﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgw_vpl;
CREATE TABLE mgw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgw_vpl WRITE;
INSERT INTO mgw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kilisitu aabelekwi mulukolo lwa Daudi, bu'ka mulukolo lwa Bulaimu. Wu'no nga nsisingwa wa lukolo lwake. ");
INSERT INTO mgw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bulaimu aampapite Isaki, Isaki aampapite Yakobi, Yakobi aampapite Yuda na alongobe. ");
INSERT INTO mgw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda aampapite Pelesi na Sela (mau' babe bai Tamali), Pelesi aampapite Esiloni, Esiloni aampapite Lamu, ");
INSERT INTO mgw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamu aampapite Aminadabu, Aminadabu aampapite Nashoni, Nashoni aampapite Salimoni, ");
INSERT INTO mgw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni aampapite Boazi (mau' bake Boazi bai Raabu) Boazi na Ruthu bai abelei ba Obedi, Obedi aampapite Yese, ");
INSERT INTO mgw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese aampapite Nkulungwa Daudi. Daudi aampapite Selemani, ywembe mau' bake baai yu'lu' ywaabile nnyumbowe Ulia, Bathsheba. ");
INSERT INTO mgw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani aampapite Leoboamu, Leoboamu aampapite Abiya, Abiya aampapite Asa, ");
INSERT INTO mgw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa aampapite Yeoshafati, Yeoshafati aampapite Yoramu, Yolamu aampapite Uzia, ");
INSERT INTO mgw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia aampapite Yotamu, Yotamu aampapite Aazi, Aazi aampapite Ezekia, ");
INSERT INTO mgw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekia aampapite Manase, Manase aampapite Amoni, Amoni aampapite Yosia, ");
INSERT INTO mgw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia aampapite Yekonia na alongobe. Awo waai nsimu wa Ayahudi pelekelwa Babeli kulwami. ");
INSERT INTO mgw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bu'ka pa Ayahudi pelekelwa kulwami Babeli, Yekonia aampapite Shealtieli, Shealtieli aampapite Zelubabeli, ");
INSERT INTO mgw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli aampapite Abihudi, Abihudi aampapite Eliakimu, Eliakimu aampapite Azoli, ");
INSERT INTO mgw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli aampapite Sadoki, Sadoki aampapite Akimu, Akimu aampapite Eliudi, ");
INSERT INTO mgw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi aampapite Eleazali, Eleazali aampapite Matani, Matani aampapite Yakobi, ");
INSERT INTO mgw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobi aampapite Yusupu, ywaabile nsengowe Malia, mau' bake Yesu ywakemelwa Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kwa nyo, yumulati ya lubelekwo lwoti bu'ka Bulaimu mpaka Daudi yai ku'mi na nsese, bu'ka Daudi mpaka lu'lu' lwami lwa Babeli yai ku'mi na nsese, bu'ka lu'lu' lwami lwa Babeli mpaka ika kwa Nkosopoli ywakemelwage Kilisitu yai ku'mi na nsese. ");
INSERT INTO mgw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Belekwa kwake Yesu Kilisitu kwaabile nnyanya. Malia mau' bake pabayi'ki'tyanie kobekana na Yusupu, lakini babile balo egelyana, Malia aabonekine abile na ndumbo kwa makakala ga Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusupu aai mundu ywabi'ngi'ya salya ya Nnu'ngu', lakini kwa mwanjaa aakani kumwisiya Malia, aabini kunneka kwa kinunu. ");
INSERT INTO mgw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lakini paawasage panga nyo, malaika wa Bwana ngampitya kwa ndi'la yo lota, ngammakia, “Yusupu wa mwana wa Daudi, kaneuyogope kunkobeka Malia, kwa mwanjaa utopelwe wabile nawo aupatike kwa makakala ga Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ywembe aapapa mwana nnalu'me, nawenga wantine lina lyake Yesu, kwa mwanjaa ngaywa aakosopolya bandu bake bu'ka mumasambi gabe.” ");
INSERT INTO mgw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ago goti gaapangike li'nga litimi li'lu' liyi'gi'yo lya Bwana kwa lilobe lya nnondoli wa Nnu'ngu' kabaya, ");
INSERT INTO mgw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Lingulya, kigoli aayi'ma ndumbo, nembe aapapa mwana nnalu'me, nabembe bantina lina lyake Emanueli,” (lina li' lilombolya, “Nnu'ngu' pamope natwenga”). ");
INSERT INTO mgw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusupu paayumwike mulugono, aapangite kati mwaalagilwe na malaika wa Bwana na ngantola Malia panga nnyumbowe. ");
INSERT INTO mgw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lakini aantangiteli nnyumbowe mpaka Malia paapapite mwana nnalu'me, ngaantina lina lyake Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu aabelekuli ku Betelehemu, kunkoa wa Yudea, nsimu wo Helode ngaywabile nkulungwa kwo. Nsimu wu'lu' wabelekwile, ajuzi ba ndondwa bu'ka kumbwani baayi'i Yelusalemu, ");
INSERT INTO mgw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ngabalaluya, “Abile kwaku' yu'lu' mwana ywabelekwile nkulungwa wa Ayahudi? Mwanjaa tulubweni lutondwa lwake patwabile kumbwani, ngatuisi kunkilikitya.” ");
INSERT INTO mgw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nkulungwa Helode na bandu boti ba Yelusalemu, pabaayu'wine makowe ga, baapatike kyukala. ");
INSERT INTO mgw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helode ngaakema api'ndo boti ba dini na balimu ba salya, li'nga bammakie Kilisitu aabelekwa kwaku'. ");
INSERT INTO mgw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nabembe ngabammakia, “Ku Betelehemu ya Yudea, kwa mwanjaa nyo ngamwaiandikilwe na nnondoli wa Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wenga wa Betelehemu munni'ma wa Yuda, wansene lili mukipi'nga sa ilambo ya Yuda, Kwa mwanjaa kasako alu'a pita nkulungwa ywaalu'a kwalongoya bandu bangu' Isilaili.’” ");
INSERT INTO mgw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bai, Helode aakemite kwa kinunu balu' ajuzi ba ndondwa, li'nga bammakie masu'ba gaku' lutondwa lu'lu' palwabonekine. ");
INSERT INTO mgw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bu'kapo, ngaatuma ku Betelehemu kaabakia, “Muyende mukapekeseni wisowiso abali ya mwana yu'lu'. Namwenga pamwamona, mwanibakiye li'nga nanenga niyende, nikankilikiti.” ");
INSERT INTO mgw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bu'ka pa kumpi'kania nkulungwa, ngababu'ka. Lu'lu' lutondwa lwabaalubweni pabaabile kumbwani, baimukya kalubonekana kai' na kwalongoya, ngaluyenda yi'ma panani ya pandu paabile mwana. ");
INSERT INTO mgw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baatinapusika muno kwa kulubona lu'lu' lutondwa kai'. ");
INSERT INTO mgw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pabaayingi nnyumba, baamweni mwana pamope na Malia mau' bake, ngabankilikitya yu'lu' mwana, no undwana igombo yabe ya samani na kumpeya zaabu, ubani na mauta ganannungya. ");
INSERT INTO mgw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bu'kapo Nnu'ngu' aatikwakwi'li'ka mumaloto panga, kanebaki'li'bu'ki kwa ndi'la ya kwa Helode. Ngabaki'li'bu'kya kunni'ma wabe kwo pi'tya ndi'la yi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Balu' ajuzi ba ndondwa pababu'i, malaika wa Nnu'ngu' ngaamwisilya Yusupu mumaloto kammakia, “Uyumuke, untole mwana na mau' bake mutile muyende Misili. Mukatame kwo mpaka panaakubakia panga uki'li'bu'ke, kwa mwanjaa Helode ampala mwana ammulage.” ");
INSERT INTO mgw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bai, Yusupu ngayumuka, kuntola mwana pamope na mau' bake ngababu'ka kilo so yenda Misili. ");
INSERT INTO mgw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aatami kwo mpaka Helode paawile, li'nga litimi liyi'gi'yo lya Bwana lyalibayilwe kwa ndi'la ya nnondoli ywa Nnu'ngu', “Nankemite mwana wangu' abuyangane bu'ka Misili.” ");
INSERT INTO mgw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode pakwipwi panga balu' atangi ba ndondwa baatikunkonga, aatiusika muno. Ngatuma bandu ku Betelehemu na kila pandu mbwega yake li'nga yenda kwabulaga bana analu'me babaabile na myaka ibi'li' au pai' yake, bu'kana na masu'ba gaabakiyilwe na balu' ajuzi. ");
INSERT INTO mgw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngaapo litimile liyi'gi'yo lyalyaabayilwe na nnondoli wa Nnu'ngu' Yelemia kabaya, ");
INSERT INTO mgw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lilobe liyu'wanika bu'ka Rama, kili'lo na malombolo gambone. Aywo Raeli kaali'lya bana bake, nembe akani kunni'yali'ya, kwa mwanjaa boti bawile. ");
INSERT INTO mgw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Paawile Helode, malaika wa Bwana ngampitya Yusupu mumaloto ku'lu' Misili, ");
INSERT INTO mgw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na kummakia, “Uyumuke, umpu'twe mwana na mau' bake uki'li'bu'ki kunni'ma wa Isilaili, kwa mwanjaa balu' babapalage kummulaga yu' mwana bawile.” ");
INSERT INTO mgw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bai, Yusupu ngakatuka na kuntola mwana na mau' bake, ngabuyangania kunni'ma wa Isilaili. ");
INSERT INTO mgw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini Yusupu paayu'wine panga Alikelao atawalage kwo Yudea pandu pa tati' bake Helode, aatiyogopa yenda kwo. Ayomwike kwi'li'ki'lwa mumaloto, ngayenda lwingo lwa Galilaya, ");
INSERT INTO mgw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ku'lu' ngatama kukilambo sa Nasaleti, li'nga gatimi gagaabayilwe na alondoli ba Nnu'ngu', “Aakemelwa mundu wa ku Nasaleti.” ");
INSERT INTO mgw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bu'ka po pi'ta myaka yambone, aapitike mundu ywakemelwage Yoani Ywabatisage kaala kulubele lwa ku Yudea kabaya, ");
INSERT INTO mgw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mugalambuke bu'ka mumasambi ginu, kwa mwanjaa Ukulungwa wa Kunani wegelile.” ");
INSERT INTO mgw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ayu' Yoani nga yu'lu' ywabayilwe na Nnu'ngu' kwa ndi'la ya nnondoli wake Isaya, paabaite, “Lilobe lya mundu likema kulubele, ‘Mumpetuli Bwana ndi'la yake, mugolwe simbasimba yake.’” ");
INSERT INTO mgw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoani abile aweti ngu'bo yaitengenesilwe na matuputupu ga ngamia, na mukibuno sake lunga lwa liki'ngo, no lya kwake kwaai njige na busi wa mmwitu. ");
INSERT INTO mgw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ngabannyendelya bandu ba ku Yelusalemu, Yudea yoti na mili'ma yoti yaiti'li'ta mbwega ya libi'ndi' lya Yordani, ");
INSERT INTO mgw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","kabammakia masambi gabe, nembe Yoani ngaabatisa mulibi'ndi' lya Yordani. ");
INSERT INTO mgw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoani paabweni bandu bu'ka muipi'nga ya Mafalisayo na Masadukayo kabaisa li'nga babatisilwe, ngaabakia, “Mwenga mwa kinng'ambo! Nyai ywankwi'li'ke mwenga kuitila nyongo ya Nnu'ngu' yailu'a isa? ");
INSERT INTO mgw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bai, mulaye kwa itendo panga mugalambwike kwa kugaleka masambi ginu. ");
INSERT INTO mgw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kanemwipune kwo wasa panga, ‘Nnu'ngu' alu'a tuyi'ki'tya kwa mwanjaa twenga twabana ba Bulaimu.’ Nimmakianga, Nnu'ngu' awesa kugagalambwa ata maliwe ga yu'ka bana ba Bulaimu. ");
INSERT INTO mgw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Libago libi'kilwe wiso pa liina lya nkongo li'nga kuupi'ngwana kila nkongo waukotoka pambika matunda ganannoga na kuutaikulya pamwoto. ");
INSERT INTO mgw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga nimmatisanga kwa masi' li'nga itanganikwe panga mugalambwike kwa kwileka sambi. Lakini ywaalu'a isa nsu'gu' yangu' alu'a kummatisanga kwa Loo Mpeleteu na kwa mwoto. Ywembe abile na makakala pi'ta nenga, ata ilatu yake nipwaikali pu'twa. ");
INSERT INTO mgw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ywembe akamwa kyelo sake so pepekea ngano, alu'a kwiuna na kwibi'ka paligu'lu', lakini mayu'ngu'lu'lu' alu'a kugatiniya pamwoto wangaimika.” ");
INSERT INTO mgw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nsimu wo, Yesu aabu'i Galilaya no ika kulibi'ndi' lya Yordani kannyendelya Yoani Ywabatisage, li'nga abatisilwe. ");
INSERT INTO mgw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yoani aapayite kunkania Yesu na kummakia, “Nenga nganipalikwa batisilwa na wenga, wenga uniisilya nenga kai'?” ");
INSERT INTO mgw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu ngannyangwa, “Uyi'ki'ti panga nambi'yambi', kwa mwanjaa ngamwaipalikwa timisa salya yoti ya Nnu'ngu'.” Bai Yoani ngayi'ki'tya. ");
INSERT INTO mgw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu paayomwi batisilwa no pita nkati ya masi', ngaimukya kunani kuyu'gwi'kya, ngammona Loo Mpeleteu wa Nnu'ngu' kauluka kwa ubee wa ngunda no tama panani yake. ");
INSERT INTO mgw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lilobe lyayu'wanike bu'ka kunani kalibaya, “Ayu' nga mwana wangu' ywanimpendile, ninogelilwe nakwe.” ");
INSERT INTO mgw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bu'kapo, Yesu ngalongoyelwa na Loo Mpeleteu mpaka kulubele li'nga apayilwe na Ibilisi. ");
INSERT INTO mgw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu paayomwi punga lya kwa masu'ba alubaini kilo na muntwekati, ngaimminya njala. ");
INSERT INTO mgw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ibilisi ngamwisilya na kummakia, “Manaitei wenga wa Mwana wa Nnu'ngu', ugaamulise maliwe ga li'nga gabe makati.” ");
INSERT INTO mgw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu ngannyangwa, “Iandikilwe nyinyo, ‘Mundu akombwali lama kwa likati bai, ila kwa kila liyi'gi'yo lyaliuma munkano wa Nnu'ngu'.’” ");
INSERT INTO mgw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bu'kapo, Ibilisi ngampu'twa mpaka pansengo mpeleteu wa Yelusalemu na kunnyi'mi'ka pandu patu'ndu'bau munyumba ya Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na kummakia, “Manaitei wenga wa mwana wa Nnu'ngu', witaikuli pai', kwa mwanjaa iandikilwe, ‘Nnu'ngu' aakulagya malaika bake, baakupu'twa mumaboko gabe, li'nga magu'lu' gako gaakanekunywa pa liwe.’” ");
INSERT INTO mgw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ngammakia, “Kai' iandikilwe, ‘Kaneumpaye Bwana Nnu'ngu' wako.’” ");
INSERT INTO mgw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bu'kapo, Ibilisi ngampeleka pakitu'mbi' kilaso na kunnaya kulungwa yoti ya padunia na uku'lu' wake, ");
INSERT INTO mgw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ngammakia, “Nilu'a kupeya yi'no yoti mana unikilikitile na kuniyinamya.” ");
INSERT INTO mgw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Lakini Yesu ngammakia, “Bu'kya kwo wenga wa Ibilisi, kwa mwanjaa iandikilwe, ‘Unkilikiti Bwana Nnu'ngu' wako, na untumikiye ywembe kisake bai.’” ");
INSERT INTO mgw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bai, Ibilisi nganneka, malaika ngabaisa kunnyangatia. ");
INSERT INTO mgw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bai, Yesu paayu'wine panga Yoani abile muutabilwe, ngayenda mpaka Galilaya. ");
INSERT INTO mgw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ywembe aabu'i Nasaleti no yenda tama Kapernaumu, nsengo waubile mbwega ya litanda lya Galilaya, muilambo ya Zebuluni na Nafutali, ");
INSERT INTO mgw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","li'nga gatimi mayi'gi'yo gagaalongelikwe na Nnu'ngu' kwo pi'tya nnondoli wa Nnu'ngu' Isaya, ");
INSERT INTO mgw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nni'ma wa Zebuluni na nni'ma wa Nafutali, li'nga kubaali kwiyi' ya libi'ndi' lya Yordani, Galilaya, nni'ma wa bandu bangali Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bandu bo babatama mulubi'ndu', Baubweni bweya nku'lu', Babatama mukiwili sa kiwo, Bamulikilwe na mwaana wa kindai.” ");
INSERT INTO mgw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bu'ka masu'ba go, Yesu aatumbwi aala no baya, “Muileke sambi na munng'alambuki Nnu'ngu', kwa mwanjaa Ukulungwa wa Kunani wegelile!” ");
INSERT INTO mgw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu paabile katyanga mbwega ya litanda lya Galilaya, aabweni alobi ba abi'li'. Bandu bo baai Simoni ywakemelwage Petili, na nnunawe Andelea, aakoli kabaulukia mbi'li'li' mulitanda. ");
INSERT INTO mgw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ngaabakia, “Munibi'ngi'ye, nipala mupange mwa alobi ba bandu.” ");
INSERT INTO mgw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Popopo, ngabaileka mbi'li'li' yabe na kummi'ngi'ya. ");
INSERT INTO mgw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Payendeli nnu'ngi' ngaakolya kai' Yakobi na nnunawe Yoani, batami mungalaba na tati' babe Zebedayo kabatendekeya mbi'li'li' yabe. Yesu ngaakema, ");
INSERT INTO mgw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nabembe popopo ngabaaleka tati' babe na ngalaba, na kummi'ngi'ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu aabile kapi'ta pano na palu' ku ilambo ya Galilaya, kaala no yi'gana abali inannoga ya Ukulungwa wa Nnu'ngu' mumayumba gabe ga kunnu'ba Nnu'ngu' no aatepwi atamwe boti. ");
INSERT INTO mgw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Abali yake yaayu'wanike munni'ma woti wa Shamu. Ngabannetya bandu boti babatesilwe na matamwe mbali'mbali', na bene moka, kyundaunda no tomboloka payi'ga, nembe Yesu ngaatepwa. ");
INSERT INTO mgw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ipi'nga ya bandu yendekumi'ngi'ya bu'ka Galilaya, Dekapoli, Yelusalemu, Yudea no bu'ka kwiyi' ya libi'ndi' lya Yordani. ");
INSERT INTO mgw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu paibweni ipi'nga ya bandu, aau'bwike pakitu'mbi' no tama pai', na banamasi' bake ngabamwisilya. ");
INSERT INTO mgw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nembe ngatumbwa kwayi'gana kabaya, ");
INSERT INTO mgw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nantali bababile aki'ba ba loo, kwa mwanjaa Ukulungwa wa Kunani wabe. ");
INSERT INTO mgw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nantali babanyopa, kwa mwanjaa Nnu'ngu' alu'a kwapembeya. ");
INSERT INTO mgw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nantali babaliyaa, kwa mwanjaa baalu'a kuilisi dunia yoti. ");
INSERT INTO mgw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nantali bene njala na nnyota yo panga gapala Nnu'ngu', kwa mwanjaa baalu'a yukutiyilwa. ");
INSERT INTO mgw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nantali bababile na kiya, kwa mwanjaa baabi'ki'lwa kiya. ");
INSERT INTO mgw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nantali anoga mwoyo, kwa mwanjaa baalu'a kummona Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nantali ya balu' babaleta amani, kwa mwanjaa baakemelwa bana ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nantali babateselwa kitumbu so panga mwapala Nnu'ngu', kwa mwanjaa Ukulungwa wa Kunani wabe. ");
INSERT INTO mgw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nantali yinu mwenga bandu pabaalu'a kuntukana, kunku'su'mbwa na kunku'pi'ki'a malau goti kwa kitumbu sangu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Munapusike no luluta, kwa mwanjaa mubi'kilwe upo yinu ngu'lu' kunani. Nnyo, ngamwabaatesike alondoli ba masu'ba ga nsu'gu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwenga nga kati mwinyo kwa bandu boti, lakini mwinyo mana wobiye kilyi'lyi' sake, ulu'a kuuyi'ya namani uki'li'bu'ye kilyi'lyi' sake? Upwaikali ata pasene, waigala taikulwa kuundi no li'batilwa na bandu. ");
INSERT INTO mgw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwenga nga mwabweya wa padunia. Nsengo wausengilwe pakitu'mbi' wiyanikwa lili. ");
INSERT INTO mgw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wala ntu'pu' mundu ywakoya kimuli na kukiwi'ki'lya mukitu'ndu', ila, aakibi'ka patu'ndu'bau li'nga kipiye bweya kwa bandu boti bababile nnyumba. ");
INSERT INTO mgw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nyinyonyo namwenga, bweya winu upalikwa umulike kwa bandu li'nga bagabone manogau gamugapanga, nabembe baalumbe Tati' binu bababile kunani. ");
INSERT INTO mgw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kanemuwase panga niisi bu'ya salya ya Musa na mayi'gano ga alondoli ba Nnu'ngu'. Nenga naisali bu'ya, ila niisi timilisa. ");
INSERT INTO mgw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kwa mwanjaa nimmakianga kakape, mpaka kunani na pai' payayomoka, ntu'pu' ata pandu pasene mu salya papa alu'a bu'yi'lwa mpaka goti gatimi. ");
INSERT INTO mgw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bai, mundu ywaalu'a ti'kwana yimo muamuli njene yi' na kwayi'gana bandu, aywo aapanga nsene muno muukulungwa wa Kunani. Lakini mundu ywaalu'a kwikamwa na kwayi'gana bi'ngi', aywo aakemelwa nku'lu' muukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bai nimmakianga, aki yinu mana ikotwike pi'ta yi'lu' ya balimu ba salya na Mafalisayo, mwauyingyali Ukulungwa wa Kunani. ");
INSERT INTO mgw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muyu'wine mwabaabakiyilwe au'ku' bitu kwai'mbu' panga, ‘Kaneubulage, mundu ywaabulaga aukumilwa.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini nenga nimmakianga, mundu ywoywoti ywamusikya nnongowe apalikwa ukumilwa. Mundu mana kantukana nnongowe apalikwa ukumilwa kubalasa, na mana kammakia nnongowe ‘Wenga wa nnogeloge', apalikwa yingya mumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bai, mana kauyenda pandu papeleteu piya salaka kwa Nnu'ngu', pauku'mbu'kya panga uyu'mine na nnongogo, ");
INSERT INTO mgw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wileke salaka yako, ukaawane na nnongogo, bu'kapo ukapiye salaka yako. ");
INSERT INTO mgw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Uyomwane na nsitaki wako kiyu'ngu'ya mubile balo mundi'la kamuyenda kumwalo. Mana nyoli, aakuikiya kwa akimu, nembe aakukamukia kwa asikali na kukuyingiya muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kakape nikubakia, waapitali mo mpaka uyomwe li'pa lwela lwa kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muyu'wine panga ibayilwe ‘Kaneupange ugoni.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini nenga nikubakia panga, mundu ywoywoti ywanningulya nnwawa kwa kumminyikia, ayomwike gonja nakwe nkati ya mwoyo wake. ");
INSERT INTO mgw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Manaitei liyo lyako lya kummalyo likupanga upange sambi, uliyokwe na kulitaikulya kuutalu. Nantali obeya kikowe simo mu yi'ga yako, kulikoni yi'ga yako yoti taikulilwa kumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kai', nyinyonyo na luboko lwako lwa kummalyo, mana kalukupeleka musambi, ulukate na kulutaikulya kuutalu. Kwa mwanjaa nantali obeya kikowe simo muyi'ga yako kulikoni yi'ga yako yoti taikulilwa ku mwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kai', yaabayilwe panga, ‘Mundu mana kanneka nnyumbowe ampei talaka.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini nenga nimmakianga panga, ntu'pu' mundu ywayi'ki'ti'lwa kunneka nnyumbowe ila kwa kitumbu sa ugoni. Kai', ampanga nnwawa ywo abe nng'oni mana aaku'ndike kwa nnalu'me ywi'ngi'. Na mundu ywakobeka nnwawa ywalekilwe apanga ugoni. ");
INSERT INTO mgw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Muyu'wine kai' au'ku' binu baabayilwe panga, ‘Kaneuti'kwane kilapo sawannapi Bwana, lakini utimise ndapo yako.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini nenga nimmakianga, kanemulape ata pasene, kwa lina lya kunani, kwa mwanjaa nga kiti'gu' sa lenji sa Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala kwa dunia, kwa mwanjaa nga kiti'gu' sake so bi'kya magu'lu', wala kwa Yelusalemu kwa mwanjaa nga nsengo wa Nkulungwa nku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala mundu kaneulape kwa ntwe wako, kwa mwanjaa uwesali ata kulugalambwa lunywili lwako lumo panga luu au lupili. ");
INSERT INTO mgw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ila pamulongela, mupalikwa longela kakape. ‘Elo,’ yinu ipange kakape ‘Elo’, na ‘Lili’ ipange kakape ‘Lili’. Sakiyongeya po kibu'ka kwa yu'lu' nnau Ibilisi. ");
INSERT INTO mgw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muyu'wine panga ibayilwe, ‘Liyo kwa liyo, na lino kwa lino.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini nenga nimmakianga kanemubukiye, maakau kwa maakau. Mana mundu akuku'mbwi mbande muligomo lya mmalyo, unng'alambukiye na ligomo lya nki'ya. ");
INSERT INTO mgw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu mana kakusitakya kwa kukutolya kiyampani sako, wanneki na likoti lyako kai'. ");
INSERT INTO mgw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu mana akulasimise pu'twa kigombo ulipau wa kilometa yimo, ukipu'twe kigombo so ata kwa kilometa ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mundu mana kakulu'ba kili'be umpei, ywapala nngu'ta kaneunnyime. ");
INSERT INTO mgw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muyu'wine panga ibayilwe, ‘Umpende ywa papipi yako, na unsukwe ndumu wako.’ ");
INSERT INTO mgw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini nenga nimmakianga panga mwapende andumu binu na kwalu'bya babantesa. ");
INSERT INTO mgw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mupange nyo li'nga mupate panga kakape mwabana ba Tati' binu ba kunani. Bembe babawali, kwa mwanjaa aapea lumu na ula anogau na alau. ");
INSERT INTO mgw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mana kamwapenda balu' babampenda mwenga bai, mupata upo yaku' kwa Nnu'ngu'? Ata alonga koli bapanga nyinyo. ");
INSERT INTO mgw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mana kamwapanga abali alongo binu bai, mupanga namani sakwapi'ta bi'ngi'? Ata bandu bangau'bi'lya bapanga kati go! ");
INSERT INTO mgw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kwa nyo, mupange mwatimya, kati mu'lu' Tati' binu ba kunani mwababile atimya.” ");
INSERT INTO mgw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwili'ndi'le, mwakanepanga makowe ginu manogau li'nga mubonekane na bandu, kwa mwanjaa pamwapanga nyo mwaapatali upo bu'ka kwa Tati' binu bababile kunani. ");
INSERT INTO mgw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Bai, mana kaumpeya kili'be nki'ba, kaneunwaye kati mwabapanga anapiki mumayumba ga kunnu'ba Nnu'ngu' na musimbasimba li'nga balumbilwe na bandu. Nimmakianga kakape panga bayomwile pata upo yabe. ");
INSERT INTO mgw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini wenga ponnyangatia nki'ba, ata luboko lwako lwa nki'ya kanelutange salupanga luboko lwa malyo, ");
INSERT INTO mgw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","li'nga salaka yako ipange ya kinunu. Nabembe Tati' bako bababile kunani babalinga saupanga kwa kinunu, baakutwi'li'ki'a. ");
INSERT INTO mgw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kai', pamusalya kanemupange kati anapiki, kwa mwanjaa bapenda yi'ma no saalya mumayumba ga kunnu'ba Nnu'ngu', na mbwega ya simbasimba, li'nga babonekane na bandu. Nimmakianga panga bayomwile pata upo yabe. ");
INSERT INTO mgw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini wenga pausali, uyingi kungati yako no yigala nniango ulu'be kwa Tati' bako bababile pa kinunu. Na Tati' bako babakubona saupanga kwa kinunu balu'a kupeya upo yako. ");
INSERT INTO mgw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kai', pamulu'ba, kanemupange kati bandu bangantanga Nnu'ngu', kwa mwanjaa batumya mayi'gi'yo gambone gangali maana kabawasa panga Nnu'ngu' alu'a kwayu'wa kwo yoloka mayi'gi'yo gabe. ");
INSERT INTO mgw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bai, kanemulandane na abo, kwa mwanjaa Tati' binu baagatangite gamupala mubile balo munalu'bali. ");
INSERT INTO mgw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bai, mupalikwa salya kati nya, Tati' bitu ba kunani, Lina linu likwi'yi'lwe. ");
INSERT INTO mgw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ukulungwa winu wise, Lyamupala lipangike, padunia kati kunani. ");
INSERT INTO mgw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mutupei li'no kilyo situ sa kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mutusami makosa gitu, kati twenga mwatwaasamya babatukosile. ");
INSERT INTO mgw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kanemutuyingiye mumapayilwo, lakini mutukosopoli na yu'lu' nnau, Ibilisi. ");
INSERT INTO mgw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwa mwanjaa mana mwasamile bandu makosa gabe, Tati' binu ba kunani baalu'a kunsamya mwenga nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini mana mukani kwasamya bi'ngi' makosa gabe, Tati' binu ba kunani bansamyali makosa ginu. ");
INSERT INTO mgw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kai', pamupunga, kanemupange kati anapiki, babakekenala kuminyo kati babile mumaku'ku'li'ko, li'nga bandu baatange panga bendapunga. Nimmakianga kakape panga bayomwile pata upo yabe. ");
INSERT INTO mgw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini wenga paupunga, uuluge masi' kuminyo no pakala mauta munywili yako, ");
INSERT INTO mgw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","li'nga bandu kanebakutange panga wendapunga. Likowe lyo litanganikwe na Tati' bako bababile pa kinunu. Na Tati' bako babakubona saupanga kwa kinunu balu'a kupeya upo yako. ");
INSERT INTO mgw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kanemwibi'ki mabi'ko pano padunia, pandu pene ngu'lu'ku'lu' na ngugu kwialabiya, na baii bomwa nyumba li'nga yiba. ");
INSERT INTO mgw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mwibi'ki mabi'ko ginu kunani kwembe ntu'pu' ngu'lu'ku'lu', ngugu ata baii bati'kwanali no yiba. ");
INSERT INTO mgw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwa mwanjaa pagabile mabi'ko gako, nga pawaalu'a ba na mwoyo wako. ");
INSERT INTO mgw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Liyo nga kimuli sa yi'ga. Manaitei minyo gako makoti, yi'ga yako yoti yabaa mubweya. ");
INSERT INTO mgw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini manaitei minyo gako gaina utamwe, yi'ga yako yoti yabaa mulubi'ndu'. Bai, manaitei bweya waubile nkati yako ugalambwike panga lubi'ndu', lubi'ndu' lwo lwapanga totolo. ");
INSERT INTO mgw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ntu'pu' mundu ywakombwa tumika kwa akulungwa abi'li', kwa mwanjaa aansukwa yu' na kumpenda yu'lu', au alu'a lu'mbana na yumo na kunsalawa ywi'ngi'. Mukombwali kuntumikia Nnu'ngu' pamope na mali. ");
INSERT INTO mgw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kwa nyo nimmakianga panga, kanemuauke mubwu'mi winu bu'kana na kilyo, au kinywo, wala payi'ga yinu muwale ki'li'. Kwa mwanjaa bwu'mi nga wangama kulikoni kilyo, na yi'ga yangama kulikoni mawalo. ");
INSERT INTO mgw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwalinge iyuni ba mmwitu, bapandali, baunali wala ligu'lu' ntu'pu' kwabe, lakini Tati' binu ba kunani bendakwayukutiya. Buli, nengite mwenga mwa bampu'ku'bi'la kulikoni iyuni? ");
INSERT INTO mgw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyai mukipi'nga sinu kwa kwiauya kwake muno awesa kwiyongeya lisu'ba limo lya bwu'mi wake? ");
INSERT INTO mgw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwa kitumbu saku' mwiauya kwa mawalo? Mugalinge malu'ba mwagalembulya, gapangali kibalua, wala kwisonia ngu'bo. ");
INSERT INTO mgw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nanenga nimmakianga panga ata Nkulungwa Selemani, muutayili wake woti waabile nawo, aawetili ngu'bo inannoga yaipi'ta ata lilu'ba limo. ");
INSERT INTO mgw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bai, manaitei Nnu'ngu' agawalika nya maakapi ga mmi'ndi' gagaboneka li'no na malau' gayu'mi no sonjelwa mwoto, buli, aakotoka kunng'walika wisowiso, mwenga mwabene imani njene? ");
INSERT INTO mgw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bai, kanemube na kyukala panga, ‘Tulu'a lya ki'li', nywa ki'li', no wala namani?’ ");
INSERT INTO mgw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bandu bangantanga Nnu'ngu' nga babaangaikya ikowe yo, lakini Tati' binu ba kunani batangite panga mupala ago goti. ");
INSERT INTO mgw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakini mwenga muupale wi'ti' Ukulungwa wa Nnu'ngu' no koleya mu'lu' mwapala, nembe alu'a kunnyongea gamugapala goti. ");
INSERT INTO mgw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwa nyo, kanemube na kyukala bu'kana na makowe ga malau', kwa mwanjaa makowe ga malau' gaiaukilya gene. Mbalanga ya lisu'ba limo ili'ngani kwa lisu'ba lyo.” ");
INSERT INTO mgw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kanemwaukumu bandu bi'ngi', li'nga Nnu'ngu' aakane kumuukumu mwenga. ");
INSERT INTO mgw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwa mwanjaa mwenga mwaukumilwa kati mwamwaaukumu ainu, na kili'ngo soso samwali'ngya ainu na Nnu'ngu' nga saatumya kunni'ngya mwenga. ");
INSERT INTO mgw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mwanjaa namani ukibona kielenje sakibile muliyo lya nnongogo, lakini ulubonali lubago lwalubile muliyo lyako? ");
INSERT INTO mgw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Au ukombwabuli kummakia nnongogo, ‘Baliya nikubu'ye kielenje muliyo,’ naapo kubile na lubago muliyo lyako wamwene? ");
INSERT INTO mgw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wenga wa nnapiki, ubu'ye wi'ti' lubago lwalubile nkati ya liyo lyako, bu'kapo uwesa kulubona wiso lwelenje lwalubile muliyo lya nnongogo. ");
INSERT INTO mgw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kanemwapei mbwa ikowe mbeletau, li'nga baakane galambuka na kumpoteka. Wala kanemwataikuli magu'be ili'be ya samani ngu'lu'. Mana mwapanga nnya, baaili'bata. ");
INSERT INTO mgw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mulu'be, namwenga mwapeyelwa, mupale namwenga mwapata, mupange u'li, namwenga mwayu'gu'li'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwa mwanjaa kila mundu ywalu'ba endapeyelwa, na ywapala endapata, na ywapanga u'li endayu'gu'li'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nyai mukipi'nga sinu ywawesa kumpeya mwana wake liwe mana kannu'ba likati? ");
INSERT INTO mgw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au nyai ywawesa kumpeya nng'ambo mana kannu'ba omba? ");
INSERT INTO mgw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Manaitei mwenga mwalau mumanyi kwapeya bana binu ikowe inannoga, nengite Tati' binu ba kunani nga munomuno kwapeya ili'be inannoga babannu'ba. ");
INSERT INTO mgw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kwa nyo, sosoti samupala mupangilwe na bandu, namwenga mwapangi ainu nyinyonyo. Aga nga malombolyo ga salya ya Musa na maandiko ga alondoli ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Muyingi kwo pi'tya nniango wo patimwa. Kwa mwanjaa nniango na ndi'la yaibile ngu'lu' ili'nga kuulanganyiki, na babayingya mo nga bambone. ");
INSERT INTO mgw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lakini nniango na ndi'la yaili'nga kuukoto nga yo patimwa. Bandu bamboneli bakombwa kwipwa ndi'la yo. ");
INSERT INTO mgw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwili'ndi'le na alondoli ba ubu'su'. Bembe bamwisilya kwo tu'lya kati ngondolo, lakini nkati ya myoyo yabe ibile kati pu'mbe akali'. ");
INSERT INTO mgw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mwalu'a kwatanga kwa makowe gabagapanga. Buli, bandu bawesa tu'mbwa itunda inannoga mumikongo ya mimimwa? ");
INSERT INTO mgw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nyinyonyo, nkongo nnogau upambika itunda inannoga, na nkongo unannyata, upambika itunda inannyata. ");
INSERT INTO mgw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongo unannoga upambikali itunda inannyata, wala nkongo unanyata upambika itunda inannoga. ");
INSERT INTO mgw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongo waukotoka pambika itunda inannoga wendapi'ngu'lwa no taikulilwa palitu'ta lya mwoto. ");
INSERT INTO mgw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nyinyonyo, mwalu'a kwatanga alondoli ba ubu'su' bu'kana na makowe gabe gabagapanga. ");
INSERT INTO mgw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kwenda kila mundu ywanikema, ‘Bwana, Bwana’, aayingya muukulungwa wa kunani, ila yu'lu' ywapanga gabagapendi Tati' bangu' ba kunani. ");
INSERT INTO mgw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lisu'ba li'lu' lya ukumu, baingi baanibakia, ‘Bwana, Bwana! Kwa lina lyako twaalike liyi'gi'yo lyako, bi'nga moka no panga mangelongelo maingi?’ ");
INSERT INTO mgw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nenga naalu'a kummakianga mpu'la, ‘Nintangiteli mwenga katu. Mubu'ke nnu'ngi' yangu' mwenga mwapanga malau.’ ");
INSERT INTO mgw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bai, kila mundu ywagapi'kania mayi'gi'yo gangu' na kugakamwa alandana na mundu mwene malango, ywasengite liku'ta lyake panani ya liwe lya mpi'mbi'. ");
INSERT INTO mgw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ula ngania na mabi'ndi' twi'lya masi', na kimbu'nga ngakiipukatya nyumba yo, lakini yaayilwikeli kwa mwanjaa yaasengilwe muliwe lya mpi'mbi'. ");
INSERT INTO mgw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lakini kila mundu ywagayu'wa mayi'gi'yo ganigalongela wangali kugakamwa, aywo alandana na mundu nnogeloge ywasengite nyumba yake pakyangi, ");
INSERT INTO mgw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ula paanile na mabi'ndi' twi'lya masi', mbu'nga ngaipukatya kwiku'mbwa nyumba yo, nayembe ngaiyiluka no sengwanika yoti.” ");
INSERT INTO mgw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu payomwi longela makowe go, ipi'nga ya bandu yaatisangala muno bu'kana na mu'lu' mwaayi'ganiye, ");
INSERT INTO mgw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwa mwanjaa mayi'gano gake gaai ga kitawala, kwenda kati mwabayi'gana balimu ba salya lili. ");
INSERT INTO mgw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu paeli bu'ka kukitu'mbi', ipi'nga yambone ya bandu yaatikummi'ngi'ya. ");
INSERT INTO mgw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mundu yumo mwene matana ngaisa kilikita nnu'ngi' yake kammakia, “Bwana, mana upendile, unipeleteye.” ");
INSERT INTO mgw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nga goloya luboko lwake na kunkunywa mundu yu'lu', kummakia, “Mbala, upeleteke.” Yu'lu' mundu aimukya matana gake gapeletike. ");
INSERT INTO mgw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bu'kapo, Yesu ngammakia, “Ulibi'ke pamwoyo wako likowe li', kaneummakie mundu. Lakini uyende kwa mpi'ndo ywa dini ukannaye mwaubile nambi'yambi'. Bu'kapo, upiye salaka kati mwaamulise Musa, li'nga ipange ukong'ondeli kwa bandu boti panga upeleteyilwe.” ");
INSERT INTO mgw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu paabile kayingya pakilambo sa Kapernaumu, mpi'ndo yumo ywa asikali ba Roma aatikunnyendelya na kunnu'ba, ");
INSERT INTO mgw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ntumisi wangu' endatetelya, aminya utamwe wo tomboloka.” ");
INSERT INTO mgw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ngammakia, “Nilu'a isa nintepwe.” ");
INSERT INTO mgw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ila yu'lu' mpi'ndo ywa asikali ngannyangwa, “Bwana, nenga nipwaikali kukupokya wenga nnyumba yangu'. Lakini kwa amuli yako bai, ntumisi wangu' alu'a yu'yu'ki'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwa mwanjaa ata nenga na mundu ywanibile pai' ya utawala wa alongosi, kai' nibile na asikali bababile pai' yangu'. Na mana nimmakie yumo, ‘Yenda!’, nembe endayenda. Mana nimmakie ywi'ngi', ‘Wise!’, nembe endaisa. Na mana nimmakie ntumisi wangu', ‘Panga mono’, nembe apanga mwanimmakie.” ");
INSERT INTO mgw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu pagayu'wine mayi'gi'yo go, aatisangala na kwabakia bandu babaabile kabammi'ngi'ya, “Kakape nendakummakianga, munni'ma woti wa Isilaili, nammonali mundu mwene imani ngu'lu' kati yu'. ");
INSERT INTO mgw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nimmakianga panga baaisa bandu bambone bu'ka kumbwani na kundondi, nabembe baatama pakitamo simo na Bulaimu, Isaki na Yakobi pakalamu ya Ukulungwa wa Kunani. ");
INSERT INTO mgw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini Baisilaili baingi babaapalikwe baa muukulungwa wo bataikulilwa panja kulubi'ndu', na akwo balu'a li'la no yaga mino.” ");
INSERT INTO mgw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bu'kapo, Yesu ngammakia yu'lu' mpi'ndo ywa asikali, “Ubuyangani kasako, na ipangike kati mwauu'bi'lile.” Na ntumisi wake ngayu'yu'ki'lwa saa yi'yi'lu'yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu payingi munyumba ya Petili, aakwembite mau' mukwe ba Petili bagonjike pakindanda kabaminya oma. ");
INSERT INTO mgw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bai, Yesu ngankunywa na luboko lwake, ngayu'yu'ki'lwa. Abo mau' ngabayi'ma no tumbwa kuntumikia. ");
INSERT INTO mgw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na payabile kakupilya, bandu baingi babaabile na moka ngabaletelwa kwa Yesu. Yesu ngaabi'nga balu' moka, kaamulisa kwa mayi'gi'yo gake bai, na kwatepwa atamwe boti. ");
INSERT INTO mgw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aapangite nyo li'nga gatimi mayi'gi'yo gagalongelilwe na nnondoli Isaya, “Ywembe aapu'twi ukigopi witu, no pu'twa kigombo sa matamwe gitu.” ");
INSERT INTO mgw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paabweni bandu bambone kabanti'li'ta, ngaamulisa banamasi' bake baloki liyi' li'ngi' lya litanda. ");
INSERT INTO mgw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mwalimu yumo ywa salya ngannyendelya na kummakia, “Mwalimu, nenga nilu'a kubi'ngi'ya kwokwoti kwalu'a yenda.” ");
INSERT INTO mgw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu ngannyangwa, “Ibweya babile na mapango gabe go tama na iyuni babile na iyumba yabe, lakini Mwana wa Mundu aoba na pobi'ka lubau lwake.” ");
INSERT INTO mgw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na mundu ywi'ngi' mukipi'nga sa banamasi' bake ngammakia, “Bwana, uniyi'ki'ti'ye wi'ti' nikasike tati' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu ngannyangwa, “Unibi'ngi'ye, waleke babawile basikane bene na bene.” ");
INSERT INTO mgw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nembe Yesu ngayingya mungalaba, banamasi' bake ngabammi'ngi'ya no longwana nakwe. ");
INSERT INTO mgw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lolekeya, baimukya mabi'mbi' mubaali kagapukatya no tumbwa kwiwi'ki'lya ngalaba yoti. Apo, yai Yesu agonjike lugono. ");
INSERT INTO mgw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Banamasi' bake ngabamwegelya na kunnyumuya kabammakia, “Bwana, twendawaa! Utukosopoli!” ");
INSERT INTO mgw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu ngaabakia, “Mwanjaa namani muyogopa mwenga mwabene imani njene?” Bu'kapo, ngayi'ma na kuukalipya wu'lu' nsunga na mapi'lu', ngakubaa liki muno. ");
INSERT INTO mgw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Balu' bandu baatisangala kababaya, “Ayu' mundu, mundu gani? Ata nsunga wa mubaali wendakunnyu'wa!” ");
INSERT INTO mgw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nembe Yesu paikite kwiyi' ya litanda kunni'ma wa Agelasi, aakwembine na bandu abi'li' babaatwi'li'yilwe na moka kababu'ka kumasiko. Babile akali' muno, ata bandu baakombwili pi'ta ndi'la yo. ");
INSERT INTO mgw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nabembe ngabatumbwa kemelya kababaya, “Ubile na makowe gani na twenga, wenga wa Mwana wa Nnu'ngu'? Wisi pano kutuku'su'mbwa pangali timya nsimu watubi'kilwe?” ");
INSERT INTO mgw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Papipi na pandu po, paabile na kipi'nga kiku'lu' sa magu'be kabali'lya. ");
INSERT INTO mgw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Balu' moka ngabampembelelya Yesu kabammakia, “Mana kautubi'nga, utuyi'ki'ti'ye tuyende tukayingi mukipi'nga si'lu' sa magu'be.” ");
INSERT INTO mgw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ngaabakia, “Muyende!” Ngababu'ka na kwayingya balu' magu'be, na kipi'nga soti ngakibutuka kakielya mungeleuko, mpaka mulitanda, ngabawaa. ");
INSERT INTO mgw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Balu' bandu babasungage magu'be ngababutuka yenda kumisengo no yaulya goti gagapangike, na galu' gagaapiti balu' bandu abi'li' babaatwi'li moka. ");
INSERT INTO mgw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bu'kapo, bandu boti ba misengo yo ngabayenda kwembana na Yesu. Nabembe pabaamweni, ngabannu'ba abu'ke mumisengo yabe. ");
INSERT INTO mgw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu aau'bwike mungalaba, ngaloka litanda liku'lu', ngaika kukilambo sake. ");
INSERT INTO mgw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na ku'lu', banneti mundu mwene utamwe wo tomboloka, aabi agonjike pakindanda. Yesu paabweni balu' bandu mwabaamwu'bi'lile, ngammakia yu'lu' ywatombolwike, “Mwana wangu', uku'le mwoyo, masambi gako gasamilwe.” ");
INSERT INTO mgw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kwa kitumbu sa likowe lyo, bi'ngi' ba balimu ba salya, ngabawasa mumyoyo yabe, “Mundu yu' ankupulu Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lakini Yesu abile agatangite gabagania, ngaalaluya, “Mwanjaa namani mugania makowe malau mumyoyo yinu? ");
INSERT INTO mgw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Buli, kikowe saku' sakibile kiyu'yu'u kukibaya, ‘Masambi gako gasamilwe’ au baya, ‘Uyi'me, uyende’? ");
INSERT INTO mgw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bai, mbala mutange panga Mwana wa Mundu abile na amuli yo samya sambi pano padunia.” Kwa nyo ngammakia yu'lu' mundu ywaatombolwike, “Uyi'me, witwi'ke kindanda sako, uyende kasako.” ");
INSERT INTO mgw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yu'lu' mundu ngayi'ma no yenda kasake. ");
INSERT INTO mgw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bandu boti babaabile pakipi'nga so pabagabweni go, baatiyogopa muno. Ngabannumba Nnu'ngu' ywaapei bandu uweso wa kubi nnya. ");
INSERT INTO mgw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu paabile kapi'ta bu'ka kwo, aamweni mundu ywakemelwa Matei atami munyumba yo li'pya koli. Yesu ngammakia, “Unibi'ngi'ye.” Matei ngakatuka na kummi'ngi'ya. ");
INSERT INTO mgw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu paabile kalya kilyo munyumba ya Matei, baaisi alonga koli na bene sambi. Abo baatami lya nakwe pamope na banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo pabagabweni makowe go, ngabaalaluya banamasi' bake, “Mwanjaa namani mwalimu winu alya na bene sambi na alonga koli?” ");
INSERT INTO mgw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nembe Yesu payu'wine mu'lu' mwabaalongei, ngaabakia, “Akoto bapalali pundi, ila atamwe ngabapala pundi. ");
INSERT INTO mgw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lakini muyende mukaiyi'gane kikomeko sa Maandiko Mapeleteu gagabaya, ‘Nipala kiya, wala salaka yinu lili,’ kwa mwanjaa niisili kwakema bene aki, ila niisi kwakema bene sambi.” ");
INSERT INTO mgw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Banamasi' ba Yoani Ywabatisage bannyendeli Yesu na kunnaluya, “Mwanjaa namani twenga na Mafalisayo twendakokotya punga, lakini banamasi' bako bapungali?” ");
INSERT INTO mgw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ngaayangwa, “Mwenga muwasa babakokilwe kulisengele bawesa baa kati babalombola, na mwene lisengele abile pamope nabo? Iwesekanali! Lakini libile lisu'ba mwene lisengele paabu'yilwa pakati yabe, masu'ba go ngapabaapunga. ");
INSERT INTO mgw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ntu'pu' mundu ywabi'ka kibamba sayambi' mungu'bo ngona. Mana apangite nyo, aso kibamba sayambi' kilu'a popwana ngu'bo ngona, no popwanika kwake kwamambulya. ");
INSERT INTO mgw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kai', bandu bayi'yali divai yayambi' mumapu'tu' magona. Mana bapangite nyo, divai yaalu'a puwana ago mapu'tu', nayembe divai pamope na mapu'tu' gaalabika. Divai yayambi' iyi'yi'lwa mumapu'tu' gayambi'. Mwaipalilwa yi'ya divai yayambi' nkati ya mapu'tu' gayambi', divai na mapu'tu' yoti, yaaba salama.” ");
INSERT INTO mgw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu paabile kaabakia makowe go, ngaisa mpi'ndo yumo na kunkilikitya nnu'ngi' yake kammakia, “Mwi'nja wangu' awile nambi'yambi', lakini sonde li'li'li', wise saubi'ke luboko lwako panani yake, li'nga apate yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu pamope na banamasi' bake ngabammi'ngi'ya yu'lu' mundu. ");
INSERT INTO mgw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nnwawa yumo ntamwe wa nkongomokwa kwa myaka ku'mi na ibi'li', aaisi nsu'gu' ya Yesu no kunywa mpindo wa ngu'bo yake. ");
INSERT INTO mgw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mwanjaa aalongei pamwoyo wake panga, “Mana nikunywile ngu'bo yawati bai, naayu'yu'ki'lwa.” ");
INSERT INTO mgw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nembe Yesu paagalambwike, ngammona na kummakia, “Wenga wa mwi'nja wangu', ube na mwoyo nku'lu'! Imani yako ikutepwile.” Yu'lu' nnwawa ngayu'yu'ki'lwa saa yi'yi'lu'yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu paaikite kasake yu'lu' mpi'ndo, ngaabona bandu kabayi'mba myambo yo lombola kwa pilimbi, na kipi'nga sa bandu kabapanga ndu'ti, ");
INSERT INTO mgw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ngaabakia, “Mubu'kange! Kwa mwanjaa mwi'nja yu' anawaali, ila atigonja bai.” Ngabamweka kwa kunsalawa. ");
INSERT INTO mgw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Payomwi kwabi'ngya panja balu' bandu, ngayingya nnyumba na kunkamwa luboko yu'lu' mwi'nja, nembe ngayi'ma. ");
INSERT INTO mgw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Likowe li' lyaatiyu'wanika munni'ma wu'lu' woti. ");
INSERT INTO mgw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu paabile kabu'ka pandu palu', mbulibuli abi'li' baatikummi'ngi'ya kabau'bu'ya malobe gabe kababaya, “Wa Mwana wa Daudi, utubi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu paayingi nnyumba, balu' mbulibuli abi'li' baatikunnyendelya, nembe aatikwalaluya, “Mwendau'bi'lya panga niwesa kumpangya likowe lyo?” Nabembe ngabannyangwa, “Eloo, Bwana.” ");
INSERT INTO mgw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bu'kapo Yesu ngagakunywa minyo gabe kabaya, “Kwinu mwenga, ipangike kati mwamuu'bi'lya.” ");
INSERT INTO mgw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Minyo gabe ngagabanjuka. Yesu ngaakong'ondelya kabaya, “Mupi'kani, likowe li', kanemummakie mundu ywoywoti.” ");
INSERT INTO mgw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini bembe ngabayenda no tumbwa yaulya abali ya Yesu mu nni'ma wu'lu' woti. ");
INSERT INTO mgw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Abo bandu abi'li' pabaabile kababu'ka, ngabannetya Yesu mundu yumo bubu, ywaayingililwe na moka. ");
INSERT INTO mgw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu paayomwi bi'nga yu'lu' moka, yu'lu' bubu aatumbwi longela. Bandu boti baatisangala no baya, “Tunalibonali likowe kati li' munni'ma woti wa Isilaili!” ");
INSERT INTO mgw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Mafalisayo ngababaya, “Mpi'ndo wa akamoka ngabampeya yu' makakala go bi'nga moka.” ");
INSERT INTO mgw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu aati'li'tike mumisengo na ilambo yoti kayi'gana mumayumba ga kunnu'ba Nnu'ngu', kaala abali inannoga ya ukulungwa no tepwa matamwe na ukigopi woti. ");
INSERT INTO mgw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Paibweni ipi'nga ya bandu aabi'ki kiya, kwa mwanjaa aabweni kabaauka pangali yangatiyilwa kati ngondolo bangali nsungi. ");
INSERT INTO mgw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Apo ngaabakia banamasi' bake, “Mauno gambone, lakini apangakasi bali'nganali. ");
INSERT INTO mgw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bai, munnu'be Bwana wa mauno, aatume auni bi'ngi' li'nga baune mauno gake.” ");
INSERT INTO mgw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu aakemite banamasi' bake ku'mi na abi'li' na kwapeya amuli yo bi'nga moka, tepwa matamwe goti, na ukigopi wa kila sampuli. ");
INSERT INTO mgw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na gano nga maina ga abo atumilwe bake ku'mi na abi'li', mosi nga Simoni (kwa lina li'ngi' akemelwa Petili) na nnunawe Andelea, Yakobi mwana wa Zebedayo na nnunawe Yoani. ");
INSERT INTO mgw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi na Batolomayo, Tomasi na Matei ywaabile nnonga koli, Yakobi mwana wa Alufayo na Tadei, ");
INSERT INTO mgw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni wa kipi'nga sa Mazeloti, na Yuda Isikalioti ywaansongi Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Abo nga banamasi' ku'mi na abi'li' babaatumilwe na Yesu no lagilwa makowe ga, “Kanemuyende kumili'ma ya bandu bangali Ayahudi wala kanemuyingi mukilambo sosoti sa Asamalia. ");
INSERT INTO mgw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila mwayendeli alongo binu ba nni'ma wa Isilaili, babapanga kati ngondolo babaobite. ");
INSERT INTO mgw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pamwaalu'a yenda, mwaali bandu kamubaya, ‘Ukulungwa wa Kunani wegelile.’ ");
INSERT INTO mgw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwatepwe atamwe, mwayu'ye babawile, mwapeleteye bene matana, mubi'nge moka. Mwaapeyilwe wabule, namwenga mupiye wabule. ");
INSERT INTO mgw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mumipuko yinu kanemupu'twe zaabu wala mbanje yoyoti. ");
INSERT INTO mgw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mumyanja yinu kanemupu'twe utingo, wala nganju ibi'li', wala ilatu, wala pimbo, kwa mwanjaa mpangakasi apeyelwe yoti yaipalikwa mumaisa gake. ");
INSERT INTO mgw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pamwaika pamisengo au kilambo sosoti, mumpale mundu ywayi'ki'tya kunkemya, namwenga mwaatame kasake mpaka pamwabu'ka pandu po. ");
INSERT INTO mgw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamwayingya munyumba, mwapange abali benekaya kamubaya, ‘Amani ibe kasinu.’ ");
INSERT INTO mgw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Manaitei bandu ba nyumba yo bankemile, amani yinu ilu'a tama pamope nabo. Lakini manabakani kunkemya, amani yi'lu' inki'li'bu'ki mwenga. ");
INSERT INTO mgw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Manaitei mundu ywoywoti aakana kunkemya mwenga, ata pi'kania mayi'gi'yo ginu, pamwabu'ka munyumba au kilambo so, mwapapate lyu'ku'mbi' lyalibile mumagu'lu' ginu na kwaleka kati mwabaabile. ");
INSERT INTO mgw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kakape nimmakianga, lisu'ba lyo ukumilwa, bandu ba kilambo si'lu' baaukumilwa paku'lu' kulikoni bandu ba ilambo ya Sodoma na Gomola. ");
INSERT INTO mgw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Lingulya! Nintumanga kati ngondolo pakatikati ya mapu'mbe. Bai, mube mwang'anga kati nng'ambo, na mwatu'lya kati ngunda. ");
INSERT INTO mgw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwili'ndi'le na bandu, kwa mwanjaa bampeleka kumabalasa gabe na kunku'mbwanga mumayumba gabe go salya. ");
INSERT INTO mgw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kai', mwalu'a pelekelwa nnu'ngi' ya api'ndo na akulungwa kwa kitumbu sangu', li'nga munikong'ondeli kwabe na bandu bangali Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lakini pabampeleka kwo ukumilwa, kanemwisuluye bu'kana na galu' gamwalu'a longela wala mu'lu' mwamwalu'a longela, kwa mwanjaa popopo mwapeyelwa makowe gamwalu'a longela. ");
INSERT INTO mgw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa mwanjaa gamwalongela gapitali kwinu, gaapita kwa Loo wa Tati' binu Nnu'ngu' ywaalongela nkati yinu. ");
INSERT INTO mgw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nnongo alu'a kunsongya nnongowe li'nga abulagilwe, nyinyonyo na tati' kunsongya mwana wabe. Nabembe bana baalu'a kwakania abelei babe li'nga babulagilwe. ");
INSERT INTO mgw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Namwenga mwalu'a sukilwa na bandu boti kwa kitumbu sa lina lyangu', lakini yu'lu' ywaalu'a komeya mpaka kuundi'la alu'a kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Pabaalu'a kunku'su'mbwa pakilambo simo, mwatili kukilambo si'ngi'. Kwa mwanjaa kakape nimmakianga, mubile balo yomwa lyengo linu muilambo yoti ya Isilaili, Mwana wa Mundu aapanga aisile. ");
INSERT INTO mgw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanamasi' ampi'tali mwalimu wake, wala mpangakasi ampi'tali bwana wake. ");
INSERT INTO mgw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ili'ngani kwa mwanamasi' landana na mwalimu wake na ntumisi landana na bwana wake. Manaitei mwene nyumba bankema Belisebuli, yu'lu' mpi'ndo wa moka, balu' ba munyumba yake ngabaakemelwa maina maakau munomuno. ");
INSERT INTO mgw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kwa nyo, kanemwayogope bandu bo, kwa mwanjaa ntu'pu' likowe lyaliiyilwe lyalyasomwa tanganikwa, wala sakiwi'ki'lilwe sasasomwa umukulwa. ");
INSERT INTO mgw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Likowe lyanimmakianga palubi'ndu' mulinwaye pabweya, na likowe lyamuliyu'wa kwo iya, mulinwaye muyi'mi patu'ndu'bau li'nga bandu bayu'we. ");
INSERT INTO mgw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kanemwayogope balu' bababulaga yi'ga bai, lakini bakombwali bulaga loo. Munomuno munnyogope Nnu'ngu' ywakombwa langamisa yi'ga pamope na kwipeleka loo kumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Injosi ibi'li' ipi'mi'yi'lwali kwa lwela lumo bai? Lakini ntu'pu' ata yumo ywatu'la pai' wangali tanga Tati' binu. ");
INSERT INTO mgw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na kwinu mwenga, ywembe atangite ata isabu ya nywili yoti ya mitwe yinu. ");
INSERT INTO mgw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bai kanemuyogope, kwa mwanjaa mwenga nga mwabangama kulikoni kipi'nga kiku'lu' sa iyuni. ");
INSERT INTO mgw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila ywaniyi'ki'tya pa bandu, nani nannyi'ki'tya nyinyonyo kwa Tati' bangu' ba kunani kabalola. ");
INSERT INTO mgw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini kila mundu ywanikana bandu kabalola, nani nankana nyinyonyo kwa Tati' bangu' ba kunani kabalola. ");
INSERT INTO mgw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kanemuwase panga niisi leta amani padunia yi'no. Lili, ila niletike mayu'mano. ");
INSERT INTO mgw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwa mwanjaa niisi kwayu'maniya mwana na tati' bake, mwi'nja na mau' bake, na nkwano na nkiwe. ");
INSERT INTO mgw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na andumu ba mundu nga balu' alongobe. ");
INSERT INTO mgw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ywaapenda tati' bake au mau' bake kulikoni nenga, anipwaikali. Na nyinyonyo, ywampenda mwana wake au mwi'nja wake kulikoni nenga anipwaikali. ");
INSERT INTO mgw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kai', mundu ywakotoka pu'twa nsalaba wake na kunibi'ngi'ya apwaikali panga ywangu'. ");
INSERT INTO mgw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kwa mwanjaa mundu ywapala kuuli'ndi'la bwu'mi wake auobeya, lakini ywaalu'a kuupiya bwu'mi wake kwa kitumbu sangu' alu'a kuupata kai'. ");
INSERT INTO mgw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mundu ywampokya mwenga anipokya nenga, na ywanipokya nenga ampokya yu'lu' ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nnu'ngu' aapiya upo bu'kana na mundu ywaumpokya, ywampokya nnondoli, kitumbu sa ywembe nnondoli, aapata upo ya nnondoli. Nembe ywampokya mwene aki, kwa kitumbu sa ywembe mwene aki, aapata upo ya mwene aki. ");
INSERT INTO mgw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nimmakianga kakape panga, ywoywoti ywaalu'a kumpeya yumo ywa asene ba, nnobo gumo wa masi' maimu kwa mwanjaa ya mwanamasi' wangu', aaikosali upo yaibu'ka kwa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu paayomwi kwalagya go banamasi' bake ku'mi na abi'li', ngabu'ka ku'lu' yenda yi'gana no ala muilambo ya nni'ma gu'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoani Ywabatisage paabile muutabilwe aayu'wine abali ya makowe ga Kilisitu. Bai ngaatuma banamasi' bake, ");
INSERT INTO mgw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bannaluye, “Buli, wenga nga wayu'lu' ywapalikwage isa, au tunni'nde ywi'ngi'?” ");
INSERT INTO mgw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ngaayangwa, “Muyendange mukammakie Yoani makowe gamugayu'wa na kugabona. ");
INSERT INTO mgw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kimbulibuli bendalola, itewe bendatyanga, bene matana bendapeleteyelwa, aibamakutu bendayu'wa, babawile bendayu'yi'lwa na aki'ba baalilwa abali inannoga. ");
INSERT INTO mgw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nantali mundu yu'lu' ywakotoka baa na kyukala nanenga.” ");
INSERT INTO mgw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bai, abo banamasi' ba Yoani pabaabu'i, Yesu aatumbwi kwibakia ipi'nga ya bandu abali ya Yoani, “Mwayi'i lola namani ku'lu' kulupu'ngu'ti'? Buli mwaapalite kummona mundu kigopi kati nnai mwautenandena na nsunga? ");
INSERT INTO mgw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Au mwayi'i lola namani? Mwayi'i kunnola mundu ywaawati ngu'bo inanng'oloka? Bandu babawati ngu'bo inanng'oloka batama mumayumba ga akulungwa. ");
INSERT INTO mgw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakini mwayi'i lola namani? Nnondoli wa Nnu'ngu'? Eloo, kakape ywembe nku'lu' kuliko nnondoli wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ayu' nga ywabayilwa mu Maandiko Mapeleteu, ‘Lola, nintuma kinala wangu' akulongoli, ywaakubi'kya wiso ndi'la nnu'ngi' yako.’ ");
INSERT INTO mgw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Kakape nimmakianga, nkati ya bana boti ba bandu, anapityali nku'lu' kuliko Yoani Ywabatisage. Ata nyo yu'lu' nsene muno muukulungwa wa kunani nga nku'lu' kuliko ywembe. ");
INSERT INTO mgw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bu'ka nsimu wa Yoani Ywabatisage mpaka nambi'yambi', Ukulungwa wa Kunani bautangya kwa ukali', na bandu akali' ngabaupokonywa. ");
INSERT INTO mgw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mayi'gano goti ga alondoli ba Nnu'ngu' na salya ya Musa mpaka nsimu wa Yoani gaalondolilwe bu'kana na nsimu gu'no. ");
INSERT INTO mgw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mana kamuliyi'ki'tya lyo, bai Yoani nga Elia ywembe ngaalu'e isa. ");
INSERT INTO mgw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mwene makutu go yu'wa, ayu'we! ");
INSERT INTO mgw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Lubelekwo lu'no nilu'a kululandanisa na kili'be saku'? Lulandana na anng'elo babatama kusoko babaakema ayabe, kababaya, ");
INSERT INTO mgw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tumwonekiye ngoma, lakini mwinikeli! Tunnyi'mbi myambo ya ili'lo, lakini muli'ili!’ ");
INSERT INTO mgw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Kwa mwanjaa Yoani aaisi kapunga na wala anywileli divai, bembe ngababaya ‘Ai na moka’. ");
INSERT INTO mgw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Mundu aaisi kalya no nywa, nabembe ngababaya ‘Munnolange ayu', mundu mwamila no lobya, mbwiga lyabe alonga koli na bene sambi!’ Ata nyo ikima ya Nnu'ngu' ilaya panga ya aki bu'kana na makowe gake.” ");
INSERT INTO mgw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bu'kapo Yesu ngatumbwa kwikwi'li'ka ilambo yalu' yaapangite mangelongelo gambone, kwa mwanjaa bandu ba ku'lu' baagalambwikeli bu'ka mumasambi gabe. ");
INSERT INTO mgw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ngabaya, “Wakibona wa kilambo sa Kolazini! Wakibona wa kilambo sa Betisaida! Kwa mwanjaa ikapangage mangelongelo gagaapangilwe kwinu gakapangilwa ku'lu' Tilo na Sidoni, bandu bake kenda bayomwike wala mabunia bu'ka palipite, no pakala maligu laya panga bagalambwike bu'ka mumasambi gabe. ");
INSERT INTO mgw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ata nyo, nimmakianga panga lisu'ba lya ukumu mwenga mwapata ukumu ngu'lu' kulikoni ya Tilo na Sidoni. ");
INSERT INTO mgw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nawenga wa Kapernaumu, buli ulu'a kwiu'bu'ya mpaka kunani? Ulu'a uluyilwa mpaka kumambi'! Mwanjaa, mangelongelo gagapangilwe kasako gapangika ku'lu' Sodoma kilambo so kilu'e baa mpaka li'no. ");
INSERT INTO mgw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakini nimmakianga, lisu'ba lya ukumu wenga wapata ukumu ngu'lu' kulikoni ya Sodoma.” ");
INSERT INTO mgw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pamasu'ba go Yesu aatibaya, “Nendakunsukulu mwa Tati', mwa Bwana ba kunani na padunia, kwa mwanjaa makowe gano mwaiyite bene ikima na bene ilimu, na kwaumukulya anangu'ta. ");
INSERT INTO mgw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eloo, Tati', amo nga mwainnogelile. ");
INSERT INTO mgw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tati' bangu' bangamukiye ili'be yoti. Ntu'pu' ywantangite Mwana ila Tati', wala ywatangite Tati' ila Mwana na ywoywoti yu'lu' Mwana ywapenda, ngamwumukulya. ");
INSERT INTO mgw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mwisange kasangu', mwaboti mwamuauka no topelwa na igombo, nanenga nalu'a kuntu'la. ");
INSERT INTO mgw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Muyi'ki'ti longoyelwa nanenga, kati ng'ombe ywatabilwe lukamba, na mwenga mukoleye mayi'gano gangu' mwanjaa nenga nantu'lya na ywangali kibuli. Kwa nyo myoyo yinu yaapu'mu'lya. ");
INSERT INTO mgw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwa mwanjaa mayi'gano gangu' malegeleu na kigombo sangu' kiyu'yu'u.” ");
INSERT INTO mgw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Masu'ba go Yesu aabi kapi'ta mumigunda ya ngano, lyai lisu'ba lya Sabato ya Ayahudi. Banamasi' bake pabaminyike njala, ngabati'kwa yeyo ya ngano no tauna nombo yake. ");
INSERT INTO mgw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo pabagabweni go ngabammakia Yesu, “Lola, banamasi' bako bapanga likowe lya mwilo lisu'ba lya Sabato.” ");
INSERT INTO mgw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ngaayangwa, “Buli munasomali mwaapangite Daudi pamope na aine pabaabile na njala? ");
INSERT INTO mgw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ywembe aayingi munyumba ya Nnu'ngu' no lya makati mapeleteu gagaapiyilwe kwa Nnu'ngu' na kwapeya aine, pamope no panga baayi'ki'tilweli lya makati go, ila api'ndo ba dini kisabe bai. ");
INSERT INTO mgw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kai', munasomali mukitabu sa salya ya Musa panga kila lisu'ba lya Sabato, api'ndo ba dini bendatumika munyumba ya Nnu'ngu'? Bati'kwana salya ya Sabato, ata nyo Nnu'ngu' aabalangilyali makosa. ");
INSERT INTO mgw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lakini nimmakianga panga pano pabile na nku'lu' pi'ta nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mukatangage malombolyo ga Maandiko Mapeleteu gagabaya, ‘Nipala kiya wala kwenda salaka yinuli,’ mulu'e kwaukumuli bandu ba bangali na makosa. ");
INSERT INTO mgw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwa mwanjaa Mwana wa Mundu nga Bwana wa Sabato.” ");
INSERT INTO mgw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu paabu'i po, ngayenda munyumba ya kunnu'ba Nnu'ngu' kwa Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu'lu' nnyumba kwabile na mundu mwene luboko lutomboloka. Bandu ngabannaluya Yesu, “Buli mwiloli kuntepwa mundu lisu'ba lya Sabato?” Bannalwiye nyo li'nga bapate kitumbu sa kunsitakya. ");
INSERT INTO mgw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu ngaabakia, “Tubaye yumo ywinu ai na ngondolo wake ywatumbuki mulyi'mbwa lisu'ba lya Sabato, buli, ankamwali na kumpiya? ");
INSERT INTO mgw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lakini mundu nga ywampu'ku'bi'la kulikoni ngondolo! Bai, mwiloli panga ganannoga lisu'ba lya Sabato.” ");
INSERT INTO mgw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bu'kapo ngaammakia yu'lu' mundu, “Golwa luboko lwako.” Ngalugolwa, na lwembe ngalupanga lukoti kati lu'lu' lwi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bai, Mafalisayo ngabapita panja no sikisana mu'lu' mwa kunnangamisa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lakini Yesu paakwipwi likowe lyo, ngabu'ka pandu po. Bandu baingi baatikunki'ngama, ngaatepwa atamwe boti. ");
INSERT INTO mgw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ngaamulisa kanebabakiye bandu panga ywembe nyai, ");
INSERT INTO mgw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","li'nga galu' gaalongei Nnu'ngu' kwa ndi'la ya nnondoli wake Isaya gatimi. ");
INSERT INTO mgw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Munnole ntumisi wangu' ywaninsawile, ywanimpendile na kunipulaisa pamwoyo wangu'. Nalu'a kuntwi'li'ya Loo wangu' naywembe aanwaya ukosopoli wangu' kwa bandu boti. ");
INSERT INTO mgw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aabali na ntau, wala ndu'ti, wala lilobe lyake lyayu'wanikali musimbasimba. ");
INSERT INTO mgw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nnai waubuguywike aauti'kwanali, wala utambi waupiya lyoi auimiali, mpaka paalu'a kuupanga ukosopoli utawale. ");
INSERT INTO mgw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kasake ywembe bandu bangali Ayahudi baapanga na mau'bi'lyo.” ");
INSERT INTO mgw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Apo bandu ngabannetya Yesu mundu ywaabile mbulibuli na bubu kwa kitumbu sa moka. Yesu ngaantepwa ata ngakombwa longela no lola. ");
INSERT INTO mgw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lipi'nga lyoti lya bandu ba palu' baatisangala ngababaya, “Buli, ayu' iwesa panga Mwana wa Daudi?” ");
INSERT INTO mgw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini Mafalisayo pabaayu'wine go ngababaya, “Mundu yu' abi'nga moka kwa makakala ga Belisebuli, mpi'ndo wa akamoka.” ");
INSERT INTO mgw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu abile atangite maganiyo gabe, ngaabakia, “Ukulungwa wowoti waubaganike ipi'ngaipi'nga yaitaukyana ukombwali konda, na ilambo yoyoti au alongo boboti bababaganike ipi'ngaipi'nga yaitaukyana ikondali. ");
INSERT INTO mgw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Manaitei Ibilisi ammi'nga Ibilisi, aitaukya mwene. Bai, ukulungwa wake walu'ayi'ma buli? ");
INSERT INTO mgw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ikapanga kakape panga nenga nibi'nga moka kwa makakala ga Belisebuli, buli? Bandu ba kipi'nga sinu babi'nga kwa makakala ga nyai? Kwa nyo bandu binu bakong'ondelya panga kikowe samukilongela sa kakape lili! ");
INSERT INTO mgw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakini manaitei nibi'nga moka kwa makakala ga Loo wa Nnu'ngu', bai mutange panga Ukulungwa wa Nnu'ngu' uikite kasinu. ");
INSERT INTO mgw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Au akombwabuli mundu kuitangya nyumba ya mwene makakala na kumpokonywa mali yake, wangali wi'ti' kuntaba? Apo ngapaalu'a kombwa kumpokonywa mali yake. ");
INSERT INTO mgw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ywoywoti ywakotoka lu'mbana nanenga endanitaukya, na ywakotoka kongwa pamope nanenga endamesana. ");
INSERT INTO mgw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa nyo nimmakianga panga, kila sambi na kila liyi'gi'yo lya kupulu bandu baalu'a samilwa, ila kwa kunkupulu Loo Mpeleteu baasamilwali. ");
INSERT INTO mgw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kai' ywaalongela liyi'gi'yo lya kuntaukya Mwana wa Mundu aasamilwa, lakini yu'lu' ywaalongela lya kuntaukya Loo Mpeleteu aasamilwali, wala mudunia yi'no, wala mudunia yayaaisa. ");
INSERT INTO mgw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nkongo unannoga na itunda yake yapanga inannoga, kai' nkongo unannyata na itunda yake yapanga inannyata. Kwa mwanjaa nkongo utanganikwa kwa itunda yake. ");
INSERT INTO mgw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenga mwa abu'su' kati nng'ambo! Mukombwabuli longela makowe ganannoga, lakini mwabene mwalau? Kwa mwanjaa mundu agalongela gagatwi'li mumoyo wake. ");
INSERT INTO mgw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu nnogau apiya makowe manogau bu'ka mumabi'ko gake manogau, na mundu nnau apiya makowe malau bu'ka mumabi'ko gake malau. ");
INSERT INTO mgw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Bai, nimmakianga, lisu'ba lya ukumu bandu baapalikwa yangwa bu'kana na kila liyi'gi'yo lyangali pwaika lyabalongei. ");
INSERT INTO mgw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwa mwanjaa ya mayi'gi'yo gako wabalangilwa aki, na kwa mayi'gi'yo gako waukumilwa.” ");
INSERT INTO mgw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bu'kapo bi'ngi' ba balimu ba salya na Mafalisayo ngabammakia Yesu, “Mwalimu, tupala tuubone mwasu bu'ka kasako.” ");
INSERT INTO mgw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naywembe ngaayangwa “Lubelekwo lulau lwangau'bi'li'ka! Mupala myasu, lakini mwaapeyelwali ila gu'lu' mwasu wa nnondoli Yona. ");
INSERT INTO mgw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kwa mwanjaa kati mwaatami Yona mundumbo ya omba nku'lu' kwa masu'ba gatatu kilo na muntwekati, nga nyinyonyo na Mwana wa Mundu alu'a tama mubwi' masu'ba gatatu, kilo na muntwekati. ");
INSERT INTO mgw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lisu'ba lya ukumu, bandu ba Ninawi baayi'ma pamope na mwenga mwabandu ba lubelekwo lu'no na kabansitakya, kwa kitumbu bembe baagalambwike bu'ka mumasambi gabe pabaayu'wine maalo ga Yona, na kumbe pano abile nku'lu' kumpi'ta Yona! ");
INSERT INTO mgw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nyinyonyo kwa lisu'ba lya ukumu, Malikia bu'ka kusi alu'a yi'ma na bandu ba lubelekwo lu'no na kasitakya, kwa mwanjaa ywembe aabu'i kuutalu muno isa pi'kania mayi'gi'yo ga ikima ga nkulungwa Selemani, na kumbe pano pabile na nku'lu' kumpi'ta Selemani! ");
INSERT INTO mgw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Moka pammu'ka mundu, atyangatyanga mulubele kapala pandu po pu'mu'lya. Lakini mana akotwike pata, ");
INSERT INTO mgw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","apo ngaibakia, ‘Nilu'a ki'li'bu'kya kasangu' kwanibu'i.’ Lakini paabuya na kwikolya ntu'pu' kili'be ipyagililwe no nemekelwa, ");
INSERT INTO mgw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","bai, ngayenda kwaatola moka bi'ngi' saba, alau muno kuliko ywembe, na boti ngabaisa kunnyingya mundu ywo. Na ali ya mundu ywo yapanga mbaya kuliko patumbu. Na nyo ngamwayalu'a panga mulubelekwo lwa bandu bano alau.” ");
INSERT INTO mgw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu paabile anayomwali longela na lipi'nga lya bandu, mau' bake na anunabe baatiisa. Ngabayi'ma panja kabapala longela nakwe. ");
INSERT INTO mgw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bai, mundu yumo ngammakia, “Mau' bako na anunabo bai panja bapala longela nawe.” ");
INSERT INTO mgw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu ngannyangwa mundu ywo, “Mau' bangu' nga nyai na anunangu' nga kinyai?” ");
INSERT INTO mgw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bu'kapo ngagoloya luboko lwake li'nga kwa banamasi' bake, kabaya, “Aba nga mau' bangu' na akina anunangu'! ");
INSERT INTO mgw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwa mwanjaa ywoywoti ywapanga mwabapendi Tati' bangu' ba kunani, abo nga mau' bangu', nnunangu' na nnu'mbwangu'.” ");
INSERT INTO mgw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lisu'ba lyolyolyo, Yesu aabu'i muyi'lu' nyumba ngayenda tama mbwega ya litanda liku'lu' kayi'gana. ");
INSERT INTO mgw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ipi'nga ya bandu yaatikunti'li'ta, kwa nyo Yesu ngau'bu'ka mungalaba no tama. Bandu boti baayi'mi mbwega ya litanda liku'lu', ");
INSERT INTO mgw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","naywembe Yesu ngaabakia makowe gambone kwa ngongo. “Mupi'kaniange! Mpandi aayi'i panda mbeyu. ");
INSERT INTO mgw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Paabile kamisa, mbeyu yi'ngi' yaatu'mbu'ki mundi'la na iyuni ngabaisa sonywa. ");
INSERT INTO mgw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yi'ngi' yaatu'mbu'ki pamaliwe pangali ukando wambone. Ngaibalika kwa kiyu'ngu'ya mwanjaa ukando wayendekiyeli. ");
INSERT INTO mgw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lilumu palyaibalile ngaiyu'ma, kwa mwanjaa ngi'ga yake yatotili mubwi'. ");
INSERT INTO mgw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yi'ngi' yaatu'mbu'ki pamimimwa, na yi'lu' mimimwa ngaiku'la na kwikombaya. ");
INSERT INTO mgw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yi'ngi' yaatu'mbu'ki paukando nnogau, ngaibalika no beleka. Yi'ngi' mya, yi'ngi' sitini na yi'ngi' salasini. ");
INSERT INTO mgw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mwene makutu go yu'wa na ayu'we!” ");
INSERT INTO mgw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Banamasi' bake ngabannyendelya na kunnaluya “Kwa mwanjaa namani ulongela na bandu ba kwa ngongo?” ");
INSERT INTO mgw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu ngaayangwa, “Mwenga muyaliwite kugatanga makowe gangaumukulilwa ga Ukulungwa wa Kunani, lakini bembe bayaliwiteli. ");
INSERT INTO mgw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwa mwanjaa ywoywoti ywagatangite makowe go, Nnu'ngu' alu'a kumpeya kugatanga muno, lakini ywoywoti ywaakotwike kugatanga, Nnu'ngu' alu'a kumpokonywa ata galu' masene gagatangite. ");
INSERT INTO mgw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwa nyo nilongela nabo kwa ngongo, kwa mwanjaa bendalola lakini babonali, bendapi'kania lakini bayu'wali na wala batangali. ");
INSERT INTO mgw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwabe gatimile gaalongei nnondoli wa Nnu'ngu' Isaya, ‘Yu'wa mwalu'a yu'wa lakini mwalu'a tangali. Lola mwalu'a lola lakini mwalu'a bonali. ");
INSERT INTO mgw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwa mwanjaa myoyo ya bandu ba itenonopa, na makutu gabe manonopau kwo yu'wa, minyo gabe gatiwiliwitya. Ikapanga nyoli balu'e lola kwa minyo gabe, balu'e yu'wa kwa makutu gabe, balu'e tanga kwa malango gabe na kunigalambukya, nanenga nilu'e kwakosopolya.’ ");
INSERT INTO mgw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lakini nantali mwenga minyo ginu gendalola na makutu ginu gendayu'wa. ");
INSERT INTO mgw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kakape nimmakianga, alondoli ba Nnu'ngu' na bene aki baingi baaminyikie kugabona na kugayu'wa gamugabona na kugayu'wa, lakini baakombwili. ");
INSERT INTO mgw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Bai, mwenga mupi'kaniange malombolyo ga lukongo lwa mpandi. ");
INSERT INTO mgw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ywoywoti ywaliyu'wa liyi'gi'yo lya Ukulungwa wa Nnu'ngu' wangali kulitangiya, alandana na yi'lu' mbeyu yaitu'mbu'ki mundi'la, yu'lu' nnau Ibilisi ngaisa no tola sakipandilwe pamwoyo wake. ");
INSERT INTO mgw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yi'lu' mbeyu yaipandilwe pamaliwe nga kati mundu ywaliyu'wa liyi'gi'yo lya Ukulungwa wa Nnu'ngu' na popopo alipokya kwo napusika. ");
INSERT INTO mgw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lakini liyendekeali nkati yabe kati ngi'ga. Balikamwa pasene bai, paiisa tabu na ngu'su'mbu' kwa kitumbu sa liyi'gi'yo lya Nnu'ngu', popopo bendatu'mbu'ka. ");
INSERT INTO mgw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu yaitu'mbu'ki pamimimwa nga kati mundu ywaliyu'wa liyi'gi'yo lya Nnu'ngu' lakini kyukala sa padunia yi'no na makowe ga mali ngagakombaya liyi'gi'yo lyo no kotoka beleka itunda. ");
INSERT INTO mgw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbeyu yaipandilwe muukando nnogau nga kati mundu ywaliyu'wa liyi'gi'yo lya Nnu'ngu' na kulitangia, naywembe beleka itunda, yumo mya, ywi'ngi' sitini na ywi'ngi' salasini.” ");
INSERT INTO mgw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ngaabakia bandu lukongo lwi'ngi', “Ukulungwa wa Kunani ulandana na mundu ywapandike mbeyu inannoga munng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lakini bandu pabaabile bagonjike, nndumu wake ngaisa, ngapanda magu'gu' pakati ya mbeyu inannoga no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bai, mitombo paibalike no tumbwa ku'la, na gembe magu'gu' ngagabonekana momomo. ");
INSERT INTO mgw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Atumisi ba yu'lu' mwene nng'unda ngabannyendelya na kummakia, ‘Bwana, tutangite panga waapandike mbeyu inannoga munng'unda wako, aga magu'gu' gabu'ka kwaku'?’ ");
INSERT INTO mgw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ywembe ngaayangwa, ‘Nndumu ngaywapangite nyo.’ Bai, atumisi bake ngabannaluya, ‘Buli upala tukagayokwane?’ ");
INSERT INTO mgw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naywembe ngaayangwa, ‘Lili, pamwayokwana magu'gu' mwakane ponekea yokwa pamope na ngano. ");
INSERT INTO mgw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mugaleke gaku'le pamope mpaka nsimu wa mauno. Nsimu wo naalu'a kummakia mwaauni, Mukongwange wi'ti' magu'gu' mukagatabe matu'tamatu'ta go sonjelwa. Lakini ngano mwikongwe mukaibi'ke paligu'lu' lyangu'.’” ");
INSERT INTO mgw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ngaabakia bandu lukongo lwi'ngi'. “Ukulungwa wa Kunani ulandana na mbeyu ya nkongo wa aladali yaatweti mundu na kwipanda munng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yembe njene kuliko mbeyu yoyoti, lakini mana ibalike no ku'la upanga nkongo nku'lu' kuliko nkongo wowoti, ata iyuni bendaisa no senga iyumba mundambi' yake.” ");
INSERT INTO mgw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ngaabakia lukongo lwi'ngi'. “Ukulungwa wa Kunani ulandana na ngelule njene yaaitweti mau' yumo, ngayangabana na bwembe wambone na bwembe woti ngaulu'la.” ");
INSERT INTO mgw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ngaabakia bandu boti makowe go kwo tumya ngongo, wala alongeili nabo sosoti wangali tumya ngongo, ");
INSERT INTO mgw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","li'nga likowe lyalyalongelilwe na nnondoli litimi, “Nalu'a longela nabo kwa ngongo, nalu'a kugabi'ka panja gagaiyilwe bu'ka umbilwa kwa dunia.” ");
INSERT INTO mgw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bu'kapo Yesu aatikwalaga balu' bandu, ngayingya nnyumba. Banamasi' ngabannyendelya na kummakia “Utuawanikie lu'lu' lukongo lwa magu'gu' munng'unda lulombolya namani.” ");
INSERT INTO mgw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ngaabakia, “Mpandi wa mbeyu inannoga nga Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gu'lu' nng'unda nga dunia. Yi'lu' mbeyu inannoga nga bandu balu' bababile nawo ukulungwa. Galu' magu'gu' nga balu' bandu ba yu'lu' Ibilisi. ");
INSERT INTO mgw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nndumu ywapandike manyei nga Ibilisi. Mauno nga kuundi'la wa dunia, na auni nga malaika. ");
INSERT INTO mgw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kati manyei mwagakongolelwa li'nga yoselwa mwoto, amo ngamwayalu'a baa kuundi'la wa dunia. ");
INSERT INTO mgw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Mundu aatuma malaika bake baakongwe balu' boti babaapangia ayabe sambi na alau boti bu'ka muukulungwa wake, ");
INSERT INTO mgw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kwataikulya mulitu'ta lya mwoto, na akwo baali'la no yaga mino. ");
INSERT INTO mgw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bu'kapo balu' anogau baamelemetya kati lisu'ba muukulungwa wa Tati' babe. Mwene makutu go yu'wa ayu'we! ");
INSERT INTO mgw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ukulungwa wa Kunani ulandana na mali yaiiyilwe munng'unda. Mundu yumo paaibweni ngaiiya kai'. Aatinapusika muno ngayenda pi'mi'ya ili'be yoti yabile nayo li'nga pi'ma nng'unda gu'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kai', Ukulungwa wa Kunani ulandana na nsulusi ywaapalite kili'be sa samani ngu'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Paaipatike yimo ya yi'lu' yene samani ngu'lu', aayi'i pi'mi'ya ili'be yoti yabile nayo, ngapi'ma so. ");
INSERT INTO mgw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kai', Ukulungwa wa Kunani ulandana na lupi'li'li' lwalutumbukiyilwe mubaali no loba omba ba kila lukolo. ");
INSERT INTO mgw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Palwaatwi'lile, bandu baaluuti kumbwani, ngabatama, no sawa omba banannoga na kwabi'ka mwiitu'ndu' yabe, na anyatau ngabataikwa. ");
INSERT INTO mgw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na nyo ngamwayalu'a baa kuundi'la wa dunia. Malaika baaisa na kwabawa bandu alau na bandu anogau, ");
INSERT INTO mgw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kwataikwa balu' alau mulitu'ta lya mwoto. Akwo baali'la no yaga mino.” ");
INSERT INTO mgw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu ngaalaluya, “Buli, mugatangite makowe gano goti?” Ngabannyangwa, “Eloo.” ");
INSERT INTO mgw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naywembe ngaabakia, “Kwa nyo, kila mwalimu ywapanga mwanamasi' wa Ukulungwa wa Kunani alandana na mwene nyumba ywapiya mumabi'ko gake ili'be yayambi' na ngona.” ");
INSERT INTO mgw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu paayomwi longela ngongo yo ngabu'ka pandu po, ");
INSERT INTO mgw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ngayenda kukilambo sake. Akwo ngaayi'gana bandu munyumba ya kunnu'ba Nnu'ngu', ata ngabasangala kababaya, “Ayu' apatike kwaku' ikima yi' na mangelongelo ga? ");
INSERT INTO mgw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Buli, ayu' mwana wa yu'lu' selemala li? Mau' bake akemelwali Malia, na akina alongobe ki Yakobi, Yusupu, Simoni na Yuda? ");
INSERT INTO mgw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na alu'mbu'be boti babileli pano pamope na twe? Buli, apatike kwaku' aga goti?” ");
INSERT INTO mgw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bai, ngababi'ka kyukala nakwe. Lakini Yesu ngaabakia, “Nnondoli wa Nnu'ngu' endaisimilwa kila pandu, lakini munni'ma wake na panyumba yake aisimilwali!” ");
INSERT INTO mgw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwa nyo aapangiteli mangelongelo gambone palu', kwa kitumbu so kotoka u'bi'lya kwabe. ");
INSERT INTO mgw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nsimu wo nkulungwa Helode aayu'wine abali ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bai, ngaabakia atumisi bake, “Mundu yu' nga Yoani Ywabatisage, ayu'kite bu'ka kuuwi'li. Kwa kitumbu so ngaaba na makakala go panga mangelongelo nkati yake.” ");
INSERT INTO mgw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kubile balo ika nsimu wo, Helode aammoywi Yoani, ngaantaba na kunnyi'ya muutabilwe kwa kitumbu sa Helodia nnyumbo wa Pilipi nnunawe Helode. ");
INSERT INTO mgw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwa mwanjaa Yoani ammakie Helode, “Mwilo wenga kunkobeka nnwawa ywaakobekilwe na nnunago!” ");
INSERT INTO mgw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode aapalike kummulaga Yoani, lakini aayogwipe bandu kwa mwanjaa bau'bi'li panga Yoani aai nnondoli wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lisu'ba lya si'li'ku'si'li'ku' yo belekwa kwa Helode, biti wa Helodia aatiina nnu'ngi' ya ageni. Helode aatikunapusikya, ");
INSERT INTO mgw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ata ngammakia kwa kilapo aywo mwi'nja panga alu'a kumpeya kili'be sosoti saalu'a kunnu'ba. ");
INSERT INTO mgw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naywembe ku'no kasopelwa na mau' bake, ngalu'ba, “Papanopano unipei ntwe wa Yoani Ywabatisage mukyani.” ");
INSERT INTO mgw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nkulungwa aatinyopa, lakini kwa mwanjaa ya si'lu' kilapo saalapike nnu'ngi' ya ageni ba pasi'li'ku'si'li'ku', ngaamulisa apeyelwe. ");
INSERT INTO mgw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bai, Helode ngantuma mundu kunyumba ya atabilwe ankate ntwe Yoani. ");
INSERT INTO mgw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ntwe wa Yoani ngauletelwa mukyani, ngabampeya yu'lu' mwi'nja, naywembe ngaapelekya mau' bake. ");
INSERT INTO mgw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Banamasi' ba Yoani ngabaisa, ngabautola ntwi wake na kuusika. Bu'kapo ngabayenda kumpeya Yesu abali yo. ");
INSERT INTO mgw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu paayu'wine abali yo, aabu'i pandu palu' kwa ngalaba yenda pandu pakiyi'yi'. Lakini bandu baapatike abali, ngabanki'ngama kwa magu'lu' bu'ka kumisengo. ");
INSERT INTO mgw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu paaulwike bai kumbwani, aalibweni lipi'nga liku'lu' lya bandu, aabi'ki kiya, ngaatepwa atamwe babe. ");
INSERT INTO mgw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pakwabile kitamwiyo, banamasi' bake baatikunyendelya ngabammakia, “Pandu pano palupu'ngu'ti', na lisu'ba lipilile. Walage bandu li'nga bayende kumisengo bakaipi'mi ilyo.” ");
INSERT INTO mgw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ngaayangwa, “Ipalikwali bayende, mwapeyange mwenga ilyo.” ");
INSERT INTO mgw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lakini bembe ngabannyangwa, “Tubile nago makati matano, na omba abi'li' bai.” ");
INSERT INTO mgw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu ngaabakia, “Munileti pano.” ");
INSERT INTO mgw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngaamulisa bandu batamange mumanyei. Bu'kapo Yesu ngagatola galu' makati matano na omba abi'li', ngalola kunani na kunsukulu Nnu'ngu'. Bu'kapo ngagametwa galu' makati, ngaapeya banamasi' bake, nabembe ngabapeya bandu. ");
INSERT INTO mgw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bandu boti ngabalya no yukuta. Bu'kapo banamasi' ngabakongwa yakulya yaigile, batwi'li'ye itu'ndu' ku'mi na ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mayumu ga bandu babaalile baai analu'me mitumbi 5,000, pangali balangilya alwawa na bana. ");
INSERT INTO mgw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bai, Yesu paabile kailaga ipi'nga ya bandu, ngaamulisa banamasi' bake bau'bu'ke ngalaba, bannongoli kwiyi' ya litanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bu'ka pa kwalaga bandu, aau'bu'ki kukitu'mbi' kisake salya. Payaabile kitamwiyo, akwo ywembe abile kisake, ");
INSERT INTO mgw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na apo ngalaba yabile iikite pakatikati ya litanda liku'lu' kaiku'mbu'lwa na mabi'mbi' kwa mwanjaa nsunga wapitike nnu'ngi' yake. ");
INSERT INTO mgw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kungu'ku', Yesu aayendeli banamasi' bake katyanga panani ya masi'. ");
INSERT INTO mgw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Banamasi' bake pabaamweni katyanga panani ya masi', baatiyogopa muno ngababaya, “Nga lyoka!” Ngabakemelya kwo yogopa. ");
INSERT INTO mgw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Popopo Yesu ngaabakia, “Muliye, nga nenga. Kanemuyogope!” ");
INSERT INTO mgw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petili ngammakia, “Bwana, manaitei kakape nga wenga uniamulise nise kasako kanityanga panani ya masi'.” ");
INSERT INTO mgw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu ngabaya, “Aya, isa.” Petili ngauluka bu'ka mungalaba, katyanga panani ya masi' kannyendelya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini paauyu'wine wu'lu' nsunga, aatiyogopa, ngatumbwa swikya no li'la kwa lilobe kabaya, “Bwana, unikosopoli!” ");
INSERT INTO mgw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Apo, Yesu ngagoloya luboko lwake, ngaankamwa na kummakia, “Wenga wamwene imani njene! Mwanjaa namani uba na kyukala?” ");
INSERT INTO mgw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na boti abi'li' pabaau'bwike mungalaba, nsunga ngaukotoka. ");
INSERT INTO mgw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Boti babaabile mu'lu' mungalaba baankilikiti Yesu, kababaya, “Kakape wenga ngawa Mwana wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pabaalokite litanda liku'lu', ngabaika kunni'ma wa Genesaleti. ");
INSERT INTO mgw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bandu ba akwo pabankwipwile, ngabayaulya abali yo pandu poti. Bai, ngabannetya Yesu atamwe boti, ");
INSERT INTO mgw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ngabannu'ba aayi'ki'ti'ye kunywa mpindo wa ngu'bo yake bai. Nabembe babankunywile baatiyu'yu'ki'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bu'kapo Mafalisayo na balimu ba salya bu'ka ku Yelusalemu, ngabannyendelya Yesu na kunnaluya, ");
INSERT INTO mgw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mbona banamasi' bako bati'kwana mimu ya api'ndo bitu? Kwa mwanjaa pabatumbwa lya bauluwali moko!” ");
INSERT INTO mgw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ngaayangwa, “Mboni mwenga muti'kwana salya ya Nnu'ngu' kwa kitumbu so koleya mimu yinu? ");
INSERT INTO mgw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwa mwanjaa Nnu'ngu' aabaite, ‘Waisimu tati' bako na mau' bako,’ na, ‘Ywaapwiwa tati' bake au mau' bake, ipalikwa abulagilwe.’ ");
INSERT INTO mgw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini mwenga mubaya, ‘Munisami, niwesali kunnyangatia mwa abelei bangu', kwa mwanjaa naabi'i nyalili ya kumpeya Nnu'ngu' yi'lu' yanipalage kumpeya mwenga.’ ");
INSERT INTO mgw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kwa nyo ipalikwali kai' kwaisimu abelei bake! Amo ngamwa mulisalawa liyi'gi'yo lya Nnu'ngu' kwo koleya mimu yinu mwabene. ");
INSERT INTO mgw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwenga mwa anapiki! Ulondoli wa Nnondoli wa Nnu'ngu' Isaya waai wa kakape bu'kana na mwenga, paabaite panga, ");
INSERT INTO mgw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bandu ba baniisimu pankano bai, lakini mumyoyo yabe babile kuutalu nanenga. ");
INSERT INTO mgw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunikilikitya kwabe kupwaikali, kwa mwanjaa mayi'gi'yo gabagayi'gana ga Nnu'ngu' li ila ga bandu bai.’” ");
INSERT INTO mgw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu aalikemite li'lu' lipi'nga lya bandu, ngaabakia, “Mupi'kaniange na mugatange makowe ganipala kummakia! ");
INSERT INTO mgw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kili'be sakiyingya munkano wa mundu kinsapuyali loo. Lakini si'lu' sakipita munkano wa mundu nga kinsapuya loo.” ");
INSERT INTO mgw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bu'kapo banamasi' ngabannyendelya, na kummakia, “Buli, utangite panga Mafalisayo baatiusika pabaayu'wine mayi'gi'yo gako?” ");
INSERT INTO mgw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ywembe ngaayangwa, “Kila ntombo waukotwike pandilwa na Tati' bangu' ba kunani waayokolelwa. ");
INSERT INTO mgw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwaalekange! Bembe nga kimbulibuli, alongosi ba kimbulibuli. Na mbulibuli mana annongoya mbulibuli nnyine, boti abi'li' baatumbukya mulyi'mbwa.” ");
INSERT INTO mgw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petili ngabaya, “Utuawanikiye lukongo lwo lulombolya buli.” ");
INSERT INTO mgw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ngabaya, “Ata mwenga balo munatangali? ");
INSERT INTO mgw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Buli, munatangali panga kila sakiyingya munkano kiyenda mundumbo, bu'kapo kiyenda pita no tumbukya mulindi? ");
INSERT INTO mgw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini mayi'gi'yo gagapita munkano, gabu'ka mumyoyo na ago ngagagasapuya loo ya mundu. ");
INSERT INTO mgw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mwanjaa mumyoyo ngamupita maganiyo manyatau, ubulagi, upege, ugoni, bwii, ubu'su' na matukano. ");
INSERT INTO mgw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ago nga makowe gakunnyi'ya mundu usapu wa loo. Lakini lya wangali uluwa moko kunnyi'yali mundu usapu wa loo.” ");
INSERT INTO mgw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu aabu'i pandu po ngayenda munni'ma wa ku Tilo na Sidoni. ");
INSERT INTO mgw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bai, mau' yumo Nkanaani wa nni'ma wo aatiisa no tu'ndu'bi'ya lilobe kabaya, “Bwana, Mwana wa Daudi, umbi'ki kiya! Biti wangu' aauyilwa na moka.” ");
INSERT INTO mgw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu annyangwili. Banamasi' bake ngabannyendelya na kummakia, “Ummakie ayende kasake kwa mwanjaa atuki'ngama ku'no kapanga ndu'ti.” ");
INSERT INTO mgw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu ngayangwa, “Nitumilweli kwa bandu bi'ngi', ila kwa bandu ba Isilaili babaaobite kati ngondolo.” ");
INSERT INTO mgw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Apo aywo mau' ngaisa, ngaankilikitya, kabaya, “Bwana, uniyangatiye.” ");
INSERT INTO mgw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ngannyangwa, “Inogelelyali tola kilyo sa bana na kwataikulya mapwa.” ");
INSERT INTO mgw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aywo mau' ngayangwa, “Kakape, Bwana, lakini ata mapwa balya mbolotya yabapoloya mabwana babe.” ");
INSERT INTO mgw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Apo Yesu ngannyangwa, “Mau', imani yinu ngu'lu'! Bai, mupangilwe kati mwamupala.” Yu'lu' mwi'nja ngayu'yu'ki'lwa saa yi'yi'lu'yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu paabu'i po aayi'i mbwega ya litandaliku'lu' lya Galilaya, ngau'bu'ka kukitu'mbi' no tama kwo. ");
INSERT INTO mgw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bandu baingi ngabamwisilya kabaaleta alemau kati kimbulibuli, itewe, mabubu na bi'ngi' baingi babaabile atamwe. Ngabaabi'ka nnu'ngi' yake, Yesu ngaatepwa. ");
INSERT INTO mgw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lipi'nga li'lu' lya bandu lyaatisangala muno, palyaabweni mabubu kabalongela, babaabile alemala baai akoti, itewe kabatyanga na kimbulibuli kabalola, bandu ngabannumba Nnu'ngu' wa Isilaili. ");
INSERT INTO mgw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu aakemite banamasi' bake, ngabaya, “Naabi'kya kiya aba bandu, kwa mwanjaa babile nanenga kwa masu'ba gatatu na ntu'pu' kilyo. Nipendili kwaleka babu'ke wangali lya baakane induka mundi'la.” ");
INSERT INTO mgw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Banamasi' ngabammakia, “Pano tubile palupu'ngu'ti', tulu'a pata kwaku' kilyo sa kwali'ngana bandu bambone kati ba?” ");
INSERT INTO mgw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ngaalaluya, “Mubile na makati gali'nga?” Ngabannyangwa, “Tubile na makati saba na omba asene bai.” ");
INSERT INTO mgw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bai, Yesu ngaamulisa bandu batame pai'. ");
INSERT INTO mgw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bu'kapo ngagatola galu' makati saba na balu' omba, ngaansukulu Nnu'ngu', ngagametwa, ngaapeya banamasi', nabembe ngabaabagana bandu. ");
INSERT INTO mgw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boti baatilya no yukuta. Bu'kapo banamasi' ngabakongwa makombo, ngabatwi'li'ya itu'ndu' saba. ");
INSERT INTO mgw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abo babaalile baai analu'me elupu nsese wangali balangilya alwawa na bana. ");
INSERT INTO mgw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bai, Yesu bu'ka pa kwalaga bandu, ngau'bu'ka ngalaba, yenda lwingo lwa Magadani. ");
INSERT INTO mgw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo bannyendeli Yesu kwa kumpaya, ngabannu'ba alaye mwanju wabu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu ngaayangwa, “Paiika saa ya kitamwiyo, pamukubona kunani kuku'ngu'lwike, mwenga mubaya panga pamalau' yake kwasa kuku'ngu'lwike. ");
INSERT INTO mgw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na kindai' pamukubona kunani gai maunde mapili, mubaya panga ula alu'a nia. Mumanyi kugatanga maunde, lakini mukombwali kugatanga makowe ga nsimu gu'no. ");
INSERT INTO mgw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bandu ba lubelekwo lwaakau na lwalukotwike u'bi'li'ka kwa Nnu'ngu' bapala balayilwe mwanju. Lakini balayilwali mwanju wowoti ila mwanju wa nnondoli Yona.” Bai, ngaaleka no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Banamasi' bake pabaalokile liyi' lyenebi'li' lya litanda liku'lu', ngabaku'mbu'kya panga balibalile pu'twa makati. ");
INSERT INTO mgw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ngaabakia, “Mutame minyo na mwili'ndi'le na ulu'u wa Mafalisayo na Masadukayo!” ");
INSERT INTO mgw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lakini banamasi' bake ngabalaluyana bene na bene kababaya, “Abaya nyo kwa mwanjaa tupu'twili makati.” ");
INSERT INTO mgw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu ataangite mwabaganiyage ngaabakia, “Mwenga mwabandu mwabene imani njene! Mboni mulongelya abali yo kotoka baa na makati? ");
INSERT INTO mgw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Buli, munatangali wala ku'mbu'kya palu' bandu elupu tano pabaayukwite makati matano? Mwatwi'liye itu'ndu' ili'nga ya makombo? ");
INSERT INTO mgw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Au galu' makati saba gabaabaganilwe bandu elupu nsese, buli mwakongwi itu'ndu' ili'nga ya makombo? ");
INSERT INTO mgw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mboni mutangali panga nilongelyageli bu'kana na makati? Mwili'ndi'le na ulu'u wa Mafalisayo na Masadukayo!” ");
INSERT INTO mgw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apo banamasi' ngabakwipwa panga aabakiye baili'ndi'le, kwenda kwa ulu'u wa makati li, ila kwa mayi'gano ga Mafalisayo na Masadukayo. ");
INSERT INTO mgw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu paaikite lwingo lwa Kaisalia Filipi, ngaalaluya banamasi' bake, “Bandu babaya Mwana wa Mundu nga nyai?” ");
INSERT INTO mgw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngabannyangwa, “Bi'ngi' babaya panga Yoani Ywabatisage, bi'ngi' Elia, bi'ngi' Yelemia au yumo ywa alondoli bi'ngi'.” ");
INSERT INTO mgw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu ngaalaluya, “Na mwenga mubaya nenga nanyai?” ");
INSERT INTO mgw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petili ngayangwa, “Wenga nga wa Kilisitu, Mwana wa Nnu'ngu' ywabile nkoti.” ");
INSERT INTO mgw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu ngabaya, “Nantali wenga wa Simoni mwana wa Yona, kwa mwanjaa ntu'pu' mundu ywoywoti ywakutakulile likowe li'no, ila Tati' bangu' ba kunani. ");
INSERT INTO mgw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nanenga nikubakia panga wenga wa Petili nga wa mpi'mbi', na panani ya mpi'mbi' gu' nalu'a lisenga kanisa lyangu', wala makakala ga kiwo gaalikombwali. ");
INSERT INTO mgw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naakupeya punguo ya Ukulungwa wa Kunani. Kila sawakiyigala padunia sayigalilwa kai' kunani, na kila sawakiyu'gu'lya padunia sayu'gu'li'lwa kai' kunani.” ");
INSERT INTO mgw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bu'kapo ngaaking'indya banamasi' bake, kane bammakie mundu ywoywoti panga ywembe nga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tangu' nsimu wo, Yesu aatumbwi kwabakia banamasi' bake mpu'la panga ipalikwa ayende ku Yelusalemu na akwo akapate ngu'su'mbu' yayaapangilwa na api'ndo, api'ndo ba dini na balimu ba salya na kwo aabulagilwa na lisu'ba lyenetatu aayu'yi'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Apo Petili ngaampeleka pambwega na kunkwi'li'ka, “Bwana, kaneibe nyo! Likowe li' lyakupityali!” ");
INSERT INTO mgw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu ngagalambuka na kummakia Petili, “Ubu'ke nnu'ngi' yangu' wenga wa Ibilisi! Wenga ngawa kiku'bala sangu'. Uganiali gagabu'ka kwa Nnu'ngu' ila ga kimundu!” ");
INSERT INTO mgw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bu'kapo Yesu ngaabakia banamasi' bake, “Mundu ywoywoti mana kapala panga mpwasi wangu', ipalikwa aikane mwene, apu'twe nsalaba wake, aniki'ngame. ");
INSERT INTO mgw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwa mwanjaa mundu ywapala kuukosopolya bwu'mi wake mwene auobeya, lakini mundu ywauobeya bwu'mi wake kwa kitumbu sa nenga aaupata. ");
INSERT INTO mgw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lakini mundu ywauobeya bwu'mi wake kwa kitumbu sa nenga aaupata. Au mundu aapata ki'li' mana aaupata utayili woti wa padunia lakini aobiye bwu'mi wake? Ntu'pu' kili'be sowesa yangangana na bwu'mi wake. ");
INSERT INTO mgw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mwanjaa Mwana wa Mundu aaisa muutukupu wa Tati' bake pamope na malaika bake, apo ngalu'a kunni'pa kila mundu bu'kana na yendo yake. ");
INSERT INTO mgw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kakape nimmakianga, bi'ngi' babile papanopano baawaali wangali kummona Mwana wa Mundu kaisa muukulungwa wake.” ");
INSERT INTO mgw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagaapite masu'ba sita bu'ka pa likowe li' Yesu aatweti Petili, Yakobi na Yoani nnunawe, ngayenda nabo panani ya kitu'mbi' kilaso, na kwo baabile kisabe. ");
INSERT INTO mgw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akwo, Yesu ngagalambuka ywoti nnu'ngi' yabe, kuminyo yake ngakung'alang'atya kati lisu'ba na iwalo yake ngaipanga uu kati bweya. ");
INSERT INTO mgw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Popopo Musa na Elia ngabaapitya, ngababaa kabalongela nakwe. ");
INSERT INTO mgw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Apo Petili ngammakia Yesu, “Bwana, inogelelile tube pano! Mana upendile naasenga isewe itatu, simo sako, simo sa Musa na simo sa Elia.” ");
INSERT INTO mgw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Paabile balo kalongela ago, lyunde lyu ngalyawi'ki'lya, na lilobe ngaliyu'wanika bu'ka mulyunde lyo, “Aywo nga Mwana wangu' ywanimpendile, ywaninogelelile. Mupi'kaniange!” ");
INSERT INTO mgw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Banamasi' pabaayu'wine nyo, baatu'i pai' wakukama, ngabayogopa muno. ");
INSERT INTO mgw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lakini Yesu ngaayendelya na kwakunywa, kabaya, “Muyi'mange, kanemuyogope!” ");
INSERT INTO mgw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabaloi kunani baamwenili mundu ywi'ngi' ila Yesu kisake. ");
INSERT INTO mgw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pabaabile kabaelya kukitu'mbi', Yesu ngaaking'indya, “Kanemummakie mundu makowe gamugabweni mpaka Mwana wa Mundu paayu'yi'lwa bu'ka kuuwi'li.” ");
INSERT INTO mgw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bu'kapo banamasi' ngabannaluya, “Mboni balimu ba salya babaya panga Kilisitu abile balo isa alongolya wi'ti' Elia?” ");
INSERT INTO mgw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ngaayangwa, “Kakape, ipalikwa wi'ti' buya Elia li'nga bi'ka wiso makowe goti. ");
INSERT INTO mgw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini nimmakianga, Elia aisile nabembe baankwipwili, ila baampangi mwabaapendile. Mwana wa Mundu aaku'su'mbu'lwa nyinyonyo na bandu babalu'balu'.” ");
INSERT INTO mgw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Apo banamasi' ngabakwipwa panga aai kaabakia abali ya Yoani Ywabatisage. ");
INSERT INTO mgw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabaikite palu' pa lipi'nga lya bandu, mundu yumo aannyendeli Yesu, ngakilikita nnu'ngi' yake, ");
INSERT INTO mgw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ngabaya, “Bwana, ummi'ki kiya mwana wangu'! Mwanjaa aminya kyundaunda, na utamwe wo wendakunku'su'mbwa muno, ywembe atu'mbu'kyatu'mbu'kya pamwoto au mumasi'. ");
INSERT INTO mgw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naatikunneta kwa banamasi' bako, lakini baakombwili kuntepwa.” ");
INSERT INTO mgw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu ngayangwa, “Mwenga mwa lubelekwo lulau na lwangali u'bi'lya! Nilu'a tama na mwenga na kunkomeya mpaka pakubawi? Unnete mwana wako pano.” ");
INSERT INTO mgw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bai, Yesu ngankalipya aywo moka, naywembe ngammu'ka na yu'lu' mwana, ngayu'yu'ki'lwa saa yi'yi'lu'yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bu'kapo banamasi' ngabannyendelya Yesu paakisake, ngabannaluya, “Kwa mwanjaa buli twenga tukombwili kummi'nga yu'lu' moka?” ");
INSERT INTO mgw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ngaayangwa, “Kwa kitumbu sa imani yinu njene. Nimmakianga kakape, mana mwabaa na imani njene ata kati mbeyu ya nkongo wa aladali, mwaakombwa kukibakia kitu'mbi' si', ‘Bu'ka pano uyende palu',’ nasembe kilu'e yenda. Ntu'pu' kili'be sosoti sasaakotoka kombolwa kasinu.” ");
INSERT INTO mgw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Banamasi' pabaabile pamope akwo Galilaya, Yesu aatikwabakia, “Mwana wa Mundu alu'a kamukiyilwa mmoko ga bandu, ");
INSERT INTO mgw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nabembe baamulaga, lakini lisu'ba lyenetatu ayu'yi'lwa.” Banamasi' baatinyopa muno. ");
INSERT INTO mgw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pabaaikite Kapernaumu, bandu babakongwa koli ya nyumba ya Nnu'ngu' bannyendeli Petili ngabannaluya, “Buli, mwalimu winu endali'paga koli?” ");
INSERT INTO mgw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petili ngayangwa “Elo, endali'paga.” Bai Petili paayingi nnyumba abi balo analongelali, Yesu ngannaluya, “Simoni, wenga wibona buli? Akulungwa ba dunia bakongwa koli bu'ka kwa kinyai? Kwa benekaya au kwa ageni?” ");
INSERT INTO mgw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petili ngayangwa, “Bu'ka kwa ageni.” Yesu ngammakia, “Aya kumbe, benekaya bapalikwali. ");
INSERT INTO mgw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini li'nga kanetwausi, uyende kulitanda liku'lu' ukataikuli ndowana, wantole omba ywaalongolya kola, waumukwe nkano wake, na nkati waikolya mbanje ya koli. Waitole ukali'pe kwa twenga twabi'li'.” ");
INSERT INTO mgw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nsimu gu'lu' banamasi' bannyendeli Yesu, ngabannaluya, “Nyai ywabile nku'lu' muno muukulungwa wa kunani?” ");
INSERT INTO mgw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu ngaankema mwana yumo, ngaannyi'mi'ka pakatikati yabe, ");
INSERT INTO mgw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ngabaya, “Kakape nimmakianga, mana mukotwike galambuka no baa kati bana, mwayingyali katu muukulungwa wa kunani. ");
INSERT INTO mgw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ywoywoti ywaiuluya kati mwana yu', aywo ngaywaalu'a panga nku'lu' muukulungwa wa kunani. ");
INSERT INTO mgw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ywoywoti ywampokya mwana nnangu'ta kati yu' kwa lina lyangu', anipokya nenga.” ");
INSERT INTO mgw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ywoywoti ywaalu'a kumpanga yumo ywa bandu babaniu'bi'lya kati mwana apange sambi, yapanga nantali kuntabya liwe lya lwaga paingo na kuntumbukiya mubaali. ");
INSERT INTO mgw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mwakibona mwenga mwabandu ba pa dunia yi'no kwa kitumbu so panga makowe gagapangya bandu bapange sambi. ");
INSERT INTO mgw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Manaitei luboko au lugu'lu' ngalukupanga upange sambi, ulukate na kulutaikulya kuutalu na wenga. Nantali uyingi muukoto wangali luboko au lugu'lu' kuliko kukutaikulya mumwoto wangayomoka ubile nago moko na magu'lu. ");
INSERT INTO mgw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na liyo lyako mana likupangite upange sambi, uliyokwe na kulitaikulya kuutalu na wenga. Nantali yako uyingi muukoto ubile na liyo limo, kulikoni taikulwa mumwoto wangayomoka ubile na minyo gabi'li'.” ");
INSERT INTO mgw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mwili'ndi'le! Kane munsalawe yumo ywa bana asene ba. Nimmakianga, malaika babe akwo kunani babile nnu'ngi' ya Tati' bangu' masu'ba goti. ");
INSERT INTO mgw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwa mwanjaa Mwana wa Mundu aaisi kwakosopolya babaobite. ");
INSERT INTO mgw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Buli? Mundu mana abile na ngondolo mya yimo, na mana amwobiye yumo apanga buli? Aaleka balu' tisini na tisa kukitu'mbi' no yenda kumpala yu'lu' yumo ywaaobite? ");
INSERT INTO mgw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mana ampatike, kakape nimmakianga ampulaikya ywo kuliko balu' tisini na tisa babile nabo. ");
INSERT INTO mgw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na nyinyonyo, Tati' binu ba kunani bapendili ata yumo ywa bana asene ba aobe.” ");
INSERT INTO mgw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nnongogo mana akukosile, unnyendeli ukankwi'li'ke mubile kisinu. Mana akuyu'wine wapanga umpatike nnongo wako. ");
INSERT INTO mgw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mana akani kukuyu'wa, untole mundu yumo au abi'li' pamope na wenga, li'nga ‘Kwa ukong'ondeli wa bandu abi'li' au atatu kila iku'balo yabi'ki'lwa wiso,’ kati mwagabaya Maandiko Mapeleteu. ");
INSERT INTO mgw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mana akotwike kwayu'wa bo, ulibakiye kanisa. Na mana aaliyu'wali kanisa, na abe kwinu kati bandu bangali kuntanga Nnu'ngu' na alonga koli.” ");
INSERT INTO mgw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Kakape nimmakianga, lyolyoti lyamwalitaba padunia lyapanga litabilwe kunani, na lyolyoti lyamwaliyu'gu'lya padunia lyapanga liyu'gu'lilwe kunani. ");
INSERT INTO mgw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kai' nimmakianga panga, abi'li' nkati yinu mana bayi'ki'tyaniye lu'ba likowe lyolyoti pano padunia, Tati' bangu' ba kunani baalu'a kumpangya likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwa mwanjaa popoti palu' pabakongolekana bandu abi'li' au atatu kwa lina lyangu', nenga nibile pakati yabe.” ");
INSERT INTO mgw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bu'kapo Petili ngannyendelya Yesu na kunnaluya, “Buli, nnongo wangu' mana anikosile ninsami pali'nga? Mala saba yendali'ngana?” ");
INSERT INTO mgw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ngaanyangwa, “Nibayali mala saba bai, ila, ata saba mala sabini. ");
INSERT INTO mgw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa nyo, Ukulungwa wa Kunani ulandana na nkulungwa yumo ywaapalike kabwa isabu ya maleni ga atumisi bake. ");
INSERT INTO mgw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paatumbwi kabwa bai, ngaletelwa mundu yumo ywaabile na leni liku'lu' muno lyosindwa mundu kulili'pa. ");
INSERT INTO mgw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundu ywo abileli na sosoti so li'pa, kwa nyo bwana wake aamulise api'mi'yi'lwe ywembe, nnyumbowe, bana bake na ili'be yoti yaabile nayo, li'nga lili'pi'lwe leni lyo. ");
INSERT INTO mgw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bai ntumisi ywo ngakilikita nnu'ngi' yake kabaya, ‘Nilu'ba unikomeye nanenga nalu'a kuli'pa lileni lyoti.’ ");
INSERT INTO mgw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yu'lu' bwana ngaammi'kya kiya, kunsamya li'lu' leni na kunneka ayende kasake. ");
INSERT INTO mgw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lakini ntumisi ywo ngabu'ka na kunkolya yumo ywa atumisi aine ywaannongage lileni lisene. Ngammoywa na kuntangya paingo kabaya, ‘Uli'pe leni lyako!’ ");
INSERT INTO mgw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aywo ntumisi nyine ngakilikita na kunnu'ba kabaya, ‘Nikulu'ba unikomeye nanenga nalu'a kuli'pa.’ ");
INSERT INTO mgw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini ywembe ayi'ki'tili, ila aammi'kite munyumba ya atabilwe mpaka palu' paali'pa li'lu' leni. ");
INSERT INTO mgw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Bai, atumisi aine pabalibweni likowe lyo, baatiku'ku'li'ka muno, ngabayenda kummakia bwana wabe bu'kana na makowe go gagapitike. ");
INSERT INTO mgw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Apo, yu'lu' bwana aatikunkema aywo ntumisi, ngaammakia, ‘Wenga wantumisi nnau muno! Waatinilu'ba, nanenga nganikusamya leni lyako lyoti. ");
INSERT INTO mgw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Buli yali'nganili na wenga kummi'kya kiya ntumisi nnyino kati mwanikubi'ki kiya nenga?’ ");
INSERT INTO mgw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Bai, bwana ywo aatiusika muno, ngaampeleka kwa asikali aywo ntumisi apwatilwe mpaka paali'pa leni lyoti. ");
INSERT INTO mgw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na Tati' bangu' ba kunani baampangyanga nyinyonyo, manaitei yumo nkati yinu, ansamyali nnongowe kwa mwoyo wake woti.” ");
INSERT INTO mgw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu paayomwi longela ago, aabu'i ku Galilaya yenda lwingo lwa ku Yudea kwiyi' ya libi'ndi' lya Yordani. ");
INSERT INTO mgw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bandu baingi baatikunki'ngama kwo, naywembe ngaatepwa. ");
INSERT INTO mgw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bi'ngi' ba Mafalisayo baatikumwisilya, ngabannaluya kwa kumpi'ndi'ka, “Buli yendayi'ki'ti'lwa mundu kumpeya talaka nnyumbowe kwa kitumbu sosoti?” ");
INSERT INTO mgw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ngaayangwa, “Buli, munasomali mu Maandiko Mapeleteu panga Nnu'ngu' ywaamumbite mundu bu'ka kwai'mbu', aampangite nnalu'me na nnwawa, ");
INSERT INTO mgw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ngabaya, ‘Kwa kitumbu si' nnalu'me alu'a kwaleka tati' bake na mau' bake no lu'mbana na nnyumbowe, na abo abi'li' baapanga yi'ga yimo?’ ");
INSERT INTO mgw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kwa nyo, bembe abi'li' li kai', ila yi'ga yimo. Bai, sakilu'mbaniye Nnu'ngu', mundu kane alekanganiye.” ");
INSERT INTO mgw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lakini bembe ngabannaluya, “Tumbwe lelo mwanjaa buli Musa aamulise panga nnwawa apeyelwe talaka no lekelwa?” ");
INSERT INTO mgw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ngaayangwa, “Musa aannyi'ki'tiye kwaleka akinayumbo binu kwa kitumbu sa unonopau wa myoyo yinu. Lakini bu'ka kwai'mbu' yaabileli nyo. ");
INSERT INTO mgw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nanenga nimmakianga, ywoywoti ywaalu'a kunneka nnyumbowe, ila kwa mwanjaa ya upege, no kobeka nnwawa ywi'ngi' apanga ugoni.” ");
INSERT INTO mgw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Banamasi' bake ngabammakia, “Mana ipangite makowe ga nnalu'me na nnyumbowe nga nyo, nantali kotoka kobeka.” ");
INSERT INTO mgw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ngaabakia, “Boti li babakombwa kulipokya liyi'gi'yo li', ila balu' bai babayaliwite na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwa mwanjaa kubile na itumbu yambone yo kotoka kobeka. Bi'ngi' kwa mwanjaa babelekwi awaambende, bi'ngi' bapangilwe na bandu babe awaambende, na bi'ngi' baamwile kobekali kwa kitumbu sa Ukulungwa wa Kunani. Ywakombwa kulipokya liyi'gi'yo li'no, alipoki.” ");
INSERT INTO mgw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bu'kapo bandu ngabannetya Yesu bana anangu'ta li'nga aabi'ki moko na kwalu'bya. Lakini banamasi' bake ngabaakalipya. ");
INSERT INTO mgw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu ngabaya, “Mwaleke abo bana baise kasangu', wala kanemwakanikiye, kwa mwanjaa Ukulungwa wa Kunani ngawa bandu bababile kati bana ba.” ");
INSERT INTO mgw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bai, ngaabi'kya moko, bu'kapo ngabu'ka pandu po. ");
INSERT INTO mgw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu yumo aamwisili Yesu, ngaannaluya, “Mwalimu, nipange kili'be saku' kinogau li'nga niupate ukoto wangayomoka?” ");
INSERT INTO mgw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu ngammakia, “Mboni unilaluya bu'kana na likowe linogau? Yumo bai ywabile nnogau. Mana kaupala yingya muukoto wangayomoka, wikamwe amuli ya Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yu'lu' mundu ngaannaluya, “Amuli yaku'?” Yesu ngabaya, “Kaneubulage, kaneupange upege, kaneuyibe, kaneukong'ondeli ubu'su', ");
INSERT INTO mgw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","waisimu tati' bako na mau' bako, na umpende ywapapipi yako kati mwawipenda wamwene.” ");
INSERT INTO mgw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aywo mwinsembe ngammakia, “Ago goti nigakamwile, nipu'ngu'kilwe muno na ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ngammakia, “Mana upendi panga wantimya, uyende ukapi'mi'ye mali yako, ela yo waapei aki'ba, nawenga wabaa na amana kunani, bu'kapo uniki'ngame”. ");
INSERT INTO mgw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aywo mwinsembe paayu'wine ago aayi'i kasake abile kanyopa kwa mwanjaa abile na mali yambone. ");
INSERT INTO mgw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu ngaabakia banamasi' bake, “Kakape nimmakianga, yapanga nonopa kwa tayili yingya muukulungwa wa kunani. ");
INSERT INTO mgw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kai' nimmakianga, yapanga kwani ngamia pi'ta pa lipoyo lya singano kuliko tayili yingya muukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Balu' banamasi' pabayu'wine go baatisangala, ngabannaluya, “Nyai lelo ywakombwa kosopolelwa?” ");
INSERT INTO mgw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ngaalola, ngabaya, “Kwa mundu likowe li' liwesekanikali, lakini kwa Nnu'ngu' makowe goti gendawesekana.” ");
INSERT INTO mgw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bu'kapo Petili ngabaya, “Na twenga buli? Tugalei goti kukuki'ngama wenga, twaapata ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ngaabakia, “Kakape nimmakianga, Mwana wa Mundu paalu'a tama pakiti'gu' sake kitukupu sa lenji mudunia yayambi', mwenga mwamuniki'ngime mwaatama mwiiti'gu' ku'mi na ibi'li' kamwiukumu ngolo ku'mi na ibi'li' ya Isilaili. ");
INSERT INTO mgw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na kila mundu ywailei nyumba yake, mwasawe, nnu'mbu'we, tati', mau', bana, au migunda kwa kitumbu sa nenga aapokya mala mya no pi'ti'li'ki'a na aapata ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini baingi babalu'a baa alongoi baalu'a panga bansu'gu', na bansu'gu' bapanga alongoi.” ");
INSERT INTO mgw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ukulungwa wa Kunani ulandana na mundu mwene nng'unda ywaabu'i kindai' putiputi yenda kwayi'mi'ka apangakasi munng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ngayi'ki'tyana nabo kwali'pa mbanje dinali yimo kwa lisu'ba, bu'kapo ngaapeleka munng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Payikite saa itatu kindai', ngayenda kai' kusoko, na kwakolya bandu bi'ngi' bayi'mi wangali panga kasi. ");
INSERT INTO mgw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ngaabakia, ‘Namwenga, muyendange mukapange kasi munng'unda wangu', nanenga naalu'a kunni'pa aki yinu.’ ");
INSERT INTO mgw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bai ngabayenda. Mwene nng'unda ngabu'ka kai' musaa sita, na saa tisa kai' ngapanga nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ata musaa ku'mi na moja kitamwiyo, ngabu'ka kai', ngaakolya bi'ngi' balo bayi'mi pasoko wangali kasi. Ngaalaluya, ‘Mboni muyi'mi pano muntwekati yoti yi'no wangali panga kasi?’ ");
INSERT INTO mgw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngabannyangwa, ‘Kwa mwanjaa ntu'pu' mundu ywakutupeya kasi.’ Naywembe ngaabakia, ‘Na mwenga muyende mukapange kasi munng'unda wangu'.’ ");
INSERT INTO mgw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pakupilile, aywo mwene nng'unda ammakie mmi'ki wa mabi'ko gake, ‘Waakeme apangakasi na wali'pe nkwiso wabe. Utumbuli kwakema balu' ba kuundi'la, na uyomoli kwa balu' bawaalongoli kwayi'mi'ka.’ ");
INSERT INTO mgw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bai, ngabaisa balu' babaapeyilwe kasi musaa ku'mi na moja kitamwiyo, ngabapokya kila mundu mbanje dinali yimo. ");
INSERT INTO mgw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Balu' alongoi pabaikite, bakitage bapala peyelwa paku'lu', lakini nabembe baapeyilwe kila mundu dinali yimo. ");
INSERT INTO mgw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pabapoki mbanje yabe, ngabatumbwa kunku'ku'li'kya yu'lu' mwene nng'unda, ");
INSERT INTO mgw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ngababaya, ‘Aba bandu babakemilwe kukasi nsu'gu' yitu bapangite kasi kwa lisaa limo bai, nawenga wali'pite nsawani na twenga twatukomeyite tabu na lilumu lyoti lya muntwekati?’ ");
INSERT INTO mgw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Apo yu'lu' bwana ngannyangwa yumo ywabe, ‘Mbwiga, nakubonelali! Buli twayi'ki'tyanieli kukuli'pa dinali yimo? ");
INSERT INTO mgw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Utole aki yako, uyende. Nipendi kumpeya ayu' ywaisi nsu'gu' yi'yi'lu'yi'lu' kati yanikupei wenga. ");
INSERT INTO mgw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Buli, ntu'pu' aki yo tumya mali yangu' kati mwanipai? Au ubona bwigu kwa mwanjaa nenga na nnoga mwoyo?’” ");
INSERT INTO mgw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu ngayomolya kwo baya, “Kwa nyo, babaalu'a ba bansu'gu' baalu'a panga alongoi, na alongoi baalu'a panga bansu'gu'.” ");
INSERT INTO mgw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu paabile mundi'la yenda ku Yelusalemu, ngaakema banamasi' bake ku'mi na abi'li' pakisake, ngaabakia, ");
INSERT INTO mgw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mupi'kani! Tuyenda ku Yelusalemu, na akwo Mwana wa Mundu alu'a kamukiyilwa kwa api'ndo ba dini na balimu ba salya, nabembe baalu'a kumuukumu kiwo. ");
INSERT INTO mgw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Baalu'a kunkamukiya kwa bandu bangali Ayahudi li'nga asalangilwe, aku'mbu'lwe mikwasu no bambilwa, lakini lisu'ba lyenetatu aalu'a yu'yi'lwa.” ");
INSERT INTO mgw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Apo, mau' babe bana ba Zebedayo, baamwisili Yesu pamope na bana bake. Ngakilikita nnu'ngi' yake, na kunnu'ba kili'be. ");
INSERT INTO mgw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu ngannaluya, “Upala namani?” Aywo mau' ngammakia, “Sonde, wayi'ki'ti'ye bana bangu' ba batame, yumo kummalyo na ywi'ngi' kunki'ya, muukulungwa wako.” ");
INSERT INTO mgw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ngayangwa, “Mwenga mulitangiteli lyamulilu'ba. Buli, mwendakombwa nnywelya nnobo wa ngu'su'mbu' wa naalu'a nnywelya nenga?” Ngabayangwa, “Twendakombwa.” ");
INSERT INTO mgw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ngaabakia, “Kakape mwaalu'a kombwa nywelya nnobo wanaalu'a nywelya nenga, lakini tama kummalyo au kunki'ya wangu', alyo lyengo lyangu'li. Ila Tati' bangu' babi'i wiso lipala lyo tama bandu bo baalu'a kwasawa.” ");
INSERT INTO mgw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Balu' banamasi' bi'ngi' ku'mi pabayu'wine go, ngabaausikya abo alongo abi'li'. ");
INSERT INTO mgw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kwa nyo Yesu ngaakema na kwabakia, “Mutangite panga atawala ba bandu bangali Ayahudi batawala bandu babe kwa makakala, na api'ndo babe baalaya makakala gabe. ");
INSERT INTO mgw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini kwinu mwenga, kaneibe nyo, ila ywapala panga nku'lu' nkati yinu, apalikwa abe ntumisi winu, ");
INSERT INTO mgw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na ywapala panga nnongoi nkati yinu, aapalikwa abe mmanda winu. ");
INSERT INTO mgw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwa mwanjaa Mwana wa Mundu aaisili li'nga tumikilwa, ila tumikia no pi'ya bwu'mi wake ube mali'po ga kwakombwa bandu baingi li'nga bakosopolelwe.” ");
INSERT INTO mgw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na banamasi' bake pabaabile kababu'ka ku kilambo sa Yeliko, lipi'nga liku'lu' lya bandu lyaatikunki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bai, kwaai na kimbulibuli abi'li' baatami mbwega ya ndi'la, na pabayu'wine panga Yesu aabile kapi'ta ngabau'bu'ya lilobe, kababaya, “Bwana, Mwana wa Daudi, utubi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Li'lu' lipi'nga lya bandu ngalyaakalipya na kwabakia batame liki. Lakini bembe ngabayongeya u'bu'ya lilobe, kababaya, “Bwana, Mwana wa Daudi, utubi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ngayi'ma, kwakema na kwabakia, “Mupala nimpangi ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngabannyangwa, “Bwana, tulu'ba tepulwa minyo gitu.” ");
INSERT INTO mgw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ngaabi'kya kiya, na kwakunywa minyo gabe, saa yi'yi'lu'yi'lu' ngabalola, nabembe ngabanki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na banamasi' bake pabaabile kabaegelya ku Yelusalemu no ika Bethfage ku Kitu'mbi' sa Minjaituni, ngaatuma banamasi' bake abi'li', ");
INSERT INTO mgw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ngaabakia, “Muyende mpaka kukilambo sakibile nnu'ngi' yinu, pamutumbwa yingya bai, mukammona mbu'nda abile pamope na likinda lyake batabilwe. Mukaundwe na munileti pano'. ");
INSERT INTO mgw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mana mundu alu'a kunnaluya kitumbu, mwammakie, ‘Bwana endakwapala,’ naywembe popopo alu'a kunnyi'ki'ti'yanga.” ");
INSERT INTO mgw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Likowe li' lyaapangike li'nga galu' gagaabayilwe na nnondoli ywa Nnu'ngu' gatimi, ");
INSERT INTO mgw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mukibakie kilambo sa Sayuni, “Linga, nkulungwa wako endaisa! Ywembe ntu'lya na au'bwi'ke mbu'nda, na mwana wa mbu'nda.” ");
INSERT INTO mgw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kwa nyo, balu' banamasi' ngabapanga kati mwababakiyilwe. ");
INSERT INTO mgw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngabanneta yu'lu' mbu'nda na mwana wake, ngabatandika magu'bo panani ya abo mbu'nda abi'li', na Yesu ngatama panani ya ngu'bo. ");
INSERT INTO mgw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lipi'nga liku'lu' lya bandu baatandike magu'bo gabe, na bi'ngi' baapalwi ndambi' ya mikongo no tandika musimbasimba. ");
INSERT INTO mgw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lipi'nga lya bandu babaalongolile na balu' babanki'ngime ngabau'bu'ya lilobe, kababaya, “Lilumbo kwa Mwana wa Daudi! Ayaliwite aywo ywaisa kwa lina lya Bwana! Lilumbo kwa Nnu'ngu' kunani!” ");
INSERT INTO mgw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu paabile kayingya ku Yelusalemu, malango ga bandu pakilambo soti gaatiyelenganika, bandu ngabalaluyana, “Ayu' nga nyai?” ");
INSERT INTO mgw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kipi'nga sa bandu ngakibaya, “Ayu' nga nnondoli wa Nnu'ngu' Yesu, bu'ka Nasaleti kilambo sa ku Galilaya.” ");
INSERT INTO mgw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bai, Yesu ngayingya munyumba ya Nnu'ngu', ngaabi'ngya panja bandu babaabile kabapi'mi'ya no pi'ma ili'be munyumba ya Nnu'ngu', ngapi'li'ngwana mesa ya balu' babaabile kabapunja mbanje, na iti'gu' ya balu' babaabile kabapi'mi'ya ngunda. ");
INSERT INTO mgw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ngaabakia, “Iandikilwe mu Maandiko Mapeleteu, ‘Nyumba yangu' yaakemelwa nyumba ya salilya,’ lakini mwenga muipanga ibe lipango lya apokonyoli.” ");
INSERT INTO mgw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kimbulibuli na alemau bi'ngi' ngabannyendelya akwo kunyumba ya Nnu'ngu', nembe Yesu ngaatepwa. ");
INSERT INTO mgw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bai, api'ndo ba dini na balimu ba salya pabagabweni mangelongelo gaapangite Yesu, na bana pabaabile kabau'bu'ya malobe gabe munyumba ya Nnu'ngu', kababaya, “Lilumbo kwa Mwana wa Daudi,” ngabamusikya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kwa nyo ngabannaluya Yesu, “Buli, wendakugayu'wa gabagabaya bana?” Yesu ngayangwa, “Elo, nendayu'wa! Buli aga Maandiko munasomali? ‘Kwa mikano ya bana anangu'ta na bana ilekeleke, wipatya lilumbo lyako.’” ");
INSERT INTO mgw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bai, ngaaleka no pitya panja ya kilambo yenda Betania, na akwo ngagonja. ");
INSERT INTO mgw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pammalau' yake kindai', Yesu paabile kaki'li'bu'kya ku Yelusalemu, ngaminya njala. ");
INSERT INTO mgw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ngaubona ntini gumo mbwega ya ndi'la, ngauyendelya, lakini aukoli ntu'pu' itunda, ila maakapi sika. Bai ngaubakia, “Katu kaneupambike kai' itunda!” Na papalu'palu' wu'lu' ntini ngauyu'ma. ");
INSERT INTO mgw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Banamasi' pabaubweni, ngabasangala kababaya, “Kwa mwanjaa namani ntini wu' uyu'mite kwa kiimuimu?” ");
INSERT INTO mgw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ngaayangwa, “Kakape nimmakianga, mana mwapanga na imani wangali kyukala, mwawesa kai' kwo panga nya baili, ila ata mana mukibakie kitu'mbi' si', ‘Yokoka ukaitumbukiye mubaali,’ ilu'a pangika. ");
INSERT INTO mgw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na mana mubile na imani, sosoti samwaalu'a lu'ba kwa sala mwaalu'a pata.” ");
INSERT INTO mgw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu payingi munyumba ya Nnu'ngu', ai kayi'gana. Paabile kayi'gana, api'ndo ba dini na api'ndo ba bandu ngabannaluya, “Upanga makowe ga kwa makakala ga nyai? Na nyai ywakupeile makakala ga?” ");
INSERT INTO mgw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ngaayangwa, “Nanenga nilu'a kunnaluya liswali limo, mana muniyangwile, bai na nani naalu'a kummakia nipanga makowe ga kwa makakala ga nyai. ");
INSERT INTO mgw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Buli Yoani aapatike kwa nyai makakala go batisa? Buli gaabu'i kunani au kwa bandu?” Lakini ngabalaluyana bene na bene kababaya, “Mana tubaite, ‘Gaabu'i kunani,’ Alu'a tulaluya, ‘Buli mboni mwaamwu'bi'lili?’ ");
INSERT INTO mgw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na mana tubaite, ‘Gaabu'kite kwa bandu,’ tuyogopa kipi'nga sa bandu, kwa mwanjaa boti bendayi'ki'tya panga Yoani nga nnondoli wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bai ngabannyangwa, “Tutangiteli.” Naywembe ngaabakia, “Nanenga nyinyonyo nimmakiali panga nipanga makowe ga kwa makakala gaku'. ");
INSERT INTO mgw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwenga mwibona buli? Mundu yumo aai na bana abi'li'. Ngammakia yu'lu' mwana mmele, ‘Mwana wangu', li'no uyende ukapange kasi munng'unda wa minjabibu.’ ");
INSERT INTO mgw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yu'lu' mwinsembe ngammakia, ‘Niyendali!’ Lakini bu'ka po ngagalambwa maganio gake, ngayenda panga. ");
INSERT INTO mgw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bu'kapo yu'lu' tati' ngammakia mwana wake wenebi'li' nyinyonyo, naywembe ngayangwa, ‘Eloo tati'!’ Lakini aayi'ili. ");
INSERT INTO mgw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Buli, ywaku' kati ya abi'li' ba ywapangite kati mwabapalage tati' babe?” Ngababaya, “Yu'lu' mwana mmele.” Bai, Yesu ngaabakia, “Kakape nimmakianga, alonga koli na apege baalu'a kunnongolya yingya muukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwa mwanjaa Yoani aaisi kasinu kunnaya ndi'la ya aki yo lama, lakini mwenga mwaamwu'bi'lili, ila alonga koli na apege baatikumwu'bi'lya. Lakini mwenga ata pamwaagabweni ago goti mwagalambwikeli no u'bi'lya.” ");
INSERT INTO mgw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu ngabaya, “Mupi'kani lukongo lwi'ngi'. Mundu yumo mwene nyumba aali'mite nng'unda wa minjabibu, ngati'li'ti'ya lubi'go, no tengenesa pandu po komangya minjabibu li'nga ipiye divai, no senga kisewe. Bu'kapo ngaakolisa ali'mi, no yabwa mwanja wa kunni'ma wi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pawikite nsimu wo una, aatumike atumisi bake kwa balu' ali'mi, li'nga bampei mauno gake. ");
INSERT INTO mgw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Balu' ali'mi ngabaaboywa abo atumisi, yumo ngabanku'mbwa, ywi'ngi' ngabammulaga na ywi'ngi' ngabanku'mbwa maliwe mpaka waa. ");
INSERT INTO mgw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aywo mundu ngaatuma kai' atumisi bi'ngi', bambone kulikoni balu' alongoi. Balu' ali'mi ngabaapangya kai' nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuundi'la, ngantuma mwana wake, kabaya, ‘Ndangite panga baalu'a kumwisimu mwana wangu'.’ ");
INSERT INTO mgw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini balu' ali'mi pabamweni mwana wake, ngababakiana bene na bene, ‘Ayu' nga nnisi, satummulage li'nga tuutole twenga ulisi wake!’ ");
INSERT INTO mgw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bai, ngabammoywa na kumpiya panja ya wu'lu' nng'unda wa minjabibu, ngabammulaga. ");
INSERT INTO mgw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Kwa nyo, aywo mwene nng'unda wa minjabibu paalu'a isa, alu'a kwapanga namani abo ali'mi?” ");
INSERT INTO mgw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bembe ngabannyangwa, “Alu'a kwabulaga abo bandu alau pangali kiya, na wu'lu' nng'unda alu'a kwakolisa ali'mi bi'ngi' babaalu'a kumpeya mauno gake nsimu waupalikwa.” ");
INSERT INTO mgw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Apo Yesu ngaabakia, “Buli, munasomali likowe li' mu Maandiko Mapeleteu? ‘Liwe lyabalikani asengi, nambi'yambi' lipangite liwe liku'lu' lya pakitumembe. Bwana ngaywapangite likowe li', nalyembe nga lya ayabu muno kasitu!’ ");
INSERT INTO mgw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kwa nyo nimmakianga, Ukulungwa wa Nnu'ngu' walu'a bu'yi'lwa kasinu no peyelwa bandu bi'ngi' babaabeleya itunda yake.” ");
INSERT INTO mgw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ywaatu'mbu'kya panani ya liwe li' alu'a ti'kwanika ipande ipande, na yu'lu' ywaatu'mbu'ki'lwa, lyalu'a kuntimbinywa. ");
INSERT INTO mgw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Api'ndo ba dini na Mafalisayo pabayu'wine ayo ngongo yake, ngabakwipwa panga, aabile kalongela makowe go bu'kana na bembe. ");
INSERT INTO mgw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kwa nyo, baabini pala kummoywa, lakini baayogwipe bandu kwa mwanjaa bembe baau'bi'li panga ywembe nnondoli ywa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ngayendelya longela na li'lu' lipi'nga lya bandu kwa ngongo, kaabakia, ");
INSERT INTO mgw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ukulungwa wa Kunani ulandana na nkulungwa yumo ywaampangi mwana wake si'li'ku'si'li'ku' ya lisengele. ");
INSERT INTO mgw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bai, ngaatuma atumisi bake kwakema balu' babaakokilwe isa kulisengele, lakini baatikana isa. ");
INSERT INTO mgw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngaatuma kai' atumisi bi'ngi', kabaya, ‘Mwabakie balu' babaakokilwe panga si'li'ku'si'li'ku' yangu' niyomwile bi'ka wiso, nisinjike ng'ombe na makinda gagaatike, baisange bai.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini balu' babaakokilwe baasitwikeli, ngabayenda kila mundu kundu kwake, yumo kunng'unda wake na ywi'ngi' kunsuluso wake, ");
INSERT INTO mgw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na bi'ngi' ngabaaboywa balu' atumisi, ngabaapwi'wa, na kwabulaga. ");
INSERT INTO mgw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yu'lu' nkulungwa ngausika, aatumike asikali bake bakaabulage abo abulagi, no langamisa kilambo sabe kwa mwoto. ");
INSERT INTO mgw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bu'kapo ngaabakia atumisi bake, ‘Si'li'ku'si'li'ku' ya lisengele ibi'kilwe wiso, lakini balu' babaakokilwe baapwaikeli. ");
INSERT INTO mgw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bai, muyende pamalekano ga simbasimba, na boboti bamwaalu'a kwabona mwakemi baise kulisengele.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Balu' atumisi ngabapita, yenda mumali'la, ngabaaleta bandu boti, anogau na alau. Nyumba ya lisengele ngaitwi'lya ageni. ");
INSERT INTO mgw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nkulungwa paayingile li'nga kwabona ageni, ngammona mundu yumo aai anawalali ngu'bo ya lisengele. ");
INSERT INTO mgw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nkulungwa ngannaluya, ‘Mbwiga, uyingi kitiwi pano wangali wala ngu'bo ya lisengele?’ Lakini ywembe annyangwili. ");
INSERT INTO mgw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Apo nkulungwa ngaabakia atumisi bake, ‘Muntabe magu'lu' na maboko, mukantaikuli panja palubi'ndu', akwo alu'a li'la no yaga mino.’” ");
INSERT INTO mgw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu ngayomolya kwo baya, “Bandu babakokilwe bambone, lakini babasaulilwe asene.” ");
INSERT INTO mgw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bu'kapo, Mafalisayo ngabayenda sikisana li'nga bapate kunnyonja Yesu mumayi'gi'yo gake. ");
INSERT INTO mgw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bai, ngabaatuma apwasi babe pamope na bandu babaalu'mbi'ne na kipi'nga sa Helode. Ngabannaluya, “Mwalimu, tutangite panga wenga wa mundu wa kakape, na uyi'gana ndi'la ya Nnu'ngu' kwa ukakape. Unnyogopali mundu ywoywoti kwa mwanjaa uyi'me wa mundu kili'be lili kasako. ");
INSERT INTO mgw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aya, utubakie mwawibona wenga, buli yendayi'ki'ti'lwa au lili twenga li'pa koli kwa Kaisali?” ");
INSERT INTO mgw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lakini Yesu autangite ulau wababiniage, ngaayangwa, “Mwenga mwaanapiki, mwanjaa namani munipi'ndi'ka? ");
INSERT INTO mgw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munilaye mbanje yo li'pya koli.” Nabembe ngabannetya lwela. ");
INSERT INTO mgw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Naywembe ngaalaluya, “Kuminyo ku' na lina li' lyaliandikilwe pa lya nyai?” ");
INSERT INTO mgw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngabannyangwa, “Ya Kaisali.” Bai Yesu ngaabakia, “Mumpei Kaisali yaibile ya Kaisali, na ya Nnu'ngu' yaibile ya Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pabayu'wine nyo, ngabasangala muno, ngabanneka Yesu no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lisu'ba lyo bi'ngi' ba Masadukayo, bababaya panga awi'li baalu'a yu'kali, bannyendeli Yesu, ");
INSERT INTO mgw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ngabammakia, “Mwalimu, Musa aabaite panga, ‘Mundu ywakobike mana awile wangali papa mwana, ipalikwa nnongo wake ankobeke aywo mau' nng'wi'li'kwa, li'nga ampapi nnongowe bana.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bai, pano pakasitu kwaabile na alongo saba. Yu'lu' nnongoi belekwa aatikobeka bu'kapo ngawaa pangali papa mwana, ngannekya nnunawe aywo nnwawa nng'wi'li'kwa. ");
INSERT INTO mgw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngaipitya kai' nyinyonyo, kwa nnongo ywenebi'li', na ywenetatu mpaka ywa saba. ");
INSERT INTO mgw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bu'ka po waa abo alongo boti, ngawaa kai' na yu'lu' mau'. ");
INSERT INTO mgw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Buli, lisu'ba lya awi'li pabaalu'a yu'ka, mau' yu' alu'a panga nnyumbowe nyai mwa balu' alongo saba? Kwa mwanjaa abo boti saba baankobike nnwawa ywo.” ");
INSERT INTO mgw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ngaayangwa, “Mwenga mukosea, kwa mwanjaa mugatangiteli Maandiko Mapeleteu wala uweso wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwa mwanjaa awi'li pabaalu'a yu'ka baakobekali wala baaku'ndali, kati mwababile malaika ba kunani. ");
INSERT INTO mgw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini kwa uyu'ki wa awi'li, buli munasomali galu' gamwaabakiyilwe na Nnu'ngu'? Ammakie, ");
INSERT INTO mgw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenga na Nnu'ngu' ywa Bulaimu, Nnu'ngu' ywa Isaki na Nnu'ngu' ywa Yakobi.’ Bai, ywembe Nnu'ngu' ywa awi'li lili, ila ywembe Nnu'ngu' ywa akoti.” ");
INSERT INTO mgw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Si'lu' kipi'nga sa bandu pasaayu'wine nnya, ngakisangala muno mayi'gano gake. ");
INSERT INTO mgw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafalisayo pabayu'wine panga Yesu aatamike liki Masadukayo, Mafalisayo ngabakwembana pamope. ");
INSERT INTO mgw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumo ywabe, ywaabile mwalimu wa salya, ngannaluya Yesu kwa kumpi'ndi'ka, kabaya, ");
INSERT INTO mgw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mwalimu, amuli yaku' musalya yaibile ngu'lu' pi'ta yoti?” ");
INSERT INTO mgw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ngannyangwa, “‘Umpende Bwana Nnu'ngu' wako kwa mwoyo wako woti, kwa loo yako yoti na kwa malango gako goti.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yi'no nga amuli yaibile ngu'lu', kai' nga nnongoi. ");
INSERT INTO mgw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na yenebi'li' ilandana na ayo, ‘Umpende ywapapipi yako kati mwawipenda wenga wamwene.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Salya yoti ya Musa na mayi'gano ga alondoli ibu'kana na amuli ibi'li' yi'.” ");
INSERT INTO mgw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo pabaabile kabakwembana pamope, Yesu ngaalaluya, ");
INSERT INTO mgw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mugania buli bu'kana na Kilisitu? Ywembe mwana wa nyai?” Ngabannyangwa, “Ywembe nga mwana wa Daudi.” ");
INSERT INTO mgw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu ngaabakia, “Tumbwe, iwesekana buli Daudi mana alongoyilwe na Loo Mpeleteu ankema ‘Bwana’? Kwa mwanjaa aabaite, ");
INSERT INTO mgw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bwana Nnu'ngu' ammakie Bwana wangu', Utame kummalyo gangu', mpaka panaalu'a kwabi'ka andumu bako pai' ya magu'lu' gako.’ ");
INSERT INTO mgw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Bai, Daudi ankema Kilisitu ‘Bwana,’ kwa nyo Kilisitu apangali mwana wake bai, ila Bwana wake kai', au lili?” ");
INSERT INTO mgw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bai, ntu'pu' ata mundu yumo ywakombwi yangwa kili'be, kai' tumbulya lisu'ba lyo ntu'pu' mundu ywaalowite kunnaluya liswali. ");
INSERT INTO mgw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bu'kapo Yesu ngakibakia kipi'nga sa bandu na banamasi' bake, ");
INSERT INTO mgw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Balimu ba salya na Mafalisayo baina uweso wo awanikia salya ya Musa, ");
INSERT INTO mgw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","kwa nyo, mugakamwe na kugakoleya galu' gabaalu'a kummakianga. Lakini kanemukoleye iyendo yabe, kwa mwanjaa bakoleyali galu' gabagaala. ");
INSERT INTO mgw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bataba igombo ndopau na kwatwi'ka bandu mmapamba, lakini bene bo bakani ata pasene tu'ndu'bi'ya lukonji kwayangatia pu'twa. ");
INSERT INTO mgw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bembe bapanga makowe gabe goti li'nga babonekane na bandu. Bawala tusanduku twene maandiko ga salya pakibu'ngi' na mmoko, no wala nganju yene mipembo milaso kulikoni bandu bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bapendi tama pandu pa isima muiyambo no tama muiti'gu' ya nnu'ngi' munyumba ya kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bapendi pangilwa abali kwa isima kusoko no kemelwa na bandu, ‘Mwalimu.’ ");
INSERT INTO mgw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini mwenga kanemuyi'ki'ti kemelwa, ‘Mwalimu,’ kwa mwanjaa mwenga mwaboti mwa alongo na Mwalimu winu yumo bai. ");
INSERT INTO mgw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nyinyonyo kanemunkeme mundu ywoywoti, ‘tati',’ pano padunia, kwa mwanjaa Tati' binu bamo bai bababile kunani. ");
INSERT INTO mgw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala kanemukemelwe, ‘Kolongosi,’ kwa mwanjaa kolongosi winu nga yumo bai, naywembe nga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ywembe ywabile mpi'ndo kwinu apalikwa abe ntumisi winu. ");
INSERT INTO mgw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na ywoywoti ywaalu'a kwiu'bu'ya auluyilwa, na ywaalu'a kwiuluya alu'a u'bu'yi'lwa. ");
INSERT INTO mgw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mwakibona mwenga mwa balimu ba salya na Mafalisayo mwa anapiki! Muuyigala nniango wa Ukulungwa wa Kunani. Mwenga mwabene muyingyali nnyumba na ata balu' babapala yingya mwendakwaibya.” ");
INSERT INTO mgw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mwakibona mwenga mwa balimu ba salya na Mafalisayo, mwa anapiki! Muyabwa mwanja wa kuutalu li'nga kumpata mwanamasi' yumo, lakini bu'ka pa kumpata, mumpanga abe mumwoto wangayomoka kulikoni mwenga. ");
INSERT INTO mgw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mwakibona mwenga mwa alongosi mbulibuli! Mwenga mubaya, ‘Mundu mana alapite kwa Nyumba ya Nnu'ngu', kilapo sake kili'be lili, lakini mundu mana alapite kwa zaabu yayabile munyumba ya Nnu'ngu', aitabite kwa kilapo sake.’ ");
INSERT INTO mgw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwenga mwa kimbulibuli, mwalogeloge! Saku' sa ngama muno, maliwe gagaleta mbanje au yi'lu' nyumba ya Nnu'ngu' yaipanga maliwe gagaleta mbanje gapange mapeletau? ");
INSERT INTO mgw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kai' mubaya ati' mundu mana alapite katambwa kibi'ki'lyo, kili'be lili, lakini mana alapite katambwa salaka yaibile kunani yake, aapalikwa timisa kilapo sake. ");
INSERT INTO mgw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwenga mwakimbulibuli! Saku' sakibile sangama muno, yi'lu' salaka au kibi'ki'lyo sakipangya ayo salaka ibe mbeletau? ");
INSERT INTO mgw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kwa nyo, mundu ywalapa kwa kibi'ki'lyo, alapa kwa aso kibi'ki'lyo na ili'be yoti yaibile panani yake. ");
INSERT INTO mgw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naywembe ywalapa kwa Nyumba ya Nnu'ngu', alapa kwa ayo Nyumba ya Nnu'ngu' na kwa aywo ywatama nkati yake. ");
INSERT INTO mgw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naywembe ywalapa kwa kunani, alapa kwa kiti'gu' sa lenji ya Nnu'ngu' na kwa ywembe ywatama panani ya kiti'gu' so. ");
INSERT INTO mgw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mwakibona mwenga mwa balimu ba salya na Mafalisayo, mwa anapiki! Kwa mwanjaa mumpeya Nnu'ngu' saka ya ndakyo, lakini mugaleka makowe maku'lu' ga salya, yani aki, kiya na imani. Yaapalikwe panga wi'ti' aga maku'lu' ga salya pangali kugaleka ago gi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwenga mwaalongosi mbulibuli! Mulopwa libembe mukinywo, lakini ngamia mwendakummila. ");
INSERT INTO mgw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mwakibona mwenga mwa balimu ba salya na Mafalisayo, mwa anapiki! Mugu'lwa nnobo na ibakuli kwa panja, lakini mukuleka nkati kwakutwi'li upokonyoli na matamanio manyatau. ");
INSERT INTO mgw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wenga wa Falisayo mbulibuli! Ugu'lwe wi'ti' nnobo na kibakuli kwa nkati, na panja kwaalu'a baa kupeleteu. ");
INSERT INTO mgw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mwakibona mwenga mwa balimu ba salya na Mafalisayo, mwaanapiki! Mulandana na masiko gagapakayilwe swakala, gembe gendanogelelya kwa panja, lakini nkati kutwi'li yupa ya awi'li na usapu wa kila lukolo. ");
INSERT INTO mgw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nga nyinyonyo na mwenga, panja mubonekana panga mwabandu anogau, lakini nkati yinu mutwi'li unapiki na ulau. ");
INSERT INTO mgw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mwakibona mwenga Mafalisayo na balimu ba salya, mwa anapiki! Mwamusenga masiko ga alondoli ba Nnu'ngu' na kuganemeka masiko ga bene aki. ");
INSERT INTO mgw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na mwenga mubaya, ‘Na twenga ikapangage tubile nsimu wa kiu'ku'lu' bitu, tulu'e yi'ki'tyanali nabo mumakowe go bulaga alondoli ba Nnu'ngu'!’ ");
INSERT INTO mgw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kwa nyo, mwikong'ondelya mwabene panga mwenga mwa lukolo lwa balu' babaabulige alondoli ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aya lelo, muyomoli li'lu' lyengo lyabalitumbwi kiu'ku'lu' binu! ");
INSERT INTO mgw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenga mwa lukolo lwa nng'ambo, mwaiyepabuli ukumu ya mwoto wangayomoka? ");
INSERT INTO mgw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa mwanjaa nya naatuma kwinu alondoli ba Nnu'ngu' na bene ikima na balimu. Bi'ngi' babe mulu'a kwabulaga na kwabamba, na bi'ngi' babe mulu'a kwamesa mikwasu mumayumba ginu ga kunnu'ba Nnu'ngu', na kwaaka bu'ka ku kilambo simo mpaka kukilambo si'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kwa nyo yi'lu' myai ya bene aki yaiyitanike pano padunia, tumbulya Abeli ywaai mwene aki, mpaka myai ya Zakalia mwana wa Balakia ywamummulige pakati ya papeleteu munyumba ya Nnu'ngu' na pakibi'ki'lyo, myai yabe yoti yaalu'a kummi'kya lukoolo. ");
INSERT INTO mgw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kakape nimmakianga, makowe aga goti gaalu'a pangika kwa lubelekwo lu'no. ");
INSERT INTO mgw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu! Ee Yelusalemu! Wabulaga alondoli ba Nnu'ngu' na kwaku'mbwa maliwe balu' babatumilwe kasako! Pali'nga panipalite kwakongolya bana bako pamope, kati mu'lu' ngu'ku' mwaakongolya bana bake pai' ya mapapayo gake, lakini waapaili. ");
INSERT INTO mgw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lingulya nambi'yambi', nyumba yinu iyu'kite kyame. ");
INSERT INTO mgw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kwa mwanjaa nimmakianga, tumbulya nambi'yambi' mwalu'a nibonali kai' mpaka pamwaalu'a baya, ‘Ayaliwite ayu' ywaisa kwa lina lya Bwana.’” ");
INSERT INTO mgw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ngapita munyumba ya Nnu'ngu', na paabile kabu'ka banamasi' bake ngabannyendelya li'nga kunnaya uku'lu' wa mayumba ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lakini Yesu ngaabakia, “Buli, mwendakugabona aga goti? Kakape nimmakianga, lyaigalali ata liwe limo panani ya li'ngi', goti gaalu'a sengemwanilwa.” ");
INSERT INTO mgw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu paabile atami pa Kitu'mbi' sa Minjaituni, banamasi' bake ngabannyendelya pakisake, ngabannaluya, “Tubakia makowe ga galu'a pitya pakubawi? Mwasu waku' wawaalu'a tulaya kwo isa kwako na kuundi'la ya dunia?” ");
INSERT INTO mgw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ngaayangwa, “Mwili'ndi'le mwakane kongelwa na mundu. ");
INSERT INTO mgw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwa mwanjaa bandu bambone baalu'a isa kwa lina lyangu', kababaya, ‘Nenga nga Kilisitu,’ Nabembe baalu'a kwakonga bandu bambone. ");
INSERT INTO mgw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mulu'a yu'wa makowe ga ngondo na mayu'yu'to gake, lakini kanemwayogope. Kwa mwanjaa aga goti gapalikwa pitya, lakini kuundi'la yake balo. ");
INSERT INTO mgw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwa mwanjaa nni'ma gumo waalu'a ku'mbwana na nni'ma wi'ngi', ukulungwa gumo waalu'a ku'mbwana na ukulungwa wi'ngi'. Na pandu mbali'mbali' paalu'a baa njala na ntikotiko wa bwi'. ");
INSERT INTO mgw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aga goti gaalu'a panga kati mwalutumbwa lwu'ngu' lwo papa mwana. ");
INSERT INTO mgw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bu'kapo bandu baalu'a kumpiya li'nga mupate ngu'su'mbu' no bulagilwa, na bandu boti baalu'a kunsukya kwa kitumbu sa lina lyangu'. ");
INSERT INTO mgw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kai' bandu bambone baalu'a kwileka imani yabe, baalu'a songyana bene na bene no sukyana. ");
INSERT INTO mgw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Baalu'a pitya alondoli bambone ba ubu'su', nabembe baalu'a kwakonga bandu baingi. ");
INSERT INTO mgw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa mwanjaa yo yolokana kwa ulau, upendo wa bandu baingi waapu'ngwa. ");
INSERT INTO mgw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini ywaalu'a komeya mpaka kuundi'la ngaywaalu'a kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yi'no abali ya Ukulungwa wa Nnu'ngu' yaalu'a alilwa mudunia yoti kati ukong'ondeli kwa mili'ma yoti. Apo ngapapaalu'a isa kuundi'la ya dunia. ");
INSERT INTO mgw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kwa nyo, mwalu'a kibona kili'be sakisukwa Nnu'ngu' na sakileta usapu kiyi'mi pandu papeleteu kati mwaabaite nnondoli ywa Nnu'ngu' Danieli, (Ywasoma na atange). ");
INSERT INTO mgw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Bai, pamwakibona, babaalu'a baa ku Yudea baabutuki muitu'mbi'. ");
INSERT INTO mgw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ywabile panani ya mwagala wa nyumba yake, kaneauluke tola kili'be sosoti nnyumba yake. ");
INSERT INTO mgw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na mundu ywabile munng'unda kaneabuye kasake tola ngu'bo yake. ");
INSERT INTO mgw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mumasu'ba go, baakibona balu' akina mau' atopelwa na babayongeya! ");
INSERT INTO mgw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Munnu'be Nnu'ngu' li'nga butuka kwinu kanekwabee nsimu wa mbepo au lisu'ba lya Sabato. ");
INSERT INTO mgw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwa mwanjaa nsimu wo kwaalu'a baa na siki ngu'lu' nayembe inapityali bu'ka umbilwa kwa dunia mpaka nambi'yambi', na wala yaapityali kai'. ");
INSERT INTO mgw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ikapangage Nnu'ngu' akotwike pu'ngu'ya masu'ba go, ntu'pu' ata mundu yumo ywapalage kosopolelwa. Lakini kwa kitumbu sa balu' babasaulilwe, masu'ba go gapu'ngu'yilwe. ");
INSERT INTO mgw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nsimu wo manaitei mundu ywoywoti ammakie, ‘Lingulya, Kilisitu abile pano,’ au ‘Abile palu',’ kanemwamwu'bi'li. ");
INSERT INTO mgw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa mwanjaa baalu'a pitya Kikilisitu ba ubu'su' na alondoli ba ubu'su', baalu'a panga myanju miku'lu' na mangelongelo go kombwa kwaobeya bandu, kai' ata kwakonga balu' babasaulilwe na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pi'kania, niyomwile kunkwi'li'ka gabile balo pitya. ");
INSERT INTO mgw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bai, mana bammakiangite, ‘Lingulya, ai kulubele,’ kanemuyende, au mana abaite ‘Lingulya ayu'bite nnyumba,’ kanemwau'bi'li. ");
INSERT INTO mgw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwa mwanjaa yapanga kati mwaibeyulya njai bu'ka kumbwani no bonekana mpaka kundondi, ngamwayapanga isa kwake Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tai bakongolekana palu' paubile ntwi. ");
INSERT INTO mgw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bu'ka pa siki ya masu'ba galu', lisu'ba lyagubikilwa na lubi'ndu', mwei waalu'a piyali bweya, ndondwa yaalu'a tu'mbu'ka bu'ka kumaunde, makakala go goti ga kunani galu'a tikatika. ");
INSERT INTO mgw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bu'kapo mwasu wa Mwana wa Mundu waalu'a bonekana kumaunde, na apo makabila goti mudunia gaalu'a lombola muno kummona Mwana wa Mundu kaisa kunani ya maunde, mwene makakala na utukupu wambone. ");
INSERT INTO mgw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naywembe aatuma malaika bake bene matalumbeta gagayu'wanika muno, li'nga baakongwe bandu baasawile Nnu'ngu' bu'ka mumbande nsese ya dunia, bu'ka kuundi'la wu' wa kunani mpaka kuundi'la wu'. ");
INSERT INTO mgw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bai, bu'kana na mikongo, mutangite panga ndambi' paitumbwa ipuka no piya maakapi, ngapamutanga nsimu wo una wendaegelya. ");
INSERT INTO mgw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nga nyinyonyo na mwenga pamwaalu'a gabona makowe ga goti kagapangika, mwatange panga ai pipi nnu'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kakape nimmakianga, lubelekwo lu'no lwaapi'tali pangali pitya makowe ago goti. ");
INSERT INTO mgw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunani na dunia kwaalu'a pi'ta, lakini mayi'gi'yo gangu' katu gaalu'a pi'tali. ");
INSERT INTO mgw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lakini bu'kana na lisu'ba na saa yi'lu' ntu'pu' ywatangite, ata malaika bababile kunani wala Mwana, ila Tati' kisake bai. ");
INSERT INTO mgw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kati mwayaabile nsimu wa Nuu, ngamwayapanga nsimu wo isa kwake Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Papipi na masu'ba galu' ga nkukulo nku'lu', bandu bendelya no nywa, bendekobeka no ku'nda, mpaka paliikite lisu'ba li'lu' Nuu paayingi musafina. ");
INSERT INTO mgw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nabembe baatangiteli lyolyoti mpaka wu'lu' nkukulo nku'lu' pawaapitile na kwakumba boti. Na nyo ngamwayapanga paaisa Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wakati wo bandu abi'li' baalu'a baa munng'unda, yumo alu'a tolelwa na ywi'ngi' lekelwa. ");
INSERT INTO mgw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Alwawa abi'li' baalu'a panga kabayaga pamope, yumo alu'a tolelwa na ywi'ngi' alu'a lekelwa. ");
INSERT INTO mgw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Bai, mukeleke, kwa mwanjaa mutangiteli lisu'ba lyaku' lyaalu'a isa Bwana winu. ");
INSERT INTO mgw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini muku'mbu'ki likowe li', kenda mwene nyumba atangite lisu'ba lyo isa mwii, alu'e keleka, na wala alu'e kwilekali nyumba yake iyingililwe. ");
INSERT INTO mgw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kwa nyo, na mwenga mutame wiso, kwa mwanjaa mutangiteli saa yaaisa Mwana wa Mundu.” ");
INSERT INTO mgw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu ngayendelya baya, “Nga ywaku' ntumisi ywau'bi'li'ka na mwene malango? Ywembe bwana wake ami'i kwayi'mi'li'ka atumisi bi'ngi' munyumba yake, li'nga aapei ilyo yabe kwa saa yaipalikwa. ");
INSERT INTO mgw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nantali ntumisi yu'lu', bwana wake paalu'a buyangana alu'a kunkolya kapanga kati mwatumilwe. ");
INSERT INTO mgw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kakape nimmakianga, bwana wake alu'a kummi'ka ntumisi ywo abe nnyi'mi'li'ki wa mali yake yoti. ");
INSERT INTO mgw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini mana ntumisi ywo nnau, naywembe aaibakia pamoyo wake panga, ‘Bwana wangu' alu'a si'li'ya buya,’ ");
INSERT INTO mgw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","naywembe ngatumbwa kwaku'mbwa atumisi aine no tumbwa lya no nywa pamope na babalobya, ");
INSERT INTO mgw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","bai, bwana wa ntumisi ywo alu'a isa lisu'ba lyangapi'kanilya na saa yangatanganikwa, ");
INSERT INTO mgw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Alu'a kumbwatya paku'lu' na kummi'ka likundi limo na anapiki. Akwo kwaalu'a ba na kili'lo no yaga mino. ");
INSERT INTO mgw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nsimu wo, Ukulungwa wa Kunani waalu'a landana na ai'nja ku'mi babaatweti imuli yabe yenda kunni'nda mwene lisengele. ");
INSERT INTO mgw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Batano baai alogeloge na batano baai bene malango. ");
INSERT INTO mgw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Balu' alogeloge baatweti imuli yabe lakini baapu'twili mauta go yongeya. ");
INSERT INTO mgw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lakini balu' bene malango baatweti imuli yabe na mauta go yongeya muyombo. ");
INSERT INTO mgw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwa mwanjaa mwene lisengele aasi'li'ye isa, boti ngalwaapi'tya lugono no gonja. ");
INSERT INTO mgw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lakini payiikite meku ngakubaa na ndu'ti, ‘Lingulyange, mwene lisengele endaisa, mupitange panja mukampoki!’ ");
INSERT INTO mgw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Apo balu' ai'nja boti ngabayumuka no bi'ka wiso imuli yabe. ");
INSERT INTO mgw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Balu' alogeloge ngabaabakia balu' bene malango, ‘Tulu'ba mutupu'ngu'li mauta ginu, kwa mwanjaa imuli yitu yendaimika.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini balu' bene malango ngabaayangwa, ‘Mauta gatubile nago gatuli'nganali twenga na mwenga! Nantali muyende kuliluka, mukapi'me,’ ");
INSERT INTO mgw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Balu' alogeloge pabaabile kabayenda pi'ma mauta, mwene lisengele ngaisa. Balu' batano babaaibi'kite wiso ngabayi'ngya pamope naywembe musi'li'ku'si'li'ku' ya lisengele. Bu'kapo niango ngauyigalilwa. ");
INSERT INTO mgw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pasu'gu', balu' bi'ngi' ngabaika no tumbwa kema, ‘Bwana! Bwana! Utuyu'gu'li niango!’ ");
INSERT INTO mgw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini mwene lisengele ngayangwa, ‘Kakape nimmakianga, nintangiteli mwenga.’” ");
INSERT INTO mgw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bu'kapo Yesu ngabaya, “Mukelekange, kwa mwanjaa mutangiteli lisu'ba wala saa.” ");
INSERT INTO mgw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nsimu wo waalu'a panga kati mundu yumo ywapalage yabwa mwanja, ngaakema atumisi bake na kwakamukiya mali yake. ");
INSERT INTO mgw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aampei kila mundu kati mwawesa, yumo aampei mbanje ela tano, ywi'ngi' ela ibi'li', na ywi'ngi' ela yimo, bu'kapo ngayabwa mwanja. ");
INSERT INTO mgw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pangali si'li'ya, yu'lu' ywaapeyilwe mbanje ela tano ngaipangya nsuluso, ngaibeleya yi'ngi' tano kai'. ");
INSERT INTO mgw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yu'lu' ywaapeyilwe mbanje ela ibi'li', ngaipangya nyinyonyo, ngaibeleya yi'ngi' ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini yu'lu' ywaapeyilwe mbanje ela yimo ngayenda kwii'mbya pai' li'nga kwiiya yi'lu' mbanje ya bwana wake. ");
INSERT INTO mgw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagapite masu'ba maingi, yu'lu' bwana ywa balu' atumisi ngaki'li'bu'ka no panga nabo isabu. ");
INSERT INTO mgw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yu'lu' ntumisi ywaapokile mbanje ela tano ngaisa, ngaleta tano yi'ngi' yaabeliye. Ngabaya, ‘Bwana, wabi'i kasangu' mbanje tano, lingulya, nibeliye yi'ngi' tano kai'.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bwana wake ngammakia, ‘Unogiye muno, ntumisi nnogau na wauu'bi'like! Wau'bi'like kwa makowe masene, nilu'a kubi'ka ube wannyi'mi'li'ki wa makowe maku'lu'. Isa sonapusike pamope na bwana wako.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Yu'lu' mwene mbanje ela ibi'li', nembe ngaisa ngabaya, ‘Bwana, wabi'i kasangu' mbanje ela ibi'li', lingulya, nibeleye yi'ngi' ibi'li'.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bwana wake ngammakia, ‘Unogiye, wantumisi nnogau na wauu'bi'like. Wau'bi'like kwa makowe masene, nanenga nilu'a kupanga ube wannyi'mi'li'ki wa makowe maku'lu'. Isa sonapusike pamope na bwana wako.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Bu'kapo yu'lu' ntumisi ywaapoki mbanje ela yimo ngaisa no baya, ‘Bwana, natangite panga wenga wa nnonopau, uuna pangali panda, ukumba pangali misa mbeyu. ");
INSERT INTO mgw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kwa nyo naatiyogopa, nganiyenda kwiiya mbanje yako mubwi'. Bai, ayi' nga mali yako, utole.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bwana wake ngayangwa, ‘Wenga wa ntumisi nnau na nkata! Waatangite panga niuna pangali panda na nikumba pangali misa mbeyu. ");
INSERT INTO mgw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bai, upalikwage bi'ka mbanje yangu' kwa bababeleya, li'nga paniki'li'bu'ka nitole yangu' na yi'lu' yaibeliye. ");
INSERT INTO mgw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bai, mumpokonywe ayo mbanje yabile nayo, mumpei yu'lu' mwene mbanje ela ku'mi. ");
INSERT INTO mgw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwa mwanjaa kila mundu ywabile na kili'be alu'a yongeyelwa si'ngi', lakini mundu ywangali kili'be ata si'lu' sabile naso, saatolelwa. ");
INSERT INTO mgw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na kwa ayu' ntumisi ywangali pwaika, muntaikuli panja kulubi'ndu'! Akwo kwaalu'a panga kili'lo no yaga mino.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nsimu wa Mwana wa Mundu paalu'a isa mu utukupu wake na malaika boti babile pamope nakwe, apo alu'a tama panani ya kiti'gu' sake sa lenji kitukupu. ");
INSERT INTO mgw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bandu ba mili'ma yoti baalu'a kongolekana nnu'ngi' yake, naywembe alu'a kwabaganiya kati nsungi mwaabaganiya ngondolo na mbwi. ");
INSERT INTO mgw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Alu'a kwabi'ka ngondolo kuluboko lwa mmalyo na mbwi kuluboko lwa nki'ya. ");
INSERT INTO mgw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Apo Nkulungwa ngaalu'a kwabakia balu' bababile kuluboko lwa mmalyo, ‘Mwisange mwenga mwamuyaliwite na Tati' bangu', muyingi muukulungwa wamwaabi'kilwe wiso tangu' umbilwa kwa dunia. ");
INSERT INTO mgw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa mwanjaa panaaminyike njala, mwanipei kilyo, panaaminyike nnyota, mwanipei masi', panaai na nng'eni, mwanikemi kasinu, ");
INSERT INTO mgw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","panaai na buula, ngamuniwalika, panaai na ntamwe, ngamuisa kunibu'bu'ya, panaai muutabilwe, na mwenga ngamuisa kunityangilya.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Apo balu' bandu anogau ngapabalu'a kunnyangwa, ‘Bwana, pakubawi patukubweni ubile na njala na twenga ngatukupeya kilyo, au ubile na nnyota, na twenga ngatukupeya masi' go nywa? ");
INSERT INTO mgw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kai' pakubawi patukubweni ubile wa nng'eni ngatukukemya kasitu, au ubile na buula, ngatukuwalika? ");
INSERT INTO mgw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Au pakubawi patukubweni ubile wa ntamwe au ubile muutabilwe, ngatuisa kukulingulya?’ ");
INSERT INTO mgw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nkulungwa alu'a yangwa, ‘Kakape nimmakianga, kwa kila kili'be samumpangi yumo ywa aba alongo bangu' bangali isimilwa, mwaanipangi nenga.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bu'kapo alu'a kwabakia balu' ba kuluboko lwa nki'ya, ‘Mubu'ke kasangu', mwenga mwamukosite lasi kwa Nnu'ngu', muyende mumwoto wangali yomoka waubi'kilwe wiso kwa Ibilisi na malaika bake. ");
INSERT INTO mgw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwa mwanjaa panaabile na njala, mwanipeili kilyo, panaabile na nnyota, mwanipeili masi' go nywa, ");
INSERT INTO mgw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","panaabile na nng'eni mwenga mwanikemili kasinu, panaabile na buula mwenga mwaniwalikeli ngu'bo, na panaabile na ntamwe na muutabilwe mwenga mwaaisili kunilingulya. ");
INSERT INTO mgw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Apo nabembe ngabaalu'a yangwa, ‘Bwana pakubawi patukubweni ubile na njala au nnyota, ubile wa nng'eni au ubile na buula, ubile wa ntamwe au ubile muutabilwe, na twenga ngatukotoka kukuyangatiya?’ ");
INSERT INTO mgw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Naywembe ngaayangwa, ‘Kakape nimmakianga, kila kili'be samwaakani kumpangya yumo ywa aba bangali isimilwa, mwaakani kunipangya nenga.’ ");
INSERT INTO mgw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bai, aba baalu'a yenda kungu'su'mbu' yangayomoka, lakini balu' bene aki baalu'a yingya muukoto wangayomoka.” ");
INSERT INTO mgw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu paayomwi longela ago goti, ngaabakia banamasi' bake, ");
INSERT INTO mgw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mutangite panga bu'ka pa masu'ba gabi'li' kwaalu'a baa na si'li'ku'si'li'ku' ya Pasika. Lisu'ba lyo Mwana wa Mundu alu'a songelwa li'nga abambilwe.” ");
INSERT INTO mgw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nsimu wo, api'ndo ba dini na api'ndo ba bandu baatikwembana pamope munyumba ya mpi'ndo nku'lu' wa dini ywakemelwa Kayafa. ");
INSERT INTO mgw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ngabasikisana ndi'la ya kummoywa Yesu kwa kinunu na kummulaga. ");
INSERT INTO mgw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lakini ngababaya, “Likowe li' kanelipangike lisu'ba lya si'li'ku'si'li'ku', kwa akane pitya puyo kwa bandu.” ");
INSERT INTO mgw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu paabile Betania munyumba ya Simoni, mwene matana. ");
INSERT INTO mgw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pabaabile nnyumba kabalya ayingi nnwawa yumo, abile na supa ya liwe yene mauta ga bei ngu'lu'. Ngagamiminia muntwe wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Banamasi' bake pabagabweni go ngabausika, ngababaya, “Kwa mwanjaa namani anyamanie mali kati yi'? ");
INSERT INTO mgw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mauta ga gakapi'mi'yi'lwa kwa bei ngu'lu', na mbanje ye kwapeya aki'ba.” ");
INSERT INTO mgw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu paakwipwi gabaganiyage, ngaabakia, “Kwa mwanjaa namani mumwauya mau' yu'? Ywembe anipangile likowe linannoga. ");
INSERT INTO mgw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aki'ba mubile nabo masu'ba goti, lakini nenga naabali na mwenga masu'ba goti. ");
INSERT INTO mgw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ayu' mau' animimini mauta ganannungya muyi'ga yangu' li'nga kwibi'ka wiso yi'ga yangu' kwo sikilwa. ");
INSERT INTO mgw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kakape nimmakianga, pandu popoti palu' mudunia yi'no kwayaalilwa abali inannoga yi', likowe li' lyalipangite mau' yu' lyalu'a tambulwa kwa kunku'mbu'kya ywembe.” ");
INSERT INTO mgw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bu'kapo Yuda Isikalioti, yumo ywa balu' banamasi' ku'mi na abi'li', ngayenda kwa api'ndo ba dini ");
INSERT INTO mgw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kwalaluya, “Mulu'a nipeya ki'li' mana nimmi'i Yesu mumaboko ginu?” Ngabammalangya ipande salasini ya mbanje. ");
INSERT INTO mgw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bu'ka lisu'ba lyo, Yuda aabile kapala lipala lya kunsongya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lisu'ba lyo tumbulya si'li'ku'si'li'ku' ya Makati Gangalu'la, banamasi' bannyendeli Yesu, ngabannaluya, “Kilyo sa Pasika upala tukakubi'ki wiso kwaku'?” ");
INSERT INTO mgw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ywembe ngayangwa, “Muyende kukilambo kwa mundu nsi'si', mukammakie, ‘Mwalimu abaya, Lisu'ba lyangu' liegelile, nenga na banamasi' bangu' tupala panga ngu'mbu'ku'mbu' ya Pasika munyumba yako.’” ");
INSERT INTO mgw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kwa nyo, banamasi' ngabapanga kati mwababakiyilwe na Yesu, ngabaibi'ka wiso Pasika. ");
INSERT INTO mgw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pakupilile, Yesu ngatama pamesa pamope na banamasi' bake ku'mi na abi'li'. ");
INSERT INTO mgw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pabaabile kabalya, Yesu ngabaya, “Kakape nimmakianga, yumo mukipi'nga sinu alu'a nisongya.” ");
INSERT INTO mgw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Banamasi' ngabanyopa muno, ngabatumbwa kunnaluya yumo yumo, “Bwana, nengali, au lili?” ");
INSERT INTO mgw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ngaabakia, “Ywasuyite likati pamope nanenga mukibakuli, ngaywaalu'a nisongya. ");
INSERT INTO mgw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Mundu ayenda kati mu'lu' Maandiko Mapeleteu mwagabaya, lakini akibona yu'lu' mundu ywaalu'a kunsongya! Ilu'e panga nantali mundu ywo akakotoka belekwa.” ");
INSERT INTO mgw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda yu'lu' ywaapalage kunsongya Yesu ngalaluya, “Mwalimu! Nengali, au lili?” Yesu ngannyangwa, “Wenga wamwene ngawaubaya.” ");
INSERT INTO mgw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pabaabile kabalya, Yesu ngatola likati, ngasukulu Nnu'ngu', ngalimetwana na kwapeya banamasi' bake kabaya, “Mutole mulye, yi'no nga yi'ga yangu'.” ");
INSERT INTO mgw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bu'kapo ngatola nnobo wa divai no sukulu kabaya, “Munywelyange mwaboti munnobo gu'no. ");
INSERT INTO mgw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kwa mwanjaa yi'no nga myai yangu' yaikangamaya lilagano, iyitanika kwa kitumbu sa bandu baingi li'nga kwabu'ki'ya sambi. ");
INSERT INTO mgw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lakini nimmakianga, naainywali kai' divai ya njabibu mpaka lisu'ba li'lu' lyanainywa yayambi' pamope na mwenga mu ukulungwa wa Tati' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bu'ka po yi'mba mwambo, ngababu'ka yenda mu Kitu'mbi' sa Minjaituni. ");
INSERT INTO mgw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bu'kapo Yesu ngaabakia, “Kilo sa li'no, mwenga mwaboti mwalu'a nileka nenga, kwa mwanjaa Maandiko Mapeleteu gabaya, ‘Naalu'a kunku'mbwa nsungi, na kipi'nga sa ngondolo saalu'a baganika.’ ");
INSERT INTO mgw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini bu'ka pa uyu'ki wangu', naalu'a kunnongolya yenda ku Galilaya.” ");
INSERT INTO mgw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petili ngammakia Yesu, “Ata mana boti baalu'a kuleka wenga, katu nenga nikulekali.” ");
INSERT INTO mgw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu ngannyangwa, “Kakape nikubakia, li'no kilo kapala bi'ka njogolo, waalu'a nikana mala itatu.” ");
INSERT INTO mgw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petili ngammakia, “Ata mana kanipalikwa waa pamope na we, katu naalu'a kukanali.” Na balu' banamasi' aine ngababaya nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bu'kapo Yesu ngayenda pamope na banamasi' bake mpaka ku kyati' sakikemelwa Getisemani, ngaabakia, “Mutame pa, nanenga niyenda palu'ngi' nikalu'be.” ");
INSERT INTO mgw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngantola Petili na balu' bana abi'li' ba Zebedayo, apo ngatumbwa nyopa no auka. ");
INSERT INTO mgw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Apo ngaabakia, “Mwoyo wangu' utwi'li manyingipalo, ata pipi no waa. Mutame pano li'nga mukeleke pamope nanenga.” ");
INSERT INTO mgw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bai, ngayenda nnu'ngi' pasene, ngatu'la ukukama, ngalu'ba kabaya, “Mwa Tati' bangu', mana iwesekine nnobo gu' wa ngu'su'mbu' munibu'ki'ye, lakini kaneipange kati mwanipala nengali, ila mwamupala mwa Tati'.” ");
INSERT INTO mgw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngaayendelya balu' banamasi' bake, ngaakolya bagonjike. Ngammakia Petili, “Mukombwili keleka pamope nanenga ata kwa lisaa limo? ");
INSERT INTO mgw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mukeleke na mulu'be li'nga mwaakane yingya mumapayilwo, kwa mwanjaa, loo yinu ipala panga makowe manogau, lakini yi'ga yinu nga kigopi.” ");
INSERT INTO mgw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngayenda kai' pampanda pabi'li' no lu'ba, “Mwa Tati', manaitei nnobo gu' ukombwali pi'ta kuutalu nanenga wangali kuunywelya, bai gamupala gapangike.” ");
INSERT INTO mgw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ngaayendelya kai', ngaakolya bagonjike, kwa mwanjaa minyo gabe gaatopilwe na lugono. ");
INSERT INTO mgw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bai, ngaaleka, ngayenda kai' lu'ba pampanda patatu kabwi'li'gi'ya baya gagalu'galu'. ");
INSERT INTO mgw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bu'kapo ngaayendelya balu' banamasi' bake ngaabakia, “Buli, balo mukagonja no pu'mu'lya? Lingulyange! Saa itimile, na Mwana wa Mundu alu'a kamukiyilwa kwa bandu bene sambi. ");
INSERT INTO mgw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muyumuke, tubu'ke. Lingulyange! Yu'lu' ywanisongya endaisa.” ");
INSERT INTO mgw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu paabile anayomwali longela nabo Yuda, yumo ywa balu' ku'mi na abi'li', ngaika pamope na kipi'nga kiku'lu' sa bandu bene mapanga na mandolonga babaatumilwe na api'ndo ba dini na api'ndo ba bandu. ");
INSERT INTO mgw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aywo ywapalage kunsongya Yesu, aabile aayomwile kwapeya abo bandu mwasu kabaya, “Yu'lu' ywanannonia ngaywembe, mummoywe.” ");
INSERT INTO mgw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bai, Yuda paamwegeli Yesu na kumpanga abali kabaya, “Abali, Mwalimu,” ngannonia. ");
INSERT INTO mgw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu ngammakia, “Mbwiga, upange si'lu' soisilile.” Apo balu' bandu ngabaisa, ngabammoywa Yesu, na kuntaba. ");
INSERT INTO mgw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumo ywa balu' babaabile pamope na Yesu ngasolomwa lipanga lyake, nganku'mbwa ntumisi ywa mpi'ndo ywa dini, na kunkata lisikilo. ");
INSERT INTO mgw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Apo Yesu ngammakia, “Ki'li'bu'ya lipanga lyako mulupata lwake, kwa mwanjaa boti babatumya lipanga, baalu'a waa kwa lipanga. ");
INSERT INTO mgw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Buli, Utangiteli panga niwesa kwalu'ba Tati' bangu', nabembe bawesa niletya saa yi'yi'noyi'no ipi'nga yaipi'ta ku'mi na ibi'li' ya malaika kuniyangatia? ");
INSERT INTO mgw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nikapangage nyo, galu'e timya buli Maandiko Mapeleteu gagabaya panga amo ngamwaipalikwa ba?” ");
INSERT INTO mgw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bu'kapo Yesu ngakibakia kipi'nga sa bandu babaaisi kummoywa, “Buli, mwisi kuniboywa kwa mapanga na mandolonga, baya kwake kati nenga nampokonyoli? Kila lisu'ba naabile munyumba ya Nnu'ngu' kaniyi'gana, na mwenga mwaniboywili! ");
INSERT INTO mgw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini aga goti gapangike li'nga maandiko mapeleteu ga alondoli ba Nnu'ngu' gatimi.” Bu'kapo banamasi' boti ngabanneka no butuka. ");
INSERT INTO mgw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bai, balu' babammoywi Yesu ngabampeleka kwa Kayafa, mpi'ndo ywa dini, pandu po baakongolekine balimu ba salya na api'ndo ba bandu. ");
INSERT INTO mgw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petili nganki'ngama Yesu kwa kuutalu mpaka kulua lwa mpi'ndo ywa dini, ngayingya nnyumba pamope na ali'ndi'li li'nga apate kugabona makowe gagalu'a pitya. ");
INSERT INTO mgw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bai, api'ndo ba dini na Balasa Liku'lu' lya Ayahudi lyoti ngabapala ukong'ondeli wa ubu'su' bu'kana na Yesu li'nga bapate kummulaga, ");
INSERT INTO mgw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","lakini baapatikeli likowe lyolyoti, pamope no panga baaisi akong'ondeli baingi ba ubu'su'. Kuundi'la ngabaisa akong'ondeli abi'li' ba ubu'su', ");
INSERT INTO mgw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","no baya, “Mundu yu' aabaite panga, ‘Nendakombwa kwisengwana nyumba ya Nnu'ngu', na kwisenga kwa masu'ba gatatu.’” ");
INSERT INTO mgw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bu'kapo mpi'ndo ywa dini ngayi'ma na kummakia Yesu, “Buli, uyangwali kili'be? Bandu ba bakong'ondelya ki'li' bu'kana na wenga?” ");
INSERT INTO mgw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu ngatama liki. Mpi'ndo wa dini ngammakia, “Ulape kwa lina lya Nnu'ngu' ywabile nkoti panga ulu'a kutubakia kweli. Buli, wenga wa Kilisitu, Mwana wa Nnu'ngu'?” ");
INSERT INTO mgw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu ngammakia, “Wenga ngaulongei. Lakini nimmakianga, tumbulya nambi'yambi' mwalu'a kummona Mwana wa Mundu atami kummalyo ga yu'lu' Bwana Mwene Makakala, kauluka bu'ka kumaunde ga kunani.” ");
INSERT INTO mgw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Apo mpi'ndo ywa dini ngapapwana magu'bo gake no baya, “Atikupulu! Tupala ukong'ondeli wi'ngi' kai'? Linga, nambi'yambi' mwenga muyu'wine ayo kupulu yake. ");
INSERT INTO mgw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwenga mwibona buli?” Bembe ngabannyangwa, “Apalikwa waa!” ");
INSERT INTO mgw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bu'kapo ngabammunia mmata kuminyo, ngabanku'mbwa ngondi, na bi'ngi' baabile kabanku'mbwa mapande, ");
INSERT INTO mgw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kababaya, “Wenga wa Kilisitu, ummaye nyai ywakuku'mbwile!” ");
INSERT INTO mgw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petili atami panja muluwa. Ntumisi yumo nnwawa ngannyendelya na kummakia, “Wenga waabile pamope na Yesu ywa ku Galilaya.” ");
INSERT INTO mgw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petili ngakana nnu'ngi' ya boti babaabile palu', kabaya, “Ndangiteli ata lyo baya.” ");
INSERT INTO mgw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Paabile paniango kaapita, ntumisi ywi'ngi' nnwawa ngammona, ngaabakia balu' babaabile palu', “Mundu yu' abile pamope na Yesu ywa ku Nasaleti.” ");
INSERT INTO mgw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petili ngakana kai' kwa kilapo, kabaya, “Nintangiteli mundu yu'!” ");
INSERT INTO mgw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bu'ka pa masaa masene, balu' babaayi'mi palu' bannyendeli Petili, ngabammakia, “Kakape wenga ngawa yumo ywabe, kwa mwanjaa nnongelo wako ukupanga utanganikwe.” ");
INSERT INTO mgw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Apo Petili ngatumbwa kwilani no lapa kabaya, “Nintangiteli mundu yu'!” Papalu'palu' njogolo ngabi'ka. ");
INSERT INTO mgw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petili ngaku'mbu'kya mayi'gi'yo galu' gaabakiyilwe na Yesu, “Li'no, kilo kapala bi'ka njogolo, waalu'a nikana mala itatu.” Bai ngapita panja, ngali'la kwa lwu'ngu' muno. ");
INSERT INTO mgw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pakusile, api'ndo ba dini boti na api'ndo ba bandu baatisikisana li'nga bapate ndi'la ya kummulaga Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ngabantaba pingwi, ngabantola na kunkamukiya kwa Pilato, mpi'ndo ywa nkoa. ");
INSERT INTO mgw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Apo Yuda ywembe ngaywaansongile Yesu, paabweni panga bayomwile kumuukumu Yesu, ngayuta no ki'li'bu'ya ipande yoti salasini ya mbanje yaapeyilwe na alongosi ba api'ndo ba dini na api'ndo ba bandu. ");
INSERT INTO mgw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ngabaya, “Ngosite kwa kumpiya mundu yu' ywangali likosa abulagilwe.” Lakini bembe ngababaya, “Likowe lyo litu twenga lili, alyo lyako wamwene!” ");
INSERT INTO mgw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bai, Yuda ngaitaikulya yi'lu' ipande ya mbanje munyumba ya Nnu'ngu', naywembe ngayenda kwiku'ngi'la. ");
INSERT INTO mgw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Api'ndo ba dini ngabatondwa yi'lu' ipande ya mbanje, kababaya, “Mbanje yi' ipwaikali bi'ka mulisanduku lya mabi'ko ga munyumba ya Nnu'ngu', kwa mwanjaa mbanje yi' ipatikine kwa ndi'la yo bulagilwa mundu.” ");
INSERT INTO mgw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bai, bu'ka po sikisana, ngabaamwa tumya mbanje yi'lu' kwo pi'ma Nng'unda wa Bwiba, li'nga waapange nng'unda wo sikya ageni. ");
INSERT INTO mgw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kwa nyo, mpaka li'no nng'unda wo ukemelwa Nng'unda wa Myai. ");
INSERT INTO mgw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kwa nyo mayi'gi'yo ga nnondoli ywa Nnu'ngu' Yelemia ngagatimya, “Baatweti ipande salasini ya mbanje, bu'kana na bei yayaabi'kilwe na bandu ba Isilaili, bu'kana na ywembe, ");
INSERT INTO mgw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ngabapi'ma nng'unda wo bwiba, kati mu'lu' Bwana mwaanilagile.” ");
INSERT INTO mgw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ngabannyi'mi'ka nnu'ngi' ya mpi'ndo ywa nkoa, ngannaluya, “Buli wenga ngawa Nkulungwa wa Ayahudi?” Yesu ngammakia, “Wenga ngawaubaya.” ");
INSERT INTO mgw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini api'ndo ba dini na api'ndo pabaabile kabansitakya, aayangwili kili'be. ");
INSERT INTO mgw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kwa nyo Pilato ngannaluya, “Buli uyu'wali makowe aga goti gabakusitakya?” ");
INSERT INTO mgw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini Yesu aayangwili ata kili'be simo, ata aywo mpi'ndo ywa nkoa ngasangala muno. ");
INSERT INTO mgw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kila nsimu wa si'li'ku'si'li'ku' ya Pasika, mpi'ndo ywa nkoa aai na mimu ya kwayu'gu'lya Ayahudi ntabilwe yumo ywabampala. ");
INSERT INTO mgw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pamasu'ba go kwaabile na ntabilwe ywaayu'wanike muno, lina lyake Balaba. ");
INSERT INTO mgw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kwa nyo bandu pabaakongolekine, Pilato ngaalaluya, “Mupala ninnyu'gu'li ywaku' muabi'li' ba, Balaba au Yesu ywakemelwa Kilisitu?” ");
INSERT INTO mgw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aabaite nyo kwa mwanjaa aatangite panga baankamukiye Yesu kasake kwa kitumbu sa bwigu bai. ");
INSERT INTO mgw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato paabile atami pakiti'gu' sa ukumu, nnyumbowe ngampelekya abali panga, “Kaneube na likowe lyolyoti kwa mundu yu' ywangali kipi'li', kwa mwanjaa li'no nipatike ngu'su'mbu' muno mumaloto kwa kitumbu sa mundu yu'.” ");
INSERT INTO mgw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakini api'ndo ba dini na api'ndo ngabaasopa bandu panga balu'be Balaba ayu'gu'li'lwe, na Yesu abulagilwe. ");
INSERT INTO mgw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mpi'ndo wa nkoa ngaalaluya, “Mupala ninnyu'gu'li ywaku' mwa abi'li' ba?” Ngabannyangwa, “Balaba!” ");
INSERT INTO mgw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ngaalaluya, “Bai, nipange buli kwa ayu' Yesu ywakemelwa Kilisitu?” Boti ngabayangwa, “Abambilwe!” ");
INSERT INTO mgw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ngalaluya, “Kwa kitumbu saku'? Apangite likosa lyaku'?” Lakini bembe ngabayongeya panga ndu'ti, kababaya, “Abambilwe!” ");
INSERT INTO mgw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato paibweni akombwali panga likowe lyolyoti na puyo yendeyongekeya, ngatola masi' no uluwa maboko gake nnu'ngi' ya bandu boti, kabaya, “Nenga lawama ntu'pu' kwa kiwo sa mundu yu', myai yake yalu'a baa kwinu mwabene.” ");
INSERT INTO mgw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bandu boti ngababaya, “Myai yake na ibe kasitu na kwa bana bitu!” ");
INSERT INTO mgw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Apo Pilato ngaayu'gu'lya Balaba bu'ka munyumba ya atabilwe, no bu'ka pakunku'bata Yesu mikwasu, ngampiya abambilwe. ");
INSERT INTO mgw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bu'kapo asikali ba mpi'ndo ywa nkoa ngabampeleka Yesu kunyumba ya liwali, na kipi'nga sabe soti ngakikongolekana, kunti'li'ta. ");
INSERT INTO mgw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ngabammula ngu'bo yake na kunng'walika nganju ya lukanda lwa sambalau. ");
INSERT INTO mgw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngabalu'ka kapiya ya mimimwa, ngabang'walika muntwe. Ngabammi'kya nnai muluboko lwake lwammalyo, no kilikita nnu'ngi' yake kabansalanga kwo baya, “Ukayumuka, nkulungwa wa Ayahudi!” ");
INSERT INTO mgw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngabammunia mmata, no tola wu'lu' nnai, ngabanku'mbu'lya nawo muntwe. ");
INSERT INTO mgw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bu'ka pakunsalanga, ngabammula yi'lu' nganju, ngabang'walika nganju yake, bu'kapo ngabampeleka li'nga kummamba. ");
INSERT INTO mgw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pabaabile kabayenda, ngabankolya mundu yumo lina lyake Simoni, mwenekaya wa Kulene, ngabanni'ndi'li'lya aupu'twe wu'lu' nsalaba wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pabaaikite pandu papakemelwa Golgotha, lombolya Pandu pa Lipakala lya Ntwe. ");
INSERT INTO mgw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Apo ngabampeya Yesu divai yaiyangabanike na kikaa li'nga anywe, lakini paipayite, ngakana nywa. ");
INSERT INTO mgw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pabayomwi kummamba, ngababagana ngu'bo yake kwa kwipangya mpumbe. ");
INSERT INTO mgw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bu'kapo ngabatama na kunni'ndi'la. ");
INSERT INTO mgw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani ya ntwe wake ngababi'ka maandiko gagabaya kitumbu so sitakilwa kwake gagaandikilwe, “Ayu' Yesu, nga Nkulungwa wa Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Apokonyoli abi'li' baabambilwe pamope nakwe, yumo kunki'ya na ywi'ngi' kummalyo. ");
INSERT INTO mgw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bandu babaabile kabapi'ta palu' ngabampwi'wa ku'no kabatikatika mitwe yabe kwa kunsalawa, ");
INSERT INTO mgw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kababaya, “Wenga! Ka ngawipunage kobaya, uwesa kwisengwana nyumba ya Nnu'ngu' na kwisenga kwa masu'ba gatatu? Nambi'yambi' wikosopoli wamwene! Mana kakape ngawa Mwana wa Nnu'ngu', uluka munsalaba!” ");
INSERT INTO mgw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nyinyonyo na api'ndo ba dini pamope na balimu ba salya na api'ndo ba bandu baatikunsalanga, kababaya, ");
INSERT INTO mgw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aakosopoli bi'ngi', lakini kwikosopolya mwene akombwali! Ati' ywembe nga nkulungwa wa Ayahudi! Nambi'yambi' aulu'ke munsalaba li'nga na twani tumwu'bi'li. ");
INSERT INTO mgw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ywembe aamwu'bi'li Nnu'ngu' no baya ati' nga Mwana wa Nnu'ngu', bai, Nnu'ngu' ankosopoli mana ampendile.” ");
INSERT INTO mgw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nyinyonyo na balu' babaabambilwe pamope nakwe baatikupwi'wa. ");
INSERT INTO mgw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tumbulya saa sita mutwekati mpaka musaa tisa, lubi'ndu' lwawi'ki'li nni'ma woti. ");
INSERT INTO mgw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Musaa tisa Yesu ngakemelya kwa lilobe liku'lu', “Eli, Eli, lema sabakitani?” Lombolya “Nnu'ngu' wangu', Nnu'ngu' wangu', mboni utenileka?” ");
INSERT INTO mgw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lakini bandu babaayi'mi palu' pabayu'wine nyo, ngababaya, “Ankema Elia.” ");
INSERT INTO mgw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Popopo yumo ywabe ngabutuka yenda tola sifongo, ngasuya mukasiki, na kwibi'ka munnai li'nga kumpeya Yesu anywe. ");
INSERT INTO mgw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bi'ngi' ngababaya, “Bai, munneke, tulole mana aywo Elia alu'a isa kunkosopolya.” ");
INSERT INTO mgw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bai, Yesu ngali'la kai' kwa lilobe liku'lu' no yomoka. ");
INSERT INTO mgw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na saa yi'yi'lu'yi'lu' panjia ya nyumba ya Nnu'ngu' yapapwike ipande ibi'li', tumbulya kunani mpaka pai'. Nnendemo wa nni'ma ngaupitya na mipi'mbi' yaatipuanika, ");
INSERT INTO mgw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","masiko ngagaumukuka na bandu bambone babawile bayi'ki'tilwe na Nnu'ngu', ngabayu'yi'lwa, ");
INSERT INTO mgw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ngabapita mumasiko, no bu'ka po yu'ka kwa Yesu, ngabayingya mu Yelusalemu, ngababonekana na bandu bambone. ");
INSERT INTO mgw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bai, yu'lu' mpi'ndo ywa asikali pamope na balu' babaabile kabanni'ndi'la Yesu pabaubweni nnendemo wa bwi' na galu' makowe gagapitile, ngabayogopa muno, no baya, “Kakape mundu yu' aabile Mwana wa Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pandu po paabile na alwawa bambone babaammi'ngi'yage Yesu na kuntumikia. Alwawa bo, baayi'mi kuutalu kabalingulya goti gagaabile kagapangika. ");
INSERT INTO mgw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nkati yabe baabile Malia Makatalena, Malia mau' babe Yakobi na Yusupu, pamope na mau' babe bana ba Zebedayo. ");
INSERT INTO mgw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Paiikite kitamwiyo, ngaisa mundu yumo tayili mwenekaya wa Alimataya, lina lyake Yusupu. Naywembe aai mwanamasi' wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ngannyendelya Pilato li'nga kunnu'ba ntwi wa Yesu. Pilato ngaamulisa apeyelwe. ");
INSERT INTO mgw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusupu ngautola wu'lu' ntwi, ngaubilingilya musanda yaipeletike, ");
INSERT INTO mgw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ngaubi'ka nkati ya lisiko lyake lyayambi' lyaaliyi'mbite mumpi'mbi'. Bu'kapo ngayigala nniango wa lisiko kwo imbilikiya liwe liku'lu', na kwibu'kya. ");
INSERT INTO mgw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Makatalena na yu'lu' Malia ywi'ngi' baabile batami kabalinga kulisiko. ");
INSERT INTO mgw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pammalau' yake, lyaai lisu'ba lyaliegelyage bi'ka wiso Sabato, Api'ndo ba dini na Mafalisayo ngabannyendelya Pilato ");
INSERT INTO mgw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","no baya, “Bwana, tuku'mbu'kile panga yu'lu' nkongi paabile balo mwu'mi aabaite, ‘Masu'ba gatatu bu'ka po waa kwangu', naalu'a yu'ka.’ ");
INSERT INTO mgw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kwa nyo uamulise lisiko lili'ndi'li'lwe mpaka lisu'ba lyenetatu, li'nga banamasi' bake baakane yiba yi'ga yake na kwabakia bandu panga ateyu'ka. Ubu'su' wu'no wa kuundi'la waalu'a nyata muno kulikoni wu'lu' waulongolile.” ");
INSERT INTO mgw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ngaabakia, “Mutole asikali, mukali'ndi'le lisiko kati mwamuwesa mwabene.” ");
INSERT INTO mgw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kwa nyo ngabayenda na ali'ndi'li, li'nga kulili'ndi'la lisiko, ngabayi'ya muhuli mu li'lu' liwe no bi'ka asikali kwa uli'ndi'li nku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bu'ka pa Sabato lisu'ba lya jumapili kindai' bulabula, Malia Makatalena na yu'lu' Malia ywi'ngi', baayi'i kulilingulya lisiko. ");
INSERT INTO mgw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Imukya, ngakupitya nnendemo nku'lu' wa bwi', na malaika wa Bwana ngauluka bu'ka kunani, ngaliimbilikiya pambwega li'lu' liwe na kulitamya. ");
INSERT INTO mgw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kuminyo ya aywo malaika kwaabile kati njai, na magu'bo gake gaabile mauu muno. ");
INSERT INTO mgw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Balu' ali'ndi'li ba lisiko baatiyogopa muno, ngabalendema no baa kati baatiwaa. ");
INSERT INTO mgw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yu'lu' malaika ngaabakia balu' alwawa, “Kanemuyogope, kwa mwanjaa nitangite panga mumpala Yesu ywaabambilwe. ");
INSERT INTO mgw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ntu'pu' pano, kwa mwanjaa ayu'kite kati mu'lu' mwaabaite. Mwisange samulole pandu pabanng'onjike. ");
INSERT INTO mgw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bai, muyende kiyu'ngu'ya mukaabakie banamasi' bake, ‘Ayu'kite bu'ka kuuwi'li, naywembe alu'a kunnongolya yenda ku Galilaya. Akwo ngamwaalu'a kummona.’ Aya, niyomwile kummakia.” ");
INSERT INTO mgw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Abo alwawa ngabapita kiyu'ngu'ya mulisiko, babi na bwoga na pulaa ngu'lu', ngababutuka yenda kwabakia banamasi' bake abali yo. ");
INSERT INTO mgw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Popopo, ngabakwembana na Yesu, ngabaya, “Mukayumuka.” Balu' alwawa ngabamwegelelya na kunkamwa magu'lu' gake, ngabankilikitya. ");
INSERT INTO mgw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bu'kapo Yesu ngaabakia, “Kanemuyogope! Muyende mukaabakie alongo bangu' bayende ku Galilaya, na akwo bakanibona.” ");
INSERT INTO mgw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Balu' alwawa pabaabile kabayenda, bi'ngi' ba ali'ndi'li ba li'lu' lisiko, baayi'i kukilambo kwapeya abali api'ndo ba dini bu'kana na makowe goti gagaapitike. ");
INSERT INTO mgw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bai, ngabakwembana na api'ndo ba dini pamope na api'ndo ba bandu no yi'ki'tyana. Ngabaapeya balu' asikali mbanje yambone, ");
INSERT INTO mgw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kabaaking'indya kababaya, “Mwenga mwabaye nya, ‘Banamasi' bake baaisi kilo twenga tugonjike, ngabannyiba.’ ");
INSERT INTO mgw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na mpi'ndo ywa nkoa mana aayu'a abali yi', twenga twaalu'a longela nakwe na kummu'ya kyukala, li'nga mwenga mwaakane pata tabu.” ");
INSERT INTO mgw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kwa nyo balu' ali'ndi'li ngabatola yi'lu' mbanje, no panga kati mwabayi'ganilwe. Abali yo ngaiyu'wanika kwa Ayahudi mpaka li'no. ");
INSERT INTO mgw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Balu' banamasi' ku'mi na yumo ngabayenda ku Galilaya kukitu'mbi' saalagile Yesu. ");
INSERT INTO mgw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nabembe pabaamweni ngabankilikitya, lakini bi'ngi' babe baabi na kyukala nakwe. ");
INSERT INTO mgw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ngaisa papipi nabo, na kwabakia, “Nipeyilwe utawala woti wa kunani na padunia. ");
INSERT INTO mgw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bai, mwayendeli bandu boti li'nga bapate panga banamasi' bangu', na kwabatisa kwa lina lya Tati', na Mwana na Loo Mpeleteu, ");
INSERT INTO mgw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mwayi'gane kugayu'wa makowe goti ganinnagile mwenga. Na mutange panga nenga nibile pamope na mwenga masu'ba goti, ata kuundi'la ya dunia.”");
INSERT INTO mgw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pano nga paitumbwa abali inannoga ya Yesu Kilisitu, Mwana wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yaatumbwi kati mwaiandikilwe mukitabu sa nnondoli ywa Nnu'ngu' Isaya. “Nnu'ngu' aatibaya, ‘Lola, nintuma ntumisi wangu' akulongoli, ywaalu'a kubi'kya wiso ndi'la yako.’ ");
INSERT INTO mgw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lilobe lya mundu liyu'wanika kulupu'ngu'ti', ‘Mummi'ki wiso Bwana ndi'la yake, mugolwe simbasimba yake.’” ");
INSERT INTO mgw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yoani Ywabatisage aabonekine kulupu'ngu'ti', ngaala panga bandu banng'alambuki Nnu'ngu' no batisilwa li'nga basamilwe masambi gabe. ");
INSERT INTO mgw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bandu bu'ka ku nni'ma wa Yudea yoti na benekaya boti ba ku Yelusalemu baatikunnyendelya, ngabaungama masambi gabe, naywembe ngaabatisa mulibi'ndi' lya Yordani. ");
INSERT INTO mgw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoani aabile aweti ngu'bo yaitengenesilwe kwa mandenga ga ngamia na lunga lwa liki'ngo. Kilyo sake saai njige na busi wa mmwitu. ");
INSERT INTO mgw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naywembe aatiala kabaya, “Bu'ka pangu', aaisa mwene makakala kulikoni nenga, ata ne nipwaikali lita undwa ngoi ya ilatu yake. ");
INSERT INTO mgw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga nimmatisa kwa masi', lakini ywembe alu'a kummatisa kwa Loo Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Masu'ba go, Yesu aaisi bu'ka ku Nasaleti kunkoa wa Galilaya, ngabatisilwa na Yoani mulibi'ndi' lya Yordani. ");
INSERT INTO mgw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Paapitike mumasi' bai, ngaakubona kunani kupuwanike na Loo Mpeleteu kamuulukya panani yake kati ngunda. ");
INSERT INTO mgw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lilobe ngaliyu'wanika bu'ka kunani, “Wenga nga wa Mwana wangu' wanikupendile, ninogelilwe nawenga.” ");
INSERT INTO mgw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Popopo Loo Mpeleteu ngannongoya ayende kulupu'ngu'ti', ");
INSERT INTO mgw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ngatama kwo masu'ba alubaini kapayilwa na Ibilisi. Aabile kwo pamope na inyama ya mmwitu, nabembe malaika ngababaa kabantumikia. ");
INSERT INTO mgw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yoani paabile muutabilwe, Yesu aayi'i ku Galilaya ala abali inannoga ya Nnu'ngu' kabaya, ");
INSERT INTO mgw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Nsimu wawalondolilwe utimile, na Ukulungwa wa Nnu'ngu' wegelile. Munng'alambuki Nnu'ngu' na kwiu'bi'lya abali inannoga!” ");
INSERT INTO mgw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu paabile kapi'ta mbwega ya litanda liku'lu' lya ku Galilaya, aabweni alobi abi'li' Simoni na Andelea nnunawe kabaloba omba kwa lupi'li'li'. ");
INSERT INTO mgw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ngaabakia, “Mungi'ngame nane nalu'a kumpanga mwaalobi ba bandu.” ");
INSERT INTO mgw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Popopo ngabaileka mbi'li'li' yabe na kunki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Paayi'i nnu'ngi' pasene aabweni Yakobi na Yoani, bana ba Zebedayo. Nabembe baai mungalaba kabanogeya mbi'li'li' yabe. ");
INSERT INTO mgw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Popopo Yesu ngaakema, nabembe ngabaaleka tati' babe mungalaba pamope na apangakasi na kunki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ngabaika kukilambo sa Kapernaumu, na palyaaikite lisu'ba lya Sabato, Yesu ayingi munyumba ya kunnu'ba Nnu'ngu' no tumbwa yi'gana. ");
INSERT INTO mgw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bandu boti pabannyu'wine baatisangala muno kwa mayi'gano gake, mwanjaa aayi'gineli kati balimu ba salya ya Musa, ila kati ntawala. ");
INSERT INTO mgw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Popopo mu'lu' munyumba ya kunnu'ba Nnu'ngu' ngapitya mundu mwene moka katu'ndu'bi'ya lilobe, ");
INSERT INTO mgw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ubile na ki'li' na twenga, wenga wa Yesu wa ku Nasaleti? Buli, wisi? Nikutangite wenga wanyai. Wenga nga wa Mpeleteu wa Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ngaankalipya yu'lu' moka kabaya, “Ndu'ti! Ummu'ke mundu yu'.” ");
INSERT INTO mgw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bai, aywo moka ngaantikatika mundu ywo, bu'kapo ngali'la kwa lilobe liku'lu', ngammu'ka. ");
INSERT INTO mgw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bandu boti baatisangala, ngabalaluyana, “Aga nga makowe gani? Buli, nga mayi'gano gayambi'? Mundu yu' abi na amuli yo amulisa ata moka, nagembe gendakunnyu'wa!” ");
INSERT INTO mgw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Abali ya Yesu ngaiyu'wanika kwa kiyu'ngu'ya mu Galilaya yoti. ");
INSERT INTO mgw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngabapita munyumba ya kunnu'ba Nnu'ngu' no yenda ntawalia mpaka kasabe ki Simoni na Andelea, Yakobi na Yoani baayi'i pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bai, mau' yumo, nkiwe Simoni aai pakindanda kaminya oma ngali'. Yesu paikite bai, ngabammakia abali yo. ");
INSERT INTO mgw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu ngannyendelya aywo mau' na kunkamwa luboko, ngantu'ndu'bi'ya. Yi'lu' oma ngayu'yu'ki'lwa, ngatumbwa kwatumikia. ");
INSERT INTO mgw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kitamwiyo, lisu'ba paliswikite, ngabannetya Yesu atamwe boti na bandu babaalobi moka. ");
INSERT INTO mgw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bandu boti ba kilambo si'lu' ngabakongolekana paniango. ");
INSERT INTO mgw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Naywembe Yesu ngaatepwa bandu bambone babaabile na matamwe mbali'mbali', agabi'ngite moka maingi. Lakini aagayi'ki'tiyeli longela kili'be kwa mwanjaa baai bantangite panga ywembe nga nyai. ");
INSERT INTO mgw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pammalau' yake bulabula, Yesu aatiyumuka no bu'ka yenda pandu pakiyi'ki'ya li'nga sali. ");
INSERT INTO mgw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na aine ngabayenda kumpala. ");
INSERT INTO mgw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pabankolile, ngabammakia, “Bandu boti bendakupala.” ");
INSERT INTO mgw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ngaabakia, “Tubu'ke kuilambo yi'ngi' ya papipi nikaale kwo kai', kwa mwanjaa niisi kwa kitumbu so.” ");
INSERT INTO mgw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bai, ngayenda kila pandu akwo ku Galilaya kaala mumayumba ga kunnu'ba Nnu'ngu' no bi'nga moka. ");
INSERT INTO mgw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mundu yumo mwene matana annyendeli Yesu, ngakilikita, ngannu'ba, “Mana upendile, wendakombwa kunitepwa li'nga nipeleteke!” ");
INSERT INTO mgw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ngammi'kya kiya, ngagolwa luboko lwake, ngankunywa na kummakia, “Mbala upeleteke.” ");
INSERT INTO mgw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Popopo mundu ywo ngayu'yu'ki'lwa galu' matana, naywembe ngapeleteka. ");
INSERT INTO mgw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bu'kapo Yesu ngankwi'li'ka abu'ke kiyu'ngu'ya kwa kummakia, ");
INSERT INTO mgw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Pi'kania, kaneummakie mundu ywoywoti likowe li'no. Ila uyende ukailaye kwa mpi'ndo ywa dini na ukapiye salaka kwo peleteka kwako, kati mwaamulise Musa kong'ondelya panga utepulilwe.” ");
INSERT INTO mgw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini aywo mundu ngayenda no tumbwa bambia makowe go kila pandu no baya makowe gambone. Kwa nyo, Yesu akombwili kai' yingya mukilambo sosoti mpu'la, aapalikwe tama panja pandu pakiyi'ki'ya. Ata nyo, bandu ngabannyendelya bu'ka kila lwingo. ");
INSERT INTO mgw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bu'ka pa masu'ba nsi'si', Yesu aki'li'bu'ki ku Kapernaumu, bandu ngabayu'wa panga aabile pakaya. ");
INSERT INTO mgw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bandu bambone ngabakongolekana palu', tumbulya nnyumba mpaka paniango. Yesu paabile kaalya mayi'gi'yo ga Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","bandu nsese bannetike mundu yumo ywatombolwike abile mpu'tu'lwa mulikai. ");
INSERT INTO mgw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwa kitumbu sa uyolou wa bandu, bakombwili kumpeleka papipi na Yesu. Bai, ngabaotwa mwagala wawaabile panani ya Yesu. Pabaabile bapatike lipala, ngabamweleya aywo mundu. ");
INSERT INTO mgw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu paabweni imani yabe ngangamau, ngammakia yu'lu' mundu ywatombolwike, “Mwana wangu', usamilwe masambi gako.” ");
INSERT INTO mgw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bi'ngi' ba balimu ba salya ya Musa babaabile batami palu' ngabagania mumyoyo yabe, ");
INSERT INTO mgw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Akombwabuli baya nyo? Ankupulu Nnu'ngu'! Ntu'pu' mundu ywakombwa samya sambi ila Nnu'ngu' kisake.” ");
INSERT INTO mgw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Popopo Yesu ngakwipwa maganiyo gabe, ngaabakia, “Mboni mugania nyo mumyoyo yinu? ");
INSERT INTO mgw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nga lyaku' lyalibile kwani muno, kummakia mundu yu' ywatombolwike, ‘Usamilwe masambi gako,’ au kummakia, ‘Uyi'me! Utole likai lyako utyange’? ");
INSERT INTO mgw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bai, mbala mutange panga Mwana wa Mundu abile na utawala wa kwasamya bandu sambi padunia.” Apo ngammakia aywo mundu ywatombolwike, ");
INSERT INTO mgw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikubakia uyi'me, utole likai lyako uyende kasako!” ");
INSERT INTO mgw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Popopo, bandu boti baabile kabannola aywo mundu mwayi'ma, tola likai lyake no bu'ka. Boti ngabasangala na kunkwi'ya Nnu'ngu' kababaya, “Tunalibonali likowe kati li'no.” ");
INSERT INTO mgw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ayi'i kai' mbwega ya litanda liku'lu' lya Galilaya. Lipi'nga lya bandu ngalinnyendelya, naywembe ngatumbwa kwayi'gana. ");
INSERT INTO mgw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Paabile kapi'ta, ngammona Lawi, mwana wa Alufayo, atami muopisi ya alonga koli. Yesu ngammakia, “Ungi'ngame.” Lawi ngayi'ma, nganki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu paabile kalya munyumba ya Lawi, alonga koli baingi na bene sambi baabile kabalya pamope naywembe na banamasi' bake, kwa mwanjaa kwai na bandu baingi babaabile kabanki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bai, bi'ngi' ba balimu ba salya babaabile Mafalisayo baamweni Yesu kalya pamope na alonga koli na bene sambi. Ngabaalaluya banamasi' bake, “Kwa mwanjaa buli alya pamope na alonga koli na bene sambi?” ");
INSERT INTO mgw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu paayu'wine, ngaabakia, “Bandu bene ukoto bapalali nng'anga, babampala nng'anga balu' bababile atamwe. Niisili kwakema bandu anogau ila bene sambi.” ");
INSERT INTO mgw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Banamasi' ba Yoani Ywabatisage na Mafalisayo baabile kabapunga. Bai, bandu ngabaisa kunnaluya Yesu, “Kwa mwanjaa buli banamasi' ba Yoani na ba Mafalisayo bendapunga lakini banamasi' bako bapungali?” ");
INSERT INTO mgw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ngayangwa, “Buli, babakokilwe kulisengele bapalikwa punga ku'no babile pamope na nkobeki? Pababaa pamope na nkobeki bapalikwali punga. ");
INSERT INTO mgw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini nsimu walu'a ika wo bu'yi'lwa nkobeki kwa akokelwe, na nsimu wo ngapabalu'a punga. ");
INSERT INTO mgw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ntu'pu' mundu ywabi'ka kibamba sayambi' mungu'bo ngona. Mana apangite nyo kibamba sayambi' sapopwana ayo ngu'bo ngona, no popwanika kwake kwamambulya muno. ");
INSERT INTO mgw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wala bandu bayi'yali divai yayambi' mumapu'tu' magona. Mana bapangite nyo divai yalu'a puwana ago mapu'tu', na yembe divai pamope na mapu'tu' yaalabika. Divai yayambi' iyi'yi'lwa mumapu'tu' gayambi'!” ");
INSERT INTO mgw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lisu'ba limo lya Sabato ya Ayahudi, Yesu aabile kapi'ta mumigunda ya ngano. Banamasi' bake ngabatumbwa ti'kwa yeyo ya ngano. ");
INSERT INTO mgw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bai, Mafalisayo ngabammakia Yesu, “Lola, mwanjaa namani banamasi' bako bapanga likowe lyalikanilwa lisu'ba lya Sabato?” ");
INSERT INTO mgw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ngaayangwa, “Buli, munasomali mwaapangite Daudi pamope na aine pabaabile na njala? ");
INSERT INTO mgw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatali paabile mpi'ndo nku'lu' ywa dini, Daudi aayingi munyumba ya Nnu'ngu' no lya makati mapeleteu na kwapeya aine. Yayi'ki'tilweli mundu lya makati go, ila api'ndo ba dini bai.” ");
INSERT INTO mgw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bai Yesu ngaabakia, “Lisu'ba lya Sabato lyabi'kilwe kwa bandu, na kwenda bandu baabi'kilwe kwa lisu'ba lyo lili. ");
INSERT INTO mgw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kwa nyo, Mwana wa Mundu nga Bwana wa Sabato.” ");
INSERT INTO mgw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu aayingi kai' munyumba ya kunnu'ba Nnu'ngu' na amo kwaabile na mundu yumo mwene luboko lutomboloka. ");
INSERT INTO mgw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mafalisayo baabile kabanni'nda bammone kantepwa mundu ywo lisu'ba lya Sabato ya Ayahudi, li'nga kunsitakya. ");
INSERT INTO mgw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ngammakia yu'lu' mundu mwene luboko lutomboloka, “Wise pano pakatikati.” ");
INSERT INTO mgw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bu'kapo ngaalaluya, “Salya yendayi'ki'ti'a panga manogau au maakau lisu'ba lya Sabato? Tepwa au bulaga?” Lakini bembe baayangwili kikowe. ");
INSERT INTO mgw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ngaabu'nju'lya minyo kwa nyongo kanyopa kwa kitumbu sa unonopau wa myoyo yabe, ngammakia yu'lu' mundu, “Golwa luboko lwako.” Ngalugolwa na lwembe ngalupanga lukoti. ");
INSERT INTO mgw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Popopo Mafalisayo ngabapita panja, panga kitamo pamope na bandu ba kipi'nga sa Helode li'nga pala ndi'la ya kummulaga Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu pamope na banamasi' bake ngababu'ka yenda mbwega ya litanda liku'lu' lya Galilaya, na kipi'nga kiku'lu' sa bandu satikunki'ngama. Bandu bo baaumi Galilaya, Yudea, ");
INSERT INTO mgw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yelusalemu, Idumea, kwiyi' ya libi'ndi' lya Yordani, Tilo na Sidoni. Bandu bo baingi bannyendeli Yesu kwa kitumbu baayu'wine makowe maingi gaagapangite. ");
INSERT INTO mgw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu ngaabakia banamasi' bake bammi'ki wiso ngalaba yimo li'nga kipi'nga sa bandu sakane kumpapania. ");
INSERT INTO mgw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aatikwatepwa bandu baingi, na atamwe bambone babaabile kabampapania li'nga bankunywe. ");
INSERT INTO mgw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na bandu babaalobi moka baatu'i pai' kila pabaamweni Yesu kabau'bu'ya malobe, “Wenga nga wa Mwana wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakini Yesu ngagaamulisa kwa ukali' panga kanebannyu'waniye kwa bandu. ");
INSERT INTO mgw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu au'bwike kukitu'mbi', ngaakema bandu baapalike nabembe ngabannyendelya. ");
INSERT INTO mgw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ngaasawa bandu ku'mi na abi'li' nkati yabe, li'nga atame nabo na kwatuma ala, ");
INSERT INTO mgw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na kwapeya uweso wo bi'nga moka. ");
INSERT INTO mgw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bai, ku'mi na abi'li' babaasaulilwe nga aba Simoni (ywaapeyilwe na Yesu lina lya Petili), ");
INSERT INTO mgw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobi na Yoani bana ba Zebedayo (Yesu aapei lina lya Boanerge lombolya kwake, “Bana ba njai”), ");
INSERT INTO mgw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andelea, Pilipi, Batolomayo, Matei, Tomasi, Yakobi mwana wa Alufayo, Tadei, Simoni wa kipi'nga sa Mazeloti na ");
INSERT INTO mgw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda Isikalioti yu'lu' ywaansongi Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bu'kapo Yesu ayi'i kasake. Bandu bambone baatikongolekana kai', kwa kitumbu so ywembe na banamasi' bake baakombwili ata lya kilyo. ");
INSERT INTO mgw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bai, alongo bake pabaayu'wine makowe go ngabayenda kuntola kwa mwanjaa babayage panga ai na lilalu'. ");
INSERT INTO mgw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nabembe balimu ba salya babaabu'i ku Yelusalemu ngababaya, “Ai na Belisebuli! Agabi'nga moka kwa makakala ga mpi'ndo wa moka.” ");
INSERT INTO mgw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Apo Yesu ngaakema na kwabakia kwa ngongo, “Ibilisi akombwabuli kwibi'nga mwene? ");
INSERT INTO mgw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mana ipangite utawala gumo ubaganike iku'ta iku'ta, utawala wo waalu'a kondali. ");
INSERT INTO mgw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kai' mana ipangite alongo bamo babaganike iku'ta iku'ta, ulongo wo waalu'a kondali. ");
INSERT INTO mgw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bai manaitei utawala wa Ibilisi ubaganike iku'ta iku'ta waalu'a kondali, na wayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Lakini ntu'pu' mundu ywakombwa kuitangya nyumba ya mwene makakala na kumpokonywa mali yake, ila ipalikwa wi'ti' antabe aywo mundu mwene makakala, bu'kapo ngapaalu'a kombwa kumpokonywa ili'be yake. ");
INSERT INTO mgw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kakape nimmakianga, bandu baasamilwanga masambi gabe goti na ata mayi'gi'yo gabe ga kupulu, ");
INSERT INTO mgw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lakini ywalongela maakau kwa Loo Mpeleteu, asamilwali katu, aywo ai na ukumu ya sambi yangayomoka.” ");
INSERT INTO mgw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Yesu aalongei go kwa kitumbu baabile kababaya panga, “Ai na moka.”) ");
INSERT INTO mgw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mau' bake Yesu na anunabe baaikite palu', ngabayi'ma panja na kuntuma mundu yenda kunkema. ");
INSERT INTO mgw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bandu bambone baatami po kabanti'li'ta. Bai, ngabammakia, “Lola, mau' bako na anunabo bai panja, bapala kukubona.” ");
INSERT INTO mgw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ngaayangwa, “Mau' bangu' na anunangu' nga kinyai?” ");
INSERT INTO mgw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Apo ngaalola bandu babanti'li'tike kabaya, “Lolange, mwenga nga mwakina mau' bangu' na mwakina nnunangu'! ");
INSERT INTO mgw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu ywoywoti ywapanga gapala Nnu'ngu', aywo nga nku'lwangu', nnu'mbwangu' na mau' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu atumbwi yi'gana kai' abile mbwega ya litanda liku'lu' lya Galilaya. Lipi'nga liku'lu' lya bandu baakongolekine papipi nakwe, kwa nyo ngayingya mungalaba no tama. Bandu boti ngababa batami kuuyu'mu', mbwega ya litanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu aayi'ganie makowe gambone kwa ngongo, na mumayi'gano gake aabakiye, ");
INSERT INTO mgw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mupi'kaniange! Mpandi yumo aayi'i panda mbeyu. ");
INSERT INTO mgw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Paabile kamisa, mbeyu yi'ngi' yaatu'mbu'ki mundi'la na iyuni ngabaisa sonywa. ");
INSERT INTO mgw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yi'ngi' yaatu'mbu'ki pamaliwe pangali ukando wambone, mbeyu yo yasi'yiteli balika kwa mwanjaa ukando wo wayendekiyeli. ");
INSERT INTO mgw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lilumu palyaibalile muno mitombo yo ngaiyu'ma, kwa mwanjaa ngi'ga yake yatotili mubwi'. ");
INSERT INTO mgw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yi'ngi' yaatu'mbu'ki pakatikati ya mimimwa, na mimimwa yaatiku'la na mitombo ngaitola kikolo mpaka yaakombwili yela. ");
INSERT INTO mgw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yi'ngi' yatu'mbu'ki paukando unannoga yaatibalika no ku'la no piya mauno, yimo nombo salasini, yimo sitini na yi'ngi' mya.” ");
INSERT INTO mgw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bu'kapo ngaabakia, “Mwene makutu go yu'wa na ayu'we!” ");
INSERT INTO mgw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pabaabile kisabe, banamasi' ku'mi na abi'li' ba Yesu, pamope na bandu babaabile mbwega yake, ngabannaluya mwailombolya ngongo yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naywembe ngaabakia, “Mwenga muyaliwite kugatanga makowe gangaumukulilwa ga Ukulungwa wa Nnu'ngu', lakini balu' bababile panja babakiyilwa kila kili'be kwa ngongo, ");
INSERT INTO mgw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","li'nga ‘Kakape balole, lakini babonali. Kakape bayu'we, lakini bakwipwali. Mana buli bakanng'alambukya Nnu'ngu', naywembe alu'e kwasamya.’” ");
INSERT INTO mgw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bai Yesu ngaalaluya, “Buli, mwenga munatangali lukongo lu'no? Mwakombwabuli tanga lukongo lwi'ngi'? ");
INSERT INTO mgw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpandi apanda liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbeyu yaitu'mbu'ki mundi'la nga kati bandu babaliyu'wa liyi'gi'yo lya Nnu'ngu', lakini popopo Ibilisi endaisa na kulibu'ya liyi'gi'yo li'lu' lyalipandilwe nkati yabe. ");
INSERT INTO mgw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bandu bi'ngi' nga kati mbeyu yaipandilwe pa maliwe. Pabaliyu'wa liyi'gi'yo lyo bai, balipokya kwo napusika. ");
INSERT INTO mgw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lakini liyingilikali no bi'ka ngi'ga nkati yabe, balikamwa kwa masu'ba masene bai, na mana kupitike tabu au ngu'su'mbu' kwa kitumbu sa liyi'gi'yo lyo, popopo baileka imani. ");
INSERT INTO mgw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bandu bi'ngi' nga kati mbeyu yaitu'mbu'ki pamimimwa. Nga kati balu' babaliyu'wa liyi'gi'yo lyo, ");
INSERT INTO mgw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lakini bembe bagania muno makowe ga padunia yi'no, bautilwa no minyikia mali na tamaa mbali'mbali'. Ago goti ngagalipanga li'lu' liyi'gi'yo likombale no pu'ngwa makakala go panga kasi. ");
INSERT INTO mgw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lakini bi'ngi' nga kati mbeyu yaipandilwe muukando nnogau. Aba nga babaliyu'wa liyi'gi'yo, ngabalipokya no piya mauno. Bi'ngi' salasini, bi'ngi' sitini na bi'ngi' mya.” ");
INSERT INTO mgw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ngayendelya kwabakia, “Buli, bandu bakoya kimuli nnyumba na kukiwi'ki'lya kitu'ndu' au kukibi'ka mmu'ngu'? Lili! Ila bakibi'ka papatu'ndu'bile. ");
INSERT INTO mgw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bai, kila sakiiyilwe salu'a bonekana, sakiwi'ki'lilwe salu'a umukulwa. ");
INSERT INTO mgw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mwene makutu go yu'wa, na ayu'we!” ");
INSERT INTO mgw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ngaabakia kai', “Mupi'kani wiso! Kili'ngo si'si'lu'si'lu' samwali'ngya bandu bi'ngi' nga samwalu'a li'ngi'lwa kai' no yongekeyelwa. ");
INSERT INTO mgw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ywabile na kili'be alu'a yongekeyelwa, ywangali kili'be ata si'lu' sabile naso saatolelwa.” ");
INSERT INTO mgw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ngayendelya longela, “Ukulungwa wa Nnu'ngu' ulandana na mundu ywapandike mbeyu munng'unda. ");
INSERT INTO mgw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Masu'ba goti endegonja no yumuka na mbeyu yatibalika no ku'la. Lakini atangiteli panga ipangikabuli. ");
INSERT INTO mgw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ukando ngawipangia mitombo ku'la no piya yeyo. Ilongolya wi'ti' ipuka lyakapi, bu'kapo seyo na kuundi'la lunombo museyo. ");
INSERT INTO mgw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nombo yo mana ikelile, apo mundu atumbwa una kwa mwanjaa nsimu wo una wikite.” ");
INSERT INTO mgw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kai' Yesu ngabaya, “Ukulungwa wa Nnu'ngu' tuulandanie na ki'li'? Tuuawanikiye kati lukongo gani? ");
INSERT INTO mgw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ubile kati mbeyu ya aladali, mwaibile njene kulikoni mbeyu yi'ngi' yoyoti. ");
INSERT INTO mgw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lakini mana upandilwe no balika, upanga nkongo nku'lu'. Ndambi' yake ipanga ngu'lu' ata kiiyuni bendakombwa senga iyumba yabe mumwili wake.” ");
INSERT INTO mgw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu aalongei na bandu mayi'gi'yo gake kwa ngongo yi'ngi' yambone yaibile kati yo, bu'kana na mwabakombwi yu'wa. ");
INSERT INTO mgw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aalongeili nabo sosoti wangali tumya ngongo, lakini paabile na banamasi' bake bai aabile kaawanikia kila kili'be. ");
INSERT INTO mgw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lisu'ba lyolyolyo kitamwiyo, Yesu ngaabakia banamasi' bake, “Tuloke litanda liku'lu' tuyende kwiyi'.” ");
INSERT INTO mgw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bai, ngabalileka lipi'nga li'lu' lya bandu na kumpu'twa Yesu mungalaba yaabile. Na mangalaba gi'ngi' gaatikunki'ngama. ");
INSERT INTO mgw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kimbu'nga kikali' satumbwi pukatya, mawi'mbi' ngagaiku'mbwa yi'lu' ngalaba na ngaitumbwa twi'lya masi'. ");
INSERT INTO mgw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu aabile nsu'gu' ya ngalaba, agonjike no yegekya ntwe wake pakiyegekyo. Bai, banamasi' ngabannyumuya na kummakia, “Mwalimu, utangite panga twenga twendawaa?” ");
INSERT INTO mgw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bai, ngayumuka ngaukalipya gu'lu' nsunga na kugaamulisa mawi'mbi', “Tama liki! Tu'ya!” Apo kimbu'nga ngakikotoka no tama liki. ");
INSERT INTO mgw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bu'kapo Yesu ngaabakia banamasi' bake, “Mboni mwendayogopa? Buli, ntu'pu' imani?” ");
INSERT INTO mgw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nabembe ngabayogopa muno, ngababa kabalaluyana, “Ayu' nga nyai, ata nsunga na mawi'mbi' gendakunnyu'wa?” ");
INSERT INTO mgw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bai, ngabaika munni'ma wa Agelasi, kwiyi' ya litanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu paaulwike bai mungalaba, popopo ngakwembana nakwe mundu yumo ywaalobi moka aumi kumasiko. ");
INSERT INTO mgw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu ywo atamage kumasiko na ntu'pu' mundu ywaakombwi kuntaba, ata kwa nyololo. ");
INSERT INTO mgw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Baatikuntaba mundu ywo kwa pingwi na minyololo, lakini kila pabantaba, aatikwikutwana minyololo yo na kwiti'kwana pingwi yo, wala ntu'pu' mundu ywaakombwi kunkanikiya. ");
INSERT INTO mgw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kilo na muntwekati atamage kumasiko na muitu'mbi' kakemelya na kwitema kwa maliwe. ");
INSERT INTO mgw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Paamweni Yesu kwa kuutalu, aatikummutukya no kilikita nnu'ngi' yake ");
INSERT INTO mgw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kalongela kwa lilobe liku'lu', “Ubile na ki'li' nanenga, wenga wa Yesu, Mwana wa Nnu'ngu' ywabile panani ya ili'be yoti. Kwa lina lya Nnu'ngu' nikulu'ba kaneuniku'su'mbwe!” ");
INSERT INTO mgw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Aalongei nyo kwa mwanjaa Yesu ammakie, “Moka, mmu'ke mundu yu'.”) ");
INSERT INTO mgw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu ngannaluya, “Lina lyako wanyai?” Naywembe ngayangwa, “Lina lyangu' na ‘Yesi,’ lombolya twenga twabambone.” ");
INSERT INTO mgw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bu'kapo ngannu'ba Yesu panga kaneagabi'nge moka go munni'ma gu'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na palu' pakitu'mbi' sa papipi paabile na lipi'nga lya magu'be kabaipalya ilyo. ");
INSERT INTO mgw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bai, ago moka ngagannu'ba panga, “Utuyi'ki'ti'e li'nga tukaayingi balu' magu'be.” ");
INSERT INTO mgw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Naywembe ngagayi'ki'ti'ya. Bai, galu' moka ngagabu'ka kwa yu'lu' mundu no yingya kwa magu'be. Magu'be gagaabile elupu ibi'li' gaaeli pakitu'mbi' mpaka pa litanda liku'lu', ngagatumbukya mumasi' no swikya. ");
INSERT INTO mgw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Asungi ba galu' magu'be baatitila, ngabaliyaulya likowe lyo mukilambo na mumigunda. Bandu ngabaisa lola gagaapitike. ");
INSERT INTO mgw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngabannyendelya Yesu, ngabammona na mundu yu'lu' ywaabile alobi moka atami, aweti ngu'bo na malango gake ganki'li'bu'kile, ngabayogopa. ");
INSERT INTO mgw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bandu babaalibweni likowe lyo, ngabaawanikia bi'ngi' makowe gagampatike aywo mundu ywaalobi moka na abali ya galu' magu'be. ");
INSERT INTO mgw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bai ngabatumbwa kunnu'ba abu'ke munni'ma wabe. ");
INSERT INTO mgw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu paabile kau'bu'ka mungalaba, yu'lu' mundu ywaalobi moka ngannu'ba balongwane. ");
INSERT INTO mgw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini Yesu aatikunkania. Paali pake ngammakia, “Uyende kaya kwa alongobo, ukabakiye makowe goti Bwana gakupangile na mwakubi'ki kiya.” ");
INSERT INTO mgw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bai, mundu ywo ngayenda awanikia akwo Dekapoli makowe goti gaapangilwe na Yesu, na bandu boti baatisangala. ");
INSERT INTO mgw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu aloki kai' liyi' li'ngi' lya litanda liku'lu' lya Galilaya kwa ngalaba. Lipi'nga lya bandu ngalikongolekana nnu'ngi' yake, naywembe abile ayi'mi mbwega ya litanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bu'kapo ngaisa mundu yumo nku'lu' ywa nyumba ya kunnu'ba Nnu'ngu' ywakemelwage Yailo. Paamweni Yesu, ngaitaikulya nnu'ngi' yake, ");
INSERT INTO mgw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nganku'ku'li'kya kabaya, “Biti wangu' nsene endakomya. Sondesonde nikulu'ba tubu'ke ukammi'ki moko gako li'nga ayu'yu'ki'lwe no lama.” ");
INSERT INTO mgw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bai, Yesu ngayenda pamope nakwe. Bandu baingi baatikunki'ngama na ngababa kabapatigana kila pandu. ");
INSERT INTO mgw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na nkati yabe kwabile na nnwawa yumo mwene utamwe wa nkongomokwa kwa myaka ku'mi na ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nnwawa ywo aatiauka muno kwo yenda kwa mapundi bambone. Pamope no panga aatumi mali yake yoti, ayu'yu'kilweli ila ayendeli minya muno. ");
INSERT INTO mgw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Paayu'wine abali ya Yesu, nnwawa ywo aatiisa no yingya pakatikati ya lipi'nga lya bandu kusu'gu' ya Yesu no kunywa ngu'bo yake. ");
INSERT INTO mgw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aapangite nyo kwa mwanjaa aabaite pamwoyo wake panga, “Mana nikunywile ngu'bo ya Yesu bai, nalu'a yu'yu'ki'lwa.” ");
INSERT INTO mgw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Popopo nkongomokwa wake ngauyu'ma na ngaibona payi'ga yake panga payu'yu'kilwe. ");
INSERT INTO mgw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Popopo Yesu ngakwipwa panga makakala gaammu'i. Bai ngaligalambukya li'lu' lipi'nga lya bandu, ngalaluya, “Nyai ywakunywi ngu'bo yangu'?” ");
INSERT INTO mgw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Banamasi' bake ngabannyangwa, “Wendakwabona bandu mwabakupapania! Mbona ulaluya nyai ywakukunywile?” ");
INSERT INTO mgw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu ayendeli linga, li'nga ammone nyai ywapangite nyo. ");
INSERT INTO mgw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Apo yu'lu' nnwawa atangite gagampatike, ngapitya kwo lendema kayogopa, ngaitaikulya nnu'ngi' ya Yesu no baya ukakape woti. ");
INSERT INTO mgw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ngammakia, “Biti, imani yako ikutepwile. Uyende kwa amani, utamwe wako uyu'yu'kilwe.” ");
INSERT INTO mgw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu paabile balo kalongela, bandu baaisi bu'ka kunyumba ya Yailo, ngabammakia, “Biti wako ayomwike. Kwa buli uyendelya kumwauya mwalimu?” ");
INSERT INTO mgw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lakini Yesu api'kanili mayi'gi'yo gabe, ngammakia Yailo, “Kaneuyogope, uu'bi'li bai.” ");
INSERT INTO mgw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wala annyi'ki'tiyeli mundu ywoywoti longwana nakwe ila Petili, Yakobi na Yoani nnunawe. ");
INSERT INTO mgw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pabaaikite kunyumba yake, Yesu ngayu'wa ndu'ti, kili'lo no lombola muno. ");
INSERT INTO mgw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngayingya nnyumba ngaabakia, “Mboni mupanga ndu'ti no li'la? Biti anawaali ila atigonja bai.” ");
INSERT INTO mgw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bembe ngabamweka kwa kunsalawa. Bai ngaabi'ngya panja boti, ngaatola abelei ba yu'lu' biti na balu' banamasi' bake yingya ku'lu' kuswi kwaabile aywo biti. ");
INSERT INTO mgw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bu'kapo ngankamwa luboko, ngammakia, “Talita, koumu,” lombolya kwake, “Biti, nikubakia, uyumuke!” ");
INSERT INTO mgw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Popopo biti ywo ngayi'ma, tumbwa tyanga. (Aabile ywa nng'elo wa myaka ku'mi na ibi'li'.) Apo bandu baatisangala pi'ta. ");
INSERT INTO mgw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ngaaking'indya kanebammakie mundu likowe lyo. Bu'kapo ngaabakia bampei kilyo aywo biti. ");
INSERT INTO mgw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Apo Yesu ngabu'ka akwo, buyangania kukilambo sake sa ku Nasaleti pamope na banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Paliikite lisu'ba lya Sabato ya Ayahudi, ngatumbwa yi'gana munyumba ya kunnu'ba Nnu'ngu', na bandu baingi pabannyu'wine baatisangala. Nabembe ngabalaluya, “Mundu yu' apatike kwaku' makowe aga goti? Ayi' ilimu yatumya ya sampuli yaku'? Kwa makakala gani apanga mangelongelo goti ga? ");
INSERT INTO mgw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Buli, kanga yu'lu' selemala li, mwana wa Malia? Na alongobe nga Yakobi, Yose, Yuda na Simoni au lili? Akina alu'mbu'be boti babileli na twenga pano?” Nabembe ngabausika muno kwa kitumbu sake, ngabakana kumwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ngaabakia, “Nnondoli ywa Nnu'ngu' endaisimilwa kila pandu, lakini munni'ma wake na panyumba yake aisimilwali!” ");
INSERT INTO mgw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kwa nyo, Yesu aakombwili panga mangelongelo, ila aabi'ki maboko atamwe asene na kwatepwa. ");
INSERT INTO mgw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Naywembe ngasangala muno kwa kitumbu sa bembe kotoka baa na imani ata pasene. Bu'kapo Yesu aityangili ilambo ya palu' papipi, kaayi'gana bandu. ");
INSERT INTO mgw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngaakema balu' banamasi' ku'mi na abi'li', ngatumbwa kwatuma abi'li' abi'li' na kwapeya uweso wo bi'nga moka. ");
INSERT INTO mgw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ngaalagya panga, “Mumwanja winu kanemutole kili'be sosoti ila pimbo bai. Kanemutole likati wala utingo, wala mbanje muiwindu yinu. ");
INSERT INTO mgw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muwalange ilatu, lakini kanemupu'twe nganju yo galambwa.” ");
INSERT INTO mgw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kai' ngaabakia, “Nyumba yoyoti yabaalu'a kunkemya, mwaatame po mpaka pamwaalu'a bu'ka pandu po. ");
INSERT INTO mgw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na pandu popoti pabaalu'a kotoka kunkemya au kumpi'kanianga, mwaabu'ke po no kung'unda lyu'ku'mbi' mumagu'lu' ginu, kati kwakwi'li'ka panga Nnu'ngu' endakana.” ");
INSERT INTO mgw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kwa nyo ngababu'ka no ala panga bandu boti bapalikwa galambuka na kugaleka masambi gabe. ");
INSERT INTO mgw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ngababi'nga moka maingi no tepwa atamwe baingi kwa kwapakaya mauta. ");
INSERT INTO mgw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bai, Nkulungwa Helode ngayu'wa abali yo, kwa mwanjaa lina lya Yesu lyaabile liyu'wanike lwingo lwoti. Bi'ngi' babe baabile kababaya, “Yoani Ywabatisage atiyu'ka bu'ka kuuwi'li, nga kitumbu sa makakala ga gagapanga kasi nkati yake.” ");
INSERT INTO mgw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bi'ngi' baabaite, “Mundu yu' nga Elia.” Bi'ngi' baabaite, “Ayu' nga nnondoli ywa Nnu'ngu' kati alondoli bi'ngi' ba kwai'mbu'.” ");
INSERT INTO mgw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lakini Helode paayu'wine abali yi', ngabaya, “Ayu' nga Yoani Ywabatisage, ywanaansinjite, atiyu'ka bu'ka kuuwi'li.” ");
INSERT INTO mgw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Helode aapiyite amuli ya kummoywa Yoani na kummi'ka munyumba ya atabilwe. Aapangite nyo kwa kitumbu sa Helode kunkobeka Helodia ywaabile nnyumbo wa Pilipi nku'we. ");
INSERT INTO mgw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yoani ammakie Helode panga, “Mwilo wenga kunkobeka nnwawa ywaakobekilwe na nku'go.” ");
INSERT INTO mgw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bai Helodia ngaansukya muno Yoani, ngapala kummulaga lakini aakombwili, ");
INSERT INTO mgw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode aannyogwipe Yoani kwa mwanjaa aatangite panga ywembe mundu mwene aki na mpeleteu, kwa nyo ngaani'ndi'la. Helode pannyu'wine Yoani, aatiauka muno pamope no panga aapulaike kumpi'kania. ");
INSERT INTO mgw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bai, lisu'ba limo Helodia aapatike ndi'la ya kummulaga Yoani. Lisu'ba lyo lyabile lya si'li'ku'si'li'ku' ya ngu'mbu'ku'mbu' yo belekwa kwa Helode, na Helode aakemite ayi'mi'li'ki bake, api'ndo ba asikali na api'ndo ba nkoa wa Ku Galilaya. ");
INSERT INTO mgw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Biti wake Helodia payingile, aatiina, ngampulaisa Helode pamope na ageni bake. Nkulungwa Helode ngammakia yu'lu' biti, “Unilu'be kili'be sosoti saupala, nanenga nilu'a kupeya.” ");
INSERT INTO mgw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kai' ngakong'ondelya kwo lapa panga, “Nilu'a kupeya sosoti saulu'a nilu'ba, ata ikatei nusu ya ukulungwa wangu'.” ");
INSERT INTO mgw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yu'lu' biti ngapita panja, ngayenda kwalaluya mau' bake, “Nilu'be ki'li'?” Mau' bake ngannyangwa, “Ulu'be ntwe wa Yoani Ywabatisage.” ");
INSERT INTO mgw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yu'lu' biti ngaki'li'bu'ka kiyu'ngu'ya kwa nkulungwa, ngammakia, “Nipala unipei papanopano ntwe wa Yoani Ywabatisage mukyani.” ");
INSERT INTO mgw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nkulungwa nganyopa muno, lakini kwa mwanjaa aabile alapite nnu'ngi' ya ageni bake, aapaili kunkania. ");
INSERT INTO mgw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Papalu'palu' nkulungwa ngatuma asikali leta ntwe wa Yoani. Ngayenda kunsinja Yoani munyumba ya atabilwe, ");
INSERT INTO mgw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ngauleta ntwe mukyani na kumpeya yu'lu' biti, naywembe ngaakamukiya mau' bake. ");
INSERT INTO mgw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Banamasi' ba Yoani pabapatike abali, ngabayenda tola yi'ga yake no yenda sika. ");
INSERT INTO mgw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Balu' banamasi' baabuyangani kwa Yesu na kumpeya abali ya makowe goti gabaapangite no yi'gana. ");
INSERT INTO mgw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bai, bandu bambone baabile kabaisa no bu'ka, kwa nyo Yesu na banamasi' bake baapatikeli ata lipala lyo lya. Na po Yesu ngaabakia banamasi' bake panga, “Mwisange, tubu'ke pandu pakiyi'ki'ya tukapu'mu'li pasene.” ");
INSERT INTO mgw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kwa nyo ngababu'ka kwa ngalaba bembe kisabe, yenda pandu pakiyi'ki'ya. ");
INSERT INTO mgw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini bandu baingi pabaabweni kababu'ka, ngabaakwipwa, nabembe ngabayenda kiyu'ngu'ya kwa magu'lu' bu'ka muilambo yoti, na abo bandu ngabalongolya ika. ");
INSERT INTO mgw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ngalaba paiikite kumbwani, Yesu alibweni lipi'nga liku'lu' lya bandu, ngaalibi'kya kiya kwa mwanjaa lyaabile kati ngondolo bangali nsungi. Ngatumbwa kwayi'gana makowe gambone. ");
INSERT INTO mgw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ata palyabile lisu'ba kalipilya, banamasi' bake Yesu baatikunnyendelya na kummakia, “Pandu pano palupu'ngu'ti' sika na lisu'ba lipilile, ");
INSERT INTO mgw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","nantali waalage bandu ba li'nga bayende kumigunda na kumisengo ya papipi bakapi'me ilyo.” ");
INSERT INTO mgw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lakini Yesu ngaabakia, “Mwapei ilyo mwenga.” Nabembe ngabannaluya, “Buli, tukapi'me makati kwa mbanje dinali mya ibi'li', na kwapeya ilyo?” ");
INSERT INTO mgw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu ngaalaluya, “Mubile na makati gali'nga? Muyende mukalinge.” Pabalingite, ngabammakia, “Kubile na makati matano na omba abi'li'.” ");
INSERT INTO mgw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bai Yesu ngaamulisa banamasi' bake baatamike pai' mumanyei bandu boti muiku'ta iku'ta. ");
INSERT INTO mgw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nabembe ngabatama muiku'ta iku'ta ya bandu mya na ya bandu amusini. ");
INSERT INTO mgw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bu'kapo Yesu ngagatola galu' makati matano na balu' omba abi'li', ngalola kunani no sukulu, ngagametwa makati na kwapeya banamasi' bake baabagane bandu. Na balu' omba abi'li' nyinyonyo aabagine boti. ");
INSERT INTO mgw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bandu boti baatilya no yukuta. ");
INSERT INTO mgw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nabembe banamasi' bake ngabakongwa makombo ga makati na omba, ngabatwi'li'ya itu'ndu' ku'mi na ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Isabu ya bandu babaalile makati yaabile analu'me elupu tano. ");
INSERT INTO mgw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Popopo, Yesu ngaabakia banamasi' bake bau'bu'ke mungalaba, bannongoli yenda Betisaida, kwiyi' ya litanda liku'lu', apo ywembe aabile kailaga ipi'nga ya bandu. ");
INSERT INTO mgw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bu'ka pa kwalaga balu' bandu, ngayenda kukitu'mbi' lu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pakupilile yi'lu' ngalaba yaabile iikite pakatikati ya litanda liku'lu', na Yesu aabile kisake kuuyu'mu'. ");
INSERT INTO mgw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ngaabona banamasi' bake kabaauka endelesa ngalaba yo, kwa mwanjaa nsunga waabile kawaaki'li'bu'ya nsu'gu'. Bai kakupala saa, Yesu ngaayendelya banamasi' bake katyanga panani ya masi'. Ngapala kwapi'ta, ");
INSERT INTO mgw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","lakini pabamweni katyanga panani ya masi', baganiyage panga lyoka, ngabakemelya, ");
INSERT INTO mgw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwa mwanjaa boti pabaamweni baatiyogopa. Apo Yesu ngaabakia, “Mukangamale! Nga nenga, kanemuyogope!” ");
INSERT INTO mgw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Naywembe ngau'bu'ka nkati ya ngalaba, na wu'lu' nsunga ngautama liki. Nabembe ngabasangala muno, ");
INSERT INTO mgw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwa mwanjaa baabile banakwipwali kitumbu sa galu' mangelongelo ga makati. Malango gabe gaai ganayu'gu'kali. ");
INSERT INTO mgw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ata pabayomwi loka, ngabaika kunni'ma wa Genesaleti no tabya ngalaba yabe mulipi'pi'li'. ");
INSERT INTO mgw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bu'ka po uluka mungalaba, popopo bandu ngabankwipwa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ngabayenda kiyu'ngu'ya muilambo yoti, no tumbwa kwapu'twa atamwe mumakai li'nga kwapeleka pandu popoti pabaayu'wine panga Yesu abile po. ");
INSERT INTO mgw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila pandu Yesu paayi'i, ibe muilambo, mumisengo au mumigunda, bandu baabi'i atamwe babe mumasoko. Ngabannu'ba aayi'ki'ti'ye abo atamwe bakunywe ata mpembo wa ngu'bo yake. Na boti babaakunywile ngabatepulwa. ");
INSERT INTO mgw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo na bi'ngi' ba balimu ba salya ya Musa babaabile babu'kite Yelusalemu ngabakongolekana nnu'ngi' ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ngabaabona bi'ngi' ba banamasi' bake kabalya makati kwa maboko gangali uluwa kati mwaipalikwa na salya ya dini ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Saai kiku'balo kwa Mafalisayo na Ayahudi boti kwa mwanjaa bembe balyali kilyo wangali uluwa kwo kotea mimu ya api'ndo babe. ");
INSERT INTO mgw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pababuya kusoko bawesali lya wangali uluwa. Kai' kwina mimu yi'ngi' yambone yabakotea, kati gu'lwa ikombe, iteleko na yombo ya yu'ma. ");
INSERT INTO mgw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bai, Mafalisayo na balimu ba salya ngabannaluya Yesu panga, “Mwanjaa namani banamasi' bako bakotali mimu ya api'ndo bitu? Balya kilyo wangali uluwa maboko!” ");
INSERT INTO mgw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ngaayangwa, “Nnondoli ywa Nnu'ngu' Isaya alongei makowe ga kakape paalondwi kwa abali yinu mwenga, mwenga mwaanapiki. Kati mwaandike, ‘Nnu'ngu' abaya, bandu ba baniisimu kwa mikano bai lakini mumyoyo yabe babile kuutalu nanenga. ");
INSERT INTO mgw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kunikilikitya kwabe kupwaikali kwa mwanjaa malagyo gabagayi'gana ga Nnu'ngu' li, ila ga bandu bai.’ ");
INSERT INTO mgw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mwenga mwiileka amuli ya Nnu'ngu' no kamuliya mimu ya bandu.” ");
INSERT INTO mgw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ngayendelya baya, “Mwenga mubile na ndi'la inannoga yo kana kamwa amuli ya Nnu'ngu' li'nga mupate kamwa mimu yinu. ");
INSERT INTO mgw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mwanjaa Musa aabaite, ‘Waisimu tati' bako na mau' bako,’ na, ‘Ywoywoti ywaatukana tati' bake au mau' bake apalikwa bulagilwa.’ ");
INSERT INTO mgw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini mwenga mubaya panga mundu abe na kili'be sa kwayangatia abelei bake, lakini mana ammakie panga kili'be si'lu' sa ‘Kobane’, (lombolya kipiyilwe panga salaka mbeletau kwa Nnu'ngu'), ");
INSERT INTO mgw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bai apalikwali kai' kwayangatia abelei bake. ");
INSERT INTO mgw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwo panga nyo, ngapamulisalawa liyi'gi'yo lya Nnu'ngu' kwa kitumbu sa mimu yamupokile. Kai' mupanga makowe maingi gagalandana na ga.” ");
INSERT INTO mgw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu ngakikema kai' si'lu' kipi'nga sa bandu, ngaabakia, “Kwa kila yumo ywinu, anipi'kani na mulitange likowe li'. ");
INSERT INTO mgw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ntu'pu' kili'be sakiuma panja sakikombwa kunnyi'ya mundu usapu wa loo, lakini si'lu' sakimpita bu'ka nkati ngasakilu'a kunnyi'ya usapu wa loo. ");
INSERT INTO mgw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mwene makutu go yu'wa, na ayu'we.” ");
INSERT INTO mgw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bu'ka pakukileka si'lu' kipi'nga sa bandu no yingya nnyumba, banamasi' bake ngabannaluya kilombolyo sa lukongo lu'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ngaayangwa, “Buli ata mwenga munatangali? Buli, munatangali panga kili'be sakinnyingya mundu uma panja kinnyi'yali usapu wa loo? ");
INSERT INTO mgw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mundu mana alile kilyo, kiyingyali mumwoyo wake ila nndumbo, bu'kapo kilu'a piyilwa panja ya yi'ga yake.” (Kwo baya nyo Yesu aayi'ki'tiye panga yakulya yoti ili'li'lwe bai.) ");
INSERT INTO mgw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngayendelya baya, “Si'lu' sakimpita mundu, ngasakinnyi'ya usapu wa loo. ");
INSERT INTO mgw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa mwanjaa bu'ka nkati ya mwoyo wa mundu, ngakupita maganio manyatau, upege, bwii, ubulagi, ");
INSERT INTO mgw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ugoni, bwimi, ulau, ukongani, mila muno, bwigu, matukano, umbu'ku'su' na ulogeloge. ");
INSERT INTO mgw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aga malau goti gabu'ka nkati ya mundu, na gembe ngaganyi'ya mundu usapu wa loo.” ");
INSERT INTO mgw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Apo Yesu ngabu'ka yenda kuwilaya ya Tilo. Ngayingya munyumba yimo na aapaili mundu ywoywoti atange panga ai mo, lakini aakombwili yu'ba. ");
INSERT INTO mgw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Akwo kwai na nnwawa yumo ywembe biti wake nsene aai na moka, aayu'wine abali ya Yesu. Bai ngaisa kwitaikulya pamagu'lu' gake. ");
INSERT INTO mgw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bai aywo nnwawa aabileli Nnyahudi, ila aabelekuli Foinike ya ku Silia. Ngannu'ba Yesu abi'nge moka kwa biti wake. ");
INSERT INTO mgw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu ngammakia, “Waleke wi'ti' bana bayukute, kwa mwanjaa inogelelyali tola kilyo sa bana na kwataikulya mapwa.” ");
INSERT INTO mgw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lakini yu'lu' nnwawa ngannyangwa, “Kakape Bwana, lakini ata mapwa bababile pai' ya mesa balya mbolotya yabapoloya bana.” ");
INSERT INTO mgw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ngammakia, “Apo ulongei wiso. Tumbwelelo, uyende bai kasako, biti wako moka ammu'kite.” ");
INSERT INTO mgw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ngayenda kasake na kunkolya biti wake agonjike pakindanda, yu'lu' moka ammu'kite. ");
INSERT INTO mgw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bu'kapo Yesu ngabu'ka kuwilaya ya Tilo, aapi'ti Sidoni, ngaika kulitanda liku'lu' lya Galilaya munni'ma wa Dekapoli. ");
INSERT INTO mgw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akwo bandu ngabannetya Yesu mundu yumo kiibamakutu, kai' mwene kimama, ngabannu'ba Yesu abi'ke maboko panani ya aywo mundu li'nga akombwe yu'wa no longela. ");
INSERT INTO mgw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu ngammu'ya yu'lu' kiibamakutu pakipi'nga sa bandu yenda nakwe pakisake, ngannyi'ya ngonji yake mumakutu gake, ngauna mmata na kunkunywa lulimi kwa galu' mmata. ");
INSERT INTO mgw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bu'kapo ngalingulya kunani, ngauta mbu'mwo no eleya na kummakia, “Efata” lombolya, “Yu'gu'ka.” ");
INSERT INTO mgw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Papalu'palu' makutu na lulimi lwake ngaiyu'gu'ka. Ngatumbwa yu'wa no longela wisowiso. ");
INSERT INTO mgw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ngaaking'indya kanebammakie mundu, lakini kwa kila mwaaking'indyage panga kanebabaye, bembe ngabayongeya yaulya abali yo. ");
INSERT INTO mgw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ngabasangala muno, ngababaya, “Makowe goti gaapangite manogau muno, ata aapangiye aibamakutu bayu'we na bene kimama balongele wisowiso.” ");
INSERT INTO mgw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mumasu'ba galu' kipi'nga sa bandu saatikongolekana kai'. Nabembe pabaakosike kilyo, Yesu ngaakema banamasi' bake na kwabakia, ");
INSERT INTO mgw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Asi' kipi'nga sa bandu nikibi'kya kiya, kwa mwanjaa batami pamope nanenga kwa masu'ba gatatu na nambi'yambi' ntu'pu' kilyo. ");
INSERT INTO mgw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mana naabakiye bayende kasabe pangali lya baalu'a induka mundi'la, kwa mwanjaa bi'ngi' babe baaumi kuutalu.” ");
INSERT INTO mgw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Banamasi' bake ngabannyangwa, “Pano patubileye palupu'ngu'ti' sika, tulwapata kwaku' makati ga kwali'ngana bandu ba boti?” ");
INSERT INTO mgw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ngaalaluya, “Mubile na makati gali'nga?” Ngabayangwa, “Tubile na makati saba.” ");
INSERT INTO mgw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu ngaamulisa boti batame pai', ngatola galu' makati saba, ngasukulu, ngagametwana na kwapeya banamasi' bake li'nga baabagane bandu. Nabembe ngabapanga nyo. ");
INSERT INTO mgw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kai' kwaabile na tuomba tusini. Yesu ngasukulu, na kwaamulisa banamasi' bake baabagane bandu. ");
INSERT INTO mgw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Balu' bandu ngabalya no yukuta. Bu'kapo banamasi' ngabakongwa makombo gagaaigile, ngabatwi'li'ya itu'ndu' saba. ");
INSERT INTO mgw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bandu babaalile baai pipi na elupu nsese. Bu'kapo ngaalaga. ");
INSERT INTO mgw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Popopo Yesu ngau'bu'ka mungalaba pamope na banamasi' bake, yenda lwingo lwa Dalmanuta. ");
INSERT INTO mgw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo ngabaisa no tumbwa taukana na Yesu li'nga kumpi'ndi'ka. Ngabannu'ba aalaye mwasu waubu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nganyopa pamwoyo wake na ngaabakia, “Kwa mwanjaa namani lubelekwo lu'no lupala mwasu? Kakape nimmakianga, lupeyelwali mwasu wowoti.” ");
INSERT INTO mgw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bai, ngaaleka, no u'bu'ka kai' ngalaba, tumbwa mwanja wo yenda liyi' lyenebi'li' lya litanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Banamasi' baatilibalya pu'twa makati gambone, ila mungalaba yabe babile na likati limo bai. ");
INSERT INTO mgw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu ngaabakia, “Mwili'ndi'le na ulu'u wa Mafalisayo na Helode.” ");
INSERT INTO mgw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Banamasi' baatumbwi longelya bene na bene panga, “Alongela nyo kwa kitumbu tubileli nago makati.” ");
INSERT INTO mgw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu ngagakwipwa makowe gabalongela, bai ngaalaluya, “Kwa mwanjaa namani mulongelya bu'kana no kotoka ba na makati? Buli, balo munakwipwali wala tanga? Buli, malango ginu balo ganayu'gu'kali? ");
INSERT INTO mgw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mubile na minyo, lakini mukibonali kili'be? Mubile na makutu, lakini muyu'wali? Buli wala muku'mbu'kyali? ");
INSERT INTO mgw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Panaagametwi galu' makati matano na kwapeya bandu babapi'ta elupu tano, mwakongwi itu'ndu' ili'nga ya makombo?” Ngabannyangwa, “Ku'mi nebi'li'.” ");
INSERT INTO mgw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na panaagametwi galu' makati saba na kwapeya bandu elupu nsese, mwakongwi itu'ndu' ili'nga ya makombo?” Ngabannyangwa, “Saba.” ");
INSERT INTO mgw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bai, ngaabakia, “Na balo munatangali?” ");
INSERT INTO mgw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu na banamasi' bake ngabaika Betisaida. Ku'lu' ngabannetya mundu yumo mbulibuli na kunnu'ba Yesu ankunywe li'nga ayu'yu'ki'lwe. ");
INSERT INTO mgw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ngaankamwa luboko aywo mbulibuli na kumpeleka panja ya kilambo. Ngaamwunia mmata muminyo, ngaammi'kya moko, ngannaluya, “Buli, wendakombwa kukibona kili'be?” ");
INSERT INTO mgw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yu'lu' mbulibuli ngalola, ngabaya, “Naabona bandu, lakini babonekana kati mikongo yaityanga.” ");
INSERT INTO mgw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bu'kapo, Yesu ngaammi'kya kai' moko muminyo. Minyo gake ngagayu'gu'ka, ngatumbwa lola na kukibona kila kili'be wisowiso. ");
INSERT INTO mgw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu aammakie ayende kasake na kumwamulisa, “Kaneubuye mukilambo.” ");
INSERT INTO mgw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bu'kapo Yesu na banamasi' bake, ngabayabwa yenda muilambo ya Kaisalia Filipi. Pabaabile mundi'la Yesu aatikwalaluya, “Bandu babaya nenga nanyai?” ");
INSERT INTO mgw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngabannyangwa, “Bi'ngi' babaya wenga wa Yoani Ywabatisage, bi'ngi' babaya wa Elia na bi'ngi' babaya wa yumo ywa alondoli ba Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Naywembe ngaalaluya, “Na mwenga buli, mubaya nenga nanyai?” Petili ngannyangwa, “Wenga ngawa Kilisitu.” ");
INSERT INTO mgw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bu'kapo Yesu ngaaking'indya kanebammakie mundu ywoywoti abali yake. ");
INSERT INTO mgw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Apo Yesu ngatumbwa kwayi'gana banamasi' bake kabaya, “Ipalikwa Mwana wa Mundu ateselwe no kanilwa na ayi'mi'li'ki ba bandu, api'ndo ba dini na balimu ba salya. Kai' ipalikwa abulagilwe no yu'ka lisu'ba lyenetatu.” ");
INSERT INTO mgw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aagabaite ga mpu'la, apo Petili ngantola Yesu no tumbwa kunkwi'li'ka. ");
INSERT INTO mgw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lakini Yesu ngaagalambukya na kwalingulya banamasi' bake, ngankwi'li'ka Petili kwa kummakia, “Ubu'ke nnu'ngi' yangu' wenga wa Ibilisi! Wenga uganiali gagabile ga Nnu'ngu', ila ugania gagabu'ka kwa bandu bai.” ");
INSERT INTO mgw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bu'kapo ngakikema si'lu' kipi'nga sa bandu pamope na banamasi' bake na kwabakia, “Mana mundu kapala kuniki'ngama, aikane mwene na aupu'twe nsalaba wake aniki'ngame. ");
INSERT INTO mgw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwa mwanjaa ywoywoti ywapala kuukosopolya bwu'mi wake alu'a kuuobeya, lakini ywoywoti ywauobeya bwu'mi wake kwa kitumbu sangu' nenga na kwa abali inannoga, aalu'a kuukosopolya. ");
INSERT INTO mgw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Buli, mundu aalu'a pata namani kwipata dunia yoti, na kuuobeya bwu'mi wake? ");
INSERT INTO mgw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Au mundu aalu'a piya namani pandu pa bwu'mi wake? ");
INSERT INTO mgw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lu'no lubelekwo lwene sambi na lwangali u'bi'li'ka. Bai, mundu ywoywoti ywanibi'kya oni nenga na mayi'gano gangu', Mwana wa Adamu naywembe aammi'kya oni mundu ywo lisu'ba lya alu'a buya muutukupu wa Tati' bake abile na malaika bake apeleteu.” ");
INSERT INTO mgw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ngayendelya kwabakia, “Kakape nimmakianga, babile bi'ngi' papanopano baalu'a panga banawaali pangali kuubona Ukulungwa wa Nnu'ngu' kawisa kwa makakala.” ");
INSERT INTO mgw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagapite masu'ba sita, Yesu ngaatola Petili, Yakobi na Yoani, ngaapeleka pakitu'mbi' kilaso pandu pakiyi'ki'ya. Akwo Yesu ngagalambuka ywoti nnu'ngi' yabe. ");
INSERT INTO mgw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Magu'bo gake gaatimelemetya, ngagapanga mauu muno, wala pano padunia ntu'pu' nkusili ywawesa kusa ipange uu kati nyo. ");
INSERT INTO mgw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Musa na Elia ngabapitya, ngababa kabalongela na Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petili ngammakia Yesu, “Mwalimu, inogelile twenga baa pano. Utuyi'ki'ti'ye tusenge isewe itatu, simo sako, si'ngi' sa Musa na si'ngi' sa Elia.” ");
INSERT INTO mgw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petili aatangiteli lyo longela kwa mwanjaa ywembe na aine baabile kabayogopa muno. ");
INSERT INTO mgw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bu'kapo lyunde ngalyaawi'ki'lya na lilobe lyayuwanike bu'ka mulyunde lyo, “Ayu' nga Mwana wangu' ywanimpendile, mumpi'kani ywembe.” ");
INSERT INTO mgw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Papalu'palu' pabalinguli ku'no na akwo, baamwenili kai' mundu ywi'ngi' kati yabe ila Yesu kisake. ");
INSERT INTO mgw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pabaabile kabaelya bu'ka kukitu'mbi', Yesu ngaaking'indya, “Kanemummakie mundu ywoywoti makowe gamugabweni, mpaka Mwana wa Mundu paalu'a yu'ka bu'ka kuuwi'li.” ");
INSERT INTO mgw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bai, ngabaliiya likowe lyo bene, lakini baabile kabalaluyana, “Yu'ka kwa awi'li kulombolya namani?” ");
INSERT INTO mgw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngabannaluya Yesu, “Mboni balimu ba salya babaya panga Kilisitu abile balo isa aalongolya wi'ti' Elia?” ");
INSERT INTO mgw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu ngaayangwa, “Kakape Elia aapalikwa buya wi'ti' li'nga bi'ka wiso makowe goti. Lakini mwanjaa namani iandikilwe panga Mwana wa Mundu alu'a teselwa muno no salaulilwa? ");
INSERT INTO mgw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakini nimmakianga Elia ayomwike isa, nabembe ngabampangya maakau goti gabapalage, kati mu'lu' mwayaandikilwe kwa ywembe.” ");
INSERT INTO mgw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu, Petili, Yoani na Yakobi pabaabuyangine bu'ka kukitu'mbi', ngabakikolya kipi'nga kiku'lu' sa bandu. Bi'ngi' ba balimu ba salya kabataukana na banamasi' bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Balu' bandu pabamweni Yesu baatisangala muno, popopo ngabammutukya li'nga kumpanga abali. ");
INSERT INTO mgw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngaalaluya banamasi' bake, “Mutaukana nabo kwa kitumbu saku'?” ");
INSERT INTO mgw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mundu yumo mu si'lu' kipi'nga sa bandu ngayangwa, “Mwalimu, ninnetike mwana wangu' kasako, aina moka gagampangiya abe bubu. ");
INSERT INTO mgw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila pantangya, antu'ya pai' na kumpanga apiye matutume munkano no tauna mino, bu'kapo yi'ga yake yendang'ong'onala. Naalu'bite banamasi' bako bammi'nge moka, lakini bakombwili.” ");
INSERT INTO mgw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu ngaabakia, “Mwenga mwa lubelekwo lwangali u'bi'lya! Nilu'a tama na mwenga mpaka pakubawi? Nilu'a kunkomeya mpaka pakubawi? Munnete mwinsembe pano.” ");
INSERT INTO mgw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nabembe ngabanneta yu'lu' mwinsembe kwa Yesu. Yu'lu' moka paamweni Yesu, popopo ngannyi'ya yu'lu' mwinsembe kyundaunda, ngatu'la pai' no galabuka ku'no kapiya matutume munkano. ");
INSERT INTO mgw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ngaalaluya tati' bake mwinsembe, “Mwana wako ngu'su'mbu' yi' intumbwi pakubawi?” Ngannyangwa, “Bu'ka kuunangu'ta wake. ");
INSERT INTO mgw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aywo moka akokotyage kuntu'mbu'ki'ya mumwoto au mumasi' li'nga kunnangamisa. Lakini mana kaukombwa panga kikowe sosoti, sonde utubi'ki kiya utuyangatiye.” ");
INSERT INTO mgw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ngannyangwa panga, “Kwa mwanjaa buli ubaya panga, ‘Mana kaukombwa?’ Goti gendawesekana kwa ywembe ywau'bi'lya.” ");
INSERT INTO mgw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Popopo, aywo tati' ywa mwinsembe ngau'bu'ya lilobe kabaya, “Nendau'bi'lya! Lakini uniyangatiye kwo kotoka u'bi'lya kwangu'.” ");
INSERT INTO mgw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pakibweni kipi'nga sa bandu kakikongolekana pamope kiyu'ngu'ya, ngankalipya yu'lu' moka kammakia, “Wenga wa moka bubu na kiibamakutu, nikuamulisa ummu'ke na kaneunnyingi kai'!” ");
INSERT INTO mgw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yu'lu' moka aatikemelya, ngannyi'ya kyundaunda kwa makakala na kummu'ka. Yu'lu' mwinsembe aabile kati ntwi, kwa nyo bandu baingi ngababaya, “Ayomwike.” ");
INSERT INTO mgw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu ngankamwa luboko kunkakatuya, naywembe ngayi'ma. ");
INSERT INTO mgw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bai, Yesu paayingi nnyumba, banamasi' bake ngabannaluya pakisake, “Mwanjaa namani twenga tukombwili kummi'nga yu'lu' moka?” ");
INSERT INTO mgw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Naywembe ngaabakia, “Moka ywa kubinnya awesekanali bu'ka mpaka kwo lu'ba.” ");
INSERT INTO mgw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na banamasi' bake ngababu'ka kwo no yendelya na mwanja kwo pi'tya ku Galilaya. Yesu aapaili mundu ywoywoti atange pandu pabaabile, ");
INSERT INTO mgw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwa mwanjaa aai kaayi'gana banamasi' bake kaabakia, “Mwana wa Mundu aalu'a songelwa no kamukiyilwa kwa bandu. Nabembe baalu'a kummulaga, lakini lisu'ba lyenetatu bu'ka waa kwake alu'a yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakini banamasi' bake baatangiteli panga saakilongei saalomboli namani, nabembe ngabayogopa kunnaluya. ");
INSERT INTO mgw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bai ngabaika Kapalanaumu no bu'ka po yingya nnyumba Yesu ngaalaluya, “Mwabile kamulongelya ki'li' mundi'la?” ");
INSERT INTO mgw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakini banamasi' baayangwili, kwa mwanjaa mundi'la baabile kabataukana panga ywaku' mukipi'nga sabe ywabile nku'lu' muno kulikoni boti. ");
INSERT INTO mgw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ngatama pai' na kwakema boti ku'mi na abi'li', ngaabakia, “Mundu ywoywoti mana kapala panga nku'lu' ywa boti, apalikwa apange wa kuundi'la kuliko boti na apange ntumisi ywa boti.” ");
INSERT INTO mgw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bu'kapo ngantola mwana nsene, ngannyi'mi'ka pakatikati yabe. Ngankumbatya na kwabakia, ");
INSERT INTO mgw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mundu ywoywoti ywampokya yumo ywa aba bana asene kwa lina lyangu' anipokya nenga. Na ywaanipokya nenga anipokya nenga baili, ila ampokya ata yu'lu' ywaanitumike.” ");
INSERT INTO mgw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoani ngammakia, “Mwalimu, tumweni mundu kabi'nga moka kwa lina lyako, na twenga ngatunkanikiya kwa mwanjaa ywembe abileli pamope na twenga.” ");
INSERT INTO mgw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ngaabakia, “Kanemunkanikiye, kwa mwanjaa ntu'pu' ywoywoti ywapanga mangelongelo kwa lina lyangu', bu'kapo kalongela likowe linyatau kwangu' nenga. ");
INSERT INTO mgw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwa mwanjaa ywakotoka taukana na twenga abile kasitu. ");
INSERT INTO mgw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kakape nimmakianga, ywoywoti ywampeya mwenga ata kikombe sa masi' go nywa kwa mwanjaa mwenga mwabandu ba Kilisitu kakape mundu ywo, aakosali upo yaibu'ka kwa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ywoywoti ywampanga yumo ywa bana ba babaniu'bi'lya aponeye, yapanga male kwake atabilwe liwe liku'lu' lya lwaga paingo na kuntaikulya mubaali. ");
INSERT INTO mgw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Luboko lwako mana lukupangiye uponeye, ulukate! Yapanga male kwako yingya muukoto wangayomoka ubile na luboko lumo, kulikoni baa na maboko gabi'li' no yingya mumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pandu po, matekenya gake gawaali, wala mwoto wake uimikali. ");
INSERT INTO mgw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mana lugu'lu' lwako lukupangiye uponeye, ulukate! Yapanga male kwako yingya muukoto wangayomoka ubile na lugu'lu' lumo, kulikoni baa na magu'lu' gabi'li' no taikulilwa mumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Pandu po, matekenya gake gawaali, wala mwoto wake uimikali. ");
INSERT INTO mgw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mana liyo lyako likupangiye uponeye, uliyokwe! Yapanga male kwako yingya muukulungwa wa Nnu'ngu' ubile na liyo limo kulikoni baa na minyo gabi'li' no taikulilwa mumwoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pandu po matekenya gake gawaali wala mwoto wake uimikali. ");
INSERT INTO mgw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kwa mwanjaa kila mundu aatakilwa kwa mwoto. ");
INSERT INTO mgw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mwinyo unogite, lakini mana uobiye kilyi'lyi' sake, mwayi'ya namani li'nga uki'li'bu'ye kilyi'lyi' kai'? Mubee na mwinyo nkati yinu na mutame pamope kwa amani kila mundu na nnyine.” ");
INSERT INTO mgw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ngabu'ka ku'lu' yenda kunkoa wa Yudea no loka liyi' lya Yordani. Na ipi'nga yambone ya bandu yaatikongolekana kai' nnu'ngi' yake, naywembe ngatumbwa kwayi'gana kati mwayobelile. ");
INSERT INTO mgw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bi'ngi' ba Mafalisayo ngabaisa li'nga kumpaya kwa kunnaluya, “Buli, yendayi'ki'ti'lwa nnalu'me kupeya talaka nnyumbowe?” ");
INSERT INTO mgw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu ngaayangwa, “Musa aamwamulise namani?” ");
INSERT INTO mgw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngabayangwa, “Musa aayi'ki'tiye panga nnalu'me endakombwa kumwandikya nnyumbowe talaka na kummu'ya.” ");
INSERT INTO mgw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ngaabakia, “Musa aamwandiki salya yo kwa kitumbu so nonopa kwinu kwa myoyo. ");
INSERT INTO mgw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lakini tangu' nsimu wa Nnu'ngu' paumbike dunia, aaumbike nnalu'me na nnwawa. ");
INSERT INTO mgw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kwa kitumbu si', nnalu'me aalu'a kwaleka tati' bake na mau' bake no lu'mbana na nnyumbowe, ");
INSERT INTO mgw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na abo abi'li' baapanga yi'ga yimo. Kwa nyo, baapangali abi'li' kai', ila yi'ga yimo. ");
INSERT INTO mgw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bai, saakilu'mbaniye Nnu'ngu', mundu kaneakilekanganiye.” ");
INSERT INTO mgw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pabaabile nnyumba kai', banamasi' bake ngabannaluya abali ya likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngaayangwa, “Mundu ywoywoti ywanneka nnyumbowe no kobeka nnwawa ywi'ngi' apanga ugoni. ");
INSERT INTO mgw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nyinyonyo na nnwawa ywanneka nsengowe no ku'nda kwa nnalu'me ywi'ngi', apanga ugoni.” ");
INSERT INTO mgw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bandu baabile kabannetya Yesu bana anangu'ta li'nga aakunywe, lakini banamasi' bake ngabaakalipya. ");
INSERT INTO mgw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lakini Yesu paabweni nyo, aatiusika muno, ngaabakia, “Mwayi'ki'ti'ye bana anangu'ta baisange kasangu', kanemwakanikiye, kwa mwanjaa bana kati ba Ukulungwa wa Nnu'ngu' nga wabe. ");
INSERT INTO mgw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kakape nimmakianga, mundu ywoywoti ywakotoka kuuyi'ki'tya Ukulungwa wa Nnu'ngu' kati mwana nnangu'ta, katu auyingyali ukulungwa wo.” ");
INSERT INTO mgw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bu'kapo ngaakumbatya bana balu', no bi'ka maboko panani yabe li'nga kwayalya. ");
INSERT INTO mgw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu paabile kabu'ka, mundu yumo aatikummutukya, ngakilikita nnu'ngi' yake ngannaluya, “Mwalimu nnogau, nipange buli li'nga niulisi ukoto wangayomoka?” ");
INSERT INTO mgw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ngammakia, “Mbona unikema nannogau? Ntu'pu' ywoywoti ywabile nnogau ila Nnu'ngu' kisake. ");
INSERT INTO mgw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Witangite amuli, ‘Kaneubulage, kaneupange upege, kaneupange ugoni, kaneuyibe, kaneukong'ondeli ubu'su', kaneuku'pi'ye, waisimu tati' na mau' bako.’” ");
INSERT INTO mgw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ngayangwa, “Mwalimu, amuli yoti yi' niikamwile bu'ka kuunangu'ta wangu'.” ");
INSERT INTO mgw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu nganningulya kwa kumpenda, ngammakia, “Upu'ngu'kilwe na kili'be simo. Uyende, ukapi'mi'ye kila kili'be saubile naso na mbanje ye ukaapei aki'ba, nawenga waapanga na amana kunani. Bu'kapo, uniki'ngame.” ");
INSERT INTO mgw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aywo mundu payu'wine nyo, ngaku'ku'li'ka muno, Ngabu'ka kanyopa kwa mwanjaa aabile na mali yambone. ");
INSERT INTO mgw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ngalingulya lwingo lwoti na kwabakia banamasi' bake, “Mulinguli mwainonwipe kwa bababile na mali, yingya mu Ukulungwa wa Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Banamasi' baatisangala kwa mayi'gi'yo go. Lakini Yesu ngaabakia kai', “Mwabana bangu', kunonwipe muno yingya mu Ukulungwa wa Nnu'ngu'! ");
INSERT INTO mgw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Male kwa mbu'nda pi'ta mulipoyo lya singano kulikoni mundu tayili yingya mu Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Banamasi' bake ngabasangala muno, ngabalaluyana bene na bene, “Kwa nyo nyai lelo ywawesa kosopolelwa?” ");
INSERT INTO mgw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ngaalingulya na kwabakia, “Likowe li' kwa mundu liwesekanali, lakini kwa Nnu'ngu' makowe goti gendawesekana.” ");
INSERT INTO mgw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Apo Petili ngammakia, “Linga, na twenga tukilei kila kili'be kukuki'ngama wenga!” ");
INSERT INTO mgw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Apo Yesu ngaabakia, “Kakape nimmakianga, mundu ywaileka nyumba yake, mwasawe, nnu'mbu'we, mau', tati', bana au migunda kwa kitumbu sangu' na kwa abali inannoga, ");
INSERT INTO mgw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aali'pi'lwa mala mya kwa nsimu wa nambi'yambi'. Aapokya nyumba na alongo, mau' na tati', bana na migunda pamope na ngu'su'mbu'. Na nsimu wawaaisa aalu'a pokya ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakini baingi bababile alongoi baalu'a ba kuundi'la, na ba kuundi'la baalu'a ba alongoi.” ");
INSERT INTO mgw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pabaabile mundi'la kabayenda Yelusalemu Yesu aatilongolya. Banamasi' bake baatisangala muno, na bandu babaabile kabaaki'ngama ngabayogopa. Yesu ngaatola kai' banamasi' bake ku'mi na abi'li' pambwega na kwabakia gagaalu'a kumpitya. ");
INSERT INTO mgw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ngabaya, “Twendau'bu'ka yenda Yelusalemu, na Mwana wa Mundu aalu'a kamukiyilwa kwa api'ndo ba dini na balimu ba salya. Bembe baalu'a kumuukumu kiwo na kunkamukiya kwa bandu bangali Ayahudi, ");
INSERT INTO mgw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","abo baalu'a kunsalanga na kummunia mmata, baalu'a kunku'mbwa na kummulaga. Bu'kapo lisu'ba lyenetatu, aalu'a yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobi na Yoani, bana ba Zebedayo, baannyendeli Yesu na kummakia, “Mwalimu, tupala utupangi sosoti satwakulu'ba.” ");
INSERT INTO mgw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ngaalaluya, “Mupala nimpangyange ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngabammakia, “Utuyi'ki'ti'ye tama yumo kummalyo na ywi'ngi' kunki'ya muutukupu wako.” ");
INSERT INTO mgw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Lakini Yesu ngaabakia, “Mwenga mutangiteli samukilu'ba. Buli, mwendakombwa nywelya nnobo wa ngu'su'mbu' wanaalu'a nywelya nenga, au batisilwa ubatiso wa kiwo wanaalu'a batisilwa nenga?” ");
INSERT INTO mgw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngabannyangwa, “Twendakombwa.” Yesu ngaabakia, “Nnobo waninywelya mwaunywelya na ubatiso wanibatisilwa mwaabatisilwa, ");
INSERT INTO mgw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","lakini tama lwingo lwa mmalyo au lwa nki'ya alyo lyengo lyangu' nengali kumpeyanga. Lipala li'no Nnu'ngu' alu'a kwapeya balu' bababi'kilwe wisowiso.” ");
INSERT INTO mgw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Balu' banamasi' bi'ngi' ku'mi pabayu'wine go, ngabatumbwa kwausikya Yakobi na Yoani. ");
INSERT INTO mgw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kwa nyo Yesu ngaakema banamasi' bake pamope na kwabakia, “Mutangite panga, ayi'mi'li'ki ba bandu bangali Ayahudi batawala bandu babe kwa ukali', na api'ndo babe baatumya kinyatau. ");
INSERT INTO mgw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini kwinu mwenga kaneibe nyo. Ila ywoywoti ywapala panga nku'lu' mukipi'nga sinu aapalikwa ba ntumisi winu, ");
INSERT INTO mgw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na ywoywoti ywapala panga nnongoi apalikwa ba mmanda ywa boti. ");
INSERT INTO mgw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwa mwanjaa Mwana wa Mundu aaisili li'nga tumikilwa, ila tumikia na kuupiya bwu'mi wake ube mali'po ga kwakombwa bandu baingi li'nga bakosopolelwe.” ");
INSERT INTO mgw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bu'kapo ngabaika Yeliko. Yesu paabile kabu'ka pakilambo so na banamasi' bake pamope na kipi'nga kiku'lu' sa bandu, mbulibuli yumo lina lyake Batimayo, mwana wa Timayo, aabile atami mbwega ya ndi'la kalu'ba yangatiyilwa. ");
INSERT INTO mgw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Paayu'wine panga Yesu ywa ku Nasaleti aabile kapi'ta, ngatumbwa u'bu'ya lilobe kabaya, “Yesu, Mwana wa Daudi, unibi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bandu baingi ngabankalipya kwa kummakia atame liki, lakini ywembe ngau'bu'ya lilobe kai' kwa makakala kabaya, “Yesu, Mwana wa Daudi, unibi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu ngayi'ma no baya, “Munkeme aise pano.” Bai ngabankema yu'lu' mbulibuli, ngabammakia, “Ube na mwoyo nku'lu'! Ukatuke, endakukema.” ");
INSERT INTO mgw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ngataikwa nganju yake no yi'ma kiyu'ngu'ya, na kunnyendelya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ngannaluya, “Upala nikupangi ki'li'?” Yu'lu' mbulibuli ngayangwa, “Mwalimu, mbala lola.” ");
INSERT INTO mgw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ngammakia, “Uyende, imani yako ikutepwile.” Popopo aakombwi lola, ngaanki'ngama Yesu kundi'la. ");
INSERT INTO mgw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na banamasi' bake pabaabile kabaegelya ku Yelusalemu lwingo lwa kilambo sa Bethfage na Betania, papipi na Kitu'mbi' sa Minjaituni, Yesu aatumike banamasi' bake abi'li', ");
INSERT INTO mgw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ngaabakia, “Muyende pakilambo sakibile nnu'ngi' yinu. Pamutumbwa yingya bai, mukammona mwana mbu'nda atabilwe, na anakolelelwali na mundu. Mukamundwe, munnete pano. ");
INSERT INTO mgw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Manaitei mundu ywoywoti kannaluya panga, ‘Mboni mupanga nnya?’ Mummakie panga, ‘Bwana endakumpala na aasi'yali kunki'li'bu'ya.’” ");
INSERT INTO mgw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bai, pabayi'i ngabammona mwana mbu'nda, ywatabilwe mbwega ya simbasimba panja ya nniango, ngabamundwa. ");
INSERT INTO mgw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pabaabile kabamundwa, bandu babaayi'mi papipi nabo baatikwalaluya, “Mupanga namani? Mwanjaa namani mumundwa mwana mbu'nda yu'?” ");
INSERT INTO mgw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Banamasi' ngabayangwa kati mu'lu' mwabaabakiyilwe na Yesu, nabembe ngabaaleka bayende. ");
INSERT INTO mgw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bu'kapo, ngabampelekya Yesu yu'lu' mwana mbu'nda no tandika magu'bo gabe panani yake li'nga Yesu atame. ");
INSERT INTO mgw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bandu baingi baatandike magu'bo gabe mundi'la, na bi'ngi' baatandike ndambi' ya mikongo yabakatike mumigunda yabe. ");
INSERT INTO mgw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bandu boti babaalongoli nnu'ngi' ya Yesu na babaabile nsu'gu' yake baau'bwiye malobe gabe kababaya, “Nnu'ngu' alumbilwe! Ayaliwite ywembe ywaisa kwa lina lya Bwana! ");
INSERT INTO mgw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uyaliwite ukulungwa wawisa wa au'ku' bitu Daudi! Nnu'ngu' wa kunani alumbilwe!” ");
INSERT INTO mgw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu aayingi pakilambo sa Yelusalemu, aayi'i ntawalia mpaka munyumba ya Nnu'ngu' na kukilinga wisowiso kila kili'be. Lakini kwa mwanjaa yaai kitamwiyo, ngayenda Betania pamope na balu' ku'mi na abi'li'. ");
INSERT INTO mgw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pammalau' yake pabaabile kabauma Betania, Yesu yamminyike njala. ");
INSERT INTO mgw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bai, ngaubona nkongo wa ntini wene maakapi maingi kwa kuutalu. Ngauegelya li'nga aulinge, pi'ngi' kunani yake awesa pata litunda. Lakini paikite papipi nawo, aakibwenili kili'be ila maakapi sika, kwa mwanjaa nsimu wo waai wo pambikali. ");
INSERT INTO mgw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kwa nyo, Yesu ngaukosya lasi nkongo wu'lu' kaubakia, “Tumbulya nambi'yambi' ata milele, mundu kanealye litunda kai' bu'ka kunani yako.” Paabile kalongela go, banamasi' bake bai kabayu'wa. ");
INSERT INTO mgw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bu'kapo, ngabaika ku Yelusalemu. Yesu paayingi muluwa lwa nyumba ya Nnu'ngu', ngatumbwa kwabi'nganga bandu babasulusage na babapi'mage ili'be muluwa lwo. Aapi'li'ngwi mamesa ga balu' babati'kwanage mbanje na iti'gu' ya asulusi ba ngunda. ");
INSERT INTO mgw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kai', annyi'ki'tiyeli mundu ywoywoti pi'ta apu'twile kigombo so sulusa paluwa lwa nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bu'kapo ngaayi'gana mayi'gi'yo gano, “Iandikilweli mu Mayi'gi'yo Mapeleteu panga, ‘Nyumba ya Nnu'ngu' yaakemelwa nyumba yo salilya kwa bandu ba mataipwa goti?’ Lakini mwenga mwiyu'yite mbango ya apokonyoli!” ");
INSERT INTO mgw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Api'ndo ba dini na balimu ba salya pabayu'wine go, baatumbwi pala ndi'la ya kummulaga, lakini bannyogopage kwa mwanjaa kipi'nga soti sa bandu kisangalage mu'lu' mwaayi'ganage. ");
INSERT INTO mgw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Payikite kitamwiyo, Yesu na banamasi' bake ngababu'ka pakilambo si'lu'. ");
INSERT INTO mgw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pammalau' yake kindai' pabaabile kabapi'ta, baaubweni wu'lu' nkongo wa ntini uyu'mite woti ata ngi'ga yake. ");
INSERT INTO mgw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petili aaku'mbu'ki makowe gagaalongolile na ngammakia Yesu, “Mwalimu, uulinge wu'lu' nkongo wa ntini wawaaukosi lasi, uyu'mi.” ");
INSERT INTO mgw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ngaabakia banamasi' bake, “Mupalikwa mumwu'bi'li Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kakape nimmakianga, mundu ywoywoti mana alongei kwo u'bi'lya na pangali kyukala pamwoyo wake, kakibakia kitu'mbi' si' kiyokoke pakibile kikatu'le mubaali, kakape ilu'a pangika. ");
INSERT INTO mgw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwa nyo nendakummakia, gogoti gamugalu'ba kamusali, muu'bi'li panga mwendagapokya, ago gaalu'a panga ginu. ");
INSERT INTO mgw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na pamuyi'ma salya, mana mubile na mayu'mano na mundu ywi'ngi', munsami, li'nga Tati' binu bababile kunani bansami mwenga makosa ginu nyinyonyo.” ");
INSERT INTO mgw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lakini mwenga mana mukani kwasamya bi'ngi' makosa gabe, Tati' binu ba kunani bansamyali mwenga makosa ginu nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bai, Yesu na banamasi' bake ngabaika kai' Yelusalemu. Yesu paabile katyanga muluwa lwa nyumba ya Nnu'ngu', api'ndo ba dini, balimu ba salya na ayi'mi'li'ki ba bandu baatikunnyendelya. ");
INSERT INTO mgw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngabannaluya, “Upanga makowe ga kwa utawala gani? Na nyai ywakupei utawala wu'?” ");
INSERT INTO mgw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ngaabakia, “Nilu'a kunnaluya liswali limo, mana muniyangwile, nenga nilu'a kummakia kwa utawala gani nipanga makowe ga. ");
INSERT INTO mgw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoani Ywabatisage aapatike utawala wo batisa bu'ka kwa nyai? Kwa Nnu'ngu' au kwa bandu? Muniyangwe.” ");
INSERT INTO mgw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nabembe ngabatumbwa laluyana bene na bene kababaya, “Mana tuyangwi panga utawala wake waabu'i kwa Nnu'ngu', aatulaluya, ‘Kwa kitumbu saku' mukotwike kumwu'bi'lya?’ ");
INSERT INTO mgw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kai', tuwesali baya waaumi kwa bandu.” (Baayogwipe kipi'nga sa bandu, kwa mwanjaa boti baau'bi'lile panga Yoani kakape aai nnondoli ywa Nnu'ngu'.) ");
INSERT INTO mgw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bai, ngabannyangwa Yesu, “Tutangiteli.” Nembe ngaabakia, “Nanenga nimmakiangali panga nipanga ga kwa utawala waku'.” ");
INSERT INTO mgw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bu'kapo, Yesu aatumbwi longela makowe ga kwa balu' api'ndo kwo tumya ngongo, “Mundu yumo aapandike minjabibu munng'unda wake na auti'li'ti'kiye lubi'go. Pakati yake aatengenise pandu po komangya minjabibu li'nga ipiye divai, na aasengite kisewe. Bu'kapo, ngaakolisa nng'unda wo kwa ali'mi no yabwa mwanja wa kunni'ma wi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Masu'ba go una pagatimile, ngantuma mpangakasi wake yumo kwa balu' ali'mi li'nga bampei iku'ta ya mauno gake. ");
INSERT INTO mgw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lakini balu' ali'mi ngabammoywa mpangakasi yu'lu', kunku'mbwa na kunki'li'bu'ya pangali kumpeya kikowe sosoti. ");
INSERT INTO mgw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yu'lu' mwene nng'unda ngantuma kai' mpangakasi ywi'ngi'. Yu'lu' nembe ngabanku'mbwa, ngabannumiya muntwe na kumpangya makowe malau muno. ");
INSERT INTO mgw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwene nng'unda antumike kai' mpangakasi ywi'ngi', balu' ali'mi ngabammulaga. Bu'kapo ngaatuma bi'ngi' baingi, lakini balu' ali'mi baatikwalumiya na bi'ngi' kwabulaga. ");
INSERT INTO mgw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwene nng'unda aaigali na mundu yumo bai, naywembe aai mwana wake ywampendile. Kuundi'la ngantuma kwa balu' ali'mi kabaya, ‘Nitangite panga balu'a kumwisimu mwana wangu'.’ ");
INSERT INTO mgw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini balu' ali'mi pabamweni kaisa, ngababakiyana, ‘Ayu' nga ywalu'a lisi nng'unda wu'. Bai, tummulage na nng'unda wu' upange witu.’ ");
INSERT INTO mgw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bai, ngabammoywa yu'lu' mwana na kummulaga, ntwi wake bautaikuli panja ya nng'unda wa minjabibu.” ");
INSERT INTO mgw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bu'kapo Yesu ngaalaluya, “Bai, yu'lu' mwene nng'unda wa minjabibu alu'a panga buli? Ywembe alu'a isa na kwabulaga balu' ali'mi. Bu'kapo, alu'a kwakolisa nng'unda wu'lu' ali'mi bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Buli, munasomali Maandiko Mapeleteu gagabaya, ‘Liwe lyabalikani asengi, nambi'yambi' lipangike liwe liku'lu' lya pakitumembe. ");
INSERT INTO mgw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Likowe li' libu'i kwa Bwana, nalyembe lya ayabu muno kasitu.’” ");
INSERT INTO mgw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bai, abo api'ndo baapalike ndi'la ya kummoywa Yesu, kwa mwanjaa baatangite panga ngongo yo aalongelyage bembe. Lakini kwa kitumbu sa kukiyogopa kipi'nga sa bandu, ngabakotoka no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bai, bi'ngi' ba Mafalisayo na bandu ba kipi'nga sa Helode baatumilwe bampi'ndi'ke Yesu kwo pi'tya milongelo yake. ");
INSERT INTO mgw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baatikunyendelya na kunnaluya, “Mwalimu, tutangite panga wenga wa mundu wa ukakape. Kai', unnyogopali mundu kwa mwanjaa, uyi'me wa mundu kili'be lili kasako, lakini uyi'gana ndi'la ya Nnu'ngu' kwa ukakape. Tubakiye, panga salya ya Musa yendatuyi'ki'ti'ya li'pa koli kwa Kaisali, nkulungwa wa Roma, au lili? Tupalikwa tuli'pe au lili?” ");
INSERT INTO mgw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini kwa mwanjaa aatangite panga bandu balu' anapiki, ngaabakia, “Mwanjaa namani munipi'ndi'ka? Munileti lwela lumo pano li'nga nilulinge.” ");
INSERT INTO mgw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngabannetya lu'lu' lwela. Nembe ngaalaluya, “Kuminyo ku' na lina li' lyaliandikilwe, lya nyai?” Ngabannyangwa, “Kaisali.” ");
INSERT INTO mgw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bai, Yesu ngaabakia, “Ga Kaisali mumpei Kaisali na ga Nnu'ngu' mumpei Nnu'ngu'.” Boti baatisangala muno. ");
INSERT INTO mgw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bu'kapo, Masadukayo, balu' babakana u'bi'lya panga kubile na lisu'ba lyo yu'yi'lwa kwa awi'li, ngabamwisilya Yesu na kunnaluya, ");
INSERT INTO mgw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mwalimu, Musa aatuandiki panga mundu ywakobike mana awile pangali papa mwana, ipalikwa nnongowe ankobeke aywo nnwawa nng'wi'li'kwa li'nga ampapi nnongowe bana. ");
INSERT INTO mgw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bai, kwabile na alongo saba, aywo mmele aakobike nnwawa lakini yu'lu' nnalu'me awile pangali papa mwana. ");
INSERT INTO mgw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ywenebi'li' ngankobeka yu'lu' nnwawa, nembe ngawaa kai' pangali papa mwana. Ngaipanga nyinyo kai' kwa nnongo ywenetatu. ");
INSERT INTO mgw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na boti saba bankobike nnwawa yu'lu' bu'ka po waa ywi'ngi', lakini baawile pangali papa bana. Kuundi'la, yu'lu' nnwawa nembe ngawaa. ");
INSERT INTO mgw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bai, lisu'ba lyo yu'yi'lwa babawile, ywembe aapanga nnyumbo wa nyai, kwa mwanjaa aakobekilwe na balu' alongo boti saba?” ");
INSERT INTO mgw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu aatikwayangwa, “Mwobite kwa kitumbu so kotoka tanga mwagaandikilwe Mayi'gi'yo Mapeleteu na makakala ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwa mwanjaa awi'li pabaalu'a yu'ka baakobekali wala baaku'ndali, kati mwababile malaika ba kunani. ");
INSERT INTO mgw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","No bu'kana na uyu'ki wa babawile, munasomali mukitabu sa salya ya Musa galu' maandiko gagalongelya bu'kana na si'lu' kiwi'mbi' sasaayakite mwoto? Nnu'ngu' ammakie Musa, ‘Nenga na Nnu'ngu' wa Bulaimu, Nnu'ngu' wa Isaki, na Nnu'ngu' wa Yakobi.’ ");
INSERT INTO mgw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ywembe Nnu'ngu' ywa bandu babawile lili, ywembe Nnu'ngu' wa bandu akoto. Mwenga mutioba muno.” ");
INSERT INTO mgw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Palu' Yesu pataukanage na Masadukayo, kwabile na mwalimu yumo ywa salya ya Musa, ywembe aatangite panga Yesu aayangwi wiso. Bai, aatikumwegelya na kunnaluya, “Amuli yaku' yaibile ngu'lu' pi'ta yoti?” ");
INSERT INTO mgw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu aatiyangwa, “Amuli ngu'lu' nga yi'no, ‘Upi'kani wenga wa Isilaili, Bwana Nnu'ngu' witu nga Bwana yumo bai. ");
INSERT INTO mgw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umpende Bwana Nnu'ngu' wako kwa mwoyo wako woti, kwa loo yako yoti, kwa malango gako goti na kwa makakala gako goti.’ ");
INSERT INTO mgw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na amuli yenebi'li' nga yi'no, ‘Umpende ywa papipi yako kati mwawipenda wamwene.’ Ntu'pu' amuli yi'ngi' ngu'lu' kulikoni yi'no ibi'li'.” ");
INSERT INTO mgw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yu'lu' mwalimu ywa salya ya Musa ngammakia Yesu, “Ulongei wiso Mwalimu, panga Nnu'ngu' yumo kisake, wala ntu'pu' Nnu'ngu' ywi'ngi' ila ywembe. ");
INSERT INTO mgw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na mundu apalikwa kumpenda Nnu'ngu' kwa mwoyo wake woti, kwa malango gake goti na kwa makakala gake goti. Nembe apalikwa kumpenda ywa papipi kati mu'lu' mwaipenda mwene. Makowe go gangama muno kulikoni salaka ya nyama yo langamisa pamwoto, na salaka yi'ngi' yoti.” ");
INSERT INTO mgw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nembe Yesu pamweni aywo mundu ayangwi kwa malango, ngammakia, “Wenga ubileli kuutalu no yingya muukulungwa wa Nnu'ngu'.” Payomwi longela go, ntu'pu' mundu ywalowite kunnaluya kai' Yesu likowe lyolyoti. ");
INSERT INTO mgw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu paabile kayi'gana muluwa lwa nyumba ya Nnu'ngu', aatilaluya, “Mboni balimu ba salya ya Musa babaya panga Kilisitu mwana wa Daudi?” ");
INSERT INTO mgw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwene kalongoyelwa na Loo Mpeleteu aatibaya, ‘Bwana Nnu'ngu' ammakie bwana wangu', Utame kummalyo gangu', mpaka panaalu'a kwabi'ka andumu bako pai' ya magu'lu' gako.’ ");
INSERT INTO mgw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi mwene ankema Kilisitu ‘Bwana.’ Kwa nyo, Kilisitu apangali mwana wake bai, ila Bwana wake kai'.” Si'lu' kipi'nga sa bandu saai kakimpi'kania kwo napusika. ");
INSERT INTO mgw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mumayi'gano gake aatikwabakia, “Mwili'ndi'le bu'kana na balimu ba salya ya Musa, bembe bapenda tyanga bawati makanju malaso, no penda pangilwa abali na bandu kwa isima mumasoko. ");
INSERT INTO mgw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kai', bembe bapendi tama muiti'gu' ya nnu'ngi' mumayumba ga kunnu'ba Nnu'ngu' no penda isimilwa muiyambo. ");
INSERT INTO mgw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bapokonywa mali ya alwawa awi'li'ka no salya sala ndaso li'nga bayu'wanike na bandu. Kwa kitumbu si', balu'a ukumilwa munomuno.” ");
INSERT INTO mgw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu aatami papipi na lisanduku lya amana ya nyumba ya Nnu'ngu', kaalingulya bandu mwabayi'ya mbanje nkati ya lisanduku li'lu'. Matayili baingi baayi'i mbanje yambone nkati ya lisanduku. ");
INSERT INTO mgw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aaisi nnwawa yumo nng'wi'li'kwa nki'ba, ngapiya ela ibi'li' bai. ");
INSERT INTO mgw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bai, Yesu aakemite banamasi' bake na kwabakia, “Kakape nimmakianga, ayu' nnwawa nng'wi'li'kwa nki'ba, apiyite mbanje yambone muno kulikoni boti babaayi'ile nkati ya lisanduku lya salaka. ");
INSERT INTO mgw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwa mwanjaa bi'ngi' baabawi bu'ka mumbanje yababile nayo, lakini ywembe kwa uki'ba wabile nawo, aapiyite ili'be yoti yabile nayo mumaisa gake.” ");
INSERT INTO mgw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu paabile kapita bu'ka muluwa lwa nyumba ya Nnu'ngu', yumo ywa banamasi' bake ngammakia, “Mwalimu, lingulya maliwe ga mwagagolwike na mayumba ga maku'lu'!” ");
INSERT INTO mgw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu aatiyangwa, “Mwendagabona mayumba ga maku'lu'? Lyaigalali ata liwe limo panani ya liwe li'ngi', goti gabomwanilwa.” ");
INSERT INTO mgw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu paabile atami pa Kitu'mbi' sa Minjaituni kalingulya ku nyumba ya Nnu'ngu', Petili, Yakobi, Yoani na Andelea ngabannaluya pakiyi'ki'ya, ");
INSERT INTO mgw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tulu'ba utubakiye makowe ga gaugabaite gaapangika pakubawi? Na ki'li' gani sasalu'a kutulaya twenga tutange panga makowe go gapalapitya?” ");
INSERT INTO mgw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ngaabakia, “Mulinguli wiso, mwakane kongelwa na mundu. ");
INSERT INTO mgw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bandu baingi baaisa kwa lina lyangu' kababaya panga, ‘Nenga ngana Kilisitu’, na abo baalu'a kwakonga baingi. ");
INSERT INTO mgw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pamwayu'wa makowe ga ngondo na mayu'yu'to gake kanemwayogope. Makowe go gapalikwa gapiti wi'ti', lakini kuundi'la yene kunaikali. ");
INSERT INTO mgw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kwa mwanjaa nni'ma waayu'mana na nni'ma wi'ngi', na ukulungwa waayu'mana na ukulungwa wi'ngi'. Kwalu'a ba na nnendemo wa nni'ma mumatapo mbali'mbali', kai' kwalu'a ba na njala ngu'lu'. Na aga goti gaalu'a panga kati mwalupanga lwu'ngu' lwo papa mwana.” ");
INSERT INTO mgw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Lakini mwenga mwilinge, kwa mwanjaa bandu baalu'a kumpeleka kumankama na kunku'mbwa mumayumba ga kunnu'ba Nnu'ngu'. Mwapelekelwa kwa atawala na akulungwa kwa kitumbu sangu' li'nga munikong'ondeli kwabe. ");
INSERT INTO mgw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ipalikwa abali inannoga ialilwe wi'ti' kwa bandu ba kila nni'ma. ");
INSERT INTO mgw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na pamwalu'a boyolelwa no sitakilwa, kanemwaauke kwo wasa galu' gamwalu'a yangwa, mwenga mwalongele likowe lyolyoti lyamwapeyelwa papalu'palu'. Kwa mwanjaa mwalongelali mwenga, ila aalongela Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nnongo aansongya nnongowe li'nga abulagilwe, na tati' kunsongya mwana wake, nabembe bana baalu'a kwagalambukya abelei babe li'nga babulagilwe. ");
INSERT INTO mgw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na bandu boti baalu'a kunsukwa kwa kitumbu sa lina lyangu', lakini ywaalu'a komeya mpaka kuundi'la aalu'a kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Lakini pamwakibona kili'be sakisukwa Nnu'ngu' na sakileta usapu kiyi'mi'kilwe pandu papeleteu (ywasoma atange), apo babaalu'a ba ku Yudea baabutuki muitu'mbi'. ");
INSERT INTO mgw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ywabile panani ya mwagala wa nyumba, kaneauluke yingya nnyumba yendatola kili'be. ");
INSERT INTO mgw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ywabile kunng'unda kaneagalambuke tola likoti lyake, ila apalikwa atile. ");
INSERT INTO mgw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bakibona alwawa atopelwe na babayongeya bana masu'ba go! ");
INSERT INTO mgw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Munnu'be Nnu'ngu' li'nga makowe go gaakane pitya nsimu wa kyuku. ");
INSERT INTO mgw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwa mwanjaa masu'ba go gaapanga ga siki ngu'lu', siki kati yo inapityali apo nsu'gu' tangu' Nnu'ngu' paumbite dunia mpaka li'no, na yapityali kai' katu. ");
INSERT INTO mgw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ikapangage Bwana akotwike pu'ngu'ya masu'ba go, ntu'pu' ata mundu yumo ywapele kosopolelwa. Lakini kwa kitumbu sa balu' babasaulilwe na Nnu'ngu', masu'ba go gapu'ngu'yilwe. ");
INSERT INTO mgw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nsimu wo manaitei mundu kammakia, ‘Lingulya, Kilisitu abile pano’ au ‘Abile palu'’, kanemwau'bi'li. ");
INSERT INTO mgw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwa mwanjaa baapitya ‘Kikilisitu’ ba ubu'su' pamope na alondoli ba ubu'su', nabembe baalaya myanju na mangelongelo li'nga baakonge bandu, kai' mana iwesekine ata balu' babasaulilwe na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lakini mwenga mwili'ndi'le, nenga nimmakie makowe goti gabile balo ganapityali. ");
INSERT INTO mgw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bu'ka pa siki ya masu'ba galu', lisu'ba lyabaa mulubi'ndu' na mwei wapiyali bweya wake. ");
INSERT INTO mgw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondwa yalu'a tu'mbu'ka bu'ka kumaunde, makakala go goti ga kunani gaalu'a kunyangunya. ");
INSERT INTO mgw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Apo nga pabammona Mwana wa Mundu kaisa bu'ka kumaunde kwa makakala maku'lu' na utukupu. ");
INSERT INTO mgw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nembe aatuma malaika bake li'nga baakongwe baasawile bu'ka mumbande yoti nsese ya dunia, bu'ka kila pandu pa dunia, mpaka kuundi'la ya kunani. ");
INSERT INTO mgw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kwa nkongo wa ntini mwiyi'gane lukongo lu'no, palu' ndambi' yake paitumbwa ipuka no piya maakapi, mutangite panga nsimu wo li'ma wendaegelya. ");
INSERT INTO mgw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Namwenga nyinyonyo, pamugabona makowe go kagatumbwa pangika, mutange panga Mwana wa Mundu abile papipi na niango. ");
INSERT INTO mgw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kakape nimmakianga, lubelekwo lu'no lwaalu'a pi'tali pangali pitya makowe ago goti. ");
INSERT INTO mgw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunani na padunia kwalu'a pi'ta lakini mayi'gi'yo gangu' katu gaapi'tali. ");
INSERT INTO mgw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lakini bu'kana na lisu'ba au saa yi'lu', ntu'pu' mundu ywatangite ata malaika ba kunani wala Mwana, ila Tati' kisabe bai. ");
INSERT INTO mgw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwili'ndi'le, mukeleke, kwa mwanjaa mutangiteli nsimu wo pawatimya. ");
INSERT INTO mgw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yalu'a panga kati mundu ywayabwa mwanja na kwalekya apangakasi bake bayi'mi'like, kila mundu na lyengo lyake, na kummakia nni'ndi'li wa nniango abe minyo. ");
INSERT INTO mgw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mukeleke, kwa mwanjaa mutangiteli mwene nyumba alu'a buya pakubawi, pi'ngi' iwesa panga kitamwiyo, meku, bulabula au kindai'. ");
INSERT INTO mgw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mwili'ndi'le, mana aaisa kwa kimuimu aakane kunkolya mugonjike lugono. ");
INSERT INTO mgw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Makowe ganimmakia mwenga, nabakia boti. Mwili'ndi'le!” ");
INSERT INTO mgw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gaaigali masu'ba gabi'li' bai ika kusi'li'ku'si'li'ku' ya Pasika na ya Makati Gangalu'la, api'ndo ba dini na balimu ba salya ya Musa bapalage ndi'la ya kummoywa Yesu kwa kinunu na kummulaga. ");
INSERT INTO mgw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kwa mwanjaa baabaite, “Kanetupange likowe li' pa si'li'ku'si'li'ku', bandu baakane panga puyo.” ");
INSERT INTO mgw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu aabile Betania munyumba ya Simoni ywaabile na matana patumbu. Pabaabile kabalya, nnwawa yumo aayingi nnyumba. Abile na supa ya liwe yaibile na mauta ganannungya gene bei ngu'lu'. Bu'kapo ngati'kwana nkano wa yi'lu' supa no u'lu'ki'ya mauta go panani ya ntwe wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bi'ngi' ba bandu babaabile palu' baatiusika muno kwa galu' gaagapangite yu'lu' nnwawa no bakiyana, “Kwa mwanjaa namani nyamana mali kati yi'? ");
INSERT INTO mgw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mauta ga galu'e pi'mi'yi'lwa kwa ela yambone yo kombwa kwapeya masikini.” Ngabammendya aywo nnwawa kwa nyongo. ");
INSERT INTO mgw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lakini Yesu ngaabakia, “Mboni mwendakumwauya ayu' nnwawa? Munneke! Ywembe anipangi likowe linannoga muno. ");
INSERT INTO mgw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kwa mwanjaa masikini mwalu'a baa pamope nabo masu'ba goti, kila pamupala kwapeya mwendakwapeya, lakini nenga nalu'a baali pamope na mwenga masu'ba goti. ");
INSERT INTO mgw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ayu' nnwawa anipangi li'lu' lyaliwesite, aniu'lu'kiye mauta ganannungya li'nga kunibi'ka wiso kwo sikilwa kwangu'. ");
INSERT INTO mgw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kakape nimmakianga, kwa ngu'mbu'ku'mbu' ya nnwawa yu', likowe lyalipangite lyabayilwa kila pandu paialilwa abali inannoga mudunia yoti.” ");
INSERT INTO mgw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Isikalioti, yumo ywa balu' banamasi' ku'mi na abi'li', aayi'i kwa api'ndo ba dini li'nga kunsongya Yesu kwabe. ");
INSERT INTO mgw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pabapatike abali yi'lu' baatipulaika muno, nabembe ngabayi'ki'tyana nakwe kumpeya mbanje. Bu'kapo, Yuda ngatumbwa pala lipala linannoga lya kunsongya Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lisu'ba lyo yingilya kalamu ya si'li'ku'si'li'ku' ya Makati Gangalu'la, napo nga pabasinjike mwana ngondolo wa Pasika, banamasi' ba Yesu baatikunnaluya, “Upala tuyende kwaku' tukakubi'ki wiso kalamu ya Pasika?” ");
INSERT INTO mgw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bai, Yesu aatumike abi'li' ba banamasi' bake kaabakia, “Muyende kumisengo, akwo mukankolya nnalu'me yumo apu'twi kibi'ga sa masi'. Mukammi'ngi'ye, ");
INSERT INTO mgw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka panyumba yaalu'a yingya, mukammakie mwene nyumba, ‘Mwalimu alaluya panga sumba sake so li'lya kalamu ya Pasika ywembe na banamasi' bake saku?’ ");
INSERT INTO mgw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naywembe aalu'a kunnangya sumba kiku'lu' kugolopwa sakibi'kilwe wiso no nemekelwa, na mwenga mukabi'ke wiso ilyo.” ");
INSERT INTO mgw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Banamasi' ngababu'ka yenda kumisengo, ngabakikolya kila kili'be kibile kati mu'lu' mwababakiyilwe na Yesu. Nabembe ngababi'ka wiso kalamu ya Pasika. ");
INSERT INTO mgw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pakiikite kitamwiyo, Yesu na banamasi' bake ku'mi na abi'li' ngabaika pa yi'lu' nyumba. ");
INSERT INTO mgw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nabembe pabaabile pakitamo so lya, Yesu aatibaya, “Kakape nimmakianga, yumo pakati yinu alu'a nisongya.” ");
INSERT INTO mgw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Apo banamasi' bake baatumbwi nyopa kabalaluyana bene na bene, “Buli, iwesapanga nenga?” ");
INSERT INTO mgw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ngaayangwa, “Yumo pakati yinu mwenga ku'mi na abi'li', yu'lu' ywasuyite likati pamope nanenga mukibakuli. ");
INSERT INTO mgw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kwa mwanjaa Mwana wa Mundu endawaa kati mu'lu' Maandiko Mapeleteu mwagabaya kwo bu'kana na ywembe, lakini akibona mundu yu'lu' ywansongya! Ilu'e panga nantali kwake akakotoka belekwa.” ");
INSERT INTO mgw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pabaabile kabalya, Yesu aatweti likati ngasukulu Nnu'ngu', bu'kapo aatikulimetwana na kwapeya banamasi' bake kaabakia, “Mutole mulye, yi'no nga yi'ga yangu'.” ");
INSERT INTO mgw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bu'kapo, aatweti nnobo wa divai, ngansukulu Nnu'ngu' na kwapeya, boti ngabanywelya munnobo wo. ");
INSERT INTO mgw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu ngaabakia, “Yi'no nga myai yangu' ya lilagano lya Nnu'ngu' yaiyitanika kwa kitumbu sa baingi. ");
INSERT INTO mgw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kakape nimmakianga, tumbulya nambi'yambi' nanywali kai' divai ya njabibu mpaka lisu'ba li'lu' lya Ukulungwa wa Nnu'ngu' panainywa yayambi'.” ");
INSERT INTO mgw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nabembe pabayomwi yi'mba mwambo, ngababu'ka yenda ku Kitu'mbi' sa Minjaituni. ");
INSERT INTO mgw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ngaabakia, “Mwenga mwaboti mwanileka, kwa mwanjaa iandikilwe mu Maandiko Mapeleteu, ‘Naalu'a kummulaga nsungi, na ngondolo boti baalu'a talanganika.’ ");
INSERT INTO mgw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini bu'ka pauyu'ki wangu', naalu'a kunnongolya yenda ku Galilaya.” ");
INSERT INTO mgw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petili ngammakia, “Ata manaitei boti baakuleka, nenga nakuleka lili.” ");
INSERT INTO mgw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ngammakia, “Kakape nikubakia, kilo si'no sa li'no njogolo abile balo bi'ka pabi'li', wanikana mala itatu.” ");
INSERT INTO mgw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petili ngakong'ondelya baya, “Ata manaitei waa pamope nawenga, katu nakukanali.” Na balu' bi'ngi' boti ngababaya nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ngabaika pakyati' sakikemelwa Getisemani, Yesu ngaabakia banamasi' bake, “Mutame pano munili'nde, nenga nendasali.” ");
INSERT INTO mgw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bu'kapo ngantola Petili, Yakobi na Yoani, no tumbwa nyopa no auka. ");
INSERT INTO mgw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngaabakia, “Mwoyo wangu' wenda nyopa muno, ata pipi no waa. Mutame pano, mukeleke.” ");
INSERT INTO mgw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bu'kapo ngaegelya nnu'ngi' pasini, ngaitu'ya pai' ukukama. Ngalu'ba kabaya panga mana iwesekine, saa yi'lu' ya ngu'su'mbu' impi'ti kuutalu. ");
INSERT INTO mgw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ngabaya, “Mwenga mwa Tati'! Ntu'pu' sangali kombolwa kasinu, ninnu'ba munibu'ki'ye agu' nnobo wa ngu'su'mbu'. Lakini kaneipange kati mwanipendi nenga, ila ipange kati mwamupendi mwenga.” ");
INSERT INTO mgw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Paabuyangine, ngaakolya bagonjike lugono. Ngammakia Petili, “Simoni, ugonjike? Ata keleka kwa lisaa limo bai ukombwili? ");
INSERT INTO mgw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mukeleke no sali li'nga mwakane yingya mumapayilwo, kwa mwanjaa loo ipenda panga makowe manogau, lakini yi'ga yinu nga kigopi.” ");
INSERT INTO mgw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngayenda sali kai' kaki'li'bu'kya mayi'gi'yo gaagalu'galu'. ");
INSERT INTO mgw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Paabuyangine kai' aakwembite bagonjike, kwa mwanjaa minyo gabe gaatopilwe na lugono, na baatangiteli saku' sa kunnyangwa. ");
INSERT INTO mgw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Paabuyangine pampanda patatu, ngaabakia, “Balo mukagonja no pu'mu'lya? Ili'ngani lelo! Saa itimile. Mulinguli, Mwana wa Mundu akamuyilwa mumaboko ga bene sambi. ");
INSERT INTO mgw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Muyumuke tubu'ke. Lingulyange, yu'lu' ywapala nisongya aegelile.” ");
INSERT INTO mgw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu paabile balo kalongela, Yuda, yumo ywa balu' banamasi' ku'mi na abi'li', ngaisa pamope na kipi'nga sa bandu babaapu'twi mapanga na mandolonga. Bandu bo baatumilwe na api'ndo ba dini, balimu ba salya ya Musa na api'ndo ba bandu. ");
INSERT INTO mgw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda yu'lu' ywansongya aayomwile kwapeya mwasu wu' kabaya, “Yu'lu' ywanannonia ngaywembe. Mummoywe na kumpeleka kwa kunni'ndi'la.” ");
INSERT INTO mgw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda paikite bai, ngannyendelya Yesu popopo na kummakia, “Mwalimu!” Bu'kapo ngannonia. ");
INSERT INTO mgw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bai, balu' bandu ngabammoywa Yesu na kuntaba. ");
INSERT INTO mgw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yumo ywa balu' babaayi'mi pamope na Yesu aasolomwi lipanga lyake na kumpoteka ntumisi wa mpi'ndo nku'lu' ywa dini na kummu'ya lisikilo. ");
INSERT INTO mgw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bu'kapo Yesu ngaabakia, “Mwisi na mapanga na mandolonga li'nga kuniboywa, baya kwake kati nenga nampokonyoli. ");
INSERT INTO mgw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Masu'ba goti naabile pamope na mwenga kaniyi'gana muluwa lwa Nyumba ya Nnu'ngu', na mwenga muniboywili. Lakini makowe ga gapangike li'nga Maandiko Mapeleteu gatimi.” ");
INSERT INTO mgw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Banamasi' bake boti ngabanneka no tila. ");
INSERT INTO mgw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lakini mwinsembe yumo ywaawati ngu'bo mukibuno, aayendeli kummi'ngi'ya Yesu. Nabembe ngabammoywa. ");
INSERT INTO mgw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lakini ayo ngu'bo yaatiulika, ngaileka popo no tila abile wausu. ");
INSERT INTO mgw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nabembe ngabampeleka Yesu kwa mpi'ndo nku'lu' ywa dini na api'ndo ba dini, na ayi'mi'li'ki ba bandu pamope na balimu ba salya ya Musa boti baakongolekine palu'. ");
INSERT INTO mgw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petili aami'ngi'yite Yesu kwa kuutalu, ngayingya kulua lwa nyumba ya mpi'ndo nku'lu' wa dini, ngatama pamope na ali'ndi'li kayota mwoto. ");
INSERT INTO mgw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Api'ndo ba dini na boti ba Balasa Liku'lu' lya Ayahudi bapalage ukong'ondeli li'nga bapate kitumbu sa kummulaga Yesu, lakini baapatikeli kitumbu sosoti. ");
INSERT INTO mgw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Baingi baapiyite ukong'ondeli wa ubu'su' bu'kana na Yesu, lakini ukong'ondeli wabe walandineli. ");
INSERT INTO mgw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ata bi'ngi' baayi'mi kumpikiya ukong'ondeli wa ubu'su' kababaya, ");
INSERT INTO mgw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Twenga twannyu'wine kabaya, ‘Nenga nilu'a kwisengwana nyumba yi' ya Nnu'ngu' yaisengilwe kwa maboko ga bandu, na kwa masu'ba gatatu nilu'a kwisenga yi'ngi' yangali sengelwa kwa maboko ga bandu.’” ");
INSERT INTO mgw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lakini ata nnyo, ukong'ondeli wabe uyi'ki'tyaniyeli. ");
INSERT INTO mgw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bai, mpi'ndo nku'lu' ywa dini ngayi'ma pakatikati ya bandu na kunnaluya Yesu, “Uyangwali ata likowe? Bandu ba bakusitakilya namani?” ");
INSERT INTO mgw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini Yesu aatami liki, alongeili kikowe sosoti. Mpi'ndo yu'lu' aatikunnaluya kai', “Wenga nga wa Kilisitu, Mwana wa Nnu'ngu' ywalumbilwa?” ");
INSERT INTO mgw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ngayangwa, “Nenga nga Naywembe! Kai', mwammona Mwana wa Mundu atami kummalyo ga yu'lu' Bwana Mwene Makakala, kaulu'ka bu'ka kumaunde ga kunani.” ");
INSERT INTO mgw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mpi'ndo yu'lu' paayu'wine makowe go, ngapopwana magu'bo gake no baya, “Tupalikwali yendelya pala ukong'ondeli wowoti waubu'kana na mundu yu'. ");
INSERT INTO mgw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwabene munnyu'wine mu'lu' mwantukine Nnu'ngu'. Muwasa buli?” Boti ngabamuukumu panga, apalikwa abulagilwe. ");
INSERT INTO mgw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bu'kapo, bandu bi'ngi' baatumbwi kumunia mmata, baantabite kitambala kuminyo na kunku'mbwa makondi na kummakia, “Londwa, nyai ywakuku'mbwile!” Nabembe ali'ndi'li baamoywi Yesu na kunku'mbwa mbande. ");
INSERT INTO mgw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petili paabile balo pai' kulua, yumo ywa atumisi alwawa ba mpi'ndo nku'lu' wa dini aaikite palu'. ");
INSERT INTO mgw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paamweni Petili kayota mwoto, aatikunningulya na kummakia, “Ata wenga nyinyonyo waabile pamope na Yesu wa ku Nasaleti.” ");
INSERT INTO mgw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini Petili aatikana kabaya, “Nigatangiteli makowe gaugabaya wenga katu!” Bu'kapo Petili aayi'i mpaka paniango wa kuluwa. Apo, njogolo ngabi'ka. ");
INSERT INTO mgw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yu'lu' ntumisi nnwawa, paamweni kai' Petili aatumbwi kai' kwabakia bandu babaayi'mi po, “Mundu yu' nga yumo mukipi'nga sabe!” ");
INSERT INTO mgw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lakini Petili aatikana kai'. Bu'ka po baliya pasene, bandu babaayi'mi po ngabammakia Petili, “Kakape wenga wa yumo ywabe, kwa mwanjaa wenga wa mundu wa Galilaya!” ");
INSERT INTO mgw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bai, Petili aatumbwi longela kalapangya panga, “Nintangiteli mundu yu' ywamunnongelya.” ");
INSERT INTO mgw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Popopo, njogolo ngabi'ka pampanda pabi'li'. Bai, Petili ngaku'mbu'kya mu'lu' mwaabakiyilwe na Yesu panga, “Pangali njogolo bi'ka pabi'li', wanikana patatu.” Na, paliku'mbu'ki lyo, aatumbwi li'la muno. ");
INSERT INTO mgw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kindai' bulabula, api'ndo ba dini, ayi'mi'li'ki ba bandu, balimu ba salya ya Musa na api'ndo boti ba Balasa Liku'lu' lya Ayahudi batami kitamo no yi'ki'tyana. Bantabite Yesu, ngabampeleka na kunkamukia kwa Pilato. ");
INSERT INTO mgw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato aannalwiye Yesu, “Wenga nga wankulungwa wa Ayahudi?” Yesu ngayangwa, “Wenga ngawaubaya.” ");
INSERT INTO mgw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nabembe api'ndo ba dini bansitaki Yesu kwa makowe gambone. ");
INSERT INTO mgw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bai, Pilato ngannaluya kai', “Wenga uyangwali ata likowe limo? Lingulya makowe ga goti gabakusitakilya!” ");
INSERT INTO mgw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu aayangwili ata likowe lyolyoti, na Pilato mwene aatisangala. ");
INSERT INTO mgw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yaai mimu yabe panga kila paika si'li'ku'si'li'ku' ya Pasika, Pilato aayu'gu'lyage ntabilwe yumo ywabansawi bene bandu. ");
INSERT INTO mgw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nsimu wo, kwabile na mundu yumo ywakemilwe Balaba, aabile ntabilwe pamope na aine bi'ngi' babaapangite makosa go bulaga bandu no kana kwiyu'wa silikali. ");
INSERT INTO mgw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bandu baingi bannyendeli Pilato li'nga kunnu'ba aapangi kati mwaibile mimu yake. ");
INSERT INTO mgw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ngaalaluya, “Mupala ninnyu'gu'lyange ayu' nkulungwa wa Ayahudi?” ");
INSERT INTO mgw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aalongei nyo kwa mwanjaa aatangite panga api'ndo ba dini bampelike Yesu kasake kwa kitumbu sa kummi'kya bwigu bai. ");
INSERT INTO mgw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini api'ndo ba dini ngabaasopa bandu li'nga bannu'be Pilato aayu'gu'li Balaba. ");
INSERT INTO mgw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato aatikwalaluya kai', “Bai, mupala nipange namani na ayu' mundu ywamunkema nkulungwa wa Ayahudi?” ");
INSERT INTO mgw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngabapanga ndu'ti kababaya, “Abambilwe munsalaba!” ");
INSERT INTO mgw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ngaalaluya, “Aapangite likosa gani?” Lakini baayongiye panga ndu'ti kababaya, “Abambilwe!” ");
INSERT INTO mgw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kwo pala kwapulaisa bandu, ngaayu'gu'lya Balaba no amulisa Yesu aku'batilwe mikwasu na kunkamukiya kwa asikali li'nga abambilwe munsalaba. ");
INSERT INTO mgw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bu'kapo, asikali ngabampeleka Yesu kunyumba ya liwali no kema kipi'nga soti sa asikali. ");
INSERT INTO mgw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Banng'walike Yesu ngu'bo yene lukanda lwa sambalau no lu'ka kapiya ya mimimwa na kunng'walika muntwe. ");
INSERT INTO mgw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngabatumbwa kumpanga abali kwa kunsalanga, “Ukayumuka, Wankulungwa wa Ayahudi!” ");
INSERT INTO mgw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ngabanku'mbwa muntwe kwa nnai, kumunia mmata, na kunkilikitya nnu'ngi' yake. ");
INSERT INTO mgw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bu'ka pa kunsalanga, ngabammula yi'lu' ngu'bo ya sambalau na kunng'walika ngu'bo yake, bu'kapo ngabampeleka kummamba. ");
INSERT INTO mgw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pabaabile kabampeleka, baakwembine na mundu yumo ywaakemilwe Simoni, mwenekaya wa Kulene kauma kunng'unda. Aywo aai tati' ywa Alekisanda na Rufo, ngabanni'ndi'ndi'lya aupu'twe nsalaba wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bu'kapo ngabampeleka Yesu mpaka pandu papaakemilwe Golgotha, ilombolya Pandu pa Lipakala lya Ntwe. ");
INSERT INTO mgw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bampei divai yaiyangabanilwe na manemane, lakini ywembe aakani nywa. ");
INSERT INTO mgw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bu'kapo ngabammamba munsalaba no bagana magu'bo gake kwo ng'andya mpumbe, li'nga batange panga ngu'bo gani yaipalikwa kila mundu apate. ");
INSERT INTO mgw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yaai musaa itatu ya kindai' paabambilwe munsalaba. ");
INSERT INTO mgw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lyaandikilwe lilu'nga bu'kana no sitakilwa kwake lyalyaandikilwe, “Nkulungwa wa Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kai' apokonyoli abi'li' baabambilwe pamope na Yesu munsalaba, yumo kunki'ya na ywi'ngi' kummalyo. ");
INSERT INTO mgw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bandu babaabile kabapi'ta palu', ngabatikatika mitwe na kumpwi'wa kababaya, “Kumbe! Wenga waupalage kuibomwana nyumba ya Nnu'ngu' na kuisenga kai' kwa masu'ba gatatu, ");
INSERT INTO mgw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","wiuluye munsalaba li'nga wikosopoli wamwene!” ");
INSERT INTO mgw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nyinyonyo na api'ndo ba dini pamope na balimu ba salya ya Musa ngabankeneka Yesu kababakiyana, “Aakosopoli bi'ngi', lakini kwikosopolya mwene akombwali! ");
INSERT INTO mgw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ati' ywembe aibaya nga Kilisitu, nkulungwa wa Isilaili! Lelo, aiuluye mwene munsalaba li'nga na twenga tupate lola na kumwu'bi'lya.” Nabembe babaabambilwe nakwe mumisalaba yabe, ngabampwi'wa. ");
INSERT INTO mgw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na payikite saa sita ya muntwekati mpaka saa tisa, lubi'ndu' lwauwi'ki'li nni'ma woti. ");
INSERT INTO mgw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na paikite saa tisa, Yesu aau'bwiye lilobe kakemelya, “Eloi, Eloi, lema sabakitani?” Lombolya, “Nnu'ngu' wangu', Nnu'ngu' wangu', mboni utenileka?” ");
INSERT INTO mgw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bi'ngi' ba bandu babaayi'mi po pabayu'wine go, baatibaya, “Mumpi'kani, ankema Eliya.” ");
INSERT INTO mgw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu yumo ngabutuka lubi'lo yenda suya mukasiki na kwitabya munnai. Bu'kapo ngamwu'bu'ki'ya Yesu li'nga anywe, kabaya, “Munneke, tulole mana Eliya alu'a isa kumuluya bu'ka munsalaba.” ");
INSERT INTO mgw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lakini Yesu aau'bwiye lilobe liku'lu', ngayomoka. ");
INSERT INTO mgw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bai, panjia munyumba ya Nnu'ngu' ngaipopwanika itema ibi'li', bu'ka kunani mpaka pai'. ");
INSERT INTO mgw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mpi'ndo yumo ywa asikali ywaayi'mi nnu'ngi' ya Yesu paibweni mu'lu' mwayomwike, ngabaya, “Kakape mundu yu' aai Mwana wa Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kwabile na alwawa babalingulyage kwa kuutalu. Mukipi'nga sabe aai Malia Makatalena, Malia mau' bake Yakobi nnunawe Yose, na nnwawa ywi'ngi' Salome. ");
INSERT INTO mgw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Alwawa ba nga balu' babammi'ngi'yite Yesu na kuntumikia nsimu waabile Galilaya. Alwawa bi'ngi' baingi babammi'ngi'yite mpaka Yelusalemu baabile po nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Paikite kitamwiyo, lyaai lisu'ba lyo yingilya Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kwabile na Yusupu wa Alimataya, mundu mwene isima mu Balasa Liku'lu', kai' api'kanilyage isa kwa Ukulungwa wa Nnu'ngu'. Kwa nyo, Yusupu ngayenda lu'ba ntwi wa Yesu kwa Pilato pangali yogopa. ");
INSERT INTO mgw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato aatisangala payu'wine panga Yesu awile. Ngankema yu'lu' mpi'ndo ywa asikali na kunnaluya panga kakape Yesu awile. ");
INSERT INTO mgw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato pabakiyilwe na yu'lu' mpi'ndo ywa asikali panga Yesu awile, ngannyi'ki'ti'ya Yusupu yenda kuutola ntwi wake. ");
INSERT INTO mgw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Apo Yusupu ngapi'ma sanda uu, na kuulukiya pai' ntwi, na kuuti'li'ti'ki'ya sanda. Ngaubi'ka ntwi wo mulisiko lyalisongilwe mumpi'mbi'. Bu'kapo, ngaimbilikia liwe liku'lu' paniango wa lisiko. ");
INSERT INTO mgw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nabembe Malia Makatalena na Malia mau' bake Yose baapabweni pandu pabanng'onjike. ");
INSERT INTO mgw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Paliyomwike lisu'ba lya Sabato, Malia Makatalena, Malia mau' bake Yakobi, na nnwawa ywi'ngi' Salome baapi'mite mauta go sikya li'nga bakaupakaye ntwi wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jumapili kindai', lisu'ba kalitumbwa pita, ngabayenda kulisiko. ");
INSERT INTO mgw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nabembe baai kababakiyana, “Nyai ywakombwa kulinokwa li'lu' liwe bu'ka munniango wa lisiko?” ");
INSERT INTO mgw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lakini pabalingulile, ngabalibona li'lu' liwe liku'lu' linokolilwe pambwega. ");
INSERT INTO mgw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pabaabile kabayingya mulisiko, ngabankolya mwinsembe yumo aweti nganju uu, atami kummalyo, nabembe ngabang'ang'amuka. ");
INSERT INTO mgw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lakini mwinsembe yu'lu' ngaabakia, “Kanemung'ang'amuke! Mumpala Yesu wa ku Nasaleti ywaabambilwe munsalaba. Ywembe ayu'kite, abileli pano. Mulinguli, pano nga pandu pabammi'kite. ");
INSERT INTO mgw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lakini nambi'yambi' muyende mukaabakiye banamasi' bake pamope na Petili panga endalongolya yenda ku Galilaya, namwenga mukammona kwo kati mu'lu' mwaamakiye.” ");
INSERT INTO mgw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bai, baapitike mulisiko no butuka lubi'lo ku'no kabalendema no sangala muno. Nabembe bammakiyeli mundu ywoywoti kwa mwanjaa baatiyogopa. ");
INSERT INTO mgw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu paayu'kite, yaai kindai' lisu'ba lyo tumbulya yuma. Aampiti wi'ti' Malia Makatalena, yu'lu' ywammi'ngite moka saba. ");
INSERT INTO mgw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malia ngayenda kwabakia balu' babaabile pamope na Yesu. Na paikite aayi'i kwakolya kabalombola no li'la. ");
INSERT INTO mgw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lakini, pabayu'wine panga Yesu ayu'kite na Malia Makatalena aamweni, baau'bi'li lili. ");
INSERT INTO mgw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bu'kapo banamasi' abi'li' baabile kabayenda kumigunda, Yesu ngaapitya abile agalambwike kuminyo. ");
INSERT INTO mgw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nabembe baatibuyangana na kwabakia banamasi' bi'ngi' makowe galu', lakini nyinyonyo baau'bi'li lili. ");
INSERT INTO mgw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kuundi'la, Yesu aapiti balu' banamasi' ku'mi na yumo pabaabile kabalya kilyo. Aatikwakalipya kwa kitumbu so kotoka u'bi'lya kwabe na unonopau wa myoyo yabe kwo kana kwau'bi'lya balu' babaamweni bu'ka pa uyu'ki wake. ");
INSERT INTO mgw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bu'kapo ngaabakia, “Muyende mudunia yoti mukaale abali inannoga kwa kila mundu. ");
INSERT INTO mgw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ywau'bi'lya no batisilwa aalu'a kosopolelwa, lakini ywaakotoka u'bi'lya aaukumilwa. ");
INSERT INTO mgw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na boti babaalu'a u'bi'lya baalaya myasu yi'no. Kwo tumya lina lyangu', baalu'a bi'nga moka, baalongela kwa luga yayambi'. ");
INSERT INTO mgw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kai', baakamwa nng'ambo kwa maboko gabe, ata mana banywile kili'be sene sumu baasulikali katu, baabi'ka moko gabe panani ya atamwe, nabembe baayu'yu'ki'lwa.” ");
INSERT INTO mgw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bwana Yesu paayomwi longela nabo makowe go, ngakatuyilwa yenda kunani no tama kummalyo ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nabembe banamasi' bake ngabayenda ala abali yake kila pandu. Bwana Yesu aapangite lyengo pamope nabo na kulikangamaya liyi'gi'yo lyake kwa myasu yayaayi'i pamope na liyi'gi'yo lyo.");
INSERT INTO mgw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mundumuko Topili, bandu baingi bakasine andika bu'kana na makowe galu' gagaapangike paminyo gitu. ");
INSERT INTO mgw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bagaandike kati mwatubakiyilwe na balu' babaagabweni makowe go kagapangika bu'ka patumbu na babaalage Liyi'gi'yo lyo. ");
INSERT INTO mgw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nanenga bu'kana no pekeseni makowe goti bu'ka patumbu, niibweni nikwandiki wa mundumuko kwa kindonda, ");
INSERT INTO mgw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","li'nga nawenga wiloli wamwene ukakape ya makowe galu' goyi'ganilwe. ");
INSERT INTO mgw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Masu'ba ga Helode, nkulungwa wa Yudea, kwai na mpi'ndo wa dini ywakemelwage Zakalia, ywaabile mukipi'nga sa upi'ndo wa dini wa Abiya. Nnyumbowe akemelwage Elisabeti nembe aabile mukipi'nga sa lukolo lwa Aluni. ");
INSERT INTO mgw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Boti abi'li' baai apeleteu kwa Nnu'ngu', batamage kwo bi'ngi'ya goti gaalagi Nnu'ngu' wangali bi'ki'lwa lukolo. ");
INSERT INTO mgw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lakini, baabile banapapali mwana mwanjaa Elisabeti aai ntonga na boti abi'li' baai agoi muno. ");
INSERT INTO mgw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Paliikite lisu'ba lyake lyo panga lyengo lya upi'ndo wa dini palua lwa nyumba ya Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakalia asaulilwe na bandu kati mwaibile mimu yo yingya mu Nyumba ya Nnu'ngu' li'nga auye ubani. ");
INSERT INTO mgw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kipi'nga sa bandu saamesekine palua kabasali, ku'no Zakalia kauya ubani. ");
INSERT INTO mgw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Amo nnyumba, ngampitya malaika ywa Nnu'ngu' ywayi'mi kummalyo ga kibi'ki'lyo so ukiya ubani. ");
INSERT INTO mgw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Paamweni, Zakalia aapatike ndele no yogopa. ");
INSERT INTO mgw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini malaika wa Nnu'ngu' ngammakia, “Wa Zakalia we, kaneuyogope, mwanjaa gonnu'bite Nnu'ngu' akuyu'wine. Nnyumbogo Elisabeti alu'a kupapya mwana nnalu'me, na lina lyake wantine Yoani. ");
INSERT INTO mgw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Waalu'a napusika muno na bandu baingi baapanga si'li'ku'si'li'ku' kwa kitumbu so belekwa kwake. ");
INSERT INTO mgw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Alu'a panga wa mpu'ku'bi'la nnu'ngi' ya Nnu'ngu'. Alu'a lobyali wi'mbi' wowoti, alu'a twi'li'yi'lwa Loo Mpeleteu bu'ka mundumbo ya mau' bake. ");
INSERT INTO mgw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Alu'a kwagalambwa bandu baingi ba Isilaili baamuyangani Nnu'ngu' wabe. ");
INSERT INTO mgw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Alu'a kunnongolya Bwana, ku'no kalongoyelwa na makakala ga Loo Mpeleteu kati nnondoli ywa Nnu'ngu' Elia. Aalu'a kwaawana akina tati' na bana babe, na kwigalambwa myoyo ya kimbu'ku'su' babe na malango kati mwabapanga bandu ba Nnu'ngu', bu'kapo ammi'ki wiso Bwana bandu bake.” ");
INSERT INTO mgw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia ngammakia aywo malaika, “Kikowe saku' sakilu'a nipanga nenga niu'bi'li likowe li'? Nenga na nnyumbo wangu' twaboti tugoime.” ");
INSERT INTO mgw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaika ngannyangwa, “Nenga na Gabulieli, na malaika ywaniyi'ma nnu'ngi' ya Nnu'ngu', nitumilwe nikubakie abali inannoga. ");
INSERT INTO mgw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pi'kania, mwanjaa ukana u'bi'lya makowe ganikubakia ulu'a galambuka panga wa bubu, walongelali mpaka gano ganikubakie gatimi.” ");
INSERT INTO mgw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Apo bandu baakibweni kyukala kwa mwanjaa Zakalia aasi'li'ye pitya palua lwa Nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Paapiti panja, akombwili longela nabo. Yabonekine mpu'la kasabe Zakalia aagabweni makowe gayambi' mu Nyumba ya Nnu'ngu', mwanjaa ywembe alongelage kwo langyalangya na moko. ");
INSERT INTO mgw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Paliyomwike lyengo lyake lyo yi'mi'li'ka mu Nyumba ya Nnu'ngu', aabuyangani kaya. ");
INSERT INTO mgw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bu'kapo, nnyumbowe Elisabeti ngayi'ma ndumbo, ngayu'ba kasake kwa myei mitano kabaya, ");
INSERT INTO mgw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ago nga gaanipangi Nnu'ngu', anibi'ki kiya na kunibu'ki'ya oni yo kotoka beleka yanaabile nayo paminyo ga bandu.” ");
INSERT INTO mgw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pawikite mwei wa sita, malaika Gabulieli aatumilwe na Nnu'ngu' ayende kukilambo sakikemelwa Nasaleti, akwo ku Galilaya, ");
INSERT INTO mgw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa mwi'nja yumo ywangalikuntanga nnalu'me ywakemelwage Malia, aakobekilwe na Yusupu bu'ka mulukolo lwa Daudi. ");
INSERT INTO mgw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika ngannyendelya na kummakia, “Abali wenga wauyaliwite na Nnu'ngu', Nnu'ngu' abile pamope na wenga.” ");
INSERT INTO mgw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia paayu'wine makowe go, ngaumpata ntenyo, no tumbwa gania, “Makowe ga galombolya namani?” ");
INSERT INTO mgw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika ngammakia, “Malia, kaneuyogope, nnyino Nnu'ngu' akupendile. ");
INSERT INTO mgw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ulu'a yi'ma ndumbo, waalu'a papa mwana nnalu'me, na lina lyake wantine Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ywembe aalu'a panga mpi'ndo na aakemelwa Mwana wa Nnu'ngu' nku'lu'. Nnu'ngu' alu'a kumpeya kiti'gu' sa lenji bu'ka mulukolo lwa nkulungwa Daudi. ");
INSERT INTO mgw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kwa nyo, alu'a tawala lukolo lwa Yakobi milele na ukulungwa wake wayomokali.” ");
INSERT INTO mgw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia ngannyangwa, “Ago kagapitya kwaku', nanenga nantangali nnalu'me?” ");
INSERT INTO mgw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika ngannyangwa, “Alu'a kuulukya Loo Mpeleteu, na uweso wa Nnu'ngu' Nku'lu' walu'a kwisilya kati kiwili. Kwa nyo, mwana ywaabelekwa alu'a kemelwa Mpeleteu Mwana wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kai' utange ata Elisabeti nnongogo, ywabammayage ntonga, ai na ndumbo ya myei sita ya mwana nnalu'me, naywembe nng'oi. ");
INSERT INTO mgw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwa nyo, makowe goti apanga Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia aabaite, “Nenga na mundu wa Nnu'ngu', nipangilwe kati mwobaike.” Payomwi yangwa nyo, yu'lu' malaika ngabu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bu'ka pa masu'ba nsi'si', Malia aayabwi mwanja wa kiyu'ngu'ya mpaka kunni'ma waubile mwitu'mbi' ya ku Yudea. ");
INSERT INTO mgw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akwo, aayi'i kunsalimia Elisabeti munyumba ya Zakalia. ");
INSERT INTO mgw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti paayu'wine lilobe lya Malia, mwana nnele mundumbo yake ngau'mbau'mba, nembe Elisabeti ngatwi'li'yi'lwa Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ngalongela kwa lilobe liku'lu', “Utiyaliwa pi'ta alwawa boti, na ywolu'a kumpapa kwa ndumbo yobilenayo, ayaliwite. ");
INSERT INTO mgw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mwanjaa namani makowe maku'lu' kati ga kumbitya ne, ata mau' bake Bwana wangu' baniisili? ");
INSERT INTO mgw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Paniyu'wine lilobe lyako bai, kaunipanga abali, kaana kakabile nndumbo yangu' kaatiu'mbau'mba kwo pulaika muno. ");
INSERT INTO mgw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nantali wenga wauu'bi'li panga galu' gaakubakie Nnu'ngu' galu'a pitya.” ");
INSERT INTO mgw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia ngabaya, “Mwoyo wangu' unnumba Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na loo yangu' impulaikya Nnu'ngu', ywanikombwile. ");
INSERT INTO mgw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwa mwanjaa anninguli kwa liyo lya kiya, ntumisi wake ywa nnyu'wa. Kwa nyo, bu'ka nambi'yambi' bandu boti balu'a nikema na ywayaliwite. ");
INSERT INTO mgw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kwa mwanjaa Nnu'ngu' mwene makakala anipangi maku'lu', lina lyake lipeleteu. ");
INSERT INTO mgw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kwabi'kya kiya balu' bandu babamwisimu, lama bu'ka lubelekwo mpaka lubelekwo. ");
INSERT INTO mgw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Apangite makowe maku'lu' kwa luboko lwake, Aasengemwaniye bene mpyata mumyoyo yabe. ");
INSERT INTO mgw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aulwiye bene makakala bu'ka muiti'gu' yabe ya lenji, na kwa katuya aki'ba. ");
INSERT INTO mgw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ayukutiye manogau bene njala, na kwabu'ya moko gabule bene mali. ");
INSERT INTO mgw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Annyangatie ntumisi wake Isilaili, aku'mbu'ki kiya sake. ");
INSERT INTO mgw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kati mwaalagi api'ndo bitu, Bulaimu na lubelekwo lwake mpaka mwiso wa bwu'mi.” ");
INSERT INTO mgw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia aatami na Elisabeti kwa myei itatu, no buyangania kasake. ");
INSERT INTO mgw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Paikomile ndumbo yake, Elisabeti ngapapa mwana nnalu'me. ");
INSERT INTO mgw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Alongobe na bandu, pabayu'wine makowe go panga Nnu'ngu' ami'kikiya muno, baanapusike pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Paliikite lisu'ba lya nane, baatiisa li'nga kumwina mwana liku'mbi' na kuntina lina lya tati' bake Zakalia. ");
INSERT INTO mgw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mau' bake ngabakana, ngababaya, “Nyinyo lili, mbala akemelwe Yoani.” ");
INSERT INTO mgw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ngabammakia, “Mboni ntu'pu' mundu ywakemelwa lina lyo mulukolo lwinu?” ");
INSERT INTO mgw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bai, ngabannaluya Zakalia kwo langyalangya bapate tanga panga apala mwana wake akemelwe nyai. ");
INSERT INTO mgw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nembe aalu'bite kibao so andika, aandike nnyanya, “Yoani nga lina lyake.” Boti baatisangala. ");
INSERT INTO mgw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Popopo, nkano na lulimi lwa Zakalia ngaiyu'gu'li'lwa, ngalongela na kunnumba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Alongobe baayingililwe na bwoga pabagabweni makowe go, gaayu'wanike kila pandu muitu'mbi' ya Yudea. ");
INSERT INTO mgw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Boti babaagayu'wine makowe go, baatigania mumyoyo yabe ku'no kababaya, “Mwana yu' alu'a panga mundu gani?” Mwanjaa makakala ga Bwana gabile pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia tati' bake mwana, ngabatwi'li'yi'lwa na Loo Mpeleteu, no piya kilondwo si'. ");
INSERT INTO mgw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Akwi'yi'lwe Bwana Nnu'ngu' wa Isilaili! Mwanjaa aatikwaisilya na kwakombwa bandu bake. ");
INSERT INTO mgw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atupei nkomboli ywa kutukombwa, mmelekwa kwa lukolo lwa Daudi, ntumisi ywa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mu'mu'lu'mu'lu' mwalongei bu'ka kwai'mbu', kwa ndi'la ya alondoli bake apeleteu, ");
INSERT INTO mgw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","panga alu'a kutukombwa mmoko ga andumu bitu, no bu'ka mumaboko ga boti babatusukwa. ");
INSERT INTO mgw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aabaite alu'a kwabi'kya kiya api'ndo bitu, no ku'mbu'kya lilagano lyake lipeleteu. ");
INSERT INTO mgw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Aalapi au'ku' bitu Bulaimu, panga alu'a tuyalya twenga. ");
INSERT INTO mgw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Panga aatulagi kutukosopolya bu'ka mmoko ga andumu bitu, tupate tumika wangali yogopa. ");
INSERT INTO mgw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kanetulemale myoyo na tubonekane twapeleteu nnu'ngi' yake, masu'ba goti ga bwu'mi witu. ");
INSERT INTO mgw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nawenga wa mwana wangu' walu'a kemelwa wa nnondoli wa Nnu'ngu' nku'lu', waalu'a kunnongolya Bwana, kumpetulya ndi'la yake, ");
INSERT INTO mgw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wabakie bandu bake panga alu'a kwakosopolya, kwo bu'yi'lwa masambi gabe. ");
INSERT INTO mgw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwa kiya kiku'lu' sa Nnu'ngu' witu, Atuumukulya bweya bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Na kwamulikya boti babatama mulubi'ndu' na kiwili sa kiwo, alongoye nganjo yitu mundi'la ya amani.” ");
INSERT INTO mgw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana aatiku'la, no pata makakala ga mumwoyo. Aatami mulubele mpaka paisi boneka paminyo ga bandu ba Isilaili. ");
INSERT INTO mgw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Masu'ba galu' nkulungwa ywa Kiroma ywakemelwage Agusito aoniye lilu'nga kwapala bandu boti panni'ma babalangilwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Awo ngawai ntumbwo wo balangilwa bandu, masu'ba go Kulenio aai mpi'ndo ywa nkoa wa Silia. ");
INSERT INTO mgw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bandu boti baayi'i balangilwa, kila mundu pakilambo sake sabelekulile. ");
INSERT INTO mgw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusupu nembe aayabwi mwanja bu'ka kukilambo sa Nasaleti kuwilaya ya Galilaya li'nga akabalangilwe. Mwanjaa ywembe aabile mulukolo lwa Daudi, aayi'i kukilambo sa Betelehemu, kunkoa wa Yudea kwaabelekuli nkulungwa Daudi. ");
INSERT INTO mgw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aayi'i balangilwa pamope na Malia nnwawa ywankobekage, naywembe pamasu'ba go aai ntopelwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pabaabile kwo, ngaliika lisu'ba lyake lyo komboka. ");
INSERT INTO mgw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngakomboka mwana nnalu'me mmele wake, anng'walike tugu'bo twa kyana na kunng'onjeka mukili'lyo sa ng'ombe mwanjaa baapatikeli poogonjo, nyumba ya ageni yai yatwi'la. ");
INSERT INTO mgw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pandu po paabile na asungi ba ngondolo, babakelekage kilo mumakwabo li'ndi'la myugo yabe. ");
INSERT INTO mgw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaika wa Bwana ngaapitya kwa kiimuimu, na bweya wa utukupu wa Bwana ngawamulikya pu'pu'lu'. Baatiyogopa muno. ");
INSERT INTO mgw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malaika ngaabakia, “Kanemuyogope! Ninnetyangite abali inannoga yo napusika muno, yailu'a kwapata bandu boti. ");
INSERT INTO mgw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mwanjaa li'no pansengo wa Daudi abelikwe Nkosopoli, abelikwe kwa kitumbu sinu mwenga nga Kilisitu Bwana. ");
INSERT INTO mgw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na wu'no walu'a panga mwanju kasinu, panga mukankwemba mwana kilekeleke banng'walike ngu'bo ya kyana banng'onjike mukili'lyo sa ng'ombe.” ");
INSERT INTO mgw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Popopo lipi'nga lya malaika ba kunani ngalilu'mbana na aywo malaika kabannumba Nnu'ngu' kababaya, ");
INSERT INTO mgw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Utukupu kwa Nnu'ngu' kunani, na amani padunia kwa bandu baapendi ywembe.” ");
INSERT INTO mgw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bu'ka pabaabu'i abo malaika buyangania kunani, asungi ngababakiana, “Tuyende nswaa mpaka ku Betelehemu tukalibone likowe li' lyatubakie Bwana.” ");
INSERT INTO mgw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bai, baayi'i kwo talima, ngabaakwemba Malia, Yusupu, na yu'lu' mwana kilekeleke banng'onjike mukili'lyo sa ng'ombe. ");
INSERT INTO mgw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Abo asungi pabaamweni mwana ywo, ngabaabakia bandu boti makowe gabagayu'wine bu'kana na aywo mwana. ");
INSERT INTO mgw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Boti pabayu'wine go, baatisangala bu'kana na makowe gababakiyilwe na asungi. ");
INSERT INTO mgw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Malia aagabi'i mumwoyo wake goti no gania. ");
INSERT INTO mgw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Balu' asungi, baabuyangani kasabe ku'no kabankwi'ya Nnu'ngu' no lumba uku'lu' wake kwa goti gabaagayu'wine na kugabona, gabi kati mwabaabakiyilwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pagapite masu'ba manane bu'ka belekwa, lisu'ba lya kumwina liku'mbi' mwana, bantinike lina lyake Yesu. Lina lyo aatinilwe na malaika masu'ba ata ndumbo ya mwana we anayi'mali. ");
INSERT INTO mgw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pagaikite masu'ba go peleteyelwa Yusupu na Malia kati mwaipalilwage na salya ya Musa, abelei bo bampu'twi mwana no yenda nakwe ku Yelusalemu li'nga bampiye kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Musalya ya Bwana Nnu'ngu' iandikilwe, “Kila mwana mmele nnalu'me abaulilwe kwa Bwana.” ");
INSERT INTO mgw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kai', baayi'i li'nga bapiye salaka ndutu abi'li' au mabunda gabi'li' ga ngunda, kati mwaipalikwage musalya ya Bwana. ");
INSERT INTO mgw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pamasu'ba go akwo Yelusalemu, kwai na mundu yumo mwene aki na kunkilikitya Nnu'ngu' lina lyake akemelwage Simioni, ywembe ali'ndage kwa kilu'lu' kosopolelwa kwa Isilaili. Loo Mpeleteu aabile pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Loo Mpeleteu aamumukuli panga kiwo kinkolyali pangali kummona Kilisitu wa Bwana, Nkulungwa ywalondolilwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bai, kalongoyelwa na Loo Mpeleteu, Simioni aayingi mulua lwa Nyumba ya Nnu'ngu'. Abelei ba Yesu pabannetike mwana wabe mulua lwa Nyumba ya Nnu'ngu', bampangi kati mwaipalikwage na salya, ");
INSERT INTO mgw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni aampoki mwana Yesu mumaboko gake ku'no kankwi'ya Nnu'ngu', kabaya, ");
INSERT INTO mgw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nambi'yambi' Bwana utimisike malagano gako, unnyi'ki'ti'ye ntumisi wako ayende kwa amani. ");
INSERT INTO mgw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Maana kwa minyo gangu' niubweni ukosopoli wauuletike ");
INSERT INTO mgw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","waubi'i wiso ubonekane na mili'ma yoti. ");
INSERT INTO mgw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bweya wawaalu'a kwamulikya bandu ba panja, na utukupu kwa bandu bako Isilaili.” ");
INSERT INTO mgw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tati' na mau' bake Yesu baatisangala kwa makowe gaalongei Simioni kwa abali ya mwana. ");
INSERT INTO mgw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni aatikwayalya, ammakie Malia mau' bake, “Mwana yu' alu'a panga kitumbu so oba no kosopolelwa kwa bandu baingi mu Isilaili. Nembe alu'a panga kati mwanju wo kanilwa na bandu, ");
INSERT INTO mgw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","li'nga gabagania bandu baingi kwo iya gaumukulwe. Na wenga wamwene, lwu'ngu' lwalubile kati lipanga linola lwalu'a kuoma pamwoyo wako.” ");
INSERT INTO mgw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwaabile na nnondoli wa Nnu'ngu' nnwawa nng'oi muno lina lyake Ana, biti Fanueli wa kabila lya Asheli. Bu'ka ku'nda, aatami na nsengowe myaka saba bai. ");
INSERT INTO mgw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kai', aatami wangali nnalu'me mpaka paikiye upi'ndo wa myaka samanini na nsese. Nsimu awo woti, aatami palua lwa Nyumba ya Nnu'ngu' kwo punga no lu'ba kilo na muntwekati. ");
INSERT INTO mgw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Popopo ngaisa Ana na kunnumba Nnu'ngu' no baya makowe ga mwana ywo kwa bandu boti babalolelage kombolelwa kwa Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Abo abelei pabaayomwi panga goti gagaamulilwe na salya ya Bwana, baabuyangani kasabe Nasaleti, kuwilaya ya Galilaya. ");
INSERT INTO mgw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana ngaku'la, aayendeli pata makakala, aatwi'li ikima na ngu'ngu' ya Nnu'ngu' yaai pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Abelei bake baai na salya yo yenda ku Yelusalemu kila mwaka masu'ba ga si'li'ku'si'li'ku' ya Pasika. ");
INSERT INTO mgw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mwana paikiye myaka ku'mi na ibi'li', baayi'i boti kati mwaibile salya yabe ya kila mwaka. ");
INSERT INTO mgw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Paiyomwike si'li'ku'si'li'ku', baatumbwi mwanja wo buyangania kasabe, lakini Yesu aaigali ku Yelusalemu wangali abelei bake tanga panga bannei nsu'gu'. ");
INSERT INTO mgw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bembe bawasage aalongwaniye na lipi'nga lya babalongolile. Baayi'i mwanja wa kutwa banammonali, ngabatumbwa kumpala mwababile alongo na mambwiga. ");
INSERT INTO mgw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pabakotwike kummona baabuyangani ku Yelusalemu kumpala. ");
INSERT INTO mgw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lisu'ba lyenetatu ngabankwemba mulua lwa Nyumba ya Nnu'ngu', atami pakatikati ya balimu ba salya, kaapi'kani'a na kwalaluya maswali. ");
INSERT INTO mgw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boti babannyu'wine makowe gake baagasangalike malango gake na mu'lu' mwayangwae kwa ikima. ");
INSERT INTO mgw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Abelei bake pabaamweni, baatisangala. Malia mau' bake ngabannaluya, “Wamwana wangu', mwanjaa namani utupangite nyo? Tati' bako na nenga twendekupala, malango gaatuobike.” ");
INSERT INTO mgw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ywembe ngayangwa, “Mwanjaa namani munipalage? Mwatangikeli panga, nipalilwa tama munyumba ya Tati' bangu'?” ");
INSERT INTO mgw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini abelei bake baatangiteli makowe go galombolya namani. ");
INSERT INTO mgw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bai, baabuyangine nakwe mpaka ku Nasaleti, na apeyage isima yabe yoti. Mau' bake baagabi'kite makowe ago goti pamwoyo wabe. ");
INSERT INTO mgw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nembe Yesu aayendeli ku'la kimalango na kyi'mo, no pendelwa na Nnu'ngu' na bandu. ");
INSERT INTO mgw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mwaka wa ku'mi na tano waatawalage Kaisali Tibelio, Pontio Pilato atawalage kunkoa wa Yudea. Helode atawalage Galilaya na nnunawe Pilipi atawalage pakilambo sa Itulea na Tulakoniti. Lusania atawalage Abilene. ");
INSERT INTO mgw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa baai api'ndo aku'lu' ba dini. Pamasu'ba go, likowe lya Nnu'ngu' ngalimwisilya Yoani mwana wa Zakalia ku'lu' kulubele. ");
INSERT INTO mgw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bai, Yoani ngayenda muilambo yoti yaipakine na libi'ndi' lya Yordani. Kaabakia bandu boti bagalambuke, bammuyangani Nnu'ngu' no batisilwa, li'nga aabu'ki'ye masambi gabe. ");
INSERT INTO mgw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngamo iandikilwe mukitabu sa nnondoli wa Nnu'ngu' Isaya, “Lilobe lya mundu akema kulubele, mumpetuli Bwana ndi'la yake, mugolwe simbasimba yake. ");
INSERT INTO mgw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mabi'ndi' goti gaalu'a kulilwa, kila kitu'mbi' na litu'mbi' yaalu'a pwimwanilwa no yanjayilwa, papapi'ndike, paalu'a gololelwa. Mali'la gangapetwa, gaalu'a petulwa. ");
INSERT INTO mgw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na bandu boti baalu'a kuubona ukosopoli wauleta Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bai, Yoani aabakiage bandu baingi babaaisile li'nga aabatise kabaya, “Mwenga mwa kinng'ambo, nyai ywanking'indile mwitile nyongo yayaisa? ");
INSERT INTO mgw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mulaye kwa itendo yinu panga mummuyangani Nnu'ngu' kwo kana buyangania sambi. Kanemutumbwe kwipuna, ‘Twenga twa bana ba Bulaimu.’ Nimmakianga kakape panga, Nnu'ngu' akombwa kugagalambwa maliwe gamugabona gapange bana ba Bulaimu. ");
INSERT INTO mgw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bai, libago libi'kilwe paliina lya nkongo kwa nyo, kila nkongo wangali pambika itunda inannoga waalu'a pi'ngu'lwa no sonjelwa mwoto.” ");
INSERT INTO mgw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kipi'nga sa bandu ngabalaluya, “Tupange buli?” ");
INSERT INTO mgw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aayangwi, “Ywabile na ngu'bo ibi'li' ampei mwene buula, na ywabile na kilyo apange nyinyonyo.” ");
INSERT INTO mgw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nabembe alonga koli ngabaisa li'nga babatisilwe ngabannaluya, “Mwalimu, tupange buli?” ");
INSERT INTO mgw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nembe ngayangwa, “Kanemwabonele bandu kwa kwaalonga koli pi'ta yi'lu' yaibi'kilwe na silikali.” ");
INSERT INTO mgw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nabembe asikali ngabannaluya, “Na twenga tupange buli?” Nembe ngayangwa, “Kanemupokonywe kikowe sa mundu ywoywoti kwa makakala, wala kunsitakya mundu kwa likosa lya kunku'pi'ki'a. Inni'ngane mikwiso yamuli'pi'lwa.” ");
INSERT INTO mgw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Boti baai na kikowe sabakipi'kaniage, baai ngabatumbwa kwilaluya kumyoyo yabe kwa abali ya Yoani panga kwaali' ywembe nga Kilisitu ywabayilwe. ");
INSERT INTO mgw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Apo, Yoani ngaabakia boti, “Nenga nimmatisanga kwa masi', nsu'gu' yangu' aisa mwene uweso kulikoni nenga, aywo nenga nipwaikali ata undwana kamba ya ilatu yake. Ywembe alu'a kummatisanga kwa Loo Mpeleteu na kwa mwoto. ");
INSERT INTO mgw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ywembe aabile na kyelo mumaboko gake, so pepekeya ilalyo akaimati muliku'ngwa paligu'lu, na mayu'ngu'lu'lu' akagatiniye kumwoto wangali imika.” ");
INSERT INTO mgw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa nyo, pamope na gaayi'ganage maingi, Yoani aakong'ondeli bandu kaabakia abali inannoga. ");
INSERT INTO mgw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lakini Yoani ankalipi ntawala Helode, kwa kitumbu sa kuntola Helodia nnyumbo wa nnunawe na kumpanga nnyumbowe, na ankalipi kwa ulau woti waupangite. ");
INSERT INTO mgw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kai', Helode aayongiye ulau kwa kunnyingia Yoani muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bandu boti pabayomwi batisilwa, nembe Yesu aatibatisilwa. Na Yesu paasalyage, kunani kwatiyu'gu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na apo, ngapaulukilwa na Loo Mpeleteu ywabile na uyi'me wa ngunda. Lilobe lyayu'wanike bu'ka kunani, “Wenga nga wamwana wangu' wanikupendile, ninogelilwe nawenga.” ");
INSERT INTO mgw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu paatumbwi tanganikwa na bandu kwa lyengo lyake, aabile na myaka salasini, na bandu bakitage panga ywembe mwana wa Yusupu, mwana wa Heli. ");
INSERT INTO mgw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli abi mwana wa Matathia, ywabile mwana wa Lawi, mwana wa Melki, mwana wa Yanai, mwana wa Yusupu. ");
INSERT INTO mgw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ywaabile mwana wa Matathia, mwana wa Amosi, mwana wa Nahumu, mwana wa Esli, mwana wa Nagai. ");
INSERT INTO mgw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ywaabile mwana wa Maathi, mwana wa Matathia, mwana wa Shemeni, mwana wa Yoseki, mwana wa Yuda. ");
INSERT INTO mgw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ywaabile mwana wa Yohanani, mwana wa Lesa, mwana wa Zelubabeli, Zelubabeli aai mwana wa Shealtieli, Shealtieli ai mwana wa Neli, ");
INSERT INTO mgw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Melki, Melki aai mwana wa Adi, mwana wa Kosamu, Kosamu aai mwana wa Elmadamu, ywaabile mwana wa Eli. ");
INSERT INTO mgw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ywaabile mwana wa Yoshua, mwana wa Eliezeli, mwana wa Yolimu, mwana wa Mathati, mwana wa Lawi, ");
INSERT INTO mgw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ywaabile mwana wa Simioni, mwana wa Yuda, mwana wa Yusupu, mwana wa Yonamu, mwana wa Eliakimu. ");
INSERT INTO mgw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ywaabile mwana wa Melea, mwana wa Mena, mwana wa Matatha, mwana wa Nathani, mwana wa Daudi. ");
INSERT INTO mgw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ywaabile mwana wa Yese, mwana wa Obedi, mwana wa Boazi, mwana wa Salmoni, mwana wa Nashoni. ");
INSERT INTO mgw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ywaabile mwana wa Aminadabu, mwana wa Admini, mwana wa Alani, ywabile mwana wa Esiloni, mwana wa Pelesi, mwana wa Yuda. ");
INSERT INTO mgw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ywaabile mwana wa Yakobi, mwana wa Isaki, mwana wa Bulaimu, mwana wa Tela, mwana wa Naholi. ");
INSERT INTO mgw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ywaabile mwana wa Selugia, mwana wa Leu, mwana wa Pelegi, mwana wa Ebeli, mwana wa Sala. ");
INSERT INTO mgw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ywaabile mwana wa Kainamu, mwana wa Alfaksadi, mwana wa Shemu, mwana wa Nuu, mwana wa Lameki. ");
INSERT INTO mgw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ywaabile mwana wa Methusela, mwana wa Henoki, mwana wa Yaledi, mwana wa Mahalaleli, mwana wa Kenani. ");
INSERT INTO mgw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ywaabile mwana wa Enoshi, mwana wa Sethi, mwana wa Adamu, ywaabile ywa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu abu'i mulibi'ndi' lya Yordani ai ntwi'lya Loo Mpeleteu. Ngalongoyelwa na Loo mpaka kulubele, ");
INSERT INTO mgw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","akwo aapayilwe na Ibilisi kwa masu'ba alubaini, masu'ba ago goti aalileli kili'be. Paliikite lisu'ba lya alubaini ngaimminya njala. ");
INSERT INTO mgw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Apo Ibilisi ngammakia, “Wenga manautei wa mwana wa Nnu'ngu' ulibakie liwe li' lipange likati.” ");
INSERT INTO mgw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu ngannyangwa, “Iandikilwe, ‘Mundu alamali kwa likati bai, ila kwa kila liyi'gi'yo lyalibu'ka kwa Nnu'ngu'.’” ");
INSERT INTO mgw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bu'kapo Ibilisi ngampeleka mpaka pandu patu'ndu'bau na kunnaya ukulungwa woti wa padunia. Ibilisi ngammakia, ");
INSERT INTO mgw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Naakupeya uweso wa kulungwa yoti yi', kwa mwanjaa ayi' yoti nitipeyelwa na mana nipendi kumpeya mundu nendakombwa. ");
INSERT INTO mgw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bai, mana wanikilikitya ayi' yoti yapanga mali yako wenga.” ");
INSERT INTO mgw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ngannyangwa, “Iandikilwe, ‘Unkilikiti Bwana Nnu'ngu' wako, na kuntumikia ywembe bai.’” ");
INSERT INTO mgw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ibilisi ngampu'twa mpaka ku Yelusalemu, panani ya Nyumba ya Nnu'ngu' ngammakia, “Manaitei wenga nga wamwana wa Nnu'ngu', witu'mbu'ye pai', ");
INSERT INTO mgw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwa mwanjaa iandikilwe, ‘Aabakia malaika bake bakuli'ndi'le,’ ");
INSERT INTO mgw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na kai', ‘Baakupu'twa mumoko gabe, li'nga wakanekunywa magu'lu' gako muliwe.’” ");
INSERT INTO mgw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lakini Yesu ngannyangwa, “Iandikilwe, ‘Kaneumpaye Bwana Nnu'ngu' wako.’” ");
INSERT INTO mgw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ibilisi paibweni ampayike kwa kila ndi'la, nganneka kwa kumpelemba. ");
INSERT INTO mgw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Apo Yesu ngaki'li'bu'kya ku Galilaya ai ntwi'lya makakala ga Loo Mpeleteu na makowe gake gayu'wanike muilambo yoti ya papipi. ");
INSERT INTO mgw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naywembe aai kayi'gana mumayumba ga kunnu'ba Nnu'ngu', ngalumbilwa na bandu boti. ");
INSERT INTO mgw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bai, Yesu ngayenda ku Nasaleti, pandu paalelilwe, na lisu'ba lya Sabato kwa Ayahudi aayingi munyumba ya kunnu'ba Nnu'ngu' kati mwayabile mimu yake. Ngayi'ma li'nga asome Maandiko Mapeleteu kwa lilobe. ");
INSERT INTO mgw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngapokya kitabu sa nnondoli ywa Nnu'ngu' Isaya, ngakiumukwa na kupakolya pandu papaandikilwe, ");
INSERT INTO mgw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loo wa Bwana ai panani yangu', aniyi'mike mwene li'nga naleti aki'ba abali inannoga. Anitumike naatangasili atabilwe yu'gu'li'lwa kwabe na kimbulibuli bapate lola kai' anitumike nakombwe bababonelwa, ");
INSERT INTO mgw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","no tangasa mwaka wa Bwana wo yaliwa bandu ngu'ngu' yake.” ");
INSERT INTO mgw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Payomwi soma, ngakiwi'ki'lya si'lu' kitabu na kumpeya ntumisi, bu'kapo ngatama. Bandu boti ngabammu'nju'lya minyo. ");
INSERT INTO mgw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naywembe ngaabakia, “Liyi'gi'yo lyamuliyu'wine, li'no litimile.” ");
INSERT INTO mgw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boti baatinapusika, munomuno baatisangala kwa makowe manogau gaagalongei. Ngabalaluyana, “Ayu' ka ngamwana wa Yusupu?” ");
INSERT INTO mgw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nembe ngaabakia, “Nitangite mulu'a nibakia nnongelo gu', ‘Wa nng'anga witepwe wamwene.’ Kai' mwabaya, ‘Goti gatugayu'wine ugapangite ku'lu' ku Kapernaumu, ugapange kai' pano pakilambo sako.’” ");
INSERT INTO mgw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngapayendelya baya, “Nnondoli atanganikwali pakilambo sake. ");
INSERT INTO mgw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pi'kani, kwai na alwawa awi'li'ka baingi ku Isilaili nsimu wa Elia, kai' kwai na njala ngu'lu' munni'ma woti kwa mwanjaa aanileli ula kwa myaka itatu na nusu. ");
INSERT INTO mgw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ata nyo, Elia atumilweli kwa nnwawa nng'wi'li'kwa ywoywoti ila kwa nnwawa nng'wi'li'kwa ywa ku Salepta nni'ma wa ku Sidoni. ");
INSERT INTO mgw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kai' ku Isilaili nsimu wa Elisha kwaabile na bene matana baingi. Ata nyo, ntu'pu' nywapeleteyilwe ila Naamani mwenekaya wa ku Silia.” ");
INSERT INTO mgw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Boti babaabile mu'lu' munyumba ya kunnu'ba Nnu'ngu' pabagayu'wine galu', baatiusika muno. ");
INSERT INTO mgw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngabayi'ma na kumpikia panja ya kilambo sabe na kumpeleka panani ya kitu'mbi', li'nga bantaikuli pai' bu'ka mungeleuko. ");
INSERT INTO mgw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakini Yesu ngapi'ta pakatikati yabe no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bu'kapo Yesu ngaelya mpaka ku Kapernaumu kuwilaya ya Galilaya, ngaba kayi'gana bandu lisu'ba lya Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ngabasangala uweso wabile nawo muuyi'gani, kwa mwanjaa ayi'ganage kwa amuli. ");
INSERT INTO mgw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na mu'lu' munyumba ya kunnu'ba Nnu'ngu' kwabile na mundu ywalobi moka, aapangite lwengele lwoiba na makutu kakemelya, ");
INSERT INTO mgw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ubile na ki'li' na twenga, wenga wa Yesu wa ku Nasaleti? Buli uisi kutulangamisa? Nikutangite wenga wanyai. Wenga nga wa Mpeleteu mwene makakala ga Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ngankalipya aywo moka kabaya, “Ndu'ti! Ummu'ke mundu yu'!” Bai, aywo moka ngantu'ya pai' yu'lu' mundu na kummu'ka wangali kunsulu ata pasene. ");
INSERT INTO mgw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bandu boti ngabasangala, ngababakiana, “Ali' likowe lyayambi' mwanjaa kwa uweso na makakala ammakia moka bu'ka naywembe endabu'ka!” ");
INSERT INTO mgw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Makowe ga Yesu gatiyu'wanika muilambo yoti ya nni'ma gu'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu pabu'i mu'lu' munyumba ya kunnu'ba Nnu'ngu', ngayenda kasake Simoni. Mau' yumo nkiwe Simoni, aai na oma ngali' ngabannu'ba antepwe. ");
INSERT INTO mgw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu ngaisa no yi'ma papipi nakwe, ngaikalipya yi'lu' oma, ngayu'yu'ki'lwa. Yu'lu' mau' ngakakatuka popopo na kwatumikia. ");
INSERT INTO mgw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lisu'ba palipilyage, boti babaabile na atamwe ba matamwe mbali'mbali', baatikunnetya. Naywembe aabi'kite maboko gake panani ya kila mundu, ngaatepwa boti. ");
INSERT INTO mgw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Moka gaatikwabu'ka bandu baingi, ngagakemelya kagabaya, “Wenga nga wa Mwana wa Nnu'ngu'!” Lakini Yesu nga gakalipya wala aagayi'ki'tiyeli longela, kwa mwanjaa gaatangite panga ywembe nga Kilisitu ywabayilwe. ");
INSERT INTO mgw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ata pakusile Yesu aatibu'ka yenda pandu pakisake, kipi'nga sa bandu ngakimpala. Pabaamweni, ngabapaya kunkanikiya li'nga kaneabu'ke kasabe. ");
INSERT INTO mgw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini Yesu ngaabakia, “Nipalikwa kwaalya abali inannoga ya Ukulungwa wa Nnu'ngu' mumili'ma yi'ngi', kwa mwanjaa nitumilwe kwa go.” ");
INSERT INTO mgw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bai, aai kaala ku Yudea mumayumba ga kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lisu'ba limo, Yesu aayi'mi mbwega ya litanda liku'lu' lya Genesaleti, na bandu baingi baatikunti'li'ta no patigana kabapi'kania liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Apo Yesu ngaibona ngalaba ibi'li', mbwega ya litanda liku'lu'. Alopoli bene bai pambwega kabagu'lwa mbi'li'li' yabe. ");
INSERT INTO mgw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu ngayingya mungalaba yimo yayaabile ya Simoni, na kumpala aiekekeye mumasi' pasene kuutalu na mbwega ya litanda liku'lu'. Ngatama no yi'gana lipi'nga lya bandu ku'no abile mungalaba. ");
INSERT INTO mgw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Payomwi yi'gana ngammakia Simoni, “Uendelese ngalaba mpaka papayendekiye, na mukatumbukiye mbi'li'li' yinu li'nga mulobe omba.” ");
INSERT INTO mgw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni ngannyangwa, “Mpi'ndo, tutikeleka kilo soti loba lakini tupatikeli kili'be, ila mwanjaa ulongei wenga niyenda tumbukia.” ");
INSERT INTO mgw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pabaatumbukiye mbi'li'li' yabe, ngabaloba omba bambone, mpaka mbi'li'li' yabe kaitumbwa kutwanika. ");
INSERT INTO mgw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngabaakema ayabe ba mungalaba yi'ngi', li'nga sabaayangatiye. Ngabaisa no twi'li'ya omba ngalaba yoti ibi'li', ngaipala swika kwo topa. ");
INSERT INTO mgw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petili paagabweni go, ngakilikita nnu'ngi' ya Yesu na kummakia, “Bwana, ubu'ke nnu'ngi' yangu', kwa mwanjaa nenga namwene sambi.” ");
INSERT INTO mgw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na aine boti baatisangala pata omba banansima kati balu'. ");
INSERT INTO mgw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobi na Yoani, bana ba Zebedayo, baai alobi aine Simoni. Yesu ngammakia Simoni, “Kaneuyogope, bu'ka nambi'yambi' ulu'a loba bandu.” ");
INSERT INTO mgw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngabaleta ngalaba mbwega ya litanda liku'lu' ngabakileka kila kili'be, na kunki'ngama. ");
INSERT INTO mgw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu paabile pakilambo simo sa nni'ma wo, ngakwembana na mundu mwene matana yi'ga yoti. Mundu ywo ngagonja ukukama na kunnu'ba Yesu, “Bwana mana upendile, wendakombwa kunipeletea.” ");
INSERT INTO mgw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu, ngagoloya luboko, ngankunywa no baya, “Mbala, upeleteke!” Popopo matana gake ngagammu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu ngammakia, “Kaneummakie mundu ywoywoti, ila uyende ukailaye kwa mpi'ndo ywa dini, na ukapiye salaka kwo peleteka kwako kati mwaabaite Musa no panga kakape upeletike.” ");
INSERT INTO mgw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini makowe ga Yesu gaayendeli yu'waanika kila pandu. Ipi'nga ya bandu yaatikongolekana kumpi'kania no tepulwa matamwe gabe. ");
INSERT INTO mgw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini ywembe aayi'i pandu pakisake, no lu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lisu'ba limo Yesu kaayi'gana, Mafalisayo na balimu ba salya bu'ka kila kilambo sa ku Galilaya, ku Yudea na ku Yelusalemu baatami po. Makakala ga Bwana gabi pamope nakwe li'nga kwatepwa atamwe. ");
INSERT INTO mgw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ngabaisa bandu bampu'twile mumasela mundu ywatombolwike yi'ga. Bapalage kunnyingiya nnyumba li'nga bammi'ke nnu'ngi' ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bu'kana no yoloka kwa bandu, baakombwili kunnyingiya nnyumba, ngabaamwa bau'bu'ke pamwagala, no bu'ya iyonjo yabayipile na kumwuluya mumasela nnu'ngi' ya Yesu, ");
INSERT INTO mgw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu paabweni bai na imani ngu'lu', ngammakia aywo mundu, “Mbwiga, masambi gako usamilwe.” ");
INSERT INTO mgw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Balimu ba salya na Mafalisayo ngabailaluya, “Ayu' nyai ywalongela mayi'gi'yo ga kupulu? Ntu'pu' mundu ywakombwa samya sambi, ila Nnu'ngu' kisake!” ");
INSERT INTO mgw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu wakwipwi gabagania ngaalaluya, “Mugania ki'li' mumyoyo yinu? ");
INSERT INTO mgw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Lyaku' lyalibile liyu'yu'u muno baya, ‘Usamilwe sambi,’ au baya, ‘Yi'ma uyende’? ");
INSERT INTO mgw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bai, mbala mutange panga Mwana wa Mundu abile na amuli yo samya bandu sambi padunia.” Apo ngammakia yu'lu' mundu ywatombolwike, “Nikubakia, uyi'me utole masela gako uyende kasako.” ");
INSERT INTO mgw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bu'kapo, yu'lu' mundu ywatombolwike ngayi'ma nnu'ngi' yabe boti, ngatola saagonjelile no yenda kasake, ku'no kankwi'ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boti batisangala no gania ngabankwi'ya Nnu'ngu' kababaya, “Tugabweni makowe gayambi' li'no.” ");
INSERT INTO mgw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bu'ka pa go, Yesu aapitike panja, ngammona nnonga koli yumo ywakemelwage Lawi, atami palyengo lyake. Yesu ngammakia, “Uniki'ngame.” ");
INSERT INTO mgw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naywembe ngagaleka goti nganki'ngama. ");
INSERT INTO mgw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi aampangi Yesu si'li'ku'si'li'ku' ngu'lu' kasake. Na lipi'nga liku'lu' lya alonga koli na bandu baingi babaabile po, baatami nabo pamope. ");
INSERT INTO mgw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo na balimu ba salya, baaku'ku'li'ki banamasi' bake kababaya, “Kwa ki'li' mulya no nywa pamope na alonga koli na bene sambi?” ");
INSERT INTO mgw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ngaayangwa, “Akoti bampalali nng'anga, babampala nng'anga balu' bababile atamwe. ");
INSERT INTO mgw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Niisili kwakema bandu anogau ila bene sambi li'nga bammuyangani Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bandu bi'ngi' ngabammakia, “Banamasi' ba Yoani Ywabatisage bakokotyage punga no lu'ba, ata apwasi ba Mafalisayo bapanga nyinyonyo. Lakini banamasi' bako bendalya no nywa.” ");
INSERT INTO mgw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu ngayangwa, “Balu' babakokilwe kulisengele bapalikwa punga ku'no mwene lisengele babile nakwe pamope? Lili! ");
INSERT INTO mgw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini nsimu walu'a isa, wobu'yi'lwa mwene lisengele kasabe, na nsimu wo, ngabaalu'a punga.” ");
INSERT INTO mgw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu ngaabakia lukongo lu'no, “Bandu bapapwali kibamba sa ngu'bo yayambi' na kukibi'ka mungu'bo ngonaa. Mana bapangite nyo, ngu'bo yo yanogelyali. Kai', yapanga bapapwi ngu'bo yayambi'. ");
INSERT INTO mgw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kai' bandu bayi'yali kinywo sa njabibu yayambi' mumapondo maumala, kwa mwanjaa aso kinywo sayambi' salu'a kanja mapondo go, kinywo salu'a yitanika na, mapondo gaalabika. ");
INSERT INTO mgw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kinywo sa njabibu yayambi', kiyi'yi'lwa mumapondo gayambi'. ");
INSERT INTO mgw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ntu'pu' mundu ywaminyikia nywa kinywo sa njabibu yayambi' bu'ka po nywa kinywo sa njabibu ngona, maana ibayilwa yi'lu' ngona nga inannoga muno.” ");
INSERT INTO mgw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lisu'ba limo lya Sabato ya Ayahudi Yesu paabile kapi'ta mumigunda ya ngano, banamasi' bake baatumbwi ti'kwana no ting'anda yeyo ya ngano li'nga balye nombo yake. ");
INSERT INTO mgw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo baingi ngabaalaluya, “Mboni mupanga makowe gagakanilwa na salya kulisu'ba lya Sabato?” ");
INSERT INTO mgw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu ngaayangwa, “Munasomali mwaapangite Daudi na aine pabaabile na njala? ");
INSERT INTO mgw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ywembe aayingi mu Nyumba ya Nnu'ngu', no tola galu' makati gagabi'kilwe nnu'ngi' ya Nnu'ngu', lya na kwapeya aine. Yatikanilwa mundu lya makati galu' ila api'ndo ba dini bai.” ");
INSERT INTO mgw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Apo ngaabakia, “Mwana wa Mundu nga Bwana wa Sabato.” ");
INSERT INTO mgw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lisu'ba li'ngi' lya Sabato ya Ayahudi, Yesu aayingi munyumba ya kunnu'ba Nnu'ngu' no yi'gana. Mu'lu', mwaabile na mundu ywalemile luboko lwa mmalyo. ");
INSERT INTO mgw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Balimu ba salya na Mafalisayo bapalage kitumbu sakunsitakya Yesu, kwa nyo baatikumpekeseni bannole mana alu'a kuntepwa mundu lisu'ba lya Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini Yesu aatangite mwabaganiage, ngammakia yu'lu' mwene luboko lutomboloka, “Kakatuka, uyi'me pakatikati yabe.” Ngayenda no yi'ma. ");
INSERT INTO mgw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu ngaabakia, “Ninnaluya mwenga, lisu'ba lya Sabato ya Ayahudi nantali panga makowe manogau au ganannyata, tepwa au bulaga?” ");
INSERT INTO mgw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Paaloi boti bababile palu' ngammakia yu'lu' mundu, “Goloya luboko lwako.” Naywembe paapangite nyo, luboko lwake lwapangite lukoti kai'. ");
INSERT INTO mgw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini bembe baatiusika muno ngabalaluyana, lyakau lyaku' lyakumpangya Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lisu'ba limo Yesu aayi'i lu'ba Nnu'ngu' kukitu'mbi', aakelike sekesekembe. ");
INSERT INTO mgw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pamalau' ngaakema banamasi' bake, na nkati yabe ngabawa bandu ku'mi na abi'li' abo ngaakema atumilwe, ");
INSERT INTO mgw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni (ywaatinilwe na Yesu lina lya Petili) na Andelea nnunawe, Yakobi na Yoani, Pilipi na Batolomayo, ");
INSERT INTO mgw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matei, Tomasi, Yakobi wa Alufayo na Simoni wa kipi'nga sa Mazeloti, ");
INSERT INTO mgw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda ywa Yakobi, na Yuda Isikalioti ywaansongi Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu aalongwaniye na banamasi' bake kaelya bu'ka kukitu'mbi', aayi'mi pandu pankanya. Apo pai na lipi'nga liku'lu' lya banamasi' bake na bandu baingi bababu'i lwingo lwoti lwa Yudea, Yelusalemu, kumbwani ya Tilo na Sidoni. Boti baisi kumpi'kania Yesu no tepulwa matamwe gabe. ");
INSERT INTO mgw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aatepwi boti, kai' aatepwi na babaauyilwage na moka. ");
INSERT INTO mgw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bandu boti bapalage bankunywe, kwa mwanjaa nkati yake gapitage makakala ga kwatepwa boti. ");
INSERT INTO mgw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ngaagalambukya banamasi' bake ngabaya, “Nantali mwenga mwamile mwaki'ba, kwa mwanjaa Ukulungwa wa Nnu'ngu' winu. ");
INSERT INTO mgw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nantali mwenga mwamuminya njala nambi'yambi', kwa mwanjaa mwalu'a yukuta. Nantali mwenga mwamuli'la nambi'yambi', kwa mwanjaa mwalu'a eka. ");
INSERT INTO mgw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nantali mwenga mwamusukilwa na bandu, mwamubaulwa, mwamui'mbu'lwa, no linyatia lina linu kwa mwanjaa ya Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pagaapita ago goti mwanapusike no u'mbau'mba, kwa mwanjaa upo yinu ngu'lu' ibile kunani. Kwa mwanjaa api'ndo babe baapangile alondoli ba Nnu'ngu' nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini mwakibona mwenga mwamatayili, kwa mwanjaa mupatike upo yinu. ");
INSERT INTO mgw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mwakibona mwenga mwamuyukuta nambi'yambi', kwa mwanjaa mwalu'a minya njala palu'ngi'. Mwakibona mwenga mwamweka kwo napusika nambi'yambi', kwa mwanjaa mwalu'a li'la no lombola. ");
INSERT INTO mgw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mwakibona mwenga mwamulumbilwa na bandu boti, kwa mwanjaa api'ndo babe baapangi alondoli ba ubu'su' nyinyonyo.” ");
INSERT INTO mgw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lakini nimmakianga mwenga mwamunipi'kania, mwapende andumu binu, na mwapangi manogau babansukwanga. ");
INSERT INTO mgw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwalu'bi makowe manogau balu' babannosa na mwalu'bi balu' babampangya ulau. ");
INSERT INTO mgw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mundu mana akuku'mbwi ligomo limo ung'alambukiye na linebi'li'. Mundu mana akupokonywi likoti lyako unneki na kiyampani sako. ");
INSERT INTO mgw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ywoywoti ywakulu'ba wampei na mundu mana akupokonywi kili'be sako kaneunnonge kukuki'li'bu'ki'ya. ");
INSERT INTO mgw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mwamupala bandu bampangi mwenga, nabembe mwapangi nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mana mwaalu'a kwapenda babampendile, mwenga mwalu'a pata upo yaku'? Ntu'pu', kwa mwanjaa ata bene sambi baapenda babaapendile. ");
INSERT INTO mgw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kai' mana mwapangi manogau balu' babampangi manogau, mwalu'a pata upo yaku'? Kwa mwanjaa ata bene sambi bapanga gogogo. ");
INSERT INTO mgw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na mana kamwapeya ngu'ta balu' bamwu'bi'lya kunni'pya, mwapata upo yaku'? Kwa mwanjaa ata bene sambi baapeya ayabe li'nga baki'li'bu'ki'yi'lwe si'si'lu'si'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ila mwenga mwapende andumu binu na kwapangya manogau, mwapei ngu'ta wangau'bi'lya ki'li'bu'ki'yi'lwa na upo yinu yapanga ngu'lu', namwe mwapanga mwabana ba Nnu'ngu' ywa kunani. Kwa mwanjaa ywembe nnogau kwa kingasukulu na bababile alau. ");
INSERT INTO mgw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mube na kiya kati Tati' binu mwababile na kiya. ");
INSERT INTO mgw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kanemwaukumu bi'ngi', na mwenga mwaukumilwali na Nnu'ngu'. Kanemwabi'ki bi'ngi' lukoolo, namwenga mwabi'ki'lwali lukoolo na Nnu'ngu'. Mwasami bi'ngi', namwenga mwasamilwa na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwapei bandu ili'be yabapala na mwenga Nnu'ngu' ampeya, mwapokya kili'ngo satwi'la no indilya, tikyatikya ika no yitanika. Kwa mwanjaa kili'ngo sososo samwaali'ngya, nga samwaali'ngi'lwa na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ngaabakia lukongo, “Mbulibuli endakombwa kunnongoya ndi'la mbulibuli nnyine? Lili, boti abi'li' baalu'a tumbukya mulyi'mbwa. ");
INSERT INTO mgw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanamasi' ampi'tali mwalimu wake, lakini mwanamasi' ywayitagile ngaywaba kati mwalimu wake. ");
INSERT INTO mgw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mwanjaa buli ukibona kielenje muliyo lya nnyino na lubago lwa muliyo lyako ulubonali? ");
INSERT INTO mgw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Au ukombwabuli kummakia nnyino, ‘Nnyangu', nileka nikubu'ye kielenje sakibile muliyo lyako’, na wamwene lubile lubago muliyo lyako? Wammu'su'bu'su', ulubu'ye wi'ti' lubago lwa muliyo lyako, ngaummu'ye nnyino. ");
INSERT INTO mgw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nkongo unannoga upambikali itunda inannyata wala nkongo unannyata upambikali itunda inannoga. ");
INSERT INTO mgw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bandu bautanga nkongo bu'kana na itunda yake, itanganikwe panga, bandu batu'mbwali tini wala njabibu mumimimwa. ");
INSERT INTO mgw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu nnogau apiya manogau gagabile mumwoyo wake, na mundu nnau apiya malau gagabile mumwoyo wake. Kwa nyo, nkano wa mundu ulongela gagabile mumwoyo wake. ");
INSERT INTO mgw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kwa mwanjaa buli munikema, ‘Bwana, Bwana,’ ku'no kamukana panga ganimmakianga? ");
INSERT INTO mgw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nilu'a kumpeyanga lukongo lu'no lwa mundu ywaisa kasangu' kugayu'wa makowe gangu' na kugapanga. ");
INSERT INTO mgw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aywo alandana na mundu ywasenga nyumba kwo i'mbi'ya mpaka mumpi'mbi' ngaupita nkukulo wa libi'ndi' pawiku'mbwi nyumba yo lakini isengwanikeli, kwa mwanjaa yaasengilwe ngangamau. ");
INSERT INTO mgw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini ywoywoti ywagayu'wa makowe gangu' kakotoka kugapanga, aywo alandana na mundu ywasengite nyumba pangali i'mbi'ya. Pawisi nkukulo ayo nyumba ngaiyiluka no sengwanika.” ");
INSERT INTO mgw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Payomwi longela gaabini kwabakia bandu, Yesu aayi'i ku Kapernaumu. ");
INSERT INTO mgw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akwo kwaai na mpi'ndo yumo ywa yesi ywembe mpangakasi wake ywampendile, endeminya na kiwo sendekumwegelelya. ");
INSERT INTO mgw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yu'lu' mpi'ndo ywa yesi paayu'wine makowe ga Yesu, ngatuma agoi nsi'si' ba Kiyahudi, bakannu'be Yesu li'nga santepwe mpangakasi wake. ");
INSERT INTO mgw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pabaikite kwa Yesu, baatikumpembelelya kababaya, “Ili'ngani mundu yu' umpangi likowe li'. ");
INSERT INTO mgw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwa kitumbu ywembe aaupendi muno nni'ma witu na ngaywatusengi yi'lu' nyumba ya kunnu'ba Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bai, kabayenda, baalongwaniye na Yesu. Pabaabile kabaegelya panyumba ya mpi'ndo ywa yesi, yu'lu' ngatuma mambwigalye bakammakie Yesu, “Bwana, kanewisuluye muno, kwa mwanjaa nenga ili'nganili wenga yingya munyumba yangu'. ");
INSERT INTO mgw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kwa nyo, nga kitumbu sanikotwike isa kwaubile, naibweni nili'nganili. Ila ulongele bai likowe, na mpangakasi wangu' alu'a lama. ");
INSERT INTO mgw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nanenga nibi pai' ya utawala nyonyonyo, na nibile na banayesi pai' yangu'. Nimmakia yumo, ‘Yenda,’ ywembe endayenda, nimmakia ywi'ngi' ‘Isa!’ nembe endaisa, na mpangakasi wangu' ‘Panga kikowe si'!’ nembe endapanga.” ");
INSERT INTO mgw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu payu'wine go, aatisangala, aakigalambuki si'lu' kipi'nga sa bandu sakimmi'ngi'yage, ngabaya, “Nammonali mundu mwene imani ngu'lu' kati yi' mu Isilaili yoti!” ");
INSERT INTO mgw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Balu' bandu babaatumilwe kwa Yesu pabaabukiye kasake yu'lu' mpi'ndo, bankoli yu'lu' mpangakasi ayu'yu'kilwe. ");
INSERT INTO mgw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bu'kapo, Yesu ngayenda kukilambo sa Naini, aalongwaniye na banamasi' bake, na lipi'nga lya bandu babammi'ngi'yage. ");
INSERT INTO mgw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bai, paegeli pa niango wo yingya pakilambo so, baapitike bandu babapu'twi ntwi wa nnalu'me yumo ywabelekwi kisake kwa nnwawa ywawi'like na nsengowe. Bandu baingi ba kilambo so, baabile pamope na mau' ywo. ");
INSERT INTO mgw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bwana Yesu paamweni mau' ywo, aammi'ki kiya, ngammakia, “Kaneuli'le.” ");
INSERT INTO mgw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bu'kapo, ngayenda kugakunywa galu' masela na balu' babaapu'twile baatiyi'ma, ngabaya, “Wamunsembe, Nikuamulisa uyumuke!” ");
INSERT INTO mgw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yu'lu' nnalu'me ywawile ngakatuka tama utama, no tumbwa longela. Yesu ngankamukiya kwa mau' bake. ");
INSERT INTO mgw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bandu boti baatiyogopa na kunnumba Nnu'ngu' kababaya, “Nnondoli nku'lu' ywa Nnu'ngu' apitike mulukolo lwitu. Nnu'ngu' aisi kwakombwa bandu bake.” ");
INSERT INTO mgw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Makowe gake go gaatiyu'wanika kwoti akwo Yudea na ilambo ya papipi. ");
INSERT INTO mgw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Banamasi' ba Yoani baayi'i kummakia Yoani makowe ago goti. Nembe Yoani payomwi kwakema banamasi' bake abi'li' bu'ka kwa boti, ");
INSERT INTO mgw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aatumike kwa Bwana, bakannaluye, “Wenga nga yu'lu' ywaisa, au tunni'nde ywi'ngi'?” ");
INSERT INTO mgw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Balu' banamasi' pabaaikite kwa Yesu, baatikummakia, “Yoani Ywabatisage atutumike kasako tukulaluye, ‘Wenga wa yu'lu' ywaisa, au tunni'nde ywi'ngi'?’” ");
INSERT INTO mgw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Palu' pabannaluyage Yesu aai mulyengo lya kwatepwa bandu baingi balu' babalumyage kwa matamwe, na babaayingililwe na moka na kwapanga atu'lu'ka minyo baingi balole. ");
INSERT INTO mgw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bai, Yesu ngayangwa, “Muyende mukammakie Yoani galu' gamugabweni kwa minyo ginu na kugayu'wa. Atu'lu'ka minyo bendalola, itewe bendayenda, bene matana bendapeleteyelwa, aibamakutu bendayu'wa, awi'li bendayu'ka, na aki'ba baalilwa abali inannoga. ");
INSERT INTO mgw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nantali mundu yu'lu' ywakotwike ba na kyukala nanenga.” ");
INSERT INTO mgw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Apo pababu'i balu' baatumike Yoani, Yesu aatumbwi kulibakia lipi'nga lya bandu abali ya Yoani, “Mwayi'i linga namani ku'lu' kulupu'ngu'ti'? Buli, mupalage kugabona mambu'ngi'li'i kagapu'ngi'la na nsunga? ");
INSERT INTO mgw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mana nyinyo lili, mwayi'i linga namani? Mwayi'i kunnola mundu ywaweti magu'bo gene bei? Babawala magu'bo gene bei no tama kwa maisa ga kitayili batama mu mayumba ga akulungwa! ");
INSERT INTO mgw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bai, munibakie, mwayi'i linga namani, mwayi'i kunnola nnondoli ywa Nnu'ngu'? Eloo, kai' kumpi'ta nnondoli ywa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ayu' Yoani ngaywabayilwa mu Maandiko Mapeleteu, ‘Lola, nenga nintuma mpangakasi wangu' akulongoli, aywo alu'a kupetulya ndi'la yako.’” ");
INSERT INTO mgw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu aayomwi kwo baya, “Nimmakia, kati ya bandu boti babatami panni'ma, ntu'pu' ywabile nku'lu' muno kumpi'ta Yoani Ywabatisage. Ata nyo, yu'lu' ywabile nsene muno mu Ukulungwa wa Nnu'ngu' nga nku'lu' kulikoni ywembe.” ");
INSERT INTO mgw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bandu boti pamope na alonga koli pabagayu'wine go, baaulumbite unnogau wa Nnu'ngu'. Abo nga balu' babaupoki ubatiso wa Yoani. ");
INSERT INTO mgw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Mafalisayo na balimu ba salya baakani panga mwapendi Nnu'ngu', kwa kuukana ubatiso wa Yoani wawaisi kwabe bembe. ");
INSERT INTO mgw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ngaalaluya, “Bandu ba mmelekwo wu', nalandaniye na kili'be gani? Bandu ba uyi'me gani? ");
INSERT INTO mgw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Landana kwabe kati bana babatamaga palisoko, kababakiana kipi'nga simo na si'ngi', ‘Tumwonekiye ngoma, namwenga mwinikeli! Tunnyi'mbi myambo ya ili'lo lakini muli'ili!’ ");
INSERT INTO mgw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Kwa mwanjaa Yoani paisile, nembe endage punga na anywageli wi'mbi', namwenga mwabaite, ‘Ayingililwe na moka!’ ");
INSERT INTO mgw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nembe Mwana wa Mundu aisi kaalya no nywa, na mwenga mubaya, ‘Munninge ayu' mundu mila no lobya, mbwiga wa alonga koli na bene sambi!’ ");
INSERT INTO mgw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ata nyo, ikima ya Nnu'ngu' ikong'ondeli panga inannoga kwa balu' boti babaiyi'ki'tya.” ");
INSERT INTO mgw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo yumo ankemite Yesu akalye kilyo kasake. Ngayingya nnyumba ya ywo Mfalisayo, aatitama no lya. ");
INSERT INTO mgw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bai, pakilambo si'lu' kwai na nnwawa yumo mwene sambi. Paayu'wine panga, Yesu abile nnyumba ya ywo Mfalisayo, aapu'twi supa ya liwe yene mauta ganannungya. ");
INSERT INTO mgw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Atiisa ngayi'ma papipi na magu'lu' ga Yesu, ku'no kali'la, na moli gake gaatu'mbu'ki mumagu'lu' ga Yesu. Aywo nnwawa aagaponwi magu'lu' ga Yesu kwa nywili yake ndaso. Payomwi kumponwa, aaganoni galu' magu'lu', na kugapakaya mauta ganannungya. ");
INSERT INTO mgw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yu'lu' Mfalisayo ywankokite Yesu paagabweni go, aganiyite pamwoyo wake, “Kenda mundu yu' akapanga nnondoli wa Nnu'ngu', alu'e tanga panga, ayu' nnwawa ywankunywa mwene sambi.” ");
INSERT INTO mgw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ngammakia ywo Mfalisayo, “Simoni, nibile na kikowe sa kukubakia.” Nembe Simoni ngammakia, “Nendakupi'kania Mwalimu, baya.” Yesu ngabaya, ");
INSERT INTO mgw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Bandu abi'li' bankopite mundu mbanje, yumo aakopite dinali mya tano, na ywi'ngi' amusini. ");
INSERT INTO mgw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wabasindwi li'pa maleni gabe, aywo mundu aatikwasamya boti abi'li'. Tumbwe, ywaku' kati ya bo bandu abi'li' ywalu'a kumpenda muno yu'lu' bwana?” ");
INSERT INTO mgw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni aatiyangwa, “Apo, niibona ywasamilwe leni liku'lu', ngaywaalu'a kumpenda muno yu'lu' bwana.” Yesu ngammakia, “Kakape.” ");
INSERT INTO mgw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kai' nganng'alambukya yu'lu' nnwawa na kummakia Simoni, “Wendakummona ayu' nnwawa? Nenga paniyingi pano panyumba yako, unipeili masi' go uluwa mumagu'lu' gangu', lakini nnwawa yu' anigu'lwi' magu'lu' gangu' kwa moli gake na kuniponwa kwa nywili yake. ");
INSERT INTO mgw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wenga unipangiteli abali kwa kuninonia, lakini ayu' nnwawa, bu'ka paniyingi pano, ywembe aganoniage magu'lu' gangu'. ");
INSERT INTO mgw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wenga unilayiteli unoga mwoyo wako kwa kunipakaya mauta muntwe, lakini ayu' nnwawa apangite nyo kwa kunipakaya mauta mumagu'lu' gangu'. ");
INSERT INTO mgw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kwa nyo nendakubakia, asamilwe masambi gake maingi kwa mwanjaa alayite unogau wake nku'lu'. Ywasamilwe kisene apenda pasene,” ");
INSERT INTO mgw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bai, Yesu ngammakia yu'lu' nnwawa, “Usamilwe masambi gako.” ");
INSERT INTO mgw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Apo nga balu' babaabi pamope nakwe pamesa, ngabalaluyana, “Ayu' mundu gani, ywakombwa samya sambi?” ");
INSERT INTO mgw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nembe Yesu ngammakia yu'lu' nnwawa, “Imani yako ikukosopolile, uyende kwa amani.” ");
INSERT INTO mgw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bu'kapo, Yesu api'ti mumisengo miku'lu'miku'lu' na misenemisene, kaala abali inannoga ya Ukulungwa wa Nnu'ngu'. Balu' banamasi' ku'mi na abi'li' bai pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kai', kwaai na alwawa balu' baabi'ngite Yesu moka na kwa tepwa matamwe. Nabembe baalekangineli nakwe, maina gabe Malia (ywakemelwage Makatalena), ywembe aabi'ngilwe mitumbi saba ya moka, ");
INSERT INTO mgw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana nnyumbo wa Kusa ywaabi mpangakasi nku'lu' ywa Helode, Susana na bi'ngi' baingi. Abo alwawa, batumyage mali yabe bene kwatumikiya bembe. ");
INSERT INTO mgw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lisu'ba limo lipi'nga lya bandu lyatemesekana, na bandu bamwisilyage Yesu bu'ka kila kilambo. Nembe aabakie lukongo lu'no. ");
INSERT INTO mgw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mpandi aayi'i misa mbeyu yake, paamisage mbeyu yo, yi'ngi' yaatu'mbu'ki mundi'la, yali'batilwe na api'ta ndi'la no sonyolwa na iyuni. ");
INSERT INTO mgw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yi'ngi' yatu'mbu'ki pa maliwe, na paibalike, yaatiyu'ma kwo oba masi'. ");
INSERT INTO mgw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yi'ngi' yaatu'mbu'ki pakatikati ya kiwi'mbi', yi'lu' ya pakiwi'mbi' paibalike, yaatolilwe kikolo. ");
INSERT INTO mgw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yi'ngi' yatu'mbu'ki muukando unannoga, yabalike, no pambika mbeyu mya kwa kila lupeyu lumo.” Payomwi longela go, ngau'bu'ya lilobe, kabaya, “Mwene makutu go yu'wa, na ayu'we!” ");
INSERT INTO mgw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Banamasi' bake Yesu ngabannaluya, “Lukongo lu' lulombolya namani?” ");
INSERT INTO mgw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nembe ngayangwa, “Mwenga muyaliwite tanga iyo ya Ukulungwa wa Nnu'ngu', lakini abo bi'ngi' lili, ila abo babakiyilwa kwa ngongo li'nga batange panga, galu' gagaandikilwe mulilagano lya kwai'mbu' gendatimya, ‘Mana kabalola, kanebakibone sabakilolase, na mana kabayu'wa, kanebatange sabakiyu'wase.’ ");
INSERT INTO mgw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bai, kikomekeyo sa lukongo lu'no nga si'no, mbeyu yaibayilwa pano nga liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yi'lu' yaitu'mbu'ki mundi'la, ilaya bandu balu' babapi'kania liyi'gi'yo lya Nnu'ngu' kai' yu'lu' ndumu endaisa na kulibu'ya mumyoyo yabe baakane u'bi'lya no kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yi'lu' yaitu'mbu'ki pamaliwe mana ibalike ntu'pu' poyingya ngi'ga, apo ilandana na bandu balu' babaliu'bi'lya liyi'gi'yo lya Nnu'ngu' kwo napusika na pabapayilwa pasene, bakoloka mwoyo. ");
INSERT INTO mgw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yi'lu' yaitu'mbu'ki pakiwi'mbi', ilandana na bandu balu' babapi'kania li'lu' liyi'gi'yo lya Nnu'ngu', lakini mana babu'i basuluyilwa na kyukala, utayili na matamanio ga yi'ga, abo bapambikali itunda no komala. ");
INSERT INTO mgw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na yi'lu' yaitu'mbu'ki mu ukando wa mbolya, nga bandu balu' babaliyu'wa li'lu' liyi'gi'yo lya Nnu'ngu' bendaligania, na kulibi'ka mu mwoyo unannoga na kuliisimu. Abo, bendakomeya mpaka bapiye itunda. ");
INSERT INTO mgw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Bandu bakoyali kimuli na kukiwi'ki'lya mukibi'ga, au mmu'ngu'. Lakini bakibi'ka patu'ndu'bau li'nga bandu balole bweya. ");
INSERT INTO mgw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sosoti sakiiyilwe saiyanikwali, na makowe ga iyo yoyoti yaiyanikwali na yabonekana paminyo ga bandu. ");
INSERT INTO mgw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwa nyo mwili'ndi'le kwa go gamugayu'wa, kwa mwanjaa ywabile na kili'be alu'a yongeyelwa, lakini ywangali kili'be ata si'lu' kisene sabile naso saatolelwa.” ");
INSERT INTO mgw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mau' na akina nnunabe, baamwisili Yesu, lakini bakombwili kumwegelya kwa mwanjaa kipi'nga sa bandu. ");
INSERT INTO mgw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yesu aapeyilwe abali, “Mau' bako na akina nnunabo bai panja, bapala kukubona.” ");
INSERT INTO mgw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lakini Yesu aabakie bandu boti, “Mau' na akina nnunangu', balu' babapi'kania lilobe lya Nnu'ngu' na kulikamwa.” ");
INSERT INTO mgw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lisu'ba limo Yesu na banamasi' bake bau'bwike mu ngalaba na ngaabakia, “Tuloke litanda tuyende mpaka kwiyi'.” Bai, ngabatumbwa mwanja. ");
INSERT INTO mgw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pabaabile mu ngalaba, Yesu lwampatike lugono, ngagonja. Nsunga nkali' na masi' gaatiyu'gayu'ga no yingya nkati ya ngalaba, apo baakibweni kiwo kakiegelya. ");
INSERT INTO mgw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Balu' banamasi' bannyendeli Yesu na kunnyumuya kababaya, “Mpi'ndo, mpi'ndo! Twenda waa!” Yesu ngayumuka na kuukalipya nsunga nkali' no yu'gayu'ga kwa masi', nawembe ngauyi'ma no tama liki. ");
INSERT INTO mgw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bu'kapo ngaabakia, “U'bi'lya kwinu kubi kwaku'?” Lakini bembe baatisangala no yogopa ku'no kababakiana, “Ayu' nga mundu gani, ywakalipya nsunga no yu'gayu'ga kwa masi' nayembe yendakunnyu'wa?” ");
INSERT INTO mgw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Baayendeli na mwanja mpaka kumbwani ya nni'ma wa Agelasi, waulolangana na Galilaya kwiyi' ya litanda. ");
INSERT INTO mgw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Paulukage kumbwani, mundu yumo ywalobi moka amwisili bu'ka kukilambo. Bu'ka myaka yambone mundu ywo atamage wausu bai na atamage kuulema. ");
INSERT INTO mgw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pamweni Yesu, aitu'yike pai' nnu'ngi' yake, no kemelya kwa lilobe liku'lu' kabaya, “Wenga wa Yesu wa Mwana wa Nnu'ngu' Nku'lu', ubile na kitumbu gani nanenga? Nendakulu'ba, sondesonde kaneunilumiye!” ");
INSERT INTO mgw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alongei nyo kwa mwanjaa Yesu agakalipi go moka gabu'ke kwa mundu ywo. Ago moka gakoyage kunnyingilya mundu ywo, pamope no panga bandu bammi'i nnyumba na kuntaba kwa nyololo na pingwi mumagu'lu' na mumoko. Kila pabantaba ipungo yo, endekwiti'kwana no butukya kulupu'ngu'ti' kwa makakala ga aywo moka. ");
INSERT INTO mgw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bai, Yesu ngannaluya, “Lina lyako wanyai?” Ywembe ngayangwa, “Lina lyangu' na Yesi,” kwa mwanjaa ganiyingi moka maingi. ");
INSERT INTO mgw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ago moka ngagannu'ba panga kaneagamulise yenda kulyi'mbwa liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pandu po kwabile na kipi'nga kiku'lu' sa magu'be kagali'lya pakitu'mbi'. Bai, balu' moka ngabannu'ba kai', aayi'ki'tiye bakaayingi balu' magu'be. Nembe Yesu ngaayi'ki'ti'a. ");
INSERT INTO mgw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kwa nyo, galu' moka gaatikummu'ka yu'lu' mundu na kwayingya balu' magu'be, nabembe baimbiliti pa linyenji no tumbukya mulitanda, masi' ngagaabulaga. ");
INSERT INTO mgw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Balu' asungi pabagabweni goti gagaapitile, baatitila no yenda kwayaulya bandu makowe go, mukilambo na mumigunda. ");
INSERT INTO mgw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bandu ngabaisa lola gagapitike. Pabaikite paabile Yesu, baamweni yu'lu' mundu ywagammu'i moka atami papipi na Yesu, aweti ngu'bo na malango gake gabuyangine, ngabayogopa. ");
INSERT INTO mgw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Balu' bandu babalibweni likowe lyo, kalipangika paminyo gabe, baayi'i kwabakia ayabe gabagabweni kwa yu'lu' mundu mwaatepulilwe. ");
INSERT INTO mgw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bandu boti ba nni'ma wa Gelasi, baatiyogopa kwa nyo, bannu'bike Yesu abu'ke. Yesu ngau'bu'ka mungalaba no bu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yu'lu' mundu ywabu'yilwe moka, aannu'bite balongwane lakini Yesu aatikunkania ngammakia, ");
INSERT INTO mgw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ubuyangani kasako, ukabaye makowe goti gaakupangi Nnu'ngu'.” Bai, yu'lu' mundu ngayenda kasake kapi'ta ku'no kaala kila pandu mukilambo si'lu' makowe goti gapangilwe na Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu pabuyangani kwiyi' ya litanda, kipi'nga sa bandu satikunkemya kwa mwanjaa boti bendekunni'nda. ");
INSERT INTO mgw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Apo ngaisa mundu yumo ywakemelwage Yailo, mpi'ndo ywa nyumba ya kunnu'ba Nnu'ngu'. Aitaikuli pamagu'lu' ga Yesu na kunnu'ba ayende kasake. ");
INSERT INTO mgw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kwa mwanjaa mwi'nja wake ywabelekwi kisake, ywa myaka ku'mi na ibi'li' endekomya. Yesu paayendage, bandu bendekuntwi'li'lya na kunkunywa ku'no na ku'no. ");
INSERT INTO mgw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bai, kwai na nnwawa yumo pakatikati ya si'lu' kipi'nga sa bandu, ywembe abi na utamwe wa nkongomokwa kwa myaka ku'mi naibi'li'. Pamope no panga aayomwi ili'be yake yoti kwapelekya aganga, ntu'pu' ywaakombwi kuntepwa. ");
INSERT INTO mgw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aywo nnwawa aammi'ngi'yite Yesu nsu'gu', ngapakunywa mpindo wa nganju yake. Pakunywile, popopo utamwe wake waatikummu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu ngalaluya, “Aywo nyai ywanikunywile?” Boti ngababaya panga, ntu'pu' mundu ywakukunywile. Nembe Petili ngabaya, “Mpi'ndo, kipi'nga sa bandu kitekuti'li'ta no kukutwi'li'lya.” ");
INSERT INTO mgw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu ngabaya, “Kubi na mundu ywanikunywile, mwanjaa nigabweni makakala kaganibu'ka.” ");
INSERT INTO mgw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yu'lu' nnwawa waibweni panga akombwali iya, ngapapitya nnu'ngi' ya Yesu ku'no kalendema kwo yogopa, ngaitu'ya pai, Yesu kannola. Apo, ngalongela nnu'ngi' ya bandu boti kitumbu sa kunkunywa Yesu na kitumbu sapatike tepulwa. ");
INSERT INTO mgw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu ammakie panga, “Biti, kwo u'bi'lya kwako uponi, uyende kwa amani.” ");
INSERT INTO mgw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Paabile balo kalongela, Yailo aaletilwe abali bu'ka kaya, “Mwi'nja wako awile, sakunsulukia muno Mwalimu saku'.” ");
INSERT INTO mgw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu pagayu'wine go, ngammakia Yailo, “Kaneuyogope, we wu'bi'li bai alu'a tepulwa.” ");
INSERT INTO mgw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu paikite kasake Yailo, annyi'ki'tiyeli mundu yingya nnyumba pamope nakwe, ila aayingi na Petili, Yoani, Yakobi na abelei ba aywo mwi'nja. ");
INSERT INTO mgw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bandu boti baabile kabali'la no lombola mwakipitike kiwo sake. Yesu ngaabakia, “kanemuli'le, mwana atigonja bai, anawaali!” ");
INSERT INTO mgw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bandu ngabamweka kwa kunsalawa panga atangiteli kiwo, mwanjaa bembe baatangite awile. ");
INSERT INTO mgw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lakini Yesu ankamwi luboko na kummakia, “We mwana, yumuka!” ");
INSERT INTO mgw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bwu'mi wake ngaubuyangana, no yumuka. Yesu ngaabakia, bampei kilyo. ");
INSERT INTO mgw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abelei bake batisangala kummona mwu'mi, lakini Yesu ngaaking'indya panga, kanebammakie mundu ywoywoti aga gagapangilwe. ");
INSERT INTO mgw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu aakemite balu' ku'mi na abi'li' na kwapeya uweso wo bi'nga moka na kwatepwa atamwe. ");
INSERT INTO mgw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kai', ngatuma bakaale Ukulungwa wa Nnu'ngu' na kwatepwa atamwe. ");
INSERT INTO mgw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aalagi, “Pamuyabwa mwanja kanemupu'twe kikowe sosoti, kanemupu'twe lukongoso wala nsaku, wala masulupu, wala mbanje wala kanemwapu'twe ata nganju yo bi'kiya. ");
INSERT INTO mgw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pansengo wowoti wabankemya no yingya, mwatame po mpaka pamwabu'ka pa kilambo so. ");
INSERT INTO mgw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bandu mana bakani kunkemya, mubu'ke pakilambo so no paapata ata litikwili lyalinamati mumagu'lu' ginu. Awo wapanga kati mwanju wa lukilo lwabe.” ");
INSERT INTO mgw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bai, baatumbwi mwanja bapi'ti muilambo kabaala abali inannoga na kwatepwa atamwe kila pandu. ");
INSERT INTO mgw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kwa nyo ntawala Helode aapatike abali ya makowe goti gagaapangike aatangiteli mwanjaa babayage, “Yoani Ywabatisage ayu'kite bu'ka kuuwi'li!” ");
INSERT INTO mgw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bi'ngi' babayage panga Elia apitike, bi'ngi' babayage kwaali' nnondoli ywa Nnu'ngu' yumo ywa kwai'mbu' ateyu'ka. ");
INSERT INTO mgw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lakini Helode ngagania, “Yoani natikumwi'sa, tumbwe aywo nyai ywaniyu'wa makowe gake?” Apalage kummona mundu ywo. ");
INSERT INTO mgw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bai, balu' atumilwe bake pababuyangine, bammakie Yesu makowe goti gabaapangite. Yesu ngabu'ka nabo, kuu'lu' mpaka kukilambo sa Betisaila. ");
INSERT INTO mgw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini ipi'nga ya bandu paikwipwi kwayi'i, baatikummi'ngi'ya. Yesu ngaakemya no longela nabo makowe ga Ukulungwa wa Nnu'ngu', aatepwi balu' babapalage tepulwa. ");
INSERT INTO mgw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lisu'ba palyatumbwi pilya, bannyendeli balu' ku'mi na abi'li' bammakie, “Walage bandu bayende kumisengo na kumigunda ya papipi, bakapate kilyo na muugonjo, kwa mwanjaa pano patubile, palupu'ngu'ti'.” ");
INSERT INTO mgw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini Yesu ngaabakia, “Mwapei mwenga kilyo.” Bannyangwi, “Twenga ntu'pu' kili'be sosoti, twigali na makati matano na omba abi'li'. Kwaali', tuyende twabene, tukaapi'mi kilyo bandu boti!” ");
INSERT INTO mgw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Palu', kwai na annalu'me kati maelupu matano. Bai, Yesu ngaabakia banamasi' bake, “Mwabakie bandu batame muipi'nga ya mitumbi amusini amusini.” ");
INSERT INTO mgw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Banamasi' baapangite kati mwababakiyilwe, baatamike mwitamo boti. ");
INSERT INTO mgw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bu'kapo, Yesu agatweti galu' makati matano na balu' omba abi'li', aalingite kunani na kwilu'bya balaka, kwimetwana na apei banamasi' bake li'nga baapei bandu. ");
INSERT INTO mgw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bandu boti baatilya no yukuta, na yaiigile baakongoli muitu'ndu', yatwi'li ku'mi na ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lisu'ba limo Yesu aabile kisake kalu'ba, na banamasi' bake babile papipi nakwe. Bai, ngaalaluya, “Bandu banibaya nenga na nyai?” ");
INSERT INTO mgw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nabembe ngabannyangwa, “Bi'ngi' babaya panga wenga wa Yoani Ywabatisage, bi'ngi' Elia, bi'ngi' yumo kati ya alondoli ba Nnu'ngu' ba kwai'mbu' balu' babayu'kite.” ");
INSERT INTO mgw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Apo ngalaluya, “Na mwenga buli, munibaya nenga na nyai?” Petili ngayangwa, “Wenga nga wa Kilisitu ywa Nnu'ngu' Nkulungwa ywabayilwe.” ");
INSERT INTO mgw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kai', Yesu ngaaking'indya na kwakanikiya panga kanebammakie mundu ywoywoti likowe lyo, ");
INSERT INTO mgw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ngayendelya baya, “Mwana wa Mundu apalikwa apate ngu'su'mbu' yansima no kanilwa na api'ndo, api'ndo ba dini, na balimu ba salya no bulagilwa. Lakini lisu'ba lyenetatu bu'ka kiwo sake, alu'a yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Payomwi po, ngaabakia bandu boti, “Mundu ywoywoti mana kapala panga mwanamasi' wangu', aikane mwene, aupu'twe nsalaba wake kila lisu'ba, na anibi'ngi'ye. ");
INSERT INTO mgw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwa mwanjaa mundu ywapala kuukombwa bwu'mi wake mwene alu'a kuobeya, lakini ywauobeya kwa kitumbu sangu' alu'a kuukombwa. ");
INSERT INTO mgw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kwani kiyongeya namani, mundu ba nawo utayili woti wa dunia kwa kwiobeya mwene? Niibona ntu'pu' so pata. ");
INSERT INTO mgw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mundu mana kanibi'kya oni nenga na gano ganiyi'gana, Mwana wa Mundu alu'a kummi'kya oni mundu ywo nsimu walu'a isa laya utukupu wake na wa Tati' bake na wa malaika apeleteu. ");
INSERT INTO mgw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nimmakianga kakape panga, kubi na bi'ngi' papanopano baapanga banawaali wangali kuubona Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Paliikite lisu'ba lya nane bu'ka palongei go, Yesu aayi'i na Petili, Yoani na Yakobi mpaka kukitu'mbi', akwo aayi'i lu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Paalu'bage kuminyo yake kwatigalambuka, na magu'bo gake gabile mauu no ng'alang'atya muno. ");
INSERT INTO mgw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na bandu abi'li' baabonekine kabalongela nakwe, na bo bai Musa na Elia. ");
INSERT INTO mgw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bandu bo pabaapitike babile na utukupu, balongei nakwe bu'kana na kiwo sake, sembe kilu'e yomolya gabini Nnu'ngu' akwo ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petili na aine baatopilwe na lugono, ata nyo pabayumwike baubweni utukupu wake, na balu' abi'li' babaayi'mi pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bai, bandu bo abi'li' pabaabile kababu'ka, Petili aammakie Yesu, “Mpi'ndo, yanogeleli twenga tukatama pano! Bai, tusenge isewe itatu, simo sako, simo sa Musa na si'ngi' sa Elia.” Kwo baya nyo kakape, aakitangiteli salongelage. ");
INSERT INTO mgw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petili palongelage go, aapangite minyo ku'pi'li'. Lyunde ngalielya na kwawi'ki'lya, na lyunde lyo palyaisilile, balu' banamasi', baatiyogopa muno. ");
INSERT INTO mgw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lilobe lyayu'wanike bu'ka kulyunde, “Ayu' nga Mwana wangu' ywaninsawile, mumpi'kani ywembe.” ");
INSERT INTO mgw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bu'ka paliyu'wanike lilobe lyo, Yesu aabonekine ai kisake. Banamasi' baatami liki, bammakieli mundu ywoywoti makowe go. ");
INSERT INTO mgw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pamalau' yake pabaelyage bu'ka kukitu'mbi', kipi'nga kiku'lu' sa bandu sakwembine na Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Apo, mundu yumo mukipi'nga si'lu', ngakatuya lilobe aabaite, “Mwalimu, nendakulu'ba sonde li'li'li' unninguli mwana wangu'. Mwana wangu' we yu'yu' bai! ");
INSERT INTO mgw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Moka endagakunnyingilya na kumpanga apange ndu'ti, annyi'ya kyundaunda na kumpiya matutume munkano. Mana annyingilile, endakuntesa muno na annekali kiyu'ngu'ya. ");
INSERT INTO mgw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naalu'bite banamasi' bako bakammi'nge, lakini baakombwili.” ");
INSERT INTO mgw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ngabaya, “Mwenga mwa lubelekwo lulau na lwangali ubi'lya! Nilu'a tama na mwenga na kunkomeya, mpaka pakubawi? Unnete mwana wako pano.” ");
INSERT INTO mgw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mwana ywo payendage kwa Yesu, yu'lu' moka ngantu'ya pai' na kunnyi'ya kyundaunda. Lakini Yesu ammi'ngite yu'lu' moka kwa yu'lu' mwana na kuntepwa, kwapeya tati' bake. ");
INSERT INTO mgw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bandu boti bausangalike uweso nku'lu' wa Nnu'ngu'. Balu' bandu pabasangalage goti gaagapangite Yesu, aabakie banamasi' bake, ");
INSERT INTO mgw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Muyu'we masikilo mugayu'we makowe gano. Mwana wa Mundu ayenda songelwa, no yingya mumaboko ga bandu.” ");
INSERT INTO mgw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini bembe baatangiteli kikomekeyo sa nnongelo wo. Likowe li' lyatiiyilwa li'nga baakane tanga, nabembe baayogwipe kunnaluya panga, alombolya buli bu'kana na nnongelo wo. ");
INSERT INTO mgw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kwai na ntau kati ya balu' banamasi', kwa abali yo laluyana panga nyai pakati yabe ywabile nku'lu' kulikoni boti. ");
INSERT INTO mgw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu pagatangite gabaganiage mumyoyo yabe, ngantola mwana nsimana na kummi'ka papipi na mwene. ");
INSERT INTO mgw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ngaabakia, “Mundu ywoywoti ywampokya mwana nsene yu' kwa lina lyangu' anipokya nenga, na ywoywoti ywanipokya nenga ampokya ywanitumike. Kwa mwanjaa yu'lu' ywabile nsene kuliko boti pakati yinu, ywembe nga nku'lu' kulikoni boti.” ");
INSERT INTO mgw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoani ngalongela, “Mpi'ndo, tumweni mundu yumo kabi'nga moka kwa lina lyako, na twenga twapayite kunkanikiya mwanjaa, ywembe aabileli mukipi'nga situ.” ");
INSERT INTO mgw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu ngammakia, “Kanemunkanikiye, yu'lu' ywakotoka taukana na mwenga, aywo ai pamope namwenga.” ");
INSERT INTO mgw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pauegeli nsimu wu'lu' wa Yesu pu'tu'lwa kunani, ywembe aabini ayende ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bai, ngatuma bandu bannongoli nabembe ngabayenda. Bayingi pakilambo simo sa Asamalia pala bakammi'ki makowe wisowiso. ");
INSERT INTO mgw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini benekaya ba po bapaili kumpokya, kwa mwanjaa ywembe ayendage ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bai, banamasi' bake Yoani na Yakobi pabagabweni go, ngababaya, “Bwana, upala twamulise mwoto uuluke bu'ka kunani walangamise?” ");
INSERT INTO mgw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lakini ywembe ngaagalambukya na kwakalipya. ");
INSERT INTO mgw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Baabu'i palu' no yenda kukilambo si'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pabaabile mumwanja, mundu yumo aammakie Yesu, “Nalu'a kuki'ngama kwokwoti kwawayenda.” ");
INSERT INTO mgw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ngabaya, “Ibweya babile na mapango gabe go tama, na iyuni iyumba yabe, lakini Mwana wa Mundu ywembe ntu'pu' pogonjo.” ");
INSERT INTO mgw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wayomwi po, aammakie mundu ywi'ngi', “Uniki'ngame.” Lakini mundu ywo ngayangwa, “Bwana, uniyi'ki'ti'ye wi'ti' nikasike tati' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ngayangwa, “Waleke babawile basikane bene na bene, lakini wenga uyende ukaale makowe ga Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mundu ywi'ngi' aatikummakia, “Bwana, naalu'a kubi'ngi'ya lakini uniyi'ki'ti'ye wi'ti' nikaalage bandu ba kasangu',” ");
INSERT INTO mgw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ngammakia, “Ywoywoti ywakamwa lingumbo, na katumbwa li'ma ku'no kalinga nsu'gu', aywo apwaikali kwa Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bu'kapo, Bwana aasawi bi'ngi' sabini na abi'li' ngaatuma abi'li' abi'li', li'nga balongoli kila pandu paabini mwene yenda. ");
INSERT INTO mgw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aatikwabakia, “Mauno gatwi'la, lakini auni bali'nganali. Kwa nyo, munnu'be Bwana mwene nng'unda alete auni munng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nambi'yambi' muyende, lakini mutange panga nintumanga kati bana ba ngondolo babayenda pakatikati ya mapu'mbe. ");
INSERT INTO mgw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kanemupu'twe likanda wala linyamanda wala ilatu, kai', mundi'la kanemumpange mundu abali. ");
INSERT INTO mgw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na kila nsengo wamulu'a yingya mwatumbwe kwapanga abali kamwabakia, ‘Amani ibe pansengo wu'no.’ ");
INSERT INTO mgw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na mana kubi na mwana wa amani, amani yinu ilu'a igala nakwe, na manaitei ntu'pu', ilu'a kummuyangania mwabene. ");
INSERT INTO mgw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bai, mutame pansengo wowowo kamulya no nywa samwapeyelwa, kwa mwanjaa mpangakasi apeyelwa nkwiso wake. Kanemuyangangane muutamo, li'no nsengo wu'no malau' wu'lu'! ");
INSERT INTO mgw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mana mwikite pakilambo nsi'si', bandu manabankemile, mwalye yabampeya. ");
INSERT INTO mgw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwatepwe atamwe bababile kwo, mwabakie bandu, ‘Ukulungwa wa Nnu'ngu' umwegelile mwenga.’ ");
INSERT INTO mgw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini mana mwikite pakilambo sosoti, mana bakani kunkemya, mwabu'ke na mana kampi'ta mumali'la gabe mubaye, ");
INSERT INTO mgw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ata lyu'ku'mbi' lya kilambo sinu lyalinamati mumagu'lu' gitu, twendapaapata kwo kana kwinu. Lakini mutange panga Ukulungwa wa Nnu'ngu' wegelile.’ ");
INSERT INTO mgw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nimmakianga panga lisu'ba lyo, kilambo so salu'a baa mmaule kulikoni galu' ga bandu ba Sodoma. ");
INSERT INTO mgw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wakibona wenga wa Kolazini! Wakibona wenga wa Betisaida! Kenda mangelongelo gagapangike kasinu gakapangika ku'lu' Tilo na Sidoni, sai'no bawati mabunia bu'ka palipite no tama muligu kababuyangania kwa Nnu'ngu' wabe. ");
INSERT INTO mgw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ata nyo lisu'ba lyo senulwa, mwenga mwasenuka paku'lu kulikoni Tilo na Sidoni. ");
INSERT INTO mgw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nawenga wa Kapernaumu buli! Ulu'a kwikatuya mpaka kunani? Ulu'a tu'mbu'yi'lwa mpaka kumambi'.” ");
INSERT INTO mgw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aayendeli baya, “Ywampi'kania mwenga, anipi'kania nenga na yu'lu' ywakana kumpokya mwenga, akana kunipokya nenga. Na ywoywoti ywakana kunipokya, akana kumpokya yu'lu' ywanitumike.” ");
INSERT INTO mgw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bu'kapo balu' sabini na abi'li', ngabaki'li'bu'ka ku'no kabanapusika, “Bwana, ata moka gendatuyu'wa kwa lina lyako.” ");
INSERT INTO mgw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu ngaabakia, “Naamweni Ibilisi katu'mbu'ka bu'ka kunani kati njai. ");
INSERT INTO mgw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nimpeyangite amuli yo li'bata nng'ambo na ipi'li'li' na makakala goti ga yu'lu' ndumu, kai' ntu'pu' kikowe sakilu'a kunsulu. ");
INSERT INTO mgw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lakini kanemunapusike mwanjaa moka gendakunnyu'wa ila, munapusike kwa mwanjaa maina ginu gaandikilwe kunani.” ");
INSERT INTO mgw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Popopo, Yesu asangiliye kwa Loo Mpeleteu aabaite, “Nendakunsukulu Mwa Tati', Bwana wa kunani na padunia, kwa mwanjaa makowe ga, mwaiyite bene ikima na malango, kwatambulya bana anangu'ta. Eloo Tati', kwa mwanjaa mo ngamwamupai.” ");
INSERT INTO mgw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bu'kapo ngabaya, “Tati' bangu' banikamukiye ili'be yoti. Ntu'pu' ywantangite Mwana ila Tati', Kai' ntu'pu' ywatangite Tati' ila Mwana, na ywoywoti yu'lu' Mwana apendi kuntambulya.” ");
INSERT INTO mgw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bu'kapo ngaatendebukya banamasi' bake alongei nabo pakiyi'ki'ya, “Nantali babagabona gano gamugabona mwenga! ");
INSERT INTO mgw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nimmakianga kakape, alondoli ba Nnu'ngu' na akulungwa, baapai kugabona galu' gamugabona mwenga na gamugayu'wa. Lakini bagabwenili na bagayu'wineli.” ");
INSERT INTO mgw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bu'kapo mundu yumo ywa salya aatiyi'ma na kunnaluya, kaapala kumpi'ndi'ka, “Mwalimu, nipange buli li'nga niupate ukoto wangali yomoka?” ");
INSERT INTO mgw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ywembe ngannyangwa, “Iandikilwe buli musalya? Wenga utanga buli?” ");
INSERT INTO mgw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mwalimu wa salya ngannyangwa, “Umpende Bwana Nnu'ngu' wako kwa mwoyo wako woti, kwa loo yako yoti, kwa makakala gako goti na kwa malango gako goti. Na umpende ywotama papipi nakwe, kati mwowipenda wamwene.” ");
INSERT INTO mgw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ngammakia, “Mwoyangwile unogiye! Upange nyo nawenga walu'a lama.” ");
INSERT INTO mgw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini mwanjaa ywembe apalage kwibalangilya panga nnogau, annalwiye Yesu, “Na mundu ywa papipi yangu' nga ywaku'?” ");
INSERT INTO mgw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ngannyangwa, “Mundu yumo aelyage bu'ka ku Yelusalemu yenda ku Yeliko. Payendage, mundi'la, aayingililwe na makatauluma, bampokonywi ili'be yake yoti, kunneka wausu na kunku'mbwa, bannei aindwike. ");
INSERT INTO mgw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nembe mpi'ndo yumo wa dini kapi'ta pandi'la yi'yi'lu'yi'lu', apite mbwega ku'no kammona. ");
INSERT INTO mgw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nembe Mlawi yumo, paikite pandu po, apite mbwega mbwega ku'no kammona. ");
INSERT INTO mgw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini mundu yumo Nsamalia ywabile mumwanja wake, paikite pabile yu'lu' mundu aammi'ki kiya. ");
INSERT INTO mgw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Atikunnyendelya na kunnyangatiya, kwa kunnyi'ya mauta na wi'mbi' wa njabibu na kuntabya itambala. Wayomwi go, ngamwu'bu'ya mu mbu'nda wake na kumpeleka ku nyumba ya ageni yenda kummu'bu'ya. ");
INSERT INTO mgw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pamalau' yake ngampeya mbanje dinali ibi'li' yu'lu' mwene nsengo, no lagana nakwe panga, ‘Ummu'bu'ye mundu yu', na sosoti sawalu'a tumya kai', nalu'a kuli'pa kibuyo.’” ");
INSERT INTO mgw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bu'kapo Yesu aatilaluya, “Kati ya bandu bo atatu, ywaku' ywabonekine panga mundu ywa papipi ywa yu'lu' ywayingililwe na balu' makatauluma?” ");
INSERT INTO mgw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yu'lu' mwalimu ywa salya ngayangwa, “Yu'lu' ywammi'ki kiya nga mundu wa papipi.” Yesu ngammakia, “Uyende, ukapange nyinyonyo.” ");
INSERT INTO mgw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pabaabile mumwanja, baaikite kukilambo simo na nnwawa yumo ywakemelwa Malita, ankemi kasake. ");
INSERT INTO mgw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita aabile na nnunawe ywakemelwage Malia, ayu' aatami papipi na Yesu, kapi'kania gayi'ganage. ");
INSERT INTO mgw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Malita ywembe aiauyage na makowe gambone ga nng'eni. Bai, ngannyendelya Yesu ngammakia, “Bwana, wenga wibona sawasawa nnunangu' anileka niauke kisangu'? Ummakie aniyangatiye.” ");
INSERT INTO mgw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Bwana annyangwi, “Malita, Malita, wendakwiauya na kwisuluya kwa makowe maingi. ");
INSERT INTO mgw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kikowe simo bai nga sangama. Malia asawi kikowe sangama muno, alu'a li'ndi'li'lwa na sembe apokonyolwali.” ");
INSERT INTO mgw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lisu'ba limo, Yesu aabile pandu nsi'si' kaalu'ba Nnu'ngu'. Payomwi lu'ba Nnu'ngu' yumo bu'ka mukipi'nga sa banamasi' bake aatikummakia, “Bwana, tukulu'ba utuyi'gane lu'ba Nnu'ngu' kati Yoani Ywabatisage mwayi'ganiye banamasi' bake.” ");
INSERT INTO mgw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu aabakiye, “Pamulu'ba Nnu'ngu' mubaye nnyanya, ‘Tati' bitu mwamubile kunani, Lina linu likwi'yi'lwe, Ukulungwa winu wise. ");
INSERT INTO mgw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mutupei kilyo situ sa kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mutusami masambi gitu, kati twenga mwatwasamya babatukosile, kai' kanemutuyi'ngiye mumakowe ga kutupaya.’” ");
INSERT INTO mgw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kai' ngaabakia, “Tubaye yumo mukipi'nga sinu aabile na mbwigalye, nembe annyendeli kasake meku, na kummakia, ‘Mbwiga, sonde li'li'li' uniyaiki makati gatatu. ");
INSERT INTO mgw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mbwiga lyangu' aai mumwanja api'ti kasangu', nanenga ntu'pu' sa kumpeya.’ ");
INSERT INTO mgw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nembe paabile nnyumba ngannyangwa, ‘Ngani kunisuluya! Ne niyigile niango wangu'! Yi'no saa yo gonja nenga na bana bangu', nikupeyali ubu'ke bai!’ ");
INSERT INTO mgw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tubaye apala yumuka kumpeya kwa mwanjaa ywembe mbwigalye lili, ila kwa mwanjaa mundu ywo aayendeli kunnu'ba, alu'a katuka ampei sosoti sakipala. ");
INSERT INTO mgw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kwa nyo, nimmakianga mulu'be namwenga mwapeyelwa, mupale namwenga mwapata. Mupange u'li, namwenga mwayu'gu'li'lwa. ");
INSERT INTO mgw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwa mwanjaa ywoywoti ywalu'ba ngaywapeyelwa, ywapala ngaywapata na ywapanga u'li, ngaywayu'gu'li'lwa. ");
INSERT INTO mgw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ywaku' kasinu mana mwana wake aalu'bite tati' bake omba, alu'a kumpeya nng'ambo ayu'ye omba? ");
INSERT INTO mgw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na mana alu'bite lipinga kitiwi, alu'a kumpeya kipi'li'li'? ");
INSERT INTO mgw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kati mwenga mwamubile mwalau, mumanyi kwapeya bana binu ikowe inannoga, nga munomuno tati' binu ba kunani, balu'a kwapeya Loo Mpeleteu balu' babannu'ba.” ");
INSERT INTO mgw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lisu'ba limo Yesu abi'ngage moka ywagampangite mundu yumo kaneakombwe longela. Bai, ago moka pagammu'i, aywo mundu ngakombwa longela, kipi'nga sa bandu satisangala. ");
INSERT INTO mgw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini bandu bi'ngi' pakipi'nga sabe babaike, “Abi'nga moka kwa uweso wa Belisebuli, mpi'ndo wa moka.” ");
INSERT INTO mgw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bi'ngi' bendekumpaya, li'nga apange mangelongelo itanganikwe panga ayi'ki'tilwe bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini mwanjaa ywembe aagatangite gabaganiage, ngaabakia, “Ukulungwa wowoti waubaganike ipi'nga yaitaukana, ukombwali konda. Nga mwalubile lukolo lwolwoti lwaluyu'mana, lusi'yali langanyika. ");
INSERT INTO mgw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mana Ibilisi kaitaukya mwene, ukulungwa wake ulu'a yi'ma kitiwi? Mubaya buli nde, panga nibi'nga moka kwa uweso wa Belisebuli? ");
INSERT INTO mgw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mana kanibi'nga moka kwa uweso wa Belisebuli, bamwatuma mwenga babi'nga kwa uweso wa nyai? Kwa kitumbu so, bembe ngabalu'a kunkania mwenga mwabu'su'. ");
INSERT INTO mgw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini mana kanibi'nga moka kwa uweso wa Nnu'ngu', bai mutange panga Ukulungwa wa Nnu'ngu', tiyali wikite kwinu. ");
INSERT INTO mgw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu mwene makakala, pali'ndi'la nsengo wake kwa yombo yo li'ndi'lya, mali yake yoti ipanga ngoto. ");
INSERT INTO mgw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini mana aisile ywampite kwa makakala na kunnyingilya, ampokonywa yombo yo li'ndi'lya yaiu'bi'lyage na mali yake kwibagana. ");
INSERT INTO mgw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ywoywoti ywakotoka lu'mbana nanenga, ayenda kinsu'gu' nanenga, ywoywoti ywakotoka kongolya pamope nanenga, alu'a yanjaya. ");
INSERT INTO mgw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Moka mana abi'ngilwe kwa mundu, ati'li'ta ti'li'ta mulubele kaapala pandu po pu'mu'lya, mana ntu'pu' aibakia mwene, ‘Nilu'a buyangania kasangu' kwanibu'i.’ ");
INSERT INTO mgw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pabuyangana, aikwemba yi'lu' nyumba ipyayililwe no nemekelwa na nkati yake ntu'pu' ywatama. ");
INSERT INTO mgw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bai, ayenda kwakoka moka aine saba alau pi'ta ywembe, boti bayenda kunnyingya mundu ywo. Kwa nyo, ali ya mundu ywo yapanga mbaya muno kulikoni mwayaabile.” ");
INSERT INTO mgw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Palongelage go, nnwawa yumo pakipi'nga si'lu' sa bandu ngatu'ndu'bi'ya lilobe lyake no baya, “Nantali nnwawa ywakupapite na kukuyongeya.” ");
INSERT INTO mgw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini Yesu ngabaya, “Nantali muno balu' babapi'kania liyi'gi'yo lya Nnu'ngu' na kulikamwa.” ");
INSERT INTO mgw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kipi'nga sa bandu pakiyendelyage isa Yesu aatikwabakia, “Lubelekwo lu'no lwene sambi lupala lulole mwanju, lakini lupeyelwali lola, mwanju wabaubweni kwa Yona, uli'ngani. ");
INSERT INTO mgw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kati mu'lu' Yona mwabile mwanju kwa bandu ba ku Ninawi, nyinyonyo na Mwana wa Mundu ngamwalu'a panga mwanju kwa lubelekwo lu'no. ");
INSERT INTO mgw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Malikiya wa Seba alu'a pitya Nsimu wo ukumilwa lubelekwo lu'no. Nembe alu'a kuluukumu kwa mwanjaa lubile na masambi. Mwanjaa ywembe aaisi bu'ka kuutalu li'nga api'kani mayi'gi'yo gene malango ga Selemani, na aaisi kwipwa panga, kumbe pano pabile na nku'lu' kulikoni Selemani. ");
INSERT INTO mgw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bandu ba Ninawi balu'a yi'ma Nsimu wo ukumilwa. Nabembe balu'a luukumu lubelekwo lu'no panga lubile na masambi. Kwa mwanjaa bembe bammuyangani Nnu'ngu' bu'kana na maalo ga Yona, na kumbe pano pabile na nku'lu' kulikoni Yona. ");
INSERT INTO mgw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ntu'pu' mundu ywakoya kimuli kukibi'ka mmu'ngu' au mukitu'ndu', ila akiu'bu'ya kunani, li'nga bandu babayingya nnyumba bapate kuubona bweya. ");
INSERT INTO mgw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liyo lyako nga kyenge sa yi'ga yako, mana libile likoto, yi'ga yako yoti yalu'a ba mubweya. Liyo lyako mana libile litu'lu'ka na yi'ga yako na yembe ilu'a ba mulubi'ndu'. ");
INSERT INTO mgw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wili'ndi'le lelo na bweya waubile nkati yako, wakane yu'ka lubi'ndu'. ");
INSERT INTO mgw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bai, manaitei yi'ga yako yoti ibile mubweya, wangali ba pandu popoti pene lubi'ndu', nawenga walu'a baa mubweya munomuno kati mu'lu' mwaupanga bweya wa kyenge.” ");
INSERT INTO mgw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu paabile kalongela, Mfalisayo yumo ankemi kilyo kasake, nembe ngayenda lya. ");
INSERT INTO mgw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aywo Mfalisayo asangalike kummona kalya wangali uluga masi' mumaboko, kwa mwanjaa yayi'ki'tilweli musalya. ");
INSERT INTO mgw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bwana ngammakia, “Mwenga mwa Mafalisayo, mumanyi gu'lwa nnobo na nkungu kunja, lakini nkati yake kutwi'li bwimi no akala mwoyo. ");
INSERT INTO mgw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwenga mwalogeloge! Buli, nengite Nnu'ngu' ywatengenise panja, nga ywatengenise nkati? ");
INSERT INTO mgw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mwapei aki'ba yi'lu' ili'be yaibile nkati ya myoyo yinu na yi'ngi' yoti yapanga alali yinu.” ");
INSERT INTO mgw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lakini, mwakibona Mafalisayo, kwa mwanjaa mupiya saka ata maakapi ga ndakyo ya ilyo, ndebele na maakapi gi'ngi'. Lakini mugaleka makowe gagakong'ondya aki na kumpenda Nnu'ngu'. Mugakamwe makowe ga, wangali kugalibalya galu' gi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mwakibona mwenga mwa Mafalisayo, kwa mwanjaa mupendi tama nnu'ngi' pandu pa isima amo mumayumba ga kunnu'ba Nnu'ngu' no pangilwa abali kwa isima pakipi'nga sa bandu. ");
INSERT INTO mgw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mwakibona, kwa mwanjaa mulandana na masiko gangali i'mbya maliwe, bandu bapi'ta panani yake wangali tanga ubolau wabauli'bata.” ");
INSERT INTO mgw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yumo mukipi'nga sa balimu ba salya ngammakia, “Mwalimu, makowe golongela, twenga wendatupwi'wa.” ");
INSERT INTO mgw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu annyangwi panga, “Mwakibona mwenga mwabalimu ba salya, kwa mwanjaa mwatwi'ka bandu igombo yangali pu'tu'li'ka, ku'no mwabene mukombwali ata golwa lukonji lumo kwayangatiya. ");
INSERT INTO mgw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mwakibona, kwa mwanjaa musengya masiko ga alondoli ba Nnu'ngu' balu' babaabulagilwe na api'ndo binu. ");
INSERT INTO mgw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kwa nyo, mukong'ondelya panga, muyi'ki'tile mwabapangite api'ndo binu, bembe bai abulagi ba abo alondoli ba Nnu'ngu', na mwenga musengya masiko gabe. ");
INSERT INTO mgw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kwa nyo, ikima ya Nnu'ngu' yabaite nnyinyo, ‘Nalu'a kwapelekya alondoli na atumilwe ba Nnu'ngu', lakini bi'ngi' balu'a kwabulaga na bi'ngi' kwapeya ngu'su'mbu'.’ ");
INSERT INTO mgw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bu'kana na makowe ga lubelekwo lu'no lwalu'a pwatilwa, kwa mwanjaa myai ya alondoli boti ba Nnu'ngu' yaiyitanike bu'ka palutumbwi dunia, ");
INSERT INTO mgw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bu'ka yitanika kwa myai ya Abeli mpaka yi'lu' ya Zakalia, yu'lu' ywabulagilwe mu Nyumba ya Nnu'ngu', pakati ya kibi'ki'lyo na pandu papeleteu. Nimmakianga, Kakape lubelekwo lu'no lwalu'a pwatilwa kwa makowe go. ");
INSERT INTO mgw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mwakibona, mwenga mwa balimu ba salya! Kwa mwanjaa mwiyite si'lu' kiyu'gu'lyo sa niango wo yi'ganilwa, mwabene muyingili na mwakanikiye babayingyae kanebayingi.” ");
INSERT INTO mgw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pabu'i palu', balu' Mafalisayo na balimu ba salya, baatumbwi kunnyingilya kwa kunnaluya maswali gambone kwa ukali', ");
INSERT INTO mgw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kabampi'ndi'ka li'nga bannyonje kwa malongelo gake bapate kitumbu sa kunsongya. ");
INSERT INTO mgw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bandu maelupu baatikusikana no li'batana, Yesu aatumbwi wi'ti' kwabakia banamasi' bake, “Mwili'ndi'le na uyi'me wa ulu'u wa Mafalisayo nga unapiki. ");
INSERT INTO mgw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lakini ntu'pu' sakiwi'ki'lilwe, sasaakotoka umukulwa, kila sakiyu'bite salu'a kwipulwa. ");
INSERT INTO mgw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kwa nyo, kila samulongei mulubi'ndu', bandu balu'a kiyu'wa pabweya, na kila gamulongei kwo yu'yu'tana kuungati milyango iyigalilwe, galu'a bayilwa panani ya mwagala wa nyumba. ");
INSERT INTO mgw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nimmakianga mwenga mwa mambwiga bangu', kanemwayogope balu' babakombwa bulaga yi'ga bai, lakini bakombwali yendelya panga kikowe si'ngi' mana babulige. ");
INSERT INTO mgw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nilu'a kummakianga yu'lu' ywapalikwa kunnyogopa, Munnyogope yu'lu' ywakombwa bulaga na kuntaikulya mundu kumwoto. Eloo, nimmakianga munnyogope ywo. ");
INSERT INTO mgw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Itanganikwe panga injosi tano ipi'mi'yi'lwa kwa ela njene muno, au nyonyoli? Lakini nnu'ngi' ya Nnu'ngu', alibalilwali ata yumo. ");
INSERT INTO mgw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lakini ata nywili ya mumitwe yinu ibalangilwe yoti. Kanemuyogope, mwenga nga mwampu'ku'bi'la kulikoni injosi yambone. ");
INSERT INTO mgw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nimmakianga kakape, kila mundu ywaniyi'ki'tya nnu'ngi' ya bandu panga ywembe ywangu', Mwana wa Mundu nembe alu'a kunnyi'ki'tya nnu'ngi' ya malaika ba Nnu'ngu' panga mundu ywo ywake. ");
INSERT INTO mgw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini mundu ywoywoti ywanikana nnu'ngi' ya bandu, nembe alu'a kanilwa nnu'ngi' ya malaika ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ywoywoti ywalongela likowe lyo kana kunnyi'ki'tya Mwana wa Mundu, alu'a samilwa, lakini ywannongelya ubu'su' Loo Mpeleteu, alu'a samilwali. ");
INSERT INTO mgw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pabampelekanga mwenga nnu'ngi' ya mayumba ga kunnu'ba Nnu'ngu' na nnu'ngi' ya api'ndo na atawala, kanemwalendeme gania panga mukaikengya, au mukayangwa buli. ");
INSERT INTO mgw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwa mwanjaa Loo Mpeleteu alu'a kunnyi'gana si'lu' samupalilwa yangwa popopo.” ");
INSERT INTO mgw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu yumo palu' pakipi'nga sa bandu aatikummakia, “Mwalimu, ummakie nnunangu' yu', tubagane ulisi wabatuleki tati'.” ");
INSERT INTO mgw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu annyangwi, “Mbwiga, nyai ywanibi'i nenga panga na mundu ywa kwakenga au kwa awana pakati yinu?” ");
INSERT INTO mgw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bai, ngaabakia boti, “Mwili'ndi'le na kila uyi'me wa bwimi, kwa mwanjaa ukoto wa mundu ubu'kanali no yoloka kwa ili'be yabile nayo.” ");
INSERT INTO mgw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bu'kapo, ngaalongelya kwa lukongo lu'no, “Kwabile na tayili yumo ywembe munng'unda wake aatimeya munomuno. ");
INSERT INTO mgw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tayili ywo, aganiyite pamwoyo wake, ‘Nilu'a panga buli nanenga ntu'pu' ligu'lu' lyo bi'kya ilyo yangu'? ");
INSERT INTO mgw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nilu'a panga nyo, nilu'a sengwana tugu'lu' twangu' tuketuke no senga ligu'lu' liku'lu' amo nganilu'a bi'ka ilyo yangu' yoti yaniunike na mali yangu'. ");
INSERT INTO mgw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Apo, naubakia mwoyo wangu' panga pano le ubile na sobi'ki'ya, no tumya myaka yambone, no ponda mali bai, lya, nywa, no napusika.’ ");
INSERT INTO mgw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lakini Nnu'ngu' ngammakia, ‘Wenga wa nnogeloge, kilo sa li'no, bwu'mi wako wendatolelwa. Na ili'be yi'lu' yoti yowitwi'li'kiye, ilu'a panga ya nyai?’” ");
INSERT INTO mgw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu ayomoli kwo baya, “Amo ngamwabile mundu ywaitwi'li'ki'ya mali kwa makowe gake mwene bai, lakini nki'ba nnu'ngi' ya Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bu'kapo Yesu aabakie banamasi' bake, “Kwa kitumbu so nendakummakianga, kanemube na kyukala ati' kilyo twapata kwaku', au alu'a kutuwalika nyai? ");
INSERT INTO mgw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwa mwanjaa nantali bwu'mi kulikoni kilyo, yi'ga nantali kuliko ngu'bo. ");
INSERT INTO mgw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mwalinge mwababile iyuni. Bapandangali wala baunali, kai' ntu'pu' ligu'lu' lyolyoti. Ata nyo Nnu'ngu' ayimali ilyo endakwayakia. Mwenga mwampu'ku'bi'la kuliko iyuni! ");
INSERT INTO mgw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nyai mukipi'nga sinu ywakombwa lumya kwa kwiauya no kombwa yongeya kwaali' pasene masu'ba ga bwu'mi wake? ");
INSERT INTO mgw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bai, manaitei mukombwali panga likowe lisene kati lyo, mwanjaa namani muba na kyukala kwa galu' gi'ngi'? ");
INSERT INTO mgw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mugalinge malu'ba mwagalembulya! Gapangali kasi kai' gaiwalikali. Lakini nimmakianga, ata Nkulungwa Selemani mwene na utayili waabile nawo na magu'bo gawalage, anaikali paugolou wa lilu'ba limo. ");
INSERT INTO mgw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Manaitei Nnu'ngu' akombwa kuliwalika nyo lyamba lya munng'unda, lyembe li'no libile na malau' lyalu'a taikulwa palitu'ta no tinika mwoto. Buli, kangi' alu'a kumpangya muno mwenga? Mwenga mwa bandu ba imani njene! ");
INSERT INTO mgw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bai, kanemube na kyukala kwa kwiauya pala kilyo au so nywa. ");
INSERT INTO mgw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mwanjaa bandu bangali kuntanga Nnu'ngu' baukya go, na Tati' binu batangite panga makowe go gendapalilwa na mwenga. ");
INSERT INTO mgw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mupale wi'ti' Ukulungwa wa Nnu'ngu' na go gi'ngi' mwalu'a yongeyelwa na Ywembe. ");
INSERT INTO mgw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kanemuyogope, mwenga mwakipi'nga kisene sa ngondolo, kwa mwanjaa Tati' binu bapendi kumpeyanga Ukulungwa. ");
INSERT INTO mgw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mupi'mi'yange mali yinu na mbanje ye mukaapei aki'ba. Mwitengenesi mipuko yangali otoka na kwibi'kya amana kunani, akwo ipu'ngwali. Akwo bai, baegelyali kai' ngu'lu'ku'lu' baalabiyali. ");
INSERT INTO mgw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Palu' paibile amana yako, nga pawaba na mwoyo wako. ");
INSERT INTO mgw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mube tiyali, mutabite mikanda muibuno na yenge yinu itame kaiyaka. ");
INSERT INTO mgw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mutame kati atumisi babanni'nda bwana wabe abuyangane bu'ka kulisengele, li'nga mana bayu'wine ilulu bai, bannyu'gu'li nniango ayingi. ");
INSERT INTO mgw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nantali atumisi balu' bembe bwana wabe paabuyangana, akwemba kabakeleka! Kakape nendakummakianga, aywo bwana aibi'ka wiso na kwakemya pamesa li'nga balye. ");
INSERT INTO mgw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ata mana aabuyangana meku au kakusa na kwakwemba kabakeleka, nantali yabe atumisi bo! ");
INSERT INTO mgw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mutange panga kenda mwene nyumba akatanga saa yaisa mwii, alu'e keleka na alu'e yi'ki'tyali kunneka ayingi no yiba. ");
INSERT INTO mgw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na mwenga nyinyonyo, mutame wiso kwa mwanjaa, Mwana wa Mundu alu'a isa saa yangatanganikwa.” ");
INSERT INTO mgw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petili ngalaluya, “Bwana, lukongo lu' utulongelya twenga bai au twa bandu boti?” ");
INSERT INTO mgw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bwana ngayangwa panga, “Ywaku' ntumisi ywa u'bi'li'ka na mwene ikima, ywembe bwana wake alu'a kummi'ka panani ya atumisi bake li'nga apei kilyo nsimu waupalilwa? ");
INSERT INTO mgw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nantali yake ntumisi ywo, manaitei bwana wake paaki'li'bu'ka alu'a kunkwemba kapanga nyo. ");
INSERT INTO mgw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kakape alu'a kumwu'bu'ya na kumpanga ntawala wa amana yake yoti. ");
INSERT INTO mgw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini mana ntumisi ywo abaite pamwoyo wake, ‘Bwana wangu' asi'liye buyangana,’ ngatumbwa kwaku'mbwa atumisi aine analu'me na alwawa no lya, nywa no lobya, ");
INSERT INTO mgw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bwana wake alu'a buyangana lisu'ba lyangali pi'kanilya na saa yangali tanganikwa, alu'a kunku'mbwa muno ntumisi ywo na kumuukumu pamope na bangali u'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ntumisi yu'lu' ywatanga mwapala bwana wake, lakini apangali gagapalilwa panga, aaputilwa munomuno. ");
INSERT INTO mgw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini ywapanga makowe gagampanga mundu asenuke wangali tanga, aaputilwa pasene. Ywapeyilwe yambone, alu'a longelwa yambone, ywapeyilwe yambone muno, alu'a longelwa yambone munomuno. ");
INSERT INTO mgw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niisi koya mwoto padunia, napendi ukapanga uyakite! ");
INSERT INTO mgw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nibile na ubatiso wambalikwa niupoki, kwa ndi'la yaku' niiauye mpaka utimi! ");
INSERT INTO mgw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mukita niletike amani pano pa dunia? Ata pasene, amani lili, ila mayu'mano. ");
INSERT INTO mgw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","No bu'ka nambi'yambi', mana kubile na alongo batano, balu'a baganika, ku'no abi'li' kwi'ngi' atatu au kwi'ngi' atatu, ku'no abi'li'. ");
INSERT INTO mgw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tati' balu'a yu'mana na mwana na mwana alu'a yu'mana na tati' bake, mau' bayu'mana na mwi'nja wabe na mwi'nja ayu'mana na mau' bake, mau' mukwe bayu'mana na nkamwana na nkamwana ayu'mana na mau' mukwe.” ");
INSERT INTO mgw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ngaibakia kai' ipi'nga ya bandu, “Mana mugabweni maunde gayi'mi kulwingo lwa kundondi bai popopo mubaya, ‘Ula alu'a nia’, kakape endania. ");
INSERT INTO mgw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mana muubweni nsunga wa kusi kaupukatya mubaya, ‘Kwalu'a ba na lyoto muno,’ Na ngamwaipangika. ");
INSERT INTO mgw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwenga mwa anapiki! Mumanyi londwa mumaumbile ga nni'ma na kumaunde, mukotoka ki'li' tanga maumbile ga nsimu wu'no? ");
INSERT INTO mgw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kwa mwanjaa namani mukotoka kwiamulya mwabene panga likowe linannoga? ");
INSERT INTO mgw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mana ywa kusitakya, kakupeleka kukoliti, yabile male yomwana nakwe mubile mundi'la, akane kupeleka kwa akimu, nembe akimu akane kukukamukiya kwa asikali, nabembe bakane kuyingiya muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kakape nikubakia, watama mo mpaka wayomwe li'pa lwela lwa kuundi'la.” ");
INSERT INTO mgw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nsimu wo baaisi bandu nsi'si' kummakia Yesu abali ya ku Galilaya, kwa bandu bababulagilwe na Pilato pabaaisi na inyama yabe isinjilwe kwa salaka ya mu Nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nembe Yesu aatikwabakia, “Mwenga mubaya Agalilaya bo, bai na sambi kulikoni Agalilaya bi'ngi' ati' kwa mwanjaa batesilwe nyo? ");
INSERT INTO mgw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nimmakianga kakape panga, bapangiteli sambi kwapi'ta balu', lakini namwenga kati bobobo, mana mukotwike kunng'alambukya Nnu'ngu', mulu'a langanyika kati bembe. ");
INSERT INTO mgw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au' balu' ku'mi na banane babaatu'mbu'kilwe na nsengo nku'lu' ku Siloamu no waa, mubaya bembe bai na masambi kulikoni bi'ngi' boti babatamage ku Yelusalemu? ");
INSERT INTO mgw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nimmakianga nyinyo lili, lakini na mwenga mana mukani kunng'alambukya Nnu'ngu', mulu'a langanyika kati bembe.” ");
INSERT INTO mgw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bu'kapo Yesu ngaabakia lukongo lu'no, “Mundu yumo aabile na ntini munng'unda wake, payi'i pala atu'mbwe itunda yake, aubweni unapambikali ata limo. ");
INSERT INTO mgw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bai, ngammakia mpangakasi wake, ‘Linga! Wu'no mwaka wenetatu nisa pa nkongo wu' pala nitu'mbwe litunda, lakini nalibonali lipambike ata limo! Upi'ngwe, uyomwa mbolya ya munng'unda bai wangali pambika.’ ");
INSERT INTO mgw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lakini mpangakasi annyangwi, ‘Bwana, tuuleke kai' mwaka gu'no, nilu'a kuuti'li'ti'ki'ya nkulyo upate masi' na kuyi'ya mbolya. ");
INSERT INTO mgw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mana waapambika manisa, twauleka, mana waapambikali twaupi'ngwa.’” ");
INSERT INTO mgw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu endeyi'gana munyumba ya kunnu'ba Nnu'ngu' kulisu'ba lya Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na po, kwabile na nnwawa yumo ntamwe kwa myaka ku'mi na minane aayingililwe na moka. Kwa mwanjaa nyo, ng'ongo wake waatilemala muno ata akombwageli yi'ma wi'ma. ");
INSERT INTO mgw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu pamweni aatikunkema ngammakia, “Mau', utamwe winu mutepulilwe.” ");
INSERT INTO mgw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aammi'ki maboko gake pantwe na popopo, yi'ga yake yapatike makakala go yi'ma kai' na ankwi'yite Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini mpi'ndo ywa nyumba ya kunnu'ba Nnu'ngu' aatiusika kitumbu sa Yesu kuntepwa mau' ywo lisu'ba lya Sabato ya Ayahudi. Kwa nyo, aabakie bandu babaabile palu', “Mubile na masu'ba sita go panga kasi, bai mugatumi masu'ba go isapala pona matamwe ginu, lakini kanemwise lisu'ba lya Sabato ya Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Apo Bwana ngannyangwa, “Mwenga mwa anapiki! Nyai kwinu ywalu'e somwa yu'gu'lya ng'ombe bake au mbu'nda bake mukyu'ngu'lu' annongoye kunyweli wa masi' ata likabile lisu'ba lya Sabato ya Ayahudi? ");
INSERT INTO mgw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tumbwe pano kubile na mwi'nja ywa Bulaimu, ywembe Ibilisi ampangite alemale kwa myaka ku'mi na minane. Buli, yanogeleli lili kunnyu'gu'lya muutabilwe wake lisu'ba lya Sabato ya Ayahudi?” ");
INSERT INTO mgw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Payomwi longela go, babantaukyage baibweni oni lakini bandu bi'ngi' boti batipulaika muno kwa makowe goti gaagapangite palu'. ");
INSERT INTO mgw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu ngalaluya, “Ukulungwa wa Nnu'ngu' ulandana na namani? Nilu'a kuulandanisa na ki'li'? ");
INSERT INTO mgw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ubile kati lupeke lwa nkongo wa aladali, lwaalutweti mundu yumo na kulupanda munng'unda wake, lwatibalika no panga nkongo nku'lu'. Iyuni yaigu'lu'ka yakombwi senga iyumba yabe mundambi' yake.” ");
INSERT INTO mgw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ngalaluya kai' “Nilu'a kuulandanisa Ukulungwa wa Nnu'ngu' na namani? ");
INSERT INTO mgw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kati ngelule njene yaiyi'i mau' yumo na kuiyangabana pamope na bwembe mbisi tano, na bwembe woti waatilu'la.” ");
INSERT INTO mgw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu aayendeli na mwanja wake wa ku Yelusalemu, ku'no kapi'tya muilambo na mumili'ma, kayi'gana liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu yumo ngannaluya, “Buli Bwana, bandu babaalu'a kosopolelwa baayoloka lili?” ");
INSERT INTO mgw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesu ngaabakia, “Mukasane yingya kwo pi'tya niango waupatimwa, kwa mwanjaa nendakummakia, baingi balu'a paya yingya, lakini baakombwali. ");
INSERT INTO mgw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nsimu waisa, apo mwene nyumba alu'a katuka no yigala niango. Mwenga mwaalu'a yi'ma panja no panga u'li kamubaya, ‘Bwana, utuyu'gu'li.’ Lakini ywembe alu'a kunnyangwa, ‘Ndangiteli kwamubu'ka!’ ");
INSERT INTO mgw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na mwenga mwatumbwa kummakia, ‘Twenga ngatulyage no nywa pamope nawenga, kai' wenga uyi'ganage muilambo yitu.’ ");
INSERT INTO mgw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini ywembe alu'a baya, ‘Ndangiteli mwenga muuma kwaku', mubu'kange nnu'ngi' yangu' mwenga mwaboti mwapanga sambi.’ ");
INSERT INTO mgw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Apo, ngapasapanga kili'lo no yaga mino, pamwabona ki Bulaimu, Isaki, Yakobi na alondoli ba Nnu'ngu', boti babile mu Ukulungwa wa Nnu'ngu', lakini mwenga mwabene, mutaikulilwe panja! ");
INSERT INTO mgw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bandu balu'a isa bu'ka kumbwani na kundondi, kukibu'la na kusi no tama pakilyo ku Ukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eloo, balu' babalongolile balu'a panga ba kuundi'la na balu' ba kuundi'la balu'a longolya.” ");
INSERT INTO mgw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wakati wowowo, Mafalisayo bi'ngi' baatikunyendelya na kummakia, “Ubu'ke pano uyende kwi'ngi' kundu, kwa mwanjaa Helode apala kukubulaga.” ");
INSERT INTO mgw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ngayangwa, “Muyende mukammakie aywo kibweya nng'anga nnyanya, ‘Li'no na malau' nilu'a bi'nga moka na kwatepwa atamwe na lisu'ba lyenetatu nilu'a yomolya lyengo lyangu'.’ ");
INSERT INTO mgw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ata nyo li'no, malau' na papasa, niyendelya na mwanja wangu', kwa mwanjaa inogelyali nnondoli ywa Nnu'ngu' abulagilwe panja ya ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwa Yelusalemu! Yelusalemu! Wabulaga alondoli ba Nnu'ngu' na kwaku'mbwa maliwe balu' babatumilwe na Nnu'ngu' kasako. Pali'nga nipalike kwabi'ka pamope bana bako, pamope kati ngu'ku' nyongolo mwakumbatya bana bake pai' ya mapapayo gake, lakini watekana. ");
INSERT INTO mgw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aya! Alu'a kuleka kisako, panyumba yako palu'a panga payame. Bai, nimmakianga mwanibonali kai' mpaka nsimu wamwabaya, ‘Ayaliwite aywo ywaisa kwa lina lya Bwana.’” ");
INSERT INTO mgw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lisu'ba limo lya Sabato ya Ayahudi, Yesu aayi'i lya kunyumba yimo ya alongosi ba Mafalisayo, bandu baabile popo kabannolekeya. ");
INSERT INTO mgw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nnu'ngi' yake Yesu, kwaabile na mundu yumo ywaminyage kitamwe so imba payi'ga. ");
INSERT INTO mgw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu aalalwiye balimu ba salya na Mafalisayo, “Buli, yendayi'ki'ti'lwa kuntepwa mundu lisu'ba lya Sabato?” ");
INSERT INTO mgw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini bembe bayangwili. Yesu ankamwi ywo ntamwe, kuntepwa na kunneka aibu'ki. ");
INSERT INTO mgw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Payomwi lyo aatikwabakia, “Ywaku' mukipi'nga sinu, ywembe mwana wake au ng'ombe wake mana atumbuki mulu'si' alu'e kunnopwali, mwanjaa ya lisu'ba lya Sabato?” ");
INSERT INTO mgw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nabembe baakombwili kunnyangwa lyaalalwiye. ");
INSERT INTO mgw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu paabweni balu' babasawa tama muiti'gu' ya nnu'ngi' mana bakokilwe. Alongei nabo kwa lukongo lu'no. ");
INSERT INTO mgw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mana mundu akukokite palisengele kanewatame pandu pa isima. Pi'ngi' akokilwe mundumuko kulikoni wenga, ");
INSERT INTO mgw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","mwene kaya aisa na kukubakia, ‘Wenga ukatuke, unneki kiti'gu' ayu'!’ Apo, walu'a kwibona oni paminyo ga bandu boti na wayenda tama pakitamo sa nsu'gu'. ");
INSERT INTO mgw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ila, mana ukokilwe pakalamu, waatame pakiti'gu' sa nsu'gu', li'nga mwene kiyambo paaisa, akubakie, ‘Mbwiga lyangu', potamiye panogeli lili, sotame pano palu'ngi' panannoga.’ Apo, walu'a peyelwa isima nnu'ngi' ya bandu boti botami nabo pamope. ");
INSERT INTO mgw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mwanjaa ywoywoti ywaiu'bu'ya mwene alu'a uluyilwa na ywaiuluya, alu'a u'bu'yi'lwa.” ");
INSERT INTO mgw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kai' aammakie yu'lu' ywankokite, “Mana kaupala panga kalamu ibe muntwekati au kitamwiyo, kanewakoke mambwiga sika, alongo, babatama papipi yako, bababile matayili. Manaitei nyo yapanga wenga bakuki'li'bu'kiye sawapangile. ");
INSERT INTO mgw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Saupalikwa panga, mana kopi'ya kalamu wakoke aki'ba, alemau, itewe na atu'lu'ka minyo. ");
INSERT INTO mgw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nawenga wayaliwa mwanjaa abo bawakokite, ntu'pu' sawaki'li'bu'ki'yi'lwa. Nnu'ngu' alu'a kuli'pa upo yako nsimu wo yu'ka bandu bene aki.” ");
INSERT INTO mgw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yumo ywa balu' babaatami na Yesu kabalya aatikummakia, “Nantali mundu yu'lu' ywalu'a lya kilyo mu Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu ngammakia, “Mundu yumo aapangite kalamu ngu'lu' na aakokite bandu baingi. ");
INSERT INTO mgw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Paliikite lisu'ba lya kalamu, antumike mpangakasi wake akaabakie babakokilwe, ‘Mwise ku'no kila kili'be kitami wiso.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakini kila mundu ywaakokilwe aatumbwi piya kitumbu no lu'ba lasi. Ywaalongoli kummona aammakie mpangakasi, ‘Nenga nipi'mite nng'unda kwa nyo, nipalikwa nikaubone, nikulu'ba unisami bai.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ywi'ngi' aatibaya, ‘Nipi'mite ng'ombe ku'mi bo li'mya na niyenda kunng'unda kwapakia, nilu'ba lasi unisami bai.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na ywi'ngi' abaike, ‘Niuma gamba nnwawa kwa nyo, nikombwali isa.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mpangakasi ywo aatibuyangana na kummakia bwana wake makowe go. Yu'lu' mwene nyumba aatiusika, ngammakia mpangakasi wake, ‘Uyende kiyu'ngu'ya kusimbasimba na kumali'la ga kumisengo ukaalete mono nnyumba aki'ba, itewe, atu'lu'ka minyo na bi'ngi' babalemile.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bu'kapo mpangakasi ywo ngabaya, ‘Bwana, bandu nabakiye kati mwoamulise, lakini balo banatwi'lyali.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yu'lu' bwana aammakie kai' mpangakasi wake, ‘Uyende kusimbasimba na mumali'la gagayenda mbwega ya misengo, ukaalasimise bandu bayingi li'nga liiku'ta lyangu' litwi'li. ");
INSERT INTO mgw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kwa nyo nendakummakianga, ntu'pu' ata yumo mwa balu' babakokilwe ywalu'a paya kalamu yangu'.’” ");
INSERT INTO mgw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Apo ipi'nga yambone ilongwanage pamope na Yesu. Bai, aagalambuki bandu na kwabakia, ");
INSERT INTO mgw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mundu ywoywoti mana kaisa kwangu' apalilwa kunipenda nenga kulikoni tati' bake, mau' bake, nnyumbowe, bana bake, nku'we na akina lu'mbu'be, kai' ata mwene. Mana akotwike kombwa panga go, apangali mwanamasi' wangu'. ");
INSERT INTO mgw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Mundu ywakotoka pu'twa nsalaba wake na kunibi'ngi'ya, akombwali panga mwanamasi' wangu'. ");
INSERT INTO mgw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ywaku' kasinu, ywembe mana kaapala senga nsengo nku'lu', akombwali wi'ti' balanga mbanje yaipalikwa, li'nga atange panga yabile nayo, yali'ngana yomolya senga? ");
INSERT INTO mgw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mana buli, mana ayomwi senga pai' bai no kotoka yomolya, bandu balu'a kumweka. ");
INSERT INTO mgw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kababaya, ‘Mundu yu' aatumbwi senga, lakini akombwili yomolya.’ ");
INSERT INTO mgw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Au', nkulungwa ywaku' ywayenda ku'mbwana ngondo na nkulungwa nnyine, ywasomwa wi'ti' gania panga yesi lyake lyene banayesi elupu ku'mi, likombwa otwa kwa yu'lu' mwene banayesi elupu isilini? ");
INSERT INTO mgw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mana aibweni ankombwali, alu'a kwatuma bandu bo yenda panga masikisano pakemu, yu'lu' nnyine abile balo kuutalu. ");
INSERT INTO mgw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bai, mwenga nyinyonyo, ntu'pu' ata yumo ywakombwa panga mwanamasi' wangu' mana asindwi kukilekekeya kila kili'be sabile naso. ");
INSERT INTO mgw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyo unogite, lakini mana unogau wake wobite, ulu'a galambuyilwa buli li'nga kilyi'lyi' sake kibuye? ");
INSERT INTO mgw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Upwaikali kwa ukando ata kwa mbolya. Bandu bendakuuyita. Bai, mwene makutu go yu'wa ayu'we.” ");
INSERT INTO mgw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lisu'ba limo, alonga koli na bene sambi baingi baayi'i kumpi'kania Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na balimu ba salya baatumbwi ku'ku'li'ka, “Munninguli mundu yu'! Aakemya bene sambi, no lya nabo nkungu gumo.” ");
INSERT INTO mgw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu aayangwi kwa lukongo, ");
INSERT INTO mgw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ati', mundu yumo kati yinu mana abile na ngondolo mya, mana aobite yumo, alu'a panga buli? Aaleka balu' tisini na kenda mmwitu, no yenda kumpala yu'lu' ywaobite mpaka ammone. ");
INSERT INTO mgw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mana amweni, alu'a kumpu'twa palipamba kwo napusika. ");
INSERT INTO mgw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Paaika kasake, aakema mambwigalye na kwabakia, ‘Munapusike pamope nanenga kwa mwanjaa yu'lu' ngondolo wangu' ywaobite nimweni.’” ");
INSERT INTO mgw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu aayendeli longela, “Mwenga nendakumakia, kwalu'a baa na pulaa kunani kwa mundu yumo mwene sambi buyangania kwa Nnu'ngu', kulikoni bandu tisini na kenda bene aki bapalilwali kummuyangania Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Au mwibona buli? Tubaye nnwawa nsi'si' abi na ela ku'mi ya mapeni, mana aobiye yimo, alu'a panga buli? Alu'a koya lumuli na kwipyaya nyumba yoti ku'no kalolekeya mpaka aibone. ");
INSERT INTO mgw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mana aibweni, aakema mambwiga na bandu ba papipi nakwe no baya, ‘Munapusike pamope nanenga kwa mwanjaa niibweni yi'lu' ela yangu' yayaobite.’ ");
INSERT INTO mgw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na mwenga nendakummakia, ngamo baanapusika malaika ba Nnu'ngu' kwa kummona mwene sambi yumo kammuyangania Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu aayendeli longela, “Kwai na mundu yumo aabile na bana abi'li' analu'me. ");
INSERT INTO mgw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yu'lu' nnuna aabakie tati' bake, ‘Tati', mumbei ulisi wangu'.’ Nembe ayi'ki'ti kwabagana mali yake. ");
INSERT INTO mgw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gaapite masu'ba bai, yu'lu' nnuna aapi'miye ulisi wake no yabwa mwanja wa nni'ma wa kuutalu na yi'lu' mbanje yaapatike. Akwo, aatikwinyamana yi'lu' mbanje. ");
INSERT INTO mgw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Payomwi tumya kila kikowe, kwapitike njala ngali' kunni'ma wu'lu', nembe ngatumbwa auka kwo pala kilyo. ");
INSERT INTO mgw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aalu'bike kibalua kwa mundu yumo ywa kunni'ma wo, nembe aampei lyengo lyo kwapeya yakulya magu'be kunng'unda wake. ");
INSERT INTO mgw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aminyikiage ata lya makabanda gabalyage magu'be mwanjaa, aabile ntu'pu' mundu ywa kumpeya kilyo sosoti. ");
INSERT INTO mgw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Paapatike malango aatigania, ‘Mboni kwa tati' bangu' kubile na apangakasi baingi babalya no igaya, nenga niwaa njala? ");
INSERT INTO mgw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nilu'a buyangania kwa tati' bangu' na kwabakia, Tati', ninkosile Nnu'ngu' na mwenga. ");
INSERT INTO mgw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nili'nganili ata kemelwa na mwana winu. Munipange kati yumo ywa apangakasi binu.’ ");
INSERT INTO mgw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bai, ngatumbwa mwanja wo buyangania kwa tati' bake. Kaegelya pakaya tati' pabamweni mwana, bammi'ki kiya, ngabammutukya, kunkumbatya na kunnonia. ");
INSERT INTO mgw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mwana aabakie tati' bake, ‘Tati', ninkosile Nnu'ngu' na mwenga. Nili'nganili ata kemelwa na mwana winu.’ ");
INSERT INTO mgw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lakini tati' bake ngaabakia apangakasi bake, ‘Kiyu'ngu'ya! Mulete ngu'bo inannoga mukang'walike! Mung'walike lupete na ilatu. ");
INSERT INTO mgw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Musinje likinda lyalinenipe tulye no panga si'li'ku'si'li'ku'! ");
INSERT INTO mgw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwa mwanjaa ayu' mwana wangu' aatiwaa, kumbe balo mwu'mi, aatioba, lakini nambi'yambi' abonekine.’ Batumbwi si'li'ku'si'li'ku'. ");
INSERT INTO mgw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Pagapangikage go, nku'we aai anagobwali bu'ka kunng'unda. Paabile mundi'la kaegelya pansengo, ngayu'wa ilulu na ngoma. ");
INSERT INTO mgw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ankemite mpangakasi yumo na kunnaluya, ‘Kubile na namani?’ ");
INSERT INTO mgw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aywo mpangakasi, aatikunnyangwa, ‘Nnunago agobwile na tati' binu bansinjili likinda lyaliatike, kwa mwanjaa amweni abile salama salimini.’ ");
INSERT INTO mgw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aywo nku'we ngausika, aakani ata yingya nnyumba. Tati' bake pabaapiti panja, baatikuntebeya ayingi nnyumba. ");
INSERT INTO mgw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lakini ywembe annyangwi, ‘Linga! Myaka yoti nitikuntumikia kati nammanda winu, nati'kwanali amuli yinu ata lisu'ba limo! Munipei namani? Munanipeyali ata likinda lya mbwi yumo, nani nipange si'li'ku'si'li'ku' na mambwiga bangu'! ");
INSERT INTO mgw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini mwana winu yu', ywalile mali yinu kwo nyamana li'no isa bai munsinjile li'lu' likinda lyalinenipe!’ ");
INSERT INTO mgw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tati' bake batikunnyangwa, ‘Wamwana wangu', wenga ubile pamope nanenga masu'ba goti na kila sanibile naso sako. ");
INSERT INTO mgw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Twaapalikwe tupange si'li'ku'si'li'ku' no napusika, kwa mwanjaa ayu' nnunago aatiwaa, kumbe balo mwu'mi, aatioba, lakini nambi'yambi', abonekine.’” ");
INSERT INTO mgw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ngaabakia banamasi' bake, “Tayili yumo aabile na mwandiki wake. Aywo mwandiki aatisongelwa mwanjaa, aatinyamana mali ya tayili wake. ");
INSERT INTO mgw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yu'lu' tayili ngankema na kummakia, ‘Aga makowe gaku' ganigayu'wa kasako? Upiye na ubalange mabi'ko na matumyo kwa mwanjaa ukombwali panga wamwandiki wangu' kai'.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yu'lu' mwandiki ngagania, ‘Bwana wangu' anibi'ngite mulyengo lya uandiki, nipange buli? Yenda li'ma nikombwali no lu'balu'ba kati nki'ba oni. ");
INSERT INTO mgw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bai nitangite lyo panga, li'nga panabi'ngi'lwa mulyengo bandu banikemi kasabe.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bai ngaakema yumoyumo babalongelwage na bwana wake, ngammakia yu'lu' ywalongolile. ‘Ulongelwa ili'nga na bwana wangu'?’ ");
INSERT INTO mgw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ywembe ngannyangwa, ‘Ilu'yo mya ya mauta ga njaituni.’ Yu'lu' mwandiki ngammakia, ‘Utole seti sako solongelwa na wandike amusini.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bu'kapo ngannaluya ywi'ngi', ‘Wenga ulongelwa ili'nga?’ Ngannyangwa, ‘Mabunia mya ga ngano.’ Yu'lu' mwandiki ngammakia, ‘Utole seti sako solongelwa na wandike samanini.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bai, yu'lu' bwana aatikunnumba aywo mwandiki ywangaaminika, kwa mwanjaa atumi malango na ung'anga. Kwa mwanjaa bandu ba dunia yi'no bai na malango na ung'anga muno mumakowe gabe, kuliko bandu ba mubweya.” ");
INSERT INTO mgw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu ngayendelya baya, “Nimmakianga, mwipangi mambwiga bu'kana na mali ya dunia, li'nga pamwayomokelwa, baampokyange muutamo wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ywoywoti ywau'bi'li'ka mumakowe masene, aau'bi'li'ka mumakowe maku'lu' na ywa kotoka au'bi'li'ka mumakowe masene, mumakowe maku'lu' aau'bi'li'kali. ");
INSERT INTO mgw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bai, mana mutei mwu'bi'li'kali kwa mali ya ulau ya padunia, nyai ywalu'a kunkamukia mali ya kakape? ");
INSERT INTO mgw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mana mutei mwu'bi'li'kali mumali ya mundu ywi'ngi', nyai ywalu'a kunkamukia mali yinu mwabene? ");
INSERT INTO mgw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ntu'pu' ntumisi ywakombwa kwatumikia mabwana abi'li', kwa mwanjaa alu'a kunsukwa yumo na kumpenda ywi'ngi' au ayi'ki'tyana na yumo na kunsalawa ywi'ngi'. Mukombwali kuntumikia Nnu'ngu' na mali.” ");
INSERT INTO mgw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayo pabagayu'wine go nabembe baai apenda mbanje, ngabansalawa Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Apo ngaabakia, “Mwenga mwilaya pabandu, panga mwaannogau, lakini Nnu'ngu' aitangite myoyo yinu. Kwa mwanjaa sakibonekana sangama pabandu, Nnu'ngu' akibona undi bai. ");
INSERT INTO mgw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Salya na maandiko ga alondoli ba Nnu'ngu' gaabile mpaka nsimu wa Yoani Ywabatisage. Bu'kapo, Ukulungwa wa Nnu'ngu' wendaalilwa, na kila mundu auyingya kwa makakala. ");
INSERT INTO mgw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nantali kunani na dunia pi'ta, kuliko bu'yi'lwa liyi'gi'yo limo lya salya. ");
INSERT INTO mgw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ywoywoti ywampeya nnyumbowe talaka no kobeka ywi'ngi', apanga upege, na ywoywoti ywankobeka nnwawa ywapeyilwe talaka, apanga upege. ");
INSERT INTO mgw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Pai na mundu yumo tayili, ywawalage ngu'bo ya bei ngu'lu' ya lukanda lwa sambalau. Mundu ywo atumyage mbanje yambone kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na paniango wa ywo tayili kwai na nki'ba yumo lina lyake Lasali, ywabile na mabanga. ");
INSERT INTO mgw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasali aminyikiage peyelwa mbolotya yaitu'mbu'ka pamesa ya aywo tayili, kai' mapwa bendeisa no lambata mabanga gake. ");
INSERT INTO mgw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Bai, yu'lu' nki'ba paawile, malaika ngabantola na kummi'ka pakyuba sa Bulaimu. Na yu'lu' tayili nembe ngawaa no sikilwa. ");
INSERT INTO mgw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aywo tayili, aai mungu'su'mbu' akwo kumambi', palolekiye kunani, ngammona Bulaimu kuutalu abile nakwe Lasali. ");
INSERT INTO mgw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bai, ngakema, ‘Tati' Bulaimu, mumbi'ki kiya, muntume Lasali asuye lukonji lwake mumasi', aniu'lu'ki'ye mululimi lwangu', kwa mwanjaa nendalumya muno mumwoto gu'no.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bulaimu ngannyangwa, ‘Mwana wangu', uku'mbu'ki wapoki ganannoga mubwu'mi wako, lakini Lasali apoki maakau. Nambi'yambi' nembe endapu'mu'lya nawenga wendalumya. ");
INSERT INTO mgw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na kai', pakati yitu na mwenga pabi'kilwe lyi'mbwa liku'lu', li'nga babapala isa kwinu bu'ka ku'no kanebakombwe na babapala bu'ka kwinu isa kwitu kanebakombwe.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yu'lu' ywabile tayili ngabaya, ‘Bai Tati', ninnu'ba muntume Lasali ayende pansengo wa tati' bangu', ");
INSERT INTO mgw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwa mwanjaa nibi na aku'bangu' batano, akaakwi'li'ke, baakaneisa pandu pano pene ngu'su'mbu'.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Lakini Bulaimu ngayangwa, ‘Aku'bo babi na Musa na alondoli ba Nnu'ngu', waleke baapi'kani bo.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lakini ywembe ngabaya, ‘Nyinyoli tati' Bulaimu, ila mundu mana aayu'ka bu'ka kumambi' no yenda kwakwi'li'ka, baagalambuka.’ ");
INSERT INTO mgw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bulaimu ngabaya, ‘Mana baayu'wali Musa na alondoli ba Nnu'ngu', ata mundu ywaayu'ka bannyu'wali.’” ");
INSERT INTO mgw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Apo, Yesu ngaabakia banamasi' bake, “Inonwipe kotoka pitya iku'balo ya sambi, lakini akibona yu'lu' ywalu'a piya iku'balo ya kumpangia mundu sambi. ");
INSERT INTO mgw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mundu kati ywo yai nantali kuntabya liwe lya lwaga paingo na kuntumbukia mubaali, kulikoni kumpangia sambi yumo ywa anangu'ta ba. ");
INSERT INTO mgw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mwili'ndi'le, ‘Manaitei nnongo akukosile, unkwi'li'ke na mana akuyu'wine unsami.’ ");
INSERT INTO mgw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na mana akukosya mala saba kwa lisu'ba na kukuki'li'bu'kya kwo lu'ba nsama mala saba ipalikwa unsami.” ");
INSERT INTO mgw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atumilwe ngabammakia Bwana, “Utuyongekeye imani.” ");
INSERT INTO mgw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bwana ngayangwa, “Mukaba na imani alau njene kati lupeke lwa nkongo wa aladali, mupekombwa kuubakia nku'yu' gu', uyokoke na ukayokekelwe mubaali na wembe ulu'e kunnyu'wa. ");
INSERT INTO mgw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tubaye mundu yumo ai na ntumisi ywali'ma nng'unda au sunga ngondolo. Buli, paabuya kwo, alu'a kummakia ntumisi, ‘Uegeli kiyu'ngu'ya saulye?’ ");
INSERT INTO mgw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lili! Alu'a kummakia, ‘Uniyupuli kilyo na wibi'ke wiso kwo ndumikia mpaka panaayomwa lya no nywa, nga wenga walye no nywa.’ ");
INSERT INTO mgw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mulu'e kummakiali posaa aywo ntumisi kwa mwanjaa apangite kati mwaabakiyilwe? ");
INSERT INTO mgw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na mwenga nyinyonyo pamwayomwa panga goti gamubayilwe, mwabaye, ‘Twenga twatumisi bai, tupangite galu' gatupalikwe tupange.’” ");
INSERT INTO mgw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu paabile mumwanja kayenda ku Yelusalemu, api'ti mumipaka ya ku Samalia na ku Galilaya. ");
INSERT INTO mgw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Paabile kaika pakilambo simo, akwembine na bandu ku'mi bene matana, bayi'mi kuutalu. ");
INSERT INTO mgw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ngabatu'ndu'bi'ya malobe kababaya, “Yesu, wa Mpi'ndo, utubi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Paabweni ngaabakia, “Muyende mukailaye kwa api'ndo ba dini.” Bai, pabaabile kabayenda, ngabapeleteka. ");
INSERT INTO mgw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumo mukipi'nga sabe paibweni apeletike, aatiki'li'bu'ka kannumba na kunkwi'ya Nnu'ngu' kwa lilobe liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Agonjike pai' wakukama nnu'ngi' ya magu'lu' ga Yesu ku'no kansukulu. Aywo aai Nsamalia. ");
INSERT INTO mgw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Apo Yesu ngalaluya, “Nengite naapeletiye bandu ku'mi? Balu' kenda bai kwaku'? ");
INSERT INTO mgw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Abonekineli ywi'ngi' ywaki'li'bwike kunsukulu Nnu'ngu' ila aywo nng'eni Nsamalia bai?” ");
INSERT INTO mgw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu ngammakia aywo mundu, “Uyi'me, uyende kasako, imani yako ikupeletiye.” ");
INSERT INTO mgw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nsimu gumo Mafalisayo bannalwiye Yesu, “Ukulungwa wa Nnu'ngu' waisa pakubawi?” Ywembe ngayangwa, “Ukulungwa wa Nnu'ngu' wisali kwo bonekana. ");
INSERT INTO mgw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wala ntu'pu' ywakombwa baya, ‘Wi pano,’ au', ‘Wi palu'.’ Kwa mwanjaa Ukulungwa wa Nnu'ngu' wi nkati yinu.” ");
INSERT INTO mgw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bu'kapo ngaabakia banamasi' bake, “Masu'ba gendaisa pamwalu'a minyikia kulibona lisu'ba limo lya Mwana wa Mundu, lakini mwalibonali. ");
INSERT INTO mgw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bandu balu'a kummakianga, ‘Ai palu'!’ au, ‘Ai pano!’ Lakini mwenga kanemwabu'ke wala kanemwaki'ngame. ");
INSERT INTO mgw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maana kati njai mwaibeyulya ngamwalyalu'a baa lisu'ba lya Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini alu'a tumbwa wi'ti' baa mungu'su'mbu' no kanilwa na lubelekwo lu'no. ");
INSERT INTO mgw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kati mwawabile nsimu wa Nuu, ngamwawalu'a baa nsimu wa masu'ba ga Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bandu baayendeli lya no nywa, kobeka no ku'nda mpaka nsimu wa Nuu payingi musapina. Ngaupita nkukulo no langanyika boti. ");
INSERT INTO mgw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yapanga kati mwayabile kwa Lutu. Bandu bai kabalya no nywa, pi'ma no pi'mi'ya, kena no senga. ");
INSERT INTO mgw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lisu'ba li'lu' lyabu'i Lutu Sodoma, mwoto wa bwaluti na kibi'li'tu' watei kwenda nia, kati ula kauluka bu'ka kunani, na kwalangamisa boti. ");
INSERT INTO mgw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngamwalyalu'a baa lisu'ba li'lu' lyoumukulwa Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Lisu'ba lyo, ywoywoti ywalu'a baa pamwagala kaneauluke yenda tola mali yake nnyumba na ywalu'a baa kunng'unda kaneaki'li'bu'ke nsu'gu'. ");
INSERT INTO mgw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muku'mbu'ki gagampatike nnyumbowe Lutu. ");
INSERT INTO mgw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ywoywoti ywapala kuukosopolya bwu'mi wake alu'a kuobeya na ywoywoti ywaalu'a kuuobeya alu'a kuukosopolya. ");
INSERT INTO mgw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nimmakianga panga, lisu'ba lyo bandu abi'li' baagonja pamope, yumo atolelwa na ywi'ngi' alekelwa. ");
INSERT INTO mgw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Alwawa abi'li' bapanga pamope kabayaga, atolelwa yumo na ywi'ngi' alekelwa.” ");
INSERT INTO mgw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Apo nga bannaluya, “Bwana, nga kwaku'?” Naywembe ngaabakia, “Papabile na ntwi ngapabakongolekana tai.” ");
INSERT INTO mgw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bu'kapo Yesu aasimuli lukongo li'nga kwalaya panga ipalikwa lu'ba Nnu'ngu' kila lisu'ba pangali totokelwa. ");
INSERT INTO mgw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ngabaya, “Munni'ma gumo kwai na akimu ywangali kunkilikitya Nnu'ngu' wala kumpi'kania mundu. ");
INSERT INTO mgw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Munni'ma wowowo, kai' kwai na mau' yumo nng'wi'li'kwa na nsengowe, ywakoyage kwa akimu ywo kunnu'ba li'nga apate aki yake bu'ka kwa nndumu wake. ");
INSERT INTO mgw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa masu'ba gambone aywo akimu apendili kumpeya aki yake yu'lu' nng'wi'li'kwa, lakini kuundi'la ngaibakia, ‘Pamope no panga nenga ninkilikityali Nnu'ngu' wala napi'kaniali bandu, ");
INSERT INTO mgw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini kwa mwanjaa nng'wi'li'kwa yu' endaniauya, nilu'a kumpeya. Mana ngotwike aayendelya kuniauya mpaka totokelwa!’” ");
INSERT INTO mgw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bai, Bwana ngayendelya baya, “Mupi'kaniange mwaalongei yu'lu' akimu nnau. ");
INSERT INTO mgw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mubaya, Nnu'ngu' alu'a kotoka kwayi'mya balu' baasawile, babanni'lya kilo na muntwekati? Aselewa kwapi'kania? ");
INSERT INTO mgw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nimmakianga alu'a kwayi'mya kiyu'ngu'ya. Nsimu waaisa Mwana wa Mundu alu'a kwikwemba imani padunia?” ");
INSERT INTO mgw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na Yesu ngaabakia kai' lukongo balu' babaibona anogau na kwasalawa bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bandu abi'li' baayi'i lu'ba kulua lwa Nyumba ya Nnu'ngu'. Yumo aai Mfalisayo na ywi'ngi' nnonga koli. ");
INSERT INTO mgw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aywo Mfalisayo ngayi'ma pakisake no lu'ba, ‘Wa Nnu'ngu', nendakusukulu kwa mwanjaa nenga, kati bandu bi'ngi' lili, bababile abwimi, abu'su' na apege. Kai' nenga kati ayu' nnonga koli lili. ");
INSERT INTO mgw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nenga nendapunga mala ibi'li' kwa juma, nipiya salaka na saka ya mabi'ko gangu'.’ ");
INSERT INTO mgw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini yu'lu' nnonga koli, ngayi'ma kuutalu na aakombwili tu'ndu'bi'a minyo gake kunani, ila aatikotima no ku'ku'li'ka kabaya, ‘Wa Nnu'ngu', unibi'ki kiya nenga na mwene sambi.’ ");
INSERT INTO mgw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nimmakianga, yu'lu' nnonga koli aki'li'bu'ki kaya asamilwe. Lakini yu'lu' ywi'ngi', asamilweli. Kwa mwanjaa ywaiu'bu'ya aulu'yi'lwa na ywaiuluya au'bu'yi'lwa.” ");
INSERT INTO mgw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bandu ngabannetya Yesu bana anangu'ta li'nga akunywe kwa maboko li'nga kwaayalya. Banamasi' pabaabweni, baatikwakanikiya kwa ukali'. ");
INSERT INTO mgw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakini Yesu aatikwakema ngabaya, “Mwaleke abo bana baise kasangu', kanemwakanikie, kwa mwanjaa Ukulungwa wa Nnu'ngu' nga wa bandu kati baa. ");
INSERT INTO mgw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nimmakianga kakape, mundu ywoywoti ywakotoka pokya Ukulungwa wa Nnu'ngu' kati bana anangu'ta, ayingyali mu Ukulungwa wo.” ");
INSERT INTO mgw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kolongosi yumo wa Kiyahudi, ngannaluya Yesu, “Mwalimu nnogau, nipange buli li'nga niupate ukoto wangayomoka?” ");
INSERT INTO mgw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ngammakia, “Mboni unikema na nnogau? Ntu'pu' ywai nnogau ila Nnu'ngu' kisake. ");
INSERT INTO mgw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uitangite amuli, ‘Keneube wampege, Kaneubulage, kaneuyibe, Keneukong'ondeli makowe ga ubu'su', waisimu tati' na mau' bako.’” ");
INSERT INTO mgw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ywembe ngabaya, “Ago goti nigakamwile bu'ka kuunangu'ta wangu'.” ");
INSERT INTO mgw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu pagayu'wine go, ngammakia, “Balo upalikwa panga kili'be simo. Upi'mi'ye kila kili'be sobile naso na kwabagana aki'ba mbanje yo na walu'a ba na amana kunani, bu'kapo uniki'ngame.” ");
INSERT INTO mgw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yu'lu' mundu paagayu'wine go, aatinyopa muno kwa mwanjaa aai tayili muno. ");
INSERT INTO mgw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu paamweni kanyopa muno, ngabaya, “Atayili yingya mu Ukulungwa wa Nnu'ngu' kunonwipe. ");
INSERT INTO mgw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Male ngamiya yingya mulipoyo lya singano, kulikoni tayili yingya mu Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Balu' bandu pabagayu'wine go, ngababaya, “Nyai ywalu'a kosopolelwa?” ");
INSERT INTO mgw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ngayangwa, “Gagakotoka kombolwa na mundu, kwa Nnu'ngu' gendakombolwa.” ");
INSERT INTO mgw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nembe Petili ngannaluya, “Na twenga, buli? Tuilei ili'be yitu yoti tukuki'ngime wenga!” ");
INSERT INTO mgw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu ngaabakia, “Kakape nimmakianga, mundu ywoywoti ywaulei nsengo wake, au nnyumbowe, au nnongowe, au abelei bake, au bana kitumbu sa Ukulungwa wa Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","alu'a pokya gambone nambi'yambi' na ukoto wangayomoka pawaisa.” ");
INSERT INTO mgw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ngayenda nabo pambwega balu' ku'mi na abi'li' ngaabakia, “Mupi'kani wi'ti'! Tuyenda ku Yelusalemu na akwo, kila sakiandikilwe na alondoli ba Nnu'ngu' kwa Mwana wa Mundu kikatimya. ");
INSERT INTO mgw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwa mwanjaa alu'a kamukiyilwa kwa bandu bangali Ayahudi nabembe balu'a kunsalanga, kumpwi'wa na kumwunia mataa. ");
INSERT INTO mgw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Balu'a kunku'mbwa bokola na kummulaga, lakini lisu'ba lyenetatu alu'a yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lakini bembe bakwipwili likowe lyo ata pasene, kwa mwanjaa sateiyilwa kikomekeyo sa makowe go na baatangiteli gagaalongelikwe. ");
INSERT INTO mgw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pai papipi na ku Yeliko, kwai na mundu yumo mbulibuli atami mundi'la kalu'balu'ba. ");
INSERT INTO mgw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Paayu'wine lipi'nga lya bandu kalipi'ta ngalaluya, “Kubile na ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngabammakia, “Yesu wa ku Nasaleti endapi'ta.” ");
INSERT INTO mgw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naywembe ngatu'ndu'bi'ya lilobe kabaya, “Yesu, Mwana wa Daudi, unibi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Balu' babaalongolile, ngabankwi'li'ka na kummakia atame liki. Lakini ywembe ngayendelya tu'ndu'bi'ya lilobe, “Mwana wa Daudi, unibi'ki kiya!” ");
INSERT INTO mgw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu ngayi'ma na kwabakia panga bannete nnu'ngi' yake. Palu' yu'lu' mbulibuli paikite papipi, Yesu ngannaluya, ");
INSERT INTO mgw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Upala nikupangi ki'li'?” Naywembe ngannyangwa, “Bwana, nilu'ba nikombwe lola.” ");
INSERT INTO mgw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ngammakia, “Ulole! Imani yako ikutepwile.” ");
INSERT INTO mgw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na popopo aywo mbulibuli aakombwi lola, ngaanki'ngama Yesu kankwi'ya Nnu'ngu'. Na bandu boti pabagabweni go, bannumbike Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu aikite kunni'ma wa ku Yeliko, ngapi'ta mumali'la ga nni'ma wo. ");
INSERT INTO mgw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Akwo kwai na mundu yumo ywakemelwa Zakayo, aywo aai mundu nku'lu' ywa alonga koli, kai' aai tayili. ");
INSERT INTO mgw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Apalage kummona Yesu, lakini akombwili kummona kwa mwanjaa bandu bai baingi na kyi'mo sake sai kipi. ");
INSERT INTO mgw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kwa nyo, aabutuki nnu'ngi' no u'bu'ka munku'yu' li'nga ammone Yesu, kwa mwanjaa api'ti ndi'la yi'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bai, Yesu paikite palu', ngalola kunani ngammakia, “Zakayo, uuluke kiyu'mbi'ti'ka, kwa mwanjaa li'no nipalikwa ngapiliye kasako.” ");
INSERT INTO mgw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Apo Zakayo ngauluka kiyu'ngu'ya na kunkemya kasake kwo napusika. ");
INSERT INTO mgw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bandu boti pabagabweni go, ngabaku'ku'li'ka no baya, “Ayi'i tama na mundu mwene sambi.” ");
INSERT INTO mgw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo ngayi'ma na kummakia Yesu, “Bwana, upi'kani! Nenga lisinda lya mali yangu' nalu'a kwapeya aki'ba na mana nampokonywi mundu kili'be, nalu'a kunki'li'bu'ki'ya mala nsese.” ");
INSERT INTO mgw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ngammakia, “Li'no ukosopoli wi pansengo gu'no, kwa mwanjaa ayu' naywembe nga ywa lukolo lwa Bulaimu. ");
INSERT INTO mgw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa mwanjaa Mwana wa Mundu aisi pala no kosopolya babaobite.” ");
INSERT INTO mgw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Apo Yesu paabile kaegelya ku Yelusalemu. Bandu babampi'kaniage baganiage panga yaigali pasene bai Ukulungwa wa Nnu'ngu' ulu'e isa. ");
INSERT INTO mgw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kwa nyo, Yesu ngaabakia lukongo lu'no, “Kwai na mundu ywalukolo lwa kikulungwa ywayabwi mwanja, yenda kunni'ma wa kuutalu li'nga pokya utawala wa ukulungwa no buya. ");
INSERT INTO mgw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bai, wai kaapala bu'ka, ngaakema wi'ti' atumisi bake ku'mi na kwapeya mbanje kila mundu na kwabakia, ‘Mupangi nsuluso mpaka panabuya.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini bandu ba palu' baatikunsukwa kwa nyo ngabatuma bandu bayende ku'lu' bakabaye, ‘Tukana kututawala yu'.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Aywo mundumuko aabuyangani kaya wayomwi pokya ukulungwa, popopo ngaabakia balu' atumisi baapei mbanje bakemelwe li'nga atange panga kila mundu abeliye ili'nga. ");
INSERT INTO mgw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ntumisi ywalongolile ngapitya, ngabaya, ‘Bwana, nibeliye ku'mi yi'ngi' ya mbanje yawanipeile.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Naywembe ngammakia, ‘Unogie, wenga nga wantumisi nnogau. Kwa mwanjaa upangite kinannoga mumakowe masene, ulu'a panga wa kolongosi muilambo ku'mi.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ntumisi ywenebi'li' ngaisa kabaya, ‘Bwana, nibeliye yi'ngi' tano ya yi'lu' mbanje yawanipeile.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naywembe ngammakia, ‘Nawenga kai', ulu'a panga wa kolongosi muilambo tano.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ntumisi ywi'ngi' ngaisa kabaya, ‘Bwana, utole mbanje yako, natiiya wiso mukitambala. ");
INSERT INTO mgw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naatiyogopa kwa mwanjaa wenga wa mundu nkali'. Wenga utola yangali yako na uuna yangali kena.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Naywembe ngammakia, ‘Malongelo gako galaya makosa gako, wenga wantumisi nnau! Waatangite panga nenga nankali', nitola yangali yangu' na niuna yangali kena. ");
INSERT INTO mgw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kwa mwanjaa ki'li', ukotwike bi'ka mbanje yangu' kwa bababeleya, nanenga kibuyo nikaisa tola yaibeleyilwe?’ ");
INSERT INTO mgw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Apo ngaabakia balu' bababile palu', ‘Mumpokonywe ayo mbanje, mukampei yu'lu' ywabeliye ku'mi yi'ngi'.’ ");
INSERT INTO mgw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bembe ngabammakia, ‘Lakini Bwana, aywo abile na mali yambone muno!’ ");
INSERT INTO mgw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ywembe ngayangwa, ‘Kila ywabile na kili'be nga ywapeyelwa no yongekeyelwa. Lakini yu'lu' ywangali ba naso kili'be, ata si'lu' sabile naso saatolelwa. ");
INSERT INTO mgw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na nambi'yambi', babanisukwa na babanikana nibe na nkulungwa wabe, mwalete pano, na mwabulage papanopano nnu'ngi' yangu'.’” ");
INSERT INTO mgw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu paayomwi longela go, aatilongolya kalongokeya ku Yelusalemu, ");
INSERT INTO mgw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","paaegeli Bethfage na Betania papipi na Kitu'mbi' sa Minjaituni, aatumike banamasi' bake abi'li', ");
INSERT INTO mgw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ngaabakia, “Muyende kukilambo sakibile nnu'ngi' yinu. Pamwayingya mukilambo, mukankolya mwana mbu'nda ywangakolelelwa na mundu atabilwe. Mumundwe, munnete pano. ");
INSERT INTO mgw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mana alu'a kunnaluya mundu mwanjaa ki'li' mumundwa, mwammakie, ‘Bwana endakumpala.’” ");
INSERT INTO mgw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bai, babatumilwe ngabayenda na baakoli kati mwabaabakiyilwe na Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pabaabile kabamundwa yu'lu' mwana wa mbu'nda, bene ngabaalaluya, “Kwa mwanjaa ki'li' mumundwa mwana mbu'nda yu'?” ");
INSERT INTO mgw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nabembe ngabayangwa, “Bwana endakumpala.” ");
INSERT INTO mgw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bai, ngabampelekya Yesu yu'lu' mwana mbu'nda. Bu'kapo ngabatandika magu'bo gabe panani ya mbu'nda na kumwu'bu'ya Yesu panani yake. ");
INSERT INTO mgw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu payendeli na mwanja, bandu baatandike magu'bo gabe musimbasimba. ");
INSERT INTO mgw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Paaegeli ku Yelusalemu pabwelyo wa Kitu'mbi' sa Minjaituni, lipi'nga lya banamasi' bake ngabatumbwa kwi'ndi'lya na kunkwi'ya Nnu'ngu' kwa lilobe liku'lu', kwa mwanjaa ya makowe maku'lu' gabagabweni. ");
INSERT INTO mgw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ngababaya, “Ayaliwite Nkulungwa ywaisa kwa lina lya Bwana! Amani kunani, utukupu kwa Nnu'ngu' ywabile kunani!” ");
INSERT INTO mgw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Apo Mafalisayo bi'ngi' babaabile mu'lu' mulipi'nga lya bandu ngabammakia Yesu, “Mwalimu, wakanikie banamasi' bako kanebapange ndu'ti!” ");
INSERT INTO mgw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu ngayangwa, “Nimmakianga, mana bakotwike bembe, ata maliwe galu'a kwi'ndi'lya.” ");
INSERT INTO mgw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Paaegeli muno na kuubona nni'ma gu'lu' Yesu aatikuuli'lya. ");
INSERT INTO mgw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ngabaya, “We Yelusalemu, Ukatangage li'noli'no makowe gagaleta amani! Lakini nambi'yambi' gaiyilwe paminyo yako. ");
INSERT INTO mgw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwa mwanjaa masu'ba gendaisa, babakusukwa bakuti'ti'li'ki'a maboma, na kukuibya ndi'la wakane kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bakutimbatimba wenga pamope na bana bako bababile nkati ya ingu'mbi' yako, baakulekyali ata liwe limo panani ya li'ngi', kwa mwanjaa wautangiteli nsimu Nnu'ngu' paakwisili kukuyangatiya.” ");
INSERT INTO mgw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bu'kapo, Yesu aayingi mulua lwa Nyumba ya Nnu'ngu' no tumbwa kwabi'nga asulusi, ");
INSERT INTO mgw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nembe ngabaya, “Iandikilwe, ‘Nyumba yangu' yapanga nyumba yo salilya,’ lakini mwenga muipangite ibe mbango ya apokonyoli.” ");
INSERT INTO mgw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu aai kayi'gana mulua lwa Nyumba ya Nnu'ngu' kila lisu'ba. Api'ndo ba dini, balimu ba salya na alongosi ba bandu baapalike kummulaga. ");
INSERT INTO mgw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lakini bai ntu'pu' lyopanga, mwanjaa bandu boti baai kabampi'kania muno. ");
INSERT INTO mgw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lisu'ba limo, Yesu waabile kaayi'gana bandu mulua lwa Nyumba ya Nnu'ngu' na kwaalya makowe ganannoga, api'ndo ba dini, balimu ba salya pamope na agoi baatiisa, ");
INSERT INTO mgw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ngababaya, “Utubakie! Upanga makowe ga goti kwa utawala waku', kai' nyai ywakupei utawala gu'?” ");
INSERT INTO mgw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ngaabakia, “Nanenga mbala kunnaluyanga. Munibakie, ");
INSERT INTO mgw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","utawala wa Yoani Ywabatisage wabu'kite kwa Nnu'ngu' au bandu?” ");
INSERT INTO mgw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini bembe ngababakiana nnyanya, “Mana tubaite ubu'kite kwa Nnu'ngu', ywembe alu'a tulaluya, ‘Mboni mumwu'bi'li lili?’ ");
INSERT INTO mgw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na mana tubaite ubu'kite kwa mundu, bandu boti ba pano batuku'mbwa maliwe, kwa mwanjaa boti bau'bi'lile panga Yoani aai nnondoli ywa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bai, ngabammakia, “Tutangiteli utawala wo wabu'kite kwaku'.” ");
INSERT INTO mgw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu ngaabakia, “Ata nenga nimmakiangali nigapanga makowe ga kwa utawala waku'.” ");
INSERT INTO mgw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu ngayendelya kwabakia bandu lukongo lu'no, “Mundu yumo ali'mike nng'unda wa minjabibu, na ayaiki aku'li'ma kwa mali'po no yabwa mwanja mpaka kilambo sa kuutalu, atami kwo kwa masu'ba ganambone. ");
INSERT INTO mgw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pa mauno, mundu ywo ngantuma ntumisi wake kwa balu' aku'li'ma bammauli lipungu lya itunda lya mauno ga nng'unda wa minjabibu. Lakini balu' aku'li'ma baatikunku'mbwa ntumisi ywo na kunki'li'bu'ya moko gabule. ");
INSERT INTO mgw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yu'lu' bwana ngantuma kai' ntumisi ywi'ngi', lakini bembe ngabanku'mbwa, bampangi makowe ga oni na kunki'li'bu'ya moko gabule. ");
INSERT INTO mgw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngaantuma kai' ywenetatu, aywo ywembe pabannumiye ngabantaikulya paungo. ");
INSERT INTO mgw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yu'lu' mwene nng'unda ngabaya, ‘Nilu'a panga buli? Nalu'a kuntuma mwana wangu' ywanimpendile, kwaali' ywembe balu'a kunnyu'wa.’ ");
INSERT INTO mgw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Balu' aku'li'ma pabamweni bai, ngababakiana, ‘Ayu' ngalu'a tola ulisi wake, kwa nyo tummulage li'nga ulisi wo upange witu.’ ");
INSERT INTO mgw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bai, ngabampiya paungo ya nng'unda wa minjabibu na kummulaga.” Yesu ngalaluya, “Yu'lu' mwene nng'unda alu'a kwapanga buli balu' aku'li'ma? ");
INSERT INTO mgw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Alu'a isa kwabulaga aku'li'ma bo na kwapeya aku'li'ma bi'ngi' nng'unda wo wa minjabibu.” Bandu wabayu'wine makowe go ngababaya, “Lili! Kanegapite ata pasene!” ");
INSERT INTO mgw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu ngaabu'nju'lya minyo na kwabakia, “Bai, Maandiko Mapeleteu gaalomboli ki'li'? ‘Liwe lyabalikani asengi, nambi'yambi' lipangite liwe liku'lu' lya pakitumembe!’ ");
INSERT INTO mgw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu ywoywoti ywatu'mbu'ka panani ya liwe lyo ati'kwanika ipandeipande na mana lintu'mbu'ki mundu ywoywoti, lyantimba.” ");
INSERT INTO mgw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Balimu ba salya na api'ndo ba dini baatangite panga lukongo lwo lwali'ngage bembe, kwa nyo bapalage kummoywa papalu'palu', ila bayogwipe bandu. ");
INSERT INTO mgw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bai, ngabaupala nsimu waupwaika. Ngabaatuma bandu baku'pi'ki'ye panga anogau, bampekeseni Yesu kwa kunnaluya, li'nga bammoywe na kunkamukia kwa alongosi ba silikali. ");
INSERT INTO mgw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bandu bo ngabammakia, “Mwalimu, tutangite panga wendalongela no yi'gana makowe ga kakape, kai' wenga ubawali bandu, uyi'gana kakape ndi'la ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bai, utubakie yendayi'ki'ti'lwa mu salya ya Musa li'pa koli kwa Kaisali?” ");
INSERT INTO mgw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu akwipwile kitapa sabe ngaabakia, ");
INSERT INTO mgw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Munilaye lwela, lubile na kuminyo ya nyai?” ");
INSERT INTO mgw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nabembe ngabannyangwa, “Kuminyo ya Kaisali.” Yesu ngaabakia, “Bai, ga Kaisali mumpei Kaisali, ga Nnu'ngu' mumpei Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bakombwili kunnyonja kwa likowe lyolyoti palu' pa bandu, kwa nyo ngabatama liki no sangala mwaayangwile. ");
INSERT INTO mgw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bu'kapo Masadukayo, bababaya panga babawile bayu'kali, bamwisili Yesu, ngababaya, ");
INSERT INTO mgw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mwalimu, Musa atuandiki panga manaitei mundu nsi'si' awile na annei nnwawa nng'wi'li'kwa wangali bana, nnunawe apalikwa antole ywo nnwawa li'nga ampapi nku'we bana. ");
INSERT INTO mgw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ngaipanga, nsimu gumo kwai na akingolo saba. Yu'lu' nku'lu' aatikobeka no waa wangali mwana. ");
INSERT INTO mgw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yu'lu' nnuna ywenebi'li' ywantweti yu'lu' nng'wi'li'kwa naywembe ngawaa kai', ");
INSERT INTO mgw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na nnuna ywenetatu yai nyinyonyo. Makowe gai gagalu'galu' kwa boti saba, boti bawile wangali papa bana. ");
INSERT INTO mgw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kuundi'la na yu'lu' nnwawa ngawaa. ");
INSERT INTO mgw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lisu'ba lyabalu'a yu'yi'lwa babawile, nnwawa ywo apanga nnyumbo wa nyai? Kwa mwanjaa boti saba baankobike.” ");
INSERT INTO mgw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ngaabakia, “Bandu ba nsimu gu'no kobeka no ku'nda, ");
INSERT INTO mgw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lakini balu' bababalangilwa panga baapwaika yu'ka no tama na Nnu'ngu', baakobekali na baaku'ndali. ");
INSERT INTO mgw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kai', bawaali, kwa mwanjaa babaa kati malaika, no baa bana ba Nnu'ngu' kwa mwanjaa bayu'kite muuwi'li. ");
INSERT INTO mgw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini kwa mwanjaa kubile no yu'ka bu'ka kuuwi'li, ata Musa aayi'ki'tile. Mu Maandiko Mapeleteu ga si'lu' kiwi'mbi' sasabile kakiaka mwoto, kaantambwa Bwana kati ‘Nnu'ngu' wa Bulaimu, Nnu'ngu' wa Isaka, na Nnu'ngu' wa Yakobi.’ ");
INSERT INTO mgw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bai, ywembe Nnu'ngu' ywa awi'li lili, ywembe Nnu'ngu' ywa balu' bababile bau'mi, kwa mwanjaa kasake boti bendalama.” ");
INSERT INTO mgw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bi'ngi' ba balu' balimu ba salya ngababaya, “Mwalimu, mwoyangwile ngamwembe.” ");
INSERT INTO mgw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ntu'pu' mundu ywi'ngi' ywalowite kai' kunnaluya gi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu ngaalaluya, “Ibayilwa buli panga Kilisitu ywabayilwe nga mwana wa Daudi? ");
INSERT INTO mgw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi mwene abaya mu Zabuli, ‘Bwana Nnu'ngu' aammakie Bwana wangu', Utame kummalyo gangu', ");
INSERT INTO mgw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka panaalu'a kwabi'ka andumu bako pai' ya magu'lu' gako.’ ");
INSERT INTO mgw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Daudi ankema Kilisitu ‘Bwana,’ kwa nyo, Kilisitu apangali mwana wake bai, ila Bwana wake kai'.” ");
INSERT INTO mgw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu ngaabakia banamasi' bake nnu'ngi' ya bandu boti, ");
INSERT INTO mgw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mwili'ndi'le na balimu ba salya babapenda pi'tapi'ta bawalile makanju malaso. Bapendi pangilwa abali na bandu kwa isima kusoko no tama muitamo ya bandu bako, mu Nyumba ya kunnu'ba Nnu'ngu' na mumasalaka. ");
INSERT INTO mgw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","44 Bapokonywa alwawa awi'li'kwa ku'no kabaku'pi'ki'ya panga anogau kwo sali sala ndaso. Abo baapata ukumu ngu'lu'.” ");
INSERT INTO mgw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu aatikwalingia matayili, ngaabona kabayi'ya salaka yabe mulisanduku lya mbanje ya mulua lwa Nyumba ya Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ngammona mau' yumo nng'wi'li'kwa kayi'ya mo ela njene. ");
INSERT INTO mgw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bai, ngabaya, “Nimmakianga, mau' yu' nng'wi'li'kwa nki'ba ayi'i kiku'lu' mulisanduku kuliko sabayi'i bi'ngi' boti. ");
INSERT INTO mgw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa mwanjaa boti bo bapiyike salaka bu'kana na mali yabe yaipi'tile, lakini mau' yu' muuki'ba wake, ayi'i yoti yabile nayo.” ");
INSERT INTO mgw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bandu bi'ngi' balongelyage makowe ga Nyumba ya Nnu'ngu', mwainemekilwe kwa maliwe ga samani, pamope na upo yaipiyilwe kwa Nnu'ngu'. Yesu ngabaya, ");
INSERT INTO mgw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Aga goti gamugabona, gaaisa masu'ba lyaigalali ata liwe limo panani ya li'ngi', kila kili'be sasengwanilwa.” ");
INSERT INTO mgw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bai, ngabannaluya, “Mwalimu, makowe go gapitya pakubawi? Na kikowe saku' sasalaya panga makowe go gaegelile pitya?” ");
INSERT INTO mgw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ngaayangwa, “Mulinguli mwakanekongelwa. Kwa mwanjaa baingi baisa na kulitumya lina lyangu', kila mundu kabaya panga, ywembe nga nenga no panga nsimu gu'lu' wegelile. Lakini mwenga kanemwakoleye! ");
INSERT INTO mgw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bai, pamwagayu'wa makowe ga ngondo na mayu'mano, kanemwayogope, kwa mwanjaa ago gapalikwa gapi'te wi'ti', lakini matemulyo ga goti gaapanga balo.” ");
INSERT INTO mgw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bu'kapo ngayendelya longela, “Nni'ma gumo waku'mbwana na wi'ngi' na ukulungwa gumo waku'mbwana na wi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kila pandu palu'a panga na malendemo maku'lu' ga bwi', njala na utamwe wa tauni. Kai' kwabaa na makowe maakau na myanju miku'lu' kunani. ");
INSERT INTO mgw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wangapitya ago goti, yalongolya wi'ti' kummoywa mwenga, kummi'ka mungu'su'mbu' no pwatilwa mumayumba ga kunnu'ba Nnu'ngu' na kunnyi'yanga muutabilwe. Mwapelekelwa nnu'ngi' ya akulungwa na atawala kwa mwanjaa ya lina lyangu'. ");
INSERT INTO mgw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Li'nga mukanikong'ondeli kasabe. ");
INSERT INTO mgw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mukangamale mumyoyo yinu, kanemwaganiye pamwapala kwikengya. ");
INSERT INTO mgw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwa mwanjaa nenga namwene nilu'a kumpeyanga milongelo yene malango, ata andumu bako bakukombwali kai' bakutaukyali. ");
INSERT INTO mgw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abelei binu, anuna, alongo na mambwiga binu balu'a kunsongya mwenga na mwabi'ngi' mwalu'a bulagilwa. ");
INSERT INTO mgw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bandu boti balu'a kunsukwanga kwa mwanjaa wa lina lyangu'. ");
INSERT INTO mgw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini, ata lunywili lumo lwa mitwe yinu lwaobali. ");
INSERT INTO mgw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwo komeya kwinu mwalu'a kosopolya bwu'mi winu. ");
INSERT INTO mgw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pamwalu'a kukibona kilambo sa ku Yelusalemu kiti'li'tilwe na mayesi, bai mwatange panga nsimu wisile wo sengwanilwa kwa kilambo so. ");
INSERT INTO mgw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Apo, bababile ku Yudea babutuki muitu'mbi', balu' bababile mukilambo babu'ke na balu' bababile kumigunda kanebaki'li'bu'ki kukilambo. ");
INSERT INTO mgw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwa mwanjaa masu'ba go nga ga ukumu, li'nga goti gagaandikilwe mu Maandiko Mapeleteu gatimi. ");
INSERT INTO mgw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Balu'a kibona atopelwe na babayongeya masu'ba go! Kwa mwanjaa kwalu'a baa na siki ngu'lu' munni'ma na nyongo ya Nnu'ngu' yalu'a kwaisilya bandu bo. ");
INSERT INTO mgw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bi'ngi' babulagilwa kwa lipanga, bi'ngi' batolelwa mateka mumili'ma yoti, na kilambo sa ku Yelusalemu sali'batilwa na bandu bangali Ayahudi, mpaka nsimu wabe pawayomokya. ");
INSERT INTO mgw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kwalu'a baa na myanju mulisu'ba, mwei, na ndondwa. Dunia yoti yaba musiki kwa kitumbu sa kyukala so bu'kana na mwago wo yu'gayu'ga kwa masi' ga baali. ");
INSERT INTO mgw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bandu bainduka kwa mwanjaa ya bwoga, kabalolela makowe gagalu'a pitya, kwa mwanjaa makakala ga kunani galu'a tikatika. ");
INSERT INTO mgw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bu'kapo, baalu'a kummona Mwana wa Mundu kaisa mulyunde, mwene makakala na utukupu wammese. ");
INSERT INTO mgw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pagalu'a tumbwa pitya makowe go mwayi'me no tu'ndu'bi'ya mitwe yinu kunani, kwa mwanjaa kosopolelwa kwinu kuegelile.” ");
INSERT INTO mgw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bu'kapo ngaabakia lukongo lu'no, “Mulolekeye nkongo wa ntini na mikongo yi'ngi' yoti. ");
INSERT INTO mgw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pamwibona panga gatumbwile ipuka maakapi, mwatange panga nsimu wa kyuku wegelile. ");
INSERT INTO mgw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nyinyonyo, pamwagabona makowe go kagapangilwa, mwatange panga Ukulungwa wa Nnu'ngu' wegelile. ");
INSERT INTO mgw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kakape nimmakianga, lubelekwo lu'no lwa nambi'yambi' lwapi'tali wangalipangika ago goti. ");
INSERT INTO mgw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Makowe goti gagabile padunia na panani ya dunia gapi'ta, lakini mayi'gi'yo gangu' gaapi'tali. ");
INSERT INTO mgw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mube minyo, yakanetopelwa myoyo yinu na makowe maakau, lobya na mengo ga bwu'mi gu'no. Mana lili, lisu'ba lyo lyamwisilyanga kwa kiimuimu. ");
INSERT INTO mgw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwa mwanjaa lyamwisilya kati kitapa kwa boti babatama mudunia yoti. ");
INSERT INTO mgw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mutame mwiso bai na mukoye lu'ba Nnu'ngu' li'nga mupate makakala go pi'ta salama mumakowe goti gagalu'a pitya no yi'ma nnu'ngi' ya Mwana wa Mundu.” ");
INSERT INTO mgw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Muntwekati masu'ba go Yesu ayi'ganage bandu mulua lwa Nyumba ya Nnu'ngu', lakini kilo ayendage ku Kitu'mbi' sa Minjaituni no tama kwo. ");
INSERT INTO mgw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bandu boti bayendage mulua lwa Nyumba ya Nnu'ngu' kindai' putiputi li'nga kumpi'kania. ");
INSERT INTO mgw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lisu'ba lya si'li'ku'si'li'ku' ya Makati Gangalu'la, yaikemelwa Pasika, yai kaiegelya. ");
INSERT INTO mgw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Api'ndo ba dini na balimu ba salya baapalike ndi'la ya kummulaga Yesu, lakini baayogopage bandu. ");
INSERT INTO mgw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bai, Ibilisi ngannyingya Yuda Isikalioti, yumo ywa balu' banamasi' ku'mi na abi'li'. ");
INSERT INTO mgw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda aayi'i lagana na api'ndo ba dini na ali'ndi'li ba Nyumba ya Nnu'ngu' mwopanga li'nga kunsongya Yesu kasabe. ");
INSERT INTO mgw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baatinapusika nabembe ngabayi'ki'tyana nakwe kunni'pa mbanje. ");
INSERT INTO mgw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda aayi'ki'tile, ngapala lipala lya kwakamukiya pangali tanga lipi'nga lya bandu. ");
INSERT INTO mgw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bai, Lisu'ba lya Makati Gangalu'la ngaliika. Na alyo nga lisu'ba lyo sinjilwa Mwana wa Ngondolo ywa Pasika. ");
INSERT INTO mgw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Apo Yesu ngaatuma Petili na Yoani, ngaabakia, “Muyende mukatubi'ki wiso si'li'ku'si'li'ku' li'nga tulye Pasika.” ");
INSERT INTO mgw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nabembe ngabannaluya, “Upala tukakubi'ki wiso kwaku'?” ");
INSERT INTO mgw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ngaabakia, “Pi'kani! Pamwalu'a yenda kukilambo, mwakwembana na nnalu'me ywapu'twi kibi'ga sa masi'. Mwanki'ngame mpaka nnyumba ya nyumba yaayingya. ");
INSERT INTO mgw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mwammakie mwene nsengo, ‘Mwalimu endakulaluya, kubi kwaku' kuswi kwo li'lya Pasika nenga na banamasi' bangu'?’ ");
INSERT INTO mgw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naywembe aannangya sumba kiku'lu' kugolopwa sakibi'kilwe wiso, na mwenga mukabi'ke wiso ilyo.” ");
INSERT INTO mgw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bai, ngabayenda, baakikoli kila kili'be kibi kati mwaabakie Yesu, ngababi'ka wiso Pasika. ");
INSERT INTO mgw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saa payikite, Yesu ngatama lya na atumilwe bake. ");
INSERT INTO mgw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngaabakia, “Ndeminyikia muno lya Pasika yi'no pamope na mwe, ku'no kaiegelya saa yo teselwa kwangu'. ");
INSERT INTO mgw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwa mwanjaa nimmakianga panga nailyali kai' mpaka palu' panailya yi'lu' yaitimile pawaika Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bu'kapo ngatola nnobo wa divai no sukulu, kabaya, “Mupokyange, munywe pamope. ");
INSERT INTO mgw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwa mwanjaa bu'ka nambi'yambi' nimmakianga, nainywali kai' divai ya njabibu mpaka pawalu'a isa Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bu'kapo ngatola likati, ngasukulu, ngalimetwana na kwapeya kabaya, “Yi'no nga yi'ga yangu' yaipiyilwa kwa mwanjaa ya mwe. Mwapange nyo kwa kuniku'mbu'kya.” ");
INSERT INTO mgw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngapanga nyinyonyo na nnobo wa divai bu'ka pa kilyo, kabaya, “Kikombe si'no nga lilagano lyayambi' lya myai yangu' yaiyitanika kwa mwanjaa mwenga. ");
INSERT INTO mgw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lakini, mulolange! Yu'lu' ywanisongya ai pamope nanenga pano pamesa. ");
INSERT INTO mgw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kakape Mwana wa Mundu ayenda bulagilwa kati mwabini Nnu'ngu', lakini akibona yu'lu' ywansongya.” ");
INSERT INTO mgw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Apo ngabatumbwa laluyana bene na bene nyai kati yabe ywalu'a panga likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kwapitike ntau kwa abo banamasi' panga nyai ywaganiyilwa baa nku'lu' kuliko bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu ngaabakia, “Akulungwa ba bandu bangali Ayahudi batawala bandu babe kwa makakala, nabembe bakemelwa ayi'mi'li'ki'yi ba bandu. ");
INSERT INTO mgw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini kaneibe nyo kwinu, ila yu'lu' ywabi nku'lu' kwinu apalikwa abe nsene wa boti, na ywabi kolongosi apalikwa abe kati ntumisi. ");
INSERT INTO mgw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tubaye nku'lu' ngaywaku', yu'lu' ywatama pamesa no lya, au yu'lu' ywatumikia? Ngamwembe panga yu'lu' ywatama pamesa no lya! Lakini ata nyo nenga nibi pano pakati yinu kati nantumisi. ");
INSERT INTO mgw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mwenga ngamwabile nanenga nsimu woti wa mapayilwo gangu', ");
INSERT INTO mgw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","kati Tati' bangu' mwabangamukiye ukulungwa, nanenga ninkamukiyanga mwenga ukulungwa. ");
INSERT INTO mgw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mwalya no nywa pamesa yangu' muukulungwa wangu' no tama muiti'gu' ya kikulungwa kuisenwa ngolo ku'mi na ibi'li' ya Isilaili. ");
INSERT INTO mgw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Pi'kania wi'ti'! Ibilisi ayi'ki'tilwe na Nnu'ngu' kumpeeta mwenga kati mundu mwapeeta ngano. ");
INSERT INTO mgw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini nenga nitikulu'bya kwa Nnu'ngu' li'nga imani yako yakanepu'ngwa. Nawenga pawalu'a niki'li'bu'kya, wasenge akina alongobo.” ");
INSERT INTO mgw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petili ngannyangwa, “Bwana, niyi'ki'tile yenda pamope nawenga muutabilwe, na ata waa.” ");
INSERT INTO mgw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ngannyangwa, “Nikubakia wenga wa Petili, kapala bi'ka njogolo li'no kilo walu'a ngana mala itatu panga unitangiteli.” ");
INSERT INTO mgw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bu'kapo, Yesu ngaalaluya banamasi' bake, “Nsimu panantumike wangali pu'twa mpuko wa mbanje wala utingo wala ilatu, mwapu'ngu'kilwe na kili'be sosoti?” Ngabayangwa, “Lili.” ");
INSERT INTO mgw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naywembe ngaabakia, “Nambi'yambi', ywabile na mpuko wa mbanje aupu'twe na ywabile na utingo nyinyonyo. Na ywabile ntu'pu' lipanga, api'mi'ye nganju yake li'nga akapi'me limo. ");
INSERT INTO mgw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nimmakianga gano mayi'gi'yo ga Maandiko Mapeleteu, ‘Aabi'kilwe kipi'nga simo na babaalabiya.’ Makowe ga gaandikilwe kwangu' nenga gapalikwa gatimi.” ");
INSERT INTO mgw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nabembe ngababaya, “Bwana, lola, pano pai na mapanga gabi'li'.” Naywembe ngabaya, “Bai gali'ngani!” ");
INSERT INTO mgw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu pabu'i po kati mwayobelile ngayenda ku Kitu'mbi' sa Minjaituni, na banamasi' bake ngabanki'ngama. ");
INSERT INTO mgw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Paaikite kwo ngaabakia, “Mulu'bange Nnu'ngu' mwakaneyingya mumapayilwo.” ");
INSERT INTO mgw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bu'kapo ngaaleka no yenda kuutalu pasene ngakilikita no lu'ba Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tati', mana mupendile, munibu'ki'ye nnobo gu'. Ata nyo, ibe kati mwamupendi mwenga, kwenda kati mwanipendi nengali.” ");
INSERT INTO mgw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bu'kapo, malaika bu'ka kunani ngampitya li'nga kunyongea makakala. ");
INSERT INTO mgw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Paabile mulwu'ngu' luku'lu', aannu'bite Nnu'ngu' kwa makakala muno, ngalimpita lyusu kati matondwa ga myai, ngalibutuka mpaka pai'. ");
INSERT INTO mgw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Paayomwi lu'ba Nnu'ngu', aki'li'bu'ki banamasi' bake, na akoli bagonjike, kwa mwanjaa baatinyopa. ");
INSERT INTO mgw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ngaabakia, “Mboni mwendagonja? Muyumukange musali, mwakane yingya mumapayilwo.” ");
INSERT INTO mgw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kayendelya longela, ngaliisa lipi'nga lya bandu lilongoyilwe na Yuda, yu'lu' yumo ywa banamasi' ku'mi na abi'li'. Yuda ngayenda kumpanga abali Yesu kwa kunnonia. ");
INSERT INTO mgw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu ngammakia, “Yuda! Unsongya Mwana wa Mundu kwa kunnonia?” ");
INSERT INTO mgw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Banamasi' bake pabagabweni go ngababaya, “Bwana, tukoleli mapanga gitu?” ");
INSERT INTO mgw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yumo kati yabe nganku'mbwa lipanga ntumisi ywa Mpi'ndo Mku'lu' wa dini, ngankata likutu lyake lya kummalyo. ");
INSERT INTO mgw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Apo, Yesu ngabaya, “Kotokaa! Ili'ngani.” Ngalikunywa likutu lya mundu yu'lu', na kuntepwa. ");
INSERT INTO mgw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bu'kapo Yesu ngaabakia api'ndo ba dini, api'ndo ba ali'ndi'li ba Nyumba ya Nnu'ngu' na api'ndo babaisi kummoywa, “Mboni mwisi na mapanga na mandolonga kuniboywa kati nenga nampokonyoli? ");
INSERT INTO mgw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Panaabile na mwenga kila lisu'ba mulua lwa Nyumba ya Nnu'ngu' mwaniboywili!. Lakini, gu'no nga nsimu winu lelo, nsimu wa utawala wa lubi'ndu'.” ");
INSERT INTO mgw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bai, ngabammoywa na kumpeleka kasake mpi'ndo nku'lu' wa dini. Petili anki'ngime nsu'gu' kwa kuutalu. ");
INSERT INTO mgw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mwoto wabi ukunganilwe pakatikati ya luwa. Nabembe batami pamope, na Petili abi pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ntumisi yumo nnwawa paamweni Petili atami kayota mwoto ngammu'nju'lya minyo, kabaya, “Mundu yu' aai pamope na Yesu.” ");
INSERT INTO mgw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petili ngakana no baya, “Wewenga! Nenintangiteli yu'.” ");
INSERT INTO mgw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Baliya pasene, mundu ywi'ngi' ngammona Petili, ngabaya, “Nawenga wanaywembe kati yabe.” Lakini Petili ngayangwa, “Wenga, nenintangiteli!” ");
INSERT INTO mgw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Walipite lisaa limo, mundu ywi'ngi' ngakong'ondelya panga “Ayu' naywembe mwenekaya wa ku Galilaya.” ");
INSERT INTO mgw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petili ngabaya, “Wenga we, ne nikitangiteli ata saukilongela!” Na popopo paabile kalongela, njogolo ngabi'ka. ");
INSERT INTO mgw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bwana Yesu ngagalambuka na kummu'nju'lya minyo Petili, naywembe Petili ngaku'mbu'kya galu' gaabakiyilwe na Bwana Yesu, “Li'no kapala bi'ka njogolo walu'a nikana mala itatu.” ");
INSERT INTO mgw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Apo ngapitya panja, no li'la munomuno. ");
INSERT INTO mgw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Balu' bandu babanni'ndi'lage Yesu, batekunku'mbwa na kunsalanga. ");
INSERT INTO mgw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bantabike kitambala kuminyo, kabannaluya, “Akuku'mbwi nyai? Ebu londwa, tulole!” ");
INSERT INTO mgw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngabampikiya makowe gambone ga kumpwi'wa. ");
INSERT INTO mgw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pakusile, kitamo sa api'ndo ba bandu saatipangilwa na amo bakwembine api'ndo ba dini na balimu ba salya. Yesu ngaletelwa nnu'ngi' ya Balasa Liku'lu' lya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nabembe ngabammakia, “Tubakia wenga nga wa Kilisitu ywabayilwe?” Yesu ngaabakia, “Ata mana nimmakiangite mwaniu'bi'lyali, ");
INSERT INTO mgw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na ata mana ninnaluyangite liswali, mwaniyangwali. ");
INSERT INTO mgw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini bu'ka nambi'yambi', Mwana wa Mundu alu'a tama kummalyo ga Nnu'ngu' mwene makakala.” ");
INSERT INTO mgw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Apo boti ngababaya, “Elo, baya wenga nga wa Mwana wa Nnu'ngu'?” Naywembe ngabaya, “Mubaya panga nenga nga naywembe.” ");
INSERT INTO mgw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nabembe ngababaya, “Buli, balo tukapala usaili wi'ngi'? Twabene tunnyu'wine kalongela munkano wake mwene.” ");
INSERT INTO mgw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bu'kapo, boti ngabayi'ma kumpeleka Yesu nnu'ngi' ya Pilato. ");
INSERT INTO mgw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ngabatumbwa kunsitakya kababaya, “Mundu yu' tunkoli kalemaya bandu bitu, kakana li'pa koli kwa Kaisali na kwikema ati' ywembe nga Kilisitu, Nkulungwa.” ");
INSERT INTO mgw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato ngannaluya Yesu, “Wenga nga wankulungwa wa Ayahudi?” Yesu ngannyangwa, “Wenga ngawaubaya.” ");
INSERT INTO mgw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ngaabakia api'ndo ba dini na lipi'nga lya bandu, “Nikibonali kitumbu sosoti sa kunsenwa ayu' mundu.” ");
INSERT INTO mgw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini bembe ngabakong'ondelya kababaya, “Asopa bandu kwa mayi'gano gake munni'ma woti wa ku Yudea, aatumbuli ku Galilaya, na nambi'yambi' ai pano.” ");
INSERT INTO mgw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato wagayu'wine go, ngalaluya, “Mundu yu' nga mwenekaya wa ku Galilaya?” ");
INSERT INTO mgw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paatangite panga Yesu aai muutawala wa Helode, ngampeleka kwa Helode, ywabile ku Yelusalemu nsimu gu'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode aatipulaika muno paamweni Yesu. Aagayu'wine makowe gake, ila endelolela li'nga ammone kwa minyo gake. Kai', au'bi'lyage kummona Yesu kapanga mangelongelo. ");
INSERT INTO mgw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bai, ngannaluya makowe ganambone kwo kondeya, lakini Yesu ayangwili. ");
INSERT INTO mgw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Api'ndo ba dini na balimu ba salya, baapitike nnu'ngi', na kunsitakya Yesu kwa makakala. ");
INSERT INTO mgw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bai, Helode pamope na asikali bake, ngabamwisia Yesu na kumpangya nsalango. Bu'kapo, ngabang'walika ngu'bo ya kikulungwa, na kunki'li'bu'ya kwa Pilato. ");
INSERT INTO mgw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helode na Pilato babaabile yu'wanganali, lakini bu'ka lisu'ba lyo baabile mambwiga. ");
INSERT INTO mgw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bai, Pilato ngakemya kitamo sa api'ndo ba dini, alongosi na bandu, ");
INSERT INTO mgw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ngaabakia, “Munnetike kasangu' ayu' mundu kamubaya panga aatindigana bandu. Nambi'yambi' pi'kaniange! Wanilokikiye likowe lyo nnu'ngi' yinu, nimwenili na lyakau lyolyoti lyalilandana na masitakyo ginu. ");
INSERT INTO mgw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wala nenga bai lili, ata Helode alibwenili lyakau lyolyoti, na nyo nganki'li'bwiye kasangu'. Ibonekana mpu'la bai panga mundu yu' apangiteli sosoti sakumpangia asenulwe kiwo. ");
INSERT INTO mgw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kwa nyo, nilu'a amulisa ammeselwe mikwasu, bu'kapo nalu'a kunnekekea.” ");
INSERT INTO mgw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Kila lisu'ba lya si'li'ku'si'li'ku' ya Pasika, Pilato yapalikwe kwayu'gu'lya bandu ntabilwe yumo.) ");
INSERT INTO mgw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini boti ngabapanga ndu'ti pamope, “Ummu'ye mundu yu' na utuyu'gu'li Balaba!” ");
INSERT INTO mgw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba aabi'kilwe muutabilwe kwa mwanjaa ayu'maniye bandu panni'ma, kai' aatibulaga. ");
INSERT INTO mgw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato apalike kunnekekea Yesu, kwa nyo ngalongela nabo kai'. ");
INSERT INTO mgw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini bembe ngabapanga ndu'ti, “Ummambe munsalaba, ummambe munsalaba!” ");
INSERT INTO mgw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ngaabakia pampanda patatu, “Apangite lyakau lyaku'? Nilibonali lyakau lyakumpanga abulagilwe, kwa nyo nilu'a kummesa mikwasu, bu'kapo ninnekekeye.” ");
INSERT INTO mgw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini bembe ngabayongekea panga ndu'ti kwa makakala munomuno, panga Yesu lasima abambilwe munsalaba. Kuundi'la, malobe gabe ngagayu'wanika. ");
INSERT INTO mgw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bai, Pilato ngabaya panga mwabapala bembe ipangilwe. ");
INSERT INTO mgw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Annyu'gu'li yu'lu' ywabampalage, ywabile ntabilwe kwa mwanjaa ayu'maniye bandu panni'ma no bulaga na kwapeya Yesu bampangi mwabapendile. ");
INSERT INTO mgw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pabaabile kabampeleka, bakwembine na mundu ywakemelwage Simoni wa Kilene, kabu'ka kunng'unda. Bai, ngabammoywa na kuntwi'ka gu'lu' nsalaba aupu'twe nsu'gu' ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lipi'nga lya bandu lyatekunki'ngama, nkati yabe baabile alwawa babaabile kabalombola na kunni'lya. ");
INSERT INTO mgw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu ngaagalambukya kabaya, “Mwenga mwaakina mau' ba ku Yelusalemu! Kanemundi'li nenga, ila mwili'li mwabene na bana binu. ");
INSERT INTO mgw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwa mwanjaa masu'ba gendaisa pabaalu'a baya, ‘Nantali balu' atonga, kingabeleka wala kingayongea bana!’ ");
INSERT INTO mgw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nsimu wo, bandu ngabatumbwa kuibakia itu'mbi' na itundulia, ‘Mututu'mbu'ki na mutuwi'ki'li!’ ");
INSERT INTO mgw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwa mwanjaa manaitei bandu baupangya nkongo mmi'gi' kati nyo, yapanga buli kwa nkongo nnyu'mu'?” ");
INSERT INTO mgw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Baatweti kai' bandu bi'ngi' abi'li' babaalabiye, babulagilwe pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pabaikite pandu papakemelwa “Lipakala lya Ntwe,” ngabammamba Yesu munsalaba papipi na balu' abi'li' babaalabiye, yumo lwammalyo wa Yesu na ywi'ngi' lwanki'ya lwake. ");
INSERT INTO mgw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu ngabaya, “Tati', mwasami, kwa mwanjaa batangiteli lyabalipanga.” Bu'kapo, ngababagana magu'bo gake kwo ng'andya mpumbe. ");
INSERT INTO mgw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bandu baabile wi'ma kabalola. Nabembe alongosi ngabansalanga kababaya, “Aakosopoli bi'ngi', nambi'yambi' aikosopoli mwene, manaitei ywembe nga Kilisitu, nsaulwa na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nabembe asikali baatikunsalanga kai', baatikunnyendelya na kumpeya kasiki, ");
INSERT INTO mgw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kababaya, “Manaitei kakape wenga nga wankulungwa wa Ayahudi, wikosopoli wamwene.” ");
INSERT INTO mgw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kai' maandiko gano gaabi'kilwe panani ya nsalaba wake, “Ayu' nga Nkulungwa wa Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumo ywa balu' babaalabiye bababambilwe munsalaba, aatikumpwi'wa kabaya, “Nga, kakape buli panga wenga nga wa Kilisitu ywabayilwe? Bai, wikosopoli wamwene, kai' utukosopoli na twenga.” ");
INSERT INTO mgw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini yu'lu' ywaalabiye ywi'ngi' ngankalipya nnyine kabaya, “Wenga unnyogopali Nnu'ngu' ata pasene? Wenga utesenulwa nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wenga nanenga ngaipalikwa pata mali'po gano kwa galu' gatupangite. Lakini mundu yu' apangiteli lyakau lyolyoti.” ");
INSERT INTO mgw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bu'kapo ngabaya, “Mwa Yesu! Mwangu'mbu'ki nsimu pamwayingya mu Ukulungwa winu.” ");
INSERT INTO mgw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ngannyangwa, “Nikubakia kakape, li'no waba pamope nanenga kumbepo ya Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Payabile kayika saa sita muntwekati, lisu'ba lyasomwi mulika, lubi'ndu' lwawi'ki'li munni'ma woti mpaka saa tisa. Na panjia yaitemwana Papeleteu pa Papeleteu mu Nyumba ya Nnu'ngu' yapopwanike ande ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu ngali'la kwa lilobe liku'lu', “Tati', mumoko ginu niibi'ka loo yangu'.” Payomwi longela go, ngayomoka. ");
INSERT INTO mgw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Apo, yu'lu' asikali nku'lu' paagabweni gagapitike, annumbite Nnu'ngu' no baya, “Kakape ayu' aai mundu ywa aki.” ");
INSERT INTO mgw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bandu boti babaakongolekine po pala bagabone gagapangika, pabagabweni malau gagapitike, baki'li'bu'ki kaya ku'no kabaisenwa no usunika pamwoyo wabe. ");
INSERT INTO mgw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mambwiga bake boti na balu' alwawa babalongwaniye nakwe bu'ka ku Galilaya, baayi'mi kuutalu lola likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kwai na mundu yumo lina lyake Yusupu, mwenekaya wa Alimataya mukilambo simo sa ku Yudea. Aai mundu nnogau na mwene aki. Aabile kalolela isa kwa Ukulungwa wa Nnu'ngu'. Pamope no panga aabile yumo ywa Kitamo Kiku'lu' sa Ayahudi, aabile anayi'ki'tyanali nabo mukyendo sabe. ");
INSERT INTO mgw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bai, ywembe ngayenda kwa Pilato, lu'ba ntwi wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bu'kapo ngauluya ntwi bu'ka munsalaba, ngaingilya sanda ngabi'ka mulisiko lyalii'mbilwe mumpi'mbi', na lyabile lyangakolelwa. ");
INSERT INTO mgw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lisu'ba lyo lyabile Ijumaa kitamwiyo, kai' lyaai lisu'ba lyo bi'ka wiso Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Balu' alwawa babaalongwaniye na Yesu bu'ka ku Galilaya banki'ngime Yusupu, ngabalibona li'lu' lipango na ntwi wa Yesu mwaubi'kilwe. ");
INSERT INTO mgw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bu'kapo, baaki'li'bu'ki kaya no bi'ka wiso mauta ganannungya ga kuupakaya ntwi wa Yesu. Lisu'ba lya Sabato ya Ayahudi baatipu'mu'lya kati mwayaamuliswe na salya. ");
INSERT INTO mgw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili, kindai' bulabula, balu' alwawa baayi'i kulisiko, baapu'twi galu' mauta ganannungya gagabi'kilwe wiso. ");
INSERT INTO mgw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baalikoli li'lu' liwe liimbiliyilwe kuutalu na lisiko, ");
INSERT INTO mgw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pabaayingi nkati, baaubwenili ntwi wa Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pabaabile kabasangala kwa likowe lyo, imukya bandu abi'li' babaaweti ngu'bo yene mmelemetya muno bayi'mi papipi nabo. ");
INSERT INTO mgw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Balu' alwawa baatiyogopa muno, ngabayinamika ibu'ngi' yabe. Apo balu' bandu ngabaabakia, “Kwa ki'li' mumpala ywabile nkoti mumapango ga awi'li? ");
INSERT INTO mgw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Abileli pano, ayu'kite. Muku'mbu'ki gammakie paabile ku'lu' ku Galilaya, ");
INSERT INTO mgw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ipalikwa Mwana wa Mundu apiyilwe kwa bandu baakau, nabembe balu'a kummamba munsalaba na lisu'ba lyenetatu alu'a yu'ka.’” ");
INSERT INTO mgw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Apo balu' alwawa ngabaku'mbu'kya mayi'gi'yo gake, ");
INSERT INTO mgw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ngabaki'li'bu'ka bu'ka kulipango, na kwabakia balu' banamasi' ku'mi na yumo na apwasi bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Babaapiyike makowe go kwa atumilwe baai, Malia Makatalena, Yoana na Malia mau' ba Yakobi, pamope na alwawa bi'ngi' babalongwaniye nabo. ");
INSERT INTO mgw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Banamasi' pabagayu'wine makowe go baagabweni kati gangali ntwe kwa nyo bau'bi'li lili. ");
INSERT INTO mgw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakini Petili aabutwike lubi'lo mpaka kulipango, palitike no lingulya nkati, ngaibona sanda bai. Ngabuyangana kaya ku'no kasangala kwa galu' gagapitike. ");
INSERT INTO mgw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lisu'ba lyolyolyo, apwasi abi'li' ba Yesu baai kabayenda kukilambo simo sakikemelwa Emau, ulipau wake kilometa ku'mi na yimo bu'ka ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baabile kabalongelya makowe go gagapitike. ");
INSERT INTO mgw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pabaabile kabalongela no laluyana, Yesu mwene ngapitya, ngalongwana nabo. ");
INSERT INTO mgw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Baamweni, lakini Nnu'ngu' aatabite malango ga kunkwipwa. ");
INSERT INTO mgw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngaalaluya, “Mulongela ki'li' ku'no kannyenda?” Nabembe baayi'mi liki, no uta ngi'njaki'nja ya kuminyo yabe kwo usunika. ");
INSERT INTO mgw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumo, ywakemelwa Kileopa, ngannyangwa, “Wenga ngawang'eni kisako ku Yelusalemu wokotoka tanga gagapitike kwo masu'ba gano?” ");
INSERT INTO mgw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naywembe ngaalaluya, “Makowe gaku'?” Bembe ngabannyangwa, “Makowe gagampatike Yesu wa ku Nasaleti. Ywembe aai nnondoli ywa Nnu'ngu' nku'lu' mwene makakala go panga makowe no yi'gana nnu'ngi' ya Nnu'ngu' na bandu boti. ");
INSERT INTO mgw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Api'ndo ba dini na atawala bitu baampiyike asenulwe waa, ngabammamba munsalaba. ");
INSERT INTO mgw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lakini twenga tuu'bi'lyage panga ywembe nga ywalu'a kwikombwa Isilaili. Bu'ka pagapangilwe makowe ga goti, li'no lisu'ba lyenetatu. ");
INSERT INTO mgw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kai', alwawa bitu bi'ngi' baatikutung'ang'amuya. Baayi'i kulisiko kindai' bulabula. ");
INSERT INTO mgw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Baaikolili yi'ga yake. Baaki'li'bwike kababaya panga bapitilwe na malaika ywabakie panga ai nkoti. ");
INSERT INTO mgw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aitu bi'ngi' baayi'i kulisiko lingulya wiso galu' gabalongei balu' alwawa, gaai nyinyonyo ila ywembe baamwenili.” ");
INSERT INTO mgw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kuundi'la Yesu ngaabakia, “Mboni mwalogeloge nyo, na myoyo yinu ndopau kwo kotoka kugau'bi'lya goti gagalongelilwe na alondoli ba Nnu'ngu'? ");
INSERT INTO mgw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Buli, yali'nganili Kilisitu ateselwe, li'nga ayingi muutukupu wake?” ");
INSERT INTO mgw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngaawanikia mayi'gi'yo gake goti ga mu Maandiko Mapeleteu tumbulya Musa mpaka alondoli ba Nnu'ngu' boti. ");
INSERT INTO mgw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pabaegeli palu' pakilambo sabayendage, Yesu ngapanga kati ayendelya na mwanja. ");
INSERT INTO mgw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lakini bembe ngabannu'ba kababaya, “Utame pamope na twe, kwendapilya na kilo kiegelile.” Bai, ngaika palu' pakilambo, no yingya nnyumba tama pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Waatami lya pamope nabo, ngatola likati kulilu'bya na kulimetwana, na kwabagana. ");
INSERT INTO mgw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Popopo minyo gabe gaatibanjwa, ngabankwipwa, lakini ywembe baimuki abu'i na baamwenili kai'. ");
INSERT INTO mgw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bai, ngababakiana, “Panga myoyo yitu yabileli kaiyaka nkati yitu paabile katuawanikia Maandiko Mapeleteu mu'lu' mundi'la?” ");
INSERT INTO mgw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ngababu'ka saa yi'yi'lu'yi'lu', ki'li'bu'ka ku Yelusalemu, ngabaakolya balu' banamasi' ku'mi na yumo na balu' apwasi bi'ngi' bababile pamope nabo bakongolekine ");
INSERT INTO mgw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kababaya, “Kakape Bwana ayu'kite, ampiti Simoni.” ");
INSERT INTO mgw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bai, balu' apwasi abi'li' ngabaayaulya ayabe galu' gabagapatike mundi'la, na mwabapatike kuntanga kwa kulimetwa likati. ");
INSERT INTO mgw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pabaabile kabaabakia go, baimuki mwene Yesu aayi'mi pakatikati yabe, ngaabakia, “Amani ibe namwenga.” ");
INSERT INTO mgw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Baating'ang'amuka no yogopa kwa mwanjaa baganiage balibweni lyoka. ");
INSERT INTO mgw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lakini ywembe ngaabakia, “Kwa mwanjaa ki'li' muyogobala? Mboni mubaa na kyukala mumyoyo yinu? ");
INSERT INTO mgw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mulolekeye moko na magu'lu' gangu', nga nenga namwene. Munipapaye munibone kwa mwanjaa lyoka ntu'pu' yi'ga wala yupaa kati mwamunibona.” ");
INSERT INTO mgw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paayomwi longela go, ngaalaya moko na magu'lu' gake. ");
INSERT INTO mgw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pabaabile balo banau'bi'lyali kwa mwanjaa ya pulaa yabe na kabasangala, ngaalaluya, “Mubile naso kilyo sosoti pano?” ");
INSERT INTO mgw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ngabampeya kitomwa sa omba mmanika. ");
INSERT INTO mgw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ngakitola no lya, boti kabammona. ");
INSERT INTO mgw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bu'kapo ngaabakia, “Yi'no nga ikomekeyo ya makowe ganammakie panaabile pamope namwenga. Panga yaapalikwe yomwa goti gagaandikilwe kwa mwanjaa ya nenga mu salya ya Musa, muitabu ya alondoli ba Nnu'ngu' na mukitabu sa Zabuli.” ");
INSERT INTO mgw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bu'kapo, ngaayu'gu'lya malango gabe li'nga bapate kugatanga Maandiko Mapeleteu. ");
INSERT INTO mgw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngaabakia, “Ngamo mwaiandikilwe, panga Kilisitu aateselwa na lisu'ba lyenetatu aayu'ka bu'ka kuuwi'li, ");
INSERT INTO mgw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kwa nyo ngaipalikwa panga, kwa lina lyake, dunia yoti tumbulya ku Yelusalemu, bandu ba dunia yoti baalilwe panga banki'li'bu'ki Nnu'ngu' basamilwe masambi. ");
INSERT INTO mgw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mwenga nga mwakong'ondeli ba makowe go. ");
INSERT INTO mgw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nenga namwene nalu'a kumpelekyanga yu'lu' ywabayilwe tumilwa na Tati'. Lakini muli'nde ku'no kukilambo mpaka pamwapeyelwa galu' makakala gagabu'ka kunani.” ");
INSERT INTO mgw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bu'kapo, ngaalongoya panja ya ku Yelusalemu mpaka ku Betania, ngatu'ndu'bi'ya moko gake kunani ngaayalya. ");
INSERT INTO mgw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Paabile kaayalya, ngaaleka, no pu'tu'lwa kunani. ");
INSERT INTO mgw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bembe ngabankilikitya, bu'kapo ngabaki'li'bu'ka ku Yelusalemu babile na pulaa ngu'lu'. ");
INSERT INTO mgw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Baatami masu'ba goti mulua lwa Nyumba ya Nnu'ngu' kabannumba Nnu'ngu'.");
INSERT INTO mgw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kwai'mbu' kwai na Liyi'gi'yo, aywo Liyi'gi'yo aai na Nnu'ngu', naywembe aai Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bu'ka kwai'mbu', aywo Liyi'gi'yo aai pamope na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kwo pi'tya ywembe ili'be yoti ngaiumbilwe, na pangali ywembe ntu'pu' kili'be sakiumbilwe. ");
INSERT INTO mgw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nkati yake ngamwawabile ukoto, na ukoto wo ngawaletike bweya kwa bandu. ");
INSERT INTO mgw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bweya wo umulika mulubi'ndu', na lubi'ndu' lukombwili kuimiya. ");
INSERT INTO mgw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aaisi mundu yumo ywaatumilwe bu'ka kwa Nnu'ngu', lina lyake Yoani. ");
INSERT INTO mgw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aywo aaisi kong'ondelya bu'kana na bweya wo, kwo pi'tya ywembe bandu boti bauu'bi'li. ");
INSERT INTO mgw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ywembe aabileli wu'lu' bweya we, ila aaisi kwabakia bandu bu'kana na awo bweya. ");
INSERT INTO mgw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wu'lu' bweya wa kakape, wammulikya kila mundu uisa padunia. ");
INSERT INTO mgw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Liyi'gi'yo aabile padunia na kwa ndi'la yake dunia ngaiumbilwe, lakini dunia yantangiteli. ");
INSERT INTO mgw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aaisi kasake, lakini babaabile bandu bake baampokili. ");
INSERT INTO mgw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakini boti babampokile, aapei uweso wo pangika bana ba Nnu'ngu', nga balu' babaliu'bi'lya lina lyake, ");
INSERT INTO mgw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","baabelekwili kwa myai, wala kati mwaipala yi'ga au mundu, ila mwapendi Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nalyembe Liyi'gi'yo lyapangike mundu no tama pamope na twenga. Na twenga twaubweni utukupu wake, utukupu wu'lu' waapeyilwe Mwana ywa kisake ywabu'ka kwa Tati'. Ywembe aalayite ukakape woti na ngu'ngu' ngu'lu' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoani aau'bwiye lilobe kaabakia bandu makowe gake, kabaya, “Ayu' nga yu'lu' ywanammakie panga, ‘Ywembe ywalu'a isa pasu'gu' yangu', nga nku'lu' kulikoni nenga, kwa mwanjaa nenga nabelekwali, ywembe aabile.’” ");
INSERT INTO mgw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwo bu'kana no timilika kwake, twenga twaboti tupoki ngu'ngu' ngu'lu' yatwi'li'yilwe nayo. ");
INSERT INTO mgw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwa mwanjaa salya ya Nnu'ngu' yaaletilwe kwa luboko lwa Musa, nambi'yambi' ngu'ngu' na kakape yaaisi kwa luboko lwa Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ntu'pu' mundu ywoywoti ywaamweni Nnu'ngu' katu, ila Mwana ywa kisake ywabile nsawani na Nnu'ngu', ywembe ywalu'mbine na Tati', ngaywatubakiye makowe ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Amo, ngamwaalongei Yoani api'ndo ba Ayahudi pabaatumike alongosi ba dini na Alawi bu'ka ku Yelusalemu kunnaluya, “Wenga wa nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yoani aakanili yangwa pabannalwiye, aalongei mpu'la kabaya, “Nenga na Kilisitu lili.” ");
INSERT INTO mgw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngabannaluya, “Wenga wanyai nde? Wenga wa Elia?” Ywembe ngaayangwa, “Lili, nenga na Elia li.” “Wenga wa yu'lu' Nnondoli wa Nnu'ngu'?” Ngaayangwa, “Lili.” ");
INSERT INTO mgw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngababaya, “Bai utubakiye panga wenga wa nyai, li'nga tupate sakwabakia babatutumike. Wenga wamwene wikema wanyai?” ");
INSERT INTO mgw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoani ngayangwa, “Nenga nga na li'lu' lilobe lya mundu ywakema kulupu'ngu'ti' ywaabaite Nnondoli Isaya makowe gake, ‘Mugolwe ndi'la ya Bwana.’” ");
INSERT INTO mgw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bandu bo baatumilwe na Mafalisayo. ");
INSERT INTO mgw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ngabannaluya, “Manaitei wenga wa Kilisitu li, kai' wa Elia li, na wayu'lu' Nnondoli wa Nnu'ngu' li, mboni wendabatisa?” ");
INSERT INTO mgw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yoani ngaayangwa, “Nenga nibatisa kwa masi', lakini pakatikati yinu ayi'mi mundu ywamumwomongwa. ");
INSERT INTO mgw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aywo ywaisa pasu'gu' yangu', nenga nipwaikali ata undwana lugoi lwa ilatu yake.” ");
INSERT INTO mgw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Makowe aga goti gaapangike ku Betania, kwiyi' ya Libi'ndi' lya Yordani, pandu paabile Yoani kabatisa. ");
INSERT INTO mgw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pammalau' yake, Yoani aamweni Yesu kaisa paabile, ngabaya, “Ayu' nga Mwana Ngondolo wa Nnu'ngu' ywagabu'ya masambi ga dunia! ");
INSERT INTO mgw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayu' nga yu'lu' ywanaalongei makowe gake panga, ‘Aisa mundu nku'lu' nsu'gu' yangu' kulikoni nenga, kwa mwanjaa nenga nabelekwali aabile!’ ");
INSERT INTO mgw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nenga namwene nantangiteli, lakini kitumbu so isa batisa kwa masi' li'nga bandu ba Isilaili bapate kuntanga.” ");
INSERT INTO mgw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kai' Yoani aakong'ondeli kabaya, “Nimmweni Loo kauluka bu'ka kunani kati ngunda, no tu'la panani yake. ");
INSERT INTO mgw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga nantangiteli, lakini yu'lu' ywanitumike nibatise kwa masi' aanibakiye, ‘Yu'lu' ywawammona Loo kamuulukya no tama panani yake, aywo nga ywaalu'a batisa kwa Loo Mpeleteu.’ ");
INSERT INTO mgw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nenga namwene nilibweni likowe li', nganikong'ondelya panga ayu' nga Mwana wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pammalau' yake, Yoani na banamasi' bake abi'li' baabile pandu po kai'. ");
INSERT INTO mgw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Paamweni Yesu kapi'ta, ngabaya, “Lingulya, Ayu' nga Mwana Ngondolo wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Balu' banamasi' abi'li' pabannyuwine Yoani kalongela go, ngabanki'ngama Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu aatigalambuka ngaabona abo banamasi' kabammi'ngi'ya, aatikwalaluya, “Mupala namani?” Baatikunnyangwa, “Rabi,” (lombolya Mwalimu), “Utama kwaku'?” ");
INSERT INTO mgw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu ngayangwa, “Mwisange, mulu'a pabona.” Kwa nyo ngabayenda na kupabona pandu patamage, baatami nakwe lisu'ba li'lu', mpaka musaa ku'mi kitamwiyo. ");
INSERT INTO mgw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andelea nnunawe Simoni Petili, aabile yumo ywa banamasi' abi'li' babaayu'wine galu' gaagalongei Yoani, nabembe ngabammi'ngi'ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andelea aankoli wi'ti' nku'we Simoni na kummakia, “Tunkoli Masiya (lombolya Kilisitu)!” ");
INSERT INTO mgw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nembe ngampeleka Simoni kwa Yesu. Yesu aatikunninga no baya, “Wenga wa Simoni, mwana wa Yoani, nambi'yambi' ulu'a kemelwa wa Kefa.” (Lilombolya Petili au Liwe). ");
INSERT INTO mgw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pammalau' yake Yesu apalage yenda Galilaya, bai ngankwemba Pilipi, ngammakia, “Unibi'ngi'ye.” ");
INSERT INTO mgw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi aai mwenekaya wa Betisaida, kukilambo sa ki Andelea na Petili. ");
INSERT INTO mgw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipi nembe ngankwemba Natanaeli na kummakia, “Tunkoli yu'lu' ywembe makowe gake gaandikilwe mukitabu sa salya ya Musa na alondoli ba Nnu'ngu', yaani Yesu mwana wa Yusupu bu'ka Nasaleti.” ");
INSERT INTO mgw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeli ngannaluya Pilipi, “Nasaleti! Buli, kikowe kinannoga kiwesa pitya bu'ka ku Nasaleti?” Pilipi ngammakia, “Wise saulole.” ");
INSERT INTO mgw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pamweni Natanaeli kamwisilya, aalongei makowe gake kabaya, “Lingulya, ayu' kakape Mwisilaili. Nkati yake ntu'pu' ki'pi'li.” ");
INSERT INTO mgw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli ngannaluya, “Unitangite buli?” Yesu ngannyangwa, “Naakubweni pawaabile pai' ya ntini, Pilipi abile balo kukukema.” ");
INSERT INTO mgw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli ngammakia kai', “Mwalimu, wenga wa Mwana wa Nnu'ngu' na wa Nkulungwa wa Isilaili!” ");
INSERT INTO mgw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ngammakia, “Uu'bi'lya mwanjaa naakubakiye naakubweni pawaabile pai' ya ntini? Bai, waagabona makowe maku'lu' kulikoni lyo.” ");
INSERT INTO mgw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Apo ngaabakia, “Kakape gano ganimmakia mwenga, mwakubona kunani kakuyu'gu'ka na malaika ba Nnu'ngu' kabau'bu'ka no uluka bu'ka kunani mpaka kwa Mwana wa Mundu.” ");
INSERT INTO mgw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lisu'ba lyenetatu kwai na lisengele ku kilambo sa Kana ya Galilaya, na mau' bake Yesu baabile kwo. ");
INSERT INTO mgw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na banamasi' bake nabembe baakokilwe kulisengele lyo. ");
INSERT INTO mgw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai payaayomwike, mau' bake ngabammakia Yesu, “Divai iyomwike.” ");
INSERT INTO mgw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu ngaabakia mau' bake, “Mau', lyanipalikwa panga nilitangite, ila saa yo panga lyengo lyangu' inaikali.” ");
INSERT INTO mgw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mau' bake Yesu ngaabakia balu' apangakasi ba lisengele, “Lyolyoti lyaalu'a kummakia, mwapange.” ");
INSERT INTO mgw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bai, palu' kwaabile na ibi'ga sita yaiukulilwe kwa maliwe. Kwa mimu ya Kiyahudi, ibi'ga yo baitumyage kwa kwipeletea, kila kibi'ga kiwesage twi'lya malebe matano. ");
INSERT INTO mgw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu ngaabakia balu' atumisi, “Mwiitwi'li'ye masi' ayo ibi'ga.” Nabembe ngabaitwi'li'ya yi'lu' ibi'ga genugenu. ");
INSERT INTO mgw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bu'kapo ngaabakia, “Nambi'yambi' muteke ago masi' masini, mumpeleki mpi'ndo ywa si'li'ku'si'li'ku'.” Kwa nyo ngabateka na kumpelekya. ");
INSERT INTO mgw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yu'lu' mpi'ndo ywa si'li'ku'si'li'ku' paagapayite masi' go, kumbe gaagalambwike panga divai. Ywembe aatangiteli kwaibu'i, lakini balu' atumisi babaatekite masi' baatangite. Mpi'ndo wa si'li'ku'si'li'ku' ngaankema mwene lisengele, ");
INSERT INTO mgw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ngammakia, “Kila mundu atumbwa wi'ti' bi'ka wiso divai inannoga, ata balu' babakokilwe pabaabonekana bayukwite, bapiya yi'lu' yanganoga. Lakini wenga wibi'i divai inannoga muno kulikoni ya patumbu!” ");
INSERT INTO mgw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu aapangite mwanju wu'no nnongoi, akwo Kana ya Galilaya. Aalayite utukupu wake, na banamasi' bake ngabamwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bu'kapo, Yesu aaeli pamope na mau' bake, anunabe, na banamasi' bake, baalumuli ku Kapernaumu, akwo baatami kwa masu'ba masini. ");
INSERT INTO mgw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Paliegeli lisu'ba lya si'li'ku'si'li'ku' ya Pasika ya Ayahudi, Yesu aatiu'bu'ka yenda ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akwo kulua lwa nyumba ya Nnu'ngu', aakoli bandu kabapi'mi'ya ng'ombe, ngondolo, na ngunda. Na balu' babapunja mbanje baabile batami mumesa. ");
INSERT INTO mgw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aapotike nkwasu wa lukamba, ngaabi'nganga boti bu'ka pandu paluwa lwa nyumba ya Nnu'ngu', pamope na ngondolo na ng'ombe. Aapi'li'ngwi mesa ya balu' babaabile kabapunja mbanje na kwiyitana mbanje yabe. ");
INSERT INTO mgw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ngaabakia balu' babaabile kabasulusa ngunda, “Ikowe yi' mubu'ye pano! Nyumba ya Tati' bangu' kanemwiyu'ye pandu po sulusilya!” ");
INSERT INTO mgw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Banamasi' bake ngabaku'mbu'kya panga iandikilwe, “Bwigu wangu' kwa nyumba yako wendanilangamisa.” ");
INSERT INTO mgw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Apo Ayahudi ngabannaluya Yesu, “Uwesa kutulaya mwanju waku', li'nga tutange uku'lu' waubile nawo wo panga makowe ga?” ");
INSERT INTO mgw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ngaayangwa, “Mwibomwane nyumba yi' ya Nnu'ngu', nanenga nilu'a kwisenga kai' kwa masu'ba gatatu!” ");
INSERT INTO mgw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Apo Ayahudi ngababaya, “Nyumba yi' ya Nnu'ngu' yaasengilwe kwa myaka alubaini na sita, na wenga ubaya ulu'a kwisenga kwa masu'ba gatatu?” ");
INSERT INTO mgw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakini ywembe nyumba ya Nnu'ngu' yailongelile yai yi'ga yake. ");
INSERT INTO mgw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Paayu'kite bu'ka kuuwi'li, banamasi' bake ngabaku'mbu'kya galu' gaabaite. Ngabagau'bi'lya maandiko mapeleteu na makowe galu' gaabaite Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu paabile kusi'li'ku'si'li'ku' ya Pasika akwo ku Yelusalemu, bandu baingi baaibweni myanju ya ayabu yaipangage, ngabamwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini mwanjaa Yesu aatangite bandu boti, aau'bi'lili. ");
INSERT INTO mgw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aapalikeli bakiyilwa na mundu kikowe sosoti kwa makowe ga bandu, kwa mwanjaa aagatangite wisowiso makowe goti gagabile mumyoyo ya bandu. ");
INSERT INTO mgw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwaabile na mundu yumo Mfalisayo, lina lyake Nikodemo, kolongosi yumo mu Balasa Liku'lu' lya Ayahudi lyalitawalage lya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ywembe aamwisili Yesu kilo ngammakia, “Mwalimu, tutangite panga wenga wa mwalimu wotumilwe na Nnu'ngu', kwa mwanjaa ntu'pu' mundu ywakombwa panga myanju yawipanga wenga ila Nnu'ngu' abe pamope nakwe.” ");
INSERT INTO mgw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ngammakia, “Kakape nikubakia, mundu mana akotwike belekwa mala yenebi'li', aakombwali yingya mu Ukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo ngannaluya, “Mundu ywakomile akombwabuli belekwa kai'? Awesa yingya mundumbo ya mau' bake no belekwa pampanda pabi'li'?” ");
INSERT INTO mgw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ngammakia, “Kakape nikubakia, mundu mana akotwike belekwa kwa masi' na Loo, akombwali katu yingya mu Ukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sakibelekwa na mundu sa yi'ga, sakibelekwa na Loo, sa Loo. ");
INSERT INTO mgw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kwa nyo, kaneuomongwe panikubakia, ‘Mupalikwa belekwa pampanda pabi'li'.’ ");
INSERT INTO mgw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nsunga upukatya yenda kwaupala, pukatya kwake wendakuuyu'wa, lakini utangiteli kwaubu'ka wala kwauyenda. Nyinyonyo kati mwaibile mundu mwabelekwa kwa Loo.” ");
INSERT INTO mgw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ngannaluya, “Makowe ga gapangika buli?” ");
INSERT INTO mgw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ngannyangwa, “Wenga wa mwalimu wotanganikwe kwa Baisilaili, ugatangiteli makowe ga? ");
INSERT INTO mgw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nikubakia kakape, twenga tulongela gatugatangite no kong'onndelya gatugabweni, lakini mwenga mugakana gatummakia. ");
INSERT INTO mgw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Manaitei kamukana u'bi'lya panimmakianga makowe ga padunia, mwaniu'bi'lya buli panammakianga makowe ga kunani? ");
INSERT INTO mgw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ntu'pu' mundu ywau'bwike yenda kunani ila Mwana wa Mundu, ywembe ngaywaulwike bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kati mu'lu' Musa mwantu'ndu'biye nng'ambo wa kyu'ma kunani ku'lu' kulupu'ngu'ti', nembe Mwana wa Mundu apalikwa tu'ndu'bi'yi'lwa kunani nyinyonyo, ");
INSERT INTO mgw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","li'nga kila mundu ywamwu'bi'lya abe na ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwa mwanjaa Nnu'ngu' aaipendi dunia, ngaampiya mwana wake wa kisake, li'nga kila mundu ywamwu'bi'lya aakaneoba, ila abe na ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwa mwanjaa Nnu'ngu' antumiteli Mwana wake isa kwisenwa dunia, ila dunia ikosopolelwe na Ywembe. ");
INSERT INTO mgw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ywamwu'bi'lya Mwana aasenulwali, ywakana kumwu'bi'lya ayomwike senulwa kwa mwanjaa amwu'bi'lili Mwana wa kisake wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","No senulwa kwene nga ku'no, panga bweya wisi padunia lakini bandu balupendi lubi'ndu' kulikoni bweya, kwa mwanjaa makowe gabapanga maakau. ");
INSERT INTO mgw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kwa mwanjaa kila ywapanga maakau ausukwa bweya na aisali kubweya li'nga makowe gake maakau gaakane bonekana. ");
INSERT INTO mgw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini yu'lu' ywapanga makowe ga kakape, aisa kubweya li'nga gaagapanga gabonekane mpu'la panga gapangilwe mwapala Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bu'ka pa go, Yesu na banamasi' bake baayi'i kunni'ma wa Yudea. Aatami kwo pamope nabo kwa masu'ba kaabatisa bandu. ");
INSERT INTO mgw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoani nembe aabile kaabatisa akwo Ainoni, papipi na Salimu, kwa mwanjaa akwo kwai na masi' gatwi'la. Bandu baatikunnyendelya li'nga aabatise. ");
INSERT INTO mgw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nsimu wo Yoani aabile balo anayingiyilwali muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kwaapitike ntau mukipi'nga sa banamasi' ba Yoani na Nnyahudi yumo bu'kana na mimu ya kwipeletea kwo uluga. ");
INSERT INTO mgw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bai, banamasi' bo ngabannyendelya Yoani na kummakia, “Mwalimu, yu'lu' mundu ywawaabile nakwe kwiyi' ya Yordani, na ngaywawankong'ondeli makowe gake, nambi'yambi' naywembe endabatisa na bandu boti bendakunnyendelya!” ");
INSERT INTO mgw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoani ngayangwa, “Mundu akombwali ba na kili'be sosoti, wangali peyelwa na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwenga mwabene mwaakong'ondeli bangu' naabaite panga, ‘Nenga na Kilisitu li, ila nitumilwe li'nga ninnongoli.’ ");
INSERT INTO mgw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nkobeki nga mwene mwali' ywaku'nda. Lakini mbwigalye nkobeki ywayi'ma papipi nakwe pi'kania lilobe lyake bai, endapulaika muno. Nyinyonyo, pulaa yangu' itimile kwa mwanjaa ywembe ywangama kulikoni nenga. ");
INSERT INTO mgw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ywembe ipalikwa au'bu'ke, nenga niuluke.” ");
INSERT INTO mgw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ywaisa bu'ka kunani nga nku'lu' wa boti. Lakini ywai ywa padunia, ywa padunia, nembe alongela makowe ga padunia. Ywembe ywaisa bu'ka kunani nga nku'lu' wa boti. ");
INSERT INTO mgw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ywembe alongela gaagabweni na kugayu'wa, lakini ntu'pu' mundu ywayi'ki'tya gaagakong'ondelya. ");
INSERT INTO mgw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lakini mundu ywoywoti ywayi'ki'tya gaagakong'ondelya, ayi'ki'tya panga Nnu'ngu' nga kakape. ");
INSERT INTO mgw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yu'lu' ywatumilwe na Nnu'ngu' alongela mayi'gi'yo ga Nnu'ngu', kwa mwanjaa Nnu'ngu' annyalya Loo wake mundu ywo wangali li'ngi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tati' bampendi Mwana, nabembe bankamwiye ili'be yoti mumaboko gake. ");
INSERT INTO mgw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ywoywoti ywamwu'bi'lya Mwana, ukoto wake waayomokali, lakini yu'lu' ywankana Mwana aaupatali ukoto wo, na nyongo ya Nnu'ngu' yabaa panani yake. ");
INSERT INTO mgw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo baayu'wine panga Yesu endebatisa no pata banamasi' baingi kulikoni Yoani. ");
INSERT INTO mgw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lakini ywabatisage aai Yesu mwene lili, baai banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu paayu'wine makowe go, aabu'i Yudea no buyangania kai' Galilaya. ");
INSERT INTO mgw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bai mwanja wo aapalikwe pi'tya kunkoa wa Samalia. ");
INSERT INTO mgw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ngaika ku kilambo simo sa ku Samalia sakikemelwa Sukali papipi na nng'unda wa Yakobi waampei mwana wake Yusupu. ");
INSERT INTO mgw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pandu po, nga palwabile lu'si' lwa Yakobi. Naywembe Yesu aabile atotokilwe kwa mwanja, ngatama pambwega ya lu'si'. Lisu'ba lyaai mu saa sita muntwekati. ");
INSERT INTO mgw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ngaisa nnwawa yumo Nsamalia teka masi'. Yesu ngammakia, “Nilu'ba masi' ninywe.” ");
INSERT INTO mgw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Wakati wo, banamasi' bake baayi'i kumisengo pi'ma kilyo.) ");
INSERT INTO mgw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yu'lu' nnwawa ngannyangwa, “Wenga wa Nnyahudi nanenga na nnwawa Nsamalia. Kwa buli unilu'ba nikupei masi' go nywa?” (Kwa mwanjaa Ayahudi bayangabanikali na Asamalia.) ");
INSERT INTO mgw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu ngannyangwa, “Kenda ukatanga sawesa kupeya Nnu'ngu' na nyai ywakulu'ba umpei masi' go nywa, wenga ulu'e kunnu'ba ywembe na alu'e kupeya masi' gagaleta ukoto”. ");
INSERT INTO mgw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yu'lu' nnwawa ngannyangwa, “Bwana, wenga ntu'pu' nnobo wo tekya, na lu'si' lu' luyendekeya. Ulu'a gapata kwaku' ago masi' ga ukoto? ");
INSERT INTO mgw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kwani wenga wampi'ndo kulikoni au'ku' bitu Yakobi, ywembe ngaywatupei lu'si' lu' lwalwaampwaike ywembe na bana bake, na myugo yake yendenywa?” ");
INSERT INTO mgw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ngannyangwa, “Kila mundu ywanywa masi' ga lu'si' lu' aaminya nnyota kai'. ");
INSERT INTO mgw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lakini ywaalu'a nywa masi' ganaampeya nenga, aaibonali nnyota milele. Masi' ganaampeya ne, nkati yake sabaa kinywanyu sa masi' ga ukoto na kumpeya ukoto wangayomoka.” ");
INSERT INTO mgw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aywo nnwawa ngammakia, “Bwana, unipei ago masi', li'nga nakane minya nnyota kai', na kanenise pano palu'si' teka masi'.” ");
INSERT INTO mgw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ngammakia, “Uyende ukankeme nsengogo, wise nakwe pano.” ");
INSERT INTO mgw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aywo nnwawa ngammakia, “Nenga ntu'pu' nnalu'me,” Yesu ngammakia, “Golongei kakape panga wenga nnalu'me ntu'pu'. ");
INSERT INTO mgw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwa mwanjaa uyomwike tama na analu'me batano na ywotama nakwe nambi'yambi' nsengogo li, apo ulongei kakape.” ");
INSERT INTO mgw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yu'lu' nnwawa ngabaya, “Bwana, ibonekana mpu'la bai panga, wenga wa nnondoli wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Api'ndo bitu bankilikityage Nnu'ngu' panani ya kitu'mbi' si'no, lakini mwenga mubaya panga pandu pa kunkilikitya Nnu'ngu' ku'lu' ku Yelusalemu.” ");
INSERT INTO mgw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ngammakia, “Mau', muniu'bi'li panga nsimu wendaisa, nsimu wo ntu'pu' pabaalu'a kwakilikitya Tati' panani ya kitu'mbi' si', ata ku'lu' ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenga mwa Asamalia, muntangiteli ywamunkilikitya. Twayahudi tuntangite Nnu'ngu' ywatunkilikitya kwa mwanjaa ukosopoli wisi kwa ndi'la ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakini nsimu wendaisa, kai' uyomwike isa, babaankilikitya Nnu'ngu' kwa kakape, baakilikitya Tati' kwa loo na kakape. Kwa mwanjaa Tati' bapala bandu babankilikitya Nnu'ngu' kwa nyo. ");
INSERT INTO mgw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nnu'ngu' nga loo, na bandu boti babankilikitya, bapalikwa bankilikiti kwa loo na ukakape.” ");
INSERT INTO mgw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yu'lu' nnwawa ngammakia, “Nitangite panga Masiya, ywakemelwa Kilisitu, endaisa. Paaisa, aatubakia kila kikowe.” ");
INSERT INTO mgw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ngammakia, “Nenga nanilongela nawenga nga na Masiya wene.” ");
INSERT INTO mgw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Palongelage na nnwawa ywo, banamasi' bake baai kababuyangana. Baatisangala muno kummona kalongela na nnwawa. Lakini ntu'pu' ywannalwiye, “Upala namani kwa nnwawa yu'?” Au, “Mwanjaa namani ulongela na nnwawa?” ");
INSERT INTO mgw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yu'lu' nnwawa aakilei kibi'ga sake no buyangania kumisengo na kwabakia bandu, ");
INSERT INTO mgw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwise samunnole mundu ywanibakiye kila kili'be sanikipangite! Buli, iwesa panga kwaali' ayu' nga Kilisitu?” ");
INSERT INTO mgw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bai, bandu ngabakongolekana bu'ka mumisengo kunnyendelya Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Akwo nsu'gu' banamasi' bendekumpembelelya kababaya, “Mwalimu, ulye.” ");
INSERT INTO mgw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini ywembe ngaabakia, “Nenga nibile na kilyo samukotwike kitanga mwenga.” ");
INSERT INTO mgw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bai, banamasi' ngabatumbwa laluyana, “Kubile na mundu ywanneti kilyo?” ");
INSERT INTO mgw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ngaabakia, “Kilyo sangu' panga si'lu' sapala ywanitumike no timisa lyengo lyake. ");
INSERT INTO mgw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwenga mubaya, ‘Igali myei mine bai ika nsimu wo una.’ Lakini nenga nimmakianga, mutu'ndu'bi'ye minyo ginu muilinguli yakulya mumigunda mwaiyei, ili'nda unilwa. ");
INSERT INTO mgw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ywauna apata mbokoboko yake, na akongwa yakulya no bi'ka muukoto wangayomoka, li'nga yu'lu' ywapanda na ywauna, banapusike pamope. ");
INSERT INTO mgw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa nyo nnongelo wu' wa kakape, ‘Apandi bi'ngi', Auni bi'ngi'.’ ");
INSERT INTO mgw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenga nintumike mukaune yakulya yangaaukilya. Bi'ngi' baapangite kasi, lakini mwenga mupata bu'ka mulyusu lyabe.” ");
INSERT INTO mgw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamalia baingi ba kilambo si'lu' bamwu'bi'li kwa kitumbu sa makowe gaalongei aywo nnwawa, “Anibakiye makowe goti ganigapangite.” ");
INSERT INTO mgw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kwa nyo balu' Asamalia bannyendeli Yesu na kunnu'ba atame nabo, nembe ngatama po masu'ba gabi'li'. ");
INSERT INTO mgw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bandu baingi baatiu'bi'lya kwa kitumbu sa liyi'gi'yo lyake Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ngabammakia yu'lu' nnwawa, “Tuu'bi'lile lelo, kwenda kwa makowe gako bai lili, ila kwa mwanjaa tunnyu'wine twabene. Tutangite kakape panga ayu' nga Nkosopoli wa dunia.” ");
INSERT INTO mgw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagapite galu' masu'ba gabi'li', Yesu aatibu'ka yenda ku Galilaya, ");
INSERT INTO mgw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","mwanjaa Yesu mwene aalongei mpu'la panga, “Nnondoli wa Nnu'ngu' aisimilwali panni'ma wake.” ");
INSERT INTO mgw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bai paikite Galilaya, Agalilaya baingi baatikunkemya, kwa mwanjaa nabembe baabile kusi'li'ku'si'li'ku' ya Pasika, baagabweni makowe gagapangite Yesu akwo Yelusalemu ku Pasika. ");
INSERT INTO mgw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu aaikite kai' kukilambo sa kana, kunkoa wa Galilaya, pandu paagalambwiye masi' panga divai. Kwaabile na mpi'ndo yumo ywa silikali ywaabile na mwana ntamwe akwo ku Kapernaumu. ");
INSERT INTO mgw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bai, ayo mundu paayu'wine panga Yesu aaisi popo pa Galilaya bu'ka ku Yudea, aatikunnyendelya na kunnu'ba aise antepwe mwana wake ywaabile ntamwe katetelya. ");
INSERT INTO mgw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ngammakia, “Mwabandu mwenga mana mukotwike kwibona myanju na mangelongelo mwau'bi'lyali katu.” ");
INSERT INTO mgw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yu'lu' mpi'ndo ywa silikali ngammakia, “Bwana, nikulu'ba wise mwana wangu' abile balo anawaali.” ");
INSERT INTO mgw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu ngammakia, “Uyende bai, mwana wako ayu'yu'kilwe.” Aywo mundu ngau'bi'lya gaalongei Yesu, ngabu'ka. ");
INSERT INTO mgw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Paabile mundi'la aakwembine na atumisi bake ngabammakia panga, mwana wake aai mwu'mi. ");
INSERT INTO mgw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nembe ngalaluya saa yayu'yu'kilwe mwana, ngabammakia, “Nsango wammu'i liso musaa saba ya muntwekati.” ");
INSERT INTO mgw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Abo tati' ba mwana ngabaku'mbu'kya panga ayo nga yai saa yabakiyilwe na Yesu, “Mwana wako ayu'yu'kilwe.” Kwa nyo ywembe pamope na boti ba panyumba yake ngabamwu'bi'lya Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Awo waai mwanju wenebi'li' waupangite Yesu kabu'ka Yudea yenda Galilaya. ");
INSERT INTO mgw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bu'ka pa go kwai na si'li'ku'si'li'ku' ya Ayahudi, nembe Yesu ngayenda ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Akwo Yelusalemu papipi na nniango waukemelwa Nniango wa Ngondolo, kwabile na litanda lya masi' lyalyaakemilwe kwa Kiebrania Bethzatha. Litanda lyo lyati'li'ti'yilwe na yega tano. ");
INSERT INTO mgw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Apo paai na bandu masikini baingi, atu'lu'ka minyo, itewe na babatombolwike, bali'ndage masi' gayu'geyu'ge. ");
INSERT INTO mgw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwa mwanjaa malaika wa Bwana aaulwike kwo kokotya nkati ya li'lu' litanda, na kugatikatika masi'. Ntamwe ywalongolya yingya nkati ya litanda masi' paliyu'gayu'ga, utamwe wowoti waminyage, waatibu'ka. ");
INSERT INTO mgw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bai, apo paabile na mundu yumo ywai ntamwe kwa myaka salasini na minane. ");
INSERT INTO mgw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu paamweni aywo mundu agonjike, naywembe aatangite panga aabile ntamwe kwa myaka yambone ngammakia, “Upala ube wankoto?” ");
INSERT INTO mgw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yu'lu' ntamwe ngayangwa, “Bwana, nenga ntu'pu' mundu ywa kuniyingiya mulitanda, masi' pagayu'gayu'ga. Kila pagayu'gayu'ga, nipaya yingya nkati ya masi', mundu ywi'ngi' anilongolya yingya.” ");
INSERT INTO mgw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu ngammakia, “Uyi'me witwi'ke likai lyako, uyende kwa magu'lu' gako.” ");
INSERT INTO mgw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Imukya, yu'lu' mundu atepulilwe ngatola likai lyake no tumbwa yenda. Likowe lyo lyapangike lisu'ba lya Sabato ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kwa nyo, bi'ngi' ba api'ndo ba Ayahudi bammakie aywo mundu ywatepulilwe, “Li'no lisu'ba lya Sabato, iyi'ki'ti'lwali pu'twa likai lyako.” ");
INSERT INTO mgw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lakini ywembe ngaabakia, “Yu'lu' mundu ywanitepwile ngaywanibakiye, ‘Upu'twe likai lyako uyende.’” ");
INSERT INTO mgw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nabembe ngabannaluya, “Nyai ywakubakiye ‘Upu'twe likai lyako uyende?’” ");
INSERT INTO mgw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bai, yu'lu' mundu ywatepulilwe aantangiteli mundu ywantepwile, kwa mwanjaa Yesu ayomwike bu'ka kwa kinunu pandu po pabaatwi'li bandu. ");
INSERT INTO mgw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bu'kapo Yesu aankwembite yu'lu' mundu ywantepwile munyumba ya Nnu'ngu' ngammakia, “Nambi'yambi' uponi, kaneupange sambi kai', lyakane kupata likowe lyakau pi'ta li'.” ");
INSERT INTO mgw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yu'lu' mundu ngayenda kwabakia api'ndo ba Ayahudi panga Yesu ngaywanitepwile. ");
INSERT INTO mgw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa nyo, api'ndo ba Ayahudi baatumbwi kunku'su'mbwa kwa mwanjaa apangage makowe go lisu'ba lya Sabato yabe. ");
INSERT INTO mgw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu ngayangwa, “Tati' bangu' bapanga kasi kila lisu'ba, kwa nyo nanenga nganipanga.” ");
INSERT INTO mgw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa kitumbu sa makowe ga, api'ndo ba Ayahudi baapalike kila ndi'la ya kummulaga Yesu, kwenda kwa kitumbu sa kwiti'kwana Sabato bai lili, ila kwa kunkema Nnu'ngu' Tati' bake naywembe abile nsawani nakwe. ");
INSERT INTO mgw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu ngaabakia, “Kakape nendakummakianga, Mwana akombwali panga likowe lya kisake. Ywembe apanga li'lu' lyaabona Tati' bake kabapanga, kwa mwanjaa lyolyoti lyalipangilwa na Tati', Mwana alipanga nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mwanjaa Tati' bampenda Mwana na kunnaya galu' gabagapanga bene Tati', naywembe alu'a kunnaya lyengo liku'lu' kulikoni li', li'nga musangale. ");
INSERT INTO mgw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kati mwaibile Tati' kwayu'ya babawile na kwapeya ukoto, nyinyonyo na Mwana kwapeya ukoto bandu kati mwapala. ");
INSERT INTO mgw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kai' Tati' bansenwali mundu ywoywoti, ila bampei Mwana uweso woti wo senwa, ");
INSERT INTO mgw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","li'nga bandu boti bamwisimu Mwana kati mu'lu' mwabaaisimu Tati'. Ywakana kumwisimu Mwana, akana kwaisimu Tati' babaantumike Mwana. ");
INSERT INTO mgw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kakape nimmakianga, ywayu'wa liyi'gi'yo lyangu' na kumwu'bi'lya yu'lu' ywanitumike abile na ukoto wangayomoka. Alu'a senulwali katu, ila ayomwike pi'ta bu'ka mukiwo no yingya muukoto. ");
INSERT INTO mgw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kakape nimmakianga, nsimu wendaisa, kai' wisile panga babawile baaliyu'wa lilobe lya Mwana wa Nnu'ngu', na babaaliyu'wa lilobe lyo baapanga bau'mi. ");
INSERT INTO mgw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kati Tati' mwababile kitumbu sa bwu'mi, nyinyonyo bannyali Mwana uweso wo piya ukoto kwa bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kai', ampeile Mwana wake utawala wo senwa, kwa mwanjaa ywembe Mwana wa Mundu. ");
INSERT INTO mgw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kanemusangale yu'wa makowe gano, kwa mwanjaa saa yendaisa payapanga bababile mumasiko baaliyu'wa lilobe lyake, ");
INSERT INTO mgw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nabembe baayu'ka. Balu' babaapangite manogau baayu'ka no tama bau'mi, balu' babaapangite malau baayu'ka no senulwa. ");
INSERT INTO mgw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nenga nikombwali panga kikowe sosoti kwa makakala gangu' namwene. Mwaniyu'wa, nga mwanisenwa. Nisenwa kwa aki, kwa mwanjaa nipalali panga ganipala namwene, ila nipanga mwabapala Tati' babaanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mana kaniikong'ondelya namwene, ukong'ondeli wangu' uyi'ki'ti'lwali panga wa kakape. ");
INSERT INTO mgw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lakini kubile na ywi'ngi' ywanikong'ondelya, nanenga nitangite panga kong'ondelya kwake kwa kakape. ");
INSERT INTO mgw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwenga mwatumike bandu kwa Yoani, nembe ngaikong'ondeli kweli. ");
INSERT INTO mgw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenga niu'bi'lyali ukong'ondeli wa mundu, ila nilibaya li', li'nga mwenga mukosopolelwe. ");
INSERT INTO mgw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoani aai kati lumuli lwaluyakage no piya bweya, namwenga pamuubweni bweya wake, ngamunapusika na awo bweya kwa mpi'to. ");
INSERT INTO mgw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Lakini nenga namwene nibile na ukong'ondeli wangu' nku'lu' kulikoni wu'lu' wa Yoani. Kwa mwanjaa mengo ganigapanga nga galu' gabanitumike Tati' nigatimise. Yaani mangelongelo gakong'ondelya panga Tati' ngabanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Tati' babaanitumike bakong'ondeli bu'kana na nenga. Wala munayu'wali katu lilobe lyabe, ata kwaabona mwababile, ");
INSERT INTO mgw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","kai', mwenga muliyi'ki'tili liyi'gi'yo lyake, kwa mwanjaa mumwu'bi'li li ywembe ywantumike. ");
INSERT INTO mgw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwenga mupekeseni Maandiko Mapeleteu mukitage nkati yake mulu'a pata ukoto wangayomoka, kumbe Maandiko gogogo nga gaganikong'ondelya nenga. ");
INSERT INTO mgw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lakini mwenga mukana kuniu'bi'lya nenga li'nga mupate ukoto. ");
INSERT INTO mgw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nenga nipalali lumbilwa na bandu. ");
INSERT INTO mgw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini nintangite mwenga, panga mumpendili Nnu'ngu' mumyoyo yinu. ");
INSERT INTO mgw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nenga niisi kwa utawala wa Tati' bangu', lakini munipokili. Ila mundu ywi'ngi' mana aisi kwa utawala wake mwene, mwampokya. ");
INSERT INTO mgw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwenga mukombwabuli u'bi'lya manaitei mupeyana utukupu mwabene na bene, lakini mubiniali kuupala utukupu waubu'ka kwa Nnu'ngu'? ");
INSERT INTO mgw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wala kanemuganiye panga nenga nalu'a kunsitakya kwa Tati', abile ywansitakya nga Musa ywamumwu'bi'lya mwenga. ");
INSERT INTO mgw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kenda kakape mukamwu'bi'lya Musa, mulu'e niu'bi'lya nanenga, kwa mwanjaa ywembe aandike abali yangu'. ");
INSERT INTO mgw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lakini manaitei mugau'bi'lyali gaandike Musa, mulu'a gau'bi'lya buli ganigalongela?” ");
INSERT INTO mgw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bu'ka pa go, Yesu aayi'i kwiyi' ya baali ya Galilaya, lina li'ngi' ikemelwa Baali ya Tibelia. ");
INSERT INTO mgw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kipi'nga kiku'lu' sa bandu satikummi'ngi'ya, kwa mwanjaa baibweni myasu ya mangelongelo gaagapangite kwa atamwe. ");
INSERT INTO mgw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nembe Yesu aau'bwike pakitu'mbi', aatami kwo pamope na banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na si'li'ku'si'li'ku' ya Pasika ya Ayahudi yai kaiegelya. ");
INSERT INTO mgw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu paalingite, na kukibona kipi'nga kiku'lu' sa bandu kakimwisilya, ngammakia Pilipi, “Tukapi'me kwaku' makati li'nga bandu ba bapate lya?” ");
INSERT INTO mgw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aannalwiye nyo kwa kumpaya, kwa mwanjaa aatangite lyo panga. ");
INSERT INTO mgw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipi ngannyangwa, “Ata mbanje dinali mya ibi'li' ili'nganali pi'ma makati ga kwapeya bandu ba walau kila mundu apate king'esu kisini.” ");
INSERT INTO mgw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yumo ywa banamasi' bake, ywakemilwe Andelea nnunawe Simoni Petili, ngammakia, ");
INSERT INTO mgw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pano abile munsembe yumo, abile na makati matano na omba abi'li' asene asene. Lakini ayi' kwa kipi'nga sa bandu ba, alu'a lya nyai, no igala nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu ngabaya, “Mwatamike bandu pakitamo.” Pandu po paabile na manyei gambone, na bandu ngabatama. Paabile na analu'me elupu tano. ");
INSERT INTO mgw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu ngatola makati na kunsukulu Nnu'ngu'. Ngatumbwa kwabagana balu' bandu babaabile mwitamo, kila mundu mwapala lya. Aapangite nyinyonyo ata kwa balu' omba. ");
INSERT INTO mgw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bandu boti pabaayomwi lya no yukuta, ngaabakia banamasi' bake, “Mukongwe ing'esu yoti yaiigile, li'nga yakane alabika.” ");
INSERT INTO mgw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bai, ngabakongwa ing'esu yoti ya makati matano yabaigiye balu' bandu, baatwi'liye itu'ndu' ku'mi na ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bandu pabaubweni mwasu waupangite Yesu, ngababaya, “Kakape ayu' nga yu'lu' Nnondoli wa Nnu'ngu' ywaisa padunia!” ");
INSERT INTO mgw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu pakwipwi panga bapalage isa bampange nkulungwa wabe kwa makakala, ngaegela pabaabile ngayenda pakitu'mbi' ywembe kisake. ");
INSERT INTO mgw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Paiikite kitamwiyo, banamasi' bake baaeleli kulitanda liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Baayingi mungalaba, baatumbwi loka litanda liku'lu' yenda Kapernaumu. Saa yo yaai ya lubi'ndu' na Yesu aai anakwembanali nabo. ");
INSERT INTO mgw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na litanda liku'lu' lyendetikatika kwa kitumbu sa nsunga nkali' waupukatyage. ");
INSERT INTO mgw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Banamasi' pabayi'i kilometa tano au sita, ngabammona Yesu kayenda na magu'lu' panani ya masi' kaiegelya ngalaba, ngabayogopa muno. ");
INSERT INTO mgw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu ngaabakia, “Nenga pano, kanemuyogope.” ");
INSERT INTO mgw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bai, bapalage kumpu'twa Yesu mungalaba yabe, baimukya, ngalaba iikite kuuyu'mu' kwabayendage. ");
INSERT INTO mgw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pammalau' yake, kipi'nga sa bandu babaigile liyi' lyenebi'li' lya litanda baatangite panga palu' kwabile na ngalaba yimo bai, na Yesu aalongwaniyeli nabo mungalaba yo, ila banamasi' bo baayi'i kisabe. ");
INSERT INTO mgw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lakini ngalaba yi'ngi' bu'ka Tibelia yaikite papipi na palu' pabaalile makati, bu'ka pa Yesu kunsukulu Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bai, abo bandu pabakwipwi panga Yesu na banamasi' bake baabileli pandu po, ngabau'bu'ka mungalaba yenda Kapernaumu kumpala. ");
INSERT INTO mgw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Balu' bandu pabankwembite Yesu kwiyi' ya litanda baatikunnaluya, “Mwalimu, waikite pakubawi pano?” ");
INSERT INTO mgw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu ngaayangwa, “Kakape nimmakianga, munipalali kwa kitumbu sa myasu ya mangelongelo gamugabweni, ila munipala kwa mwanjaa mwaalile galu' makati no yukuta. ");
INSERT INTO mgw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kanemuyomwe malango ginu kwo panga lyengo kwa kilyo sakilu'la, muganiye no panga lyengo kwa kilyo sangalu'la sakimpeyanga ukoto wangayomoka. Mwana wa Mundu, ywakong'ondelilwe na Nnu'ngu', alu'a kumpeya kilyo so.” ");
INSERT INTO mgw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nabembe ngabannaluya, “Tupange buli li'nga tukombwe kugapanga mengo ga Nnu'ngu'?” ");
INSERT INTO mgw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ngayangwa, “Li'no nga lyengo lyalipala Nnu'ngu' mulipange, kumwu'bi'lya yu'lu' ywantumike.” ");
INSERT INTO mgw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Apo ngabannaluya, “Ulu'a panga mwasu waku' tuubone li'nga tukuu'bi'li? Ulu'a panga kikowe gani? ");
INSERT INTO mgw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Au'ku' bitu baalile kilyo sasaakemilwe ‘mana’ ku'lu' kulubele, kati mwagabaya maandiko, ‘Aapei makati bu'ka kunani li'nga balye.’” ");
INSERT INTO mgw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu ngaabakia, “Kakape nimmakianga, ywampeyangite makati bu'ka kunani Musa lili, ila Tati' bangu' ngabampeyanga makati ga kakape bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwa mwanjaa likati lya Nnu'ngu' nga yu'lu' ywauluka bu'ka kunani na kwipeya dunia ukoto.” ");
INSERT INTO mgw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ngabammakia, “Bwana, utupei alyo likati masu'ba goti.” ");
INSERT INTO mgw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu ngaabakia, “Nenga nga na likati lya ukoto. Ywaisa kasangu' aaminyali njala, na ywaniu'bi'lya aaminyali nnyota katu. ");
INSERT INTO mgw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lakini kati mwanimmakie, pamope no panga munibweni lakini mwu'bi'lyali. ");
INSERT INTO mgw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Balu' boti baanipeya Tati' baaisa kasangu', na ywoywoti ywaisa kasangu', katu nankanali. ");
INSERT INTO mgw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwa mwanjaa niulwike bu'ka kunani li'nga nipange ganipala lili, ila nipange gapala ywembe ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aga nga gapala ywembe ywanitumike, panga kanenimwobeye ata yumo ywa balu' baanipeile, ila naayu'ye lisu'ba lya kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwa mwanjaa sabapala Tati' bangu' nga si'no, kila ywammona Mwana na kumwu'bi'lya abe na ukoto wangayomoka, nanenga nalu'a kunnyu'ya lisu'ba lya kuundi'la.” ");
INSERT INTO mgw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bai, Ayahudi baatumbwi ku'ku'li'ka kwa mwanjaa Yesu aabakie panga ywembe nga likati lyaliulwike bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ngababaya, “Ayu' mwana wa Yusupu li, tati' bake na mau' bake batwatangite? Akombwabuli baya, ‘Niulwike bu'ka kunani?’” ");
INSERT INTO mgw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu ngaabakia, “Kanemuku'ku'li'kyane mwaboti mwabamo. ");
INSERT INTO mgw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ntu'pu' mundu ywakombwa isa kasangu' mpaka autilwe na Tati' bangu' babanitumike, nanenga nannyu'ya lisu'ba lya kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Alondoli ba Nnu'ngu' baatiandika, ‘Bandu boti baayi'ganilwa na Nnu'ngu'.’ Kila mundu ywaayu'wa na kwiyi'gana bu'ka kwa Tati', aaisa kasangu'. ");
INSERT INTO mgw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pano ilombolyali panga kubile na mundu ywoywoti ywaabweni Tati', ila yu'lu' ywaumi kwa Nnu'ngu', aywo ngaywaabweni Tati'. ");
INSERT INTO mgw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kakape nimmakianga, ywau'bi'lya abile na ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenga nga na likati lya ukoto. ");
INSERT INTO mgw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Au'ku' binu baalile kilyo sasaakemilwe ‘mana’ ku'lu' kulubele, lakini baawile. ");
INSERT INTO mgw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lakini ali' likati lyaliuluka bu'ka kunani, lyembe mundu ywoywoti mana alile, aawali. ");
INSERT INTO mgw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenga na likati lya ukoto li'lu' lyalibu'i kunani. Mundu ywoywoti mana alile likati li' alu'a ba na ukoto wangayomoka. Likati li' nga yi'ga yangu' yanaaipiya li'nga dunia ipate ukoto.” ");
INSERT INTO mgw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bai, Ayahudi baatitaukana bene na bene kababaya, “Akombwabuli mundu yu' kutupeya yi'ga yake tulye?” ");
INSERT INTO mgw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kwa nyo Yesu ngaabakia, “Kakape nimmakianga, mana mukotwike kuilya yi'ga ya Mwana wa Mundu na kuinywa myai yake, kakape mwaalamali. ");
INSERT INTO mgw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundu ywoywoti ywailya yi'ga yangu' na kwinywa myai yangu', abi na ukoto wangayomoka. Nane nannyu'ya lisu'ba lya kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwa mwanjaa yi'ga yangu' nga kilyo sa kakape na myai yangu' nga kinywo sa kakape. ");
INSERT INTO mgw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ywalya yi'ga yangu' na kuinywa myai yangu' aatama nkati yangu' nanenga naatama nkati yake. ");
INSERT INTO mgw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kati mu'lu' Tati' babanitumike nenga mwababile bau'mi, nanenga nankoti kwa Tati', nyinyonyo nembe ywanilya nenga aapanga nkoto kwa kitumbu sangu'. ");
INSERT INTO mgw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Li'no nga likati lyaliuluka bu'ka kunani, kwenda kati likati li'lu' lyabalile au'ku' binu na baawile. Ywalya likati li', ukoto wake waayomokali.” ");
INSERT INTO mgw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu aalongei makowe go paabile kayi'gana munyumba ya kunnu'ba Nnu'ngu' akwo ku Kapernaumu. ");
INSERT INTO mgw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Baingi ba banamasi' bake pabaayu'wine likowe li' ngababaya, “Mayi'gano ga ganonwipe. Nyai ywakombwa kugapokya?” ");
INSERT INTO mgw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu aatangite panga banamasi' bake bendaku'ku'li'ka bu'kana na mayi'gano gake, ngaabakia, “Kitiwi, likowe li' limpanga muku'bale? ");
INSERT INTO mgw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ilu'e panga buli, mukammona Mwana wa Mundu kau'bu'ka buyangania kwaumi? ");
INSERT INTO mgw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Loo wa Nnu'ngu' nga yaileta ukoto, yi'ga ipwaikali. Makowe ga ganimmakie nga Loo na ukoto. ");
INSERT INTO mgw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lakini mwabi'ngi' binu muu'bi'lyali.” (Mwanjaa Yesu aatangite bu'ka patumbu balu' babaalu'a kana kumwu'bi'lya pakati yabe, na yu'lu' ywaalu'a kunsongya.) ");
INSERT INTO mgw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aayendeli baya, “Asi' nga kitumbu sanammakie panga ntu'pu' mundu ywakombwa isa kasangu' ila yu'lu' ywayaliwite na Tati' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bu'ka lisu'ba lyo, apwasi bake baingi baabuyangani nsu'gu', na baalongwaniyeli nakwe kai'. ");
INSERT INTO mgw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kwa nyo, Yesu aalalwiye balu' banamasi' bake ku'mi na abi'li', “Buli, namwenga mpala bu'ka kai'?” ");
INSERT INTO mgw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petili ngannyangwa, “Bwana, tubu'ke tuyende kwa nyai? Wenga ubile na mayi'gi'yo ga ukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Twenga twendau'bi'lya no tanga panga wenga nga wa Mpeleteu wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu ngaabakia, “Buli, ninsawangiteli mwenga ku'mi na abi'li'? Ata nyo, yumo mukipi'nga sinu nga moka!” ");
INSERT INTO mgw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu aalongei go bu'kana na Yuda, mwana wa Simoni Isikalioti, kwa mwanjaa ayu' ngaywaalu'a kunsongya, pamope no panga aai yumo ywa balu' ku'mi na abi'li'. ");
INSERT INTO mgw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bu'ka pa makowe go Yesu aayi'i tyangilya ku Galilaya. Aakani yenda kunkoa wa Yudea, kwa mwanjaa api'ndo ba Ayahudi bapalage kummulaga. ");
INSERT INTO mgw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Si'li'ku'si'li'ku' ya Ibanda ya Ayahudi yai kaiegelya. ");
INSERT INTO mgw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bai, anunabe ngabammakia, “Ubu'ke pano, uyende Yudea li'nga banamasi' bako bakagabone mengo gaugapanga. ");
INSERT INTO mgw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mundu mana kaapala tanganikwa, apangali makowe gake kwo iya. Mana kaupanga makowe ga, wilaye kwa dunia.” ");
INSERT INTO mgw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Kwa mwanjaa anunabe baamwu'bi'li lili.) ");
INSERT INTO mgw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu ngaabakia, “Wakati wangu' waupwaika balo unatimyali, lakini kwinu mwenga kila wakati wendapwaika. ");
INSERT INTO mgw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dunia ikombwali kunsukwa mwenga, lakini dunia inisukwa nenga kwa mwanjaa naakong'ondelya makowe maakau gabapanga. ");
INSERT INTO mgw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mwenga muyende kusi'li'ku'si'li'ku' yo. Nenga niyendali, kwa mwanjaa wakati waupwaika kwangu' nenga unaikali.” ");
INSERT INTO mgw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nembe payomwi kwabakia makowe go, aaigali ku Galilaya. ");
INSERT INTO mgw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lakini anunabe pabaabu'i yenda kusi'li'ku'si'li'ku', nembe Yesu aayi'i, lakini kwa kinunu. ");
INSERT INTO mgw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Api'ndo ba Ayahudi baabile kabampala akwo kusi'li'ku'si'li'ku' no laluyana, “Ayu' mundu ai kwaku'?” ");
INSERT INTO mgw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwaabile na bandu kabataunana makutu pandu po pabaamesekine bandu bu'kana na Yesu, bandu bi'ngi' kababaya, “Mundu nnogau,” bi'ngi' kababaya, “Lili, ywembe aakonga bandu.” ");
INSERT INTO mgw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lakini ntu'pu' mundu ywaalongei mpu'la bu'kana na ywembe, kwa mwanjaa baayogopage api'ndo ba Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pakati ya si'li'ku'si'li'ku', Yesu aatiu'bu'ka yenda muluwa lwa nyumba ya Nnu'ngu', ngatumbwa yi'gana. ");
INSERT INTO mgw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayahudi baatisangala mu'lu' mwayi'ganage, ngababaya, “Mundu yu' akombwi buli kugamanya makowe ga wangali yi'ganilwa?” ");
INSERT INTO mgw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu ngaayangwa, “Mayi'gano gangu' gabu'ka kwangu' namwene lili, ila kwa yu'lu' ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu ywoywoti mana kapanga mwapala Nnu'ngu', alu'a tanga panga mayi'gano gangu' gabu'ka kwa Nnu'ngu', au nilongela ga pamwoyo wangu' namwene. ");
INSERT INTO mgw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Balu' babalongela kwa kitumbu sabe bene bapanga nyo kwo linga utukupu wabe bene. Lakini ywembe ywapala utukupu wa yu'lu' ywantumike nga ywa kakape, ata ubu'su' ntu'pu' nkati yake. ");
INSERT INTO mgw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Buli, Musa ampeyangiteli mwenga salya? Lakini ntu'pu' ata yumo ywinu ywaikamwa salya. Mwanjaa namani mupala kunibulaga?” ");
INSERT INTO mgw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Si'lu' kipi'nga sa bandu ngakinnyangwa, “Wenga ubile na moka! Nyai ywapala kukubulaga?” ");
INSERT INTO mgw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu ngaayangwa, “Nipangite lyengo limo lisu'ba lya Sabato na mwaboti mutisangala. ");
INSERT INTO mgw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Lakini kwa mwanjaa Musa aampeyangite amuli ya liku'mbi', (pamope no panga yaumili kwa Musa, ila yaumi kwa kiu'ku'lu' binu) muina bana ata lisu'ba lya Sabato. ");
INSERT INTO mgw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Manaitei mundu awesa inilwa lisu'ba lya Sabato li'nga salya ya Musa yakane ti'kwanilwa, alyo, likowe lisene bai, mwanjaa namani mwenga muniusikya nenga kwa kuntepwa mundu lisu'ba lyo? ");
INSERT INTO mgw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kanemusenwe makowe kati mwamugalola kunja bai, ila musenwe kwa aki.” ");
INSERT INTO mgw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bai, bandu bi'ngi' ba Yelusalemu ngababaya, “Buli, ayu' nga yu'lu' ywabampala bammulage lili? ");
INSERT INTO mgw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mboni abile pano alongela pa bandu na bamakiali kikowe sosoti? Kwaali' alongosi batangite panga ayu' nga Kilisitu? ");
INSERT INTO mgw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lakini mundu yu' tutangite kwabu'ka, Kilisitu palu'a isa, ntu'pu' ywoywoti ywalu'a tanga kwabu'ka.” ");
INSERT INTO mgw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu aayendeli yi'gana mu Nyumba ya Nnu'ngu', aau'bwiye lilobe kabaya, “Mwenga munitangite no tanga kwanibu'ka. Nenga niisili kwa kitumbu sangu' namwene, ila ywembe ywanitumike ywa kakape, na mwenga muntangiteli. ");
INSERT INTO mgw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Lakini nenga nintangite, kwa mwanjaa nibu'ka kasake naywembe ngaywanitumike.” ");
INSERT INTO mgw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngabapala kummoywa, lakini ntu'pu' mundu ywoywoti ywapayite kunkunywa, kwa mwanjaa saa yake yai inaikali. ");
INSERT INTO mgw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na bandu baingi palu' pa kipi'nga sa bandu ngabamwu'bi'lya, ngababaya, “Buli, Kilisitu paaisa, alu'a laya myasu miku'lu' kulikoni gaagapangite mundu yu'?” ");
INSERT INTO mgw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo baayu'wine bandu kabayu'yu'ta makowe kati go bu'kana na Yesu, ngapo bembe pamope na api'ndo ba dini ngabatuma ali'ndi'li li'nga bakammoywe. ");
INSERT INTO mgw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu ngabaya, “Nenga balo nibile pamope na mwenga kwa masu'ba masini, bu'kapo nabuyangania kasake ywembe ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwanipala lakini mwanibonali, kwa mwanjaa mukombwali ika pandu panalu'a ba.” ");
INSERT INTO mgw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Api'ndo ba Ayahudi baatilaluyana bene na bene, “Mundu yu' apala yenda kwaku' kwangali twenga kombwa kumpata? Buli, apala yenda kwa Agiliki, kwembe bi'ngi' ba bandu bitu baayi'i kwo akaayi'gane? ");
INSERT INTO mgw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ywembe alombolya ki'li' pabaya, ‘Mwanipala lakini mwanibonali, kwa mwanjaa mukombwali ika pandu panalu'a ba’?” ");
INSERT INTO mgw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lisu'ba lya kuundi'la ya si'li'ku'si'li'ku' lisu'ba li'lu' liku'lu', Yesu aatiyi'ma no u'bu'ya lilobe lyake kabaya, “Manaitei mundu ywoywoti aminya nnyota, aise kasangu' anywe. ");
INSERT INTO mgw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kati mwagabaya Maandiko Mapeleteu, ‘Ywaniu'bi'lya nenga, mabi'ndi' ga masi' ga ukoto gaabutuka bu'ka mumwoyo wake.’” ");
INSERT INTO mgw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu paabaike ga, alombolyage Loo Mpeleteu ywaapokelelwa na boti babamwu'bi'li Yesu. Kwa nsimu wu'lu' Loo aai balo anatumilwali, kwa mwanjaa Yesu aai balo anakwi'yi'lwali. ");
INSERT INTO mgw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pabayu'wine makowe go, bandu bi'ngi' mukipi'nga si'lu' ngababaya, “Kakape ayu' nga yu'lu' Nnondoli wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bi'ngi' baatibaya, “Ayu' nga Kilisitu!” Lakini bi'ngi' baatilaluya, “Ilu'e wesekana buli Kilisitu aume ku Galilaya? ");
INSERT INTO mgw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiko Mapeleteu gabayali panga Kilisitu aabelekwa bu'ka mulukolo lwa Daudi akwo Betelehemu, kukilambo saatamage Daudi?” ");
INSERT INTO mgw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kwa nyo, bandu baatibaganika kwa kitumbu sa Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bi'ngi' babe bapalage kummoywa, lakini ntu'pu' ywalowite kummoywa. ");
INSERT INTO mgw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bu'kapo, balu' ali'ndi'li ngababuyangania kwa api'ndo ba dini na Mafalisayo babaatumike kummoywa Yesu, ngabalaluyilwa, “Mwanjaa namani mukotwike kunneta?” ");
INSERT INTO mgw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ali'ndi'li ngabayangwa, “Tunannyu'wali mundu ywalongela kati mwalongela mundu yu'lu'!” ");
INSERT INTO mgw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bai, Mafalisayo ngabaalaluya, “Buli, namwenga mukongilwe kai'? ");
INSERT INTO mgw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ywaku' mukipi'nga sa api'ndo bitu au mukipi'nga sa Mafalisayo ywamwu'bi'lile? ");
INSERT INTO mgw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lakini bandu ba babakotwike tanga salya ya Musa, bakosite lasi.” ");
INSERT INTO mgw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ngapo Nikodemo, yu'lu' ywaannyendeli Yesu lisu'ba limo nembe aai yumo mukipi'nga sa Mafalisayo, ngalaluya, ");
INSERT INTO mgw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Buli, musalya yitu yendayi'ki'ti'lwa kunsenwa mundu wangali kumpi'kania no tanga sapangite?” ");
INSERT INTO mgw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nabembe ngabannyangwa, “Buli, nawenga kai' ubu'ka Galilaya? Upekeseni nawenga ulu'a tanga panga ntu'pu' Nnondoli ywa Nnu'ngu' ywabu'ka ku Galilaya!” ");
INSERT INTO mgw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bai, kila mundu ngabu'ka yenda kasake. ");
INSERT INTO mgw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kila mundu aabuyangani kasake, lakini Yesu ngayenda mpaka ku Kitu'mbi' sa Minjaituni. ");
INSERT INTO mgw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pammalau' yake kindai' putiputi, aayi'i kai' munyumba ya Nnu'ngu'. Bandu boti ngabannyendelya, naywembe ngatama no tumbwa kwayi'gana. ");
INSERT INTO mgw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bai, balimu ba salya na Mafalisayo ngabannetya nnwawa yumo ywaboyolilwe bwalipu, ngabannyi'mi'ka pakatikati yabe. ");
INSERT INTO mgw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bu'kapo ngabannaluya Yesu, “Mwalimu, nnwawa yu' aboyolilwe bwalipu. ");
INSERT INTO mgw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musalya yitu Musa aatulagi panga nnwawa kati yu' aku'mbu'lwe maliwe. Bai, wenga ubaya buli?” ");
INSERT INTO mgw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Banalwiye liswali li', kwa kumpi'ndi'ka li'nga bapate kitumbu sa kunsitakya. Lakini Yesu ngayinama pai' no andika mubwi' kwa lukonji lwake. ");
INSERT INTO mgw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pabaayendeli kunnaluya, Yesu ngakatuka, ngaabakia, “Mundu ywangali sambi kasinu, atumbwe kunku'mbwa liwe.” ");
INSERT INTO mgw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bu'kapo ngayinama kai' no andika mubwi'. ");
INSERT INTO mgw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pabayu'wine nyo, ngabatumbwa bu'ka yumo yumo baalongoli agoi, Yesu aaigile kisake na yu'lu' nnwawa aayi'mi papalu'palu'. ");
INSERT INTO mgw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu paakatwike ngannaluya yu'lu' nnwawa, “Nnwawa, bai kwaku' balu' bandu babaakusitakile? Buli, ntu'pu' ata yumo ywakusenwile?” ");
INSERT INTO mgw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yu'lu' nnwawa ngannyangwa, “Bwana, ntu'pu' ata yumo!” Yesu ngammakia, “Ata nenga nikusenwali. Uyende bai, ila bu'ka nambi'yambi' kaneupange sambi kai'.” ");
INSERT INTO mgw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu paalongei nabo bandu kai', aatikwabakia, “Nenga nga na bweya wa padunia. Ywanikota nenga ayendali mulubi'ndu' katu, ila alu'a ba na bweya wa kumpeya ukoto.” ");
INSERT INTO mgw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bai, Mafalisayo ngabammakia, “Ukong'ondeli wako uyi'ki'ti'lwali, kwa mwanjaa wikong'ondelya wamwene.” ");
INSERT INTO mgw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu ngaayangwa, “Ata mana kaniikong'ondelya namwene, ukong'ondeli wangu' ngawa kakape kwa mwanjaa nitangite kwaniumi na kwaniyenda. Lakini mwenga mutangiteli kwaniumi wala kwaniyenda. ");
INSERT INTO mgw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwenga muukumu kwo koleya makowe ga bandu, lakini nenga nimuukumuli mundu. ");
INSERT INTO mgw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lakini ata mana nipiyite ukumu, ukumu kwangu' kwa kakape kwa mwanjaa nenga niukumuli kisangu' ila na Tati' babanitumike babile pamope nanenga. ");
INSERT INTO mgw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iandikilwe musalya yinu panga ukong'ondeli wa bandu abi'li' ngawa kakape. ");
INSERT INTO mgw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nenga niikong'ondelya namwene, nabembe Tati' babanitumike bendanikong'ondelya nyinyonyo.” ");
INSERT INTO mgw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Apo ngabannaluya, “Tati' bako bai kwaku'?” Yesu ngaayangwa, “Mwenga munitangiteli nenga wala mwatangiteli Tati' bangu'. Ikapanga munitangite nenga, mulu'e kwatanga na Tati' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu aagalongei mayi'gi'yo go papipi na lisanduku lya mabi'ko, paabile kayi'gana munyumba ya Nnu'ngu'. Lakini ntu'pu' mundu ywammoywile, kwa mwanjaa saa yake yaai inaikali. ");
INSERT INTO mgw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu ngaabakia kai', “Nendabu'ka, mwenga mwaalu'a nipala, lakini mwalu'a waa mumasambi ginu. Kwaniyenda nenga, mwenga mukombwali ika.” ");
INSERT INTO mgw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bai, alongosi ba Kiyahudi ngababaya, “Ywembe abaya panga kwayenda twenga tukombwali ika, buli, ayenda kwibulaga?” ");
INSERT INTO mgw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ngaabakia, “Mwenga muuma paapanopano pai', nenga niuma kunani. Mwenga mwa ba padunia yi'no ila nenga na ywa padunia yi'no lili. ");
INSERT INTO mgw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kwa nyo nammakiangite panga mwalu'a waa mumasambi ginu. Mana mukotwike u'bi'lya panga nenga nga naywembe, mwalu'a waa mumasambi ginu.” ");
INSERT INTO mgw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nabembe ngabannaluya, “Wenga wa nyai?” Yesu ngaayangwa, “Nenga nga yu'lu' ywanammakiangite bu'ka patumbu! ");
INSERT INTO mgw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nibile na makowe gambone ga kummakia na ga kumuukumu mwenga, Lakini yu'lu' ywanitumike nga ywa kakape, nanenga niibakia dunia makowe galu' ganigayu'wine bu'ka kasake.” ");
INSERT INTO mgw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Baatangiteli panga Yesu aabile kaalongelya Tati' bake. ");
INSERT INTO mgw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bai, Yesu ngaabakia, “Bu'ka pamwantu'ndu'bi'ya Mwana wa Mundu kunani, ngapamwatanga panga nenga nga naywembe no panga nipangali sosoti nenga namwene, ila nilongela galu' gabaniyi'ganiye Tati' bai. ");
INSERT INTO mgw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yu'lu' ywanitumike ai pamope nanenga. Ananilekali, kwa mwanjaa masu'ba goti nipanga gagannogelelya ywembe.” ");
INSERT INTO mgw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Paabile kalongela go, bandu baingi ngabamwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bai, Yesu ngaabakia balu' Ayahudi babaamwu'bi'lile, “Mana mwagakoleya mayi'gano gangu', kakape mwapanga mwabanamasi' bangu'. ");
INSERT INTO mgw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Apo, ngaapo mwaitanga kakape, nayembe kakape ngayayalu'a kumpanga mube ulu.” ");
INSERT INTO mgw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bembe ngabannyangwa, “Twenga twa lubelekwo lwa Bulaimu, na tunapangali twaabanda kwa mundu ywoywoti katu, ukombwabuli baya, ‘Mulu'a ba ulu?’” ");
INSERT INTO mgw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu ngaayangwa, “Kakape nimmakianga, kila mundu ywapanga sambi nga mmanda wa sambi. ");
INSERT INTO mgw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Masu'ba goti, mmanda abalangilwali mukipi'nga sa alongo ba pakaya, lakini mwana abalangilwa mualongo ba pakaya masu'ba goti. ");
INSERT INTO mgw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mwanjaa, Mwana mana ampei uulu, kakape mwaalu'a panga ulu. ");
INSERT INTO mgw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ndangite panga mwenga mwa lubelekwo lwa Bulaimu. Ata nyo, mupala kunibulaga kwa mwanjaa mugayi'ki'tyali mayi'gi'yo gangu'. ");
INSERT INTO mgw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nenga nigabaya galu' ganaagabweni kwa Tati' bangu', na mwenga mugapanga galu' gamugayu'wine bu'ka kwa tati' binu.” ");
INSERT INTO mgw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bembe ngabannyangwa, “Twenga twa bana ba Bulaimu!” Yesu ngaabakia, “Ikapangage mwabana ba Bulaimu, mulu'e panga kati mwaapangage Bulaimu. ");
INSERT INTO mgw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nenga nimmakiangite ukakape wanaauyu'wine kwa Nnu'ngu', ata nyo mwenga mupala kunibulaga. Bulaimu aapangiteli nyo! ");
INSERT INTO mgw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwenga mupanga makowe gagalu'galu' gabapanga tati' binu.” Bembe ngabammakia, “Twenga twabana ba makowe ga mwiloli, tubile na Tati' bamo, naywembe nga Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu ngaabakia, “Ikapangage Nnu'ngu' nga Tati' binu, mulu'e kunipenda nenga, kwa mwanjaa nenga naaumi kwa Nnu'ngu', na nambi'yambi' nibile pano. Niisili kwa kitumbu sangu' namwene, ila kwa ywembe ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mwanjaa namani mugaomongwa ganimmakia? Kwa mwanjaa mukana kugayu'wa mayi'gi'yo gangu'. ");
INSERT INTO mgw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwenga nga mwabana ba Ibilisi, na mupala panga kati mwabapala tati' binu. Ywembe aai mmulagi bu'ka kwai'mbu', ntu'pu' ukakape kwa mwanjaa ukakape ubileli nkati yake. Kila palongela ubu'su', alongela bu'kana na kibelekwe sake, mwanjaa ywembe mmu'su' na tati' wa ubu'su'. ");
INSERT INTO mgw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nenga nilongela kakape, na kwa nyo mwenga muniu'bi'lyali. ");
INSERT INTO mgw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Buli, ywaku' kasinu ywakombwa kunikong'ondelya panga nenga nibi na sambi? Na mana kanimmakia ga kakape, kwa ki'li' mukotoka kuniu'bi'lya? ");
INSERT INTO mgw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ywaai ywa Nnu'ngu' api'kania mayi'gi'yo ga Nnu'ngu'. Lakini mwenga mupi'kaniali, kwa mwanjaa mwenga mwa bandu ba Nnu'ngu' lili.” ");
INSERT INTO mgw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayahudi ngabammakia, “Buli, twabaiteli panga kakape wenga ngawa Nsamalia, kai' ubile na moka?” ");
INSERT INTO mgw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ngaayangwa, “Nenga ntu'pu' moka. Naisimu Tati' bangu', lakini mwenga muniisimuli. ");
INSERT INTO mgw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nenga niipalyali utukupu wangu' namwene, abile yumo mwene kuupala utukupu wo, naywembe nga mwene makakala go ukumu. ");
INSERT INTO mgw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kakape nimmakianga, mundu ywagakoleya mayi'gi'yo gangu' aawali milele.” ");
INSERT INTO mgw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bai, Ayahudi ngababaya, “Nambi'yambi' kakape tutangite panga ubile na moka! Bulaimu aatiwaa, nyonyo na alondoli baatiwaa, na wenga ubaya ati', ‘Ywaagakoleya mayi'gi'yo gangu', aawali milele!’ ");
INSERT INTO mgw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Buli, wipanga wa nku'lu' kuliko tati' bitu Bulaimu, ywaawile? Kai', ata alondoli nabembe baatiwaa. Wenga wipanga wanyai?” ");
INSERT INTO mgw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ngaayangwa, “Mana niikwi'yite namwene, utukupu wangu' kili'be lili. Tati' bangu' bamwabaya mwenga nga Nnu'ngu' winu, bembe ngabanikwi'ya nenga. ");
INSERT INTO mgw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwenga mwatangiteli, lakini nenga naatangite. Na mana nibaite naatangiteli, nilu'a panga na mmu'su'bu'su' kati mwenga. Nenga naatangite na nigakoleya mayi'gi'yo gabe. ");
INSERT INTO mgw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tati' binu Bulaimu baatikwi'ndi'lya, kabau'bi'lya kulibona lisu'ba lyo isa kwangu', naywembe aatikulibona, nganapusika.” ");
INSERT INTO mgw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bai, Ayahudi ngabammakia, “Wenga balo unaikiyali myaka amusini, ubaya buli umweni Bulaimu?” ");
INSERT INTO mgw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ngaabakia, “Kakape nimmakianga, anabelekwali Bulaimu, ‘Nenga naabile.’” ");
INSERT INTO mgw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Apo ngabatondwa maliwe li'nga banku'mbwe, lakini Yesu ngayu'ba no pita panja ya nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu paabile kapi'ta, aamweni mundu yumo, mbulibuli bu'ka belekwa. ");
INSERT INTO mgw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bai, banamasi' ngabannaluya, “Mwalimu! Ywaku' ywapangite sambi, ayu' au abelei bake, mpaka abelekwe mbulibuli?” ");
INSERT INTO mgw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu ngaayangwa, “Likowe li' lipitikeli kwa kitumbu sa sambi yake ywembe, wala sambi ya abelei bake, ila aabelekwi mbulibuli li'nga makakala ga Nnu'ngu' gabonekane kagapanga kasi nkati yake. ");
INSERT INTO mgw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kubile balo muntwekati, tupalikwa yendelya panga lyengo lya yu'lu' ywanitumike, kwa mwanjaa kilo sendaisa so kotoka panga mundu lyengo. ");
INSERT INTO mgw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Panibaa mudunia, nenga nga nabweya wa padunia.” ");
INSERT INTO mgw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bu'ka po baya go ngaunia mmata pai', na kuutepengaya ukando kwa mmata gake, ngaampakaya yu'lu' mbulibuli mminyo, ");
INSERT INTO mgw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ngammakia, “Uyende ukauluwe mulitanda lya Siloamu.” (Siloamu lombolya, “Ywatumilwe”). Bu'kapo aywo mbulibuli ngayenda uluwa no buyangana kalola. ");
INSERT INTO mgw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bai, bapapipi yake na balu' boti babaabile kabammona apo patumbu panga aai nki'ba, kalu'balu'ba ngabatumbwa laluya, “Buli, ayu' nga yu'lu' nki'ba ywaabile katama no lu'balu'ba?” ");
INSERT INTO mgw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bi'ngi' babe ngababaya, “Nga ywembe.” Bi'ngi' baabaite, “Lili! Ila endalandana nakwe.” Lakini yu'lu' ywaabile mbulibuli ngabaya, “Nga nenga!” ");
INSERT INTO mgw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngabannaluya, “Minyo gako gaatepulilwe kitiwi?” ");
INSERT INTO mgw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naywembe ngaayangwa, “Yu'lu' mundu ywakemelwa Yesu, aatepengiye ukando, nganipakaya muminyo na kunibakia, ‘Uyende ukauluwe mulitanda lya Siloamu.’ Apo nenga nganiyenda uluwa, nganipata lola!” ");
INSERT INTO mgw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngabannaluya, “Aywo mundu we ai kwaku'?” Naywembe ngayangwa, “Ne ndangiteli!” ");
INSERT INTO mgw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bu'kapo ngabampeleka aywo mundu ywaabile mbulibuli kwa Mafalisayo. ");
INSERT INTO mgw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lisu'ba lyo Yesu lyaainyite utu'pi' na kummanjuya minyo mundu ywo, lyaai lisu'ba lya Sabato kwa Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bai, Mafalisayo ngabannaluya kai' mundu ywo, “Ukombwi buli lola?” Naywembe ngaabakia, “Aanipakiye utu'pi' mminyo, nanenga nganiuluwa na nambi'yambi' nendalola.” ");
INSERT INTO mgw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo bi'ngi' ngababaya, “Mundu yu' abu'ili kwa Nnu'ngu', kwa mwanjaa akamwali salya ya lisu'ba lya Sabato lya Ayahudi.” Lakini bi'ngi' ngababaya, “Mundu mwene sambi akombwabuli panga myanju kati yi'?” Ngakubaa na ntau nkati yabe. ");
INSERT INTO mgw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kwa nyo ngabannaluya kai' yu'lu' ywaai mbulibuli, “Wenga nga wautepulilwe minyo, ubaya buli kwa mundu ywo?” Ngaayangwa, “Ywembe nga nnondoli ywa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lakini api'ndo ba Ayahudi baau'bi'lili panga mundu ywo aai mbulibuli no pata lola mpaka pabaakemike abelei bake, ");
INSERT INTO mgw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ngabaalaluya, “Buli, ayu' nga mwana winu ywamubaya aabelekwi mbulibuli? Tumbwe akombwibuli lola?” ");
INSERT INTO mgw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abelei bake ngabayangwa, “Tutangite panga ayu' nga mwana witu, na aabelekwi mbulibuli. ");
INSERT INTO mgw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lakini apatike buli lola, tutangiteli, wala ywaantepwile minyo gake tuntangiteli. Munnaluye mwene, ywembe mundu mpi'ndo, endakombwa kwiawanikia.” ");
INSERT INTO mgw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abelei bake baabaite nyo kwa mwanjaa baayogopage api'ndo ba Kiyahudi, bembe bayi'ki'tyanie panga mundu ywoywoti ywaayi'ki'tya panga Yesu nga Kilisitu alu'a bi'ngi'lwa munyumba ya kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nga kitumbu sa abelei bake baya, “Ywembe mundu mpi'ndo, munnaluye mwene.” ");
INSERT INTO mgw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bai, api'ndo ba Kiyahudi bankemite kai' yu'lu' ywaabile mbulibuli ngabammakia, “Kakape baya nnu'ngi' ya Nnu'ngu'! Twenga tutangite panga mundu yu' ywakutepwile mwene sambi.” ");
INSERT INTO mgw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ywembe ngayangwa, “Nenga ndangiteli panga ywembe mwene sambi. Lakini kili'be simo sanitangite, naai na mbulibuli na nambi'yambi' nendalola.” ");
INSERT INTO mgw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bai, ngabannaluya, “Aakupangi ki'li'? Akutepwi buli minyo gako?” ");
INSERT INTO mgw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aywo mundu ngaayangwa, “Ngita nimmakiangite, mwenga munipi'kanili, kwa ki'li' mupala pi'kania kai'? Buli, na mwenga mupala ba mwabanamasi' bake?” ");
INSERT INTO mgw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lakini bembe ngabampwi'wa kababaya, “Wenga ngawa mwanamasi' wake, twenga twa banamasi' ba Musa. ");
INSERT INTO mgw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twenga tutangite panga Nnu'ngu' aalongei na Musa, lakini mundu yu' tutangiteli kwauma!” ");
INSERT INTO mgw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naywembe ngaayangwa, “Ali' likowe lyo sangala, mwenga mutangiteli kwauma, lakini nenga anitepwile minyo gangu'. ");
INSERT INTO mgw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tutangite panga Nnu'ngu' aapi'kaniali bandu bene sambi, ila api'kania boti babankilikitya na kunnyu'a. ");
INSERT INTO mgw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bu'ka umbilwa dunia, tunayu'wali panga kubile na mundu ywoywoti ywakombwa kuntepwa mundu ywaai mbulibuli bu'ka belekwa kwake. ");
INSERT INTO mgw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kenda mundu yu' aumali kwa Nnu'ngu', apelekombwali panga likowe lyolyoti!” ");
INSERT INTO mgw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bembe ngabannyangwa, “Wenga wa mwene sambi bu'ka belekwa kwako! Ukombwabuli kutuyi'gana twenga?” Bai, ngabammi'nga munyumba ya kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu paayu'wine panga bammi'ngite munyumba ya kunnu'ba Nnu'ngu' yu'lu' ywaabile mbulibuli, ngankolya na kunnaluya, “Buli wenga wendakumwu'bi'lya Mwana wa Nnu'ngu'?” ");
INSERT INTO mgw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yu'lu' mundu ngayangwa, “Bwana, nibakia ywembe nga nyai, li'nga nipate kumwu'bi'lya.” ");
INSERT INTO mgw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ngammakia, “Umweni, na nga ywaulongela nakwe nambi'yambi'.” ");
INSERT INTO mgw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bai, yu'lu' mundu ngabaya, “Bwana, nendau'bi'lya!” Ngankilikitya. ");
INSERT INTO mgw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ngabaya, “Nenga niisi mudunia li'nga ukumu ipate pangika, ilombolya balu' babakotoka lola bapate lola na babalola babe kimbulibuli.” ");
INSERT INTO mgw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo bi'ngi' babaabile pamope naywembe pabaayu'wine mayi'gi'yo go, ngabannaluya, “Buli, na twenga kai' twakimbulibuli?” ");
INSERT INTO mgw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ngaayangwa, “Mukapangage mwa kimbulibuli, mulu'e bali musambi, lakini nambi'yambi' mwenga mubaya, ‘Twenga twendalola,’ apo ilaya panga balo mubile na sambi.” ");
INSERT INTO mgw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Kakape nimmakia, ywoywoti yu'lu' ywaayingya mukyu'ngu'lu' sa ngondolo wangali pi'tya muniango, lakini ayingya kwo pekenya pandu pi'ngi', aywo mmwi na mpokonyoli. ");
INSERT INTO mgw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lakini ywayingya kwo pi'tya muniango, aywo nga nsungi ywa ngondolo. ");
INSERT INTO mgw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nni'ndi'li ywa paniango wa kyu'ngu'lu' ngaywannyu'gu'lya, na ngondolo bendaliyu'wa lilobe lyake. Ywembe aakema ngondolo bake kwa maina gabe, na kwapikiya panja. ");
INSERT INTO mgw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mana ayomwile kwapikiya panja boti, alongolya nnu'ngi' nabembe bendakunki'ngama, kwa mwanjaa balitangite lilobe lyake. ");
INSERT INTO mgw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngondolo banki'ngamali nng'eni, ila balu'a kuntila kwa mwanjaa balitangiteli lilobe lyake.” ");
INSERT INTO mgw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu aabakie lukongo lu'no, lakini bembe baakwipwili sapalage kwabakia. ");
INSERT INTO mgw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bai, Yesu ngabaya kai', “Kakape nimmakianga, nenga nga na nniango wa ngondolo. ");
INSERT INTO mgw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Balu' bi'ngi' boti babaaisi nsu'gu' yangu' baabile baii na apokonyoli, lakini ngondolo baapi'kanili. ");
INSERT INTO mgw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenga nga na niango, ywaayingya kwo pi'tya kasangu' akosopolelwa, alu'a yingya no pita naywembe alu'a pata kilyo. ");
INSERT INTO mgw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mmwi endaisa li'nga yiba, bulaga no alabiya. Nenga niisi li'nga bandu bapate ukoto, kai' babe nawo wambone. ");
INSERT INTO mgw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenga na nsungi nnogau. Nsungi nnogau aupiya bwu'mi wake kwa kitumbu sa ngondolo bake. ");
INSERT INTO mgw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mundu ywo li'pi'lwa ywembe ngondolo mali yake lili na nsungi lili, pammona pu'mbe kaisa, endatila na kwaleka ngondolo kababoyolwa no sengemwanika. ");
INSERT INTO mgw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ywembe endatila na abi'kyali kiya ngondolo, kwa mwanjaa ywembe mundu ywo li'pi'lwa bai. ");
INSERT INTO mgw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nenga na nsungi nnogau. Naatangite ngondolo bangu', na ngondolo bangu' banitangite, ");
INSERT INTO mgw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kati mu'lu' Tati' mwabanitangite, nanenga mwanaatangite Tati'. Nenga niupiya bwu'mi wangu' kwa kitumbu sa ngondolo. ");
INSERT INTO mgw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kai' nibile na ngondolo bi'ngi', bembe baabileli mukyu'ngu'lu' si'no, ipalikwa kwaleta kai', nabembe balu'a yu'wa lilobe lyangu', na kwalu'a baa na kipi'nga simo na nsungi yumo. ");
INSERT INTO mgw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ngamo Tati' banipenda, kwa mwanjaa niupiya bwu'mi wangu' li'nga niupoki kai'. ");
INSERT INTO mgw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ntu'pu' mundu ywanipokonywa bwu'mi wangu', nenga niupiya kwo penda namwene. Nibile na makakala ga kuupiya na makakala ga kuutola kai'. Amo ngamwabaniamulise Tati' nipange.” ");
INSERT INTO mgw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bu'kana na mayi'gi'yo ga, ngakupitya kai' kotoka yi'ki'tyana mukipi'nga sa Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bi'ngi' babe ngababaya, “Aina moka, kai' aina lilalu'! Mwanjaa namani kumpi'kania?” ");
INSERT INTO mgw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bi'ngi' ngababaya, “Aga mayi'gi'yo ga mundu mwene moka lili. Buli, moka gendakombwa kuntepwa minyo mbulibuli?” ");
INSERT INTO mgw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Akwo ku Yelusalemu kwaai na si'li'ku'si'li'ku' yo ku'mbu'kya bi'ki'lwa wakupu nyumba ya Nnu'ngu'. Nsimu wo waai wa kipepwe. ");
INSERT INTO mgw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naywembe Yesu aai katyanga mulubanja lwa luwa lwa Nyumba ya Nnu'ngu', pandu papakemelwa Sega sa Selemani. ");
INSERT INTO mgw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bai, Ayahudi ngabanti'li'ta na kunnaluya, “Upala kutuleka mukyukala mpaka pakubawi? Manaitei wenga nga wa Kilisitu, bai utubakie mpu'la.” ");
INSERT INTO mgw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ngayangwa, “Nimmakiangite, lakini muu'bi'lyali. Mengo ganigapanga nenga kwa lina lya Tati' bangu' gendanikong'ondelya. ");
INSERT INTO mgw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lakini mwenga muu'bi'lyali kwa mwanjaa mwenga mwangondolo bangu' li. ");
INSERT INTO mgw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngondolo bangu' baliyu'wa lilobe lyangu', nanenga naatangite, nabembe bendanibi'ngi'ya. ");
INSERT INTO mgw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nenga naapeya ukoto wangayomoka, nabembe baaobali milele, kai' ntu'pu' mundu ywaakombwa kwabu'ya mumaboko gangu'. ");
INSERT INTO mgw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tati' bangu' babaanipei ngondolo ba, nga aku'lu' kulikoni boti, kai' ntu'pu' ywaakombwa kwabu'ya mumaboko ga Tati' bangu'. ");
INSERT INTO mgw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Tati' twabamo.” ");
INSERT INTO mgw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bai, Ayahudi ngabatondwa kai' maliwe li'nga banku'mbwe. ");
INSERT INTO mgw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lakini Yesu ngaabakia kai', “Ninnayangite mengo gambone manogau bu'ka kwa Tati'. Lyengo lyaku' mumengo go, lyalipala kumpanga muniku'mbwe maliwe?” ");
INSERT INTO mgw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayahudi ngabannyangwa, “Tukuku'mbwa maliwe kwenda kwa kitumbu sa mengo manogau lili, ila kwa kitumbu sa kunkupulu Nnu'ngu'! Kwa mwanjaa wipanga wa Nnu'ngu' naapo wenga wa mundu bai.” ");
INSERT INTO mgw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu ngaayangwa, “Buli, inaandikilwali musalya yinu panga, ‘Nenga nibaite, mwenga nga mwakinnu'ngu'?’ ");
INSERT INTO mgw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nnu'ngu' aakemite kinnu'ngu' balu' babaapeyilwe mayi'gi'yo gake, na twenga tutangite panga Maandiko Mapeleteu gabaya kakape, gaati'kwanikali. ");
INSERT INTO mgw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mukombwabuli baya, ‘Endakupulu,’ yu'lu' ywaabi'kilwe wakupu na Tati' no tumilwa mudunia, ati' kwa mwanjaa naabaite, ‘Nenga na Mwana wa Nnu'ngu'?’ ");
INSERT INTO mgw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Manaitei nipangali lyengo lya Tati' bangu', bai kanemuniu'bi'li, ");
INSERT INTO mgw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","lakini manaitei muniu'bi'lyali, male muu'bi'li alyo lyengo lyanipanga, mupate tanga panga kakape Tati' bai nkati yangu' na nenga ni nkati yabe.” ");
INSERT INTO mgw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngabapaya kai' kummoywa lakini ngabannema mumaboko gabe. ");
INSERT INTO mgw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu aayi'i kai' kwiyi' ya libi'ndi' lya Yordani, pandu po kwai'mbu' Yoani aabatisage bandu, ngatama kwo. ");
INSERT INTO mgw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bandu baingi ngabannyendelya kababaya, “Yoani aapangiteli myanju yoyoti. Lakini galu' goti gaabaite Yoani kwa mundu yu', kakape ngagembe.” ");
INSERT INTO mgw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pandu po bandu baingi ngabamwu'bi'lya Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bai, kwai na mundu yumo ywakemelwage Lasali aai ntamwe. Aywo atamage kukilambo sa Betania na alu'mbu'be Malia na Malita. ");
INSERT INTO mgw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia nga yu'lu' ywaampakiye Bwana mauta mumagu'lu' na kumponwa kwa nywili yake. ");
INSERT INTO mgw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bai, abo akina alu'mbu'be ngabapeleka abali kwa Yesu, “Bwana, yu'lu' mbwigalyo ywaumpendile endaminya.” ");
INSERT INTO mgw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu paayu'wine nyo ngabaya, “Utamwe wo wakumpanga awee lili, ila kwa mwanjaa ya kunkwi'ya Nnu'ngu'. Endaminya li'nga kwa ndi'la yo, Mwana wa Nnu'ngu' akwi'yi'lwe.” ");
INSERT INTO mgw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu aapendi Malita, Malia na Lasali nnuna wabe. ");
INSERT INTO mgw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pamope no yu'wa panga Lasali aai ntamwe, lakini Yesu aayendeli tama pandu po kwa masu'ba gabi'li'. ");
INSERT INTO mgw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bu'kapo ngaabakia banamasi' bake, “Tuki'li'bu'ki kai' ku Yudea.” ");
INSERT INTO mgw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Banamasi' bake ngabammakia, “Mwalimu, ganapi'tali masu'ba gambone bu'ka pa Ayahudi pabapalage kukuku'mbwa maliwe, nambi'yambi' upala yenda kai'?” ");
INSERT INTO mgw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ngaayangwa, “Kubile na masaa ku'mi na gabi'li' ga muntwekati mulisu'ba limo. Bai, mundu mana atyangite muntwekati aawesali ku'bala kwa mwanjaa aubona bweya wa padunia yi'no. ");
INSERT INTO mgw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lakini mundu mana atyangite kilo, alu'a ku'bala kwa mwanjaa ntu'pu' bweya nkati yake.” ");
INSERT INTO mgw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu paayomwi longela ago, ngaabakia, “Mbwiga litu Lasali atigonja, lakini nenga niyenda kunnyumuya.” ");
INSERT INTO mgw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Banamasi' bake ngabammakia, “Bwana, manaitei agonjike lugono, bai alu'a yu'yu'ki'lwa.” ");
INSERT INTO mgw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bembe bakitage Yesu aabile kannongelya Lasali panga agonjike lugono, lakini aabile kalongelya kiwo sa Lasali. ");
INSERT INTO mgw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bai, Yesu ngaabakia mpu'la, “Lasali ayomwike, ");
INSERT INTO mgw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lakini ninapusika panga naabileli kwo, li'nga muu'bi'li. Aya, tubu'ke kasake.” ");
INSERT INTO mgw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma (ywakemelwage Mapaga) ngaabakia banamasi' aine, “Na twenga tuyende tukawee pamope na Yesu!” ");
INSERT INTO mgw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu paaikite kwo, yaai gapite masu'ba nsese bu'ka po sikilwa kwa Lasali. ");
INSERT INTO mgw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kilambo sa Betania saai kilometa itatu bu'ka ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayahudi bambone baaisi kwa Malita na Malia, li'nga kwali'yali'ya kwo wi'li'kwa na mwasa wabe. ");
INSERT INTO mgw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bai, Malita paayu'wine panga Yesu endaisa, ngankwi'ndi'lya na kumpokya, lakini Malia aaigali nnyumba. ");
INSERT INTO mgw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malita ngammakia Yesu, “Bwana, ukabage pano, mwasangu' alu'e waali! ");
INSERT INTO mgw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakini ata nambi'yambi' ndangite panga sosoti saulu'a kunnu'ba Nnu'ngu', alu'a kupeya.” ");
INSERT INTO mgw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ngammakia, “Mwasago alu'a yu'ka.” ");
INSERT INTO mgw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita ngannyangwa, “Ndangite panga alu'a yu'ka lisu'ba lya kuundi'la, pabaayu'ka bandu boti.” ");
INSERT INTO mgw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu ngammakia, “Nenga nga na uyu'ki na ukoto. Ywaniu'bi'lya nenga ata mana awile, alu'a lama, ");
INSERT INTO mgw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na kila ywatama nkati yangu' na kuniu'bi'lya katu awaali. Buli, wendau'bi'lya ago?” ");
INSERT INTO mgw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malita ngammakia, “Elo Bwana! Nenga nendau'bi'lya panga wenga nga wa Kilisitu, Mwana wa Nnu'ngu', yu'lu' ywaaisa padunia.” ");
INSERT INTO mgw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bu'ka po baya go, Malita aayi'i kunkema Malia nku'we, pandu pakisake na kummakia, “Mwalimu abile pano endakukema.” ");
INSERT INTO mgw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naywembe paayu'wine nyo, popopo ngakatuka na kunnyendelya Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu aabile anayingyali mukilambo, ila aabile balo papalu'palu' paakwi'ndi'lilwe na Malita. ");
INSERT INTO mgw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bai, Ayahudi babaabile panyumba pamope na Malia kabanni'yali'ya, pabamweni akatwike no pita panja kiyu'ngu'ya, ngabanki'ngama. Bakitage panga apala yenda lombola ku'lu' kulisiko. ");
INSERT INTO mgw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bai, Malia paaikite pandu palu' Yesu paabile na kummona, aakilikite pai' na kummakia, “Bwana, ukabage pano, mwasangu' apewaali!” ");
INSERT INTO mgw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu paamweni Malia kali'la, na balu' Ayahudi babaaisi pamope nakwe kabali'la kai', lwampatike lwu'ngu' pamwoyo no nyopa. ");
INSERT INTO mgw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bu'kapo ngaalaluya, “Mwammi'i kwaku'?” Ngabammakia, “Bwana, so linge.” ");
INSERT INTO mgw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu aali'i moli. ");
INSERT INTO mgw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bai, Ayahudi ngababaya, “Mulinge mu'lu' mwaampendile!” ");
INSERT INTO mgw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakini bi'ngi' babe ngababaya, “Buli, ayu' nga ywantepwile minyo yu'lu' mbulibuli, aakotwike buli kumpanga Lasali kaneawe?” ");
INSERT INTO mgw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bai, Yesu nganyopa kai' pamwoyo wake, ngaika pa lipango lyo sikya lyaliwi'ki'lilwe na liwe. ");
INSERT INTO mgw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ngabaya, “Mulibu'ye alyo liwe.” Malita, ywaabile nnu'mbowe malemu, ngammakia, “Bwana, atumbwile nunga, kwa mwanjaa li'no lisu'ba lyene nsese bu'ka pasikilwe!” ");
INSERT INTO mgw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu ngammakia, “Buli, nakubakiyeli panga mana uu'bi'lile, ulu'a kuubona utukupu wa Nnu'ngu'?” ");
INSERT INTO mgw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bai, ngabalibu'ya li'lu' liwe. Yesu ngatu'ndu'bi'ya minyo gake kunani, kabaya, “Tati', nendakunsukulu kwa mwanjaa mwenga mwendanipi'kania. ");
INSERT INTO mgw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Masu'ba goti ndangite panga mwendanipi'kania. Lakini nilongei aga goti kwa kitumbu sa bandu bababile pano li'nga nabembe bau'bi'li panga mwenga nga munitumike.” ");
INSERT INTO mgw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Paayomwi longela go, ngakema kwa lilobe liku'lu', “Lasali, upite panja!” ");
INSERT INTO mgw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yu'lu' ywaai awile ngapitya panja, ku'no atabilwe sanda mmagu'lu' na mmoko, na kuminyo yake kuwi'ki'lilwe. Yesu ngaabakia, “Mumundwe, munneke ayende.” ");
INSERT INTO mgw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bai, Ayahudi bambone babaaisi kwa Malia, pabagabweni galu' gaagapangite Yesu, ngabamwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lakini bi'ngi' babe ngabayenda kwa Mafalisayo kwabakia likowe lyo lyaapangite Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwa nyo Api'ndo ba dini na Mafalisayo ngabakema kitamo sa Balasa Liku'lu' lya Ayahudi, ngababaya, “Tupange buli? Mundu yu' alaya myasu yambone. ");
INSERT INTO mgw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mana tunnei bai, bandu boti bapakumwu'bi'lya, na Aroma baalu'a isa alabiya nyumba ya Nnu'ngu' witu na nni'ma witu!” ");
INSERT INTO mgw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Apo yumo ywabe ywakemelwa Kayafa, ywembe aai mpi'ndo nku'lu' ywa dini mwaka wo, ngaabakia, “Mwenga mutangiteli kili'be sosoti! ");
INSERT INTO mgw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Buli, mwibonali kwinu panga male mundu yumo awee paali pa bandu, kulikoni nni'ma woti ulangamiswe?” ");
INSERT INTO mgw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ywembe aalongei nyo kwo penda mwene lili, ila kwa mwanjaa aai mpi'ndo ywa dini mwaka wo, aatilondwa panga Yesu alu'a waa paali pa bandu ba nni'ma wake, ");
INSERT INTO mgw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kai', kiwo sake kwa kitumbu sa abo baili, ila li'nga kwalu'mbania pamope bana ba Nnu'ngu' babasengemwanike. ");
INSERT INTO mgw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bai, tumbulya lisu'ba lyo alongosi ba Kiyahudi ngabapala ndi'la ya kummulaga Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwa nyo Yesu atyangiteli pa bandu ba Kiyahudi, ila aabu'i po yenda papipi na lubele, mukilambo sakikemelwa Eflaimu. Ngatama kwo pamope na banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Si'li'ku'si'li'ku' ya Pasika kwa Ayahudi yaai kaiegelya, na bandu bambone baayi'i ku Yelusalemu li'nga bakaipeleteye kwa Pasika yo. ");
INSERT INTO mgw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bai, bandu ngababa kabampala Yesu. Nabembe pabakongolekine pandu pamo munyumba ya Nnu'ngu', ngabalaluyana, “Muwasa buli? Ibonekana panga aisali katu musi'li'ku'si'ku' au lili?” ");
INSERT INTO mgw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Api'ndo ba dini na Mafalisayo baapiyite amuli panga mundu mana atangite kwabile Yesu, alete abali li'nga bammoywe. ");
INSERT INTO mgw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Masu'ba sita kaiegelya Pasika, Yesu aayi'i Betania kwaatamage Lasali, yu'lu' ywaayu'yilwe na Yesu bu'ka kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Akwo ngabankemya kilyo sa kitamwiyo, naywembe Malita aabile kaabi'kya wiso. Lasali aabile yumo ywa balu' babaabile pamesa pamope na Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bai, Malia ngatola lisinda lya lita ya mauta ganannungya ga naldo ga bei ngu'lu', ngampakaya Yesu mmagu'lu' na kugaponwa kwa nywili yake. Nyumba yoti ngaitwi'lya lumba lunannungya. ");
INSERT INTO mgw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bai, Yuda Isikalioti, yumo ywa banamasi' ba Yesu ywembe ngaywaalu'a kunsongya, ngabaya, ");
INSERT INTO mgw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwa mwanjaa namani mauta ganannungya ga gasomwa pi'mi'yi'lwa kwa mbanje ya dinali mya itatu, na mbanje yo peyelwa aki'ba?” ");
INSERT INTO mgw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aabaite nyo, kwenda aabi'ki kiya aki'ba li, ila kwa mwanjaa aabile mmi'ki wa mabi'ko na aai mmwi, na aitolyage mali bu'ka mumabi'ko. ");
INSERT INTO mgw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lakini Yesu ngabaya, “Munneke kanemunsuluye ayu' mau', kwa mwanjaa aagabi'kite mauta kwa lisu'ba lyo sikilwa kwangu'. ");
INSERT INTO mgw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Aki'ba mubile nabo masu'ba goti, lakini mwaalu'a baali nanenga masu'ba goti.” ");
INSERT INTO mgw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayahudi bambone pabaayu'wine panga Yesu aai ku Betania, baaikite kwo kwenda kummona Yesu baili, ila li'nga kummona Lasali ywaayu'yilwe bu'ka kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Api'ndo aku'lu' ba dini ngabaamwa kummulaga Lasali kai', ");
INSERT INTO mgw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwa kitumbu sa Lasali Ayahudi bi'ngi' baamwu'bi'li Yesu, paali pa kwau'bi'lya alongosi ba dini yabe. ");
INSERT INTO mgw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pammalau' yake kipi'nga kiku'lu' sa bandu babaaisi kusi'li'ku'si'li'ku' baayu'wine panga Yesu ai mundi'la isa Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ngabatola ndambi' ya mitende, pita panja yenda kunkwi'ndi'lya, ngabau'bu'ya malobe kababaya, “Nnu'ngu' alumbilwe! Ayaliwe aywo ywaisa kwa lina lya Bwana. Ayaliwe nkulungwa wa ku Isilaili.” ");
INSERT INTO mgw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ngampata mwana mbu'nda yumo, ngau'bu'ka panani yake kati Maandiko mwagabaya. ");
INSERT INTO mgw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kanemuyogope mwa ba kilambo sa Sayuni! Linguli, nkulungwa winu au'bwike mwana mbu'nda endaisa!” ");
INSERT INTO mgw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Patumbu banamasi' bake baakwipwili makowe ga, lakini Yesu paakwi'yilwe, apo ngabaku'mbu'kya panga ago gaandikilwe kwa ywembe na aapangilwe ywembe. ");
INSERT INTO mgw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kipi'nga sa bandu balu' babaai pamope na Yesu paankemite Lasali bu'ka mulisiko, na kunnyu'ya bu'ka kuuwi'li, baayendeli kunkong'ondelya. ");
INSERT INTO mgw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwa nyo kipi'nga sa bandu ngabankwi'ndi'lya, kwa mwanjaa boti baayu'wine panga Yesu ngaywapangite mwanju wo. ");
INSERT INTO mgw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bai, Mafalisayo ngababakiana, “Mwendalola? Tukombwali panga sosoti! Mulinge, dunia yoti inki'ngama ywembe!” ");
INSERT INTO mgw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwaabile na Agiliki nsi'si' mwa balu' bandu babaayi'i Yelusalemu kilikita nsimu wa si'li'ku'si'li'ku'. ");
INSERT INTO mgw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Abo ngabannyendelya Pilipi, mwenekaya wa Betisaida mu Galilaya, ngabammakia, “Bwana, tulu'ba kummona Yesu.” ");
INSERT INTO mgw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipi ngayenda kummakia Andelea, na boti abi'li' ngabayenda kummakia Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu ngaabakia, “Saa yo kwi'yi'lwa Mwana wa Mundu iikite! ");
INSERT INTO mgw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kakape nimmakianga, lupeke lwa ngano mana lunatu'mbu'kyali mubwi' no waa, lwaigala kati lupeke kisake bai. Lakini mana luwile lwaapiya mbeyu yambone. ");
INSERT INTO mgw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ywapenda maisa gake, alu'a gaobeya, ywagasukya maisa gake mudunia yi'no, alu'a gali'ndi'la mpaka muukoto wangayomoka. ");
INSERT INTO mgw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ywapala kunitumikiya apalikwa aniki'ngame, li'nga popoti palu' panibile nenga, ngapaalu'a ba na ntumisi wangu'. Mundu mana kanitumikiya, Tati' bangu' baalu'a kumwisimu. ");
INSERT INTO mgw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nambi'yambi' loo yangu' ibile na ntenyo, nilongele ki'li'? Buli, nibaye, ‘Mwa Tati' ninnu'ba munikosopoli bu'ka saa yi'no?’ Lili, kwa mwanjaa nga kitumbu saniisilile. ");
INSERT INTO mgw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tati' mulikwi'ye lina linu.” Apo lilobe ngaliyu'wanika bu'ka kunani, “Nilikwi'yite, na naalu'a likwi'ya kai'.” ");
INSERT INTO mgw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ipi'nga ya bandu yayaayi'mi po, yaayu'wine lilobe lyo, na bi'ngi' babe ngababaya, “Alyo lilobe lya njai,” Lakini bi'ngi' ngababaya, “Aalongei nakwe malaika!” ");
INSERT INTO mgw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lakini Yesu ngaabakia, “Lilobe lyo linapityali kwa kitumbu sangu', ila kwa kitumbu sinu. ");
INSERT INTO mgw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nambi'yambi' nga saa ya ukumu kwa dunia yi', na mpi'ndo ywa dunia yi' alu'a taikulilwa panja. ");
INSERT INTO mgw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nenga panatu'ndu'bi'yi'lwa panani ya nni'ma, naalu'a kwauta bandu boti baise kasangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu aalongei nyo kalombolya kiwo saku' saalu'a waa. ");
INSERT INTO mgw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bai, kipi'nga si'lu' ngakinnyangwa, “Twenga tubakiyilwa na salya yitu panga Kilisitu alu'a lama milele. Ukombwabuli baya Mwana wa Mundu apalikwa tundu'bi'yi'lwa? Aywo Mwana wa Mundu nga nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu ngaabakia, “Balo pasene bweya ubile pamope na mwenga. Mutyangange mubile nawo awo bweya li'nga lubi'ndu' kanelumpatange, kwa mwanjaa ywatyanga mulubi'ndu' atangiteli kwayenda. ");
INSERT INTO mgw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bai, nsimu wamubile mubweya wu'no, muu'bi'li bweya li'nga mupate panga mwabandu ba mubweya.” Bu'ka po longela mayi'gi'yo go, Yesu aatibu'ka no yu'ba kuutalu nabo. ");
INSERT INTO mgw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pamope no panga Yesu aapangite myanju yoti yi' nnu'ngi' yabe, bembe bammwu'bi'lili. ");
INSERT INTO mgw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kwa nyo mayi'gi'yo gaabaite nnondoli ywa Nnu'ngu' Isaya ngagatimya, “Bwana, nyai ywau'bi'li mayi'gi'yo gitu? Na uweso wa Bwana abakiyilwe nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kwa nyo bakombwili u'bi'lya, kwa mwanjaa Isaya aabaite kai', ");
INSERT INTO mgw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nnu'ngu' atu'lwi minyo gabe na kwipanga myoyo yabe ibe minonopau, kanebalole kwa minyo gabe na kanebatange kwa malango gabe, kai' kanebanigalambuki, abaya Bwana, li'nga nakane kwatepwa.” ");
INSERT INTO mgw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya aalongei mayi'gi'yo ga kwa mwanjaa aaubweni utukupu wa Yesu, ngabaya makowe gake. ");
INSERT INTO mgw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ata nyo, api'ndo bambone ba Kiyahudi ngabamwu'bi'lya Yesu. Lakini kwa kitumbu sa Mafalisayo, bannyi'ki'tili pa bandu kwo yogopa bi'ngi'lwa munyumba ya kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bembe baapendi lumbilwa na bandu kuliko lumbilwa na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Bu'kapo Yesu ngau'bu'ya lilobe lyake kabaya, “Mundu ywaniu'bi'lya, aniu'bi'lya nenga baili, ila amwu'bi'lya na yu'lu' ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ywanibona nenga ammona yu'lu' ywanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Niisi mudunia panga na bweya li'nga boti babaniu'bi'lya kanebaigale mulubi'ndu'. ");
INSERT INTO mgw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ywagayu'wa mayi'gi'yo gangu', lakini kakotoka kamwa, nenga namukumuli, kwa mwanjaa naisali ukumu dunia ila kwikosopolya. ");
INSERT INTO mgw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ywakana kugakamwa mayi'gi'yo gangu', abile nakwe ywakumukumu. Liyi'gi'yo li'lu' lyanililongei nga akimu wake lisu'ba lya kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nenga nalongelali kwa makakala gangu' namwene, ila Tati' babanitumike ngabaniamulise nibaye ki'li' na nilongele ki'li'. ");
INSERT INTO mgw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nenga ndangite panga amuli yake ileta ukoto wangayomoka. Nenga nibaya galu' bai Tati' gabaanilagile nigabaye.” ");
INSERT INTO mgw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lyaaigali lisu'ba limo nnu'ngi' lyo timya kwa si'li'ku'si'li'ku' ya Pasika, Yesu aatangite panga saa yake yo bu'ka mudunia no yenda kwa Tati' yaikite. Aapendi bandu bake babaai mudunia, kakape aapendi mpaka kuundi'la! ");
INSERT INTO mgw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bai, Yesu na banamasi' bake baai batami pakilyo sa kitamwiyo. Ibilisi aansopite Yuda, mwana wa Simoni Isikalioti, li'nga ansongi Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu aatangite panga Tati' bampei kila kili'be, no panga aaumi kwa Nnu'ngu' na abukiya kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bai, aabu'i pamesa, ngabi'ka pambwega nganju yake, tola kitambala na kwitaba mukibuno. ");
INSERT INTO mgw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bu'kapo ngayi'ya masi' mukibakuli, tumbwa kwagu'lwa banamasi' bake magu'lu' na kwaponwa kwa si'lu' kitambala saaitabite nkibuno. ");
INSERT INTO mgw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bai, paamwiki Simoni Petili, Petili ngabaya, “Bwana, upala kunigu'lwa nenga magu'lu'?” ");
INSERT INTO mgw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu ngayangwa, “Nambi'yambi' utangiteli sanikipanga, lakini nnu'ngi' waalu'a kitanga.” ");
INSERT INTO mgw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petili ngammakia, “Wenga unigu'lwali magu'lu' gangu' katu!” Yesu ngayangwa, “Mana kaukana kukugu'lwa magu'lu' gako, ulu'a lu'mbanali nanenga kai'.” ");
INSERT INTO mgw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petili ngannyangwa, “Bwana, unigu'lwe, kai' magu'lu' baili, ila maboko gangu' na ntwe.” ");
INSERT INTO mgw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ngammakia, “Ywaau'gite ili'ngani ipalikwali uluwa ila magu'lu' bai, kwa mwanjaa yi'ga yake ipeletike. Mwenga mupeletike ila mwaboti lili.” ");
INSERT INTO mgw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesu aantangite yu'lu' ywapalage kunsongya, kwa nyo ngabaya, “Mwenga mupeletike ila mwabotili.”) ");
INSERT INTO mgw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Paayomwi kwagu'lwa magu'lu' no wala kai' ngu'bo yake, ngatama pamesa, ngaabakia, “Buli, mulitangite likowe lyanimpangile? ");
INSERT INTO mgw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mwenga munikema ‘Mwalimu’ na ‘Bwana’, mwenga mubaya kakape, kwa mwanjaa nga nenga. ");
INSERT INTO mgw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bai, manaitei nenga ngana Bwana kai' na Mwalimu ninng'u'lwangite mwenga magu'lu', na mwenga mupalikwa gu'lwana magu'lu'. ");
INSERT INTO mgw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ninnayangite makowe ga li'nga namwenga muyige mupange kati mwanimpangile. ");
INSERT INTO mgw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kakape nimmakianga, ntumisi nku'lu' li kulikoni bwana wake, wala ntumilwa nku'lu' li kulikoni yu'lu' ywantumike. ");
INSERT INTO mgw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bai, mana mugatangite ga, yapanga nantali mana mwaagapanga. ");
INSERT INTO mgw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Aga ganigabaya kwenda ginu mwaboti li. Nenga naatangite balu' banaasawile. Lakini li'nga Maandiko Mapeleteu gatimi, ‘Yu'lu' ywaalile kilyo sangu' agalambwike kunitangya.’ ");
INSERT INTO mgw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nimmakiangite makowe ga gabile balo pitya, li'nga pagaapitya mwau'bi'li panga nenga nga naywembe. ");
INSERT INTO mgw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kakape nimmakianga, ywaampokya yu'lu' ywanintuma, anipokya nenga na ywanipokya nenga, ampokya yu'lu' ywanitumike.” ");
INSERT INTO mgw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Paayomwi longela go, Yesu aapatike ntenyo muno pamwoyo wake, ngabaya mpu'la, “Kakape nimmakianga, yumo ywinu alu'a nisongya!” ");
INSERT INTO mgw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Banamasi' ngabalingana, wangali tanga panga ywaku' ywannongelya. ");
INSERT INTO mgw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yumo ywa banamasi', ywaapendilwe na Yesu, aatami papipi na Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bai, Simoni Petili ngampu'ngya luboko yu'lu' mwanamasi' no baya, “Nnokiye ammaya nyai.” ");
INSERT INTO mgw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mwanamasi' ywo ngaegelya papipi muno na Yesu, ngannokiya, “Bwana, nga nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu ngayangwa, “Yu'lu' ywanampeya king'esu sa likati lyanisuyite, nga ywembe.” Bai, ngaatola king'esu sa likati, ngakisuya, ngampeya Yuda mwana wa Simoni Isikalioti. ");
INSERT INTO mgw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda pakipokile king'esu so, Ibilisi ngannyingya. Bai, Yesu ngammakia, “Sopala panga ukipange kiyu'ngu'ya!” ");
INSERT INTO mgw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lakini ntu'pu' ata yumo ywa balu' babaatami palu' pamesa ywaatangite kitumbu sa kummakia nyo. ");
INSERT INTO mgw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwa mwanjaa Yuda aabile mmi'ka mabi'ko, bi'ngi' babe bakitage panga Yesu ammakie api'me ili'be yaipalikwa kwa si'li'ku'si'li'ku', au iwesa panga ammakie akapiye sosoti kwa aki'ba. ");
INSERT INTO mgw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bai, Yuda paakitweti si'lu' king'esu sa likati, popopo ngapita panja. Na yaai kilo. ");
INSERT INTO mgw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bu'ka pa Yuda pitya panja, Yesu ngabaya, “Nambi'yambi' Mwana wa Mundu akwi'yilwe, naywembe Nnu'ngu' akwi'yilwe kwa ndi'la yake. ");
INSERT INTO mgw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na manaitei Nnu'ngu' akwi'yilwe kwa ndi'la ya Mwana, naywembe Nnu'ngu' ankwi'ya Mwana kiyu'ngu'ya kwa ndi'la yake mwene. ");
INSERT INTO mgw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mwabana bangu', balo pasene baa pamope na mwenga. Mwaanipala, lakini nambi'yambi' nimmakia galu' ganaabakiye api'ndo ba Ayahudi. ‘Kwaniyenda mwenga mukombwali ika.’ ");
INSERT INTO mgw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nimpeyanga amuli yayambi', Mupendane, kati nenga mwanimpendile mwenga, nyinyonyo na mwenga mupendane. ");
INSERT INTO mgw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mana mupendine, bandu boti baalu'a tanga panga mwenga nga mwabanamasi' bangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petili ngannaluya, “Bwana uyenda kwaku'?” Yesu ngannyangwa, “Kwaniyenda nambi'yambi' ukombwali kuniki'ngama, lakini waalu'a niki'ngama nnu'ngi' yake.” ");
INSERT INTO mgw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petili ngammakia, “Bwana, kwa mwanjaa namani nikotoke kukuki'ngama nambi'yambi'? Niyi'ki'tile waa kwa kitumbu sako!” ");
INSERT INTO mgw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ngayangwa, “Buli, kakape uyi'ki'tile waa kwa kitumbu sangu'? Kakape nikubakia, njogolo ai balo bi'ka waalu'a nikana patatu!” ");
INSERT INTO mgw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu ngaabakia, “Kanemube na kyukala mumyoyo yinu. Mumwu'bi'lya Nnu'ngu', muniu'bi'li na nenga. ");
INSERT INTO mgw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ya Tati' bangu' muutamo mwambone. Ikapangage nyonyoli, nilu'e kummakia. Nambi'yambi' niyenda kummi'kyanga wiso muutamo. ");
INSERT INTO mgw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na mana niyi'i kummi'kya muutamo, naalu'a buya kai' kuntolanga li'nga palu' panibile nenga, na mwenga mwaabe. ");
INSERT INTO mgw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mwitangite ndi'la yo yenda akwo kwaniyenda.” ");
INSERT INTO mgw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi ngammakia, “Bwana, tutangiteli kwauyenda, tukombwabuli kwitanga ndi'la?” ");
INSERT INTO mgw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ngannyangwa, “Nenga ngana ndi'la, ukakape na ukoto. Ntu'pu' ywakombwa yenda kwa Tati' ila kwo pi'tya kasangu'. ");
INSERT INTO mgw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kwa mwanjaa munitangite nenga, mulu'a kwatanga na Tati' bangu' kai'. No bu'ka nambi'yambi', mwatangite kai' mwabweni.” ");
INSERT INTO mgw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipi ngammakia, “Bwana, utulangili Tati', na twenga yali'ngana.” ");
INSERT INTO mgw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ngammakia, “Nitami na mwenga kwa masu'ba ga goti, nawenga Pilipi unanitangali? Ywaanibweni nenga abweni na Tati'. Ukombwabuli baya, ‘Utulangili Tati'?’ ");
INSERT INTO mgw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Buli, uu'bi'lyali panga nenga nibi nkati ya Tati', nabembe Tati' babi nkati yangu'? Mayi'gi'yo ganimmakianga, nigalongelali kwa utawala wangu'. Ila Tati' bababile nkati yangu' bapanga lyengo lyabe. ");
INSERT INTO mgw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mupalikwa kuniu'bi'lya panibaya panga nenga nibile nkati ya Tati' nabembe babile nkati yangu'. Mana lili, muu'bi'li kwa mwanjaa ya makowe ganigapanga. ");
INSERT INTO mgw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kakape nimmakianga, ywaniu'bi'lya alu'a panga makowe ganigapanga nenga, kai' alu'a panga maku'lu' muno, kwa mwanjaa niyenda kwa Tati'. ");
INSERT INTO mgw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na sosoti samwaalu'a lu'ba kwa lina lyangu', naalu'a kipanga, li'nga Tati' bakwi'yi'lwe nkati ya Mwana. ");
INSERT INTO mgw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mana munilu'bite sosoti kwa lina lyangu', naalu'a kumpangya. ");
INSERT INTO mgw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mana munipendile mwaalu'a kwikamwa amuli yangu'. ");
INSERT INTO mgw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nanenga nilu'a kwalu'ba Tati', na bembe baalu'a kumpeya Nnyangatiyi ywi'ngi' ywaalu'a tama na mwenga milele. ");
INSERT INTO mgw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ywembe nga Loo ywa kakape. Dunia ikombwali kumpokya kwa mwanjaa ikombwali kummona wala kuntanga. Lakini mwenga muntangite kwa mwanjaa atama na mwenga na ai nkati yinu. ");
INSERT INTO mgw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Naalu'a kunnekali muuki'ba, naalu'a isa kai' kasinu. ");
INSERT INTO mgw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Balo pasene dunia yaalu'a nibonali kai', lakini mwenga mwalu'a nibona. Kwa mwanjaa nenga nankoti, na mwenga mwapanga mwaakoti. ");
INSERT INTO mgw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lisu'ba li'lu' palyaalu'a ika mwatanga panga nenga nibile nkati ya Tati', na mwenga nkati yangu', nanenga nkati yinu. ");
INSERT INTO mgw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ywapokya amuli yangu' na kwikamwa, ywembe nga ywanipenda. Na ywanipenda nenga, aapendelwa na Tati' bangu', nanenga nalu'a kumpenda na kwilaya kasake.” ");
INSERT INTO mgw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda (yu'lu' Isikalioti li) ngammakia, “Bwana, ukombwabuli kwilaya kasitu, lakini kwa dunia lili?” ");
INSERT INTO mgw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ngayangwa, “Mundu mana anipendile, alu'a kamwa liyi'gi'yo lyangu'. Tati' bangu' baalu'a kumpenda, na twenga twaalu'a isa kasake no tama nakwe. ");
INSERT INTO mgw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ywakotoka kunipenda akamwali mayi'gi'yo gangu'. Na mayi'gi'yo gamugayu'wine gangu' lili, ila ga Tati' babanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nimmakiangite makowe ga nibile balo pamope na mwenga, ");
INSERT INTO mgw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","lakini Nnyangatiyi, Loo Mpeleteu bembe Tati' baalu'a kuntuma kwa lina lyangu', alu'a kunnyi'gana kila kili'be na kunku'mbu'ki'yanga goti ganammakie. ");
INSERT INTO mgw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Amani nendakunekya, nimpeyanga amani yangu'. Nimpeyangali kati dunia mwaimpeya. Kanemube na kyukala wala yogopa. ");
INSERT INTO mgw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwaaniyu'wine mu'lu' mwanammakie, ‘Nendabu'ka kasangu' ila naalu'a buya kai' kasinu.’ Kenda mukanipenda, mulu'e napusika kwa mwanjaa niyenda kwa Tati', nabembe nga aku'lu' pi'ta nenga. ");
INSERT INTO mgw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nimmakiangite makowe ga nambi'yambi' gai balo pitya, li'nga pagaalu'a pitya mwapate u'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naalu'a longelali kai' na mwenga makowe gambone, kwa mwanjaa mpi'ndo ywa dunia yi'no endaisa. Ywembe ntu'pu' uweso kasangu' nenga, ");
INSERT INTO mgw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","li'nga dunia itange panga napendi Tati', nanenga nipanga mu'mu'lu'mu'lu' kati Tati' mwabaaniamulise. Muyi'me, tubu'ke pano.” ");
INSERT INTO mgw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nenga na kitepo sa nnjabibu wa kakape, na Tati' bangu' nga ali'mi. ");
INSERT INTO mgw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila lutambi' nkati yangu' lwalukotoka pambika ywembe endalubu'ya, na kila lutambi' lwalupambika aalupetulya, li'nga lupambike munomuno. ");
INSERT INTO mgw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwenga muyomwike petulilwa kwa li'lu' liyi'gi'yo lyanimmakiyangite. ");
INSERT INTO mgw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mutame nkati yangu' nane nkati yinu. Kati lutambi' mwalukotoka pambika pangali tama mukitepo, nyinyonyo mwenga mukombwali pambika pangali tama nkati yangu'. ");
INSERT INTO mgw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nenga nga na nnjabibu, mwenga mwakindambi'. Ywatama nkati yangu', nane nkati yake, aywo aapambika munomuno, kwa mwanjaa pangali nenga mukombwali panga kili'be sosoti. ");
INSERT INTO mgw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu ywoywoti ywakotoka tama nkati yangu' aataikulilwa panja kati lutambi' lwalutaikulilwe no yu'ma. Bandu balutondwa na kulutaikulya pamwoto lutinike. ");
INSERT INTO mgw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mana mutami nkati yangu' na mayi'gi'yo gangu' nkati yinu, mulu'be sosoti samupala mwapeyelwa. ");
INSERT INTO mgw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tati' bangu' baakwi'yi'lwa mana mwapambika munomuno no panga mwabanamasi' bangu'. ");
INSERT INTO mgw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nenga nimpendi mwenga kati Tati' mwabanipendi nenga. Mutamange mulipendo lyangu'. ");
INSERT INTO mgw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mana mwaikolea amuli yangu' mwalu'a tama mulipendo lyangu', kati nenga mwaniikoleyite amuli ya Tati' bangu' no tama mulipendo lyabe. ");
INSERT INTO mgw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nimmakiangite makowe gano li'nga pulaa yangu' itame nkati yinu, na pulaa yinu itimi. ");
INSERT INTO mgw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Amuli yangu' nga yi'no. Mupendane kati mwanimpendangite mwenga. ");
INSERT INTO mgw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ntu'pu' upendo nku'lu' muno kuliko wa mundu kuupiya bwu'mi wake kwa kitumbu sa mambwiga bake. ");
INSERT INTO mgw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwenga mwamambwiga bangu', mana mwapanga kati mwanimwamulisa. ");
INSERT INTO mgw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mwenga ninkemangali kai' mwatumisi, kwa mwanjaa ntumisi atangali sakipanga bwana wake. Lakini nenga ninkemite mwenga mwamambwiga, kwa mwanjaa nimmakiangite goti ganigayu'wine bu'ka kwa Tati' bangu'. ");
INSERT INTO mgw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mwenga munisawili nenga, ila nenga nganinsawi mwenga, na kuntuma muyende mukapambike, itunda yo tamilika, nabembe Tati' bampeya sosoti samwaalu'a kwalu'ba kwa lina lyangu'. ");
INSERT INTO mgw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bai amuli yangu' kasinu nga yi'no, mupendane. ");
INSERT INTO mgw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Manaitei bandu ba padunia kabansukya mwenga mutange panga baalongwi wi'ti' kunisukya nenga. ");
INSERT INTO mgw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mukapangage mwabandu ba padunia, bandu ba padunia balu'e kumpenda kati mwabandu babe. Lakini kwa mwanjaa mwenga mwabandu ba padunia li, ila nenga ninsawi bu'ka padunia, kwa nyo dunia yenda kunsukya. ");
INSERT INTO mgw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muku'mbu'ki ganammakie, ‘Ntumisi nku'lu' li kulikoni bwana wake.’ Kwa mwanjaa baaniku'su'mbwi nenga, balu'a kunku'su'mbwa kai' na mwenga, mana baalikamwi liyi'gi'yo lyangu' baalikamwa kai' na linu. ");
INSERT INTO mgw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lakini ago goti baalu'a kumpangyanga mwenga kwa kitumbu sa lina lyangu', mwanjaa bantangiteli ywanitumite. ");
INSERT INTO mgw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngakotoka isa no longela nabo, bapalage bali na sambi, lakini nambi'yambi' bakombwali kwikengya panga ntu'pu' sambi. ");
INSERT INTO mgw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ywanisukwa nenga, asukwa na Tati' bangu' kai'. ");
INSERT INTO mgw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngakotoka kugapanga kasabe makowe gagaai ganapangilwali na mundu ywi'ngi', balu'e bali na sambi. Lakini nambi'yambi' bagabweni ganigapangite baatinisukya nenga na Tati' bangu' kai'. ");
INSERT INTO mgw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lakini bapangite nya li'nga mayi'gi'yo gagaandikilwe musalya yabe gatimi, ‘Baanisuki pangali kitumbu!’ ");
INSERT INTO mgw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Paalu'a isa aywo Nnyangatiyi ywanalu'a kuntuma kasinu bu'ka kwa Tati', aywo Loo ywa kakape ywabu'ka kwa Tati', ywembe ywo aanikong'ondelya. ");
INSERT INTO mgw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na mwenga mwanikong'ondelya kai' kwa mwanjaa mwaabile nanenga bu'ka patumbu.” ");
INSERT INTO mgw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nimmakiangite go li'nga mwaakane ku'bala muimani yinu. ");
INSERT INTO mgw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bandu balu'a kummi'nga mwenga mumayumba gabe ga kunnu'ba Nnu'ngu'. Kai' nsimu wendaisa wa kila ywaalu'a kummulaga mwenga, aakita antumikia Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baalu'a kumpangya go kwa mwanjaa baatangiteli Tati', wala banitangiteli nenga. ");
INSERT INTO mgw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bai, nimmakiangite makowe ga li'nga payaika saa yake mwaku'mbu'ki panga nammakiangite. “Nimmakiangiteli makowe gano bu'ka patumbu, kwa mwanjaa naabile pamope na mwenga. ");
INSERT INTO mgw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambi'yambi' ninnyendelya ywanitumike, na ntu'pu' ata yumo ywanilaluya panga, ‘Uyenda kwaku'?’ ");
INSERT INTO mgw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwa mwanjaa nimmakiangite makowe go, myoyo yinu itwi'li manyingipalo. ");
INSERT INTO mgw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakini nimmakianga, nantali yinu nenga niyende, mwanjaa mana nikotwike yenda, Nnyangatiyi aisali. Lakini mana niyi'i nalu'a kuntuma kasinu. ");
INSERT INTO mgw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naywembe paaisa alu'a kwakong'ondelya bandu ba padunia bu'kana na sambi, aki na ukumu ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bu'kana na sambi, mwanjaa baniu'bi'lyali, ");
INSERT INTO mgw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","bu'kana na aki, mwanjaa niyenda kwa Tati', namwe mwanibonali kai', ");
INSERT INTO mgw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","bu'kana na ukumu, mwanjaa mpi'ndo ywa dunia yi'no ayomwike ukumilwa. ");
INSERT INTO mgw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nibinago maingi ga kummakianga, ila kwa nambi'yambi' mukombwali kugakomeya. ");
INSERT INTO mgw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini paalu'a isa aywo Loo ywa kakape alu'a kunnongoya muukakape woti, mwanjaa aalongelali kwa utawala wake mwene, ila aabaya gaagayu'wa na kummakianga gagalu'a isa. ");
INSERT INTO mgw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ywembe anikwi'ya nenga, kwa mwanjaa alu'a kummakianga galu' gaalu'a kugapata bu'ka kasangu'. ");
INSERT INTO mgw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Goti gababilenago Tati' nga gangu', mwanjaa nibaite panga aywo Loo alu'a kummakianga galu' gaalu'a kugapata bu'ka kasangu'. ");
INSERT INTO mgw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Balo masu'ba masene namwe mwanibonali, no bu'ka pa masu'ba masene kai' mwanibona.” ");
INSERT INTO mgw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Apo bi'ngi' ba banamasi' bake ngabalaluyana, “Alombolya namani patubakia, ‘Balo masu'ba masene namwe mwanibonali, no bu'ka pa masu'ba masene mwanibona kai'?’ Kai' abaya, ‘Kwa mwanjaa nendayenda kwa Tati'!’” ");
INSERT INTO mgw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bai ngabalaluyana, “Alombolya namani pabaya, ‘Balo masu'ba masene?’ Tutangiteli alongela ki'li'.” ");
INSERT INTO mgw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu aatangite panga baapalike kunnaluya, bai ngaabakia, “Buli, mulaluyana galu' ganimmakie panga, ‘Balo masu'ba masene namwe mwanibonali, no bu'ka pa masu'ba masene mwanibona kai'?’ ");
INSERT INTO mgw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kakape nimmakianga, mwenga mwali'la no lombola, lakini bandu ba dunia balu'a napusika, mwalu'a nyopa, lakini nyopa kwinu kwagalambuka panga pulaa. ");
INSERT INTO mgw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nnwawa pakomboka endanyopa kwa mwanjaa saa yake ya lwu'ngu' yikite, lakini mana akombwike aku'mbu'kyali kai' lwu'ngu' lwo kwa mwanjaa ya pulaa panga mundu abelekwile padunia. ");
INSERT INTO mgw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kai' mwenga nambi'yambi' mwendanyopa, lakini nalu'a kumwisilyanga kai', na mwenga myoyo yinu yatwi'lya pulaa, na pulaa yo ntu'pu' mundu ywaalu'a kwibu'ya kasinu. ");
INSERT INTO mgw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lisu'ba lyo mwanilaluyali sosoti. Kakape nimmakianga, sosoti samwalu'a kwalu'ba Tati' kwa lina lyangu' bampeyanga. ");
INSERT INTO mgw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka nambi'yambi' munalu'bali sosoti kwa lina lyangu'. Mulu'bange na mwenga mwapata li'nga pulaa yinu itimi. ");
INSERT INTO mgw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nimmakiangite makowe go kwa ngongo. Lakini nsimu waaisa wanalongelali namwenga kwa ngongo, ila nalu'a kummakianga mpu'la abali ya Tati'. ");
INSERT INTO mgw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lisu'ba lyo mwalu'a lu'ba kwa lina lyangu', na nimmakiangali panga nalu'a kunnu'ba Tati' paali pinu mwenga, ");
INSERT INTO mgw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mwanjaa ywembe endakumpenda mwenga, kwa mwanjaa mwenga munipendi nenga na mwu'bi'li panga nibu'ka kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nenga naumi kwa Tati', isa mudunia, na nambi'yambi' niileka dunia no ki'li'bu'kya kwa Tati'.” ");
INSERT INTO mgw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bai banamasi' bake ngabammakia, “Kumbe! Nambi'yambi' ulongela mpu'la wangali ngongo. ");
INSERT INTO mgw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nambi'yambi' tutangite panga wenga utangite kila kili'be, na ntu'pu' kitumbu so laluyilwa maswali na mundu ywoywoti, kwa nyo tuu'bi'lile panga waumi kwa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ngaayangwa, “Buli nambi'yambi' mwu'bi'lile? ");
INSERT INTO mgw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nsimu wendaisa, kai' uikite wa mwenga mwaboti talanganika kila mundu kwa kisake, nanenga nalekelwa kisangu'. Lakini nenga nibali kisangu' mwanjaa, Tati' bai pamope nanenga. ");
INSERT INTO mgw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nimmakiangite makowe gano li'nga mupate ba na amani kwa mwanjaa mubile nkati yangu'. Mudunia mwapata siki, lakini mwikase, nenga niisindike dunia!” ");
INSERT INTO mgw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu paayomwi longela go, aaloi kunani, ngabaya, “Tati', yi'lu' saa yikite! Munkwi'ye Mwana winu li'nga naywembe ankwi'ye. ");
INSERT INTO mgw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mwanjaa mwaampei mwana winu utawala kwa bandu boti, li'nga apei ukoto wangayomoka boti bamwampeile. ");
INSERT INTO mgw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ukoto wangayomoka nga gu'no, kukutanga wenga waubile kisako wa Nnu'ngu' wa kakape, na kuntanga Yesu Kilisitu ywauntumike. ");
INSERT INTO mgw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tati', nenga ninkwi'yite pano padunia, niyomolile li'lu' lyengo lyamwanipeile nilipange. ");
INSERT INTO mgw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nambi'yambi', Tati', munikwi'ye nnu'ngi' yinu kwa gu'lu' utukupu wanaabile nawo payabile balo dunia umbilwa. ");
INSERT INTO mgw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nimpangite mutanganikwe kwa bandu bamwanipeile bu'ka mudunia. Baai bandu binu, na mwenga mwanipei babe bangu', nabembe balikamwile liyi'gi'yo linu. ");
INSERT INTO mgw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nambi'yambi' batangite panga kila samunipeile kibu'kite kasinu. ");
INSERT INTO mgw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nenga napeile yi'lu' abali yamwanipeile, nabembe baipokile, batangite panga kakape niuma kasinu, na bendau'bi'lya panga ngamwaanitumike. ");
INSERT INTO mgw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nalu'bya bo, niilu'byali dunia, ila nalu'bya balu' bamwanipeile mwanjaa nga binu. ");
INSERT INTO mgw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Boti banibile nabo nga binu, na binu nga bangu', na utukupu wangu' ubonekine mwa balu' bamunipeile. ");
INSERT INTO mgw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na nambi'yambi' niisa kasinu, nibileli kai' mudunia, lakini bembe bai mudunia. Mwa Tati' Mwaapeleteu! Kwa makakala ga lina linu lyamunipeile, nilu'ba mwali'ndi'le li'nga babe kili'be simo kati twenga mwatubile twabamo. ");
INSERT INTO mgw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panaabile nabo nenga, naatikwali'ndi'la kwa makakala ga lina linu lyamunipeile. Nenga naatikwali'ndi'la, ntu'pu' ata yumo ywaaobite ila yu'lu' ywapalikwa langamiswa, li'nga Maandiko Mapeleteu gatimi. ");
INSERT INTO mgw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bai, nambi'yambi' niisa kasinu, na nibaite makowe gano nibile balo padunia, li'nga bakombwe ba nsawani mupula yangu'. ");
INSERT INTO mgw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nenga naapeile abali yako, nabembe ba dunia ngabaasukwa, kwa mwanjaa bembe ba dunia li, kati nenga mwanibileli ywa dunia. ");
INSERT INTO mgw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nilu'bali mwabu'ye mudunia, ila nilu'ba mwali'ndi'le na yu'lu' nnau. ");
INSERT INTO mgw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bembe ba dunia li kati nenga mwanibile na ywa dunia li. ");
INSERT INTO mgw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mwabi'ke wiso kwa ukakape, liyi'gi'yo linu nga kakape. ");
INSERT INTO mgw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kati mwamunitumike mudunia, nanenga kai' natumike bembe mudunia, ");
INSERT INTO mgw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","paali pa bembe nenga namwene niibi'ka wiso kukutumikia, li'nga nabembe babi'ki'lwe wiso muukakape. ");
INSERT INTO mgw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nalu'byali abo bai, ila nalu'bya boti babaalu'a niu'bi'lya bu'kana na abali yabe. ");
INSERT INTO mgw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nilu'ba boti babe kili'be simo, Tati'! Nilu'ba babe nkati yitu kati mwenga mwamubile nkati yangu' nanenga nkati yinu. Nilu'ba babe kili'be simo li'nga dunia iu'bi'li panga mwenga nga mwamunitumike. ");
INSERT INTO mgw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nenga napei utukupu gu'gu'lu'gu'lu' wamwanipeile, li'nga babe kili'be simo kati twenga mwatubile twabamo, ");
INSERT INTO mgw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","nenga nibe nkati yabe, na mwenga mube nkati yangu', nilu'ba babi'ki'lwe wiso no ba kili'be simo, li'nga dunia itange panga mwenga ngamwamunitumike na mwapendi bembe kati mwamunipendi nenga. ");
INSERT INTO mgw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tati', mbala abo bamunipeile babe pamope nanenga palu' panibile li'nga baubone utukupu wangu' wamwanipeile, kwa mwanjaa mwalongwi wi'ti' kunipenda ibile balo umbilwa dunia. ");
INSERT INTO mgw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mwa Tati' Anogau! Dunia intangiteli, lakini nenga nintangite. Bano bembe batangite panga mwenga nga mwamunitumike. ");
INSERT INTO mgw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nimpangite mutanganikwe kwabe na nilu'a yendelya panga nyo, li'nga upendo wamubile nawo kasangu' ube nkati yabe, nanenga nibe nkati yabe.” ");
INSERT INTO mgw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu paayomwi longela go, ngayenda pamope na banamasi' bake. Baayi'i kwiyi' ya lukolongo lwa Kedroni. Pandu po paai mukyati', Yesu pamope na banamasi' bake ngabayingya mo. ");
INSERT INTO mgw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda ywaansongi Yesu, aapatangite pandu po kwa mwanjaa Yesu akokotyage kwembana po na banamasi' bake. ");
INSERT INTO mgw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bai, Yuda aakitweti kipi'nga sa asikali na ali'ndi'li babaatumilwe na api'ndo ba dini na Mafalisayo, ngaisa nabo mukyati' bapu'twile na taa, yenge na yombo ngali'. ");
INSERT INTO mgw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu aatangite goti gagalu'a kumpata, ngaayendelya na kwalaluya, “Mumpala nyai?” ");
INSERT INTO mgw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nabembe ngabannyangwa, “Yesu Nnasaleti.” Yesu ngaabakia “Nga nenga” Nsongi Yuda aai ayi'mi pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bai, Yesu paabakiye, “Nga nenga,” ngabaki'li'bu'kya nsu'gu' no tu'la pai'. ");
INSERT INTO mgw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu ngaalaluya kai', “Mumpala nyai?” Ngabannyangwa, “Yesu Nnasaleti.” ");
INSERT INTO mgw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ngaabakia, “Nimmakiangite panga nenga nga naywembe. Bai mana kamunipala nenga, mwaleke banamasi' bangu' babu'kange.” ");
INSERT INTO mgw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Agalongei go li'nga gatimi gaalongei, “Balu' bawanipeile nimwobiyeli ata yumo.” ");
INSERT INTO mgw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petili abile na lipanga, bai ngalisolomwa, ngankata likutu lya kummalyo ntumisi ywa mpi'ndo ywa dini. Ntumisi ywo akemelwage Malko. ");
INSERT INTO mgw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bai, Yesu ngammakia Petili, “Uki'li'bu'ye lipanga lyako mulupata. Buli, nipalikwali nywelya nnobo wa ngu'su'mbu' wabanipei Tati'?” ");
INSERT INTO mgw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kipi'nga sa asikali na mpi'ndo wabe pamope na ali'ndi'li ba Ayahudi baammoywi Yesu, ngabantaba ");
INSERT INTO mgw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","na kumpeleka kwa Anasi nkiwe Kayafa, ywaabile mpi'ndo nku'lu' wa dini mwaka wo. ");
INSERT INTO mgw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aywo Kayafa nga ywaabakiye api'ndo ba Ayahudi panga nantali mundu yumo awee paali pa bandu. ");
INSERT INTO mgw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petili na mwanamasi' ywi'ngi' baanki'ngime Yesu. Aywo mwanamasi' ywi'ngi' atanganikwe kwa mpi'ndo ywa dini, kwa nyo ayingi pamope na Yesu pangu'lu' munyumba ya mpi'ndo ywa dini. ");
INSERT INTO mgw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lakini Petili aayi'mi panja, paniango. Bai, aywo mwanamasi' ywaatanganikwe na mpi'ndo ywa dini aapitike panja, ngalongela na mwi'nja nni'ndi'li wa niango, ngaannyingia Petili nkati ya luwa. ");
INSERT INTO mgw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aywo mwi'nja nni'ndi'la niango ngaannaluya Petili, “Buli, wenga nga yumo ywa banamasi' ba mundu yu'?” Petili ngammakia, “Nenga lili!” ");
INSERT INTO mgw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Atumisi na ali'ndi'li baakungine mwoto kwa mwanjaa kwabile na mbepo, ngababa kabayota. Naywembe Petili aayi'mi pamope nabo kayota mwoto. ");
INSERT INTO mgw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bai, mpi'ndo ywa dini ngannaluya Yesu bu'kana na banamasi' bake na mayi'gano gake. ");
INSERT INTO mgw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu ngannyangwa, “Naalongei na kila mundu pa bandu. Naatiyi'gana mumayumba ga kunnu'ba Nnu'ngu' na munyumba ya Nnu'ngu', pandu pabakwembana Ayahudi boti. Nalongelali sosoti kwo iya. ");
INSERT INTO mgw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kwa mwanjaa buli unilaluya? Walaluye babaayu'wine ki'li' sanaabakiye. Bembe batangite sanaabakiye.” ");
INSERT INTO mgw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Paayomwi longela go nni'ndi'li yumo ywaayi'mi na Yesu ngaanku'mbwa mbande kabaya, “Unnyangwa buli nyo mpi'ndo ywa dini?” ");
INSERT INTO mgw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ngannyangwa, “Manaitei nilongei kinanyata ubaye awo unyatau, lakini mana nilongei kinannoga, mboni wendaniku'mbwa?” ");
INSERT INTO mgw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bai, Anasi ngampeleka Yesu, abile ntabilwa, kwa mpi'ndo ywa dini Kayafa. ");
INSERT INTO mgw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bai, Petili aayi'mi po kayota mwoto ngabannaluya, “Buli, wenga wa yumo ywa banamasi' bake?” Ywembe ngakana, “Nenga lili!” ");
INSERT INTO mgw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumo ywa atumisi ba mpi'ndo ywa dini, nnongo wa yu'lu' ywaakatilwe likutu na Petili, ngannaluya, “Buli, nakubwenili kukyati' pamope nakwe?” ");
INSERT INTO mgw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petili ngakana kai', popopo njogolo ngabi'ka. ");
INSERT INTO mgw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kindai' bulabula baantweti Yesu bu'ka kwa Kayafa, kumpeleka kunyumba ya liwali. Lakini baayingili nnyumba, kwa mwanjaa yingya kwabe mu'lu' waai mwilo kwo lya kilyo sa Pasika. ");
INSERT INTO mgw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kwa nyo, Pilato aatikwayendelya panja, ngabaya, “Mubile na masitaka gaku' kwa mundu yu'?” ");
INSERT INTO mgw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ngabannyangwa, “Ikapangage mundu yu' apangiteli ulau tupelekunnetali kasako.” ");
INSERT INTO mgw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ngaabakia, “Muntole mwabene, mukansenwe bu'kana na salya yinu.” Api'ndo ba Ayahudi ngabannyangwa, “Twenga tuyi'ki'ti'lwali kummulaga mundu ywoywoti.” ");
INSERT INTO mgw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yaapangilwe nyo li'nga gatimi mayi'gi'yo gaalongei Yesu panga awaa kiwo saku'. ");
INSERT INTO mgw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ngayingya kai' munyumba ya liwali, ngaankema Yesu na kunnaluya. “Ati' wenga nga Nkulungwa wa Ayahudi?” ");
INSERT INTO mgw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ngannyangwa, “Buli, ago mayi'gi'yo gako au bi'ngi' batikubakia abali yangu'?” ");
INSERT INTO mgw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ngannyangwa, “Nenga na Nnyahudi lili! Bandu bako na api'ndo ba dini yako ngabakuletike kasangu'. Upangite ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu ngannyangwa, “Ukulungwa wangu' wa padunia li. Ikapangage ukulungwa wangu' wa padunia yi'no, atumisi bangu' bapelenikengelya kanenikamuyi'lwe mmoko ga api'ndo ba Ayahudi. Lakini ukulungwa wangu' wa pano li.” ");
INSERT INTO mgw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Apo Pilato ngammakia, “Wenga nga Wankulungwa?” Yesu ngayangwa, “Wenga ngawaubaya panga nenga nga Nankulungwa. Nenga nibelekwi kwa kitumbu so, na kwa nyo niisi mudunia kwabakia bandu abali ya kakape. Kila mundu ywa ukakape aanipi'kania.” ");
INSERT INTO mgw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ngaammakia, “Ukakape nga kili'be gani?” Pilato paayomwi longela go, aapiti kai' panja, ngaabakia Ayahudi, “Nenga nikibonali ata kitumbu simo sa kunsitakya mundu yu'. ");
INSERT INTO mgw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lakini bu'kana na mayobelya ginu panga nenga ninnyu'gu'lyange ntabilwe yumo masu'ba ga Pasika. Bai, mupala ninnyu'gu'lyange Nkulungwa wa Ayahudi?” ");
INSERT INTO mgw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Apo ngabapanga ndu'ti, “Ata! Ayu' lili, ila Balaba!” Naywembe Balaba aai mpokonyoli. ");
INSERT INTO mgw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bai, Pilato ngaamulisa Yesu aku'mbu'lwe mikwasu. ");
INSERT INTO mgw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asikali ngabalu'ka kapiya ya mimimwa na kunng'walika muntwe, ngabanng'walika na nganju ya lukanda lwa sambalau. ");
INSERT INTO mgw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ngabaisa nnu'ngi' yake no baya, “Sikamu, Nkulungwa wa Ayahudi!” Ngabanku'mbwa mbande. ");
INSERT INTO mgw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato aapitike panja kai', ngaabakia, “Ninneta Yesu kasinu, li'nga mutange panga nikibwenili kitumbu sa kumpanga aukumilwe.” ");
INSERT INTO mgw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bai, Yesu ngapita panja aweti kapiya yailu'kilwe kwa mimimwa na nganju ya lukanda lwa sambalau. Pilato ngaabakia, “Lolange! Mundu wene nga aywo.” ");
INSERT INTO mgw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Api'ndo ba dini na ali'ndi'li pabaamweni baatu'ndu'biye malobe, “Ummambe! Ummambe munsalaba!” Pilato ngaabakia, “Muntolange mwabene mukammambe, kwa mwanjaa nenga nikibonali kitumbu sosoti sa kumukumu.” ");
INSERT INTO mgw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayahudi ngabannyangwa, “Twenga tubinayo salya, no bu'kana na salya yo ipalikwa awee kwa mwanjaa aaipangite Mwana wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato paayu'wine mayi'gi'yo go ngayogopa munomuno. ");
INSERT INTO mgw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bai, ngayingya nnyumba ya liwali kai' ngaannaluya Yesu, “Wenga wumi kwaku'?” Lakini Yesu annyangwili. ");
INSERT INTO mgw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kwa nyo Pilato ngaammakia, “Ulongelali nanenga? Buli, utangiteli panga nibile nawo utawala wa kukuyu'gu'lya na wa kukubamba?” ");
INSERT INTO mgw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu ngannyangwa, “Wenga ubileli na utawala wowoti kasangu', ila wu'lu' wopeyelwa na Nnu'ngu'. Kwa mwanjaa ya yu'lu' ywanikamukiye kasako ai na sambi ngu'lu' muno.” ");
INSERT INTO mgw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bu'ka po, Pilato aai kapala ndi'la ya kunnekekea, lakini Ayahudi ngabapanga ndu'ti, “Mana wannekekea mundu yu', wenga wambwigalyeli Kaisali. Kila mundu ywaaipanga nkulungwa antaukya Kaisali!” ");
INSERT INTO mgw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bai, Pilato waagayu'wine mayi'gi'yo go nganneta Yesu panja, bu'kapo Pilato ngatama pakiti'gu' sa ukumu, pandu papakemelwa “Sakafu ya Maliwe” (kwa Kiebrania, Gabasa). ");
INSERT INTO mgw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaai saa sita muntwekati lisu'ba lyo bi'ka wiso kwa Pasika. Pilato ngaabakia Ayahudi, “Ayu' nga nkulungwa winu!” ");
INSERT INTO mgw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lakini bembe bapangite ndu'ti, “Ummulage! Ummulage! Ummambe munsalaba!” Pilato ngaalaluya, “Buli, nimmambe nkulungwa winu?” Api'ndo ba dini ngabannyangwa, “Twenga ntu'pu' nkulungwa ila Kaisali!” ");
INSERT INTO mgw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato ngaakamukiya Yesu mmoko gabe li'nga abambilwe. Bai, ngabantola Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Abu'i apu'twile nsalaba wake mpaka pandu papakemelwa “Lipakala lya Ntwe” (kwa Kiebrania Golgotha). ");
INSERT INTO mgw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Apo nga pabammambite, pamope nakwe baabambilwe bandu bi'ngi' abi'li', yumo lwammalyo na ywi'ngi' kunki'ya, na Yesu pakatikati. ");
INSERT INTO mgw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato aamulise liandikilwe lilu'nga libi'ki'lwe panani ya nsalaba. Na lyembe lyaandikilwe nnyinya, “Yesu Nnasaleti, Nkulungwa wa Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayahudi baalisomike lilu'nga lyo, kwa mwanjaa apo paabambilwe Yesu paai papipi na kilambo. Kai' lilu'nga lyo lyaandikilwe kwa Kiebrania, Kiroma na Kigiliki. ");
INSERT INTO mgw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bai, api'ndo ba dini ngabammakia Pilato, “Kaneuandike ‘Nkulungwa wa Ayahudi,’ ila ‘Ywembe aabaite, Nenga nga Nankulungwa wa Ayahudi.’” ");
INSERT INTO mgw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ngayangwa, “Ganiandike, niandike!” ");
INSERT INTO mgw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Asikali pabaayomwi kummamba Yesu, magu'bo gake ngabagabagana mapungu nsese, lipungu limo kwa kila asikali. Kai' baatweti na nganju yake, yayai mbuma wangali sonelwa bu'ka kunani mpaka pai', yawesekineli baganika. ");
INSERT INTO mgw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Abo asikali ngababakiana, “Kanetuipopwane, ila tuipangi mpumbe yapanga ya nyai.” Likowe lyo lyapangilwe li'nga gatimi Maandiko Mapeleteu gagabaya, “Batibagana iwalo yangu', na ngu'bo yangu' baipangi mpumbe.” Amo nga mwabaapangite abo asikali. ");
INSERT INTO mgw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Papipi na nsalaba wake Yesu baayi'mi mau' bake, nku'we mau' bake, Malia nnyumbowe Kleopa na Malia Makatalena. ");
INSERT INTO mgw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu paabweni mau' bake, na papipi yake ayi'mi yu'lu' mwanamasi' ywaampendile, ngaabakia mau' bake, “Mau'! Mulole, aywo nga mwana winu.” ");
INSERT INTO mgw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bu'kapo ngammakia yu'lu' mwanamasi', “Ulole aywo nga mau' bako.” Na tangu' saa yi'lu' aywo mwanamasi' antweti mau' bake Yesu atame kasake. ");
INSERT INTO mgw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu pabweni panga goti gatimile, no li'nga Maandiko Mapeleteu gatimi, ngabaya, “Niminya nnyota.” ");
INSERT INTO mgw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Apo paabile na bakuli lyalitwi'li kasiki. Bai ngabampeya kasiki kwa lutengo lwa malu'ba ga husopo, na kumwekekeya pankano wake. ");
INSERT INTO mgw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu paayomwi pokya yo kasiki ngabaya, “Gatimile!” Ngakotima na kwipiya loo yake. ");
INSERT INTO mgw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yaai Ijumaa, lisu'ba lyo bi'ka wiso kwa Sabato. Kwa nyo li'nga mitwi kaneitame munsalaba lisu'ba lya Sabato, mwanjaa lisu'ba lyo lyaai liku'lu', api'ndo ba Ayahudi baannu'bite Pilato magu'lu' ga abo bababambilwe gati'kwanilwe na mitwi yabe ibu'yi'lwe. ");
INSERT INTO mgw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bai, asikali baayi'i ti'kwana magu'lu ga yu'lu' ywa kumbito na yu'lu' ywenebi'li' babaabile babambilwe pamope na Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lakini pabamwisili Yesu, baamweni panga ayomokile, kwa nyo baanti'kwaniyeli magu'lu'. ");
INSERT INTO mgw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakini asikali yumo aamwomite nkwa mumbau, popopo yapitike myai na masi'. ");
INSERT INTO mgw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ywaalibweni likowe lyo aatikong'ondelya na ukong'ondeli wo wa kakape. Na atangite panga alongela ga kakape li'nga mwenga muu'bi'li. ");
INSERT INTO mgw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Likowe lyo lyaapangilwe kati mwagalongela Maandiko Mapeleteu, “Ntu'pu' ata kyupa sake simo sasalu'a ti'kwanilwa.” ");
INSERT INTO mgw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kai' maandiko gi'ngi' gabaya, “Baalu'a kunnola yu'lu' ywabaamwomite.” ");
INSERT INTO mgw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bu'ka pa go, Yusupu, mwenekaya wa Alimataya, aannu'bike Pilato annyi'ki'ti'ye kuubu'ya ntwi wa Yesu. (Yusupu aai mumini wa Yesu, lakini kwo iya, mwanjaa aayogopage api'ndo ba Ayahudi). Bai, Pilato ngaannyi'ki'ti'a. Kwa nyo Yusupu aayi'i kuubu'ya ntwi wa Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo ywaannyendeli patumbu Yesu lisu'ba limo kilo, aaisi apu'twile manemane yaiyangabanike na ubani kyasi sa kilo salasini. ");
INSERT INTO mgw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bai, boti abi'li' ngabautola ntwi wa Yesu, na kuubilingya sanda yaipakalilwe na mauta manjuli bu'kana na Ayahudi mwabayobelile muusiki. ");
INSERT INTO mgw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Apo paabambilwe Yesu paai na kyati', na mukyati' so kwabile na lisiko lyalyabile linasikilwali mundu ywoywoti nkati yake. ");
INSERT INTO mgw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwa mwanjaa lyaai lisu'ba lyo bi'ka wiso Sabato kwa Ayahudi, na mwanjaa lisiko lyaai papipi, ngabansika Yesu mo. ");
INSERT INTO mgw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jumapili kindai' bulabula, Malia Makatalena aayi'i kulisiko, ngalibona li'lu' liwe lya paniango wa lisiko libu'yilwe. ");
INSERT INTO mgw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bai, ngabutuka mpaka kwa Petili na kwa yu'lu' mwanamasi' ywi'ngi' ywaapendilwe na Yesu ngaabakia, “Bammu'yite Bwana kulisiko na tutangiteli kwabammi'kite.” ");
INSERT INTO mgw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petili na yu'lu' mwanamasi' ywi'ngi' baayi'i kulisiko. ");
INSERT INTO mgw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Boti abi'li' baatibutuka lakini yu'lu' mwanamasi' ywi'ngi' aabutwike muno kuliko Petili, kwa nyo alongoli ika kulisiko. ");
INSERT INTO mgw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Paalitike no lingulya nkati, aibweni sanda, lakini aayingili nkati. ");
INSERT INTO mgw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petili ngaisa nsu'gu' yake kanki'ngama, ngayingya mulisiko na amo aibweni sanda, ");
INSERT INTO mgw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na si'lu' kitambala saatabilwe Yesu muntwe. Saabi'kilweli pamope na yi'lu' sanda, ila saatikwi'kanilwa no bi'ki'lwa pandu pa kisake. ");
INSERT INTO mgw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bu'kapo yu'lu' mwanamasi' ywi'ngi' ywaalongoli ika kulisiko ngayingya nkati, ngabona, ngau'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Baai balo banagatangali Maandiko Mapeleteu gagaabaite panga yapalikwe ayu'ke bu'ka kwa awi'li.) ");
INSERT INTO mgw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bai, abo banamasi' baabuyangani kaya. ");
INSERT INTO mgw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia ayi'mi panja ya lisiko, kali'la. Paabile balo kali'la aatilita no lingulya mulisiko, ");
INSERT INTO mgw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ngaabona malaika abi'li' babaweti ngu'bo uu batami palu' pabaaugonjike ntwi wa Yesu, yumo kuntwe na ywenebi'li' kumagu'lu'. ");
INSERT INTO mgw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Abo malaika ngabannaluya, “Mau', kwa mwanjaa ki'li' muli'la?” Naywembe ngaabakia, “Baubu'yite ntwi wa Bwana wangu', na nitangiteli kwababi'kite!” ");
INSERT INTO mgw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Paalongelage go, aagalambuki nsu'gu', ngammona Yesu ayi'mi, lakini aakwipwili panga nga Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ngaannaluya, “Mau', muli'la ki'li'? Mumpala nyai?” Malia akitage panga aywo ngannolekeji wa kyati', ngaammakia, “Bwana, manaitei wenga ngawaubu'yite ntwi wa Yesu, unibakiye kwaubi'kite, nanenga nalu'a kuutola.” ");
INSERT INTO mgw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu ngammakia, “Malia!” Naywembe Malia ngagalambuka, ngammakia kwa Kiebrania, “Raboni!” (Lombolya “Mwalimu”). ");
INSERT INTO mgw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ngammakia, “Upalikwali kunikamwa, kwa mwanjaa ninayendali kunani kwa Tati'. Lakini uyende kwa alongo bangu' ukabakiye, ‘Niyenda kwa Tati' bangu' na Tati' binu, Nnu'ngu' wangu' na Nnu'ngu' winu.’” ");
INSERT INTO mgw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Malia Makatalena ngayenda kwapeya abali balu' banamasi' panga amweni Bwana, na aammakie nyo. ");
INSERT INTO mgw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kitamwiyo lisu'ba lya Jumapili, banamasi' baabile bakwembine munyumba, na milyango yaabile iyigalilwe kwa mwanjaa baayogopage api'ndo ba Ayahudi. Bai, Yesu ngaisa, ngayi'ma pakati yabe, ngaabakia, “Amani ibe kasinu!” ");
INSERT INTO mgw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Paayomwi longela go, ngaalaya moko na lubau lwake. Apo banamasi' ngabapulaika muno kummona Bwana. ");
INSERT INTO mgw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu ngaabakia kai', “Amani ibe kasinu! Kati Tati' mwabanitumike nenga, nanenga nintuma mwenga.” ");
INSERT INTO mgw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Paayomwi longela go, ngaayulya na kwabakia, “Mupokyange Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mana mwaasamya bandu masambi gabe, basamilwa. Mana mwaasamyali, basamilwali.” ");
INSERT INTO mgw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi (ywakemelwa Mapaga), yumo ywa balu' kumi' na abi'li', aabileli pamope nabo paaisi Yesu. ");
INSERT INTO mgw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bai balu' banamasi' bi'ngi' ngabammakia, “Tumweni Bwana.” Tomasi ngaabakia, “Mana ngotwike kugabona mabai ga misumali mumoko gake no yi'ya lukonji lwangu' palu', kai' yi'ya luboko lwangu' mulubau lwake naau'bi'lyali katu.” ");
INSERT INTO mgw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bai, bu'ka po pi'ta masu'ba manane abo banamasi' baabile kai' pamope mu'lu' nnyumba, na Tomasi aai pamope nabo. Milyango yaai iyigalilwe, lakini Yesu ngaisa, ngayi'ma pakati yabe, ngabaya, “Amani ibe kasinu!” ");
INSERT INTO mgw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bu'kapo ngammakia Tomasi, “Ulete lukonji lwako pano, ugalole moko gangu'. Ulete luboko lwako ukaluyi'i mulubau lwangu'. Kaneube na kyukala, ila uu'bi'li!” ");
INSERT INTO mgw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi ngannyangwa, “Bwana wangu' na Nnu'ngu' wangu'!” ");
INSERT INTO mgw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu ngaammakia, “Buli, uu'bi'lya kwa mwanjaa unibweni? Nantali yabe balu' bangali kunibona, lakini bau'bi'lile.” ");
INSERT INTO mgw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu aapangite kwa banamasi' bake myasu yambone, yi'ngi' iandikilweli mukitabu si'no. ");
INSERT INTO mgw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lakini yi'no iandikilwe li'nga mupate u'bi'lya panga Yesu nga Kilisitu, Mwana wa Nnu'ngu', no kwo u'bi'lya mupate ba na ukoto kwa makakala ga lina lyake. ");
INSERT INTO mgw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bu'ka pa go, Yesu aatikwapitya kai' banamasi' bake mbwega ya litanda liku'lu' lya Tibelia. Aapiti nyinya. ");
INSERT INTO mgw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petili, Tomasi (ywakemelwage Mapaga), Natanaeli mwenekaya wa Kana Galilaya, bana abi'li' ba Zebedayo na banamasi' bake bi'ngi' abi'li' baai pamope. ");
INSERT INTO mgw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petili aatikwabakia, “Niyenda loba omba.” Nabembe ngabammakia, “Na twenga tulu'a longwana nawenga.” Bai, ngabayenda u'bu'ka ngalaba, lakini kilo so baapatikeli sosoti. ");
INSERT INTO mgw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kakutumbwa saa, Yesu aayi'mi mbwega ya litanda liku'lu', lakini banamasi' baatangiteli panga aai nga ywembe. ");
INSERT INTO mgw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bai, Yesu ngaalaluya, “Mwansembe, munapatali omba boboti au buli?” Bembe ngabannyangwa, “Ata! Tunapatali kili'be.” ");
INSERT INTO mgw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu ngaabakia, “Mutumbukiye lupi'li'li' lwingo lwa kummalyo ga ngalaba na mwenga mwapata omba.” Bai, ngabatumbukia no pata omba bambone, ata baakombwili uta kai' kwa nnyolokano wa omba. ");
INSERT INTO mgw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Apo yu'lu' mwanamasi' ywaapendilwe na Yesu ngaammakia Petili, “Nga Bwana!” Simoni Petili paayu'wine panga nga Bwana, ngawala kiwalo sake (mwanjaa aaweti ngu'bo ya lyengo bai), ngau'mbya mumasi'. ");
INSERT INTO mgw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lakini balu' banamasi' bi'ngi' baaisi kumbwani kwa ngalaba ku'no kabauta lupi'li'li' lwalutwi'li omba, baabileli kuutalu na kuuyu'mu', ila baai meta mya bu'ka muntengo. ");
INSERT INTO mgw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pabaaikite kuuyu'mu' baubweni mwoto wa makala ukunganilwe na panani yake paabi'kilwe omba na likati. ");
INSERT INTO mgw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu ngaabakia, “Muletange pano omba bi'ngi' ba balu' bamulobite.” ");
INSERT INTO mgw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Bai, Simoni Petili ngau'bu'ka mungalaba, aatiuta lu'lu' lupi'li'li' mpaka kuuyu'mu' lwalwabile lutwi'lile omba aku'lu' 153. Baatiyolokana, lakini lupi'li'li' lwakutwanikeli. ");
INSERT INTO mgw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu ngaabakia, “Mwisange samulabuke.” Ntu'pu' ata yumo ywabe ywaalowite kunnaluya, “Wenga nga wanyai?” Mwanjaa baatangite aai Bwana. ");
INSERT INTO mgw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu ngaisa, ngatola likati, ngaapeya, apangite nyinyonyo na balu' omba. ");
INSERT INTO mgw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yi'no yaai pampanda patatu Yesu kwaapitya banamasi' bake tangu' yu'ka bu'ka kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pabayomwi lya, Yesu ngannaluya Simoni Petili, “Simoni mwana wa Yoani! Buli, unipendile nenga kulikoni mwabanipenda ba?” Naywembe ngayangwa, “Elo Bwana, utangite panga nenga nikupendile.” Yesu ngammakia, “Wakote bana ngondolo bangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bu'kapo ngammakia pampanda pabi'li', “Simoni mwana wa Yoani! Buli, unipendile?” Petili ngannyangwa, “Elo, Bwana, utangite panga nikupendile.” Yesu ngammakia, “Wakote ngondolo bangu'.” ");
INSERT INTO mgw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ngannaluya pampanda patatu, “Simoni mwana wa Yoani! Buli, unipendile?” Apo Petili aatinyopa kwa mwanjaa aalaluyilwe patatu, “Unipendile?” Ngammakia, “Bwana, wenga utangite goti, panga nenga nikupendile.” Yesu ngammakia, “Wakote ngondolo bangu'. ");
INSERT INTO mgw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kakape nikubakia, pawaabile wamwinsembe wayobeli kwitaba lunga no yenda kwokwoti kwopala. Lakini pawapanga wang'oi wagoloya moko gako, na mundu ywi'ngi' alu'a kutaba na kukupeleka kwaupendili yenda.” ");
INSERT INTO mgw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Kwo longela nyo alayite Petili mwaalu'a waa na kunkwi'ya Nnu'ngu'.) Bu'kapo ngammakia, “Uningi'ngame.” ");
INSERT INTO mgw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Apo Petili ngagalambuka, ngammona yu'lu' mwanamasi' ywaapendilwe na Yesu kaki'ngama. (Ayu' mwanamasi' nga yu'lu' pa kilyo sa kitamwiyo atamage papipi muno na Yesu na kunnaluya, “Bwana nga nyai ywaalu'a kusongya?”) ");
INSERT INTO mgw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bai, Petili paamweni ywo, ngannaluya Yesu, “Bwana, na yu'no buli?” ");
INSERT INTO mgw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ngannyangwa, “Mana kanipala alame mpaka panaaki'li'bu'ka, wenga ga ki'li'? Wenga uniki'ngame nenga.” ");
INSERT INTO mgw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bai, likowe lyo lyaabambite kwa balu' aumini panga mwanamasi' ywo aawali. Lakini Yesu ammakieli panga mwanamasi' ywo awaali, ila, “Manaitei kanipala alame mpaka panaaki'li'bu'ka, wenga ga ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ayu' nga yu'lu' mwanamasi' ywaagabweni makowe ga na kugaandika. Na twenga tutangite panga gaagalongei nga kakape. ");
INSERT INTO mgw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kubile makowe gi'ngi' maingi gaapangite Yesu, ikapangage gaandikilwe goti, limo bu'ka pa li'ngi', nengite ata dunia yene ilu'e li'nganali kwibi'ka itabu yaipalage andikilwa.");
INSERT INTO mgw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Waupendilwe Topili, mukitabu sangu' sa patumbu naatikuandikya bu'kana na makowe goti gaapangite Yesu no yi'gana bu'ka paatumbwi lyengo lyake, ");
INSERT INTO mgw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka lisu'ba li'lu' lyaatu'ndu'bi'yilwe kunani. Paabi balo tu'ndu'bi'yi'lwa aapiyite malagyo kwa makakala ga Loo Mpeleteu kwa balu' atumilwe baasawile. ");
INSERT INTO mgw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa masu'ba alubaini bu'ka pa kiwo sake, aatikwapitya kwo kokotya li'nga bakwipwe panga kakape aai nkoti. Aabonekine kwabe, naywembe aalongei nabo makowe ga Ukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lisu'ba lyaakwembine nabo aalagi, “Kenemubu'ke mono mu Yelusalemu, ila muli'nde yi'lu' upo yabaalagi Tati', yi'lu' yamwaniyu'wine kaniilongelya. ");
INSERT INTO mgw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoani aabatisike kwa masi', lakini masu'ba gendaisa mulu'a batisilwa kwa Loo Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bai, atumilwe pabaakwembine na Yesu ngabannaluya, “Bwana, buli wu'no nga nsimu waulu'a buyangania ukulungwa wabe Isilaili?” ");
INSERT INTO mgw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu ngaabakia, “Alyo lyengo linu lili lyo tanga lisu'ba au nsimu wabaubi'i Tati' bangu', ago gabile muutawala wabe bene. ");
INSERT INTO mgw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini Loo Mpeleteu paamwisilyanga, mwapokya makakala na mwanikong'ondelya ku Yelusalemu, kumili'ma yoti ya Yudea, ku Samalia na ata kuundi'la ya dunia.” ");
INSERT INTO mgw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Paayomwi longela go, Yesu ngatu'ndu'bi'yi'lwa kunani. Pabaabile kabanningulya, ngayingya mulyunde na baamwenili kai'. ");
INSERT INTO mgw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pabaabi balo kabalingulya kunani, imukya bandu abi'li' babaaweti magu'bo mauu bayi'mi papipi nabo, ");
INSERT INTO mgw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ngababaya, “Mwenga mwabandu ba ku Galilaya, mboni muyi'mi kamulingulya kunani? Ayu' Yesu ywatolilwe bu'ka kasinu yenda kunani, alu'a buya kai' nyinyonyo kati mwamumweni kayenda kunani.” ");
INSERT INTO mgw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bu'kapo atumilwe baaki'li'bu'ki ku Yelusalemu bu'ka mu Kitu'mbi' sa Minjaituni, sakibile kilomita yimo bu'ka Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pabaaikite pa kilambo so sa ku Yelusalemu, baayi'i musumba sa kugolopwa kwabaatamage. Balu' babaabile palu' baai Petili, Yoani, Yakobi, Andelea, Pilipi, Tomasi, Batolomayo, Matei, Yakobi mwana wa Alufayo, Simoni wa Selote na Yuda mwana wa Yakobi. ");
INSERT INTO mgw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aba boti baai kabakongolekana kwo lu'ba Nnu'ngu' pamope na alwawa nsi'si', Malia mau' bake Yesu, na anunabe. ");
INSERT INTO mgw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lisu'ba limo, Petili aayi'mi pakati ya balu' bandu aumini, baai kati mitumbi mya na isilini. ");
INSERT INTO mgw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ngabaya, “Mwalongo bangu', yaapalikwe galu' Maandiko Mapeleteu gatimi, Loo Mpeleteu aatilondwa pi'tya kwa Daudi panga Yuda ngaywaalongwiye balu' babammoywi Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda aai yumo ywamukipi'nga situ, kwa mwanjaa asaulilwe yangatiya lyengo li'.” ");
INSERT INTO mgw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yuda aapi'mite nng'unda kwa yi'lu' mbanje yaapatike kwa iyendo yake ndau, paabile munng'unda ngatu'la pai' puanika ndumbo na matumbu goti gaai panja. ");
INSERT INTO mgw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Likowe lyo lyaatanganikwe na bandu boti babatamage ku Yelusalemu, ata ngabautina lina nng'unda wo kwa luga yabe, “Akeldama,” lombolya, “Nng'unda wa Myai.”) ");
INSERT INTO mgw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Bai, iandikilwe mukitabu sa Zabuli, ‘Mwitamo yake yaigala yame, mundu ywoywoti kaneatame nkati yake.’ Kai' iandikilwe panga, ‘Lipala lya lyengo lyake atole ywi'ngi' mundu.’ ");
INSERT INTO mgw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kwa nyo ipalikwa tunsawe mundu yumo mwa balu' babaabile pamope na twe nsimu woti watutyangae nakwe Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Aywo aapalikwa panga yumo mwa balu' babaai pamope na twenga tumbulya Yoani paabatisage mpaka lisu'ba li'lu' Yesu lyaatolilwe bu'ka kwitu yenda kunani. Aywo abe nkong'ondeli pamope natwenga kwa uyu'ki wake Yesu.” ");
INSERT INTO mgw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Apo, ngabatambwa maina ga bandu abi'li' yumo aai Yusupu, ywakemelwage Balsaba (ywembe aatanganikwe kwa lina lya Yusita) na Matiasi. ");
INSERT INTO mgw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bu'kapo ngabalu'ba Nnu'ngu', “Bwana, wenga wiitangite myoyo ya kila mundu. Kwa nyo utulaye ywaku' kati ya aba abi'li' ywaunsawile, ");
INSERT INTO mgw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","li'nga aibe lipala lya lyengo lya utumilwe lyalilei Yuda, no yenda pandu pake mwene papanni'ngana.” ");
INSERT INTO mgw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ngabapanga mpumbe, ngasaulilwa Matiasi, naywembe ngayongeyelwa mwa balu' atumilwe ku'mi na yumo. ");
INSERT INTO mgw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Paliikite lisu'ba lya Pentekosite, aumini boti baakongolekine pandu pamo. ");
INSERT INTO mgw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kwa kiimuimu lilobe lyaayu'wanike kati limbu'nga liku'lu' lyaumi kunani, ngaliitwi'li'ya yi'lu' nyumba yoti yabaatami. ");
INSERT INTO mgw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ngagapitya malimi kati ga mwoto, ngagabaganika no tu'la panani ya kila mundu. ");
INSERT INTO mgw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Boti ngabatwi'li'yi'lwa Loo Mpeleteu, no tumbwa longela kwa luga mbali'mbali', kati Loo mwaayalile. ");
INSERT INTO mgw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bai, ku Yelusalemu kwaabile na Ayahudi babankilikityage Nnu'ngu' babaaumi kila nni'ma wa padunia. ");
INSERT INTO mgw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pabayu'wine malobe go, lipi'nga liku'lu' lya bandu lyaatikongolekana. Boti baating'ondoka muno kwa mwanjaa kila mundu aayu'wine abo aumini, kabalongela kwa luga yake mwene. ");
INSERT INTO mgw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Baating'ondoka no sangala kababaya, “Aba boti babalongela, benekaya ba ku Galilaya li? ");
INSERT INTO mgw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iteibuli kai', kila mundu aayu'wa kabalongela kwa luga yake yo belekwa nayo? ");
INSERT INTO mgw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pakati yitu kwina bandu bababu'ka mili'ma ya Palti, Wamedi na Waelamu, bi'ngi' benekaya ba Mesopotamia, Yudea, Kapadokia, Ponto na Asia, ");
INSERT INTO mgw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piligia, Pamfilia, Misili na lwingo lwa ku Libya papipi na nni'ma nku'lu' wa Kulene na ageni bu'ka Roma, ");
INSERT INTO mgw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","kati yabe kubile na Ayahudi na bandu babaasawi kwikotea dini ya Kiyahudi, bandu ba nni'ma wa Kilete na ku Alabia. Ata nyo twayu'wa boti kabalongela makowe maku'lu' ga iyendo ya Nnu'ngu' muluga yitu yo belekwa.” ");
INSERT INTO mgw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boti baatisangala no ng'ondoka, kabalaluyana, “Makowe ga galombolya ki'li'?” ");
INSERT INTO mgw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lakini bi'ngi' baatikwasalanga, kababaya, “Bandu ba batilobya!” ");
INSERT INTO mgw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bai, Petili ngayi'ma papipi na balu' atumilwe bi'ngi' ku'mi na yumo, ngatumbwa kwaalya bandu kwa lilobe liku'lu', “Mwaayahudi ayangu' na mwenga mwaboti mwamutama ku Yelusalemu, mutange likowe li'no na munipi'kanie. ");
INSERT INTO mgw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kakape bandu ba banalobyali kati mwamugania, kwa mwanjaa yi'no saa itatu ya kindai' bai. ");
INSERT INTO mgw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kakape panga likowe li' nga li'lu' lyalyaabayilwe na nnondoli ywa Nnu'ngu' Yoeli. ");
INSERT INTO mgw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mumasu'ba galu' ga kuundi'la abaya Nnu'ngu', naalu'a kunnyitanikia Loo wangu' panani ya bandu boti. Bana binu analu'me na alwawa baalu'a londwa, ansembe binu baalu'a gabona makowe gayambi', na agoi baalu'a lota maloto. ");
INSERT INTO mgw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kakape, ata kwa atumisi bangu' analu'me na alwawa, naalu'a kwayityanikia Loo wangu', nabembe, baalu'a londwa. ");
INSERT INTO mgw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Naalu'a panga mangelongelo kumaunde na myanju miku'lu' padunia, kwalu'a ba na myai, mwoto, na lyoi litopau. ");
INSERT INTO mgw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lisu'ba lyaalu'a ba mulubi'ndu' na mwei walu'a ba nkele kati myai, kaliegelya isa lisu'ba liku'lu' lya ngama lya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Apo mundu ywoywoti ywaalu'a lu'ba yangatiyilwa na Bwana, alu'a kosopolelwa.’” ");
INSERT INTO mgw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mwenga mwa Isilaili, mupi'kani mayi'gi'yo ga ganigalongela! Nnu'ngu' aalayite mpu'la bai panga kakape antumike Yesu ywa Nasaleti. Aapangite nyo kwa ndi'la ya mangelongelo na myanju yaapangite pakati yinu, kati mwamumweni mwabene. ");
INSERT INTO mgw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nnu'ngu' aatangite no binia bu'ka kwai'mbu' panga Yesu aakamuyilwe mumaboko ginu, na mwenga kummulaga kwa kwalekya bandu alau bammambe munsalaba. ");
INSERT INTO mgw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lakini Nnu'ngu' ngannyu'ya bu'ka kuuwi'li, ngaankosopolya bu'ka mulwu'ngu' lwake. Kwa mwanjaa yaawesekineli ywembe kamulwa na makakala ga kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwa mwanjaa Daudi aabaite nyinyo kwa ywembe ywo, ‘Naamweni Bwana nnu'ngi' yangu' masu'ba goti, kwa mwanjaa abi kuluboko lwangu' lwa mmalyo, li'nga nakane tenandena. ");
INSERT INTO mgw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa nyo, mwoyo wangu' watenapusika, kai' nilulutike ilulu yo napusika. Yi'ga yangu' yatama muu'bi'lyo, ");
INSERT INTO mgw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwa mwanjaa loo yangu' wailekali kumambi', wala wannekali ywabile Mpeleteu wako abole. ");
INSERT INTO mgw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unilayite ndi'la ya bwu'mi, wanitwi'li'ya pulaa panaaba papipi nawe.’” ");
INSERT INTO mgw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mwalongo bangu' ba ku Isilaili, mbala nimmakiange mpu'la gagampatike Daudi, tati' bitu. Ywembe aatiwaa no sikilwa, lisiko lyake libile papanopano mpaka li'no. ");
INSERT INTO mgw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lakini kwa mwanjaa aai nnondoli ywa Nnu'ngu', aatangite panga Nnu'ngu' aatikunnagya kwa kilapo panga ammi'ka yumo ywa lubelekwo lwake pakiti'gu' sake sa lenji. ");
INSERT INTO mgw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi aatumbwi wi'ti' kugabona makowe gagaalu'a pangilwa na Nnu'ngu' na nyo ngabaya kwa uyu'ki wa Kilisitu nsimu waabaite, ‘Analekelwali kumambi', wala yi'ga yake inabolali.’ ");
INSERT INTO mgw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Nnu'ngu' annyu'yite Yesu na twenga twaboti nga twaakong'ondeli ba likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nnu'ngu' amwu'bwiye Yesu na kummi'ka pandu pake pakummalyo, apoki bu'ka kwa Tati' li'lu' lilagyo lya Loo Mpeleteu, naywembe aayitanikiye si'lu' samukibona nambi'yambi' na kukiyu'wa. ");
INSERT INTO mgw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwa mwanjaa Daudi aai anau'bu'kali kunani, lakini aatibaya, ‘Bwana Nnu'ngu' aammakie Bwana wangu', Utame kummalyo gangu', ");
INSERT INTO mgw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mpaka panaalu'a kwabi'ka andumu bako pai' ya magu'lu' gako.’ ");
INSERT INTO mgw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kwa nyo Isilaili yoti mutange kakape panga, yu'lu' Yesu ywamummambike munsalaba, Nnu'ngu' ampangite panga Bwana na Kilisitu!” ");
INSERT INTO mgw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bai, Pabaagayu'wine mayi'gi'yo go, gaatikwalumiya mumyoyo yabe. Ngabaalaluya Petili na balu' atumilwe bi'ngi', “Mwalongo bitu, tupange buli?” ");
INSERT INTO mgw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petili ngaayangwa, “Munng'alambuki Nnu'ngu' na kila yumo ywinu abatisilwe kwa lina lya Yesu Kilisitu, li'nga mupate samilwa masambi ginu no pokya yi'lu' upo ya Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwa mwanjaa lilagyo li'no lyaai kwinu mwenga, bana binu, kwa balu' boti babatama kuutalu, na kwa kila mundu ywaalu'a kemelwa na Bwana Nnu'ngu' witu.” ");
INSERT INTO mgw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petili aatikwakwi'li'ka kwa mayi'gi'yo gi'ngi' gambone na kwakong'ondelya, “Mwikosopoli bu'ka mu lu'no lubelekwo lwakau.” ");
INSERT INTO mgw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bai, baingi baatikugayi'ki'tya mayi'gi'yo gake Petili, ngababatisilwa. Na lisu'ba lyo bandu bateyongekeya ika kati mitumbi elupu itatu. ");
INSERT INTO mgw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abo boti ngabayendelya binia kwiyi'gana bu'ka kwa atumilwe, tama pamope kati alongo, metwana makati, lya pamope no lu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kila mundu ngannyogopa Nnu'ngu', kwa mangelongelo na myanju yambone yayaapangilwe kwo pi'tya atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Babaau'bi'li boti baayendeli ba pamope na mali yabe batebaganana. ");
INSERT INTO mgw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Baapi'miye migunda na ili'be yabe, bu'ka po bagana mbanje li'ngana na mwaipalikwa kwa kila mundu. ");
INSERT INTO mgw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kila lisu'ba baabile kabakongolekana pamope mulua lwa nyumba ya Nnu'ngu'. Bametwanage makati no kwembana mumisengo yabe lya kilyo so kwo napusika na kwa mwoyo nnogau. ");
INSERT INTO mgw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bankwi'yite Nnu'ngu' no pendelwa na bandu boti. Kila lisu'ba Bwana aatikwayongekeya mitumbi ya bandu, babaabile kabakosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lisu'ba limo musaa tisa pipi na kitamwiyo, yai saa yo lu'ba, Petili na Yoani bayendage kulua lwa nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Bai, paabile na mundu yumo ywaabile kitewe bu'ka belekwa. Abi'ki'lwage pa niango wa nyumba ya Nnu'ngu' waukemelwage Mzuli, kila lisu'ba li'nga alu'be kwa bandu babayingya mulua lwa nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yu'lu' kitewe paabweni Petili na Yoani bai papipi no yingya mulua lwa nyumba ya Nnu'ngu', ngaalu'ba bannyangatiye mbanje. ");
INSERT INTO mgw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petili na Yoani ngabammu'nju'lya minyo, naywembe Petili ngammakia, “Utulinge!” ");
INSERT INTO mgw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yu'lu' kitewe ngaalinga, ku'no kau'bi'lya pata kili'be bu'ka kwabe. ");
INSERT INTO mgw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lakini Petili ngammakia, “Ne ntu'pu' mbanje, ila si'lu' sanibile naso ngasanilu'a kupeya. Kwa lina lya Yesu Kilisitu ywa ku Nasaleti, uyi'me kwa magu'lu' gako uyende!” ");
INSERT INTO mgw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bu'kapo ngankamwa luboko lwake lwa kummalyo kuntu'ndu'bi'ya, papalu'palu' magu'lu' gake ngagapata makakala. ");
INSERT INTO mgw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ngau'mba no yi'ma, no tumbwa yenda kwa magu'lu' gake. Bu'kapo ngayingya mulua lwa nyumba ya Nnu'ngu' pamope na Petili na Yoani, ku'no kayenda no u'mbau'mba na kunnumba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bandu boti babaabile palu', ngabammona kayenda kwa magu'lu' gake ku'no kannumba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pabakwipwi panga nga yu'lu' ywaabile kalu'balu'ba palu' pa niango Mzuli wa nyumba ya Nnu'ngu', ngabasangala muno ata baakombwili tanga gagampatike. ");
INSERT INTO mgw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mundu ywo ywatepulilwe apendili lekana na Petili na Yoani, na bandu boti ngabasangala muno, no butukya mu Balasa lya Selemani. ");
INSERT INTO mgw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petili paabweni bandu bakongolekine, ngaabakia, “Mwenga mwabandu ba ku Isilaili, mwanjaa ki'li' mulisangala likowe li'no? Mboni mutubu'nju'lya minyo kwa kutusangala, baya kwake kati twenga tupangite kwa makakala au kwa upeleteu witu kumpangiya mundu yu' ayende kwa magu'lu' gake? ");
INSERT INTO mgw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nnu'ngu' ywa Bulaimu, Isaki na Yakobi, Nnu'ngu' ywa akinatati' bitu ankwi'yite ntumisi wake Yesu. Lakini mwenga mwaatikumpiya li'nga apwatilwe kiwo na kunkana nnu'ngi' ya Pilato, pamope no panga Pilato ammakiangite annekekeye ayende. ");
INSERT INTO mgw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yu'lu' ywaabile Mpeleteu na mwene Aki mwaatikunkana, na mwenga ngamummakia Pilato annyu'gu'li yu'lu' mmulagi. ");
INSERT INTO mgw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bai, mwammulige ywaabile kitumbu sa bwu'mi, lakini Nnu'ngu' ngannyu'ya bu'ka kuuwi'li. Twenga ngatwaakong'ondeli ba makowe ga. ");
INSERT INTO mgw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mundu yu' ywamumona na kuntanga apatike kai' makakala kwa uweso wa lina lya Yesu. Kwa ndi'la yo u'bi'lya lina li' kakape ywembe atepulilwe, kati mwamwibonia mwabene. ");
INSERT INTO mgw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mwalongo bangu', ndangite panga mwenga na api'ndo binu mwampangite Yesu aga goti wangali tanga namani samupanga. ");
INSERT INTO mgw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lakini kwa ndi'la yi' Nnu'ngu' ayomolekeyage si'lu' sasaalondolilwe na alondoli ba Nnu'ngu' boti, panga Kilisitu wake alu'a teselwa. ");
INSERT INTO mgw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bai, mugalambuke na kummuyangania Nnu'ngu', li'nga ansami masambi ginu. ");
INSERT INTO mgw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bu'kapo Bwana annetya nsimu wo pu'mu'lya, naywembe alu'a kuntuma Kilisitu ywaabi'kilwe bu'ka kwai'mbu' li'nga kunkosopolya mwe, nga Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ywembe aapalikwa igala kunani mpaka pawalu'a timya nsimu wa Nnu'ngu', paabi'ka wiso ili'be yoti, kati mu'lu' mwaabaite bu'ka kwai'mbu' kwa alondoli bake apeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwa mwanjaa Musa aabaite, ‘Bwana Nnu'ngu' winu alu'a kunsaulyanga nnondoli ywalandana nanenga bu'ka mulukolo lwinu, yaapalikwa kunnyu'wa ywo kwa kila likowe lyaalu'a kummakia. ");
INSERT INTO mgw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na mundu ywoywoti ywaalu'a kotoka kunnyu'wa aywo nnondoli ywa Nnu'ngu', aabi'ki'lwa kuutalu na bandu bake no langamiswa.’ ");
INSERT INTO mgw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Alondoli boti ba Nnu'ngu', tumbulya Samweli na balu' babammi'ngi'yite, baalondwi abali ya makowe ga gagapangika masu'ba gano. ");
INSERT INTO mgw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mwenga mwabana ba alondoli, na lilagano lya Nnu'ngu' lyaapangite na kiu'ku'lu' binu lyaai kasinu. Kati mwammakie Bulaimu, ‘Kwa ndi'la ya lubelekwo lwako, makabila goti ga padunia gaalu'a yaliwa.’ ");
INSERT INTO mgw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nnu'ngu' pannyu'yite ntumisi wake Yesu, ngaantumike wi'ti' kasinu, li'nga annyali kwa kunng'alambwa kila yumo ywinu bu'ka mundi'la yake ndau.” ");
INSERT INTO mgw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petili na Yoani pabaabile palu' kabaalya bandu, api'ndo ba dini na mpi'ndo ywa ali'ndi'li ba nyumba ya Nnu'ngu', na Masadukayo ngabaisa. ");
INSERT INTO mgw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bembe ngabausika muno kwa mwanjaa ya abo atumilwe, babaabi kabayi'gana no ala panga Yesu aatiyu'ka, na uyu'ki wake ukong'ondelya panga kakape awi'li baalu'a yu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kwa nyo ngabaaboywa na kwayi'ya muutabilwe, mpaka pammalau' yake, kwa mwanjaa yai kitamwiyo. ");
INSERT INTO mgw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini bambone kati ya bandu balu' babaayu'wine li'lu' liyi'gi'yo ngabau'bi'lya, na isabu ya analu'me babaau'bi'lile ngaiyongekeya mpaka ika kati mitumbi elupu tano. ");
INSERT INTO mgw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pammalau' yake alongosi ba Kiyahudi, api'ndo na balimu ba salya, ngabakongolekana ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paabile na Anasi Mpi'ndo wa Dini, Kayafa, Yoani, Alekisanda na bandu bi'ngi' boti ba lukolo lwa mpi'ndo ywa dini. ");
INSERT INTO mgw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ngabaayi'mika Petili na Yoani nnu'ngi' yabe, ngabaalaluya, “Mwenga kwa makakala gaku' au kwa lina lya nyai mulipangite likowe li'?” ");
INSERT INTO mgw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Apo Petili abi ntwi'li'yi'lwa Loo Mpeleteu, ngayangwa, “Mwenga mwaayi'mi'li'ki na mwaapi'ndo ba bandu. ");
INSERT INTO mgw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Li'no mutupekeseni kwa kitumbu sa makowe manogau gaapangilwe yu'lu' kitewe na kutulaluya mu'lu' mwaatepulilwe. ");
INSERT INTO mgw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kwa nyo, mwenga na bandu boti ba Isilaili, mupalikwa tanga panga mundu yu' ywayi'mi nnu'ngi' yinu li'no nkoti bai, kwa makakala ga lina lyake Yesu Kilisitu ywa ku Nasaleti. Ywembe mwenga mwaatikummamba, lakini Nnu'ngu' ngannyu'ya bu'ka kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ayu' nga yu'lu' Yesu Maandiko Mapeleteu gagammaya, ‘Liwe lyamulikani mwa asengi, nambi'yambi' lipangite liwe liku'lu' lya pakitumembe.’ ");
INSERT INTO mgw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Kwa nyo ntu'pu' ywakombwa kosopolelwa kwa ndi'la ya mundu ywi'ngi', kwa mwanjaa mudunia yoti bandu ntu'pu' ndi'la yi'ngi' yo kosopolewa ila kwa lina li'lu' lyabapeyilwe na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Balu' akolongosi pabaubweni ukangamau wa Petili na Yoani no tanga panga baai bandu bangali ilimu wala tanganikwa, ngabaasangala muno, nnu'ngi' ngabakwipwa panga ukangamau wabe waai kitumbu so baa papipi na Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lakini pabaamweni yu'lu' mundu ywatepulilwe ayi'mi pamope nabo, baakombwili longela kili'be. ");
INSERT INTO mgw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Alongosi ngabaamulisa bapite panja ya si'lu' kitamo, ku'no kabalaluyana bene na bene likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Twapange ki'li' bandu ba? Na tukombwali kana mangelongelo maku'lu' gagapangilwe no bonekana na kila mundu ywa ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lakini li'nga iya likowe li'no kaneliyendeli landala muno mwa bandu, ipalikwa twakwi'li'ke bandu ba kanebalongele kai' na mundu ywoywoti kwa lina lya Yesu.” ");
INSERT INTO mgw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bu'kapo ngabaakema kai' nnyumba na kwakanikiya kanebalowe longela kai' wala yi'gana kwa lina lya Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petili na Yoani ngabaayangwa, “Mubaye mwenga mwabene panga aki nnu'ngi' ya Nnu'ngu' kunnyu'wa mwenga, kuliko kunnyu'wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lakini twenga tukombwali kotoka baya galu' gatugabweni na kugayu'wa.” ");
INSERT INTO mgw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bu'kapo balu' api'ndo ba kitamo ngabaakwi'li'ka kai' kwa ukali' na kwalekekeya bayende. Baapatikeli ndi'la ya kwasenwa, kwa mwanjaa bandu boti baabile kabankwi'ya Nnu'ngu' kwa likowe li'lu' lyalipangike. ");
INSERT INTO mgw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kwa mwanjaa aywo mundu ywaatepulilwe aabile na myaka yaipi'ta alubaini. ");
INSERT INTO mgw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Papalu'palu' Petili na Yoani pabaayu'gu'lilwe, ngababuyangana kwaayabe na kwaawanikiya galu' gabaabakiyilwe na api'ndo ba dini na agoi. ");
INSERT INTO mgw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nabembe pabaagayu'wine go, ngabalu'mbana boti na kunnu'ba Nnu'ngu' kababaya, “Wenga ngawa Bwana wauumbike kunani, pai', baali na kila kili'be sakibile nkati yake. ");
INSERT INTO mgw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ngawaumpangite ntumisi wako, tati' bitu Daudi abaye kwa makakala ga Loo Mpeleteu, ‘Mwanjaa ki'li' mili'ma intaukya Nnu'ngu' na kumusikya? Mboni bandu bagania makowe gangali ngama? ");
INSERT INTO mgw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Akulungwa ba dunia baaibi'i wiso, na atawala baakwembine pamope kunkana Bwana na Kilisitu wake.’ ");
INSERT INTO mgw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Kakape Helode na Pontio Pilato, bandu ba Isilaili na bandu bangali Ayahudi, baatikongolekana pano pa kilambo, li'nga panga likowe linyatau kwa ntumisi wako mpeleteu Yesu ywaunsawile panga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bembe baagayomoli makowe gawabinile tangu' kwai'mbu' kwa uweso wako na mwaupendile. ");
INSERT INTO mgw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambi'yambi' wa Bwana, ulinge iyogokeyo yabe, na utulongoye twenga twaatumisi bako tupate ala mayi'gi'yo gako wangali ba na kyukala. ");
INSERT INTO mgw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ulaye makakala gako li'nga kwatepwa atamwe, upange myanju na mangelongelo kwa lina lya ntumisi wako Yesu Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pabaayomwi lu'ba, pandu palu' pabaakongolekine ngapalendema, nabembe boti ngabatwi'li'yi'lwa na Loo Mpeleteu, ngabatumbwa ala liyi'gi'yo lya Nnu'ngu' wangali ba na kyukala. ");
INSERT INTO mgw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Balu' babaau'bi'lile boti baai na mwoyo gumo no nugia limo, ntu'pu' ata yumo ywaabile na kili'be, ywaakipangite kibe mali yake mwene, ila baatikamwana kwa kila kikowe. ");
INSERT INTO mgw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Atumilwe baatikong'ondelya kwa makakala, kwa uyu'ki wa Bwana Yesu, naywembe Nnu'ngu' ngaayalya muno. ");
INSERT INTO mgw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ntu'pu' ata mundu yumo kwabe ywapalage kili'be, kwa mwanjaa kila likowe bapangage pamope, baapi'miye migunda na mayumba na mbanje ngabakongolya pamope, ");
INSERT INTO mgw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kwakamukiya atumilwe, kila mundu aabaganilwe kati mwaapalage. ");
INSERT INTO mgw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwaabile na Nnawi yumo mmelekwe wa Kuplo, lina lyake Yusupu. Atumilwe baankemite kwa lina lya Balanaba, lilombolya nsengi ywa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mundu ywo aapi'miye nng'unda waabile nawo, na mbanje ye aakamukiye atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Bai, mundu yumo ywakemelwage Anania, na nnyumbowe Safila, baapi'miye nng'unda wabe. ");
INSERT INTO mgw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lakini nnyumbowe aai atangite, Anania aabawi lipungu lya mbanje yaapatike na yi'ngi' iya, yayigile ngaakamukiya atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petili ngannaluya, “Anania, mboni Ibilisi autwi'liye mwoyo wako, li'nga kummakia ubu'su' Loo Mpeleteu, uiyike lipungu lya mbanje lyaupi'mie nng'unda? ");
INSERT INTO mgw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pawaabile balo unapi'mi'yali nng'unda wo, ngita waai mali yako? Ata popi'miye mbanje yoipatike ngita yai yako? Mwanjaa ki'li' uganiyite panga likowe li'no mumwoyo wako? Wenga unkongiteli mundu ila unkongite Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania paagayu'wine mayi'gi'yo go, ngatu'la pai' no waa. Na boti babaayu'wine abali yo baatiyogopa muno. ");
INSERT INTO mgw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ansembe ngabaisa wi'ki'lya yi'ga yake, ngabampikiya panja na kunsika. ");
INSERT INTO mgw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagapite masaa gatatu nnyumbowe ngayingya, naywembe aai anayu'wali lyolyoti lya makowe galu' gagaapangike. ");
INSERT INTO mgw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petili ngannaluya, “Unibakie yi'no nga mbanje yoti yamupatike, pamupi'miye nng'unda winu?” Ngannyangwa, “Elo nga yi'no.” ");
INSERT INTO mgw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bu'kapo Petili ngammakia, “Mwanjaa ki'li' muyi'ki'tyaniye kumpaya Loo Mpeleteu ywa Bwana? Pi'kania! Balu' babauma kunsika nsengogo baikite paniango, nawenga nyinyonyo bapakupeleka!” ");
INSERT INTO mgw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bai, papalu'palu' Safila ngatu'la pai' nnu'ngi' ya Petili no waa, na balu' ansembe ngabayi'ngya nnyumba ngabankwemba awile. Ngabantola no yenda kunsika papipi na nsengowe. ");
INSERT INTO mgw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bwoga nku'lu' ngawapata aumini boti na bandu bi'ngi' babaayu'wine likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Atumilwe baapangite myanju yambone na mangelongelo kwa bandu. Na boti babaau'bi'lile baabile kabakongolekana mu Balasa lya Selemani kwo nugia limo. ");
INSERT INTO mgw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na pai ntu'pu' ata mundu yumo ywangau'bi'lya ywaapayite lu'mbana nabo, lakini ata nyo balu' babaau'bi'lile baatilumbilwa muno na bandu. ");
INSERT INTO mgw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na isabu ya bandu babaamwu'bi'li Bwana, analu'me kwa alwawa, yaatiyongekeya muno. ");
INSERT INTO mgw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwa nyo bandu baabile kabaapeleka atamwe musimbasimba na kwagonjeka muindanda na mumakai, li'nga Petili paalu'a pi'ta kiwili sake saapi'ti bi'ngi' babe. ");
INSERT INTO mgw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bandu bambone ngabakongolekana bu'ka muilambo ya papipi na ku Yelusalemu, kabaaleta atamwe na bandu babaatesilwe na moka, na boti baatitepulwa. ");
INSERT INTO mgw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Bu'kapo Mpi'ndo wa Dini na aine babaabile mukipi'nga sa Masadukayo, ngabaabi'kya bwigu atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bai, ngabaaboywa atumilwe na kwayi'ya muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lakini kilo malaika wa Bwana ngaisa no yu'wa milyango ya utabilwe, kwapiya panja na kwabakia, ");
INSERT INTO mgw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muyende, mukayi'me munyumba ya Nnu'ngu' mukaali bandu ndi'la yi'no ya ukoto wayambi'.” ");
INSERT INTO mgw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kindai' putiputi bayi'i munyumba ya Nnu'ngu' yi'gana bandu kati mwababakiyilwe. Mpi'ndo wa Dini na aine pabaaisile, bakemi kitamo sa Balasa Liku'lu' lya Ayahudi na api'ndo boti ba ku Isilaili, ngabaatuma bandu bayende munyumba ya atabilwe kwaleta atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini balu' atumisi pabaaikite ku'lu' kuutabilwe baakwembiteli balu' atumilwe. Kwa nyo ngababuya no piya abali. ");
INSERT INTO mgw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ngababaya, “Tuikoli nyumba ya atabilwe iyigalilwe ndendende na ali'ndi'li kabali'ndi'la mumilyango. Lakini patuyu'wile tunakunkwembali mundu ywoywoti nnyumba!” ");
INSERT INTO mgw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bai, mpi'ndo ywa ali'ndi'li ba nyumba ya Nnu'ngu' na api'ndo ba dini pabagayu'wine go, baatisangala muno, ngababa na kyukala no kotoka tanga sasaapatike. ");
INSERT INTO mgw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mundu yumo ngaisa na kwabakia, “Lingange, balu' bandu bamwaayingiye muutabilwe bai munyumba ya Nnu'ngu' bayi'gana bandu.” ");
INSERT INTO mgw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Apo mpi'ndo ywa ali'ndi'li ba nyumba ya Nnu'ngu' pamope na bandu bake, baayi'i munyumba ya Nnu'ngu', ngabaaleta. Lakini baaboywili kwa makakala, kwa mwanjaa baayogwipe ku'mbu'lwa maliwe na bandu. ");
INSERT INTO mgw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bai, ngabaapeleka na kwayi'mi'ka nnu'ngi' ya kitamo. Mpi'ndo wa Dini ngaabakia, ");
INSERT INTO mgw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Twaankanikiye kwa makakala, kanemuyi'gane kai' kwa lina lya Yesu, na nambi'yambi' mubambiye mayi'gano ginu mu Yelusalemu yoti, na mubini kutubi'kya lukoolo lwa kiwo sa mundu yu'.” ");
INSERT INTO mgw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petili na balu' atumilwe aine ngabayangwa, “Tupalikwa kunnyu'wa Nnu'ngu' kuliko bandu. ");
INSERT INTO mgw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nnu'ngu' ywa kitati' bitu, aatikunnyu'ya Yesu, yu'lu' ywamwammulige kwa kummamba munsalaba. ");
INSERT INTO mgw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nnu'ngu' aatikunkwi'ya, ngammi'ka kuluboko lwake lwa kummalyo, panga Kolongosi na Nkosopoli, li'nga aipange Isilaili inng'alambuki Nnu'ngu' no samilwa sambi. ");
INSERT INTO mgw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twenga nga twaakong'ondeli ba makowe ga, na Loo Mpeleteu ywabaapeyilwe na Nnu'ngu' balu' babannyu'wa, naywembe endakong'ondelya kai'.” ");
INSERT INTO mgw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Balu' boti ba mukitamo pabaagayu'wine makowe go, baatiusika muno no pala kwabulaga balu' atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini Mfalisayo yumo lina lyake Gamalieli, ywaabile mwalimu wa salya ywaesimilwe na bandu boti, aayi'mi nnu'ngi' ya kitamo, ngaamulisa balu' atumilwe bapite panja pasene. ");
INSERT INTO mgw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bu'kapo ngaabakia balu' ba mukitamo, “Mwenga mwa bandu ba ku Isilaili, mulinguli wiso ali' likowe lyamupala kwapangya bandu ba. ");
INSERT INTO mgw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kwa mwanjaa nsimu waupite kwaapitike mundu yumo lina lyake Teude, ywaipunage panga ywembe nga mundu ywa ngama, ngapata banamasi' mitumbi mya nsese, babaalu'mbine nakwe. Lakini aatibulagilwa, na banamasi' bake boti ngababaganika no oba. ");
INSERT INTO mgw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kai' nsimu wu'lu' wo balangilwa bandu, ngaapiti Yuda ywa ku Galilaya. Aywo naywembe aatikwauta bandu nabembe ngabanki'ngama, lakini naywembe aatibulagilwa, na banamasi' bake boti ngababaganika. ");
INSERT INTO mgw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nambi'yambi' nendakumakianga, mwaleke bayende kasabe! Kwa mwanjaa likowe li' au lyengo li' manaitei alitumbwi mundu, kakape lyakondali. ");
INSERT INTO mgw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini manaitei libu'i kwa Nnu'ngu' mwalu'a kwakombwalili kwaibya bandu ba. Bai, mwilinguli wiso mwakane taukana na Nnu'ngu'!” Balu' ba muitamo baayi'ki'tyanie na mwababakiyilwe na Gamalieli. ");
INSERT INTO mgw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ngabaakema atumilwe na kwamesa mikwasu na kwaamulisa kanebayi'gane kai' kwa lina lya Yesu. Bu'kapo ngabaalekekeya babu'ke. ");
INSERT INTO mgw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bai, balu' atumilwe ngabapita panja ya si'lu' kitamo kwo napusika, kwa mwanjaa yai aki yabe bapate oni no teselwa kwa kitumbu sa lina lya Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Baakotwikeli yi'gana no ala abali inannoga panga Yesu nga Kilisitu, kila lisu'ba mulua lwa nyumba ya Nnu'ngu' na nsengo kwa nsengo. ");
INSERT INTO mgw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mumasu'ba galu' bu'kana na isabu ya banamasi' mwaiyongekeyage muno, ngakupitya maku'ku'li'ko kati ya au'bi'lya ba Kiyunani na au'bi'lya ba Kiyahudi. Baatiku'ku'li'ka kwa mwanjaa alwawa awi'li'ka ba Kiyunani baatilibalilwa nsimu wo baganilwa ilyo ya kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kwa nyo balu' atumilwe ku'mi na abi'li' ngabakema kitamo sa ipi'nga yoti ya banamasi' na kwabakia, “Yaalu'a nogelelyali twenga kotoka ala mayi'gi'yo ga Nnu'ngu', kwa kitumbu sa lyengo lya kwabagana ilyo. ");
INSERT INTO mgw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kwa nyo mwalongo, musawe nkati yinu bandu saba babatanganikwe panga batwi'li'yilwe na Loo Mpeleteu na bene ikima. Abo tuwesa kwapeya lyengo li'no, ");
INSERT INTO mgw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","na twenga tubinia yendelya lu'ba Nnu'ngu' no ala liyi'gi'yo lyake.” ");
INSERT INTO mgw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Galu' gabaagalongei ngagayi'ki'ti'lwa na bandu boti, nabembe ngabaasawa Sitefano, mundu ywatwi'li'yilwe imani na Loo Mpeleteu na Pilipi, Plokolo, Nikanoli, Timoni, Pamena na Nikola ywa Antiokia ywaagalambwike panga Nnyahudi. ");
INSERT INTO mgw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ngabaaleta bandu bo nnu'ngi' ya atumilwe, nabembe ngabaabi'ka maboko panani yabe kwalu'bya. ");
INSERT INTO mgw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Liyi'gi'yo lya Nnu'ngu' ngaliyendelya bamba, na isabu ya banamasi' ngaiyongekeya muno mu Yelusalemu ata api'ndo bambone ba dini ya Kiyahudi ngabamwu'bi'lya Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bai, Sitefano aai apeyilwe ngu'ngu' na makakala bu'ka kwa Nnu'ngu', aapangite myanju na mangelongelo maku'lu' kwa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini ngakupitya bandu nsi'si' ngabataukana nakwe Sitefano. Bandu bo baai munyumba ya kunnu'ba Nnu'ngu' yaitanganikwe kwa lina lya “Bandu Ulu” nabembe baaumi ilambo ya Kilene na Alesandulia na bi'ngi' bu'ka mumili'ma ya Kilikia na Asia. Bandu bo ngabayendelya taukana na Sitefano. ");
INSERT INTO mgw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini bankombwili, kwa mwanjaa ya ikima yake na Loo Mpeleteu ywannongoyage longela. ");
INSERT INTO mgw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ngabaapeya mbanje bandu nsi'si', li'nga bakong'ondeli ubu'su' panga, “Tunnyu'wine Sitefano kaala mayi'gi'yo go kupulu kwa Musa na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ngabaasopa bandu, api'ndo na balimu ba salya, nabembe ngabammoywa Sitefano na kumpeleka ku Balasa Liku'lu. ");
INSERT INTO mgw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ngabaaleta akong'ondeli ba ubu'su' babaabaite, “Mundu yu' akotokali baya mayi'gi'yo go kupulu Nyumba ya Nnu'ngu' witu mpeleteu pamope na salya ya Musa. ");
INSERT INTO mgw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tunnyu'wine kabaya panga ayu' Yesu ywa ku Nasaleti, alu'a paalabiya pandu papeleteu no galambwa mimu yatupeyilwe na Musa.” ");
INSERT INTO mgw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bandu boti babaabile palu' pakitamo sa balasa bammu'nju'li minyo Sitefano, ngabammona kuminyo yake kugalambwike, kubile kati malaika. ");
INSERT INTO mgw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bai, Mpi'ndo wa Dini ngannaluya, “Buli mayi'gi'yo ga nga kakape?” ");
INSERT INTO mgw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefano ngayangwa, “Mwalongo bangu' na mwaakina tati' bangu', munipi'kani! Nnu'ngu' mwene utukupu, aapiti tati' bitu Bulaimu nsimu wabaabile ku'lu' kunni'ma wa Mesopotamia. Aai balo amya kukilambo sa Alani, ");
INSERT INTO mgw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nnu'ngu' ngammakia, ‘Ubu'ke munni'ma wako na waleke alongobo boti, uyende kunni'ma wanilu'a kulangilya.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bai, Bulaimu ngabu'ka munni'ma wa Wakaladayo no yenda tama Alani. Bu'ka pa kiwo sa tati' bake, Nnu'ngu' ngammu'ya na kunneta panni'ma wu'no wamutama nambi'yambi'. ");
INSERT INTO mgw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nnu'ngu' ampeili ulisi wowoti munni'ma wu'no, ata nyo Nnu'ngu' annagi panga ywembe na lubelekwo lwake baalu'a lisi nni'ma wu'no, na nsimu wo Bulaimu aai ntu'pu' mwana. ");
INSERT INTO mgw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nnu'ngu' ngammakia, ‘Lubelekwo lwako lwatama munni'ma wa kigeni, na akwo baapangilwa abanda no pangilwa manyatau kwa myaka mya nsese. ");
INSERT INTO mgw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naalu'a kuusenwa nni'ma wu'lu' wawaalu'a kwapanga abanda. Bu'ka po, baalu'a bu'ka munni'ma wo na kunikilikitya pandu pano.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nnu'ngu' ngampeya Bulaimu lilagano na liku'mbi' nga lyaai usaili wake. Naywembe Bulaimu ngampapa Isaki na kumwina lisu'ba lya nane bu'ka belekwa kwake. Bu'kapo Isaki ngampapa Yakobi, naywembe Yakobi ngaapapa balu' au'ku' bitu aku'lu' ku'mi na abi'li', nabembe ngabainilwa na tati' babe Yakobi. ");
INSERT INTO mgw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kwa mwanjaa api'ndo bitu aku'lu', bana ba Yakobi, baammi'ki bwigu nnongo wabe Yusupu, ngabampi'mi'ya panga mmanda akwo Misili. Lakini Nnu'ngu' aai pamope nakwe, ");
INSERT INTO mgw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ngaankosopolya bu'ka mmaule goti gaagapatike, kai' ngaampeya ikima no yi'ki'ti'lwa paayi'mage nnu'ngi' ya Falao, nkulungwa wa Misili. Falao ammi'i panga nnyi'mi'li'ki ku Misili na nyumba yake yoti. ");
INSERT INTO mgw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bai, ngakupitya njala munni'ma woti wa ku Misili na Kanani, ngaipanga siki ngu'lu' na kiu'ku'lu' bitu baakombwili pata kilyo sosoti. ");
INSERT INTO mgw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobi paayu'wine panga kubile na ilyo akwo Misili, ngaatuma bana bake, yani kiu'ku'lu' bitu, bayende kwo. Awo ngawai mwanja wabe nnongoi. ");
INSERT INTO mgw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mumwanja wenebi'li', Yusupu ngailaya kwa alongo bake, na Falao ngaatanga alongobe Yusupu. ");
INSERT INTO mgw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bu'kapo Yusupu ngatuma bandu yenda kwakema tati' bake Yakobi pamope na alongo bake boti baise ku Misili, nabembe baai mitumbi sabini na tano. ");
INSERT INTO mgw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kwa nyo Yakobi aayi'i Misili, kwaawi'li ywembe na bana bake. ");
INSERT INTO mgw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yi'ga yabe yaki'li'bu'yilwe Shekemu no sikilwa mulisiko lyaapi'mite Bulaimu, bu'ka kwa bana ba Hamoli kwa mbanje. ");
INSERT INTO mgw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Lakini nsimu wa lilagano lyaapeyilwe Bulaimu bu'ka kwa Nnu'ngu' kauegelya timya, isabu ya bandu bitu yendeyongeya muno. ");
INSERT INTO mgw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nkulungwa ywi'ngi' ywaakotwike kuntanga Yusupu wala abali yake, ngatumbwa tawala Misili. ");
INSERT INTO mgw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aywo nkulungwa ngaakonga bandu ba nni'ma witu, kwatesa api'ndo bitu na kwaamulisa baataikwe bana ilekeleke, li'nga bawee. ");
INSERT INTO mgw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nsimu wo Musa ngawaabelekwile, naywembe aabile mwana nng'olou muno. Ngalelelwa kwa myei itatu munyumba ya abelei bake. ");
INSERT INTO mgw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na pabampikiye panja li'nga awee, biti Falao ngantola na kunnela kati mwana wake. ");
INSERT INTO mgw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa ngayi'ganilwa makowe goti ga ikima ya ku Misili, ngapanga mundu nkangamau kwa mayi'gi'yo na iyendo. ");
INSERT INTO mgw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa paaikiye myaka alubaini ngayenda kwatyangilya alongo bake ba ku Isilaili. ");
INSERT INTO mgw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ku'lu' ngammona yumo ywabe kabonelwa na Mmisili, ngaankengya na kunku'mbwa yu'lu' Mmisili na kummulaga kwa kummukiya. ");
INSERT INTO mgw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa aganiage Baisilaili aine bapekwipwa panga Nnu'ngu' ammi'i li'nga kwakosopolya, lakini bembe baakwipwili. ");
INSERT INTO mgw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pammalau' yake Musa ngaakolya Baisilaili abi'li' kabayu'mana, ngapaya kwakenga kwa kwabakia, ‘Mwenga mwabandu, ngita mwengaye mwalongo, mboni mupala lumiyana?’ ");
INSERT INTO mgw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lakini yu'lu' ywammonelage nnyine, ngannokolya Musa pambwega kabaya, ‘Nyai ywakubi'i ube wannyi'mi'li'ki au nkengeli witu? ");
INSERT INTO mgw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Buli upala kunibulaga kati mwaummulige yu'lu' Mmisili liso?’ ");
INSERT INTO mgw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa paagayu'wine malongelo go, ngatilya Midiani, kwaatami kati nng'eni naywembe ngapata bana abi'li'. ");
INSERT INTO mgw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Bai, bu'ka pa myaka alubaini pi'ta, malaika ywa Nnu'ngu' ngaampitya Musa mulubele papipi na kitu'mbi' sa ku Sinai, pakiwi'mbi' sasaabile kakiaka mwoto. ");
INSERT INTO mgw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa paalibweni likowe lyo aatisangala muno, naywembe paaegeli papipi li'nga alinguli wiso, ngayu'wa lilobe lya Bwana kalibaya, ");
INSERT INTO mgw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nenga ngana Nnu'ngu' ywa api'ndo bako Bulaimu, Isaki na Yakobi.’ Musa ngalendema kwa bwoga na akombwili yendelya lingulya. ");
INSERT INTO mgw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Apo Bwana ngammakia, ‘Uule ilatu yako kwa mwanjaa apo poyi'mi pandu papeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kakape nigabweni mateso ga bandu bangu' akwo Misili. Niyu'wine ili'lo yabe nane nganiulwike li'nga kwakosopolya. Kwa nyo lelo wise, nanenga nilu'a kutuma ku Misili.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ayu' nga Musa ywabankani kababaya, ‘Nyai ywakubi'i ube wannyi'mi'li'ki na nkengeli witu?’ Aabile ntumilwa na Nnu'ngu' mwene panga nnyi'mi'li'ki na nkosopoli wabe, kwa ndi'la ya yu'lu' malaika ywaampiti pakiwi'mbi' sakiakage mwoto. ");
INSERT INTO mgw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ywembe ngaywaalongwiye Baisilaili bu'ka Misili kapanga mangelongelo na myanju munni'ma wo, mubaali ya Shamu, na mulubele kwa myaka alubaini. ");
INSERT INTO mgw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ayu' nga yu'lu' Musa ywaabakiye Baisilaili, ‘Nnu'ngu' alu'a kunsaulyanga nnondoli ywalandana nanenga bu'ka mulukolo lwinu.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ata pabaakongolekine ku'lu' kulubele, Musa ngaywaabile pamope nabo au'ku' bitu na yu'lu' malaika ywaalongei nakwe pakitu'mbi' sa Sinai. Ngaywaapeyi'lwe galu' mayi'gi'yo ga ukoto, li'nga atupei twenga. ");
INSERT INTO mgw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakini au'ku' bitu baakani kunnyu'wa Musa, ngabannokolya pambwega no minyikiya buya kai' Misili. ");
INSERT INTO mgw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ngabammakia kai' Aluni, ‘Ututengenesi kinnu'ngu' babaalu'a tulongoya mundi'la, kwa mwanjaa tutangiteli gagampatike aywo Musa ywaatulongwiye bu'ka Misili.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Apo ngabaitengenesya nnu'ngu' ywa likinda lya ng'ombe, ngabalibi'ki'lya na kulipulaikya kwa mwanjaa lyaai lyengo lya maboko gabe bene. ");
INSERT INTO mgw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bai, Nnu'ngu' ngatama kuutalu nabo, na kwaleka bakilikiti ndondwa ya kumaunde, kati mwaiandikilwe mukitabu sa alondoli ba Nnu'ngu', ‘Mwenga mwabandu Baisilaili, buli nenga lili ywamunipikiage salaka ya inyama kwa myaka alubaini ku'lu' kulubele? ");
INSERT INTO mgw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwenga mwakitweti kimanda sa nnu'ngu' Moloki, na inyago ya ndondwa ya nnu'ngu' winu Lefani. Inyago yamwaipangile ngayamwikilikitya. Kwa nyo nilu'a kwabi'ngya kuutalu pita Babeli.’ ");
INSERT INTO mgw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ku'lu' kulubele api'ndo bitu baabile na ema ya lilagano nkati yake. Na yatengenesilwe kati Nnu'ngu' mwannagi Musa kwa galu' gaalayilwe. ");
INSERT INTO mgw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bu'kapo kiu'ku'lu' bitu baapokangine yi'lu' ema bene na bene mpaka nsimu wa Yoshua, pabaautweti wu'lu' nni'ma bu'ka kwa bandu ba mili'ma ya bandu babaabi'ngilwe na Nnu'ngu' nnu'ngi' yabe. Apo lyaatami mpaka nsimu wa Daudi. ");
INSERT INTO mgw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi ywaapendilwe na Nnu'ngu', nembe annu'bite Nnu'ngu' ywa Yakobi ansengi po tama. ");
INSERT INTO mgw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Selemani ngaywansengile nyumba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ata nyo Nnu'ngu' Nku'lu' atamali munyumba yaisengilwe kwa maboko ga bandu. Kati nnondoli ywa Nnu'ngu' mwaabaite, ");
INSERT INTO mgw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kunani nga kiti'gu' sangu' sa lenji, na dunia nga pandu po bi'kya magu'lu' gangu'. Mwalu'a nisengya nyumba kati yaku'? Au pandu pangu' po pu'mu'lya pabaa kwaku'? ");
INSERT INTO mgw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Buli maboko gangu' gaumbikeli ili'be ayi' yoti?’ ");
INSERT INTO mgw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mwenga mwabandu anonopau! Myoyo na makutu ginu gai kati bandu bangali Ayahudi. Mwenga kati kiu'ku'lu' binu! Masu'ba goti muntaukya Loo Mpeleteu, kati mwabaapangite au'ku' binu. ");
INSERT INTO mgw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ywaku' kati ya alondoli ba Nnu'ngu', ywangateselwa na kiu'ku'lu' binu? Baatikwabulaga balu' babalondwage kwai'mbu' abali yoisa kwa Mwene Aki. Nambi'yambi' munsongile na kummulaga. ");
INSERT INTO mgw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwenga ngamwamupokile salya yailetilwe kasinu kwo pi'tya malaika, lakini mwaaiyu'wineli.” ");
INSERT INTO mgw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Balu' api'ndo ba mukitamo, pabagayu'wine makowe go, baatiusika muno na kunnyagya mino Sitefano kwa nyongo. ");
INSERT INTO mgw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini Sitefano abi atwi'li'yilwe Loo Mpeleteu, ngalingulya kunani ngaubona utukupu wa Nnu'ngu' na Yesu kayi'ma kummalyo ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ngabaya, “Mulinge! Nibona kunani kuyu'gwike na Mwana wa Mundu kayi'ma kummalyo ga Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lakini balu' ba mukitamo ngabaiba makutu gabe no panga ndu'ti kwa makakala na kunnyingilya kwa pamope. ");
INSERT INTO mgw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ngabampiya panja ya kilambo no tumbwa kunku'mbwa maliwe li'nga bammulage. Balu' babanku'mbwage ngabampeya makoti gabe mwinsembe yumo ywakemelwage Sauli akamuli. ");
INSERT INTO mgw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pabaabi kabanku'mbwa maliwe Sitefano andelu'ba, “Bwana Yesu, wipoki loo yangu'.” ");
INSERT INTO mgw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bu'kapo ngakilikita li'la kwa lilobe liku'lu', “Bwana kanewabalangili sambi yi'!” Bu'ka po baya go, ngayomoka. ");
INSERT INTO mgw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naywembe Sauli aayi'ki'tile panga Sitefano apalikwa bulagilwa. Lisu'ba li'li'lu'li'lu' aumini ba ku Yelusalemu ngabatumbwa pata mateso maku'lu', aumini boti ngababaganika mu Yudea na Samalia ila atumilwe bai. ");
INSERT INTO mgw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bandu babankilikitya Nnu'ngu' ngabansika Sitefano na kunni'lya muno. ");
INSERT INTO mgw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lakini Sauli aayendeli kwaalabiya aumini, ngayingya nyumba kwa nyumba na kwaboywa aumini, alwawa na analu'me, kwayi'ya muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kwa nyo balu' babaabaganike baayi'i pano na palu' ala liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Naywembe Pilipi ngayenda mukilambo kiku'lu' sa Samalia kwaalya abali ya Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bandu pabannyu'wine Pilipi na kwibona myanju yaaipangite, ngabampi'kania wiso ku'no kababinia limo kwa galu' gaagabaite. ");
INSERT INTO mgw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kwa mwanjaa moka gendekwabu'ka bandu baingi ku'no kagapanga ndu'ti, na bambone babaatombolwike na itewe ngabatepulilwa. ");
INSERT INTO mgw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kwa nyo ngakubaa na pulaa ngu'lu' mukilambo so. ");
INSERT INTO mgw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kwaai na mundu yumo ywakemelwage Simoni, ywaatamage mukilambo si'si'lu'si'lu' bu'ka kwai'mbu', ywembe apangage makowe ga bwabi' na kwapanga bandu ba Samalia basangale, na aipunage panga ywembe mundu nku'lu', ");
INSERT INTO mgw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","bandu boti, api'ndo kwa anangu'ta, baatikumpi'kania kababaya, “Mundu yu' nga galu' makakala ga Nnu'ngu' gagatanganikwe kati, ‘Uweso Nku'lu'.’” ");
INSERT INTO mgw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ngabanki'ngama, kwa mwanjaa yapite myaka kabansangala kwa bwabi' wake. ");
INSERT INTO mgw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini bandu pabaamwu'bi'li Pilipi paalage abali inannoga ya Ukulungwa wa Nnu'ngu' na lina lya Yesu Kilisitu, ngababatisilwa, analu'me kwa alwawa. ");
INSERT INTO mgw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Naywembe Simoni ngau'bi'lya no batisilwa. Nganki'ngama Pilipi kila pandu, kasangala myanju na mangelongelo maku'lu' gaagabweni. ");
INSERT INTO mgw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Balu' atumilwe babaabile Yelusalemu pabayu'wine panga bandu ba Samalia balipokile Liyi'gi'yo lya Nnu'ngu', ngabaatuma Petili na Yoani bayende kwo. ");
INSERT INTO mgw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pabaaikite Samalia ngabaalu'bya aumini bapate kumpokya Loo Mpeleteu, ");
INSERT INTO mgw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kwa mwanjaa Loo Mpeleteu aai anakwaulukyali ata yumo, ila baatibatisilwe kwa lina lya Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bai, Petili na Yoani ngabaabi'kya maboko balu' babaabatisilwe nabembe ngabampokya Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni paabweni bandu kabampokya Loo Mpeleteu kwo bi'ki'lwa moko ga atumilwe, ngapaya kwapeya mbanje kabaya, ");
INSERT INTO mgw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nanenga munipei uweso kati wo, li'nga kila mundu ywanaalu'a kummi'kya maboko gangu', apate pokya Loo Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petili ngayangwa, “Mbanje yako ilangamiswe pamope na we, kwa mwanjaa ugania pi'ma upo ya Nnu'ngu' kwa mbanje! ");
INSERT INTO mgw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wenga ntu'pu' aki yoyoti mulyengo li'no, kwa mwanjaa mwoyo wako ubile na ulau nnu'ngi' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bai, ugalambuke bu'ka mumasambi na unnu'be Bwana naywembe aakombwa kukusamya awo ulau waubile nawo mumwoyo wako. ");
INSERT INTO mgw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwa mwanjaa nibweni panga wenga ubi na bwigu na wantabilwe wa sambi.” ");
INSERT INTO mgw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Apo Simoni ngayangwa, “Munilu'bi kwa Bwana, li'nga ago gamugabaite gaakanekunipitya.” ");
INSERT INTO mgw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bu'ka pa Petili na Yoani piya ukong'ondeli wabe no ala mayi'gi'yo ga Bwana, ngababuya ku Yelusalemu. Pabaabi kababuya ngabaala abali inannoga ya Yesu muilambo yambone ya Samalia. ");
INSERT INTO mgw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaika ywa Bwana ngammakia Pilipi, “Uyende lwingo lwa kusi muyi'lu' ndi'la ya mulubele yaibu'kya Yelusalemu li'nga Gasa.” ");
INSERT INTO mgw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bai, Pilipi ngaibi'ka wiso no yabwa mwanja, paabile mundi'la ngakwembana na nng'wambende ywa Isiopia, ywaai mpi'ndo nku'lu' mwene utawala wa mabi'ko goti ga Kandake, Malikia wa Isiopia. Aywo nng'wambende aayi'i Yelusalemu li'nga kunkilikitya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Naywembe paabile mumwanja wo buya kaya, aai mummutuka wake kasoma kitabu sa nnondoli ywa Nnu'ngu' Isaya. ");
INSERT INTO mgw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Loo Mpeleteu ngammakia Pilipi, “Uyende ku'lu' kummutuka, ukatame papipi nawo li'nga waalongwane nawo.” ");
INSERT INTO mgw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipi ngaubutukya wu'lu' mmutuka, ngannyu'wa yu'lu' mundu kasoma kitabu sa Nnondoli ywa Nnu'ngu' Isaya. Pilipi ngannaluya, “Ugatangite buli ago gausoma?” ");
INSERT INTO mgw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yu'lu' nng'wambende ngabaya, “Nilu'atangabuli pangali mundu kuniawanikiya?” Bu'kapo ngankoka Pilipi li'nga au'bu'ke no tama pamope nakwe. ");
INSERT INTO mgw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na kipungu sa Maandiko Mapeleteu sasomage nga si'no, “Apelekilwe kati ngondolo ywayenda sinjilwa, kati mwana ngondolo mwatama liki nnu'ngi' yake ywembe ywakata manyoya. Kwa nyo ayu'gwili nkano wake. ");
INSERT INTO mgw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Aateisika no yimilwa aki yake, bwu'mi wake ubu'yilwe mudunia, kwa nyo ntu'pu' ywakombwa awana bu'kana na lubelekwo lwake.” ");
INSERT INTO mgw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yu'lu' nng'wambende ngannaluya Pilipi, “Sondesonde unibakiye, nnondoli ywa Nnu'ngu' yu' alongelya kwa abali yake mwene au abali ya mundu ywi'ngi'?” ");
INSERT INTO mgw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Bai, Pilipi ngatumbwa tumya pandu papalu'palu' pa Maandiko Mapeleteu, na kumwawanikiya abali inannoga ya Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pabaabi balo kabayendelya na mwanja, baaikite pandu pene masi', na aywo mpi'ndo ngabaya, “Pandu pano paina masi', buli kubile na kili'be sosoti sakilu'a nipanga kanenibatisilwe?” ");
INSERT INTO mgw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nng'wambende ngayi'mika wu'lu' mmutuka, ngabauluka mumasi' boti abi'li', Pilipi ngammatisa. ");
INSERT INTO mgw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pabaapitike mumasi', papalu'palu' Loo ywa Bwana ngammu'ya Pilipi, yu'lu' nng'wambende amwenili kai', lakini ngayendelya na mwanja wake kwo napusika muno. ");
INSERT INTO mgw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi aaimuki abile mukilambo sa Azoto. Bu'kapo ngapi'ta muilambo yoti kaala abali inannoga, mpaka paaikite mukilambo sa Kaisalia. ");
INSERT INTO mgw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pamasu'ba go Sauli aabile balo kayendelya yogoya bulaga banamasi' ba Bwana. Ngannyendelya Mpi'ndo Nku'lu' wa dini, ");
INSERT INTO mgw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ngalu'ba apeyelwe balua yailu'a kunnaya munyumba ya kunnu'ba Nnu'ngu' ya Kiyahudi ku'lu' Damasiko, li'nga mana aakwembite kwo alwawa au analu'me babaki'ngama Ndi'la Yo, aatabe na kwaleta ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Paabile balo mumwanja papipi no ika Damasiko, papalu'palu' bweya bu'ka kunani ngaummulikya mwoti. ");
INSERT INTO mgw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ngatu'la pai', ngayu'wa lilobe kalimmakia, “Sauli, Sauli! Mboni wendanitesa?” ");
INSERT INTO mgw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naywembe ngalaluya, “Wenga wanyai Bwana?” Li'lu' lilobe ngaliyangwa, “Nenga ngana Yesu ywaunitesa. ");
INSERT INTO mgw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lakini nambi'yambi' ukatuke uyingi mukilambo, na kwo waabakiyilwa saupalikwa panga.” ");
INSERT INTO mgw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Balu' bandu babaai mumwanja pamope na Sauli baatiyi'ma na baabile ntu'pu' lyo baya kwa mwanjaa baayu'wine lilobe, lakini baamwenili ywalongelage. ");
INSERT INTO mgw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli aatiyi'ma bu'ka palu' pai' na paapayite banjwa minyo gake, aakombwili kukibona kili'be sosoti. Bai ngabankamwa luboko na kunnongoya mpaka Damasiko. ");
INSERT INTO mgw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Naywembe kwa masu'ba gatatu aaloili, aalileli wala nywa kili'be sosoti. ");
INSERT INTO mgw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Akwo Damasiko kwaabile na mwanamasi' yumo lina lyake Anania. Bwana ngammakia mumakowe gayambi', “Anania!” Ngayangwa, “Nenga pano, Bwana.” ");
INSERT INTO mgw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bwana ngammakia, “Uyende musimbasimba yaikemelwa ‘Ntawaliya’ ukayingi nkati ya nyumba ya Yuda amo ukannokikiye mundu ywa mukilambo sa Taliso ywakemelwa Sauli. Wankolya kalu'ba, ");
INSERT INTO mgw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kwa mwanjaa endalu'ba na aamweni mumakowe gayambi' mundu ywakemelwage Anania kaisa na kummi'kya maboko kunnu'bya, li'nga apate lola kai'.” ");
INSERT INTO mgw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania ngayangwa, “Bwana niyu'wine bu'ka kwa bandu baingi abali yambone bu'kana na mundu yu' na maakau gake goti gaapangile bandu bako akwo ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naywembe aisi pano Damasiko abi na amuli bu'ka kwa api'ndo ba dini, li'nga aaboywe boti babatambwa lina lyako.” ");
INSERT INTO mgw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Bwana ngammakia Anania, “Uyende bai, kwa mwanjaa mundu yu' nitikunsawa li'nga kunitumikiya, na aale lina lyangu' kwa bandu bangali Ayahudi, akulungwa babe na kwa Isilaili. ");
INSERT INTO mgw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nanga namwene nilu'a kunnaya mwaapalikwa teselwa kwa kitumbu sangu'.” ");
INSERT INTO mgw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bai, Anania ngayenda yingya munyumba yaabile Sauli, ngammi'kya maboko panani yake na kummakia, “Wa Sauli, Bwana Yesu ywaakupiti mundi'la koisa ku'no, anitumike kasako li'nga upate lola kai' no twi'li'yi'lwa Loo Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Papalu'palu' ili'be yaibile kati makabanda ga omba ngagatu'mbu'ka bu'ka muminyo ga Sauli, ngapata lola kai'. Ngayi'ma no batisilwa. ");
INSERT INTO mgw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bu'kapo ngalya no pata makakala kai'. Sauli ngatama masu'ba nsi'si' pamope na banamasi' akwo Damasiko. ");
INSERT INTO mgw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bu'kapo aatumbwi ala mumayumba ga kunnu'ba Nnu'ngu' panga, “Yesu nga mwana wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bandu boti babannyu'wine Sauli ngabansangala no baya, “Mundu yu' kanga yu'yu'lu'yu'lu' ywaabulige balu' babaabile kabalu'ba kwa lina lya Yesu ku'lu' Yelusalemu? Kai' aaisi pano kabinia kwaboywa bandu ba na kwapeleka kwa api'ndo ba dini?” ");
INSERT INTO mgw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli aayendeli pata makakala mumaalo gake panga Yesu nga Kilisitu. Ayahudi ba ku Damasiko baatisengemwanika muno. ");
INSERT INTO mgw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bu'ka pa masu'ba gambone pi'ta, Ayahudi ngabapanga ndi'la ya kummulaga Sauli. ");
INSERT INTO mgw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini Sauli ngakwipwa makowe gababiniage. Ayahudi baabile kabali'ndi'la milyango yoti ya pakilambo so kilo na mutwekati pala bammulage. ");
INSERT INTO mgw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini lisu'ba limo kilo banamasi' bake ngabannyi'ya mukitu'ndu' na kumuuluya pi'tya palipoyo lya mukingu'mbi'. ");
INSERT INTO mgw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli paaikite Yelusalemu ngapaya lu'mbana na banamasi', lakini boti ngabannyogopa, kwa mwanjaa bammwu'bi'lili panga kakape naywembe aabile mwanamasi'. ");
INSERT INTO mgw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lakini Balanaba ngantola kumpeleka kwa balu' atumilwe, ngaawanikiya Sauli mwaamweni Bwana mundi'la na mwaalongei nakwe na mwaalike lina lya Yesu akwo Damasiko wangali bwoga. ");
INSERT INTO mgw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kwa nyo Sauli ngatama pamope nabo akwo ku Yelusalemu ku'no kaala liyi'gi'yo lya Bwana wangali bwoga. ");
INSERT INTO mgw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kai' aatilongela no taukana na Ayahudi babalongelage Kigiliki, lakini bembe baapayite kummulaga. ");
INSERT INTO mgw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Balu' aumini pabaakwipwile likowe lyo ngabantola Sauli kumpeleka Kaisalia, ngabannekekeya ayende Taliso. ");
INSERT INTO mgw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nsimu wo aumini ngababa na amani mu Yudea yoti, Galilaya na Samalia. Lyaatisengelwa no ku'la kwa kunkilikitya Bwana no yongekeyelwa bandu no yi'yi'lwa Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bai, Petili paabile mumwanja aapi'ti muilambo mbali'mbali', yenda kwatyangilya bandu ba Nnu'ngu' babatamage akwo Lida. ");
INSERT INTO mgw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Akwo ankwembite mundu yumo ywakemelwa Ainea, ywembe aai ntomboloka kwa myaka minane, aakombwili kakatuka pakindanda. ");
INSERT INTO mgw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bai, Petili ngammakia, “Ainea, Yesu Kilisitu endakutepwa, ukatuke utandike kindanda sako.” Popopo Ainea ngakatuka. ");
INSERT INTO mgw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bandu boti ba Lida na ba munkanya wa Saloni pabaamweni Ainea katyanga, ngabanng'alambukya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Akwo Yopa kwaabile na mwanamasi' yumo nnwawa lina lyake Tabita, kwa Kiyunani Dolikasi, lilombolya mbala. Aabile kapanga manogau na kwayangatiya aki'ba. ");
INSERT INTO mgw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nsimu wo ngaminya no waa. Bandu ngabaugu'lwa wu'lu' ntwi na kuubi'ka musumba sa golopwa. ");
INSERT INTO mgw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kwa mwanjaa kilambo sa Lida sabile papipi na kilambo sa Yopa, banamasi' pabaayu'wine panga Petili aabile ku'lu', ngabaatuma bandu abi'li' bakammakie, “Sonde li'li'li', wise ku'no kasitu kiyu'ngu'ya.” ");
INSERT INTO mgw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kwa nyo Petili ngayenda nabo, naywembe paaikite, ngabampeleka mpaka munngati mwabaugonjike wu'lu' ntwi. Alwawa awi'li'ka baingi, baanti'li'tike Petili ku'no kabali'la no laya makoti na magu'bo gaasonile Dolikasi paabile nkoti. ");
INSERT INTO mgw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petili ngaapiya panja bandu boti, bu'kapo ngakilikita lu'ba. Ngaugalambukya wu'lu' ntwi ngabaya, “Tabita, ukatuke.” Ngabanjwa minyo gake na paamweni Petili, ngatama. ");
INSERT INTO mgw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petili ngannyangatiya kunkatuya kwa kunkamwa luboko, apo ngaakema balu' aumini na balu' awi'li'kwa babaabile nkati yabe, na kwakamukiya ai nkoti. ");
INSERT INTO mgw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Abali yo ngaitanganikwa pandu poti pa Yopa, na bandu baingi ngabammu'bi'lya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petili aatami Yopa kwa masu'ba maingi kwa mundu yumo ntengenesi ywa maki'ngo, ywakemelwage Simoni. ");
INSERT INTO mgw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwaai na mundu yumo ywangali Nnyahudi akwo ku Kaisalia ywakemelwage Koloneli mpi'ndo ywa kipi'nga simo sa yesi sakikemelwa “Kipi'nga sa Italia.” ");
INSERT INTO mgw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aai mundu ywabiniage kunkilikitya Nnu'ngu' ywembe na alongo bake boti. Apangage gambone kwayangatiya aki'ba ba Kiyahudi na abi kasali kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kayika saa tisa pipi na kitamwiyo, aamweni mpu'la mumakowe gayambi' malaika ywa Nnu'ngu' kayingya nnyumba na kummakia, “Koloneli!” ");
INSERT INTO mgw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koloneli ammu'nju'li minyo aywo malaika kwo yogopa ngammakia, “Kubile na ki'li' wa Mukoo?” Aywo malaika ngammakia, “Nnu'ngu' apokile sala na salaka yako kwa aki'ba wala akulibalyali. ");
INSERT INTO mgw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bai, nambi'yambi', watume bandu kukilambo sa Yopa bakankeme mundu yumo ywakemelwa Simoni, kwa lina li'ngi' Petili. ");
INSERT INTO mgw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ywembe nng'eni ywa mundu yumo lina lyake Simoni, ywatengenesa maki'ngo na nyumba yake ibile kumbwani.” ");
INSERT INTO mgw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aywo malaika ywaalongei go paabu'i, Koloneli aakemite atumisi abi'li' bannyumba babau'bi'li'ka na yumo ywa asikali bake babankilikitya Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","na payomwi kwaawanikia makowe goti ngaatuma yenda Yopa. ");
INSERT INTO mgw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pammalau' yake, abo bandu atatu babi balo mumwanja kabaegelya ika Yopa, Petili au'bwike pamwagala wa golopwa muntwekati li'nga sali. ");
INSERT INTO mgw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Amminyike njala ngatamania pata kilyo. Kilyo pakibi'ki'lwage wiso aagabweni makowe gayambi'. ");
INSERT INTO mgw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Aakubweni kunani kuyu'gu'likwe na kili'be kati suka ngu'lu' kaiuluyilwa pai' ikamulilwe mumipembo yake nsese. ");
INSERT INTO mgw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkati ya suka yo kwaai na kila lukolo lwa inyama, bene magu'lu nsese, mang'ambo na iyuni. ");
INSERT INTO mgw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngayu'wa lilobe kalimmakia, “Petili, ukatuke ui'se, ulye!” ");
INSERT INTO mgw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petili ngayangwa, “Lili Bwana, nenga napayali katu kili'be sosoti sakikanilwa na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Li'lu' lilobe ngaliyu'wanika kai' kalimmakia, “Kenewikeme mwilo ili'be yaipeleteyilwe na Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Likowe li'no lyapangike mala itatu, bu'kapo yi'lu' suka ngaiki'li'bu'kya kunani. ");
INSERT INTO mgw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petili paabile balo kasangala kikomeko sa makowe gaagabweni, balu' bandu babaatumilwe na Koloneli, pabaitangite nyumba ya Simoni, baaikite paniango nniango nku'lu' wa panja. ");
INSERT INTO mgw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ngabapanga u'li no laluya, “Buli kubile na nng'eni mono ywakemelwa Simoni Petili?” ");
INSERT INTO mgw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petili aabile balo kagagania galu' makowe gayambi', apo Loo Mpeleteu ngammakia, “Pi'kania! Kubile na bandu atatu pano bendakupala. ");
INSERT INTO mgw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Weli kiyu'ngu'ya wala kaneuyogope longwana nabo kwa mwanjaa natumike nenga.” ");
INSERT INTO mgw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bai, Petili ngaelya ngaabakia abo bandu, “Nenga nga ywamunipala. Kwa mwanjaa ki'li' mwisile?” ");
INSERT INTO mgw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bembe ngabannyangwa, “Asikali mpi'ndo Koloneli ywembe mundu nnogau ywankilikitya Nnu'ngu', mwene isima nnu'ngi' ya Ayahudi boti, atetutuma. Abakiyilwe na malaika mpeleteu akukemi kasake li'nga api'kani sopala kummakia.” ");
INSERT INTO mgw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petili aakemi nnyumba ngaapeya pandu po gonja kilo si'lu'. Pammalau' yake Petili aatumbwi mwanja pamope nabo, na aumini bi'ngi' ba Yopa baatilongwana nakwe. ");
INSERT INTO mgw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lisu'ba lyenebi'li' lyake baaikite Kaisalia. Koloneli, alongo na mambwiga bake ba pamwoyo baai kabanni'nda Petili. ");
INSERT INTO mgw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petili paabile kayingya, Koloneli aapitike panja kumpokya, ngakilikita nnu'ngi' yake no yinama kwa kunkilikitya. ");
INSERT INTO mgw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lakini Petili aatikuntu'ndu'bi'ya Koloneli kabaya, “Yi'ma, kwa mwanjaa nenga na mundu bai.” ");
INSERT INTO mgw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petili aayendeli longela na Koloneli ku'no kabayingya munyumba mwabaakwembite bandu baingi bakongolekine. ");
INSERT INTO mgw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petili ngaabakia, “Mwenga mwabene mutangite panga Nnyahudi ywoywoti akanikiyilwe na salya ya dini yake tama pamope wala tyangilyana na bandu bangali Ayahudi. Lakini Nnu'ngu' anibakiye kanening'aniye panga kubile na mundu ywoywoti ywakanilwa na Nnu'ngu' au nsapu. ");
INSERT INTO mgw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa mwanjaa nyo, pamungemite niisi wangali kana, bai ninnaluyanga mwanjaa ki'li' mungemite?” ");
INSERT INTO mgw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koloneli ngabaya, “Masu'ba gatatu gagapite saa kati yi'no, saa tisa pipi na kitamwiyo naabile kanisali kasangu'. Niimukya mundu ywaweti ngu'bo inammelemetya aayi'mi nnu'ngi' yangu', ");
INSERT INTO mgw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ngabaya, ‘Koloneli! Sala yako na salaka yako kwa aki'ba iyi'ki'tilwe na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Untume mundu Yopa akankeme mundu yumo ywakemelwa Simoni, kwa lina li'ngi' Petili. Ai munyumba ya Simoni ywatengenesa maki'ngo papipi na baali.’ ");
INSERT INTO mgw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kwa nyo nakulagi uyu'mbi'ti'ke isa, nawenga unogiye. Nambi'yambi' twenga tubile nnu'ngi' ya Nnu'ngu' pi'kania sosoti saalu'a kukuamulisa Bwana longela.” ");
INSERT INTO mgw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Apo Petili ngabaya, “Nambi'yambi' nitangite panga kakape Nnu'ngu' abawali. ");
INSERT INTO mgw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mundu ywa nni'ma wowoti ywankilikitya Nnu'ngu' no panga gagabile manogau endayi'ki'ti'lwa. ");
INSERT INTO mgw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Li'no nga li'lu' liyi'gi'yo lya Nnu'ngu' lyaapeleki Baisilaili, kaalya abali inannoga yaileta amani kwa ndi'la ya Yesu Kilisitu nga Bwana wa boti. ");
INSERT INTO mgw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwenga mutangite likowe lyalyaapitike munni'ma woti wa Ayahudi tumbulya ku Galilaya bu'ka pa wu'lu' ubatiso waalage Yoani. ");
INSERT INTO mgw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nnu'ngu' ansawi Yesu wa ku Nasaleti kwa lyengo lyake kwa kummiminikia Loo Mpeleteu na makakala. Nnu'ngu' abi pamope nakwe, ywembe aayi'i ku'no na akwo kapanga ganannoga na kwatepwa boti babaabonelilwe na Ibilisi. ");
INSERT INTO mgw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Twenga nga twaakong'ondeli ba makowe goti gagapangilwe munni'ma wa Ayahudi na ku Yelusalemu. Baatikummulaga kwa kummamba munsalaba. ");
INSERT INTO mgw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lakini Nnu'ngu' aatikunnyu'ya lisu'ba lyenetatu, ngannaya kwa bandu, ");
INSERT INTO mgw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kwa bandu boti lili, ila kwa balu' baasawile Nnu'ngu' babe akong'ondeli bake, yani twenga twatulile no nywa pamope nakwe bu'ka po yu'ka kwake kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atuamulise tuale kwa bandu boti no kong'ondya panga ywembe nga ywasaulilwe na Nnu'ngu' abe nsenuli wa akoti na babawile. ");
INSERT INTO mgw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Alondoli boti ba Nnu'ngu' baatikong'ondelya panga kila mundu ywamwu'bi'lya aasamilwa masambi gake goti kwa lina lyake.” ");
INSERT INTO mgw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petili paabile balo kalongela mayi'gi'yo go, Loo Mpeleteu aatikwaulukya boti babaabile kabapi'kania makowe go. ");
INSERT INTO mgw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Balu' Ayahudi aumini babaaisi pamope na Petili bu'ka Yopa baatisangala panga Nnu'ngu' aamiminikie Loo Mpeleteu ata bandu bangali Ayahudi, ");
INSERT INTO mgw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","kwa mwanjaa baabayu'wine kabalongela kwa luga yayambi' kabankwi'ya Nnu'ngu'. Apo Petili ngabaya, ");
INSERT INTO mgw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bandu ba bampoki Loo Mpeleteu kati twenga twabene mwatwaampokile. Buli, kubile na ywoywoti ywalu'a kombwa kwakanikiya kanebabatisilwe kwa masi'?” ");
INSERT INTO mgw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bai, ngaamulisa babatisilwe kwa lina lya Yesu Kilisitu. Bu'kapo ngabannu'ba atame nabo kwa masu'ba masene. ");
INSERT INTO mgw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Atumilwe na alongo aumini ku'lu' ku Yudea baayu'wine panga bandu bangali Ayahudi baai kabalipokya liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bai, Petili paaki'li'bwike ku Yelusalemu, balu' Ayahudi aumini babaapendi bandu bangali Ayahudi bainilwe li'nga babe Ayahudi, bammi'ki lukoolo kababaya, ");
INSERT INTO mgw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Wenga uyi'i tama na bandu bangainilwa na ata ulile nabo nkungu gumo!” ");
INSERT INTO mgw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Apo Petili ngaawanikia makowe goti gagapangilwe kwa kindonda. ");
INSERT INTO mgw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lisu'ba limo panabile kanisali kukilambo sa Yopa naagabweni makowe gayambi' kili'be kati suka ngu'lu' kaiuluyilwa pai' bu'ka kunani, ikamulilwe mipembo yake nsese, yabi'kilwe mbwega yangu'. ");
INSERT INTO mgw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Natilingia nkati nganiibona inyama yene magu'lu' nsese, inyama ya mmwitu, mang'ambo, na iyuni. ");
INSERT INTO mgw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Bu'kapo nganiyu'wa lilobe kalinibakia, ‘Petili, ukatuke ui'se, ulye.’ ");
INSERT INTO mgw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lakini nenga nganibaya, ‘Lili ata pasene Bwana, kwa mwanjaa sosoti sakikanilwa na Nnu'ngu' kinayingyali katu munkano wangu'.’ ");
INSERT INTO mgw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Li'lu' lilobe ngaliyu'wanika kai' bu'ka kunani, ‘Kanewikeme mwilo ili'be yaipeletiye Nnu'ngu'.’ ");
INSERT INTO mgw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Likowe lyo lyapangilwe mala itatu, na kuundi'la yoti yaki'li'bu'yilwe kunani. ");
INSERT INTO mgw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Popopo bandu atatu babaatumilwe kasangu' bu'ka ku Kaisalia, baaikite pansengo panitamage. ");
INSERT INTO mgw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Loo aanibakie niyende pamope nabo pangali yogopa. Bano alongo aumini sita baalongwaniye nanenga yenda ku Kaisalia na kwo twayingi pansengo wa Koloneli. ");
INSERT INTO mgw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ywembe atuawanikiye mwaamweni malaika ywayi'mi nnyumba yake na kummakia, ‘Untume mundu Yopa akankeme mundu yumo ywakemelwage Simoni, kwa lina li'ngi' Petili. ");
INSERT INTO mgw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ywembe alu'a kubakia mayi'gi'yo gagaakupanga wenga na alongo bako boti mukosopolelwe.’ ");
INSERT INTO mgw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na panaatumbwi longela bai, Loo Mpeleteu aatikwaulukya kati mwaatuuluki twenga patumbu. ");
INSERT INTO mgw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Apo naaku'mbu'ki galu' mayi'gi'yo Bwana gaalongei, ‘Yoani aabatisike kwa masi', lakini mwenga mwalu'a batisilwa kwa Loo Mpeleteu.’ ");
INSERT INTO mgw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bai, manaitei Nnu'ngu' aapei kai' bandu bangali Ayahudi upo yi'yi'lu'yi'lu' yaatupei twenga patwaamwu'bi'li Bwana Yesu Kilisitu, buli, nenga nanyai ata nipaye kuntaukya Nnu'ngu'?” ");
INSERT INTO mgw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pabagayu'wine go, baulei ntau na bankwi'yite Nnu'ngu' kababaya, “Nnu'ngu' apei bandu bangali Ayahudi uweso wa kunng'alambukya bapate ukoti!” ");
INSERT INTO mgw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bu'kana na ngu'su'mbu' yayaapitike paabulagilwe Sitefano, aumini baatisengemwanika. Bi'ngi' baayi'i mpaka Foinike, Kuplo na Antiokia kabaala li'lu' liyi'gi'yo kwa Ayahudi bai. ");
INSERT INTO mgw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini aumini bi'ngi' bababu'kite Kuplo na Kulene baayi'i Antiokia kabaala abali inannoga ya Bwana Yesu kwa bandu bangali Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nnu'ngu' aatikwayangatiya na bandu baingi baatiu'bi'lya na kunng'alambukya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abali ya likowe lyo yayu'wanike kwa balu' aumini ba ku Yelusalemu. Kwa nyo ngabantuma Balanaba ayende Antiokia. ");
INSERT INTO mgw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Paaikite kwo na kummona Nnu'ngu' mwaapeile ngu'ngu' balu' bandu, aatipulaika na kwakong'ondelya boti batame muukakape kwa Bwana kwa myoyo yabe yoti. ");
INSERT INTO mgw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balanaba aai mundu nnogau ywatwi'lile Loo Mpeleteu na imani, kwa nyo lipi'nga liku'lu' lya bandu lyanng'alambuki Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bu'kapo Balanaba aayi'i kilambo sa Taliso kumpala Sauli. ");
INSERT INTO mgw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paampatike, annetike Antiokia. Nabembe boti abi'li' bakwembanage na balu' aumini kwa mwaka woti kabayi'gana lipi'nga liku'lu' lya bandu. Akwo Antiokia nga kwabaatumbwi banamasi' kemelwa “Akilisitu”. ");
INSERT INTO mgw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nsimu wowowo, alondoli ba Nnu'ngu' baeleli ku Antiokia bu'ka ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bai, yumo ywabe ywakemelwa Agabo aatiyi'ma na kwa uweso wa Loo Mpeleteu ngalondwa panga kwalu'a baa njala ngu'lu' munni'ma woti. Njala yo yapitike nsimu wa utawala wa Klaudio. ");
INSERT INTO mgw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Balu' banamasi' ngabaamwa panga kila mundu yumo apeleke kili'be bu'kana na uweso wake li'nga kwayangatiya balu' alongo aumini babaabile kabatama ku Yudea. ");
INSERT INTO mgw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bai, ngabapanga nyo na kwapeya Balanaba na Sauli mbanje yo baikiye kwa api'ndo ba kanisa lya Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pamasu'ba galu', nkulungwa Helode aatumbwi kwatesa aumini bi'ngi' babe. ");
INSERT INTO mgw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Aamulise Yakobi nnunawe Yoani abulagilwe kwa lipanga. ");
INSERT INTO mgw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Paabweni panga kyendo so satikwapulaisa Ayahudi, ngammoywa kai' Petili. Aso saapangilwe nsimu wa si'li'ku'si'li'ku' ya makati gangalu'la yaapangilwe na Ayahudi yaikemelwage Pasika. ");
INSERT INTO mgw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bu'ka po boyolwa, Petili aabi'kilwe munyumba ya atabilwe pai' ya uli'nda wa ipi'nga nsese ya asikali nsese nsese. Helode aapalike ampiye pabandu bu'ka pa si'li'ku'si'li'ku' ya Pasika li'nga asenulwe. ");
INSERT INTO mgw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bai, Petili paabile muutabilwe, aumini baai kabannu'bya kwa Nnu'ngu' kwa mwoyo wangali totokelwa. ");
INSERT INTO mgw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kilo so yumukya lisu'ba li'lu' lya Helode kumpiya Petili li'nga senulwa, Petili aabile agonjike pakatikati ya asikali abi'li'. Aai atabilwe pingwi ibi'li' na ali'ndi'li baai kabali'ndi'la niango wa nyumba ya atabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Imukya, malaika wa Bwana aayi'mi papipi nakwe na bweya waatimulika musi'lu' sumba sa atabilwe. Malaika ngaantikatika mumbau kunnyumuya kabaya, “Ukatuke kiyu'ngu'ya!” Na yi'lu' pingwi yabantabike mmoko kaiti'kwanika no tu'mbu'kya pai'. ");
INSERT INTO mgw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaika ngammakia, “Witabe lunga lwako, uwale ilatu yako.” Ngapanga nyo. Bu'kapo aywo malaika ngammakia, “Uwale nganju yako, ungi'ngame.” ");
INSERT INTO mgw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petili nganki'ngama panja, lakini aatangiteli kati ago gagapangilwe na aywo malaika gaai ga kakape, akitage alota maloto. ");
INSERT INTO mgw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baapite kili'ndi'lo sa kumbito na senebi'li', bu'kapo ngabaika paniango wa kyu'ma woyingilya pakilambo. Awo niango wayu'wike wene nabembe ngabapita panja. Ngabatyanga mundi'la yimo, kwa kiimuimu yu'lu' malaika nganneka Petili kisake. ");
INSERT INTO mgw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Apo Petili ngapakwipwa gagapitike ngabaya, “Nambi'yambi' nitangite panga kakape Bwana antumike malaika wake anikosopoli mmoko ga Helode na bu'ka mumakowe galu' goti bandu ba Isilaili gabalolelage.” ");
INSERT INTO mgw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Paagakwipwi go aayi'i ntawalia mpaka kasake Malia mau' bake Yoani Maluko. Amo baai bandu baingi bakongolekine kabasali. ");
INSERT INTO mgw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petili aapangite u'li paniango wa panja na ntumisi yumo mwi'nja ywakemelwa Loda, aayi'i paniango yi'ki'ti'a. ");
INSERT INTO mgw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aywo mwi'nja paakwipwi panga lilobe lya Petili ngapulaika muno ata paali po kuuyu'wa gu'lu' niango aabutuki nnyumba na kwabakia panga Petili ayi'mi panja paniango. ");
INSERT INTO mgw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ngabammakia yu'lu' mwi'nja, “Wina lilalu'!” Lakini ywembe ngakong'ondelya panga yai kakape. Nabembe ngabammakia, “Aywo malaika wake.” ");
INSERT INTO mgw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petili aai kayendelya panga u'li. Kuundi'la bayu'wi niango, pabaamweni ngabasangala. ");
INSERT INTO mgw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petili aalangi luboko batame liki, ngaawanikia Bwana mwampiyike munyumba ya atabilwe. Bu'kapo ngaabakia, “Bapiye abali ya likowe lyo kwa Yakobi na balu' alongo aumini bi'ngi'.” Bu'kapo ngayenda pandu pi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakusile malango ga balu' asikali gaatiyelenganika kwa galu' gagampatike Petili. ");
INSERT INTO mgw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode aamulise upangilwe nsakata lakini baakombwili kumpata. Kwa nyo aamulise balu' asikali balaluyilwe no piya amuli babulagilwe. Bu'kapo ngabu'ka ku Yudea, yenda Kaisalia kwaatami. ");
INSERT INTO mgw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode aatikwausikya munomuno bandu ba Tilo na Sidoni. Kwa nyo bembe baampeleki asenga. Nabembe baakombwi kumpata wi'ti' Bulasito ayangatiye. Bulasito aai nnyi'mi'li'ki nku'lu' wa nyumba ya nkulungwa. Bu'kapo ngabannu'ba Helode baawane li'nga kube na amani, kwa mwanjaa nni'ma wabe wau'bi'li nni'ma wa nkulungwa kwa kilyo. ");
INSERT INTO mgw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lisu'ba limo lyalyasaulilwe Helode aawati ngu'bo ya kikulungwa no tama pakiti'gu' sake, ngaalya bandu. ");
INSERT INTO mgw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Balu' bandu baampangi ndu'ti ya si'li'ku'si'li'ku' kababaya, “Li'no, lilobe lya nnu'ngu', lya mundu lili.” ");
INSERT INTO mgw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Popopo malaika wa Bwana nganku'su'mbwa Helode kwa mwanjaa ampeili Nnu'ngu' ayo sipwa. Ngapata utamwe wa ntuli, ngawaa. ");
INSERT INTO mgw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Liyi'gi'yo lya Nnu'ngu' ngalibamba no ku'la. ");
INSERT INTO mgw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balanaba na Sauli pabayomwi lyengo lyabe ku Yelusalemu, baki'li'bu'ki ku Antiokia, ngabalongwana na Yoani Maluko. ");
INSERT INTO mgw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mukanisa lya Antiokia kwaabile na bandu bi'ngi' babaabile alondoli ba Nnu'ngu' na balimu, nkati yabe baabile Balanaba, Simoni ywakemelwage Mpili, Lukio wa Kulene, Manaeni ywaalelilwe pamope na nkulungwa Helode, na Sauli. ");
INSERT INTO mgw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pabaabile kabankilikitya Bwana no punga, Loo Mpeleteu ngabaya, “Munibauli Balanaba na Sauli kwa lyengo lyanaakemile.” ");
INSERT INTO mgw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bai, bu'ka po yendelya sali no punga ngabaabi'kya moko panani yabe li'nga Nnu'ngu' ayali, ngabaaleka bayende. ");
INSERT INTO mgw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bai, Balanaba na Sauli pabatumilwe na Loo Mpeleteu, batielya mpaka kukilambo sa Seleukia bu'ka kwo bau'bwike meli mpaka kisiwa sa Kuplo. ");
INSERT INTO mgw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pabaaikite kilambo sa Salami baalike liyi'gi'yo lya Nnu'ngu' mumayumba ga kunnu'ba Nnu'ngu' ga Ayahudi. Yoani Maluko aai nnyangatiyi wabe. ");
INSERT INTO mgw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pabaayomwi pi'ta pakatikati ya kisiwa mpaka Pafo ngabammona mundu yumo mwabi', ywaiku'pi'ki'yage panga nnondoli, aai Nnyahudi lina lyake Baliyesu, kwa Kigiliki Elima. ");
INSERT INTO mgw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ayu' aai pamope na Selgio Pauli, mpi'ndo ywa palu' pakisiwa ywaabile mundu mwene malango. Selgio Pauli aatikwakema Balanaba na Sauli li'nga aliyu'we liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini aywo mwabi' Elima, aapayike kwataukya li'nga aywo mpi'ndo ywa kisiwa akaneu'bi'lya liyi'gi'yo lya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bai, Sauli ywakemelwage Pauli, abile ntwi'lya Loo Mpeleteu aatikummu'nju'lya minyo aywo mwabi', ");
INSERT INTO mgw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kabaya, “Wankongi nku'lu' na wammu'su'bu'su'! Wenga nga wamwana wa Ibilisi na wandumu kwa kila kili'be sakibile kinogau! Ukotokali ata paya kugatindigana mayi'gi'yo ga Bwana gagagolokile. ");
INSERT INTO mgw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nambi'yambi' makakala ga Bwana galu'a kupwatya, ulu'a baa wambulibuli na wakombwali lola bweya wa lisu'ba kwa masu'ba.” Popopo kila kili'be ngakipanga kati lipundugulu na lubi'ndu' kwa ywembe, ngatumbwa yenda ku'no na kwo kampala mundu ywa kunkamwa luboko annongoye. ");
INSERT INTO mgw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yu'lu' mpi'ndo ywa kisiwa paagabweni go, ngau'bi'lya, kwa mwanjaa asangalage mayi'gano gaagayu'wine kwa Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bu'ka Pafo, Pauli na aine bau'bwike meli yenda mpaka Pelga ku Pamfilia, lakini Yoani Maluko aatikwaleka ngaki'li'bu'ka ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bembe baayendeli na mwanja bu'ka Pelga mpaka kilambo sa Antiokia Pisidia. Baayingi munyumba ya kunnu'ba Nnu'ngu' ya Ayahudi paliikite lisu'ba lya Sabato yabe, ngabatama. ");
INSERT INTO mgw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pabayomwi soma mayi'gi'yo bu'ka mukitabu sa salya ya Musa na maandiko ga alondoli ba Nnu'ngu', api'ndo ba yi'lu' nyumba ya kunnu'ba Nnu'ngu' bantumike mundu aalu'be panga, “Mwalongo, mana mubile na likowe lya kwabakia bandu li'nga kwasenga, mubaye.” ");
INSERT INTO mgw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bai, Pauli aatiyi'ma ngaapu'ngya luboko no baya, “Mwabandu ba Isilaili na mwaboti mwamunkilikitya Nnu'ngu', mupi'kaniange. ");
INSERT INTO mgw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nnu'ngu' ywa Isilaili aatikwasawa kiu'ku'lu' bitu babe nni'ma nku'lu' pabaabile kuugeni ku'lu' Misili. Ngaakosopolya kwo kwa uweso wake nku'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Atikwakomeya kwa myaka alubaini ku'lu' kulubele. ");
INSERT INTO mgw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Paagalangamise makabila saba ga nni'ma wa Kanani, ngaapeya abo bandu bake wu'lu' nni'ma ube mali yabe. ");
INSERT INTO mgw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Makowe aga goti gapangilwe nkati ya myaka 450. “Bu'kapo ngaapeya asenuli baalongoye mpaka nsimu wa nnondoli ywa Nnu'ngu' Samweli. ");
INSERT INTO mgw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Apo ngabalonga babe na nkulungwa, na Nnu'ngu' ngaapeya Sauli mwana ywa Kishi ywa kabila lya Benyamini abe nkulungwa wabe kwa myaka alubaini. ");
INSERT INTO mgw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bu'ka pa kummu'ya Sauli, Nnu'ngu' ansawi Daudi apange nkulungwa wabe. Nnu'ngu' abaike nyinya kwa Daudi, ‘Nikwipwi panga Daudi mwana wa Yese nga mundu ywayu'wangana na mwoyo wangu', mundu ywaalu'a panga galu' goti ganipala kugapanga.’ ");
INSERT INTO mgw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Bu'ka mulukolo lwake Daudi, Nnu'ngu' kati mwaalagile aletile bandu ba Isilaili nkomboli, nga Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Papipi no isa kwa Yesu, aalongoli wi'ti' Yoani kaala kwa bandu boti ba Isilaili panga bapalikwa banng'alambuki Nnu'ngu' kwa kwileka sambi no batisilwa. ");
INSERT INTO mgw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yoani paabile kayomolya lyengo lyake aabakiye bandu, ‘Munikema nenga nanyai? Nenga nga yu'lu' ywamunnolelali. Aywo aaisa bu'ka pangu' nenga, nanenga nipwaikali ata undwa ngoi ya ilatu yake.’ ");
INSERT INTO mgw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mwalongo, mwenga mwabana ba lukolo lwa Bulaimu, na bi'ngi' boti babankilikitya Nnu'ngu'! Mayi'gi'yo gano ga ukosopoli tuletilwe twenga. ");
INSERT INTO mgw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kwa mwanjaa benekaya ba ku Yelusalemu na api'ndo babe baatangiteli panga ywembe nkomboli wala mayi'gi'yo ga alondoli ba Nnu'ngu' gagasomelwa kila Sabato. Ata nyo, bagatimisike mayi'gi'yo ga alondoli ba Nnu'ngu' kwa kunsenwa Yesu kiwo. ");
INSERT INTO mgw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pamope no panga baamwenili na lyakau lyolyoti lyakumpanga abulagilwe, baannu'bite Pilato ansenwe kiwo. ");
INSERT INTO mgw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bu'ka po panga goti gagaandikilwe kwa ywembe, baatikumuluya bu'ka munsalaba, ngabammi'ka mulisiko. ");
INSERT INTO mgw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Nnu'ngu' aatikunnyu'ya bu'ka kuuwi'li. ");
INSERT INTO mgw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naywembe kwa masu'ba maingi aatikwapitya balu' babaalongwaniye nakwe bu'ka ku Galilaya mpaka ku Yelusalemu. Abo ngababile akong'ondeli bake kwa bandu ba Isilaili. ");
INSERT INTO mgw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na twenga tuisi pano kunnetyanga abali inannoga. Likowe li'lu' Nnu'ngu' lyaalagile kiu'ku'lu' bitu, ");
INSERT INTO mgw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nambi'yambi' ayomolile kwitu twenga twasu'ku'lu' babe kwa kunnyu'ya Yesu bu'ka kuuwi'li kati mwaiandikilwe mu Zabuli inebi'li', ‘Wenga nga Mwana wangu', nenga li'no niba natati' bako.’ ");
INSERT INTO mgw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Na kwa kunnyu'ya bu'ka kuuwi'li kaneabuye kai' kwo no bola, Nnu'ngu' aabaite nyinyo, ‘Nalu'a kupeya lilagyo lipeleteu na lya kakape lyanammakie Daudi.’ ");
INSERT INTO mgw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Kakape na mu Zabuli yi'ngi' abaya, ‘Wannekali Mpeleteu wako abole.’ ");
INSERT INTO mgw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Kwa mwanjaa Daudi aapangite mwapalage Nnu'ngu' nsimu wake, bu'kapo ngawaa no sikilwa papipi na kiu'ku'lu' bake, na yi'ga yake ngaibola. ");
INSERT INTO mgw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini yu'lu' ywayu'yilwe na Nnu'ngu' bu'ka kuuwi'li aboi lili. ");
INSERT INTO mgw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kwa nyo, mwalongo bangu', mutange panga kwa ndi'la ya ayu' Yesu, mayi'gi'yo go samilwa sambi gendaalilwa kwinu, ");
INSERT INTO mgw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","no panga kila mundu ywamwu'bi'lya Yesu endasamilwa masambi gake goti, likowe lyo lipelepangikali kwa ndi'la ya salya ya Musa. ");
INSERT INTO mgw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mwilinguli mwakanekugapata galu' gagalongelilwe na alondoli ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mupi'kani mwenga mwamunibebeya musangale mukalanganyike! Kwa mwanjaa kili'be sanikipanga nambi'yambi' nsimu winu mwakiu'bi'lyali ata manaitei mundu amwawanikiye.’” ");
INSERT INTO mgw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Balanaba pabaabile kabapita mu'lu' munyumba ya kunnu'ba Nnu'ngu', balu' bandu baatikwapembelelya baise kai' ku Sabato ya Ayahudi yaibandike sabalongeli muno makowe go. ");
INSERT INTO mgw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kitamo so pakiyomwike, Ayahudi baingi na bandu bangali Ayahudi babaabile mudini ya Kiyahudi, baaki'ngime Pauli na Balanaba. Abo atumilwe baatilongela nabo, na kwasenga li'nga bayendeli tama kwo u'bi'lya ngu'ngu' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabato ya Ayahudi yaibandike, bandu baingi mu'lu' mukilambo baaisi pi'kania liyi'gi'yo lya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lakini Ayahudi pabaalibweni lipi'nga lya bandu baabi'i bwigu, ngabatauka saalongei Pauli na kumpwi'wa. ");
INSERT INTO mgw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pauli na Balanaba baalongei kwo kangamala muno, kababaya, “Yaapalikwe wi'ti' liyi'gi'yo lya Nnu'ngu' limwikyange mwenga, lakini kwa mwanjaa mutelikana na kwiibona mupwaikali muukoti wangayomoka, bai, twendakunnekanga na kwayendelya bandu bangali Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwa mwanjaa Bwana atulagi nyinyo, ‘Nikubi'kite wenga ube wabweya kwa bandu bangali Ayahudi, li'nga waleti bandu ukosopoli mudunia yoti.’” ");
INSERT INTO mgw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bandu bangali Ayahudi pabaayu'wine likowe lyo baatipulaika, ngabalikwi'ya liyi'gi'yo lya Nnu'ngu' na balu' babaasaulilwe kuupata ukoto wangayomoka, ngabau'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Liyi'gi'yo lya Bwana lyaatibamba kila pandu munni'ma wu'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ayahudi baatikwasopya api'ndo ba kilambo na alwawa matayili babankilikitya Nnu'ngu'. Ngapabatumbwa kwapeya ngu'su'mbu' Pauli na Balanaba, ngabaabi'nga bu'ka munni'ma wabe. ");
INSERT INTO mgw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bai, atumilwe ngabakung'unda lyu'ku'mbi' mumagu'lu' gabe na kwaleka kati mwabaabile, bu'kapo ngabayenda Ikonio. ");
INSERT INTO mgw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na abo banamasi' baai atwi'lya pulaa na Loo Mpeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku'lu' Ikonio, Pauli na Balanaba baayi'i munyumba ya kunnu'ba Nnu'ngu' ya Ayahudi, ngabalongela kati mwabaalongei ku Antiokia na ata lipi'nga liku'lu' lya Ayahudi na Agiliki ngabau'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lakini Ayahudi babaakani u'bi'lya baatikwasopa bandu bangali Ayahudi, li'nga kwayu'maniya alongo aumini. ");
INSERT INTO mgw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauli na Balanaba baayendeli tama kwo kwa masu'ba gambone kabalongela abali ya Bwana kwo kangamala. Naywembe Bwana ngakong'ondelya ukakape wa likowe lyabalilongei lya ngu'ngu' ya Nnu'ngu', na aapei uweso wopanga mangelongelo. ");
INSERT INTO mgw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bandu ba kilambo so baatibaganika, bi'ngi' baayi'ki'tyaniye na Ayahudi na bi'ngi' baabile kwa atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kuundi'la, bandu bangali Ayahudi na Ayahudi baayi'ki'tyaniye na api'ndo babe baapangi maakau abo atumilwe na baaku'mbwe maliwe. ");
INSERT INTO mgw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Atumilwe pabakwipwi likowe lyo, babutuki Lustila na Delbe, ilambo ya Lukaonio, na mupipi yake, ");
INSERT INTO mgw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","akwo ngabayendelya ala abali inannoga. ");
INSERT INTO mgw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwaai na mundu yumo akwo Lustila ywaabile kitewe bu'ka belekwa, na aabile anayendali katu. ");
INSERT INTO mgw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu ywo aabile kampi'kania Pauli paabile kaala. Pauli aatikummu'nju'lya minyo na paamweni aabile na imani yo kombwa tepulwa, ");
INSERT INTO mgw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ngabaya kwa lilobe liku'lu', “Uyi'me kwa magu'lu' gako!” Aywo mundu ngaimukya akakatwike no yenda kwa magu'lu' gake. ");
INSERT INTO mgw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kipi'nga sa bandu pabaakibweni sakipangite Pauli, baapangite ndu'ti kwa luga ya Lukaonio, “kinnu'ngu' batuisili kati bandu!” ");
INSERT INTO mgw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balanaba ngabankema Zeu na Pauli ngabankema Helme, kwa mwanjaa ywembe ngaywalongelage muno. ");
INSERT INTO mgw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mpi'ndo wa dini wa Nyumba ya Nnu'ngu' ya Zeu, yayaabile panja ya kilambo, ngaleta ng'ombe malu'me babanemekilwe na malu'ba nnu'ngi' ya niango nku'lu' wa kilambo. Ywembe pamope na si'lu' kipi'nga sa bandu li'nga kwabi'ki'li'lya atumilwe. ");
INSERT INTO mgw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lakini Balanaba na Pauli pabayu'wine abali yo, bapopwanie magu'bo gabe no butukya musi'lu' kipi'nga sa bandu kababaya kwa lilobe liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mwalongo kwa mwanjaa ki'li' mugapanga makowe ga? Na twenga twabandu kati mwenga. Na tubile pano li'nga kumwalyanga abali inannoga, muileke inyago yangali maana, mukanng'alambuki Nnu'ngu' nkoti ywaumbike kunani na pai', baali na yoti yaibile mo. ");
INSERT INTO mgw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kwai'mbu' Nnu'ngu' aayi'ki'tiye kila nni'ma ubi'ngi'ye ndi'la yabapala. ");
INSERT INTO mgw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ata nyo Nnu'ngu' akotwikeli kwilaya kwa makowe manogau gaapangya. Anni'lya ula bu'ka kunani, apeya mauno munsimu wake, apeya ilyo na kuitwi'li'ya pulaa myoyo yinu.” ");
INSERT INTO mgw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ata kwa mayi'gi'yo ago, atumilwe baapatike tabu kwakanikiya balu' bandu kwapikiya salaka. ");
INSERT INTO mgw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lakini Ayahudi bi'ngi' baaisi bu'ka Antiokia na Ikonio, ngabaasopa bandu balu'mbane nabo, ngabanku'mbwa maliwe Pauli na kunkwakwata mpaka panja ya kilambo kabakita ayomwike. ");
INSERT INTO mgw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lakini banamasi' pabaakongolekine na kunti'li'ta, aatiyumuka, ngaki'li'bu'kya kukilambo. Pammalau' yake ywembe na Balanaba baayi'i Delbe. ");
INSERT INTO mgw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bu'ka pa Pauli na Balanaba ala abali inannoga akwo Delbe na kwapata banamasi' bambone, baabuyangani kai' Lustila, Ikonio, na Antiokia. ");
INSERT INTO mgw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Baatikwakangamaya banamasi' ba ilambo yo na kwasenga batame akangamau muimani. Ngaabakia, “Tupalikwa twenga twaboti pi'tya mungu'su'mbu' li'nga tuyingi muukulungwa wa Nnu'ngu'.” ");
INSERT INTO mgw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Baasawi api'ndo mu kila kanisa. Bu'kapo, kwo sali no punga, ngabaakamukia kwa Bwana ywaabile kabamwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bu'ka po pi'tya munni'ma wa Pisidia, baaikite Pamfilia. ");
INSERT INTO mgw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bu'ka po ala liyi'gi'yo lya Nnu'ngu' akwo Pelga, baayi'i Atalia. ");
INSERT INTO mgw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bu'ka kwo baayi'i kwa meli ki'li'bu'kya Antiokia, kwabaakamukiyilwe lyengo lyabayomolile kwa ngu'ngu' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabaaikite Antiokia baapangite kitamo sa aumini ba palu', ngabaapeya abali ya makowe gaagapangite Nnu'ngu' pamope nabo, na mwaayu'gu'li bandu bangali Ayahudi niango wo yingya muimani. ");
INSERT INTO mgw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ngabatama pamope na balu' banamasi' kwa masu'ba gambone ku'lu' Antiokia. ");
INSERT INTO mgw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bai, bandu bi'ngi' pabaaikite Antiokia bu'ka ku Yudea, ngabatumbwa kwayi'gana balu' babau'bi'lile kababaya, “Manaitei mwaba mwangainilwa kati mwaibayilwe musalya ya Musa, mwakosopolelwali.” ");
INSERT INTO mgw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bai, Pauli na Balanaba ngabataukana nabo mulikowe li', kwa nyo api'ndo ngabaasawa Pauli, Balanaba, na aumini nsi'si' ba kanisa li'lu' lya Antiokia bayende ku Yelusalemu bonagana na balu' atumilwe na api'ndo kwa likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bai, aumini baatikwayabuya, nabembe ngabatyangilya Foinike na Samalia. Ku'lu', baawanikie bandu bangali Ayahudi mwabanng'alambuki Nnu'ngu', na makowe go gaatikwapulaisa muno boti babau'bi'lile. ");
INSERT INTO mgw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabaaikite ku Yelusalemu, baakemilwe na aumini atumilwe na api'ndo. Nabembe ngabapeya abali ya goti Nnu'ngu' gaapangite pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lakini aumini bi'ngi' babaabile ba kipi'nga sa Mafalisayo baatiyi'ma kababaya, “Ipalikwa bandu bangali Ayahudi bainilwe no yi'ganilwa kwikoleya salya ya Musa.” ");
INSERT INTO mgw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bai, atumilwe na api'ndo ba kanisa baatami kitamo so pekeseni likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ntau pauyendelyage, Petili ngayi'ma kabaya, “Mwalongo aumini ayangu' mwenga mutangite panga kwai'mbu' Nnu'ngu' aanisawi nenga nkati yinu nibaye abali inannoga kwa bandu bangali Ayahudi, li'nga bapate yu'wa no u'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Nnu'ngu', ywatangite myoyo ya bandu, aalayite mwaayi'ki'tile kwa kwapeya bembe Loo Mpeleteu kati mwatupei twenga. ");
INSERT INTO mgw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nnu'ngu' aabawili pakati yitu na bembe, aaipeletiye myoyo yabe kwa mwanjaa baatikumwu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bai, kwa ki'li' kumpaya Nnu'ngu' kwa kwatwi'ka aumini kigombo kitopau, au'ku' bitu wala twenga twakombwili kukipu'twa? ");
INSERT INTO mgw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kaneibe nyo, ila tuu'bi'lya panga twenga kati bembe tukosopolelwa kwa ndi'la ya ngu'ngu' ya Bwana Yesu.” ");
INSERT INTO mgw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kitamo soti satami liki, kabaapi'kania Balanaba na Pauli kabaawanikia mangelongelo goti Nnu'ngu' gaapangite kwo pi'tya bembe kwa bandu bangali Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabaayomwi longela Yakobi ngabaya, “Mwalongo bangu', munipi'kani! ");
INSERT INTO mgw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni aawanikiye apo patumbu Nnu'ngu' mwaapangile bandu bangali Ayahudi, ngaasawa bi'ngi' babe bandu bake. ");
INSERT INTO mgw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Likowe li'no ngaliyi'ki'tyana na mayi'gi'yo ga alondoli ba Nnu'ngu' kati Maandiko Mapeleteu mwagalongela. ");
INSERT INTO mgw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bu'ka pa makowe ga nalu'a ki'li'bu'ka no senga kai' utawala wa Daudi wausengwanike. Mbala bi'ka wiso no kangamaya kai'. ");
INSERT INTO mgw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Li'nga bandu bi'ngi' boti, bandu bangali Ayahudi banaakemite babe bangu', baalu'a kunigalambukya. ");
INSERT INTO mgw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Amo nga mwalongela Bwana, ywapangite likowe li' litanganikwe bu'ka kwai'mbu'.’ ");
INSERT INTO mgw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kwa nyo pala kwangu' kanetwaauye bandu bangali Ayahudi babanng'alambukya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ila twapeleki balua ya kwabakia panga kanebapange upege, kanebalye ilyo yaibi'ki'lilwe kwa inyago, kanebalye kinyama sosoti sakipopotolilwe wala nywa myai. ");
INSERT INTO mgw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwa mwanjaa bu'ka kwai'mbu' salya ya Musa yabile kaialilwa muilambo yoti no somelwa mumayumba ga kunnu'ba Nnu'ngu' kila Sabato.” ");
INSERT INTO mgw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Atumilwe, api'ndo, na aumini boti baamwile kwasawa bandu nkati yabe na kwatuma Antiokia pamope na Pauli na Balanaba. Bai, ngabaasawa Yuda Balsaba na Sila babaabile alongosi ba au'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nabembe ngabaatuma na balua yaiandikilwe nyinya. “Twenga twatumilwe na api'ndo, twalongo binu, tummakia mukayumukanga mwenga mwalongo mwangali Ayahudi mwammile akwo Antiokia, Silia, na Kilikia. ");
INSERT INTO mgw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuyu'wine panga bandu bi'ngi' bu'ka ku'no kwitu baatikunsuluya mwenga kwa mayi'gi'yo gabe, baipangite myoyo yinu ibe na kyukala. Lakini baapangite nyo wangali yi'ki'ti'lwa na ywoywoti bu'ka kwitu. ");
INSERT INTO mgw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kwa nyo tuyi'ki'tyaniye kwa pamope kwasawa bandu nsi'si' na kwatuma kwinu pamope na batwapendile Balanaba na Pauli, ");
INSERT INTO mgw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","babaayi'ki'ti ata waa kwa mwanjaa ya lina lya Bwana witu Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kwa nyo twatuma Yuda na Sila kwinu babalu'a kummakia bene aga gatumwandikyanga. ");
INSERT INTO mgw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bai, Loo Mpeleteu na twenga tuyi'ki'tyaniye kanetwatwi'ke kigombo pi'ti'li'ki'ya pa makowe aga gangama. ");
INSERT INTO mgw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kanemupange upege, kanemulye ilyo yaibi'ki'lilwe kwa inyago, kanemulye kinyama sosoti sakipopotolilwe wala nywa myai. Mwapanga kinannoga mana mwakotoka panga go. Muyumukage!” ");
INSERT INTO mgw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bu'ka pa kwalaga, abo bandu baayi'i Antiokia akwo baakemite kitamo sa aumini, ngabaapeya yo balua. ");
INSERT INTO mgw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pabaaisomike ayo balua, mayi'gi'yo gake gaatikwasenga ngabapulaika muno. ");
INSERT INTO mgw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, babaai alondoli ba Nnu'ngu', baatilongela na abo alongo aumini kwa mayi'gi'yo maingi, kabaasenga na kwakangamaya. ");
INSERT INTO mgw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bu'ka po tama kwo kwa masu'ba nsi'si', alongo ba Antiokia baatikwalaga kababaya, “Yendage, mwakimambwiga bitu.” Bu'kapo baaki'li'bu'ki kwa balu' babaatumike. ");
INSERT INTO mgw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Lakini Pauli na Balanaba baaigali kwo Antiokia kwa masu'ba, ngabayi'gana no ala liyi'gi'yo lya Bwana, pamope na bandu bi'ngi' baingi. ");
INSERT INTO mgw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bu'ka pa masu'ba maingi Pauli aammakie Balanaba, “Tuki'li'bu'ke tukaakabwe balu' alongo mu kila kilambo satualite liyi'gi'yo lya Bwana, tukaalole mwabayendelya.” ");
INSERT INTO mgw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balanaba apalage bampu'twe na Yoani Maluko. ");
INSERT INTO mgw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lakini Pauli aapendili kumpu'twa Yoani Maluko kwa mwanjaa patumbu aatikwaleka ku'lu' Pamfilia no kana kwayangatiya lyengo lyabe. ");
INSERT INTO mgw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bai, kwapitike na ntau kati yabe, ngabalekangana. Balanaba ngantola Yoani Maluko, ngabau'bu'ka meli yenda Kuplo. ");
INSERT INTO mgw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Naywembe Pauli ngaansawa Sila. Bu'kapo, alongo ba pandu palu' ngabaalu'bya uli'nda wa ngu'ngu' ya Bwana, ngababu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mumwanja wo aapi'ti Silia na Kilikia, kaikangamaya imani ya bandu mumakanisa. ");
INSERT INTO mgw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauli aaikite Delbe na Lustila, kwaatami mwanamasi' ywakemelwage Timoteo. Mau' bake baai aumini ba Kiyahudi, lakini tati' bake baai Agiliki. ");
INSERT INTO mgw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bandu ba Lustila na Ikonio baakong'ondeli unogau wa Timoteo. ");
INSERT INTO mgw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli aapalike longwana nakwe Timoteo mumwanja wake, kwa nyo aatikumwina. Aapangite nyo kwa mwanjaa Ayahudi boti ba po baatangite panga tati' bake Timoteo baai Agiliki. ");
INSERT INTO mgw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pabaapite muilambo yi'lu' baapei bandu malagyo gagaapiyilwe na atumilwe na api'ndo ku'lu' ku Yelusalemu, ngababakia bagakamwe. ");
INSERT INTO mgw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kwa nyo galu' makanisa gendekomala muimani na mitumbi ya aumini yendeyongekea kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Baapi'ti Fulugia na Galatia kwa mwanjaa Loo Mpeleteu aabayi'ki'tiyeli ala mayi'gi'yo ga Nnu'ngu' munni'ma waukemelwage Asia. ");
INSERT INTO mgw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pabaaikite mumipaka ya Misia bapayike yingya munni'ma wa Bitinia, lakini Loo wa Yesu aabayi'ki'tiyeli. ");
INSERT INTO mgw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bai, ngabapi'tya Misia no yenda ntawalia mpaka Tiloa. ");
INSERT INTO mgw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kilo so Pauli aagabweni makowe gayambi', gaamweni mundu yumo ywa Makedonia ayi'mi palu' na kunnu'ba, “Uloke wise Makedonia utuyangatiye.” ");
INSERT INTO mgw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bu'ka pa Pauli kugabona makowe gayambi' go twaamwile kwibi'ka wiso yenda Makedonia kiyu'ngu'ya, twakwipwi kakape panga Nnu'ngu' atukemite twaali abali inannoga ku'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bu'ka Tiloa twayi'i kwa meli ntawalia mpaka Samotilake na pammalau' yake ngatuyi'ma Neapoli. ");
INSERT INTO mgw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bu'ka kwo, ngatuyenda mpaka Filipi, simo sa kilambo kiku'lu' sa Makedonia, kai' nga koloni lya Roma. Twaatami mukilambo so kwa masu'ba nsi'si'. ");
INSERT INTO mgw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabato ya Ayahudi twapitike panja ya kilambo na twayi'i mbwega ya libi'ndi', tukitage panga nga pandu po sali. Twatetama no longela na alwawa babaakongolekine pandu po. ");
INSERT INTO mgw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nkati ya balu' babatupi'kaniage aai nnwawa yumo ywankilikitya Nnu'ngu' ywakemelwage Lidia mwenekaya wa Tiatila ywabile nsulusi wa ngu'bo ya katani ya lukanda lwa sambalau. Bwana aauyu'wi mwoyo wake ata api'kani no pokya galu' mayi'gi'yo gaagalongei Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bu'ka pa aywo nnwawa pamope na alongobe batisilwa, aatitukoka kabaya, “Manaitei kakape mwibona panga nenga nimwu'bi'li Bwana, ninkemyanga kaya mukatame.” Aatuli'ndi'ndi'li tuyende. ");
INSERT INTO mgw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lisu'ba limo patwaabile katuyenda pandu po sali, mwi'nja yumo mmanda ywaabile na moka go londwa aakwembine na twenga. Kwa ulondoli wa mwi'nja ywo matayili bake bapatage mbanje yambone. ");
INSERT INTO mgw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bai, aywo mwi'nja aankotiye Pauli na twenga kapanga ndu'ti no baya, “Aba atumisi ba Nnu'ngu' Nku'lu'. Bammakianga ndi'la ya ukosopoli.” ");
INSERT INTO mgw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Apangite nyo kwa masu'ba gambone. Lisu'ba limo, Pauli paauyilwe, ngaang'alambukya aywo mwi'nja na kugabakia ago moka, “Kwa lina lya Yesu Kilisitu, nikuamulisa ummu'ke mundu yu'!” Popopo ago moka gaatikummu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Matayili ba yu'lu' mwi'nja pabakwipwi panga ndi'la yabe yo pata mali iyomwike, baaboywi Pauli na Sila, ngabaakwakwata mpaka kwa bandu nnu'ngi' ya api'ndo ba kilambo. ");
INSERT INTO mgw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ngabaasitakya kwa maakimu kababaya, “Bandu ba nga Ayahudi na bapanga puyo mukilambo situ. ");
INSERT INTO mgw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bayi'gana makowe gagakanilwa kugakoleya twabandu ba Roma.” ");
INSERT INTO mgw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kipi'nga sa bandu sasaabile palu' salu'mbine na balu' maakimu, ngabaaula magu'bo gabe Pauli na Sila kwa makakala no amulisa baku'mbu'lwe mikwasu. ");
INSERT INTO mgw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bu'ka po ku'mbu'lwa munomuno, ngababi'ki'lwa nnyumba na asikali wa nyumba ya atabilwe ngaamuliswa kwabi'ka muuli'nda nkali'. ");
INSERT INTO mgw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bu'kana na amuli yo baabi'kite musumba sa nkati muno sa nyumba ya atabilwe na kugatabya magu'lu' gabe mulipi'ki'ti' lya nkongo lyaliotolilwe. ");
INSERT INTO mgw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Papipi na meku Pauli na Sila baai kabasali no yi'mba myambo ya kunnumba Nnu'ngu', na ku'no atabilwe bi'ngi' baai kabaapi'kania. ");
INSERT INTO mgw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kwa kiimuimu kwapitike nnendemo nku'lu' wa bwi', wawalendemiye nyumba ya atabilwe. Popopo milyango yoti na pingwi ya atabilwe abo atabilwe yateyu'gu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Asikali wa nyumba ya atabilwe paayumwike na kwibona milyango ya nyumba ya atabilwe iyu'gu'lilwe, akitage panga atabilwe boti batolwike, na nyo aasolomwi lipanga lyake pala kwibulaga. ");
INSERT INTO mgw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini Pauli ngakema kwa lilobe liku'lu', “Kanewibulage wamwene kwa mwanjaa twenga tubile papano!” ");
INSERT INTO mgw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Bu'ka pa kunkema mundu leta lumuli, aywo asikali wa nyumba ya atabilwe aabutuki nnyumba ngaitaikulya nnu'ngi' ya magu'lu' ga Pauli na Sila, ku'no kalendema kwo yogopa. ");
INSERT INTO mgw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bu'kapo aatikwalongoya panja, ngaalaluya, “Mwabakoo, nipange buli li'nga nikosopolelwe?” ");
INSERT INTO mgw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bembe ngabannyangwa, “Umwu'bi'li Bwana Yesu nawenga walu'a kosopolelwa, pamope na alongo boti ba pansengo wako.” ");
INSERT INTO mgw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bai, ngabamwalya liyi'gi'yo lya Bwana, ywembe na bandu ba pansengo wake woti. ");
INSERT INTO mgw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yu'lu' asikali aatikwapu'twa saa yi'yi'lu'yi'lu' ya kilo ngaagu'lwa mabanga gabe, bu'kapo ywembe na alongo bake ngababatisilwa popopo. ");
INSERT INTO mgw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bu'kapo ngaalongwana nabo Pauli na Sila kasake na kwapeya kilyo. Ywembe na alongo bake boti ngabapanga si'li'ku'si'li'ku' kwa mwanjaa nambi'yambi' bamwu'bi'li Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pammalau' yake kindai', maakimu baatumike ayangatiyi babe kababaya, “Mwayu'gu'li balu' bandu babu'ke.” ");
INSERT INTO mgw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yu'lu' asikali wa nyumba ya atabilwe aampei abali Pauli, “Maakimu batumite abali li'nga muyu'gu'li'lwe. Nambi'yambi' mwendakombwa bu'ka no yenda kwa amani.” ");
INSERT INTO mgw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pauli ngaabakia ayangatiyi, “Ati' ki'li'? Baatuku'mbwi mikwasu pa bandu wangali senulwa na twenga twabandu ba Roma. Kai' batubi'kite muutabilwe na nambi'yambi' bapala kutuyu'gu'lya kwa kinyemela! Ata pasene! Ipalikwa maakimu baise bene paapanopano batuyu'gu'li.” ");
INSERT INTO mgw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abo ayangatiyi baapei abali ya likowe lyo maakimu, nabembe pabaayu'wine panga Pauli na Sila baai bandu ba Roma, baatiyogopa. ");
INSERT INTO mgw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kwa nyo baayi'i kwalu'ba nsama na kwapiya muutabilwe, bu'kapo baalu'bike babu'ke pakilambo si'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila pabaapiyilwe munyumba ya atabilwe baayi'i kunyumba ya Lidia. Akwo bakwembine na alongo aumini no bu'ka pa kwasenga, ngababu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kwo pi'tya Amfipoli na Apolonia baayi'i mpaka Tesalonike, kwayaabile nyumba ya kunnu'ba Nnu'ngu' ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pauli aatiyingya kati mwagaabile mayobelya gake, aalongei nabo ntawalia kwa masu'ba goti gatatu ga Sabato ya Ayahudi katumya Maandiko Mapeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aatikwaawanikia panga Kilisitu yaapalikwe abe mungu'su'mbu' no yu'ka bu'ka kwa awi'li. Ngaabakia, “Yesu ywanimwala kasinu nga Kilisitu.” ");
INSERT INTO mgw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bi'ngi' babe, lipi'nga lya Agiliki babankilikityage Nnu'ngu' pamope na alwawa baingi babaisimika baatiu'bi'lya, ngabalu'mbana nabo Pauli na Sila. ");
INSERT INTO mgw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini Ayahudi baabi'i bwigu, ngabaakoka bandu baakau kusoko panga kipi'nga no tumbwa puyo mukilambo soti. Ngabautangya nsengo wa Yasoni kabaapala Pauli na Sila li'nga baalete pa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lakini baapatikeli. Kwa nyo, bankwakwatike Yasoni pamope na alongo bi'ngi' mpaka kwa api'ndo ba kilambo, ngabapanga ndu'ti, “Bandu ba baai kabaasopa bandu ba dunia yoti, na nambi'yambi' bai pano pakilambo. ");
INSERT INTO mgw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni aakemi kasake. Boti bati'kwana amuli ya Kaisali kababaya, ‘Kubile na nkulungwa ywi'ngi' ywakemelwa Yesu.’” ");
INSERT INTO mgw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa mayi'gi'yo go baapei kyukala api'ndo ba kilambo na kipi'nga sa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Baapangite Yasoni na aine boti bapie mbwatyo, bu'kapo ngabaaleka bayende kasabe. ");
INSERT INTO mgw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kilo balu' alongo aumini baaindikiye Pauli na Sila bayende Belea. Pabaaikite kwo bai, baayi'i munyumba ya kunnu'ba Nnu'ngu' ya Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bandu ba kwo baai kinannyu'wa muno kuliko balu' ba Tesalonike. Baatigapokya galu' mayi'gi'yo kwa kilu'lu' muno, ngabapekeseni Maandiko Mapeleteu kila lisu'ba li'nga lola kati galu' gaalongei Pauli na Sila gaai ga kakape. ");
INSERT INTO mgw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Baingi babe baatiu'bi'lya na alwawa babaisimika ba Kigiliki na analu'me kai'. ");
INSERT INTO mgw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini Ayahudi ba Tesalonike pabakwipwi panga Pauli aai kaala liyi'gi'yo lya Nnu'ngu' akwo Belea, baayi'i kwo no tumbwa panga puyo no sopa ipi'nga ya bandu. ");
INSERT INTO mgw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Balu' alongo aumini baamwindikiye Pauli kiyu'ngu'ya ayende kumbwani, lakini Sila na Timoteo baaigali Belea. ");
INSERT INTO mgw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Balu' alongo babaamwindikiye Pauli baayi'i pamope nakwe mpaka Atene. Pabaabakiyilwe na Pauli panga Sila na Timoteo banki'ngame kiyu'ngu'ya, ngababuya. ");
INSERT INTO mgw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli paabile kaali'nda Sila na Timoteo akwo Atene, mwoyo wake watwi'li nyongo muno paakibweni kilambo so kitwi'li inyago ya kinnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aataukine na Ayahudi na bandu bi'ngi' babakilikitage nabo munyumba ya kunnu'ba Nnu'ngu'. Kila lisu'ba aai kalongela na bandu, pamope na boti balu' babaaisile kusoko. ");
INSERT INTO mgw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Balimu ba ipi'nga ya wa Epikuro na wa Sitoiki, baatitaukyana nakwe. Bi'ngi' baatibaya, “Apala longela ki'li' ayu' pwetela?” Kwa mwanjaa Pauli aai kaala makowe ga Yesu na uyu'ki, bi'ngi' baabaite, “Ibonekana kati aala makowe ga kinnu'ngu' ageni.” ");
INSERT INTO mgw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kwa nyo bampu'twi Pauli ngabampeleka ku Balasa lya Aleopago kababaya, “Tupala tutange likowe li' lyayambi' lyaulilongelyage. ");
INSERT INTO mgw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ili'be yi'ngi' yatuyu'wine kwa makutu gitu tunaiyu'wali. Twapendi tanga makowe ga galombolya ki'li'.” ");
INSERT INTO mgw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bandu ba Atene na atami bi'ngi' ba kwo baai ntu'pu' sabapangage ila yaulyana no pi'kania makowe gayambi' gagapitike. ");
INSERT INTO mgw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bai, Pauli aayi'mi nnu'ngi' ya kitamo sa Aleopago, ngabaya, “Mwabandu ba Atene! Nibona panga mwenga nga mwabandu ba dini muno. ");
INSERT INTO mgw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwa mwanjaa panaabile kanipi'ta akwo na kwo naibweni inyago yinu. Pakibi'ki'lyo simo sakiandikilwe, ‘Kwa Nnu'ngu' ywangatanganikwa.’ Bai, aywo ywamunkilikitya wangantanga, nga ywanimwalya mwenga. ");
INSERT INTO mgw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nnu'ngu' ywaumbike dunia na yoti yaibile mo, nga Bwana wa kunani na dunia, ywembe atamali mumayumba gagasengilwe na bandu. ");
INSERT INTO mgw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wala ayangatiyilwali na moko ga bandu panga kite apala sosoti si'lu', kwa mwanjaa ywembe mwene nga ywaapeya bandu ukoti, pu'mwa na kila kili'be. ");
INSERT INTO mgw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kwo pi'tya mundu yumo Nnu'ngu' aaumbite makabila goti na kwapanga batame mudunia yoti. Aatiamwa pakubawi na kwaku' kwo tama makabila go. ");
INSERT INTO mgw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Aapangite nyo li'nga makabila go gakombwe kunkoleya ata kwo papakia li'nga kumwikya. Lakini ata nyo, Nnu'ngu' abileli kuutalu na kila mundu. ");
INSERT INTO mgw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kati mwaabaite mundu yumo, ‘Nkati yake ywembe twenga twendatama, twendaegela na tubile,’ kati mwabalongei mumayandiko ginu gi'ngi', ‘Twenga nga twabana bake.’ ");
INSERT INTO mgw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Manaitei twenga twabana ba Nnu'ngu', inogelelyali kunng'anikia Nnu'ngu' panga kati zaabu, kyu'ma au ata liwe lyalibasilwe no lembelwa na mundu. ");
INSERT INTO mgw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nnu'ngu' aapangite kati alolali nsimu gu'lu' bandu pabaabile alalo. Lakini nambi'yambi' aamulisa bandu boti na kila pandu banng'alambuki Nnu'ngu' kwa kwileka sambi. ");
INSERT INTO mgw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwa mwanjaa ayomwile libi'ka lisu'ba lyaalu'a kwasenwa bandu kwa aki kwa ndi'la ya mundu yumo ywansawile. Nnu'ngu' aalayike boti likowe li' kwa kunnyu'ya mundu ywo bu'ka kuuwi'li!” ");
INSERT INTO mgw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pabannyu'wine Pauli kalongelya likowe lyo yu'ka kwa awi'li, bi'ngi' babe baatikunsalawa lakini bi'ngi' baatibaya, “Tupala tumpi'kaniye kai' likowe li'!” ");
INSERT INTO mgw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bu'kapo Pauli aatikwaleka ngabu'ka pakitamo. ");
INSERT INTO mgw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini bandu mitumbi nsi'si' baatilongwana nakwe ngabapanga aumini. Nkati ya bandu bo baai Dionisio wa Balasa lya Aleopago, nnwawa yumo ywakemelwage Damali, na bi'ngi' babe. ");
INSERT INTO mgw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bu'ka pa go, Pauli abu'i Atene yenda Kolinto. ");
INSERT INTO mgw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akwo Kolinto ankoli Nnyahudi yumo ywakemelwage Akula, ywabelekuli Ponto. Akula, pamope na nnyumbowe ywakemelwage Plisikila, baai baki'li'bwike bu'ka Italia masu'ba gogogo kwa mwanjaa Kaisali Klaudio aamulise Ayahudi boti babu'ke Roma. Pauli aayi'i kwatyangilya, ");
INSERT INTO mgw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwa mwanjaa bembe baai mapundi bo sona maema kati ywembe, Pauli aatitama no panga nabo kasi. ");
INSERT INTO mgw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Sabato ya Ayahudi aatiala munyumba ya kunnu'ba Nnu'ngu', kapaya kwaatebeya Ayahudi na Agiliki. ");
INSERT INTO mgw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Bu'ka pa Sila na Timoteo ika bu'ka Makedonia, Pauli aatumbwi tumya wakati wake woti kwo ala, kaakong'ondelya Ayahudi panga Yesu nga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pabankanile no tumbwa kumpwi'wa aakung'undike ngu'bo yake nnu'ngi' yabe kabaya, “Mana mwobite mwatanga mwabene, nenga ntu'pu' lukoolo lwolwoti kwa likowe lyo. No bu'ka nambi'yambi' nalu'a kwayendelya bandu bi'ngi' bangali Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Bu'kapo, ngayenda tama kasake mundu ywankilikitya Nnu'ngu' ywakemelwage Tito Yusito, ywembe nyumba yake yaai papipi na yi'lu' nyumba ya kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilispo, mpi'ndo ywa nyumba ya kunnu'ba Nnu'ngu', aamwu'bi'li Bwana pamope na alongo bake boti. Akolinto baingi baatikugapi'kania makowe go ngabau'bi'lya no batisilwa. ");
INSERT INTO mgw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lisu'ba limo kilo Bwana aammakie Pauli mumakowe gayambi', “Kaneuyogope, uyendeli ala wangali kotoka, ");
INSERT INTO mgw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwa mwanjaa nenga nibile pamope nawe. Ntu'pu' mundu ywaalu'a kukusulu mwanjaa pano pakilambo pabile na bandu baingi bababile kwangu'.” ");
INSERT INTO mgw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bai, Pauli aatami kwo kayi'gana liyi'gi'yo lya Nnu'ngu' kwabe kwa mwaka gumo na myei sita. ");
INSERT INTO mgw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nsimu Galio paabile mpi'ndo ywa nkoa wa Akaya, Ayahudi batikuntangya Pauli kwa pamope na kumpeleka kumankama, ");
INSERT INTO mgw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","kababaya, “Tunsitakya mundu yu' kwa mwanjaa asopa bandu bankilikiti Nnu'ngu' kwa ndi'la yangayi'ki'tyana na salya.” ");
INSERT INTO mgw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pauli abile balo longela, Galio ngaabakia, “Mupi'kaniange mwenga Mwaayahudi! Manaitei kakape likowe li' likaba kwa makowe maakau nilu'e kumpi'kanianga. ");
INSERT INTO mgw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini kwa kitumbu sa ntau wa mayi'gi'yo na maina ga salya yinu, muyomwane mwabene. Nenga ngani panga nsenuli wa makowe go.” ");
INSERT INTO mgw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Bai, ngaabi'nga bu'ka mankamani. ");
INSERT INTO mgw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nabembe boti ngabammoywa Sositene ywaabile mpi'ndo ywa nyumba ya kunnu'ba Nnu'ngu', ngabanku'mbwa papalu'palu' nnu'ngi' ya mankama. Lakini Galio aasitwikeli kyendo so ata pasene. ");
INSERT INTO mgw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli aatami na balu' alongo akwo Kolinto kwa masu'ba maingi. Bu'kapo ngaalaga no u'bu'ka meli yenda Silia pamope na Plisikila na Akula. Akwo Kenklea, aasekwi nywili yake kwa mwanjaa ya nyalili yaabi'kite. ");
INSERT INTO mgw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Paaikite Efeso, Pauli aalei Plisikila na Akula, aayi'i munyumba ya kunnu'ba Nnu'ngu' ngalongela na Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Baannu'bite atame nabo kwa masu'ba gambone, lakini aayi'ki'tili. ");
INSERT INTO mgw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ila paabile kabu'ka, ngaabakia, “Nnu'ngu' mana apendile nalu'a isa kai' kasinu.” Bu'kapo, ngabu'ka kwa meli. ");
INSERT INTO mgw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Meli yatiyi'ma Kaisalia, naywembe Pauli ngayenda kwakabwa balu' aumini, bu'kapo ngayenda Antiokia. ");
INSERT INTO mgw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Aatami kwo kwa masu'ba, bu'kapo ngayendelya na mwanja kwo pi'tya ku Galatia na Fulugia kaasenga banamasi' boti. ");
INSERT INTO mgw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nnyahudi yumo ywakemelwage Apolo mmelekulya ku Alekisandilia, aaikite Efeso. Aai mundu mwene malango kwo longela na ywagamanyi muno Maandiko Mapeleteu. ");
INSERT INTO mgw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aayi'ganilwe ndi'la ya Bwana, na kwa mwanjaa li'lu' liyi'gi'yo liyakage pamwoyo wake, aayi'gine wisowiso abali ya Yesu pamope no panga apatike ubatiso wa Yoani bai. ");
INSERT INTO mgw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Plisikila na Akula pabannyu'wine kalongela kwo kangamala munyumba ya kunnu'ba Nnu'ngu', baampu'tu'li kasabe ngabannyi'gana ayo ndi'la ya Nnu'ngu' kwa wisowiso muno. ");
INSERT INTO mgw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo paabile kabu'ka yenda Akaya, balu' alongo batikunsenga kwa kwaandikya banamasi' ba Akaya bampoki. Paaikite kwo, aakombwi kwayangatiya balu' alongo babaau'bi'lile kwa ngu'ngu' ya Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kwa mwanjaa aayendeli kwo kangamala ngaasinda Ayahudi pa bandu kaalaya bu'ka mu Maandiko Mapeleteu panga Yesu nga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nsimu Apolo paabile Kolinto, Pauli aai mumwanja kumili'ma miyu'mu' mpaka ku Efeso, akwo aakwembite banamasi' nsi'si'. ");
INSERT INTO mgw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Aatikwalaluya, “Buli, mwenga pamwau'bi'lile mwapokile Loo Mpeleteu?” Nabembe ngabannyangwa, “Lili! Ata tunayu'wali panga kubile na Loo Mpeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Naywembe Pauli ngaalaluya, “Mwabatisilwe kwa ubatiso waku'?” Ngabannyangwa, “Ubatiso wa Yoani.” ");
INSERT INTO mgw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nembe Pauli ngaabakia, “Yoani aabatisike balu' babanng'alambuki Nnu'ngu' kwa kwileka sambi na kwabakia bamwu'bi'li yu'lu' ywaalu'a isa nsu'gu' yake, nga Yesu.” ");
INSERT INTO mgw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pabaayu'wine go, ngababatisilwa kwa lina lya Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bai, Pauli ngaabi'kya maboko kwalu'bya na Loo Mpeleteu ngaaulukya, baatumbwi longela luga yayambi' no londwa. ");
INSERT INTO mgw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Boti mayumu baai analu'me mitumbi ku'mi na abi'li'. ");
INSERT INTO mgw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa myei itatu Pauli ayendage kunyumba ya kunnu'ba Nnu'ngu', na akwo alongelage na bandu wangali yogopa, li'nga kwauta bau'bi'li Ukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini bi'ngi' bendetauka, baakani u'bi'lya no tumbwa longela maakau kwikana ndi'la ya Bwana pakipi'nga sa bandu. Apo Pauli aakani baa nabo pamope, aapelike pambwega balu' banamasi' bake, aai kalongela nabo kila lisu'ba munyumba yo somya ya mundu yumo ywakemelwage Tilano. ");
INSERT INTO mgw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aayendeli panga nyo kwa myaka ibi'li', ata bandu boti ba Asia, Ayahudi na bandu bangali Ayahudi, baakombwi yu'wa liyi'gi'yo lya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nnu'ngu' aapangite mangelongelo maku'lu' kwa moko ga Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Magu'bo na itambala yaponolyage lyusu Pauli, yaapelekilwe kwa atamwe nabembe baatepulilwe matamwe gabe, na balu' bene moka gaatikwabu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kwabile na Ayahudi bababi'ngage moka ku'no na kwo, kabapaya kulitumya lina lya Bwana Yesu kwa balu' babaayingililwe na moka. Babayage, “Nimwamulisa kwa lina lya Yesu yu'lu' ywaalilwa na Pauli mummu'ke mundu yu'.” ");
INSERT INTO mgw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bana saba ba Sekewa, Mpi'ndo wa dini ya Kiyahudi, ngabapangage nyo. ");
INSERT INTO mgw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lakini moka aatikwayangwa, “Nintangite Yesu, kai' ata Pauli ninnyu'wine, lakini mwenga mwakinyai?” ");
INSERT INTO mgw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Bu'kapo, yu'lu' mundu ywayingililwe na moka aatikwalipulya boti na kwapi'ta kwa makakala. Na abo bana ba Sekewa baatitila bu'ka munyumba yi'lu' wausu na mabanga gambone. ");
INSERT INTO mgw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kila mundu ywabile Nnyahudi na ywangali Nnyahudi akwo ku Efeso aaliyu'wine likowe lyo. Boti baatiyogopa, ngabalikwi'ya lina lya Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bandu baingi bu'ka mwa balu' babaau'bi'lile nsimu wo baatiisa no buyangania kwa Nnu'ngu' wabe kababaya masambi galu' gabagapangage, wangali iya. ");
INSERT INTO mgw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na bandu baingi bu'ka mubalu' babapangage makowe ga bwabi', baakongwi itabu yabe ya kwiyi'ganikia na kwitiniya mwoto bandu kabalola. Baapangite isabu ya mbanje yaikombwa pi'ma itabu yo, yaai yene samani ngu'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kwa nyo, liyi'gi'yo lya Nnu'ngu' lyayongekiye landala no yendelya pangika kwa makakala ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pagayomwike pitya makowe go, Pauli aabini pamwoyo wake yenda ku Yelusalemu kwo pi'tya Makedonia na Akaya. Aabaite, “Bu'ka po ika kwo, nipalikwa niyende ku Roma.” ");
INSERT INTO mgw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kwa nyo, aatumike bandu abi'li' ayangatiyi bake Timoteo na Elasito bannongoli yenda ku Makedonia, ywembe mwene aaigali ku Asia kwa masu'ba. ");
INSERT INTO mgw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Awo, nga wai nsimu wu'lu' wagaapitike mayu'mano maku'lu' kwa kitumbu sa ndi'la yi'lu' ya Bwana. ");
INSERT INTO mgw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mundu yumo ywakemelwage Demetilio, ywaabile na kipala, ayanage yu'ma li'nga tengenesa inyago ya nyumba ya nnu'ngu' ywakemelwage Atemi, na kwapeya nsuluso nku'lu' ywembe na mapundi aine. ");
INSERT INTO mgw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Aakemi pamope na bandu bi'ngi' babapanga lyengo lya upundi wo yana kati ywembe aatikwabakia, “Mwenga mwa bandu! Utayili witu ubu'kana na usulusi wu'no. ");
INSERT INTO mgw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kai', mwenga mwendakugabona gapanga Pauli ga kwakonga na kwaobeya bandu, ku'no ku Efeso na ku Asia yoti kaabakia panga, ‘Inyago yaiyanilwe na bandu, kinnu'ngu' lili ata pasene.’ ");
INSERT INTO mgw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kwa nyo kubile na makowe manonopau kwenda kwo obeya isima ya lyengo litu bai lili, ila ata kunyumba ya kunkilikitya nnu'ngu' nnwawa Atemi ywabile nku'lu', ywakilikitilwa ku Asia na dunia yoti, ukulungwa wake waapanga upokonyolilwe.” ");
INSERT INTO mgw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pabayu'wine makowe go, baatiusika no tumbwa panga ndu'ti kababaya, “Atemi ywa Efeso nga nku'lu'!” ");
INSERT INTO mgw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kilambo soti satwi'li puyo. Bannyingili Gayo na nnyine Alisitako, benekaya ba Makedonia babaabile mumwanja umo na Pauli. Baatikwaboywa no butuka nabo mpaka kulua lwo kwembanikia. ");
INSERT INTO mgw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Mwene Pauli apalage longela na kipi'nga so sa bandu, lakini aumini baatikunkanikiya. ");
INSERT INTO mgw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Alongosi bi'ngi' ba ku Asia, babaabile mambwigalye Pauli, baatumike bandu bankwi'li'ke panga kaneayingi muluwa lwo kwembanikia. ");
INSERT INTO mgw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pandu po kila mundu endepu'yu'ta bai, ywi'ngi' kalongela li', na ywi'ngi' li'lu', mpaka si'lu' kitamo saatimunaika. Baingi baatangiteli ata kitumbu so kwembana kwabe. ");
INSERT INTO mgw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayahudi bannyi'mike Alekisanda nnu'ngi', ngabammakia makowe go longela. Bai, ngaapu'ngya luboko pala aikengi pa kipi'nga sa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lakini pabaakwipwi panga ywembe Nnyahudi, boti kwa pamope baapangite ndu'ti kababaya, “Atemi ywa Efeso nga nku'lu'!” Baayendeli pu'yu'ta nyo kwa masaa gabi'li'. ");
INSERT INTO mgw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Bu'kapo mwandiki ywa kilambo ngakitamika liki kipi'nga sa bandu na aatikwabakia, “Mwenga mwa bandu ba ku Efeso, dunia yoti itangite panga kilambo sa Efeso ngakili'ndi'la nyumba ya Nnu'ngu' Atemi ywabile nku'lu', na si'lu' kinyago sake sakitu'mbwike bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bai, kwa mwanjaa makowe ga ntu'pu' ywakombwa kugakana, mupalikwa mutame liki kanemupange kikowe sosoti kwa kilokoloko. ");
INSERT INTO mgw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mwaletike bandu ba pano, pamope no panga bembe banayibali munyumba ya nnu'ngu', wala banankupululi ayu' nnu'ngu' witu. ");
INSERT INTO mgw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bai, manaitei Demetilio na mapundi aine babile na likowe lyolyoti kwa mundu ywoywoti, mabalasa gabile, na alongosi babile, bakasitakyane kwo. ");
INSERT INTO mgw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Manaitei kubile na makowe gi'ngi' gogoti gamupala, gapalikwa gakaawanikiyilwe pa kibalangwa. ");
INSERT INTO mgw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwa mwanjaa tulu'e sitakilwa kwa kitumbu sa puyo yatupangite li'no. Ntu'pu' kitumbu satukombwa piya sakilu'wa yi'ki'tyana na puyo yi'no.” ");
INSERT INTO mgw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Payomwi longela go, kitamo ngakiyomoka. ");
INSERT INTO mgw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Paiyomwike puyo ya palu' Efeso, Pauli aakemi pamope aumini, ngaasenga myoyo yabe na kwalaga, ngaayabwa mwanja wo yenda Makedonia. ");
INSERT INTO mgw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Aapi'ti muilambo yambone ya munni'ma wu'lu' ku'no kalongela na bandu makowe maingi ga kwasenga myoyo, ngaika ku Uyunani, ");
INSERT INTO mgw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","akwo aatami myei itatu. Aapalike yabwa mwanja kwa ndi'la ya baali yenda ku Shamu, lakini kwa mwanjaa Ayahudi baampangi masauli maakau, ngaileka ndi'la yo no buyangana kwo pi'tya ndi'la ya Makedonia. ");
INSERT INTO mgw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pauli aalongwaniye na Sopatilo mwana wa Pilo bu'ka Belea, Alisitako na Sekundo bu'ka Tesalonike, Gayo mundu wa bu'ka Delbe, Timoteo pamope na Tikiko na Tilofimo wa kunni'ma wa ku Asia. ");
INSERT INTO mgw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ila bandu bo baatilongolya, baayi'i kutuli'nda ku Tiloa. ");
INSERT INTO mgw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bu'ka po pi'ta si'li'ku'si'li'ku' ya makati gangalu'la, na twenga twau'bwike meli bu'ka Filipi. Twaai mumwanja kwa masu'ba matano, ngatulu'mbana na aitu akwo Tiloa, ngatutama yuma yimo. ");
INSERT INTO mgw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lisu'ba lya Jumapili, twaakwembine li'nga metwana likati pamope. Pauli aalongei na bandu, nembe kwa mwanjaa aabini bu'ka pammalau' yake, aayendeli longela mpaka meku. ");
INSERT INTO mgw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mu'lu' musumba kuligolopwa, kwaai na imuli yambone kaiyaka. ");
INSERT INTO mgw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mwinsembe yumo ywakemelwage Eutiko aatami palililisa, Pauli payendelyage ala liyi'gi'yo lya Nnu'ngu' kwa masaa gambone, Eutiko aalobi lugono ngatu'mbu'ka bu'ka kugolofa yenetatu. Bantondwi awile. ");
INSERT INTO mgw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pauli auluki pai', aatiyinama na kunkumbatya ngabaya, “Kanemube na kyukala, ayu' mundu ayu'kite.” ");
INSERT INTO mgw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bu'kapo Pauli ngau'bu'kya kai' kuligolopwa, aalimetwi likati no lya. Aayendeli longela mpaka kakusaa, ngabu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bandu bammuyanganiye kaya yu'lu' mwinsembe abi mwu'mi, nabembe myoyo yabe yaatiumukuka muno. ");
INSERT INTO mgw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Lakini twenga twaatilongolya u'bu'ka mumeli yenda Aso, kwembe ngatwaalagine tukampaki Pauli, kwa mwanjaa apalage ika kwo kwa ndi'la ya magu'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bai, aatukwembite ku'lu' Aso, twamwu'bwiye mumeli, twabu'i pamope mpaka Mitilene. ");
INSERT INTO mgw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bu'kapo, twayendeli na mwanja, pammalau' yake ngatuika Kio. Lisu'ba lyenebi'li', twayi'mi Samo, na pammalau' ngatuika Mileto. ");
INSERT INTO mgw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pauli aabini yendelya na mwanja kwa meli wangali pi'tya ku Efeso. Akanage yomwa masu'ba gambone muno akwo ku Asia, kwa mwanjaa atamaniage akalikoli lisu'ba lya Pentekosite ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pauli paabile ku Mileto, aatumike bandu yenda ku Efeso kwakema api'ndo ba kanisa sababonagane nakwe. ");
INSERT INTO mgw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pababonagine nakwe aatikwabakia, “Mwenga mwabene munibweni mwanitami na mwenga masu'ba goti, bu'ka lisu'ba lyanitumbwi li'bata pano Asia. ");
INSERT INTO mgw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nintumikiye Bwana kwa kwibu'ya samani na kwa moli, kanikomeya mapayilwo gaganipatike bu'kana na ulau wa Ayahudi. ");
INSERT INTO mgw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mutangite panga nimwiyangiteli likowe ata limo lyanilibweni likombwa kunnyangatiya mwenga, lakini nannyi'ganiye pa bandu kai' pansengo gumo mpaka wi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Naakwi'like Ayahudi na bandu bangali Ayahudi panga banng'alambuki Nnu'ngu' kwa kugaleka masambi na kumwu'bi'lya Bwana witu Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bai, kwa mwanjaa ninnyu'wa Loo Mpeleteu, niyabwa mwanja wo yenda ku Yelusalemu, pamope no panga nigatangiteli gagayenda kunipata kwo. ");
INSERT INTO mgw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Lakini sanikitangite si'no bai panga kila kilambo sanilu'a yenda Loo Mpeleteu anikong'ondelya panga pingwi na ngu'su'mbu' ngainili'nda. ");
INSERT INTO mgw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini, bwu'mi wangu' niubalangilyali panga wa ngama muno kwangu' nenga, kulikoni kwiyomolya nganjo yangu' ya lyengo lyanipeyilwe na Bwana Yesu, lya kwiala abali inannoga ya ngu'ngu' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mulole mwoti mwanityangite, ala liyi'gi'yo lya Ukulungwa wa Nnu'ngu', ntu'pu' babaalu'a kunibona kai'. ");
INSERT INTO mgw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kwa nyo, li'no nendakummakianga panga nenga ntu'pu' mundu ywoywoti ywalu'a oba ywakunibi'kya lukoolo. ");
INSERT INTO mgw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwa mwanjaa nenga nasi'yiteli kummakianga goti gaagapala Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Muli'ndi'le myoyo yinu na kipi'nga soti si'lu' Loo Mpeleteu ammi'kite mwenga. Mulikote kanisa lyake Nnu'ngu' lyaalipi'mite kwa myai yake mwene. ");
INSERT INTO mgw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nitangite munomuno panga, mananibu'i nenga, bandu alau babalandana na mapu'mbe makali', baalu'a isa kunnyingilyanga wangali kibi'kya kiya kipi'nga si'no. ");
INSERT INTO mgw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kai', bu'ka mukipi'nga sinu mwabene, baakatuka bandu babaalu'a kwaobeya ayabe kwo galambuya mayi'gano, li'nga baaute aumini na baabi'ngi'ye bembe. ");
INSERT INTO mgw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa nyo, mube minyo ku'no kamuku'mbu'kya panga kwa myaka itatu ntawalia kilo na muntwekati, naatotokilweli kunkwi'li'ka kila mundu, ata kwa moli. ");
INSERT INTO mgw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Bai, nambi'yambi', nimmi'kanga mumaboko ga Nnu'ngu' na kwa liyi'gi'yo lya ngu'ngu' yake lyalikombwa kunsenga, na kumpeyanga ulisi pamope na boti babapeleteyilwe. ");
INSERT INTO mgw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nenga naaminyikiyeli mbanje, wala ili'be yoyoti yaileta utayili. ");
INSERT INTO mgw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwenga mwabene mutangite panga maboko gangu' gano gatumike kwo paalya makowe gangu' namwene na balu' babaabile pamope nanenga. ");
INSERT INTO mgw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kwa makowe goti, ninnayite panga kwa ndi'la yo panga kasi kwo binia, tupalikwa kwayangatiya bangali uweso na kugaku'mbu'kya mayi'gi'yo ga Bwana Yesu gaabaite, ‘Nantali muno kumpeya mundu kulikoni pokya bu'ka kwa mundu.’” ");
INSERT INTO mgw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Payomwi longela go, Pauli aatikilikita na kunnu'ba Nnu'ngu' pamope nabo. ");
INSERT INTO mgw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Boti baatili'la muno, ku'no kabannaga kwa kunkumbatya na kunnonia, ");
INSERT INTO mgw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","baatitotokelwa munomuno, kwa si'lu' saabakiye panga baalu'a kummonali kai'. Ngabamwindikiya mpaka payingi mumeli. ");
INSERT INTO mgw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patuyomwi lagana nabo, twau'bwike mumeli no yenda ntawalia mpaka Kosi. Pammalau' yake twaikite Lode, patubu'i kwo twayi'i Patala. ");
INSERT INTO mgw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Apo, twaikoli meli yailokage yenda ku Foinike, twaatiu'bu'ka no yendanayo. ");
INSERT INTO mgw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patuikite Kuplo, twaasegite mbwega na kupaleka kumaki'ya gitu, twayendeli na mwanja mpaka Silia, twayi'mike meli yitu pakiloko sa Tilo, na apo meli yitu ngaipalikwage iuluye kigombo sake. ");
INSERT INTO mgw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Akwo, twaakoli aumini batwaatami nabo kwa yuma yimo. Nabembe kabalongoyelwa na Loo Mpeleteu, bammakie Pauli panga kaneayende ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Lakini pagayomwike masu'ba gotama palu', twaatibu'ka. Balu' aumini, pamope na alwawa na bana, baatituindikiya mpaka panja ya kilambo. Twaboti twaatikilikita palu' pambwani na kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Patuyomwi lagana, twaayingi mumeli, nabembe ngababuyangania kasabe. ");
INSERT INTO mgw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Patubu'i Tilo, ngatuika ku Tolemai, akwo twatami nabo alongo aumini kwa lisu'ba limo kwapanga abali no bonagana nabo. ");
INSERT INTO mgw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pammalau' yake twatibu'ka ngatuika Kaisalia, twaiki munyumba ya Pilipi ywaalage abali inannoga, ywaabile yumo mwa balu' bandu saba babaasagulilwe ku Yelusalemu kwayangatiya alwawa awi'li'ka. ");
INSERT INTO mgw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilipi aabile na ai'nja banee, bembe baapeyilwe uweso wa ulondoli wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bai, patutami kwo kwa masu'ba gambone, ngaisa Agabo, nnondoli yumo ywa Nnu'ngu', bu'ka ku Yudea. ");
INSERT INTO mgw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Paatukolile, aautweti nkanda wa Pauli na kwitaba maboko na magu'lu' no baya, “Loo Mpeleteu abaya nnyanya, ‘Ayahudi ku'lu' ku Yelusalemu nga mwabaalu'a kuntaba mwene nkanda wu'no nyinyonyo na kunnyi'ya mumaboko ga bandu bangali Ayahudi.’” ");
INSERT INTO mgw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patugayu'wine go, bandu bi'ngi' babaabile pamope na twenga ngatunnu'ba muno Pauli kaneayende ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lakini Pauli aatiyangwa, “Mupala panga namani? Mupala kuniti'kwana mwoyo wangu' kwa moli ginu? Nenga niyi'ki'tile kwenda tabilwa baili, ata kiwo kwa kitumbu sa lina lya Bwana Yesu.” ");
INSERT INTO mgw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Paakani yi'ki'tya katukatu gatummakie, ngatunneka katubaya, “Lyalibini Bwana lipaangike.” ");
INSERT INTO mgw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Patutami palu' kwa masu'ba, twaibi'i wiso no yendelya na mwanja witu wa ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bi'ngi' ba aumini bu'ka Kaisalia baalongwaniye na twenga kutuindikia, ngatuika kasake Mnasoni, mundu wa Kuplo, akwo ngatwaayi'i tama. Ywembe aabile yumo ywa aumini ba patumbu. ");
INSERT INTO mgw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patuikite ku Yelusalemu, alongo baatupoki kwo napusika muno. ");
INSERT INTO mgw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pammalau' yake, twalongwaniye na Pauli yenda kwakaulya Yakobi na api'ndo boti ba kanisa. ");
INSERT INTO mgw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Payomwi kwapanga abali, Pauli aabakie makowe goti limo ata li'ngi' gaagapangite Nnu'ngu' kwa bandu bangali Ayahudi kwo pi'tya lyengo lyake. ");
INSERT INTO mgw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pabaagayu'wine go, bankwi'yite Nnu'ngu' na bammakie Pauli, “Nnongo! Lola, kubile na maelupu ga Ayahudi babayi'ki'tya panga aumini, na boti baikamwa salya ya Musa. ");
INSERT INTO mgw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tubakiyilwe panga, wayi'gana Ayahudi babatama pamope na bandu bangali Ayahudi baisalawe salya ya Musa, kanebaaine bana babe liku'mbi', na baileke yali yabe ya Kiyahudi. ");
INSERT INTO mgw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tumbwelelo, bakosali yu'wa panga wisile ku Yelusalemu, bai, tupange buli? ");
INSERT INTO mgw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bai, upange li'lu' lyatukubakia. Tubile na bandu nsese pano, bembe babi'i nyalili kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wiyingiye kwa bandu baa, uli'pe mbanje yoti kwa kwiipeletea pamope nabembe, na basekulwe nywili yabe. Kwa ndi'la yi', boti balu'a tanga panga makowe gabaagayu'wine gai gammali'la, nawenga uyendelya kwikamwa salya ya Musa wisowiso. ");
INSERT INTO mgw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Bu'kana na balu' bandu bangali Ayahudi babaabile aumini, twaapeleki balua yatwabakiye panga kanebalye ilyo ya paibi'ki'lyo ya kinnu'ngu' ba ubu'su', kanebanywe myai, kanebalye inyama yaipopotolilwe, na kanebatome ilu'mbu'.” ");
INSERT INTO mgw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bai, pammalau' yake Pauli aatweti balu' bandu no panga nabo ibala ya kwiipeletea. Bu'kapo, ngayingya mu Nyumba ya Nnu'ngu', kaabakia makowe ga kuuyomolyo wa lisu'ba lya kwiipeletea na salaka yayaalu'a piyilwa kwa kila mundu. ");
INSERT INTO mgw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Galu' masu'ba saba pagaegeli yomokya, bi'ngi' ba Ayahudi bu'ka Asia babaamweni Pauli mu Nyumba ya Nnu'ngu', ngabakisopa kipi'nga soti sa bandu na ngabammoywa. ");
INSERT INTO mgw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Baapangite ndu'ti kababaya, “Mwaisilaili mwaitu, mutuyangatiye! Ayu' nga yu'lu' mundu ywannyi'gana kila mundu na kila pandu taukana na bandu bitu, salya yitu, ata Nyumba ya Nnu'ngu'. Kai', aaletike Agiliki mu Nyumba ya Nnu'ngu' na kupasapuya pandu pano papeleteu.” ");
INSERT INTO mgw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Baalongei nyo kwa mwanjaa patumbu baamweni Tilofimo, mwenekaya wa ku Efeso, alongwaniye na Pauli kabatyanga pamope, bakitage kwaali' Pauli aannyingiye mu Nyumba ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kilambo soti saatwi'li puyo, bandu baaisi bu'ka kila pandu, baammoywi Pauli na kunkwakwatya panja ya Nyumba ya Nnu'ngu'. Popopo milyango yabe ngaiyigalilwa. ");
INSERT INTO mgw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Baabini kummulaga, lakini abali yaamwiki kolongosi ywa yesi lya Kiroma panga ku Yelusalemu kwoti kwaai na puyo. ");
INSERT INTO mgw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Popopo, mpi'ndo ywa Yesi aatweti asikali na alongosi ba yesi. Nabembe pabaamweni mpi'ndo ywa yesi na asikali, ngabasomwa kunku'mbwa Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yu'lu' mpi'ndo ywa yesi aamwegeleli Pauli na kummoywa, aamulise atabilwe kwa pingwi ibi'li'. Ngalaluya, “Ayu' nyai? Kai', apangite namani?” ");
INSERT INTO mgw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bandu bi'ngi' palu' pa kipi'nga sa bandu bapangage ndu'ti, aba kabalongela li', balu' kabalongela li'lu'. Yu'lu' mpi'ndo ywa yesi waibweni panga akombwali tanga kitumbu sa yi'lu' ndu'ti, aamulise Pauli apelekelwe kunyumba ya banayesi. ");
INSERT INTO mgw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli paikite pa ngasi, asikali baampu'twi nnani nnani kwo yogopa puyo ya si'lu' kipi'nga sa bandu, ");
INSERT INTO mgw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","kwa mwanjaa sendekummi'ngi'ya ku'no kakipanga ndu'ti kababaya, “Mummulagi kwo!” ");
INSERT INTO mgw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pabaannyingiyage munyumba ya banayesi, Pauli aannu'bite mpi'ndo ywa yesi kammakia, “Wendanji'ki'ti'ya kukubakia kikowe?” Yu'lu' mpi'ndo ywa yesi ngannyangwa, “Kumbe umanyi longela Kigiliki! ");
INSERT INTO mgw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kwa nyo wenga wa yu'lu' mundu ywa Misili lili, ywaapangite puyo masu'ba gagapite kaalongoya makatauluma 4,000 mpaka kulubele?” ");
INSERT INTO mgw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli ngayangwa, “Nenga nga Nannyahudi, nibelekuli Taliso akwo Kilikia, namwenekaya ywa kilambo sakitanganikwe na boti. Sonde li'li'li', uniyi'ki'ti'ye nilongele na bandu ba.” ");
INSERT INTO mgw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yu'lu' mpi'ndo ywa yesi ngaannyi'ki'ti'a. Kwa nyo Pauli aayi'mi mungasi, aapu'ngi luboko balu' bandu, pabaatami liki, aatumbwi longela nabo kwa Kiebrania. ");
INSERT INTO mgw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Aatibaya, “Mwenga mwalongo bangu' na akina tati' bangu', munipi'kani mwaniikengya nnu'ngi' yinu.” ");
INSERT INTO mgw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pabayu'wine kalongela nabo kwa Kiebrania, baayongiye tama liki kulikoni patumbwi longela. Nembe Pauli aayendeli longela, ");
INSERT INTO mgw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga Nannyahudi, nibelekuli Taliso ku'lu' Kilikia. Lakini naaku'li paapano pano pa kilambo sa Yelusalemu kwa mayi'gano ga mwalimu wangu' Gamalieli. Naayi'ganilwe wisowiso mwaiyenda salya ya api'ndo bitu, kaniyi'ma kwa mwoyo woti kwa Nnu'ngu' kati mwenga mwabene mwamubile nambi'yambi'. ");
INSERT INTO mgw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Naatesike bandu ba ndi'la yi'no ata kwapanga babulagilwe kanaaboywa annalu'me kwa alwawa na kwataikulya kuutabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mpi'ndo wa dini na balasa lyoti liku'lu' lya api'ndo, bendakombwa kong'ondelya likowe lyo. Bu'ka kwabe, naapeyilwe balua yabaandikilwe balu' Ayahudi babaabile ku'lu' ku Damasiko. Naayi'i Damasiko li'nga nikaaboywe bandu ba ndi'la yo, na kwaleta Yelusalemu babile atabilwe li'nga bakapwatilwe. ");
INSERT INTO mgw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Panaabile mundi'la kanili'nga Damasiko, musaa sita ya muntwekati, niimukya bweya nku'lu' bu'ka kunani kaunimulika mundu mwoti. ");
INSERT INTO mgw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Apo nganitu'la pai', nganiyu'wa lilobe kalinibakia, ‘Sauli, Sauli! Mboni wendakunitesa?’ ");
INSERT INTO mgw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nganilaluya, ‘Wa bwana, wenga wanyai?’ Nembe nganibakia, ‘Nenga ngana Yesu ywaunitesa.’ ");
INSERT INTO mgw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bai, balu' bandu babaabile pamope nanenga, baaubweni wu'lu' bweya, lakini baaliyu'wineli li'lu' lilobe lya yu'lu' ywalongelage nanenga. ");
INSERT INTO mgw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Bai, nenga naatilaluya, ‘Bwana, nipange buli?’ Nembe Bwana aatinibakia, ‘Ukatuke, uyende ku Damasiko, akwo ukabakiyilwa makowe goti gopalilwa kugapanga.’ ");
INSERT INTO mgw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bu'kana na wu'lu' bweya nkali', nakombwili banjwa, kwa nyo yapalikwe balu' ayangu' banitandaye mpaka paniikite ku Damasiko. ");
INSERT INTO mgw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Akwo, kwaabile na mundu yumo ywabi'ngi'yage salya ya Musa munomuno na kunkilikitya Nnu'ngu'. Ywembe aatiisimilwa muno na Ayahudi babatamage Damasiko, lina lyake Anania. ");
INSERT INTO mgw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ywembe aaisi kunilola, ngayi'ma papipi yangu' ngabaya, ‘Wa nnongo wa Sauli! Ubanjwe kai'.’ Popopo, nganibanjwa kai' na kummona. ");
INSERT INTO mgw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ngabaya, ‘Nnu'ngu' wa au'ku' bitu akusawi upate tanga mwapala Nnu'ngu', kummona Mwene Aki, na kumpi'kania mwene kalongela. ");
INSERT INTO mgw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwa mwanjaa ukankong'ondelya wamwene kwa bandu boti, kawabakia galu' gaugabweni na kugayu'wa. ");
INSERT INTO mgw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bai, nambi'yambi' mboni wendasi'li'ya? Uyi'me, ukabatisilwe, ukagu'lu'li'lwe masambi gako, kaulu'ba kwa lina lyake Bwana.’ ");
INSERT INTO mgw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Panibuyangani ku Yelusalemu, kanisalya mu Nyumba ya Nnu'ngu' naagabweni makowe gayambi'. ");
INSERT INTO mgw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Naamweni Bwana kanibakia, ‘Uyu'mbi'ti'ke bu'ka ku Yelusalemu, kwa mwanjaa bandu ba pano baayi'ki'tyali gawalu'a kwabakia bu'kana na nenga.’ ");
INSERT INTO mgw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nani nganibaya, ‘Bwana, ata bembe batangite panga nenga nganiyendage ku mayumba goti ga kunnu'ba Nnu'ngu' li'nga kwayi'ya muutabilwe na kwaku'mbwa balu' babakuu'bi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Palu' payaayitanike myai ya nkong'ondeli wako Sitefano, nenga namwene naayi'mi pambwega, kaniyi'ki'tyana na sakipaangilwage, ku'no kanaali'ndi'lya magu'bo gabe abulagi.’ ");
INSERT INTO mgw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bwana ngaanibakia, ‘Uyende, kwa mwanjaa nilu'a kutuma kuutalu kwa bandu bangali Ayahudi.’” ");
INSERT INTO mgw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Si'lu' kipi'nga sa bandu saatikumpi'kania mpaka palu' paabaike likowe lyo, ngapabau'bu'ya malobe gabe kababaya, “Mummulage, mundu wa kubi nya apwaikali kunneka mwu'mi!” ");
INSERT INTO mgw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Baayendeli panga ndu'ti ku'no kabakung'unda makoti gabe no timwana lyu'ku'mbi' kwa nyongo muno. ");
INSERT INTO mgw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kolongosi ywa yesi aamulise bandu bake bampeleke Pauli nkati ya nyumba ya banayesi, aalagi panga bammese mikwasu mpaka aabakie kitumbu sa Ayahudi kumpangya ndu'ti. ");
INSERT INTO mgw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lakini pabaayomwi kuntaba li'nga batumbwe kummesa kwa mikwasu, Pauli aannalwiye asikali yumo ywaayi'mi po, “Buli, yendayi'ki'ti'lwa kwinu kummesa mikwasu mwenekaya ywa Roma wangali senulwa?” ");
INSERT INTO mgw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yu'lu' asikali paayu'wine go, ampeleki abali mpi'ndo ywa yesi kabaya, “Upala panga namani? Mundu yu' ngite mwenekaya wa Roma!” ");
INSERT INTO mgw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Bai, mpi'ndo ywa yesi aannyendeli Pauli kunnaluya, “Umbakie, wenga wa mwenekaya wa ku Roma?” Pauli ngayangwa, “Ngamwembe.” ");
INSERT INTO mgw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mpi'ndo ywa yesi aatibaya, “Nanenga nyinyonyo, nipatike wenekaya wa Roma kwo pi'ma kwa mbanje yansima.” Pauli ngabaya, “Lakini nenga namwenekaya ywa Roma bu'ka belekwa.” ");
INSERT INTO mgw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Balu' bandu babapalage kumpekeseni Pauli baatikunneka no bu'ka. Ata yu'lu' mpi'ndo ywa yesi pakwipwi panga antabike Pauli, mwenekaya ywa Roma, aatiyogopa muno. ");
INSERT INTO mgw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Pammalau' yake, kwa mwanjaa yu'lu' kolongosi ywa yesi apalage tanga kitumbu sa Pauli laumilwa na Ayahudi, aatikunnyu'gu'lya na kwalagya api'ndo ba dini na Balasa lyoti liku'lu' bakwembane. Bu'kapo, annyi'mike Pauli nnu'ngi' yabe. ");
INSERT INTO mgw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli aabu'nju'li minyo balu' bandu ba Balasa Liku'lu' aatibaya, “Mwalongo bangu', nenga kwo binia pamwoyo wangu', ntu'pu' so senulwa nnu'ngi' ya Nnu'ngu' mpaka pano panibile.” ");
INSERT INTO mgw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mpi'ndo ywa dini Anania aamulise balu' babaayi'mi papipi na Pauli banku'mbwe mbande pankano. ");
INSERT INTO mgw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bai, Pauli ngammakia, “Nnu'ngu' alu'a kuku'mbwa, wenga wawipanga wannogau, kumbe wannau. Wenga utami po kunisenwa nenga bu'kana na salya, nawenga witi'kwana salya kwa kuniku'mbwa nenga!” ");
INSERT INTO mgw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bandu babaayi'mi palu' ngabammakia Pauli, “Wenga ulowa kumpwi'wa mpi'ndo nku'lu' ywa dini ywa Nnu'ngu'!” ");
INSERT INTO mgw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli ngayangwa, “Mwalongo bangu', naatangiteli panga ywembe nga mpi'ndo ywa dini. Kwa mwanjaa iandikilwe, ‘Kaneunnongeli maakau kolongosi ywa bandu bako.’” ");
INSERT INTO mgw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pauli paakwipwi panga bi'ngi' baai Masadukayo na bi'ngi' Mafalisayo, aau'bwiye lilobe pa Balasa Liku'lu', “Mwalongo bangu', nenga na Mfalisayo, mwana wa Mafalisayo. Pano nenga nisitakilwa mwanjaa nipi'kanilya yu'ka kwa bandu babawile.” ");
INSERT INTO mgw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Payomwi longela go, ngabatumbwa gongwana Mafalisayo na Masadukayo, na Balasa Liku'lu' lyabaganike ipi'nga ibi'li'. ");
INSERT INTO mgw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kitumbu sene sai si'no, Masadukayo bau'bi'lya panga ntu'pu' yu'ka kwa ywawile, kai' ntu'pu' malaika, au loo, lakini Mafalisayo bagau'bi'lya ago goti. ");
INSERT INTO mgw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ndu'ti yatiyongeya, na bi'ngi' ba balimu ba salya bu'ka mukipi'nga sa Mafalisayo baayi'mi wi'ma no taukana kwa makakala, “Tukibonali kikowe sosoti sakibile kyakau kwa mundu yu', kwaali' loo au malaika aatilongela nakwe.” ");
INSERT INTO mgw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bulwe waai nku'lu', mpi'ndo ywa yesi aayogwipe panga balu'e kunnumia muno Pauli, ngaamulisa ipi'nga ya banayesi iuluke na kummu'ya Pauli pakatikati yabe kwa makakala na kunneta nkati ya nyumba ya banayesi. ");
INSERT INTO mgw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilo si'lu', Bwana aayi'mi papipi nakwe aatikummakia, “Ube na mwoyo nku'lu', kwa mwanjaa kati mwaunikong'ondeli ku Yelusalemu, ipalikwa ukanikong'ondeli nyaanyalu'nyalu' akwo ku Roma.” ");
INSERT INTO mgw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pakusile, Ayahudi baatami kitamo pamope na baabi'i nyalili panga, “Tulyali wala tunywali mpaka tummulage Pauli.” ");
INSERT INTO mgw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Na babaabi'i nyalili yo, baai bandu alubaini no pi'ti'li'ki'ya. ");
INSERT INTO mgw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Baayendeli api'ndo ba dini na alongosi no baya, “Twiitabite pamope kwa nyalili panga tulyaali mpaka tummulage Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Bai, mwenga pamope na api'ndo ba Balasa Liku'lu', mummakie kolongosi ywa yesi annete Pauli akwo kwamubile, ipange kati mupala tanga kinkati makowe gake na twenga twibi'i wiso kummulaga abile balo mundi'la.” ");
INSERT INTO mgw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini mwipwawe Pauli paliyu'wine likowe lyo lya kumpelemba, aayi'i ku'lu' kunyumba ya banayesi na kummakia Pauli likowe lyo. ");
INSERT INTO mgw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Apo Pauli ngankema asikali yumo na kummakia, “Untole mwinsembe yu' umpeleke kwa mpi'ndo ywa yesi abile na kikowe sa kummakia.” ");
INSERT INTO mgw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kwa nyo, yu'lu' asikali aampelike yu'lu' mwinsembe kwa mpi'ndo ywa yesi, ngammakia, “Pauli yu'lu' ntabilwe aatinikema na kunilu'ba ninnete ayu' mwinsembe kwaubile, kwa mwanjaa abile na likowe lya kukubakia.” ");
INSERT INTO mgw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mpi'ndo ywa yesi aankamwi luboko aywo mwinsembe na kumpeleka kuu'lu', ngannaluya, “Upala kunibakia namani?” ");
INSERT INTO mgw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yu'lu' mwinsembe ngabaya, “Ayahudi basikisine bakulu'be umpeleke Pauli ku Balasa Liku'lu' kabaku'pi'ki'ya, panga Balasa Liku'lu' lipala lipate abali ya nkati bu'kana na mundu ywo. ");
INSERT INTO mgw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lakini wenga kaneuyi'ki'ti kwa mwanjaa kubile na bandu babapi'ti'li'kiye alubaini, babile wi'ma li'nga kuntangya. Babi'i nyalili kotoka lya wala nywa kili'be sosoti mpaka bammulage Pauli. Tumbwelelo bai wi'ma, bakupi'kania mwaulu'a baya.” ");
INSERT INTO mgw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yu'lu' mpi'ndo ywa yesi annei mwinsembe aibu'ki kankwi'li'ka panga, “kaneummakie mundu ywoywoti makowe gano gaunibakiye.” ");
INSERT INTO mgw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Bai, yu'lu' mpi'ndo ywa yesi aakemite alongosi abi'li' ba yesi lyake na kwabakia, “Mubi'ke wiso banayesi 200, banayesi babau'bu'ka farasi 70, na banayesi babatumya mikwaa 200 bayende Kaisalia. Mutame wiso kwo bu'ka li'no saa itatu ya kilo. ");
INSERT INTO mgw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mubi'ke wiso farasi ba kumpu'twa Pauli li'nga akaike salama kwa ntawala Felisi.” ");
INSERT INTO mgw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Aywo mpi'ndo ywa yesi aamwandiki balua Felisi inyanya. ");
INSERT INTO mgw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nenga na Klaudio Lisia nikuandikya wenga wa mwisimiwa Felisi, wa mpi'ndo ywa nkoa. Salamu! ");
INSERT INTO mgw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Mundu yu' aaboyolilwe na Ayahudi li'nga kummulaga. Nenga panibakiyilwe panga ywembe mwenekaya wa Roma, naayi'i na kipi'nga sa banayesi kunkosopolya. ");
INSERT INTO mgw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nani nipalage tanga kitumbu sa Ayahudi kunsitakya, nganimwikiya ku Balasa lyabe Liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nganikwipwa panga bansitaki mwanjaa ntau waubu'kana na salya yabe, lakini aapangiteli likosa lyolyoti lyo senulwa waa, wala tabilwa. ");
INSERT INTO mgw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Panibakiyilwe panga Ayahudi baapangite ulau wo pala kummulaga, nganibinia kunneta kasako kiyu'ngu'ya, naalagi babapala kunsitakya sabasitaki kasako.” ");
INSERT INTO mgw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bai, balu' banayesi, kati mwabaabakiyilwe, bampu'twi Pauli kilo na kumpeleka Antipatili. ");
INSERT INTO mgw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pammalau' yake, balu' banayesi babayendage kwa magu'lu' ngababuyangania Yelusalemu kulua lwabe, kwaleka babayenda na farasi bayendeli pamope na Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pabaaikite Kaisalia, bampei mpi'ndo ywa nkoa yi'lu' balua, na kummi'ka Pauli mmoko gake. ");
INSERT INTO mgw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felisi paisomike balua yo, ngaalaluya panga mundu yu' abu'i kunkoa gani. Paabakiyilwe panga abu'ka ku Kilikia, ");
INSERT INTO mgw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ngabaya, “Naupi'kania mwalo wako pabaaisa babakusitakile.” Bu'kapo, ngaamulisa Pauli ali'ndi'li'lwe munyumba ya nkulungwa Helode. ");
INSERT INTO mgw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pagapite masu'ba matano, mpi'ndo ywa dini Anania aalongwaniye na alongosi nsi'si' na Telitulo nkengeli wa salya mpaka Kaisalia. Bannyendeli Felisi, Kolongosi ywa nkoa, li'nga bansitaki Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pabankemite Pauli, Telitulo aatumbwi kunsitakya kabaya. “Mundumuko Felisi, kwo pi'tya wenga tupatike likenge liku'lu', no bu'kana na mwautulongoya, nni'ma gu'no ugalambwike kwa manogau gambone. ");
INSERT INTO mgw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kwa goti, twendasukulu na kugapokya kila pandu na kila lisu'ba. ");
INSERT INTO mgw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini kanenisi'li'ye muno, nikulu'ba upi'kani kwa kiya sako, makowe maipi gatupala longela. ");
INSERT INTO mgw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tukwipwi panga mundu yu' ywakunng'andyali. Ngaywatumbwi kwayu'maniya Ayahudi boti padunia, kai' ywembe nga mpi'ndo ywa kipi'nga sa Anasaleti. ");
INSERT INTO mgw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kai' aapayite kualabiya upeleteu wa Nyumba ya Nnu'ngu', lakini twatikummoywa. ");
INSERT INTO mgw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na wamwene wendakombwa kumpekeseni wiso mundu ywo makowe gatunsitakilya.” ");
INSERT INTO mgw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayahudi nabembe ngabayi'ki'tyana na makowe go gakunsitakya Pauli kababaya panga goti ga kakape. ");
INSERT INTO mgw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na ntawala ampu'ngi luboko Pauli kati mwanju wa kunnyi'ki'ti'a alongele, nembe ngabaya, “Nenga ntu'pu' kyukala sosoti sa kwikengya nnu'ngi' yako, kwa mwanjaa nitangite panga wenga wa nsenuli ywa nni'ma gu'no bu'ka kwai'mbu'. ");
INSERT INTO mgw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wenga wamwene wendakombwa kwipwa panga ganapi'tali masu'ba ku'mi na gabi'li' bu'ka panaayi'i ku Yelusalemu kunnu'ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bandu ba banikolili nkati ya nyumba ya Nnu'ngu', wala mumayumba ga kunnu'ba Nnu'ngu', wala pandu popoti pamisengo kanitaukana na mundu au kanaabakia bandu bapange puyo. ");
INSERT INTO mgw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wala, bakombwali kong'ondelya makowe gabanisitakilya nambi'yambi'. ");
INSERT INTO mgw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila niyi'ki'tya likowe limo kasako, panga nintumikia Nnu'ngu' ywa au'ku' bitu no bi'ngi'ya ndi'la yi'lu' yabaibaya yo ubu'su'. Nenga niu'bi'lya kila kikowe sakiyi'ki'tyana na gagaandikilwe mu salya ya Musa na muitabu ya alondoli ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nenga niu'bi'lya kwa Nnu'ngu' kati mwabau'bi'lya bembe panga bandu boti, anogau na alau, baayu'ka. ");
INSERT INTO mgw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kwa nyo, nendakwikasa masu'ba goti tama maisa manogau wangali senulwa na mwoyo wangu', kwa Nnu'ngu' na kwa bandu. ");
INSERT INTO mgw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Bu'ka po tama myaka yambone kuutalu na nni'ma wangu', naaisi kwaletya alongo bangu' ba Kiyahudi babaabile akiba, kili'be sa kwayangatiya na salaka kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Panipangage makowe go, baanikoli munyumba ya Nnu'ngu', niyomwile panga ibala ya kwiipeletea. Naabileli na kipi'nga sa bandu wala puyo. ");
INSERT INTO mgw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakini palu', baabile Ayahudi bu'ka kunkoa wa Asia, bembe ngabapalilwage isa kasako, kunisitakya mana baalibweni likosa lyolyoti kwangu' nenga. ");
INSERT INTO mgw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au, bandu bababile pano babaye bene likosa lyabalibweni kwangu' nenga, pabaniyi'mike pa Balasa lyabe Liku'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ila likowe limo bai lyanilongei kwo tu'ndu'bi'a lilobe panaayi'mi, ‘Nenga li'no nisitakilwa mwanjaa niu'bi'lya panga, bababile kumambi', baayu'ka.’” ");
INSERT INTO mgw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bai Felisi, ywaabile aitangite ndi'la yi'lu' ya Yesu wisowiso, aamulise munaisa kabaya, “Naayomwa makowe ginu paaisa mpi'ndo ywa yesi Lisia.” ");
INSERT INTO mgw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nga mwamulisa yu'lu' asikali panga baanni'ndi'le Pauli amo muutabilwe, lakini banneke maulu pasene, na kanebaakanikie mambwigalye isa kumpeya saapala. ");
INSERT INTO mgw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pagaapite masu'ba, Felisi aaisi na nnyumbowe Dulusila, ywembe aai Nnyahudi. Aapiyite amuli akemelwe Pauli, aampi'kani abali ya imani yaibile kwa Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lakini, Pauli paalongelage abali ya aki, baa na uweso wa kugasinda maminyikiyo ga yi'ga, no bu'kana na ukumu yayaaisa, Felisi aapatike bwoga no baya, “Gautubakiye gali'ngani! Wendakombwa bu'ka. Panaakupala, naakukema.” ");
INSERT INTO mgw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kai', Felisi aakokoti kunkema Pauli no longela nakwe, aganiage alu'a kumpeya mbanje. ");
INSERT INTO mgw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Na payatimi myaka ibi'li', Polikio Fesito aayingi muutawala pandu pa Felisi, lakini mwanjaa Felisi apalage kwapulaisa Ayahudi, nganneka Pauli muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pagapite masu'ba gatatu bu'ka Fesito ika Kunkoa wa Kaisalia, ngau'bu'ka yenda ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ku'lu', api'ndo ba dini na alongosi ba Ayahudi ngabansitakya Pauli kwa Fesito. ");
INSERT INTO mgw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bampembelyage Fesito aapangi manogau kwa kwaletya Pauli ku Yelusalemu, kwa mwanjaa bapalage bannyu'bi'li li'nga bammulage mundi'la. ");
INSERT INTO mgw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesito ngayangwa, “Pauli endali'ndi'li'lwa muutabilwe akwo ku Kaisalia, na namwene niyenda kwokwo nambi'yambi'. ");
INSERT INTO mgw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bai, alongosi binu baeli nanenga bakansitaki mana apangite kikowe kilau mundu yu'.” ");
INSERT INTO mgw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Payomwi tama kwo masu'ba manane au ku'mi, Fesito aabuyangani ku Kaisalia. Pammalau' yake aatami pa kiti'gu' so senwa no amulisa Pauli aletelwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paaisi Pauli, Ayahudi babaaisi bu'ka ku Yelusalemu, baayi'mi papipi nakwe na kunsitakya kwa makowe matopau, gangali bembe kombwa kugaawanikiya panga kakape. ");
INSERT INTO mgw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pauli ngaikengya kwo baya, “Nenga nipangiteli ulau wowoti musalya ya Ayahudi, munyumba ya Nnu'ngu', ata kwa Nkulungwa wa Roma, Kaisali.” ");
INSERT INTO mgw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lakini Fesito kapala kwapulaisa Ayahudi, ngannaluya Pauli, “Buli, upala yenda ku Yelusalemu mwalo wako ukapi'kanilwe nnu'ngi' yangu' kwa kitumbu sa makowe gano?” ");
INSERT INTO mgw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauli ngabaya, “Nenga niyi'ma pano pakiti'gu' so senwa sa Kaisali, ngapanipalikwa senulwa. Naapangyali ulau Ayahudi, na wamwene utangite. ");
INSERT INTO mgw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Manaitei nikosite na nipangite ulau wo pwatilwa kiwo, nikanali bulagilwa. Lakini manaitei likowe lyabanisitakilya lya kakape lili, ntu'pu' ywakombwa kunikamukiya kasabe. Nikulu'ba mwalo wangu' nipeleke nnu'ngi' kwa Kaisali!” ");
INSERT INTO mgw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bai, Fesito payomwi longela mwalo wo na api'ndo bake ba Balasa Liku'lu', ngabannyangwa, “Upalike yenda nnu'ngi' kwa Kaisali. Bai, ulu'a yenda kwa Kaisali!” ");
INSERT INTO mgw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pagapite masu'ba nsi'si', Nkulungwa Agilipa na Belinike nnu'mbu'we baayi'i Kaisalia kunkemya Fesito. ");
INSERT INTO mgw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baatami kwo kwa masu'ba maingi, nembe Fesito ngammakia Agilipa mwalo wa Pauli, “Kubile na mundu yumo pano, ywembe Felisi aannei muutabilwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panaayi'i ku Yelusalemu, api'ndo ba dini na alongosi ba Ayahudi baanibakie makowe gake, kabanilu'ba ninsenwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lakini nenga naayangwi panga, kwa yali ya Kiroma, mundu apwatilwali mpaka ywasitakilwe akwembane na babaansitakile pamope, no peyelwa lisu'ba lya kwikengya kwa ulau wabansitakilya. ");
INSERT INTO mgw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bai, pabaaikite pano nasi'yiteli, pammalau' yake naatami pakiti'gu' sangu' so senwa no lagya aywo mundu aletelwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Na babansitakile pabaayi'mi, bapiyiteli ulau kati mwaniganiyage. ");
INSERT INTO mgw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ila, bendetaukana nakwe kwa makowe ga dini yabe, na kwa abali ya mundu yumo ywakemelwa Yesu. Ywembe aatiwaa, lakini Pauli ali'ndi'ndi'lya ai mwu'mi. ");
INSERT INTO mgw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kwa mwanjaa naatangiteli mwo pekeseni kakape ya mwalo wu', nannalwiye Pauli panga mana apala yenda ku Yelusalemu akapi'kanilwe kwo makowe ga mwalo gu'. ");
INSERT INTO mgw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Pauli palu'bike panga mwalo wake ukapi'kanilwe na Nkulungwa wa Roma, nganiamulisa ali'ndi'li'lwe musumba sa atabilwe mpaka panampeleka.” ");
INSERT INTO mgw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Bai, Agilipa ngammakia Fesito, “Nani napendike nikampi'kania mundu yu' namwene.” Fesito ngayangwa, “Walu'a kumpi'kania malau'.” ");
INSERT INTO mgw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bai, pammalau' yake Agilipa na Belinike baaisi kwo isimika muno pabayingyae muliku'ta lya mikutano, babile na alongosi ba yesi na api'ndo ba kilambo. Fesito ngaamulisa bannete Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesito ngabaya, “Nkulungwa Agilipa, na mwaboti mwamubile pano pamope na twenga! Ayu' mundu ywamummona, Ayahudi boti bansitaki kwangu' ku'lu' ku Yelusalemu na pano nyinyonyo, kabaku'ku'li'ka no panga ndu'ti panga ipalikwa abulagilwe. ");
INSERT INTO mgw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nenga naibweni panga apangiteli ulau wowoti wo pwatilwa kiwo. Lakini mwanjaa mwene aalu'bike mwalo wake ukapi'kanilwe na Nkulungwa wa Roma, nilu'a kumpelekya. ");
INSERT INTO mgw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nenga ntu'pu' likowe lya ngama lya kumwandikya Nkulungwa wa Roma kwa makowe gake, ngaapo ninnetike nnu'ngi' yinu, munomuno kwako wa nkulungwa Agilipa, pi'ngi' niwesa pata so andika bu'kana no pekeseni kwako. ");
INSERT INTO mgw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwa mwanjaa naapanga makosa kwa kumpeleka ntabilwe wangali awanikiya wisowiso sabansitakilile.” ");
INSERT INTO mgw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa ngammakia Pauli, “Lelo, wendakombwa longela makowe gako.” Bai, Pauli ngaapu'ngya luboko no tumbwa longela. ");
INSERT INTO mgw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nkulungwa Agilipa, inogelile muno nenga li'no yi'ma nnu'ngi' yako, kwikengya bu'kana na makowe goti Ayahudi gabanisitakile. ");
INSERT INTO mgw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nipulaika muno kwa mwanjaa wenga utangite mimu yoti ya Ayahudi na makowe gagaapanga bataukane, kwa nyo nikulu'ba ukomeye kwa kunipi'kania. ");
INSERT INTO mgw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ayahudi boti batangite mwanaatami kunni'ma wangu' bu'ka unng'elo wangu' na ata ku Yelusalemu. ");
INSERT INTO mgw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Baanitangite bu'ka kwai'mbu', na mana bapendile bakombwa kong'ondelya, panga naai na Mfalisayo kwa mu'lu' mwanibi'ngi'yage salya ngali' ya dini yitu. ");
INSERT INTO mgw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na nambi'yambi', niyi'ma pano senulwa kwa mwanjaa niliu'bi'lya li'lu' lilagano Nnu'ngu' lyaapei au'ku' bitu. ");
INSERT INTO mgw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Makabila gitu ku'mi na gabi'li' gantumikia Nnu'ngu' kilo na muntwekati kwa mwanjaa gau'bi'lya kugabona kagatimya galu' gagalagilwe. Na kwa kitumbu so u'bi'lya ku'lu', wa Nkulungwa, Ayahudi ngabanisitakya! ");
INSERT INTO mgw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mwanjaa namani mwenga mukana u'bi'lya panga Nnu'ngu' alu'a kwayu'ya babawile? ");
INSERT INTO mgw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kakape nenga namwene, naau'bi'lile panga nipalikwa kugapanga goti ganikombwa kwa kulilangamisa lina lya Yesu ywa ku Nasaleti. ");
INSERT INTO mgw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nani naagapangite go ku Yelusalemu. Panaapeyilwe amuli na api'ndo ba dini, naayingiye aumini bake baingi muutabilwe. Pabaasenulwe kiwo, nenga nayi'ki'tile babulagilwe. ");
INSERT INTO mgw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mala yambone naatikwaku'su'mbwa mumayumba ga kunnu'ba Nnu'ngu', na kwali'ndi'ndi'lya baikane imani yabe. Naatikwausikya kati niminya lilalu', na kwabi'ngi'ya kumili'ma ya kuutalu li'nga kwaku'su'mbwa. ");
INSERT INTO mgw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Bai, panaabile mulyengo lyo kaniyenda ku Damasiko kwa makakala ga api'ndo ba dini, ");
INSERT INTO mgw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","panaabile mundi'la muntwekati, wa Nkulungwa, niubona bweya nku'lu' kulikoni bweya wa lisu'ba kaubu'ka kunani. Bweya wu'lu' waatuti'li'tike twaboti twatwaabile mumwanja wu'lu'. ");
INSERT INTO mgw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twatu'i pai' twaboti, nganiyu'wa lilobe kalilongela nanenga kwa Kiyahudi, ‘Sauli, Sauli, mboni wendakunitesa? Wendakwilumia bai, kati ng'ombe ywayu'mana na pimbo ya bwana wake.’ ");
INSERT INTO mgw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nenga nganilaluya, ‘Wenga wanyai Bwana?’ Nembe Bwana ngayangwa, ‘Nenga ngana Yesu ywaunitesa. ");
INSERT INTO mgw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lakini ukatuke na uyi'me wi'ma lelo. Nikuisili li'nga upange wa ntumisi wangu'. Wenga walu'a panga wa nkong'ondeli wangu', wabakie bandu makowe gaugabweni li'no, na galu' ganaakulaya. ");
INSERT INTO mgw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nalu'a kukosopolya bu'ka mumaboko ga bandu bako Isilaili na ga bandu bangali Ayahudi, banaakutuma. ");
INSERT INTO mgw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Li'nga waabanjuye minyo gabe, kawaayi'gana babu'ke mulubi'ndu' na kwayingiya mubweya. Baabu'ke bu'ka pai' ya makakala ga Ibilisi na kunng'alambukya Nnu'ngu'. Kwa ndi'la yo u'bi'lya bapate samilwa masambi gabe no peyelwa ulisi pamope na bandu bake apeleteu.’ ");
INSERT INTO mgw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kwa kitumbu so, wa Nkulungwa Agilipa, nenga nipanga kati mwanilagilwe palu' panilaayilwe galu' gaganiisili bu'ka kunani. ");
INSERT INTO mgw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Lakini naatumbwi wi'ti' kwaalya benekaya ba Damasiko, nganiyenda ku Yelusalemu na Yudea, kai' na bandu bangali Ayahudi. Naalyage panga bagalambuke bu'ka mumasambi gabe li'nga bammuyangani Nnu'ngu', na babonekane kwa gabapanga panga bagalambwike. ");
INSERT INTO mgw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa kitumbu sa makowe go Ayahudi baaniboywi nibile munyumba ya Nnu'ngu' li'nga banibulage. ");
INSERT INTO mgw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bai, kwa mwanjaa nipatike uli'ndi'li bu'ka kwa Nnu'ngu', ata li'no nibile nnu'ngi' yinu kaninkong'ondelya mwalongosi na mwabandu bi'ngi' mwamunipi'kania li'no. Kai' nilongelali mayi'gi'yo gi'ngi' gayambi', ila galu' ga alondoli ba Nnu'ngu' na Musa gabaabaite panga gaapitya. ");
INSERT INTO mgw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yani, Kilisitu aapalikwe pata ngu'su'mbu' no panga nnongoi kwo yu'ka kwa boti babawile, naywembe alu'a ala, panga kwa ndi'la yake, bweya ulu'a mulika kwa Ayahudi na bangali Ayahudi.” ");
INSERT INTO mgw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauli paabile kaikengya nyo, Fesito ngammakia kwa lilobe liku'lu', “Wenga wa Pauli ubile na lilalu'! Akwo soma kwako muno ngakualabiye malango gako!” ");
INSERT INTO mgw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pauli ngannyangwa, “Mundumuko Fesito, nenga niminyali lilalu'. Makowe ganikubakia ga kakape na gampu'ku'bi'la. ");
INSERT INTO mgw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nkulungwa Agilipa aagatangite wiso makowe galu' gagapitike. Nanenga nendakombwa longela kaaniyu'wa wangali yogopa. Ndangite kakape panga makowe aga goti gatanganikwe kwake kwa mwanjaa gaaiyanikweli. ");
INSERT INTO mgw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wa Nkulungwa Agilipa, wendau'bi'lya mayi'gi'yo gabaalongei alondoli ba Nnu'ngu'? Ndangite panga wendau'bi'lya!” ");
INSERT INTO mgw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nembe Agilipa ngannyangwa Pauli, “Uwasa panga kwa mayi'gi'yo gako ga nambi'yambi' bai, wendakombwa kunigalambwa nenga panga na Nkilisitu?” ");
INSERT INTO mgw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauli ngannyangwa, “Manaitei kwa mayi'gi'yo masene au gambone, ninnu'ba Nnu'ngu', kwenda kwa wenga kisako bai lili, ila ata kwa aba boti babanipi'kania li'no babe kati nenga, lakini kanebaike po yingiyilwa muutabilwe!” ");
INSERT INTO mgw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Palongei go, Nkulungwa Agilipa, Mpi'ndo ywa Nkoa Fesito, Belinike na boti babaatami pamope nabo baayi'mi wi'ma. ");
INSERT INTO mgw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Na pabaabile kababu'ka, ngababakiana, “Mundu yu' apangiteli ulau wo pwatilwa kiwo, wala tabilwa.” ");
INSERT INTO mgw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa ngammakia Fesito, “Mundu yu' kwa kitumbu sa kuupeleka mwalo wake nnu'ngi' ukapi'kanilwe na Nkulungwa ywa Roma, ayu'gu'li'lwa lili.” ");
INSERT INTO mgw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bai, paiamulilwe yabwa mwanja wo yenda ku Italia, bammi'i Pauli na atabilwe bi'ngi' muuli'ndi'li wa Yulio ywaabile kolongosi ywa yesi mukipi'nga sakikemelwage “Kipi'nga sa Nkulungwa ywa Roma.” ");
INSERT INTO mgw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twau'bwike mumeli ya Adilamito yayaabile kaiyabwa pi'tya kumisengo ya kumbwani ya Asia. Twatumbwi mwanja witu tubile pamope na Alisitaliko, mwenekaya wa Makedonia bu'ka Tesalonike. ");
INSERT INTO mgw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pammalau' yake ngatuyi'ma Sidoni. Yulio aampangi kinannoga Pauli, kwa kunnyi'ki'ti'a akabonagane na mambwiga li'nga bapate kumpeya ili'be yaipalage. ");
INSERT INTO mgw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Bu'kapo, ngatuyingya kai' mubaali yendelya na mwanja witu. Ngatupi'ta lwingo lwa kisiwa sa Kuplo li'nga kuusega nsunga kwa mwanjaa upukatyage yenda kwatuuma. ");
INSERT INTO mgw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Patulokite baali kwiyi' ya kunkoa wa Kilikia na Pampilia, ngatuika kukilambo sa Mila, kunkoa wa Likia. ");
INSERT INTO mgw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ku'lu', yu'lu' mpi'ndo ywa yesi ngaikolya meli kaibu'ka Alesandulia kaiyenda Italia, nembe ngatuu'bu'ya nkati yake. ");
INSERT INTO mgw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twayendeli na mwanja mbolembole kwa masu'ba maingi. Mwanja waai wo kokona muno, ngatuika papipi na kilambo sa Nido. Na kwa mwanjaa nsunga utukanikiyage pi'ta mu'lu' mwatwabinile, ngatupi'ta lwingo lwa Kilete papipi na kumbwani ya Salumone, kwembe nsunga waai kwaani. ");
INSERT INTO mgw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twaapite katusega mbwega mbwega kwa tabu muno, ngatuika pandu papakemelwa Kiloko Kigolou, papipi na kilambo sa Lasea. ");
INSERT INTO mgw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twaatami palu' kwa masu'ba maingi. Lisu'ba lyo punga kwa Ayahudi paliyomwike pi'ta, na nsimu wa myanja ya mubaali pangali ntatala waapite. Pauli aatikwaking'inda kabaya, ");
INSERT INTO mgw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mwanalu'me, nibona panga mwanja witu ulu'a baa na ntatala na asala yambone, kai' kwenda kwa igombo na meli baili, ata kwa bwu'mi witu.” ");
INSERT INTO mgw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini yu'lu' kolongosi ywa yesi aagau'bi'li muno mayi'gi'yo ga ywailongoya meli na ga mwene meli kuliko gaalongei Pauli. ");
INSERT INTO mgw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na mwanjaa kiloko si'lu' saapwaikeli tama nsimu wa kipepwe, baingi baapiyite usauli wo paya baike Fonisi, pakiloko salama sa Kilete, kwo tama nsimu wa kipepwe. ");
INSERT INTO mgw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nsunga nsene pawaatumbwi pukatya bu'ka lwingo lwa kusi, bawasage panga bendakombwa timisa kati mu'lu' mwabaabinile. Ngabau'bu'ya kiyi'mi'kyo no yendelya mbwega mbwega papipi muno na Kilete. ");
INSERT INTO mgw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Popopo ngawisa nsunga nkali' bu'ka kisiwa sa Kilete, bandu baukemite nsunga wa “Eurakilo”. ");
INSERT INTO mgw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Meli ngaiku'mbu'lwa na nsunga nkali', na yakombwili yu'mana naso. Ngatulola minyo bai ikwakwatilwe na nsunga. ");
INSERT INTO mgw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Patwaabile katupi'ta lwingo lwa kisiwa sa Kauda, twapatike kwani pasene, kwa mwanjaa saatuibiliye na nsunga. Kwa nyo ngatukombwa kwitabya ngalaba ya mumeli, lakini kwa tabu. ");
INSERT INTO mgw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Apangakasi ba meli pabayomwi kwiyingiya ngalaba yi'lu' nkati ya meli, ngabakwi'ya no nyweletea lukamba kwitaba meli. Na mwanjaa bayogopage baakane kola mukyangi kwiyi' ya Libia, ngabauluya tanga na kwileka meli ikwakwatilwe na nsunga. ");
INSERT INTO mgw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Pammalau' yake, bu'kana na mwatunokolelwa kwa makakala ga nsunga, ngabatumbwa taikulya igombo mubaali. ");
INSERT INTO mgw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na lisu'ba lyenetatu, kwa moko gabe bene, ngabataikulya ata yombo ya meli mubaali. ");
INSERT INTO mgw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa masu'ba maingi lyaabonekineli lisu'ba ata ndondwa, na nsunga nku'lu' kauyendelya pukatya, twati'kwanike mwoyo ata u'bi'lya kwitu kwo kosopolelwa kwatioba. ");
INSERT INTO mgw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bandu pabaatami masu'ba maingi wangalya kili'be, Pauli ngayi'ma pakati yabe no longela, “Mwanalu'me, mukanipi'kania mwanammakie no munaisa bu'ka patwaabile ku Kilete, mulu'e kwiyingyali asala yo obeya ili'be kati yi'. ");
INSERT INTO mgw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lakini lelo nendakunnu'ba mukangamaye myoyo, kwa mwanjaa ntu'pu' ata mundu yumo pamubile ywaalu'a waa, meli bai ngailu'a sengwanika. ");
INSERT INTO mgw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwa mwanjaa kilo sa li'no, malaika wa Nnu'ngu' yu'lu' nenga naywake, naywembe nganinkilikitya, aatikuniisilya. ");
INSERT INTO mgw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Aatinibakia, ‘Pauli, kaneuyogope! Upalikwa uyi'me nnu'ngi' ya Nkulungwa. Na kwo pi'tya ngu'ngu' ya Nnu'ngu' kwako, boti baulongwaniye nabo kanebalanganyike.’ ");
INSERT INTO mgw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Bai, muku'le mwoyo, kwa mwanjaa nimwu'bi'lya Nnu'ngu' panga ilu'a pangika kati mwanibakiyilwe. ");
INSERT INTO mgw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini meli yitu ipalikwa ikole wi'ti' pakisiwa.” ");
INSERT INTO mgw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ata pakiikite kilo sa lisu'ba lya ku'mi na nsese, twanokolilwe na nsunga ku'no na kwo mubaali ya Adilia. Paiikite meku, apangakasi ba meli baawasite panga baaegeli kuuyu'mu'. ");
INSERT INTO mgw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Baali'ngite yendekeya kwa masi', ngabaibona mbi'ma alubaini. Pabaayendeli nnu'ngi' pasene, ngabaibona mbi'ma salasini. ");
INSERT INTO mgw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwo yogopa meli yaakane kola mumaliwe, ngabauluya iyi'mi'kyo nsese ya nsu'gu' ya meli, kabalu'bya kusee. ");
INSERT INTO mgw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Apangakasi ba meli bapalage tila na kwileka meli, ngabauluya ngalaba mubaali, kabaku'pi'ki'ya panga bapala uluya kiyi'mi'kyo sa nnu'ngi'. ");
INSERT INTO mgw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Pauli ngammakia kolongosi ywa yesi na asikali bake, “Bandu ba mana basomwi igala nkati ya meli, mwaalamali.” ");
INSERT INTO mgw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bai, asikali ngabaikutwana kamba yabatabili yi'lu' ngalaba na kwileka itumbuki mubaali. ");
INSERT INTO mgw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na papaabile kakusaa, Pauli aalu'bite bandu boti balye kilyo kabaya, “Mpaka li'no likite lisu'ba lya ku'mi na nsese mutami na kyukala na mulileli kili'be sosoti. ");
INSERT INTO mgw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bai, ninnu'banga mulye sakulya mupate yendelya lama. Mwanjaa nimmakianga, ntu'pu' ywaalu'a obeya ata lunywili lwa muntwe wake.” ");
INSERT INTO mgw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Payomwi longela go, Pauli aatweti likati na kunsukulu Nnu'ngu' nnu'ngi' ya boti, aatimetwa no tumbwa lya. ");
INSERT INTO mgw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Apo myoyo yabe ngaikangamala, nabembe ngabatumbwa lya sakulya. ");
INSERT INTO mgw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mayumu gitu, twaai twabandu mya ibi'li', sabini na sita nkati ya meli. ");
INSERT INTO mgw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pabaayukwite, ngabataikulya igombo ya ngano mubaali li'nga pu'ngu'ya utopau wa meli. ");
INSERT INTO mgw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Pakusile, apangakasi ba meli bautangiteli nni'ma wu'lu' lakini baalibweni lipala mubaali lyaliyingya kuuyu'mu'. Bai, baabini yenda yi'mi'ka meli mana ilu'e wesekana. ");
INSERT INTO mgw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Baakutwanie kamba yabaatabi kiyi'mi'kyo, no tomboloya lukamba lwabaatabi nsukani wa meli, no u'bu'ya tanga ya nnu'ngi' ikamwe nsunga li'nga kwikwakwata meli iyende kumbwani. ");
INSERT INTO mgw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini baaikite pa litu'ta lya kyangi na meli ngaikola. Nnu'ngi', meli yayingi mukyangi wangali tenandena. Nsu'gu', meli yaatumbwi ti'kwanika ipande ipande kwa makakala ga mabi'mbi'. ");
INSERT INTO mgw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asikali bapalage kwabulaga atabilwe boti baakane tila kwo u'gi'lya. ");
INSERT INTO mgw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini mwanjaa kolongosi ywa yesi apalage kunkengya Pauli, ngaakanikiya kanebapange nyo. Aamulise panga balu' babaamanyi u'gi'lya balongoli kwitaikulya mmasi' no loka mpaka kuuyu'mu'. ");
INSERT INTO mgw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na bi'ngi' babaigile baabi'ngi'ye kabakamuliya mumbago au muipande ya meli. Amo nga mwabaikite bandu boti kuuyu'mu' babile akoti. ");
INSERT INTO mgw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patuponagilwe kiwo, ngatukwipwa panga, twikite pakisiwa sakikemelwa Melita. ");
INSERT INTO mgw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Benekaya ba ku'lu' baatupangi manogau muno. Ula aatumbwi nia na kwaai na mbepo, kwa nyo bandu balu' baatukungani mwoto ngabatukemya tuyote. ");
INSERT INTO mgw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauli aayi'i tina anju, na paaisi kokeya pamwoto, nng'ambo ngapita pakatikati ya li'lu' liki'nda lya anju kaatila lyoto na kunnuma Pauli muluboko. ");
INSERT INTO mgw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Balu' benekaya pabaamweni nng'ambo yu'lu' kannuma muluboko lwake, ngababakiana, “Kakape mundu yu' mmulagi! Pamope no panga aponagilwe kiwo mubaali, balo nnu'ngu' ywakemelwa ‘Aki’ atimisa kiwo sake.” ");
INSERT INTO mgw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini Pauli ngankung'undya nng'ambo yu'lu' pamwoto na ampangiteli kili'be. ");
INSERT INTO mgw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bembe bawasage kwaali' alu'e imba au tu'la pai' kwa kiimuimu no waa. Pagapite masaa gambone na kummona ntu'pu' sakimpata, ngabagalambwa mawaso gabe no baya panga ywembe aai nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Papipi na palu' kwai na migunda ya mpi'ndo ywa palu' pa kisiwa ywaakemelwage Pubulio. Mundu yu' aatukemi kati twamambwigalye na kutupea pogonjo kwa masu'ba gatatu. ");
INSERT INTO mgw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tati' bake Pubulio baatigonja kwa mwanjaa baai na utamwe wo selenga myai na oma. Pauli ngayenda kunninga, ngabi'ka moko panani yake kunnu'bya, nembe ngayu'yu'ki'lwa. ");
INSERT INTO mgw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Bu'kana na lyo, atamwe boti ba pandu palu', baatiisa na ngabatepulilwa. ");
INSERT INTO mgw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bandu baatituisimu muno, na katubu'ka kwa ndi'la ya meli yendelya na mwanja witu, baatupei kila kili'be sakipalikwa mumwanja witu. ");
INSERT INTO mgw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Paipite myei itatu, twatumbwi kai' mwanja witu kwa meli yimo ya Alesandulia yaikemelwa “Kinnu'ngu' Mapaga.” Meli yo yaayi'mike mwanja wake kwa nsimu woti wa kipepwe. ");
INSERT INTO mgw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Twaikite kukilambo sa Silakusa, no tama kwo kwa masu'ba gatatu. ");
INSERT INTO mgw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Bu'ka ku'lu' ngatuyendelya na mwanja witu ngatuika kukilambo sa Lejio. Pammalau' yake nsunga ngautumbwa pukatya bu'ka kusi, mumwanja wa masu'ba gabi'li' ngatuika Puteoli. ");
INSERT INTO mgw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Akwo ngatwakwemba alongo ba aumini, nabembe ngabatukoka tutame pamope nabo kwa yuma yimo. Amo ngamwatuyi'i mpaka tuika Roma. ");
INSERT INTO mgw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aumini ba ku'lu' Roma pabaayu'wine abali yitu, baaisi kutupokya mpaka kusoko lya Apio na Mikaawa Itatu. Pauli paabweni, ngansukulu Nnu'ngu' no ng'ang'ala. ");
INSERT INTO mgw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patuikite Roma, Pauli aayiki'tilwe tama paakisake mwene, lakini na asikali yumo ywa kunni'ndi'la. ");
INSERT INTO mgw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pagapite masu'ba gatatu, Pauli aakemite api'ndo ba Ayahudi babatamage ku'lu'. Pabaisile ngaabakia, “Mwalongo bangu', nenga naatitabilwa ku'lu' ku Yelusalemu no kamukiyilwa mmoko ga Aroma, pamope no panga nipangiteli ulau wowoti kwa Ayahudi au kwo ti'kwana salya na yali ya au'ku' bitu. ");
INSERT INTO mgw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Aroma pabaapekesenile, balu'e kuniyu'gu'lya kwa mwanjaa banibwenili na lilau lya kunisenwa kiwo. ");
INSERT INTO mgw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Ayahudi pabaakani nenga lekekeyelwa, nganilu'ba mwalo wangu' ukapi'kanilwe na Nkulungwa ywa Roma. Kwa gano goti, nenga nibinili kwasitakya Ayahudi ayangu'. ");
INSERT INTO mgw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwa nyo, saninkemya li'nga tubonagane na nilongele na mwenga. Nitabilwa na pingwi yi'no kwa kitumbu sa yu'lu' ywatumpi'kanilya na Baisilaili.” ");
INSERT INTO mgw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Balu' ngabannyangwa, “Twenga tunapokyali balua yaikulongelya wenga bu'ka ku Yudea, wala nnongo Nnyahudi ywaisi ku'no kutubakia ulau wowoti. ");
INSERT INTO mgw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini twapendi pi'kania mwauwasa, kwa mwanjaa tutangite panga, kila pandu bendakikana kipi'nga sako.” ");
INSERT INTO mgw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Baasikisine lisu'ba lyo kwembana na Pauli. Lisu'ba lyo baamwisili bandu baingi panyumba yatamage. Bu'ka kindai' mpaka kitamwiyo, Pauli aabakie makowe maingi pamope na kwakong'ondelya makowe ga Ukulungwa wa Nnu'ngu'. Abiniage bau'bi'li abali ya Yesu, katumya mayi'gi'yo ga salya ya Musa na itabu ya alondoli ba Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bi'ngi' baagau'bi'lile makowe gaalongei, na bi'ngi' baagau'bi'li lili. ");
INSERT INTO mgw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Na pabaabile kababu'ka wangali yi'ki'tyana, Pauli aayongiye kwabakia, “Loo Mpeleteu aalongei kakape kwa au'ku' binu kwa ndi'la ya nnondoli ywa Nnu'ngu' Isaya, ");
INSERT INTO mgw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","kabaya, ‘Uyende kwa bandu ba ukaabakie, Mwayendelya yu'wa, lakini mwaatangali, Mwayendelya lola, lakini mwakibonali samulolase. ");
INSERT INTO mgw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwa mwanjaa myoyo ya bandu ba itenonopa, na makutu gabe matopau kwo yu'wa, minyo gabe gatiwiliwitya. Ikapanga nyoli, balu'e lola kwa minyo gabe, balu'e yu'wa kwa makutu gabe, balu'e tanga kwa malango gabe, Na kunigalambukya, nanenga nilu'e kwakosopolya.’ ");
INSERT INTO mgw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Kwa nyo mutange panga abali yi'no yo kosopolelwa na Nnu'ngu' itumilwe ialilwe kwa bandu bangali Ayahudi, nabembe baalu'a pi'kania!” ");
INSERT INTO mgw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pauli aatami munyumba yo panga kwa myaka ibi'li'. Aakemi bandu boti babaaisi kunkaulya. ");
INSERT INTO mgw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Aabile kaala abali ya Ukulungwa wa Nnu'ngu' na kwayi'gana bandu abali ya Bwana Yesu Kilisitu wangali yogopa wala kanikiyilwa.");
INSERT INTO mgw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Balua yi' iandikilwe na nenga na Pauli kwo yangatiyana na nnongo witu Sositene. Naakemilwe panga na ntumilwe wa Yesu Kilisitu bu'kana na mwabini mwene Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Tumwandikyanga mwenga mwamubile mwa likanisa lya Nnu'ngu' lya Kolinto, mwamupeleteyilwe kwo lu'mbana kwinu na Kilisitu Yesu. Ngamukemelwa mube mwapeleteu bake Nnu'ngu' pamope na bandu boti babalitambwa lina lya Bwana witu Yesu Kilisitu, ywembe nga Bwana wabe na Bwana witu. ");
INSERT INTO mgw_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ngu'ngu' na amani yaibu'ka kwa Nnu'ngu' Tati' bitu na kwa Bwana witu Yesu Kilisitu, ibe pamope na mwe. ");
INSERT INTO mgw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ninsukulu Nnu'ngu' wangu' masu'ba goti kwinu mwenga, kwa kitumbu sa ngu'ngu' ya Nnu'ngu' yamupeyilwe kwa ndi'la ya Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Kwa kitumbu so lu'mbana na Kilisitu, muyaliwite muulongeli woti na muutangi woti, ");
INSERT INTO mgw_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","kwa mwanjaa ukong'ondeli watunnetile nkati yinu bu'kana na Kilisitu ulaya ukakape. ");
INSERT INTO mgw_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Kwa nyo, mupu'ngu'kilweli na upo yoyoti ya kiloo pamuli'nda kwa kilu'lu' bonekana kwa Bwana witu Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ywembe aalu'a kumpanga mukangamale mpaka kuundi'la, li'nga kane mube na makosa lisu'ba li'lu' lyoisa kwake Bwana witu Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Nnu'ngu' ywau'bi'li'ka ngaywaankemite mwenga mutame mukiselele pamope na Mwana wake Yesu Kilisitu Bwana witu. ");
INSERT INTO mgw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Mwalongo bangu', nendakunnu'banga kwa lina lya Bwana witu Yesu Kilisitu mwaboti muyi'ki'tyane, kanekube na mayu'mano pakati yinu, na muganiye pamope kwa galu' gamugabinia. ");
INSERT INTO mgw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Kwa mwanjaa nibakiyilwe na bandu ba munyumba ya Kloe panga kubile na mayu'mano pakati yinu. ");
INSERT INTO mgw_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Bai, pano nilombolya panga kila mundu wa kasinu alongela lya kisake, yumo abaya, “Nenga na ywa Pauli,” ywi'ngi', “Nenga na ywa Apolo,” ywi'ngi', “Nenga na ywa Petili,” na ywi'ngi', “Nenga na ywa Kilisitu.” ");
INSERT INTO mgw_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Buli, Kilisitu aatibaganika? Buli, Pauli aabambilwe kwa kitumbu sinu? Au mwaabatisilwe kwa lina lya Pauli? ");
INSERT INTO mgw_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ninsukulu Nnu'ngu' kwa mwanjaa nimmatisikeli mundu ywoywoti kasinu ila Kilisipo na Gayo, ");
INSERT INTO mgw_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Kwa nyo, ntu'pu' ywawesa baya panga abatisilwe kwa lina lyangu'. ");
INSERT INTO mgw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Lakini niku'mbu'kile panga, naabatisike na bandu ba munyumba ya Stefana, bu'ka pa bo nitangiteli panga naammatisike na mundu ywi'ngi'.) ");
INSERT INTO mgw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kwa mwanjaa, Kilisitu aanitumikeli li'nga nibatise, ila niale Abali Inannoga, kai' niale pangali u'bi'lya ikima ya bandu, li'nga kiwo sa Kilisitu munsalaba sakane obeya makakala gake. ");
INSERT INTO mgw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kwa mwanjaa maalo ga kiwo sa Yesu munsalaba kwa balu' babaoba baibona ulogeloge bai, lakini kwitu twenga twatukosopolelwa, galaya makakala ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Kwa mwanjaa maandiko mapeleteu gabaya, “Naialabiya ikima yabe bene ikima, na kugataikwa malango ga bene malango.” ");
INSERT INTO mgw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Bai, tubaye buli bu'kana na bene ikima, balimu ba Salya ya Musa, au alongeli ba masu'ba gano? Nnu'ngu' alayite panga ikima ya dunia yi'no ulogeloge bai. ");
INSERT INTO mgw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Nnu'ngu' mu ikima yake, aabini kwakosopolya balu' babau'bi'lya kwa ndi'la ya maalo gatuala, gagabonekana kwabe panga ga kilogeloge. Aapangite nyalu' kwa mwanjaa kwa ndi'la ya ikima ya kimundu, bandu baakombwili kuntanga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayahudi bapala mwanju li'nga bau'bi'li, na Ayunani bapala ikima. ");
INSERT INTO mgw_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Lakini twenga tuala abali ya Kilisitu ywabambilwe munsalaba, likowe li' kwa Ayahudi kiku'balo na kwa Ayunani ibonekana ulalo. ");
INSERT INTO mgw_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Lakini kwa balu' babakemilwe na Nnu'ngu', babe Ayahudi au Ayunani, Kilisitu nga makakala ga Nnu'ngu' na kai' nga ikima ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Kwa mwanjaa sakibonekana na bandu panga ulogeloge, kwa Nnu'ngu' kibile na ikima kulikoni ikima ya bandu, na ukigopi wa Nnu'ngu' ubile na makakala kulikoni makakala ga bandu. ");
INSERT INTO mgw_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Mwalongo, muku'mbu'ki pamwakemilwe na Nnu'ngu'. Kwa kili'ngo sa kimundu mwabamboneli mwamwaabile na ikima, makakala, wala mubelekwili mumisengo yene yeo, wala yo isimika. ");
INSERT INTO mgw_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Lakini Nnu'ngu' aaisawi ikowe ya kilogeloge ya mudunia yi'no li'nga kwapeya oni bene ikima, kai', Nnu'ngu' aaisawi ikowe ya ukigopi ya mudunia yi'no li'nga kwapeya oni bene makakala. ");
INSERT INTO mgw_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Nnu'ngu' aaisawi ikowe yangaliisimilwa na yaisalaulilwa mudunia yi'no, ikowe yangali maana, li'nga aialabiye ikowe yabaibona ya maana. ");
INSERT INTO mgw_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Aapangite nyo li'nga kaneabe mundu ywakwipuna nnu'ngi' ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Lakini Nnu'ngu' annu'mbaniye na Kilisitu Yesu na kumpanga ikima yitu bu'ka kwa Nnu'ngu'. Kwa ndi'la ya Kilisitu tubalangilwa aki kwa Nnu'ngu' no pangilwa twapeleteu ba Nnu'ngu', no kosopolelwa bu'ka mumasambi gitu. ");
INSERT INTO mgw_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kati mu'lu' mwagabaite Maandiko Mapeleteu panga, “Ywapala kwipuna, aipune kwa kitumbu sa Bwana.” ");
INSERT INTO mgw_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Mwalongo bangu', panaaisi kasinu kumwalya iyo ya liyi'gi'yo lya Nnu'ngu', naisi lili kwa ung'anga wo longela au kwo tumya ikima ya dunia yi'no. ");
INSERT INTO mgw_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Kwa mwanjaa panaabile kasinu naabini kanenilitange likowe li'ngi', ila abali ya Yesu Kilisitu ywabambilwe munsalaba bai. ");
INSERT INTO mgw_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Panaabile kasinu naabi na kigopi, kaniyogopa no lendema muno. ");
INSERT INTO mgw_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Mayi'gano na maalo gangu' gaapiyilweli kwa mayi'gi'yo ga kwauta bandu, au ikima, ila galayage uweso wa Loo wa Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","li'nga imani yinu yaakanesengelwa muikima ya kimundu, ila mumakakala ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ata nyo twenga tulongela kwa ikima kwa balu' babakomile loo yabe, lakini ikima yo ya pano padunia yi'noli, wala ya akulungwa ba dunia yi'no ya bababile mulikundi lyo oba. ");
INSERT INTO mgw_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ila twenga tulongela ikima ya Nnu'ngu' yembe nga iyo yaiyilwe na Nnu'ngu' yayaabi'kilwe wiso kubile balo ata umbilwa kwa dunia kwa kitumbu sa utukupu witu. ");
INSERT INTO mgw_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ntu'pu' ata nkulungwa yumo ywa mudunia yi'no ywaaitangite ikima yi'. Kenda bakaitanga ikima yo, balu'e kummambali munsalaba Bwana wa utukupu. ");
INSERT INTO mgw_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Lakini kati mu'lu' mwagabaya Maandiko Mapeleteu panga, “Makowe gangali bonekana na liyo, ata lisikilo linagayu'wali, makowe gangali ganiyilwa na mundu ywoywoti, ago nga galu' Nnu'ngu' aabi'ki wiso babampenda.” ");
INSERT INTO mgw_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Lakini Nnu'ngu' aatuumukuli twenga iyo yi'lu' kwa ndi'la ya Loo wake, kwa mwanjaa Loo apekeseni ili'be yoti, ata makowe ga nkati muno ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Nyai ywatanga gawasa mundu ywi'ngi' ila loo ya mwene mundu yaibile nkati yake? Nyinyonyo, ntu'pu' ywatanga gawasa Nnu'ngu', ila Loo wa mwene Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Kwa nyo, twenga tupokili loo wa padunia, ila tupoki Loo ywabu'ka kwa Nnu'ngu' li'nga tupate kugatanga galu' gatuyali Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Bai, twenga tulongelali kwa mayi'gi'yo gatuyi'ganilwe kwa ikima ya kimundu, ila gatuyi'ganilwe na Loo mpeleteu. Tugalongela mayi'gi'yo ga kiloo kwa bandu bababile na aywo Loo. ");
INSERT INTO mgw_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mundu wa dunia apokyali makowe ga Loo wa Nnu'ngu' kwa mwanjaa kwake ywembe makowe go ga kilalo bai. Malango gake gawesali kwipwa makowe go, ila gawesa kwipulwa kwo yangatiyilwa na Loo bai. ");
INSERT INTO mgw_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Lakini mundu ywatawalilwa na Loo wa Nnu'ngu' awesa kuukwipwa ukakape wa kila kili'be, lakini ywembe aukumilwali na mundu ywoywoti. ");
INSERT INTO mgw_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Kati mwagabaya maandiko, “Nyai ywatangite mwawasa Bwana li'nga apate kunnyi'gana?” Lakini twenga tuwasa kati mwawasa Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Kakape mwalongo bangu', niwesiteli longela na mwenga kati mwabandu mwamutawalilwa na Loo wa Nnu'ngu', ila kati mwabandu mwamutawalilwa na makowe ga mudunia. Mukabalo mwabana ilekeleke mumaisa ga Kikilisitu. ");
INSERT INTO mgw_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Nanki'ngiye mabele wala nannyakiyeli kilyo kinonopau. Naapangite nyo kwa mwanjaa mwaai munaikali po lya kilyo so. Eloo, ata nambi'yambi' mukiwesali. ");
INSERT INTO mgw_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Mwenga ata nambi'yambi' mwabandu ba iyendo ya payi'ga, kwa mwanjaa kasinu kubile na bwigu no pitiniana, ago galaya panga mwenga mwabandu ba mudunia, kai' iyendo yinu ya bandu ba payi'ga. ");
INSERT INTO mgw_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kwa mwanjaa yumo ywinu pabaya, “Nenga na ywa Pauli,” na ywi'ngi', “Nenga na ywa Apolo,” buli! Ago galayali panga mwenga mukabalo panga kati mwabapanga bandu ba dunia yi'no? ");
INSERT INTO mgw_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Bai, Apolo nga nyai? Na Pauli nga nyai? Twenga twaboti twatumisi li'nga kunnaya mwenga ndi'la ya u'bi'lya. Kila yumo ywitu apanga lyengo lyapeyilwe na Bwana. ");
INSERT INTO mgw_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Nenga naapandike mbeyu, Apolo ngaiyitya masi', lakini Nnu'ngu' ngaywaipangite iku'le. ");
INSERT INTO mgw_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Kwa nyo, ywapandike na ywayiti masi' boti kili'be lili, ila ywangama Nnu'ngu' ywaipangite iku'le. ");
INSERT INTO mgw_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Yu'lu' ywapandike na ywayiti masi', boti balekineli, lakini kila mundu aapokya upo yake bu'kana no kasana kwake mwene. ");
INSERT INTO mgw_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Twenga twabi'li' tupangite kiyangatani na Nnu'ngu' mulyengo lyake, na Likanisa nga lyengo lya Nnu'ngu'. Kai', mwenga mwa nyumba yake. ");
INSERT INTO mgw_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kwo bu'kana na ngu'ngu' yanipeyilwe na Nnu'ngu' nipange kati nansengi nku'lu' mwene ikima, naabi'i nsingi. Nambi'yambi' mundu ywi'ngi' asenga panani yangu'. Lakini yendapwaika panga kila mundu alinguli wiso mu'lu' mwasenga panani yake. ");
INSERT INTO mgw_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Kwa mwanjaa ntu'pu' mundu ywoywoti ywawesa bi'ka nsingi wi'ngi' ila wu'lu' waubi'kilwe, nawembe nga Yesu Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Lakini mana mundu asengite panani ya nsingi wo kwa zaabu au madini ga mbanje au maliwe ga samani au mikongo au manyei au kipelei, ");
INSERT INTO mgw_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","lyengo lya kila mundu lyabonekana pangali iya lisu'ba li'lu' lya ukumu. Kwa mwanjaa lisu'ba li'lu' lyapitya pakati ya mwoto, na mwoto wu'lu' ngawalu'a li'nga no laya mwalibile lyengo lya kila mundu. ");
INSERT INTO mgw_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Manaitei sasengite mundu saigala, mundu ywo aapokya upo yake bu'ka kwa Nnu'ngu', ");
INSERT INTO mgw_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","lakini mana si'lu' sasengite satinika, ywembe aapatali upo. Ata nyo mwene aakosopolelwa, kati mundu ywalopolilwe bu'ka pamwoto. ");
INSERT INTO mgw_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Buli, mutangiteli panga mwenga mwa nyumba ya Nnu'ngu' na Loo wa Nnu'ngu' atama nkati yinu? ");
INSERT INTO mgw_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Bai, mundu mana asengwaniye nyumba ya Nnu'ngu', Nnu'ngu' aalu'a kunnangamisa nyinyonyo. Kwa mwanjaa nyumba ya Nnu'ngu' mbeletau, na mwenga nga mwanyumba yake. ");
INSERT INTO mgw_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Mundu ywoywoti pakati yinu kaneaikonge mwene panga abile na ikima. Mana mundu kaaibona abile na ikima ya mudunia yi'no, aipange nnalo li'nga apate baa na ikima ya kweli. ");
INSERT INTO mgw_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Nilongela nnya kwa mwanjaa ikima ya dunia yi'no kwa Nnu'ngu' ibonekana ulalo bai. Kati mwagabaya Maandiko Mapeleteu panga, “Nnu'ngu' aayonja bene ikima muung'anga wabe bene.” ");
INSERT INTO mgw_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Kai' gabaya, “Bwana Nnu'ngu' agatangite mawaso ga bene ikima panga, gapwaikali.” ");
INSERT INTO mgw_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Kwa nyo, mundu kaneaipuni bandu kwa mwanjaa kila kili'be nga sinu. ");
INSERT INTO mgw_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Apange Pauli, abe Apolo, au Petili. Ibe ya mudunia yi'no, au ukoto, au kiwo, ibe yaibile nambi'yambi', au yayalu'a isa, yoti nga yinu. ");
INSERT INTO mgw_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Mwenga mwa ba Kilisitu, na Kilisitu ywa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Bai, bandu batubalangili panga twenga twaatumisi ba Kilisitu tukamukiyilwe lyengo lyo aala abali ya Nnu'ngu' yayaiyilwe. ");
INSERT INTO mgw_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Apo, sakipalikwa kwa mundu ywoywoti ywakamukiyilwe lyengo lyo, au'bi'li'ke. ");
INSERT INTO mgw_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Lakini kwangu' nenga ukumilwa na mwenga wala na mankama ya bandu, kili'be li. Kai' ata namwene niiukumuli. ");
INSERT INTO mgw_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Kwa mwanjaa nikibonali kitumbu sa kwiukumu namwene, lakini kwo baya nyo, nilombolyali panga nenga ntu'pu' likosa. Ywaniukumu nenga mwene Bwana. ");
INSERT INTO mgw_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Kwa nyo, mwenga kanemuukumu kubile balo timya nsimu wake. Muli'nde mpaka lisu'ba lyaaisa Bwana Yesu. Ywembe ngaalu'a kwimulika ili'be yoti yaiyilwe mulubi'ndu' no laya mabinio ga myoyo ya bandu. Nsimu wo, kila nkilisitu aapokya liposo lyabile nalyo bu'ka kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Mwalongo bangu', makowe goti ganilongei gabu'kana na nenga na Apolo, yaai li'nga mwiyi'gane mayi'gi'yo gagabaya, “Kanemwu'mbe gagaandikilwe mu Maandiko Mapeleteu.” Mana mwaubi'ngi'ya nnongelo wo, aalu'a bonekanali mundu ywaalu'a kwipunia mundu yumo na kummawa ywi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Tumbwelelo, nyai ywakupangite wenga ube wa mundu wo pwaika muno kulikoni bi'ngi'? Ki'li'gani saubile naso sangalipeyelwa na Nnu'ngu'? Manaitei mutepeyelwa, mwanjaa namani mwilumba kati mupatike kwa makakala ginu mwabene? ");
INSERT INTO mgw_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Mwiwasilya panga muyomwike pata kila kikowe samukipala! Au muyomwike tayilika no pangika mwakulungwa pangali twenga! Ilu'e panga male mukapangilwa mwakulungwa kwa mwanjaa tulu'e baa twaakulungwa pamope na mwenga. ");
INSERT INTO mgw_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Lakini nibona panga Nnu'ngu' atupangite twatumilwe tube twabandu ba kuundi'la kati atabilwe babaukumilwe kiwo. Tuyi'mi'kilwe munsisingwa wa tabulu li'nga tupange mandi'ya kwa dunia yoti itubone, kwenda kwa bandu bai lili, lakini na ata malaika. ");
INSERT INTO mgw_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Kwa kitumbu sa kuntumikiya Kilisitu, bandu batubona twenga twalalo, lakini mwenga mwibona mwabene ikima kwa kitumbu sa kummi'ngi'ya Kilisitu. Twenga tubonekana twakikigopi, lakini mwenga mwibona mubile na makakala. Mwenga mwibona panga mwendaisimika, lakini twenga twendasalaulilwa. ");
INSERT INTO mgw_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Mpaka nambi'yambi'no, twenga ntu'pu' kilyo na tubile na nnyota na buula. Mala yambone twendaku'mbu'lwa na ntu'pu' potamo. ");
INSERT INTO mgw_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Tupanga kasi kwo kasana kwa maboko gitu. Bandu pabatutukana, tunnu'ba Nnu'ngu' aayali. Bandu pabatupangya maakau, twendakwakomeya. ");
INSERT INTO mgw_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Bandu pabatuku'pi'ki'ya, twayangwa kwo tu'lya, lakini bandu bayendelya kutupanga kati undi ya padunia na kwa kila mundu, twenga twasapu. ");
INSERT INTO mgw_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nimmakiyanga ga kwa kitumbu sa kumpeyanga oni lili, ila kunkwi'li'ka kati mwabana bangu' banaapenda. ");
INSERT INTO mgw_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Pamope no panga mubile na balimu maku'mi elupu mu Kilisitu, lakini mubileli na tati' bambone. Kwo pi'tya Abali Inannoga, nenga naapangike na tati' kasinu kwa Kilisitu Yesu. ");
INSERT INTO mgw_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Kwa nyo, nendakunkong'ondelya muno panga muyige mwanipanga nenga. ");
INSERT INTO mgw_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Alyo ngalyalinipangite nintume Timoteo kasinu, ywembe mwana wangu' ywanimpendile na ywau'bi'li'ka mulyengo lya Bwana. Ywembe aalu'a kunku'mbu'ki'ya mu'lu' mwanibi'ngi'ya nenga kwo lu'mbana na Kilisitu na mwaniyi'gana bandu kila pandu mumakanisa goti. ");
INSERT INTO mgw_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Bi'ngi' binu bendakwipuna kabawasilya panga naaisali kuntyangilya kai'. ");
INSERT INTO mgw_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Lakini mana Bwana apendile naaisa kasinu kiyu'ngu'ya, kwenda nitange makowe gabalongela abo babaipuna baili, ila no tanga makakala gabe. ");
INSERT INTO mgw_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Kwa mwanjaa ukulungwa wa Nnu'ngu' ubonekanali kwa mayi'gi'yo bai, ila na kwa makakala. ");
INSERT INTO mgw_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Mwenga mubaye mwabene, buli, niise kasinu kwa mapimbo, au niise kwa loo ya upendo na kwo liya? ");
INSERT INTO mgw_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Nipendili kugau'bi'lya makowe gagayu'wanika panga, pakati yinu kubile na upege. Upege kati wo unabonekanali ata kwa bandu bangali kuntanga Nnu'ngu', panga mundu atyangite na nnyumbo wa tati' bake. ");
INSERT INTO mgw_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Mwenga mwendakwipuna! Mwapalikwe mulombole na kummi'nga mukipi'nga sinu mundu ywapangite ulau wo! ");
INSERT INTO mgw_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Pamope no panga nibile kuutalu na mwenga, lakini tubile pamope kwa ndi'la ya loo. Na niyomwike kumuukumu mundu ywo kati namundu nanibile pamope namwenga. ");
INSERT INTO mgw_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Pamukongolekana pamope kwa lina lya Bwana Yesu, nanenga nibile pamope na mwenga kwa loo, na uweso wa Bwana Yesu ubile pakati yinu. ");
INSERT INTO mgw_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Apo, mundu ywo mummu'ye kasinu na kunneka muutawala wa Ibilisi li'nga bwu'mi wake walabike, na loo yake yaakosopolelwe lisu'ba lyo buyangana kwa Bwana Yesu. ");
INSERT INTO mgw_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Kwipuna kwinu kupwaikali. Buli, mutangiteli panga ngelule njene bai iwesa kuulu'ya bwembe woti? ");
INSERT INTO mgw_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Mubu'ye ngelule ya masambi ga kwai'mbu' mu bwembe wawinyatilwe, apo mwaapanga mwabandu baayambi' kati bwembe wawinyatilwe wangali ngelule, kwa mwanjaa Kilisitu mwana ngondolo witu wa Pasika ayomwike piyilwa panga salaka. ");
INSERT INTO mgw_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Kwa nyo, tupange kalamu yitu pangali tumya likati lyene ngelule ya kwai'mbu', yaani ya mabinio maakau na ulau. Ila tutumi makati gangalu'la, kwo lombolya mabinio ganannoga na ukakape. ");
INSERT INTO mgw_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Naamwandiki mubalua yangu' panga kanemupange kiselele na bandu apege. ");
INSERT INTO mgw_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Apo nilombolyali panga kanemuyangatiyane na bandu ba dunia yi'no, kwa mwanjaa mulu'e palikwa ama mudunia yi'no li'nga mube kuutalu na apege, au asoyo na apokonyoli, au babakilikitya inyago. ");
INSERT INTO mgw_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Pano nilombolya panga, kanemupange kiselele na mundu yu'lu' ywaibaya panga Nkilisitu ku'no kayendelya na upege, usoyo, kilikitya inyago, ntukani, nnobyawi'mbi' au mpokonyoli. Mundu kati ywo kanemuyi'ki'ti ata lya nakwe. ");
INSERT INTO mgw_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Bai, lyengo lyangu' lili kwaukumu bababile panja ya kipi'nga sa aumini. Mupalikwa kwaukumu bababile mukipi'nga sinu. ");
INSERT INTO mgw_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Nnu'ngu' aalu'a kwaukumu abo bababile panja. Maandiko gabaya, “Mwenga mummu'ye aywo mundu nnau pakati yinu.” ");
INSERT INTO mgw_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Manaitei pakati yinu kubile na mundu mwene mwalo na nnyine, mwanjaa namani apeleka mwalo wake kwa bandu bangali aumini paali pa kumpeleka kwa apeleteu ba Nnu'ngu'? ");
INSERT INTO mgw_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Au mutangiteli panga apeleteu ngabaalu'a kwiukumu dunia? Manaitei dunia yaukumilwa na mwenga, mwanjaa namani mukotoka ukumyana ata kwa makowe masini? ");
INSERT INTO mgw_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Mwenga mutangiteli panga twalu'a kwaukumu ata malaika? Bai, mwenga muwesa ukumu makowe ga maisa gano. ");
INSERT INTO mgw_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Tumbwelelo, pamugongwana kwa makowe ginu ga kila lisu'ba, mwanjaa namani mupeleka myalo yinu kwa bandu ba panja ya kanisa? ");
INSERT INTO mgw_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Nilongela nnya linga mwiibone oni. Ngatubaye panga kwinu mwenga ntu'pu' mundu mwene ikima ywawesa ukumu myalo ya aumini? ");
INSERT INTO mgw_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Lakini mwenga mubile na kitibe sa mundu kunsitakya mumini nnyine kumankama, kwa bandu bangali aumini! ");
INSERT INTO mgw_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Akwo sitakyana kwinu mwabene na bene kulaya panga muyomwike sindwa. Yaai male kwinu mwenga komeya galu' gangali aki, ata ikatei pokonyolwa ili'be yinu. ");
INSERT INTO mgw_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Lakini mwenga nga mwamupanga maakau no pokonywa mali ya bandu bi'ngi', na bamwapangya ga alongo binu aumini. ");
INSERT INTO mgw_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Au mutangiteli panga alau baaulisili ukulungwa wa Nnu'ngu'? Kanemwikonge! Apege, babaikilikitya inyago, babaileka ndoa no yenda panja, apege ba analu'me sika, ");
INSERT INTO mgw_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","baii, asoyo, alobyawi'mbi', atukani, wala apokonyoli baaulisili ukulungwa wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Mwabi'ngi' binu mwabile kati bo. Lakini mwatigu'lu'li'lwa, mwatipeleteyelwa, mwabalangililwe aki kwa lina lya Bwana witu Yesu Kilisitu na kwa Loo wa Nnu'ngu' witu. ");
INSERT INTO mgw_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Mundu awesa baya, “Kwangu' nenga ili'be yoti yendayi'ki'ti'lwa.” Eloo, lakini kwinu mwenga ili'be yoti yo pwaika lili. Niwesa baya panga, “Ili'be yoti yendayi'ki'ti'lwa kwangu' nenga,” lakini naayi'ki'tya lili panga nitawalilwe na kili'be sosoti. ");
INSERT INTO mgw_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“Kilyo kwa ndumbo na ndumbo kwa kilyo. Lakini Nnu'ngu' aalu'a kwilangamisa yoti ibi'li'.” Yi'ga iumbilweli kwa kitumbu sa upege ila kwa kitumbu sa kuntumikia Bwana na Bwana kwa kwikota yi'ga. ");
INSERT INTO mgw_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Nnu'ngu' ywannyu'yite Bwana Yesu bu'ka kuuwi'li aalu'a kutuyu'ya na twenga kwa uweso wake. ");
INSERT INTO mgw_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Buli, mutangiteli panga yi'ga yinu nga ili'mbi'li'mbi' ya yi'ga ya Kilisitu? Buli, nitole ili'mbi'li'mbi' ya yi'ga ya Kilisitu na kwilu'mbaniya na yi'ga ya mpege? Ipwaikali ata pasene! ");
INSERT INTO mgw_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Au mutangiteli panga mundu ywoywoti ywapanga kiyangatani na mpege apanga yi'ga yimo na ywembe? Ayi' nga kati mu'lu' mwaiandikilwe mu Maandiko Mapeleteu panga, “Abi'li' bo, baapanga yi'ga yimo.” ");
INSERT INTO mgw_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Lakini ywoywoti ywalu'mbana na Bwana endagalambuka no baa na loo yimo na ywembe. ");
INSERT INTO mgw_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Kwa nyo muutile upege, kwa mwanjaa sambi yi'ngi' yoti yaipanga mundu, aipanga panja ya yi'ga yake, lakini yu'lu' ywapanga upege, apanga sambi nkati ya yi'ga yake mwene. ");
INSERT INTO mgw_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Au mutangiteli panga yi'ga yinu nga nyumba ya Loo Mpeleteu ywabile nkati yinu ywamupeyilwe na Nnu'ngu'? Namwenga mwa mali yinu mwabeneli. ");
INSERT INTO mgw_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Mwanjaa, Nnu'ngu' aampi'mite kwa bei. Kwa nnyo, yi'ga yinu inkwi'ye Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Bai, bu'kana na makowe galu' gamwaaniandikile, “Nantali nnalu'me kaneakobeke,” ");
INSERT INTO mgw_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","lakini li'nga kuuyepa upege, bai, kila nnalu'me abe na nnyumbowe na nnwawa abe na nsengowe. ");
INSERT INTO mgw_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Nnalu'me apalikwa ampangi nnyumbowe goti gagapalikwa mulisengele, nyinyonyo na nnwawa kwa nsengowe. ");
INSERT INTO mgw_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Nnwawa nku'nda ntu'pu' utawala kwa yi'ga yake, ila kwa nsengowe, nyinyonyo na kwa nnalu'me ywakobike. ");
INSERT INTO mgw_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Kanemuyimane, ila mupange kwo yi'ki'tyana panga kwa wakati nsene bai, li'nga mupate lipala lya kunnu'ba Nnu'ngu'. Bu'kapo muki'li'bu'kyane kai', li'nga Ibilisi aakane pata lipala lya kumpaya kwo kotoka li'ngi'lya mumakowe ginu. ");
INSERT INTO mgw_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Makowe gano ganimmakia kwenda amuli lili, ila ninnyi'ki'tiye mulekangane kwa wakati nsene bai. ");
INSERT INTO mgw_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Naapendi kila mundu abe kati mwanibile nenga, lakini ibileli nyo kwa mwanjaa kila mundu Nnu'ngu' ampei uweso wa kisake, aapangite ywi'ngi' apange nya, na ywi'ngi' nyalu'. ");
INSERT INTO mgw_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Lakini naabakia balu' bangali kobeka na alwawa awi'li'kwa panga yaali'ngani batame ulu'mi'langa kati mwanibile nenga. ");
INSERT INTO mgw_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Lakini mana bakombwali kwikanikiya bene, nantali bakobeke no ku'nda kulikoni tama na maminyikio ga payi'ga. ");
INSERT INTO mgw_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Kwa balu' babayomwike kobekana, Nnu'ngu' aapeya amuli, kwenda nengali panga, nwawa nku'nda kanealekangane na nsengowe. ");
INSERT INTO mgw_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Lakini mana alekangine nakwe, bai apalikwa atame pangali ku'nda, au aawane na nsengowe li'nga baki'li'bu'kyane, nyinyonyo na nnalu'me nkobeka kanealekane na nnyumbowe. ");
INSERT INTO mgw_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Makowe gano nimmakia nenga, kwenda Bwanali, panga manaitei nnalu'me mwu'bi'lya ai na nnyumbowe ywangau'bi'lya, na aywo nnyumbowe kayi'ki'tya tama nakwe, kaneanneke nnwawa ywo. ");
INSERT INTO mgw_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Nyinyonyo na nnwawa mwu'bi'lya mana ai na nsengowe ywangau'bi'lya na aywo nsengowe kayi'ki'tya tama nakwe, kaneanneke nnalu'me ywo. ");
INSERT INTO mgw_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Kwa mwanjaa aywo nnalu'me ywangau'bi'lya aapeleteyelwa na Nnu'ngu' kwo pi'tya nnyumbowe, nyinyonyo na nnwawa ywangau'bi'lya aapeleteyelwa na Nnu'ngu' kwo pi'tya nsengowe. Kenda ikapangageli nyo bana binu bapelepangali apeleteu, lakini mwaibile nambi'yambi' bembe apeleteu. ");
INSERT INTO mgw_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Lakini manaitei yu'lu' ywangau'bi'lya kapala kunneka nnyine, anneke bai, apo aywo nnwawa au nnalu'me ywau'bi'lile aapanga ayu'gu'lilwe kwa lisengele lyo. Kwa mwanjaa Nnu'ngu' ankemike li'nga mutame mumaisa ga amani. ");
INSERT INTO mgw_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Muwesali tanga panga, kwo u'bi'lya kwa nnyumbowe au nsengowe, pi'ngi' yumo ywabe aawesa kunng'alambwa nnyine ywangau'bi'lya li'nga amwu'bi'li Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Lakini kila mundu atame mumaisa gagabu'kana na Bwana, galu' gaakemilwe na Nnu'ngu'. Li'no nga lilagyo lyanilibi'ka mumakanisa goti. ");
INSERT INTO mgw_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Manaitei mundu aakemilwe na Nnu'ngu' abile ainilwe, bai, kaneapange kati ywangainilwa. Kai' manaitei mundu aakemilwe na Nnu'ngu' abile ywangainilwa, bai kaneainilwe. ");
INSERT INTO mgw_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Inilwa au kotoka inilwa kili'be sa ngamali, kili'be sakibile sa ngama kwikamwa amuli ya Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Bai, kila mundu atame kati mwaabile paakemilwe na Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Buli, Nnu'ngu' aakukemite nsimu pawaabile wa mmanda? Alyo kanelikuauye. Lakini mana upatike lipala lya kwibi'ka ulu, bai, utumi lipala lyo. ");
INSERT INTO mgw_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Kwa mwanjaa ywembe ywaakemilwe na Bwana abile mmanda, aywo aalu'a ba ulu kwa Bwana, nyinyonyo na ywaakemilwe abile ulu aywo nga mmanda kwa Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Mwaapi'milwe na Nnu'ngu' kwa bei, kwa nyo, kanemube mwaabanda ba bandu kai'. ");
INSERT INTO mgw_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Mwalongo bangu', kila mundu aigale na Nnu'ngu' kati mwaabile nsimu waakemilwe. ");
INSERT INTO mgw_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Bu'kana na alu'mi'langa nenga ntu'pu' amuli yaibu'ka kwa Bwana, lakini nibaya kati na mundu ywaniu'bi'like kwa kiya sa Bwana. ");
INSERT INTO mgw_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Bu'kana na tabu yaibile nambi'yambi', nibona male muigale kati mwamubile. ");
INSERT INTO mgw_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Manaitei ukobike bai kaneupale lekangana, na mana unakobekali bai kaneukobeke. ");
INSERT INTO mgw_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Lakini ntu'pu' sambi kwa babakobeka au ku'nda, ila babakobike au ku'nda baalu'a pata tabu mumaisa ga, na nenga nipalage kanemwipate tabu yo. ");
INSERT INTO mgw_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Lakini mwalongo bangu' nibaya nyinya, wakati wauigalile bu'ka nambi'yambi' mpaka buya kwa Kilisitu, nsene bai, kwa nyo balu' babakobike batame kati bangali kobeka li'nga bapange kasi ya Bwana, ");
INSERT INTO mgw_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","na babali'la babe kati bangali li'la, na babapulaika babe kati bangali pulaika, nyinyonyo na babapi'ma, yi'lu' yabapi'mite ibe kati yabe lili, ");
INSERT INTO mgw_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","na balu' babatumya mali ya dunia yi'no, babe kati baitumyali, kwa mwanjaa dunia yi'no kati mwatutangite yendapi'ta. ");
INSERT INTO mgw_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Nipala kanemube na kyukala kwa abali ya makowe ga. Nnalu'me ywangalikobeka aiauya na makowe ga Bwana, na kwa ndi'la yaku' apange li'nga Bwana anapusike. ");
INSERT INTO mgw_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Lakini nnalu'me ywakobike aiauya na makowe ga dunia, na kwa ndi'la yaku' apange li'nga ampulaise nnyumbowe, ");
INSERT INTO mgw_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","na maganio gake gabaganike pabi'li'. Nnwawa ywangali ku'nda aiauya na makowe ga Bwana, li'nga apate baa mpeleteu kwa yi'ga na loo. Lakini yu'lu' ywaku'ndike, ywembe aiauya na makowe ga padunia, li'nga kumpulaisa nsengowe. ");
INSERT INTO mgw_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Nilongela makowe ga kwa pwaila yinu mwabene, kwenda nendakunkanikiyali, ila nipala mutame mundi'la ya kakape yaipalikwa, li'nga mupate kuntumikia Bwana pangali minyikia makowe gi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Nnalu'me mana aibweni ampangyali wiso mwi'nja ywapala kunkobeka, na mana kautilwa na maminyikio, apange mwapala. Bakobekane bai, wala apangali sambi. ");
INSERT INTO mgw_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Lakini mundu mana aamuite mwene bu'ka pamwoyo wake kotoka kobeka, pangali li'ndi'ndi'lwa na mundu ywoywoti, ila awesa kwitawala mwene na maminyikio gake go kotoka kunkobeka aywo nnwawa, bai apanga kati mwaipalikwa. ");
INSERT INTO mgw_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Kwa nyo, nnalu'me ywankobeka nnwawa ywapalage kunkobeka ywembe, aapanga likowe linogau, na nnalu'me ywaakotoka kobeka aapanga likowe linogau muno. ");
INSERT INTO mgw_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Nnwawa apalikwa tama na nsengowe kwa nsimu woti wa baa mwu'mi. Lakini mana nnalu'me awile, nnwawa aapanga ulu kwo ku'nda na nnalu'me ywoywoti, ila aywo nnalu'me abe mpwasi wa Bwana. ");
INSERT INTO mgw_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Manaitei aatama kisake aapanga na pulaa muno, ila aga maganio gangu', na niu'bi'lya panga, nanenga nibile na Loo wa Nnu'ngu' ywanilongoya longela go. ");
INSERT INTO mgw_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Nambi'yambi' nilongelya bu'kana na ilyo yaibi'ki'lilwe kwa inyago. Tutangite panga kila mundu abile na ilimu, lakini ilimu yo yapanga bandu baipune, ila upendo ngauliyangatia likanisa lisengelwe. ");
INSERT INTO mgw_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ywagania panga atangite likowe nsi'si', anatangali likowe lyolyoti kati mwaipalikwa kulitanga. ");
INSERT INTO mgw_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Lakini Nnu'ngu' antangite mundu ywampenda. ");
INSERT INTO mgw_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Kwa nyo bu'kana na ilyo yaibi'ki'lilwe kwa inyago, tutangite panga inyago kili'be lili mudunia, satutangite twenga panga Nnu'ngu' yumo bai. ");
INSERT INTO mgw_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Ata ikatei bandu bi'ngi' bagania panga kubile na kinnu'ngu' na mabwana bi'ngi' mudunia au kunani, ");
INSERT INTO mgw_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","lakini kwitu twenga Nnu'ngu' yumo bai, na nga Tati' ywaumbike ili'be yoti, na twenga tutama kwa kitumbu sake. Kai', kubile na Bwana yumo bai, na ywembe nga Yesu Kilisitu. Ili'be yoti yaumbilwe kwo pi'tya ywembe, kai' twenga tulama bu'kana na ywembe. ");
INSERT INTO mgw_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Lakini boti lili bababile na ilimu ya likowe li'. Kwa mwanjaa kubile na bi'ngi' babayobeli inyago, bandu bo mpaka nambi'yambi' pabalya, baibona kati balo kabalya ilyo yaibi'ki'lilwe kwa inyago. Kwa mwanjaa muimani balo banakomalali, kwa nyo baibona bapanga sambi. ");
INSERT INTO mgw_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Lakini kilyo kitubi'kali papipi na Nnu'ngu', kwa mwanjaa ata mana tukotwike lya tuobeyali kili'be, kai' ata mana tulile, tuyongekeyelwali kili'be. ");
INSERT INTO mgw_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Lakini mulinguli, wu'no uulu winu kanewaapange bangali komala muimani baku'bale. ");
INSERT INTO mgw_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Kwa mwanjaa mundu ywangalikomala muimani, mana amweni mwene ilimu yi' kalya munyumba ya inyago, buli, aawasali panga yendayi'ki'ti'lwa lya kilyo sakibi'ki'lilwe kwa inyago? ");
INSERT INTO mgw_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Kwa ndi'la yo aywo nnongo mwene imani yangakomala, Kilisitu ywaawile kwa kitumbu sake, aalu'a oba, bu'kana na ilimu yako. ");
INSERT INTO mgw_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Manaitei kamupanga sambi kwa alongo binu kwa ndi'la yi'no na kwalumiya myoyo na imani yabe yangakomala, apo munkosya muno Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Kwa nyo manaitei nyama yanilya kaimpanga muumini nnyangu' atu'mbu'ke musambi, naailyali nyama yo ata pasene, li'nga naakane kumpanga nnyangu' apange sambi. ");
INSERT INTO mgw_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Buli, nenga na mundu ulu lili? Buli nantumilwe lili? Buli, nenga namwenili Yesu, Bwana witu? Buli, mwenga mauno ga lyengo lyangu' lili kwa Bwana? ");
INSERT INTO mgw_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Ata manaitei bandu bi'ngi' kabaibona panga nenga nantumilweli, lakini kwinu mwenga nantumilwe kwa kitumbu sa imani yinu kwa Kilisitu, ilaya panga nantumilwe wa Bwana. ");
INSERT INTO mgw_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Amo ngamwaniyangwa kwa balu' babanipekeseni. ");
INSERT INTO mgw_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Buli twenga ntu'pu' aki yo lya no nywa mulyengo litu lya utumilwe? ");
INSERT INTO mgw_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Buli tuyi'ki'ti'lwali longwana na ayumbo bitu aumini patuyabwa mwanja wo ala, kati mu'lu' atumilwe bi'ngi' na anunabe Bwana Yesu, na Petili? ");
INSERT INTO mgw_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Au nenga na Balanaba bai ngatupalikwa panga lyengo li'ngi', li'nga tukombwe pata ili'be yaipalikwa mumaisa gitu? ");
INSERT INTO mgw_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Asikali ywaku' ywayenda kungondo kwa kwili'pya mwene? Ywaku' ywapanda nng'unda wa minjabibu, no kotoka lya itunda yake? Na ywaku' ywasunga kipi'nga sa ngondolo ywakotoka tumya mabele gake? ");
INSERT INTO mgw_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Mayi'gi'yo ganigabaya, kwenda maganio ga bandu lili ila ata salya ya Musa kai' ibaya nyinyonyo. ");
INSERT INTO mgw_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Kwa mwanjaa musalya ya Musa iandikilwe, “Kaneumwibe nkano ng'ombe pali'bata ngano li'nga ku'bata.” Buli, ngo baya kakape Nnu'ngu' annongelya ng'ombe? ");
INSERT INTO mgw_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Au alongelage ga kwa kitumbu situ? Kakape ngamwaibile! Maandiko ga gaandikilwe kwa twenga, kwa mwanjaa mundu pali'ma na nku'bati paku'bata, boti babile na mau'bi'lyo go pata mauno gabe. ");
INSERT INTO mgw_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Manaitei twapandike mbeyu ya kiloo mumyoyo yinu, buli ipalikwali twenga una ili'be yo lya yaibu'ka kwinu? ");
INSERT INTO mgw_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Manaitei bi'ngi' baabile na aki yo pata ili'be yo bu'ka kwinu, kakape na twenga tubile na aki muno kulikoni bi'ngi'. Lakini twenga twalongiteli aki yi' yayapalikwe tupeyelwe na mwenga, ila twakomiye goti li'nga twaakane kwaibya bandu u'bi'lya abali inannoga ya Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Kakape mutangite panga babatumika munyumba ya Nnu'ngu' bapata liposo lyabe munyumba yo. Na balu' babapanga kasi pakibi'ki'lyo sa nyumba ya Nnu'ngu', nabembe bapokya itomwa ya nyama yo. ");
INSERT INTO mgw_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Nyinyonyo na Bwana aamulise panga balu' babaala Abali Inannoga bapate liposo lyabe bu'ka mumakanisa. ");
INSERT INTO mgw_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Lakini nenga mumakowe go natumyali ata limo, na kwenda niandika ga li'nga munipei lili. Kwangu' nenga, nantali niwee kulikoni mundu ywoywoti kunikanikia kwilumba kwangu'. ");
INSERT INTO mgw_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Nenga ntu'pu' aki ya kwilumba kwa kitumbu so ala Abali Inannoga, kwa mwanjaa lyengo li' nilipanga kwa amuli ya Nnu'ngu'. Kai' naakibona mana nikwotwike ala abali yo. ");
INSERT INTO mgw_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Ikapangage nialike kwo penda namwene, nilu'e banayo upo yangu', lakini nialikeli kwo penda namwene, bai apo nitimisa si'lu' sanipalikwa panga. ");
INSERT INTO mgw_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Bai upo yangu' nga yaku'? Upo yangu' nga yi'no, yo ala Abali Inannoga pangali li'pi'lwa, lombolya kotoka longa aki yaniipala mulyengo lyo. ");
INSERT INTO mgw_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Pamope no panga nenga na mmandali kwa mundu ywoywoti, lakini niipangite nammanda kwa kila mundu li'nga kwauta bandu baingi kwa Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Kwa Ayahudi naabile kati na Nnyahudi, li'nga kwauta Ayahudi. Kwa bandu balu' babaabile pai' ya Salya ya Musa, naabile pai' ya salya yi' (pamope no panga nenga nibileli pai' ya salya), li'nga kwauta balu' babaabile pai' ya salya. ");
INSERT INTO mgw_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Kwa balu' bangali baa na salya, naabile kati ywangali baa na salya, li'nga kwauta abo bababile panja ya salya. Kwenda nenga niikamwali salya ya Nnu'ngu', ila nilongoyelwa na salya ya Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Kwa akigopi naabile kati nakigopi li'nga niwese kwauta bababile akigopi. Naaipangite namundu wa sampuli mbali'mbali' kwa bandu boti li'nga kwa ndi'la yoyoti niwese kwakosopolya bi'ngi' babe. ");
INSERT INTO mgw_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Nipanga aga goti kwa kitumbu sa Abali Inannoga, li'nga nipate baa kiselele mu balaka yake. ");
INSERT INTO mgw_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Buli, mutangiteli panga pabang'anda butuka, boti bendabutuka lakini ywapata upo yo sinda yumo bai? Kwa nyo, mubutuke muno li'nga mupate upo yo sinda. ");
INSERT INTO mgw_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Kila ywabaa muming'ando aiyobeleka ng'anda kwo kasana. Nabembe bapanga nyo li'nga bapoki taji yaialabika, lakini twenga tupanga nnya li'nga tupoki taji yangaalabika milele. ");
INSERT INTO mgw_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Kwa nyo nibutuka kati mundu mwene manugio go sinda, na niku'mbwanali kati mundu ywaku'mbwa pabule. ");
INSERT INTO mgw_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Ila niiku'su'mbwa yi'ga yangu' na kwiyobeleka komeya li'nga bu'ka pa kwaalya bandu Abali Inannoga, nenga namwene naakane obeya upo yo sinda. ");
INSERT INTO mgw_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Mwalongo bangu', nipala mutange panga kiu'ku'lu' bitu baayabwi mwanja kababu'ka Misili kwo longoyelwa na lyunde, kai' boti baapite pakatikati ya baali ya Shamu. ");
INSERT INTO mgw_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Boti baabatisilwe no panga apwasi ba Musa nkati ya li'lu' lyunde na nkati ya yi'lu' baali. ");
INSERT INTO mgw_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Boti baalile kilyo si'si'lu'si'lu' sa loo, ");
INSERT INTO mgw_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","na boti baanywile kinywo simo sa kiloo, kwa mwanjaa baanywile masi' gagabu'ka nkati ya mpi'mbi' wawaalongwaniye nabo, na mpi'mbi' wo wai nga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Lakini Nnu'ngu' aanogelilweli na baingi babe, kwa nyo ngabalangamiswa, na mitwi yabe ngaibamba mulubele. ");
INSERT INTO mgw_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Bai, makowe ga goti gaabile kagatulaya ndi'la twenga li'nga twaakane ba twabandu babaminyikia malau, kati bembe mwabaaminyikiye malau. ");
INSERT INTO mgw_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Kanemube mwabandu bo kilikitya inyago kati bi'ngi' babe mwabaabile, kati mwagabaya Maandiko Mapeleteu panga, “Bandu baatitama, lya no nywa bu'kapo yi'ma no ina.” ");
INSERT INTO mgw_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Wala kanetupange upege kati bi'ngi' babe babaapangite nyo no waa bandu elupu isilini na atatu kwa lisu'ba limo. ");
INSERT INTO mgw_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Kai' kanetumpaye Bwana, kati bi'ngi' babe mwabaapangite, ngabawaa kwo lumilwa na nng'ambo. ");
INSERT INTO mgw_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Wala kanemuku'ku'li'ke kati bi'ngi' babe mwabaapangite, ngababulagilwa na malaika mwalabiyi. ");
INSERT INTO mgw_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Makowe ga goti gaapatike bembe li'nga gabe kati mayi'gano na gaandikilwe li'nga kutukwi'li'ka twenga twatutama mumasu'ba gano ga kuundi'la. ");
INSERT INTO mgw_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Kwa nyo kila ywaibona ayi'mi wiso muimani alinguli aakane tu'mbu'ka. ");
INSERT INTO mgw_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Ntu'pu' lipayilwo lyolyoti lyalimpata mundu lyalibile liku'lu' pi'ta lya bandu bi'ngi'. Nnu'ngu' mwu'bi'li'ka, ywembe aalu'a kunnekali mupayilwe pi'ta uweso winu wo komeya. Ila, pamope no payilwa, Nnu'ngu' aalu'a kumpeya ndi'la yo pita mo, mubile salama. ");
INSERT INTO mgw_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Kwa nyo mwamambwiga bangu' mwamupendilwe, mwitile kwikilikitya inyago. ");
INSERT INTO mgw_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Nilongela na mwenga mwabandu bene malango, muamwe mwabene bu'kana na gano ganigalongela nambi'yambi'. ");
INSERT INTO mgw_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Patunsukulu Nnu'ngu' kwa kikombe si'lu' sa balaka, buli tubali pamope mumyai ya Kilisitu? Na patumetwa likati buli, tubali pamope muyi'ga ya Kilisitu? ");
INSERT INTO mgw_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Kwa mwanjaa likati lyatumetwa twabandu boti limo, kwa nyo twenga twaboti yi'ga yimo, pamope no panga twabambone. ");
INSERT INTO mgw_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Mwalinguli Baisilaili, balu' babalya salaka yaipiyilwe pakibi'ki'lyo, balu'mbana na Nnu'ngu' kwa ndi'la ya salaka yo. ");
INSERT INTO mgw_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Bai nibaye namani? Panga kilyo si'lu' sakipiyilwe salaka kwa inyago nga kili'be sa ngama? Au panga inyago nga kili'be? ");
INSERT INTO mgw_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Lili! Lakini sanipala baya panga salaka yabapiya bandu bangali kuntanga Nnu'ngu' baapikia kimasetani, kwenda Nnu'ngu'li. Nanenga katu nipendili mwenga mulu'mbane na masetani. ");
INSERT INTO mgw_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Muwesali nywelya mukikombe sa Bwana na sa masetani kai', nyinyonyo muwesali baa pamope mukilyo pamesa ya Bwana na pamesa ya masetani. ");
INSERT INTO mgw_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Au tupala kunsokasoka Bwana abe na bwigu? Mugania tubile na makakala pi'ta ywembe? ");
INSERT INTO mgw_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Mwabandu bi'ngi' nkati yinu mubaya, “Ili'be yoti iyi'ki'ti'yilwe,” ila yotili yaileta pwaila. Kai' “Ili'be yoti iyi'ki'ti'yilwe,” lakini ili'be yi'ngi' innetyali mundu pwaila ya kunsenga muimani. ");
INSERT INTO mgw_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Mundu ywoywoti kaneapale gagabile ga pwaila yake mwene, ila kila mundu apale galu' gagaayangatia na bi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Mulye sosoti sakipi'mi'yi'lwa pasoko. Kanemulaluyelaluye li'nga pala tanga panga yendayi'ki'ti'yi'lwa au lili lya kili'be so. ");
INSERT INTO mgw_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Kwa mwanjaa Maandiko Mapeleteu gabaya, “Dunia na ili'be yoti yaibile nkati yake, nga mali ya Bwana.” ");
INSERT INTO mgw_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Mana mukokilwe kwa mundu ywangau'bi'lya, mwalyee sosoti sakibi'ki'lwa nnu'ngi' yinu pangali kunnaluya. ");
INSERT INTO mgw_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Lakini mundu mana ammakiye, “Kilyo si'no kibi'ki'lilwe muinyago,” bai kanemulye. Kwa mwanjaa ya aywo ywammakiye nyo na kwa kitumbu sa mwoyo. ");
INSERT INTO mgw_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Nilongelali bu'kana na maganio ga myoyo yinu, ila nilongelya maganio ga mwoyo wa mundu yu'lu' ywabaite. Nitangite mulu'a nilaluya, “Kwa mwanjaa namani uulu wangu' namwene uukumilwe na maganio ga mwoyo wa mundu ywi'ngi'? ");
INSERT INTO mgw_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Mana kaninsukulu Nnu'ngu' kwa kilyo sanilya, kwa ki'li' nipate lukoolo kwa kilyo saninsukulu Nnu'ngu' bu'kana na so?” ");
INSERT INTO mgw_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Bai, likowe lyolyoti lyamupanga, manaitei lya au nywa, mupange goti kwa utukupu wa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Katu kanemupange likowe lyolyoti lyalyalu'a kwapanga bandu bi'ngi' bapange malau, ibe kwa Ayahudi au bangali Ayahudi au mundu ywoywoti mumakanisa ga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Mube kati nenga mwanibile. Kwa kila ndi'la nibinia kumpulaisa kila mundu mumakowe gangu' goti ganipanga. Na kwenda nipanga nyo li'nga nipate kili'be lili, ila nipanga nyo li'nga kwapanga bandu baingi bawese kosopolelwa. ");
INSERT INTO mgw_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Muniyige nenga kati nenga mwaninnyiga Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Nendakunnumba kwa kitumbu sa kuniku'mbu'kya mumakowe goti, na kugakamwa mayi'gano goti ganimpeile. ");
INSERT INTO mgw_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Lakini nipala mutange kai' panga Kilisitu nga ntwe wa kila nnalu'me, na ntwe wa nnwawa nga nnalu'me, na ntwe wa Kilisitu nga Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kila nnalu'me ywalu'ba au londwa ku'no awi'ki'li ntwe wake, aywo amwisiya Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Nyinyonyo na nnwawa palu'ba au londwa pangali wi'ki'lya ntwe wake, amwisiya nsengowe, kwa kitumbu so alandana na nnwawa yu'lu' ywasekwi nywili yoti. ");
INSERT INTO mgw_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Manaitei nnwawa awi'ki'lyali ntwe wake, nantali atemi. Lakini yaapanga oni kwa nnwawa temya au sekwa nywili yake. Kwa nyo apalikwa awi'ki'li ntwe wake. ");
INSERT INTO mgw_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Ipwaikali kwa nnalu'me wi'ki'lya ntwe wake kwa mwanjaa ywembe alaya utukupu wa Nnu'ngu'. Lakini nnwawa alaya utukupu wa nnalu'me. ");
INSERT INTO mgw_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Kwa mwanjaa nnalu'me apitikeli kwa nnwawa, ila nnwawa apitike kwa nnalu'me. ");
INSERT INTO mgw_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Na nnalu'me aumbilweli kwa kitumbu sa nnwawa, ila nnwawa kwa kitumbu sa nnalu'me. ");
INSERT INTO mgw_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Kwa kitumbu sa malaika, nnwawa apalikwa wi'ki'lya ntwe wake, li'nga laya panga ai pai' ya utawala wa nsengowe. ");
INSERT INTO mgw_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Lakini muulu'mbani na Bwana, nnwawa kili'be lili pangali nnalu'me, na nnalu'me kili'be lili pangali nnwawa. ");
INSERT INTO mgw_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Nibaya nyo kwa mwanjaa kati mwaibile panga, nnwawa aumbilwe bu'ka kwa nnalu'me, nyinyonyo na nnalu'me abelekwi na nnwawa. Lakini kila kili'be kibu'kite kwa Nnu'ngu'. ");
INSERT INTO mgw_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Muamwe mwabene, buli, yendapwaika nnwawa lu'ba Nnu'ngu' pangali wi'ki'lya ntwe wake? ");
INSERT INTO mgw_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Ata maumbile gene galaya mpu'la panga kwa nnalu'me ba na nywili ndaso oni kwake mwene, ");
INSERT INTO mgw_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","lakini kwa nnwawa ba na nywili ndaso nga isima kasake mwene, kwa mwanjaa nnwawa apeyilwe nywili ndaso li'nga wi'ki'lya ntwe wake. ");
INSERT INTO mgw_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Manaitei mundu kapala tauka bu'kana na likowe li'no, bai atange panga twenga wala mumakanisa ga Nnu'ngu' ntu'pu' mimu yi'ngi'. ");
INSERT INTO mgw_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Nibile balo kunnagya ga, niwesali kunnumba bu'kana na aga, kwa mwanjaa kwembana kwinu mumakanisa kwenda kwa pwaila lili ila kwa bule bai. ");
INSERT INTO mgw_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Wi'ti' niyu'wine panga pamukwembana kati likanisa, nkati yinu mwendabaganika, nanenga mwanibona iwesa panga kakape. ");
INSERT INTO mgw_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Mibaganiko nkati yinu lasima ipiti, li'nga balu' babayi'ki'tilwe na Nnu'ngu' batanganikwe. ");
INSERT INTO mgw_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Kwa mwanjaa, pamukwembana pamope, mulyali Kalamu ya Bwana kati mwaipalikwa, ");
INSERT INTO mgw_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","kila mundu alya kilyo sake mwene pangali kwali'nda bi'ngi', kwa nyo bi'ngi' baigala na njala na bi'ngi' bendalobya. ");
INSERT INTO mgw_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Buli, muwesali lya no nywa mumayumba ginu? Kwa ki'li' mulisalawa likanisa lya Nnu'ngu' na kwaisiya abo bangali kili'be? Nimmakie namani? Ninnumbe au? Lili, niwesali kunnumba ata pasene bu'kana na likowe li'. ");
INSERT INTO mgw_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Mayi'gano ganinnyi'ganiye nga gagalu'galu' ganigapokile bu'ka kwa Bwana, panga kilo si'si'lu'si'lu' saasongilwe Bwana Yesu atweti likati, ");
INSERT INTO mgw_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","naywembe bu'ka pa kunsukulu Nnu'ngu' ngalimetwana, kabaya, “Ayi' nga yi'ga yangu' yaipiyilwe kwa mwenga, mupange nnyo kwa kuniku'mbu'kya.” ");
INSERT INTO mgw_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Nyinyonyo bu'ka po lya, ngatola nnobo wa divai no baya, “Nnobo wu' nga lilagano lyayambi' lyalibonekana kwa ndi'la ya myai yangu'. Mupange nnya kila pamunywelya nnobo gu', kwa kuniku'mbu'kya.” ");
INSERT INTO mgw_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ayi' ilombolya panga kila pamulya likati li'no na kuunywelya nnobo wu', muala kiwo sa Bwana mpaka paalu'a isa. ");
INSERT INTO mgw_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Kwa nyo, kila ywalya likati lyo au kuunywelya nnobo wo Bwana kati mwaikotoka palikwa, aapanga apangite sambi, kwa mwanjaa aisalawi yi'ga na myai ya Bwana. ");
INSERT INTO mgw_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Bai, ipalikwa kila mundu aipekeseni mwene, bu'kapo alye likati na kuunywelya nnobo. ");
INSERT INTO mgw_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Kwa mwanjaa mundu ywoywoti ywalya no nywa pangali tanga kilombolyo sa yi'ga ya Bwana, endalya no nywa ukumu yake mwene. ");
INSERT INTO mgw_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Si'no nga kitumbu sa bandu baingi nkati yinu bapanga atamwe na akigopi, na bandu bi'ngi' ata waa. ");
INSERT INTO mgw_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Lakini ikapangage twipekesenile wiso twabene, Nnu'ngu' alu'e tuukumu lili. ");
INSERT INTO mgw_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Lakini patuukumilwa na Bwana, apo twendakwi'li'ki'lwa li'nga twaakane pwatilwa pamope na bandu ba dunia. ");
INSERT INTO mgw_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Kwa nyo mwalongo bangu', pamukwembana pamope li'nga lya Kalamu ya Bwana, ipalikwa muli'ndane. ");
INSERT INTO mgw_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Manaitei mundu abile na njala, alye kasake li'nga kwembana kwinu pamope kanekunneti ukumu. Makowe gi'ngi' gagaigalile, naalu'a kugabi'ka wiso nsimu wanaalu'a isa kwinu. ");
INSERT INTO mgw_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Bai mwalongo bangu', kwo bu'kana na upo ya Loo Mpeleteu nipala mutange ukakape wake. ");
INSERT INTO mgw_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Mutangite panga pamwabile balo mwabandu bangali kuntanga Nnu'ngu', mwatikongelwa no longoyelwa kilikitya inyago yangali ukoto. ");
INSERT INTO mgw_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Kwa nyo mutange panga ntu'pu' mundu ywalongoyelwa na Loo wa Nnu'ngu' ywawesa baya, “Yesu akosite lasi.” Kai', ntu'pu' mundu ywawesa baya, “Yesu nga Bwana” ila kwa yu'lu' ywalongoyelwa na Loo Mpeleteu bai. ");
INSERT INTO mgw_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Kubile na upo ya kiloo ya sampuli mbali'mbali', lakini ywapiya upo yo, Loo yumo bai. ");
INSERT INTO mgw_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Kubile na utumisi wa sampuli mbali'mbali', lakini Bwana ywatumikiyilwa yumo bai. ");
INSERT INTO mgw_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Kubile na uweso wa sampuli mbali'mbali' wo panga kasi, lakini Nnu'ngu' nga yu'yu'lu'yu'lu' bai ywaapanga bandu boti bakombwe panga kasi yabe. ");
INSERT INTO mgw_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Kili'be sopeyilwe na Loo Mpeleteu, kiwesa bonekana nkati ya kila mundu, li'nga bapwailike bandu ba kanisa. ");
INSERT INTO mgw_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Loo yu'yu'lu'yu'lu' abile na uweso wa kumpeya mundu yumo ikima na ywi'ngi' malango. ");
INSERT INTO mgw_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Loo ywoywoywo ampeya mundu yumo imani, na ywi'ngi' uweso wo lawa bandu, ");
INSERT INTO mgw_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","kai' ywoywoywo ampeya mundu uweso wo panga mangelongelo, ywi'ngi' ulondoli, ywi'ngi' kwitanga loo ya kakape na ya ubu'su', ywi'ngi' longela kwa luga yayambi' na ywi'ngi' awanikiya mwailombolya luga yo. ");
INSERT INTO mgw_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Ayo yoti kasi ya Loo Mpeleteu yumo, ywoywoywo ywampeya kila mundu upo ya sampuli mbali'mbali' kati mwapendi mwene. ");
INSERT INTO mgw_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Mundu ai na yi'ga yimo na nkati yake kubile ilu'mbi'lu'mbi' yambone, nyinyonyo ngamwaibile muyi'ga ya Kilisitu. ");
INSERT INTO mgw_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Kwa mwanjaa twaboti tubatisilwe ubatiso wa Loo yumo ata manaitei Ayahudi au Ayunani, wammanda au wangwana, tupeyilwe aywo Loo yumo li'nga tupange yi'ga yimo. ");
INSERT INTO mgw_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Yi'ga iumbilweli na kilu'mbi'lu'mbi' simo ila kwa ilu'mbi'lu'mbi' yambone. ");
INSERT INTO mgw_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Ikapangage lugu'lu' kalubaya, “Kwa mwanjaa nenga na luboko lili, bai, nenga na ywayi'gali,” alyo lilu'e pangali alwo lugu'lu' kanelube kilu'mbi'lu'mbi' sa yi'ga. ");
INSERT INTO mgw_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Ikapangage likutu kalibaya, “Kwa mwanjaa nenga na liyo lili, bai, nenga na ywayi'gali,” alyo lilu'e pangali alyo likutu kanelibe kilu'mbi'lu'mbi' sa yi'ga. ");
INSERT INTO mgw_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Ikapangage yi'ga yoti panga nga liyo, yu'wa kulu'e panga ntu'pu', nyinyonyo yi'ga yoti ikapangage likutu, nuya kulu'e panga ntu'pu'. ");
INSERT INTO mgw_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Lakini kati mwaibile, Nnu'ngu' akibi'kite kila kilu'mbi'lu'mbi' muyi'ga kati mwapendi mwene. ");
INSERT INTO mgw_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Kulu'ebali yi'ga, ikapangage ilu'mbi'lu'mbi' yoti panga simo bai. ");
INSERT INTO mgw_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ukakape nga gu'no, yi'ga yimo lakini ilu'mbi'lu'mbi' yambone. ");
INSERT INTO mgw_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Liyo likombwali kulubakiya luboko, “Nikupalali.” Nyinyonyo, ntwe ukombwali kulubakiya lugu'lu', “Nikupalali.” ");
INSERT INTO mgw_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Lakini mwaibile, kilu'mbi'lu'mbi' sa yi'ga sakibonekana kigopi muno, aso nga sa ngama muno. ");
INSERT INTO mgw_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Kai' ilu'mbi'lu'mbi' yaibonekana panga ipalikwali isimilwa ngayatuisimu. Nyinyonyo, ilu'mbi'lu'mbi' ya yi'ga yitu yaibonekana panga ileta oni, ngayatuikota muno. ");
INSERT INTO mgw_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Ilu'mbi'lu'mbi' yangali leta oni ipalikwali kotelwa kati yi'ngi', lakini Nnu'ngu' mwene abi'kite pamope ilu'mbi'lu'mbi' ya yi'ga na kwipeya isima muno yi'lu' yaipu'ngu'kilwe. ");
INSERT INTO mgw_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Nnu'ngu' aabini panga nyo li'nga ilu'mbi'lu'mbi' ya yi'ga kaneilekangane, ila kila simo kiyangatiyane na si'ngi'. ");
INSERT INTO mgw_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Manaitei kilu'mbi'lu'mbi' simo kilumile na yi'ngi' yoti yaalu'a minya pamope naso. Na si'ngi' mana kilumbilwe, yi'ngi' yoti yaalu'a pulaika pamope. ");
INSERT INTO mgw_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Bai, mwenga mwaboti kwa pamope nga yi'ga ya Kilisitu. Na kila yumo ywinu nga kilu'mbi'lu'mbi' sa yi'ga yo. ");
INSERT INTO mgw_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Nnu'ngu' mumakani