﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgv_vpl;
CREATE TABLE mgv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgv_vpl WRITE;
INSERT INTO mgv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ganga ndi mahina gaka hoku baka Yesu Kilisitu, jojabii mu kibeleku saka Daudi, jojabii nsoko waka Ibulahimu. ");
INSERT INTO mgv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu ambelika Isaka na Isaka ambelika Yakobo na Yakobu ambelika Yuda naaka alongu baki. ");
INSERT INTO mgv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ambelika Pelesi na Zela, nyongo wabu jwabii Tamali, Pelesi ambelika Heziloni na Heziloni ambelika Alami, ");
INSERT INTO mgv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alami ambelika Aminadabu na Aminadabu ambelika Nashoni na Nashoni ambelika Salumoni, ");
INSERT INTO mgv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni ambelika Boazi, nyongoo waka Boazi jojabii Lahabu na Boazi na Lutu bakabii azazi baka Obedi na Obedi ambelika Yese. ");
INSERT INTO mgv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ambelika Bambu Nkolongu Daudi. Daudi ambelika Solomoni, nyongoo waki Solomoni bunkema Besisheba jojabii nhwanu waka Ulia. ");
INSERT INTO mgv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni ambelika Leoboamu na Leoboamu ambelika Abiya na Abiya ambelika Asa, ");
INSERT INTO mgv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ambelika Yeoshafati na Yeoshafati ambelika Yolamu na Yolamu na Yolamu ambelika Uzia, ");
INSERT INTO mgv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia ambelika Yosamu na Yosamu ambelika Ahazi na Ahazi ambelika Hezekia, ");
INSERT INTO mgv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia ambelika Manase na Manase ambelika Amoni na Amoni ambelika Yosia, ");
INSERT INTO mgv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia ambelika Yekonia na alongu baki, mu masoba gegala sakabii kipindi sa Ayaudi pabaapelika ku luhami ku Babeli. ");
INSERT INTO mgv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pababiya baapeliki Ayaudi ku luhami luku Babeli, na Yekonia ambelika Shealutieli na Shetieli ambelika Zelubabeli, ");
INSERT INTO mgv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli ambelika Abiudi na Abiudi ambelika Eliakimu na Eliakimu ambelika Azoli, ");
INSERT INTO mgv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli ambelika Sadoki na Sadoki ambelika Akimu na Akimu ambelika Eliudi, ");
INSERT INTO mgv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi ambelika Eleazali na Eleazali ambelika Matani na Matani ambelika Yakobu. ");
INSERT INTO mgv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobu ambelika Josepu, jojabii nndomi waka Malia, nyongoo waka Yesu joakema Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ndienu kwabi niibeleku Komi nu nsesi kutumbuli Ibulahimu mbaka Daudi ni ibeleku komi nu nsesi tumbuka Daudi mbaka Ayaudi pabaakamula kujenda kuluhami ku Babeli, ni ibeleku komi nu nsesi toka pabaakamula kujenda kuluhami mbaka kusaliwa kwaka Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kilisitu jwasaliwa ana, Malia nyongoo waka Yesu jwabia jusumbiki Josepu. Lakini pa babiya bakoni nganukutama pamu ngati nndomi nu nhwanumundu, Malia jabonikana jubii ni kitumbu kupete uwesu wa Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josepu ndaba jabii mundu waamboni palongi jaka Sapanga, ngasejapai kumpoalihamu Malia, ndi japala kundeka kinunukinunu. ");
INSERT INTO mgv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pajwabia jwakoni jwakawasaliya lijambu leheli, Ntumi jukunani waka Bambu ampitila mundotu ampwagila, “Josepu mwana waka Daudi, wijogopa kunzuku Malia kuba nhwanu wako, ndaba kitumbu saki jupatiki ku uwesu waka Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jwiibelika mwana mwanalomi nawe wankema liina laki Yesu, ndaba jombi ndi jojwaakombula bandu baki kuhuma mu mahakau gabu.” ");
INSERT INTO mgv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndienu, haga goti gapitii ili litimia lilobi laka Bambu lejwapwaga kwi indela jaka mlota waka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Linga, kamwali jwanga kuketanga na mwanalomi jwiitotula kitumbu, ambelika mwana mwanalomi, najombi bankema liina la Manueli.” Maana jaki, “Sapanga jubii pamu na twepani.” ");
INSERT INTO mgv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ndienu, Josepu pa jwajumuka mu lugonu jatenda ngati ntumi jukunani eampwagila, anzukua Malia nhwanu waki, nukujenda naku kunyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lakini ngasejagoni naku mbaka Malia pajabelika mwana mwanalomi. Najombi Josefu ankema liina laki Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu jasaliwa ku musi guku Betelehemu, ku nndema uku Yudea, masoba Helodi pajwabii bambu nkolongu. Bandu baamanya gagiipitila mweni katai sukulingali ndondu babahuma upandi golipitii lyoba bahika ku Yelusalemu, ");
INSERT INTO mgv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","baalalukiya bandu, “Jubii kwaa mwana jojibiya bambu nkolongu jwa Ayaudi, jojusaliwi? Tujibweni ndondu jaki jipitii upandi golipiti lyoba, tuhikiki kungungamali.” ");
INSERT INTO mgv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bambu nkolongu Helodi pajajoa ganiaga, jahangajiki ngamaa mmoju jaki, jombi pamu na bandu boti buku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ndienu Helodi, jaakema pamu agolu akolongu boti na abola ba malagalaki jalalukiya bombi, “Boo, Kilisitu Nkombosi jwisaliwa kwako?” ");
INSERT INTO mgv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nabombi bajibua, “Jisaliwa ku musi uku Betelehemu, ku nndema uku Yudea. Ndaba mlota waka Sapanga ejuandiki, ");
INSERT INTO mgv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mwabandu buku Betelehemu musi gogubii ku Yudea, mwanganya mwaasoku kati jaka kilongosi ba bandu buku Yudea, ndaba kwinu jiihuma kilongosi, jojaalongua bandu bangu buku Izilaeli.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ndipala Helodi jaakema bandu bala baamanya gagipitila sukulingali ndondu su ujobu, ili bumpwagila muda gojipitila ndondu. ");
INSERT INTO mgv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ndienu jaatuma ku Betelehemu, japwaaga, “Nzendannya mukataputa sapi pajubii mwana hoju. Anamubweni mwihika kumbwagi na nane kabee niijenda kungungamali.” ");
INSERT INTO mgv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ebajomula kunzoane bambu nkolongu batenda kuboka. Na ndondu jela jebabiya bijibweni upandi kolipitii lyoba jaalongulikiya nukujenda kujema pandu pajabii mwana pala. ");
INSERT INTO mgv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ebijibona ndondu jela, batoguli ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ndienu, bajingala nnyumba, bummbona mwana jola pamu na Malia nyongoo waka mwana, bapega magoti nukungungamali. Ndipala baogula mikoba jabu, nukumpeke nhupi yabu, zaabu nu ubani na mahuta gabagakema manemane. ");
INSERT INTO mgv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sapanga jaakana mundotu biikelebuki kabee kwaka Helodi, ndienu bakelubuka mwa manyumba gabu kupete indela jengi. ");
INSERT INTO mgv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pababoka ageni bala, ntumi juku kunani jwaka Bambu ampitila Josepu mu ndotu, ampwagila, “Jumuka! Gunzukua mwana pamu na nyongoo, ntilila ku Misili. Mwakatama konioku mbaka enampwagila, ndaba Helodi jupala kunkoma mwana weajo.” ");
INSERT INTO mgv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ndienu, Josepu jajumuka, anzukua mwana pamu na amabu baki ikilu ajelaje, nukujendane ku Misili. ");
INSERT INTO mgv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jatama hoku mbaka Helodi ejakuwa. Lijambu heli lahengika ili lilobi lejwapwaga Bambu kwi indela juku mlota litimia, “Nunkemaa mwana wangu kuhuma ku Misili.” ");
INSERT INTO mgv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helodi pajamanya baamanya gagipitila sukulinga ndondu bala babia ankongiki, jayomiki ngamaa. Jaamulisa bana boti akanalomi buku musi uku Betelehemu na baabii pambipi jabu, baabii na yaka ibeli na pai jaki akomika. Jwahenga hela kulengana na muda gobabia bumpwagi bandu bala. ");
INSERT INTO mgv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndienu, hegatimia malobi gajapwaga Mlota waka Sapanga jobunkema Yelemia, ");
INSERT INTO mgv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sauti jajoaniki ku Lama, kilelu su usungu nkolongu nu kulobalake. Laheli jaalele bana baki, wala ngakupala kuntulisa, ndaba boti awii.” ");
INSERT INTO mgv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helodi ejakuwa, ntumi juku nani jwaka Bambu ampitila Josepu mu ndotu ku Misili, ");
INSERT INTO mgv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ampwagila, “Jumuka! Gunzukua mwana pamu na nyongoo waki nkelubuka kabee ku ndema uku Izilaeli, ndaba baapala kunkoma mwana hoju akuwike.” ");
INSERT INTO mgv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ndienu, Josepu jajumuka, anzukua mwana pamu na nyongoo waki, nukukelabuka ku ndema uku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lakini Josepu ejajoa Alukelao mwana waka Helodi, jabii nkolongu juku Yudea jalisa kiteu sa atati baki, jajogopa kujenda hoku. Najombi ndaba babiya ankaniki mundotu jajenda upandi uku Galilaya, ");
INSERT INTO mgv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ndienu jatama mmusi gobugukema Nazaleti. Ndi egatimia malobi gajapwaga kwi indela jaka alota baka Sapanga, “Bankema mundu kuhuma ku Nazaleti.” ");
INSERT INTO mgv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Masoba gala Yohana Mmbatisa jajenda, mulukoba luku Yudea, nukutumbuli kaalandi bandu. ");
INSERT INTO mgv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Japwaaga, “Nkotuka kuhenga mahakau gino, ndaba Ubambu ukolongu ukunani kwaka Sapanga guhegali.” ");
INSERT INTO mgv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana ndi joandongalia mlota waka Sapanga Isaya pajapwaaga, “Mundu jujamali kulukoba, ‘Munhandaliya Bambu indela jaki, nnyosa indela jaki.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana jaweti ingobu yeasoniki kwa mangoma gi kinyama sebikikema ngamia nu nkanda wa ngosi mukibunu saki. Posu jaki jabia mapai na busi gumwikioli. ");
INSERT INTO mgv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bandu bunzendila, kuhuma ku Yelusalemu na kuhuma misi yoti yuku Yudea kuhuma ndema yoti yeibii pambipi ja losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bajetakiya mahakau gabu nukugaleka, najombi jaabatisa mu losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lakini pajaabona Afalisayu bingi naka Asadukayu bunhiki ili jaabatisa, jaapwagila, “Mwanganya mwi kibeleku si lijoka! Nya joantonyiki kujepa kutemuliwa na Sapanga kokwihikaje? ");
INSERT INTO mgv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nhenga mahengu gagalangi nndekaki mahakau gino. ");
INSERT INTO mgv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mwiwasali nhwesa kujepa kutemuliwa na Sapanga sukulipwagi, ‘Atati bitu Ibulahimu.’ Numpwagi sakaka, Sapanga juwesa kung'anambu malibu haga gabia bana baka Ibulaimu. ");
INSERT INTO mgv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ndienu lipengu abei punhina ji mikongu, na henu nkongu gokapi wanga kupapa matunda gasapi biitenda kuguseku nukuguleke pamwotu. ");
INSERT INTO mgv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nepani numbatisa kwa masi kulangi nndekaki mahakau gino. Lakini jojuhika munyuma jane jubii nu uwesu kupeta nepani, nane ngasembalika hata kujuku makobasi gaki. Jombi jambatisa kwa Loho jaka Sapanga na kwa mwotu. ");
INSERT INTO mgv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jombi jubi ni kipalu saki mumaboku gaki, ili jupeta ilebi yaki, ni inganu yaki jaibeka mukikoku, lakini mwegeu jagujosa kwa mwotu wanga kususuka.” ");
INSERT INTO mgv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ndienu, Yesu jahuma ku Galilaya, jahika ku losi luku Yoludani, kubatiswa na Yohana. ");
INSERT INTO mgv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakini Yohana jalenga kumpenga, sukupwaga, “Nepani ndi nembala kubatiswa nawe, kubi boo, wehapa guhika kwango?” ");
INSERT INTO mgv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Lakini Yesu anzibua, “Kuleka pe kubia ahelahe kwa sajeno, ndaba ndi ekupalika tutimisa goti gajupala Sapanga.” Ndienu Yohana jatenda kujetake kumbatisa Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu pajajomula pee kubatiswa, jwapita mmasi. Apalapa kunani ku mahundi kwaka Sapanga kwatenda kuhogoka, ambona Loho jaka Sapanga jakahuluka ngati ngunda nu kumete panani jaki. ");
INSERT INTO mgv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sauti kuhuma kunani kwaka Sapanga jajoanika jakapwaga, “Jonzo ndi Mwanangu jonumpai, jojunenganile.” ");
INSERT INTO mgv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ndipala Loho jaka Sapanga jundongua Yesu mbaka kulukoba ili julengwa ni Lijobi. ");
INSERT INTO mgv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Japungiki kula posu masoba komi nsesi muhi ni ikilu, pajajomula jumbina inzala. ");
INSERT INTO mgv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ndienu Lijobi, lunhikila nukunkolo, “Ana wehapa wa Mwana waka Sapanga, ugapwagila malibu aga gabiya mabumunda.” ");
INSERT INTO mgv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu jajibua, “Aandiki mu Maandiku gaka Sapanga, ‘Mundu ngasejuwesa kutama kupete mabumunda pena, ila kwa kila lilobi lejupwaga Sapanga.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ndipala Lijobi lunzukua Yesu mbaka ku Yelusalemu, kumusi wa asapi, ambeka panani jikipagaa sa Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ndienu ampwagila, “Ana wehapa wa Mwana waka Sapanga, lilekala pai, ndaba aandiki mu Maandiku gaka Sapanga, ‘Sapanga jaatuma atumi baki bu kunani bagukenga, nu kugujanga mumaboku gabu, ili walikobando kwaku mu lilibu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ampwagila, “Aandiki kabee mu Maandiku gaka Sapanga, ‘Wandenga Bambu, Sapanga wako.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ndipala, Lijobi anzukua kabee mbaka panani ji kitombi kilasu, andangia ubambu ukolongu wa ndema yoka na nu ukolongu waki woti. ");
INSERT INTO mgv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ndienu lumpwagila, “Yenze yoti misinugupekia ana gunyinamii nu kungungamali.” ");
INSERT INTO mgv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu ampwagila, “Boka neapa Lijobi wee! Aandiki mu Maandiku gaka Sapanga, ‘Gungungamaliya Bambu Sapanga waku, nukuntumakii jombi kajika jaki.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndienu Lijobi lundeka Yesu, na atumi bu kunani kwaka Sapanga bahika kuntumakii. ");
INSERT INTO mgv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu pajajoa Yohana ampeliki mu kipungu, jajenda ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jaboka ku Nazaleti, jajenda ku Kapelinaumu, musi gogubii pambipi nu nhanga uku Genesaleti, gogupakini nu nndema uku Zebuluni nuku Nafutali, jatama kokuje. ");
INSERT INTO mgv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ndi latimia lilobi lejapwaaga Mlota waka Sapanga Isaya, ");
INSERT INTO mgv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nndema guku Zebuluni nu nndema guku Nafutali, indela jukuyetuki ku nhanga mulutengu ja losi luku Yoludani. Galilaya, nndema wa bandu banga Ayaudi! ");
INSERT INTO mgv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bandu baatama pa lwii agubweni unang'anu nkolongu. Nabombi baatama mundema ja lwii ni kihilu sa kuwa, unang'anu gutei kwaanang'ani!” ");
INSERT INTO mgv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tumbuka masoba gala Yesu jatumbuliya kulandi jakapwaga, “Nkotuka kuhenga mahakau, ndaba Ubambu ukolongu ukunani kwaka Sapanga guhegali!” ");
INSERT INTO mgv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu pajabia jujenda mulutengu ju nhanga uku Galilaya, jaabona aka kilongu abeli aloi, Simoni jobunkema Petili nu nndongumundu Andilea. Babia bakalopula homba kwi ilepa mu nhanga ndaba babia aloi. ");
INSERT INTO mgv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu jaapwagila, “Mbwata nepani, na nepani nantenda mwanganya mbia mwa bandu babaleta bandu kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Apalapa biileka ilepa yabu, nukunzengale. ");
INSERT INTO mgv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ejwabia jujenda palongi kidogu, jaabona aka kilongu abeli, Yakobu na Yohana bana baka Zebedayu. Haba babia nkati junhwatu pamu na ahengo babu Zebedayu, bakalenganakiya ilepa yabu. Ndi Yesu jatenda kwaakema, ");
INSERT INTO mgv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nabombi apalapa buguleka nhwatu pamu na ahengo babu, nukunzengale. ");
INSERT INTO mgv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu jayongolatiya Galilaya joa, jatumbuliya kuboola mu nyumba yukuketangane Ayaudi, jaalandila bandu Lijambu la Amboni lu Ubambu ukolongu waka Sapanga. Jaalamisa bandu magonzu goa. ");
INSERT INTO mgv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Majambu gaki gaeni pandu poti ku Silia. Ndienu bandu bumpelakiya agonzu boti, na bandu balwala ugonzu wokapi na baang'alika, baabii ni ilombu, bana kihinduhindu na bandu baalei, najombi jaalamisa boti. ");
INSERT INTO mgv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nsambi nkolongu wa bandu gwatenda kumpwata kuhuma ku Galilaya, nndema yuku Dekapoli maana jaki Misi Komi, Yelusalemu na Yudea na kwii ja losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pajugubona nsambi wa bandu, jakwela ku kitombi, nukutama pai. Banafunzi baki batenda kunzende, ");
INSERT INTO mgv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","najombi jatumbuliya kwaabola, koni jupwaga. ");
INSERT INTO mgv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Apengaliwi bandu babunhobale Sapanga, ndaba Ubambu ukolongu ukunani kwaka Sapanga ndi gwabu. ");
INSERT INTO mgv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Apengiwi babii nu usungu mmoju ndaba jukutenda mahakau, ndaba Sapanga jaakelubukiya kutogule kwabu. ");
INSERT INTO mgv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Apengiwi babunzogopa Sapanga, ndaba biilisa ndema. ");
INSERT INTO mgv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Apengiwi baabii ni inzala na nywita jukuhenga gajagapala Sapanga, ndaba biitenda kutupi. ");
INSERT INTO mgv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Apengiwi baabii ni ikia, ndaba Sapanga jaabonila ikia. ");
INSERT INTO mgv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Apengiwi bana mwoju wa sapi, ndaba bammbona Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Apengiwi baaleta lukwali, ndaba baakema bana baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Apengiwi baang'alika ndaba jukuhenga gajupala Sapanga, ndaba Ubambu ukolongu ukunani kwaka Sapanga ndi gwabo. ");
INSERT INTO mgv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mpengaliwi mwanganya bandu na buntondoo, nunkung'alisa nu kunkopake kwi isoli, ndaba mwanganya mbwata, ");
INSERT INTO mgv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ntoguliya nukululuta ndaba nhupi inu ngolongu ibi ku maundi. Ndaba hela ndi ebaang'alisa alota baka Sapanga bababii kabula jukusaliwa mwanganya. ");
INSERT INTO mgv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwanganya ndi mwinyu gu pundema. Lakini mwinyu naguhoiki kunoga kwaki, boo, mwiibeka kii mbaka jinoga kabee? Ngasejibii ni lihengu kabee, ila aleke kunza nukukanyatwa na bandu. ");
INSERT INTO mgv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwanganya ndi unang'anu wu nndema! Musi goasengiki panani ji kitombi ngaguwesi kuhihiika. ");
INSERT INTO mgv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wala bandu ngaseapambaki taa nu kujiyekale ni kitonga, ila abeka panani ji kipanda ili gwamulakya boti baabii mu nyumba. ");
INSERT INTO mgv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ahelahe, mwanganya unang'anu winu gunang'ana palongi ja bandu, ili bagabona mahengu ginu gaamboni ganhenga, ili baalumbaliya atati binu bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mwiholale hikiki kuputa malagalaki gaka Musa na mabolee gaka alota baka Sapanga. Ngasenhikiki kuputa ila kugatenda gabiya ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Numpwagi sakaka, mbaka kunani kwaka Sapanga nu nndema ekwipeta, nga hata nukuta jimu au lilobi lisokopi mu Malagalaki leliiboka, mbaka goti pagiitimia. ");
INSERT INTO mgv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndienu jokapi jojiikana lilagisu lisokopi kuhuma ku Malagalaki gaanga, nakaabola bangi ahenga hela, mundu hoju jwiibia msoku ngani mu Ubambu ukolongu ukunani kwaka Sapanga. Lakini jojukamulaki Malagalaki na kwaabola bangi ahenga hela, hoju jwibiya nkolongu mu Ubambu ukolongu ukunani kumaunde. ");
INSERT INTO mgv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Numpwagi sakaka, ana ngasenhenga gajupala Sapanga kwaapeta abola ba Malagalaki na aka Afalisayu, kyee ngamwijingii mu Ubambu ukolongu ukunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nnzoini bandu ba mwandi baapwagila, ‘Wikoma na mundu jokapi jojikoma jupalika kutemuliwa.’ ");
INSERT INTO mgv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakini nepani numpwagi sakaka, jokapi joanhyome ndongu waki, buntenda kuntemu. Mundu joantondo nndongu waki bampelika pasengu. Mundu joankema nndongu waki, ‘Nng'ang'a’ jubii pambipi kujingi mmwotu wanga kususuka masoba goa.” ");
INSERT INTO mgv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ndienu, egupeleka matambiku gaku palongi ja mesa jukupiiki litambiku na papuje gukomboka gukomini nu nndongu waku, ");
INSERT INTO mgv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wagaleka hoti matambiku gaku palongi ja mesa jukupiiki litambiku, jenda hoti wakajomulania nu nndongu waku, ndi wikelubuka kupia litambiku laku. ");
INSERT INTO mgv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mundu na jugutaki, jongana na jojugutaki nyata mwindela kabula jukujenda pasengu, anangahela jojugutaki jagukabisa kwaka jojutemu, najombi ntemu jagukabisa kwaka nndonda, nanagu wikongika kukipungu. ");
INSERT INTO mgv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nugupwagi sakaka, ngawipiti mukipungu mola mbaka gwilepa lingengalema la mwisu.” ");
INSERT INTO mgv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nnzoini bandu bumpwagila, ‘Mwitenda ugoni!’ ");
INSERT INTO mgv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakini nepani numpwagi, joandingali mmbomba nukuntokule, jutei naku ugoni mmoju jaki. ");
INSERT INTO mgv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ana ngati liu laku la malele lugukolo kuhenga mahakau, tupula ukalekala kutali. Nambanga kuhoa kipandi simu sa nhyega jaku, kuliku nhyega jaku joti kuleke mmwotu wa masoba goa. ");
INSERT INTO mgv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anangati kuboku kwaku kwa malele gukukolo kuhenga mahakau, sekula wakalekala kutali. Nambanga kuhoa kipandi simu sa nhyega jaku, kuliku nhyega jaku joti kuguleke mmwotu wa masoba goa.” ");
INSERT INTO mgv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Apwagiki kabee, ‘Joandeka nhanu waki, kupalika ampekiya likalatasi lu kutalikana.’ ");
INSERT INTO mgv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakini nepani numpwagi, mundu jokapi joantalika nhwanu waki, ila pee ndaba jutei ugoni, ankolo jutenda ugoni, na mundu jokapi anajujukwi mmbomba joantaliki, najombi kabee jutenda ugoni.” ");
INSERT INTO mgv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kabee nzoini bandu ba mwandi ebaapwagila, ‘Wikotoka kutenda sewalagila kutenda, ila gutimisa kulagi kwaku kwa Bambu.’ ");
INSERT INTO mgv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakini nepani numpwagi, mwilapa, wala su kunani kwaka Sapanga, ndaba senyesi ndi kiteu su ubambu saka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala kulilapi kwa nndema, ndaba paniapa ndi pandu pukubeke magolu gaki, wala ku Yelusalemu, ndaba goniogu ndi musi waka Bambu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala wilapa su umutu waku, ndaba ngaseguwesa kuling'anambu lijunzu limu kuba lihuu au lijilu. ");
INSERT INTO mgv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Anagupwagiki, ‘Hena,’ kubia, ‘Hena,’ na gupwagiki, ‘Ngahela,’ kubia, ‘Ngahela.’ Sokapi sekijonzuke haga kihuma kuku Mbaja jola.” ");
INSERT INTO mgv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nzoini ebapwaaga, ‘Lihu kwa lihu na linu kwa linu.’ ");
INSERT INTO mgv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakini nepani numpwagi, gwandepa sindu silia mundu mbaja. Mundu ana jugulapwi likopi lituku luku malele, kabee gundeka jugulapula lituku luku mangega, ");
INSERT INTO mgv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu ana jukutaki ili kugujukuki likoti laku, gundeka jujukua na kaputi jaku. ");
INSERT INTO mgv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu anajupala untotuliya nsigu waki kilumita jimu, witotula kilumita ibeli. ");
INSERT INTO mgv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gumpekiya jojuguloba, na jojuguloba wannzima.” ");
INSERT INTO mgv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nnzoini ebapwaaga, ‘Gumpala nnzako na gunsukila jojugusuki.’ ");
INSERT INTO mgv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lakini nepani numpwagi, mwaapala banga kumpala na kwaalobe kwaka Sapanga babunng'alisa mwanganya, ");
INSERT INTO mgv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ili mbia mwabana ba Atati binu baabii kunani ku mahundi. Ndaba lyoba laki laanang'ani bandu abaya na baamboni, na kwaakuni iyula bandu baabi abaya na baamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ana mwaapai babumpai pee, boo, mwiipata nhupi bole? Ndaba baajopa kodi nabombi ahenga ahelahela! ");
INSERT INTO mgv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ana mwaalamuki alongu bii pena, boo ntenda sindu boo sakwaapea bandu bange? Hata bandu banga kummanya Sapanga, ahenga ahelahela. ");
INSERT INTO mgv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Henu, mbia momkamiliki, ngati Atati binu bu kunani kwaka Sapanga ebii akamiliki.” ");
INSERT INTO mgv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nnzepa kuhenga mahengu gaamboni palongi ja bandu ili mbonikana. Ndaba anantei hela ngamwiipati nhupi jokapi kuhuma kwa Atati binu bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Henu, hemunzangati mundu nhagu sindu sokapi, walilangii kwa bandu. Wiihenga ngati bandu babilikopake baamboni, heahenga mu manyumba gukuketangane Ayaudi na mwiindela ili bandu baalumbaliya. Numpwagi sakaka, baniaba apatiki nhupi yabu yoti. ");
INSERT INTO mgv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakini wehapa egunzangati nhagu, henga kinunu hata nkosi waku jwimanya seguhenga. ");
INSERT INTO mgv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Waajangatya ahagu kinunukinunu, na Atati baku babagabona gaguhenga mukinunu, bagupekiya nhupi. ");
INSERT INTO mgv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pamundoba Sapanga, mwihenga ngati babilikopake baamboni. Ndaba bombi apala kujema kundoba Sapanga mu manyumba gukuketangane Ayaudi na mumagobukanu giindeela ili bandu baabona. Numpwagi sakaka, haba apatiki nhupi yabu yoti. ");
INSERT INTO mgv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lakini wehapa pagundoba Sapanga, jingala nsumba saku, jigala ndyangu waku, ndi waaloba Atati baku banga kubonikana. Ndienu Atati baku babagabona gauhenga sujobu bagupekiya nhupi. ");
INSERT INTO mgv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pamundoba Sapanga, mwiposukana malobi gingi ganga na mana ngati ehenga bandu banga kummanya Sapanga. Ndaba bombi awasali baajogwaniya ndaba ja malobi gabu kuba gingi. ");
INSERT INTO mgv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mwikuba ngati bombi, ndaba Atati binu amamyiki gampala kabula ngasemwalobiki. ");
INSERT INTO mgv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lakini mwanganya nndoba ana, ‘Atati bitu mombii kunani kwaka Sapanga kwaka Sapanga, liina linu lilumbalika ngani. ");
INSERT INTO mgv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ubambu ukolongu waku guhika, gagupala gahengika pundema ngati kunani kwaka Sapanga kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gutupekiya lelenu posu jitu ja kila lisoba, ");
INSERT INTO mgv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gutulekakiya mahakau gitu, ngati twepani etwalekake babutukosi. ");
INSERT INTO mgv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Watujingisa mu milengu, lakini utuhokua kuhuma kuku Mbaja jola.’ ");
INSERT INTO mgv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Namwalekaki bangi babunhengi giliya, Atati bii bu kunani kabee bandekakya na mwanganya giliya gamwahengi bangi. ");
INSERT INTO mgv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lakini nanga kwaalekake bandu bangi, Atati binu bu kunani ngabandekake mahakau gino. ");
INSERT INTO mgv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pampunga kula posu, mwiikuba nhyomiki ngati bandu baakopake baamboni heatenda. Bombi atulana pamihu jabu ili abonikana kwa bandu atei kupunga kula posu. Numpwagi sakaka, haba apatiki hupi yabu. ");
INSERT INTO mgv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakini pagupunga kula posu, gusamba pamihu jaku, gupakia mahuta kumutu jaku, ");
INSERT INTO mgv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili wiimanyikana kwa bandu gutei kupunga kula, ila amanya Atati baku banga kubonikana pee. Nabombi Atati baku babagabona gagilihihiki, jampekia nhupi. ");
INSERT INTO mgv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mwalibeke kikoku pundema, momuje nkeki na kutu itenda kuhalabana na bii atenda kubombo nuku kujiba. ");
INSERT INTO mgv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lakini mlibekila mali kunani kwaka Sapanga, kokuje ibongo na kutu ngaseiwesia, kuhalabana hata bii ngaawesi kutunu nu kujingi kujiba. ");
INSERT INTO mgv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ndaba pagabi mali gaku ndi pagubii moju waku.” ");
INSERT INTO mgv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lihu ndi unang'anu wa nhyega. Ana lihu laku libi sapi, nhyega jaku joti jibii pu unang'anu. ");
INSERT INTO mgv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lakini ana lihu laku libohu, nhyega jaku joti jiibya mu lwii. Lakini, ana unang'anu gogubii nkati jaku gubii na lwii, ndienu lwibiya lwii tikitiki! ");
INSERT INTO mgv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nga mundu jojuwesa kwaatumaki akakolongu abeli, ndaba ansukila jumu nukumpala jongi, au jijongana na jumu kundongama jongi. Ngakuwesa kuntumaki Sapanga napapa nukutumaki mali. ");
INSERT INTO mgv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Henu numpwagi, mwihangajaki posu wala sa kunywa ili nhwesa kutama, wala ingobu yempalika kuwata mu nhyega inu. Boo, womi lee ngasindu kikolongu kupeta poso? Na nhyega boo, nga lee sindu kikolongu kupeta ingobo? ");
INSERT INTO mgv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwilingaliya ijuni yu nnani, yombi ngaseipanda wala kuhusa wala kubeka sokapi mwikikoku, lakini Atati binu bu kunani biilea. Boo, mwanganya lee ngase mpalika kujangatiwa ngani kupeta ijune? ");
INSERT INTO mgv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nyaa kati jinu kukulihangajisa kwaki juwesa kujonzuke ulasu wa womi wake hata kwilisaa limo? ");
INSERT INTO mgv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ndaba jakii nhangajaki ingobo? Nndingaliya maua gimwikiholi egakola. Ngasegahenga lihengu wala kulilenganake ingobu. ");
INSERT INTO mgv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lakini numpwagi, hata Bambu Solomoni na hindu yaki hingi yoti, ngasebawahiki kunhwatika ngati maua haga. ");
INSERT INTO mgv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Henu ana Sapanga jagawatika maua libi lelenu ni kilabu bagaleke pamwotu, boo Sapanga ngajanhwatiki mwanganya nakanope? Mwanganya mombii nukuhobale kusokopi! ");
INSERT INTO mgv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Henu, mwiihangajaki kupwaaga, ‘Twiikula kii au twiikunywa kike? Au twiiwata kiki!’ ");
INSERT INTO mgv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndaba haga goti bagahangajaki bandu banga kumanya Sapanga. Atati binu bu kunani kwaka Sapanga amanyiki mpala hindu heyi yote. ");
INSERT INTO mgv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakini ntaputa oti Ukolongu waka Sapanga, nu nnhenga goti gajupala Sapanga, na gangi haga goti jiitenda kunzonzuke. ");
INSERT INTO mgv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Henu mwihangajaki gi kilabu, ndaba gi kilabu galihangajakiya geni. Matatisu gilisoba limu gatosane kulisoba heli.” ");
INSERT INTO mgv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mwaatemu bandu bangi, ili nanamu mwiitemuliwa na Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ndaba emwatemu bandu bangi, ndi nanamu ebantemula. Kipemu aselase sentumii kwa kwaatemu bandu bangi ndi Sapanga sejwitumia kuntemu mwanganya. ");
INSERT INTO mgv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndaba jakii ukibona kijola sekibii mmihu jaka nndongu waku, na papa ngakulubona lumbagau lolubii nndiu jako? ");
INSERT INTO mgv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Guwesa boo kumpwagi nndongu waku, ‘Nndongu wango, lekaoti nuguboi kijola sekibii nndiu jaku,’ koni wamweti gubii nulumbagau nndiu jako? ");
INSERT INTO mgv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Weapa ulikopake waamboni! Guboa oti lumbagau lolubii nndiu jaku ndi wiwesa kukibona sapi kijola sekibi kukunndongu waku.” ");
INSERT INTO mgv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mwaipeke himbwa hindu ya sapi ndaba yaa nng'anambuka nukuntukali nukunduma. Mwagalekale magolobi mayuda gii ndaba biitenda kukanyatakanyata kwa magolu gabu. ");
INSERT INTO mgv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nndoba nanamu biitenda kumpeke, ntaputa nanamu mwitenda kupata, nhotima nanamu biitenda kunhogule. ");
INSERT INTO mgv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ndaba, mundu jokapi jojuloba atenda kumpeke na jojutaputa jutenda kupata na jojuhotima atenda kunhogule nndyangu. ");
INSERT INTO mgv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Atati boo, kati jinu mwana waki ana andobiki libumunda ampekia lilibo? ");
INSERT INTO mgv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au anajulobiiki homba, ampekia lijoka? ");
INSERT INTO mgv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ana mwanganya mwabaya mmanya kwaapeke bana bii nhupi ya sapi, boo Atati bii bu kunani ngalee biijonzuke kaapeke hindu ya sapi babunndoba? ");
INSERT INTO mgv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Goti gampala bandu banhengila mwanganya, mwaatendila bombii ahelahela, ndaba Malagalaki gaka Musa na mabole ga Alota gapwaaga ahelahe. ");
INSERT INTO mgv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nnzingala kupete nndiyangu mpepandau. Ndaba indela jejilongoo ku kuwa ndi ngolongu na bandu baapeta indela heji bingipi. ");
INSERT INTO mgv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lakini indela jejilongoo kuwomi nzoku nu ndyangu ukujingali mpepandau na bandu babijibona indela heji asokope.” ");
INSERT INTO mgv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nnzepana na alota biisoli. Babunhiki kunza abonikana makondoo, lakini nkati abonikana imei ikali. ");
INSERT INTO mgv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mwaamanya kwa mahengu gabo. Boo bandu lee atongo matunda mizabibu mu mikongu ja miha, au atongo lee tini mumbigile? ");
INSERT INTO mgv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nala nkongu wa sapi gutenda kupapa matunda gasapi nu nkongu gwilyaa gupapa matunda giliya. ");
INSERT INTO mgv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongu wa sapi ngase gupapa matunda giliya nu nkongu gwiliya ngase gupapa matunda gaa sape. ");
INSERT INTO mgv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongu gwanga kupapa matunda gaa sapi aguseku nukuguleke pamwotu. ");
INSERT INTO mgv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Henu mwaamanya alota biisoli kwa mahengu gabu.” ");
INSERT INTO mgv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nga kila jojungema, ‘Bambu, Bambu’ jwijingala mu Ukolongu ukunani kwaka Sapanga, ila jojuhenga gaapala Atati bangu babii kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mlisoba le lela bandu bingi biimbwagila, ‘Bambu, Bambu! Kwiliina laku twaalandila bandu lilobi laka Sapanga nu kwiliina laku twaapia bandu ilombu nu kwiliina laku tuhengika nginyuli hingi.’ ");
INSERT INTO mgv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ndienu naapwagila, ‘Kye ngasenummanyiki mwanganya. Mmbokaniya palongi jangu moutenda mahakau!’ ");
INSERT INTO mgv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Henu, kila mundu jojujoana malobi gangu nu kugahenga, julengana na mundu jwana malangu, jojusengiki nyumba jaki panani ji lilibu likolongu. ");
INSERT INTO mgv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iyula jatenda kukuna, losi yatenda kutwele kikoka, kimbonga satenda kupoga nukujikanga nyumba heji. Lakini nyumba heji ngasejahabwiki ndaba nsingi waki basengiki nkati jililibu.” ");
INSERT INTO mgv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lakini mundu jokapi jojujoana malobi gangu na ngase juhenge lihengu, julengana na mundu nng'anga, jojusengiki nyumba jaki panani ju nsangi. ");
INSERT INTO mgv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iyula jatenda kukuna, losi yatenda kutwele kikoka, nhwai watenda kupoga nukujikanga nyumba jela, najombi jabombuka nukuhabuka joka.” ");
INSERT INTO mgv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu ejajomula kupwaaga malobi haga, nsambi wa bandu gogunnzoannya gwasangii ngamaa mabole gaki. ");
INSERT INTO mgv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ndaba jabola ngati mundu junu uwesu nkolongu, nga ngati aka abola babu ba malagalaki. ");
INSERT INTO mgv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ejahuluka ku kitombi, nsambi nkolongu wa bandu watenda kumpwata. ");
INSERT INTO mgv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mundu jumu jojuleliki anzendila, anzinamia nukupwaga, “Bambu, ana gupai guwesa kunyambisa.” ");
INSERT INTO mgv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu jwanyosha kuboku kwaki angusa mundu jojuleliki jola nukumpwagi, “Mbala gunyambisika.” Apalapa mundu jola jatenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ndipala Yesu ampwagila mundu jola, “Jowania, wampwagi mundu jokapi, ila gujenda ukulilangia kwaka nngolu nkolongu na ukapia litambiku lejalagalakiya Musa, kwaalangi bandu gulamiki.” ");
INSERT INTO mgv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu pajabia jujingii ku Kapelinaumu, nkolongu jumu jwa alonda juku Loma anzendila, nukunndoba anzangatia, ");
INSERT INTO mgv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ampwagila, “Bambu, mtumi wangu jugoni kunyumba, nngonzu jukulela nhyega kabee julwala ngamaa.” ");
INSERT INTO mgv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ampwagila, “Niijenda kundamisa.” ");
INSERT INTO mgv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lakini nkolongu jola ampwagila, “Bambu, nepani ngase kupalika wehapa gujingila mu nyumba jango. Lakini pwaga lilobi pee, nu ntumi wangu jwiitenda kulama.” ");
INSERT INTO mgv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Ndaba, hata ngama nepani anongo akolongu bangi kabee mi na alonda banaalongo. Nunndagalaki ajojo, ‘Jenda’ najombi jutenda kujenda, nunndagalaki jongi, ‘Hikaa’ najombi jutenda kuhika. Kabee ana nunndagalaki ntumwa wangu, ‘Henga ase’ najombi jutenda kuhenga.” ");
INSERT INTO mgv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ejajoana malobi gala, jatenda kusanga, jaapwagila bandu babumpwatiki, “Numpwaagi sakaka, ngase nhwaiki kumbona mundu jokapi pa Izilaeli pani jojuhobale ngati ajo. ");
INSERT INTO mgv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Numpwaagi sakaka, bandu bingi bihika kuhuma ku kolipita lioba nu kolihobe lioba, nabombi biitama pa tipati gakula posu pamu na Ibulahimu na Isaka na Yakobu mu Ukolongu ukunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakini bandu baapalika kuba mu ubambu ukolongu waka Sapanga, mitibaalekala kunza, kolubii lwii, kokuje biibiya alela nukupola minu.” ");
INSERT INTO mgv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ndipala Yesu ampwagila nkolongu jola, “Jenda kunyumba na gaguhobali haga giitenda kuhengeka.” Nu ntumi jola jatenda kulama muda agolagola. ");
INSERT INTO mgv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ejajingala mu nyumba jaka Petili, jaakolila akowanu baka Petili agoni pikitanda abii na homa. ");
INSERT INTO mgv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ndienu, Yesu angusa nyongoo jola kuboku, na homa jela jatenda kukotoka, jatumbuliya kuntumaki Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ekwabiya pakamii, bandu bundetila Yesu bandu bingi bababii niilombu, Yesu jaaboa ilombu sukupwaga pee lilobi, ndi jaalamisa bandu boka bababi agonzu boti. ");
INSERT INTO mgv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jahenga hela ili gatimia gajaapwaga mlota jwaka Sapanga Isaya, “Jombi mweni jujukwi mang'aliku gitu kabee jutotwi magonzu gitu.” ");
INSERT INTO mgv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu ejugubona nsambi wa bandu gunhyongaliti, jaapwagila banafunzi baki ajenda kwii ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mmbola jumu jwa Malagalaki anzendila Yesu, ampwagila, “Mmbola, nepani nagupwata kwokapi kola kowijenda.” ");
INSERT INTO mgv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu jajibua, “Mabwea gabii na mapoli gabu, ni ijuni yukunani ibii ni miui jabu, lakini mwana waka Mundu nga na pandu puku pomulalela.” ");
INSERT INTO mgv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mbolee waki jumu ampwagila, “Bambu, nyetakaliya nyenda kunyumba nakaataga atati bangu.” ");
INSERT INTO mgv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lakini Yesu ampwagila, “Mbwata! Waaleka baawii baataga baawii ajabu.” ");
INSERT INTO mgv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu pajajingala munhwatu banafunzi baki batenda kumpwata. ");
INSERT INTO mgv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Apalapa, gapitila majeba makolongu munhanga na masi gatumbuliya kuguyekale nhwatu. Lakini Yesu jabiya jugosi lugonu. ");
INSERT INTO mgv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Banafunzi baki bunzendila, bunzumua nukupwaaga, “Bambu, utuokuaje tutenda kuwa!” ");
INSERT INTO mgv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lakini Yesu jwaapwagila, “Mwabandu bini lihobale lisokopi mwanganya, ndaba jaki ntenda kujogopa?” Ndienu, jajumuka jagalakaliya majeba makolongu gala nu nhanga gola gwatuli nuu. ");
INSERT INTO mgv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Banafunzi baki basangi nukupwaga, “Jonioju we mundu bole? Hata unhwai na majeba gatenda kunzoanela!” ");
INSERT INTO mgv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ejahika kwii ju nhanga, munndema wa Agadala, jwaketangana na bandu abeli baabii ni ilombu bakahumila kutenge. Bandu haba babiya ajogoo ngamaa, nga mundu jojalenga kupeta indela jela. ");
INSERT INTO mgv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Apalapa batenda kujamalii, “Gupala kike kwito, wehapa wa Mwana waka Sapanga? Guhikiki pamba kutung'alisa kabula ji lisoba litu kuhika?” ");
INSERT INTO mgv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pambipi na pandu pehapa kwabii na magolobi gingi gakakula. ");
INSERT INTO mgv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ilombu yela yundoba Yesu, “Anautubenga, nambanga utujetakiya tugajingala magolobi galaga.” ");
INSERT INTO mgv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jaapwagila, “Hena mmbokaniya.” Ndienu yaapiita bandu bala, nu kujingii mwamagolobi, na magolobi ge gatilila pilikemba luku nhanga nukujingi mu nhanga, na goti gakuwa mmasi. ");
INSERT INTO mgv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Alimu ba magolobi bala batilila ku musi. Hoku baalandila bandu kila sindu sesapitila na gagaapitila bandu bababii ni ilombu. ");
INSERT INTO mgv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bandu boti ba musi we gola bunzendila Yesu, pabumbona bundoba juboka mu nndema wabu. ");
INSERT INTO mgv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu jwajingala mu nhwatu, jalombuka nhanga, nukuhika mmusi waki. ");
INSERT INTO mgv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bandu bangi bundetila mundu jojulei, babia angoniki pu mpandu. Yesu ejukubona kuhobale kwabu, ampwagila mundu jojulei jola, “Mwanango, hobaliyaje, mahakau gaku galekakiwi.” ");
INSERT INTO mgv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abola bangi ba Malagalaki bapwaga mu mioju jabu, “Mundu hajo antondo Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu jagamanyiki mawasu gabu, jalalukiya, “Ndaba jakii nhwasali ubaja mu mioju jino? ");
INSERT INTO mgv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Laa lelipepwiki ngani, kupwaga, ‘Gulekakiwi mahakau gaku,’ au kupwaaga, ‘Jema gujendaje?’ ");
INSERT INTO mgv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lakini, nepani mbala mmanya Mwana waka Mundu jubii nu uwesu wakalekake bandu mahakau.” Ndienu ampwagila mundu jojulei jola, “Jukua mpandu waku gujenda.” ");
INSERT INTO mgv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mundu jola jajema nukujenda kunyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bandu pababona gala, batenda kujogopa, bundumbaliya Sapanga jojaapeki bandu uwesu wehogu. ");
INSERT INTO mgv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu pajaboka pala, ambona mundu jumu jobunkema Matei jutemi mu nyumba jukulepe kodi. Ampwagila, “Mbwata.” Matei jajema nukumpwata. ");
INSERT INTO mgv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pajabia jutemi kula posu ja pakamii mu nyumba jaka Matei, baajopa kodi bingi na baabii na mahakau bahika kula pamu najombi na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afalisayu ebagabona haga, baalalukiya banafunzi baki, “Mbona mmbola winu jukula pamu na baajopa kodi na bana mahakao?” ");
INSERT INTO mgv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu pajwajoana haga, japwaaga, “Bandu babii bomi ngaseampala aka singanga ila baalwala ndi baapala aka singanga. ");
INSERT INTO mgv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nzendaniya mukilibola maana ja Maandiku gaka Sapanga gaga pwaga, ‘Mbala ikia wala nga matambiku.’ Ndaba ngasenahika kwaakema bandu baamboni palongi jaka Sapanga ila bandu bana mahakau.” ");
INSERT INTO mgv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ndipala banafunzi baka Yohana Mmbatisa bunzendila Yesu, nukundaluki, “Mbona twepani na Afalisayu tupunga kula posu lakini banafunzi baku ngaseapunga kula posu?” ");
INSERT INTO mgv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu jajibua, “Boo kuwesikana lee bandu babaakokiki ku ndoa kupunga kula posu koni bambu wa ndoa jubii pamu nabo?” Ngahela, ngasekuwesikana! Liihika lisoba bambu ndoa bamboa kwabu, lisoba leheli ndi pabipunga kula posu. ");
INSERT INTO mgv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mundu ngasejuseku kibambu si ingobu inyai nukusone mwiingobu jejilaile. Ana jutei hela, ingobu inyai jela jiijendula ingobu jejilai jela, na papajendwiki jepala piitenda kujonzukeka. ");
INSERT INTO mgv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kabee nga mundu jojujege divai inyai mumipuku ja ngosi ja mwandi, ana jutei hela, mipuko jela jiitenda kupojoka na divai inyai jela jiitenda kujitika ni mipuku ja ngosi jitenda kuhalabika. Ila bandu abeka divai inyai mu mipuku minyai, na yoti ibeli yiibia abei pandu pa sapi.” ");
INSERT INTO mgv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pajabiya jupwaga haga, kilongosi jumu Nhyahudi jwahika, anzinamiya nukupwaga, “Kamwali wangu juwii hesajeno, lakini gupepa koku, guhika kumbeke kuboku ili julama.” ");
INSERT INTO mgv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu jajumuka nukumpwata na banafunzi baki batenda kupwata. ");
INSERT INTO mgv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mmbomba jumu jojuwe jabi nuugonzu ukujauka ku kipindi sa yaka komi ni ibeli, jahika munyuma jaka Yesu angusa lupeta lwi ingobu yaki. ");
INSERT INTO mgv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jilipwagila mmoju jaki, “Anangamwi pe ingobu yaki niitenda, kulama.” ");
INSERT INTO mgv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ejang'anumbuka jwatenda kummbona ampwagila, “Kamwali wangu ulikasa mwoju! Kuhobale kwaku kugulamise.” Apalapa mbomba wejola jatenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ndipala Yesu jajingala mu nyumba jaka kilongosi jola. Na ejaabona bandu ajemba mapenenga na bandu bingi atenda kulobalake, ");
INSERT INTO mgv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","jaapwagila, “Mpitaniya kunza! Kamwali jonzo ngasejakuhike, ila jutei kugone pena.” Lakini bombi batenda kunheka. ");
INSERT INTO mgv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lakini bandu pababiya baapiiki kunza, Yesu jajingala nkati ankamula kuboku kamwali jola, apalapa najombi jatenda kujema. ");
INSERT INTO mgv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lijambu leheli laeniya nndema woti. ");
INSERT INTO mgv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu pajaboka pala, hejwabia mwiindela bangalinga abeli bunkagula koni bakajamaliya kwa makili, “Mwana waka Daudi, utubonila ikia.” ");
INSERT INTO mgv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu ejajingala nkati, bangalinga abeli bala bunzendila, najombi jaalalukiya, “Boo, nnhobale lee nepani nhwesa kundamisa?” Nabombi bajibua, “Ena Bambu.” ");
INSERT INTO mgv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Papuje Yesu jagusa mihu gabu, nukupwaga, “Kubia kwinu ngati enhobali.” ");
INSERT INTO mgv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mihu gabu gatenda kulinga. Najombi Yesu jaakanakia suukali, “Mwampwagi mundu jokapi lijambu leheli.” ");
INSERT INTO mgv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakini bombi ebaboka, balandila majambu gaka Yesu pa ndema jela. ");
INSERT INTO mgv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pababiya atenda kuboka, bandu bundetila Yesu kimumuta, jojabii ni ilombu. ");
INSERT INTO mgv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Apalapa kilombu sela pasaboka, mundu jojabii kimumuta jola jatumbuliya kulonge. Bandu basangia nukupwaaga, “Lijambu ngati ale ngaseliwaiki kupitii pa Izilaeli!” ");
INSERT INTO mgv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakini Afalisayu bapwaaga, “Nkolongu jwi ilombu ndi joampeke Yesu makili gukuboa ilombu.” ");
INSERT INTO mgv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu jayongolota mmisi joti ni ijiji yoti koni jakabola mu nyumba yukuketangane Ayaudi gabu nukulandi Majambu ga Sapi gu Ubambu Ukolongu waka Sapanga, nakalamisa bandu kila magonzu nukung'alika kwoti. ");
INSERT INTO mgv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu pajugubona nsambi wa bandu, jaabonila ikia ndaba babiya asokiki na abii ni kiholu, na babiya abaganyiki ngati makondoo ganga nu nndimi. ");
INSERT INTO mgv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Papuje jaapwagila banafunzi baki, “Ilebii yukuhusa ibii hingipi lakini baahenga lihengu lukuhusa be asokopi. ");
INSERT INTO mgv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndienu mundoba Bambu jojuhusa, jaaleta bahenga lihengu mlitui laki.” ");
INSERT INTO mgv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu jaakemaa pamu banafunzi baki komi na abeli, jaapekiya uwesu gukupia ilombu nuku lamisa magonzu na mang'alisu goka. ");
INSERT INTO mgv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mahina ga atumi haba ganga: jutumbuli Simoni jobunkemika Petili nundonguwaki Andilea na Yakobu nu ndongu waki Yohana bana baka Zebedayu. ");
INSERT INTO mgv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipi na Batolomayu na Tomasi na Matei jojabii jojujopa kodi na Yakobu mwana waka Alufayo na Tadei, ");
INSERT INTO mgv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni jojukomane nndema waki na Yuda Isikalioti joang'anumbuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu jaatumaa atumi komi na abeli haba, jaapekia uwesu nakaalagalaki, “Mwijenda kwa bandu banga Ayaudi, wala mwijingi mmisi ya Asamalia. ");
INSERT INTO mgv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila nzendannya kwa bandu buku Izilaeli baobiki ngati makondoo gagahobiki. ");
INSERT INTO mgv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Enzenda, mkalandila ana, ‘Ubambu ukolongu waka Sapanga guegali.’ ");
INSERT INTO mgv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwalamisa agonzu, mwaayoa baawii na mwaanyambisa baaleliki, mwakapia ilombu. Mpatiki bwaka mwakaboa bwaka. ");
INSERT INTO mgv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mwiitoto zaabu mumipuku jinu wala feza, wala lingengalema la shaba. ");
INSERT INTO mgv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mwitoto nkoba wa sapwali mwiindela, wala majalisi mabeli wala makobasi mabeli wala ndonga. Ndaba jojuhenga lihengu jwiipata gajupala kila lisoba.” ");
INSERT INTO mgv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Emwakajingala ku musi au kijiji sokapi mukuntaputa mundu jwaamboni jojupai kunzopa, mwakatama pala mbaka pamwiboka. ");
INSERT INTO mgv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Emwakajingala mu nyumba mwakalamukiya bandu babii nyumba mola, ‘Lukwali lubia na mwanganya.’ ");
INSERT INTO mgv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ana bandu ba nyumba bunzopiki, ndienu lukwali lwinu lwibiya pamu nabombi. Lakini anangasebunzopiki, ndienu lukwali lukunkelabukia mwabee. ");
INSERT INTO mgv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ana mundu jokapi jwiikana kunzopa au kunzoane malobi ginu, emwakaboka mu nyumba jeheji au musi wehogu, mwakakung'unda luhombi mu magolu kulangi akaniki kunzopa. ");
INSERT INTO mgv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Numpwaagi sakaka, lisoba lu kutemu bandu bamusi hogu biitemuliwa ngani kupeta bandu buku musi uku Sodoma na Gomola. ");
INSERT INTO mgv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nnzoaniya, nepani nuntuma mwanganya ngati makondoo pikilanda ji imei. Henu mmbia na malangu ngati lijoka, na mmbia mwaapoli ngati ngunda. ");
INSERT INTO mgv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nzepana na bandu, ndaba bampelika mwanganya ku sengu, nukunndapu iboku munyumba yabu yukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bampelika palongi ja aka kilongosi na aka bambu akolongu ndaba jangu nepani, nndandila Lijambu la Amboni kwabu na kwa bandu banga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lakini pabankamula mwanganya, mwihangajika kuwasali gamwiipwaga, ndaba mwipata sukupwaga muda gogo. ");
INSERT INTO mgv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ndaba nga mwanganya mo mwibia mwakalongila ila Loho ja Atati binu biipwaga kupete mwanganya. ");
INSERT INTO mgv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mundu ang'anumbuka nndongu waki ili jukomika, na atati banng'anumbuka mwanamundu, nabombi bana bahang'anambuka atati na amabu babu na kaakoma. ");
INSERT INTO mgv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bandu boti bansukila mwanganya ndaba jukunhobale nepani. Lakini jojihinakaliya mbaka pa mwisu, ndi jojikombulika. ");
INSERT INTO mgv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pabanng'alisa mmusi gumu, mwitilila mmusi gongi. Numpwagi sakaka, ngamwijomo lihengu lii mmisi joti juku Izilaeli kabula Mwana waka Mundu kuhika. ");
INSERT INTO mgv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mmbolee ngasejuwesa kumpeta mmbola waki wala mtumisi ngase juwesa kumpeta bambu waki. ");
INSERT INTO mgv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lakini tosa mmbolee kuba ngati mmbola waki, nu mtumisi kuba ngati bambu waki. Ila anabunkemiki nkolongu jwa nyumba Belizebuli, boo, bandu baatama mu nyumba mola nga bunkemi mahina giliya ngane? ");
INSERT INTO mgv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ndienu, mwaajogopa bandu. Kila sindu sekiyekaliki sitenda kuyekulika, na kila sekihikiki sitenda kubonikana. ");
INSERT INTO mgv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lenumpwagi mwanganya mulwii, mlipwaaga pu unang'anu ni lijambu lemwilijoini alonge suku bolane, mwililandila pangwendu. ");
INSERT INTO mgv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mwaajogopa babijikoma nhyega, lakini ngaseawesa kujikoma loho. Nambanga kunzogopa jojuwesa kualabana nhyega pamu na loho mu mwotu wanga kususuka masoba goha. ");
INSERT INTO mgv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Boo, hiweba ibeli lee ngasealomba kwa mangengalema mabeli masoku? Lakini nga hata jumu wabu jojukuwa bila Atati binu kupala. ");
INSERT INTO mgv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hata majunzu gagabii ku imutu yii gabalangiki. ");
INSERT INTO mgv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Henu mwijogopa, ndaba mwanganya Sapanga ampala ngani kupeta ijuni yoti. ");
INSERT INTO mgv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila mundu jojunyetake nepani palongi ja bandu, kabee nanzetakiya palongi ja Atati bangu baabii kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lakini mundu jokapi jojingana palongi ja bandu, nanepani nankana palongi ja Atati bangu baabii kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mwiwasali nepani nhikiki kwahenga bandu atama nulukwali pundema. Ngahela, ngasenhikiki kuleta lukwali ila ngondu. ");
INSERT INTO mgv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ndaba nhikiki kukomanisa kati jaka mundu na atati mundu na kamwali na amabu baki na kati ja anhyalamundu na akowanu baki. ");
INSERT INTO mgv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nu mbaja waka mundu ndi bandu buku nyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Jokapi jojapai atati na amabu baki kuliku ejumbala nepani, ngasejupalika kuba mbolee wango. Na jokapi joampai mwana waki au kamwali waki kuliku ejumbai nepani, ngasejupalika kuba mbolee wango. ");
INSERT INTO mgv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu jwanga kujuku nsalaba waki nukumbwata, ngasejupalika kuba mbolee wango. ");
INSERT INTO mgv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jojukamulaki womi waki ndaba jukunhobale nepani jitenda kuguhoa, lakini jojuhoa womi waki ndaba jangu nepani, jiipata kabee. ");
INSERT INTO mgv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Jojunzopa mwanganya, junyopa nepani, na jojunyopa nepani anzopa jojundumike. ");
INSERT INTO mgv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Joanzopa mlota waka Sapanga ndaba mlota waka Sapanga, hoju jijopa nhupi yuku mlota waka Sapanga. Joanzopa mundu jwa amboni palongi jaka Sapanga, jijopa nhupi yaka mundu jwa amboni. ");
INSERT INTO mgv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Numpwagi sakaka, jokapi joampeke jumu jwa apwasi bangu banga kumanyikana, kikombi sa masi mahimu ndaba ja kuba mmbolee jwangu, hoju jiipata nhupi jaki.” ");
INSERT INTO mgv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ejajomula kaapeke lilagisu banafunzi komi na abeli, jaboka pala nukujenda kubola nu kulandi bandu na bapambipi na misi juku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mmbatisa pajabii mligelesa jwajogwana gajuhenga Yesu Kilisitu. Ndienu, Yohana jaatuma banafunzi baki, ");
INSERT INTO mgv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bukundalukiya, “Boo, wehapa le jojapwaga Yohana gutenda kuhika, au tundendaliya jonge?” ");
INSERT INTO mgv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu jaapwagila, “Nnzendannya mkumpwagila Yohana majambu gamwagajoana nakagabona, ");
INSERT INTO mgv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bangalinga atenda kulinga, ilema bamagolu atenda kujenda na baaleliki atenda kunyambisika na banga kujoa atenda kujowa na baawii atenda kuyoka na ahagu baalandi Lijambu la Amboni. ");
INSERT INTO mgv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jupengaliwi mundu jangakukotoka kunhobale nepani.” ");
INSERT INTO mgv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ndienu, banafunzi baka Yohana pababiya ajendane, Yesu jatumbuliya kugupwagi nsambi wa bandu lijambu laka Yohana ana, “Pamwajenda kulukoba kola mwajenda kulinga kike? Boo, mwajenda kulinga nndai lolupoga nunhwae? ");
INSERT INTO mgv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Henu, mwajenda kulinga kike? Mwajenda lee kundinga mundu jojuwati ingobu yeinyambike? Bandu bawata ingobu yeinyambiki atama mu manyumba gu ubambu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakini, mwajenda kulinga kyane? Kumbona mlota waka Sapanga? Ena, numpwagi mumbona mundu nkolongu kupeta mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hajo ndi joandongale mu Maandiku gaka Sapanga, ‘Linga, nepani numtuma ntenga wangu jugulonguliya, jojuwe jwaguhandaliya indela jaku.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Numpwagi sakaka, kati ja bandu boti baasaliwi kwaka mbomba, ngasejupitii jojubii nkolongu kupeta Yohana Mmbatisa. Kabee, jojubii nsoku mu ubambu ukolongu ukumaundi, ndi nkolongu kupeta jombi. ");
INSERT INTO mgv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tumbuka masoba gaka Yohana Mmbatisa mbaka sajenu, ubambu ukolongu agupenga ngamaa na bandu bana makili ndi babugujuku. ");
INSERT INTO mgv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Malagalaki gaka Musa na alota baka Sapanga balongaliya lijambu luukolongu waka Sapanga mbaka masoba gaka Yohana. ");
INSERT INTO mgv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ana mugahobale haga, nala Yohana ndi Elia jobundongaliyaje jwiitenda kuhika. ");
INSERT INTO mgv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jwana makutu guku jowane jujoana! ");
INSERT INTO mgv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Henu ni kilenganisa kibeleku ase na sindu bole? Kilengana na akombu baatama pulubanza, baakema bangi nakaapwagi, ");
INSERT INTO mgv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tunzembi mapenenga, lakini ngase mwahinike! Tunzembi mihambu ji kilelu, lakini ngasemwaleile!’ ");
INSERT INTO mgv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ndaba Yohana Mmbatisa jahika, jupunga kula wala ngasejukunywika divai nabombi bapwaaga, ‘Jubii ni ilombu.’ ");
INSERT INTO mgv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana waka Mundu juhikiki, jukula na kunywa, nabombi bapwaaga, ‘Mundingaliya mundu hajo, nndepi nu nndapi, nkosi wa bandu baajopa kodi na bana mahakau!’ Lakini malangu gaka Sapanga jiibonikana ja sapi kupete mahengu gaki.” ");
INSERT INTO mgv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ndipala Yesu jatumbuliya kwaalakali bandu ba misi ye jwahengiki ndonduke yingi ndaba ngasebalekaki mahakau gabu. ");
INSERT INTO mgv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Misi mukiboni mwabandu buku Kolazini! Misi mukiboni mwa bandu buku Betisaida! Ana nginyuli yehengika kwinu yakahengika ku misi yuku Tilo nuku Sidoni, bandu baahoku bakabiya akotwiki mahakau toka mwandi nu kuwata magunii nukulipaki ilihu. ");
INSERT INTO mgv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lakini numpwagi, biiwesa kuhinakali mu masoba gukutemu bandu buku Tilo na buku Sidoni kupeta mwanganya. ");
INSERT INTO mgv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mwabandu buku Kapelinaumu! Boo, mwalikwea mbaka kunani kumaunde? Banhulua mbaka kumwotu wanga kususuka koatama bandu baawii! Ndaba, ana ndonduke yeihengiki kwinu mwanganya yakahengika ku Sodoma, musi wehogu wakabiya mbaka leleno. ");
INSERT INTO mgv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakini numpwagi, lisoba lu kutemu Sapanga jaabonila ikia bandu buku Sodoma kupeta mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kipindi sehesi Yesu japwaaga, “Nunsengu mwa Atati, Bambu jukunani kwaka Sapanga nu nndema, ndaba waahihiki majambu haga bana malangu na baasomiki, waayekuli bandu asoku.” ");
INSERT INTO mgv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena, Atati bangu, hela ndi ekukukulengani. ");
INSERT INTO mgv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Atati bangu ambeki indu yoti. Nga jojaamanyi Mwana ila Atati. Ngamundu jojaamanyi Atati ila Mwana na mundu jokapi jojupala Mwana anhyekuliya.” ");
INSERT INTO mgv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nhika kwangu, mwaboa monng'alika nukutope ni misigu jejitopiki, nane nitenda kumpomulesa. ");
INSERT INTO mgv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mlikonga kingolingoli sangu, mwikilibola kuhuma kwangu, ndaba nepani numpoli na jojunyenyeke mioju, nanamu myoju jinu jiitenda kupomulela, ");
INSERT INTO mgv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndaba kingolingoli sangu kitei kujojoka ni misigu jangu ngasejitopike.” ");
INSERT INTO mgv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Masoba gala, Yesu jabiya jupeta mumatui gi inganu Lisoba lu Kupomulela, banafunzi baki babiya ni inzala, batumbuliya kuseku kipambiku si inganu nakula inganu yaki. ");
INSERT INTO mgv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lakini Afalisayu pabagabona haga, bumpwagila Yesu, “Linga! Banafunzi baku ahenga lijambu li mihilu Lisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu jaalalukiya, “Boo, ngasensomiki lee sejwahengiki Daudi na ajaki pababii ni inzala? ");
INSERT INTO mgv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jajingala mu nyumba jaka Sapanga jakula mabumunda gabapiiki palongi jaka Sapanga. Lijambu leheli labii lu nhilu kwabu kula lakini Daudi na ajaki bakuliki. Mabumunda gegala babapalika kula pee agolu kajika. ");
INSERT INTO mgv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Boo, ngasensomiki mukitabu sa Malagalaki gaka Musa agolu ahalabana Malagalaki gi Lisoba lu Kupomulela munyumba jaka Sapanga, lakini ngase abonikana ngati atei kuhalabana? ");
INSERT INTO mgv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Henu numpwagi, pamba jubii jojubii nkolongu kupete Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maandiku gaka Sapanga gapwagiki, ‘Mbala ikia wala nga matambiku,’ mwakamanyi maana ja malobi ganga, ngamwakaatemwi bandu banga na mahakau. ");
INSERT INTO mgv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ndaba Mwana waka Mundu ndi Bambu ju Lisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu jaboka pala, jajenda munyumba jukuketangane Ayaudi, ");
INSERT INTO mgv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","momuje kwabii na mundu jumu junu kuboku kokulei. Ndienu bandu andalukiya Yesu, “Boo, kujetakeka le kundamisa mundu Lisoba lu Kupomulela?” Bundalukiya hela ili apata indela jukuntaki. ");
INSERT INTO mgv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lakini Yesu ampwagila, “Boo, mundu boo kati jinu likondoo na lihabuki mlibomba Lisoba lu Kupomulela ngajitondabe kuboku kulipia? ");
INSERT INTO mgv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lakini mundu ndi jwa sapi kuliku likondoo! Henu, nga nhilu kuhenga majambu ga amboni Lisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ndipala ampwagila mundu jola, “Nyosa kuboku kwaku.” Janyosa kuboku, nakwombi kwalama na kuba ngati kongi kola. ");
INSERT INTO mgv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndienu Afalisayu bapita kunza bataputa indela jukunkoma Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lakini Yesu ejamanya lijambu lela, japita pandu je pala. Na bandu bingi bunkagula najombi jatenda kwaalamisa agonzu boti. ");
INSERT INTO mgv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jaakanakya baapwagi bandu majambu gaki. ");
INSERT INTO mgv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jatenda hela, ili gajapwaga Sapanga kupete Mlota Isaya gatimia. ");
INSERT INTO mgv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jonzo ndi mtumisi wangu jonuhagwi, mpali wangu jojugutogulesa mwoju wangu. Naajibeka loho jangu panani jaki, najombi jwiilandila nndema joti kutemu kwangu. ");
INSERT INTO mgv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngajilosani wala kujamalii kwa sauti, nga mundu jojijoana sauti jaki mwiindela. ");
INSERT INTO mgv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nndai gogupondiki ngajitunuli wala utambi gogupia lioi ngajisusue, mbaka kutemu kwa sakaka, kutawala. ");
INSERT INTO mgv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bandu boti bandema joka banhobaliya jombi.” ");
INSERT INTO mgv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ndienu Yesu bundetila mundu jumu jwangalinga kabee jabi kimumuta ndaba jabiya jubii ni ilombu. Yesu andamisa najombi jwawesa kulonge nu kulinga. ");
INSERT INTO mgv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bandu boa basangia ngamaa, nukulaluana, “Boo, jonzo lee nga Mwana waka Daude?” ");
INSERT INTO mgv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakini Afalisayu pabajoa haga, bapwaaga, “Mundu hajo jubenga ilombu ku uwesu waka Belizebuli, nkolongu wi ilombu.” ");
INSERT INTO mgv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu jamanyiki sebawasaliya, jaapwagila, “Ubambu ukolongu wokapi gogubaganiki nukukomana beni kwa beni, gwitenda kuhalabika. Musi au nyumba jokapi jejibaganiki jitenda kuhabuka. ");
INSERT INTO mgv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ana Lijobi liipenga ilombu yaki, hoju jilipenga mwene. Henu, ukolongu waki wiijema bole? ");
INSERT INTO mgv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwanganya mpwaaga eti menga ilombu ku uwesu waka Belizebuli. Boo, nya jojaapeke bandu bii uwesu ukubenga ilombo? Ndienu bandu bii bene buntemula mwanganya. ");
INSERT INTO mgv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakini ana moa ilombu kwa makili ga Loho jaka Sapanga enu mmanya Ubambu ukolongu waka Sapanga guhikiki kwinu.” ");
INSERT INTO mgv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ngamundu jojuwesa kujingi nyumba jaka mundu jwana makili nukunyaga hindu yaki yoti, jitumbuliya oti kunkonga jwana makili jola. Hapa ndi pajiwesa kunyaga hindu yaki.” ");
INSERT INTO mgv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mundu jwanga kuba pamu nanepani, hoju ndi jojumbenga, na jokapi jwanga kubonga pamu na nepani jutenda kupesangana. ");
INSERT INTO mgv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Henu numpwagi, bandu bilekakiwa kila mahakau namatondu gabu bitenda kulekakewa, lakini jola joantondo Loho jaka Sapanga ngabundekake mahakau ge haga. ");
INSERT INTO mgv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mundu joampwaga liyaa Mwana waka Mundu bitenda kundekake mahakau gaki, lakini joampwaaga liyaa Loho jaka Sapanga, ngabanndekake lihakau lela masoba ganga kujomoka nndema goguhika. ");
INSERT INTO mgv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nkongu gwa sapi gupapa matunda ga sapi, nunkongu guliya gupapa matunda giliya. Nkongu gumanyikana kwa matunda gaki. ");
INSERT INTO mgv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwanganya mukibeleku si lijoka! Nhwesa boo kupwaaga majambu gamboni koni mwabeti mwambaja? Ndaba mundu jupwaaga gagatweli mmoju jaki. ");
INSERT INTO mgv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu jwa amboni jupia gagabii ga amboni mu kikoku sa hindu yamboni, na mundu juliya jupia majambu giliyaa mu mukikoku sa hindu hiliya.” ");
INSERT INTO mgv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ndienu numpwagi lisoba lu kutemu kila bandu biipalika kutemuliwa kwa kila lilobi langa kupalika leapwaga.” ");
INSERT INTO mgv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ndaba ja malobi gaku bagutemula ana gubii na mahakau au ngasegubina mahakau. ");
INSERT INTO mgv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ndipala abola bangi ba Malagalaki na Afalisayu bumpwagila Yesu, “Mmbola, tupalika kulinga nginyuli kuhuma kwaku.” ");
INSERT INTO mgv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lakini jombi jaapwagila, “Kibeleku siliya sanga kuhobaleka! Mpala nginyuli, lakini ngabampeke nginyuli ila nginyuli jaka Yona Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngati Yona ejatama masoba matatu pipipipi na kelukelu mulutumbu ja homba ngolongu, ndienu Mwana waka Mundu ejitama pai ju nndema masoba matatu pipipipi na kelukelu.” ");
INSERT INTO mgv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bandu buku Ninawi biijema ni kibeleku ase mlisoba lu kutemu nukuntemu mwanganya. Ndaba bandu buku Ninawi bagaleka mahakau gabu Yona pajalandila kwabu, na pamba jubii nkolongu kupeta Yona! ");
INSERT INTO mgv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mmasoba gu kutemula, Malikia juku Sheba jijema na bandu bi kibeleku senze, najombi jantemula mwanganya ndaba juhikiki kuhuma kunndema jaki juhikiki kujoane mabolee gana malangu gaka Salumoni, na pamba jubii nkolongu kupeta Solomoni. ");
INSERT INTO mgv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kilombu esumpita mundu, kiyongolota yongolota mulungwenza kutaputa pandu pukupomulela, na ana ngasekipatiki pandu pukupomulela, ");
INSERT INTO mgv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ndi salipwagila seni, ‘Ngelubuka kunyumba jangu.’ Lakini pakikelabuka nukukubona nyumba ndopu apyaagi nu kubeka sapi, ");
INSERT INTO mgv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","sijenda kujukuu ilombu yengi saba, ibaja kupeta sombi, na yombi ijingala nukutama momu. Na mundu we wehoju kupogale kwaki kwiikuba kuliya kupeta puwanzu. Ndi ekwibiya kibeleku ase siliya.” ");
INSERT INTO mgv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pajabiya juendalee kulongee na bandu, amabu baki na akalongu baki bahika nukujema kunza, bapala kulongee naku. ");
INSERT INTO mgv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mundu jumu ampwagila, “Anyongoo baku na alongu baku abii kunza, apala kulongee na wehapa.” ");
INSERT INTO mgv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lakini Yesu ampwagila mundu wehoju, “Anyongo bangu ndi nyane? Nakalongu ba ndi akanyane?” ");
INSERT INTO mgv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ndipala jaalangia kuboku kwa banafunzi baki nukupwaaga, “Haba ndi aka nyongo bangu na alongu bangu! ");
INSERT INTO mgv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ndaba jokapi jojihenga gaapala Atati bangu baabii kunani kwaka Sapanga, hoju ndi mmbeli wangu nu nndombu wangu na amabu bangu.” ");
INSERT INTO mgv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lisoba lele Yesu jahuma mu nyumba jela, jajenda nukutama mulutengu ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nsambi nkolongu wa bandu buyongolota Yesu najombi jwakwela munhwatu nukutama momu, bandu boti bajeema mulutengu ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndipala Yesu jaapwagila majambu gingi ngamaa kwa malenganu, japwaaga, “Nnzoannya! Mpanda jumu jajenda kupanda imbeju. ");
INSERT INTO mgv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pajabiya jwakakweta imbeju, yengi yahabukiya pambipi ni indela, ijuni yahika nakula. ");
INSERT INTO mgv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yengi yahabuka mu malibu punu luhombi lusokopi. Yabonikana imeliki nyata nukukola ndaba lwabii luhombi lusokopi. ");
INSERT INTO mgv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lakini lyoba palanyaka, mimea jejela janyala nukujoma ndaba mikega jaki ngasejahumiki pai. ");
INSERT INTO mgv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeju yengi yahabukiya pi mikongu ja miha, nayombi jakola nukujihinya. ");
INSERT INTO mgv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imbeju yengi yahabukiya puluombi lolubolalani, yamei nukupapa, yengi yapapiki imbeju mia na yengi sitini na yengi selasini.” ");
INSERT INTO mgv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu jajomulia kupwaga, “Jwana makutu gukujoa nujujoana!” ");
INSERT INTO mgv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Banafunzi baki bunzendila nukundaluki, “Ndaba jaki gulongee na bandu sa malengano?” ");
INSERT INTO mgv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jaapwagila, “Mwanganya bumpeki uwesu hukumanya sili ju ubambu ukolongu uku maundi, lakini bombi ngasebaapekie. ");
INSERT INTO mgv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ndaba mundu jojubii na sindu bitenda kunnzonzuke ngani lakini jwanga na sindu, hata sejubinaku sitenda kujukulika. ");
INSERT INTO mgv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndi ndaba mbwaga naku kwa malenganu, ndaba biilinga lakini ngabiikibone, bijoane lakini ngabiijoane, wala ngabiielewe. ");
INSERT INTO mgv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gatimia gajapwaga Isaya Mlota waka Sapanga, ‘Kujoana mbaka bijowani, lakini ngabielewi. Kulinga mbaka alingi, lakini ngamwakibone. ");
INSERT INTO mgv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ndaba mioju ja bandu aba jitei kunonopa, ngaseajoana kwa makutu gabu, mihu gabu atei kuhigi. Ana ngahela, bakabona kwa mihu gabu, bakajoana kwa makutu gabu, bakaelawa kwa mioju jabu, nukung'anumbuki nepani, nane nakabiya nalamisi.’ ");
INSERT INTO mgv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lakini nambanga mwanganya! Ndaba mihu ginu gatenda kulinga, na makutu ginu gatenda kujoa! ");
INSERT INTO mgv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Numpwagi sakaka, alota baka Sapanga bingi na bandu baka Sapanga bingi batokulii ngamaa kugabona gamwagabona, ngasebagabona, nukugajoana gala gamwagajoana, lakini ngasebagabweni wala kugajoana. ");
INSERT INTO mgv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ndienu nnzoannya, maana ja malenganu guku mpanda. ");
INSERT INTO mgv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mundu ejijoana lilobi lu Ubambu ukolongu waka Sapanga lakini ngasejilielewa, mundu we hoju julengana ni imbeju yehihabuki mwiindela. Mbaja jihika nukukwelapu seapandiki mmoju jaki. ");
INSERT INTO mgv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbeju yeihabuki mmalibu ilengana na mundu jojujoana lilobi laka Sapanga, na papa julijopa sukutogule. ");
INSERT INTO mgv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lakini ndaba ngaselijingii nkati jaki ngati mikega ejijingi muluhombi, juendale kuhinakali kidogu pena ana bahengi liyaha nakaang'alisa ndaba ji lilobi le heli, ndi jukotoka kuhobale lilobi. ");
INSERT INTO mgv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbeju yehihabuki pi mikongu ja miha ilengana namundu jojulijoane lilobi, lakini ndaba juku hangajaki womi upundema nu kupala mali ndi kuhalabana lilobi leheli, na ngase jupapa matunda ndaba ngasejuhenga gajupala Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lakini imbeju yeyahabukiya muluhombi lwa sapi ilengana na mundu jojujoana lilobi nukulielewa, jihenga majambu gingi ga mboni ngati mkongu egupapa matunda, gumu mia na gongi sitini na gongi selasini.” ");
INSERT INTO mgv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu jaapwagila bandu lilenganu lengi, “Ubambu ukolongu ukumaundi gulengana na mundu jojupandiki imbeju ya sapi mulitui laki. ");
INSERT INTO mgv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lakini bandu ana agoni, mbaja waki juhika nukupanda manyai pikilanda ji inganu, nu kuboka. ");
INSERT INTO mgv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ndienu inganu paimela nukutumbuli kupapa, manyai nagombi gabonikana mwi inganu. ");
INSERT INTO mgv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Atumi baka mwini litui bunzendila, nukundaluki, ‘Bambu, si wapandiki imbeju ya sapi mulitui lako? Manyai aga gahumiki kwako?’ ");
INSERT INTO mgv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jombi jajibua, ‘Mbaja wangu ndi jojuhenga hela.’ Ndienu atumi baki bundalukiya, ‘Boo, gupala le tujenda twakatupulaje?’ ");
INSERT INTO mgv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Najombi jaapwagila, ‘Ngaela, mwitupula ndaba emwiitupula manyai nhwesa kutupu ni inganu kabee. ");
INSERT INTO mgv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muileka ikola pamu mbaka masoba gukuhusa egihika. Masoba ge haga naapwagila baahusa ntupula hoti manyai nukugakoonga malundumalundu nu kugajosa mwotu, lakini inganu baikusanya nukuibeka mwikikoku sangu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu jaapwagila bandu kwa malenganu gangi, “Ubambu ukolongu gulengana ni imbeju nzoku ja haladali jejajukwi mundu jumu, japaanda mulitui laki. ");
INSERT INTO mgv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeju heji jibii nzoku kupete imbeju yoti, lakini pajikola, mmea waki gukuba nkolongu kupeta mikongu ju mulitui. Nagwombi gukuba nkolongu ni ijuni ihika nukusengale miui mu mambandi gaki.” ");
INSERT INTO mgv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu jaapwagila kabee lilenganu lengi, “Ubambu ukolongu gulengana na amila lejajukua nyongoo jumu, jasanganya nu uwembi madebi mabeli, mbaka uwembi gwoti watenda kututumuka.” ");
INSERT INTO mgv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu jaapwagila nsambi bandu majambu haga goa kwa malenganu. Ngase jaapwagila sokapi bila kutumii malenganu, ");
INSERT INTO mgv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","jatenda hela ili litimia lejwapwaaga Mlota waka Sapanga, “Nipwaaga nabu kwa malenganu, niiyekula gagahihiki pu nndema tumbuka kubombeka.” ");
INSERT INTO mgv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ndipala Yesu jaaleka bandu bala, jajingala mu nyumba. Banafunzi baki bunzendila, bumpwagila, “Tupwajila malenganu ga manyai gabola kike.” ");
INSERT INTO mgv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu jaapwagila, “Mpanda imbeju ya sapi, ndi Mwana waka Mundu. ");
INSERT INTO mgv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Litui lela ndi nndema. Imbeju ya sapi ndi bandu baka Sapanga babube ubambu ukolongu ndi wabu. Lakini manyai gala ndi bandu baka Mbaja jola. ");
INSERT INTO mgv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mundu mbaja jojupanda magogu ndi Lijobi. Ilebi ndi mwisu gu nndema gongo, na baahusa ndi Atumi bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngati manyai ebagabonga nukujosa mwotu, ndi ekwikuba pamwisu ju nndema. ");
INSERT INTO mgv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana waka Mundu jaatuma atumi bu kunani kuhuma mu Ukolongu waki abonga kila sindu sesaakolo bandu kuhenga mahakau na baatenda liyaha masoba goti. ");
INSERT INTO mgv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nabombi baalekala nkati jitanuli la mwotu nkolongu, hoku bilela nukupola minu. ");
INSERT INTO mgv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ndipala babii baamboni palongi jaka Sapanga biing'ala ngati lyoba mu ubambu ukolongu wa Atati babu. Jwana makutu gukujoane nu jujoana.” ");
INSERT INTO mgv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ukolongu ukunani ukumaundi gulengana na hindu yu lupija lwingi loahihiki mu litui. Mundu pajijibona juhiya kabee. Sukutogule ngamaa jujenda kulombesa indu yoti yejubi naku, ndienu jukelabuka nukulomba litui lela.” ");
INSERT INTO mgv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kabee, ukolongu uku ukunani gulengana na mundu jojilomba hindu nukulombesa jojutaputa lulu. ");
INSERT INTO mgv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pajijibona lulu jimu ja bei ngolongu, jajenda kulombesa yoti yejabinaku nukulomba lulu jela.” ");
INSERT INTO mgv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kabee, ukolongu ukunani kwaka Sapanga kwaka Sapanga gulengana na kilepa sealekaki mu nhanga, gogukamu homba ya sapi nihiliya. ");
INSERT INTO mgv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kilepa esatwelila, aloi buguhuti mulutengu ju unhanga, batama pai, kuhagu homba ya sapi babeka mukitonga, lakini homba iliya yela batenda kuleke. ");
INSERT INTO mgv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ndi ekwibiya mwisu gu nndema, Atumi bu kunani kwaka Sapanga bipitila, baabaganisa bandu abaya na bandu baamboni, ");
INSERT INTO mgv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kwaaleke abaya bala mulitanuli la mwotu. Kokuje bilela nukupola minu.” ");
INSERT INTO mgv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu jalalukiya, “Boo nheliwi le majambu goti haga?” Bajibua, “Hena.” ");
INSERT INTO mgv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Najombi jaapwagila, “Ndienu, kila mmbola wa Malagalaki jojukuba mmbolee ju Ubambu ukolongu ukunani kwaka Sapanga julengana na mundu jwana nyumba jojupia indu yulupija lwingi inyai na hindu yulupija lwingi ya mwandi kuhuma mukikoku saki.” ");
INSERT INTO mgv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pajajomula kwaapwaagi malenganu gala, jaboka pandu pala, ");
INSERT INTO mgv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jajenda ku nyumba jabu. Kokuje jabiya jaabola bandu mu nyumba jukuketangane Ayaudi. Nabombi balweuki, na babumbona basangia, bundalukiya, “Boo, mundu hajo jupatiki kwaa malangu nu uwesu ukuhenga nginyulila? ");
INSERT INTO mgv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jonioju le nga mwana waka nndanda jola? Boo, amabu baki baakema Malia na alongu baki aka Yakobu na Josepu na Simoni na Yuda? ");
INSERT INTO mgv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Naka alombu baki ngase abii apamba na twenga? Ndienu jupatiki kwaa goka haga?” ");
INSERT INTO mgv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ndienu baatenda kunkana. Lakini Yesu jaapwaagila, “Mlota waka Sapanga anzoane kila pandu, ila ngasebunzoane pa musi jaki na pa nyumba jaki!” ");
INSERT INTO mgv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndienu ngasejatei nginyuli hinge ndaba ngase bunhobali pa musi jaki. ");
INSERT INTO mgv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Masoba gegala, Helodi kilongosi juku Galilaya jajoini lijambu laka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jaapwagila atumi baki, “Hoju Yohana Mmbatisa, jutei kuyoka kuhuma kwa bandu baawii. Henu makili gukutenda nginyuli gahenga lihengu nkati jaki.” ");
INSERT INTO mgv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helodi jabiya ankamwi Yohana nukunkonga mukipungu ndaba jaka Helodia, nhwanu waka Pilipi, mbeli waki. ");
INSERT INTO mgv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ndaba Yohana jabiya ampwagi Helodi, “Ngasekupalika wehapa kunzuku Helodia.” ");
INSERT INTO mgv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helodi japala kunkoma Yohana, lakini jaajogopa bandu ndaba bandu bumbona Yohana ngati Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lakini lisoba lukutogule kusaliwa kwaka Helodi, kamwali waka Helodia jahina palongi ja ageni na Helodi jatoguli ngamaa, ");
INSERT INTO mgv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","henu jalagi kumpeke kamwali sokapi sejiiloba. ");
INSERT INTO mgv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kamwali kwa kwaajowane amabu baki, japwaga, “Mbekiya kimutu saka Yohana Mmbatisa mu kipalu.” ");
INSERT INTO mgv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bambu nkolongu Helodi jabona usungu ngamaa, lakini ndaba jalapa palongi ja ageni bingi lisoba lukutogule lela, jalagalakiya ampekiya. ");
INSERT INTO mgv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Helodi andagalakiya mundu akusekula umutu Yohana Mmbatisa mkipungu mola. ");
INSERT INTO mgv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umutu waki baleta mu kipalu, nukumpeke kamwali jola, najombi jaapelakiya amabu baki. ");
INSERT INTO mgv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Banafunzi baka Yohana bahika, bajukua nhyega jaka Yohana nukutaga, ndipala bajenda kumpwagi lijambu leheli Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ejapata lijambu leheli, jaboka nu nhwatu kujenda pandu panga bandu. Lakini bandu pabapata lijambu, bumpwata kwa magolu kuhuma ku misi jabu. ");
INSERT INTO mgv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu pajapita mu nhuwatu nukuhika mulutengu ju nhanga jugubona nsambi wa bandu nkolongu, jaabonila ikia, jaalamisa agonzu babu. ");
INSERT INTO mgv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ekwahika pakamii, banafunzi baki bunzengaliya, bumpwagila, “Pandu pamba pulukoba, na lyoba lijingi, waleka bandu abokannya ili bakalomba posu mwijiji.” ");
INSERT INTO mgv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu jaapwagila, “Lakini nga lasima kuboka, mwanganya mwabeti mwaapekia poso.” ");
INSERT INTO mgv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lakini bombi bapwagila, “Tubii na mabumunda nwanu na homba ibeli pena.” ");
INSERT INTO mgv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu jaapwagila, “Nnetila pambane.” ");
INSERT INTO mgv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jalagalakiya bandu atamannya pai pamanyoi. Jajukua mabumunda gala nhwanu na homba ibeli yela, jalinga kunani kwaka Sapanga, nukunsengula Sapanga. Jasekula mabumunda gala nakaapeke banafunzi baki nabombi babagila bandu. ");
INSERT INTO mgv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bandu boti bakula, nukutupi. Ndipala banafunzi batondula ipandi ya posu yeyaigali, batwelakiya itonga komi ni ibeli. ");
INSERT INTO mgv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Akanalomi babakuliki baiki elupu unhwano bila kabalanga aka mbomba na bana. ");
INSERT INTO mgv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu pajabiya jaatabuka bandu jaapwagila banafunzi baki akwela nhwatu, andonguliya kujenda kwii ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ejajomula kwaatabuka bandu bala jajenda kukitombi kundoba Sapanga, ekwahika pakamii jakabii kajika jaki, ");
INSERT INTO mgv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","nu nhwatu wegola wabia kutali nuku mbwani, lakini waketangana na majeba ni kimbonga kikali. ");
INSERT INTO mgv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ekwahegaliya kusa, Yesu jaajendila banafunzi baki koni jubii panani ja masi. ");
INSERT INTO mgv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lakini banafunzi baki pabumbona jujenda panani ja masi, batenda kujogopa. Bapwaaga, “Leneli Lihoka.” Batenda kujamali sukujogopa ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Apalapa Yesu jaapwagila, “Ntumbala! Nabii nepane! Mwijogopa!” ");
INSERT INTO mgv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petili ampwagila, “Bambu, ana wehapa mbwagila nhika kogubii hoku, koni nyenda panani ja mase.” ");
INSERT INTO mgv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ndienu Yesu japwaaga, “Hikajee.” Ndienu Petili jahuluka kunza ju nhwatu, nukujenda panani ja masi, kunzende Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lakini pajabona unhwai, jajogopa, jatumbuliya kujingi mmasi, jatenda kujamali sukulela, “Bambu, gunhokua.” ");
INSERT INTO mgv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Apalapa Yesu janyosa kuboku kwaki, nukunkamu nukumpwagi, “Wehapa woguhobale kasokopi! Ndaba jaki gutenda kujogopa?” ");
INSERT INTO mgv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndipala bombi pabakwela munhwatu nu nhwai gwatenda kutumbaa. ");
INSERT INTO mgv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Boti bababii munhwatu bungungamaliya Yesu, bapwaaga, “Sakaka wehapa wa Mwana waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Balombuka nhanga, bahika kundema guku Genesaleti. ");
INSERT INTO mgv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bandu pabummanya Yesu, baenisa majambu goti pa ndema joti. Ndienu bandu bundetila Yesu agonzu boti. ");
INSERT INTO mgv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bundoba jaalekakiya agonzu akamula lupeta lwii ingobu jaki. Naboti babunngusa batenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ndi Afalisayu na Abola ba Malagalaki babahuma ku Yelusalemu, bunzendila Yesu nukundaluki, ");
INSERT INTO mgv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ndabajaki banafunzi baku ngase ajetake mabolee gatujopiki kuhuma kwaka hoku bito? Paakula ngaseasamba maboku gabu sapi!” ");
INSERT INTO mgv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu jaajibua, “Ndabajaki na mwanganya ngase mpwata malagalaki gaka Sapanga ila mpwata mabolee ginu mwabete? ");
INSERT INTO mgv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sapanga jupwagiki, ‘Waatendila isima atati baku na amabu baku na jojwaapwaga giliyaa atati baki na amabu baki jukomika.’ ");
INSERT INTO mgv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakini Mwanganya mbola bandu eti ana mundu jubi na sindu sejuwesa kwaajangati atati baki au amabu baki, lakini na sindu sehesi ampiiki Sapanga,” ");
INSERT INTO mgv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Henu ngasejupalika kabee kwaajangati sindu atati baki. Ndi emulileka lilobi laka Sapanga nukupwata mabolee ginu mwabee. ");
INSERT INTO mgv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwanganya nkopake mwamboni pamiu jabandu! Isaya Mlota waka Sapanga junndotila sakaka mwanganya pajwapwaga, ");
INSERT INTO mgv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Bandu haba andende isima kwa malobi pena, lakini mmyoju jabu abii kutali na nepani. ");
INSERT INTO mgv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunumbali kwabu kwa bwakaa, ndaba baabola bandu malagalaki ga bando kuba ngati malagalaki gango.” ");
INSERT INTO mgv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu jwaakema bandu nakwaapwagi, “Nzowana sapi nukuelewa malobi ganumpwagi! ");
INSERT INTO mgv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sindu sesunhenga mundu kuba mpija nga sekijingi mundomu, ila sekipita munndomu. Hesi ndi sesunhenga mundu kuba mbaja.” ");
INSERT INTO mgv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ndi abole baki bunzendila nukundaluki, “Boo, umanyi Afalisayu bayomiki ngama pabajogwana malobi gaku?” ");
INSERT INTO mgv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lakini jombi jwaapwagila, “Kila nkongu gwanga kupandwa na atati bangu bu kunani, gwitenda kutupuliwa. ");
INSERT INTO mgv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwaalekaje! Bombi bangalinga, baalongosa bangalinga ajabu, Jwangalinga na andongo jwangalinga jongi, boka abeli baabukiya mulibomba.” ");
INSERT INTO mgv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petili japwaga, “Tupwagila maana jililenganu heli.” ");
INSERT INTO mgv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu jalalukiya, “Hata mwanganya lee mwakona ngasenhelewa? Ngasenhelewa sindu sekijingi munndomu kijenda mulutumbu nukupita kunza kujenda mu likelo? ");
INSERT INTO mgv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mwakona ngasemmanyiki kila sekijingi mundomu kijenda mulutumbu nukupiti kulikelo? ");
INSERT INTO mgv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lakini malobi gagapita punndomu, gahuma nkati kumoju, na haga ndi gaguhenga mundu jubiya mpija. ");
INSERT INTO mgv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ndaba mmoju gapita mawasu giliyaa nu kukoma na ugoni na kunng'anambuka mundu na kukopake waamboni kwa bandu na wii niisoli na matondu. ");
INSERT INTO mgv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Haga ndi gagunhenga mundu kuba juliyaa. Lakini kulaposu bila kusamba maboku ngasekunhenga mundu kuba mpija.” ");
INSERT INTO mgv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu jaboka pala, jajenda kundema uku Tilo nuku Sidoni. ");
INSERT INTO mgv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nyongo jumu juku musi uku Kana, jukubika jutama pambipi na misi heji, anzendila Yesu koni jakalela sukujamali, “Bambu, Mwana waka Daudi, naandi gumone ikia! Mwana wangu jubii nikilombu, sunng'alisa ngamaa.” ");
INSERT INTO mgv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lakini Yesu ngasejajibwiki sindo. Ndi banafunzi baki bunzendila nukundoba, “Mpwagila jubokaje ndaba jutupwata na jutupege keleli!” ");
INSERT INTO mgv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu jwapwaga, “Andumiki kwa bandu buku Izilaeli pee baahobiki ngati makondoo.” ");
INSERT INTO mgv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ndipala mmbomba jola anzendila, angungamaliya nukupwaga, “Bambo, nagunyangatiaje.” ");
INSERT INTO mgv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu jwapwaga, “Ngasapi kujuku posu ja bana nukulekale jimbwa.” ");
INSERT INTO mgv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nyongo jola jwapwaga, “Sakaka bambu, lakini hata himbwa ikula mbuluti yeiabuki pai jamesa jaka bambu wabu.” ");
INSERT INTO mgv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu jwapwaga, “Amabo kuhobale kwaku kukolongu! Nala kuhengika ngati hegulobiki.” Apalapa mwana waki jatenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu jwaboka pandu pala, jwajenda pulutengu ju nhanga uku Galilaya. Ndienu jwakwela pikitombi nukutama pai. ");
INSERT INTO mgv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bandu bingi ngamaa bunhikila koni bunndeti ilema na bandu bangakulinga na aka kimumuta na bandu balei na bandu bingi bababi agonzu bumbekila palongi jaki naboti jatenda kwaalamisa. ");
INSERT INTO mgv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nsambi wa bandu gola wasangii ngamaa pawabona, imumuta itenda kulongela na ilema atei kulama na baalei nhyega atenda kujenda na banga kulinga atenda kulinga, bandu bunndumbaliya Sapanga jwa bandu buku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu jaakema banafunzi baki nukupwaga, “Naabone ikia bandu haba, ndaba abii na nepani kwa masoba matatu, na ngaseabi na poso. Ngasembala kwaaleka ajenda bila kula ndaba awesa kuhinduka mwiindela ninzala.” ");
INSERT INTO mgv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Banafunzi baki bundalukiya, “Pamba tubi kulungwenza, twiipata kwaa posu jukutupi bandu bingi ana?” ");
INSERT INTO mgv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu japwaga, “Mmbi na mabumunda galenga?” Bajibwa, “Saba nutuhomba tusokopi tusokutusoku.” ");
INSERT INTO mgv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu jwalagalakya banafunzi baki baapwagila bandu atama pai. ");
INSERT INTO mgv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jwajukua mabumunda gala nutuomba tola, ansengula Sapanga nu kunuku, nakwaapeke banafunzi baki nabombi baabagila bandu. ");
INSERT INTO mgv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Boti bakula nukutupi. Ndienu banafunzi baki batondula ipandi yeiigali, batwelakia itonga saba yeyatweli posu jejahigali. ");
INSERT INTO mgv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Babakula babia akanalomi elupu nsesi bila kwaabalanga aka mbomba na bana. ");
INSERT INTO mgv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ndi Yesu jaatabuka bandu, jwakwela nhwatu jajenda musi uku Magadani. ");
INSERT INTO mgv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afalisayu na aka Asadukayu bunzendila Yesu, bunndenga sukunndoba, julangia nginyuli yeilangi jombi juhuma kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lakini Yesu jaapwagila, “Lyoba elijingi mwanganya mpwaga, ‘Lelenu kubi sapi ndaba mahundi gakuba makeli!’ ");
INSERT INTO mgv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nulukela mpwaga, ‘Lelenu jiikuna hiyula, ndaba kunani kukeli na mahundi gatei kutanda.’ Mwanganya nhwesa kumanya nginyuli ja mahundi, lakini ngasenhwesa kumanya nginyuli ja masoba ganga. ");
INSERT INTO mgv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bandu bikibeleku salyaa na sanga kuhobaleka! Kipala nginyuli, lakini ngakipati nginyuli jengi jokapi kupeta nginyuli jaka Yona jela.” Ndipala Yesu jwaaleka nu kuboka. ");
INSERT INTO mgv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pababiya alombwiki nhanga, banafunzi baka Yesu bakombuka ajewiki kutoto Mabumunda. ");
INSERT INTO mgv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu jwaapwagila, “Ntama miu, mulilenda na amila jaka Afalisayu na Asadukayu!” ");
INSERT INTO mgv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Banafunzi batumbulia kulaluana beni na beni, “Jupwaga hela ndaba ngasetwatogwi mabumunda.” ");
INSERT INTO mgv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu jwamanyiki sebabia bakapwaga ndi jaapwagila, “Mwabandu banga kuhobale mwanganya! Ndaba jaki nndaluana mwabeni na beni ndaba ngasembii na mabumunda? ");
INSERT INTO mgv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Boo, mwakona lee ngasenhelewe? Boo, ngase nkomboka panamega mabumunda nhwanu ndaba ja bandu elupu nhwano? Boo, mwatwelaki itonga ilenga yiipandi yeyaihigali? ");
INSERT INTO mgv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amala mabumunda saba gala gabaabagila bandu elupu nsesi bala, boo, mwakusinyi itonga ilenga yeyaigali? ");
INSERT INTO mgv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndaba jaki ngase nhelewa nepani ngase nongale mabumunda? Lakini nzepana na amila jaka Afalisayu na Asadukayu.” ");
INSERT INTO mgv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ndipala banafunzi bala bamanya Yesu ngasejwabia jwaapwagi ajepana na amila ja mabumunda, ila ajepana na mabolee gaka Afalisayu na Asadukayu. ");
INSERT INTO mgv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu pajwahika ku Kaisalia kojuhumi Pilipi, jwaalalukia banafunzi baki, “Bandu apwaga Mwana waka Mundu ndi nyanye?” ");
INSERT INTO mgv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bumpwagila, “Bandu bangi apwaga ndi Yohana Mmbatisa na bangi apwaga ndi Elia na bangi apwaga ndi Yelemia au jumu jwa alota baka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu jwapwaga, “Na mwanganya boo, mpwaga nee na nyanye?” ");
INSERT INTO mgv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petili jwapwaga, “Weapa ndi wa Kilisitu Mwana waka Sapanga jojubi mwomi.” ");
INSERT INTO mgv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu jwapwaga, “Mbanga wa Simoni mwana waka Yona, ndaba nga mundu jokapi jojukuyekuli haga ila Atati bangu baabi kunani. ");
INSERT INTO mgv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nane nukupwagi wa Petili, weapa lilibu, na panani jililibu hale naguletila bandu bingi ambwata na makili ga kuwa ngagakuwesi. ");
INSERT INTO mgv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nagupekia punguu yu ukolongu ukunani, sokapi sewiogula pundema pani, kwiioguliwa nu kunani kwaka Sapanga kabee nasokapi sewipunga pundema sipungika kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ndi Yesu jaakana banafunzi baki bampwaji mundu jokapi ana jombi ndi Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Toka pala Yesu jwatumbulia kwaapwagi hotuhotu banafunzi baki kupwaga jupalika kujenda ku Yelusalemu, nakola jwitenda kung'aliswa ngamaa mang'alisu gabiileta aseja na aka agolu akolongu na aka abola bamalagalaki. Kabee biitenda kunkoma na jwiitenda kuyoka lisoba la tatu. ");
INSERT INTO mgv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ndi Petili anzuku Yesu pulutengu nukundakali, “Ngahela Bambu! Lijambu heli nga lugupate!” ");
INSERT INTO mgv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Lakini Yesu jwang'anambuka nukumpwagi Petili, “Tama kutali na nee, Lijobi wee! We gupala kumbengale nepani. Mawasu gaku ngasegahuma kwaka Sapanga ila ga bandu.” ");
INSERT INTO mgv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ndi Yesu jwaapwagila abole baki, “Mundu jokapi jojupala kuba mbolee jwangu nepani, julikana mweni, jujukua nsalaba waki, jumbwata. ");
INSERT INTO mgv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ndaba mundu na jupala kuulenda womi waki mweni, jwitenda kuguhoa, lakini mundu jo juguhoa womi waki ndaba jangu, jwitenda kugupata kabee. ");
INSERT INTO mgv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Boo, mundu jwiipata sindu boo ana jupatiki hindu yoka yu pundema pani na papuje juhoiki womi waki mwene? Au mundu jwipia sindu boo ili jupata kabee womi wake? ");
INSERT INTO mgv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ndaba Mwana waka Mundu jwiika nu Ukolongu wa Atati baki, pamu na atumi baki bu kunani na pala ndi pabantemula kila mundu kulengana na mahengu gaki. ");
INSERT INTO mgv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Numpwagi sakaka, abi bangi apambane ngaakue mbaka pabaambona Mwana waka Mundu pajihika koni jubii mu Ubambu Nkolongu.” ");
INSERT INTO mgv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagapeta masoba sita, Yesu jwaajukua Petili na Yakobu nundongu waki Yohana nukujenda nabu kunani ji kitombi kilasu kobabii kajika jabu. ");
INSERT INTO mgv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pababiya bukundingaliya, apalapa Yesu jwang'anambuka kubonikana kwaki. Pamihu jaki panang'ana ngati lyoba ni ingobu yaki yabii ihuu kupukupu ngati unang'anu. ");
INSERT INTO mgv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ndienu Musa na Elia batenda kupiti, babia alonge na Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ndienu Petili ampwagila Yesu, “Bambu kwibia sapi twepani kutama paambane! Ana gupai niisenga indamba itatu, simu saku na simu saka Musa na simu saka Elia.” ");
INSERT INTO mgv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petili pajabia jwakona jakalongila, lihundi lununang'anu latenda kwaayekale, na sauti jajogwanika kuhuma pilihundi lela, “Hajo Mwana wangu jonumpai, jojunengani, munzowania.” ");
INSERT INTO mgv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Banafunzi bala pabajowania sauti jela, bajogupa ngama, batenda kukupama. ");
INSERT INTO mgv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu jwaapwata, nakagusa nakapwagi, “Nzemania, mwiijogopa!” ");
INSERT INTO mgv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabalinga kunani, ngasebumbweni mundu, ila pee Yesu kajika jaki. ");
INSERT INTO mgv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pababia ahuluka kuhuma kukitombi, Yesu jwaalagalakiya, “Mwampwagi mundu majambu ga mugabweni mbaka Mwana waka Mundu pajwiiyoka kuhuma kwa bandu baawii.” ");
INSERT INTO mgv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ndi banafunzi bundalukia, “Enu ndaba jaki abola ba malagalaki apwaga juhika hote Elia?” ");
INSERT INTO mgv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu jwapwaga, “Sakaka Elia jwiika hoti nukugabeka majambu goti sapi. ");
INSERT INTO mgv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakini numpwagi, Elia juhikiki nabombi ngasebugumanyike, ila buntendila ngati hebapai. Ahelahela Mwana waka Mundu bang'alisa mwamaboku gabu.” ");
INSERT INTO mgv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndienu banafunzi baka Yesu bamanya Yesu jwabia anndongale Yohana Mmbatisa. ");
INSERT INTO mgv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabuguhikila nsambi wa bandu, mundu jumu anzendila Yesu nukumpege magoti palongi jaki, ");
INSERT INTO mgv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nukupwaga, “Bambu umbonila hikia mwana wango ndaba jubi ni kihinduhindu, kabee jung'alika ngamaa, mala jingi juhabuki pamotu au mmasi. ");
INSERT INTO mgv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nunndetiki kwaaka banafunzi baku lakini ngase bawesiki kunndamisa.” ");
INSERT INTO mgv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu jwapwaga, “Mwanganya mukibeleku sanga kuhobale na sekihobiki mwee! Niitama na mwanganya mbaka lile? Nanhinakalia mwanganya mbaka lile? Munndeta pani nkombu hoju.” ");
INSERT INTO mgv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu jukilakalia kilombu sela nasombi satenda kupita. Nunkombu wejola jwalama apalapa. ");
INSERT INTO mgv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ndi banafunzi bunzendila Yesu puujobu, nukundaluki, “Ndaba jaki twepani ngasetwawesiki kukipia kilombu sela?” ");
INSERT INTO mgv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu jajibua, “Ndaba nhuobale kasokopi. Numpwagi sakaka, ana pee mmbii na nhobale nzoku ngati imbeju ja haladali, mwiwesa kukipwagi kitombi ase, ‘Boka hapa ujenda pala,’ Nasombi kiitenda kujenda. Nga sindu sokapi sesisindikana kwinu. ");
INSERT INTO mgv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lakini kilombu ngati ase ngakuwesa kupita kwindela jokapi ila kukiboa ila sukundoba Sapanga nukupunga kula.” ");
INSERT INTO mgv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Banafunzi boti ebahika ku Galilaya, Yesu jwaapwagila, “Mwana waka Mundu bantenda kunkamula nukunkabisa kwa bandu, ");
INSERT INTO mgv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nabombi biitenda kunkoma lakini lisoba la tatu jwiitenda kuyoka.” Banafunzi baki gwaabina mwoju ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na banafunzi baki pabahika ku Kapelinaumu, bandu bababia ajopa kodi Nyumba jaka Sapanga bunzendila Petili nukundaluki, “Boo, mbola waku julepa kodi ja Nyumba jaka Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petili jwajibua, “Helo, julepa.” Petili pajwajingala mu nyumba, kabula ngasejupwajiki lilobi, Yesu jatumbuliya kumpwagi, “Wa Simoni gubona boo? Aka bambu akolongu bupunndema ajopa ushulu na kodi kuhuma kwaka nyane? Kuhuma kwa benei au kwa agene?” ");
INSERT INTO mgv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petili jwajibwa, “Kuhuma kwa ageni.” Yesu jwapwaga, “Gupwajiki sapi, benei ngaseapalika kulepa. ");
INSERT INTO mgv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakini ngasetupalika kwaajege inyela bandu haba. Jenda kunhanga, wakalekala ndoana jaku, na homba ja kwanza jegulonguli kulopo, ukananungula nndomu waki ndipala ukijiketaniya lupija nkati. Wiijukua lupija lola ili wakaalepa kodi jaku na kodi jango.” ");
INSERT INTO mgv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Apalapa banafunzi baka Yesu bunzendila, Yesu nu kunndaluki, “Nyaa nkolongu mu ukolongu ukunani kwaka Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu ankema mwana nsoku nukunzemeka pikilanda jabu. ");
INSERT INTO mgv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Japwagila, “Numpwagi sakaka ana ngaseng'anambwiki na kulengana ngati mwana nsoku, kyee nganzingi mu ukolongu ukunani. ");
INSERT INTO mgv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jokapi jojulibona ngasindu ngati mwana nsoku ajo, hoju ndi nkolongu mu ukolongu ukunani. ");
INSERT INTO mgv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jokapi joanzopa mwana nsoku ngati jonzo kwii liina langu, hoju junyoopa nepani. ");
INSERT INTO mgv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Jokapi joankolo jumu ja bana asokopi baanhobale nepani atenda mahakau, kwakabia mbanga bunkonga lilibu lukupole pahingu nukundeke punhanga pandu papanyoliki.Bandu abeli apola kukutumi lilibu lukupole. ");
INSERT INTO mgv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Misibikiboni bandu bupunndema ndaba jakwaakolo bangi kutenda mahakau. Kukolo lasima kupitila lakini misijukiboni mundu jojwaakolua bangi haga gapitila. ");
INSERT INTO mgv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ana kuboku kwaku au kugolu kwaku kukukolwi kuhenga mahakau, nambanga ukusekula nukukuleke kutali naweapa. Nambanga kujingi mu womi wa masoba goti bila kuboku au kugolu kuliku kukuleke mmwotu wa yaka petapeta koni ubii na maboku gabeli na magolu gaku gabeli. ");
INSERT INTO mgv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Liu laku ana lukukolwii kuhenga mahakau, litupula nukulileke kutali na weapa. Nambanga gujingila mu womi wa masoba goha koni gubi naliu limu, kuliku kujingi mu motu uku jehanamu koni ubii na miu gaku goka mabeli. ");
INSERT INTO mgv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mulilinga, mwaambona jumu kati ja bana aba ngati nga sindu sukuhobale. Numpwagi, atumi babu bu kunani abi masoba goha pambipi na Atati bangu kunani kwa mahundi. ");
INSERT INTO mgv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ndaba Mwana waka Mundu juhikiki kwaagombo bandu baahobiki.” ");
INSERT INTO mgv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mmbona boo? Mundu na jubi na makondoo makomi komi, ana limu lihobiki jutenda boo? Jwagaleka makondoo tisini na tisa gala kukitombi, nukujenda kulitaputa limu lelihobiki. ");
INSERT INTO mgv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Numpwagi sakaka, ana julipatiki julitogule lelu ngani kupeta makondoo makomi tisa na tisa gagabia ngasegahobiki gala. ");
INSERT INTO mgv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ahelahela, Atati bitu bu kunani ngasejupala mundu hata jumu kati ja asoku aba ahoba.” ");
INSERT INTO mgv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ndongu waku na jukukosi, unzendila ukumpwagila likosa laki weapa na jombi pambii mwakajika. Najugujowani, jibiya ndongu waku kabee. ");
INSERT INTO mgv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ana jukaniki kugujowane, unzukua mundu jumu au abeli pamu na wamweti, ili kila lilobi ajowana bandu abeli au atatu ngati Maandiku gaka Sapanga hegapwaga. ");
INSERT INTO mgv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ana ngasejwajogwani na haba, wakaapwagila bandu babunhobale Sapanga. Ana jukaniki kwaajoane bandu babunhobale Kilisitu kwaku weapa jiibiya ngati bandu banga kummanya Sapanga na ngati bandu babaajopa bandu kodi.” ");
INSERT INTO mgv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Numpwagi sakaka, sokapi semwikikanakia punndema pani kibia bikikanaki nu kunani kwaka Sapanga, na sokapi semwakijetakiya pundema kibia bikijetaki kunani.” ");
INSERT INTO mgv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kabee numpwagi, abeli kati jinu ana ajetangani pundema pani kuloba sindu sokapi kwaka Atati na Atati bangu bu kunani jwantendila sindu hesi. ");
INSERT INTO mgv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ndaba pokapi pala paketangana, bandu abeli au atatu kwi liina langu, nepani mii apalapa pamu nabu. ");
INSERT INTO mgv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petili anzendila Yesu nukunndaluki, “Boo, Bambu, nndongu wangu ana jungosi nunndekakia mala palenga? Amala nundekakiya mala saba?” ");
INSERT INTO mgv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu jwapwaga, “Ngasembwaga pee mala saba, lakini hata makomi saba mala saba. ");
INSERT INTO mgv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndaba ukolongu ukunani ulengana nu nkolongu jumu jojaamua kukagu lupija lwaki loabinaku bandu baahenge lihengu mumali gaki. ");
INSERT INTO mgv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hejwatumbuliya kubalanga bunndetila mundu jojwabia anndaja lupija lwingi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundu jola ngasejwabi na sindu sokapi sukunndepa, ndi bambu waki jwaalagalakiya bunndombisa ngati ntumwa, jombi nunhwanu waki na bana baki na nahindu yoka yejubinaku ili julepa lideni. ");
INSERT INTO mgv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ntumisi jola jwapega magoti palongi jaki nukupwaga, ‘Guhinakaliya nane nakulepa kila sindu.’ ");
INSERT INTO mgv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bambu jola ambonila hikia, nu kunndekake lideni lela, nukundeka jujenda. ");
INSERT INTO mgv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lakini ntumisi jola jwaboka, ankolila jumu kati jaatumisi ajaki jojwabi jombi anndaja lupija kidogu. Ankamula nukunhinyati pahingu, nukumpwagi, ‘Nepa lupija lwango.’ ");
INSERT INTO mgv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntumisi nnzaki jola najombi jwapega magoti nukupwaga, nu kunndoba, ‘Guinakaliya mbaka nugulepe.’ ");
INSERT INTO mgv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lakini jombi ngasejwatenda kukana, ila anzegala mukipungu mbaka pajwiilepa lupija lola. ");
INSERT INTO mgv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Atumisi ajaki pababona hela waabina mioju ngamaa, bajenda kupwagi bambu wabu majambu gagapitii pala. ");
INSERT INTO mgv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bambu jola ankema ntumisi jola nukumpwagi, ‘Weapa untumisi mbaja ngamaa! Wanoba nepani nukulekakia lideni laku nane nukulekaki lideni laku loti ndaba wandenda kunoba. ");
INSERT INTO mgv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kupalika gumbonila ikia ntumisi nzaku ngati nepani henugubonila weapa ikia.’ ");
INSERT INTO mgv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bambu jola jwayomiki ngamaa, ambeka mukipungu anng'alisa mbaka pajwiilepa lideni loti.” ");
INSERT INTO mgv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu jaendaliya kupwaga, “Atati bangu bu kunani ebantendila ahelahela, ana ngasemwalekaki alongu bii kuhuma mmyoju jino.” ");
INSERT INTO mgv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pajajomula kupwaga hela, jwaboka ku Galilaya, jwajenda ku Yudea, kwii ja losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bandu bingi bumpwata kola, najombi jwatenda kwaalamisa. ");
INSERT INTO mgv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afalisayu bangi bunzendila Yesu, nukundaluki sukumpendake, “Boo, sapi lee mwanalomi kuntalika nhwanu waki kwi likosa lokape?” ");
INSERT INTO mgv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu jwapwaga, “Boo, ngase nsomiki mu Maandiku gaka Sapanga, Sapanga jojabomba mundu toka putumbuli, jabomba mmbomba na mwanalome? ");
INSERT INTO mgv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Henu Sapanga japwaga kabee, ‘Kwa ndaba heji mwanalomi jaaleka atati baki na amabu baki nukujongana nu nhwanu waki, nabombi abeli haba biibia nhyega jimu.’ ");
INSERT INTO mgv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Henu bombi nga abeli kabee ila nhyega jimu. Sejukilombangini Sapanga, Mundu jwaakilekanisa.” ");
INSERT INTO mgv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afalisayu bundalukia, “Henu ndaba jaki Musa jutulagalakia mundu kumpeke nhwanu waki likalatasi luku lekana nukunndeka?” ");
INSERT INTO mgv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu jaapwagila, “Musa anndekakiya mwaleka akaahanu bii ndaba jukunonopa kwa mioju jiino. Lakini ngase kwabii hela toka pakwatumbulia. ");
INSERT INTO mgv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Henu numpwagi, jokapi jojundeka nhwanu waki kwa ndaba jokapi ilapee kwa ndaba ju ugoni, nukujuku mmbomba jongi, jutenda ugoni.” ");
INSERT INTO mgv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Banafunzi baki bumpwagila, “Ana ndi ekukuba kwaka mwanalomi numbomba nambanga kutama bila kujuku mmbomba.” ");
INSERT INTO mgv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu jaapwagila, “Nga boka baawesa kulijopa libolee heli, ila pee baapatiki uwesu kuhuma kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndaba ibi hindu toauti yeyaahenga bandu biijukuu mmbomba, ndaba bangi asaliwi ahelahe, bangi ndaba bandu baatei abia hela. Bangi ahamwi beni nga biijukue ndaba ju Ubambu ukolongu ukunani. Mundu jojuwesa kulijopa libolee ale julijopa.” ");
INSERT INTO mgv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ndi bandu bunndetila Yesu bana ili jwaabekila maboku na kwaalobe. Lakini banafunzi batenda kwaalakali bandu babaaleta bana. ");
INSERT INTO mgv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu jwapwaga, “Mwaaleka bana asoku aba ahika kwangu, wala mwaapengale, ndaba ukolongu ukunani ndi wa bandu ngati bana asoku aba.” ");
INSERT INTO mgv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ndi jwaabekila maboku ili kwaapenge, nu kuboka pala. ");
INSERT INTO mgv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu jumu anzendila Yesu nukupwaga, “Mbola ndendakii saamboni ili mbata womi wa yaka petapeta?” ");
INSERT INTO mgv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu jwapwaga, “Ndaba jaki gunaluki kupete lijambu la ambone? Jubii jumu pee jojubii jwa amboni ndi Sapanga. Ana gupai kujingi mu womi, kamula mihilu jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundu jola jwalalukia, “Mihilu bole?” Yesu jwapwaga, “Wiikoma na wiitenda ugoni na wiijiba na wiilonge isoli, ");
INSERT INTO mgv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","waajoannya atati baku na amabu baku na umpala mundu wa pambipi jaku ngati heulipala wamwe.” ");
INSERT INTO mgv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nkombu jola jwapwaga, “Goti aga nagakamwi toka panabii namwana, henu mbongukiki na sengi kike?” ");
INSERT INTO mgv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu jwapwaga, “Ana gupala kuba wa mundu waamboni sakaka, jenda kalombisa hindu yaku yoka yegubinaku waapekia aka kapuku lupija, wiibia na kikoku kunani, ndi guika kumbwata.” ");
INSERT INTO mgv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nkombu jola pajwajogwana hela, jwajenda koni ngasejutogulela, ndaba jabii na mali. ");
INSERT INTO mgv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ndi Yesu jwaapwagila banafunzi baki, “Numpwaagi sakaka kunonwipi ngamaa mundu mwana mali kujingi mu ukolongu ukukunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Numpwagi kabee, kunonwipi ngamaa mundu mwana mali kujingi mu ukolongu waka Sapanga, kuliku kinyama sebikikema ngamia kujingi mulihotu la sindanu.” ");
INSERT INTO mgv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Banafunzi bala hebajowana hela, basangi ngamaa, bunndalukiya, “Henu nya jojuwesa kulama?” ");
INSERT INTO mgv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu jwaalingalia nukupwaga, “Kwa bandu lijambu heli ngaseliwesikana lakini kwaka Sapanga goka gawesikana.” ");
INSERT INTO mgv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petili japwaga, “Natwepani, tukilekiki kila sindu tukupwatiki weapa twiipata kike?” ");
INSERT INTO mgv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu jwapwaga, “Numpwagi sakaka, Mwana waka Mundu pajwiitama pikiteu saki su ukolongu mu nndema nnyai. Mwanganya mwembwatiki nepani, mwiitama mwiiteu komi ni ibeli, koni mukatemula makabila komi ni ibeli guku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jokapi jojulei nyumba, au nndongu au nndombu au atati au amabu au matui, ndaba jangu nepani, jwiijopa mala makomi komi nukupata womi wa yaka petapeta. ");
INSERT INTO mgv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakini baabia buutumbulii biikuba ba mwisu, na baabi ba mwisu biikuba buutumbulii.” ");
INSERT INTO mgv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ukolongu ukunani ulengana na mundu jojubii nilitui, jojaboka lukela ngani kujenda kwaataputa bandu bukuhenga lihengu mulitui laki li mizabibu. ");
INSERT INTO mgv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jajetangana nabu kwaalepa mangengalema gu lupija lulihengu lwi lisoba limu, ndi jwaapelika kulitui laki li mizabibu. ");
INSERT INTO mgv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Egapeta masaa matatu, jwajenda kabee jwabona bandu bangi ajemiki kuguliu, ngaseabi ni lihengu. ");
INSERT INTO mgv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jwaapwagila, ‘Nzendania nanamu mwakahenga lihengu mulitui langu li mizabibu, nane nandepa.’ ");
INSERT INTO mgv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nabombi bapiti. Jojubi nilitui jola jwaboka kabee saa sita na saa tisa, jahenga kabee ahelahela. ");
INSERT INTO mgv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hesahika saa komi na jimu pakamii jajenda kabee, jwaaketania bandu bangi ajemiki pagulio pala. Jaalalukia, ‘Ndaba jaki nzemiki pamba lyobamutu loti bila lihengu?’ ");
INSERT INTO mgv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bandu bebala bunzibua, ‘Ndaba ngamundu jojutupeki lihengu.’ Najombi jwaapwagila, ‘Nzendania nanamu mwakahenga lihengu mulitui langu li mizabibu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Helajingala lyoba, juni litui jola ampwagila jojujemale litui jola, ‘Waakema baahenga lihengu waalepa lupija lwabu, tumbuliya babatumbulia lihengu kumwisu, nukujomule babatumbulia kuuwanzu bala.’ ");
INSERT INTO mgv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pabahika babatumbuliya lihengu saa komi na jimu, bajopa kila mundu lupija lwilisoba limu. ");
INSERT INTO mgv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Babatumbulia lihengu bala hebahika, bawasalia biipata yingi ngani, lakini hata bombi bapata kipandi simu silingengalema gu lupija lwilihengu lilisoba limu. ");
INSERT INTO mgv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pabajopa lupija lwabu, batumbuliya kunhyome jwinilitui jola. ");
INSERT INTO mgv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bapwaga, ‘Bandu babahika kuhenga lihengu pakamii, bahengiki lihengu lisaa limu pee, ndaba ja kii utulepiki kulengana na bombi nakoni twepani tuhinakali lihengu pipipipi na lyoba likali?’ ” ");
INSERT INTO mgv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ndi bambu jola anzibwa jumu wabu, ‘Nkosi wango, ngasenugutei uhune nugupeki setwajetangani! Boo, ngase twajetanganii lee kulepana lupija lwi lisoba limo?’ ” ");
INSERT INTO mgv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jukua setujetanganile, ujendaje. Ne mbai kumpeke wamwisu jonzo ngati henukupeki weapa. ");
INSERT INTO mgv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Boo, ngase mbalika kutumi lupija lwangu ngati hembala? Boo, gubona wipu ndaba nepani naambone? ");
INSERT INTO mgv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu jwajomula sukupwaga, “Jojubi jwa mwisu jwiibia jukutumbuli na jojubi juutumbuli jwiibia jwa mwisu.” ");
INSERT INTO mgv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu pajwabia jukwela kunani ku Yelusalemu, jwaajukua banafunzi baki komi na abeli pandu panga na bandu, na pababii ajenda mwiindela jwaapwagila, ");
INSERT INTO mgv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nzowana, tujenda ku Yelusalemu, nahoku Mwana waka Mundu bankabisa kwaka agolu akolongu naaka abola ba malagalaki, nabombi bantemula jukomika. ");
INSERT INTO mgv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ndipala baampelika kwa bandu banga Ayaudi ili bumpoalihamu, bunndapula iboku nukumbambali punsalaba lakini lisoba la tatu jwiitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ndipala nhwanu waka Zebedayu pamu na bana baki anzendila Yesu, jwapega magoti palongi jaki nukunndoba anhengila sejupala. ");
INSERT INTO mgv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu anndalukia, “Upala kike?” Nyongo jola jwapwaga, “Pepakoku, lagalakiya pawiibia mu ukolongu waku, bana bangu abeli abaa atama jumu upandi waku wa malele na jongi upandi waku wa mangega.” ");
INSERT INTO mgv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu jwaapwagila, “Ngase mukimanyi sendoba. Boo, nhwesa kunywele kikombi seniinywelila nepani?” Bajibwa, “Tuwesa.” ");
INSERT INTO mgv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu jwaapwagila, “Sakaka mwiinywelila kikombi sangu samang'aliku, lakini kutama kumalele au kumangega kwangu nepani, nga lihengu langu ne kuhagula. Biitama babaabeki Atati bangu.” ");
INSERT INTO mgv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Banafunzi bangi komi bala hebajogwana haga, baayomila aka kilongu abeli bala. ");
INSERT INTO mgv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ndi Yesu jwaakema, nakaapwagi, “Mmanyiki aka kilongosi na bandu banga Ayaudi baalongo bandu kwa makili, na aka akolongu babu apala kwahenga bandu haba kuba bandu babu. ");
INSERT INTO mgv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lakini kwinu mwanganya kwiikuba hela, ila jojupala kuba nkolongu kati jinu jubia ntumisi jwa boti, ");
INSERT INTO mgv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na jojupala kuba juutumbuli kati jinu jubia ntumika wino. ");
INSERT INTO mgv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ahelahela, Mwana waka Mundu ngasejwahika kutumakaliwa, ila kutumiki bandu nukupia womi waki kwa gombo bandu bingi.” ");
INSERT INTO mgv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na banafunzi baki pababia aboka kumusi uku Yeliko, nsambi wa bandu watenda kumpwata. ");
INSERT INTO mgv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kwabia na banga linga abeli atemi pulutengu lwi indela, na pabajowana Yesu jwabia jupeta pala, bajamalia, “Bambu, Mwana waka Daudi utubonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nsambi wa bandu bala waalakalia nakaapwagi atama kinunu. Lakini bombi bajamalia ngani, “Bambo, Mwana waka Daudi utubonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu jwajema, nakaakema nakaalaluki, “Boo, mpala nunhengila kike?” ");
INSERT INTO mgv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bunzibwa, “Bambu, tuloba mihu gitu galinga.” ");
INSERT INTO mgv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu jwaabonila ikia, jwaagusa mihu gabu na apalapa bawesa kulinga nabombi nukumpwata. ");
INSERT INTO mgv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na banafunzi baki pa bahegali kuhika ku Yelusalemu, bahika ku Betifage pi Kitombi si Mizeituni. Yesu jaatama kola na banafunzi baki abeli, ");
INSERT INTO mgv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jaapwagila, “Nzendania mbaka kukijiji sekibi palongi ji, pala mwalibona liponda bilikongiki na mwana waki. Mwakagabopula mwagaleta kwangu. ");
INSERT INTO mgv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ana mundu jundaluki sokapi mumpwagila, ‘Bambu jutenda kugapala, najombi jandekakiya mmboka.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lijambu heli la hengika ili gajwapwaga mlota waka Sapanga gatimia, ");
INSERT INTO mgv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwaapwagila bandu buku Sayuni. Lingaliya, Bambu Nkolongu waku jutenda kuhika! Mpoli na jukweliki mu liponda, libana liliponda, mwana wi liponda kinyama sekitoto misigu.” ");
INSERT INTO mgv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ndi, banafunzi bala bajenda nukutenda ngati Yesu hejwaalagalakia. ");
INSERT INTO mgv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Biilileta liponda lela nilibana laki, batandika ingobu yabu panani ja liponda na Yesu jwatama panani jaki. ");
INSERT INTO mgv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nsambi wa bandu batandika ingobu yabu mwiindela, na bandu bangi basekula matutu gimikongu nukugagoneka mwiindela. ");
INSERT INTO mgv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nsambi wa bandu gogunndonguli na babupwata bajamalia, “Ulumbi kwaka mwana waka Daudi! Jupengalika jojuhika kupete lihina laka Bambu! Ulumbi kwaka Sapanga kunani!” ");
INSERT INTO mgv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu jajingala kumusi ku Yelusalemu, bandu boka batenda kujabalika nukulaluki, “Boo hajo nyane?” ");
INSERT INTO mgv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bandu munsambi gola bapwaga, “Hajo mlota waka Sapanga, Yesu kuhuma ku Nazaleti musi uku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu jwajingala pa Nyumba jaka Sapanga, jwaabenga kunza bandu bababia alomba nuku lombesa hindu. Jwapendula mesa ja bandu bababia aba abadisani lupija, niiteu ya bandu baabia alombesa ngunda. ");
INSERT INTO mgv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jwaapwagila, “Ahandiki mu Mahandiku gaka Sapanga, ‘Nyumba jangu jiibia nyumba jukundobe Sapanga.’ Lakini mwanganya mujing'anambwi kuba lipoli la bii!” ");
INSERT INTO mgv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bandu banga kulinga na niilema bunzendila Yesu pa Nyumba jaka Sapanga, na Yesu jwatenda kwaalamisa. ");
INSERT INTO mgv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lakini agolu akolongu na aka abola ba malagalaki pababona ndonduke yejwatei Yesu, na kabee bana pababia ajamali kwa sauti jabu pa Nyumba jaka Sapanga bakapwaga, “Ulumbi kwaka mwana waka Daudi,” Bombi batenda kuyoma. ");
INSERT INTO mgv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ndi bumpwagila, “Boo, ngasegujogwana seapwaga bana?” Yesu japwaga, “Helo, nyowana! Boo, ngasenhwahiki lee kusoma mahandiku agaga? ‘Kwi milomu ja bana asoku na bana baajonga ulipati ulumbi wa sakaka.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu jwaaleka, jwajenda ku Betania, kunza ja musi kojabii, nukugone koku. ");
INSERT INTO mgv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pulukela ngani Yesu pajwabi jubuja ku musi, jummbina inzala. ");
INSERT INTO mgv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Juubona nkongu wu ntini gumu pulutengu jiindela, juujendila lakini juuketanya ngasegubi na sokape ila pe mahamba matopu. Ndii juupwagila, “Wiibeleka kabee matunda masoba goti!” Apalapa nkongu wo ntini gola gwatenda kunyala. ");
INSERT INTO mgv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Banafunzi pababona basangi nukupwaga, “Nkongu ago gunyaliki boo nyatanyata?” ");
INSERT INTO mgv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu jwapwaga, “Numpwagi sakaka, ana mwikuba ni lihobale bila lujogopu, unhuwesa kuhenga nga pe seehengiki mu nkongu ago pena, ila hata na mukipwagi kitombi ase, ‘Tupuka ulilekala munhanga,’ kwiihengika ahelahela. ");
INSERT INTO mgv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ana mbi nilihobale, sokapi semwiloba kwaka Sapanga mwiitenda kupata.” ");
INSERT INTO mgv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu jwajingala pa Nyumba jaka Sapanga, pajwabia jutenda kubola, agolu akolongu na aseja ba bandu bundalukia, “Guhenga majambu haga kupete uwesu bole? Nya jojugupeki uwesu gwehogu?” ");
INSERT INTO mgv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu jwajibua, “Nanepani nundaluki lijambu limu, ana nhnyibwiki, nane nampwagila nhenga majambu haga kupete uwesu boo. ");
INSERT INTO mgv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Boo, uwesu waka Yohana ukubatisa wahuma kwaka nya? Boo, wahuma kunani au kwa bando?” Lakini batumbuliya kulaluana beni kwa beni, “Ana tupwagiki, ‘Gahuma kunani,’ jwatulalukia, ‘Henu mbona ngase munhobale Yohana?’ ");
INSERT INTO mgv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Natupwagiki ‘Guhuma kwa bandu,’ twaajogopa bandu haba ndaba boti ajetake Yohana mlota waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ndi bunzibua, “Ngasetumanya!” Najombi Yesu jwapwaga, “Nanepani nganumpwagi nhenga haga kupete uwesu boo.” ");
INSERT INTO mgv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwanganya mmbona boo? Mundu jumu jwabi na bana abeli. Ampwagila mwana nkolongu jola, ‘Mwanango, lelenu jenda ukahenga lihengu ku lituhi li mizabibu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nkombu jola ampwagila, “Nganyende!” Lakini mwonikatai jwaamua kujenda nukuhenga lihengu. ");
INSERT INTO mgv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ahengo bala bajenda kumpwagi kabee mwana waki wa pili jola ahelahela, najombi jwajibwa, ‘Koonyenda atati.’ Lakini ngasejwapiti ku lihengo.” ");
INSERT INTO mgv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Boo, kati ja abeli haba nya jojwahengiki sebapala atati bake? Bajibwa, “Mwana nkolongu jola.” Ndi Yesu jwaapwagila,Ndi Yesu jwaapwagila, “Numpwagi sakaka, baajopa kodi na agoni banndonguliya kujingi mu ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndaba Yohana jwahika kwinu nukunndangi ndela jejupala Sapanga, nanamu ngasemunhobalile, lakini baajopa kodi na baatenda ugoni bunhobali. Pamu na kugabona goti haga mwanganya ngasemwalekaki mahakau nukunhobale.” ");
INSERT INTO mgv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu jwaapwagila, “Nzowania lilenganu lengi. Mundu jumu mwana litui japandiki mizabibu mu litui, juliyongulaki ua litui leheli, jwahembiki libomba lukuminyi zabibu, jwasenga kindamba kilasu sukulonde. Ndi jilibesiki kwa bandu baalema, mweni jwajenda ku ndema jukutali. ");
INSERT INTO mgv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Masoba gukuhusa egahika, jwaatuma atumika baki kwaaka bandu baalema bala, ili kujuku lipungu laki kuhuma kwa yeahusika. ");
INSERT INTO mgv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bandu baalema bala baakamula atumika bala, jumu batenda kunndapu, jongi batenda kunkoma na jongi bunndapula na malibu. ");
INSERT INTO mgv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mundu jola jwaatuma kabee atumika bangi, bingi kupeta babalonguli bala. Baalema bala bababesa lituhi baatendila ngati bangi bala. ");
INSERT INTO mgv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mwisuwe antuma mwana waki koni jwaka wasalia, ‘Mwana wangu biitenda kunzoanela.’ ");
INSERT INTO mgv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lakini baalema bala pabumbona mwana waki, balongalania beni kwa beni, ‘Jonzo ndi nndisi waki, tunkomaji ili twiilisa litui lenu!’ ");
INSERT INTO mgv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ndi bunkamula nukumpia kunza ji litui li mizabibu lela, nukunkoma. ");
INSERT INTO mgv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Henu, munilitui li mizabibu pajwihika, jwaatenda boo bandu baalema bala?” ");
INSERT INTO mgv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bombi bunzibua, “Kye jiitenda kwakoma bandu abaja haba, ni litui lee jaapekiya bandu bangi litui nabombi bambaguliya zabibu mu masoba gukuhusa.” ");
INSERT INTO mgv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ndi Yesu jwaapwagila, “Boo, ngasemwasomiki lijambu heli mu Maandiku gaka Sapanga? ‘Lilibu le bilikana bandu baasenga henu ndi lenieli lilibu lelipalika kuba lunsingi kupeta goka. Lijambu hale lihuma kwaka Sapanga, nalombi lisangasa ngamaa kwitu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Henu numpwagi, Ukolongu waka Sapanga biitenda kukwepatu kwinu na kwaapeke bandu bangi babagahenga gagunndengane Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jojwiiabukia panani ji lilibu heli jwitenda kutunuka ipandiipandi, ana lunhabuki mundu jokapi, jwitenda kupondeka. ");
INSERT INTO mgv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aka agolu akolongu pamu na aka Afalisayu pabajogwa malenganu gaki, bamanya Yesu jwabia jwaapwaga bombi. ");
INSERT INTO mgv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Henu babia ataputa indela jukunkamu, lakini baajogupa bandu ndaba bombi buholaliya Yesu ndi mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu jalongila nabu kabee kwa malengano nukupwaga, ");
INSERT INTO mgv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ukolongu u kunani kwaka Sapanga gulengana na Bambu nkolongu jumu ehantendila mwana waki tipati ga posu ja kutola mmbomba. ");
INSERT INTO mgv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ndienu jaatuma atumika baki bakaakema bajwaakokiki ahika pa tipati, lakini bajaakokiki bala batenda kukana kuhika. ");
INSERT INTO mgv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ndienu jatuma kabee atumika bangi japwaga, ‘Mwaapwagila banaakokiki bala, ndeliki posu ja tipati, nzinziki likambaku la ng'ombi na ng'ombi yengi yeikendiki, nakila sindu kibii sapi. Nhikaniya ku tipati ga posu ja kutola mmbomba.’ ");
INSERT INTO mgv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakini bandu bala batenda kusonzoa, kila mundu jajenda kulihengu laki, jongi kulituhi laki na jongi jajenda kukuhemalesa nukulombase hindu yaki. ");
INSERT INTO mgv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bangi baakamula atumika bala baalapula na kaakoma. ");
INSERT INTO mgv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bambu nkolongu jola jatenda kuyoma. Jaatuma alonda baki bakaakoma bandu babakomiki atumika baki bala, nukugujosa mwotu musi wabu. ");
INSERT INTO mgv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ndienu jaapwagila atumika baki, ‘Tipati ja posu ju kutola mmbomba jabii sakaka, lakini banaakokiki ngasebapalika kuhika. ");
INSERT INTO mgv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ndienu nzendaniya pa maagobukanu mwakakema bandu boka bamwaabona, akahika pa tipati ga posu ju kutola mmbomba.’ ");
INSERT INTO mgv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Atumika bala babokaniya, bajendaniya mwindela, baaleta bandu boka babaakolila, ba asapi na abaja. Nanyumba ja tipati jatweli bandu ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Bambu nkolongu ejajingala nakabona ageni, ambona mundu jumu, ngase juweti ingobu ya tipati ga posu ju kutola mmbomba. ");
INSERT INTO mgv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bambu nkolongu andalukiya, ‘Nkose, gujingi boo mombo bila ingobu ja ndoa?’ Lakini jombi jatama kinunu. ");
INSERT INTO mgv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Henu bambu nkolongu jaapwagila atumika baki, ‘Munkonga mu magolu numumaboku mukundekala kunza kulwii. Hoku kwiibiya kilelu nukupola minu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu jajomuliya kupwaga, “Bingi baakokiki lakini baahaguliwi asokopi.” ");
INSERT INTO mgv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Afalisayu bajendaniya, bataputa indela jukumpendake Yesu kwa malobi gaki. ");
INSERT INTO mgv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ndienu baatuma banafunzi babu pamu ni kikundi saka Helodi kwaka Yesu, bumpwagila, “Mbola, tumanyiki weapa gupwaga sakaka, naweapa gubola sapi indela jaka Sapanga, bila kujogopa bandu apwagakii, ndaba ngasegulingali pamiu jaka mundu. ");
INSERT INTO mgv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Henu utupwagila, boo weapa gubona bole? Boo sapi lee au nga sapi kulepa kodi kwaka nkolongu juku Loma jobunkema Kaisali?” ");
INSERT INTO mgv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu jugumanyiki mpangu wabu uliyaa henu jalalukiya, “Mwanganya monkopake mwamboni ndaba jaki nndenda kumbendakela? ");
INSERT INTO mgv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nangia hoti lingengalema lu lupija lukulepe kodi!” Nabombi bumpekia lingengalema lu lupija. ");
INSERT INTO mgv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu jalalukiya, “Pamihu apa na lihina alee laka nyanye?” ");
INSERT INTO mgv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bapwaga, “Jaka Kaisali Nkolongu juku Loma.” Apalapa Yesu jaapwagila, “Henu yaka Nkolongu juku Loma mupekia Nkolongu juku Loma na yaka Sapanga mupekia Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pabajowana ganiaga, basangii ngamaa, bundeka nukubokane. ");
INSERT INTO mgv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lisoba leheli, aka Asadukayu bangi, baapwaga bawi ngase ayoka, bunzendila Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Bapwaga, “Mbola, Musa japwaga mundu jojutoguliki ana juwii sanga kundeka mwana, kupalika nnuhuna waki anzukua mmbomba jowii alome ili ampapila mmbeli waki we jola bana. ");
INSERT INTO mgv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Henu, pitu pani abii akalongu saba. Nkolongu jatoi mmbomba nakuwa, ndaba ngasejapatiki mwana, mbomba we jola antola nnuhuna waki. ");
INSERT INTO mgv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sindu aselase supitila nnuhuna waki wa pili na watatu mbaki wa saba. ");
INSERT INTO mgv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mwisuwe mmbomba jatenda kuwa. ");
INSERT INTO mgv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Henu, lisoba lukuyoka mmbomba we jola jibiya nhwanu wakanyanye? Ndaba boka saba babiya antoi.” ");
INSERT INTO mgv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu jaapwagila, “Mwanganya nkose ndaba ngase mugamanyi Maandiku gaka Sapanga wala makili gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ndaba bandu bawii ebiyoka ngabitoguleki wala kutola, ila biibiya ngati atumi bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lakini lijambu lukuyoka kwa bandu ba wii, boo, ngasensomiki gaju mpwagila Sapanga? Jwapwaga, ");
INSERT INTO mgv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nepani na Sapanga waka Ibulahimu, Sapanga waka Isaka na Sapanga waka Jakobu.’ Jombi nga Sapanga ba bandu bawii ila Sapanga wa bandu babi bomi.” ");
INSERT INTO mgv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nsambi wa bandu gola ewajoana gala, basangii ngamaa mabole gaki. ");
INSERT INTO mgv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Afalisayu ebajowana Yesu jabiya jatamisi kinunu Asadukayu, baketangana pamu. ");
INSERT INTO mgv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jumu wabu, jabiya mbola wa malagalaki, jalenga kundaluki Yesu sukumpendake. ");
INSERT INTO mgv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Andalukiya, “Mbola, nhilu boo gogubii nkolongu mumalagalakila?” ");
INSERT INTO mgv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu japwaga, “Gumpala Bambu Sapanga waku kwa mwoju waku woti, na kwa loho jaku joti na kwamalangu gaku goti. ");
INSERT INTO mgv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gongo ndi nhilu nkolongu kabee ndi jejilongule. ");
INSERT INTO mgv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jejipwata ndi jenze, ‘Gumpala nnzaku ngati eulipai wamwete.’ ");
INSERT INTO mgv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagalaki goti gaka Musa na mabole ga alota baka Sapanga gahobale mihilu mibeli heji.” ");
INSERT INTO mgv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afalisayu pabaketangana pamu, Yesu jalalukiya, ");
INSERT INTO mgv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwanganya mumbona boo, Kilisitu Nkombosi? Boo, jombi mwana waka nyanye?” Bombi bapwaga, “Mwana waka Daude.” ");
INSERT INTO mgv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu jaapwagila, “Henu kubiboo Daudi we kwa makili ga Loho jaka Sapanga ankema jombi Bambo? Pajwapwaga, ");
INSERT INTO mgv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bambu apwagila Bambu wangu, tama pamba upandi wangu uku malele, mbaki panaabeka abaja baku pai ja magolu gako.’ ");
INSERT INTO mgv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ana Daudi ankema Kilisitu Nkombosi ‘Bambu,’ henu kuwesikana boo jubiya mwana wake?” ");
INSERT INTO mgv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngamundu jokapi jojajibua lilobi. Toka lisoba leheli ngamundu jojalenga kundaluki lijambu lokapi. ");
INSERT INTO mgv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ndipala Yesu jugupwagila nsambi wa bandu pamu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aka abola ba Malagalaki na Afalisayu ndi bababi nu uwesu gukubola Malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ndienu nzetakiya nukuhenga goka gabumpwaji kuhenga. Lakini mwiipwata mahengu gabu, ndaba ngaseahenga gala gabundandi. ");
INSERT INTO mgv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bombi akonga misigu jejitopiki nakatweka bandu mwamabega gabu, koni beni ngaseapai kulangi hata lukonzi nukutondabe. ");
INSERT INTO mgv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bombi ahenga majambu gabu goka ili abonikana kwa bandu. Awata hipandi ikolongu yiingobu yeahandiki Malagalaki gaka Musa nukujonzuke ulasu wi ingobu yabu. ");
INSERT INTO mgv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Apala kutama ku tipati iteu ya sapi nu munyumba jukuketangane Ayaudi apala kutama iteu ya palongo. ");
INSERT INTO mgv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Apala kulamukiwa mu maguliu, kabee apala bandu baakema, ‘Mbola.’ ");
INSERT INTO mgv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakini mwanganya baankema ‘Mbola,’ ndaba mmbii nu mbola jumu pee, nu mbanganya mwaboti mwa kikilongu. ");
INSERT INTO mgv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wala mwankema mundu jokapi pani pundema, ‘Atati,’ ndaba mmbii na atati bamu, ndi baabi kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wala baankema ‘Akilongosi,’ ndaba mmbii ni kilongosi jumu pee, ndi Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jojubi nkolongu kati jinu jupalika kuba ntumisi wino. ");
INSERT INTO mgv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jokapi jojulibeka nkolongu biitenda kunhulu, na jokapi jojilihulu ammbeka nkolongu. ");
INSERT INTO mgv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Musimukiboni mwaka abola ba Malagalaki na aka Afalisayu! Mo mulikopake mwa amboni! Ndaba mwapungi bandu nndyangu ukujingi mu ukolongu ukunani kwaka Sapanga, na mwabeti ngasenzingii momu, wala ngasemwaajetakale bandu baapala kujingi ajingala.” ");
INSERT INTO mgv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Musimukiboni mwaka abola ba Malagalaki na Aka afalisayu mo mulikopake mwa amboni! Mwaanyaga aka mbomba baawii alomi babu hindu yabu, nukukopake mwa bandu baamboni sukuloba sala nasu. Henu mwitemuliwa ngani. ");
INSERT INTO mgv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Musimukiboni mwa abola ba Malagalaki na Afalisayu! Mo mulikopake mwa amboni! Nnzenda munhanga nu munndema kuhenga mundu jumu jupwata indela jinu jukumpwata Sapanga. Namuupatiki muhenga juwesa kujenda kumwotu wanga kususuka mala pabeli ngani. ");
INSERT INTO mgv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Musimukiboni mwaka kilongosi banga linga! Mwanganya mpwaaga, ‘Mundu najulapiki kwa Nyumba jaka Sapanga, kuliga jee kola nga sindu, ila najulapiki kwa zahabu yu Nyumba jaka Sapanga kuliga kwekola kwiibiya na makili.’ ");
INSERT INTO mgv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwanganya mwang'ang'a mwangakulinga! Saa sekibi sapi nakanope, zahabu au Nyumba jaka Sapanga jejihenga zahabu jibiya ja sapi. ");
INSERT INTO mgv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kabee mpwaaga mundu najulapiki kwa mesa jukupiiki litambiku nga sindu, lakini najulapiki kwa matambiku gaabei panani ji litambiku, kilapu sesela suunkamu mweni. ");
INSERT INTO mgv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwanganya mwangalinga! Saa sekibi sapi ngani, boo matambiku au mesa jukupiiki litambiku leligahenga matambiku gabia ga sapi? ");
INSERT INTO mgv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Henu, jojulapa kwi litambiku jukuba julapiki pa mesa jukupiki litambiku, na sokapi seabei panani jaki. ");
INSERT INTO mgv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jojulapiki kwa Nyumba jaka Sapanga jukuba julapiki kwa nyumba heji na kabee jukuba julapiki kwa jojutama nkati ja nyumba jaka Sapanga heji. ");
INSERT INTO mgv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Najojulapa kwa kunani kwaka Sapanga, julapa kwi kiteu su ubambu saka Sapanga na kwaka Sapanga sejutami. ");
INSERT INTO mgv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Musimukiboni mwaka abola ba Malagalaki na Afalisayu mwe mwilikopake mwa amboni! Mwaalepesa bandu pandu pamu pa komi ya hindu isoku, ngati manyoi gaganungi sapi, binzali na kalafu na ndimbalila, lakini nkotoka kukamu majambu makolongu ga Malagalaki, kuhenga gajwagapai Sapanga na kuba ni ikia nu kunhobale Sapanga. Ananhengiki haga na mwikotoka na gangi haga. ");
INSERT INTO mgv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwakikilongosi mwangakulinga! Mmboa lunzenzema musindu sakunywa sinu, lakini mukimila kinyama sebikikema ngamia! ");
INSERT INTO mgv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Musimukiboni mwaabola bamalagalaki na Afalisayu! Mwenkopake mwaamboni mwanganya! Nngoloo nzipuli ni kibega kunza lakini mukuleka nkati kutweli hindu yempatiki kukukwepatu nuusoju. ");
INSERT INTO mgv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weapa mfalisayu jwangalinga! Gulonguliya oti kugolo nnzipuli nkati nikibega, ndienu kunza kwiibiya sapi. ");
INSERT INTO mgv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Musimukiboni mwaabola bamalagalaki na Afalisayu! Mo mulikopake mwaamboni! Mbii ngati matenge gaapaki langi nhuu, gagabonikana ga sapi sakunza, lakini nkati gatweli maupa ga bandu na kila sindu kibaja. ");
INSERT INTO mgv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ahelahe na mwanganya mbonekana na bandu kwa kunza nnhenga gajupala Sapanga, lakini nkati jii mwaabaja nu usapu wa kila namuna. ");
INSERT INTO mgv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Musimukiboni mwaabola ba Malagalaki na Afalisayu momlikopake mwaamboni na mwaabaja! Nzengale matenge ga alota baka Sapanga nu kugapamba matenge ga bandu bababi baamboni. ");
INSERT INTO mgv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mpwaga, ‘Ana twepani twakabia masoba gaka hoku bitu nga twakajongini nabu kwaakoma alota baka Sapanga!’ ");
INSERT INTO mgv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Henu nndangi mwabeti ndi mwa bana babaakoma alota baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hena, nhendilia kuhenga batumbulia kuhenga aka hoku bii! ");
INSERT INTO mgv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwanganya majoka ni kibeleku si lijoka! Nhwesa boo kukijepa kutemuliwa ku mwotu wangakususuka? ");
INSERT INTO mgv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Henu nundete alota baka Sapanga, bandu babii na malangu na abola. Bangi babu mwitenda kaakoma na bandu bangi mwiitenda kwaabambali pu nsalaba, na bangi mwaalapula iboku munyumba yinu yukuketangane Ayaudi nakaabenga kuhuma mmusi gumu kujenda mmusi gongi. ");
INSERT INTO mgv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sapanga jammbona mwa bandu biliya ndaba mwaakomiki bandu boti ba amboni, toka kukomeka kwaka Abeli mundu jwa amboni jola mbaka kukomeka kwaka Zakalia mwana waka Balakia jomunkoma pikilanda ja Nyumba jaka Sapanga na mesa jukupiki litambiku. ");
INSERT INTO mgv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Numpwagi sakaka, kibeleku senze kitenda kutemuliwa ndaba ja majambu ganga. ");
INSERT INTO mgv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mwabandu buku Yelusalemu! Mwabandu buku Yelusalemu! Mwanganya mwaakoma alota nakalapu malibu babatumiki kwinu, natokuli ngamaa kwaabeka pamu bana binu ngati ingoku eijobate ibana yaki kwa mapapati gaki lakini mwanganya ngasemwapaile. ");
INSERT INTO mgv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Henu nyumba ji jaka Sapanga bijilei lihami. ");
INSERT INTO mgv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Numpwaji ngamwimoni kabee mbaka lisoba lemwipwaaga, ‘Jupengilika jojuhika ku lihina laka Bambo.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu japita pa Nyumba jaka Sapanga, pajabiya jakajenda, banafunzi baki bunzendila, nukulangi Nyumba jaka Sapanga easengiki. ");
INSERT INTO mgv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu jaapwagila, “Boo, mgabona le manyumba gangane. Numpwagi sakaka ngalihigali lilibu panani ji lilibu lengi, kila lilibu liihabuliwa pai.” ");
INSERT INTO mgv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu pajabii jutemi panani ji Kitombi si Mizeituni, banafunzi baki bunzendila pa kajika bundalukiya, “Tupwagila majambu haga gipitila lile? Na nginyuli boo jewilangia kuhika kwaku na mwisu upundema pane?” ");
INSERT INTO mgv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu jajibua, “Nnzepana mundu jwankonga. ");
INSERT INTO mgv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ndaba bandu bingi bihika ku lihina langu koni apwaaga, ‘Nepani ndi Kilisitu,’ nabombi baakonga bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mwijowana ngondu na majambu ga ngondu, lakini mwijogopa. Ndaba ganiaga gapalika kupitila hoti, lakini mwisu upundema wakona ngaseguhikike. ");
INSERT INTO mgv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Musi gumu guikomana na musi gongi, ukolongu gumu gwikomana nu ukolongu gongi. Kwiibiya ni ling'ai li inzala ni kililima kila pandu. ");
INSERT INTO mgv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Haga goti gibiya ngati utumbuli gulipyanda ukubeleka mwana.” ");
INSERT INTO mgv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ndienu bantenda kunng'anambuka nukunng'alisa nu kunkoma. Bandu boti bupunndema bansukila ndaba jukunhobale nepani. ");
INSERT INTO mgv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Masoba ge haga bandu bingi biikotuka kuhobale, biing'anambukana nu kusukiana. ");
INSERT INTO mgv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Biipitila alota bingi biisoli, nakaakonga bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndaba jukujonzukeka ubaja ngani, upali wa bandu bingi gwiitenda kupongoo. ");
INSERT INTO mgv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lakini jojwihinakaliya mbaka pamwisu ndi jojikombuliwa. ");
INSERT INTO mgv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lijambu la Amboni lende lu ubambu ukolongu waka Sapanga liilandiwa kwa bandu boti punndema ili bilijowana nukulibona bandu boti. Ndienu mwisu upunndema pagwihika.” ");
INSERT INTO mgv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pamwibona ‘Liyomisu Lukuhalabana,’ lejalongila mlota waka Sapanga Danieli, lijemiki pandu pa sapi pa Nyumba jaka Sapanga, jojusoma jumanya maana jaki.” ");
INSERT INTO mgv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ndienu bandu baabii ku Yudea atilila kuitombi. ");
INSERT INTO mgv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jojubii kunani ja nyumba jaki juhuluka nu kutila bila kujuku sindu mu nyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jojubi ku litui jwiikelabuka ku nyumba kujuku ingobu yaki. ");
INSERT INTO mgv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bing'alika ngamaa aka nyongo bini hitumbu na bajongesa mu masoba ge haga! ");
INSERT INTO mgv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mundoba Sapanga ili kutila kwinu kwikuba mu masoba gi kipepu au Lisoba lu Kupomulela! ");
INSERT INTO mgv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ndaba kuibiya na mang'aliku makolongu ngasekuwahiki kupitii tumbuka kubombeka kunndema mbaka lelenu, na ngagipiti kabee mang'aliku makolongu ngati haga. ");
INSERT INTO mgv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ana masoba haga nga gakapungiswi, nga mundu jojakalama, lakini ndaba ja bandu bahaguliwi, Sapanga jupungwisi masoba ge haga. ");
INSERT INTO mgv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ndienu, mundu najumpwagi lisoba heli, ‘Linga, Kilisitu Nkombosi jubi pamba’ au ‘Jubi palapa,’ mwihobalela. ");
INSERT INTO mgv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ndaba biipitila aka Kilisitu biisoli na alota biisoli. Nabombi biihenga nginyuli ngolongu na ndonduke ili kwaakonga bandu kuwesikana hata bahaguliwi na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nzowaniya! Nongule kumpwagi lijambu hale kabula masoba kuhika.” ");
INSERT INTO mgv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Henu mundu jokapi najumpwaji, ‘Kilisitu Nkombosi jubi kulukoba,’ mwiijenda hoku, au ‘Nndinga jujobiki nkati,’ mwihobale. ");
INSERT INTO mgv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndaba Mwana waka Mundu kwiibonika ngati unang'anu wikitobi hegunang'ana kunani, kuhuma upandi golipiti lyoba mbaka upandi golijingii lyoba.” ");
INSERT INTO mgv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ndaba pokapi pakibii sindu sekiwii ndi paketangana ijuni yebiikikema tai. ");
INSERT INTO mgv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Apalapa masoba haga egiipeta, liyoba baalijegala lwii, na mwehi ngawinang'ane, na ndondu yiiabuka kuhuma kunani kwaka Sapanga na makili ga hindu yeibii kunani gitenda kunyuka. ");
INSERT INTO mgv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ndienu nginyuli yaka Mwana waka Mundu jiibonikana kunani, na bandu bupunndema biitenda kulobalake, bandu bammbona Mwana waka Mundu juhika mu maundi kunani kwaka Sapanga pamu na makili nu ukolongu wingi. ");
INSERT INTO mgv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sauti ngolongu ja mapenega jiitenda kujowaneka najombi jaatuma atumi baki bu kunani kwaka Sapanga, baabeka pamu baahaguliwi bala kuhuma pandi yoti yu punndema, kuhuma nndema joti. ");
INSERT INTO mgv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mulibola lilenganu lende kuhuma mu nkongu wu ntini. Mambandi gaki pagatumbuli kuba gundepwani nukutunduli mahamba, mmanya kuegale kuhusa ilebi. ");
INSERT INTO mgv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ahelahe pamwagaabona goti haga mmanya muda guegali. ");
INSERT INTO mgv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Numpwagi sakaka, kibeleku senze ngakikui kabula ja majambu ganga kupiti. ");
INSERT INTO mgv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunani kwaka Sapanga na nndema yoti kwiitenda kupeta lakini malobi gangu ngagiipeti.” ");
INSERT INTO mgv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ngamundu jojumanyiki lisoba wala lisaa, hata atumi bu kunani kwaka Sapanga wala Mwana, ila pee Atati kajika. ");
INSERT INTO mgv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngati ekwabii mu masoba gaka Noa, ndi ekwibiya ejwihika Mwana waka Mundu. ");
INSERT INTO mgv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndaba masoba haga kabula jukutwele masi punndema bandu akubika akakula na kunywa, atogulika nukutola aka mbomba, mbaka lisoba Noa pajajingala munhwatu nkolongu gobugukema safina. ");
INSERT INTO mgv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bombi ngasebamanyiki siipitila kii mbaka masi pagatwelila punndema nakajola boti. Hela ndi ekwibiya pajihika Mwana waka Mundu. ");
INSERT INTO mgv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Masoba gegala bandu abeli biibiya ku lituhi, jumu biitenda kunzuku najongi biitenda kundeka. ");
INSERT INTO mgv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aka nyongo abeli biibiya apola kilebi, jumu biitenda kunzuku na jongi biitenda kundeka. ");
INSERT INTO mgv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndienu, ntama mihu ndaba ngasemmanyiki lisoba boo pajwihika Bambu winu. ");
INSERT INTO mgv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lakini nkombuka lijambu lende, ngati mwana nyumba ejwakamanyiki lisoba mwii pajihika, jakabiya jutemi mihu, wala ngajikijilei nyumba jaki akonyula. ");
INSERT INTO mgv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ahelahe nanamu mliandia ndaba Mwana waka Mundu juihika mulisaa langa kulimanya mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu jaendaliya kupwaaga, “Boo, ntumisi jwaa jojwiihobalika na jwana malangu? Ndi ntumisi jola bambu waki joambeka jwaajemaliya atumisi bangi mu nyumba jaki na kaapeke posu jaki mu masoba gake. ");
INSERT INTO mgv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mbanga mtumisi jola jojuwe bambu waki pajihika ankolila jakahenga hela. ");
INSERT INTO mgv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Numpwagi sakaka, bambu hoju ammbeka ntumisi hoju jujemaliya hindu yaki yoti. ");
INSERT INTO mgv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lakini ana ntumisi hoju juliya najilipwaji mweni mmwoju waki, ‘Bambu wango juseliwa kuhika.’ ");
INSERT INTO mgv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ndipala jiitumbuliya kwaalapu atumisi ajaki, nukutumbuli kula na kuywa pamu na alepi. ");
INSERT INTO mgv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bambu waki jwihika lisoba langa kulihobale ni lisaa langa kulimanya. ");
INSERT INTO mgv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ndienu andapula liyaa ntumisi wehoju nukumbeka mulikundi la bandu babilikopake ba amboni, hoku kwiibiya kilelu nukupola minu. ");
INSERT INTO mgv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Masoba ge haga, Ukolongu ukunani kwaka Sapanga gulengana na aka kamwali komi babajukua taa yabu, nukujenda kunzopa bambu ndoa. ");
INSERT INTO mgv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aka mbomba nhwanu kati jabu babi ang'ang'a na aka kamwali nhwanu bangi babii bana malangu. ");
INSERT INTO mgv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aka kamwali ang'ang'a bala bajukua taa yabu, lakini ngasebatogwi mahuta. ");
INSERT INTO mgv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lakini aka kamwali bana malangu bala bajukua lisupa lelibii na mahuta pamu na taa yabu. ");
INSERT INTO mgv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bambu ndoa jwaseliwi kuhika, henu aka kamwali bala boka batenda kupotoka nulugonu, nukugone. ");
INSERT INTO mgv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pamaiku kwabiya na keleli, ‘Nzumukaniya, bambu ndoa jutenda kuhika!’ Mpitaniya kunza mukunzopaje. ");
INSERT INTO mgv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aka kamwali bala bajumukaniya, bapambakiya taa yabo. ");
INSERT INTO mgv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aka kamwali ang'ang'a bala baapwagila aka kamwali bana malangu bala, ‘Mtuponguliya mahuta ginu kidogo ndaba taa hitu itenda kususuka.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lakini aka kamwali bana malangu bala bapwaga, ‘Ngagututosi twabeti na mwanganya! Nambanga nzenda kwa bandu baalombesa mahuta mwakalombaje!’ ");
INSERT INTO mgv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ndienu aka kamwali ang'ang'a bala pabajenda kulomba mahuta, bambu ndoa jatenda kuhika, aka kamwali bababi ajiandii bala, bajingala pamu najombi mu nyumba ja tipati ga ndoa, nu nndyangu batenda kuupunga. ");
INSERT INTO mgv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Monikatae aka kamwali ang'ang'a bala batenda kuhika, bakema, ‘Bambo, bambo, tuoguliya nndyango!’ ");
INSERT INTO mgv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lakini jombi jajibua, ‘Numpwagi sakaka, ngasenummanyi mwanganya.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ndipala Yesu jwaapwagila, “Ntama mihu heno, ndaba ngasemmanyi lisoba wala lisaa Mwana waka Mundu pajihika.” ");
INSERT INTO mgv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ahelahe Ukolongu ukunani kwaka Sapanga gulengana na mundu jojupiti kutali, nakakema atumisi baki nakapeke hindu yaki ajemalya. ");
INSERT INTO mgv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ampekia kila jumu kulengana nu uwesu waki, jumu mipuku nhwanu wa mangengalema gu lupija, najongi mipuku mibeli na jongi mpuku gumu, namweni jajenda kutali. ");
INSERT INTO mgv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Joampekia mipuku nhwanu jola jahengila lihengu mangengalema ju lupija lola najapata mipuku jengi nhwanu ja mangengalema ju lupija. ");
INSERT INTO mgv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Joampekiya mipuku mibeli ja mangengalema ju lupija jola najombi jahengila lihengu nukupata mipuku jengi mibeli ja mangengalema ju lupija. ");
INSERT INTO mgv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakini joampekia mpuku ulupija gumu jola, jajenda kuemba libomba pai nukuhiya mpuku ulupija lwaka bambu waki.” ");
INSERT INTO mgv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Egapeta masoba gingi bambu jola jatenda kukelabuka, jatumbuliya kubalanga lupija pamu nabu. ");
INSERT INTO mgv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ntumisi jojajopiki mipuku jamangalema ju lupija nhwanu jahika nukuleta mipuku jengi unhwano. Japwaaga, ‘Bambu wambeki mipuku nhwanu ju lupija mbatiki mipuku jengi nhwanu.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bambu waki apwagila, ‘Gutei sapi ngamaa, guntumisi wa amboni na woguhobaleka, guhobaliki kwa hindu hisoku, nagupekiya kujemale mali gingi ngani. Hika gutoguliya pamu na bambu waku.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ntumisi jwana mipuku mibeli ju lupija jahika nukupwaga, ‘Bambu gwambeki mipuku ju lupija mibeli. Nane mbatiki mipuku jengi mibeli ju lupija.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bambu waki apwagila, ‘Gutei sapi ngamaa, guntumisi wa amboni na weguhobaleka, guhobaliki kwa hindu hisoku nane nagupekia gujemaliya mali gingi ngani. Hika gutoguliya pamu na bambu wako.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ndienu jahika ntumisi jojajopa mpuku gumu gu lupija jahika nukupwaga, ‘Bambu nugumanyi weapa wa mundu mbaja, guhusa panga kupanda nu kukusanya panga kukweta imbejo. ");
INSERT INTO mgv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Najogopa, najenda kuhiya mpuku ulupija lwaku pai jilibomba nukuyelale. Jukua henu mpuku ulupija lwaku.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bambu waki ampwagila, ‘Weapa guntumisi uliya nu umpipu! Gumanyi nepani nihusa panga kupanda, kabee ngusanya panga kukweta namweti. ");
INSERT INTO mgv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Henu wakabeka mpuku u lupija lwaku kwa bandu baabeka lupija ili panakakelubuka nakajukua lupija lwangu na longi lolujonzukiki. ");
INSERT INTO mgv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ndienu munnzopa mipuku ju lupija lwe holu mukumpekia jwana mipuku ju lupija komi jela. ");
INSERT INTO mgv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ndaba jojubi na sindu buntenda kunzonzukela. Lakini jwanga na sindu hata sela sejubinaku nasombi biitenda kunzopa. ");
INSERT INTO mgv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ntumisi wehoju jwangakujonzuke lupija! Mundekala kunza kulwii! Hoku kwiibiya ni kilelu nu kupola minu.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana waka Mundu pajihika mu ukolongu waki pamu na atumi baki bu kunani kwaka Sapanga, papuje jiitama panani ji kiteu saki su ubambu sekibii nu ukolongu. ");
INSERT INTO mgv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bandu boti bupundema biiketangana palongi jaki, najombi jwaabaganisa bandu ngati nndimi ejagabaganisa makondoo ni imbui. ");
INSERT INTO mgv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jaabeka makondoo ndi bandu baamboni upandi waki uku malele na imbui ndi bandu baliya upandi wa mangega. ");
INSERT INTO mgv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ndienu Bambu nkolongu jaapwagila baabii upandi ukumalele bala, ‘Nhikannya mwanganya mompengaliwi na Atati bango, nnzopa ukolongu gobuguhandi ndaba jinu tumbuka kubombeka nndema. ");
INSERT INTO mgv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ndaba nabii ninzala mwanganya mwambekia posu, nabii nanywita mwanganya mwambekia masi, nakabii nungeni mwanganya mwandenda kunyopa kunyumba jii, ");
INSERT INTO mgv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ngase nabii niingobu mwanganya mwambekiya ingobu, nabii nungonzu mwanganya mwahika kuninga, nabii kukipungu mwanganya mwahika kuninga.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ndienu bandu ba mboni bundalukiya nkolongu, ‘Bambo boo, tugubona lii gubii ni inzala natwepani tugupekya posu au wabii lii na nywita na twepani tukupekya masi gakunywa? ");
INSERT INTO mgv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Boo lile tugubona gungeni natwepani twatenda kugujopa au ngasewabii ni ingobu natwepani twatenda kuguwatika? ");
INSERT INTO mgv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Boo lii wabii gungonzu natwepani twahika kugulinga au lii wabii kukipungu Natwepani twahika kugulinga?’ ");
INSERT INTO mgv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nkolongu japwaga, Numpwaji sakaka, kila sindu semuntendila jumu jwa alongu bango asoku, nndendila nepani.” ");
INSERT INTO mgv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ndipala jaapwagila bababi upandi waki ukumangega, ‘Mmbokaniya palongi jangu mwanganya mwembiii na yambamba! Nnzendananiya kumwotu wanga kususuka wa yaka petapeta go baandali Lijobi na atumi baki. ");
INSERT INTO mgv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndaba nabii ni inzala ngasemwambeki posu, nabii na nywita ngasemwambeki masi gakunywa. ");
INSERT INTO mgv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nabii nungeni ngasemwanyopiki kunyumba jii, ngasenabii niingobu ngase mwambeki ingobu nabii nungonzu, kabee nabii numpugwa mwanganya ngase mwahikiki kuninga.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ndienu nabombi bapwaga, ‘Bambu, lii tugubona gubi ni inzala na nywita, wabii gungeni au ngase wabii ni ingobu wakabii gungonzu au gumpugwa natwepani ngase tugujangatilee?’ ");
INSERT INTO mgv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bambu nkolongu jwajibua, ‘Numpwagi sakaka, kila pankanika kunzangati jumu jwanga kumanyikana, nkanika kunyangati nepani.’ ");
INSERT INTO mgv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndienu bamba biijingala mwa mang'aliku gukutemuliwa ga yaka petapeta, lakini bandu baamboni haba bijenda kuwomi wa masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu pajajomula kupwaga haga goti, jaapwagila banafunzi baki, ");
INSERT INTO mgv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mmanyiki egipeta masoba mabeli gibiya tipati ja Pasaka, Mwana waka Mundu bankamula ili bumbambaliya pu nsalaba.” ");
INSERT INTO mgv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Masoba ge haga agolu akolongu na aseja ba bandu baketangana pamu pa sengu jaka Kayafa, jojabii nngolu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bataputa indela juu ujanza juku nkamu Yesu nunkukoma. ");
INSERT INTO mgv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lakini baamua lijambu lee liihengeka lisoba la tipati ja Pasaka, ili bandu biileta puju. ");
INSERT INTO mgv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu pajwabii ku Betania, mu nyumba jaka Simoni joandamisa ugonzu ukuleleka, ");
INSERT INTO mgv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mmbomba jumu anhikila koni jutogwi lisupa lealenganisi kwi lilibu lebilikema alabasita lelatweli mahuta gaganungali gabei ngolongu, anzitila Yesu kumutu pajabiya jukula posu. ");
INSERT INTO mgv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Banafunzi baki ebabona hela basuki nukupwaga, “Ndaba ja kii kuhoa mahuta hela? ");
INSERT INTO mgv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mahuta ge haga bakalombisa kwa bei ngolongo, lupija lwe bakaapekia aka kapuku.” ");
INSERT INTO mgv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu jagamanyiki mawasu gabu jaapwajila, “Ndaba jakii munsumbu nyongo jonzo? Jombi juhengiki lijambu la amboni ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aka kapuku mmbinaku masoba goha lakini ngamwikubi na nepani masoba goha. ");
INSERT INTO mgv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nyongo ajo pajanyegi mahuta gaganungi jabiya juandaa nhyega jango ndaba jukujitaga. ");
INSERT INTO mgv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Numpwagi sakaka, pokapi pundema pabiilandila Lijambu la Amboni, sejuhengiki nyongo jonzo biilandila sukunkomboka jombi.” ");
INSERT INTO mgv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndienu jumu ja banafunzi komi na abeli jobukema Yuda Isikalioti, jajenda kwaka agolu akolongu, ");
INSERT INTO mgv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jaapwagila, “Mwimbekia sindu boo nanung'anambwiki Yesu?” Bumbalangiya mangengalema makomi matatu gu lupija nukumpeke. ");
INSERT INTO mgv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tumbuka pala, Yuda jabiya jutaputa mbekenyu jukunng'anambuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lisoba lukutumbuli la tipati ga mabumunda ganga kujege amila, banafunzi bunzendila Yesu nukupwagi, “Boo gupala tukuguhandaliya kwako posu ja Pasaka?” ");
INSERT INTO mgv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jombi japwaga, “Nnzendaniya ku musi kwaka mundu jumu mwanalomi mukupwagila, ‘Mbola jupwaga masoba gangu gahegalii. Nepani na banafunzi bangu twikula posu ja Pasaka mu nyumba jaku.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ndienu banafunzi bahenga ngati Yesu ejaapwagila, na bombi baandia posu jakula Pasaka. ");
INSERT INTO mgv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ekwahika pakamii, Yesu jakula posu pamu na banafunzi baki komi na abeli. ");
INSERT INTO mgv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pababia bakakula, Yesu japwaaga, “Numpwagi sakaka jumu wi jwiindenda kung'anambuka.” ");
INSERT INTO mgv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Banafunzi baki gwaabiniki mwoju ngamaa, kila mundu jatumbuliya kundaluki Yesu, “Boo, Bambu, nepane lena?” ");
INSERT INTO mgv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu jaapwajila, “Jojutobe libumunda laki pamu na nepani mmbakuli ndi jojing'anumbuka. ");
INSERT INTO mgv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana waka Mundu jujenda kuwa, ngati eahandiki mu Maandiku gaka Sapanga. Lakini musijikiboni mundu joang'anumbuka Mwana waka Mundu! Kwiibiya mbanga mundu hoju ejakasindiki kusaliwa.” ");
INSERT INTO mgv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ndi jojapala kunng'anumbuka andalukiya, “Mbola, boo, nepane?” Yesu jajibua, “Weapa gupwajiki.” ");
INSERT INTO mgv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pababiya bakakula, Yesu jwajukua libumunda, ansengula Sapanga, jamega, jaapekia banafunzi baki japwaga, “Nnzukua mkula, jenze nhyega jango.” ");
INSERT INTO mgv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ndipala jajukua nnzipuli wa divai ja zabibu jwasengula, jaapekia koni jupwaga, “Nkunywa mwaboa. ");
INSERT INTO mgv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gongo mwai wango wa malagano gogujitika ndaba jakulekake bandu bingi ili alekakiwa mahakau. ");
INSERT INTO mgv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Numpwaji ngangunywi kabee divai ja zabibu mbaka lisoba paniikunywa divai inyai pamu nu mbanganya mu Ukolongu wa Atati bango.” ");
INSERT INTO mgv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ebajomula kujemba nhwambu gu ulumbi, jaboka jajenda ku Kitombi si Mizeituni. ");
INSERT INTO mgv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ndienu Yesu jaapwajila, “Ikilu ja lelenu, kila mundu musijundenda kundila nukuneka ngati Maandiku gaka Sapanga egapwaga, ‘Nandapula nndimi, nu nsambi wa makondoo wiitenda kupesangana.’ ");
INSERT INTO mgv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakini eniiyoka, nandonguliya kujenda ku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petili apwagila Yesu, “Hata ngati boka baguleka weapa, nepani nganuguleki.” ");
INSERT INTO mgv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu ampwagila, “Nugupwagi sakaka, ikilu jenze kabula ji likongobi kubeka wingana mala pa tato.” ");
INSERT INTO mgv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petili apwagila, “Nganugukane hata nakupalika kuwa pamu naweapa.” Na banafunzi bangi boti bapwaga ahelahela. ");
INSERT INTO mgv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ndipala Yesu jajenda pamu na banafunzi baki pandu pabapakema Getisemani, jaapwajila, “Ntamaniya pamba nane nyenda palapa kundoba Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Anzukua Petili pamu na bana abeli baka Zebedayu bala, jatumbuliya kuhangajika nukumbina mwoju. ");
INSERT INTO mgv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Papuje japwaaga, “Mwoju wangu gubi nuusungu ngamaa gukuegale kuwa. Ntamaniya kelukelu pamu nanepane.” ");
INSERT INTO mgv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jajenda palongi kidogu, jahabuka ukupama nukundoba Sapanga, “Atati bangu, ana kuwesikana, mokia nzipuli ukung'alika gongo kuhuma kwango. Lakini nga ngati embala nepani ila ngati egupala weapa.” ");
INSERT INTO mgv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ndipala ejwaakelubukiya banafunzi baki, jwaaketaniya agoni. Andalukiya Petili, “Boo ngasemwawesiki kukeluki pamu nanepani hata lisaa limo? ");
INSERT INTO mgv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ntama na nndoba ili mwijingi mu milengu. Loho jipala lakini nhyega ngase jibii namakili.” ");
INSERT INTO mgv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu jajenda kabee, jaloba, “Atati bangu, ana kuwesakini nnzipuli gukung'alika gongo gumbeta kutali bila kunywa, ila gagupala weapa gahengika.” ");
INSERT INTO mgv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pajakelubuka kabee, jaakolila agoni ndaba mihu gabu gabi nulugonu. ");
INSERT INTO mgv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu jaaleka, jajenda kabee kuloba mala ja tatu, jaloba kabee ahelahela. ");
INSERT INTO mgv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ndienu jaajendila banafunzi nakapwaji, “Boo, mwakona nngoni nukupomulela? Nndinga muda guhikiki na Mwana waka Mundu bumpeleka kwa bandu bana mahakau. ");
INSERT INTO mgv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nnzemaniya, tumbokaniya. Nndingaliya, juhika jola jojing'alumbuka.” ");
INSERT INTO mgv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu pajabiya jakalongila nabu, Yuda jumu ja banafunzi komi na abeli bala, jahika na bandu bingi baatogwi mapanga na ibonga babube babiya ahikiki sukutumwa na agolu akolongu na aseja babandu. ");
INSERT INTO mgv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda jabiya jaapeki nginyuli jukupwaga, “Mundu jonukukumbatiya jola ndi jombi, mukunkamula.” ");
INSERT INTO mgv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda anzendila Yesu nukupwagi, “Jambu otii Mbola!” Ndi jwatenda kukumbati. ");
INSERT INTO mgv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu jaapwajila, “Nkose, henga seguhikiki kuhenga.” Papuje bandu bala bunhegaliya Yesu nukunkamu nukumbeka pai juulonda wabu. ");
INSERT INTO mgv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jumu ja bandu bababi pamu na Yesu bala jahopula upanga waki andapula ntumisi wa agolu akolongu, nukunseku likutu. ");
INSERT INTO mgv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu ampwagila, “Kelubua upanga waku munhaku waki. Ndaba jokapi jojukoma kupete upanga jiikuwa nuupanga. ");
INSERT INTO mgv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Uhambusi ngasenhwesa kwaaloba Atati bangu anetila hikundi ya alonda komi na abele ba atumisi bu kunani ahika kunyangatila? ");
INSERT INTO mgv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lakini giitimia boo Maandiku gaka Sapanga ganga gagapwaga majambu ge haga kupalika gapitila?” ");
INSERT INTO mgv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Apalapa Yesu jugupwajila nsambi wa bandu bala, “Boo, nhikiki kungamu kwa mapanga niibonga nepani ngati lee jojuhalabana malagalaki gaka Sapanga? Kila lisoba nabii pamu numbanganya pa Nyumba jaka Sapanga nakabolisa, ngasemwangamwi. ");
INSERT INTO mgv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lakini ganga gapiti ili gaandiki alota baka Sapanga gatimia.” Ndipala banafunzi baki bundeka nukutila. ");
INSERT INTO mgv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Babunkamula Yesu bala bumpelika kunyumba jaka Kayafa, nngolu nkolongu, kobaketangini abola bamalagalaki na aka kilongosi. ");
INSERT INTO mgv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petili ampwata sukutali mbaka paua jaka Nngolu nkolongu. Jajingala nkati jatama pai na alonda ili juwesa kulinga gagiibiya. ");
INSERT INTO mgv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Agolu akolongu na sengu joka bataputa malobi gi isoli ili bunkoma Yesu, ");
INSERT INTO mgv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","lakini ngasebapata malobi gokapai, hata ngati bahikiki bandu bingi babapwaga malobi giisoli. Ndipala pamwisu we baika bandu abeli, ");
INSERT INTO mgv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bapwaaga, “Mundu jonzo japwaga, ‘Nhwesa kubombo Nyumba jaka Sapanga nukusenga kabee kwa masoba matato.’ ” ");
INSERT INTO mgv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nngolu nkolongu jajema nukundaluki Yesu, “Boo ngasegubi nu sukupwaga? Boo bandu aba bugutakii ndaba jakikee?” ");
INSERT INTO mgv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lakini Yesu ngasejapwajiki sindo. Nngolu nkolongu ampwagila, “Nugulapisa kwaka Sapanga jojubi mwomi. Utupwajila anaweapa ndi wa Kilisitu Nkombosi Mwana waka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu japwaaga, “Weapa gupwaga. Lakini numpwagi mwaboti tumbuka sajenu nukuendalee mwambona Mwana waka Mundu jutemi upandi wa malele waka Sapanga jwana makili, jwihika panani ja mahundi gukunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pajajowana Nngolu nkolongu malobi haga jajendula ingobu jaki nukupwaga, “Jutenda kutondoka. Ngasetupala mundu jongi juhika kuntakila kabee? Mwabee nzowini ejutondwiki. ");
INSERT INTO mgv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Boo mwanganya mmbona bole?” Bombi bajibua, “Jubii na makosa kupalika jukomikaje.” ");
INSERT INTO mgv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndipala buhunila imata kumihu, nukundapu. Bangi babiya bundapu iganza ");
INSERT INTO mgv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","koni bakapwaga, “Wehapa gu Kilisitu Nkombosi! Lotila nya jojugulapwi?” ");
INSERT INTO mgv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petili jabii nkati ja hua. Ntumisi jumu mmbomba anzendila nukumpwagi, “Na wehapa wabii pamu na Yesu mwenei ku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakini Petili jakana palongi jabu jwapwaga, “Ngasemanyiki segumpwaga.” ");
INSERT INTO mgv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ndienu pajapita kunza, kola ntumisi jongi mmbomba ambona, jaapwagila bandu boti bababi pala, “Mundu jonzo jabii pamu na Yesu juku Nazaleti.” ");
INSERT INTO mgv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petili jakana kabee kukulapa, “Ngasenummanyi mundu ajo.” ");
INSERT INTO mgv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Monikatae bandu babajemiki pala bunzendila Petili bumpwagila, “Sakaka weapa ndi jumu wabu, ndaba hata kulonge kwaku kubonikana wehapa guhumi ku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndienu petili jatumbuliya kulilobe yaambamba nukulapa sukupwaga, “Ngasenumanyi mundu ajo!” Apalapa likongobi latenda kubeka. ");
INSERT INTO mgv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petili jakombuka malobi gajwapwaga Yesu, “Kabula likongobi ngaselibekiki wingana mala pa tato.” Ndienu japita kunza koni julela ku usungu. ");
INSERT INTO mgv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pulukela aka agolu akolongu boti na aka aseja ba bandu batenda kulongalane baamua kunkoma Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bunkonga, bunzukua nukumpeleka kwaka Pilatu, jojabi kilongosi ju pundema jojahaguliwi nu nkolongu juku Loma. ");
INSERT INTO mgv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda, joang'anambuka Yesu, pajwabona Yesu atenda kuntemu, gumbina mwoju, jwaakelabukia agolu akolongu bala na aseja, mangengalema makomi matatu gulupija yela. ");
INSERT INTO mgv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jwaapwagila, “Ndei mahakau ndaba nung'anambwiki mundu jwanga mahakau ili jukomika.” Lakini bombi bapwaga, “Kwali wamwete, twepani ngasetuhusika.” ");
INSERT INTO mgv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Henu Yuda jwalekala pee lupija lola pa Nyumba jaka Sapanga, ndienu japita kunza nukujenda kulikonge. ");
INSERT INTO mgv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Agolu akolongu bajukua lupija lola, nukupwaga, “Lupija alo ngaselupalika kulubeka pi kikoku sa Nyumba jaka Sapanga, ndaba londo lupija lobapia ndaba jukukome.” ");
INSERT INTO mgv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ndi bajetangania lupija lola kulombe litui la bandu baabombe ibega pabia pandu pukutagi bandu ageni. ");
INSERT INTO mgv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndienu mbaki lelenu litui lela bilikema, “Litui lelalombika kupete lupija lukukome.” ");
INSERT INTO mgv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndi gatimia gajwapwaga mlota waka Sapanga Yelemia pajwapwaga, “Bajukua mangengalema makomi matatu gulupija yebajetangana bandu buku Izilaeli kundepe, ");
INSERT INTO mgv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","balombila litui la bandu babomba ibega, ngati Bambu hejanagalakiya nepani.” ");
INSERT INTO mgv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu jajemiki palongi juku nkolongu ju Loma. Ndi Nkolongu hoju anndalukia, “Boo, weapa lee ndi Bambu Nkolongu jwa Ayaude?” Yesu japwaga, “Upwagiki weapa.” ");
INSERT INTO mgv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lakini agolu akolongu na aseja pababia atenda kuntaki, ngasejwajibwiki lilobe. ");
INSERT INTO mgv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ndienu pilatu andalukia Yesu, “Boo, ngasegujogwana matakilu gabugutakali weapa?” ");
INSERT INTO mgv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lakini Yesu ngase jwajibwiki hata lilobi limu, nkolongu juku Loma jola jwasangi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kila lisoba la tipati ja Pasaka, nkolongu juku Loma jayobali kunhuhogule mpungwa jumu bandu babumpai. ");
INSERT INTO mgv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Masoba gala jwabi mpungwa jumu jojwamanyikini ngamaa, liina laki Balaba. ");
INSERT INTO mgv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndi bandu hebakusanyiki pamu, Pilatu jwaalalukia, “Mpala nunhogulia nyane kati ja bandu abeli haba? Boo, nundekakiya Balaba au Yesu jobunkema Kilisituje?” ");
INSERT INTO mgv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatu jwapwaga hela ndaba jwamanyiki bundeta Yesu kwaki ndaba bumbonila wipu. ");
INSERT INTO mgv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatu pajwabia jutemi pikiteu sukutemu, nhwanu waki ampelakia lilobi, “Wiitenda sokapi kwaka mundu ajo jwanga mahakau, ndaba lelenu ikilu ng'aliki ngamaa nndotu ndaba jaki.” ");
INSERT INTO mgv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakini agolu akolongu naaka aseja baakolua bandu bundoba Pilatu bunndekakia Balaba na Yesu jukuwa. ");
INSERT INTO mgv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatu jwaalalukia kabee, “Jwaa kati ja baamba jompala nundekakiyaje?” Bajibua, “Balaba!” ");
INSERT INTO mgv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu jwaalalukia, “Henu nuntenda boo Yesu jobunkema Kilisitu?” Boti bapwaga, “Umbambaliaje pu nsalaba!” ");
INSERT INTO mgv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatu jwaalalukia, “Ndaba ja kike? Jutei ubaja bole?” Bombi baendalia kujamali kwa sauti koni bakapwaga, “Umbambalia punsalaba!” ");
INSERT INTO mgv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatu hejwamanya ngajuwesi kutenda sokapi na puju japala kutumbuli, jwajukua masi, nukusamba maboku palongi ja bandu bala nukupwaga, “Nengasemii na mahakau kupete kuwa kwaka mundu ajo, namu kwali mwabee.” ");
INSERT INTO mgv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bandu boka bapwaga, “Mahakau ga kuwa kwaki gabiya panani jitu na panani ja bana bitu!” ");
INSERT INTO mgv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ndipala Pilatu andekakiya Balaba ndaba jabu jupita mukipungu, na jaapwagila bunndapula Yesu iboku nukumbambali pu nsalaba. ");
INSERT INTO mgv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ndienu alonda baka Pilatu bumpelika Yesu mu nyumba jaka Pilatu, nu nsambi wa alonda bunnyongulota Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bunhula ingobu yaki, bunhuwatika lingobu likeli lu ubambu. ");
INSERT INTO mgv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ndipala baloka kihilingu sa miha, nukunhwatika kumutu jaki, bumbekila kabee nndai mu kuboku kwaki kwa malele. Bapega magoti palongi jaki, bundongama bapwaaga, “Jambu oti Bambu nkolongu jwa Ayaudi!” ");
INSERT INTO mgv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bunhunila imata, buujukua nndai gola, bundapula nagu kumutu. ");
INSERT INTO mgv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pabajomula kundongama, bunhula kanzu ngeli jela nukunhwatika kabee ingobu yaki. Nukumpeleka kumbambali punsalaba. ");
INSERT INTO mgv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pababia atenda kujenda, baketangana na mundu jumu bunkema Simoni, mwenei juku Kilene, bunndasimisa kutoto nsalaba waka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pabahika pandu pabapakema Goligota maana jaki pandu pi Lihupa li Kimutu, ");
INSERT INTO mgv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bumpekia divai jeahangangini na sindu sekibaba, lakini Yesu pajwaonza jwakanaa kunywa. ");
INSERT INTO mgv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Batenda kumbambali pu nsalaba, nukubagana ingobu yaki sukugapege gudugudu. ");
INSERT INTO mgv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ndienu pala batama pai koni bukunndonda. ");
INSERT INTO mgv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani jaki babeka lilobi lelilangi ndaba jukutakiliwa kwaki: “Jonzo ndi Yesu Bambu Nkolongu jwa Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bii abeli nabombi baabambalia panani ju nsalaba pamu na Yesu, jumu upandi uku mangegi na gongi upandi uku malele. ");
INSERT INTO mgv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bandu bababia apeta pala, banyua imutu yabu koni bukundongama nukuntondoo bakapwaga, ");
INSERT INTO mgv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Oo! We si wapwaga wiibombula nyumba jaka Sapanga nukusenga masoba gatatu? Henu, uliokua wa mweti! Ana sakaka weapa wa mwana waka Sapanga huluka pu nsalaba hapa sajenu!” ");
INSERT INTO mgv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ahelahe agolu akolongu pamu na abola ba Malagalaki na aseja nabombi batenda kunndongama koni bakapwaga, ");
INSERT INTO mgv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Jwaakombula bangi, lakini jusindwa kulioko mweni! Ati jombi Bambu nkolongu jwa Ayahude! Henu julihulua pu nsalaba natwepani tunhobaliaje. ");
INSERT INTO mgv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jombi anhobalia Sapanga na jwapwaga jombi Mwana waka Sapanga. Ana Sapanga ampala jombi anhokuaje. ");
INSERT INTO mgv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","“Kabee bababi abambaliwi pu nsalaba pamu najombi batenda kuntondo.” ");
INSERT INTO mgv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tumbuka lisaa la sita mbaka lisaa la tisa, lwii lwijiyekalia ndema joti. ");
INSERT INTO mgv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hekwabia saa tisa lyobamutu Yesu jwalela sukujamali, “Eloi, Eloi Lama sabakitani?” Maana jaki, “Sapanga wangu, Sapanga wangu, ndaba jaki undei kuneka?” ");
INSERT INTO mgv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bandu bangi babajemiki pala bala pabajogwana bapwaga, “Ankema Elia.” ");
INSERT INTO mgv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Apalapa jumu wabu jwaboka imbelu nukujuku kipongu, nukukijingi mu divai jejibaba nukukikonga punndai nukuntondabake Yesu jukunywa. ");
INSERT INTO mgv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bangi bapwaaga, “Tunndolake hoti ana Elia juhika kugombo.” ");
INSERT INTO mgv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu jwalela kabee sukujamali kwa sauti ngolongu, ndienu na kuwa. ");
INSERT INTO mgv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Apalapa lipazia lu mu Nyumba jaka Sapanga lajenduka ipandi ibeli, toka kunani mbaka pai, ndema jatenda kubagaja malibu makolongu gatenda kusekuka, ");
INSERT INTO mgv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mmatenge gatenda kuhukuka na bandu bingi baka Sapanga babawi batenda kuyoka. ");
INSERT INTO mgv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nabombi bapita kunza ja matenge na Yesu pajayoka bajenda ku musi wa sapi uku Yelusalemu na bandu bingi baabweni. ");
INSERT INTO mgv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ndienu nkolongu jwaalonda jumu na bangi bababia pamu najombi bukundonda Yesu, pababona kililima sa ndema na majambu gagapitila gala, bajogupa ngamaa, bapwaga, “Sakaka jonzo jabii Mwana waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pandu je pala babii aka mbomba abeli bakalingalia sukutali. Haba ndi babumpwata Yesu kuhuma ku Galilaya ndi babuhudumia. ");
INSERT INTO mgv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jwabii Malia juku Magidala na Malia amabu baka Yakobu na Josepu na amabu baka bana baka Zebedayu. ");
INSERT INTO mgv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pakamihi jwahika mundu jumu mwana mali mwenei juku Alimatayo, liina laki Josepu. Najombi jwabia mbolee waka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Anzendila Pilatu nukuloba ampekia nhyega jaka Yesu. Ndienu Pilatu jwalagalakia bumpekya. ");
INSERT INTO mgv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josepu jwajukua nhyega jaka Yesu jela, jwiiyongalatia ingobu nhuu. ");
INSERT INTO mgv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Josepu jabeka nhyega jaka Yesu nkati jilitenge laki linyai lejwabi julisongiki mweni pililibu. Ndienu juliingalatiya lilibu likolongu palongi junndyangu ulitengee nu kuboka. ");
INSERT INTO mgv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia juku Magidala na Malia jongi jola babia atemi papu kulilingali litengee. ");
INSERT INTO mgv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kilabu jaki, labia lisoba lukuandaa Lisoba lu Kupomulela, Agolu akolongu na aka Afalisayu bunzendila Pilatu, ");
INSERT INTO mgv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bumpwagila, “Nkolongo, tukomboka jojulonge isoli jola pajabi mwomi jwapwaga ati, ‘Nagapetiki masoba matatu nitenda kuyoka.’ ");
INSERT INTO mgv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Enu gulagalakia litenge laki bililonda sapi mbaka lisoba la tatu ili banafunzi baki bihika kujiba nhyega jaki nakaapwaji bandu jutei kuyoka. Isoli heji jamwisu jibia jiliya ngani kupeta jejatumbulia.” ");
INSERT INTO mgv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu jwapwaga, “Alonda mmbii nabu, nzendania mwaka londa ngati henhwesa.” ");
INSERT INTO mgv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ndi bajenda, bililonda litenge, bilibeka halama panani ji lilibu lela nakaabeka alonda. ");
INSERT INTO mgv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Elapeta Lisoba lu Kupomulela, lisoba la juma pili pulukela ngani, Malia juku Magidala na Malia jongi jola bajenda kulinga litenge lela. ");
INSERT INTO mgv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Apalapa sapitila kililima kikolongu pundema, ndaba ntumi jukunani waka Bambu jwatenda kuhuluka kuhuma kunani, juliingalitia lilibu lela pulutengu nukulitami panani. ");
INSERT INTO mgv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ntumi we jola jwang'ala ngati unang'anu ukitobi ni ingobu yaki yabia ihuu kupukupu. ");
INSERT INTO mgv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Alonda bilitenge batenda kubagaja sulujogopu lukolongu, mbaka babia ngati atei kua. ");
INSERT INTO mgv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lakini ntumi jukunani jola jwaapwagila aka mbomba bala, “Mwee mwijogopa!” Japaga, “Nepani manyiki muntaputa Yesu jobumbambaliya pu nsalaba jola. ");
INSERT INTO mgv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngasejubi pane, juyokiki ngati hejupwagike. Nhika nndingalia pandu pajwabii jugonile. ");
INSERT INTO mgv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Henu, nzendania nyata mwakaapwagila banafunzi baki, ‘Yesu juyokiki kuhuma kwa bandu baa wile, na henu junndonguli ku Galilaya, mwaambona hakolakola.’ Nkombuka senumpwaji.” ");
INSERT INTO mgv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aka mbomba bala baboka ku litenge kola koni ajogopa ngamaa na mioju jabu jitweli ndogulela nukujombatake kwaapwagi banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Apalapa, Yesu jwaketangana nabu nakwaapwagi, “Jambu oti.” Aka mbomba bala bunzendila, nukukamu magolu gaki nukungungamali. ");
INSERT INTO mgv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ndienu Yesu jwaapwagila, “Mwiijogopa! Nzendania mwakaapwagila alongu bangu ajendania ku Galilaya nakola biimona nepani.” ");
INSERT INTO mgv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aka mbomba bala pababia atenda kuyetuana, aka alonda baakumu bilitenge bajenda ku musi kwaalandi agolu akolongu goti gagapitii kulitenge. ");
INSERT INTO mgv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ndienu, agolu akolongu baketangana pamu na aseja, ebajomula kulongalane bajetangania, baapekia alonda bilitenge bala lupija lwingi, ");
INSERT INTO mgv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ndipala bapwaga, “Mwanganya mwiipwaga ana, ‘Banafunzi baki bahika kunziba ikilu, twepani twabii tugoni.’ ");
INSERT INTO mgv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ana kilongosi ju ndema jumanyiki lijambu heli, twepani twiitenda kunkolo jujetakia, namwanganya ngamwikubi namang'aliku.” ");
INSERT INTO mgv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Alonda bala bajukua lupija lola, batenda ngati hebaapwagila. Nilijambu heli laheni kwaka Ayaudi mbaka lelenu. ");
INSERT INTO mgv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Banafunzi komi na jumu bala bajenda ku Galilaya kukitombi sejwaalagalakia Yesu ajenda. ");
INSERT INTO mgv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pabumbona Yesu batenda kungungamali, lakini bangi babu babiya ngaseanhobale. ");
INSERT INTO mgv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu jwahika pambipi jabu na kwaapwagi, “Ambekii uwesu woka kunani nu pundema. ");
INSERT INTO mgv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nzendania kwa bandu boti bupundema mwakaatenda bandu boti abia banafunzi bangu, mwakaabatisa kwiliina la Atati na laka Mwana na laka Loho jaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mwaabola kukamu malagalaki goti ganundagalaki. Nanepani mi pamu na mwanganya masoba goha mbaka mwisu gu nndema.”");
INSERT INTO mgv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ganga Majambu ga Sapi gaka Yesu Kilisitu, Mwana waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gatumbuka ngati ejaandika Isaya jojabii Mlota waka Sapanga, “Sapanga japwaaga, ‘Nuntuma mtumisi wango jugulongulya, Najombi jugulenganakiya indela jaku.’ ");
INSERT INTO mgv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu jumu jajoanika jujamalii kwa sauti ngolongu pulukoba jakapwaga, ‘Nndenganikya indela jaka Bambo, nnyoosha mpeta waki!’ ” ");
INSERT INTO mgv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana Mmbatisa jutamika pulukoba, jalandila bandu na kabatisa. Jaapwagila, “Nkotuka mahakau gino nu kubatiswa na Sapanga janndekakya mahakau gino.” ");
INSERT INTO mgv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bandu bingi kuhuma kundema uku Yudea na musi uku Yelusalemu bajenda kunzowane Yohana. Bapwaga mahakau gabu, najombi jaabatisa ku losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana jaweti ingobu yebalenganaki kwa mangoma gi kinyama sebikikema ngamia, nu nkanda wa ngosi mukibunu saki. Na posu jaki gabia mapai na busi. ");
INSERT INTO mgv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana jalandila bandu, “Jwiika mundu ehenu munyuma jangu nepani jo jubii na makili kupeta ne, jojuwee ne ngasembalika hataa kujinama kukonga ng'oji ya makobasi gaki. ");
INSERT INTO mgv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne numbatisa kwa masi, lakini jombi jammbatisa kwa Loho jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Masoba ge gala, Yesu jwahika kuhuma ku Nazaleti ku musi uku Galilaya, nu kubatiswa na Yohana ku losi luku Yoludani. ");
INSERT INTO mgv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu ejapita pe mmasi, jukubona kunani kwa mahundi kuhogwiki na Loho jaka Sapanga junhulukya panani jaki ngati ngunda. ");
INSERT INTO mgv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na sauti jaka Sapanga jajoanika kuhuma kunani kwaka Sapanga jakapwaga, “Wenga wa Mwanango jonugupai, we gunenganile.” ");
INSERT INTO mgv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Apalapala Loho jaka Sapanga junndongua Yesu kujenda kulukoba, ");
INSERT INTO mgv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jatama kola masoba makomi nsesi koni julengwa ni Lijobi. Jatama kola ni inyama imwikioli lakini atumisi bu kunani kwaka Sapanga bahika kunzangatii Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana pajabii mkipungu, Yesu jajenda ku Galilaya kaalandi bandu Majambu ga Sapi gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Japwaaga, “Masoba gahikiki, nu ukolongu waka Sapanga guegali! Nndekakya mahakau nukulihobalee Lijambu la Amboni!” ");
INSERT INTO mgv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu pajapeta mulutengu ju nhanga uku Galilaya jabona aloi habeli. Simoni nu nndongu mundu Andilea, bakalopula homba kwi ilepa. ");
INSERT INTO mgv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu jaapwagila, “Nnyengalya ne, nane nantenda mmbia mwaaleta bandu kwangu ngati emwabii nndobo homba.” ");
INSERT INTO mgv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Apalapa biileka ilepa yabu nu kunzengalee Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ejahika kulongi kidogu jwabona aka Yakobu na Yohana, bana baka Zebedayu. Nabombi babii nkati ju nhwatu wabu bakalenganakya ilepa yabu. ");
INSERT INTO mgv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pajaabona tu jatenda kakema, nabombi baaleka ahengo Azebedayu mu nhwatu pamu na babaahenge lihengu, nu kunzengalee Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na banafunzi baki bahika kumusi uku Kapelinaumu. Palahika Lisoba lu Kupomulela, Yesu jajingala mu nyumba jukuketangane Ayaudi, nukutumbulii kwaabola bandu malobi gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bandu boa babuzoanya basangia mabola gaki, ndaba ngasejaabola ngati abola babu ba malagalaki, jaabola ngati mundu jojubii nu uwesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Muda gogo, mundu jumu jojabii munyumba jukuketangane Ayaudi, jojabia juyokalanii ilombu jatumbuka kujamalii. ");
INSERT INTO mgv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Japwaaga, “Gubi naki na twenga, Weapa wa Yesu uku Nazaleti? Boo! Guhikiki kutukoma? Twe tugumanyi, weapa wa Waasaapi weguhumiki kwaka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu jiilakaliya ilombu ye yela koni jakapwaga, “Tama kinunu! Gumpita mundu we hojo!” ");
INSERT INTO mgv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndipala kilombu se sela sunyuanyua kwa makili, mundu we jola jajamalya, nukumpita. ");
INSERT INTO mgv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bandu boa batenda kusangaa, koni bakalaluana, “Boo ganiaga ge majambu bolee? Ganiaga lee mabole manyae? Mundu ajo jubii nu uwesu hata ukulakalii ilombu, na yombi nukunzoane!” ");
INSERT INTO mgv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ndipala, majambu gaka Yesu gaeniya nyatanyata ku Galilaya kwoka. ");
INSERT INTO mgv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na banafunzi baki, baboka mu nyumba jukuketangane Ayaudi, bajenda kunyumba jaka Simoni na Andilea na Yakobu na Yohana bajendanya pamu nabombi. ");
INSERT INTO mgv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ndienu, akoanu baka Simoni babii agoni pikitanda alwala ngamaa. Ejahika pala Yesu bumpwagila lijambu laka nyongoo we hoju. ");
INSERT INTO mgv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ndienu Yesu anzendila nyongoo jola, ankamula kuboku. Nukuntondabee, na homa jejela jatenda kumboka. Ndi jwatumbuliya kuntelake posu. ");
INSERT INTO mgv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ekwahikila pakamii, bandu baaleta agonzu boa na bandu bababii ayokalani ni ilombu kwaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bandu bingi ba musi wegola bakusanyika pulubanza palongi ja nyumba. ");
INSERT INTO mgv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Najombi Yesu jaalamisa bandu bingi bababii na magonzu gokapi, kabee jiibenga ilombu hingi yeyabii yakamwi bandu. Ngasejiilekiti kupwaga sindu sokape ndaba yumanyiki jombi nyanye. ");
INSERT INTO mgv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kilabu je pulukela, Yesu jaboka nukujenda pandu panga na bandu nu kunndoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na ajaki bajenda kunkaguu Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ebumbona bumpwagila, “Kila mundu jugutaputa weapa.” ");
INSERT INTO mgv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu japwaaga, “Tujenda kumusi gongi gwapambipi, nakalandila bandu bangi kabee ndaba nhikiki kuhenga lihengu lele.” ");
INSERT INTO mgv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ndi jajenda kila pandu ku Galilaya nukulandi mu nyumba yukuketangane Ayaudi nu kubenga ilombu. ");
INSERT INTO mgv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lisoba limwa mundu jumu jojuleliki anzendila Yesu, nukungungamali nukundoba, “Nagupai guwesa kunyambisa!” ");
INSERT INTO mgv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ambonila ikia, nukumtondabee kuboku kwaki nukungusa nukupwaagi, “Mbala! Gunyambisika.” ");
INSERT INTO mgv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Apalapa, kuleleka kwaki kwatenda kukotoka, najombi jatenda kunyambisika. ");
INSERT INTO mgv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ndi Yesu ampwagila jujenda koni anndagalaki sukunhingamaki, ");
INSERT INTO mgv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Linga, wampwagi mundu jokapi jola lijambu leheli, gujenda ukililangia kwaka Nngolu waku ukaboa matambiku ndaba jukunyambisika kwaku ngati ejalagalakiya Musa kulangi gulamike.” ");
INSERT INTO mgv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakini mundu weoju jajenda, nukutumbuli kulongee lijambu lela, kila pandu, nukupwaga majambu gingi hata Yesu ngasijawesiki kabee kujingi kumusi gonge bila bandu kumanya. Jwalasimika kutama kunza pandu pangaa na bandu. Pamu na haga bandu bunzendila kila pandu. ");
INSERT INTO mgv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagapeta masoba masokopi, Yesu jakelubukya ku Kapelinaumu, bandu bajoana jubii ku nyumba. ");
INSERT INTO mgv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ndi bahika bandu bingi ngamaa, mbaki jasindikana mbekenyu jukupeta pundyangu na kunza. Yesu jwabii jaalandi malobi gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Papuje mundu jumu jojulei bundeta kwaka Yesu koni buntotwi bandu nsesi. ");
INSERT INTO mgv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lakini ndaba ju nsambi wa bandu, ngasebawesiki kujingi nkate. Ndienu, bakwela panani ju nhagaa bahotula nhagaa nukunhulu jojulei we jola pikilanda ja bandu nukumbeka palongi jaka Yesu pamu nilipega laki. ");
INSERT INTO mgv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ejukubona kuhobale kwabu, ampwagila mundu jojulei jola, “Mwanango, gulekakiwi mahakau gako.” ");
INSERT INTO mgv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abola bangi ba malagalaki gaka Musa babia atamani papuje baholalya mmwoju jabu, ");
INSERT INTO mgv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mundu we hoju juwesa boo kupwaga hela? Antondoo lee Sapanga! Nga mundu jojuwesa kulekake mahakau gaka mundu, kwaa Sapanga kajika jaki!” ");
INSERT INTO mgv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Apalapa Yesu jikimanyiki sebaholalya, jaapwagila, “Ndaba jaki nholale hela mmyoju jino? ");
INSERT INTO mgv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lijambu boo lelipepwiki nakanopi, kumpwagi mundu jojulei hajo, ‘Gulekakiwi mahakau gaku,’ au kupwaga, ‘Jumuka! Jukua lipega laku gujenda’? ");
INSERT INTO mgv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nala, mbala mmanya ana Mwana waka Mundu jubii nu uwesu wa kwaalekake bandu mahakau gabu pundema.” Ndii ampwagila mundu jojulei we jola, ");
INSERT INTO mgv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nugupwaagi, jema, jukua lipega laku, gujenda kunyumba jaku!” ");
INSERT INTO mgv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bandu boa pababia atenda kundingali, mundu we jola jajumuka, jajukua lipega laki nu kuboka. Bandu boa batenda kusangaa koni andumbalii Sapanga koni bakapwaga, “Ngasituwahiki kulibona lijambu ngati ele!” ");
INSERT INTO mgv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu jajenda kabee mulutengu ju nhanga. Nsambi wa bandu unzendila, na jombi jwatumbulya kwaabola. ");
INSERT INTO mgv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pajabia jujenda ambona Lawi mwana waka Alufayo, jutemi mu nyumba jukulepe kodi na bandu bababia baholali abii na mahakau. Yesu ampwagila, “Hikaa gunyengalyaje!” Lawi jajema nukunzengale. ");
INSERT INTO mgv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu pajabiya jutemi kunyumba jaka Lawi, jaka kula posu. Bandu baajopa kodi bingi na bandu bangi bababii baholale abii na mahakau babia anzengalii Yesu. Na bingi babu babia akula posu na Yesu pamu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ndienu, Abola bangi ba Malagalaki bababii Afalisayu, pabumbona Yesu jukula pamu na bandu bababia baholale abii na mahakau na baajopa kodi, baalalukya banafunzi baki, “Ndaba jakii jukula na bandu ngati haba?” ");
INSERT INTO mgv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ejajoana jaapwagila, “Bandu babii bomi ngaseampala sing'anga ila baabii atamu. Ngasenahika kakema bandu bambone, ila kwa bandu babaaholale abii na mahakau.” ");
INSERT INTO mgv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Banafunzi baka Yohana na banafunzi baka Afalisayu, babii atenda kupunga kula. Ndi enu bandu bangi bahika nukundaluki Yesu, “Ndaba jakii Banafunzi baka Yohana na banafunzi baka Afalisayu atenda kupunga kula, lakini banafunzi baku ngaseapunga?” ");
INSERT INTO mgv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu jaapwagila, “Boo, babaakokiki kundoa awesa lee kupunga kula ni kipindi se esi abii pamu na bambu wa ndoa? Kipindi se babii pamu na bambu wa ndoa ngaseatakiwa kupunga. ");
INSERT INTO mgv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakini sihika kipindi bambu wa ndoa pabamboa kwabu, kipindi se esi ndi pabiipunga kula. ");
INSERT INTO mgv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nga mundu jojuseku kibambu si ingobu inyai nukukisonee mwingobu jejilai. Anajwitenda hela, kibambu kinyai se sela siitenda kuwina nuku kupapu ingobu jejilai jela, nasombi siitalambuka ngane. ");
INSERT INTO mgv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wala nga mundu jojuwesa kujegee divai inyai mumipuku jelenganaki kwa ngosi jejilai, anaatei hela, divai je jitutumuka nukupojo mipuku je jela. Najombi divai pamu ni mipuku jealenganaki kwa ngosi jejela jitenda kuhalabika. Divai inyai abeka mmipuku minyai.” ");
INSERT INTO mgv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lisoba limu Lukupomulela, Yesu jabia jupeta mwamatui gi inganu. Pababii mwindela, banafunzi baki batumbulya kuseku makapati gi inganu. ");
INSERT INTO mgv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Afalisayu bunndalukya Yesu koni apwaga, “Linga! Mbona banafunzi baku atenda lijambu leakani kutenda Lisoba lu Kupomulela?” ");
INSERT INTO mgv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu jaapwagila, “Boo ngasemsomiki lee gajahenga Daudi pamu na ajaki kipindi sebabii ni inzala? ");
INSERT INTO mgv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daudi jajingala nyumba jaka Sapanga, nakula mabumunda gababei palongi jilitambiku laka Sapanga. Lijambu le heli lahengika pajabii Abiazali nngolu nkolongu. Mabumunda ge gala bapalika akula agolu pee kajika. Lakini Daudi jagakula na kwaapeke ajaki.” ");
INSERT INTO mgv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ndi Yesu jaapwagila, “Lisoba lu Kupomulela abei ndaba jakwaajangatii bandu, nga bandu ndaba jukutumiki Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nahela, Mwana waka Mundu jubii nu uwesu hata Lisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu jajingala kabee mu nyumba jukuketangane Ayaudi, nu nkati je mola jwabii mundu jokulei kuboku. ");
INSERT INTO mgv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Momuje, bandu bangi batenda kundingali jombi anndamisa mundu we jola Lisoba lu Kupomulela bapala apata ndela jukuntaki. ");
INSERT INTO mgv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ampwagila mundu jokulei kuboku jola, “Hikaa palongi pamba.” ");
INSERT INTO mgv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Henu Jaalalukiya, “Boo sakaka lee Lisoba lu Kupomulela kuhenga lijambu la sape au lalyaa, kunzangatii mundu au kunhumisa? Kunhokoo mundu au kunkoma?” Lakini bombi ngasibapwagiki sindo. ");
INSERT INTO mgv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu jaalingaliya bandu boti kwi ingwinya nukugubona usungu ndaba mioju jabu ngasebapai anzangatya mundu jola. Ndipala ampwagila jojulei kuboku jola, “Nyosha kuboku!” Najombi ejanyosha kuboku kwaki kola kwatenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ndipala, aka Afalisayu bapita kunza, baketangana na bandu kuhuma kwaka Helodi, bajetanganya kutumbulii kutaputa indela jukunkoma Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu jaboka pala na banafunzi baki, jajenda mulutengu junhanga uku Galilaya na bandu bingi batenda kunzengalee. Bandu bahika kuhuma ku Yelusalemu nuku Yudea, ");
INSERT INTO mgv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nuku Idumea na kwii juku losi luku Yoludani na ku Tilo nuku Sidoni. Bandu haba boa bunzendila Yesu ndaba jeni babii ajogwini gajabia juhengiki. ");
INSERT INTO mgv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu jaapwagila banafunzi baki bunhandalya nhwatu gumu, ndaba likundi lya bandu lyatenda kunhinya. ");
INSERT INTO mgv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ndaba jabia jalamisi bandu bingi, na agonzu bote bahinyana beni na beni kupala kungusa jombe. ");
INSERT INTO mgv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na bandu bababii ni ilombu pabumbona, biliabua pai palongi jaki nu kujamalii, “Wehapa wa Mwana waka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakini Yesu jaakanakya baapwagi bandu jombi nyanye. ");
INSERT INTO mgv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu jakwela kukitombi, na kakema bajaapala mweni. Na bombi nukunzengale, ");
INSERT INTO mgv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","najombi jahagula bandu komi na habeli, bajaakema atumi. Jaapwagila, “Nunhagwi mwanganya mmbia pamu nane. Kabee nuntuma mwakalandila bandu. ");
INSERT INTO mgv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na mwikubaa nu uwesu ukubenga ilombu.” ");
INSERT INTO mgv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Henu bandu bala bajahagwi komi na habeli babii haba, Simoni jojapataa liina la Petili kuhuma kwaka Yesu, ");
INSERT INTO mgv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu na Yohana bana baka Zebedayu Yesu jaakema aka kilongu haba Bonigesi, maana jaki, “Bandu bini kipyau,” ");
INSERT INTO mgv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andilea na Pilipi na Batolomayu na Matei na Tomasi na Yakobu mwana waka Alufayo na Tadei na Simoni joankema Zelote maana jaki mundu jojukomane nndema waki, ");
INSERT INTO mgv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na Yuda Isikaliote, joang'anumbuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu jajenda kunyumba. Bandu bingi bakusanyika kabee, mbaka Yesu na banafunzi baki ngasebapatiki muda gwakula posu. ");
INSERT INTO mgv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndipala, alongumundu pabapata lijambu le ele bajenda kunzuku ndaba bandu bapwaaga, “Juyowiki mwanamangongu.” ");
INSERT INTO mgv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Naka Abola bamalagalaki babahuma ku Yelusalemu bapwaaga, “Hajoo jubii ni Lijobi! Kabee jubenga ilombu kwa makili guku nkolongu jwi ilombu.” ");
INSERT INTO mgv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Papuje Yesu jaakema, jaapwagila kwa malenganesu, “Lijobi liwesaboo kulibenga nkolongu jwi lijobi yenge? ");
INSERT INTO mgv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nagubii ukolongu gumu gogubaganiki makundimakundi gagakomana, ukolongu we ogu gwiitenda kuhabuka. ");
INSERT INTO mgv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kabee najibii nyumba jejibaganiki makundimakundi gagapengana, nyumba jeeji jiitenda kuhalabika. ");
INSERT INTO mgv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nahela, ana gubii ukulongu wi ilombu gubaganiki makundimakundi ngagwiwesi kudumo, ila gwihoba ngane. ");
INSERT INTO mgv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ngamundu jojuwesa kutukalii nyumba jaka mundu jojubii na makili nukunyaga mali gaki. Mbaka ankonga hoti mundu jwana makili jola, ndi jiwesa kunyaga mali gee. ");
INSERT INTO mgv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Numpwagi sa sakaka, Sapanga jaalekakya bandu mahakau gabu pamu nukuntondoka kwabu, ");
INSERT INTO mgv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","lakini joantondo Loho jaka Sapanga, Sapanga ngahandekakele mahakau gaki, jwiitama na mahakau gaki masoba goa.” ");
INSERT INTO mgv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu japwaaga hela ndaba bandu bapwaaga, “Jubii ni kilombu.” ");
INSERT INTO mgv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anyongo baka Yesu na alongu baki bahika pala nukujema kunza, buntuma mundu kunkema. ");
INSERT INTO mgv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nsambi wa bandu watemi papu kunyongolota Yesu. Ndipala mundu jumu ampwagila Yesu, “Anyongo na alongu baku abii kunza, atenda kugukema.” ");
INSERT INTO mgv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu jaapwagila, “Anyongo bangu ne naka alongu bangu ne ndi akanyane?” ");
INSERT INTO mgv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Papuje jalingalya bandu babatemi kun'yongolota nukupwaga, “Nndingalya! Naabona bamba ngati nyongowangu naka alongu bango. ");
INSERT INTO mgv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu jokapi jojuhenga gajupala Sapanga, ndi amabu bangu na nndombu wa nu mmbeli wa.” ");
INSERT INTO mgv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu jatumbulya kabee kubola mulutengu ju nhanga uku Galilaya. Nsambi wa bandu watei kunyongolota hata hela kwatakiwa jujingala munhwatu nukutama momu. Bandu boa babii atemi mundema nzomu mulutengu ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jaabola majambu gingi kwa malenganu, mmabolee gaki japwaaga. ");
INSERT INTO mgv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nzoanya! Mundu jumu jwajenda kukweta imbejo. ");
INSERT INTO mgv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pajabiya jukweta imbeju, yengi yahabuka piindela jahika ijuni nakula. ");
INSERT INTO mgv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yengi yahabuka pamalibu pangakuba nuluombi lwingi. Ndaba luhombi ngase lwabii lwinge yabonikana imeliki nyata. ");
INSERT INTO mgv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ekwahika lyobamutu, mimea jatenda kujoma, ndaba mikega jaki ngasijabii na makili, nayombi yatenda kunyala nukujoma. ");
INSERT INTO mgv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yengi yahabuki mmikongo ja miha, na mia jejela jakola nyata kujiinya na yombi ngase yapapike. ");
INSERT INTO mgv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yengi yahabukya puluhombi lwa sapi, yamela, nukukola nukupapa. Lumu makomi matatu, lumu makomi sita na longi imbeju makomi komi.” ");
INSERT INTO mgv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndienu jaapwagila, “Jojubii na makutu jujowana.” ");
INSERT INTO mgv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu pajabii kajika jaki, banafunzi baki komi na habeli pamu na bandu bangi babunzoanya bunzendila nukupwagi jaayekulya malenganu gala. ");
INSERT INTO mgv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Najombi jaapwagila, “Mwanganya mpatiki uwesu ukumanya majambu gagajobiki gu Ukolongu waka Sapanga. Lakini baabi kunza balibola kwa malenganu pena, ");
INSERT INTO mgv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ndaba je, ‘Alinga sa sakaka, lakini bakibona ajoa sakaka, lakini bakielewa. Kwa naa bung'anumbuki Sapanga, najombi jaalekakya mahakau.’ ” ");
INSERT INTO mgv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Enu Yesu jalalukya, “Boo, mwanganya ngasenheliwi ndaba ja malenganesu ge agaa? Mwimanya boo malenganesu gange? ");
INSERT INTO mgv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpanda jukweta Lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bandu bangi abingati bandu bababii mwindela paapandiki lilobi. Lakini pabilijoana pee lijobi lihika kuboa lilobi leapandiki mmwoju jabo. ");
INSERT INTO mgv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bandu bangi baabii ngati imbeju yeapandiki pamalibu. Hebilijoana pe Lilobi laka Sapanga bilijopa hapalapa koni bakatogulya. ");
INSERT INTO mgv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lakini ngase laajingii nukumela mikega mmyoju jabo. Bilihobale muda msokopi pena, nalipitii linga'ai na tabu ndaba jililobi heli atenda kulileka. ");
INSERT INTO mgv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bandu bangi abii ngati imbeju yeihabuki pimikongu jamiha. Agaa malenganu ga bandu baajoana lilobi laka Sapanga heli, ");
INSERT INTO mgv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kupete maholu gupundema goni, kupala mali gingi nukutokule kila sindu apataa bombi kulihinya lilobi heli, na bombi ngaseahenga ngati Lilobi laka Sapanga selipwaga. ");
INSERT INTO mgv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lakini bandu bangi abii ngati imbeju yeakwetiki puluhombi lwa sapi. Bombi bilijowane lilobi le heli nukulijopa nukulijetake, nukuhenga ngati Sapanga ejupala. Ngati imbeju ja sapi jejipapa matunda makomi matato, bangi makomi sita, na bangi makomi kome.” ");
INSERT INTO mgv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu jaendaliya kapwagi, “Boo! Kanono mundu lee kupambakiya taa nukujingisa nkati ja nyumba nu kuyekale mkitonga au kwii ja sindo? Ngahela! Biibeka pi kipanda. ");
INSERT INTO mgv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nahela kila sekihihiki sitenda kubonikana, na kila se kiyekaliwi kitenda kuyekuliwa. ");
INSERT INTO mgv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jojubii na makutu jujogwana!” ");
INSERT INTO mgv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ndi jaapwagila, “Nzoanya nakanopi senumpwagii! Sapanga janzangatya nmanya kukipemu aselasee se senzoane, janzonzukiya kumanya ngani. ");
INSERT INTO mgv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bandu bajoane nakanopi senumpwagi nukumanya Sapanga janzangatya kumanya ngane. Lakine bangakujoanee nakanopi biitenda kujewa hata gabagamanyi.” ");
INSERT INTO mgv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu jaendalya kupwaga, “Ukolongu waka Sapanga gubii ana. Mundu jojukweta imbeju mlitui. ");
INSERT INTO mgv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikilu jutenda kugone, na muhi jukuba mihu, na muda we ogu imbeju ye itenda kumela nu kukola. Jombi sanga kumanya sekihengeka. ");
INSERT INTO mgv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mimea je jitunduli muluhombi jikola nu kupapa matunda. Itumbuli kutunduli maamba masokumasoku, mapongoo na mwisu we kipambiku. ");
INSERT INTO mgv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Inganu eikuba ikomiki, mundu we jola jutumbulii kuhusa ni kijipii ndaba jene muda ukuhusa gukuba guhikiki.” ");
INSERT INTO mgv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu jaapwagila kabee, “Ukolongu waka Sapanga gubii bole? Henu tuguelasiya kwi indela bole? ");
INSERT INTO mgv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gulengana ni imbeju jebijikema haladali, jejibii nzoku kupeta imbeju yoti jeakweta mlitui. ");
INSERT INTO mgv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lakini naakwetiki jimela nakuba mimea mikolongu kupeta mimea joka jammatui. Mambandi gaki gakuba makolongu hata ijuni ioto kusenga miui momu jene.” ");
INSERT INTO mgv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu jalandila malagi gaki kupete malenganu gangi gingi ngati gagaa. Jalongila nabu ngati ebawesa kunzoane kuhusu Ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ngasijalongila nabu sokapi bila kutumii malenganu. Lakini pajabii na banafunzi baki kajika jukubika jaayekuli ndaba jakila malengano. ");
INSERT INTO mgv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lisoba alelale pakamii, Yesu jaapwagila banafunzi baki, “Tulombuka nhanga, tujenda kwiie.” ");
INSERT INTO mgv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ndipala banafunzi bugutabuka nsambi wa bandu, bajingalaa munhwatu mojabii Yesu nu kuboka pamu najombi na kabee minhwatu jengi jejabii na bandu jatenda kujengalee. ");
INSERT INTO mgv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ndienu sasuma kimbonga kikolongu, na majeba kutumbuli kugukanga nhwatu we gola, nunhwatu gola gwatumbulya kutwele masi. ");
INSERT INTO mgv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu jabii kunyuma junhwatu, jagoni panani ju ntoo. Banafunzi baki bunzumua nukumpwagi, “Mbola, ngasegubona lee usungu etukuwa!” ");
INSERT INTO mgv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jajumuka nu kukilakali kimbonga se sela, nakagalakali majeba guku nhanga ge gala japwaga, “Tama kinunu!” Ndipala kimbonga se sela satenda kukotoka, ndienu kwabia nuu. ");
INSERT INTO mgv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ndienu, Yesu jaapwagila banafunzi baki, “Ndaba jakii ntenda kujogopa? Mwakona lee ngase nhobalela?” ");
INSERT INTO mgv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nabombi babia ajogopa ngamaa. Babia alaluana, “Jonioju we nya eno? Mbaka kimbonga na majeba gatenda kunzowanela?” ");
INSERT INTO mgv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na banafunzi baki bahika ku nndema uku Gelasi, kwii juku nhanga. ");
INSERT INTO mgv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ndipala Yesu pajapita nhwatu, jaketangini na mundu jumwa jojabii nii ilombu jakahumila kutenge. ");
INSERT INTO mgv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu we oju jutamika kutenge. Nga mundu jojawesa kunkamulaki hata kunkonga nnyolu, ");
INSERT INTO mgv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","mala jingi bunkonga kwa peengu ju nnyolu lakini kila muda jabia juwesa kuseku nnyolu nu kutunu peengu je. Wala ngamundu jojuwesa kumpengalela. ");
INSERT INTO mgv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Muhi ni ikilu jutamika kutenge nukukitombi jalongila kwa sauti ngolongu nukulisekuseku kwa malibu. ");
INSERT INTO mgv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eambona Yesu su kutali, ambutukiya nukungungamali palongi jaki, ");
INSERT INTO mgv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","jalela kwa sauti ngolongu nukupwaga, “Nanugutei kyane! Weapa le wa Yesu, Mwana waka Sapanga jojubii kunani kwa mahunde? Kwi liina la Sapanga, nuguloba gwing'alisa!” ");
INSERT INTO mgv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Japwaga hela ndaba Yesu jabi jiipwagi, “Ilombu mumboka mundu we hojo.” ");
INSERT INTO mgv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ndipala, Yesu andalukiya, “Liina laku wa nyane?” Najombi ampwagila, “Liina langu ni likundi la alonda, ndaba twe tubii twabinge.” ");
INSERT INTO mgv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ndipala kilombu sela sundobiki ngamaa Yesu jwaimbenga pundema we gola. ");
INSERT INTO mgv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Muda gogo wabii nsambi nkolongu wa magolobi pikiheleu pambipi ni kitombi bakalimaa. ");
INSERT INTO mgv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Henu, ilombu ye yundoba Yesu, “Gutujetakalya twagajingala magolobi agaa.” ");
INSERT INTO mgv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu jwajetakii. Henu ilombu yumboka mundu jola, nakagajingii magolobi gala. Likungusa loa la magolobi lelaegalii elupu ibeli. Magolobi ge gala gabutuka pikiheleu nu kujingii muhanga na kuwa. ");
INSERT INTO mgv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Alimu ba magolobi ge gala batenda kutilanii, bajendanya kumusi na kwa matui kapwagi bandu lihengu le heli. Na bandu bajenda kulinga sekipitii. ");
INSERT INTO mgv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pabahika kwaka Yesu, bumbona mundu jojabii na manzolinzoli giilombu. Jutami pai, juwati ingobu jubii na malangu gaki gunkelabwiki, batenda kujogopa. ");
INSERT INTO mgv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bandu babagabona mahengu ge gala, baapwagila bangi gagunkolii mundu jojabii ni ilombu pamu nilijambu li ilombu yela kujenda kulikungusa la magolobi. ");
INSERT INTO mgv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ndipala, jatumbuka kundoba juboka nndema wabu. ");
INSERT INTO mgv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu pajabia jukwela munhwatu, mundu joampia ilombu andoba anzetakiya kujenda naku. ");
INSERT INTO mgv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lakini Yesu jatenda kunkani. Ampwagila, “Gujenda kunyumba jaka alongu baku, wakapwagila mahengu goti ga juguhengi Bambu nu kugubone ikia.” ");
INSERT INTO mgv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ndipala, mundu we jwajenda nukutumbuka kalandi kunkoa uku Dekapoli kwoa, majambu goti gajuhengiki Yesu. Bandu boa babajoa batenda kusangaa. ");
INSERT INTO mgv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu jalombukiya kabee upandi wa pili unhanga nu nhwatu. Pajahika pe nsambi wa bandu wabia palongi jaki, najombi jabia jujemiki kulutengu upunhanga. ");
INSERT INTO mgv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Papuje jahika mundu jumwa kilongosi jwa nyumba jukuketangane Ayaudi joankema Yailo. Ejumbona Yesu, ahegalya nu kungungamali, ");
INSERT INTO mgv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","andoba ngamaa koni jwakapwaga, “Kamwali wa nsoku jubii lailai. Gupepa koku tumboka, ukumbekila maboku gaku julama.” ");
INSERT INTO mgv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ndipala, Yesu jaboka pamwa nabu. Bandu bingi ngamaa batenda kunzengale, babia atenda kuhinyahinya. ");
INSERT INTO mgv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kati jabu jabii mmbomba jumu jojubii nu ugonzu gukupita mwai kwa muda wa miaka komi ni mibele. ");
INSERT INTO mgv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mmbomba we oju jabia jung'aliki kwaka sing'anga bingi. Pamu jabia jujomwi mali gaki goa, ngasijapogalyaje jabia jijonzukeka kuba jiliya. ");
INSERT INTO mgv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mmbomba we hoju pajajoana Yesu jalamisa bandu, jilipekalakiya pu nsambi wa bandu kuhuma kunyuma, nukugusa ingobu jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jatenda hela, ndaba julipwagila mmwoju jaki, “Nanung'usiki tu ingobu yaki nibia namiki.” ");
INSERT INTO mgv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Apalapa kupita mwai we kwatenda kukotoka, najombi jilijoannya nhyega jaki julamike. ");
INSERT INTO mgv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu jabia jumanyiki makili gaki gundamisi mundu jumu. Jugung'anumbukiya nsambi wa bandu gola, nukugulaluki, “Nya jojung'usiki ingobu yango?” ");
INSERT INTO mgv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Banafunzi baki baapwaga, “Ngase wabweni lee bandu mobuguhinyila jee. Ndaba ja kii gulaluki nya jojugugusike?” ");
INSERT INTO mgv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakini Yesu jaendaliya kulingalii kila upandi ili ambona mundu jojuhengiki ganiaga. ");
INSERT INTO mgv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Papuje mbomba we jola, ejamanya sesumpatiki, jajenda palongi jaki koni jakabagaja kwi kiholu, jililekala pai palongi jaka Yesu nukupwaga sakaka. ");
INSERT INTO mgv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ampwagila, “Kamwali wangu kuhobalee kwaku kugulamise. Jenda sapi, gulama ngane ugonzu waku we hogo.” ");
INSERT INTO mgv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu pajabia jakoni jakalonge, bandu bahika kuhuma kunyumba jaka Yailo kilongosi jwa nyumba jukuketangane Ayaudi, bumpwagila, “Kamwali waku juwile. Ndaba jakii kunsumbu Mbola?” ");
INSERT INTO mgv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lakine Yesu ngasejajoannya gabapwaga bandu, Yesu ampwagila kilongosi jwa nyumba jukuketangane Ayaudi jola, “Wijogopa, guhobaliya pena.” ");
INSERT INTO mgv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ngase jajetakiya mundu jongi jokapi kulongana naku ila pee Petili, Yakobu na Yohana nndongu waka Yakobu. ");
INSERT INTO mgv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hebahika kunyumba jaka kilongosi jwa nyumba jukuketangane Ayaudi jaka Yailo, Yesu jajoana atenda kujobalane, na bandu bakalela na malobalake gingi. ");
INSERT INTO mgv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ejajingala nkati, jaapwagila, “Ndaba jakii nntenda kujobalane nu kulela? Kamwali ngasijuwile jutei kugone pena.” ");
INSERT INTO mgv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lakini bombi batenda kun'heka. Jaamua kapia boti kunza, jajukua amabu na ahengo baka kamwali we naaka banafunzi baki atatu, bajingala kusumba kojabii jugoni kamwali we. ");
INSERT INTO mgv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ndienu ankamula mukuboku nukumpwagi, “Talita kumi,” maana jaki, “Wakamwali, nugupwagi gujumka!” ");
INSERT INTO mgv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Apalapa kamwali jajema nukutumbuka kujenda. Kamwali we jabii na miaka komi ni mibele. Hapa ndi bandu basangia ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu jaakana bampwagi mundu jokapi lijambu le ele. Ndienu jaapwagila bupekia posu kamwali we jola. ");
INSERT INTO mgv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu jaboka papuje nukujenda kukijiji saki, koni bunzengalee banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Elahika Lisoba lu Kupomulela, jajingala mu nyumba jukuketangane Ayaudi nu kutumbulii kubola. Bandu bingi babunzoana batenda kusangaa nakaapwagi, “Boo, jagapatiki kwako majambu ge aga gajupwaga? Linga jupatiki kwa malangu haga? Kabee juhenga boo hindu ye heye? ");
INSERT INTO mgv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Boo jonyoju lee nga nndanda juimbau jola, mwana waka Malia, nu ndongu wabu Yose na Yakobu, Yuda na Simoni? Alombu baki si atamani pa pitu pane?” Henu batenda kunkana. ");
INSERT INTO mgv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ampwagila, “Mlota waka Sapanga julumbalika kila pandu ila ngasejulumbalika kwa alongu baki, kwaka akosimundu nu kunyumba jaki.” ");
INSERT INTO mgv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu ngase jawesa kutenda ginyuli papu, ila jaabekila maboku agonzu asokopi, na kwaalamisa. ");
INSERT INTO mgv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jasangi ngamaa ndaba bandu kusindwa kuhobale kwabu. Ndipala Yesu jiijendila ijiji ya pambipi jaki nakabola bandu. ");
INSERT INTO mgv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jakema banafunzi baki komi na abeli, jatumbuka katuma habelihabeli. Japekiya uwesu ukubenga ilombu, ");
INSERT INTO mgv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","jalagalakiya, “Mwiitoto sindu sokapi nsapwali ila ndonga pena. Mwitoto posu, wala kibwaila, wala lupija mupuku. ");
INSERT INTO mgv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nhwata makobasi, lakini mwitoto lijalisi mabele.” ");
INSERT INTO mgv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kabee jaapwagila, “Pokapi pabanzoopa panyumba, mwakatamanya mbaka pamwiboka. ");
INSERT INTO mgv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pandu pokapi bandu pabukunkana kunkalibisa au kunzoane, mwakabokannya nukukung'unda luhombi mwamagolu ili kalangi atei kukana malobi gaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ndienu baboka, bakaalandila bandu kunkelubuki Sapanga wabu. ");
INSERT INTO mgv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bibengana ilombu ingi. Baapakia mahuta agonzu bingi, na agonzu bala nu kulama. ");
INSERT INTO mgv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ndipala, nkolongu Helodi jajohana goka haga, ndaba bandu bingi babia apwaga majambu gaka Yesu kila pandu. Bandu bangi apwaga, “Hajo ndi Yohana Mmbatisa juyokiti! Ndaba jubii nu uwesu ukuhenga hindu yu kusangasa.” ");
INSERT INTO mgv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bangi, bapwaga, “Jonioju we Elia.” Bangi apwaga, “Jonioju we Mlota waka Sapanga ngati jumwa wabu waka Alota baka Sapanga ba samani.” ");
INSERT INTO mgv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lakini Helodi pajajoa lijambu le eli japwaga, “Jonioju we Yohana! Jonunsekula umutu, lakini juyokiti!” ");
INSERT INTO mgv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Helodi jawasalya hela ndaba masoba gumunyuma jabia julagalaki ankamula Yohana Mmbatisa, nukunkonga mligelesa. Helodi jahenga hela ndaba Helodia jakabii nhwanu waka Pilipi nndongu waki. Pamu na haga Helodi jaamua kunzuku Helodia. ");
INSERT INTO mgv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana Mmbatisa jabia ampwagi Helodi, “Gutei lyaa kunzuku nwanu waka nndongu wako.” ");
INSERT INTO mgv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ndienu Helodia, nwanu waka bambu nkolongu, ansuki ngamaa Yohana, japala kunkoma, ngasijawesaje. ");
INSERT INTO mgv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode anzogapa Yohana ndaba jamanyiki jombi mundu jwa amboni na jwa sapi, na hela nukundenda. Helodi japai kunzoane Yohana, baada jukunzoane, jahangajiki ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lisoba limwa nhwanu waka bambu nkolongu japata mbekenyo, elahika lisoba lukukomboka kusaliwa kwaka Helode. Lisoba le heli Helodi jakokiki, akakiongosi akolongu bupundema waki na linzolinzoli na akanahota boti buku Galilaya. Ndaba jakula nabu posu pamu. ");
INSERT INTO mgv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndienu, kamwali waka Helodia jajingala nukuhina, janhekisi ngamaa Helodi na ageni baki. Bambu nkolongu apwagila kamwali we hoju, “Gunobaa sokapi se ukipai nane nugutenda nugupeke.” ");
INSERT INTO mgv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kabee nu kunndapila, “Sokapi segwinoba nugutenda kugupekea, hata jikubi nusu ju ubambo wango.” ");
INSERT INTO mgv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Papuje kamwali we oju japita, nakalalukii amabu, “Noba kike?” Nabombi bapwagaa. “Kimutu saka Yohana Mmbatisa.” ");
INSERT INTO mgv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kamwali jakelubuka kwaka bambu nkolongu imbelo kukundoba, “Mbala gumbekya sajenu, mmutu waka Yohana Mmbatisa mwikipalu.” ");
INSERT INTO mgv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bambu nkolongu jayomiki ngamaa, lakine ndaba jukulagi kwaki, na ndaba ja ageni baki bajakokiki, ngasijapala kunkanila. ");
INSERT INTO mgv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ndienu, bambu nkolongu antuma linzolinzoli, jwakaleta kimutu saka Yohana. Linzolinzoli, jwajenda nukunseku kimutu Yohana mligelesa, ");
INSERT INTO mgv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","jaleta mmutu waki we gola mwikipalo nukumpeke kamwali, najombi nakapekee amabu. ");
INSERT INTO mgv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Banafunzi baka Yohana ebajoana ganiaga, bajenda kujukuu nhyega jaki je nukujenda kusika. ");
INSERT INTO mgv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Atumi baki bala babuja kuhuma sapwali jabu, bakusanyika palongi jaka Yesu, bumpwagila goa gabahenga nu kubola. ");
INSERT INTO mgv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu jaapwagila, “Tumbokannya jikajitu pandu panga bandu mwakapomulia kasokope.” Japwaga hela, ndaba ja bandu bingi ngamaa babia ahika papu nu kuboka, hataa Yesu na banafunzi baki ngasibawesa kupata mbekenyu jakula posu. ");
INSERT INTO mgv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ndienu babokannya kajika jabu munhwatu, bajendannya pandu panga bandu. ");
INSERT INTO mgv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lakini bandu bingi, babaabweni bakajenda, bamanyiki, hata hela bandu babahumila kila musi, bumbutukya koku Yesu na banafunzi baki kobabia ajenda, balonguliya kuhika. ");
INSERT INTO mgv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu na banafunzi baki ebahuluka kumbwani, Yesu jugubona nsambi wa bandu, jaabonila ikia, ndaba babia ngati makondoo ganga na alima. Jatumbulya kubola majambu gingi. ");
INSERT INTO mgv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pakamii ekwahika, banafunzi bunzendila Yesu, nukumpwagi, “Pandu je pani pulukoba, na sajenu kutenda kupilila. ");
INSERT INTO mgv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nambanga, waatabuka bandu be haba ajendannya mwamatui nu kwiijiji ya pambipi, bakalomba posu.” ");
INSERT INTO mgv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lakini Yesu jaapwagila, “Mwapekya mwanganya posu.” Na bombi bundalukiya, “Boo, twapekya kike? Tupalika tuhenga mahengu kwa miehi jingi ili tupata lupija lukulombe posu ja bandu boti haba.” ");
INSERT INTO mgv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu jalalukiya, “Mmbii na mabumunda malenga? Nzendannya mwakalinga.” Pababia alingiki, bumpwagila, “Gabii mabumunda nhwano na homba ibele.” ");
INSERT INTO mgv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndienu Yesu jalagalakya banafunzi baki, baatamika bandu boa malundu ga bandu pamanyonyoli. ");
INSERT INTO mgv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na bombi batama malundu ga bandu makomi komi na makomi nu nhwano. ");
INSERT INTO mgv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ndipala Yesu jajukua mabumunda nhwanu na homba ibeli ye yela, jalingaliya kunani kwa mahundi, jagapengaliya, nukunuku mabumunda, japekiya banafunzi baki babagila bandu. Na homba ye yela jabagila boti. ");
INSERT INTO mgv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bandu boa bakula, nukutupila. ");
INSERT INTO mgv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Batondula posu yeyaigali ya mabumunda na homba batwelakiya hiitonga komi ni ibele. ");
INSERT INTO mgv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nababa kula be mabumunda ge gala babia akanalomi elupu nhwanu. ");
INSERT INTO mgv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Apalapa Yesu jatuma banafunzi baki akwela nhwatu, andonguliya kujenda ku Betisaida kwii ju nhanga. Jombi muda we ogu jabia jugutabuka nsambi wa bandu we gola. ");
INSERT INTO mgv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ejajomula katabuka bandu bala jajenda kukitombi kundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pakwahikila pakamii, nhwatu we gola wabia pikilanda ju nhanga, najombi jabia kajika jaki kundema kwanga masi. ");
INSERT INTO mgv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Apalapa, jaabona banafunzi baki bakaangijika kukwabu masi, ndaba je nhwai wabia gutenda kwapengale. Ekwabia lukela, Yesu jaajendila banafunzi baki koni jakajenda panani ja masi, japala ngati kwaapeta. ");
INSERT INTO mgv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lakini pabumbona jujenda panani ja mase, bahambukya lihoka, batenda kujamali. ");
INSERT INTO mgv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ndaba boa pabumbona bajogipi ngamaa. Apalapa Yesu jalongila nabu, “Nabi nepane! Mwijogopa! Ntama nuu.” ");
INSERT INTO mgv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ndi jakwela munhwatu mobabii, nu nhwai gwatenda kukotoka. Nabombi basangii ngamaa, ");
INSERT INTO mgv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ndaba babi ngaseaheliwi sejikihenga Yesu kupete mabumunda gala. Gabaapekiya bandu bingi ngati posu, malangu gabu gabia ngasegahogwiki. ");
INSERT INTO mgv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Balombuka nhanga bahika kundema guku Genesaleti, bajemika nhwatu wabu. ");
INSERT INTO mgv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pabapita munhwatu, bandu bumanyiki Yesu apalapa. ");
INSERT INTO mgv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ndienu, mala pee bayongulata nndema gola woti, bandu batumbuka katogo agonzu babagoni panani ji ipega yabu, baapelika kila pandu pabajoa Yesu jubi. ");
INSERT INTO mgv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila pandu pajajenda Yesu, kwiijijini nu kumusi au kwamatui. Bandu babeka agonzu pulubanza, bundoba jajetakalya bungusa pe hata pu lupeta ji ingobu jaki. Na boa babungusa batenda kulama. ");
INSERT INTO mgv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lisoba limu Afalisayu bangi na Abola ba Malagalaki bababia ahumi ku Yelusalemu bajenda kumbona Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Baabona banafunzi baka Yesu bangi bakakula posu kwa maboku gabu ganga kunyamba, yaani ganga kusamba ngati ekupalika mmalagalaki gabu. ");
INSERT INTO mgv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ndaba Afalisayu na Ayaudi bangi boa akamulaki ngamaa mabole gabajopiki kwaka aseja babu bamwandi, ngase akula sindu sanga kusamba maboku ngati ekupalika. ");
INSERT INTO mgv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kabee ngasiakula sindu kuhuma kuguliu bila kuhuba oti ngati ekupalika na mila jabu. Ibii kabee mila yengi yebajopaa tumbuka samani ngati kugolo nzipuli, supulia na yombu ya shaba. ");
INSERT INTO mgv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ndienu, Afalisayu na Abola ba Malagalaki bundalukya Yesu, “Ndaba jaki banafunzi baku ngaseapwata malagalaki gaka aseja bito. Enu akula posu kwa maboku sanga kusamba ngati ekutakiwa?” ");
INSERT INTO mgv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu japwaaga, “Mwanganya mliholale mwaasapi akati nga mwasaape Isaya jojabii Mlota waka Sapanga japwaga sakaka kunhusu mwanganya pajaandika, ‘Sapanga japwaga, bandu haba, anumbali kwa malobi pena, lakini mmyoju jabu, abii kutali na nenepani. ");
INSERT INTO mgv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kunumbali kwabu ngasekubii na mana, ndaba majambu gabaabola bandu malagalaki pee ga bandu ngati malagalaki gaka Sapanga.’ ");
INSERT INTO mgv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mwanganya mwijileka Amuli jaka Sapanga nuku kamulaki malagalaki ga bandu.” ");
INSERT INTO mgv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu jaendalya kupwaga, “Mwanganya kwa malangu ginu nkana malagalaki gaka Sapanga ndaba jukupwata majopu gino! ");
INSERT INTO mgv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ndaba Musa japwaga, ‘Wajoannya ahengo baku na amabu bako,’ na ‘Mundu jokapi jojaatondo ahengo baki na amabu baki, kupalika ankoma.’ ");
INSERT INTO mgv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lakini mwanganya mwaabola bandu, ana mundu jubii na sindu sejuwesa kwaajangatii ahengo baki au amabu baki, lakini jupwaga Sindu see esi Kolubani, yani sindu hesi litambiku kwaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ndienu, ngajwaajangati kabee ahengo baki na amabu baki. ");
INSERT INTO mgv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hela ndi pamwilikana Lilobi laka Sapanga ndaba ja mabolee gamulibeki. Kabee nhenga majambu gangi gingi ngati gagaga.” ");
INSERT INTO mgv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu jugukema kabee nsambi wa bandu we gola, nakaapwagi, “Nnyogwana mwaboa, mukimanya senumpwagi. ");
INSERT INTO mgv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nga posu jejukula mundu jejuntenda jubia mpija palongi ja mihu gaka Sapanga. Lakini sekipita mmoju jaka mundu ndi sesuntenda jubia mundu jwiliya palongi ja mihu gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jwana makutu gu kujoana nu jujoana!” ");
INSERT INTO mgv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ejuguuleka nsambi wa bandu nu kujingi nnyumba, banafunzi baki bundalukya ndaba ja malenganu ge gala. ");
INSERT INTO mgv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Najombi jaapwagila, “Boo, hata mwanganya lee ngasemmanyike? Ngasemmanyiki lee posu jejukula mundu jipita kunza ngase jiwesa kuntenda mundu jubia mpija palongi ja mihu gaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ndaba ngasesunzingii mmwoju jaki, ila mulutumbu na mwisu jaki je kupitii kunza kulikelo?” Kukupwaga hela, Yesu jalekakya ilebi yoti iwesikana kula. ");
INSERT INTO mgv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jaendalya kupwaaga, “Sekipita mmoju jaka mundu, ndi sesu ntenda jubia mpija palongi ja mihu gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ndaba kuhuma mmoju jaka mundu, gapita mawasu gililya na uselati na wihii na mawasu gukukoma kukoma, ");
INSERT INTO mgv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ugoni na soju nu uliya ni isoli nu kupala utani wa uselati na wipu matondu nu kibuli nu ung'ang'a. ");
INSERT INTO mgv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Goa gilia ge haga gahuma mmoju jaka mundu, nagombi guntenda mundu jubia jwiliya palongi ja mihu gaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu jaboka papuje, jajenda kundema uku Tilo. Kokuje jajingala mu nyumba jimwa na ngasejapai mundu jumanya, lakini ngasejawesa kujoba. ");
INSERT INTO mgv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Papuje mbomba jumwa jwabii na kamwali waki jojabii ni ilombu, ejajoa lijambu laka Yesu, jahika nukulilekee pai palongi ja magolu gaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nyongoo we oju ngase jwabi Nyahude jwabii Ngiliki mwenei juku Silofoiniki. Ndi andoba Yesu amboa kamwali waki ilombu. ");
INSERT INTO mgv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu ampwagila, “Lendalya twaapekiya bana oti posu, ndaba ngasape kujukuu posu ja bana nukulekale jimbwa.” ");
INSERT INTO mgv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lakini nyongoo we jola ampwagila, “Sakaka, Bambu, hata jimbwa jejibii pai ja mesa ikula posu jejiigi jehahabwi bana.” ");
INSERT INTO mgv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ampwagila, “Ndaba jililobi alee, jenda kunyumba jaku. Kilombu se sela sumboi kamwali wako!” ");
INSERT INTO mgv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ndi jajenda kunyumba jaki, anketanya kamwali we jugoni pu mpandu, ni kilombu see sumboi. ");
INSERT INTO mgv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu jaboka kundema uku Tilo, nukupetee ku Sidoni, nu kuhika ku nhanga uku Galilaya kupete kundema uku Dekapoli maana jaki musi kome. ");
INSERT INTO mgv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ndipala bundeta kwaka Yesu kimumuta jwanga kujoa, bundoba ambekila maboku ili andamisa. ");
INSERT INTO mgv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu amboa mundu hoju munsambi wa bandu nu kunzingii ngonzi mwamakutu, jwahuna imata mulungonzi lwaki nu kuungusa mululimi lwaka mundu jola. ");
INSERT INTO mgv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ndi jalinga kunani kwa mahundi kwaka Sapanga, japomula kwa makili nukupwaga, “Efata,” maana jaki, “Hogukaje.” ");
INSERT INTO mgv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Apalapa mundu jola jawesa kujowana sapi nu kulongee sapi. ");
INSERT INTO mgv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu jaalagalakya bampwagi mundu jokapi lijambu lela. Lakini ngati ejalagalakya, ndi pabaendalya kulandi lijambu lelela. ");
INSERT INTO mgv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bandu basangii ngamaa nukupwaga, “Gajutei goa gaasapi. Jaatei hataa bandu banga kujoa ajogwana, naka kimumuta jwaawesisi alongila!” ");
INSERT INTO mgv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Masoba gala, nsambi wa bandu waketangini kabee, na ngasebabii na posu. Ndienu Yesu jaakema banafunzi baki, nakaapwaagi, ");
INSERT INTO mgv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naabonee ikia bandu haba ndaba abii nane masoba matatu, wala ngaseabii na posu. ");
INSERT INTO mgv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ana naalei ajendannya kunyumba, koni abii ni inzala biinduka mwiindela, ndaba bangi ahumiki kutali.” ");
INSERT INTO mgv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Banafunzi baki bundalukya, “Pamba jee pulukoba twiipata kwaa mabumunda gukutupii bandu boa haba?” ");
INSERT INTO mgv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu jaalalukya, “Boo mmbii na mabumunda malenga?” Nabombi bapwaaga, “Saba.” ");
INSERT INTO mgv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ndipala, jaamulisa bandu atama pai. Jwajukua mabumunda saba gala, ansengula Sapanga, nukuseku, nakaapekee banafunzi baki baabagila bandu, nabombi batenda kwaabagii. ");
INSERT INTO mgv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Babii kabee na homba isokuisoku. Yesu ansengula Sapanga, na kwaamulisa baabagila kabee bandu. ");
INSERT INTO mgv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bandu bakula, nukutupi. Banafunzi baki bakusanya ilebi yeyahigali batwelakya itonga saba. ");
INSERT INTO mgv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nabombi babalii mabumunda babii ngati bandu makomi nnsesi komi. Ndipala Yesu jwaamua kwaatabuka, ");
INSERT INTO mgv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","apalapa jakwela nhwatu pamu na banafunzi baki, jajenda kumusi juku Dalimanuta. ");
INSERT INTO mgv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afalisayu bahika kwaka Yesu, batumbulya kulonge naku sukumpendake. Koni apala jutenda nginyuli kuhuma kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu jwayoma mmoju, nukupwaga, “Ndaba jaki bandu ba masoba gani apala nginyulila? Numpwagi sakaka! Bandu habaa ngabiipati nginyuli jokape.” ");
INSERT INTO mgv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ndi jaaleka, jwakwela kabee nhwatu, nukutumbuli sapwali jwalomboka kujenda kwii ju nhanga. ");
INSERT INTO mgv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Banafunzi baki babia ajewiki kujukuu mabumunda, ila babii nilibumunda limwa pe munhwatu we gola. ");
INSERT INTO mgv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu jaalagalakya, “Ntama kutali nu kujepa amila jaka Afalisayu na amila jaka Helodi.” ");
INSERT INTO mgv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Banafunzi batumbulya kulaluana beni na beni, “Jupwaga hela ndaba ngasetubii na mabumunda.” ");
INSERT INTO mgv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu jabi jugamanyiki sebalongila, jaapwagila, “Mbona npwaganii lijambu lukukosa mabumunda? Mwakona lee ngasemmanyiki wala kuelewa? Mbona ngasenholalela? ");
INSERT INTO mgv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mmbii na miu lakini ngase nndinga? Mmbii na makutu lakini ngase nnzoana? Boo ngasenkomboka ");
INSERT INTO mgv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kipindi se sela panasekula mabumunda nwanu nakaapeke bandu elupu nhwano? Mwatondwi posu yeyahigali hitonga ilenga?” Bumpwagila, “Hitonga komi ni ibeli.” ");
INSERT INTO mgv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jaalalukya kabee “Na panasekula mabumunda saba na kwaapeke bandu elupu nsesi. Mwatondwi itonga ilee yeyatweli ipandi yeyahigalile?” Bapwaga, “Hitonga saba.” ");
INSERT INTO mgv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndipala jaapwagila, “Mwakona lee ngase nhelewa?” ");
INSERT INTO mgv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu jahika ku Betisaida pamu na banafunzi baki. Bandu bundetila mundu jwanga kulinga, bundoba angusa ili andamisa. ");
INSERT INTO mgv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ankamla kuboku mundu jwanga kulinga jola nuku mpeleka kunza ji kijiji. Anhunila imata, nukumbeke maboku, alapu anndalukyai, “Boo guwesa kukibona sindo sokape?” ");
INSERT INTO mgv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mundu we jola jwalinga kunani, nukupwaga, “Naabona bandu abonikana ngiti mikongu jejijenda.” ");
INSERT INTO mgv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ndi Yesu ambekila kabee maboku. Najombi jatupa mihu, jwalama miugaki nukuwesa kukibona kilasindu sapi. ");
INSERT INTO mgv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ampwagila jujenda kunyumba jaki anndagalakya, “Gwikelabuki kukijiji sela nakaapwagi bandu.” ");
INSERT INTO mgv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ndi Yesu na banafunzi baki bajenda kwiijiji yuku Kaisalia Pilipi. Pababii mwiindela, Yesu jaalalukiya banafunzi baki, “Boo bandu apwaaga nee nanyane?” ");
INSERT INTO mgv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bumpwagila, “Bangi apwaga we wa Yohana Mmbatisa, bangi apwaga we wa Elia na bangi apwaga wa mundu jumu kati ja Alota baka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Najombi jalalukya, “Mwanganya boo, mpwaaga nena nyane?” Petili japwaga, “We apa ndi Kilisitu jojuaguliwi na Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ndi Yesu jaakana bampwaagi mundu jokape majambu gala. ");
INSERT INTO mgv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu jatumbulya kabola banafunzi baki kupwaga, “Mwana waka Mundu lasima jung'alika ngamaa nukunka aseja na agolu akolongu na abola bamalagalaki. Biitenda kunkoma lakini jwiyoka kabee lisoba lya tatu.” ");
INSERT INTO mgv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu jaapwagila lijambu lee heli bila kuhiya sindu. Ndi Petili anhutila pulutengu nukunndakali jwipwaga lijambu le heli pagwendu. ");
INSERT INTO mgv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lakini Yesu jang'anambuka, jaalinga banafunzi baki, nukundakali Petili koni jakapwaaga, “Boka Lijobi wee! Mawasu gaku ngasegahuma kwaka Sapanga ila kwa bandu.” ");
INSERT INTO mgv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ndi jugukema nsambi wa bandu pamu na banafunzi baki nakaapwagi, “Ana mundu jokapi jojupai kunyengale ne, jupalika julikana mweni nu kujukua nsalaba waki, junyengalia. ");
INSERT INTO mgv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anaa mundu jojupala kugulenda womi waki mweni, jwiitenda kuguhoa, lakini mundu jojuhoa womi waki ndaba jami ne na ndaba ji Lijambu la Amboni, jwagulenda womi waki. ");
INSERT INTO mgv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Boo sanzangatya kii mundu ana jupatiki nndema woka nukuhoa napwasi jukujingii muwomi wa masoba goa? ");
INSERT INTO mgv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mundu jiipia sindu boo ndaba jukupata kabee womi wa masoba goa? ");
INSERT INTO mgv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundu jojumonee nepani iyoni pamu na mabola gangu mukibeleku senze siliya na sanga kummanya Sapanga, Mwana waka Mundu jwaammbonila iyoni mundu we hoju pajihika muukolongu wa Atati baki pamu na atumi bu kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu jaendalya kaapwagi, “Numpwagi sakaka, abii bandu bangi apambani ngaakui kabula jukuubona Ukolongu waka Sapanga wakahika kwamakili gingi.” ");
INSERT INTO mgv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Masoba sita egapeta Yesu jaajukua Petili na Yakobu na Yohana nukujenda nabu panani jikitombi kilasu kajika jabu. Kokuje Yesu bumbona jang'anambuka pamihu. ");
INSERT INTO mgv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ingobu yaki yabonikana ihulii kupukupu nga mundu jojuwesa kuing'alisa pani pundema ngati eyabii. ");
INSERT INTO mgv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Banafunzi atatu bala, bumbona Elia na Musa bakalongila na Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petili ampwagila Yesu, “Mbola, kwibia sapi ana twepani twitama apambane! Tusengaa indamba itatu simu saku na simu saka Musa, na sengi saka Elia.” ");
INSERT INTO mgv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petili na ajaki bajogapaa ngamaa mbaka ngasejamanyiki sukupwaaga. ");
INSERT INTO mgv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndi lapitila liundi nakayekale, na sauti jajogwanika kuhuma mulihundi lela, “Jonzo Mwanawango jonumpai, munzoannya!” ");
INSERT INTO mgv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Apalapa banafunzi baki balinga koni na koni, lakini ngasebummbona mundu jonge ila Yesu kajika jaki. ");
INSERT INTO mgv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndi pababia ahelee kuhuma kukitombi, Yesu jaakana, “Mwampwagi mundu jokapi majambu gamugabweni, mbaka Mwana waka Mundu pajiibia juyokiki kabee.” ");
INSERT INTO mgv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ndi bilikamula lilobi lela, lakini balaluana beni na beni, “Kuyoka ndi kyane?” ");
INSERT INTO mgv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bundalukya Yesu, “Ndaba jakii abola ba malagalaki apwaaga, lasima Elia julongulya kuhika hote?” ");
INSERT INTO mgv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Najombi japwaaga, “Hena, Elia jwiika oti kugabeka majambu goti sapi. Hata hela ndaba jakii aandiki Mmaandiku ga Sapi, Mwana waka Mundu jwing'alika ngamaa nu kuntondo? ");
INSERT INTO mgv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakini numpwagi, Elia juhikike na bandu buntendila ngati ebapala ngati Mahandiku ga Sapi egapwaga kundongale jombe.” ");
INSERT INTO mgv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu na banafunzi baki atatu pabahika pababii banafunzi bangi pala, bugubona nsambi nkolongu wa bandu papuje. Naka abola ba malagalaki babi pala bakabisana nabu. ");
INSERT INTO mgv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Apalapa bandu bala pabumbona Yesu boa basangii ngamaa, bummbutukya nukundamu. ");
INSERT INTO mgv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu jaalalukya banafunzi baki, “Mmbisanii kike?” ");
INSERT INTO mgv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Papuje mundu jumwa munsambi wa bandu jwajibwa, “Mbola, nundetiki mwanawango kwaku wenga, jubii ni ilombu yeyuntei jubia kimumuta. ");
INSERT INTO mgv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila eguntukalii, gunhabuu pai nukumpita lihuluhulu kundomo, nukumemena minu na kuba jojujomangini nhyega joa. Naaloba banafunzi baku bikiboa kilombu se hesi, lakini ngasebawesike.” ");
INSERT INTO mgv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu jaapwagila, “Mwanganya mwenhuma mukibeleku sanga kuhobale! Nitama na mwanganya mbaka lile? Nunhinakaliya mbaka lile? Munndeta nkombu we oju pani!” ");
INSERT INTO mgv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bumpelika kwaka Yesu. Apalapa kilombu se esumbona Yesu, sunzegala nkombu wejola kihinduhindu na jombi jaabuka pai, jagalubukana nukupita lihuluhulu kukanu, ");
INSERT INTO mgv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu andalukiya hengo waka nkombu we oju, “Majambu ge aga jwagapatiki tokalile?” Najombi ampwagila. Jatumbuka toka pajabii mwana. ");
INSERT INTO mgv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Mala jingi kilombu sehesi sunhabuki nkombu we hoju pa mwotu nu nmasi, ili kunkoma. Ndi anaguwesa, utubonila ikia nukutujangatii!” ");
INSERT INTO mgv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ampwagila, “Ndaba jakii gupwaga ana nhwesa! Majambu goa gawesikana kwaka mundu joju hobale.” ");
INSERT INTO mgv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ndi ahengo baki bajamalya kwa sauti, “Nihobalela! Lakini kuhobale kwangu kusoku unyangatiyaje nihobalya ngane!” ");
INSERT INTO mgv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pajugubona nsambi wa bandu gujonzukeka nyatanyata palongi jaki, jukilakaliya kilombu sela, “Kilombu we huntenda nkombu ajoo jubiya kimumuta na jwanga kujoa, nugulagalaki umboka nkombu hajo na wanzingii kabee!” ");
INSERT INTO mgv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Apalapa kilombu se sela, sajamaliya, nukunhabu pai nkombu we jola nukumpita. Nkombu jola jabonikana ngiti jojuwii hata bangi bapwaaga, “Juwii!” ");
INSERT INTO mgv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakini Yesu ankamula kuboku antondabya, najombi jwatenda kujumuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ndi Yesu ejajingala munyumba, pababii kajikajabu banafunzi baki bundalukya, “Ndaba jakii twe ngasetwawesiki kukiboa kilombu sela?” ");
INSERT INTO mgv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Najombi jaapwagila, “Kilombu ngati ase ngasekiwesa kuboka ila kwi indela jukundoba Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na banafunzi baki baboka pala baendalya na sapwali kupetee kundema uku Galilaya. Yesu ngasejapai bandu amanya kojubile, ");
INSERT INTO mgv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ndaba jabii jaabola banafunzi bake, jaapwagila, “Mwana waka Mundu bankabisa kwa bandu, nabombi biitenda kunkoma, lakini lisoba la tatu baada jukunkoma jwitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakini banafunzi baki ngasibamanyiki lijambu le hele, bajogopa kundalukii. ");
INSERT INTO mgv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ndi bahika ku Kapelinaumu, na pajabii kunyumba jwaalalukia, “Nkubika mmbisani kike?” ");
INSERT INTO mgv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakini bombi batenda kutumbaa, ndaba mwindela babia atenda kubisana nya jojabii nkolongu kati jabu. ");
INSERT INTO mgv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu jwatama pai, jwaakema komi na habeli bala, nakapwaagi, “Mundu najupai kuba nkolongu jupalika julihulua na kuba ntumisi wa boti.” ");
INSERT INTO mgv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ndi Yesu anzukua mwana nsoku nukunzemeka kati jabu, jwatenda kunzobate nakaapwagi, ");
INSERT INTO mgv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Joanzopa mwana ngati jonzo kwi liina langu, junyopa nepane. Jokapi jojunyopa nepani ngasejunyopa nepena anzopa jojundumike.” ");
INSERT INTO mgv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ndi Yohana ampwagila, “Mbola, tumbweni mundu jumu jupia ilombu kupete liina lako. Na twepani twatenda kunkana ndaba jombi nganzito.” ");
INSERT INTO mgv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lakini Yesu jaapwaga, “Mwaankana, ndaba ngamundu jojutenda nginyuli kwi liina langu koni jumbwaga nepani liyaa. ");
INSERT INTO mgv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndaba jwanga kutupenga twe jubii upandi wito. ");
INSERT INTO mgv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mundu jokapi jojampekya kikombi sa masi ga kunywa, ndaba mwanganya mwa bandu bangu nepana na Kilisitu sakaka ngajwikosi kupata nhupi yake.” ");
INSERT INTO mgv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ana mundu jokapi joantenda jumu ja asoku aba baanhobalee nepani kuhenga mahakau. Kwiibia mbanga mundu we hoju kunkongale lilibu nhingu nukunndeke kunhanga kuliku kutemuliwa na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ana kuboku kwaku kugulongulake gutenda mahakau, ugusekula! Mbanga kujingii kuwomi wa masoba goti nu kuboku kumwa, kuliku kuba na maboku goti mabele nukujenda kumwotu wa masoba goa wanga kususuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Momuje mipetupetu jaki ngasejikua na mwotu we ngasegususuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nu kugolu kwaku nakugukosisi sekula! Na mbanga kujingii kuwomi, nu kugolu kumwa kuliku na magolu goa mabeli nu kuguleke kumwotu wa masoba goa wanga kususuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Momuje mipetupetu jaki ngasejikua na mwotu we ngasegususuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na liu laku lukulongulake kutenda mahakau uliboa boa! Na mbanga kujingi ku Ukolongu waka Sapanga na liu limwa kuliku kuba na mihu goti mabeli nu kuguleke mumwotu wamasoba goa ngwanga kususuka. ");
INSERT INTO mgv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Momuje mipetupetu ngasejikua na mwotu we hogu ngasegususuka.’ ");
INSERT INTO mgv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ndaba kila mundu jwiisapisika kwa mwinyu ngati litambiku bilijosa kwa mwotu. ");
INSERT INTO mgv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyu sindu saasapi, lakini naguhalabiki wiitenda boo ili gunogaa kabee? “Mmbia na mwinyu gu ukosi nkati jii nu ntama pamu bila kulosana.” ");
INSERT INTO mgv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu jaboka papu jajenda ku Yudea, mbaka kwii juku losi luku Yoludani. Nsambi wa bandu gunzendila kabee, najombi jaabola kabee ngati ebayobali. ");
INSERT INTO mgv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ndi Afalisayu bunzendila nu kulenga kundaluki, “Boo malagalaki gaka Sapanga gajetake mwanalomi kuntalika nhwana mundo?” ");
INSERT INTO mgv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu japwaaga, “Musa jumpekya malagalaki bole?” ");
INSERT INTO mgv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nabombi bapwagaa, “Musa jalagalakya mwanalomi juwesa kunhandakii nhanuwaki likalatasi lukutalikana.” ");
INSERT INTO mgv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu jaapwagila, “Musa jalagalakya malagalaki ge haga ndaba ngasemmboleka. ");
INSERT INTO mgv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lakini Sapanga hejaabomba bandu bakwanza, jwaabomba mwanalomi numbomba ngati Maandiku ga Sapi egapwaga. ");
INSERT INTO mgv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na hela mwanalomi jaaleka ahengo na amabu nukulombana na ahanu bake, ");
INSERT INTO mgv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nabombi habeli haba bibia nhyega jimu. Na bombi ngaabele kabee ila nhyega jimu. ");
INSERT INTO mgv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndienu gajugalombiki Sapanga mundu ngakuwesa kugabaganisa.” ");
INSERT INTO mgv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pabajingala kabee munyumba, banafunzi baki bundalukya kupete lijambu lela. ");
INSERT INTO mgv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Najombi jaapwagila, “Jojwanndeka nhwanamundu nukunzukuu jongi, antendee ugoni nhwanu waki. ");
INSERT INTO mgv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ahelahe nu mbomba joandeka nndomi waki nukujenda kuulomu gongi najombi antendee ugoni nndomi waki.” ");
INSERT INTO mgv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bandu bundetila Yesu bana asoku ili jaagusa, lakini banafunzi baki batenda kalakalii. ");
INSERT INTO mgv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ejabona hela, jayoma nakaapwagi, “Mwaleka bana haba ahika kwango, wala mwaapengalee, ndaba Ukolongu waka Sapanga guhikiki ndaba ja bandu baabii ngati bana haba. ");
INSERT INTO mgv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Numpwagi sakaka, mundu jokapi jwanga kujetake Ukolongu waka Sapanga ngati mwana nsoku, ngajwi jingii mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ndipala, jaajopa bana bala, jaabekila maboku gaki nakaapenge. ");
INSERT INTO mgv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pajabia jutenda kuboka mundu jumwa anzombatakya nukun'gungamalii nukundaluki, “Mbola waamboni, ndendaboo nugupata womi wa masoba goa?” ");
INSERT INTO mgv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu japwaaga, “Ndaba jakii gungema nambone? Ngajojubii jwa amboni ila Sapanga kajika jaki. ");
INSERT INTO mgv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ugamanyi lee Malagalaki gaka Sapanga, ‘Witenda ugoni na wikoma na wijiiba na wikopake na wipwaga isoli na wajoannya ahengo baku na amabu baku.’ ” ");
INSERT INTO mgv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Najombi japwaga, “Mbola, haga goa nagakamwi toka muukombu wango.” ");
INSERT INTO mgv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu andingaliya, nukumpala, nukumpwagi, “Sindu simwa kitei kupunguu kwaku. Gujenda ukalombisa kila sindu segubinaku, gwapekya bandu banga na sindu lupija lweni, nanagu wiibia nikikoku kunani kwaka Sapanga. Ndienu gwihika kumbwata.” ");
INSERT INTO mgv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pajajowana ganiaga, jasoka makili, jajenda koni jubii nu usungu, ndaba jabii na mali gingi na ngasijapai kupia sindu sokapi. ");
INSERT INTO mgv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu jalinga pandi yoha, nakwapwagi banafunzi baki, “Kunonwipi ngamaa mundu jwana mali gingi kundeke Sapanga julongua womi waki!” ");
INSERT INTO mgv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Banafunzi balwehuki na malobi gaki. Yesu jaapwagila kabee, “Mwabanango, kunonwipi ngamaa kundeke Sapanga julongua womi waki! ");
INSERT INTO mgv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngati ekunonwipi kinyama sebikikema ngamia kupeta mwilihotu la sindanu, na ahelahe kubonikana kunonwipi, mundu jwana hindu kundeke Sapanga julongua womi waki!” ");
INSERT INTO mgv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Banafunzi baki basangia ngamaa nu kulaluana, “Henu nya jojwiwesa kulama?” ");
INSERT INTO mgv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu jalingaliya nakapwagi, “Kwa bandu ngakuwesikana, lakini kwaka Sapanga nga hela, ndaba kwaka Sapanga goa gawesikana.” ");
INSERT INTO mgv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petili ampwagila, “Linga! Natwe bo? Tukotwiki kila sindu, tugujengale we!” ");
INSERT INTO mgv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu japwaaga, “Numpwagi sakaka, mundu jokapi jojijilei nyumba au alongu baki au nndombu mundu au amabu au ahengo au bana au matui ndaba jaminee ni Lijambu la Amboni, ");
INSERT INTO mgv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jwiipata mala mia muda gongo, nyumba na akaalongu naalombumundu na nyongoo na bana na matui pamu nukung'alika, na muda gogwihika jijopa womi wa masoba goka. ");
INSERT INTO mgv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakini bandu bingi babilibona akolongu sajenu bibia asoku na babilibona asoku bibia akolongu.” ");
INSERT INTO mgv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ndienu, babii mwindela kujenda kunani ku Yelusalemu, na Yesu jwabiya jaalonguli. Banafunzi baki babii nikiholu, na bandu babunzengale munyuma batenda kujogopa. Yesu jaajukua kabee komi na habeli bala nukujendanabu pulutengo, nukutumbuli kaapwagi gagampitila. ");
INSERT INTO mgv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Japwagila, “Nzogwana tujenda ku Yelusalemu. Na hoku Mwana waka Mundu bumpelika kwaka agolu akolongu na abola bamalagalaki, nabombi bantemua kunkoma nukunkabisi kwa bandu banga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nabombi bitenda kunkangasaki, banhunila imata, bandapula migwandu nukunkoma. Lakini elihika lisoba la tatu jwiitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobu na Yohana, bana baka Zebedayu, bunzendila Yesu nukumpwagi, “Mbola, tupala utuhengila sindu setuguloba.” ");
INSERT INTO mgv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu jalalukya, “Mpala nunhengila kike?” ");
INSERT INTO mgv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bumpwagila, “Utujetakya kutama jumwa upandi wa malele na jongi upandi wa mangega pagwitama pikiteu saku su Ukolongu nu ulumbi waku.” ");
INSERT INTO mgv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu jaapwagila, “Ngasemwikimanyi se nndoba! Boo, nhwesa lee kuhinakali kunywele nzipuli ukung'alika goninywelila, nuubatisu ukung'alika ngati ebimatisa nenga?” ");
INSERT INTO mgv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bombi bumpwagila, “Tuwesa.” Yesu jaapwagila, “Sakaka nhwesa kunywele nzipuli ukung'alika nukuhinakalii ubatisu ukung'alika ngati ebimatisa. ");
INSERT INTO mgv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ila bandu babiitama kwa malele au kwa mangega kwangu, nga lihengu langune kupanga. Ila napwasi jeheji biipata bahaguliwi na Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Banafunzi bangi bala babajoana ganiaga, batenda kwayome Yakobu na Yohana. ");
INSERT INTO mgv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ndienu, Yesu jaakema, nakapwagi, “Mmanyiki baaholale kuba akolongu babandu banga Ayaudi, baalongoo bandu babu kwa makili. Na akolongu behaba abii nu uwesu nkolongu kwa bandu babu. ");
INSERT INTO mgv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lakini kwinu kwikuba hela, ila jojipala kuba nkolongu kati jinu, jupalika jubia ntumisi wino. ");
INSERT INTO mgv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jojupala kuba nkolongu kupeta boa, jupalika jubia mtumisi wa boa. ");
INSERT INTO mgv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndaba Mwana waka Mundu ngasejwahika kuntumakila, ila kwaatumikii bandu nukuboa womi waki ili kwaagombo bandu bingi.” ");
INSERT INTO mgv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ndienu, bahika ku Yeliko, najombi Yesu pajabii juhuma kumusi we hogu koni jubii na banafunzi baki pamu nu nsambi wa bandu. Mundu jumu jwanga kulinga, jobunkema Batilimayo, mwana waka Timayo, jojabii jutemi mulutengu jindela, jakaloba. ");
INSERT INTO mgv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pajajowana Yesu juku Nazaleti jabii jupeta papu, jatumbulya kujamalii, “Yesu, mwana waka Daudi, gumonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bandu bingi bundakalya jutama kinunu, lakini jombi jaendalya kujamalii, “Mwana waka Daudi, gumonila ikia.” ");
INSERT INTO mgv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu jajema nukupwaga, “Munkema.” Ndienu bunkema jwanga kulinga we hoju nukumpwagi, “Wijogopa! Jema, jugukema.” ");
INSERT INTO mgv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Najombi jalekala kutali gungobu gwaki, jahomba kunani, nukumpwata Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu andalukiya, “Boo gupala nuguhengila kike?” Jwanga linga we jola ampwagila. “Mbola, nanoba nhwesa kulinga.” ");
INSERT INTO mgv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ampwagila, “Jendaje, kuhobale kwaku kugulamisi.” Apalapa, mundu jwanga kulinga we jola jwawesa nukulinga, nukunzengale Yesu mwiindela. ");
INSERT INTO mgv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na banafunzi baki, pababia ahegale ku Yelusalemu bahika ku Betifage nuku Betania, pambipi ni Kitombi si Mizeituni. Papuje jaatuma banafunzi baki abeli, ");
INSERT INTO mgv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Japwagila, “Nzendanya kijiji sekibii palongi jinu. Emwihika kola, mwalikolila liponda bilikongiki, lelu le ngasejujendii mundu jokapi. Mulibopula mulileta. ");
INSERT INTO mgv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ana mundu jundaluki, ‘Ndaba jakii huhenga hela?’ Mumpwagila, ‘Jilipala Bambu jwalikelebuha kabee nyata.’ ” ");
INSERT INTO mgv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ndienu bajenda, biliketanya liponda leni bilikongiki pundyangu wa nyumba pambipi ni indela. Pababia bilibopo, ");
INSERT INTO mgv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bandu bangi bababii ajemiki papuje baalalukya, “Ndaba jakii mwilibopoo liponda hele?” ");
INSERT INTO mgv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Banafunzi bapwagaa ngati Yesu ejwaalagalaki, na bandu bala baaleka ajenda nalu. ");
INSERT INTO mgv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bumpelakya Yesu liponda lela. Batandiki ingobu yabu panani jili ponda na Yesu jatemi panani jaki. ");
INSERT INTO mgv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bandu bingi batandika ingobu yabu mwiindela ili kuntende hisima, bangi batandika matutu gabasekula mwilitui. ");
INSERT INTO mgv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bandu boa babalongulii na babajengalya munyuma, bajamalya koni bakapwaga, “Ulumbi waka Sapanga! Jumpengelika jojuhika kwiliina laka Bambu! ");
INSERT INTO mgv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ulumbaliwa ukolongu goguhika wa ahengo bitu Daudi. Ulumbii kwaka Sapanga kunani kwa mahundi!” ");
INSERT INTO mgv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu jajingala kumusi uku Yelusalemu jajenda mbaka mu Nyumba jaka Sapanga, jwalinga kila sindu sukutupii mihu. Lakini ndaba kwabia pakamii, jajenda ku Betania pamu na komi na habeli. ");
INSERT INTO mgv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kilabu jaki, pababia ahuma ku Betania, Yesu jummbina inzala. ");
INSERT INTO mgv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ndienu, jugubona sukutali nkongu wu ntini wana mahamba gingi. Jugujendila jugubona ana gubii nili tunda lokapi. Pajuguhikila, juguketanya ngasegubii ni litunda lokapi ila mahamba matopu, ndaba ngasiwabia muda hukupapa. ");
INSERT INTO mgv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Papuje jugupwagila nkoju we gola, “Kutumbuka leleno nga mundu jojikula matunda gaku kabee.” Nabombi banafunzi baki bajoa malobi ge haga. ");
INSERT INTO mgv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ndipala, bahika ku Yelusalemu, Yesu jajingala Munyumba jaka Sapanga nukutumbulii kwaabengee kunza bandu bababia alombesa nu kulomba indu momu. Japendula mesa ya bandu bababia ang'anambulana lupija, ni iteu ya bandu bababia alombesa ngunda. ");
INSERT INTO mgv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ngase anzetakii mundu jokapi jola kupita nasindu sokapi pulubanza ja Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ndipala jaabola, “Aandiki, ‘Nyumba jangu jiibia Nyumba jukundobe Sapanga!’ Lakini mwanganya mjitei jibia ngati kipoli sa bii!” ");
INSERT INTO mgv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Agolu akolongu na abola bamalagalaki ebajoana ganaga, batumbulya kutaputa indela jukunkoma. Lakini bunzogupa ndaba nsambi wa bandu gwalweuki na mabolee gaki. ");
INSERT INTO mgv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pakwabia pakamii, Yesu na banafunzi baki bajenda kumusi. ");
INSERT INTO mgv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lukela ngani, pababia atenda kupeta bugubona nkoju we gola gunyaliki ngani, kuhumi mikega mbaka kulubekubeku. ");
INSERT INTO mgv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petili jugukombuka, ampwagila Yesu, “Mbola, linga! Nkongu we gola gouguligila, gunyalike!” ");
INSERT INTO mgv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ampwagila, “Munhobalya Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Numpwagi sakaka, mundu najikipwagi kitombi ase, ‘Tupuka ukililekala munhanga,’ Bila kujogopa mmyoju jaki, ila anajuhobali majambu goka gajupwagiki gahengeka, sakaka litenda kuhengeka kupete Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Henu numpwagii, pansali nukuloba sindu, nhobaliya oti mukijopiki, nanamu mwitenda kupata. ");
INSERT INTO mgv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Panzema kusali, nukuloba sindu, mundekakya kila mundu jojunkosii sokapi, na Atati binu bababii kunani bandekakiya mahakau gino. ");
INSERT INTO mgv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lakini ana ngasemwaalekaki bangi, hata Ahengo binu baabii kunani kwa ngabandekake mwanganya mahakau ginu.” ");
INSERT INTO mgv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ndienu bahika kabee ku Yelusalemu. Yesu pajabia jujenda kabee pa Nyumba jaka Sapanga, agolu akolongu, abola bamalagalaki na aseja bunzendila, ");
INSERT INTO mgv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bundalukya, “Guhenga mahengu ge aga kupete kuuwesu waka nyane? Nya jojugupeki uwesu ukuhenga mahengu ge aga?” ");
INSERT INTO mgv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lakini Yesu ampwagila, “Ngiti nundalukya sindu simu. Anannyibwiki, nane nampwagila henga mahengu ge aga kupete luhusa jaka nyaa. ");
INSERT INTO mgv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nnyibwaje, boo, mbwagila ubatisu waka Yohana guhuma kwaka Sapanga au kwa bandu?” ");
INSERT INTO mgv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Batumbulya kulaluana, “Anatupwagiki, ‘Gahuma kwaka Sapanga,’ Jwaatulalukya, ‘Ndaba jaki ngasemwahobalile?’ ");
INSERT INTO mgv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Anatupwagiki, ‘Gahuma kwa bandu,’ kwibia bole?” Bajogupa nsambi wa bandu ndaba boa bamanyiki Yohana jabii Mlota waka Sapanga sakaka. ");
INSERT INTO mgv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ndienu, bumpwagila Yesu, “Twe ngasetumanyike.” Najombi Yesu jaapwagila, “Nanee nganumpwagi nihenga mahengu agaa kupetee luhusa jaka nyane.” ");
INSERT INTO mgv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu jatumbulya kupwaga nabu kwa malenganu jakapwaga, “Mundu jumu jalemiki litui li mizabibu. Jiliyongulaki ukuta, ni pikilanda je jahemba libomba lukuminyi divai, jasenga kabee kindamba su ulonda. Jwaapangisi litui lee heli bandu bukulema, mweni jajenda kumusi ukutali. ");
INSERT INTO mgv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Muda hukuhusa hewahikaa, antuma ntumi waki kwa bandu baalema bala, andetila ilebi yaakumu yeipatikini mulituhi laki. ");
INSERT INTO mgv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Alemu be bala bunkamula, bundapula, nukunkelabuu sanga kumpeke sindu sokapi. ");
INSERT INTO mgv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Antuma kabee ntumi jongi. Hoju kabee bundapula mumutu nukumpoa lihamu. ");
INSERT INTO mgv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jwini litui jola antuma ntumi jongi kabee jojuwe alemu bala batenda kunkoma. Bangi bingi bajaatuma, bangi batenda kalapu, na bingi batenda kwaakoma. ");
INSERT INTO mgv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Jahigalii na mundu jumu, yani mwanamundu joampai. Mwisu weni antuma joju nukupwaga, ‘Mwana wangu biitenda kunzogopa.’ ");
INSERT INTO mgv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lakini alemu be haba bapwaganya, ‘Jonzo ndi jobanndek lituhi lenu, ndienu, tunkoma ili litui libia litu!’ ");
INSERT INTO mgv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ndipala bunkamula, bunkoma nukundekee kunza ji litui li mizabibu lela.” ");
INSERT INTO mgv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Enu, jwini litui jwitenda kike? “Jwihika kaakoma alemu bala nukupangisa litui li mizabibu lela kwa bandu bangi. ");
INSERT INTO mgv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Boo, ngasensomiki Maandiku ga Sapi? ‘Lilibu lebilikaniki bandu baasenga, henu ndi lilibu lunsingi. ");
INSERT INTO mgv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bambu ndi jojuhengiki lihengu lee heli, nalombi lisangasa ngamaa kwitu!’ ” ");
INSERT INTO mgv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aka agolu akolongu naka abola bamalagalaki na aseja bamanyiki malenganu gala gaahusu bombi. Ndienu balenga kunkamuu, lakini bugujogopa nsambi wa bandu. Henu, baamua kunndeka nukubokane. ");
INSERT INTO mgv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ndienu, baamua kwaatuma aka Afalisayu bangi na banafunzi baka Helodi bumpendakaliya Yesu kwa malobi gaki. ");
INSERT INTO mgv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bunzendila Yesu, nukumpwagi, “Mbola, tumanyiki weapa wa mundu wa mwanahota wogupwaga sakaka pena, ndaba ngase gunzogopa mundu jokapi. Wala ukolongu waka mundu nga sindu kwako, lakini waabola bandu sakaka kupete indela jaka Sapanga. Boo, sapi lee kulepa kodi kwaka bambu nkolongu juku Loma Kaisale? Tulepaje au lee Twilepa?” ");
INSERT INTO mgv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lakini Yesu jukumanyiki kukopake kwabu, jaapwagila, “Mbona ntenda kunenga? Netila lupija alo hoti.” ");
INSERT INTO mgv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bumpelakya lupija. Najombi jaalalukya, “Sula ni liina ale laka nyane?” Bumpwagila, “Jaka bambu nkolongu juku Loma.” ");
INSERT INTO mgv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndienu, Yesu ampwagila, “Gagabi guku nkolongu juku Loma mumpekya nkolongu juku Loma, na gaka Sapanga mumpekya Sapanga.” Bunsangi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ndipala Asadukayu baapwaga bandu ngaseayoka kabee bunzendila Yesu, nukunndaluki, ");
INSERT INTO mgv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mbola, Musa jutulagalakya ana, ‘Mundu ana juwii bila kundeke nhwanu waki mwana, ndongu waki lasima anzukua mbomba mmbabi jola, ili ambelakya nndongumundu jojuwii jola bana.’ ");
INSERT INTO mgv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tupwaga kwabii naka kilongu saba, jwa kwanza jajukwii mmbomba, jakuwa bila kundeka mwana. ");
INSERT INTO mgv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nndonguwaki wa pili anzukua mbomba mmbabi jola, najombi kabee jakuwa bila kundeka mwana, nundongu wa tatu kwabii ahelahe. ");
INSERT INTO mgv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Boti saba bakua bila kundeka mwana. Masoba egapeta mbomba mmbabi najombi jwatenda kuwa. ");
INSERT INTO mgv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Henu, lisoba lukuyoka bandu, mmbomba we hoju jwibia nhanu waka nyane? Ndaba akanalomi boa saba babia anzukwi.” ");
INSERT INTO mgv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu jaapwagila, “Mwanganya nkose, ndaba ngasemgamanya Maandiku ga Sapi wala makili gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndaba baawii pabiyoka ngabiijukuu wala kujukulika, biibia ngati Atumi bu kunani kwa mahunde. ");
INSERT INTO mgv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lakini kupete kuyoka bandu baawii, boo, ngasensomiki lee kitabu saka Musa maala papapwaga kitengu sekinyaka mwoto? Sapanga ampwagila Musa, ‘Nepani Sapanga waka Ibulahimu na Sapanga waka Isaka na Sapanga waka Yakobo.’ ");
INSERT INTO mgv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ndienu, jombi nga Sapanga wa bandu bawile, nena Sapanga wa bandu bome. Mwanganya ntei kukosie.” ");
INSERT INTO mgv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jumu kati jaabola abola wa malagalaki jahika, nukujoana kubisana kwabu. Paambona Yesu jaapwagi gasapi, japitila nukundaluki, “Kati ja malagi goka malagalaki boo makolongo?” ");
INSERT INTO mgv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ampwagila, “Malagi makolongu ndi ganga, ‘Nzoannya mwa bandu buku Izilaeli! Bambu Sapanga witu, ndi kajika jaki Bambu. ");
INSERT INTO mgv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gumpalaa Bambu Sapanga waku kwa mwoju waku woti, kwa womi waku woti, kwa malangu gaku goti na kwa makili gaku goti.’ ");
INSERT INTO mgv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na ja pili ndi aje, ‘Gumpala nzako ngati eulipala wamwete.’ Ngakuba malagi gangi gagabi makolongu kupeta haga.” ");
INSERT INTO mgv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ndienu, mbola wa malagalaki, ampwagila, “Sapi Mbola! Gupwagiki sakaka Bambu ndi Sapanga kajika ngakuba jonge ila jombi.” ");
INSERT INTO mgv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gumpala Sapanga waku kwa moju waki woti, kwa malangu gaki goa, na kwa makili gaki goa, nukumpala wapambijaku ngati eulipala wamwete. Lijambu heli likolongu kupeta matambiku goa gu kukoma na matambiku gangi. ");
INSERT INTO mgv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pajabona mundu jola jujibwiki kwamalangu, ampwagila, “Weapa ngasegubii kutali kundekee Sapanga julongua womi wako.” Ndienu, ngakuba mundu jojawesa kabee kundaluki sindu. ");
INSERT INTO mgv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu pajabia jwaabola bandu mu Nyumba jaka Sapanga, balalukya, “Ndaba jakii abola ba malagalaki apwaga Kilisitu mwana waka Daudi pena kati ja bana bake? ");
INSERT INTO mgv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi wee pajunndonguwa Loho Jaasapi, jwapwaga, ‘Bambu ampwagila Bambu wango Tama upandi wangu uku malele, mbaka panaabeka abaya baku pai ja magolu gako.’ ");
INSERT INTO mgv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi we ankema Kilisitu, ‘Bambu,’ enu, kwibia boo Kilisitu jubia mwana wake?” Nsambi wa bandu wabia utenda kunzowanela koni atogulela. ");
INSERT INTO mgv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mmabolee gaki, Yesu jaapwaga, “Nzepana naka abola ba malagalaki babube apai kupetapeta koniaweti ingobu nasu nakalamuu bandu kwi isima kuguliu. ");
INSERT INTO mgv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kabee apala kutama palongi pandu pini isima mu nyumba jukuketangane Ayaudi, nu kujukuu napwasi jiniisima kutipati. ");
INSERT INTO mgv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Baajibii bandu baawii alomi babu nyumba na mali gabu, lakini eajenda kunyumba jaka Sapanga aloba kipindi kilasu! Lisoba la mwiso kung'alika kwabu kwibia kukolongu.” ");
INSERT INTO mgv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu jabia jutami pambipi ni kikoku silitambiku. Jabia julingali bandu bingi ebabia apia lupija nukujegee mwikikoku Sunyumba jaka Sapanga. Babii na indu hingi bapia lupija lwinge. ");
INSERT INTO mgv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Papuje jwahika nyongoo jumu joawii alomi jojuwe jwabii kapuku, japia mangengalema mabele masoku gulupija. ");
INSERT INTO mgv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Papuje Yesu jaakema banafunzi baki, jaapwagila, “Sakaka numpwagii, nyongoo joawii alomi hajoo nuukapuku gojubii naku jupiiki lupija lwingi kupeta loajegi bangi boa. ");
INSERT INTO mgv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndaba bangi boa apiiki hindu yeabagwi mukikoku sa indu yabu hingi, lakini mbujamundu hajo jupiiki yoa yejubinaku, jupiiki kila sindu sesabia sunzangatia.” ");
INSERT INTO mgv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ejwabia jupita mu Nyumba jaka Sapanga jumu wa banafunzi baki ampwagila, “Mbola, linga malibu ganga moganyambiki na manyumba gaanga mogakoliki!” ");
INSERT INTO mgv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu jaapwagila, “Boo wagabweni lee manyumba agaga mogabeli makolongo? Ngaliigali hata lilibu limwa panani jililibu lengi, kila sindu siitenda kubomboka.” ");
INSERT INTO mgv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu pajabia jutemi panani ji Kitombi si Mizeituni pajajenda ku Nyumba jaka Sapanga, Petili na Yakobu na Yohana na Andilea pababi pakajika bunndalukiya, ");
INSERT INTO mgv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tumpwagila majambu ge haga gipitila lile, kabee nginyuli bole jejilangia majambu ge haga gabi pambipi kupitila?” ");
INSERT INTO mgv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu jatumbulya kaapwagi, “Mulilenda jankonga mundu jokapi jola. ");
INSERT INTO mgv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ndaba bandu bingi bihika nukutumii liina lango, kila mundu jwiipwaga, ‘Jombi ndi nepani!’ Nabombi baakolua bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pamwijoana ndema jimu jikomana na ndema jengi, mwijogopa. Ganiaga gee lasima gapitila hoti, lakini mwisu wee wibia wakona. ");
INSERT INTO mgv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ndema gumwa wikomana nu nndema gongi, ukolongu gumwa wikomana nu ukolongu gongi, kila nndema gwiibia nikililima niinzala. Majambu ge haga gabii ngati kubina kwaka mundu jojuhegalekubeleka mwana. ");
INSERT INTO mgv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Lakini mwanganya nnzepa. Ndaba bandu bampelika kuntaki pasengu, nukundapu iboku mu nyumba jukuketangane Ayaudi. Bampelika palongi ju ukolongu na kwaka bambu nkolongu ndaba jangu, ndaba mwapwagila lijambu langu ne. ");
INSERT INTO mgv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lakini kupalika Lijambu la Amboni lilandilika kwa bandu bamakabila goti. ");
INSERT INTO mgv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nabombi pabaakema kilasima na kapeleka kuntaki pasengu, mwiholale su kupwaga. Muda gwe egwihika mpwaaga sokapi sebampekya, ndaba nga mwanganya momwipwaga, ila Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nndongu jumu anng'anumbuka nndongu waki bunkoma, na hengo jitenda ahelahela kwaka mwanamundu, bana nabombi baang'anumbuka atati na amabu babu ndaba jakwaakoma. ");
INSERT INTO mgv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bandu boa babansukila mwanganya ndaba ji liina langu ne. Lakini jojwihinakalya mbaka pa mwisu ndi Sapanga janhokuwa kuhuma mwamang'aliku gamasoba goha.” ");
INSERT INTO mgv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pamwalibona Liyomisu lukualabana lijemiki pandu panga paki,” Jojusoma jumanya ndaba jaki. “Ndi, baabii ku Yudea atililaa kwitombi. ");
INSERT INTO mgv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jojubii kunza jwiselewa kujingi munyumba jaki jutila, na jwiselewa ndaba ju kujingii mu nyumba jaki kujuku sindo! ");
INSERT INTO mgv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ahelahe jojubii kutui jwikelabuka kunyumba jaki kujukuu ingobu yaki. ");
INSERT INTO mgv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nabone usungu ndaba jaakambomba bini itumbu na bajongesa masoba ge haga bibia ang'alika ngamaa! ");
INSERT INTO mgv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nndoba ili mahengu ge haga giipiti muda ukipepu. ");
INSERT INTO mgv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Masoba ge haga kwikuba ni ling'ai lelule ngaseliwahiki kupiti tumbuka Sapanga pajwabomba nndema mbaka lelenu, na nga kwipitii kabee. ");
INSERT INTO mgv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ana Bambu ngajakapungwisi masoba ge aga ngajakabii mundu jojakalamaje. Lakini ndaba ja banafunzi baki ba jwaagwi, Bambu jaamua kupungusa masoba ge haga. ");
INSERT INTO mgv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ndienu mundu ana jumpwagi, ‘Linga, Kilisitu jubii pamba,’ Au ‘Jubii palapa,’ Mwanhobale. ");
INSERT INTO mgv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ndaba bipitila bandu aka Kilisitu biisoli naka alota biisoli, bihenga nginyuli yu kusangasa, ndaba jakaakolo bandu baka Sapanga ana ngati kuwesakini. ");
INSERT INTO mgv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lakini mwanganya nnzepa. Ne numpwagi majambu goa kabula ngasegapitii.” ");
INSERT INTO mgv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ndienu masoba ge haga hegwipeta pe uhagu we hogu, lyoba baalijegala lwii na mwehi ngagwinang'ane.” ");
INSERT INTO mgv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondu hiabuka kuhuma kunani, namakili gukunani kwaka Sapanga gitenda kunyuka. ");
INSERT INTO mgv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Papuje mwambona, Mwana waka Mundu, jakahika kuhuma kwa mahundi kwa makili gingi nu ulumbi. ");
INSERT INTO mgv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ndipala jaatuma atumi baki baakusanya bandu bajahagwi Sapanga kuhuma pandi yoka nnsesi yu pundema. Hata kuhuma kumwisu ukutali ukundema mbaka mwisu ukunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mulibola hagaa kuhuma munkongu nkoju, mambandi gaki egatumbulii kutunduli tuu nukupia manyoi, mmanya kipindi si iyula kihegalile. ");
INSERT INTO mgv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hataa hela, nanamu emwiibona mahengu ge haga gakahengika, mmanya Mwana waka Mundu jubii pambipi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Numpwagi sakaka, kibeleku ase ngasipeti mbaka majambu haga pagipitila. ");
INSERT INTO mgv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunani kwa mahundi nu nndema gwipeta, ila malobi gangu gitimia ngati embwagike. ");
INSERT INTO mgv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Lakini mwilisoba la mwisu, nga mundu jojumanyiki libia lile, wala lisaa boo, wala atumi bu kunani kwa mahundi kwaka Sapanga, wala Mwana waka Sapanga. Ila Atati a Sapanga kajika jabu ndi baamanyiki. ");
INSERT INTO mgv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nnzepa nu kutama mihu, ndaba ngasemmanyiki kipindi sekihika. ");
INSERT INTO mgv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kwibia ngati mundu jojuboka panyumba kujenda sapwali nakwaleke atumi baki ukolongu, kila mundu ni lihengu laki, nukumpwagi mlonda ju pundyangu jubia mihu. ");
INSERT INTO mgv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mliandia, ndaba ngasemmanyiki jwana nyumba jwibuja lii. Tosa kwibia pakamii au pamahiku au mokukusa au pulukela. ");
INSERT INTO mgv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mliandia, ili anajihika sukusituki, jaankole nngoni. ");
INSERT INTO mgv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ganumpwagi mwanganya, numpwagi mwaboa. Ntama mihu!” ");
INSERT INTO mgv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gahigali masoba mabeli kuhika Lisoba likolongu la Pasaka ni lisoba la kula mabumunda ganga kubeka Lisali. Agolu akolongu na abola bamalagalaki bataputa indela jukunkamu Yesu suujanza ndaba kunkoma. ");
INSERT INTO mgv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lakini bapwagannya, “Twihenga hela Lisoba la Pasaka, bandu bileta pujuu.” ");
INSERT INTO mgv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu jwabii ku Betania, munyumba jaka Simoni jojabii juleliki. Pajabia jukula posu, mmbomba jumu jojabii ni lisupa lealenganaki kwi lilibu lebilikema alubasita lelibii na mahuta gaganungali sapi gabagakema naludo, jahika pala nukuhogo lisupa lela nukunzakanii Yesu mauta gegala kumutu. ");
INSERT INTO mgv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bandu bangi bababi pala batenda kuyoma, bapwaaga, “Ndaba jakii ajoo juhoa mahuta agaga? ");
INSERT INTO mgv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mahuta geaga jwakawesaa kugalombesa nukupata lupija lwingi, nakwapekee bandu aka kahosu!” Bundakalia mmbomba we jola. ");
INSERT INTO mgv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ndienu Yesu jaapwagila, “Mundekaaje! Ndaba jaki kunsumbua? Jundendi lijambu la sapi. ");
INSERT INTO mgv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bandu akahosu mmbii nabu masoba goka, nhwesa kwaajangati masoba gokapi gampai. Lakini nepani nganiikubi na mwanganya masoba goka. ");
INSERT INTO mgv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mmbomba hoju jutei sejuwesiki. Jujakanii nhyega jangu mahuta gaganungi ndaba jeni kujitayalisa nhyega ja pabiisika. ");
INSERT INTO mgv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Numpwagi sakaka, pokapi pundema pani pabiilandila Lijambu la Amboni lihengu lejuhengiki mbomba hale baalilogula ndaba juku nkomboka nyongo we hoju.” ");
INSERT INTO mgv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ndipala, Yuda Isikalioti, jumu kati ja banafunzi komi na habeli, jajenda kwaka agolu ili kung'anambuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Agolu akolongu pabajoa lijambu lee batenda kutogule, nukundagi kumpekee lupija. Ndienu, Yuda jatumbuka kutaputa mbekenyu ju kunng'anambuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lisoba lu kutumbuka la Mabumunda ganga ni Lisali, lisoba leasinza likondoo lya Pasaka, banafunzi baki bundalukya, “Gupala tuguhandalya kwako pandu pakula pasaka?” ");
INSERT INTO mgv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ndienu Yesu jaatuma banafunzi baki habeli jaapwagila, “Nzendanya kumusi, na momuje mwanketanya mwanalomi jumu jojutotwi kibega sa masi. Mukunzengalyaje, ");
INSERT INTO mgv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka mu nyumba jejakajingala, mukupwagila junanyumba jola, ‘Mbola jupwaga, sumba sangu monilelila Pasaka pamu na banafunzi bango kibi kwako?’ ");
INSERT INTO mgv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Najombi jandangia sumba kikolongu kugolopa seahandii nukukilenganake sapi. Mutuandalya momu.” ");
INSERT INTO mgv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Banafunzi bala baboka, nukujenda kumusi, bukuketanya kila sindu kibii sapi ngati Yesu ejwabia jaapwagi. Ndienu baandia posu ja Pasaka momu. ");
INSERT INTO mgv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pakwahika pakamii, Yesu jahika papu pamu na banafunzi baki komi na habeli. ");
INSERT INTO mgv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pababia pamu bakakula, Yesu japwaga, “Sakaka numpwagi, jumu wi jojukula pamu nanee, jwindenda kunng'anambuka.” ");
INSERT INTO mgv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Papuje banafunzi baki batumbuka kuyoma, bundalukya jumujumu, “Boo, nepane?” ");
INSERT INTO mgv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu jaapwagila, “Kati jinu mwanganya komi na habeli mwe, jojutobakee libumunda pamu nane mbakuli. ");
INSERT INTO mgv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sakaka, Mwana waka Mundu jwitenda kuwa ngati Maandiku ga Sapi egapwagiki. Lakini jakibona mundu jo ang'anumbuka Mwana waka Mundu! Kwakabia sapi ana mundu we hoju jakabia nga kusaliwa!” ");
INSERT INTO mgv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pababia bakakula, Yesu jwajukua libumunda, nukunsengu Sapanga, jasekula na kapeke banafunzi baki koni jakapwaga, “Nzukua, nkula, jenze nhyega jango.” ");
INSERT INTO mgv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ndipala, jajukua nzipuli wa divai, ansengula Sapanga, nakaapeke boa banywaa divai kupete nzipuli we hogu. ");
INSERT INTO mgv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jaapwagila, “Gongo mwai wango goguhakikisa lilaganu laka Sapanga, mwai gogujitika ndaba jakalekake bandu bingi mahakau gabu. ");
INSERT INTO mgv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Sakaka nupwagii, ngangunywi kabee divai mbaka lisoba lela paniywaa kabee mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndipala bajemba nhwambu ukunsengu Sapanga, baboka kujenda ku Kitombi si Mizeituni. ");
INSERT INTO mgv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu jaapwagila banafunzi baki, “Mwanganya mwaboa mwindenda kundila nukuneka ngati ebaandiki mu Maandiku ga Sapi Sapanga jupwaga, ‘Nankoma nndima, nagombi makondoo gitenda kuyetuana.’ ");
INSERT INTO mgv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakini ana nhyokiki, nandongulya ku Galilaya kola.” ");
INSERT INTO mgv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petili japwaga, “Hataa ngati boa bikuba ni kiholu nawehapa nukuguleka, ne nganaguleke hata kidogu!” ");
INSERT INTO mgv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ampwagila, “Sakaka nugupwagi, ikilu jenze, kabula ji likongobi kubeka mala pabeli, wingana mala patato ngati ngasegumanyiki.” ");
INSERT INTO mgv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lakini Petili jahingamakya, “Hata nakubii kuwa pamu nawehapa, nganaguleki hata kasokopi.” Banafunzi boa nabombi bapwaga ahelahee. ");
INSERT INTO mgv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ndienu, bahika kukijongu sebikikema Getisemani. Yesu jaapwagila banafunzi baki, “Ntamaniya pamba ne panundoba Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ndipala jaajukua Petili na Yakobu na Yohana. Jatumbulya kuhusunika ngamaa nu kuangajika. ");
INSERT INTO mgv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jaapwagila, “Neyomiki ngamaa mmyoju kalibu jakuwa. Nhigalya hapa ntama mihu.” ");
INSERT INTO mgv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jajenda palongi kidogu, jililekala pai suku gungamali, jaloba ana, ana kwakawesikini, niipete lisaa luku ng'alika. ");
INSERT INTO mgv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Japwaga, “Atati bangu, kwaku weapa majambu goa gawesikana. Gumokia nzipuli gongo gukung'alika. Lakini kwikuba ngati embalane, ila kubia ngati egupala wee.” ");
INSERT INTO mgv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ndipala jakelubuka kwaka banafunzi baki atatu, jakolila agoni. Ndienu, andalukiya Petili, “Boo, Simoni, ntei lee kugonela? Ngasewawesiki lee kutama mihu hata lisaa limo?” ");
INSERT INTO mgv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndipala jaapwagila, “Ntama mihu nu kuloba ili mwihika kujingii mwi milengu. Moju gupala, lakini nhyega ngasejipala.” ");
INSERT INTO mgv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jwajenda kuloba kabee konijukelabuki malobi agalaga. ");
INSERT INTO mgv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ndienu jakelubukia kabee, jaakoli agoni. Mihu gabu gatweli lugonu. Ngasibamanyiki sukumpwagi. ");
INSERT INTO mgv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ejahika mala ja tatu jaapwagila, “Mwakona lee nngonile nu kupomulela? Enu kutosike! Muda guhikiki! Mwana waka Mundu banzegala mmaboku ga bandu biliya. ");
INSERT INTO mgv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nzumukannya, tubokannya, nndingaliya, jojwing'anambuka ne juhegalii.” ");
INSERT INTO mgv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ejwabia jakona jakapwaga, Yuda jumu kati ja banafunzi baki komi na habeli jahika. Jahika pamu nu nsambi wa bandu baabii na mapanga niindonga. Bandu be bala babia baatumiki agolu akolongu na abola bamalagalaki na akahokomundu. ");
INSERT INTO mgv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda joang'anumbuka Yesu, jabia jaatendi nginyuli, “Jonukunzobatiya ndi ajolajo. Mukamula nukumbeka paijuulonda wino.” ");
INSERT INTO mgv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda ejahika pe, anzendila Yesu, ampwagila, “Mbola!” Nukunzobatee. ");
INSERT INTO mgv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ndienu, bandu be bala bunkamula Yesu, nukunkamulaki nntoo. ");
INSERT INTO mgv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jumu kati jabu jojabia jujemiki papuje pamu na Yesu, jahopula mpanga waki, nukundapu ntumi waka Nngolu Nkolongu nukunseku likutu. ");
INSERT INTO mgv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu jaapwagila, “Boo, nhikiki na mapanga ni indonga kunyonza ne ngati ne na mundu jo nyaga hindu? ");
INSERT INTO mgv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila lisoba panabii pamu na mwanganya nabola bandu mu Nyumba jaka Sapanga, wala ngase mwanyonzike. Lakini enu Maandiku ga Sapi gatimi.” ");
INSERT INTO mgv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Papuje banafunzi boa bundeka, nukuntila. ");
INSERT INTO mgv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jwabi nkombu jumu jojuliyekiki shuka pee annzengaliya Yesu na bombi balenga konzonza. ");
INSERT INTO mgv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lakini jombi jatenda kukwelapuka nukulekake shuka jejela jatila heu. ");
INSERT INTO mgv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndienu bumpelika Yesu mu nyumba jaka Agolu Akolongu papuje agolu akolongu, akahokomundu na abola bamalagalaki babia aketangini. ");
INSERT INTO mgv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petili jabia ankagu Yesu sukutali, jajingala nkati junhua kwaka Nngolu Nkolongu. Jatama pamu na alonda bakanyata mwotu. ");
INSERT INTO mgv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Agolu akolongu ni libalasa loti bataputa ndaba jukuntaki Yesu ili ankoma, lakini ngase bapatike. ");
INSERT INTO mgv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bandu bingi bapia malobi giisoli, lakini malobi gabu ngasegalengine. ");
INSERT INTO mgv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ndipala bangi bajema, nukupia malobi gi isoli koni bakapwaga, ");
INSERT INTO mgv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tunzoana mundu jonzoo jakapwaga, ‘Nihalabana Nyumba jaka Sapanga jenze jeasengiki bandu, na kwa masoba matatu nisenga kabee jangakusenga kwa maboku.’ ” ");
INSERT INTO mgv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Lakini hataa hela, malobi gabu ngasegalengine. ");
INSERT INTO mgv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ndienu, Nngolu Nkolongu jajema pikilanda jabu, andalukiya Yesu, “Boo, ngasegupala kupwaga? Bandu haba bugutakalii kike?” ");
INSERT INTO mgv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lakini jombi jatama kinunu, ngasijapwagiki hata lilobi limu. Nngolu nkolongu andalukiya kabee, “Boo, wele ndi wa Kilisituje, Mwana waka Sapanga jojupengeliwi?” ");
INSERT INTO mgv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu japwaaga, “Ena, anenganenga. Kabee, mwambona Mwana waka Mundu jutemi upandi wa malele waka Bambu jojubii na makili. Jakahika kuhuma kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Papuje Nngolu Nkolongu jwajendula lingobu laki, jakapwaaga, “Ngasetupai kabee malobi gangi ndaba jaka mundu hojo? ");
INSERT INTO mgv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwabe lee nnzoini eantondo Sapanga! Mwanganya mmbona bole?” Boti baamua jukomikaje. ");
INSERT INTO mgv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ndienu, bangi batumbulya kunhuni imata, bunhyekaliya kumihu, bundapula nukupwagi, “Lotila, nya jojugulapwile!” Hataa alonda bunzukua, nukundapu makopi. ");
INSERT INTO mgv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petili ejwabia jwakona pai jili balasa, mmbomba jumu ntumi jwaka Nngolu Nkolongu jatenda kuhegale. ");
INSERT INTO mgv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ehambona Petili junyata mwotu, andingaliya nukumpwagi, “Hata wee wabii pamu na Yesu juku Nazaleti.” ");
INSERT INTO mgv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lakini petili jatenda kukana, “Ngasemanya, wala ngasenielewa ga gupwaga!” Ndipala Petili jaboka jajenda kunza jahua. Papuje likongobi latenda kubeka. ");
INSERT INTO mgv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ntumi mmbomba jola eambona kabee petili, jatumbuka kabee kapwagii bandu bababii ajemiki papuje, “Mundu jonzo jwabii pamu najombi.” ");
INSERT INTO mgv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petili jakana kabee. Muda kidogu, bandu bababii ajemiki papuje bumpwagila Petili, “Kee wehapa jumu wabu, ndaba weapa wa mwenei juku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lakini Petili jatumbuka kupwaga, Kuliga nukulapa, nakaapwagi, “Nepani ngase numanyiki mundu hoju jomupwaga majambu gaki.” ");
INSERT INTO mgv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Papuje likongobi labeka mala ja pili. Ndienu, Petili jakombuka ngati Yesu ejwabia ampwagii, “Kabula likongobi ngaselibekiki mala ja pili, gwingana kabee mala ja tatu.” Petili jilihabuu pai nukulela. ");
INSERT INTO mgv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ekwakusa, agolu akolongu baketangana pamu na aseja, na abola ba malagalaki na bandu boa ba pasengu bajetangannya kunkonga Yesu pengu nu kumpeleka kwaka Pilatu. ");
INSERT INTO mgv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu andalukiya Yesu, “Boo wehapa lee gu Nkolongu wa Ayaude?” Yesu jaapwagila. “Ena, ngati egupwagike weapa.” ");
INSERT INTO mgv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Agolu akolongu buntakila Yesu kwa malobi gangi ginge. ");
INSERT INTO mgv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu andalukiya kabee Yesu, “Boo, mbona ngasegupwaga lilobe? Joannya ebugutaki kwa malobi gingi.” ");
INSERT INTO mgv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lakini Yesu ngasejapwagiki lilobe, mbaki Pilatu jasangii. ");
INSERT INTO mgv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila Lisoba likolongu la Pasaka, Pilatu jayobali kunhogule mpugwa jumu jobumpala. ");
INSERT INTO mgv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ndienu jabii mundu jumu joankema Balaba, jojuwe jabii ankongiki pamu na bangi babatei puju nukukoma bandu. ");
INSERT INTO mgv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bandu bangi bunzendila Pilato, bundoba jwaatendila ngati kawaida jaki. ");
INSERT INTO mgv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu jalalukya, “Boo, mpala nunhogulya Bambu Nkolongu juku Uyahude?” ");
INSERT INTO mgv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jwapwaaga hela ndaba jwamanyiki agolu akolongu bumpelika Yesu kwaki ndaba babia bumbone wipu. ");
INSERT INTO mgv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lakini agolu akolongu bakolua bandu bundoba pilatu jaabopulya Balaba badala jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu jalalukya kabee, “Ndienu, mpala nunhengila ki mundu jomunkema Nkolongu jwa Ayaude hojo?” ");
INSERT INTO mgv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bandu boa bajamalya kabee, “Unkomangalya punsalaba!” ");
INSERT INTO mgv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lakini pilatu jalalukya, “Ndaba jakii! Jutei kihakau bole?” Lakini bombi bajonzukya kujamalii. “Nkomangaliya punsalaba!” ");
INSERT INTO mgv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu japala, jwapala nsambi wa bandu gola gwiyoma, ndienu andekakya Balaba kuhuma muligelesa. Jwaapwgila bandu bunndapula Yesu iboku nukukomangale punsalaba. ");
INSERT INTO mgv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ndipala manzolinzoli bumpelika Yesu pasengu ja nyumba jaka Pilatu, jojabii nkolongu ju ndema Ndienu baakusanya manzolinzoli boka. ");
INSERT INTO mgv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bunhwatika Yesu ingobu ja zambalau ngati Bambu Nkolongu, balenganakiya hingu ja miha, bunhwatika pamutu. ");
INSERT INTO mgv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Batumbuka kundamuu, “Jambuoti, u Nkolongu wa Ayaude!” ");
INSERT INTO mgv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bundapula pamutu na nndai, nu kunhuni imata, bapega magoti nu kunzinamii. ");
INSERT INTO mgv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ebaboka batenda kundongama, buhulaa ingobu ya zambalau ye yela, nukunhwatika ingobu yake, ndi bumpelika nukunkomangale punsalaba. ");
INSERT INTO mgv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pababii mwiindela, baketangini na mundu jumwa ankema Simoni, mwenei juku Kilene. Bombi babia ahengo baka Alekizanda na Lupu. Na muda we hogu jabia juhuma kukijijini. Manzolinzoli bundasimisa Simoni kutogo nsalaba gojabii naku Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ndipala, bumpelika Yesu mbaka pandu pabakema Goligota, maana jaki, pandu papabonikana ngati “Pandu piliupa lu umutu.” ");
INSERT INTO mgv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ndienu, bumpekya Yesu divai jeahangagini mitela jebijikema manemane. Lakini Yesu jatenda kukana ");
INSERT INTO mgv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ndienu bunkomangalya punsalaba, nukubagana ingobu yaki kwa gudugudu ili amanya nyaa jupata ingobu boo. ");
INSERT INTO mgv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ekwabia lisaa la tatu pulukela pabunkomangalya punsalaba. ");
INSERT INTO mgv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na panani ju nsalaba baandiki malobi gu kuntaki ganga, “NKOLONGU JWA AYAUDI.” ");
INSERT INTO mgv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Papuje baakomangalya bii habeli mumisalaba pambipi na Yesu, jumu upandi wa malele na jongi upandi wa mangega waka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ndienu gatimi Mahandiku gagapwaga, “Ambei likundi limu na bandu abaya.” ");
INSERT INTO mgv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bandu bababiapeta pandu pala, bannyua imutu yabu nu kuntondo nu kupwaga, “Ooo! Wehapa ndi wewapwaga witunula Nyumba jaka Sapanga nukusenga kwa masoba matato! ");
INSERT INTO mgv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Enu, guhuluka munsalaba ulikombula wamwete!” ");
INSERT INTO mgv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nabombi agolu akolongu pamu na abola bamalagalaki bundongama nu kumpwagani beni na beni, “Jahokua bangi, lakini kulihoko mweni ngakuwesa! ");
INSERT INTO mgv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eti jombi Kilisitu, bambu nkolongu juku Izilaeli! Ndienu juhuluka kuhuma punsalaba ili tumbona nukunhobale.” Hata bandu bangi bala babaakomangali mumisalaba pambipi jaki nabombi batenda kuntondoo. ");
INSERT INTO mgv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kutumbuka lisaa la sita lyobamutu mbaka lisaa la tisa pakamii lwii lwayekalya nndema woka. ");
INSERT INTO mgv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lisaa la tisa pakamii Yesu jalela kwa sauti ngolongu, koni jakapwaga, “Eloi, Eloi lema Sabakitani?” Maana jaki, “Sapanga wango, Sapanga wango, ndaba jaki guneka kajika jango?” ");
INSERT INTO mgv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bandu bangi babajemiki pala pabajoa hela bapwaga, “Joanya! Ankema Elia.” ");
INSERT INTO mgv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu jumu jabutuka, jajubika kipongu divai jejibaba, nukujibeka panani ja nndai, ambekila pundomu nukupwaga, “Lendalya tugubona ana Elia juhika kuguhuluu punsalaba jehapa!” ");
INSERT INTO mgv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ndipala Yesu jajamalya kwa makili, ndienu jatenda kuwa. ");
INSERT INTO mgv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kipindi sela, lipazia la Nyumba jaka Sapanga lakajuka pikilanda ipandi ibeli tumbuka kunani mbaka pai. ");
INSERT INTO mgv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkolongu wa manzolinzoli jumwa jojabia jujemiki palongi jaki pajabona namuna jejakua Yesu japwaga, “Sakaka mundu hajo jwabii Mwana waka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Babii kabee aka mbomba babalingalya sukutali, kati jabu jakabii Malia juku Magidala na Salomi na Malia amabu baka nkombu Yakobu na Yose. ");
INSERT INTO mgv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aka mbomba haba ndi babunzengalya Yesu pajabii ku Galilaya nukunzangatii. Kwabii na aka mbomba bangi bingi babahika ku Yelusalemu pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ekwahika pakamii. Helilabia lisoba lukubeka sapi, yani lisoba lelilongulii Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Papuje, jahika Josepu mwenei juku Alimatayo, ntenga wa Sengu ngolongu, jwabii mundu jwiniisima. Kabee jwabia mundu jojulendale kuhika ku Ukolongu waka Sapanga. Ndienu anzendila Pilatu bila kujogopa, jaaloba bumpekya nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu jasangia kujoana Yesu jabia juwii. Ndienu, ankema nkolongu jwa manzolinzoli, andalukiya ana gupetiki muda gwingi toka Yesu pajuwii. ");
INSERT INTO mgv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nkolongu wa alonda hejwabii ampwagi Pilatu Yesu juwii, ampwagila Josepu juku Alimatayo jajukua nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Papuje Josepu jalomba sanda jikitani, jijihelia nhyega je jela nukujiyongulakee sanda. Jabeka mlikabuli lelabii pililibu la soma, ndipala jwilihingalya lilibu likolongu kulibeka pundyangu. ");
INSERT INTO mgv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nabombi Malia juku Magidala na Malia amabu baka Yose balingaliya papu pabumbei. ");
INSERT INTO mgv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Elapeta Lisoba lu Kupomulela, Malia juku Magidala na Salomi na Malia nyongoo waka Yakobu balomba mahuta gaganungii bapala bakapakia nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndienu, pulukela ngani lisoba la Jumapili, bajenda pilitenge, lyoba elatumbulya kupita. ");
INSERT INTO mgv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nabombi babia bakapwagannya, “Nya jojukutubokia lilibu lelibii pundyangu ulitengela?” ");
INSERT INTO mgv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lakini ebalinga bapabona lilibu lee bilihingaliti. Nalombi labii likolongu ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pabajingala pilitenge, bumbona nkombu jumwa juweti ingobu nhunhu, jutamiki upandi wa malele. Nabombi basangia ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lakini nkombu we jola jaapwagila, “Mwisangaa. Muntaputa lee Yesu juku Nazaleti jobunng'alisi jola. Juyokike, ngasejubii pane. Ndinga pandu pababii bumbekike. ");
INSERT INTO mgv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nzendanya mwakaapwagila banafunzi baki pamu na Petili ‘Jundongulee ku Galilaya kola. Kokuje bambona ngati ejumpwagila.’ ” ");
INSERT INTO mgv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndienu, baboka pi litenge je pala imbelo, koni bakabagaja sulujogopu nukusangaa. Ngasebumpwagi mundu jokapi sindu, ndaba bajogipi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pajayoka pulukela mlisoba la Jumapili, jatumbuka kulilangii kwaka Malia juku Magidala, jojabii Yesu ampiiki ilombu saba. ");
INSERT INTO mgv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malia juku Magidala jajenda kaapeke lijambu bandu bababii pamu na Yesu, muda we hogu banafunzi baka Yesu, balobalakya nyembu nu kulela. ");
INSERT INTO mgv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lakini ebajoana Yesu jubii mwomi na Malia juku Magadala ambweni, ngase bajetakile. ");
INSERT INTO mgv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muda egwapeta Yesu japitila kwa banafunzi habeli nabombi oti ngasebummanyike. Banafunzi be haba babia ajenda kukijijini. ");
INSERT INTO mgv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nabombi kabee bajenda kwaapwagi banafunzi bangi. Hata hela ngasebaajetakile. ");
INSERT INTO mgv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pamwisu Yesu japitila banafunzi baki komi na jumwa pababii pamu akula posu. Jalakalii ngamaa ndaba jukusinwa kuhobalee kwabu nu kusindwa kujoa kwabu, ndaba ngase baahobalii bababii bumbweni baada jukuyoka. ");
INSERT INTO mgv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndienu, jaapwagila, “Nzendanya pundema poti mwakaalandila Lijambu la Amboni kwaka kila mundu. ");
INSERT INTO mgv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundu jokapi jojuhobalee nu kubatiswa jitenda kulama. Na mundu jwanga kunhobale Sapanga jiitenda kuntemu. ");
INSERT INTO mgv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na nginyuli ye heyi ilongana na bandu bahobalee. Kwi liina langu biiboa ilombu na biilongila kwa luga inyai. ");
INSERT INTO mgv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Naakamwi lijoka au kunywa sindu sokapi sukukoma, nga biikuwe. Baabekila agonzu maboku na Sapanga jitenda kwaalamisa.” ");
INSERT INTO mgv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ndienu, Bambu Yesu ejajomula kulongee naku, jajukulika kujenda kunani jatama pikiteu saki su ubambu ukolongu pulutengu jaka Sapanga kwaatawala pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndienu banafunzi bajenda nu kulandi kila pandu Lijambu la Amboni. Bambu jahenga lihengu pamu nabombi nukuhenga nginyuli hingi kulangi Lijambu heli la sakaka.");
INSERT INTO mgv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nkolongu Teofilo. Bandu bingi batumbuliya kuandika majambu gala ngati egahengika nkati jitu. ");
INSERT INTO mgv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Baandiki majambu ngati ebutupwagila na bandu babagabona kwa mihu gabu tangu puwanzu, na bandu babalandila malobi gene. ");
INSERT INTO mgv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Unkolongu Teofili, nenamweti ningiki majambu haga goti sapi toka puwanzu, moniki kwibia sapi nuguandakya sukupanga majambu ge haga sapi. ");
INSERT INTO mgv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ndenda hela ndaba nanagu gumanya usakaka gwoti gwa majambu gabugubola. ");
INSERT INTO mgv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mumasoba gala Helodi pajabi bambu nkolongu juku Yudea, jakabii nngolu jumu joankemika Zakalia, jojabiya jumu kati ja agolu buku Abiya. Nhwanu waki bunkemika Elizabeti, najombi jabia juhumi mulukolu lwaka nngolu Aloni. ");
INSERT INTO mgv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Boka abeli babia baajetakiwi palongi jaka Sapanga, koni akamulaki ngani malagalaki goka gaka Bambu sanga lawama. ");
INSERT INTO mgv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lakini ngasebabii na bana, ndabaje Elizabeti jabi nga nikibeleko, na boti abeli babii aseja ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lisoba limu, Zakalia pajatenda lihengu luugolu mu Nyumba jaka Sapanga, jabia zamu jaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakalia bunhagula kwa gudugudu ngati ekwayobaliki muugolu kujingi mu Nyumba jaka Sapanga kupogale ubani. ");
INSERT INTO mgv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kipindi sukupogale ubani esahika, bandu boha babi kunza bukundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ndipala ntumi jukunani kwaka Bambu ampitila, jajemiki upandi wamalele pa mesa jukupiiki litambiku lejwapogalya ubani. ");
INSERT INTO mgv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia eambona ntumi jukunani we hoju jatenda kusituka nukujogopa. ");
INSERT INTO mgv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lakini ntumi jukunani ampwagila, “Zakalia, gwijogopa! Sapanga jujoine segulobikaje. Nu nhwanu waku Elizabeti jwagupapila mwana mwanalome, nanagu wankema Yohana. ");
INSERT INTO mgv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Gwiitoguliya ngamaa na bandu bingi bitenda kutogule ndaba jukusaliwa kwaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jombi jwibiya ntumisi nkolongu pamihu jaka Bambu. Ngajikunyi divai wala uwembi. Loho jaka Sapanga antwelila kabula lisoba lukusaliwa kwaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jaalongua bandu bingi buku Izilaeli kunkelabuki Bambu Sapanga wabu. ");
INSERT INTO mgv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jiilongulya palongi jaka Bambu, jiibia na makili na loho ngati jaka Elia jojabii Mlota waka Sapanga. Jajing'alumbua mioju jaka hengo kwaapala bana babu, jaahenga bandu banga kunzoane Sapanga ahenga gajupala Sapanga, jahenga bandu bijiandia kunzopa Bambu.” ");
INSERT INTO mgv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia andalukia ntumi jukunani kwaka Sapanga, “Nimanya boo lilobi le hele? Neje nuseja na ahanubabe kabee aseja.” ");
INSERT INTO mgv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ntumi jukunani kwaka Sapanga japwaga, “Nena Gabulieli. Nenyema palongi jaka Sapanga, jojundumiki kulonge naweapa, nugupwagila lijambu la sapi lende. ");
INSERT INTO mgv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jogwana, gwibiya gwikimumuta ndaba ngaseguhobale malobi gangu ne gagitimia kwa masoba gaki. Ngawiwesi kulonge mbaka ganugupwagi haga pagipitila.” ");
INSERT INTO mgv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Muda gwe hogu bandu bundendaliya Zakalia koni bakasangia kuselewa kwaki mu Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pajapita kunza, ngasejawesiki kulonge nabu, henu bamanyiki jagabweni majambu kuhuma kwaka mu Nyumba jaka Sapanga. Jalongila nabu kwa maboku gaki ndaba ngasejawesa kupwaga. ");
INSERT INTO mgv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Masoba gaki gukuhenga lihengu lu ugolu mu Nyumba jaka Sapanga egajomuka, Zakalia jabuja kunyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Monikatae Elizabeti nhwanu waki jabia nikitumbo. Jajoba mu nyumba muda wa mieyi nhwanu. ");
INSERT INTO mgv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeti jilipwagila, “Hela ndi Bambu ejundendi, jumoniki nu kumoke hiyoni kwa bandu.” ");
INSERT INTO mgv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kitumbu saka Elizabeti hesahika miehi sita, Sapanga antuma ntumi ukunani kwaka Sapanga jobunkema Gabulieli jujenda mmusi uku Nazaleti kundema uku Galilaya, ");
INSERT INTO mgv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwaka kamwali jumu jobunkema Malia jwangakuketangana na mwanalomi nsumba waka mundu jumu joakema Josepu, jojuhumi mulukolu lwaka Bambu nkolongu Daudi. ");
INSERT INTO mgv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ntumi jukunani kwaka Sapanga anhikila kamwali jola nukumpwagi, “Lukwali lubiya pamu na weapa! Webabugupeki wamboni waka Sapanga nukugupengee!” ");
INSERT INTO mgv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia pajajowana malobi ge haga, jasangia mmwoju jaki, najombi jaholalya malobi ge haga manaki je kike? ");
INSERT INTO mgv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ntumi ukunani waka Sapanga ampwagila, “Malia, wijogopa! Ndaba Sapanga jugulangi wamboni waki. ");
INSERT INTO mgv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gwitotula kitumbu gwibelika mwana mwanalome, gwankema Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jombi jwiba nkolongu, bankema Mwana waka Sapanga jojubii kunani ngani. Bambu Sapanga jwampekia kiteu su ubambu nkolongu saka Daudi ahoku baki. ");
INSERT INTO mgv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jwibiya Bambu juku kibeleku saka Yakobu masoba goka. Nu ubambu ukolongu waki ngagwikubi na mwiso!” ");
INSERT INTO mgv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia ampwagila ntumi jukunani kwaka Sapanga, “Kwiwesikana bole, naneje ngasewahiki kuketangana namwanalome?” ");
INSERT INTO mgv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ntumi jukunani kwaka Sapanga ampwagila, “Loho jaka Sapanga jiitenda kuguhulukila na makili gaka Sapanga giitenda kuguyekale. Henu Mwana wa Sapi jitenda kusaliwa, bankema Mwana waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Gunkombuka nndongu waku Elizabeti jupatiki kitumbu pamu nu useja waki. Lakini bandu bapwagannya ngajukubeleka mwana, nahenu jubi nikitumbu sa myei sita. ");
INSERT INTO mgv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ndaba ngasindu sejusindwa kutenda Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia jwapwaga ana, “Nenga nuntumwa waka Bambu, jundendila ngati egupwagike.” Ndipala ntumi jukunani jola jatenda kuboka. ");
INSERT INTO mgv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Masoba agalaga Malia jwajenda nyata mmusi gumu gogubi mwitombi yu nndema uku Yudea. ");
INSERT INTO mgv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kola jajingala nnyumba jaka Zakalia, andamukya Elizabeti. ");
INSERT INTO mgv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti ejwajowana Malia andamuki, mwana jojwabi mulutumbu jaki jatenda kuhomba. Najombi Elizabeti jwatwelila Loho jaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","jajamalya, “Bugupendali kuliku aka mbomba boha, mwana jowibelika jiibiya jupengaliwi! ");
INSERT INTO mgv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ndaba jaki sindu kikolongu ngati ase kimbitii nenga, mbaka amabu baka Bambu wangu anhiki nenga? ");
INSERT INTO mgv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Enajowana wakanamukya, kamwana kakeki kwaatenda kuhomba mulutumbu jangu koni kwaatogule. ");
INSERT INTO mgv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gupengaliwi na Sapanga ndaba guhobali gajugupwagi Bambu gala!” ");
INSERT INTO mgv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia japwaaga, “Mwoju wangu gundumbali Bambu. ");
INSERT INTO mgv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Loho jango juntogule Sapanga jojubi Nkombosi wangu. ");
INSERT INTO mgv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ndaba juningali kwikiya ndaba jukombwiki ntumwa waki jojulihulwii pai ngani! Tumbuka sajeno nukuendale bandu boti biingema na mundu jojupendaliwi, ");
INSERT INTO mgv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ndaba Sapanga jwana na Makili jundendi makolongu. Lihina laki la Sapi, ");
INSERT INTO mgv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","jaabone hikia bandu babunzogopa jombi. Hikia yaki hitama kibeleku mbaka kibeleku. ");
INSERT INTO mgv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Juhengiki majambu makolongu nu kuboku kwaki. Jaapesangini bandu babikipunika mmyoju jabu. ");
INSERT INTO mgv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jwahulwi akolongu kuhuma mwiteu yabu yu ubambu, na jatondabi bandu bangakupala makolongu. ");
INSERT INTO mgv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bini inzala baatupalisi majambu gaamboni, na jaabengiki bandu bana mali gingi maboku matopu. ");
INSERT INTO mgv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Anzangati ntumisi waki Izilaeli, koni jwakakombuka hikia yaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jukombwiki kumbone hikia Ibulahimu ni kibeleku saki yaka petapeta ngati ejalagila aseja bitu!” ");
INSERT INTO mgv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia jatemi na Elizabeti kwa miehi mitato, ndipala jabuja kunyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Masoba gaka Elizabeti gukubeleka egahika, najombi jabelika mwana mwanalome. ");
INSERT INTO mgv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bandu bapambipi na alongu ebajowana lijambu laka Bambu kumbone hikia ngolongu, batogulya pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana ejahikisa lisoba la nani bahika kunseku jandu. Bapala kumpeke liina Zakalia, liina la ahengo baki. ");
INSERT INTO mgv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lakine amabaki bapwaga, “Koto! Lihina laki tunkema Yohana!” ");
INSERT INTO mgv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bandu bala bumpwagila, “Mbona nga mundu jwini liina ngati heli mulukolu wako!” ");
INSERT INTO mgv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ndipala balongila kwa nginyuli na Zakalia, bapala amanya jombi jupala mwanamundu ankema lihina bole. ");
INSERT INTO mgv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia jaloba kibau sukuandaki, ndipala jaandika, “Lihina laki Yohana!” Bandu boha batenda kusangaa. ");
INSERT INTO mgv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Apalapa, Zakalia jawesa kulonge kabee, nukutumbuli kundumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bandu bapambipi boha batenda kujogopa, na majambu ge haga gaeniya nndema yoka yiitombi yuku Yudea. ");
INSERT INTO mgv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bandu pabajoana majambu gala bawasaliya mmyoju jabu koni bikililalukya, “Boo mwana we hoju jibiya mundu bole?” Ndaba makili gaka Bambu gabonikana gabi pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia ahengo baka Yohana batwelala Loho jaka Sapanga, najombi jalota, nukupwaga, ");
INSERT INTO mgv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Julumbalika Bambu, Sapanga juku Izilaeli! Ndaba jahiki bandu baki nakagombo. ");
INSERT INTO mgv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jutupeki twepani Nkombosi mwana makili, nsokoo waka mtumisi waki Daudi. ");
INSERT INTO mgv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngati ejapwaga toka pamwandi kupete alota baki baa Sapi. ");
INSERT INTO mgv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jatukombula kwa abaya bitu nu kutupia mwamaboku babutusuki. ");
INSERT INTO mgv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Japwaga jwabonila hikia aseja bitu nu kukomboka lilaganu laki la sapi. ");
INSERT INTO mgv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jalapa kwaka Ibulahimu ahengo bitu, ");
INSERT INTO mgv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jwahokua kuhuma kwaka abaya bitu, na jatujangatya tuwesa kuntumiki Sapanga bila kujogopa. ");
INSERT INTO mgv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tubiya twa sapi na tubiya bandu bamboni palongi jaka Sapanga, masoba goti ga womi wito.” ");
INSERT INTO mgv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Wehapa wamwanango, bagukema Mlota waka Sapanga nkolongu. Wandongulya Bambu kundenganake indela jaki, ");
INSERT INTO mgv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kwaapwagi bandu baki biitenda kuokuleka, sakaalekake mahakau gabu. ");
INSERT INTO mgv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sapanga witu mpoli na jwana mmwoju wa sapi. Jaamulakya unang'anu na kwaagomboo kuhuma kwaka Sapanga juku nani. ");
INSERT INTO mgv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Gwamulaki bandu boti batama mlwii lwa kuwa, Jutulongua magolu gitu mwiindela jaamboni.” ");
INSERT INTO mgv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana jakola nu kujonzukeka makili mu loho. Jatama pulugwenza mbaka lisoba lejaapitila bandu buku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Masoba gala Agusitu, Bambu nkolongu, juku Loma jalagalakya bandu boka buku ukolongu guku Loma baabalanga. ");
INSERT INTO mgv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kwaabalanga bandu kwe hoku kwabia kuutumbuli, kipindi Kilenia pajabia nkolongu juku nndema uku Silia. ");
INSERT INTO mgv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndienu, kila mundu jajenda kumusi waki kubalangwa. ");
INSERT INTO mgv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josepu jahuma mmusi uku Nazaleti gogubi kunndema juku Galilaya, jajenda kumusi uku Betelehemu gogubi ku Yudea, pandu pajasaliwa bambu nkolongu Daudi. Josepu jajenda hoku ndaba jabia juhumi mukibeleku saka Daudi. ");
INSERT INTO mgv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jajenda kubalangwa pamu nu nsumba waki Malia jojwabi ni kitumbo. ");
INSERT INTO mgv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pababi ku Betelehemu hoku, lisoba laki lukubeleka labiya lihikiki. ");
INSERT INTO mgv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jabelika mwana jukutumbuli mwanalomi, bunhwatiki indenga. Ndipala bunngonika mulukoi lukulele ng'ombi, ndaba ngasebapatiki pandu pukutama munyumba ja ageni. ");
INSERT INTO mgv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mmusi agolago, babi alimu batamika ikilu kumatuhi kulendale mipugu jabu. ");
INSERT INTO mgv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ntumi jukunani kwaka Sapanga waka Bambu jwaapitila nu ulumbi waka Bambu waanang'annya, nabombi bajogipi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lakini ntumi jukunani kwaka Bambu jola jaapwagila, “Mwijogopa! Nundeti Lijambu la Amboni, lebiitoguliya bandu boka. ");
INSERT INTO mgv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leleno pamusi jaka Daudi jusaliwi Nkombosi wino Kilisitu, Bambu! ");
INSERT INTO mgv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jeneji jibiya nginyuli jino, mwanketaniya mwana nsaliwano anhwati indenga, angoniki mulukoi.” ");
INSERT INTO mgv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Apalapa likundi likolongu la atumi bu kunani kwaka Sapanga laketangana nu ntumi jukunani hoju, koni bukundumbalya Sapanga, bakapwaga, ");
INSERT INTO mgv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ukolongu kwaka Sapanga jojubi kunani ngani kumaundi, nu lukwali kwa bandu babi pundema poti bagulisiki nabu!” ");
INSERT INTO mgv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Atumi bu kunani bala pababuja kunani kwa mahundi, alimu bapwagannya, “Tubokannya ku Betelehemu tukikibona sekipiti, sejutupwagi bambu.” ");
INSERT INTO mgv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndienu babutuka, baaketannya Malia na Josepu na mwana nsaliwanu we jola bunngoniki mulukoi. ");
INSERT INTO mgv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Alimu be pabumbona mwana we jola, baapwagila majambu ga mwana jola gabapwaga atumi bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bandu boka babajowana ganiaga basangia malobi gaalimu. ");
INSERT INTO mgv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lakini Malia jabeka haga goka mmwoju jaki nukugawasali ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Alimu bala bakelubuka kunyumba jabu, bundumbalya Sapanga kwa goka gabajoana na kugabona, goti gapitila ngati ntumi jukunani kwaka Sapanga ejaapwagila. ");
INSERT INTO mgv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mulisoba la nani, lisoba lukunseku jandu mwana, bumpekya lihina laki Yesu. Lihina le heli amabu bapatiki kuhuma kwaka ntumi jukunani kwaka Sapanga kabula jukupata kitumbu amabu. ");
INSERT INTO mgv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gahika masoba gaka Josepu na Malia kuhenga malagalaki gu kunyambisika ili ajetakika palongi jaka Sapanga ngati Malagalaki gaka Musa egalagalaki. Henu bunzukua mwana, bajenda naku kumusi uku Yelusalemu kumpenge palongi jaka Bambu, ");
INSERT INTO mgv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ngati egaandiki malagalaki gaka Bambu Sapanga, “Kila mwana mwanalomi juutumbuli bumpelika kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kabee bajenda ili akatambika, kupalika apia inzeba ibele au ibana ya ngunda ibeli, ngati Malagalaki gaka Bambu Sapanga egapwaga. ");
INSERT INTO mgv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ku Yelusalemu kola jwabi mundu jumu jobunkemika Simoni. Mundu we hoju jwabi jwa sapi joanzetakya Sapanga, jojuwe jwabi mundu jojulendalya ukombosi guku Izilaeli, najombi jwabii na Loho jaka Sapanga pamu na jombi. ");
INSERT INTO mgv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Loho jaka Sapanga anhyekulya kupwaga ngajukui mbaka ambona Kilisitu Nkombosi jojuhaguliki na Bambu. ");
INSERT INTO mgv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndienu Loho jaka Sapanga andongua Simoni kujenda ku Nyumba jaka Sapanga. Ahengo na amabu baka Yesu bumpelika mwana mundu mu Nyumba jaka Sapanga, buhengila ngati hebayobali mu Malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni anzukua mwana Yesu mwamaboku gaki nukunsengu Sapanga koni jwakapwaga, ");
INSERT INTO mgv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Enu Bambu gutimisi lilagi laku, gunzetakya ntumi waku, jupomulya kulukwali, ");
INSERT INTO mgv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kwa mihu gangu nugubweni ukombosi waku, ");
INSERT INTO mgv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","gogutei gubonikana kwa bandu boka, ");
INSERT INTO mgv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Unang'anu gogumulika kwa bandu boka banga Ayaudi nu kuleta ukolongu waku kwa bandu baku buku Izilaeli.” ");
INSERT INTO mgv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ahengo na amabu baka Yesu batenda kusangaa kwi lijambu laka mwana wabu lejwapwaga Simoni. ");
INSERT INTO mgv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoni jwaapengila, nukumpwagi Malia, nyongo waka Yesu, “Linga, mwana we hoju juhaguliwi na Sapanga ndaba jukuhoba nakaagombo bandu bingi buku Izilaeli. Ndienu jiibia nginyuli kuhuma kwaka Sapanga, jebaajikana bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndipala mawasu ga bandu bingi gibonikana pangwendu. Nawamweti usungu gogubi ngati mpamba gogutema gwaguhosa mmwoju waku.” ");
INSERT INTO mgv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jabi mlota jumu mmbomba, jabi nseja ngamaa, lihina laki Ana, kamwali waka Fanueli, julukolu lwaka Asheli. Mmbomba we hoju jatemi yaka saba pee nu nndomi waki hoju tumbuka ehantola. ");
INSERT INTO mgv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ndienu jabia mmbomba joawi alomi baki mbaka masoba gajabi nseja jwa yaka makomi nane nu nsesi jimu. Na masoba ge haga goa jabia jutama mu Nyumba jaka Sapanga jupungika kula posu nukunndoba Sapanga ikilu na muhi. ");
INSERT INTO mgv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lisaa alelale, Ana jajendila, koni ansengula Sapanga, jaapwagila lijambu laka mwana jola kwa bandu boka bababia alendale ukombosi uku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josepu na Malia pababiya ajomuli majambu gabu goti gagapalika mu Malagalaki gaka Bambu Sapanga, babuja kunyumba jabu ku Nazaleti mmusi uku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana jakola, jajonzukeka makili, jatwelila malangu na waamboni waka Sapanga wabia pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila saka, Josepu na Malia babii ayobali kujenda ku Yelusalemu kwa ndaba ja tipati ja Pasaka, ");
INSERT INTO mgv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu pajabiya na yaka komi ni mibeli, bajenda naku ku tipati ngati hebayobali. ");
INSERT INTO mgv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pabajomula tipati ja Pasaka, na pababiya abuja kunyumba jabu. Yesu jaigala kunyuma ku Yelusalemu koni ahengo na amabu bila kumanya, ");
INSERT INTO mgv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","bombi ahambusiya jubi pamu na bandu bababii musapwali jabu, bajenda pipipipi. Ndienu batumbulya kunkagu kwaka alongu baki na akosi baki. ");
INSERT INTO mgv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngasebumbweni, henu bakelubukya ku Yelusalemu kunkagu. ");
INSERT INTO mgv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mlisoba la tatu, bunkolila pa Nyumba jaka Sapanga pikilanda ja abola biki Yahudi, jabia jakaajonnya nakaalaluki. ");
INSERT INTO mgv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boti babunzowana batenda kusangaa malangu gaki na ejwabia jaajibu. ");
INSERT INTO mgv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ahengo na amabu baki ebumbona basangii ngamaa. Anyongo baki bundalukiya, “Mwanango, ndaba jakii gutei hela? Nepani na ahengo baku tukubika tutenda kugutaputa ku usungu.” ");
INSERT INTO mgv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu jaajibua, “Henu nndaputya kyane? Ngasemmanyiki le nepani kupalika miya pa Nyumba ja Ahengo bango?” ");
INSERT INTO mgv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lakini bombi ngasebaheliwi mana ja malobi gajaapwagila. ");
INSERT INTO mgv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ndienu jabuja nabu mbaka ku Nazaleti najombi jatenda kwaajowane. Anyongo baki bagabeka haga goti mmwoju wabu. ");
INSERT INTO mgv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu jakola nu kujonzukeka malangu nu ulasu, nukundengane Sapanga na bandu. ");
INSERT INTO mgv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saka sa komi nu nhwanu wu ukolongu waka Bambu nkolongu juku Loma jobunkema Tibelio, Pontio Pilato jabia kilongosi juku Yudea. Helodi jabi kilongosi juku Galilaya, nu nndongu waki Pilipi jojabi kilongosi ju pundema puku Itulea nu nndema uku Tilakoniti na Lusania jabi kilongosi juku Abilene. ");
INSERT INTO mgv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa babi agolu akolongu, mumasoba ge haga Lilobi laka Sapanga lunhikila Yohana, mwana waka Zakalia kulungwenza. ");
INSERT INTO mgv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ndienu, Yohana jajenda nndema joka jejipakini na losi luku Yoludani. Jaalandila nakapwagi, “Nzetakya kugaleka mahakau ginu nu kubatiswa ili Sapanga jundekakya mahakau gino.” ");
INSERT INTO mgv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngati ekiandiki kitabu saka mlota waka Sapanga Isaya, “Mundu jujamali pulukoba, ‘Muhandaliya Bambu indela jaki, nnyoosha indela jaki! ");
INSERT INTO mgv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila likemba lipalika kuyelale, kila kitombi kikolongu ni kitombi kisoku sitenda kulenganakeka, papapendiki piitenda kunyosheka, indela jiliha jiitenda kunyosheka na kuba sapi. ");
INSERT INTO mgv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na bandu boti bagubona uwokovu waka Sapanga!’ ” ");
INSERT INTO mgv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ndienu bandu bingi bunzendila Yohana ili jaabatisa, najombi jaapwagila, “Mwanganya mwa bandu bilijoka! Nya jojumpwagi nhwesa kujepa inyela yaka Sapanga yeyihikaje? ");
INSERT INTO mgv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nhenga mahengu gagalangi nkotwiki mahakau. Mwipwaaga, ‘Ibulahimu ndi hoku witu!’ Numpwagi sakaka, Sapanga jubi nuuwesu ukung'anambu malibu haga gabia bana baka Ibulahimu! ");
INSERT INTO mgv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ndienu, lipengu abei punhina ji mikongu, na henu nkongu gokapi wanga kupapa matunda ga sapi biitenda kuguseku nukuguleke pamwotu.” ");
INSERT INTO mgv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nsambi wa bandu gundalukiya, “Henu tutenda kike?” ");
INSERT INTO mgv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohana jaajibua, “Mundu jojubi ni ingobu ibele ambaguliya jwangakuba nayu, jojubi na posu ampekya jwini inzala.” ");
INSERT INTO mgv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nabombi baajopa kodi bahika ili baabatisa, bundalukiya, “Mbola, natwe tutendaa kyane?” ");
INSERT INTO mgv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Najombi jwaapwagila, “Mwijopa kodi ngolongu kupeta yebupangi.” ");
INSERT INTO mgv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nabombi aka alonda bundalukya, “Natwe tutenda kyane?” Najombi jaajibua, “Mwinyaga hindu yaka mundu jokapi kwa makili wala mwankopake mundu jokapi jola. Ntosika na sebundepa.” ");
INSERT INTO mgv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bandu ebabiya ahobale gagiipitila, bandu boha bawasaliya mmyoju lijambu laka Yohana kupwaga jombi ndi Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Papuje Yohana jaapwagila boti, “Nenga numbatisa kwa masi, lakini juhika junuwesu kupeta nenga, jojuwe ne ngasembalika hata kujinama kummbopo ng'oji ya makobasi gake. Jombi jaambatisa kwa Loho jaka Sapanga na kwa mwotu. ");
INSERT INTO mgv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jombi jubi ni kipalu saki mumaboku gaki, najombi jupeta inganu yaki, jubeka pamu mwikikoku saki na jwijosa mwegeu mumwotu wanga kususuka masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Henu, kwa malobi gangi gingi Yohana jabia jakaalandila bandu Lijambu la Amboni nakahingamaki ang'anambua indela yabu. ");
INSERT INTO mgv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lakini Yohana andosa Helodi nkolongu juku ku Galilaya, ndaba anzukwi Helodia, nhwanu waka nndongu waki, na majambu gangi gingi giliha gajatei Helodi. ");
INSERT INTO mgv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Helodi jajonzukiya ubaja waki sunkukonga Yohana mkipungu. ");
INSERT INTO mgv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bandu boti pajajomula kwaabatisa, ndienu Yesu batenda kumbatisa, na pajabiya jakaloba, mahundi gatenda kuyekuka, ");
INSERT INTO mgv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Loho jaka Sapanga anhulukiya jabi na nhyega ngati ngunda. Jajowanika sauti kuhuma kunani kwaka Sapanga, “We wamwanango jonugupaile, gutei kunenganela.” ");
INSERT INTO mgv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ejatumbulya lihengu jabi na yaka makomi matatu, na bandu baambusiya jombi mwana waka Josepu, mwana waka Heli. ");
INSERT INTO mgv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli jabi mwana waka Matati, Matati jojabi mwana waka Lawi, Lawi jojabii mwana waka Meliki, Meliki jojabii mwana waka Yanai, Yanai jojabii mwana waka Josepu, ");
INSERT INTO mgv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josepu jojabi mwana waka Matatiasi, Matatia jojabii mwana waka Amosi, Amosi jojabii mwana waka Nahumu, Naumu jojabii mwana waka Hesili, Hesili jojabii mwana waka Nagai, ");
INSERT INTO mgv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jojabi mwana waka Maati, Maati jojabii mwana waka Matatia, Matatiasi jojabii mwana waka Shemeni, Shemeli jojabii mwana waka Yoseki, Yoseki jojabii mwana waka Yuda, ");
INSERT INTO mgv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda jojabi mwana waka Yohanani, Yohanani jojabii mwana waka Lesa, Lesa jojabii mwana waka Zelubabeli, Zelubabeli jojabii mwana waka Shetieli, Shetieti jojabii mwana waka Neli, ");
INSERT INTO mgv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli jojabii mwana waka Meliki, Meliki jojabii mwana waka Adi, Adi jojabii mwana waka Kosamu, Kosamu jojabii mwana waka Elimadamu, Elimadamu jojabii mwana waka Eli, ");
INSERT INTO mgv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli jojabi mwana waka Yoshua, Yoshua jojabii mwana waka Eliezeli, Eliezeli jojabii mwana waka Yolimu, Jolimu jojabii mwana waka Matati mwana waka Lawi, ");
INSERT INTO mgv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi jojabi mwana waka Simoni, Simoni jojabii mwana waka Yuda, Yuda jojabii mwana waka Josepu, Josepu jojabii mwana waka Yonamu, Jonamu jojabii mwana waka Eliakimu, ");
INSERT INTO mgv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu jojabi mwana waka Melea, Melea jojabii mwana waka Mena, Mena jojabii mwana waka Matata, Matata jojabii mwana waka Natani, Natani jojabii mwana waka Daudi, ");
INSERT INTO mgv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi Jojabi mwana waka Yese, Yese jojabii mwana waka Obedi, Obedi jojabii mwana waka Boazi, Boazi jojabii mwana waka Salumoni, Salumoni jojabii mwana waka Nashoni, ");
INSERT INTO mgv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","jojabi mwana waka Aminadabu, mwana waka Alimini, mwana waka Heziloni, mwana waka Pelesi, mwana waka Yuda, ");
INSERT INTO mgv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","jojabi mwana waka Yakobu, mwana waka Isaka, mwana waka Ibulahimu, mwana waka Tela, mwana waka Naholi, ");
INSERT INTO mgv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","jojabi mwana waka Selugi, mwana waka Leu, mwana waka Pelegi, mwana waka Ebeli, mwana waka Sala, ");
INSERT INTO mgv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","jojabi mwana waka Kainamu, mwana waka Alifikisadi, mwana waka Shemu, mwana waka Noa, mwana waka Lameki, ");
INSERT INTO mgv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","jojabi mwana waka Metusela, mwana waka Enoki, mwana waka Yaledi, mwana waka Mahalaleli, mwana waka Kainamu, ");
INSERT INTO mgv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","jojabi mwana waka Enoshi, mwana waka Seti, mwana waka Adamu, jojabi mwana waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu jahuma ku losi luku Yoludani koni jutweli Loho jaka Sapanga na Loho jaka Sapanga jundongua mbaka pulukoba. ");
INSERT INTO mgv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hoku jalengwa ni Lijobi kwa masoba makomi nu nsesi. Mumasoba ge gala goka ngasejakuliki sokapi na masoba ge gala egajomuka jilijoannya inzala. ");
INSERT INTO mgv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lijobi lumpwagila, “Ana we wa Mwana waka Sapanga, gulipwagila lilibu lende libiya libumunda.” ");
INSERT INTO mgv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lakini Yesu ampwagila, “Aandiki, ‘Mundu ngasejutama sa kula libumunda pena.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ndipala, Lijobi lundongua Yesu mbaka pikitombi kilasu, nukundangi kwa mala jimwa ukolongu woti gupundema poka. ");
INSERT INTO mgv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lijobi lumpwagila, “Nagupekia ubambu ukolongu nu ulumbi, ndaba yoti ambeki nepani, nane niwesa kumpeke mundu jokapi jonumpai. ");
INSERT INTO mgv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nagupekia yenieyi yoka, ana gung'ungamali.” ");
INSERT INTO mgv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu ampwagila, “Aandiki, ‘Gungungamalya Bambu Sapanga waku, nukuntumaki jombi pena.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ndienu Lijobi lunzukua Yesu mbaka ku Yelusalemu nukumbeka kunani pikibekubeku sikipaga sa Nyumba jaka Sapanga. Ampwagila, “Ana we wa Mwana waka Sapanga, ulilekala toka pamba mbaka pai. ");
INSERT INTO mgv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ndaba ahandiki, ‘Sapanga jaalagalakya atumi baki bu kunani kwaka Sapanga bugulonda.’ ");
INSERT INTO mgv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Nabombi bagujukua mwamaboku gabu, walikobando kugolu kwaku pililibo.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lakini Yesu ampwagila, “Ahandiki, ‘Gwanndenga Bambu Sapanga waku.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lijobi palajomula kundenga Yesu kwa kila sindu, andeka kipindi kisokopi. ");
INSERT INTO mgv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ndi Yesu ejakelubukiya kundema uku Galilaya, koni jutweli makili ga Loho jaka Sapanga. Majambu gaki gaenia ku Galilaya na ndema ya pambipi. ");
INSERT INTO mgv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jombi jabiya jaabola bandu mu nyumba yabu yukuketangane Ayaudi, na bandu boha batenda kundumbali. ");
INSERT INTO mgv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ndienu, Yesu jakelubuka ku Nazaleti, pandu pajukoli. Lisoba lu Kupomulela, jajenda mu nyumba jukuketangane Ayaudi ngati ejayobalile. Jajema nukusoma Maandiku ga Sapi kwa sauti. ");
INSERT INTO mgv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bumpekya kitabu saka Isaya jojabii Mlota waka Sapanga. Ejayekula, japaketannya pandu paahandiki, ");
INSERT INTO mgv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loho jaka Bambu jubi panani jangu, ndaba juhagwi nenga naapelakya Ahagu Lijambu la Amboni. Jundumiki naalandila apungwa kulekakewa, na banga kulinga biitenda kulinga. Jundumiki kagombo bandu bababone, ");
INSERT INTO mgv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nukupwaga masoba gahikiki gaka Bambu kagombo bandu baki.” ");
INSERT INTO mgv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu ejajomula kusoma, japunga kitabu se sela, ampekya ntumi, ndipala nukutama pai. Bandu boha bababi nkati mu nyumba jukuketangane Ayaudi butupila mihu. ");
INSERT INTO mgv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Najombi jaapwagila, “Lihandiku lende lenzowini litimi lelenu pamwakabii mwakajoaniya.” ");
INSERT INTO mgv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bandu boti bundongaliya sapi, balwehuka na malobi gaki ga sapi gajabia jakapwaga. Bapwaga, “Boo, jonzo le nga mwana waka Josepu?” ");
INSERT INTO mgv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu jaapwagila, “Manyiki mwibwagila lilobi lende, ‘Wa sing'anga gulilamisa wamwete!’ Kabee mwipwaga, ‘Goa gatujowini guhengiki ku Kapelinaumu, enu ugatenda kabee pamusi jaku pambane.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu jaendaliya kupwaaga, “Sakaka numpwagi, mlota ngasebunzetake pamusi jaki. ");
INSERT INTO mgv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nnzoannya! Sakaka numpwagi kwakabi na aka mbomba bingi buku Izilaeli baawii alomi babu kipindi saka Elia. Masoba ge gala ngasejakuniki iyula kwa miyaka mitato na mieyi sita, japitii inzala ngolongu nndema we woti. ");
INSERT INTO mgv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata hela Elia ngasebuntumiki kwaka mundu jokapi joawii alomi baki juku Izilaeli, ila pe kwaka mbomba joawii alomi jojutamika ku Selefati nndema juku Sidoni. ");
INSERT INTO mgv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mumasoba gaka Elisha jojabii mlota waka Sapanga kwabii na bandu bingi bababi aleliki. Ngamundu jokapi jojalamiki ila pe Naamani mwenei juku Silia.” ");
INSERT INTO mgv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bandu boha bababii mu nyumba jukuketangane Ayaudi pabajowana malobi ge haga bayomiki ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bajema, bunkamula Yesu kwa makili nunkangi kunza ja musi, bumpelika kunani jikitombi pabasengiki musi wabu. Bumpelika pukegi jilikemba bapala bunkangila pilikemba, ");
INSERT INTO mgv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","lakini Yesu jwapeta pikilanda jabu nukuyetuana. ");
INSERT INTO mgv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ndipala Yesu jahuluka mbaka ku Kapelinaumu musi uku Galilaya. Mlisoba lu Kupomulela jabiya jaabola bandu. ");
INSERT INTO mgv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Basangia uwesu gojabinaku pajabiya jutenda kubola. ");
INSERT INTO mgv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mnyumba jukuketangane Ayaudi, jabi mundu jwini kilombu, jajamalya nukupwaga, ");
INSERT INTO mgv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Gupala gututenda ki twenga wa Yesu uku Nazaleti? Guhikiki le kutukoma? Nenugumanye, wehapa ntumisi wa Sapi waka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu jikilakalya kilombu se sela, “Tumbala! Gumboka mundu hoju!” Kilombu suhabua pai mundu we jola palongi ja bandu boha, nukumpita bila kunhumisa. ");
INSERT INTO mgv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bandu boka basangii ngamaa, bakapwagannya, “Ganiaga mabolee bole? Mundu we hoju jubii nu uwesu na makili gukulakali, kilombu na sombi nukunzoanela.” ");
INSERT INTO mgv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ndienu majambu gaka Yesu gaeni pundema poti puku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu jaboka munyumba jukuketangane Ayaudi, jajenda munyumba jaka Simoni. Jaakolila akoanu baka simoni alwala homa ingali, nabombi bundoba Yesu jalamisa. ");
INSERT INTO mgv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ndienu Yesu jahika nukujenda pambipi najombi, nukujilakali homa je jela. Homa je jela jumboka, apalapa jatenda kujumuka, nukutumbuli kwaatelake posu. ");
INSERT INTO mgv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lyoba palabiya lakajingala, bandu bundetila Yesu agonzu ba kila namuna, najombi jaabekila maboku gaki kwa kila nngonzu, nakwaalamisa boti. ");
INSERT INTO mgv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ilombu yaapita bandu bingi, yajamalia koni yakapwaga, “Wehapa Mwana waka Sapanga!” Lakini Yesu jiilakaliya na ngasejiijetakali kupwaga sokapi, ndaba yumanyiki jombi ndi Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kilabu jaki pulukela Yesu jajenda kunza ja musi pandu panga bandu. Bandu batumbulya kuntaputa, ebumbona bumpengalya jiiboka. ");
INSERT INTO mgv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lakini Yesu jaapwagila, “Ahelahe mbalika kaalandi bandu Lijambu la Amboni lu Ubambu Ukolongu waka Sapanga mmisi jengi kabee, ndaba ndi sejundumi Sapanga kuhenga.” ");
INSERT INTO mgv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndienu jwaendalya kaalandi bandu mu nyumba yukuketangane Ayaudi buku ndema uku Yudea. ");
INSERT INTO mgv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lisoba limu, Yesu jabiya jujemiki pulutengu juhanga uku Genesaleti na papuje bandu batei kuntwelale koni babiya anyongaliti, bajoannya Lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jijibona minhwatu jibeli mulutengu ju nhanga, jebijileka alobo homba bababia abokani apiti kutabulana ilepa yabu. ");
INSERT INTO mgv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu jajingala munhwatu gumu waka Simoni, ampwagila Simoni juhegakya nhwatu kuhuma mulutengu ju nhanga mbaka mmasi. Ndipala jatama pai nukugubola nsambi wa bandu koni jubi munhwatu. ");
INSERT INTO mgv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pajajomula kubola, ampwagila Simoni, “Gukanga nhwatu we hogu mbaka papanyoliki ndienu wakalekala ilepa yaku mmasi gulopua homba.” ");
INSERT INTO mgv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni ampwagila, “Bambu! Tuhengiki lihengu likolongu le heli kelukelu bila kupata sindu sokapi. Lakini ndaba gupwagi wehapa, nyenda kuleke ilepa mmasi.” ");
INSERT INTO mgv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Balekala ilepa yabu mmasi na balopwi homba hingi ngamaa, mbaka ilepa yabu yatumbulya kujenduka. ");
INSERT INTO mgv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Henu baakema ajabu bababi mu nhwatu gongi ahika kwaajangati. Bahika, batwelakiya minhwatu joti mibeli homba mbaki yapala kuhobe mmasi. ");
INSERT INTO mgv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petili ejagabona ganiaga, ampegila magoti Yesu koni jakapwaga, “Bambu boka palongi jangu ndaba nepani mii na mahakau!” ");
INSERT INTO mgv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni pamu na ajaki boa basangia ndaba ja homba hingi yebalopula. ");
INSERT INTO mgv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobu na Yohana bana baka Zebedayu, bababii aloi ajaki Simoni batenda kusangaa ahelahe. Yesu ampwagila Simoni, “Wijogopa, tumbuka sajenu nukuendele nagutenda gubia waaleta bandu kwangu ngati ewabii gulobo homba nukupeleka kunyumba.” ");
INSERT INTO mgv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndienu, pabaleta pe minhwatu jela pulutengu ju nhanga, bagaleka goti, nukunzengale Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu ejabi musi gumu, kati ja misi ja hoku, jahika mundu jumu jojuleliki nhyega joti. Nngonzu we hoju eambona Yesu, jahabuka sukunzinamii, nukundoba Yesu, “Bambu, nagupai guwesa kunyambisa.” ");
INSERT INTO mgv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu janyoosha kuboku, angusa nukupwaga, “Mbala! Gunyambisika!” Apalapa kuleleka kwatenda kumboka. ");
INSERT INTO mgv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu ampwagila, “Wampwagi mundu jokapi. Ila gujenda, ukililangia kwaka nngolu nkolongu ukapia litambiku ngati Musa ejulagalakya, ili bandu boti abona wehapa gulamike.” ");
INSERT INTO mgv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lakini majambu gaka Yesu gajoanika ngani kila pandu. Bandu bingi bahika kunzoane na bapala jaalamisa magonzu gabu. ");
INSERT INTO mgv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakini Yesu kila mala jwajenda pandu panga na bandu, kola andoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lisoba limu Yesu pajabiya jutenda kubola, Afalisayu bangi naka abola ba malagalaki kuhuma misi juku Galilaya, ku Yudea nuku Yelusalemu, babi pala. Makili gaka Bambu gabia pamu najombi jakalamisa agonzu. ");
INSERT INTO mgv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Apalapa bandu bangi bahika antogwi mundu jumu jojulei angoniki pu mpandu, bapala kunzingi nkati ili bummbeka palongi jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lakini ndaba ju nsambi wa bandu, ngasebawesiki kunzingi nkate. Ndienu, bakwela panani ju nhagaa bahotula lihotu likolongu punhagaa nukunhulu jojulei we jola pikilanda ja bandu nukumbeka palongi jaka Yesu pamu nilipega laki. ");
INSERT INTO mgv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ejukubona kuhobale kwabu, ampwagila mundu jojulei, “Nkosiwango, gulekakiwi mahakau gako.” ");
INSERT INTO mgv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abola ba malagalaki na Afalisayu batumbulya kulilaluki beni, “Boo, hajo mundu bo joantondo Sapanga? Nya jojuwesa kulekake bandu mahakao? Sapanga kajika jojuwesa kwaalekake bandu mahakau!” ");
INSERT INTO mgv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu jagamanyiki mawasu gabu, jaalalukya, “Nhwasali kike mmyoju jino? ");
INSERT INTO mgv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sa sekijojwiki, kupwaga, ‘Gulekakiwi mahakau,’ au kupwaga, ‘Jema gujendaje?’ ");
INSERT INTO mgv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ndienu, mbala mmanya Mwana waka Mundu jubi nuuwesu pundema ukulekake mahakau ga bandu.” Papuje ampwagila mundu jojulei we jola, “Jema, jukua lipega laku gujenda kuyumba jaku.” ");
INSERT INTO mgv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Apalapa, mundu we jola jajema palongi jabu, jajukua lipega laki. Jajenda kunyumba jaki koni akundumbalya Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boti basangii ngamaa! Bajogupa nuku nndumbali Sapanga koni apwaga, “Lelenu twagabweni majambu gagasangasa!” ");
INSERT INTO mgv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Egapeta ganiaga, Yesu japita kunza ambona jojujopa kodi jumu joankema Lawi, jutemi mu nyumba jukulepe kodi. Yesu ampwagila, “Nyengalya!” ");
INSERT INTO mgv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi jajema, nukukileka kila sindu nukunzengale Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ndipala Lawi antendila Yesu tipati ngolongu kunyumba jaki. Nilikundi la bandu likolongu la baajopa kodi na bandu bangi babia akula pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lakini Afalisayu bangi naka abola ba Malagalaka baayomila banafunzi baki bakapwaga, “Ndaba jaki nkula na kunywa pamu na bandu bajopa kodi na baabi na mahakao?” ");
INSERT INTO mgv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu jaajibua, “Babii bomi ngaseampala sing'anga, ila baabi agonzu ndi babumpala sing'anga. ");
INSERT INTO mgv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngasenhikiki kakema bandu baamboni palongi jaka Sapanga, ila babi na mahakau, ajetakya mahakau gabu.” ");
INSERT INTO mgv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bandu bangi bumpwagila Yesu, “Banafunzi baka Yohana mmbatisa mala jingi apunga nu kuloba, hata banafunzi baka Afalisayu ahenga ahelahe. Lakini banafunzi baku akula na kunywa.” ");
INSERT INTO mgv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu jaajibua, “Boo, nhwesa le kwaapenga babaakokiki pandoa kula posu na akati abii na bambu jojupunga ndoa? Ngakuwesikana! ");
INSERT INTO mgv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakini lisoba lihika bambu ndoa pabamboa kati jabu, muda we hogu ndi pabipunga kula posu.” ");
INSERT INTO mgv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu jaapwagila lilenganu lende, “Mundu ngasejuseku kibambu si ingobu inyai nukusone mwiingobu jejilai. Ana jutei hela, kiijendula ingobu jejilai jejela, ni kibambu si ingobu inyai ngasilengani ni ingobu jejilai je jela. ");
INSERT INTO mgv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nga mundu jojujege divai inyai mumipuku jealenganaki na ngosi ja mwandi. Ana jutei hela, divai inyai jela jitenda kututumuka nukujendu mipuku jealenganaki na ngosi je jela, divai jiitenda kujitika ni mipuku jealenganaki na ngosi jitenda kuhalabika. ");
INSERT INTO mgv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakini bandu abeka divai inyae mumipuku jealenganaki na ngosi inyae! ");
INSERT INTO mgv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nga mundu jojupala kunywa divai ja mwandi na divai inyai, ndaba jiipwaga, ‘Divai ja mwandi ndi ja sapi.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lisoba limu lu Kupomulela Yesu jabiya jupeta pikilanda ja matui gi inganu. Banafunzi baki batumbulya kupanyu ipambiku yi inganu, bapulua inganu yaki kwa maboku, nakula. ");
INSERT INTO mgv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Afalisayu bangi andalukiya, “Ndaba jakii nhenga lijambo leakaniki kutenda Lisoba lu Kupomulela?” ");
INSERT INTO mgv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu jaalalukya, “Boo, ngasensomiki lee sejahenga Daudi pamu na ajake pababii ni inzala? ");
INSERT INTO mgv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi jajingala mu Nyumba jaka Sapanga, jajukua mabumunda gabumpekya Sapanga, nakula. Kabee gangi jaapekya ajaki. Malagalaki gaka Musa gunkana mundu jokapi kula mabumunda ge haga ila agolu pena ndi baatakiwa kula.” ");
INSERT INTO mgv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ndipala Yesu jaapwagila, “Mwana waka Mundu jubi nuwesu Mlisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lisoba lengi lu Kupomulela Yesu jajingala kubola mu Nyumba jukuketangane Ayaudi. Mu nyumba mola jabi mundu jojulei kuboku kwaki kwa malele. ");
INSERT INTO mgv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aka abola bangi Malagalaki na Afalisayu bapala apata kikopakale sukunkamuli Yesu. Henu babia andingali ngamaa ana andamisa mundu Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakini Yesu jikimanyiki sebawasalya, ampwagila mundu jojulei kuboku jola, “Hika gujema pikilanda pamba.” Mundu we jola jajema nukujenda kujema pikilanda. ");
INSERT INTO mgv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndipala Yesu jaapwagila, “Nundaluki mwanganya, boo, mu Lisoba lu Kupomulela sapi le kuhenga lijambu la sapi au kuhenga lijambu lilyaa, kundamisa mundu au kunkoma?” ");
INSERT INTO mgv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jaalinga bandu boti bababi pala, ampwagila mundu we jola, “Nyoosa kuboku kwaku.” Jahenga ngati Yesu eampwagila, nu kuboku kwaki kwatenda kulama. ");
INSERT INTO mgv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lakini bombi bayomiki ngamaa batumbulya kupwagani sindu siliyaa sukuntenda Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mmasoba gala Yesu jajenda kukitombi, jatama kelukelu akundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ekwakusa, Yesu jaakema banafunzi baki. Jaahagula banafunzi komi na abeli nakakema atumi. ");
INSERT INTO mgv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bajahagula be ndi Simoni, joampekia Yesu liina Petili na Andilea nnuhuna waki na Yakobu na Yohana na Pilipi na Batolomayu. ");
INSERT INTO mgv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matei na Tomasi na Yakobu mwana waka Alufayo na Simoni jowankemika Zelote, mundu jojukomane nndema waki. ");
INSERT INTO mgv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana waka Yakobu na Yuda Isikaliote, joang'alumbuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu pajahuluka pikitombi pamu na banafunzi baki, jajema puubamba ni likundi likolongu la banafunzi baki. Bandu bingi bababi pala bahuma nndema yoka yuku Yudea, na Yelusalemu na babahuma nndema yoka yuku kumbwani ja Tilo na Sidoni. ");
INSERT INTO mgv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bandu haba bahika kunzoane Yesu nu kulamiswa magonzu gabu. Kabee bandu baang'alika ni ilombu bahika nukulamiswa. ");
INSERT INTO mgv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bandu boa bapala kunngusa Yesu, ndaba makili gabia gumpita nkati jaki na kwaalamisa bandu boti. ");
INSERT INTO mgv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu jaang'anumbukya banafunzi baki, nukupwaga, “Mpengaliwi mwanganya mombii mwahagu, ndaba Ubambu ukolongu waka Sapanga gwinu. ");
INSERT INTO mgv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mpengaliwi mwanganya mommbii ni inzala sajenu, ndaba mwitenda kutupi!” Mpengaliwi mwanganya mondela heno, Ndaba mwitenda kutogule! ");
INSERT INTO mgv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mpengaliwi mwanganya ana bandu bitenda kunsuki, biitenda kummbagu nukuntondoo nukumpwaga mwanganya mwaabaja, ndaba jaka Mwana waka Mundu! ");
INSERT INTO mgv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ntoguliya nukuhina haga pagipitila ndaba nhupi jinu bammbekia kunani kwaka Sapanga. Hela ndi aseja babu ebaatendila alota. ");
INSERT INTO mgv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakini mwing'alika mmbanganya mombi na mali gingi, ndaba mwanganya nntoguli mmwoju jino! ");
INSERT INTO mgv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mwingalika mwaanganya montupi sajeno, ndaba pamwibia ni inzala! Mwiing'alika mwanganya montogule sajenu, ndaba mwagubona usungu nukulela!” ");
INSERT INTO mgv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mwiing'alika ana bandu boti bandumbalya mwanganya sapi! Ndaba hela ndi aseja babu baahengila alota biisoli.” ");
INSERT INTO mgv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lakini numpwaji mmbanganya monyoane, mwaapala abaja binu, na mwahengila ga sapi babunsuki, ");
INSERT INTO mgv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwapengila bandu bala babundiga, nakalobe kwaka Sapanga bandu babuntende galiya. ");
INSERT INTO mgv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mundu ana jugulapwi lituku limu, gung'anumbukiya ni lituku lengi, mundu najugunyagiki puti jaku, gundekila jujukua ni likoti laku. ");
INSERT INTO mgv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jokapi jojuguloba sindu gumpekiya, na mundu jojugunyaga hindu yaku gwipala jugukelubukiya. ");
INSERT INTO mgv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mwatendila bandu banhengila ngati empala buntendila mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Anamwapai babumpala mwanganya pee, boo, mwiipata nhupi bole? Hata baabi na mahakau baapala babapala bombi! ");
INSERT INTO mgv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ana mwahengi ga sapi bandu babuhenge mwanganya ga sapi mwiipata mbengee bole? Hata baabi na mahakau ahenga ahelahela! ");
INSERT INTO mgv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ana mwaakopisi bandu banhobale bundepa, boo, mwiipata mbengee bole? Hata baabi na mahakau baakopesa ajabu nu kuhobale bakelubukya.” ");
INSERT INTO mgv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Lakini mwaapala babunsuki mwanganya nakatende gasapi, mwaakopisa bila kunhobale kunkelubuki. Ndienu hupi jinu jibia ngolongu kunani kwaka Sapanga na mwiibia mwabana baka Sapanga jojubi kunani ngani. Ndaba jombi jwa amboni kwa bandu banga kunsengu na bandu abaya. ");
INSERT INTO mgv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mmbia ni ikia ngati Atati binu ebii ni ikia. ");
INSERT INTO mgv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mwaatemu bandu bangi na Sapanga ngajantemu. Mwaang'alisa bangi na Sapanga ngajanng'alise, mwaalekakya bangi na Sapanga jaanndekakya mwanganya. ");
INSERT INTO mgv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwapekia bandu bangi yeapala na Sapanga jampekya, nanamu mwiijopa kipemu sekitweli mukuboku mbaka kujitika. Ndaba kipemu sentumi kwa bandu bangi, Sapanga jiitumia kipemu sese kwinu.” ");
INSERT INTO mgv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ndienu Yesu jaapwagila lilenganu lende, “Boo, jwanga kulinga le juwesa kundongo jwanga kulinga nnzake? Ngahela! Boti biabukiya mulibomba. ");
INSERT INTO mgv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mbolee ngaseampeta mmbola wake, lakini mbolee anajujomwi kubolwa kwaki jukuba ngati mmbola wake. ");
INSERT INTO mgv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndaba jakii ukibona kijola mmihu juku nnzaku, lakini ngaseulibona lumbagau lolubii nndiu jaku? ");
INSERT INTO mgv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Guwesa boo, kumpwagi nndongu wako, ‘Nndongu wango, leka nuguboi lumbagau nndiu jaku,’ na wamweti ngaseulibona lijola lelibii nndiu jako? We ulikopake waamboni! Guboa oti lijola lelibii nndiu jaku, ndienu wiilinga sapi nukukibona kijola sekibii nndiu juku nndongu waku. ");
INSERT INTO mgv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nkongu wa sapi ngasegubeleka matunda giliya, wala ngakuba nkongu uliya gogubeleka matunda ga sapi. ");
INSERT INTO mgv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bandu bugumanya nkongu kupete matunda gaki, lakini bandu ngakuwesa kutongo matunda gabagakema tini kuhuma mumi gwandu, wala ngaseatongo zabibu kuhuma mmbigili. ");
INSERT INTO mgv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu jwa amboni jupia gagabi ga sapi kuhuma gajagabei mmwoju jaki, na mundu juliya jupia gagabi giliya kuhuma nkati gajabei mmwoju jake. Ndaba mundu julonge gagatweli mmwoju jake.” ");
INSERT INTO mgv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ndaba jakii nngema, ‘Bambu, Bambu,’ nakoni ngasenntenda ganumpwagila ntenda gala? ");
INSERT INTO mgv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nampekya lilenganu lelilengana na mundu jojupalika kuhika kwangu nenga. Jojupalika kuhika kwangu ndi mundu jojujoane malobi gangu nakugahenga ngati ekupalika. ");
INSERT INTO mgv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Hoju julengana na mundu, jojusenga nyumba, sukuhemba pai ngani pililibu, nukusenga nyumba je heji panani jaki. Esahika kikoka ngasesawesa kujinyua nyumba, ndaba basengiki sapi. ");
INSERT INTO mgv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakini jokapi jojujoana malobi gangu bila kugatenda ngati ekutakiwa, hoju julengana na mundu jojasengiki nyumba munsangi bila kuhemba ngani. Kikoka esahika, masi gijinyua nyumba nukujihabu, na nyumba joti jatenda kubomboka!” ");
INSERT INTO mgv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu pajajomula kupwaga majambu gala kwa bandu, jajenda ku Kapelinaumu. ");
INSERT INTO mgv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kokuje jabi nkolongu jumu jwa alonda makomi komi juku Loma, jojabi nu ntumi waki joampai ngani. Ntumi we hoju jutendika kulwala jahegalya kuwa. ");
INSERT INTO mgv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nkolongu we jola ejwajowana majambu gaka Yesu, jatuma aseja bakumu buku Uyaudi ajenda kundoba Yesu juhika kundamisa ntumi waki. ");
INSERT INTO mgv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ebahika kwaka Yesu bundobiki ngamaa, bapwaga, “Kye! Mundu hoju jupalika unzangatiya, ");
INSERT INTO mgv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ndaba jombi jaapai bandu bitu najombi ndi jojutusengiki Nyumba jukuketangane Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ndienu, Yesu jajenda pamu na bombi. Ejahegalya kuhika kunyumba jaka nkolongu hoju, nkolongu hoju jaatuma akakosi baki ampwagila Yesu, “Bambu, wing'alika kuika koni, ndaba nenga ngasembalika wenga kujingi nnyumba jango. ");
INSERT INTO mgv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndaba nepani ngase mbalika hata kuhika kwako. Lakini pwaga pee lilobi, nu ntumi wa jwiitenda kulama. ");
INSERT INTO mgv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndaba namweti kabee mipai ju ukolongu, mi na alonda pai jangu. Ana numpwagi jumu, ‘Jenda!’ Najombi jutenda kujenda, ana numpwagi jongi, ‘Hikaa!’ Najombi jutenda kuhika, ana numpwagi ntumi wangu, ‘Henga ase!’ Najombi jutenda kuhenga.” ");
INSERT INTO mgv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ejajoana ganiaga, jatenda kusangaa ndipala jugung'anumbukya nsambi wa bandu gogwabia gunzengalee, nukugupwagi, “Sakaka numpwaji ngasenumbweni mundu jwana hobale ngati jenze hata ku Izilaeli!” ");
INSERT INTO mgv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndipala bandu be bala pabahika kunyumba juku nkolongu jwa alonda juku Loma bunketannya ntumi we jola julamiki. ");
INSERT INTO mgv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Monikatae, Yesu jajenda ku musi gumu gobugukema Naini na banafunzi baki, koni julongini nu usambi wa bandu. ");
INSERT INTO mgv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ndienu,Yesu ejahegalya pundyangu nkolongu wa musi, bapitila bandu babatotwi nsiba guku nkombu, nkombu weni jabia mwana wa kanzika kwaka mmbomba joawi alomi. Nu nsambi wa bandu wa musi gola wabi pamu nu mmbomba we jola. ");
INSERT INTO mgv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bambu ejumbona mmbomba jola, ambonila ikia, ampwagila, “Wilela.” ");
INSERT INTO mgv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ndipala Yesu, jajenda kukamu uleli we gola, na bababia atotwi uleli gola batenda kujema. Yesu japwaga, “Nkomboo! Nugupwaji jumuka!” ");
INSERT INTO mgv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nkombu jojawi we jola jatenda kujumuka, nukutumbuli kulonge. Yesu ankabisa nkombu we jola kwa amabaki. ");
INSERT INTO mgv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bandu boka batenda kujogopa nukundumbali Sapanga koni bakapwaga, “Mlota nkolongu jupitii kati jitu. Sapanga juhikiki kwaajangati bandu baki.” ");
INSERT INTO mgv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Majambu gaka Yesu gaeniya mu Yudea mwoka na ndema ya pambipi. ");
INSERT INTO mgv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Banafunzi baka Yohana Mmbatisa bajenda nukumpwagi Yohana majambu goti gajahenga Yesu. Najombi jaakema banafunzi baki abeli, ");
INSERT INTO mgv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jaatuma kwaka Bambu bukundalukya, “We lee ndi jojapwaga Yohana Mmbatisa guhika, au tundendaliya jonge?” ");
INSERT INTO mgv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Banafunzi bala pabunhikila Yesu bumpwagila, “Yohana mmbatisa jututumiki kwaku tugulalukya, ‘We lee ndi jojuhika, au tundendalya jonge?’ ” ");
INSERT INTO mgv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kipindi aselase, Yesu jabiya jaalamisi agonzu bingi ngamaa, japia bandu bingi ilombu na kwaajangatii banga linga kulinga. ");
INSERT INTO mgv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndienu, Yesu jaajibua banafunzi baka Yohana Mmbatisa, “Nnzendannya mukumpwagila Yohana gamwagabweni na ganzoini, banga linga henu atenda kulinga, na ilema atenda kujenda na baaleliki atei kunyambisika na bangajoa atenda kujoana na baawii ateikuyoka na ahagu baalandi Majambu ga Sapi. ");
INSERT INTO mgv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jupengaliwi mundu jojuhobale nepani!” ");
INSERT INTO mgv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndienu, banafunzi baka Yohana pababia abohi, Yesu jatumbulya kwaapwagi bandu majambu gaka Yohana, “Pamwajenda kulungwenza mwajenda kulinga kike? Boo, mwajenda lee kulinga nndai lelinyuka nu nhwae? ");
INSERT INTO mgv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Boo! Henu mwajenda kulinga kike? Mwajenda lee kundinga mundu jojuweti ingobu yeinyambike? Bandu baawata ingobu yeinyambiki nukutama kwa laha, atama mumanyumba gu ubambu ukolongu! ");
INSERT INTO mgv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Henu mwajenda kulinga kike? Mwajenda lee kumbona mlota waka Sapanga? Heelo, sakaka lakini mubweni nkolongu kupeta Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jonioju Yohana jobumpwaga mu Mahandiku ga Sapi, Sapanga japwaga, ‘Nantuma ntumi wangu jugulongulya, jojaguhandaliya indela jaku.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ndienu Yesu jaapwajila, “Numpwagi, Yohana Mmbatisa ndi nkolongu kati ja bandu boti baabelikwi nu mmbomba. Lakini mundu jojubi nsoku mu Ukolongu waka Sapanga ndi nkolongu kupeta Yohana.” ");
INSERT INTO mgv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bandu boa pamu na baajopa kodi ebajowana ganiaga bajetakiya indela jaka Sapanga ndi ja sakaka na haba ndi bababatiswa na Yohana. ");
INSERT INTO mgv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lakini Afalisayu naka abola ba Malagalaki, bakana gajalagalakiya Sapanga kwabu, kabee bakana kubatiswa na Yohana. ");
INSERT INTO mgv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu jaendaliya kupwaga, “Boo! Bandu bikibeleku senze alengana na kike? Alengana na sindu bole? ");
INSERT INTO mgv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Alengana ngati bana baabii kugulio. Akemana beni na beni. ‘Tunzembi mapenenga, lakini ngasemwahiniki! Tunzembi mihambu ja malelu, lakini ngasemwaleile!’ ");
INSERT INTO mgv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ndaba Yohana Mmbatisa jahikiki, jukubika jupunga kula wala ngase jukunywikaje, nanamu mwapwaga, ‘Yohana jubi ni ilombu!’ ");
INSERT INTO mgv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana waka Mundu juhikiki, jukula na kunywa, nanamu mpwaga, ‘Mundu jonzo jukula ngamaa na julobe ngamaa, nkosi jwa bandu baajopa kodi na baabi na mahakau!’ ");
INSERT INTO mgv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lakini malangu gaka Sapanga galangi sakaka kwa bandu boka babunzetaki.” ");
INSERT INTO mgv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo jumu ankokiki Yesu kula posu ja pakamii kunyumba jaki. Yesu jajingala ku nyumba jaka Mfalisayu we hoju, nukutama kula posu. ");
INSERT INTO mgv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pa musi je pala jabii nyongo jumu jwana mahakau. Ejwajowana Yesu jukula mu nyumba jaka Mfalisayu hoju, mmbomba jahika nilisupa lebalenganaki kwa malibu ga alabasita lelabii na mahuta gaganungii sapi. ");
INSERT INTO mgv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mmbomba we jola jajema pambipi na magolu gaka Yesu, koni julela na maholi gaki gahabukya mmagolu gaka Yesu. Ndipala jagahungula magolu gaka Yesu kwa majunzu gaki, nukugasonzoo magolu nu kugapakia mahuta. ");
INSERT INTO mgv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayu joankoka Yesu jola pajagabona haga, jawasalya mmyoju jaki, “Mundu ajo ana sakaka mlota waka Sapanga, jakamanya mmbomba joankamwi ajo jubii boo, jakamanya jubii na mahakau.” ");
INSERT INTO mgv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ampwagila Mfalisayu jola, “Simoni, mina sindu mbala kukugupwagila.” Simoni jajibua, “Ena mmbola, mbwagilaje.” ");
INSERT INTO mgv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu jatumbuliya kupwaga, “Bandu abeli babii bunkopiki mundu lupija, jumu jabia jukopiki lupija makomi hamsine, na jongi makomi nhwanu. ");
INSERT INTO mgv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pabasindwa kulepa lupija lola, mundu we jola jojaakopesa lupija jaalekakya boti abele. Boo nyanye kati jabu joampala ngani mundu jojukopesa lupija jola?” ");
INSERT INTO mgv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni jajibua, “Neholale joandekaki lupija lwingi ngani jola ampala ngani jojukopesa jola.” Yesu ampwagila, “Gujibwiki sapi.” ");
INSERT INTO mgv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ndipala Yesu ang'anumbukya mmbomba we jola, nukumpwagi Simoni, “Boo gumbweni lee mmbomba jonzone? Nepani enyingala nnyumba jaku, ngasewambeki masi gu kusamba magolu gangu, lakini mmbomba jonzo jung'olwi magolu gangu kwa maholi gaki nukuputa kwa majunzu gaki. ");
INSERT INTO mgv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wehapa ngasewanamuki sukunzonzo, lakini mmbomba jonzo tumbuka panyingala pambani ngasejakotwiki kubusu magolu gango. ");
INSERT INTO mgv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wehapa ngasewangalibisi sukumbaki mahuta kumutu, lakini mmbomba jonzo jumbaki mahuta gaganungi mwamagolu gango. ");
INSERT INTO mgv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nugupwagi, ndaba julekakewa mahakau gaki gingi, henu jumbai ngani. Jojulekakiwi mahakau kidogu, jupala kidogu.” ");
INSERT INTO mgv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ndienu Yesu ampwagila mmbomba we jola, “Gulekakiwi mahakau gaku.” ");
INSERT INTO mgv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bandu bangi bajabi jukula naku batumbuliya kupwagani, “Hajo mundu boo jojuwesa kulekake mahakao?” ");
INSERT INTO mgv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu apwagila mmbomba jola, “Kuhobale kwaku kugukombwi. Jenda sulukwali.” ");
INSERT INTO mgv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ebajomula ganiaga, Yesu jayongulitya mmusi ni kwijiji, koni jakalandila bandu Lijambu la Amboni lu Ukolongu waka Sapanga. Mwoha mojapetila jabi pamu na banafunzi baki komi na abeli, ");
INSERT INTO mgv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","jalongini kabee na aka mbomba bangi bababi Yesu jaapihiki ilombu nakwaalamisa magonzu. Aka mbomba be ndi Malia juku Magidala, jojabi Yesu ampihiki ilombo saba, ");
INSERT INTO mgv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana nhwanu waka Kuza, kilongosi wapasengu jaka Helodi na Susana na aka mbomba bangi bingi bababii apia hindu yabu hingi kunzangati Yesu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nsambi wa bandu gunzendila Yesu kuhuma kila musi, nu nsambi wa bandu gola pawaketangini pamu, Yesu jaapwajila lilenganu lende. ");
INSERT INTO mgv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mpanda jajenda kukweta imbeju yaki. Ejwabia jukweta imbeju mulituhi, imbeju yengi yaabuka mwindela. Babapeta mwiindela batenda kuitimbana ni ijuni yakula imbeju ye yela. ");
INSERT INTO mgv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imbeju yengi yaabukiya puluhombi lolubii pililibu, payamela yatenda kunyala ndaba ubeibei ngasegabii muluombi. ");
INSERT INTO mgv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yengi yaabukya pimikongu ja miya, mikongu ja miha yela heyakola yatenda kuihinya mimea jejela. ");
INSERT INTO mgv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yengi yaabuki muluombi lwa sapi, nayombi yamela nukupapa ilebi, kila jimu ja papa nu kujonzukeka mala miya jiimbeju jejapandiki.” Yesu pajwapwaga hela japwaga kwa sauti, “Mundu jojubi na makutu gukujoane nujujowana!” ");
INSERT INTO mgv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Banafunzi baka Yesu bundalukiya ndaba jililenganu lela, ");
INSERT INTO mgv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu jajibua, “Mmbanganya bunhwesisi kumanya indu ya sili yu Ukolongu waka Sapanga. Lakini bandu bangi mbwaga nabu kupete malengano, biilinga lakini biibona, ajowana lakini biihelewa sindu.” ");
INSERT INTO mgv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ndienu ndaba jililenganu le heli ndi jenze, imbeju jilangi Lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeju yeyahabwiki mwindela, ilangi bandu babilijowane lilobe, lakini Lijobi lihika nu kuliboa lilobi mmyoju jabu, ili biihobale nu kulama. ");
INSERT INTO mgv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imbeju yeyahabuki puluhombi lolubi pililibu lilangi bandu bala babilijone lilobi, bilijopa nukutogule, ila ngase lijingi nkati ja myoju jabu ndaba ngaselibii ni mikega. Bilihobale kwa muda nsokopi, lakini kipindi si milengu ji lijobi akotoka kuhobale lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeju yeyahabuki mwi mikongu ja miha ilangi bandu bala babilijone lilobi laka Sapanga, lakini eaendale kidogu, lilobi laka Sapanga lihinywa nikiholu ndaba jamang'aliku ga mahengu ga kila lisoba, kutokule, kutogule, nukupala kuba na mali gingi hiliya, kwaatenda bandu haba biihendelee kulijetake lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lakini imbeju yeyahabuki muluhombi lwa sapi ndi jilangi bandu bala babilijone lilobi laka Sapanga nukulikamu kwa mwoju wabu nukulihobale, nukuendele kuhenga ga gundengane Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Bandu ngase apambaki taa nu kujiyekale nikitonga au kujibeka kwii ji kitanda. Lakini bijibeka pikipanda, ndaba kila mundu jojujingi nkati jugubona unang'anu. ");
INSERT INTO mgv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Sokapi sebikihihiki sibiya pangwendu, na sokapi seyekali simanyikana nakuba pa gwenda. ");
INSERT INTO mgv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ndienu nzepana na ganzowana, ndaba mundu jokapi jojubi na sindu biitenda kunzonzukela, lakini jwanga na sindu bannyaga hata kidogu sejawasali jubi nasu.” ");
INSERT INTO mgv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Anyongo na alongu baka Yesu batenda kunhiki, lakini ngasebawesiki kuhika pambipi jaki ndaba ju nsambi wa bandu. ");
INSERT INTO mgv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu jumu ampwagila Yesu, “Anyongo baku na alongu baku ajemiki kunza, apala kugubona.” ");
INSERT INTO mgv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu jaapwajila, “Anyongo bango na alongu bango ndi babilijowane lilobi laka Sapanga nukulihenge lihengu.” ");
INSERT INTO mgv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lisoba limwa Yesu jakwela munhwatu pamwa na banafunzi baki na kwaapwagi, “Tulombuka tujenda kwii junhanga.” Ndipala, batumbulya sapwali. ");
INSERT INTO mgv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ebabiya mwindela, Yesu jagosila lugonu. Apalapa kimbonga kikolongu satumbuka kupoga mu nhanga, masi gatumbuka kujingi nkati ju unwatu, boti baegaliya kuwa. ");
INSERT INTO mgv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Banafunzi bunzendila Yesu nukunzumu nu kumpwaji, “Bambo, Bambo! Tutenda kuwa!” Yesu jajumuka nu kukilakali kimbonga se sela na majeba ga masi, nayombi yatenda kukotoka. Nunhanga watulia nuuu. ");
INSERT INTO mgv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndienu Yesu jaalalukiya banafunzi baki, “Kuobale kwii kubi kwako?” Lakini bombi basangii, bajogopa koni bakapwaganya, “Boo! Jonujuwe nyanye? Mbaka jikilakali kimbonga na majeba nayombi itenda kunzowanela!” ");
INSERT INTO mgv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na banafunzi baki baendaliya na sapwali, bahika kumbwani uku nndema uku Gelasi, jejibii kwii junhanga uku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu ejwabiya juhuluka pee kuhuma munhwatu kumbwani, jwaketangana na mundu jojabii niilombu. Mundu we jola ngasejawatiki ingobu kwa masoba gingi, jukubika ngasejutama nkati ja nyumba, lakini jukubika jutama ku matengela. ");
INSERT INTO mgv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eambona pe Yesu, jalela nuku jileke pai palongi jaka Yesu nukujamali koni jakapwaga kwa sauti, “We wa Yesu Mwana waka Sapanga Wogubii Kunani Ngani! Boo gupala ki kwangu nenga? Nuguloba, gwing'alisa!” ");
INSERT INTO mgv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mundu we jola japwaga hela ndaba Yesu jabia jikipwagi kilombu se sumpita mundu we jola. Kilombu se hesi kikubika suntukali mundu we hoju mala jingi. Hata ana bandu babia bunzigali nkati koni mumagolu na mumaboku babiya bunkongiki kwi minyolu, lakini jombi jukubika jutenda kuseku. Kilombu se sela kikubika sunzombate mbaka pulungwenza. ");
INSERT INTO mgv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu andalukiya, “Lihina laku wa nyanye?” Anzibua, “Nsambi waalonda.” Japwaga hela ndaba jabii ni ilombu hingi. ");
INSERT INTO mgv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ilombu ye yela yundoba Yesu jaipwaji ijenda ku libomba lilasu langa na mwisu. ");
INSERT INTO mgv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pambipi na pala wabi nsambi nkolongu wa magolobi gatenda kula pikitombi. Ndipala ilombu ye yela yundoba Yesu jiijetakya yagajingala magolobi, najombi Yesu jajetakiya yagajingala magolobi. ");
INSERT INTO mgv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ilombu yela yumpita mundu jola, nukujingi mumagolobi gala. Nsambi wa magolobi gola gwatila pikiheleu kikolongu nu kujingii munhanga, nukuwele mmasi. ");
INSERT INTO mgv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Alimu ba magolobi bala ebabona goti gala ga gahengiki, batenda kutila bajenda kaalandi bandu kumusi nuku ijiji. ");
INSERT INTO mgv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bandu bajenda kulinga ga gapiiti, pabahika kwaka Yesu, bumbona mundu jola joyumpitaa ilombu jutemi pambipi na Yesu, juweti ingobu, malangu gaki gunkelubuki kabee. Bandu boka batenda kujogopa. ");
INSERT INTO mgv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bandu bala bababona lijambu lela baalandila bandu Yesu heandamisa mundu jola. ");
INSERT INTO mgv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndienu bandu bu nndema uku Gelasi saakamwi kiholu kikolongu. Ndipala bundoba Yesu juboka kwabu, ndienu Yesu jakwela munhwatu, nu kuboka. ");
INSERT INTO mgv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu jola joyumpitiki ilombu andoba Yesu, “Nandi noba nyenda pamu na wenga.” Lakini Yesu ngase anzetaki kujenda naku, ila ampwagila, ");
INSERT INTO mgv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gubuja ku nyumba wakaalandila bandu majambu goka makolongu ga juguhengi Sapanga.” Ndienu, mundu jola jajenda musi goti nakaalandi bandu majambu ga junhengi Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu ejwakelubuka upandi gongi gunhanga, nsambi nkolongu wa bandu gunzopa sukutogule ndaba boti batenda kundendale. ");
INSERT INTO mgv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ndienu jahika mundu jumu joakema Yailo, jojabii kilongosi jwa nyumba jukuketangane Ayaudi. Jililekala mwamagolu gaka Yesu, andoba jujenda kunyumba jaki, ");
INSERT INTO mgv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ndaba kamwali waki wa kajika, jwana yaka komi ni mibele, jwabiya juhegale kuwa. Yesu ejwabiya jutenda kujenda, nsambi wa bandu gwatenda kunhinya pandi yoka. ");
INSERT INTO mgv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Muunsambi wa bandu gola, jwabi mmbomba jumu pikilanda ju unsambi wa bandu gola, jojuwe jwabi mmbomba junu ugonzu gukujahuka kwa miaka komi ni mibele, kabee jwabiya jutumi hindu yaki hingi kwaka sing'anga, nga mundu jojawesa kunndamisa. ");
INSERT INTO mgv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mmbomba we jola ampwata Yesu sumunyuma, nukugusa mu lupeta lwi ingobu yaki, apalapala ugonzu waki hukujahuka watenda kulama. ");
INSERT INTO mgv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu jalalukiya, “Kanono! Nya jojung'usike?” Bandu boka batenda kukana. Petili japwaaga, “Bambu, nsambi wa bandu guguyongalwiti nukuguhinya.” ");
INSERT INTO mgv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lakini Yesu japwaga, “Nemanyiki mundu jutei kung'usa, ndaba nilijowani makili gangu gandei kumbita.” ");
INSERT INTO mgv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mmbomba jola pajilibona ngasejuwesa kulihiya, japitila koni jakabagaja sukujogopa. Jililekala pamagolu gaka Yesu. Ndipala japwaga pa bandu boha ndaba jukugusa ingobu jaka Yesu nu kulama. ");
INSERT INTO mgv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu ampwagila mmbomba jola, “Kamwali wango, kuhobale kwaku kugulamise. Gujenda sulukwali.” ");
INSERT INTO mgv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu pajabiya jakoni jakalongela, jahika ntenga kuhuma ku nyumba jaka Yailo. Ampwagila Yailo, “Kamwali waku juwile, ndaba jaki kunsumbu Mmbola?” ");
INSERT INTO mgv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lakini Yesu ejwajowana ganiaga apwagila Yailo, “Gwijogopa, we guhobaliya pena, na mwana waku mbaka julame.” ");
INSERT INTO mgv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu pajahika kunyumba jaka Yailo, jaakana bandu biijingi nkati pamu najombi ila ajingala pe Petili na Yohana na Yakobu na amabu na ahengo baka kamwali we jola. ");
INSERT INTO mgv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bandu boka babiya bakalela nukulobalake ndaba jaka kamwali jola. Lakini Yesu jaapwagila, “Mwilela, ndaba kamwali ngase juwile ila jutei kugone pee.” ");
INSERT INTO mgv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bandu boti bunheka Yesu ndaba babia amanyiki kamwali jola juwii. ");
INSERT INTO mgv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ndipala Yesu ankamula kuboku kamwali jola nukumpwaagi, “Mwanango, jumuka!” ");
INSERT INTO mgv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kamwali jola womi waki unkelubukiya kabee, apalapa jatenda kujumuka. Ndipala Yesu jaaloba bumpekia posu kamwali. ");
INSERT INTO mgv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ahengo na amabu baki basangii ngamaa, lakini Yesu jaakanakiya bampwagi mundu jokapi sekipitii. ");
INSERT INTO mgv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu jaakema pamu banafunzi baki komi na abeli, jaapekia makili nu uwesu gwakaboa bandu ilombu, nakwalamisa agonzu. ");
INSERT INTO mgv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ndienu jaatuma ajenda bakaalandila bandu lijambu lu Ukolongu waka Sapanga nakalamisa agonzu. ");
INSERT INTO mgv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jaapwagila, “Mwiitoto sindu sokapi emwijenda mwiindela, mwitoto ndonga, wala kibwahila, wala posu, wala lupija, wala ingobu ibeli. ");
INSERT INTO mgv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba jokapi jemwijingala nukunzopa, mwakatama momu mbaka pamwiboka mwikijiji se hesi. ");
INSERT INTO mgv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bandu nabunkaniki kunzopa, mmbokaniya musi we hogu, nanamu emwibia ntenda kuboka mwikung'unda luhombi mwamagolu ginu jibiya nginyuli kwabu jukunkana kunzowane.” ");
INSERT INTO mgv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ndipala, banafunzi batenda kuboka, bapeta kila hijiji koni bakaalandila bandu Lijambu la Amboni nakalamisa agonzu kila pandu. ");
INSERT INTO mgv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nkolongu Helodi juku Galilaya, pajabona majambu goha gagahengika. Jajogupa ndaba bandu bangi babiya apwaaga, Yohana mmbatisa juyokiki. ");
INSERT INTO mgv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bandu bangi bapwaga Elia jutei kupitii, na bangi bapwaga jombi ndi jumu ja alota baka Sapanga ba mwandi, jutei kuyoka. ");
INSERT INTO mgv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helodi japwaaga, “Yohana mmbatisa we nunsekwii kimutu, jo nyowana majambu gake hoju nyane?” Najombi japala ammbona. ");
INSERT INTO mgv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Atumi bala pabakelubuka bumpwagila Yesu goha gabahengiki. Yesu jaajukua banafunzi baki nukujenda nabu pandu panga na bandu kumusi uku Betisaida. ");
INSERT INTO mgv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lakini bandu ebamanya kobapiti, batenda kunkagu. Yesu jaajopa, na kwaabola Ukolongu waka Sapanga egubii nakalamisa boka babapala kulama. ");
INSERT INTO mgv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Palajingala lyoba, banafunzi komi na abeli bala bunzendila Yesu nukumpwagi, “Waapwagila bandu haba ajendaninnya kwijiji ya pambipi na kwamatui bakataputa posu na pandu pukugone, ndaba pamba je pulungwenza.” ");
INSERT INTO mgv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lakini Yesu jaapwagila, “Mwaapekia mwanganya poso akulaje.” Nabombi bunzibua, “Twepani tubii na mabumunda unhwano na homba ibele pena. Boo gupala lee tujenda twabeti twakaalombila posu bandu behaba?” ");
INSERT INTO mgv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Papuje babii akanalomi ngati elupu unhwano. Yesu jaapwagila banafunzi baki, “Mwapwagila bandu beaba atama malundumalundu ga bandu makomi nhwanu.” ");
INSERT INTO mgv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Banafunzi baki batenda ngati ejaapwagila, na bandu boti batama pai. ");
INSERT INTO mgv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ndipala Yesu jajukua mabumunda unhwanu na homba ibeli yela, jalingalya kunani kwaka Sapanga kwaka Sapanga, nukuipengee. Ndienu janukula mabumunda nahomba, nakaapeke banafunzi baki baabagila bandu. ");
INSERT INTO mgv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bandu boha bakula, nukutupi. Na banafunzi baki batondwi makombu gagaigali itonga yeyatweli komi ni ibeli. ");
INSERT INTO mgv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lisoba limu Yesu jabiya kajika jaki andoba Sapanga. Banafunzi baki babi bunzendila pajubii, najombi jaalalukiya, “Boo bandu apwaga ne nanyane?” ");
INSERT INTO mgv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nabombi bapwaga, “Bandu bangi apwaga we wa Yohana Mmbatisa, bangi apwaga we wa Elia na bangi apwaga jumu kati ja Alota baka Sapanga ba mwandi jojuyokiki.” ");
INSERT INTO mgv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Najombi jalalukiya, “Mwanganya boo, mpwaga ne nanyane?” Petili japwaga, “Weapa ndi Kilisitu weguhumiki kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ndipala Yesu jaakanakiya mwampwagi mundu jokapi lijambu le hele. ");
INSERT INTO mgv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ahelahe Yesu jaapwagila, “Mwana waka Mundu jupalika kung'alika ngamaa nu kunkana aseja na agolu akolongu na abola ba Malagalaki. Jwiitenda kukomeka lakini jwiyoka mlisoba la tatu.” ");
INSERT INTO mgv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ndipala Yesu jaapwagila bandu boha, “Mundu jokapi najupai kunyengale ne, kupalika julikana na majambu gaki mweni nukujuku nsalaba waki, junyengaliya. ");
INSERT INTO mgv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mundu jokapi jojupala kugugombo womi waki mweni, jitenda kuguhoa, lakini mundu jojuhoa womi waki ndaba jami ne jaguokuwa womi waki wamasoba goha. ");
INSERT INTO mgv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Boo sanzangatiya kii mundu ana jupatiki kila sindu su punndema pane koni na julihoa mweni? ");
INSERT INTO mgv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mundu jojumonee nepani iyoni pamu na mabolee gangu, Mwana waka Mundu jaambonila iyoni mundu we hoju pajihika mu ulumbi waki nu ulumbi wa Ahengo nu ulumbi wa atumisi ba asapi bu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Numpwagi sakaka, abii bangi apamba ngabikuwi mbaka pabagubona Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Egapeta masoba nani tumbuka ejapwaga majambu ge gala, Yesu anzukua Petili na Yakobu na Yohana bakwela pikitombi kundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu pababiya jakaloba, bumbona jakang'anumbuka pamihu, ni ingobu yaki yabia iyuu kwejakweja. ");
INSERT INTO mgv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Apalapa bandu abeli babia alonge naku. Bandu be haba babia Musa na Elia, ");
INSERT INTO mgv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","babonikana abi muulumbi gukunani kwaka Sapanga kwaka Sapanga na bakalongila na Yesu lijambu la kuwa kwaki kokwipitila ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petili na ajaki babi agosi lugonu, na pabajumuka bugubona ulumbi waka Yesu, baabona na bandu abeli bajabi jujemiki nabu pamwa. ");
INSERT INTO mgv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa na Elia pababia bakaboka, Petili ampwagila Yesu, “Bambu, sapi twe kutama pambane. Tusenga indamba hitatu, simwa sako, simwa saka Musa na sengi saka Elia.” Lakini Petili ngasejamanyiki sejikipwaga. ");
INSERT INTO mgv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petili ejwabiya jakalongila, gapitila mahundi nakaayekale, na banafunzi bajogapa ngamaa liundi elaayekaliya. ");
INSERT INTO mgv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauti japita kuhuma mulihundi, “Jonzo ndi Mwanangu jonuwagwi, munzowaniya.” ");
INSERT INTO mgv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sauti ejatumbala, Yesu jabonikana jubii kajika jaki. Banafunzi batumbala kinunu na ngasebumpwagi mundu jokapi sindu sebikibweni masoba ge gala. ");
INSERT INTO mgv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Elwahika lukela Yesu na banafunzi baki atatu bahuluka kuhuma kukitombi, nu nsambi wa bandu jatenda kuketangana nabu. ");
INSERT INTO mgv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu jumwa mu nsambi we gola jajamalia kwa sauti, japwaga, “Mmbola! Nuguloba gundingaliya mwanango, ndaba jonioju mwanawa wakajika! ");
INSERT INTO mgv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kilombu kikuba kitenda kuntukali nukunhenga jujamalia, sunzege kihindu hindu, ni lihuluhulu lumpita kukanu nukuendale kunng'alisa na ngase sundekakeye kanyata! ");
INSERT INTO mgv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naalobalakiya banafunzi baku bikiboha kilombu, lakini ngasebawesike.” ");
INSERT INTO mgv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu japwaga, “Mmbanganya mwabandu bikibeleku sanga kuhobale na sekihobiki! Boo ndama na mwanganya nukunhinakali mbaka lile?” Ndipala ampwagila mundu we jola, “Gunndeta mwanawaku we pamba.” ");
INSERT INTO mgv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nkombu we jola ejwabiya anzende Yesu, kilombu se sela suhabua pai nukunzege kihindu hindu. Lakini Yesu jikilakaliya kilombu, nukundamisa nkombu we jola nukunkelabu kwa ahengo baki. ");
INSERT INTO mgv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bandu boka basangia ku uwesu nkolongu waka Sapanga. Bandu ebabiya bakona bakasangia majambu goha gajutei Yesu, jaapwajila banafunzi baki, ");
INSERT INTO mgv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nnzowaniya sapi malobi ganga gambala kumpwaji! Mwana waka Mundu jupalika kunkabisa mwamaboku ga bandu.” ");
INSERT INTO mgv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lakini banafunzi baki ngasebamanyiki ndaba lilobi heli, ndaba lijambu leheli babibia baahihiki kwabu ili biimanya, nabombi bajogipi kundaluki Yesu ndaba ja malobi haga. ");
INSERT INTO mgv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Banafunzi baka Yesu batumbuliya kubisana nya jojubii nkolongu kati jabu. ");
INSERT INTO mgv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lakini Yesu jamanyiki kuholale kwabu, ndipala anzukua mwana nsoku nukumbeka pambipi jaki, ");
INSERT INTO mgv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ndipala jaapwajila banafunzi baki, “Mundu jokapi joanzopa mwana nsoku ngati jonzo kulihina langu, junyopa nenga. Na mundu jokapi jojinyopa nepani, ahelahe anzopa jojundumiki nepani. Ndaba mundu jokapi jojubii nsoku kati jinu jibia nkolongu kupeta boti.” ");
INSERT INTO mgv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana jajangila kupwaga, “Bambu, tumbweni mundu jumu jakaapia ilombu kulihina lako natwe tunkana ndaba jombi nga jumu wito.” ");
INSERT INTO mgv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lakini Yesu ampwagila Yohana na banafunzi bangi, “Mwankana, ndaba mundu jokapi jwanga kupengana na mwanganya jubii pamu na twee.” ");
INSERT INTO mgv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Masoba gaka Yesu gukujukulika kujenda kunani kwa mahundi kwaka Sapanga pagaeliya, Yesu japala kujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jaatuma atumi bundonguliya na ajenda mwiijiji yuku Samalia ili bukuhandaliya kila sindu. ");
INSERT INTO mgv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakini bandu buku Samalia ngase bunzopike, ndaba bamanyiki jujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Banafunzi baki, aka Yakobu na Yohana ebagabona haga, bundalukiya Yesu, “Bambu, boo gupala tundoba Sapanga juhuluwa mwotu kuhuma kunani kwaka Sapanga gwatiniya tikitiki ngati ejatei Elia?” ");
INSERT INTO mgv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu jang'alumbukiya nakalakali. ");
INSERT INTO mgv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ndipala Yesu na banafunzi baki bajenda mwikijiji sengi. ");
INSERT INTO mgv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pababi mwiindela, mundu jumwa ampwagila Yesu, “Nagupwata kwokapi kola kowijenda.” ");
INSERT INTO mgv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu jaapwagila, “Mabwea gabi ni imbaku yabu ni ijuni ibi ni ihui yabu, lakini Mwana waka Mundu ngasejubi na pandu pukupomulela wala pukubeka kimutu saki.” ");
INSERT INTO mgv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu ampwagila mundu jongi, “Bwata.” Lakini mundu jola japwaga, “Bambu gunendaliya hoti muja ku nyumba nakaataga atati bango.” ");
INSERT INTO mgv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ampwagila, “Waaleka baawii haba baataga ajabu, ila we gujenda ukalandila bandu lijambu lu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mundu jongi kabee ampwagila, “Bambu nagujengaliya lakini lendaliya hoti nakaatabuka alongu bango.” ");
INSERT INTO mgv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ampwagila, “Mundu jokapi jojutumbuka kulema koni jakalinga munyuma ngasejuwesa kujangati sokapi mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ndipala Yesu jasagula banafunzi bangi makomi saba na abele nakaatuma abeliabeli, bundonguliya kila mwikijiji na kila pandu pajapala kujenda. ");
INSERT INTO mgv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesu jaapwagila, “Ilebi yukuhusa ibii hingipi, lakini bandu bukuhuna asokopi. Ndienu, munndoba jwini lituhi jaatuma bandu bukuhusa mulitui laki. ");
INSERT INTO mgv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Henu nnzendaniya, nuntuma mwanganya ngati matoli gi likondoo pikilanda jiimei. ");
INSERT INTO mgv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mwijuku lupija wala mpuku, wala mitamaduni, wala mwandamuki jokapi mwindela. ");
INSERT INTO mgv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nyumba jokapi jemwakajingala, mwakatumbulya kwaalamu ana, ‘Lukwali lubia mu nyumba jenze!’ ");
INSERT INTO mgv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Najubi mundu jojupala lukwali, lukwali lwinu lwibia naku mundu hoju lakini ana ngase jubii mundu jojupala lukwali, lukwali lwinu lwitenda kunkelabuki. ");
INSERT INTO mgv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ntama mu nyumba heji, mwakakula nakunywa kila sebampekia, ndaba jojuhenga lihengo jupalika kulepwa malepu gaki. Ntama mu nyumba jenhiki mwiboka kujenda nyumba jengi. ");
INSERT INTO mgv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Musi gokapi gomwakajingala na bandu na bunzopiki mwakakula sindu sokapi sebukumpekia, ");
INSERT INTO mgv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mwaalamisa agonzu babi pala, na mwakaapwagila bandu, ‘Ukolongu waka Sapanga guhegali kwinu.’ ");
INSERT INTO mgv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lakini nanzingi mmusi gokapi na bandu akaniki kunzopa, mwakapita, mkapetannya mwindela yabu koni mwakapwaga, ");
INSERT INTO mgv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata luombi lwa musi winu gagakamulini mwamagolu gitu, tugakung'unda ndaba jinu kulangi ntei liyaha. Lakini mmanya ukolongu waka Sapanga gunhegali.’ ");
INSERT INTO mgv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Numpwaji sakaka mlisoba lu kutemu kwaka Sapanga bandu ba musi uku Sodoma awesa kuhinakali kutemuliwa na Sapanga kuliku bandu ba musiwe hogu! ");
INSERT INTO mgv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Misi mwikiboni mwa bandu muku Kolazini! Msimwikiboni mwabandu buku Betisaida! Ndaba ana ndondukela yeyahengika pala gakahengiki ku Tilo nuku Sidoni, bandu baapala bakawata magunila nukupaki malihu ili kulangi alekaki mahakau gabu. ");
INSERT INTO mgv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mlisoba luku kutemu, bandu ba misi juku Tilo nuku Sidoni biiwesa kunhinakali kutemuliwa na Sapanga kupeta mwanganya. ");
INSERT INTO mgv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na mwabandu buku Kapelinaumu! Boo bantondabiya mbaka kunani kwaka Sapanga? Ngahela! Bandekala mbaka koajenda bandu baawile!” ");
INSERT INTO mgv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu jaapwaga banafunzi baki, “Mundu jokapi jojunzoane mwanganya, junyoane nepani, na mundu jokapi jojunkana mwanganya, jungana nenga. Na mundu jokapi jojungana nenga, ankana jojundumiki nenga!” ");
INSERT INTO mgv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mwoni katai bandu makomi saba na abeli bakelubuka bakatoguliya ngamaa, bakapwaga, “Bambo, kuliina laku twabenga ilombu nayombi nukutujetake.” ");
INSERT INTO mgv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu jaapwajila, “Nilibweni lijobi lakahabuka ngati unang'anu ukitobi kuhuma kunani kwaka Sapanga kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nzoaninya! Numpeki ukolongu, ndienu nhwesa kutimba lijoka ni kipelela, na mwagawesa makili goa gili Lijobi na nga gutendi sindo. ");
INSERT INTO mgv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lakini, mwitogule ndaba ilombu yuntei kunzetakela, ila ntoguliya ndaba mahina gi gahandikwi kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kipindi aselasela, Yesu jatoguliya ngamaa ku uwesu wa Loho jaka Sapanga, japwaaga, “Atati, Bambu jukunani kwaka Sapanga nu kundema, nukusengu ndaba majambu ganga gwaahihiki babi na malangu na asomi, nawe waalangi bana asoku! Atati, hela ndi ekugulengani.” ");
INSERT INTO mgv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ahelahela Yesu jaendaliya kupwaaga, “Atati bangu ambeki hindu yoka. Nga joammanyiki mwana ila Atati, wala joamanyiki Atati ila mwana, na boka Mwana bajwahagwi kwaayekuli kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ndienu Yesu jang'alumbukiya banafunzi baki kajika jabu nakapwagi, “Apengaliwi babagabona gamwagabona mwanganya! ");
INSERT INTO mgv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Numpwagi sakaka, alota baka Sapanga bingi na aka bambu akolongu batokuliya bagabona gamwagabona mwanganya, lakini ngasebagabwene, nukujoane sela senzoane, lakini ngasebawesiki kujoane.” ");
INSERT INTO mgv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mbola wa Malagalaki jajema kundenga Yesu, nukundaluki “Mbola, ndenda kike anambai mbata womi wa masoba goa?” ");
INSERT INTO mgv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu andalukiya, “Boo, aandiki kike mmalagalaki gaka Musa? Guelewa bole?” ");
INSERT INTO mgv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mundu jola japwaaga, “Gumpala Bambu Sapanga waku kwa mwoju waku woti, kwa loho jaku joti, na kwa makili gaku goti, kwa malangu gaku goti, na gumpala nnzaku ngati eulipala wamwete.” ");
INSERT INTO mgv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ampwagila, “Gupwagiki sapi. Tenda ahelahela nawe gwibia na womi wa masoba goa.” ");
INSERT INTO mgv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lakini mundu we jola koni jupala jubonikana jombi wamboni, andalukiya Yesu, “Boo nnzangu wee ndi nyanye?” ");
INSERT INTO mgv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ampwagila, “Jabii mundu jumu jabia juhele kuhuma ku Yelusalemu kujenda ku Yeliko. Pajabiya mwiindela buntukalya manzolinzoli, bunnyaga hindu yaki nukundapu, bundeka jugoni pala juhegale kuwa. ");
INSERT INTO mgv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Monikatai japeta nngolu nkolongu jumu juhelee piindela jela, lakini eambona mundu joandapwi we jola japeta kulutengu. ");
INSERT INTO mgv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ahelahe Mlawi jumu ejahika pala ammbona mundu jola najombi japeta kulutengu. ");
INSERT INTO mgv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lakini mundu jumu juku Samalia jojwabia jujenda sapwali jaki. Eambona, ammbonila ikia. ");
INSERT INTO mgv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Anzendila, ampakia mahuta na divai nukukonga ilonda yaki sapi, nukunkwea mliponda laki, ampelika mu nyumba ja ageni nukunnwaa. ");
INSERT INTO mgv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kilabu jaki Msamalia jola japia lupija dinali ibele nukumpeke mwana nyumba, nukumpwagi, ‘Muntunza mundu jonzo, paniikelubuka nakulepa sokapi sewijonzukya kutumi.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ndipala Yesu jalalukya, “Gubona boo kati ja atatu be haba, nya jojabonakini nzake jake mundu jobuntukali manzolinzoli?” ");
INSERT INTO mgv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mbola wa Malagalaki jola ampwagila, “Joambonila hikia.” Yesu ampwagila, “Nawe gujenda kahenga ahelahela.” ");
INSERT INTO mgv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na banafunzi baki pababiya ajenda sapwali, bajingala mwikijiji simwa. Mmbomba jumu joakema Maluta anzopa Yesu mu nyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maluta jwabi numbeli waki joakema Malia, jojuweni jatemi pambipi na Yesu, na jabia jakajowannya mabole gaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lakini Maluta jwabiya juhenga mahengu gingi. Ndipala, anzendila Yesu nukundaluki, “Bambu, ngasegumona le nnuhuna wangu hoju juneki mahengu goti henga kajika jango? Gumpwagila junyangatyaje.” ");
INSERT INTO mgv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lakini Bambu ampwagila, “We Maluta, mbona guhangajika kwa majambu gingi, ");
INSERT INTO mgv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lakini sindu simu pe sekipalika. Na Malia juhagwi sindu sa sapi, wala ngamundu jukunnyagaje.” ");
INSERT INTO mgv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lisoba limu, Yesu jabi pandu akundoba Sapanga. Ejajomula kuloba, mbolee waki jumu apwagila, “Bambo, tuloba utubola kundoba Sapanga ngati Yohana Mmbatisa ejwaabolaa banafunzi baki.” ");
INSERT INTO mgv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu jaapwagila, “Pamundoba Sapanga mpwaaga ana, ‘Atati bitu! Lihina laku la Sapi lilumbilika, Ukolongu waku guhika. ");
INSERT INTO mgv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gutupekiya posu jitu ja kila lisoba. ");
INSERT INTO mgv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gutulekakiya mahakau gitu, ngati twenga etwalekake bandu boti babutuhengi liyaha. Wala watubeka mwimilengu.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ndienu Yesu jaapwagila banafunzi baki, “Tupwaga kati ji jumu jubi nukosi waki, jwajenda kunyumba jaki pamahiku nukumpwagi, ‘Nkosi wango, nanoba gumbeke mabumunda matatu, ");
INSERT INTO mgv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ndaba nkosi waa jojubii kusapwali juhikiki kunyumba jango, nane ngase mina posu.’ ");
INSERT INTO mgv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Najombi koni jubi nkati jakapwaga, ‘Gwinzumbua nepani! Nepani mbungiki nndiyangu, nepani na bana bangu tugoni. Nganhwesi kujumuka kukupeke sokapi.’ ");
INSERT INTO mgv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Numpwagi sakaka, hata ana mundu hoju ngajwiijumuki kumpeke posu nkosi waki ndaba nkosi waki lakini ndaba ngasejubona iyoni kuendalee kuloba, ndienu mwoni katai jwiijumuka nukumpeke sokapi sela sejupala.” ");
INSERT INTO mgv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ndienu numpwagila, nndoba nanamu biitenda kupekea, ntaputa nanamu mwiitenda kupata, nhotima nanamu biitenda kunhogule nndyango. ");
INSERT INTO mgv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ndaba mundu jokapi jojuloba jwiitenda kujopa, na mundu jokapi jojutaputa jwiitenda kujupata, na mundu jokapi jojuhotima biitenda kunhogule nndiyango. ");
INSERT INTO mgv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Atati boo kati jinu mwana waki ana anndobiki homba ampekia lijoka? ");
INSERT INTO mgv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au najulobiki lihombi, apekia lee kipeleli? ");
INSERT INTO mgv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ana mwanganya, mombi na mahakau mmanyiki kwaapeke bana bi hindu ya sapi, boo atati binu bu kunani, nga lee baapekee Loho jaki bandu babundoba!” ");
INSERT INTO mgv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lisoba limwa Yesu jwabiya jupia kilombu kuhuma kwaka mundu sesuhengika mundu we hoju jubia kimumuta. Ni kilombu esumpita mundu we jola jatumbuliya kulonge, bandu basangii ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakini bandu bangi bapwaga, “Haba, abenga ilombu kwa makili gaka Belizebuli, nkolongu wii hilombu.” ");
INSERT INTO mgv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bandu bangi bapala kundenga Yesu, bapala julangila nginyuli kuhuma kunani kwaka Sapanga yeilangi Sapanga antei kuntuma. ");
INSERT INTO mgv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lakini Yesu jamanyiki kuholale kwabu, ndienu jaapwajila, “Ukolongu wokapi gogubaganiki makundimakundi nukukomana ngasegutama, lukolu lolubaganika lweni kwa lweni lwitenda kuwa. ");
INSERT INTO mgv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ana Lijobi gogubaganiki nukulipenga lyeni, ukolongu waki gwijema bole? Mbwaga hela ndaba mwanganya mpwaga ne menga ilombu kwa makili gaka Belizebuli. ");
INSERT INTO mgv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ana ne mbia ilombu kwamakili gaka Belizebuli, boo bandu bii apia ilombu kwa makili gaka nyanye? Ana hela bandu binu mwabe biitenda kuntemu! ");
INSERT INTO mgv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lakini ana mbia ilombu kuuwesu waka Sapanga, nala mmanya ukolongu waka Sapanga guhikiki kwiinu. ");
INSERT INTO mgv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu jwana makili pajulonda nyumba jaki kwa hindu yukukomane ngondu, hindu yaki ngakuwesa kunyagika. ");
INSERT INTO mgv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakini ana juhikiki mundu jongi jwanamakili kupeta jombi, jwiitenda kunndapu nukuwesa, jwiinyaga hindu yaki yukukomane ngondu yejuihobale yela nukubaga hindu yebunnyagiki. ");
INSERT INTO mgv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundu jokapi jwanga kuba upandi wangu hoju jundenda kumbenga, na mundu jokapi jwanga kubonga pamu nanepani jutenda kupesangana. ");
INSERT INTO mgv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kilombu esumpita mundu, kijendajenda pandu panga na masi kitaputa pandu pukupomule. Ana ngasekipatiki pandu pukupomule salipwagila, ‘Niikelubuka mu nyumba jangu monapita.’ ");
INSERT INTO mgv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Henu ekikelabuka nukuketane nyumba apyagi sapi nukubeka kilasindu sapi. ");
INSERT INTO mgv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ndienu kijenda kujuku hilombu yengi saba yeibi na makili kuliku sombi. Nayoti hijenda nukunzingi mundu we jola. Henu hali jaka mundu we jikuba jiliha kuliku pajatumbuka.” ");
INSERT INTO mgv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu pajwabia jupwaga majambu haga, mmbomba jumwa kuhumaa munsambi we gola japwaga Yesu, “Mbanga mmbomba jojugubeliki nukukujoha!” ");
INSERT INTO mgv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lakini Yesu japwaga, “Lakini mbanga ngani bandu babilijone lilobi laka Sapanga nukulijetake.” ");
INSERT INTO mgv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nsambi wa bandu egwabiya guendale kujonzukeka, Yesu jaendaliya kwaapwagi, “Kibeleku senze sa bandu banamahakau kipala nginyuli. Ngakipati nginyuli jokapi ila nginyuli jaka Yona jela. ");
INSERT INTO mgv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngati Yona ejabi nginyuli kwa bandu buku Ninawi, ndi Mwana waka Mundu ejibiya nginyuli kwa bandu bikibeleku senze. ");
INSERT INTO mgv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lisoba lu kutemu, Malikia juku Sheba jihika nukupwa bandu bikibeleku senze abii na mahakau, ndaba jombi ja huma kundema jaki nukuhika kujowane mabole gana malangu gaka Bambu Nkolongu Solomoni, lakini pamba jubii mundu nkolongu kupeta Selemani. ");
INSERT INTO mgv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mulisoba lu kutemu bandu, bandu buku Ninawi bijema nukupwaga bandu bikibeleku senze abii na mahakau, ndaba bombi balekakiya mahakau gabu hebajogwana pee malandi gaka Yona. ");
INSERT INTO mgv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nga mundu jojupambaki taa nu kujiyekale au kuiya nikitonga, lakini jujibeka pikipanda ili bandu baajingi nkati bugubona unang'anu. ");
INSERT INTO mgv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liu laku ndi taa ja nhyega jaku. Ana liu laku libii sapi, nhyega jaku joha jikuba na unang'anu. Lakini ana liu laku libii lyaa, nhyega jaku joka jitwelila lwii. ");
INSERT INTO mgv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Henu ulilenda, unang'anu gogubii nhyega jaku ili gwiikuba na lwii. ");
INSERT INTO mgv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndienu, nhyega jaku joka najitweli unang'anu, ana ngakuba pandu pokapi papabii na lwii nhyega joka jiitenda kunang'ana ngati taa ejinang'ana na unang'anu waki.” ");
INSERT INTO mgv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu ejajomula kulongela, Mfalisayu jumwa ankoka Yesu kula posu ku nyumba jaki. Ndienu Yesu jajingala nkati jatama nakula posu. ");
INSERT INTO mgv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisayu jola jasangii kumbona Yesu jukula posu bila kusamba maboku. ");
INSERT INTO mgv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ndi Bambu jaapwagila, “Mmbanganya mwaka, Afalisayu nngolo nnzipuli na sahani kunza, lakini nkati ja mioju jino jitweli ndokule ja wii nu ubaya. ");
INSERT INTO mgv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mmbanganya ngasembi na malango! Boo Sapanga jojundenganaki kunza ngalee ndi jojundenganaki nuukate? ");
INSERT INTO mgv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Henu mwapekia ahagu hindu yeibii nkati ja mioju jii na kila sindu kwinu kiibia sapi palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Lakini musi mukiboni mwaka Mafalisayu! Ndaba mwaajopa bandu zaka hata manyoi gaganungi nunsisa nakila aina jilikolu, lakini ngasempala kwaatende bandu majambu ga sapi palongi jaka Sapanga na nkotoka kumpala Sapanga. Kutaki kuba hoti mwabandu baamboni bila kugaleka gangiaga. ");
INSERT INTO mgv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Musimukiboni mwaka Afalisayu! Ndaba mpala kutama hiteu yeibii palongi munyumba jukuketangane Ayaudi, nukundamu kwi hisima kugulihu. ");
INSERT INTO mgv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Musimukiboni! Ndaba mmbi ngati matenge gagilihihiki, na bandu apeta panani bila mwabeti kumanya.” ");
INSERT INTO mgv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mmbola jumu jwa Malagalaki ampwagila, “Mbola, egulonge hela gututondo kabee natwenga!” ");
INSERT INTO mgv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu jaapwagila, “Musimukiboni na mwanganya mwabola bamalagalaki! Ndaba mwatweka bandu misigu jejitopiki janga kutotoleka, koni mwabee ngasennyosa hata maboku gino kwajangati. ");
INSERT INTO mgv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Musimukiboni, ndaba mwasenge matenge alota baka Sapanga babakomika na aseja bino. ");
INSERT INTO mgv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mwanganya mwabee mwagabweni nuku jezetake goha gabahenga aka aseja binu ndaba bombi baakoma alota baka Sapanga, nananu nsengale matenge gabu. ");
INSERT INTO mgv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Henu malobi gasapi gaka Sapanga gapwaga ana, ‘Naatuma alota baka Sapanga na atumisi, lakini bangi biitenda kaakoma na bangi kwaang'alisa.’ ");
INSERT INTO mgv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Henu bandu bikiibeleku senze sipata azabu ndaba jakakoma alota baka Sapanga boka tangu kutumbuka nndema, ");
INSERT INTO mgv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tumbuka kukomeka kwaka Abeli mbaka kukomeka kwaka Zakalia, jobukoma pikilanda ja mesa jukupiiki litambiku na pandu pa sapi. Sakaka numpwaji kibeleku senze bitenda kukitemu kwa majambu goti haga. ");
INSERT INTO mgv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Musimukiboni mwaabola bamalagalaki mbanganya! Ndaba nhihiki upunguu gukuelewa. Mwabe ngasennzingi na mwaapengali bandu baapala kujingi!” ");
INSERT INTO mgv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu ejaboka pala, Mafalisayu na abola ba Malagalaki batumbuliya kumpenga sukundaluki maswali gingi, ");
INSERT INTO mgv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ili bunkamula kwa sindu sokapi sejiilongila. ");
INSERT INTO mgv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kipindi bandu bingi aketangini pamu mbaka kukanyatana. Yesu jatumbulya kulonge na banafunzi baki, “Nzepana amila jaka Afalisayu, bandu babilikopake baamboni. ");
INSERT INTO mgv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sindu sokapi sebikiyekali kiitenda kuyekuliwa, nasokapi sebikihihiki sitenda kuyekuliwa. ");
INSERT INTO mgv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ndienu, kila sealongi palwii sijowanika pu unang'anu, na sokapi sebalongila nkati koni nndyangu apungiki, siilandiwa pagwendu kunani ju nhaga. ");
INSERT INTO mgv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Numpwagi mmbanganya mwakosi bangu, mwaajogopa bandu baakoma nhyega pena lakini ngaseawesa kuhenga sindu sengi siliya ngani. ");
INSERT INTO mgv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lakini mitinundangia jukunzogopa. Munzogupa jola ana junkomiki mundu, juwesa kundeke mundu wehoju mu mwotu wa masoba goha. Numpwagi, hoju ndi munnzogupa. ");
INSERT INTO mgv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Boo iweba nhwanu ngase alombesa kwi lingengalema pena? Lakini nga kiweba hata simu sejukijegwa Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lakini hata majunzu gukumutu jinu atei kugabalanga goka. Mwijogopa, ndaba mwanganya mpalika ngani na Sapanga kupeta iweba. ");
INSERT INTO mgv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Numpwagi sakaka, mundu jokapi jojunyetake nepani pa bandu, Mwana waka Mundu najombi anzetakiya palongi ja atumi bu kunani baka Sapanga kupwaga mundu hoju waki. ");
INSERT INTO mgv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lakini mundu jokapi jojungana palongi ja bandu, najombi Mwana waka Mundu ankana palongi ja atumi bu kunani baka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mundu jokapi jojwiipwaga lilobi luku mpenga Mwana waka Mundu, jwitenda kulekakewa mahakahu haga, lakini joantondo Loho jaka Sapanga ngajulekakewi. ");
INSERT INTO mgv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pabampelika mwanganya palongi ja nyumba jukuketangane Ayaudi na palongi ja akolongu na palongi ja aka kilongosi, mwijogopa namna jukulilonge. ");
INSERT INTO mgv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ndaba Loho jaka Sapanga jwammbola sukulonge kipindi semwipala kulonge.” ");
INSERT INTO mgv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu jumwa jojwabi mu nsambi wa bandu apwagila Yesu, “Mbola, mpwagila nndongu wangu tubagana hindu yebutuleki atate bito.” ");
INSERT INTO mgv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu jaapwagila, “Nkose wango, nya jojumei nepani mia namundu jukuamuli au kubaganisa hindu hii?” ");
INSERT INTO mgv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndi Yesu jaapwajila boti, “Nnzepana na majambu gukupala mali gingi! Ndaba womi waka mundu ngaseguhobale mu hindu yejubi nako.” ");
INSERT INTO mgv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ndipala Yesu jaapwagila lilengano lende, “Jwabi mundu jumwa jojabi na mali gingi jabii ni litui laki lelabii niilebi hingi. ");
INSERT INTO mgv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Henu jawasaliya mmwoju jaki, ‘Boo ndenda bole nane ngase mii na pandu pukubeka ilebi yango?’ ");
INSERT INTO mgv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Japwaga, ‘Nitenda ana, niibombula hikoku yaa nukusenga yengi hikolongu ngani. Niibeka momu ilebi yaa yoka na hindu yango.’ ");
INSERT INTO mgv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndienu najipwagila namweti, ‘Wamwoju wango! Gubi na mali gingi yukutumii yaka ingi. Pomuliya, gukula na gukunywa na gutogulya!’ ");
INSERT INTO mgv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ndipala Sapanga ampwagila jwana mali gingi jola, ‘Weapa gung'ang'a! Ikilu ja lelenu womi waku musigutenda kujukulika. Boo hindu yehei yeulibeki hibiya yakanyanye?’ ” ");
INSERT INTO mgv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu jajomuliya sukupwaga, “Ndi mokwibelila mundu jojijibeke hindu yaki ndaba jaki mweni, lakini palongi jaka Sapanga ngase jubonikana jubii na sindo.” ");
INSERT INTO mgv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ndipala Yesu jaapwajila banafunzi baki, “Ndienu numpwaji mwiing'alika kupete posu ndaba ja womi wii, wala ingobu yemwipala kuwata mu nhyega jino. ");
INSERT INTO mgv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndaba womi winu mbanga nakanopi kupeta posu, na nhyega yinu mbanga nakanopi kupeta ingobu. ");
INSERT INTO mgv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mwiilinga ijuni yumukiholi yombi ngase ipanda wala kuhusa, wala ngaseibii nikikoku sokapi wala pandu pokapi pukubeka posu, lakini Sapanga jwiilea! Mmbanganya mpalika na Sapanga ngani kupeta ijune! ");
INSERT INTO mgv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Boo, nya kati jinu kukujihangajisa ngani, jojuwesa kujonzuke hata lisaa limu lukutama punndema? ");
INSERT INTO mgv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ana ngasenhwesa kuhenga lijambu lisoku ngati heli, ndaba ja kii muisumbuki hindu yenge? ");
INSERT INTO mgv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nndinga maua mogakole, ngasegaenga lihengu lokapi wala kulipumi ingobu. Lakini numpwagi, hata Nkolongu Solomoni pamwa na mali gingi yejabinaku katika womi waki ngasejawahiki kuwata ingobu ya sapi ngati mauwa gagalengani ngati ganga. ");
INSERT INTO mgv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ana Sapanga jiliwatika linyonyoli lukulitui lelibii lelenu nikilabu bilileke mu mwotu, boo, nga janhwatiki lee ngani mmbanganya mwenhobale kidogu? ");
INSERT INTO mgv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Henu mwiihangajaki sindu sakula wala sindu sakunywa. Mwiiholale ganiaga. ");
INSERT INTO mgv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ndaba bandu banga kummanya Sapanga asumbuki ngamaa hindu ngati hei. Atati bii bukukunani amanyiki hindu ye mpala. ");
INSERT INTO mgv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lakini ntaputa oti Ukolongu waka Sapanga na hindu yengi biitenda kumpeke. ");
INSERT INTO mgv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mwijogopa mwembii mukilundu kisokopi, ndaba Atati bii bu kunani apai kumpeke Ukolongu. ");
INSERT INTO mgv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nndombisa hindu hii, mwakaapekia bandu banga nuwesu lupija. Mwililenganakya mipuku jangakulala, nukulibeke mali gingi kunani kwaka Sapanga, kokuje mali gingi ye ngase ipungua. Kokuje nga bii, bukujiba wala nkeki goguwesa kuhalabana. ");
INSERT INTO mgv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ndaba paibii hindu yaku hingi, ndi pagubii mwoju waku. ");
INSERT INTO mgv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mbia muliandii sapi ndaba ji lihengu, na taa hinu hibiya itenda kunyaka, ");
INSERT INTO mgv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mmbia ngati hatumisi babundendale nkolongu wabu ejukelubuka kuhuma kutipati ja ndoa. Ejukelabuka nukuhotima nyatanyata antenda kunhogule. ");
INSERT INTO mgv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Apengaliwi hatumisi bala nkolongu wabu pajiikelubuka jaaketaniya atemi mihu! Numpwaji sakaka, nkolongu hoju jaalikonga luhunga mwikibunu, jaapwagila atamapai nakaatumaki. ");
INSERT INTO mgv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Apengaliwi atumisi bala nkolongu wabu ejihika hata pamahiku, jaaketaniya abii mihu! ");
INSERT INTO mgv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lakini mmanya ana, ana mwananyumba ejakamanyiki muda mwii pajiihika, jwakatama mihu. Wala ngajikijilei nyumba jaki mwii jubombula nukujiba hindu. ");
INSERT INTO mgv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nanamu, ahelahe kupalika mliandia, ndaba Mwana waka Mundu jiihika muda wanga kugumanya.” ");
INSERT INTO mgv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petili andalukia, “Bambo lilenganu alee gutupwaji twepani kajika pena au bandu boka?” ");
INSERT INTO mgv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bambu japwaga, “Nya, jojubi ntumisi jojuhobaleka na jwanamalangu? Nkolongu waki ana ambei kwaajemale baahenga lihengu bangi nakaapeke posu kipindi sekipalika. ");
INSERT INTO mgv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jupengaliwi ntumisi jola nkolongu waki pajibuja aketaniya jakahenga hela. ");
INSERT INTO mgv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Numpwagi sakaka, nkolongu hoju ambeka mundu jola jujemalya hindu yoka. ");
INSERT INTO mgv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakini ana ntumisi hoju julipwaji mweni mmwoju jaki, ‘Bambu wango juselewa kukelabuka.’ Ndipala nukutumbuka kwaalapu hatumisi hajaki akanalomi nakaambomba, najombi nukukula na kunywa nukulobe, ");
INSERT INTO mgv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bambu waki hejiipala kuhika, jiika lisoba langa kuobale na muda wanga kugumanya. Na bambu jola ansekulana hipandi ibeli nukummbeka lipungu limu na hatumisi banga kuhobaleka. ");
INSERT INTO mgv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ntumisi jojumanyiki sapi sejupai nkolongu waki, lakini ngasejijibeka tayali kuhenga gagatakiwa, ntumi hoju bundapula ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lakini ntumisi jola jojuhenga majambu gagapalika azabu bila kumanya banndapula pasoku. Jobumpekii hingipi banndaja hingi, jobupekii hingi ngamaa banndaja hingi ngani. ");
INSERT INTO mgv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nikiki kupambaki mwotu pundema, ndokule mbakasajenu gwakabia gunyakiki! ");
INSERT INTO mgv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mii nuubatisu gukung'alika gombalika kugupata, nane ng'alika ngamaa mbaka ngamilisa kung'alika kwe hoku! ");
INSERT INTO mgv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Boo nhwasali nkiki kuleta lukwali pee pundema pane? Ngaela! Ngasenhikiki kwaahenga bandu baatama kulukwali ila kwaabaganisa. ");
INSERT INTO mgv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Toka sajeno bandu nhwano baabii nnyumba jimu biitenda kukomana, bandu atatu biilosana na abeli na abeli bilosana na atatu. ");
INSERT INTO mgv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ahengo biilosana na mwana, na mwana jilosana na ahengo baki. Anyongo biilosana na mwana waki, mwana waki jiilosana na amabu baki. Aniala baki biilosana na mwinikimwana waki na mwinikimwana waki jiilosana na anialabaki.” ");
INSERT INTO mgv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu jaapwajila bandu, “Emmbona mahundi gakapitila kolijingi lyoba, mpwaga, ‘Iyula jiitenda kukuna’ Na sakaka iyula jikuna. ");
INSERT INTO mgv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pammbona unhwahi guhuma upandi ukusine mpwaaga, ‘Kuibiya na jotu’ Na ahelahe kutenda kuba. ");
INSERT INTO mgv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mmbanganya mwemlikopake mwaamboni! Nhwesa kulingali lihundi nu unhwahi nukulote iyula jitenda kukuna pani pundema au lyoba litenda kunyaka. Boo ngasemmanyi lee kumanya majambu gaheno? ");
INSERT INTO mgv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ndaba ja kii mwa bee ngasenhwesa kumanya majambu boo gaamboni gukuhenga? ");
INSERT INTO mgv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na mundu jo jugutaki pasengu, nambanga gupatana naku koni mwakona mwindela, ana nga hela jojutemu magambu jagupelika kwaka mlonda wa bandu najombi jagupelika kukipungu. ");
INSERT INTO mgv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nugupwaji, ngawipiti momu mbaka egwilepa lingengalema la mwisu.” ");
INSERT INTO mgv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kipindi sehesi, babi bandu babumpwagila Yesu majambu ga bandu benei buku Galilaya bajwaakoma Pilatu na mwai wa bandu behaba jwahangangana na matambiku gabu giinyama gababia bakapia. ");
INSERT INTO mgv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu jaapwagila, “Boo mwanganya nhwasali lee benei buku Galilaya babawii ngati hela babi lee na mahakau gingi kupeta Agalilaya bangi bote? ");
INSERT INTO mgv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngahela! Numpwagi sakaka ana nanamu ngamugaleki mahakau ginu, nanamu mwihoba ngati ebahoba bombi. ");
INSERT INTO mgv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au bandu komi na nane bala bagwaahabuki nnala ku Soloamu kola? Boo nhwasali lee bandu be bala babii na mahakau kupeta bandu bangi boti baatamika ku Yelusalemu? ");
INSERT INTO mgv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngahela! Numpwagi sakaka mwanganya ana ngakulekake mahakau, mwihoba ngati ebahoba bombi.” ");
INSERT INTO mgv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ndipala Yesu jaapwagila kwa malenganu ganga, “Mundu jumu jabi nunkongu wa matunda mulitui waki. Mundu we hoju jajenda kutongo matunda munkongu gola, lakini ngasegwabii nilitunda lokapi. ");
INSERT INTO mgv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndienu ampwagila jojutunza litui lela, ‘Lingalya, hikika kutongo matunda munkongu gongo yaka itatu, sanga kupata sokapi. Sekula nkongu wehogu! Ndaba jaki guendale kutumi ndema bwaka?’ ");
INSERT INTO mgv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lakini jojutunza litui jola japwaaga, ‘Bambo, guleka hoti mwaka gumu nepani niitenda kugukulagali nukugujegale mbolea. ");
INSERT INTO mgv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ana gupapiki matunda pamwaka, kwibia sapi, lakini anangasegupapiki, wagusekula.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lisoba limu Yesu jabia jaabola bandu mu nyumba jukuketangane Ayaudi Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Papuje jabii mmbomba jumu jojabii nikilombu sesundwalisa miaka komi na nane. Nngongu waki wabii gupendiki ngasejwabia juwesa kulinyosa. ");
INSERT INTO mgv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu paambona, ankema nuku mpwagi, “Nyongo gulamisiki ugonzu waku!” ");
INSERT INTO mgv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ndienu Yesu ambekila maboku gaki nyongo we jola nukundobe kwaka Sapanga, apalapa nngongu watenda kunyoka nuku tumbuli kundumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lakini kilongosi jwa nyumba jukuketangane Ayaudi jatenda kuyoma ndaba Yesu andamisa nyongo we hoju Lisoba lu Kupomulela, henu jaapwajila bandu ba baketangini pala, “Mbii na masoba sita gukuhenga lihengu. Nhika masoba ge haga mwilamiswa magonzu gii, lakini mwihika Lisoba lu Kupomulela ili kulamiswa.” ");
INSERT INTO mgv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ndipala Bambu anzibua, “Mwee mwabandu babilikopake baambone! Nyaa kati ji ngase jubopulee ng'ombi jaki au liponda laki kuuma mwikisisi nukupeleka kunywa masi, hata na lakabi Lisoba lu Kupomulela? ");
INSERT INTO mgv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Henu pamba jubii mbomba jo juhuma mulukolu lwaka Ibulahimu, joluntukali lijobi kwa miaka komi na nane. Boo, ngase kwabii lee sapi kunhogule Mlisoba lu Kupomulela?” ");
INSERT INTO mgv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu pajajomula kupwaga haga, bandu babumpenga bilijogwanya iyoni, lakini bandu bangi boti batenda kutogule ndaba ja majambu gu kusangasa goti gajwahengiki Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ndienu Yesu jalalukiya, “Boo Ukolongu waka Sapanga uwanangini na kike? Boo nu gulenganisa nakii? ");
INSERT INTO mgv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uwanangana ngati imbeju nzoku ja haladali jejajukua mundu jumu nukujenda kupanda mu lituhi laki. Imbeji jela jamela nakuba nkongu nkolongu, ijuni yukunani yasenga inhui yabu mu mambandi gaki.” ");
INSERT INTO mgv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu jaalalukiya kabee, “Boo, Ukolongu waka Sapanga gubii boo? Nagulenganisa na kike? ");
INSERT INTO mgv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Guwanangini ngati amila jejajukwi nyongo jumu nukuangangana pamu nu uwembi ukutelake mabumunda madebi mabeli nu uwembi gola woka watenda kututumuka.” ");
INSERT INTO mgv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu jaendaliya na sapwali jaki kujenda ku Yelusalemu. Pajabii mwindela, japetila mmusi na mwijiji koni jaka abola bandu majambu ga sapi gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu jumwa andalukiya Yesu, “Bambo, boo, bandu babiilama biibia asokopi pena?” Yesu jajibua, ");
INSERT INTO mgv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkasana kujingi nkati su kupete nndiyangu mpepandau, ndaba bingi biipala kujingi kunani kwaka Sapanga lakini ngabiwesi. ");
INSERT INTO mgv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwananyumba jwiijema nu kupunga nndiyangu. Mwanganya mwijema kunza nu kutumbuli kuhotima pundyangu mwakapwaga, ‘Bambo, utuhoguliyaje.’ Lakini jombi jaajibua, ‘Ngasenummanyike konhumila!’ ");
INSERT INTO mgv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nanamu mwitumbuka kupwaga, ‘Twepani ndi twetwakula na kunywa pamu nawe, kabee wabola mmusi witu!’ ");
INSERT INTO mgv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lakini jombi jwiipwaga kabee, ‘Nee ngase nukumanyi konhuma. Mmbokaniya mwa boti montenda mahakau!’ ");
INSERT INTO mgv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ndienu mwilela nukupola minu, kipindi pamwambona Ibulahimu na Isaka na Yakobu na alota baka Sanga boti abii mu Ukolongu waka Sapanga, lakini mwanganya bandekala kunza! ");
INSERT INTO mgv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bandu bihika kuhuma kuupandi golipita lyoba na kolijingi lyoba, nukuhuma upandi wa pai nu upandi ukunani, biitama kula posu mu Ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndienu bandu bababii ba mwisu bikuba buutumbuli, na bandu bababibumbuli bikuba bamwisu.” ");
INSERT INTO mgv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kipindi aselase Afalisayu bangi bunzendila Yesu nukumpwagi, “Guboka pamba gujenda pandu pangi, ndaba Helodi jupala kugukoma.” ");
INSERT INTO mgv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu jaajibua, “Nzendannya mkilipwagila libwea leheli, ‘Lelenu ni kilabu menga ilombu nukulamisa bandu, nane lisoba la tatu niijomula lihengu lango.’ ");
INSERT INTO mgv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata ela, lelenu ni kilabu na pamalabu, ndaba mbalika endaliya na sapwali jangu, ndaba ngasapi mlota waka Sapanga kuwele pandu pangi ila ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwabandu buku Yelusalemu! Mwabandu buku Yelusalemu! Mwaakomiki alota baka Sapanga na kwaalapu kwa malibu atumisi baka Sapanga babaatumiki kwinu. Mala jingi mbaliki kwaabeka bana baku pamu ngati ingoku heyiikema ibana yaki paijamapapati gaki, lakini mmbanganya ngasemwapaile! ");
INSERT INTO mgv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lingalilya! Nyumba jinu bijilei lihame. Ngammoni kabee mbaka pamwipwaga, ‘Jupengalika jojuhika kupete lihina laka Bambo.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lisoba limu lu Kupomulela, Yesu jajenda kula posu ku nyumba jaka kilongosi jumu jwa Afalisayu, na bandu bababi pala batenda kunndingalaki ngamaa Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mundu jumu jojubi nu ugonzu ukuimba nhyega jabii palongi jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu jaalalukiya abola bamalagalaki na Afalisayu, “Boo, Malagalaki gitu gatupwata gutupwagi tulamisa bandu mlisoba lu Kupomulela au ngasegutuluhuso?” ");
INSERT INTO mgv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lakini ngasebajibwiki sindo. Ndienu Yesu ankamula nngonzu jola nukundamisa nukunndeka jujenda. ");
INSERT INTO mgv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ndi Yesu jaalalukia, “Nya kati jii mwanawaki au ng'ombi jaki ana jiabuki mukiliba Lisoba lu Kupomulela ngaampie kunza?” ");
INSERT INTO mgv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lakini ngasebawesa kujibu sindo. ");
INSERT INTO mgv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu pajaabona ageni bangi babaakokiki biliaguli beni kutama iteu yapa longi yiniisima, jaapwagila malenganu ganga. ");
INSERT INTO mgv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ana mundu junkukokiki kutipati ja ndoa, witama piiteu yapalongi piisima. Ndaba juwesa kuhika mundu joankokiki jongi jwiisima kupeta weapa, ");
INSERT INTO mgv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na mundu jojunkokiki mwaboti jwihika nu kukupwagi, ‘Jumuka jutama jonzo.’ Ndi wiibona ihoni pa bandu boka kujenda kutama kumwisu. ");
INSERT INTO mgv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakini weapa guhenga ana eguhika ku kutipati, gujenda gukatama mwiteu yumunyuma, ili jo jugukokiki pajwiika jugupwagila, ‘Nkosi wango, jumuka, guhika gutama piiteu yapalongi.’ Ndi wibiya gupatiki isima pa bandu boti babaakokiki pamu na weapa. ");
INSERT INTO mgv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ndaba mundu jokapi jojulikwea kulibona nkolongu banhenga kuba nsoku, najojulihulu kuba nsoku bankwea jubiya nkolongu.” ");
INSERT INTO mgv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ndipala Yesu ampwagila mundu jojaakokiki bandu jola, “Ana waandali bandu posu ja muhi au pakamii, kotokwaakoka akosi baku au alongu baku au bandu bana mali gingi babii pambipi nawenga. Nagutei hela, nabombi bagukoka kabee ku nyumba jabu, nanagu bagulepa ngati egwahengi. ");
INSERT INTO mgv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lakini pagukuba na tipati, waakoka bandu ahagu ni ileema na bandu basindwa kujenda na bandu banga kulinga, ");
INSERT INTO mgv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nawe wiitenda kupengeleka, ndaba baniaba ngabiiwesi kugulepa. Sapanga jagulepa masoba guku yoka bandu baamboni.” ");
INSERT INTO mgv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mundu jumu kati ja bandu bababia atemi pamu na Yesu bakakula posu japwaga, “Jupengiwi mundu jojwikula posu mu ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu jajibua, “Mundu jumu jatei tipati ngolongu ja kula posu, jaakokiki bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Muda wa kula ewahika, mundu jola antuma ntumi waki jakaapwagila bandu bajaakokiki, ‘Nhikaniya, ndaba kila sindu kibi tayali!’ ");
INSERT INTO mgv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lakini boti kila jumu batenda kupia sababu. Mundu juku tumbuli, japwaga ‘Nombiki litui, mbala nyenda kulibona, gupepa koku ngahike.’ ");
INSERT INTO mgv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mundu jongi japwaga, ‘Nombiki ng'ombi kome yu kuleme, henu nyenda kuilenge. Gupepa koku ngahike,’ ");
INSERT INTO mgv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ahelahe mundu jongi japwaaga, ‘Nyukwi mbomba ehenu, nganhwesi kuika.’ ");
INSERT INTO mgv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mtumi hoju jabuja nukumpwagi nkolongu waki majambu goti. Nkolongu waki jayomiki ngamaa, ampwagila mtumi waki, ‘Gujenda nyatanyata mwijiji na mumipeta ya musi wakapwajila ahagu, baalemi na banga kujenda na banga kulinga ahika.’ ");
INSERT INTO mgv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Monikatai, mtumi jola japwaga, ‘Nkolongu, ndei ngati egumbwagi lakini jakona napwasi jukutama bandu.’ ");
INSERT INTO mgv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ndi nkolongu ampwagila mtumi waki, ‘Gujenda mwiindela na mumipeta ya musi waalasimisa bandu aikaniya, ili nyumba jangu jitwelila. ");
INSERT INTO mgv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Numpwagi sakaka, ngamundu jumu kati jabandu banaakokiki jojwionza posu ja tipati jangu!’ ” ");
INSERT INTO mgv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndipala, nsambi nkolongu wa bandu egwabiya gujenda najombi, Yesu jugung'anumbukiya nsambi wa bandu nakugupwagi, ");
INSERT INTO mgv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mundu jokapi jojuhika kwangu kutaki jumbala nepani kupeta hejwaapala ahengo baki na amabu baki, nunhwanu waki na bana baki, alongu baki na aka alombu baki hata womi waki mweni, ngasejiwesa kuba mbolee wango. ");
INSERT INTO mgv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundu jokapi janga kujuku nsalaba waki nukumbwata ngajwiwesi kuba mbolee wango. ");
INSERT INTO mgv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Boo nya kati ji na jupai kusenga nnala nkolongu, ngajwiitami oti pai kubalanga lupija lojiwesa kusenge, ili jumanya ana jubii nu lupija lukujomule lihengu lake? ");
INSERT INTO mgv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ana jutumbuli kusenga nsingi, nangasejuwesa kujomule bandu boti babumbona biitenda kunheka. ");
INSERT INTO mgv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ndienu biipwaaga, ‘Mundu hoju jutumbulii kusenga, lakini ngasejawesiki kujomulile lihengu laki.’ ");
INSERT INTO mgv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Au bambu nkolongu boo jojupala kujenda kukomana na bambu nkolongu jongi, nga jutami hoti pai kuwasali ana mbaka juwesi kukomana kwa alonda baki elupu komi bajubinaku na alonda elupu ishilini baka bambu nkolongu jongi hoju? ");
INSERT INTO mgv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ana jubona ngajwiiwesi, jaatuma atumi baki ajenda kuku nkolongu hoju koni jakoni kutali ili kundoba ajatangannya biikomana. ");
INSERT INTO mgv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ahelahe, ana mundu ngase juwesa kukileka sindu sejubii nasu ngasejupalika kuba mbolee wango.” ");
INSERT INTO mgv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyu sindu sa sapi, lakini naguohiki kunong'amake kwaki, wijonzukiya kii ili kukelubuki kunoga kwaki? ");
INSERT INTO mgv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngasegupalika kubeka puluombi wala kuangangana na mbolea. Bandu biitenda kujileke kutali. Jojubi na makutu jujoana!” ");
INSERT INTO mgv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lisoba limu baajopa kodi na bana mahakau bingi bajenda kunzowane Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lakini Afalisayu na abola ba Malagalaki batumbuka kusikatika, “Mundu ajo, jaajopa bana mahakau, kabee jutenda kula nabu.” ");
INSERT INTO mgv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ndipala Yesu jaapwagila malengano ganga. ");
INSERT INTO mgv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ana jumu kati jii jubi na makondoo makomi komi, najumanyiki limu liteikuhoba, jiitenda bole? Jwagaleka makondoo makomi tisa na tisa pululela nukujenda kulitaputa limu lelihobiki mbaka julipata. ");
INSERT INTO mgv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Najilipatiki, jalitogula puubega koni jutogule, ");
INSERT INTO mgv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nu kulipeleka pa nyumba. Ndienu jaakema akosi baki na bapambipi baki na kaapwagi, ‘Ntoguliya pamwa nane ndaba mbatiki likondoo langu lelahobiki.’ ");
INSERT INTO mgv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Numpwagi, kwibia nukutogule ngamaa kunani kwaka Sapanga mundu jumu jwana mahakau ana julekaki mahakau gaki kupeta bandu tisini na tisa babilibona bombi baamboni palongi jaka Sapanga koni ngaseapala kulekake mahakau gabu.” ");
INSERT INTO mgv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Au tupwaga mmbomba jumu jubii na mangengalema komi gu lupija, ana juhoiki lingengalema limu boo, jwiitenda bole? Jipambakiya taa, nuku pyagii mu nyumba nukulitaputa mbaka julipata. ");
INSERT INTO mgv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Najilipatiki, jaakema akakosi baki na ba pambipi jaki nakaapwagi, ‘Ntoguliya pamwa nane, ndaba mbatiki lingengalema langu lelahobiki!’ ");
INSERT INTO mgv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ahelahela numpwagi, atumi bu kunani kwaka Sapanga biitoguliya ngamaa ndaba jaka mundu jumu jwana mahakau jojulekake mahakau gaki.” ");
INSERT INTO mgv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu jaendaliya kupwaga, “Jwabi mundu jumu jojabi na bana akanalomi abeli. ");
INSERT INTO mgv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mwana nsoku jola jaapwagila atati baki, ‘Atati, mmbekia lipungu la hindu yango.’ Najombi jaabagila hindu yaki. ");
INSERT INTO mgv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hegapeta masoba masokopi, nsoku jola jwalombisa hindu yaki, jwaboka pala kujenda musi uku tali. Kokuje jwajomula lupija lwaki kulombe indu ya lyaa ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pajwajomula lupija lwaki, ling'ai li inzala ngolongu japitila mu musi we gola, najombi jatumbuliya kung'alika. ");
INSERT INTO mgv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ndipala jajenda kuloba lihengu kwaka mundu jumwa mwenei jwa musi gola, mundu we jola ampekiya lihengu lukulea magolobi mwi litui laki. ");
INSERT INTO mgv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jatokuliya ngamaa kula manyonyoli gajuleikya magolobi lakini nga mundu joampekiya posu. ");
INSERT INTO mgv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pajapata malangu jawasalya, ‘Atati bangu abi na baahenga lihengu bingi, mbona akula nu kutupi hadi posu jengi kuigii, nane ngua pamba ni inzala!’ ");
INSERT INTO mgv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nikelubukya kwa atati bangu nakaapwagila, ‘Atati, nuntendii mahakau Sapanga na kabee nu nuntendi mahakau mwa atati.’ ");
INSERT INTO mgv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngasembalika hata kungema na mwana wako, gunhenga ngati jumwa jwa atumisi bako.” ");
INSERT INTO mgv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndienu jatumbuliya sapwali kukelabuki kwa atati baki. “Lakini pajwabiya jwakona kutali, ahengo baki eabummbona ambonila ikia anzombatakiya, nukunzobate, nukumbusu.” ");
INSERT INTO mgv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mwana jaapwagila, ‘Atati bango, nunhengi mahakau Sapanga na kabee nunhengi mwenhapa mahakau. Ngasembalika kungema na mwana wino.’ ");
INSERT INTO mgv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lakini atati baki jakema atumisi baki nakaapwagi, ‘Nyatanyata! Nndeta ingobu ya sapi munhwatika! Munhwatika na peti ja ngonzi mulukonzi lwaki na makobasi mu kugolu jaki. ");
INSERT INTO mgv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nsinza Litoli lelikendiki. Twaboa tukula nu kutogule! ");
INSERT INTO mgv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ndaba mwanangu jonzo jabi juwii, lakini henu jubi nsima, jabi juhobiki, lakini henu jubonakini. Henu batenda kutogule.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tipati ejwabia jitenda kuendale mwana waki nkolongu jabia jakona ku litui. Ejwabiya jukelabuka juegale kuhika pa nyumba jajowana ing'oma na bandu bakahina. ");
INSERT INTO mgv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ndienu ankema mtumisi jumu, nukundalu, ‘Panyumba hapa kibikike?’ ");
INSERT INTO mgv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mtumisi jola ampwagila, ‘Nnuuna waku juhikike, na atati baku asinzi litoli lelikendiki ndaba mwana waki juhikiki kunyumba jwakona mwome.’ ");
INSERT INTO mgv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nkombu nkolongu jwatenda kuyoma, jakana kujingi nkati, ndienu atati baki bapita kunza nuku nndoba jujingala nkati. ");
INSERT INTO mgv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lakini jombi jaajibua atati baki, ‘Linga, yaka joha heyi nugu tumaki ngati mtumi waku, ngasenakaaniki gawambwagila kuhenga. Lakini ngasewambeki hata kambui kasoku ndoguliya na akosi bango! ");
INSERT INTO mgv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakini mwana waku jojuhalabini hindu yaku pamu naaka mbomba baatenda ugoni hejuhikiki pee pa nyumba mweapa munsinzi litoli lelikendiki!’ ");
INSERT INTO mgv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Atati baki bumpwagila, ‘Mwanango, weapa gubi na ne masoba goha, na hindu yoka yeminaku nepani ndi yaku. ");
INSERT INTO mgv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lakini tupalika kutogule nukuhekale, ndaba nnuuna waku we hoju twamanyiki juwii, lakini henu jubii mwomi, jabi juhobiki, lakini henu jubonakini.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu jaapwagila banafunzi baki, “Mundu jumu jwana mali gingi jwabii na mundu jukujemalee hindu yaki. Mundu jwana mali gingi we jola, jaajoana kuhuma kwa bandu akapwaga jojujemalee hindu yaki jola jutumi hindu yaki liyaa. ");
INSERT INTO mgv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ndienu ankema nkati jojujemalee hindu yaki jola nukundaluki, ‘Boo majambu bo ganagajoa kwaku wenga? Noba gubalanga hindu yangu yoti yegujopiki na yegubohiki, ndaba ngaguwesi kuba kabee wogujemalee hindu yango.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jojujemalee we jola jawasaliya mmoju, ‘Nkolongu wangu jiimenga lihengu. Boo, niihenga kike? Kulema ngasenhwesa, kujenda kulobaloba ngati nhagu niibona iyoni. ");
INSERT INTO mgv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Enu manyiki sindu sukutenda, ili ebiimenga lihengu langu, bandu anyopa muma nyumba gabu.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ndienu jaakema bandu boti bajaalaja hindu yaka nkolongu waki. Andalukiya jojalonguli kuhika ‘Nkolongu wangu jugulaja kike?’ ");
INSERT INTO mgv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Najombi japwaaga, ‘Madebi mia moja ga mahuta gimi zeituni,’ Jojujemale we jola ampwagila, ‘Jukua likalatasi laku lilideni, tama pai nyata handika madebi amusini.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ndipala andalukiya joandaja jongi, ‘Weapa bugulaja ilenga?’ Jombi japwaga, ‘Maguni mia gi ingano?’ Jojujemalee we jola ampwagila, ‘Jukua likalatasi laku lilideni, andika maguni semanini.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndienu, nkolongu jola andumbalya jojujemale hindu jwanga kuhobaleka jola ndaba jatei ujanza. Ndaba bandu bupundema pani abii nu ujanza nkolongu gukuhenga majambu gabu kupeta bandu ba pamwanga.” ");
INSERT INTO mgv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu jaendaliya kupwaga, “Henu numpwagi, mlintaputiya aka akosi kupete hindu yu pundema ili payijomuka, Sapanga junzopa kunani kwaka Sapanga mu nyumba ja womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jokapi jojuhobaleka ku lijambu lisoko, jiihobalika ku lijambu likolongu, na mundu jokapi jwanga kuhobaleka ku lijambu lisoku, ngajihobaliki ku lijambu likolongo. ");
INSERT INTO mgv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ndienu, ana mwanganya ngasenhobaleka mu hindu yu pundema, boo nya jojiwesa kugupeke hindu ya sakaka? ");
INSERT INTO mgv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ana ngasenhobaleka mu hindu ya mundu jongi, boo nya jojwampekiya hindu hinu mwabete? ");
INSERT INTO mgv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nga ntumisi jojuwesa kwaatumaki aka akolongu abeli, ndaba ansukia jumu nukumpala jongi, au jijongana na jumu nukundeka jongi. Nganhwesi kuntumaki Sapanga nu lupija muda gumu.” ");
INSERT INTO mgv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lakini Afalisayu pabajowana majambu haga goha, bundongama Yesu, ndaba bombi babi apala ngamaa lupija. ");
INSERT INTO mgv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu jaapwagila, “Mmbanganya mulikopake mwaamboni pa bandu, lakini Sapanga jijimanyiki mioju jino. Ndaba sekibonekana sa sapi kwa bandu, kwaka Sapanga kibonikana siliyaa. ");
INSERT INTO mgv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malagalaki gaka Musa na maandiku ga alota galandika mbaka kipindi saka Yohana Mmbatisa. Toka pala Lijambu la Amboni lu Ukolongu waka Sapanga litenda kulandika, na kila mundu jujingi kwa makili. ");
INSERT INTO mgv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakini kujojwiki ngani kunani kwaka Sapanga nu ndema ekwipeta, kuliku kuputika hata kalembu kamu kiliandiku la Malagalaki gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mwanalomi jokapi joandeka nhwanu waki nukunzuku mbomba jongi jutenda ugone, na mwanalomi jokapi joanzuku mmbomba jobunndekiki kabee jutenda ugone. ");
INSERT INTO mgv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Jwabii mundu jumu jwana mali gingi, jojabii juwata ingobu ya bei ngolongu ngamaa, kila lisoba jukubika jutumi hindu yaki lyaa kuhenga tipati. ");
INSERT INTO mgv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nu pundyangu nkolongu, akubika ambeka mundu jumu nhagu jobunkema Lazalu jojabi ni ilonda nhyega joka. ");
INSERT INTO mgv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazalo jatokulya kula posu jejihabwiki pai kuhuma pamesa. Hata hibwa yabiya ihika nuku lamba hilonda yaki. ");
INSERT INTO mgv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Henu nhagu we jola jatenda kuwa, nabombi atumi bu kunani kwaka Sapanga bunzukua mbaka pambipi jaka Ibulahimu. Na mundu jwana mali gingi jola najombi jatenda kuwa na batenda kuntaga. ");
INSERT INTO mgv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Henu koatama bandu ba akuwa kola, mundu jwana mali gingi jola jukubika jung'alika ngamaa, jalinga kunani, ambona Ibulahimu su kutali pamu na Lazalu jojatemi pambipi jaka Ibulahimu. ");
INSERT INTO mgv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Henu ankema kwa sauti ngolongu, ‘Atati a Ibulahimu! Gumonila hikia! Guntuma Lazalu jubeka lukonzi lwaki mmasi, jutulisa lulimi lwango, ndaba ne ng'alika ngamaa na mmwotu gongo!’ ");
INSERT INTO mgv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Lakini Ibulahimu anzibua, ‘Kombuka mwanango, pawabii punndema wajopiki hindu yoti ya sapi, na Lazalo jajopiki giliya. Lakini henu Lazalu jubii pamba jutenda kutogule weapa gutenda kung'alika. ");
INSERT INTO mgv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hata hela, kati jitu twepani na weapa libi libomba likolongu, ili mundu jojupala kuhomba kuhuma hoku kuhika kwitu jwiiwesa, na kabee nga mundu jojuwesa kuhomba kuhuma kwinu kuhika kwito.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mundu jwana mali gingi we jola japwaga, ‘Nala nunndoba mwaatati mwaa Ibulahimu, guntuma Lazalo jujenda ku nyumba ja atati bango, ");
INSERT INTO mgv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ndaba mi naakaalongu bangu nhwano. Nndeka jujenda jakaakanakiya biitenda ngati enatenda nepani ili bihika pamba nu kung'alika ngati hening'alika nepane.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibulahimu ampwagila, ‘Alongu baku abii na Musa na alota baka Sapanga, waaleka baajoanakiya bombe.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lakini mundu jwana mali gingi jola japwaaga, ‘Ngahela atati bangu a Ibulahimu! Ana mundu juyokiki kuhuma kwa bandu bawii nakaajende, bagalekakiya mahakau gabu.’ ");
INSERT INTO mgv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibulahimu ampwaga, ‘Ngasebaajowani Maandiku gaka Musa na Maandiku gaka alota baka Sapanga, ngabiiwesi kujoane hata najuyokiki mundu kuhuma kwa bandu baawii.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ndienu Yesu jaapwagila banafunzi baki, “Sakaka ipitila hindu yeyunkolo mundu kutenda mahakau, lakini musijikiboni mundu jojaakoloha mahakau gapitila! ");
INSERT INTO mgv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kwiibia mbanga kwaka mundu hoju kunkongale lilibu likolongu lukupole pahingujaki nukundeke gunhanga, kuliku kunhenga jumwa jwa asoku haba jutenda mmahakau. ");
INSERT INTO mgv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Henu mulilenda! “Nndongu waku najukukosi, nndakalya, najombi najujetaki mahakau gaki jijeleka kabee, gundekakiya. ");
INSERT INTO mgv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ana jukosi mala saba ku lisoba limu, najukelabwiki kwaku kabee mala saba sukupwaga, ‘Nyetaki mahakau nganijeleki kabee,’ Gupalika gundekakiya.” ");
INSERT INTO mgv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atumi baki bumpwagila Bambu, “Utujonzukya kuhobale.” ");
INSERT INTO mgv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bambu japwaaga, “Ana kuhobale kwinu kwakabia kusoku hata ngati imbeju ja haladali, mwakawesa kugupwagi nkoju ago, ‘Tupuka ukalipanda ku nhanga!’ Nagwombi wiitenda kunzoane. ");
INSERT INTO mgv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tupwaga jumwa kati jinu jubi nu ntumisi waki jojulema litui au julima makondoo. Boo, ntumisi jola hejuhika kuhuma ku nngonda, bambu waki ampwagila lee, ‘Guhika nyata gu kula poso?’ ");
INSERT INTO mgv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ngajupwagiela! Jwiipwaga, ‘Ndelakiya posu, utumbuliya kundumaki nepani mbaka pani jomula kula na kunywa, ndi nawe wiikula na kunywa!’ ");
INSERT INTO mgv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Boo, jwiitenda lee kunsengu ntumisi jola ndaba juhengiki sapi gaandagalakile? ");
INSERT INTO mgv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nanamu ahelahela na nhengiti gajundagalaki Sapanga, mpwaga, ‘Twepani twa atumisi twanga na faida, tuhengiki sewalagalaki tuhenga.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu pajabii mwindela kujenda ku Yelusalemu jwapetii mu mipaka juku Samalia nuku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pajajingala mu kijiji simu, baketangini na bandu komi baa leliki, bajemiki sukutali, ");
INSERT INTO mgv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bajamalya kwa sauti, “Yesu! Bambu! Utubonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu ejaabona jaapwagila, “Nzendannya mukililangia kwaka agolu.” Pababi mwiindela bakajendaninya batenda kunyambisika. ");
INSERT INTO mgv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jumu wabu ejabona julamiki, jakelabukya kwaka Yesu, koni andumbali Sapanga suku jamalii. ");
INSERT INTO mgv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jililekala pai kulongi ja magolu gaka Yesu koni akunsengula. Mundu we hoju jabii juku Samalia. ");
INSERT INTO mgv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu jalalukya, “Boo, ngase mwalamiki lee mwa bandu kome? Boo bangi tisa bala abi kwako? ");
INSERT INTO mgv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Boo, nga lee jongi jojukelabwiki ku ndumbali Sapanga ila nngeni jonzo pena?” ");
INSERT INTO mgv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ndienu Yesu ampwagila mundu jola, “Jumuka gujenda, kuhobale kwaku kugulamise.” ");
INSERT INTO mgv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lisoba limu Afalisayu bundalukiya Yesu, “Ukolongu waka Sapanga wiika lii?” Najombi jaapwagila, “Ukolongu waka Sapanga ngaguhiki sukubonikana kwa miho. ");
INSERT INTO mgv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ngamundu jojwiwesa kupwaaga, ‘Gubii pamba,’ au ‘Gubi kolakola.’ Ndaba Ukolongu waka Sapanga gubii nkati jino.” ");
INSERT INTO mgv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ndienu jaapwagila Banafunzi baki, “Gihika masoba mwipala kulibona lisoba limu laka Mwana waka Mundu, lakini ngamwalibone. ");
INSERT INTO mgv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bandu bampwagila, ‘Ndingalya, jubii kolakola!’ Au ‘Jubi kongone!’ Lakini mwanganya nkoto kwaapwata. ");
INSERT INTO mgv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ndaba ngati unang'anu ukitobi, hegupiti nukumulika kunani kuhumi upandi gumu mbaka upandi gongi, ndi hejwibia Mwana waka Mundu hejiiki mmasoba gaki. ");
INSERT INTO mgv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakini kabula ja haga jwiitumbuliya hoti kung'alika ngamaa na bandu bikibeleku senze kunkana, ");
INSERT INTO mgv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ngati egabii masoba gaka Noa, ndi ekwibia ahelahe mu masoba gaka Mwana waka Mundu. ");
INSERT INTO mgv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bandu baendalya kula na kunywa, akanalomi baendalya kujuku aka mbomba na aka mbomba baendaliya kujenda ku ulomu mbaka lisoba lejwajingala Noa munhwatu nkolongu gobugukema safina. Ndipala kikoka sa masi saika na kwaakoma boa. ");
INSERT INTO mgv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kwibia ngati ekwabia mmasoba gaka Lutu. Bandu baendalya kula na kunywa, kulomba nu kulombesa, kupanda imbeju nu kusenga. ");
INSERT INTO mgv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakini lisoba lejaboka Lutu ku Sodoma, motu na malibu gagalipuka mwotu gahuluka pai kuhuma kunani kwaka Sapanga nakwaa kupisa boti. ");
INSERT INTO mgv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndi hekwibia lisoba laka Mwana waka Mundu hejwiiyekuliwa. ");
INSERT INTO mgv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mlisoba lee heli, mundu jokapi jojubi kunani jikipagaa jiihuluka kujingi mu nyumba kujuku hindu yaki. Kabee, najojubi ku lituhi jwikelabuki ku nyumba. ");
INSERT INTO mgv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nkombuka gagumpataa nhwanu waka Lutu. ");
INSERT INTO mgv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jokapi jojupala kugombo womi waki jitenda kuguhoa, na jokapi jojuhoa womi waki ndaba jangu, jiipata womi wa masoba goti. ");
INSERT INTO mgv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Numpwagi, lisoba leheli hikilu bandu abeli biibia agoni kitanda simu, jumu biitenda kunzuku najongi biitenda kundeka. ");
INSERT INTO mgv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aka mbomba abeli bibia pamu apola ilebi yabu, jumu biitenda kunzuku najongi biitenda kundeka.” ");
INSERT INTO mgv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bandu abeli biibia kulitui, jumu biitenda kunzuku najongi biitenda kundeka. ");
INSERT INTO mgv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ndienu banafunzi baki bundalukya, “Bambo ganiaga giipitila kwako?” Yesu jajibua “Pakibii sindu sekiwii ndi ihegalane hijuni ikolongu yebikema tai.” ");
INSERT INTO mgv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ndienu, Yesu jaabola banafunzi baki kwa malenganu, kulangi masoba goa kutaki bunndoba Sapanga bila kusoka. ");
INSERT INTO mgv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jwapwaaga, “Kumusi gumu kwabii na ntemu magambu, jojuwe ngaseanzogupa Sapanga wala ngasejwaapala bandu. ");
INSERT INTO mgv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mmusi we hogu jwabii kabee nyongo jumu joawii alomi baki, anzendila ntemu magambu hoju mala jingi koni andoba, ‘Nandi unyangatia kupata sekibii sangu kuhuma kuka mmbaja wango!’ ");
INSERT INTO mgv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa masoba gingi ntemu magambu jola, jutendika kukana kunzangati mmbomba joawii alomi we jola. Lakini mwisuwe japwaga, ‘Hata ngama nepane ngasenunzogopa Sapanga wala kwaapala bandu, ");
INSERT INTO mgv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakini ndaba mmbomba joawi alomi baki ajo jundenda kunzumbua, nanzangatiya kupata sekibii saki anangahela jwiiendalea kunzumbua!’ ” ");
INSERT INTO mgv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ndienu, Bambu jaendaliya kupwaaga, “Nzoaninya sejupwagiki jojutemu jojubii juliyaa ajo. ");
INSERT INTO mgv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Boo, Sapanga lee nga jaajangatiya sekibii sabu bandu bajaagwi babunndele muhi ni ikilo? Boo, jwiiselewa lee kwaajangatila? ");
INSERT INTO mgv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Numpwagi jaajangatya nyata. Lakini Mwana waka Mundu pajwiika, boo, mbaka lee jwaakolee bandu babunhobale pundema?” ");
INSERT INTO mgv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ndipala Yesu jaapwagila lilenganu lende bandu babilibonaa baamboni na kwaalongama bangi. ");
INSERT INTO mgv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bandu abeli bajenda mu Nyumba jaka Sapanga kundoba Sapanga. Jumu mfalisayu na jongi jojujopa bandu kodi. ");
INSERT INTO mgv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mfalisayu, jaloba mmoju jaki koni jakapwaga, ‘Nugusengu wa Sapanga, ndaba nepani nga ngati bandu bangi baakula kupeta kipemu na asoli na baatenda ugoni na wala nepani nga ngati jojujopa kode ajojo. ");
INSERT INTO mgv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nepani mbunga kula masoba mabeli kila juma, mbia lipungu la komi mhindu yoti yembata.’ ");
INSERT INTO mgv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lakini jojujopa kodi jola jajemiki sukutali wala ngasejalingali mihu gaki kunani kwaka Sapanga, ila jililapula pamoju ku usungu, nukupwaga, ‘Sapanga, nagumonee ikia, nepani mii na mahakau!’ ");
INSERT INTO mgv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu japwagi, jojujopa kodi ajo, jabuja ku nyumba koni jujetakiwi na Sapanga kupeta Mfalisayu jola. Ndaba mundu jokapi jojulibeka kuba nkolongu bantenda kunhulu na jokapi jojulibeka kuba nsoku biitenda kunkwea.” ");
INSERT INTO mgv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bandu bundetila Yesu bana asoku ili jwaabekila maboku gaki na kwaapengee. Banafunzi pabaabona jutenda hela, batenda kwa alakali, ");
INSERT INTO mgv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","lakini Yesu jaakema bana bebala nakaapwagi, “Mwaaleka bana asoku ahika kwangu, mwaakana, ndaba Ukolongu waka Sapanga gwaahiki bandu ngati baniaba. ");
INSERT INTO mgv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Numpwagi sakaka! Mundu jokapi jwanga kugujopa Ukolongu waka Sapanga ngati mwana nsoku, kyee nga jwijingi mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nkolongu jumu jwa Ayaudi andalukiya Yesu, “Mmbola wa ambone, ndenda kike ili nhwesa kupata womi wa masoba goka?” ");
INSERT INTO mgv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu andalukiya, “Ndaba jakii gungema na ambone? Ngase jubii mundu jwa amboni ila Sapanga kajika jaki. ");
INSERT INTO mgv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ugamanyiki malagalaki gaka Sapanga egapwaga, ‘Witenda ugoni, wikoma, wijiiba, wiipwaga isoli, wajetakiya ahengo baku na amabu baku.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mundu jola japwaga, “Malagalaki haga gooka nepani nagakamwi tumbuka pu ukombu wangu.” ");
INSERT INTO mgv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu pajajowana hela ampwagila, “Kipungwi sindu simu, kalombisa hindu yoti yegubinaku, nu lupija lwe waapekya ahagu, nanagu wibia na mali gingi kunani kwaka Sapanga, ndienu guhika gumbwata.” ");
INSERT INTO mgv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lakini mundu jola pajajogwa hela gumbina mmoju ngamaa ndaba jabii na mali gingi. ");
INSERT INTO mgv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu paambona gumbina mmoju, japwaga, “Kunonipi ngamaa mundu jwana mali gingi kundeke womi waki Sapanga! ");
INSERT INTO mgv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ndaba kujojwiki ngani kinyama sebikikema ngamia kupeta mulihotu la sindanu, kuliku mundu jwana mali gingi kundeke womi waki Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bandu babunzogwannya Yesu bundalukiya, “Boo nya enu jojwiwesa kugombolewa na Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu japwaaga, “Ganga kuwesikana kwa bandu, kwaka Sapanga kiwesikana.” ");
INSERT INTO mgv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ndienu Petili jalalukiya, “Na twe bole? Twilei hindu yoka tugupwatiki wehapa!” ");
INSERT INTO mgv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu jaapwagila, “Sakaka numpwagi mundu jokapi jojwijilei nyumba jaki au nhanamundu au ndongumundu au hengo na nyongoo au bana, ndaba ju Ukolongu waka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jwijopa mali gingi mu masoba ganga na jitama mu womi wa masoba goha masoba gagahika.” ");
INSERT INTO mgv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu jaajuku banafunzi baki komi na abeli bala, nakaapwagi, “Nzoannya! Tukwela kujenda ku Yelusalemu na hoku kila sindu seanhandaki alota baka Sapanga Mwana waka Mundu sakatenda kupitii. ");
INSERT INTO mgv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ndaba bitenda kunkamu nukunkabisa kwa bandu banga Ayaudi. Nabombi biitenda kundongama, nukuntondo, nukunhuni imata, ");
INSERT INTO mgv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bandapula iboku nu kunkoma. Lakini mu lisoba la tatu jwiitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lakini banafunzi baki ngase bamanyiki julongalekike. Baahihiki majambu ge haga, na ngasebamanyiki sejwapwaga Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pajahegalya kuhika ku Yeliko, mundu jumu jwanga kulinga jwatemi pulutengu jiindela jakaloba. ");
INSERT INTO mgv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mundu jwanga linga we jola pajajoa nsambi wa bandu gutenda kupeta, jalalukiya, “Boo kibii kike?” ");
INSERT INTO mgv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bumpwagila, “Yesu juku Nazaleti jutenda kupeta.” ");
INSERT INTO mgv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Najombi jajamalya koni jakapwaaga, “Yesu, Mwana waka Daude, gumonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bandu bababia andongulii andakalya nukupwagi tumbala, lakini jombi jaendalya kujamalii, “Yesu Mwana waka Daude, gumonila ikia!” ");
INSERT INTO mgv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu jajema, nakaapwagi bundeta mundu hoju pajajemiki jombi. Jwanga kulinga we jola hejwahegaliya pambipi, Yesu andalukiya, ");
INSERT INTO mgv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Gupala nu guhengila kike?” Najombi japwaaga, “Bambu, mbala kulinga kabee.” ");
INSERT INTO mgv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ampwagila, “Linga! Kuhobale kwaku kugulamise.” ");
INSERT INTO mgv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Apalapa jwanga kulinga we jola jwatenda kulinga, ampwata Yesu koni akundumbaliya Sapanga: Bandu boa pababoona hela, nabombi bundumbaliya Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu jajingala ku musi uku Yeliko, jabia jupeta pi kilanda ja musi we gola. ");
INSERT INTO mgv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jwabii mundu jumu mmusi we gola joankemika Zakayu, jojabii nkolongu wa baajopa kodi, najombi jwabi mundu jwana mali gingi. ");
INSERT INTO mgv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Japala kumbona Yesu ejubije, lakini ngasejawesa ndaba kwabii na bandu bingi najombi jwabii nzipi. ");
INSERT INTO mgv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Henu, jajombatakiya palongi ja bandu, jakwela munkongu nkoju ndaba Yesu japetila indela ajelaje. ");
INSERT INTO mgv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ndienu, Yesu pajahikaa pala, jalinga kunani, nukumpwagi Zakayu, “Zakayu huluka nyata, ndaba lelenu nepani mbalika kupilaki mu nyumba jako.” ");
INSERT INTO mgv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayu jahuluka nnyata nukunzopa Yesu koni jutogule. ");
INSERT INTO mgv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bandu boa pababona hela, batumbuliya kung'ong'ateka koni bakapwaga, “Mundu we hoju jupiti kutama kunyumba jaka mundu jwana mahakau.” ");
INSERT INTO mgv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lakini Zakayu jajema, ampwagila Yesu, “Jogwana Bambu! Nepani naapekya ahagu nusu ja hindu yangu, ana nunyagiki mundu jokapi sindu sokapi, na nkelabuki nu kunzonzuke mala nsese.” ");
INSERT INTO mgv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ampwagila, “Lelenu ukombosi guhikiki nyumba jenze, ndaba jonzo najombi julukolu lwaka Ibulahimu. ");
INSERT INTO mgv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ndaba Mwana waka Mundu juhikiki kataputa na kagombo bandu bahobiki.” ");
INSERT INTO mgv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bandu pababi ajogwane malobi gala, Yesu jaendaliya kaapwagi kwa malenganu. Ndaba jabii pambipi nuku Yelusalemu, nabombi bawasaliya Ukolongu waka Sapanga gubii pambipi kupiti. ");
INSERT INTO mgv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ndienu jaapwagila, “Jabii mundu jumu kuhuma mulukolu luu ubambu nkolungu jabia jujenda kundema ukutali ili bukunzemika kuba bambu nkolongu, na kabee jwiibuja. ");
INSERT INTO mgv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Henu, kabula jukuboka, jwaakema atumisi baki komi na abeli, jaapekya lupija kila mundu na kaapwagi, ‘Nhengila lihengu lukulomba hindu nukulombase lupija londo mbaka panikelubuka.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lakini bandu bu pundema jaki batenda kunsuki, baatuma bandu ajenda akapwaga, ‘Ngasetumpai mundu hoju jubia bambu nkolongu wito.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pabunzemika kuba bambu nkolongu, jakelubuka ku nyumba jaki na kalagalaki atumisi baki bajaapeki lupija lola ili jumanya kila mundu ijonzukiki ilengaa. ");
INSERT INTO mgv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ntumisi jojalonguli, japwaaga ‘Nkolongu, lupija lwaku lowambeki lujonzukiki longi komi.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bambu jola japwaaga, ‘Guhengiki Sapi, weapa untumisi waamboni. Ndaba guhobaliki nsindu kisokopi, nukupeke ukolongu wa misi komi!’ ");
INSERT INTO mgv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ntumisi ja pili jahika japwaaga, ‘Bambo, lupija lowambeki lujonzukiki longi nhwano.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Najombi ampwagila, ‘Sapi nanagu wibia nkolongu wa misi nhwanu.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ntumisi jongi jwahika nu kupwaga, ‘Jukua lupija lwaku, nulukongiki sapi mu kitambaa, ");
INSERT INTO mgv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","nugujogupa ndaba weapa wa mundu unkali. Gujuku hindu yanga kuba yaku nukuhusa hindu yanga kupanda wamweti.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nkolongu waki ampwagila, ‘We hapa guntumi mbaja nukulepa ngati heguhengiki! Wamanyiki ne na mundu nunkali, nenyuku hindu yela yanga kubeka namweti nukuhusa yanga kupanda namweti. ");
INSERT INTO mgv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndaba jaki ngase wabei lupija lwangu kwa bandu baatunza lupija, nane henakahika nakajopa lupija lwangu lolujonzukike?’ ");
INSERT INTO mgv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ndi jaapwagila bandu bababi ajemiki pala, ‘Munyaga lupija lweholu, mumpekya ntumisi jola jolujonzukiki jengi komi.’ ");
INSERT INTO mgv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lakini bombi bumpwagila, ‘Nkolongu, lakini mbona jonioju lujonzukiki lupija longi kome!’ ");
INSERT INTO mgv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Najombi jaapwagila, ‘Numpwagi sakaka, kila jojubii na sindu biitenda kunzonzuke. Lakini janga kuba na sindu, hata kisoku sejubinasu biitenda kunyaga. ");
INSERT INTO mgv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Henu abaya bangu baangana nepani kwaalongosa, mwaaleta pani na mwaakoma apambane koni nakalingalya.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu hejajomula kulonge ganiaga, jalongulya palongi kujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pajaegalya kuhika ku Betifage nuku Betania, pambipi ni Kitombi suku Mizeituni, Yesu jaatuma banafunzi baki abeli, ");
INSERT INTO mgv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","jaapwagila, “Nzenda mu ijiji yemwibona palongi jii. Hemwibia nzingi mu ijiji heyi, mkilibona liponda bilikongiki kulongi jii ngasejuwahiki kulitumii mundo. Mwilibopula mukilileta pambane. ");
INSERT INTO mgv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ana mundu jundaluki mundu jokapi ndaba jukubopo liponda, mu kumpwagila, ‘Julipala Bambo.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Banafunzi bala ebajenda pala, bunkolila ngati Yesu ejaapwagila. ");
INSERT INTO mgv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pababia bilibopo liponda lela, mwini liponda jaalalukya, “Ndaba jaki mu libopo liponda hele?” ");
INSERT INTO mgv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nabombi bumpwagila, “Julipala Bambo.” ");
INSERT INTO mgv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ndipala bumpelakya liponda lelela Yesu, batandika ingobu yabu pungongu ji liponda, nuku nkwea Yesu panani jaki. ");
INSERT INTO mgv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu pajaendalya kujenda, na bandu batandika ingobu yabu mwiindela. ");
INSERT INTO mgv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu pajahegalya ku Yelusalemu, pi kihelelu si Kitombi si Mizeituni, nsambi nkolongu wa banafunzi baki batumbuliya kundumbali Sapanga koni atogule kwa sauti ngolongu ndaba ja majambu makolongu gabagabweni, ");
INSERT INTO mgv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","babia apwaga, “Jupengaliki Bambu nkolongu jojuhika ku liina laka Bambo! Kubia lukwali nu ulumbi kunani kwaka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Papuje Afalisayu bangi bababi munsambi wa bandu gola bumpwagila Yesu, “Mbola, waapwagila banafunzi baku atumbalaje!” ");
INSERT INTO mgv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu jaajibua, “Numpwagi bandu be haba ana atumbii, malibu haga gijamaliya kwa sauti.” ");
INSERT INTO mgv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu pajaegalya musi guku Yelusalemu napajabona bandu ba musi gola jatenda kaalele. ");
INSERT INTO mgv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Japwaaga, “Ana wakamanyiki lelenu majambu gagaleta lukwali! Lakini henu ahihiki pamihu jii. ");
INSERT INTO mgv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ndaba gihika masoba, abaya baku bagusengila ubegu, biitenda kuguyongolota nu kukuhinya pandi yoka. ");
INSERT INTO mgv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bagutimbatimba weapa na bana baku mu nyumba jaku. Ngabilileki lilibu panani jililibu lengi, ndaba ngase gumanyiki kipindi sukuhika Sapanga kungombo.” ");
INSERT INTO mgv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu jajingala pa Nyumba jaka Sapanga, jatumbuliya kabeenge kunza bandu babaii alombase hindu, ");
INSERT INTO mgv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","koni jakapwaaga, “Ahandiki, ‘Nyumba jangu jiibia nyumba jukundobe Sapanga,’ Lakini mwanganya mwijing'anabwi kuba imbaku ja manzolinzoli.” ");
INSERT INTO mgv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lisoba limu Yesu jabia jaabola bandu pa Nyumba jaka Sapanga. Agolu akolongu, na abola ba Malagalaki na aka akolongu bataputa indela jukunkoma, ");
INSERT INTO mgv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lakini ngase bapatiki mbekenyu jukunkoma ndaba bandu babiya bukunzoaniya. ");
INSERT INTO mgv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lisoba limu, Yesu pajabi jaabola bandu pa nyumba jaka Sapanga nakaalandi bandu Lijambu laa Sapi, agolu akolongu naaka abola ba malagalaki pamu na aseja bahikiki, ");
INSERT INTO mgv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bundalukiya, “Utupwagila guhenga mahengu ge haga kupete uwesu bole? Boo nya jojugu peki uwesu we hogo?” ");
INSERT INTO mgv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu jaapwagila, “Nane nanndaluki lijambu limu, mmbwajila, ");
INSERT INTO mgv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","boo, uwesu waka Yohana lukubatisa bandu lwahuma kwako? Boo, kwaka Sapanga au kwa bandu?” ");
INSERT INTO mgv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakini bombi balaluana beni kwa beni nukupwaga, “Ana tupwagiki guhuma kwaka Sapanga, jombi jatulalukya, mbona ngase munhobali Yohana?” ");
INSERT INTO mgv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kabee ana tupwagiki wahuma kwa bandu, bandu boa batulapula kwa malibu, ndaba boa anhobali Yohana jabii mlota waka Sapanga! ");
INSERT INTO mgv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Henu, bumpwagila, “Ngasetumanya uwesu we hogu wahuma kwako.” ");
INSERT INTO mgv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu japwaaga, “Hata nepani nganumpwagi henga lihengu lende kupete uwesu bole.” ");
INSERT INTO mgv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ndienu Yesu jaendalya kaapwagi bandu malenganu ganga, “Mundu jumu jalemiki lituhi li mizabibu. Nukulikodisa kwa bandu baalema, ndi jaboka nukujenda kutama kundema jengi. ");
INSERT INTO mgv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kipindi sukutongo zabibu esahika, antuma mtumisi waki kwa bandu baalema bala ili bumbaguliya zabibu. Lakini bandu baalema bala bumbenga nukundapu nukunkelabu maboku matopu. ");
INSERT INTO mgv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nkolongu jola antuma kabee ntumi jongi, lakini bombi bunndapula ahelahe nukunhenge majambu giliya, nukunkelabu maboku matopu. ");
INSERT INTO mgv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Antuma kabee ntumisi wa tatu, hoju najombi, batenda kunhumisa, nukundeke kunza jilitui. ");
INSERT INTO mgv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ndipala mundu jwini litui jola japwaaga, ‘Niitenda bole? Nantuma mwana wangu jonumpai, kwaa buntenda kunzogopa ngamaa.’ ");
INSERT INTO mgv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lakini bandu baalema bala pabumbona pee, bapwagannya, ‘Jonzo ndi jobandekila lituhi lende. Enu, tunkoma ili litui libia liito.’ ");
INSERT INTO mgv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Enu, bumpia kunza jilitui li mizabibu lela, nukunkoma.” Yesu jaalalukya, “Boo, mundu jojubii nilitui jola jaatenda kii bandu baalema bala? ");
INSERT INTO mgv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jwiika na kaakoma bandu baalema bala, nakaapeke bandu bangi litui li mizabibu lela.” Bandu pabajogwa malenganu gala, bapwaga, “Ngahela, haga giipiti!” ");
INSERT INTO mgv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lakini Yesu jaalingalya na kaapwagi, “Maandiku ganga gabii na maana boo? ‘Lilibu lebilikana bandu baasenga, enu ndi libii lilibu lelipalika ngamaa nnyumba!’ ");
INSERT INTO mgv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu jokapi najuabuki panani jililibu heli jwiitunyuka ipandiipandi, na mundu jokapi ana lunhabuki lilibu heli litenda kumponda.” ");
INSERT INTO mgv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abola ba malagalaki na agolu akolongu bamanyiki malenganu gala gaalenga bombi, ndi bapala bunkamula Yesu apalapala. Lakini baajogopa bandu. ");
INSERT INTO mgv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Enu, babiya ataputa muda wa sapi wukunkamu. Ndi baatuma bandu bilikopakya baamboni kwaki, bumpendakiya kwa maswali, ili jujibwa liya apata indela jukunkali nukumpeleka kwaka kilongosi juku Loma. ");
INSERT INTO mgv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bandu bala bumpwagila Yesu, “Mbola, tumanyiki weapa gupwaga nukubola majambu gasakaka, ngasegulinga ukolongu waka mundu, lakini gubola lijambu la sakaka lejupala Sapanga tuhenga. ");
INSERT INTO mgv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Utupwagila, boo sapi lee kulepakodi kwaka bambu nkolongu juku Loma joakema Kaisali au nga sape!” ");
INSERT INTO mgv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu jamanyiki kupendake kwabu, jaapwagila, ");
INSERT INTO mgv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nnangia lingengalema. Boo, sula jenze ni lihina lende laka nyane?” Bunzibua, “Yuku bambu nkolongu juku Loma joakema Kaisali.” ");
INSERT INTO mgv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ndienu Yesu jaapwagila, “Sapi, hindu yaka nkolongu juku Loma mupekia nkolongu juku Loma, nayaka Sapanga mupekia Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndienu ngasebawesiki kunkamu kupete lilobi lokapi lejwapwagiki pa bandu ila basangi lijibu laki baamua kutumba. ");
INSERT INTO mgv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndipala Asadukayu bangi, bandu bapwaga nga kuyoka kwa bandu bawii, buhikila Yesu nukundaluki, ");
INSERT INTO mgv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mbola, Musa, jutuandakya, ‘Ana nndongu waka mundu juwi nukunndeka nndonguwaki bila mwana, nndongu waki kupalika kuntola mmbomba we hoju, ili ampapila nndongu waki bana.’ ");
INSERT INTO mgv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwabii naaka alongu saba. Jakwanza jola anzukua mmbomba na jakuwa bila kundeka mwana. ");
INSERT INTO mgv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ndongu jwa pili jola anzukua mmbomba joawii alomi we jola, najombi jakuwa bila kwaaleka bana, ");
INSERT INTO mgv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","watatu anzukua mmbomba jola na kwabiya ahelahe boti saba, lakini bakuwa bila kwaaleka bana. ");
INSERT INTO mgv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwisuwe jakuwa kabee mmbomba we jola. ");
INSERT INTO mgv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Boo, lisoba la bandu pabiyoka, nyongoo we hoju jwiibia nhwanu waka nyane? Ndaba babia anzukwi boa saba.” ");
INSERT INTO mgv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ampwagila, “Bandu ba ndema jenze ajuku nu kujukulika, ");
INSERT INTO mgv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lakini bandu bajaabona Sapanga awesa kuba mu ndema jejihika ili kuyoka ngabiijuku wala kujukulika. ");
INSERT INTO mgv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ngabiiwesi kuwa kabee, ndaba bibia ngati atumi bu kunani kwaka Sapanga, bombi biibia bana baka Sapanga ndaba atei kuyoka. ");
INSERT INTO mgv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lakini sakaka kuyoka kuhuma kwa bandu baawi kubii. Ata Musa jalangia lijambu leheli mu Maandiku gaka Sapanga pajapwaga kupete kitengu sesabiya kinyakaa mwotu. Papuje jwapwaga Bambu ndi Sapanga jwaka Ibulahimu, Sapanga waka Isaka na Sapanga waka Yakobu. ");
INSERT INTO mgv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Najombi nga Sapanga wa bandu baawii lakini jombi Sapanga ja bandu bome. Ndaba boti atama pundema ndaba jaki.” ");
INSERT INTO mgv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aka abola bangi ba Malagalaki bapwaaga, “Mmbola, gujibwiki sapi ngamaa.” ");
INSERT INTO mgv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nabombi ngasebalengiki kundaluki malobi gange. ");
INSERT INTO mgv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ndienu Yesu jalalukya, “Bandu apwaga boo, Kilisitu mwana waka Daude? ");
INSERT INTO mgv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi weni jupwaga mu kitabu sa Zabuli, ‘Bambu ampwagila bambu wangu. Tama upandi wangu ukumalele, ");
INSERT INTO mgv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mbaka naabeka bandu babugusuki ngati kiteu sukubeke magolu.’ ");
INSERT INTO mgv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ana Daudi we ankema jombi, ‘Bambu,’ kwibia boo jubiya mwama waka Daude?” ");
INSERT INTO mgv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bandu boti pababiya bunzowane Yesu, jaapwagila banafunzi baki, ");
INSERT INTO mgv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nzepana naka abola ba Malagalaki bapala kupetapeta koni aweti ingobu ilasu, apala kulamukiwa kwii hisima na bandu mumagulio, nukutama mwiteu yapalongi mu nyumba jukuketangane Ayaudi nuku tipati. ");
INSERT INTO mgv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baajibi bandu bawii aka alomi babu, bilikopake ngati baamboni sukulilangi aloba ku kipindi kilasu, bandu haba bipata azabu ngolongu!” ");
INSERT INTO mgv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu jalingiki ngamaa, jaabona bandu bana mali gingi ajege matambiku gabu mukikoku pa Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ambona nyongoo jumu joawi alomi jujege mangengalema mabeli. ");
INSERT INTO mgv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu jaapwagila, “Numpwagi sakaka, nyongo nhwagu joawi alomi ajo jupiiki sindu kikolongu kupeta yeajegi bandu boa. ");
INSERT INTO mgv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ndaba bangi boa apihiki matambiku gabu gagapeti mu hindu yabu, lakini nyongo ajo pamu nu uhagu waki jupihiki kila sindu sejukipala mu womi.” ");
INSERT INTO mgv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Banafunzi bangi babia alongale kupete Nyumba jaka Sapanga, jeasengiki kwa malibu gu lupija lwingi, kabee balongalia matambiku gabaapihihiki kwaka Sapanga. Lakini Yesu japwaga, ");
INSERT INTO mgv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Haga goa gamwagabona, masoba gagihika, biitenda kubombulana ngaliigi lilibu panani jililibu lengi, na kila sindu kiitenda kuhalabika.” ");
INSERT INTO mgv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bandu bundalukya Yesu, “Mmbola, majambu ge haga gipitila lile? Nginyuli boo yeyiilangia majambu ge haga egibia pambipi kupiti?” ");
INSERT INTO mgv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu jajibua, “Nnzepa, mundu jankonga. Ndaba bandu bingi bihika kuliina langu nukupwaga, ‘Nepani ndi Kilisitu,’ na ‘Nilisoba lee libi pambipi.’ Lakini mwanganya mwaapwata! ");
INSERT INTO mgv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pamwijoana majambu gukukomana na puju, mwijogopa, ndaba majambu ge haga gapalika gapitila hoti, lakini mwisu ngaseguhika nyata.” ");
INSERT INTO mgv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ndipala, Yesu jaendalya kupwaga, “Bandu ba ndema jimwa biikomana na bandu bu ndema jengi, nu ukolongu gumu gwikomana nu ukolongu gongi. ");
INSERT INTO mgv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kwipitila kililima kikolongu su ndema, ling'ai linzala, na magonzu guku jambukani, kwipitila majambu gingi guku jogopesa na nginyuli ngolongu kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lakini kabula jukupiti haga goti, biitenda kunkamuu nu kung'alisa. Bampelika mma nyumba guku ketangane Ayaudi na muma gelesa, na bampelika palongi jaka bambu akolongu na aka kilongosi ndaba ji liina lango, ");
INSERT INTO mgv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","kupete haga mwiikuba mwaalandii bandu Lijambu la Amboni. ");
INSERT INTO mgv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lakini mmoju jinu, mwiholale sukulonge, ");
INSERT INTO mgv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndaba nepani nampekia malobi gukupwaaga gaa sapi, ngajwiikubi mbaja winu jojwiiwesa kukana wala kumpenga gamwipwaaga. ");
INSERT INTO mgv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nanamu banng'anambuka hata na ahengo na aka nyongo binu, aka kilongu binu, naakosi binu na bangi kati jinu biitenda kukomeka. ");
INSERT INTO mgv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bandu boti bansukila mwanganya ndaba jukuhobale nepani. ");
INSERT INTO mgv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lakini hata lijunzu li limu ngalihobe. ");
INSERT INTO mgv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kuhinakali kwinu, mwiitenda kulama. ");
INSERT INTO mgv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pamwagubona nndema guku Yelusalemu aguyongalwiti alonda bu pundema, ndienu mwiimanya kipindi sukuguhalabana musi we hogu kihegali. ");
INSERT INTO mgv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Papuje, bandu baabi ku Yudea bitilila kwi itombi, na baabi pikilanda ja musi biitilila kunza ja musi, na boti baabi ku matuhi biitili ku musi. ");
INSERT INTO mgv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ndaba masoba ge haga giibia masoba gukutemu, ili goa gaahandiki gatimia. ");
INSERT INTO mgv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Misibikiboni aka mbomba biniitumbu na bajongesa! Ndaba kwibia na manga'aliku makolongu ngani pundema na Sapanga jaatemula bandu bu pundema pani. ");
INSERT INTO mgv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bangi babu baakoma nimipanga, na bangi baajonza kuba apungwa nakapeleka kundema jengi. Na Musi uku Yelusalemu bagukanyata kanyata bandu banga Ayaudi, mbaka kipindi sabu esijomuka. ");
INSERT INTO mgv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ndienu kwibia na nginyuli mu lyoba, mu mwei na mu ndondu. Mu ndema kwibia na mang'aliku ndaba jukujogopa kukwihika kupete kulundamii ku nhanga na majeba gaki. ");
INSERT INTO mgv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bandu biitenda kuhinduka ndaba jikiholu, sukulendale majambu gagipitila mu nndema, ndaba hindu yu kunani kwaka Sapanga yiitenda kunyukanyuka. ");
INSERT INTO mgv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ndipala, mwaambona Mwana waka Mundu juhika jubii mu mahundi, kwa makili nu ulumbi nkolongu. ");
INSERT INTO mgv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Majambu ge haga egitumbulia kupiti, nzema nukutondabee imutu hii kulinga ndaba kipindi saka Sapanga sukungombo kupita mu mang'aliku ginu kihegali.” ");
INSERT INTO mgv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ndipala Yesu jaapwagila lilenganu lende, “Nndingalya nkongu wu ntini ni mikongu jengi joti. ");
INSERT INTO mgv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pammbona manyoi gatenda kutunduli, mmanya iyula jihegali. ");
INSERT INTO mgv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nanamu ahelahe, emwagabona majambu ge haga gakapitila, mmanya ukolongu waka Sapanga guhegali. ");
INSERT INTO mgv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Numpwagi sakaka, bandu bikibeleku senze ngabiwesi kuwa mbaka hindu yenze ipitila. ");
INSERT INTO mgv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mahundi nu nndema gwiitenda kupeta, lakini malobi gangu ngagiipeti tekateka. ");
INSERT INTO mgv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mbia miu! Myoju jinu mwiiutwa nukupala mali gingi, ulepi nukusumbuki yukutujangati kutama pundema pani ndaba lisoba leheli lihika sukujituki ngati itaba eijonza. ");
INSERT INTO mgv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ndaba lisoba leheli laahikila bandu baatama punndema pani gapula ngati ntegu. ");
INSERT INTO mgv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nkelukiya masoba goti, nndoba ili mpata makili kunhinakali haga goti pagiipitila ili nzema palongi jaka Mwana waka Mundu.” ");
INSERT INTO mgv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kila lisoba, Yesu jabiya jubola pa Nyumba jaka Sapanga, ni ikilu jabia jujenda mwi Kitombi si Mizeituni nu kutama koku. ");
INSERT INTO mgv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bandu boti babia ajumuka pulukela nukujenda pa Nyumba jaka Sapanga, kunzoane Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lisoba la kula mabumunda ganga kujege amila, lebijikema tipati ja Pasaka, labia lihegali. ");
INSERT INTO mgv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Agolu akolongu naka abola ba Malagalaki babia ataputa indela juku nkoma Yesu, lakini babiya baajogopa bandu. ");
INSERT INTO mgv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ndienu, Lijobi lunzingia Yuda jo bunkema Isikalioti, jumu ja atumi komi na abele. ");
INSERT INTO mgv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda jajenda kwa Agolu akolongu na alonda ba Nyumba jaka Sapanga, jalongila nabu namuna jukung'anambuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nabombi batogulya nuku jetakake kumpeke Yuda lupija. ");
INSERT INTO mgv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda jajetakiya na jatumbuliya kutaputa indela juku ng'anambuka Yesu kipindi sesabii nganu kumanya nsambi wa bandu. ");
INSERT INTO mgv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lisoba la mabumunda ganga kujege amila labiya lihikiki. Ndi labia lisoba lukusinza likondoo la tipati ja Pasaka. ");
INSERT INTO mgv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Henu Yesu jaatuma Petili na Yohana, nakaapwagi, “Nnzendaninya mkutuandaliya posu ja kula Pasaka.” ");
INSERT INTO mgv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nabombi bundalukiya, “Gupala tukuguandaliya kwako?” ");
INSERT INTO mgv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu jaapwagila, “Nnzowanya sukuhingamaki, pamwakajingila ku Musi, mwakaketangana na mwanalomi jumu jojutogwi nndundu wa masi. Mukumpwata mbaka mu nyumba mojijingala. ");
INSERT INTO mgv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mukumpwajila mwana nyumba jola, ‘Mbola julaluki, kibi kwa sumba sa ageni sukulele posu ja Pasaka pamwa na banafunzi bango?’ ");
INSERT INTO mgv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Najombi jwandangia sumba kikolongu sukunani, seapambiki sapi. Nanamu mkaandia posu je momu.” ");
INSERT INTO mgv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ndienu bajenda bukuketaniya kila sindu ngati Yesu ejabi jaapwaji, nabombi baandia posu ja Pasaka. ");
INSERT INTO mgv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lisaa elahika, Yesu jatama kula posu pamwa na atumi baki. ");
INSERT INTO mgv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jaapwagila, “Ndokuli ngamaa kula posu ja Pasaka nu mbanganya kabula juku ng'alika kwango! ");
INSERT INTO mgv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sakaka numpwagi, nganikuli kabee mbaki pajikamilika mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu ndienu jajukua nzipuli wa divai, ansengula Sapanga, nukupwaaga, “Nzoopa nzipuli gongo mmbagana mwaboa. ");
INSERT INTO mgv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Numpwagi, ngangunywi kabee divai ji Mizeituni jenze mbaka ukolongu waka Sapanga hegwiika.” ");
INSERT INTO mgv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ndipala jajukua libumunda, ansengula Sapanga, jasekula, jaapekia banafunzi baki nu kupwaga, “Jenze nhyega jango jejipita ndaba jinu mwanganya. Nhenga hela kungomboka nepani.” ");
INSERT INTO mgv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ahelahe ejajomula kula posu japakamii, jaapekiya nzipuli wa divai nu kupwaaga, “Gongo nzipuli gu lilaganu linyai laka Sapanga lelijemaliwi na mwai wango, gogujitika ndaba jinu mwanganya. ");
INSERT INTO mgv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lakini nndingalya! Mundu jojing'anumbuka nepani jubii pamu na nepani pamesa, pakula posu! ");
INSERT INTO mgv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sakaka Mwana waka Mundu jujenda kuwa ngati Sapanga ejapai, lakini musijikiboni mundu jojwiing'anumbuka nepani.” ");
INSERT INTO mgv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndipala batumbuliya kulaluana beni na beni, nya kati jabu jojihenga lihengu hele. ");
INSERT INTO mgv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Banafunzi baka Yesu batumbuliya kubisana nya jojuholaleka kuba nkolongu kati jabu. ");
INSERT INTO mgv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu jaapwagila, “Aka bambu akolongu ba bandu banga Ayaudi baalongo bandu kwa makili. Aka akolongu be haba bilikema ‘Akosi ba bandu.’ ");
INSERT INTO mgv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lakini kwinu mwanganya ngahela, lakini jojubii nkolongu kupeta mwaboti kati jinu, jubiya nsoku kupeta mwaboa, na kilongosi jubia ngati ntumisi. ");
INSERT INTO mgv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nya jojubii nkolongu, jojutami pamesa kula posu, au lee jojuhudumii jola? Lasima jojutama pamesa kula posu! Lakini, nepani mi pamba kati jinu ngati ntumisi. ");
INSERT INTO mgv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mwanganya ndi mwatemi pamu na nane mu milengu jango, ");
INSERT INTO mgv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ngati ahengo bangu ebamei kuba nu nkolongu nane numpeke ukolongu we hogu mwanganya. ");
INSERT INTO mgv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nhwesa kula na kunywa pamu na nane mu Ukolongu wangu, nuku tama mwiteu yu ubambu kulutemu lukolu komi na lubeli luku Izilaeli.” ");
INSERT INTO mgv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu japwaaga, “Simoni, Simoni! Joanya! Lijobi lipala kumpeta mwanganya ngati mundu ejupeta inganu. ");
INSERT INTO mgv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakini nugulobi kwaka Sapanga we hapa wa Simoni ili kunhobale kwaku kwiipongo, nanagu egwikelubuka wajangatiya ajaku anhobaliya nepani ngani.” ");
INSERT INTO mgv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petili ampwagila, “Bambu, nepani niijenda nawe pamu na weapa hata ku kipungu na hata kuwa.” ");
INSERT INTO mgv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ampwagila, “Petili nugupwagi lelenu, kabula ji likongobi kubeka, wingana mala patato.” ");
INSERT INTO mgv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ndipala Yesu jaalalukiya banafunzi baki, “Boo, panuntuma bila mpuku gu lupija wala nkoba wala makobasi, sumpungukii sindu sokape?” Bapwaga, “Ngahela ngase twapungukiwi sindo.” ");
INSERT INTO mgv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu japwaaga, “Lakini henu jojubii nu mpuku ulupija jujukua na jojubii nunkoba jujukua, na jokapi jwanga nu mpanga, julombisa likoti laki julomba upanga. ");
INSERT INTO mgv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndaba Maandiku ga Sapi gagapwaaga, ‘Bumbei likundi limu na bandu banamahakau gatimi.’ Numpwagi, haga goti bahandiki ndaba jangunepani giitenda kutimi.” ");
INSERT INTO mgv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Banafunzi bapwaga, “Bambu linga pamba tubii ni mipanga mibele.” Najombi japwaga, “Kutosiki kulongale mipanga!” ");
INSERT INTO mgv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu jajenda kwi Kitombi si Mizeituni ngati ejajoyobali, nabombi banafunzi baki bajenda pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pajahika hoku jaapwagila, “Mundoba Sapanga ili mwijingii mu milengu.” ");
INSERT INTO mgv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ndipala jaaleka, jajenda utali wa mundu kuwesa kuleke lilibu. Japega magoti nu kundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Japwaaga, “Atati, ana gupai guboa nzipuli hago guku ng'alika, lakini si ngati embala nenga ila ngati egupala wehapa.” ");
INSERT INTO mgv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Papuje atumi kuhuma kunani kwaka Sapanga ampitila nu kumpeke makili. ");
INSERT INTO mgv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu koni jubii mu usungu nkolongu ukujogopa kuwa, andoba ngamaa Sapanga, mbaka lumpita lyogate, lyogate laki labia ngati mandondu ga mwai gagahabuka pai. ");
INSERT INTO mgv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pajajomula kundoba Sapanga, jakelubuka kwa banafunzi baki jaakolila agoni ndaba babi nu usungu. ");
INSERT INTO mgv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jaapwajila, “Boo ndaba jakii ntei kugonela? Nzumuka mu ndoba Sapanga, ili mwijingi mwi milengu.” ");
INSERT INTO mgv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu pajabia jakoni jakalongela, nsambi wa bandu wahika koni julongo Yuda, jojabi jumu ja banafunzi baki komi na abele. Yuda anzendila Yesu nu kundamu suku kumbate. ");
INSERT INTO mgv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lakini Yesu andalukiya, “Yuda, boo, unng'anambuka Mwana waka Mundu suku kunkumbatila?” ");
INSERT INTO mgv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Banafunzi baki pabagabona haga gatenda kupiti bundalukiya, “Bambu, twaasekula lee ni mipanga jito?” ");
INSERT INTO mgv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na jumu kati jabu andapula mpanga ntumi waka nngolu nkolongu, nuku nseku likutu laki la kumalele. ");
INSERT INTO mgv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lakini Yesu japwaga, “Kotuka kutenda hela!” Jiligusa likutu laka mundu we hoju, nukulilamisa. ");
INSERT INTO mgv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ndipala Yesu jaapwagila agolu akolongu, aka kilongosi na alonda ba Nyumba jaka Sapanga na aseja bababia ahikiki kunkamuu, “Boo, ndaba jakii nhikiki ni mipanga ni ibonga kungamu ngati jojunyaga hindu? ");
INSERT INTO mgv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Masoba goti natami na mwanganya pa Nyumba jaka Sapanga, ngase mwangamwi. Lakini senze ndi kipindi sinu sukutawala palwiye.” ");
INSERT INTO mgv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ndienu bunkamula Yesu, bajenda naku ku nyumba jaka nngolu nkolongu, Petili jabia anzengalee Yesu munyuma su kutali. ");
INSERT INTO mgv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bandu bangi bakoa mwotu pikilanda ja hua nukutama na Petili jahika kunyata mwotu pamu nabu. ");
INSERT INTO mgv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mtumi jumu mmbomba ambona Petili jutami papu jakanyata mwotu, antupila mihu, nu kupwaga, “Mundu ajo najombi jabii pamu na Yesu.” ");
INSERT INTO mgv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lakini Petili jakana, nu kupwaga, “Mmbomba wee! Nepani ngasenikimanyi segulongela!” ");
INSERT INTO mgv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Monikatai, mundu jongi ambona Petili, najombi japwaaga, “Weapa na nanagu wa jumu kati jabu!” Lakini Petili japwaaga, “Bambo, nganenga.” ");
INSERT INTO mgv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ndipala lapeta lisaa limu, mundu jongi anhingamakiya nu kumpwaji, “Sakaka jonouju jwabii pamu na Yesu, ndaba na jombi mwenei juku Galilaya!” ");
INSERT INTO mgv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lakini Petili japwaga, “Wamundu wee ngase manyiki segupwaga!” Apalapa pajabii jakoni jakapwaga, likongobi latenda kubeka. ");
INSERT INTO mgv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bambu jang'anambuka nu kundingali Petili. Najombi Petili jakombuka malobi gajabia Bambu ampwagi, “Lelenu kabula ji likongobi kubeka, wingana mala patato wiipwaga ngasegumanyiki.” ");
INSERT INTO mgv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petili japita kunza nukulela ku usungu. ");
INSERT INTO mgv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bandu bababia anndonda Yesu, kundongama nukundapu. ");
INSERT INTO mgv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bunkongiki ingobu kumihu nu kundaluki, “Lotila, nya jojugulapwile?” ");
INSERT INTO mgv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndienu bapwaaga malobi gingi gukuntondoo. ");
INSERT INTO mgv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ekwakusa, aseja, aka akolongu na abola ba Malagalaki na agolu akolongu, baketangana pamu bumpelika Yesu pasengu jabu. ");
INSERT INTO mgv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bapwaaga, “Tupwagila! Boo, weapa lee wa Kilisitu Nkombose?” Lakini Yesu jaapwajila, “Hata nanumpwagi, mbanganya nganzetakele, ");
INSERT INTO mgv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","nanundaluki, ngammbwagile. ");
INSERT INTO mgv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lakini tumbuka sajeno nukuendalee, Mwana waka Mundu jiitama kuboku kwa malele kwaka Sapanga jwana makili.” ");
INSERT INTO mgv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ndipala boa bundalukya, “Boo, weapa ndi wa Mwana waka Sapanga?” Najombi japwaaga, “Mwanganya mpwaga nepani ndi jombi.” ");
INSERT INTO mgv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bapwaaga, “Boo, tupala lee mundu jongi julongilaje? Twee twabee tujoini sejupwaga kupete ndomu waki mwene.” ");
INSERT INTO mgv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndipala boka batenda kujema, nu kumpeleka Yesu kwaka Pilatu. ");
INSERT INTO mgv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Batumbuliya kuntakii koni bakapwaga, “Tunkoli mundu ajo jaahoa bandu biito kwa malobi gisoli. Jaakana bandu kulepa kodi kwaka nkolongu juku Loma, jupwaaga jombi ndi Kilisitu, Bambo nkolongu.” ");
INSERT INTO mgv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu andalukiya Yesu, “Boo, we lee Bambu Nkolongu wa Ayaude?” Yesu jajibua, “Ngati egupwagiki weapa.” ");
INSERT INTO mgv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ndienu Pilatu jaapwagila agolu akolongu nu nsambi wa bandu bala, “Ngase nilibweni likosa lokapi lejutei mundu jonzo.” ");
INSERT INTO mgv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lakini bombi bahingamaki ngamaa koni apwaaga, “Kupetea mabolee gaki jaakwelake bandu baabii ku ndema juku Yudea. Jatumbuliya ku Galilaya mbaka kongo.” ");
INSERT INTO mgv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu pajajogwa haga, andalukiya, “Boo, mundu hoju mwenei juku Galilaya?” ");
INSERT INTO mgv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilatu pajamanya Yesu jahumi mundema jejitawala Helodi, ampelika kwaka Helodi, jojabii ku Yelusalemu masoba gegala. ");
INSERT INTO mgv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helodi pa ambona Yesu, jatogulii ngamaa ndaba masoba gingi japala kumbona. Jabia jujoini majambu gaki na japala jubona ndonduke kuhuma kwaki. ");
INSERT INTO mgv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Helodi andalukiya Yesu malobi gingi lakini Yesu ngasejajibwiki sokapi. ");
INSERT INTO mgv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Agolu akolongu na aka abola ba Malagalaki bajemiki pala, bumpikia Yesu magambu gingi kwa makili ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helodi na alonda baki bunhengila Yesu liyaa nu kundongama. Bunhwatika ingobu ya sapi ngamaa ngati laka bambu nkolongu, nu kunkelabuu kwaka Pilatu. ");
INSERT INTO mgv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tumbuka lisoba le leli, Helodi jabia nkosi waka Pilatu, kabula ja masoba gu munyuma batenda kusukiana. ");
INSERT INTO mgv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ndienu, Pilatu jaakema pamu aka agolu akolongu, aka kilongosi na bandu, ");
INSERT INTO mgv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","jaapwagila, “Mundetiki mundu ajoo kwangu ngati jojaakonga bandu. Ne nundaluki palongi jinu, lakini ngasenilibweni likosa lokapi lemuntakali. ");
INSERT INTO mgv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Najombi Helodi ahelahe ankelabwi mundu jonzo kwitu, ndaba ngasejilibweni likosa lake. Henu mundu jonzo ngase jatei sokapi sesunhenga kuwa. ");
INSERT INTO mgv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Henu nagalaki mundapula iboku, ndi mundekakiya jujenda.” ");
INSERT INTO mgv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila lisoba la tipati ja Pasaka, Pilatu jwayobali kundekake mpungwa jumu. ");
INSERT INTO mgv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lakini bandu boti bajamaliya pamwa, “Gunkoma mundu hoju, utubopuliya Balaba!” ");
INSERT INTO mgv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba jabia mundu joankongiki mkipungu ndaba jukusababisa puju jejapiti kumusi nukukoma bandu. ");
INSERT INTO mgv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu japala kundekake Yesu, henu jalongila nabu kabee. ");
INSERT INTO mgv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lakini bombi bajamalya kwa sauti, “Mumbambaliya mu nsalaba! Mumbambaliya mu nsalaba!” ");
INSERT INTO mgv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatu jaapwagila kwa mala ja tatu, “Ndaba ja kike? Boo jutei likosa boo mundu we jone? Ngase nilibweni likosa lokapi leluntenda mbaka kunkoma. Henu nu ndapu iboku ya ndomondo nu kundekakela.” ");
INSERT INTO mgv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lakini bombi baendalya kujamali kwa sauti ngolongu ngamaa, bapala ambambaliya Yesu mu nsalaba. Kujamali kwabu buntenda Pilatu jujetakiya. ");
INSERT INTO mgv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ndienu Pilatu jaamua sebapala bandu bala kihengika. ");
INSERT INTO mgv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Andekakiya mundu jobumpala jola, jobummbei mukipungu jojwatei puju nukukoma bandu na kwaapeke Yesu bunhengila seapala. ");
INSERT INTO mgv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pababia bumpeleka, baketangana na mundu jumu jobunkema Simoni, mwenei juku Kilene, jojabia juhuma ku litui. Ndipala bunkamula, buntweka nsalaba we gola ili jutotula su munyuma jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nsambi nkolongu wa bandu unkagula Yesu, pamu na aka mbomba bababia alobalake nu kundele Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu jaang'anumbukiya na kwaapwaagi, “Mbanganya mwa aka mbomba buku Yelusalemu, mwinele nenga, ila nndela ndaba jinu mwabeti na bana bino. ");
INSERT INTO mgv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ndaba gahika masoba pabipwaga, ‘Nambanga banga akambonga banga kubeleka, banga kuwai kupata bana wala mabeli gangakujongesa bana!’ ");
INSERT INTO mgv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Masoba ge haga, bandu pa biitumbuka kiipwagi itombi, ‘Mtuhabukiya!’ Ni itombi isoku, ‘Mtuyelalya!’ ");
INSERT INTO mgv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ana bandu ahengiki hela ku nkongu mmbei, kwibia boo ku nkongu nzomu?” ");
INSERT INTO mgv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bandu bangi abeli bababii baahenga galiya baapeliki pamu na Yesu ili bakaabambaliya. ");
INSERT INTO mgv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pabahika pandu pabapakema, “Lihupa lu Umutu” Ndienu bummbambaliya Yesu pamu na bababi baahenga galiya abeli bala kila mundu nu nsalaba waki, jumu upandi waki wamalele na jongi upandi waki wamangega. ");
INSERT INTO mgv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu japwaga “Atati! Waalekakiya mahakahu gabu ndaba ngase amanyiki se ahenga.” Ndienu alonda bala bapega gudugudu ili kubagana ingobu yaki. ");
INSERT INTO mgv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bandu babia ajemiki pala buku ndingalya, na akakolongu ba Ayaudi babia bundongama Yesu bakapwaga, “Jaakombwi bandu bangi, henu julikombula mweni, ana jombi ndi Kilisitu Nkombosi jojuhaguliwi na Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ahelahe alonda batenda kundongama kabee, bunzendila nu kumpeke divai jejibabiki, ");
INSERT INTO mgv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nabombi bumpwagila, “Ana sakaka weapa Bambu Nkolongu wa Ayaudi, ulikombula wamwete!” ");
INSERT INTO mgv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Panani ju nsalaba waki babia ahandiki malobi ganga, “Jonzo ndi Bambu Nkolongu jwa Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jumu jojabii jojuhenga galiya babaambalii mu nsalaba antondula Yesu nu kupwaga, “Weapa le nga wi Kilisitu? Ulikombula wamweti na twe utumbula!” ");
INSERT INTO mgv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lakini jojuhenga giliyaa jongi jola andakaliya nzaki juliyaa jola nu kupwagi, “Boo weapa ngase gunzogopa Sapanga? Wehapa bukutemu ngati jombi. ");
INSERT INTO mgv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Weapa na nepani bututemwi ngati ekupalika, ndienu tujopiki malepu ga mahengu gitu, lakini mundu jonzo ngasejatei sindu siliya.” ");
INSERT INTO mgv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ndipala mundu jola ampwagila Yesu, “Waa Yesu, egwihika mu Ukolongu waku gwingombuka.” ");
INSERT INTO mgv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu japwaga, “Nugupwagi sakaka lelenu gwiibiya pamu nane pandu pa laha pabapakema Paladiso.” ");
INSERT INTO mgv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kwabiya saa sita lyoba mutu, lwahika lwii nndema gwooti mbaka saa tisa. ");
INSERT INTO mgv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ndipala, lipazia la Nyumba jaka Sapanga lajenduka hipandi ibele. ");
INSERT INTO mgv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu jajamaliya kwa sauti ngolongu, japwaaga, “Atati, Mwamaboku gaku nijibeka loho jango!” Ejapwaaga hela jwatendakuwa. ");
INSERT INTO mgv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nkolongu ja alonda miya moja juku Loma jola pajabona gagapiti, andumbaliya Sapanga nukupwaaga, “Sakaka mundu jonzo jabii jwaamboni.” ");
INSERT INTO mgv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bandu boka bababii ahikiki kulingali lijambu heli, pabagabona gagapiti, bajenda mwama nyumba gabu, koni abii nu usungu. ");
INSERT INTO mgv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lakini bandu boti babummanyiki Yesu bajeema su kutali ili bagabona majambu ge haga. Kati jabu babii aka mbomba babunzengali Yesu kuhuma ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jabii mundu jumu, lihina laki Josepu jojahumi ku Alimataya musi uku Yudea. Mundu we hoju jwabii jwa amboni na jabii juhenga majambu ga amboni na jabia julendale Ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hata ngati Alimatayo jabii jumu kati ja akolongu ba pasengu ja Ayaudi. Lakini ngasejajetaki sebahenga ajake, ");
INSERT INTO mgv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josepu jajenda kwaka Pilatu, kuloba nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Henu jahulua kuhuma pu nsalaba, jijiwatika sanda, jugubeka pilitenge lelabii ahembiki pi lilibu, lelule ngasebawaiki kuntaga mundu. ");
INSERT INTO mgv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lisoba lee heli labii lijumaa, lisoba le heli labi lisoba lukutumbuli Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aka mbomba bala bababii ampwatiki Yesu kuhuma ku Galilaya bumpwata Josepu, na bilibona litenge lela na ebabei nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ndipala babujaninya ku nyumba, baandia mahuta gaganungi sapi ili bijipakia nhyega jaka Yesu. Lisoba lu Kupomulela bapomulya ngati Malagalaki gaka Sapanga egapwaaga. ");
INSERT INTO mgv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lisoba la Jumapili pulukela ngani aka mbomba bajukua mahuta gaganungi sapi nu kujenda kulitenge. ");
INSERT INTO mgv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Biliketannya lilibu lukuyekale litenge lihilangaliti puukegi jilitengela. ");
INSERT INTO mgv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Henu pabajingala mwilitenge, ngasebijibweni nhyega jaka Bambu Yesu. ");
INSERT INTO mgv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bajema papu koni bakasangia lijambu leheli, apalapa bapitila bandu abeli aweti ingobu inhuu kwejakweja bajema pambipi nabombi. ");
INSERT INTO mgv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aka mbomba be haba bajogipi ngamaa, bajinama pai. Papuje bandu be bala baapwagila, “Ndaba jaki ki muntaputa jojubii mwomi kati ja bandu baawile? ");
INSERT INTO mgv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu ngasejubii pane, juyokiki. Nkombuka gajumpwagila pajabii ku ndema uku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana waka Mundu kwabia bunkamula bandu bana mahakau, nabombi bambambaliya pu nsalaba na mlisoba la tatu juyoka.’ ” ");
INSERT INTO mgv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ndienu aka mbomba bagakombuka malobi gaka Yesu gajwaapwagila, ");
INSERT INTO mgv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","pabakelubuka kuhuma kwi litenge, baapwagila majambu ge haga goti banafunzi komi na jumu pamu na bangi bala boti. ");
INSERT INTO mgv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aka mbomba babapwaaga majambu ge gala kwa banafunzi baka Yesu, babii Malia juku Magidala, Yoana na Malia amabu baka Yakobu pamu na bangi bajalongini naku. ");
INSERT INTO mgv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lakini banafunzi baka Yesu, pabajoana malobi ge gala, bagabona giking'ang'a henu ngasebahobalile. ");
INSERT INTO mgv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakini Petili jaboka nukujombateka imbelu mbaka kulitenge. Pajahika, jajinama nu kulingali nkati, papuje jijibona sanda pena. Ndienu jabuja ku nyumba koni jakasangia kupete gagapitii. ");
INSERT INTO mgv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lisoba alelale, banafunzi abeli baka Yesu babia ajenda kukijiji simu se bikikema Emau, utali waki kilumita komomi na moja kuhuma ku Yelusalemu, ");
INSERT INTO mgv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Babia alongalee haga goti gagapiti. ");
INSERT INTO mgv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pababia alongalane nuku pwaganii, Yesu mweni jatenda kwaapitii, nukujenda pamu nabombi. ");
INSERT INTO mgv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bummbona kwa mihu, lakini ngase bummanyiki. ");
INSERT INTO mgv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu jaalalukiya, “Mndongalane kyane koni nzendanela?” Nabombi bajeema nuu, na pamihu jabu pabonikana nu usungu. ");
INSERT INTO mgv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jumu kati jabu, jobunkemika Kileopa, andalukiya, “Boo, weapa ndi kajika jaku gu ngeni uku Yelusalemu, ngasegumanyiki majambu gagapiti mu masoba ga heno haga?” ");
INSERT INTO mgv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Najombi jaalalukya, “Majambu bole?” Bumpwagila, “Majambu gagumpata Yesu juku Nazaleti. Mundu we hoju jabii Mlota waka Sapanga junu makili gukubola nukuhenga mahengu gaki, palongi jaka Sapanga na palongi ja bandu boti. ");
INSERT INTO mgv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aka akolongu ba agolu na aka kilongosi bitu bumpelika kwa akolongu buku Loma ili antemumula kuwa, nabombi bummbambaliya pu nsalaba. ");
INSERT INTO mgv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lakini twepani twabia tunhobale jombi ndi jaagombula bandu buku Izilaeli. Nalelenu lisoba la tatu tumbuka majambu ge haga pagapitila. ");
INSERT INTO mgv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kabee, aka mbomba bangi ba kwitu batenda kutusangasa. Pulukela ngani bajenda kulitenge, ");
INSERT INTO mgv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lakini ngase bijiketanii nhyega jaka Yesu. Bakelubuka nu kupwaga, baapitii atumi bu kunani kwaka Sapanga, atumi be bapwaga Yesu jubii mwome. ");
INSERT INTO mgv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ndipala bandu bangi ajitu bajenda kulitenge, nabombi bukuketannya ngati ebapwaga aka mbomba bala, lakini ngase bumbweni Yesu.” ");
INSERT INTO mgv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ndipala Yesu jaapwagila, “Mbona mwaang'ang'a hela! Na mwanganya nhobale mbolimboli gabapwaaga alota baka Sapanga! ");
INSERT INTO mgv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Boo, ngasekwapalika Kilisitu jung'alika ngati hela, na moni katai jujingila mu ulumbi wake?” ");
INSERT INTO mgv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu jaayekulia hotuhotu majambu goti gagundangii jombi mu Maandiku ga Sapi, tumbuka mu itabu yejuandiki Musa na mu maandiku gaka alota boha baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nabombi pabahika pambipi ni kijiji sela sebabia bakajenda, Yesu jatenda ngati kupetana, ");
INSERT INTO mgv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","lakini bombi buhingamakiya ngamaa juhigaliya nabu, koni bakapwaga, “Tama pamba na twe, ndaba sajenu pakamihi na lwii lutenda kuhika.” Ndienu jajingala nkati nu kutama nabu. ");
INSERT INTO mgv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesu pajabii jutami nabu pamu na kula nabu posu, jajukua libumunda, ansengula Sapanga, jamega na kapeke ajaki. ");
INSERT INTO mgv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Apalapa mihu gabu gatenda kuogoka nabombi bumanya jombi, najombi jahoba ngase bumbona kabee. ");
INSERT INTO mgv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndipala, bapwaganiya, “Boo, mioju jito ngasejutujosiki pajabii jutupwagi mwiindela nu kutusimuli Maandiku ga sapi?” ");
INSERT INTO mgv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Babokaniya apalapa, bakelubuka ku Yelusalemu, kokuje baaketaniya banafunzi bala komi na jumu na bangi bababii pamwa nabu aketangini. ");
INSERT INTO mgv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bapwaga, “Sakaka Bambu juyokiki! Ampiti Simoni!” ");
INSERT INTO mgv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ndipala bandu abeli bala baapwagila ajabu gagapiti mwindela, na ebummanya Yesu pajamega libumunda. ");
INSERT INTO mgv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pababiya bakoni bakaalandila bangi, mweni Yesu jajema kati jabu, na kwaapwagi, “Lukwali lubiya kwinu.” ");
INSERT INTO mgv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bombi basitukaniya nu kujogopa ngamaa, baambusiya bilibweni lihoka. ");
INSERT INTO mgv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lakini Yesu jalalukiya, “Ndaba ja kii ntenda kuangajika? Ndaba jaki nng'alika mmoju jino? ");
INSERT INTO mgv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nndinga mabanga ga mmaboku na mabanga mmagolu gango ili nhobaliya anenganenga. Nhika nngamula ili mmbona, ndaba lihoka ngaselibii na nhyega wala mahupa ngati nepani.” ");
INSERT INTO mgv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesu pajapwaga hela, jalangia maboku na magolu gaki. ");
INSERT INTO mgv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pababiya bakona ngakuhobale ndaba juku togulela nu kusangaa ngani, Yesu jalalukiya, “Mmbii na posu jokapi panipane?” ");
INSERT INTO mgv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bumpekia kipandi sa homba seababali pamwotu. ");
INSERT INTO mgv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jwajukua na kula koni bandu boka bukumbona. ");
INSERT INTO mgv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ndienu jaapwagila, “Ganga ndi majambu ganumpwagila panabii namwanganya: Kwabia gatimia goti gabahandaki nepani gagabii mu Malagalaki gaka Musa na alota baka Sapanga na mu kitabu sa Zabuli.” ");
INSERT INTO mgv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ndipala, jaayekula malangu gabu ili amanya Maandiku ga Sapi. ");
INSERT INTO mgv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jwaapwagila, “Ahandiki ana, Kilisitu Nkombosi jing'aliswa nilisoba la tatu jwiitenda kuyoka. ");
INSERT INTO mgv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bandu boka tumbuka ku Yelusalemu nuku ndema yengi yoti lasima baalandila lijambu la asapi kupete lihina laki, ili alekakiya mahakau gabu, najombi Sapanga jaalekakiya mahakau gabu. ");
INSERT INTO mgv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mmbanganya mwaka banafunzi mpalika kwaapwagi bandu amanya goti gagambiti nepane gasakaka. ");
INSERT INTO mgv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nanamweti nandetila Loho jaka Sapanga jojwaalagila Atati bangu. Lakini mwanganya nndendaliya mbaki Sapanga ampekia makili kuhuma kunani.” ");
INSERT INTO mgv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ndienu jaalongua banafunzi baki kunza ja musi guku Yelusalemu mbaka ku Betania, najombi jatondabiya maboku gaki kunani, nakaapenge. ");
INSERT INTO mgv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pajabiya jaapenge, jaaleka, nukuyetuki kujenda kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bombi batenda kungungamali, ndipala bakelubuka ku Yelusalemu koni bakatoguliya ngamaa. ");
INSERT INTO mgv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Baendaliya kutama mu Nyumba jaka Sapanga koni bukundumbalya Sapanga.");
INSERT INTO mgv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pakwatumbuliya kwabiya ni Lilobi, ni lilobi heli labiya kwaka Sapanga nalombi ndi labiya Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Toka pu utumbuli jakabii pamu na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kupete jombi, Sapanga jabomba hindu yoti, wala nga sindu sokapi sesabombika sanga jombi. ");
INSERT INTO mgv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jombi ndi utumbulii gwa womi, na womi gola guletiki unang'anu kwa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Unang'anu gola gwanang'ana pa lwii, na lwii ngaselwawesiki kususua. ");
INSERT INTO mgv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Sapanga antuma mundu jumu, lihina laki Yohana. ");
INSERT INTO mgv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Hoju jahika kaapwagi bandu majambu gu unang'anu. Jahika ili bandu boka ajoana malobi gaki nu kunhobale. ");
INSERT INTO mgv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana we hoju ngasejabii unang'anu gola, lakini jahika pee kaapwagi bandu kupete unang'anu gola. ");
INSERT INTO mgv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gongo ndi unang'anu wa sakaka, goguhika pundema pani, kwaanang'anii bandu boka. ");
INSERT INTO mgv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndienu Lilobi jabii pundema nu kupete jombi, Sapanga jabomba nndema hogu, lakini bandu bupundema ngasebummanyiki. ");
INSERT INTO mgv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jahika kwa bandu baki, lakini bandu baki ngasebunzopike. ");
INSERT INTO mgv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakini boka babunzopa, ndi bala babuhobali, jaapekia uwesu gakuba bana baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bababi bana baka Sapanga nga ngati easaliwa bandu bangi, ngasebasaliwi ngati mundu ejupala ila ngati ejupala Sapanga, ila Sapanga mweni babii Atati babu. ");
INSERT INTO mgv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lilobi jwabiya mundu, jwatama pamu natwepani. Natwepani tugubona ukolongu waki, ulumbii waki jombi jojubii Mwana wakajika wa Atati a Sapanga, jutweli wamboni na sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana jaapwajila bandu majambu gaki, japwaga sukujamali, “Jonzo ndi jonapwaga majambu gaki panapwaga, ‘Juhika mundu jumu munyuma jangu nkolongu kupeta nepani, ndaba jabii kabula jukusaliwa nepani.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ngati ejubii jwaamboni ngamaa, natwepani kuhuma kwaki tujopiki mbenge hingi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ndaba Sapanga japia Malagalakilo kupete Musa, lakini umboni waka Sapanga na usakaka yahika kwii indela jaka Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nga mundu joambweni Sapanga. Lakini Mwana wa kajika, jojubii Sapanga jojupaliwi na Atati baki, jonioju ndi jojutupwagi majambu gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ganga ndi malobi gaka Yohana gajaapwagila aka kilongosi ba Ayaudi buku Yelusalemu pababi baatumiki kwaki agolu na Alawi ili bundalukiya, “Boo we wa nyanye?” ");
INSERT INTO mgv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana ngasejakaniki kujibu liswali lela, ila japwaga pee hotuhotu, “Nepani nga ni Kilisitu nkombosi?” ");
INSERT INTO mgv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ndienu bundalukiya, “Boo henu we wanyanye? Boo weapa lee wa Elia?” Yohana jajibua, “Nganenga!” Bundalukiya babe, “Boo Mlota waka Sapanga jola ndi lee weapa?” Yohana jajibua, “Nganenga!” ");
INSERT INTO mgv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Henu bupwagila, “Henu we wanyanye? Boo gupwaga bole kuhusu wamwete? Utupwagila ili tujenda takapwagila bala babututumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana japwaga, “Nepani ndi jojanongaliya Mlota Isaya pajapwaga, ‘Mundu jujamali pulukoba. Mujinyosa indela jaka Bambu.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Likundi laka Afalisayu ndi bababii baatumiki bandu haba, ");
INSERT INTO mgv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bundalukiya Yohana, “Ana we nga wa Kilisitu wala nga wa Elia, wala nga u Mlota, henu ndaba ja kii gutenda kabatisa bando?” ");
INSERT INTO mgv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana jajibua, “Nepani numbatisa kwa masi. Lakini pikilanda jinu jubii mundu mwanganya ngasemumanyike. ");
INSERT INTO mgv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jojuhika munyuma jangu hoju, nepani ngasembalika hata kukonga lunyusi lwii latu saki.” ");
INSERT INTO mgv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Majambu haga gahengika ku musi uku Betania kwii ja losi luku Yoludani, kojabii Yohana jwakabatisa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lisoba la pili Yohana ambona Yesu akuhikila, japwaga, “Linga lende ndi, Mwana Likondoo waka Sapanga, jojuijukua mahakau ga bandu bupundema! ");
INSERT INTO mgv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jonzo ndi jonalandila majambu gaki kupwaga, ‘Jwiihika mundu munyuma jango ndi jombi nkolongu kupeta nepani, ndaba jombi jabii kabula nepani ngasenzaliwi.’ ");
INSERT INTO mgv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nenamwete ngasenumanyiki, lakini nahika kabatisa bandu kwa masi ili bandu buku Izilaeli amanya.” ");
INSERT INTO mgv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana japwaga kabee gala gajagabona, “Nijimbweni Loho jaka Sapanga jakahuluka ngati ngunda kuhuma kunani kwaka Sapanga nukutama panani jaki. ");
INSERT INTO mgv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Wala nepani ngasenumanyiki, lakini jombi jojandumiki kubatisa bandu kwa masi, jombi jambwajila, ‘Mundu jowambona Loho jakahuluka nukutama panani jaki, hoju ndi jojubatisa kwa Loho jaka Sapanga.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana japwagaa, “Numbweni, kabee numpwaji jonujuwe ndi Mwana waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kilabu jaki Yohana jabii jujemiki papuje kabee pamu na banafunzi baki abeli, ");
INSERT INTO mgv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","eambona Yesu jakapeta japwaga, “Linga, lende ndi Mwana Likondoo laka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Banafunzi abeli bala bunzowini Yohana ejapwaga malobi gala, bajenda pamu na Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu ejang'alumbuka, jabona bukunzengaliya, jaapwagila, “Ntaputa kike?” Nabombi bunzibua, “Labi maana jaki Mbola, gutama kwako?” ");
INSERT INTO mgv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu jaapwajila, “Nhikaniya nanamu nndinga.” Banafunzi bala bajendaniya balinga pajutama, ndaba sabii saa komi pakamii, batama kwaki lisoba lela. ");
INSERT INTO mgv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andilea, mmbeli waka Simoni Petili, jakabii jumu ja abeli bala babunzowa Yohana jakapwaga ganga nukujenda na Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sindu sa kwanza sejahenga Andilea sabiya kuntaputa nndonguwaki joakema Simoni nukupwagi, “Tumbweni Masia.” Ndi kupwaga, “Kilisitu Nkombosi” ");
INSERT INTO mgv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndipala ampelika Simoni kwaka Yesu. Najombi Yesu andingaliya nukupwagi, “Weapa wa Simoni mwana waka Yohana, nawe bagukema wa Kefa.” Kefa kukigiliki Petili maana jaki “Lilibu.” ");
INSERT INTO mgv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kilabu jaki Yesu japala kujenda ku musi uku Galilaya. Najombi ambona Pilipi, Yesu apwagila, “Gumbwata nenga!” ");
INSERT INTO mgv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi jabii mundu juku Betisaida mwenei jwa musi kobabiya atama Andilea na Petili. ");
INSERT INTO mgv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ndipala Pilipi ataputa Nataneli, naeambona ampwagila, “Tumbweni mundu jola joahandiki Musa mukutabu sa Malagalaki, na alota baka Sapanga babahandiki majambu gaki, hoju ndi Yesu mwana waka Josepu, kuhuma ku musi uku Nazaleti.” ");
INSERT INTO mgv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataneli andalukiya Pilipi, “Boo sindu sa sapi kihuma ku Nazaleti?” Pilipi ampwagila, “Hika gulinga.” ");
INSERT INTO mgv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ndipala Yesu ambona Nataneli jakahika kwaki, jakalandila majambu gaki, “Linga hoju Mwizilaeli wa sakaka ngasejubii niisoli nkati jake!” ");
INSERT INTO mgv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataneli andalukiya, “Gumanyiki kwa bolee?” Yesu anzibua, “Kabula Pilipi ngasejugu kemiki, nugubweni pawabii pai ju nkongu wu ntini.” ");
INSERT INTO mgv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataneli ampwagila kabee, “Mbola, weapa wa Mwana waka Sapanga, weapa ndi wa Bambu nkolongu uku Izilaeli.” ");
INSERT INTO mgv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu jajibua, “Boo guhobali ndaba nugupwaji nugubweni pawabii pai junkongu gu nkoju? Wagabona majambu makolongu kupeta ganga.” ");
INSERT INTO mgv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu jajonzukiya kupwaji, “Numpwaji sakaka, mwakubona kunani kwaka Sapanga kwakahoguka na Atumi bu kunani kwaka Sapanga bakakwela nukuhuluka panani jaka Mwana waka Mundu.” ");
INSERT INTO mgv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lisoba la tatu kwabia nu kutogule ndoa ku Musi uku Kana, ku nkoa uku Galilaya. Amabaka Yesu nabombi babii, ");
INSERT INTO mgv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","najombi Yesu babii bunkokiki ku kutogule ndoa pamu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai ejajomuka, amabaka Yesu bumpwagila, “Ngaseabi na divai!” ");
INSERT INTO mgv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Lakini Yesu jaapwagila, “Mwiimbwagi sukuhenga. Lisaa la lakona ngaselihikike.” ");
INSERT INTO mgv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ndienu amabaka Yesu baapwagila atumisi, “Lokapi lejwaampwagila, mwihengaje.” ");
INSERT INTO mgv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Papuje jabii milundu sita jealenganaki kwa malibu, kila gumu gwawesa kutoto madebi gabeli au gatatu ga masi. Babia abei papu ndaba mihilu jeapwata Ayaudi ndaba jukulisapisa ili kundumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu jaapwagila atumisi, “Ntwelakiya milundu jenze masi.” Nabombi batwelakiya twee. ");
INSERT INTO mgv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ndienu Yesu jaapwagila, “Nteka henu masi haga mupelakiya nkolongu wa tipati ga ndoa.” Batenda ngati Yesu ejalagalakiya, ");
INSERT INTO mgv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nkolongu jola ejaonza masi gala kumbi gabiya gang'anambwiki kuba divai, nkolongu jola ngasejamanyiki pandu kojahuma divai, lakini atumisi babateka masi bamanyiki. Ndienu akema mwanalomi jojutola mbomba jola, ");
INSERT INTO mgv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ampwagila, “Kila mundu jutumbuli kupia divai jejinoi oti, na bandu naanywii nakanopi ndi apia jejinyolwi. Lakini wehapa gubei divai jejinoga mbaka sajenu!” ");
INSERT INTO mgv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu jahenga nginyuli ja kwanza ku Kana kunkoa uku Galilaya, jalangila ukolongu waki na banafunzi baki batenda kunhobale. ");
INSERT INTO mgv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Egapeta ganiaga, Yesu jahuluka pamu na amabu na alongu baki na banafunzi baki, nukujenda kumusi uku Kapelinaumu kokuje batemi masoba masokopi. ");
INSERT INTO mgv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lisoba likolongu lukutogule Pasaka ja Ayaudi lihegali, Yesu jakwela kujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jakolila bandu ku Nyumba jaka Sapanga bakalombisa ng'ombi na makondoo na ngunda na bangi abadilisa lupija koni atemi mmesa yabu. ");
INSERT INTO mgv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndipala japota lugoji kuba ngati kiboku na kwaabenga boka kuhuma mu Nyumba jaka Sapanga pamu na ng'ombi na makondoo gabu. Ndipala japendua mesa ya bandu babadilisa lupija nukujiti mangengalema ge pai, ");
INSERT INTO mgv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","jaapwajila bababia alombesa ngunda, “Mmboa hindu aye pamba. Mwajihenga nyumba ja Atati bangu kuba guliu!” ");
INSERT INTO mgv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Banafunzi baki bakombuka Maandiku ga Sapi gapwaga, “Mwaa Sapanga upali wangu gu nyumba jaku guindenda kundinyi ngati mwotu.” ");
INSERT INTO mgv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ndienu Ayaudi bangi bumpwajila, “Witenda nginyuli boo, kulangi gubii nu uwesu gukuhenga majambu ge haga?” ");
INSERT INTO mgv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu jajibua, “Mmbombula Nyumba jaka Sapanga jenze, nane najisenga kabee kwa masoba matato.” ");
INSERT INTO mgv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayaudi bumpwajila, “Nyumba jaka Sapanga jeze basenga kwa kipindi sa yaka alobaini na sita, nawehapa wisenga boo kwa masoba matatu?” ");
INSERT INTO mgv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakini Nyumba jaka Sapanga jejabiya julongale Yesu, jabiya nhyega jaki. ");
INSERT INTO mgv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yesu ejayoka, banafunzi baki bakombuka jabiya juwaiki kulongale lijambu le heli, ndienu bahobaliya Maandiku ga Sapi na malobi gajabiya jupwagiki Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu pajwabii ku Yelusalemu ku tipati ja Pasaka. Bandu bingi bahobalii pababona nginyuli yejabii juhengiki. ");
INSERT INTO mgv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakini Yesu ngasejaahobali bandu bala ndaba jaamanyiki boka. ");
INSERT INTO mgv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jombi ngasejapai mundu jokapi ampwagila majambu ga bandu bala ndaba jaamanyiki sapi gagabii nkati ja mioju jabu. ");
INSERT INTO mgv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jabii kilongosi jumu Nhyaudi joankemika Nikodemu, jojuhumiki mwikikundi sa Afalisayu. ");
INSERT INTO mgv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lisoba limu Nikodemu anzendila Yesu ikilu nu kumpwaji, “Mbola, tumanyiki wehapa ummbola jugutumiki Sapanga kutubola, ndaba nga mundu jojuwesa kuhenga nginyuli yeguhenga ila ana Sapanga jubii najombi.” ");
INSERT INTO mgv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu anzibua, “Nugupwagi sakaka, ana mundu ngasejusaliwi mala ja pili, ngajuwesi kugubona Ubambu ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu anndalukiya, “Mundu juwesa boo kubelekwa koni msejaa? Ngajiwesi kujingi mulutumbu ja amabaki nu kubelekwa kabee!” ");
INSERT INTO mgv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu ampwagila, “Nugupwagi sakaka, mundu na ngasejubelikwi kwa masi na Loho jaka Sapanga, ngajuwesi kujingi mu ubambu ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundu jubelekwa koni jubii na nhyega kuhuma kwa amabu baki na atati baki, lakini mundu jubelekwa loho kwa loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Guisangaa ndaba nugupwaagi kupalika kubelekwa mala ja pili. ");
INSERT INTO mgv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nhwahi gupoga pandu pagupala, nawenga gujowa kupoga kwaki, lakini ngasegumanyiki pandu paguhuma wala pagujenga. Ndi ekukuba kwa kila mundu ejibelekwa kwa Loho jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu andalukiya Yesu, “Malobi ge haga gawesikana bole?” ");
INSERT INTO mgv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ampwagila, “Wehapa wogubii gu mbola nkolongu uku Izilaeli, ngasegumanyiki majambu haga? ");
INSERT INTO mgv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nugupwaji sakaka, twepani tupwaaga gatugamanyi nu tupwaga gatagabweni, lakini mwabangi ngasempai kujetake malobi gitu. ");
INSERT INTO mgv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ana malobi gupundema pani numpwagi ngasenhobali, mwihobale boo ananupwagi majambu gu kunani kwaka Sapanga? ");
INSERT INTO mgv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ngasejubii mundu jojuwahiki kujenda kunani kwaka Sapanga, ila pee Mwana waka Mundu jojahuluka kuhuma kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngati Musa ejilitondabiya lijoka la shaba lela panani ja ndonga kulukoba, ndi ahelahela Mwana waka Mundu ebuntondabiya kunani, ");
INSERT INTO mgv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili kila mundu joanhobale jubiya na womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ndaba Sapanga jaapai ngamaa bandu bupundema hata jaamua kumpia Mwana waki wakanzika, ili kila mundu joanhobaale ngajikuwe ila jubiya na womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ndaba Sapanga ngaseantumiki Mwana waki puundema ili jutemula bandu bupundema, ila jaakombula. ");
INSERT INTO mgv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Joanhobale Mwana waka Sapanga ngasejuhukumiwa, lakini jwanga kunhobale tayali buntemwi, ndaba ngaseahobali Mwana wakanzika waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kutemu je ndi kongo, unang'anu guhikiki pundema, lakini bandu bulupala lwii kuliku unang'anu, ndaba ahenga mahakau. ");
INSERT INTO mgv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mundu jojuhenga mahakau jugusuki unang'anu, najombi jukana kuhika ku unang'anu ili mahengu gaki giibonikana. ");
INSERT INTO mgv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakini bahenga ga sakaka ahika pu unang'anu ili mahengu gabu gabonikana ahengiki sukunzoane Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ebajomula ganiaga Yesu na banafunzi baki bajenda ku nkoa uku Yudea, batama nabu kola kipindi kisokopi, koni jakabatisa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana jabiya jakabatisa ku Ainoni, pambipi nuku Salimu, ndaba kola gakabii masi gingi. Bandu bunzendila najombi nakabatisa. ");
INSERT INTO mgv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ganiaga gapitila kabula Yohana ngaseanzegi mukipungu. ");
INSERT INTO mgv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gwapitila ubisi kati ja banafunzi bangi baka Yohana nu nhyuda jumu kuhusu mihilu jeakamulaki Ayaudi jukusamba masi mumaboku na mumagolu asapisika ndaba jukundumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndienu anzendila Yohana nukumpwajila, “Mbola, gunkomboka mundu jola jojabii pamu nawe kwii juku losi luku Yoludani, jowabii gulonge naku jola, henu najombi jutenda kubatisa, na bandu boka atenda kunzende.” ");
INSERT INTO mgv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana ampwagila, “Mundu ngasejuwesa kuba na sindu ana Sapanga ngaseampeki. ");
INSERT INTO mgv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwabe mmanyiki panapwaga, ‘Nepani nga na Kilisitu Nkombose, lakini andumiki ili nundonguliyaje.’ ");
INSERT INTO mgv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mmbomba jobuntola ndi waka bambu jojutola, lakini nkosi waka bambu jojutola jujema pambipi nukunzowane, jutogule ngamaa paanzowane sauti jaka bambu jojutola mmbomba. Ndienu kutogule kwangu ekutimii. ");
INSERT INTO mgv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesu jupalika kuba nkolongu ngani nane miya nsokopi.” ");
INSERT INTO mgv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jojuhuma kunani kwaka Sapanga ndi nkolongu kupeta boka. Jojuhuma pundema ndi jupundema, na julongale malobi gupundema. Lakini jojuhuma kunani kwaka Sapanga ndi julongosa gooka. ");
INSERT INTO mgv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jombi julongale gajagabweni nakaga jowa, lakini nga mundu jojujetake gajagalongale. ");
INSERT INTO mgv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jokapi jojujetake kulongale kwaki jujetake Sapanga ndi sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Joantumiki Sapanga jupwaga malobi gaka Sapanga ndaba antwelake Loho jaki kupeta kipemo. ");
INSERT INTO mgv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Atati bumpahi Mwana, najombi ampeki hindu yoti mwamaboku gaki. ");
INSERT INTO mgv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Joanhobale Mwana jubii na womi wa masoba goka, jwanga kunhobale Mwana ngajukubi na womi ila Sapanga anhyomila ngamaa masoba goti. ");
INSERT INTO mgv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afalisayu bajowana Yesu jupata banafunzi bingi nukubatisa kupeta Yohana. ");
INSERT INTO mgv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lakini Yesu wee ngasejabatisi mundu ila banafunzi baki ndi bababiya bakabatisa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ndienu Yesu pajajowa haga jaboka ku Yudea nukukelubuki ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ejwabiya mwiindela kujenda ku Galilaya kwapalika jupetila ku Samalia. ");
INSERT INTO mgv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jahika ku Sikali musi gumu gogubii ku Samalia, pambipi nilituhi laka Yakobo leampeki mwana waki, joakema Josepu. ");
INSERT INTO mgv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Papuje sakabii kiliba saka Yakobu, Yesu jaatama pulutengu jikiliba, ndaba jabii jusokiki nukujenda. Papuje sabiya kiegali saa sita liyoba mutu. ");
INSERT INTO mgv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ndienu jahika mbomba jumu Nsamalia kuteka masi na Yesu ampwagila, “Nagumbeke masi ngunywi.” ");
INSERT INTO mgv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kipindi se sela banafunzi baki bapiti ku musi kulomba kilebi. ");
INSERT INTO mgv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Lakini mmbomba Nsamalia ampwagila Yesu, “Kubii bole weapa u Yaudi kunoba ne masi kipindi ne nu Msamalia?” Ndaba Ayaudi ngaseajongana na Asamalia. ");
INSERT INTO mgv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu ampwagila, “Ana wakamanyiki hindu yejupia Sapanga, kabee na ukummanyiki jojuguloba masi ga kunywa hoju, weapa ndi ukundoba, najombi jukugupekia masi gagaleta womi.” ");
INSERT INTO mgv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mmbomba jola ampwagila, “Bambu, weapa ngasegubi na sindu sukuteke masi ni kiliba se seno kilasu ngamaa. Henu gwipata kwaa, masi ga womi? ");
INSERT INTO mgv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wele ulibona gu nkolongu kupeta atati bitu Ayakobo? Jombi jutupekia twepani kiliba senze, mweni na bana baki ni mipugu jaki bakunywa masi jikiliba senze?” ");
INSERT INTO mgv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ampwagila. “Kila mundu jojukunywa masi ganga ngajilijowane nywita kabee, ");
INSERT INTO mgv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lakini jokapi jojikunywa masi ganampekia nepani ngajunkamwi nywita masoba goha. Masi ganumpekia gibiya nkati jaki ngati kiliba sa masi ga womi gajapekia womi wa masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mmbomba jola ampwagila, “Bambo, gumbekia masi haga ili niibona nywita kabee, nihika kabee pamba kuteka masi.” ");
INSERT INTO mgv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu ampwagila, “Jenda kunkema nndomi waku, guhika naku pamba.” ");
INSERT INTO mgv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mmbomba jola ampwagila, “Nepani ngase mii na mwanalome.” Yesu ampwagila, “Gupwajiki sakaka ngasegubii na mwanalome. ");
INSERT INTO mgv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ndaba wabii nakanalomi anhwano, na mwanalomi jogutama naku sajenu nga wako. Henu gupwajiki sakaka.” ");
INSERT INTO mgv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mmbomba jola japwaga, “Bambo, nee mona weapa umlota waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Aka hoku bitu bundumbaliya Sapanga kukitombi senze, lakini mwa Ayaudi mwee mpwaga ku Yelusalemu ndi pandu papalika kungungamali Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu ampwagila, “Amabo, guhobalya senumpwagi, gihika masoba ngamwalumbali Atati kukitombi ase, wala ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwasamalia mwanganya munzinamii sapanga jwanga kummanya, lakini twepani tumanyiki jotunzinamii, ndaba ukombosi guhuma kwa Ayahude. ");
INSERT INTO mgv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakini sihika kipindi, kabee tayali kihiki, kipindi se hesi bandu balumbali sakaka balumbaliya Atati sukulongoswa kwa Loho jaka Sapanga na sakaka. Ndaba Atati apala bandu babundumbali kwii ndela heji. ");
INSERT INTO mgv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sapanga ndi Loho, nabombi babunzinamii kupalika kunzinamii kwa Loho jaka Sapanga na sakaka.” ");
INSERT INTO mgv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mbomba jola ampwagila, “Numanyiki Masia jobukema Kilisitu Nkombosi, jutenda kuhika, nikipindi sejihika jutupwajila kila sindu.” ");
INSERT INTO mgv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu ampwagila, “Nepani nenonge nawe, ndi Masiya.” ");
INSERT INTO mgv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Muda agolagola banafunzi baka Yesu batenda kuhika, nabombi basangii kumbona jakalongila numbomba. Lakini nga jumu kati ja banafunzi bala joandalukiya mmbomba jola, “Gupala kike?” Wala nga jumu joandalukiya Yesu, “Ndabaja kii gulonge nu mmbomba ajojo?” ");
INSERT INTO mgv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ndienu mmbomba jola juguleka nndundu waki wa masi, jajenda ku musi, kalandi bandu, ");
INSERT INTO mgv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Uhikaniya mumbona mundu jojumpwaji majambu goka gahengiki. Boo kuwesikana jonzo ndi wa Kilisituje?” ");
INSERT INTO mgv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndipala bandu bapita mmusi gola nukunzende Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kipindi se sela banafunzi baki bundoba Yesu bakapwaga, “Mbola, kulaa kilebi!” ");
INSERT INTO mgv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lakini jaapwagila, “Nepani mii ni kilebi sangakukimanya mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ndipala banafunzi batumbuliya kulaluana, “Boo jubii mundu joandeti kilebe?” ");
INSERT INTO mgv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu jaapwagila, “Kilebi sangu nenga ndi kuhenga sejupala jola jojundumiki nukujomo lihengu laki. ");
INSERT INTO mgv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mmbanganya uyobali kupwaga, ‘Jihigali miehi nsese pee kuhika masoba gukuhusa.’ Lakini nenupwagi, nndingaliya mwagabona matuhi egabii tayali kuhusa! ");
INSERT INTO mgv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jojuhusa jukuba jujopiki nsalaha najombi jukusanya ilebi kwa ajili ja womi wa masoba goha, ndi jojupanda na jojuhusa bitoguliya pamu. ");
INSERT INTO mgv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa ndaba heji malobi ganga ga sakaka, ‘Mundu jumu jutenda kupanda na jongi jutenda kuhusa apwaga sakaka.’ ");
INSERT INTO mgv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nepani nutumiki mwanganya kutuhi kuhusa ilebi yeyuye mwanganya ngasemwapandike, bangi bahengiki lihengu lukupanda lakini mwanganya uhusa ilebi yeapandiki bangi.” ");
INSERT INTO mgv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Asamalia bingi ba musi gola buhobali Yesu ndaba ja malobi gajapwaga mmbomba jola, “Jambwajila majambu goka ganabii nagahengiki.” ");
INSERT INTO mgv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ndipala Asamalia pabuhikila Yesu, bundoba jutama nabu pamu, najombi jatama kola masoba mabele. ");
INSERT INTO mgv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bandu bingi ngamaa buhobali Yesu ndaba ja malobi gaka mmbomba jola. ");
INSERT INTO mgv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bandu be haba bumpwajila mmbomba jola, “Henu tuhobali ila nga ndaba ja malobi gaku pena, ndaba twepani twabeti kabee tumanyiki sakaka jonzo ndi Nkombosi jupundema poti.” ");
INSERT INTO mgv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagapeta masoba mabeli, Yesu jaboka kola jajenda ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ndaba mweni Yesu japwaga bila kuhiya, “Mlota ngasejujetakeka mmusi waki mwene.” ");
INSERT INTO mgv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ndienu pajwahika ku Galilaya benei bunzopiki, ndaba bagabweni majambu goha gajahenga Yesu ku Yelusalemu kwa tipati ja Pasaka. ");
INSERT INTO mgv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ndienu Yesu jakelubuka kabee ku musi uku Kana gogubii ku Galilaya, pandu pajang'alumbua masi kuba divai. Kola jwabii kilongosi jwakabii na mwana nngonzu musi uku Kapelinaumu. ");
INSERT INTO mgv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kilongosi jola ejwajowana Yesu juhikiki ku Galilaya kuhuma ku Yudea, anzendila Yesu ahingamakiya jujenda akundamisa mwana waki jojabii lahilahi. ");
INSERT INTO mgv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ampwagila, “Ana ngasembweni nginyuli na ndonduke ngauhobalele Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kilongosi jola ampwagila, “Bambo, nuguloba guhika kwangu kabula mwanawango ngasejuwile.” ");
INSERT INTO mgv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu ampwagila, “Jenda pena mwana waku julamike!” Mundu jola jaamua kuhobale lilobi laka Yesu lejwapwaga najombi jaamua kubuja. ");
INSERT INTO mgv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pajwabii mwindela jaketangana na atumisi baki bumpwajila, “Mwanawaku we mwomi!” ");
INSERT INTO mgv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jombi jalalukiya saa kike mwana wa pajatumbuliya kuba sapi, nabombi bumpwagila, “Jombi jalama saa saba lioba mutu.” ");
INSERT INTO mgv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ndienu atati bala bakombuka muda ngati agolagola Yesu pabumpwajila, “Mwana waku julamike.” Ndipala jombi na akakosi baki buhobaliya Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Heji ndi nginyuli jukusangasa ja pili jejahenga Yesu pajabiya juhuma ku Yudea jujenda ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagapeta haga Yesu jajenda ku Yelusalemu ku tipati gangi ga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ku Yelusalemu kola, pambipi nu litanga lu kujingali pa musi gobugukema litanga lilikondoo labiya litanda likolongu la masi lebikikema kiebulania Betizata, litanda heli labiya ni indamba unhwano yunu ugolu. ");
INSERT INTO mgv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mwindamba ye mola batemi agonzu bingi, babi bangalinga na akilema na balei. ");
INSERT INTO mgv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Boti babiya alendale masi gatimbulikana ndaba kila mala mtumi juku nani kwaka Sapanga jwahika kutimbu masi mlitanda. Mundu jokapi jojabi jwa kwanza kujingi mlitanda baada juntumi waka Sapanga kugatimbu masi, julamika ugonzu wokapi gojubinaku. ");
INSERT INTO mgv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Papuje jabii mundu jumu jojabii julehi muda wa yaka selasini na nane. ");
INSERT INTO mgv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu paambona nngonzu jola jugoni pala jamanyiki mundu jola jabii nngonzu jwa muda wa masoba gingi andalukiya, “Gupala lee kulama?” ");
INSERT INTO mgv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nngonzu jola ampwagila, “Bambu, nandi ngasemi na mundu jukunyingi mmasi kipindi masi egakuba agatimbwilini, kila enenga kujingi mundu jongi jundenda kunongule.” ");
INSERT INTO mgv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu apwagila, “Jema ulitweka kipega saku gujenda.” ");
INSERT INTO mgv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Apalapa mundu jola jatenda kulama, jajukua, kipega saki nukutumbuli kujenda. Lisoba le lela labiya Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ndi Ayaudi bangi bumpwagila mundu jojulamiki we jola, “Lelenu Lisoba lu Kupomulela Malagi gi mihilu jitu ngasegutupala kutoto kipega.” ");
INSERT INTO mgv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lakini jombi jaapwagila, “Mundu jola jojunamisi ndi jojumbwajila, ‘Jukua kipega saku gujenda.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nabombi bundalukiya, “Mundu jojugupwaji, jukua kipega saku gujenda, jonujuwe nyanye?” ");
INSERT INTO mgv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lakini jombi ngaseamanyiki mundu joandamisi ndi nyaa, ndaba Yesu jabii tayali juboi, ndaba papuje wabii nsambi wa bandu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ndienu monikatae, Yesu ankolila mundu we jola mu Nyumba jaka Sapanga apwagila, “Henu gulamiki, guihenga mahakau kabee, guipata lijambu likolongu ngani.” ");
INSERT INTO mgv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu jola jajenda nakapwaji aka kilongosi ba Ayaudi Yesu ndi jojunamisi. ");
INSERT INTO mgv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndaba Yesu jahengiki lijambu lela Lisoba lu Kupomulela, Ayaudi batumbuliya kusumbuu. ");
INSERT INTO mgv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ndienu Yesu jaapwagila, “Atati bangu ahenga lihengu masoba goti, nane henga ahelahela.” ");
INSERT INTO mgv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndaba ja malobi haga, akikilongosi ba Ayaudi bataputa indela jukunkoma Yesu, nga ndaba jukuhalabana Malagi gi Lisoba lu Kupomulela pee, ila kabee ndaba japwaga Sapanga ndi Atati baki, nukulibona julengini na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu jaapwagila, “Nupwaji sakaka, Mwana ngasejuwesa kuhenga sindu kajika jaki juwesa pee kuhenga sindu sejaabona Atati bakahenga. Ndaba seahenga Atati Mwana najombi juhenga aselasela. ");
INSERT INTO mgv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Atati bupala Mwana, nukundangi kila sindu sejuhenga mweni, kabee bundangia majambu makolongu kupeta haga, nanamu mwitenda kusangaa. ");
INSERT INTO mgv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngati Atati ejaayoha bandu bawii nakapeke womi, ahelahe na Mwana japeke womi bandu bajapai. ");
INSERT INTO mgv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Atati ngaseantemu mundu jokapi lakini ampeki Mwana uwesu woka gukutemu bandu, ");
INSERT INTO mgv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili bandu boka babunzoane Mwana ngati ebajoane Atati. Janga kunzoane Mwana ngasejajoane Atati babuntumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Numpwaji sakaka, jojujoane lilobi langu nukuhobale jojundumiki, jubii na womi wa masoba goha. Jombi ngajwiitemuliwe, ila julobwiki kuhuma ku kuwa nukujingi kuwomi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nupwaji sakaka, kihika kipindi kabee kihikiki tayali bandu ba wii bijowana malobi gaka Mwana waka Sapanga, na bandu babijowana biibiya bomi. ");
INSERT INTO mgv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngati Atati ebi utumbuli wa womi, ndi ahelahela ampeki Mwana uwesu ukupia womi kwa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kabee ampeki Mwana uwesu ukutemu, ndaba jombi ndi Mwana waka Mundu. ");
INSERT INTO mgv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wisangaa ndaba ja malobi ganga, ndaba kihika kipindi bandu boka babii kutenge bijowana malobi gaki, ");
INSERT INTO mgv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nabombi bitenda kuyoka. Baahengiki ga amboni bitenda kuyoka nukupata womi, lakini baahengiki giliya bitenda kuyoka nukutemuliwa.” ");
INSERT INTO mgv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nepani ngasenhwesa kuhenga sindu ku uwesu wangu na mwete. Nepani ndemu ngati enyowana kutemu kwa Atati, nu kutemu kwangu kwa sakaka. Ndaba nga kukupala namweti ila kukupala kwa jola jojundumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nanililongali namweti malobi gangu ngagiwesi kujetakeka kuba ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lakini jubi jongi jojupia malobi gango, nane manyiki goka gajunongale nepani ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwanganya mwaatuma bandu kwaka Yohana Mmbatisa, najombi jalongila sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nepani ngasenhobale malobi gala gaapwaga bandu, ila mbwaga malobi ganga ili mpata kuokolewa. ");
INSERT INTO mgv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana jabii ngati taa jejabi jinyaka nukumulika, nanamu mwabi mwasagula kutogule unang'anu we hogu kwa masoba masokopi. ");
INSERT INTO mgv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Lakini malobi gaganongale nepani gabi nuukolongu ngamaa kupeta gaka Yohana. Ndaba mahengu ganihenga ndi mahengu gambeki Atati nagajomula, galangi Atati ndi bandumiki. ");
INSERT INTO mgv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Atati baandumiki ndi jojaapwagi bandu majambu gangu. Kyee mwanganya ngasenzoini sauti jaki kwa makutu ginu wala kummbona ejubii, ");
INSERT INTO mgv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","wala lilobi laki ngaselitama nkati jinu, ndaba ngase munhobali jola joantumike. ");
INSERT INTO mgv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwanganya nsoma ngamaa Maandiku ga Sapi uwasali nkati jaki mwipata womi wa masoba goha. Lakini mahandiku ge gaga ganongale nepani! ");
INSERT INTO mgv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lakini mwanganya ngasempai kuhika kwangu nepani ili mpata womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nepani ngasendaputa bandu buku numbalila. ");
INSERT INTO mgv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lakini numanyiki mwanganya ngasemmbii nu upali waka Sapanga nkati jinu. ");
INSERT INTO mgv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nepani hikiki kuuwesu Atati bango, lakini ngasennyopa. Ila mundu jongi najuhikiki kupete uwesu wakimweni mwitenda kunzopa. ");
INSERT INTO mgv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Henu nhwesa boo kunhobale kipindi mwanganya mpala kujopa ulumbi kuhuma kwinu mwabeti, lakini ngasentaputa ulumbi kuhuma kwaka Sapanga jojubii kajika? ");
INSERT INTO mgv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mwiwasali nepani ndi nenantakila kwa Atati. Musa jomuhobali ndi jojuntakila mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ana sakaka munhobali Musa, mwakahobaliya nane, Ndaba Musa jaandika majambu gango. ");
INSERT INTO mgv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lakini ngasemwagahobale ga juandiki, boo mwiwesa boo kuhobalee malobi gango?” ");
INSERT INTO mgv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ndienu Yesu jajenda kwii ju nhanga uku Galilaya gobugukema Tibelia. ");
INSERT INTO mgv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nsambi nkolongu wa bandu watenda kumpwata, ndaba bigibweni nginyuli jejabii juhengi kalamisa agonzu. ");
INSERT INTO mgv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu jakwela kukitombi jatama pai pamu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kipindi sa tipati ja Pasaka ja Ayaudi jabiya jiegali. ");
INSERT INTO mgv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu ejalinga jugubona nsambi wa bandu gukuhikila, andalukiya Pilipi, “Tukalomba kilebi kwako ili tuwesa kapeke bandu ababa?” ");
INSERT INTO mgv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Japwaga sanahuli ili kundenga Pilipi, ndaba jombi mweni jamanyiki semusijuhenga. ");
INSERT INTO mgv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipi apwagila, “Hata tulombi mabumunda kwi ipandi mia mbili ja feza ngagatosi, kila jumu mwisijupata kidogu pena.” ");
INSERT INTO mgv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mbolee waki jumu joakema Andilea, ndongu waka Simoni Petili, ampwagila, ");
INSERT INTO mgv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Jubii pamba mwana jumu jubii na mabumunda ga shaili uhwanu na homba ibeli. Lakini yeniye ngaseitosa kwa bandu boka haba.” ");
INSERT INTO mgv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu japwaaga, “Mwatamika pai bandu haba.” Napandu jepala pakabi na manyonyoli gingi. Ndipala bandu babatamiki bakabii akanalomi elupu uhwano. ");
INSERT INTO mgv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu jajukua mabumunda gala, ansengula Sapanga, nakapeke banafunzi baki abaga kwa bandu babatemi pala. Najahenga ahelahe kwa homba yela, kila mundu japata ngati ejapala. ");
INSERT INTO mgv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bandu pabatupila, Yesu jaapwagila banafunzi baki, “Nkusanya hipandi yeihigali hiiyooba.” ");
INSERT INTO mgv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ndipala bakusanya hipandi ya mabumunda ga shaili yebahigaki, nukutwelake hitonga komi ni ibeli. ");
INSERT INTO mgv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bandu ebabona nginyuli yaka Yesu ejalangia, bapwaga, “Sakaka mundu jonzo ndi mlota jola jojuhika pani puundema!” ");
INSERT INTO mgv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu pajamanya bandu bapala kunzuku ili kumbeka jubiya bambu nkolongu, jaboka kabee kajika jaki kujenda ku kitombi. ");
INSERT INTO mgv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pakwabiya pakamii banafunzi baka Yesu bahuluka kujenda kunhanga, ");
INSERT INTO mgv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bakwela munhwatu ili alombuka nhanga kujenda ku Kapelinaumu. Lwii lwabiya lujingi na Yesu jabiya ngasejahiki bombi. ");
INSERT INTO mgv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Apalapa kimbonga satumbuliya kupoga nuku ukologa nhanga. ");
INSERT INTO mgv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pabahika ulasu wa kilumita nhwanu au sita bumbona Yesu jakajenda panani ja masi, jakaegaliya punhwatu, henu batenda kujogopa ngamaa. ");
INSERT INTO mgv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lakini Yesu jaapwagila, “Nepane, mwijogopa!” ");
INSERT INTO mgv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bunkalibisa jujingala nkati ju nhwatu, apalapa nhwatu wahika pulutengu jundema kobaabiya apala kujenda. ");
INSERT INTO mgv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kilabu jaki nsambi wa bandu gogwahigali upandi gongi gu unhanga bamanya gwabii nhwatu gumwa pee, kabee Yesu ngasejajingala munwatu gola pamu na banafunzi baki, ila banafunzi baki bajenda kajika jabu. ");
INSERT INTO mgv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ndienu jahika minhwatu jengi kuhuma ku Tibelia mbaki pambipi na pandu pala pababiya akula mabumunda, kipindi Yesu pajabiya ansengwi Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ndienu nsambi wa bandu pabamanya Yesu na banafunzi baki ngaseabi pala, bajingala minhwatu kujenda ku Kapelinaumu kuntaputa Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bandu bala bunkolila Yesu kwii ju nhanga, bundalukiya, “Mbola, gwahika pamba kipindi bole?” ");
INSERT INTO mgv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu japwaga, “Numpwaji sakaka, mwanganya ndaputa nga ndaba mwabweni nginyuli, ila ndaba mwalii mabumunda gala nukutupi. ");
INSERT INTO mgv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mwakihenge lihengu kilebi sekibohi, lakini mukihengila lihengu kilebi sekitama masoba goha ndaba ja womi wa masoba goha. Jenze ndi posu jejuje Mwana waka Mundu jitenda kumpeke, ndaba Sapanga, Atati jutei kunhagu.” ");
INSERT INTO mgv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ndipala bandu bundalukiya, “Tuhenga kike ili tupata kuhenga mahengu gajupala Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu japwaga, “Lende ndi lihengu lejupala Sapanga nhenga, kunhobe joantumike.” ");
INSERT INTO mgv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ndienu bundalukiya, “Wiihenga nginyuli boo ili tubona tuwesa kuguhobalela? Gwihenga sindu bole? ");
INSERT INTO mgv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aka hoku bitu bakula posu jebijikema mana kulukoba, ngati ebaandiki mu Maandiku ga Sapi gagapwaga, ‘Jaalea mabumunda kuhuma kunani kwaka Sapanga.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu jaapwagila, “Numpwaji sakaka, Musa ngasejumpeki mwanganya libumunda lelihuma kunani kwaka Sapanga. Lakini Atati bangu bumpeke libumunda la sakaka kuhuma kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ndaba libumunda laka Sapanga lelaapeke bandu womi ndi jojuhuluka kuhuma kunani kwaka Sapanga na jojaapeke bandu bupunndema womi.” ");
INSERT INTO mgv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ndipala jaapwagila, “Bambo, utupekia libumunda heli masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu jaapwagila, “Nepani ndi posu jejapeke bandu womi. Jojuhika kwangu nepani ngajijoi inzala, najojunhobale ne kyee ngajijoi nywita. ");
INSERT INTO mgv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lakini ngati enumpwagi mmweni nepani lakini ngamwihobalele. ");
INSERT INTO mgv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Boka baambeke Atati biihika kwango, nane nganundeke kunza mundu jokapi jojuhika kwango. ");
INSERT INTO mgv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ngase na hulwiki kuhuma kunani kwaka Sapanga kuhenga ganagapai namwete ila hulwiki ili kuhenga gala gajugapai jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jola jojundumiki jupala haga, naunhoa hata jumu kati ja bandu ba jumbeki ila nanhyoha boka lisoba la mwiso. ");
INSERT INTO mgv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ndaba gabagapai Atati bango ndi ganga, kila joandingali Mwana nukuhobale jombi jubiya na womi wa masoba goha. Nane nanhyoha lisoba la mwiso.” ");
INSERT INTO mgv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ndipala Ayaudi batumbuliya kumumuta ndaba Yesu japwajiki, “Jombi ndi libumunda lelahuluka kuhuma kunani kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bombi bapwaga, “Jonzo lee nga Yesu mwana waka Josepu? Twetwaamanyiki atati baki na amabaki? Henu jupwaga boo juhulwiki kuhuma kunani kwaka Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu jaapwagila, “Nkotuka kumumutanila kati jinu. ");
INSERT INTO mgv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngamundu jojuwesa kuhika kwangu nepani, sanga kuhutwa na Atati bandumiki, nane nayoha lisoba la mwiso. ");
INSERT INTO mgv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Alota baka Sapanga ahandiki ana, ‘Bandu boka biboliwa na Sapanga.’ Kila mundu joajone Atati nukulibola mabolee kuhuma kwaki juhika kwango. ");
INSERT INTO mgv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nga mundu jojabweni Atati, ila jombi jojuhuma kwaka Sapanga hoju ndi jojabweni Atati. ");
INSERT INTO mgv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Numpwaji sakaka, mundu jokapi jojuhobalee jiipata womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nepani ndi posu sekileta womi. ");
INSERT INTO mgv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aka hoku binu bakula kilebi sebikikema mana pulukoba, hata hela bawii. ");
INSERT INTO mgv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lakini senze kilebi sekihuluka kuhuma kunani kwaka Sapanga kila mundu jokapi jojukula nga jwiikuwe. ");
INSERT INTO mgv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nepani ndi libumunda lelileta womi gogwahuluka kuhuma kunani kwaka Sapanga. Mundu najukuliki libumunda lende jwitama masoba goha. Na libumunda lenumpeke nepani ndi nhyega jango, gonipia ndaba ja womu wa bandu bapandema pani.” ");
INSERT INTO mgv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndipala Ayaudi patumbuliya kulosana beni na beni ngamaa kati jabu bakapwaga, “Juwesa boo mundu jonzo kutupeke twe nhyega jaki ili twe tukulaje?” ");
INSERT INTO mgv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu jaapwagila, “Sakaka numpwaji, nangakula nhyega jaka Mwana waka Mundu na kunywa mwai waki ngamwikubi na womi nkati jino. ");
INSERT INTO mgv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundu jokapi jojukula nhyega jangu na kunywa mwai wango jupata womi wa masoba goha, nane nayoha lisoba la mwiso. ");
INSERT INTO mgv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ndaba nhyega jangu ndi posu ja sakaka, na mwai wa nikinywaji sa sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mundu jokapi jojukula nhyega jaa na kunywa mmwai waa jutama nkati jango nane ndama nkati jaki. ");
INSERT INTO mgv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Atati baabi bomi andumiki nenga, nanepani ndama na mwomi, ahelahe jojungula nepani jiendaliya kutama na womi. ");
INSERT INTO mgv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lende ndi libumunda lelahuluka kuhuma kunani kwaka Sapanga, nga ngati mana yebakula aka hoku binu nakuwa. Ila jojikula libumunda lende juitama masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu japwaga malobi ganga pajabii jakabola mu nyumba jukuketangena Ayaudi ku Kapelinaumu. ");
INSERT INTO mgv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Banafunzi baki bingi pabajowana malobi haga bapwaaga, “Mabole ganga ganonwipi. Nyajojuwesa kugajetakela?” ");
INSERT INTO mgv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu jamanyiki banafunzi baki ayoma kuhusu mabolee gala, ndipala jaalalukiya, “Boo lijambu lende liwesa lee kuhoa kuhobalela? ");
INSERT INTO mgv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kuibiya boo henu pamumbona Mwana waka Mundu jakakwela kujenda kojabii kabula? ");
INSERT INTO mgv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Loho ndi jejileta womi, makili gaka mundu ngase gawesa sindo. Malobi ganga ganumpwagi mwanganya ndi loho na womi. ");
INSERT INTO mgv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lakini abi bangi kati jinu banga kuhobalela.” Ndaba Yesu jamanyiki toka puwanzu nya ngasejuhobale na jola joang'alumbuka. ");
INSERT INTO mgv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu japwaga, “Ndaba numpwaji nga mundu jojuwesa kuhika kwangu nepani ila mbaka Atati anhwesisa kuhika kwangu.” ");
INSERT INTO mgv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndipala ndaba ja malobi haga banafunzi baki bingi bundeka Yesu na ngase baendaliya kumpwata kabee. ");
INSERT INTO mgv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ndipala Yesu jaapwagila banafunzi komi na abeli bala, “Boo! Na mwanganya mpala kuboka ahelahela?” ");
INSERT INTO mgv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petili japwaga, “Bambo, tujenda kwaka nyanye? Weapa gubi na malobi ga womi wa masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Natwe tuguhobale weapa ndi mundu wa Sapi kuhuma kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu jaapwagila, “Nepani kajika nenunhwagwi mwanganya komi na abeli? Lakini jumu wii ndi Lijobi!” ");
INSERT INTO mgv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Japwaaga hela ndaba jaka Yuda mwana waka Simoni Isikalioti, ndaba hoju jabiya ndi joang'alumbuka, lakini jabi nkati ja banafunzi baki komi na abeli. ");
INSERT INTO mgv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagajomukiya ganiaga, Yesu jabia jakajendajenda mu Galilaya, ndaba ngasejapai kujenda ku Yudea ndaba aka kilongosi ba Ayaudi bapala kunkoma. ");
INSERT INTO mgv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lisoba la tipati ga Ayaudi lukutama mwi indamba labia liegali, ");
INSERT INTO mgv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","alongu baka Yesu bumpwajila, “Guboka pamba gujenda ku Yudea, ili banafunzi baku akagabona mahengu gaguhenga. ");
INSERT INTO mgv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nga mundu jojuhiya majambu gajuhenga anajupala jumanyikana kwa bandu. Ndaba guhenga majambu ge haga nala ulilangia kwa bandu bupundema poti!” ");
INSERT INTO mgv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata akalongu baki ngasebunhobalile. ");
INSERT INTO mgv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu jaapwajila, “Kipindi sangu sekibii sapi ngasekihikike, lakini kwinu mwanganya ipindi yoti ya sapi. ");
INSERT INTO mgv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bandu bupundema ngaawesi kunsuki mwanganya, ila anzuki nepani, ndaba nepani naapwagi mahengu gabu giliya. ");
INSERT INTO mgv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mwanganya nnzendaniya ku tipati. Nepani nganyendi ku tipati, ndaba kipindi sangu saasapi sakona ngasekihikike.” ");
INSERT INTO mgv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu pajajomula kwaapwagi ganiaga, jahigaliya ku Galilaya. ");
INSERT INTO mgv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Alongu baki pababiya apiti ku tipati, Yesu najombi jajenda ahelahe, lakini jajenda sukulihiya bila kulilangi kwa bandu. ");
INSERT INTO mgv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aka kilongosi ba Ayaudi babiya bukuntaputa mtipati, balalukiya, “Jubi kwako?” ");
INSERT INTO mgv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Babiya atenda kubolane. Bangi bapwaaga, “Yesu mundu jwa amboni” Bangi bapwaaga, “Ngahela, ila jaakonga bandu.” ");
INSERT INTO mgv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lakini ngamundu jojalenga kundongale pagwendu, ndaba jakaajogopa aka kilongosi ba Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hata hela tipati egahika pikilanda, Yesu jajingala mu Nyumba jaka Sapanga nuku tumbuli kubola bandu. ");
INSERT INTO mgv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aka kilongosi ba Ayaudi basangi bapwaaga, “Boo mundu ajo mabole haga jupatiki kwako najombi ngase bumbolike?” ");
INSERT INTO mgv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu jaapwagila, “Mabolee ga mola nga gango, ila gaka jola jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu najupai kuhenga gajupala Sapanga, jiimanya ana mabole gangu gahuma kwaka Sapanga, au gahuma kwangu namwete. ");
INSERT INTO mgv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mundu jojupwa malobi gaki mweni pe jutaputa ulumbi waki mweni, ila jojutaputa ulumbi waka joantumiki, hoju julonge sakaka wala nkati jaki ngasejubii nu ubaja wokapi. ");
INSERT INTO mgv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa ngasejumpeki mwanganya Malagalaki? Lakini ngajumuwi jojukamulaki malagalaki jene. Boo, henu ndaba jakii mpala kungoma nenga?” ");
INSERT INTO mgv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bandu bala bapwaaga, “Wehapa gubii ni kilombu. Nya jojupala kugukoma weapa?” ");
INSERT INTO mgv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu japwaaga, “Nahengiki ndonduke jimu mwanganya ntenda kusangaa. ");
INSERT INTO mgv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa jumpekia Malagalaki gu kuseku jandu. Lakini Malagalaki gee haga ngasegahuma kwaka Musa ila kwaka aka ahoku bitu na mwanganya nseku jandu hata Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ana mundu juwesa kunseku jandu mundu Lisoba lu Kupomulela ili Malagalaki gaka Musa giihalabika, boo ndaba ja kii nhyome nepani kundamisa mundu Lisoba lu Kupomulela? ");
INSERT INTO mgv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nkotuka kutemu kukulingali kunza pee, ila ntemula ngati ejupala Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Henu, bandu bangi buku Yelusalemu bapwaaga, “Jonoju lee ngajobuntaputa ili bunkomaje? ");
INSERT INTO mgv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Linga! Ajo hapa julonge pagwendu, wala nga mundu joampwagi lilobi! Henu aka kilongosi amanyiki jonzo ndi Kilisitu nkombosi? ");
INSERT INTO mgv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kilisitu pajihika nga mundu jojwimanya kojuhumila, lakini twepani tukumanyi kojuhumi mundu ajo.” ");
INSERT INTO mgv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Henu Yesu pajwabiya jubola mu Nyumba jaka Sapanga, japwaga kwa sauti, “Ati mpwaga nepani mmanyi nakonhuma mukumanyi? Lakini nepani ngasenhikiki kupete uwesu wangu na mwete, ila jojundumiki ndi jwa sakaka. Mbanganya ngasemumanye, ");
INSERT INTO mgv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nepani nummanyiki ndaba nahuma kwaki najombi ndi jojundumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ndienu bataputa kunkamu, lakini nga mundu jojalenga kunkamu ndaba saa jaki jabiya jakona ngasejihikike. ");
INSERT INTO mgv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bandu bingi munsambi we gola batenda kunhobale bapwaaga, “Boo Kilisitu pajiihika jihenga nginyuli ngolongu ngani kupeta yejahenga ajojo?” ");
INSERT INTO mgv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afalisayu bajowana bandu bakabolannya malobi gaka Yesu gala, ndi bombi pamu na agolu akolongu baatuma alonda babu ajenda bukunkamula. ");
INSERT INTO mgv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu japwaaga, “Nepani nakona pamu numbanganya kukipindi kijipi ndienu nikelubuka kwaka jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwindaputa wala ngamwimone, ndaba ngamwiwesi kuhika pandu panibiya.” ");
INSERT INTO mgv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Alongosi ba Ayaudi balongalaniya beni na beni, “Mundu jonzo jijenda kwako twepani sangakuwesa kumbona? Boo jijenda ku misi ja Agiliki koahami Ayaudi na kwaabola Agiliki? ");
INSERT INTO mgv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jubii na maana boo ejupwaaga, ‘Mwindaputa lakini ngamwimoni na panibiya mwanganya ngamwiwesi kuhika?’ ” ");
INSERT INTO mgv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lisoba la mwisu la tipati gi indamba labiya lisoba likolongu. Yesu jajema nukupwaga kwa sauti ngolongu, “Mundu najubi na nywita, juhika kwangu jukunywa. ");
INSERT INTO mgv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngati Maandiku ga Sapi egapwaga, ‘Jojunhobale nepani, losi ya masi ga womi ginyika kuhuma nkati jaki.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu japwaaga haga kundongule Loho jaka Sapanga, bandu bala ba bunhobali jombi bitenda kunzopa. Kipindi se hesi Loho jaka Sapanga jabii ngasejihikike, ndaba Yesu jabiya jakoni ngasejujingi muukolongu waki. ");
INSERT INTO mgv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ndipala nsambi wa bandu be bala pabajowana malobi gala bapwaaga, “Sakaka mundu jonzo ndi Mlota jwaka Sapanga jola.” ");
INSERT INTO mgv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bangi bapwaga, “Jonzo ndi Kilisitu nkombosi.” Bangi bapwaga, “Kilisitu lee juwesa kuhuma ku Galilaya? ");
INSERT INTO mgv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maandiku ga Sapi lee ngasegapwajiki Kilisitu jisaliwa mukibeleku saka Nkolongu Daudi na musi uku Betelehemu, musi gola gojatama Daudi?” ");
INSERT INTO mgv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ndipala bandu batenda kubaganika ndaba jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bangi kati jabu bapala kunkamu, lakini nga mundu jojalenga kungusa. ");
INSERT INTO mgv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ndienu alonda bala bakelubuka kwa akolongu ba agolu na Afalisayu. Nabombi balalukiya alonda, “Boo, ndaba ja kii ngasemundetiki Yesu?” ");
INSERT INTO mgv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Alonda bala bapwaga, “Ngasejubii mundu jojuwesa kulonge ngati ejulonge mundu jola!” ");
INSERT INTO mgv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afalisayu bapwaga, “Boo na mwanganya ahelahe jutei kunkonga? ");
INSERT INTO mgv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Boo nhwahiki lee kumbona kilongosi jokapi ja bandu au jumu jwa Afalisayu babunhobalela? ");
INSERT INTO mgv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngahela lakini nsambi wa bandu aba bangakumanya Malagalaki gaka Musa, apatiki yaambamba kuhuma kwaka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mfalisayu jumu jobunkema Nikodemu jojawahiki kunzende Yesu jaapwagila, ");
INSERT INTO mgv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kulengana na malagalaki gitu ngasetuwesa kuntemu mundu kabula jukunzone nukumanya gajuhenga.” ");
INSERT INTO mgv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nabombi bajibua, “Nawehapa lee ahelahela guhumi ku Galilaya? Henu ukasoma wamweti Maandiku ga Sapi na we wibona ngasejubii mlota waka Sapanga jojuhumi ku Galilaya.” ");
INSERT INTO mgv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kila mundu jabuja ku nyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ndienu Yesu jajenda ku kitombi si Mizeituni. ");
INSERT INTO mgv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kilabu jaki pulukela jakelubukiya kabee mu Nyumba jaka Sapanga. Bandu boka bunhikila nukutama nabu, jabiya jakaabola. ");
INSERT INTO mgv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abola ba Malagalaki pamu na Afalisayu bundeta mbomba jumu joankamwi ugoni bunzemika palongi ja bandu boka. ");
INSERT INTO mgv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bumpwajila Yesu, “Mbola, Mbomba jonzo tukamwi jakatenda ugoni. ");
INSERT INTO mgv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kulengana na Malagalaki gaka Musa galagalaki kalapu malibu mbaka kua aka mbomba ngati haba, henu we gupwaga bolee?” ");
INSERT INTO mgv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bapwaaga hela ili kundenga Yesu ili apata ndaba jukuntaki. Lakini Yesu jajinama nukuandika pai nu lukonzi lwaki. ");
INSERT INTO mgv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nabombi pabaendaliya kundaluki Yesu jajumuka nakapwaaji, “Mundu jokapi kati jinu jwanga na mahakau jujumuka jutumbuliya kundapu malibu.” ");
INSERT INTO mgv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ndipala jajinama kabee nu kuandika panani juluhombi. ");
INSERT INTO mgv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pabajowana malobi gala, jaboka jumujumu balonguliya aseja. Yesu jahigaliya kajika jaki, nu mbomba jola jabiya jakona jujemiki apalapa. ");
INSERT INTO mgv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu pajajumuka ngaseambweni mundu ila mbomba jola, andalukiya, “Mbomba, bandu ba bukukamwi bala abii kwako? Boo ngamundu jo jukutemwi gubi na makosa?” ");
INSERT INTO mgv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mbomba jola japwaaga, “Bambo, ngasejubi mundo hata jumu.” Ndipala Yesu ampwagila, “Nane ahelahe nganugutemule. Jenda ila witenda mahakau kabee.” ");
INSERT INTO mgv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu jalongila kabee na Afalisayu, “Nepani ndi unang'anu wa bandu bupundema. Jokapi jojumbwata kyee ngajiijendi nndwii, ila jibiya na unang'anu wa womi.” ");
INSERT INTO mgv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ndipala Afalisayu bumpwajila, “Weapa ulilongale wamweti, malobi gaku ga gupwaga haga nga ga sakaka.” ");
INSERT INTO mgv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu jaapwagila, “Hata nanililongali namweti, malobi gangu ga sakaka, ndaba manyiki kohumiki na konyenda. Lakini mwanganya ngasemmanyiki kohumiki wala konyenda. ");
INSERT INTO mgv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwanganya ntemu ngati bandu eatemu, lakini nepani ngasenuntemwi mundu jokapi. ");
INSERT INTO mgv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Hata nandenda kutemu, kutemu jangu ja sakaka, ndaba ngase mii kajika jangu lakini Atati baandumiki abi pamu nane. ");
INSERT INTO mgv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ahandiki mu Malagalaki ginu ana bandu abeli alongi lijambu limu ajetangane kuhusu sindu sebikibweni ndi malobi ge aga gibia gasakaka. ");
INSERT INTO mgv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nepani nililongale sakaka namwete na Atati baandumiki anongalee sakaka kuhusu nepani.” ");
INSERT INTO mgv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ndienu bundalukiya, “Atati baku abi kwako?” Yesu japwaaga, “Nepani ngasemmanyiki wala Atati bangu ngasemwamanyiki, emwakamanyi nepani, mwakabiya mwaamanyiki na Atati bango.” ");
INSERT INTO mgv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu jalongila malobi ge haga pajabiya jubola mu Nyumba jaka Sapanga nsumba sukubeke matambiku, wala nga mundu joankamula, ndaba muda waki wabi wakona ngaseguhikike. ");
INSERT INTO mgv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu jaapwagila kabee, “Nepani ndenda kuboka, mwanganya mwindenda kundaputa, lakini mwikua kwa mahakau gino. Nepani konijenda mwanganya ngamwiwesi kuhika.” ");
INSERT INTO mgv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aka kilongosi ba Ayaudi balaluana, “Boo jupala lee kujenda kulikoma? Mbona jupwaaga konyenda ne mwanganya ngamwiwesi kuhika?” ");
INSERT INTO mgv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu jaapwagila, “Mbanganya nhuma pai pani, lakini nepani nhumiki kunani. Mwanganya mwabandu bupundema pani lakini nepani nga namundu jupundema pane. ");
INSERT INTO mgv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndi ndaba nabii numpwaji mwikuwa kwa mahakau gino ana ngasenhobale, ‘Nepani ndi Jojuwe.’ Mwikuwa kwa mahakau gino.” ");
INSERT INTO mgv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ndipala bundalukiya, “Boo weapa ndi wanyanye?” Yesu japwaaga, “Nepani ndi jola jonumpwagila toka panatumbuliya kulonge. ");
INSERT INTO mgv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mii na malobi gingi gukumpwagi nu kuntemu mwanganya. Lakini jojundumiki ndi jwa sakaka, nane numpwaagi mwabandu bupundema malobi ganyowini kuhuma kwaki.” ");
INSERT INTO mgv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngasebamanyiki ngati japwaaga kuhusu Sapanga Atati baki. ");
INSERT INTO mgv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndipala Yesu jaapwagila, “Pamwantondabia Mwana waka Mundu kunani, hapa ndi pamwimanya, ‘Nepani ndi Jojuwe.’ Na ngasehennga sokapi namwete, ila mbwaga pe gabamoliki Atati. ");
INSERT INTO mgv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jombi jojanduma jubi pamu nane, ngasejanei kajika jango, ndaba henga masoba goha ga gundenganile.” ");
INSERT INTO mgv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu pajajomulaa kupwaga malobi ge haga bandu bingi batenda kunhobale. ");
INSERT INTO mgv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndipala Yesu jaapwagila Ayaudi bala babahobali, “Mwanganya nanzetaki malobi gango mwibiya mwa banafunzi bangu basakaka. ");
INSERT INTO mgv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mwajimanya sakaka na sakaka heji jitenda kundekakela.” ");
INSERT INTO mgv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bumpwagila, “Twepani kibeleku saka Ibulahimu, Wala ngasetubii twaatumwa kwaka mundu jokapi. Ndaba jaki gupwaga, ‘Sakaka jiitenda kutulekakela?’ ” ");
INSERT INTO mgv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu jaapwagila, “Numpwaji sakaka, kila jojuhenga mahakau jwibiya jutumaki mahakau. ");
INSERT INTO mgv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ntumwa ngasejutama pa nyumba masoba goha, lakini mwana jutama masoba goha. ");
INSERT INTO mgv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ndienu Mwana najundekaki, mwilekakiwi sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Manyiki mwanganya ndi kibeleku saka Ibulahimu lakini ntaputa kungoma ndaba nkana kujetake mabole gango. ");
INSERT INTO mgv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nepani mbwaga gala ganagabweni kwa Atati bango, lakini mwanganya uhenga ganzowini kuhuma kwa atati bino.” ");
INSERT INTO mgv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bapwaga, “Twepani atati bitu a Ibulahimu.” Yesu jaapwagila, “Ana mmbanganya emwakabii mwabana baka Ibulahimu, mwakahenga ngati ejwabiya juhenga Ibulahimu. ");
INSERT INTO mgv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nepani numpwagi sakaka jenyoini kuhuma kwaka Sapanga, hata hela mwanganya mpala kungoma. Ibulahimu ngasejatei hela! ");
INSERT INTO mgv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwanganya uhenga mahengu gahenga atati binu.” Bapwaga, “Twepani nga twabana ba panyumba. Tubii na atati bamu ndi Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu jaapwagila, “Sapanga ebakabi Atati binu, mwakambala nepani, ndaba humiki kwaka Sapanga na henu mi pamba. Wala ngasenahika kupete uwesu wangu namweti lakini jombi jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndaba ja kii ngaseuhobale malobi ga numpwagila? Ndaba ngasempala kujowane malobi gango. ");
INSERT INTO mgv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mmbanganya atati binu Lijobi na mwanganya mpala kuhenga gapai atati binu. Jombi jabii jojukoma toka puwanzu. Najombi ngasejutama puusakaka, ndaba ngasejibi sakaka nkati jaki. Kila ejupwaga isoli, jupwaga gaki mweni, ndaba jombi jwinisoli na atati baki bini isoli. ");
INSERT INTO mgv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ndaba nepani numpwagi sakaka mwanganya ngaseuhobale nepani. ");
INSERT INTO mgv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Boo nya kati jinu jojuwesa kulangi nepani mi na mahakao? Ana nepani mbwaga ga sakaka, ndaba jakii mwanganya ngasenhobalela? ");
INSERT INTO mgv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jojukuba mundu jwaka Sapanga jujoana malobi gaka Sapanga. Lakini mwanganya ngasenzowane ndaba nga mwabandu baka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayaudi bumpwaga Yesu, “Boo ngase twapwajiki sakaka weapa gu Msamalia kabee gubi ni ilomboo?” ");
INSERT INTO mgv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu jaapwagila, “Nepani naajowane Atati bangu.” Lakini mwanganya ngasenyoane nepani. ");
INSERT INTO mgv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wala nepani ngasendaputa ukolongu wango. Ila jubi jumu jojundaputi ukolongu wangu najombi ndi jojutemu. ");
INSERT INTO mgv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Numpwaji sakaka, “Mundu najukamwi malobi gangu nga giikui ila giitama masoba goha.” ");
INSERT INTO mgv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Henu Ayaudi bumpwagila, “Henu tumanyiki gubi niilombu! Ibulahimu jawii, na alota bawii nawe gupwaga mundu najilikamwi lilobi laku ngajikui yaka petapeta. ");
INSERT INTO mgv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Boo gulibona lee weapa gu nkolongu kupeta atati bitu Ibulahimu? Jombi jawii na alota bawii. Boo weapa gulibona wa nyanye?” ");
INSERT INTO mgv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu japwaga, “Nanililumbali na mwete ukolongu waa nga sindo, Atati bangu ndi ba anumbali nepani ba mwakema mwanganya ndi Sapanga wino. ");
INSERT INTO mgv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwanganya ngasemumanyiki lakini nepani numanyiki. Ana mbwagiki ngasenumanyiki nibiya nonge isoli ngati mwanganya, lakini nepani numanyiki kabee nilijetake lilobi laki. ");
INSERT INTO mgv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atati binu Ibulahimu batoguli ngamaa ndaba bapala kulibona lisoba langu lukuhika najombi jilibweni nukutogule.” ");
INSERT INTO mgv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayaudi bumpwajila, “Weapa ngaseguhiki yaka amusini, enu gupwaga boo gumbweni Ibulahimu?” ");
INSERT INTO mgv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu jaapwagila, “Nupwagi sakaka, kabula Ibulahimu ngasejubelikwi, ‘Nena bii.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Apalapa batondula malibu ili bundapula, lakini Yesu jilihia nukupita pa Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu pajabiya jupeta mwindela, ambona mundu jumu jojabii ngasejulinga toka kubelekwa kwaki. ");
INSERT INTO mgv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Banafunzi baki bundalukiya, “Mbola, nya jojuhengiki mahakau mundu ajo au ahengo na amabu baki mbaka jubelikwi jwanga kulinga?” ");
INSERT INTO mgv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu japwaga, “Jonzo ngasejatei mahakau wala ahengo na amabu baki. Jwasaliwi jwangalinga ili makili gaka Sapanga gabonikana gakahengika mumaisa gaki. ");
INSERT INTO mgv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kipindi sakona lioba mutu tupalika kuhenga lihengu laka jola jojundumiki. Ndaba ikilu jiegali na nga mundu jojuwesa kuhenga lihengu laka jola jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kipindi semi pundema nepani ndi unang'anu gupundema.” ");
INSERT INTO mgv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pajajomula kupwaga haga, Yesu jahuna imata pai, jalenganakiya likandu, ampakia jwanga linga jola likandu mmiho. ");
INSERT INTO mgv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ampwajila, “Gujenga ukasamba masi ku kiliba sa Soloamu.” Maana jilihina lende ndi “Joantumiki.” Ndienu jajenda nukusamba, jakelubuka koni jakalinga. ");
INSERT INTO mgv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bandu bapambipi jaki na babumbona kipindi sumunyuma jakabiya julobaloba, bapwaga, “Jonzo le nga mundu jojabii jutama pai nukulobaloba jola?” ");
INSERT INTO mgv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bangi bapwaaga, “Jombe” Lakini bangi bapwaaga, “Ngaela, nga jombe jutei kulengana naku pena.” Lakini mweni japwaga, “Anenganenga nongubika ndenda kulobaloba.” ");
INSERT INTO mgv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ndienu bundalukiya, “Guwesiki boo, sajenu kulinga?” ");
INSERT INTO mgv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Najombi japwaga, “Mundu jola joankema Yesu jalenganakiya likandu, nukumbaki mmihu nukumbwagi gujenda kukiliba suku Soloamu ukasamba kumihu. Ndienu najenda kusamba, nukuwesa kulinga.” ");
INSERT INTO mgv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nabombi bundalukiya kabee, “Jubi kwaa mundu we hojo?” Japwaaga, “Nepani ngase nukumanye.” ");
INSERT INTO mgv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndipala bumpelika jwangalinga we jola kwaka Afalisayu koni juwesa kulinga henu. ");
INSERT INTO mgv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lisoba Yesu pajahenga likandu nukuyeku mihu jwangalinga jola lakabi Lisoba lu Kupomulela. ");
INSERT INTO mgv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ndipala Afalisayu bundalukiya, “Guwesiki bo kulinga?” Najombi jaapwajila, “Jambakia likandu mmihu, nane nasamba masi kumihu, henu sajenu ndenda kulinga.” ");
INSERT INTO mgv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Afalisayu baakumwa bapwaga, “Mundu jonzo ngasejuhumiki kwaka Sapanga ndaba ngasejukamu Malagalaki ji Lisoba lu Kupomulela.” Afalisayu bangi bapwaga, “Juwesa boo mundu jwana mahakau kuhenga nginyuli ngati heje?” Batenda kubaganika kati jabu. ");
INSERT INTO mgv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ndienu Afalisayu bundalukiya kabee jojabi ngakulinga, “Boo wamwee gupwaga bole kuhusu mundu jola jojugukulamisa miho?” Japwaga, “Jombi ndi Mlota Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lakini alongosi ba Ayaudi ngasebahobalile ana mundu jola ngasejawesa kulinga, nasajenu juwesa kulinga, mbaka pabaakema ahengo na amabu baki, ");
INSERT INTO mgv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","nakalaluki, “Jonzo ndi mwana wino jojabelikwi bila kuwesa kulinga? Henu sajenu juwesiki boo kulinga?” ");
INSERT INTO mgv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ahengo na amabu baki bajibua, “Tumanyiki jonzo mwana witu, na jabelikwi bila kulinga. ");
INSERT INTO mgv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lakini ngasetumanyiki sekipiti mbaka kulinga sajeno, wala ngasetumanyiki nyaa joanhyeku mihu gaki. Mundalukiya mwene ndaba jombi mundu mwanahota juwesa kulandi mwene!” ");
INSERT INTO mgv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ahengo na amabu baki bapwaga hela ndaba jakaajogopa akikilongosi ba Ayaudi, ndaba Ayaudi babiya ajetangani mundu jokapi jojipwaga Yesu ndi Kilisitu Nkombosi bambenga mu Nyumba jukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndaba ahengo na amabu baki bapwaga, “Jombi mundu mwanahota mundalukiya mwene!” ");
INSERT INTO mgv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ndienu bunkema kabee jojabi jusaliwi bila kulinga jola nukumpwagi, “Pwaga sakaka na Sapanga jugujoannya! Twepani tumanyiki mundu hoju jubii na mahakau.” ");
INSERT INTO mgv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jombi jaapwagila, “Ana jombi jubii na mahakau ne ngasemanyike. Natu semanyiki nabii ngakuwesa kulinga na sajenu ndenda kulinga.” ");
INSERT INTO mgv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bundalukiya, “Jombi juguhengi kike? Juguyekula boo, mihu gako?” ");
INSERT INTO mgv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Najombi jaapwagila, “Nenumpwaji wala ngasenzoa. Ndaba ja kii mpala nupwajila kabee? Boo, namwanganya kabee mpala kuba mwa banafunzi bake?” ");
INSERT INTO mgv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ndipala buntondula nukupwagi, “Weapa ndi mbolee waka mundu jola, twepani ndi twa banafunzi baka Musa. ");
INSERT INTO mgv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumanyii Sapanga jalongila na Musa, lakini ngasetumanyiki kojuhumi mundu hoju!” ");
INSERT INTO mgv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Najombi jaapwagila, “Haleli lijambu lukusangasa! Mwanganya ngasemmanyiiki kojuhuma, lakini jombi juyekwi mihu! ");
INSERT INTO mgv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanyiki Sapanga ngaseanzoane jwana mahakau, ila anzowane mundu jola joanzogopa nukuhenga gajupala. ");
INSERT INTO mgv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tumbuka kubomba nndema ngasetujowini mundu jugayekwi mihu gaka mundu jojubelikwi bila kulinga. ");
INSERT INTO mgv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ana mundu hoju ngasejahumiki kwaka Sapanga, ngajakawesiki kuhenga lihengu ngati alele.” ");
INSERT INTO mgv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Japwaga, “Wehapa wasaliwa nukukole mumahakau, uwesa boo, kutubola twepane?” Ndi bumbengila kunza ja Nyumba jukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu jajowana ampihiki kunza mu Nyumba jukuketangane Ayaudi, ehambona kabee ampwagila, “Boo, weapa lee guhobale Mwana waka Mundu?” ");
INSERT INTO mgv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundu jola japwaga, “Bambo, gumbwajila Mwana waka Mundu we hoju ndi nyanye, ili wesa kunhobalela.” ");
INSERT INTO mgv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ampwagila, “Umbwene, jombi ndi jojulonge naweapa sajeno.” ");
INSERT INTO mgv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ndipala mundu jola japwaaga, “Bambo, nuguhobalela.” Najombi anzinamiya Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu japwaga, “Nepani hikiki pundema kaabaganisa bandu, ili bandu bangalinga alinga, na bandu balinga biilinga.” ");
INSERT INTO mgv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Afalisayu bangi babakabi pamu najombi pabajowana haga, bumpwajila, “Boo, natwe lee ngasetulinga?” ");
INSERT INTO mgv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu jaapwagila, “Ana mwakabii ngasenndinga ngamwakabii na mahakau, lakini henu mwanganya mpwaaga, twe tutenda kulinga, hempwaga hela nndangi mwakona mbii na mahakao.” ");
INSERT INTO mgv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu japwaga, “Numpwagi sakaka, mundu jokapi jwanga kujingi mukisisi sa makondoo sukukupetee punndyangu, lakini jujingi kupete pandu pangi, hoju mwie kabee hoju linzolinzoli. ");
INSERT INTO mgv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lakini mundu jojujingi kupete punndyangu, hoju ndi nndimi wa makondoo. ");
INSERT INTO mgv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nndonda wikisisi jutenda kunhogule, na makondoo gajowana lilobi laki, najombi jwagakema makondoo gaki kila limu ku liina laki, na kugalongulake kunza. ");
INSERT INTO mgv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pajujomo kugapia kunza, jagalongule kulongi nagombi makondoo gatenda kumpwata, ndaba gijimanya malobi jaki. ");
INSERT INTO mgv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Makondoo haga ngase gawesa kumpwata nngeni, ila gatenda kuntila ndaba ngasebilimanya malobi gaki.” ");
INSERT INTO mgv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu jwaapwagila lilenganu heli, lakini bombi ngase bamanyiki sejwapala kwaapwagi. ");
INSERT INTO mgv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ndienu Yesu jwapwaga kabee, “Numpwagi sakaka, nepani nundyangu wa makondoo. ");
INSERT INTO mgv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bangi boka babanonguli nepani babi bii na manzolinzoli, na makondoo ngasegaajogwani boombe. ");
INSERT INTO mgv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nepani nunndyangu. Jojujingi kupete kwangu nepani jwitenda kuokolewa, jwijingila nukupita, nukupata malele. ");
INSERT INTO mgv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwii juika pee ili kujiba nukukoma nukuhalabana. Nepani nhikiki ili bandu apata womi, womi wa sakaka wanga kupongo. ");
INSERT INTO mgv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Neepani nu nndimi waamboni. Nndimi waamboni juuboa womi waki ndaba ja makondoo gaki. ");
INSERT INTO mgv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lakini mundu jojuhenga kibalua hoju nga nndime, na makondoo nga gake. Pajukibona kimei kitenda kuhika jugaleka makondoo nukutila. Kimei kitukali makondoo nukugabaganisa ndela. ");
INSERT INTO mgv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mundu hoju jutila ndaba ngase jugaangajaki makondoo ndaba jombi mundu jukibalua pena. ");
INSERT INTO mgv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nepani nundimi waamboni. Nagamanyi makondoo gangu, nagombi makondoo gangu gamanyi nepani, ");
INSERT INTO mgv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ngati Atati heamanya nepani, ndi nanepani henaamanya Atati. Nepani mbia womi wangu ndaba ja makondoo. ");
INSERT INTO mgv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kabee mina makondoo gangi ngasegabi mukisisi seno. Ndakiwa kugaleta na haga kabee, nabombi biijogwana malobi gango na kwibia nsambi gumu nu nndimi jumu. ");
INSERT INTO mgv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Atati ambala nepani ndaba mitayali kupia womi wangu ili nuujopa kabee. ");
INSERT INTO mgv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nga mundu jojuwesa kunyaga womi wangu, nepani mbia sukupala namwete. Mii nuuwesu ukuuboa nukuujuku kabee. Hela ndi Atati eambwagi kutenda.” ");
INSERT INTO mgv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu pajajomula kupwaga haga Ayaudi babaganika kabee. ");
INSERT INTO mgv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bingi kati jabu bapwaga, “Ajo jubi niilombu, kabee jonojuwe mwanamangongu! Munzogwane wakyane?” ");
INSERT INTO mgv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lakini bangi bapwaga, “Haga nga malobi gaka mundu jwiniilombo. Boo kilombu lee kiwesa kuyeku mihu ga bandu banga kulinga?” ");
INSERT INTO mgv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ku Yelusalemu kwabi tipati gukukomboka kujibeka palongi jaka Bambu Nyumba jaka Sapanga. Kipindi se hesi wabiya nsimu ukipepu. ");
INSERT INTO mgv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu jwabia jwakajendajenda pa Nyumba jaka Sapanga nkati ja sengu jaka Solomoni. ");
INSERT INTO mgv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Henu, Ayaudi bunhyongolota nukundaluki, “Watubeka mukiholu mbaka lile? Ana weapa ndi Kilisitu Nkombosi utupwagila pe hotuhotu.” ");
INSERT INTO mgv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu jwaapwagila, “Nenumpwagi, lakini ngasenhobalela. Lihengu lenienga kupete uwesu wa Atati bangu lilangi nepani ndi jojuwe. ");
INSERT INTO mgv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lakini mwanganya ngasenhobale, ndaba mwanganya nga makondoo gango. ");
INSERT INTO mgv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Makondoo gangu gajogwana lilobi lango. Nenamwe nagamanyi, nagombi gandenda kumbwata. ");
INSERT INTO mgv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nepani nagapeke womi wa yaka petapeta, nabombi ngabikuwi masoba goha. Wala nga mundu jojuwesa kwagaboa mumaboku gangu. ");
INSERT INTO mgv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Atati bangu baambeki makondoo haga ndi nkolongu kupeta boka, wala nga mundu jojuwesa kwagaboa mumaboku ga Atati. ");
INSERT INTO mgv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nepani na Atati tubi sindu simu.” ");
INSERT INTO mgv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ndipala, Ayaudi bajukua malibu ili bundapula Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu jwaapwagila, “Nunndangi mahengu gingi gaasapi kuhuma kwa Atati. Lihengu boo lamboni kati ja mahengu haga gampala kungome kwa maliboo?” ");
INSERT INTO mgv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayaudi bapwaaga, “Ngasetugukoma malibu ndaba jilihengu la amboni, ila ndaba untondwi Sapanga! Wee ulihenga wamwe kuba wa Sapanga koni weapa wa mundu pee.” ");
INSERT INTO mgv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu japwaaga, “Boo, ahandiki mu Malagalaki gii, ‘Nee mbwagiki mwanganya mwaka sapanga.’ ");
INSERT INTO mgv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Sapanga jwaakema aka sapanga bandu bajwaapeki malobi gaki, natwe tumanya Maandiku gaa Sapi galonge sakaka masoba goti. ");
INSERT INTO mgv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Henu Atati anhagwi nee nukunduma nepani punndema. Ndaba jakii mwanganya mpwaga nuntondo Sapanga, pa mbwaga, nepani na mwana waka Sapanga? ");
INSERT INTO mgv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ana ngasendenda mahengu ga Atati bangu mwinhobalela. ");
INSERT INTO mgv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ana nihenga mahengu ga Atati bangu, hata na ngase nhobalela, nala unhobaliya mahengu haga. Ili mmanya sakaka Atati abii nkati jangu, nane mi nkati jaki.” ");
INSERT INTO mgv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Balenga kabee kunkamu Yesu, lakini jwalemangana mumaboku gabu. ");
INSERT INTO mgv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu jwajenda kabee kwii ja losi luku Yoludani, pandu pajwabia jwakabatisa Yohana, jwatama koku. ");
INSERT INTO mgv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bandu bingi bunzendila Yesu nukupwaga, “Yohana ngasejwatei nginyuli jokapi. Lakini goka gajwabia jwakapwaga Yohana kunndongale jombi gabia gasakaka nganii.” ");
INSERT INTO mgv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bandu bingi pandu pala batenda kuhobalela Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu jumu jobunkema Lazalu, mwenei juku Betania, jwabii nngonzu. Betania sabi kijiji sejutamika Malia nu nndombu waki Maluta. ");
INSERT INTO mgv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia ndi joampakia Bambu mahuta gaganungi mumagolu gaki nukunhungu na majunzu gaki. Kaka waka Malia joakemika Lazalu ndi jojwabia jutenda kulwala. ");
INSERT INTO mgv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ndienu, Malia na Maluta baatuma malobi kwaka Yesu kupwaga, “Bambo, nkosi waku jutenda kulwala!” ");
INSERT INTO mgv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu pajwajogwa jwapwaga, “Ugonzu hogu nga gukukoma ila guhikiki ndaba guleta ulumbi kwaka Sapanga, julwala ili kupete ugonzu wee hogu Mwana waka Sapanga julumbalika.” ");
INSERT INTO mgv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu jwaapai ngamaa Maluta na Malia na kaka wabu Lazalu. ");
INSERT INTO mgv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pajapata malobi gu ugonzu waka Lazalu, Yesu jwaendalia kutama koku kwa masoba gangi mabeli. ");
INSERT INTO mgv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ndi jaapwagila banafunzi baki, “Tujendaniya kabee ku musi uku Yudea!” ");
INSERT INTO mgv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Banafunzi bumpwagila, “Mbola, kipetiki kipindi pe kisokopi toka Ayaudi pabapala kugukoma kwa malibu, gupala kabee kujenda koko kabee?” ");
INSERT INTO mgv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu jwaajibwa, “Boo, masaa ga lyoba mutu nga komi na mabeli pee? Mundu hejujenda lyobamutu ngajuwesi kulikobando ndaba jugubona unang'anu upundema goni. ");
INSERT INTO mgv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lakini mundu na jujenda ikilu jutenda kulikobando, ndaba ikilu ngasekukuba nunang'ano.” ");
INSERT INTO mgv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu pajwajomula kupwaga malobi gala, jwaapwagila, “Nkosi witu Lazalu jutei kugonela, lakini nepani niijenda kunnzumu.” ");
INSERT INTO mgv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Banafunzi baki bumpwagila, “Bambo, ana jutei kugone pee mbaka julame.” ");
INSERT INTO mgv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bombi bawasalya jupwagiki jugosi lugonu, lakini Yesu jwabi julongale Lazalu jutei kuwa. ");
INSERT INTO mgv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndi, Yesu jwaapwagila hotuhotu, “Lazalu jutei kuwa, ");
INSERT INTO mgv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lakini nepani ndenda kutogule, ndaba ngasenabi kola, ili nhwesa kuhobale. Henu tubokaniya kojubi Lazalu.” ");
INSERT INTO mgv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi jobunkema Mapaa jwaapwagila banafunzi ajaki, “Tubokaniya na twee twakakuwa pamu najombi Yesu!” ");
INSERT INTO mgv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu pajwahika kola jwaketania Lazalu bunsikiki na jutemi pilitenge masoba nsesi. ");
INSERT INTO mgv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kijiji suku Betania sabi pambipi nuku Yelusalemu, ulasu waki wabi kilumita itatu. ");
INSERT INTO mgv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayaudi bingi babia ahikiki kwaka maluta na Malia kwaajegwesa mawasu ndaba ja kuwa kwaka kaka wabu. ");
INSERT INTO mgv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maluta pajwajogwana Yesu jutenda kuhika, jwajenda kunzopa kuindela, lakini Malia jwaigali ku nyumba. ");
INSERT INTO mgv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maluta ampwagila Yesu, “Bambu, ana wakabia apambani, kaka wangu nee nga jwaka wile! ");
INSERT INTO mgv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakini nee manyiki hata sajenu sokapi sewanndoba Sapanga, jwitenda kugupeke.” ");
INSERT INTO mgv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu jwapwaga, “Kaka waku jwitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maluta japwaga, “Nee manyiki jiyoka lisoba le heli Sapanga jayoa bandu boa, mulisoba la mwisu.” ");
INSERT INTO mgv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu jwapwaga, “Nepani ndi jojuyoha bandu nakaapeke womi. Jojunhobale nepani hata najuwi, jwitama kabee, ");
INSERT INTO mgv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na jokapi jojutama nukunhobale, ngajikue. Boo, guhobale lee ganiaga?” ");
INSERT INTO mgv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maluta jwapwaga, “Hena Bambo, Nepani nhobale weahapa ndi wa Kilisitu, Mwana waka Sapanga, jojuhika pundema.” ");
INSERT INTO mgv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maluta pajwajomula kupwaga gala, jwajenda kunkeme nndombu waki Malia pulutengu, nukumpwagi, “Mbola jubi apambane, jutenda kugukema.” ");
INSERT INTO mgv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia pajwajogwa hela, jwajumuka nyatanyata, nukunzende Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu jwabi jwakona ngase jujingi mukijiji, ila jwabia jwakona apalapala pajwaketangana na Maluta. ");
INSERT INTO mgv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ayaudi bababi panyumba pala pamu na Malia bukuzewesa mawasu, pabumbona jujumuka nukupita kunza nyatanyata, batenda kunpwata. Baambusiya jujenda kulele kulitenge. ");
INSERT INTO mgv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia pajwahika pandu pajwabi Yesu, na paambona pee anzinamiya nukumpwagi, “Bambu, ana wakabi apambani, nhwasa wangu nga jaka wile!” ");
INSERT INTO mgv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu paambona Malia jakalela, na Ayaudi bababi pamu najombi na bombi atenda kulela, gumbina moju nukuhangajika ngamaa. ");
INSERT INTO mgv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ndienu jaapwagila, “Boo mummbei kwako?” Bumpwagila, “Bambu, guhika gulingaje.” ");
INSERT INTO mgv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu jatenda kulela. ");
INSERT INTO mgv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ayaudi bapwaaga, “Lola oti Yesu moampali Lazalu!” ");
INSERT INTO mgv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bangi bapwaaga, “Ajo joanndamisa jwanga kulinga jola, boo jwasinda lee kupengale Lazalu jwikuha?” ");
INSERT INTO mgv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu koni gumbiniki mwoju kabee, jwahika kulitenge. Litenge lee labi lipoli, leayekali ni lilibu. ");
INSERT INTO mgv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu jwapwaga, “Mmboa lilibu heli!” Maluta, nndombu waka jojuwi we hoju, ampwagila, “Bambu, jutumbuli kununga, jutemi mulitenge masoba nsesi!” ");
INSERT INTO mgv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu jwapwaaga, “Boo, ngasenugupwagii na guhobali wagubona ukolongu waka Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ndipala baboa lilibu lela. Yesu jwalingalia kunani kwaka Sapanga, nukupwaga, “Nunsengu mwa Atati ndaba Ntenda kunyogwanela. ");
INSERT INTO mgv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nepani manyiki unyongwane masoba goka. Lakini ndenda hela ndaba ja bandu baabi paamba aba ili awesa kuhobale weapa ndi wogundumiki nepani.” ");
INSERT INTO mgv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hejwajomula kupwaga hela, jwakema kwa sauti ngolongu, “Lazaloo! Piita kunza!” ");
INSERT INTO mgv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jojuwi jola ndi jwapitaa kunza, koni bunkongiki sanda mukuboku na mukugolu, nukumiu jaki kuyekaliwi. Yesu jwaapwagila, “Mumbopula, munndeka jujenda.” ");
INSERT INTO mgv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ayaudi bingi bababi ahikiki kwaka Malia pababona gajutei Yesu, batenda kunhobale. ");
INSERT INTO mgv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bangi bajenda kwa Afalisayu kapwagi majambu gajutei Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Henu agolu akolongu na Afalisayu batenda kuketangana pamu na bandu bapa Sengu ja Ayaudi, balaluana, “Tutendaa bolee? Mundu hajo jutenda nginyuli ingipi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Anatundekiki pe bandu boti biitenda kunzetake, na Aka kilongosi buku Loma bihika kualabana Nyumba jaka Sapanga na kwa akoma bandu bitu.” ");
INSERT INTO mgv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ndipala, jumu wabu jobunkema Kayafa, jojabii Nngolu Nkolongu saka se hesi, jwaapwagila, “Mwanganya ngase mukimanyi sindo! ");
INSERT INTO mgv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Boo, ngase mbona mbanga kwinu mundu jumu jawelila bandu bingi, kuliku bandu boka kuwaa?” ");
INSERT INTO mgv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jombi ngasejwapwaga hela ndaba jukupala kwaki ila ndaba jwabii Nngolu Nkolongu saka se hesi, jwalotila kupwaga Yesu jwitenda kuwa ndaba ja Ayaudi boka, ");
INSERT INTO mgv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kuwa kwaki nga ndaba Ayaudi pena, ila kabee ili juwesa kwaaleta pamu bandu baka Sapanga babaeni ndema yengi. ");
INSERT INTO mgv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Henu toka lisoba heli aka kilongosi baka Ayaudi ataputa indela jukunkoma Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ndienu Yesu, ngase jwajenda kabee pangwendo ja Ayaudi, ila jwaboka pala, nukujenda pambipi nu lukoba pambipi na musi gobugukema Efulaimu. Jwatama kola pamu na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lisoba lukutogule la Pasaka ja Ayaudi labia lihegali, na bandu bingi bapiti ku Yelusalemu kulisapisa haga ndi malagalaki gaguhenga mundu kundumbaliya Sapanga kabula ji lisoba heli kuhika. ");
INSERT INTO mgv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ndienu, babiya buntaputa Yesu, nabombi pabaketangini pa Nyumba jaka Sapanga balaluana, “Boo mundu we hoju ngajuhiki ku tipati ja Pasaka?” ");
INSERT INTO mgv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Agolu akolongu na aka Afalisayu babia alagalaki mundu jokapi na jumanyiki pandu pajubi Yesu jwaapwagila ili bunkamula. ");
INSERT INTO mgv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pagahigali masoba sita kabula jukuhika tipati ja Pasaka, Yesu jwahika ku Betania kojwabia jutama Lazalu joanhyoa. ");
INSERT INTO mgv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kokuje buntelakiya posu ja pakamii, na Maluta jwabia jutenda kwaatelake. Lazalu jwabi kati ja bandu bababi pamu na Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Malia jwajukua mahuta gaganungi ga bei ngolongu nusu lita galenganaki kunkongu gobugukema nado, nukumpaki Yesu mumagolu nukunhungu kwa majunzu gaki. Nyumba joti jatweli ulumba wa mahuta gaganungi. ");
INSERT INTO mgv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Henu, ntumi waka Yesu jumu, jobunkema Yuda Isikalioti, joanng'anambuka Yesu, jwapwaga, ");
INSERT INTO mgv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mbanga mahuta gabei ngolongu aga bakalombisa hipati mia tatu ya feza, nakaapeke aka kapuko?” ");
INSERT INTO mgv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jwapwaga hela, si japala kwaajangati aka kapuku, ila ndaba jabii mwii. Ndaba jukubika jubeka mpuku ulupija, kila mala jwabia jujiba lupija mumpuku gola. ");
INSERT INTO mgv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu jwapwaga, “Mundeka, jagalomba mahuta ge haga ili jagabeka lisoba luku ndaga nepani. ");
INSERT INTO mgv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Aka kapuku mwikuba nabu masoba goti, lakini nga mwikubi nanepani masoba gote.” ");
INSERT INTO mgv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayaudi bingi bajogwini Yesu jubii ku Betania. Ndi bahika kola nga ndaba jukumbona pee Yesu, ila kabee bapala kumbona Lazalu joanhyoha Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Agolu akolongu nabombi bajetanganiya kabee kunkoma Lazalu, ");
INSERT INTO mgv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ndaba jukuyoka kwaka Lazalu, Ayaudi bingi baakana aka kilongosi babu, nukunhobale Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kilabu jaki, bandu bingi bababiya ahikiki ku tipati ja Pasaka bajogwana Yesu jubi mwindela kuhika ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ndienu bajukuwa mambandi gi mikongu gabagakema mitendi, koni bajenda kunzopa Yesu bakajamaliya kwa sauti ngolongu bakapwaga, “Julumbalikaa Sapanga! Jupengalika hajo jojuika kupete liina laka Bambu. Julumbalika Bambu nkolongu juku Izilaeli.” ");
INSERT INTO mgv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu japata liponda, julikwelalia panani jaki ngati hegapwaga Maandiku ga Sapi. ");
INSERT INTO mgv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mwijogopa mwa bandu buku Sayuni! Lingalya Bambu nkolongu wino jutenda kuhika, jukwei mwana liponda.” ");
INSERT INTO mgv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Banafunzi baki ngasebaheliwi majambu ge gala, lakini Yesu pajayoka nukupata ukolongu, ndi pabakombuka ganigala gabi gaandikwi kundongale jombi bandu bahenga hela ndaba jaki. ");
INSERT INTO mgv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bandu bababi pamu na Yesu kipindi paankema Lazalu kuhuma mulitenge, nukunhyoha, baalandila bandu majambu gala gagapiti. ");
INSERT INTO mgv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Henu bandu bingi bajenda kunzopa, ndaba boka babi ajogwini jutei nginyuli ye hehi. ");
INSERT INTO mgv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Henu, Afalisayu bapwaganiya, “Boo mumbwene? Ngatuwesi kutenda sokape! Lingalia, Bandu boka bupundema batenda kumpwata.” ");
INSERT INTO mgv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Babii Agiliki bangi kati ja bandu bababia ahikiki ku Yelusalemu kunndumbali Sapanga kipindi sukutogule Pasaka sela. ");
INSERT INTO mgv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bunzendila Pilipi, mwenei juku Betisaida ku Galilaya kola, bumpwagila, “Nkolongoo, twaa tupala kumbona Yesu.” ");
INSERT INTO mgv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipi jwajenda kumpwagi Andilea na boka abeli bajenda kumpwagi Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu jwaapwagila, “Lisaa lihikiki Mwana waka Mundu kumpeke ukolongu! ");
INSERT INTO mgv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Numpwagi sakaka, imbeju jimu ji inganu jiigali pee kuba imbeju jimu ngati ejabii, lakini na jiabwiki pai nakuwa jitenda kumela, nukupapa imbeju hingi. ");
INSERT INTO mgv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jojupala womi waki punndema pani jwitenda kuguhoa, lakini jwanga kugupala womi waki punndema pani, jwagubeka mbaka pajwipata womi wa masoba goti. ");
INSERT INTO mgv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jojupala kundumaki nepani lasima jumbwata neepani, pokapi pamii nepani ndi nuntumisi wangu pajwiibia. Mundu jokapi jojundumaki neepani Atati bangu biitenda kundenda.” ");
INSERT INTO mgv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Henu moju wangu gubina ngamaa, henu mbwaga kike? Boo, mbwaga lee, ‘Atati nhokula kipindi senze lakini hikiki ndaba jikipindi senze?’ Lakini ne nhikiki ndaba mbetila kipindi senze. ");
INSERT INTO mgv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atati, ulangia ukolongu waku.” Ndi sauti jajogwanika kuhuma kunani kwaka Sapanga, “Nangi ukolongu wangu na nilangia kabee.” ");
INSERT INTO mgv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bandu bingi bababiya ajemiki pala bajogwa sauti jela, na bangi bapwaga, “Senesi lee kitobe.” Lakini bangi bapwaga, “Ntumi jukunani kwaka Sapanga jutei kulonge naku!” ");
INSERT INTO mgv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lakini Yesu jwaapwagila, “Sauti heji ngasejahikiki ndaba jangu nepani, ila ndaba jinu mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sajenu ndi muda wa bandu bupunndema goni kutemuliwa, henu lijobi jojuwe nkolongu ja ndema jenu ajenda kumboa. ");
INSERT INTO mgv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nepani pabiingwea kunani junndema nanhuta kila mundu kuhika kwangu.” ");
INSERT INTO mgv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kupwaaga kwaki hela, kwalangia kuwa kwaki kuibiya boo. ");
INSERT INTO mgv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nsambi wa bandu gola gwapwaga, “Twepani Malagalaki jitu jitupwagi Kilisitu nkombosi jwitama yaka petapeta. Henu uwesa boo kupwaga eti Mwana waka Mundu biitenda kunkwea kunani? Kilisitu wee hoju nyane?” ");
INSERT INTO mgv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu jwapwaga, “Unang'anu wakona gubi na mwanganya kwa kipindi kijipi. Nzendanya pagubii unang'anu hogu ili lwii lwampata, ndaba jojujenda mu lwii ngasejukumanya kojujenda. ");
INSERT INTO mgv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Henu hembii na unang'anu hogu muguhobalya unang'anu ili mmbia mwabandu bu unang'anu.” Yesu hejwajomula kulonge, jwaboka nukujenda kujoba kutali nunsambi wa bandu gola. ");
INSERT INTO mgv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu pamu nukutenda ndonduke yoka yela pa bandu lakini bombi ngase bunhobalile. ");
INSERT INTO mgv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ndi malobi gajwapwaga Isaya jojabii mlota waka Sapanga gatenda kutimi, “Bambu, nyaa jojugahobali malobi gitu gatwaapwagila? Boo na makili gaka Sapanga gabonikini kwaka nyane?” ");
INSERT INTO mgv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndi, ngasebawesa kuhobale, ndaba Isaya jwapwagiki kabee pandu pangi. ");
INSERT INTO mgv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Sapanga jwatei abiya bangalinga, jatei kuba ang'ang'a, ili biilinga kwa mihu gabu, bielewa kwa malangu gabu, wala biing'anambukii nepani, ili nhwesaa kwaalamisa.” ");
INSERT INTO mgv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya jojabii mlota waka Sapanga jwapwaga malobi haga ndaba jugubweni ukolongu waka Yesu, ndi jalandila majambu gaki. ");
INSERT INTO mgv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata hela, aka kilongosi bingi ba Ayaudi bunhobali Yesu. Lakini ndaba jaaka Afalisayu, ngase bunzetaki palongi ja bandu ndaba jukujogopa kwaatumi mu Manyumba jukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bapai kulumbaliwa na bandu kuliku kulumbaliwa na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ndi Yesu jwapwagiki kwa sauti ngolongu, “Mundu jojunhobale nepani, ngase junhobale nepani pee, ila anhobalee kabee najojundumiki nepani. ");
INSERT INTO mgv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mundu jojumona nepani ambona kabee na jojundumiki nepani. ");
INSERT INTO mgv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nepani nunang'anu, nanepani nhikiki pundema ili miya nunang'anu ili boka ba anhobalee nepani biigali kulwii. ");
INSERT INTO mgv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jojugajogwane malobi gangu lakini ngase jugakamu, nepani nga nunhukumo. Ndaba ngasenahika kutemu bandu bupu nndema pani ila kwaaokoa. ");
INSERT INTO mgv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jwanga kugakamu malobi gangu jubii juku ntemula. Lilobi lee lenumpwaji ndi lukutemula lisoba la mwiso. ");
INSERT INTO mgv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nepani ngase napwagiki ku uwesu wangu na mwete, ila Atati ba andumiki ndi babambwagila mbwaga kii na nongila kii. ");
INSERT INTO mgv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nepani manyiki miilu jaki jileta womi wama soba goka. Henu, nembwaga pee ga anagalaki Atati kugapwaga.” ");
INSERT INTO mgv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Labi lisoba limu kabula ji Lisoba la Pasaka. Yesu jwamanyiki kipindi sukuboka kwaki punndema kujenda kwa Atati lihikiki. Jwabii jwaapai bandu baki boka baabii punndema pani, jwaapai upali wanga na mwiso! ");
INSERT INTO mgv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na banafunzi baki pababia atemi akula posu ja pakamii. Lijobi labi lunzingi Yuda, mwana waka Simoni Isikalioti nukupeke mawasu gu kunng'anambuka Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu jwamanyiki Atati baki babii ampeki kila sindu muuwesu waki, kabee jwamanyiki juhuma kunani kwaka Sapanga na jwabia jukelabuka kujenda kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ndi jwaboka pababia akula posu pala, jwahula ingobu jaki jakunza nukubeka pulutengu, jajukua nsalu nukukonga nkungi mukibunu. ");
INSERT INTO mgv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ndi jwajegala masi mulikalai, nukutumbuli kwaasambisa banafunzi baki magolu na kugahungu ku nsalu gojabii jukongiki mukibunu. ");
INSERT INTO mgv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Henu, paanhikila Simoni Petili, Petili jwapwaga, “Bambu we lee gunzambisa nepani magolo?” ");
INSERT INTO mgv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu jwapwaaga, “Sajenu nga gumanyi sendenda, ila wimanya mwenikatai.” ");
INSERT INTO mgv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petili jwapwaga, “Bambu, kyee weapa ngagunzambisi nepani magolo!” Yesu jwapwaga, “Ana nga nugusambisi magolu gaku ngagukubi gu mbolee wango.” ");
INSERT INTO mgv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petili jwapwaga, “Bambo, gunzambisaje, nga magolu pena, ila na maboku gee ni kimutu see.” ");
INSERT INTO mgv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ampwagila, “Mundu jojuogiki jukuba junyambisiki ngase jupalika kusambisa magolu pee. Mwanganya nnyambisiki, lakini nga mwaboa.” ");
INSERT INTO mgv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ammanyiki joang'anambuka, ndaba jwapwaga, “Mwanganya nnyambisiki, lakini nga mwaboa.” ");
INSERT INTO mgv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu pajwajomula kwaasambisa magolu jawata kabee ingobu jaki, jwatama kabee kula posu, nakwaapwagi, “Boo, mmanyiki lee ganunhengile?” ");
INSERT INTO mgv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mwanganya nngemane nu Mbola na Bambu, mpwaga sakaka, ndaba ndi hemii. ");
INSERT INTO mgv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nepani numbola na Bambu wii, nunsambisi mwanganya magolu, nanamu kubidi nsambisana magolu. ");
INSERT INTO mgv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Numpeki malenganu ili nanamu ntenda ngati enuntendii mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Numpwagi sakaka, ntumi nga nkolongu ngati ejubii bambu wake, wala mundu jobuntumiki ngankolongu kupete jojutuma. ");
INSERT INTO mgv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Henu, hemugamanyi haga, Sapanga jiitenda kumpenge ana mugahengi lihengu. ");
INSERT INTO mgv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gambwaga haga nga ndaba jinu mwanganya mwabote. Nepani naamanyi boka banaahagwi. Lakini lasima gatimia Maandiku gaa Sapi gagapwaga, ‘Mundu jojukulika posu jangu jung'anambwiki nepani.’ ");
INSERT INTO mgv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nepani numpwagi majambu hagaa sajenu kabula ngase gapitii, ili hegiipitila nhwesa kuhobale, ‘Nepani ndi Jojuwe.’ ");
INSERT INTO mgv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Numpwagi sakaka, joanzopa mundu jonuntumiki nepani junyopa nepani, na jojunyopa nepani anzopa jojundumiki nepani.” ");
INSERT INTO mgv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu pajwajomula kupwaga hela, mwoju wa gubina ngamaa, jwapwaga hotuhotu, “Numpwagi sakaka, kati jii jumu jwitenda kung'anambuka!” ");
INSERT INTO mgv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Banafunzi balingalania lakini ngase bummanyiki joandongaliaje. ");
INSERT INTO mgv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mmbolee jumu, jojwabia Yesu ampai ngamaa, jwabia jutemi pambipi na Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Henu Simoni Petili ankinyulia mbolee jola nukupwagi, “Nndalukia andongale nyane.” ");
INSERT INTO mgv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mbolee jola jwahegalia pambipi ngani na Yesu, nukunndaluki, “Bambu, tupwagila gundongale nyane?” ");
INSERT INTO mgv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu jwapwaga, “Jonampekia kipandi silibumunda sendobi mubakuli, ndi jojoju.” Ndi, jwajukua kipandi silibumunda, nukutobe mu bakuli, nukumpeke Yuda, mwana waka Simoni Isikalioti. ");
INSERT INTO mgv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda pajwajopa pee kipandi silibumunda sela, Lijobi latenda kunzingi. Ndi Yesu ampwagila, “Segupala kutenda, tenda nyatanyata!” ");
INSERT INTO mgv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lakini ngaa hata jumu kati jabu babatemi pabakula posu pala, jojwabii jumanyi ndaba jukumpwaga hela. ");
INSERT INTO mgv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndaba Yuda jabiya jutunza mpuku ulupija, bangi bawasalia Yesu ampwagila jujenda kulomba hindu yebiipalika tipati ja Pasaka, au ampwagila jwakapia sokapi kwaka kapuku. ");
INSERT INTO mgv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ndienu, Yuda hejwajukua kipandi silibumunda sela, jwapita kunza. Kipindi se sela sabii ikilu. ");
INSERT INTO mgv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda ejwabiya jubokiki, Yesu jwapwaga, “Henu ukolongu waka Mwana waka Mundu gubonakini, ahelahe ukolongu waka Sapanga gubonakini kupete jombi. ");
INSERT INTO mgv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ana ukolongu waka Sapanga guyekuliwi nkati jaka Mwana waka Mundu, nala Sapanga jilangia ukolongu waka Mwana nkati jaki mweni kabee nga jiselewi kuhenga hela. ");
INSERT INTO mgv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mwabana bangu, nepani nakona mii na mwanganya kwa muda nzipi pee. Mwitenda kundaputa, lakini ganupwaji sajenu nabii naapwagi aka kilongosi ba Ayaudi, ‘Konyenda nepani mwanganya nga nhwesi kujenda!’ ");
INSERT INTO mgv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Henu nupeke miilu minyae, mpalana. Mpalana ngati nepani henumpai mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ana mpalini, bandu boka biimanya mwanganya mwa banafunzi bangu.” ");
INSERT INTO mgv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petili andalukia, “Bambu, gujenda kwako?” Yesu jwapwaaga, “Konyenda nepani ngaguwesi kumpwata sajeno, lakini wimbwata mwenikatai.” ");
INSERT INTO mgv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petili jwapwaga kabee, “Bambo, ndaba jakii nganhwesi kugupwata sajeno? Nepani mitayali kuwa ndaba jako!” ");
INSERT INTO mgv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu ampwagila, “Boo, sakaka lee gubi tayali kuwa ndaba jangu nepane? Nugupwagi sakaka, kabula jukubeka likongobi wiingana mala patatu!” ");
INSERT INTO mgv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu jwaapwagila, “Mwiola myoju jii. Munhobaliya Sapanga, nhobalia na nepani kabee. ");
INSERT INTO mgv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ja Atati bangu ibi yumba ingi, ana ngakwakabi hela nakabiya numpwagi. Henu nyenda kunhandali pandu pukutama. ");
INSERT INTO mgv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nepani nambiti kuhandali pandu pukutama, nikelubuka kunzuku nhika kwangu nepani, ili nanamu mwibia paniibia nepani. ");
INSERT INTO mgv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mwanganya mjimanyi indela jukujenda konijenda.” ");
INSERT INTO mgv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi jwalalukiya, “Bambu, ngase tukumanyi kogujenda, twiwesabo kujimanya indela jene?” ");
INSERT INTO mgv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu jwapwaga, “Nepani ndi indela na sakaka na womi. Nga mundu jojuwesa kujenda kwa Atati ila kupete kwangu nepani. ");
INSERT INTO mgv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ana mwakamanyi nepani, mwakaamanya na Atati bangu. Tangu sajenu mwaamanyi Atati kabee mwaambweni.” ");
INSERT INTO mgv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipi ampwagila, “Bambu, utulangia Atati ndi setupala.” ");
INSERT INTO mgv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ampwagila, “Ndemi na mwanganya masoba goti haga, wa Pilipi ngase gumanyi nepane? Jojumweni nepani jwaabweni Atati. Henu guwesabo kupwaga, ‘Tulangia Atate?’ ");
INSERT INTO mgv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Boo, ngase uhobale nepani mii nkati ja Atate, na bombi atati abii nkati jango? Malobi ganumpwagi mwanganya ngasegahuma kwango, Ila gahuma kwaka Atati bangu baabi nkati jangu atenda lihengu laki. ");
INSERT INTO mgv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mpalika kunhobale nenga hembwaga nepani mii nkati ja Atati na Atati abii nkati jangu. Ana ngasenhobale nhobalia ndaba ja mahengu ganihenga. ");
INSERT INTO mgv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Numpwagi sakaka, jojunhobale nepani jwitenda mahengu gandenda nepani. Ena, jwitenda makolongu ngani kupeta yenhengiki nee, ndaba nyenda kwa Atati. ");
INSERT INTO mgv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sokapi semwiloba kupete liina langu mbaka ndendi, ili Atati alumbalika kwii indela jaka Mwana. ");
INSERT INTO mgv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ana nnobiki sokapi kupete liina langu, mbaka ndendi. ");
INSERT INTO mgv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ana mnipai, mwikamula miilu jangu. ");
INSERT INTO mgv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nane naaloba Atati na bombi bampeki Jukunzangati jongi, jojwitama na mwanganya yaka petapeta. ");
INSERT INTO mgv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jojuwe ndi Loho jaka Sapanga jojutupwaji sakaka majambu gaka Sapanga. Bandu bupundema ngaseawesa kunzopa ndaba ngase awesa kumbona wala kummanya. Lakini mwanganya mumanyi ndaba juhigii na mwanganya kabee jubi nkati jinu. ");
INSERT INTO mgv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nganundeki mwanganya kajika jinu ngati mwakeba, nihika kabee kwinu. ");
INSERT INTO mgv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Guigali muda nsokopi, na bandu bupunndema pani ngaamoni kabee. Lakini mwanganya mbaka mmoni, ndaba nepani mi na womi, na mwanganya mwibia mwa bomi. ");
INSERT INTO mgv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lisoba le heli paliika ndi pamwimanya nepani mi nkati ja Atati bangu, na mwanganya mmbi nkati jangu, na nepani nkati jino. ");
INSERT INTO mgv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Jokapi jojujopa miilu jangu nukuikamu, hoju ndi jojumbala, na jojumbala nepani Atati bangu biitenda kumpala, nane nampala nukulilangi kwaki.” ");
INSERT INTO mgv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda nga nsikalioti jola, andaluki Yesu, “Bambu, boo walilangia kwitu twepani lee badala jukulilangi kwa bandu bupunndema pane?” ");
INSERT INTO mgv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu jwapwaga, “Mundu na jumbai nepani jalijowaniya lilobi langu, na Atati bangu biitenda kumpala, Atati nane twiika kwaki nukutama nkati jaki. ");
INSERT INTO mgv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jwanga kumbalane ngajujowane malobi gango. Namalobi gannyogwini nepani nga gangu nepani, ila gaa Atati baandumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Numpwagi malobi haga koni nakona mii pamu na mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lakini Jukunzangati mwanganya, Loho jaka Sapanga, jo bantuma Atati kupete liina langu, jwammbola kila sindu nuku nkombosa goti ganumpwaagi.” ");
INSERT INTO mgv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nundeke lukwali, numpeke lukwali lwangu. Lukwali lonumpeke nepani nga ngati loapia bandu bupundema pane. Mwihola mmiojuji, wala mwijogopa. ");
INSERT INTO mgv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwanyogwini panapwaga, ‘Nendenda kuboka, lakini niihika kabee.’ Ana nee mmbaii, mwakabia ntoguli ndaba nyenda kwa Atati, ndaba Atati nkolongu kupeta nepani. ");
INSERT INTO mgv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Numpwagi ganiaga sajenu kabula ngasegapitii, ili pagiipitila nhwesa kuhobale. ");
INSERT INTO mgv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nga nongee na mwanganya kabee majambu gingipi, ndaba lijobi kilongosi ju nndema goni jutenda kuhika. Lakini nepani ngasejunhwesa kundenda sindo, ");
INSERT INTO mgv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakini bandu bupundema pani apalika kumanya naapai Atati, nane ndenda kila sindu ngati Atati heandumiki.” Nzemaniya tubokaniya pambane! ");
INSERT INTO mgv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nepani nunzabibu wa sakaka na Atati bangu ndi jojulema. ");
INSERT INTO mgv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila limbandi nkati jangu langa kubeleka matunda jutenda kuliseku. Kila limbandi lelibeleka jutenda kulisekuli ili libelika ngani. ");
INSERT INTO mgv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwanganya tayali mmbi sapi ndaba ja malobi ganumpwagi. ");
INSERT INTO mgv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ntama nkati jangu nanepani ndama nkati jii. Ngati helibii limbandi ngaseliwesa kupapa matunda kajika ana ngaselitemi mu nzabibu, ndi nanamu nganhwesi kupapa matunda bila kutama nkati jangu.” ");
INSERT INTO mgv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nepani nunzabibu, na mwanganya ndi mambandi. Jojutama nkati jangu, nanepani anami nkati jaki, hoju jupapa matunda gingipi, ndaba bila nepani nganhwesi kutenda sokapi sela. ");
INSERT INTO mgv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu jokapi ana ngasejutemi nkati jangu bundeke kunza ngati limbandi lebileke kunza nukujoma. Mambandi ngati haga bandu bagatondo nukugaleke kumotu ili gatinyika. ");
INSERT INTO mgv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ana ntemi nkati jangu na malobi gangu na gatemi nkati jinu, henu nndoba sokapi sempala mwitenda kupata. ");
INSERT INTO mgv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Atati bangu atenda kulumbaliwa ana mpapiki matunda gingipi nukupete hela nkuba mwa banafunzi bangu. ");
INSERT INTO mgv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nenumpai mwanganya ngati Atati heambai nepani. Ntama muupali wangu. ");
INSERT INTO mgv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ana nzetaki miilu jangu mwiitama muupali wangu, ngati nepani henyoani malagalaki ya Atati bangu nukutama mu upali waki.” ");
INSERT INTO mgv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Numpwagi majambu haga ili kutogule kwangu kutama nkati jino, nukutogule kwinu kukamilikaje. ");
INSERT INTO mgv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jenze ndi miilu jangu, mpalana ngati henumpai nepani mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nga upali gogubi nkolongu ngani kupeta upali waka mundu kuguboa womi waki ndaba jaakosi baki. ");
INSERT INTO mgv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwanganya mwibia mwaakosi bangu nantei ganundagalaki. ");
INSERT INTO mgv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mwanganya nga nunkemi mwaatumisi, ndaba ntumisi ngasejumanya sejuhenga nkolongu waki. Lakini nepani nunkemiki mwanganya mwaakakosi bangu, ndaba numanyisi goti ganyoini kuhuma kwa Atati bangu. ");
INSERT INTO mgv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mwanganya ngasemwahaagwi nepani, nepani nunhagwi mwanganya, nuntuma nnzenda mwakaabelika matunda gingi, matunda ganga kuhoba ndi mahengu ga sapi. Nabombi Atati awesa kumpeke sokapi semwaaloba kupete liina langu. ");
INSERT INTO mgv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ndienu miilu jangu kwinu ndi jenze, mpalana.” ");
INSERT INTO mgv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ana bandu bupundema pani bunsuki mwanganya, nkombuka biibiya anzuki nepani kabula jukunsuki mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ana mwakabii mwa bandu bupundema pani, bandu bupundema pani bakabiya bupai mwanganya ngati bandu babu, lakini ndaba mwanganya nga mwabandu bupundema pani ila nepani nuwagwi kuhuma pundema. Ndaba jahela bandu bupundema pani bunsuki mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nkombuka ennupwaji ntumisi nga nkolongu kupeta bambu waki. Ana bandu andesiki nepani hata mwanganya bitenda kuntesa, ana ajetaki malobi gangu nepani bijetakiya malobi ginu mwanganya kabee. ");
INSERT INTO mgv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lakini ganaga goti bantendila mwanganya ndaba mwanganya mwabandu bango, ndaba ngasebumanyiki jombi jojundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ana nganakahikiki nukulonge nabu nabombi ngabakabii namahakao, lakini henu nganhwesi kupwaga ngase abii na mahakau. ");
INSERT INTO mgv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jojunzuki nepani, jaasuki kabee na Atati bango. ");
INSERT INTO mgv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ana nganakahengiki kwabu majambu gaguge mundu jokapi jojawaiki kuhenga ngabakabii na mahakao, lakini henu biibweni ndonduke yenahengiki anzuki nepani nakabee baasuki na Atati. ");
INSERT INTO mgv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Majambu ge haga gapiti ili kutimisa gala gahandiki mu Malagalaki gabu, ‘Anzuki bwaka!’ ” ");
INSERT INTO mgv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pajihika Jojujangati hoju jonantuma kwinu kuhuma kwa Atati, hoju ndi Loho jaka Sapanga jojampwagila sakaka kuhusu Sapanga. Nantuma kwinu kuhuma kwa Atati najombi jinongaliya nepani. ");
INSERT INTO mgv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Namwanganya kabee mwapwagila bandu kuhusu nepani, ndaba mwabii na nepani toka panatumbuliya lihengu langu.” ");
INSERT INTO mgv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Numpwagi majambu goti haga ili mwikotoka kuhobale kwino. ");
INSERT INTO mgv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bandu bambenga mwanganya mma nyumba jukuketangane Ayaudi. Kabee sihika kipindi kila mundu jojwaankoma mwanganya jihambusiya anhenge lihengu Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bantendila hela ndaba ngasebaamanyiki Atati wala nepani. ");
INSERT INTO mgv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Lakini numpwagi mwanganya majambu haga, ili lisaa lee heliika mwingombuka nepani numpwagi. “Ngasenumpwagi majambu haga toka panaatumbuliya kuketangana na mwanganya ndaba nabii pamu na mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Lakini henu nunzendee jojundumiki jola, na ngakuba hata jumu winu jojumbwagi nyenda kwaa. ");
INSERT INTO mgv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ndaba nepani numpwagi malobi haga, mioju jinu jibiniki ngamaa. ");
INSERT INTO mgv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakini nepani numpwagi sakaka, nambanga kwinu nepani moka, ndaba anangasemokiki Jukujangatii hoju ngajwiiki kwino. Lakini anamokiki namtuma kwinu. ");
INSERT INTO mgv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Najombi ejwihika jwalangia bandu bupu ndema ngaseamanyi usakaka wa mahakau, usakaka wa gajupala Sapanga na usakaka wa na utemu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jaalangia usakaka wa mahakau, ndaba ngaseanhobale nepani, ");
INSERT INTO mgv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","jalangia usakaka wa gajupala Sapanga ndaba nepani nyenda kwa Atati. ");
INSERT INTO mgv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jaalangia usakaka kuhusu Sapanga kwaatemu bandu, ndaba nkolongu ju nndema goni juhukumiwi tayali.” ");
INSERT INTO mgv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nakona mii na majambu gingi gukumpwagi, lakini nganhuwesi kugakamu goha. ");
INSERT INTO mgv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lakini pajwihika Loho jaka Sapanga jandongua muu sakaka woti kuhusu Sapanga. Ngajipwagi kupete uwesu waki mweni, ila jwipwaga gajwijoa kuhuma kwa Atati nukummanyisa gagihika. ");
INSERT INTO mgv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jombi jwinumbaliya nepani ndaba jagajukua ganalongi nepani nu kumpwaji mwanganya. ");
INSERT INTO mgv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yoti yeabinaku Atati ndi yangu. Ndi maana bwagiki Loho hoju jwijukua gagabii gangu nepani nukumanyisa mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Sakoni kipindi kisokopi pena mwanganya ngamwimone na kabee esipeta kipindi kisokopi mwindenda kumona kabee.” ");
INSERT INTO mgv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Banafunzi bangi balaluana, “Jubii na maana boo ejupwaaga, ‘Sakoni kipindi kisokopi mwanganya ngamwimoni na kabee sakoni kipindi kisokopi mwanganya mbaka mwiimoni?’ Kabee jubii na maana bole ejupwaaga, ‘Ndaba nyenda kwa Atate!’ ");
INSERT INTO mgv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Baendaliya kulaluana, jubii na maana bo ejupwaga, ‘Sakoni kipindi kisokope?’ Ngasetuelewa sejupwaga.” ");
INSERT INTO mgv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu jamanyiki apala kundaluki, ndienu jaapwagila, “Boo ndaluana le kupete ganapwaaga, ‘Sakona kipindi kisokopi ngamwimone, na esipeta kipindi kisokopi kabee mbaka mwimone?’ ” ");
INSERT INTO mgv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Numpwagi Sakaka, mwanganya mwilela nukulobalake, lakini bandu bupunndema biitenda kutogulela. Mwibona usungu lakini usungu winuu wing'anumbuka mwitenda kutogulela. ");
INSERT INTO mgv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kipindi mmbomba ejuegale kubeleka mwoju gumbina ndaba lisaa lukubona usungu guhikiki. Lakini najubeliki tayali ngasejukomboka ndaba jukutogule mwana na jusaliwi. ");
INSERT INTO mgv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nanamu kabee mbii nu ubini sajenu, lakini nanhikila kabee nanamu mwitenda kutogule mioju jinu nukutogule kweehoku nga mundu jojwiwesa kukuboa kutogulee kweehoku. ");
INSERT INTO mgv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Lisoba le heli ngamwinobi sokapi. Numpwagi sakaka, sokapi semwaaloba Atati kwi liina langu, jombi jiitenda kumpeke. ");
INSERT INTO mgv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka sajenu ngasenndobiki sokapi ku liina langu. Nndoba nanamu mbaka mpati ili kutogule kwinu kutimia. ");
INSERT INTO mgv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Numpwagi majambu haga sa malenganu, lisaa lihika nganilonge na mwanganya kwa malenganu kabee, lakini kipindi kihika nampwagila hotuhotu majambu ga Atati. ");
INSERT INTO mgv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lisoba le heli mwiloba kwi liina langu, ngasenumpwagi naaloba Atati badala jino. ");
INSERT INTO mgv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ndaba Atati beni bumpai mwanganya. Ndaba mwanganya mmbai nepani nukunhobale nepani nhumiki kwaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","nepani nhumiki kwa Atati, nukuhika kundema, henu nuuleka nndema nukukelabuki kwa Atati.” ");
INSERT INTO mgv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ndienu banafunzi baki bumpwagila, “Henu gupwaga pagwendu sanga kutumii malenganu. ");
INSERT INTO mgv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Henu tumanyiki wehapa ugamanyiki majambu goti, wala nga kupalika mundu kulaluki maswali. Kwa majambu haga tuhobale sakaka guhumiki kwaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu japwaaga, “Boo, sajenu lee nhobalela? ");
INSERT INTO mgv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kihika kipindi, kabee kihikiki pamwilekana kila mundu kujenda kunyumba jaki, nukuneka kajika jangu. Lakini nepani ngase mii kajika jangu ndaba Atati abii pamu na nepani. ");
INSERT INTO mgv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Numpwagi majambu ge haga ili mbia nu lukwali mukujongana na nepani. Punndema pani mwipata mang'aliku lakini mulipekia makili. Ndaba nepani nagawesiki majambu gupu nndema!” ");
INSERT INTO mgv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu ejwajomula kupwaaga ganiaga, jalinga kunani kwaka Sapanga nukupwaaga, “Atati lisaa lela lihikike! Gumpekiya Mwana waku ukolongu ili najombi Mwana jugupekiya ukolongu. ");
INSERT INTO mgv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ndaba umpeki Mwana waku uwesu kwa bandu boti ili jwapekia womi wa masoba goa gaumpeki. ");
INSERT INTO mgv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na womi wa masoba goa ndi gongo, bandu bugumanya weapa kajika jaku ndi Sapanga wa sakaka na Yesu Kilisitu joguntumiki. ");
INSERT INTO mgv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nepani nugupeki ukolongu wehapa pundema nukujomo lihengu leumbeki kuhenga. ");
INSERT INTO mgv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Henu mwa Atati mmbekya ukolongu palongi jaku sajenu, ngati ulumbi gola gonabii naku kabula jukubomba ndema.” ");
INSERT INTO mgv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nugumanyisi kwa bandu boka baumbeki kundema. Babi bandu baku nawe wambekya abia bandu bangu, nabombi bilijoini lilobi laku. ");
INSERT INTO mgv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Henu amanyiki hindu yoti yegumbeki ihumiki kwaku. ");
INSERT INTO mgv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nepani naapeki malobi gaumbeki nabombi bagajopikii. Henu amanya sakaka nhumiki kwaku na ahobali wehapa ndi joundumiki.” ");
INSERT INTO mgv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Naalobe bombi. Ngasenaalobe bandu bupundema ila naalobee bagumbeki, ndaba ndi baku. ");
INSERT INTO mgv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Goka gami naku gaku, na gaku gangu, na ukolongu wangu gumanyikini kwa bandu bagumbeki. ");
INSERT INTO mgv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Henu nhika kwaku, nganiendele kutama kabee mundema, lakini bamba biendaliya kutama mundema. Atati baa Sapi! Kwa makili giliina laku legumbeki, noba walinga, ili abia bamu ngati twepani etubi pamu. ");
INSERT INTO mgv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panabii pamu nabu, nepani naalendiki kupete makili giliina laku lewambeki. Nga mundu hata jumu jojuhobiki, ila pee jojahoba jola ili Maandiku gaa Sapi gatimia. ");
INSERT INTO mgv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ndienu nhika kwaku, nane mbwagiki majambu haga kundema, ili nabombi abiya mukutogule kwango. ");
INSERT INTO mgv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nepani naapeki lilobi laku, bandu bapandema batenda kwaasuki ndaba bombi ngabandu bupundema pane, ngati nepani hemi nga jupunnndemapani. ");
INSERT INTO mgv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ngasenoba waboa pundema, ila walonda kuhuma kwaka Mbaja jola yani Lijobi. ");
INSERT INTO mgv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bombi nga bandu bupundema, ngati nepani ezindiki kuba upundema. ");
INSERT INTO mgv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wahenga abiya bandu baku baasapi kupete sakaka jaku, lilobi laku ndi la sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngati ewanduma nepani pundema, nane naatumiki bombi pundema. ");
INSERT INTO mgv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ndaba jabu nilipia namweti kwaku, ili na bombi ahelahe bilipia kwaku su usakaka.” ");
INSERT INTO mgv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ngasenaalobe bombi kajika, ila naalobe kabee boti balababi nhobaliya kupete lilobi lango. ");
INSERT INTO mgv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Noba ili boti abia bamu. Atati, noba abiya nkati jitu ngati wehapa egubii nkati jangu nane nkati jaku. Noba abiya bamu ili bandu bupundema ahobaliya wehapa ndi wogundumiki. ");
INSERT INTO mgv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nepani numpeki ukolongu agolago gogwambekiya nepani, ili abiya bamu ngati twee etubii pamu. ");
INSERT INTO mgv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nepani miya nkati jaku nawe nkati jango, noba wahenga abiya bamu ngani ili ndema gumanya gundei kunduma, nane napai bombi ngati egumbai nepane.” ");
INSERT INTO mgv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Atati! Mbala bagumbeki haba abiya pamu na nepani panguba, ili bugubona ukolongu wangu gogumbeki, ndaba watei kumbala kabula jukubomba nndema. ");
INSERT INTO mgv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Atati ba amboni, bandu bupundema ngase bugumanyi, lakini nepani nugumanyiki. Haba nabombi amanyiki wehapa watei kunduma. ");
INSERT INTO mgv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naatei bombi akumanya weapa na musiendaliya kuhenga aendalia kugumanya ili upali gogubinaku kwangu gubiya nkati jabu nane miya nkati jabu.” ");
INSERT INTO mgv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu ejajomula kundoba Sapanga, jaboka na banafunzi baki balombuka kikoka suku Kidiloni. Pandupe pala sakabii kijongu, jombi Yesu na banafunzi baki bajingala homu. ");
INSERT INTO mgv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda joa ang'anumbuka Yesu, japamanyiki pandu pala ndaba mala jingi Yesu jukubika juketangana na banafunzi baki. ");
INSERT INTO mgv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ndienu, Yuda jahika kukijongu pamu nu nsambi wa alonda bikilumi na alonda ba Nyumba jaka Sapanga kuhuma kwaka Agolu na Afalisayu bababia baatumiki, babii na haya ya miotu ni ibonga na hindu yukukomane. ");
INSERT INTO mgv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ndienu Yesu jojabia jumanyiki goti gagampata jaahegaliya nakaalaluki, “Boo muntaputa nyanee?” ");
INSERT INTO mgv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nabombi bapwaga, “Yesu juku Nazaleti!” Yesu jaapwagila, “Ndi nepane!” Yuda joang'anambuka Yesu jajemiki papuje pamu nabu. ");
INSERT INTO mgv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ndienu Yesu jaapwagila, “Ndi nepane,” bakelubuka kunyuma nukuhabuka pai. ");
INSERT INTO mgv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu jaalalukiya kabee, “Muntaputa nyane?” Nabombi bumpwagila, “Yesu juku Nazaleti!” ");
INSERT INTO mgv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu japwaagila, “Ne numpwagi ndi nepani. Ndienu ngati nndaputa nenga, mwaaleka banganya ajendannya.” ");
INSERT INTO mgv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Japwaaga haga ili gatimia gabapwaaga, “Atati, bawambeki bala ngasenahoiki hata jumu.” ");
INSERT INTO mgv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petili jojabii nu upanga, jaholumula, anunkula likutu luku malele ntumi waka Nngolu Nkolongu. Ntumi we hoju ankemika Malukusi. ");
INSERT INTO mgv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu ampwagila Petili, “Kelubua mpamba waku munhaku waki. Boo niikunywa le kikombi sukung'alika seambeki Atate?” ");
INSERT INTO mgv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nsambi wa alonda pamu na kilongosi jaalonda bikilumi bumkamula Yesu, nukunkonga, ");
INSERT INTO mgv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","batumbuliya kumpeleka kwaka Anasi, na Anasi jabiya nkowanu waka Kayafa jojuwe jojabii nngolu nkolongu wa saka sela. ");
INSERT INTO mgv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa we hoju ndi jojabiya jaapwagila Ayaudi nambanga mundu jumu kuwa ndaba ja bandu. ");
INSERT INTO mgv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petili na banafunzi bangi bumpwata Yesu. Mmbolee jongi jabiya jumanyikana kuku Nngolu Nkolongu, ndienu jajenda pamu na Yesu nkati ja hua jaka Nngolu Nkolongu. ");
INSERT INTO mgv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lakini Petili jabiya jujemiki kunza pambipi ni litanga. Ndienu, mmbole jongi we hoju jojabiya jumanyikana kwaka Nngolu Nkolongu japita nukulongee nu ntumisi mmbomba, jojuhenga lihengu lukuhogo nukupunga litanga anzingia Petili nkati. ");
INSERT INTO mgv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mmbomba we jola andalukiya Petili, “Boo wehapa le nga jumu wa banafunzi baka mundu hajojo?” Petili ampwagila, “Ngasenummanyi mundu we hojo!” ");
INSERT INTO mgv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Atumi na alonda babiya anyata mwotu ndaba sabii kipepu, babiya akoiki papuje. Najombi Petili jabiya jujemiki pamu nabu bakanyata mwotu. ");
INSERT INTO mgv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kipindi aselase, Nngolu Nkolongu jabiya andaluki Yesu majambu ga banafunzi baki na mabolee gaki. ");
INSERT INTO mgv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu japwaaga, “Nongee pagwendu mbeli ja bandu boti. Masoba goti molika mu Nyumba juku ketangane Ayaudi nu ku Nyumba jaka Sapanga, papuje Ayaudi boti paaketangane ngasenapwaga lijambu lokapi puujobu. ");
INSERT INTO mgv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ndaba jakii kunaluki nepane? Walalukiya babajoannya naapwagila ki. Bombi ndi amanyiki ganaapwagila.” ");
INSERT INTO mgv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu pajajomula kupwaaga haga, nndonda jumu jojabii jujemiki papu andapula Yesu likopi kumihu koni jupwaaga, “Boo ndi le egumpwagi Nngolu Nkolongo?” ");
INSERT INTO mgv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ampwagila, “Ana ngati mbwagiki liyaa, langia uliya wene kwa bando, lakini na mbwagiki sapi, mbona gunapula?” ");
INSERT INTO mgv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ndienu, Anasi ampelika Yesu koni ankongiki kwaka Nngolu Nkolongu Kayafa. ");
INSERT INTO mgv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petili jabiya jakoni jakanyata mwotu, andalukiya, “Boo wehapa le nga jumu ja banafunzi bake?” Jombi jakana kukupwaaga, “Nganenga!” ");
INSERT INTO mgv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ntumisi jumu jwaka Nngolu Nkolongu, ndongu waka mundu joansekula Petili likutu, andalukiya, “Boo, nepani ngasenugubweni kukijongu kola pamu na Yesu?” ");
INSERT INTO mgv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petili japwaaga kabee, “Ngahela” Apalapa likongobi latenda kubeka. ");
INSERT INTO mgv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ndienu pakwahika pulukela bunzukua Yesu kuhuma kwaka Kayafa, nukumpeleka ku kunyumba ju ubambu lu ukolongu la Aloma. Lakini bombi ngasebajingala nkati ndaba bii kuba apija ila abiya sapi palongi jaka Sapanga ili awesa kula Lisoba lukutogule Pasaka. ");
INSERT INTO mgv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ndienu Pilatu japita kunza kobabii, jalalukiya, “Muntaki jubii na magambu boo mundu we hojo?” ");
INSERT INTO mgv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bombi bumpwagila, “Ana mundu we hoju jakabia ngasejuhengiki uliyaa ngatukunndetiki kwako.” ");
INSERT INTO mgv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu ampwagila, “Ndienu munzukua mwanganya mukuntemula kukupwata Malagalaki.” Ayaudi bapwagila, “Twepani ngasetubii nu uwesu uku kutemu mundu jokapi jukuwa.” ");
INSERT INTO mgv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gahengika hela ili gatimia Malobi ga Sapi gajapwaga Yesu kulangi jiikuwa kwi indela boo. ");
INSERT INTO mgv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatu jajingala kabee nkati ja nyumba jaki, ankema Yesu nukundaluki, “Boo, wehapa lee wa Bambu Nkolongu wa Ayahude?” ");
INSERT INTO mgv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu japwaaga, “Boo, ganiaga le malobi gaku au bandu bangi agupwagi majambu gango?” ");
INSERT INTO mgv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu jaapwagila, “Boo, ne lee nga nu Nhyahude? Bandu baku naka agolu aguletiki kwa minepani. Gutei kyane?” ");
INSERT INTO mgv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu jaapwagila, “Ukolongu wa minepani nga gundema gone. Ukolongu wane wakabii gupundema gongo apwasi bangu bakabia anyangati biingamu aka kilongosi ba Ayaudi. Lakini henu Ubambu Ukolongu wangu nga waapane.” ");
INSERT INTO mgv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Papuje Pilatu japwaagila, “Ndienu, wehapa le wa Bambu Nkolongu?” Yesu jaapwagila, “Wehapa gupwaiki nepani na Bambu Nkolongu. Nepani melikwi ndaba ja majambu haga, na kwa ndaba heji nhikiki pundema kaapwagi bandu majambu ga Sakaka. Kila mundu jojupala sakaka jutenda kunyoane.” ");
INSERT INTO mgv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu ampwagila, “Sakaka ndi sindu bole?” Pilatu ejajomula kupwaaga lilobi heli, japita kabee kunza nakaapwagi Ayaudi. “Nepani ngasenilibweni likosa lokapi laka mundu we hojo. ");
INSERT INTO mgv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lakini kila saka nhyobali nepani, nunhogule mpungwa jumu kipindi sukutogule Pasaka. Boo, mpala nunhoguliya nkolongu jwa Ayahude?” ");
INSERT INTO mgv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Papuje bajamaliya, “Nga hojo, ila utuhoguliya Balaba!” Najombi Balaba jakabii jojanyaga bandu hindu. ");
INSERT INTO mgv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ndi Pilatu jalagalakiya, bunzukua Yesu nubundapula iboko. ");
INSERT INTO mgv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Akamanzolinzoli baloka seketule ja miha bunhwatika Yesu kumutu, nukunhwatika lingobu la zambalau. ");
INSERT INTO mgv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Babiya ahika palongi jaki nukupwaaga, “Jambuoti! Bambu Nkolongu wa Ayaudi!” Koni akundapula makopi kumihu. ");
INSERT INTO mgv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu japita kunza kabee nukupwa, “Nndinga nundeta kabee kwinu ili mmanya nepani ngasenugubweni uliya wokapi kwaki.” ");
INSERT INTO mgv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ndienu, Yesu japitila kunza juweti seketule ja miha na ingobu ja langi ja zambalau juu bambu. Pilatu ampwagila, “Nndinga, mundu we jonzone!” ");
INSERT INTO mgv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Agolu akolongu na alonda pabumbona batenda kujamaliya, “Umbambaliya punsalaba! Mumbambaliya puunsalaba!” Pilatu jaapwagila, “Munzukua mwabee mukumbambaliya punsaba, nepani ngasenilibweni lihakau lokape kwaki.” ");
INSERT INTO mgv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayaudi bapwaaga, “Twe tubii na Malagalaki gitu, na kwa Malagalaki ge haga mundu we hoju kupalika kukomeka, ndaba julikema Mwana waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu ejajoa haga, jajogopa ngani. ");
INSERT INTO mgv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jajingala kabee pa nyumba ju ubambu ukolongu nukundaluki Yesu, “Wehapa guhumi kwako?” Lakini Yesu ngasejapwaaga lilobi. ");
INSERT INTO mgv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndienu Pilatu ampwagila, “Wehapa gukana le kulongee na nenga? Ngasegumanyiki le minu uwesu gukugulekake au kugubambali punsalaba?” ");
INSERT INTO mgv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu japwaga, “Wehapa nga wakabii nu uwesu wokapi kwangu nepani ananga ngawakapatiki kuhuma kwaka Sapanga. Henu jojunetiki kwaku wehapa hoju ndi jubii na kihakau kikolongu nakanopi?” ");
INSERT INTO mgv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tumbuka hapa, Pilatu jabiya jutaputa indela jukundekake Yesu lakini Ayaudi batenda kujamali, “Ana gundekaki mundu ajo, wehapa nga gunkosi waka bambu nkolongu juku Loma, kila mundu jojilikema bambu nkolongu ankana bambu nkolongu juku Loma.” ");
INSERT INTO mgv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatu ejajoa malobi gala andeta Yesu kunza jatama pumpandu waki gukutemu, pandu pabapakema lubanza lwa malibu, kwi kiebulania akema Gabata. ");
INSERT INTO mgv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lisoba le heli labiya lukuandaa Pasaka, pambipi ni lisaa la sita lioba mutu. Pilatu jaapwagila Ayaudi, “Ndinga, Bambu Nkolongu winu ajo!” ");
INSERT INTO mgv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bajamaliya, “Munkoma! Munkoma! Gumbambaliya punsalaba!” Pilatu andalukiya, Mpala le numbambaliya Nkolongu wi pu nsalaba. Akolongu ba agolu bajibua, “Twepani nganu nkolongu jongi ila nkolongu juku Loma.” ");
INSERT INTO mgv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndipala Pilatu ampia Yesu kwabu ili bummbambaliya punsalaba. Ndienu alonda bunzukua Yesu ");
INSERT INTO mgv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu jaboka jutotwi nsalaba waki, baboka kujendane pandu pabapakema, “Lihupa lu umutu,” kwi kiebulania akukema ku Goligota. ");
INSERT INTO mgv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pabumbambaliya Yesu punsalaba, pamu najombi bapumbambaliya punsalaba na bandu bangi abeli babambaliya pumisalaba jabu, jumu kumangega na jongi kumalele kwaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu jaaandika kibau sekisomeka, “Yesu juku Nazaleti Bambu Nkolongu jwa Ayahude.” Panani ju nsalaba waka Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayaudi bingi basoma kibau se hesi, ndaba pandu pabummbambaliya Yesu pakabii pambipi na Musi. Kabee kibau se hesi sabiya aandiki kwi kiebulania ni kilatini ni kigiliki. ");
INSERT INTO mgv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ndienu Agolu Akolongu ba Ayaudi bumpwagila Pilatu, “Wiihandika, ‘Bambu Nkolongu wa Ayaudi, ila andika ana, mundu jonzo japwaaga, nepani na Bambu Nkolongu wa Ayaudi.’ ” ");
INSERT INTO mgv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu japwaaga, “Ganhandiki, ndi handiki!” ");
INSERT INTO mgv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Alonda pababiya ammbambalii Yesu, bajukua ingobu yaki babaga mapungu nsesi, lipungu limu kwaka kila mlonda. Bajukua kabee kanzu jaki, kanzu je jela jabia alenganaki kukitambaa simu bila lutotu. ");
INSERT INTO mgv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bapwagannya, “Twijendu ila tupega gudugudu ili tumanya jujukuu nyaa.” Haga ndi gabahenga aka alonda bala. “Babagana ingobu yangu, na kanzu jangu bakinila gudugudu.” Ndi hebahenga aka alonda. ");
INSERT INTO mgv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pambipi nu nsalaba waka Yesu, babiya ajemiki na amabu baki, na nndombu wa amabu na Malia nhwanu waka Kileopa, na Malia juku Magidala. ");
INSERT INTO mgv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu ejaabona amabu baki, ajemiki pamu nu mbolee joampai, jajema pambipi nakapwaagi amabu, “Amabo, nndinga hoju ndi mwana wako.” ");
INSERT INTO mgv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ndipala ampwagila mmbole jola, “Linga aba ndi amabu baku.” Tumbuka lisaa lela mmbolee jaajukua nukujenda kutama naku kunyumba jaki. ");
INSERT INTO mgv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu ejabona goti gatimii, na ili Maandiku ga Sapi gatimia japwaaga, “Nilijoane nywita.” ");
INSERT INTO mgv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Papuje kwabii na sombu sekitweli divai jejibabiki. Ndienu batobakiya kipongu divai jejibabiki, bakonga panani julundonga lunkongu wa hisopu, nukumbeke pundomu. ");
INSERT INTO mgv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu ebumpekia divai je jela, japwaaga, “Goka gatimie!” Ndipala jajinamisa mmutu, nakuwa. ");
INSERT INTO mgv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ndaba kwabiya lisoba lukuandaa tipati ja Pasaka, Ayaudi ngasebapai nhyega ihigaliya punsalaba Lisoba lu Kupomulela, ndaba lisoba le heli labii Lisoba lu Kupomulela. Aka kilongosi ba Ayaudi bundoba Pilatu magolu ga bandu baabambaliwi bala bijitunula na nhyega yabu biiboa punsalaba ndaba lisoba le heli labia likolongu lakajika. ");
INSERT INTO mgv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ndienu alonda bajenda ili baatunula magolu gaka mundu ja kwanza jojakomika pamu na Yesu na jongi we jola kabee. ");
INSERT INTO mgv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lakini ebunhikila Yesu, bunkolila juwile, ndienu ngasebatunula magolu gaki. ");
INSERT INTO mgv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakini nndonda jumu antonga nkoa muluteta Yesu apalapa wapita mwai na masi. ");
INSERT INTO mgv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mundu jojagabweni majambu ge haga ndi jojapwaaga hotuhotu ili nanamu nhwesa kuhobale, na malobi gajapwaaga ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lijambu le heli lihengiki ili Maandiku ga Sapi gatimia, “Nga lihupa laki hata limu leliitunuka.” ");
INSERT INTO mgv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kabee Maandiku gangi gapwaaga, “Bandingaliya jobaantonga nkoa.” ");
INSERT INTO mgv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Egajomuka haga, Josepu juku Alimatayo andoba Pilatu anzetakiya kuhulu nhyega jaka Yesu kuhuma punsalaba. Josepu jabiya mmbole waka Yesu, lakini sanga bandu kumanya ndaba jajogopa aka akolongu buku Uyahudi. Ndienu Pilatu anzetakiya, ndienu Josepu jajenda nukuhulu nhyega jaka Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josepu jalongini na Nikodemu jojuwe jawahiki kunzende Yesu ikilu, jahika nukuleta mahuta gabagakema manemane gahangangini nu ubani kilu selasini. ");
INSERT INTO mgv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ndienu bandu abeli bajukua nhyega jaka Yesu, bakonga ingobu nhuu pamu na mahuta ngati ebayobali kutaga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pandu paakomila Yesu pakabii ni kijongu, ni kijongu se hesi kwabii lipoli linyai lelabii ngasebawaiki kuntagi mundu. ");
INSERT INTO mgv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndienu, ndaba labi lisoba la Ayaudi kulibeka sapi ndaba ji Lisoba lu Kupomulela, na ndaba lipoli le lakabii pambipi, bummbeka Yesu momuje. ");
INSERT INTO mgv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lisoba la jumapili pulukela, ekwabiya kwakona nga na kusaki, Malia juku Magidala jajenda ku lipole. Ejahika kola jilikolila lilibu lebayekali lipole lela aliboiki. ");
INSERT INTO mgv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ndienu jajenda imbelu kwaka Simoni Petili na mmbole jongi jojuwe Yesu ampaliki ngamaa, jaapwagila, “Amboiki Bambu mu litenge, wala ngasetumanyiki koambeile.” ");
INSERT INTO mgv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ndipala Simoni Petili na mmbolee jongi jola bajendannya kulitenge. ");
INSERT INTO mgv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Boti abeli babia abutukani lakini jongi jola jabia jubutuka kupeta Petili, jalonguliya kuhika ku lipole. ");
INSERT INTO mgv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jajinama nukulingali nkati, jijibona ingobu nhuu seahingalaki nhyega jaka Yesu lakini ngasejajingala nkate. ");
INSERT INTO mgv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petili najombi jahika munyuma jaki nu kujingii mlipoli momuje jikibona ingobu nhuu jela. ");
INSERT INTO mgv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ni kitamba sebabia anyonalati Yesu kumutu. Kitambaa se hesi abei patali na sanda, ila sabia kitulwini kibii pakajika jaki. ");
INSERT INTO mgv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ndienu mmbolee waki jojalonguliya kuhika kulipoli jola najombi jajingala nkati nukubona itamba ye bahingalati nhyega jaka Yesu, nukuhobale. ");
INSERT INTO mgv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Babia bakoni ngakuelewa Maandiku ga Sapi egapwaga kwabi, jupalika juyoka. ");
INSERT INTO mgv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ndipala banafunzi bala babujaniya kumajumba gabu. ");
INSERT INTO mgv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia juku magadala jabia jujemiki kunza jilipoli jakalela. Ejwabiya jakoni jakalela jajinama nukulinga nkati jilipoli, ");
INSERT INTO mgv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","jaabona atumi abeli bu kunani baka Sapanga aweti ingobu iyuu, atamani pababei nhyega jaka Yesu pwabiya ajigoniki, jumu upandi ukumutu na jongi upandi wa kwamagolu. ");
INSERT INTO mgv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bundalukiya, “Nyongoo gulele kike?” Na Malia jaapwagila “Amboiki Bambu wango na wala ngasenukumanyiki koambeile!” ");
INSERT INTO mgv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Malia pajajomula kupwaga haga, njang'anumbuka munyuma ambona Yesu jujemiki, lakini ngaseamanyike ngati jombi ndi Yesu. ");
INSERT INTO mgv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu ampwagila, “Nyongoo, gulele kike? Guntaputa nyane?” Malia jaholaliya julongee na jojuhenga lihengu lukulingali kijongu, ampwagila, “Nkolongu, ana gumboiki wehapa gumbwagila kogumbeile nane nukunzukuaje.” ");
INSERT INTO mgv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu ampwagila, “Malia!” Ndipala Malia anng'anambukiya Yesu nu kulongee naku kwi kiebulania, “Laboni!” Maana jaki Mmbola. ");
INSERT INTO mgv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ampwagila, “Wingamu, nakonaa ngasembiti kunani kwa Atati. Lakini jenda kwaka alongu bangu ukaapwagila, nyenda kunani kwaka Sapanga kwa Atati bangu na Atati binu, Sapanga wangu na ndi Sapanga winu.” ");
INSERT INTO mgv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ndienu Malia juku Magidala jajenda kaapwagi majambu gala banafunzi kupwaga ambweni Bambu, najabiya ampwagi malobi haga. ");
INSERT INTO mgv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kwabiya pakamii ji lisoba alelale la juma pili, banafunzi baki pababiya pamu nkati ju nyumba, milyangu babia apungiki ndaba jakajogopa akakiliongosi ba Ayaudi, Yesu jaapitila, jajema pikilanda jabu nukupwaaga, “Lukwali lubiya kwinu.” ");
INSERT INTO mgv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ejajomula kupwaga haga, jaalangia maboku gaki nu luteta lwaki. Banafunzi baki batogulii ngamaa pabummbona Bambu. ");
INSERT INTO mgv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu jaapwagila kabee, “Lukwali lubiya kwinu! Ngati Atati ebantuma nepani, nane numtuma mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Najombi ejajomula kupwaaga haga, jaapulaliya loho nakaapwagi, “Nzoopannya Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Anamwalekaki bandu mahakau gabu, alekakiwi, anangakaalekake, ngabilekakiwe.” ");
INSERT INTO mgv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lakini Tomasi, jobunkema, “Lipaa,” Jojabii jumu ja banafunzi baki komi na abeli, ngasejabii pamu nabu kipindi Yesu ejahika. ");
INSERT INTO mgv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Henu banafunzi bangi bumpwagila, “Tumbweni Bambu.” Lakini jombi Tomasi jaapwagila, “Anangakagabona mabanga gi misumali mumaboku gaki nukubeka lukonzi lwagu mumabanga gimisumali nukuboku kwaku muluteta jaki, nganhobalele.” ");
INSERT INTO mgv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Egapeta masoba nani banafunzi baki babiya kabee pamu mu nyumba, najombi Tomasi jabii pamu naku. Ndienu Yesu jahika koni milyangu apungiki nu kujema pikilanda jabu nukupwaaga, “Lukwali lubiya kwinu!” ");
INSERT INTO mgv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ndipala ampwagila Tomasi, “Beka lukonzi lwaku pambani gulinga maboku gangu, nyosa kuboku kwaku gulinga muluteta lwangu. Kotuka kuba ni kiholu, ila guhobaliya.” ");
INSERT INTO mgv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi ampwagila, “Bambu wangu na Sapanga wangu!” ");
INSERT INTO mgv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu ampwagila, “Boo gunhobali le egumwene? Nambanga banga kubona, lakini ahobale.” ");
INSERT INTO mgv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu jatenda nginyuli nga yeyo mbeli ja banafunzi baki, yeyuye ngaseaandiki mukitabu senzeno. ");
INSERT INTO mgv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lakini ganiaga aandiki ili nnwesa kunhobale Yesu ndi Kilisitu Nkombosi, Mwana waka Sapanga, na sukunhobale jombi, mwanganya mwiipata womi wa masoba goa kwa makili gi liina laki. ");
INSERT INTO mgv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagapeta ganiaga Yesu jaapitila kabee banafunzi baki mulutengu ju nhanga guku Tibelia. Jaapitila ana, ");
INSERT INTO mgv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petili na Tomasi joankema mapaa na Nataneli mwenei juku Kana Galilaya na bana abeli baka Zebedayu na banafunzi baki bangi abeli, babia boti abeli pamu. ");
INSERT INTO mgv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petili jaapwagila, “Nyenda kulobo homba.” Nabombi bumpwagila, Natwe ngiti tulongana nawenga, ndienu bajenda nukukwela nhwatu, lakini ikilu je heji ngasebapatiki sokape. ");
INSERT INTO mgv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ekwatumbuliya kukusa, Yesu jajema mulutengu ju nhanga, lakini banafunzi baki ngasemanyiki ndi ngati jombe. ");
INSERT INTO mgv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ndienu, Yesu jaalalukiya, “Akosi bangu ngasempatiki le sokape?” Bombi bapwaaga, “Loo! Ngasetupatiki sindo.” ");
INSERT INTO mgv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu jaapwagila, “Nndekala ilepa hinu upandi wa malele uku nhwatu ngiti mpata homba.” Ndienu balekala kilepa mu nhanga lakini ngasebawesa kuhuta kabee ndaba ja homba kuba hinge. ");
INSERT INTO mgv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Papuje mmbolee jojapaliki na Yesu ampwagila Petili, “Jonzo Bambu!” Simoni Petili pajajoa Bambu, jakonga ingobu jaki ndaba jabiya ndaba ngaese jwakongike ingobo, nukuhombe mmase. ");
INSERT INTO mgv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lakini banafunzi bangi bala bahika ku mbwani ku nhwatu gola koni ahuta ilepa yeitweli homba, ngasebabii kutali nukundema, ila babiya utali wa meta miya kuhuma mulutengu. ");
INSERT INTO mgv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pabahika kundema bugubona mwotu wa makalakala akohiki na panani jaki abei homba ni libumunda. ");
INSERT INTO mgv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu jaapwagila, “Nndeeta pamba homba yengi yendobwi yene.” ");
INSERT INTO mgv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni na Petili bakwela munhwatu, jahuta mbaka mundema gola kilepa sesabii homba ngolongu mia moja hamsini ni itatu. Papuje baabii bandu bingi ndienu kilepa se ngasewajendwike. ");
INSERT INTO mgv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu jaapwagila, “Nhikannya nkula.” Ngajabii hata jumu jojawesa kundaluki sokapi. “We wa nyane.” Ndaba bumanyiki jombi ndi Bambu. ");
INSERT INTO mgv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu jahika, jajukua libumunda, jaapekiya, jahenga ahelahe na homba yela. ");
INSERT INTO mgv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Papuje jabiya mala ji itatu Yesu jaapitila banafunzi baki baada juku yoka. ");
INSERT INTO mgv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ebajomula kula, Yesu andalukiya simoni Petili, “Simoni mwana waka Yohana! Boo gumbai nepani kuliku banganya ababa?” Najombi jaapwagila, “Ena Bambu, gumanyiki nepani nugupaile.” Yesu ampwagila, “Gulima bana ba makondoo gangu.” ");
INSERT INTO mgv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ndipala ampwagila mala ja pili, “Simoni mwana waka Yohana! Boo, gumbaile?” Petili ampwagila, “Ena Bambu gumanyiki nendenda kugupala.” Yesu ampwagila, “Gulima makondoo gangu.” ");
INSERT INTO mgv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Andalukiya mala ja tatu, “Simoni mwana waka Yohana! Boo gumbaile?” Papuje Petili jayomika ndaba andalukiya mala ja tatu. “Gumbaile?” Ampwagila, “Bambu, wehapa wagamanyi goti, wehapa gumanyiki nepani nde kugupala.” Yesu ampwagila, “Gulima makondoo gangu!” ");
INSERT INTO mgv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sakaka nugupwagi, pawabii gunkombu wayobali kukonga luhunga nukujenda kwokapi kogupai. Lakini pawibiya gunseja gwitondabia maboku gaku, na mundu jongi jagukonga nukugupeleka kwanga kupala kujenda. ");
INSERT INTO mgv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kukupwaga hela, Yesu jalangia Petili ejikuwa nukundumbalii Sapanga. Ndipala ampwagila, “Nyengaliya.” ");
INSERT INTO mgv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Papuje Petili jang'anambuka, ambona mmbolee jojabii Yesu ampai, jujengalee, mmbolee jola ndi jojabii kipindi sela sebabiya bakakula kilebi sa pakamii, jatemi pambipi ngamaa na Yesu nukundaluki, “Bambu nya jojwagung'anambuka?” ");
INSERT INTO mgv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ndienu, Petili eambona hoju, andalukiya Yesu, “Bambu, na jonzo boo?” ");
INSERT INTO mgv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu ampwagila, “Ana ngati jupai juhigaliya mbaka panihika, gupala kyane? We gumbwata nenga.” ");
INSERT INTO mgv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ndienu, majambu ge haga gaeniya kwa bandu babuhobale Kilisitu kupwaaga mmbolee hoju ngajiikuwi. Lakini Yesu ngasejapwagiki mmbolee we hoju ngajukuwe ila japwaaga pe, “Ana ngati mbala juhigala mbaka panikelubuka, we gupala kyane?” ");
INSERT INTO mgv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hoju ndi jojagabona majambu ge haga, nukuandika. Natwee tumanyiki gajapwaga ndi ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gabii majambo gingi gajahenga Yesu. Gaguge ngati gakahandikwi goti, limu baada ja lengi, nholale hata ndema weni ngakwakabii kwiibeka itabu yeyabii iyandikwi.");
INSERT INTO mgv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nkolongu Teofili. Mu kitabu sangu senalonguli kuandika, naandiki majambu goka gajatei Yesu na kwaabola bandu toka pajatumbuliya lihengu laki, ");
INSERT INTO mgv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka lisoba lebunzukua kujenda kunani kwaka Sapanga, kabula jukunzuku jaalagalakiya malagalaki atumi baki bajaahagula kupete uwesu wa Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Masoba alubaini baada jakuwa kwaki, jaapitila bombi mala jingi kwaalangi sakaka juyokiki. Bummbona Yesu nukulongee naku lijambu lu Ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lisoba limu pajabi pamu nabu jaapekiya malagalaki ganga: “Mwiboka pa Yelusalemu pani, lakini nndendaliya nhupi jebalagalaki Atati bangu, jemwajowana nakalongaliya.” ");
INSERT INTO mgv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“Yohana jummbatisa mwanganya kwa masi, lakini gakona masoba kidogu mwibatiswa kupete Loho jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Atumi baka Yesu pabaketangana na Yesu, bundalukiya, “Boo, Bambo senze le kipindi sakaa kelabuki bandu buku Izilaeli ukolongu wabo?” ");
INSERT INTO mgv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu jaajibua “Lisaa ni kipindi sehesi amanya beni Atati kajika, nga lihengu lii kumanya lisoba lukupiti. ");
INSERT INTO mgv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakini kipindi se mwipata Loho jaka Sapanga, mwipata makili nanamu mwibia mwa bandu bangu bakaapwagi bandu ku Yelusalemu kwoka, ku ndema joka juku Yudea nuku Samalia, na mbaka kila pandu poti pu ndema gamwagabweni kwangu.” ");
INSERT INTO mgv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pajajomula kulonge haga, jajenda kunani kwa mahundi, koni boka buku ndingaliya, na mahundi gatenda kunhyekale Yesu ngase jwabonikana kabee. ");
INSERT INTO mgv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pababi bakona bakalingaliya kunani kojahobila Yesu, bajitukiya bandu abeli babaweti ingobu nhuu ajemiki pambipi nabombi. ");
INSERT INTO mgv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bapwaaga, “Mwa bandu buku Galilaya mwee! Ndaba jaki nndingalii kunane? Yesu hoju jobunzukwi kuhuma kwinu kujenda kunani kwaka Sapanga, jwihika kabee ngati emummbona jwakajenda.” ");
INSERT INTO mgv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Papuje atumi baka Yesu bala baamua kujenda Ku Yelusalemu kuhuma ku kitombi sebikikema Kitombi si Mizeituni, gogwabi pambipi pe kuhumi Ku Yelusalemu, ulasu waki wabipe atua kilumita jimu kuhuma kumusi. ");
INSERT INTO mgv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pabaika ku musi, bajenda sumba su kunani mu sumba seatamikaa. Babi, Petili na Yohana na Yakobu na Andilea na pilipi na Tomasi na Batolomayu na Matei na Yakobu mwana waka Alufayo na Simoni Zelote na Yuda mwana waka Yakobu. ");
INSERT INTO mgv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Boka haba babi pamu kunndoba Sapanga, pamu na aka mbomba bababi pala, jwabii Malia amabu baka Yesu na alongu baki bangi. ");
INSERT INTO mgv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lapeta lisoba limu Petili jwajema pikilanda ja bandu bababii mia ni ishilini babung'anambuki Sapanga, nukupwaga, ");
INSERT INTO mgv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mwaalongu bangu,” kwabi kupalika Maandiku ga Sapi gatimia, gajwalongila Loho jaka Sapanga kupete nndomu waka Daudi, pajwalotila lijambu laka Yuda jojwaalongua bandu babunkamula Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda jwabi pamu na twepani, ndaba najombi bunhagula jubia pamu na twepani kuhenga lihengu laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mundu hoju jwaamua kulomba lituhi kupete lupija lojapataa mu ubaja, jaabuka pai puu! Nukupojoka litumbu laki na matumbu goka gakusumbukiya kunza. ");
INSERT INTO mgv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kila mundu ku Yelusalemu kola jajogwa lijambu le heli, ndienu baamua kupakema pandu pe pala kwa luga jabu beni Akelidama maana jaki, “Litui la mwae.” ");
INSERT INTO mgv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ngati hebaandiki mukitabu sa zabuli, ‘Pandu paki payoka ukeba, ngajikubi mundu jojitama homo.’ Kabee aandiki, ‘Napwasi jaki jwiijukua mundu jongi.’ ");
INSERT INTO mgv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Nala, tunhagula mundu jumu jojabi pamu na twepani muda goti Bambu Yesu pajabia jujenda pamu na twepani. ");
INSERT INTO mgv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Hoju jupalika kuba jumu kati ja bandu baalandi bababi pamu na twepani, toka Yohana pajabi jutenda kubatisa, mbaka lisoba Yesu pa bunzukua kuhuma kwitu kujenda kunani kwaka Sapanga. Hoju jijangatana pamu na twepani kaalandi bandu kuyoka kwaka Yesu Kilisitu.” ");
INSERT INTO mgv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ndienu balogula maina ga bandu abeli, Josepu jobunkema Balusaba liina lengi bunkema Yusito na Matiasi. ");
INSERT INTO mgv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ndi bundoba Sapanga bapwaga, “Bambo weapa ugumanya mwoju wa kila mundu. Ndienu utulangia mundu jounhagwi kati ja bandu abaa. ");
INSERT INTO mgv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ili jujukuwa napwasi ju utumi jejujileka Yuda nukujenda pandu jaki mweni.” ");
INSERT INTO mgv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ndienu bapega gudugudu, gudugudu junhabukiya Matiasi, najombi bumbalangiya kuba pamu na atumi komi na jumu bala. ");
INSERT INTO mgv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Palaika lisoba la Pentekosite, apwasi boka babi aketangini pamu. ");
INSERT INTO mgv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Apalapa sauti jajowanika kuhuma kunani, sauti je jabii ngati kimbonga kikolongu, nukutwele mu nyumba jela joka. ");
INSERT INTO mgv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ndienu, yabonikana hindu yeyabi ngati ilimi ya mwotu, yabaganika nukutola panani ja kila mundu. ");
INSERT INTO mgv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ndipala boti batwelila Loho jaka Sapanga, nukutumbuli kulonge luga yengi ngati Loho ja Sapanga ejalongua. ");
INSERT INTO mgv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ku Yelusalemu kola babi Ayaudi bingi ba bunhobale Sapanga kuhuma kila ndema. ");
INSERT INTO mgv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pabajowa sauti yela Yaatena, bahegalaninya pamu. Boti lwaakamwi lujogopu ndaba kila mundu jojwabi pala jwajogwana bakalongila kwa luga jaki mweni. ");
INSERT INTO mgv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Basangi nukulwehuka koni bakapwaga, “Boo, bandu boka batwajogwa akalongela hela haba, nga lee benei buku Galilaya! ");
INSERT INTO mgv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Henu kubi bole, mbona kila mundu jaajoane kwa lugha jaki jukusaliwa najo? ");
INSERT INTO mgv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Alapalati na Aamedi na Aelamu na buku Mesopotamia na Yudea na Akapadokia na Buku ku Ponto na buku Asia, ");
INSERT INTO mgv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Afulugia na Pamfilia, na buku Misili nu upandi woka Uku Libiya na pambipi nuku Kilene na bangi bababi ageni kuhuma ku Loma. ");
INSERT INTO mgv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayaudi na bangi babang'anambwiki kuba Ayaudi, na Akilete na buku Alabuni twaboa twaajogwana banganya aba alonge kwa luga jitu twabete, aga majambu makolongu gaka Sapanga!” ");
INSERT INTO mgv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boti basangi nukujogopa koni alaluana, “Majambu geaga mana jaki kike?” ");
INSERT INTO mgv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bandu bangi bapwaaga, “Bandu aba atei kulobe!” ");
INSERT INTO mgv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ndienu Petili jwajema pamu na atumi baka Yesu ajaki komi na jumu, jwatumbuliya kwaalandi kwa sauti ngolongu kaapwagi, “Mwaalongu bangu Ayaudi na mwa bandu boka mwontama ku Yelusalemu, nzoaninya sapi malobi gangu. ");
INSERT INTO mgv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bandu ababa ngase alobii ngati enhwasali mwanganya, sajenuje saa tatu pee pulukela. ");
INSERT INTO mgv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ila lijambu le eli lejwalota Joeli Mlota waka Sapanga pajwapwaga, ");
INSERT INTO mgv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Bambu jupwaga, mumasoba ga mwisu, niijakanakia Loho jangu panani ja bandu boka. Bana bii akakombu na aka kamwali bitenda kulandi malobi gaka Sapanga, akakombu binu bibona majambu gagipitila masoba gapalongi, na aseja binu biilota ndotu. ");
INSERT INTO mgv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Heloo, hata atumisi bangu akanalomi naaka mbomba, naajakaniya Loho jangu masoba gehaga, nabombi biitenda kulandi majambu gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nane niitenda ndonduke kunani, na nginyuli yiibonikana pai punndema, gwibonikana mwai na motu na liyoi likolongu. ");
INSERT INTO mgv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lyoba ligubikwa na lwii, nulubalamwei lwikuba nkeli ngati mwai, gokaaga gilonguliya kabula jukuhika lisoba likolongu lu ulumbi waka Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hapandi, jokapi jojiiloba kupetee liina laka Bambu jwiitenda kulama.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mwabandu buku Izilaeli, nnzowaniniya malobi aga! Yesu juku Nazaleti jwabii mundu jojwayekuliwi pangwendu kupete uwesu goguhuma kwaka Sapanga kwinu kupete ndonduke, maajabu na nginyuli yejatei Sapanga kwinu mwanganya kupete jombi, ngati hemanyiki mwabeti. ");
INSERT INTO mgv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ngati hegwabi mpangu waki mweni Sapanga, jwabi jumanyi mwanganya mwiitenda kunkamu Yesu, nanamu mwankoma kupete maboku ga bandu abaja. ");
INSERT INTO mgv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lakini Sapanga anhyoa kabee kuhuma koatama bandu bawii, nuku mmboke ubini wa kua ndaba ngase kwawesakini makili ga kuwa gunkamulakiya. ");
INSERT INTO mgv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ndaba Daudi andongali jombi pajapwaaga, “Nummbona Bambu palongi jangu masoba goti, jubii nanepani upandi wangu wa malele, nga niangajike. ");
INSERT INTO mgv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Henu, mwoju wangu watenda kutogule, nululimi lwangu lwatweli malobi guku togule, nhyega jangu jitama mu mahobale, ");
INSERT INTO mgv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ndaba ngauleki mwoju wangu koatama bandu baawii, wala kunzetake mundu wa sapi waku juboola. ");
INSERT INTO mgv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gunaangi indela ja womi, gwindwelakiya kutogule mmoju wangu palongi jango!” ");
INSERT INTO mgv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mwaalongu bangu mwa Izilaheli, mbala numpwagila hotuhotu majambu gagumpata ahoku bitu bambu nkolongu Daudi jojamanyakini ngamaa. Jombi jawii, nukuntaga, ni litenge laki libi apambane mbaka lelenu. ");
INSERT INTO mgv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lakini ndaba Daudi jabi Mlota waka Sapanga, jwamanyiki Sapanga andagila kupwaga jwihagula mundu jumu mukibeleku saki nuku mmbeka jubia Bambu nkolongu ngati ejabii jombi. ");
INSERT INTO mgv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi jagamanyiki majambu gajwihenga Sapanga palongi ndi jwaamua kulongale kuyoka kwaka Kilisitu pala pajapwaga, ‘Ngase bundekiti koatama bandu baawile, nhyega jaki ngase jabolike.’ ");
INSERT INTO mgv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Henu, Sapanga anhyoa Yesu hoju natwepani twaboti tugabweni majambo goka haga. ");
INSERT INTO mgv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu pabunkwea nuku mbeka upandi wa malele waka Sapanga, jajopa kuhuma kwaka Atati Loho jaka Sapanga jojutulagi, jutujakani Loho we hoju. Hesi ndi semwikibona nukukijoana sajenu. ");
INSERT INTO mgv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ndaba mweni Daudi ngase jwakwehi kunani kwaka Sapanga, jombi jwapwaga pee, ‘Bambu ampwagila Bambu wangu, gutama upandi wangu wa malele, ");
INSERT INTO mgv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka panaabeka abaja baku pai ja magolu gaku.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Mwabandu boti muku Izilaeli mpalika kumanya sapi ana Yesu hoju ndi jomumbambaliya punsalaba, ndi Sapanga ambei jubia Bambu nu Nkombosi!” ");
INSERT INTO mgv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndienu, bandu pabajogwa gala, mioju jabu jatenda kuligana, bundalukia Petili na atumi ajaki, “Boo mwaalongu bitu tutenda bole?” ");
INSERT INTO mgv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petili jajibua, “Nzetakia mahakau nukugaleka na kila jumu jubatiswa kupete liina laka Yesu Kilisitu ili junndekakiya mahakau ginu nukujopa nhupi kuhuma kwaka Sapanga ndi Loho jaki. ");
INSERT INTO mgv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ndaba, lilagi heli labi liitu na bana bitu na bandu boka baatama kutali na laka kila mundu joankema Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petili jahingamakia kwa malobi gangi gingi nakaaloba bandu bala koni jupwaaga, “Muliboa mukibeleku sana mahakau asese.” ");
INSERT INTO mgv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bandu bingi bajetaki malobi gaki, nukubatiswa. Ni lisoba lelela bajonzukika bandu kuhegale elupu itato. ");
INSERT INTO mgv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Boka haba baendaliya kulibola kwaka atumi bala, kutama pamu ngati kilongu simu, kumega libumunda pamu nu kundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Atumi batei ndondoke hingi mbaka bandu babia nulujogopu nu kusangaa. ");
INSERT INTO mgv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bandu boa babia sindu simu hata hindu yabu batenda kubagana. ");
INSERT INTO mgv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Babia alombesa mali gabu na hindu yabu nukubagana lupija kulengana nili tatisu laka mundu. ");
INSERT INTO mgv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Baendaliya kuketangana pamu mu Nyumba jaka Sapanga kila lisoba. Lakini kipindi sa kula posu, baketangana mu manyumba gabu na nukunuku libumunda lela koni atogule kwa mwoju wa sapi. ");
INSERT INTO mgv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bundumbaliya Sapanga na bandu boti baapala bombi. Kila lisoba Bambu jaendaliya kwaagombo bandu baki. ");
INSERT INTO mgv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lisoba limu, lyobamutu saa tisa, Petili na Yohana bakwela kujenda mu Nyumba jaka Sapanga, muda gu kunndoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Muda we hogu bandu akubika buntoto mundu jumu jojabii kilema toka kusaliwa kwaki. Bandu bala bayobali kila lisoba kumbeka mundu jola pundyangu wa Nyumba jaka Sapanga gobugukema “Nndyangu wa sapi,” ili jwaaloba lupija kwa bandu baahika mu Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mundu jola pajwaabona Petili na Yohana baka hegalya mu Nyumba jaka Sapanga jwaaloba bumpekya lupija. ");
INSERT INTO mgv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petili na Yohana buntupila mihu, najombi Petili jwapwaga ana, “Tulingalia twepani!” ");
INSERT INTO mgv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Najombi jwatenda kwaang'anambuki, koni juhobale kupata lupija kuhuma kwabu. ");
INSERT INTO mgv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ndipala Petili ampwagila, “Nepani ngasemi na feza wala zaabu, lakini seminasu ndi senukupeke. Kupetee liina laka Yesu Kilisitu juku Nazaleti gujema nugujenda” ");
INSERT INTO mgv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petili ankamula mundu jola kuboku kwamalele, nuku ntondabee. Apalapa magolu gaki na majugu gaki gapata makili. ");
INSERT INTO mgv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jwahoba kunani, nukujema namagolu gaki nukutumbuli kujenda. Ndienu jwajingala mu Nyumba jaka Sapanga pamu na Petili na Yohana koni jujenda nuku hombahomba koni junndumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bandu boti bababi pala bumbona jakajenda koni anndumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pabummanya jwabia mundu jojulobaloba pambipi nunndyangu gobugukema, “Nndyangu wa Sapi,” wa Nyumba jaka Sapanga gola, basangii ngamaa hata ngase bawesiki kumanya gagumpiti. ");
INSERT INTO mgv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bandu boti koni atenda kusangaa, batumbulia kwajombatake Petili na Yohana na mundu jola pababiya ajenda ku, “Sengu jaka Solomoni.” ");
INSERT INTO mgv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ndienu, Petili pajaabona bandu bala jaapwagila, “Mwa Izilaeli ajangu, ndaba jaki nsangaa lijambu hele? Ndaba jaki mutulingalii ngati tuntei mundu ajo jujenda kupete makiligitu au usapi witu twabete? ");
INSERT INTO mgv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sapanga waka Ibulahimu na Isaka na Yakobu, Sapanga wa Ahoku bitu anndumbaliya mtumi waki Yesu Kilisitu jomunng'anambuka nukunkana kwaka Pilatu, hata ana Pilatu jaamwii kunndekake. ");
INSERT INTO mgv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwanganya mwaamua kunkana mundu wa sapi hoju na joandengane Sapanga nukupala jojukoma bandu jola. ");
INSERT INTO mgv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Henu aji, munkoma jojupia kwa bandu womi. Lakini Sapanga anhyoiki, natwepani ndi tugabweni majambu haga. ");
INSERT INTO mgv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sukuhobale lihina laka Yesu ndi yeyumpeki makili mundu hajo jomumbona nuku mmanya. Kulihina laka Yesu nukuhobale kokuhuma kwaki ndi kokundamisi mundu ajo jomumbona.” ");
INSERT INTO mgv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Henu, mwalongu bangu mwanganya nakikilongosi binu, nemanya mwatei haga ndaba ngase mwamanyiki sindo. ");
INSERT INTO mgv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lakini hela ndi Sapanga ejutimisi gajapwaga toka mwandi kupetee Alota baka Sapanga boka, kupwaga kwabii lasima Kilisitu waki biitenda kunng'alisa. ");
INSERT INTO mgv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nala, nzetakia, kugalekake mahakau ginu, nukung'alumbuki Sapanga najombi ja nndekakia mahakau ginu, ");
INSERT INTO mgv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ntenda ahelahe ili Bambu jampekiya muda hukutogulee mumwoju nu kunndetee Kilisitu jola joanhagwi ndi Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesu jupalika juhigala kunani kwaka Sapanga mpaka pagwihika muda gukutenda indu yoka ibia inyai, ngati Sapanga ejwapwaga kupetee Akalota baki bababi toka mwandi. ");
INSERT INTO mgv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndaba Musa jwapwaaga, ‘Bambu Sapanga winu anndetila Mlota jongi ngati nepani kuuma kwa bandu binu mwabeti mwanganya mpalika kunzoane kila sejwaampwagila. ");
INSERT INTO mgv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu jokapi jojwikana kunzogwane Mlota baantenga bandu baki nukukomeka.’ ");
INSERT INTO mgv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Alota boka, kutumbuli Samweli na bangi babahika munyuma jaki, boti balongali nukulandi majambu gehaga gaga hengeka masoba gani. ");
INSERT INTO mgv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Malaganu gala gajapia Sapanga kwi indela ja alota ndi jinu mwanganya, kabee nililaganu lejatenda Sapanga na ahoku binu ndi lino. Ngati eampwagila Ibulahimu, ‘Kupete kibeleku saku, bandu boa bupu ndema pani biitenda kupengeleka.’ ");
INSERT INTO mgv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Henu Sapanga anhyoa Yesu ntumi waki nukuntuma kwinu hoti, ili kwaapengalee nukung'alambu kila jumu winu jukotuka indela yaki iliyaa.” ");
INSERT INTO mgv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petili na Yohana pabaendaliya kaalandi bandu, agolu ni kilongosi jwaalonda ba Nyumba jaka Sapanga pamu naka Asadukayu babahika pala. ");
INSERT INTO mgv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bayomiki ngamaa, ndaba atumi bala baalandila bandu koni bakapwaga yesu juyokiki, lijambu lelaatenda bandu amanya kila mundu jojuwi jwiiyoka kabee lisoba lamwisu. ");
INSERT INTO mgv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ndienu baamua kwaakamu na kwaabeka mukipungu mbaka lisoba lapili ndaba kwabii kupili. ");
INSERT INTO mgv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lakini bandu bingi kati jabandu babaajowana babi ahobali, na bandu babung'anambukya Sapanga bajonzukika bahegali kuhika akanalomi elupu nhwano. ");
INSERT INTO mgv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kilabu jaki akakilongosi ba Ayaudi, Aseja na Abola bamalagalaki gaka Musa baketangini pamu ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Baketangana pamu na Anasi jojabii nngolu nkolongu na Kayafa na Yohana na Alekizanda na bangi babi bikilongu saka nngolu nkolongu wa nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Baajemiki atumi bala palongi jabu, nakaalaluki, “Mwanganya ntei lijambu eli kupete uwesu bole nukupete liina laka nyaane?” ");
INSERT INTO mgv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndipala Petili koni jutweli makili ga Loho jaka Sapanga jaka Sapanga, jaapwagila, “Mwaakolongu na aseja mwanganya: ");
INSERT INTO mgv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ana ntulaluki twepani lelenu ndaba jilijambu laamboni letuntendi mundu jola kwiliina lyaka Yesu. Mundu jojabii kilema wa magolu na sajenu mwomi, ");
INSERT INTO mgv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nala mwanganya na bandu boka buku Izilaeli kupalika mmanya munduhoju jujema lelenu kulongi jinu koni mwomi, juyokiti kupete makili gilihina laka Yesu Kilisitu juku Nazaleti jomunng'alisa mwanganya punsalaba jola lakini Sapanga anhyoa kuhuma kwa bandu baawi. ");
INSERT INTO mgv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hoju ndi jojulongaleka mmaandiku gagapwaga: lilibu lemulikana mwanganya mwensenga mwee, henu ndiu leniheli ndi lilibu likolongu lunsingi lapa kona. ");
INSERT INTO mgv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uokopu ngasegupatikani kupetee liina laka mundu jongi jokape ndabaje, pu nndema poti bandu ngasebaapeki liina laka mundu jongi lakaaokoa.” ");
INSERT INTO mgv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aseja ba pasengu bala, basangii ngamaa ebalongila Petili na Yohana bila kujogopa ndaba ngasebiliboliki kusule. Ndienu pabamanya abii pamu na Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lakini pabumbona mundu jojulamiki jola jujemiki nabu, ngase bawesaa kupwaga sokape. ");
INSERT INTO mgv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sengu jaamua apita kunza japa sengu, na bombi baigaliya pee papasengu koni akolobeka mbolimboli. ");
INSERT INTO mgv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Aseja bala baamua kulalukani ana, “Tutenda boo, na bandu ababa? Bandu boka buku Yelusalemu amanyiki ndonduke jebijitei hapa, natwepani ngatuwesi kukana lijambu lee hele. ");
INSERT INTO mgv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ana tupai kulipenga lijambu leheli liiendalee kuene ngani kwa bandu, twaakana biilongee na mundu jokapi kuhusu liina laka Yesu.” ");
INSERT INTO mgv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ndipala baakemila nkati kabee na kaapwagi biilongalee kabee pangwendu lijambu lee lela, wala kwaabola bandu lijambu laka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakini Petili na Yohana baajibwa, “Nhamua mwabe sekibi saa sapi kwaka Sapanga kibii kwako, kumpwata mwanganya kuliku kumpwata Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndaba ngatukotoki kupwaga majambu gatugabweni nukugajogwana.” ");
INSERT INTO mgv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ndienu, aseja bapasengu bala baakanakia su ukali ngamaa, na kwalekake ajenda. Ngasebawesiki kwaalapu ndaba bandu boka bundumbalya Sapanga kupetee lijambu lee heli. ");
INSERT INTO mgv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundu jojalama magolu jola jabii na yaka kupeta alubaini. ");
INSERT INTO mgv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pabaalekakiya pee Petili na Yohana, bajenda kobabii apwasi bangi, na kaalandi gabaajogwana agoluu akolongu bapasengu na aseja ba Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nabombi hebajogwa majambu gegala bajongana pamu kunndoba Sapanga koni apwaaga, “Bambo, wee ndi weubombiki kunani kwaka Sapanga na punndema pani, kunhanga na hindu yoka yeibi kunhanga! ");
INSERT INTO mgv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wee ndi wewaawesisa atati bitu Adaudi, atumisi baku apwagaa kwa makili ga Loho jaka Sapanga pajapwaga, ‘Ndaba jakii bandu bu nndema goni aholale ubaya pena, ndaba jakii atenda mipagu yanga namana? ");
INSERT INTO mgv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Aka bambu nkolongu bupu ndema pani bijiandii beni, na aka kilongosi baketangini pamu, andongale Bambu na Kilisitu waki.’ ");
INSERT INTO mgv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ndaba sakaka Helodi, Pontio Pilatu, bandu buku Izilaeli na bandu kuhuma ndema jengi baketenganhya papamusi pani, kumpenga Yesu ntumisi waku wa sapi joumbekiki kuba Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Helo, baketangana ili atenda, majambu ga wapala nu kupanga toka mwandi kupete makili gaku nu upali waku wamwete. ");
INSERT INTO mgv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na sajenu Bambo, ulingaliya itishu yabu na utuwesisa twepani twa atumisi baku tulongila lilobi laku bila kujogopa. ");
INSERT INTO mgv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gunyoshaa kuboku kwaku gwaalamisaa bandu. Gutendaa nginyuli na ndonduke kupetee liina laka Yesu Mtumisi waku wa Sapi.” ");
INSERT INTO mgv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pabajomulya kunndoba Sapanga, pandu pabaketangini pala patenda kunyuka na boti batwelila loho jaka Sapanga. Na boti balandila malobi gaka Sapanga bila kujogopa. ");
INSERT INTO mgv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bandu boka bababia bunzetaki Sapanga babii sindu simu na moju gumu. Ngajumu jojabii na sindu nukupwaga saki kajika, babaganaa kila sebabia nasu. ");
INSERT INTO mgv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Atumi baka Yesu balongila kwa bandu kwa makili gingi kuyoka kwaka Yesu, na Sapanga jaapengaali ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ngasejabii mundu jojakosa sindo, ndaba je bandu bababii na matuhi au nyumba batendaa kulombesa nukuleta lupija, ");
INSERT INTO mgv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na lupija lweni baapelakiya atumi baka Yesu na kila jwanga na sindu bumbaguliya kulengana nukupala kwaki. ");
INSERT INTO mgv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jwabii Mlawi jumu, jojasaliwi ku Kupulo, liina laki Josepu, atumi baka Yesu bunkema Balunaba maana jaki, mundu jojaapeke bandu makili kupete malobi gaki. ");
INSERT INTO mgv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Najombi jabii nilitui jililombisi, najajukua lupija lola na kwaapekee atumi baka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lakini mundu jumu jobunkema Anania na ahanu baki Safila na bombi balombisi litui labu. ");
INSERT INTO mgv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anania jahia lupia longi lojalombasia lituhi, jwaakabisa atumi baka Yesu lupija kidogu tuu hata ahanu baki bamanyiki. ");
INSERT INTO mgv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petili jwaamua kundaluki, “Anania ndaba jaki ulilekiki lijobi lijingala mu moju waku nu kugulongo unkonga Loho jaka Sapanga sukuhia lupija longi logupatiki kupete lituhi legulombisi lela? ");
INSERT INTO mgv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kabula jukulilombesa labii laku, na baada jukulilombesa lupija lwe lola lwakona lwako, uwesa kutumi ngati egupala. Henu ndaba jakii moju waku gwaamwi kutenda hela? Hajaku ngase unkongiki mundo, ila unkongiki Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania pajajowana goti gala jaabuka pai na kua. Bandu boka babajogwa lijambu leheli bajogwipi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Akakombu bahika pala, bijiyekaliya nhyega jaki na sanda nukumpia kunza nukuntaga. ");
INSERT INTO mgv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Egapeta masaa matatu nhwanu waki jwahika pala nukujingi mu nyumba mola bila kumanya sokapi. ");
INSERT INTO mgv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petili anndalukya, “Pawalombisa litui boo wapatiki le lupija lolo pena?” Najombi jajibwa, “Heelo, twapatiki yeye pena.” ");
INSERT INTO mgv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petili ampwagila, “Ndaba jakii wehapa na alomi baku ntenda ujanza kunndenga Loho jaka Sapanga? Henu, Linga! Bandu baapiti kwaataga alomi baku, ahegale kuhika kugujukuu na weapa!” ");
INSERT INTO mgv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Apalapa Safila jaabukiya palongi jaka Petili na kuwa. Akakombu bala ebajingala bunketannya juwii, ndienu bumpia kunza, nukuntaga pambipi nu nndomi waki. ");
INSERT INTO mgv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kiholu kilikamula bandu ba bunhobale Kilisitu boka na bandu boti babajowana lijambu lela. ");
INSERT INTO mgv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Atumi baka Yesu batenda ndonduke na nginyuli hingi pa bandu bingi. Bandu babahobali bayobali kuketangana pamu pa sengu ngolongu jaka Solomoni. ");
INSERT INTO mgv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mundu jongi jokapi janga kuhobale ngase jalengiki kujingila ndaba batenda kwaajogopa, ila bandu bangi bangakuhobale baalongaliya malobi ga sapi. ");
INSERT INTO mgv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bandu ba bunhobali Bambu, akanalomi na aka mbomba bajonzukika ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kupete majambu gagapiti, bandu bangi baabeka agonzu babu mwiindela koni baagoniki mu itanda ni mileli, ili hejupeta Petili saagusa kihilu saki. ");
INSERT INTO mgv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bandu bingi bahika kuhuma ku musi ya pambipi na Yelusalemu, kwaleta agonzu na bandu baabi ni ilombu na boti batenda kulamiswa. ");
INSERT INTO mgv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndienu, nngolu nkolongu jwa Nyumba jukulobee na ajaaki bababi mu kikundi saka Asadukayu, baabonila wipu atumi baka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Baamua kwaakamu na kwaajigali mu ligelesa. ");
INSERT INTO mgv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ikilu jaki Ntumi jukunani jwaka Bambu jaogula milyangu jiligeleza, jwaapia kunza na kwaapwagi ana, ");
INSERT INTO mgv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nnzenda mwakajema ku Nyumba jaka Sapanga mwakaapwaagila bandu boka malobi gawomi.” ");
INSERT INTO mgv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Atumi baka Yesu batenda kujetake, bajingala mu Nyumba jukulobe lukela nukutumbuli kwaabola bandu. Pajahika nngolu akolongu na ajaki, baakema aseja buku Izilaeli nukutenda kikau kikolongu na kaapwagi bandu baaleta atumi baka Yesu bala kuhuma kuligelesa. ");
INSERT INTO mgv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lakini bandu bala pabaikaa pala ngasebaaketani atumi baka Yesu mu ligelesa lee mola. Baamua kujenda kukikau sela kupwaga sekipiti ku ligelesa. ");
INSERT INTO mgv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Baapwagila ana “Tuliketani ligelesa apungiki ngamaa kila upandi na alonda alondika papu. Lakini patuogula milyangu jela ngase tunketani mundu jokapi nkati jene.” ");
INSERT INTO mgv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nkolongu jwaalonda na agolu akolongu ba nyumba jaka Sapanga pabajogwaa lijambu heli batenda kuhola, ngasebamanyiki sekihengiki pala. ");
INSERT INTO mgv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Apalapa jaika mundu jumu, jwaapwagila ana, “Bandu bamwaajigalii muligelesa bala, saajenu abii mu Nyumba jaka Sapanga atenda kwaabola bandu” ");
INSERT INTO mgv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ndipala nndonda nkolongu mu Nyumba jaka Sapanga pamu na bandu bangi bajendaa kuliekalu kola, na kwaaleta. Lakini ngase baakamula kwamakili, ndaba bajogopa bandu awesa kwapega na malibu. ");
INSERT INTO mgv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ndienu baamua kwaapeleka, na kwaajemeka palongi ja pasengu. Nngolu nkolongu mu Nyumba jaka Sapanga jaapwagila, ");
INSERT INTO mgv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tunkaniki mwanganya kwaabola bandu kupetee liina laka mundu hoju, henu nndetiki mabolee ginu pa Yelusalemu poka henu mpala bandu atusukila twepani kupete kuwa kwaka mundu hoju.” ");
INSERT INTO mgv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ndienu Petili pamu na atumi baka Yesu bangi bala bajibua, “Kupalika tunzetakia Sapanga, kuliku mundu jongi. ");
INSERT INTO mgv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sapanga wa atati bitu anhyoa Yesu jomunkoma mwanganya suku mbambalii panani ju nsalaba. ");
INSERT INTO mgv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Sapanga ankwea jombi kunani nukumbeka upandi waki wa malele, na kuba kilongosi nu Nkombosi witu ili jaapekiya napwasi bandu buku Izilaeli kujetake mahakau gabu ukugaleka ili Sapanga jaalekake mahakau. ");
INSERT INTO mgv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twepani ndi twetulibona kwa mihu gitu lijambu leheli, pamu na Loho jaka Sapanga jaka Sapanga jejuletiki Sapanga kwa bandu boka babunzetake, najombi jubona lijambu lee heli.” ");
INSERT INTO mgv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Atumi boka ba pa sengu pala pabajogwana batenda kuyoma ngamaa, nukupala kwa akoma. ");
INSERT INTO mgv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lakini mfalisayu jumu jobunkema Gamalieli, jojabii Mbola wa Malagalaki gaka Musa jojamanyikini ngamaa nabandu, jajema pikikau pala, nukupwaga atumi bala apita hoti kunza kipindi kisokopi. ");
INSERT INTO mgv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ndienu jaa pwagila atumi bapasengu jela, “Mwa bandu buku Izilaeli, nhwasalia oti nakanopi kabula jukutenda sempala kwa bandu haba. ");
INSERT INTO mgv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nkomboka mwandi kidogu, jabii mundu jumu bunkemika Teuda, jukipunika kwa bandu kupwaga jombi mundu nkolongu na bandu baaegale mia nsesi bajongana na jombi. Lakini pabunkoma pee, apwasi baki boka batenda kutilani ni kikundi sela satenda kuwa. ");
INSERT INTO mgv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Alafu hegwapeta muda, kipindi suku balanga bandu sela, japitila Yuda juku Galilaya. Hoju najombi jaahuta bandu bingi nabombi batenda kumpwata, najombi batendaa kunkoma na apwasi baki batenda kubokane. ");
INSERT INTO mgv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nahenu nepani numpwagi kabee, mwitenda sokapi kwa bandu abaa, mwaalekakyaje! Ndaba ana mpangu hogu waka mundu, witenda kujomukane. ");
INSERT INTO mgv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lakini ana mpangu wehogu guhuma kwaka Sapanga ngamwiwesi kupenga gaatenda haga. Mwalikolila mumpenga Sapanga.” Ndi baamua pee kupwata gajalongila Gamlieli. ");
INSERT INTO mgv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Henu baamua kwakema aka atumi bala, nukuamu kwalapu iboku na kaapwagi akotuka kubola kabee bandu liina laka Yesu, ndienu baalekakiya ajendaninya. ");
INSERT INTO mgv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Atumi baamua kubokane mu sengu mola koni atogule ngamaa ndabaje bajetaki baapoa lihamu kupetee liina laka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Baendaliya kwaabola bandu na kaalandi bandu Lijambu la Amboni laka Yesu Kilisitu mu nyumba jukulobe na muma nyumba ga bando kila lisoba. ");
INSERT INTO mgv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hegwapeta muda kidogu, banafunzi hebabii aendalee kujonzukeka, gatumbuliya manung'uniku kati ja Ayaudi babalongila luga ji Kigiliki na Ayaudi babalongila Kiebulania. Ayaudi babalongila Kigiliki banug'unika kupwaga, paabagi mahitaji ga posu ga kila lisoba, bandu babu baawi alomi babu atendika kwajegwa. ");
INSERT INTO mgv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Henu atumi komi na abeli bala baakema banafunzi boka pamu, nukupwaga, “Nga sapi twepani tukotuka kulandii lilobi laka Sapanga kwa bandu ndaba jukubagii bandu mahitaji ga posu. ");
INSERT INTO mgv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Henu mwalongu bitu nhagula bandu saba baamboni, baatweli Loho jaka Sapanga jaka Sapanga na baabi bana malangu ili twaapekiya lihengu le heli bombi. ");
INSERT INTO mgv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Twepani twiibia tutumi muda witu kuloba kwaka Sapanga nilihengu lukupeta kulandi lilobi laka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gabaamua atumi gaapendisa bandu bingi, ndienu baamua kunhagu Sitivini, mundu jojunhobale Sapanga ngamaa nujutwelii Loho jaka Sapanga, Pilipi na Pulokolo na Nikolasi na Timona na Palimena na Nikolao juku Antiokia jojabii kudini ju Uyaudi kabla jukuamu kumpwata Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Baabeka palongi jaka atumi, nabombi batenda kwaabekee maboku panani jabu na kwaalobe. ");
INSERT INTO mgv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lilobi laka Sapanga laendalia kuene na idadi ja banafunzi ku Yelusalemu jajonzukeka ngamaa, na agolu baka Sapanga bingi bunzetaki Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sapanga ampengeli Sitivini nukumpeke makili, jwatenda nginyuli na ndonduke ingi pabandu bingi. ");
INSERT INTO mgv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lakini bandu ba Nyumba jukuketangane Ayaudi jeakemika “Bandu baalekakiwi.” Nabombi bauma ku Kilene nuku Alekisandilia na Ayaudi bangi kuhuma ku Kilikia nuku Asia batenda kumpenga Sitivini sukubisana naku. ");
INSERT INTO mgv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lakini ngasebunwesike ndaba Loho jaka Sapanga jumpekia malangu gingi pajabia jwakalongila nabu. ");
INSERT INTO mgv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Baamua kapeke lupija ili apwagaa, “Tunzogwini Sitivini julongee malobi gu kuntondoo Musa na Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sukutenda hela baakolakya bandu ili ayoma, aseja na aka abola ba Malagalaki. Ndienu baamua kunkamu Sitivini nukumpeleka kusengu ngolongu. ");
INSERT INTO mgv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pa sengu jepala baaleta bandu balonge isoli babapwagaa, “Mundu hajoo kila lisoba jupatondoo pandu pa sapi paamba na Malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ndaba tunzowini twabeti jakapwaga akiti Yesu juku Nazaleti hoju jwiitenda kupa alabana pandu paa sapi pani nukung'anambu kila setuyobali sejutubolaa Musa.” ");
INSERT INTO mgv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Boti bababii atemi pa sengu pala bundingalya Sitivini, bumbonaa pamiu jaki pabii ngati ntumi juku nani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Henu nngolu nkolongu jwa nyumba jaka Sapanga andalukiya, “Gatugajowana haga gasakaka lena.” ");
INSERT INTO mgv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Najombi Sitivini jajibwa ana, “Mwaalongu bangu naaka atati bangu, nnyowana nee! Sapanga jaapitila ahoku bitu Ibulahimu pajabii ku Mesopotamia kabula jukujenda kutama ku Halani. ");
INSERT INTO mgv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Sapanga ampwagila ana, ‘Guboka pandema julukolu waku, waaleka bandu bulukolu lwaku gujenda ku ndema jenagulangia.’ ");
INSERT INTO mgv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ndipala, Ibulaimu jwaboka ndema ja Kalidayo, nukujenda kutama ku Harani. Baada ja kua atati baki, Sapanga amboa kabee ku Halani nukundeta pu ndema pantama mwanganya saajenu. ");
INSERT INTO mgv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sapanga ngaseampeki Ibulaimu ndema ili jibia jaki, ngaseampekii hata pandu pasokopi pukubeka lwaji lukugolu kwaki. Lakini Sapanga ampwagila jwiitenda kumpekee ndema jenu jiibia jaki na jabana baki nikilongu saki sekiisaliwa, masoba ge gala Ibulaimu ngasejwabii na mwana. ");
INSERT INTO mgv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Sapanga ampwagila, ‘Kibeleku saku sewibelika kiijenda kutama kuugeni, nakola biikuba atumwa nukuteseka muda wa yaka miya nsesi. ");
INSERT INTO mgv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lakini nepani naapekya azabu bandu bandema jebantumakya na mwenikatai mwiiboka pandema jejela nukunumbali nepani paamba.’ ");
INSERT INTO mgv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ndi Sapanga jwatenda malaganu na Ablahamu na nginyuli yaki jabii kuseku jandu. Ndienu Ablahamu jwaamua kunseku jandu mwanawaki Isaka lisoba la nani baada jukusaliwa. Isaka najombi ansekula jandu Yakobu. Najombi Yakobu jaasekula jandu banabaki babaikuba aseja komi na abeli bala.” ");
INSERT INTO mgv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aseja bala bumbonila wipu Josepu baamua kundombesa ili jwakabia ntumwa ku Misili. Lakini Sapanga jwabii pamu na jombi, ");
INSERT INTO mgv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","anhokua pajabii mu mang'aliku goka. Sapanga ampekya Falao jojabii bambo nkolongu juku Misili uwesu gukumpala jombi na Sapanga ampekia Josepu malangu gingi na jombi Falao, anhobalii ngamaa nukumbeka julongusa pa Misili ni lijumba loti lu ubambu. ");
INSERT INTO mgv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Monikatai japitila inzala ngolongu ku Misili nuku Kaanani, inzala jela jaleta ling'ai likolongu. Aseja bitu bala ngasebabii nikilebe, ");
INSERT INTO mgv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo hejajowana ku Misili kubii nikilebi kingi jaatuma banabaki ndi aseja bitu bala ajenda ku Misili kola mala ja kwanza. ");
INSERT INTO mgv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hebajenda mala ja pili, Josepu julitambulisa kwa alongu baki na Falao jaamanya alongu baki Josepu. ");
INSERT INTO mgv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josepu jaamua kwaatuma bakaajukua atati baki na alongu baki boka ajenda ku Misili, boka babi bandu sabini nu nhwanu. ");
INSERT INTO mgv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ndienu Yakobu jajenda kutama ku Misili kojawelila jombi na bana baki. ");
INSERT INTO mgv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Maiti gabu bapelika ku Shekemu, na kwaataga mulitenge lejwalomba Ibulahimu kupete lupija kuhuma kulukolu lwaka Hamoli. ");
INSERT INTO mgv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pagahika masoba gukutimisa malagisu gaka Sapanga, gajapwaga antendila Ibulahimu, bandu bitu ku Misili bajonzukika na kuba bingi. ");
INSERT INTO mgv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ndienu, bambu nkolongu jongi jwanga kummanya Josepu, jwatumbuliya kulongosa ku Misili. ");
INSERT INTO mgv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jwaatendila bandu bitu liya, na kwaang'alisa bandu bitu na kwaalasimisa baabeka bana babu akeki kunza atama kajika ili akua. ");
INSERT INTO mgv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Masoba gegala jasaliwa Musa, najombi jabii mwana waa sapi ngamaa kwaka Sapanga. Atati baki na amabu baki buntunza ku nyumba kwa muda wa miei mitatu. ");
INSERT INTO mgv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pabasindwa kunhia, bajenda kumbeka kulosi na kamwali waka Falao heambona jatenda kuntondola nukuntunza ngati mwana waki jukumbeleka. ");
INSERT INTO mgv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ndienu bumbola Musa umanyi woti guku Misili, jwabii mundu jojubii nu uwesu nkolongu ukulonge nu kuhenga mahengu. ");
INSERT INTO mgv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pajwabii na yaka alubaini jwaamua kataputa alongu baki ku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kola ambona mundu juku Misili jumu andapu Nhizilaeli jumu, jwajenda kungombo nukundepese sukunkoa mmisili jola. ");
INSERT INTO mgv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa jawasaliya Aizilaeli ajaki baeliwi Sapanga antumia jombi kwaagombo bombi, lakini ngasebaeliwe. ");
INSERT INTO mgv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kilabuje, jwaabona Aizilaeli abeli atenda kukomana, jwalenga kwaakengale nakaapwagi, ‘Mwanganya mwanalukolu, ndaba jakii nkomana mwabeni kwa mwabene?’ ");
INSERT INTO mgv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jojabiya andapu nzaki wejola ankanga Musa pulutengu nukumpwagi, ‘Jojukubei weapa gubia kilongosi na mundu jukutukengalee twepani nyane.’ ");
INSERT INTO mgv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Boo, gupala lee kungoma nepani ngati heunkoma Mmisili jola liso?’ ");
INSERT INTO mgv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa pajajogwa malobi gala, jajenda ku Midiani nukutama kola ngati nngeni nakola japataa bana abeli akanalomi.” ");
INSERT INTO mgv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pajapeta yaka alobaini, Atumi bu kunani baka Bambu ampitila Musa kukitengu sesabia kinyaka motu kulukoba pambipi nikitombi saa Sinai. ");
INSERT INTO mgv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa jasangii ngamaa hejabona lijambu lela, pajaegalya jalingalya sapi jajowa sauti jaka Bambu jakapwaga, ");
INSERT INTO mgv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nepani ndi na Sapanga wa ahoku baku, Sapanga waka Ibulahimu ni Isaka na Yakobu!’ Musa jwatumbuliya kubagaja jabii nu lujogopu lukolongu ngase jwalengiki kulingali kabee ngane. ");
INSERT INTO mgv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ndienu Bambu ampwagila, ‘Guhula ilatu yaku ndaba pagujemi je hapa pandu pa sapi. ");
INSERT INTO mgv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Sakaka naabweni bandu bangu Aizilaeli eang'alika ku Misili. Nyowini kilelu sabu su usungu nanepani nhulwiki kuhika kwaahoko. Henu guhika nukutuma ku Misili.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Hoju ndi Musa jola jobunkana Aizilaeli pabapwaga, ‘Nyaa jojukubekiti weapa gubia kilongosi witu twepani na jukutukengale twepani?’ Kwi indela juku Ntumi jukunani joampitila Musa kupete kitengu sela sesabiya kinyaka mwotu, Sapanga antuma Musa hoju jubiya kilongosi nu nkombosi witu. ");
INSERT INTO mgv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndi jojwaalongua Aizilaeli aboka ku Misili nukutenda nginyuli na ndonduke ku Misili, mu nhanga uku Shamu nuku lukoba, kwa yaka alubaini. ");
INSERT INTO mgv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jonioju Musa jojaapwagila bandu buku Izilaeli, ‘Sapanga jwileta mlota jongi jojwibia ngati nepani, kuuma mukilongu sino.’ ");
INSERT INTO mgv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aizilaeli pababii pamu kulukoba kola, Musa jabii kola ngati ntenga kati ja aseja bitu nu ntumi jukunani jojalongila naku Kukitombi si Sinai, najombi jwajopa malobi ga womi kutulete twepani.” ");
INSERT INTO mgv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakini aseja bitu bakana kunzogwane Musa, na bapala kubuja kabee ku Misili. ");
INSERT INTO mgv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bumpwagila Aloni, ‘Utulenganakiya imong'umong'u yeyaatulongua, ndaba ngase tumanyi sesumpatiki Musa jojutuboiki twepani ku Misili.’ ");
INSERT INTO mgv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sabia kipindi sebililenganakiya kimong'umong'u sekilengana ni litoli la ng'ombi, bijipekya matambiku nukujitende tipati sindu sesuse ndi lihengu la maboku gabu. ");
INSERT INTO mgv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sapanga jaamua kuboka kati jabu, jwaaleka agungamaliya ndondu yu kunani, ngati hebaandiki mukitabu saka Alota baka Sapanga, ‘Mwabandu buku Izilaeli! Ngasenabii nepani jomuntendila matambiku nukumpekee nhupi muda wa yaka alubaini kulukoba. ");
INSERT INTO mgv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwanganya mwajukwi lihema laka kisapanga sinu Moleki, na imong'umong'u ya ndondu yaka sapanga winu Lefani, imong'umong'u ye muilenganakya ndi yemwabiya mwilumbali. Henu nampelika kuluhami kutali kupeta ku Babeli.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kulukoba kola aseja bitu babii lihema la sapi lelabii ni ibau ya malaganu. Balenganaki kulengana na Sapanga heandagalakya Musa jutenda ngati eandangia. ");
INSERT INTO mgv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ndienu aseja bitu bapokiana beni kwa beni mbaka hesaika kipindi saka Yoshua, pabijijopa nndema gola kuhuma kwa bandu bajwaabenga Sapanga nabombi babii papu. Latamaa pala mbaka kipindi saka Daudi. ");
INSERT INTO mgv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Sapanga ampala ngamaa Daudi, najombi andoba Sapanga anzetakiya kunsenge pandu pukutama Sapanga waka Yakobu. ");
INSERT INTO mgv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakini Solomoni ndi joa nsengila Sapanga nyumba jene.” ");
INSERT INTO mgv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hata hela Sapanga ngase jutama mu nyumba jejusengiti mundo, ngati hejupwaga Mlota waka Sapanga: ");
INSERT INTO mgv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Bambo jupwaga, ‘Kunani ndi kiteu sangu su Ukolongu nuku ndema ndi kiteu sangu sukubeke magolu. Mwinzengila nyumba bole? Pandu boo nepani paniiwesaa kupomulela? ");
INSERT INTO mgv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Boo, hindu yoka ngase nabombaa lee namwete? Au lee nganepani nenahenga haga gote?’ ” ");
INSERT INTO mgv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mwabandu mwanga kujowana! Mioju jii jibii ngati bandu banga kummanya Sapanga. Masoba goka mumpenga Loho jaka Sapanga ngati hebahenga aseja binu. ");
INSERT INTO mgv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jubii lee Mlota jokapi jwanga kung'aliswa naaka aseja bino? Baakoma Alota babatumwa na Sapanga kulandi lijambu lukuhika jojujetakeka palongi jaka Sapanga. Na sajenu mwanganya munkaniki nuku nkoma. ");
INSERT INTO mgv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwanganya mwajopa malagalaki gaka Sapanga kupete atumi baki buku nani, lakini mwanganya ngase mugajetakile.” ");
INSERT INTO mgv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Aseja ba sengu bala pabajowa malobi goka gala, bayoma ngamaa bahamua kumpole minu koni ndaba babii ni inyela. ");
INSERT INTO mgv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakini Sitivini koni jutweeli Loho jaka Sapanga, jalingalia mihu kunani, jugubona ulumbi waka Sapanga na Yesu jujemiki upandi wa malele waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jwapwaga, “Lotika kunani kuhogwiki na mwana waka Adamu jujemiki upandi wa malele waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lakini bombi batenda kujamali, nukuhibali makutu kwa maboku gabu, ndi boka bunhombila pamu. ");
INSERT INTO mgv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Baamua kumpeleka kutali kuhuma ku musi, nukutumbuli kunndapu kwa malibu. Na bababona bala bahula makoti gabu nukumpekee jukamula nkombu jumu jobunkemika Sauli. ");
INSERT INTO mgv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pabaendaliya kunndapu Sitivini kwa malibu jombi jwatenda kundoba Sapanga koni jupwaga, “Bambu Yesu gujopaa loho jangu.” ");
INSERT INTO mgv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ndienu jwapega magoti, nukulela kwa sauti ngolongu konijupwa, “Bambo koto kwaabalangii lihakau lendeno. Hejajomula kupwaga hela jahabuka pai nakuwa.” ");
INSERT INTO mgv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli najombi jabii apalapala, jatenda kujetake lijambu lukunkoma Sitivini. Lisoba lee lela bandu babuhobale Kilisitu buku Yelusalemu latumbulia kung'alika ngamaa. Bandu boka ba bunhobale Sapanga, kulekape atumi baka Yesu, babaganiki kutili ku Yudea nuku Samalia. ");
INSERT INTO mgv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bandu bangi babumpala Sapanga buntaga Sitivini nukunndele ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lakini Sauli jatumbuliya kwaakoma bandu babuhobale Kilisitu, jajingala kila nyumba na kwakamuu bandu ba ahobale aka mbomba na akanalomi na kwaajege muligelesa. ");
INSERT INTO mgv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bandu ba ahobale babaganiki bala, bajenda kila pandu koni baka landila Lijambu la Amboni laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Najombi Pilipi jajenda ku musi nkolongu juku Samalia na kaalandi bandu baatama kola Lijambu la Amboni laka Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bandu pabajowa malobi gaka Pilipi nukujibona ndonduke je jwatenda, baamua kunzogwane namangani. ");
INSERT INTO mgv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ilombu yaapita bandu bingi, koni ipega keleli, bandu baalei nhyega na bini ilema boti batenda kulama. ");
INSERT INTO mgv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Musi gola gwoka wabii nalaa ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Henu jwabii mundu jumu bunkema Simoni jatenda uhabi muda gwingi mmusi jemola, bandu boka buku Samalia bunsangii jombi, najombi jukipuna kubanga jombi mundu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bandu boka akolongu na asoku, bunzowanakiya ngamaa nukupwaga, “Mundu ajoo jubii nu uwesu waka Sapanga gobugukema, ‘Uwesu Nkolongu.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bandu bingi bumpwata jombi ndaba jeni jaasangisi bombi kupetee uhabi waki. ");
INSERT INTO mgv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lakini pabahobali malandi gaka Pilipi pajaalandila Lijambu la Amboni lukolongu waka Sapanga ni liina laka Yesu Kilisitu, aka mbomba na akanalomi baamua kubatiswa. ");
INSERT INTO mgv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni najombi jatenda kuhobale nuku batiswa. Jaamua kumpwata Pilipi kila pandu, koni jusangaa nginyuli na ndonduke yejuibona. ");
INSERT INTO mgv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Atumi baka Yesu bababi ku Yelusalemu pabajowana bandu buku Samalia bilijetaki lilobi laka Sapanga, baatuma Petili na Yohana ajendaa nabombi. ");
INSERT INTO mgv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pabaika ku Samalia baalobila kwaka Sapanga bandu boka bahobale nabombi ajopa Loho jaka Sapanga ");
INSERT INTO mgv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ndaba jeni Loho jaka Sapanga jabii ngase junhuluki mundu hata jumu, babipee atei kabatisa kupete liina laka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ndipala Petili na Yohana babekila maboku panani jabu, nabombi bajopa Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni pajabona bandu ajopiki Loho jaka Sapanga kupete kwaabeke maboku gaka atumi baka Yesu panani jabu, japala kwapeke lupija Petili na Yohana nakaapwagi, ");
INSERT INTO mgv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nanepani kabee mmbekiya uwesu wehogu, nane jokapi jonammbekila maboku gangu panani jaki, jujopa Loho jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petili jajibua, “Lupija lwaku luobila kutali pamu na wamweti, ndaba guholale guwesa kulomba nhupi jaka Sapanga kupete lupija! ");
INSERT INTO mgv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wehapa ngase gubii na pandu wala haki jokapi jukutenda lihengu laka Sapanga ndaba jeni mwoju waku ngasegubii sapi palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nala gujetakia mahakau gaku nukugaleka, ndi hundoba Bambu najombi kwaa juwesa kugulekake mawasu gaku gehaga. ");
INSERT INTO mgv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ndaba nugubweni ubii nu usungu ngamaa kabee ubii mukipungu sa mahakau.” ");
INSERT INTO mgv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ndienu Simoni jaapwagila Petili na Yohana, “Nandi munobila kwaka Bambu, goka gampwagiki giimbata nandino.” ");
INSERT INTO mgv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petili na Yohana pabajomula kupwaga gabagabona babuja ku Yelusalemu. Pababii mwindela balandila Lijambu la Amboni laka Sapanga mu ijiji ingipi yuku Samalia. ");
INSERT INTO mgv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Atumi baka Bambu bu kunani ampwagila Pilipi, “Gujiandia kujenda upandi ukusini kupete ndela jejiuma ku Yelusalemu kujenda ku Gaza jejibii ku lungwenza.” ");
INSERT INTO mgv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Najombi Pilipu juliandila nukujenda. Hejwabii mwindela, jwaketangana nu nkolongu jumu towashi juku Esiopia. Mundu hoju jwabii kilongosi, lihengu laki labii kujemalee hindu yoka yaka Kandake malikia juku Esiopia. Jwapiti ku Yelusalemu kunndumbali Sapanga enu jutendika kubuja jwatemi muligali laki lelihutwa na maponda. ");
INSERT INTO mgv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pajukubika jubuja kunyumba jaki koni jutemi muligali laki jabia jusoma kitabu saka Isaya Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Loho jaka Sapanga jumpwagila Pilipi, “Gujenda pambipi ni ligali lelabii lihutwa na maponda gupwatana nalu.” ");
INSERT INTO mgv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipi julijommbatakiya ligali lelihutwa na maponda lela, najombi anzogwana mundu jola jusoma kitabu saka Mlota Isaya. Pilipu anndalukya, “Boo guelewa lee gagusoma geaga?” ");
INSERT INTO mgv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Najombi jwajibua, “Niwesa boo kuelewa bila mundu kunongowa?” Jaamua kunndoba Pilipi jukwela muligali lelihutwa na maponda nukutama pamu. ");
INSERT INTO mgv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nkolongu jola jusomika lipungu la maandiku ganga, “Jwabii ngati likondoo leajenda kulisinza, jwabii kinunu ngati likondoo helitumbaa pabilisekuu mangoma. Ngase jwalongii sindo. ");
INSERT INTO mgv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bumpoa lihamu nukunzima sejabia jakapata. Ngajojwiwesa kulonge kuhusu kibeleku saki, ndaba jeni womi waki ukutama punndema pani atei kuguboa.” ");
INSERT INTO mgv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mundu juku Esiopia jola jwaamua kundaluki Pilipi, “Nagumbwagila, mlota hoju anndongale nyane? Jililongale mweni au mundu jonge?” ");
INSERT INTO mgv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ndipala Pilipi jatumbuliya nilipungu la maandiku agalaga gajabia jwakasoma, kulandi Lijambu la Amboni laka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pabaendaliya na sapwali, bahika pandu papabii na masi na kilongosi jola anndalukya Pilipu, “Pamba masi gabi boo, kibi lee sindu sukumbenga nee kubatiswa?” ");
INSERT INTO mgv_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipu jajibwa, “Ana guhobale kwa mwoju waku woka uwesa kubatiswa.” Najombi jajibwa, “Nehobale Yesu Kilisitu Mwana waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Alafu jwaamulisa ligali lelihutwa na maponda lela lijema. Boka abeli Pilipi na Towashi jola bahulukaniya nukujingi mu masi na Pilipi ambatisa nkolongu jola. ");
INSERT INTO mgv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pabapita kunza ja masi, Loho jaka Sapanga jaka Bambo junzukua Pilipi nu kuboka naku kwa gafula nu nkolongu jola ngaseambweni kabee, lakini jwaendaliya kubuja koni jutogule. ");
INSERT INTO mgv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipi julibona jubii ku Azotu, jwaamua kupete kila musi kulandi mbaka pajwaikaa ku Kaisalia. ");
INSERT INTO mgv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Masoba ge gala, Sauli jwaendalya kwaajogopesa bandu na kwaakoma apwasi baka Bambo. Lisoba limu jajenda kwaka Ngolu Nkolongu jwa Nyumba jaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nukundoba anhandakiya balua juku nzetake muma Nyumba jukuketangane Ayaudi ku Damasiko, ndaba ana anketani kola mundu jokapi jola mmbomba au mwanalomi jojupwata Indela jaka Bambo jela, jwaakamula na kwaaleta ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pajwabii mu sapwali jaki pambipi kuhikii kumusi uku Damasiko, apalapa unang'anakiya unang'anu kuuma kunani nuku nhyongolota kila upandi, ");
INSERT INTO mgv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","jwaabuka pai, nukujoana sauti jumpwagi, “Sauli, Sauli” Ndaba jaki gutenda kuning'alisa? ");
INSERT INTO mgv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli japwaga, “Wee wanya, Bambo?” Sauti jela jajibwa, “Nena Yesu joung'alisa. ");
INSERT INTO mgv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Enu gujema, gujenda ku musi nakola bakupwagila segupalika kuhenga.” ");
INSERT INTO mgv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bandu bababi ajenda pamu na Sauli bala bajema pala kinunu, ngasebawesiki kulonge lilobi, ndaba bajogwana sauti jela lakini ngasebumbweni mundu jojalongilaje. ");
INSERT INTO mgv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli jajumuka, pa jalenga kuyeku mihu gaki ngasejawesiki kukibona sokapi. Ndienu bunkamula kuboku nuku nndongo mbaka ku Damasiko. ");
INSERT INTO mgv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli jatama masoba matatu bila kulinga, na kipindi se hesi ngasejakuliki sokapi wala kunywa sokapi. ");
INSERT INTO mgv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ku Damasiko kola jabi mbolee jumu bunkema Anania. Bambu ankema sukuyekuliwa, “Anania!” Najombi jajibwa, “Ne mipamba Bambo.” ");
INSERT INTO mgv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bambu japwaga, “Uliandia ujenda ku indela jebijikema indela jejinyokiki, ukalalukya mu nyumba jaka Yuda mundu jojuhumi ku Taliso jobunkema Sauli. Sajenu andoba Sapanga, ");
INSERT INTO mgv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na mmabonikanu ambweni mundu joankema Anania jakajingila nkati nukumbeke maboku panani jaki ili juwesa kulinga kabee.” ");
INSERT INTO mgv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lakini Anania jajibwa, “Bambo, nyoini majambu gaka mundu we hoju kuhuma kwa bandu bingi, nyowini majambu giliya gajwaahengi bandu baku buku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Najombi juikiki pa Damasiko pamba jupatiki uweso kuhuma kwaka agolu akolongu kwakamu bandu boka baaloba kupete liina laku.” ");
INSERT INTO mgv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lakini Bambu japwaga, “Jenda pena, ndaba nunhagwi ili jundumakiya, kulilandi liina langu ku ndema yoka na kwaka bambu akolongu babu na kwa bandu buku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nenamweti nanndangia goti gajupalika kung'alika ndaba ji liina langu.” ");
INSERT INTO mgv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ndienu, Anania jatenda kujenda, jajingala mu nyumba jeheji. Ndipala jabeka maboku gaki panani jaka Sauli, nukumpwagi, “Nndongu wa Sauli, Bambu Yesu jojukupitila pa wabii ku indela kuhika pani, jundumiki nee ili uwesa kulinga kabee nukugutwelake Loho jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Apalapala hindu ngati magamba ga homba yahabuka kuhuma mmiu gaka Sauli, ndienu jawesa kulinga kabee. Jajema nuku batiswa. ");
INSERT INTO mgv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na baada jakula posu, makili gaki gatenda kunkelabuki kabee. Sauli jatemi masoba masokopi pamu na apwasi baka Yesu ku Damasiko. ");
INSERT INTO mgv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Apalapa jatumbuliya kaalandi bandu mu Nyumba jukuketangane Ayaudi kupwaaga Yesu ndi Mwana waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bandu boti babunzowanya batenda kunsanga, koni bakapwaga, “Boo, ngale jojaakoma bababia aloba kupete liina lele ku Yelusalemu kola? Kabee jahika pani kwaakamu na kwaapeleka kwaka agolu!” ");
INSERT INTO mgv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli jahendiliya kupata makili, na ejaendiliya kulangi pangwendu Yesu ndi Kilisitu, Ayaudi buku Damasiko hoku ngasebawesiki kumpenga. ");
INSERT INTO mgv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Egapeta masoba gingi, Ayaudi baketangini pamu kutenda mpangu ukunkoma Sauli. ");
INSERT INTO mgv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lakini Sauli jamanyiki lijambu lukunkoma leheli. Ikilu na lyoba mutu balonda milyangu gukujingali pa musi ili bunkoma. ");
INSERT INTO mgv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakini ikilu banafunzi baki bunzukua, nukunhele pai mu kitonga kikolongu kupete napwasi jejabii mulumatu. ");
INSERT INTO mgv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli pajaika ku Yelusalemu jalenga kujongana na apwasi bala. Lakini boti batenda kunzogopa ndaba ngase bunhobali ngati najombi jabii mpwase. ");
INSERT INTO mgv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ndi pala Balunaba jwahika nukunzuku Sauli, ampelika koabi atumi baka Yesu na kaalandi Sauli heambona Bambu mwindela na Bambu hejwalongi naku. Jaapwagila kabee Sauli hejabii jaalandi badu sanga kujogopa ku Damasiko. ");
INSERT INTO mgv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ndienu, Sauli jatama pamu nabu, nukuyongolota Yelusalemu joka koni julandi lilobi laka Bambu bila kujogopa. ");
INSERT INTO mgv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kabee jalongi nukubisana naka Ayaudi baalonge Kigiliki, lakini bombi balenga kunkoma. ");
INSERT INTO mgv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bandu bala babubobale Kilisitu pabamanya lijambu heli, bunzukua Sauli, bumpelika ku Kaisalia, nukunndeka jujenda ku Taliso. ");
INSERT INTO mgv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kipindi se sela bandu babuhobale Kilisitu boti buku Yudea poti, ku Galilaya, nuku Samalia babia nulukwali. Kwi indela jujujangatiwa na Loho jaka Sapanga bapata makili nu kujonzukeka ngati ebaendaliya kutama koni antende isima Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petili pajabia jujendajenda kila pandu, kabee jahika kwa bandu baka Sapanga bababia atama ku Lida. ");
INSERT INTO mgv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kola ankolila mundu jumu jobunkema Ainea jojuwe jabi jugoni pikitanda muda wa yaka nani ndaba jabi jutei kulela nhyega. ");
INSERT INTO mgv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ndienu, Petili ampwagila, “Ainea, Yesu Kilisitu jutenda kukulamisa. Jumuka gutandika kitanda sako.” Na muda gogo Ainea jwatenda kujumuka. ");
INSERT INTO mgv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bandu boti buku Lida nuku Saloni bunndingalya Ainea, na boti bunng'anambukya Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jwabi mpwasi jumu mmbomba ku musi uku Yopa jobunkema Tabita. Kukigiliki, “Dolikasi.” Mana jaki, “Kinyama simwiki holi sebikikema mbawala.” Mmbomba hoju jwabia juhenga majambu ga sapi na jabii juyobali kwajangati aka kapuku. ");
INSERT INTO mgv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kipindi sehesi jwalwaliki, nakuwa. Bandu bijigolua nhyegajaki, nukujigoneka mu sumba su kunani. ");
INSERT INTO mgv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ndaba ku Yopa nga kutali ngani kuhuma ku Lida, apwasi baka Yesu hebajowana Petili jubi ku Lida, baatuma bandu abeli bunndoba, “Pepa guhika kongo nyatanyata.” ");
INSERT INTO mgv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ndipala, Petili jajenda pamu nabu. Pajahika bumpelika ku sumba su kunani. Kola bandu bingi baawi alomi babu bunhyongwaliti Petili koni alela nukundangi makoti ni ingobu yengi yejwalenganaki Dolikasi pajabi na womi waki. ");
INSERT INTO mgv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petili jaapia boka kunza, japega magoti, nukundoba Sapanga. Ndi anng'anambukiya mundu jojuwi jola, nukupwagi, “Tabita, jumukaje.” Najombi jwaogula mihu gaki, heambona Petili jatenda kutama pai. ");
INSERT INTO mgv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petili akamula kuboku nukunzangatiya kujema, nakaakema bandu baka Sapanga bala na bandu baawii alomi babu bala, jwaakabisa mundu jola koni jubi mwomi. ");
INSERT INTO mgv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lijambu heli laenia ku Yopa kwoka na bandu bingi bunhobalya henu Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petili jwaendaliya kutama masoba gingi ku Yopa, jwatama kwaka mundu jumu jojulenganake ngosi jobunkema Simoni. ");
INSERT INTO mgv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jwabi mundu jumu ku Kaisalia jobunkema Kolinelio, nkolongu wi kikundi sa alonda sebikikema, “Kikundi suku Italia.” ");
INSERT INTO mgv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jabi mundu jwaamboni, jombi pamu na bandu boka buku nyumba jaki babia bandu babunzetake Sapanga nukunndumbali, jaajangatya hindu aka kapuku bingi nukundoba Sapanga kila lisoba. ");
INSERT INTO mgv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lisoba limu sa tisa lyobamutu, jabona pee pangwendu majambu kuhuma kwaka Sapanga ntumi jukunani jwaka Sapanga jujingi nkati nukumpwagi, “Kolinelio!” ");
INSERT INTO mgv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolinelio andingaliya ntumi jukunani jola koni jujogopa, andalukia, “Kibiki Bambu?” Ntumi jukunani jola jwapwaga, “Sapanga jujetaki kuloba kwaku na matambiku gaku gawaapeki haka kapuku henu nga jugujewe. ");
INSERT INTO mgv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Heno, waatuma bandu ku Yopa bukunkema mundu jumu jobunkema Simoni, liina lengi Petili. ");
INSERT INTO mgv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jombi jubi ku nyumba jaka Simoni jojulenganake ngosi, nyumba jaki jibi mulutengu ju nhanga.” ");
INSERT INTO mgv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ntumi jukunani jojulongila na Kolinelio jola hejabia jubokiki, Kolinelio jaakema atumisi baki abeli nundonda waki jumu joanzetake Sapanga, ");
INSERT INTO mgv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","jaapwagila majambu goka gagapitii, nakaatuma ku Yopa. ");
INSERT INTO mgv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kilabu jaki, bandu atatu bala koni akona ajenda, lakini ebaegaliya kuhika ku Yopa, Petili jwakwela kunani kukipagaa sa nyumba, kwabii sa sita lyobamutu jajenda kundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jabona inzala, jwatokulya kula posu. Pababia ahanda posu, jwabona hindu kuhuma kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jwabona kunani kwaka Sapanga kuogwiki na sindu ngati shuka bikihulu pai koni bikikamwi kona yoka nsesi. ");
INSERT INTO mgv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nkati ja shuka jela mwabi na kila aina ji inyama, inyama yana magolu nsesi, inyama yeikwaba pundema ni ijuni yukunani. ");
INSERT INTO mgv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ndi jajowana sauti kuhuma kunani, “Petili, jumuka usinza, ukulaje!” ");
INSERT INTO mgv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petili jwajibwa, “Ngahela Bambu, nengase nhwaiki kuonza sindu sokapi seakaniki kula au kipija.” ");
INSERT INTO mgv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sauti jela jajowanika kabee koni jumpwagi, “Hindu yeisapisiki na Sapanga wahikema ipija!” ");
INSERT INTO mgv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lijambu heli lahengiki mala patatu, ndi shuka jela jakelabuka kabee kunani. ");
INSERT INTO mgv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petili pajabi jwakona juholale ndaba jaki majambu gala jutei kugabona, apalapa bandu bajwaatumiki Kolinelio bahikapala baada jibona nyumba jaka Simoni, ");
INSERT INTO mgv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","bakema sukujamali, “Boo, jubi nngeni konioku jobunkema Petili?” ");
INSERT INTO mgv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petili jwabi jwakona juwasali majambu gajugabweni, ndi pala Loho jaka Sapanga jumpwagila, “Jowana! Abi bandu atatu, atenda kukupala. ");
INSERT INTO mgv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Uhuluka wala wisita kujenda pamu nabu ndaba naatumiki nepane.” ");
INSERT INTO mgv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ndi pala, Petili jwauluka pai, nakaapwagi bandu bala, “Nepani ndi jomumpala. Nhikiki pamba ndaba ja kike.” ");
INSERT INTO mgv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bombi bapwaga, “Jututumiki nkolongu jwa alonda jobunkema Kolinelio, jojuwe mundu wa asapi joanzetake Sapanga na Ayaudi boti antende isima. Ntumi jukunani ampwagila jukukoka kunyumba jaki ili jujowana malobi gawampwagila.” ");
INSERT INTO mgv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petili jwatenda kwa ajopa, jaapekya pandu pukugone ikilu jela. Kilabu jaki, Petili jwatumbulya sapwali pamu na bombi, na bandu bangi ba bunhobale Kilisitu buku Yopa kola bajenda pamu najombi. ");
INSERT INTO mgv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lisoba la pili jaki bahika ku Kaisalia na kola Kolinelio jwabi jwaalendale pamu na alongu baki na akosi baki bangi bajwabi jwaakokiki. ");
INSERT INTO mgv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petili pajwabi jutenda kujingi mu nyumba, Kolinelio jwapita kunza kunzopa, jwapega magoti nukunzinami pai. ");
INSERT INTO mgv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lakini Petili jwatenda kuntondabe, nukumpwagi, “Jemaje, hata nepani na mundu pena.” ");
INSERT INTO mgv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petili jwaendalya kulonge na Kolinelio koni ajingi mu nyumba kojaakoli bandu bingi atemi pamu. ");
INSERT INTO mgv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petili jaapwagila, “Mwanganya mmanyiki mundu juku Uyahudi jokapi, akolongu badini akaniki jwijongana na bandu banga Ayaudi. Lakini Sapanga jumoliki nammbona mundu jokapi kuba ngasejujetakeka kwaka Sapanga au mpija. ");
INSERT INTO mgv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Henu, henngemiki nane nhikiki sanga kujogopa. Henu, nundaluki, nngemi kike?” ");
INSERT INTO mgv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolinelio japwaga, “Masoba gatatu gagapetiki, lisaa ngati lele, la tisa lyoba mutu, nabi ndenda kuloba mu nyumba. Mala pee, mundu jojwabi juweti ingobu yeing'aliki jwajemiki palongi jangu, ");
INSERT INTO mgv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","japwaga, ‘Kolinelio! Kuloba kwaku na nhupi yaku yewapeke aka kapuku ijetakiki na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ntuma mundu ku Yopa jukunkema mundu jumu jobunkema Simoni, liina lengi Petili, jubi kunyumba jaka Simoni jojulenganake ngosi pambipi nunhanga.’ ");
INSERT INTO mgv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ndienu apalapa naatuma bandu kwaku, naweapa utei sapi kuhika. Henu, twepani tubi pani palongi jaka Sapanga kujoane sokapi sejukutumiki Bambu kutupwagi.” ");
INSERT INTO mgv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndienu Petili jatumbulya kupwaga, “Henu manyiki sakaka Sapanga ngasejubagu bando. ");
INSERT INTO mgv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mundu jukuhuma nndema jokapi joanzetake Sapanga nukutenda gajupala Sapanga jutenda kunzopa. ");
INSERT INTO mgv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Lende ndi lijambu lejulipelika Sapanga kwa bandu buku Izilaeli, koni julandi Lijambu la Amboni lelileta lukwali kupete indela jaka Yesu Kilisitu, Bambu wa bandu boka. ");
INSERT INTO mgv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwanganya mmanyiki lijambu lelapitila ku nndema juku Yudea, kutumbuli ku Galilaya baada ju ubatisu gojwaalandila Yohana bandu. ");
INSERT INTO mgv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Namwanganya mmanyiki Sapanga heanhagwi Yesu juku Nazaleti kuhenga lihengu laki koni ampeki makili ga Loho jaka Sapanga nukumpeke uwesu. Sapanga jwabi pamu najombi jwajenda koni na kola jwakatenda majambu ga sapi na kwaalamisa bandu bababi lyatukali lijobi. ");
INSERT INTO mgv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Twepani ndi twetwabona majambu goka ga jutendiki munndema ja Ayaudi nuku Yelusalemu. Bunkoma sukumbambali mu nsalaba, ");
INSERT INTO mgv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","lakini Sapanga anyoa lisoba latatu, nuku nhwesesa jubonikana kwa bandu, ");
INSERT INTO mgv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ngasejabonakini kwa bandu bote, ila kwa bandu bababi ahaguliwi na Sapanga ili bagabona haga nukulonge, ndi twepani twetwakula na kunywa pamu najombi baada jukuyoka kwaki kuhuma kwa bandu baawi. ");
INSERT INTO mgv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jutulagalakya kulandi Lijambu la Amboni kwa bandu boti nakaapwagi bandu jombi ndi jojuaguliki na Sapanga kuba jukutemu bandu baawi na bandu bomi. ");
INSERT INTO mgv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Alota baka Sapanga boti bundongali jombi kupwaga boti ba bunhobale jwitenda kundekake mahakau gaki goka kupete liina laki.” ");
INSERT INTO mgv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petili pajwabi jwakona juendale kulonge, Loho jaka Sapanga jaahulukya boti bababi ajowane lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayaudi babunzetake Sapanga babahikiki pamu na Petili bala kuhuma ku Yopa, basangi kubona Sapanga jwaapeki nhupi ja Loho jaka Sapanga hata bandu banga Ayaudi, ");
INSERT INTO mgv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ndaba baajowana bakalongila kwa luga ingeni koni bundumbali Sapanga. Ndi Petili japwaa, ");
INSERT INTO mgv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bandu haba bunzopiki Loho jaka Sapanga jaka Sapanga ngati twabete hetunzopaje. Boo, jubijokapi jojuwesa kwapenga biibatiswa kwa masi?” ");
INSERT INTO mgv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Henu, jaamua abatiswa kwiliina laka Yesu Kilisitu. Nabombi bunndoba jutama nabu kwamasoba gangi kidogu. ");
INSERT INTO mgv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Atumi baka Yesu na bandu bangi ba bunhobale Sapanga buku Yudea bajogwa kupwaga bandu banga ayaudi babi bilijetaki lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Henu, Petili pajabuja kuhuma ku Yelusalemu, banafunzi biki Yaudi baapala bandu banga ayaudi asekula jandu, batenda kunndosa koni baka pwaga, ");
INSERT INTO mgv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Weapa gupiti mu nyumba ya bandu banga kuseku jandu hadi gukuliki nabu posu pamu!” ");
INSERT INTO mgv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ndi Petili jatumbulya kulandi mbolimboli majambu gagapitii kola tumbuka puutumbuli. ");
INSERT INTO mgv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lisoba limu panabi ndenda kuloba ku musi guku Yopa, nabi ngati ndei kuinduka ndi nabona hindu kuhuma kwaka Sapanga, nabona sindu ngati shuka ngolongu bikijihulua kuhuma kunani koni bijikamwi kona yoka nsesi, nukubeka pulutengu jangu. ");
INSERT INTO mgv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nalingalia nkati sapambipi nabona inyama yeibi na magolu nnsesi, inyama yu mukioli niinyama yeikwaba pai ni ijuni. ");
INSERT INTO mgv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Apalapa nijijogwana sauti jakambwagila, ‘Petili jumuka, usinza, ukulaje.’ ");
INSERT INTO mgv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lakini nepani napwaga, ‘Ngaela, Bambo, ndaba sindu sokapi kipija au seakaniki kula ngasekiwahiki kujingi mu ndomu jango.’ ");
INSERT INTO mgv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sauti jela jajowanika kabee kuhuma kunani, ‘Waikema sindu sokapi kipija sejikihengiki Sapanga kuba kisapi.’ ");
INSERT INTO mgv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lijambu heli lahengiki mala patatu, na mwisu we hindu yela yoka yakelabwiki kunani kabee. ");
INSERT INTO mgv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Apalapa, bandu atatu bababi baatumiki kuhuma ku Kaisalia bahika ku nyumba jenabia nakatama. ");
INSERT INTO mgv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Loho jaka Sapanga jambwagila nyenda nabu bila kujogopa. Bandu sita haba balongana nanepani kabee kujenda ku Kaisalia na kola twajingala kunyumba jaka Kolinelio. ");
INSERT INTO mgv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jombi jutulandi hejwabi ambweni mtumi jukunani jujemiki kunyumba jaki nukumpwagi. ‘Ntuma mundu ku Yopa jukunkema mundu jumu jobunkema Simoni, liina lengi Petili. ");
INSERT INTO mgv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jombi jakupwagila malobi ga gagujangatya kugombolewa.’ ");
INSERT INTO mgv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Naenatumbulya kulonge pee, Loho jaka Sapanga jaahulukya ngati hejutuhulukya twepani. ");
INSERT INTO mgv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ndi nakombuka malobi gajwapwaga Bambu, ‘Yohana jabatisa kwa masi, ila mwanganya mwibatiswa kwa Loho jaka Sapanga.’ ");
INSERT INTO mgv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Henu, ana Sapanga jwaapeki kabee bandu bukuhuma ku ndema jengi nhupi ajelaje jejutupekya na twepani patunhobalya Bambu Yesu Kilisitu, boo, nena na nyane mbaka nenga kumpenga Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pabajogwana gala, batulia nukundumbali Sapanga koni bakapwaga, “Sapanga jwaapeki bandu banga Ayaudi napwasi juku lekakewa mahakau ili apata womi!” ");
INSERT INTO mgv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ndaba jamang'aliku gagapitila pabunkoma Sitivini, abole batenda kupalaganyika. Bangi bajenda mbaka ku Foinike, ku Kupulo nuku Antiokia koni bakalandila lijambu la sapi kwaka Ayaudi pena. ");
INSERT INTO mgv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakini Ayaudi bangi babahuma ku Kupulo nuku Kilene, bajenda ku Antiokia nukulandi Lijambu la Amboni laka Bambu Yesu lela, kwa bandu buku ndema jengi. ");
INSERT INTO mgv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Makili gaka Bambu gabii pamu nabombi bandu bingi bahobali nukunng'anambuki Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lijambu heli lajogwanika mbaka kwa bandu ba bunhobale Sapanga buku Yelusalemu. Ndi buntuma Balunaba kujenda ku Antiokia. ");
INSERT INTO mgv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pajwahika kola nukubona Sapanga hejapengali bandu, jwatoguli na kwaaloba aendalia kujongana na Bambu kwa mioju jabu joka. ");
INSERT INTO mgv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balunaba jwabi mundu jojutweli Loho jaka Sapanga na jojunhobale Sapanga. Nabandu bingi bajonzukika kwaka Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ndienu, Balunaba jwajenda ku Taliso kumpwata Sauli. ");
INSERT INTO mgv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paampata, anndeta ku Antiokia. Boti abeli batama kola nabandu baka Sapanga kwa saka soka koni abola likundi likolongu la bandu. Ku Antiokia kola ndi kobatumbulya kwakema banafunzi baka Yesu, akilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kipindi aselasela, Alota baka Sapanga bangi bahika ku Antiokia kuhuma ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Henu, jumu katijabu jobunkema Agabo jwajema, nukupete makili gaka Loho jaka Sapanga jalotila kwibia niinzala ngolongu mu ndema joti. Inzala heji japiti Kilaudio pa jabii bambu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Banafunzi bala baamua kila jumu kulengana nuuwesu waki jupelika sokapi ili kwaajangati bandu bababi atama ku Yudea bala. ");
INSERT INTO mgv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Henu, Batenda ahelahe nakaapeke Balunaba na Sauli nsangu gola buhupelika beni kwaka aseja babandu ba bunhobale Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sabi kipindi ngati aselase, nkolongu Helodi jatumbuliya kwang'alisa bandu bangi ba bunhobale Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ankoma Yakobu, nndongu waka Yohana nu upanga. ");
INSERT INTO mgv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hejwabona lihengu laki heli Ayaudi batei kutogule, jatenda kuendale, ankamula Petili. Lijambu heli lahengika lisoba la tipati jukula mabumunda ganga kujege amila. ");
INSERT INTO mgv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pabunkamula pee Petili, bumpelika kukipungu, bumbeka pai ju ulonda wiikundi nsesi, yeibii na alonda nsesinsesi. Helodi jwapala kundeta pa bandu baada ji lisoba likolongu la kula mabumunda ganga kubeka amila. ");
INSERT INTO mgv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Henu, Petili pajabi muligelesa, bandu ba bunhobale Kilisitu babii bunndobe ngamaa kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ikilu, kabula jilisoba lelabi Helodi andeta Petili palongi ja bandu, Petili jwabi jugoni pikilanda ja alonda abeli. Babi ankongiki minyolu mibeli na alonda babi alonda bupu ndyangu nkolongu uli ligelesa. ");
INSERT INTO mgv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Apalapa, ntumi jukunani kwaka Sapanga jwajema pambipi najombi na unang'anu wang'ala sumba siligelesa. Ntumi we hoju angusa piimbau nukunzumu, “Jumuka nyata!” Apalapa minyolu jela jebunkongiki maboku jatenda kusekuka nukuabuka pai. ");
INSERT INTO mgv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ntumi jukunani waka Sapanga jola ampwagila, “Likonga nkanda waku, guwata ilatu yaku.” Najombi jwatenda helahela. Ndienu Ntumi jola jwapwaga, “Wata likoti laku, gunyengalya.” ");
INSERT INTO mgv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petili anzengalya kujenda kunza lakini ngase jwamanyiki ana gajutei Ntumi jukunani haga gasakaka, jwawasalya julota ndotu. ");
INSERT INTO mgv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baapeta kikundi sa kwanza sa alonda na kikundi sa pili, nukuiki pundyangu wa somasoma gukujingali kumusi. Ndyangu gola waoguka pee weni, nabombi bapita kunza. Babi ajenda mwiindela na apalapa Ntumi jola andeka Petili kajika jaki. ");
INSERT INTO mgv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pala ndi Petili pajamanya gagapitii japwaga, “Henu manyiki sakaka Bambu antumiki Ntumi waki jukunani junhokula mmaboku gaka Helodi nukumoha mmajambu gilya goka gabapala kunhenge Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pajamanya hela jwajenda kunyumba jaka Malia amabu baka Yohana jobunkema Maluko. Homu bandu bingi babi pamu atenda kunndoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petili jwahotima pundangu wakunza na ntumisi jumu mmbomba jobunkema Loda, jwajenda punndyangu kujeteka. ");
INSERT INTO mgv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mmbomba jola pajujimanya Sauti jaka Petili jwatoguli ngamaa, jwabutuka bila kuogo nnyangu na kwaapwagi ajaki, Petili jujemiki kunza. ");
INSERT INTO mgv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bumpwagila mmbomba jola, “Gubi lee na mangongo!” Lakini jombi jahingamakiya kwabii sakaka, nabombi bumpwagila, “Jonioju Ntumi waki jukunani waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kipindi sehesi Petili jwabi juendale kuhotima. Ebahogula nndyangu, hebumbona, batenda kusangaa. ");
INSERT INTO mgv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petili jwakinyulya kwa maboku gaki kwaalangi atama kinunu, ndi jaalandila Bambu heamboa muligelesa. Kabee jaapwagila bumpwagila lijambu leheli na Yakobu na bandu bangi ba bunhobale Kilisitu bala, najombi jwaboka nukujenda kongi. ");
INSERT INTO mgv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakwakusa, alonda bala bahangajiki ngamaa koni alaluana gagumpiti Petili. ");
INSERT INTO mgv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helodi jwaamulisa buntaputa, lakini ngase bumpatike. Ndienu jwalalukya alonda bala nuku pia amuli akomika. Ndienu, Helodi jaboka ku Yudea kola, nukujenda ku Kaisalia nukutama kola. ");
INSERT INTO mgv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helodi jwaayomi ngamaa bandu buku Tilo nuku Sidoni. Ndi bandu bamisi mibeli heji bajetanganhya pamu kujenda kuketangana naku. Nabombi batumbulya kumpata Bulasito jubia upandi wabu, ndaba Bulasito jwabii mundu nkolongu jojijemale nyumba jaka bambu nkolongu. Ndienu bunzendila Helodi bundoba ajongana sulukwali, ndaba ndema jabu jabia jipata posu kuhuma ndema jaka bambu nkolongu. ");
INSERT INTO mgv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lisoba limu lebilihagwi, Helodi jwabi juweti ingobu yaki yu ubambu nukutama pikiteu su ubambu, jwaalandi malobi gaki bandu. ");
INSERT INTO mgv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bandu bala bapega keleli nukupwaga, “Jenze sauti jaka sapanga, nga jaka mundo.” ");
INSERT INTO mgv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Apalapala Ntumi jukunani kwaka Sapanga anhabua Helodi pai ndaba ngaseampekia Sapanga ndumbali yela. Yunkula imbeku nakuwa. ");
INSERT INTO mgv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lakini Lilobi laka Sapanga laendalya kuene na bingi batenda kulijopa. ");
INSERT INTO mgv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Baada jaka Sauli na Balunaba kujomo lihengu labu, baboka kabee ku Yelusalemu, bunzukua Yohana jobunkea Maluko. ");
INSERT INTO mgv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kwaka bandu ba bunhobale Kilisitu buku Antiokia kwakabi na bandu bangi bababi alota baka Sapanga na aka abola, nkati jabu jwabi Balunaba, Simoni jobunkema Nzilu, Lukio juku Kilene, Manaeni jojabi jukoli nu nkolongu Helodi, na Sauli. ");
INSERT INTO mgv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pababia buntende Bambu ulumbi koni apungiki kula posu, Loho jaka Sapanga japwaga, “Mmekila Balunaba na Sauli pulutengu ndaba jilihengu lenaakemi.” ");
INSERT INTO mgv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Henu, baada juku nndoba Sapanga nuku punga kula posu, baabekila maboku, nakaaleka ayetuana. ");
INSERT INTO mgv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Henu, Loho jaka Sapanga pajaatuma pee Balunaba na Sauli, bajenda ku Selukia, nukuhuma kola bakwela sitima mbaki ku kilwa juku Kupulo. ");
INSERT INTO mgv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pabahika ku Musi uku Salami, balandi lilobi laka Sapanga munyumba jukuketangane Ayaudi. Yohana jobunkema Maluko jabi mundu jakaajangati. ");
INSERT INTO mgv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bajenda kuhuma upandi gumwa gwa kilwa mbaki ku Papo, upandi gongi, na kola bunketani unhabi jumu Nyahudi jobunkema Bali Yesu jojulikopaki jombi mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Hoju jabi nkosi waka Seligio Pauli, nkolongu wa kilwa sela, jojwabii mundu jwana malangu ngamaa. Seligio Pauli jaakema Balunaba na Sauli ili jujogwana lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakini nhabi jola, jobunkema kukigiliki Elima, jalenga kwaapenga Balunaba na Sauli ili nkolongu jwa kilwa jola jwing'anambuka nukutumbuli kunhobale Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Henu, Sauli jobunkema liina lengi Pauli, koni jutweli Loho jaka Sapanga, antupila mihu nduuu nhabi jola, ");
INSERT INTO mgv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","japwaga, “Wamwana waka lijobi weapa, weapa wumbaja wa kila sindu sa asapi, ngale ukotoka hata mala jimu kung'anambu ndela yaka Bambu yeinyokiki kuba yisoli! ");
INSERT INTO mgv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Enu, kuboku kwaka Bambu kwibia panani jaku. Wibia wanga linga ngaguwesi kabee kugubona unang'anu wa lyoba kwa muda.” Apalapa kila sindu jukibona ngati likongobu na lwii, jatumbulia kupapaa koni na koni kuntaputa mundu jukunkamu kuboku ili anndongua. ");
INSERT INTO mgv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nkolongu jwa kilwa jola pajwabona gala, anng'anambukiya Sapanga nakuba mpwasi, jasangi ngamaa mabole gaka Bambu gajajowini. ");
INSERT INTO mgv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pauli naajaki bakwela sitima kuhuma ku Papo bahika ku Peliga musi huku Pamfilia, lakini Yohana jaaleka, nuku kelabuka ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lakini bombi baendalia kujenda kuhuma ku Peliga mbaki kumusi uku Antiokia juku Pisidia. Lisoba lu Kupomulela bajingala mu nyumba jukuketangane Ayaudi, nukutama. ");
INSERT INTO mgv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pabajomula kusoma kitabu sa malagalaki na maandiku ga alota, aka kilongosi ba nyumba jukuketangane Ayaudi buntuma mundu kwabu, nakaapwagi, “Alongu bito ana mmbi nililobi lokapi lakaapwagi bandu ili biikata tamaa, mpwagaje.” ");
INSERT INTO mgv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ndienu, Pauli jwatenda kujema nakaponge kuboku, nakaapwagi, “Mwabandu buku Izilaeli na mwaboka mwemundumbali Sapanga, nnzowania. ");
INSERT INTO mgv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sapanga wa bandu haba buku Izilaeli baagula aka hoku bitu, nakaajangati abia bingi ngamaa pababi ku Misili. Sapanga jaaboa kola kwa makili gaki makolongu. ");
INSERT INTO mgv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sapanga jaainakali yaka alubaini pababi kulukoba. ");
INSERT INTO mgv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Najombi baada jakaakoma bandu ba makabila saba ga ndema juku Kaanani nakaapeke bandu babu ili ndema heji jibia jabu. ");
INSERT INTO mgv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yapeta yaka miya nne na hamusine. “Ndienu jaapekia bandu bukutemu baalongua mbaki kipindi saka Samweli Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ndienu bandu baloba apata bambo nkolongu, ndi Sapanga jaapekia Sauli, mwana waka Kishi julikabila laka Benyamini, jojwabi bambo nkolongu kwa yaka makomi nsesi. ");
INSERT INTO mgv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Baada jukummboa Sauli ubambu ukolongu, jwaapekia Daudi kuba bambu nkolongu wabu. Sapanga anndongalia koni jupwaga, ‘Nummbweni Daudi mwana waka Yese, jojuulengani mwoju wangu jojwihenga kila senipala.’ ");
INSERT INTO mgv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhuma mukilongu saki mundu hoju, Sapanga, ngati hejutulagila, jwaapelakia bandu buku Izilaeli nkombosi, ndi Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kabula jukuhika kwaka Yesu, Yohana anndonguli koni jaalandi bandu boti buku Izilaeli ajetakia mahakau nukugaleka nukubatiswa.” ");
INSERT INTO mgv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","“Yohana pajabi jujomule malobi gaki jwaapwagila bandu, ‘Nhwasali nepani nanyane? Nepani nga jomundendalela. Nnzoaniya, j ojuhika munyuma jangu nepani hata nepani ngase ndakiwa kubopo ngoji yi ilatu yaki.’ ");
INSERT INTO mgv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mwalongu bangu, mwabandu bulukolu lwaka Ibulahimu, na mwabangi mwaboha mwemundumbali Sapanga! Lijambu lendenu lu ukombosi lihikiti ndaba jitu twepani. ");
INSERT INTO mgv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ndaba bandu buku Yelusalemu na akolongu babu ngasebummanya ana jombi nkombosi, wala ngasebaeliwi malobi gaka alota baka Sapanga gaasoma kila Lisoba lu Kupomulela. Lakini bugutenda ulota hogu gutimia pabung'alisa Yesu nukunkoma. ");
INSERT INTO mgv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ngase bapatiki ndela jukunkome, bundoba pee Pilatu jwaalekila bunkoma. ");
INSERT INTO mgv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pabajomula kutenda goka gagumpwaga mu maandiku gikitabu, bunhulua punsalaba nukunhyelale pilitenge. ");
INSERT INTO mgv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakini Sapanga anhyoa kuhuma kubandu baawi. ");
INSERT INTO mgv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Najombi masoba gingi, jaapitila bajwabii nabu tumbuka ku Galilaya mbaka ku Yelusalemu. Haba ndi sajenu baalongalee majambu gaki kwa bandu buku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Natwepani tuhikiki pambani kunndete Lijambu la Amboni, lijambu lejaalagila Sapanga aka hoku bitu kwaatende, ");
INSERT INTO mgv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","juhamwi kututende twepani twaka kibeleku sabu paanhyoa Yesu kuhuma kwa bandu baawi. Ngati healembiki mu kitabu sa zabuli japili, ‘Weapa wa Mwanawango, nepani lelenu ndei kukubeleka.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kabee Sapanga heanhyoa kuhuma kwa bandu baawi ili jwiibole mulitenge, jwapwaga ana, “Naakupekia hindu ya sapi na yasakaka yenundagila Daudi.” ");
INSERT INTO mgv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na mu maandiku gangi ga Zabuli japwaga, “Ngaunndeki waa Sapi waku jola jubola.” ");
INSERT INTO mgv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ndaba, Daudi mweni pajajomula lihengu laki leampekia Sapanga mumasoba gaki na kabee jwawi nukuntaga pambipi na aseja ajaki na nhyega jaki jabohile. ");
INSERT INTO mgv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lakini Sapanga anhyoa kuhuma kwa bandu baawi na ngasejwabohile. ");
INSERT INTO mgv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Henu, mmanya mwaalonguba, kupete ndela jaka mundu hoju lijambu lukulekakewa mahakahu bililandi kwinu kupete indela jaka Yesu, ");
INSERT INTO mgv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na kila mundu joanhobale Yesu julekakewa mahakau gaki goka, lijambu ale ngalaka wesikini kupete malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nala nzepa, ili gampata gagabi apwagiki alota baka Sapanga: ");
INSERT INTO mgv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nzogwana mwanganya mwendongama bandu bangi, Nsangia nunhobila kola! Ndaba niihenga lihengu mumasoba ginu, lihengu lelule nga mulihobale hata na mundu jumpwagi.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Balunaba pababia apita mu Nyumba jukuketangane Ayaudi, bandu bala baakokiki ahika kabee Lisoba lu Kupomulela lengi lelahika, ili alongila nunkani majambuge haga. ");
INSERT INTO mgv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pabajomula kulongalane, Ayaudi bingi pamu na bandu bandema yengi bababi bijijetaki ndela jukunhobale Sapanga ja Ayaudi nabombi bumpwata Pauli na Balunaba. Nabombi balongii nabu, nakaa pwagi aendalia kutama sukutegeme wamboni waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lisoba lu Kupomulela helahika, kalibu kila mundu pamusi pala jahika kujogwane lilobi laka Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayaudi pabuubona nsambi wa bandu babona wipu, bapenga kila sejapwaga Pauli nukuntondoo. ");
INSERT INTO mgv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hataela, Pauli na Balunaba baalongila kwamakili ngani bapwaga, “Kwabi lasima lilobi laka Sapanga lunhikila mwanganya hoti, henu ndaba mutei kulikana nukulibona mwabe ngasempala womi wamasoba goti, henu, tutenda kunndeka nakaajende bandu banga Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ndaba bambu jutulagalakia ana: “ ‘Nukubei weapa ubia unang'anu kwabandu ba ndema yengi, ili waaletila bandu ukombosi pandema poti.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bandu banga Ayaudi pabajoana haga batenda kutogule, bilimbalia lilobi laka Sapanga, na boka bababi ahaguliwi kuujopa womi wa masoba goka, babia henu ba bunhobale Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilobi laka Sapanga laheni kila pandu pa ndema pala. ");
INSERT INTO mgv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ayaudi baamua kwakwelake aka mbomba babunndumbali Sapanga na bana mali gingi naakanalomi baamanyikini pa musi pala. Batumbulia kwaang'alisa Pauli na Balunaba na kwaabenga pa musi jabu. ");
INSERT INTO mgv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ndipala Pauli na Balunaba bakung'unda luhombi mumagolu gabu kwalangi ngasebaatendi sape, nukujenda ku Ikonia. ");
INSERT INTO mgv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ila pee bandu ba bunhobale Kilisitu bababii ku Antiokia babii atweli ndogule na Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku Ikonia majambu gabi ngati hegabi ku Antiokia, Pauli na Balunaba bapiti mu nyumba jukuketangane Ayaudi ngati eayobali. Balongi kuuwesu nkolongu hata Ayaudi bi bingi na Agiliki bunzetaki Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ayaudi bangi ba bakana kuba apwasi baakwelakia nukujege mawasu galia mumioju ja bandu banga Ayaudi ili baapenga bandu ba ndema yengi. ");
INSERT INTO mgv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauli na Balunaba baendalia kutama kola muda gwini. Balongila kwamakili lilobi laka Bambu jojalangia malobi ga waamboni waka Sapanga gaki wabii wasakaka pajaawesisa kutenda ndondukela na nginyuli. ");
INSERT INTO mgv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bandu bamusi gola batenda kubaganika, bangi baajetakia Ayaudi nabangi bababi upandi waka atumi baka Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mwisu je, bandu banga Ayaudi na Ayaudi bangi bajongana na akakilongosi babu, baahamua kwaatende liya atumi bala nakaapega na malibu. ");
INSERT INTO mgv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Atumi baka Yesu pabamanya hela, batilila ku Lusitila nuku Delube, misi juku Lukaonia, na pandu yengi yapambipi, ");
INSERT INTO mgv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","baendalia kulandi Lijambu la Amboni laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jwabi mundu jumu ku Lusitila jojabi kilema toka kusaliwa, na jwabi ngasejuwahiki kujenda hata lisoba limu. ");
INSERT INTO mgv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu jola jwabia anzogwane Pauli pajwabia jutenda kulandi. Pauli andingalia ngama, na pajabona juhobale ngamaa tosa kulama, ");
INSERT INTO mgv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","japwaga kwa sauti ngolongu, “Gujema kwa magolu gaku!” Mundu jojalemi magolu jola jahomba apalapala nukutumbuli kujenda. ");
INSERT INTO mgv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nsambi wa bandu pawabona sejwatei Pauli, batumbuliya kujamali kwa luga ji ki lukaonia, “Aka sapanga atuhuluki kwitu abonikana ngati bandu!” ");
INSERT INTO mgv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balunaba bunkema Zeu, na Pauli ndaba ndi jojulongila bunkema, Helume. ");
INSERT INTO mgv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nu nngolu jwa Nyumba jaka Sapanga juku Zeu jejabii kunza ja musi gola, jaleta ng'ombi nilitaji la mauha mbaki pundyangu, jombi pamu nu nsambi wa bandu gola bapala kuboa matambiku gabu kwaka atumi. ");
INSERT INTO mgv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Balunaba pamu na Pauli, pabamanya lijambu leheli bajendula ingobu yabu nukutili kunsambi wa bandu gola koni apwaga kwa sauti ngolongu: ");
INSERT INTO mgv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Alongu bito, ndaba jaki ntenda ela? Natwepani twa bandu ngati mwanganya. Tubi pambani kunndandi mwanganya Lijambu la Amboni laka Sapanga, ili muileka imong'umong'u yanga na mana hei, munng'anambukia Sapanga jojubi mwomi, Sapanga jojubombiki kunani na ndema, nhanga na yoka yeibi nkati ja hindu hei. ");
INSERT INTO mgv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pamwandi Sapanga jwaaleka kila bandu atenda seakipala. ");
INSERT INTO mgv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata hela, Sapanga ngasejwakotwiki kulilangi kwitu sukututende majambu gaamboni. Junndete iyula kuhuma kunani, junpeke hilebi muda gogupalika, jumpeke posu nukuitenda miojuji jitogulia.” ");
INSERT INTO mgv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pamu nukupwaga hela ngase labi lihengu lisoku kwakanaki bandu bala biiboa matambiku gabu kwaapeke bombe. ");
INSERT INTO mgv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ndienu bahika Ayaudi bangi kuhuma ku Antiokia nuku Ikonia, nakaapwagi bandu ajongana na bombi, nukunndapu Pauli nukuntutuana mbaki kunza ja musi koni bawasaliya bunkomiki. ");
INSERT INTO mgv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lakini banafunzi pabaketangana pamu nukunnyongolota, jwatenda kujumuka, nukubuja kumusi. Kilabu jaki, jombi pamu na Balunaba bajenda ku Delube. ");
INSERT INTO mgv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pauli na Balunaba pabajomula kulandi bandu Lijambu la Amboni laka Sapanga ku Delube nukupata banafunzi bingi, batumbuliya sapwali kujenda ku Antiokia kupete ku Lusitila kuhika ku Ikonia. ");
INSERT INTO mgv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Baahingamakia banafunzi ba misi jela nakaapeke makili atama sapi koni ahendale kunhobale Sapanga. Baapwagila, “Twepani twaboka tupalika kupete mumang'aliku gingi kabula jukujingi mu Ukolongu waka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Hagula aseja kila pandu paabi bandu ba bunhobale Kilisitu kwaalongo banafunzi, kabee kupete kuloba nukupunga kula posu, baabeka palongi jaka Sapanga jobabia bunhobale. ");
INSERT INTO mgv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Baada jukupete nndema ja Pisidia, bahika ku Pamfilia. ");
INSERT INTO mgv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pabajomula kulandi lijambu lela ku Peliga, bajenda ku Atalia. ");
INSERT INTO mgv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuhuma hoku bakweliki sitima babuja ku Antiokia. Kola batenda kwalobe waamboni waka Sapanga ndaba jilihengu lebabi baapeki nahenu babia bilijomwi. ");
INSERT INTO mgv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabahika ku Antiokia batenda kikau sa bandu babumpwata Kilisitu bakola, baapwagila Sapanga hejutei pamu na bombi, na namuna hejuogwi indela kwa bandu banga Ayaudi jukuhobale. ");
INSERT INTO mgv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Batama pamu ku Antiokia na banafunzi bala kwa muda gwingipi. ");
INSERT INTO mgv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bandu bangi bahika ku Antiokia kuhuma ku Yudea nuku tumbulili kwaabola bandu babunzetaki Sapanga bala kupwaga, “Ana ngakuseku jandu ngati hejutulagalakia Musa, nganhwesi kukombulewa.” ");
INSERT INTO mgv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pauli na Balunaba ngase bajetaki mabole gabo ndi kwapitila kujobane nukulalukani na bandu bala, ndi baamua Pauli na Balunaba na bandu bangi kati jabu ajenda ku Yelusalemu ili kulilongale lijambu heli naka atumi baka Yesu bangi pamu na Aseja. ");
INSERT INTO mgv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ndienu bandu baanhobale Kilisitu batenda kwaatabuka, pabapetila ku Foinike nuku Samalia baalandila bandu amanya bandu banga Ayaudi bunng'anambuki Sapanga. Bandu bala hebajogwa batoguli ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabahika ku Yelusalemu bandu ba bunhobale Sapanga, atumi baka Yesu naka aseja batenda kwaajopa nabombi baalandila goka gajwatenda Sapanga pamu nabombi. ");
INSERT INTO mgv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ila pe bandu bangi ba bunhobale Kilisitu bikikundi saka Afalisayu bajema nukupwaga, “Kupalika bandu banga kuba Ayaudi asekula jandu nakaabola namuna jukupwata Malagalaki gaka Musa.” ");
INSERT INTO mgv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Henu, atumi baka Yesu na aseja batenda kikau kikolongu ili amanya sukutenda. ");
INSERT INTO mgv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Balongila muda nndasu, Petili jaamua kujema nukupwaga, “Mwalongubangu, mwabe mmanya toka masoba gukutumbuli Sapanga jwanhagula nepani nkati jitu nandila Lijambu la Amboni kwaka bandu bandema yengi, ili ajowana nukuhobale. ");
INSERT INTO mgv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Najombi Sapanga jojumanya mioju jitu, jwalangi jwaapai sakaapeke nabombi Loho jaka Sapanga ngati hejutupeki twepani. ");
INSERT INTO mgv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sapanga ngasejutubagwi kati jitu na bombi, jaalekakia mahakau gabu ndaba batenda kusapisa mioju jabu kukuhobale kwabu. ");
INSERT INTO mgv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Henu, ndaba jaki kunndenga Sapanga sakaatweka bandu haba nsigu goguwe hata aka hoku bitu wala twabe ngasetwawesiki kutoto. ");
INSERT INTO mgv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kwiikuba hela, ila tuhobale, ana twepani tubii ngati bombi, twigombuliwa kupete waamboni waka Bambu Yesu.” ");
INSERT INTO mgv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bandu boka batama nuu, baamua kwajoane Balunaba na Pauli hebalandila ndonduke na nginyuli yejwatenda Sapanga kupete maboku gabu kwa bandu banga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabajomula kulonge, Yakobu japwaga, “Mwaalongu bangu, nyowannya nepani! ");
INSERT INTO mgv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni julandi namuna Sapanga mumasoba gumunyuma hejwaatendila bandu bandema yengi, jaagula bandu bangi akuba bandu baki. ");
INSERT INTO mgv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lijambu heli lilengana na malobi gaka alota baka Sapanga, ngati Maandiku gaka Sapanga hegapwaga.” ");
INSERT INTO mgv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Hegijomuka majambu haga nihika kabee, nukusenga kabee nyumba jaka Daudi jejiabwiki, niilenganakia mang'oba gaki nukusenga kabee, ");
INSERT INTO mgv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ili bandu baaigili boti bumpala Bambu, na bandu bandema yoti banaakemiki abia bangu, bampala Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ndi hejupwaga Sapanga, jojwatenda lijambu heli limanyikana toka mwandi.” ");
INSERT INTO mgv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo jaendaliya kupwaaga, “Henu, senhamwi ne senze, tukoto kwaasumbuu bandu bandema jengi babung'anambuki Sapanga, ");
INSERT INTO mgv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ila Pee twaalembila balua kwaapwagi biikula poso jejibii mbija jeatambiki mahoka, akotuka usalati, biikula kinyama sebikinyongiki, kabee bikula mwai. ");
INSERT INTO mgv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ndaba masoba gingi malobi gaka Musa gabi galandika kila musi nukugasoma mu nyumba jukuketangane Ayaudi yoka kila Lisoba lu Kupomulela.” ");
INSERT INTO mgv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Atumi baka Yesu, aseja na bandu boka ba bunhobale Sapanga baamua kwaagu bandu nkati jabu nakaapwagi ajenda ku Antiokia pamu na Pauli na Balunaba. Henu, bunhagula Yuda jobunkema kabee Balusaba na Sila babaii akakilongosi ba bandu babahobali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Baapekia balua jejiandiki ana, “Jambuoti, twepani twaka atumi baka Yesu na aseja na alongu binu na tutenda kunhandi balua mwabandu banga Ayaudi mwanganya mwembi ku Antiokia hoku, ku Silia nuku Kilikia. ");
INSERT INTO mgv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tujowini bandu bangi babahuma koni batenda kunsumbu kwa malobi gabu, nukujibeka mioju jabu jibii nulujogopu. Twepani ngase twaalagalaki kutenda hela. ");
INSERT INTO mgv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Henu, tuamwi pamu kwaagu bandu baakumu nakaapwagi ahika kwinu pamu na akosi bitu Balunaba na Pauli, ");
INSERT INTO mgv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bandu bababii tayali hata kuwa ndaba ji liina laka Bambu witu Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Henu twaapwagi Yuda na Sila ahika hoku, kumpwagi mwanganya kupetee milomu jabu malobi gatunhandaki mu balua. ");
INSERT INTO mgv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ndienu, Loho jaka Sapanga jutupwaagi tukotoka kuntweka mwanganya nsigu ila pe majambu ganga gagapalika: ");
INSERT INTO mgv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mwikula posu jeatambaki mahoka, mwikula wala mwiikunywa mwai na mwikula inyama jikinyama seakinyongiki nzepana usalati. Mwibia ntei sapi ana nkotwiki kutenda haga. Kwaheli!” ");
INSERT INTO mgv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pabajomula kwaatabuka bandu bala, bajenda ku Antiokia kokuje bakema kikau saka bandu babuhobale Kilisitu, nakaapeke balua jela. ");
INSERT INTO mgv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pabasoma balua jela, malobi gaki gaatenda agangamala mwoju, batoguli ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, bababi kabee alota, balongila na bandu ba bunhobali Kilisitu bala kwa malobi gingi tulisa mwoju na kwaasenga. ");
INSERT INTO mgv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Baada jukutama kola kwa muda, bandu ba bunhobali Kilisitu buku Antiokia baatabuka koni baalobe lukwali, ndi babuja kwa babatumiki. ");
INSERT INTO mgv_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sila jaamua kuigali. ");
INSERT INTO mgv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pauli na Balunaba baigalia ku Antiokia kwa muda, baabola bandu nukulandi Lilobi laka Bambu, pamu na bandu bangi bingi. ");
INSERT INTO mgv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagapeta masoba kidogu, Pauli ampwagila Balunaba, “Tubuja twakaalinga bandu bala kila musi kotwaalandila lilobi laka Bambo, tukilibonila twabe eandalela.” ");
INSERT INTO mgv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balunaba japala bunzukua na Yohana jobunkema kabee Maluko. ");
INSERT INTO mgv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lakini Pauli ngase jabona sapi kujenda na Maluko, jojaaleka ku Pamfilia nukukana kuhenga lihengu pamu nabu. ");
INSERT INTO mgv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ndienu, wapitali ubisi nkolongu, ngase bajetangini, baamua kulekana. Balunaba anzukua Maluko, bakwela sitima bajenda ku Kupulo. ");
INSERT INTO mgv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Najombi Pauli anhagula Sila, baada ja bandu ba pala kundobe uamboni waka Sapanga, batenda kuboka. ");
INSERT INTO mgv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Hebabia atenda kujenda bapetila ku Silia nuku Kilikia, koni jaasenga bandu ba bunhobale Kilisitu kupete malobi gaki. ");
INSERT INTO mgv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauli jahika ku Delube nuku Lusitila, kojabi jutama mbolee jumu jobunkema Timoti. Anyongoo baki bababi kabee jabii mundu joanhobale Kilisitu, babi Ayaudi, na atati baki babi Agiliki. ");
INSERT INTO mgv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoti jabi wa mboni kwa bandu kati ja bandu buku Lusitila nuku Ikonia. ");
INSERT INTO mgv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli ampala Timoti julongana najombi mu sapwali jaki, ndi enu ansekula jandu. Jatenda hela ndaba Ayaudi boti bababia atama pala bamanyiki atati baka Timoti babi Agiliki. ");
INSERT INTO mgv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pababia apeta pa misi jela baapekia bandu malagalaki ga balagalakia atumi baka Yesu na aseja ku Yelusalemu, baapwagila bagakamulakia. ");
INSERT INTO mgv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Henu, bandu bala baendaliya kukola mu kuhobale kwabu, na banafunzi bajonzukika kila lisoba. ");
INSERT INTO mgv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bapeti ku Fulugia nuku Galatia ndaba Loho jaka Sapanga ngase jaapwagi kulandi Lijambu la Amboni ku ndema juku Asia. ");
INSERT INTO mgv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pabahika pambipi nu nkoa uku Musia, balengiki kujingi ku musi uku Bitunia, lakini Loho jaka Yesu ngasejaa jetakile. ");
INSERT INTO mgv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Henu, bapetila ku nkoa guku Musia, nuku jenda bila kugoboka mbaki ku Tiloa. ");
INSERT INTO mgv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ikilu jela, Pauli jatenda kuyekuliwa, ambona mundu jumu juku Makedonia jujemiki pala nuku nndoba, “Lombuka, uhika ku Makedonia ukutujangatiaje.” ");
INSERT INTO mgv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauli pajajomula pe kubona uyekuli gola, tuliandia kujenda ku Makedonia bila kukabaki, koni tumanyiki Sapanga jutukemiki twaalandila Lijambu la Amboni bandu baakola. ");
INSERT INTO mgv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ndi twajenda muli jojoma kuhuma ku Tiloa mbaka ku Samotilake, ni kilabu jaki twahika ku Neapoli. ");
INSERT INTO mgv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuhuma kola twahika mbaka kunkoa uku Pilipi, musi nkolongu uku ndema uku Makedonia pandu pababi mu ukolongu huku Loma. Twatemi pa musi gola masoba kidogu. ");
INSERT INTO mgv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lisoba lu Kupomulela twapiti kunza ja musi, twapiti pulutengu lwa losi pandu patwaholali tuwesa kupata pandu pukundoba Sapanga. Twatama pala nukulonge na aka mbomba bababi ajongini pala. ");
INSERT INTO mgv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kati ja aka mbomba bala bababia atenda kutujoane jabi mmbomba jumu joanzogopa Sapanga jobunkema Lidia mwenei juku Tuatila, jojabi julombesa ingobu ya zambalau ya bei ngolongu. Sapanga jaogula moju waki ili juwesa kupwata malobi gajabia julonge Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ndi jombi na bandu buku nyumba jaki batenda kubatiswa. Najombi jutuloba jakapwaga, “Ana sakaka mmbona ne nunzetaki Bambu, nhika ku nyumba jangu mwaka tama” Jutupembalakiya tujenda, twajenda pamu naku. ");
INSERT INTO mgv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lisoba limu, patwabia tujenda pandu puku nndoba Sapanga, mmbomba jumu jojabi nikilombu sukulondo jaketangini natwepani. Mbomba hoju jabia jaapeke akakolongu baki lupija lwingi kupete kulondola kwaki. ");
INSERT INTO mgv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Henu, mmbomba jola ampwata Pauli na twepani koni jupega keleli nukupwaga, “Bandu haba atumisi baka Sapanga Nkolongu. Bunndandi mwanganya ndela ju ukombosi.” ");
INSERT INTO mgv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jabia jutenda hela masoba gingi hata lisoba limu Pauli jatenda kusukia, ang'anambukia mmbomba jola nuku kipwagi kilombu se sela, “Nukuamulisa kupete liina laka Yesu Kilisitu, umpita mwenioju!” Mala pee kilombu se sela satenda kumpita. ");
INSERT INTO mgv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Henu aka akolongu bababia apata lupija lwingi kupete mmbomba jola pababona kuhobale kupata lupija kwabu kupete mmbomba jola kujomwiki, baakamula Pauli na Sila, naka atutuana mbaka kuguliu palongi jaka kilongosi ba musi. ");
INSERT INTO mgv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Baatakila kwaka bandu baatemu bapwaga, “Ayaudi haba aleta puju pa musi wito. ");
INSERT INTO mgv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Butubola tuhenga majambo gaguge twa bandu buku Loma ngase tupalika kujetake wala kugapwata.” ");
INSERT INTO mgv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nsambi wa bandu wajenda kujongana nabu kwalapu Pauli na Sila. Ndienu, bandu baatemu bala baahula ingobu yabu kwa makili, nuku kulagalaki baalapula iboku Pauli na Sila. ");
INSERT INTO mgv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pabajomula kwaalapu ngamaa baajegala nkati jiligelesa, na baalagalakia nkolongu jwa alonda biligelesa baalonda ili biitila. ");
INSERT INTO mgv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Henu ndaba jililagalaki lela, nndonda jola jaabeka mu sumba sunkati ngani siligelesa nuku gakonga magolu gabu mu mpengu. ");
INSERT INTO mgv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pambipi na pamahiku, Pauli na Sila babia buku nndoba Sapanga nuku nzembe mihambu juku nndumbali, na bandu bangi bingi ba baajigali mola batenda kwaajongwane. ");
INSERT INTO mgv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Apalapa sapitila kililima sesanyuanyua nsingi wa nyumba jiligelesa. Apalapa milyangu yoti yatenda kuhogoka ni minyolu yebaakongi bandu bala gatenda kubopoka. ");
INSERT INTO mgv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nkolongu juligelesa jatenda kujumuka nukubona milyangu giligelesa ihogwiki, jawasaliya bandu bala atilike, ndi jahopula upanga waki nuku pala kulikoma. ");
INSERT INTO mgv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lakini Pauli jajamaliya, “Walikoma ndaba twepani twaboa tubi pambane.” ");
INSERT INTO mgv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pajabiya ankemiki mundu juletaa taa, nndonda juligelesa jola jatili nkati, nukulileke palongi jamagolu gaka Pauli na Sila koni jaka bagaja sulu jogopu. ");
INSERT INTO mgv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jaalongua kunza na kwaalaluki, “Mwaakolongu, ndenda boo ili nhuwesa kukombulewa?” ");
INSERT INTO mgv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bombi bunzibwa, “Unhobalia Bambu Yesu nanagu witenda kugombolewa pamu na alongu baku boti.” ");
INSERT INTO mgv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ndienu bundandila Lilobi laka Bambu jombi pamu na alongu baki boti. ");
INSERT INTO mgv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Apalapa ikilu jela nkolongu jiligelesa jola jaajukua na kwaagolo ilonda yabu, ndi jombi na alongu baki batenda kubatiswa apalapala. ");
INSERT INTO mgv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ndienu jaajukua Pauli na Sila mbaka ku nyumba jaki, jaapekia posu akula. Batoguli ngamaa pamu na alongu baki ndaba babia henu bunhobale Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kilabu jaki pulukela, bandu bukutemu baatuma atumisi babu kwaka nkolongu uligelesa jola kumpwagi,“ Mwabopuliya bandu bala.” ");
INSERT INTO mgv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ndonda jola apwagila Pauli, “Bandu bukutemu buntumiki mundu kupwaga tunhoguliaje. Henu nhwesa kujenda bila kujogopa.” ");
INSERT INTO mgv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lakini Pauli anzibwa, “Gupwaga oti boo?” “Butulapula iboku pa bandu bila likosa ingawa twepani twa bandu buku Loma. Kabee butujegi nkati henu apala butupia bila bandu kumanya! Nga kuwesekana! Waleka beni ahika pamba kutupia.” ");
INSERT INTO mgv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Atumisi bala bakelabuka na kaapwagi bandu baatemu bala, na bombi pa bajoana Pauli na Sila babia bandu buku Loma, batenda kujogopa. ");
INSERT INTO mgv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Henu, bajenda kupwaga mpepakoku na kwaapwaagi aboka mmusi we gola. ");
INSERT INTO mgv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila bapita muligelesa, bajenda ku nyumba jaka Lidia. Kola babonana na bandu ba babunhobali Kilisitu na baagangamalisa mwoju kwa malobi gingi batenda kuboka. ");
INSERT INTO mgv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pauli na Sila baendalia na sapwali jabu, bapetila ku Amfipoli nuku Apolonia, ndi bahika ku Tesaloniki kokwabi na nyumba jukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pauli jajongana nabu ngati ebayobali, jatumia Maandiku ga Sapi kubolana nabu muda wa juma itatu kila Lisoba lu Kupomulela munyumba jukuketangane Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jaalandila nuku langi kwabi lasima Kilisitu kung'alika nuku yoka kuhuma kwa bandu baawi. Jaapwagila, “Yesu jonundandi nepani kwinu, ndi Kilisitu Nkombosi.” ");
INSERT INTO mgv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ayaudi bangi bunzetaki nukujongana na Pauli na sila. Nagombi nsambi nkolongu wa Agiliki bababia bunhobale Sapanga pamu naka mbomba bingi bini isima, batenda kunzetake Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lakini Ayaudi babona wipu, baamua kujuku bandu baliya kuhuma kuguliu, nukutenda nsambi nkolongu wa bandu batenda puju pa musi poa. Biitukaliya nyumba jaka Yasoni koni ahobale kwaapata Pauli na Sila mu nyumba mola ili baapelika kwa bandu, ");
INSERT INTO mgv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","lakini ngase baakolile, baamua kunkangana Yasoni pamu na apwasi bangi mbaka kwaaka akolongu ba musi, nuku jamali, “Bandu bamba ahengiki puju kila pandu henu ahikiki pa musi pani.” ");
INSERT INTO mgv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Najombi Yasoni jaajopiki ku nyumba jaki. Boti ngase anzetake bambu nkolongu juku Loma, ati apwaga, “Jubi bambu nkolongu jongi jobunkema Yesu.” ");
INSERT INTO mgv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Malobi gala gaajegi kiholu akolongu ba musi nu nsambi wa bandu gola. ");
INSERT INTO mgv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Baamua Yasoni naajaki abeka poni, na kwaaleka abujaje. ");
INSERT INTO mgv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ekwahika pee ikilu, apwasi bala bunhingamakiya Pauli na sila ajenda ku Beloya. Hebahika pee kola bajenda ku nyumba jimu juku ketangene Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bandu baakola babi abii tayali kujowane lilobi kupeta bandu buku Tesaloniki. Bilijetaki Lilobi laka Sapanga sukutokule kukolongu, babia aendale kulinga Maandiku ga Sapi kila lisoba, ili kumanya ga bapwaga Pauli na Sila ana gabi ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bandu bingi bunzetaki Sapanga pamu naka mbomba naaka nalomi Agiliki bini isima. ");
INSERT INTO mgv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Lakini Ayaudi buku Tesaloniki pa bajowa pee Pauli julandi lilobi laka Sapanga ku Beloya, bajenda kola, batumbuliya kuhenga puju na kugujogopesa nsambi wa bandu. ");
INSERT INTO mgv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ndienu bandu babunzetaki Sapanga bala bumpelika Pauli nyatanyata ku mbwani, lakini Sila na Timoti bahigali ku Beloya. ");
INSERT INTO mgv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bandu babuhindakiya Pauli bala bajenda pamu naku mbaka ku Atene. Ndienu, babuja na malagalaki kuhuma kwaka Pauli gagapwaga Sila na Timoti bumpwata nyata. ");
INSERT INTO mgv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli pajabia jaalendale Sila na Timoti ku Ateni, moju waki wayomiki ngamaa pajugubona musi gola gutweli imong'umong'u. ");
INSERT INTO mgv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jalongila na Ayaudi na bandu bangi babunzetaki Sapanga munyumba juku ketangane Ayaudi, na kila lisoba jabia julongalane na bandu bangi kugulio pamu na kila bandu baahika pala. ");
INSERT INTO mgv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bandu bangi bababii apwasi baka Epikulio na Sitoiko baabi aboliwi ngamaa balongila naku. Bangi bapwaga, “Jwana malobi gingi ajo jupala kupwaga kike?” Ndaba Pauli jabi julandi Lijambu laka Yesu nuku yoka kwaki, bangi bapwaga, “Kubonikana julandi lijambu laka sapanga bange.” ");
INSERT INTO mgv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ndienu bunzukua Pauli, bumpelika palongi ja sengu juku Aleopago, nukupwaga, “Tupala tumanya lijambu linyahi lewabii gutenda kulandi. ");
INSERT INTO mgv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hindu yengi yetukujogwini kwa makutu gitu ibonikana hikigeni kwiitu. Tupala kumanya mabolee manyai haga mana jaki kike.” ");
INSERT INTO mgv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bandu buku Ateni na bandu bangi ageni bababia kola babia atumi muda wabu woka kupwagani nukujogwane mabolee manyai. ");
INSERT INTO mgv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Henu, Pauli jajema palongi jikikau suku Aleopago, nuku pwaga, “Mwabandu buku Ateni! Mu majambu goti ganhenga, mona mwanganya mwa bandu balumbali aka sapanga bingi ngamaa, ");
INSERT INTO mgv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ndaba henabia mbeta hako na ako koni ninga pandu pii pukulumbali nijibona mesajimu jukupiki litambiku bijiandiki,” “kwaka Sapanga janga kumanyikana.” Henu, jo mundumbali sanga kummanya hoju, ndi jonundandi nepani kwinu. ");
INSERT INTO mgv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sapanga jojubombiki ndema joka na kila sindu sekibi momu, ndi Bambu jukunani nuku ndema, jombi ngasejutama mu nyumba jukunndumbalii jeasengiki bandu. ");
INSERT INTO mgv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wala jombi ngase buntumaki ndaba jupala sokapi, ndaba jombi ndi jojaapeke bandu womi, jaawesesa kupomo na kaapeke kila sindu. ");
INSERT INTO mgv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuhumi kwa mundu jumu jaabomba bandu boka bupunndema nakaawesesa kutama punndema pani poti. Jaamua nuku panga kabula muda ni mipaka jukutama pundema pani. ");
INSERT INTO mgv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Jatenda hela, ili bandu ba ndema yoti awesa kumpwata hata suku papaa ili buhikila. Sakaka Sapanga ngasejubii kutali na kila jumu wito. ");
INSERT INTO mgv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngati hejapwaga mundu jumu, ‘nkati jaki jombi twepani tutenda kutama, tutenda kujenda na tubi!’ Ngati bandu binu ebajemba mihambu jejipwaga, ‘Twepani twabana baki.’ ");
INSERT INTO mgv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ana twepani twa kibeleku saka Sapanga, henu twiholale Sapanga awesa kunndenganake kwa zahabu, au feza hata lilibu lealenganaki bandu kwa malangu gabu. ");
INSERT INTO mgv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sapanga jatenda ngati ngase jubona kipindi sela bandu hebabi ang'ang'a. Lakini sajenu, jaalagalakiya bandu boti kila pandu ajetakiya nukugaleka mahakau.” ");
INSERT INTO mgv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","“Ndaba jupangiki lisoba lu kutemu nndema waki ngati ekupalika, kupete mundu jumu joanhagwi ndaba jilihengu lela. Sapanga jalangi lijambu heli la sakaka sukunhyoa mundu hoju kuhuma kwa bandu baawi!” ");
INSERT INTO mgv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pabunzoana Pauli jakalongalia lijambu luku yoka kwa bandu baawii, bangi baabuha luheku, lakini bangi bapwaga, “Tupala kujowana kabee lijambu legupwagiki le heli!” ");
INSERT INTO mgv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ndienu, Pauli jaaleka, nuku pita kunza ja pasengu pala. ");
INSERT INTO mgv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Lakini bandu asokopi bajongana naku, nakuba bandu ba bunhobale Kilisitu. Kati jabu babia Dionisio juku Aleopogo nu mmbomba jumu jobunkema Damali na bandu bangi kabee. ");
INSERT INTO mgv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ndipala, Pauli jwaboka ku Atene, nukujenda ku Kolintu. ");
INSERT INTO mgv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ku Kolintu kola, anketanya Nyaudi jumu jobunkema Akila, mwenei juku Ponto. Akula pamu nunhwanu waki jobunkema Pisikila, babi ahikiki kuhuma ku Italia masoba ge gala ndaba Kaisali Kilaudio jwabi juamulisi Ayaudi boti aboka ku Loma. Pauli jwapiti kwaabona, ");
INSERT INTO mgv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","najombi ndaba jwabii pundi jukulenganake mahema ngati bombi, jwatama nabu nukuhenga lihengu pamu nabombi. ");
INSERT INTO mgv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Lisoba lu Kupomulela Pauli jwalongila nabu munyumba jukuketangane Ayaudi koni julenga kwaapata Ayaudi na Agiliki. ");
INSERT INTO mgv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoti pabahika kuhuma ku Makedonia, Pauli jwatumbulia kutumi muda waki woka kulandi Lilobi laka Sapanga, koni jaalangi Ayaudi Yesu ndi Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ayaudi bumpenga Pauli nukuntondo, najombi jwaamua kukung'unda ingobu yaki, nakaapwagi, “Ana nhobiki kwali mwabete, nepani ngasemi nilikosa. Kutumbu sajenu naajende bandu banga Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ndienu, jwaboka pala nukujenda kutama ku nyumba jaka mundu jumu joanzetake Sapanga jobunkema Titu Yusito, jojuwe nyumba jaki jabii pambipi na nyumba jukuketangane Ayaudi jela. ");
INSERT INTO mgv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, nkolongu wa nyumba jukuketangane Ayaudi jela, pamu naalongu baki boti buhobaliya Bambu. Akolintu bajogwaniya malandi gala, bahobaliya nukubatiswa. ");
INSERT INTO mgv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lisoba limu ikilu, Bambu ampwagila Pauli muuyekuli, “Wijogopa, endalya kulandi wala kukotoka, ");
INSERT INTO mgv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ndaba nepani mipamu naweapa. Ngamundu jojwilenga kuguhumisa ndaba pamusi pani abii bandu bingi baabi upandi waminenga.” ");
INSERT INTO mgv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Henu, Pauli jwatamakola koni jwaka bola bandu lilobi laka Sapanga muda wa mwaka gumu na miei sita. ");
INSERT INTO mgv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakini kipindi Galio pajabii nkolongu ju ndema guku Akaya, Ayaudi ankupaliya Pauli kwa pamu nukumpeleka kusengu. ");
INSERT INTO mgv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bapwaga, “Tuntaki mundu jonzo ndaba jwaakoloo bandu kundumbali Sapanga kwa ndela jejipengana na malagalaki gito.” ");
INSERT INTO mgv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pauli hejapala pee kulitete, Galio jaapwagila Ayaudi, “Nnzoaniya mwa Ayaudi mmbanganya! Ana lijambu lende elakabii jutei lijambu la liyaa ngamaa nakabia nunzowani. ");
INSERT INTO mgv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lakini ana kokubisana pe ndaba ja malobi, mahina na Malagalaki gii, nhamua mwabee. Ne ngase mbala kuba mundu jukutemu magambu haga!” ");
INSERT INTO mgv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ndienu, jwaabenga kuhuma pasengu. ");
INSERT INTO mgv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nabombi boha bunzonza Sositena jojabii julongo mu nyumba jukuketangane Ayaudi, bundapula apalapa palongi ja pasengu. Lakini Galio jatenda pee kwaaleka. ");
INSERT INTO mgv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli jatemi na bandu banhobale ku Kolintu kwa masoba gingi. Ndienu jaatabuka, jwakwela msitima kujenda ku Silia pamu na Pisikila na Akula. Ku Kenikilea, jamoga majunzu gabu ndaba ja nazili jejabiya jubei. ");
INSERT INTO mgv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bahika ku Epesu na papuje Pauli jaleka Pisikila na Akula, jajenda munyumba jukuketangane Ayaudi, balongalaniya na Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bundoba atamanabu kukipindi kilasu, lakini ngasejapai. ");
INSERT INTO mgv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pababiya bakaboka, japwaga, “Sapanga najupai nihika kwinu kabee.” Jaboka ku Epesu kupete sitima. ");
INSERT INTO mgv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sitima lajema ku Kaisalia, najombi Pauli jajenda ku Yelusalemu kwaalamu bandu ba bunhobale Kilisitu, ndienu jajenda Antiokia. ");
INSERT INTO mgv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jatemi kola kipingi kisokopi, ndienu jaendaliya na sapwali kukupete kila pandu pa Galatia nuku Fulugia koni jaagangamalisa mwoju bandu ba bunhobale Kilisitu boka. ");
INSERT INTO mgv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myaudi jumu joakema Apolo, mundu juku Alekisandilia na jahika ku Epesu. Jabii mundu jojumanya kulonge sapi na jojabii jumanyiki Maandiku ga Sapi. ");
INSERT INTO mgv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jabiya bummboliki indela jaka Bambu najombi mwoju waki wabii na mwotu gukuhenga majambu gaka Sapanga, jwalongila majambu gaka Yesu kwa sakaka lakini jabii jumanyiki pe ubatisu waka Yohana. ");
INSERT INTO mgv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Pisikila na Akula pabunzowana jakalongila bila kujogopa nkati ja nyumba jukuketangane Ayaudi, bunzukua kwabu nakabola indela jaka Sapanga ngati ekupalika kubiya. ");
INSERT INTO mgv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo pajaamua kujenda Akaya, alongu bala bungangamalisa moju kukumpeke balua jukummanyisa kwa bandu baakola bunzopaje. Pajahika kola, jaangatia ngamaa bandu babahobalia Kilisitu kupete waamboni waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ndaba kupete kulonge bila kujogopa jaakanakya pangwendu Ayaudi bababia apenga koni jwakalangia kupete Maandiku kupwaga Yesu ndi Kilisitu Nkombosi. ");
INSERT INTO mgv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo pajabii ku Ukolintu, Pauli jwapiti ku Epesu kupete ndela juku hitombi. Kola jaaketania banafunzi. ");
INSERT INTO mgv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jalalukiya, “Boo, pamunng'anambukia Kilisitu mumpatika Loho jaka Sapanga?” Nabombi bapwaga, “Hata, ngasetumanyi ana kubii na Loho ja Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Najombi japwaga, “Henu mwapatiki ubatisu gwa bole?” Bunzibua, “Ubatizo waka Yohana.” ");
INSERT INTO mgv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Najombi Pauli japwaga, “Ubatisu waka Yohana wabiya gupwaga bandu alekakiwa mahakau. Yohana jaapwagila bandu bunhobaliya jojuhika jola, ndi Yesu.” ");
INSERT INTO mgv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hebajowana gala, babatiswa kupete lihina laka Bambu Yesu. ");
INSERT INTO mgv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ndienu, Pauli jaabekila maboku, na Loho jaka Sapanga janhulukiya, batumbuliya kulonge luga ingeni nukutangasa Lilobi laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bandu boha babii kalibu akanalomi kome na abele. ");
INSERT INTO mgv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pauli jabi kola miei mitatu jukubika jujenda munyumba jukuketangane Ayaudi, jwabia julonge nabu bila kujogopa, jabiya julongalane nabu ili jaapata ili ahika mu Ukolongu waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lakini bangi mioju jabu jabii ngaseijetaki, bakana kuhobale, batumbuliya kulongale liyaa Indela jaka Bambu pabaketangini pala. Apalapa Pauli jilibagua nabombi, jaajukua pulutengu banafunzi baki, jabiya jakalongila nabu kila lisoba mu nyumba jukulibole jaka mundu jumu joakema Tulano. ");
INSERT INTO mgv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jaendaliya kutenda hela kwa yaka ibeli bandu buku Asia boha na Ayaudi na bandu bupundema poha, bawesa kujowana lilobi laka Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Sapanga jwahenga ndonduke yaki kupete maboku gaka Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bandu babia ajuku hitambaa ni ingobu yengi yeyabii jitumi Pauli, biipelika kwa agonzu, nabombi batenda kulama, na bababii ni ilombu nayombi yatenda kwaaboka. ");
INSERT INTO mgv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ayaudi bangi baaponga ilombu bala bajenda koni na koni bakalenga kutumi lihina laka Bambu Yesu kwa bandu bababii ni ilombu. Babiya bakapwaga, “Numpwagi mpita kupete liina laka Yesu joanndandi Pauli.” ");
INSERT INTO mgv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bababii ahenga haga bana saba baka Sikewa, nngolu nkolongu wiki Yaudi. ");
INSERT INTO mgv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lakini ilombu yapwaga, “Nummanyi Yesu, na nummanyi kabee Pauli lakini mwanganya mwakanyanye?” ");
INSERT INTO mgv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ndipala mundu we jola jwini ilombu jahombila, nakasambuli kwamakili, basoka makili boti, bapita kunza ja nyumba nukutila hehu koni alihumasini. ");
INSERT INTO mgv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Lijambu lamanyikana kwa Ayaudi boka na Ayunani baatamika ku Epesu, boti lwaajingia lujogopu, ni lihina laka Bambu Yesu latenda kuhesimika. ");
INSERT INTO mgv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bandu bingi bababii ahobali masoba ge gala bahika palongi ja bandu nukupwaga gabahengiki pangwendu. ");
INSERT INTO mgv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bandu bangi bababia ahenga majambu guuhabi bajola hitabu yabo yu uhabi, biijosa mwotu pagwendu. Pababalanga bei jiihitabu hei, babona hihiki hipandi elupu uwano ya madini ya feza. ");
INSERT INTO mgv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Henu, lilobi laka Bambu lajonzukika kusambaa ngamaa na kwamakili. ");
INSERT INTO mgv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pagajomuka majambu gala, Pauli jamua kujenda ku Yelusalemu kupete Makedonia na nuku Akaya. Japwaaga mmoju jaki, “Panakahika hoku nipalika kujenda kabee ku Loma. ");
INSERT INTO mgv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Henu jaatuma bandu abeli kati ja atumi baki, Timoti na Elasito, ajenda ku Makedonia, jahigalya muda msokopi ku Asia.” ");
INSERT INTO mgv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mumasoba ge gala japitila puju ndaba jiindela jaka Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Jwabii mundu jumu joankemika Demetilio jojabii juhenga lihengu lukulenganake hindu ya feza ye ilengana na nyumba jaka sapanga wiisoli, mmbomba joankema Alutemia. Lihengu leheli laapekiya baalenganake bala lupija lwiingi. ");
INSERT INTO mgv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetilio jaakema pamu bahenga lihengu bala na bangi bababii ni lihengu ngati heli nakaapwagi, “Mbandumwe, mmanyiki lee lupia lotupata luhumi mulihengu litu leno. ");
INSERT INTO mgv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Henu mwabe nhwesa kujoane nukulibone majambu gajuhenga Pauli, nga pa Epesu pani pena, ku Asia koti. Jombi jwaakolo na nukuhuta bandu bingi sa kwaapwagi imong'omong'u yebiilenganaki bandu yela nga sapanga hata kidogo. ");
INSERT INTO mgv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kuwesikana ngamaa lihengu litu kuba nilihina liliyaa. Ngahela pena, hata na nyumba jaka sapanga mmbomba Alutemia kuba ngasindu sa mana mwisuweni jobunndumbali hoju ku Asia koti nuku ndema koti ulumbi waki witenda kujomoka.” ");
INSERT INTO mgv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pabajogwa gala, batenda kuyoma, batumbulia kujamali, “Alutemia juku Epesu ndi nkolongu wene!” ");
INSERT INTO mgv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Musi woka gwabii na puju. Bandu bala baakamula Gayo na Alisitaliko na bandu buku Makedonia, bababi sapwali jimu pamu na Pauli. Baapelika pulubanza lu kukinii. ");
INSERT INTO mgv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauli najombi jwapala kujingi mu nsambi wa bandu bala apwasi baki batenda kumpomo. ");
INSERT INTO mgv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Akolongu bangi buku Asia, bababi akosi baka Pauli baatuma bandu kwaapwagi Pauli jwiijenda mu lubanza gola. ");
INSERT INTO mgv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Muda wegola, kila mundu jwabia jutenda kujobane, bangi alonge ale na bangi alonge ale, mbaki nkutanu watenda kualabika. Na bingi ngasebamanyiki ndaba jaki aketangini pamu. ");
INSERT INTO mgv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayaudi bunzemika Alekizanda palongi. Bandu bangi punkutanu pala bawasaliya ndi jombi jojusababishi. Henu, Alekisanda jwaakinyuliya bandu kwa maboku kulangi jupala kulikengale kwa bandu boti. ");
INSERT INTO mgv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pabamanya jwabi Nhyaudi, boti kwa sauti jimu bajamaliya, “Alutemia ndi nkolongu juku Epesu.” ");
INSERT INTO mgv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ndienu jojuhandika jwa musi gola jwaapwagila atumbala nukupwaga, “Mwabandu buku Epesu, boo, kila mundu jumanya lee musi guku Efesu goni ndi gogulonda nyumba jaka sapanga Alutemia kabee ulonda nikimong'umong'u se saabwiki kuhuma kunane. ");
INSERT INTO mgv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nga jojuwesa kukana lijambu le heli. Henu, ntulia, mwihenga sindu sokapi bila kuwasali. ");
INSERT INTO mgv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mwaakemiki bandu hababa lakini ngase bijitondwi nyumba jaka sapanga wala kuntondo sapanga witu mmbomba. ");
INSERT INTO mgv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ana Demetilio na aka pundi ajaki abi na magambu gokapi na bandu haba, sengu ibile na akolongu ba musi abi, awesa pee kutakiana kokoko. ");
INSERT INTO mgv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ana libii litatisu lengi, mulipelika sengu jejipalika. ");
INSERT INTO mgv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ndaba awesa kupeleka pasengu ndaba jukuleta puju jalelenu. Ndaba ngasetubii na sababu jukulikengalela.” ");
INSERT INTO mgv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pajajomula kupwaga hela jwaapwagila bandu aboka. ");
INSERT INTO mgv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Puju juku Efesu pajakotuka Pauli jaakema banafunzi bala, jaagangamalisa moju. Ndi pala jwatenda kwaatabuka, nu kuboka kujenda ku Makedonia. ");
INSERT INTO mgv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Japetila pandu punndema pala, konijulonge nabandu malobi gingi ga kwa gangamalisa moju. Ndi jahika ku Ugiliki, ");
INSERT INTO mgv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","jatama miei jitato. Pajabia jilianda kujenda ku Silia, jamanya aka Ayaudi babia buntende mpangu guliyaa, henu jaamua kubuja sukupetee ku Makedonia. ");
INSERT INTO mgv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopatila mwana waka Pilo juku Belea jwalongana naku nakabee Alisitaliko na Sekundo kuhuma ku Tesolonike na Gayo kuhuma ku Delube na Timoti na Tukiko na Tilofimo jukunkoa guku Asia. ");
INSERT INTO mgv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Haba butulonguli nukutulendale ku Tiloa kola. ");
INSERT INTO mgv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Twepani, helapeta lisoba la mabumunda ganga kujege amila, twakwela sitima kuhuma ku Pilipi na hela peta lisoba la tatu twahika ku Tiloa kola. Kola twatama masoba ga juma jimu. ");
INSERT INTO mgv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lisoba la jumamosi twaketangini pamu kula mabumunda. Ndaba Pauli jabia jupala kuboka kilabu jaki, jaalandila bandu nukuendale kulonge naku mbaka pamahiku. ");
INSERT INTO mgv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mu sumba su kunani setwabi yabii taa hingi yakanyaka. ");
INSERT INTO mgv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pauli pajabiya jutenda kulandi lilobi laka Sapanga, nkombu jumu jobunkema Eutuko jwatumbulya kupotoka mbolimboli mwisu we lunkamula lugonu, jwaabuka pai kuhuma ku sumba satatu suku nani kugolofa. Buntondula koni juwi. ");
INSERT INTO mgv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lakini Pauli jwahuluka pai nukujinama nukunzobate nukupwaga, “Mwikuba nikiholu ndaba womi waki wakoni nkati jaki.” ");
INSERT INTO mgv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ndienu jwakwela kabee ku sumba sukunani, janukula libumunda nakula, jaaendilia kulonge nabu kipindi kilasu mbaki pulukela, ndi nu kuboka. ");
INSERT INTO mgv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bandu bala bunzukua nkombujola mbaki kunyumba koni jubi nsima na batenda kutogule ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twepani twakwela musitima kujenda ku Asu kotwabia tunzukua Pauli. Ndi hetwapangiki je, ndaba japala juhikahoku kwa magolu. ");
INSERT INTO mgv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Henu, jutuketania ku Asu kola, tunkwea musitima, twajenda ku Mituleni. ");
INSERT INTO mgv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Patwahuma kola twaboka, kilabu jaki twahika ku Kio. Lisoba lapili twajema ku Samo nikilabu jaki twahika ku Miletu. ");
INSERT INTO mgv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pauli jabia jupala kuendale na sapwali nisitima bila kupete ku Epesu ili jwiiselewa ngani ku Asia. Jabii ni kipyau sukuhika ku Yelusalemu ku tipati ja Pendekosite ana kuwesikini. ");
INSERT INTO mgv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuhuma ku Miletu Pauli jwatuma bandu kwaa kilongosi ba bunhobale Kilisitu buku Epesu aketangana naku. ");
INSERT INTO mgv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ebahika kwaki jaapwagila, “Mmanyiki nepani henatami na mwanganya masoba goti tumbuka lisoba lukutumbuli panahika ku Asia. ");
INSERT INTO mgv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mmanyiki henuhengila Bambu sukunyenyekee goti na kwamaholi na mang'aliku gagambata ndaba jimipangu jukunzuki Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanyiki ngasenajogwipi hata kidogu kunndandi pagwendu nu kunyumba ji nukumbola sokapi sukunzangatii. ");
INSERT INTO mgv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ngati enaapwagila Ayaudi na bandu banga Ayaudi kupalika anzetakiya Sapanga nuku nhobale Bambu witu Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Henu, nenunzogwane Loho jaka Sapanga, nyenda ku Yelusalemu lakini ngasemanyiki sekimbata hoko. ");
INSERT INTO mgv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila semanyiki, Loho jaka Sapanga jumbwagi kipungu na mang'aliku kitenda kunendale. ");
INSERT INTO mgv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakini ngasenugubona womi wangu ngati sindu sa mana kwangu, ngati kujomo sapwali jangu jukutama pundema pani bila kunkosee Sapanga nukujomule lihengu lejumbeki Bambu Yesu, yaani lihengu lukulandi waamboni waka Sapanga kwa bandu. ");
INSERT INTO mgv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mbetiki kati jinu mwaboti koni nakalandila ukolongu waka Sapanga. Henu, manyiki ngakuba hata jumu winu jojimona kabee. ");
INSERT INTO mgv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Henu, lelenu numpwagi sakaka ana jumuwi juhobiki ne nga na lawama jokapi jela namu kwali mwabeti. ");
INSERT INTO mgv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ndaba ngasenakotwiki hata kasokopi kundandi lijambu loti laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mugulenda womi winu na mgulenda nsambi wa bandu gojumbei Loho jaka Sapanga kuba mwaalonda baki. Mwaalingalia bandu ba bunhobale Kilisitu bajwahemi kwa mwai waka mwana waki mweni. ");
INSERT INTO mgv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nemanyiki ngamaa heniiboka pee pani himei hikali hitenda kuntukali, na ngabikubi ni ikia mu nsambi wa bandu hogo. ");
INSERT INTO mgv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata kuhuma kwinu mwabe biipitila bandu nukupwaga majambu giisoli ili kwaakonga bandu nakatenda baapwata bombi pena. ");
INSERT INTO mgv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ndienu ntama mihu, nkombuka kwa yaka itatu ngasenundekiki kummbola kila jumu winu kwa maholi ikilu na muhi. ");
INSERT INTO mgv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Henu nunkabisi kwaka Sapanga ni kwililobi la waamboni waka Sapanga waki, leliwesa kunsenga nukumpeke uwesu nkati jinu mwaboka monnyambisiki. ");
INSERT INTO mgv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ngasendokuli feza wala zaabu wala ingobu yaka mundu jokapi. ");
INSERT INTO mgv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwanganya mmanyiki maboku ga ganga gatumiki kwa ganagapala kutumi na bababii pamu na nane. ");
INSERT INTO mgv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu mahengu ganhengiki, nundangi indela jenze jukuhenga mahengu ngamaa ngati haga ili twaajangatiya banga kujiwesa, koni nkomboka malobi gaka mweni Bambu Yesu ngati ejapwaaga, ‘Mbanga kupia kuliku kujopa.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pauli ejajomula kupwaga haga, jagungamala pamu na bombi nukunndoba Bambu. ");
INSERT INTO mgv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Boti babia bakalelaninya, buntabuka Pauli koni bunzobatia nukumbusu. ");
INSERT INTO mgv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Babiniki mwoju ngamaa ndaba ja malobi gajapwaga ngabamboni kabee. Ndienu bunhindakiya mbaka kwii sitima. ");
INSERT INTO mgv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Hetwabia tutabukini nabu, twakwela sitima twajenda mbaka ku Kosi. Kilabu jaki bahika ku Lode, nukuhuma hoku twajenda ku Patala. ");
INSERT INTO mgv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hokuje, tujiketaniya sitima labiya lijenda ku Foinike, henu twakwela, twatumbuliya sapwali. ");
INSERT INTO mgv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patwahika ku Kupulo, tuguleka upandi wa mangegi twajenda ku Silia. Twajema musi uku Tilo papuje sitima lela labii lijenda kuhulu misigu. ");
INSERT INTO mgv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Twaaketaniya na banafunzi kola, twatama pamu nabu masoba saba. Banafunzi bala balongila koni alongoswa na Loho jaka Sapanga, bumpwajila Pauli jwijenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Lakini muda witu pagwajomuka twabokaniya nukuendale na sapwali, twaboti pamwa na aka mbomba na bana babu butuhindakiya mbaka kunza ja misi. Twahika kumbwani, twaboti twagungamaliya nukundoba Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ndienu twatabukana pamwa, twepani twakwela sitima nabombi babujaniya mwama nyumba gabu. ");
INSERT INTO mgv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twaendaliya na sapwali jitu kuhuma ku Tilo mbaka etwahika ku Tolemai, twaalamua banafunzi ba kola na twatama nabu lisoba limu. ");
INSERT INTO mgv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kilabu jaki twaboka twajenda ku Kaisalia. Hoku je twajenda kunyumba jaka mundu jojulandi lilobi laka Sapanga jobunkema Pilipi. Jombi jabii jumu ja bandu saba babahaguliwi ku Yelusalemu kola. ");
INSERT INTO mgv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilipu jabii na bana baki aka kamwali nsesi bababii akabikila nabombi babii apia ulota. ");
INSERT INTO mgv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Twatama kola masoba gingi, ndienu Mlota waka Sapanga jumu joakema Agabo jahika kuhuma ku Yudea. ");
INSERT INTO mgv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jutuhikila, jajukua nkanda waka Pauli lojukonge mukibunu, jilikonga mwamaboku na mwamagolu, jakapwaga, “Loho jaka Sapanga jipwaga ana, ‘Ayaudi buku Yelusalemu bankonga mundu jununkanda ago ana nukunkabisa kwa bandu bu ndema jengi.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patajowana malobi gala, twepani na alongu bangi tundoba Pauli jwijenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lakini jombi jwajibwa, “Ntendaki kike, mpala lee kungelebu mojuwa kunyuma sukunelela? Ne mi tayali si kunyege nkati pena ila hata kuwa ku Yelusalemu ndaba jiliina laka Bambu Yesu.” ");
INSERT INTO mgv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pajakana kutujogwane twatama nuu, twapwaga, “Leejupala Bambu lihengikaje!” ");
INSERT INTO mgv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Patajomula kutama pala kwa muda, twakonga misigu jitu, nukujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Apwasi bangi buku Kaisalia bajenda pamu na twepani, butupelika kunyumba jaka Mnasoni kotwajenda kutamani masoba kidogu. Mnasoni jwabi mundu juku Kupulo kabee jwabi anzetaki Sapanga masoba gingi gagapeta. ");
INSERT INTO mgv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patwaika ku Yelusalemu, bandu baanzetake Sapanga butujopiki sapi ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kilabu jaki Pauli jwajenda pamu na twepani kunndamuki Yakobu, na aseja boti babandu ba bunhobale Kilisitu babii pala. ");
INSERT INTO mgv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pajwajomula kwaalamuki, Pauli jwaapwagila majambu goha gajwatenda Sapanga pabandu ba ndema jeyengi kupetee lihengu lakii. ");
INSERT INTO mgv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pabajogwana haga, bunndumbalia Sapanga. Ndi bumpwagila Pauli, “Nndongu wito, ubweni Ayaudi bingi haba babung'alambuki Kilisitu na boti abi na wipu na malagalaki gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ajogwini hegwaabola kila lisoba Ayaudi baatama pikilanda ja bandu banga Ayaudi biipwata malagalaki gaka Musa kwa kaapwagi biiseku banababu jandu wala kupwata mahengu gaayobali Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Henu tutenda boo? Ndaba biijogwana gubii pamba pa Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Henu utenda letukupwagi. Tubi na bandu nsesi paamba baabi na nazili kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ajukua bandu haba, gubiya nabu pamu pa tipati gukulinyambisa na kwaagalami ili amoga majunzu giimutu yabu. Ndi bandu boha biimanya majambu gabajogwana nga ga sakaka, hata wamwe ugajetaki malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Lakini kupete bandu banga Ayaudi babuhobale Sapanga, twapelaki balua kwapwagi majambu ga tuamwi. Biikula sokapi seatendi matambiku gaka sapanga biisoli, biikunywa mwai, biikula inyama ikinyama seakinyongiki, ajepana nukugone na bandu bila ndoa.” ");
INSERT INTO mgv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ndienu, kilabu jaki Pauli jwaajukua bandu bala jwatenda ndumbali jukulinyambisa pamu nabombi. Ndienu jwajingala mu Nyumba jaka Sapanga kupwaga lisoba laki la mwisu lukulinyambisa na matambiku gabu gajwiboa kwa kila jumu wabu. ");
INSERT INTO mgv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Masoba saba gala hegahegali kujomoka, Ayaudi bababi ahumiki ku nkoa uku Asia bumbona Pauli mu Nyumba jaka Sapanga. Bakwelakiya bandu ayoma nukunkamu Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bajamaliya, “Mwabandu buku Isilaeli, mutujangatiaje! Jonzo ndi mundu jojwabola bandu kila pandu majambu gagaapenga bandu buku Isilaeli, gagapenga malagalaki gaka Musa na Nyumba jaka Sapanga jenzeno. Hata heno jwajingisi mombo bandu bukuhuma ndema jengi nuku pajege upija pandu pasapi pamba.” ");
INSERT INTO mgv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bapwaaga hela ndaba babi ambweni Tilofimo, mundu juku Epesu, jubi pamu na Pauli pababi kumusi, bawasaliya Pauli joanzingisi mu Nyumba jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Musi woka wabi na puju, bandu bahika kuhuma pandi yoka, bunkamula Pauli nukunkangakanga, numkumpia kunza ja Nyumba jaka Sapanga apalapa nukupunga milyangu. ");
INSERT INTO mgv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pabapala kunkoma, lijambu lela lahika kwaka nkolongu wa jwaalonda juku Loma kuba musi uku Yelusalemu woka watweli puju. ");
INSERT INTO mgv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Apalapa, nkolongu jwaalonda jwaleta alonda na akilongosi bangi, bajombatakiya pa puju pala jebatenda nsambi wa bandu. Nabombi pabumbona nkolongu wa alonda jola na alonda baki, bakotuka kundapu Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nkolongu wa alonda anzendila Pauli, ankamula nukulagalaki bunkonga minyolu mibeli. Ndienu jwalalukiya, “Jonioju we nyanye, kabee jutei bole?” ");
INSERT INTO mgv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bangi mu nsambi wa bandu gola babia apwaga ale na bandu bangi bapwaga ale. Ndaba ja puju jela, nkolongu wa alonda jola ngasejwawesiki kumanya sekipiti. Ndienu jalagalakiya alonda baki bumpelika Pauli nkati ja nyumba ja alonda. ");
INSERT INTO mgv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli pajwahika pa ngasi, alonda kwapalika buntotula ndaba bandu bajonzukiya puju. ");
INSERT INTO mgv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nsambi nkolongu wa bandu bumpwata koni atenda kujamali kwa sauti, “Unkomila ako!” ");
INSERT INTO mgv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pabunzingia mu nyumba ja alonda, Pauli andoba nkolongu wa alonda jwapwaga, “Nhwesale kukupwagi sindo?” Nkolongu wa alonda jola jwapwaga, “Boo uwesa lee kulonge Kigiliki? ");
INSERT INTO mgv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Weapa ngalee mundu juku Misili jola jojwatumbuliya jojahenga bandu ang'anambuka malagalaki kwisukwisu apa na kwaalongo bandu elupu nnsesi agaide bala mbaka ku kulungwenza?” ");
INSERT INTO mgv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli jajibua, “Nepani nu Nhyahude, nihumi ku Musi uku Taliso nndema uku Kilikia, nena mundu wa musi nkolongo. Gupepakoku, nanonge na bando.” ");
INSERT INTO mgv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nkolongu waalonda jola andeka julongila. Ndienu Pauli jwajema pikikwelu, jwaapongila bandu bala kuboku. Hebatama kinunu, jwalongila nabu kupete luga ji Kiebulania. ");
INSERT INTO mgv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mwaalongu bangu naaka atati bangu, na nyowana malobi gangu gukulikengale ndaba jukuyoma kwinu!” ");
INSERT INTO mgv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pabajawana julonge nabu luga ji Kiebulania, baendalia kutama kinunu ngani. Najombi Pauli jaendalia kulonge, ");
INSERT INTO mgv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nepani nu Nhyaudi, nasaliwa ku Taliso pa Kilikia. Lakini konakolila je pa musi guku Yelusalemu pani, nabii mbolee waka mbola Gamalieli. Jamola kukamulaki sapi malagalaki goka ga ahoku bitu. Moju wa woka gwabii kwaka Sapanga ngati hee nhenga mwanganya lelenu. ");
INSERT INTO mgv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nepani naang'alisa hata kwaakoma bandu baapwata Indela jaka Bambu. Naakamula akanalomi na aka mbomba na kwaajege nkati. ");
INSERT INTO mgv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nngolu nkolongu na aka aseja boti bapasengu amanya goti haga. Najopa balua kuhuma kwabu jeba handikiwi Ayaudi ajitu bababi ku Damasiko. Napiti ku Damasiko ili naakamula bandu ba bunhobali Kilisitu nakaaleta ku Yelusalemu koni naakongiki minyolu ili atemuliwa.” ");
INSERT INTO mgv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Henu, panabi mwindela pambipi nukuhika ku Damasiko, kwabii ngati saa sita liobamutu, unang'anu nkolongu wamulika nepani pandi yoka. ");
INSERT INTO mgv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Apalapa nahabuka pai pwaa, ndi najowa sauti jaka mbwagila, ‘Sauli, Sauli! Ndaba jaki gung'alisa nenga?’ ");
INSERT INTO mgv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nanepani nalalukiya, ‘Wewanyane, Bambo?’ Najombi jambwagila, ‘Nepani na Yesu juku Nazaleti jounng'alisa.’ ");
INSERT INTO mgv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ajangu bala buubweni unang'anu nkali gola lakini ngase baeliwi sauti jela jaka mundu jonabia nakalongila nako. ");
INSERT INTO mgv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Henu, nenalalukia, ‘Enu nepani ndenda boli Bambo?’ Najombi Bambu japwaga, ‘Jema, gujenda ku Damasiko nakola baakupwagila goka gagupalika kuhenga.’ ");
INSERT INTO mgv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ndaba ju unang'anu nkali gola ngasenawesiki kulinga ndi ajangu bala bangamula kuboku nukunongo mbaka ku Damasiko.” ");
INSERT INTO mgv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kola kwabii mundu jumu jobunkema Anania, mundu joanhobale Sapanga, jojujetake malagalaki gitu na Ayaudi baatama ku Damasiko buntende isima ngamaa. ");
INSERT INTO mgv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jombi jahika kumona, jajema pamu na nane, nukupwaga, ‘Nndongu wa Sauli! Linga kabee.’ Apalapa nawesa kulinga kabee.” ");
INSERT INTO mgv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Japwaga kabee Anania, ‘Sapanga waka ahoku bitu juguhangwi ili umanya gajugapala, nukummanya ntumi waki Jojuhenga gajupala Sapanga nukunzoane mweni jakalongila.’ ");
INSERT INTO mgv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","‘Waapwagila bandu majambu goti gawagabweni na kugajowana kwa bandu boti. ");
INSERT INTO mgv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ndienu, gulendale kyane? Jeema, gubatiswa nukugulekakee mahakau gabu sukulikema lihina laki.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ndienu, pana kelubuka ku Yelusalemu, panabia noba mu Nyumba jaka Sapanga, napata uyekuli. ");
INSERT INTO mgv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Numbona Bambu jaka mbwagila, ‘Guboka ku Yelusalemu nyata ndaba bandu ba pamba ngabugujetake kunongale kwaku kupete nenga.’ ");
INSERT INTO mgv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nane numpwagila, ‘Bambo, bombi amanyiki sakaka kupwaga nepani ndi jola jojabia jujendajenda mu nyumba jukuketangane Ayaudi kwaakamu na kalapu bala bababii aguhobale. ");
INSERT INTO mgv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pabunkoma Sitivini ntumisi waku, nane natu nabia nyemiki pambipi, nakajetakya, nukujemale ingobu yabu ya babunkoma.’ ");
INSERT INTO mgv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Najombi Bambu jambwagila, ‘Jenda, nagutuma kutali kwa nndema jengi.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Nsambi wa bandu we gola gunzoanya Pauli mbaka pajapwaga lilobi heli ndi balongila kwa sauti yabu nukujamalii bakapwaga, “Unkoma pundema pani ngase jupalika kutama!” ");
INSERT INTO mgv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Baendaliya kulwanguka lwanguka koni bakalekala ingobu yabu nuku jembelee luhombi. ");
INSERT INTO mgv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nkolongu wa alonda jaamulisa bandu baki bumpelika Pauli nkati ja nyumba ja alonda, jaalagalakiya andapula iboku na andalukiya ndaba jakii Ayaudi atenda kujamali ndaba jake. ");
INSERT INTO mgv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lakini pababia ankongiki ili andapula iboku, Pauli andalukiya nkolongu wa alonda jojajemiki papu, “Boo sapi lee kwinu kundapu iboku mundu juku Loma nga nuku ntemula?” ");
INSERT INTO mgv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nndonda jola pajajoana malobi gala anzendila nkolongu jwaalonda nukumpwaagi, “Gupala guhenga kike? Ndaba jonzo mundu juku Loma!” ");
INSERT INTO mgv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ndienu nkolongu wa alonda jahika nukundaluki Pauli, “Mbwagila, wehapa lee wa mundu uku Loma?” Pauli ampwagila “Hena sakaka.” ");
INSERT INTO mgv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nkolongu wa alonda japwaaga, “Nanepani na mundu uku Loma jukulepe galama ngolongu.” Pauli japwaaga, “Nepani nsaliwi ku Loma.” ");
INSERT INTO mgv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bandu bala bababii bilihandii kundapula nukundaluki maswali Pauli, batenda kuhoba. Hata nkolongu wa alonda jajogwipi ngamaa pajamanya Pauli mundu juku Loma na jabia ankongiki minyolu. ");
INSERT INTO mgv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kilabu jaki nkolongu wa alonda japala kumanya magambu ga sakaka ga Ayaudi gababii bumbeki Pauli. Henu ambopula Pauli nnyolu, nukulagalaki agolu akolongu ba pasengu boti aketangana. Ndienu bundeta Pauli, nukunzemeka palongi japa sengu. ");
INSERT INTO mgv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli jaatupila mihu atumi bapasengu bala nukutumbuli kapwaji, “Alongu bango, mbaka lelenu ndama na mwoju wango wanga na makosa palongi jaka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Apalapa nngolu nkolongu Anania jaapwagila baajemiki pambipi na Pauli bala bundapula likopi kundomu. ");
INSERT INTO mgv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ndipala Pauli jaapwagila, “Sapanga we jwagulapula likopi wamweti wogubi ngati lumatu lokilimi nulutopi luhuhu! Guwesa boo kutama panapa ili kutemula ngati malagalaki hegapala na koni ngase guhenga ngati malagalaki ge hegapala kukulagalaki anapula?” ");
INSERT INTO mgv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bandu bababii jujemiki naku pambipi bumpwagila Pauli, “Boo guntondoo nngolu nkolongu waka Sapanga?” ");
INSERT INTO mgv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli japwaga, “Alongu bango, ngasenamanyiki ngati jombi nngolu nkolongu. Ndaba maandiku gaka Sapanga gahandiki, ‘Gwampwaji liyaa nkolongu wa bandu bako.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Henu Pauli jamanyiki pasengu pala babii aka Asadukayu na bangi aka Afalisayu. Ndi jajamaliya kwa sauti jaki palongi japa sengu, “Alongu bango, nepane nu Mfalisayo, mwana waka Mfalisayo. Nepani andaki pasengu ndaba nhobale bawii biitenda kuyoka.” ");
INSERT INTO mgv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pajajomula kupwaga ganiaga, gwatumbuka ubisi kati ja aka Afalisayu na aka Asadukayu na sengu joka nukubaganika. ");
INSERT INTO mgv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ndaba Asadukayu apwaga bakuwa ngaseayoka, wala nga atumi bu kunani baka Sapanga na loho ngakuba. Lakini Afalisayu ahobalee goti haga matato. ");
INSERT INTO mgv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pabiya na kiinzobi singi, aka abola bamalagalaki na Afalisayu bajema bapenga kwa makili, “Ngasetubwemi likosa liliyaa laka mundu jonzo, pengi loho au mtumi jukunani kwaka Sapanga julongi naku.” ");
INSERT INTO mgv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kujobane kwaendaliya kuba kukolongu hata nkolongu wa alonda jajogapa Pauli ahoto kunsekulana hipandihipandi. Henu jaalagalakiya aka alonda baki ajingala mu sambi we gola, bumpia Pauli nukunkelabu nkati ja nyumba jaalonda. ");
INSERT INTO mgv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikilu jela Bambu jajemiki pambipi jaka Pauli, ampwagila, “Wiijogopa! Gulandi pamba pa Yelusalemu, guhenga ahelahe kumusi guku Loma.” ");
INSERT INTO mgv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Hekwakusa, Ayaudi bajetangania puujobu. Balapania, “Ngatuikuli wala kunywa mbaka patwibiya tunkomiki Pauli.” ");
INSERT INTO mgv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Babajetangini be babii bandu alubaini. ");
INSERT INTO mgv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Henu, bajenda kwaka agolu akolongu na aseja, baapwagila, “Twepani tulapiki mbamba nga tuonzi sokapi mu milomu jitu mbaka patwibia tunkomiki Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Henu, mwanganya pamu na sengu joha nntuma lilobi kwaka nkolongu wa alonda ili andeta Pauli kwinu koni mulikopake mpala kumanya majambu gaki sapi ngani. Tupala kunkoma kabula ngase juhegali kuhika.” ");
INSERT INTO mgv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lakini anijaja waka Pauli jwajowini kulonge kwabu, henu jajenda nkati ja nyumba ja alonda, apwagila Pauli seapala kuhenga majambu gala. ");
INSERT INTO mgv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ndienu Pauli akema nndonda jumu, ampwagila, “Mumpelika nkombu ajo kwaka nkolongu waalonda, jubi na sindu sukumpwagi.” ");
INSERT INTO mgv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nndonda anzukuwa nkombuwe jola, andonguwa mbaka kukunkolongu waalonda, japwaga, “Pauli jobunkongiki jola jungemiki nukunoba nundeta nkombu hajo kwaku ndaba jubi nilijambu lukugupwagi.” ");
INSERT INTO mgv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nkolongu jwaalonda ankamula kuboku nkombu we jola, nukumpeleka pandu puujobu, andalukiya, “Gubi na kii sukumbwagila?” ");
INSERT INTO mgv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Jombi jwapwaga, “Ayaudi ajetangani buguloba gumpelika Pauli pasengu koni bikilikopakiya ati kwa Sengu jipala jipata majambu goha. ");
INSERT INTO mgv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lakini wehapa wijetakela ndaba abii bandu kupeta bandu alubaini balendale kuntukali. Alapiki mbamba ngaakuli wala kunywa sindu mbaka pabibia ankomiki. Henu alendale pe lilobi laku.” ");
INSERT INTO mgv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nkolongu jwaalonda andeka jujenda koni akunkana ampwagi mundu jokapi ngati andeti lijambu leheli. ");
INSERT INTO mgv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Henu, nkolongu jwaalonda jwaakeme alonda abeli na kaapwagi, “Mwaandia alonda 200, baakwela falasi 70 na bandu bakomana ngondu kumikoa 200, ajenda ku Kaisalia mliandia kabula ja saa tatu lelenu ikilu. ");
INSERT INTO mgv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Nhandia Pauli falasi, bumpelika sapi kwaka Felikisi, kuku nkolongu juku nkoa.” ");
INSERT INTO mgv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ndipala nkolongu waalonda jahaandika ana: ");
INSERT INTO mgv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nepani na Kilaudio Lusia nuguhandaki gu nkolongu Felikisi nkolongu uku nkoa, jambu hooti!” ");
INSERT INTO mgv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Ayaudi bumkamula mundu hajo nukupala kukoma. Panajowana jonujuwe Mloma jakabia pambipi na kuwa, henu najenda pamu na alonda nukunhoko. ");
INSERT INTO mgv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Napala kumanya ndaba jukuntaki Ayaudi, henu nunndeta palongi ja pasengu jabu. ");
INSERT INTO mgv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nukubona antaki ndaba jukulaluana malagalaki gabu, wala ngasenilibweni lijambu lokapi lukunhenga jukomika au kukonga mukipungu. ");
INSERT INTO mgv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pabambwagila Ayaudi babia atei mpangu ukunkoma, nhamua kundeta kwaku, naapwagila babuntaki be bala aleta ligambu laki palongi jaku. ");
INSERT INTO mgv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","“Henu, aka alonda bunzukua Pauli ngati ebaalagalakiwi bumpelika ikilu ajelajela mbaka ku Antipatili. ");
INSERT INTO mgv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kilabu jaki nndonda wa magolu jabuja nkati ja nyumba ja alonda, baaleka aka alonda akwela falasi aendaliya na sapwali pamu na Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pabahika ku Kaisalia bumpekia nkolongu juku nkoa balua je jela nu kumbeka Pauli pai ju ukolongu waki.” ");
INSERT INTO mgv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pelisi pajasoma balua je jela andalukiya Pauli juhumiki nkoa bole. Pabummanyisa jabia juhumiki ku nkoa uku Kilikia, ");
INSERT INTO mgv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","japwaaga, “Nyoane ligambu laki niijogwania ebiika babugutaki.” Ndipala ampwagila Pauli ambeka pai juulonda nkati ja nyumba jaka bambu nkolongu Helodi. ");
INSERT INTO mgv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pagapeta masoba nhanu, nngolu nkolongu Anania jwahika ku Kaisalia pamu na aseja asokopi na mundu jumu jojumanya malagalaki jobunkema Telutulo. Bunzendila Felikisi nkolongu ju nkoa jola nukundandi majambu gabuntakili Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bunkema Pauli na Telutulo jatumbulia magambu ana. “Nkolongu Felikisi, kwa malangu gu ukolongu waku tutoguli ngamaa ndaba jakuba nulukwali gulenganaki majambu ga asapi ndaba ja bandu bunndema gwitu. ");
INSERT INTO mgv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nkolongu Felikisi, tulijopa lijambu heli kila pandu na kila namuna na masoba goha nusukutogule ngamaa nukukusengu. ");
INSERT INTO mgv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Lakini, bila kuhoa muda waku, nukuloba utujowaniya kasokopi lijambu litu letu kupwagi. ");
INSERT INTO mgv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tugundwi mundu jonzo jubi ni milomu. Jonoju ndi jojuleta puju kwaka Ayaudi kila pandu punndema poti na kabee kiongosi jukikundi sa Nazaleti. ");
INSERT INTO mgv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kabee jalenga sapu Nyumba jaka Sapanga, natwepani twaamua kunkamu. Twapala kuntemu kulengana na malagalaki gito. ");
INSERT INTO mgv_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lakini Lusia, nkolongu waalonda, jwahika nuku nzuku mmaboku gitu kwamakili. Ndi japwaga bandu babuntaki ahika kwaku. ");
INSERT INTO mgv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ana gundaluki wa mweti, guwesa kugamanya majambu goti gatuntakali.” ");
INSERT INTO mgv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na Ayaudi bajongana nabu mumagambu gala koni apwaga haga goti gabi sakaka. ");
INSERT INTO mgv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Henu, nkolongu jwa nkoa Felikisi ampwagila Pauli julongila. Najombi Pauli jwapwaga, “Ne ndogule kulikengale kwaku ndaba manyi weapa ubi mundu jukutemu mu nndema goni yaka jingi. ");
INSERT INTO mgv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wamwe guwesa kumanya bila tabu masoba komi na mabeli gapetiki nabii ku Yelusalemu kundumbali Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayaudi ngase bangoli nakabisana na mundu jokapi munyumba jaka Sapanga. Ngasebangoli naka kwelakia bandu munyumba jukuketangane gabo, wala pandu pangi pokapi mu musi gola. ");
INSERT INTO mgv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Kabee ngabiwesi kulangi magambu gandakali nepani ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lakini nyetake ndee nepani nungungamali Sapanga waka ahoku bitu ndama koni mbwata indela jejuje bombi akema sama siisoli. Nhobale mahengu goha gagahandikwi mwiitabu ya malagalaki na alota baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nepani nunhobale Sapanga, nabombi abii na nhobale heji, kwa bandu baamboni na abaya, bitenda kuyoka. ");
INSERT INTO mgv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Henu gangamala masoba goti kuba na mwoju wanga na makosa ga sapi palongi jaka Sapanga na palongi ja bandu. ");
INSERT INTO mgv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Baada jukutama kutali masoba kwa yaka kidogu, nakelubuka ku Yelusalemu ili kwaapelake bandu ajangu kuboa litambiku. ");
INSERT INTO mgv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Panabiya nyoomwi kutenda tipati jukulinyambisa ndi pabangetaniya mu Nyumba jaka Sapanga nakatenda hela. Ngase wabii nsambi wa bandu wala puju. ");
INSERT INTO mgv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakini kwabii na Ayaudi bangi kuhuma kunkoa uku Asia, banganya haba ndi bapalika kuba palongi jaku nukupia magambu gabu ana abi nusukupwaga sokapi kupeta nepani. ");
INSERT INTO mgv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au, waleka babii pamba apwaga likosa lebilibweni kwangu kipindi senajemiki palongi japasengu jabu ngolongu, ");
INSERT INTO mgv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ila pe malobi ganga ganapwaga panajemiki palongi jabu: ‘Nepani nndaki lelenu ndaba jukuhobale bawii bitenda kuyoka.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Papujeni, Felikisi jojabii bumanyisi indela jaka bambu sapi, jajomula ligambu le heli. Jaapwajila, “Niitemula ligambule heli mbaka Lusia nkolongu jaalonda pajihika pamba.” ");
INSERT INTO mgv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ndienu ampwagila nkolongu jwaalonda jola andonda Pauli, lakini andekakila napwasi kidogu aka akosi baki bisindwa kumpeke sindu sokapi. ");
INSERT INTO mgv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Egapeta masoba Felikisi jahika pamu nunhwana waki Dulisila jabii Myaudi. Jaalagalakiya Pauli anndeta, anzowaniya hejulonge majambu gukuhobale Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lakini kipindi Pauli pajatumbuliya kulongale majambu gajupala Sapanga, ili kuliwesa wamweti na kwamajambu gilisoba lukutemuliwa kokwiika, Felikisi jajogapa nukupwaga, “Henu guhoto kujenda nagukema kabee panipata napwasi,” ");
INSERT INTO mgv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Apalapa jabiya anhobalee Pauli ampekia hongo. Henu jabiya ankema mala kwa mala ili julongila naku. ");
INSERT INTO mgv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ejapeta yaka jibeli, Polikio Fesito jwaakamula napwasi jaka Felikisi, jwabiia nkolongu ju nkoa. Ndaba Felikisi jabiya jilihemake kwa Ayaudi, Felikisi andeka Pauli mukipungu. ");
INSERT INTO mgv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Masoba matatu egapeta toka hebahika ku nkoa, Fesito jahuma ku Kaisalia, nukujenda ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Aka agolu akolongu pamu na aka kilongosi ba Ayaudi buntakila Pauli palongi jaki. Bundoba Fesito, ");
INSERT INTO mgv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","jahengila lijambu la sapi luku nndeta Pauli ku Yelusalemu, ndaba babiya ampendakali ili ankoma pajwiibia mwindela. ");
INSERT INTO mgv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Lakini Fesito japwaga, “Pauli jwiigaliya kukipungu ku Kaisalia kola nane nganzelewi kujenda hoku. ");
INSERT INTO mgv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mwaleka akakilongosi binu ajenda konihoku pamu nanenga kwaka Kaisali bukuntakila kola ana jombi jutei sindu siliyaa.” ");
INSERT INTO mgv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito jatemi naku masoba nani au komi elahe, ndienu jakelubuka ku Kaisalia. Kilabu jaki jajenda kusengu anhamulisa Pauli andeta palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pauli ejwabia juhika, Ayaudi bababiya ahuma ku Yelusalemu buyonguluta nukutumbuli kupia magambu gingi makolongu gaguge ngasebawesa kulangi usakaka wake. ");
INSERT INTO mgv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pauli japwaga sukujikengale, “Nepani ngase nhengiki likosa lokapi kupete malagi ga Ayaudi au ata kupete Nyumba jaka Sapanga wala kupete Kaisali.” ");
INSERT INTO mgv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesito japala kilihemake kwa Ayaudi naela andalukiya Pauli, “Boo gupai kujenda ku Yelusalemu na hoku bukugutemula palongi jangunenga kupete magambu ge haga?” ");
INSERT INTO mgv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauli japwaaga, “Nepani sajenu nyemiki palongi ja pasengu jaka Kaisali, ndi pandu pa mbalika kutemliwa. Ngati wamweti egumanya sapi ngani ngasenaatendi Ayaudi sindu sokapi siliya. ");
INSERT INTO mgv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ndienu ana nepani mbatakini ni likosa lokapi lelipalika kuwa, ngasenoba kunekake kutemuliwa hoko. Lakini ana magambu gaanetiki Ayaudi aba nga ga sakaka, ngasejubii jojuwesa kumbeleka mumaboku gabo. Mbala kujenda kutemuliwa kwaka bambu nkolongu juku Loma!” ");
INSERT INTO mgv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ndienu Fesito ejwabia julongi na aseja, ampwagila Pauli, “Gusekwi lufaa kwa Kaisali, ndienu gujenda kwaka Kaisali.” ");
INSERT INTO mgv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Egapeta masoba masokopi, bambu nkolongu Agilipa na Belunike bahika ku Kaisalia ili kupia kunndamuki Fesito. ");
INSERT INTO mgv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Babia hoku kwa masoba gingi najombi Fesito andandila bambu nkolongu ligambu laka Pauli, “Jubii mundu jumu pamba jojuwe Felikisi ambea pikipungu. ");
INSERT INTO mgv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Enajenda ku Yelusalemu agolu akolongu na aseja ba Ayaudi buntakila nukunoba nuntemula. ");
INSERT INTO mgv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Lakini nepani naapwagila ngasetuyobali Aloma kumpia mundu antemula kabula jojuletiki magambu ngasejuketangini najoantaki ana kwa ana nukumpeke mbekenyu jukulikengale mu ligambu le hele. ");
INSERT INTO mgv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ndienu, pabahika pamba ngase nakabaki, ila nahenga kikau kilabu jaki, naa lagalakia anndeta mundu we hoju. ");
INSERT INTO mgv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Babaleta magambu be bala pabatenda kujema, ngasebapihiki magambu giliya ngati enabia nakawasalila. ");
INSERT INTO mgv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ila pe babia na hindu isokopi pamu najombi kupete Indela jabu nu kupete mundu jumu joankema Yesu jojabia juwii, lakini Pauli juahobale jwakoni. ");
INSERT INTO mgv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ngase namanyiki lukuhenga kupete lijambu le hele, ndienu nundalukiya Pauli ana jupai kujenda ku sengu guku Yelusalemu ndaba ja magambu ge haga. ");
INSERT INTO mgv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakini Pauli jaloba akuntemula nkolongu juku Loma, najaloba juhigaliya apalapa mbaka bambu nkolongu juku Loma pajihika kutemu ligambu heli. Nanepani nalagalakiya andeka mbaka panupelika kwaka bambu nkolongu juku Loma.” ");
INSERT INTO mgv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ndienu Agilipa ampwagila Fesito, “Mbalika nunzoa mundu we hoju namwete.” Fesito ampwagila, “Wanzoa kilabu.” ");
INSERT INTO mgv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lisoba lelapwata Agilipa na Belunike bahika kukutogule ngamaa muukumbi gukukentakane babia alongini na akakolongu ba alonda na aka akolongu ba misi. Fesito jaalagalakia Pauli andeta nkati, ");
INSERT INTO mgv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ndienu japwaaga, “Bambu nkolongu wa Agilipa na mwaboti mombii pamba pamu na twepani! Pamba palongi jinu jubii mundu jonzo, bandu boti buku Uyaudi pamba nuku Yelusalemu ambege keleli mundu jonzo jupalika jukomika. ");
INSERT INTO mgv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lakini nepani ngasenikibweni sejutei sokapi siliya hata kupalika kunndapu mbaka jukomika. Ndaba Pauli weni jasekwi lufaa kwaka bambu nkolongu juku Loma, naamua bumpeleka ku Loma. ");
INSERT INTO mgv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ku upandi wangu ngasemii ni lijambu la sakaka lenhwesa kunhandaki bambu nkolongu juku Loma kupete jombe. Ndi mana nundetiki pamba palongi jaku Agilipa, ili enyomo kulinga sapi miha nusukuandakila. ");
INSERT INTO mgv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ndaba mona ngakwikubi sapi kumpeleka mukipungu bila kulogo pangwendu magambu gabuntakali.” ");
INSERT INTO mgv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Henu, Agilipa ampwagila Pauli, “Uwesa kulikengale kwa malobi gako.” Ndienu Pauli julinyosa nukulikengale. ");
INSERT INTO mgv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Jwapwaga ana, “Nkolongu Agilipa! Nenibona mbanga lelenu kulikengale kwangu palongi jaku weapa ndaba ja magambu goha gaambwagi nepani Ayaudi, ");
INSERT INTO mgv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ndaba wamweni umanya sapi miilu joti jaka Ayaudi na malaluki gabu. Nala nenoba unyowana sukunhinakali. ");
INSERT INTO mgv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ndaba Ayaudi boti amanya womi wangu toka panabi nkombu, hegabi toka panatumbulia mu ndema jangu ku Yelusalemu. ");
INSERT INTO mgv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Amanya nepani toka muda nndasu, awesaku kulonge ana apai, ndaba toka pamwandi nabi mu kikundi sa Afalisayu sekikamulaki ngamaa malagalaki ga dini jitu. ");
INSERT INTO mgv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nahenu mipamba andaki ndaba nilihobale lilaganu lela lejaalagi Sapanga ahoku bito. ");
INSERT INTO mgv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Lilagu heli ndi jebijihobale makabila komi na mabeli ga nndemajito, koni buntumaki sapanga ikilu na lioba mutu. Bambo nkolongu, Ayaudi andaki nepani ndaba jukuhobale hoko! ");
INSERT INTO mgv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ndaba jaki mwanganya ngasempala kunhobale Sapanga juyoa bandu baawile? ");
INSERT INTO mgv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Sakaka namweti nahobali jene kupalika nepani kutenda majambu gingi kulipenga liina laka Yesu juku Nazaleti. ");
INSERT INTO mgv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Majambu haga ndi ga nagahenga ku Yelusalemu. Nepani, koni mbatiki uwesu kuhuma kwaka agolu akolongu, naajegi nkati bandu bingi baka Sapanga. Nabombi pababia atenda kwaatemu kuwa naajetaki. ");
INSERT INTO mgv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Malajingi naatemula munyumba jukuketangane ayaudi yoti koni na kwa makili naahenga bukukana kuhobale kwabu. Inyela yangu kwabu jabi ngolongu mbaka najenda kwaataputa ku misi jukutali.” ");
INSERT INTO mgv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Lisoba limu panabi mu mahengu gagaga najenda ku Damasiko, nabi na makili na malagalaki kuhuma kwaka agolu akolongu. ");
INSERT INTO mgv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Unkolongu wee, panabi mwindela, lisaa la sita lioba mutu, nuubona unang'anu nkolongu kupeta walioba wakamulika kuhuma kunani, wanhyonguluta nepani na bandu bangi banabinabu. ");
INSERT INTO mgv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Twepani twaboka twaabukaa pai, nanepani najogwana sauti jaka mbwagila kwa luga ji kiebulania, ‘Sauli, Sauli! Ndabajaki utenda kundesa? Uliumisa bwaka pena ngati ngombi jejipega nteki ndonga jaka bambu wake.’ ");
INSERT INTO mgv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nepani nalalukia ana, ‘We wanya Bambo?’ Najombi Bambu jajibwa, ‘Nepani na Yesu jountesa weapa.’ ");
INSERT INTO mgv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lakini henu, jemaje kwa magolu gako. Nukupiti ili nukubeka ubia untumi wango. Waapwagila bandu bangi majambu gaugabweni lelenu na gangi ganakulangia. ");
INSERT INTO mgv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nakukombua weapa na bandu buku Isilaeli na bandu banga Ayaudi banukutuma kwabu. ");
INSERT INTO mgv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Waakikinua miu gabu naka awesesa apita kulwii nukujingi mu unang'anu, apita mu makili gaka lijobi, bung'anambukiya Sapanga, ili kupete kuhobale, apata kulekakewa mahakau gabu nukujuku napwasi jabu abia kati jabandu ba haguliwi nakuba bandu baka Sapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ndienu, bambu nkolongu Agilipa, nepani ngase nawesiki kuba niing'omu kwa mabonikanu haga gagahumiki kunani kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila natumbuliya kulandi oti kwa bandu buku Damasiko, ndi najenda kulandi ku Yelusalemu na ndema joka juku Yudea, na kabee najenda kwa bandu banga Ayaudi. Naalandila ili ajetakiya na kugaleka mahakau gabu nubung'anambukiya Sapanga nukulangi mu mahengu gabu ang'anambwi mioju jabu. ");
INSERT INTO mgv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwa ndaba heji, Ayaudi bangamula panabi mu Nyumba jaka Sapanga, balenga kungoma. ");
INSERT INTO mgv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lakini Sapanga jatenda kunyangati na mbaka lelenu nyemiki pamba kumpwagi mwaboti, akakilongosi na banga kilongosi. Majambu gampwaga ndi gabapwaga alota baka Sapanga na Musa bapwaga giitenda kupiti, ");
INSERT INTO mgv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","yani kwabi lasima Kilisitu Nkombosi jung'alika na jubia jukutumbuli kuyoka kuhuma kwa bandu baawi, ili julandila unang'anu ukombosi gwaamulaki bandu boti, Ayaudi na bandu banga Ayaudi.” ");
INSERT INTO mgv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauli pajaika pani hejulikengali, Fesito japwaga kwa sauti ngolongu, “Pauli! Ubi na mangongo! Kusoma kwaku kwingi kukutenda ubia na mangongu!” ");
INSERT INTO mgv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Lakini Pauli japwaga, “Ngase mii na mangongo, nkolongu Fesito. Senipwaga sa sakaka pena na gana maana. ");
INSERT INTO mgv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wa bambu nkolongu Agilipa nhwesa kulonge palongi jaku bila kujogopa ndaba gumanyiki majambu goka haga. Mii nu uwakika ugamanyi majambu goti gagapiti haga sakaka ndaba ngasegahengiki kuujobu. ");
INSERT INTO mgv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Bambu nkolongu Agilipa, boo, waaobale Alota baka Sapanga? Nemanya waaobale.” ");
INSERT INTO mgv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Bambu nkolongu Agilipa anzibua Pauli, “Boo, guwasali guwensa kung'anambu nepani nyatanyata hela kuba nu Nkilisitu?” ");
INSERT INTO mgv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauli jajibwa, “Nundoba Sapanga kwa kipindi kisokopi au kilasu, nga weapa pena, ila boti baanyogwane lelenu abia ngati hemi nepani, lakini bilaminyolu ajejee.” ");
INSERT INTO mgv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ndipala Bambu nkolongu Agilipa na nkolongu ju nkoa na Belunike na bandu boa bababi pamu nabu, batenda kujema. ");
INSERT INTO mgv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pabapita kunza, bapwagania, “Mundu ajo ngasejatei sokapi sekipalika kutemuliwa kuwa au kipungu.” ");
INSERT INTO mgv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Najombi Agilipa ampwagila Fesito, “Mundu ajo twakabia tunhoguli ana jwakabii ngase jusekwi lufaa kwaka bambu nkolongu juku Loma.” ");
INSERT INTO mgv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pababii ahamwi kujenda mbaka ku Italia, Pauli bumbei pamu na apungwa bangi pai ju ulonda waka Julio, jojabii nkolongu wa alonda mu nsambi gobuukema, “Kikosi saka Agusito.” ");
INSERT INTO mgv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twakwela sitima la Adilamitio, lelabii lijenda kupete bandali jejabi misi isokopi yu nkowa wa Asia, nuku tumbuli sapwali. Alisitako, mwenei juku Makedonia kuhuma ku Tesalonike, jabii pamu natwee. ");
INSERT INTO mgv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kilabu jaki twajema pabandali juku Sidoni. Julio anhengila Pauli sapi nukunzetake jaabona akakosi baki, nuku mpeke hindu yejupala. ");
INSERT INTO mgv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuhuma hoku twaendaliya na sapwali, lakini nhuwahi wakabi waka poga kwa makili koni guhika kutupenga palongi, twapetila upangi wa kilwa suku ku Kupulo sombi ngasesabii nu nhwahi winge. ");
INSERT INTO mgv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Hetwalombuka nhanga huku Kilikia nuku Pamfilia, twajema ku Mila nkoa guku Lukia. ");
INSERT INTO mgv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nkolongu wa alonda jola jilikolila sitima limu ku Mila lelihuma ku Alekisandilia kujenda ku Italia, jutukwea momu. ");
INSERT INTO mgv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Twajenda mbolimbo na kwa masoba gingi na kwa tabu ndi twaika pambipi na musi uku Nido. Ndaba nhwahi wabia utupengale kuendale kujenda kulongi, twaamua kupete upandi uku Kilete twapeta mulutengu ja Salumoni kokuje nhwahi ngase wabi wingipi. ");
INSERT INTO mgv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twapeta pulutengu jaki mbolimboli kwa tabu kupete kumbwani nukuhika pandu pabapakema, “Bandali ja asapi,” pambipi na musi uku Lasea. ");
INSERT INTO mgv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wapeta muda wingi, hata Lisoba la tipati lukutogule lukulekakewa mahakau na Sapanga labia lipetiki. Henu jabia hatali ngolongu kujenda ni sitima. Henu, Pauli japia mawasu, ");
INSERT INTO mgv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mwaalongu bango, ne nhwasali sapwali jenze jiibia jahatali ngolongu na mali gingi hitenda kuhoba, nga sitima ni misigu jitu pee, na hataa twabete.” ");
INSERT INTO mgv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakini nkolongu jwa alonda jaa pelakania ngani malobi gajalongila jojulongoo sitima na mundu jojubii ni sitima kuliku gajapwaga Pauli. ");
INSERT INTO mgv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ndaba bandali jela ngase jabii pandu paa sapi pukutama kipindi sikipepu, bingi bapwaga tuendalia na sapwali ili twakahika ku Foanike na kuwesakini, nukutama hoku kipindi sikipepu. Foanike jabii bandali jejibi ku kilwa juku Kilete, jejibii pambipi nu upandi uku kusini magalibi nu upandi uku kazikazini magalibi. ");
INSERT INTO mgv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Henu nhwai huku ku kusini watumbuliya kuhika, nabombi bawasalia awesa kuendale na sapwali, batupula nanga henu batumbulia sapwali, bajenda ni sitima pambipi nuku mbwani juku Kilete. ");
INSERT INTO mgv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakini ngase wapeta muda, nhwai nkolongu ngamaa gobugukema, “Nhwai huku kasikasini.” Watumbuliya kuhika kuhuma ku kilwa. ");
INSERT INTO mgv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nhwahi ulikanga sitima na sitima ngaselawesa kusindana naku, tuuleka pe sitima litutuliwa nu uhwahi. ");
INSERT INTO mgv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kilwa simu se bikikema Kauda sutujangati kidogu kuponga nhwahi gola, na hetwapeta upandi wa ku kusini twawesa hata kwa tabu twawesa kugubeka sapi nhwatu huku okolee mu sitima. ");
INSERT INTO mgv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Atumisi bisitima bala bahutila nhwatu gola nkati, ndi biiyongulatiya uhwatu ngoji kwa makili ili kujikenga na makili gu uhwahi. Bajogupa awesa kukwama mulutengu gu nhanga nuku mbwani juku Libia. Ndi bahulua matanga nuku lileka sitima libia likangwa nu nhwahi, ");
INSERT INTO mgv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","uhwahi nkolongu gaendaliyaa kuhika, nikilabu jaki baamua kuleke kunza misigu jili jojoma. ");
INSERT INTO mgv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lisoba la tatu, batumbulia kuleke mmasi hindu ya sitima kwa maboku gabu beni. ");
INSERT INTO mgv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kukipindi sa masoba gingi ngase twawesiki kulibona lyioba wala ndondu, uhwahi nkolongu gaendalia kupoga ngamaa, hata kuhobale kulama kwa tenda kujomoka. ");
INSERT INTO mgv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Baada jukutama masoba gingi bila kula posu, Pauli jajema pikilanda jabu, nuku pwaga, “Mwaaka alongu bangu, kwakabia nambanga mwakanyoane nepani nuku kotoka sapwali kuhuma ku Kilete. Ana mwaka tenda hela twakabia tujepini na tabu na hasala heji joti. ");
INSERT INTO mgv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lakini henu nundoba nhinakaliya, nga mundu jumu jojwiikuha, sitima pee ndi jejiihoba.” ");
INSERT INTO mgv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndaba lisu hikilu ntumi juku nani kwaka Sapanga jonungungamali nepani ndi jwaki jatenda kumbiti, ");
INSERT INTO mgv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","jambwagila, “Pauli, wijogopa! Gupalika kujema palongi jaka Kaisali, na Sapanga kupete ikia kwaku weapa, jajangati boti baabi musapwali pamu na weapa biikua. ");
INSERT INTO mgv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Henu, mwaakolongu nngangamala! Ndaba nunhobale Sapanga kwipitila ngati hejumbwagi. ");
INSERT INTO mgv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lakini lasima tupelikwa mulutengu mwa kilwa simu.” ");
INSERT INTO mgv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ikilu jilisoba la komi nu nsese, nhwai wabia ututuana koni na koni ku nhanga uku Adilia, pambipi na pamahiku bahenga lihengu mu sitima bamanya ahegale kundema. ");
INSERT INTO mgv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Henu bataputa ulasu ukunyoleka kunhanga suku jingi lugoji lolabi akongiki sindu sekitopiki, bapata ulasu wa meta alubaini. Hebapema kabee bapata ulasu wa meta selasini. ");
INSERT INTO mgv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ndaba jukujogopa kupati mmalibu, bahulua nanga nsesi kunyuma jisitima, nukuloba kukusa nyata. ");
INSERT INTO mgv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Baahenga lihengu musitima bala bapala kutila, babi ahulwi nhwatu gola mmasi, koni bakalongila isoli ajenda kuhulu nanga upandi huku longi wili jojoma. ");
INSERT INTO mgv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lakini Pauli ampwagila nkolongu wa alonda jola na alonda baki, “Ana baahenga lihenga musitima haba ngase ahigi musitima, nganndame.” ");
INSERT INTO mgv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ndipala alonda bala basekula migoji yeyabi ikamulaki nhwatu gola, nukuuleka gujenda na masi. ");
INSERT INTO mgv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ekwahegaliya pulukela, Pauli jaapwagila boti akula posu koni jakapwaga, “Masoba komi nu nsesi mwabi ni kiholu na bila kula posu. ");
INSERT INTO mgv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Henu, nundoba nkula posu ndaba kubidi nkula ili nhwesa kuendale kuba mwabomi. Ndaba hata lijunzu limu liimutu hii nga lihobe.” ");
INSERT INTO mgv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Baada jukupwaga hela, Pauli jajukua libumunda, ansengula Sapanga palongi ja bandu boti, janukula, nukutumbuli kula. ");
INSERT INTO mgv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ndienu boti bagangamala mwoju jabu na kula, na bombi bakula posu. ");
INSERT INTO mgv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Twabii twa bandu miya mbili sabini na sita musitima. ");
INSERT INTO mgv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pabajomula kula posu jukutosa, bapungusa kutopa kwi sitima sukuleke ilebi munhanga. ");
INSERT INTO mgv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Hekwakusa, baahenga lihengu musitima ngase bamanyiki abi mu nndema bole, ila baabona pandu punhanga pununsangi pambwani, baamua ajenda bakajemika sitima. ");
INSERT INTO mgv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Henu basekula nanga nukuileka munhanga, kipindi aselase babopula ing'oji yebuukongiki usukani wa sitima, ndi batondibia litanga limu palongi ji sitima ili lijenda sukukangwa nu nhwahi, nukujenda ku mbwani. ");
INSERT INTO mgv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakini bahika pandu pununsangi wingi mu nhanga, na sitima jatenda kupati. Pandu palongi ja sitima pabi pajingi mu nsangi bila kuwesa kuboka. Pandu puku nyuma ja sitima pa tumbuka kutunyuka ipandi ipandi baada jukupegwa na makili ga majeba. ");
INSERT INTO mgv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Alonda bapala kaakoma apungwa bala boti, ndaba bajogopa awesa kusibii mmasi mbaka kundema juku mbwani nukutila. ");
INSERT INTO mgv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakini ndaba nkolongu wa alonda jola japala kunkengale Pauli, jaakanakia biitenda hela. Jaapwagila boti baamanya kusibi mmasi ahomba kuhuma mu sitima mbaka ku mbwani, ");
INSERT INTO mgv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","na bangi apwaata koni akamulaki mu ibau au mu ipandi ya sitima yeitunywiki. Hela ndi hetwahika ku mbwani bila kuwa. ");
INSERT INTO mgv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Etwabia tuhikiki sapi mu ndema, ndi twamanya kilwa se sela akikema Maluta. ");
INSERT INTO mgv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Benei babu babii bandu baamboni ngamaa kwitu. Iyula jabii jitumbuli kukuna na kwabii ni kipepu, henu bapambakya mwotu, butujopa kunyata mwotu. ");
INSERT INTO mgv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauli jatonduliya nsigu nsokopi wa nhanzu jabia jukokake pahinza. Papuje ndaba ja lyotu la mwotu, lijoka lapitila munhanzu nukunduma Pauli mukuboku nukung'ang'anii papu. ");
INSERT INTO mgv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Benei baapala pabilibona lijoka lela lijenze mukuboku jaki bapwaganinya, “Mundu ajoo sakaka jutei kukoma, hata ana julamiki mu nhanga, lakini kuboku kwaka ‘Kisapanga itu’ ngaandeke. ");
INSERT INTO mgv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakini Pauli ja kung'undiya lijoka lela pamwotu na ngase lundumiki hata kidogu. ");
INSERT INTO mgv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bandu bala bahobaliya ngiti jutenda kuhimba au jwiihabukiya pai na kuwa. Lakini baada jukundendale munimuni nukubona Pauli ngase suntenda sindu sokapi silya, bang'anumbua mawasu gabu kupete jombi, bapwaaga jombi ndi kisapanga.” ");
INSERT INTO mgv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Pambipi na pandu pala gakabii na matui gaka Pubulio, nkolongu jwa kilwa. Pubulio jutujopa ngati ukosi baki, twabia twaageni baki masoba matatu. ");
INSERT INTO mgv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","“Atati baka Pubulio babia agoni pikitanda, babia atamu nu kuhalisa mwai. Pauli jajingala nkati ili kwaabona baada ju kundoba Sapanga ambekila maboku nukundamisa. ");
INSERT INTO mgv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lihengu le heli elapitila, bandu boa ba kilwa jela bababii agonzu bahika nabombi nukulamiswa. ");
INSERT INTO mgv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Butupekiya mali gingi, na patatumbuliya kabee sapwali, bapakila musitima indu yoka yetwabia twiipala.” ");
INSERT INTO mgv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ejapeta miei mitatu twatumbuliya sapwali jitu mu sitima limu laka Alekisandilia lebilikema, “Aka kisapanga ba mapaa” Sitima le heli labia lijemiki pandu papanyoliki kipindi soa si kipepu. ");
INSERT INTO mgv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Twahika pikilanda ja Salukusa, twatama papu masoba matatu. ");
INSERT INTO mgv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ndienu twatumbulia kujenda, twaendaliya na sapwali nukuhika ku Legio. Elapita masoba mabeli, nhwai watumbuliya kupoga kuhuma kusini, na egapeta lisoba limu twahika bandali ja Potioli. ");
INSERT INTO mgv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kokuje twaakolila aka kilongu asokopi babube butuloba tutama nabu kwa juma jimo. Nahenu twahika ku Loma. ");
INSERT INTO mgv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aka kilongu ku Loma kola ebapata lijambu litu, bahika kutujopa kuguliu juku Apio na pandu pabapakema nyumba itatu ja ageni. Pauli ejaabona ansengula Sapanga, japata moju. ");
INSERT INTO mgv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Patwabiya tuhikiki ku Loma, Pauli anzetakiya kutama kajika jaki pamu na nndonda jumu jukulonda. ");
INSERT INTO mgv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Egapeta masoba matatu, Pauli jaakema akilongosi buku Uyahudi bababiya atama hoku. Pabaketangana, Pauli jaapwagila, “Mwabandu aja, nepani ingawa ngasenatei sokapi siliya kwa bandu bangu wala kupenga malagalaki ga aseja bitu, batenda kungamuu ku Yelusalemu kola nukumbeleka mwamaboku ga Aloma. ");
INSERT INTO mgv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Pabanalukiya nukubona ngase mi nilikosa lokapi nhenga nikomika, bapala kuneka. ");
INSERT INTO mgv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakini Ayaudi bangi bapenga lijambu le heli nane napalika kuseku lufaa kwaka bambu nkolongu juku Loma, hata hela ngasenabii na sokapi sa kwaa akataki ajangu.” ");
INSERT INTO mgv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Jenze ndi ndaba jukuloba kummbona nukulonge na mwanganya, nepani angongiki minyolu jenze ndaba jukuhobale kwa bandu buku Izilaeli. ");
INSERT INTO mgv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bombi bapwaaga, “Twe ngasetujopiki balua jokapi kuhuma ku Yudea, wala ngamundu jokapi jojuhikiki pamba nukupia lijambu le heli au kupwaaga sokapi siliya segutei wehapa. ");
INSERT INTO mgv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakini tuholale tujoana kuhuma kwaku wamweti gaguwasali ndaba tubweni kila pandu bandu alonge liyaa kupete kikundi hesi.” ");
INSERT INTO mgv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ndienu bapanga naku lisoba lukuketangana naku, bandu bingi bahika kojutamika tumbuka pulukela mbaka pakamii jaalandila nukulongale Ukolongu waka Sapanga, jalenga kwaalandi kupete Yesu kuhuma mu malagalaki gaka Musa nuku kuhuma kwa Alota baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bangi bahobali malobi gaki, lakini bangi ngase bahobalile. ");
INSERT INTO mgv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ndienu, ngase bajetangini kuolale kwabu. Pababia ajendane Pauli japwaaga lilobi ale, “Loho jaka Sapanga japwaga sakaka naka hengo binu pajapwaaga majambu gala gajapwaaga Bambu Yesu kundomu wiki Isaya Mlota waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Jaapwaga, ‘Jenda kwa bandu haba ukaapwagila, kujoa ngitinzoa, lakini nganhelewe, kulinga ndinga, lakini ngamwiibone. ");
INSERT INTO mgv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ndaba malangu ga bandu haba gatei kuhoba, ahibalaki makuto ahigi mihu gabo ana hela bakalinga kwa mihu gabu bakajoa kwa makutu gabo bakaelewa kwa malangu gabo nukung'anumbukila, jupwaaga Bambu nane nukundamisa.’ ” ");
INSERT INTO mgv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ndienu Pauli japwaaga, “Henu mmanya lijambu laka Sapanga luku kuokoka bapelaki bandu banga Ayaudi. Na bombi bitenda kunzoane!” ");
INSERT INTO mgv_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pauli ejwabia jupwagiki ganiaga, Ayaudi batenda kuboka koni bakabisana ngamaa beni na beni. ");
INSERT INTO mgv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Yaka hibeli yoka Pauli jutamika mu mnyumba jejapangiki mweni jukubika jaajopa boa bahikiki kumbona. ");
INSERT INTO mgv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Julandila Ubambu Ukolongu waka Sapanga nu kubola lijambu laka Bambu Yesu Kilisitu ku uwesu, bila lujogopu wala kukanaliwa na mundu jokapi.");
INSERT INTO mgv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nepani Pauli ntumisi waka Yesu Kilisitu, nunhandaki balua jenze. Sapanga junhagwi kuba ntumisi nukunhenga nandila Lijambu la Amboni lejumbeki Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Pamwandi Sapanga jwaalagila bandu Lijambu la Amboni lende kupete alota baka Sapanga ngati hekuandikwi mu Maandiku gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Lijambu la Amboni lende lunndongale Mwana waka Sapanga, ndi Bambu witu Yesu Kilisitu jojwasaliwa ki nhyega mulukolu lwaka Daudi, ");
INSERT INTO mgv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","jojuwe kupete usapi waki na kwa makili gaka Loho jaka Sapanga, jwalangiswa kuba mwana waka Sapanga kupete kuyoka kwaki yani Yesu Kilisitu Bambu witu. ");
INSERT INTO mgv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Nukupete jombi, ne jumbeki wamboni waka Sapanga nguba nuntumi, ili kupete jombi naalongulakia bandu ba ndema yoka anhobalia nukunzetake Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mwanganya montama ku Loma kabee mmbi nkati ja bandu haba, ankemiki mmbia mwabandu baka Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ndienu nunhandaki mwanganya mwaboti mwentama ku Loma mwee mwabandu bampalika na Sapanga, na ankemiki mmbia mwabandu baki. Tunndobee waamboni waka Sapanga nu lukwali kuhuma kwaka Sapanga Atati bitu na kwaka Bambu Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kabula ja goka nunsengu Sapanga wangu kupete Yesu Kilisitu ndaba jinu mwanganya, ndaba kuhobale kwinu kujogwaneka kila pandu pundema pani. ");
INSERT INTO mgv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Sapanga jo nuntumaki kwa mwoju wangu goti pa nandi Lijambu la Amboni laka Mwana waki ndi jojumona nukunyoana ndaba jumanya ndenda kunkomboka mwanganya, ");
INSERT INTO mgv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","masoba goa panunndoba Sapanga. Nundoba Sapanga ana jupai, jumbekia napwasi ja sapi jukuika kwinu kwa masoba gani. ");
INSERT INTO mgv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ndaba ndokule ngamaa kummbona mwanganya ili mbata napwasi juku mmbaguli nhupi ja loho ili mmbia nganganganga. ");
INSERT INTO mgv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Sembala mmanya senze, mwanganya na nepani twitenda kugangamalisana moju, kuhobale kwangu nepani kwanzangatia mwanganya nukuhobale kwinu mwanganya kwinyangatia nepani. ");
INSERT INTO mgv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mwaalongu bangu, mbala mmanya mala jingi napala kuhika kwinu, lakini mbaka sajenu atei kumbenga. Napai ngamaa kuhika ili nhwesa kunzangati mwanganya ili nngangamala mukuhobale, ngati henaajangatia bandu bangi bandema yoti. ");
INSERT INTO mgv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ndaba leniheli lihengu lango, kwaalandi bandu boti, bandu baasomiki na banga kusoma, bandu bana malangu na banga malangu. ");
INSERT INTO mgv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ndaba ndokule ngama kunndandi Lijambu la Amboni kwinu mwanganya kabee mombi ku Loma. ");
INSERT INTO mgv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nepani ngamoni iyoni kulandi Lijambu la Amboni laka Kilisitu, ndaba lenieli ndi makili gaka Sapanga gakaagombo bandu boti baahobale, kutumbuli Ayaudi hoti mbaki bandu ba nndema yoti. ");
INSERT INTO mgv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ndaba Lijambu la Amboni lilangi sapi namuna Sapanga hejwaajetake bandu kuba baamboni palongi jaki. Lijambu lee heli lihengeka sukuhobale, tumbuka puwanzu mbaka pamwisu, ngati Malobi gaka Sapanga egapwaga, “Mundu jwa amboni palongi jaka Sapanga jwitama kupete kuhobale.” ");
INSERT INTO mgv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ndaba inyela yaka Sapanga jilangiswi kuhuma kunani kwaka Sapanga banga kunzogopa jombi na abaja boka baapenga usakaka kupete uliya. ");
INSERT INTO mgv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ndaba goti majambu gagunhenga Sapanga jumanyikana kwabu gabonakini ndaba Sapanga weni jwaalangi pangwendu. ");
INSERT INTO mgv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tumbuka Sapanga pa jwabomba nndema, makili gaki ga yaka petapeta nu ukolongu waki hata ngati ngase ubonikana kwa mihu, lakini gabonikana kupete hindu yejubombiki. Henu ngabiiwesi kulikengale kwi indela jokapi. ");
INSERT INTO mgv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Hata ngati bummanya Sapanga lakini ngase bundumbali wala kunsengula ngati hekupalika. Badala jaki, mawasu gabu gabiya ganga na mana na mioju jabu jatweli lwiye. ");
INSERT INTO mgv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Awasali abii na malangu lakini ngaseabii na malango. ");
INSERT INTO mgv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Akotoka kundumbali Sapanga jojutama yaka petapeta, badala jaki alumbali imong'umong'u yealenganaki kuba ngati mundu jojukua, yeyuye ibi ngati bandu, inyama yeibeleka, ijuni, au iumbi yeikwaba. ");
INSERT INTO mgv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ndaba jahela, Sapanga jwaalekiki apwata kutokule kwiliya mu myoju jabu nukuhengane majambu giiyoni mu nhyega jabu. ");
INSERT INTO mgv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ang'anambwi usakaka waka Sapanga kuba isoli, bikigungamali nukuhitumaki hindu yejubombiki Sapanga nukunndeka Sapanga jojubombiki, jojupalika kulumbaliwa yaka petapeta, Amina. ");
INSERT INTO mgv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ndienu Sapanga jwaalei apwata kutogule kwabu kwiiyoni. Hata haka mbomba bakotuka kugone na aka alomi babu ngati Sapanga hejabombiki, nukutokule kugone nakambomba ajabu. ");
INSERT INTO mgv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Akanalomi nabombi ahelahe akotoka kugone nakambomba nukugone na akanalomi ajaki. Ahenga mahengu giiyoni, kupete kuhenga hela bililete beni mang'aliku ga apalika kupata ndaba jukuhenga mahengu mabaja. ");
INSERT INTO mgv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ngati bandu heakaniki kuba na Sapanga, najombi Sapanga jwaalekiti apwata malangu gabu giliya, jwaalekiki aheenga ganga kupalika kuhenga. ");
INSERT INTO mgv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Atwelii kila uliya na wii gwakila namuna juubaja na soju na ugoni na kukomana. Atwelii wipu na kukoma na isoli na kutokule kuliya nu kugamba, ");
INSERT INTO mgv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","nu kwa akakopakangane bandu isoli na babunsuki Sapanga na baatondoka na baabi ni ing'omu kabee atenda kukipuna atonga majambu giliya, banga kwaajetake ahengo na amabu babu. ");
INSERT INTO mgv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ang'ang'a na banga kuhobaleka na banga kuba nu upali na banga ni ikiya kwa bandu bangi na banga kuhenga sealagi beni kuhenga. ");
INSERT INTO mgv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Amanyi malagalaki gaka Sapanga gapwaga bandu baatenda majambu ngati haga, apalika kuwa. Ganiaga ngase atenda pee beni ila kabee baajetake bangi baatenda majambu ngati haga. ");
INSERT INTO mgv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Henu unkosi wangu ana untemu bandu bangi, ngaguwesi kulikengale, hata ngati gukubi wanya. Ndaba, hewaatemu bangi, ulipeke yaambamba wamweti ndaba na weapa gutenda majambu agalagala gagutemu. ");
INSERT INTO mgv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tumanya kutemu kwaka Sapanga kwa bandu baatenda majambu ngati haga ndi kutemu kwa sakaka. ");
INSERT INTO mgv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lakini unkosi wangu weapa we waatemu bandu baatenda majambu ngati haga koni na wamweti uhenga majambu ngati gagaga, boo, uwasali lee wiijepa kutemuliwa na Sapanga? ");
INSERT INTO mgv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au lee uhulongama waamboni waki nkolongo, na kuinakali kwaki nukulendale kwaki sanga kumanya boo, waamboni waka Sapanga hogu utulongo kujetake mahakau nukugaleka? ");
INSERT INTO mgv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lakini ndaba jii ng'omu na mioju jii janga kupala kujetake mahakau na kugaleka, nahenu mulibeke mwabeti mang'aliku gingi lisoba laka Sapanga inyela yaki nu kutemu kwaki ngati hejupala mweni kwiitenda kubonikana. ");
INSERT INTO mgv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Lisoba leheli Sapanga anndepa kila mundu kulengana na sejuhengi gaki. ");
INSERT INTO mgv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Bandu bahenga majambu gaamboni sangakusoka koni ataputa ulumbi kuhuma kwaka Sapanga ni isima na womi wanga na mwisu, Sapanga jwaapekia womi wa masoba goti. ");
INSERT INTO mgv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lakini bangi baapwata majambu gabu beni na baakana usakaka waka Sapanga nukupwata ubaja, sakaka Sapanga jwaatemula kwii nyela yaki ngolongu. ");
INSERT INTO mgv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mang'aliku nu ubini gampata mundu jokapi jojutenda ulia. Gaapata hoti Ayaudi mbaka bandu banga Ayaudi kabee. ");
INSERT INTO mgv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lakini Sapanga jaapekia ulumbi ni isima nu lukwali bandu boti baatenda majambu ga amboni, jwaapekia Ayaudi hoti na bandu banga Ayaudi kabee. ");
INSERT INTO mgv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ndaba Sapanga ngase jujangati bandu boti sukubagu bangi. ");
INSERT INTO mgv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Bandu boti baatei mahakau sanga kugamanya Malagalaki gaka Musa biikuwa sukutemuliwa bila Malagalaki, na baatei mahakau koni amanya Malagalaki, biitemuliwa kupete malagalaki. ");
INSERT INTO mgv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ndaba nga bandu baajogwane pe Malagalaki gaka Musa ndi abonekana baamboni kwaka Sapanga, ila bandu baajetake Malagalaki ndi babibonikana baamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Bandu Banga Ayaudi ngaseabi na Malagalaki gaka Musa, lakini paahenga ngati egapalika Malagalaki sukulongoswa na mioju jabu, bombi akuba ndi Malagalaki hata ngati ngaseagamanyi Malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bombi alangi sekipalika mu Malagalaki gagaandikwi mu myoju jabu, koni moju wabu ulangi lijambu leheli, ndaba mawasu gabu mala jingi gatenda kwaataki na mala jengi gatenda kwaakengale. ");
INSERT INTO mgv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Henu, kupete Lijambu la Amboni lenandi nepani ndi hekwiibia lisoba lela Sapanga pajwiitemula kupete Yesu Kilisitu majambu gaahengiki bandu pu ujobu. ");
INSERT INTO mgv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Henu boo wehapa? Wehapa, ana ulikema wamweti Nhyaudi, guhobale Malagalaki gaka Musa nukukipuni kuba mwana waka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kupete Malagalaki gaka Musa ugamanyi gajupala Sapanga kabee guwesa kuhagu majambu gaamboni. ");
INSERT INTO mgv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ulimanya wehapa ukilongosi wa bandu banga kulinga na wehapa unang'anu wa bandu baabii palwii, ");
INSERT INTO mgv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ulibona weapa gu mmbola wa bandu ang'ang'a nu mbola wa bana akeke ndaba nhwasali mu malagaliki mbii na umanyi nu usakaka. ");
INSERT INTO mgv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Henu weapa, gwaabola bangi ndaba jaki ngase gulibole wamwete? Wehapa walandi bangi biijiba na wamweti gutenda kujiba. ");
INSERT INTO mgv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Weapa gupwaga, “Mundu jwiitenda ugoni,” koni wamwe utenda ugoni. Gusuki imong'umong'u yi isapanga ndaba jaki wamweti gujingi nukujiba mali gingi mu nyumba ji isapanga. ");
INSERT INTO mgv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Weapa weukipuna ugamanyi Malagalaki gaka Sapanga lakini umpoa Sapanga lihamu sukukotoka kuhenga ngati malagalaki hegapala? ");
INSERT INTO mgv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ngati Maandiku gaka Sapanga hegapwaga, “Bandu banga Ayaudi alitondwi liina laka Sapanga ndaba ja majambu ganhenga mwa Ayaudi mwanganya.” ");
INSERT INTO mgv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kuseku jandu kwaku kwiibia kwasakaka ana gujetake Malagalaki, lakini ana ngasegutenda ngati Malagalaki hegapala, kuseku jandu kwaku kukuba ngati mundu jwanga kusekujandu. Ndienu mbanga wakahigali sanga kuseku jandu. ");
INSERT INTO mgv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ana bandu banga Ayaudi banga kuseku jandu ahenga gagapalika mu Malagalaki, boo, kutama bila kuseku jandu kwabu ngase kubonikana le ngati asekwi jando? ");
INSERT INTO mgv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Henu bandu banga Ayaudi bantemula mweapa mwa Ayaudi mwensekwi jandu nukugamanya Malagalaki gaka Sapanga ana ngasenhenga ngati Malagalaki hegapala. ");
INSERT INTO mgv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ndaba nga kila mundu jojubonikana kunza kuba Nhyaudi ndi Nhyaudi wa sakaka kabee mundu ngasejukuba nhyaudi wasakaka ati ndaba jusekwi jandu nhyega. ");
INSERT INTO mgv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Nhyaudi wa sakaka ndi mundu jojubi nhyaudi nkati, ndi jojusekwi jandu mu moju. Ganiaga ndi majambu gu mu loho, na nga majambu gagabi mu maandiku gagabi mu Malagalaki. Mundu ngati hoju ngase jupata ulumbi kuhuma kwa bandu ila ulumbi kuhuma kwaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Nhyaudi jubii na sindu boo kikolongu kupeta bandu bangi? Au boo, Ayaudi baajonzuki sindu boo ngani kupete kuseku jandu? ");
INSERT INTO mgv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Hena, Kibii sekijonzukeka kila upandi. Sapanga jatumbulia oti kwaapeke Ayaudi malobi gaki. ");
INSERT INTO mgv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Henu kwibia boo, ana bangi babu akotwiki kunhobale Sapanga? Boo, kukotoka kuhobale kwabu kwiiboa lee kuhobaleka kwaka Sapanga? ");
INSERT INTO mgv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ngaela! Sapanga juigali kuba jojuhobaleka masoba goka hata ngati kila mundu julonge isoli. Ngati hegapwaga Maandiku gaka Sapanga, “Kila hegulonge, malobi gaku gakubaa ga sakaka, pa witemuliwa, wehapa ndi wibia we guwesa.” ");
INSERT INTO mgv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ana mahakau gitu galangi Sapanga jutenda gaamboni, henu twiipwaga bole? Boo, ana jututemwi twiipwaga lee Sapanga jutenda liya. Pamba nonge kwa mawasu gikimundu. ");
INSERT INTO mgv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ngahela! Nakwakabii hela Sapanga jwakawesa boo kwa atemu bandu bu punndema? ");
INSERT INTO mgv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mundu juwesa kupwaga ana, “Ana isoli yangu ijangati kulangi usakaka waka Sapanga nukujonzuke ulumbi waki, henu ndaba jaki nepani andemu kuba namundu mwana mahakao?” ");
INSERT INTO mgv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Kulengana nukupwaga ana, tuhenga majambu giliya ili tupata gaamboni! Ndi bangi hebututondula sukututaki tupwagiki hela. Biitemuliwa ngati hekupalika. ");
INSERT INTO mgv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Henu tupwaga kike? Boo, twa Ayaudi lee twaamboni kupeta bandu bange? Ngahela! Ndaba anangi kupwaga Ayaudi na bandu banga Ayaudi boka abii pai ja makili ja na mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ngati maandiku gaka Sapanga hegapwaga, “Ngamundu hata jumu jwaamboni palongi jaka Sapanga, ");
INSERT INTO mgv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nga mundu jumwa jwana malangu wala ngakuba mundu hata jumu joantaputa Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boti atei kung'anambuka boti atei kukosa nga jojutenda gaamboni, ngasejubii hata jumu. ");
INSERT INTO mgv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Milomu jabu jibii ngati matenge gaayekwi gaganunga, ni ilimi yabu ilonge isoli mu milomu jabu gapita malobi gana sumu ngati gi lijoka. ");
INSERT INTO mgv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Malobi ga alonge gatweli yaambamba nu usungu. ");
INSERT INTO mgv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Magolu gabu gajojuke kukoma bandu. ");
INSERT INTO mgv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Pokapi pa ajenda aleta ling'ai nuku kuhalabana hindu. ");
INSERT INTO mgv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ngaseamanyi kutama su lukwali.” ");
INSERT INTO mgv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Ngase bunzogopa Sapanga hata kidogu.” ");
INSERT INTO mgv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","“Henu tumanyiki ana malobi goka gagalongi mu Malagalaki gaka Musa, gaapwaga bandu boti baalongoswa na Malagalaki ili kila mundu jiiwesa kulikengale, ili kulangi bandu boti apalika kutemuliwa na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Henu nga mundu hata jumu jojubalangiwa kuba jwaamboni palongi jaka Sapanga sukukamulaki Malagalaki, ndaba Malagalaki gehaga gunzangati mundu kumanya ana juhengiki mahakau.” ");
INSERT INTO mgv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lakini henu indela jaka Sapanga ja kwaajetake bandu kuba baamboni palongi jaki jibonikini pangwendu, kabee bila kugahenga Malagalaki. Malagalaki gagaandikwi na Musa na Alota baka Sapanga alongale lijambu leheli. ");
INSERT INTO mgv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Sapanga jwaajetake bandu kuba baamboni kwi indela jukunhobale Yesu Kilisitu. Sapanga jutenda ela kwa boka babunhobale Kilisitu ndaba ngasejibi tofauti kati ja Ayaudi na bandu banga Ayaudi. ");
INSERT INTO mgv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Bandu boka atei mahakau nukupongukewa nu ulumbi waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lakini kupete waamboni wa bwaka waka Sapanga bandu boti ajetakeka ku kuba baamboni palongi jaka Sapanga kupete Yesu Kilisitu jojwaakombwi. ");
INSERT INTO mgv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Sapanga ampia Yesu Kilisitu kwa mwai waki ili jubia indela ja kwaalekake bandu mahakau gabu kwa mwai waki kupete kunhobale jombi. Sapanga jwatenda hela ili kulangi jombi jwaamboni. Kabula jukukuwa Kilisitu Sapanga jwatenda kuhinakali bila kulingali mahakau ga bandu. ");
INSERT INTO mgv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Lakini henu Sapanga ampia mwana waki ili kwaalangi bandu aina ja wamboni gogujetakeka palongi jaki. Kwi indela heji Sapanga mweni julangi jombi jwaamboni na kabee antenda kila mundu joanhobale Yesu jubia jwaamboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Henu tuwesa kukipunii kike? Ngasekibile! Ndaba jaki? Boo, nndaba jukugahenge lihengu Malagalaki gaka Musa? Ngahela! Ila ndaba tutenda kuhobale Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Henu tumanya Sapanga anzetake mundu kuba jwaamboni palongi jaki kupete kuhobale kwaki, ila nga kukuhenga gagapalika mu Malagalaki gaka Musa. ");
INSERT INTO mgv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Au boo, Sapanga ndi Sapanga waka Ayaudi pena, au Sapanga wa bandu ba ndema yoka kabee? Heena, Sapanga wa bandu banga Ayaudi boti kabee. ");
INSERT INTO mgv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Sapanga jubi jumu pena, najombi jwaatenda bandu Ayaudi na bandu ba nndema joti abia baamboni kupete kuhobale kwabu. ");
INSERT INTO mgv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Henu boo, tugaleke Malagalaki gaka Musa ndaba jukuhobalela? Ngahela ila tugajemale Malagalaki gaka Musa kulangi ga sakaka. ");
INSERT INTO mgv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Boo, henu tupwaga kike kuhusu atati bitu Ibulahimu? ");
INSERT INTO mgv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ana Ibulahimu jwabii bunhengiki kuba jwaamboni palongi jaka Sapanga kupete mahengu gaki mweni, nala jubii na sindu sukukipuni lakini nga palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ndaba Maandiku gaka Sapanga gapwaga, “Ibulahimu anhobalia Sapanga, najombi Sapanga anzetakia kuba waamboni palongi jaki.” ");
INSERT INTO mgv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Mundu jojuhenga lihengu kwaka mundu julepwa malepu, malepu gaki nga nhupi yake ila sindu sejupalika kulepwa kwi lihengu lejuhengiki. ");
INSERT INTO mgv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lakini mundu jwanga kuhobale mahengu gaki mweni, ila anhobale Sapanga jojwaalekake bandu baatende mahakau, henu Sapanga jukubona kuhobale kwaka mundu hoju nukunzetake kuba jwaamboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daudi kabee jwapwaga ahelahe pajwalongalia kutogule kwaka mundu jojuwe Sapanga ambona jwaamboni palongi jaki sanga kulingali mahengu gaki: ");
INSERT INTO mgv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Apengaliwi bandu baalekakiwi makosa gabu, babube mahakau gabu atei kugaputa. ");
INSERT INTO mgv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Jupengaliwi mundu jojuwe mahakau gaki Bambu nga juga komboke.” ");
INSERT INTO mgv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Boo, kutogule hoku apata bandu baasekwi jandu pena au apata na bandu banga kuseku jando? Apata na bandu banga kuseku jandu kabee. Ndaba tupwagiki, “Ibulahimu jwatenda kuhobale na Sapanga jwatenda kunzetake kuba jwaamboni palongi jaki” ");
INSERT INTO mgv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Boo, Ibulahimu jwajetakiwa na Sapanga kipindi bole? Kabula jukuseku jando, au baada jukuseku jandu? Kabula jukuseku jandu, na nga baada jukuseku jando. ");
INSERT INTO mgv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibulahimu jwasekula jandu mwenikatai, nukuseku jandu kwe hoku kwabii nginyuli jejalangia Sapanga anzetaki jombi kuba jwaamboni palongi jaki ndaba jukuhobale kwaki kojwabi naku kabula jukuseku jandu. Henu, Ibulahimu jubi ndi atati ba bandu boti babube, hata na ngaseasekwi jandu, bunhobale Sapanga nukuhengwa kuba baamboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Jombi kabee atati ba bandu baasekwi jandu, lakini nga ndaba atei kuseku jandu pee, ila ndaba apwata indela ajelajela jukuhobalela jebabia apwata atati bitu Ibulahimu kabula jukuseku jandu. ");
INSERT INTO mgv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Sapanga andagila Ibulahimu nikibeleku saki kupwaga ampekia ndema joti jakakuba jabu. Lilagii heli ngaselahengiki ndaba Ibulahimu jwagapwata malagalaki gaka Musa, ila ndaba jwatenda kuhobalela, nukujetake kuba jwaamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ndaba ana babiipata Malagi gaka Sapanga pena ndi bandu baajetake malagalaki gaka Musa pena nala kuhobale ngasekubii na mana jokape, nakwombi kulagi kwaka Sapanga nga sindo. ");
INSERT INTO mgv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Malagalaki galeta inyela, lakini na ngakuba malagalaki, ngakukubi na makosa. ");
INSERT INTO mgv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Kwa ndaba heji, lilaganu lihika kwa ndela jukuhobale, henu lilaganu heli ndi nhupi yaka Sapanga, na henu lilaganu heli ndi nginyuli jejilangi usakaka lilaganu heli ndi li kibeleku soka saka Ibulahimu, nga kwa bandu babagakamulaki malagalaki gaka Musa, ila kabee na kwa bandu baatama kupete kuhobale ngati Ibulaimu. Jombi ndi atati bitu twaboti. ");
INSERT INTO mgv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ngati maandiku gaka Sapanga hegapwaga, “Nugubei gubia gwa atati ba bandu ba ndema yoti.” Malagi haga ndi sakaka palongi jaka Sapanga joampwagila Ibulaimu, Sapanga jojwaayoa bandu, nukupete mihilu yaki, jwiihenga hindu yoka yeyabii ngaseibii ibiya. ");
INSERT INTO mgv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Hata ngati ngasekwabi na sindu sokapi sesunhenga Ibulahimu kuhobale lilaganu heli, lakini Ibulahimu anhobalea Sapanga nukulendale lilaganu heli na bunhenga kuba atati ba bandu ba makabila gingi, ngati hebunndagila kupwaga, “Kibeleku saku kiikuba kingi ngamaa ngati ndondu.” ");
INSERT INTO mgv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Jwabii hokomundu jojuhegale kuba na yaka mia jimu, lakini kuhobale kwaki ngase kwakotwike hata mweni jwamanyiki ngase juwesa kupapa ndaba jabii nseja ngamaa, nu nhwanu waki Sala yaka yaki yukubeleka mwana yabia ipetiki. ");
INSERT INTO mgv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ibulahimu ngase jakotwiki kuhobale na ngase jwaabii nikiholu kupete lilaganu laka Sapanga ila kuhobale kwaki kumpekia makili nukunhobale Sapanga henu anndumbalia Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Jamanya ana sakaka Sapanga juwesa kuhenga gala gaandagila. ");
INSERT INTO mgv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndi ndaba Sapanga anzetake kuba jwa amboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Paalonge, “Jatenda kunzetake kuba jwaamboni palongi jaki.” Ngasealonge anzetaki jubiya jwaamboni kajika jaki pena. ");
INSERT INTO mgv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Lijambu le heli lutulongale natwepani kabee totujetakiwi na Sapanga totunhobale Sapanga joanhyoa Yesu Bambu witu kuhuma kwa bandu baawii. ");
INSERT INTO mgv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yesu bumpia jukuwa ndaba ja mahakau gitu, jayoka ili kutuhenga twaamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Henu, ndaba Sapanga jututei tubia twaamboni palongi jaki kupete kuhobale, henu tubii nulukwali na Sapanga kupete indela jaka Bambu witu Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ndaba jukuhobale kwitu, Yesu jutuletiki mu waamboni waka Sapanga mo tutama sajenu. Natwepani tutogule kukipuni kuhobale kotubi naku kutama pamu nu ulumbi waka Sapanga! ");
INSERT INTO mgv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ngahela pena, ila tutogule ndaba ja mang'aliku koni tumanya mang'aliku gutubola kuhinakali, ");
INSERT INTO mgv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kuhinakali kungangamalisa mundu mwoju, nu kugangamaa mwoju kundete mundu kuhobale. ");
INSERT INTO mgv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nukuhobale ngasekutuhenga tusindwa, ndaba Sapanga jutupeki upali waki mu myoju jitu kupete indela jaka Loho wa Sapi jejutupeki. ");
INSERT INTO mgv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ndaba hata patwabiya twakona nga na makili, esahika kipindi, Kilisitu jwakuwa ndaba jitu twepani twana mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Sakaka, ngasekuwesikana mundu kuwa ndaba ja mundu jo jujetakeka palongi ja bandu ila kuwesikana mundu kulenga kuwa ndaba ja mundu jwaamboni. ");
INSERT INTO mgv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lakini Sapanga julangi kwitu jutenda kutupala, ndaba patwabia twakona tubi na mahakau, Kilisitu jwakuwa ndaba jitu twepani. ");
INSERT INTO mgv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Henu ndaba jututei tubia twaamboni palongi jaki kupete mwai waka Yesu Kilisitu, kulangi sakaka jwatukombula kuhuma mwi inyela yaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ndaba twabia twaabaja baka Sapanga lakini jutulenganaki tubia twaakosi baki kupete kuwa kwaka Mwana waki. Henu ngati hetubii twaakosi baka Sapanga sakaka kulangi he jwatuokuwa kupete womi waka mweni Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nga haga pena ila tutogule kabee ndaba jagala gajutuhengi Sapanga kupete indela jaka Bambu witu Yesu Kilisitu jojutujonganisi na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kupete indela jaka mundu jumu mahakau gatenda kujingi punndema, nagombi gaatenda bandu akuwa. Henu kuwa kwaahiki bandu boka ndaba bandu bowa atei mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ndaba kabula jukuhika malagalaki gaka Musa mahakau gabii punndema, lakini mahakau ngase gabonakini bila kuba Malagalaki. ");
INSERT INTO mgv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lakini toka pajwabii Adamu mbaka pajwahikiki Musa, kuwa kwaapatiki hata bandu banga kutenda mahakau ngati hejwatenda Adamu, mahakau guku nng'anambuka Sapanga. Adamu jwabii lilenganu laka jola jojwihika. ");
INSERT INTO mgv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lakini lihakau laka Adamu ngase lilengana na waamboni waka Sapanga. Ndaba ana mahakau gaka mundu jumu galeta kuwa kwa bandu boti, kulangi ana uamboni waka Sapanga gobii gwingi na nhupi jaki ja bwaka jejibii kwa bandu bingi, nayombi ihuma kwaka mundu jumu, mundu we hoju ndi Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nhupi yaka Sapanga ngaseilengana sekiipitila baada jukuhenga lihakau mundu jumu: Sapanga jwaatemula bundu kupete lihakau lejwatei mundu jumu, lakini bandu bingi pababiya ahengiki mahakau, Sapanga jaaletila nhupi jakuba jwaamboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Sakaka, kupete lihakau laka mundu jumu, kuwa kwatenda kuhika ndaba jaka mundu jumu hoju, lakini kulangi sekipiti kupete sejutei mundu jumu hoju yaani ndi Yesu Kilisitu hekibi kikolongu ngani! Boka baajopa waamboni waka Sapanga wabwaka hogu na nhupi heji ahengwa kuba waamboni palongi jaka Sapanga, biitawala mu womi kupete indela jaka jumu hoju, yaani Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Henu ngati hekubi lihakau laka mundu jumu liletiki kutemuliwa kwa bandu boka ndi ahelahe kupete lijambu limu laamboni laka mundu jumu kwaka Sapanga laapeke boti waamboni na womi. ");
INSERT INTO mgv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na ngati hekubi kusindwa kunzowane Sapanga kwaka mundu jumu hekwaatenda bandu bingi abia na mahakau, ndi ahelahela kunzowane Sapanga kwaka mundu jumu hekwaatenda bandu bingi kuba baamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagalaki gaka Musa gahika ili kuleta ujonzukeku wa mahakau, lakini mahakau hegajonzukika, waamboni waka Sapanga nagombi watenda kujonzukeka ngani. ");
INSERT INTO mgv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ngati mahakau hegalongosa nukuleta kuwa, ndi ahelahe waamboni wa bwaka waka Sapanga ulongusa kwi indela ja kwaahenga bandu abiya baamboni palongi jaki nu kulongosa abiya na womi wa masoba goti kupete indela jaka Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Henu tupwaga boo? Boo, tuendalia lee kukuhenga mahakau ili waamboni waka Sapanga ujonzukikaje? ");
INSERT INTO mgv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ngahela! Twepani twe tuwii kupete mahakau tuwesa boo kuendalee kuhenga mahakao? ");
INSERT INTO mgv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Au lee ngase mmanya twepani twaboa twe twabatiswa nukujongana na Yesu Kilisitu sukujongana na kuwa kwaki. ");
INSERT INTO mgv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Patwabatiswa twajongana pamu na jombi mu kuwa kwaki nukusikwa kwaki, ili ngati Kilisitu ejayoka kuhuma kwa bandu baawi kupete ulumbi wa Atati na twepani kabee tuwesa kuba na womi nyai. ");
INSERT INTO mgv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ndaba ana twepani tujongini najombi kwa kuwa kwaki ngati jombi, ahelahela twiijongana najombi sukuyoka ngati hejwayoka jombi. ");
INSERT INTO mgv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tumanya umundu witu wa mwandi buubambalia pamu na Kilisitu, ili nhyega itu ya mahakau ialabika, ili tukotuka kuba twaatumwa ba mahakau kabee. ");
INSERT INTO mgv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ndaba mundu jokapi jojuwi julekakiwi, na ngasejulongoswa na mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Henu ana tuwi pamu na Kilisitu, tuhobale twiitama kabee pamu na jombi. ");
INSERT INTO mgv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ndaba tumanya Kilisitu juyokiki kuhuma kwa bandu baawi najombi nga jukui kabee, ndaba kuwa nga kukubi na makili kabee kwaake. ");
INSERT INTO mgv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Henu, ndaba jwakuwa mala jimu pee ndaba ja mahakau ga bandu, mahakau ngasegunndoo jombe, nukutama kojutama jujongana na Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ahelahela nanamu kupalika mulibona ntei kuwa kupete mahakau, nukutama pamu na Sapanga kupete na Kilisitu Yesu. ");
INSERT INTO mgv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Henu, mwiijetake mahakau galongua nhyega hinu jejikuwa ili mwiijetake ndokule iliya ya nhyega. ");
INSERT INTO mgv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Wala mwiipia hata pandu pamu pa nhyega ji ibia sindu sukutende mahakau. Ila mulipia kwaka Sapanga ngati bandu babayokiki kuhuma kukuwa kujingi mu womi. Lakini mpia ihungu yi yoti ihenga lihengu laka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ndaba mahakau ngagundongoo mwanganya kabee, ndaba ngase nndongoswa na Malagalaki gaka Musa ila nndongoswa na waamboni waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Henu, tupwaga kike? Tutendaa mahakau ati ndaba ngasetubi pai ja malagalaki ila tulongoswa na waamboni waka Sapanga? Ngahela! ");
INSERT INTO mgv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mmanya nde ana mulipiiki mwabe kuba mwaatumwa sukunzoane mundu najongi, sakaka mwanganya mkuba mwaatumwa baka mundu we hoju. Ana mwiikuba mwaatumwa ba mahakau mwisu waki kuwa, na ana mmbii mwaatumwa bukunzoane Sapanga mwisu waki junhenga mmbiya mwaamboni palongi jaki. ");
INSERT INTO mgv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ata na mwabi mwaatumwa ba mahakau pamwandi, lakini henu nunsengu Sapanga nzetaki kwa mwoju wii woti usakaka gogubii mu mabole ganzopiki. ");
INSERT INTO mgv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mwakombuliwi kuhuma mu utumwa wa mahakau, nakuba mwa atumwa bukuhenga majambu gaamboni palongi jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nonge luga jakawaida ja bandu ndaba jukusindwa kumanya kwitu. Ndaba mwabe mulipia kutumaki upija nu ulia ndaba ju ubaja, ahelahela henu mulipia mwabeti kuba mwaatumwa bukutenda majambu gaamboni palongi jaka Sapanga ili nhuwesa kutama mu usapi. ");
INSERT INTO mgv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Pamwabia mwa atumwa ba mahakau ngase mwawesiki kuhenga gajupala Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Mwapata sindu boo, saamboni pamwahenga hindu yemwibone hioni sajenu? Ndaba mwisu wa majambu haga goti ndi kuwa! ");
INSERT INTO mgv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lakini henu mkombuliwi kuhumu ku utumwa wa mahakau na mmbi mwa atumwa baka Sapanga, sindu samboni se mpata sajenu ndi kutama maisa gu usapi gagaleta womi wa masoba goti. ");
INSERT INTO mgv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ndaba malepu ga mahakau ndi kuwa lakini nhupi jejupia Sapanga ndi womi wa masoba goti su kupete Yesu Kilisitu, Bambu witu. ");
INSERT INTO mgv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Mwaalongu bangu henu manyiki nonge na bandu babagamanya malagalaki. Ndaba mmanyiki ana malagalaki gunndongoo mundu pajukuba mwomi. ");
INSERT INTO mgv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Tupwaga, mmbomba jobunzukwi jukuba pai ja Malagalaki pajutama nu nndomi waki pajukuba mwomi, lakini nndomi waki ana juwii, Malagalaki haga ngasegundongosa kabee mmbomba hoju. ");
INSERT INTO mgv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Henu mmbomba hoju na jutama na mwanalomi jongi kipindi nndomi waki jubii mwomi, bankema nhgoni, lakini nndomi waki ana juwii, mmbomba hoju jukuba julekakiwi ngasejubii pai ja malagalaki kabee, ana jujukuliki na mwanalomi jongi ngajwiikubi nhgone. ");
INSERT INTO mgv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ahelahe mwaalongu bangu ngasemmbii kabee mu Malagalaki ndaba nnzongini na nhyega jaka Yesu Kilisitu, mana jaki Kilisitu pajakuwa na mwanganya mwakuwa pamu najombi. Henu mwanganya mmbii mwabandu baki, jombi Kilisitu jojuyokiki ili nhwesa kuntumaki sapi Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ndaba patwabia tutama sukulongoswa na kutokule kuliya kwa nhyega kotubii naku, kutokule kokutukoluwa ndaba ja Malagalaki gaka Musa, kokukwe gahenga lihengu nkati ja nhyega jitu nukutulete kuwa. ");
INSERT INTO mgv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lakini henu tulekakiwi kuhuma muipungu ya Malagalaki, ndaba tuwi ndaba ji lijambu le lutuhenga twepani tubia twaatumwa. Henu tuwesa kuntumaki Sapanga sukupwata indela inyai ju ulongosi waka Loho jaki, wala nga ngati pamwandi patwabiya tulongoswa na maandiku ga Malagalaki. ");
INSERT INTO mgv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Boo, nala tupwaga hetupwata Malagalaki tutenda mahakau? Ngahela! Lakini bila Malagalaki nepani nga nakamanyi mahakao. Ndaba nganaka manyi kutokule majambu gilyaa ndi sindu salia, ana Malagalaki egakabii ngase gapwagiki, “Wiitokule.” ");
INSERT INTO mgv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Sukutumi mihilu heji, mahakau gapata napwasi jukujumu kila aina jukutokulee kwalia kokubi nkati ja nhyega. Ndaba bila Malagalaki mahakau gakubape sindu sekiwii. ");
INSERT INTO mgv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Pamwandi nepani nabii namwomi kutali na malagalaki, lakini mihilu hejahika, mahakau gatenda kuyoka nanepani nabii ngati ndei kuwa. ");
INSERT INTO mgv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Henu Mihilu jejapala kuleta womi, kwangu nepani jiletiki kuwa. ");
INSERT INTO mgv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ndaba mahakau gapata napwasi kwi indela ji mihilu ajelaje nukungonga nepani nu kungoma. ");
INSERT INTO mgv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Henu, Malagalaki geni gabii pe gaga Sapi ni mihilu je heji jabii pe jeja Sapi, kabee jaamboni palongi jaka Sapanga na ja sapi. ");
INSERT INTO mgv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Boo, sesabi saamboni saleta kuwa kwangu nepane? Ngahela! Mahakau ndi gaganeti nepani kuwa. Lakini ili mahakau gabonikana mahakau ga sakaka, gapetila indela ja sindu sekikuba sa amboni ili kuleta kuwa kwangu. Henu mahakau kupete indela ji mihilu, gililangia sapi hegabii giliyaa ngamaa. ");
INSERT INTO mgv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tumanya Malagalaki ndi loho, lakini nepani namundu jumu nndema, nepani anombisi mia ntumwa wa mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ngase nikimanyi sehenga, ndaba sembala kuhenga ngase mbala kuhenga lakini sindu se nikisuki ndi se nihenga. ");
INSERT INTO mgv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Henu, ana nihenga sanga kukipala namwe, kulangi nyetake Malagalaki kuba ga amboni. ");
INSERT INTO mgv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Lakini henu nga nepani jojuhenga sanga kukipala ila mahakau gagatama nkati jangu. ");
INSERT INTO mgv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Manyiki ngasekibi samboni sokapi nkati jangu nepani, kulengana nu umundu wangu. Ndaba mbala kutenda lijambu lelibii laamboni, lakini ngase nhwesa kuhenga. ");
INSERT INTO mgv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ndaba lijambu laamboni lenilipala ngase nilihenga, ila lijambu la liyaa langa kupala kulihenga ndi lenilihenga. ");
INSERT INTO mgv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Henu ana nihenga lijambu langa kulipala namweti, henu kulangi nga namwete jojuhenga haga ila ga mahakau gagatama nkati jangu ndi gagahenga. ");
INSERT INTO mgv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Henu manyiki Malagalaki gahenga lihengu nkati jangu: Pambala kuhenga lijambu laamboni, nilibona nihaguu kuhenga lijambu li liyaa. ");
INSERT INTO mgv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ndaba nkati ja mojuwangu nitogule Malagalaki gaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lakini nagabona malagalaki gangi gagahenga lihengu mu nhyega jango, malagalaki gagapengana na Malagalaki gagajetakewa na malangu gangu. Henu ganhenga mia nuntumwa wa malagalaki ga mahakau gagahenga lihengu mu nhyega jango. ");
INSERT INTO mgv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Musinikiboni namundu nhagu nepani! Nya jojwingombula nepani kuhuma mu nhyega jejinongo nepani kuwa? ");
INSERT INTO mgv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Jusengulikaa Sapanga jojutenda hela kupete Bambu witu Yesu Kilisitu! Hela ndi hemi, kwa malangu gangu ndumaki Malagalaki gaka Sapanga lakini kwa ndokule yangu ya nhyega jangu ndumaki malagalaki ga mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Henu sajenu bandu baatama kupete Kilisitu Yesu ngase kubii kutemuliwa kwabu kabee. ");
INSERT INTO mgv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ndaba, malagalaki gaka Loho jojuleta womi jojubii nkati jaka Yesu Kilisitu ganhokwi kuhuma ku malagalaki ga mahakau na kuwa. ");
INSERT INTO mgv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Sapanga juhengi lihengu legasindwa kuhenga Malagalaki, ndaba jukukosa makili kwa nhyega. Sapanga antumia Mwana waki wakajika koni jubii na nhyega ngati hejibii nhyega jitu twepani twetubii na mahakau ili jugawesa mahakau nukupete nhyega jeheji jugakoma mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Sapanga jwatenda hela ili sekipalika mu Malagalaki kihengika bwisu nkati jitu twepani twetubi twabomi, nga kwa makili gaka mundu ila kwa makili ga Loho. ");
INSERT INTO mgv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ndaba bandu baatama sukulongoswa na ndokule iliya ya nhyega malangu gabu galongoswa na ndokule ilia ya nhyega. Lakini bandu baatama sukulongoswa na Loho jaka Sapanga ahenga mahengu gajupala Loho jaka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ndaba kulongoswa na ndokule ilia ya nhyega kuleta kuwa lakini kulongoswa na Loho jaka Sapanga kuleta womi nu lukwali. ");
INSERT INTO mgv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ndaba baalongoswa na ndokule ilia ya nhyegaa akuba abaja baka Sapanga, ngase bagajetake Malagalaki gaka Sapanga wala ngaseawesa kugajetake. ");
INSERT INTO mgv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bandu baajetake kulongoswa na nhyega ngase awesa kunhenga Sapanga jutogulia. ");
INSERT INTO mgv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Lakini mwanganya ngase ntama sukulongoswa na nhyega, ila nndongoswa na Loho, ana Loho jwaka Sapanga jutama nkati jii. Jokapi jwangakuba na Loho jaka Kilisitu hoju nga mundu jwaka Kilisituje. ");
INSERT INTO mgv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Lakini ana Kilisitu jubii nkati jinu, Loho jaka Sapanga jumpeke womi ndaba nkuba nzetakiwi kuba mwaamboni palongi jaka Sapanga hata ngati nhyega yinu yiibia iwi ndaba ja mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ana Loho jaka Sapanga jojunhyoa Yesu kuhuma kwa bandu baawi jutama nkati jinu, nala joanhyoa Yesu hoju jwaipekia womi nhyega jii jejikuba ja kuwa, jwiihenga hela kupete Loho jaki jojutama nkati jino. ");
INSERT INTO mgv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Henu mwaalongu bangu, tubii ni lihengu lukuhenga, lakini nga lukulongoswa na ndokule iliya ya nhyega ngati heipala. ");
INSERT INTO mgv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ndaba ana ntama sukulongoswa na ndokule ilya ya nhyega sakaka mwiitenda kuwa. Lakini kupete Loho ana mugakoma mahengu gii gilyaa nala mwiitenda kutama. ");
INSERT INTO mgv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Boti baalongoswa na Loho jaka Sapanga ndi bana baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ndaba ngasemwajopiki Loho jojwanhenga mwanganya kuba mwaatumwa kabee nukunzege kiholu, ila munzopiki Loho jojunhenga mwanganya kuba mwabana baka Sapanga, na kwa Loho hoju, twepwani tunkema Sapanga, yani “Aba!” Mana jaki, “Atati” ");
INSERT INTO mgv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Najombi Loho mweni julangi mu loho yitu kupwaga twepani twabana baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Henu ndaba twepani twabana baka Sapanga, twiijopa mbengale yoka yejwaabeki Sapanga bandu baki, twiilisa ulisi hogu pamu na Kilisitu, ndaba ana tung'aliki pamu na Kilisitu ahelahe twiilumbalika kabee pamu na jombi. ");
INSERT INTO mgv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mang'aliku gagabonikana sajenu kwangu nee mona nga sindo ana nagalenganisi nu ulumbi gogwiibonikana kwiitu. ");
INSERT INTO mgv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Hindu yomi yoka yunndendale Sapanga kwa hamu ngolongu jwaalangia bana baki. ");
INSERT INTO mgv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ndaba hindu yomi yoka biing'anambwi kuba yanga na mana, nga sukupala yeni ila biibombiki hela sukupala Sapanga mweni. Ila kuhobale kubii, ");
INSERT INTO mgv_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ndaba ihumbi hei nayombi yiigombuliwa kuhuma mu utumwa wo uhalabanika, nukujingi ukulekakewa mu ulumbi wa bana baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ndaba tumanya mbaka sajenu, ihumbi yoka ilela sukubobo su ubini ngati ulipyanda lukubeleka mwana. ");
INSERT INTO mgv_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nga ihumbi hei pena yeyibobula ila hata twepani twetubi tayali na Loho jaka Sapanga, jojubii jukutumbulii mu nhupi yejwatupekia Sapanga, natwe twiitenda kubobo nkati jitu koni tulendale kujetakewa na Sapanga kuba twabana baki yani kugombolewa umundu witu. ");
INSERT INTO mgv_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ndaba kupete kuhobale hoku twepani tukombuliwi. Lakini kuhobale ngasekubi na mana ana tukibona setukihobale. Ndaba nya jojuhobale sindu sejukibona? ");
INSERT INTO mgv_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ana tukihobale sindu sanga kukibona nala tukilendalee sukuhinakali. ");
INSERT INTO mgv_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Helahe kabee najombi Loho jutujangati muku sindwa kwitu. Ndaba ngasetumanya hetupalika kuloba lakini Loho mweni jutulobe kwaka Sapanga kwikilelu sukubobo. ");
INSERT INTO mgv_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Najombi Sapanga jojubona mbaka nkati ja myoju ja bandu, jumanya mawasu ga Loho hoju, ndaba Loho hoju jwaalobe bandu baka Sapanga kulengana nu upali waka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tumanya mu majambu goti gajuhenga Sapanga juhenga kwa bandu boti babumpala, yaani bajaakemiki kulengana na sejaakemi. ");
INSERT INTO mgv_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ndaba Sapanga jwaamanyiki bandu baki toka pu utumbuli na jwaagula ili awanangana na mwana waki, ili mwana jubia ju utumbuli mu kilongu sa bandu bingi. ");
INSERT INTO mgv_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ndienu bandu bajatumbuli kwaagu Sapanga ndi bajwaakemiki, na bajwaakemiki haba ndi bajwaahengiki kuba baamboni palongi jaki na bajwaahengiki kuba baamboni palongi jaki haba ndi bajwaapeki ulumbi waki. ");
INSERT INTO mgv_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Henu kupete haga tupwaga kii ngane? Ana Sapanga jubii upandi witu nya jojwibia jukutupenga? ");
INSERT INTO mgv_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Sapanga ngaseambonila ikia hata Mwana waki wakajika ila ampia ndaba jitu twepani twaboka. Jwiisindwa boo, kutupeke sindu sengi sokapi bwaka ana tubi pamu najombe? ");
INSERT INTO mgv_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nyaa jojiwesa kwaatemu bandu baahaguliwi na Sapanga? Sapanga mweni ndi jojutulekake mahakau. ");
INSERT INTO mgv_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Henu nya jojwaatemula? Ngasejubii. Ndaba Yesu Kilisitu ndi jojuwii kabee jwayoka kuhuma kwa bandu baawii na jutama upandi wa malele waka Sapanga. Jombi ndi jojututulobe! ");
INSERT INTO mgv_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nya jojuwesa kututenga nu upali waka Kilisitu? Boo shida lena au tabu au mang'aliku au inzala au kukosa ingobo atali au kuwa? ");
INSERT INTO mgv_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ngati maandiku gaka Sapanga hegapwaga, “Ndaba jaku tukuba mu mang'aliku ga kuwa kila lisoba, atubeka ngati makondoo gu kusinzwa.” ");
INSERT INTO mgv_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ngahela, lakini mu majambu goti haga tupatiki kuwesa kukolongu sukutujangati jombi jojutupala. ");
INSERT INTO mgv_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ndaba manya sakaka nga sindu sengi sekiwesa kututenga twepani nu upali waka Sapanga wala kuwa wala womi wala atumi bu kunani wala ilombu au makili gangi gukunani kwaka Sapanga wala gagapitii sajenu wala gagiipitila mweni katai wala aka kilongosi, ");
INSERT INTO mgv_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wala gagabii kunani wala gagabii pai. Wala ngasekibii kiumbi sokapi sekiwesa kututenga nu upali waka Sapanga woubii kupete Bambu witu Yesu Kilisitu. ");
INSERT INTO mgv_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mbwaga sakaka nepani namundu waka Yesu Kilisitu, wala ngase nonge isole na moju wangu gunangi koni nongoswa na Loho jaka Sapanga sakaka ngase nonge isoli. ");
INSERT INTO mgv_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Pamwaga hela niangajika ngamaa mumoju jangu nu ubini nkolongu wanga kukotoka mu moju jango. ");
INSERT INTO mgv_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nndokule hata kupata yaambamba nukubekwa kutali na Kilisitu ndaba ja bandu ajangu ba ndema jangu baabi likabila limu na nepani. ");
INSERT INTO mgv_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Haba ndi bandu buku Isilaheli bajwaagwi Sapanga kuba bana baki, jwaapekia ulumbi waki, jwatenda nabu malaganu, jwaapekia Malagalaki gaki, jwaabola namuna jukugungamali na kwaapeke malagi gaki. ");
INSERT INTO mgv_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Haba ndi asoko baka aka hoku akolongu, babube Kilisitu jwahika koni jubii na nhyega kupete kwabu. Jombi ndi Sapanga jojulongoo majambu goti, juku lumbaliwa yaka petapeta. Amina. ");
INSERT INTO mgv_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ngase mbwaga lilagi laka Sapanga litei kusindwa. Ndaba nga kila jojuhuma ku Izilaeli ndi bandu baka Sapanga. ");
INSERT INTO mgv_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Wala nga kibeleku soka saka Ibulahimu ndi bana baki ba sakaka. Ila ngati hegapwaga Maandiku gaka Sapanga, “Kupete Isaka ndi nakupekia kibeleku bandu bikibeleku saku” ");
INSERT INTO mgv_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ndi kupwaga, nga babana baabelikwi kwa nhyega ndi bana baka Sapanga ila bana bahumi ku lilaganu laka Sapanga ndi bana baka Ibulahimu. ");
INSERT INTO mgv_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ndaba lilaganu le ndi lende, “Niikelabukia kabee kipindi ngati senze na Sala jwiipapa mwana mwanalomi.” ");
INSERT INTO mgv_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Kabee nga hagapee, ila kabee Lebeka najombi jwiipata bana bamapaa kwa atati jumu yaani ahoku bitu a Isaka. ");
INSERT INTO mgv_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ndaba kabula mapaa bala ngaseasaliwi wala ngaseatei lijambu lamboni au lilyaa ili kupala kwaka Sapanga kuwesa kuba nganganganga, ");
INSERT INTO mgv_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Sapanga ampwagila Lebeka mwana jojutumbuli jola jwantumakia mwana jwamwisu. Henu hejuhagu Sapanga kutegamee hejukema mweni, na ngase kutegame mahengu gaka mundu. ");
INSERT INTO mgv_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ngati Maandiku gaka Sapanga hegapwaga, “Numpala Yakobu lakini nunsukia Esau.” ");
INSERT INTO mgv_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Henu tupwaga bole? Sapanga jukosi lee kuhenga gajupala kuhenga? Ngahela! ");
INSERT INTO mgv_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ndaba Sapanga ampwagila Musa, “Nanzangatia mundu jokapi jombala kunzangati, nammbonila ikia mundu jokapi jonumpai.” ");
INSERT INTO mgv_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Henu majambu goka gahobale ikia yaka Sapanga na nga kukasana kwaka mundu au kupala kwaka mundu. ");
INSERT INTO mgv_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ndaba maandiku gaka Sapanga gapwaga ana kwaka Falao, “Nukuhagwi gubia bambu nkolongu uku Misili ili kupete indela jaku, makili gangu gamanyikana punndema pani ni liina langu limanyikana pu nndema poti.” ");
INSERT INTO mgv_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Henu, Sapanga antende ikia joampala kuntende ikia na ana jupai kuntenda mundu jubia niing'omu, jutenda ahelahela. ");
INSERT INTO mgv_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Nhwesa kunaluki, “Ana kubihela enu ndaba jaki Sapanga jwaataki bandu? Ndaba nya jojuwesa kupengana na gajupala jombi?” ");
INSERT INTO mgv_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Lakini, wamundu we ndi wanya mbaka gulenga kusindana na Sapanga? Boo kibega kiwesa kunndaluki jojukibombiki, “Ndaba jaki gumombiki anana.” ");
INSERT INTO mgv_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Jojubomba ibega juwesa kutumi utopi ngati hejupala nu kubomba ibega ibeli kupete utopi agolago, simu kutumalia majambu gini isima na sengi kutumala majambu gakawaida. ");
INSERT INTO mgv_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Hela ndi hekubii kwaka Sapanga. Jwapala kulangi inyela yaki nu kutumanyisa makili gaki. Henu 