﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgq_vpl;
CREATE TABLE mgq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgq_vpl WRITE;
INSERT INTO mgq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ɨga ge mataawa aga shɨkholo sha Yeesu Kilisiti we áfumile mʉ shɨkholo sha mwene uDaudi nu Abulahaamu. ");
INSERT INTO mgq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","UAbulahaamu ámupaapile uIsaaka, uIsaaka ámupaapile ʉYaakobo, ʉYaakobo ámupaapile ʉYʉʉda na bhakhambakʉ bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ɄYʉʉda ámupaapile uPeleesi nʉ Zeela kwa Tamaali. UPeleesi ámupaapile uHezelooni, uHezelooni ámupaapile uLaami, ");
INSERT INTO mgq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","uLaami ámupaapile uAminadaabu, uAminadaabu ámupaapile uNaashoni, uNaashoni ámupaapile uSalimoni, ");
INSERT INTO mgq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","uSalimoni ámupaapile uBoazi kwa Lakhabho, uBoazi ámupaapile uObedi kwa Lʉʉtɨ, uObedi ámupaapile ʉYeese, ");
INSERT INTO mgq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","nʉ Yeese ámupaapile ʉmwene uDaudi. UDaudi ámupaapile uSelemaani kwa mwantanda we áamɨle mʉshɨ wa Uliya. ");
INSERT INTO mgq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","USelemaani ámupaapile uLehoboamu, uLehoboamu ámupaapile uAbiya, uAbiya ámupaapile ʉAsa, ");
INSERT INTO mgq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ʉAsa ámupaapile uYehoshafati, uYehoshafati ámupaapile uYoolamu, uYoolamu ámupaapile uUziiya, ");
INSERT INTO mgq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","uUziiya ámupaapile uYootamu, uYootamu ámupaapile uAhazi, uAhazi ámupaapile uHezekiya, ");
INSERT INTO mgq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","uHezekiya ámupaapile uManaasi, uManaasi ámupaapile uAmoni, nu Amoni ámupaapile uYoosiya. ");
INSERT INTO mgq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","UYoosiya ámupaapile uYekoniya na bhakhambakʉ bhaakwe kʉ khabhalɨlo khe abhantʉ abha ku Babeeli bhábhalemile aBhaisilaeli na kʉbhala nabho mʉ nsɨ yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Khabhɨlɨ we bhasogola mu Babeeli, uYekoniya ámupaapile uShealitiyeeli, uShealitiyeeli ámupaapile uZelubabeli, ");
INSERT INTO mgq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","uZelubabeli ámupaapile uAbihuudi, uAbihuudi ámupaapile uEliakimu, uEliakimu ámupaapile uAzooli ");
INSERT INTO mgq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","uAzooli ámupaapile uSadoki, uSadoki ámupaapile uAkimu, uAkimu ámupaapile uEliyuudi, ");
INSERT INTO mgq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","uEliyuudi ámupaapile uEliazali, uEliazali ámupaapile uMaatani, nu Maatani ámupaapile ʉYaakobo. ");
INSERT INTO mgq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ɄYaakobo ámupaapile uYoosefu ʉmʉlʉme wa Maliya, unyina wa Yeesu, we ɨtaawa lyakwe wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pe kufuma kwa Abulahaamu paka kufikha kwa mwene uDaudi kwámɨle ni vipaafi ishumi na vini. Khabhɨlɨ kufuma kwa Daudi paka kufikha mʉ khabhalɨlo khe abhantʉ abha ku Babeeli bhábhasamwizye aBhaisilaeli mʉ nsɨ yaabho, kwámɨle ni vipaafi ishumi na vini. Khabhɨlɨ kufuma mʉ khabhalɨlo khe bhábhasamwizye paka kufikha kʉpaapwa kwa Kilisiti, kwámɨle ni vipaafi ishumi na vini. ");
INSERT INTO mgq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kʉpaapwa kwa Yeesu Kilisiti kwámɨle anziishi: uMaliya unyina waakwe ázinjiliilwe nu Yoosefu. Ɨleelo we bhashɨɨlɨ kwegana, uMaliya akhalolekha kʉtɨ alɨ pa wumwamu, we áwaajile kʉ makha ga Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ɨleelo kʉnongwa ye uYoosefu, ʉmʉsakhaala we ámuzinjiiye uMaliya áamɨle mugolosu, atakhanzaga kʉtɨ amʉsʉʉpɨzye uMaliya. Pe akhasɨɨbha kʉtɨ amʉleshe kukwilu. ");
INSERT INTO mgq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","We asɨɨbha zɨnɨɨzyo, ʉkhabhɨzya wa Mwene akhamwɨnzɨla mu njozi. Ʉkhabhɨzya wʉnʉʉyo akhamʉbhʉʉzya akhatɨ, “We Yoosefu, ʉwa shɨkholo sha mwene uDaudi, ʉtogopaje kʉmwega uMaliya, kʉnongwa ye uwumwamu we alɨ nawo awaajile kʉ makha ga Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Akhayɨpaapa ʉmwana ʉmʉsakhaala, ukhayimwita ɨtaawa kʉbha wu Yeesu, kʉnongwa ye akhayɨbhapokha abhantʉ bhaakwe mu mbiibhi zyabho.” ");
INSERT INTO mgq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Zɨnɨɨzyo zyonti zyábhombeshile shɨnɨɨsho ɨnga lɨkwɨle izwi lye ʉMwene álilonjile kwɨ dala ɨlya mukuwi waakwe kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yeenya! Ʉmʉlɨndʉ we atabhalile naalumo nʉ mʉsakhaala, atɨbhe pa wumwamu. Khabhɨlɨ akhayɨpaapa ʉmwana ʉmʉsakhaala! Pe bhakhayimwita ʉmwana wʉnʉʉyo ɨtaawa ɨlya Manweli.” Kwe kʉtɨ, “ɄMʉlʉngʉ alɨ peeka nɨɨtwe.” ");
INSERT INTO mgq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pe uYoosefu we adaamʉkha, akhabhomba anza she ʉkhabhɨzya wa Mwene ámulajiziizye, akhamwega akhabha mʉshɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɨleelo atábhalile naalumo nawo paka we uMaliya akhapaapa ʉmwana ʉmʉsakhaala. Pe uYoosefu akhamwita ʉmwana wʉnʉʉyo ɨtaawa ɨlya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","UYeesu ápapiilwe mʉ nhaaya ɨya ku Beteleheemu, mʉ mʉkoa ʉwa Yudeeya, mʉ khabhalɨlo khe uHeloodi áamɨle wʉ mwene. Abhamanyi abhɨ nzota kufuma kuwutukulo bhakhɨnza mʉ nhaaya ɨya mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bhakhabhʉzɨɨlɨzya bhakhatɨ, “Alɨ kwoshi we apapiilwe kʉbha wʉ Mwene ʉwa Bhayahuudi? Tumanyile kʉtɨ apapiilwe, kʉnongwa ye tuyilolile ɨnzota yaakwe kuwutukulo ye yɨkʉlolesya kʉpaapwa kwakwe. Nɨɨtwe twinzile kumupuuta.” ");
INSERT INTO mgq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ʉmwene uHeloodi we ayɨmvwa zɨnɨɨzyo, akhazyʉgʉnhana peeka na bhantʉ bhonti abha mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pe akhabhabhʉngaanɨkha abhapɨtɨ bhonti abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo zya Moose, akhabhabhʉzɨɨlɨzya akhatɨ, “UKilisiti akhayɨpaapwa kwoshi?” ");
INSERT INTO mgq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhoope bhakhamwamʉla bhakhatɨ, “Akhayɨpaapwa mu Beteleheemu, ɨya mu Yudeeya. Kʉnongwa ye shɨnɨɨsho she umukuwi ásimbile amazwi ga Mʉlʉngʉ kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ɨwe Beteleheemu mʉ nsɨ ɨya Yʉʉda, we mʉpɨtɨ mʉ bhapɨtɨ abha mʉ Yʉʉda, kʉnongwa ye mʉmwakho akhayifuma ʉmʉpɨtɨ, we akhayibhadiima abhantʉ bhaanɨ aBhaisilaeli.’” ");
INSERT INTO mgq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pe uHeloodi akhabhabhɨlɨshɨla abhamanyi abhɨ nzota bhaala kukwilu ɨnga amanye uwanalyoli akhabhalɨlo khe ɨnzota yiila yáloleshile. ");
INSERT INTO mgq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pe akhabhasonteelezya mu Beteleheemu, akhabhabhʉʉzya akhatɨ, “Bhalaji mupiminhanye akhinza mʉmanye pe ʉmwana wʉnʉʉyo alɨ. Ɨnga mwamwaga, mwɨnze mʉmbʉʉzye nalʉbhɨlo ɨnga nɨɨne ɨmbale kumupuuta.” ");
INSERT INTO mgq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","We abhamanyi bhaala abhɨ nzota bhɨmvwa amazwi ga mwene, bhakhasogola. Ɨnzota yiila ye bhakhayɨlolaga kuwutukulo, yɨkhabhalongolela kwɨlongolela yaabho, yɨkhabhala yɨkhɨmɨɨlɨla pamwanya pe ʉmwana áamɨle. ");
INSERT INTO mgq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","We bhayɨlola ɨnzota yiila, bhakhaseshela nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pe bhakhinjila mu nyumba, bhakhamʉlola ʉmwana alɨ nu nyina waakwe uMaliya, bhakhasʉgamɨla papaakwe, bhakhamupuuta ʉmwana. Bhakhasatʉla imbuguuli zyabho, bhakhamufumwizya insupo izyi zahaabu, uwuvumba, na mafuta ge gakununshiilila. ");
INSERT INTO mgq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","We ʉMʉlʉngʉ abhasokha mu njozi kʉtɨ bhatakhasheele kʉgalʉkha winza kwa Heloodi, bhakhaselenga kʉshɨlɨla ɨdala ilinji kʉbhala kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","We abhamanyi abhɨ nzota bhaala bhasogola, ʉkhabhɨzya wa Mwene akhamʉloleshela uYoosefu mu njozi, akhamʉbhʉʉzya akhatɨ, “Daamʉkha, ʉmweje ʉmwana nu nyina waakwe, ʉshɨmbɨɨlɨle ku Miisili. Mwɨkhale kʉnʉʉkwo kufishila pe ɨnhayɨkʉbhʉʉzya, kʉnongwa ye uHeloodi atɨmwanze ʉmwana kʉtɨ amʉgoje.” ");
INSERT INTO mgq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pe uYoosefu akhadaamʉkha, akhamwega ʉmwana peeka nu nyina waakwe uwusiku, akhashɨmbɨla, akhabhala ku Miisili. ");
INSERT INTO mgq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akhɨɨkhala kukuula paka we uHeloodi aafwa. Shɨnɨɨsho she izwi lyákwɨlɨɨye lye ʉMwene álonjile kwɨ dala ɨlya mukuwi kʉtɨ, “Námʉbhɨlɨshɨɨye ʉmwana waanɨ asogole mu Miisili.” ");
INSERT INTO mgq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","We uHeloodi aamanya kʉtɨ abhamanyi abhɨ nzota bhaala bhamʉkhopeeye, akhaviitwa nhaani. Pe akhalajɨzya kʉtɨ bhabhagoje abhaana abhasakhaala bhonti kwandɨla abheela kufishila abhaana abha manha gabhɨlɨ, mu Beteleheemu na mʉmbalɨ zyonti. Ábhombile shɨnɨɨsho kʉlandatana na khabhalɨlo khaala khe abhamanyi abhɨ nzota bhámubhuziizye. ");
INSERT INTO mgq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Shɨnɨɨsho she lyákwɨlɨɨye izwi lye lyálonjiilwe nu mukuwi uYelemiya kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Izi lyávwinshile mʉ nhaaya ɨya mʉ Laama, kʉlɨla na kuzinda nhaani. ULaheli akʉlɨla kʉnongwa ya bhaana bhaakwe, atakwɨtɨkha we bhakʉmʉpʉmɨɨlɨzya, kʉnongwa ye abhaana bhaakwe bhatalɨɨpo.” ");
INSERT INTO mgq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","We uHeloodi aafwa, ʉkhabhɨzya wa Mwene ʉMʉlʉngʉ akhamʉloleshela uYoosefu winza mu njozi ku Miisili, ");
INSERT INTO mgq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akhamʉbhʉʉzya akhatɨ, “Daamʉkha, ʉmweje ʉmwana nu nyina waakwe, ʉgalʉshe mʉ nsɨ ɨya mu Isilaeli kʉnongwa ye bhaala bhe bhanzaga kʉmʉgoga ʉmwana bhafuuye.” ");
INSERT INTO mgq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pe uYoosefu akhadaamʉkha, akhamwega ʉmwana nu nyina waakwe, bhakhasogola, bhakhagalʉkha mʉ nsɨ ɨya mu Isilaeli. ");
INSERT INTO mgq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɨleelo we ayɨmvwa kʉtɨ uAlikelao akʉtabhaala mu Yudeeya, apwanɨɨye pa yise waakwe uHeloodi, akhoogopa kʉbhala kuula. Woope we insoshi zyamwɨnzɨla mu njozi, akhasogola kʉbhala mʉ mʉkoa ʉwa Galɨlaaya, ");
INSERT INTO mgq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akhabhala kwɨkhala mʉ nhaaya ɨya mu Naazaleti. Shɨnɨɨsho she lyákwɨlɨɨye izwi lye lyálonjiilwe kwɨ dala ɨlya bhakuwi kʉtɨ, “Bhakhayɨmʉbhɨlɨshɨlaga kʉtɨ Munaazaleti.” ");
INSERT INTO mgq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu nsiku ziila we uYeesu alɨ ku Naazaleti áfumiiye uYookhani uMwozyi akhalʉmbɨlɨlaga mu shilozu ɨsha mu Yudeeya. Akhabhabhʉzyaga abhantʉ akhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Laataji imbiibhi zyinyu, kʉnongwa ye ʉwʉmwene ʉwa kʉmwanya wʉpalamɨɨye!” ");
INSERT INTO mgq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","UYookhani wʉnʉʉyo we umukuwi ʉYeesaya akhamʉtekhaga kʉtɨ, “Umuntu akʉkhoola mu shilozu akʉtɨ, ‘Linganyaaji ɨdala lya Mwene, golosyaji ɨdala lye atɨshɨle.’” ");
INSERT INTO mgq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","UYookhani akhakwataga ʉmwenda we bhátabhɨɨye amasepe agɨ ngamɨla, akhayipinyaga nɨ lambɨ ɨlyɨ gwembe mʉ mʉsana waakwe. Ishaakulya shaakwe sháamɨle mpʉlaala nu wooshi ʉwa mwɨ sengo. ");
INSERT INTO mgq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abhantʉ abhinji bhakhabhalaga kʉmʉtejeelezya kufuma mʉ nhaaya ɨya mu Yelusaleemu, mʉ nsɨ yonti ɨya mu Yudeeya na mʉmbalɨ zyonti ɨzya mu lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhakhalaataga imbiibhi zyabho, woope akhabhozyaga mu lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ɨleelo we uYookhani aalola aBhafalisaayi na Bhasadukaayi abhinji bhakʉmwɨnzɨla ku winji kwe akhozyaga, akhabhabhʉzyaga akhatɨnjɨ, “Ɨmwe mʉbhaana bhɨ njokha! Wu naanu we abhasoshile kʉtɨ mʉwʉshɨmbɨle ʉmʉlakha wa Mʉlʉngʉ we wʉkwɨnza? ");
INSERT INTO mgq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ishi bhombaji ɨmbombo inyinza zye zɨkʉlolesya kʉtɨ mulaatile imbiibhi zyinyu zyonti, anzi kwi lye lɨkwela amatunda aminza. ");
INSERT INTO mgq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mʉtayɨbaadaje kʉtɨ, ‘Ʉmaama wɨɨtʉ wu Abulahaamu!’ Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, ʉMʉlʉngʉ angakhola kuumupa uAbulahaamu abhazʉkʉlʉ kufuma mʉ mawe ɨga! ");
INSERT INTO mgq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ɄMʉlʉngʉ alinganyiinye ulufundo kʉ bhe bhatalaatile, anzu muntu we alemile intemu akwanza kudiba amazi aga makwi. Ikwi lyolyonti lye lɨtakwela amatunda aminza, atɨlɨtʉʉlɨle na kʉlɨsʉmba mʉ mwoto. ");
INSERT INTO mgq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨne ɨnkʉbhoozya ku minzi kʉlolesya kʉtɨ mulaatile imbiibhi zyinyu. Ɨleelo we atɨlandate papaanɨ alɨ na makha kʉnshɨla ɨne. Khabhɨlɨ ɨntakhondeeye poope kʉpɨmba ɨndaala zyakwe. Ʉweene, we akhayɨbhoozya kwa Mupepu uMufinjile na kʉ mwoto. ");
INSERT INTO mgq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ʉweene akhayɨbhagabhʉlanya abhagolosu na bhabhomba mbiibhi, ngatɨ muntu we akʉkhoma na kʉpementa ɨngano pa shikhomelwi, akʉbhʉngaanɨkha ɨngano na kʉbhɨɨkha mʉ shanga, ɨleelo amampunyunzi akʉpembeelela nʉ mwoto we wutakuzima.” ");
INSERT INTO mgq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pe mʉ khabhalɨlo khanaakho, uYeesu áfumile mʉ Galɨlaaya, akhɨnza kwa Yookhani uMwozyi, ku lwizi ʉlwa Yoolodani ɨnga uYookhani amwozye. ");
INSERT INTO mgq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ɨleelo uYookhani akhalɨnjɨzya kusiita, akhatɨ, “Ɨne ne ɨnkwanzɨwa kwozelwa nɨɨwe, zɨngabha bhʉlɨɨbhʉlɨ kʉtɨ ɨwe ʉyɨnze kʉkwanɨ?” ");
INSERT INTO mgq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ɨleelo uYeesu akhamwamʉla akhatɨ, “Yɨɨtɨkha kʉnoozya akhabhalɨlo ɨkha, kʉnongwa ye tʉkwanzɨwa kʉkwɨlɨzya uwugolosu wonti pamiiso ga Mʉlʉngʉ.” Pe uYookhani akhɨɨtɨkha kʉmwozya. ");
INSERT INTO mgq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","We uYeesu ayoozelwa, akhafuma lyeka bhʉʉlo mu minzi, kʉmwanya kukhiigukha, akhamʉlola uMupepu wa Mʉlʉngʉ akwikha ngatɨ nkʉnda, akhagwa pamwanya papaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe izi lya Mʉlʉngʉ kufuma kʉmwanya lɨkhavwɨnha lɨkʉtɨ, “Ʉnʉ we Mwana waanɨ ʉmʉganwa, we ɨnkʉmʉseshela.” ");
INSERT INTO mgq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pe panaapo uYeesu akhalongolwa nu Mupepu uMufinjile kʉbhala mu shilozu ɨnga uSeetani amʉlɨnje. ");
INSERT INTO mgq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","UYeesu áyiimile kulya insiku amashumi gani shawusiku na shamʉsanya. Kʉwʉmalɨlɨshɨlo, ɨnzala yikhamuluma. ");
INSERT INTO mgq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe uSeetani akhɨnza kʉmʉlɨnga akhatɨ, “Ɨnga ɨwe we Mwana wa Mʉlʉngʉ, gabhʉʉzye amawe ɨga gagalʉnhane gabhe makaati.” ");
INSERT INTO mgq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","UYeesu akhamwamʉla akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ʉwʉpʉʉma wa muntu wutakufumilana ni shaakulya sheene, lyoli wukufumilana ni zwi lyolyonti lye likufuma mwi lomu lya Mʉlʉngʉ.’” ");
INSERT INTO mgq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pe uSeetani akhamʉtwala uYeesu kʉ nhaaya imfinjile iYelusaleemu, akhamwɨmɨɨlɨsya pa ndʉngo iyi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Akhamʉbhʉʉzya akhatɨ, “Ɨnga ɨwe we Mwana wa Mʉlʉngʉ, yɨsʉmbe paasɨ kufuma panaapa. Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘ɄMʉlʉngʉ atɨbhasonteelezye abhakhabhɨzya bhaakwe bhatɨkʉtone mʉ nyoobhe zyabho, ɨnga ɨvɨnama vwakho vɨtakhakhomele mʉ mawe.’” ");
INSERT INTO mgq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ɨleelo uYeesu akhatɨ, “Iwinza yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ʉtamʉlɨngaje ʉMwene ʉMʉlʉngʉ waakho.’” ");
INSERT INTO mgq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pe uSeetani akhamʉtwala uYeesu pamwanya pɨ gamba itali, akhamʉlanga ʉwʉmwene ʉwa mʉ nsɨ zyonti nɨ togo lyakwe. ");
INSERT INTO mgq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Akhamʉbhʉʉzya akhatɨ, “Ɨnga wansʉgamɨlɨla na kumpuuta, vwonti viniivi intiikupe.” ");
INSERT INTO mgq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","UYeesu akhatɨ, “Yeepa ɨpa, Seetani! Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Umupuutaje ʉMwene ʉMʉlʉngʉ waakho, khabhɨlɨ ʉmʉbhombelaje wʉʉyo mwene.’” ");
INSERT INTO mgq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pe uSeetani akhamʉlekha uYeesu, abhakhabhɨzya bha Mʉlʉngʉ bhakhɨnza kʉmʉsʉnga. ");
INSERT INTO mgq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","UYeesu we ayɨmvwa kʉtɨ uYookhani uMwozyi akungiilwe mwɨ jeela, akhagalʉkha kʉ Galɨlaaya. We alɨ mʉ Galɨlaaya, akhabhala suuti ku Naazaleti. ");
INSERT INTO mgq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pe akhasogola mu Naazaleti, akhabhala kwɨkhala mu Kapelenaumu, ɨnhaaya ye yáamɨle mʉmbalɨ mwa sʉmbɨ ʉwa Galɨlaaya, mʉ mɨkoa ɨya Zabulooni ni Nafutaali. ");
INSERT INTO mgq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Zyábhombeshile shɨnɨɨsho ɨnga lɨkwɨle izwi lye umukuwi ʉYeesaya álonjile kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ɨnsɨ ɨya Zabulooni nɨ ya Nafutaali, zɨlɨ kwɨ dala ɨlya kʉbhala kwa sʉmbɨ, kwɨsyɨla ɨlya lwizi ʉlwa Yoolodani, ɨGalɨlaaya, ɨnsɨ ye bhakwɨkhala bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abhantʉ bhaala bhe bhakwɨkhala mu khiisi akhi mbiibhi, bhalʉlola ʉlʉkhozyo ʉlʉpɨtɨ, khabhɨlɨ bhe bhakwɨkhala mʉ nsɨ, na mu khanzundila akha wufwe, ʉlʉkhozyo lubhalamiziizye.” ");
INSERT INTO mgq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kufuma akhabhalɨlo khanaakho, uYeesu akhanda kʉlʉmbɨɨlɨla akhatɨnjɨ, “Laataji imbiibhi zyinyu, kʉnongwa ye ʉwʉmwene ʉwa kʉmwanya wʉpalamɨɨye!” ");
INSERT INTO mgq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","We uYeesu akʉshɨla mʉmbalɨ mwa sʉmbɨ ʉwa Galɨlaaya, akhabhalola abhaana muntu bhabhɨlɨ abhazʉbhʉla nswi, uSiimoni we ɨtaawa ɨlyamwabho bhakhatɨnjɨ wu Peeteli nʉ khambakʉ waakwe ʉAndeleeya. Bhanaabho bhabhɨlɨ bhakhazʉbhʉlaga inswi nu waavu mwa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","UYeesu akhabhabhʉʉzya akhatɨ, “Ndandataje, te mʉjendeelele kʉzʉbhʉla inswi, lyoli ɨntɨbhabhɨɨshe kʉtɨ mʉzʉbhʉlaje abhantʉ na kʉbhaleeta kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Panaapo bhʉʉlo, bhakhazɨlekha inyaavu zyabho, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","We uYeesu aabhala pɨlongolela, akhabhalola abhavʉlɨ bha Zebedaayo, ʉYaakobo nʉ wamwabho uYookhani, peeka nu yise waabho bhalɨ mʉ shɨtʉʉlɨ, bhakhazɨlɨnganyaaga inyaavu zyabho. UYeesu akhabhabhɨlɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Panaapo bhʉʉlo, bhakhashɨlekha ɨshɨtʉʉlɨ nu yise waabho, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","UYeesu akhazyʉngʉʉlaga mʉ nsɨ yonti ɨya Galɨlaaya. Akhamanyɨzyaga abhantʉ mu masinagoogi gaabho, akhalʉmbɨlɨlaga iNtumi iNyinza ɨzya wʉmwene ʉwa kʉmwanya na kʉbhaponɨa abhantʉ ɨmpʉngo zyonti nʉ wʉtolwe nʉʉwo nʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Intumi zyakwe zɨkhasaata mʉ nsɨ yonti ɨya mu Siiliya. Bhoope abhantʉ bhakhamʉleetela abhabhinu bhonti bhe bhakʉyɨmba nɨ mpʉngo ɨzya vɨkholo nɨ vɨkholo, na bhe bháamɨle na mavune. Mʉ bhanaabho, bhálɨɨpo bhe bháamɨle na mapepu amabhiibhi na bhe bháamɨle ni vizilisi na bhe bháfuuye kʉndwɨmo. UYeesu akhabhaponɨa. ");
INSERT INTO mgq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Khabhɨlɨ ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakhamʉlandata kufuma mʉ nsɨ ɨya Galɨlaaya, mʉ nhaaya ɨzya Dekapooli, mʉ nhaaya ɨya Yelusaleemu, mʉ nsɨ ɨya Yudeeya na mwɨ syɨla ɨya lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","UYeesu we aalola ɨmpʉga yiila ɨya bhantʉ, akhazʉbha mwɨ gamba, akhɨɨkhala paasɨ. Pe abhalandati bhaakwe bhakhɨnza kʉkwakwe, ");
INSERT INTO mgq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","akhanda kʉbhamanyɨzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhasayiilwe bhe bhapɨɨna mʉ mwoyo, kʉnongwa ye ʉwʉmwene ʉwa kʉmwanya waabho. ");
INSERT INTO mgq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bhasayiilwe bhe bhalɨ nu wuswimiilizu, kʉnongwa ye bhanaabho ʉMʉlʉngʉ akhayibhajinjizya. ");
INSERT INTO mgq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bhasayiilwe bhe bhatonsu, kʉnongwa ye bhakhayɨpwanɨla ɨnsɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bhasayiilwe bhe bhalɨ nɨ nzala nɨ shʉʉmɨlwa ɨsha wugolosu, kʉnongwa ye bhanaabho ʉMʉlʉngʉ akhayibhiikusya. ");
INSERT INTO mgq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bhasayiilwe bhe bhalɨ ni shisa, kʉnongwa ye bhoope ʉMʉlʉngʉ akhayɨbhalolela ishisa. ");
INSERT INTO mgq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bhasayiilwe bhe bhalɨ nʉ mwoyo umuzelu, kʉnongwa ye bhakhayɨmʉlola ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bhasayiilwe bhe bhakwɨmvwanya abhantʉ, kʉnongwa ye bhakhayɨbhɨlɨshɨlwa kʉbha bhaana bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhasayiilwe bhe bhakʉyɨmba kʉnongwa ya wugolosu, kʉnongwa ye ʉwʉmwene ʉwa kʉmwanya waabho. ");
INSERT INTO mgq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Musayiilwe ɨmwe mwe abhantʉ bhakubhaliga, kʉbhayɨmvwa na kʉbhalonjela imbiibhi nɨɨzyo nɨɨzyo kʉnongwa yaanɨ. ");
INSERT INTO mgq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Seshelaji na kushimwa, kʉnongwa ye ʉMʉlʉngʉ akhayɨbhaposheelezya ku winji kʉmwanya, kʉnongwa ye shɨnɨɨsho she bhakhabhayɨmvwaga abhakuwi bhe bhátalile palʉsalo yiinyu. ");
INSERT INTO mgq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ɨmwe mwe lɨbheeya lya mʉ nsɨ! Ɨleelo ɨbheeya ɨnga lyateezya uwunonu, bhʉlɨ lɨngalʉngwa khantʉ khooni akha kʉlɨbhɨɨkha kʉtɨ lyande kʉkhola winza? Lɨtakʉbha nɨ mbombo winza, lyoli lɨkʉbha lya kʉtaaga kunzi, na kʉkhanywa na bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ɨmwe mwe lʉkhozyo lwa mʉ nsɨ! Ɨnhaaya ye yizenjiilwe pamwanya pɨ gamba, yɨtangʉʉbha. ");
INSERT INTO mgq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Khabhɨlɨ abhantʉ bhatakʉkholeelezya ɨtaala na kugubishila mʉ nsonta, lyoli bhakʉlɨbhɨɨkha pa shɨmbeeje ɨnga lɨbhakhozezye bhonti bhe bhalɨ mu nyumba. ");
INSERT INTO mgq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Shɨnɨɨsho ʉlʉkhozyo lwinyu, lʉkwanzɨwa lʉkhozyaje kʉ bhantʉ ɨnga bhazɨlolaje ɨnjendo zyinyu inyinza, na kʉmʉpaala ʉTaata wiinyu we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mʉtakhasheele kʉtɨ ininzile kwefwa ɨndajɨzyo zya Moose, awe zye zɨkhalongwaga na bhakuwi. Intínzile kwefwa, lyoli kʉkwɨlɨzya. ");
INSERT INTO mgq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kwe kʉtɨ, nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, kufishila mʉ khabhalɨlo khe kʉmwanya na paasɨ vɨkhayɨshɨla, wʉtalɨɨpo uwusimbe wushe ʉwɨ ndajɨzyo we wʉkhayɨshɨla kufishila pe zyonti zɨkhayɨkwɨla. ");
INSERT INTO mgq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Umuntu wowonti we atakuyitinikha ɨndajɨzyo ye nyinsi kʉshɨla zyonti, na kʉbhamanyɨzya abhanjɨ kʉtɨ bhoope bhatazitinikhaje, wʉnʉʉyo, akhayɨbha munsi nhaani mʉ wʉmwene ʉwa kʉmwanya. Ɨleelo wowonti we akʉzɨbhomba na kʉbhamanyɨzya abhanjɨ, wʉnʉʉyo akhayɨbha mʉpɨtɨ mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ye nongwa ɨnkʉbhabhʉʉzya kʉtɨ, ɨnga uwugolosu wiinyu wʉtakʉshɨla ʉwa Bhafalisaayi nʉ wa bhamanyizyi abhɨ ndajɨzyo zya Moose, te mukhinjile naalumo mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwimvwizye kʉtɨ abhantʉ abhɨ maandɨ bhábhabhuziizye kʉtɨ, ‘Ʉtakhaagoje, nu muntu we aagoga akhondeeye kʉlongwa.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we akumuviitilwa ʉwamwabho, akhondeeye kʉlongwa. Khabhɨlɨ wowonti we akumuliga ʉwamwabho kʉtɨ, ‘We mʉlema,’ akhondeeye kʉsɨtaakwa kwɨ balaaza. Khabhɨlɨ wowonti we akʉmʉbhʉʉzya ʉwamwabho kʉtɨ, ‘We mʉlema,’ akhondeeye kwinjila mʉ mwoto we wutakuzima naalumo! ");
INSERT INTO mgq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pe shɨnɨɨsho, ɨnga ukufumwa imfinjile yaakho kʉ shɨgemo, ɨleelo wakʉmbʉkha kʉtɨ unanjile zimo kwa wamwinyu, ");
INSERT INTO mgq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yɨleshe imfinjile yɨnɨɨyo pɨlongolela pa shɨgemo, bhalaga ʉyɨmvwane suuti nu wamwinyu. Ɨngaleelo ʉyɨnze kufumwa imfinjile yaakho. ");
INSERT INTO mgq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ɨnga umuntu akusitaakile, akʉkʉtwala kwɨ balaaza, yɨmvwana nawo nalʉbhɨlo she mʉlɨ mwɨ dala kʉbhala kwɨ balaaza, ɨnga we akusitaakile atakhakʉbhɨɨshe mʉ nyoobhe zya mulonganyi. Woope umulonganyi, atɨkʉbhɨɨshe mʉ nyoobhe zya bhasikaali nɨɨwe ʉsʉmbwe mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nalyoli ɨnkʉkʉbhʉʉzya kʉtɨ, mukaasi ʉmwo te ukhaafume paka we waamala kʉsomba vwonti vwe akʉkwɨsya! ");
INSERT INTO mgq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwimvwizye yálonjiilwe kʉtɨ, ‘Utakhabhembushe.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we amwenya ʉmwantanda kumiiso aga kʉmʉsʉngʉkha, atɨbhe abhembushile nawo mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pe ɨnga ilyiso lyakho ɨlya kʉndɨɨlo lɨkʉkʉpʉvwa kʉbhomba imbiibhi, lifigule na kʉlɨsʉmba ukutali. Kwashi kʉteezya ʉlʉpaaswa lweka mʉ mʉbhɨlɨ waakho, na kʉtɨ ʉmʉbhɨlɨ waakho wonti wʉkhasʉmbwe mʉ mwoto we wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Khabhɨlɨ ɨnga ɨnyoobhe yaakho ɨya kʉndɨɨlo yɨkʉkʉpʉvwa kʉbhomba imbiibhi, yidumule na kʉyɨsʉmba ukutali. Kwashi kʉteezya ʉlʉpaaswa lweka mʉ mʉbhɨlɨ waakho, na kʉtɨ ʉmʉbhɨlɨ waakho wonti wʉkhasʉmbwe mʉ mwoto we wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Khabhɨlɨ mwimvwizye yálonjiilwe kʉtɨ, ‘Umuntu wowonti we akʉmʉtabhʉla ʉmʉshɨ waakwe, amʉpanje ɨkalaata ɨlya kʉmʉlekha.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we akʉmʉtabhʉla ʉmʉshɨ waakwe, ɨnga atamulemile mu wubhembu, ɨleelo ʉmʉshɨ wʉnʉʉyo ayeegwa ukunji, akʉmʉbhɨɨkha kʉbha mubhembu. Khabhɨlɨ wowonti we akʉmwega ʉmwantanda wʉnʉʉyo akʉbhomba wubhembu. ");
INSERT INTO mgq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Khabhɨlɨ mwimvwizye kʉtɨ abhantʉ abhɨ maandɨ bhábhabhuziizye kʉtɨ, ‘Ʉtalapaje ɨlenga. Ɨleelo ʉbhombaje zyonti zye wálapile kwa Mwene.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, mʉtalapaje ngakheeka kwɨ taawa ɨlya kʉmwanya kʉnongwa ye lye lɨtengo lya Mʉlʉngʉ, ");
INSERT INTO mgq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","awe mʉtalapaje kwɨ dala ɨlya kʉyɨtekha ɨnsɨ kʉnongwa ye pe ʉMʉlʉngʉ akʉbhɨɨkha ɨvɨnama vwakwe. Awe mʉtalapaje kʉ nhaaya ɨya Yelusaleemu kʉnongwa ye yɨnɨɨyo nhaaya ya Mwene ʉMʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Khabhɨlɨ ʉtalapaje kwi twe lyakho, kʉnongwa ye ʉtangakhola kʉgalʉlanya ulusisi lweka kʉbha luzelu awe lwilu. ");
INSERT INTO mgq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lyoli amazwi giinyu gabhe ɨnga ‘Nalyoli,’ ‘Nalyoli.’ Awe ɨnga ‘Ndaali,’ ‘Ndaali.’ Ɨleelo zyonti zye zɨkwonjela mʉ zɨnɨɨzyo, zikufuma kwa mʉbhomba mbiibhi uSeetani. ");
INSERT INTO mgq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwimvwizye yálonjiilwe kʉtɨ, ‘Ilyiso ku lyiso ni lyino ku lyino.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, mʉtatabhʉlɨzyaje uwubhiibhi we umuntu abhabhombeeye. Poope ɨnga umuntu akʉkhoma kʉ lʉdɨlɨ ʉlwɨ mbalɨ yeeka, mʉleshe akʉkhome nɨ mbalɨ ɨyamwabho. ");
INSERT INTO mgq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khabhɨlɨ ɨnga umuntu akwanza kʉkʉsɨtaaka kʉtɨ afwʉle inshaati yaakho, mʉleshele afwʉle ni kooti. ");
INSERT INTO mgq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Khabhɨlɨ ɨnga umuntu akukubijila kʉpɨmba umuzigo waakwe ikilomiita yeeka, ʉpɨmbe umuzigo wʉnʉʉwo ikilomiita zɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Khabhɨlɨ ɨnga umuntu akʉkʉlaabha akhantʉ, ʉmʉpanje. Khabhɨlɨ ɨnga umuntu we akwanza kʉpabha kʉkwakho, utakhamwime. ");
INSERT INTO mgq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwimvwizye yálonjiilwe kʉtɨ, ‘Ʉmʉgane uwamwinyu, ɨleelo umuviitilwe ʉmʉlʉgʉ waakho.’ ");
INSERT INTO mgq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, mʉbhaganaje abhalʉgʉ bhiinyu. Khabhɨlɨ mubhaputilaje bhe bhakʉbhayɨmvwa. ");
INSERT INTO mgq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Panaapo pe mʉtɨbhe mwe bhaana bha Taata wiinyu we alɨ kʉmwanya. Kʉnongwa ye ʉweene akʉbhalamɨzya ɨzʉbha lyakwe abhantʉ abhabhiibhi na bhinza. Khabhɨlɨ akʉtonyezya imvula kʉ bhe bhagolosu na kʉ bhe te bhagolosu. ");
INSERT INTO mgq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ɨnga mʉkʉbhagana bhe bhabhaganile bheene, mʉkhayɨposheela akhooni? Bhʉlɨ, bhoope abhasonshezya nsonho bhatakʉbhomba shɨnɨɨsho? ");
INSERT INTO mgq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Khabhɨlɨ ɨnga mʉkʉbhalamʉkha abhanholo bhiinyu bheene, mʉtɨbhe mʉkʉbhomba lyoni ɨlya kʉshɨla? Bhʉlɨ, bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ bhatakʉbhomba anza shɨnɨɨsho? ");
INSERT INTO mgq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pe shɨnɨɨsho mʉbhe mwe bhagolosu anza she ʉTaata wiinyu we alɨ kʉmwanya mugolosu.” ");
INSERT INTO mgq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mʉbhe amiiso, mʉtabhombaje uwinza wiinyu pa bhantʉ ɨnga bhabhalole. Ɨnga mʉkʉbhomba shɨnɨɨsho, te mʉkhaposheele naakhamu kufuma kwa Taata wiinyu we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pe shɨnɨɨsho, akhabhalɨlo khe mʉkʉbhaavwa abhapɨɨna, mʉtayɨvwɨnsyaje anza she abhi shisa ɨshɨ lenga bhakʉbhomba mu masinagoogi na mʉ madala ɨnga abhantʉ bhabhapaale. Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, bhanaabho bhaposheleeye insupo yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ɨleelo ɨwe we ʉkʉbhaavwa abhapɨɨna, ɨnyoobhe yaakho ɨya kʉmongo yɨtamanyaje zye ɨnyoobhe yaakho ɨya kʉndɨɨlo yɨkʉbhomba, ");
INSERT INTO mgq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ɨnga kwavwa kwakho kʉbhe kwa kukwilu, woope ʉTaata waakho we akʉlola zye zɨkʉbhombekha kukwilu, atɨkʉposheelezye. ");
INSERT INTO mgq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Akhabhalɨlo khe mukupuuta mʉtabhanje anza bhi shisa ɨshɨ lenga. Abheene bhayiganile kupuuta ʉwɨmɨɨlɨla mu masinagoogi na mʉ madala amalenhaana, ɨnga abhantʉ bhabhalole. Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, bhaposheleeye insupo yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɨleelo ɨwe we ukupuuta, yinjila ku lupitu ʉlwa mukaasi mu nyumba yaakho na kwɨgalɨla ʉmʉlyango waakho. Pe upuute kwa Taata waakho we atakʉlolekha apazelu. Pe ʉTaata waakho we akʉlola zye zɨkʉbhombekha kukwilu, atɨkʉposheelezye. ");
INSERT INTO mgq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ɨmwe we mukupuuta, mʉtagalʉshɨlaje zyeka zɨɨzyo anza she bhakʉbhomba bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ. Abheene bhakʉsɨɨbha kʉtɨ ʉMʉlʉngʉ waabho atɨbhɨmvwe kʉnongwa ya mazwi gaabho aminji. ");
INSERT INTO mgq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mʉtabhanje anza bheene, kʉnongwa ye ʉTaata wiinyu amanyile vwe mubhuliliilwe poope we mʉshɨɨlɨ kʉmʉlaabha. ");
INSERT INTO mgq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Pe ɨmwe mupuutaje mʉtɨnjɨ, ‘We Taata wɨɨtʉ ʉwa kʉmwanya, ɨtaawa lyakho lɨpalwaje. ");
INSERT INTO mgq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ʉwʉmwene waakho wɨnze. Ɨshɨgane shaakho shɨbhombekhaje mʉ nsɨ umu, anza she zɨkʉbhombekha kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ʉtʉpanje ishaakulya shɨɨtʉ insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ʉtʉtʉʉyɨle imbiibhi zyɨtʉ, anza she nɨɨtwe tʉkʉbhatʉʉyɨla bhe bhakʉtʉbhombela amabhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ʉtʉlongolaje ɨnga tutakhinjile mʉ ndɨngo, lyoli ʉtʉposhe kwa mʉbhomba mbiibhi uSeetani.’ Kʉnongwa ye ʉwʉmwene waakho, na makha, nu wumwamu, wiila na wiila. Zɨbhe shɨnɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ɨnga mʉkʉbhatʉʉyɨla abhantʉ imbiibhi zyabho, uYise wiinyu ʉwa kʉmwanya woope atɨbhatʉʉyɨle imbiibhi zyinyu. ");
INSERT INTO mgq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ɨleelo ɨnga mʉtakʉbhatʉʉyɨla abhantʉ, woope uYise wiinyu te akhabhatʉʉyɨle. ");
INSERT INTO mgq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“We mukuyiima kulya, mʉtabhombaje anza she abhi shisa ɨshɨ lenga bhakʉlolesya uwuswimiilizu pa vweni vwabho. Abheene bhakuzingaanikha pa vweni vwabho ɨnga abhantʉ bhabhalole kʉtɨ bhayiimile kulya. Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, bhaposheleeye insupo yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ɨleelo ɨwe we ukuyiima kulya, ʉpakhalaje amafuta kwi twe lyakho na kʉgeeza ku sheeni shaakho, ");
INSERT INTO mgq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ɨnga abhantʉ bhatalolaje kʉtɨ uyiimile kulya, lyoli ʉTaata wiinyu we atakʉlolekha apazelu, wʉʉyo mwene we amanyile. Ʉweene we akʉlola zye zɨkʉbhombekha kukwilu, atɨbhaposheelezye. ");
INSERT INTO mgq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mʉtayɨbhɨshɨlaje ɨshʉʉma ishinji mʉ nsɨ umu, mwe umuswa nu musimwa vɨkʉnanganya, na bhiibha bhakʉdobhola na kwibha. ");
INSERT INTO mgq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lyoli mʉyɨbhɨshɨlaje ɨshʉʉma kʉmwanya kwe umuswa nu musimwa vɨtakʉnanganya, na kwe abhiibha bhatakʉdobhola, na kwibha. ");
INSERT INTO mgq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kʉnongwa ye paala pe mubhiishile ɨshʉʉma shiinyu, panaapo pe amooyo giinyu gakhayɨbha. ");
INSERT INTO mgq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Amiiso ge lʉkhozyo lwa mʉbhɨlɨ. Ɨnga amiiso gaakho gakʉlola akhinza, pe ʉmʉbhɨlɨ waakho wonti wʉkʉbha nʉ lʉkhozyo. ");
INSERT INTO mgq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ɨleelo ɨnga amiiso gaakho gafuuye, pe ʉmʉbhɨlɨ waakho wonti wʉkʉbha khiisi. Ɨnga ʉlʉkhozyo lwe lʉlɨ mukaasi yaakho lwabha khiisi, pe akhiisi khakʉbha khapɨtɨ khakwogofwa! ");
INSERT INTO mgq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atalɨɨpo umutumwa we angakhola kʉbhabhombela abhapɨtɨ bhabhɨlɨ kʉ khabhalɨlo kheeka. Kʉnongwa ye atimuviitilwe ʉmʉpɨtɨ weeka na kʉmʉgana uwunji, awe atɨyɨkʉngʉle kwa weeka na kʉmʉshoolanya uwunji. Mʉtangakhola kʉmʉbhombela ʉMʉlʉngʉ ɨnga ɨshʉʉma shɨbhatabhalaaye! ");
INSERT INTO mgq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kʉnongwa yɨnɨɨyo, ɨnkʉbhabhʉʉzya kʉtɨ, mʉteleelaje kʉ zya wɨɨkhalo wiinyu kʉtɨ mutilye akhooni, awe mʉtɨmwele akhooni, awe mʉtɨkwate akhooni. Bhʉlɨ, ʉwɨɨkhalo wutashilile ishaakulya? Bhʉlɨ, ʉmʉbhɨlɨ woope wutashilile amenda? ");
INSERT INTO mgq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Zyenye inyonyi, zɨtakʉwaala awe zɨtakʉsezya awe zitakusengula mʉ shanga, ɨleelo poope shɨnɨɨsho, ʉTaata wiinyu ʉwa kʉmwanya, akʉzɨlɨɨsya. Bhʉlɨ, ɨmwe mʉtakhondeeye nhaani pamiiso ga Mʉlʉngʉ kʉshɨla inyonyi? ");
INSERT INTO mgq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wu naanu mukaasi yiinyu we kweleela kwakwe kʉngonjezya ʉwɨɨkhalo waakwe poope akhabhalɨlo khashe? ");
INSERT INTO mgq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Khooni khe mʉkʉtʉʉya kʉ zya menda? Yeenya ameezya aga mwɨ laala, she gakʉkʉla. Gatakʉbhomba ɨmbombo, awe kʉsona amenda gaabho aga kʉkwata. ");
INSERT INTO mgq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ɨleelo ɨnkʉbhabhʉʉzya kʉtɨ, poope ʉmwene uSelemaani mwɨ togo lyakwe lyonti, atálinjiziizye kʉkwata amenda na kʉkhondezya anzɨ lyezya limo! ");
INSERT INTO mgq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ɄMʉlʉngʉ akʉgakwatɨzya ameezya aga mwɨ laala anza shiniishi poope she gakʉkhondezya kʉ khabhalɨlo khashe bhʉʉlo, ɨndaabhɨ gakwʉma na kʉpembwa. Ɨnga akʉbhomba shɨnɨɨsho kʉ meezya, bhʉlɨ, atangabhakwatɨzya ɨmwe kʉshɨla, mʉbha lwɨtɨkho ʉlwɨ tende? ");
INSERT INTO mgq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Pe shɨnɨɨsho, mʉtatʉʉyaje kʉtɨ, ‘Tutilye akhooni?’ Awe ‘Tʉtɨmwele akhooni?’ Awe ‘Tʉtɨkwate akhooni?’ ");
INSERT INTO mgq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kʉnongwa ye abhantʉ bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ bhakweleela nhaani ni vintu vɨnɨɨvwo. Ɨleelo ɨmwe ʉTaata wiinyu ʉwa kʉmwanya amanyile kʉtɨ mubhuliliilwe vwonti vɨnɨɨvwo. ");
INSERT INTO mgq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lyoli ɨmwe yanzaji suuti ʉwʉmwene wa Mʉlʉngʉ nu wugolosu waakwe, pe vɨnɨɨvwo vwonti atɨbhonjeelezye. ");
INSERT INTO mgq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Pe shɨnɨɨsho, mʉtayɨmbaje kʉ zyɨ ndaabhɨ kʉnongwa ye ɨzyɨ ndaabhɨ zɨkʉyɨyɨmbɨla zɨɨzyo. Imbiibhi izyi siku zɨkʉlɨkwɨla isiku lɨnɨɨlyo.” ");
INSERT INTO mgq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mʉtabhalongaje abhanjɨ pe nɨɨmwe te mʉkhalongwe nʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kʉnongwa ye she mʉkʉbhalonga abhantʉ abhanjɨ, shɨnɨɨsho she ʉMʉlʉngʉ akhayɨbhalonga nɨɨmwe. Ishipimilo she mukubhapimila abhanjɨ, she shɨnɨɨsho ʉMʉlʉngʉ akhayipimila kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Khooni khe ʉkwenya ɨkooko lye lɨlɨ mu lyiso lya wamwinyu, ɨleelo ʉtakʉlola ʉmʉkooko we wʉlɨ mu lyiso lyakho? ");
INSERT INTO mgq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Khabhɨlɨ zɨngabha bhʉlɨɨbhʉlɨ kʉmʉbhʉʉzya uwamwinyu kʉtɨ, ‘Isuuti ɨnkwefwe ɨkooko lye lɨlɨ mu lyiso lyakho,’ ɨleelo ɨwe wʉneewe ʉtakwefwa ʉmʉkooko we wʉlɨ mu lyiso lyakho? ");
INSERT INTO mgq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɨwe ʉlɨ ni shisa ɨshɨ lenga! Yeefwa suuti ʉmʉkooko we wʉlɨ mu lyiso lyakho, pe ʉngakhola kwefwa ɨkooko lye lɨlɨ mu lyiso lya wamwinyu! ");
INSERT INTO mgq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mʉtazɨpanje ɨmbwa ivintu ivifinjile. Khabhɨlɨ mʉtazɨsʉmbɨlaje ɨngʉlʉbhe ivintu vwinyu ɨvwɨ nhela ɨmpɨtɨ. Ɨnga mwazɨsʉmbɨla ivintu ɨvwɨ nhela ɨmpɨtɨ vɨnɨɨvwo, ɨngʉlʉbhe zɨtakhavɨkhanye na kʉbhagalʉshɨla ɨmwe kʉtɨ zibhazepulanye. ");
INSERT INTO mgq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ishi ɨnkʉbhabhʉʉzya kʉtɨ, laabhaji nɨɨmwe mʉtɨposheele, yanzaji nɨɨmwe mʉtɨvwaje, yiguzyaji nɨɨmwe mutiyigulilwe. ");
INSERT INTO mgq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kʉnongwa ye umuntu wowonti we akʉlaabha, akʉposheela, wowonti we akwanza, akʉvwaga, woope we akwiguzya, akwigulilwa. ");
INSERT INTO mgq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Bhʉlɨ, wu naanu mukaasi yiinyu we ɨnga ʉmwana waakwe akʉmʉlaabha ikaati, angaamupa iwe? ");
INSERT INTO mgq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Awe ɨnga akʉmʉlaabha inswi, angaamupa ɨnjokha? ");
INSERT INTO mgq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe shɨnɨɨsho, ɨnga ɨmwe mʉbhabhomba mbiibhi mumanyile kʉʉbhapa abhaana bhiinyu ivintu ivwinza, mʉbhe nu lusimishizyo kʉtɨ ʉTaata wiinyu ʉwa kʉmwanya atɨbhabhombele akhinza nhaani, bhe bhakʉmʉlaabha. ");
INSERT INTO mgq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pe shɨnɨɨsho, zyonti zye mʉkwanza kʉtɨ abhanjɨ bhabhabhombelaje, nɨɨmwe zye mʉbhabhombelaje abhanjɨ. Kʉnongwa ye shɨnɨɨsho she yɨkʉlongwa mʉ ndajɨzyo zya Moose nɨ manyɨzyo zya bhakuwi. ");
INSERT INTO mgq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Yinjilaji kʉshɨlɨla pa mʉlyango ʉmʉnyeela. Kʉnongwa ye ʉmʉlyango we wʉkʉbhala ʉkwa kʉlʉngʉlɨla mʉbaaba nɨ dala lye lɨkʉbhala kʉnʉʉkwo lɨbaaba. Khabhɨlɨ bhinji bhe bhakʉshɨlɨla ʉmʉlyango wʉnʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ɨleelo ʉmʉlyango we wʉkʉbhala ku wuumi mʉnyeela, nɨ dala lye lɨkʉbhala ku wuumi lifinyu. Khabhɨlɨ bhalɨ bhashe bhe bhakʉlɨshɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mʉbhe amiiso na bhakuwi abhɨ lenga, bhe bhakʉbhɨnzɨla, bhakwatile amagwembe agɨ ngoole. Ɨleelo mukaasi yaabho ɨmbwa zya mwɨ laala inhali. ");
INSERT INTO mgq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mʉtɨbhamanye ku matunda gaabho. Bhʉlɨ, abhantʉ bhakʉtʉngʉla amatunda agi zabiibu mʉ nyangwa? Awe bhakʉtʉngʉla amatunda agi tiini mʉ mansʉʉgwa? ");
INSERT INTO mgq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Shɨnɨɨsho, ikwi lyolyonti ilyinza lɨkwela amatunda aminza, ɨleelo ikwi ibhiibhi lɨkwela amatunda amabhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lɨtalɨɨpo ikwi ilyinza lye lɨngakhola kwela amatunda amabhiibhi, khabhɨlɨ lɨtalɨɨpo ikwi ibhiibhi lye lɨngakhola kwela amatunda aminza. ");
INSERT INTO mgq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ikwi lyolyonti lye lɨtakwela amatunda aminza, lɨkʉtʉʉlɨlwa na kʉsʉmbwa mʉ mwoto. ");
INSERT INTO mgq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pe shɨnɨɨsho mʉtɨbhamanye ku matunda gaabho. ");
INSERT INTO mgq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Te muntu wowonti we akʉmbʉʉzya kʉtɨ, ‘Mwene, Mwene,’ akhayinjila kʉ wʉmwene ʉwa kʉmwanya. Lyoli umuntu we akʉbhomba ɨshɨgane sha Taata waanɨ ʉwa kʉmwanya, wʉnʉʉyo we akhayinjila. ");
INSERT INTO mgq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Abhinji bhakhayɨmbʉʉzya isiku liila ɨlya kʉlongwa bhakhayɨtɨ, ‘Mwene, Mwene! Kwɨ taawa lyakho tutafumwaga uwukuwi, kwɨ taawa lyakho tʉtabhɨngaga amapepu amabhiibhi, na kwɨ taawa lyakho tʉtabhombaga amayele aminji?’ ");
INSERT INTO mgq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe ɨnhayɨbhaamʉla apazelu kʉtɨ, ‘Intábhamanyile ɨmwe naalumo! Yeepi kʉkwanɨ, ɨmwe mʉbhabhomba mbiibhi!’ ");
INSERT INTO mgq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pe wowonti we akwɨmvwa amazwi gaanɨ ɨga na kʉgabhomba, akʉkholanywa nu muntu ʉwɨ njeele we ázenjile inyumba yaakwe pɨ lyalaawe. ");
INSERT INTO mgq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Imvula yɨkhatoonya, aminzi gakhiizula, impepu ɨmpɨtɨ yikhavugula na kuyibunshila inyumba yiila. Ɨleelo inyumba yiila yɨtakhagwa kʉnongwa ye ʉlwalo lwakwe lwázenjiilwe pɨ lyalaawe. ");
INSERT INTO mgq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɨleelo wowonti we akwɨmvwa amazwi gaanɨ ɨga, ɨleelo atakʉgabhombela, wʉnʉʉyo akʉkholanywa nu muntu ʉmʉlema we ázenjile inyumba yaakwe pa mʉselesenga. ");
INSERT INTO mgq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Imvula yɨkhatoonya, aminzi gakhiizula, impepu ɨmpɨtɨ yikhavugula na kuyibunshila inyumba yiila, yɨkhagwa ku khashinto akhapɨtɨ!” ");
INSERT INTO mgq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","We uYeesu aamala kʉlonga amazwi ganaago, ɨmpʉga ɨya bhantʉ yikhaswiga nhaani nɨ manyɨzyo zyakwe, ");
INSERT INTO mgq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kʉnongwa ye akhamanyɨzyaga ngatɨ muntu ʉwa waamʉlo, te ngatɨ bhamanyizyi bhaabho abhɨ ndajɨzyo. ");
INSERT INTO mgq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","We uYeesu ayiikha mwɨ gamba, ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakhamʉlandata. ");
INSERT INTO mgq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Umuntu ʉmo ʉwa maketa akhɨnza, akhasʉgamɨla pa vɨnama vwa Yeesu, akhamʉlaabha akhatɨ, “Mwene, ɨnga uyiganile, ʉnsatʉle.” ");
INSERT INTO mgq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","UYeesu akhagolosya ɨnyoobhe yaakwe, akhamʉpalamansya, akhatɨ, “Injiganile kʉtɨ ʉpone, ʉsatʉshe!” Nalʉbhɨlo umuntu ʉla akhasatʉkha amaketa gaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","UYeesu akhamʉbhʉʉzya umuntu ʉla akhatɨ, “Ʉtakhasheele kʉmʉbhʉʉzya umuntu wowonti ʉla ziniizi. Lyoli bhalaga ʉyɨlolesye kwa mupuutili, ʉbhale ufumwe imfinjile ɨzya kʉsatʉlwa kwakho zye ʉMoose álajiziizye, ɨnga abhantʉ bhonti bhazɨlole ɨmbombo zya Mʉlʉngʉ zye abhomba kʉkwakho.” ");
INSERT INTO mgq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","We uYeesu ayinjila mʉ nhaaya ɨya mu Kapelenaumu, ʉmʉpɨtɨ weeka ʉwa bhasikaali akhɨnza kwa Yeesu akhamʉlamba, ");
INSERT INTO mgq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akhatɨ, “We Mwene, umubhombi waanɨ agonile mu nyumba, afuuye kʉndwɨmo, abhinile nhaani.” ");
INSERT INTO mgq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","UYeesu akhamwamʉla akhatɨ, “Ɨntɨyɨnze ɨmʉponɨe.” ");
INSERT INTO mgq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɨleelo ʉmʉpɨtɨ ʉla akhamʉbhʉʉzya akhatɨ, “We Mwene! Ɨntakhondeeye kʉtɨ uyinjile mu nyumba yaanɨ. Ɨleelo ʉlonje izwi lyene, umubhombi waanɨ atɨpone. ");
INSERT INTO mgq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kʉnongwa ye nɨɨne bhʉʉlo ɨndɨ paasɨ pa bhapɨtɨ bhaanɨ. Khabhɨlɨ ɨndɨ na bhasikaali bhe bhalɨ paasɨ papaanɨ. Ɨnga namʉbhʉʉzya weeka natɨ, ‘Bhalaga!’, nalʉbhɨlo akʉbhala. Ɨnga namʉbhʉʉzya ʉwamwabho natɨ, ‘Nzaaga!’, woope akwɨnza. Woope umutumwa waanɨ ɨnga namʉbhʉʉzya natɨ, ‘Bhomba ʉtɨ!’, akʉbhomba shɨnɨɨsho.” ");
INSERT INTO mgq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","We uYeesu ayɨmvwa amazwi ganaago, akhaswiga nhaani, akhabhabhʉʉzya bhe bhakhamʉlandataga akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, mu Bhaisilaeli bhonti, intamulolile umuntu ngaweeka we alɨ nʉ lwɨtɨkho ʉlʉpɨtɨ anza lunuulu! ");
INSERT INTO mgq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ɨnkʉbhabhʉʉzya kʉtɨ, abhantʉ kufuma ɨmbalɨ zyonti ɨzyɨ nsɨ bhakhayɨnza, bhakhayɨɨkhala pa shikulukulu peeka nu Abulahaamu, uIsaaka nʉ Yaakobo mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ɨleelo bhe ʉwʉmwene wʉnʉʉwo waabho, bhakhayɨsʉmbwa kunzi ku khiisi. Kʉnʉʉkwo kwe bhakhayɨlɨla na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ!” ");
INSERT INTO mgq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pe uYeesu akhamʉbhʉʉzya ʉmʉpɨtɨ ʉla akhatɨ, “Bhalaga kʉkhaaya! Yɨbhe kʉkwakho anza she uyitishile.” Pe umubhombi waakwe akhapona kʉ khabhalɨlo khakhaala. ");
INSERT INTO mgq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","UYeesu we aafikha mu nyumba ya Peeteli, akhamwaga ʉnyavwala wa Peeteli agonile pa shɨtala, alɨ nɨ nzegema. ");
INSERT INTO mgq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pe uYeesu akhamʉpalamansya ɨnyoobhe, akhapona ɨnzegema yiila. Woope akhɨmɨɨlɨla, akhalɨngaanya ishaakulya kʉnongwa ya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","We kwabha shalyabheela, bhakhamʉleetela uYeesu abhantʉ abhinji bhe bháamɨle na mapepu amabhiibhi. Akhagabhɨnga amapepu amabhiibhi gaala ku mazwi meene. Khabhɨlɨ akhabhaponɨa bhonti bhe bháamɨle bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ganaago gábhombeshile ɨnga kʉkwɨlɨzya izwi lye lyálonjiilwe nu mukuwi ʉYeesaya kʉtɨ, “Ʉweene ayeejile ʉwʉtolwe wɨɨtʉ, akhazɨpɨmba ɨmpʉngo zyɨtʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","UYeesu we aalola ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakʉmʉzyʉngʉʉla, akhabhalajɨzya abhalandati bhaakwe kʉtɨ bhafumiile ʉsʉmbɨ ʉwa Galɨlaaya kʉbhala kwɨsyɨla. ");
INSERT INTO mgq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pe umumanyizyi weeka ʉwɨ ndajɨzyo akhasejeelela kwa Yeesu, akhamʉbhʉʉzya akhatɨ, “We Mumanyizyi, ɨntɨkʉlandate kwonti kwe ʉkʉbhala.” ");
INSERT INTO mgq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","UYeesu akhamwamʉla akhatɨ, “Ɨmbɨla zɨlɨ nɨ ngwenya, inyonyi zɨlɨ ni vwanswi, ɨleelo ʉMwana wa Muntu atalɨ ni nyumba ɨya kwɨkhala!” ");
INSERT INTO mgq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ʉmo mu bhalandati bhaakwe akhamʉbhʉʉzya uYeesu akhatɨ, “We Mwene, ʉnɨtɨshɨzye ɨmbale suuti, ɨmʉsyɨle uyise waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ɨleelo uYeesu akhamwamʉla akhatɨ, “Ɨwe ndandate! Bhaleshe abhafwe bhabhasyɨlaje abhafwe bhaabho.” ");
INSERT INTO mgq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pe uYeesu akhinjila mʉ shɨtʉʉlɨ, abhalandati bhaakwe bhakhamʉlandata. ");
INSERT INTO mgq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nalʉbhɨlo ishimvulungwa ɨshɨpɨtɨ nhaani shikhafumila mwa sʉmbɨ, amabhilingwa gakhanda kugubishila ɨshɨtʉʉlɨ. Ɨleelo uYeesu ágonile utulo. ");
INSERT INTO mgq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abhalandati bhaakwe bhakhabhala bhakhamʉdaamʉsya, bhakhatɨ, “We Mwene! Tʉposhe! Tukuswibha!” ");
INSERT INTO mgq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","UYeesu akhatɨ, “Khooni khe mʉkwogopa, ɨmwe mʉbha lwɨtɨkho ulunsi?” Pe akhɨmɨɨlɨla, akhayɨkhajɨla impepu ɨmpɨtɨ na mabhilingwa, kʉkhabha mye nalyoli lyoli. ");
INSERT INTO mgq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abhantʉ bhaala bhakhaswiga, bhakhatɨ, “Wu naanu wʉnʉʉnʉ we ni mpepu na mabhilingwa vikumutinikha?” ");
INSERT INTO mgq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","We uYeesu afumiila ʉsʉmbɨ, akhafikha mʉ nsɨ ɨya Bhagadaala. Akhakhomaana na bhantʉ bhabhɨlɨ abha mapepu amabhiibhi bhe bháfumile kʉ mbɨɨpa. Abhantʉ bhanaabho bháamɨle bhakhali nhaani, atálɨɨpo umuntu we akhalɨnjɨzyaga kʉshɨla ɨdala liila. ");
INSERT INTO mgq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pe bhakhazingula ɨshongo bhakhatɨ, “We Mwana wa Mʉlʉngʉ, ʉlɨ na khooni nɨɨtwe? Bhʉlɨ, wɨnza kʉtʉyɨmvwa we akhabhalɨlo khashɨɨlɨ akha kʉyɨmba?” ");
INSERT INTO mgq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Papɨɨpɨ na papaala pe bháamɨle, páamɨle ɨmpʉga ɨmpɨtɨ ɨyɨ ngʉlʉbhe zɨkhalyanga. ");
INSERT INTO mgq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pe amapepu amabhiibhi gaala gakhamʉlamba uYeesu gakhatɨ, “Ɨnga ʉkʉtʉbhɨnga, ʉtwɨtɨshɨzye tʉbhale twinjile mʉ mpʉga yiila ɨyɨ ngʉlʉbhe.” ");
INSERT INTO mgq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Akhagabhʉʉzya akhatɨ, “Bhalaji!” Pe amapepu amabhiibhi gakhafuma mʉ bhantʉ bhabhɨlɨ bhaala, gakhinjila mʉ ngʉlʉbhe ziila. Ɨmpʉga ɨmpɨtɨ yiila ɨyɨ ngʉlʉbhe yonti yikhiikha nalʉbhɨlo ku lwikha lwe lusulamile nhaani, zɨkhagwɨla mwa sʉmbɨ, zɨkhafwa. ");
INSERT INTO mgq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abhadiimi abhɨ ngʉlʉbhe bhakhoogopa, bhakhashɨmbɨla, bhakhabhala mʉ nhaaya. Bhakhanda kʉbhabhʉʉzya abhantʉ zyonti zye zibhombeshile na kʉ zya bha mapepu amabhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abhantʉ bhonti kufuma mʉ nhaaya, bhakhasogola kʉbhala kwa Yeesu. Pe we bhamʉlola, bhakhamʉlamba kʉtɨ asogole mʉ nsɨ yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","UYeesu akhinjila mʉ shɨtʉʉlɨ, akhafumiila ʉsʉmbɨ ʉwa Galɨlaaya akhagalʉkha mʉ nhaaya ɨya kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pe abhantʉ bhamu bhámuleetile umuntu we áamɨle nu wubhinu ʉwa kufwa kʉndwɨmo, agonile pi pagali. We uYeesu alʉlola ʉlwɨtɨkho lwabho, akhamʉbhʉʉzya umubhinu ʉla akhatɨ, “We mwana waanɨ, yɨgomwe ʉmwoyo! Utuyiliilwe imbiibhi zyakho.” ");
INSERT INTO mgq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pe bhamu mu bhamanyizyi abhɨ ndajɨzyo zya Moose bhakhayɨsɨɨbhaga mʉ mooyo gaabho bhakhatɨnjɨ, “Umuntu ʉnʉ akʉmʉshoolanya ʉMʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Woope uYeesu ázimanyile zyonti zye bhakhasɨɨbhaga, akhabhabhʉzɨɨlɨzya akhatɨ, “Khooni khe mʉkʉsɨɨbha akhabhiibhi mʉ mooyo giinyu? ");
INSERT INTO mgq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kwe kʉtɨ lilikwi lye lipupuusu nhaani? Kʉtɨ, ‘Imbiibhi zyakho zituyiliilwe,’ awe kʉtɨ, ‘Yɨmɨɨlɨla, jendaga’? ");
INSERT INTO mgq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ishi leelo ɨnkwanza ɨmbalanje kʉtɨ, ʉMwana wa Muntu alɨ nʉ waamʉlo ʉwa kʉbhatʉʉyɨla imbiibhi abhantʉ mʉ nsɨ.” Pe uYeesu akhamʉbhʉʉzya umuntu ʉla we alemaaye akhatɨ, “Yɨmɨɨlɨla, yeega ɨshɨlɨlɨ shaakho, bhalaga kʉkhaaya.” ");
INSERT INTO mgq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pe umuntu ʉla akhɨmɨɨlɨla, akhabhala kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ɨmpʉga ɨmpɨtɨ yiila we bhazɨlola zɨnɨɨzyo, bhakhoogopa nhaani. Bhakhamʉpaala ʉMʉlʉngʉ we ábhapiiye abhantʉ ʉwaamʉlo anza wʉnʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","We uYeesu asogola paala, akhamʉlola umuntu ʉmo ɨtaawa lyakwe bhakhatɨnjɨ uMataayi, ayɨkhaaye mu ofesi ɨya kʉsonshezya ɨnsonho. UYeesu akhamʉbhʉʉzya akhatɨ, “Ndandate.” Nalʉbhɨlo, uMataayi akhɨmɨɨlɨla, akhanda kʉmʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe uYeesu we ayɨkhaaye kulya ishaakulya mu nyumba ya Mataayi, bhakhinjila abhasonshezya nsonho abhinji na bhabhomba mbiibhi, bhakhɨnza na kulya peeka nu Yeesu na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","We aBhafalisaayi bhazɨlola zɨnɨɨzyo, bhakhabhabhʉzɨɨlɨzya abhalandati bhaakwe bhakhatɨ, “Khooni khe umumanyizyi wiinyu akulya peeka na bhasonshezya nsonho na bhabhomba mbiibhi?” ");
INSERT INTO mgq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","We uYeesu ayɨmvwa zɨnɨɨzyo, akhabhabhʉʉzya akhatɨ, “Abhantʉ bhe bhatabhinile bhatakʉmwanza ʉmʉganga, lyoli bhe bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pe bhalaji mʉmanyɨle kwe kʉtɨ bhʉlɨ amazwi ɨga ge gakʉtɨ, ‘Ɨnkwanza ishisa te mfinjile.’ Ɨne intínzile kʉbhanza bhe bhakʉyɨlola kʉtɨ bhagolosu, lyoli nínzile kʉbhanza abhabhomba mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pe abhalandati bha Yookhani bhakhabhala kwa Yeesu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ɨtwe na Bhafalisaayi tukuyiimaga kulya ishaakulya. Khooni khe abhalandati bhaakho bhatakuyiima kulya?” ");
INSERT INTO mgq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","UYeesu akhabhaamʉla akhatɨ, “Abhantʉ bhe bhalanjiliilwe ku weeji, bhangakhola kʉswɨmɨɨlɨla we bhalɨ peeka nʉ wa weeji? Ɨleelo mu nsiku zye zɨkwɨnza, we abhalʉgʉ bhamwefwa ʉwa weeji pakaasi yaabho, akhabhalɨlo khanaakho bhakhayiyiima kulya. ");
INSERT INTO mgq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Atalɨɨpo umuntu we akudeebula ɨshɨpaatɨkho kʉ mwenda umupwa, na kʉshɨpaatɨkha mʉ mwenda ʉmʉkʉʉlʉ. Ɨnga akhonzya shɨnɨɨsho, ɨshɨpaatɨkho ishipwa, shikuyizeepula kufuma kʉ mwenda ʉmʉkʉʉlʉ, pe woope wʉkwonjela kuzeepukha nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Khabhɨlɨ abhantʉ bhatakʉbhɨɨkha idivaayi impwa mʉ ntembe ɨnkʉʉlʉ zye zilalile. Ɨnga abhomba shɨnɨɨsho, idivaayi we yɨkʉlʉla ɨntembe zɨkʉbazʉkha, idivaayi yikwitikha nɨ ntembe yoope yɨkʉnanjɨkha. Lyoli abhantʉ bhakʉbhɨɨkha idivaayi impwa mʉ ntembe impwa. Pe vwonti vɨbhɨlɨ ɨntembe impwa ni divaayi impwa vɨkʉbha akhinza!” ");
INSERT INTO mgq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","We uYeesu akʉlonga na bhantʉ bhaala, nalʉbhɨlo akhɨnza umulongozi weeka, akhasʉgamɨla pɨlongolela yaakwe, akhamʉbhʉʉzya akhatɨ, “Ʉmwalɨ waanɨ aafwa shiniishi bhʉʉlo. Ɨnkʉlamba, saalɨ ʉmʉbhɨɨshe ɨnyoobhe yaakho, woope atɨbhe mwumi winza.” ");
INSERT INTO mgq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","UYeesu akhɨmɨɨlɨla peeka na bhalandati bhaakwe, bhakhamʉlandata umulongozi ʉla. ");
INSERT INTO mgq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yeenya, mʉ khabhalɨlo khakhaala ʉmwantanda weeka we áyimbile nu wubhinu ʉwa kuzwa ɨbhanda kʉ manha ishumi na gabhɨlɨ, akhabhala kʉlʉsalo kwa Yeesu, akhapalamansya ipindilwi ɨlya mwenda waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kʉnongwa ye ákwinile mʉ mwoyo waakwe kʉtɨ, “Ɨnga napalamansya ʉmwenda waakwe bhʉʉlo, ɨntɨpone.” ");
INSERT INTO mgq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","We apalamansya, uYeesu akhagalʉnhana kwenya kʉlʉsalo. Pe we amʉlola ʉmwantanda ʉla, akhamʉbhʉʉzya akhatɨ, “We mwalɨ waanɨ, yɨgomwe ʉmwoyo! Ʉlwɨtɨkho lwakho lwakʉponɨa!” Nalʉbhɨlo, ʉmwantanda ʉla akhapona. ");
INSERT INTO mgq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","UYeesu we aafikha mu nyumba ya mulongozi ʉla, akhabhaaga abhantʉ abhinji bhabhungaanile, bhakʉlɨla ɨmpʉngo. Bhamu bhakhakhomaga ɨmfwɨlɨmbo. ");
INSERT INTO mgq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","UYeesu akhabhabhʉʉzya akhatɨ, “Yeepi ɨpa! Kʉnongwa ye ʉmʉlɨndʉ ʉnʉ atafuuye, lyoli asʉpɨlɨɨye bhʉʉlo!” Abhantʉ bhaala we bhɨmvwa shɨnɨɨsho, bhakhamʉsekha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pe bhakhabhafumwa kunzi abhantʉ, uYeesu akhinjila mukaasi, akhamʉlema ɨnyoobhe ʉmʉlɨndʉ ʉla, woope akhɨmɨɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Intumi zɨnɨɨzyo zɨkhasaata mʉ nsɨ yiila yonti. ");
INSERT INTO mgq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","We uYeesu asogola paala, bhe bhafuuye amiiso bhabhɨlɨ bhakhamʉlandata, bhakhabhɨlɨshɨla kʉ makha bhakhatɨ, “We Mwene, ʉwa shɨkholo sha mwene uDaudi, tʉlolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pe uYeesu akhinjila mu nyumba, bhe bhafuuye amiiso bhakhabhala mumuula. Pe akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, mʉkwɨtɨkha kʉtɨ ɨngakhola kʉbhaponɨa?” Bhakhamwamʉla bhakhatɨ, “Ee, Mwene! Tʉkwɨtɨkha.” ");
INSERT INTO mgq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pe uYeesu akhabhapalamansya amiiso gaabho, akhabhabhʉʉzya akhatɨ, “Zɨbhombeshe kukwinyu anza she ʉlwɨtɨkho lwinyu lʉlɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nalʉbhɨlo, amiiso gaabho gakhadaamʉla. UYeesu akhabhasokha kʉ makha akhatɨ, “Mʉtakhasheele kʉmʉbhʉʉzya umuntu wowonti intumi izi!” ");
INSERT INTO mgq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ɨleelo bhakhabhala, bhakhavwɨnsya intumi zyakwe mʉ nsɨ yiila yonti. ");
INSERT INTO mgq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","We abhantʉ bhaala bhasogola paala, abhantʉ abhanjɨ bhakhamʉleetela uYeesu umuntu we álemiilwe ni pepu ibhiibhi lye lyámubhiishile uwushinuunu. ");
INSERT INTO mgq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","UYeesu akhalɨbhɨnga ipepu liila, nalʉbhɨlo ushinuunu ʉla akhanda kʉlonga winza. Abhantʉ bhe bhálɨɨpo paala bhakhaswiga nhaani, bhakhatɨ, “Zitafumiiye naalumo anza ziniizi mʉ nsɨ yonti ɨya Isilaeli!” ");
INSERT INTO mgq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ɨleelo aBhafalisaayi bhakhabhʉzanyaaga bhakhatɨnjɨ, “Akʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa mʉpɨtɨ wa mapepu!” ");
INSERT INTO mgq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pe uYeesu akhazyʉngʉʉlaga mʉ nhaaya zyonti na mʉ tʉkhaaya twonti. Akhamanyɨzyaga abhantʉ mu masinagoogi gaabho, akhalʉmbɨlɨlaga iNtumi iNyinza ɨzya wʉmwene ʉwa kʉmwanya na kʉbhaponɨa abhantʉ ɨmpʉngo zyonti nʉ wʉtolwe nʉʉwo nʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pe we azɨlola ɨmpʉga ɨzya bhantʉ, akhabhalolela ishisa. Kʉnongwa ye bhálitile, na kʉsataana, ngatɨ ngoole zye zɨtalɨ nu mudiimi. ");
INSERT INTO mgq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pe akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨvɨyabho vwinji vweleeye mu shiizi, ɨleelo abha kʉsezya bhalɨ bhashe. ");
INSERT INTO mgq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pe mʉlaabhaje ʉMwene ʉMʉlʉngʉ ʉwa vɨyabho, ɨnga abhasonteelezye abha kʉsezya ɨvɨyabho vwakwe.” ");
INSERT INTO mgq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","UYeesu akhabhabhɨlɨshɨla peeka abhalandati bhaakwe ishumi na bhabhɨlɨ. Akhaabhapa ʉwaamʉlo ʉwa kʉbhɨnga amapepu amabhiibhi na ga kʉponɨa uwubhinu wonti nʉ wʉtolwe nʉʉwo nʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amataawa ga bhasundikwa bhanaabho ishumi na bhabhɨlɨ ge ga gɨɨga, ʉwa kwanda wu Siimoni, we bhakʉtɨ uPeeteli, ʉAndeleeya ʉkhambakʉ waakwe, ʉYaakobo ʉmwana wa Zebedaayo, uYookhani ʉkhambakʉ waakwe, ");
INSERT INTO mgq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","uFilipo, ʉBatolomaayo, uToomasi, uMataayi ʉmʉsonshezya nsonho, ʉYaakobo ʉmwana wa Alʉfeeyo, ʉTadeeyo, ");
INSERT INTO mgq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","uSiimoni ʉmʉlwɨla nsɨ yaakwe nʉ Yʉʉda Sikalioti we akhamʉlonjeelela uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","UYeesu akhabhasonteelezya bhanaabho ishumi na bhabhɨlɨ, akhabhalajɨzya akhatɨ, “Mʉtabhalaje kʉ bhantʉ bhe te Bhayahuudi, khabhɨlɨ mutinjilaje mʉ nhaaya ɨzya Bhasamaliya. ");
INSERT INTO mgq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lyoli mʉbhale ku Bhaisilaeli kʉnongwa ye bhateejile ngatɨ ngoole. ");
INSERT INTO mgq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Khabhɨlɨ we mʉkʉshɨla, mʉlʉmbɨlɨlaje mʉtɨnjɨ, ‘Ʉwʉmwene ʉwa kʉmwanya wʉpalamɨɨye.’ ");
INSERT INTO mgq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mʉbhaponɨaje abhabhinu, mʉzyʉsyaje abhafwe, mʉbhasatʉlaje abha maketa na kʉbhɨnga amapepu amabhiibhi. Kʉnongwa ye ʉMʉlʉngʉ abhapiiye pabhʉʉlo, nɨɨmwe fumwaji pabhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mʉtakhaapaye izahaabu, awe ɨnhela, awe ɨnsabhaazya ɨzyɨ shaaba mʉ nyambɨ zyinyu. ");
INSERT INTO mgq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mʉteegaje imbuguuli, awe amenda aga kwandʉlanya, awe ɨvɨlyatʉ, awe ɨndoogo ɨya kʉjendela. Kʉnongwa ye umubhombi akhondeeye kʉtɨ aposheelaje kufumilana nɨ mbombo yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ɨnhaaya yoyonti awe akhakhaaya khokhonti khe mwinjila mʉmwo, mʉkhamwanze umuntu we akhondeeye kʉbhaposheela ɨmwe. Panaapo mwɨkhalaje kʉkwakwe kufishila akhabhalɨlo khe mʉkhayɨsogola. ");
INSERT INTO mgq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","We mwinjila mu nyumba, mʉbhalamʉkhaje abhakhaaya. ");
INSERT INTO mgq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ɨnga abhakhaaya abhi nyumba yɨnɨɨyo bhakhondeeye, uwutengaanu wiinyu wʉtɨbhe peeka nabho. Ɨleelo ɨnga bhatakhondeeye, uwutengaanu wiinyu wʉtɨbhagalʉshɨle ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɨnga umuntu ngaweeka atakʉbhaposheela awe kʉtejeelezya amazwi giinyu, we mʉkʉsogola mu nyumba yɨnɨɨyo awe mʉ nhaaya yɨnɨɨyo mukhakunyuntaje ulusuuto mʉ vɨnama vwinyu, kʉbhasokha kʉtɨ bhakʉmʉkhaana wʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nalyoli ɨnkʉbhabhʉʉzya isiku ɨlya kʉlongwa, ɨnhaaya yɨnɨɨyo yɨkhayɨlongwa ulufundo ʉlʉpɨtɨ kʉshɨla luula ʉlwɨ nhaaya ɨya mu Sodoomu nɨ ya mʉ Gomoola! ");
INSERT INTO mgq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ishi, ɨnkʉbhasonteelezya ngatɨ ngoole pakaasi pa mbwa inhali ɨzya mwɨ laala. Mʉbhe mwe bhɨ njeele ngatɨ njokha, khabhɨlɨ mʉbhe mwe bhatonsu ngatɨ nkʉnda. ");
INSERT INTO mgq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mʉbhe amiiso na bhantʉ, kʉnongwa ye bhakhayɨbhatwala mʉ mabalaaza na kʉbhakhoma mu masinagoogi gaabho. ");
INSERT INTO mgq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bhakhayɨbhatwala kʉ bhapɨtɨ abhɨ nsɨ na kʉ bhamwene kʉnongwa yaanɨ, kʉtɨ mʉkhabhe mwe bhakeeti pɨlongolela yaabho na pɨlongolela pa bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","We bhakʉbhatwala kʉ bhapɨtɨ, mʉtakhaalabhe kʉsɨɨbha zye mʉtɨbhale mʉlonje. Kʉnongwa ye mʉkhayɨpeelwa aga kʉlonga kʉ khabhalɨlo khanaakho. ");
INSERT INTO mgq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kʉnongwa ye te mwemwe mʉkhayɨlongaga, lyoli uMupepu wa Taata wiinyu we akhayɨbhalongolaga we mʉkʉlonga. ");
INSERT INTO mgq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kʉ khabhalɨlo khanaakho, ʉkhambakʉ akhayɨmʉlonjeelela ʉwamwabho kʉ bhalʉgʉ kʉtɨ bhamʉgoje, uyise akhayɨmʉlonjeelela ʉmwana. Abhaana bhoope bhakhayɨsambʉkha ku bhapaafi bhaabho na kʉbhalonjeelela ɨnga bhabhagoje. ");
INSERT INTO mgq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abhantʉ bhonti bhakhayibhaviitilwa kʉnongwa yɨ taawa lyanɨ. Ɨleelo, we akhayijimbiilila kufishila kʉmpeleela we ʉMʉlʉngʉ akhayɨmʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ɨnga bhabhabhɨnga mʉ nhaaya yimo, mʉkhashɨmbɨlɨlaje mʉ nhaaya ɨyamwabho. Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, te mʉkhaamale kʉshɨla mʉ nhaaya zyonti ɨzya mu Isilaeli she ʉMwana wa Muntu atagalushile. ");
INSERT INTO mgq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Umumanyili atangamʉshɨla umumanyizyi waakwe. Khabhɨlɨ umutumwa woope atakʉmʉshɨla ʉmwene waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umumanyili abhe anzu mumanyizyi waakwe nu mutumwa abhe anzʉ mwene waakwe. Ɨnga bhamuteshile ʉmʉsongo uwi nyumba kʉtɨ wu Belizebuuli, bhʉlɨ, bhatangabhabhɨlɨshɨla ɨtaawa ibhiibhi nhaani bhe bhalɨ mu nyumba yaakwe? ");
INSERT INTO mgq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Shɨnɨɨsho mʉtabhogopaje abhantʉ bhanaabho. Akhabhalɨlo khakwɨnza khe gonti ge galɨ kukwilu gakhayɨbha apazelu, khabhɨlɨ gonti ge gafisishile gakhayɨmanyɨkha. ");
INSERT INTO mgq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Zye ɨnkʉbhabhʉʉzya ku khiisi, mʉzɨlongaje apazelu. Khabhɨlɨ zyonti zye mʉkwɨmvwa kukwilu, zɨvwɨnsyaje pa mbɨmbɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mʉtabhogopaje bhe bhakʉgoga ʉmʉbhɨlɨ mwene, ɨleelo bhatangakhola kʉgoga umupepu. Mʉmwogopaje ʉMʉlʉngʉ wʉʉyo mwene we angakhola kʉyazya ʉmʉbhɨlɨ peeka nu mupepu mʉ mwoto we wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bhʉlɨ, ʉtʉdwaya tʉbhɨlɨ bhatakʉkazya kʉ nhela ɨnsabhaazya nyishe bhʉʉlo? Poope shɨnɨɨsho atalɨɨpo ʉdwaya mʉ bhanaabho we akʉlenda paasɨ sita kwɨtɨshɨzya ʉTaata wiinyu. ");
INSERT INTO mgq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɨleelo ɨmwe, insisi zyonti ɨzya mʉ matwe giinyu ʉMʉlʉngʉ azibhaziizye. ");
INSERT INTO mgq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pe shɨnɨɨsho mʉtogopaje, kʉnongwa ye ɨmwe mʉkhondeeye kʉshɨla ʉtʉdwaya utwinji. ");
INSERT INTO mgq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Umuntu wowonti we akʉnɨɨtɨkha pɨlongolela pa bhantʉ, nɨɨne ɨnhayɨmwɨtɨkha pɨlongolela pa Taata waanɨ we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ɨleelo, wowonti we akʉnhaana pɨlongolela pa bhantʉ, nɨɨne ɨnhayɨmʉkhaana pɨlongolela pa Taata waanɨ we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mʉtasɨɨbhaje kʉtɨ ininzile kʉleeta uwutengaanu mʉ nsɨ umu. Intinzile kʉleeta uwutengaanu, lyoli kuviitana. ");
INSERT INTO mgq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kʉnongwa ye ininzile kumulumanya umuntu nu yise waakwe, ʉmʉlɨndʉ nu nyina waakwe, ʉmʉnhamwana nʉ nyavwala waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Khabhɨlɨ abhalʉgʉ bha muntu bhakhayɨbha bha bhaala abha mu nyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Khabhɨlɨ umuntu wowonti we akʉmʉgana uyise waakwe awe unyina waakwe kʉshɨla kʉngana ɨne, wʉnʉʉyo atanhondeeye. Wowonti we akʉmʉgana ʉmwana waakwe awe ʉmwalɨ waakwe kʉshɨla kʉngana ɨne, wʉnʉʉyo woope atanhondeeye. ");
INSERT INTO mgq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Khabhɨlɨ umuntu we atakʉpɨmba ɨshɨkhobhenhanyo shaakwe na kʉndandata, wʉnʉʉyo atanhondeeye. ");
INSERT INTO mgq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Umuntu wowonti we akʉwʉpokha uwuumi waakwe, akhayɨwʉteezya. Lyoli we akʉwʉteezya uwuumi waakwe kʉnongwa yaanɨ, akhayɨwʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Umuntu wowonti we akʉbhaposheela ɨmwe, akʉmposheela neene. Khabhɨlɨ we akʉmposheela ɨne, akʉmʉposheela nʉ Taata we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","We akʉmʉposheela umukuwi kʉnongwa ye mukuwi, akhayɨposheela anzu mukuwi. Khabhɨlɨ we akʉmʉposheela umuntu we mugolosu kʉnongwa ye mugolosu, akhayɨposheela anzu muntu we mugolosu. ");
INSERT INTO mgq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, wowonti we akuumupa ɨshɨkoopa ɨsha minzi amakhatazu weeka mʉ bhe te bha lushindikho ɨbha kʉnongwa ye mulandati waanɨ, akhayɨposheela ɨnsamaalɨzyo.” ");
INSERT INTO mgq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","We uYeesu aamala kʉbhalajɨzya abhalandati bhaakwe ishumi na bhabhɨlɨ, akhasogola paala. Akhabhala kʉmanyɨzya na kʉlʉmbɨɨlɨla mʉ nhaaya zya Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","UYookhani uMwozyi we akungiilwe mwɨ jeela, akhɨmvwa zye uKilisiti akhabhombaga. Pe akhabhasonteelezya abhalandati bhaakwe, ");
INSERT INTO mgq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kʉmʉbhʉzɨɨlɨzya kʉtɨ, “Bhʉlɨ, ɨwe we Kilisiti we abhakuwi bhátɨlɨ akhayɨnza, awe tʉmʉgʉlɨlaje uwunji?” ");
INSERT INTO mgq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","UYeesu akhabhaamʉla akhatɨ, “Bhalaji mʉmʉbhʉʉzye uYookhani zyonti zye mʉkʉzyɨmvwa na kʉzɨlola: ");
INSERT INTO mgq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","bhe bhatalolaga bhakʉlola, bhe bhatajendaga bhakʉjenda, bhe bhalɨ na maketa bhakʉsatʉlwa, bhe bhatɨmvwaga bhakwɨmvwa, abhafwe bhakʉzyʉkha, na bhapɨɨna bhakʉlʉmbɨɨlɨlwa iNtumi iNyinza. ");
INSERT INTO mgq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Asayiilwe umuntu we atakʉlʉlekha ʉlwɨtɨkho kʉnongwa yaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","We abhalandati bha Yookhani bhasogola, uYeesu akhanda kʉyɨbhʉʉzya ɨmpʉga ya bhantʉ kʉ zya Yookhani akhatɨ, “Mwabhalaga kwenya khooni ku shilozu kuula? Bhʉlɨ, mwabhalaga kwenya umuntu we atalɨ na makha ngatɨ lɨtete lye impepu yikuyinzanya? ");
INSERT INTO mgq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɨnga te shɨ shɨnɨɨsho, mwábhalile kwenya khooni? Mwábhalile kʉmwenya umuntu we akwatile amenda agɨ togo? Yeenya, abhantʉ bhe bhakʉkwata amenda agɨ togo bhakwɨkhala mu nyumba ɨzya shɨmwene. ");
INSERT INTO mgq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pe mwabhalaga kwenya khooni? Bhʉlɨ, mwábhalile kʉmwenya umukuwi? Nalyoli uYookhani mʉpɨtɨ kʉshɨla umukuwi. ");
INSERT INTO mgq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wʉnʉʉnʉ we wʉ wʉʉla we yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Yeenya, ɨnhayɨmʉsonteelezya we akʉtwala intumi mwɨlongolela lyakho, akhayɨlɨngaanya ɨdala lyakho ɨlya kwɨnzɨla.’” ");
INSERT INTO mgq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, mʉ bhantʉ bhonti bhe bhapapiilwe na bhantanda, atafumiiye nʉʉmo we mʉpɨtɨ kʉmʉshɨla uYookhani uMwozyi. Ɨleelo, umuntu we munsi nhaani mʉ wʉmwene ʉwa kʉmwanya, we mʉpɨtɨ kʉmʉshɨla ʉweene. ");
INSERT INTO mgq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwandɨla mu nsiku ɨzya Yookhani uMwozyi kufishila akhabhalɨlo akha shiishi, ʉwʉmwene ʉwa kʉmwanya wʉkʉgadɨɨlwa, khabhɨlɨ abhantʉ abha makha bhakʉlɨnga kʉwʉfwʉla kʉ makha. ");
INSERT INTO mgq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwe kʉtɨ abhakuwi bhonti nɨ ndajɨzyo zya Moose bháfumwizye uwukuwi kufishila mʉ khabhalɨlo akha Yookhani. ");
INSERT INTO mgq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ɨnga mʉkwɨtɨkha lɨnɨɨlyo, uYookhani we wu Eliya we abhakuwi bhálonjile kʉtɨ akhayɨnza. ");
INSERT INTO mgq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa! ");
INSERT INTO mgq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bhʉlɨ, abhantʉ abha khabhalɨlo ɨkha ɨmbakholanye na khooni? Bhakʉkholana na bhaana bhe bhɨkhaaye pa mʉnaalo bhakʉbhabhɨlɨshɨla abhamwabho bhakʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Twaabhakhomeeye ɨmfwɨlɨmbo, ɨleelo mʉtɨmbaga! Twaabhɨmbɨɨye ɨnyɨmbo ɨzya wuswimiilizu, ɨleelo mʉtalɨlaga!’ ");
INSERT INTO mgq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Shɨnɨɨsho she nɨɨmwe mʉlɨ, kʉnongwa ye akhabhalɨlo khe uYookhani uMwozyi áyinzile, atakhalyanga awe kʉmwela, ɨmwe mʉkhatɨ, ‘Alemiilwe ni pepu ibhiibhi!’ ");
INSERT INTO mgq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ɄMwana wa Muntu áyinzile, akhalyanga na kʉmwela, abheene bhakhatɨ, ‘Yeenya! Umulyovi ʉnʉ, khabhɨlɨ mumwezi, mumanyani wa bhasonshezya nsonho na bhabhomba mbiibhi!’ Ɨleelo ɨnjeele yɨkʉmanyɨkha kʉtɨ ya nalyoli kʉ mbombo zyakwe.” ");
INSERT INTO mgq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pe uYeesu akhanda kʉzɨkhajɨla ɨnhaaya mwe akhabhombaga amayele aminji nhaani kʉnongwa ye abhantʉ abhɨ nhaaya zɨnɨɨzyo bhatálaatile imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Akhatɨ, “Mʉsheleeye mʉbhantʉ abhɨ nhaaya ɨya mu Kolaziini! Mʉsheleeye mʉbhantʉ abhɨ nhaaya ɨya mu Betisayida! Kʉnongwa ye amayele ge nábhombile kukwinyu, ɨnga ɨnhabhombaga mʉ nhaaya ɨya mu Tiilo nɨ ya mu Sidooni, abhantʉ abha mʉ nhaaya zɨnɨɨzyo nhanɨ bhalaatile khalɨ na kʉkwata amafuuku na kʉyɨpakha amalota kʉlolesya kʉlaata imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ɨleelo, ɨnkʉbhabhʉʉzya isiku ɨlya kʉlongwa, ɨnhaaya yɨnɨɨyo yɨkhayɨlongwa ulufundo ʉlʉpɨtɨ kʉshɨla luula ʉlwɨ nhaaya ɨya mu Tiilo nɨ ya mu Sidooni! ");
INSERT INTO mgq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nɨɨmwe mʉbhantʉ abha mʉ nhaaya ɨya mu Kapelenaumu, bhʉlɨ, mʉkʉsɨɨbha kʉtɨ ʉMʉlʉngʉ akhayɨbhazʉvwa paka kʉmwanya? Ndaali! Akhayibhiisya paka kwɨlongo! Kʉnongwa ye ɨnga amayele ge gábhombeshile kʉkwabho, bhanje gakhabhombwaga mʉ nhaaya ɨya mu Sodoomu, ɨnhaaya yɨnɨɨyo nhanɨ yɨlɨɨpo kufishila akhabhalɨlo akha shiishi. ");
INSERT INTO mgq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ɨleelo ɨnkʉbhabhʉʉzya isiku ɨlya kʉlongwa, ɨnhaaya yɨnɨɨyo yɨkhayɨlongwa ulufundo ʉlʉpɨtɨ kʉshɨla luula ʉlwɨ nhaaya ɨya mu Sodoomu!” ");
INSERT INTO mgq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Akhabhalɨlo khanaakho uYeesu akhajendeelela kʉlonga akhatɨ, “Inkukusalifwa we Taata, wʉMwene ʉwa kʉmwanya na paasɨ, kʉnongwa ye ubhafisile abhantʉ abhɨ njeele na bhabhaazye ɨnongwa ziniizi, ɨleelo uzibhiishile apazelu kʉ bhaana abhansi. ");
INSERT INTO mgq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nalyoli we Taata, shɨnɨɨsho she wáyiganile. ");
INSERT INTO mgq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ɄTaata waanɨ ampiiye ivintu vwonti. Atalɨɨpo umuntu we amumanyile ʉMwana, lyoli ʉTaata waanɨ mwene. Khabhɨlɨ atalɨɨpo umuntu we amumanyile ʉTaata, lyoli ʉMwana mwene, nu muntu wowonti we ʉMwana ayiganile kʉmʉlanga. ");
INSERT INTO mgq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nzaagaji kʉkwanɨ ɨmwe mwenti mwe mʉkʉyɨmba na kʉmwamɨlwa na mazigo, nɨɨne ɨntɨɨbhape ʉwʉtʉʉzyo. ");
INSERT INTO mgq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mʉkwataje iniila yaanɨ, mʉmanyɨlaje kʉkwanɨ kʉnongwa ye ɨne ne mutonsu, khabhɨlɨ ɨne inkuyiisya mʉ mwoyo, nɨɨmwe mʉtɨtʉʉzye mʉ mooyo giinyu. ");
INSERT INTO mgq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kʉnongwa ye iniila yaanɨ nkulumusu, khabhɨlɨ umuzigo waanɨ mupupuusu.” ");
INSERT INTO mgq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mʉ khabhalɨlo khanaakho, uYeesu na bhalandati bhaakwe bhakhashɨlaga mu vwizi ɨvwɨ ngano pi siku ɨlyɨ Sabaato. We ɨnzala yabhaluma, bhakhanda kudumula amatwe agɨ ngano na kulya. ");
INSERT INTO mgq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ABhafalisaayi we bhazɨlola zɨnɨɨzyo, bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Yeenya, abhalandati bhaakho bhakʉbhomba zye zɨtakwɨtɨshɨlwa kʉbhomba pi siku ɨlyɨ Sabaato!” ");
INSERT INTO mgq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, mutabhaziizye mu Wusimbe uWufinjile she uDaudi ábhombile we ɨnzala yabhaluma, ʉweene peeka na bhamwabho? ");
INSERT INTO mgq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Áyinjiiye mu nyumba ya Mʉlʉngʉ, akhalya amakaati ge gábhishiilwe pa shɨgemo kʉ mbombo imfinjile. Amakaati ganaago gatakhɨtɨshɨlwaga kulya ʉweene na bhamwabho, lyoli abhapuutili bheene. ");
INSERT INTO mgq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Awe mutabhaziizye mʉ ndajɨzyo zya Moose kʉtɨ abhapuutili abha mu Nyumba iMfinjile bhakʉshɨlanya ɨndajɨzyo pi siku ɨlyɨ Sabaato, ɨleelo bhakʉbhaazɨwa kʉtɨ te bhatʉla nongwa? ");
INSERT INTO mgq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ɨleelo ɨnkʉbhabhʉʉzya kʉtɨ, ɨpa alɨɨpo we mʉpɨtɨ kʉshɨla iNyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɨnga mʉmanyaje kwe kʉtɨ bhʉlɨ amazwi ɨga ge gakʉtɨ, ‘Ɨnkwanza ishisa te mfinjile,’ nhanɨ mutaabhalonjile abhantʉ bhe bhatalɨ nɨ nongwa. ");
INSERT INTO mgq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kʉnongwa ye ʉMwana wa Muntu we wʉ Mwene ʉwɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","UYeesu akhasogola paala, akhinjila mwi sinagoogi lyabho. ");
INSERT INTO mgq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mwi sinagoogi muula, álɨɨpo umuntu we álemaaye ɨnyoobhe. ABhafalisaayi bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, yɨkwɨtɨshɨlwa kʉponɨa abhantʉ pi siku ɨlyɨ Sabaato?” Bhámubhuziliziizye shɨnɨɨsho ɨnga bhalyaje ɨdala ɨlya kʉmʉsɨtaaka uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","UYeesu akhabhabhʉʉzya akhatɨ, “Wu naanu pakaasi yiinyu we ɨnga ɨngoole yaakwe yalendela mu lyina pi siku ɨlyɨ Sabaato atangayɨlema na kʉyeefwa? ");
INSERT INTO mgq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ɨleelo umuntu alɨ nu lushindikho nhaani kʉshɨla ɨngoole! Shɨnɨɨsho, yɨkwɨtɨshɨlwa kʉbhomba inyinza pi siku ɨlyɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pe uYeesu akhamʉbhʉʉzya umuntu ʉla we álemaaye ɨnyoobhe akhatɨ, “Golosya ɨnyoobhe yaakho.” Woope akhagolosya, yɨkhapona, yɨkhabha nyinza anzɨ yamwabho. ");
INSERT INTO mgq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɨleelo aBhafalisaayi bhaala bhakhafuma panzɨ na kʉpanzanya she bhangamʉgoga uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","We uYeesu aamanya kʉtɨ aBhafalisaayi bhakʉpanzanya kʉmʉgoga, akhasogola paala. Abhantʉ abhinji bhakhamʉlandata, ábhaponiizye bhonti bhe bháamɨle bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɨleelo akhabhasokha kʉtɨ bhatakhavundule kʉ bhantʉ kʉtɨ ʉweene wu naanu. ");
INSERT INTO mgq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ganaago gábhombeshile ɨnga kʉkwɨlɨzya izwi lye lyálonjiilwe nu mukuwi ʉYeesaya kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yeenya, umubhombi waanɨ we ɨmʉsabhʉʉye, ʉMʉganwa waanɨ we ʉmwoyo waanɨ wʉkʉmʉseshela. Ɨnhayɨbhɨɨkha uMupepu waanɨ mʉmwakwe, woope akhayɨbhalʉmbɨɨlɨla abhantʉ abhɨ nsɨ zyonti uwulonji waanɨ ʉwa nalyoli. ");
INSERT INTO mgq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Te akhadalɨnhanaje, te akhazingulaje ɨshongo, khabhɨlɨ atalɨɨpo umuntu we akhayɨmvwa izi lyakwe mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Te akhapwote ilanzi lye lilandile, te akhazimanye ʉlʉkhozyo lwe lukufumwa ilyosi, paka pe akhayɨbhɨɨkha uwulonji ʉwa wugolosu wʉtole. ");
INSERT INTO mgq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Khabhɨlɨ ɨtaawa lyakwe abhantʉ abhɨ nsɨ zyonti bhakhayɨlɨsʉʉbhɨla.” ");
INSERT INTO mgq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pe abhantʉ bhamu bhakhamʉleeta umuntu we álemiilwe ni pepu ibhiibhi kwa Yeesu. Ipepu liila lyámubhiishile kʉtɨ atalolaje, khabhɨlɨ áamɨle wu shinuunu. UYeesu akhamʉponɨa umuntu ʉla, akhanda kʉlonga na kʉlola. ");
INSERT INTO mgq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ɨmpʉga ɨya bhantʉ yikhaswiga na kʉbhʉzɨlɨzanya bhɨɨbho na bhɨɨbho bhakhatɨ, “Bhʉlɨ, pamu wʉnʉʉnʉ angabha we Mwana ʉwa shɨkholo sha mwene uDaudi?” ");
INSERT INTO mgq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ɨleelo aBhafalisaayi we bhɨmvwa zɨnɨɨzyo, bhakhatɨ, “Umuntu wʉnʉʉnʉ akʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Belizebuuli, ʉmʉpɨtɨ wa mapepu!” ");
INSERT INTO mgq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","UYeesu we aamanya zye bhakʉsɨɨbha, akhabhabhʉʉzya akhatɨ, “Ɨnga abhantʉ abha wʉmwene weeka bhagabhʉnhana ɨvɨpʉga vwe vɨtakwɨmvwana, pe ʉwʉmwene wʉnʉʉwo wʉkʉnanjɨkha. Khabhɨlɨ ɨnga abhantʉ abhɨ nhaaya yeeka awe inyumba yeeka bhaviitana, bhakʉsataana. ");
INSERT INTO mgq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɨnga uSeetani akʉmʉbhɨnga uSeetani ʉwamwabho, ʉwʉmwene waakwe wʉkʉbha wugabhunhiine. Bhʉlɨ, ʉwʉmwene waakwe wʉngakhola bhʉlɨɨbhʉlɨ kʉjendeelela? ");
INSERT INTO mgq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ɨnga mʉkʉtɨ ɨne ɨnkʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Belizebuuli, abhalandati bhiinyu bhakʉbhɨnga kʉ waamʉlo wa naanu? Mʉ lɨnɨɨlyo, abhalandati bhiinyu bhe bhatɨbhalonje. ");
INSERT INTO mgq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɨleelo ɨne, ɨnga ɨnkʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Mupepu wa Mʉlʉngʉ, ishi ʉwʉmwene wa Mʉlʉngʉ wubhafishiiye ɨmwe! ");
INSERT INTO mgq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Atalɨɨpo umuntu we angakhola kwinjila mu nyumba ya muntu ʉwa makha kʉtɨ amʉfwʉlɨle ivintu vwakwe sita kumupinya suuti. Lyoli ɨnga amupinya, pe angakhola kʉfwʉla vwe vɨlɨ mu nyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Umuntu wowonti we atalɨ peeka nɨɨne, akundindanjila. Khabhɨlɨ wowonti we atakʉbhʉngaanɨkha peeka nɨɨne, akʉsataanya. ");
INSERT INTO mgq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kʉnongwa yɨnɨɨyo, ɨnkʉbhabhʉʉzya kʉtɨ, ʉMʉlʉngʉ akhayɨbhatʉʉyɨla abhantʉ imbiibhi zyabho zyonti na kʉshoolanya kwabho, ɨleelo te akhabhatʉʉyɨle abhantʉ ɨnga bhakʉmʉshoolanya uMupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Khabhɨlɨ umuntu we akʉlonga amazwi amabhiibhi kʉ zya Mwana wa Muntu, akhayɨtʉʉyɨlwa. Ɨleelo we akʉlonga akhabhiibhi kʉ zya Mupepu uMufinjile te akhatʉʉyɨlwe mʉ khabhalɨlo akha shiishi na khe khakwɨnza. ");
INSERT INTO mgq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ikwi ilyinza lɨkwela amatunda aminza, ni kwi ibhiibhi lɨkwela amatunda amabhiibhi. Ikwi lɨkʉmanyɨkha kufumilana na matunda ge lɨkwela. ");
INSERT INTO mgq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɨmwe shɨkholo shɨ njokha! Mʉngakhola bhʉlɨɨbhʉlɨ kʉlonga amazwi aminza we mwe bhabhomba mbiibhi? Kʉnongwa ye umuntu akʉlonga zye zyizuuye mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umuntu umwinza akʉlonga inyinza, zye zikufuma mʉ mwoyo waakwe umwinza. Woope umuntu umubhiibhi akʉlonga imbiibhi, zye zikufuma mʉ mwoyo waakwe umubhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ɨleelo ɨnkʉbhabhʉʉzya kʉtɨ, izwi lyolyonti lye lɨtakhondeeye lye abhantʉ bhakʉlonga bhakhayɨlaata zyonti pi siku ɨlya kʉlongwa. ");
INSERT INTO mgq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kʉnongwa ye ku mazwi gaakho ʉtɨbhaazɨwe kʉtɨ we mugolosu, na ku mazwi gaakho ʉkhayɨlongwa.” ");
INSERT INTO mgq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pe aBhafalisaayi bhamu na bhamanyizyi abhɨ ndajɨzyo bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Mumanyizyi, tʉkwanza ʉtʉbhombele ɨshɨlolesyo she shɨkʉmanyɨsya kʉtɨ ʉMʉlʉngʉ akusonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","UYeesu akhabhaamʉla akhatɨ, “Ishipaafi ɨsha bhantʉ abhabhomba mbiibhi na bhe bhatalɨ nu wusunde bhakwanza ɨshɨlolesyo! Te ɨmbalanje ɨshɨlolesyo shoshonti, lyoli ɨshɨlolesyo sha mukuwi ʉYoona. ");
INSERT INTO mgq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kʉnongwa ye anza she ʉYoona áyɨkhaaye insiku zɨtatʉ mʉ lwanda mu nswi ɨmpɨtɨ shawusiku na shamʉsanya, she shɨnɨɨsho ʉMwana wa Muntu atɨyɨɨkhale insiku zɨtatʉ mʉ mbɨɨpa shawusiku na shamʉsanya. ");
INSERT INTO mgq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Khabhɨlɨ isiku ɨlya kʉlongwa, abhantʉ abha mu Ninaawi bhoope bhakhayɨmɨɨlɨla kʉbhalonga ɨmwe mʉbha khabhalɨlo ɨkha kʉtɨ mwe bhi mbiibhi. Kʉnongwa ye ʉYoona we alʉmbɨɨlɨla izwi lya Mʉlʉngʉ kʉkwabho, bhakhalaata imbiibhi zyabho. Ishi ɨpa alɨɨpo ʉmʉpɨtɨ kʉshɨla ʉYoona. ");
INSERT INTO mgq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Khabhɨlɨ isiku ɨlya kʉlongwa ʉmwene ʉmwantanda ʉwɨ nsɨ ɨya Sheeba, akhayɨmɨɨlɨla na kʉbhalonga abhantʉ abha khabhalɨlo ɨkha. Kʉnongwa ye ʉweene áfumile mʉ nsɨ ɨya kutali kʉtɨ ayɨnze atejeelezye ɨmanyɨzyo ɨzyɨ njeele ɨzya mwene uSelemaani. Ɨleelo ɨnkʉbhabhʉʉzya ɨmwe kʉtɨ alɨɨpo ɨpa we mʉpɨtɨ kʉmʉshɨla uSelemaani.” ");
INSERT INTO mgq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","UYeesu akhajendeelela kʉlonga akhatɨ, “Ipepu ibhiibhi we lyafuma mwa muntu, lɨkʉzyʉngʉʉla mu shilozu umwumu kwanza apa kʉtʉʉzya. Ɨnga lɨtapaaga, ");
INSERT INTO mgq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pe lɨkʉyɨlonga lɨkʉtɨ, ‘Ɨntɨgalʉshe ku nyumba yaanɨ ye naafumile.’ We lyagalʉkha, lɨkwaga inyumba yiila nyʉʉse, khabhɨlɨ yizelupile akhinza. ");
INSERT INTO mgq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Panaapo pe lɨkʉbhala kwega amapepu amabhiibhi aganjɨ saba, amabhiibhi kʉshɨla lyene. Pe gakwinjila kwa muntu wʉnʉʉyo, gakwɨkhala. Panaapo ʉmʉbhɨlɨ wa muntu wʉnʉʉyo wʉkʉbha akhabhiibhi nhaani, kʉshɨla kʉwandɨlo. Shɨnɨɨsho she yɨkhayɨbha kʉ bhantʉ abha khabhalɨlo ɨkha akhabhiibhi.” ");
INSERT INTO mgq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mʉ khabhalɨlo khakhaala we uYeesu akʉlonga nɨ mpʉga ɨya bhantʉ, unyina na bhakhambakʉ bhaakwe bhakhɨnza na kwɨmɨɨlɨla panzɨ, bhakhanzaga kʉlonga nawo. ");
INSERT INTO mgq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pe umuntu ʉmo akhamʉbhʉʉzya akhatɨ, “Yeenya, unyina waakho na bhakhambakʉ bhaakho bhalɨ panzɨ ɨpo, bhakʉkwanza.” ");
INSERT INTO mgq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ɨleelo uYeesu akhamwamʉla akhatɨ, “Unyina waanɨ wu naanu? Na bhakhambakʉ bhaanɨ bhe bha bhanaanu?” ");
INSERT INTO mgq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pe akhasonda ku bhalandati bhaakwe akhatɨ, “Yeenyi, ɨbha bhe bhanyina bhaanɨ na bhe bhakhambakʉ bhaanɨ! ");
INSERT INTO mgq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kʉnongwa ye umuntu wowonti we akʉbhomba zye ʉTaata waanɨ we alɨ kʉmwanya akwanza, wʉnʉʉyo we wʉ khambakʉ waanɨ, wʉ yɨlʉmbʉ waanɨ, khabhɨlɨ we wu nyina waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pi siku liliila, uYeesu akhasogola mu nyumba yiila, akhabhala kwɨkhala pambalɨ pa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɨmpʉga ɨmpɨtɨ ɨya bhantʉ yɨkhamʉbhʉngaanɨla uYeesu. Pe akhazʉbha mʉ shɨtʉʉlɨ, akhɨɨkhala ɨnga atabijilizanyaaje na bhantʉ. Abhantʉ bhonti bhɨ́mɨlɨɨye pambalɨ pa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","UYeesu akhabhabhʉʉzya amazwi aminji kʉ vɨkholanyo akhatɨ, “Álɨɨpo umupesi ʉmo we ábhalile kʉsansa imbeyu. ");
INSERT INTO mgq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","We akʉsansa, imbeyu zimo zɨkhalendela mwɨ dala, inyonyi zɨkhɨnza na kuzilya. ");
INSERT INTO mgq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imbeyu ɨzyamwabho zɨkhalendela pɨ lyalaawe lye lɨtalɨ nu lusuuto ulwinji, imbeyu zɨnɨɨzyo zɨkhamela nalʉbhɨlo kʉnongwa ye ulusuuto lwámɨle lushe pamwanya. ");
INSERT INTO mgq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ɨleelo we ɨzʉbha lyalama, imbeyu zɨnɨɨzyo zɨkhapwa na kʉnyaala kʉnongwa ye amazi gaakwe gatíishile paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeyu ɨzyamwabho zɨkhalendela mu makwi aga mimvwa. We amimvwa ganaago gaakʉla, gakhazipuuta imbeyu ziila. ");
INSERT INTO mgq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imbeyu ɨzyamwabho zɨkhalendela mu lusuuto uluvunzu, zɨkhamela na kʉkʉla akhinza, zɨkheela, yimo yɨkheela ɨnsanga imia yeeka (100), yimo yɨkheela amashumi ʉmʉtanda, yimo yɨkheela amashumi gatatʉ. ");
INSERT INTO mgq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa!” ");
INSERT INTO mgq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhalandati bha Yeesu bhakhɨnza, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Khooni khe ʉkʉlonga na bhantʉ kʉ vɨkholanyo?” ");
INSERT INTO mgq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Akhabhaamʉla akhatɨ, “Ɨmwe ʉMʉlʉngʉ abhapiiye kʉmanya ɨzya kukwilu ɨzya wʉmwene ʉwa kʉmwanya, ɨleelo abheene atabhapiiye kʉmanya zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kʉnongwa ye we akʉlɨtejeelezya izwi lya Mʉlʉngʉ na kʉlɨmanya, pe ʉMʉlʉngʉ akʉmwavwa kwonjela kʉlɨmanya nhaani. Ɨleelo we atakʉlɨtejeelezya izwi lya Mʉlʉngʉ, ni linsi lye alimanyile lɨkʉfwʉlwa. ");
INSERT INTO mgq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ye nongwa ɨnɨ, ɨnkʉlonga nabho kʉ vɨkholanyo, kʉnongwa ye we bhakwenya, bhatakʉlola. Khabhɨlɨ we bhakʉtejeelezya, bhatakwɨmvwa, awe kʉzyaganya. ");
INSERT INTO mgq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uwukuwi wa Yeesaya wʉkʉkwɨla kʉkwabho we ákuwiilwe kʉtɨ, ‘Mʉkhayɨmvwaga, ɨleelo te mʉkhazyaganyaaje. Mʉkhayɨlolaga, ɨleelo te mʉkhamanyaje. ");
INSERT INTO mgq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kʉnongwa ye abhantʉ bhanaabha amooyo gaabho magomu, amakutwe gaabho gatakwɨmvwa, amiiso gaabho galɨ ngatɨ gatakʉlola. Ɨnga zɨtabhanje shɨnɨɨsho, amiiso gaabho nhanɨ gakʉlola, goope amakutwe gaabho nhanɨ gakwɨmvwa, goope amooyo gaabho nhanɨ gakʉzyaganya, bhaamɨle bhagangalʉshɨla, ɨnga ɨmbatʉʉle.’ ");
INSERT INTO mgq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ɨleelo musayiilwe ɨmwe, kʉnongwa ye amiiso giinyu gakʉlola na makutwe giinyu gakwɨmvwa. ");
INSERT INTO mgq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, abhakuwi abhinji na bhagolosu bháyiganile kʉzɨlola zye mʉkʉzɨlola ɨmwe, ɨleelo bhatázilolile. Khabhɨlɨ bháyiganile kwɨmvwa zye mʉkwɨmvwa ɨmwe, ɨleelo bhatázyimvwizye. ");
INSERT INTO mgq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tejeelezyi uwilulanyo ʉwa mupesi uwi mbeyu. ");
INSERT INTO mgq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Umuntu wowonti we akwɨmvwa izwi kʉ zya wʉmwene ʉwa kʉmwanya, ɨleelo atakʉzyaganya, ʉmʉbhomba mbiibhi uSeetani akwɨnza na kʉlɨnyamvʉla lye ʉMʉlʉngʉ awaalile mukaasi mʉ mwoyo waakwe. Ɨnɨ ye mbeyu ye yálendeeye mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbeyu ye yálendeeye mwɨ lyalaawe lye lɨtalɨ nu lusuuto ulwinji, yɨkʉkholana nu muntu we akwɨmvwa izwi lya Mʉlʉngʉ, nalʉbhɨlo akʉlɨposheela kʉ lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ɨleelo kʉnongwa ye atalɨ na mazi mukaasi yaakwe, izwi lɨnɨɨlyo lɨkwɨkhala kʉ khabhalɨlo khashe. Ɨnga kweleela awe kʉyɨmba kwamwaga kʉnongwa yi zwi lya Mʉlʉngʉ, nalʉbhɨlo akʉlɨlekha. ");
INSERT INTO mgq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbeyu ye yálendeeye mu mimvwa, yɨkʉkholana nu muntu we akwɨmvwa izwi lya Mʉlʉngʉ. Ɨleelo kʉnongwa ɨya kʉpɨlɨnhana nɨ mbombo ɨzya mʉ nsɨ na kʉkhopelwa nɨ nsʉngʉkho ɨzya kwanza uwudumbwe, vwonti vɨnɨɨvwo vikulipuuta izwi kʉtɨ lɨteelaje amatunda. ");
INSERT INTO mgq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɨleelo imbeyu yiila ye yálendeeye mu lusuuto uluvunzu, yɨkʉkholana na bhantʉ bhe bhakwɨmvwa izwi lya Mʉlʉngʉ na kʉlyaganya. Abhantʉ bhanaabho bhe bhakwela amatunda, ʉmo imia yeeka (100), ʉmo amashumi ʉmʉtanda nʉ wamwabho amashumi gatatʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","UYeesu akhabhabhʉʉzya ɨshɨkholanyo ɨshamwabho akhatɨ, “Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nu muntu we ápesile imbeyu inyinza mu shiizi shaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ɨleelo we abhantʉ bhonti bhagonile, ʉmʉlʉgʉ waakwe akhɨnza akhapesa ɨndezya mʉmwanya mʉ ngano, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","We ɨngano yɨnɨɨyo yaamela na kwanda kwela, ɨndezya zyope zɨkhalolekha. ");
INSERT INTO mgq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Abhabhombi abha wi shiizi bhakhabhala kʉmʉbhʉzɨɨlɨzya bhakhatɨ, ‘Mwene, ɨwe waawaalile imbeyu inyinza mu shiizi shaakho. Bhʉlɨ, ɨndezya ziila zifumile kwoshi?’ ");
INSERT INTO mgq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Akhabhaamʉla akhatɨ, ‘Ʉmʉlʉgʉ we abhombile ziniizi.’ Abhabhombi bhaakwe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, ‘Bhʉlɨ, ʉkwanza tʉbhale tuguunye?’ ");
INSERT INTO mgq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Woope akhatɨ, ‘Ndaali, mʉtakhasheele kuguunya kʉnongwa ye ɨnga mwaguunya ɨndezya, mutakhaguunye peeka nɨ ngano. ");
INSERT INTO mgq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vɨleshe vwonti vɨkʉle peeka kufishila mʉ khabhalɨlo akhi mvuno. Mʉ khabhalɨlo khanaakho, ɨnhayɨbhabhʉʉzya abhavuni kʉtɨ bhabhʉngaanye suuti ɨndezya na kupinya mu nsunza kʉtɨ bhayɨpembe. Ɨleelo ɨngano bhayɨbhʉngaanye na kusengula mʉ shanga shaanɨ.’ ” ");
INSERT INTO mgq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","UYeesu akhabhabhʉʉzya ɨshɨkholanyo ɨshamwabho akhatɨ, “Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana na khasanga akhansi akhi nhaladaali khe umuntu áwaalile mu shiizi shaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Akhasanga khanaakho khansi nhaani kʉshɨla ɨsanga izinji zyonti, ɨleelo ɨnga khaamela khakʉbha khapɨtɨ kʉshɨla ɨvɨmela vwonti ɨvwa kʉwaala vwe vɨlɨ mu vwizi. Akhasanga khanaakho khakʉbha likwi lye inyonyi zɨkwɨnza kʉtenjela ivwanswi mʉ mpaaswa zyakwe.” ");
INSERT INTO mgq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","UYeesu akhabhabhʉʉzya ɨshɨkholanyo ɨshamwabho akhatɨ, “Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nu wusafu we ʉmwantanda áyeejile, akhasangaanya nu wusu amadebe gatatʉ. We akhandʉlanya, uwusafu wuula wukhadudula uwusu wonti.” ");
INSERT INTO mgq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","UYeesu akhayɨbhʉzyaga ɨmpʉga ɨya bhantʉ zɨnɨɨzyo zyonti kʉ vɨkholanyo. Atakhalongaga lyolyonti kʉkwabho sita shɨkholanyo. ");
INSERT INTO mgq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zɨnɨɨzyo zyábhombeshile kʉtɨ izwi liila lɨkwɨle lye umukuwi álonjile kʉtɨ, “Ɨnhayɨlonga na bhantʉ kʉ vɨkholanyo. Inhayivundula zye zifisiilwe kufuma pe ʉMʉlʉngʉ ápelile ɨnsɨ yonti.” ");
INSERT INTO mgq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pe uYeesu akhayɨlaga ɨmpʉga yiila, akhinjila mu nyumba. Abhalandati bhaakwe bhakhabhala, bhakhamʉbhʉʉzya bhakhatɨ, “Twilulile kwe kʉtɨ bhʉlɨ ɨshɨkholanyo ɨshɨ ndezya zye zyámɨle mu shiizi.” ");
INSERT INTO mgq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","UYeesu akhabhaamʉla akhatɨ, “We áwaalile imbeyu inyinza Mwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ishiizi shiila nsɨ, imbeyu inyinza bhantʉ abha wʉmwene ʉwa kʉmwanya, ɨndezya ziila bhantʉ bha mʉbhomba mbiibhi uSeetani. ");
INSERT INTO mgq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ʉmʉlʉgʉ we áyinzile kʉpesa ɨndezya mʉbhomba mbiibhi uSeetani. Kuvuna lisiku ɨlya kʉmpeleela ɨlya kʉlongwa ɨnsɨ, abhavuni bhabhakhabhɨzya bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Anza she abhabhombi abhi shiizi bhakuguunya na kʉpemba ɨndezya mʉ mwoto, she yɨkhayɨbha pi siku ɨlya kʉmpeleela ɨlya kʉlongwa ɨnsɨ. ");
INSERT INTO mgq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ɄMwana wa Muntu akhayɨbhasonteelezya abhakhabhɨzya bhaakwe kʉtɨ bhabhʉngaanɨshe kufuma mʉ wʉmwene waakwe abhantʉ bhonti bhe bhakwazya imbiibhi na bhabhomba mbiibhi bhonti. ");
INSERT INTO mgq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Abhakhabhɨzya bhakhayɨbhasʉmba bhonti bhanaabho mwi tanuli ɨlya mwoto, mʉnʉʉmwo mwe bhakhayɨlɨla, na kuzyekusya amiino. ");
INSERT INTO mgq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pe abhantʉ bhonti bhe bhagolosu, bhakhayɨlama ngatɨ lɨzʉbha mʉ wʉmwene wa Taata waabho. Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa! ");
INSERT INTO mgq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana na khantʉ akhɨ nhela ɨmpɨtɨ khe kháfisiilwe mu shiizi. We umuntu weeka akhaaga, akhafisa. Kʉ lʉseshelo, akhabhala akhakazya vwonti vwe áamɨle navwo, akhakala ishiizi shiila. ");
INSERT INTO mgq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Khabhɨlɨ ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nu mukazyi weeka we ábhalile kwanza iwe ɨlyɨ nhela ɨmpɨtɨ nhaani kʉshɨla aganjɨ gonti. ");
INSERT INTO mgq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","We alyaga iwe lyeka ɨlyɨ nhela ɨmpɨtɨ nhaani, akhakazya ivintu vwonti vwe áamɨle navwo, akhalɨkala. ");
INSERT INTO mgq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Khabhɨlɨ ʉwʉmwene ʉwa kʉmwanya wukholiine nu waavu we abhazubhuli bhátejile mwa sʉmbɨ. We bhaatega, uwaavu wʉkhalema inswi ɨzya vɨkholo nɨ vɨkholo. ");
INSERT INTO mgq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","We uwaavu wuula wiizula, abhazubhuli bhakhawʉkwesa kʉwʉtwala kwɨsyɨla kwa sʉmbɨ. Pe bhakhɨɨkhala bhakhabhʉngaanɨkha inswi inyinza mʉ vɨtʉndʉ, ɨleelo inswi imbiibhi bhakhataaga. ");
INSERT INTO mgq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Shɨnɨɨsho she yɨkhayɨbha pi siku ɨlya kʉmpeleela ɨlya kʉlongwa ɨnsɨ. Abhakhabhɨzya bha Mʉlʉngʉ bhakhayɨbhagabhʉlanya abhabhomba mbiibhi na bhagolosu. ");
INSERT INTO mgq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abhakhabhɨzya bhakhayɨbhasʉmba abhi mbiibhi mwi tanuli ɨlya mwoto, mʉnʉʉmwo mwe bhakhayɨlɨla na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","UYeesu akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Bhʉlɨ, mwazyaganya zyonti zɨnɨɨzyo?” Bhoope bhakhamwamʉla bhakhatɨ, “Twazyaganya.” ");
INSERT INTO mgq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Woope akhabhaamʉla akhatɨ, “Kʉnongwa yɨnɨɨyo, umumanyizyi wowonti ʉwɨ ndajɨzyo zya Moose we akʉbha mulandati mʉ wʉmwene ʉwa kʉmwanya, akʉkholana nu wi nyumba we akufumwa mʉ shʉʉma shaakwe ivintu ivipwa nɨ vwɨ maandɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","We uYeesu aamala kʉlonga ɨvɨkholanyo vɨnɨɨvwo, akhasogola paala. ");
INSERT INTO mgq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","We aafikha mʉ nhaaya ɨya kʉkwabho, akhanda kʉbhamanyɨzya abhantʉ mwi sinagoogi. Abhantʉ bhakhaswiga bhakhabhʉzɨlɨzanya bhakhatɨ, “Umuntu wʉnʉʉnʉ azyajile kwoshi ɨnjeele ziniizi nʉ waamʉlo ʉwa kʉbhomba amayele ganaaga? ");
INSERT INTO mgq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bhʉlɨ, wʉnʉʉnʉ te mwana wa mukelesi? Bhʉlɨ, ɨtaawa lya nyina waakwe te wu Maliya? Bhʉlɨ, abhakhambakʉ bhaakwe te wʉ Yaakobo, uYoosefu, uSiimoni nʉ Yʉʉda? ");
INSERT INTO mgq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bhʉlɨ, abhayɨlʉmbʉ bhaakwe bhonti tʉtakwɨkhala nabho panaapa? Pe wʉnʉʉnʉ azyajile kwoshi ziniizi zyonti?” ");
INSERT INTO mgq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pe bhakhakhaana kʉmwɨtɨkha. Ɨleelo uYeesu akhabhabhʉʉzya akhatɨ, “Abhantʉ bhakumushindikha umukuwi ukunji kwonti, ɨleelo abha mʉ nhaaya yaakwe na bha mu nyumba yaakwe bhatakumushindikha.” ");
INSERT INTO mgq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kʉnongwa ye abhantʉ bhaala bhatáamɨle nʉ lwɨtɨkho, uYeesu atábhombile amayele aminji kuula. ");
INSERT INTO mgq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mʉ khabhalɨlo khaala ʉmwene uHeloodi akhɨmvwa zye uYeesu akhabhombaga. ");
INSERT INTO mgq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Akhabhabhʉʉzya abhabhombi bhaakwe akhatɨ, “Wʉnʉʉyo wu Yookhani uMwozyi azyushile kufuma kʉ bhafwe. Ye nongwa ɨnɨ, akʉbhomba amayele amapɨtɨ anza ganaago.” ");
INSERT INTO mgq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","UHeloodi álonjile shɨnɨɨsho kʉnongwa ye ámulemile uYookhani, akhamupinya na kʉmʉkʉnga mwɨ jeela. Ámukunjile kʉnongwa ɨya Helodiya we áamɨle mʉshɨ wa Filipo, ʉkhambakʉ waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kʉnongwa ye uYookhani akhamʉbhʉzyaga uHeloodi akhatɨnjɨ, “Mwinho pamiiso ga Mʉlʉngʉ kwega ʉmwantanda wʉnʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pe uHeloodi akhanzaga ɨdala ɨlya kʉmʉgoga uYookhani, ɨleelo akhogopaga abhantʉ kʉnongwa ye bhámwitishile uYookhani uMwozyi kʉtɨ mukuwi. ");
INSERT INTO mgq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","We lyafikha isiku ɨlya kʉkʉmbʉkha kʉpaapwa kwa mwene uHeloodi, ʉmwalɨ wa Helodiya akhavina pɨlongolela pa bhajeni. We aavina, uHeloodi akhasha nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Akhafinga na kʉlapa kuumupa khokhonti khe ʉmwalɨ waakwe atɨmʉlaabhe. ");
INSERT INTO mgq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pe unyina waakwe akhamʉsonjeelezya ʉmwalɨ kʉtɨ amʉbhʉʉzye uHeloodi atɨ, “Nampe shiniishi itwe lya Yookhani uMwozyi mʉ nselo.” ");
INSERT INTO mgq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ʉmwene akhayibhuna nhaani, ɨleelo kʉnongwa ɨya lufingo lwe álapile pɨlongolela pa bhajeni bhaala, akhalajɨzya kʉtɨ bhaamupe. ");
INSERT INTO mgq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","UHeloodi akhamʉsonteelezya umuntu kʉtɨ abhale kumudumula uYookhani itwe mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umuntu ʉla akhɨnza ni twe lya Yookhani mʉ nselo, akhaamupa ʉmʉlɨndʉ ʉla, woope akhaamupa unyina waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Abhalandati bha Yookhani bhakhabhala bhakheega ivimba lyakwe, bhakhalɨsyɨla. Bhakhabhala kʉmʉbhʉʉzya uYeesu zyonti zye zyáfumiiye. ");
INSERT INTO mgq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","We uYeesu ayɨmvwa zyonti zɨnɨɨzyo, akhasogola paala nɨ shɨtʉʉlɨ akhabhala kwe kʉtáamɨle na bhantʉ. Ɨleelo we abhantʉ bhɨmvwa, bhakhamʉtangʉlɨla, bhakhajenda nɨ vɨnama kufuma mʉ nhaaya. ");
INSERT INTO mgq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","We ayiikha mʉ shɨtʉʉlɨ, akhayɨlola ɨmpʉga ɨmpɨtɨ ɨya bhantʉ. We abhalola, akhabhalolela ishisa, akhabhaponɨa abhabhinu bhaabho. ");
INSERT INTO mgq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","We kwabha shalyabheela, abhalandati bhaakwe bhakhabhala bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Ɨpa pe tʉlɨ shilozu sheene, uwusiku wʉpalamɨɨye. Ishi, bhalaje abhantʉ ɨbha ɨnga bhabhale bhayɨkalɨle bhɨɨbho ivwakulya mʉ tʉkhaaya.” ");
INSERT INTO mgq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ɨleelo uYeesu akhabhaamʉla akhatɨ, “Bhatakwanzɨwa kʉsogola. Bhape mʉneemwe ishaakulya!” ");
INSERT INTO mgq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bhoope bhakhamwamʉla bhakhatɨ, “Tʉlɨ na makaati gasaanʉ bhʉʉlo ni nswi zɨbhɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","UYeesu akhatɨ, “Ndeeteli ɨpa.” ");
INSERT INTO mgq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pe akhabhalajɨzya abhantʉ bhaala kʉtɨ bhɨɨkhale mʉ malaala. Akheega amakaati gaala gasaanʉ ni nswi ziila zɨbhɨlɨ, akheenya kʉmwanya, akhavɨsaya. Akhamensulanyaaga amakaati gaala, akhabhapanga abhalandati bhaakwe, bhoope bhakhabhagabhɨla abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abhantʉ bhonti bhakhalya, bhakhiikuta. Abhalandati bhaakwe bhakhabhʉngaanya ɨnsenyenha, zikhiizula ɨvɨtʉndʉ ishumi na vɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abhantʉ bhe bháliiye ishaakulya shiila, bháamɨle abhasakhaala ielufu zɨsaanʉ (5,000) sita kʉbhaazya abhantanda na bhaana. ");
INSERT INTO mgq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nalʉbhɨlo, uYeesu akhabhabijila abhalandati bhaakwe kʉtɨ bhinjile mʉ shɨtʉʉlɨ, bhalongolele kʉbhala kwɨsyɨla ɨya sʉmbɨ ʉwa Galɨlaaya we akʉyɨlaga ɨmpʉga ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","We ayɨlaga ɨmpʉga yiila ɨya bhantʉ, uYeesu akhazʉbha wʉʉyo mwene mwɨ gamba kupuuta. We kwabha na khabhʉbhɨɨla, áamɨle mwene mwɨ gamba. ");
INSERT INTO mgq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mʉ khabhalɨlo khanaakho ɨshɨtʉʉlɨ sháfishile pakaasi pa sʉmbɨ, ɨleelo amabhilingwa gakhashɨkhomaga kʉnongwa ye impepu yikhavugulaga kʉbhala ukunji. ");
INSERT INTO mgq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kʉ masheelo, uYeesu akhafikha pe abhalandati bhaakwe bháamɨle akhajendaga pamwanya pa minzi. ");
INSERT INTO mgq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ɨleelo we abhalandati bhaakwe bhamʉlola uYeesu akʉjenda pamwanya pa minzi, bhakhoogopa nhaani bhakhakhoola kʉ lyoga bhakhatɨ, “Muzimu!” ");
INSERT INTO mgq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nalʉbhɨlo, uYeesu akhabhabhʉʉzya akhatɨ, “Yɨgomwaje ʉmwoyo, mʉtogopaje khaala, neene!” ");
INSERT INTO mgq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","UPeeteli akhamwamʉla akhatɨ, “Mwene, ɨnga weewe nalyoli, nɨtɨshɨzye kʉtɨ ɨnɨnze kʉkwakho, ɨnjende pamwanya pa minzi.” ");
INSERT INTO mgq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","UYeesu akhamwamʉla akhatɨ, “Nzaaga.” UPeeteli akhiikha mʉ shɨtʉʉlɨ, akhanda kʉjenda pamwanya pa minzi kʉbhala kwa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ɨleelo we ayɨlola impepu, akhoogopa, akhanda kuswibha. Pe akhakhoola akhatɨ, “We Mwene, ntʉʉle!” ");
INSERT INTO mgq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nalʉbhɨlo, uYeesu akhagolosya ɨnyoobhe, akhamʉlema, akhamʉbhʉʉzya akhatɨ, “Ɨwe wʉwa lwɨtɨkho ulunsi, khooni khe ʉkʉyʉnjɨɨla?” ");
INSERT INTO mgq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","We uYeesu nu Peeteli bhinjila mʉ shɨtʉʉlɨ, impepu yɨkhalekha kuvugula. ");
INSERT INTO mgq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bhe bháamɨle mʉ shɨtʉʉlɨ, bhakhamupuuta uYeesu bhakhatɨ, “Nalyoli ɨwe we Mwana wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","We uYeesu na bhalandati bhaakwe bhafumiila ʉsʉmbɨ ʉwa Galɨlaaya, bhakhafikha mʉmbalɨ yɨ nhaaya ɨya mu Genezaleeti. ");
INSERT INTO mgq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","We abhantʉ abha mʉ nhaaya yiila bhaamanya kʉtɨ wu Yeesu, bhakhavwɨnsya intumi zyakwe mʉ nsɨ yiila yonti. Pe abhantʉ bhakhamʉletelaga abhabhinu bhonti. ");
INSERT INTO mgq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhoope bhakhamʉlambaga uYeesu kʉtɨ abhɨtɨshɨzye bhapalamansye mwi pindilwi ɨlya mwenda waakwe lyene. Pe abhabhinu bhonti bhe bhápalamansiizye, bháponile. ");
INSERT INTO mgq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pɨlongolela, aBhafalisaayi bhamu na bhamanyizyi abhɨ ndajɨzyo bhínzile kufuma ku Yelusaleemu. Bhakhabhala kwa Yeesu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Khooni khe abhalandati bhaakho bhatakʉlandata aminho ge abhamaama bhɨɨtʉ bhátʉlesheeye? Tʉkʉlonga shɨnɨɨsho kʉnongwa ye bhakulya ishaakulya sita kʉlandata ɨndajɨzyo ɨzya kʉgeeza ɨnyoobhe!” ");
INSERT INTO mgq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","UYeesu akhabhaamʉla akhatɨ, “Khooni khe nɨɨmwe mutakutinikha ɨndajɨzyo ya Mʉlʉngʉ kʉnongwa ɨya kʉlandata aminho giinyu? ");
INSERT INTO mgq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɨnkʉlonga shɨnɨɨsho kʉnongwa ye ʉMʉlʉngʉ átɨlɨ, ‘Umushindikhaje uyise waakho nu nyina waakho.’ Khabhɨlɨ átɨlɨ, ‘Wowonti we akumuliga uyise waakwe awe unyina waakwe, yɨkhondeeye agogwe.’ ");
INSERT INTO mgq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ɨleelo ɨmwe mʉkʉlonga kʉtɨ umuntu akwɨtɨshɨlwa kʉmʉbhʉʉzya uyise waakwe awe unyina waakwe kʉtɨ, ‘Ivintu vwe nhanɨ nakwavwa, ɨmvɨsabhʉʉye kumufumwizya ʉMʉlʉngʉ.’ ");
INSERT INTO mgq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pe shɨnɨɨsho, mʉkʉlonga kʉtɨ umuntu atakwanzɨwa kumushindikha uyise waakwe awe unyina waakwe. Shɨnɨɨsho she mʉkʉshoolanya izwi lya Mʉlʉngʉ kwɨ dala ɨlya kʉlandata aminho giinyu. ");
INSERT INTO mgq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɨmwe mubhi shisa ɨshɨ lenga! Umukuwi ʉYeesaya áfumwizye uwukuwi ʉwa nalyoli kukwinyu kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abhantʉ ɨbha bhakunshindikha ku mazwi meene, ɨleelo amooyo gaabho galɨ ukutali nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bhakumpuuta ʉlwa khasa. Zyope zye bhakʉmanyɨzya ndajɨzyo zye zikufumilana na minho ga bhantʉ.’” ");
INSERT INTO mgq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pe uYeesu akhayɨbhɨlɨshɨla ɨmpʉga ɨya bhantʉ, akhayɨbhʉʉzya akhatɨ, “Tejeelezyi, mʉzyaganye! ");
INSERT INTO mgq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Te vintu vwe vikwinjila mwi lomu, vwe vɨkʉmʉbhɨɨkha umuntu kʉbha mukhandamanu. Lyoli ziila zye zikufuma mwi lomu, zye zɨkʉmʉbhɨɨkha umuntu kʉbha mukhandamanu.” ");
INSERT INTO mgq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pe abhalandati bha Yeesu bhakhabhala kʉkwakwe, bhakhamʉbhʉʉzya bhakhatɨ, “Umanyile kʉtɨ aBhafalisaayi we bhɨmvwa amazwi ge waalonjile, gaabhavisiizye nhaani?” ");
INSERT INTO mgq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","UYeesu akhabhaamʉla akhatɨ, “ɄTaata waanɨ we alɨ kʉmwanya akhayiguunya imbeyu zyonti zye atáwaalile wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bhaleshe, kʉnongwa ye bhanaabho bhafuuye amiiso, khabhɨlɨ bhakʉbhalongola bhe bhafuuye amiiso! Ɨnga umufwe amiiso akʉmʉlongola ʉwamwabho we afuuye amiiso, bhonti bhabhɨlɨ bhakʉlendela mu lyina!” ");
INSERT INTO mgq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ɨleelo uPeeteli akhamʉbhʉʉzya akhatɨ, “Twilulile ɨshɨkholanyo kʉ zya vintu vwe vɨkʉmʉbhɨɨkha umuntu kʉbha mukhandamanu.” ");
INSERT INTO mgq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","UYeesu akhabhaamʉla akhatɨ, “Ishi nɨɨmwe mʉtalɨ nɨ njeele ɨzya kʉshɨmanya ɨshɨkholanyo? ");
INSERT INTO mgq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mutamanyile kʉtɨ khokhonti khe khakwinjila mwi lomu, khakushizanya bhʉʉlo mʉ lwanda, kʉwʉmalɨlɨshɨlo khakʉtaagwa mʉ shɨkwɨlo? ");
INSERT INTO mgq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ɨleelo zye zikufuma mwi lomu, zikufuma mʉ mwoyo waakwe. Zɨnɨɨzyo zye zɨkʉmʉbhɨɨkha umuntu kʉbha mukhandamanu. ");
INSERT INTO mgq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kʉnongwa ye mʉ mwoyo, mukufuma ɨnsɨɨbho imbiibhi, uwugoji, uwubhembu, uwelengani, uwiibha, uwukeeti ʉwɨ lenga nɨ nshoolanyo. ");
INSERT INTO mgq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Zɨnɨɨzyo zye zɨkʉmʉbhɨɨkha umuntu kʉbha mukhandamanu. Ɨleelo kulya ishaakulya sita kʉgeeza ɨnyoobhe kʉtakʉmʉbhɨɨkha umuntu kʉbha mukhandamanu.” ");
INSERT INTO mgq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","UYeesu akhasogola paala, akhabhala kʉmbalɨ ɨya kʉ nhaaya ɨzya Tiilo ni Sidooni. ");
INSERT INTO mgq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pe ʉmwantanda weeka ʉMʉkananaayo we akhɨkhalaga kʉnʉʉkwo, akhɨnza kwa Yeesu, akhalamba kwi zi ɨlya kʉdandɨzya akhatɨ, “We Mwene, ʉwa shɨkholo sha mwene uDaudi ʉndolele ishisa! Ʉmwalɨ waanɨ alemiilwe nhaani ni pepu ibhiibhi.” ");
INSERT INTO mgq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ɨleelo uYeesu atakhaamʉla izwi lyolyonti. Pe abhalandati bhaakwe bhakhamʉsejeelela, bhakhamʉlamba bhakhatɨ, “Mʉbhʉʉzye asogole, kʉnongwa ye ʉmwantanda wʉnʉʉnʉ akuzingula ɨshongo kʉlʉsalo kʉkwɨtʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Akhabhaamʉla akhatɨ, “ɄMʉlʉngʉ ánsonteleziizye kʉbhatʉʉla aBhaisilaeli bhe bhalɨ ngatɨ ngoole zye ziteejile.” ");
INSERT INTO mgq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ʉmwantanda ʉla akhɨnza, akhasʉgamɨla pɨlongolela pa Yeesu, akhamʉlamba akhatɨ, “We Mwene, ɨnkʉkʉlaabha ʉnaavwe!” ");
INSERT INTO mgq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","UYeesu akhamwamʉla akhatɨ, “Te khinza kwega ishaakulya sha bhaana na kʉzɨsʉmbɨla ɨmbwa.” ");
INSERT INTO mgq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ʉmwantanda ʉla akhatɨ, “She zɨlɨ Mwene, ɨleelo ɨmbwa zyope zikulya ɨnsenyenha zye zɨkʉlenda paasɨ pa vintalati vwa bhapɨtɨ bhaabho.” ");
INSERT INTO mgq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","UYeesu akhamwamʉla akhatɨ, “Wʉmwantanda ɨwe, ʉlwɨtɨkho lwakho lʉpɨtɨ nhaani! Yɨbhe shɨnɨɨsho anza she ʉkwanza.” Nalʉbhɨlo, ʉmwalɨ waakwe akhapona akhabhalɨlo khakhaala. ");
INSERT INTO mgq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","UYeesu akhasogola paala akhashɨla kʉmbalɨ ɨya sʉmbɨ ʉwa Galɨlaaya, akhazʉbha mwɨ gamba, akhɨɨkhala kʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abhantʉ abhinji nhaani bhakhabhala kwa Yeesu, bhakhabhaleeta bhe bhalemaaye, bhe bhafuuye amiiso, bhe bhafuuye ɨvɨnama, abhashinuunu na bhabhinu abhanjɨ abhinji. Bhakhabhabhɨɨkha pa vɨnama pa Yeesu, woope akhabhaponɨa. ");
INSERT INTO mgq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɨmpʉga ɨya bhantʉ bhaala bhakhaswiga nhaani we bhabhalola abhashinuunu bhakʉlonga, bhe bhalemaaye bhakʉpona, bhe bhafuuye ɨvɨnama bhakʉjenda, bhe bhafuuye amiiso bhakʉlola. Bhakhamʉpaala ʉMʉlʉngʉ ʉwa Bhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pe uYeesu akhabhabhɨlɨshɨla abhalandati bhaakwe, akhabhabhʉʉzya akhatɨ, “Ɨnkʉbhalolela ishisa abhantʉ ɨbha kʉnongwa ye nɨɨkhala nabho insiku zɨtatʉ, ɨleelo bhatalɨ ni shaakulya. Ɨntakwanza kʉtɨ ɨmbalaje ɨnga bhasogole kʉkwabho we bhalɨ nɨ nzala, bhatakhashe bhazilishe mwɨ dala.” ");
INSERT INTO mgq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abhalandati bhaakwe bhakhamwamʉla bhakhatɨ, “Ɨpa tʉlɨ pa shilozu, tʉtɨgaaje kwoshi amakaati aga kʉbhakwɨla abhantʉ bhonti abhinji ɨbha?” ");
INSERT INTO mgq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉlɨ na makaati galɨnga?” Bhakhamwamʉla bhakhatɨ, “Tʉlɨ na makaati saba nu tuswi tushe.” ");
INSERT INTO mgq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pe uYeesu akhabhalajɨzya abhantʉ bhonti kʉtɨ bhɨɨkhale paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akheega amakaati gaala saba nu tuswi, akhamusalifwa ʉMʉlʉngʉ, akhamensulanya, akhabhapanga abhalandati bhaakwe, bhoope bhakhabhagabhɨlaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhonti bhakhalya, bhakhiikuta. Abhalandati bhakhabhʉngaanya ɨnsenyenha zye zyásyalile, zikhiizula ɨvɨtʉndʉ saba. ");
INSERT INTO mgq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abhantʉ bhe bháliiye ishaakulya shiila bháamɨle abhasakhaala ielufu zini (4,000) sita kʉbhaazya abhantanda na bhaana. ");
INSERT INTO mgq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","We abhalaga abhantʉ bhaala, uYeesu akhinjila mʉ shɨtʉʉlɨ, akhabhala kʉmbalɨ ɨyɨ nhaaya ɨya mu Magadaani. ");
INSERT INTO mgq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pɨlongolela, aBhafalisaayi na Bhasadukaayi bhamu bhínzile kwa Yeesu, kʉmʉlɨnga bhakhamʉlaabha kʉtɨ alolesye ɨshɨlolesyo she shɨkʉmanyɨsya kʉtɨ afumile kʉmwanya kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","UYeesu akhabhaamʉla akhatɨ, “We yaafikha shalyabheela, mʉkʉtɨ, ‘Ɨndaabhɨ kukhayisha akhinza kʉnongwa ye kʉmwanya kuzelu.’ ");
INSERT INTO mgq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɨleelo mʉ khabhalɨlo akha shɨlaabhɨla mʉkʉlonga mʉkʉtɨ, ‘Ʉmʉsanyʉʉnʉ imvula yɨtɨtoonye kʉnongwa ye kʉmwanya kwilu, khabhɨlɨ kʉlɨ na mabhɨngo.’ Ɨmwe mumanyile kʉzyaganya ɨzya khabhalɨlo kwɨ dala ɨlya kwenya kʉmwanya, ɨleelo kʉvwaganya ɨvɨlolesyo ɨvwa khabhalɨlo ɨkha mutamanyile. ");
INSERT INTO mgq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ishipaafi ɨsha bhantʉ abhabhomba mbiibhi na bhe bhatalɨ nu wusunde bhakwanza ɨshɨlolesyo. Te ɨmbalanje ɨshɨlolesyo shoshonti, lyoli ɨshɨlolesyo sha mukuwi ʉYoona.” Pe uYeesu akhabhalekha, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","We abhalandati bha Yeesu bhafumiila ʉsʉmbɨ, bhakhakʉmbʉkha kʉtɨ bhíwiilwe kʉpaya amakaati. ");
INSERT INTO mgq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","UYeesu akhabhabhʉʉzya akhatɨ, “Mwenyaaje nhaani, na kʉbha amiiso nu wusafu wa Bhafalisaayi nʉ wa Bhasadukaayi.” ");
INSERT INTO mgq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhalandati bhaala bhakhanda kʉzaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Akʉlonga shɨnɨɨsho kʉnongwa ye tutapayile amakaati.” ");
INSERT INTO mgq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","UYeesu ámanyile zye bhakʉzaabhana, akhabhabhʉʉzya akhatɨ, “Ɨmwe mʉbha lwɨtɨkho ulunsi! Khooni khe mʉkʉzaabhana mʉneemwe na mʉneemwe kʉtɨ mʉtalɨ na makaati? ");
INSERT INTO mgq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bhʉlɨ, mʉlɨ she mʉtakʉzyaganya? Bhʉlɨ, mʉtakʉkʉmbʉkha amakaati gasaanʉ gaala ge gíkusiizye abhantʉ ielufu zɨsaanʉ (5,000), bhʉlɨ, mwízuziizye ɨnsenyenha ɨvɨtʉndʉ vɨlɨnga? ");
INSERT INTO mgq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Awe amakaati gaala saba ge gíkusiizye abhantʉ bhaala ielufu zini (4,000), bhʉlɨ mwábhunganyiinye ɨnsenyenha ɨvɨtʉndʉ vɨlɨnga? ");
INSERT INTO mgq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Khooni khe mʉtakʉzyaganya kʉtɨ zɨnɨɨzyo zye ɨnkʉlonga te zya makaati? Lyoli mʉbhe amiiso nu wusafu ʉwa Bhafalisaayi nʉ wa Bhasadukaayi.” ");
INSERT INTO mgq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pe abhalandati bhaakwe bhakhazyaganya kʉtɨ atakhalongaga ɨzya wusafu ʉwa makaati, lyoli kʉ zyɨ manyɨzyo ɨzyɨ lenga ɨzya Bhafalisaayi na Bhasadukaayi. ");
INSERT INTO mgq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","We uYeesu peeka na bhalandati bhaakwe bhaafikha kʉmbalɨ ɨya ku Kaisaliya Filiipi, akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Ishi abhantʉ bhakʉtɨ ʉMwana wa Muntu wu naanu?” ");
INSERT INTO mgq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakhamwamʉla bhakhatɨ, “Bhamu bhakʉtɨ we Yookhani uMwozyi, bhamu bhakʉtɨ we Eliya, bhamu bhakʉtɨ we Yelemiya awe weeka mu bhakuwi abhamwabho.” ");
INSERT INTO mgq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","UYeesu akhabhʉzɨɨlɨzya winza akhatɨ, “Nɨɨmwe, mʉkʉtɨ ɨne ne naanu?” ");
INSERT INTO mgq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","USiimoni Peeteli akhamwamʉla akhatɨ, “Ɨwe we Kilisiti, ʉMwana wa Mʉlʉngʉ we mwumi.” ");
INSERT INTO mgq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","UYeesu akhamʉbhʉʉzya akhatɨ, “Usayiilwe ɨwe Siimoni mwana wa Yoona, kʉnongwa ye atalɨɨpo umuntu we akulanjile zɨnɨɨzyo, lyoli wʉ Taata waanɨ we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ɨne ɨnkʉkʉbhʉʉzya kʉtɨ ɨwe, we Peeteli, pamwanya pɨ lyalaawe ili, ɨntɨzenje ɨshɨbhanza shaanɨ na makha aga kwɨlongo te gakhashɨtole. ");
INSERT INTO mgq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nɨɨne intiikupe imfungulo ɨzya wʉmwene ʉwa kʉmwanya, nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, lyolyonti lye mwalɨkhaana mʉ nsɨ, lɨtɨbhe lyakhaanwa kʉmwanya. Khabhɨlɨ lyolyonti lye mwalyɨtɨshɨzya mʉ nsɨ, lɨtɨbhe lyɨtɨshɨlwa na kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","UYeesu akhabhasokha abhalandati bhaakwe kʉtɨ bhatakhamʉbhʉʉzye umuntu wowonti kʉtɨ ʉweene we wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kwandɨla akhabhalɨlo khanaakho, uYeesu akhanda kʉbhabhʉʉzya abhalandati bhaakwe kʉtɨ yɨkwanzɨwa abhale ku Yelusaleemu na kʉyɨmba amayɨmba amapɨtɨ kufuma kʉ bhasongo abha Bhayahuudi, kʉ bhapɨtɨ abha bhapuutili na ku bhamanyizyi abhɨ ndajɨzyo. Akhayɨgogwa, ɨleelo akhayɨzyʉkha isiku ɨlya wʉtatʉ. ");
INSERT INTO mgq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","UPeeteli akhabhala nawo pambalɨ, akhanda kʉmʉkhajɨla, akhatɨ, “Mwene zɨtakhabhe shɨnɨɨsho! Te zɨkwaje zɨnɨɨzyo!” ");
INSERT INTO mgq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ɨleelo uYeesu akhagalʉnhana kʉmwenya uPeeteli, akhamʉbhʉʉzya akhatɨ, “Yeepa kwɨlongolela kʉkwanɨ Seetani! Ukundindanjila, kʉnongwa ye ʉkʉsɨɨbha zye te zya Mʉlʉngʉ, lyoli ʉkʉsɨɨbha ɨzya bhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Umuntu wowonti we akwanza kʉndandata ɨne, akwanzɨwa ayɨkhaane wʉʉyo, apɨmbe ɨshɨkhobhenhanyo shaakwe, andandate ɨne. ");
INSERT INTO mgq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwe kʉtɨ umuntu we akwanza kʉwʉpokha uwuumi waakwe wʉʉyo, akhayɨwʉteezya. Lyoli umuntu we akwanza kʉwʉteezya uwuumi waakwe kʉnongwa yaanɨ, akhayɨwʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kwe kʉtɨ umuntu angakabha akhooni ɨnga aapata vwonti ɨvwa mʉ nsɨ, ɨleelo ateezya uwuumi waakwe? Awe umuntu angafumwa khantʉ bhʉlɨ kʉtɨ khapwanɨle pa wuumi waakwe? ");
INSERT INTO mgq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ɄMwana wa Muntu akhayɨnza ku wumwamu wa Taata waakwe peeka na bhakhabhɨzya bhaakwe. Pe akhayɨmʉposheelezya umuntu wowonti kʉlandatana nɨ mbombo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nalyoli ɨnkʉbhabhʉʉzya ɨnkʉtɨ, panaapa bhalɨɨpo abhantʉ bhe bhakhayɨlola ʉMwana wa Muntu we akwɨnza mʉ wʉmwene waakwe, we bhashɨɨlɨ kufwa.” ");
INSERT INTO mgq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","We zyashɨla insiku ʉmʉtanda, uYeesu akhabheega uPeeteli, ʉYaakobo nu Yookhani umunsi wa Yaakobo. Akhazʉbha nabho mwɨ gamba itali, kwe kʉtalɨ na bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pe we bhalɨ kuula, uYeesu akhagalʉnhana pamiiso pɨlongolela yaabho. Pamiiso yaakwe pakhalama ngatɨ lɨzʉbha, amenda gaakwe gáamɨle mazelu nhaani ngatɨ lʉkhozyo lwɨ zʉbha. ");
INSERT INTO mgq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nalʉbhɨlo, bhakhafumila ʉMoose nu Eliya, bhakhalongaga nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pe uPeeteli akhamʉbhʉʉzya akhatɨ, “We Mwene, khinza kʉtɨ ɨtwe tʉbhe panaapa! Ɨnga ʉkwanza, ɨntɨzenje ivwegwi vɨtatʉ. Sheeka shɨbhe shaakho, shimo shɨbhe sha Moose, nɨ shamwabho shɨbhe sha Eliya.” ");
INSERT INTO mgq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","We uPeeteli akʉjendeelela kʉlonga, yeenya, ɨbhɨngo izelu likhabhagubishila. Pe bhakhɨmvwa izi kufuma mwɨ bhɨngo lɨkʉtɨ, “Ʉnʉ we Mwana waanɨ ʉmʉganwa we akʉnhondezya, mʉmwɨmvwaje ʉweene!” ");
INSERT INTO mgq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","We abhalandati bhaakwe bhaala bhɨmvwa zɨnɨɨzyo, bhakhoogopa nhaani, bhakhagwa paasɨ shikupama. ");
INSERT INTO mgq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","UYeesu akhabhasejeelela, akhabhapalamansya, akhabhabhʉʉzya akhatɨ, “Bhuushi, mʉtogopaje!” ");
INSERT INTO mgq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","We bheenya, bhatakhamʉlola umuntu ʉwamwabho nʉʉmo, lyoli uYeesu mwene. ");
INSERT INTO mgq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","We bhakwikha mwɨ gamba, uYeesu akhabhalajɨzya akhatɨ, “Mʉtakhamʉbhʉʉzye umuntu wowonti zyonti zye mwazɨlola, kufishila akhabhalɨlo khe ʉMwana wa Muntu akhayɨzyʉkha kufuma kʉ bhafwe.” ");
INSERT INTO mgq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhalandati bhaakwe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ishi khooni khe abhamanyizyi abhɨ ndajɨzyo bhakʉtɨ, yɨkwanzɨwa kʉtɨ uEliya ayɨnze suuti?” ");
INSERT INTO mgq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","UYeesu akhabhaamʉla akhatɨ, “Nalyoli uEliya akwɨnza suuti kʉlɨngaanya zyonti. ");
INSERT INTO mgq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ɨleelo ɨnkʉbhabhʉʉzya kʉtɨ, uEliya ayinzile, bhatámumanyile, lyoli bhámubhombile zyonti zye bhakhanzaga. She shɨnɨɨsho, ʉMwana wa Muntu akʉbhala kʉyɨmba kʉkwabho.” ");
INSERT INTO mgq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pe abhalandati bhaala bhakhazyaganya kʉtɨ uYeesu akhalongaga nabho kʉ zya Yookhani uMwozyi. ");
INSERT INTO mgq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","We uYeesu na bhalandati bhaakwe bhagalʉkha pe páamɨle nɨ mpʉga ɨya bhantʉ, umuntu weeka akhabhala kwa Yeesu, akhasʉgamɨla pɨlongolela yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Akhatɨ, “We Mwene, ɨnkʉlaabha mʉlolele ishisa ʉmʉvʉlɨ waanɨ kʉnongwa ye alɨ ni shizilisi. Uwubhinu wʉnʉʉwo, wʉkʉmʉyɨmvwa nhaani. Akhabhalɨlo akhinji akugwa mʉ mwoto na mu minzi. ");
INSERT INTO mgq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naamuleetile ku bhalandati bhaakho kʉtɨ bhamʉponɨe, ɨleelo anza bhaatolwa kʉmʉponɨa.” ");
INSERT INTO mgq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","UYeesu akhaamʉla akhatɨ, “Ɨmwe mushipaafi she shɨtakwɨtɨkha, she shiteejile. Ɨntɨyɨɨkhale nɨɨmwe kufishila liino? Imbajimbiilile paka liino? Mʉleete kʉkwanɨ!” ");
INSERT INTO mgq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","UYeesu akhalɨkhajɨla ipepu ibhiibhi, likhafuma, ʉmwana ʉla akhapona akhabhalɨlo khakhaala. ");
INSERT INTO mgq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pe abhalandati bha Yeesu bhakhamʉbhalɨla kukwilu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Khooni khe ɨtwe twaapotiilwe kʉlyefwa ipepu lɨnɨɨlyo?” ");
INSERT INTO mgq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","UYeesu akhabhaamʉla akhatɨ, “Mwaapotiilwe kʉnongwa ye ʉlwɨtɨkho lwinyu lunsi. Nalyoli ɨnkʉbhabhʉʉzya, ɨnga mwabha nʉ lwɨtɨkho, poope lʉbhe lunsi anza khasanga akhi nhaladaali, khe khansi kʉshɨla ɨnsanga zyonti, mʉtɨlɨbhʉʉzye ɨgamba ili kʉtɨ, ‘Yeepa ɨpa, ʉbhale paala,’ lyope lɨtɨyeepe. Poope khatalɨɨpo akhantʉ khe mʉtɨtolwaje.  ");
INSERT INTO mgq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɨleelo, ipepu ɨlya shɨkholo shɨnɨɨsho mʉtangakhola kʉlɨbhɨnga, lyoli kwɨ dala ɨlya kupuuta na kuyiima kulya.” ");
INSERT INTO mgq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","We uYeesu alɨ peeka na bhalandati bhaakwe mʉ Galɨlaaya, ábhabhuziizye átɨlɨ, “ɄMwana wa Muntu atɨlonjeelelwe na kʉtwalwa kʉ bhantʉ bhe bhatɨmʉgoje. ");
INSERT INTO mgq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ɨleelo we bhamʉgoga, pi siku ɨlya wʉtatʉ akhayɨzyʉkha.” We abhalandati bhaakwe bhɨmvwa zɨnɨɨzyo, bhakhaswɨmɨɨlɨla nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","We uYeesu na bhalandati bhaakwe bhaafikha mu Kapelenaumu, abhasonshezya nsonho ɨya kʉbhombela mu Nyumba iMfinjile, bhakhɨnza kwa Peeteli. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, umumanyizyi wiinyu akufumwa ɨnsonho iyi Nyumba iMfinjile?” ");
INSERT INTO mgq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","UPeeteli akhabhaamʉla akhatɨ, “Akufumwa.” We akwinjila mu nyumba, she ashɨɨlɨ kʉlonga lyolyonti, uYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “We Siimoni, ʉkʉlola bhʉlɨɨbhʉlɨ? Abhamwene abha mʉ nsɨ ɨnɨ bhakʉsonshezya ɨnsonho kʉ bhantʉ bhʉlɨ? Kʉ bhaana bhaabho awe ku bhajeni?” ");
INSERT INTO mgq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","UPeeteli akhaamʉla akhatɨ, “Bhakʉsonshezya ku bhajeni.” UYeesu akhamʉbhʉʉzya akhatɨ, “Ɨnga she zɨlɨ, pe bhabhatʉyɨɨye abhaana bhaabho kufumwa ɨnsonho. ");
INSERT INTO mgq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɨleelo kʉtɨ tutakhabhaviisye abhantʉ ɨbha, bhalaga mwa sʉmbɨ ʉsʉmbe ulusikulo. Inswi ye wayɨlema kʉwandɨlo, ukhayigubule ilomu, ʉtɨyaaje ɨnhela. Ʉyeeje ɨnhela yɨnɨɨyo ɨnga ʉbhale ufumwe ɨnsonho yaanɨ nɨ yaakho.” ");
INSERT INTO mgq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mʉ khabhalɨlo khaala abhalandati bha Yeesu bhakhabhala, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Wu naanu we mʉpɨtɨ kʉshɨla abhanjɨ bhonti mʉ wʉmwene ʉwa kʉmwanya?” ");
INSERT INTO mgq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","UYeesu akhamʉbhɨlɨshɨla ʉmwana umunsi, akhamwɨmɨɨlɨsya pakaasi yaabho, ");
INSERT INTO mgq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, ɨnga mʉtakʉpɨndʉkha kʉbha anza bhaana abhansi, te mukhinjile mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pe shɨnɨɨsho, umuntu wowonti we akuyiisya anzʉ mwana umunsi ʉnʉ, wʉnʉʉyo we atɨbhe mʉpɨtɨ mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Khabhɨlɨ umuntu wowonti we akʉmʉposheela ʉmwana umunsi anza wʉnʉʉnʉ kwɨ taawa lyanɨ, akʉmposheela neene. ");
INSERT INTO mgq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ɨleelo umuntu wowonti we akʉmʉpʉvwa weeka mu bhansi ɨbha bhe bhakʉnɨɨtɨkha kʉtɨ abhombe imbiibhi, yaamɨle kwashi kʉkʉnjɨɨlwa iwe ɨpɨtɨ ɨlya kʉsyela mu nsingo na kʉsʉmbwa mwa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mʉsheleeye mʉbhantʉ mwe mʉlɨ mʉ nsɨ umu, kʉnongwa yɨ ndɨngo zye zɨkwazya abhantʉ kʉbhomba imbiibhi! Ɨndɨngo zɨnɨɨzyo yɨkʉtɨ zitifumilaje bhʉʉlo, ɨleelo asheleeye umuntu we akwazya ɨndɨngo zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɨnga ɨnyoobhe yaakho awe ɨshɨnama shaakho vwakʉpʉvwa kʉbhomba imbiibhi, vidumule na kʉvɨsʉmba ukutali. Kwashi kwinjila mu wuumi ʉwa wiila sita kʉbha nɨ nyoobhe zyonti zɨbhɨlɨ awe ɨvɨnama vwonti vɨbhɨlɨ, na kʉtɨ ʉbhe nɨ nyoobhe zɨbhɨlɨ nɨ vɨnama vɨbhɨlɨ, ɨleelo ʉsʉmbwe mʉ mwoto we wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Khabhɨlɨ ɨnga ilyiso lyakho lɨkʉkʉpʉvwa kʉbhomba imbiibhi, lifigule na kʉlɨsʉmba ukutali! Kwashi kwinjila mu wuumi ʉwa wiila we ʉlɨ ni lyiso lyeka, na kʉtɨ ʉbhe na miiso gonti gabhɨlɨ, ɨleelo ʉsʉmbwe mʉ mwoto we wutakuzima naalumo.” ");
INSERT INTO mgq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","UYeesu akhajendeelela kʉlonga akhatɨ, “Mʉbhe amiiso, mʉtakhasheele kʉmʉshoolanya weeka mu bhansi ɨbha! Kʉnongwa ye ɨnkʉbhabhʉʉzya kʉtɨ, abhakhabhɨzya bhaabho abha kʉmwanya akhabhalɨlo khonti bhalɨ pɨlongolela pa Taata waanɨ we alɨ kʉmwanya.  ");
INSERT INTO mgq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwe kʉtɨ ʉMwana wa Muntu áyinzile kʉbhapokha bhe bhateejile. ");
INSERT INTO mgq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mʉkʉlola bhʉlɨɨbhʉlɨ? Tʉtɨ umuntu alɨ nɨ ngoole imia yeeka (100), ɨnga ateezya yeeka, angakhonzya bhʉlɨ? Atakʉzɨlekha suuti amashumi tisa nɨ zyamwabho tisa mwɨ gamba na kʉbhala kwanza yeeka ye yiteejile? ");
INSERT INTO mgq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nalyoli ɨnkʉbhabhʉʉzya, ɨnga ayaaga, akʉseshela nhaani kʉnongwa yɨ ngoole yiila yeeka kʉshɨla ɨngoole ɨzyamwabho amashumi tisa nɨ zyamwabho tisa zye zitáteejile. ");
INSERT INTO mgq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","She shɨnɨɨsho, ʉTaata wiinyu we alɨ kʉmwanya atakwanza kʉtɨ weeka mu bhansi ɨbha ateeje. ");
INSERT INTO mgq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ɨnga uwamwinyu akʉbhombela uwubhiibhi, bhalaga ʉmʉbhʉʉzye pe apʉbhɨɨye we mʉlɨ bhabhɨlɨ mʉbheene. Ɨnga akwɨmvwa, ʉtɨbhe wagalʉshɨlana nu wamwinyu. ");
INSERT INTO mgq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɨleelo ɨnga atakwɨmvwa, bhalaga ʉmweje umuntu ʉwamwabho weeka awe bhabhɨlɨ kʉtɨ, ‘Ɨnongwa yoyonti yitisimishizwe ku wukeeti ʉwa bhantʉ bhabhɨlɨ awe bhatatʉ.’ ");
INSERT INTO mgq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ɨnga atabhɨmvwa bhanaabho bhoope, bhalaga kʉshɨbhʉʉzya ɨshɨbhanza. Ɨnga atashɨmvwa ɨshɨbhanza, abhe kʉkwakho anza bhantʉ bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ awe anzʉ mʉsonshezya nsonho. ");
INSERT INTO mgq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, lyolyonti lye mwalɨkhaana mʉ nsɨ, lɨtɨbhe lyakhaanwa kʉmwanya. Khabhɨlɨ lyolyonti lye mwalyɨtɨshɨzya mʉ nsɨ, lɨtɨbhe lyɨtɨshɨlwa na kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Khabhɨlɨ ɨnkʉbhabhʉʉzya kʉtɨ, ɨnga bhabhɨlɨ pakaasi yiinyu bhɨtɨnhana mʉ nsɨ kʉ zye bhakupuuta, ʉTaata waanɨ we alɨ kʉmwanya atɨbhabhombele zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwe kʉtɨ ɨnga bhalɨ abhantʉ bhabhɨlɨ awe bhatatʉ bhe bhabhungaanile kwɨ taawa lyanɨ, nɨɨne ɨnkʉbha peeka nabho.” ");
INSERT INTO mgq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pe uPeeteli akhabhala kwa Yeesu, akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, ʉwamwɨtʉ ɨnga ambombela uwubhiibhi, ɨmʉtʉʉyɨle khalɨnga? Bhʉlɨ, khonti saba?” ");
INSERT INTO mgq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","UYeesu akhamwamʉla akhatɨ, “Ɨntakʉtɨ saba bhʉʉlo, lyoli ʉmʉtʉʉyɨle uwamwinyu akhabhalɨlo khonti mʉ wɨɨkhalo waakho sita kʉbhaazya. ");
INSERT INTO mgq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kʉnongwa yɨnɨɨnɨ, ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nʉ mwene weeka we akhanzaga kusimishizya ɨnhela ku bhabhombi bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","We ʉmwene ayanda kusimishizya ɨnhela, bhakhamʉleetela umubhombi weeka we akhadayɨwaaga ɨtalanta ielufu ishumi (10,000). ");
INSERT INTO mgq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Umubhombi wʉnʉʉyo akhapootwa kufumwa ɨnhela zye bhakhamwɨsyaga. Pe ʉmwene akhabhalajɨzya abhasikaali kʉtɨ bhamʉkazye wʉʉyo, ʉmʉshɨ, abhaana bhaakwe, ni vintu vwonti vwe alɨ navwo, ɨnga ideeni lɨtabhʉlwe. ");
INSERT INTO mgq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Pe umubhombi ʉla akhasʉgamɨla pɨlongolela pa mwene, akhamʉlamba akhatɨ, ‘Ɨnkʉlaabha ʉngʉʉlɨle khashe, ɨntɨkʉtabhʉlɨle ɨnhela zyakho zyonti.’ ");
INSERT INTO mgq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ʉmwene ʉla akhamʉlolela ishisa umubhombi waakwe, akhamʉtʉʉyɨla ideeni, akhamwɨtɨshɨzya kʉtɨ asogolaje. ");
INSERT INTO mgq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Umubhombi ʉla we aafuma kunzi, akhakhomaana nu mubhombi ʉwamwabho we ámʉkhopeeye idinaali imia yeeka (100). Nalʉbhɨlo akhamufina ku nsingo, akhamʉbhʉʉzya akhatɨ, ‘Tabhʉla vwe naakʉkhopeeye.’ ");
INSERT INTO mgq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Umubhombi wʉnʉʉyo akhasʉgamɨla pɨlongolela yaakwe, akhamʉlamba akhatɨ, ‘Ʉngʉʉlɨle khashe, ɨntɨkʉtabhʉlɨle ideeni lyakho.’ ");
INSERT INTO mgq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ɨleelo ʉweene akhakhaana, akhabhala kʉmʉkʉnga ʉwamwabho ʉla mwɨ jeela kufishila pe akhayɨtabhʉla ideeni lyonti. ");
INSERT INTO mgq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“We abhabhombi abhamwabho bhazɨlola zɨnɨɨzyo, zɨkhabhabhobha nhaani mʉ mooyo gaabho. Pe bhakhabhala kwa mwene kʉmʉpanjɨla zyonti zye zibhombeshile. ");
INSERT INTO mgq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pe ʉmwene akhamʉbhɨlɨshɨla umubhombi ʉla, akhamʉbhʉʉzya akhatɨ, ‘Ɨwe we mubhombi umubhiibhi! Yeenya we wandamba kʉtɨ ɨnkʉtʉʉyɨle vwe nakwɨsyaga, nákʉtʉyɨɨye zyonti zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bhʉlɨ, nɨɨwe ʉtaakhondeeye kʉmʉlolela ishisa umubhombi uwamwinyu anza she nɨɨne naakʉloleeye ishisa?’ ");
INSERT INTO mgq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Pe ʉmwene ʉla akhaviitwa nhaani, akhabhalajɨzya kʉtɨ bhamʉleme na kʉmʉsʉmba mwɨ jeela kufishila akhabhalɨlo khe akhayɨtabhʉla ɨnhela zyonti. ");
INSERT INTO mgq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Shɨnɨɨsho she ʉTaata waanɨ we alɨ kʉmwanya akhayɨbhabhombela nɨɨmwe ɨnga mʉtakʉbhatʉʉyɨla abhamwinyu kʉ mwoyo wonti.” ");
INSERT INTO mgq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","We uYeesu aamala kʉlonga amazwi ganaago, akhasogola mʉ Galɨlaaya, akhabhala mʉ nsɨ ɨya Yudeeya, kwɨsyɨla ɨya lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Abhantʉ abhinji bhakhamʉlandata, woope ábhaponiizye bhonti bhe bháamɨle bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pe aBhafalisaayi bhamu bhakhɨnza kwa Yeesu kʉmʉlɨnga. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, yɨkwɨtɨshɨlwa mʉ ndajɨzyo ʉmʉsakhaala kʉmʉlekha ʉmʉshɨ waakwe kʉnongwa yoyonti yiila?” ");
INSERT INTO mgq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","UYeesu akhabhaamʉla akhatɨ, “Mutabhaziizye mu Wusimbe uWufinjile kʉtɨ, kufuma kʉwandɨlo ʉMʉlʉngʉ ápelile ʉmʉsakhaala nʉ mwantanda? ");
INSERT INTO mgq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Akhatɨ, ‘Kʉnongwa yɨnɨɨyo, ʉmʉsakhaala akhayɨmʉlekha uyise waakwe nu nyina waakwe, akhayɨpatɨnhana nʉ mʉshɨ waakwe. Bhabhɨlɨ bhanaabho bhakhayɨbha mʉbhɨlɨ weeka.’ ");
INSERT INTO mgq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pe bhanaabha te bhabhɨlɨ winza, lyoli bhakʉbha mʉbhɨlɨ weeka. Pe shɨnɨɨsho, bhe ʉMʉlʉngʉ abhakhomanyiinye, umuntu wowonti atakhabhalenhaanye.” ");
INSERT INTO mgq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ABhafalisaayi bhanaabho bhakhamʉbhʉzɨɨlɨzya winza bhakhatɨ, “Ɨnga ziniizi zya nalyoli, khooni khe ʉMoose áyitishiziizye kʉtɨ ʉmʉsakhaala amʉpanje ʉmʉshɨ waakwe ɨkalaata ɨlya kʉmʉlekha?” ");
INSERT INTO mgq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","UYeesu akhabhaamʉla akhatɨ, “ɄMoose ábhitishiziizye kʉtɨ mʉbhalekhaje abhashɨ bhiinyu kʉnongwa ɨya wugomu ʉwa mooyo giinyu, ɨleelo kufuma kʉwandɨlo yɨtáamɨle shɨnɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ɨnkʉbhabhʉʉzya ɨmwe kʉtɨ umuntu wowonti we akʉmʉtabhʉla ʉmʉshɨ waakwe, ɨnga atamulemile mu wubhembu, ɨnga ayeega ʉmwantanda uwunji, akʉbhomba wubhembu.” ");
INSERT INTO mgq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pe abhalandati bhaakwe bhakhamʉbhʉʉzya bhakhatɨ, “Ɨnga she zɨlɨ shɨnɨɨsho kwa mʉlʉme nʉ mʉshɨ, pe yɨtakhondeeye kwega!” ");
INSERT INTO mgq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","UYeesu akhabhaamʉla akhatɨ, “Te bhonti bhe bhangakhola kʉlɨposheela izwi liniili, lyoli bhaala bhe bhasayiilwe nʉ Mʉlʉngʉ kʉlɨposheela. ");
INSERT INTO mgq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye nongwa bhamu bha bhatowaashi kʉnongwa ye bhapapiilwe shɨnɨɨsho. Bhamu bha bhatowaashi kʉnongwa ye abhantʉ bhabhabhiishile kʉtɨ bhabhe shɨnɨɨsho. Bhalɨɨpo bhamu bhe bhamʉʉye kʉtɨ bhateegaje kʉnongwa ɨya wʉmwene ʉwa kʉmwanya. Umuntu wowonti we angakhola kʉlɨposheela izwi ili, aliposheele.” ");
INSERT INTO mgq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abhantʉ bhakhamʉleetela uYeesu abhaana abhansi kʉtɨ abhabhɨɨshe ɨnyoobhe yaakwe na kubhapuutila kwa Mʉlʉngʉ. Ɨleelo abhalandati bhaakwe bhakhabhakhajɨla bhe bhábhaleetile abhaana bhaala. ");
INSERT INTO mgq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ɨleelo uYeesu akhatɨ, “Bhaleshe abhaana abhansi ɨbho bhɨnze kʉkwanɨ, lashi mutabhadindaje! Kʉnongwa ye ʉwʉmwene ʉwa kʉmwanya wa bhantʉ bhe bhalɨ anza bhaana ɨbha.” ");
INSERT INTO mgq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pe uYeesu akhabhɨɨkha ɨnyoobhe zyakwe pamwanya yaabho, akhabhasaya abhaana bhaala, akhasogola paala. ");
INSERT INTO mgq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pe umuntu ʉmo áyinzile kwa Yeesu, akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “We Mumanyizyi, ɨmbombe lyoni ilyinza ɨnga ɨnhawaaje uwuumi ʉwa wiila?” ");
INSERT INTO mgq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","UYeesu akhamwamʉla akhatɨ, “Khooni khe ʉkʉmbʉzɨɨlɨzya ɨzya winza? Umwinza alɨ weeka mwene, wʉ Mʉlʉngʉ! Ɨleelo ɨnga ʉkwanza kwinjila mu wuumi ʉwa wiila na wiila, zɨleme ɨndajɨzyo zya Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Umuntu ʉla akhamʉbhʉzɨɨlɨzya akhatɨ, “Ɨndajɨzyo zilikwi?” UYeesu akhamwamʉla akhatɨ, “Ʉtakhaagoje, utakhabhembushe, utakhiibhe, utakhaafumwe uwukeeti ʉwɨ lenga. ");
INSERT INTO mgq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Umushindikhaje uyise waakho nu nyina waakho, khabhɨlɨ ʉmʉgane uwamwinyu anza she uyiganile wʉneewe.” ");
INSERT INTO mgq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umuntu ʉla akhatɨ, “Ɨndajɨzyo zyonti zɨnɨɨzyo inzilemile. Imbuliliilwe ni lyoni winza?” ");
INSERT INTO mgq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","UYeesu akhamʉbhʉʉzya akhatɨ, “Ɨnga ʉkwanza ʉbhe we mugolosu, bhalaga ʉkazye ivintu vwonti vwe ʉlɨ navwo, ɨnhela zye waapata, ʉbhagabhɨle abhapɨɨna. Ɨnga wabhomba shɨnɨɨsho, ʉtɨbhe ʉyɨbhɨshɨɨye ɨshʉʉma kʉmwanya. Pe ʉyɨnze, ʉndandate.” ");
INSERT INTO mgq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","We umuntu ʉla ayɨmvwa zɨnɨɨzyo, akhasogola paala ku wuswimiilizu kʉnongwa ye áamɨle nɨ shʉʉma ishinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, yɨkhayɨbha papala nhaani kwa dumbwe kwinjila mʉ wʉmwene ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɨnkʉbhabhʉʉzya winza kʉtɨ papupuusu ɨngamɨla kwinjila mu khaazi akha lusindaani, na kʉtɨ udumbwe ayinjile mʉ wʉmwene wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","We abhalandati bhaala bhɨmvwa, bhakhaswiga nhaani, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ishi, ɨnga she zɨlɨ shɨnɨɨsho, wu naanu we angawaaga uwuposhi?” ");
INSERT INTO mgq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","UYeesu akhabheenya, akhabhabhʉʉzya akhatɨ, “Kʉ bhantʉ lɨnɨɨlyo lɨtangabhombekha, ɨleelo kwa Mʉlʉngʉ zyonti zɨkʉbhombekha.” ");
INSERT INTO mgq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","UPeeteli akhaamʉla akhatɨ, “Yeenya, ɨtwe tuvileshile ivintu vwonti, tukulandatile ɨwe! Ishi tʉtɨpate akhooni?” ");
INSERT INTO mgq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","UYeesu akhabhaamʉla akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, kʉtɨ nɨɨmwe mwe mumulandatile ʉMwana wa Muntu we ayɨɨkhala pɨ tengo lyakwe ɨlya wumwamu mʉ nsɨ impwa, mʉkhayɨɨkhala mʉ matengo aga shɨmwene ishumi na gabhɨlɨ, kʉbhalonga abhantʉ abha vɨkholo ishumi na vɨbhɨlɨ ɨvwa Bhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pe umuntu wowonti we ayileshile inyumba, awe abhakhambakʉ, awe abhayɨlʉmbʉ, awe uyise, awe unyina, awe abhaana, awe ivwizi, kʉnongwa yaanɨ, akhayɨposheela ivwinji nhaani kʉshɨla vwe avileshile. Khabhɨlɨ akhayɨwaaga uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɨleelo abhinji bhe bhakʉyɨlola kʉtɨ bhatakhondeeye mʉ nsɨ, bhakhayɨbha bha mwɨlongolela, khabhɨlɨ bhe bhakʉyɨlola kʉtɨ bhakhondeeye mʉ khabhalɨlo ɨkha, bhakhayɨbha kʉlʉsalo mʉ khabhalɨlo khe khakwɨnza.” ");
INSERT INTO mgq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iwinza uYeesu akhabhabhʉʉzya kʉ shɨkholanyo akhatɨ, “Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nu muntu uwi shiizi ɨsha mazabiibu, we akhalaabhɨla kwanza abhabhombi abha kʉbhomba ɨmbombo mu shiizi shaakwe ɨsha mazabiibu. ");
INSERT INTO mgq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","We abhaaga, akhɨtɨnhana nabho kʉbhaposheelezya weeka weeka idinaali kwi siku, pe akhabhatwala ku shiizi shaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akhafuma ɨsaala ɨya wʉtatʉ ɨshɨlaabhɨla, akhabhalola abhantʉ abhamwabho bhɨmɨlɨɨye pa mʉnaalo, bhatalɨ nɨ mbombo. ");
INSERT INTO mgq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akhabhabhʉʉzya akhatɨ, ‘Nɨɨmwe bhalaji kʉbhomba ɨmbombo mu shiizi shaanɨ ɨsha mazabiibu. Nɨɨne ɨntɨbhaposheelezye mwenti anza she yɨkwanzɨwa, bhoope bhakhabhala.’ ");
INSERT INTO mgq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","We ɨzʉbha lyabha pi twe, iwinza we lyabhota, akhafuma winza kubhinjizya abhantʉ abhamwabho kʉbhomba ɨmbombo mu shiizi shaakwe shiila. ");
INSERT INTO mgq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","We yakwɨla ɨsaala iyi shumi na yeeka, akhafuma winza, akhabhalola abhantʉ abhamwabho bhɨmɨlɨɨye pa mʉnaalo. Akhabhabhʉzɨɨlɨzya akhatɨ, ‘Khooni khe mwɨmɨlɨɨye ɨpa isiku lyonti sita mbombo?’ ");
INSERT INTO mgq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bhoope bhakhamwamʉla bhakhatɨ, ‘Kʉnongwa ye atalɨɨpo umuntu we atubhiishile pa mbombo.’ Akhabhabhʉʉzya akhatɨ, ‘Nɨɨmwe bhʉʉlo bhalaji kʉbhomba ɨmbombo mu shiizi shaanɨ ɨsha mazabiibu.’ ");
INSERT INTO mgq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“We kwabha shalyabheela, uwi shiizi akhamʉbhʉʉzya we akhɨmɨlɨlaga ɨmbombo yaakwe akhatɨ, ‘Bhabhɨlɨshɨle abhabhombi bhonti, ʉbhaposheelezye ɨnhela zyabho. We ʉkʉbhaposheelezya, ʉyande na bhabhombi bhe bhinzile kʉwʉmalɨlɨshɨlo na kʉmalɨɨlɨzya na bhe bhinzile kʉwandɨlo.’ ");
INSERT INTO mgq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pe abhabhombi bhaala bhe bhínzile shalyabheela, bhakhaposheela idinaali yeeka. ");
INSERT INTO mgq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","We bhɨnza abhabhombi abha kʉwandɨlo, bhásʉbhɨɨye kʉposheela idinaali inyinji kʉshɨla bhe bhínzile kʉwʉmalɨlɨshɨlo. Ɨleelo bhoope weeka weeka bhakhaposheela idinaali yeeka. ");
INSERT INTO mgq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pe we bhaposheela, bhakhanda kuyibhuna ku wi shiizi, bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ɨbha bhe waabhabhiishile pa mbombo kʉwʉmalɨlɨshɨlo, bhabhombile ɨmbombo kʉ saala yeeka bhʉʉlo, zyabha bhʉlɨɨbhʉlɨ watʉlɨngaanya nabho kʉtʉposheelezya, we ɨtwe tubhombile ɨmbombo ingomu nhaani mʉsanya wonti.’ ");
INSERT INTO mgq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Uwi shiizi ʉla akhamwamʉla weeka mʉ bhantʉ bhaala akhatɨ, ‘We manyani, intakucheepile. Bhʉlɨ, tutinhiine kʉtɨ ɨntɨkʉposheelezye idinaali yeeka? ");
INSERT INTO mgq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yeega idinaali yaakho yeeka, sogola ɨpa! Ɨne injiganile kʉmʉposheelezya ʉwa kʉwʉmalɨlɨshɨlo idinaali yeeka anzɨɨwe. ");
INSERT INTO mgq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bhʉlɨ, ɨntakwɨtɨshɨlwa kʉbhombela ivintu vwanɨ anza she injiganile? Bhʉlɨ ʉlɨ nʉ mwone kʉnongwa ye ne mupi?’ ");
INSERT INTO mgq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","She shɨnɨɨsho, abhinji bhe bhakʉyɨlola kʉtɨ bhatakhondeeye mʉ nsɨ, bhakhayɨbha bha mwɨlongolela, khabhɨlɨ bhe bhakʉyɨlola kʉtɨ bhakhondeeye mʉ khabhalɨlo ɨkha, bhakhayɨbha kʉlʉsalo mʉ khabhalɨlo khe khakwɨnza.” ");
INSERT INTO mgq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","We uYeesu akʉzʉbha kʉbhala ku Yelusaleemu, akhabheega abhalandati bhaakwe ishumi na bhabhɨlɨ pambalɨ, akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yeenyi, ishi tʉkʉzʉbha kʉbhala ku Yelusaleemu. Kʉnʉʉkwo ʉMwana wa Muntu atɨtwalwe kʉ bhapɨtɨ abha bhapuutili na ku bhamanyizyi abhɨ ndajɨzyo bhe bhatɨmʉlonje kʉtɨ agogwe. ");
INSERT INTO mgq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iwinza bhakhayɨmʉtwala kʉ bhantʉ bhe te Bhayahuudi kʉtɨ bhamʉsʉʉpɨzye, bhamʉkhome nɨ sambogo na kʉmʉkhomeela pa shɨkhobhenhanyo. Ɨleelo isiku ɨlya wʉtatʉ, akhayɨzyʉkha.” ");
INSERT INTO mgq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pe unyina wa bhaana bha Zebedaayo akhabhala kwa Yeesu peeka na bhaana bhaakwe, akhasʉgamɨla pɨlongolela pa Yeesu akhamʉlaabha amwavwe. ");
INSERT INTO mgq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","UYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “Ʉkwanza ɨnkʉbhombele lyoni?” Woope akhamwamʉla akhatɨ, “Ɨnkʉlaabha ʉbhɨtɨshɨzye abhaana bhaanɨ bhabhɨlɨ ɨbha kʉtɨ weeka ayɨɨkhale kʉmbalɨ ɨyɨ nyoobhe yaakho ɨya kʉndɨɨlo nʉ wamwabho kʉmbalɨ ɨyɨ nyoobhe yaakho ɨya kʉmongo mʉ wʉmwene waakho.” ");
INSERT INTO mgq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","UYeesu akhabhaamʉla akhatɨ, “Mutalimanyile lye mʉkʉlaabha. Bhʉlɨ, mʉngakhola kujimbiilila amayɨmba ge ɨnkʉbhala kʉyɨmba?” Bhakhamwamʉla bhakhatɨ, “Tʉngakhola.” ");
INSERT INTO mgq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","UYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli mʉngakhola kʉyɨmba anza she ɨnkʉbhala kʉyɨmba, ɨleelo kwɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo awe ɨnyoobhe yaanɨ ɨya kʉmongo ɨyo te mbombo yaanɨ. Lyoli panaapo apa kwɨkhala pa bhaala bhe ʉTaata waanɨ abhabhɨshɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Abhalandati abhanjɨ bhaala ishumi we bhɨmvwa amazwi ganaago, bhakhabhaviitilwa abhanamuntu bhaala bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pe uYeesu akhabhabhɨlɨshɨla bhonti peeka, akhabhabhʉʉzya akhatɨ, “Mumanyile kʉtɨ abhapɨtɨ abha mʉ nsɨ bhakʉbhatabhaala abhantʉ bhaabho kʉ makha, khabhɨlɨ abhapɨtɨ bhaabho bhakʉbhabhombezya kʉ makha. ");
INSERT INTO mgq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ɨleelo kukwinyu ɨmwe te zɨbhe shɨnɨɨsho khaala. Lyoli umuntu we akwanza kʉbha mʉpɨtɨ wiinyu, atɨbhabhombelaje mwenti. ");
INSERT INTO mgq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Khabhɨlɨ umuntu wowonti we akwanza kʉbha wa kwanda kukwinyu, atɨbhabhombelaje ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwɨ dala lɨnɨɨlyo, ʉMwana wa Muntu atínzile kʉbhombelwa, lyoli áyinzile kʉbhabhombela abhantʉ na kufumwa uwuumi waakwe ɨnga abhasombele imbiibhi abhantʉ abhinji.” ");
INSERT INTO mgq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","UYeesu na bhalandati bhaakwe we bhakʉsogola mʉ nhaaya ɨya mu Yeeliko, ɨmpʉga ɨya bhantʉ yɨkhamʉlandataga. ");
INSERT INTO mgq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bhe bháfuuye amiiso bhabhɨlɨ bhɨ́khaaye pambalɨ pɨ dala, we bhɨmvwa kʉtɨ uYeesu akʉshɨla, bhakhabhɨlɨshɨla kwi zi ɨlya kʉdandɨzya bhakhatɨ, “We Mwene, ʉwa shɨkholo sha mwene uDaudi, tʉlolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɨmpʉga ɨya bhantʉ yɨkhabhakhajɨla kʉtɨ bhapʉʉme, ɨleelo abheene bhakhajinaga kʉdandɨzya izi bhakhatɨnjɨ, “We Mwene, ʉwa shɨkholo sha mwene uDaudi, tʉlolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","UYeesu akhɨmɨɨlɨla, akhabhabhɨlɨshɨla, akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkwanza ɨmbabhombele akhooni?” ");
INSERT INTO mgq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bhakhamwamʉla bhakhatɨ, “We Mwene, tʉkwanza amiiso gɨɨtʉ gadaamʉle.” ");
INSERT INTO mgq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","UYeesu akhabhalolela ishisa, akhabhapalamansya amiiso gaabho. Nalʉbhɨlo, amiiso gaabho gakhanda kʉlola, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","UYeesu na bhalandati bhaakwe bhakhapalamɨla mu Yelusaleemu. We bhaafikha mʉ khakhaaya akha Betisifaage mwɨ gamba ɨlya Mizeituni, uYeesu akhabhasonteelezya abhalandati bhaakwe bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Akhabhabhʉʉzya akhatɨ, “Bhalaji mʉ khakhaaya khaala khe khalɨ pɨlongolela yiinyu, mʉtɨyɨlole indogomi nɨ nyaana yaakwe nkʉnjɨɨle, ye umuntu atapandile naalumo. Mʉkhazɨsatʉle, mʉzɨleete kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ɨnga umuntu wowonti akʉbhabhʉzɨɨlɨzya izyi ndogomi zɨnɨɨzyo, mʉkhamʉbhʉʉzye kʉtɨ, ‘ɄMwene akʉzyanza,’ woope atɨbhɨtɨshɨzye mʉzɨleete nalʉbhɨlo.” ");
INSERT INTO mgq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ziniizi zyonti zyábhombeshile ɨnga lɨkwɨle izwi lye álonjile umukuwi kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mʉbhʉʉzye ʉmʉlɨndʉ ʉwa mʉ nhaaya ɨya mu Sayuuni kʉtɨ, ‘Yeenya, ʉMwene waakho akwɨnza kʉkwakho, mutonsu, ayɨkhaaye pa ndogomi, ɨnyaana yi ndogomi.’” ");
INSERT INTO mgq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pe abhalandati bhaala bhakhabhala, bhakhabhomba anza she uYeesu ábhalajiziizye. ");
INSERT INTO mgq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakhɨnza ni ndogomi yiila peeka nɨ nyaana yaakwe kwa Yeesu, bhakhaala amenda gaabho pamwanya pa ndogomi, uYeesu akhazʉbha, akhɨɨkhala pamwanya. ");
INSERT INTO mgq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Abhantʉ abhinji bhakhaalaga amenda gaabho mwɨ dala, bhamu bhakhatemaga ʉtʉzanzala ʉtwa makwi, bhakhaalaga mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abhantʉ bhe bhálongoleeye kwɨlongolela na bhaala bhe bhakhalandataga kʉlʉsalo kwa Yeesu, bhakhadandɨzyaga kʉkhoolela bhakhatɨnjɨ, “Apalwaje ʉMwana ʉwa shɨkholo sha mwene uDaudi! Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ! Apalwaje ʉMʉlʉngʉ ʉwa kʉmwanya!” ");
INSERT INTO mgq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","We uYeesu ayinjila mu Yelusaleemu, ɨnhaaya yonti yɨkhasambagana. Abhantʉ bhakhanda kʉbhʉzɨlɨzanya bhakhatɨnjɨ, “Wu naanu wʉnʉʉnʉ?” ");
INSERT INTO mgq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ɨmpʉga ɨya bhantʉ bhaala ye yáfumile nu Yeesu yɨkhabhaamʉla yɨkhatɨ, “Ʉnʉ mukuwi uYeesu, kufuma mu Naazaleti, mʉ nhaaya ɨya mʉ Galɨlaaya.” ");
INSERT INTO mgq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pe uYeesu akhinjila mwi linga ilyi Nyumba iMfinjile. We ayinjila, akhabhabhɨnjɨla kunzi bhe bhakhakazyaga na kʉkala ivintu mwi linga ilyi Nyumba iMfinjile. Akhabenulanya ivintalati ɨvwa bhe bhakhavunzanyaaga ɨnhela, akhabenulanya na matengo aga bhe bhakhakazyaga ɨnkʉnda. ");
INSERT INTO mgq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","UYeesu akhabhabhʉʉzya akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Inyumba yaanɨ yɨtɨbhe nyumba ya kupuutila.’ Ɨleelo ɨmwe muyigalulanyiinye kʉbha ngwenya ya bhabuda!” ");
INSERT INTO mgq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bhe bhatakʉlola na bhe bhálemaaye bhínzile mwi linga ilyi Nyumba iMfinjile, uYeesu akhabhaponɨa. ");
INSERT INTO mgq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɨleelo abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo we bhavɨlola ɨvɨlolesyo ɨvwa kuswijizya vwe uYeesu ábhombile, khabhɨlɨ we bhɨmvwa abhaana bhakhapaalaga mwi linga ilyi Nyumba iMfinjile bhakhatɨnjɨ, “Apalwaje ʉMwana ʉwa shɨkholo sha mwene uDaudi,” bhakhaviitwa nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Bhʉlɨ, ʉkwɨmvwa she abhaana ɨbha bhakʉlonga?” UYeesu akhabhaamʉla akhatɨ, “Ɨnkwɨmvwa. Bhʉlɨ, mutabhaziizye amazwi ɨga mu Wusimbe uWufinjile kʉtɨ, ‘Mu malomu ga bhaana abheela na bhe bhakwonha, ukwiliziizye ɨmpaalo zyonti’?” ");
INSERT INTO mgq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","UYeesu akhabhalekha abhantʉ bhaala, akhafuma kunzi ɨyɨ nhaaya, akhabhala ku Besaniya, akhagona kʉnʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ɨshɨlaabhɨla we uYeesu akʉgalʉkha mu Yelusaleemu kufuma ku Besaniya, ɨnzala yikhamuluma. ");
INSERT INTO mgq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pe akhalɨlola ikwi limo lye bhakʉtɨ umutiini pambalɨ pɨ dala, akhasejeelela papɨɨpɨ, akhaaga lɨtalɨ na matunda naagamu, lyoli lɨlɨ na matʉndʉ meene. Akhalɨbhʉʉzya ikwi liila akhatɨ, “Kufuma ʉmʉsanyʉʉnʉ ʉtakheele amatunda naalumo, wiila na wiila!” Nalʉbhɨlo, ikwi liila lɨkhʉʉma lyonti. ");
INSERT INTO mgq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","We abhalandati bha Yeesu bhazɨlola zɨnɨɨzyo, bhakhaswiga nhaani, bhakhatɨ, “Khooni khe ikwi ili ɨlya mutiini lyʉma nalʉbhɨlo?” ");
INSERT INTO mgq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","UYeesu akhabhaamʉla akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, ɨnga mwabha nʉ lwɨtɨkho sita kusingaana, mʉngakhola kʉbhomba te lɨnɨɨlyo ɨlya mutiini lyene. Lyoli poope ɨnga mwalɨbhʉʉzya ɨgamba ili, mwatɨ, ‘Kumpukha ʉsʉmbwe mwa sʉmbɨ,’ lɨnɨɨlyo lɨtɨbhombeshe. ");
INSERT INTO mgq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɨnga mʉlɨ nʉ lwɨtɨkho, lyolyonti lye mʉkʉlaabha kwa Mʉlʉngʉ mu mpuuto, mʉtɨposheele.” ");
INSERT INTO mgq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","UYeesu akhinjila mwi linga ilyi Nyumba iMfinjile. We akʉmanyɨzya, abhapɨtɨ abha bhapuutili na bhasongo abha Bhayahuudi bhakhabhala kʉmʉbhʉzɨɨlɨzya bhakhatɨ, “Ganaaga ge ʉkʉbhomba, ʉkʉbhomba kʉ waamʉlo wooni? Wu naanu we akupiiye ʉwaamʉlo wunuuwu?” ");
INSERT INTO mgq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","UYeesu akhabhaamʉla akhatɨ, “Nɨɨne ɨntɨbhabhʉzɨɨlɨzye izwi lyeka. Ɨnga mwanaamʉla, pe nɨɨne ɨntɨbhabhʉʉzye kʉtɨ ɨnkʉbhomba ganaaga kʉ waamʉlo wa naanu. ");
INSERT INTO mgq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bhʉlɨ, ʉwaamʉlo wa Yookhani ʉwa kwozya abhantʉ wáfumile kwoshi? Wáfumile kʉmwanya awe kʉ bhantʉ?” Pe bhakhazaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Ɨnga twatɨ lwáfumile kʉmwanya, atɨtʉbhʉzɨɨlɨzye kʉtɨ, ‘Khooni khe mʉtakhamwɨtɨkhaga?’ ");
INSERT INTO mgq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Khabhɨlɨ ɨnga twatɨ lwáfumile kʉ bhantʉ, tʉkwogopa ɨmpʉga ɨya bhantʉ. Kʉnongwa ye bhonti bhakwɨtɨkha kʉtɨ uYookhani áamɨle mukuwi.” ");
INSERT INTO mgq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pe bhakhamwamʉla bhakhatɨ, “Tutamanyile.” Woope uYeesu akhabhabhʉʉzya akhatɨ, “Nɨɨne ɨntakʉbhabhʉʉzya kʉtɨ ɨnkʉbhomba ziniizi kʉ waamʉlo wa naanu.” ");
INSERT INTO mgq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","UYeesu akhajendeelela kʉlonga akhatɨ, “Ɨmwe mʉkʉlola bhʉlɨɨbhʉlɨ? Álɨɨpo umuntu ʉmo áamɨle na bhaana bhabhɨlɨ. Akhabhala kwa mwana ʉwa kwanda, akhatɨ, ‘Mwana waanɨ, ʉmʉsanyʉʉnʉ bhalaga kʉbhomba ɨmbombo mu shiizi ɨsha mazabiibu.’ ");
INSERT INTO mgq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ʉmwana ʉla akhamwamʉla akhatɨ, ‘Ndaali.’ Ɨleelo akhayɨsɨɨbha, akhabhala kʉbhomba ɨmbombo. ");
INSERT INTO mgq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pe uyise waakwe akhabhala kwa mwana ʉwa wʉbhɨlɨ akhamʉbhʉʉzya shishiila. Woope akhamwamʉla akhatɨ, ‘Ɨntɨbhale baaba.’ Ɨleelo pɨlongolela, akhagalʉlanya ɨnsɨɨbho yaakwe, atakhabhala kʉbhomba ɨmbombo. ");
INSERT INTO mgq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bhʉlɨ, mʉ bhabhɨlɨ bhanaabho, wu naanu we ábhombile zye uyise waakwe akhanzaga?” Bhakhamwamʉla bhakhatɨ, “Wʉ wʉʉla ʉwa kwanda.” Pe uYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, abhasonshezya nsonho na bhabhembu bhakhayɨbhalongolela kwinjila mʉ wʉmwene ʉwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kʉnongwa ye uYookhani áyinzile kukwinyu kwɨ dala ɨlya wugolosu, ɨmwe mutámwitishile. Ɨleelo abhasonshezya nsonho na bhabhembu bhámwitishile. Ɨmwe poope we mwazɨlola zyonti zɨnɨɨzyo, mʉtakhalaata na kʉmwɨtɨkha.” ");
INSERT INTO mgq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","UYeesu akhalonga winza akhatɨ, “Tejeelezyi ɨshɨkholanyo ɨshamwabho. Álɨɨpo umuntu ʉmo, we áamɨle ni shiizi, akhawaala amazabiibu. Akhazyʉngʉʉlɨzya ʉlʉbhaga, akhabana apa kufinyila amazabiibu, akhazenga ʉmʉnaala. Pe akhɨmvwana na bhalimi kʉtɨ bhabhombaje ɨmbombo ɨnga bhakhagabhane nawo ɨvɨyabho, akhashʉʉla kʉbhala ɨnsɨ ɨya kutali. ");
INSERT INTO mgq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“We akhabhalɨlo akhi mvuno ɨya mazabiibu khaafikha, akhabhasonteelezya abhabhombi bhaakwe ku bhalimi bhaala kʉtɨ bhaamupe amazabiibu ge bhamʉgabhɨɨye kufuma mu shiizi shaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ɨleelo abhalimi bhaala bhakhabhalema abhabhombi bhaakwe, ʉmo bhakhamʉkhoma, ʉmo bhakhamʉgoga nʉ wamwabho bhakhamʉkhoma na mawe. ");
INSERT INTO mgq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Umuntu ʉla akhabhasonteelezya winza abhabhombi abhamwabho abhinji kʉshɨla bhe ábhasonteleziizye kʉwandɨlo. Abhalimi bhaala bhakhabhabhomba akhabhiibhi anza bha kwanda. ");
INSERT INTO mgq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kʉwʉmalɨlɨshɨlo, akhamʉsonteelezya ʉmwana waakwe akhatɨ, ‘Bhatimushindishe pe mwana waanɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ɨleelo abhalimi bhaala we bhamʉlola ʉmwana ʉla, bhakhabhʉʉzanya bhakhatɨ, ‘Ʉnʉ, we mugaali uwi shiizi ishi. Ishi tʉmʉgoje ɨnga tweje uwugaali waakwe.’ ");
INSERT INTO mgq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pe bhakhamʉlema, bhakhamʉsʉmba kunzi ku shiizi ɨsha mazabiibu, bhakhamʉgoga. ");
INSERT INTO mgq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bhʉlɨ, we ayɨnza ʉmwanensho uwi shiizi ɨsha mazabiibu akhayɨbhabhomba lyoni abhalimi bhaala?” ");
INSERT INTO mgq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Abhapuutili abhapɨtɨ na bhapɨtɨ abha Bhayahuudi bhakhamwamʉla bhakhatɨ, “Akhayɨbhayazya abhabhiibhi bhaala, ishiizi shaakwe akhayɨɨbhapa abhalimi abhanjɨ bhe bhatɨmʉpanje amatunda agaakwe kʉ khabhalɨlo akhi mvuno.” ");
INSERT INTO mgq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Bhʉlɨ, mutabhaziizye ziniizi mu Wusimbe uWufinjile? Yisimbiilwe kʉtɨ, ‘Iwe lye bhálikhaanile abhazenji, lɨnɨɨlyo lye lyabha liwe ɨlya pambalɨ, lye lilemile inyumba yonti. Izwi liniili lifumile kwa Mwene, lyope lya kuswijizya kʉkwɨtʉ!’ ");
INSERT INTO mgq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kʉnongwa yɨnɨɨyo, ɨnkʉbhabhʉʉzya kʉtɨ, ʉMʉlʉngʉ akhayeefwa ʉwʉmwene waakwe kukwinyu akhayɨɨbhapa abhantʉ abhɨ nsɨ izinji bhe bhangakhola kuumupa amatunda gaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Umuntu wowonti we alendela pi we lɨnɨɨlyo, akhayivunzinhana. Khabhɨlɨ wowonti we lyamʉlendela, likhayimuvinyulanya vinyuvinyu.” ");
INSERT INTO mgq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","We aBhafalisaayi na bhapɨtɨ abha bhapuutili bhɨmvwa ɨvɨkholanyo vwa Yeesu, bhakhamanya kʉtɨ akubhiibhikha bhɨɨbho. ");
INSERT INTO mgq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pe bhakhanza ɨdala ɨlya kʉmʉlema, ɨleelo bhakhogopaga ɨmpʉga ɨya bhantʉ, kʉnongwa ye abheene bhámwaganyiinye uYeesu kʉtɨ mukuwi. ");
INSERT INTO mgq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","UYeesu akhabhabhʉʉzya winza aBhafalisaayi na bhapɨtɨ bha bhapuutili kʉ vɨkholanyo akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nʉ mwene ʉmo we álinganyiinye uweeji ʉwa mwana waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akhabhasonteelezya abhabhombi bhaakwe kʉbhabhɨlɨshɨla bhe abhalanjɨɨye kʉtɨ bhɨnze ku weeji, ɨleelo bhakhakhaana kwɨnza. ");
INSERT INTO mgq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Akhabhasonteelezya winza abhabhombi abhamwabho, akhabhabhʉʉzya akhatɨ, ‘Bhalaji mʉbhabhʉʉzye bhaala bhe naabhalanjɨɨye kʉtɨ, “Indinganyiinye ivintu vwonti ɨvwa weeji. Ingojile ɨngʼombe zyanɨ zye zinyanyatile nhaani, vwonti vɨlɨngaanye. Nzaagaji ku weeji!” ’ ");
INSERT INTO mgq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ɨleelo abheene bhatakhasaajɨla bhakhabhala ʉlwabho. Weeka akhabhala ku shiizi shaakwe, ʉwamwabho akhabhala kʉ mbombo yaakwe ɨya kʉkazya. ");
INSERT INTO mgq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bhamu bhakhabhalema abhabhombi bhaakwe, bhakhabhabhomba izyi nsoni na kʉbhagoga. ");
INSERT INTO mgq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pe ʉmwene ʉla akhaviitwa nhaani, akhabhasonteelezya abhasikaali bhaakwe kʉbhayazya abhagoji bhaala na kʉyazya ɨnhaaya yaabho. ");
INSERT INTO mgq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pe ʉmwene akhabhabhʉʉzya abhabhombi bhaakwe akhatɨ, ‘Ivintu ɨvwa weeji vɨlɨngaanye, ɨleelo bhe naabhalanjɨɨye bhataakhondeeye kwɨnza ku weeji. ");
INSERT INTO mgq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pe bhalaji mʉ madala amalenhaana, bhonti bhe mwabhaaga mʉbhabhʉʉzye bhɨnze ku weeji.’ ");
INSERT INTO mgq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abhabhombi bhaala bhakhabhala mʉ madala amalenhaana. Bhakhabhabhʉngaanya bhonti bhe bhakhabhalolaga, abhabhiibhi na bhinza. Pe inyumba ɨya weeji yikhiizula abhajeni. ");
INSERT INTO mgq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ɨleelo we ʉmwene ʉla ayinjila mu nyumba kʉtɨ abhalole abhajeni, akhamʉlola umuntu weeka we atákwatile ʉmwenda ʉwa weeji. ");
INSERT INTO mgq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akhamʉbhʉzɨɨlɨzya akhatɨ, ‘We manyani, uyinjiiye bhʉlɨɨbhʉlɨ umu sita mwenda ʉwa weeji?’ Ɨleelo umuntu ʉla akhapootwa ɨlya kwamʉla. ");
INSERT INTO mgq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pe ʉmwene akhabhabhʉʉzya abhabhombi bhaakwe akhatɨ, ‘Mupinye umuntu ʉnʉ ɨnyoobhe nɨ vɨnama na kʉmʉsʉmba kunzi ku khiisi. Kʉnʉʉkwo akhayɨlɨla na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kʉnongwa ye bhe bhabhilishiliilwe bhinji, ɨleelo abhasaabhʉlwa bhalɨ bhashe.” ");
INSERT INTO mgq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pe aBhafalisaayi bhakhasogola paala, bhakhabhala kʉpanzanya she bhangamʉtega uYeesu ku mazwi gaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pe bhakhasonteelezya abhalandati bhaabho peeka nɨ shɨpʉga sha bhalandati bha mwene uHeloodi, bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “We Mumanyizyi, tumanyile kʉtɨ ɨwe we muntu ʉwa nalyoli na kʉtɨ ʉkʉmanyɨzya ɨzya Mʉlʉngʉ mu wanalyoli. Khabhɨlɨ ʉtakʉwʉsaajɨla ʉwʉpɨtɨ wa muntu pa mbombo, kʉnongwa ye ʉtakwɨmɨla bha ndwɨmo. ");
INSERT INTO mgq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tʉbhʉʉzye she ʉkʉlola. Bhʉlɨ, ɨndajɨzyo zɨkwɨtɨshɨzya kufumwa ɨnsonho kwa Kaisaali awe khaala?” ");
INSERT INTO mgq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ɨleelo uYeesu ámanyile ɨnsɨɨbho yaabho imbiibhi, akhabhaamʉla akhatɨ, “Khooni khe mʉkʉndɨnga, ɨmwe mubhi shisa ɨshɨ lenga? ");
INSERT INTO mgq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndanje ɨnhela ɨnsabhaazya ye mukufumwa kʉ nsonho.” Bhoope bhakhamʉleetela idinaali yeeka. ");
INSERT INTO mgq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Ishifwani ishi nu wusimbe uwu vwa naanu?” ");
INSERT INTO mgq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakhamwamʉla bhakhatɨ, “Vwa Kaisaali.” UYeesu akhabhabhʉʉzya akhatɨ, “Mʉmʉpanje uKaisaali vwe vwa Kaisaali, iwinza mʉmʉpanje ʉMʉlʉngʉ vwe vwa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","We bhɨmvwa zɨnɨɨzyo, bhakhaswiga nhaani. Pe bhakhamʉlekha, bhakhasogola. ");
INSERT INTO mgq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Isiku liliila, aBhasadukaayi bhe bhakʉmanyɨzya kʉtɨ kʉtalɨɨpo kʉzyʉkha abhafwe, bhamu bhakhabhala kwa Yeesu. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mumanyizyi, ʉMoose átusimbiiye ɨndajɨzyo kʉtɨ ɨnga umuntu aafwa, amʉlekha ʉmʉshɨ sita kʉpaapa ʉmwana, yɨkwɨtɨshɨlwa ʉkhambakʉ waakwe kʉmʉgaala ʉmʉfwɨle ɨnga amʉpaapɨle umuyazi abhaana. ");
INSERT INTO mgq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Papɨɨtʉ ɨpa, bhálɨɨpo abhanamuntu saba. Ʉwa kwanda áyeejile, akhafwa sita kʉpaapa ʉmwana. Pe ʉkhambakʉ waakwe ʉwa wʉbhɨlɨ akhamʉgaala ʉmʉfwɨle ʉla. ");
INSERT INTO mgq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Zɨkhabha shɨnɨɨsho kwa khambakʉ ʉwa wʉbhɨlɨ, nʉ wa wʉtatʉ, bhakhasila bhonti saba. ");
INSERT INTO mgq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kʉwʉmalɨlɨshɨlo wa bhonti, ʉmwantanda ʉla woope akhafwa. ");
INSERT INTO mgq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bhʉlɨ, pi siku lye abhafwe bhakhayɨzyʉkha, ʉmwantanda ʉla akhayɨbha mʉshɨ wa naanu mʉ bhaala saba? Kʉnongwa ye abhasakhaala bhonti bhámwejile!” ");
INSERT INTO mgq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","UYeesu akhabhaamʉla akhatɨ, “Mʉkʉpʉbha kʉnongwa ye mutawumanyile uWusimbe uWufinjile, khabhɨlɨ mutagamanyile amakha ga Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Akhabhalɨlo khe abhafwe bhakhayɨzyʉkha, te bhakheegaje awe kwejelwa, lyoli bhakhayɨbha anza bhakhabhɨzya kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɨleelo kʉ zya kʉzyʉkha abhafwe, bhʉlɨ, mutabhaziizye mu Wusimbe uWufinjile she ʉMʉlʉngʉ ábhabhuziizye kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ɨne ne Mʉlʉngʉ wa Abulahaamu, ne Mʉlʉngʉ wa Isaaka, khabhɨlɨ ne Mʉlʉngʉ wa Yaakobo’? ɄMʉlʉngʉ te wa bhafwe, lyoli wʉ Mʉlʉngʉ ʉwa bhuumi!” ");
INSERT INTO mgq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɨmpʉga ɨya bhantʉ we bhɨmvwa zɨnɨɨzyo, bhakhaswiga nhaani kʉ manyɨzyo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","We aBhafalisaayi bhɨmvwa kʉtɨ uYeesu abhatola aBhasadukaayi, bhakhabhʉngaana peeka. ");
INSERT INTO mgq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Weeka we áamɨle mumanyizyi wɨ ndajɨzyo, akhamʉbhʉzɨɨlɨzya uYeesu kʉmʉlɨnga akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mumanyizyi, mʉ ndajɨzyo zya Moose, ndajɨzyo bhʉlɨ ye mpɨtɨ kʉshɨla zyonti?” ");
INSERT INTO mgq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","UYeesu akhamwamʉla akhatɨ, “‘Ʉmʉgane ʉMwene ʉMʉlʉngʉ waakho kʉ mwoyo waakho wonti, na ku mupepu waakho wonti na kʉ njeele zyakho zyonti.’ ");
INSERT INTO mgq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɨnɨ ye ndajɨzyo ɨmpɨtɨ, khabhɨlɨ ye ya kwanda. ");
INSERT INTO mgq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɨya wʉbhɨlɨ yɨkʉkholana nɨ ya kwanda, yoope yɨkʉtɨ, ‘Ʉmʉgane uwamwinyu anza she uyiganile wʉneewe.’ ");
INSERT INTO mgq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ɨndajɨzyo zɨbhɨlɨ ziniizi, zye lwalo lwɨ ndajɨzyo zyonti nu wusimbe ʉwa bhakuwi.” ");
INSERT INTO mgq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ABhafalisaayi we bhabhungaanile, uYeesu ábhabhuziliziizye átɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mʉkʉlola bhʉlɨɨbhʉlɨ kʉ zya Kilisiti? Bhʉlɨ, mwana wa naanu?” Bhakhamwamʉla bhakhatɨ, “Mwana ʉwa shɨkholo sha mwene uDaudi.” ");
INSERT INTO mgq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Khooni khe uDaudi we akhalongolwaga nu Mupepu wa Mʉlʉngʉ, akʉmʉtekha uKilisiti, kʉtɨ Mwene? Kwe kʉtɨ álonjile átɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ɄMwene ámubhuziizye ʉMwene waanɨ átɨlɨ, “Yɨɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo, paka we nabhabhɨɨkha abhalʉgʉ bhaakho paasɨ pa vɨnama vwakho.”’ ");
INSERT INTO mgq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ɨnga uDaudi akʉmʉtekha uKilisiti akʉtɨ Mwene, pe uKilisiti angabha mwana waakwe anza bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Atalɨɨpo umuntu we akhamwamʉla lyolyonti uYeesu. Khabhɨlɨ kufuma isiku liliila nʉʉmo umuntu we álinjiziizye kʉmʉbhʉzɨɨlɨzya winza uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pe uYeesu akhayɨbhʉʉzya ɨmpʉga ɨya bhantʉ na bhalandati bhaakwe akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abhamanyizyi abhɨ ndajɨzyo na Bhafalisaayi bhalɨ nʉ waamʉlo ʉwa kwilulanya ɨndajɨzyo zya Moose. ");
INSERT INTO mgq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ishi zyonti zye bhakʉbhabhʉʉzya mʉzɨlemaje na kʉzɨbhomba. Ɨleelo mʉtakhalandate ɨmbombo zyabho, kʉnongwa ye abheene bhatakʉzɨbhomba zye bhakʉmanyɨzya. ");
INSERT INTO mgq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Abheene bhakupinya amazigo amamwamu na kʉbhapɨmbɨzya abhantʉ mʉ vɨpʉngo, ɨleelo abheene bhatakwanza kʉlɨnjɨzya kʉbhʉʉsya na khasamba akhɨ nyoobhe kʉpɨmba. ");
INSERT INTO mgq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Abheene bhakʉbhomba ɨmbombo zyonti zɨnɨɨzyo ɨnga abhantʉ bhabhatendeele. Bhakʉkwata ɨvɨbeeza ɨvwa magwembe ɨvɨbaaba kʉshɨla ɨvwa bhanjɨ, vwe visimbiilwe ɨndajɨzyo, na kwonjezya amapintilwi aga menda gaabho aga kupuutila kʉshɨla aga bhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bhakʉyɨgana nhaani kwɨkhala mʉ matengo aga pɨlongolela mu vikulukulu na kwɨkhala mʉ matengo aga lushindikho mu masinagoogi. ");
INSERT INTO mgq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bhakʉyɨgana kʉtɨ abhantʉ bhabhalamʉkhaje ku lushindikho mʉ manaalo na kʉtɨ bhabhatekhaje bhatɨnjɨ, ‘Mumanyizyi.’ ");
INSERT INTO mgq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ɨleelo ɨmwe bhatabhatekhaje kʉtɨ, ‘Mumanyizyi!’ Kʉnongwa ye mʉlɨ nu Mumanyizyi weeka mwene, nɨɨmwe mwenti mwe bhanholo mʉ lwɨtɨkho. ");
INSERT INTO mgq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Khabhɨlɨ mʉtamʉtekhaje umuntu wowonti kʉtɨ, ‘Taata’ mʉ nsɨ umu, kʉnongwa ye mʉlɨ nʉ Taata wiinyu weeka mwene we alɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Khabhɨlɨ bhatabhatekhaje kʉtɨ, ‘Bhalongozi,’ kʉnongwa ye mʉlɨ nu Mulongozi weeka mwene, we wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umuntu wowonti we akwanza kʉbha mʉsongo wiinyu, akwanzɨwa kʉbha mubhombi wiinyu. ");
INSERT INTO mgq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Umuntu wowonti we akʉyɨzʉvwa, ʉMʉlʉngʉ akhayimwisya. Ɨleelo umuntu wowonti we akuyiisya, ʉMʉlʉngʉ akhayɨmʉzʉvwa. ");
INSERT INTO mgq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mʉsheleeye ɨmwe bhamanyizyi abhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Ɨmwe kʉ manyɨzyo zyinyu mukubhadindila abhantʉ kwinjila mʉ wʉmwene ʉwa kʉmwanya, ɨmwe mʉneemwe mutakwinjila. Khabhɨlɨ mʉtakʉbhɨtɨshɨzya abhantʉ bhe bhakwanza kwinjila.  ");
INSERT INTO mgq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Mʉsheleeye ɨmwe bhamanyizyi bhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mʉkʉfwʉla ivintu vwa bhafwɨle. Khabhɨlɨ mʉkʉyɨlolesya kʉtɨ mwe bhagolosu, mukupuuta impuuto intali. Pe shɨnɨɨsho, mʉkhayɨpata ulufundo ʉlʉpɨtɨ kufuma kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mʉsheleeye mubhamanyizyi abhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mʉkʉshʉʉla mwa sʉmbɨ na mʉ nsɨ inyuumu ɨnga mʉmʉgalʉlanye umuntu weeka kʉbha mulandati wa lupuuto lwinyu. Ɨleelo ɨnga mwamʉgalʉlanya umuntu wʉnʉʉyo, mʉkʉmʉteezya, akʉkhondela kwinjila kʉ mwoto we wutakuzima naalumo kʉbhashɨla ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mʉsheleeye ɨmwe mubhalongozi mwe mʉtakʉlola! Kʉnongwa ye mʉkʉtɨ, ‘Ɨnga umuntu akʉlapa ku Nyumba iMfinjile, te khabhiibhi. Ɨleelo ɨnga akʉlapa ku zahaabu ye yɨlɨ mu Nyumba iMfinjile, umuntu wʉnʉʉnʉ akwanzɨwa kʉbhomba anza she álapile.’ ");
INSERT INTO mgq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwe bhalema, khabhɨlɨ mʉlɨ ngatɨ mʉtakʉlola! Khooni khe khinza kʉshɨla akhanjɨ? Bhʉlɨ, zahaabu, awe iNyumba iMfinjile ye yɨkʉyɨbhɨɨkha izahaabu kʉbha mfinjile? ");
INSERT INTO mgq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Khabhɨlɨ mʉkʉtɨ, ‘Ɨnga umuntu akʉlapa kʉ shɨgemo she shɨlɨ mu Nyumba iMfinjile, te nongwa. Ɨleelo ɨnga akʉlapa ku mfinjile ye yɨlɨ pa shɨgemo, akwanzɨwa abhombaje anza she álapile.’ ");
INSERT INTO mgq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɨmwe mʉlɨ ngatɨ bhe bhatakʉlola! Khooni khe khinza kʉshɨla akhanjɨ? Bhʉlɨ, mfinjile zɨnɨɨzyo awe shɨgemo she shɨkʉbhɨɨkha izahaabu kʉbha mfinjile? ");
INSERT INTO mgq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","We akʉlapa kʉ shɨgemo, akʉlapa kʉ shɨgemo shɨnɨɨsho na ku vintu vwonti vwe vɨlɨ pa shɨgemo. ");
INSERT INTO mgq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Umuntu wowonti we akʉlapa ku Nyumba iMfinjile, akʉlapa ku Nyumba yɨnɨɨyo na kwa we akwɨkhala mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Woope we akʉlapa kʉmwanya, akʉlapa kwɨ tengo ɨlya shɨmwene ɨlya Mʉlʉngʉ na kwa we akwɨkhala pɨ tengo lɨnɨɨlyo. ");
INSERT INTO mgq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mʉsheleeye ɨmwe bhamanyizyi abhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mukufumwa ɨvwa pi shumi, amatʉndʉ aga mʉnanaa ge gakununshiilila, ibinzaali, ni mbeyu izyi jila, ɨleelo muzileshile zye mpɨtɨ nhaani mʉ ndajɨzyo anzu wugolosu, ishisa, nʉ lwɨtɨkho. Zɨnɨɨzyo zye mʉkhondeeye kʉbhomba sita kwɨwa aganjɨ. ");
INSERT INTO mgq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɨmwe bhalongozi mwe mʉtakʉlola! Kʉnongwa ye mʉkʉsʉʉya inyanyanzi, ɨleelo mukumila ɨngamɨla! ");
INSERT INTO mgq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mʉsheleeye ɨmwe mubhamanyizyi abhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mʉkwozya ʉlʉpɨndɨ ni shiibho munzi, ɨleelo mukaasi mwizuuye uwufwuli nu wulyovi. ");
INSERT INTO mgq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɨmwe Bhafalisaayi, mwe mʉtakʉlola! Yozyaji suuti mukaasi mʉ lʉpɨndɨ, ɨnga munzi mwope mʉbhe muzelupile. ");
INSERT INTO mgq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mʉsheleeye ɨmwe bhamanyizyi abhɨ ndajɨzyo na muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mukholiine nɨ mbɨɨpa zye zipashiilwe ʉwʉlongo, zye kunzi zɨkʉlolekha nyinza, ɨleelo mukaasi zyizuuye amafupa aga bhafwe nu wubhozu ʉwa vɨkholo nɨ vɨkholo. ");
INSERT INTO mgq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","She shɨnɨɨsho, nɨɨmwe kunzi mʉkʉlolekha kʉ bhantʉ kʉtɨ mwe bhagolosu, ɨleelo mukaasi mwizuuye ishisa ɨshɨ lenga nu wubhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mʉsheleeye ɨmwe bhamanyizyi abhɨ ndajɨzyo nɨɨmwe muBhafalisaayi, mubhi shisa ɨshɨ lenga! Kʉnongwa ye mʉkʉzenga ɨmbɨɨpa ɨzya bhakuwi na kʉzɨbhɨngʉlanya ɨmbɨɨpa ɨzya bhantʉ abhagolosu. ");
INSERT INTO mgq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mʉkʉlonga kʉtɨ, ‘Bhanje ɨtwe twálɨɨpo mʉ khabhalɨlo akha bhamaama bhɨɨtʉ, nhanɨ tutímvwanile nabho kʉbhagoga abhakuwi abha Mʉlʉngʉ.’ ");
INSERT INTO mgq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Shɨnɨɨsho, mukusimishizya mʉneemwe kʉtɨ mwe bhaana bha bhantʉ bhe bhábhagojile abhakuwi abha Mʉlʉngʉ! ");
INSERT INTO mgq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ishi malilizyaji ɨmbombo ye abhamaama bhiinyu bhándile! ");
INSERT INTO mgq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ɨmwe mʉnjokha, mʉbhaana bhɨ njokha! Mʉkhayɨpona bhʉlɨɨbhʉlɨ kʉlongwa kʉ mwoto? ");
INSERT INTO mgq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kʉnongwa yɨnɨɨyo, ɨnkʉbhasonteelezya kukwinyu abhakuwi bha Mʉlʉngʉ, abhantʉ abhɨ njeele, na bhamanyizyi. Ɨleelo bhamu mʉ bhanaabho, mʉkhayɨbhagoga na kʉbhakhomeela pa shɨkhobhenhanyo, bhamu mʉkhayɨbhakhoma nɨ sambogo mu masinagoogi, bhamu mʉkhayɨbhayɨmvwa mʉ nhaaya nɨɨzyo nɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ishi, ɨmwe mukhayifundwa kʉnongwa ya bhagolosu bhonti bhe bhágogiilwe, kufuma agogwe uAbeli we áamɨle mugolosu, kufishila pe ágogiilwe uZakaliya ʉmwana wa Balakiya, we mwámugojile pakaasi pa shɨgemo na Pafinjile. ");
INSERT INTO mgq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, abhantʉ abha khabhalɨlo ɨkha bhakhayifundwa kʉ zya ganaago gonti.” ");
INSERT INTO mgq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","UYeesu akhatɨ, “Ɨmwe mʉbhantʉ abha mu Yelusaleemu, mʉkʉbhagoga abhakuwi na kʉbhakhoma na mawe bhe ʉMʉlʉngʉ abhasonteleziizye kukwinyu. Akhinji bhʉʉlo, naayiganile kʉbhabhʉngaanɨkha ɨmwe anzɨ nkʉkʉ she yɨkwʉbhatɨla ʉtwanankʉkʉ twakwe mu mapikho gaakwe, ɨleelo mʉkhakhaana! ");
INSERT INTO mgq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yeenya, inyumba yiinyu yɨtɨsyale lipongoolwi! ");
INSERT INTO mgq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ɨnkʉbhabhʉʉzya kʉtɨ, te mʉkhandole winza paka pe mʉkhayɨlonga kʉtɨ, ‘Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ!’” ");
INSERT INTO mgq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","UYeesu akhasogola mwi linga ilyi Nyumba iMfinjile. We akʉsogola, abhalandati bhaakwe bhakhabhala pe áamɨle ɨnga bhamʉlanje inyumba zye zyámɨle mwi linga ilyi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ɨleelo uYeesu akhabhaamʉla akhatɨ, “Ʉkʉgalola amayumba amapɨtɨ ɨga? Nalyoli ɨnkʉbhabhʉʉzya, gonti ganaaga gakhayɨpongolwa, te lɨkhasyale iwe naalimo pamwanya pi we ɨlyamwabho!” ");
INSERT INTO mgq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pɨlongolela, uYeesu we ayɨkhaaye mwɨ gamba ɨlya Mizeituni, abhalandati bhaakwe bhakhamʉbhalɨla kukwilu. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Tʉbhʉʉzye, ɨnongwa ziniizi zikhayifumila liino? Khabhɨlɨ shɨlolesyo shooni she shɨkhayɨlolesya kwɨnza kwakho nʉ wʉmalɨlɨshɨlo ʉwɨ nsɨ?” ");
INSERT INTO mgq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","UYeesu akhabhaamʉla akhatɨ, “Mʉbhe amiiso, umuntu wowonti atakhabhakhopele! ");
INSERT INTO mgq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kʉnongwa ye abhinji bhakhayɨnza kwɨ taawa lyanɨ, bhakhayɨyɨtekhaga kʉtɨ, ‘Ɨne ne ne Kilisiti!’ Bhoope bhakhayɨbhakhopela abhantʉ abhinji. ");
INSERT INTO mgq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Mʉkhayɨmvwa ɨnongwa ɨzya wʉlʉgʉ ni mpempu ɨzya wʉlʉgʉ. Mʉbhe amiiso, mʉtakhagandʉshe kʉnongwa ye zɨnɨɨzyo yɨkwanzɨwa kʉtɨ zifumile, ɨleelo ʉwʉmalɨlɨshɨlo wuula wʉkhayɨbha wʉshɨɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɨnsɨ yeeka yɨkhayɨlwanga nɨ nsɨ iyinji, nʉ wʉmwene weeka wʉkhayɨlwanga nʉ wʉmwene ʉwamwabho. Kʉkhayɨbha ɨnzala ni viyingayinga ɨvwɨ nsɨ, uku nʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vɨnɨɨvwo vwe vɨkhayɨbha wandɨlo bhʉʉlo wa mayɨmba, anza she akʉbhabhwa ʉmwantanda we akwanda kʉpaapa. ");
INSERT INTO mgq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mʉ khabhalɨlo khanaakho, mʉkhayɨlemwaga, bhakhayɨbhayɨmvwaga, na kʉbhagoga, abhantʉ abhɨ nsɨ zyonti bhakhayibhaviitilwa, kʉnongwa ye mwe bhalandati bhaanɨ. ");
INSERT INTO mgq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pe abhinji bhakhayɨlʉlekha ʉlwɨtɨkho lwabho. Bhakhayɨlonjelelana na kuviitana bhɨɨbho na bhɨɨbho. ");
INSERT INTO mgq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Mʉ khabhalɨlo khanaakho, bhakhayifumila abhakuwi abhinji abhɨ lenga bhe bhakhayɨbhateezya abhantʉ abhinji. ");
INSERT INTO mgq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Khabhɨlɨ kʉnongwa ɨya kwonjela imbiibhi, ʉlʉgano lwa bhinji lʉkhayɨbha ɨtende. ");
INSERT INTO mgq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ɨleelo umuntu we akhayijimbiilila kufishila kʉmpeleela, we ʉMʉlʉngʉ akhayɨmʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Khabhɨlɨ iNtumi iNyinza ɨzya wʉmwene ʉwa kʉmwanya zɨkhayɨlʉmbɨɨlɨlwa mʉ nsɨ zyonti, ɨnga wʉbhe wukeeti kʉ bhantʉ bhonti. Panaapo pe kʉmpeleela kukhayifikha. ");
INSERT INTO mgq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pe mʉkhayɨlɨlola ‘inanganyi lye lɨkʉnanganya’ lye lyálonjiilwe nu mukuwi uDanieli, lyɨmɨlɨɨye aPafinjile. We akʉbhaazya amazwi ganaaga, azyaganyaaje. ");
INSERT INTO mgq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pe bhe bhalɨ mʉ nsɨ ɨya Yudeeya, bhakhashɨmbɨlɨlaje mʉ magamba. ");
INSERT INTO mgq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Woope we alɨ kʉ shɨsonyonje, atakhiishe kwega ivintu vwakwe mu nyumba. ");
INSERT INTO mgq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Umuntu we ayagaatile ku shiizi atakhasheele kʉgalʉkha kʉlʉsalo kʉbhala kwega ʉmwenda waakwe, akhashɨmbɨlaje! ");
INSERT INTO mgq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bhasheleeye abhantanda bhe bhakhayɨbha pa wumwamu na bhe bhakhayonsyaga mu nsiku zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Puutaji kwa Mʉlʉngʉ ɨnga we mʉkʉshɨmbɨla yɨtakhabhe mʉ khabhalɨlo akhi mpepu awe pi siku ɨlyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kʉnongwa ye mʉ khabhalɨlo khanaakho, kʉkhayɨbha na mayɨmba amapɨtɨ ge gatafumiiye naalumo kufuma pe ʉMʉlʉngʉ ápelile ɨnsɨ kufishila ishi. Khabhɨlɨ amayɨmba ganaago te gakhafumile winza. ");
INSERT INTO mgq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ɨnga ʉMʉlʉngʉ atazɨpʉngʉzyaje insiku zɨnɨɨzyo, nhanɨ atalɨɨpo umuntu ʉwa kʉpona. Ɨleelo kʉnongwa ɨya bhasaabhʉlwa bhaakwe, insiku zɨnɨɨzyo zɨkhayɨbha mfupi. ");
INSERT INTO mgq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mʉ khabhalɨlo khanaakho, ɨnga umuntu akʉbhabhʉʉzya kʉtɨ, ‘Yeenya, uKilisiti alɨ ɨpa,’ awe ‘Alɨ kuula!’ Mʉtakhɨɨtɨshe. ");
INSERT INTO mgq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kʉnongwa ye bhakhayifumila bhe bhakʉyɨtekha kwɨ lenga kʉtɨ bhabha Kilisiti, na bhakuwi abhɨ lenga. Bhakhayɨbhombaga ɨvɨlolesyo ɨvɨpɨtɨ na mayele aga kʉbhakhopela abhantʉ, poope na bhasaabhʉlwa bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ishi ɨmwe, mʉbhe amiiso! Ɨne naatala suuti nabhasokha we zyonti zɨnɨɨzyo zɨshɨɨlɨ kufumila. ");
INSERT INTO mgq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pe ɨnga bhakʉbhabhʉʉzya bhakʉtɨ, ‘Yeenya, uKilisiti alɨ mu shilozu,’ mʉtakhasheele kʉbhala kwenya. Awe ɨnga bhakʉtɨ, ‘Yeenya, alɨ ku lupitu,’ mʉtakhɨɨtɨshe. ");
INSERT INTO mgq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kʉnongwa ye anza she imvula yɨkʉmwangʉkha kufuma kuwutukulo paka kʉwʉswelo, she yɨkhayɨbha we akwɨnza ʉMwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Poponti pe shɨlɨ she shifuuye, pe abhashɨpʉngʉ bhakʉbhʉngaana. ");
INSERT INTO mgq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nalʉbhɨlo we insiku zɨnɨɨzyo ɨzya mayɨmba zyashɨla, ‘Ɨzʉbha likhayigwa akhiisi, umwezi woope te wʉkhalamaje, ɨnzota zyope zɨkhayɨlendaga paasɨ kufuma kʉmwanya, na makha aga kʉmwanya goope gakhayiyinga.’ ");
INSERT INTO mgq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Pe ɨshɨlolesyo ɨsha Mwana wa Muntu shɨkhayɨlolekha kʉmwanya. Abhantʉ abhɨ nsɨ zyonti bhakhayanda kʉyɨlʉmbʉʉzya. Bhakhayɨmʉlola ʉMwana wa Muntu akwɨnza mʉ mabhɨngo alɨ na makha nu wumwamu ʉwʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Woope akhayɨbhasonteelezya abhakhabhɨzya bhaakwe bhe bhalɨ ni kakaavu lye lɨkʉkʉʉta, bhakhayɨbhabhʉngaanya abhasaabhʉlwa kufuma mʉmbalɨ zyonti zini ɨzyɨ nsɨ, kufuma kʉwʉmalɨlɨshɨlo weeka ʉwa kʉmwanya kufishila ʉwʉmalɨlɨshɨlo ʉwamwabho.” ");
INSERT INTO mgq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","UYeesu akhajendeelela kʉlonga akhatɨ, “Mʉmanyɨlaje ɨshɨkholanyo ishi kwi ɨlya mutiini. Kʉnongwa ye ɨmpaaswa zyakwe we zyanda kuduvwa na kʉmezya amatʉndʉ, mʉkʉmanya kʉtɨ akhabhalɨlo akhi mvuno khapalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","She shɨnɨɨsho, nɨɨmwe ɨnga mwazɨlola zyonti zɨnɨɨzyo zɨkʉbhombekha, mʉkhamanyaje kʉtɨ ɨndɨ papɨɨpɨ nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nalyoli ɨnkʉbhabhʉʉzya, ishipaafi ishi te shɨshɨle we ziniizi zyonti zɨshɨɨlɨ kufumila. ");
INSERT INTO mgq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kʉmwanya na paasɨ vɨkhayɨshɨla, ɨleelo amazwi gaanɨ te gakhaashɨle naalumo. ");
INSERT INTO mgq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ɨleelo ku zyi siku liila na kʉ zyɨ saala yiila, atalɨɨpo umuntu we amanyile awe abhakhabhɨzya abha kʉmwanya, awe ʉMwana, lyoli ʉTaata waakwe mwene. ");
INSERT INTO mgq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kʉnongwa ye anza she yáamɨle mu nsiku ɨzya Noowa, she yɨkhayɨbha kwɨnza kwa Mwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kʉnongwa ye mu nsiku zɨnɨɨzyo we imvula imbiibhi yɨshɨɨlɨ kwɨnza, abhantʉ bhakhalyanga na kʉmwela, bhakheegaga na kwejelwa, kufishila pi siku liila lye ʉNoowa akhinjila mu safina. ");
INSERT INTO mgq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abhantʉ bhanaabho bhatámanyile kʉtɨ khooni khatifumile kufishila pe imvula imbiibhi yɨkhɨnza na kʉbhagoga bhonti. Shɨnɨɨsho she yɨkhayɨbha kwɨnza kwa Mwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mʉ khabhalɨlo khanaakho abhantʉ bhabhɨlɨ bhakhayɨbha ku shiizi, weeka akhayɨnyamvʉlwa, ʉmo te akhanyamvʉlwe. ");
INSERT INTO mgq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Khabhɨlɨ abhantanda bhabhɨlɨ bhakhayɨsyanga, weeka akhayɨnyamvʉlwa, ʉmo te akhanyamvʉlwe. ");
INSERT INTO mgq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mʉbhe amiiso kʉnongwa ye mutamanyile isiku lye akhayɨnza ʉMwene wiinyu. ");
INSERT INTO mgq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mʉmanye akhinza kʉtɨ, uwi nyumba abhanje amanyaje akhabhalɨlo khe umwibha akwɨnza, angɨɨkhala amiiso kʉtɨ amudinde umwibha atakhadobhole inyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kʉnongwa yɨnɨɨyo, nɨɨmwe mʉyɨlɨnganyaaje kʉnongwa ye mutamanyile akhabhalɨlo khe akhayɨnza ʉMwana wa Muntu.” ");
INSERT INTO mgq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","UYeesu akhabhʉzɨɨlɨzya akhatɨ, “Umubhombi umusunde, ʉwɨ njeele, we alikwi? Wʉnʉʉyo we ʉmʉpɨtɨ waakwe akʉmʉbhɨɨkha abhe mwimiilili wa bhamwabho na kʉʉbhapa ishaakulya akhabhalɨlo khe khakhondeeye. ");
INSERT INTO mgq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Asayiilwe umubhombi ʉla we ʉmwene waakwe agalʉkha, akhayɨmwaga akʉbhomba zye amulajiziizye. ");
INSERT INTO mgq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nalyoli ɨnkʉbhabhʉʉzya, akhayɨmʉbhɨɨkha kʉbha mʉpɨtɨ wɨ shʉʉma shaakwe shonti. ");
INSERT INTO mgq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ɨleelo umubhombi umubhiibhi, ɨnga akʉsɨɨbha mʉ mwoyo waakwe kʉtɨ, ‘Ʉmwene waanɨ akhaabha kʉgalʉkha,’ ");
INSERT INTO mgq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ayanda kʉbhakhoma abhabhombi abhamwabho, ayanda kulya na kʉmwela peeka na bhamwezi, ");
INSERT INTO mgq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ʉmwene waakwe akhayɨgalʉkha isiku lye atasʉbhɨɨye na khabhalɨlo khe atamanyile. ");
INSERT INTO mgq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pe akhayiimupa ulufundo ʉlʉpɨtɨ na kʉmʉbhɨɨkha peeka na bhi shisa ɨshɨ lenga. Kʉnʉʉkwo kwe bhakhayɨlɨla na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Mʉ khabhalɨlo khanaakho ʉwʉmwene ʉwa kʉmwanya wʉkhayɨkholana na bhalɨndʉ ishumi bhe bhálemile amataala gaabho, bhakhabhala kʉmʉposheela ʉwa weeji. ");
INSERT INTO mgq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bhasaanʉ bháamɨle bhalema, bhasaanʉ bháamɨle nɨ njeele. ");
INSERT INTO mgq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhalema bhaala bhálemile amataala gaabho sita kʉpaya amafuta aga kwonjezya. ");
INSERT INTO mgq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ɨleelo abhɨ njeele bhaala bhálemile amataala gaabho peeka nɨ mpayo ɨya mafuta mu nsupa zyabho aga kwonjezya. ");
INSERT INTO mgq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ʉwa weeji we akhaabha kwɨnza, abhalɨndʉ bhaala bhonti bhakhasinziila, bhakhagona utulo. ");
INSERT INTO mgq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ɨleelo uwusiku pakaasi, kʉkhabha nɨ shongo kʉtɨ, ‘Mwebheya, mwebheya, ʉwa weeji akwɨnza! Fumaji, bhalaji kʉmʉposheela.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nalʉbhɨlo abhalɨndʉ bhaala bhonti bhakhadaamʉkha na kʉlɨngaanya amataala gaabho. ");
INSERT INTO mgq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Abhalema bhaala bhakhabhabhʉʉzya abhɨ njeele bhakhatɨ, ‘Tupe amafuta mashe kʉnongwa ye amataala gɨɨtʉ gakuzima.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ɨleelo abhɨ njeele bhaala bhakhabhaamʉla bhakhatɨ, ‘Ndaali! Amafuta ge tʉlɨ nago, gatangatʉkwɨla ɨtwe, nɨɨmwe. Kwashi mʉbhale kwe bhakʉkazya ɨnga mʉyɨkalɨle mʉneemwe.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ɨleelo abhalema bhaala we bhakʉbhala kʉkala amafuta, ʉwa weeji akhɨnza. Abhalɨndʉ bhe bháyilinganyiinye, bhakhinjila peeka nʉ wa weeji mu nyumba ɨya weeji, ulwiji lʉkhɨgalɨlwa. ");
INSERT INTO mgq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pɨlongolela, abhalema bhaala bhakhagalʉkha, bhakhabhɨlɨshɨla bhakhatɨ, ‘We mwene! Mwene! Twigulile ulwiji!’ ");
INSERT INTO mgq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ɨleelo ʉwa weeji akhabhaamʉla akhatɨ, ‘Nalyoli ɨnkʉbhabhʉʉzya, intabhamanyile!’ ” ");
INSERT INTO mgq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pe uYeesu akhatɨ, “Ishi mʉbhe amiiso, kʉnongwa ye mutamanyile isiku awe ɨsaala.” ");
INSERT INTO mgq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","UYeesu akhajendeelela kʉlonga akhatɨ, “Ʉwʉmwene ʉwa kʉmwanya wʉkʉkholana nu muntu we akhanzaga kʉshʉʉla. Akhabhabhɨlɨshɨla abhabhombi bhaakwe na kʉʉbhapa ɨshʉʉma shaakwe kʉtɨ bhajendelezyaje. ");
INSERT INTO mgq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ámupiiye umubhombi weeka weeka kʉlandatana na makha gaakwe. Weeka ámpiiye ɨtalanta zɨsaanʉ, ʉwa wʉbhɨlɨ ɨtalanta zɨbhɨlɨ nʉ wa wʉtatʉ ámupiiye ɨtalanta yeeka, pe akhashʉʉla. ");
INSERT INTO mgq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Nalʉbhɨlo, umubhombi we ʉmʉpɨtɨ waakwe ámupiiye ɨtalanta zɨsaanʉ, akhabhala nazyo kʉbhombela ɨmbombo ɨya kʉkazya, zɨkhapaapa ɨzyamwabho zɨsaanʉ. ");
INSERT INTO mgq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Woope umubhombi we ʉmʉpɨtɨ waakwe ámupiiye ɨtalanta zɨbhɨlɨ, akhabhala nazyo kʉmbombela ɨmbombo ɨya kʉkazya, zɨkhapaapa ɨzyamwabho zɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ɨleelo umubhombi ʉla we ʉmʉpɨtɨ waakwe ámupiiye ɨtalanta yeeka, akhabhala kʉbana ilyina akhayifushila ɨtalanta ya mʉpɨtɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“We akhabhalɨlo akhatali khaashɨla, ʉmʉpɨtɨ waabho akhagalʉkha kwe áshuulile. Pe akhabhabhɨlɨshɨla abhabhombi bhaakwe bhaala, akhanda kwenya she bhabhombeeye ɨtalanta zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Umubhombi ʉla we áposheleeye ɨtalanta zɨsaanʉ, akhaleeta ɨtalanta ɨzyamwabho zɨsaanʉ, akhamʉbhʉʉzya ʉmʉpɨtɨ waakwe akhatɨ, ‘We mwene, wámpiiye ɨtalanta zɨsaanʉ, yeenya, inkabhile ɨtalanta ɨzyamwabho zɨsaanʉ.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ʉmʉpɨtɨ waakwe akhamʉbhʉʉzya akhatɨ, ‘Ubhombile akhinza, we mubhombi umwinza, khabhɨlɨ we musunde! Kʉnongwa ye waamɨle we musunde ku vinsi, ishi ɨntɨkʉbhɨɨshe ʉbhe we mwimiilili ʉwɨ shʉʉma ɨshɨpɨtɨ. Nzaaga ʉseshelaje peeka nʉ mʉpɨtɨ waakho.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Akhɨnza we áposheleeye ɨtalanta zɨbhɨlɨ, akhatɨ, ‘We mwene, wámpiiye ɨtalanta zɨbhɨlɨ, yeenya, inkabhile ɨtalanta ɨzyamwabho zɨbhɨlɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ʉmʉpɨtɨ waakwe akhamʉbhʉʉzya akhatɨ, ‘Ubhombile akhinza, we mubhombi umwinza, khabhɨlɨ we musunde! Kʉnongwa ye waamɨle we musunde ku vinsi, ishi ɨntɨkʉbhɨɨshe ʉbhe we mwimiilili wɨ shʉʉma ɨshɨpɨtɨ. Nzaaga ʉseshelaje peeka nʉ mʉpɨtɨ waakho.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Akhɨnza we áposheleeye ɨtalanta yeeka, akhatɨ, ‘We mwene, naamanyile kʉtɨ ɨwe we muntu umugomu nhaani. Ukuvuna pe utawaalile na kʉbhʉngaanya pe utapesile. ");
INSERT INTO mgq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nógopile kʉyɨteezya ɨtalanta yaakho, pe ɨnhabhala inhayifushila mu lyina. Ishi, yeega ɨtalanta yaakho ɨnɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ʉmʉpɨtɨ waakwe akhamwamʉla akhatɨ, ‘Ɨwe we mubhombi umubhiibhi khabhɨlɨ we mʉkhata! Waamanyile kʉtɨ ɨne inkuvuna pe intawaalile, khabhɨlɨ ɨnkʉbhʉngaanya pe intapesile. ");
INSERT INTO mgq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pe waakhondeeye kʉbhɨɨkha ɨtalanta yaanɨ kʉ bhe bhakʉpaapɨzya kʉtɨ we ɨnkʉgalʉkha ɨneeje ɨtalanta yaanɨ peeka na zye zyonjeeye.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pe ʉmʉpɨtɨ waakwe akhalajɨzya akhatɨ, ‘Fwuli ɨtalanta yɨnɨɨyo, muumupe we ayonjeziizye ɨzyamwabho ishumi.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kʉnongwa ye wowonti we akʉshɨbhombela akhinza ɨshɨkʉnjɨlwa shaakwe, ʉMʉlʉngʉ akʉmwonjezya ku winji. Ɨleelo we atakʉshɨbhombela ɨshɨkʉnjɨlwa shaakwe, ʉMʉlʉngʉ akʉfwʉla ni shinsi she alɨ nasho. ");
INSERT INTO mgq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Umubhombi ʉnʉ we atakhondeeye, mʉsʉmbe kunzi ku khiisi kwe akhayɨlɨlaga na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","UYeesu akhajendeelela kʉbhabhʉʉzya abhalandati bhaakwe akhatɨ, “Akhabhalɨlo khe ʉMwana wa Muntu akhayɨnza mu wumwamu waakwe peeka na bhakhabhɨzya bhaakwe bhonti, pe akhayɨɨkhala pɨ tengo lyakwe ɨlya wumwamu. ");
INSERT INTO mgq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abhantʉ abhɨ nsɨ zyonti bhakhayɨbhʉngaana pɨlongolela yaakwe. Woope akhayɨbhagabhʉlanya anza she umudiimi akʉgabhʉlanya ɨngoole ni mbuzi. ");
INSERT INTO mgq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Akhayɨzɨbhɨɨkha ɨngoole kʉmbalɨ yaakwe ɨya kʉndɨɨlo ni mbuzi kʉmbalɨ yaakwe ɨya kʉmongo. ");
INSERT INTO mgq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pe ʉMwene akhayɨbhabhʉʉzya bhaala bhe bhalɨ kʉmbalɨ yaakwe ɨya kʉndɨɨlo akhayɨtɨ, ‘Nzaaji, mwe musayiilwe nʉ Taata waanɨ. Yinjilaji mʉ wʉmwene we ʉTaata waanɨ álinganyiinye nzɨɨla kufuma pe ɨnsɨ yápeliilwe. ");
INSERT INTO mgq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kʉnongwa ye ɨnzala we yándumile, mwámpiiye ishaakulya, we náamɨle nɨ shʉʉmɨlwa, mwámpiiye aminzi, náamɨle ne mujeni, mwámposheleeye mu nyumba zyinyu. ");
INSERT INTO mgq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Khabhɨlɨ náamɨle ishitali, mʉkhankwatɨzya amenda, nábhinile, mwínzile kʉneenya. We ɨndɨ mwɨ jeela, mwínzile kʉneenya.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pe abhagolosu bhakhayɨmwamʉla bhakhayɨtɨ, ‘We Mwene, liino pe twákulolile ɨnzala yikulumile, tukhaakupa ishaakulya? Awe we ʉlɨ nɨ shʉʉmɨlwa tukhaakupa aminzi? ");
INSERT INTO mgq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Khabhɨlɨ liino pe twákulolile we mujeni tʉkhakʉposheela? Awe we ʉlɨ shitali tʉkhakʉkwatɨzya? ");
INSERT INTO mgq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Khabhɨlɨ liino pe wáamɨle we mubhinu tukhakubhinia, awe we wáamɨle mwɨ jeela tʉkhɨnza kʉkwenya?’ ");
INSERT INTO mgq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pe ʉMwene akhayɨbhaamʉla akhayɨtɨ, ‘Nalyoli ɨnkʉbhabhʉʉzya, lyolyonti lye mwámʉbhombeeye weeka mʉ bhanholo bhaanɨ ɨbha bhashe, mwámbombeeye neene.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pe akhayɨbhabhʉʉzya bhaala bhe bhalɨ kʉmbalɨ yaakwe ɨya kʉmongo akhayɨtɨ, ‘Yeepi ɨpa ɨmwe mwe muguniilwe! Bhalaji kʉ mwoto we wutakuzima naalumo, we abhishiliilwe uSeetani na bhakhabhɨzya bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kʉnongwa ye náamɨle nɨ nzala, mutámpiiye ishaakulya, náamɨle nɨ shʉʉmɨlwa, mutámpiiye aminzi. ");
INSERT INTO mgq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Khabhɨlɨ náamɨle ne mujeni, mʉtámposheleeye, náamɨle ishitali, mutánkwatiziizye. Náamɨle ne mubhinu, náamɨle mwɨ jeela, mutínzile kʉneenya.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Pe bhoope bhakhayɨmwamʉla bhakhayɨtɨ, ‘We Mwene, liino pe twákulolile, ʉlɨ nɨ nzala awe ʉlɨ nɨ shʉʉmɨlwa, awe we mujeni, awe ʉlɨ shitali, awe we mubhinu, awe ʉlɨ mwɨ jeela, tutákwavwizye?’ ");
INSERT INTO mgq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Woope akhayɨbhaamʉla akhayɨtɨ, ‘Nalyoli ɨnkʉbhabhʉʉzya, lyolyonti lye mʉtámʉbhombeeye weeka mʉ bhashe ɨbha, mʉtámbombeeye neene.’ ");
INSERT INTO mgq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Pe bhanaabho bhakhayinjila mu lufundo ʉlwa wiila na wiila. Ɨleelo abhagolosu bhakhayinjila mu wuumi ʉwa wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","We uYeesu aamala kʉlonga amazwi ganaago gonti, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mumanyile kʉtɨ we zyashɨla insiku zɨbhɨlɨ, tʉtɨbhe ni shikulukulu ɨshɨ Pasaaka. ɄMwana wa Muntu atɨlonjeelelwe na kʉkhomeelwa pa shɨkhobhenhanyo.” ");
INSERT INTO mgq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Akhabhalɨlo khanaakho, abhapɨtɨ abha bhapuutili na bhasongo abha Bhayahuudi, bhakhabhʉngaana mu nyumba ɨya lʉbhʉngaano ɨya mupuutili ʉmʉpɨtɨ, we ɨtaawa lyakwe bhakhatɨnjɨ ʉKayaafa. ");
INSERT INTO mgq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhakhapanzanya kʉmʉlema uYeesu kukwilu ɨnga bhamʉgoje. ");
INSERT INTO mgq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɨleelo bhakhatɨ, “Tʉtakhasheele kʉbhomba ziniizi pi siku ilyi shikulukulu ɨshɨ Pasaaka, abhantʉ bhatakhabhombe ʉmʉyʉbhano.” ");
INSERT INTO mgq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","UYeesu we alɨ mʉ nhaaya ɨya mu Besaniya, mu nyumba ya Siimoni we ámuponiizye amaketa, ");
INSERT INTO mgq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","áyɨkhaaye akhalyanga ishaakulya. Akhɨnza ʉmwantanda ʉmo we áamɨle na khasupa akhinza akha mafuta agɨ nhela ɨmpɨtɨ ge gakununshiilila, akhamʉsejeelela uYeesu pe akulya akhamwitiilizya pi twe. ");
INSERT INTO mgq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abhalandati bhaakwe we bhazɨlola zɨnɨɨzyo, bhakhaviitwa nhaani bhakhatɨ, “Wa khooni uwunanganyi ʉwa mafuta wunuuwu? ");
INSERT INTO mgq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kʉnongwa ye amafuta ganaaga gayiiye kʉkazya kʉ nhela inyinji nhaani na kʉʉbhapa abhapɨɨna ɨnhela zɨnɨɨzyo!” ");
INSERT INTO mgq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","UYeesu akhamanya zye bhakhasɨɨbhaga, akhabhabhʉʉzya akhatɨ, “Khooni khe mʉkʉmʉyɨmvwa ʉmwantanda ʉnʉ? Ʉweene ambombeeye lye lyinza nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abhapɨɨna mʉlɨ nabho kukwinyu insiku zyonti, ɨleelo ɨne te ɨmbe peeka nɨɨmwe insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ʉmwantanda wʉnʉʉnʉ anitiliziizye amafuta ganaaga ɨnga kʉndɨngaanya kʉsyɨlwa kwanɨ. ");
INSERT INTO mgq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nalyoli ɨnkʉbhabhʉʉzya, poponti pe iNtumi iNyinza zɨkhayɨlʉmbɨɨlɨlwa mʉ nsɨ zyonti, lye ʉmwantanda ʉnʉ ambombela lɨkhayɨlongwa kʉmʉkʉmbʉkha.” ");
INSERT INTO mgq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pe ʉYʉʉda Sikalioti, weeka mu bhalandati bhaala ishumi na bhabhɨlɨ abha Yeesu, akhabhala kʉ bhapɨtɨ abha bhapuutili, ");
INSERT INTO mgq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akhabhʉzɨɨlɨzya akhatɨ, “Mutimpe akhooni ɨnga namʉlonjeelela uYeesu kukwinyu?” Pe bhakhaamupa ɨnhela ɨnsabhaazya amashumi gatatʉ. ");
INSERT INTO mgq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kufuma akhabhalɨlo khanaakho, ʉYʉʉda Sikalioti akhanda kwanza ɨdala ɨlya kʉmʉlonjeelela uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pi siku ɨlya kwanda ilyi shikulukulu ɨsha makaati ge gatabhishiilwe uwusafu, abhalandati bhakhabhala kwa Yeesu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ʉkwanza tʉbhale tʉkʉlɨnganɨzanye kwoshi ishikulukulu ɨshɨ Pasaaka?” ");
INSERT INTO mgq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","UYeesu akhabhaamʉla akhatɨ, “Bhalaji mʉ nhaaya ɨya mu Yelusaleemu kwa muntu ʉmo, mʉmʉbhʉʉzye kʉtɨ, ‘UMumanyizyi akʉtɨ, “Akhabhalɨlo khaanɨ khapalamɨɨye. Injiganile kulya ɨPasaaka peeka na bhalandati bhaanɨ mu nyumba yaakho.” ’ ” ");
INSERT INTO mgq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abhalandati bhakhabhomba anza she uYeesu ábhalajiziizye, bhakhalɨngaanya ɨPasaaka. ");
INSERT INTO mgq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","We kwabha shalyabheela, uYeesu na bhalandati bhaakwe ishumi na bhabhɨlɨ bhakhɨɨkhala kulya ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","We bhalɨ kulya, uYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, weeka wiinyu atɨndonjeelele kʉ bhalʉgʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abhalandati bhaakwe bhakhaswɨmɨɨlɨla nhaani, weeka weeka akhanda kʉmʉbhʉzɨɨlɨzya bhakhatɨnjɨ, “Mwene! Bhʉlɨ, neene?” ");
INSERT INTO mgq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","UYeesu akhabhaamʉla akhatɨ, “Ʉla we akʉsanzɨla mʉ shɨlɨɨlo peeka nɨɨne, we atɨndonjeelele kʉ bhalʉgʉ. ");
INSERT INTO mgq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ɄMwana wa Muntu atɨbhale anza she yisimbiilwe mu Wusimbe uWufinjile. Ɨleelo asheleeye umuntu we akʉmʉlonjeelela ʉMwana wa Muntu kʉ bhalʉgʉ! Yaamɨle kwashi kʉkwakwe umuntu wʉnʉʉyo nhanɨ atakhapapwaga.” ");
INSERT INTO mgq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pe ʉYʉʉda we atɨmʉlonjeelele uYeesu kʉ bhalʉgʉ, akhamʉbhʉzɨɨlɨzya akhatɨ, “Mumanyizyi! Bhʉlɨ, neene?” UYeesu akhamwamʉla akhatɨ, “Walonga wʉneewe.” ");
INSERT INTO mgq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","We bhakulya, uYeesu akheega ikaati, akhalɨsaya, akhamensula, akhaabhapa abhalandati bhaakwe, akhatɨ, “Yeeji mulye, uwu we mʉbhɨlɨ waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akheega ɨshɨkoopa, akhasalifwa kwa Mʉlʉngʉ, akhaabhapa, akhatɨ, “Mweleli mwenti mʉ shɨkoopa ishi. ");
INSERT INTO mgq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kʉnongwa ye ili lye lɨbhanda lyanɨ ɨlya lufingo lye likwitikha kʉnongwa ɨya bhantʉ abhinji ɨnga bhatʉʉyɨlwe imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ɨnkʉbhabhʉʉzya kʉtɨ, te ɨnhamwele winza idivaayi paka pi siku lye ɨnhayɨmwela idivaayi iyi zabiibu peeka nɨɨmwe mʉ wʉmwene ʉwa Taata waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pe bhakhɨmba ʉlwɨmbo. We bhaamala kwɨmba, bhakhasogola, bhakhabhala kwɨ gamba ɨlya Mizeituni. ");
INSERT INTO mgq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Uwusiku ʉwa mʉsanyʉʉnʉ, ɨmwe mwenti mʉtɨshɨmbɨle na kʉndekha. Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ɨnhayɨmʉkhoma umudiimi, ɨmpʉga ɨyɨ ngoole yɨkhayɨsataana.’ ");
INSERT INTO mgq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ɨleelo we nazyʉkha, ɨnhayɨbhatangʉlɨla kʉbhala kʉ Galɨlaaya.” ");
INSERT INTO mgq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","UPeeteli akhamʉbhʉʉzya uYeesu akhatɨ, “Poope ɨnga bhonti bhatɨkʉleshe, ɨne te ɨnkʉleshe ngakheeka!” ");
INSERT INTO mgq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","UYeesu akhamwamʉla akhatɨ, “Nalyoli ɨnkʉkʉbhʉʉzya kʉtɨ, uwusiku ʉwa mʉsanyʉʉnʉ, we ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ kʉtɨ utamanyile.” ");
INSERT INTO mgq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","UPeeteli akhamwamʉla akhatɨ, “Poope ɨnga yɨtɨbhe ya kufwa peeka nɨɨwe, te yɨmbɨɨshe kʉtɨ ɨnkʉkhaane ɨwe ngakheeka!” Abhalandati abhamwabho bhoope bhakhalonga shɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pe uYeesu akhabhala na bhalandati bhaakwe mu bositaani ye bhakhatɨnjɨ iGetisemaani, akhabhabhʉʉzya akhatɨ, “Yiikhali ɨpa, ɨmbale paala kupuuta.” ");
INSERT INTO mgq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akhabheega uPeeteli peeka na bhaana bhabhɨlɨ abha Zebedaayo, akhanda kʉswɨmɨɨlɨla na kʉzyʉgʉnhana mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pe akhabhabhʉʉzya akhatɨ, “Ʉmwoyo waanɨ wʉswɨmɨlɨɨye nhaani, ɨngafwa bhʉʉlo. Ɨmwe mwɨkhale panaapa, mʉbhe amiiso.” ");
INSERT INTO mgq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akhasejela pɨlongolela khashe, akhagwa shikupama, akhapuuta akhatɨ, “We Taata waanɨ, ɨnga yɨkwɨtɨnhana, ʉtakhɨtɨshɨzye kʉtɨ amayɨmba amapɨtɨ ɨga ganaaje! Ɨleelo yɨtakhabhe anza she ɨnkwanza, lyoli anza she ʉkwanza ɨwe.” ");
INSERT INTO mgq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pe uYeesu akhagalʉkha ku bhalandati bhaakwe, akhaaga bhagonile utulo. Akhamʉbhʉʉzya uPeeteli akhatɨ, “Bhʉlɨ, mwapootwa kʉbha amiiso peeka nɨɨne poope akhabhalɨlo akhɨ saala yeeka? ");
INSERT INTO mgq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Daamushi, mʉbhe amiiso na kupuuta kʉtɨ mutakhinjile mʉ ndɨngo. Ʉmwoyo wʉlɨ na makha aga kwɨtɨshɨla, ɨleelo ʉmʉbhɨlɨ mudeganu.” ");
INSERT INTO mgq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","UYeesu akhabhala akha wʉbhɨlɨ kupuuta, akhatɨ, “Taata waanɨ, ɨnga yɨkwɨtɨnhana, ʉtakhɨtɨshɨzye kʉtɨ amayɨmba amapɨtɨ ɨga ganaaje! Ɨleelo zye ʉkwanza zɨbhombeshe.” ");
INSERT INTO mgq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","We agalʉkha winza, akhaaga bhagonile, kʉnongwa ye utulo twámɨle twinji mu miiso gaabho. ");
INSERT INTO mgq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","UYeesu akhabhalekha winza, akhabhala kupuuta akha wʉtatʉ, akhalonga amazwi gagaala. ");
INSERT INTO mgq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pe akhagalʉkha winza ku bhalandati bhaakwe, akhabhabhʉʉzya akhatɨ, “Mʉlɨ she mugonile utulo na kʉtʉʉzya? Akhabhalɨlo khaafikha khe ʉMwana wa Muntu atɨlemwe na bhabhomba mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Daamushi, saalɨ tʉsogolaje! Yeenya, ʉla we atɨndonjeelele alɨ papɨɨpɨ!” ");
INSERT INTO mgq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","We uYeesu akʉlonga, ʉYʉʉda, weeka mu bhalandati bhaakwe ishumi na bhabhɨlɨ, akhɨnza peeka nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ bhe bháamɨle na mafwo amapɨtɨ ni nduugu. Ɨmpʉga yɨnɨɨyo yáfumile kʉ bhapɨtɨ abha bhapuutili na kʉ bhasongo abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ɄYʉʉda we akhanzaga kʉmʉlonjeelela uYeesu ábhalinganiziizye abhalʉgʉ ɨshɨlolesyo akhatɨ, “Ʉla we mwalola namʉtambɨla we mʉkhamʉlemaje.” ");
INSERT INTO mgq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nalʉbhɨlo, ʉYʉʉda akhamʉsejeelela uYeesu, akhatɨ, “Mwagona Mumanyizyi!” Akhamʉtambɨla. ");
INSERT INTO mgq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","UYeesu akhamwamʉla akhatɨ, “Manyani, bhomba lye ʉyɨnzɨɨye.” Pe abhantʉ bhaala bhakhamʉlema uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pe weeka mʉ bhe bháamɨle peeka nu Yeesu, akhasakʉla ʉmʉfwo ʉmʉpɨtɨ, akhamʉkhoma umubhombi ʉwa mupuutili ʉmʉpɨtɨ, akhamudiba ikutwe. ");
INSERT INTO mgq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ɨleelo uYeesu akhamʉbhʉʉzya akhatɨ, “Galʉsya ʉmʉfwo waakho ʉmʉpɨtɨ mʉ shɨpata, kʉnongwa ye bhonti bhe bhakʉgoga kʉ mʉfwo ʉmʉpɨtɨ bhakhayifwa kʉ mʉfwo ʉmʉpɨtɨ! ");
INSERT INTO mgq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bhʉlɨ, mutamanyile kʉtɨ ɨngakhola kʉmʉlaabha ʉTaata waanɨ, andeetele nalʉbhɨlo uwinji ʉwa vɨpʉga ɨvwa bhakhabhɨzya ishumi na vɨbhɨlɨ? ");
INSERT INTO mgq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ɨleelo, wʉngakwɨla bhʉlɨɨbhʉlɨ uWusimbe uWufinjile we wʉkʉtɨ, shɨnɨɨsho she yákhondeeye kʉbha?” ");
INSERT INTO mgq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Akhabhalɨlo khakhaala uYeesu akhayɨbhʉʉzya ɨmpʉga ɨya bhantʉ bhe bhínzile kʉmʉlema akhatɨ, “Bhʉlɨ, mwinzile kʉndema mʉlɨ na mafwo amapɨtɨ ni nduugu ngatɨ ne muntu umufwuli? Insiku zyonti nɨkhalaga mwi linga ilyi Nyumba iMfinjile, namanyɨzyaga, ɨleelo mʉtandemaga! ");
INSERT INTO mgq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ɨleelo zyonti ziniizi zyabhombekha ɨnga gakwɨle ge bhásimbile abhakuwi.” Pe abhalandati bhaakwe bhonti bhakhamʉlekha uYeesu bhakhashɨmbɨla. ");
INSERT INTO mgq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pe abhantʉ bhe bhámulemile uYeesu bhakhamʉtwala kwa Kayaafa, umupuutili ʉmʉpɨtɨ, kwe bhábhungaanile abhamanyizyi abhɨ ndajɨzyo na bhasongo abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","UPeeteli akhamʉlandataga uYeesu ukutali paka pa lʉbhaga ulwi nyumba ɨya mupuutili ʉmʉpɨtɨ. Akhinjila mukaasi, akhɨɨkhala peeka na bhalindiilili ɨnga alole zye zitifumile. ");
INSERT INTO mgq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abhapɨtɨ abha bhapuutili nɨ balaaza lyonti ɨlya bhasongo, bhakhanda kwanza uwukeeti ʉwɨ lenga kʉmʉsɨtaaka uYeesu kʉtɨ bhamʉlonje na kʉmʉgoga. ");
INSERT INTO mgq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɨleelo bhatakhawaaga uwukeeti wowonti, she poope bháfumiiye abhakeeti abhinji abhɨ lenga. Pɨlongolela, bhakhɨnza abhakeeti bhabhɨlɨ bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Umuntu wʉnʉʉnʉ átɨlɨ, ‘Ɨngakhola kʉpongolanya iNyumba iMfinjile ɨya Mʉlʉngʉ na kʉyɨzenga ku nsiku zɨtatʉ.’ ” ");
INSERT INTO mgq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pe umupuutili ʉmʉpɨtɨ akhɨmɨɨlɨla, akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Bhʉlɨ, ʉtakwamʉla naalimo? Ʉtakʉlola kʉtɨ abhantʉ bhonti ɨbha bhakufumwa uwukeeti kʉkʉsɨtaaka ɨwe?” ");
INSERT INTO mgq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɨleelo uYeesu atakhaamʉla naalimo. Pe umupuutili ʉmʉpɨtɨ akhamʉbhʉʉzya akhatɨ, “Ɨnkʉkʉlajɨzya kwɨ taawa lya Mʉlʉngʉ we mwumi, tʉbhʉʉzye, ɨnga ɨwe we we Kilisiti, ʉMwana wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","UYeesu akhamwamʉla akhatɨ, “Walonga weewe! Ɨleelo ɨnkʉbhabhʉʉzya kwandɨla ishi mʉtɨmʉlole ʉMwana wa Muntu ayɨkhaaye kʉmbalɨ ɨya kʉndɨɨlo ɨya Mʉlʉngʉ ʉwa makha. Khabhɨlɨ mʉkhayɨmʉlola we akwɨnza mʉ mabhɨngo.” ");
INSERT INTO mgq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pe umupuutili ʉmʉpɨtɨ akhadebulanya amenda gaakwe, akhatɨ, “Mwɨmvwa, amashoolanyo! Tʉkwanza bhaashi abhakeeti abhanjɨ? Mwɨmvwa mʉneemwe kʉshoolanya kwakwe! ");
INSERT INTO mgq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɨmwe mʉkʉtɨ bhʉlɨ?” Bhakhamwamʉla bhakhatɨ, “Akwanzɨwa kʉtɨ agogwe!” ");
INSERT INTO mgq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pe bhakhamʉswɨla amatɨ kumiiso, bhakhamʉkhoma ni nguumu. Bhamu bhakhamʉwaata amakoofi, ");
INSERT INTO mgq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bhakhatɨnjɨ, “We Kilisiti, tambʉla wu naanu we akʉkhoma?” ");
INSERT INTO mgq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mʉ khabhalɨlo khakhaala uPeeteli áyɨkhaaye pa lʉbhaga. Pe umubhombi weeka ʉmʉlɨndʉ akhasejeelela kwa Peeteli, akhamʉbhʉʉzya akhatɨ, “Nɨɨwe bhʉʉlo waamɨle peeka nu Yeesu ʉwa kʉ Galɨlaaya.” ");
INSERT INTO mgq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","UPeeteli akhakhaana pɨlongolela pa bhonti akhatɨ, “Intazimanyile zɨnɨɨzyo zye ʉkʉlonga!” ");
INSERT INTO mgq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pe akhasogola paala, akhafuma kunzi kʉ mʉlyango ʉwa lʉbhaga. Umubhombi ʉwamwabho ʉmʉlɨndʉ akhamʉlola, akhabhabhʉʉzya abhantʉ bhe bhálɨɨpo paala akhatɨ, “Umuntu ʉnʉ aamɨle peeka nu Yeesu ʉwa mu Naazaleti.” ");
INSERT INTO mgq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","UPeeteli akhakhaana winza na kʉlapa akhatɨ, “Intamumanyile umuntu wʉnʉʉyo!” ");
INSERT INTO mgq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","We akhabhalɨlo khaashɨla khashe, abhantʉ bhaala bhe bhɨ́mɨlɨɨye paala, bhakhamʉsejeelela uPeeteli, bhakhamʉbhʉʉzya bhakhatɨ, “Nalyoli ɨwe ʉlɨ peeka na bhantʉ bhanaabho, kʉnongwa ye poope kʉlonga kwakho kʉkʉmanyɨsya kʉtɨ ufumile kʉ Galɨlaaya!” ");
INSERT INTO mgq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","UPeeteli akhatipa na kʉlapa akhatɨ, “Intamumanyile umuntu wʉnʉʉyo!” Nalʉbhɨlo ɨnhanda yɨkhabhɨlɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pe uPeeteli akhakʉmbʉkha izwi liila lye uYeesu ámubhuziizye kʉtɨ, “We ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ.” Akhafuma kunzi, akhalɨla ku wuswimiilizu ʉwʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","We kwabha shɨlaabhɨla, abhapɨtɨ bhonti abha bhapuutili peeka na bhasongo abha Bhayahuudi bhakhapanzanya she bhangamʉgoga uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pe bhakhamupinya, bhakhamʉtwala kwa Pɨlaato we akhatabhaalaga. ");
INSERT INTO mgq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pe ʉYʉʉda, we ámʉlonjeleeye uYeesu, we aalola kʉtɨ uYeesu alongwa kʉtɨ bhamʉgoje, akhatɨ, “Nasheela.” Akhagalʉsya ɨnhela ɨnsabhaazya ziila amashumi gatatʉ, kʉ bhapɨtɨ bhaala abha bhapuutili na bhasongo abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akhabhabhʉʉzya akhatɨ, “Imbombile imbiibhi kʉmʉbhɨɨkha mʉ nyoobhe zyinyu umuntu we atatulile naazimo.” Ɨleelo abheene bhakhatɨ, “Zɨnɨɨzyo zɨtakʉtwavwa ɨtwe, ɨzyo zyakho wʉneewe.” ");
INSERT INTO mgq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pe ʉYʉʉda akhazɨsʉmba ɨnhela ɨnsabhaazya ziila mwi linga ilyi Nyumba iMfinjile, akhasogola, akhabhala kʉyɨkʉnjɨɨla. ");
INSERT INTO mgq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abhapɨtɨ abha bhapuutili bhakhasebha ɨnhela ɨnsabhaazya ziila, bhakhatɨ, “Yɨtakwɨtɨshɨlwa kʉsangaanya ɨnhela izi mʉ shɨlɨɨlo ishi mfinjile, kʉnongwa ye izi nhela zyɨ bhanda.” ");
INSERT INTO mgq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pe bhakhapanzanya, bhakheega ɨnhela ziila na kʉkalɨla ishiizi ɨsha mumati ʉwɨ nsonta, ɨnga bhabhasyɨlaje mʉmwo abhajeni. ");
INSERT INTO mgq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ye nongwa ishiizi shɨnɨɨsho ɨtaawa lyakwe bhakʉtɨ iShiizi ɨshɨ Bhanda nʉ mʉsanyʉʉnʉ. ");
INSERT INTO mgq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Shɨnɨɨsho she izwi lyákwɨlɨɨye lye umukuwi uYelemiya álonjile kʉtɨ, “Bhéejile ɨnhela ɨnsabhaazya amashumi gatatʉ, zɨnɨɨzyo zye aBhaisilaeli bhítinhiine. ");
INSERT INTO mgq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bhakhakalɨla ishiizi ɨsha mumati ʉwɨ nsonta anza she ʉMwene ándajiziizye.” ");
INSERT INTO mgq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pe uYeesu akhɨmɨɨlɨla pɨlongolela pa mulongozi ʉwa Bhaluumi, umulongozi ʉla akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ɨwe we Mwene wa Bhayahuudi?” UYeesu akhamwamʉla akhatɨ, “Weewe walonga kʉtɨ ɨne ne mwene.” ");
INSERT INTO mgq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ɨleelo abhapɨtɨ bhaala abha bhapuutili na bhasongo abha Bhayahuudi we bhakʉmʉsɨtaaka, ʉweene atakhabhaamʉla naalimo. ");
INSERT INTO mgq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pe ʉPɨlaato akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ʉtakʉzyɨmvwa zɨnɨɨzyo zyonti zye bhakʉkʉsɨtaaka?” ");
INSERT INTO mgq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ɨleelo uYeesu atakhaamʉla poope izwi lyeka. Pe ʉPɨlaato akhaswiga nhaani. ");
INSERT INTO mgq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yáamɨle mwata pa shikulukulu ɨshɨ Pasaaka, umulongozi wʉnʉʉyo kʉmʉsatʉlɨla ʉmʉkʉngwa weeka we abhantʉ bhamuganile. ");
INSERT INTO mgq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pe mʉ khabhalɨlo khaala, kwámɨle nʉ mʉkʉngwa weeka we ámanyishile nhaani, ɨtaawa lyakwe bhakhatɨnjɨ ʉBalaaba. ");
INSERT INTO mgq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pe we abhantʉ bhabhungaanile, ʉPɨlaato akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkwanza ɨmbasatʉlɨle unaanu mʉ bhakʉngwa bhabhɨlɨ ɨbha, ʉBalaaba awe uYeesu we abhantʉ bhakʉtɨ uKilisiti?” ");
INSERT INTO mgq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ɄPɨlaato ábhabhuziliziizye shɨnɨɨsho kʉnongwa ye ámanyile kʉtɨ abhalongozi abha Bhayahuudi bhámuleetile uYeesu kʉkwakwe kʉnongwa ɨya mwone. ");
INSERT INTO mgq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","We ʉPɨlaato ayɨkhaaye pɨ tengo lyakwe ɨlya kʉlonjela ɨnongwa, ʉmʉshɨ waakwe akhamʉtwalɨla intumi akhatɨ, “Ʉtakhasheele kʉbhomba ibhiibhi lyolyonti kwa muntu wʉnʉʉyo we te mʉtʉla nongwa, kʉnongwa ye ʉmʉsanyʉʉnʉ uwusiku injimbile nhaani mu njozi kʉnongwa yaakwe.” ");
INSERT INTO mgq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ɨleelo abhapɨtɨ abha bhapuutili na bhasongo abhanjɨ abha Bhayahuudi bhakhabhasonjeelezya abhantʉ kʉtɨ bhamʉlaabhe ʉPɨlaato abhasatʉlɨle ʉBalaaba, ɨleelo uYeesu agogwe. ");
INSERT INTO mgq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ɄPɨlaato akhabhabhʉzɨɨlɨzya winza akhatɨ, “Mʉkwanza ɨmbasatʉlɨle unaanu mʉ bhakʉngwa bhabhɨlɨ ɨbha?” Bhakhamwamʉla bhakhatɨ, “Tʉkwanza ʉtʉsatʉlɨle ʉBalaaba.” ");
INSERT INTO mgq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ɄPɨlaato akhabhabhʉzɨɨlɨzya winza akhatɨ, “Pe ɨmbombe lyoni nu Yeesu we bhakʉtɨ wu Kilisiti?” Abhantʉ bhonti bhakhazingula ɨshongo bhakhatɨ, “Mʉkhomeele pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ɄPɨlaato akhabhabhʉzɨɨlɨzya akhatɨ, “Atulile zyoni?” Ɨleelo abheene pe bhakhazanzala nhaani kʉshongola bhakhatɨ, “Ɨtwe tʉkʉtɨ mʉkhomeele bhʉʉlo pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","We ʉPɨlaato aamanya kʉtɨ atangakhola kʉgalʉlanya ɨnsɨɨbho ɨya bhantʉ bhaala na kʉtɨ bhatalɨkha ʉmʉyʉbhano, akheega aminzi, akhasamvwa ɨnyoobhe pɨlongolela pa mpʉga. Pe akhabhabhʉʉzya akhatɨ, “Ɨntalɨ nɨ nongwa naayimo kwɨ bhanda lya muntu umugolosu ʉnʉ. Ziniizi zɨlɨ mʉ nyoobhe zyinyu mʉneemwe!” ");
INSERT INTO mgq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abhantʉ bhonti bhakhamwamʉla bhakhatɨ, “Ɨnongwa ɨya kwita ɨbhanda lyakwe yɨbhe yɨɨtʉ na bhaana bhɨɨtʉ!” ");
INSERT INTO mgq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pe ʉPɨlaato akhabhasatʉlɨla ʉBalaaba, ɨleelo akhabhalajɨzya abhasikaali bhaakwe kʉtɨ bhamʉkhome uYeesu nɨ sambogo na kʉmʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pe abhasikaali bhaala abha mulongozi uMuluumi bhakhamwega uYeesu na kʉbhala nawo mwi linga lya mwene. Abhasikaali ɨshɨpʉga shonti bhakhamʉbhʉngaanɨla uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakhamʉzʉʉla amenda gaakwe, bhakhamʉkwatɨzya ɨgolole ishamamu. ");
INSERT INTO mgq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bhakhatabha ishipambwi ɨsha mimvwa, bhakhamʉkwatɨzya kwi twe na kʉyɨbhɨɨkha ɨndɨɨsa kʉ nyoobhe yaakwe ɨya kʉndɨɨlo. Bhakhasʉgamɨla pɨlongolela yaakwe na kʉmʉsʉʉpɨzya bhakhatɨnjɨ, “Waagona, we Mwene wa Bhayahuudi!” ");
INSERT INTO mgq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe bhakhamʉswɨla amatɨ, bhakheega ɨndɨɨsa yiila kʉ nyoobhe yaakwe, bhakhamʉkhomanganya nayo pi twe. ");
INSERT INTO mgq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","We bhaamala kʉmʉsʉʉpɨzya, bhakhamʉzʉʉla ɨgolole liila, bhakhamʉkwatɨzya amenda gaakwe. Bhakhamufumwa kunzi, bhakhasogola nawo kʉbhala kʉmʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","We abhasikaali bhakufuma mʉ nhaaya ɨya mu Yelusaleemu, bhakhamwaga mwɨ dala umuntu ʉmo we ɨtaawa lyakwe bhakhatɨnjɨ uSiimoni. Umuntu wʉnʉʉyo áfumile mʉ nhaaya ɨya mu Kileene. Bhakhamubijila kʉpɨmba ɨshɨkhobhenhanyo sha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe bhakhafikha nu Yeesu pe bhakhatɨnjɨ pa Goligoota, kwe kʉtɨ, “Pi Fupa ilyi Twe.” ");
INSERT INTO mgq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pe bhakhaamupa uYeesu idivaayi ye bhásanganyiinye ni vintu vwe vɨkʉbhabhaata, kʉtɨ amwele. Ɨleelo we alɨnga, akhasiita kʉmwela. ");
INSERT INTO mgq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","We bhamʉkhomeela pa shɨkhobhenhanyo, bhakhagabhana amenda gaakwe kwɨ dala ɨlya kʉkhoma ɨkʉʉla. Pe gakhakwɨla amazwi ge gálonjiilwe nu mukuwi kʉtɨ, “Bhakhagabhana amenda gaanɨ nɨ golole lyanɨ bhakhalɨkhomela ɨkʉʉla.” ");
INSERT INTO mgq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe bhakhɨɨkhala papaala ɨnga bhamʉlɨndɨlɨlaje. ");
INSERT INTO mgq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pamwanya pi twe lyakwe, pa shɨkhobhenhanyo bhakhasimba amazwi aga kʉmʉsɨtaaka ge gakʉtɨ, “Ʉnʉ wu Yeesu, ʉMwene ʉwa Bhayahuudi.” ");
INSERT INTO mgq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mʉ khabhalɨlo khanaakho abhabuda bhabhɨlɨ, bhakhabhakhomeela peeka nu Yeesu, weeka kʉmbalɨ ɨya kʉndɨɨlo nʉ wamwabho kʉmbalɨ ɨya kʉmongo. ");
INSERT INTO mgq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abhantʉ bhe bhakhashɨlaga paala, bhakhamuligaga na kuyinzanya amatwe gaabho. ");
INSERT INTO mgq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Bhakhamʉbhʉzyaga bhakhatɨnjɨ, “Ɨwe wayɨbaadaga kʉtɨ ʉtɨpongolanye iNyumba iMfinjile na kʉyɨzenga winza ku nsiku zɨtatʉ. Ɨnga we Mwana wa Mʉlʉngʉ, yɨposhe wʉneewe, yiikha pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Shɨnɨɨsho, abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo peeka na bhasongo abha Bhayahuudi bhakhamʉsʉpɨzyaga uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Bhakhatɨnjɨ, “Abhapokhaga abhanjɨ, ɨleelo apootwa kʉyɨpokha wʉʉyo! Ɨnga nalyoli wʉ Mwene ʉwa Bhaisilaeli, ayiishe pa shɨkhobhenhanyo, pe nɨɨtwe tʉtɨmwɨtɨshe. ");
INSERT INTO mgq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ʉweene akʉmʉsʉʉbhɨla ʉMʉlʉngʉ, ishi ʉMʉlʉngʉ amʉposhe ɨnga amuganile. Kʉnongwa ye alongaga kʉtɨ, ‘Ɨne ne Mwana wa Mʉlʉngʉ.’ ” ");
INSERT INTO mgq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bhoope abhafwuli bhe bhákhomeliilwe peeka nu Yeesu, bhakhamuliga anza shishiila. ");
INSERT INTO mgq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pe kwandɨla ɨsaala ɨya mʉtanda kufikha mʉ saa tisa, akhiisi khakhagwa mʉ nsɨ yonti. ");
INSERT INTO mgq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","We yaafikha saa tisa, uYeesu akhalɨla kwi zi ɨlya kʉdandɨzya akhatɨ, “Elooyi! Elooyi! Lama sabakitaani?” Kwe kʉtɨ, “We Mʉlʉngʉ waanɨ! We Mʉlʉngʉ waanɨ! Khooni khe wandekha?” ");
INSERT INTO mgq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abhantʉ bhamu bhe bhɨ́mɨlɨɨye paala we bhɨmvwa ganaago, bhakhatɨ, “Wʉnʉʉnʉ akʉmʉbhɨlɨshɨla wu Eliya umukuwi.” ");
INSERT INTO mgq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Umuntu ʉmo akhashɨmbɨla nalʉbhɨlo akhabhala akhadumvikha akhagodoolo mu divaayi ye yilulile, akhapinyiila mwi lanzi itali, akhalɨbhʉʉsya kʉmwanya, akhaamupa uYeesu kʉtɨ amwele. ");
INSERT INTO mgq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɨleelo abhanjɨ bhakhatɨ, “Lakha tʉlole she umukuwi uEliya atɨyɨnze kʉmʉpokha!” ");
INSERT INTO mgq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pe uYeesu akhakhoola winza kwi zi ɨlya kʉdandɨzya, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Akhabhalɨlo khanaakho, ɨgolole lye lyápitulanyiinye aPafinjile na Pafinjile Nhaani mu Nyumba iMfinjile, likhadeebukha pakaasi kufuma pamwanya kwikha paasɨ. Ɨnsɨ yikhayingaana, amalaawe gakhabazʉkha. ");
INSERT INTO mgq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ɨmbɨɨpa zɨkhabwobhokha na mabhɨlɨ aminji aga bhafinjile bhe bháfuuye bhakhazyʉkha. ");
INSERT INTO mgq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bhakhafuma mʉ mbɨɨpa, we uYeesu azyʉkha, bhakhinjila mʉ nhaaya imfinjile ɨya mu Yelusaleemu, bhakhabhaloleshela abhantʉ abhinji. ");
INSERT INTO mgq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","We ʉmʉpɨtɨ ʉwa bhasikaali peeka na bhaala bhe bhakhamʉlɨndɨlɨlaga uYeesu bhaalola ishiyingayinga na ganjɨ gonti ge gáfumiiye, bhakhoogopa nhaani, bhakhatɨ, “Nalyoli ʉnʉ aamɨle Mwana wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Papaala bhálɨɨpo abhantanda bhe bhɨ́mɨlɨɨye ukutali, bhakhenyaaga zyonti zye zɨkhabhombekhaga. Bhanaabho bhe bhakhamʉlandataga uYeesu kufuma mʉ nsɨ ɨya mʉ Galɨlaaya, na kʉmwavwa. ");
INSERT INTO mgq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mʉ bhantanda bhanaabho, álɨɨpo uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala, uMaliya unyina wa Yaakobo nu Yoosefu, peeka nu nyina wa bhaana bha Zebedaayo. ");
INSERT INTO mgq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","We kwabha shalyabheela, akhɨnza umuntu ʉmo we áamɨle wu dumbwe, áfumile mʉ nhaaya ɨya ku Alimasaaya, ɨtaawa lyakwe wu Yoosefu. Woope áamɨle mulandati wa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","UYoosefu akhabhala kwa Pɨlaato, akhalaabha ivimba lya Yeesu. ɄPɨlaato akhabhalajɨzya abhasikaali bhaakwe kʉtɨ bhaamupe. ");
INSERT INTO mgq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","UYoosefu akheega ivimba lya Yeesu, akhalɨgwɨnhanya ʉmwenda we wuzelupile. ");
INSERT INTO mgq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Akhalɨbhɨɨkha ivimba mʉ mbɨɨpa yaakwe impwa ye yábaniilwe mwɨ lyalaawe. Pe akhadinda iwe ɨpɨtɨ pa mʉlyango ʉwɨ mbɨɨpa yiila, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mʉ khabhalɨlo khanaakho, uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala nu Maliya unyina wa Yaakobo nu Yoosefu bhɨ́khaaye paala, bhényiizye kʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɨndaabhɨ yaakwe lyámɨle lisiku lyɨ Sabaato, abhapɨtɨ abha bhapuutili na Bhafalisaayi bhakhabhala kwa Pɨlaato. ");
INSERT INTO mgq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bhakhamʉbhʉʉzya bhakhatɨ, “Mwene, twakʉmbʉkha kʉtɨ ʉwɨ lenga ʉla we mwumi, álonjile átɨlɨ, ‘We zyashɨla insiku zɨtatʉ, ɨnhayɨzyʉkha.’ ");
INSERT INTO mgq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tʉkʉlaabha ʉbhalajɨzye abhasikaali bhalɨndɨɨlɨle akhinza ɨmbɨɨpa insiku zɨtatʉ, ɨnga abhalandati bhaakwe bhatakhiibhe ivimba lyakwe na kʉbhakhopela abhantʉ kʉtɨ azyushile kufuma kʉ bhafwe. Ɨlenga lɨnɨɨlyo lɨtɨbhe libhiibhi nhaani kʉshɨla ɨlya kwanda.” ");
INSERT INTO mgq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ɄPɨlaato akhabhaamʉla akhatɨ, “Yeeji abhasikaali. Bhabhale bhalɨndɨɨlɨle ɨmbɨɨpa kʉ makha gaabho gonti.” ");
INSERT INTO mgq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pe bhakhabhala kʉ mbɨɨpa, bhakhatitizya umunhuuli pi we liila, bhakhabhalekha abhasikaali paala kʉtɨ bhalɨndɨɨlɨle ɨmbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Isiku ɨlyɨ Sabaato we lyashɨla, ɨshɨlaabhɨla we kʉshɨɨlɨ kuzelupa, isiku ɨlya Pamʉlʉngʉ, uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala peeka nu Maliya ʉwamwabho, bhakhabhala kwenya ɨmbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nalʉbhɨlo ishiyingayinga ɨshɨpɨtɨ shikhafumila. Ʉkhabhɨzya wa Mwene akhiikha kufuma kʉmwanya, akhasejeelela pa mbɨɨpa, akhalibhungulusya iwe lye lyámɨle pa shɨlyango pa mbɨɨpa, akhalyɨkhalɨla. ");
INSERT INTO mgq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ʉkhabhɨzya ʉla akhalamaga ngatɨ lʉkhozyo ʉlwɨ mwangʉkho yi mvula na menda gaakwe gáamɨle mazelu ngatɨ nganda. ");
INSERT INTO mgq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Abhasikaali bhaala bhe bhakhalɨndɨlɨlaga ɨmbɨɨpa, we bhazɨlola zɨnɨɨzyo, ɨlyoga lɨkhabhalema nhaani, bhakhanda kuyinga, bhakhabha ngatɨ bhafuuye. ");
INSERT INTO mgq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ɨleelo ʉkhabhɨzya ʉla akhabhabhʉʉzya abhantanda bhaala akhatɨ, “Ɨmwe mʉtogopaje! Imanyile kʉtɨ mʉkʉmwanza wu Yeesu we aakhomeliilwe pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Atalɨɨpo ɨpa, azyushile anza she álonjile. Nzaaji mwenye pe bhaamulambalishile. ");
INSERT INTO mgq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ɨmwe bhalaji nalʉbhɨlo mʉbhabhʉʉzye abhalandati bhaakwe kʉtɨ, ‘Azyushile kufuma kʉ bhafwe, abhalongoleeye kʉbhala kʉ Galɨlaaya. Kukuula kwe mʉtɨmʉlole.’ Ishi ɨne nabhabhʉʉzya!” ");
INSERT INTO mgq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pe abhantanda bhaala bhakhasogola nalʉbhɨlo pa mbɨɨpa paala kʉ lyoga nʉ lʉseshelo ʉlʉpɨtɨ nhaani. Bhakhashɨmbɨla kʉbhala kʉbhabhʉʉzya abhalandati bha Yeesu zye ʉkhabhɨzya ʉla akhabhabhʉʉzya. ");
INSERT INTO mgq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","We bhakʉbhala kʉbhabhʉʉzya abhalandati bhaakwe, uYeesu akhakhomaana nabho, akhabhalamʉkha. Bhakhamʉsejeelela, bhakhasʉgamɨla, bhakhalema ɨvɨnama vwakwe kumupuuta. ");
INSERT INTO mgq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Mʉtogopaje, bhalaji mʉbhabhʉʉzye abhanholo bhaanɨ bhabhale kʉ Galɨlaaya kwe bhatɨndole.” ");
INSERT INTO mgq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","We abhantanda bhaala bhalɨ mwɨ dala bhakʉjenda, abhasikaali bhamu bhe bhakhalɨndɨlɨlaga ɨmbɨɨpa ya Yeesu bhakhabhala mʉ nhaaya ɨya mu Yelusaleemu kʉbhabhʉʉzya abhapɨtɨ bha bhapuutili zyonti zye zibhombeshile. ");
INSERT INTO mgq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pe abhapɨtɨ bha bhapuutili bhaala bhakhabhʉngaana peeka na bhasongo abha Bhayahuudi, bhakhapanzanya kʉtɨ bhabhabheke ɨnhela inyinji abhasikaali bhaala. ");
INSERT INTO mgq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bhakhabhabhʉʉzya bhakhatɨ, “Ɨnga umuntu wowonti akʉbhabhʉzɨɨlɨzya, mʉkhatɨnjɨ, ‘Abhalandati bha Yeesu bhinzile shawusiku bhiibhile ivimba, we ɨtwe tʉsʉpɨlɨɨye.’ ");
INSERT INTO mgq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɨnga ʉPɨlaato ayɨmvwa ziniizi, tʉtɨlonje nawo tʉneetwe, ɨnga ɨmwe mʉtakhabhe mʉ mayɨmba.” ");
INSERT INTO mgq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pe abhasikaali bhakhaposheela ɨnhela ziila, bhakhabhomba anza she bhábhalinganiziizye. Ɨnongwa zɨnɨɨzyo zisaatile ku Bhayahuudi, nʉ mʉsanyʉʉnʉ. ");
INSERT INTO mgq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abhalandati bha Yeesu ishumi na weeka bhakhabhala kʉ Galɨlaaya, bhakhafikha mwɨ gamba lye uYeesu ábhalajiziizye. ");
INSERT INTO mgq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","We bhamʉlola uYeesu, bhakhasʉgamɨla kumupuuta, ɨleelo bhamu bhakhasingaana kwɨtɨkha kʉtɨ wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","UYeesu akhabhasejeelela papɨɨpɨ, akhabhabhʉʉzya akhatɨ, “ɄMʉlʉngʉ ampiiye ʉwaamʉlo wonti kʉmwanya na paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ishi bhalaji mʉbhalʉmbɨɨlɨle abhantʉ abhɨ nsɨ zyonti bhabhe bhalandati bhaanɨ, mʉbhozyaje kwɨ taawa lya Taata, ɨlya Mwana nɨ lya Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mʉkhabhamanyɨzyaje kʉzɨlandata zyonti zye imbalajiziizye. Ɨne ɨndɨ peeka nɨɨmwe insiku zyonti, paka kʉwʉmalɨlɨshɨlo ʉwɨ nsɨ.”");
INSERT INTO mgq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uwu we wandɨlo wi Ntumi iNyinza ɨzya Yeesu Kilisiti ʉMwana wa Mʉlʉngʉ, ");
INSERT INTO mgq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","anza she yisimbiilwe nu mukuwi ʉYeesaya, kʉtɨ ʉMʉlʉngʉ átɨlɨ, “Yeenya, ɨnhayɨmʉsonteelezya we akʉtwala intumi mwɨlongolela lyakho, akhayɨlɨngaanya ɨdala lyakho ɨlya kwɨnzɨla. ");
INSERT INTO mgq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Umuntu akʉkhoola mu shilozu akʉtɨ, ‘Linganyaaji ɨdala lya Mwene, golosyaji ɨdala lye atɨshɨle.’” ");
INSERT INTO mgq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ʉmʉtwala ntumi wʉnʉʉyo áamɨle wu Yookhani uMwozyi. UYookhani áfumiiye mu shilozu, akhalʉmbɨlɨlaga akhatɨnjɨ abhantʉ bhapɨndʉkhaje, bhazɨlekhaje imbiibhi zyabho na kwozelwa kʉtɨ, ʉMʉlʉngʉ abhatʉʉyɨle imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abhantʉ abhinji kufuma mʉ nhaaya ɨya mu Yelusaleemu na mʉ nsɨ yonti ɨya mu Yudeeya bhakhabhalaga kʉmʉtejeelezya. Bhakhalaataga imbiibhi zyabho, woope akhabhozyaga mu lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","UYookhani akhakwataga ʉmwenda we bhátabhɨɨye amasepe agɨ ngamɨla, akhayipinyaga nɨ lambɨ ɨlyɨ gwembe mʉ mʉsana waakwe. Ishaakulya shaakwe sháamɨle mpʉlaala nu wooshi ʉwa mwɨ sengo. ");
INSERT INTO mgq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","UYookhani akhalʉmbɨlɨlaga akhatɨnjɨ, “Atɨlandate papaanɨ umuntu we alɨ na makha kʉnshɨla ɨne, we ɨne ɨntakhondeeye poope kʉbha ne mubhombi wa kusulama na kʉsatʉla amakhobha gɨ ndaala zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨne ɨnkʉbhoozya ɨmwe ku minzi, ɨleelo ʉweene akhayɨbhoozya kwa Mupepu uMufinjile.” ");
INSERT INTO mgq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pe mu nsiku ziziila, uYeesu áyinzile kufuma ku Naazaleti, mʉ nsɨ ɨya mʉ Galɨlaaya, akhoozelwa nu Yookhani uMwozyi mu lwizi ʉlwa Yoolodani. ");
INSERT INTO mgq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","We uYeesu aafuma bhʉʉlo mu minzi, akhalola kʉmwanya kwigulwa, nu Mupepu uMufinjile akwikha ngatɨ nkʉnda, akhagwa pamwanya papaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pe izi lya Mʉlʉngʉ kufuma kʉmwanya lɨkhavwɨnha lɨkʉtɨ, “Ɨwe we Mwana waanɨ ʉmʉganwa, we ɨnkʉkʉseshela.” ");
INSERT INTO mgq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Panaapo bhʉʉlo uMupepu uMufinjile akhamwega, akhamʉtwala mu shilozu. ");
INSERT INTO mgq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","UYeesu ádɨlɨɨye mu shilozu insiku amashumi gani, akhalɨngwa nu Seetani. Áamɨle peeka nɨ vɨkhanʉ ɨvwa mwɨ laala na bhakhabhɨzya bhakhamʉsʉngaga. ");
INSERT INTO mgq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bhakhamʉkʉnga uYookhani mwɨ jeela. We alɨ mwɨ jeela, uYeesu akhalʉmbɨlɨlaga iNtumi iNyinza ɨzya Mʉlʉngʉ mʉ nsɨ ɨya mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akhalʉmbɨlɨlaga akhatɨnjɨ, “Akhabhalɨlo khafishile, khabhɨlɨ ʉwʉmwene ʉwa kʉmwanya wʉpalamɨɨye. Ishi laataji imbiibhi zyinyu na kʉzɨlekha, na kʉzyɨtɨkha iNtumi iNyinza ɨzya Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Isiku limo we uYeesu akʉshɨla mʉmbalɨ mwa sʉmbɨ ʉwa Galɨlaaya, akhabhalola abhaana muntu abhazʉbhʉla nswi, uSiimoni nʉ Andeleeya, bhakʉzʉbhʉla inswi nu waavu mwa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","UYeesu akhabhabhʉʉzya akhatɨ, “Ndandataje, te mʉjendeelele kʉzʉbhʉla inswi, lyoli ɨntɨbhabhɨɨshe kʉtɨ mʉzʉbhʉlaje abhantʉ na kʉbhaleeta kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Panaapo bhʉʉlo, bhakhazɨlekha inyaavu zyabho, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","We aabhala pɨlongolela khashe, akhabhalola abhavʉlɨ bha Zebedaayo, ʉYaakobo nʉ wamwabho uYookhani, bhalɨ mʉ shɨtʉʉlɨ, bhakhazɨlɨnganyaaga inyaavu zyabho. ");
INSERT INTO mgq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Akhabhabhɨlɨshɨla, bhakhamʉlekha uyise waabho ʉZebedaayo na bhabhomba mbombo mʉ shɨtʉʉlɨ muula, bhakhanda kʉmʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pe bhakhabhala mʉ nhaaya ɨya mu Kapelenaumu. We ɨSabaato yaafikha, uYeesu akhinjila mwi sinagoogi, akhanda kʉmanyɨzya. ");
INSERT INTO mgq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abhantʉ bhonti bhe bhámutejeleziizye, bhakhaswiga nhaani nɨ manyɨzyo zyakwe, kʉnongwa ye akhamanyɨzyaga ngatɨ muntu ʉwa waamʉlo, te ngatɨ bhamanyizyi bhaabho abhɨ ndajɨzyo zya Moose. ");
INSERT INTO mgq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mwi sinagoogi liila, álɨɨpo umuntu uwi pepu ibhiibhi. Akhakhoola kwi zi ɨlya kʉdandɨzya, ");
INSERT INTO mgq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akhatɨ, “Tʉlɨ na khooni nɨɨwe Yeesu Munaazaleti? Kwe kʉtɨ uyinzile kʉtʉnanganya? Inkumanyile kʉtɨ ɨwe we naanu, ɨwe we Mufinjile wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","UYeesu akhalɨkhajɨla ipepu liila akhatɨ, “Pʉʉma! Fuma mwa muntu ʉnʉ!” ");
INSERT INTO mgq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe ipepu liila likhamuyinzanya na kʉmʉzyangaanya, lɨkhakhoola kwi zi ɨlya kʉdandɨzya, likhafuma mwa muntu ʉla. ");
INSERT INTO mgq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abhantʉ bhonti bhakhaswiga nhaani, bhakhabhʉzɨlɨzanya bhakhatɨ, “Khooni khanaakha, kwe kʉtɨ izi manyɨzyo impwa ɨzya makha! Yeenya, khabhɨlɨ alɨ nʉ waamʉlo ʉwa kʉgakhajɨla amapepu amabhiibhi, goope gakʉmwɨmvwa.” ");
INSERT INTO mgq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Intumi zya Yeesu zɨkhasaata mʉ nsɨ yonti ɨya mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","UYeesu na bhalandati bhaakwe bhakhafuma mwi sinagoogi. USiimoni nʉ Andeleeya bhakhabhalaabha uYeesu, uYookhani nʉ Yaakobo kʉtɨ bhabhale kʉ nhaaya yaabho. ");
INSERT INTO mgq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","We aafikha bhʉʉlo, bhakhamʉbhʉʉzya kʉtɨ, ʉnyavwala wa Siimoni mubhinu, abhinile ɨnzegema, agonile pa shɨtala. ");
INSERT INTO mgq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","UYeesu akhabhala pe agonile, akhamʉlema ɨnyoobhe, akhamʉbhʉʉsya. Ʉnyavwala wa Siimoni akhapona ɨnzegema, akhalɨngaanya ishaakulya kʉnongwa yaabho. ");
INSERT INTO mgq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Isiku liliila we ɨzʉbha lyaswa, ɨSabaato yaasila, bhakhamʉleetela uYeesu abhabhinu bhonti, na bhe bháamɨle na mapepu amabhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Abhantʉ abhɨ nhaaya yiila yonti, bhakhabhʉngaana pa mʉlyango. ");
INSERT INTO mgq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","UYeesu akhabhaponɨa abhantʉ abhinji bhe bhábhinile nɨ mpʉngo ɨzya vɨkholo ivwinji. Akhageefwa amapepu amabhiibhi ku bhinji, ɨleelo atakhagalekhaga amapepu galonje, kwe kʉtɨ gámanyile kʉtɨ uYeesu wu naanu. ");
INSERT INTO mgq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ɨndaabhɨ yaakwe ɨshɨlaabhɨla, nakhantandabhɨla, uYeesu akhafuma akhabhala pamu pe patalɨ na bhantʉ, akhanda kupuuta. ");
INSERT INTO mgq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","USiimoni na bhamwabho bhakhanda kʉmwanza. ");
INSERT INTO mgq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pe we bhamwaga, bhakhamʉbhʉʉzya bhakhatɨ, “Abhantʉ bhonti ʉkwo bhakʉkwanza!” ");
INSERT INTO mgq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","UYeesu akhatɨ, “Ndaali, lyoli ishi saalɨ tʉbhale kʉ nhaaya izinji ɨzya papɨɨpɨ nɨɨnɨ, ɨnga kwope ɨmbale ɨndʉmbɨɨlɨle, ɨmbombo yɨnɨɨnɨ ye ɨnɨnzɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pe akhabhala mʉ nhaaya nɨɨzyo nɨɨzyo ɨzya mʉ Galɨlaaya, akhalʉmbɨlɨlaga mu masinagoogi gaabho, na kʉbheefwa abhantʉ amapepu amabhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pe umuntu ʉmo ʉwa maketa akhamwɨnzɨla, akhasʉgamɨla pa vɨnama vwakwe, akhamʉlambɨɨlɨzya akhatɨ, “Ɨnga uyiganile, ʉnsatʉle.” ");
INSERT INTO mgq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","UYeesu akhamʉlolela ishisa, akhagolosya ɨnyoobhe yaakwe, akhamʉpalamansya, akhalonga akhatɨ, “Injiganile kʉtɨ ʉpone, ʉsatʉshe!” ");
INSERT INTO mgq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pe nalʉbhɨlo bhʉʉlo amaketa gakhamwepa, akhapona na kʉsatʉkha. ");
INSERT INTO mgq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","UYeesu akhamʉsokha, akhamʉkʉbhɨɨlɨzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ʉtakhasheele kʉmʉbhʉʉzya umuntu wowonti ʉla ziniizi. Lyoli bhalaga ʉyɨlolesye kwa mupuutili, ʉbhale ufumwe imfinjile ɨzya kʉsatʉlwa kwakho zye ʉMoose álajiziizye, ɨnga abhantʉ bhonti bhazɨlole ɨmbombo zya Mʉlʉngʉ zye abhomba kʉkwakho.” ");
INSERT INTO mgq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɨleelo umuntu ʉla akhanda kʉbhapanjɨla abhantʉ ɨnongwa zɨnɨɨzyo poponti. We akhonzya shɨnɨɨsho, pe uYeesu akhanda kʉpootwa kwinjila mʉ nhaaya yoyonti yiila apazelu. Akhalola kʉtɨ khinza abhanje mwene bhʉʉlo kunzi, poope leelo abhantʉ bhakhamwɨnzɨlaga kufuma uku nʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","UYeesu akhagalʉkha winza ku Kapelenaumu. We insiku inyinsi bhʉʉlo zyashɨla, abhantʉ bhakhɨmvwa kʉtɨ alɨ mu nyumba. ");
INSERT INTO mgq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pe abhantʉ abhinji nhaani bhakhakhomaana, patakhabha na pa kʉshɨla naapamu pa mʉlyango. UYeesu akhabhalʉmbɨlɨlaga abhantʉ amazwi gaakwe aga wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pe bhakhɨnza abhantʉ bhani bhe bhámupimbile mʉ shɨlɨlɨ umuntu we áfuuye kʉndwɨmo. ");
INSERT INTO mgq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ku winji wɨ mpʉga ɨmpɨtɨ ɨya bhantʉ, bhakhapootwa kumwinjizya pe uYeesu áamɨle. Pe bhakhazʉbha kʉ shɨsonyonje ishi nyumba, bhakhadobhola ɨshɨsonyonje. Bhakhamwisya umubhinu ʉla mʉ shɨlɨlɨ, pakaasi pe uYeesu áamɨle. ");
INSERT INTO mgq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","We uYeesu alʉlola ʉlwɨtɨkho lwabho, akhamʉbhʉʉzya umubhinu ʉla akhatɨ, “We mwana waanɨ, utuyiliilwe imbiibhi zyakho.” ");
INSERT INTO mgq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ɨleelo abhamanyizyi bhamu abhɨ ndajɨzyo bhe bhɨ́khaaye pʉʉpo kʉtejeelezya, bhakhayɨsɨɨbhaga mʉ mooyo gaabho bhakhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Umuntu ʉnʉ akʉlonga bhʉlɨɨbhʉlɨ shiniishi? Akʉmʉshoolanya ʉMʉlʉngʉ, kʉnongwa ye atalɨɨpo umuntu we angabhatʉʉyɨla abhantʉ imbiibhi, lyoli wʉ Mʉlʉngʉ mwene.” ");
INSERT INTO mgq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pe uYeesu akhamanya bhʉʉlo mʉ mwoyo waakwe zye bhakʉsɨɨbha, akhabhabhʉzɨɨlɨzya akhatɨ, “Khooni khe mʉkʉsɨɨbha shɨnɨɨsho mʉ mooyo giinyu? ");
INSERT INTO mgq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ishi lyoni lye lipupuusu nhaani, kʉmʉbhʉʉzya umuntu ʉnʉ we alemaaye kʉtɨ, ‘Imbiibhi zyakho zituyiliilwe,’ awe kʉtɨ, ‘Yɨmɨɨlɨla, yeega ɨshɨlɨlɨ shaakho, jendaga’? ");
INSERT INTO mgq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ishi leelo ɨnkwanza ɨmbalanje kʉtɨ, ʉMwana wa Muntu alɨ nʉ waamʉlo ʉwa kʉbhatʉʉyɨla imbiibhi abhantʉ mʉ nsɨ.” Pe uYeesu akhamʉbhʉʉzya umuntu ʉla we alemaaye akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ɨnkʉkʉbhʉʉzya ɨnkʉtɨ yɨmɨɨlɨla, yeega ɨshɨlɨlɨ shaakho, bhalaga kʉkhaaya.” ");
INSERT INTO mgq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pe papaala we bhonti bhakʉmwenya, umuntu ʉla akhɨmɨɨlɨla, akheega ɨshɨlɨlɨ shaakwe, akhafuma kunzi. Abhantʉ bhonti bhakhaswiga, na kʉmʉpaala ʉMʉlʉngʉ bhakhatɨ, “Tutazilolile nsiku izi zye zyafumila ʉmʉsanyʉʉnʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pe uYeesu akhafuma, akhabhala winza kʉmbalɨ kwa sʉmbɨ, abhantʉ abhinji bhakhamʉlandata kukuula, akhanda kʉbhamanyɨzya. ");
INSERT INTO mgq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pɨlongolela we uYeesu akʉshɨla, akhamʉlola uLaawi ʉmwana wa Alʉfeeyo ayɨkhaaye mu ofesi yaakwe ɨya kʉsonshezya ɨnsonho. UYeesu akhamʉbhʉʉzya akhatɨ, “Ndandate.” Nalʉbhɨlo, uLaawi akhɨmɨɨlɨla, akhanda kʉmʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","UYeesu na bhalandati bhaakwe, bhábhalile kulya ishaakulya mu nyumba ya Laawi. Abhasonshezya nsonho na bhabhomba mbiibhi bhe bhakhamʉlandataga, abhinji bhaabho bhɨ́khaaye pa shintalati kulya ishaakulya peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pe bhamu abhamanyizyi abhɨ ndajɨzyo na Bhafalisaayi we bhaalola uYeesu akulya peeka na bhasonshezya nsonho na bhabhomba mbiibhi, bhakhabhabhʉzɨɨlɨzya abhalandati bhaakwe bhakhatɨ, “Khooni khe akulya peeka na bhasonshezya nsonho na bhabhomba mbiibhi?” ");
INSERT INTO mgq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","We uYeesu ayɨmvwa zɨnɨɨzyo, akhabhabhʉʉzya akhatɨ, “Abhantʉ bhe bhatabhinile bhatakʉmwanza ʉmʉganga, lyoli bhe bhabhinu. Ɨne intínzile kʉbhanza bhe bhakʉyɨlola kʉtɨ bhagolosu, lyoli nínzile kʉbhanza abhabhomba mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mʉ khabhalɨlo khamu, abhalandati bha Yookhani uMwozyi na bha Bhafalisaayi, mu nsiku zye bhalɨ kupuuta, bhakhayiimaga kulya. Isiku limo, abhantʉ bhamu bhínzile kwa Yeesu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Abhalandati bha Yookhani uMwozyi na bha Bhafalisaayi mu nsiku zye bhalɨ kupuuta bhakuyiima kulya, khooni khe ɨwe abhaakho mu nsiku ɨzya lupuuto bhatakuyiima kulya?” ");
INSERT INTO mgq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pe uYeesu akhabhaamʉla akhatɨ, “Abhantʉ bhe bhalanjiliilwe ku weeji, bhangayiima kulya anza bhʉlɨɨbhʉlɨ, we bhalɨ peeka nʉ wa weeji? Mʉ khabhalɨlo khonti we bhalɨ peeka nawo bhatangayiima kulya. ");
INSERT INTO mgq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɨleelo mu nsiku zye zɨkwɨnza, we abhalʉgʉ bhamwefwa ʉwa weeji pakaasi yaabho, akhabhalɨlo khanaakho bhakhayiyiima kulya. ");
INSERT INTO mgq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Atalɨɨpo umuntu we akudeebula ɨshɨpaatɨkho kʉ mwenda umupwa, na kʉshɨpaatɨkha mʉ mwenda ʉmʉkʉʉlʉ. Ɨnga akhonzya shɨnɨɨsho, ɨshɨpaatɨkho ishipwa shikuyizeepula kufuma kʉ mwenda ʉmʉkʉʉlʉ, pe woope wʉkwonjela kuzeepukha nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iwinza nʉʉmo umuntu we akʉbhɨɨkha idivaayi impwa mʉ ntembe ɨnkʉʉlʉ zye zilalile. Ɨnga abhomba shɨnɨɨsho, we yɨkʉlʉla ɨntembe zɨkʉbazʉkha, idivaayi yikwitikha nɨ ntembe yoope yɨkʉnanjɨkha. Ɨleelo idivaayi impwa yɨkwanzɨwa kʉyɨbhɨɨkha mʉ ntembe impwa.” ");
INSERT INTO mgq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Isiku limo ɨlyɨ Sabaato, uYeesu akhashɨlaga mu vwizi ɨvwɨ ngano. Abhalandati bhaakwe bhakhanda kudumula amatwe agɨ ngano na kulya. ");
INSERT INTO mgq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pe aBhafalisaayi bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Khooni khe abhalandati bhaakho bhakʉbhomba zye zɨtakwɨtɨshɨlwa kʉbhomba pi siku ɨlyɨ Sabaato?” ");
INSERT INTO mgq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, mutabhaziizye nsiku mu Wusimbe uWufinjile she uDaudi ábhombile we ɨnzala yabhaluma, ʉweene peeka na bhamwabho? ");
INSERT INTO mgq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ɨmaandɨ we uAbitaali áamɨle mupuutili mʉpɨtɨ? UDaudi áyinjiiye mu nyumba ya Mʉlʉngʉ, akhalya amakaati ge gábhishiilwe pa shɨgemo kʉ mbombo imfinjile. Bhapuutili bheene bhe bhítishiliilwe kulya amakaati ɨgo, ɨleelo uDaudi áliiye genego, khabhɨlɨ ábhapiiye na bhamwabho, bhoope bhakhalya.” ");
INSERT INTO mgq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Isiku ɨlyɨ Sabaato lyábhishiilwe nʉ Mʉlʉngʉ kʉtɨ lɨbhavwaje abhantʉ, lɨtáamɨle lya kʉtɨ abhantʉ bhe bhalɨbhombelaje isiku ɨlyo khaala. ");
INSERT INTO mgq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mʉmanye kʉtɨ ʉMwana wa Muntu we wʉ Mwene ʉwɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","UYeesu akhinjila winza mwi sinagoogi, mʉnʉʉmwo álɨɨpo umuntu we álemaaye ɨnyoobhe. ");
INSERT INTO mgq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ABhafalisaayi bhamu bhámʉlɨndɨlɨɨye nhaani uYeesu kʉmwenyeelezya kʉtɨ bhalole she atɨmʉponɨe umuntu ʉla pi siku ɨlyɨ Sabaato. Ɨnga amʉponɨa, bhalyaje ɨdala ɨlya kʉmʉsɨtaaka. ");
INSERT INTO mgq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","UYeesu akhamʉbhʉʉzya umuntu ʉla we álemaaye ɨnyoobhe akhatɨ, “Bhʉʉkha, ʉyɨmɨɨlɨle pakaasi.” ");
INSERT INTO mgq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pe uYeesu akhabhashebhela abhantʉ bhaala, akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, lyoni lye ɨndajɨzyo zɨkwɨtɨshɨzya pi siku ɨlyɨ Sabaato, kʉ kʉbhomba imbiibhi, awe kʉ kʉbhomba inyinza, kʉ kʉgoga awe kʉ kʉponɨa uwuumi?” Abheene bhakhapʉʉma bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","UYeesu akhabheenya bhonti kʉ mʉlakha na kʉswɨmɨɨlɨla mʉ mwoyo waakwe, kʉnongwa ya wugomu ʉwa mooyo gaabho. Pe uYeesu akhamʉbhʉʉzya umuntu ʉla akhatɨ, “Golosya ɨnyoobhe yaakho.” Woope akhagolosya, yɨkhapona, yɨkhabha nyinza bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Panaapo bhʉʉlo aBhafalisaayi bhaala bhakhafuma panzɨ, bhakhakhomaana na bhalandati bha mwene uHeloodi, bhakhanda kʉpanzanya she bhangamʉgoga uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Pe uYeesu akhasogola kwenekwo, akhabhala kwa sʉmbɨ peeka na bhalandati bhaakwe. We bhɨmvwa amayele ge akʉbhomba, ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakhamʉlandata kufuma mʉ nsɨ ɨya Galɨlaaya, mʉ nhaaya ɨya Yelusaleemu na mʉ nsɨ ɨya Yudeeya, na mʉ nsɨ ɨya Idumeeya, na mwɨ syɨla ɨya lwizi ʉlwa Yoolodani, na papɨɨpɨ nɨ nhaaya ɨzya Tiilo ni Sidooni. ");
INSERT INTO mgq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","UYeesu akhabhabhʉʉzya abhalandati bhaakwe kʉtɨ bhashɨlɨngaanye ɨshɨtʉʉlɨ shɨbhe papɨɨpɨ yanzɨɨla, mwe akhabhe, ɨnga abhantʉ bhamubijiilizya. ");
INSERT INTO mgq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Álonjile shɨnɨɨsho kʉnongwa ye ábhaponiizye abhantʉ abhinji, abhabhinu bhakhabijilizyaga we bhakʉsejeelela kʉkwakwe kʉtɨ bhamʉpalamansye. ");
INSERT INTO mgq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Abhantʉ bhonti bhe bháamɨle na mapepu amabhiibhi we bhamʉlola bhʉʉlo, bhakhagwanga pa vɨnama vwakwe na kʉkhoola ɨnhoolo, kʉtɨ, “Ɨwe we Mwana wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɨleelo akhagasokha amapepu kʉtɨ gatakhavundule kʉ bhantʉ kʉtɨ ʉweene wu naanu. ");
INSERT INTO mgq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","UYeesu akhazʉbha mwɨ gamba, akhabhasebha abhantʉ bhe akhanzaga kʉjenda nabho mwe akʉbhala, bhakhɨnza kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ásebhile abhantʉ ishumi na bhabhɨlɨ kʉtɨ abhanje nabho wiila, abhasontelezyaje kʉlʉmbɨɨlɨla, ");
INSERT INTO mgq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aabhape nʉ waamʉlo ʉwa kwefwa amapepu amabhiibhi mʉ bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɨga ge mataawa ga bhantʉ ishumi na bhabhɨlɨ bhe ábhasebhile: uSiimoni we ámʉtanʉʉye ɨtaawa ilinji, akhatɨ wu Peeteli, ");
INSERT INTO mgq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ʉYaakobo nu Yookhani bhe bháamɨle bhaana bha Zebedaayo bhe uYeesu akhabhataanʉla ɨtaawa ɨlya Boeneji, kwe kʉtɨ, “ABhaana bha Nguluguuto,” ");
INSERT INTO mgq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ʉAndeleeya, uFilipo, ʉBatolomaayo, uMataayi, uToomasi, ʉYaakobo ʉmwana wa Alʉfeeyo, ʉTadeeyo, uSiimoni ʉmʉlwɨla nsɨ yaakwe, ");
INSERT INTO mgq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nʉ Yʉʉda Sikalioti, we akhamʉlonjeelela uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pe we uYeesu ayinjila winza mu nyumba ye akhabhanga, ɨmpʉga ɨya bhantʉ yɨkhabhʉngaana winza papaala, uYeesu na bhalandati bhaakwe bhakhapootwa na kulya. ");
INSERT INTO mgq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","We abha mʉmwabho bhazyɨmvwa ziniizi, bhakhabhala kʉmwega, bhakhatɨnjɨ akʉlaalʉkha. ");
INSERT INTO mgq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bhoope abhamanyizyi abhɨ ndajɨzyo bhe bháfumile ku Yelusaleemu bhakhatɨnjɨ, “Alɨ nu Belizebuuli, ʉmʉpɨtɨ wa mapepu! Wʉnʉʉyo we akuumupa ʉwaamʉlo ʉwa kʉbhɨnga amapepu amabhiibhi.” ");
INSERT INTO mgq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pe uYeesu akhabhabhɨlɨshɨla, akhanda kʉbhabhʉʉzya kʉ vɨkholanyo akhatɨ, “Bhʉlɨ, uSeetani angafishila kʉyɨbhɨnga wʉʉyo anza bhʉlɨɨbhʉlɨ? ");
INSERT INTO mgq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɨnga abhantʉ abha wʉmwene weeka bhagabhʉnhana ɨvɨpʉga vwe vɨtakwɨmvwana, ʉwʉmwene wʉnʉʉwo wʉkʉnanjɨkha. ");
INSERT INTO mgq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bhoope abhantʉ abha mu nyumba yeeka ɨnga bhagabhʉnhana ɨvɨpʉga vwe vɨtakwɨmvwana, inyumba yɨnɨɨyo yɨkʉnanjɨkha. ");
INSERT INTO mgq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɨnga uSeetani akulwa na maseetani agamwabho nʉ wʉmwene waakwe wugabhunhiine, wʉngɨmɨɨlɨla anza bhʉlɨɨbhʉlɨ? Wʉtangɨmɨɨlɨla khaala, lyoli we wuguuye nzɨɨla. ");
INSERT INTO mgq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɨleelo uwanalyoli we wu wuuwu: atalɨɨpo umuntu we angakhola kwinjila mu nyumba ya muntu ʉwa makha kʉtɨ amʉfwʉlɨle ivintu vwakwe sita kumupinya suuti. Lyoli ɨnga amupinya, pe angakhola kʉfwʉla vwe vɨlɨ mu nyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nalyoli ɨnkʉbhabhʉʉzya, abhantʉ bhakhayɨtʉʉyɨlwa imbiibhi zyabho nɨ nshoolanyo zyabho zyonti. ");
INSERT INTO mgq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɨleelo umuntu wowonti we akʉmʉshoolanya uMupepu uMufinjile, te akhatʉʉyɨlwe naalumo. Lyoli akhayɨbha ni mbiibhi ɨya wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ábhabhuziizye shɨnɨɨsho kʉnongwa ye abheene bhakhatɨnjɨ alɨ ni pepu ibhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pe panaapo, unyina wa Yeesu na bhakhambakʉ bhaakwe bhakhafikha papaala, bhakhɨmɨɨlɨla panzɨ pa nyumba mwe akhamanyɨzyaga. Bhakhamʉsonteelezya umuntu ʉmo kʉtɨ amʉbhɨlɨshɨle uYeesu mu nyumba, bhalonje nawo. ");
INSERT INTO mgq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɨmpʉga ɨmpɨtɨ ɨya bhantʉ yɨ́khaaye, yámʉzyʉgʉlʉʉye, uYeesu akhabhamanyɨzyaga. Pe bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Yeenya, unyina waakho na bhakhambakʉ bhaakho bhalɨ panzɨ ɨpo, bhakʉkwanza.” ");
INSERT INTO mgq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","UYeesu akhaamʉla akhatɨ, “Unyina waanɨ na bhakhambakʉ bhaanɨ bhe bha bhanaanu?” ");
INSERT INTO mgq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","UYeesu akhabheenya abhantʉ bhe bhɨ́khaaye bhámʉzyʉngʉlʉʉye, akhatɨ, “Yeenyi, ɨbha bhe bhanyina bhaanɨ na bhe bhakhambakʉ bhaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Akhalonga akhatɨ, “Umuntu wowonti we akʉbhomba zye ʉMʉlʉngʉ akwanza, wʉnʉʉyo we wʉ khambakʉ waanɨ, we wʉ yɨlʉmbʉ waanɨ, khabhɨlɨ we wu nyina waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","UYeesu akhanda kʉbhamanyɨzya abhantʉ winza pambalɨ pa sʉmbɨ. Ɨmpʉga ɨmpɨtɨ nhaani ɨya bhantʉ yɨkhamʉbhʉngaanɨla. Pe akhazʉbha mʉ shɨtʉʉlɨ, akhɨɨkhala ɨnga atabijilizanyaaje na bhantʉ. Abhantʉ bhonti bhɨ́khaaye pambalɨ pa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Akhabhamanyɨzyaga amazwi aminji kʉ vɨkholanyo. Mʉ manyɨzyo zyakwe, akhamanyɨzyaga akhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tejeelezyi, álɨɨpo umupesi ʉmo we ábhalile kʉsansa imbeyu. ");
INSERT INTO mgq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","We akʉsansa, imbeyu zimo zɨkhalendela mwɨ dala, inyonyi zɨkhɨnza na kuzilya. ");
INSERT INTO mgq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imbeyu ɨzyamwabho zɨkhalendela pɨ lyalaawe lye lɨtalɨ nu lusuuto ulwinji, imbeyu zɨnɨɨzyo zɨkhamela nalʉbhɨlo kʉnongwa ye ulusuuto lwámɨle lushe pamwanya. ");
INSERT INTO mgq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ɨleelo we ɨzʉbha lyalama, imbeyu zɨnɨɨzyo zɨkhapwa na kʉnyaala kʉnongwa ye amazi gaakwe gatíishile paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imbeyu ɨzyamwabho zɨkhalendela mu makwi aga mimvwa. We amimvwa ganaago gaakʉla, gakhazipuuta imbeyu ziila, zɨkhapootwa kwela. ");
INSERT INTO mgq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɨleelo ɨzyamwabho zɨkhalendela mu lusuuto uluvunzu, zɨkhamela, zɨkhakʉla na kwela nhaani. Imbeyu yeeka yɨkheela imbeyu impwa amashumi gatatʉ, ɨyamwabho yɨkheela imbeyu impwa amashumi ʉmʉtanda, iwinza ɨyamwabho yɨkheela imbeyu impwa imia yeeka (100).” ");
INSERT INTO mgq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa!” ");
INSERT INTO mgq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","UYeesu akhasyala na bhalandati bhaakwe ishumi na bhabhɨlɨ, na bhalandati abhamwabho. Pe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ishi ɨvɨkholanyo vwakho vɨkʉlɨnganɨzya akhooni?” ");
INSERT INTO mgq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akhabhaamʉla akhatɨ, “Ɨmwe ʉMʉlʉngʉ abhapiiye kʉmanya ɨzya kukwilu ɨzya wʉmwene waakwe. Ɨleelo abhantʉ abha kunzi ɨnkʉbhabhʉʉzya zyonti kʉ vɨkholanyo, ");
INSERT INTO mgq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ɨnga zɨbhe anza she zisimbiilwe kʉtɨ, ‘We bhakwenya, bhatalolaje, khabhɨlɨ we bhakwɨmvwa, bhatazyaganyaaje, ɨnga bhatakhalaate na kʉtʉʉyɨlwa.’” ");
INSERT INTO mgq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pe uYeesu akhatɨ, “Ishi leelo ɨnga mʉtakʉshaaganya ɨshɨkholanyo ishi, bhʉlɨ, pe mʉtɨvwaganyaaje ɨvwamwabho anza bhʉlɨɨbhʉlɨ? ");
INSERT INTO mgq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ʉmʉpesa mbeyu muntu we akʉbhaleetela abhinji amazwi ga wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","She abhantʉ bhamu bhakʉtejeelezya izwi lya Mʉlʉngʉ, bhakʉkholanywa ni mbeyu ye yálendeeye mwɨ dala. Ɨbha bhe bha bhaala bhe ɨnga bhɨmvwa bhʉʉlo izwi lya Mʉlʉngʉ, uSeetani akwɨnza, akwefwa izwi liila mʉ mooyo gaabho. ");
INSERT INTO mgq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bhamu she bhakwɨmvwa izwi lya Mʉlʉngʉ, bhakʉkholanywa ni mbeyu zye zyálendeeye mu khasuuto khashe pɨ lyalaawe. Ɨbha bhe bhakʉlɨposheela izwi lya Mʉlʉngʉ nʉ lʉseshelo lwonti nalʉbhɨlo bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ɨleelo kʉnongwa ye bhatalɨ na mazi mukaasi yaabho, izwi lɨnɨɨlyo lɨkwɨkhala kʉ khabhalɨlo khashe. Ɨnga kweleela awe kʉyɨmba kwabhaaga kʉnongwa yi zwi lya Mʉlʉngʉ, nalʉbhɨlo bhakʉlɨlekha. ");
INSERT INTO mgq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bhamu she bhakwɨmvwa izwi lya Mʉlʉngʉ, bhakʉkholanywa ni mbeyu zye zyálendeeye mu lusuuto lwe lʉlɨ na mazi aga mimvwa. Bhanaabha bhoope bhe bhakʉlyɨmvwa na kʉlɨposheela izwi lya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ɨleelo kʉnongwa ɨya kʉpɨlɨnhana nɨ mbombo ɨzya mʉ nsɨ na kʉkhopelwa nɨ nsʉngʉkho ɨzya kwanza uwudumbwe peeka na kʉvwanza ivintu ivwinza ɨvwamwabho, vwonti vɨnɨɨvwo vikulipuuta izwi kʉtɨ lɨteelaje amatunda. ");
INSERT INTO mgq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bhamu she bhakwɨmvwa izwi lya Mʉlʉngʉ, bhakʉkholanywa ni mbeyu zye zyálendeeye mu lusuuto uluvunzu. Ɨbha bhe bhakʉlyɨmvwa izwi lya Mʉlʉngʉ na kʉlɨposheela, na kʉlɨbhombela. Pe lɨkʉbhala kʉbhazenga abhantʉ kʉbhomba inyinza, anza she imbeyu yeeka yéleeye imbeyu impwa amashumi gatatʉ, ɨyamwabho amashumi ʉmʉtanda, yimo imia yeeka (100).” ");
INSERT INTO mgq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","UYeesu akhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, alɨɨpo umuntu we akʉkhozya ɨtaala, na kʉlɨbhɨɨkha kwɨ zyʉngʉ kʉ shɨtala, awe kugubishila mʉ nsonta? Bhʉlɨ, atakʉlɨbhɨɨkha pamwanya pa shɨmbeeje kʉtɨ lɨkhozyaje mwonti? ");
INSERT INTO mgq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pe ishi leelo, gonti ge galɨ kukwilu gakhayɨbha apazelu, khabhɨlɨ gonti ge gafisishile gakhayɨmanyɨkha. ");
INSERT INTO mgq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa!” ");
INSERT INTO mgq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pe uYeesu akhajendeelela kʉbhabhʉʉzya, akhatɨ, “Tejelezyaji nhaani! Ishipimilo she mukubhapimila abhanjɨ, she shɨnɨɨsho ʉMʉlʉngʉ akhayipimila kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kʉnongwa ye we akʉlɨtejeelezya izwi lya Mʉlʉngʉ na kʉlɨmanya, pe ʉMʉlʉngʉ akʉmwavwa kwonjela kʉlɨmanya nhaani. Ɨleelo we atakʉlɨtejeelezya izwi lya Mʉlʉngʉ, ni linsi lye alimanyile lɨkʉfwʉlwa.” ");
INSERT INTO mgq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","UYeesu akhajendeelela kʉbhabhʉʉzya akhatɨ, “Ʉwʉmwene wa Mʉlʉngʉ wukholiine nu muntu we akʉpesa imbeyu mu shiizi. ");
INSERT INTO mgq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Shawusiku na shamʉsanya, abhe adamushile awe agonile, imbeyu yiila yɨkʉbha yɨlɨ kʉmela na kʉkʉla, kwɨ dala lye umupesi atalimanyile khaala she yɨkʉkʉla. ");
INSERT INTO mgq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ulusuuto lwe lʉkʉyɨkʉzya imbeyu yiila na kʉyeelezya. Yɨkʉtala suuti kudugula, pe yɨkwanda kʉkʉla, kʉwʉmalɨlɨshɨlo yɨkʉmezya ɨnyaana. Ɨnyaana yɨkʉbha nɨ khoso lye lɨlɨ ni mbeyu mwonti. ");
INSERT INTO mgq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","We imbeyu yiila yeela, khabhɨlɨ yaagoma, pe akwanda kʉkhaasa, kʉnongwa ye akhabhalɨlo akha kʉsezya khafishile.” ");
INSERT INTO mgq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iwinza uYeesu akhalonga nabho akhatɨ, “Ishi tʉwʉkholanye ʉwʉmwene wa Mʉlʉngʉ na khooni? Tʉshɨkholanye kʉ shɨkholanyo shooni? ");
INSERT INTO mgq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wukholiine na khasanga akhi nhaladaali akhansi kʉshɨla ɨnsanga zyonti zye zɨkʉwaalwa mu vwizi. ");
INSERT INTO mgq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ɨleelo ɨnga khaamela, khakʉbha likwi ɨpɨtɨ kʉshɨla amakwi gonti aga mu vwizi. Lɨkʉbha nɨ mpaaswa ɨmpɨtɨ zye ni nyonyi zyope zɨkʉtenjela ivwanswi mʉ mpaaswa zya khanzundila khaakwe.” ");
INSERT INTO mgq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","UYeesu akhabhalʉmbɨlɨlaga amazwi aga wʉmwene wa Mʉlʉngʉ kʉ vɨkholanyo ivwinji anza viniivi. Akhabhabhʉzyaga anza she bhakhazyaganyaaga. ");
INSERT INTO mgq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Atakhalongaga lyolyonti kʉkwabho sita shɨkholanyo. Ɨleelo we alɨ mwene na bhalandati bhaakwe, bhe akhabhalɨnganɨzyaga zyonti. ");
INSERT INTO mgq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Isiku liliila, shalyabheela yaakwe, uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Saalɨ, tufumiile ʉsʉmbɨ, tʉbhale kwɨsyɨla.” ");
INSERT INTO mgq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhakhayɨlekha ɨmpʉga ya bhantʉ, bhakhamwega uYeesu mʉ shɨtʉʉlɨ bhakhabhala peeka nawo. Páamɨle nɨ vɨtʉʉlɨ ɨvwamwabho vwe vwalongozanyiinye nawo. ");
INSERT INTO mgq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Impepu inhali nhaani yɨkhanda kuvugula mwa sʉmbɨ muula. Amabhilingwa gakhashibunshila ɨshɨtʉʉlɨ na minzi gakhiizula. ");
INSERT INTO mgq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mʉ khabhalɨlo khakhaala, uYeesu ágonile kʉlʉsalo kʉ shɨtʉʉlɨ, áyinuliiye ni shinulilo kwi twe. Abhalandati bhaakwe bhakhamʉdaamʉsya, bhakhatɨ, “Mumanyizyi, kwe kʉtɨ ʉtasajɨɨye khaala we ɨtwe tukufwa?” ");
INSERT INTO mgq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pe uYeesu akhɨmɨɨlɨla akhayɨkhajɨla impepu yiila, akhagabhʉʉzya amabhilingwa akhatɨ, “Puumi mye!” Impepu yiila yɨkhalekha kuvugula, kʉkhabha mye nalyoli lyoli. ");
INSERT INTO mgq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pe uYeesu akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Khooni khe ɨmwe mʉlɨ nɨ lyoga? Niishi bhʉʉlo mʉtalɨ nʉ lwɨtɨkho khaala?” ");
INSERT INTO mgq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Abheene bhakhoogopa nhaani, bhakhanda kʉbhʉzɨlɨzanya kʉtɨ, “Ishi wu naanu wʉnʉʉnʉ we ni mpepu na mabhilingwa vikumutinikha?” ");
INSERT INTO mgq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pe uYeesu na bhalandati bhaakwe bhakhafikha kwɨsyɨla ilinji ɨlya sʉmbɨ, kʉ nsɨ ɨya Bhagelaasi. ");
INSERT INTO mgq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","We uYeesu ayiikha bhʉʉlo kufuma mʉ shɨtʉʉlɨ, umuntu ʉmo we áamɨle ni pepu ibhiibhi, akhafuma kʉ mbɨɨpa, akhamʉshɨmbɨɨlɨla uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Umuntu ʉnʉ akhabhanga kʉ mbɨɨpa, áamɨle na makha, atálɨɨpo umuntu nʉʉmo we áamɨle angakhola kʉmʉkʉnga poope na manyoloolo. ");
INSERT INTO mgq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bhakhamʉkʉnjɨɨlaga akhinji bhʉʉlo na manyoloolo nɨ mpɨngwa, ɨleelo akhagadadʉlanyaaga amanyoloolo na kʉzɨdadʉlanya ɨmpɨngwa, atálɨɨpo umuntu we áamɨle angamudindanjila. ");
INSERT INTO mgq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Akhabhanga kʉ mbɨɨpa na mʉ magamba shawusiku na shamʉsanya, akhakholelaga na kʉyɨbhoolanya na mawe. ");
INSERT INTO mgq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","She uYeesu alɨ ukutali bhʉʉlo, umuntu ʉla akhamʉlola na kʉmʉshɨmbɨɨlɨla, akhabhala akhasʉgamɨla mʉ vɨnama vwakwe. ");
INSERT INTO mgq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","We uYeesu amʉlola, akhalɨbhʉʉzya ipepu lye lyámɨle mʉmwakwe akhatɨ, “Yeepa mwa muntu ʉnʉ!” Pe umuntu ʉla akhakhoola kwi zi ɨlya kʉdandɨzya akhatɨ, “Ʉlɨ na khooni nɨɨne Yeesu, Mwana wa Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya? Ɨnkʉkʉlaabha kwɨ taawa lya Mʉlʉngʉ kʉtɨ ʉtanjɨmvwaje.” ");
INSERT INTO mgq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pe uYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “Ɨtaawa lyakho we naanu?” Akhamwamʉla akhatɨ, “Ɨtaawa lyanɨ ne Lijeeshi, kʉnongwa ye ɨtwe twe bhinji mukaasi mwa muntu ʉnʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ipepu liila lɨkhamʉlambɨɨlɨzya kʉtɨ atakhalɨbhɨnje mʉ nsɨ yiila. ");
INSERT INTO mgq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Papaala páamɨle ɨmpʉga ɨmpɨtɨ ɨyɨ ngʉlʉbhe, zɨkhalyanga mʉ khazʉbha akhɨ gamba. ");
INSERT INTO mgq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pe amapepu gaala gakhatɨ, “Tʉkʉkʉlamba kʉtɨ ʉtwɨtɨshɨzye, twinjile mʉ ngʉlʉbhe ziila.” ");
INSERT INTO mgq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","UYeesu akhagɨtɨshɨzya, gakhafuma, gakhinjila mʉ ngʉlʉbhe. Ɨmpʉga yonti ɨyɨ ngʉlʉbhe zye zyámɨle ielufu zɨbhɨlɨ (2,000), zɨkhashɨmbɨla, zikhiikha ku lwikha lwe lusulamile nhaani ʉlwɨ gamba liila, paka mwa sʉmbɨ, zɨkhagwɨla na kufwa. ");
INSERT INTO mgq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abhadiimi abhɨ ngʉlʉbhe, bhakhoogopa, bhakhashɨmbɨla, bhakhabhala mʉ nhaaya na mu vwizi. Poponti pe bhaafikha, bhakhabhabhʉzyaga abhantʉ ɨnongwa zɨnɨɨzyo. Abhantʉ bhakhɨnza kwe uYeesu áamɨle, kʉtɨ bhayɨlolele bhɨɨbho zye zibhombeshile. ");
INSERT INTO mgq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bhakhamʉbhalɨla uYeesu, bhakhoogopa nhaani we bhamʉlola umuntu we áamɨle ni jeeshi ɨlya mapepu amabhiibhi ayɨkhaaye, akwatile amenda, alɨ nɨ njeele zyonti. ");
INSERT INTO mgq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhaala bhe bhálolile zye zyábhombeshile, bhakhabhabhʉʉzya abhanjɨ she zyámɨle, uYeesu we akʉmʉponɨa ʉwa mapepu. ");
INSERT INTO mgq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pe ɨmpʉga yiila yɨkhanda kʉmʉlamba uYeesu kʉtɨ asogole mʉ nsɨ yaabho. ");
INSERT INTO mgq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","UYeesu akhanda kʉsogola, we akwinjila mʉ shɨtʉʉlɨ, umuntu ʉla we áamɨle na mapepu amabhiibhi akhanda kʉmʉlambɨɨlɨzya uYeesu amwɨtɨshɨzye kʉtɨ abhalaje nawo. ");
INSERT INTO mgq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ɨleelo uYeesu atakhamwɨtɨshɨzya khaala, lyoli akhamʉbhʉʉzya akhatɨ, “Bhalaga kukwinyu, ʉbhale ʉbhabhʉʉzye zye ʉMʉlʉngʉ akʉbhombeeye, na she akʉloleeye ishisa.” ");
INSERT INTO mgq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pe umuntu ʉla akhasogola, akhanda kʉbhabhʉʉzya abhantʉ mu Dekapooli zye uYeesu amʉbhombeeye. Abhantʉ bhonti bhakhaswiga. ");
INSERT INTO mgq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","We uYeesu afumiila ʉsʉmbɨ mʉ shɨtʉʉlɨ, aabhala kwɨsyɨla ilinji, ʉweene akhabha pambalɨ pa sʉmbɨ, pe ɨmpʉga ɨmpɨtɨ ɨya bhantʉ yɨkhamʉbhʉngaanɨla. ");
INSERT INTO mgq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Panaapo, akhɨnza ʉmʉpɨtɨ ʉmo uwi sinagoogi lyabho, we ɨtaawa lyakwe bhakhatɨnjɨ ʉYayɨlo. We amʉlola uYeesu, akhamʉsejeelela, akhagwa pa vɨnama vwakwe. ");
INSERT INTO mgq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akhamʉlambɨɨlɨzya nhaani akhatɨ, “Ʉmwalɨ waanɨ akwanza kufwa. Nalamba nalamba, nzaaga, ʉmʉbhɨɨshe ɨnyoobhe yaakho, ʉmʉponɨe kʉtɨ abhe mwinza bhʉʉlo.” ");
INSERT INTO mgq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pe uYeesu akhanda kʉbhala kwa muntu ʉyo. Ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakhanda kʉmʉlandata, bhakhabijilizanyaaga pe áamɨle. ");
INSERT INTO mgq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mʉ mpʉga yiyiila mwámɨle nʉ mwantanda we áyimbile nu wubhinu ʉwa kuzwa ɨbhanda kʉ manha ishumi na gabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ʉmwantanda ʉla áyimbile nhaani kʉbheeta mʉ bhaganga abhinji, ámalile ɨshʉʉma shaakwe shonti kʉtwala kʉ bhaganga, ɨleelo uwubhinu waakwe wʉtakhapʉpʉʉkhaga khaala, lyoli wʉkhonjelaga. ");
INSERT INTO mgq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Ʉmwantanda ʉla áyimvwizye ɨzya Yeesu, akhasɨɨbhaga akhatɨnjɨ, “Poope she napalamansya ʉmwenda waakwe bhʉʉlo, ɨntɨpone.” Pe akhabhala kʉlʉsalo kwa Yeesu, akhawʉpalamansya ʉmwenda waakwe. ");
INSERT INTO mgq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pe she awʉpalamansya bhʉʉlo, amabhanda gakhalekha kufuma, woope akhayɨmvwa kʉtɨ aapona nalyoli. ");
INSERT INTO mgq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ɨleelo uYeesu akhamanya bhʉʉlo kʉtɨ amakha gaakwe gabhomba ɨmbombo. Akhagalʉnhana, akhabhʉzɨɨlɨzya akhatɨ, “Wu naanu we apalamansya amenda gaanɨ?” ");
INSERT INTO mgq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abhalandati bhaakwe bhakhamwamʉla bhakhatɨ, “Che! She ʉkʉlola abhantʉ bhonti ɨbha bhakubijilizanya kʉkwakho, ishi khooni khe ʉkʉbhʉzɨɨlɨzya ʉkʉtɨ, ‘Wu naanu we ampalamansya?’ ” ");
INSERT INTO mgq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɨleelo akhajendeelela kʉtelenganya kwenya umuntu we amupalamansiizye. ");
INSERT INTO mgq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pe ʉmwantanda ʉla, she amanyile zye zibhombeshile kʉkwakwe, akhatʉʉya, akhɨnza na kugwa pa vɨnama vwa Yeesu, kumo akuyinga. Akhamʉbhʉʉzya she zyaamɨle. ");
INSERT INTO mgq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","UYeesu akhamʉbhʉʉzya akhatɨ, “We mwalɨ waanɨ, ʉlwɨtɨkho lwakho lwakʉponɨa, bhalaga ku wutengaanu, ishi uponile.” ");
INSERT INTO mgq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","We uYeesu alɨ kʉlonga nʉ mwantanda ʉyo, abhantʉ bhakhɨnza kufuma kʉkhaaya kwa Yayɨlo, bhakhalonga bhakhatɨ, “Lakha kʉmʉyɨmvwa umumanyizyi, ʉmwalɨ waakho afuuye.” ");
INSERT INTO mgq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ɨleelo uYeesu atakhazɨsaajɨla zye bhakʉlonga, akhamʉbhʉʉzya uyise wa mwana ʉla akhatɨ, “Ʉtogopaje khaala, lyoli ʉyɨɨtɨshe.” ");
INSERT INTO mgq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pe uYeesu akhabhagalʉsya abhantʉ abhanjɨ bhonti, lyoli akhabhala nu Peeteli, ʉYaakobo nu Yookhani ʉkhambakʉ wa Yaakobo bheene. ");
INSERT INTO mgq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","We bhaafikha pakhaaya pa Yayɨlo, uYeesu akhaaga papatɨɨye ɨshongo, abhantʉ bhakhalɨlaga na kʉyɨlʉmbʉʉzya. ");
INSERT INTO mgq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","UYeesu akhinjila mu nyumba muula, akhabhabhʉʉzya akhatɨ, “Ɨshongo ishi nɨ nhoolo ɨnɨ ya khooni? Ʉmwana ʉnʉ atafuuye, lyoli asʉpɨlɨɨye bhʉʉlo.” ");
INSERT INTO mgq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɨmpʉga ɨya bhantʉ bhaala yɨkhamʉsekha nhaani uYeesu, ɨleelo ʉweene akhabhafumwa bhonti panzɨ. Akhamwega uyise wa mwana nu nyina waakwe na bhalandati bhaakwe bhatatʉ, bhakhabhala ku wizigo kwe bhálibhiishile ivimba. ");
INSERT INTO mgq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akhalɨlema ivimba liila ɨnyoobhe, akhalonga akhatɨ, “Talita, kumi!” Kwe kʉtɨ, “Wʉmwana ɨwe, ɨnkʉkʉbhʉʉzya ɨnkʉtɨ yɨmɨɨlɨla!” ");
INSERT INTO mgq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pe panaapo, ʉmwana ʉla akhɨmɨɨlɨla, akhanda kʉjenda, áamɨle na manha ishumi na gabhɨlɨ, bhakhaswiga akhaswigo akhapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","UYeesu akhabhasokha nhaani kʉtɨ, bhatakhamʉbhʉʉzye umuntu nʉʉmo zye zyabhombekha. Iwinza akhabhabhʉʉzya abhapaafi bha mwana ʉla kʉtɨ bhaamupe ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pe uYeesu akhasogola kʉ nsɨ yiila, akhagalʉkha kʉkwabho ku Naazaleti na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pa Sabaato ye yɨkhalandata, akhanda kʉmanyɨzya mwi sinagoogi. Abhinji bhe bhámwimvwizye she akʉmanyɨzya, bháswijile na kʉmʉshoolanya nhaani. Bhakhatɨnjɨ, “Ishi anza wʉnʉʉnʉ azyajile kwoshi ziniizi? Khabhɨlɨ azyajile kwoshi ɨnjeele zyonti anza ziniizi na makha aga kʉbhombela amayele anza ganaaga? ");
INSERT INTO mgq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bhʉlɨ, wʉnʉʉnʉ te wʉ wʉʉla umukelesi? Bhʉlɨ, te mwana wa Maliya? Bhʉlɨ, abhakhambakʉ bhaakwe te wʉ Yaakobo, ʉYoose, ʉYʉʉda nu Siimoni? Bhʉlɨ, abhayɨlʉmbʉ bhaakwe tʉtakwɨkhala nabho panaapa?” Pe bhakhakhaana kʉmwɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Abhantʉ bhakumushindikha umukuwi ukunji kwonti, ɨleelo abha mʉ nhaaya yaakwe, na bhanholo bhaakwe, na bha mu nyumba yaakwe bhatakumushindikha.” ");
INSERT INTO mgq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kʉnongwa ye bhatáamɨle nʉ lwɨtɨkho, uYeesu akhabhomba amayele mashe bhʉʉlo kukuula. Ábhabhɨshɨɨye ɨnyoobhe abhabhinu bhashe bhʉʉlo, akhabhaponɨa. ");
INSERT INTO mgq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Zɨkhabha zya khaswigo kʉkwakwe we aalola bhatalɨ nʉ lwɨtɨkho naalumo. UYeesu akhazyʉngʉʉlaga mʉ tʉkhaaya ʉtwa papɨɨpɨ kʉbhamanyɨzya abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akhabhabhɨlɨshɨla peeka abhalandati bhaakwe ishumi na bhabhɨlɨ bhaala. Akhaabhapa ʉwaamʉlo ʉwa kʉbhɨnga amapepu amabhiibhi, akhabhasonteelezya bhabhɨlɨ bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akhabhalajɨzya akhatɨ, “Mʉtakhaapaye akhantʉ naakhamu mwɨ dala, awe ishaakulya, imbuguuli awe ɨnhela mʉ nyambɨ zyinyu, lyoli mwegaje zyɨ ndoogo nyeene mʉ nyoobhe. ");
INSERT INTO mgq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mʉkwataje vwɨ vɨlyatʉ vwinyu, mʉtakhaapaye amenda aga kwandʉlanya kwe mʉkʉbhala.” ");
INSERT INTO mgq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iwinza akhabhabhʉʉzya akhatɨ, “Mu nyumba yoyonti yiila ye bhabhaposheela, mʉkhabhanje mʉmwo, kufishila akhabhalɨlo khe mʉkhayɨsogola mʉ nhaaya yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɨnga poponti paala pe bhatabhaposheela awe kʉbhatejeelezya, we mʉkʉsogola, mukhakunyuntaje ulusuuto mʉ vɨnama vwinyu, kʉbhasokha kʉtɨ bhakʉmʉkhaana wʉ Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pe abhalandati bhaala bhakhasogola, bhakhanda kʉbhalʉmbɨɨlɨla abhantʉ bhonti bhe bhakhomaana nabho kʉtɨ bhapɨndʉkhaje na kʉzɨlekha imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhakhefwaga amapepu amabhiibhi kʉ bhantʉ abhinji, na kʉbhaponɨa abhabhinu abhinji ɨmpʉngo, we bhabhapakhazya amafuta. ");
INSERT INTO mgq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pe panaapo ʉmwene ʉwɨ nsɨ yiila, we ɨtaawa lyakwe áamɨle wu Heloodi, akhɨmvwa zye uYeesu akhabhombaga, kʉnongwa ye bhakhamʉlongaga poponti paala. Bhamu bhakhatɨnjɨ, “Wʉnʉʉyo wu Yookhani uMwozyi azyushile kufuma kʉ bhafwe. Ye nongwa ɨnɨ akʉbhomba amayele amapɨtɨ anza ganaago.” ");
INSERT INTO mgq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bhamu bhakhatɨnjɨ, “Wu Eliya.” Abhamwabho bhakhatɨnjɨ, “Ʉnʉ mukuwi anza bhakuwi abhɨ maandɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ɨleelo uHeloodi we ayɨmvwa, akhatɨ, “Wʉnʉʉnʉ wu Yookhani uMwozyi we ɨne námudumuuye itwe, azyushile kufuma kʉ bhafwe!” ");
INSERT INTO mgq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","UHeloodi ásonteleziizye kʉtɨ bhamʉleme uYookhani na kʉmʉkʉnga mwɨ jeela, we ayaaga uYookhani azemeeye kʉmʉbhʉʉzya kʉtɨ, “Mwinho pamiiso ga Mʉlʉngʉ kwega ʉmʉshɨ wa wamwabho.” UYookhani akhamʉbhʉzyaga shɨnɨɨsho kʉnongwa ye uHeloodi ámwejile uHelodiya we áamɨle mʉshɨ wa khambakʉ waakwe uFilipo. ");
INSERT INTO mgq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","We zyabha shɨnɨɨsho, uHelodiya akhabha nu lwisi kwa Yookhani. Akhanzaga ɨdala ɨlya kʉmʉgoga, ɨleelo akhapotwaga. ");
INSERT INTO mgq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kʉnongwa ye uHeloodi akhamwogopaga uYookhani, pe akhamʉlɨndɨlɨlaga kʉtɨ uHelodiya atakhamʉgoje, kʉnongwa ye ámanyile nzɨɨla kʉtɨ uYookhani muntu we mwinza, mugolosu, khabhɨlɨ áamɨle nu wanalyoli. UHeloodi áyiganile kʉmʉtejeelezya uYookhani nhaani, poope we amwɨmvwa, akhasʉngamaga nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pɨlongolela, uHeloodi akhabhɨɨkha ishikulukulu na bhatongwa bhaakwe, abhantʉ abhapɨtɨ mʉ Galɨlaaya, peeka na bhapɨtɨ bha bhasikaali bhaakwe kʉkʉmbʉkha isiku lye ápapiilwe. Pe uHelodiya akhalyaga ɨdala ɨlya kʉmʉgojela uYookhani. ");
INSERT INTO mgq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ʉmwalɨ wa Helodiya akhinjila mu shikulukulu, akhavina pɨlongolela pa Heloodi na bhajeni bhaakwe, bhonti bhakhasha nhaani. Ʉmwene uHeloodi akhamʉbhʉʉzya ʉmwana ʉla akhatɨ, “Mbʉʉzye khokhonti khe ʉkwanza, ɨne intiikupe.” ");
INSERT INTO mgq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iwinza akhalapa akhatɨ, “Khokhonti khe ɨwe ʉkwanza, ɨne intiikupe, poope ni nuusu ɨya wʉmwene waanɨ bhʉʉlo, woope inkuukupa.” ");
INSERT INTO mgq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pe ʉmwana ʉmʉlɨndʉ ʉla akhafuma panzɨ, akhamʉbhʉzɨɨlɨzya unyina akhatɨ, “Maayɨ, ɨndaabhe akhooni?” Unyina akhamwamʉla akhatɨ, “Laabha aakupe itwe lya Yookhani uMwozyi.” ");
INSERT INTO mgq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pe ʉmwana ʉmʉlɨndʉ ʉla akhakhalambana, akhabhala kwa mwene, akhamʉlaabha akhatɨ, “Ɨnkwanza kʉtɨ umpe shiniishi itwe lya Yookhani uMwozyi mʉ nselo.” ");
INSERT INTO mgq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ɄMwene akhayibhuna nhaani, ɨleelo kʉnongwa ɨya lufingo lwe álapile pɨlongolela pa bhajeni bhaala, akhapootwa she atɨmʉkhaane. ");
INSERT INTO mgq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pe akhamʉsonteelezya umusikaali kʉtɨ abhale kumudumula uYookhani itwe. Umusikaali ʉla akhabhala, akhamudumula uYookhani itwe mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akhalɨleeta itwe lya Yookhani mʉ nselo, akhaamupa ʉmwalɨ ʉla, woope akhaamupa unyina. ");
INSERT INTO mgq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","We abhalandati bha Yookhani bhazyɨmvwa ziniizi, bhakhabhala, bhakheega ivimba lyakwe, bhakhalɨsyɨla mʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pe abhasundikwa bha Yeesu bhakhamʉbhʉngaanɨla, bhakhamʉbhʉʉzya zyonti zye bhábhombile, na she bhabhamanyiziizye abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kʉnongwa ye kwámɨle na bhantʉ abhinji nhaani, bhamu bhakhɨnzaga, bhamu bhakhasogolaga, pe na bhalandati bhaakwe bhakhapootwa kʉbha na khabhalɨlo akha kulya. UYeesu akhabhabhʉʉzya akhatɨ, “Saalɨ tʉbheene, tʉbhale pamu pe patalɨ nɨ shongo, mʉtʉʉzye khashe.” ");
INSERT INTO mgq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bhakhasogola bheene mʉ shɨtʉʉlɨ, bhakhabhala kumo kwe kʉtáamɨle na bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɨleelo abhinji bhʉʉlo bhakhabhalola we bhakʉsogola, bhakhabhamanya. Bhakhabhashɨmbɨɨlɨla ʉlwa paasɨ kufuma ɨnhaaya inyinji bhʉʉlo, bhakhabhatangʉlɨla kufikha kuula kwe bhakhabhalaga. ");
INSERT INTO mgq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","We ayiikha mʉ shɨtʉʉlɨ, akhayɨlola ɨmpʉga ɨmpɨtɨ ɨya bhantʉ. We abhalola, akhabhalolela ishisa, kʉnongwa ye bháamɨle ngatɨ ngoole zye zɨtalɨ nu mudiimi. Pe akhanda kʉbhamanyɨzya inyinji. ");
INSERT INTO mgq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","We kwabha shalyabheela, abhalandati bhaakwe bhakhabhala bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Ɨpa pe tʉlɨ shilozu sheene, uwusiku wʉpalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ishi, bhalaje abhantʉ ɨbha ɨnga bhabhale bhayɨkalɨle bhɨɨbho ivwakulya mʉ tʉkhaaya ʉtwa mʉpɨɨpɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ɨleelo uYeesu akhabhaamʉla akhatɨ, “Bhape mʉneemwe ishaakulya!” Pe bhoope bhakhamʉbhʉʉzya bhakhatɨ, “Ʉkʉtɨ ɨtwe tʉbhale tʉbhakalɨle amakaati agi dinaali imia zɨbhɨlɨ (200), kʉtɨ bhalye?” ");
INSERT INTO mgq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pe uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, mʉlɨ na makaati galɨnga? Bhalaji mwenye.” We bhagaaga, bhakhamʉbhʉʉzya bhakhatɨ, “Tʉlɨ na makaati gasaanʉ ni nswi zɨbhɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pe uYeesu akhabhabhʉʉzya kʉtɨ, bhabhɨɨkhazye abhantʉ bhonti mʉ tʉpʉga mwɨ laala ibhisi. ");
INSERT INTO mgq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pe bhakhɨɨkhala mʉ tʉpʉga ʉtwa bhantʉ, bhamu imia yeeka (100), bhamu amashumi gasaanʉ. ");
INSERT INTO mgq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Akheega amakaati gaala gasaanʉ ni nswi zɨbhɨlɨ, akheenya kʉmwanya, akhavɨsaya. Akhamensulanyaaga amakaati gaala, akhabhapanga abhalandati bhaakwe bhabhagabhɨlaje abhantʉ. Iwinza akhabhagabhanya ni nswi ziila zyope zɨkhabhakwɨla abhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Abhantʉ bhonti bhakhalya, bhakhiikuta. ");
INSERT INTO mgq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abhalandati bhaakwe bhakhabhʉngaanya ɨvɨtʉndʉ ishumi na vɨbhɨlɨ ɨvwɨ nsenyenha ɨzya makaati ni nswi. ");
INSERT INTO mgq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bhe bháliiye ishaakulya shiila bháamɨle bhinji, abhasakhaala bheene bháamɨle ielufu zɨsaanʉ (5,000). ");
INSERT INTO mgq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nalʉbhɨlo, uYeesu akhabhabijila abhalandati bhaakwe kʉtɨ bhinjile mʉ shɨtʉʉlɨ, bhalongolele kʉbhala kwɨsyɨla ɨya sʉmbɨ ku Betisayida, we akʉyɨlaga ɨmpʉga ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","We alenhaana nabho, akhazʉbha wʉʉyo mwene mwɨ gamba kupuuta. ");
INSERT INTO mgq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","We kwavwelelema, ɨshɨtʉʉlɨ shikhafikha pakaasi pa sʉmbɨ, uYeesu áamɨle mwene kʉ nsɨ inyuumu kwɨsyɨla ilinji. ");
INSERT INTO mgq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","UYeesu akhabhalola abhalandati bhaakwe bhakulibha kʉshɨjenzya ɨshɨtʉʉlɨ shaabho kʉnongwa ye impepu yikhavugulaga kʉbhala ukunji. Kʉ masheelo, akhabhabhalɨla akʉjenda pamwanya pa minzi, akhanzaga kʉbhashɨla. ");
INSERT INTO mgq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ɨleelo we bhonti bhamʉlola akʉjenda pamwanya pa minzi bhakhatɨnjɨ muzimu, bhakhoogopa nhaani, bhakhakhoola kʉ lyoga. Pe uYeesu akhalonga nalʉbhɨlo nabho akhatɨ, “Yɨgomwaje ʉmwoyo, mʉtogopaje khaala, neene!” ");
INSERT INTO mgq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","We uYeesu ayinjila mʉ shɨtʉʉlɨ mwe bháamɨle, impepu yɨkhalekha kuvugula. Bhakhabha na khaswigo akhapɨtɨ nhaani, ");
INSERT INTO mgq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kʉnongwa ye amooyo gaabho gáamɨle magomu, bhatázyaganyiinye naazimo ɨzyɨ yele lya Yeesu ɨlya kʉpela amakaati gaala. ");
INSERT INTO mgq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","We uYeesu na bhalandati bhaakwe bhafumiila ʉsʉmbɨ ʉwa Galɨlaaya, bhakhafikha mʉmbalɨ yɨ nhaaya ɨya mu Genezaleeti, bhakhashɨmɨɨlɨkha ɨshɨtʉʉlɨ kukuula. ");
INSERT INTO mgq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","We bhaafuma bhʉʉlo mʉ shɨtʉʉlɨ, abhantʉ bhakhamʉmanya uYeesu nalʉbhɨlo bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pe bhakhashɨmbɨla kʉbhala kʉbhabhʉʉzya abhantʉ mʉ nsɨ yiila yonti. We abhantʉ bhɨmvwa, bhakhabhapɨmbaga abhabhinu mʉ vɨlɨlɨ kʉbhala kwokwonti kwe bhɨmvwa kʉtɨ uYeesu alɨ. ");
INSERT INTO mgq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Poponti paala pe akhabhalaga, mʉbhe mʉ tʉkhaaya, mʉ nhaaya awe mʉ nsɨ yiila mwomwonti, bhakhamʉletelaga abhabhinu. Bhakhamʉlambaga uYeesu kʉtɨ abhɨtɨshɨzye bhapalamansye mwi pindilwi ɨlya mwenda waakwe lyene. Pe abhabhinu bhonti bhe bhápalamansiizye, bháponile. ");
INSERT INTO mgq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Isiku limo, aBhafalisaayi na bhamanyizyi bhamu abhɨ ndajɨzyo, bhínzile kufuma ku Yelusaleemu, bhakhamʉbhʉngaanɨla uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakhaaga abhalandati bha Yeesu bhamu bhakulya ishaakulya sita kʉgeeza, anza she ɨndajɨzyo zɨkʉlonga. ");
INSERT INTO mgq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ABhafalisaayi na Bhayahuudi abhamwabho bhonti bhatakhalyanga sita kʉgeeza, kʉlandata she aminho ga bhamaama bhaabho gáamɨle. ");
INSERT INTO mgq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","We bhaafuma kʉ mʉnaalo, bhatakulya khaala, paka we bhageeza suuti she yɨkwanzɨwa. Iwinza bhakʉgalandata aminho gaabho agamwabho aminji agɨ maandɨ, anza kwozya ɨvɨkoopa, amasefulila, nɨ vɨlɨɨlo ɨvwɨ shaaba. ");
INSERT INTO mgq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pe aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Khooni khe abhalandati bhaakho bhatakʉlandata aminho aga bhamaama bhɨɨtʉ? Khooni khe bhakulya ishaakulya nɨ nyoobhe inhandamanu?” ");
INSERT INTO mgq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","UYeesu akhabhaamʉla akhatɨ, “Umukuwi ʉYeesaya áfumwizye uwukuwi ʉwa nalyoli kʉtɨ mʉbhantʉ ɨmwe mʉlɨ ni shisa ɨshɨ lenga, anza she ásimbile átɨlɨ, ‘Abhantʉ ɨbha bhakunshindikha ku mazwi meene, ɨleelo amooyo gaabho galɨ ukutali nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bhakumpuuta ʉlwa khasa. Zyope zye bhakʉmanyɨzya ndajɨzyo zye zikufumilana na minho ga bhantʉ.’” ");
INSERT INTO mgq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","UYeesu akhabhabhʉʉzya akhatɨ, “Ɨmwe mʉkʉzɨlekha ɨndajɨzyo zya Mʉlʉngʉ, mʉkʉgalandata aminho ga bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Khinza bhʉʉlo we mukuzisiita ɨndajɨzyo zya Mʉlʉngʉ, ɨnga mʉgalandataje aminho giinyu! ");
INSERT INTO mgq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yeenya, ʉMʉlʉngʉ álonjile kʉshɨlɨla kwa mukuwi ʉMoose átɨlɨ, ‘Umushindikhaje uyise waakho nu nyina waakho.’ Khabhɨlɨ átɨlɨ, ‘Wowonti we akumuliga uyise waakwe awe unyina waakwe, yɨkhondeeye agogwe.’ ");
INSERT INTO mgq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ɨleelo ɨmwe mʉkʉlonga kʉtɨ umuntu akwɨtɨshɨlwa kʉmʉbhʉʉzya uyise waakwe awe unyina waakwe kʉtɨ, ‘Ivintu vwe nhanɨ nakwavwa, ishi vwabha Kolobani,’ kwe kʉtɨ, ‘Ishi vwa Mʉlʉngʉ.’ ");
INSERT INTO mgq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kʉmanyɨzya shɨnɨɨsho mʉkʉmʉbhɨɨkha kʉtɨ atamwavwaje naakhamu uyise waakwe awe unyina waakwe. ");
INSERT INTO mgq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Shɨnɨɨsho she mʉkʉshoolanya izwi lya Mʉlʉngʉ kwɨ dala ɨlya kʉlandata aminho giinyu. Khabhɨlɨ mʉkʉbhomba inyinji bhʉʉlo zye zɨkʉkholana na zɨnɨɨzyo.” ");
INSERT INTO mgq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pe uYeesu akhayɨbhɨlɨshɨla winza ɨmpʉga ɨya bhantʉ, akhayɨbhʉʉzya akhatɨ, “Mʉbhantʉ ɨmwe mwenti mʉntejeelezye, khabhɨlɨ mʉzyaganye zye ɨnkʉlonga! ");
INSERT INTO mgq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khatalɨɨpo akhantʉ naakhamu khe khakufuma kunzi na kumwinjila umuntu, khangakhola kʉmʉleetela uwukhandamanu. Lyoli ziila zye zikufuma mwa muntu zye zɨkʉmʉleetela uwukhandamanu.  ");
INSERT INTO mgq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa.” ");
INSERT INTO mgq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","We ayɨlekha ɨmpʉga ya bhantʉ na kwinjila mu nyumba, abhalandati bhaakwe bhakhamʉbhʉʉzya kʉtɨ abhilulile ɨshɨkholanyo shiila akhinza. ");
INSERT INTO mgq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pe akhatɨ, “Ishi nɨɨmwe mʉtalɨ nɨ njeele ɨzya kʉshɨmanya ɨshɨkholanyo shiila? Mutamanyile kʉtɨ khokhonti khe khakwinjila mwa muntu kufuma kunzi khatangamʉleetela uwukhandamanu? ");
INSERT INTO mgq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ivwakulya vɨtakʉkhomaana nʉ mwoyo khaala, vɨkʉshɨzanya bhʉʉlo mʉ lwanda, kʉwʉmalɨlɨshɨlo vɨkʉtaagwa mʉ shɨkwɨlo.” We alonga shishiila, akhalolesya kʉtɨ ivwakulya vwonti vwitishiliilwe kulya. ");
INSERT INTO mgq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pe akhonjezya akhalonga akhatɨ, “Zye zikufuma mʉ mwoyo wa muntu zye zɨkʉmʉleetela umuntu uwukhandamanu. ");
INSERT INTO mgq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kʉnongwa ye mʉ mwoyo, mukufuma ɨnsɨɨbho imbiibhi, uwelengani, uwiibha, uwugoji, ");
INSERT INTO mgq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uwubhembu, ɨnsʉngʉkho imbiibhi, uwuyanzi, uwulyovi, uwubhiibhi, uwusyobhi, uwusalusu, ʉmwone, ɨnshoolanyo, amapʉlɨ, nʉ wʉlema. ");
INSERT INTO mgq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Imbiibhi zyonti zɨnɨɨzyo zikufuma mukaasi mʉ mwoyo wa muntu zye zɨkʉmʉleetela umuntu uwukhandamanu.” ");
INSERT INTO mgq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pe uYeesu na bhalandati bhaakwe bhakhasogola mʉ Galɨlaaya, bhakhabhala kʉ nhaaya ɨya mu Tiilo. Kukuula akhʉʉbha mu nyumba, kʉtɨ umuntu nʉʉmo atakhaamanye pe alɨ. Ɨleelo abhantʉ bhakhabha she bhamulolile. ");
INSERT INTO mgq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kukuula kwámɨle nʉ mwantanda ʉmo we ʉmwana waakwe ʉmʉlɨndʉ áamɨle ni pepu ibhiibhi. Ʉmwantanda ʉla áamɨle Muyunaani, áfumile ku Foinike mʉ mʉkoa ʉwa Siiliya. Áyimvwizye ɨmbombo zya Yeesu, pe akhɨnza, akhagwa pa vɨnama vwakwe. Akhamʉlaabha kʉtɨ amwefwe ʉmwana waakwe ipepu ibhiibhi. ");
INSERT INTO mgq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pe uYeesu akhamʉbhʉʉzya akhatɨ, “Isuuti abhaana bhiikute. Te khinza kwega ishaakulya sha bhaana na kʉzɨsʉmbɨla ɨmbwa.” ");
INSERT INTO mgq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɨleelo ʉmwantanda ʉla akhamwamʉla uYeesu akhatɨ, “Nalyoli Mwene, ɨleelo zyope ɨmbwa zye zɨlɨ paasɨ pa shintalati, zikulya ɨnsenyenha zya bhaana zye zɨkʉlenda paasɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","UYeesu akhamwamʉla akhatɨ, “Kʉnongwa ye wanaamʉla akhinza, sogolaga ipepu lyamwepa ʉmwana waakho.” ");
INSERT INTO mgq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","We ʉmwantanda ʉla agalʉkha kʉkhaaya, akhaaga ʉmwana waakwe aponile, alambalaaye pa shɨtala, mwinza bhʉʉlo, ipepu limwepile. ");
INSERT INTO mgq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pe uYeesu akhasogola na bhalandati bhaakwe mʉ wɨlaaya ɨya ku Tiilo, akhashɨlɨla ku Sidooni, akhagalʉkha kwa sʉmbɨ ʉwa kʉ Galɨlaaya, kʉ nsɨ ɨya ku Dekapooli. ");
INSERT INTO mgq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Abhantʉ bhamu bhakhamʉleetela uYeesu umuntu we áamɨle wu shinuunu we atakwɨmvwa. Bhakhamʉlaabha uYeesu kʉtɨ amʉbhɨɨshe ɨnyoobhe, apone. ");
INSERT INTO mgq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","UYeesu akhamwefwa pa mpʉga ya bhantʉ, akhabhala nawo pambalɨ mwene, akhabhɨɨkha ʉtʉsamba twakwe mu makutwe ga muntu ʉla, akhaswɨla amatɨ gaakwe, akhamʉpakha pa lumili. ");
INSERT INTO mgq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akheenya kʉmwanya, akhiishizya ʉmwoyo, akhamʉbhʉʉzya akhatɨ, “Efaata!” Kwe kʉtɨ, “Yiigulwa!” ");
INSERT INTO mgq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Panaapo bhʉʉlo, umuntu ʉla akhiigukha amakutwe, akhanda kʉlonga na kwɨmvwa akhinza bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","UYeesu akhayɨsokha ɨmpʉga ya bhantʉ kʉtɨ bhatakhamʉbhʉʉzye umuntu nʉʉmo. Ɨleelo she akhajinaga kʉbhakhaana, pe bhakhonjezyaga nhaani kʉlonga zyenezyo poponti. ");
INSERT INTO mgq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhakhabha na khaswigo akhapɨtɨ nhaani. Bhakhanda kʉlonga kʉtɨ, “Zyonti zye akʉbhomba, nyinza. Akʉbhaponɨa na bhantʉ bhe bhatakwɨmvwa na bhashinuunu bhʉʉlo!” ");
INSERT INTO mgq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mʉ khabhalɨlo khanaakho, ɨmpʉga ɨmpɨtɨ ɨyamwabho ɨya bhantʉ abhinji yɨkhabhʉngaana winza, bhoope bhatáamɨle ni shaakulya, shásilile. Pe uYeesu akhabhabhɨlɨshɨla abhalandati bhaakwe akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ɨnkʉbhalolela ishisa abhantʉ ɨbha kʉnongwa ye nɨɨkhala nabho insiku zɨtatʉ, ɨleelo bhatalɨ ni shaakulya. ");
INSERT INTO mgq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ɨnga natɨ ɨmbalaje bhasogole kʉkwabho we bhalɨ nɨ nzala, bhatizilishe mwɨ dala, khabhɨlɨ bhamu bhafumile ukutali.” ");
INSERT INTO mgq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abhalandati bhaakwe bhakhamwamʉla bhakhatɨ, “Ɨpa tʉlɨ pa shilozu, tʉtɨgaaje kwoshi amakaati aga kʉbhakwɨla abhantʉ bhonti bhanaabha?” ");
INSERT INTO mgq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉlɨ na makaati galɨnga?” Bhakhamwamʉla bhakhatɨ, “Tʉlɨ na makaati saba.” ");
INSERT INTO mgq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","UYeesu akhabhalajɨzya abhantʉ bhonti kʉtɨ bhɨɨkhale paasɨ. Akheega amakaati gaala saba, akhamusalifwa ʉMʉlʉngʉ, akhamensulanya. Akhabhapanga abhalandati bhaakwe, bhoope bhakhabhagabhɨlaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Khabhɨlɨ bháamɨle ni nswi nyishe bhʉʉlo. Zyope akhazɨsaya, akhalajɨzya kʉtɨ bhaabhape abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abhantʉ bhakhalya, bhakhiikuta. Abhalandati bhakhabhʉngaanya ɨnsenyenha zye zyásyalile, zikhiizula ɨvɨtʉndʉ saba. ");
INSERT INTO mgq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Abhantʉ bhe bháliiye ishaakulya bháfishile ielufu zini (4,000). UYeesu akhabhalaga abhantʉ bhaala kʉtɨ bhasogolaje, bhagalʉkhaje kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Akhinjila na bhalandati bhaakwe mʉ shɨtʉʉlɨ nalʉbhɨlo bhʉʉlo, bhakhabhala kʉ wɨlaaya ɨya mu Dalamanuuta. ");
INSERT INTO mgq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","We bhaafikha, aBhafalisaayi bhakhɨnza, bhakhanda kʉbhʉzɨlɨzanya nu Yeesu kʉtɨ bhamʉlɨnje, bhakhanza kʉtɨ abhalolesye ɨshɨlolesyo she shɨkʉmanyɨsya kʉtɨ afumile kʉmwanya kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","UYeesu akhaswɨmɨɨlɨla mʉ mwoyo. Akhalonga akhatɨ, “Khooni khe mʉbhantʉ abha shipaafi ishi mʉkwanza kʉlola ɨshɨlolesyo? Nalyoli ɨnkʉbhabhʉʉzya, ɨne ɨntakʉʉbhapa ɨshɨlolesyo naashimo abhantʉ abha shipaafi ishi.” ");
INSERT INTO mgq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akhabhalekha, akhinjila winza mʉ shɨtʉʉlɨ. Akhanda kʉshʉʉla, kufumiila kwɨsyɨla ilinji ɨlya sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abhalandati bhaakwe bhíwiilwe kʉpaya amakaati. Bháamɨle ni kaati lyeka lyene mʉ shɨtʉʉlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","UYeesu akhabhasokha akhatɨ, “Mwenyaaje nhaani na kʉbha amiiso nu wusafu wa Bhafalisaayi nʉ wa Heloodi.” ");
INSERT INTO mgq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abhalandati bhaakwe bhakhanda kʉzaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Akʉlonga shɨnɨɨsho kʉnongwa ye tutapayile amakaati.” ");
INSERT INTO mgq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","UYeesu ámanyile zye bhakʉzaabhana, akhabhabhʉʉzya akhatɨ, “Khooni khe mʉkʉzaabhana kʉtɨ mʉtalɨ na makaati? Kwe kʉtɨ niishi bhʉʉlo mʉtakʉzyaganya na kʉzɨmanya naazimo? Mooyo giinyu magomu kʉzɨmanya zye ɨnkʉlonga? ");
INSERT INTO mgq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kwe kʉtɨ ɨmwe mʉlɨ na miiso, ɨleelo mʉtakʉlola khaala? Goope amakutwe mʉlɨ nago, ɨleelo mʉtakwɨmvwa khaala? Bhʉlɨ, mʉtakʉkʉmbʉkha ngakheeka? ");
INSERT INTO mgq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Akhabhalɨlo khaala khe inhamensulanyaaga amakaati gasaanʉ gaala na kʉʉbhapa abhantʉ ielufu zɨsaanʉ (5,000), mwábhunganyiinye ɨnsenyenha ɨvɨtʉndʉ vɨlɨnga?” Bhakhamwamʉla bhakhatɨ, “Twábhunganyiinye ɨvɨtʉndʉ ishumi na vɨbhɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“We inhamensulanyaaga amakaati saba na kʉʉbhapa abhantʉ ielufu zini (4,000), mwábhunganyiinye ɨnsenyenha ɨvɨtʉndʉ vɨlɨnga?” Bhakhamwamʉla bhakhatɨ, “Ɨvɨtʉndʉ saba.” ");
INSERT INTO mgq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pe akhabhabhʉʉzya akhatɨ, “Niishi bhʉʉlo mʉlɨ she mʉtakʉzyaganya khaala?” ");
INSERT INTO mgq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","UYeesu na bhalandati bhaakwe bhakhafikha ku Betisayida. Abhantʉ bhamu bhakhamʉtwala kwa Yeesu umuntu we áfuuye amiiso. Bhakhamʉlaabha uYeesu kʉtɨ amʉpalamansye na kʉmʉponɨa. ");
INSERT INTO mgq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","UYeesu akhamʉlema ɨnyoobhe umuntu ʉla we áfuuye amiiso, akhabhala nawo kunzi yɨ nhaaya yiila. Akhamʉswɨla amatɨ mu miiso, akhamʉbhɨɨkha ɨnyoobhe mu miiso, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, wanda kʉlola khamu?” ");
INSERT INTO mgq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Umuntu ʉla akheenya, akhalonga akhatɨ, “Ɨnkʉbhalola abhantʉ, ɨleelo bhakʉlolekha ngatɨ makwi gakʉjenda.” ");
INSERT INTO mgq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","UYeesu akhamʉbhɨɨkha winza ɨnyoobhe mu miiso, umuntu ʉla akhasimishizya kwenya, akhapona. Akhanda kʉlola ivintu vwonti akhinza bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","UYeesu akhamʉbhʉʉzya akhatɨ, “Bhalaga kʉkhaaya, ʉjendele kunuuku, ʉtakhagalʉshe winza ku Betisayida.” ");
INSERT INTO mgq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","UYeesu na bhalandati bhaakwe bhakhasogola ku Betisayida, bhakhabhala mʉ tʉkhaaya ʉtwa papɨɨpɨ ni Kaisaliya Filiipi. We bhakʉjenda mwɨ dala, uYeesu akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Ishi abhantʉ bhakʉtɨ ɨne ne naanu?” ");
INSERT INTO mgq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakhamwamʉla bhakhatɨ, “Bhamu bhakʉtɨ we Yookhani uMwozyi, bhamu bhakʉtɨ we Eliya, bhamu bhakʉtɨ we mukuwi ʉmo mu bhakuwi abhɨ maandɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Akhabhabhʉzɨɨlɨzya akhatɨ, “Nɨɨmwe, mʉkʉtɨ ɨne ne naanu?” UPeeteli akhamwamʉla akhatɨ, “Ɨwe we Kilisiti.” ");
INSERT INTO mgq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","UYeesu akhabhasokha kʉtɨ bhatakhamʉbhʉʉzye umuntu wowonti ʉla kʉtɨ ʉweene wu naanu. ");
INSERT INTO mgq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pe uYeesu akhanda kʉbhamanyɨzya abhalandati bhaakwe kʉtɨ, “ɄMwana wa Muntu yɨkwanzɨwa kʉtɨ ayɨmbe amayɨmba amapɨtɨ, akhaanwe na bhasongo abha Bhayahuudi, abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo. Akhayɨgogwa, ɨleelo akhayɨzyʉkha isiku ɨlya wʉtatʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","UYeesu ábhabhuziizye abhalandati bhaakwe ɨnongwa zɨnɨɨzyo apazelu. UPeeteli akhabhala nawo pambalɨ, akhanda kʉmʉkhajɨla. ");
INSERT INTO mgq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","UYeesu akhagalʉnhana, akhabheenya abhalandati bhaakwe. Akhamʉkhajɨla uPeeteli akhatɨ, “Yeepa kwɨlongolela kʉkwanɨ Seetani, ʉkʉsɨɨbha zye te zya Mʉlʉngʉ, lyoli ʉkʉsɨɨbha ɨzya bhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akhayɨbhɨlɨshɨla ɨmpʉga ya bhantʉ peeka na bhalandati bhaakwe kʉtɨ, bhɨnze kʉkwakwe. Akhabhabhʉʉzya akhatɨ, “Umuntu wowonti we akwanza kʉndandata ɨne, akwanzɨwa ayɨkhaane wʉʉyo, apɨmbe ɨshɨkhobhenhanyo shaakwe, andandate ɨne. ");
INSERT INTO mgq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Umuntu we akwanza kʉwʉpokha uwuumi waakwe wʉʉyo, akhayɨwʉteezya. Ɨleelo ʉla we akuwufumwa uwuumi waakwe kʉnongwa yaanɨ, na kʉnongwa yi Ntumi iNyinza, akhayɨwʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kwe kʉtɨ umuntu angakabha akhooni ɨnga aapata vwonti ɨvwa mʉ nsɨ, ɨleelo ateezya uwuumi waakwe? ");
INSERT INTO mgq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awe umuntu angafumwa khantʉ bhʉlɨ kʉtɨ khapwanɨle pa wuumi waakwe? ");
INSERT INTO mgq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Umuntu wowonti we akʉndolela insoni pa bhantʉ ɨne nɨ manyɨzyo zyanɨ, mʉ khabhalɨlo ɨkha khe abhantʉ bhakʉbhomba imbiibhi na bhe bhatakʉmʉsaajɨla ʉMʉlʉngʉ, woope ʉMwana wa Muntu we akwikha na bhakhabhɨzya abhafinjile mu wumwamu wa Taata waakwe, akhayɨmʉlolela insoni umuntu wʉnʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","UYeesu akhajendeelela kʉbhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya ɨnkʉtɨ, panaapa bhalɨɨpo abhantʉ bhe bhakhayɨlola kwɨnza kʉ wʉmwene wa Mʉlʉngʉ kʉ makha we bhashɨɨlɨ kufwa.” ");
INSERT INTO mgq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","We zyashɨla insiku ʉmʉtanda, uYeesu akhabheega uPeeteli, ʉYaakobo nu Yookhani. Akhazʉbha nabho mwɨ gamba itali, kwe kʉtalɨ na bhantʉ. Pe we bhalɨ kuula, uYeesu akhagalʉnhana pamiiso pɨlongolela yaabho. ");
INSERT INTO mgq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amenda gaakwe gakhanda kʉlama nhaani. Gakhabha mazelu kʉshɨla she ʉmʉkhanda menda wowonti ʉla ʉwa mʉ nsɨ umu she angagazelufwa. ");
INSERT INTO mgq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bhakhafumila uEliya nʉ Moose, bhakhalongaga nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","UPeeteli akhamʉbhʉʉzya uYeesu akhatɨ, “We Mumanyizyi, khinza kʉtɨ ɨtwe twɨkhalaje ɨpa! Ɨnga ʉkwanza, ɨntɨzenje ivwegwi vɨtatʉ: sheeka shɨbhe shaakho, shimo shɨbhe sha Moose, nɨ shamwabho shɨbhe sha Eliya.” ");
INSERT INTO mgq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Atakhamanya nɨ lya kʉlonga naalimo kʉnongwa ye ʉweene na bhamwabho bhógopile nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pe ɨbhɨngo likhafumila, likhabhagubishila. Bhakhɨmvwa izi kufuma mwɨ bhɨngo lɨkʉtɨ, “Ʉnʉ we Mwana waanɨ ʉmʉganwa, mʉmwɨmvwaje ʉweene!” ");
INSERT INTO mgq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Panaapo bhʉʉlo abhalandati bhaala bhakheenya uku nʉʉkwo, bhatakhamʉlola umuntu ʉwamwabho nʉʉmo, lyoli uYeesu mwene we áamɨle peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","We bhakwikha mwɨ gamba, uYeesu akhabhakhaana kʉtɨ, bhatakhamʉbhʉʉzye umuntu wowonti zyonti zye bhazɨlola mwɨ gamba muula, kufishila akhabhalɨlo khe ʉMwana wa Muntu akhayɨzyʉkha kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abhalandati bhaala bhakhalɨlema izwi liila. Ɨleelo bhakhabha she bhakʉbhʉzɨlɨzanya bhɨɨbho na bhɨɨbho kʉtɨ, “Kʉzyʉkha kufuma kʉ bhafwe kwe kʉtɨ bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Ishi khooni khe abhamanyizyi abhɨ ndajɨzyo bhakʉtɨ, yɨkwanzɨwa kʉtɨ uEliya ayɨnze suuti?” ");
INSERT INTO mgq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Woope akhabhaamʉla akhatɨ, “Nalyoli uEliya akwɨnza suuti kʉlɨngaanya zyonti. Ɨleelo khooni khe yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ʉMwana wa Muntu akhayɨyɨmba amayɨmba aminji na kʉshoolanywa? ");
INSERT INTO mgq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ishi ɨnkʉbhabhʉʉzya kʉtɨ, uEliya ayinzile, woope bhakhamʉbhombela zyonti zye bhakhanzaga, anza she ásimbiliilwe mu Wusimbe uWufinjile.” ");
INSERT INTO mgq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","We bhaafikha ku bhalandati abhamwabho bhe bhásyalile, bhakhayɨlola ɨmpʉga ɨmpɨtɨ ɨya bhantʉ ye yɨbhabhʉnganɨɨye. Abhamanyizyi abhɨ ndajɨzyo bhamu bhakhadalɨnhanaga na bhalandati. ");
INSERT INTO mgq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nalʉbhɨlo bhʉʉlo we ɨmpʉga ya bhantʉ bhonti bhamʉlola uYeesu, bhakhaswiga nhaani. Bhakhamʉshɨmbɨɨlɨla, bhakhabhala bhakhamʉlamʉkha. ");
INSERT INTO mgq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkʉdalɨnhana nabho zyoni?” ");
INSERT INTO mgq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Umuntu ʉmo mʉ mpʉga yiila akhamwamʉla akhatɨ, “Mumanyizyi, imuleetile ʉmʉvʉlɨ waanɨ kʉkwakho, alɨ ni pepu ibhiibhi lye lɨkʉmʉbhɨɨkha kʉbha wu shinuunu. ");
INSERT INTO mgq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wiila bhʉʉlo likumuzilisya, likumugwisya paasɨ, akwanda kufumwa ʉmʉtatafʉla kwi lomu, kuzyekusya amiino na kwʉmangana ʉmʉbhɨlɨ wonti. Naabhalaabhile abhalandati bhaakho kʉtɨ bhalɨbhɨnje ipepu nyeene, ɨleelo bhaapotiilwe kʉlyefwa.” ");
INSERT INTO mgq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","UYeesu akhaamʉla akhatɨ, “Ɨmwe mushipaafi she shɨtakwɨtɨkha, she shiteejile. Ɨntɨyɨɨkhale nɨɨmwe kufishila liino? Imbajimbiilile paka liino? Mʉleete kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhakhamʉtwala ʉmwana ʉla kwa Yeesu. We ipepu liila lyamʉlola uYeesu, panaapo bhʉʉlo likhamuzilisya ʉmwana ʉla. Akhagwa paasɨ, akhagalagaata na kufumwa ʉmʉtatafʉla kwi lomu. ");
INSERT INTO mgq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","UYeesu akhamʉbhʉzɨɨlɨzya uyise wa mwana ʉla akhatɨ, “Amayɨmba ganaaga gamwandile ʉmwana kufuma liino?” Uyise akhatɨ, “Kufuma kʉ waana waakwe. ");
INSERT INTO mgq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wiila bhʉʉlo ipepu liniili likumugwisya mʉ mwoto, awe mu minzi kʉtɨ lɨmʉgoje. Ɨleelo ɨnga ʉlɨ na makha aga kʉbhomba limo, tʉlolele ishisa, ʉtwavwe.” ");
INSERT INTO mgq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","UYeesu akhamʉbhʉʉzya akhatɨ, “Avwa bhaatɨ, ɨnga ʉlɨ na makha! Zyonti zɨkʉbhombekha kwa muntu we akwɨtɨkha kʉmʉsʉʉbhɨla ʉMʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nalʉbhɨlo bhʉʉlo uyise wa mwana ʉla akhakhoola kwi zi ɨlya kʉdandɨzya akhatɨ, “Ɨnkwɨtɨkha kʉmʉsʉʉbhɨla ʉMʉlʉngʉ! Ɨleelo ʉlwɨtɨkho lwanɨ lʉtakwɨlɨɨye, naavwe.” ");
INSERT INTO mgq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","UYeesu we aalola kʉtɨ ɨmpʉga ya bhantʉ yɨkwonjela kʉshɨmbɨɨlɨla kʉbhala kʉmʉbhʉnganɨla, akhalɨkhajɨla ipepu ibhiibhi liila. Akhalɨbhʉʉzya akhatɨ, “Wulipepu ɨwe, we ʉkʉmʉbhɨɨkha ʉmwana ʉnʉ kʉbha wu shinuunu na kʉtɨ atɨmvwaje amakutwe khaala, ɨnkʉkʉlajɨzya ɨnkʉtɨ, fuma mwa mwana ʉnʉ, khabhɨlɨ ʉtakhasheele kumwinjila winza.” ");
INSERT INTO mgq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pe ipepu liila lɨkhakhoola kwi zi ɨlya kʉdandɨzya, likhamugwisya ʉmwana ʉla na kʉmʉgalagasya akhabhiibhi, lɨkhamwepa. Ʉmwana ʉla akhabha ngatɨ mufwe, abhinji papaala bhakhatɨ, “Afuuye!” ");
INSERT INTO mgq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ɨleelo uYeesu akhamʉlema ɨnyoobhe ʉmwana ʉla, akhamʉbhʉʉsya, woope akhɨmɨɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","We uYeesu ayinjila mu nyumba, abhalandati bhaakwe bhakhamʉbhʉzɨɨlɨzya kukwilu bhakhatɨ, “Khooni khe ɨtwe twaapotiilwe kʉlyefwa ipepu lɨnɨɨlyo?” ");
INSERT INTO mgq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","UYeesu akhabhabhʉʉzya akhatɨ, “Ipepu ɨlya shɨkholo shɨnɨɨsho litangafuma bhʉʉlo khaala, lyoli ku mpuuto nyeene.” ");
INSERT INTO mgq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","UYeesu na bhalandati bhaakwe bhakhasogola kwenekwo, bhakhanda kʉjenda, bhakhashɨla pakaasi mʉ mʉkoa ʉwa Galɨlaaya. UYeesu atáyiganile kʉtɨ abhantʉ bhamanye pe áamɨle, ");
INSERT INTO mgq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kʉnongwa ye akhabhamanyɨzyaga abhalandati bhaakwe. Ábhabhuziizye átɨlɨ, “ɄMwana wa Muntu atɨlonjeelelwe na kʉtwalwa kʉ bhantʉ bhe bhatɨmʉgoje. Ɨleelo we bhamʉgoga, pi siku ɨlya wʉtatʉ, akhayɨzyʉkha.” ");
INSERT INTO mgq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ɨleelo abheene bhatakhazyaganyaaga zye uYeesu akhalongaga, bhakhoogopa kʉmʉbhʉzɨɨlɨzya. ");
INSERT INTO mgq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bhakhafikha mu Kapelenaumu, we bhinjila mu nyumba, uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mwadalɨnhanaga nongwa zyoni mwɨ dala?” ");
INSERT INTO mgq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɨleelo abhalandati bhaakwe bhakhapʉʉma bhʉʉlo, kʉnongwa ye mwɨ dala bhakhadalɨnhanaga bhɨɨbho na bhɨɨbho kʉtɨ, ʉmʉpɨtɨ kʉshɨla abhamwabho bhonti wu naanu. ");
INSERT INTO mgq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","UYeesu akhɨɨkhala paasɨ, akhabhabhɨlɨshɨla abhalandati bhaakwe ishumi na bhabhɨlɨ. Akhabhabhʉʉzya akhatɨ, “Umuntu wowonti we akwanza kʉbha mʉpɨtɨ wa bhonti, yɨkʉtɨ ayiisye paasɨ, abhe mubhombi wa bhonti.” ");
INSERT INTO mgq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akhamwega ʉmwana umunsi, akhamwɨmɨɨlɨsya pakaasi yaabho. Akhamʉpakhatɨla, akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Umuntu wowonti we akʉmʉposheela ʉmwana umunsi weeka anza wʉnʉʉnʉ kwɨ taawa lyanɨ, akʉmposheela neene. Khabhɨlɨ umuntu we akʉmposheela ɨne, atakʉmposheela neene nʉmwene khaala, lyoli akʉmposheela nʉ Taata we ansonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","UYookhani akhamʉbhʉʉzya uYeesu akhatɨ, “Mumanyizyi, twaamulolile umuntu ʉmo akʉbhɨnga amapepu amabhiibhi kwɨ taawa lyakho, twaamukhaanile, kʉnongwa ye atalɨ peeka nɨɨtwe.” ");
INSERT INTO mgq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ɨleelo uYeesu akhaamʉla akhatɨ, “Mʉtamʉkhaanaje khaala umuntu anza wʉnʉʉyo. Atalɨɨpo umuntu we akʉbhomba amayele kwɨ taawa lyanɨ, kumo winza pɨlongolela, ayande kʉndonga akhabhiibhi ɨne. ");
INSERT INTO mgq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Umuntu we atakʉtʉkhaana, alɨ peeka nɨɨtwe. ");
INSERT INTO mgq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Poope umuntu wowonti ʉla we aabhapa aminzi aga kʉmwela mʉ shɨkoopa kʉnongwa ye ɨmwe mwe bhantʉ bha Kilisiti, nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, akhayɨposheela ɨnsamaalɨzyo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ɨleelo umuntu wowonti we akʉmʉpʉvwa weeka mu bhansi ɨbha bhe bhakʉnɨɨtɨkha kʉtɨ abhombe imbiibhi, yaamɨle kwashi kʉkʉnjɨɨlwa iwe ɨpɨtɨ ɨlya kʉsyela mu nsingo na kʉsʉmbwa mwa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɨnga ɨnyoobhe yaakho yɨkʉkʉpʉvwa kʉbhomba imbiibhi, yidumule. Kwashi kwinjila mu wuumi ʉwa wiila sita kʉbha nɨ nyoobhe zyonti zɨbhɨlɨ, na kʉtɨ ʉbhe nɨ nyoobhe zɨbhɨlɨ, ɨleelo ʉsʉmbwe mʉ mwoto we wutakuzima naalumo.  ");
INSERT INTO mgq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kʉnʉʉkwo imvinyu zyakwe zitakufwa nʉ mwoto waakwe wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Khabhɨlɨ ɨnga ɨshɨnama shaakho shakʉpʉvwa, shidumule. Kwashi kwinjila mu wuumi ʉwa wiila sita kʉbha nɨ vɨnama vwonti vɨbhɨlɨ, na kʉtɨ ʉbhe nɨ vɨnama vɨbhɨlɨ, ɨleelo ʉsʉmbwe mʉ mwoto we wutakuzima naalumo.  ");
INSERT INTO mgq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kʉnʉʉkwo imvinyu zyakwe zitakufwa nʉ mwoto waakwe wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɨnga ilyiso lyakho lɨkʉkʉpʉvwa kʉbhomba imbiibhi, lifigule na kʉlɨtaaga. Kwashi kwinjila mʉ wʉmwene wa Mʉlʉngʉ we ʉlɨ ni lyiso lyeka bhʉʉlo, na kʉtɨ ʉbhe na miiso gonti gabhɨlɨ, ɨleelo ʉsʉmbwe mʉ mwoto we wutakuzima naalumo. ");
INSERT INTO mgq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kʉnʉʉkwo imvinyu zyakwe zitakufwa nʉ mwoto waakwe wutakuzima. ");
INSERT INTO mgq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Amagomu gakumuzelufwa umuntu wowonti mukaasi anzʉ mwoto kʉtɨ abhe nɨ njendo inyinza. ");
INSERT INTO mgq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ɨbheeya khantʉ khinza, ɨleelo ɨnga lyateezya uwunonu, lɨngalʉngwa khantʉ khooni akha kʉlɨbhɨɨkha kʉtɨ lyande kʉkhola winza? Nɨɨmwe mʉbhe anzɨ bheeya lye lɨkʉkhola, mʉbhanje mu wutengaanu mʉneemwe na mʉneemwe.” ");
INSERT INTO mgq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pe uYeesu akhasogola ku Kapelenaumu, akhabhala mʉ nsɨ ɨya Yudeeya, kwɨsyɨla ɨya lwizi ʉlwa Yoolodani. Ɨmpʉga zya bhantʉ zɨkhamʉbhʉnganɨlaga winza. Akhabhamanyɨzyaga anza she álʉbhɨɨye kʉkhonzya wiila. ");
INSERT INTO mgq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ABhafalisaayi bhamu bhakhɨnza kwa Yeesu kʉmʉlɨnga. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, yɨkwɨtɨshɨlwa mʉ ndajɨzyo ʉmʉsakhaala kuumupa ɨkalaata ʉmʉshɨ waakwe?” ");
INSERT INTO mgq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","UYeesu akhabhaamʉla akhatɨ, “Ɨmwe ʉMoose ábhapiiye ndajɨzyo zyoni kʉ bhantʉ bhe bhegiine?” ");
INSERT INTO mgq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhakhamwamʉla bhakhatɨ, “ɄMoose áyitishiziizye kʉtɨ ʉmʉsakhaala amusimbilaje ʉmʉshɨ waakwe ɨkalaata ɨlya kʉmʉlekha.” ");
INSERT INTO mgq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pe uYeesu akhabhabhʉʉzya akhatɨ, “ɄMoose ábhasimbiiye ɨndajɨzyo yɨnɨɨyo kʉnongwa ɨya wugomu ʉwa mooyo giinyu. ");
INSERT INTO mgq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ɨleelo kufuma kʉwandɨlo ʉwa kʉpelwa ɨnsɨ ʉMʉlʉngʉ ‘ápelile ʉmʉsakhaala nʉ mwantanda.’ ");
INSERT INTO mgq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kʉnongwa yɨnɨɨyo, ʉmʉsakhaala akhayɨmʉlekha uyise waakwe nu nyina waakwe, akhayɨpatɨnhana nʉ mʉshɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bhabhɨlɨ bhanaabho bhakhayɨbha mʉbhɨlɨ weeka.’ Pe bhanaabha te bhabhɨlɨ winza, lyoli bhakʉbha mʉbhɨlɨ weeka. ");
INSERT INTO mgq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bhe ʉMʉlʉngʉ abhakhomanyiinye, umuntu wowonti atakhabhalenhaanye.” ");
INSERT INTO mgq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","We bhinjila winza mu nyumba, abhalandati bhaakwe bhakhamʉbhʉzɨɨlɨzya akhinza ɨnongwa ɨzya kʉpeelana ɨkalaata. ");
INSERT INTO mgq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","UYeesu akhabhaamʉla akhatɨ, “Umuntu wowonti we akʉmʉtabhʉla ʉmʉshɨ waakwe, ɨnga ayeega ʉmwantanda uwunji, akʉbhomba wubhembu kwa mʉshɨ ʉmʉtala. ");
INSERT INTO mgq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Woope ʉmwantanda we akʉmʉlekha ʉmʉlʉme waakwe na kwegwa nʉ mʉsakhaala uwunji, akʉmʉbhombela wubhembu ʉmʉlʉme ʉmʉtala.” ");
INSERT INTO mgq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Abhantʉ bhakhamʉletelaga uYeesu abhaana abhansi kʉtɨ abhabhɨɨshe ɨnyoobhe yaakwe abhasaye. Ɨleelo abhalandati bhaakwe bhakhabhakhajɨla bhe bhakhabhaleetaga abhaana bhaala. ");
INSERT INTO mgq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","UYeesu we aalola bhabhomba shɨnɨɨsho, akhiilamwa. Akhabhabhʉʉzya akhatɨ, “Bhaleshe abhaana abhansi ɨbho bhɨnze kʉkwanɨ, lashi mutabhadindaje! Kʉnongwa ye ʉwʉmwene wa Mʉlʉngʉ wa bhantʉ bhe bhalɨ anza bhaana ɨbha. ");
INSERT INTO mgq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we atakʉwʉposheela ʉwʉmwene wa Mʉlʉngʉ anzʉ mwana umunsi, atangakhola kwinjila mʉ wʉmwene wʉnʉʉwo.” ");
INSERT INTO mgq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pe akhabhatambɨla abhaana bhaala, akhabhɨɨkha ɨnyoobhe zyakwe pamwanya yaabho, akhabhasaya. ");
INSERT INTO mgq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","UYeesu akhanda kʉsogola, we aafikha pɨ dala, umuntu ʉmo akhɨnza akʉshɨmbɨla, akhasʉgamɨla paasɨ. Akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “We Mumanyizyi uMwinza, ɨmbombe lyoni ilyinza ɨnga ɨnhawaaje uwuumi ʉwa wiila?” ");
INSERT INTO mgq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","UYeesu akhamwamʉla akhatɨ, “Khooni khe ʉkʉmbʉʉzya kʉtɨ ne mwinza? Atalɨɨpo we mwinza, lyoli ʉMʉlʉngʉ mwene. ");
INSERT INTO mgq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bhʉlɨ, uzimanyile ɨndajɨzyo zye zɨkʉtɨ, ‘Ʉtakhaagoje, utakhabhembushe, utakhiibhe, utakhaafumwe uwukeeti ʉwɨ lenga, ʉtabhanje we mukhopeli, umushindikhaje uyise waakho nu nyina waakho.’” ");
INSERT INTO mgq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Umuntu ʉla akhamwamʉla akhatɨ, “Mumanyizyi, ɨndajɨzyo zyonti zɨnɨɨzyo inzilemile kufuma kʉ waana waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","UYeesu akhamwenya, akhamʉgana, akhamʉbhʉʉzya akhatɨ, “Kʉlɨ na khantʉ kheeka khe ubhuliliilwe nakho. Bhalaga ʉkazye ivintu vwonti vwe ʉlɨ navwo, ɨnhela zye waapata, ʉbhagabhɨle abhapɨɨna. Ɨnga wabhomba shɨnɨɨsho, ʉtɨbhe ʉyɨbhɨshɨɨye ɨshʉʉma kʉmwanya. Pe ʉyɨnze, ʉndandate.” ");
INSERT INTO mgq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɨleelo umuntu ʉla we ayɨmvwa shɨnɨɨsho, akhazyʉgʉkhana pamiiso. Akhasogola paala ku wuswimiilizu kʉnongwa ye áamɨle nɨ shʉʉma ishinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","UYeesu akhatelenganya uku nʉʉkwo, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Yeenyi she yɨkhayɨbha papala kwa dumbwe kwinjila mʉ wʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abhalandati bhaakwe bhakhagaswiga amazwi ge uYeesu akhalonga. UYeesu akhabhabhʉʉzya winza akhatɨ, “Bhaana bhaanɨ, yeenyi she kʉlɨ ʉwʉpala kwinjila mʉ wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Papupuusu ɨngamɨla kwinjila mu khaazi akha lusindaani, na kʉtɨ udumbwe ayinjile mʉ wʉmwene wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abhalandati bhaakwe bhakhaswiga nhaani kwi zwi lɨnɨɨlyo. Bhakhalonjezanya bhɨɨbho na bhɨɨbho bhakhatɨ, “Ishi, ɨnga she zɨlɨ shɨnɨɨsho, wu naanu we angawaaga uwuposhi?” ");
INSERT INTO mgq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","UYeesu akhabheenya, akhabhabhʉʉzya akhatɨ, “Kʉ bhantʉ lɨnɨɨlyo lɨtangabhombekha, ɨleelo kwa Mʉlʉngʉ zɨtalɨ anza shɨnɨɨsho, kʉnongwa ye kwa Mʉlʉngʉ zyonti zɨkʉbhombekha.” ");
INSERT INTO mgq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","UPeeteli akhanda kʉmʉbhʉʉzya uYeesu akhatɨ, “Yeenya, ɨtwe tuvileshile ivintu vwonti, tukulandatile ɨwe!” ");
INSERT INTO mgq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pe uYeesu akhalonga akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya ɨnkʉtɨ, umuntu we ayileshile inyumba, abhakhambakʉ, awe abhayɨlʉmbʉ, awe unyina, awe uyise, awe abhaana, awe ivwizi, kʉnongwa yaanɨ, na kʉnongwa yi Ntumi iNyinza, ");
INSERT INTO mgq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","akhayɨposheela ivwinji kʉshɨla vɨnɨɨvwo: inyumba, abhakhambakʉ, abhayɨlʉmbʉ, unyina, abhaana ni vwizi. Peeka na vɨnɨɨvwo vwonti, akhayɨbha na mayɨmba. Iwinza mʉ khabhalɨlo khe khakwɨnza akhayɨposheela uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɨleelo abhinji bhe bhakʉyɨlola kʉtɨ bhakhondeeye mʉ khabhalɨlo ɨkha, bhakhayɨbha kʉlʉsalo mʉ khabhalɨlo khe khakwɨnza, khabhɨlɨ bhe bhakʉyɨlola kʉtɨ bhatakhondeeye mʉ nsɨ, bhakhayɨbha bha mwɨlongolela.” ");
INSERT INTO mgq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","We bhalɨ mwɨ dala kʉbhala ku Yelusaleemu, uYeesu ábhalongoleeye mwɨlongolela yaabho. Abhalandati bhaakwe bhátuuyile, na bhantʉ abhanjɨ bhakhalandataga kʉ lyoga. UYeesu akhabheega winza abhalandati bhaakwe ishumi na bhabhɨlɨ pambalɨ, akhanda kʉbhabhʉʉzya zye zɨtɨmwaje. ");
INSERT INTO mgq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akhalonga akhatɨ, “Yeenyi, ishi tʉkʉzʉbha kʉbhala ku Yelusaleemu. Kʉnʉʉkwo ʉMwana wa Muntu atɨtwalwe kʉ bhapɨtɨ abha bhapuutili na ku bhamanyizyi abhɨ ndajɨzyo bhe bhatɨmʉlonje kʉtɨ agogwe. Iwinza bhakhayɨmʉtwala kʉ bhantʉ bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Abheene bhakhayanda kʉmʉsʉʉpɨzya, kʉmʉkhoma nɨ sambogo na kʉmʉkhomeela pa shɨkhobhenhanyo. Ɨleelo isiku ɨlya wʉtatʉ akhayɨzyʉkha.” ");
INSERT INTO mgq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ɄYaakobo nu Yookhani, abhaana bha Zebedaayo, bhakhamʉsejeelela uYeesu bhakhamʉbhʉʉzya bhakhatɨ, “Mumanyizyi, tʉkwanza ʉtʉbhombele lyolyonti lye tʉtɨkʉlaabhe.” ");
INSERT INTO mgq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkwanza ɨmbabhombele akhooni?” ");
INSERT INTO mgq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakhamwamʉla bhakhatɨ, “Tʉkʉlaabha kʉtɨ, we wanda kʉtabhaala mu wumwamu waakho ʉkhatwɨtɨshɨzye kʉtabhaala peeka nɨɨwe, weeka kʉmbalɨ ɨyɨ nyoobhe yaakho ɨya kʉndɨɨlo, nʉ wamwabho kʉmbalɨ ɨyɨ nyoobhe yaakho ɨya kʉmongo.” ");
INSERT INTO mgq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","UYeesu akhabhabhʉʉzya akhatɨ, “Mutalimanyile lye mʉkʉlaabha. Bhʉlɨ, mʉngakhola kujimbiilila amayɨmba ge ɨnkʉbhala kʉyɨmba, awe mʉngɨɨtɨkha kʉbha mʉ khabhalɨlo akhagomu khe ɨne ɨntɨbhe nakho?” ");
INSERT INTO mgq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakhamwamʉla bhakhatɨ, “Tʉngakhola.” UYeesu akhabhaamʉla akhatɨ, “Nalyoli mʉngakhola kʉyɨmba anza she ɨnkʉbhala kʉyɨmba. ");
INSERT INTO mgq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ɨleelo kwɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo awe ɨya kʉmongo, ɨyo te mbombo yaanɨ. Lyoli panaapo apa kwɨkhakhala pa bhaala bhe bhabhishiliilwe shɨnɨɨsho.” ");
INSERT INTO mgq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Abhalandati abhamwabho ishumi we bhɨmvwa amazwi ganaago, bhakhanda kubhaviitilwa ʉYaakobo nu Yookhani. ");
INSERT INTO mgq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pe uYeesu akhabhabhɨlɨshɨla bhonti peeka, akhabhabhʉʉzya akhatɨ, “Mumanyile kʉtɨ abhapɨtɨ abha mʉ nsɨ bhakʉbhatabhaala abhantʉ bhaabho kʉ makha, khabhɨlɨ abhapɨtɨ bhaabho bhakʉbhabhombezya kʉ makha. ");
INSERT INTO mgq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ɨleelo kukwinyu ɨmwe te zɨbhe shɨnɨɨsho khaala. Lyoli umuntu we akwanza kʉbha mʉpɨtɨ wiinyu, atɨbhabhombelaje mwenti. ");
INSERT INTO mgq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Khabhɨlɨ umuntu wowonti we akwanza kʉbha wa kwanda kukwinyu, atɨbhabhombelaje bhonti. ");
INSERT INTO mgq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kʉnongwa ye woope ʉMwana wa Muntu atínzile kʉbhombelwa, lyoli áyinzile kʉbhabhombela abhantʉ na kufumwa uwuumi waakwe ɨnga abhasombele imbiibhi abhantʉ abhinji.” ");
INSERT INTO mgq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhakhafikha ku Yeeliko. We uYeesu na bhalandati bhaakwe nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ bhakʉsogola mu Yeeliko, umuntu ʉmo we bhakhatɨnjɨ uBatimaayo, ʉmwana wa Timaayo we áfuuye amiiso, áyɨkhaaye pambalɨ pɨ dala akhalaabhaga ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","We ayɨmvwa kʉtɨ wu Yeesu ʉwa ku Naazaleti akʉshɨla, akhabhɨlɨshɨla kwi zi ɨlya kʉdandɨzya akhatɨ, “We Yeesu, ʉwa shɨkholo sha mwene uDaudi, ʉndolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abhantʉ abhinji bhakhamʉkhajɨlaga kʉtɨ apʉʉme. Ɨleelo ʉweene akhajinaga kʉdandɨzya izi akhatɨnjɨ, “We Mwana ʉwa shɨkholo sha mwene uDaudi, ʉndolele ishisa.” ");
INSERT INTO mgq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pe uYeesu akhɨmɨɨlɨla akhatɨ, “Mʉbhɨlɨshɨle ayɨnze ɨpa.” Bhakhamʉbhɨlɨshɨla umuntu ʉla we áfuuye amiiso, bhakhamʉbhʉʉzya bhakhatɨ, “Yɨgomwe ʉmwoyo, yɨmɨɨlɨla! Akʉkʉbhɨlɨshɨla.” ");
INSERT INTO mgq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Woope akhasʉmba ɨgolole lyakwe paasɨ, akhatomokha, akhabhala kwa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","UYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “Ʉkwanza kʉtɨ ɨne ɨnkʉbhombele akhooni?” Umuntu ʉla we áfuuye amiiso akhamʉbhʉʉzya akhatɨ, “Mumanyizyi, ɨnkʉlaabha kʉtɨ amiiso gaanɨ galole.” ");
INSERT INTO mgq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","UYeesu akhamʉbhʉʉzya akhatɨ, “Bhalaga kʉkhaaya, ʉlwɨtɨkho lwakho lwakʉponɨa.” Panaapo bhʉʉlo, umuntu ʉla akhanda kʉlola, akhamʉlandata uYeesu mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","We bhapalamɨla ku Yelusaleemu, bhakhafikha papɨɨpɨ na khakhaaya akha Betisifaage na kha Besaniya, mwɨ gamba ɨlya Mizeituni, uYeesu akhabhasonteelezya abhalandati bhaakwe bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Akhabhabhʉʉzya akhatɨ, “Bhalaji mʉ khakhaaya ɨkho khe khalɨ pɨlongolela yiinyu. We mwafikha mʉ khakhaaya muula, nalʉbhɨlo bhʉʉlo mʉtɨyaaje ɨnyaana yi ndogomi nkʉnjɨɨle, ye umuntu atapandile naalumo. Mʉyɨsatʉle na kʉyɨleeta ɨpa. ");
INSERT INTO mgq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɨnga umuntu wowonti akʉbhabhʉzɨɨlɨzya akʉtɨ, ‘Khooni khe mʉkʉbhomba shɨnɨɨsho?’ mʉkhatɨnjɨ, ‘ɄMwene akʉyanza, atɨyɨgalʉsye winza panaapa shiniishi bhʉʉlo.’” ");
INSERT INTO mgq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","We bhasogola bhaabhala kuula, bhakhayɨlola ɨnyaana yi ndogomi nkʉnjɨɨle panzɨ pa mʉlyango mwɨ dala ɨpɨtɨ, bhakhayɨsatʉla. ");
INSERT INTO mgq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abhantʉ bhamu bhe bhɨ́mɨlɨɨye pʉʉpo bhakhabhabhʉzɨɨlɨzya bhakhatɨ, “Mʉkʉbhomba lyoni ɨpo, mʉkʉyɨsatʉla yaashi ɨnyaana yi ndogomi ɨyo?” ");
INSERT INTO mgq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Abhalandati bhaala bhakhabhaamʉla shishiila she uYeesu ábhabhuziizye kʉtɨ bhakhalongaje. Pe bhakhabhalekha bhasogole ni ndogomi yiila. ");
INSERT INTO mgq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakhɨnza nɨ nyaana yi ndogomi yiila kwa Yeesu. Bhakhaala amenda gaabho pamwanya pa ndogomi yiila, uYeesu akhazʉbha, akhɨɨkhala pamwanya. ");
INSERT INTO mgq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abhantʉ abhinji bhakhaalaga amenda gaabho mwɨ dala, bhamu bhakhatemaga amazanzala aga makwi mu vwizi, bhakhaalaga mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abhantʉ bhe bhálongoleeye kwɨlongolela yaakwe na bhaala bhe bhakhalandataga kʉlʉsalo bhakhadandɨzya kʉkhoolela bhakhatɨnjɨ, “Apalwaje ʉMʉlʉngʉ! Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ! ");
INSERT INTO mgq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wʉsayaje ʉwʉmwene wa yise wɨɨtʉ uDaudi we wʉkwɨnza! Mʉpaalaje ʉMʉlʉngʉ ʉwa kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pe uYeesu akhinjila mʉ nhaaya ɨya mu Yelusaleemu, akhashɨzanya kʉbhala ku Nyumba iMfinjile. Akhavwenya ivintu vwonti vwe vwámɨle mukaasi muula. Ɨleelo pe kʉkhabha kwafikha shalyabheela, akhasogola, akhabhala ku Besaniya peeka na bhalandati bhaakwe ishumi na bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ɨndaabhɨ yaakwe we bhakʉsogola ku Besaniya, ɨnzala yikhamuluma uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","She alɨ ukutali bhʉʉlo, akhalɨlola ikwi ɨlya mutiini, lye lyámɨle na matʉndʉ aminji. Akhabhala kwenya she lɨlɨ na matunda ge geleeye mʉmwo. We aafikha pʉʉpo, akhaaga lɨtalɨ nago khaala, lyoli lijejile ga matʉndʉ meene, kʉnongwa ye akhabhalɨlo akha kwela kháshɨɨlɨ kufikha. ");
INSERT INTO mgq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pe akhalɨbhʉʉzya ikwi liila akhatɨ, “Kufuma ʉmʉsanyʉʉnʉ paka wiila na wiila, nʉʉmo umuntu atakhaalye amatunda kʉkwakho.” Abhalandati bhaakwe bhakhagɨmvwa amazwi ɨgo ge uYeesu akhalonga. ");
INSERT INTO mgq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bhakhaduuga winza ku Yelusaleemu, pe uYeesu akhinjila mwi linga ilyi Nyumba iMfinjile. We ayinjila, akhabhabhɨnjɨla kunzi bhe bhakhakazyaga na kʉkala ivintu mwi linga ilyi Nyumba iMfinjile. Akhabenulanya ivintalati ɨvwa bhe bhakhavunzanyaaga ɨnhela, akhabenulanya na matengo aga bhe bhakhakazyaga ɨnkʉnda. ");
INSERT INTO mgq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Khabhɨlɨ atakhamʉlekha umuntu nʉʉmo we apimbile akhantʉ khokhonti akha kʉkazya kʉshɨzya mwi linga ilyi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","UYeesu mʉ manyɨzyo zyakwe akhalongaga akhatɨnjɨ, “Bhʉlɨ, yitasimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Inyumba yaanɨ yɨtɨbhe nyumba ya kupuutila kʉ bhantʉ abhɨ nsɨ zyonti’? Ɨleelo ɨmwe muyigalulanyiinye kʉbha ngwenya ya bhabuda!” ");
INSERT INTO mgq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo, we bhɨmvwa zɨnɨɨzyo zye uYeesu akhalonga, bhakhanda kwanza ɨdala ɨlya kʉmʉgoga. Ɨleelo bhakhamwogopaga, kʉnongwa ye abhantʉ bhonti bhakhaswigaga nu winza wɨ manyɨzyo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","We kwabha shalyabheela, uYeesu na bhalandati bhaakwe bhakhasogola mʉ nhaaya yiila. ");
INSERT INTO mgq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","We bhakʉgalʉkha ɨshɨlaabhɨla kʉbhala winza ku Yelusaleemu, bhakhalola ikwi liila ɨlya mutiini lyumile lyonti kwandɨla ku mazi gaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","UPeeteli akhakʉmbʉkha izwi lye uYeesu aalonjile, akhamʉbhʉʉzya akhatɨ, “Mumanyizyi, ana lyali kwi ɨlya mutiini lye waaligunile lyumile lyonti!” ");
INSERT INTO mgq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","UYeesu akhabhaamʉla akhatɨ, “Mʉbhe nʉ lwɨtɨkho ʉlwa kʉmʉsʉʉbhɨla ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we alɨbhʉʉzya ɨgamba ili atɨ, ‘Kumpukha ʉsʉmbwe mwa sʉmbɨ,’ lɨnɨɨlyo lɨtɨbhombeshe shɨnɨɨsho ɨnga mʉ mwoyo waakwe mʉlɨ sita kusingaana, lyoli akʉsʉʉbhɨla bhʉʉlo kʉtɨ, lyolyonti lye akʉlɨlonga lɨkʉbhombekha. ");
INSERT INTO mgq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ishi leelo ɨnkʉbhabhʉʉzya ɨnkʉtɨ, lyolyonti lye mʉkʉlɨlaabha mu mpuuto, mʉbhanje nʉ lwɨtɨkho ʉlwa kʉsʉʉbhɨla kʉtɨ mʉkʉlɨposheela, ɨpo pe mʉkhayɨposheela nalyoli. ");
INSERT INTO mgq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nɨɨmwe we mʉkwɨmɨɨlɨla kupuuta, mʉmʉtʉyɨlaje umuntu wowonti ʉla we abhabhombeeye imbiibhi zimo. Kʉkhonzya shɨnɨɨsho kwe kʉkʉmʉbhɨɨkha uYise wiinyu ʉwa kʉmwanya woope abhatʉyɨlaje imbiibhi zyinyu.”  ");
INSERT INTO mgq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ɨleelo ɨmwe ɨnga mʉtakʉbhatʉʉyɨla abhamwinyu, woope uYise wiinyu ʉwa kʉmwanya te akhabhatʉʉyɨle imbiibhi zyinyu. ");
INSERT INTO mgq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pe bhakhafikha winza ku Yelusaleemu. UYeesu we akʉjenda mwi linga ilyi Nyumba iMfinjile, abhapɨtɨ abha bhapuutili, abhamanyizyi abhɨ ndajɨzyo na bhasongo bhakhamʉbhalɨla. ");
INSERT INTO mgq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ganaaga ge ʉkʉbhomba, ʉkʉbhomba kʉ waamʉlo wooni? Wu naanu we akupiiye ʉwaamʉlo wunuuwu?” ");
INSERT INTO mgq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","UYeesu akhabhabhʉʉzya akhatɨ, “Nɨɨne ɨntɨbhabhʉzɨɨlɨzye izwi lyeka. Ɨnga mwanaamʉla, pe nɨɨne ɨntɨbhabhʉʉzye kʉtɨ ɨnkʉbhomba ganaaga kʉ waamʉlo wa naanu. ");
INSERT INTO mgq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bhʉlɨ, ʉwaamʉlo wa Yookhani ʉwa kwozya abhantʉ, twenyi mʉmbʉʉzye, wáfumile kwoshi? Wáfumile kʉmwanya awe kʉ bhantʉ?” ");
INSERT INTO mgq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pe bhakhazaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Ɨnga twamwamʉla kʉtɨ lwáfumile kʉmwanya, atɨtʉbhʉzɨɨlɨzye kʉtɨ, ‘Khooni khe mʉtakhamwɨtɨkhaga?’ ");
INSERT INTO mgq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɨleelo kʉlonga kʉtɨ lwáfumile kʉ bhantʉ, tʉtangasheela.” Bhakhogopaga abhantʉ, kʉnongwa ye abhantʉ bhonti bhámwitishile uYookhani kʉtɨ áamɨle mukuwi we ʉMʉlʉngʉ ámusonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bhakhamwamʉla bhakhatɨ, “Tutamanyile.” Woope uYeesu akhabhabhʉʉzya akhatɨ, “Nɨɨne ɨntakʉbhabhʉʉzya kʉtɨ ɨnkʉbhomba ziniizi kʉ waamʉlo wa naanu.” ");
INSERT INTO mgq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","UYeesu akhanda kʉlonga na bhalongozi bhaala abha Bhayahuudi kʉ vɨkholanyo. Akhalonga akhatɨ, “Álɨɨpo umuntu ʉmo, we áwaalile amazabiibu mu shiizi shaakwe. Akhazyʉngʉʉlɨzya ʉlʉbhaga, akhabana apa kufinyila amazabiibu, akhazenga ʉmʉnaala. Pe akhɨmvwana na bhalimi kʉtɨ bhabhombaje ɨmbombo ɨnga bhakhagabhane nawo ɨvɨyabho, akhashʉʉla kʉbhala ɨnsɨ ɨya kutali. ");
INSERT INTO mgq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","We akhabhalɨlo akhi mvuno ɨya mazabiibu khaafikha, akhamʉsonteelezya umubhombi waakwe ku bhalimi bhaala, kʉtɨ bhaamupe amazabiibu ge bhamʉgabhɨɨye kufuma mu shiizi shaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɨleelo abhalimi bhaala bhakhamʉlema umubhombi waakwe ʉla, bhakhamʉkhoma na kʉmʉgalʉsya ɨnyoobhe nyeene kwa mwene waakwe. ");
INSERT INTO mgq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Akhamʉsonteelezya winza umubhombi waakwe ʉwamwabho ku bhalimi bhaala. Woope bhakhamʉkhoma na kʉmʉvwalazya amalonda shaakha mwi twe na kʉmʉbhomba akhabhiibhi nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akhamʉsonteelezya umubhombi waakwe ʉwamwabho winza, woope abhalimi bhaala bhakhamʉgoga. Ábhasonteleziizye abhabhombi bhaakwe abhamwabho abhinji bhʉʉlo. Abhalimi bhaala bhakhabhakhoma bhamu, abhanjɨ bhakhabhagoga. ");
INSERT INTO mgq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ʉmwene shiizi akhasyalɨlwa nu muntu weeka we áamɨle mwana waakwe we amuganile. Akhamʉsonteelezya ku bhalimi bhaala kʉwʉmalɨlɨshɨlo, akhasɨɨbhaga akhatɨnjɨ, ‘Bhatimushindishe pe mwana waanɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ɨleelo abhalimi bhaala bhakhabhʉʉzanya bhakhatɨ, ‘Ʉnʉ we mugaali uwi shiizi ishi. Ishi tʉmʉgoje, ɨnga tweje uwugaali waakwe.’ ");
INSERT INTO mgq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pe bhakhamʉlema, bhakhamʉgoga, bhakhamʉsʉmba kunzi ku shiizi ɨsha mazabiibu. ");
INSERT INTO mgq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ishi pe ʉmwanensho uwi shiizi ɨsha mazabiibu ʉyo akhayɨbhomba lyoni? Akhayɨbhayazya abhalimi bhaala. Ishiizi shiila ɨsha mazabiibu, akhayɨɨbhapa abhanjɨ! ");
INSERT INTO mgq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mʉtakʉwʉsaajɨla uWusimbe uWufinjile we wʉkʉtɨ, ‘Iwe lye bhálikhaanile abhazenji, lɨnɨɨlyo lye lyabha liwe ɨlya pambalɨ, lye lilemile inyumba yonti. ");
INSERT INTO mgq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Izwi liniili lifumile kwa Mwene, lyope lya kuswijizya kʉkwɨtʉ!’” ");
INSERT INTO mgq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abhapɨtɨ abha bhapuutili, abhamanyizyi abhɨ ndajɨzyo na bhasongo bhakhamanya kʉtɨ akubhiibhika bhɨɨbho. Pe bhakhanza ɨdala ɨlya kʉmʉlema, ɨleelo bhakhogopaga ɨmpʉga ɨya bhantʉ, bhakhamʉlekha, bhakhasogola. ");
INSERT INTO mgq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pe bhakhasonteelezya aBhafalisaayi bhamu peeka nɨ shɨpʉga sha bhalandati bha mwene uHeloodi, ɨnga bhamʉleme mu mazwi gaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “We Mumanyizyi, tumanyile kʉtɨ ɨwe we muntu ʉwa nalyoli. Khabhɨlɨ ʉtakʉwʉsaajɨla ʉwʉpɨtɨ wa muntu pa mbombo, kʉnongwa ye ʉtakwɨmɨla bha ndwɨmo, lyoli ʉkʉmanyɨzya ɨzya Mʉlʉngʉ mu wanalyoli. Tʉbhʉʉzye she ʉkʉlola. Bhʉlɨ, ɨndajɨzyo zɨkwɨtɨshɨzya kufumwa ɨnsonho kwa Kaisaali awe khaala?” ");
INSERT INTO mgq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ɨleelo uYeesu ámanyile ɨnsɨɨbho yaabho imbiibhi, akhabhaamʉla akhatɨ, “Khooni khe mʉkʉndɨnga? ");
INSERT INTO mgq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ndanje ɨnhela ɨnsabhaazya ye mukufumwa kʉ nsonho.” Bhoope bhakhamʉleetela ɨnsabhaazya yeeka. ");
INSERT INTO mgq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Ishifwani ishi nu wusimbe uwu vwa naanu?” Bhakhamwamʉla bhakhatɨ, “Vwa Kaisaali.” Pe uYeesu akhabhabhʉʉzya akhatɨ, “Mʉmʉpanje uKaisaali vwe vwa Kaisaali, iwinza mʉmʉpanje ʉMʉlʉngʉ vwe vwa Mʉlʉngʉ.” Bhonti bhakhaswiga nawo nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ABhasadukaayi bhe bhakhatɨnjɨ naakumo kʉzyʉkha abhafwe, bhamu bhakhabhala kwa Yeesu, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mumanyizyi, ʉMoose átusimbiiye ɨndajɨzyo kʉtɨ, ɨnga umuntu aafwa, amʉlekha ʉmʉshɨ sita kʉpaapa ʉmwana, yɨkwɨtɨshɨlwa ʉkhambakʉ waakwe kʉmʉgaala ʉmʉfwɨle ɨnga amʉpaapɨle umuyazi abhaana. ");
INSERT INTO mgq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ishi bhálɨɨpo abhanamuntu saba. Ʉwa kwanda áyeejile ʉmʉshɨ, ɨleelo akhafwa sita kʉpaapa ʉmwana. ");
INSERT INTO mgq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ʉwa wʉbhɨlɨ woope akhamʉgaala ʉmwantanda ʉla, ɨleelo woope akhafwa, atakhalekha ʉmwana nʉʉmo. Woope ʉwa wʉtatʉ zɨkhabha shɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bhonti saba bhakhafwa, bhatakhalekha ʉmwana nʉʉmo. Kʉwʉmalɨlɨshɨlo wa bhonti, ʉmwantanda ʉla woope akhafwa. ");
INSERT INTO mgq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bhʉlɨ, pi siku lye abhafwe bhakhayɨzyʉkha, ʉmwantanda ʉla akhayɨbha mʉshɨ wa naanu mʉ bhaala saba? Kʉnongwa ye abhasakhaala bhonti saba bhámwejile!” ");
INSERT INTO mgq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","UYeesu akhabhaamʉla akhatɨ, “Mʉkʉpʉbha kʉnongwa ye mutawumanyile uWusimbe uWufinjile, khabhɨlɨ mutagamanyile amakha ga Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kʉnongwa ye isiku lye abhafwe bhakhayɨzyʉkha te bhakheegaje awe kwejelwa. Lyoli bhakhayɨbha anza bhakhabhɨzya bhe bhalɨ kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ɨleelo kʉ zya kʉzyʉkha abhafwe, mutabhaziizye mu shitaabu sha Moose she ʉMʉlʉngʉ ámubhuziizye paala pe ɨshɨsyeta shɨkhaakhaga ʉmwoto? ɄMʉlʉngʉ ámubhuziizye ʉMoose átɨlɨ, ‘Ɨne ne Mʉlʉngʉ wa Abulahaamu, ne Mʉlʉngʉ wa Isaaka, khabhɨlɨ ne Mʉlʉngʉ wa Yaakobo.’ ");
INSERT INTO mgq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ishi leelo mʉmanye kʉtɨ ʉweene wʉ Mʉlʉngʉ wa bhantʉ bhanaabho, she poope bháfuuye khalɨ. Ɨmwe mupubhile nhaani.” ");
INSERT INTO mgq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Umumanyizyi ʉmo ʉwɨ ndajɨzyo akhafikha, akhazyɨmvwa zye uYeesu akhadalɨnhanaga na Bhasadukaayi. We aalola kʉtɨ uYeesu abhaamʉla akhinza, akhamʉbhʉzɨɨlɨzya akhatɨ, “Mʉ ndajɨzyo zyonti, yilikwi ye ya kwanda?” ");
INSERT INTO mgq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","UYeesu akhamwamʉla akhatɨ, “Ɨya kwanda ye yɨ yɨɨnɨ, ‘Tejeelezya Isilaeli! ɄMwene ʉMʉlʉngʉ wɨɨtʉ, we wʉ Mwene weeka. ");
INSERT INTO mgq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nɨɨwe ʉmʉgane ʉMwene ʉMʉlʉngʉ waakho kʉ mwoyo waakho wonti, ku mupepu waakho wonti, kʉ njeele zyakho zyonti na kʉ makha gaakho gonti.’ ");
INSERT INTO mgq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɨya wʉbhɨlɨ ye yɨ yɨɨnɨ, ‘Ʉmʉgane uwamwinyu anza she uyiganile wʉneewe.’ Ɨndajɨzyo ɨyamwabho ye mpɨtɨ kʉshɨla ziniizi zɨbhɨlɨ yɨtalɨɨpo nɨɨmo.” ");
INSERT INTO mgq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Umumanyizyi ʉla ʉwɨ ndajɨzyo akhamʉbhʉʉzya uYeesu akhatɨ, “Mumanyizyi, walonga zya nalyoli kʉtɨ ʉMʉlʉngʉ alɨ weeka mwene, atalɨɨpo ʉwamwabho nʉʉmo, lyoli wʉʉyo mwene. ");
INSERT INTO mgq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Khabhɨlɨ lyoli kʉmʉgana ʉMʉlʉngʉ kʉ mwoyo wonti, na kʉ njeele zyonti, na kʉ makha gonti, khabhɨlɨ ʉmʉgane umuntu wowonti anza shishiila she uyiganile wʉneewe. Liniili lɨpɨtɨ nhaani pamiiso ga Mʉlʉngʉ kʉshɨla impuuto zyonti ɨzya kufumwa imfinjile na kʉlʉngʉlɨzya ɨvɨkhanʉ mʉ mwoto.” ");
INSERT INTO mgq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","UYeesu we aalola kʉtɨ umuntu ʉla amwamʉla ku wushindamu, akhamʉbhʉʉzya akhatɨ, “Ɨwe ʉtalɨ apatali nʉ wʉmwene wa Mʉlʉngʉ.” Pe kufuma luluula, kʉtakhabha nu muntu ngaweeka we álinjiziizye kʉmʉbhʉzɨɨlɨzya winza uYeesu zimo ɨzya kʉmʉtega. ");
INSERT INTO mgq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","We uYeesu akʉmanyɨzya mwi linga ilyi Nyumba iMfinjile, akhabhʉzɨɨlɨzya akhatɨ, “Khooni khe abhamanyizyi abhɨ ndajɨzyo bhakʉlonga bhakʉtɨ uKilisiti Mwana ʉwa shɨkholo sha mwene uDaudi? ");
INSERT INTO mgq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","UDaudi wʉʉyo kʉ makha ga Mupepu uMufinjile, álonjile átɨlɨ, ‘ɄMwene ámubhuziizye ʉMwene waanɨ átɨlɨ, “Yɨɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo, paka we nabhabhɨɨkha abhalʉgʉ bhaakho paasɨ pa vɨnama vwakho.”’ ");
INSERT INTO mgq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ishi uDaudi wʉʉyo akʉmʉtekha uKilisiti kʉtɨ wʉ Mwene waakwe, uKilisiti atangabha mwana waakwe bhʉʉlo khaala, lyoli kumo wʉ Mwene.” Ɨmpʉga ya bhantʉ yɨkhabha she yɨkʉmʉtejeelezya uYeesu kʉ lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mʉ manyɨzyo zyakwe ɨzyamwabho, uYeesu akhabhamanyɨzya akhatɨ, “Mʉbhe amiiso na bhamanyizyi abhɨ ndajɨzyo, abheene bhakʉyɨgana kʉjenda kʉ mabaado we bhakwatile ɨnkanzʉ, kʉtɨ abhantʉ bhabhalamʉkhaje ku lushindikho mʉ manaalo. ");
INSERT INTO mgq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","We bhalɨ mwi sinagoogi, bhakwanza kwɨkhala mʉ matengo aga pɨlongolela. Mwope mu vikulukulu bhakwɨkhala mʉ matengo aga bhapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Abhantʉ ɨbha bhakʉfwʉla ku wushevu ivintu vwa bhafwɨle. Mu shisa ɨshɨ lenga abheene bhakupuuta impuuto intali, kʉtɨ abhantʉ bhatɨnjɨ bhagolosu. Mʉ lɨnɨɨlyo, ʉMʉlʉngʉ akhayɨɨbhapa ulufundo ʉlʉpɨtɨ!” ");
INSERT INTO mgq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","UYeesu akhabhala kwɨkhala papɨɨpɨ nɨ shɨlɨɨlo ɨsha kufumwizya imfinjile mu Nyumba iMfinjile. Akhenyaaga abhantʉ abhinji she bhakufumwa ɨnhela mʉ nsandʉʉka muula. Abhadumbwe abhinji bhakhafumwaga amakhela aminji mʉ nsandʉʉka. ");
INSERT INTO mgq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Akhɨnza ʉmʉfwɨle ʉmo ʉmʉpɨɨna, woope akhafumwa utukoobheli tʉbhɨlɨ bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pe uYeesu akhabhabhɨlɨshɨla abhalandati bhaakwe, akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, ʉmwantanda ʉmʉfwɨle ʉmʉpɨɨna we aafumwa nhaani kʉshɨla abhanjɨ bhonti zye bhafumwizye mʉ shɨlɨɨlo ɨsha kufumwizya imfinjile, mu Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ɨnkʉlonga shiniishi kʉnongwa ye abhantʉ abhinji bhonti bhafumwizye zye zyonjeleeye mu winji wɨ shʉʉma shaabho. Ɨleelo ʉmwantanda ʉnʉ poope she mʉpɨɨna mansɨ, aafumwa vwonti vwe vwamɨle vwa kʉmwavwa mʉ wɨɨkhalo waakwe.” ");
INSERT INTO mgq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","We uYeesu akufuma mwi linga ilyi Nyumba iMfinjile, umulandati waakwe weeka akhamʉbhʉʉzya akhatɨ, “Mumanyizyi, geenye amawe amapɨtɨ ɨga ni nyumba ɨmpɨtɨ izi she vikuswijizya!” ");
INSERT INTO mgq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","UYeesu akhamwamʉla akhatɨ, “Ʉkʉgalola amayumba amapɨtɨ ɨga? Gonti ganaaga gakhayɨpongolwa, te lɨkhasyale iwe naalimo pamwanya pi we ɨlyamwabho!” ");
INSERT INTO mgq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","UYeesu áyɨkhaaye pɨ gamba ɨlya Mizeituni, áyenyiizye amiiso kʉmbalɨ iyi Nyumba iMfinjile. Pe uPeeteli, ʉYaakobo, uYookhani nʉ Andeleeya bhakhamʉbhʉzɨɨlɨzya kukwilu we bhalɨ bheene, bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tʉbhʉʉzye, ziniizi zye ʉkʉlonga zikhayifumila liino? Shɨlolesyo shooni she shɨkhayɨlolesya kʉtɨ zɨnɨɨzyo zɨpalamɨɨye kufumila?” ");
INSERT INTO mgq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pe uYeesu akhanda kʉbhabhʉʉzya, akhatɨ, “Mʉbhe amiiso, umuntu wowonti atakhabhakhopele! ");
INSERT INTO mgq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abhantʉ abhinji bhakhayɨnza kwɨ taawa lyanɨ, bhakhayɨyɨtekhaga kʉtɨ, ‘Ɨne ne ne Kilisiti,’ bhakhayɨbhakhopela abhantʉ abhinji. ");
INSERT INTO mgq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nɨɨmwe we mwazyɨmvwa ɨnongwa ɨzya wʉlʉgʉ, ni mpempu ɨzya wʉlʉgʉ, mʉtakhogopaje khaala. Zɨnɨɨzyo zikhayifumila lyoli, ɨleelo ʉwʉmalɨlɨshɨlo wuula wʉkhayɨbha wʉshɨɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɨnsɨ yeeka yɨkhayɨlwanga nɨ nsɨ iyinji, nʉ wʉmwene weeka wʉkhayɨlwanga nʉ wʉmwene ʉwamwabho. Kʉkhayɨbha ɨnzala ni viyingayinga ɨvwɨ nsɨ, uku nʉʉkwo. Mumo ɨnzala yikhayigwa. Vɨnɨɨvwo vwe vɨkhayɨbha wandɨlo bhʉʉlo wa mayɨmba, anza she akʉbhabhwa ʉmwantanda we akwanda kʉpaapa. ");
INSERT INTO mgq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ɨleelo ɨmwe mʉbhe amiiso nhaani, abhantʉ bhakhayɨbhatwala mʉ mabalaaza na mu masinagoogi gaabho kʉtɨ mʉkhomwe. Bhakhayɨbhatwala kʉ bhapɨtɨ abhɨ nsɨ na kʉ bhamwene kʉnongwa yaanɨ, kʉtɨ mʉkhamvwɨnsye kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yɨkʉtɨ suuti iNtumi iNyinza zɨlʉmbɨɨlɨlwe kʉ bhantʉ abha vɨkholo vwonti, pe insiku ɨzya kʉmpeleela zikhayifikha. ");
INSERT INTO mgq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Abhantʉ ɨbho we bhabhalema na kʉbhatwala mʉ mabalaaza, kʉbhalonjeelela zimo, mʉtakhaalabhe kʉsɨɨbha zye mʉtɨbhale mʉlonje. Mʉkhalongaje ziila zye mwapeelwa kʉzɨlonga mʉ khabhalɨlo khakhaala. Kʉnongwa ye te mwemwe mʉkhayɨlongaga, lyoli uMupepu uMufinjile we akhayɨbhalonjela. ");
INSERT INTO mgq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Kʉ khabhalɨlo khanaakho, ʉkhambakʉ akhayɨmʉlonjeelela ʉwamwabho kʉ bhalʉgʉ kʉtɨ bhamʉgoje, uyise akhayɨmʉlonjeelela ʉmwana. Abhaana bhoope bhakhayɨsambʉkha ku bhapaafi bhaabho na kʉbhalonjeelela ɨnga bhabhagoje. ");
INSERT INTO mgq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abhantʉ bhonti bhakhayibhaviitilwa kʉnongwa yɨ taawa lyanɨ. Ɨleelo, we akhayijimbiilila kufishila kʉmpeleela we ʉMʉlʉngʉ akhayɨmʉpokha. ");
INSERT INTO mgq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ɨleelo mʉkhayɨlɨlola ‘inanganyi lye lɨkʉnanganya’ lyɨmɨlɨɨye aPafinjile paala pe lɨtakwanzɨwa kʉbha. We akʉbhaazya amazwi ganaaga, azyaganyaaje, pe bhe bhalɨ mʉ nsɨ ɨya Yudeeya, bhakhashɨmbɨlɨlaje mʉ magamba! ");
INSERT INTO mgq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Umuntu we alɨ kʉ shɨsonyonje, atakhiishe kwega ivintu vwakwe mu nyumba, lyoli akhashɨmbɨlaje! ");
INSERT INTO mgq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Umuntu we ayagaatile ku shiizi atakhasheele kʉgalʉkha kʉlʉsalo kʉbhala kwega ʉmwenda waakwe, akhashɨmbɨlaje! ");
INSERT INTO mgq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bhasheleeye abhantanda bhe bhakhayɨbha pa wumwamu na bhe bhakhayonsyaga mu nsiku zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mupuutaje kʉtɨ insiku zɨnɨɨzyo zitakhafumile mʉ khabhalɨlo akhi mpepu ni mvula inyinji. ");
INSERT INTO mgq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Insiku zɨnɨɨzyo zɨkhayɨbha zya mayɨmba amapɨtɨ ge gatafumiiye naalumo kufuma pe ʉMʉlʉngʉ ápelile ɨnsɨ kufishila mʉ khabhalɨlo ɨkha. Khabhɨlɨ te gakhafumile winza naalumo amayɨmba anza ganaago. ");
INSERT INTO mgq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Khabhɨlɨ ɨnga ʉMwene ʉMʉlʉngʉ atazɨpʉngʉzyaje insiku zɨnɨɨzyo, nhanɨ atalɨɨpo umuntu ʉwa kʉpona. Ɨleelo ʉMʉlʉngʉ apunguziizye insiku ziila, kʉnongwa ya bhasaabhʉlwa bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mʉ khabhalɨlo khanaakho, ɨnga umuntu akʉbhabhʉʉzya kʉtɨ, ‘Yeenya, uKilisiti alɨ ɨpa!’ Awe akʉtɨ, ‘Yeenya, ʉla alɨ kuula!’ Mʉtakhamwɨtɨkhaje khaala. ");
INSERT INTO mgq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kʉnongwa ye bhakhayifumila bhe bhakʉyɨtekha kwɨ lenga kʉtɨ bhabha Kilisiti, na bhakuwi abhɨ lenga. Bhakhayɨbhombaga ɨvɨlolesyo ɨvɨpɨtɨ na mayele aga kʉbhakhopela abhantʉ, poope na bhasaabhʉlwa bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ishi ɨmwe, mʉbhe amiiso! Ɨne naatala suuti nabhasokha we zyonti zɨnɨɨzyo zɨshɨɨlɨ kufumila. ");
INSERT INTO mgq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ɨleelo mu nsiku ziila, we amayɨmba gaala gaasila, ‘Ɨzʉbha likhayigwa akhiisi, umwezi woope te wʉkhalamaje, ");
INSERT INTO mgq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ɨnzota zyope zɨkhayɨlendaga paasɨ kufuma kʉmwanya, na makha aga kʉmwanya goope gakhayiyinga.’ ");
INSERT INTO mgq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ɨpo pe abhantʉ bhonti bhakhayɨmʉlola ʉMwana wa Muntu akwɨnza mʉ mabhɨngo alɨ na makha aminji nu wumwamu ʉwʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pe akhayɨbhasonteelezya abhakhabhɨzya bhaakwe kʉbhabhʉngaanya abhasaabhʉlwa bhaakwe kufuma mʉmbalɨ zyonti zini ɨzyɨ nsɨ, kufuma kʉwʉmalɨlɨshɨlo ʉwɨ nsɨ kufishila ʉwʉmalɨlɨshɨlo ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mʉmanyɨlaje ɨshɨkholanyo ishi kwi ɨlya mutiini. Kʉnongwa ye ɨmpaaswa zyakwe we zyanda kuduvwa na kʉmezya amatʉndʉ, mʉkʉmanya kʉtɨ akhabhalɨlo akhi mvuno khapalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","She shɨnɨɨsho, nɨɨmwe ɨnga mwazɨlola zyonti zɨnɨɨzyo zɨkʉbhombekha, mʉkhamanyaje kʉtɨ ɨndɨ papɨɨpɨ nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nalyoli ɨnkʉbhabhʉʉzya, ishipaafi ishi te shɨshɨle we ziniizi zyonti zɨshɨɨlɨ kufumila. ");
INSERT INTO mgq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kʉmwanya na paasɨ vɨkhayɨshɨla, ɨleelo amazwi gaanɨ te gakhaashɨle naalumo. ");
INSERT INTO mgq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ɨleelo ku zyi siku liila na kʉ zyɨ saala yiila, atalɨɨpo umuntu we amanyile awe abhakhabhɨzya abha kʉmwanya, awe ʉMwana, lyoli ʉTaata waakwe mwene. ");
INSERT INTO mgq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kʉnongwa ye mutamanyile kʉtɨ akhabhalɨlo khanaakho khakhayifikha liino, yɨlɨnganyaaje, mʉbhe amiiso! ");
INSERT INTO mgq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ɨshɨkholanyo shaakwe shɨkʉkholana nu muntu we akʉsogola pakhaaya, akʉshʉʉla. Akʉbhaleshela abhabhombi bhaakwe kʉtɨ bhasʉngaje pakhaaya. Akʉmʉgabhɨla weeka weeka ɨmbombo yaakwe ɨya kʉbhomba. Woope umulindiilili ʉwa pa mʉlyango akʉmʉlajɨzya kʉtɨ, abhanje amiiso kwenyeelezya pakhaaya. ");
INSERT INTO mgq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mʉbhe amiiso, kʉnongwa ye mutamanyile isiku lye akhayɨnza uwi nyumba. Mutamanyile kʉtɨ lumo akhayɨgalʉkha sha shalyabheela, awe shawusiku pakaasi awe kʉ masheelo we ɨnhanda zɨkʉbhɨlɨshɨla awe shɨlaabhɨla. ");
INSERT INTO mgq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mʉbhe amiiso, kʉtɨ poope ɨnga agandʉshɨzya kwɨnza, atakhaaje mugonile utulo. ");
INSERT INTO mgq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Liniili lye ɨnkʉbhabhʉʉzya ɨmwe, ɨnkʉbhabhʉʉzya na bhantʉ bhonti kʉtɨ mʉbhe amiiso.” ");
INSERT INTO mgq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zyásyalile insiku zɨbhɨlɨ bhʉʉlo kʉtɨ shɨbhe shikulukulu ɨshɨ Pasaaka nɨ sha makaati ge gatabhishiilwe uwusafu. Abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo, bhakhanzaga ɨdala ɨlya kumuziga uYeesu kʉtɨ, bhamʉleme kukwilu ɨnga bhamʉlonje na kʉmʉgoga. ");
INSERT INTO mgq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ɨleelo bhakhalonga bhakhatɨ, “Isuuti tʉleshe ishikulukulu shɨshɨle ɨnga tʉkhamʉlemaje, abhantʉ bhatakhabhombe ʉmʉyʉbhano.” ");
INSERT INTO mgq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","UYeesu áamɨle mʉ nhaaya ɨya mu Besaniya, mu nyumba ya Siimoni we ámuponiizye amaketa, áyɨkhaaye akhalyanga ishaakulya. Akhɨnza ʉmwantanda ʉmo we áamɨle na khasupa akhinza khe khízuuye amafuta agɨ nhela ɨmpɨtɨ ge gakununshiilila, ge bhakhatɨnjɨ ɨnalaado. Amafuta gaala gáamɨle gɨ nhela ɨmpɨtɨ, ge gakhanunshilaga akhinza. Ʉmwantanda ʉla akhabazʉla akhasupa khaala, akhamwitiilizya uYeesu pi twe. ");
INSERT INTO mgq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abhantʉ bhamu bhe bháamɨle mu nyumba muula, bhakhaviitwa. Bhakhanda kʉlonga bheene na bheene kʉtɨ, “Khooni khe akʉnanganya amafuta aminza anza ganaaga? ");
INSERT INTO mgq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Amafuta ɨga ge gayiiye kʉkazya idinaali imia zɨtatʉ (300), na kʉʉbhapa abhapɨɨna ɨnhela zye waakazya.” Bhakhamʉlongana nhaani ʉmwantanda ʉla. ");
INSERT INTO mgq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ɨleelo uYeesu akhatɨ, “Mʉleshe, khooni khe mʉkʉmʉyɨmvwa? Ʉweene ambombeeye lye lyinza nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abhapɨɨna mʉlɨ nabho kukwinyu insiku zyonti, muyiiye kʉbhabhombela inyinza zyonti zye muyiganile. Ɨleelo ɨne te ɨmbe peeka nɨɨmwe insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ʉmwantanda ʉnʉ abhomba lye angalɨkhola. Aatala kʉwʉpakha ʉmʉbhɨlɨ waanɨ amafuta ganaaga kʉwʉlɨngaanya kʉsyɨlwa. ");
INSERT INTO mgq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nalyoli ɨnkʉbhabhʉʉzya, poponti pe iNtumi iNyinza zɨkhayɨlʉmbɨɨlɨlwa mʉ nsɨ zyonti, lye ʉmwantanda ʉnʉ ambombela lɨkhayɨlongwa kʉmʉkʉmbʉkha.” ");
INSERT INTO mgq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pe ʉYʉʉda Sikalioti, weeka mu bhalandati bhaala ishumi na bhabhɨlɨ abha Yeesu, akhabhala kʉlonjeelela kʉ bhapɨtɨ abha bhapuutili kʉtɨ, abhalanje ɨdala ɨlya kʉmʉlema uYeesu. ");
INSERT INTO mgq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Abhapuutili abhapɨtɨ we bhɨmvwa, bhakhasha nhaani. Bhakhalagana nawo kʉtɨ bhatiimupe ɨnhela. Pe ʉYʉʉda akhanda kwanza ɨdala ɨlya kʉmʉlonjeelela uYeesu mʉ khabhalɨlo khe khakhondeeye. ");
INSERT INTO mgq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lyámɨle lisiku ɨlya kwanda ɨlya shikulukulu ɨsha makaati ge gatabhishiilwe uwusafu. Khabhɨlɨ kháamɨle khabhalɨlo khe abhantʉ bhakhabhoolaga ɨngoole ɨyɨ Pasaaka. Pe abhalandati bha Yeesu bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ʉkwanza tʉbhale tʉkʉlɨnganɨzanye kwoshi ishikulukulu ɨshɨ Pasaaka?” ");
INSERT INTO mgq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pe uYeesu akhabhasonteelezya abhalandati bhaakwe bhabhɨlɨ. Akhabhabhʉʉzya akhatɨ, “Bhalaji mʉ nhaaya ɨyo, mʉtɨkhomaane nu muntu ʉmʉsakhaala ʉmo we apimbile ɨnsonta ɨya minzi, mʉkhamʉlandataje kuula kwe akʉbhala. ");
INSERT INTO mgq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mu nyumba yiila ye ayinjila, mʉbhale mʉmʉbhʉʉzye ʉmwene nyumba mʉtɨ, ‘UMumanyizyi akʉbhʉzɨɨlɨzya akʉtɨ, ulupitu ʉlwa bhajeni lʉlɨ pooshi? Mʉnʉʉmwo mwe ɨnkwanza kulya ishikulukulu ɨshɨ Pasaaka peeka na bhalandati bhaanɨ.’ ");
INSERT INTO mgq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pe ʉmwene nyumba wʉʉyo atɨbhalanje ulupitu ʉlʉpɨtɨ ʉlwa pamwanya mu nyumba ɨnjelenhanye, lwe lʉlɨngaanye nzɨɨla apa kwɨkhala. Mʉnʉʉmwo mwe mʉtɨlɨngaanye.” ");
INSERT INTO mgq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abhalandati bhaala bhakhasogola, bhakhabhala bhakhinjila mʉ nhaaya. Bhakhaaga zyonti zɨlɨ shishiila she uYeesu ábhabhuziizye, bhakhalɨngaanya ɨPasaaka. ");
INSERT INTO mgq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","We kwabha shalyabheela, uYeesu akhɨnza peeka na bhalandati bhaakwe bhaala ishumi na bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","We bhalɨ kulya, uYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, weeka wiinyu we akulya peeka nɨɨne panaapa, atɨndonjeelele kʉ bhalʉgʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abhalandati bhaakwe bhakhanda kʉswɨmɨɨlɨla, weeka weeka akhanda kʉmʉbhʉʉzya uYeesu kʉtɨ, “Bhʉlɨ, neene?” ");
INSERT INTO mgq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","UYeesu akhabhabhʉʉzya akhatɨ, “Atɨbhe wamwinyu weeka ɨmwe ishumi na bhabhɨlɨ, we akʉsanzɨla ikaati peeka nɨɨne mʉ shɨlɨɨlo umu. ");
INSERT INTO mgq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ɄMwana wa Muntu atɨbhale anza she yisimbiilwe mu Wusimbe uWufinjile. Ɨleelo asheleeye umuntu we akʉmʉlonjeelela ʉMwana wa Muntu kʉ bhalʉgʉ! Yaamɨle kwashi kʉkwakwe umuntu wʉnʉʉyo nhanɨ atakhapapwaga.” ");
INSERT INTO mgq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","We bhakulya, uYeesu akheega ikaati, akhalɨsaya, akhamensula, akhaabhapa abhalandati bhaakwe, akhatɨ, “Yeeji, uwu we mʉbhɨlɨ waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Khabhɨlɨ akheega ɨshɨkoopa, akhasalifwa kwa Mʉlʉngʉ, akhaabhapa abhalandati bhaakwe, bhonti bhakhamwelela mʉ shɨkoopa shiila. ");
INSERT INTO mgq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akhabhabhʉʉzya akhatɨ, “Ili lɨbhanda lyanɨ lye likwitikha kʉnongwa ya bhantʉ abhinji, likusimishizya ulufingo ʉlwa Mʉlʉngʉ na bhantʉ bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nalyoli ɨnkʉbhabhʉʉzya ɨnkʉtɨ, kufuma ʉmʉsanyʉʉnʉ, te ɨnhamwele winza idivaayi iyi zabiibu paka pi siku liila lye ɨnhayɨmwela idivaayi iyi zabiibu mʉ wʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pe bhakhɨmba ʉlwɨmbo. We bhaamala kwɨmba, bhakhasogola, bhakhabhala kwɨ gamba ɨlya Mizeituni. ");
INSERT INTO mgq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","We bhalɨ mwɨ dala, uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨmwe mwenti mʉtɨshɨmbɨle na kʉndekha. Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ɨnhayɨmʉkhoma umudiimi, ɨmpʉga ɨyɨ ngoole yɨkhayɨsataana.’ ");
INSERT INTO mgq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ɨleelo we nazyʉkha, ɨnhayɨbhatangʉlɨla kʉbhala kʉ Galɨlaaya.” ");
INSERT INTO mgq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pe uPeeteli akhamʉbhʉʉzya akhatɨ, “Poope ɨnga abhamwɨtʉ bhonti bhakʉshɨmbɨla, ɨleelo ɨne ɨntangakʉshɨmbɨla ɨnkʉleshe.” ");
INSERT INTO mgq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","UYeesu akhamʉbhʉʉzya akhatɨ, “Nalyoli ɨnkʉkʉbhʉʉzya kʉtɨ, uwusiku ʉwa mʉsanyʉʉnʉ, we ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla khabhɨlɨ, ɨwe ʉtɨnhaane khatatʉ kʉtɨ utamanyile.” ");
INSERT INTO mgq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ɨleelo uPeeteli akhazeemela nhaani akhatɨ, “Poope ɨnga yɨtɨbhe ya kufwa peeka nɨɨwe, te yɨmbɨɨshe kʉtɨ ɨnkʉkhaane ɨwe ngakheeka.” Abhalandati abhamwabho bhoope bhakhalonga shɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","We bhaafikha kwɨ gamba ɨlya Mizeituni, bhakhabhala ku bositaani ye bhakhatɨnjɨ iGetisemaani. UYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Yiikhali ɨpa, mʉ khabhalɨlo khe ɨne inkupuuta.” ");
INSERT INTO mgq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akhabheega uPeeteli, ʉYaakobo nu Yookhani, akhabhala nabho apatali khashe, akhanda kʉswɨmɨɨlɨla na kupulinta. ");
INSERT INTO mgq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akhabhabhʉʉzya akhatɨ, “Ʉmwoyo waanɨ wʉswɨmɨlɨɨye nhaani, ɨngafwa bhʉʉlo. Ɨmwe mwɨkhale panaapa, mʉbhe amiiso.” ");
INSERT INTO mgq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akhasejela pɨlongolela khashe, akhagwa shikupama. Akhapuutaga kʉtɨ, ɨnga yɨtɨnhanaga, aamɨle atashɨlɨle mʉ khabhalɨlo ɨkho akha mayɨmba. ");
INSERT INTO mgq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","UYeesu akhalonga akhatɨ, “Aaba, we Taata, ɨwe kʉkwakho zyonti zɨkʉbhombekha. Ʉtakhɨtɨshɨzye kʉtɨ amayɨmba amapɨtɨ ɨga ganaaje! Ɨleelo yɨtakhabhe anza she ɨnkwanza, lyoli anza she ʉkwanza ɨwe.” ");
INSERT INTO mgq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","We agalʉkha ku bhalandati bhaakwe, akhaaga bhagonile utulo. Akhamʉbhʉʉzya uPeeteli akhatɨ, “Siimoni, ugonile utulo? Wapootwa kʉbha amiiso ɨsaala yeeka nyeene?” ");
INSERT INTO mgq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Akhabhabhʉʉzya akhatɨ, “Daamushi, mʉbhe amiiso na kupuuta kʉtɨ mutakhinjile mʉ ndɨngo. Ʉmwoyo wʉlɨ na makha aga kwɨtɨshɨla, ɨleelo ʉmʉbhɨlɨ mudeganu.” ");
INSERT INTO mgq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","UYeesu akhabhala akha wʉbhɨlɨ kupuuta, akhagalʉshɨla kʉlonga amazwi gagaala. ");
INSERT INTO mgq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","We agalʉkha winza, akhaaga bhagonile, kʉnongwa ye utulo twámɨle twinji mu miiso gaabho. We abhadaamʉsya, bhatakhalɨmanya ɨlya kʉmwamʉla khaala. ");
INSERT INTO mgq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","We ayɨnza winza akha wʉtatʉ, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Mʉlɨ she mugonile utulo na kʉtʉʉzya? Ishi mwagona khayaana. Akhabhalɨlo khaafikha khe ʉMwana wa Muntu atɨlemwe na bhabhomba mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Daamushi, saalɨ tʉsogolaje! Yeenya, ʉla we akʉndonjeelela alɨ papɨɨpɨ.” ");
INSERT INTO mgq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","We uYeesu akʉlonga, ʉYʉʉda, weeka mu bhalandati bhaakwe ishumi na bhabhɨlɨ, akhɨnza peeka nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ bhe bháamɨle na mafwo amapɨtɨ ni nduugu. Ɨmpʉga yɨnɨɨyo yáfumile kʉ bhapɨtɨ abha bhapuutili, ku bhamanyizyi abhɨ ndajɨzyo na kʉ bhasongo abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ɄYʉʉda we atɨmʉlonjeelele, ábhapiiye nzɨɨla ɨshɨlolesyo átɨlɨ, “Ʉla we mwalola namʉtambɨla, mʉkhamanyaje kʉtɨ we wʉʉyo. Mʉkhamʉlemaje na kʉsogola nawo mʉmʉlɨndɨlɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pe ʉYʉʉda we aafikha bhʉʉlo paala, akhalongola akhabhala pe uYeesu áamɨle, akhalonga akhatɨ, “Mwagona Mumanyizyi!” Akhamʉtambɨla. ");
INSERT INTO mgq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe abhantʉ bhaala bhakhamʉlema uYeesu, bhakhamʉlɨndɨɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɨleelo umuntu ʉmo mʉ bhaala bhe bhɨ́mɨlɨɨye papaala peeka nu Yeesu, akhasakʉla ʉmʉfwo waakwe ʉmʉpɨtɨ, akhamʉkhoma na kumudiba ikutwe umubhombi wa mupuutili ʉmʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","UYeesu akhabhabhʉʉzya abhantʉ bhaala akhatɨ, “Khooni khe mwinzile na mafwo amapɨtɨ ni nduugu kʉtɨ mʉndeme ɨne, ngatɨ bhantʉ bhe bhakʉbhala kʉmʉlema umuntu we mufwuli? ");
INSERT INTO mgq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wiila bhʉʉlo naamɨle peeka nɨɨmwe, namanyɨzyaga mwi linga ilyi Nyumba iMfinjile, khooni khe mʉtandemaga? Ɨleelo ziniizi zyabhombekha ɨnga zye zyásimbiilwe mu Wusimbe uWufinjile zɨkwɨle.” ");
INSERT INTO mgq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pe abhalandati bhaakwe bhonti bhe bháamɨle peeka nawo, bhakhamʉlekha, bhakhashɨmbɨla. ");
INSERT INTO mgq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwámɨle nʉ mwana umutunta ʉmo we ákwatile ɨshɨlʉndo, akhamʉlandataga uYeesu. Woope bhakhalɨnga kʉtɨ bhamʉleme. ");
INSERT INTO mgq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ɨleelo ʉweene akhapulumukha kʉ nyoobhe, akhabhaleshela ɨshɨlʉndo shaakwe, akhashɨmbɨla ʉlʉbhɨlo alɨ shitali. ");
INSERT INTO mgq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pe abhantʉ bhaala bhakhamʉtwala uYeesu kwa mupuutili ʉmʉpɨtɨ. Bhakhabhʉngaana papaala abhapɨtɨ abha bhapuutili bhonti, abhasongo, na bhamanyizyi abhɨ ndajɨzyo. ");
INSERT INTO mgq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","UPeeteli akhamʉlandataga uYeesu apatali bhʉʉlo. Akhabhala, akhinjila mukaasi mʉ lʉbhaga lwa mupuutili ʉmʉpɨtɨ. Akhɨɨkhala mumuula peeka na bhalindiilili bha mupuutili ʉmʉpɨtɨ, akhootaga ʉmwoto pa lʉbhʉngo. ");
INSERT INTO mgq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abhapɨtɨ abha bhapuutili nɨ balaaza lyonti ɨlya bhasongo, bhakhanda kwanza uwukeeti ʉwa kʉmʉsɨtaakɨla uYeesu ɨnga bhamʉlonje na kʉmʉgoga, ɨleelo bhatakhawaaga uwukeeti naawumo. ");
INSERT INTO mgq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abhantʉ abhinji bháfumwizye uwukeeti ʉwa kʉmwandɨla ɨlenga uYeesu, ɨleelo uwukeeti waabho wʉkhaleganaga. ");
INSERT INTO mgq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Khabhɨlɨ abhantʉ abhamwabho bhamu bhakhɨmɨɨlɨla kufumwa uwukeeti ʉwɨ lenga. Bhakhalongaga bhakhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ɨtwe twámwimvwizye tʉneetwe umuntu ʉnʉ akʉlonga akʉtɨ, ‘Ɨne ɨntɨpongolanye iNyumba iMfinjile ɨnɨ ye abhantʉ bházenjile. Ɨleelo ɨnhayɨzenga iyinji ku nsiku zɨtatʉ nyeene. Inyumba yɨnɨɨyo te yɨkhazengwe na bhantʉ.’ ” ");
INSERT INTO mgq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Poope na ku liniili bhʉʉlo, uwukeeti waabho wʉtakhɨtɨnhana ngakheeka. ");
INSERT INTO mgq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pe umupuutili ʉmʉpɨtɨ akhɨmɨɨlɨla pɨlongolela pɨ balaaza. Akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Bhʉlɨ, ʉtakwamʉla naalimo? Ʉtakʉlola kʉtɨ abhantʉ bhonti ɨbha bhakufumwa uwukeeti kʉkʉsɨtaaka ɨwe?” ");
INSERT INTO mgq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ɨleelo uYeesu akhapʉʉma mye, atakhalonga izwi naalimo. Umupuutili ʉmʉpɨtɨ akhamʉbhʉzɨɨlɨzya winza akhatɨ, “Bhʉlɨ, ɨwe we we Kilisiti, ʉMwana wa Mʉlʉngʉ, ʉMʉlʉngʉ ʉwa Wumwamu?” ");
INSERT INTO mgq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","UYeesu akhamwamʉla akhatɨ, “Ee! Ɨne ne neene. Khabhɨlɨ ɨmwe mʉtɨmʉlole ʉMwana wa Muntu ayɨkhaaye kʉmbalɨ ɨya kʉndɨɨlo ɨya Mʉlʉngʉ ʉwa makha. Khabhɨlɨ mʉkhayɨmʉlola we akwɨnza mʉ mabhɨngo.” ");
INSERT INTO mgq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pe umupuutili ʉmʉpɨtɨ akhadebulanya amenda gaakwe akhatɨ, “Tʉkwanza bhaashi abhakeeti winza? ");
INSERT INTO mgq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwɨmvwa mʉneemwe amashoolanyo gaakwe! Ishi ɨmwe, mʉkʉtɨ bhʉlɨ?” Abhantʉ bhonti bhakhamʉlonga bhakhatɨ, “Ʉnʉ ayiiye kʉtɨ tʉmʉgoje.” ");
INSERT INTO mgq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pe bhamu bhakhanda kʉmʉswɨla amatɨ, kumugubishila kumiiso na kʉmʉkhoma ni nguumu. Bhakhamʉbhʉʉzya bhakhatɨ, “Tambʉla twenye wumukuwi she waamanya kʉtɨ wu naanu we akʉkhoma!” Bhoope abhalindiilili bhe bháamɨle papaala, bhakhamwega, bhakhamʉkhoma na makoofi. ");
INSERT INTO mgq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mʉ khabhalɨlo khanaakho, uPeeteli áamɨle she alɨ mʉ lʉbhʉngo. Pe akhɨnza ʉmʉlɨndʉ weeka mu bhabhombi abha shantanda abha mupuutili ʉmʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Akhamʉlola uPeeteli akwota ʉmwoto, akhamutina. Akhamʉbhʉʉzya akhatɨ, “Nɨɨwe bhʉʉlo waamɨle peeka nu Yeesu ʉwa ku Naazaleti.” ");
INSERT INTO mgq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ɨleelo uPeeteli akhakhaana akhatɨ, “Ɨne intamanyile. Khabhɨlɨ ɨntakʉzyaganya zɨnɨɨzyo zye ʉkʉlonga khaala!” Akhabhala pa shɨlyango. Mʉ khabhalɨlo khakhaala, ɨnhanda yɨkhabhɨlɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Umubhombi ʉmʉlɨndʉ ʉla akhamʉlola winza uPeeteli, akhanda kʉbhabhʉʉzya abhantʉ bhe bhɨ́mɨlɨɨye paala akhatɨ, “Umuntu ʉnʉ woope alɨ peeka nabho.” ");
INSERT INTO mgq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɨleelo uPeeteli akhakhaana winza. Akhabhalɨlo khakhashɨla khashe bhʉʉlo, abhantʉ bhaala bhe bhɨ́mɨlɨɨye papaala, bhoope bhakhamʉbhʉʉzya uPeeteli bhakhatɨ, “Nalyoli wumuntu ɨwe ʉlɨ peeka nabho, kʉnongwa ye nɨɨwe ufumile kʉ Galɨlaaya.” ");
INSERT INTO mgq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ɨleelo uPeeteli akhanda kutipa na kʉlapa, akhatɨ, “Umuntu ʉnʉ we mʉkʉmʉtekha, ɨne intamumanyile. Ɨne ɨnkʉlonga zya nalyoli, ɨnga ɨnkwanda lɨlenga, ʉMʉlʉngʉ akhandongaje!” ");
INSERT INTO mgq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Panaapo bhʉʉlo, ɨnhanda yɨkhabhɨlɨshɨla akha wʉbhɨlɨ. Mʉ khabhalɨlo khanaakho, uPeeteli akhalɨkʉmbʉkha izwi liila lye uYeesu ámubhuziizye kʉtɨ, “We ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ.” UPeeteli we asɨɨbha zɨnɨɨzyo, akhalɨla, akhiisya amasonzi aminji. ");
INSERT INTO mgq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɨshɨlaabhɨla we kwasha, ɨbalaaza lyonti ɨlya bhapɨtɨ abha bhapuutili, abhasongo, peeka na bhamanyizyi abhɨ ndajɨzyo, bhakhabhʉngaana bhakhɨtɨnhana she bhatɨbhombe nu Yeesu. Pe bhakhamupinya, bhakhamʉtwala kwa Pɨlaato. ");
INSERT INTO mgq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ɄPɨlaato akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Bhʉlɨ, ɨwe we Mwene wa Bhayahuudi?” UYeesu akhamwamʉla akhatɨ, “Weewe walonga kʉtɨ ɨne ne mwene.” ");
INSERT INTO mgq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abhapɨtɨ abha bhapuutili bhakhamʉsɨtaakaga uYeesu kʉtɨ abhombile amabhiibhi aminji bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ɄPɨlaato akhamʉbhʉzɨɨlɨzya winza uYeesu akhatɨ, “Nalyoli ʉtakwamʉla naalimo? Ʉkʉlola wʉneewe she abhantʉ bhakʉkʉsɨtaaka inyinji.” ");
INSERT INTO mgq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ɨleelo uYeesu atakhaamʉla naalimo. ɄPɨlaato akhasyala akhasiime! ");
INSERT INTO mgq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mu shikulukulu ɨshɨ Pasaaka, ʉPɨlaato áamɨle nʉ mwata ʉwa kʉmʉsatʉlɨla ʉmʉkʉngwa weeka we abhantʉ bhakhalaabhaga kʉtɨ asatʉlwe. ");
INSERT INTO mgq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Álɨɨpo umuntu ʉmo ɨtaawa lyakwe bhakhatɨnjɨ ʉBalaaba. Ʉweene ákungiilwe mwɨ jeela peeka na bhamwabho bhe bhábhombile uwulumanyi na kʉgoga abhantʉ mu wulumanyi waabho. ");
INSERT INTO mgq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Abhantʉ abhinji bhakhabhala kwa Pɨlaato, bhakhamʉlaabha kʉtɨ abhasatʉlɨle ʉmʉkʉngwa weeka, shishiila she álʉbhɨɨye kʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ɄPɨlaato akhabhaamʉla akhatɨ, “Bhʉlɨ, mʉkwanza ɨmbasatʉlɨle ʉMwene ʉwa Bhayahuudi?” ");
INSERT INTO mgq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Álonjile shɨnɨɨsho kʉnongwa ye ámanyile kʉtɨ, abhapɨtɨ abha bhapuutili bhamuleetile uYeesu kʉkwakwe kʉnongwa ɨya mwone. ");
INSERT INTO mgq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɨleelo abhapɨtɨ abha bhapuutili bhakhayɨsonjeelezya ɨmpʉga yiila ɨya bhantʉ, pe yɨkhamʉlaabha ʉPɨlaato abhasatʉlɨle ʉBalaaba. ");
INSERT INTO mgq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pe ʉPɨlaato akhabhabhʉzɨɨlɨzya winza akhatɨ, “Ishi leelo, mʉkwanza ɨnhonzye bhʉlɨ nu muntu ʉnʉ we mʉkʉtɨ ʉMwene wa Bhayahuudi?” ");
INSERT INTO mgq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Abhantʉ bhonti bhakhazingula ɨshongo winza bhakhatɨ, “Mʉkhomeele pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ɄPɨlaato akhabhabhʉzɨɨlɨzya akhatɨ, “Atulile zyoni?” Ɨleelo abheene pe bhakhazanzala nhaani kʉshongola bhakhatɨ, “Ɨtwe tʉkʉtɨ mʉkhomeele bhʉʉlo pa shɨkhobhenhanyo.” ");
INSERT INTO mgq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kʉnongwa ye ʉPɨlaato akhanzaga kʉbhomba zye zɨkʉyɨkhobhosya ɨmpʉga ya bhantʉ, akhamʉsatʉlɨla ʉBalaaba. Akhalajɨzya abhasikaali bhaakwe bhamʉkhome uYeesu nɨ sambogo, na kʉmʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abhasikaali bhakhamwega uYeesu, bhakhabhala nawo mwi linga lya mwene. Bhakhabhɨlɨshɨlana ɨmpʉga yonti ɨya bhasikaali, bhakhabhala bhakhabhʉngaana bhonti mumuula. ");
INSERT INTO mgq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakhamʉkwatɨzya uYeesu ɨgolole ishamamizu ɨlya shɨmwene. Bhakhatabha ishipambwi ɨsha mimvwa, bhakhamʉkwatɨzya kwi twe. ");
INSERT INTO mgq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakhatala kʉmʉlamʉkha kʉtɨ, “Waagona, we Mwene wa Bhayahuudi!” ");
INSERT INTO mgq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakhamʉkhomaga pi twe ni lanzi, bhakhamʉswɨlaga amatɨ, bhakhamʉsʉgamɨlɨlaga na kʉmʉsʉlamɨla paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","We bhaamala kʉmʉsʉʉpɨzya, bhakhamʉzʉʉla ʉmwenda umushamamizu wuula na kʉmʉkwatɨzya amenda gaakwe. Bhakhamufumwa kunzi, bhakhasogola nawo kʉbhala kʉmʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","We bhalɨ mwɨ dala, bhakhakhomaana nu muntu we akhashɨlaga, áfumile mu vwizi. Ɨtaawa lyakwe bhakhatɨnjɨ uSiimoni, áamɨle mʉkhaaya wa ku Kileene. Umuntu ʉla áamɨle wu yise wa Alekizanda nu Luufo. Bhakhamubijila kʉtɨ apɨmbe ɨshɨkhobhenhanyo sha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bhakhamʉtwala uYeesu pe bhakhatɨnjɨ pa Goligoota, kwe kʉtɨ, “Pi Fupa ilyi Twe.” ");
INSERT INTO mgq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhakhaamupa uYeesu idivaayi ye bhásanganyiinye ni vintu vwe vɨkʉbhabhaata kʉtɨ amwele, ɨleelo ʉweene akhasiita kʉmwela. ");
INSERT INTO mgq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pe bhakhamʉkhomeela pa shɨkhobhenhanyo paala, bhakhagabhana amenda gaakwe. Bhakhakhoma ɨkʉʉla bhaamʉle kʉtɨ wu naanu atɨyeeje ʉmwenda wulikwi. ");
INSERT INTO mgq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","We bhakʉmʉkhomeela, yáamɨle mʉ saala ɨya wʉtatʉ, ɨshɨlaabhɨla. ");
INSERT INTO mgq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhásimbile pamwanya pa shɨkhobhenhanyo uwusimbe ʉwɨ nongwa yaakwe, wʉkhatɨnjɨ, “Ʉnʉ wʉ Mwene ʉwa Bhayahuudi.” ");
INSERT INTO mgq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhábhakhomeleeye abhabuda bhabhɨlɨ peeka nawo mʉ vɨkhobhenhanyo, weeka kʉmbalɨ ɨya kʉndɨɨlo, ʉwamwabho kʉmbalɨ ɨya kʉmongo.  ");
INSERT INTO mgq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ɨpo pe wʉkhakwɨla uWusimbe uWufinjile we wʉkʉtɨ, “Bhakhamʉbhaazɨzya peeka na bhatʉla nongwa.” ");
INSERT INTO mgq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abhantʉ bhe bhakhashɨlaga paala mwɨ dala, bhakhamuligaga na kuyinzanya amatwe gaabho bhakhatɨnjɨ, “Ɨwe wayɨbaadaga kʉtɨ ʉtɨpongolanye iNyumba iMfinjile na kʉyɨzenga winza ku nsiku zɨtatʉ. ");
INSERT INTO mgq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yɨposhe wʉneewe, yiikha pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bhoope abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo bhonti peeka, bhakhamuliga uYeesu. Bhakhabhʉzanyaaga bheene bhakhatɨnjɨ, “Ana mwebheya, abhapokhaga abhanjɨ, ɨleelo akʉpootwa kʉyɨpokha wʉʉyo! ");
INSERT INTO mgq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bhaatɨ ʉweene akʉyɨtekha akʉtɨ wu Kilisiti, ʉMwene wa Bhaisilaeli. Ishi twenye ayiishe pa shɨkhobhenhanyo, ɨnga tʉlole na kwɨtɨkha kʉmʉsʉʉbhɨla.” Na bhantʉ bhaala bhe bhábhakhomeleeye pa vɨkhobhenhanyo peeka nawo, bhoope bhakhamuliga. ");
INSERT INTO mgq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kufuma mʉ saala ɨya mʉtanda shamʉsanya kufikha mʉ saa tisa, akhiisi khakhagwa mʉ nsɨ yonti. ");
INSERT INTO mgq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","We yaafikha saa tisa, uYeesu akhalɨla kwi zi ɨlya kʉdandɨzya akhatɨ, “Elooyi! Elooyi! Lama sabakitaani?” Kwe kʉtɨ, “We Mʉlʉngʉ waanɨ! We Mʉlʉngʉ waanɨ! Khooni khe wandekha?” ");
INSERT INTO mgq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abhantʉ bhamu bhe bhɨ́mɨlɨɨye papaala, we bhɨmvwa zye uYeesu akʉlonga, bhakhatɨ, “Avwa mwebheya! Akʉmʉbhɨlɨshɨla wu Eliya umukuwi.” ");
INSERT INTO mgq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umuntu ʉmo akhashɨmbɨla nalʉbhɨlo akhabhala akhadumvikha akhagodoolo mu divaayi ye yilulile, akhapinyiila mwi lanzi itali, akhalɨbhʉʉsya kʉmwanya, akhaamupa uYeesu kʉtɨ amwele. Umuntu ʉla akhalonga akhatɨ, “Leshi twenye she uEliya atɨyɨnze kumwisya pa shɨkhobhenhanyo ɨpo!” ");
INSERT INTO mgq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","UYeesu akhakhoola kwi zi ɨlya kʉdandɨzya, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pe ɨgolole lye lyápitulanyiinye aPafinjile na Pafinjile Nhaani mu Nyumba iMfinjile, likhadeebukha pakaasi kufuma pamwanya kwikha paasɨ. ");
INSERT INTO mgq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ʉmʉpɨtɨ wa bhasikaali áyɨmɨlɨɨye pɨlongolela pa Yeesu. We aalola aafwa anza shishiila, akhalonga akhatɨ, “Nalyoli umuntu ʉnʉ aamɨle Mwana wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhálɨɨpo winza abhantanda bhe bhɨ́mɨlɨɨye ukutali bhakhatendeelaga. Mukaasi mʉ bhanaabho, álɨɨpo uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala, ʉSaloome, nu Maliya unyina wa Yaakobo umunsi wa Yoose. ");
INSERT INTO mgq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abhantanda ɨbho bhakhamʉlandataga na kʉmʉbhombela uYeesu mʉ khabhalɨlo khe áamɨle kʉ Galɨlaaya. Bhálɨɨpo papaala na bhantanda abhamwabho abhinji bhʉʉlo bhe bhábhalile peeka nawo ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","We kwapalamɨla shalyabheela, isiku lɨnɨɨlyo lyámɨle lya kʉzɨlɨngaanya ɨmbombo zyonti nzɨɨla. Ɨndaabhɨ yaakwe lyámɨle lisiku lyɨ Sabaato ɨya Bhayahuudi kupuuta na kʉtʉʉzya. We kwatala kʉbha shalyabheela, ");
INSERT INTO mgq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","umuntu ʉmo we bhakhatɨnjɨ uYoosefu, akhayɨgomwa akhabhala kʉmʉlaabha ʉPɨlaato kʉtɨ amwɨtɨshɨzye abhale ayeeje ivimba lya Yeesu, ɨnga alɨsyɨle nalʉbhɨlo. Umuntu ʉyo áamɨle mʉkhaaya wa ku Alimasaaya. Áamɨle weeka mʉ bhapɨtɨ abha Bhayahuudi we abhantʉ bhakhamushindikhaga nhaani mwɨ balaaza ɨpɨtɨ ɨlya Bhayahuudi. Khabhɨlɨ akhagʉlɨlaga akhabhalɨlo khe ʉwʉmwene wa Mʉlʉngʉ wʉkhayɨnza. ");
INSERT INTO mgq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pe ʉPɨlaato we ayɨmvwa kʉtɨ uYeesu aafwa nalʉbhɨlo shɨnɨɨsho, akhaswiga! Akhamʉbhɨlɨshɨla ʉmʉpɨtɨ wa bhasikaali kʉtɨ amusimishizye she uYeesu afuuye nalyoli. ");
INSERT INTO mgq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","We amusimishizya kʉtɨ uYeesu afuuye, ʉPɨlaato akhamwɨtɨshɨzya uYoosefu kwega ivimba. ");
INSERT INTO mgq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pe uYoosefu woope akhakala ikibha ɨlyɨ nhela ɨmpɨtɨ. Akhabhala pa shɨkhobhenhanyo paala, akhalyisya paasɨ ivimba lya Yeesu, akhalizinga ni kibha liila. Akhalɨpɨmba, akhabhala kʉlɨbhɨɨkha ivimba liila mʉ mbɨɨpa ye yábaniilwe mwɨ lyalaawe. Akhalibhungulusya iwe ɨpɨtɨ, akhalɨbhɨɨkha pa mʉlyango wɨ mbɨɨpa, akhadinda. ");
INSERT INTO mgq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Bhoope abha Maliya ʉwa mʉ nhaaya ɨya mu Magidaala nu Maliya unyina wa Yoose, bhakhapalola pe bhamʉsyɨla. ");
INSERT INTO mgq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Isiku ɨlyɨ Sabaato we lyashɨla, uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala, ʉSaloome nu Maliya unyina wa Yaakobo, bhakhakala amafuta ge gakununshiilila kʉtɨ bhabhale bhalɨpashe ivimba lya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bhakhalaabhɨla isiku ɨlya Pamʉlʉngʉ, we ɨzʉbha lyanda kutukula, bhakhalongola ɨdala kʉbhala kʉ mbɨɨpa ya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","We bhakʉjenda mwɨ dala, bhakhanda kʉbhʉzɨlɨzanya bheene kʉtɨ, “Ishi wu naanu we atitubhungulushizye iwe lye lɨlɨ pa mʉlyango pa mbɨɨpa paala?” ");
INSERT INTO mgq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iwe liila lyámɨle lɨpɨtɨ akhapango. Ɨleelo we bhapalamɨla, bhakhatendeela, bhakhalola iwe liila libhungulusye, lɨlɨ pambalɨ. ");
INSERT INTO mgq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","We bhinjila mukaasi mʉ mbɨɨpa, bhakhamʉlola ʉmʉsakhaala ʉmo umutunta we akwatile amenda amazelu. Áyɨkhaaye kʉmbalɨ ɨya kʉndɨɨlo ɨyɨ mbɨɨpa, abhantanda bhaala bhakhagandʉkha nhaani. ");
INSERT INTO mgq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɨleelo umuntu ʉla akhabhabhʉʉzya akhatɨ, “Mʉtagandʉkhaje khaala. Imanyile kʉtɨ mʉkʉmwanza wu Yeesu ʉwa ku Naazaleti we bhaamʉkhomeleeye pa shɨkhobhenhanyo. Azyushile, atalɨɨpo ɨpa khaala! Yeenyi pe bhaamulambalishile. ");
INSERT INTO mgq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ishi bhalaji mʉbhabhʉʉzye abhalandati bhaakwe peeka nu Peeteli bhʉʉlo kʉtɨ, uYeesu abhatangʉlɨɨye kʉbhala kʉ Galɨlaaya. Kukuula kwe mʉtɨmʉlole anza she ábhabhuziizye.” ");
INSERT INTO mgq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","We bhɨmvwa zɨnɨɨzyo, bhakhanda kuyinga kʉ lyoga na kuswiga. Bhakhafuma panzɨ, bhakhasogola pa mbɨɨpa paala kumo bhakʉshɨmbɨla. Bhatakhamʉbhʉʉzya umuntu nʉʉmo kʉnongwa ye bhógopile nhaani.  ");
INSERT INTO mgq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","UYeesu we azyʉkha pi siku ɨlya Pamʉlʉngʉ nakhantandabhɨla, akhamʉloleshela suuti uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala we ámwefwizye amapepu amabhiibhi saba. ");
INSERT INTO mgq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Woope akhabhala kʉbhabhʉʉzya bhaala bhe bháamɨle peeka nu Yeesu. Mʉ khabhalɨlo khanaakho bháamɨle she bhalɨ mu wuswimiilizu na kʉlɨla. ");
INSERT INTO mgq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ɨleelo we bhɨmvwa kwa Maliya kʉtɨ amulolile uYeesu mwumi, bhatakhɨɨtɨkha khaala. ");
INSERT INTO mgq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","We akhabhalɨlo khaashɨla, uYeesu akhabhaloleshela abhalandati bhaakwe bhabhɨlɨ. Akhalolekhaga alɨ shinji bhʉʉlo, bhakhapootwa kʉmʉmanya. Abhalandati bhaakwe bhaala bháamɨle mwɨ dala, bhakhabhalaga mu vwizi. ");
INSERT INTO mgq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bhoope bhakhagalʉkha kʉbhabhʉʉzya abhamwabho, ɨleelo bhoope bhatakhabhɨɨtɨkha khaala. ");
INSERT INTO mgq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kʉwʉmalɨlɨshɨlo, uYeesu akhabhaloleshela abhalandati bhaakwe ishumi na weeka. Bhɨ́khaaye peeka bhakhalyanga ishaakulya. UYeesu akhabhakhajɨla nhaani kʉnongwa ye bhatakhɨɨtɨkha khaala nu wugomu wa mooyo gaabho. Abheene bhákhaanile kʉbhɨɨtɨkha abhamwabho bhe bhámulolile uYeesu kʉtɨ, nalyoli azyushile kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pe akhabhabhʉʉzya akhatɨ, “Ishi bhalaji mʉbhalʉmbɨɨlɨle iNtumi iNyinza abhantʉ abhɨ nsɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Umuntu wowonti ʉla we ayɨɨtɨkha kʉmʉsʉʉbhɨla ʉMʉlʉngʉ na kwozelwa, atɨposheelaje uwuposhi. Ɨleelo umuntu wowonti ʉla we akʉkhaana kʉmʉsʉʉbhɨla ʉMʉlʉngʉ, akhayɨlongwa. ");
INSERT INTO mgq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abhantʉ bhaala bhe bhakwɨtɨkha kʉmʉsʉʉbhɨla ʉMʉlʉngʉ, bhakhayɨbhombaga ɨvɨlolesyo. Bhakhayɨbhɨngaga amapepu amabhiibhi mʉ bhantʉ kwɨ taawa lyanɨ, bhakhayɨlongaga kʉ ndongo impwa. ");
INSERT INTO mgq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Poope ɨnga bhaalema ɨnjokha nɨ nyoobhe, awe poope ɨnga bhamwela akhantʉ khokhonti khe khalɨ nɨ nsalɨle inhali, te yɨkhabhabhombaje naakhamu. Bhakhayɨbhɨɨkhaga ɨnyoobhe zyabho mu bhabhinu, bhoope bhakhayɨponaga.” ");
INSERT INTO mgq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ɄMwene uYeesu we aamala kʉlonga nabho, akheegwa kʉbhala kʉmwanya. Akhɨɨkhala kʉmbalɨ ɨya kʉndɨɨlo kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pe abhalandati bhaakwe bhaala, bhakhasogola paala, bhakhalʉmbɨlɨlaga iNtumi iNyinza poponti. ɄMwene uYeesu akhabhapanga amakha aga kʉbhomba ɨvɨlolesyo. Shɨnɨɨsho she akhagasimishizyaga amazwi gaabho kʉtɨ ga nalyoli.");
INSERT INTO mgq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kʉkwakho wa lushindikho Seofiilo: Abhantʉ abhinji bhasimbile ɨnongwa zya Yeesu Kilisiti anza she zyábhombeshile kʉkwɨtʉ. ");
INSERT INTO mgq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bhasimbile ɨnongwa ziniizi anza she bhátubhuziizye bhaala bhe bhálolile na miiso gaabho na kʉzɨlʉmbɨɨlɨla kufuma pawandɨlo waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ishi nɨɨne naalola kʉtɨ khinza kukusimbila ziniizi zyonti mʉ lʉbhaatɨkho, kʉnongwa ye insimishiziizye akhinza uwanalyoli ʉwɨ nongwa zya Yeesu kufuma kʉwandɨlo, ");
INSERT INTO mgq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ɨnga ʉmanye uwanalyoli ʉwɨ nongwa zye bhakubhuziizye. ");
INSERT INTO mgq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mu nsiku zye uHeloodi áamɨle wʉ mwene mʉ nsɨ ɨya Yudeeya, álɨɨpo umupuutili ʉmo we bhakhatɨnjɨ uZakaliya, kufuma mʉ shɨpʉga ɨsha shipuutili ɨsha Abiya. Ʉmʉshɨ waakwe bhakhatɨnjɨ uElisabeeti, áfumile mʉ shɨkholo ɨsha shipuutili ɨsha Aaloni. ");
INSERT INTO mgq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","UZakaliya nu Elisabeeti bháamɨle bhagolosu pamiiso ga Mʉlʉngʉ, bhakhalandataga akhinza ɨndajɨzyo zyonti ɨzya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bhatáamɨle na bhaana, kʉnongwa ye uElisabeeti áamɨle mʉlʉʉjɨ, khabhɨlɨ bháamɨle bhagoosi. ");
INSERT INTO mgq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Kwámɨle nu wutengulizu ʉwa kʉbhomba ɨmbombo aPafinjile mu Nyumba iMfinjile. Mu wutengulizu wʉnʉʉwo, kháamɨle khabhalɨlo kha shɨpʉga sha Abiya. Isiku limo, abhapuutili abha shɨpʉga shɨnɨɨsho, anza she yáamɨle mwata yaabho, bhakhamʉkhomela ɨkʉʉla uZakaliya kwinjila aPafinjile panaapo apa Mʉlʉngʉ, ɨnga atukulushizye pa shɨgemo ivintu vwe vikununshiilila umununsi umwinza. ");
INSERT INTO mgq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Akhabhalɨlo khe áamɨle mukaasi akutukulushizya, abhantʉ abhinji bháamɨle mwi linga ilyi Nyumba iMfinjile bhakhapuutaga. ");
INSERT INTO mgq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pe ʉkhabhɨzya wa Mwene akhamʉloleshela uZakaliya. Ʉkhabhɨzya wʉnʉʉyo áyɨmɨlɨɨye kʉmbalɨ ɨya kʉndɨɨlo ɨya shɨgemo shiila. ");
INSERT INTO mgq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","UZakaliya we amʉlola ʉkhabhɨzya, ɨlyoga lɨkhamʉlema nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pe ʉkhabhɨzya ʉla akhamʉbhʉʉzya akhatɨ, “Ʉtogopaje Zakaliya, kʉnongwa ye ʉMʉlʉngʉ ayimvwizye impuuto zyakho, ʉmʉshɨ waakho uElisabeeti atɨkʉpaapɨle ʉmwana, ʉmwana wʉnʉʉyo ukhayiimupa ɨtaawa abhe wu Yookhani. ");
INSERT INTO mgq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ɨpo pe ʉkhayɨbha nʉ lʉseshelo na khaluluuto, khabhɨlɨ abhantʉ abhinji bhakhayɨbha nʉ lʉseshelo we apaapwa, ");
INSERT INTO mgq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kʉnongwa ye akhayɨbha nʉ wʉpɨtɨ kufuma kwa Mwene. Ʉmwana wʉnʉʉyo te akhamwelaje akhantʉ khokhonti khe khakʉkhola, lyoli amakha ga Mupepu uMufinjile gakhayɨbha nawo kufuma akhabhalɨlo khe alɨ mʉ lwanda mwa nyina waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Akhayɨbhagalʉsya aBhaisilaeli abhinji kwa Mwene ʉMʉlʉngʉ waabho. ");
INSERT INTO mgq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wʉnʉʉyo akhayɨmʉlongolela ʉMwene mʉ makha nu mupepu anzu mukuwi uEliya. Akhayɨbhɨmvwanyaaga abhapaafi na bhaana bhaabho, khabhɨlɨ akhayɨbhagalʉsyaga bhe bhatakumutinikha ʉMʉlʉngʉ mʉ njeele ɨya wugolosu, na kʉbhalɨngaanya abhantʉ kʉmʉposheela ʉMwene.” ");
INSERT INTO mgq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pe uZakaliya akhamʉbhʉʉzya ʉkhabhɨzya akhatɨ, “Bhʉlɨ, khantʉ khooni khe khanganaavwa kʉmanya kʉtɨ amazwi ganaaga ga wanalyoli? Kʉnongwa ye ɨne nʉ mʉshɨ waanɨ insiku zituushile.” ");
INSERT INTO mgq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","We alonga lɨnɨɨlyo, ʉkhabhɨzya akhamʉbhʉʉzya akhatɨ, “Ɨne ne Gabulieli, ɨnkwɨmɨɨlɨla pamiiso ga Mʉlʉngʉ, ne ansonteleziizye kʉkʉbhʉʉzya ɨwe intumi inyinza ziniizi. ");
INSERT INTO mgq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ishi ʉtɨbhe we shinuunu, kʉnongwa ye ʉtɨɨtɨkha zye nakʉbhʉʉzya. Te ʉlongaje paka isiku lye zikhayifumila ziniizi zye nakʉbhʉʉzya, we akhabhalɨlo khaakwe khaafikha!” ");
INSERT INTO mgq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Akhabhalɨlo khanaakho, abhantʉ bhaala bhe bháamɨle mwi linga, bhakhamʉgʉlɨlaga uZakaliya kumo bhakuswiga, kʉnongwa ye ákhaabhile nhaani aPafinjile mu Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","We aafuma, akhapootwa kʉlonga nabho, pe abheene bhakhamanya kʉtɨ, alolile amayele ge gafumiiye aPafinjile. Ʉweene akhalolesyaga nɨ nyoobhe zye akwanza kʉlonga, akhajendeelela kʉbha wu shinuunu. ");
INSERT INTO mgq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","We insiku zyakwe zyasila ɨzya kʉbhomba ɨmbombo ɨya shipuutili, akhagalʉkha kʉkhaaya. ");
INSERT INTO mgq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pɨlongolela, ʉmʉshɨ waakwe uElisabeeti akhabha pa wumwamu, akhʉʉbha mu nyumba ameezi gasaanʉ. Akhayɨlonjelaga wʉʉyo akhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Liniili lye ʉMwene ambombeeye ɨne, andolile na kʉneefwezya insoni pamiiso ga bhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","We waafikha umwezi ʉwa mʉtanda ʉwa wumwamu wa Elisabeeti, ʉMʉlʉngʉ akhamʉsonteelezya ʉkhabhɨzya uGabulieli mʉ khakhaaya akha mu Naazaleti, khe kháamɨle mʉ mʉkoa ʉwa mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Akhabhala kwa mʉlɨndʉ we bhakhatɨnjɨ uMaliya, we ázinjiliilwe nu Yoosefu ʉwa mʉ shɨkholo sha mwene uDaudi. ");
INSERT INTO mgq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ʉkhabhɨzya we aafikha kwa Maliya akhatɨ, “Ɨnkʉkʉlamʉkha ɨwe we usayiilwe, ʉMwene alɨ nɨɨwe.” ");
INSERT INTO mgq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","UMaliya, we ayɨmvwa amazwi ganaago aga khabhɨzya, ʉmwoyo wʉkheleela nhaani, akhayɨbhʉzɨɨlɨzya akhatɨ, “Ɨndamʉkho ɨnɨ, kwe kʉtɨ bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pe ʉkhabhɨzya akhatɨ, “Maliya, ʉtogopaje, kʉnongwa ye ʉMʉlʉngʉ akupiiye uwiila. ");
INSERT INTO mgq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yeenya, ʉtɨbhe pa wumwamu, ʉtɨpaape ʉmwana ʉmʉsakhaala, ukhayimwita ɨtaawa lyakwe akhayɨbha wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ʉmwana wʉnʉʉyo akhayɨbha mʉpɨtɨ, khabhɨlɨ ɨtaawa lyakwe bhakhayɨtɨnjɨ Mwana wa Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya. ɄMwene ʉMʉlʉngʉ akhayiimupa amakha aga shɨmwene, anza she áamɨle ʉmaama waakwe ʉmwene uDaudi. ");
INSERT INTO mgq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Khabhɨlɨ akhayɨtabhaalaga aBhaisilaeli insiku zyonti, ʉwʉmwene waakwe te wʉkhabhe nu wusililishilo.” ");
INSERT INTO mgq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","UMaliya akhamʉbhʉzɨɨlɨzya ʉkhabhɨzya akhatɨ, “Ɨne ɨntalɨ nʉ mʉlʉme, ishi liniili lɨtɨbhe bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ʉkhabhɨzya akhamwamʉla akhatɨ, “UMupepu uMufinjile atɨkwɨnzɨle, na makha ga Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya gatikugubishile anzɨ shɨnzyʉngʉʉlɨ. Pe ʉmwana we ʉkhayɨpaapa akhayɨbha mufinjile, we bhakhayɨtɨnjɨ ʉMwana wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tejeelezya! Woope ʉnholo waakho uElisabeeti alɨ pa wumwamu, she poope mugoosi. Khabhɨlɨ uwumwamu waakwe wa meezi ʉmʉtanda, we bhatɨnjɨ mʉlʉʉjɨ! ");
INSERT INTO mgq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kʉnongwa ye khatalɨɨpo naakhamu khe khakʉmʉtola ʉMʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pe uMaliya akhatɨ, “Ɨne ne mubhombi wa Mwene, zɨbhe shɨnɨɨsho kʉkwanɨ anza she walonga.” Pe ʉkhabhɨzya akhasogola. ");
INSERT INTO mgq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","We zyashɨla insiku nyishe, uMaliya akhasogola akhalambiine, akhabhala mʉ nhaaya yimo ye yáamɨle mʉ nsɨ ɨya mʉ magamba aga mu Yudeeya. ");
INSERT INTO mgq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kukuula akhinjila mu nyumba ya Zakaliya, akhamʉlamʉkha uElisabeeti. ");
INSERT INTO mgq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","UElisabeeti we ayɨmvwa ɨndamʉkho ya Maliya, ʉmwana akhashimwa mukaasi mʉ lwanda lwakwe. Pe uMupepu uMufinjile akhamʉlongola uElisabeeti, ");
INSERT INTO mgq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","akhadandɨzya kʉlonga akhatɨ, “Usayiilwe ɨwe kʉshɨla abhantanda bhonti, khabhɨlɨ asayiilwe nʉ mwana we ʉtɨpaape. ");
INSERT INTO mgq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ɨne ne naanu ne unyina wa Mwene waanɨ ayinzile kʉkwanɨ? ");
INSERT INTO mgq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","We nɨmvwa izi lyakho, ʉmwana mʉ lwanda lwanɨ aashimwa kʉ lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Usayiilwe ɨwe we uyitishile kʉtɨ zɨnɨɨzyo zye ʉMwene akubhuziizye, zɨtɨbhombeshe.” ");
INSERT INTO mgq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pe uMaliya akhatɨ, “Ɨnkʉmʉpaala ʉMwene, kʉ mwoyo waanɨ wonti. ");
INSERT INTO mgq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ʉmwoyo waanɨ wʉkʉmʉseshela ʉMʉlʉngʉ uMuposhi waanɨ, ");
INSERT INTO mgq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kʉnongwa ye anavwizye mʉ wʉtolwe ɨne numubhombi waakwe. Yeenya, kufuma ishi abhantʉ abha vipaafi vwonti, bhatɨtɨnjɨ ɨne ne mʉsaywa. ");
INSERT INTO mgq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ɄMwene ʉwa makha gonti ambombeeye ɨzya kuswijizya, ɨtaawa lyakwe lifinjile. ");
INSERT INTO mgq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ishisa shaakwe sha vipaafi vwonti, ku bhonti bhe bhakumupuuta. ");
INSERT INTO mgq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɨnyoobhe yaakwe ya makha, yibhombile ɨmbombo ɨmpɨtɨ. Bhe bhalɨ na mabaado mʉ mooyo gaabho, abhasasiizye. ");
INSERT INTO mgq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhapɨtɨ abhefwizye mʉ matengo gaabho aga wʉpɨtɨ, na kʉbhazʉvwa abhatolwe. ");
INSERT INTO mgq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bhe bhalɨ nɨ nzala, abhapiiye ivintu ivwinza, ɨleelo abhɨ shʉʉma ishinji abhabhinjile ɨnyoobhe nyeene. ");
INSERT INTO mgq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Abhavwizye abhabhombi bhaakwe aBhaisilaeli, we akʉkʉmbʉkha ulufingo lwakwe ʉlwa kʉbhalolela ishisa, ");
INSERT INTO mgq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","anza she álonjile kwa maama wɨɨtʉ, uAbulahaamu nɨ shɨkholo shaakwe shonti wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","UMaliya akhɨɨkhala nu Elisabeeti pamu ameezi gatatʉ, pɨlongolela, akhagalʉkha kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","We khaafikha akhabhalɨlo akha kʉpaapa, uElisabeeti akhapaapa ʉmwana ʉmʉsakhaala. ");
INSERT INTO mgq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abhapalamani na bhanholo bhaakwe we bhɨmvwa kʉtɨ ʉMwene amʉloleeye ishisa nhaani, bhakhaseshela peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Isiku ɨlya naane kufuma apaapwe ʉmwana, bhakhɨnza kumutahiili. Bhakhanzaga kuumupa ʉmwana ɨtaawa lya yise waakwe, uZakaliya. ");
INSERT INTO mgq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ɨleelo unyina wa mwana akhabhabhʉʉzya akhatɨ, “Ndaali, ɨtaawa lyakwe atɨbhe wu Yookhani.” ");
INSERT INTO mgq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Abheene bhakhamwamʉla bhakhatɨ, “Mʉ shɨkholo shaakho atalɨɨpo umuntu we alɨ nɨ taawa lɨnɨɨlyo.” ");
INSERT INTO mgq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pe bhakhamʉbhʉzɨɨlɨzya uyise waakwe kʉtɨ akwanza kuumupa ʉmwana ɨtaawa abhe wu naanu. ");
INSERT INTO mgq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","UZakaliya akhalaabha ɨshɨbaabho ɨsha kusimba, akhasimba akhatɨ, “Ɨtaawa lyakwe atɨbhe wu Yookhani.” Abhantʉ bhonti bhakhaswiga. ");
INSERT INTO mgq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Panaapo bhʉʉlo ulumili lwakwe lukhiigukha, akhanda kʉlonga na kʉmʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pe abhapalamani bhonti abha Zakaliya, ɨlyoga lɨkhabhalema. Ɨnongwa ziniizi zɨkhasaata mʉ nsɨ yonti ɨya mʉ magamba aga mu Yudeeya. ");
INSERT INTO mgq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Abhantʉ bhonti bhe bhimvwizye, bhakhasɨɨbhaga mʉ mooyo gaabho kʉtɨ, “Ʉmwana wʉnʉʉnʉ akhayɨbha anza bhʉlɨɨbhʉlɨ?” Bhakhasɨɨbhaga shɨnɨɨsho, kʉnongwa ye bhámanyile kʉtɨ ʉMwene alɨ peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pe amakha ga Mupepu uMufinjile gakhamwɨnzɨla uZakaliya, uyise wa mwana, akhanda kʉkʉwa akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Apalwaje ʉMwene ʉMʉlʉngʉ ʉwa Bhaisilaeli, kʉnongwa ye ayinzile na kʉtʉʉla abhantʉ bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atupiiye uMuposhi ʉwa makha, kufuma mʉ shɨkholo sha mubhombi waakwe uDaudi. ");
INSERT INTO mgq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anza she álonjile kufuma ɨmaandɨ kʉshɨlɨla ku bhakuwi bhaakwe abhafinjile, ");
INSERT INTO mgq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kʉtɨ akhayɨtʉtʉʉla kʉ bhalʉgʉ bhɨɨtʉ, na kufuma mʉ nyoobhe zya bhantʉ bhonti bhe bhatupatile. ");
INSERT INTO mgq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ɄMʉlʉngʉ atʉloleeye ishisa, anza she álapile kʉ bhamaama bhɨɨtʉ, akʉkʉmbʉkha ulufingo lwakwe ulufinjile insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Anza she álapile kwa maama wɨɨtʉ uAbulahaamu, ");
INSERT INTO mgq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kʉtɨ akhayɨtwavwa kʉtʉtʉʉla mʉ nyoobhe zya bhalʉgʉ bhɨɨtʉ, tʉmʉbhombelaje ʉweene sita lyoga, ");
INSERT INTO mgq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mu wufinjile na mu wugolosu mu nsiku zyonti ɨzya wuumi wɨɨtʉ. ");
INSERT INTO mgq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ishi ɨwe mwana waanɨ, bhatɨkʉtekhaje kʉtɨ mukuwi wa Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya, kʉnongwa ye ʉtɨmʉlongolele ʉMwene, ɨnga ʉmʉgombele ʉweene ɨdala, ");
INSERT INTO mgq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kʉbhabhʉʉzya abhantʉ bhaakwe kʉtɨ, bhakʉwaaga uwuposhi kwɨ dala ɨlya kʉtʉʉyɨlwa imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kʉnongwa ye ʉMʉlʉngʉ wɨɨtʉ alɨ ni shisa kʉkwɨtʉ, ʉlʉkhozyo lwakwe kufuma kʉmwanya lwandile kʉtʉlamɨla, ");
INSERT INTO mgq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","twenti twe tʉlɨ mu khiisi akha wufwe, na kʉtʉlongola mwɨ dala ɨlya wutengaanu.” ");
INSERT INTO mgq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pe uYookhani akhajendeelela kʉkʉla, na kwonjela kʉbha nu wudandamazu mʉ mwoyo. We aakʉla, áyɨkhaaye mu shilozu paka akhabhalɨlo khe akhalolekha ku Bhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mʉ khabhalɨlo khe uYookhani ápapiilwe, uKaisaali Augusiti álajiziizye kʉtɨ, abhantʉ bhonti mʉ nsɨ zye akhatabhaalaga, bhabhaazɨwe. ");
INSERT INTO mgq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ɨsensa yɨnɨɨyo ye yáamɨle ya kwanda, yásimbiilwe we uKileniyo akhalongozyaga ʉmʉkoa ʉwa mu Siiliya. ");
INSERT INTO mgq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pe abhantʉ bhonti bhakhabhala kʉbhaazɨwa mʉ khakhaaya mwe sháfumile ɨshɨkholo shaabho. ");
INSERT INTO mgq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","UYoosefu woope akhasogola mʉ khakhaaya akha mu Naazaleti khe kháamɨle mʉ nsɨ ɨya Galɨlaaya. Akhabhala kʉbhaazɨwa mʉ khakhaaya akha mu Beteleheemu ɨya mu Yudeeya, mwe ápapiilwe ʉmwene uDaudi, kʉnongwa ye áamɨle wa shɨkholo sha Daudi. ");
INSERT INTO mgq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ábhalile kʉbhaazɨwa peeka nu Maliya we ámuzinjiiye. Akhabhalɨlo khanaakho uMaliya áamɨle pa wumwamu. ");
INSERT INTO mgq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","We bhalɨ kʉnʉʉkwo, khakhafikha akhabhalɨlo akha Maliya kʉpaapa. ");
INSERT INTO mgq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akhapaapa ʉmwana ʉkhatoote ʉmʉsakhaala, akhamʉkwatɨzya amenda aga mwana ʉmwela. Akhamʉgoneelezya mwi zinga ɨlya kʉlɨɨsɨzya ɨngʼombe, kʉnongwa ye patálɨɨpo apa kʉgona, inyumba ɨzya bhajeni zyízuuye abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Papɨɨpɨ ni Beteleheemu bhálɨɨpo abhadiimi bhe bhakhalɨndɨlɨlaga ɨngoole zyabho uwusiku ku wudiimilo. ");
INSERT INTO mgq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Panaapo ʉkhabhɨzya wa Mwene akhabhaloleshela, ʉlʉkhozyo kufuma kwa Mwene lʉkhabhalamɨla ɨmbalɨ zyonti, bhakhoogopa nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pe ʉkhabhɨzya akhabhabhʉʉzya akhatɨ, “Mʉtogopaje! Tejeelezyi, ɨmbaleteeye intumi inyinza zye zɨtɨɨbhape abhantʉ bhonti ʉlʉseshelo ʉlʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ʉmʉsanyʉʉnʉ mʉ nhaaya ya Daudi apapiilwe uMuposhi kʉnongwa yiinyu, wʉnʉʉyo we wu Kilisiti, ʉMwene. ");
INSERT INTO mgq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ɨshɨlolesyo ɨsha kʉmʉmanya ɨmwe she shi shiishi: mʉtɨmwaje ʉmwana ʉmwela, bhamukwatiziizye amenda aga mwana ʉmwela, agonile mwi zinga ɨlya kʉlɨɨsɨzya ɨngʼombe.” ");
INSERT INTO mgq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Panaapo ʉkhabhɨzya ʉla áamɨle nɨ shɨpʉga ɨshɨpɨtɨ ɨsha bhakhabhɨzya kufuma kʉmwanya, bhakhamʉpaalaga ʉMʉlʉngʉ bhakhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ayɨmɨshɨlwaje ʉMʉlʉngʉ kʉmwanya, uwutengaanu wʉbhe mʉ nsɨ kʉ bhantʉ bhe abhitishile, aabhape uwiila.” ");
INSERT INTO mgq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ʉkhabhɨzya we asogola kʉbhala kʉmwanya, abhadiimi bhaala bhakhabhʉʉzanya bhakhatɨ, “Ishi saalɨ tʉbhale ku Beteleheemu, twenye lye libhombeshile lye ʉMwene atʉbhʉʉzya.” ");
INSERT INTO mgq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pe bhakhabhala nalʉbhɨlo ku Beteleheemu. We bhaafikha pʉʉpo, bhakhamwaga uMaliya nu Yoosefu, nʉ mwana ʉmwela agonile mwi zinga ɨlya kʉlɨɨsɨzya ɨngʼombe. ");
INSERT INTO mgq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","We bhamwenya ʉmwana ʉla, bhakhabhabhʉʉzya abhantʉ intumi zye ʉkhabhɨzya abhabhuziizye kʉ zya mwana wʉnʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bhonti bhe bhímvwizye intumi zye abhadiimi bhaala bhábhabhuziizye, bhakhaswiga. ");
INSERT INTO mgq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ɨleelo, uMaliya akhazɨsɨbhɨɨlɨla zɨnɨɨzyo zyonti na kʉzɨbhɨɨkha mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pɨlongolela, abhadiimi bhaala bhakhagalʉkha kumo bhakʉmwɨmɨkha na kʉmʉpaala ʉMʉlʉngʉ ku zyonti zye bhazyimvwizye na kʉzɨlola, kʉnongwa ye bhakhaaga zɨlɨ shishiila she ʉkhabhɨzya abhabhuziizye. ");
INSERT INTO mgq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","We lyafikha isiku ɨlya naane kufuma ʉmwana apaapwe, akhabhalɨlo akha kumutahiili khakhafikha, bhakhamwita ɨtaawa ɨlya Yeesu. Ɨtaawa liniili ʉkhabhɨzya ámupiiye, unyina waakwe we ashɨɨlɨ kʉbha pa wumwamu. ");
INSERT INTO mgq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","We khaafikha akhabhalɨlo akha Yoosefu nu Maliya kuyizelufwa, anza she ʉMwene álajiziizye mʉ ndajɨzyo zya Moose, bhakhabhala nʉ mwana ku Yelusaleemu ɨnga bhamʉbhɨɨshe kwa Mwene. ");
INSERT INTO mgq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mʉ ndajɨzyo zɨnɨɨzyo ɨzya Mwene yisimbiilwe kʉtɨ, “Ʉmwana wowonti ʉmʉsakhaala we wʉkhatoote, bhamʉbhɨɨkhaje kʉbha mufinjile wa Mwene.” ");
INSERT INTO mgq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Khabhɨlɨ bhakhafumwa imfinjile, ɨnkʉnda zɨbhɨlɨ awe ɨnyaana zɨbhɨlɨ ɨzyɨ nkʉnda anza she yɨkhanzɨwaaga mʉ ndajɨzyo zya Mwene. ");
INSERT INTO mgq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Akhabhalɨlo khanaakho ku Yelusaleemu, álɨɨpo umuntu ʉmo we bhakhatɨnjɨ uSimilyoni. Umuntu ʉyo áamɨle mugolosu, akhalaabhaga insiku zyonti kwa Mʉlʉngʉ na kʉsʉʉbhɨla kwɨnza uKilisiti, we akhayɨbhatʉʉla aBhaisilaeli. Khabhɨlɨ akhalongolwaga nu Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","UMupepu uMufinjile ámubhuziizye kʉtɨ te afwe we ashɨɨlɨ kʉmʉlola uKilisiti wa Mwene. ");
INSERT INTO mgq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pe uMupepu uMufinjile akhamʉlongola uSimilyoni kʉbhala mwi linga ilyi Nyumba iMfinjile. Woope uYoosefu nu Maliya bhakhamʉtwala uYeesu mwi linga liila, kufumwa imfinjile na kʉmʉbhɨɨkha kwa Mwene, anza she yɨkhalajɨlaga mʉ ndajɨzyo zya Moose. ");
INSERT INTO mgq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","USimilyoni akhamwega ʉmwana ʉla akhamʉpakhatɨla, akhamʉpaala ʉMʉlʉngʉ akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ishi Mwene, ɨmbombo yaanɨ yaasila, ʉnɨtɨshɨzye ɨne numubhombi waakho ɨnsogole ku wutengaanu, kʉnongwa ye wabhomba zye wámbuziizye. ");
INSERT INTO mgq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Amiiso gaanɨ gamʉlola uMuposhi, ");
INSERT INTO mgq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","we ʉmʉsabhʉʉye kʉbha Muposhi wa bhantʉ abhɨ nsɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wʉnʉʉnʉ atɨbhe lʉkhozyo ʉlwa kʉmʉlolesya ʉMʉlʉngʉ kʉ bhe te Bhayahuudi, khabhɨlɨ atɨleetaje uwumwamu kʉ bhantʉ bhaakho aBhaisilaeli.” ");
INSERT INTO mgq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Uyise nu nyina wa Yeesu bhakhaswigaga zye uSimilyoni akhalongaga kʉ zya mwana. ");
INSERT INTO mgq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pɨlongolela, uSimilyoni akhabhasaya, akhamʉbhʉʉzya uMaliya akhatɨ, “Ʉmwana wʉnʉʉnʉ abhishiilwe nʉ Mʉlʉngʉ kʉnongwa ya bhantʉ abhinji mʉ nsɨ ɨya Isilaeli, ɨnga bhe bhamʉkhaana bhakhayɨteega, lyoli bhe bhamwɨtɨkha bhakhayɨtʉʉlwa. Ʉweene akhayɨbha shɨlolesyo ɨsha kʉbhasokha abhantʉ, ɨleelo abhantʉ bhakhayɨmʉkhaana. ");
INSERT INTO mgq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɨpo pe ɨzya mukaasi mʉ mooyo gaabho zɨkhayɨbha apazelu. Nɨɨwe, ʉkhayɨvwalala nhaani mʉ mwoyo waakho, ngatɨ wʉvwalale wa mʉfwo ʉmʉpɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Khabhɨlɨ álɨɨpo umukuwi ʉmwantanda we áamɨle mugoosi, bhakhatɨnjɨ ʉHana. Áamɨle mwalɨ wa Fanweli kufuma mʉ shɨkholo sha Asheli. We bhɨɨkhala amanha saba kufuma bheegane, ʉmʉlʉme waakwe akhafwa. ");
INSERT INTO mgq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Akhasyala mʉfwɨle, akhafisya amanha amashumi naane na gani. Akhabhalɨlo khonti khanaakho akhabhanga mwi linga ilyi Nyumba iMfinjile, akhapuutaga na kuyiima kulya shawusiku na shamʉsanya. ");
INSERT INTO mgq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","We uSimilyoni akʉlonga nu Yoosefu nu Maliya, ʉHana áyɨmɨlɨɨye papɨɨpɨ. Pe akhanda kʉmʉpaala ʉMʉlʉngʉ kʉnongwa ya mwana uYeesu, akhasasyaga intumi zyakwe kʉ bhantʉ bhonti bhe bhakhasʉbhɨlaga kʉtɨ ʉMʉlʉngʉ akhayɨbhatʉʉla aBhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","UYoosefu nu Maliya we bhaamala kʉbhomba uwutengulizu wonti anza she zyámɨle mʉ ndajɨzyo zya Mwene, bhakhagalʉkha mʉ khakhaaya khaabho akha mu Naazaleti khe kháamɨle mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ʉmwana akhajendeelela kʉkʉla, akhonjelaga kʉbha na makha nɨ njeele, woope uwiila wa Mʉlʉngʉ wáamɨle peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Amanha gonti abhapaafi bha Yeesu bhakhabhalaga ku Yelusaleemu mʉ khabhalɨlo akhi shikulukulu ɨshɨ Pasaaka. ");
INSERT INTO mgq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","We abha na manha ishumi na gabhɨlɨ, akhabhala na bhapaafi bhaakwe ku Yelusaleemu mu shikulukulu ɨshɨ Pasaaka, anza she yáamɨle mwata yaabho. ");
INSERT INTO mgq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Insiku ɨzya shikulukulu ɨshɨ Pasaaka we zyasila, abhapaafi bhaakwe bhakhanda kʉgalʉkha kʉkhaaya sita kʉmanya kʉtɨ, ʉmwana uYeesu asyalile ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","We bhakʉgalʉkha kʉkhaaya, bhakhasɨɨbhaga kʉtɨ, bhalɨ peeka nu Yeesu mʉ shɨpʉga, bhakhashʉʉla ɨnjendo iyi siku lyeka. Pe bhakhanda kʉmwanza mʉ bhanholo na mu bhamanyani, ");
INSERT INTO mgq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","bhatakhamwaga, bhakhagalʉkha ku Yelusaleemu kumo bhakʉmwanza. ");
INSERT INTO mgq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","We zyashɨla insiku zɨtatʉ, bhakhamwaga mwi linga ilyi Nyumba iMfinjile, ayɨkhaaye na bhamanyizyi abhɨ ndajɨzyo, akʉbhatejeelezya na kʉbhabhʉzɨɨlɨzya ɨmbʉzɨɨlɨzyo. ");
INSERT INTO mgq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bhonti bhe bhakhamʉtejelezyaga, bhakhaswigaga nhaani uwumanyi waakwe nʉ waamʉlo waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Abhapaafi bhaakwe we bhamʉlola, bhakhaswiga nhaani. Pe unyina waakwe akhamʉbhʉʉzya akhatɨ, “Mwana waanɨ, khooni khe watʉbhomba shiniishi? Yeenya! Ɨne nu yise waakho tweleela nhaani kʉkwanza.” ");
INSERT INTO mgq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","UYeesu akhabhaamʉla akhatɨ, “Khooni khe mwananzaga? Mutamanyile kʉtɨ ɨne ɨnkwanzɨwa kʉbha mu nyumba ya yise waanɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɨleelo abhapaafi bhaakwe bhatakhazyaganya zye akhabhabhʉʉzya. ");
INSERT INTO mgq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pe akhagalʉkha na bhapaafi bhaakwe ku Naazaleti, akhabhatinikhaga. Unyina waakwe akhazɨbhɨɨkha ziniizi zyonti mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","UYeesu akhajendeelela kʉkʉla ʉmʉbhɨlɨ nɨ njeele, akhamʉkhondezyaga ʉMʉlʉngʉ na bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wáamɨle mwanha uwi shumi na gasaanʉ kufuma uKaisaali uTibeliyo ayande kʉtabhaala ʉwʉmwene ʉwa Shiluumi. Akhabhalɨlo khanaakho uPontiyo Pɨlaato akhalongozyaga ʉmʉkoa ʉwa Yudeeya, uHeloodi akhalongozyaga ʉmʉkoa ʉwa Galɨlaaya. Khabhɨlɨ uFilipo ʉkhambakʉ waakwe akhalongozyaga ʉmʉkoa ʉwa Ituleeya nʉ wa Tulakooniti, woope uLisaniya áamɨle mulongozi wa mʉkoa ʉwa Abileene. ");
INSERT INTO mgq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","UAanasi nʉ Kayaafa bháamɨle bhapuutili abhapɨtɨ. Akhabhalɨlo khanaakho izwi lya Mʉlʉngʉ lɨkhamwɨnzɨla uYookhani ʉmwana wa Zakaliya, mu shilozu. ");
INSERT INTO mgq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pe akhabhalaga ɨmbalɨ zyonti zye zyámɨle papɨɨpɨ nu lwizi ʉlwa Yoolodani, akhalʉmbɨlɨlaga akhatɨnjɨ abhantʉ bhapɨndʉkhaje, bhazɨlekhaje imbiibhi zyabho na kwozelwa kʉtɨ, ʉMʉlʉngʉ abhatʉʉyɨle imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ziniizi zye zyásimbiilwe ɨmaandɨ mu shitaabu ɨsha mazwi ga mukuwi ʉYeesaya kʉ zya Yookhani kʉtɨ, “Umuntu akʉkhoola mu shilozu akʉtɨ, ‘Linganyaaji ɨdala lya Mwene, golosyaji ɨdala lye atɨshɨle. ");
INSERT INTO mgq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Amakhombe gatifushilwe, amagamba nu tudunyunzu vɨtɨbhe khantelama. Pe pagombaanile patɨgoloshe, amadala aga makhoga gatifushilwe, ");
INSERT INTO mgq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","pe abhantʉ bhonti bhatɨwʉlole uwuposhi wa Mʉlʉngʉ.’” ");
INSERT INTO mgq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abhantʉ abhinji bhakhabhalaga kwa Yookhani kwozelwa, ɨleelo akhabhabhʉzyaga akhatɨnjɨ, “Ɨmwe mʉbhaana bhɨ njokha! Wu naanu we abhasoshile kʉtɨ mʉwʉshɨmbɨle ʉmʉlakha wa Mʉlʉngʉ we wʉkwɨnza? ");
INSERT INTO mgq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ishi bhombaji ɨmbombo inyinza zye zɨkʉlolesya kʉtɨ mulaatile imbiibhi zyinyu zyonti, anzi kwi lye lɨkwela amatunda aminza. Mʉtayɨbaadaje kʉtɨ, ‘Ʉmaama wɨɨtʉ wu Abulahaamu!’ Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, ʉMʉlʉngʉ angakhola kuumupa uAbulahaamu abhazʉkʉlʉ kufuma mʉ mawe ɨga! ");
INSERT INTO mgq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ɄMʉlʉngʉ alinganyiinye ulufundo kʉ bhe bhatalaatile, anzu muntu we alemile intemu akwanza kudiba amazi aga makwi. Ikwi lyolyonti lye lɨtakwela amatunda aminza, atɨlɨtʉʉlɨle na kʉlɨsʉmba mʉ mwoto.” ");
INSERT INTO mgq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pe abhantʉ bhaala bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ishi tʉbhombe lyoni?” ");
INSERT INTO mgq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","UYookhani akhabhaamʉla akhatɨ, “We alɨ na makooti gabhɨlɨ, amʉpanje we atalɨ ni kooti, woope we alɨ ni shaakulya, amʉpanje we atalɨ ni shaakulya.” ");
INSERT INTO mgq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bhoope abhasonshezya nsonho bhe bhínzile kʉtɨ bhoozelwe, bhakhamʉbhʉzɨɨlɨzya uYookhani bhakhatɨ, “Mumanyizyi, nɨɨtwe tʉbhombe lyoni?” ");
INSERT INTO mgq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akhabhabhʉʉzya akhatɨ, “Mʉleshe kʉsonshezya ɨnsonho kʉshɨla zye zibhishiilwe.” ");
INSERT INTO mgq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bhoope abhasikaali bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Nɨɨtwe tʉbhombe lyoni?” Akhabhabhʉʉzya akhatɨ, “Mʉleshe kʉfwʉla ɨnhela zya bhantʉ, awe kwega ku wushevu ʉwa kʉkhopela, lyoli mʉkhobhokhaje na vwe mʉkʉposheela kʉ mbombo yiinyu.” ");
INSERT INTO mgq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Akhabhalɨlo khanaakho abhantʉ bhakhasʉbhɨlaga kwɨnza kwa Kilisiti, pe bhakhasɨɨbhaga kʉtɨ pamu uYookhani we wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pe uYookhani akhabhabhʉʉzya bhonti akhatɨ, “Ɨne ɨnkʉbhoozya ku minzi, ɨleelo akwɨnza umuntu we alɨ na makha kʉnshɨla ɨne, we ɨne ɨntakhondeeye poope kʉbha ne mubhombi ʉwa kʉsatʉla amakhobha gɨ ndaala zyakwe. Wʉnʉʉyo we akhayɨbhoozya kwa Mupepu uMufinjile na kʉ mwoto. ");
INSERT INTO mgq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʉweene akhayɨbhagabhʉlanya abhagolosu na bhabhomba mbiibhi, ngatɨ muntu we akʉkhoma na kʉpementa ɨngano pa shikhomelwi, akʉbhʉngaanɨkha ɨngano na kʉbhɨɨkha mʉ shanga, ɨleelo amampunyunzi akʉpembeelela nʉ mwoto we wutakuzima.” ");
INSERT INTO mgq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ku mazwi ganaago na ganjɨ aminji uYookhani akhabhasokhaga abhantʉ we akʉbhalʉmbɨɨlɨla iNtumi iNyinza. ");
INSERT INTO mgq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pɨlongolela, akhamʉkhajɨla ʉmwene uHeloodi, kʉnongwa ye ámwejile uHelodiya ʉmʉshɨ wa khambakʉ waakwe uFilipo, na ku mbiibhi inyinji zye ábhombile. ");
INSERT INTO mgq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pe uHeloodi akhonjezya uwubhiibhi, akhamʉkʉnga uYookhani mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","UYookhani we ashɨɨlɨ kʉkʉngwa mwɨ jeela, akhabhalɨlo khe akhozyaga abhantʉ abhinji, woope uYeesu akhoozelwa. Pe uYeesu we akupuuta, kʉmwanya kukhiigukha, ");
INSERT INTO mgq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","uMupepu uMufinjile akhamwishila mu shifwani shɨ nkʉnda. Pe izi lya Mʉlʉngʉ kufuma kʉmwanya lɨkhavwɨnha lɨkʉtɨ, “Ɨwe we Mwana waanɨ ʉmʉganwa, we ɨnkʉkʉseshela.” ");
INSERT INTO mgq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","UYeesu we akwanda ɨmbombo yaakwe, áamɨle na manha ge gáfishiiye amashumi gatatʉ. Abhantʉ bhakhasɨɨbhaga kʉtɨ áamɨle mwana wa Yoosefu. UYoosefu áamɨle mwana wa Eli, ");
INSERT INTO mgq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","uEli áamɨle mwana wa Masaati, uMasaati áamɨle mwana wa Laawi, uLaawi áamɨle mwana wa Meeliki, uMeeliki áamɨle mwana wa Yanaayi, uYanaayi áamɨle mwana wa Yoosefu, ");
INSERT INTO mgq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","uYoosefu áamɨle mwana wa Matasiya, uMatasiya áamɨle mwana wa Amosi, uAmosi áamɨle mwana wa Nahuumu, uNahuumu áamɨle mwana wa Esili, uEsili áamɨle mwana wa Nagaayi, ");
INSERT INTO mgq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","uNagaayi áamɨle mwana wa Maasi, uMaasi áamɨle mwana wa Matasiya, uMatasiya áamɨle mwana wa Semeini, uSemeini áamɨle mwana wa Yooseki, uYooseki áamɨle mwana wa Yooda, ");
INSERT INTO mgq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ʉYooda áamɨle mwana wa Yoanani, uYoanani áamɨle mwana wa Leesa, ʉLeesa áamɨle mwana wa Zelubabeli, uZelubabeli áamɨle mwana wa Shealitiyeeli, uShealitiyeeli áamɨle mwana wa Neeli, ");
INSERT INTO mgq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","uNeeli áamɨle mwana wa Meeliki, uMeeliki áamɨle mwana wa Adi, uAdi áamɨle mwana wa Kosamu, uKosamu áamɨle mwana wa Elimadamu, uElimadamu áamɨle mwana wa Eli, ");
INSERT INTO mgq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","uEli áamɨle mwana wa Yoshua, uYoshua áamɨle mwana wa Eliezeli, uEliezeli áamɨle mwana wa Yoolimu, uYoolimu áamɨle mwana wa Masaati, uMasaati áamɨle mwana wa Laawi, ");
INSERT INTO mgq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","uLaawi áamɨle mwana wa Similyoni, uSimilyoni áamɨle mwana wa Yʉʉda, ʉYʉʉda áamɨle mwana wa Yoosefu, uYoosefu áamɨle mwana wa Yoonamu, uYoonamu áamɨle mwana wa Eliakimu, ");
INSERT INTO mgq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","uEliakimu áamɨle mwana wa Meleeya, ʉMeleeya áamɨle mwana wa Meena, ʉMeena áamɨle mwana wa Mataasa, ʉMataasa áamɨle mwana wa Naasani, uNaasani áamɨle mwana wa Daudi, ");
INSERT INTO mgq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","uDaudi áamɨle mwana wa Yeese, ʉYeese áamɨle mwana wa Obedi, uObedi áamɨle mwana wa Boazi, uBoazi áamɨle mwana wa Salimoni, uSalimoni áamɨle mwana wa Naashoni, ");
INSERT INTO mgq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","uNaashoni áamɨle mwana wa Aminadaabu, uAminadaabu áamɨle mwana wa Adimiini, uAdimiini áamɨle mwana wa Aalamu, uAalamu áamɨle mwana wa Hezelooni, uHezelooni áamɨle mwana wa Peleesi, uPeleesi áamɨle mwana wa Yʉʉda, ");
INSERT INTO mgq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ʉYʉʉda áamɨle mwana wa Yaakobo, ʉYaakobo áamɨle mwana wa Isaaka, uIsaaka áamɨle mwana wa Abulahaamu, uAbulahaamu áamɨle mwana wa Teela, ʉTeela áamɨle mwana wa Nahooli, ");
INSERT INTO mgq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","uNahooli áamɨle mwana wa Seluugi, uSeluugi áamɨle mwana wa Lagau, uLagau áamɨle mwana wa Peleegi, uPeleegi áamɨle mwana wa Ebeli, uEbeli áamɨle mwana wa Saala, ");
INSERT INTO mgq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ʉSaala áamɨle mwana wa Keenani, uKeenani áamɨle mwana wa Alufakisadi, uAlufakisadi áamɨle mwana wa Sheemu, uSheemu áamɨle mwana wa Noowa, ʉNoowa áamɨle mwana wa Laameki, ");
INSERT INTO mgq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","uLaameki áamɨle mwana wa Mesuseela, uMesuseela áamɨle mwana wa Enoki, uEnoki áamɨle mwana wa Yaaledi, uYaaledi áamɨle mwana wa Mahalaleeli, uMahalaleeli áamɨle mwana wa Keenani, ");
INSERT INTO mgq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","uKeenani áamɨle mwana wa Enoshi, uEnoshi áamɨle mwana wa Seeti, uSeeti áamɨle mwana wa Adamu, woope uAdamu áamɨle mwana wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","UYeesu akhasogola pa lwizi ʉlwa Yoolodani, akhalongolwaga nu Mupepu uMufinjile. UMupepu uMufinjile akhamʉtwala mu shilozu. ");
INSERT INTO mgq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kukuula akhalɨngwa nu Seetani insiku amashumi gani. Insiku zyonti zɨnɨɨzyo atáliiye naakhamu, kʉ khabhalɨlo khanaakho ɨnzala yikhamuluma. ");
INSERT INTO mgq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pe uSeetani akhamʉbhʉʉzya uYeesu akhatɨ, “Ɨnga ɨwe we Mwana wa Mʉlʉngʉ, lɨbhʉʉzye iwe ili lɨgalʉnhane lɨbhe likaati.” ");
INSERT INTO mgq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","UYeesu akhamwamʉla akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ʉwʉpʉʉma wa muntu wutakufumilana ni shaakulya sheene.’” ");
INSERT INTO mgq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pe uSeetani akhamʉtwala uYeesu pamu pe palɨ pamwanya nhaani, akhamʉlanga ʉwʉmwene ʉwɨ nsɨ zyonti kʉ khabhalɨlo khashe. ");
INSERT INTO mgq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","USeetani akhatɨ, “Ɨne intiikupe ʉwaamʉlo ʉwa wʉmwene uwu wonti nɨ togo lyakwe, ɨnga wansʉgamɨlɨla na kumpuuta, kʉnongwa ye viniivi vwonti vwanɨ, nɨɨne inkuumupa umuntu wowonti kʉ shɨgane shaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","UYeesu akhamwamʉla akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Umupuutaje ʉMwene ʉMʉlʉngʉ waakho, khabhɨlɨ ʉmʉbhombelaje wʉʉyo mwene.’” ");
INSERT INTO mgq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pe uSeetani akhamʉtwala uYeesu ku Yelusaleemu, akhamwɨmɨɨlɨsya pa ndʉngo iyi Nyumba iMfinjile, akhamʉbhʉʉzya akhatɨ, “Ɨnga ɨwe we Mwana wa Mʉlʉngʉ, yɨsʉmbe paasɨ kufuma panaapa. ");
INSERT INTO mgq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘ɄMʉlʉngʉ atɨbhasonteelezye abhakhabhɨzya bhaakwe, bhakʉlɨndɨɨlɨle,’ ");
INSERT INTO mgq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","khabhɨlɨ, ‘Bhatɨkʉtone mʉ nyoobhe zyabho, ɨnga ɨvɨnama vwakho vɨtakhakhomele mʉ mawe.’” ");
INSERT INTO mgq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","UYeesu akhamwamʉla akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ʉtamʉlɨngaje ʉMwene ʉMʉlʉngʉ waakho.’” ");
INSERT INTO mgq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","USeetani akhamʉlekha uYeesu kʉ khabhalɨlo we aamala kʉmʉlɨnga kʉ madala ganaago gonti. ");
INSERT INTO mgq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pe uYeesu akhagalʉkha mʉ Galɨlaaya, alɨ na makha ga Mupepu uMufinjile. Intumi zyakwe zɨkhasaata mʉ nhaaya zyonti impalamani. ");
INSERT INTO mgq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Akhamanyɨzyaga mu masinagoogi gaabho, na bhantʉ bhonti bhe bhámutejeleziizye bhakhamʉpaalaga. ");
INSERT INTO mgq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Isiku limo, uYeesu akhafikha mu Naazaleti, akhakhaaya khe ákʉlɨɨye. Isiku ɨlyɨ Sabaato akhinjila mwi sinagoogi anza she yáamɨle mwata yaakwe. Akhɨmɨɨlɨla kʉtɨ abhaazye uWusimbe uWufinjile. ");
INSERT INTO mgq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bhakhaamupa ishitaabu ɨsha mukuwi ʉYeesaya, akhagubula pa wusimbe we wʉkʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“UMupepu wa Mwene alɨ peeka nɨɨne, kʉnongwa ye ʉMʉlʉngʉ ansebhile kʉbhalʉmbɨɨlɨla abhapɨɨna iNtumi iNyinza. Ansonteleziizye kʉbhabhʉʉzya bhe bhalɨ mwɨ jeela, intumi ɨzya kʉsatʉlwa kwabho, na bhe bhatakʉlola, intumi ɨzya kʉlola winza. Ansonteleziizye kʉbhapokha bhe bhakʉbhonelwa, ");
INSERT INTO mgq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kʉmanyɨsya akhabhalɨlo khe ʉMwene atɨyɨnze kʉbhasaya abhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","We abhaazya, akhagubishila ishitaabu shiila, akhamʉgalʉshɨzya umubhombi uwi sinagoogi, akhɨɨkhala ɨnga ayande kʉmanyɨzya. Abhantʉ bhonti bhe bháamɨle mu nyumba yiila bhakhamʉtontomela na miiso. ");
INSERT INTO mgq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pe akhanda kʉbhamanyɨzya akhatɨ, “Ziniizi zye mwazyɨmvwa ɨnkʉbhaazya mu Wusimbe uWufinjile, ʉmʉsanyʉʉnʉ zyakwɨla.” ");
INSERT INTO mgq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bhonti bhakhamʉpaala nhaani, bhakhaswiga ku mazwi aga lʉsayo ge álonjile, bhakhatɨ, “Bhʉlɨ, wʉnʉʉnʉ te mwana wa Yoosefu?” ");
INSERT INTO mgq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","UYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli mʉtɨmbʉʉzye ku miibhikho kʉtɨ, ‘Ɨwe mʉganga, yɨponɨe wʉneewe!’ Kwe kʉtɨ, ɨmbombo zye tuzyimvwizye ubhombile mʉ khakhaaya akha mu Kapelenaumu, ishi ʉbhombe na panaapa pa khakhaaya akha papiinyu wʉneewe.” ");
INSERT INTO mgq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akhajendeelela kʉlonga akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, abhantʉ bhakumushindikha umukuwi ukunji kwonti, ɨleelo abha mʉ nhaaya yaakwe bhatakumushindikha. ");
INSERT INTO mgq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mu nsiku ɨzya mukuwi uEliya, imvula yitátoonyile amanha gatatʉ na meezi ʉmʉtanda, ɨnzala ɨmpɨtɨ yɨkhagwa mʉ nsɨ yonti ɨya mu Isilaeli. Nalyoli ɨnkʉbhabhʉʉzya, akhabhalɨlo khanaakho bhálɨɨpo abhafwɨle abhinji mʉ nsɨ yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɨleelo ʉMʉlʉngʉ atámusonteleziizye uEliya kwa mʉfwɨle ngaweeka mʉ bhanaabho abha mu Isilaeli, lyoli ámusonteleziizye kwa mʉfwɨle ʉwa mʉ khakhaaya akha mu Saleeputa, mʉ nsɨ ɨya mu Sidooni. ");
INSERT INTO mgq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Khabhɨlɨ mu nsiku ɨzya mukuwi uElisha, bhálɨɨpo abhantʉ abhinji abhɨ mpʉngo ɨya maketa mʉ nsɨ ɨya mu Isilaeli. Ɨleelo atálɨɨpo ngaweeka we ásatushile, lyoli uNaamani mwene we áfumile mʉ nsɨ ɨya mu Siiliya.” ");
INSERT INTO mgq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Abhantʉ bhonti bhe bháamɨle mwi sinagoogi, we bhɨmvwa amazwi ganaago, bhakhaviitwa nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pe bhakhɨmɨɨlɨla, bhakhamufumwa uYeesu mʉ khakhaaya khaabho khe kháamɨle pamwanya pa khagamba. Bhakhanzaga kumubunshiilila kʉ nkʉʉkha ɨnga alendele paasɨ, afwe. ");
INSERT INTO mgq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ɨleelo ʉweene akhashɨla pakaasi yaabho, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pɨlongolela, uYeesu akhabhala mʉ nhaaya ɨya mu Kapelenaumu, ye yáamɨle mʉ nsɨ ɨya mʉ Galɨlaaya. Isiku ɨlyɨ Sabaato, akhinjila mwi sinagoogi, akhanda kʉmanyɨzya abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Abhantʉ bhakhaswiga nhaani nɨ manyɨzyo zyakwe, kʉnongwa ye akhamanyɨzyaga ngatɨ muntu ʉwa waamʉlo. ");
INSERT INTO mgq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mwi sinagoogi liila, álɨɨpo umuntu uwi pepu ibhiibhi. Akhakhoola kwi zi ɨlya kʉdandɨzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tʉlɨ na khooni nɨɨwe Yeesu Munaazaleti? Kwe kʉtɨ uyinzile kʉtʉnanganya? Inkumanyile kʉtɨ ɨwe we naanu, ɨwe we Mufinjile wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","UYeesu akhalɨkhajɨla ipepu liila akhatɨ, “Pʉʉma! Fuma mwa muntu ʉnʉ!” Pe ipepu liila likhamugwisya umuntu ʉla pɨlongolela yaabho, likhafuma sita kʉmʉvwalazya. ");
INSERT INTO mgq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abhantʉ bhonti bhakhaswiga nhaani, bhakhazabhanaga bheene bhakhatɨnjɨ, “Ziniizi zya kuswijizya nhaani! Umuntu ʉnʉ akʉbhɨnga amapepu amabhiibhi kʉ makha nʉ waamʉlo, goope gakufuma!” ");
INSERT INTO mgq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Intumi zya Yeesu zɨkhasaata mʉ nsɨ yiila yonti. ");
INSERT INTO mgq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","UYeesu akhafuma mwi sinagoogi, akhabhala mu nyumba ya Siimoni. We aafikha, akhamʉlola ʉnyavwala wa Siimoni abhinile ɨnzegema nhaani, bhakhamʉlaabha uYeesu amwavwe. ");
INSERT INTO mgq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pe akhɨmɨɨlɨla papɨɨpɨ nu mubhinu, akhayɨkhajɨla ɨnzegema yiila. Panaapo umubhinu akhapona, akhɨmɨɨlɨla na kʉlɨngaanya ishaakulya kʉnongwa yaabho. ");
INSERT INTO mgq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ɨzʉbha we lyaswa, abhantʉ bhonti bhe bháamɨle na bhabhinu abhɨ mpʉngo ɨzya vɨkholo ivwinji, bhakhamʉtwalɨla uYeesu abhabhinu bhaabho. Ʉweene akhabhapalamansyaga bhonti, akhabhaponɨaga. ");
INSERT INTO mgq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Khabhɨlɨ akhabhɨngaga amapepu amabhiibhi, gakheepaga kʉ bhantʉ abhinji, kumo gakʉlwetaana gakhatɨnjɨ, “Ɨwe we Mwana wa Mʉlʉngʉ!” Kʉnongwa ye gámumanyile kʉtɨ we wu Kilisiti, uYeesu akhagakhaanaga kʉtɨ gatalongaje izwi lyolyonti. ");
INSERT INTO mgq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ɨndaabhɨ yaakwe we kwasha, uYeesu akheepa mʉ nhaaya yiila akhabhala pamu pe patalɨ na bhantʉ. Ɨmpʉga ɨmpɨtɨ ɨya bhantʉ bhakhanda kʉmwanza, bhakhafikha pe áamɨle. We bhamʉlola, bhakhalɨnga kumudinda kʉtɨ atasogolaje. ");
INSERT INTO mgq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɨleelo ʉweene akhabhabhʉʉzya akhatɨ, “Ɨnkwanzɨwa kʉlʉmbɨɨlɨla iNtumi iNyinza ɨzya wʉmwene wa Mʉlʉngʉ mʉ nhaaya izinji, kʉnongwa yɨnɨɨyo ye ʉMʉlʉngʉ ansonteleziizye kʉbhomba.” ");
INSERT INTO mgq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pe uYeesu akhabhala mʉ nhaaya nɨɨzyo nɨɨzyo ɨzya mʉ Galɨlaaya, akhalʉmbɨlɨlaga mu masinagoogi. ");
INSERT INTO mgq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Isiku limo, uYeesu áyɨmɨlɨɨye pambalɨ pa sʉmbɨ ʉwa Genezaleeti, akhamanyɨzyaga izwi lya Mʉlʉngʉ. Abhantʉ abhinji bhakhamubijilizyaga we bhakʉsejeelela kʉkwakwe kʉtejeelezya izwi lya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","UYeesu akhavɨlola ɨvɨtʉʉlɨ vɨbhɨlɨ pambalɨ pa sʉmbɨ, abhazʉbhʉla nswi abhanensho abha vɨtʉʉlɨ viila bhatálɨɨpo, kʉnongwa ye bháamɨle kwozya inyaavu zyabho. ");
INSERT INTO mgq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","UYeesu akhinjila mʉ shɨtʉʉlɨ sheeka, she sháamɨle sha Siimoni. Akhamʉlaabha uSiimoni ashɨsejeelezye khashe mukaasi mwa sʉmbɨ, pe uYeesu akhɨɨkhala mʉ shɨtʉʉlɨ, akhamanyɨzyaga ɨmpʉga ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","We aamala kʉmanyɨzya, akhamʉbhʉʉzya uSiimoni akhatɨ, “Twala ɨshɨtʉʉlɨ pe pibhiiye, pe mwisye inyaavu zyinyu, mʉzʉbhʉle inswi.” ");
INSERT INTO mgq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","USiimoni akhamwamʉla uYeesu akhatɨ, “We Mʉpɨtɨ, tubhombile ɨmbombo ɨya kʉzʉbhʉla wusiku wonti, tutakhaajile naakhamu. Ishi, pe walonga weewe, intiyiisye inyaavu.” ");
INSERT INTO mgq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","USiimoni na bhamwabho bhakhiisya inyaavu zyabho. We bhiisya, inswi inyinji nhaani zɨkhalemwa, inyaavu zɨkhanda kʉdadʉkha. ");
INSERT INTO mgq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pe bhakhabhapalɨzya abhamwabho bhe bháamɨle mʉ shɨtʉʉlɨ ɨsha wʉbhɨlɨ, kʉtɨ bhɨnze kʉbhaavwa. We bhɨnza, bhakhiizuzya inswi ɨvɨtʉʉlɨ vwonti vɨbhɨlɨ, inswi zyámɨle nyinji nhaani paka ɨvɨtʉʉlɨ vɨkhanzaga kuswibha. ");
INSERT INTO mgq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","USiimoni Peeteli we aalola zɨnɨɨzyo, akhasʉgamɨla pa Yeesu akhatɨ, “We Mwene, ɨnkʉlaabha ʉyeepe papaanɨ, kʉnongwa ye ɨne ne mʉbhomba mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","USiimoni álonjile zɨnɨɨzyo, kʉnongwa ye ʉweene na bhanjɨ bhonti bhe bháamɨle peeka, bhakhaswiga nhaani ku winji wi nswi zye bházʉbhʉʉye. ");
INSERT INTO mgq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bhoope abhaana bha Zebedaayo, ʉYaakobo nu Yookhani, bhe bhakhavwanaga nu Siimoni, bhakhaswiga nhaani. Pe uYeesu akhamʉbhʉʉzya uSiimoni akhatɨ, “Siimoni ʉtogopaje, kufuma ʉmʉsanyʉʉnʉ ɨntɨkʉbhɨɨshe kʉtɨ ʉzʉbhʉlaje abhantʉ na kʉbhaleeta kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pe bhakhavɨtwala ɨvɨtʉʉlɨ vwabho pambalɨ pa sʉmbɨ, bhakhavɨlekha panaapo vwonti, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isiku limo, uYeesu akhinjila mʉ nhaaya yimo, mʉnʉʉmwo álɨɨpo umuntu ʉwa maketa mʉbhɨlɨ wonti. Umuntu ʉla we amʉlola uYeesu, akhagwa shikupama paasɨ, pe akhamʉlamba akhatɨ, “Mwene, ɨnga uyiganile, ʉnsatʉle.” ");
INSERT INTO mgq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","UYeesu akhagolosya ɨnyoobhe yaakwe, akhamʉpalamansya akhatɨ, “Injiganile kʉtɨ ʉpone, ʉsatʉshe.” Akhabhalɨlo khanaakho amaketa gakhamwepa mʉ mʉbhɨlɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Akhamʉsokha umuntu ʉla akhatɨ, “Ʉtakhasheele kʉmʉbhʉʉzya umuntu wowonti ʉla ziniizi. Lyoli bhalaga ʉyɨlolesye kwa mupuutili, ʉbhale ufumwe imfinjile ɨzya kʉsatʉlwa kwakho zye ʉMoose álajiziizye, ɨnga abhantʉ bhonti bhazɨlole ɨmbombo zya Mʉlʉngʉ zye abhomba kʉkwakho.” ");
INSERT INTO mgq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ɨleelo intumi zya Yeesu zɨkhonjela kʉvwɨnha ɨmbalɨ zyonti. Abhantʉ abhinji bhakhabhʉngaanaga kʉmʉtejeelezya, akhabhaponɨaga ɨmpʉngo zyabho. ");
INSERT INTO mgq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ɨleelo ʉweene akhabhalaga kupuuta ukutali kwe kutali na bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Isiku limo, uYeesu akhamanyɨzyaga abhantʉ. Mʉ bhanaabho bhálɨɨpo aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo zya Moose, kufuma mʉ tʉkhaaya twonti ʉtwa mʉ Galɨlaaya na mu Yudeeya, na mʉ nhaaya ɨya Yelusaleemu. Amakha ga Mwene gáamɨle peeka nawo kʉbhaponɨa abhabhinu. ");
INSERT INTO mgq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pe bhakhɨnza abhantʉ bhamu, bhámupimbile mʉ shɨlɨlɨ umuntu we áamɨle nu wubhinu ʉwa kufwa kʉndwɨmo, bhakhanzaga kumwinjizya mu nyumba kʉtɨ bhamʉbhɨɨshe pa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ɨleelo bhakhapootwa kumwinjizya umubhinu ʉla pa shɨlyango, kʉnongwa ye abhantʉ bhizuuye nhaani. Pe bhakhazʉbha kʉ shɨsonyonje ishi nyumba, bhakhadobhola ɨshɨsonyonje. Bhakhamwisya we álemaaye mʉ shɨlɨlɨ, pakaasi pe uYeesu áamɨle. ");
INSERT INTO mgq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","UYeesu we alʉlola ʉlwɨtɨkho lwabho, akhamʉbhʉʉzya umubhinu ʉla akhatɨ, “Manyani, utuyiliilwe imbiibhi zyakho.” ");
INSERT INTO mgq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pe abhamanyizyi abhɨ ndajɨzyo na Bhafalisaayi bhaala bhakhanda kʉyɨbhʉzɨɨlɨzya kʉtɨ, “Ishi wʉnʉʉnʉ wu naanu, we akʉmʉshoolanya ʉMʉlʉngʉ? Atalɨɨpo umuntu we angabhatʉʉyɨla abhantʉ imbiibhi, lyoli wʉ Mʉlʉngʉ mwene.” ");
INSERT INTO mgq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zye bhakhayɨbhʉzɨlɨzyaga, uYeesu akhazɨmanya, pe akhabhabhʉzɨɨlɨzya akhatɨ, “Khooni khe mʉkʉsɨɨbha ziniizi mʉ mooyo giinyu? ");
INSERT INTO mgq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ishi lyoni lye lipupuusu nhaani: kʉmʉbhʉʉzya umuntu ʉnʉ we alemaaye kʉtɨ, ‘Imbiibhi zyakho zituyiliilwe,’ awe kʉtɨ, ‘Yɨmɨɨlɨla, jendaga’? ");
INSERT INTO mgq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ishi leelo ɨnkwanza ɨmbalanje kʉtɨ, ʉMwana wa Muntu alɨ nʉ waamʉlo ʉwa kʉbhatʉʉyɨla imbiibhi abhantʉ mʉ nsɨ.” Pe uYeesu akhamʉbhʉʉzya umuntu ʉla we alemaaye akhatɨ, “Ɨnkʉkʉbhʉʉzya ɨnkʉtɨ yɨmɨɨlɨla, yeega ɨshɨlɨlɨ shaakho, bhalaga kʉkhaaya.” ");
INSERT INTO mgq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Panaapo umuntu ʉla akhɨmɨɨlɨla pamiiso gaabho, akheega ɨshɨlɨlɨ shaakwe, akhasogola akhagalʉkha kʉkhaaya kʉkwakwe kumo akʉmʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pe bhonti bhakhaswiga na kʉmʉpaala ʉMʉlʉngʉ, bhakhabha nɨ lyoga nhaani, bhakhatɨ, “Ʉmʉsanyʉʉnʉ twazɨlola ɨzya kuswijizya!” ");
INSERT INTO mgq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pɨlongolela, uYeesu akhasogola paala pe áamɨle, akhamʉlola ʉmʉsonshezya nsonho ʉmo, we bhakhatɨnjɨ uLaawi, ayɨkhaaye mu ofesi yaakwe ɨya kʉsonshezya ɨnsonho. UYeesu akhamʉbhʉʉzya akhatɨ, “Ndandataje.” ");
INSERT INTO mgq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nalʉbhɨlo, uLaawi akhavɨlekha vwonti, akhanda kʉmʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pɨlongolela, uLaawi akhamʉbhɨɨshɨla uYeesu ishikulukulu mu nyumba yaakwe. Panaapo páamɨle nɨ shɨpʉga ɨshɨpɨtɨ ɨsha bhasonshezya nsonho na bhantʉ abhanjɨ abhinji. ");
INSERT INTO mgq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pe aBhafalisaayi na bhamanyizyi bhaabho abhɨ ndajɨzyo bhakhanda kuyibhuna ku bhalandati bha Yeesu bhakhatɨnjɨ, “Khooni khe mukulya na kʉmwela peeka na bhasonshezya nsonho na bhabhomba mbiibhi?” ");
INSERT INTO mgq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","UYeesu akhabhaamʉla akhatɨ, “Abhantʉ bhe bhatabhinile bhatakʉmwanza ʉmʉganga, lyoli bhe bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɨne intínzile kʉbhanza bhe bhakʉyɨlola kʉtɨ bhagolosu, lyoli nínzile kʉbhanza abhabhomba mbiibhi, kʉtɨ bhalaataje.” ");
INSERT INTO mgq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Abhantʉ bhaala bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Abhalandati bha Yookhani na bhalandati bha Bhafalisaayi bhalɨ nɨ mwata ɨya kuyiima kulya insiku zimo, kʉtɨ bhayɨbhɨɨshe mu mpuuto. Ɨleelo abhalandati bhaakho bhakulya na kʉmwela insiku zyonti!” ");
INSERT INTO mgq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","UYeesu akhabhaamʉla akhatɨ, “Abhantʉ bhe bhalanjiliilwe ku weeji, bhangayiima kulya anza bhʉlɨɨbhʉlɨ, we bhalɨ peeka nʉ wa weeji? ");
INSERT INTO mgq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ɨleelo mu nsiku zye zɨkwɨnza, we abhalʉgʉ bhamwefwa ʉwa weeji pakaasi yaabho, akhabhalɨlo khanaakho bhakhayiyiima kulya.” ");
INSERT INTO mgq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Khabhɨlɨ akhabhaamʉla kʉ shɨkholanyo akhatɨ, “Atalɨɨpo umuntu we akudeebula ɨshɨpaatɨkho mʉ mwenda umupwa, kʉtɨ asoneele mʉ mwenda ʉmʉkʉʉlʉ. Ɨnga akhonzya shɨnɨɨsho, we ananganya ʉmwenda umupwa. Peeka na shɨnɨɨsho, ɨshɨpaatɨkho shiila shɨtakʉkholana nʉ mwenda ʉmʉkʉʉlʉ. ");
INSERT INTO mgq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Khabhɨlɨ atalɨɨpo umuntu we akʉbhɨɨkha idivaayi impwa mʉ ntembe ɨnkʉʉlʉ zye zilalile. Ɨnga abhomba shɨnɨɨsho, we yɨkʉlʉla ɨntembe zɨkʉbazʉkha, idivaayi yikwitikha nɨ ntembe yoope yɨkʉnanjɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɨleelo, idivaayi impwa yɨkwanzɨwa kʉyɨbhɨɨkha mʉ ntembe impwa. ");
INSERT INTO mgq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Khabhɨlɨ atalɨɨpo umuntu we akʉyɨgana kʉmwela idivaayi impwa, kumo amweleeye ɨnkʉʉlʉ, kʉnongwa ye akʉtɨ idivaayi ɨnkʉʉlʉ ye nyinza.” ");
INSERT INTO mgq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Isiku limo ɨlyɨ Sabaato, uYeesu akhashɨlaga mu vwizi ɨvwɨ ngano. Abhalandati bhaakwe bhakhanda kudumula amatwe agɨ ngano, bhakhapukusulaga na kulya. ");
INSERT INTO mgq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pe aBhafalisaayi bhamu bhakhabhabhʉzɨɨlɨzya bhakhatɨ, “Khooni ɨmwe mʉkʉbhomba zye zɨtakwɨtɨshɨlwa kʉbhomba pi siku ɨlyɨ Sabaato?” ");
INSERT INTO mgq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","UYeesu akhabhaamʉla akhatɨ, “Mutabhaziizye mu Wusimbe she uDaudi ábhombile we ɨnzala yabhaluma, ʉweene peeka na bhamwabho? ");
INSERT INTO mgq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Áyinjiiye mu nyumba ya Mʉlʉngʉ, akheega amakaati ge gábhishiilwe pa shɨgemo kʉ mbombo imfinjile, akhalya, akhaabhapa na bhamwabho. Ɨndajɨzyo zɨtakhɨtɨshɨzyaga abhantʉ kulya amakaati ganaago, lyoli abhapuutili bheene.” ");
INSERT INTO mgq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","UYeesu akhabhabhʉʉzya winza akhatɨ, “ɄMwana wa Muntu we wʉ Mwene ʉwɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Isiku ɨlyamwabho ɨlyɨ Sabaato, uYeesu akhinjila mwi sinagoogi, akhanda kʉmanyɨzya abhantʉ. Mukaasi muula, álɨɨpo umuntu ʉmo we ɨnyoobhe yaakwe ɨya kʉndɨɨlo yálemaaye. ");
INSERT INTO mgq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ABhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhakhamuzijilaga uYeesu, ɨnga bhalole she atɨmʉponɨe umuntu ʉla pi siku ɨlyɨ Sabaato. Bhakhamʉbhendeelaga shɨnɨɨsho, kʉnongwa ye bhakhanzaga ɨdala ɨlya kʉmʉsɨtaaka uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ɨleelo uYeesu akhamanya ɨnsɨɨbho zyabho. Pe akhamʉbhʉʉzya umuntu ʉla we álemaaye ɨnyoobhe akhatɨ, “Bhʉʉkha, ʉyɨmɨɨlɨle pakaasi.” Pe umuntu ʉla akhabhʉʉkha, akhɨmɨɨlɨla pakaasi yaabho. ");
INSERT INTO mgq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Ɨnkʉbhabhʉzɨɨlɨzya, bhʉlɨ, lyoni lye ɨndajɨzyo zɨkwɨtɨshɨzya pi siku ɨlyɨ Sabaato, kʉ kʉbhomba imbiibhi, awe kʉ kʉbhomba inyinza, kʉ kʉgoga awe kʉ kʉponɨa uwuumi?” ");
INSERT INTO mgq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","UYeesu akhazyʉngʉʉla kʉbheenya bhonti, akhamʉbhʉʉzya umuntu ʉla akhatɨ, “Golosya ɨnyoobhe yaakho.” Woope akhagolosya, yɨkhapona, yɨkhabha nyinza bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ABhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhaala bhakhaviitwa nhaani, bhakhazaabhana kʉtɨ bhatɨmʉbhombe lyoni uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Isiku limo, uYeesu akhabhala mwɨ gamba kupuuta, kʉnʉʉkwo akhapuuta kwa Mʉlʉngʉ uwusiku wonti. ");
INSERT INTO mgq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ɨshɨlaabhɨla, akhabhabhɨlɨshɨla abhalandati bhaakwe. Mʉ bhanaabho akhabhasebha ishumi na bhabhɨlɨ, akhaabhapa ɨtaawa ɨlya bhasundikwa. ");
INSERT INTO mgq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Abhasundikwa bhanaabho bhe bha bhɨɨbha: uSiimoni we uYeesu ámʉtanʉʉye ɨtaawa ɨlya Peeteli, ʉAndeleeya ʉkhambakʉ wa Siimoni, ʉYaakobo, uYookhani, uFilipo, ʉBatolomaayo, ");
INSERT INTO mgq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","uMataayi, uToomasi, ʉYaakobo ʉmwana wa Alʉfeeyo, uSiimoni ʉmʉlwɨla nsɨ yaakwe, ");
INSERT INTO mgq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ʉYʉʉda ʉmwana wa Yaakobo, nʉ Yʉʉda Sikalioti, we ámʉlonjeleeye uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","UYeesu akhiikha kufuma mwɨ gamba, peeka na bhalandati bhaakwe. We aafikha pa khantelama, akhɨmɨɨlɨla. Papaala páamɨle ɨshɨpʉga ɨshɨpɨtɨ ɨsha bhalandati bhaakwe, peeka nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ. Abhantʉ bhanaabho bháfumile ɨmbalɨ ɨzya mʉ nsɨ ɨya Yudeeya na mʉ nhaaya ɨya Yelusaleemu, na mʉmbalɨ mwa sʉmbɨ mʉ nhaaya ɨzya Tiilo ni Sidooni. ");
INSERT INTO mgq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Abhantʉ bhaala bhábhalile paala kʉmʉtejeelezya uYeesu, na kʉtɨ abhaponɨe ɨmpʉngo zyabho. Bhoope bhe bhakhayɨmbaga na mapepu amabhiibhi, akhabhaponɨaga. ");
INSERT INTO mgq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Abhantʉ bhonti bhakhanzaga kʉmʉpalamansya uYeesu, kʉnongwa ye amakha kufuma mʉmwakwe gakhabhaponɨaga bhonti. ");
INSERT INTO mgq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","UYeesu akhabheenya abhalandati bhaakwe, akhabhabhʉʉzya akhatɨ, “Musayiilwe ɨmwe, mwe mwe bhapɨɨna, kʉnongwa ye ʉwʉmwene wa Mʉlʉngʉ wiinyu. ");
INSERT INTO mgq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Musayiilwe ɨmwe, mwe mʉlɨ nɨ nzala akhabhalɨlo ɨkha, kʉnongwa ye mukhayiikuta. Musayiilwe ɨmwe, mwe mʉkʉlɨla akhabhalɨlo ɨkha, kʉnongwa ye mʉkhayɨsekha. ");
INSERT INTO mgq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Musayiilwe ɨmwe, mwe abhantʉ bhakubhaviitilwa, kubhazila na kubhaliga, na kʉbhalonga kʉtɨ mʉlɨ ni mbiibhi kʉnongwa ye mʉkʉmwɨtɨkha ʉMwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Bhoope abhamaama bhaabho, bhábhayimvwizye abhakuwi shɨnɨɨsho. Pe zɨnɨɨzyo we zɨkʉbhombekha, mʉseshelaje na kʉtomonhana, kʉnongwa ye ʉMʉlʉngʉ akhayɨbhaposheelezya ku winji kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ɨleelo mʉsheleeye mwe mwe bhadumbwe, kʉnongwa ye ʉlʉseshelo lwinyu, mʉlʉposheleeye. ");
INSERT INTO mgq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mʉsheleeye ɨmwe, mwe mukwikuta akhabhalɨlo ɨkha, kʉnongwa ye mʉkhayɨbha nɨ nzala. Mʉsheleeye ɨmwe, mwe mʉkʉsekha akhabhalɨlo ɨkha, kʉnongwa ye mʉkhayɨyɨlʉmbʉʉzya na kʉlɨla. ");
INSERT INTO mgq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mʉsheleeye ɨmwe, mwe abhantʉ bhonti bhakʉbhapaala, kʉnongwa ye lɨnɨɨlyo lye abhamaama bhaabho bhábhombile, kʉbhapaala abhakuwi abhɨ lenga. ");
INSERT INTO mgq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ishi, ɨnkʉbhabhʉʉzya ɨmwe mwe mʉkʉtejeelezya, mʉbhaganaje abhalʉgʉ bhiinyu, na bhe bhakubhaviitilwa, mʉbhabhombelaje inyinza. ");
INSERT INTO mgq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bhe bhakubhaguna mʉbhalabhɨlaje ʉlʉsayo kwa Mʉlʉngʉ. Bhe bhakʉbhabhombela zye zɨtakhondeeye, mubhaputilaje kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Umuntu ɨnga akʉkhoma kʉ lʉdɨlɨ ʉlwɨ mbalɨ yeeka, mʉleshe akʉkhome nɨ mbalɨ ɨyamwabho. Khabhɨlɨ umuntu ɨnga akʉfwʉlɨla ikooti lyakho, mʉleshe ayeeje ni nshaati. ");
INSERT INTO mgq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Umuntu wowonti we akʉkʉlaabha akhantʉ, ʉmʉpanje. Khabhɨlɨ umuntu ɨnga afwʉla ivintu vwakho, ʉtatɨnjɨ akʉgalʉshɨzye. ");
INSERT INTO mgq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mʉbhabhombelaje abhanjɨ anza she nɨɨmwe mʉkwanza kʉbhombelwa. ");
INSERT INTO mgq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ɨnga mʉkʉbhagana bhaala bhe bhabhaganile ɨmwe, mʉtalɨ nɨ lya kʉyɨbaada pamiiso ga Mʉlʉngʉ. Bhoope abhabhomba mbiibhi, bhakʉbhagana bhaala bhe bhabhaganile! ");
INSERT INTO mgq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Khabhɨlɨ ɨnga mʉkʉbhabhombela inyinza bhaala bhe bhakʉbhabhombela inyinza, mʉtalɨ nɨ lya kʉyɨbaada pamiiso ga Mʉlʉngʉ. Bhoope abhabhomba mbiibhi bhakʉbhomba anza shɨnɨɨsho! ");
INSERT INTO mgq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɨnga mwabhapabhɨla bhaala bhe mumanyile kʉtɨ bhangabhagalʉshɨzya, mʉngaposheela khantʉ khooni? Bhoope abhabhomba mbiibhi bhakʉbhapabhɨla abhamwabho, kʉnongwa ye bhamanyile kʉtɨ, bhangabhagalʉshɨzya vwonti! ");
INSERT INTO mgq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Lyoli ɨmwe, mʉbhaganaje abhalʉgʉ bhiinyu na kʉbhabhombela inyinza. Mʉbhapabhɨlaje, sita kʉsʉʉbhɨla kʉtɨ bhatɨbhagalʉshɨzye. Ɨnga mwabhomba zɨnɨɨzyo, ʉMʉlʉngʉ akhayɨbhasomba ivwinji. Khabhɨlɨ mʉkhayɨbha mwe bhaana bha Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya, kʉnongwa ye ʉweene akʉbhabhombela inyinza bhe bhatakusalifwa na kʉ bhabhomba mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mʉbhalolelaje ishisa abhantʉ bhonti, anza she ʉTaata wiinyu ʉMʉlʉngʉ akʉbhalolela ishisa abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mʉtabhalongaje abhanjɨ, pe nɨɨmwe te mʉkhalongwe nʉ Mʉlʉngʉ. Mutabhabhunaje abhanjɨ, pe nɨɨmwe te mukhaabhunwe. Mʉbhatʉyɨlaje abhanjɨ, pe nɨɨmwe mʉkhayɨtʉʉyɨlwa. ");
INSERT INTO mgq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mʉbhanje mwe bhateti, pe nɨɨmwe mʉkhayɨtetwa, mu shipimilo she shisindiliilwe, shizuuye na kwitinhana. Kwe kʉtɨ ishipimilo she mukubhapimila abhanjɨ, she shɨnɨɨsho ʉMʉlʉngʉ akhayipimila kukwinyu.” ");
INSERT INTO mgq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","UYeesu akhalonga mʉ shɨkholanyo akhatɨ, “Bhʉlɨ, umuntu we afuuye amiiso angakhola kʉmʉlongola ʉwamwabho we afuuye amiiso? Ɨnga bhakhonzya shɨnɨɨsho, bhonti bhabhɨlɨ bhakʉlendela mu lyina. ");
INSERT INTO mgq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umumanyili atangamʉshɨla umumanyizyi waakwe. Ɨleelo, we aamala kʉmanyɨla zyonti, pe akhayɨbha anzu mumanyizyi waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Khooni khe ʉkwenya ɨkooko lye lɨlɨ mu lyiso lya wamwinyu, ɨleelo ʉtakʉlola ʉmʉkooko we wʉlɨ mu lyiso lyakho? ");
INSERT INTO mgq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Zɨngabha bhʉlɨɨbhʉlɨ kʉmʉbhʉʉzya uwamwinyu kʉtɨ, ‘We wamwɨtʉ, isuuti ɨnkwefwe ɨkooko lye lɨlɨ mu lyiso lyakho,’ ɨleelo ɨwe wʉneewe ʉtakwefwa ʉmʉkooko we wʉlɨ mu lyiso lyakho? Ɨwe ʉlɨ ni shisa ɨshɨ lenga! Yeefwa suuti ʉmʉkooko we wʉlɨ mu lyiso lyakho. Pe ʉngakhola kwefwa ɨkooko lye lɨlɨ mu lyiso lya wamwinyu. ");
INSERT INTO mgq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lɨtalɨɨpo ikwi ilyinza lye lɨkwela amatunda amabhiibhi, khabhɨlɨ lɨtalɨɨpo ikwi ibhiibhi lye lɨkwela amatunda aminza. ");
INSERT INTO mgq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abhantʉ bhakʉlɨmanya ikwi kufumilana na matunda gaakwe, ye nongwa abhantʉ bhatakʉtʉngʉla amatunda agi kwi ilyi tiini mu mimvwa, awe agi zabiibu mʉ nyangwa. ");
INSERT INTO mgq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Shɨnɨɨsho she zɨlɨ, umuntu umwinza akʉlonga inyinza, zye zikufuma mʉ mwoyo waakwe umwinza. Woope umuntu umubhiibhi akʉlonga imbiibhi, zye zikufuma mʉ mwoyo waakwe umubhiibhi. Kʉnongwa ye umuntu akʉlonga zye zyizuuye mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Khooni khe mʉkʉntekha kʉtɨ, ‘Mwene, Mwene,’ ɨleelo mʉtakʉbhomba zye ɨnkʉbhabhʉʉzya? ");
INSERT INTO mgq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Umuntu wowonti we akwɨnza kʉkwanɨ, na kʉtejeelezya amazwi gaanɨ na kʉgalema, ɨntɨmʉkholanye nɨ shɨkholanyo ishi: ");
INSERT INTO mgq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Akʉbha anzu muntu we ázenjile inyumba. We akwanda, akhabana ʉlwalo kwikha paasɨ pɨ lyalaawe, akhazenga ʉlwalo ulwi nyumba, pe akhamala kʉzenga inyumba yonti. Imvula we yatoonya inyinji, ulwizi lukhiizula nhaani, aminzi gakhapongola, gakhabhala kʉ makha, gakhabunshila inyumba yiila, ɨleelo yitakhayinga ngakheeka, kʉnongwa ye inyumba yázenjiilwe akhinza mʉ lwalo ulugomu. ");
INSERT INTO mgq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɨleelo umuntu we akʉtejeelezya amazwi gaanɨ, sita kʉgalema, wʉnʉʉyo akʉkholana nu muntu we ázenjile inyumba yaakwe pa mʉselesenga sita lwalo. Aminzi we giizula mu lwizi gapongola, gakhabhala kʉ makha, gakhabunshila inyumba yiila, yɨkhagwa panaapo na kʉpongonhana yonti.” ");
INSERT INTO mgq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","UYeesu we aamala kʉyɨbhʉʉzya ɨmpʉga ya bhantʉ amazwi ganaago gonti, akhabhala mʉ nhaaya ɨya mu Kapelenaumu. ");
INSERT INTO mgq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mʉ nhaaya yɨnɨɨyo, álɨɨpo umuntu ʉmo we atáamɨle Muyahuudi, áamɨle mʉpɨtɨ wa bhasikaali abha Shiluumi. Ʉmʉpɨtɨ wʉnʉʉyo áamɨle nu mutumwa we ámuganile nhaani. Umutumwa ʉyo áamɨle mubhinu, ápalamɨɨye kufwa. ");
INSERT INTO mgq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ʉmʉpɨtɨ ʉla, we ayɨmvwa ɨnongwa ɨzya Yeesu, akhabhasonteelezya abhasongo bhamu abha Bhayahuudi kwa Yeesu, bhabhale bhamʉlaabhe ayɨnze kʉmʉponɨa umutumwa waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abhasongo bhaala, we bhaafikha kwa Yeesu, bhakhamʉlamba nhaani bhakhatɨ, “Umuntu ʉyo akhondeeye kʉtɨ ʉmʉbhombele izwi liniili, ");
INSERT INTO mgq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kʉnongwa ye abhaganile abhantʉ abhɨ nsɨ yɨɨtʉ, khabhɨlɨ we atʉzenjeeye isinagoogi.” ");
INSERT INTO mgq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pe uYeesu akhabhala peeka na bhasongo bhaala kʉkhaaya kwa mʉpɨtɨ. We bhapalamɨla, ʉmʉpɨtɨ wʉnʉʉyo akhabhasonteelezya abhamanyani bhaakwe, bhakhabhala ni ntumi yaakwe kwa Yeesu, bhakhamʉbhʉʉzya bhakhatɨ, “We Mwene, ʉtayɨyɨmvwaje, kʉnongwa ye ɨntakhondeeye kʉtɨ uyinjile mu nyumba yaanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ye nongwa naalola kʉtɨ poope ɨntakhondeeye kwɨnza kʉkwakho. Ɨleelo ʉlonje izwi lyene, umubhombi waanɨ atɨpone. ");
INSERT INTO mgq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kʉnongwa ye nɨɨne bhʉʉlo ɨndɨ paasɨ pa bhapɨtɨ bhaanɨ. Khabhɨlɨ ɨndɨ na bhasikaali bhe bhalɨ paasɨ papaanɨ. Ɨnga namʉbhʉʉzya weeka natɨ, ‘Bhalaga!’, nalʉbhɨlo akʉbhala. Ɨnga namʉbhʉʉzya ʉwamwabho natɨ, ‘Nzaaga!’, woope akwɨnza. Woope umutumwa waanɨ, ɨnga namʉbhʉʉzya natɨ, ‘Bhomba ʉtɨ!’, akʉbhomba shɨnɨɨsho.” ");
INSERT INTO mgq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","UYeesu we ayɨmvwa zɨnɨɨzyo, akhamuswiga nhaani. Akhagalʉnhana akhayeenya ɨmpʉga ya bhantʉ bhe bhakhamʉlandataga, akhabhabhʉʉzya akhatɨ, “Ɨnkʉbhabhʉʉzya kʉtɨ, mu Bhaisilaeli bhonti, intamulolile umuntu ngaweeka we alɨ nʉ lwɨtɨkho ʉlʉpɨtɨ anza lunuulu!” ");
INSERT INTO mgq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pe abhantʉ bhe ʉmʉpɨtɨ ʉla ábhasonteleziizye bhakhagalʉkha mu nyumba yaakwe, bhakhaaga umutumwa aponile. ");
INSERT INTO mgq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pɨlongolela khashe, uYeesu akhabhala mʉ nhaaya ɨya mu Naayini, áamɨle peeka na bhalandati bhaakwe, na bhantʉ abhanjɨ abhinji. ");
INSERT INTO mgq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","We apalamɨla pa mʉlyango ʉwa kwinjiilila mʉ nhaaya, akhakhomaana na bhantʉ bhe bhapimbile ivimba ɨlya mʉsakhaala. Ʉmʉsakhaala wʉnʉʉyo áamɨle mwana weeka mwene, unyina waakwe áamɨle mʉfwɨle. Ʉmwantanda wʉnʉʉyo álongozanyiinye na bhantʉ abhinji abha mʉ nhaaya yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ɄMwene uYeesu we amʉlola ʉmʉfwɨle wʉnʉʉyo, akhamʉlolela ishisa, akhamʉbhʉʉzya akhatɨ, “Pʉʉma, ʉtalɨlaje.” ");
INSERT INTO mgq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Akhalɨsejeelela ipagali mwe ivimba lyámɨle, akhalɨpalamansya. Abhantʉ bhe bhápimbile, bhakhɨmɨɨlɨla. Akhatɨ, “Wʉmwana wumutunta ɨwe, ɨnkʉkʉbhʉʉzya ɨnkʉtɨ, daamʉkha!” ");
INSERT INTO mgq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wʉnʉʉyo we áfuuye, nalʉbhɨlo akhadaamʉkha, akhɨɨkhala, akhanda kʉlonga winza. Pe uYeesu akhaamupa unyina waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abhantʉ bhanaabho bhonti bhakhaswiga na kʉtʉʉya nhaani! Bhakhanda kʉmʉpaala ʉMʉlʉngʉ, bhakhatɨnjɨ, “Umukuwi ʉmʉpɨtɨ afumiiye kʉkwɨtʉ!” Bhakhapaalaga winza bhakhatɨnjɨ, “ɄMʉlʉngʉ ayinzile kʉbhaavwa abhantʉ bhaakwe!” ");
INSERT INTO mgq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɨnongwa zɨnɨɨzyo zye uYeesu ábhombile zɨkhasaata nhaani mu Yudeeya yonti, na mʉ nsɨ izinji ɨzya papɨɨpɨ. ");
INSERT INTO mgq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Akhabhalɨlo khanaakho, abhalandati bha Yookhani, bhakhamʉtwalɨla uYookhani ɨnongwa zyonti zɨnɨɨzyo ɨzya Yeesu. UYookhani akhabhabhɨlɨshɨla abhalandati bhaakwe bhabhɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","akhabhasonteelezya kʉtɨ bhabhale kʉmʉbhʉzɨɨlɨzya ʉMwene uYeesu, bhatɨ, “Bhʉlɨ, ɨwe we Kilisiti we abhakuwi bhátɨlɨ akhayɨnza, awe tʉmʉgʉlɨlaje uwunji?” ");
INSERT INTO mgq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pe bhanaabho bhabhɨlɨ we bhaafikha kwa Yeesu, bhakhamʉbhʉʉzya bhakhatɨ, “UYookhani uMwozyi atusonteleziizye kʉkwakho, kʉtɨ tʉkʉbhʉzɨɨlɨzye, ‘Bhʉlɨ, ɨwe we Kilisiti we abhakuwi bhátɨlɨ akhayɨnza, awe tʉmʉgʉlɨlaje uwunji?’ ” ");
INSERT INTO mgq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mʉ khabhalɨlo khanaakho, uYeesu akhaponɨaga abhantʉ abhinji uwubhinu na bhe amapepu amabhiibhi gábhinjiiye. Khabhɨlɨ akhabhavwaga abhinji bhe bhatakʉlola bhande kʉlola. ");
INSERT INTO mgq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe uYeesu akhabhaamʉla akhatɨ, “Bhalaji mʉmʉbhʉʉzye uYookhani zyonti zye mwazɨlola, na kʉzyɨmvwa: bhe bhatalolaga bhakʉlola, bhe bhatajendaga bhakʉjenda, bhe bhalɨ na maketa bhakʉsatʉkha, bhe bhatɨmvwaga bhakwɨmvwa, abhafwe bhakʉzyʉkha, na bhapɨɨna bhakʉlʉmbɨɨlɨlwa iNtumi iNyinza. ");
INSERT INTO mgq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Asayiilwe umuntu we atakʉlʉlekha ʉlwɨtɨkho kʉnongwa yaanɨ!” ");
INSERT INTO mgq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhanaabho bhabhɨlɨ we bhasogola panaapo, uYeesu akhanda kʉyɨbhʉʉzya ɨmpʉga ya bhantʉ kʉ zya Yookhani akhatɨ, “Mwabhalaga kwenya khooni ku shilozu kuula? Bhʉlɨ, mwabhalaga kwenya umuntu we atalɨ na makha ngatɨ lɨtete lye impepu yikuyinzanya? ");
INSERT INTO mgq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɨnga te shɨ shɨnɨɨsho, mwábhalile kwenya khooni? Mwábhalile kʉmwenya umuntu we akwatile amenda agɨ togo? Yeenya, abhantʉ bhe bhakʉkwata amenda agɨ togo, na kʉyɨbaada mu winji ʉwa vintu vwe bhalɨ navwo, bhanaabho bhakwɨkhala mu nyumba ɨmpɨtɨ ɨzya shɨmwene! ");
INSERT INTO mgq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pe mwabhalaga kwenya khooni? Bhʉlɨ, mwábhalile kʉmwenya umukuwi? Nalyoli uYookhani mʉpɨtɨ kʉshɨla umukuwi. ");
INSERT INTO mgq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wʉnʉʉnʉ we wʉ wʉʉla we yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Yeenya, ɨnhayɨmʉsonteelezya we akʉtwala intumi mwɨlongolela lyakho, akhayɨlɨngaanya ɨdala lyakho ɨlya kwɨnzɨla.’” ");
INSERT INTO mgq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","UYeesu akhatɨ, “Nɨɨne ɨnkʉbhabhʉʉzya kʉtɨ, mʉ bhantʉ bhonti bhe bhapapiilwe na bhantanda, atalɨɨpo we mʉpɨtɨ kʉmʉshɨla uYookhani uMwozyi. Poope shɨnɨɨsho, umuntu we munsi nhaani mʉ wʉmwene wa Mʉlʉngʉ, we mʉpɨtɨ kʉmʉshɨla uYookhani.” ");
INSERT INTO mgq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bhanaabho abhantʉ bhonti, peeka na bhasonshezya nsonho, we bhɨmvwa amazwi ganaago aga Yeesu, bhakhɨɨtɨkha kʉtɨ ɨnsɨɨbho ya Mʉlʉngʉ yáamɨle nyinza. Bhanaabho bhe bha bhaala bhe bhózeliilwe nu Yookhani. ");
INSERT INTO mgq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ɨleelo aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhatózeliilwe nu Yookhani, kʉnongwa ye bhákhaanile zye ʉMʉlʉngʉ akhabhasɨbhɨlɨlaga. ");
INSERT INTO mgq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pe uYeesu akhalonga winza akhatɨ, “Abhantʉ abha khabhalɨlo ɨkha ɨmbakholanye na khooni? Bhakholiine na khooni? ");
INSERT INTO mgq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhakʉkholana na bhaana bhe bhɨkhaaye pa mʉnaalo, bhakʉbhɨlɨshɨlana bhakʉtɨ, ‘Twaabhakhomeeye ɨmfwɨlɨmbo, ɨleelo mʉtɨmbaga! Twaabhɨmbɨɨye ɨnyɨmbo ɨzya wuswimiilizu, ɨleelo mʉtalɨlaga!’ ");
INSERT INTO mgq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Shɨnɨɨsho she nɨɨmwe mʉlɨ, kʉnongwa ye akhabhalɨlo khe uYookhani uMwozyi áyinzile, atakhalyanga ikaati, awe kʉmwela idivaayi, ɨmwe mʉkhatɨ, ‘Alemiilwe ni pepu ibhiibhi!’ ");
INSERT INTO mgq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Akhabhalɨlo khe ʉMwana wa Muntu áyinzile, akhalyanga na kʉmwela. Ɨmwe mʉkhatɨ, ‘Yeenya! Umulyovi ʉnʉ, khabhɨlɨ mumwezi, mumanyani wa bhasonshezya nsonho na bhabhomba mbiibhi!’ ");
INSERT INTO mgq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Poope shɨnɨɨsho, ɨnjeele ya Mʉlʉngʉ, yɨkʉlolekha kʉtɨ yɨkhondeeye kʉ zye bhakʉbhomba abhalandati bhaakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Isiku limo, uMufalisaayi ʉmo ámʉlanjɨɨye uYeesu kʉtɨ ayɨnze kulya kʉkwakwe. Pe uYeesu akhinjila kʉkhaaya kwa Mufalisaayi, akhɨɨkhala pa shintalati. ");
INSERT INTO mgq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mʉ nhaaya yɨnɨɨyo, mwámɨle nʉ mwantanda ʉmo we ámanyishile kʉtɨ akwɨkhala mʉ njendo imbiibhi. Ʉmwantanda ʉla, we ayɨmvwa kʉtɨ uYeesu akulya kwa Mufalisaayi, akhafikha mʉmwo na khasupa akhinza akha mafuta ge gakununshiilila. ");
INSERT INTO mgq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akhɨmɨɨlɨla kʉlʉsalo kwa Yeesu, papɨɨpɨ nɨ vɨnama vwakwe. Akhanda kʉlɨla, amansozi gaakwe gakhalendelaga mʉ vɨnama vwa Yeesu. Akhasyʉmʉlaga ni nsisi zyakwe, akhamʉtambɨlaga-tambɨlaga mʉ vɨnama vwakwe, na kʉvɨpakhazya amafuta ge gakununshiilila. ");
INSERT INTO mgq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","UMufalisaayi we aalola zɨnɨɨzyo, akhasɨɨbha mʉ mwoyo waakwe akhatɨ, “Umuntu ʉnʉ, ɨnga abhanje mukuwi, amanyaga kʉtɨ ʉmwantanda ʉnʉ we akʉmʉpalamansya muntu we alɨ bhʉlɨɨbhʉlɨ. Amanyaga kʉtɨ ʉweene akwɨkhala mʉ njendo imbiibhi!” ");
INSERT INTO mgq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","UYeesu akhamʉbhʉʉzya akhatɨ, “We Siimoni, ɨndɨ ni zwi ɨlya kʉkʉbhʉʉzya.” Woope akhamwamʉla akhatɨ, “We Mumanyizyi, mbʉʉzye.” Pe uYeesu akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Páamɨle na bhantʉ bhabhɨlɨ, bhakhadayɨlwaga ɨnhela nu muntu we ábhapabhɨɨye. Weeka mʉ bhanaabho ákhopile idinaali imia zɨsaanʉ (500), ʉwamwabho woope ákhopile idinaali amashumi gasaanʉ. ");
INSERT INTO mgq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhanaabho bhabhɨlɨ bhakhapootwa ɨnhela ɨzya kʉtabhʉla amadeeni gaabho, pe we ábhapabhɨɨye akhabhatʉʉyɨla, kʉtɨ bhatatabhʉle. Bhʉlɨ, kʉ bhabhɨlɨ bhanaabho, alikwi we angamʉgana kʉshɨla ʉwamwabho?” ");
INSERT INTO mgq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","USiimoni akhamwamʉla akhatɨ, “Ɨnkʉlola kʉtɨ wʉ wʉʉla we átuyiliilwe ideeni ɨpɨtɨ.” UYeesu akhamʉbhʉʉzya akhatɨ, “Waamʉla akhinza.” ");
INSERT INTO mgq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pe uYeesu akhagalʉnhana, akheenya kwa mwantanda ʉla, akhamʉbhʉʉzya uSiimoni akhatɨ, “Ʉkʉmʉlola ʉmwantanda ʉnʉ? Ininjiiye mu nyumba yaakho ɨwe, ɨleelo ʉtamposheleeye kwɨ dala ɨlya kumpa aminzi aga kʉvwanzya mʉ vɨnama vwanɨ. Ɨleelo ʉweene avwanzya ɨvɨnama vwanɨ na mansozi gaakwe, na kʉgasyʉmʉla ni nsisi zyakwe. ");
INSERT INTO mgq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","We ʉkʉndamʉkha, ʉtantambɨɨye, ɨleelo ʉweene, kufuma akhabhalɨlo khe ininjiiye umu, atalitile kʉntambɨla mʉ vɨnama vwanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɨwe utampakhaziizye pi twe lyanɨ amafuta, ɨleelo ʉweene ampakhaziizye ɨvɨnama vwanɨ amafuta ge gakununshiilila! ");
INSERT INTO mgq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pe shɨnɨɨsho, ɨnkʉkʉbhʉʉzya ɨnkʉtɨ, ʉlʉgano ʉlwa mwantanda ʉnʉ lʉpɨtɨ, kʉnongwa ye atuyiliilwe imbiibhi zyakwe inyinji. Ɨleelo wowonti we atuyiliilwe imbiibhi inyinsi, akʉbha nʉ lʉgano ulunsi.” ");
INSERT INTO mgq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pe uYeesu akhamʉbhʉʉzya ʉmwantanda ʉla akhatɨ, “Imbiibhi zyakho zituyiliilwe.” ");
INSERT INTO mgq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abhajeni abhanjɨ bhe bháamɨle pa shintalati, bhakhanda kʉbhʉzɨlɨzanya kʉtɨ, “Wu naanu wʉnʉʉnʉ, we poope akʉtʉʉyɨla ni mbiibhi?” ");
INSERT INTO mgq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pe uYeesu akhamʉbhʉʉzya ʉmwantanda ʉla akhatɨ, “Ʉlwɨtɨkho lwakho lwe lwakʉpokha, sogolaga ku wutengaanu.” ");
INSERT INTO mgq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pɨlongolela, uYeesu akhashɨlaga mʉ nhaaya ɨmpɨtɨ ni nyinsi, akhalʉmbɨlɨlaga iNtumi iNyinza ɨzya wʉmwene wa Mʉlʉngʉ. Áamɨle peeka na bhalandati bhaakwe ishumi na bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Khabhɨlɨ áamɨle peeka na bhantanda bhamu bhe ábhaponiizye uwubhinu, na bhe ábhefwizye amapepu amabhiibhi. Mʉ bhantanda bhanaabho, álɨɨpo uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala, we uYeesu ámwefwizye amapepu amabhiibhi saba, ");
INSERT INTO mgq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nʉ Yoana ʉmʉshɨ wa Kuuza. UKuuza áamɨle mubhombi ʉmʉpɨtɨ ʉwa Heloodi. Khabhɨlɨ álɨɨpo uSusaana, na bhantanda abhanjɨ abhinji. Abhantanda bhanaabho bhakhafumwaga ivintu vwabho, kʉmwavwa uYeesu na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Isiku limo, abhantʉ abhinji kufuma mʉ nhaaya inyinji, bhábhungaanile pa Yeesu. Pe uYeesu akhabhabhʉʉzya mʉ shɨkholanyo akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Álɨɨpo umupesi ʉmo ábhalile kʉsansa imbeyu. We akʉsansa, imbeyu zimo zɨkhalendela mwɨ dala, zɨkhakhanywa, inyonyi zɨkhɨnza na kuzilya. ");
INSERT INTO mgq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɨzyamwabho zɨkhalendela pɨ lyalaawe. We zyamela na kwanda kʉkʉla, zɨkhʉʉma, kʉnongwa ye púumile. ");
INSERT INTO mgq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zimo zɨkhalendela mu makwi aga mimvwa. Amimvwa gaala we gakʉkʉla peeka ni mbeyu ziila zye zyámelile, gakhazipuuta. ");
INSERT INTO mgq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɨzyamwabho zɨkhalendela mu lusuuto uluvunzu, zɨkhamela, zɨkhakʉla, na kwela akhinza nhaani, zyonti yeeka yeeka zɨkheela amatunda imia yeeka (100).” UYeesu we aamala kʉlonga lɨnɨɨlyo, akhadandɨzya izi akhatɨ, “Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa!” ");
INSERT INTO mgq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pɨlongolela, abhalandati bhaakwe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ɨshɨkholanyo ishi kwe kʉtɨ bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akhabhabhʉʉzya akhatɨ, “Ɨmwe ʉMʉlʉngʉ abhapiiye kʉmanya ɨzya kukwilu ɨzya wʉmwene waakwe. Ɨleelo bhamu ɨnkʉbhabhʉʉzya kʉ vɨkholanyo ɨnga, ‘We bhakwenya, bhatalolaje, khabhɨlɨ we bhakʉtejeelezya, bhatazyaganyaaje.’ ");
INSERT INTO mgq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ɨshɨkholanyo shiniishi kwe kʉtɨ, imbeyu lye lizwi lya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeyu zye zyálendeeye mwɨ dala, bhantʉ bhe bhakwɨmvwa izwi lya Mʉlʉngʉ, ɨleelo akhabhalɨlo khanaakho, uSeetani akwɨnza akwefwa izwi liila mʉ mooyo gaabho, bhaleshe kwɨtɨkha, ɨnga bhatakhaapone na kʉwaaga uwuposhi. ");
INSERT INTO mgq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imbeyu zye zyálendeeye pɨ lyalaawe, bhantʉ bhe bhakwɨmvwa izwi lya Mʉlʉngʉ, bhakʉposheela kʉ lʉseshelo, ɨleelo bhatakʉlɨbhɨɨkha mʉ mwoyo. Bhanaabho bhakwɨtɨkha kʉ khabhalɨlo, ɨleelo ɨnga bhalɨngwa bhakʉlʉlekha ʉlwɨtɨkho. ");
INSERT INTO mgq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeyu zye zyálendeeye pa mimvwa, bha bhaala bhe bhakwɨmvwa izwi lya Mʉlʉngʉ, ɨleelo pɨlongolela mʉ wɨɨkhalo waabho, kʉpɨlɨnhana nɨ mbombo ɨzya mʉ nsɨ na kwanza uwudumbwe, nɨ nsʉngʉkho ɨzya mʉ nsɨ, lɨnɨɨlyo lɨkʉbhabhɨɨkha kʉtɨ bhaleshe kwela amatunda. ");
INSERT INTO mgq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɨleelo imbeyu zye zyálendeeye mu lusuuto uluvunzu, shɨkholanyo sha bhantʉ bhe bhakwɨmvwa izwi na kʉlɨlema kʉ mwoyo umugolosu ʉwa lutinikho. Bhanaabho bhe bhakwela amatunda kwɨ dala ɨlya kujimbiilila mʉ mayɨmba gonti. ");
INSERT INTO mgq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Atalɨɨpo umuntu we akʉkholeelezya ʉlʉkhozyo na kugubishila mʉ nsonta, awe kʉbhɨɨkha kwɨ zyʉngʉ kʉ shɨtala. Lyoli akʉbhɨɨkha pa shɨmbeeje ɨnga abhantʉ we bhakwinjila, bhalolaje ʉlʉkhozyo lwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","She zɨlɨ, gonti ge galɨ kukwilu gakhayɨbha apazelu, khabhɨlɨ gonti ge gafisishile gakhayɨmanyɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Mʉbhe amiiso she mʉkʉtejeelezya, kʉnongwa ye we akʉlɨtejeelezya izwi lya Mʉlʉngʉ na kʉlɨmanya, pe ʉMʉlʉngʉ akʉmwavwa kwonjela kʉlɨmanya nhaani. Ɨleelo we atakʉlɨtejeelezya izwi lya Mʉlʉngʉ, ni linsi lye alimanyile lɨkʉfwʉlwa.” ");
INSERT INTO mgq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pe unyina na bhakhambakʉ bha Yeesu, bhakhabhala kwa Yeesu, ɨleelo bhakhapootwa kʉsejeelela papaakwe kʉnongwa ye abhantʉ bháamɨle bhinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bhamu bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Unyina waakho na bhakhambakʉ bhaakho bhalɨ panzɨ ɨpo, bhakʉkwanza.” ");
INSERT INTO mgq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","UYeesu akhabhaamʉla akhatɨ, “Abhantʉ bhe bhakwɨmvwa izwi lya Mʉlʉngʉ na kʉlɨlandata, bhanaabho bhe bhanyina bhaanɨ na bhe bhakhambakʉ bhaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isiku limo, uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Tufumiile ʉsʉmbɨ, tʉbhale kwɨsyɨla.” Pe bhakhinjila mʉ shɨtʉʉlɨ, bhakhanda kufumiila. ");
INSERT INTO mgq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","We bhakufumiila, uYeesu akhasʉpɨɨla utulo. Impepu ɨmpɨtɨ yɨkhanda kuvugula na kʉbhɨɨkha amabhilingwa amapɨtɨ mwa sʉmbɨ. Aminzi gakhanda kwizula mʉ shɨtʉʉlɨ, bhakhapalamɨla kuswibha. ");
INSERT INTO mgq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pe abhalandati bhakhabhala kwa Yeesu, bhakhamʉdaamʉsya, bhakhatɨ, “We Mʉpɨtɨ! We Mʉpɨtɨ! Tukufwa!” UYeesu akhadaamʉkha, akhayɨkhajɨla impepu na mabhilingwa, vɨkhapʉʉma, kʉkhabha mye! ");
INSERT INTO mgq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pe uYeesu akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Ʉlwɨtɨkho lwinyu lʉlɨ kwoshi?” Abhalandati bhakhaswiga na kwogopa, kumo bhakhabhʉzɨlɨzanyaaga bhakhatɨnjɨ, “Wu naanu wʉnʉʉnʉ we akʉkhajɨla poope ni mpepu na mabhilingwa, vikumutinikha?” ");
INSERT INTO mgq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","UYeesu na bhalandati bhaakwe bhakhafumiila ʉsʉmbɨ ʉwa Galɨlaaya, bhakhafikha kwɨsyɨla mʉ nsɨ ɨya Bhagelaasi. ");
INSERT INTO mgq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","UYeesu we ayiikha mʉ shɨtʉʉlɨ, umuntu ʉmo ʉwa mʉ nsɨ yiila akhɨnza kʉkwakwe. Umuntu ʉyo áamɨle na mapepu amabhiibhi. Insiku inyinji akhajendaga ishitali, khabhɨlɨ atakhɨkhalaga mu nyumba, lyoli akhɨkhalaga kʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Amapepu ganaago gakhamʉyɨmvwaga akhinji bhʉʉlo. Akhabhalɨlo khamu abhantʉ bhakhamupinyaga na manyoloolo nɨ mpɨngwa ɨnga bhamʉlɨndɨlɨlaje, ɨleelo akhinji akhavidumulanyaaga na kʉtwalwa na mapepu gaala mwɨ laala. Umuntu ʉla we aafikha kwa Yeesu, uYeesu akhagakhajɨla amapepu gaala, kʉtɨ geepe. Umuntu ʉla we akʉmwenya uYeesu, akhakhoola. Akhagwa pɨlongolela pa Yeesu akhalonga kwi zi ɨlya kʉdandɨzya akhatɨ, “Ʉlɨ na khooni nɨɨne Yeesu, Mwana wa Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya? Ɨnkʉkʉlaabha kʉtɨ ʉtanjɨmvwaje.” ");
INSERT INTO mgq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","UYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “Ɨtaawa lyakho we naanu?” Akhamwamʉla akhatɨ, “Ɨtaawa lyanɨ ne Lijeeshi,” kʉnongwa ye amapepu amabhiibhi gáamɨle minji mʉmwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Amapepu amabhiibhi gaala gakhamʉlamba uYeesu kʉtɨ atakhagalajɨzye gafume kʉbhala mwi lyina itali. ");
INSERT INTO mgq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akhabhalɨlo khanaakho pambalɨ pɨ gamba páamɨle ɨmpʉga ɨmpɨtɨ ɨyɨ ngʉlʉbhe, zye zikhadimwaga. Pe amapepu amabhiibhi gaala gakhamʉlamba uYeesu kʉtɨ, agɨtɨshɨzye ginjile mʉ ngʉlʉbhe, pe akhagɨtɨshɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gakheepa mukaasi mwa muntu ʉla, gakhinjila mʉ ngʉlʉbhe. Pe ɨngʉlʉbhe zyonti zikhiikha nalʉbhɨlo ku lwikha lwe lusulamile nhaani, paka mwa sʉmbɨ, zɨkhagwɨla na kufwa. ");
INSERT INTO mgq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Abhadiimi abhɨ ngʉlʉbhe we bhaalola shɨnɨɨsho, bhakhoogopa, bhakhashɨmbɨla, bhakhabhala mʉ nhaaya na mu vwizi, bhakhalongaga zyonti zye bhazɨlola. ");
INSERT INTO mgq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Abhantʉ bhe bhímvwizye, bhakhabhalaga kwenya zye zifumiiye. We bhaafikha pe uYeesu áamɨle, bhakhamʉlola umuntu we amapepu amabhiibhi gamwepile, ayɨkhaaye pa vɨnama pa Yeesu, akwatile akhinza, khabhɨlɨ alɨ nɨ njeele zyonti, pe bhakhalemwa nɨ lyoga. ");
INSERT INTO mgq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abhantʉ bhe bhálolile zye zyábhombeshile, bhakhabhabhʉʉzya abhanjɨ she zyámɨle, uYeesu we akʉmʉponɨa ʉwa mapepu. ");
INSERT INTO mgq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pe abhantʉ bhonti abha mʉ nsɨ ɨya Bhagelaasi, bhakhalemwa nɨ lyoga. Pe bhakhamʉlamba uYeesu asogole kʉkwabho. UYeesu akhinjila mʉ shɨtʉʉlɨ, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","UYeesu we akʉsogola, umuntu ʉla we amapepu amabhiibhi gámwepile, akhamʉlamba uYeesu kʉtɨ bhabhale bhonti. Ɨleelo uYeesu atakhamwɨtɨshɨzya, akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Galʉkhaga kʉkhaaya kʉkwakho, ʉbhale ʉbhabhʉʉzye abhantʉ zye ʉMʉlʉngʉ akʉbhombeeye.” Pe umuntu ʉla akhasogola paala, akhabhala mʉ nhaaya. Kʉnʉʉkwo akhavwɨnsyaga mʉ nhaaya yonti, zye uYeesu amʉbhombeeye. ");
INSERT INTO mgq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","UYeesu we agalʉkha kwɨsyɨla ɨlyamwabho, akhaposheelwa kʉ lʉseshelo nɨ mpʉga ɨya bhantʉ, kʉnongwa ye bhakhamʉgʉlɨlaga. ");
INSERT INTO mgq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pe umuntu ʉmo akhɨnza. Umuntu wʉnʉʉyo bhakhatɨnjɨ ʉYayɨlo, áamɨle weeka mʉ bhapɨtɨ abhi sinagoogi. Akhagwa pa vɨnama pa Yeesu, akhamʉlamba kʉtɨ abhale kʉkwakwe, ");
INSERT INTO mgq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kʉnongwa ye ʉmwalɨ waakwe ʉwa manha ishumi na gabhɨlɨ, we áamɨle weeka mwene kwa yise waakwe, ábhinile ɨya kufwa. Pe uYeesu akhanda kʉbhala kwa Yayɨlo. We alɨ mwɨ dala, abhantʉ abhinji bháamɨle peeka nawo, bhakhamubiganyaaga-biganyaaga. ");
INSERT INTO mgq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mʉ mpʉga yiila, álɨɨpo ʉmwantanda, we áamɨle nu wubhinu ʉwa kuzwa ɨbhanda. Uwubhinu wʉnʉʉwo wámuyimvwizye kʉ manha ishumi na gabhɨlɨ. Khabhɨlɨ ámalile ivintu vwakwe vwonti kʉ bhaganga, ɨleelo nʉʉmo we ámuponiizye. ");
INSERT INTO mgq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pe ʉmwantanda ʉla akhabhala kʉlʉsalo kwa Yeesu, akhapalamansya ipindilwi ɨlya mwenda waakwe, papaala akhapona uwubhinu waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","UYeesu akhabhʉzɨɨlɨzya akhatɨ, “Wu naanu we ampalamansya?” Abhantʉ bhonti bhakhakhaana. Pe uPeeteli akhamʉbhʉʉzya uYeesu akhatɨ, “We Mʉpɨtɨ, abhantʉ abhinji nhaani bhakusyetile, bhakukubiganya!” ");
INSERT INTO mgq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɨleelo uYeesu akhatɨ, “Alɨɨpo umuntu we ampalamansya, kʉnongwa ye ɨnkʉyɨlola kʉtɨ amakha ganeepa.” ");
INSERT INTO mgq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ʉmwantanda ʉla we aalola kʉtɨ uYeesu amʉmanya, akhabhala kumo akuyinga. Akhagwa pa vɨnama vwa Yeesu, akhamʉbhʉʉzya pɨlongolela pa bhantʉ bhonti zye zyámubhiishile kʉtɨ amʉpalamansye, khabhɨlɨ she aponile nalʉbhɨlo. ");
INSERT INTO mgq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","UYeesu akhamʉbhʉʉzya akhatɨ, “We mwalɨ waanɨ, ʉlwɨtɨkho lwakho lwakʉponɨa. Bhalaga ku wutengaanu!” ");
INSERT INTO mgq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","We uYeesu alɨ kʉlonga nʉ mwantanda ʉyo, akhɨnza umuntu kufuma kʉkhaaya kwa Yayɨlo, akhamʉbhʉʉzya ʉYayɨlo akhatɨ, “Lakha kʉmʉyɨmvwa uMumanyizyi, ʉmwalɨ waakho afuuye.” ");
INSERT INTO mgq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ɨleelo uYeesu we ayɨmvwa shɨnɨɨsho, akhamʉbhʉʉzya ʉYayɨlo akhatɨ, “Ʉtogopaje khaala, lyoli ʉyɨɨtɨshe. Ʉmwalɨ waakho atɨpone.” ");
INSERT INTO mgq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","UYeesu we aafikha kʉkhaaya kwa Yayɨlo, akhabhakhaana abhantʉ abhanjɨ kwinjila peeka nawo, lyoli uPeeteli, uYookhani, ʉYaakobo, uyise nu nyina wa mʉlɨndʉ. ");
INSERT INTO mgq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abhantʉ bhonti bhe bhálɨɨpo paala, bhakhalɨlaga na kʉyɨlʉmbʉʉzya kʉnongwa yaakwe. UYeesu akhabhabhʉʉzya akhatɨ, “Lashi kʉlɨla! Ʉmʉlɨndʉ ʉnʉ atafuuye, asʉpɨlɨɨye bhʉʉlo.” ");
INSERT INTO mgq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Abhantʉ bhaala we bhɨmvwa shɨnɨɨsho, bhakhamʉsekha uYeesu, kʉnongwa ye bhámanyile kʉtɨ ʉmʉlɨndʉ ʉla afuuye. ");
INSERT INTO mgq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","UYeesu akhamʉlema ɨnyoobhe umufwe ʉla, akhamʉbhɨlɨshɨla kwi zi akhatɨ, “We mwana, yɨmɨɨlɨla!” ");
INSERT INTO mgq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Akhabhalɨlo khanaakho, ʉmʉlɨndʉ ʉla, uwuumi waakwe wʉkhagalʉkha, akhɨmɨɨlɨla. UYeesu akhabhalajɨzya kʉtɨ bhaamupe ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abhapaafi bhaakwe bhakhaswiga nhaani, ɨleelo uYeesu akhabhasokha kʉtɨ bhatakhamʉbhʉʉzye umuntu nʉʉmo zye zifumiiye. ");
INSERT INTO mgq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","UYeesu akhabhabhɨlɨshɨla abhalandati bhaakwe ishumi na bhabhɨlɨ. Akhaabhapa amakha nʉ waamʉlo ʉwa kʉbhɨnga amapepu amabhiibhi, na ga kʉbhaponɨa abhabhinu. ");
INSERT INTO mgq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Khabhɨlɨ akhabhasonteelezya kʉlʉmbɨɨlɨla intumi ɨzya wʉmwene wa Mʉlʉngʉ na kʉbhaponɨa abhabhinu. ");
INSERT INTO mgq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akhabhabhʉʉzya akhatɨ, “We mʉkʉshʉʉla, mʉtakhaapaye akhantʉ naakhamu: ɨndoogo, imbuguuli, ishaakulya, ɨnhela, awe amenda aga kwandʉlanya. ");
INSERT INTO mgq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inyumba yoyonti ye mwinjila, mʉkhabhanje mʉmwo, kufishila akhabhalɨlo khe mʉkhayɨsogola mʉ nhaaya yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ɨnga poponti paala pe bhatabhaposheela awe kʉbhatejeelezya, we mʉkʉsogola, mukhakunyuntaje ulusuuto mʉ vɨnama vwinyu, kʉbhasokha kʉtɨ bhakʉmʉkhaana wʉ Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pe abhasundikwa bhaala bhakhabhala mʉ nhaaya nɨɨzyo nɨɨzyo bhakhalʉmbɨlɨlaga iNtumi iNyinza, na kʉbhaponɨa abhabhinu kwonti kwe bhakhabhalaga. ");
INSERT INTO mgq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ʉmwene uHeloodi akhɨmvwa ɨnongwa zyonti zye uYeesu akhabhombaga. Zɨnɨɨzyo zɨkhamʉzyʉgʉnhanya nhaani, kʉnongwa ye abhantʉ bhamu bhakhalongaga bhakhatɨnjɨ uYeesu wu Yookhani uMwozyi azyushile kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bhamu bhakhalongaga bhakhatɨnjɨ, wu Eliya ayinzile winza. Bhamu bhakhalongaga bhakhatɨnjɨ, weeka mu bhakuwi abhɨ maandɨ azyushile. ");
INSERT INTO mgq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ɨleelo uHeloodi akhatɨ, “UYookhani ɨne námudumuuye itwe! Ishi, wu naanu we akʉbhomba ziniizi zye ɨnkʉzyɨmvwa?” Pe uHeloodi akhanzaga nhaani kʉlolana nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pe abhasundikwa bhaala bhakhagalʉkha kwa Yeesu, bhakhamʉbhʉʉzya zyonti zye bhábhombile. Pe akhabheega, bhakhabhala mʉ nhaaya ye bhakhatɨnjɨ Betisayida, ɨnga bhabhe bheene kukwilu. ");
INSERT INTO mgq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ɨleelo abhantʉ abhinji we bhaamanya kwe abhalile, bhakhamʉlandata kʉʉkwo. UYeesu akhabhaposheela akhinza, akhabhamanyɨzyaga intumi ɨzya wʉmwene wa Mʉlʉngʉ. Khabhɨlɨ bhe bháamɨle nu wubhinu, akhabhaponɨaga. ");
INSERT INTO mgq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","We kwabha shalyabheela, abhalandati bhaakwe ishumi na bhabhɨlɨ bhakhabhala kwa Yeesu, bhakhatɨ, “Ʉbhɨtɨshɨzye abhantʉ bhabhale mʉ nhaaya ɨzya mʉpɨɨpɨ na mu vwizi, ɨnga bhalaabhe ishaakulya na pa kʉgona, kʉnongwa ye ɨpa pe tʉlɨ shilozu sheene patalɨ naakhamu akha kʉbhaavwa.” ");
INSERT INTO mgq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","UYeesu akhabhabhʉʉzya akhatɨ, “Bhape mʉneemwe ishaakulya!” Bhakhamwamʉla bhakhatɨ, “Ɨtwe tʉtalɨ nakho naakhamu, lyoli amakaati gasaanʉ ni nswi zɨbhɨlɨ nyeene. Bhanga tʉbhale tʉkale ishaakulya ɨshamwabho she shɨngabhakwɨla abhantʉ bhonti ɨbha!” ");
INSERT INTO mgq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Abhantʉ bhe bhálɨɨpo paala, abhasakhaala bheene bháamɨle ielufu zɨsaanʉ (5,000). Ɨleelo uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Bhɨɨkhazye abhantʉ mʉ vɨpʉga ɨvwa bhantʉ amashumi gasaanʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pe bhakhabhomba anza she ábhabhuziizye, abhantʉ bhonti bhakhɨɨkhala. ");
INSERT INTO mgq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pe uYeesu akheega amakaati gaala gasaanʉ ni nswi ziila zɨbhɨlɨ, akheenya kʉmwanya, akhavɨsaya. Akhamensulanyaaga amakaati gaala, akhabhapanga abhalandati bhaakwe bhabhagabhɨlaje abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Abhantʉ bhonti bhakhalya, bhakhiikuta. Abhalandati bhaakwe bhakhabhʉngaanya ɨnsenyenha, zikhiizula ɨvɨtʉndʉ ishumi na vɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isiku limo, uYeesu na bhalandati bhaakwe bháamɨle peeka, kukwilu, uYeesu akhapuutaga kwa Mʉlʉngʉ. Pɨlongolela, akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “Abhantʉ bhakʉtɨ ɨne ne naanu?” ");
INSERT INTO mgq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhakhamwamʉla bhakhatɨ, “Bhamu bhakʉtɨ, ɨwe we Yookhani uMwozyi, bhamu bhakʉtɨ we Eliya. Bhamu bhakʉtɨ ɨwe we mukuwi weeka mu bhakuwi abhɨ maandɨ we azyushile.” ");
INSERT INTO mgq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","UYeesu akhabhabhʉzɨɨlɨzya winza akhatɨ, “Nɨɨmwe, mʉkʉtɨ ɨne ne naanu?” UPeeteli akhamwamʉla akhatɨ, “Ɨwe we Kilisiti, we ʉMʉlʉngʉ átɨlɨ akhayɨmʉsonteelezya!” ");
INSERT INTO mgq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","UYeesu akhabhasokha kʉtɨ, bhatakhamʉbhʉʉzye umuntu nʉʉmo ɨnongwa zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","UYeesu akhabhabhʉʉzya winza akhatɨ, “ɄMwana wa Muntu yɨkwanzɨwa kʉyɨmba amayɨmba amapɨtɨ, kʉkhaanwa na bhasongo abha Bhayahuudi, abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo. Akhayɨgogwa, ɨleelo akhayɨzyʉkha isiku ɨlya wʉtatʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pɨlongolela, uYeesu akhabhabhʉʉzya bhonti akhatɨ, “Umuntu wowonti ʉla we akwanza kʉndandata ɨne, akwanzɨwa ayɨkhaane wʉʉyo, apɨmbe ɨshɨkhobhenhanyo shaakwe, andandate ɨne. ");
INSERT INTO mgq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kʉnongwa ye umuntu we akwanza kʉwʉpokha uwuumi waakwe wʉʉyo, akhayɨwʉteezya. Ɨleelo ʉla we akuwufumwa uwuumi waakwe kʉnongwa yaanɨ, akhayɨwʉpokha. ");
INSERT INTO mgq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Umuntu angakabha akhooni ɨnga aapata vwonti ɨvwa mʉ nsɨ, ɨleelo ateezya uwuumi waakwe? ");
INSERT INTO mgq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Umuntu wowonti we akʉndolela insoni pa bhantʉ ɨne nɨ manyɨzyo zyanɨ, woope ʉMwana wa Muntu we akwikha mu wumwamu waakwe, nʉ wa Taata nʉ wa bhakhabhɨzya abhafinjile, akhayɨmʉlolela insoni umuntu wʉnʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nalyoli ɨnkʉbhabhʉʉzya ɨnkʉtɨ, panaapa bhalɨɨpo abhantʉ bhe bhakhayɨlola kwɨnza kʉ wʉmwene wa Mʉlʉngʉ we bhashɨɨlɨ kufwa.” ");
INSERT INTO mgq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","We zyashɨla insiku naane kufuma pe akhalongaga amazwi ganaago, uYeesu akhabheega uPeeteli, uYookhani, nʉ Yaakobo, akhazʉbha nabho mwɨ gamba kupuuta. ");
INSERT INTO mgq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","We akupuuta, akhagalʉnhana pamiiso na menda gaakwe gakhabha mazelu, gakhalama nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Akhabhalɨlo khanaakho, bhakhafumila abhasakhaala bhabhɨlɨ bhe bhakʉlama mu wumwamu wa Mʉlʉngʉ. Abhasakhaala bhanaabho bháamɨle wʉ Moose nu Eliya, bhakhalongaga nu Yeesu. Bhakhalongaga nawo she atɨmalɨɨlɨzye zye ʉMʉlʉngʉ ásɨbhɨlɨɨye, ɨzya kufwa kwakwe mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Akhabhalɨlo khanaakho uPeeteli na bhamwabho bhágonile. Ɨleelo we bhakʉdaamʉkha, bhakhalola uwumwamu wa Yeesu, khabhɨlɨ bhakhabhalola abhasakhaala bhabhɨlɨ bhɨmɨlɨɨye peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Abhantʉ bhaala bhabhɨlɨ we bhakʉlenhaana nu Yeesu, uPeeteli akhamʉbhʉʉzya uYeesu akhatɨ, “We mʉpɨtɨ, khinza kʉtɨ ɨtwe twɨkhalaje ɨpa! Ɨnga ʉkwanza, ɨntɨzenje ivwegwi vɨtatʉ: sheeka shɨbhe shaakho, shimo shɨbhe sha Moose, nɨ shamwabho shɨbhe sha Eliya.” Atakhamanya lye akʉlonga. ");
INSERT INTO mgq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","UPeeteli we akʉlonga amazwi ganaago, lɨkhɨnza ɨbhɨngo likhabhagubishila, ɨpo pe bhakhoogopa nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pe bhakhɨmvwa izi kufuma mwɨ bhɨngo lɨkʉtɨ, “Ʉnʉ we Mwana waanɨ we ɨmʉsabhʉʉye, mʉmwɨmvwaje ʉweene!” ");
INSERT INTO mgq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Izi lɨnɨɨlyo we lyavwɨnha, uYeesu akhalolekha alɨ mwene. Abhalandati bhaakwe bhakhapʉʉma mye. Mu nsiku zɨnɨɨzyo bhatámubhuziizye umuntu nʉʉmo zye bházilolile. ");
INSERT INTO mgq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ɨndaabhɨ yaakwe, uYeesu na bhalandati bhaala bhatatʉ we bhiikha kufuma mwɨ gamba, bhakhakhomaana nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kufuma mʉ mpʉga yiila umuntu ʉmo akhabhɨlɨshɨla akhatɨ, “We Mumanyizyi, ɨnkʉlaabha ʉmwenye ʉmwana waanɨ, kʉnongwa ye ɨndɨ nawo wʉnʉʉnʉ mwene. ");
INSERT INTO mgq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ipepu ibhiibhi likumubudaga, panaapo akʉkhoolaga nhaani. Khabhɨlɨ likumuyinzanya na kumugwisya paasɨ, likumuzilisya, kumo ʉmʉtatafʉla wukumufuma kwi lomu. Ipepu liniili lɨkʉmʉyɨmvwa nhaani, lɨtakʉmʉleshezya, lyoli khashe bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naabhalaabhile abhalandati bhaakho kʉtɨ bhalɨbhɨnje, bhaapotiilwe.” ");
INSERT INTO mgq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","UYeesu akhaamʉla akhatɨ, “Ɨmwe mushipaafi she shɨtakwɨtɨkha, she shiteejile. Ɨntɨyɨɨkhale nɨɨmwe kufishila liino? Imbajimbiilile paka liino? Mʉleete kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","We bhakʉmʉtwala, ipepu liila likhamugwisya paasɨ, likhaamupa ishizilisi. Pe uYeesu akhalɨkhajɨla ipepu ibhiibhi, akhamʉponɨa ʉmwana ʉla, akhamʉgalʉsya kwa yise waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abhantʉ bhonti we bhagalola amakha amapɨtɨ aga Mʉlʉngʉ she galɨ, bhakhaswiga nhaani. Abhantʉ bhaala we bhakuswiga zyonti zye uYeesu abhombile, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tejeelezyi akhinza zye ɨnkwanza kʉbhabhʉʉzya: ʉMwana wa Muntu atɨlonjeelelwe na kʉtwalwa mʉ nyoobhe zya bhalʉgʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ɨleelo abheene bhatakhazyaganyaaga zye uYeesu akhalongaga. Bháfisiilwe ɨnga bhatazyaganyaaje, khabhɨlɨ bhakhoogopa kʉmʉbhʉzɨɨlɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abhalandati bha Yeesu bhakhanda kʉdalɨnhana kʉtɨ wu naanu we mʉpɨtɨ mʉ shɨpʉga shaabho. ");
INSERT INTO mgq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","UYeesu akhamanya ɨnsɨɨbho zyabho, pe akhamwega ʉmwana umunsi, akhamwɨmɨɨlɨsya papɨɨpɨ na wʉʉyo, ");
INSERT INTO mgq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","akhabhabhʉʉzya akhatɨ, “We akʉmʉposheela ʉmwana umunsi anza wʉnʉʉnʉ kwɨ taawa lyanɨ, akʉmposheela neene. Khabhɨlɨ we akʉmposheela ɨne, akʉmʉposheela nʉ Taata we ansonteleziizye. Kʉnongwa ye we munsi kukwinyu mwenti, wʉnʉʉyo we mʉpɨtɨ kʉshɨla bhonti.” ");
INSERT INTO mgq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","UYookhani akhamʉbhʉʉzya uYeesu akhatɨ, “We Mʉpɨtɨ, twaamulolile umuntu ʉmo akʉbhɨnga amapepu amabhiibhi kwɨ taawa lyakho, twaamukhaanile, kʉnongwa ye atalɨ peeka nɨɨtwe.” ");
INSERT INTO mgq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","UYeesu akhamwamʉla akhatɨ, “Mʉtamʉkhaanaje, kʉnongwa ye umuntu we atakʉbhakhaana, alɨ peeka nɨɨmwe.” ");
INSERT INTO mgq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Insiku zyakwe ɨzya kʉzʉbha kʉmwanya we zyapalamɨla, uYeesu akhaamʉla kʉbhala ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pe akhabhasonteelezya abhantʉ bhalongolele mʉ nhaaya ɨya Bhasamaliya ɨnga bhamʉlɨnganɨzanye pamu. ");
INSERT INTO mgq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɨleelo abhantʉ abha kukuula bhakhakhaana kʉmʉposheela, kʉnongwa ye ákhambɨɨye kʉbhala ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abhalandati bhaakwe ʉYaakobo nu Yookhani, we bhaalola lɨnɨɨlyo, bhakhatɨ, “We Mwene, ʉkwanza tʉlaabhe ʉmwoto wiishe kufuma kʉmwanya wʉbhapembe, anza she umukuwi uEliya woope ábhombile?” ");
INSERT INTO mgq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ɨleelo uYeesu akhagalʉnhana kʉbheenya, akhabhakhajɨla. Akhatɨ, “Ɨmwe mutamanyile ɨnjendo zyinyu she zɨlɨ, kʉnongwa ye ʉMwana wa Muntu atínzile kʉyazya, lyoli áyinzile kʉbhatʉʉla abhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bhakhasogola bhakhabhala mʉ khakhaaya akhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","UYeesu na bhalandati bhaakwe we bhalɨ mwɨ dala, umuntu ʉmo akhamʉbhʉʉzya uYeesu akhatɨ, “Ɨntɨkʉlandate kwonti kwe ʉkʉbhala!” ");
INSERT INTO mgq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","UYeesu akhatɨ, “Ɨmbɨla zɨlɨ nɨ ngwenya, inyonyi zɨlɨ ni vwanswi, ɨleelo ʉMwana wa Muntu atalɨ ni nyumba ɨya kwɨkhala.” ");
INSERT INTO mgq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","UYeesu akhamʉbhʉʉzya umuntu ʉwamwabho akhatɨ, “Ndandataje!” Umuntu ʉla akhatɨ, “We Mwene, ʉnɨtɨshɨzye ɨmbale suuti, ɨmʉsyɨle uyise waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","UYeesu akhamwamʉla akhatɨ, “Bhaleshe abhafwe bhabhasyɨlaje abhafwe bhaabho. Lyoli ɨwe, bhalaga kʉvwɨnsya ʉwʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Woope ʉwamwabho akhamʉbhʉʉzya uYeesu akhatɨ, “We Mwene, ɨntɨkʉlandate, ɨleelo ʉnɨtɨshɨzye suuti ɨmbale ɨndaje kʉkhaaya.” ");
INSERT INTO mgq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","UYeesu akhamʉbhʉʉzya akhatɨ, “Umuntu ɨnga ayanda kʉlɨma nɨ ngʼombe, kumo akʉgalʉnhana kwenya kʉlʉsalo, ʉyo atakhondeeye kʉbha mubhombi mʉ wʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pɨlongolela, ʉMwene uYeesu akhasebha abhalandati abhamwabho amashumi saba na bhabhɨlɨ, kʉtɨ abhasonteelezye. Pe akhabhasonteelezya bhabhɨlɨ bhabhɨlɨ mʉ nhaaya na mʉmbalɨ zyonti kwe akhasɨɨbhaga kʉbhala wʉʉyo, ɨnga bhalongolele. ");
INSERT INTO mgq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akhabhabhʉʉzya akhatɨ, “Ɨvɨyabho vwinji vweleeye mu shiizi, ɨleelo abha kʉsezya bhalɨ bhashe. Pe mʉlaabhaje ʉMwene ʉMʉlʉngʉ ʉwa vɨyabho, ɨnga abhasonteelezye abha kʉsezya ɨvɨyabho vwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ishi bhalaji, ɨleelo mʉmanye kʉtɨ ɨnkʉbhasonteelezya ngatɨ nyaana zyɨ ngoole pakaasi pa mbwa inhali ɨzya mwɨ laala! ");
INSERT INTO mgq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mʉtakhaapaye ɨnhela, imbuguuli, awe ɨvɨlyatʉ ɨvwa kwandʉlanya. Khabhɨlɨ mʉtamʉlamʉkhaje umuntu ngaweeka mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Inyumba yoyonti ye mwinjila, mʉlamʉkhaje suuti mʉtɨnjɨ, ‘ɄMʉlʉngʉ aabhape uwutengaanu mu nyumba ɨnɨ.’ ");
INSERT INTO mgq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɨnga uwi nyumba abhaposheela ku wutengaanu, pa nyumba yɨnɨɨyo patɨbhe nu wutengaanu. Lyoli ɨnga uwi nyumba atakʉbhaposheela ku wutengaanu, pe uwutengaanu wiinyu wʉtɨbhagalʉshɨle ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mʉtasamangaje, lyoli inyumba ye bhabhaposheela mʉkhɨkhalaje mʉmwo, mʉkhamwelaje na kulya ishaakulya she bhakʉʉbhapa, kʉnongwa ye umubhombi akhondeeye kʉtɨ aposheelaje kufumilana nɨ mbombo yaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ɨnga mwinjila mʉ nhaaya yimo, abhakhaaya bhabhaposheela kʉ lʉseshelo, mʉkhalyanje ishaakulya shoshonti she bhakʉʉbhapa. ");
INSERT INTO mgq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mʉbhaponɨaje abhabhinu bhe bhalɨ mʉ nhaaya yɨnɨɨyo, mʉbhabhʉzyaje kʉtɨ, ‘Ʉwʉmwene wa Mʉlʉngʉ wʉpalamɨɨye!’ ");
INSERT INTO mgq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ɨleelo ɨnga mwinjila mʉ nhaaya yoyonti, bhatabhaposheela, mʉkhasogolaje mwenemwo. We mʉkʉshɨla mʉ madala gaabho, mʉtɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Poope amasuuto agɨ nhaaya yiinyu ge galɨ mʉ vɨnama vwɨtʉ, tukukunyunta kʉtɨ wʉbhe wukeeti ʉwa kʉbhasokha. Ɨleelo mʉmanye kʉtɨ ʉwʉmwene wa Mʉlʉngʉ wʉpalamɨɨye!’ ");
INSERT INTO mgq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ɨnkʉbhabhʉʉzya kʉtɨ, isiku ɨlya kʉlongwa, ɨnhaaya yɨnɨɨyo yɨkhayɨlongwa ulufundo ʉlʉpɨtɨ kʉshɨla luula ʉlwa bhantʉ abha mʉ nhaaya ɨya mu Sodoomu!” ");
INSERT INTO mgq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Akhatɨ, “Mʉsheleeye mʉbhantʉ abhɨ nhaaya ɨya mu Kolaziini! Mʉsheleeye mʉbhantʉ abhɨ nhaaya ɨya mu Betisayida! Kʉnongwa ye amayele ge nábhombile kukwinyu, ɨnga ɨnhabhombaga mʉ nhaaya ɨya mu Tiilo nɨ ya mu Sidooni, abhantʉ abha mʉ nhaaya zɨnɨɨzyo nhanɨ bhalaatile khalɨ na kʉkwata amafuuku na kʉyɨpakha amalota kʉlolesya kʉlaata imbiibhi zyabho. ");
INSERT INTO mgq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ishi, pi siku ɨlya kʉlongwa, ɨmwe mʉkhayɨlongwa ulufundo ʉlʉpɨtɨ kʉshɨla ʉlwa bhantʉ abha mu Tiilo na bha mu Sidooni! ");
INSERT INTO mgq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nɨɨmwe mʉbhantʉ abha mʉ nhaaya ɨya mu Kapelenaumu, bhʉlɨ, mʉkʉsɨɨbha kʉtɨ ʉMʉlʉngʉ akhayɨbhazʉvwa paka kʉmwanya? Ndaali, akhayibhiisya paka kwɨlongo!” ");
INSERT INTO mgq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe bhaala akhatɨ, “Umuntu we akʉbhɨmvwa ɨmwe, akʉnɨmvwa neene, we akʉbhakhaana ɨmwe, akʉnhaana neene. Khabhɨlɨ we akʉkhaana kʉmposheela ɨne, akʉkhaana kʉmʉposheela nʉ Taata we ansonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pɨlongolela, abhalandati bha Yeesu amashumi saba na bhabhɨlɨ bhakhagalʉkha bhashiiye, bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “We Mwene, goope amapepu amabhiibhi gatutinikhaga, we tʉkʉgabhɨnga kwɨ taawa lyakho!” ");
INSERT INTO mgq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","UYeesu akhabhabhʉʉzya akhatɨ, “Imulolile uSeetani akwikha ngatɨ mvula ye yɨkʉmwangʉkha kufuma kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yeenya, imbapiiye ʉwaamʉlo ʉwa kʉmʉtola ʉmʉlʉgʉ mu zyonti. Kʉ makha ganaago mʉtɨkhanyaje ɨnjokha ni inge, khabhɨlɨ khatalɨɨpo akhantʉ akha kʉbhavwalazya. ");
INSERT INTO mgq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɨleelo ɨnga mʉkʉseshela kʉnongwa ye amapepu amabhiibhi gakubhatinikha, mʉleshe kʉseshela kʉ lɨnɨɨlyo lyene, lyoli mʉseshelaje kʉnongwa ye amataawa giinyu gasimbiilwe nʉ Mʉlʉngʉ kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Akhabhalɨlo khanaakho, uMupepu uMufinjile akhamʉbhɨɨkha uYeesu kʉseshela nhaani akhatɨ, “Inkukusalifwa we Taata, wʉMwene ʉwa kʉmwanya na paasɨ, kʉnongwa ye ubhafisile abhantʉ abhɨ njeele na bhabhaazye ɨnongwa ziniizi, ɨleelo uzibhiishile apazelu kʉ bhaana abhansi. Nalyoli we Taata, shɨnɨɨsho she wáyiganile.” ");
INSERT INTO mgq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Khabhɨlɨ akhatɨ, “ɄTaata waanɨ ampiiye ivintu vwonti. Atalɨɨpo umuntu we amumanyile ʉMwana, lyoli ʉTaata waanɨ mwene. Khabhɨlɨ atalɨɨpo umuntu we amumanyile ʉTaata, lyoli ʉMwana mwene, nu muntu wowonti we ʉMwana ayiganile kʉmʉlanga.” ");
INSERT INTO mgq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pe uYeesu akhagalʉnhana kʉbheenya abhalandati bhaakwe akhabhabhʉʉzya akhatɨ, “Musayiilwe ɨmwe mʉbhantʉ mwe mʉkʉgalola ɨga! ");
INSERT INTO mgq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ɨnkʉbhabhʉʉzya kʉtɨ, abhakuwi abhinji na bhamwene bháyiganile kʉzɨlola zye mʉkʉzɨlola ɨmwe, ɨleelo bhatázilolile. Khabhɨlɨ bháyiganile kwɨmvwa zye mʉkwɨmvwa ɨmwe, ɨleelo bhatázyimvwizye.” ");
INSERT INTO mgq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Panaapo umumanyizyi weeka ʉwɨ ndajɨzyo akhɨmɨɨlɨla, akhamʉbhʉzɨɨlɨzya uYeesu kʉmʉlɨnga akhatɨ, “We Mumanyizyi, ɨmbombe lyoni ɨnga akhabhalɨlo khe khakwɨnza ɨnhawaaje uwuumi ʉwa wiila?” ");
INSERT INTO mgq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","UYeesu akhamwamʉla akhatɨ, “Yisimbiilwe yɨtɨlɨ bhʉlɨ mʉ ndajɨzyo zya Moose? Ʉkʉzyaganya bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akhamwamʉla akhatɨ, “Yisimbiilwe mʉnʉʉmwo kʉtɨ, ‘Ʉmʉgane ʉMwene ʉMʉlʉngʉ waakho kʉ mwoyo waakho wonti, na ku mupepu waakho wonti, na kʉ makha gaakho gonti, na kʉ njeele zyakho zyonti.’ Khabhɨlɨ, ‘Ʉmʉgane uwamwinyu anza she uyiganile wʉneewe.’” ");
INSERT INTO mgq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","UYeesu akhatɨ, “Waamʉla akhinza! Ʉbhombe shɨnɨɨsho, ɨpo pe ʉtɨbhe nu wuumi ʉwa wiila.” ");
INSERT INTO mgq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɨleelo umumanyizyi ʉwɨ ndajɨzyo ʉla akhanzaga kʉyɨbhɨɨkha kʉtɨ we akhondeeye pamiiso ga Mʉlʉngʉ, akhamʉbhʉzɨɨlɨzya winza uYeesu akhatɨ, “Ishi, ʉwamwɨtʉ wu naanu?” ");
INSERT INTO mgq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","UYeesu akhamwamʉla akhatɨ, “Álɨɨpo umuntu ʉmo, áfumile mu Yelusaleemu, akhabhalaga mʉ nhaaya ɨya mu Yeeliko. Mwɨ dala, akhalemwa na bhabuda, bhakhamʉzʉʉla amenda, bhakhamʉkhoma nhaani, bhakhamʉlekha abhinile ɨya kufwa. ");
INSERT INTO mgq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Panaapo umupuutili ʉmo akhashɨlaga mwɨ dala liila, we amʉlola umuntu ʉla, akhasela kʉmbalɨ. ");
INSERT INTO mgq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Woope uMulaawi we aafikha paala akhamʉlola umuntu ʉla, akhasela kʉmbalɨ. ");
INSERT INTO mgq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pɨlongolela, akhɨnza uMusamaliya weeka, we akhashʉʉlaga kʉshɨlɨla mwɨ dala liila. We amʉlola umuntu ʉla, akhamʉlolela ishisa, ");
INSERT INTO mgq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","akhasejeelela, akhamʉpakha idivaayi na mafuta mʉ malonda gaakwe, akhamupinya. Akhamʉzʉvwa pamwanya pa ndogomi yaakwe, akhamʉtwala mu nyumba ɨya bhajeni, akhamʉsʉngaga. ");
INSERT INTO mgq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","We kwasha, akhafumwa idinaali zɨbhɨlɨ, akhaamupa uwi nyumba yiila, akhamʉbhʉʉzya akhatɨ, ‘Umubhinie umuntu ʉnʉ. Ɨnga ɨnhela izi zyasila, waafumwa ɨzyakho kʉnongwa ya kʉmwavwa, we nagalʉkha, ɨnhayɨkʉgalʉshɨzya.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pe uYeesu akhamʉbhʉzɨɨlɨzya umumanyizyi ʉwɨ ndajɨzyo ʉla akhatɨ, “Ishi, mʉ bhɨɨbha bhatatʉ, wu naanu we ʉkʉsɨɨbha kʉtɨ wamwabho wa nalyoli ʉwa wʉʉla we ábudiilwe na bhabuda?” ");
INSERT INTO mgq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Akhaamʉla akhatɨ, “We ámʉloleeye ishisa.” UYeesu akhamʉbhʉʉzya akhatɨ, “Nɨɨwe bhalaga ʉbhombe shɨnɨɨsho!” ");
INSERT INTO mgq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","UYeesu na bhalandati bhaakwe we bhalɨ mwɨ dala bhakʉbhala ku Yelusaleemu, bhakhafikha mʉ khakhaaya khamu. Panaapo ʉmwantanda weeka, we bhakhatɨnjɨ uMalita, akhamʉposheela uYeesu mu nyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","UMalita áamɨle nu munsi waakwe we bhakhatɨnjɨ uMaliya. Akhabhalɨlo khanaakho, uMaliya áyɨkhaaye pambalɨ pa vɨnama vwa Mwene uYeesu, akhatejelezyaga ɨmanyɨzyo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ɨleelo uMalita ápilinhiine nɨ mbombo inyinji ɨzya kʉmʉposheela uYeesu. Pe akhamʉbhʉʉzya uYeesu akhatɨ, “We Mwene, ʉtakʉlola khabhiibhi we umunsi waanɨ andesheeye ɨmbombo zyonti nʉmwene? Ishi mʉbhʉʉzye anaavwe!” ");
INSERT INTO mgq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ɄMwene uYeesu akhamwamʉla akhatɨ, “Malita, Malita, khooni khe ʉkʉyɨmba ni nyinji? ");
INSERT INTO mgq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Khakwanzɨwa akhantʉ kheeka kheene akhinza. Khanaakho khe uMaliya asabhʉʉye, atangafwʉlwa.” ");
INSERT INTO mgq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isiku limo, uYeesu áamɨle apantʉ pamu, akhapuutaga kwa Mʉlʉngʉ. We aamala, umulandati waakwe weeka akhatɨ, “We Mwene, ʉtʉmanyɨzye kupuuta kwa Mʉlʉngʉ, anzu Yookhani she ábhamanyiziizye abhalandati bhaakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","UYeesu akhabhabhʉʉzya akhatɨ, “We mukupuuta kwa Mʉlʉngʉ, mʉtɨnjɨ: ‘We Taata wɨɨtʉ ʉwa kʉmwanya, ɨtaawa lyakho lɨpalwaje. Ʉwʉmwene waakho wɨnze. Ɨshɨgane shaakho shɨbhombekhaje mʉ nsɨ umu, anza she zɨkʉbhombekha kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ʉtʉpanje ishaakulya shɨɨtʉ insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ʉtʉtʉʉyɨle imbiibhi zyɨtʉ, kʉnongwa ye nɨɨtwe tʉkʉbhatʉʉyɨla bhe bhakʉtʉbhombela amabhiibhi. Ʉtʉlongolaje ɨnga tutakhinjile mʉ ndɨngo, lyoli ʉtʉposhe kwa mʉbhomba mbiibhi uSeetani.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pe akhabhabhʉʉzya ɨshɨkholanyo akhatɨ, “Tʉtɨ umuntu ʉmo mukaasi yiinyu akʉbhala kwa manyani waakwe shawusiku pakaasi, kʉlaabha akhantʉ. Akʉmʉbhʉʉzya akʉtɨ, ‘We manyani, ɨnkʉlaabha ʉnhopele amakaati gatatʉ, ");
INSERT INTO mgq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kʉnongwa ye umanyani waanɨ ayɨnza kʉkwanɨ akʉshʉʉla, ɨleelo ɨne ɨntalɨ ni shaakulya ɨsha kuumupa.’ ");
INSERT INTO mgq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Woope umanyani wʉnʉʉyo akʉmwamʉla akʉtɨ, ‘Lakha kʉnjɨmvwa! Ɨnɨgalɨɨye ulwiji, khabhɨlɨ ɨne na bhaana bhaanɨ tugonile. Ɨntangakhola kʉdaamʉkha inkupe khokhonti!’ ");
INSERT INTO mgq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ɨnkʉbhabhʉʉzya kʉtɨ, atɨdaamʉshe na kuumupa vwe abhuliliilwe, te kʉnongwa ye wu manyani waakwe, lyoli kʉnongwa ye ajendeelela kʉmʉlaabha. ");
INSERT INTO mgq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ishi ɨnkʉbhabhʉʉzya kʉtɨ, laabhaji nɨɨmwe mʉtɨposheele, yanzaji nɨɨmwe mʉtɨvwaje, yiguzyaji nɨɨmwe mutiyigulilwe. ");
INSERT INTO mgq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kʉnongwa ye umuntu wowonti we akʉlaabha, akʉposheela, we akwanza, akʉvwaga, woope we akwiguzya, akwigulilwa. ");
INSERT INTO mgq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bhʉlɨ, wu naanu mukaasi yiinyu we ɨnga ʉmwana waakwe akʉmʉlaabha ikaati, angaamupa ɨnjokha, atakuumupa ikaati? ");
INSERT INTO mgq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Awe akʉmʉlaabha ɨjɨnza, angaamupa uinge? ");
INSERT INTO mgq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe shɨnɨɨsho, ɨnga ɨmwe mʉbhabhomba mbiibhi mumanyile kʉʉbhapa abhaana bhiinyu ivintu ivwinza, mʉbhe nu lusimishizyo kʉtɨ ʉTaata wiinyu ʉwa kʉmwanya atɨbhabhombele akhinza nhaani, bhe bhakʉmʉlaabha akhayɨɨbhapa uMupepu uMufinjile.” ");
INSERT INTO mgq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isiku limo, uYeesu akhabhɨngaga ipepu ibhiibhi mwa muntu ʉmo. Ipepu lɨnɨɨlyo lɨkhamʉbhɨɨkhaga umuntu wʉnʉʉyo kʉbha wu shinuunu, we lyafuma, umuntu ʉla akhanda kʉlonga. Abhantʉ abhinji bhe bhálɨɨpo, bhakhaswiga nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ɨleelo bhamu mukaasi yaabho bhakhatɨ, “Akʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Belizebuuli, ʉmʉpɨtɨ wa mapepu!” ");
INSERT INTO mgq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhamu bhakhamʉlɨngaga uYeesu kʉtɨ abhalanje ɨshɨlolesyo she shikufuma kʉmwanya kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ɨleelo uYeesu akhamanya ɨnsɨɨbho zyabho. Pe akhabhabhʉʉzya akhatɨ, “Abhantʉ abha wʉmwene weeka ɨnga bhagabhʉnhana ɨvɨpʉga vwe vɨtakwɨmvwana, ʉwʉmwene wʉnʉʉwo wʉkʉnanjɨkha. Bhoope abhantʉ abha mu nyumba yeeka ɨnga bhanda kulwa bhɨɨbho na bhɨɨbho, inyumba yɨnɨɨyo yɨkʉnanjɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","She zɨlɨ, ɨnga uSeetani akulwa na maseetani agamwabho nʉ wʉmwene waakwe wugabhunhiine, wʉngɨmɨɨlɨla anza bhʉlɨɨbhʉlɨ? Ɨnkʉlonga lɨnɨɨlyo kʉnongwa ye mʉkʉtɨ ɨnkʉbhɨnga amapepu amabhiibhi kʉ makha ga Belizebuuli. ");
INSERT INTO mgq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ishi, ɨnga ɨne ɨnkʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Belizebuuli, abhalandati bhiinyu bhakʉbhɨnga kʉ waamʉlo wa naanu? Mʉ lɨnɨɨlyo, abhalandati bhiinyu bhe bhatɨbhalonje. ");
INSERT INTO mgq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ɨleelo ɨne, ɨnga ɨnkʉbhɨnga amapepu amabhiibhi kʉ waamʉlo wa Mʉlʉngʉ, ishi ʉwʉmwene wa Mʉlʉngʉ wubhafishiiye ɨmwe! ");
INSERT INTO mgq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Umuntu ʉwa makha, ɨnga alɨ nɨ shɨlwɨlo, angalɨndɨɨlɨla inyumba yaakwe, atalɨɨpo ʉwa kwega ivintu vwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lyoli umuntu ʉwa makha kʉmʉshɨla ʉweene ɨnga ayɨnza, akumubuda na kʉmʉtola. Pe akʉmʉfwʉlɨla ɨvɨlwɨlo vwonti vwe asʉbhɨlaga, na kwega ivintu vwonti vwe vɨlɨ mu nyumba na kʉbhagabhɨla abhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Umuntu wowonti we atalɨ peeka nɨɨne akundindanjila. Khabhɨlɨ wowonti we atakʉbhʉngaanɨkha peeka nɨɨne, akʉsataanya. ");
INSERT INTO mgq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ipepu ibhiibhi we lyafuma mwa muntu, lɨkʉzyʉngʉʉla mu shilozu umwumu kwanza apa kʉtʉʉzya. Ɨnga lɨtapaaga, pe lɨkʉyɨlonga lɨkʉtɨ, ‘Ɨntɨgalʉshe ku nyumba yaanɨ ye naafumile.’ ");
INSERT INTO mgq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","We lyagalʉkha, lɨkwaga inyumba yiila nyʉʉse, khabhɨlɨ yizelupile akhinza. ");
INSERT INTO mgq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Panaapo pe lɨkʉbhala kwega amapepu amabhiibhi aganjɨ saba, amabhiibhi kʉshɨla lyene. Pe gakwinjila kwa muntu wʉnʉʉyo, gakwɨkhala. Panaapo ʉmʉbhɨlɨ wa muntu wʉnʉʉyo wʉkʉbha akhabhiibhi nhaani, kʉshɨla kʉwandɨlo.” ");
INSERT INTO mgq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","UYeesu we akʉlonga lɨnɨɨlyo, ʉmwantanda weeka mʉ shɨpʉga shiila akhadandɨzya izi akhatɨ, “Asayiilwe we akupaapile na kʉkwonsya!” ");
INSERT INTO mgq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","UYeesu akhalonga akhatɨ, “Bhasayiilwe nhaani bhe bhakwɨmvwa na kulitinikha izwi lya Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Abhantʉ we bhakʉjendeelela kʉbhʉngaana, uYeesu akhatɨ, “Abhantʉ abha shipaafi ishi, bhi mbiibhi nhaani, bhakwanza ɨndolesye ɨshɨlolesyo! Ɨleelo ɨntakʉʉbhapa ɨshɨlolesyo naashimo, lyoli ɨshɨlolesyo sha mukuwi ʉYoona. ");
INSERT INTO mgq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kʉnongwa ye anza she ʉYoona áamɨle shɨlolesyo kʉ bhantʉ abha mʉ nhaaya ɨya mu Ninaawi, she zɨlɨ ʉMwana wa Muntu woope atɨbhe shɨlolesyo kʉ bhantʉ abha shipaafi ishi. ");
INSERT INTO mgq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Isiku ɨlya kʉlongwa, ʉmwene ʉmwantanda ʉwɨ nsɨ ɨya Sheeba akhayɨmɨɨlɨla na kʉbhalonga abhantʉ abha khabhalɨlo ɨkha. Kʉnongwa ye ʉweene áfumile mʉ nsɨ ɨya kutali kʉtɨ ayɨnze atejeelezye ɨmanyɨzyo ɨzyɨ njeele ɨzya mwene uSelemaani. Ɨleelo ɨnkʉbhabhʉʉzya ɨmwe kʉtɨ alɨɨpo ɨpa we mʉpɨtɨ kʉmʉshɨla uSelemaani. ");
INSERT INTO mgq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Khabhɨlɨ isiku ɨlya kʉlongwa, abhantʉ abha mu Ninaawi bhoope bhakhayɨmɨɨlɨla kʉbhalonga ɨmwe mʉbha khabhalɨlo ɨkha kʉtɨ mwe bhi mbiibhi. Kʉnongwa ye ʉYoona we alʉmbɨɨlɨla izwi lya Mʉlʉngʉ kʉkwabho, bhakhalaata imbiibhi zyabho. Ishi ɨpa alɨɨpo ʉmʉpɨtɨ kʉshɨla ʉYoona! ");
INSERT INTO mgq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Atalɨɨpo umuntu we akʉkholeelezya ʉlʉkhozyo, na kʉbhɨɨkha pe puubhile awe kugubishila mʉ nsonta. Lyoli akʉbhɨɨkha pa shɨmbeeje, ɨnga abhantʉ we bhakwinjila, bhalolaje ʉlʉkhozyo lwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Amiiso ge lʉkhozyo lwa mʉbhɨlɨ. Ɨnga amiiso gaakho gakʉlola akhinza, pe ʉmʉbhɨlɨ waakho wonti wʉkʉbha nʉ lʉkhozyo. Ɨleelo ɨnga amiiso gaakho gafuuye, pe ʉmʉbhɨlɨ waakho wonti wʉkʉbha khiisi. ");
INSERT INTO mgq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pe ʉbhe amiiso, ʉlʉkhozyo lwe lʉlɨ mukaasi yaakho lʉtakhabhe khiisi. ");
INSERT INTO mgq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ishi ɨnga ʉmʉbhɨlɨ waakho wonti wabha nʉ lʉkhozyo, sita kʉbha na khiisi ngapeeka, pe ʉmʉbhɨlɨ wonti wʉtɨbhe muzelu, anzʉ lʉkhozyo she lʉkʉkʉlamɨla.” ");
INSERT INTO mgq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","UYeesu we aamala kʉlonga amazwi ganaago, uMufalisaayi ʉmo akhamʉlanjɨla abhale kulya kʉkwakwe. Pe uYeesu akhabhala, akhinjila, akhɨɨkhala kulya ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","UMufalisaayi ʉla we aalola uYeesu akulya sita kʉgeeza ɨnyoobhe anza she bhálʉbhɨɨye, akhaswiga nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pe ʉMwene akhamʉbhʉʉzya akhatɨ, “Ɨmwe muBhafalisaayi mʉkʉyɨbhɨɨkha mwe bhagolosu, we mʉkwozya ʉlʉpɨndɨ ni shiibho munzi, ɨleelo mukaasi mwizuuye uwufwuli nu wubhiibhi. ");
INSERT INTO mgq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mʉbhalema ɨmwe! We ápelile munzi, te wʉʉyo we ápelile na mukaasi? ");
INSERT INTO mgq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mʉbhavwaje abhapɨɨna kʉ mwoyo wiinyu wonti, pe vwonti vɨtɨbhe vizelupile kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mʉsheleeye ɨmwe Bhafalisaayi, kʉnongwa ye mukumufumwizya ʉMʉlʉngʉ ɨvwa pi shumi ɨvwa vɨlʉnjɨɨlɨlo ɨvwa shɨkholo nɨ shɨkholo, ɨleelo mʉtakʉsaajɨla kʉbhabhombela abhanjɨ inyinza awe kʉmʉgana ʉMʉlʉngʉ. Zɨnɨɨzyo zye mʉkhondeeye kʉbhomba sita kwɨwa aganjɨ. ");
INSERT INTO mgq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mʉsheleeye ɨmwe Bhafalisaayi, kʉnongwa ye mʉkʉyɨgana kwɨkhala mʉ matengo agɨ togo aga pɨlongolela mwi sinagoogi. Khabhɨlɨ mʉkwanza abhantʉ bhabhalamʉkhaje mʉ madala ngatɨ mwe bha lushindikho. ");
INSERT INTO mgq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mʉsheleeye kukwinyu, kʉnongwa ye mukholiine nɨ mbɨɨpa zye zɨtalɨ ni dunzu, abhantʉ bhakʉjenda pamwanya sita kʉmanya.” ");
INSERT INTO mgq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umumanyizyi weeka ʉwɨ ndajɨzyo akhamʉbhʉʉzya uYeesu akhatɨ, “Mumanyizyi, we ʉkʉlonga ganaago, ʉkʉtʉlonga khabhiibhi nɨɨtwe tubhamanyizyi bhɨ ndajɨzyo.” ");
INSERT INTO mgq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","UYeesu akhamwamʉla akhatɨ, “Nɨɨmwe mubhamanyizyi bhɨ ndajɨzyo, mʉsheleeye, kʉnongwa ye mukubhatwinha abhantʉ amazigo amamwamu ge gatakʉpɨmbɨkha. Nɨɨmwe mʉtakʉbhaavwa kʉpɨmba poope kʉlɨnjɨzya na khasamba! ");
INSERT INTO mgq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Mʉsheleeye kukwinyu, kʉnongwa ye mʉkʉzenga ɨmbɨɨpa zya bhakuwi bhaala bhe abhamaama bhiinyu bhábhagojile! ");
INSERT INTO mgq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Panaapo mʉkʉlolesya kʉtɨ, mʉkwɨtɨnhana na zye abhamaama bhiinyu bhábhombile, kʉnongwa ye abheene bhágojile, nɨɨmwe mʉkʉzenga ɨmbɨɨpa zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ye nongwa ʉMʉlʉngʉ kʉ njeele zyakwe álonjile átɨlɨ, ‘Ɨnhayɨbhasonteelezya kʉkwabho abhakuwi na bhasundikwa, bhamu bhakhayɨbhagoga, bhamu bhakhayɨbhayɨmvwa.’ ");
INSERT INTO mgq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ishi, ɨmwe mukhayifundwa kʉnongwa ya bhakuwi bhonti bhe bhágogiilwe, kufuma kʉwandɨlo ʉwɨ nsɨ, ");
INSERT INTO mgq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kufuma agogwe uAbeli kufishila pe ágogiilwe uZakaliya, we mwámugojile pakaasi pa shɨgemo na Pafinjile. Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, abhantʉ abha khabhalɨlo ɨkha bhakhayifundwa kʉ zya ganaago gonti. ");
INSERT INTO mgq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mʉsheleeye ɨmwe bhamanyizyi abhɨ ndajɨzyo, kʉnongwa ye mudindile ɨdala ɨlya bhantʉ kʉmʉmanya ʉMʉlʉngʉ. Poope nɨɨmwe mutamumanyile, khabhɨlɨ mubhadindiiye bhe bhalɨ nɨ shɨsaago ɨsha kʉmʉmanya ʉMʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","UYeesu we aamala kʉlonga amazwi ganaago, akhasogola paala. Kwandɨla panaapo aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhakhabha bhakhali nhaani kwa Yeesu. Bhakhamʉbhʉzɨlɨzyaga inyinji, ");
INSERT INTO mgq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ɨnga bhamʉteje, pamu atɨlonje zimo kʉtɨ bhalyaje ɨdala ɨlya kʉmʉlonjela. ");
INSERT INTO mgq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mʉ khabhalɨlo khanaakho, abhantʉ amaelufu na maelufu bhakhabhʉngaana kʉmʉtejeelezya uYeesu. Bháamɨle bhinji poope bhakhakhanyanaga we bhakʉsejeelela kʉkwakwe. Pe uYeesu akhalonga suuti ku bhalandati bhaakwe akhatɨ, “Mʉbhe amiiso ni shisa ɨshɨ lenga ɨsha Bhafalisaayi, kʉnongwa ye shɨkʉsaata ngatɨ wusafu. ");
INSERT INTO mgq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Akhabhalɨlo khakwɨnza khe gonti ge galɨ kukwilu gakhayɨbha apazelu, khabhɨlɨ gonti ge gafisishile gakhayɨmanyɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pe shɨnɨɨsho gonti ge mʉkʉlonga ku khiisi, gakhayɨvwɨnha apazelu. Khabhɨlɨ gonti ge mʉkʉsenha kukwilu, bhakhayɨgavwɨnsya pa mbɨmbɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","UYeesu akhajendeelela kʉlonga kʉtɨ, “Ɨmwe bhamanyani bhaanɨ, ɨnkʉbhabhʉʉzya kʉtɨ, mʉtabhogopaje bhe bhakʉgoga ʉmʉbhɨlɨ mwene, khatalɨɨpo akhanjɨ khe bhangakhola kʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lyoli ɨmbabhʉʉzye we mʉkhondeeye kʉmwogopa. Mwogopaje ʉMʉlʉngʉ! Kʉnongwa ye we bhanaabho bhaagoga, ʉweene alɨ nʉ waamʉlo ʉwa kʉmʉsʉmba umuntu kʉ mwoto we wutakuzima naalumo! Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, wʉnʉʉyo we mʉmwogopaje! ");
INSERT INTO mgq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Bhʉlɨ, ʉtʉdwaya tʉsaanʉ bhatakʉkazya kʉ nhela ɨnsabhaazya nyishe bhʉʉlo? Poope shɨnɨɨsho, ʉMʉlʉngʉ atakʉmwɨwa ngaweeka. ");
INSERT INTO mgq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɨleelo ɨmwe, insisi zyonti ɨzya mʉ matwe giinyu, ʉMʉlʉngʉ azibhaziizye. Pe shɨnɨɨsho mʉtogopaje, kʉnongwa ye ɨmwe mʉkhondeeye kʉshɨla ʉtʉdwaya utwinji. ");
INSERT INTO mgq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we akʉnɨɨtɨkha pɨlongolela pa bhantʉ, ʉMwana wa Muntu akhayɨmwɨtɨkha pɨlongolela pa bhakhabhɨzya bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ɨleelo umuntu wowonti we akʉnhaana pɨlongolela pa bhantʉ, woope akhayɨkhaanwa pɨlongolela pa bhakhabhɨzya bha Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Umuntu wowonti we akʉlonga amazwi amabhiibhi kʉ zya Mwana wa Muntu, akhayɨtʉʉyɨlwa. Ɨleelo we akʉmʉshoolanya uMupepu uMufinjile, wʉnʉʉyo te akhatʉʉyɨlwe. ");
INSERT INTO mgq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“We bhabhatwala mu masinagoogi, awe pɨlongolela pa bhamwene na pa bhapɨtɨ, mʉtakhaalabhe kʉsɨɨbha kʉtɨ mʉkhayɨlamba lyoni awe mʉkhayɨlonga lyoni. ");
INSERT INTO mgq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akhabhalɨlo khanaakho uMupepu uMufinjile akhayɨbhamanyɨzya zye mʉkhondeeye kʉlonga.” ");
INSERT INTO mgq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Umuntu weeka mʉ mpʉga yiila akhamʉbhʉʉzya uYeesu akhatɨ, “Mumanyizyi, mʉbhʉʉzye ʉkhambakʉ waanɨ kʉtɨ angabhɨle ivintu ɨvwa wugaali, vwe uyise wɨɨtʉ átʉlesheeye.” ");
INSERT INTO mgq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","UYeesu akhamwamʉla akhatɨ, “Wu naanu we ambiishile ɨne, kʉbha ne mwamuli wiinyu, awe kʉbha ne wakʉgabhanya uwugaali wiinyu?” ");
INSERT INTO mgq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pe akhabhabhʉʉzya abhantʉ bhonti akhatɨ, “Mʉbhe amiiso! Mʉleshe kʉbha mwe bhalyovi, kʉnongwa ye uwuumi wa muntu wutakufuma mu winji wa vintu vwe alɨ navwo.” ");
INSERT INTO mgq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pe akhabhabhʉʉzya ɨshɨkholanyo ishi akhatɨ, “Álɨɨpo udumbwe ʉmo, we mu shiizi shaakwe ɨvɨyabho vwéleeye nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akhasɨɨbha mʉ mwoyo waakwe akhatɨ, ‘Ɨvɨyabho vwanɨ ivi, patalɨɨpo apa kʉbhɨɨkha! Ɨntɨkhonzye bhʉlɨ?’ ");
INSERT INTO mgq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pe akhatɨ, ‘Ɨntɨbhombe ɨntɨtɨ: ɨntɨpongolanye ɨvwanga vwanɨ, na kʉzenga ivinji ɨvɨpɨtɨ nhaani. Mʉnʉʉmwo mwe intisengule ɨvɨyabho vwanɨ vwonti ni vintu vwanɨ ivinji. ");
INSERT INTO mgq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Panaapo pe ɨnhayɨtɨ, “Mwoyo waanɨ, ʉlɨ ni vintu ivwinji ivwinza ɨvwa kʉkwavwa amanha aminji. Ishi, tʉʉzya, lyanga, mwelaga, na kʉseshela.” ’ ");
INSERT INTO mgq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ɨleelo ʉMʉlʉngʉ akhamʉbhʉʉzya akhatɨ, ‘We mʉlema! Uwusiku ʉwa mʉsanyʉʉnʉ utifwe! Ivintu vwonti vwe ʉyɨbhɨshɨɨye, vɨtɨbhe vwa naanu?’ ");
INSERT INTO mgq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Shɨnɨɨsho she yɨkhayɨbha, kwa muntu wowonti we akʉbhʉngaanɨkha ivintu mʉ vɨgane ɨvwa mʉ nsɨ umu, sita kʉbhombela uwudumbwe waakwe mʉ mbombo ya Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Kʉnongwa yɨnɨɨyo, ɨnkʉbhabhʉʉzya kʉtɨ, mʉteleelaje kʉ zya mʉ wɨɨkhalo wiinyu kʉtɨ mutilye akhooni, awe mʉtɨkwate akhooni. ");
INSERT INTO mgq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bhʉlɨ, ʉwɨɨkhalo wutashilile ishaakulya? Bhʉlɨ, ʉmʉbhɨlɨ woope wutashilile amenda? ");
INSERT INTO mgq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yeenya amakʉngʉʉlʉ, gatakʉwaala awe gatakʉsezya, gatalɨ nɨ shanga awe apa kusengula ɨvɨyabho, ɨleelo ʉMʉlʉngʉ akʉgalɨɨsya. Ishi ɨmwe mʉkhondeeye nhaani pamiiso ga Mʉlʉngʉ kʉshɨla amavwanga! ");
INSERT INTO mgq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wu naanu mukaasi yiinyu we kweleela kwakwe kʉngonjezya ʉwɨɨkhalo waakwe poope akhabhalɨlo khashe? ");
INSERT INTO mgq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ishi, ɨnga ʉkʉpootwa kʉbhomba akhantʉ khati anza khanaakho, khooni khe mʉkweleela na ganjɨ? ");
INSERT INTO mgq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Yeenya ameezya aga mwɨ laala, she gakʉkʉla. Gatakʉbhomba ɨmbombo awe kʉsona amenda gaabho aga kʉkwata. Ɨleelo ɨnkʉbhabhʉʉzya kʉtɨ, poope ʉmwene uSelemaani mwɨ togo lyakwe lyonti, atálinjiziizye kʉkwata amenda na kʉkhondezya anzɨ lyezya limo! ");
INSERT INTO mgq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ɄMʉlʉngʉ akʉgakwatɨzya ameezya aga mwɨ laala anza shiniishi, poope she gakʉkhondezya kʉ khabhalɨlo khashe bhʉʉlo, ɨndaabhɨ gakwʉma na kʉpembwa. Ɨnga akʉbhomba shɨnɨɨsho kʉ meezya, bhʉlɨ, atangabhakwatɨzya ɨmwe kʉshɨla, mʉbha lwɨtɨkho ʉlwɨ tende? ");
INSERT INTO mgq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Pe shɨnɨɨsho, nɨɨmwe mʉleshe kweleela kʉtɨ mutilye akhooni, awe mʉtɨmwele akhooni. Khabhɨlɨ mʉleshe kʉbha nɨ lyoga. ");
INSERT INTO mgq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kʉnongwa ye abhantʉ bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ bhakweleela nhaani ni vintu vɨnɨɨvwo. Ɨleelo ɨmwe ʉTaata wiinyu ʉwa kʉmwanya amanyile kʉtɨ mubhuliliilwe vɨnɨɨvwo. ");
INSERT INTO mgq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ishi yanzaji ʉwʉmwene wa Mʉlʉngʉ, pe vɨnɨɨvwo vwonti atɨbhonjeelezye. ");
INSERT INTO mgq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mʉleshe kʉtʉʉya, ɨmwe mwe mʉlɨ ɨshɨpʉga ishinsi, kʉnongwa ye ʉTaata wiinyu ʉwa kʉmwanya ayiganile kʉʉbhapa ʉwʉmwene waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kazyaji ivintu vwinyu, mʉʉbhape abhapɨɨna ɨnhela zɨnɨɨzyo. Kʉbhomba shɨnɨɨsho kwe kʉyɨbhɨɨshɨla ivintu mʉ shanga ɨsha kʉmwanya she shɨtakwʉnda, kwe ivintu vwakwe ɨvwa kusengulila vɨtakʉlala. Khabhɨlɨ atalɨɨpo umwibha we akʉsejeelela kwibha poope ʉmʉmese kʉnanganya. ");
INSERT INTO mgq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Paala pe mubhiishile ɨshʉʉma shiinyu, panaapo pe amooyo giinyu gakhayɨbha. ");
INSERT INTO mgq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Isiku lyolyonti mʉyɨlɨnganyaaje kʉbhomba ɨmbombo, zyope ɨnhozyo zyinyu zyakhaje, ");
INSERT INTO mgq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ngatɨ bhabhombi bhe bhakʉmʉgʉʉlɨla ʉmʉpɨtɨ waabho akʉgalʉkha kufuma ku weeji, kʉtɨ akhabhalɨlo khe atɨyɨnze na kwiguzya pa lwiji, bhamwigulile nalʉbhɨlo. ");
INSERT INTO mgq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bhasayiilwe abhabhombi bhe ʉmʉpɨtɨ waabho ɨnga ayɨnza, akhayɨbhaaga bhalɨ amiiso. Nalyoli ɨnkʉbhabhʉʉzya, akhayɨyɨlɨngaanya kʉtɨ abhabhombele, akhayɨbhabhɨlɨshɨla kwɨkhala pa shintalati, akhayɨɨbhapa ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bhasayiilwe abhabhombi ɨbho bhe ʉmʉpɨtɨ waabho ɨnga ayɨnza shawusiku pakaasi awe nakhantandabhɨla, akhayɨbhaaga bhalɨ amiiso. ");
INSERT INTO mgq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mʉmanye akhinza kʉtɨ, uwi nyumba abhanje amanyaje akhabhalɨlo khe umwibha akwɨnza, angɨɨkhala amiiso kʉtɨ amudinde umwibha atakhadobhole inyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kʉnongwa yɨnɨɨyo, nɨɨmwe mʉyɨlɨnganyaaje kʉnongwa ye mutamanyile akhabhalɨlo khe akhayɨnza ʉMwana wa Muntu.” ");
INSERT INTO mgq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pe uPeeteli akhabhʉzɨɨlɨzya akhatɨ, “Mwene, ɨshɨkholanyo ishi, ʉkʉtʉbhʉʉzya ɨtwe tʉbheene, awe ʉkʉbhabhʉʉzya abhantʉ bhonti?” ");
INSERT INTO mgq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ɄMwene akhamwamʉla akhatɨ, “Umubhombi umusunde, ʉwɨ njeele, we alikwi? Wʉnʉʉyo we ʉmʉpɨtɨ waakwe akʉmʉbhɨɨkha abhe mwimiilili wa bhamwabho na kʉʉbhapa ishaakulya akhabhalɨlo khe khakhondeeye. ");
INSERT INTO mgq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asayiilwe umubhombi ʉla we ʉmwene waakwe agalʉkha, akhayɨmwaga akʉbhomba zye amulajiziizye. ");
INSERT INTO mgq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nalyoli ɨnkʉbhabhʉʉzya, akhayɨmʉbhɨɨkha kʉbha mʉpɨtɨ wɨ shʉʉma shaakwe shonti. ");
INSERT INTO mgq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ɨleelo umubhombi wʉnʉʉyo ɨnga ayɨsɨɨbha mʉ mwoyo waakwe kʉtɨ, ‘Ʉmwene waanɨ akhaabha kʉgalʉkha,’ pe akwanda kʉbhakhoma abhabhombi abhamwabho, abhasakhaala na bhantanda, akulya na kʉmwela, na kʉkholwa. ");
INSERT INTO mgq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ʉmwene waakwe akhayɨgalʉkha isiku lye atasʉbhɨɨye na khabhalɨlo khe atamanyile. Pe akhayiimupa ulufundo ʉlʉpɨtɨ na kʉmʉbhɨɨkha peeka na bhe bhatitishile. ");
INSERT INTO mgq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Umubhombi wʉnʉʉyo we amanyile zye akwanza ʉmʉpɨtɨ waakwe, ɨleelo akʉlekha kʉyɨlɨngaanya kʉmʉposheela, na kʉbhomba she akwanza ʉmʉpɨtɨ waakwe, akhayɨkhomwa nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ɨleelo umubhombi we atamanyile zye akwanza ʉmʉpɨtɨ waakwe, ɨnga abhomba akhabhiibhi, wʉnʉʉyo akhayɨkhomwa khati. Umuntu wowonti we bhamupiiye ivwinji, wʉnʉʉyo bhakhayɨmwɨsya ivwinji, we bhamupiiye ivwinji nhaani, bhakhayɨmwɨsya ivwinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ininzile mʉ nsɨ umu kwasya ʉmwoto, kwashi ɨnga wʉbhanje wandile kwakha! ");
INSERT INTO mgq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nɨɨne ɨndɨ nʉ lwozyo ʉlwa mayɨmba lwe ɨnhondeeye kʉposheela, ɨntɨjendeelele nhaani mʉ mwoyo waanɨ, paka lʉbhombeshe. ");
INSERT INTO mgq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mʉkʉsɨɨbha kʉtɨ ininzile kʉleeta uwutengaanu mʉ nsɨ? Ndaali! Ɨnkʉbhabhʉʉzya kʉtɨ, ininzile kʉleeta ʉmʉyʉbhano. ");
INSERT INTO mgq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kufuma ishi, mu nyumba mwe bhalɨ abhantʉ bhasaanʉ, bhatɨsataanaje, bhatatʉ bhatɨyeepaje kʉ bhabhɨlɨ, bhoope bhabhɨlɨ bhanaabho bhatɨyeepaje kʉ bhatatʉ. ");
INSERT INTO mgq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ʉtaata akhayizilanaga nʉ mwana waakwe, nʉ mwana akhayizilanaga nʉ taata waakwe. Unyina akhayizilanaga nʉ mwalɨ waakwe, nʉ mwalɨ akhayizilanaga nu nyina waakwe. Ʉnyavwala akhayizilanaga nʉ mʉnhamwana waakwe, woope ʉmʉnhamwana akhayizilanaga nʉ nyavwala waakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","UYeesu akhabhabhʉʉzya winza abhantʉ abhɨ mpʉga yiila akhatɨ, “We mʉkʉlola amabhɨngo gakʉbhʉngaana mʉkʉtɨ, ‘Imvula yɨkwanza kʉtoonya,’ nalyoli yɨkʉtoonya. ");
INSERT INTO mgq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Khabhɨlɨ we mʉkʉlola impepu yikufuma ɨmbalɨ ɨya kʉmbalɨntende mʉkʉtɨ, ‘Kʉkwanza kʉbha amafuku,’ nalyoli she kʉkʉbha. ");
INSERT INTO mgq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɨmwe mʉlɨ ni shisa ɨshɨ lenga! Ɨmwe mumanyile kʉzyaganya ɨzya khabhalɨlo kwɨ dala ɨlya kwenya kʉmwanya, ɨleelo kʉvwaganya ɨvɨlolesyo ɨvwa khabhalɨlo ɨkha mutamanyile. ");
INSERT INTO mgq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Khooni mʉtakʉsaabhʉla kʉbhomba zye zɨkhondeeye? ");
INSERT INTO mgq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɨnga umuntu akusitaakile, akʉkʉtwala kwɨ balaaza, kwashi kʉmʉlamba kʉtɨ mwɨmvwane we mʉlɨ mwɨ dala. Sita kʉbhomba lɨnɨɨlyo, atɨkʉtwale mʉ nyoobhe zya mulonganyi, woope umulonganyi, atɨkʉbhɨɨshe mʉ nyoobhe zya bhasikaali na kʉtwalwa kʉ makha mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ɨnkʉkʉbhʉʉzya kʉtɨ, mukaasi ʉmwo te ukhaafume paka we waamala kʉsomba vwonti vwe akʉkwɨsya!” ");
INSERT INTO mgq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Akhabhalɨlo khanaakho, abhantʉ abhanjɨ bhe bhakhamʉtejelezyaga uYeesu, bhakhamʉbhʉʉzya kʉtɨ, ʉPɨlaato aabhagojile aBhagalɨlaaya bhamu, we bhakufumwa ɨmpʉmba zyabho kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, mʉkʉtɨ aBhagalɨlaaya bhanaabho bhaabhombeliilwe shɨnɨɨsho, kʉnongwa ye bhaamɨle bhabhomba mbiibhi kʉshɨla aBhagalɨlaaya abhanjɨ bhonti? ");
INSERT INTO mgq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Te shɨnɨɨsho khaala! Ɨleelo nɨɨmwe bhakhayɨbhayazya mwenti, ɨnga mʉtakʉlaata imbiibhi zyinyu! ");
INSERT INTO mgq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bhoope abhanjɨ ishumi na naane ku Siloamu kuula, bhe ʉlʉbhʉmba ulutali lwaabhagwɨlɨɨye, anza bhaafwa. Mʉkʉtɨ abheene bhaamɨle bhabhomba mbiibhi kʉshɨla abhantʉ bhonti, bhe bhɨkhalaga mu Yelusaleemu? ");
INSERT INTO mgq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Te shɨnɨɨsho khaala! Ɨleelo nɨɨmwe bhakhayɨbhayazya mwenti, ɨnga mʉtakʉlaata imbiibhi zyinyu!” ");
INSERT INTO mgq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Panaapo uYeesu akhabhabhʉʉzya abhantʉ bhanaabho ɨshɨkholanyo ɨshamwabho akhatɨ, “Álɨɨpo umuntu ʉmo we áwaalile ikwi ɨlya mutiini, mu shiizi shaakwe ɨsha mazabiibu. Akhabhala kʉtʉngʉla amatiini, ɨleelo atakhalɨlola itunda ɨngalyeka. ");
INSERT INTO mgq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pe akhamʉbhʉʉzya umubhombi waakwe uwi shiizi akhatɨ, ‘Yeenya! Kʉ manha gatatʉ ɨnkwɨnza kʉtʉngʉla amatunda mwi kwi ili, ɨleelo ɨntakʉkhalola naakhamu! Ishi ʉtʉʉlɨle lyenelyo, kʉnongwa ye lɨkʉnanganya bhʉʉlo ishiizi!’ ");
INSERT INTO mgq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ɨleelo umubhombi ʉla akhamwamʉla akhatɨ, ‘Mwene, lɨleshe ʉmwanha ʉnʉ, indifukutile na kʉbhɨɨkha ɨmbolela. ");
INSERT INTO mgq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ɨnga lyela amatunda ʉmwanha we wʉkwɨnza, yɨkhayɨbha khinza! Ɨleelo ɨnga lɨteela, pe ʉkhatʉlɨlaje.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Isiku limo ɨlyɨ Sabaato, uYeesu akhamanyɨzyaga abhantʉ mwi sinagoogi. ");
INSERT INTO mgq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mumuula, álɨɨpo ʉmwantanda ʉmo, we áamɨle ni pepu ibhiibhi lye lɨkhamʉbhɨɨkhaga kʉbha muyeyebhazu amanha ishumi na naane. Ʉmwantanda wʉnʉʉyo ágombaanile ʉmʉsana, akhapotwaga kʉgolokha. ");
INSERT INTO mgq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","UYeesu we amʉlola, akhamʉbhɨlɨshɨla, kʉtɨ ayɨnze papaakwe. Pe akhamʉbhʉʉzya akhatɨ, “Maayɨ, waapona uwubhinu waakho, ishi wasatʉlwa!” ");
INSERT INTO mgq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","UYeesu akhamʉbhɨɨkha ɨnyoobhe, panaapo ʉmwantanda ʉla, akhagolokha ʉmʉsana waakwe, akhɨmɨɨlɨla, akhanda kʉmʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ʉmʉpɨtɨ uwi sinagoogi akhaviitwa, kʉnongwa ye uYeesu ámuponiizye ʉmwantanda ʉla pi siku ɨlyɨ Sabaato. Pe akhabhabhʉʉzya abhantʉ akhatɨ, “Ʉmʉlʉngʉ wʉlɨ ni nsiku ʉmʉtanda ɨzya kʉbhomba ɨmbombo. Mʉkwanzɨwa kwɨnza mu nsiku zɨnɨɨzyo kʉtɨ mʉpone ɨmpʉngo zyinyu, ɨleelo pi siku ɨlyɨ Sabaato khaala!” ");
INSERT INTO mgq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ɄMwene akhamwamʉla akhatɨ, “Ɨmwe mʉlɨ ni shisa ɨshɨ lenga! Mwenti mʉkʉbhomba ɨmbombo pi siku ɨlyɨ Sabaato! Bhʉlɨ, mʉtakʉsatʉlɨla mu shibhijili shɨ ngʼombe awe ni ndogomi zyinyu, na kʉzɨtwala kʉmwela aminzi, she poope lisiku ɨlyɨ Sabaato? ");
INSERT INTO mgq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ishi bhʉlɨ, ʉmwantanda ʉnʉ ʉwa shɨkholo sha Abulahaamu, we amanha ishumi na naane akungiilwe nu Seetani, atakhondeeye kʉtɨ asatʉlwe pi siku ɨlyɨ Sabaato?” ");
INSERT INTO mgq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","UYeesu we alonga ganaago, abhalʉgʉ bhaakwe bhonti bhakhalola insoni. Ɨleelo abhanjɨ bhonti bháshiiye nhaani kʉnongwa yɨ mbombo inyinza ɨzya kuswijizya zye uYeesu akhabhombaga. ");
INSERT INTO mgq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pe uYeesu akhabhʉzɨɨlɨzya akhatɨ, “Ʉwʉmwene wa Mʉlʉngʉ wʉkʉkholanywa na khooni? Ɨnholanye na khooni? ");
INSERT INTO mgq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wʉkʉkholana na khasanga akhansi akhi nhaladaali khe umuntu áwaalile mu shiizi shaakwe. Akhasanga khakhamela, khakhabha likwi, inyonyi zɨkhatenjela ivwanswi mʉ mpaaswa zyakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","UYeesu akhabhʉzɨɨlɨzya winza akhatɨ, “Ʉwʉmwene wa Mʉlʉngʉ, ɨnholanye na khooni? ");
INSERT INTO mgq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wʉkʉkholana nʉ mwantanda ʉmo we áyeejile uwusafu, akhawʉkhandʉlanya nu wusu uwinji nhaani. We akhandʉlanya, uwusafu wuula wukhadudula uwusu wonti.” ");
INSERT INTO mgq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","UYeesu akhabhalaga ku Yelusaleemu, akhashɨlaga mʉ nhaaya ɨmpɨtɨ ni nyinsi, kumo akʉlʉmbɨɨlɨla abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Isiku limo, umuntu akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, abhantʉ bhe ʉMʉlʉngʉ akhayɨbhapokha bhakhayɨbha bhashe?” UYeesu akhamwamʉla akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mʉyɨkʉngʉlaje kwinjila mʉ wʉmwene wa Mʉlʉngʉ kʉshɨlɨla pa mʉlyango ʉmʉnyeela. Ye nongwa ɨnkʉbhabhʉʉzya kʉtɨ, abhinji bhakhayɨlɨnga kwinjila, ɨleelo bhakhayɨpootwa. ");
INSERT INTO mgq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Akhabhalɨlo khakwɨnza khe ʉmwanensho uwi nyumba akhayɨmɨɨlɨla na kwɨgalɨla ʉmʉlyango. Pe mʉkhayɨmɨɨlɨla panzɨ, mukhayiguzyaga na kʉmʉlaabha mʉkhayɨtɨnjɨ, ‘We mwene, twigulile!’ Ɨleelo ʉweene akhayɨbhaamʉla akhayɨtɨ, ‘Intabhamanyile, khabhɨlɨ intamanyile kwe mufumile!’ ");
INSERT INTO mgq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nɨɨmwe mʉkhayɨtɨ, ‘Ɨtwe twe bha bhaala bhe twalyanga na kʉmwela peeka nɨɨwe! Khabhɨlɨ ɨwe we watʉmanyɨzyaga mʉ tʉkhaaya twɨtʉ!’ ");
INSERT INTO mgq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɨleelo ʉweene akhayɨtɨ, ‘Intabhamanyile, khabhɨlɨ intamanyile kwe mufumile! Yeepi kʉkwanɨ, ɨmwe mwenti mʉbhabhomba mbiibhi!’ ");
INSERT INTO mgq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mʉkhayɨbhalola uAbulahaamu, uIsaaka, ʉYaakobo, na bhakuwi bhonti bhalɨ mʉ wʉmwene wa Mʉlʉngʉ. Lyoli ɨmwe mʉkhayɨsʉmbwa kunzi. Kʉnʉʉkwo kwe mʉkhayɨlɨla na kuzyekusya amiino kʉnongwa ya mayɨmba amapɨtɨ! ");
INSERT INTO mgq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Abhantʉ kufuma ɨmbalɨ zyonti ɨzyɨ nsɨ bhakhayɨnza, bhakhayɨɨkhala pa shikulukulu mʉ wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Tejeelezyi! Abhinji bhe bhakʉyɨlola kʉtɨ bhatakhondeeye mʉ nsɨ, bhakhayɨbha bha mwɨlongolela, khabhɨlɨ bhe bhakʉyɨlola kʉtɨ bhakhondeeye mʉ khabhalɨlo ɨkha, bhakhayɨbha kʉlʉsalo mʉ khabhalɨlo khe khakwɨnza.” ");
INSERT INTO mgq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Akhabhalɨlo khanaakho, aBhafalisaayi bhamu bhakhabhala kwa Yeesu, bhakhamʉbhʉʉzya bhakhatɨ, “Sogola ɨpa, bhalaga mʉ nhaaya izinji, kʉnongwa ye uHeloodi akwanza kʉkʉgoga.” ");
INSERT INTO mgq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","UYeesu akhabhaamʉla akhatɨ, “Bhalaji mʉmʉbhʉʉzye ʉmbɨla wʉnʉʉyo mʉtɨ, ‘Yeenya! Ʉmʉsanyʉʉnʉ nɨ ndaabhɨ, ɨnkʉbhɨnga amapepu amabhiibhi na kʉbhaponɨa abhabhinu, isiku ɨlya wʉtatʉ, ɨnhayɨkwɨlɨzya ɨmbombo yaanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Poope shɨnɨɨsho, yɨkwanzɨwa kʉtɨ ɨnjendeelele kʉshʉʉla kʉbhala ku Yelusaleemu, ʉmʉsanyʉʉnʉ, ɨndaabhɨ, na kʉlɨnda ɨndaabhɨ, paka imfishe, kʉnongwa ye yɨtakhondeeye umukuwi kʉfwɨla ukunji na mu Yelusaleemu!’ ");
INSERT INTO mgq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ɨmwe mʉbhantʉ abha mu Yelusaleemu mʉkʉbhagoga abhakuwi na kʉbhakhoma na mawe bhe ʉMʉlʉngʉ abhasonteleziizye kukwinyu. Akhinji bhʉʉlo, naayiganile kʉbhabhʉngaanɨkha ɨmwe anzɨ nkʉkʉ she yɨkwʉbhatɨla ʉtwanankʉkʉ twakwe mu mapikho gaakwe, ɨleelo mʉkhakhaana! ");
INSERT INTO mgq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yeenya, inyumba yiinyu yɨtɨsyale lipongoolwi! Ɨnkʉbhabhʉʉzya kʉtɨ, te mʉkhandole winza paka pe mʉkhayɨlonga kʉtɨ, ‘Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ!’” ");
INSERT INTO mgq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Isiku limo ɨlyɨ Sabaato, uYeesu akhabhala kulya ishaakulya kʉkhaaya kwa mulongozi ʉmo ʉwa Bhafalisaayi. Akhabhalɨlo khe alɨ muula, aBhafalisaayi na bhanjɨ bhakhamʉtejelaga kʉtɨ bhalole she atɨbhombe pi siku ɨlyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pɨlongolela pa Yeesu, álɨɨpo umuntu ʉmo, we áamɨle nu wubhinu ʉwa kwizula ʉmʉbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pe uYeesu akhabhabhʉzɨɨlɨzya aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo akhatɨ, “Bhaatɨ, ɨndajɨzyo zyɨtʉ zɨkʉtwɨtɨshɨzya kʉponɨa abhantʉ pi siku ɨlyɨ Sabaato?” ");
INSERT INTO mgq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Abheene bhakhapʉʉma mye. UYeesu akhamʉpalamansya umubhinu ʉla, akhamʉponɨa, akhamwɨtɨshɨzya kʉtɨ asogolaje. ");
INSERT INTO mgq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pe uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Wu naanu pakaasi yiinyu we ɨnga ʉmwana waakwe awe ɨngʼombe yaakwe yalendela mu shindingwi pi siku ɨlyɨ Sabaato, atangeefwa nalʉbhɨlo?” ");
INSERT INTO mgq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abhantʉ bhaala, bhatakhabha nɨ lya kwamʉla. ");
INSERT INTO mgq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","UYeesu akhenyaaga abhajeni bhe bhálanjiliilwe ku shikulukulu, she bhakhasebhaga amatengo aga bhapɨtɨ. Pe akhabhabhʉʉzya ɨshɨkholanyo akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ɨnga umuntu akʉlanjɨɨye ku weeji, ʉtakhaatale kwɨkhala apa bhapɨtɨ, kʉnongwa ye lumo alanjiliilwe ʉmʉpɨtɨ uwunji kʉkʉshɨla ɨwe. ");
INSERT INTO mgq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɨnga ayɨnza we abhalanjɨɨye ɨmwe mwenti, atɨkʉbhʉʉzye ɨwe atɨtɨ, ‘Musegushile ʉnʉ pe ʉyɨkhaaye.’ Ɨpo, ʉtɨlole insoni nhaani, we ʉkʉsogola kʉbhala apa bhantʉ abha paasɨ. ");
INSERT INTO mgq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Lyoli ɨnga walanjɨlwa, ufishilaje mʉ matengo aga bhantʉ abha paasɨ, kʉtɨ ɨnga ayɨnza we akʉlanjɨɨye, akʉbhʉʉzye kʉtɨ, ‘Weeya manyani waanɨ, nzaaga ʉyɨɨkhale apinza ɨpa apa bhapɨtɨ.’ Ɨpo pe wʉtɨloleshe ʉwʉpɨtɨ waakho, pɨlongolela pa bhonti bhe bhalanjiliilwe. ");
INSERT INTO mgq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwe kʉtɨ, umuntu wowonti we akʉyɨzʉvwa, ʉMʉlʉngʉ akhayimwisya. Woope umuntu we akuyiisya, ʉMʉlʉngʉ akhayɨmʉzʉvwa.” ");
INSERT INTO mgq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pe uYeesu akhamʉbhʉʉzya we amʉlanjɨɨye akhatɨ, “We ʉkʉbhalanjɨla abhantʉ ku shikulukulu ɨsha shamʉsanya awe shalyabheela, ʉleshe kʉbha nɨ njendo ɨya kʉbhabhɨlɨshɨla abhamanyani bhaakho, awe abhanholo bhaakho, awe abhantʉ abha shɨkholo shaakho, awe abhapalamani bhaakho bhe bhadumbwe. Ʉtakhabhalanjɨle abhantʉ anza bhanaabho, kʉtɨ bhoope bhakhakʉlanjɨle kʉnongwa ɨya kʉtabhʉlɨzya zye waabhabhombeeye. ");
INSERT INTO mgq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lyoli we ʉkʉlɨngaanya ishikulukulu, ʉbhabhɨlɨshɨlaje abhapɨɨna, abha shɨlema, na bhe bhatakʉlola, ");
INSERT INTO mgq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nɨɨwe pe ʉtɨbhe nʉ lʉsayo, kʉnongwa ye bhanaabho bhatalɨ na khantʉ akha kʉkʉsomba. ɄMʉlʉngʉ we akhayɨkʉsomba, akhabhalɨlo khe akhayɨbhazyʉsya abhagolosu.” ");
INSERT INTO mgq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ʉmʉlanjɨlwa ʉmo we ayɨmvwa amazwi ga Yeesu, akhamʉbhʉʉzya akhatɨ, “Asayiilwe, umuntu we akhayilya ishikulukulu mʉ wʉmwene wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","UYeesu akhamwamʉla mʉ shɨkholanyo akhatɨ, “Álɨɨpo umuntu ʉmo, we álinganyiinye ishikulukulu ɨshɨpɨtɨ, akhabhalanjɨla abhantʉ abhinji. ");
INSERT INTO mgq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Akhabhalɨlo akhi shikulukulu we khaafikha, akhamʉsonteelezya umubhombi waakwe kʉ bhe abhalanjɨɨye, kʉtɨ abhabhʉʉzye atɨ, ‘Nzaagaji, ivintu vwonti vɨlɨngaanye!’ ");
INSERT INTO mgq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ɨleelo bhonti bhe bhálanjiliilwe, bhakhatɨ te bhabhale. Ʉwa kwanda akhatɨ, ‘Inkalile ishiizi, ɨnkwanzɨwa ɨmbale ɨnsheenye. Ʉntʉʉyɨle ɨntakwɨnza.’ ");
INSERT INTO mgq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ʉwa wʉbhɨlɨ akhatɨ, ‘Inkalile ɨngʼombe ishumi ɨzya kʉlɨma, ɨnkʉbhala kʉzɨlɨnjɨzya. Ʉntʉʉyɨle ɨntakwɨnza.’ ");
INSERT INTO mgq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Woope ʉwa wʉtatʉ akhatɨ, ‘Ineejile ʉmʉshɨ ɨgolo bhʉʉlo, ishi ɨntangɨnza.’ ");
INSERT INTO mgq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Umubhombi ʉla akhagalʉkha, akhamʉpanjɨla zyonti ʉmwene waakwe. Pe ʉmwene ʉla akhaviitwa, akhamʉbhʉʉzya umutumwa waakwe akhatɨ, ‘Bhalaga nalʉbhɨlo mʉ mbalaabala na mʉ tʉdala ʉtwa mʉ nhaaya ɨnɨ, ʉbhaleete ɨpa abhapɨɨna, abha shɨlema na bhe bhatakʉlola.’ ");
INSERT INTO mgq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Pɨlongolela, umubhombi ʉla akhagalʉkha, akhamʉbhʉʉzya akhatɨ, ‘Mwene, zye waandajiziizye nabhomba, ɨleelo apa kwɨkhala pasyalɨlɨɨye.’ ");
INSERT INTO mgq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ʉmwene akhamʉbhʉʉzya akhatɨ, ‘Ishi! Bhalaga kunzi ɨyɨ nhaaya, mʉ mbalaabala na mʉ madala ge gakʉbhala mʉ tʉkhaaya, na mu vwizi, ʉbhalambɨɨlɨzye abhantʉ bhɨnze mu nyumba yaanɨ, yiizule. ");
INSERT INTO mgq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ɨnkʉbhabhʉʉzya ɨmwe kʉtɨ, mʉ bhanaabho bhe naabhalanjɨɨye kʉwandɨlo, atalɨɨpo nʉʉmo we akhayilya ishikulukulu she indinganyiinye!’ ” ");
INSERT INTO mgq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","UYeesu akhajendaga peeka nɨ mpʉga ɨmpɨtɨ ɨya bhantʉ. Pe akhagalʉnhana, akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Umuntu wowonti we akwanza kʉndandata ɨne, akwanzɨwa kʉngana ɨne kʉshɨla she akʉmʉgana uyise waakwe, unyina waakwe, ʉmʉshɨ waakwe, abhaana bhaakwe, abhakhambakʉ bhaakwe, na bhayɨlʉmbʉ bhaakwe. Khabhɨlɨ akwanzɨwa kʉngana ɨne kʉshɨla she akʉyɨgana wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Umuntu wowonti we atakʉpɨmba ɨshɨkhobhenhanyo shaakwe na kʉndandata, atangakhola kʉbha mulandati waanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tʉtɨ umuntu weeka kukwinyu akwanza kʉzenga inyumba intali kʉzʉbha kʉmwanya. Akʉtala kʉkhonzya bhʉlɨ? Akʉsɨɨbha suuti ivintu vwonti vwe vɨkwanzɨwa kʉzenjela, khabhɨlɨ akʉyeenya she alɨ nɨ nhela ɨzya kʉmala kʉzenjela. ");
INSERT INTO mgq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sita kʉbhomba shɨnɨɨsho, angakhola kʉzenga ʉlwalo lwene, ɨleelo angapootwa kʉmalɨɨlɨzya kʉzenga. Pe abhashɨla dala bhonti bhanganda kʉmʉsekha, ");
INSERT INTO mgq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kʉtɨ, ‘Umuntu ʉnʉ áyandile kʉzenga, ɨleelo apootwa kʉmalɨɨlɨzya!’ ");
INSERT INTO mgq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Awe tʉtɨ abhamwene bhabhɨlɨ bhakʉyɨlɨngaanya kulwa. Ʉwa kwanda alɨ na bhasikaali ielufu ishumi (10,000) bhʉʉlo, ʉwa wʉbhɨlɨ alɨ nabho ielufu amashumi gabhɨlɨ (20,000). Bhʉlɨ, ʉwa kwanda atakwɨkhala suuti kʉsɨɨbha she angakhola kulwa na kʉmʉtola we alɨ na bhasikaali ielufu amashumi gabhɨlɨ (20,000)? ");
INSERT INTO mgq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Angalola kʉtɨ atɨtolwe, angasonteelezya abhaavwi bhaakwe, bhabhale kwa mwene ʉwamwabho she alɨ ukutali, kʉlamba kʉtɨ bhɨmvwane. ");
INSERT INTO mgq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“She zɨlɨ na kukwinyu. Atalɨɨpo nʉʉmo kukwinyu we akhondeeye kʉbha mulandati waanɨ, ɨnga atavileshile vwonti vwe alɨ navwo. ");
INSERT INTO mgq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ɨbheeya khantʉ khinza. Ɨleelo ɨbheeya ɨnga lyateezya uwunonu, bhʉlɨ lɨngalʉngwa khantʉ khooni akha kʉlɨbhɨɨkha kʉtɨ lyande kʉkhola winza? ");
INSERT INTO mgq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lɨtakʉbha nɨ mbombo ku lusuuto, poope kʉbha khantʉ akha kuvunzya, lyoli kʉtaagwa kunzi. Umuntu wowonti ʉla we akwɨmvwa, asimishizyaje nhaani ziniizi zye akʉzyɨmvwa!” ");
INSERT INTO mgq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Abhasonshezya nsonho na bhabhomba mbiibhi abhanjɨ abhinji, bhakhabhʉngaanaga kwa Yeesu, kʉmʉtejeelezya. ");
INSERT INTO mgq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pe aBhafalisaayi na bhamanyizyi abhɨ ndajɨzyo bhakhanda kuyibhuna bhakhatɨnjɨ, “Khooni umuntu ʉnʉ akʉsangaana na bhabhomba mbiibhi, khabhɨlɨ akulya nabho?” ");
INSERT INTO mgq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pe uYeesu akhabhabhʉʉzya ɨshɨkholanyo ishi akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tʉtɨ umuntu weeka kukwinyu alɨ nɨ ngoole imia yeeka (100). Ɨnga ateezya yeeka, angakhonzya bhʉlɨ? Atakʉzɨlekha suuti amashumi tisa nɨ zyamwabho tisa na kʉbhala kwanza yeeka ye yiteejile, paka ayaaje? ");
INSERT INTO mgq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","We ayaaga, akʉyɨbhegala pa shɨpʉngo kʉ lʉseshelo, ");
INSERT INTO mgq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kʉgalʉkha nayo kʉkhaaya. Pe akʉbhabhɨlɨshɨla abhamanyani na bhapalamani bhaakwe, akʉbhabhʉʉzya kʉtɨ, ‘Seshelaji peeka nɨɨne, kʉnongwa ye ɨngoole yaanɨ ye yaateejile, nayaaga!’ ");
INSERT INTO mgq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Ɨnkʉbhabhʉʉzya kʉtɨ, shɨnɨɨsho she yɨtɨbhe lʉseshelo lʉpɨtɨ kʉmwanya, we ʉmʉbhomba mbiibhi weeka alaata imbiibhi zyakwe. Ʉlʉseshelo lʉnʉʉlwo lʉkʉbha lʉpɨtɨ, kʉshɨla ʉlʉseshelo kʉ bhantʉ amashumi tisa na bhamwabho tisa bhe bhakʉyɨlola kʉtɨ bhagolosu, bhatakwanza kʉtɨ bhangalaata.” ");
INSERT INTO mgq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","UYeesu akhabhabhʉʉzya ɨshɨkholanyo ɨshamwabho akhatɨ, “Tʉtɨ ʉmwantanda ʉmo alɨ nɨ nhela ɨnsabhaazya ishumi, ɨngaleelo ɨnhela yeeka yɨteeje, angakhonzya bhʉlɨ? Akʉkhozya ʉlʉkhozyo, na kwʉsa inyumba yonti, akwanza paka ayaaje. ");
INSERT INTO mgq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","We ayaaga, akʉbhabhɨlɨshɨla abhamanyani na bhapalamani bhaakwe, na kʉbhabhʉʉzya kʉtɨ, ‘Seshelaji peeka nɨɨne, kʉnongwa ye ɨnhela yaanɨ ye yaateejile, nayaaga!’ ");
INSERT INTO mgq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ɨnkʉbhabhʉʉzya kʉtɨ, shɨnɨɨsho she abhakhabhɨzya bha Mʉlʉngʉ bhakʉseshela, we ʉmʉbhomba mbiibhi weeka alaata imbiibhi zyakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","UYeesu akhabhabhʉʉzya ɨshɨkholanyo ɨshamwabho kʉ zɨnɨɨzyo akhatɨ, “Álɨɨpo umuntu ʉmo, we áamɨle na bhaana bhaakwe abhasakhaala bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ʉmwana umunsi akhabhala kwa yise waakwe akhatɨ, ‘We taata, ɨnkʉlaabha umpe uwugaali waanɨ.’ Pe uyise waakwe akhabhagabhɨla abhaana bhaakwe uwugaali waabho. ");
INSERT INTO mgq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“We zyashɨla insiku nyishe, umunsi ʉla akhabhʉngaanya ivintu vwakwe vwonti, akhasogola akhabhala kʉ nsɨ ɨya kutali. We aafikha kukuula, akhanda kʉbhombela akhabhiibhi ɨshʉʉma shaakwe paka akhamala shonti. ");
INSERT INTO mgq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","We aamala shonti, ɨnzala yɨkhagwa mʉ nsɨ yiila, akhanda kweleela. ");
INSERT INTO mgq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pe akhabhala kwa muntu ʉmo ʉwa mʉ nsɨ yiila, akhalaabha ɨshɨbalʉwa. Umuntu ʉla akhamʉtwala ku shiizi, akhaamupa ɨmbombo ɨya kʉzʉbhɨla ɨngʉlʉbhe zyakwe. ");
INSERT INTO mgq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ʉmʉsakhaala umunsi ʉla áamɨle nɨ nzala, akhasʉngʉkhaga kulya amagoola ge zɨkhalyanga ɨngʉlʉbhe. Ɨleelo atálɨɨpo umuntu nʉʉmo we ámupiiye akha kulya. ");
INSERT INTO mgq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“We asɨɨbha mʉ mwoyo waakwe akhatɨ, ‘Abhabhomba mbombo bhonti abha yise waanɨ, bhakulya vɨkʉtola, khooni khe inkufwa nɨ nzala ɨpa? ");
INSERT INTO mgq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ishi ɨntɨgalʉshe kwa taata na kʉmʉbhʉʉzya kʉtɨ, “We taata, ɨmʉtʉlɨɨye ʉMʉlʉngʉ, ɨnkʉtʉlɨɨye na wʉneewe. ");
INSERT INTO mgq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ishi ɨntakhondeeye kʉbha ne mwana waakho, ʉmbɨɨshe ɨmbe weeka wa bhabhomba mbombo bhaakho.” ’ ");
INSERT INTO mgq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Pe akhasogola, akhagalʉkha kwa yise waakwe. We apalamɨla kʉkhaaya, uyise waakwe akhamʉlola ukutali, akhamʉlolela ishisa. Akhabhala akʉshɨmbɨla, akhamʉkʉmbatɨla na kʉmʉtambɨla. ");
INSERT INTO mgq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pe ʉmwana ʉla, akhamʉbhʉʉzya uyise waakwe akhatɨ, ‘We taata, ɨmʉtʉlɨɨye ʉMʉlʉngʉ, ɨnkʉtʉlɨɨye na wʉneewe. Ishi ɨntakhondeeye kʉbha ne mwana waakho.’ ");
INSERT INTO mgq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ɨleelo uyise waakwe akhabhabhʉʉzya abhatumwa bhaakwe akhatɨ, ‘Leete nalʉbhɨlo amenda aminza, mʉkwatɨzye. Mʉkwatɨzye nʉ lʉsakhala mʉ khasamba, nɨ vɨlyatʉ mʉ vɨnama. ");
INSERT INTO mgq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mweje ɨngʼombe ye nyinza, mʉbhoole, tʉbhɨɨshe ishikulukulu, ");
INSERT INTO mgq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kʉnongwa ye ʉmwana ʉnʉ aateejile, ishi alolekha. Aamɨle ngatɨ afuuye, ishi mʉpʉʉma!’ Pe abhantʉ bhaala bhonti bhakhanda kushimwa ishikulukulu. ");
INSERT INTO mgq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Akhabhalɨlo khanaakho, ʉmwana waakwe ʉmʉsongo áamɨle ku shiizi. We akʉgalʉkha, apalamɨla papɨɨpɨ ni nyumba, akhɨmvwa abhantʉ bhakwɨmba na kushimwa. ");
INSERT INTO mgq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akhamʉbhɨlɨshɨla umubhombi ʉmo, akhamʉbhʉzɨɨlɨzya akhatɨ, ‘Kʉlɨ khooni?’ ");
INSERT INTO mgq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Akhamʉbhʉʉzya akhatɨ, ‘Umunsi waakho ayinzile. Uyise waakho amʉgojeeye ɨngʼombe inyinza, kʉnongwa ye amʉlola ʉmwana waakwe alɨ she mwumi, khabhɨlɨ mwinza.’ ");
INSERT INTO mgq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ʉmwana ʉmʉsongo ʉla akhaviitwa, atakhanzaga kwinjila mu nyumba. Pe uyise waakwe akhafuma panzɨ, akhanda kʉmʉlambɨɨlɨzya ayinjile mu nyumba. ");
INSERT INTO mgq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ɨleelo akhamwamʉla uyise waakwe akhatɨ, ‘Yeenya, amanha gonti ɨga nabhomba ɨmbombo pakhaaya ɨpa, khabhɨlɨ intalinjile kʉshoolanya naalumo zye ʉkʉndajɨzya! Ɨleelo ɨne utampiiye naalumo poope akhabhuzi, kʉtɨ ɨnseshele peeka na bhamanyani bhaanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lyoli we ayɨnza ʉmwana waakho ʉnʉ, we abhombeeye akhabhiibhi ɨshʉʉma shaakho peeka na bhabhembu, ʉmʉgojeeye ɨngʼombe inyinza!’ ");
INSERT INTO mgq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Uyise waakwe akhamʉbhʉʉzya akhatɨ, ‘Mwana waanɨ, ɨwe ʉlɨ nɨɨne insiku zyonti, ivintu vwonti vwe ɨndɨ navwo vwakho. ");
INSERT INTO mgq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ishi, tʉkwanzɨwa kʉseshela na kʉbhɨɨkha ishikulukulu kʉnongwa ye umunsi waakho aateejile, ishi alolekha. Aamɨle ngatɨ afuuye, ishi mʉpʉʉma!’ ” ");
INSERT INTO mgq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","UYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Álɨɨpo udumbwe ʉmo, we áamɨle nu mwimiilili ʉwɨ shʉʉma shaakwe. Udumbwe ʉla akhɨmvwa kʉtɨ umwimiilili waakwe wʉnʉʉyo akʉnanganya ɨshʉʉma shaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pe udumbwe akhamʉbhɨlɨshɨla umwimiilili, akhamʉbhʉʉzya akhatɨ, ‘Zyoni ziniizi zye inimvwizye kʉ zyɨ mbombo yaakho? Lolesya ʉlʉbhaatɨkho she ʉbhombeeye ɨshʉʉma shaanɨ, kʉnongwa ye ʉtakhondeeye winza kʉbha we mwimiilili!’ ");
INSERT INTO mgq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Umwimiilili ʉla akhayɨbhʉzɨɨlɨzya akhatɨ, ‘Ʉmʉpɨtɨ waanɨ akʉneefwa mʉ mbombo, ishi ɨntɨbhombe lyoni? Kʉlɨma, ɨntalɨ na makha. Khabhɨlɨ kʉlaabha, ɨnkʉlola insoni. ");
INSERT INTO mgq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ishi, imanyile she ɨntɨbhombe, kʉtɨ we aneefwa mʉ mbombo ɨnɨ, abhantʉ bhakhamposheele kʉ nhaaya zyabho.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Pe umwimiilili ʉla akhabhabhɨlɨshɨla bhonti bhe ʉmʉpɨtɨ waakwe akhabhɨsyaga. Akhamʉbhʉzɨɨlɨzya ʉwa kwanda akhatɨ, ‘Ʉmʉpɨtɨ waanɨ akʉkwɨsya zɨlɨnga?’ ");
INSERT INTO mgq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Akhamwamʉla akhatɨ, ‘Akʉnɨɨsya ivipimilo imia yeeka (100) ɨvwa mafuta agi zeituni.’ Umwimiilili akhamʉbhʉʉzya akhatɨ, ‘Yeega ikalataasi ili lye lisimbiilwe vwe akʉkwɨsya, simba nalʉbhɨlo ivipimilo amashumi gasaanʉ.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pe akhamʉbhʉzɨɨlɨzya ʉwa wʉbhɨlɨ akhatɨ, ‘Ɨwe akʉkwɨsya zɨlɨnga?’ Akhamwamʉla akhatɨ, ‘Amagunila imia yeeka (100) agɨ ngano.’ Umwimiilili ʉla akhatɨ, ‘Yeega ikalataasi ili lye lisimbiilwe vwe akʉkwɨsya, simba amagunila amashumi naane.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Pe udumbwe ʉla akhamʉpaala umwimiilili ʉla, she abhombile kʉ njeele. Kʉnongwa ye abhantʉ bhe bhatakʉmwɨtɨkha ʉMʉlʉngʉ, bhakʉbhomba ɨmbombo zyabho ɨzya mʉ nsɨ kʉ njeele kʉshɨla bhe bhamwitishile ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ishi ɨne ɨnkʉbhabhʉʉzya kʉtɨ, mʉbhavwaje abhamwinyu kʉ shʉʉma shiinyu ɨsha mʉ nsɨ umu, kʉtɨ we shaasila, bhakhabhaposheele mʉ wɨɨkhalo ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Umuntu wowonti we akusengula akhinza ivintu ivinsi, wʉnʉʉyo angakhola kusengula akhinza ni vintu ivwinji. Shɨnɨɨsho she umuntu wowonti we te mwimiilili umusunde ʉwa vintu ivinsi, akʉbha te mwimiilili umusunde ku vintu ivwinji. ");
INSERT INTO mgq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ishi, ɨnga te mwe bhimiilili abhasunde abhɨ shʉʉma ɨsha mʉ nsɨ umu, wu naanu we angakhola kʉbhasʉʉbhɨla kʉsʉnga ɨshʉʉma ɨsha nalyoli! ");
INSERT INTO mgq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Khabhɨlɨ ɨnga te mwe bhimiilili abhasunde abhɨ shʉʉma ɨsha wunji, wu naanu angaabhapa ɨshʉʉma shiinyu mʉneemwe? ");
INSERT INTO mgq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Atalɨɨpo umutumwa we angakhola kʉbhabhombela abhapɨtɨ bhabhɨlɨ kʉ khabhalɨlo kheeka. Kʉnongwa ye atimuviitilwe ʉmʉpɨtɨ weeka na kʉmʉgana uwunji, awe atɨyɨkʉngʉle kwa weeka na kʉmʉshoolanya uwunji. Mʉtangakhola kʉmʉbhombela ʉMʉlʉngʉ ɨnga ɨshʉʉma shɨbhatabhalaaye!” ");
INSERT INTO mgq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ABhafalisaayi we bhɨmvwa amazwi ganaago, bhakhanda kʉmʉsʉʉpɨzya, kʉnongwa ye bháziganile nhaani ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","UYeesu akhabhabhʉʉzya akhatɨ, “Ɨmwe mʉkʉyɨbhɨɨkha mʉkhondeeye pamiiso ga bhantʉ, ɨleelo ʉMʉlʉngʉ amanyile zye zɨlɨ mʉ mooyo giinyu. Zye abhantʉ bhaziganile, ʉMʉlʉngʉ azipatile! ");
INSERT INTO mgq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ɨndajɨzyo zya Moose nu wusimbe wa bhakuwi wábhalongooye abhantʉ kufishila akhabhalɨlo akha Yookhani uMwozyi. Kufuma akhabhalɨlo khanaakho, iNtumi iNyinza ɨzya wʉmwene wa Mʉlʉngʉ zɨkʉlʉmbɨɨlɨlwa, abhantʉ abhinji bhakuyifumwa nhaani kwinjila mʉ wʉmwene wʉnʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Papupuusu nhaani kʉmwanya na paasɨ kʉshɨla, ɨleelo wʉtalɨɨpo uwusimbe wushe ʉwɨ ndajɨzyo we wʉkhayɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Umuntu wowonti we akʉmʉtabhʉla ʉmʉshɨ waakwe na kwega uwunji, akʉbhomba wubhembu. Na we akwega ʉmwantanda we aleshiilwe nʉ mʉlʉme waakwe, akʉbhomba wubhembu. ");
INSERT INTO mgq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Álɨɨpo udumbwe ʉmo, we akhakwataga amenda aminza agɨ nhela ɨmpɨtɨ. Insiku zyonti akhalyanga ishaakulya ɨshɨ nhela ɨmpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ʉmʉpɨɨna ʉmo, we bhakhatɨnjɨ ʉLaazalo, bhakhamʉbhɨɨkhaga insiku zyonti pa mʉlyango wa dumbwe ʉla. ɄLaazalo áamɨle na malonda ʉmʉbhɨlɨ wonti, ");
INSERT INTO mgq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nɨ mbwa zɨkhamʉmwantaga amalonda gaakwe. Ɨnzala yikhamulumaga nhaani, pe akhasʉngʉkhaga kulya ɨnsenyenha zye zɨkhalendaga kufuma pa shintalati pe akhalyanga udumbwe. ");
INSERT INTO mgq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Pɨlongolela, ʉmʉpɨɨna ʉLaazalo akhafwa. Abhakhabhɨzya bhakhamwega, bhakhamʉbhɨɨkha papɨɨpɨ nu Abulahaamu kʉmwanya. Udumbwe ʉla, woope akhafwa, bhakhamʉsyɨla. ");
INSERT INTO mgq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pe udumbwe ʉla we akʉyɨmba nhaani kwɨlongo, akhamʉlola uAbulahaamu ukutali alɨ nʉ Laazalo. ");
INSERT INTO mgq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akhamʉkhoolela akhatɨ, ‘We taata Abulahaamu, ndolele ishisa! Ɨnkʉyɨmba nhaani mʉ mwoto uwu! Ʉmʉsonteelezye ʉLaazalo, adumvishe akhasamba mu minzi, kʉtɨ antolishizye mu lumili lwanɨ ɨnga lʉkhatalɨle.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ɨleelo uAbulahaamu akhamwamʉla akhatɨ, ‘Mwana waanɨ, ʉkʉmbʉshe kʉtɨ akhabhalɨlo khe wáamɨle we mwumi, wáamɨle ni vintu ivwinza vwe ʉkhavwanzaga, ɨleelo ʉLaazalo áamɨle mʉ mayɨmba. Ishi, ʉweene atengaanile ɨpa, ɨwe ʉkʉyɨmba. ");
INSERT INTO mgq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Peeka na lɨnɨɨlyo, pakaasi yɨɨtʉ nɨɨmwe, palɨ ilyina ɨpɨtɨ nhaani. Ilyina lɨnɨɨlyo libhishiilwe kʉtɨ, abha kuuku bhe bhakwanza kwɨnza kukwinyu, bhapotwaje kufumiila, na bha kukwinyu bhapotwaje kwɨnza kʉkwɨtʉ.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Udumbwe akhamʉbhʉʉzya akhatɨ, ‘Ishi taata, ɨnkʉkʉlaabha ʉmʉsonteelezye ʉLaazalo abhale kʉkhaaya mu nyumba ya yise waanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kʉnʉʉkwo ɨndɨ na bhakhambakʉ bhaanɨ bhasaanʉ. Abhale abhasoshe bhazɨleshe imbiibhi zyabho, kʉtɨ bhatakhɨnze uku kʉ mayɨmba amapɨtɨ.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","UAbulahaamu akhamwamʉla akhatɨ, ‘Abhakhambakʉ bhaakho bhalɨ nu wusimbe ʉwa Moose nʉ wa bhakuwi, bhawʉtejelezyaje wʉnʉʉwo!’ ");
INSERT INTO mgq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Udumbwe ʉla akhatɨ, ‘Khaala, taata Abulahaamu! Ɨleelo umuntu ɨnga aafuma kʉ bhafwe aabhala kʉkwabho, pe bhatɨlaate imbiibhi zyabho.’ ");
INSERT INTO mgq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","UAbulahaamu akhamwamʉla akhatɨ, ‘Ɨnga bhatakʉwʉtejeelezya uwusimbe wa Moose nʉ wa bhakuwi, poope umuntu azyʉshe kufuma kʉ bhafwe, bhatangɨɨtɨkha.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","UYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨndɨngo zye zɨkwazya abhantʉ kʉbhomba imbiibhi zɨlɨɨpo insiku zyonti. Ɨleelo, asheleeye umuntu we akwazya ɨndɨngo zɨnɨɨzyo! ");
INSERT INTO mgq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yaamɨle kwashi kwa muntu wʉnʉʉyo kʉkʉnjɨɨlwa iwe ɨpɨtɨ ɨlya kʉsyela mu nsingo na kʉsʉmbwa mwa sʉmbɨ, na kʉtɨ amʉpʉvwe weeka mu bhansi ɨbha abhombe imbiibhi! ");
INSERT INTO mgq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ishi, mʉbhe amiiso, mʉtakhabhombe shɨnɨɨsho! “Uwamwinyu mʉ lwɨtɨkho ɨnga akʉbhombela ibhiibhi, mʉsoshe, ɨnga alaata, ʉmʉtʉyɨlaje. ");
INSERT INTO mgq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Poope ɨnga akʉbhombela akhabhiibhi khabhɨlɨ khabhɨlɨ kwi siku lyeka, na kʉgalʉkha kʉkwakho khabhɨlɨ khabhɨlɨ akʉtɨ, ‘Ntʉʉyɨle,’ ɨwe ʉmʉtʉyɨlaje.” ");
INSERT INTO mgq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pe abhasundikwa bhaala bhakhamʉbhʉʉzya ʉMwene bhakhatɨ, “Twonjezye ʉlwɨtɨkho!” ");
INSERT INTO mgq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ɄMwene akhabhaamʉla akhatɨ, “Ɨnga mwabha nʉ lwɨtɨkho, poope ulunsi anza khasanga akhi nhaladaali, khe khansi kʉshɨla ɨnsanga zyonti, mʉngakhola kʉlɨbhʉʉzya ikwi ɨkʉyʉ ili kʉtɨ, ‘Kumpukha ʉyɨsʉmbe mwa sʉmbɨ,’ lyope lingabhatinikha! ");
INSERT INTO mgq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tʉtɨ weeka mukaasi yiinyu alɨ nu mubhombi we akʉlɨma awe kudiima ɨngoole. Bhʉlɨ, umubhombi we aafuma kʉbhomba ɨmbombo, angamʉbhʉʉzya kʉtɨ, ‘Nzaaga ishi, yɨɨkhala ulye ishaakulya’? ");
INSERT INTO mgq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nʉʉmo! Lyoli angatɨ, ‘Ndɨnganɨshɨzye ishaakulya, khabhɨlɨ ʉmbombele paka we naamala kulya na kʉmwela. We naamala, pe nɨɨwe ulye na kʉmwela.’ ");
INSERT INTO mgq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bhʉlɨ, angamusalifwa umubhombi, kʉnongwa ye abhombile she amulajiziizye? ");
INSERT INTO mgq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","She zɨlɨ na kukwinyu, we mwamala kʉbhomba zyonti zye ʉMʉlʉngʉ abhalajiziizye, pe mʉtɨnjɨ, ‘Ɨtwe twe bhabhombi twe tʉtakhondeeye, tubhombile bhʉʉlo zye tʉkwanzɨwa kʉbhomba.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","UYeesu we akʉbhala ku Yelusaleemu, akhashɨlɨla ɨdala lye lyáshɨlɨɨye pakaasi pa nsɨ ɨya Samaliya nɨ ya Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","We akwinjila mʉ khakhaaya khamu, akhakhomaana na bhantʉ ishumi abha maketa. Abhantʉ bhaala bhakhɨmɨɨlɨla apatali na weene, ");
INSERT INTO mgq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakhamʉbhɨlɨshɨla kwi zi bhakhatɨ, “We Yeesu, we Mʉpɨtɨ, ʉtʉlolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","UYeesu we abhalola, akhabhabhʉʉzya akhatɨ, “Bhalaji mʉyɨlolesye ku bhapuutili.” We bhalɨ mwɨ dala bhakʉbhala, bhakhasatʉkha. ");
INSERT INTO mgq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Weeka mʉ bhaala, we aalola kʉtɨ aapona, akhagalʉkha kwa Yeesu, kumo akʉmʉpaala ʉMʉlʉngʉ kwi zi ɨlya kʉdandɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","We aafikha, akhagwa shikupama pɨlongolela pa vɨnama vwa Yeesu na kumusalifwa. Umuntu wʉnʉʉyo, áamɨle Musamaliya. ");
INSERT INTO mgq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","UYeesu akhabhʉzɨɨlɨzya akhatɨ, “Bhatasatushile abhantʉ bhonti ishumi? Bhamu tisa bhalɨ kwoshi? ");
INSERT INTO mgq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Atalɨɨpo we agalʉkha kʉmʉpaala ʉMʉlʉngʉ, lyoli umujeni ʉnʉ?” ");
INSERT INTO mgq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pe uYeesu akhamʉbhʉʉzya akhatɨ, “Yɨmɨɨlɨla, sogolaga, ʉlwɨtɨkho lwakho lwakʉponɨa!” ");
INSERT INTO mgq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Isiku limo, aBhafalisaayi bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Ʉwʉmwene wa Mʉlʉngʉ wʉkhayɨnza liino?” UYeesu akhabhaamʉla akhatɨ, “Ʉwʉmwene wa Mʉlʉngʉ wʉtakwɨnza kwɨ dala ɨlya vɨlolesyo vwe vɨkʉlolekha na miiso. ");
INSERT INTO mgq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abhantʉ te bhakhatɨ, ‘Yeenya! Wʉlɨ ɨpa!’ Awe ‘Wʉlɨ paala!’ Yeenya, ʉwʉmwene wa Mʉlʉngʉ wʉlɨ pakaasi yiinyu.” ");
INSERT INTO mgq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Zɨkhayɨnza insiku zye mʉkhayɨsʉngʉkha kʉbha nʉ Mwana wa Muntu poope kwi siku lyeka, ɨleelo te mʉkhandole. ");
INSERT INTO mgq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abhantʉ bhakhayɨbhabhʉzyaga bhakhayɨtɨnjɨ, ‘Yeenya! Alɨ paala!’ Awe ‘Ʉnʉ ɨpa!’ Mʉtakhasheele kʉbhɨɨtɨkha, poope kʉbhalandata. ");
INSERT INTO mgq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Imbabhuziizye ganaago, kʉnongwa ye akhabhalɨlo khe akhayɨgalʉkha ʉMwana wa Muntu, akhayɨnza ngatɨ mvula ye yɨkʉmwangʉkha nalʉbhɨlo na kʉkhozya ɨmbalɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","We ganaago gashɨɨlɨ kufumila, isuuti ʉMwana wa Muntu, kʉ shɨgane sha Mʉlʉngʉ atɨyɨmbe ku minji na kʉkhaanwa na bhantʉ abha khabhalɨlo ɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Anza she yáamɨle insiku ɨzya Noowa, she yɨkhayɨbha akhabhalɨlo akha kʉgalʉkha ʉMwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Insiku ɨzya Noowa, abhantʉ bhakhalyanga na kʉmwela, bhakheegaga na kwejelwa, kufishila pi siku liila lye ʉNoowa akhinjila mu safina. Pe imvula ɨmpɨtɨ yɨkhatoonya, yɨkhayazya abhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Shɨnɨɨsho she yáamɨle insiku ɨzya Looti. Abhantʉ bhakhalyanga na kʉmwela, bhakhakalaga na kʉkazya, bhakhawaalaga na kʉzenga. ");
INSERT INTO mgq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ɨleelo isiku liila uLooti we ayeepa mu Sodoomu, ʉmwoto ni shibiliiti kufuma kʉmwanya wukhiikha ngatɨ mvula, wʉkhabhayazya abhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","She yɨkhayɨbha isiku liila, lye ʉMwana wa Muntu akhayɨnza. ");
INSERT INTO mgq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Isiku lɨnɨɨlyo, umuntu ɨnga alɨ kwi gulu, atakhiishe kʉtɨ ayeeje ivintu vwakwe vwe vɨlɨ mukaasi mu nyumba. Woope we alɨ ku shiizi, atakhasheele kʉgalʉkha kʉkhaaya kwega khakhonti. ");
INSERT INTO mgq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mʉkʉmbʉshe zye zyámwajile ʉmʉshɨ wa Looti. ");
INSERT INTO mgq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Umuntu wowonti we akwanza kʉponɨa uwuumi waakwe, wʉnʉʉyo akhayɨwʉyazya. Ɨleelo umuntu wowonti we akʉwʉyazya, wʉnʉʉyo we akhayɨwʉponɨa. ");
INSERT INTO mgq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ɨnkʉbhabhʉʉzya kʉtɨ, isiku lɨnɨɨlyo abhantʉ bhabhɨlɨ bhakhayɨgona ɨshɨtala sheeka, ʉmo akhayɨnyamvʉlwa, ʉmo akhayɨsyala. ");
INSERT INTO mgq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Isiku lɨnɨɨlyo, abhantanda bhabhɨlɨ bhakhayɨsyanga peeka, weeka akhayɨnyamvʉlwa, weeka akhayɨsyala.  ");
INSERT INTO mgq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Isiku lɨnɨɨlyo, abhasakhaala bhabhɨlɨ bhakhayɨbhombaga ɨmbombo ku shiizi, weeka akhayɨnyamvʉlwa, weeka akhayɨsyala.” ");
INSERT INTO mgq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abhalandati bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Mwene, ganaago gakhayɨbhombekha kwoshi?” Akhabhaamʉla ku shiili akhatɨ, “Poponti pe shɨlɨ she shifuuye, pe abhashɨpʉngʉ bhakʉbhʉngaana.” ");
INSERT INTO mgq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","UYeesu akhabhabhʉʉzya abhalandati bhaakwe ɨshɨkholanyo kʉbhamanyɨzya kʉtɨ, bhamʉlaabhaje ʉMʉlʉngʉ insiku zyonti, sita kulita. ");
INSERT INTO mgq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akhabhabhʉʉzya akhatɨ, “Álɨɨpo umulonganyi mʉ nhaaya yimo we atakhamwogopaga ʉMʉlʉngʉ, khabhɨlɨ atakhasajɨlaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mʉ nhaaya yɨnɨɨyo, álɨɨpo ʉmwantanda ʉmʉfwɨle ʉmo. Akhabhalaga akhinji kʉkwakwe kʉlaabha kʉtɨ amwavwe, akhatɨnjɨ, ‘Ufumwe ʉwaamʉlo, ʉmʉlʉgʉ waanɨ aleshe kʉnjɨmvwa.’ ");
INSERT INTO mgq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Insiku inyinji zɨkhashɨla, umulonganyi ʉla akhajendelelaga kʉkhaana kʉmwavwa ʉmʉfwɨle ʉla. Pe kʉwʉmalɨlɨshɨlo, akhayɨsɨɨbha mʉ mwoyo waakwe akhatɨ, ‘She poope ɨntakʉmwogopa ʉMʉlʉngʉ, awe kʉsaajɨla abhantʉ, ");
INSERT INTO mgq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ɨleelo kʉnongwa ye ʉmʉfwɨle ʉnʉ akʉnjɨmvwa nhaani, ishi intifumwe ʉwaamʉlo kʉmwavwa, ɨnga aleshe kʉnjɨmvwa winza!’ ” ");
INSERT INTO mgq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pe ʉMwene akhatɨ, “Mʉmanyɨlaje kwa mulonganyi ʉla umubhiibhi, she áyamʉʉye kʉbhomba! ");
INSERT INTO mgq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ishi, ʉMʉlʉngʉ atangakhola kʉbhabhombela akhinza abhasaabhʉlwa bhaakwe bhe bhakʉmʉlamba shamʉsanya na shawusiku? Angakhaabha kʉbhaavwa? ");
INSERT INTO mgq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ɨnkʉbhabhʉʉzya kʉtɨ, ʉMʉlʉngʉ atɨbhabhombele nalʉbhɨlo zye zɨbhakhondeeye kʉbhabhombela. Ishi ʉMwana wa Muntu we akʉgalʉkha mʉ nsɨ, akhayɨbhalola abhantʉ bhe bhamwitishile?” ");
INSERT INTO mgq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pe uYeesu akhabhabhʉʉzya kʉ vɨkholanyo abhantʉ bhe bhakhayɨlolaga kʉtɨ bhakhondeeye pamiiso ga Mʉlʉngʉ na kʉshoolanya abhamwabho, akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Abhantʉ bhabhɨlɨ bhábhalile kupuuta mwi linga ilyi Nyumba iMfinjile, ʉmo áamɨle Mufalisaayi, ʉwamwabho áamɨle mʉsonshezya nsonho. ");
INSERT INTO mgq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“UMufalisaayi ʉla akhɨmɨɨlɨla, akhapuuta ishinuunu akhatɨ, ‘We Mʉlʉngʉ, inkukusalifwa, kʉnongwa ye ɨne ɨntalɨ anza bhantʉ abhanjɨ, bhe bhakʉfwʉla kʉ njeele, abhabhomba mbiibhi, abhabhembu, poope anzʉ mʉsonshezya nsonho ʉnʉ! ");
INSERT INTO mgq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ɨne inkuyiima kulya kʉ mʉlʉngʉ khabhɨlɨ, kʉnongwa ɨya kupuuta. Khabhɨlɨ inkukufumwizya imfinjile ɨshɨgada sheeka mʉ vɨgada ishumi mu vintu vwanɨ vwonti.’ ");
INSERT INTO mgq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ɨleelo ʉmʉsonshezya nsonho ʉla áyɨmɨlɨɨye ukutali, ásʉlamɨɨye paasɨ, atakhalɨnjɨzya poope kwenya kʉmwanya, akhayɨkhomaga-khomaga pa shifubha shaakwe, akhatɨnjɨ, ‘We Mʉlʉngʉ, ʉndolele ishisa, ɨne ne mʉbhomba mbiibhi!’ ” ");
INSERT INTO mgq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pe uYeesu akhatɨ, “Ɨnkʉbhabhʉʉzya kʉtɨ, ʉmʉsonshezya nsonho akhagalʉkha kʉkhaaya, abhaziliilwe uwugolosu. Ɨleelo ʉwamwabho ʉla, atakhabhaazɨlwa uwugolosu! Kʉnongwa ye umuntu wowonti we akʉyɨzʉvwa, ʉMʉlʉngʉ akhayimwisya. Ɨleelo umuntu we akuyiisya, ʉMʉlʉngʉ akhayɨmʉzʉvwa.” ");
INSERT INTO mgq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Isiku limo, abhantʉ bhakhamʉletelaga uYeesu abhaana abhansi, kʉtɨ abhabhɨɨshe ɨnyoobhe yaakwe abhasaye. Ɨleelo abhalandati bhaakwe we bhaalola shɨnɨɨsho, bhakhabhakhajɨla bhe bhakhabhaleetaga abhaana bhaala. ");
INSERT INTO mgq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pe uYeesu akhabhabhɨlɨshɨla abhaana kʉtɨ bhabhale kʉkwakwe, akhatɨ, “Bhaleshe abhaana abhansi ɨbho bhɨnze kʉkwanɨ, lashi mutabhadindaje! Kʉnongwa ye ʉwʉmwene wa Mʉlʉngʉ wa bhantʉ bhe bhalɨ anza bhaana ɨbha. ");
INSERT INTO mgq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we atakʉwʉposheela ʉwʉmwene wa Mʉlʉngʉ anzʉ mwana umunsi, atangakhola kwinjila mʉ wʉmwene wʉnʉʉwo.” ");
INSERT INTO mgq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ʉmʉpɨtɨ ʉmo akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “We Mumanyizyi uMwinza, ɨmbombe lyoni ilyinza ɨnga akhabhalɨlo khe khakwɨnza ɨnhawaaje uwuumi ʉwa wiila?” ");
INSERT INTO mgq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","UYeesu akhamwamʉla akhatɨ, “Khooni khe ʉkʉmbʉʉzya kʉtɨ ne mwinza? Atalɨɨpo we mwinza, lyoli ʉMʉlʉngʉ mwene! ");
INSERT INTO mgq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bhʉlɨ, uzimanyile ɨndajɨzyo zye zɨkʉtɨ, ‘Utakhabhembushe, ʉtakhaagoje, utakhiibhe, utakhaafumwe uwukeeti ʉwɨ lenga, umushindikhaje uyise waakho nu nyina waakho.’” ");
INSERT INTO mgq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ʉweene akhatɨ, “Ɨndajɨzyo zyonti zɨnɨɨzyo, inzilemile kufuma kʉ waana waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","UYeesu we ayɨmvwa ganaago, akhamʉbhʉʉzya akhatɨ, “Ubhuliliilwe na khantʉ kheeka. Bhalaga ʉkazye ivintu vwonti vwe ʉlɨ navwo, ɨnhela zye waapata, ʉbhagabhɨle abhapɨɨna. Ɨnga wabhomba shɨnɨɨsho, ʉtɨyɨbhɨɨshɨle ɨshʉʉma kʉmwanya. Pe ʉyɨnze, ʉndandate.” ");
INSERT INTO mgq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ʉmʉpɨtɨ ʉla, we ayɨmvwa ganaago, akhasʉngama nhaani, kʉnongwa ye áamɨle nɨ shʉʉma ishinji. ");
INSERT INTO mgq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","UYeesu we amʉlola kʉtɨ asʉngama, akhatɨ, “Abhantʉ bhe bhakʉsʉʉbhɨla uwudumbwe we bhalɨ nawo, yɨkhayɨbha papala nhaani kwinjila mʉ wʉmwene ʉwa Mʉlʉngʉ! ");
INSERT INTO mgq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Papupuusu ɨngamɨla kwinjila mu khaazi akha lusindaani, na kʉtɨ udumbwe ayinjile mʉ wʉmwene wa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abhantʉ bhe bhímvwizye ganaago, bhakhatɨ, “Ishi, ɨnga she zɨlɨ shɨnɨɨsho, wu naanu we angawaaga uwuposhi?” ");
INSERT INTO mgq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","UYeesu akhabhabhʉʉzya akhatɨ, “Zye abhantʉ bhakʉpootwa kʉbhomba kʉ makha gaabho, kwa Mʉlʉngʉ zɨkʉbhombekha.” ");
INSERT INTO mgq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pe uPeeteli akhamʉbhʉʉzya uYeesu akhatɨ, “Yeenya, ɨtwe tuvileshile ivintu vwonti, tukulandatile ɨwe!” ");
INSERT INTO mgq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","UYeesu akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we ayileshile inyumba, awe ʉmʉshɨ, awe abhakhambakʉ, awe abhapaafi, awe abhaana, kʉnongwa ya wʉmwene wa Mʉlʉngʉ, ");
INSERT INTO mgq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wʉnʉʉyo we akʉposheela ivwinji kʉshɨla vwe avileshile. Khabhɨlɨ akhabhalɨlo khe khakwɨnza, akhayɨposheela uwuumi ʉwa wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","UYeesu akhabheega abhalandati bhaakwe ishumi na bhabhɨlɨ, akhabhala nabho pambalɨ, pe akhabhabhʉʉzya akhatɨ, “Yeenyi, tʉkʉzʉbha kʉbhala ku Yelusaleemu. Kʉnʉʉkwo, zyonti zye abhakuwi bhásimbile kʉ zya Mwana wa Muntu, zɨtɨbhombeshe. ");
INSERT INTO mgq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Akhayɨtwalwa kʉ bhantʉ bhe te Bhayahuudi. Ɨpo bhakhayɨmʉshoolanya na kumuliga, na kʉmʉswɨla amatɨ. ");
INSERT INTO mgq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Khabhɨlɨ bhakhayɨmʉkhoma nɨ sambogo na kʉmʉgoga, isiku ɨlya wʉtatʉ, akhayɨzyʉkha.” ");
INSERT INTO mgq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Abhalandati bhaakwe bhatakhazyaganya angazyeka zye akhabhabhʉzyaga. Bháfisiilwe kʉtɨ amazwi ganaaga kwe kʉtɨ bhʉlɨ, bhatámanyile kʉtɨ akʉlonga khantʉ khooni. ");
INSERT INTO mgq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","UYeesu na bhalandati bhaakwe we bhalɨ papɨɨpɨ nɨ nhaaya ɨya mu Yeeliko, umuntu ʉmo we áfuuye amiiso áyɨkhaaye pambalɨ pɨ dala, akhalaabhaga ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","We ayɨmvwa abhantʉ abhinji bhakʉshɨla, akhabhʉzɨɨlɨzya akhatɨ, “Kʉlɨ khooni?” ");
INSERT INTO mgq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakhamʉbhʉʉzya bhakhatɨ, “UYeesu ʉwa ku Naazaleti akʉshɨla.” ");
INSERT INTO mgq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pe akhabhɨlɨshɨla nhaani akhatɨ, “We Yeesu, ʉwa shɨkholo sha mwene uDaudi, ʉndolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abhantʉ bhe bháamɨle pɨlongolela pa Yeesu, bhakhamʉkhajɨla kʉtɨ apʉʉme. Ɨleelo ʉweene akhonjezya kʉmʉbhɨlɨshɨla nhaani akhatɨ, “We Mwana ʉwa shɨkholo sha mwene uDaudi, ʉndolele ishisa!” ");
INSERT INTO mgq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","UYeesu akhɨmɨɨlɨla, akhalajɨzya kʉtɨ bhamʉleete kʉkwakwe. Umufwe amiiso ʉla we asejeelela pɨlongolela yaakwe, uYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ʉkwanza ɨnkʉbhombele lyoni?” Akhatɨ, “We Mwene, ɨnkʉlaabha ʉmponɨe ɨnande kʉlola.” ");
INSERT INTO mgq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","UYeesu akhamʉbhʉʉzya akhatɨ, “Ishi ʉyande kʉlola! Ʉlwɨtɨkho lwakho lwakʉponɨa.” ");
INSERT INTO mgq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Akhabhalɨlo khanaakho we áfuuye amiiso ʉla akhalola, pe akhamʉlandata uYeesu kumo akʉmʉpaala ʉMʉlʉngʉ. Abhantʉ bhonti we bhazɨlola zɨnɨɨzyo, bhoope bhakhamʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","UYeesu akhinjila mʉ nhaaya ɨya mu Yeeliko, akhashɨlaga pakaasi mʉ nhaaya yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mʉ nhaaya yiila, álɨɨpo umuntu ʉmo, we bhakhatɨnjɨ uZakaayi. Áamɨle mʉpɨtɨ wa bhasonshezya nsonho, khabhɨlɨ áamɨle wu dumbwe. ");
INSERT INTO mgq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Umuntu ʉnʉ akhanzaga kʉmʉlola uYeesu kʉtɨ alɨ bhʉlɨɨbhʉlɨ, ɨleelo akhapootwa kʉmʉlola kʉnongwa ye áamɨle mufupi, khabhɨlɨ abhantʉ bháamɨle bhinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pe akhabhala akʉshɨmbɨla, kwɨlongolela kʉ mpʉga ya bhantʉ, akhazʉbha mwi kwi ɨkʉyʉ, ɨnga amʉlole uYeesu we akʉshɨla paala. ");
INSERT INTO mgq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","UYeesu we aafikha paala, akheenya kʉmwanya kwɨ kʉyʉ liila, akhamʉlola uZakaayi, akhatɨ, “Zakaayi, yiikha nalʉbhɨlo! Kʉnongwa ye ʉmʉsanyʉʉnʉ yɨkwanzɨwa ɨmbe ne mujeni mu nyumba yaakho.” ");
INSERT INTO mgq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","UZakaayi akhiikha nalʉbhɨlo, akhamʉlanjɨla uYeesu kʉkhaaya kʉkwakwe kʉ lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Abhantʉ bhonti bhe bhámulolile uYeesu we akwinjila muula, bhakhanda kuyibhuna, bhakhatɨnjɨ, “Khooni aabhala kʉbha mujeni wa muntu ʉmʉbhomba mbiibhi!” ");
INSERT INTO mgq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ɨleelo uZakaayi akhɨmɨɨlɨla, akhamʉbhʉʉzya ʉMwene uYeesu akhatɨ, “We Mwene! Ishi, ivintu vwanɨ ɨntɨgabhʉlanye pakaasi, vimo ɨntɨɨbhape abhapɨɨna. Woope umuntu wowonti we imwibhiiye akhantʉ khaakwe, ɨntɨmʉgalʉshɨzye khani.” ");
INSERT INTO mgq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pe uYeesu akhamʉbhʉʉzya akhatɨ, “Ʉmʉsanyʉʉnʉ, uwuposhi wɨnza kʉ bhantʉ abha mu nyumba ɨnɨ, kʉnongwa ye umuntu ʉnʉ woope wa mʉ shɨkholo sha Abulahaamu. ");
INSERT INTO mgq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwe kʉtɨ, ʉMwana wa Muntu ayinzile kwanza na kʉpokha abhantʉ bhe bhateejile.” ");
INSERT INTO mgq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Abhantʉ bhe bhakhamʉtejelezyaga uYeesu bhakhasɨɨbhaga kʉtɨ ʉwʉmwene wa Mʉlʉngʉ wʉpalamɨɨye, kʉnongwa ye bhápalamɨɨye kufikha ku Yelusaleemu. Pe uYeesu akhabhabhʉʉzya kʉ shɨkholanyo ");
INSERT INTO mgq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","akhatɨ, “Álɨɨpo umuntu ʉmo ʉwa mʉ shɨkholo ɨsha shɨmwene, we áshuulile kʉbhala ɨnsɨ ɨya kutali. Ábhalile kʉ nsɨ yɨnɨɨyo kʉtɨ aposheele ʉwʉpɨtɨ ʉwa kʉbha wʉ mwene, ɨnga agalʉshe kʉtabhaala ɨnsɨ yaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“We ashɨɨlɨ kʉsogola, akhabhabhɨlɨshɨla abhabhombi bhaakwe ishumi, weeka weeka akhaamupa ɨnhela inyinji, akhabhabhʉʉzya akhatɨ, ‘Mʉbhombelaje ɨnhela ziniizi kʉtɨ akhabhalɨlo khe ɨnhayɨgalʉkha ɨnhaagaje zyonjeeye.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ɨleelo abhantʉ abhɨ nsɨ yaakwe bhámupatile, pe bhakhasonteelezya abhantʉ bhamʉlandate kʉ nsɨ yiila ɨya kutali, bhabhale bhalonje bhatɨ, ‘Tʉtakwanza umuntu ʉnʉ abhe wʉ mwene wɨɨtʉ!’ ");
INSERT INTO mgq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Poope she bhálonjile lɨnɨɨlyo, akhɨtɨshɨlwa kʉbha mʉpɨtɨ ʉwa wʉmwene. We agalʉkha, akhabhabhɨlɨshɨla abhabhombi bhaala bhe ábhapiiye ɨnhela, kʉtɨ amanye kwa weeka weeka ayonjeziizye zɨlɨnga. ");
INSERT INTO mgq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Umubhombi ʉwa kwanda akhɨnza, akhalonga akhatɨ, ‘We mwene, ɨnhela zye wándesheeye, inonjeziizye ɨzyamwabho ɨvɨlʉndo ishumi.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ʉmwene ʉla akhamʉbhʉʉzya akhatɨ, ‘Ubhombile akhinza, ɨwe we mubhombi umwinza. Kʉnongwa ye waamɨle we musunde mu vintu ivinsi nhaani, intiikupe ʉwʉpɨtɨ ʉwa kʉtabhaala ɨnhaaya ishumi.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Umubhombi ʉwa wʉbhɨlɨ woope akhɨnza, akhalonga akhatɨ, ‘We mwene, ɨnhela zye wándesheeye, inonjeziizye ɨzyamwabho ɨvɨlʉndo vɨsaanʉ.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ʉmwene waakwe akhamʉbhʉʉzya akhatɨ, ‘Nɨɨwe, inkuukupa amakha aga kʉtabhaala ɨnhaaya zɨsaanʉ.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Umubhombi ʉwamwabho akhɨnza, akhatɨ, ‘We mwene, yeega ɨnhela zyakho zye wándesheeye izi ɨpa. Naazisenguuye akhinza mʉ shɨtambaala, kʉtɨ zɨtakhateeje. ");
INSERT INTO mgq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naakwogopile, kʉnongwa ye ɨwe we muntu umugomu. Ɨwe ʉkwega vwe utabhiishile, khabhɨlɨ ʉkʉyebhela vwe utawaalile.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ʉmwene akhamʉbhʉʉzya akhatɨ, ‘Ɨwe we mubhombi ʉmʉbhomba mbiibhi! Ishi, inkuukupa ulufundo ku mazwi gaakho ge walonga. Waamanyile kʉtɨ ɨne ne muntu umugugu nhaani, ɨnkwega vwe intabhiishile, khabhɨlɨ ɨnkʉbhʉngaanya vwe intawaalile. ");
INSERT INTO mgq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ishi khooni utabhiishile ɨnhela zyanɨ kʉ bhe bhakʉpaapɨzya, kʉtɨ ɨneeje peeka nɨ zya pamwanya zye zyonjeeye?’ ");
INSERT INTO mgq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Pe akhabhabhʉʉzya abhantʉ bhe bhɨ́mɨlɨɨye paala, akhatɨ, ‘Fwuli ɨtalanta zyakwe, muumupe we ayonjeziizye ɨzyamwabho ishumi.’ ");
INSERT INTO mgq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhakhamʉbhʉʉzya bhakhatɨ, ‘We mwene, mbona ʉyo alɨ nazyo ishumi!’ ");
INSERT INTO mgq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Akhabhaamʉla akhatɨ, ‘Ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we akʉshɨbhombela akhinza ɨshɨkʉnjɨlwa shaakwe, ʉMʉlʉngʉ akʉmwonjezya ku winji. Ɨleelo we atakʉshɨbhombela ɨshɨkʉnjɨlwa shaakwe, ʉMʉlʉngʉ akʉfwʉla ni shinsi she alɨ nasho. ");
INSERT INTO mgq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Peeka na zɨnɨɨzyo, bhaleete abhalʉgʉ bhaanɨ bhaala bhe bhatanzaga ɨne ɨmbe ne mwene waabho, mʉbhagoje pɨlongolela yaanɨ!’ ” ");
INSERT INTO mgq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","UYeesu we alonga ganaago, akhajendeelela kʉbhala ku Yelusaleemu kumo alongoleeye kʉ mpʉga yiila ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","We alɨ papɨɨpɨ na khakhaaya akha Betisifaage na kha Besaniya, mwɨ gamba ɨlya Mizeituni, akhabhasonteelezya abhalandati bhaakwe bhabhɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akhabhabhʉʉzya akhatɨ, “Mʉbhale mʉ khakhaaya khaala khe khalɨ pɨlongolela yiinyu. We mukwinjila muula, mʉtɨyɨlole ɨnyaana yi ndogomi nkʉnjɨɨle ye umuntu atapandile naalumo. Mʉyɨsatʉle, mʉyɨleete ɨpa. ");
INSERT INTO mgq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɨnga umuntu wowonti akʉbhabhʉzɨɨlɨzya akʉtɨ, ‘Khooni khe mʉkʉyɨsatʉla?’ mʉmʉbhʉʉzye mʉtɨ, ‘ɄMwene akʉyanza.’ ” ");
INSERT INTO mgq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pe abhalandati bhaala bhakhabhala, bhakhalola zyonti anza she uYeesu ábhabhuziizye. ");
INSERT INTO mgq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","We bhakʉyɨsatʉla ɨnyaana yiila iyi ndogomi, abhanensho bhakhabhabhʉzɨɨlɨzya bhakhatɨ, “Khooni khe mʉkʉyɨsatʉla ɨnyaana yi ndogomi?” ");
INSERT INTO mgq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhakhabhabhʉʉzya bhakhatɨ, “ɄMwene akʉyanza.” ");
INSERT INTO mgq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pe bhakhɨnza nɨ nyaana yi ndogomi yiila kwa Yeesu, bhakhaala amenda gaabho pamwanya pa ndogomi, bhakhamʉzʉvwa uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","UYeesu we akʉbhala, abhantʉ bhakhaalaga amenda gaabho mwɨ dala. ");
INSERT INTO mgq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","We alɨ papɨɨpɨ kwikha ɨgamba ɨlya Mizeituni, ɨshɨpʉga shonti ɨsha bhalandati bhaakwe bhakhaseshela, bhakhanda kʉmʉpaala ʉMʉlʉngʉ kʉnongwa ya mayele gonti ge bhálolile we uYeesu akʉbhomba. Bhakhamʉpaalaga nhaani ");
INSERT INTO mgq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","bhakhatɨnjɨ, “Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ! Uwutengaanu kʉmwanya nu wumwamu kwa Mʉlʉngʉ we alɨ kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mʉ mpʉga yiila, bhálɨɨpo aBhafalisaayi abhanjɨ, bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Mumanyizyi, bhalongane abhalandati bhaakho, bhaleshe kʉlonga zɨnɨɨzyo!” ");
INSERT INTO mgq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","UYeesu akhatɨ, “Ɨnkʉbhabhʉʉzya kʉtɨ, ɨnga ɨbha bhapʉʉma, amawe ɨgo gatɨlonje nhaani!” ");
INSERT INTO mgq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","UYeesu we alɨ papɨɨpɨ, akʉlola ɨnhaaya ɨya Yelusaleemu, akhanda kʉlɨla kʉnongwa ɨya mayɨmba ge gakwɨnza kʉ nhaaya yɨnɨɨyo, ");
INSERT INTO mgq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akhatɨ, “Nhanɨ waamanya ʉmʉsanyʉʉnʉ zye ʉkwanzɨwa kʉbhomba kʉtɨ ʉbhe nu wutengaanu! Ishi zifisiilwe pamiiso gaakho. ");
INSERT INTO mgq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mu nsiku zye zɨkwɨnza, abhalʉgʉ bhaakho bhakhayɨzenga ʉlʉbhaga ulugomu kʉzyʉngʉʉlɨzya ɨnhaaya yaakho yonti, ɨpo pe bhakhayanda kukubuda kufuma ɨmbalɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bhakhayikugwisya paasɨ, ɨwe na bhantʉ bhaakho bhonti. Te bhakhakʉleshele ni we lye lɨkhayɨsyala pamwanya pa lyamwabho, kʉnongwa ye ʉtanzaga kʉmanya akhabhalɨlo khe ʉMʉlʉngʉ akʉkʉleetela uwuposhi!” ");
INSERT INTO mgq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","UYeesu akhinjila mwi linga ilyi Nyumba iMfinjile, akhanda kʉbhabhɨnjɨla kunzi bhe bhakhakazyaga ivintu. ");
INSERT INTO mgq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akhabhabhʉʉzya akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Inyumba yaanɨ, yɨtɨbhe nyumba ya kupuutila.’ Ɨleelo ɨmwe, muyigalulanyiinye kʉbha ngwenya ya bhabuda!” ");
INSERT INTO mgq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","UYeesu akhamanyɨzyaga abhantʉ insiku zyonti mwi linga ilyi Nyumba iMfinjile. Abhapɨtɨ abha bhapuutili, na bhamanyizyi abhɨ ndajɨzyo na bhasongo abha Bhayahuudi, bhakhanzaga ɨdala ɨlya kʉmʉgoga. ");
INSERT INTO mgq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ɨleelo bhakhapootwa, kʉnongwa ye abhantʉ bhonti bhe bhakhamʉlandataga bhakhalemaga akhinza amazwi gaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Isiku limo, uYeesu akhamanyɨzyaga abhantʉ mwi linga ilyi Nyumba iMfinjile, na kʉbhalʉmbɨɨlɨla iNtumi iNyinza. Pe abhapɨtɨ abha bhapuutili, abhamanyizyi abhɨ ndajɨzyo, na bhasongo abha Bhayahuudi bhakhamʉbhalɨla, ");
INSERT INTO mgq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Tʉbhʉʉzye, ʉkʉbhomba ziniizi kʉ waamʉlo wooni? Wu naanu we akupiiye ʉwaamʉlo wunuuwu?” ");
INSERT INTO mgq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Akhabhabhʉʉzya akhatɨ, “Nɨɨne ɨntɨbhabhʉzɨɨlɨzye izwi lyeka mʉmbʉʉzye. ");
INSERT INTO mgq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bhʉlɨ, ʉwaamʉlo wa Yookhani ʉwa kwozya abhantʉ wáfumile kwoshi? Wáfumile kʉmwanya awe kʉ bhantʉ?” ");
INSERT INTO mgq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe bhakhazaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Ɨnga twamwamʉla kʉtɨ lwáfumile kʉmwanya, atɨtʉbhʉzɨɨlɨzye kʉtɨ, ‘Khooni khe mʉtakhamwɨtɨkhaga?’ ");
INSERT INTO mgq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ɨleelo ɨnga twatɨ bhantʉ bhámupiiye, bhonti ɨbha bhatɨtʉkhome na mawe, kʉnongwa ye bhitishile kʉtɨ uYookhani áamɨle mukuwi.” ");
INSERT INTO mgq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pe bhakhamwamʉla bhakhatɨ, “Tutamanyile amakha ganaago kwe gáfumile.” ");
INSERT INTO mgq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Woope uYeesu akhabhabhʉʉzya akhatɨ, “Nɨɨne ɨntakʉbhabhʉʉzya kʉtɨ ɨnkʉbhomba ziniizi kʉ waamʉlo wa naanu.” ");
INSERT INTO mgq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pe uYeesu akhanda kʉbhabhʉʉzya abhantʉ ɨshɨkholanyo ishi akhatɨ, “Álɨɨpo umuntu ʉmo, we áwaalile amazabiibu mu shiizi shaakwe. Akhabhabhɨɨkha abhalimi abha kʉlɨndɨɨlɨla na kʉsʉnga amazabiibu gaala, kʉtɨ we izabiibu zyagoma, bhoope bheegaje zimo zye bhatʉngʉʉye. Ʉweene akhashʉʉla, akhabhala kʉ nsɨ ɨya kutali, kʉnʉʉkwo akhɨɨkhala insiku inyinji. ");
INSERT INTO mgq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","We akhabhalɨlo akhi mvuno ɨya mazabiibu khaafikha, akhamʉsonteelezya umubhombi waakwe ku bhalimi bhaala, kʉtɨ bhaamupe amazabiibu ge bhamʉgabhɨɨye kufuma mu shiizi shaakwe. Ɨleelo abhalimi bhaala bhakhamʉlema umubhombi waakwe ʉla, bhakhamʉkhoma na kʉmʉgalʉsya ɨnyoobhe nyeene kwa mwene waakwe. ");
INSERT INTO mgq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Ʉmwanensho uwi shiizi, akhamʉsonteelezya umubhombi ʉwamwabho. Ɨleelo woope bhakhamʉkhoma na kʉmʉbhombela zye zɨtakhondeeye, pe bhakhamʉbhɨnga sita kuumupa naakhamu. ");
INSERT INTO mgq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akhamʉsonteelezya ʉwa wʉtatʉ. Wʉnʉʉyo woope bhakhamʉvwalazya, bhakhamʉsʉmba kunzi. ");
INSERT INTO mgq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Pɨlongolela, ʉmwanensho uwi shiizi akhatɨ, ‘Ishi ɨntɨbhombe lyoni? Akhabhalɨlo ɨkha, ɨntɨmʉsonteelezye ʉmwana waanɨ ʉmʉganwa! Pamu ʉnʉ we bhatimushindishe.’ ");
INSERT INTO mgq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ɨleelo abhalimi bhaala we bhamʉlola ʉmwana ʉla, bhakhabhʉʉzanya bhakhatɨ, ‘Ʉnʉ we mugaali uwi shiizi ishi. Ishi tʉmʉgoje, ɨnga tweje uwugaali waakwe.’ ");
INSERT INTO mgq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhakhamʉsʉmba kunzi ku shiizi ɨsha mazabiibu, bhakhamʉgoga.” Pe uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Ishi pe ʉmwanensho uwi shiizi ʉyo akhayɨbhabhomba lyoni abhalimi bhaala? ");
INSERT INTO mgq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Akhayɨbhayazya abhalimi bhaala. Ishiizi shiila ɨsha mazabiibu, akhayɨɨbhapa abhanjɨ!” Abhantʉ we bhɨmvwa amazwi ganaago, bhakhatɨ, “Ganaago gatakhatufumile ngakheeka!” ");
INSERT INTO mgq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ɨleelo uYeesu akhabheenya, akhabhabhʉzɨɨlɨzya akhatɨ, “Ishi uwusimbe uwu, kwe kʉtɨ bhʉlɨ? ‘Iwe lye bhálikhaanile abhazenji, lɨnɨɨlyo lye lyabha liwe ɨlya pambalɨ lye lilemile inyumba yonti.’ ");
INSERT INTO mgq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɨnkʉbhabhʉʉzya, umuntu wowonti we alendela pi we lɨnɨɨlyo, akhayivunzinhana. Khabhɨlɨ wowonti we lyamʉlendela, likhayimuvinyulanya vinyuvinyu.” ");
INSERT INTO mgq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pe abhamanyizyi abhɨ ndajɨzyo na bhapɨtɨ abha bhapuutili, bhakhamanya kʉtɨ akubhiibhika bhɨɨbho. Pe bhakhanza ɨdala ɨlya kʉmʉlema, ɨleelo bhakhogopaga ɨmpʉga ɨya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pe abhapɨtɨ abha Bhayahuudi, bhakhamuzijilaga uYeesu. Bhakhasonteelezya abhantʉ bhe bhakhayɨbhɨɨkha ngatɨ bhantʉ bhagolosu, kʉtɨ bhɨnanjɨzye zye uYeesu akʉbhomba. Bhakhabhombaga shɨnɨɨsho kʉtɨ bhapaaje apa kwandɨla mu mazwi gaakwe wʉʉyo, ɨnga bhamʉleme na kʉmʉtwala kwa mwene kʉtɨ amʉlonje. ");
INSERT INTO mgq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pe abhantʉ bhaala bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “We Mumanyizyi, tumanyile kʉtɨ ʉkʉlonga na kʉmanyɨzya ɨzya nalyoli. Khabhɨlɨ ʉtakʉwʉsaajɨla ʉwʉpɨtɨ wa muntu pa mbombo, kʉnongwa ye ʉtakwɨmɨla bha ndwɨmo, lyoli ɨwe ʉkʉmanyɨzya ɨdala lya Mʉlʉngʉ mu wanalyoli. ");
INSERT INTO mgq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tʉbhʉʉzye she ʉkʉlola. Bhʉlɨ, ɨndajɨzyo zɨkwɨtɨshɨzya kufumwa ɨnsonho kwa Kaisaali awe khaala?” ");
INSERT INTO mgq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ɨleelo uYeesu akhamanya kʉtɨ bhamʉtejeeye, akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mʉndanje ɨnhela iyi dinaali. Ipiicha ɨnɨ nɨ taawa ili, vwa naanu?” Bhakhamwamʉla bhakhatɨ, “Vwa Kaisaali.” ");
INSERT INTO mgq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Ishi, ɨvwa Kaisaali, mʉmʉpanje uKaisaali, ɨnga vwa Mʉlʉngʉ mʉmʉpanje ʉMʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Abhantʉ bhaala bhakhaswiga nhaani ʉwaamʉlo we uYeesu akhafumwa, bhakhapʉʉma mye. Bhakhapootwa apa kwandɨla kʉmʉsɨtaaka, kʉnongwa ya mazwi ge akhalonga pɨlongolela pa bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pɨlongolela, aBhasadukaayi bhamu, bhe bhakhamanyɨzyaga kʉtɨ abhafwe te bhakhazyʉshe, bhakhabhala kwa Yeesu. Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mumanyizyi, ʉMoose átusimbiiye ɨndajɨzyo kʉtɨ, ɨnga umuntu aafwa, amʉlekha ʉmʉshɨ sita kʉpaapa ʉmwana, yɨkwɨtɨshɨlwa ʉkhambakʉ waakwe kʉmʉgaala ʉmʉfwɨle ɨnga amʉpaapɨle umuyazi abhaana. ");
INSERT INTO mgq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ishi bhálɨɨpo abhanamuntu saba. Ʉwa kwanda áyeejile ʉmʉshɨ, akhafwa sita kʉpaapa ʉmwana. ");
INSERT INTO mgq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ʉwa wʉbhɨlɨ, akhamʉgaala ʉmʉfwɨle ʉla, woope akhafwa sita kʉlekha ʉmwana. ");
INSERT INTO mgq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pɨlongolela, ʉwa wʉtatʉ akhamʉgaala, woope akhafwa. Yɨkhabha shishiila ku bhonti saba. Abhaana bha yise weeka bhonti ɨbha bhámwejile ʉmwantanda ʉla, ɨleelo bhonti bhakhafwa sita kʉlekha ʉmwana. ");
INSERT INTO mgq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kʉwʉmalɨlɨshɨlo wa bhonti, ʉmwantanda ʉla woope akhafwa. ");
INSERT INTO mgq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bhʉlɨ, pi siku lye abhafwe bhakhayɨzyʉkha, ʉmwantanda ʉla akhayɨbha mʉshɨ wa mʉsakhaala alikwi? Kʉnongwa ye abhasakhaala bhonti saba bhámwejile.” ");
INSERT INTO mgq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","UYeesu akhabhabhʉʉzya akhatɨ, “Abhantʉ abha mʉ khabhalɨlo ɨkha, bhakwega na kwegwa. ");
INSERT INTO mgq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ɨleelo abhantʉ bhe ʉMʉlʉngʉ akʉlola bhakhondeeye kʉtɨ abhazyʉsye kufuma kʉ bhafwe, bhɨɨkhale mʉ nsɨ impwa, bhanaabho te bhakheegaje, awe kwejelwa winza. ");
INSERT INTO mgq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Peeka na lɨnɨɨlyo te bhakhaafwe winza, kʉnongwa ye bhakhayɨbha anza bhakhabhɨzya. Bhakʉbha bhaana bha Mʉlʉngʉ, kʉnongwa ye bhazyushile kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Woope ʉMoose álonjile kʉtɨ abhafwe bhakhayɨzyʉkha. Álonjile lɨnɨɨlyo mu Wusimbe uWufinjile, mʉ shɨsyeta she shɨkhaakhaga ʉmwoto. Panaapo álonjile átɨlɨ ʉMwene ʉMʉlʉngʉ ‘wʉ Mʉlʉngʉ wa Abulahaamu, wʉ Mʉlʉngʉ wa Isaaka, khabhɨlɨ wʉ Mʉlʉngʉ wa Yaakobo.’ ");
INSERT INTO mgq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ɄMʉlʉngʉ atakʉbhabhɨlɨshɨla abhafwe kumupuuta na kʉmʉbhombela ʉweene, lyoli bhe bhuumi. Kwe kʉtɨ kʉkwakwe abhantʉ bhonti bhuumi.” ");
INSERT INTO mgq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pe abhamanyizyi abhanjɨ abhɨ ndajɨzyo bhakhatɨ, “Mumanyizyi, walonga akhinza!” ");
INSERT INTO mgq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kwandɨla panaapo, nʉʉmo umuntu we álinjiziizye kʉmʉbhʉzɨɨlɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pe uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨɨbhʉlɨ, abhantʉ bhakʉtɨ, uKilisiti Mwana ʉwa shɨkholo sha mwene uDaudi? ");
INSERT INTO mgq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","UDaudi wʉʉyo, ásimbile mu shitaabu ɨsha Zabuuli, átɨlɨ, ‘ɄMwene ámubhuziizye ʉMwene waanɨ átɨlɨ, “Yɨɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo, ");
INSERT INTO mgq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","paka we nabhabhɨɨkha abhalʉgʉ bhaakho paasɨ pa vɨnama vwakho.”’ ");
INSERT INTO mgq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɨnga uDaudi ámuteshile uKilisiti kʉtɨ wʉ Mwene waakwe, uKilisiti angabha mwana waakwe anza bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Abhantʉ bhonti we bhakʉmʉtejeelezya uYeesu, ʉweene akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mʉbhe amiiso na bhamanyizyi abhɨ ndajɨzyo, abheene bhakʉyɨgana kʉjenda kʉ mabaado we bhakwatile ɨnkanzʉ, kʉtɨ abhantʉ bhabhalamʉkhaje ku lushindikho mʉ manaalo. We bhalɨ mwi sinagoogi, bhakwanza kwɨkhala mʉ matengo aga pɨlongolela. Mwope mu vikulukulu bhakwɨkhala mʉ matengo aga bhapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Abhantʉ ɨbha bhakʉfwʉla ku wushevu ivintu vwa bhafwɨle! Mu shisa ɨshɨ lenga abheene bhakupuuta impuuto intali, kʉtɨ abhantʉ bhatɨnjɨ bhagolosu. Mʉ lɨnɨɨlyo, ʉMʉlʉngʉ akhayɨɨbhapa ulufundo ʉlʉpɨtɨ!” ");
INSERT INTO mgq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","UYeesu we alɨ mwi linga ilyi Nyumba iMfinjile, akhabhalola abhadumbwe bhakhafumwaga imfinjile zyabho mʉ shɨlɨɨlo ɨsha kufumwizya imfinjile. ");
INSERT INTO mgq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akhamʉlola nʉ mʉfwɨle ʉmo ʉmʉpɨɨna akufumwa utukoobheli tʉbhɨlɨ bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pe uYeesu akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, ʉmʉfwɨle ʉnʉ ʉmʉpɨɨna, we aafumwa nhaani kʉshɨla abhanjɨ ɨbho bhonti. ");
INSERT INTO mgq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kʉnongwa ye abhanjɨ ɨbha, bhafumwizye zye zyonjeleeye mu winji wɨ shʉʉma shaabho. Ɨleelo ʉmʉfwɨle ʉnʉ poope she mʉpɨɨna mansɨ, aafumwa vwonti vwe vwamɨle vwa kʉmwavwa mʉ wɨɨkhalo waakwe!” ");
INSERT INTO mgq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abhalandati bhamu abha Yeesu, bhakhalongaga izyi Nyumba iMfinjile she yázenjiilwe na mawe aminza, peeka ni vintu vwe vɨkʉsʉngʉsya vwe abhantʉ bháfumwizye kwa Mʉlʉngʉ. Pe uYeesu akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ganaago gonti ge mʉkʉgalola ishi, zɨkhayɨnza insiku zye te lɨkhasyale iwe naalimo pamwanya pa lyamwabho, kʉnongwa ye gonti ganaago gakhayɨpongolwa!” ");
INSERT INTO mgq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abhantʉ bhaala bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Mumanyizyi, ziniizi zye ʉkʉlonga zikhayifumila liino? Shɨlolesyo shooni she shɨkhayɨlolesya kʉtɨ zɨnɨɨzyo zɨpalamɨɨye kufumila?” ");
INSERT INTO mgq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Akhabhabhʉʉzya akhatɨ, “Mʉbhe amiiso, kʉtɨ mʉtakhakhopelwe! Kʉnongwa ye abhantʉ abhinji bhakhayɨnza kwɨ taawa lyanɨ, bhakhayɨyɨtekhaga kʉtɨ, ‘Ɨne ne ne Kilisiti!’ Khabhɨlɨ bhakhayɨtɨnjɨ, ‘Akhabhalɨlo khalɨ papɨɨpɨ!’ Abhantʉ bhanaabho, mʉtakhasheele kʉbhalandata! ");
INSERT INTO mgq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ɨmwe we mwɨmvwa ɨnongwa ɨzya wʉlʉgʉ, nu wunanganyi wa bhantʉ, mʉtakhogopaje. Poope yɨkhabhe bhʉlɨ ganaago gakhayɨlolekha suuti, ɨleelo akhabhalɨlo nyeene akha kʉmpeleela khakhayɨbha khashɨɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","UYeesu akhajendeelela kʉlonga kʉtɨ, “Ɨnsɨ yeeka yɨkhayɨlwanga nɨ nsɨ iyinji, nʉ wʉmwene weeka wʉkhayɨlwanga nʉ wʉmwene ʉwamwabho. ");
INSERT INTO mgq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ɨmbalɨ zimo kʉkhayɨbha iviyingayinga ɨvɨpɨtɨ, mumo ɨnzala ɨmpɨtɨ, apamwabho ɨvɨwaaya ɨvwa kwambʉshɨla. Khabhɨlɨ kʉkhayɨbha ivintu ɨvwa kwogofwa nɨ vɨlolesyo ɨvɨpɨtɨ kufuma kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Zɨnɨɨzyo zyonti we zɨshɨɨlɨ kufumila, abhantʉ bhakhayɨbhalema ɨmwe na kʉbhayɨmvwa. Bhakhayɨbhatwala kʉlongwa mu masinagoogi, na kʉbhakʉnga mwɨ jeela. Khabhɨlɨ mʉkhayɨtwalwa kʉ bhamwene na kʉ bhapɨtɨ abhɨ nsɨ ɨnga mʉlongwe, kʉnongwa ye mwe bhalandati bhaanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɨleelo kukwinyu khanaakho khakhayɨbha khe khabhalɨlo akha kumfumwizya uwukeeti kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ishi, mʉtakhatʉʉyaje kʉtɨ mʉtɨlonje lyoni. ");
INSERT INTO mgq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kʉnongwa ye ɨne ɨntɨɨbhape ɨnjeele na mazwi ge mʉkhayɨlonga, paka abhalʉgʉ bhiinyu bhakhayɨpootwa kʉbhakhaana na kubhadinda. ");
INSERT INTO mgq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Khabhɨlɨ mʉkhayɨlonjeelelwa na bhapaafi bhiinyu, na bhakhambakʉ bhiinyu, na bhanholo bhiinyu, na bhamanyani bhiinyu, bhamu mukaasi yiinyu bhakhayɨbhagoga. ");
INSERT INTO mgq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abhantʉ bhonti, bhakhayibhaviitilwa kʉnongwa ye mwe bhalandati bhaanɨ. ");
INSERT INTO mgq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ɨleelo te lʉkhateeje poope ulusisi lweka, mʉ matwe giinyu! ");
INSERT INTO mgq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nɨɨmwe ɨnga mukhayijimbiilila, ɨpo pe mʉkhayɨposheela uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Akhabhalɨlo khe mʉkhayɨlola ɨnhaaya ɨya Yelusaleemu yabijilwa na bhe bhakulwa ibho, pe mʉkhamanyaje kʉtɨ akhabhalɨlo akha kʉpongolwa ɨnhaaya yɨnɨɨyo khalɨ papɨɨpɨ. ");
INSERT INTO mgq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pe bhe bhalɨ mʉ nsɨ ɨya Yudeeya bhakhashɨmbɨlɨlaje mʉ magamba. Bhe bhalɨ mʉ nhaaya ɨya Yelusaleemu, bhakheepaje bhakhashɨmbɨlaje, na bhe bhayagaatile mu vwizi, bhatakhasheele kʉgalʉkha mʉ nhaaya yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kʉnongwa ye insiku zɨnɨɨzyo zɨkhayɨbha zya mayɨmba, ɨnga mazwi gonti ge gasimbiilwe mu Wusimbe uWufinjile gakhabhombeshe. ");
INSERT INTO mgq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bhasheleeye abhantanda bhe bhakhayɨbha pa wumwamu na bhe bhakhayonsyaga mu nsiku zɨnɨɨzyo! Kʉnongwa ye yɨkhayɨbha papala nhaani mʉ nsɨ yɨnɨɨyo, khabhɨlɨ ʉmʉlakha kufuma kwa Mʉlʉngʉ wʉkhayɨbhɨnzɨla abhantʉ abha khabhalɨlo ɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abhantʉ bhamu, bhakhayɨbhagoga nʉ mʉfwo ʉmʉpɨtɨ, bhamu bhakhayɨtwalwa mu wutumwa mʉ nsɨ inyinji. Abhantʉ bhe te Bhayahuudi, bhakhayɨtabhaalaga ɨnhaaya ɨya Yelusaleemu, kufishila pe insiku zyabho ɨzya kʉtabhaala zikhayisila. ");
INSERT INTO mgq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Vɨkhayɨlolekha ɨvɨlolesyo kwɨ zʉbha, ku mwezi na kʉ nzota. Na mʉ nsɨ munuumu, abhasʉmbɨ bhakhayɨbha na mabhilingwa amapɨtɨ aga khashinto. Lɨnɨɨlyo lɨkhayɨbhabhɨɨkha abhantʉ abhɨ nsɨ zyonti, kʉbha na mayɨmba nɨ lyoga. ");
INSERT INTO mgq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ganaago gonti, we gakwɨnza mʉ nsɨ, abhantʉ bhakhayɨkhatampa mʉ mwoyo kʉnongwa ya kwogopa nhaani. Bhakhayɨsɨɨbhaga kʉtɨ lʉkwɨnza ulufundo ʉlʉpɨtɨ, kʉnongwa ye ivintu ɨvwa kʉmwanya vikhayiyinga. ");
INSERT INTO mgq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Pe bhakhayɨmʉlola ʉMwana wa Muntu akwɨnza mʉ mabhɨngo alɨ na makha nu wumwamu ʉwʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ganaago gonti, we gakwanda kʉbhombekha, mʉkhabhanje nʉ lʉsʉʉbhɨlo nʉ lʉseshelo, kʉnongwa ye ganaago gakhayɨlolesya kʉtɨ ʉMʉlʉngʉ alɨ papɨɨpɨ kʉbhatʉʉla!” ");
INSERT INTO mgq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe ɨshɨkholanyo akhatɨ, “Yeenya ikwi ɨlya mutiini na makwi aganjɨ gonti. ");
INSERT INTO mgq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Akhabhalɨlo khe mʉkʉlola amakwi ganda kuduvwa, nalʉbhɨlo mʉkʉmanya kʉtɨ akhabhalɨlo akhi mvuno khapalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“She shɨnɨɨsho, nɨɨmwe ɨnga mwazɨlola zyonti zɨnɨɨzyo zɨkʉbhombekha, mʉkhamanyaje kʉtɨ ʉwʉmwene wa Mʉlʉngʉ wʉlɨ papɨɨpɨ. ");
INSERT INTO mgq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nalyoli ɨnkʉbhabhʉʉzya, ishipaafi ishi te shɨshɨle we ziniizi zyonti zɨshɨɨlɨ kufumila. ");
INSERT INTO mgq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kʉmwanya na paasɨ vɨkhayɨshɨla, ɨleelo amazwi gaanɨ te gakhaashɨle naalumo. ");
INSERT INTO mgq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mʉbhe amiiso, kʉtɨ mʉtakhaalemwe nɨ nsʉngʉkho imbiibhi, nu wumwezi, na mayɨmba aga mʉ nsɨ umu, isiku lɨnɨɨlyo ɨlya kʉmpeleela lɨkhayɨbhɨnzɨla kwɨ dala ɨlya kʉgandʉshɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kʉnongwa ye isiku lɨnɨɨlyo lɨkhayɨbhɨnzɨla abhantʉ bhonti mʉ nsɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ishi, mʉbhe amiiso akhabhalɨlo khonti, mʉmʉlaabhaje ʉMʉlʉngʉ kʉtɨ, abhapanje amakha kʉshɨlɨla mu zyonti zye zikufumila, kʉtɨ mʉkhondele kwɨmɨɨlɨla pɨlongolela pa Mwana wa Muntu.” ");
INSERT INTO mgq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mu nsiku zɨnɨɨzyo shamʉsanya, uYeesu akhamanyɨzyaga abhantʉ mwi linga ilyi Nyumba iMfinjile. Shawusiku, akhabhalaga kʉgona mwɨ gamba ɨlya Mizeituni. ");
INSERT INTO mgq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Insiku zyonti abhantʉ bhonti bhakhadamʉkhaga ɨshɨlaabhɨla, na kʉbhala mwi linga ilyi Nyumba iMfinjile, kʉtɨ bhamʉtejeelezye. ");
INSERT INTO mgq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Akhabhalɨlo akhi shikulukulu ɨsha makaati ge gatabhishiilwe uwusafu sháamɨle papɨɨpɨ. Ishikulukulu shɨnɨɨsho bhakhatɨnjɨ ɨPasaaka. ");
INSERT INTO mgq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abhapɨtɨ bha bhapuutili, peeka na bhamanyizyi abhɨ ndajɨzyo, bhakhanzaga ɨdala ɨlya kʉmʉgojela uYeesu. Bhakhabhombaga lɨnɨɨlyo kukwilu, kʉnongwa ye bhakhogopaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pe uSeetani akhamwinjila ʉYʉʉda, we bhakhatɨnjɨ Sikalioti, weeka mu bhalandati bha Yeesu ishumi na bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ɄYʉʉda akhabhala kʉ bhapɨtɨ abha bhapuutili, na kʉ bhapɨtɨ abha bhasikaali bhe bhakhalɨndɨlɨlaga iNyumba iMfinjile. Akhalonga nabho she atɨbhaavwe ɨnga bhamʉleme uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lɨnɨɨlyo, lɨkhabhakhondezya nhaani abhapɨtɨ bhaala, pe bhakhɨtɨnhana nʉ weene kuumupa ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ɄYʉʉda akhɨɨtɨkha, pe akhanda kwanza akhabhalɨlo khe ɨmpʉga ɨya bhantʉ naayimo, kʉtɨ amʉlonjeelele uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Isiku ilyi shikulukulu ɨsha makaati ge gatabhishiilwe uwusafu, likhafikha. Isiku lɨnɨɨlyo, yɨkhanzɨwaaga abhantʉ bhabhoole ɨngoole zye zyábhishiilwe kʉbha zyɨ Pasaaka. ");
INSERT INTO mgq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pe uYeesu akhamʉsonteelezya uPeeteli nu Yookhani, akhabhabhʉʉzya akhatɨ, “Bhalaji mʉtʉlɨnganɨzanye ishaakulya ɨshɨ Pasaaka.” ");
INSERT INTO mgq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ʉkwanza tʉlɨngaanye kwoshi?” ");
INSERT INTO mgq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akhabhabhʉʉzya akhatɨ, “Bhalaji mwinjile mʉ nhaaya ɨya mu Yelusaleemu. We mwinjila, mʉtɨkhomaane nʉ mʉsakhaala ʉmo, ayitwinshile ɨnsonta ɨya minzi. Mʉkhamʉlandataje umuntu wʉnʉʉyo mukhinjilaje mu nyumba ye atiyinjile. ");
INSERT INTO mgq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pe mʉkhamʉbhʉʉzye ʉmwanensho uwi nyumba yɨnɨɨyo mʉkhatɨ, ‘UMumanyizyi akʉbhʉzɨɨlɨzya akʉtɨ, “Ulupitu ʉlwa bhajeni lʉlɨ pooshi? Mʉnʉʉmwo mwe ɨnkwanza kulya ishikulukulu ɨshɨ Pasaaka peeka na bhalandati bhaanɨ.” ’ ");
INSERT INTO mgq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Woope atɨbhalanje ulupitu ʉlʉpɨtɨ ʉlwa pamwanya mu nyumba ɨnjelenhanye, lwe lʉlɨngaanye nzɨɨla apa kwɨkhala. Mʉnʉʉmwo mwe mʉtɨlɨngaanye.” ");
INSERT INTO mgq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Abhalandati bhaala bhakhabhala, bhakhafikha mʉ nhaaya yɨnɨɨyo. We bhaafikha, bhakhaaga zyonti zɨlɨ shishiila she uYeesu ábhabhuziizye. Pe bhakhalɨngaanya ɨPasaaka. ");
INSERT INTO mgq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Akhabhalɨlo akha kulya khakhafikha. Pe uYeesu akhɨɨkhala kulya ishaakulya peeka na bhasundikwa bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akhabhabhʉʉzya akhatɨ, “Naseshela nhaani kulya ishikulukulu ishi ɨshɨ Pasaaka peeka nɨɨmwe, we ɨnshɨɨlɨ kʉbha mʉ mayɨmba. ");
INSERT INTO mgq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ɨnkʉbhabhʉʉzya kʉtɨ, te ɨnhaalye winza ishikulukulu ɨshɨ Pasaaka paka ʉMʉlʉngʉ we abhatʉʉla abhantʉ bhaakwe bhonti na kʉtabhaala mʉ wʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pe uYeesu akheega ɨshɨkoopa, akhamusalifwa ʉMʉlʉngʉ akhatɨ, “Yeeji, mʉmwele mwenti! ");
INSERT INTO mgq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ɨnkʉbhabhʉʉzya kʉtɨ, te ɨnhamwele winza idivaayi iyi zabiibu paka we ʉwʉmwene wa Mʉlʉngʉ wɨnza.” ");
INSERT INTO mgq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pe akheega ikaati, akhamusalifwa ʉMʉlʉngʉ, akhamensulanya. We akʉʉbhapa, akhatɨ, “Uwu we mʉbhɨlɨ waanɨ, we inkuwufumwa kʉnongwa yiinyu. Mʉbhombaje shiniishi, kʉnkʉmbʉkha ɨne.” ");
INSERT INTO mgq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","We bhaamala, uYeesu akheega ɨshɨkoopa, akhamusalifwa ʉMʉlʉngʉ. We akʉʉbhapa, akhatɨ, “Ɨshɨkoopa ishi sha lufingo ulupwa, lwe ʉMʉlʉngʉ atɨbhombe nɨɨmwe kwɨ dala ɨlya kwitikha ɨbhanda lyanɨ kʉnongwa yiinyu. ");
INSERT INTO mgq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ɨleelo mʉmanye kʉtɨ, umuntu we akwanza kʉndonjeelela, tukulya peeka nawo panaapa. ");
INSERT INTO mgq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kwe kʉtɨ ʉMwana wa Muntu atɨbhale anza she ʉMʉlʉngʉ ábhiishile ʉlʉbhaatɨkho. Ɨleelo asheleeye, umuntu wʉnʉʉyo we akʉmʉlonjeelela!” ");
INSERT INTO mgq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pe abhasundikwa bha Yeesu bhakhanda kʉbhʉzɨlɨzanya bhɨɨbho na bhɨɨbho kʉtɨ, wu naanu mʉ shɨpʉga shaabho we atɨbhombe lɨnɨɨlyo. ");
INSERT INTO mgq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Abhalandati bha Yeesu bhakhanda kʉdalɨnhana kʉtɨ, wu naanu mʉ bhɨɨbho we mʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Abhamwene abhɨ nsɨ bhakʉtabhaala abhantʉ bhaabho kʉ makha, ɨleelo abhamwene bhanaabho bhakʉyɨtekha kʉtɨ, Bha Shisa kʉ Bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Ɨleelo ɨmwe, mʉtakhasheele kʉbhomba shɨnɨɨsho. Lyoli umuntu we mʉpɨtɨ kukwinyu, wʉnʉʉyo abhanje ngatɨ muntu munsi ku bhonti. We akʉlongozya abhantʉ, abhanje ngatɨ muntu we akʉbhabhombela abhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ishi! Ʉmʉsongo wu naanu? We akwɨkhala kulya ishaakulya! We akwavwa? Bhaatɨ! Te we akwɨkhala kulya? Ishi, ɨne ɨndɨ peeka nɨɨmwe, ne muntu we akʉbhabhombela. ");
INSERT INTO mgq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Akhabhalɨlo khonti akhɨ ndɨngo zyanɨ, ɨmwe mwe mwaamɨle nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ishi, nɨɨne ɨnkʉʉbhapa amakha aga kʉtabhaala mʉ wʉmwene waanɨ, anza she ʉTaata waanɨ ámpiiye kʉtabhaala. ");
INSERT INTO mgq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pe mukhayilya na kʉmwela nɨɨne, mʉ wʉmwene waanɨ. Khabhɨlɨ mʉkhayɨɨkhala mʉ matengo aga shɨmwene, kʉbhalonga abhantʉ abha vɨkholo ishumi na vɨbhɨlɨ ɨvwa Bhaisilaeli.” ");
INSERT INTO mgq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","UYeesu akhatɨ, “Siimoni, Siimoni! Ʉmanye akhinza kʉtɨ uSeetani amulaabhile ʉMʉlʉngʉ na ayitishiliilwe kʉbhalɨnga ɨmwe, anzu muvuni ʉwɨ ngano she akʉkhoma na kugulusya ɨngano yaakwe. ");
INSERT INTO mgq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɨleelo ɨne, ɨnkʉkʉlaabhɨla kwa Mʉlʉngʉ, kʉtɨ ʉtakhalʉleshe ʉlwɨtɨkho lwakho kʉkwanɨ. Ɨleelo we wangalʉshɨla ɨne, ʉkhabhagomwe abhamwinyu.” ");
INSERT INTO mgq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","USiimoni akhamwamʉla akhatɨ, “We Mwene! Ɨne injifumwizye kʉbha nɨɨwe, injilinganyiinye kʉkʉngwa peeka nɨɨwe mwɨ jeela, poope yɨbhe ya kufwa!” ");
INSERT INTO mgq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","UYeesu akhamwamʉla akhatɨ, “Peeteli! Ɨnkʉkʉbhʉʉzya kʉtɨ, uwusiku ʉwa mʉsanyʉʉnʉ, we ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ kʉtɨ utamanyile.” ");
INSERT INTO mgq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pɨlongolela, uYeesu akhabhabhʉzɨɨlɨzya abhalandati bhaakwe akhatɨ, “We nabhasonteelezya sita nhela, awe imbuguuli awe ɨvɨlyatʉ, mwaabhuliliilwe akhantʉ khokhonti?” Bhakhamwamʉla bhakhatɨ, “Khaala.” ");
INSERT INTO mgq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Ishi, ɨnga umuntu alɨ nɨ nhela, awe imbuguuli, ayeeje. Woope we atalɨ nʉ mʉfwo ʉmʉpɨtɨ, akazye ikooti lyakwe, ɨnga akale weeka. ");
INSERT INTO mgq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kʉnongwa ye yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Abhaziliilwe peeka na bhabhomba mbiibhi.’ Amazwi ganaago gásimbiilwe ɨzya kʉkwanɨ. Ishi ɨnkʉbhabhʉʉzya kʉtɨ, ganaago gakwanzɨwa gabhombeshe kʉkwanɨ, khabhɨlɨ galɨ papɨɨpɨ kʉbhombekha.” ");
INSERT INTO mgq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhakhamʉbhʉʉzya bhakhatɨ, “We Mwene! Yeenya! Ɨpa galɨɨpo amafwo amapɨtɨ gabhɨlɨ.” Woope akhatɨ, “Mʉtajendeelele kʉlonga ɨnongwa ɨzya mʉfwo ʉmʉpɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pe uYeesu akhasogola, akhabhala kwɨ gamba ɨlya Mizeituni, anza she yáamɨle mwata yaakwe. Bhoope abhalandati bhaakwe, bhakhamʉlandata. ");
INSERT INTO mgq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","We aafikha mwɨ gamba liila, akhabhabhʉʉzya akhatɨ, “Mumupuutaje ʉMʉlʉngʉ, kʉtɨ aabhape amakha ɨnga ɨndɨngo zɨtakhabhatole.” ");
INSERT INTO mgq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pe akhabhalekha paala, akhabhala pɨlongolela khashe, uwutali ʉwa kʉsʉmba iwe. Akhasʉgamɨla, akhapuuta kwa Mʉlʉngʉ akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“We Taata! Ɨnga uyiganile, ʉtakhɨtɨshɨzye kʉtɨ amayɨmba amapɨtɨ ɨga ganaaje! Ɨleelo yɨtakhabhe anza she ɨnkwanza, lyoli anza she ʉkwanza ɨwe.”  ");
INSERT INTO mgq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pe ʉkhabhɨzya kufuma kʉmwanya akhamwɨnzɨla uYeesu, akhamʉpanga amakha. ");
INSERT INTO mgq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɨleelo uYeesu akhonjezya kupuuta, kʉnongwa ye áamɨle nu wuswimiilizu ʉwʉpɨtɨ. We akupuuta, amantwinsi ge galɨ anzɨ bhanda gakhalendaga paasɨ. ");
INSERT INTO mgq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","We apuuta, akhɨmɨɨlɨla, akhabhala ku bhalandati bhaakwe, akhaaga bhagonile utulo, kʉnongwa ye bháamɨle mu wuswimiilizu. ");
INSERT INTO mgq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akhabhabhʉʉzya akhatɨ, “Khooni khe mugonile utulo? Daamushi! Mumupuutaje ʉMʉlʉngʉ, kʉtɨ aabhape amakha ɨnga ɨndɨngo zɨtakhabhatole.” ");
INSERT INTO mgq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","UYeesu we akʉlonga zyonti zɨnɨɨzyo, shɨkhɨnza ɨshɨpʉga ɨsha bhantʉ bhe bhalongoliilwe nʉ Yʉʉda, weeka mu bhalandati bhaakwe ishumi na bhabhɨlɨ. Pe ʉYʉʉda akhamʉsejeelela uYeesu ɨnga amʉtambɨle. ");
INSERT INTO mgq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","UYeesu akhamwamʉla akhatɨ, “We Yʉʉda! Ʉkʉmʉlonjeelela ʉMwana wa Muntu kwɨ dala ɨlya kʉmʉtambɨla?” ");
INSERT INTO mgq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Abhalandati bha Yeesu we bhaalola ganaago na kʉmanya zye zɨtɨbhombeshe, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “We Mwene! Tubhadibanye na mafwo amapɨtɨ?” ");
INSERT INTO mgq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pe ʉmo mʉ bhanaabho akhamʉkhoma umubhombi ʉwa mupuutili ʉmʉpɨtɨ, akhamudiba nʉ mʉfwo ʉmʉpɨtɨ ikutwe ɨlya kʉndɨɨlo. ");
INSERT INTO mgq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","UYeesu akhalonga akhatɨ, “Lakha kʉbhomba lɨnɨɨlyo!” Akhamʉpalamansya ikutwe liila, akhamʉponɨa. ");
INSERT INTO mgq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","UYeesu akhabhabhʉzɨɨlɨzya abhapɨtɨ bha bhapuutili, abhapɨtɨ abha bhasikaali, peeka na bhasongo abha Bhayahuudi, akhatɨ, “Khooni khe mwinzile na mafwo amapɨtɨ ni nduugu, ngatɨ mwinzile kʉmʉlema umubuda? ");
INSERT INTO mgq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Insiku zyonti twabhanga peeka mwi linga ilyi Nyumba iMfinjile, khooni mʉtandemaga! Ɨleelo, ɨkha khe khabhalɨlo khiinyu, khe atabhalaaye ʉmwene ʉwa khiisi.” ");
INSERT INTO mgq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pe abhantʉ bhaala bhakhamʉlema uYeesu, bhakhamwega, bhakhabhala nawo mu nyumba ya mupuutili ʉmʉpɨtɨ. UPeeteli akhamʉlandataga ukutali. ");
INSERT INTO mgq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Abhantʉ bhaala we bhaafikha ku nyumba ya mupuutili ʉmʉpɨtɨ, bhakhapemba ʉmwoto pakaasi pa lʉbhʉngo mwi linga, bhakhɨɨkhala peeka, bhakhootaga ʉmwoto. Woope uPeeteli akhasejeelela, akhɨɨkhala peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ɨleelo we ʉlʉkhozyo ʉlwa mwoto lwalama, umubhombi ʉmo ʉmʉlɨndʉ, akhamʉlola uPeeteli ayɨkhaaye, akhamwenya akhinza, akhatɨ, “Woope umuntu ʉnʉ aamɨle peeka nu Yeesu.” ");
INSERT INTO mgq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ɨleelo uPeeteli akhakhaana akhatɨ, “Wʉmwantanda ɨwe, ʉlɨ na malenga, ɨne intamumanyile!” ");
INSERT INTO mgq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pɨlongolela khashe, umuntu ʉwamwabho akhamʉlola uPeeteli akhatɨ, “Nɨɨwe bhʉʉlo ʉlɨ peeka nabho.” Ɨleelo uPeeteli akhamwamʉla akhatɨ, “Wumuntu ɨwe! Ɨne ɨntalɨ peeka nabho!” ");
INSERT INTO mgq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","We yatʉʉkha ɨsaala yeeka, umuntu ʉwamwabho akhazemeshezya akhatɨ, “Nalyoli umuntu ʉnʉ aamɨle peeka nu Yeesu! Kʉnongwa ye woope muntu wa kʉ Galɨlaaya!” ");
INSERT INTO mgq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɨleelo uPeeteli akhatɨ, “Wumuntu ɨwe! Zɨnɨɨzyo zye ʉkʉlonga, ɨne ɨntakʉzyaganya!” Papaala we akʉlonga zɨnɨɨzyo, ɨnhanda yɨkhabhɨlɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ɄMwene uYeesu akhagalʉnhana, akhamwenya uPeeteli. Pe uPeeteli akhakʉmbʉkha amazwi gaala ge uYeesu ámubhuziizye kʉtɨ, “Ʉmʉsanyʉʉnʉ, we ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pe uPeeteli akhafuma kunzi, akhalɨla amansozi gakhiikha nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abhasakhaala bhe bhakhamʉlɨndɨlɨlaga uYeesu, bhakhamʉsʉpɨzyaga na kʉmʉkhoma. ");
INSERT INTO mgq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakhamupinya nɨ shɨtambaala kumiiso, bhakhamʉbhʉzɨlɨzyaga bhakhatɨnjɨ, “Tambʉla twenye! Wu naanu we akʉkhoma?” ");
INSERT INTO mgq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bhakhajendeelela kʉmʉshoolanya inyinji bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","We kwasha, abhasongo abha Bhayahuudi, abhapɨtɨ bha bhapuutili, na bhamanyizyi abhɨ ndajɨzyo, bhakhabhʉngaana. Bhakhalajɨzya kʉtɨ bhamʉleete uYeesu pɨlongolela pɨ balaaza lyabho, bhakhamʉbhʉzɨlɨzyaga bhakhatɨnjɨ, ");
INSERT INTO mgq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Tʉbhʉʉzye! Ɨwe we we Kilisiti?” UYeesu akhabhaamʉla akhatɨ, “Poope ɨnga nabhabhʉʉzya, te mwɨtɨshe ngakheeka. ");
INSERT INTO mgq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Khabhɨlɨ ɨnga nabhabhʉzɨɨlɨzya, te mʉnaamʉle naalimo. ");
INSERT INTO mgq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ɨleelo kufuma ɨsaala ɨnɨ, ʉMwana wa Muntu atɨyɨɨkhale kʉmbalɨ ɨya kʉndɨɨlo ɨya Mʉlʉngʉ ʉwa makha.” ");
INSERT INTO mgq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɨpo pe bhonti bhakhatɨ, “Kwe kʉtɨ ɨwe we Mwana wa Mʉlʉngʉ?” UYeesu akhabhaamʉla akhatɨ, “Ɨmwe mwe mʉkʉtɨ ɨne ne neene!” ");
INSERT INTO mgq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pe abhapɨtɨ bhaala bhakhatɨ, “Tʉkwanza bhaashi abhakeeti? Kʉnongwa ye ɨtwe tʉneetwe twɨmvwa izwi ili kufuma mwi lomu lyakwe wʉʉyo!” ");
INSERT INTO mgq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pɨlongolela, abhapɨtɨ bhaala bhonti abha Bhayahuudi bhakhɨmɨɨlɨla, bhakhamʉtwala uYeesu kwa Pɨlaato. ");
INSERT INTO mgq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhakhanda kʉmʉsɨtaaka bhakhatɨnjɨ, “Umuntu ʉnʉ, twaamulolile akʉmanyɨzya zye zɨkʉbhasonganya abhantʉ abhɨ nsɨ yɨɨtʉ bhatatinikhaje isilikaali. Kʉnongwa ye akʉkhaana abhantʉ kufumwa ɨnsonho kwa Kaisaali, khabhɨlɨ akʉlonga akʉtɨ ʉweene wu Kilisiti, ʉMwene.” ");
INSERT INTO mgq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ɄPɨlaato akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Bhʉlɨ, ɨwe we Mwene wa Bhayahuudi?” UYeesu akhamwamʉla akhatɨ, “Weewe walonga kʉtɨ ɨne ne mwene.” ");
INSERT INTO mgq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pe ʉPɨlaato akhabhabhʉʉzya abhapɨtɨ bha bhapuutili, peeka nɨ mpʉga ɨya bhantʉ akhatɨ, “Ɨntakʉwʉlola uwubhiibhi ngaweeka kwa muntu ʉnʉ.” ");
INSERT INTO mgq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abhantʉ bhaala, bhakhazeemezya bhakhatɨ, “Khooni khe ɨmanyɨzyo zyakwe zɨkʉbhasonganya abhantʉ abhɨ nsɨ yɨɨtʉ bhatayitinikhaje isilikaali! Asasiizye ɨmanyɨzyo zɨnɨɨzyo ɨnsɨ ɨnɨ yonti ɨya Yudeeya, ayandile kʉ Galɨlaaya ayɨnza aafikha uku.” ");
INSERT INTO mgq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ɄPɨlaato we ayɨmvwa ganaago, akhabhʉzɨɨlɨzya she uYeesu muntu wa kʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","We aamanya kʉtɨ muntu wa kʉ Galɨlaaya, akufuma mʉ wʉmwene ʉwa Heloodi, akhamʉtwala kwa Heloodi kʉnongwa ye insiku zɨnɨɨzyo, uHeloodi áamɨle papaala pa Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","UHeloodi we amʉlola uYeesu, akhaseshela nhaani, kʉnongwa ye akhɨmvwaga intumi zyakwe, ni nsiku inyinji akhanzaga kʉmʉlola. Akhasʉbhɨlaga kʉtɨ ayɨlolele wʉʉyo ɨvɨlolesyo vwe uYeesu angakhola kʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pe uHeloodi akhamʉbhʉzɨɨlɨzya uYeesu amazwi aminji, ɨleelo ʉweene atakhaamʉla poope izwi lyeka. ");
INSERT INTO mgq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abhapɨtɨ abha bhapuutili na bhamanyizyi abhɨ ndajɨzyo bhakhɨmɨlɨlaga na kʉmʉsɨtaaka nhaani uYeesu. ");
INSERT INTO mgq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pe uHeloodi na bhasikaali bhaakwe bhakhanda kʉmʉsʉʉpɨzya uYeesu na kʉmwangalɨzya. Bhakhamʉkwatɨzya ɨgolole ɨlya shɨmwene na kʉmwangalɨla. Pe uHeloodi akhamʉgalʉsya uYeesu kwa Pɨlaato. ");
INSERT INTO mgq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kufuma isiku lɨnɨɨlyo, uHeloodi nʉ Pɨlaato bhakhabha bhamanyani, she poope palʉsalo bháamɨle mʉ wʉlʉgʉ. ");
INSERT INTO mgq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pɨlongolela, ʉPɨlaato akhabhabhʉngaanɨkha abhapɨtɨ abha bhapuutili, na bhasongo abha Bhayahuudi, peeka nɨ mpʉga ya bhantʉ bhe bhábhungaanile. ");
INSERT INTO mgq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akhabhabhʉʉzya akhatɨ, “Mʉndeteeye umuntu ʉnʉ, mʉkʉtɨ akʉbhasonjeelezya abhantʉ bhatayitinikhaje isilikaali. Ishi kʉ zye mʉkʉmʉlonga, namʉbhʉzɨɨlɨzya pɨlongolela yiinyu, ɨleelo ɨntaalola uwubhiibhi ngaweeka kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Woope uHeloodi ataalola uwubhiibhi ngaweeka kʉkwakwe, mwe mʉmwo amʉgalʉsya kʉkwɨtʉ. Ishi mʉmanye akhinza kʉtɨ, umuntu ʉnʉ, lɨtalɨɨpo naalimo lye abhombile, lye lɨngakhondezya kʉtɨ bhamʉgoje. ");
INSERT INTO mgq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ishi, akhomwe nɨ sambogo, pe ɨntɨmʉsatʉlɨle.”  ");
INSERT INTO mgq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yáamɨle mwata isiku ilyi shikulukulu ɨshɨ Pasaaka, ʉPɨlaato kʉbhasatʉlɨla abhantʉ ʉmʉkʉngwa weeka. ");
INSERT INTO mgq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɨleelo abhantʉ bhaala bhonti bhakhazingula ɨshongo peeka bhakhatɨ, “Umuntu wʉnʉʉyo, akhondeeye kʉmʉgoga! Tʉkwanza ʉtʉsatʉlɨle ʉBalaaba!” ");
INSERT INTO mgq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ɄBalaaba ákungiilwe mwɨ jeela kʉnongwa ye ábhombile ibho ɨpɨtɨ mʉ nhaaya, na kʉgoga. ");
INSERT INTO mgq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ɄPɨlaato akhanzaga kʉmʉsatʉlɨla uYeesu, pe akhalonga winza na bhantʉ bhaala. ");
INSERT INTO mgq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ɨleelo abheene bhakhonjezya kuzingula ɨshongo bhakhatɨnjɨ, “Mʉkhomeele pa shɨkhobhenhanyo! Mʉkhomeele pa shɨkhobhenhanyo!” ");
INSERT INTO mgq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ɄPɨlaato akhalonga nabho winza akha wʉtatʉ akhatɨ, “Akhomeelwe ku lyoni? Umuntu ʉnʉ, atulile zyoni? Ɨne ɨntakʉlɨlola naalimo kʉkwakwe lye lɨngakhondela kʉmʉgoga! Ishi akhomwe nɨ sambogo, pe ɨntɨmʉsatʉlɨle.” ");
INSERT INTO mgq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ɨleelo abhantʉ bhaala bhakhonjezya kuzingula ɨshongo nhaani, bhakhanzaga kʉtɨ uYeesu akhomeelwe pa shɨkhobhenhanyo. Pɨlongolela, ɨshongo shaabho shɨkhɨtɨshɨlwa. ");
INSERT INTO mgq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pe ʉPɨlaato akhaamʉla kʉbhomba anza she bhámulaabhile. ");
INSERT INTO mgq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akhamʉsatʉlɨla ʉBalaaba we bhákhondeziizwe nawo, poope she ákungiilwe kʉnongwa ɨya kwandɨɨlɨzya ibho ɨpɨtɨ na kʉgoga. Pe akhaabhapa uYeesu abhasikaali kʉtɨ bhabhombe anza she abhantʉ bhakwanza. ");
INSERT INTO mgq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abhasikaali we bhakʉmʉtwala uYeesu kʉmʉgoga, bhakhakhomaana nu muntu ʉmo we bhakhatɨnjɨ uSiimoni, ʉwa mʉ nhaaya ɨya mu Kileene. Umuntu wʉnʉʉyo áfumile ku vwizi, akhabhalaga mu Yelusaleemu. Bhakhamʉlema, bhakhamʉpɨmbɨzya ɨshɨkhobhenhanyo sha Yeesu. Pe akhashɨpɨmba, akhalandataga kʉlʉsalo kwa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nɨ mpʉga ɨya bhantʉ yɨkhamʉlandataga uYeesu. Mukaasi mʉ bhanaabho, bhálɨɨpo abhantanda bhe bhakhalɨlaga na kʉswɨmɨɨlɨla kʉnongwa ya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","UYeesu akhabhashebhela, akhabhabhʉʉzya akhatɨ, “Ɨmwe bhantanda abha mu Yelusaleemu! Mʉleshe kʉndɨlɨla ɨne! Lyoli mʉlɨlaje kʉnongwa ɨya wɨɨkhalo wiinyu na bhaana bhiinyu! ");
INSERT INTO mgq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mʉmanye akhinza kʉtɨ insiku zye zɨkwɨnza, abhantʉ bhakhayɨtɨ, ‘Bhasayiilwe abhantanda bhe bhalʉʉjɨ, bhe bhatapaapile na kwonsya!’ ");
INSERT INTO mgq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pe, ‘Abhantʉ bhakhayɨgabhʉzyaga amagamba kʉtɨ, “Mʉtʉgwɨle!” Bhakhayɨtʉbhʉzyaga ʉtʉgamba utunsi tunsi kʉtɨ, “Mutugubishile!” ’ ");
INSERT INTO mgq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kʉnongwa ye ɨnga bhakʉbhomba akhabhiibhi shiniishi, we ikwi libhisi, pe yɨtɨbhe bhʉlɨɨbhʉlɨ we ikwi lyʉma?” ");
INSERT INTO mgq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Akhabhalɨlo khanaakho, abhasikaali bhakhabhatwalaga abhabhomba mbiibhi bhabhɨlɨ peeka nu Yeesu kʉbhakhomeela. ");
INSERT INTO mgq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","We bhaafikha pe bhakhatɨnjɨ, “Pi Fupa ilyi Twe,” bhakhamʉkhomeela uYeesu pa shɨkhobhenhanyo. Bhoope abhabuda bhabhɨlɨ bhaala bhakhabhakhomeela, weeka weeka pa shɨkhobhenhanyo shaakwe, ʉmo kʉmbalɨ ɨya kʉndɨɨlo ɨya Yeesu, ʉwamwabho kʉmbalɨ ɨya kʉmongo. ");
INSERT INTO mgq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","UYeesu akhatɨ, “We Taata! Ʉbhatʉʉyɨle! Kʉnongwa ye zye bhakʉbhomba, bhatazimanyile.” Abhasikaali bhaala bhakhagabhana amenda ga Yeesu, kwɨ dala ɨlya kʉkhoma ɨkʉʉla. ");
INSERT INTO mgq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abhantʉ bhakhɨmɨɨlɨla papaala, bhakhenyaaga. Abhapɨtɨ abha Bhayahuudi, bhakhanda kʉmwangalɨzya uYeesu bhakhatɨnjɨ, “Apokhaga abhanjɨ! Ishi, ɨnga ʉweene wu Kilisiti ʉmʉsaabhʉlwa wa Mʉlʉngʉ, ayɨposhe wʉʉyo!” ");
INSERT INTO mgq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abhasikaali bhoope, bhakhamwangalɨzya. Bhakhamʉsejelelaga na kuumupa idivaayi ye yilulile, ");
INSERT INTO mgq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bhakhamʉbhʉzyaga bhakhatɨnjɨ, “Ɨnga we Mwene wa Bhayahuudi, yɨposhe wʉneewe!” ");
INSERT INTO mgq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Khabhɨlɨ pamwanya pa shɨkhobhenhanyo shaakwe, páamɨle ɨshɨbaabho she shásimbiilwe amazwi ge gakʉtɨ, “Ʉnʉ wʉ Mwene ʉwa Bhayahuudi.” ");
INSERT INTO mgq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Weeka mʉ bhabhomba mbiibhi bhaala bhabhɨlɨ, akhamʉshoolanya uYeesu akhatɨ, “Ɨwe te we Kilisiti? Yɨposhe wʉneewe, ʉtʉposhe nɨɨtwe!” ");
INSERT INTO mgq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɨleelo ʉwamwabho ʉla ʉwa wʉbhɨlɨ akhamʉkhajɨla akhatɨ, “We! Ʉtakʉmwogopa ʉMʉlʉngʉ? Twenti bhatatʉ tulongiilwe ulufundo ʉlwa shɨkholo sheeka. ");
INSERT INTO mgq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɨtwe tʉkhondeeye kʉposheela ulufundo ulu, kʉnongwa ye tulongiilwe ku mbiibhi zye tubhombile. Ɨleelo ʉnʉ, atabhombile ibhiibhi naalimo.” ");
INSERT INTO mgq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pe akhatɨ, “We Yeesu! We ukwinjila mʉ wʉmwene waakho, ʉkhankʉmbʉkhaje!” ");
INSERT INTO mgq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","UYeesu akhamwamʉla akhatɨ, “Nalyoli ɨnkʉkʉbhʉʉzya kʉtɨ, ʉmʉsanyʉʉnʉ ʉtɨbhe peeka nɨɨne kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kwandɨla ɨsaala ɨya mʉtanda shamʉsanya, kufikha mʉ saa tisa, akhiisi khakhagwa mʉ nsɨ yonti, ");
INSERT INTO mgq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ɨzʉbha lɨtakhalamaga. Ɨgolole lye lyápitulanyiinye aPafinjile na Pafinjile Nhaani mu Nyumba iMfinjile, likhadeebukha pakaasi kufuma pamwanya kwikha paasɨ. ");
INSERT INTO mgq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","UYeesu akhakhoola kwi zi ɨlya kʉdandɨzya akhatɨ, “We Taata! Nabhɨɨkha uwuumi waanɨ mʉ nyoobhe zyakho.” We alonga ganaago, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ʉmʉpɨtɨ ʉwa bhasikaali we aalola zye zyabhombekha, akhamʉpaala ʉMʉlʉngʉ akhatɨ, “Nalyoli umuntu ʉnʉ aamɨle mugolosu!” ");
INSERT INTO mgq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abhantʉ bhonti bhe bhábhungaanile papaala, we bhazɨlola zye zyabhombekha, bhakhagalʉkha kʉkhaaya zyabho, bhakʉyɨkhoma-khoma ku vifubha vwabho ku wuswimiilizu. ");
INSERT INTO mgq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Khabhɨlɨ bhonti bhe bhámanyiine nu Yeesu, peeka na bhantanda bhe bhakhamʉlandataga kufuma kʉ Galɨlaaya, bhɨ́mɨlɨɨye ukutali bhakhenyaaga zye zɨkʉbhombekha. ");
INSERT INTO mgq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Álɨɨpo umuntu ʉmo, we bhakhatɨnjɨ uYoosefu, áfumile mʉ nhaaya ɨya ku Alimasaaya, mʉ nsɨ ɨya Yudeeya. UYoosefu áamɨle weeka mʉ bhapɨtɨ abha Bhayahuudi. Ɨleelo atítinhiine na bhamwabho kʉ zya kʉmʉgoga uYeesu, kʉnongwa ye áamɨle mugolosu pamiiso ga Mʉlʉngʉ. Khabhɨlɨ akhasʉbhɨlaga kwɨnza kʉ wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pe umuntu ʉnʉ akhabhala kʉmʉlaabha ʉPɨlaato kʉtɨ, ayeeje ivimba lya Yeesu ɨnga alɨsyɨle. ");
INSERT INTO mgq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ɄPɨlaato we ayɨɨtɨkha, pe ʉweene akhabhala kwisya ivimba pa shɨkhobhenhanyo. Akhalɨsyempa nʉ mwenda, akhalɨlambalɨkha mʉ mbɨɨpa ye yábaniilwe mwɨ lyalaawe. Ɨmbɨɨpa yɨnɨɨyo, bhatásyɨlɨɨye umuntu naalumo. ");
INSERT INTO mgq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Isiku lɨnɨɨlyo, lyámɨle lisiku ɨlya kʉyɨlɨngaanya nɨ Sabaato, ye yáamɨle papɨɨpɨ kwanda. ");
INSERT INTO mgq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abhantanda bhe bhínzile peeka nu Yeesu kufuma kʉ Galɨlaaya, bhakhabhala peeka nu Yoosefu kʉ mbɨɨpa. Bhakhayɨlola ɨmbɨɨpa, na bhakhalola pe bhakhalɨlambalɨkha ivimba lya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pɨlongolela, bhakhagalʉkha kʉkhaaya, bhakhalɨngaanya amafuta nʉ mʉlembo ʉwa kudinda ivimba kununha. Pi siku ɨlyɨ Sabaato bhakhatʉʉzya, anza she ɨndajɨzyo zya Moose zɨkʉlajɨzya. ");
INSERT INTO mgq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Isiku ɨlya Pamʉlʉngʉ ɨshɨlaabhɨla we kʉshɨɨlɨ kuzelupa, abhantanda bhakhabhala kʉ mbɨɨpa. Abhantanda bhanaabho, bhálemile amafuta nʉ mʉlembo we bhálinganyiinye ʉwa kʉpakha ivimba lya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","We bhaafikha, bhakhalola iwe lye bhádindile libhungulusye, lɨlɨ pambalɨ pa mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pe bhakhinjila mukaasi, bhakhaaga ivimba lya Mwene uYeesu naalimo. ");
INSERT INTO mgq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","We bhakuswiga, bhakhagandʉshɨlwa abhasakhaala bhabhɨlɨ bhɨmɨlɨɨye papɨɨpɨ nabho, bhe bhákwatile amenda amazelu ge gakumeetukha nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Abhantanda bhaala, bhakhalemwa nɨ lyoga, bhakhasʉlamɨkha amatwe gaabho paasɨ. Pe abhasakhaala bhaala bhakhabhabhʉʉzya bhakhatɨ, “Khooni khe mʉkʉmwanza we mwumi mʉ bhafwe? ");
INSERT INTO mgq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Atalɨɨpo ɨpa! Azyushile! Mʉkʉmbʉshe amazwi ge ábhabhuziizye we alɨ kʉ Galɨlaaya peeka nɨɨmwe, átɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Yɨkwanzɨwa ʉMwana wa Muntu atwalwe mʉ nyoobhe zya bhabhomba mbiibhi, bhamʉkhomeele pa shɨkhobhenhanyo, isiku ɨlya wʉtatʉ azyʉshe’!” ");
INSERT INTO mgq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Abhantanda bhaala, bhakhakʉmbʉkha amazwi ga Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pe bhakhafuma mʉ mbɨɨpa, bhakhabhala bhakhabhabhʉʉzya ɨnongwa ziila zyonti abhalandati bha Yeesu ishumi na weeka, peeka na bhanjɨ bhonti. ");
INSERT INTO mgq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abhantanda bhanaabho bhe bhátwalile ɨnongwa zɨnɨɨzyo ku bhasundikwa, bháamɨle bha bhɨɨbha: uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala, ʉYoana, nu Maliya unyina wa Yaakobo, peeka na bhantanda abhanjɨ bhe bháamɨle peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Abhasundikwa we bhɨmvwa ɨnongwa zɨnɨɨzyo, bhakhalola zyɨ lenga, bhatakhɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ɨleelo uPeeteli akhɨmɨɨlɨla nalʉbhɨlo, akhabhala kʉ mbɨɨpa akʉshɨmbɨla. We aafikha, akhagunzama, akhɨnanjɨzya mʉ mbɨɨpa, akhalola ikibha lyene lye bhaamʉsyɨlɨlɨɨye uYeesu. Akhasogola paala, akuswiga zye zifumiiye. ");
INSERT INTO mgq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Isiku lɨnɨɨlyo ɨlya Pamʉlʉngʉ, abhalandati bhabhɨlɨ abha Yeesu bhakhabhalaga kʉ khakhaaya akha mu Emau. Akhakhaaya khanaakho, kháamɨle apatali apa kʉjenda amasaala gabhɨlɨ kufuma ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mwɨ dala abhalandati bhaala bhakhalongaga ɨnongwa zye zyáfumiiye. ");
INSERT INTO mgq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","We bhakʉlonga zɨnɨɨzyo, uYeesu wʉʉyo akhɨnza akʉjenda peeka nabho, ");
INSERT INTO mgq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ɨleelo ʉMʉlʉngʉ akhabhabhɨɨkha kʉtɨ bhatamanyaje kʉtɨ wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","UYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkʉlonga nongwa zyoni kumo mʉkʉjenda?” Abhantʉ bhaala bhakhɨmɨɨlɨla, kumo bhasungamile. ");
INSERT INTO mgq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Weeka mʉ bhanaabho, ɨtaawa lyakwe áamɨle wu Kileopa, akhamwamʉla akhatɨ, “Ɨwe we mujeni wʉmwene mu Yelusaleemu, we utamanyile zye zibhombeshile kʉnʉʉkwo insiku ɨzyɨ golo bhʉʉlo!” ");
INSERT INTO mgq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Woope uYeesu akhatɨ, “Kʉlɨ nongwa zyoni?” Bhakhamwamʉla bhakhatɨ, “Ɨnongwa zye bhamʉbhombeeye uYeesu ʉwa ku Naazaleti. Umuntu ʉyo aamɨle mukuwi, khabhɨlɨ aamɨle na makha aminji mʉ mbombo na mu mazwi gaakwe, ʉMʉlʉngʉ na bhantʉ bhaakhondeziizwe nawo. ");
INSERT INTO mgq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ɨleelo, abhapɨtɨ abha bhapuutili, na bhalongozi bhɨɨtʉ, anza bhamufumwa kʉtɨ alongwe ulufundo ʉlwa kʉmʉgoga. Anza bhamʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wʉnʉʉyo we twamʉsʉbhɨlaga kʉtɨ atɨbhatʉʉle aBhaisilaeli. Ishi, ʉmʉsanyʉʉnʉ lisiku ɨlya wʉtatʉ, kufuma pe zɨnɨɨzyo zyonti zyaabhombeshile. ");
INSERT INTO mgq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Khabhɨlɨ abhantanda abhanjɨ mʉ shɨpʉga shɨɨtʉ bhatugandusiizye, kʉnongwa ye ʉmʉsanyʉʉnʉ we kukusha, bhabhalile kʉ mbɨɨpa, ");
INSERT INTO mgq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɨleelo bhaajile ivimba naalimo. Bhinzile kʉtʉbhʉʉzya kʉtɨ bhalolesheliilwe na bhakhabhɨzya bhe bhabhabhuziizye kʉtɨ uYeesu mʉpʉʉma. ");
INSERT INTO mgq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pe abhanjɨ mʉ shɨpʉga shɨɨtʉ bhabhalile kʉ mbɨɨpa, bhaajile zɨlɨ shishiila she bhalonjile abhantanda bhaala, ɨleelo, ʉweene bhatamulolile.” ");
INSERT INTO mgq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","UYeesu wʉʉyo akhabhabhʉʉzya akhatɨ, “Ɨmwe mwe bhalema! Khooni khe amooyo giinyu magomu kwɨtɨkha zyonti zye zyálonjiilwe na bhakuwi! ");
INSERT INTO mgq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bhátɨlɨ yɨkhanzɨwaaga kʉtɨ uKilisiti ashɨlɨle mʉ mayɨmba gaala gonti, pɨlongolela ayinjile mu wumwamu waakwe.” ");
INSERT INTO mgq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pe akhabhabhʉʉzya ɨnongwa zyonti ɨzya mu Wusimbe uWufinjile, zye zyásimbiilwe kʉ zya weene. Akhalonga zɨnɨɨzyo kwandɨla ivitaabu ɨvwa Moose ni vitaabu vwonti ɨvwa bhakuwi. ");
INSERT INTO mgq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","We bhapalamɨla kufikha mʉ khakhaaya khe bhakhabhalaga, uYeesu akhabha ngatɨ akʉshɨzanya. ");
INSERT INTO mgq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ɨleelo abheene bhakhamʉlamba nhaani bhakhatɨ, “Ʉyɨɨkhale ɨpa peeka nɨɨtwe! Ishi kukwila, akhiisi khapalamɨɨye.” Pe uYeesu akhinjila mu nyumba, akhɨɨkhala nabho. ");
INSERT INTO mgq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","We bhɨkhaaye peeka kulya ishaakulya, uYeesu akheega ikaati, akhalɨsaya, akhamensula, akhabhapanga. ");
INSERT INTO mgq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Akhabhalɨlo khanaakho, ʉMʉlʉngʉ akhabhigulila kʉmanya kʉtɨ wu Yeesu, panaapo akhayonga pɨlongolela yaabho. ");
INSERT INTO mgq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pe bhakhabhʉzɨlɨzanya bhakhatɨ, “Mwe mʉmwo akhabhalɨlo khe alongaga nɨɨtwe mwɨ dala, atʉbhʉzyaga zye zɨlɨ mu Wusimbe uWufinjile, amooyo gɨɨtʉ gaamɨle nʉ lʉseshelo nhaani!” ");
INSERT INTO mgq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Akhabhalɨlo khanaakho bhakhasogola, kʉgalʉkha ku Yelusaleemu. Kʉnʉʉkwo bhakhabhalola abhasundikwa bha Yeesu ishumi na weeka bhabhungaanile peeka na bhanjɨ, ");
INSERT INTO mgq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bhakhabhabhʉʉzya bhabhɨlɨ bhaala bhakhatɨ, “Wʉ wʉʉyo, ʉMwene wɨɨtʉ nalyoli azyushile! Amʉlolesheeye uSiimoni!” ");
INSERT INTO mgq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pe bhoope bhakhabhapanjɨla zyonti zye zibhafumiiye mwɨ dala, na she anza bhamʉmanya uYeesu we akumensula ikaati na kʉʉbhapa. ");
INSERT INTO mgq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Abhalandati bha Yeesu we bhakʉjendeelela kʉlonga ganaago, uYeesu wʉʉyo akhɨmɨɨlɨla pakaasi yaabho. Akhabhabhʉʉzya akhatɨ, “Uwutengaanu wʉbhe peeka nɨɨmwe!” ");
INSERT INTO mgq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhakhagandʉkha, bhakhoogopa nhaani, kʉnongwa ye bhakhasɨɨbhaga kʉtɨ bhamʉlola muzimu. ");
INSERT INTO mgq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ɨleelo, uYeesu akhabhabhʉʉzya akhatɨ, “Khooni khe mʉkweleela! Khooni khe mukusingaana mʉ mooyo giinyu! ");
INSERT INTO mgq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yeenyi ɨnyoobhe zyanɨ nɨ vɨnama vwanɨ, pe mʉmanye kʉtɨ neene nʉneene. Mʉmpalamansye mʉlole, kʉnongwa ye umuzimu atalɨ nʉ mʉbhɨlɨ, ɨleelo ɨne anza she mʉkʉlola, ɨndɨ nʉ mʉbhɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","UYeesu we alonga amazwi ganaago, akhabhalanga ɨnyoobhe nɨ vɨnama vwakwe. ");
INSERT INTO mgq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pe abhalandati bhaakwe bhakhaseshela nhaani, we kumo bhakuswiga bhakhafishila kʉsɨɨbha kʉtɨ pamu te nalyoli! We bhakʉseshela na kuswiga, uYeesu akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉlɨ ni shaakulya shimo ɨpa?” ");
INSERT INTO mgq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakhaamupa ɨshɨbeeza ishi nswi ɨnyooshe. ");
INSERT INTO mgq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Akhaposheela na kulya pɨlongolela yaabho. ");
INSERT INTO mgq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pe akhabhabhʉʉzya akhatɨ, “Ziniizi zye nábhabhuziizye akhabhalɨlo khe náamɨle peeka nɨɨmwe. Nábhabhuziizye kʉtɨ zyonti zye zisimbiilwe kʉ zyanɨ mʉ ndajɨzyo zya Moose, mu vitaabu ɨvwa bhakuwi, na mu shitaabu ɨsha Zabuuli, zɨkwanzɨwa zɨbhombeshe.” ");
INSERT INTO mgq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pe akhabhamanyɨzya kwɨ dala ɨlya kʉʉbhapa uwumanyi ʉwa kʉwaaganya uWusimbe wʉnʉʉwo uWufinjile, ");
INSERT INTO mgq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","akhabhabhʉʉzya akhatɨ, “Yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, uKilisiti akhayɨyɨmba, isiku ɨlya wʉtatʉ, akhayɨzyʉkha kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Khabhɨlɨ kwɨ taawa lyakwe, abhantʉ abhɨ nsɨ zyonti, kwandɨla ku Yelusaleemu, bhalʉmbɨɨlɨlwe kʉtɨ bhalaate imbiibhi zyabho, ɨnga ʉMʉlʉngʉ abhatʉʉyɨle. ");
INSERT INTO mgq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ziniizi zye zibhombeshile, ɨmwe mwe bhakeeti, mʉbhabhʉzyaje abhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tejeelezyi! Ishi ɨne ɨntɨmʉsonteelezye kukwinyu uMupepu uMufinjile we ʉTaata waanɨ álajile kʉtɨ akhayɨɨbhapa. Ishi, mwɨkhale mʉ nhaaya ɨnɨ, kufishila pe mʉkhayɨposheela amakha kufuma kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pɨlongolela, uYeesu akhafuma nabho mʉ nhaaya, akhabhala kʉmbalɨ kwe kwámɨle papɨɨpɨ na khakhaaya akha ku Besaniya. We bhaafikha paala, akhabhʉʉsya ɨnyoobhe zyakwe kʉmwanya, akhabhasaya. ");
INSERT INTO mgq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","We akʉjendeelela kʉbhasaya, akhapemukha khashe, pe akheegwa kʉbhala kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pe bhakhamupuuta, bhakhagalʉkha ku Yelusaleemu, kumo bhashiiye nhaani. ");
INSERT INTO mgq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Insiku zyonti bhakhɨkhalaga mwi linga ilyi Nyumba iMfinjile, bhakhamʉpaalaga ʉMʉlʉngʉ.");
INSERT INTO mgq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kʉwandɨlo we ɨnsɨ yɨshɨɨlɨ kʉpelwa, álɨɨpo iZwi. IZwi wʉnʉʉyo áamɨle peeka nʉ Mʉlʉngʉ. Woope iZwi wʉnʉʉyo áamɨle wʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kufuma kʉwandɨlo iZwi wʉnʉʉyo áamɨle peeka nʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ɄMʉlʉngʉ ávipelile ivintu vwonti kʉshɨlɨla kwi Zwi. Atápelile akhantʉ khokhonti sita wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","IZwi wʉnʉʉyo we áamɨle wandɨlo wa wuumi. Uwuumi wʉnʉʉwo wáamɨle lʉkhozyo kʉ bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ʉlʉkhozyo lʉnʉʉlwo lʉkʉkhozya mu khiisi, akhiisi khoope khatakhakhola kʉlʉtola. ");
INSERT INTO mgq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ɄMʉlʉngʉ ámusonteleziizye umuntu ʉmo we ɨtaawa lyakwe bhakhatɨnjɨ uYookhani. ");
INSERT INTO mgq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","UYookhani áyinzile kʉtɨ abhe mukeeti ɨnga afumwe uwukeeti kʉ zya lʉkhozyo lʉnʉʉlwo. Áyinzile ɨnga ku wukeeti waakwe abhantʉ bhonti bhamwɨtɨshe ʉlʉkhozyo. ");
INSERT INTO mgq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","UYookhani atáamɨle lʉkhozyo, ɨleelo áyinzile kufumwa uwukeeti kʉ zya lʉkhozyo lʉnʉʉlwo. ");
INSERT INTO mgq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wʉnʉʉyo we lʉkhozyo ʉlwa nalyoli, we áyinzile mʉ nsɨ kʉbhakhozezya abhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Izwi álɨɨpo mʉ nsɨ. ɄMʉlʉngʉ ápelile ɨnsɨ kwi Zwi wʉnʉʉyo, ɨleelo abhantʉ abha mʉ nsɨ bhatámwaganyiinye. ");
INSERT INTO mgq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Áyinzile kʉ bhantʉ bhe bhaakwe, ɨleelo bhatakhamʉposheela khaala. ");
INSERT INTO mgq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ɨleelo abhantʉ bhonti bhe bhámʉposheleeye ábhapiiye ʉwaamʉlo ʉwa kʉbha bhaana bha Mʉlʉngʉ, bhe bha bhaala bhe bhámwitishile. ");
INSERT INTO mgq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bhakhabha bhaana bha Mʉlʉngʉ bhe bhapapiilwe te kʉnongwa ya bhapaafi bhaabho, awe kʉ shɨgane sha mʉbhɨlɨ, awe kʉ shɨgane sha muntu, lyoli bhapapiilwe nʉ Mʉlʉngʉ wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Izwi wʉnʉʉyo akhabha muntu, akhɨɨkhala peeka nɨɨtwe. Tʉkhawʉlola uwumwamu waakwe, uwumwamu waakwe ʉweene we Mwana we alɨ mwene kwa Taata, khabhɨlɨ alɨ nu wiila nu wanalyoli ku winji. ");
INSERT INTO mgq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","UYookhani akhafumwaga uwukeeti kʉ zya wʉnʉʉyo, akhalonga kwi zi ɨlya kʉdandɨzya akhatɨ, “Wʉnʉʉnʉ we nábhabhuziizye intumi zyakwe kʉtɨ, ‘Akhayɨnza umuntu ʉmo we akhayɨlandata papaanɨ we mʉpɨtɨ kʉnshɨla ɨne, kʉnongwa ye álɨɨpo we ɨne ɨnshɨɨlɨ kʉpaapwa.’ ” ");
INSERT INTO mgq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kufumilana nu wukwilizu waakwe, ɨtwe twenti tʉposheleeye uwiila na kʉshɨla. ");
INSERT INTO mgq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwe kʉtɨ khalɨ ʉMʉlʉngʉ áfumwizye ɨndajɨzyo kwɨ dala lya Moose, ɨleelo akhabhalɨlo ɨkha alolesiizye uwiila nu wanalyoli waakwe kwɨ dala ɨlya Yeesu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Atalɨɨpo umuntu we amulolile ʉMʉlʉngʉ akhabhalɨlo khokhonti. ɄMwana waakwe mwene, we woope wʉ Mʉlʉngʉ, khabhɨlɨ alɨ peeka nʉ Mʉlʉngʉ, wʉnʉʉyo we atulanjile ʉMʉlʉngʉ she alɨ. ");
INSERT INTO mgq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Uwu we wukeeti wa Yookhani, akhabhalɨlo khe abhalongozi abha Bhayahuudi bhábhasonteleziizye abhapuutili na Bhalaawi kufuma mu Yelusaleemu kʉmʉbhʉzɨɨlɨzya uYookhani kʉtɨ, “Ɨwe we naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","UYookhani akhɨɨtɨkha sita kʉkhaana akhatɨ, “Ɨne te ne Kilisiti.” ");
INSERT INTO mgq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Pe ɨwe we naanu? Bhʉlɨ, we mukuwi uEliya?” UYookhani akhabhaamʉla akhatɨ, “Ɨne te ne Eliya.” Abheene bhakhamʉbhʉzɨɨlɨzya winza bhakhatɨ, “Bhʉlɨ, ɨwe we mukuwi we tʉkʉmʉgʉʉlɨla?” Akhatɨ, “Ndaali.” ");
INSERT INTO mgq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Pe tʉbhʉʉzye, ɨwe we naanu? Tʉbhʉʉzye ɨnga tʉbhale tʉbhabhʉʉzye bhaala bhe bhatusonteleziizye. Ɨwe ʉkʉyɨtekha kʉtɨ we naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","UYookhani akhabhaamʉla kʉlandatana na mazwi ge gasimbiilwe nu mukuwi ʉYeesaya, akhatɨ, “Ɨne ne muntu we akʉkhoola mu shilozu kʉtɨ, ‘Golosyaji ɨdala lye atɨshɨle ʉMwene.’” ");
INSERT INTO mgq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bhanaabho abhantʉ bhásonteleziizwe na Bhafalisaayi kwa Yookhani. ");
INSERT INTO mgq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ɨnga ɨwe te we Kilisiti, awe ɨwe te we mukuwi uEliya, awe te we mukuwi we tʉkʉmʉgʉʉlɨla, pe uwaajile kwoshi ʉwaamʉlo ʉwa kwozya abhantʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","UYookhani akhabhaamʉla akhatɨ, “Ɨne ɨnkʉbhoozya ku minzi, ɨleelo pakaasi yiinyu ayɨmɨlɨɨye we ɨmwe mutamumanyile. ");
INSERT INTO mgq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wʉnʉʉyo we atɨlandate papaanɨ, ɨntakhondeeye poope kʉsatʉla amakhobha gɨ ndaala zyakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Zyonti zɨnɨɨzyo zyábhombeshile mʉ nhaaya ɨya mu Besaniya, kwɨsyɨla ɨlya lwizi ʉlwa Yoolodani kwe uYookhani akhabhozyaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɨndaabhɨ yaakwe, uYookhani akhamʉlola uYeesu akwɨnza kʉkwakwe. Akhatɨ, “Yeenya, ɨNyaana yɨ Ngoole ya Mʉlʉngʉ ye yɨkwefwa imbiibhi ɨzya bhantʉ bhonti! ");
INSERT INTO mgq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wʉnʉʉnʉ we nábhabhuziizye intumi zyakwe kʉtɨ, ‘Akhayɨnza umuntu ʉmo we akhayɨlandata papaanɨ we mʉpɨtɨ kʉnshɨla ɨne, kʉnongwa ye álɨɨpo we ɨne ɨnshɨɨlɨ kʉpaapwa.’ ");
INSERT INTO mgq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Poope nɨɨne nʉneene intámumanyile, ɨleelo ininzile kʉbhoozya abhantʉ abha mu Isilaeli na minzi ɨnga bhamʉmanye.” ");
INSERT INTO mgq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pe uYookhani akhafumwa uwukeeti akhatɨ, “Námulolile uMupepu uMufinjile akwikha kufuma kʉmwanya ngatɨ nkʉnda, akhagwa pamwanya papaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ɨne intámumanyile, ɨleelo ʉMʉlʉngʉ we ansonteleziizye kwozya abhantʉ na minzi we ámbuziizye átɨlɨ, ‘Ɨnga wamʉlola umuntu we uMupepu kufuma kʉmwanya ayiikha pamwanya papaakwe, wʉnʉʉyo we akhayɨbhoozya nu Mupepu uMufinjile.’ ");
INSERT INTO mgq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ɨne nʉneene indolile, khabhɨlɨ inkufumwa uwukeeti kʉtɨ wʉnʉʉnʉ we Mwana wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɨndaabhɨ yaakwe, uYookhani áamɨle kukuula winza peeka na bhalandati bhaakwe bhamu bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pe akhamʉlola uYeesu akʉshɨla, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Yeenya, ɨNyaana yɨ Ngoole ya Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","We abhalandati bhaakwe bhabhɨlɨ bhɨmvwa uYookhani akʉlonga amazwi ganaago, bhakhaamʉla kʉmʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pe uYeesu akhashebhela, akhaaga bhakʉmʉlandata. Akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkwanza khooni?” Bhoope bhakhamwamʉla bhakhatɨ, “Mumanyizyi, ʉkwɨkhala kwoshi?” ");
INSERT INTO mgq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","UYeesu akhabhaamʉla akhatɨ, “Nzaaji, mʉtɨpalole pe ɨnkwɨkhala.” Pe bhakhamʉlandata na kʉpalola pe akhɨkhalaga. Bhakhalɨnda nawo isiku lɨnɨɨlyo, kwandɨla mʉ saala iyi shumi shalyabheela. ");
INSERT INTO mgq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ɄAndeleeya, ʉkhambakʉ wa Siimoni Peeteli, áamɨle weeka mu bhalandati bhabhɨlɨ bhe bhímvwizye we uYookhani akʉlonga, bhakhamʉlandata uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ɄAndeleeya akhamwanza suuti ʉkhambakʉ waakwe uSiimoni. Akhamʉbhʉʉzya akhatɨ, “Twamʉlola uMeesiya!” kwe kʉtɨ Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pe ʉAndeleeya akhamʉtwala uSiimoni kwa Yeesu. UYeesu akhamwenya uSiimoni, akhatɨ, “Ɨwe we Siimoni ʉmwana wa Yookhani. Kufuma ishi, ɨtaawa lyakho ʉtɨbhe we Keefa,” kwe kʉtɨ Peeteli awe ɨLyalaawe. ");
INSERT INTO mgq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɨndaabhɨ yaakwe, uYeesu akhaamʉla kʉbhala mʉ nsɨ ɨya mʉ Galɨlaaya. Akhamwaga uFilipo, akhamʉbhʉʉzya akhatɨ, “Ndandataje.” ");
INSERT INTO mgq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","UFilipo áamɨle mʉkhaaya wa mʉ nhaaya ɨya mu Betisayida ye ʉAndeleeya nu Peeteli bhakhɨkhalaga. ");
INSERT INTO mgq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","UFilipo woope akhamwaga uNasanaeli, akhamʉbhʉʉzya akhatɨ, “Twamʉlola umuntu we ʉMoose ásimbile intumi zyakwe mu Shitaabu ɨshɨ ndajɨzyo na we abhakuwi bhásimbile intumi zyakwe. Umuntu wʉnʉʉyo wu Yeesu ʉwa mʉ nhaaya ɨya mu Naazaleti, ʉmwana wa Yoosefu.” ");
INSERT INTO mgq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ɨleelo uNasanaeli akhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, akhantʉ akhinza khangakhola kufuma mu Naazaleti?” UFilipo akhamwamʉla akhatɨ, “Nzaaga ʉyɨlolele wʉneewe.” ");
INSERT INTO mgq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","We uYeesu amʉlola uNasanaeli akwɨnza kʉkwakwe, akhabhabhʉʉzya abhalandati bhaakwe intumi zya Nasanaeli akhatɨ, “Yeenya, umuntu wʉnʉʉyo we akwɨnza, Mwisilaeli ʉwa nalyoli we atalɨ nɨ lenga mukaasi yaakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","UNasanaeli akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Waamanya bhʉlɨɨbhʉlɨ ɨne?” UYeesu akhamwamʉla akhatɨ, “We wáamɨle pɨɨkholo pi kwi ɨlya mutiini, we uFilipo ashɨɨlɨ kʉkʉbhɨlɨshɨla nákulolile.” ");
INSERT INTO mgq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","UNasanaeli akhamwamʉla akhatɨ, “We Mumanyizyi, ɨwe we Mwana wa Mʉlʉngʉ! Ɨwe we Mwene ʉwɨ nsɨ ɨya Isilaeli!” ");
INSERT INTO mgq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","UYeesu akhamwamʉla akhatɨ, “Bhʉlɨ, ʉkwɨtɨkha kʉnongwa ye nakʉbhʉʉzya kʉtɨ nákulolile we ʉyɨkhaaye pɨɨkholo pi kwi ɨlya mutiini? Ʉtɨgalole amapɨtɨ nhaani kʉshɨla ganaaga! ");
INSERT INTO mgq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nalyoli ɨnkʉbhabhʉʉzya, khakhayɨnza akhabhalɨlo khe mʉkhayɨlola kʉmwanya kwigukha, abhakhabhɨzya bha Mʉlʉngʉ bhakhayɨzʉbhaga na kwikha pamwanya pa mwa Mwana wa Muntu.” ");
INSERT INTO mgq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pi siku ɨlya wʉtatʉ, páamɨle ni shikulukulu ɨsha weeji mʉ nhaaya ɨya mʉ Kaana, mʉ nsɨ ɨya Galɨlaaya. Woope unyina wa Yeesu álɨɨpo. ");
INSERT INTO mgq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","UYeesu na bhalandati bhaakwe bhoope bhálanjiliilwe ku weeji wʉnʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","We idivaayi yaasila, pe unyina waakwe akhamʉbhʉʉzya uYeesu akhatɨ, “Idivaayi yabhasilila.” ");
INSERT INTO mgq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","UYeesu akhamwamʉla akhatɨ, “Maayɨ ʉtambʉzyaje ɨlya kʉbhomba, akhabhalɨlo akha kʉbhomba ɨmbombo yaanɨ khashɨɨlɨ kufikha.” ");
INSERT INTO mgq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pe unyina waakwe akhabhabhʉʉzya abhabhombi akhatɨ, “Lyolyonti lye atɨbhabhʉʉzye, mʉbhombe.” ");
INSERT INTO mgq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Papaala, páamɨle nɨ nsaaya ʉmʉtanda zye zyágombiilwe kʉ mawe. Ɨnsaaya zɨnɨɨzyo bhakhabhɨshɨlaga aminzi aga kuyizelufwa kʉlandatana na minho ga Bhayahuudi. Ɨnsaaya yeeka yikhizulaga kwandɨla iliita amashumi naane paka iliita imia yeeka na mashumi gabhɨlɨ (120). ");
INSERT INTO mgq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","UYeesu akhabhabhʉʉzya abhabhombi bhaala akhatɨ, “Yiizuzyi aminzi mʉ nsaaya zɨnɨɨzyo.” Bhoope bhakhiizuzya aminzi mʉ nsaaya ziila paka pamwanya. ");
INSERT INTO mgq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Tapi aminzi, mʉmʉtwalɨle ʉmʉpɨtɨ ʉwa shikulukulu ɨsha weeji.” Bhoope bhakhatwala. ");
INSERT INTO mgq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ʉmʉpɨtɨ wʉnʉʉyo ʉwa weeji akhalɨnga aminzi gaala ge gagalunhiine kʉbha divaayi. Ʉweene atámanyile kwe idivaayi yiila yáfumile, ɨleelo abhabhombi bhe bhátapile aminzi bhámanyile. Pe akhamʉbhɨlɨshɨla ʉwa weeji pambalɨ, ");
INSERT INTO mgq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akhamʉbhʉʉzya akhatɨ, “Umuntu wowonti akʉlɨngaanya suuti idivaayi inyinza, ɨleelo we abhantʉ bhamwela na kʉkwɨla, kʉwʉmalɨlɨshɨlo akʉlɨngaanya idivaayi ye te nyinza. Ɨleelo ɨwe ʉlɨ she usenguuye idivaayi inyinza nhaani paka kʉwʉmalɨlɨshɨlo.” ");
INSERT INTO mgq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɨshɨlolesyo ishi she uYeesu ábhombile she sháamɨle sha kwanda. Ábhombile mʉ nhaaya ɨya mʉ Kaana, mʉ nsɨ ɨya mʉ Galɨlaaya. Kwɨ dala liniili uYeesu álolesiizye uwumwamu waakwe. Kʉnongwa yɨnɨɨyo, abhalandati bhaakwe bhakhamwɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","We ishikulukulu ɨsha weeji shaasila, uYeesu akhiikha mʉ nhaaya ɨya mu Kapelenaumu nu nyina waakwe, abhansi bhaakwe, peeka na bhalandati bhaakwe. Bhakhɨɨkhala kʉnʉʉkwo insiku nyishe. ");
INSERT INTO mgq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","We akhabhalɨlo akhi shikulukulu ɨshɨ Pasaaka ɨya Bhayahuudi khapalamɨla, uYeesu akhazʉbha ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pe akhinjila mwi linga ilyi Nyumba iMfinjile. Mʉnʉʉmwo akhabhaaga abhantʉ bhakʉkazya ɨngʼombe, ɨngoole, nɨ nkʉnda. Khabhɨlɨ bhamu bhɨkhaaye pa vintalati vwabho bhakhavunzanyaaga ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","UYeesu we azɨlola zɨnɨɨzyo, akhagomba ɨsambogo ɨya lukusa, akhabhabhɨnga bhonti bhe bhakʉkazya bhafume mwi linga ilyi Nyumba iMfinjile peeka nɨ ngʼombe nɨ ngoole. Akhabenulanya ivintalati ɨvwa bhe bhakhavunzanyaaga ɨnhela na kwitanya ɨnhela zyabho. ");
INSERT INTO mgq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pe uYeesu akhabhabhʉʉzya bhaala bhe bhakhakazyaga ɨnkʉnda akhatɨ, “Yeefwi ɨnkʉnda izi ɨpa! Mʉtayɨbhɨɨkhaje inyumba ya Taata waanɨ kʉbha mʉnaalo.” ");
INSERT INTO mgq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abhalandati bhaakwe we bhɨmvwa zɨnɨɨzyo, bhakhakʉmbʉkha amazwi ge gasimbiilwe mu Wusimbe uWufinjile kʉtɨ, “Ʉlʉgano lwanɨ ku nyumba yaakho lʉtɨngoje.” ");
INSERT INTO mgq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pe abhalongozi abha Bhayahuudi bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Ʉtɨbhombe shɨlolesyo bhʉlɨ kʉlolesya kʉtɨ ʉlɨ nʉ waamʉlo ʉwa kʉbhomba ganaaga?” ");
INSERT INTO mgq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","UYeesu akhabhaamʉla akhatɨ, “Pongolanyi iNyumba iMfinjile ɨnɨ, nɨɨne ɨntɨyɨzenje ku nsiku zɨtatʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pe abhalongozi bhakhamwamʉla bhakhatɨ, “INyumba iMfinjile ɨnɨ yázenjiilwe kʉ manha amashumi gani nʉ mʉtanda. Ɨwe ʉkʉtɨ ʉtɨyɨzenje ku nsiku zɨtatʉ bhʉʉlo anza bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ɨleelo ʉweene akhalongaga kʉ zya mʉbhɨlɨ waakwe kʉtɨ Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pe we uYeesu azyʉkha kufuma kʉ bhafwe, abhalandati bhaakwe bhakhakʉmbʉkha kʉtɨ álonjile amazwi ganaago. Pe bhakhawɨɨtɨkha uWusimbe uWufinjile na mazwi ge uYeesu álonjile. ");
INSERT INTO mgq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","We uYeesu alɨ mu Yelusaleemu mu shikulukulu ɨshɨ Pasaaka, abhantʉ abhinji bhakhamwɨtɨkha kʉnongwa ye bhakhavɨlola ɨvɨlolesyo vwe ábhombile. ");
INSERT INTO mgq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ɨleelo uYeesu atáamɨle nʉ lwɨtɨkho nabho kʉnongwa ye ázimanyile zye zyámɨle mʉ mooyo ga bhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Khabhɨlɨ atakhanzaga umuntu wowonti ʉwa kʉmʉpanjɨla zye abhantʉ bhakhasɨɨbhaga kʉnongwa ye ázimanyile zyonti zye zyámɨle mʉ mooyo ga bhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwámɨle nʉ mʉpɨtɨ weeka ʉwa Bhayahuudi ʉwa shɨpʉga sha Bhafalisaayi, ɨtaawa lyakwe bhakhatɨnjɨ uNikodeemu. ");
INSERT INTO mgq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isiku limo, uNikodeemu akhabhala kwa Yeesu shawusiku, akhamʉbhʉʉzya akhatɨ, “We Mumanyizyi, tumanyile kʉtɨ ɨwe we mumanyizyi we ʉMʉlʉngʉ akusonteleziizye. Kʉnongwa ye atalɨɨpo umuntu wowonti we angakhola kʉbhomba ɨvɨlolesyo vwe ʉkʉbhomba, bhanje ʉMʉlʉngʉ atalɨ peeka nawo.” ");
INSERT INTO mgq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","UYeesu akhamwamʉla akhatɨ, “Nalyoli ɨnkʉkʉbhʉʉzya, umuntu ɨnga atapapiilwe akha wʉbhɨlɨ, atangakhola kʉwʉlola ʉwʉmwene wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","UNikodeemu akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Umuntu umugoosi angakhola bhʉlɨɨbhʉlɨ kʉpaapwa akha wʉbhɨlɨ? Atangakhola kwinjila mʉ lwanda lwa nyina waakwe ɨnga apaapwe winza!” ");
INSERT INTO mgq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","UYeesu akhamwamʉla akhatɨ, “Nalyoli ɨnkʉkʉbhʉʉzya, atalɨɨpo umuntu we angakhola kwinjila mʉ wʉmwene wa Mʉlʉngʉ ɨnga atapapiilwe ku minzi na kwa Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Umuntu akʉpaapwa nʉ mʉbhɨlɨ kufuma ku bhapaafi bhaakwe, ɨleelo akʉpaapwa nu Mupepu uMufinjile ɨnga aposheele uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Utaswigaje we ɨnkʉkʉbhʉʉzya kʉtɨ, ‘Ʉkwanzɨwa ʉpaapwe akha wʉbhɨlɨ.’ ");
INSERT INTO mgq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Impepu yikuvugula kʉbhala kwonti kwe yiyiganile. Ʉngakhola kwɨmvwa we yikuvugula, ɨleelo ʉtakʉmanya kwe yikufuma na kwe yɨkʉbhala. Ziniizi she zɨlɨ na kwa muntu wowonti we apapiilwe kwa Mupepu uMufinjile.” ");
INSERT INTO mgq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","UNikodeemu akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Ziniizi zɨngabhombekha bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","UYeesu akhamwamʉla akhatɨ, “Ɨwe we mumanyizyi ʉmʉpɨtɨ ʉwa Bhaisilaeli, utazimanyile zyonti ziniizi? ");
INSERT INTO mgq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nalyoli ɨnkʉkʉbhʉʉzya, ɨtwe tʉkʉlonga zye tuzimanyile na kufumwa uwukeeti zye tuzilolile, ɨleelo ɨmwe mʉtakwɨtɨkha zye tʉkʉbhabhʉʉzya. ");
INSERT INTO mgq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Imbabhuziizye ɨzya mʉ nsɨ, nɨɨmwe mʉtakʉnɨɨtɨkha. Mʉngakhola bhʉlɨɨbhʉlɨ kwɨtɨkha ɨnga ɨnkʉbhabhʉʉzya ɨzya kʉmwanya? ");
INSERT INTO mgq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atalɨɨpo umuntu we abhalile lumo kʉmwanya, lyoli ʉMwana wa Muntu we ayinzile kufuma kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Anza she ʉMoose ábhusiizye ishifwani shɨ njokha ɨyɨ shaaba mu shilozu, shɨnɨɨsho woope ʉMwana wa Muntu bhakhayɨmʉbhʉʉsya pa shɨkhobhenhanyo, ");
INSERT INTO mgq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ɨnga umuntu wowonti we akʉmwɨtɨkha abhe nu wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“ɄMʉlʉngʉ ábhaganile abhantʉ bhonti mʉ nsɨ, ye nongwa akhamʉsonteelezya ʉMwana waakwe weeka mwene kwɨnza mʉ nsɨ umu, ɨnga umuntu wowonti we amwɨtɨkha ʉweene, atateegaje, lyoli abhe nu wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ɄMʉlʉngʉ atámusonteleziizye ʉMwana waakwe kʉbhalonga abhantʉ, lyoli kʉbhapokha. ");
INSERT INTO mgq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Wowonti we akʉmwɨtɨkha ʉweene, atakʉlongwa, ɨleelo we atakʉmwɨtɨkha alongiilwe kusilile, kʉnongwa ye atamwitishile ʉMwana weeka mwene ʉwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kʉlongwa kwe ku kuuku: kʉtɨ, ʉlʉkhozyo lwinzile mʉ nsɨ, ɨleelo abhantʉ bhakhayɨgana akhiisi kʉshɨla ʉlʉkhozyo, kʉnongwa ye ɨmbombo zyabho zyámɨle mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abhantʉ bhonti bhe bhakʉbhomba imbiibhi bhakuluviitilwa ʉlʉkhozyo, khabhɨlɨ bhatakwanza kwɨnza kʉ lʉkhozyo, ɨnga ɨmbombo zyabho imbiibhi zɨtakhasakʉlwe apazelu. ");
INSERT INTO mgq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɨleelo bhaala bhe bhakʉbhomba uwanalyoli, bhakwɨnza kʉ lʉkhozyo ɨnga yɨloleshe apazelu kʉtɨ ɨmbombo zyabho zibhombeshile kʉ makha ga Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","We akhabhalɨlo khaashɨla khashe, uYeesu na bhalandati bhaakwe bhakhabhala mʉ nsɨ ɨya Yudeeya. Bhakhɨɨkhala kʉʉkwo kʉ khabhalɨlo, uYeesu akhabhozyaga abhantʉ. ");
INSERT INTO mgq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","UYookhani uMwozyi woope akhabhozyaga abhantʉ mʉ nhaaya ɨya mu Ayinooni papɨɨpɨ nɨ nhaaya ɨya mu Saleemu, kʉnongwa ye kwámɨle na minzi aminji. Abhantʉ bhakhabhala kʉkwakwe ɨnga abhoozye. ");
INSERT INTO mgq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Akhabhalɨlo khanaakho uYookhani uMwozyi áshɨɨlɨ kʉkʉngwa mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Isiku limo, abhalandati bha Yookhani uMwozyi bhakhanda kʉdalɨnhana nu Muyahuudi weeka kʉ zya minho aga kʉgeeza. ");
INSERT INTO mgq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe bhakhabhala kwa Yookhani uMwozyi, bhakhamʉbhʉʉzya bhakhatɨ, “We Mumanyizyi, umuntu ʉla we aamɨle peeka nɨɨwe kwɨsyɨla ɨlya lwizi ʉlwa Yoolodani, we waatʉpanjɨɨye intumi zyakwe, ishi akwozya, abhantʉ bhonti bhakʉbhala kʉkwakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","UYookhani akhabhaamʉla akhatɨ, “Umuntu atangakhola kʉbha na khantʉ ɨnga ʉMʉlʉngʉ atamupiiye. ");
INSERT INTO mgq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɨmwe mʉneemwe mwe bhakeeti bhaanɨ kʉtɨ, nálonjile nátɨlɨ, ‘Ɨne te ne Kilisiti, lyoli ʉMʉlʉngʉ ansonteleziizye kʉtɨ ɨmʉlongolele.’ ");
INSERT INTO mgq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ʉmʉlɨndʉ we akwegwa wa mʉsakhaala we akʉmwega. Ɨleelo umanyani wa muntu we akwega, we akwɨmɨɨlɨla papɨɨpɨ nawo na kʉmʉtejeelezya, akʉseshela nhaani we akwɨmvwa izi lya we akwega. Shɨnɨɨsho she ʉlʉseshelo lwanɨ lwakwɨla. ");
INSERT INTO mgq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yɨkwanzɨwa uYeesu abhe mʉpɨtɨ nhaani, lyoli ɨne ɨmbe ne munsi nhaani.” ");
INSERT INTO mgq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ʉweene we akwɨnza kufuma kʉmwanya mʉpɨtɨ kʉshɨla bhonti, ɨleelo we akufuma mʉ nsɨ wa mʉ nsɨ, khabhɨlɨ akʉlonga ɨzya mʉ nsɨ. Ɨleelo we akwɨnza kufuma kʉmwanya mʉpɨtɨ kʉshɨla bhonti. ");
INSERT INTO mgq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ʉweene akʉlonga zye azilolile na kʉzyɨmvwa kufuma kwa Mʉlʉngʉ, ɨleelo atalɨɨpo umuntu we akwɨtɨkha zye akʉlonga. ");
INSERT INTO mgq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɨleelo umuntu wowonti we akwɨtɨkha intumi zyakwe akusimishizya kʉtɨ ʉMʉlʉngʉ wa nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kʉnongwa ye ʉweene we ʉMʉlʉngʉ amusonteleziizye, akʉlonga amazwi ga Mʉlʉngʉ, kʉnongwa ye ʉMʉlʉngʉ akuumupa uMupepu waakwe uMufinjile sita shipimilo. ");
INSERT INTO mgq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ɄTaata amuganile ʉMwana waakwe, khabhɨlɨ amupiiye ʉwaamʉlo ʉwa kʉtabhaala ivintu vwonti. ");
INSERT INTO mgq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","We akʉmwɨtɨkha ʉMwana, alɨ nu wuumi ʉwa wiila na wiila. Ɨleelo we atakʉmwɨtɨkha ʉMwana, atalɨ nu wuumi ʉwa wiila na wiila, lyoli ʉmʉlakha wa Mʉlʉngʉ wʉkʉjendeelela kʉmʉgʉʉlɨla. ");
INSERT INTO mgq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pe aBhafalisaayi bhakhɨmvwa kʉtɨ uYeesu akʉbhoozya na kʉbhaaga abhalandati abhinji kʉshɨla uYookhani uMwozyi. ");
INSERT INTO mgq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Uwanalyoli kʉ kʉtɨ te wu Yeesu we akhabhozyaga abhantʉ, lyoli bhalandati bhaakwe bhe bhakhozyaga. ");
INSERT INTO mgq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","We uYeesu aamanya kʉtɨ intumi zɨnɨɨzyo zyasaata, akhasogola mʉ nsɨ ɨya mu Yudeeya, akhagalʉkha winza mʉ nsɨ ɨya mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mʉ khabhalɨlo khanaakho akhanzɨwaaga kʉshɨlɨla mʉ nsɨ ɨya mu Samaliya. ");
INSERT INTO mgq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pe akhafikha mu Samaliya, mʉ nhaaya ye bhakhatɨnjɨ iSikaali. Ɨnhaaya yɨnɨɨyo yáamɨle papɨɨpɨ ni shiizi she ʉYaakobo ámupiiye ʉmwana waakwe, uYoosefu. ");
INSERT INTO mgq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Panaapo páamɨle ni shindingwi ɨsha Yaakobo. We ɨzʉbha lyafikha pi twe, uYeesu akhɨɨkhala pambalɨ pa shindingwi shɨnɨɨsho, kʉnongwa ɨya wulisu ʉwa kʉshʉʉla akhabhalɨlo akhatali. ");
INSERT INTO mgq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pe ʉmwantanda ʉmo uMusamaliya akhɨnza kʉtapa aminzi. UYeesu akhamʉbhʉʉzya akhatɨ, “Ɨnkʉlaabha aminzi ɨmwele.” ");
INSERT INTO mgq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kʉ khabhalɨlo khanaakho abhalandati bhaakwe bhábhalile mʉ nhaaya kʉkala ishaakulya. ");
INSERT INTO mgq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pe ʉmwantanda ʉla akhamwamʉla uYeesu akhatɨ, “Ɨwe we Muyahuudi, ɨne ne Musamaliya! Ʉngalaabha aminzi bhʉlɨɨbhʉlɨ kʉkwanɨ?” ABhayahuudi bhatakhanzaga kwɨmvwana na Bhasamaliya. ");
INSERT INTO mgq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","UYeesu akhamwamʉla akhatɨ, “Bhanje ʉmanyaje khe ʉMʉlʉngʉ akwanza kuukupa na kʉtɨ wu naanu wʉnʉʉnʉ we akʉkʉlaabha aminzi aga kʉmwela, ɨwe nhanɨ wamʉlaabha, woope angaakupa aminzi aga wuumi.” ");
INSERT INTO mgq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ʉmwantanda ʉla akhamwamʉla uYeesu akhatɨ, “We mwene, ɨwe ʉtalɨ nɨ shɨlɨɨlo ɨsha kʉtapɨla aminzi, khabhɨlɨ ishindingwi ishi shibhiiye nhaani, ʉtɨgaaje kwoshi aminzi aga wuumi? ");
INSERT INTO mgq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ʉmaama wɨɨtʉ ʉYaakobo we átupiiye ishindingwi ishi, she ʉweene na bhaana bhaakwe peeka nɨ vwʉma vwakwe bhakhatapaga aminzi. Bhʉlɨ, ʉkʉyɨlola kʉtɨ ɨwe we mʉpɨtɨ kʉmʉshɨla ʉweene?” ");
INSERT INTO mgq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Pe uYeesu akhamwamʉla akhatɨ, “Umuntu wowonti we akʉmwela aminzi ge gakufuma mu shindingwi ishi, akwɨmvwa ɨshʉʉmɨlwa winza. ");
INSERT INTO mgq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ɨleelo umuntu wowonti we akʉmwela aminzi ge ɨne inkuumupa, te akhɨmvwe ɨshʉʉmɨlwa naalumo. Aminzi ge ɨne inkuumupa, gakhayɨbha ngatɨ shindingwi ɨsha minzi mukaasi yaakwe she shɨtakwʉma naalumo na kuumupa uwuumi ʉwa wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ʉmwantanda ʉla akhamʉlamba uYeesu akhatɨ, “We mwene, ɨnkʉkʉlaabha umpe aminzi ganaago ɨnga ɨntɨmvwaje ɨshʉʉmɨlwa winza, na kʉtɨ ɨndeshe kwɨnza kʉtapa aminzi winza ɨpa!” ");
INSERT INTO mgq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","UYeesu akhamwamʉla akhatɨ, “Bhalaga ʉmʉbhɨlɨshɨle ʉmʉlʉme waakho, ʉyɨnze nawo ɨpa.” ");
INSERT INTO mgq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ʉweene akhamwamʉla akhatɨ, “Ɨne ɨntalɨ nʉ mʉlʉme.” UYeesu akhamwamʉla akhatɨ, “Walonga ɨzya nalyoli kʉtɨ ʉtalɨ nʉ mʉlʉme! ");
INSERT INTO mgq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kʉnongwa ye weejeliilwe na bhasakhaala bhasaanʉ, woope we ʉkwɨkhala nawo ishi, te mʉlʉme waakho. Ɨpo walonga uwanalyoli.” ");
INSERT INTO mgq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ʉmwantanda ʉla akhamwamʉla uYeesu akhatɨ, “We mwene, ɨnkʉlola kʉtɨ ɨwe we mukuwi. ");
INSERT INTO mgq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Abhamaama bhɨɨtʉ bhakhamupuutaga ʉMʉlʉngʉ mwɨ gamba ili ɨlya Geliizimu, ɨleelo ɨmwe muBhayahuudi mʉkʉtɨ tʉkwanzɨwa tʉbhalaje kumupuuta ʉMʉlʉngʉ mu Yelusaleemu.” ");
INSERT INTO mgq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","UYeesu akhamwamʉla akhatɨ, “We mwantanda, nɨɨtɨshe, akhabhalɨlo khakwɨnza khe te mukhamupuute ʉTaata mwɨ gamba ili awe mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɨmwe muBhasamaliya mukumupuuta we mutamumanyile, ɨtwe tuBhayahuudi tukumupuuta ʉMʉlʉngʉ we tumumanyile, kʉnongwa ye uwuposhi wukufuma ku Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ɨleelo akhabhalɨlo khakwɨnza, khabhɨlɨ khafishile khe abhantʉ bhe bhakumupuuta ʉMʉlʉngʉ nalyoli bhakhayimupuuta kʉ mwoyo nu wanalyoli. Kwe kʉtɨ ʉMʉlʉngʉ akwanza abhantʉ bhe bhakumupuuta kwɨ dala lɨnɨɨlyo. ");
INSERT INTO mgq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ɄMʉlʉngʉ Mupepu, atalɨ nʉ mʉbhɨlɨ ngatɨ wa bhantʉ. Abhantʉ bhe bhakumupuuta, bhakhondeeye kʉtɨ bhamupuutaje kʉ mwoyo nu wanalyoli.” ");
INSERT INTO mgq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ʉmwantanda ʉla akhamwamʉla uYeesu akhatɨ, “Imanyile kʉtɨ uMeesiya we bhakʉtɨ uKilisiti akwɨnza. Khabhɨlɨ imanyile kʉtɨ ɨnga ayɨnza, akhayɨtʉbhʉʉzya zyonti kʉ zya Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","UYeesu akhamwamʉla akhatɨ, “Ɨne ne ɨnkʉlonga nɨɨwe, ne ne Meesiya.” ");
INSERT INTO mgq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mʉ khabhalɨlo khanaakho, abhalandati bhaakwe bhakhagalʉkha, bhakhaswiga nhaani we bhamwaga uYeesu akʉlonga nʉ mwantanda. Ɨleelo atálɨɨpo umulandati we akhamʉbhʉzɨɨlɨzya uYeesu kʉtɨ, “Ʉkwanza khooni kʉkwakwe?” Awe kʉtɨ, “Khooni khe ʉkʉlonga nawo?” ");
INSERT INTO mgq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ʉmwantanda ʉla akhayɨlekha ɨnsonta yaakwe, akhabhala mʉ nhaaya, akhabhabhʉʉzya abhantʉ akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Saalɨ mʉmʉlole umuntu we ambuziizye zyonti zye nazɨbhombaga! Bhʉlɨ, pamu umuntu wʉnʉʉyo angabha wu Kilisiti?” ");
INSERT INTO mgq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pe abhantʉ bhakhagʉʉkha, kufuma mʉ nhaaya kʉbhala kwe uYeesu áamɨle. ");
INSERT INTO mgq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mʉ khabhalɨlo khanaakho, abhalandati bhaakwe bhakhamʉlambaga uYeesu bhakhatɨnjɨ, “We Mumanyizyi, ilya ishaakulya shishe.” ");
INSERT INTO mgq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ɨleelo ʉweene akhabhaamʉla akhatɨ, “Ɨne ɨndɨ ni shaakulya she ɨmwe mutashimanyile.” ");
INSERT INTO mgq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pe abhalandati bhaakwe bhakhanda kʉbhʉzɨlɨzanya bhakhatɨ, “Bhʉlɨ, alɨɨpo umuntu we amʉleteeye ishaakulya?” ");
INSERT INTO mgq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","UYeesu akhabhaamʉla akhatɨ, “Ishaakulya shaanɨ kʉ kʉbhomba ɨshɨgane sha Mʉlʉngʉ, na kʉyɨkwɨlɨzya ɨmbombo ye ánsonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɨmwe mʉkʉlonga kʉtɨ, ‘Gasyalile ameezi gani bhʉʉlo kufishila akhabhalɨlo akhi mvuno.’ Ɨleelo ɨne ɨnkʉbhabhʉʉzya kʉtɨ, yenyaaji mʉlole ivwizi, she ɨvɨyabho vigomile, vɨkwɨlɨɨye kʉsezya. ");
INSERT INTO mgq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","We akʉsezya akʉposheela kʉ mbombo yaakwe, woope akʉbhʉngaanya ɨvɨyabho kʉnongwa ɨya wuumi ʉwa wiila na wiila. Pe we akʉwaala na we akʉsezya, bhonti bhaseshele peeka. ");
INSERT INTO mgq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kʉnongwa yɨnɨɨyo, ɨndonjelo ɨnɨ ya nalyoli, ‘Umuntu weeka akʉwaala imbeyu nʉ wamwabho akʉsezya.’ ");
INSERT INTO mgq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nábhasonteleziizye kʉsezya ɨvɨyabho vwe mutawaalile. Bhamu bhábhombile ɨmbombo ingomu. Ɨleelo nɨɨmwe mʉkʉseshela kufumilana nɨ mbombo yaabho.” ");
INSERT INTO mgq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ABhasamaliya abhinji kufuma mʉ nhaaya yiila ɨya Sikaali bhakhamwɨtɨkha uYeesu kʉnongwa ya wukeeti wa mwantanda ʉla we akhabhabhʉʉzya kʉtɨ, “Umuntu ʉnʉ ambuziizye zyonti zye nazɨbhombaga.” ");
INSERT INTO mgq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pe aBhasamaliya bhakhabhala kwa Yeesu, bhakhamʉlaabha kʉtɨ ayɨkhalaje kʉkwabho. Woope akhɨɨkhala kʉʉkwo insiku zɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abhantʉ abhinji nhaani bhakhamwɨtɨkha kʉnongwa ya mazwi gaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhakhamʉbhʉʉzya ʉmwantanda ʉla bhakhatɨ, “Ishi, tʉkwɨtɨkha te kʉnongwa ya mazwi gaakho meene, lyoli kʉnongwa ye twɨmvwa tʉneetwe. Twamanya kʉtɨ nalyoli ʉnʉ we Muposhi wa bhantʉ bhonti.” ");
INSERT INTO mgq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","We insiku zɨbhɨlɨ zyashɨla, uYeesu na bhalandati bhaakwe bhakhasogola mʉ nhaaya ɨya mu Sikaali na kʉbhala mʉ nsɨ ɨya mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","UYeesu wʉʉyo álonjile kʉtɨ umukuwi abhantʉ abha mʉ nhaaya yaakwe bhatakumushindikha. ");
INSERT INTO mgq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","We aafikha mʉ Galɨlaaya, aBhagalɨlaaya abhinji bhakhamʉposheela. Abhantʉ bhanaabho bhoope bhábhalile ku shikulukulu ɨshɨ Pasaaka ku Yelusaleemu, bházilolile zye uYeesu ábhombile. ");
INSERT INTO mgq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pe uYeesu akhabhala winza mʉ nhaaya ɨya mʉ Kaana ye yɨlɨ mʉ Galɨlaaya. Mʉ nhaaya yɨnɨɨyo mwe ágalulanyiinye aminzi kʉbha divaayi. Kʉnʉʉkwo álɨɨpo umulongozi weeka uwi silikaali we akhafumaga mʉ nhaaya ɨya mu Kapelenaumu we ʉmwana waakwe ʉmʉsakhaala áamɨle mubhinu. ");
INSERT INTO mgq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Umulongozi wʉnʉʉyo we ayɨmvwa kʉtɨ uYeesu ayinzile winza mʉ Galɨlaaya kufuma mʉ nsɨ ɨya Yudeeya, akhabhala kwa Yeesu na kʉmʉlaabha kʉtɨ abhale kʉmʉponɨa ʉmwana waakwe we abhinile, ápalamɨɨye kufwa. ");
INSERT INTO mgq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","UYeesu akhamʉbhʉʉzya akhatɨ, “Mʉbhantʉ ɨmwe, ɨnga mʉtaalola ɨvɨlolesyo na mayele mʉtangakhola kwɨtɨkha!” ");
INSERT INTO mgq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Umulongozi ʉla akhamwamʉla akhatɨ, “We mwene, ɨnkʉkʉlaabha, saalɨ she ʉmwana waanɨ ashɨɨlɨ kufwa.” ");
INSERT INTO mgq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","UYeesu akhamwamʉla akhatɨ, “Bhalaga kʉkhaaya, ʉmwana waakho aponile.” Umulongozi ʉla akhagɨɨtɨkha amazwi ge uYeesu ámubhuziizye, pe akhasogola kʉbhala kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","We umulongozi ʉla alɨ mwɨ dala, akhakhomaana na bhabhombi bhaakwe. Bhakhamʉbhʉʉzya bhakhatɨ, “Ʉmwana waakho aponile.” ");
INSERT INTO mgq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pe akhabhabhʉzɨɨlɨzya akhatɨ, “Aponile kwandɨla liino?” Bhakhamwamʉla bhakhatɨ, “Aponile kwandɨla mazʉbha shamʉsanya mʉ saa saba.” ");
INSERT INTO mgq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pe uyise wa mwana ʉla akhamanya kʉtɨ aaponile akhabhalɨlo khakhaala khe uYeesu ámubhuziizye kʉtɨ, “Ʉmwana waakho aponile.” Pe umulongozi ʉla peeka na bha mu nyumba yaakwe bhonti bhakhamwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ishi sháamɨle shɨlolesyo sha wʉbhɨlɨ she uYeesu ábhombile mʉ nsɨ ɨya kʉ Galɨlaaya we aafuma mʉ nsɨ ɨya mu Yudeeya. ");
INSERT INTO mgq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","We zɨnɨɨzyo zyashɨla, kwámɨle ni shikulukulu ɨsha Bhayahuudi, woope uYeesu akhabhala mʉ nhaaya ɨya mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mʉ nhaaya ɨya mu Yelusaleemu, papɨɨpɨ nʉ mʉlyango we bhakhatɨnjɨ, “ɄMʉlyango ʉwɨ Ngoole,” páamɨle nɨ bwabho lye ɨtaawa lyakwe mʉ ndongo yaabho bhakhatɨnjɨ iBetizaasa. Ɨbwabho lɨnɨɨlyo lyázyunguliilwe ni nyumba ɨzya lʉbhʉngaano zɨsaanʉ. ");
INSERT INTO mgq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mukaasi yaakwe bhalɨɨpo abhabhinu abhinji, bhe bhatakhalolaga, bhe bhálemaaye, na bhe bháfuuye kʉndwɨmo. Bhakhagʉlɨlaga aminzi gavwalangane, ");
INSERT INTO mgq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kʉnongwa ye ʉkhabhɨzya wa Mwene akhiikhaga akhabhalɨlo khamu, akhavwalanganyaaga aminzi. Umuntu we abha wa kwanda kwinjila mwɨ bwabho we aminzi gavwalangana akhaponaga uwubhinu wowonti we áamɨle nawo. ");
INSERT INTO mgq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Umuntu ʉmo álɨɨpo kʉnʉʉkwo we ábhinile kʉ manha amashumi gatatʉ na gamwabho naane. ");
INSERT INTO mgq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","UYeesu we amʉlola agonile paala, ámanyile kʉtɨ umuntu ʉla alɨ papaala kʉ khabhalɨlo akhatali, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ʉkwanza kʉpona?” ");
INSERT INTO mgq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pe umubhinu ʉla akhamwamʉla uYeesu akhatɨ, “We mwene, atalɨɨpo umuntu ʉwa kʉmbɨɨkha mwɨ bwabho we aminzi gavwalangana. Ye nongwa ɨnga ɨnkwanza kwinjila mwɨ bwabho, umuntu uwunji akʉntangʉlɨla kwinjila.” ");
INSERT INTO mgq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pe uYeesu akhamʉbhʉʉzya umubhinu ʉla akhatɨ, “Yɨmɨɨlɨla, yeega ɨshɨlɨlɨ shaakho, bhalaga.” ");
INSERT INTO mgq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nalʉbhɨlo, umuntu ʉla akhapona, akheega ɨshɨlɨlɨ shaakwe, akhanda kʉjenda. UYeesu ámuponiizye umuntu wʉnʉʉyo pi siku ɨlyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pe abhalongozi abha Bhayahuudi bhakhamʉbhʉʉzya umuntu ʉla we uYeesu ámuponiizye bhakhatɨ, “Ʉmʉsanyʉʉnʉ lisiku lyɨ Sabaato, pe shɨnɨɨsho yɨtakwɨtɨshɨlwa mʉ ndajɨzyo zya Moose kʉpɨmba ɨshɨlɨlɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɨleelo umuntu ʉla akhabhaamʉla akhatɨ, “Umuntu we amponiizye we ambuziizye kʉtɨ, ‘Pɨmba ɨshɨlɨlɨ shaakho, jendaga.’ ” ");
INSERT INTO mgq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pe abhalongozi bhaala bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Wu naanu we akubhuziizye kʉtɨ ʉpɨmbe ɨshɨlɨlɨ shaakho ʉjendaje?” ");
INSERT INTO mgq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ɨleelo umuntu ʉla atámumanyile umuntu we ámuponiizye, kʉnongwa ye uYeesu ásogooye pa mpʉga ya bhantʉ ye yáamɨle paala. ");
INSERT INTO mgq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Isiku liliila we akhabhalɨlo khaashɨla khashe, uYeesu akhamwaga umuntu ʉla we aamuponiizye mwi linga ilyi Nyumba iMfinjile, akhamʉsokha akhatɨ, “Tejeelezya, ishi uponile. Ʉtakhasheele kʉbhomba imbiibhi winza, lɨtakhakwaje ibhiibhi nhaani.” ");
INSERT INTO mgq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Umuntu ʉla akhamʉlekha uYeesu, akhagalʉkha kʉbhabhʉʉzya abhalongozi abha Bhayahuudi kʉtɨ umuntu we amponiizye wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pe abhalongozi abha Bhayahuudi bhakhanda kʉmʉyɨmvwa uYeesu, kʉnongwa ye akhabhombaga zɨnɨɨzyo pi siku ɨlyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ɨleelo uYeesu akhabhabhʉʉzya akhatɨ, “ɄTaata waanɨ akʉbhomba ɨmbombo yaakwe akhabhalɨlo khonti, poope ni siku ɨlya mʉsanyʉʉnʉ. Nɨɨne bhʉʉlo ɨnkʉjendeelela kʉyɨbhomba pi siku ɨlyɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kʉnongwa yɨnɨɨyo, abhalongozi abha Bhayahuudi bhakhanda kwanza kʉ makha ɨdala ɨlya kʉmʉgoga uYeesu. Bhakhanzaga kʉmʉgoga te kʉnongwa ye álisholanyiinye isiku ɨlyɨ Sabaato lyene, lyoli kʉnongwa ye akhalongaga kʉtɨ ʉMʉlʉngʉ wʉ Taata waakwe. Kʉbhomba shɨnɨɨsho uYeesu áyibhiishile kʉtɨ alingaanile nʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","UYeesu akhabhabhʉʉzya abhalongozi bhaala akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, ʉMwana atangakhola kʉbhomba lyolyonti mwene bhʉʉlo, ʉweene akʉbhomba lye akʉlola ʉTaata waakwe akʉbhomba, kʉnongwa ye lye akʉbhomba ʉTaata lye nʉ Mwana waakwe akʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ɄTaata amuganile ʉMwana, ye nongwa akʉmʉlanga ɨmbombo zyonti zye akʉzɨbhomba, khabhɨlɨ atɨmʉlanje she atɨbhombe amayele amapɨtɨ kʉshɨla kʉbhaponɨa abhantʉ, nɨɨmwe mutiswigaje. ");
INSERT INTO mgq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Anza she ʉTaata akʉbhazyʉsya abhafwe na kʉʉbhapa uwuumi ʉwa wiila na wiila, shɨnɨɨsho ʉMwana waakwe akuumupa uwuumi umuntu wowonti we ayiganile kuumupa. ");
INSERT INTO mgq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ɄTaata atakʉmʉlonga umuntu wowonti, ɨleelo amupiiye ʉMwana waakwe ʉwaamʉlo ʉwa kʉbhalonga abhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kwɨ dala lɨnɨɨlyo, abhantʉ bhonti bhakhayimushindikha ʉMwana waakwe anza she bhakumushindikha ʉTaata waakwe. Umuntu wowonti we atakumushindikha ʉMwana waakwe atangamushindikha ʉTaata waakwe we amusonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we akwɨmvwa amazwi gaanɨ na kʉmwɨtɨkha ʉMʉlʉngʉ we ansonteleziizye, alɨ nu wuumi ʉwa wiila na wiila. Te akhalongwe ku mbiibhi zyakwe zye azibhombile, lyoli ayeepile kufuma mu wufwe na kwinjila mu wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nalyoli ɨnkʉbhabhʉʉzya, akhabhalɨlo khakwɨnza, khabhɨlɨ khafishile, bhe bhafwe bhakhayɨmvwa zye ɨne nʉMwana wa Mʉlʉngʉ ɨnkʉlonga. Pe bhonti bhe bhakwɨmvwa izi, bhakhayɨbha nu wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Anza she ʉTaata waanɨ alɨ na makha aga kuumupa umuntu uwuumi ʉwa wiila na wiila, shɨnɨɨsho ampiiye ɨne nʉMwana waakwe amakha aga kʉʉbhapa abhantʉ uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Khabhɨlɨ ampiiye ʉwaamʉlo ʉwa kʉbhalonga abhantʉ, kʉnongwa ye ɨne ne Mwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mutaswigaje ganaaga! Khakhayɨnza akhabhalɨlo khe abhantʉ bhonti abhafwe bhakhayɨmvwa izi lyanɨ we ɨnkʉbhabhɨlɨshɨla, ");
INSERT INTO mgq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bhakhayifuma mʉ mbɨɨpa zyabho. Bhonti bhe bhakhabhombaga ɨmbombo inyinza, ʉMʉlʉngʉ akhayɨbhazyʉsya na kʉʉbhapa uwuumi ʉwa wiila na wiila. Ɨleelo bhonti bhe bhakhabhombaga imbiibhi, ʉMʉlʉngʉ akhayɨbhazyʉsya ɨnga bhalongwe.” ");
INSERT INTO mgq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","UYeesu akhajendeelela kʉbhabhʉʉzya abhalongozi abha Bhayahuudi akhatɨ, “Ɨne ɨntangakhola kʉbhomba khokhonti kʉ makha gaanɨ nʉmwene. Ɨnkʉbhalonga abhantʉ kʉlandatana na she ʉTaata waanɨ akʉmbʉʉzya. Shɨnɨɨsho uwulonji waanɨ wa wugolosu, kʉnongwa ye ɨntakʉbhomba zye injiganile ɨne, lyoli ɨnkʉbhomba zye shɨgane sha Taata waanɨ we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ɨnga ɨnkʉbhabhʉʉzya ɨmwe intumi zyanɨ nʉneene, mʉtangakhola kwɨtɨkha kʉtɨ zye ɨnkʉlonga zya nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɨleelo ʉTaata waanɨ woope akuwufumwa uwukeeti waanɨ kukwinyu, nɨɨne imanyile kʉtɨ zyonti zye akumfumwizya uwukeeti zya nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Ɨmwe twábhasonteleziizye abhantʉ kwa Yookhani uMwozyi kʉtɨ bhamʉbhʉzɨɨlɨzye, woope akhamfumwizya uwukeeti kukwinyu we wáamɨle wa nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Te kʉtɨ ɨne ɨnkʉsʉʉbhɨla uwukeeti wa bhantʉ, ɨleelo ɨnkʉbhabhʉʉzya zɨnɨɨzyo ɨnga mʉwaaje uwuposhi. ");
INSERT INTO mgq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","UYookhani uMwozyi áamɨle lʉkhozyo lwe lʉkhaakhaga na kʉkhozya, nɨɨmwe mʉkhalʉseshela ʉlʉkhozyo lʉnʉʉlwo kʉ khabhalɨlo khashe. ");
INSERT INTO mgq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ɨleelo ɨndɨ nɨ zya kʉbhabhʉʉzya ɨmpɨtɨ kʉshɨla ɨzya Yookhani. Ɨmbombo zye ɨnkʉbhomba zikufumwa uwukeeti, kʉtɨ ʉTaata we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Woope ʉTaata we ansonteleziizye, akunsimishizya ɨne kukwinyu. Ɨmwe mutimvwizye naalumo izi lyakwe, khabhɨlɨ mutamulolile naalumo she alɨ. ");
INSERT INTO mgq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Izwi lyakwe lɨtalɨɨpo mukaasi yiinyu, kʉnongwa ye mutamwitishile we ʉMʉlʉngʉ amusonteleziizye kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mukwiniilizya uWusimbe uWufinjile, kʉnongwa ye mʉkʉsɨɨbha kʉtɨ mukaasi yaakwe mʉlɨ nu wuumi ʉwa wiila na wiila. Fwanɨ uWusimbe uWufinjile wʉnʉʉwo wukumfumwizya uwukeeti neene. ");
INSERT INTO mgq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ɨleelo mʉtakwanza kwɨnza kʉkwanɨ ɨnga mʉwaaje uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ɨne ɨntakwanza kʉpaalwa na bhantʉ, ");
INSERT INTO mgq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ɨleelo imbamanyile kʉtɨ mʉtalɨ nʉ lʉgano lwa Mʉlʉngʉ mʉ mooyo giinyu. ");
INSERT INTO mgq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨne ininzile kwɨ taawa lya Taata waanɨ, ɨleelo mʉtakʉmposheela. Ɨnga umuntu uwunji akwɨnza kwɨ taawa lyakwe wʉʉyo, mʉkhayɨmʉposheela. ");
INSERT INTO mgq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɨmwe mʉtangakhola kwɨtɨkha ɨnga mʉkʉpaalana mʉneemwe na mʉneemwe, ɨleelo mʉtakʉyɨkʉngʉla kwanza ɨmpaalo zye zikufuma kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉtakhasheele kʉsɨɨbha kʉtɨ ɨne ɨnhayɨbhasɨtaaka kwa Taata waanɨ. ɄMoose we akhayɨbhasɨtaaka kʉnongwa ye we mʉmʉsʉbhɨɨye. ");
INSERT INTO mgq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bhanje mʉmwɨtɨkhaje ʉMoose nhanɨ munitishile nɨɨne, kʉnongwa ye ʉMoose ásimbile intumi zye zɨkʉntekha ɨne. ");
INSERT INTO mgq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɨleelo ɨnga mʉtakwɨtɨkha zye ʉMoose ásimbile, mʉngakhola bhʉlɨɨbhʉlɨ kwɨtɨkha zye ɨne ɨnkʉlonga?” ");
INSERT INTO mgq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","We ganaago gaashɨla, uYeesu akhafumiila ʉsʉmbɨ ʉwa Galɨlaaya, we ɨtaawa ɨlyamwabho bhakʉtɨ ʉsʉmbɨ ʉwa Tibeeliya. ");
INSERT INTO mgq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɨmpʉga ɨmpɨtɨ ɨya bhantʉ yɨkhamʉlandata, kʉnongwa ye bhakhalolaga ɨvɨlolesyo vwe akhabhombaga ku bhabhinu. ");
INSERT INTO mgq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pe uYeesu akhazʉbha mwɨ gamba, akhɨɨkhala peeka na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Akhabhalɨlo khanaakho, ishikulukulu ɨshɨ Pasaaka ɨya Bhayahuudi shápalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","UYeesu we atendeela, akhayɨlola ɨmpʉga ɨmpɨtɨ ɨya bhantʉ ye yɨkhɨnzaga kʉkwakwe. Pe akhamʉbhʉzɨɨlɨzya uFilipo akhatɨ, “Tʉkale kwoshi amakaati ɨnga abhantʉ ɨbha bhalye?” ");
INSERT INTO mgq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","UYeesu ámubhuziliziizye shɨnɨɨsho kʉmʉlɨnga, kʉnongwa ye ámanyile she atɨbhombe. ");
INSERT INTO mgq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","UFilipo akhamwamʉla akhatɨ, “Poope ɨnga twakala amakaati agi dinaali imia zɨbhɨlɨ (200), gatangabhakwɨla abhantʉ ɨbha, poope ɨnga weeka weeka aapata khashe bhʉʉlo.” ");
INSERT INTO mgq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Weeka mu bhalandati bhaakwe ɨtaawa lyakwe bhakhatɨnjɨ ʉAndeleeya, we áamɨle wʉ khambakʉ wa Siimoni Peeteli, akhamwamʉla uYeesu akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“We Mwene, ɨpa alɨɨpo ʉmwana ʉmʉsakhaala alɨ na makaati gasaanʉ agi shayili ni nswi zɨbhɨlɨ. Ɨleelo viniivi vɨngakwɨla ɨmpʉga yonti ɨnɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","UYeesu akhatɨ, “Bhɨɨkhazye abhantʉ.” Papaala páamɨle na malaala aminji. Pe abhantʉ bhakhɨɨkhala, páamɨle na bhasakhaala ielufu zɨsaanʉ (5,000). ");
INSERT INTO mgq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pe uYeesu akheega amakaati gaala, akhamusalifwa ʉMʉlʉngʉ. Akhabhagabhɨla abhantʉ bhaala bhe bhɨ́khaaye, akhabhomba shɨnɨɨsho ni nswi ziila. Abhantʉ bhonti bhakhapata anza she bhakhanzaga. ");
INSERT INTO mgq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","We abhantʉ bhonti bhaalya bhiikuta, uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Bhungaanyi ɨnsenyenha zye zisyalile, ɨnga zɨtakhateeje.” ");
INSERT INTO mgq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe bhakhabhʉngaanya ɨnsenyenha zye zyásyalile ɨzya makaati agi shayili, bhakhiizuzya ɨvɨtʉndʉ ishumi na vɨbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","We abhantʉ bhaala bhaalola ɨvɨlolesyo vwe uYeesu ábhombile, bhakhalonga bhakhatɨ, “Nalyoli umuntu ʉnʉ we mukuwi we twagʉlɨlaga kʉtɨ akhayɨnza mʉ nsɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","UYeesu akhamanya kʉtɨ abhantʉ bhaala bhakwanza kumubijila kʉmʉbhɨɨkha kʉbha wʉ Mwene waabho, ɨleelo akhasogola akhabhala mwene winza mwɨ gamba. ");
INSERT INTO mgq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","We kwabha shalyabheela, abhalandati bha Yeesu bhakhiikha kʉbhala kwa sʉmbɨ ʉwa Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhakhapanda mʉ shɨtʉʉlɨ, bhakhanda kufumiila ʉsʉmbɨ kʉbhala mʉ nhaaya ɨya mu Kapelenaumu. Mʉ khabhalɨlo khanaakho, akhiisi kháguuye, uYeesu atáamɨle peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pe ʉsʉmbɨ akhavwalangana, kʉnongwa ye impepu inhali yikhavugulaga. ");
INSERT INTO mgq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","We abhalandati bha Yeesu bhashʉʉla ikilomiita zɨsaanʉ awe ʉmʉtanda, bhakhamʉlola uYeesu akʉjenda pamwanya pa minzi, akʉshɨpalamɨla ɨshɨtʉʉlɨ, bhakhoogopa nhaani. ");
INSERT INTO mgq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ɨleelo uYeesu akhabhabhʉʉzya akhatɨ, “Neene, mʉtogopaje!” ");
INSERT INTO mgq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pe bhakhanzaga kʉmʉpɨmba uYeesu mʉ shɨtʉʉlɨ. Nalʉbhɨlo ɨshɨtʉʉlɨ shikhafikha mʉ nsɨ inyuumu kwe bhakhabhalaga. ");
INSERT INTO mgq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Isiku lye lɨkhalandata, ɨmpʉga ɨya bhantʉ bhe bhásyalile kwɨsyɨla ɨlya sʉmbɨ bhakhamanya kʉtɨ shálɨɨpo ɨshɨtʉʉlɨ sheeka sheene paala. Khabhɨlɨ bhámanyile kʉtɨ uYeesu atínjiiye mʉ shɨtʉʉlɨ peeka na bhalandati bhaakwe, lyoli abhalandati bhanaabho bhábhalile bheene. ");
INSERT INTO mgq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɨleelo vɨkhɨnza ɨvɨtʉʉlɨ ɨvwamwabho kufuma mʉ nhaaya ɨya mu Tibeeliya, vikhafikha papɨɨpɨ na paala pe abhantʉ bháliiye amakaati we uYeesu amusalifwa ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pe we ɨmpʉga ɨya bhantʉ bhaala bhaamanya kʉtɨ uYeesu na bhalandati bhaakwe naabhamu paala, bhakhinjila mʉ vɨtʉʉlɨ vɨnɨɨvwo, bhakhabhala mʉ nhaaya ɨya mu Kapelenaumu kʉmwanza uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","We abhantʉ bhaala bhamwaga uYeesu kwɨsyɨla ɨlyamwabho ɨlya sʉmbɨ ʉwa Galɨlaaya, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “We Mumanyizyi, uyinzile liino kunuuku?” ");
INSERT INTO mgq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","UYeesu akhabhaamʉla akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, imanyile kʉtɨ mʉkʉnanza te kʉnongwa ye mwaalolile ɨvɨlolesyo vwe naabhombile, lyoli kʉnongwa ye mwaaliiye amakaati gaala na kwikuta. ");
INSERT INTO mgq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mʉtashɨbhombelaje ɨmbombo ishaakulya she shɨkʉnanjɨkha, lyoli mʉshɨbhombelaje ishaakulya she shɨtakʉnanjɨkha, she shɨkʉdɨɨla wiila na wiila. ɄMwana wa Muntu we ʉTaata ʉMʉlʉngʉ amusimishiziizye, atɨɨbhape ishaakulya shɨnɨɨsho.” ");
INSERT INTO mgq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Tʉkhonzye bhʉlɨ ɨnga tʉbhombaje ɨmbombo ye ʉMʉlʉngʉ akwanza?” ");
INSERT INTO mgq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","UYeesu akhabhaamʉla akhatɨ, “Ɨmbombo ye ʉMʉlʉngʉ akwanza ye yɨ yɨɨnɨ: mʉmwɨtɨshe we amusonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Ʉtɨbhombe shɨlolesyo shooni kʉtɨ tʉshɨlole ɨnga tʉkwɨtɨshe? Ʉtɨbhombe khantʉ khooni? ");
INSERT INTO mgq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abhamaama bhɨɨtʉ bháliiye ishaakulya she bhakʉtɨ ɨmaana we bhalɨ mu shilozu, anza she yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Ábhapiiye ishaakulya kufuma kʉmwanya ɨnga bhalye.’” ");
INSERT INTO mgq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, te wʉ Moose ábhapiiye abhamaama bhiinyu ishaakulya kufuma kʉmwanya, lyoli wʉ Taata we akʉʉbhapa ɨmwe ishaakulya ɨsha nalyoli kufuma kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kʉnongwa ye ishaakulya sha Mʉlʉngʉ she akʉshɨleeta kufuma kʉmwanya she shɨkʉʉbhapa abhantʉ bhonti mʉ nsɨ uwuumi ʉwa wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pe bhakhamwamʉla bhakhatɨ, “We mwene, ʉtʉpanje wiila ishaakulya shɨnɨɨsho.” ");
INSERT INTO mgq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","UYeesu akhabhaamʉla akhatɨ, “Ɨne ne shaakulya she shɨkʉʉbhapa abhantʉ uwuumi ʉwa wiila na wiila. Umuntu wowonti we akwɨnza kʉkwanɨ, te akhaalole naalumo ɨnzala, khabhɨlɨ we akʉnɨɨtɨkha te akhaalole ɨshʉʉmɨlwa naalumo. ");
INSERT INTO mgq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ɨleelo nábhabhuziizye kʉtɨ she poope mundolile mʉtakʉnɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhonti bhe akumpa ʉTaata waanɨ, bhatɨyɨnze kʉkwanɨ, nɨɨne te ɨnhamʉsʉmbe naalumo kunzi umuntu wowonti we akwɨnza kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kʉnongwa ye ɨne ininzile kufuma kʉmwanya te kʉnongwa ɨya kʉbhomba ɨshɨgane shaanɨ, lyoli kʉbhomba ɨshɨgane sha Taata waanɨ we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ɨshɨgane sha we ansonteleziizye, kʉ kʉtɨ ɨntakhamʉteezye ngaweeka mʉ bhaala bhe ampiiye, lyoli ɨnhabhazyʉsye pi siku ɨlya kʉmpeleela. ");
INSERT INTO mgq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kʉnongwa ye ɨshɨgane sha Taata waanɨ kʉ kʉtɨ umuntu wowonti we akʉmwenya ʉMwana na kʉmwɨtɨkha, abhe nu wuumi ʉwa wiila na wiila. Nɨɨne ɨnhayɨmʉzyʉsya pi siku ɨlya kʉmpeleela.” ");
INSERT INTO mgq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pe aBhayahuudi bhakhanda kungʼulungʼuusa kʉnongwa ye uYeesu átɨlɨ, “Ɨne ne shaakulya she shikufuma kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakhabhʉzɨlɨzanya bhakhatɨ, “Bhʉlɨ, wʉnʉʉnʉ te wu Yeesu, ʉmwana wa Yoosefu, we uyise waakwe nu nyina waakwe tubhamanyile? Angakhola bhʉlɨɨbhʉlɨ kʉlonga kʉtɨ, ‘Imfumile kʉmwanya’?” ");
INSERT INTO mgq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","UYeesu akhabhaamʉla akhatɨ, “Lashi kungʼulungʼuusa mʉneemwe na mʉneemwe. ");
INSERT INTO mgq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Atalɨɨpo umuntu we angakhola kwɨnza kʉkwanɨ ɨnga ʉTaata waanɨ we ansonteleziizye atamʉlongooye. Nɨɨne ɨnhayɨmʉzyʉsya pi siku ɨlya kʉmpeleela. ");
INSERT INTO mgq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yisimbiilwe mu wusimbe ʉwa bhakuwi kʉtɨ, ‘ɄMʉlʉngʉ akhayɨbhamanyɨzya abhantʉ bhonti.’ Pe umuntu wowonti we akʉmʉtejeelezya ʉTaata na kʉmanyɨla kufuma kʉkwakwe, wʉnʉʉyo akwɨnza kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɨntakʉtɨ alɨɨpo umuntu we amulolile ʉMʉlʉngʉ ʉTaata waanɨ, lyoli ʉla we afumile kwa Mʉlʉngʉ, wʉʉyo mwene we amulolile ʉTaata. ");
INSERT INTO mgq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we akwɨtɨkha, alɨ nu wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɨne ne shaakulya she shɨkʉʉbhapa abhantʉ uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abhamaama bhiinyu bháliiye ishaakulya ɨshɨkholo ɨshɨ maana we bhalɨ mu shilozu, ɨleelo bháfuuye. ");
INSERT INTO mgq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ɨleelo ɨpa shɨlɨɨpo ishaakulya she shifumile kʉmwanya. Umuntu wowonti ɨnga aalya te akhaafwe naalumo. ");
INSERT INTO mgq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɨne ne shaakulya she shíishile kufuma kʉmwanya she shɨkʉʉbhapa abhantʉ uwuumi ʉwa wiila na wiila. Umuntu wowonti we aalya ishaakulya ishi, atɨbhe nu wuumi ʉwa wiila na wiila. Ishaakulya she intiimupe mʉbhɨlɨ waanɨ we inkuwufumwa kʉnongwa ya wuumi ʉwa bhantʉ bhonti mʉ nsɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pe aBhayahuudi bhakhanda kʉdalɨnhana bhɨɨbho na bhɨɨbho kʉtɨ, “Umuntu ʉnʉ angakhola bhʉlɨɨbhʉlɨ kuutupa ʉmʉbhɨlɨ waakwe tulye?” ");
INSERT INTO mgq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, ɨnga mutakulya ʉmʉbhɨlɨ wa Mwana wa Muntu na kʉmwela ɨbhanda lyakwe, te mʉbhe nu wuumi mukaasi yiinyu. ");
INSERT INTO mgq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Umuntu wowonti we akulya ʉmʉbhɨlɨ waanɨ na kʉmwela ɨbhanda lyanɨ alɨ nu wuumi ʉwa wiila na wiila, nɨɨne ɨnhayɨmʉzyʉsya pi siku ɨlya kʉmpeleela. ");
INSERT INTO mgq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kʉnongwa ye ʉmʉbhɨlɨ waanɨ shaakulya sha nalyoli nɨ bhanda lyanɨ shakʉmwela ɨsha nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Umuntu wowonti we akulya ʉmʉbhɨlɨ waanɨ na kʉmwela ɨbhanda lyanɨ, atɨyɨɨkhale mukaasi mʉmwanɨ, nɨɨne ɨntɨyɨɨkhale mukaasi yaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“ɄTaata waanɨ we mwumi ansonteleziizye, nɨɨne ne mwumi kʉshɨlɨla kʉkwakwe. She shɨnɨɨsho, umuntu wowonti we akulya ʉmʉbhɨlɨ waanɨ, atɨbhe mwumi kʉshɨlɨla kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ishi she shaakulya she shiishile kufuma kʉmwanya. Ishaakulya shiniishi shitakholiine ni shaakulya ɨshɨ maana she abhamaama bhiinyu bháliiye, bhakhafwa. Lyoli wowonti we akulya ishaakulya ishi, atɨbhe nu wuumi ʉwa wiila na wiila.” ");
INSERT INTO mgq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","UYeesu álonjile zɨnɨɨzyo we alɨ kʉmanyɨzya mwi sinagoogi kuula mʉ nhaaya ɨya mu Kapelenaumu. ");
INSERT INTO mgq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Abhinji mu bhalandati bhaakwe we bhɨmvwa zɨnɨɨzyo bhakhatɨ, “Ɨmanyɨzyo izi mbiibhi nhaani! Wu naanu we angakhola kʉzɨtejeelezya?” ");
INSERT INTO mgq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","We uYeesu aamanya kʉtɨ abhalandati bhaakwe bhakungʼulungʼuusa kʉ zye alonga, akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, liniili lyabhaviisya? ");
INSERT INTO mgq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pe yɨkhayɨbha bhʉlɨɨbhʉlɨ we mʉkʉmʉlola ʉMwana wa Muntu akʉzʉbha kʉbhala kʉmwanya kwe áamɨle kʉwandɨlo? ");
INSERT INTO mgq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","UMupepu uMufinjile we akʉʉbhapa abhantʉ uwuumi, umuntu atangakhola kʉbhomba lyolyonti. Amazwi ɨga ge nabhabhʉʉzya gakufuma kwa Mupepu uMufinjile, khabhɨlɨ gakʉbhaleetela uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ɨleelo bhalɨɨpo bhamu pakaasi yiinyu bhe bhatakʉmwɨtɨkha.” UYeesu álonjile shɨnɨɨsho kʉnongwa ye ámanyile kufuma kʉwandɨlo kʉtɨ bha bhanaanu bhe bhatakwɨtɨkha na kʉtɨ wu naanu we akhayɨmʉlonjeelela kʉ bhalʉgʉ. ");
INSERT INTO mgq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akhajendeelela kʉlonga akhatɨ, “Ye nongwa yɨnɨɨyo, nabhabhʉʉzya kʉtɨ atalɨɨpo umuntu we angakhola kwɨnza kʉkwanɨ ɨnga atalongoliilwe nʉ Taata waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kufuma akhabhalɨlo khanaakho abhalandati bhaakwe abhinji bhakhagalʉkha kʉlʉsalo, bhakhalekha kʉmʉlandata. ");
INSERT INTO mgq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pe uYeesu akhabhabhʉzɨɨlɨzya bhaala ishumi na bhabhɨlɨ akhatɨ, “Bhʉlɨ, nɨɨmwe bhʉʉlo mʉkwanza kʉsogola?” ");
INSERT INTO mgq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","USiimoni Peeteli akhamwamʉla akhatɨ, “Mwene, tʉsogole tʉbhale kwa naanu? Ɨwe ʉlɨ na mazwi aga wuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ɨtwe tʉkwɨtɨkha, khabhɨlɨ tumanyile kʉtɨ ɨwe we Mufinjile kufuma kwa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pe uYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, intabhasebhile ɨmwe ishumi na bhabhɨlɨ? Ɨleelo weeka mukaasi yiinyu akʉlongolwa nu Seetani.” ");
INSERT INTO mgq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ɨpa uYeesu akhamʉtekhaga wʉ Yʉʉda, ʉmwana wa Siimoni Sikalioti. She poope áamɨle weeka mʉ bhaala ishumi na bhabhɨlɨ, pɨlongolela we akhayɨmʉlonjeelela uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pe we zɨnɨɨzyo zyashɨla, uYeesu akhanda kʉjenda mʉ nhaaya ɨzya mʉ nsɨ ɨya Galɨlaaya. Atakhanzaga kʉbhala mʉ nsɨ ɨya Yudeeya kʉnongwa ye abhalongozi abha Bhayahuudi bhakhanzaga kʉmʉgoga. ");
INSERT INTO mgq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ishikulukulu ishi vwegwi ɨsha Bhayahuudi shápalamɨɨye. ");
INSERT INTO mgq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pe abhansi bha Yeesu bhakhamʉbhʉʉzya bhakhatɨ, “Sogola ɨpa, ʉbhale mu Yudeeya, ɨnga abhalandati bhaakho bhavɨlole ɨvɨlolesyo vwe ʉkʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Umuntu we akwanza kʉmanyɨkha, atakʉbhomba ɨmbombo zyakwe kukwilu. Ɨnga ʉkʉbhomba ziniizi, yɨlolesye kʉ bhantʉ abha mʉ nsɨ ɨnga bhakʉmanye.” ");
INSERT INTO mgq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abhansi bhaakwe bhálonjile shɨnɨɨsho kʉnongwa ye bhoope bhatámwitishile uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pe uYeesu akhabhabhʉʉzya akhatɨ, “Akhabhalɨlo khaanɨ akha kʉbhala khashɨɨlɨ kufikha, ɨleelo ɨmwe mʉlɨ na khabhalɨlo insiku zyonti kʉbhala. ");
INSERT INTO mgq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abhantʉ abha mʉ nsɨ ɨnɨ bhatangakhola kubhaviitilwa ɨmwe, lyoli bhakumviitilwa ɨne kʉnongwa ye ɨnkʉbhabhʉʉzya kʉtɨ, zye bhakʉbhomba mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zubhaji mʉbheene kʉbhala kushimwa ishikulukulu. Ɨne ɨntakʉbhala, kʉnongwa ye akhabhalɨlo khaanɨ akha kʉbhala khashɨɨlɨ kufikha.” ");
INSERT INTO mgq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","We uYeesu alonga ganaago, akhasyala mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ɨleelo we abhansi bhaakwe bhaabhala mu Yelusaleemu kushimwa ishikulukulu ishi vwegwi, uYeesu woope akhabhala, ɨleelo sita kʉyɨlolesya apazelu. ");
INSERT INTO mgq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pe we bhalɨ pa shikulukulu, abhalongozi abha Bhayahuudi bhakhamwanzaga uYeesu. Bhakhabhabhʉzɨɨlɨzya abhantʉ bhe bhálɨɨpo paala bhakhatɨ, “Alɨ kwoshi umuntu wʉnʉʉnʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwámɨle na kʉdalɨnhana mʉ mpʉga ya bhantʉ kʉ zya Yeesu. Bhamu bhakhatɨnjɨ, “Muntu mwinza.” Ɨleelo bhamu bhakhatɨnjɨ, “Ndaali, akʉbhakhopela abhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ɨleelo atálɨɨpo umuntu we akhamʉtekhaga uYeesu apazelu, kʉnongwa ya kʉbhoogopa abhalongozi abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","We kushimwa ishikulukulu ishi vwegwi kwafikha pakaasi, uYeesu akhabhala mwi linga ilyi Nyumba iMfinjile, akhanda kʉbhamanyɨzya. ");
INSERT INTO mgq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pe abhalongozi abha Bhayahuudi bhakhaswiga bhakhatɨ, “Umuntu wʉnʉʉnʉ amanyile bhʉlɨɨbhʉlɨ ziniizi, we atabhaziizye?” ");
INSERT INTO mgq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pe uYeesu akhabhaamʉla akhatɨ, “Ɨmanyɨzyo zye ɨnkʉmanyɨzya te zyanɨ, lyoli zikufuma kwa Mʉlʉngʉ we ánsonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Umuntu wowonti we akwanza kʉbhomba zye ʉMʉlʉngʉ ayiganile, atɨmanye kʉtɨ ɨmanyɨzyo ziniizi zifumile kwa Mʉlʉngʉ awe kʉtɨ ɨnkʉlonga zyanɨ nʉneene. ");
INSERT INTO mgq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Umuntu wowonti we akʉlonga zyɨ zyakwe, akʉyanzɨla uwumwamu waakwe wʉʉyo. Ɨleelo we akwanza uwumwamu wa wʉʉla we amusonteleziizye, akʉlonga uwanalyoli, ɨlenga naalimo mukaasi yaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bhʉlɨ, ʉMoose atábhapiiye ɨmwe ɨndajɨzyo? Ɨleelo poope shɨnɨɨsho atalɨɨpo ngaweeka mukaasi yiinyu we akʉlandata ɨndajɨzyo zɨnɨɨzyo. Khooni khe mʉkwanza kʉngoga?” ");
INSERT INTO mgq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɨmpʉga ɨya bhantʉ yɨkhamwamʉla yɨkhatɨ, “Ɨwe ʉlɨ ni pepu ibhiibhi! Wu naanu we akwanza kʉkʉgoga?” ");
INSERT INTO mgq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","UYeesu akhabhaamʉla akhatɨ, “Nábhombile ɨshɨlolesyo sheeka, ɨmwe mwenti mukhaswiga. ");
INSERT INTO mgq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ɄMoose akhabhalajɨzya ɨmwe kutahiili. Te kʉtɨ ʉmwata ʉwa kutahiili wʉnʉʉwo wáfumiliine nʉ Moose, lyoli wáfumile kʉ bhamaama bhɨɨtʉ. Ishi ɨmwe mukumutahiili ʉmwana poope na pi siku ɨlyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ɨnga mukubhatahiili abhaana pi siku ɨlyɨ Sabaato, ɨnga ɨndajɨzyo zya Moose zɨtakhashoolanywe, khooni khe mukumviitilwa ɨne kʉnongwa ɨya kʉmʉponɨa umuntu ʉmʉbhɨlɨ waakwe wonti pi siku ɨlyɨ Sabaato? ");
INSERT INTO mgq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʉtamʉlongaje umuntu kʉnongwa ya zye zɨkʉlolekha kunzi, lyoli mʉmʉlongaje umuntu ku wugolosu.” ");
INSERT INTO mgq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pe abhantʉ bhamu bhe bháamɨle mʉ nhaaya ɨya Yelusaleemu bhakhalongaga bhakhatɨnjɨ, “Bhʉlɨ, umuntu wʉnʉʉnʉ te we abhalongozi bhakʉmwanza ɨnga bhamʉgoje? ");
INSERT INTO mgq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yeenya ishi, akʉlonga apazelu, poope shɨnɨɨsho, abheene bhatakʉmʉbhʉʉzya lyolyonti! Bhʉlɨ, abhapɨtɨ lumo bhamanyile kʉtɨ ʉweene we wu Kilisiti? ");
INSERT INTO mgq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɨleelo ɨtwe tumumanyile umuntu wʉnʉʉnʉ kwe afumile. Lyoli uKilisiti we akwɨnza, atalɨɨpo umuntu we amanyile kwe afumile.” ");
INSERT INTO mgq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pe uYeesu akhajendeelela kʉmanyɨzya mwi linga ilyi Nyumba iMfinjile, akhalonga kwi zi ɨlya kʉdandɨzya akhatɨ, “Ɨmwe mumanyile ɨne, khabhɨlɨ mumanyile kwe inkufuma. Ɨne intínzile kʉ waamʉlo waanɨ, lyoli we ansonteleziizye we wa nalyoli, nɨɨmwe mutamumanyile. ");
INSERT INTO mgq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ɨne imumanyile kʉnongwa ye imfumile kʉkwakwe, khabhɨlɨ we ansonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pe bhakhanza ɨdala ɨlya kʉmʉlema, ɨleelo atálɨɨpo umuntu we álinjiziizye kʉmʉlema, kʉnongwa ye akhabhalɨlo khaakwe akha kʉlʉmbɨɨlɨla kháshɨɨlɨ kusila. ");
INSERT INTO mgq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɨleelo abhantʉ abhinji mʉ mpʉga yiila bhakhamwɨtɨkha uYeesu, bhakhatɨ, “Bhʉlɨ, uKilisiti ɨnga ayɨnza, akhayɨbhomba ɨvɨlolesyo ivwinji kʉshɨla vwe abhombile umuntu ʉnʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ABhafalisaayi we bhɨmvwa ɨmpʉga ɨya bhantʉ bhakunongʼona zɨnɨɨzyo kʉ zya Yeesu, abheene peeka na bhapɨtɨ abha bhapuutili bhakhabhasonteelezya abhalindiilili abhi Nyumba iMfinjile ɨnga bhamʉleme. ");
INSERT INTO mgq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pe uYeesu akhatɨ, “Ɨne ɨndɨ peeka nɨɨmwe kʉ khabhalɨlo khashe bhʉʉlo, ɨleelo ɨnhayɨgalʉkha kwa Mʉlʉngʉ we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mʉkhayɨnanza, ɨleelo te mʉkhanaaje, khabhɨlɨ paala pe ɨnhayɨbha ɨmwe mʉtangakhola kwɨnza.” ");
INSERT INTO mgq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pe abhalongozi abha Bhayahuudi bhakhazaabhana bhɨɨbho na bhɨɨbho bhakhatɨ, “Umuntu wʉnʉʉnʉ akwanza kʉbhala kwoshi kwe tʉtangakhola kʉmwaga? Bhʉlɨ, atɨbhale ku Bhayahuudi bhe bhasataanile mʉ nhaaya zya bhe te Bhayahuudi na kʉbhamanyɨzya abheene? ");
INSERT INTO mgq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kwe kʉtɨ bhʉlɨ we akʉtʉbhʉʉzya kʉtɨ, ‘Mʉkhayɨnanza, ɨleelo te mʉkhanaaje, khabhɨlɨ paala pe ɨnhayɨbha, ɨmwe mʉtangakhola kwɨnza’?” ");
INSERT INTO mgq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pi siku ɨlya kʉwʉmalɨlɨshɨlo, isiku liila ɨpɨtɨ ilyi shikulukulu ishi vwegwi, uYeesu akhɨmɨɨlɨla akhalonga kwi zi ɨlya kʉdandɨzya akhatɨ, “Umuntu wowonti we alɨ nɨ shʉʉmɨlwa, ayɨnze kʉkwanɨ amwele. ");
INSERT INTO mgq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anza she uWusimbe uWufinjile wʉkʉlonga kʉtɨ, umuntu wowonti we akʉnɨɨtɨkha, ‘Inyiizi ɨzya minzi aga wuumi zɨkhayɨchongolokha mʉ mwoyo waakwe.’” ");
INSERT INTO mgq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","UYeesu akhalongaga kʉ zya Mupepu uMufinjile we bhonti bhe bhamwitishile, bhakhayɨmʉposheela. Akhabhalɨlo khanaakho, uMupepu uMufinjile áshɨɨlɨ kwɨnza, kʉnongwa ye ʉMʉlʉngʉ áshɨɨlɨ kʉlolesya apazelu uwumwamu wa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Abhantʉ bhamu bhe bháamɨle mʉ mpʉga yiila we bhɨmvwa amazwi ganaago, bhakhatɨ, “Nalyoli umuntu wʉnʉʉnʉ we mukuwi we tʉkʉmʉgʉʉlɨla.” ");
INSERT INTO mgq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bhamu bhakhatɨ, “Umuntu wʉnʉʉnʉ wu Kilisiti.” Ɨleelo bhamu bhakhatɨ, “Bhʉlɨ, uKilisiti angafuma mʉ Galɨlaaya? ");
INSERT INTO mgq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","UWusimbe uWufinjile wʉkʉlonga kʉtɨ, uKilisiti akhayifuma mʉ shɨkholo sha mwene uDaudi, khabhɨlɨ akhayɨpaapwa mʉ nhaaya ɨya mu Beteleheemu, ɨnhaaya ye ʉmwene uDaudi akhɨkhalaga.” ");
INSERT INTO mgq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pe abhantʉ bhakhagabhʉnhana kʉnongwa ya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhamu bhakhanzaga kʉmʉlema, ɨleelo atálɨɨpo umuntu we ámulemile. ");
INSERT INTO mgq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pe abhalindiilili abhi Nyumba iMfinjile bhakhagalʉkha kʉ bhapɨtɨ bha bhapuutili na Bhafalisaayi bhe bhabhasonteleziizye kʉmʉlema uYeesu. Abheene bhakhabhabhʉzɨɨlɨzya abhalindiilili bhakhatɨ, “Khooni khe mutamulemile na kʉmʉleeta?” ");
INSERT INTO mgq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abhalindiilili bhakhabhaamʉla bhakhatɨ, “Tupotiilwe kʉmʉlema kʉnongwa ye atalɨɨpo umuntu we akʉlonga kʉ makha anza she ʉweene akʉlonga.” ");
INSERT INTO mgq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ABhafalisaayi bhakhabhaamʉla bhakhatɨ, “Bhʉlɨ, nɨɨmwe bhʉʉlo mwakhopelwa? ");
INSERT INTO mgq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bhʉlɨ, alɨɨpo ʉmʉpɨtɨ wowonti awe uMufalisaayi weeka we amwitishile uYeesu? ");
INSERT INTO mgq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɨleelo ɨmpʉga ɨya bhantʉ bhe bhatazimanyile ɨndajɨzyo zya Moose bhaguniilwe.” ");
INSERT INTO mgq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pe uNikodeemu, ʉla we ábhalile isiku limo shawusiku kwa Yeesu, we áamɨle weeka mu Bhafalisaayi, akhabhabhʉzɨɨlɨzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bhʉlɨ, ɨndajɨzyo zyɨtʉ zɨkʉtwɨtɨshɨzya kʉmʉlonga umuntu we tutamutejeleziizye na kʉmanya zye abhombile?” ");
INSERT INTO mgq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Abheene bhakhamwamʉla bhakhatɨ, “Bhʉlɨ, nɨɨwe ufumile mʉ Galɨlaaya? Bhaazya uWusimbe uWufinjile, pe ʉtɨzyaganye kʉtɨ atalɨɨpo umukuwi we angafuma mʉ Galɨlaaya.”  ");
INSERT INTO mgq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pe bhakhasogola, weeka weeka akhagalʉkha kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ɨleelo uYeesu akhabhala mwɨ gamba ɨlya Mizeituni. ");
INSERT INTO mgq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Shɨlaabhɨla we kwasha, uYeesu akhɨnza winza mwi linga ilyi Nyumba iMfinjile. Abhantʉ bhonti bhakhabhala kʉkwakwe, akhɨɨkhala, akhanda kʉbhamanyɨzya. ");
INSERT INTO mgq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abhamanyizyi abhɨ ndajɨzyo zya Moose na Bhafalisaayi bhakhamʉleeta ʉmwantanda ʉmo we álemiilwe mu wubhembu. Bhakhamwɨmɨɨlɨsya pakaasi pa mpʉga ya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pe bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “We Mumanyizyi, ʉmwantanda ʉnʉ alemiilwe we alɨ kubhembukha. ");
INSERT INTO mgq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mʉ ndajɨzyo, ʉMoose átulajiziizye kʉbhakhoma na mawe abhantanda anza bhanaabha, paka kufwa. Ishi, ɨwe ʉkʉtɨ bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bhámubhuziliziizye shɨnɨɨsho uYeesu kʉmʉtega ɨnga bhalyaje ɨdala ɨlya kʉmʉsɨtaaka. Ɨleelo uYeesu, akhasulama paasɨ, akhanda kusimba na khasamba pa lusuuto. ");
INSERT INTO mgq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","We bhakʉjendeelela kʉmʉbhʉzɨɨlɨzya, pe uYeesu akhabhʉʉkha, akhabhaamʉla akhatɨ, “Ɨnga alɨɨpo weeka pakaasi yiinyu we atalɨ ni mbiibhi, abhe wa kwanda kʉmʉkhoma ni we.” ");
INSERT INTO mgq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pe uYeesu akhasulama winza paasɨ na kusimba pa lusuuto. ");
INSERT INTO mgq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","We bhɨmvwa zɨnɨɨzyo, bhakhanda kʉsogola weeka weeka, kwandɨla abhagoosi. Pe uYeesu akhasyala mwene nʉ mwantanda ʉla, ayɨmɨlɨɨye pɨlongolela yaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","UYeesu we abhʉʉkha, atakhamʉlola umuntu ngaweeka, akhamʉbhʉzɨɨlɨzya ʉmwantanda ʉla akhatɨ, “Wʉmwantanda ɨwe, bhalɨ kwoshi abhantʉ bhe bhakʉsɨtaakaga? Bhʉlɨ, atalɨɨpo we akulonjile kʉtɨ we mʉtʉla nongwa?” ");
INSERT INTO mgq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ʉmwantanda ʉla akhamwamʉla akhatɨ, “Mwene, atalɨɨpo ngaweeka.” Pe uYeesu akhamʉbhʉʉzya akhatɨ, “Nɨɨne ɨntakʉkʉlonga. Sogolaga, ɨleelo kufuma ishi, ʉtakhabhombe imbiibhi winza.” ");
INSERT INTO mgq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pe uYeesu akhabhabhʉʉzya winza abhantʉ bhaala akhatɨ, “Ɨne ne lʉkhozyo lwɨ nsɨ, umuntu wowonti we akʉndandata, te ajendaje mu khiisi naalumo, lyoli atɨbhe nʉ lʉkhozyo lwe lʉkʉʉbhapa abhantʉ uwuumi.” ");
INSERT INTO mgq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ABhafalisaayi bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Uwukeeti we ukufumwa wʉtakwɨtɨshɨlwa, kʉnongwa ye ʉkʉyɨtekha wʉneewe. Pe shɨnɨɨsho uwukeeti waakho te wa nalyoli.” ");
INSERT INTO mgq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","UYeesu akhabhaamʉla akhatɨ, “Poope ɨnga ɨnkʉyɨlonjela nʉneene, uwukeeti waanɨ wa nalyoli, kʉnongwa ye imanyile kwe imfumile, khabhɨlɨ imanyile na kwe ɨnkʉbhala. Ɨleelo ɨmwe mutamanyile kwe imfumile awe kwe ɨnkʉbhala. ");
INSERT INTO mgq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɨmwe mʉkʉlonga abhantʉ ku vipimilo ɨvwa bhantʉ, ɨleelo ɨne ɨntakʉmʉlonga umuntu wowonti. ");
INSERT INTO mgq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ɨleelo ɨnga ɨne ɨnkʉmʉlonga umuntu, ɨnkʉmʉlonga mu wugolosu, kʉnongwa ye ɨntakʉbha nʉmwene, lyoli ɨnkʉbha peeka nʉ Taata we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉ ndajɨzyo zyinyu yisimbiilwe kʉtɨ, ‘Uwukeeti ʉwa bhantʉ bhabhɨlɨ wa nalyoli.’ ");
INSERT INTO mgq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ɨne ɨnkʉyɨlonjela nʉneene nʉ Taata waanɨ we ansonteleziizye we mukeeti waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pe aBhafalisaayi bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “ɄTaata waakho alɨ kwoshi?” UYeesu akhabhaamʉla akhatɨ, “Mutamanyile ɨne, woope ʉTaata mutamumanyile. Bhanje mʉmanyaje ɨne nhanɨ mumumanyile nʉ Taata waanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","UYeesu álonjile amazwi ganaago we akʉmanyɨzya mwi linga ilyi Nyumba iMfinjile papɨɨpɨ nu lupitu ʉlwa kusengulila ɨnsandʉʉka ɨyɨ nhela. Ɨleelo atálɨɨpo umuntu we ámulemile kʉnongwa ye akhabhalɨlo khaakwe akha kʉlʉmbɨɨlɨla kháshɨɨlɨ kusila. ");
INSERT INTO mgq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pe uYeesu akhabhabhʉʉzya aBhafalisaayi winza akhatɨ, “Ɨne ɨnkʉbhala ʉlwanɨ, ɨmwe mʉkhayɨnanza, ɨleelo mʉkhayɨfwɨla mu mbiibhi zyinyu. Paala pe ɨnhayɨbha ɨmwe mʉtangakhola kwɨnza.” ");
INSERT INTO mgq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pe abhalongozi abha Bhayahuudi bhakhatɨ, “Bhʉlɨ, akʉbhala kʉyɨgoga? Khooni khe akʉtɨ, ‘Kwe ɨnkʉbhala ɨmwe mʉtangakhola kwɨnza’?” ");
INSERT INTO mgq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","UYeesu akhabhabhʉʉzya akhatɨ, “Ɨmwe mufumile paasɨ panaapa, ɨne imfumile kʉmwanya. Ɨmwe mwe bha mʉ nsɨ munuumu, ɨleelo ɨne te ne wa mʉ nsɨ ɨnɨ. ");
INSERT INTO mgq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ye nongwa nábhabhuziizye kʉtɨ mʉkhayɨfwɨla mu mbiibhi zyinyu. Ɨnga mʉtakwɨtɨkha kʉtɨ ɨne ne neene, mʉkhayɨfwɨla mu mbiibhi zyinyu.” ");
INSERT INTO mgq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pe bhakhamʉbhʉzɨɨlɨzya uYeesu bhakhatɨ, “Ɨwe we naanu?” UYeesu akhabhaamʉla akhatɨ, “Ɨne ne wʉ wʉʉla we nabhabhʉzyaga kufuma kʉwandɨlo. ");
INSERT INTO mgq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ɨndɨ ni nyinji ɨzya kʉlonga nɨ zya kʉbhalonga ɨmwe, ɨleelo ʉla we ansonteleziizye wa nalyoli, nɨɨne ɨnkʉbhabhʉʉzya abhantʉ abha mʉ nsɨ ziila zye inzyimvwizye kufuma kʉkwakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Abheene bhatakhazyaganya kʉtɨ uYeesu akhabhabhʉzyaga ɨzya Taata waakwe ʉwa kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pe uYeesu akhabhabhʉʉzya akhatɨ, “We mwamʉbhʉʉsya kʉmwanya ʉMwana wa Muntu, pe mʉkhayɨmanya kʉtɨ ɨne ne neene. Khabhɨlɨ mʉkhayɨmanya kʉtɨ ɨntakʉbhomba naazimo nʉmwene, lyoli ɨnkʉlonga zye ʉTaata waanɨ amanyiziizye. ");
INSERT INTO mgq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","We ansonteleziizye alɨ peeka nɨɨne, atandeshile, kʉnongwa ye insiku zyonti ɨnkʉbhomba zye zɨkʉmʉkhondezya.” ");
INSERT INTO mgq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Abhinji bhe bhímvwizye we uYeesu akʉlonga zɨnɨɨzyo, bhakhamwɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pe uYeesu akhabhabhʉʉzya aBhayahuudi bhaala bhe bhamwitishile akhatɨ, “Ɨnga mʉkʉgalema amazwi gaanɨ, mʉtɨbhe mwe bhalandati bhaanɨ nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pe mʉtɨwʉmanye uwanalyoli, woope uwanalyoli wʉtɨɨbhape ʉwʉsatʉlwe.” ");
INSERT INTO mgq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhoope bhakhamwamʉla bhakhatɨ, “Ɨtwe twe shɨkholo sha Abulahaamu. Te twe bhatumwa naalumo bha muntu wowonti. Khooni khe ʉkʉtɨ tʉtɨbhe twe bhasatʉlwe?” ");
INSERT INTO mgq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","UYeesu akhabhaamʉla akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we akʉjendeelela kʉbhomba imbiibhi, akʉbha mutumwa wi mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Umutumwa atakwɨkhala mu nyumba ya mwene waakwe insiku zyonti, lyoli ʉmwana wa mwene akwɨkhala insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pe ɨnga ʉMwana abhabhɨɨkha mʉ wʉsatʉlwe mʉtɨbhe mwe bhasatʉlwe nalyoli lyoli. ");
INSERT INTO mgq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Imanyile kʉtɨ ɨmwe mwe shɨkholo sha Abulahaamu, ɨleelo mʉkwanza kʉngoga, kʉnongwa ye mʉkʉkhaana kwɨtɨkha ɨmanyɨzyo zyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ɨne ɨnkʉlonga zye inzilolile kwa Taata waanɨ, ɨleelo ɨmwe mʉkʉbhomba zye mwimvwizye kwa taata wiinyu.” ");
INSERT INTO mgq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhoope bhakhamwamʉla bhakhatɨ, “Ʉtaata wɨɨtʉ wu Abulahaamu.” UYeesu akhabhaamʉla akhatɨ, “Ɨnga mʉbhanje mwe bhaana bha Abulahaamu, nhanɨ mʉkʉbhomba zye uAbulahaamu akhabhombaga. ");
INSERT INTO mgq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ɨleelo ishi mʉkwanza kʉngoga ɨne, ne imbabhuziizye uwanalyoli we nímvwizye kufuma kwa Mʉlʉngʉ. UAbulahaamu atábhombile anza she ɨmwe mʉkwanza kʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɨmbombo zye mʉkʉzɨbhomba mbombo zya Taata wiinyu.” ABhayahuudi bhaala bhakhamwamʉla uYeesu bhakhatɨ, “Ɨtwe te twe bhasoosi, lyoli tʉlɨ nʉ Taata weeka mwene ʉMʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","UYeesu akhabhaamʉla akhatɨ, “Ɨnga ʉMʉlʉngʉ abhanje wʉ Taata wiinyu, nhanɨ munganile ɨne. Kʉnongwa ye náfumile kwa Mʉlʉngʉ, ishi ɨndɨ ɨpa. Intinzile kʉ shɨgane shaanɨ, lyoli wʉʉyo ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Khooni khe mʉtakʉzyaganya zye ɨnkʉlonga? Kʉnongwa ye mʉtangakhola kʉtejeelezya amazwi gaanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɨmwe mwe bhaana bha taata wiinyu uSeetani, khabhɨlɨ mʉkwanza kʉbhomba ɨnsʉngʉkho zya taata wiinyu. Ʉweene mugoji kufuma kʉwandɨlo, atawuganile uwanalyoli, kʉnongwa ye uwanalyoli wʉtalɨɨpo mukaasi yaakwe. Ɨnga akʉlonga ɨlenga, yɨnɨɨyo ye mwata yaakwe, kʉnongwa ye ʉweene wɨ lenga, khabhɨlɨ we wʉ taata wɨ lenga. ");
INSERT INTO mgq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɨleelo kʉnongwa ye imbabhuziizye uwanalyoli mʉtakʉnɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wu naanu pakaasi yiinyu we angakhola kusimishizya kʉtɨ ɨne ɨndɨ ni mbiibhi? Ɨnga ɨnkʉlonga uwanalyoli, khooni khe mʉtakʉnɨɨtɨkha? ");
INSERT INTO mgq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Umuntu wowonti we wa Mʉlʉngʉ, akwɨtɨkha amazwi ga Mʉlʉngʉ. Ɨleelo ɨmwe mutakutinikha, kʉnongwa ye ɨmwe te mwe bhantʉ bha Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ABhayahuudi bhakhamwamʉla uYeesu bhakhatɨ, “Bhʉlɨ, tʉtakʉlonga zya nalyoli we tʉkʉtɨ ɨwe we Musamaliya na kʉtɨ ʉlɨ ni pepu ibhiibhi?” ");
INSERT INTO mgq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","UYeesu akhabhaamʉla akhatɨ, “Ɨne ɨntalɨ ni pepu ibhiibhi. Ɨne inkumushindikha ʉTaata waanɨ, ɨleelo ɨmwe mʉkʉnshoolanya. ");
INSERT INTO mgq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɨne ɨntakwanza kʉpaalwa na bhantʉ. Lyoli alɨɨpo we akwanza ɨmpaalwe, ʉweene we mulonji. ");
INSERT INTO mgq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we alitinikha izwi lyanɨ, te akhaafwe naalumo!” ");
INSERT INTO mgq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pe aBhayahuudi bhakhamʉbhʉʉzya uYeesu bhakhatɨ, “Ishi twamanya kʉtɨ nalyoli ʉlɨ ni pepu ibhiibhi! UAbulahaamu na bhakuwi bha Mʉlʉngʉ bháfuuye, ɨleelo ɨwe ʉkʉtɨ, ‘Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we alitinikha izwi lyanɨ, te akhaafwe naalumo!’ ");
INSERT INTO mgq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bhʉlɨ, ɨwe ʉkʉyɨbhɨɨkha kʉtɨ we mʉpɨtɨ kʉshɨla ʉmaama wɨɨtʉ uAbulahaamu? Ʉweene áfuuye, bhoope abhakuwi bháfuuye. Ɨwe ʉkʉyɨbhɨɨkha kʉtɨ we naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","UYeesu akhabhaamʉla akhatɨ, “Ɨnga ɨnkʉyɨpaala, kʉyɨpaala kwanɨ kʉtalɨ nɨ mbombo. ɄTaata waanɨ we ɨmwe mʉkʉtɨ wʉ Mʉlʉngʉ wiinyu, we akʉmpaala. ");
INSERT INTO mgq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Niishi bhʉʉlo mutamumanyile, ɨleelo ɨne imumanyile. Ɨnga natɨnjɨ intamumanyile, ɨntɨbhe ne wɨ lenga anzɨɨmwe. Ɨleelo ɨne imumanyile, khabhɨlɨ ɨnkʉlɨlema izwi lyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ʉmaama wiinyu uAbulahaamu áshiiye na kʉtomonhana kʉnongwa ye akhasʉbhɨlaga kʉtɨ angalɨlola isiku ɨlya kwɨnza kwanɨ, woope akhalɨlola, akhaseshela.” ");
INSERT INTO mgq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pe aBhayahuudi bhakhamʉbhʉʉzya bhakhatɨ, “Ɨwe ʉshɨɨlɨ kufisya amanha amashumi gasaanʉ, ʉkʉtɨ wámulolile uAbulahaamu?” ");
INSERT INTO mgq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","UYeesu akhabhaamʉla akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, we uAbulahaamu áshɨɨlɨ kʉpaapwa, ɨne ɨndɨɨpo.” ");
INSERT INTO mgq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","We aBhayahuudi bhɨmvwa zɨnɨɨzyo, bhakhasebha amawe kʉtɨ bhamʉkhome, ɨleelo uYeesu akhʉʉbha, akhafuma mwi linga ilyi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Isiku limo, uYeesu we akʉshɨla, akhamʉlola umuntu ʉmo we áfuuye amiiso kufuma apaapwe. ");
INSERT INTO mgq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abhalandati bhaakwe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Mumanyizyi, wu naanu we abhombile imbiibhi, muntu wʉnʉʉnʉ, awe bhapaafi bhaakwe, yikhafishila akhapaapwa afuuye amiiso?” ");
INSERT INTO mgq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","UYeesu akhabhaamʉla akhatɨ, “Umuntu ʉnʉ afuuye amiiso te kʉnongwa ɨya kʉtɨ ábhombile imbiibhi awe abhapaafi bhaakwe bhábhombile imbiibhi. Lyoli ápapiilwe afuuye amiiso ɨnga amakha ga Mʉlʉngʉ galoleshe kʉ bhantʉ mʉ wɨɨkhalo waakwe. ");
INSERT INTO mgq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tʉkwanzɨwa kʉbhomba ɨmbombo zyakwe we ánsonteleziizye, she mʉsanya. Uwusiku wʉkwɨnza, pe umuntu atangakhola kʉbhomba ɨmbombo. ");
INSERT INTO mgq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Akhabhalɨlo khe ɨndɨ mʉ nsɨ, ɨne ne lʉkhozyo kʉ bhantʉ bhonti.” ");
INSERT INTO mgq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","We alonga zɨnɨɨzyo, akhaswɨla amatɨ pa lusuuto, akhagomba ɨtope na matɨ, akhamʉpakha mu miiso umufwe amiiso. ");
INSERT INTO mgq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pe akhamʉbhʉʉzya akhatɨ, “Bhalaga ʉgeeze kumiiso mwɨ bwabho ɨlya Siloamu.” ISiloamu kwe kʉtɨ, “we bhamusonteleziizye.” Pe umufwe amiiso akhabhala, akhageeza kumiiso, akhagalʉkha akʉlola. ");
INSERT INTO mgq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pe abhapalamani bhaakwe na bhanjɨ bhe bhakhamʉlolaga kʉwandɨlo we akʉlabhɨɨlɨzya, bhakhabhʉzɨlɨzanya bhakhatɨ, “Bhʉlɨ, umuntu ʉnʉ te wʉ wʉʉla we ayɨkhalaga na kʉlabhɨɨlɨzya?” ");
INSERT INTO mgq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bhamu bhakhatɨ, “Wʉ wʉʉyo.” Ɨleelo bhamu bhakhatɨ, “Te wʉ wʉʉyo, lyoli akholiine nawo nhaani.” Ɨleelo we afuuye amiiso akhabhabhʉʉzya akhatɨ, “Neene!” ");
INSERT INTO mgq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Amiiso gaakho gandile bhʉlɨɨbhʉlɨ kʉlola?” ");
INSERT INTO mgq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ʉweene akhabhaamʉla akhatɨ, “Umuntu ʉla we bhakʉtɨ uYeesu, aagombile ɨtope anza ampakha mu miiso. Ambʉʉzya atɨ, ‘Bhalaga ʉgeeze kumiiso mwɨ bwabho ɨlya Siloamu.’ Pe anza naabhala, nageeza, nanda kʉlola.” ");
INSERT INTO mgq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Umuntu wʉnʉʉyo alɨ kwoshi?” Ʉweene akhabhaamʉla akhatɨ, “Maanyi!” ");
INSERT INTO mgq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pe abhantʉ bhaala bhakhamʉtwala ku Bhafalisaayi umuntu ʉla we kʉwandɨlo áfuuye amiiso. ");
INSERT INTO mgq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Isiku lye uYeesu ágombile ɨtope na kʉmʉponɨa umufwe amiiso ʉla lyámɨle lyɨ Sabaato. ");
INSERT INTO mgq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pe aBhafalisaayi bhoope bhakhamʉbhʉzɨɨlɨzya umuntu ʉla bhakhatɨ, “Amiiso gaakho gandile kʉlola bhʉlɨɨbhʉlɨ?” Akhabhaamʉla akhatɨ, “Umuntu wʉnʉʉyo aampashile ɨtope mu miiso, anza nageeza, ishi ɨnkʉlola.” ");
INSERT INTO mgq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pe aBhafalisaayi bhamu bhakhatɨ, “Umuntu wʉnʉʉyo atafumile kwa Mʉlʉngʉ kʉnongwa ye atakʉlandata ɨndajɨzyo zyɨ Sabaato.” Ɨleelo bhamu bhakhatɨ, “Ʉmʉbhomba mbiibhi angakhola bhʉlɨɨbhʉlɨ kʉbhomba ɨvɨlolesyo anza vɨnɨɨvwo?” Pe bhakhagabhʉnhana bhɨɨbho na bhɨɨbho. ");
INSERT INTO mgq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pe aBhafalisaayi bhakhamʉbhʉzɨɨlɨzya winza umuntu we áfuuye amiiso bhakhatɨ, “Ʉkʉmʉlola bhʉlɨɨbhʉlɨ umuntu wʉnʉʉyo we akuponiizye amiiso?” Ʉweene akhabhaamʉla akhatɨ, “Ɨne ɨnkʉmʉlola kʉtɨ mukuwi.” ");
INSERT INTO mgq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Abhalongozi abha Bhayahuudi bhatakhɨɨtɨkha kʉtɨ umuntu wʉnʉʉyo we ápapiilwe afuuye amiiso, ayanda kʉlola. Bhakhabhabhɨlɨshɨla abhapaafi bhaakwe, ");
INSERT INTO mgq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","bhakhabhabhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, ʉnʉ mwana wiinyu we mʉkʉtɨ ápapiilwe afuuye amiiso? Ishi ayandile bhʉlɨɨbhʉlɨ kʉlola?” ");
INSERT INTO mgq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abhapaafi bhaakwe bhakhabhaamʉla bhakhatɨ, “Tumanyile kʉtɨ ʉnʉ mwana wɨɨtʉ, khabhɨlɨ tumanyile kʉtɨ ápapiilwe afuuye amiiso. ");
INSERT INTO mgq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ɨleelo she ayandile kʉlola tutamanyile, poope umuntu we amuponiizye amiiso tutamumanyile. Mʉbhʉzɨɨlɨzye wʉʉyo, kʉnongwa ye muntu mʉsongo, angakhola kʉlonga wʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abhapaafi bhaakwe bhálonjile shɨnɨɨsho kʉnongwa ye bhábhogopile abhalongozi abha Bhayahuudi. Abhalongozi bhanaabho bhítinhiine kʉtɨ umuntu wowonti we akʉlaata kʉtɨ uYeesu wu Kilisiti, bhakʉmʉbhɨnga mwi sinagoogi. ");
INSERT INTO mgq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ye nongwa abhapaafi bhaakwe bhakhatɨ, “Mʉbhʉzɨɨlɨzye wʉʉyo, kʉnongwa ye muntu mʉsongo, angakhola kʉlonga wʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pe bhakhamʉbhɨlɨshɨla akha wʉbhɨlɨ umuntu ʉla we áfuuye amiiso kʉwandɨlo, bhakhamʉbhʉʉzya bhakhatɨ, “Longa uwanalyoli pamiiso ga Mʉlʉngʉ! Ɨtwe tumanyile kʉtɨ umuntu wʉnʉʉyo we akuponiizye mʉbhomba mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pe umuntu ʉla akhabhaamʉla akhatɨ, “Ɨne intamanyile kʉtɨ umuntu wʉnʉʉyo mʉbhomba mbiibhi, lyoli imanyile lyeka lyene, kʉtɨ naafuuye amiiso, ɨleelo ishi ɨnkʉlola.” ");
INSERT INTO mgq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pe bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Akʉbhombeeye lyoni? Akuponiizye bhʉlɨɨbhʉlɨ amiiso gaakho?” ");
INSERT INTO mgq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akhabhaamʉla akhatɨ, “Ɨne imbabhuziizye she ambombeeye, ɨleelo mʉtanzaga kwɨmvwa zye nalongaga. Khooni khe mʉkwanza ɨmbabhʉʉzye winza? Bhʉlɨ, nɨɨmwe bhʉʉlo mʉkwanza kʉbha mwe bhalandati bhaakwe?” ");
INSERT INTO mgq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pe abheene bhakhamuliga bhakhatɨ, “Ɨwe we mulandati waakwe! Ɨleelo ɨtwe twe bhalandati bha Moose. ");
INSERT INTO mgq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumanyile kʉtɨ ʉMʉlʉngʉ álonjile nʉ Moose, ɨleelo umuntu wʉnʉʉyo tutamanyile kwe afumile.” ");
INSERT INTO mgq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Umuntu ʉla akhabhaamʉla akhatɨ, “Ili lya kuswijizya nhaani! Ɨmwe mutamanyile kwe afumile, ɨleelo amponiizye amiiso gaanɨ! ");
INSERT INTO mgq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanyile kʉtɨ ʉMʉlʉngʉ atakʉbhatejeelezya abhi mbiibhi, lyoli akʉmʉtejeelezya wowonti we akumushindikha na kʉbhomba zye akwanza. ");
INSERT INTO mgq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kufuma pe ʉMʉlʉngʉ ápelile ɨnsɨ, tutimvwizye naalumo kʉtɨ umuntu amuponiizye umuntu we ápapiilwe afuuye amiiso. ");
INSERT INTO mgq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ɨnga umuntu wʉnʉʉnʉ atáfumile kwa Mʉlʉngʉ, nhanɨ ataakhola kʉbhomba lyolyonti.” ");
INSERT INTO mgq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Abheene bhakhamwamʉla bhakhatɨ, “Ɨwe wápapiilwe na kʉsʉngwa mu mbiibhi. Ʉngakhola bhʉlɨ kʉtʉmanyɨzya ɨtwe?” Pe bhakhamʉbhɨnga kʉtɨ afume mwi sinagoogi. ");
INSERT INTO mgq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","UYeesu akhɨmvwa kʉtɨ abhalongozi abha Bhayahuudi bhamubhinjile umuntu ʉla mwi sinagoogi. Akhabhala kʉmwanza, we amwaga, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ɨwe ʉkʉmwɨtɨkha ʉMwana wa Muntu?” ");
INSERT INTO mgq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Umuntu ʉla akhamwamʉla akhatɨ, “We mwene, mbʉʉzye ʉMwana wa Muntu wu naanu, ɨnga ɨmwɨtɨshe?” ");
INSERT INTO mgq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","UYeesu akhamwamʉla akhatɨ, “Wamʉlola, wʉ wʉʉnʉ we akʉlonga nɨɨwe ishi.” ");
INSERT INTO mgq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Umuntu ʉla akhatɨ, “Ɨnkwɨtɨkha, Mwene!” Pe akhasʉgamɨla pɨlongolela pa Yeesu na kumupuuta. ");
INSERT INTO mgq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","UYeesu akhatɨ, “Ɨne nínzile mʉ nsɨ kʉbhalonga abhantʉ, ɨnga bhe bhafuuye amiiso bhalolaje, bhaala bhe bhakʉlola, bhabhe bhafwe amiiso.” ");
INSERT INTO mgq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pe aBhafalisaayi bhamu bhe bhálɨɨpo paala bhakhɨmvwa amazwi ganaago, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, nɨɨtwe tufuuye amiiso?” ");
INSERT INTO mgq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","UYeesu akhabhaamʉla akhatɨ, “Ɨnga mwaafuuye amiiso, mʉtaamɨle mʉbhe ni mbiibhi. Ɨleelo ishi mʉkʉtɨ, ‘Tʉkʉlola,’ lɨnɨɨlyo lɨkʉlolesya kʉtɨ mʉlɨ she mwe bhi mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","UYeesu akhajendeelela kʉbhabhʉʉzya aBhafalisaayi akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, umuntu wowonti we atakwinjila mʉ mʉlyango ʉwa shibhijili shɨ ngoole, ɨleelo akʉshɨla apanjɨ, wʉnʉʉyo mwibha, khabhɨlɨ mufwuli. ");
INSERT INTO mgq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ɨleelo we akwinjila kʉshɨlɨla pa mʉlyango, wʉnʉʉyo we mudiimi wɨ ngoole. ");
INSERT INTO mgq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Umulindiilili ʉwa shibhijili akumwigulila, ɨngoole zɨkwɨmvwa izi lyakwe. Woope akʉzɨbhɨlɨshɨla ɨngoole zyakwe yeeka yeeka kwɨ taawa lyakwe na kʉzɨlongola kufuma kunzi. ");
INSERT INTO mgq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɨnga azifumwa kunzi, akʉlongolela kwɨlongolela, zyope zɨkʉmʉlandata kʉnongwa ye zilimanyile izi lyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɨleelo ɨngoole zɨtangakhola kʉmʉlandata umujeni, lyoli zɨkʉmʉshɨmbɨla kʉnongwa ye zitalimanyile izi lyakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","UYeesu ábhabhuziizye ɨshɨkholanyo ishi, ɨleelo abheene bhatakhazyaganya zye akhabhabhʉzyaga. ");
INSERT INTO mgq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pe uYeesu akhabhabhʉʉzya winza akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, ɨne ne mʉlyango ʉwɨ ngoole. ");
INSERT INTO mgq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhonti bhe bhantangʉlɨɨye bhiibha, khabhɨlɨ bhafwuli, ɨleelo ɨngoole zɨtakhabhatejeelezya. ");
INSERT INTO mgq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɨne ne mʉlyango. Wowonti we akwinjila mu shibhijili kʉshɨlɨla kʉkwanɨ, akhayɨtʉʉlwa, khabhɨlɨ atɨbhe mʉsatʉlwe kwinjila na kufuma ɨnga awaaje ʉwʉsole winza. ");
INSERT INTO mgq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umwibha akwɨnza kʉnongwa ɨya kwibha, kʉgoga na kʉnanganya. Ɨleelo ɨne ininzile ɨnga bhabhe nu wuumi, khabhɨlɨ bhabhe nawo ku winji. ");
INSERT INTO mgq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ɨne ne mudiimi umwinza. Umudiimi umwinza akuyifumwa kufwa kʉnongwa yɨ ngoole zyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Umuntu we akʉsʉʉbhɨla kʉposheela te mudiimi, khabhɨlɨ ɨngoole te shʉʉma shaakwe. Ye nongwa ɨnga ayɨlola ɨmbwa ɨya mwɨ laala yɨkwɨnza, akʉzɨlekha ɨngoole akʉshɨmbɨla. Pe ɨmbwa ɨya mwɨ laala yɨkʉzɨlema zimo na kʉzɨsataanya ɨzyamwabho. ");
INSERT INTO mgq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ʉweene atakʉsaajɨla naakhamu kʉ zyɨ ngoole, kʉnongwa ye ʉweene wa kʉposheela. ");
INSERT INTO mgq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ɨne ne mudiimi umwinza. Inzimanyile ɨngoole zyanɨ, zyope zimanyile ɨne, ");
INSERT INTO mgq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","anza she ʉTaata waanɨ amanyile ɨne, nɨɨne she imumanyile ʉweene. Nɨɨne injifumwizye kufwa kʉnongwa yɨ ngoole. ");
INSERT INTO mgq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ɨndɨ nɨ ngoole izinji zye te zya mu shibhijili ishi, zyope ɨnhondeeye kʉzɨleeta. Zyope zɨtɨlyɨmvwe izi lyanɨ. Pe kʉtɨbhe nɨ mpʉga yeeka nu mudiimi weeka. ");
INSERT INTO mgq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ɄTaata waanɨ anganile kʉnongwa ye inkuyifumwa kufwa, ɨnga ɨngwaje uwuumi winza. ");
INSERT INTO mgq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Atalɨɨpo umuntu we angakhola kʉfwʉla uwuumi waanɨ, lyoli inkuwufumwa kʉ shɨgane shaanɨ nʉneene. Ɨndɨ nʉ waamʉlo ʉwa kuwufumwa uwuumi waanɨ, khabhɨlɨ ɨndɨ nʉ waamʉlo ʉwa kʉweega winza. Shiniishi she ʉTaata waanɨ andajiziizye kʉbhomba.” ");
INSERT INTO mgq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","We bhɨmvwa amazwi ganaago, aBhayahuudi bhakhagabhʉnhana winza. ");
INSERT INTO mgq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abhinji mukaasi yaabho bhakhatɨ, “Wʉnʉʉnʉ alɨ na mapepu amabhiibhi, khabhɨlɨ gamulalusiizye, mutamutejelezyaje.” ");
INSERT INTO mgq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɨleelo bhamu bhakhatɨ, “Ganaago te mazwi ga muntu we alɨ na mapepu amabhiibhi. Bhʉlɨ! Ipepu ibhiibhi lɨngakhola kʉbhaponɨa abhafwe amiiso?” ");
INSERT INTO mgq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pe akhabhalɨlo akhi shikulukulu ɨsha kwinjizya iNyumba iMfinjile mu Yelusaleemu khakhafikha. Akhabhalɨlo khanaakho kháamɨle khi mpepu. ");
INSERT INTO mgq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mʉ khabhalɨlo khanaakho, uYeesu akhajendaga mwi linga ilyi Nyumba iMfinjile mwɨ dala itimiilile ɨlya Selemaani. ");
INSERT INTO mgq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","We aBhayahuudi bhamu bhamʉlola uYeesu, bhakhamʉsyeta na kʉmʉbhʉzɨɨlɨzya kʉtɨ, “Bhʉlɨ, ʉtɨtweleelezye amooyo gɨɨtʉ paka liino? Ɨnga ɨwe we Kilisiti, tʉbhʉʉzye apazelu.” ");
INSERT INTO mgq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ɨleelo uYeesu akhabhaamʉla akhatɨ, “Imbabhuziizye kʉtɨ ne naanu, ɨleelo ɨmwe mʉtakwɨtɨkha. Ɨmbombo zye ɨnkʉzɨbhomba kwɨ taawa lya Taata waanɨ zikufumwa uwukeeti. ");
INSERT INTO mgq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɨleelo ɨmwe mʉtakwɨtɨkha kʉnongwa ye ɨmwe te mwe mpʉga yɨ ngoole zyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɨngoole zyanɨ zilimanyile izi lyanɨ. Ɨne inzimanyile, zyope zɨkʉndandata. ");
INSERT INTO mgq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ɨne ɨnkʉʉbhapa uwuumi ʉwa wiila na wiila, bhoope te bhakhateeje naalumo. Khabhɨlɨ atalɨɨpo umuntu we angakhola kʉbhafwʉla kufuma mʉ nyoobhe zyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ɄTaata waanɨ we ampiiye bhanaabho alɨ na makha kʉshɨla bhonti. Pe shɨnɨɨsho atalɨɨpo umuntu we angakhola kʉbhafwʉla mʉ nyoobhe zyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ɨne nʉ Taata waanɨ tʉlɨ nʉ wʉpeeka.” ");
INSERT INTO mgq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pe aBhayahuudi bhakhasebha amawe winza ɨnga bhamʉkhome nago. ");
INSERT INTO mgq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ɨleelo uYeesu akhabhabhʉʉzya akhatɨ, “Imbalanjile ɨmbombo inyinji inyinza kʉ makha ga Taata waanɨ. Bhʉlɨ, mbombo yilikwi ye yɨkʉbhabhɨɨkha kʉtɨ mʉnhome na mawe?” ");
INSERT INTO mgq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ABhayahuudi bhakhamwamʉla bhakhatɨ, “Tʉtakʉkʉkhoma na mawe kʉnongwa ɨyɨ mbombo inyinza zye ubhombile, lyoli kʉnongwa ye ʉkʉmʉshoolanya ʉMʉlʉngʉ. Ɨwe ʉkʉyɨtekha kʉtɨ we Mʉlʉngʉ we ɨwe we muntu bhʉʉlo!” ");
INSERT INTO mgq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, yitasimbiilwe mu Wusimbe uWufinjile kʉtɨ ʉMʉlʉngʉ átɨlɨ, ‘Ɨmwe mwe bhamʉlʉngʉ’? ");
INSERT INTO mgq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ɄMʉlʉngʉ ábhateshile kʉtɨ bha bhamʉlʉngʉ, bhaala bhe izwi lya Mʉlʉngʉ lyábhafishiiye, woope uWusimbe uWufinjile wʉtangakhola kuvunzikha. ");
INSERT INTO mgq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Khabhɨlɨ mʉngakhola bhʉlɨɨbhʉlɨ kʉlonga kʉtɨ ʉla we ʉTaata ámʉsabhʉʉye na kʉmʉsonteelezya mʉ nsɨ umu, akʉshoolanya kʉnongwa ye álonjile kʉtɨ, ‘Ɨne ne Mwana wa Mʉlʉngʉ’? ");
INSERT INTO mgq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ɨnga ɨntakʉbhomba ɨmbombo zya Taata waanɨ, mʉtanɨtɨkhaje. ");
INSERT INTO mgq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ɨleelo ɨnga ɨnkʉbhomba ɨmbombo zya Mʉlʉngʉ, poope ɨnga mʉtanɨɨtɨkha ɨne, zyitikhaji ɨmbombo zɨnɨɨzyo, ɨnga mʉmanye na kʉzyaganya kʉtɨ ʉTaata alɨ mukaasi yaanɨ, nɨɨne ɨndɨ mukaasi yaakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pe bhakhalɨnjɨzya kʉmʉlema winza, ɨleelo uYeesu akhapulumukha mʉ nyoobhe zyabho. ");
INSERT INTO mgq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pe uYeesu akhabhala winza kwɨsyɨla ɨya lwizi ʉlwa Yoolodani, akhafikha pe uYookhani akhozyaga kʉwandɨlo, akhɨɨkhala kʉnʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abhantʉ abhinji bhakhɨnza kʉkwakwe na kʉlonga kʉtɨ, “UYookhani atábhombile ɨshɨlolesyo shoshonti, ɨleelo zyonti zye uYookhani álonjile kʉ zya muntu ʉnʉ zya nalyoli.” ");
INSERT INTO mgq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pe abhantʉ abhinji bhe bhálɨɨpo paala bhakhamwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Álɨɨpo umuntu ʉmo ɨtaawa lyakwe bhakhatɨnjɨ ʉLaazalo, áamɨle mubhinu. Umuntu wʉnʉʉyo akhɨkhalaga mʉ nhaaya ɨya mu Besaniya peeka na bhayɨlʉmbʉ bhaakwe uMaliya nu Malita. ");
INSERT INTO mgq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","UMaliya wʉnʉʉyo we ámupashile ʉMwene uYeesu amafuta ge gakununshiilila na kʉmʉpʉʉpʉla mʉ vɨnama ni nsisi zyakwe. Ʉkhambakʉ waakwe ʉLaazalo áamɨle mubhinu. ");
INSERT INTO mgq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pe uMaliya nu Malita bhakhasonteelezya intumi kwa Yeesu bhakhatɨ, “We Mwene, umanyani waakho we umuganile mubhinu.” ");
INSERT INTO mgq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","We uYeesu ayɨmvwa intumi zɨnɨɨzyo, akhatɨ, “Uwubhinu wʉnʉʉwo te wa kʉmʉgoga ʉLaazalo, lyoli wa kʉlolesya uwumwamu wa Mʉlʉngʉ, ɨnga ʉMwana wa Mʉlʉngʉ apaalwe kwɨ dala ɨlya wubhinu wʉnʉʉwo.” ");
INSERT INTO mgq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","UYeesu ábhaganile uMalita, uMaliya, nʉ Laazalo ʉkhambakʉ waabho. ");
INSERT INTO mgq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","We uYeesu ayɨmvwa kʉtɨ ʉLaazalo mubhinu, akhajendeelela kwɨkhala insiku zɨbhɨlɨ papaala pe áamɨle. ");
INSERT INTO mgq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pe uYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Saalɨ winza mʉ nsɨ ɨya mu Yudeeya.” ");
INSERT INTO mgq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abhalandati bhaakwe bhakhamwamʉla bhakhatɨ, “We Mumanyizyi, shiniishi bhʉʉlo aBhayahuudi bhanzaga kʉkʉkhoma na mawe! Khooni khe ʉkwanza kʉgalʉkha winza kʉʉkwo?” ");
INSERT INTO mgq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, ʉmʉsanya wʉtalɨ nɨ saala ishumi na zɨbhɨlɨ? Ɨnga umuntu akʉjenda mʉ khabhalɨlo khanaakho, atangakhola kukuntila, kʉnongwa ye akʉlola ʉlʉkhozyo ʉlwa mʉ nsɨ umu. ");
INSERT INTO mgq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɨleelo umuntu we akʉjenda shawusiku, angakhola kukuntila kʉnongwa ye ʉlʉkhozyo ʉlwa kʉmwavwa kʉlola akhinza lʉtalɨɨpo.” ");
INSERT INTO mgq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","We uYeesu alonga zɨnɨɨzyo, akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Umanyani wɨɨtʉ ʉLaazalo agonile, ɨleelo ɨntɨbhale kʉmʉdaamʉsya.” ");
INSERT INTO mgq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pe abhalandati bhaakwe bhakhamʉbhʉʉzya bhakhatɨ, “Mwene, ɨnga agonile utulo, atɨpone.” ");
INSERT INTO mgq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ɨleelo abhalandati bhaakwe bhatakhazyaganyaaga. Abheene bhakhasɨɨbhaga kʉtɨ akhalongaga kʉtɨ ʉLaazalo agonile utulo, fwanɨ uYeesu ɨpa akhalongaga kʉtɨ ʉLaazalo afuuye. ");
INSERT INTO mgq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pe uYeesu akhabhavundulila abhalandati bhaakwe akhatɨ, “ɄLaazalo afuuye. ");
INSERT INTO mgq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɨleelo ɨne naseshela kʉnongwa yiinyu kʉtɨ ɨntaalɨɨpo we ʉLaazalo akufwa, ɨnga ɨmwe mʉnɨɨtɨshe. Ishi, saalɨ kʉkwakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pe uToomasi we bhakhatɨnjɨ ʉMwoga, akhabhabhʉʉzya abhalandati abhamwabho akhatɨ, “Saalɨ nɨɨtwe, ɨnga tufwe peeka nawo.” ");
INSERT INTO mgq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pe uYeesu we aafikha mu Yudeeya mʉ khakhaaya akha mu Besaniya, akhaaga ʉLaazalo aamala insiku zini mʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ɨnhaaya ɨya mu Besaniya yáamɨle papɨɨpɨ ni Yelusaleemu, uwutali uwi kilomiita zɨtatʉ. ");
INSERT INTO mgq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abhantʉ abhinji kufuma mu Bhayahuudi bhínzile kubhajinjizya uMalita nu Maliya kʉnongwa ɨya kʉfwɨlwa nʉ khambakʉ waabho ʉLaazalo. ");
INSERT INTO mgq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pe uMalita we ayɨmvwa kʉtɨ uYeesu akwɨnza, akhafuma kʉbhala kʉmʉposheela, ɨleelo uMaliya akhasyala mu nyumba. ");
INSERT INTO mgq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","UMalita akhamʉbhʉʉzya uYeesu akhatɨ, “We Mwene, ɨnga ʉbhanje panaapa, ʉkhambakʉ waanɨ nhanɨ ataafuuye. ");
INSERT INTO mgq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ɨleelo niishi bhʉʉlo imanyile kʉtɨ ʉMʉlʉngʉ atiikupe khokhonti khe ʉtɨmʉlaabhe.” ");
INSERT INTO mgq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Pe uYeesu akhamwamʉla uMalita akhatɨ, “Ʉkhambakʉ waakho atɨzyʉshe.” ");
INSERT INTO mgq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","UMalita akhamwamʉla akhatɨ, “Imanyile kʉtɨ akhayɨzyʉkha akhabhalɨlo khe abhafwe bhakhayɨzyʉkha pi siku ɨlya kʉmpeleela.” ");
INSERT INTO mgq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","UYeesu akhamʉbhʉʉzya uMalita akhatɨ, “Ɨne ne ɨnkʉbhazyʉsya abhantʉ na kʉʉbhapa ʉwʉpʉʉma. Umuntu wowonti we akʉnɨɨtɨkha ɨne, poope ɨnga aafwa, atɨjendeelele kʉbha mʉpʉʉma. ");
INSERT INTO mgq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wowonti we mʉpʉʉma, na kʉnɨɨtɨkha ɨne, te akhaafwe naalumo. We Malita, bhʉlɨ, ʉkʉzyɨtɨkha zɨnɨɨzyo?” ");
INSERT INTO mgq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","UMalita akhamwamʉla akhatɨ, “Nalyoli Mwene, nɨɨtɨkha kʉtɨ ɨwe we Kilisiti, ʉMwana wa Mʉlʉngʉ, we twagʉlɨlaga kʉtɨ akhayɨnza mʉ nsɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","We uMalita alonga ganaago, akhabhala kʉmʉbhɨlɨshɨla ʉyɨlʉmbʉ waakwe uMaliya kukwilu. Akhamʉbhʉʉzya akhatɨ, “UMumanyizyi alɨɨpo panaapa, akʉkʉbhɨlɨshɨla.” ");
INSERT INTO mgq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","UMaliya we ayɨmvwa zɨnɨɨzyo, akhabhʉʉkha nalʉbhɨlo, akhabhala kwa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","UYeesu áshɨɨlɨ kwinjila mʉ nhaaya ɨya mu Besaniya, lyoli áamɨle she alɨ paala pe uMalita ábhalile kʉmʉposheela. ");
INSERT INTO mgq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","We aBhayahuudi bhe bhakhamujinjizyaga uMaliya mu nyumba bhamʉlola akwɨmɨɨlɨla na kufuma kunzi, bhakhamʉlandata. Bhakhasɨɨbhaga kʉtɨ uMaliya aabhala kʉ mbɨɨpa kʉlɨla. ");
INSERT INTO mgq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","We uMaliya aafikha paala pe uYeesu áamɨle, akhasʉgamɨla pa vɨnama vwakwe, akhamʉbhʉʉzya akhatɨ, “We Mwene, ɨnga ʉbhanje panaapa, ʉkhambakʉ waanɨ nhanɨ atafuuye.” ");
INSERT INTO mgq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","We uYeesu amʉlola uMaliya akʉlɨla na Bhayahuudi bhe bhinzile nawo bhoope bhakʉlɨla, akhaswɨmɨɨlɨla nhaani mʉ mwoyo waakwe. ");
INSERT INTO mgq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pe akhabhabhʉzɨɨlɨzya akhatɨ, “Mwaamʉsyɨlɨɨye kwoshi?” Bhakhamwamʉla bhakhatɨ, “We Mwene, saalɨ tʉkʉlanje pe twaamʉsyɨlɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","UYeesu akhalɨla amansozi. ");
INSERT INTO mgq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pe aBhayahuudi bhe bhínzile pa mpʉngo bhakhalonga bhakhatɨ, “Yeenya she uYeesu aamuganile ʉLaazalo!” ");
INSERT INTO mgq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɨleelo bhamu bhakhalonga bhakhatɨ, “Umuntu wʉnʉʉnʉ we ámuponiizye umufwe amiiso, pe khooni atakholile kudinda kʉtɨ ʉLaazalo ataafwe?” ");
INSERT INTO mgq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","UYeesu we alɨ mu wuswimiilizu mʉ mwoyo waakwe, akhafikha pa mbɨɨpa. Ɨmbɨɨpa yɨnɨɨyo yáamɨle ngwenya ye bhágubishiiye ni we ɨpɨtɨ ku winjiililo. ");
INSERT INTO mgq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","UYeesu akhabhabhʉʉzya abhantʉ bhe bhálɨɨpo paala akhatɨ, “Libhungulusye iwe lɨnɨɨlyo lye lɨlɨ pa winjiililo.” UMalita, ʉyɨlʉmbʉ wa muyazi, akhamwamʉla akhatɨ, “Mwene, kʉ khabhalɨlo ɨkha ivimba lɨtɨbhe lyandile kununha, kʉnongwa ye zyashɨla insiku zini kwandɨla pe twaamʉsyɨlɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","UYeesu akhamʉbhʉʉzya akhatɨ, “Bhʉlɨ, intakubhuziizye kʉtɨ ɨnga wɨɨtɨkha, ʉtɨwʉlole uwumwamu wa Mʉlʉngʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pe bhakhalibhungulusya iwe liila. UYeesu akheenya kʉmwanya, akhapuuta akhatɨ, “We Taata waanɨ, inkukusalifwa kʉnongwa ye waposheela impuuto zyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Imanyile kʉtɨ ɨwe ʉkʉnɨmvwa akhabhalɨlo khonti, ɨleelo ɨnkʉlonga ganaaga kʉnongwa ɨya bhantʉ ɨbha bhe bhalɨɨpo ɨpa, ɨnga bhɨɨtɨshe kʉtɨ ɨwe we unsonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","We uYeesu alonga ganaago, akhabhɨlɨshɨla kwi zi ɨlya kʉdandɨzya akhatɨ, “We Laazalo, fuma kunzi!” ");
INSERT INTO mgq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pe ʉLaazalo we áfuuye, akhafuma kunzi, kumo bhamusyembile ikibha mʉ vɨnama na mʉ nyoobhe. Khabhɨlɨ bhamugubishiiye ni kibha kumiiso. UYeesu akhabhabhʉʉzya akhatɨ, “Mʉsatʉle, mʉleshe, asogolaje.” ");
INSERT INTO mgq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pe aBhayahuudi abhinji bhe bhínzile kumujinjizya uMaliya we bhazɨlola zye uYeesu azɨbhomba, bhakhamwɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ɨleelo aBhayahuudi bhamu bhakhabhala ku Bhafalisaayi na kʉbhabhʉʉzya zye uYeesu abhombile. ");
INSERT INTO mgq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pe abhapɨtɨ abha bhapuutili na Bhafalisaayi bhakhabhʉngaana ʉlʉbhʉngaano ʉlwɨ balaaza ɨlya bhasongo, bhakhabhʉzɨlɨzanya bhɨɨbho na bhɨɨbho bhakhatɨ, “Tʉbhombe lyoni? Kʉnongwa ye umuntu ʉnʉ akʉbhomba ɨvɨlolesyo ivwinji. ");
INSERT INTO mgq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ɨnga twamʉlekha bhʉʉlo, abhantʉ bhonti bhatɨmwɨtɨshe, bhoope aBhaluumi bhakhayɨnza kʉnanganya iNyumba iMfinjile nɨ nsɨ yɨɨtʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pe weeka mʉ bhapɨtɨ bhanaabho we ɨtaawa lyakwe bhakhatɨnjɨ ʉKayaafa, we áamɨle mupuutili mʉpɨtɨ ʉmwanha wʉnʉʉwo, akhatɨ, “Ɨmwe mutamanyile naakhamu! ");
INSERT INTO mgq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bhʉlɨ, mutamanyile kʉtɨ kwashi kukwinyu umuntu weeka afwe kʉnongwa ya bhantʉ bhonti na kʉtɨ ɨnsɨ yonti yɨyazwe?” ");
INSERT INTO mgq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ɄKayaafa atálonjile zɨnɨɨzyo kʉ shɨgane shaakwe wʉʉyo. Lyoli kʉnongwa ye áamɨle mupuutili mʉpɨtɨ mʉ mwanha wʉnʉʉwo, akhakʉwaaga kʉtɨ uYeesu akhayifwa kʉnongwa ɨya Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Khabhɨlɨ te akhaafwe kʉnongwa ɨya Bhayahuudi bheene, lyoli kʉnongwa ɨya bhaana bha Mʉlʉngʉ bhe bhasataanile, ɨnga bhabhe peeka. ");
INSERT INTO mgq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pe kwandɨla isiku lɨnɨɨlyo, abhalongozi abha Bhayahuudi bhakhanda kwanza ɨdala ɨlya kʉmʉgoga uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kʉnongwa yɨnɨɨyo, uYeesu akhalekha kʉjenda apazelu mu Bhayahuudi, pe akhasogola na kʉbhala papɨɨpɨ ni shilozu, mʉ nhaaya ɨya mu Efulayimu. Akhɨɨkhala kʉnʉʉkwo peeka na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ishikulukulu ɨshɨ Pasaaka ɨya Bhayahuudi shápalamɨɨye. Pe abhantʉ abhinji bhakhafuma mʉ nhaaya zyabho bhakhabhala mu Yelusaleemu ɨnga bhayizelufwe we ishikulukulu shɨshɨɨlɨ kufikha. ");
INSERT INTO mgq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe bhakhajendeelela kʉmwanza uYeesu. We bhabhungaanile peeka mwi linga ilyi Nyumba iMfinjile, bhakhanda kʉbhʉzɨlɨzanya bhakhatɨ, “Mʉkʉlola bhʉlɨɨbhʉlɨ? Yɨkʉlolekha kʉtɨ te ayɨnze ku shikulukulu, bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abhapɨtɨ abha bhapuutili na Bhafalisaayi bhálajiziizye kʉtɨ umuntu wowonti we amanyile kwe uYeesu alɨ, abhabhʉʉzye ɨnga bhamʉleme. ");
INSERT INTO mgq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","We insiku ʉmʉtanda zɨshɨɨlɨ kʉkwɨla ɨnga kʉbhe ni shikulukulu ɨshɨ Pasaaka, uYeesu akhabhala mu Besaniya, ɨnhaaya ye akhɨkhalaga ʉLaazalo. Wʉnʉʉyo we uYeesu ámuzyusiizye kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pe bhakhamʉlɨnganɨzanya ishaakulya ɨsha lyabheela, uMalita akhabhavwaga. ɄLaazalo áamɨle peeka mʉ bhe bhakhalyanga ishaakulya pa shintalati peeka nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pe uMaliya akheega akhasupa akha mafuta agɨ nhela ɨmpɨtɨ ge gakununshiilila, akhamʉpakha uYeesu mʉ vɨnama na kʉgasyʉmʉla ku nsisi zyakwe. Inyumba yonti yikhiizula umununsi ʉwa mafuta. ");
INSERT INTO mgq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pe ʉYʉʉda Sikalioti, weeka mu bhalandati bhaakwe ishumi na bhabhɨlɨ, we akhayɨmʉlonjeelela uYeesu, akhalonga akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Khooni khe amafuta ganaago gatakazwaga ku dinaali imia zɨtatʉ (300) na kʉʉbhapa abhapɨɨna?” ");
INSERT INTO mgq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ɄYʉʉda álonjile shɨnɨɨsho te kʉnongwa ɨya kʉbhasaajɨla abhapɨɨna, lyoli kʉnongwa ye áamɨle mwibha. Ʉweene we akhabhɨɨkhaga imbuguuli ɨyɨ nhela, akhabhalɨlo akhinji akhiibhaga ɨnhela zye zyámɨle mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pe uYeesu akhatɨ, “Mʉtamʉyɨmvwaje ʉmwantanda ʉnʉ, mʉmʉleshe, agabhɨɨshe amafuta ganaago kʉnongwa iyi siku ɨlya kʉsyɨlwa kwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abhapɨɨna mʉlɨ nabho kukwinyu insiku zyonti, ɨleelo ɨne te ɨmbe peeka nɨɨmwe insiku zyonti.” ");
INSERT INTO mgq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ABhayahuudi abhinji bhakhɨmvwa kʉtɨ uYeesu alɨ mu Besaniya. Pe bhakhafikha kʉnʉʉkwo te kʉmʉlola uYeesu mwene, lyoli kʉtɨ bhamʉlole nʉ Laazalo we uYeesu amuzyusiizye kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pe abhapɨtɨ abha bhapuutili bhakhanza ɨdala ɨlya kʉmʉgoga ʉLaazalo woope. ");
INSERT INTO mgq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kʉnongwa iyi ntumi ɨzya kʉzyʉkha kwa Laazalo, aBhayahuudi abhinji bhakhalekha kʉbhalandata abhalongozi bhaabho, bhakhamwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɨndaabhɨ yaakwe, ɨmpʉga ɨmpɨtɨ ɨya bhantʉ ye yɨkhɨnzaga ku shikulukulu ɨshɨ Pasaaka yɨkhɨmvwa kʉtɨ uYeesu alɨ mwɨ dala kwɨnza mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pe bhakheega ɨmpaaswa ɨzya makwi aga matende, bhakhafuma kʉbhala kʉmʉposheela uYeesu. Bhakhalongaga kwi zi ɨlya kʉdandɨzya kʉtɨ, “Apalwaje ʉMʉlʉngʉ! Asayiilwe we akwɨnza kwɨ taawa lya Mwene ʉMʉlʉngʉ! Asayiilwe ʉMwene ʉwa Bhaisilaeli.” ");
INSERT INTO mgq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pe uYeesu akhayaaga ɨnyaana yi ndogomi, akhayɨpanda anza she yisimbiilwe mu Wusimbe uWufinjile kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ʉtogopaje wʉmʉlɨndʉ ʉwa mʉ nhaaya ɨya mu Sayuuni! Yeenya, ʉMwene waakho akwɨnza, ayɨkhaaye pa nyaana yi ndogomi!” ");
INSERT INTO mgq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kʉ khabhalɨlo khanaakho, abhalandati bha Yeesu bhatakhazyaganya zɨnɨɨzyo. Ɨleelo pɨlongolela, ʉMʉlʉngʉ ámuzyusiizye uYeesu kwɨ dala lye lyámʉleteeye uwumwamu. Pe abhalandati bhaakwe bhakhakʉmbʉkha kʉtɨ zɨnɨɨzyo zisimbiilwe kʉnongwa yaakwe, na kʉtɨ abhantʉ bhámʉbhombeeye shɨnɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɨmpʉga ɨya bhantʉ ye yáamɨle peeka nu Yeesu we akhamʉbhɨlɨshɨlaga ʉLaazalo kufuma mʉ mbɨɨpa, na kʉmʉzyʉsya kufuma kʉ bhafwe, yikhafumwaga uwukeeti kʉ bhantʉ zye yázilolile na kwɨmvwa. ");
INSERT INTO mgq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pe abhantʉ abhinji bhakhabhala kʉmʉposheela uYeesu kʉnongwa ye bhonti bhímvwizye kʉ zya shɨlolesyo she ábhombile. ");
INSERT INTO mgq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pe aBhafalisaayi we bhaalola zɨnɨɨzyo, bhakhabhʉʉzanya bhakhatɨ, “Mwalola? Tʉtangabhomba lyolyonti! Yeenya, abhantʉ bhonti bhakʉmʉlandata ʉweene.” ");
INSERT INTO mgq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mʉ bhantʉ bhe bhábhalile kupuuta mʉ khabhalɨlo akhi shikulukulu ɨshɨ Pasaaka, bhálɨɨpo bhamu na bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Abhantʉ bhanaabho bhakhabhala kwa Filipo we áamɨle mʉkhaaya wa mʉ nhaaya ɨya mu Betisayida mʉ nsɨ ɨya kʉ Galɨlaaya, bhakhamʉlaabha bhakhatɨ, “We mwene, tʉkʉlaabha tʉmʉlole uYeesu.” ");
INSERT INTO mgq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","UFilipo akhabhala kʉmʉbhʉʉzya ʉAndeleeya, bhonti bhabhɨlɨ bhakhabhala kʉmʉbhʉʉzya uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","UYeesu akhabhaamʉla akhatɨ, “Akhabhalɨlo khaafikha akha Mwana wa Muntu kʉposheela uwumwamu. ");
INSERT INTO mgq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nalyoli ɨnkʉbhabhʉʉzya kʉtɨ, imbeyu ɨyɨ ngano yɨkʉsyala she mbeyu, lyoli ɨnga yalenda pa lusuuto na kufwa. Ɨnga yaafwa, pe yɨkʉmela na kʉpaapa amatunda aminji. ");
INSERT INTO mgq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","She shɨnɨɨsho, umuntu wowonti we awuganile uwuumi waakwe, atɨwʉteezye, ɨleelo we akuwuviitilwa uwuumi waakwe mʉ nsɨ umu, akhayɨwʉpokha na kʉwaaga uwuumi ʉwa wiila na wiila. ");
INSERT INTO mgq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Umuntu wowonti we akʉmbombela ɨne, andandataje. Poponti pe ɨne ɨndɨ nu mubhombi waanɨ akhayɨbha. Umuntu wowonti we akʉmbombela, ʉTaata waanɨ atimushindishe. ");
INSERT INTO mgq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ishi ʉmwoyo waanɨ wʉswɨmɨlɨɨye. Ɨndonje ɨntɨ bhʉlɨ? Bhʉlɨ, ɨntɨ, ‘We Taata, ɨnkʉkʉlaabha ʉntʉʉle mʉ khabhalɨlo ɨkha akha mayɨmba’? Ɨleelo intangapuuta shɨnɨɨsho, kʉnongwa ye ininzile ɨnga ɨnshɨlɨle mʉ khabhalɨlo ɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","We Taata, ʉlɨmwamɨshe ɨtaawa lyakho.” Pe izi kufuma kʉmwanya kwa Mʉlʉngʉ lɨkhatɨ, “Nalɨmwamɨkha, khabhɨlɨ ɨntɨlɨmwamɨshe winza.” ");
INSERT INTO mgq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pe ɨmpʉga ɨya bhantʉ bhe bhálɨɨpo paala bhakhɨmvwa izi, bhamu bhakhatɨ, “Ɨlyo lizi lyi nguluguuto ɨya kʉtalalʉkha.” Bhamu bhakhatɨ, “Wʉ khabhɨzya alongaga nawo.” ");
INSERT INTO mgq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɨleelo uYeesu akhabhabhʉʉzya akhatɨ, “Izi lye mwalyɨmvwaga lɨtaamɨle lya kʉnongwa yaanɨ, lyoli kʉnongwa yiinyu. ");
INSERT INTO mgq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ishi akhabhalɨlo akha kʉlongwa ɨnsɨ khaafikha. Ishi uSeetani, ʉmʉpɨtɨ ʉwa mʉ nsɨ umu, atɨsʉmbwe kunzi. ");
INSERT INTO mgq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ɨleelo ɨne we bhanzʉvwa, ɨnhayɨbhakwesa abhantʉ bhonti bhɨnze kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","UYeesu álonjile shɨnɨɨsho kʉlolesya uwufwe we akhayifwa. ");
INSERT INTO mgq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pe ɨmpʉga ɨya bhantʉ yɨkhamwamʉla yɨkhatɨ, “Tubhaziizye mu Wusimbe uWufinjile kʉtɨ uKilisiti atɨjendeelele kʉbha mwumi wiila na wiila. Ishi ʉkʉlonga bhʉlɨɨbhʉlɨ kʉtɨ bhatɨmʉzʉvwe ʉMwana wa Muntu? ɄMwana wa Muntu wu naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","UYeesu akhabhabhʉʉzya akhatɨ, “Ʉlʉkhozyo lʉlɨ peeka nɨɨmwe kʉ khabhalɨlo khashe bhʉʉlo. Jendaji mʉ lʉkhozyo lʉnʉʉlwo she lʉlɨɨpo, ɨnga akhiisi khatakhashe khabhatole, kʉnongwa ye umuntu we akʉjenda mu khiisi, atamanyile kwe akʉbhala. ");
INSERT INTO mgq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bhiishi ʉlʉsʉʉbhɨlo lwinyu mʉ lʉkhozyo lʉnʉʉlwo she lʉlɨɨpo, ɨnga mʉbhe mwe bhaana bha lʉkhozyo.” We uYeesu alonga amazwi ganaago, akhasogola, akhʉʉbha ɨnga bhatakhamʉlole. ");
INSERT INTO mgq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ɨleelo poope she uYeesu ábhombile ɨvɨlolesyo ivwinji pamiiso gaabho, abheene bhatámwitishile. ");
INSERT INTO mgq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bhatámwitishile ɨnga gakwɨle amazwi ge umukuwi ʉYeesaya álonjile átɨlɨ, “We Mwene, wu naanu we ayitishile intumi zyɨtʉ? Khabhɨlɨ ʉMwene amulanjile unaanu amakha gaakwe?” ");
INSERT INTO mgq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Shɨnɨɨsho bhatakhakhola kwɨtɨkha, kʉnongwa ye ʉYeesaya iwinza álonjile átɨlɨ, ");
INSERT INTO mgq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Abhagojile amiiso gaabho, agabhiishile amooyo gaabho kʉbha magomu. Ɨnga zɨtabhanje shɨnɨɨsho, amiiso gaabho nhanɨ gakʉlola, goope amooyo gaabho nhanɨ gakʉzyaganya, bhaamɨle bhagangalʉshɨla, ɨnga ɨmbatʉʉle.” ");
INSERT INTO mgq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ɄYeesaya álonjile ganaaga kʉnongwa ye áwulolile uwumwamu wa Yeesu na kʉlonga intumi zyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Poope shɨnɨɨsho, abhapɨtɨ abhinji abha Bhayahuudi bhámwitishile uYeesu. Ɨleelo bhatakhalongaga apazelu kʉtɨ bhamwitishile kʉnongwa ye bhakhogopaga kʉbhɨngwa na Bhafalisaayi mwi sinagoogi. ");
INSERT INTO mgq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abhalongozi bhanaabho bháyiganile nhaani kʉpaalwa na bhantʉ kʉshɨla kʉpaalwa nʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pe uYeesu akhalonga kwi zi ɨlya kʉdandɨzya akhatɨ, “Umuntu we akʉnɨɨtɨkha ɨne, atakʉnɨɨtɨkha neene nʉmwene, lyoli akʉmwɨtɨkha nʉʉla we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wowonti we akʉndola ɨne, akʉmʉlola we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨne ne lʉkhozyo, nɨɨne ininzile mʉ nsɨ ɨnga bhonti bhe bhakʉnɨɨtɨkha, bhatasyalaje mu khiisi. ");
INSERT INTO mgq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Umuntu we akwɨmvwa amazwi gaanɨ, ɨleelo atakʉgabhombela, ɨne te ɨmʉlonje, kʉnongwa ye intínzile mʉ nsɨ umu kʉbhalonga abhantʉ, lyoli nínzile kʉbhatʉʉla. ");
INSERT INTO mgq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wowonti we akʉnhaana ɨne peeka na mazwi gaanɨ alɨ nʉ wa kʉmʉlonga. Amazwi ge nalonga gakhayɨmʉlonga pi siku ɨlya kʉmpeleela. ");
INSERT INTO mgq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kwe kʉtɨ ɨntakhalongaga kʉ waamʉlo waanɨ nʉneene, lyoli ʉTaata waanɨ we ansonteleziizye, andajiziizye ɨzya kʉlonga na kʉtɨ ɨndonje ɨntɨ bhʉlɨ. ");
INSERT INTO mgq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Khabhɨlɨ imanyile kʉtɨ ɨndajɨzyo zyakwe zɨkʉʉbhapa abhantʉ uwuumi ʉwa wiila na wiila. Pe nɨɨne ɨnkʉlonga ziila zye ʉTaata waanɨ ándajiziizye kʉzɨlonga.” ");
INSERT INTO mgq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","We isiku ɨlya shikulukulu ɨshɨ Pasaaka shɨshɨɨlɨ kufikha, uYeesu ámanyile kʉtɨ akhabhalɨlo khaakwe khaafikha akha kʉsogola mʉ nsɨ umu na kʉbhala kwa Taata waakwe. Ábhaganile nhaani abhantʉ bhaakwe bhe bhámwitishile mʉ nsɨ umu, khabhɨlɨ ábhaganile kufishila kʉwʉmalɨlɨshɨlo. ");
INSERT INTO mgq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","UYeesu na bhalandati bhaakwe bhakhɨɨkhala na kulya ishaakulya ɨsha shalyabheela. Mʉ khabhalɨlo khanaakho, uSeetani áyinjiiye mʉ mwoyo wa Yʉʉda ʉmwana wa Siimoni Sikalioti ɨnga amʉlonjeelele uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","UYeesu ámanyile kʉtɨ ʉTaata amupiiye ʉwaamʉlo ku vintu vwonti, khabhɨlɨ kʉtɨ áfumile kwa Mʉlʉngʉ na kʉtɨ akʉgalʉkha kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pe akheepa pa shaakulya, akhazʉʉla ɨnkanzʉ yaakwe, akheega ʉmwenda na kuyipinya mʉ mʉsana. ");
INSERT INTO mgq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akhaponya aminzi mwi beeseni. Pe akhanda kʉbhasamvwa ɨvɨnama abhalandati bhaakwe na kʉsyʉmʉla nʉ mwenda we áyipinyile mʉ mʉsana. ");
INSERT INTO mgq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","We uYeesu aafikha pe uSiimoni Peeteli áamɨle, uPeeteli akhatɨ, “Mwene, ʉkwanza ʉngeezye ɨvɨnama ɨne?” ");
INSERT INTO mgq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","UYeesu akhamwamʉla akhatɨ, “Utalimanyile lye ɨnkʉlɨbhomba ishi, ɨleelo ʉtɨlɨmanye pɨlongolela.” ");
INSERT INTO mgq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","UPeeteli akhamʉbhʉʉzya akhatɨ, “Ndaali, ɨwe ʉtangansamvwa ɨvɨnama ngakheeka!” UYeesu akhamwamʉla akhatɨ, “Ɨnga ɨntakʉsamvwa, ʉtangakhola kʉbha peeka nɨɨne naalumo.” ");
INSERT INTO mgq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pe uSiimoni Peeteli akhamwamʉla akhatɨ, “Mwene, ɨnga she zɨlɨ, pe ʉtansamvwaje ɨvɨnama vwene, lyoli ʉngeezye ɨnyoobhe, peeka ni twe.” ");
INSERT INTO mgq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","UYeesu akhamwamʉla akhatɨ, “Umuntu we ageezile atakwanzɨwa kʉgeeza winza, lyoli akwanzɨwa kʉsamvwa ɨvɨnama vwene, kʉnongwa ye ʉmʉbhɨlɨ waakwe wonti wuzelupile. Ɨmwe muzelupile, ɨleelo te mwenti.” ");
INSERT INTO mgq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","UYeesu áamɨle she amumanyile umuntu we akhayɨmʉbhɨɨkha mʉ nyoobhe zya bhalʉgʉ, ye nongwa átɨlɨ, “Ɨmwe muzelupile, ɨleelo te mwenti.” ");
INSERT INTO mgq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","We uYeesu aamala kʉbhageezya abhalandati bhaakwe ɨvɨnama vwabho, akhakwata ɨnkanzʉ yaakwe, akhagalʉkha pe áyɨkhaaye, akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, mwazyaganya zɨnɨɨzyo zye nabhabhombela? ");
INSERT INTO mgq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɨmwe mʉkʉmbɨlɨshɨla mʉkʉtɨ, ‘Mumanyizyi,’ iwinza, ‘Mwene.’ Mʉkʉlonga wanalyoli, kʉnongwa ye ɨne she ɨndɨ. ");
INSERT INTO mgq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pe ɨnga ɨne ne ne Mumanyizyi wiinyu, khabhɨlɨ ne Mwene wiinyu, nabhasamvwa ɨmwe ɨvɨnama vwinyu, shɨnɨɨsho nɨɨmwe mʉkhondeeye kʉsamvwanya ɨvɨnama mʉneemwe na mʉneemwe. ");
INSERT INTO mgq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Imbalanjile ɨshɨkholanyo, ɨnga nɨɨmwe mʉbhombelanaje anza she ɨne nabhabhombelaga ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nalyoli ɨnkʉbhabhʉʉzya, umutumwa te mʉpɨtɨ kʉshɨla ʉmwene waakwe, khabhɨlɨ ʉmʉsonteelezwa te mʉpɨtɨ kʉshɨla we amusonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ɨnga mwazɨmanya zyonti zɨnɨɨzyo, ʉMʉlʉngʉ akhayɨbhasaya ɨnga mʉkʉzɨbhombela ɨmbombo.” ");
INSERT INTO mgq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ziniizi zye ɨnkʉlonga, ɨntakʉbhabhʉʉzya ɨmwe mwenti. Ɨne imbamanyile bhaala bhe ɨmbasabhʉʉye. Ɨleelo yɨkʉtɨ wʉkwɨle uWusimbe uWufinjile we wʉkʉtɨ, ‘Ʉla we alyanga ishaakulya peeka nɨɨne, agalʉnhana kʉbha mʉlʉgʉ waanɨ.’ ");
INSERT INTO mgq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ɨnkʉbhabhʉʉzya zyonti zɨnɨɨzyo we zɨshɨɨlɨ kufumila, ɨnga we zyafumila, mʉkhɨɨtɨshe kʉtɨ nalyoli ɨne ne neene. ");
INSERT INTO mgq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nalyoli ɨnkʉbhabhʉʉzya, umuntu wowonti we akʉmʉposheela we imusonteleziizye, akʉmposheela neene. Khabhɨlɨ we akʉmposheela ɨne, akʉmʉposheela nʉ Taata we ansonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","We uYeesu alonga zɨnɨɨzyo, akhaswɨmɨɨlɨla nhaani mʉ mwoyo, akhalonga apazelu akhatɨ, “Nalyoli ɨnkʉbhabhʉʉzya, weeka wiinyu atɨndonjeelele kʉ bhalʉgʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pe abhalandati bhaakwe bhakhanda kwenyanya bhɨɨbho na bhɨɨbho sita kʉmanya wu naanu we akʉmʉtekha. ");
INSERT INTO mgq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Páamɨle nu mulandati weeka mu bhalandati bhaakwe, we uYeesu ámuganile nhaani. Ʉweene áyɨkhaaye papɨɨpɨ nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pe uSiimoni Peeteli akhamʉpalɨzya umulandati wʉnʉʉyo, akhamʉbhʉzɨɨlɨzya akhatɨ, “Mʉbhʉzɨɨlɨzye, akʉmʉtekha wu naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pe umulandati wʉnʉʉyo, akhasejeelela papɨɨpɨ nu Yeesu, akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, wu naanu we atɨkʉlonjeelele kʉ bhalʉgʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","UYeesu akhamwamʉla akhatɨ, “Wʉ wʉʉla we intiimupe ɨshɨbeeza ishi kaati she nasanzɨla mʉ shɨlɨɨlo.” Pe uYeesu akheega ɨshɨbeeza ishi kaati, akhasanzɨla, akhaamupa ʉYʉʉda ʉmwana wa Siimoni Sikalioti. ");
INSERT INTO mgq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","We ʉYʉʉda aposheela ɨshɨbeeza shɨnɨɨsho, uSeetani akhamwinjila. Pe uYeesu akhamʉbhʉʉzya akhatɨ, “Lye ʉkwanza kʉbhomba, bhomba nalʉbhɨlo!” ");
INSERT INTO mgq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ɨleelo atálɨɨpo umuntu mʉ bhaala bhe bhakhalyanga paala we ázyaganyiinye kʉtɨ khooni khe uYeesu akhamʉbhʉzyaga ʉYʉʉda shɨnɨɨsho. ");
INSERT INTO mgq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kʉnongwa ye ʉYʉʉda we akhabhɨɨkhaga imbuguuli ɨyɨ nhela, bhamu bhakhasɨɨbhaga kʉtɨ uYeesu akʉmʉbhʉʉzya ʉYʉʉda kʉtɨ abhale akale vwe vwábhʉlɨɨye mu shikulukulu, awe aabhape abhapɨɨna akhantʉ khokhonti. ");
INSERT INTO mgq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pe we ʉYʉʉda aposheela ɨshɨbeeza shɨnɨɨsho ishi kaati, akhafuma kunzi. Akhabhalɨlo khanaakho kwámɨle wusiku. ");
INSERT INTO mgq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pe we ʉYʉʉda aafuma kunzi, uYeesu akhatɨ, “Ishi ʉMwana wa Muntu aposheela uwumwamu, woope ʉMʉlʉngʉ aposheela uwumwamu kʉshɨlɨla kwa Mwana wa Muntu. ");
INSERT INTO mgq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","We uwumwamu wa Mʉlʉngʉ walolekha kʉshɨlɨla kwa Mwana, pe ʉMʉlʉngʉ wʉʉyo atɨmʉmwamɨshe ʉMwana waakwe, khabhɨlɨ atɨbhombe shɨnɨɨsho nalʉbhɨlo. ");
INSERT INTO mgq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bhaana bhaanɨ, ɨntɨbhe peeka nɨɨmwe kʉ khabhalɨlo khashe bhʉʉlo. Mʉkhayɨnanza, anza she nábhabhuziizye abhalongozi abha Bhayahuudi, shɨnɨɨsho ɨnkʉbhabhʉʉzya ɨmwe ishi kʉtɨ, paala pe ɨnhayɨbha ɨmwe mʉtangakhola kwɨnza. ");
INSERT INTO mgq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ɨleelo ishi ɨnkʉʉbhapa ɨndajɨzyo impwa kʉtɨ, ‘Mʉgananaje, anza she ɨne imbaganile ɨmwe, shɨnɨɨsho nɨɨmwe mʉgananaje mʉneemwe na mʉneemwe.’ ");
INSERT INTO mgq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ɨnga mʉkʉganana mʉneemwe na mʉneemwe, abhantʉ bhonti bhatɨmanye kʉtɨ ɨmwe mwe bhalandati bhaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pe uSiimoni Peeteli akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “We Mwene, ʉkʉbhala kwoshi?” UYeesu akhamwamʉla akhatɨ, “Kwe ɨnkʉbhala ʉtangakhola kʉndandata ishi, ɨleelo ʉkhayɨndandata pɨlongolela.” ");
INSERT INTO mgq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","UPeeteli akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, khooni khe ɨne ɨntangakhola kʉkʉlandata ishi? Ɨne intiyifumwe kufwa kʉnongwa yaakho!” ");
INSERT INTO mgq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","UYeesu akhamwamʉla akhatɨ, “Bhʉlɨ, nalyoli utiyifumwe kufwa kʉnongwa yaanɨ? Nalyoli ɨnkʉkʉbhʉʉzya, we ɨnhanda yɨshɨɨlɨ kʉbhɨlɨshɨla, ʉtɨnhaane khatatʉ kʉtɨ utamanyile.” ");
INSERT INTO mgq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pe uYeesu akhajendeelela kʉbhabhʉʉzya akhatɨ, “Mʉtaswɨmɨlɨlaje mʉ mooyo giinyu. Mwɨtɨkhaje ʉMʉlʉngʉ, khabhɨlɨ mʉnɨtɨkhaje nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mu nyumba ya Taata waanɨ mʉlɨ nʉ wɨɨkhalo uwinji. Ɨnga zɨtabhanje shɨnɨɨsho, nhanɨ imbabhuziizye. Ishi ɨnkʉbhala kʉbhalɨnganɨzanya ʉwɨɨkhalo. ");
INSERT INTO mgq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","We naabhala na kʉbhalɨnganɨzanya ʉwɨɨkhalo, ɨnhayɨnza winza kʉbheega, ɨnga nɨɨmwe mʉkhabhe paala pe ɨnhayɨbha. ");
INSERT INTO mgq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɨɨmwe mulimanyile ɨdala lye lɨkʉbhala kwe ɨnkʉbhala.” ");
INSERT INTO mgq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pe uToomasi akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, tutamanyile kwe ʉkʉbhala. Tʉngalɨmanya bhʉlɨɨbhʉlɨ ɨdala?” ");
INSERT INTO mgq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","UYeesu akhamwamʉla akhatɨ, “Ɨne ne lɨdala, uwanalyoli, nu wuumi. Umuntu atangakhola kwɨnza kwa Taata ɨnga atashɨlɨɨye kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ɨnga mʉmanyaje ɨne, nhanɨ mumumanyile nʉ Taata waanɨ. Kwandɨla ishi, mumumanyile ʉTaata, khabhɨlɨ mumulolile.” ");
INSERT INTO mgq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pe uFilipo akhamʉbhʉʉzya akhatɨ, “We Mwene, tʉlanje ʉTaata. Ɨnga watʉlanga, we kwasila.” ");
INSERT INTO mgq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","UYeesu akhamwamʉla akhatɨ, “We Filipo, nɨɨkhala nɨɨmwe akhabhalɨlo akhatali khonti khanaakho, poope niishi utamanyile? Umuntu wowonti we andolile ɨne, amulolile ʉTaata. Ishi khooni ʉkʉtɨ, ‘Tʉlanje ʉTaata’? ");
INSERT INTO mgq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bhʉlɨ, ʉtakwɨtɨkha kʉtɨ ɨne ɨndɨ mwa Taata, woope ʉTaata alɨ mʉmwanɨ? Amazwi ge ɨnkʉbhabhʉʉzya gatakufuma mʉ waamʉlo waanɨ, lyoli ʉTaata we alɨ mukaasi yaanɨ, akʉbhomba ɨmbombo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mʉnɨɨtɨshe kʉtɨ ɨne ɨndɨ mwa Taata, woope ʉTaata alɨ mʉmwanɨ. Ɨleelo ɨnga mʉtakʉnɨɨtɨkha kʉnongwa ya zye ɨnkʉlonga, pe mwɨtɨshe kʉnongwa yɨ mbombo zye ɨnkʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nalyoli ɨnkʉbhabhʉʉzya, we akʉnɨɨtɨkha ɨne, atɨbhombaje ɨmbombo zye ɨnkʉbhomba ɨne. Khabhɨlɨ atɨbhombaje poope amapɨtɨ kʉshɨla ge ɨnkʉbhomba, kʉnongwa ye ɨnkʉbhala kwa Taata. ");
INSERT INTO mgq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ɨnga mʉkʉlaabha akhantʉ khokhonti kwɨ taawa lyanɨ, ɨntɨbhombe, ɨnga ʉTaata apaalwe kwɨ dala lya Mwana. ");
INSERT INTO mgq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ɨnga mʉkʉndaabha ɨne akhantʉ khokhonti kwɨ taawa lyanɨ, ɨntɨbhabhombele.” ");
INSERT INTO mgq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","UYeesu akhajendeelela kʉbhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨnga munganile, mʉtɨzɨleme ɨndajɨzyo zyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɨɨne ɨntɨmʉlaabhe ʉTaata, woope atɨɨbhape uMwavwi we atɨyɨkhalaje nɨɨmwe wiila. ");
INSERT INTO mgq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","UMwavwi wʉnʉʉyo Mupepu we atɨbhalanje abhantʉ uwanalyoli. Abhantʉ abha mʉ nsɨ bhe bhakʉmʉkhaana ʉMʉlʉngʉ bhatangakhola kʉmʉposheela, kʉnongwa ye bhatakʉmʉlola awe bhatamumanyile. Ɨleelo ɨmwe mumumanyile, kʉnongwa ye akwɨkhala peeka nɨɨmwe, khabhɨlɨ alɨ mukaasi yiinyu. ");
INSERT INTO mgq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Te ɨmbaleshe mʉbheene ngatɨ bhapɨɨna, lyoli ɨnhayɨnza winza kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Khasyalile akhabhalɨlo khashe khe abhantʉ abha mʉ nsɨ te bhakhandole winza, lyoli ɨmwe mʉkhayɨndola. Kʉnongwa ye ɨne ne mwumi, nɨɨmwe mʉkhayɨbha mwe bhuumi. ");
INSERT INTO mgq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Isiku liila we lyafikha, mʉkhayɨmanya kʉtɨ ɨne ɨndɨ mukaasi ya Taata waanɨ, nɨɨmwe mʉlɨ mukaasi yaanɨ, nɨɨne ɨndɨ mukaasi yiinyu. ");
INSERT INTO mgq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wowonti we akʉzɨposheela ɨndajɨzyo zyanɨ na kʉzɨlema, wʉnʉʉnʉ we anganile. Woope we anganile ɨne, ʉTaata atɨmʉgane, nɨɨne ɨntɨmʉgane na kʉyɨlolesya kʉkwakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pe ʉYʉʉda, we te wʉ Yʉʉda Sikalioti, akhamʉbhʉzɨɨlɨzya akhatɨ, “We Mwene, zɨlɨ bhʉlɨɨbhʉlɨ kʉtɨ ʉtɨyɨlolesye kʉkwɨtʉ, ɨleelo te kʉ bhantʉ abha mʉ nsɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","UYeesu akhamwamʉla akhatɨ, “Umuntu ɨnga angana, atɨgaleme amazwi gaanɨ, woope ʉTaata waanɨ atɨmʉgane. Nɨɨtwe tʉtɨyɨnze kʉkwakwe na kwɨkhala nawo. ");
INSERT INTO mgq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wowonti we atanganile atakʉgalema amazwi gaanɨ. Amazwi ge ɨnkʉbhabhʉʉzya te gaanɨ, lyoli ga Taata we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Imbabhuziizye zyonti zɨnɨɨzyo we ɨndɨ she ɨnkwɨkhala peeka nɨɨmwe. ");
INSERT INTO mgq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ɨleelo wʉnʉʉyo uMwavwi kwe kʉtɨ, uMupepu uMufinjile we ʉTaata atɨmʉsonteelezye kukwinyu kwɨ taawa lyanɨ, we atɨbhamanyɨzye na kʉbhakʉmbʉsya zyonti zye imbabhuziizye. ");
INSERT INTO mgq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ɨnkʉbhaleshela uwutengaanu, uwutengaanu we ɨnkʉʉbhapa wʉtalɨ anza wuula we wukufuma kʉ bhantʉ abha mʉ nsɨ. Mʉtaswɨmɨlɨlaje mʉ mooyo giinyu, khabhɨlɨ mʉtatʉʉyaje khokhonti. ");
INSERT INTO mgq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwimvwizye zye nabhabhʉzyaga kʉtɨ, ‘Ɨnkʉbhala, ɨleelo ɨnhayɨgalʉkha winza.’ Ɨnga mʉnganaje nalyoli, nhanɨ mʉkʉseshela kʉnongwa ye ɨnkʉbhala kwa Taata, kwe kʉtɨ ʉTaata mʉpɨtɨ kʉnshɨla ɨne. ");
INSERT INTO mgq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“Ishi nabhabhʉʉzya zyonti zɨnɨɨzyo we zɨshɨɨlɨ kufumila, ɨnga we zyafumila, mʉkhɨɨtɨshe. ");
INSERT INTO mgq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ɨntangalonga nɨɨmwe kʉ khabhalɨlo akhatali, kʉnongwa ye uSeetani we mʉpɨtɨ wa mʉ nsɨ umu, akwɨnza. Ɨleelo atalɨ na makha kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ɨleelo abhantʉ abha mʉ nsɨ bhamanye kʉtɨ imuganile ʉTaata, nɨɨne ɨnkʉbhomba shishiila she ʉTaata ándajiziizye. Yimiilili tʉsogole ɨpa.” ");
INSERT INTO mgq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Pe uYeesu akhajendeelela kʉbhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨne ne muzabiibu ʉwa nalyoli, ʉTaata waanɨ we mulimi. ");
INSERT INTO mgq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ʉlʉpaaswa lyolyonti lwe lʉtakwela amatunda, ʉTaata waanɨ akuludiba na kʉlwefwa. Ɨleelo ʉlʉpaaswa lwe lʉkwela, ʉTaata waanɨ akulupulundila ɨnga lwele nhaani. ");
INSERT INTO mgq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɨmwe muzelupile anzɨ mpaaswa zye mpulundile, kʉnongwa ye muzyitishile ɨmanyɨzyo zye nábhamanyiziizye. ");
INSERT INTO mgq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mʉjendeelele kwɨkhala mukaasi mʉmwanɨ, nɨɨne ɨnɨkhalaje mukaasi mumwinyu. Anza she ʉlʉpaaswa lʉtangakhola kwela amatunda lwene sita kʉlemeela mu muzabiibu, shɨnɨɨsho nɨɨmwe mʉtangakhola kwela amatunda sita kwɨkhala mukaasi mʉmwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ɨne ne muzabiibu, ɨmwe mwe mpaaswa. Umuntu we akwɨkhala mukaasi yaanɨ nɨɨne mukaasi yaakwe, wʉnʉʉyo akwela amatunda aminji, kwe kʉtɨ sita neene mʉtangakhola kʉbhomba lyolyonti. ");
INSERT INTO mgq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Umuntu we atakwɨkhala mukaasi mʉmwanɨ akʉsʉmbwa kunzi anza she ʉlʉpaaswa lʉkʉsʉmbwa kunzi na kwʉma. Abhantʉ bhakʉteenya na kʉlʉsʉmba mʉ mwoto lʉlʉngʉlɨle. ");
INSERT INTO mgq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ɨnga mwɨkhala mukaasi mʉmwanɨ nɨɨne mukaasi mumwinyu, pe mʉlaabhaje khokhonti khe mʉkwanza nɨɨmwe mʉtɨpeelwe. ");
INSERT INTO mgq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ɨnga mʉkwela amatunda aminji, na kʉbha mwe bhalandati bhaanɨ abha nalyoli, pe mʉtɨlolesye palʉkɨndɨ uwumwamu wa Taata waanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Anza she ʉTaata waanɨ ánganile ɨne, she nɨɨne imbaganile ɨmwe. Shɨnɨɨsho, mʉjendeelele kwɨkhala mʉ lʉgano lwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ɨnga mwazɨlema ɨndajɨzyo zyanɨ, mʉtɨyɨɨkhale mʉ lʉgano lwanɨ, anza she nɨɨne inzilemile ɨndajɨzyo zya Taata waanɨ na kwɨkhala mʉ lʉgano lwakwe. ");
INSERT INTO mgq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Imbabhuziizye zyonti zɨnɨɨzyo ɨnga ʉlʉseshelo lwanɨ lʉbhe mukaasi mumwinyu, nʉ lʉseshelo lwinyu lʉkwɨlane. ");
INSERT INTO mgq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ɨndajɨzyo yaanɨ ye yɨ yɨɨnɨ, ‘Mʉgananaje anza she ɨne imbaganile ɨmwe.’ ");
INSERT INTO mgq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Atalɨɨpo umuntu we alɨ nʉ lʉgano ʉlʉpɨtɨ kʉshɨla ulu, ʉlwa muntu kuyifumwa kufwa kʉnongwa ya bhamanyani bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ɨmwe mwe bhamanyani bhaanɨ ɨnga mʉkʉbhomba zye imbalajiziizye. ");
INSERT INTO mgq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kwandɨla ishi te ɨmbabhɨlɨshɨlaje winza kʉtɨ bhabhombi bhaanɨ, kʉnongwa ye umubhombi atamanyile zye ʉmʉpɨtɨ waakwe akʉbhomba. Lyoli ɨnkʉbhabhɨlɨshɨla kʉtɨ bhamanyani bhaanɨ, kwe kʉtɨ imbabhuziizye zyonti zye inimvwizye kufuma kwa Taata waanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Te mwemwe mwe mwánsebhile ɨne, lyoli neene nábhasebhile ɨmwe na kʉbhasonteelezya mʉbhale mwelaje amatunda, ge gakʉdɨɨla. Woope ʉTaata waanɨ atɨbhapanje khokhonti khe mʉtɨmʉlaabhaje kwɨ taawa lyanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ɨndajɨzyo yaanɨ kukwinyu yɨ yɨɨnɨ: mʉgananaje.” ");
INSERT INTO mgq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","UYeesu akhajendeelela kʉbhabhʉʉzya abhalandati bhaakwe akhatɨ, “Ɨnga abhantʉ abha mʉ nsɨ ɨnɨ bhakubhaviitilwa ɨmwe, mʉmanyaje kʉtɨ bhamvitiliilwe ɨne she bhashɨɨlɨ kubhaviitilwa ɨmwe. ");
INSERT INTO mgq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ɨnga mʉbhanje mwe bhantʉ abha mʉ nsɨ ɨnɨ, abhantʉ abha mʉ nsɨ nhanɨ bhabhaganile anza she bhaganiine bhɨɨbho na bhɨɨbho. Ɨleelo ɨmwe te mwe bha mʉ nsɨ, lyoli ɨne imbasebhile kufuma mʉ nsɨ ɨnɨ, kʉnongwa yɨnɨɨyo, abhantʉ abha mʉ nsɨ bhakubhaviitilwa. ");
INSERT INTO mgq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mʉkʉmbʉkhaje zye nábhabhuziizye kʉtɨ, ‘Umutumwa te mʉpɨtɨ kʉshɨla ʉmwene waakwe.’ Ɨnga bhanjimvwizye ɨne, bhakhayɨbhayɨmvwa nɨɨmwe. Ɨnga bhakʉzyɨtɨkha ɨmanyɨzyo zyanɨ, bhatɨzyɨtɨshe ni zyinyu. ");
INSERT INTO mgq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɨleelo zyonti zɨnɨɨzyo bhakhayɨbhabhombela ɨmwe kʉnongwa yɨ taawa lyanɨ, khabhɨlɨ kʉnongwa ye bhatamumanyile we ansonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Bhanje ɨntɨnzaje na kʉlonga nabho, nhanɨ bhatalɨ ni mbiibhi. Ɨleelo ishi bhatangakhola kʉlamba kʉtɨ bhatalɨ ni mbiibhi. ");
INSERT INTO mgq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Umuntu wowonti we akumviitilwa ɨne, akumuviitilwa nʉ Taata waanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bhanje ɨntabhombaje kʉkwabho amayele amapɨtɨ ge atalɨɨpo umuntu we abhombile lumo, pe nhanɨ bhatalɨ ni mbiibhi. Ɨleelo ishi bhazɨlola zyonti zye imbombile, poope shɨnɨɨsho bhakumviitilwa ɨne, nʉ Taata waanɨ woope. ");
INSERT INTO mgq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ganaaga gafumiiye ɨnga amazwi gakwɨle ge gasimbiilwe mu Wusimbe uWufinjile kʉtɨ, ‘Bhamvitiliilwe sita nongwa naayimo.’ ");
INSERT INTO mgq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ɨleelo we ayɨnza uMwavwi wʉnʉʉyo we ɨnhayɨmʉsonteelezya kukwinyu kufuma kwa Taata kwe kʉtɨ uMupepu ʉwa nalyoli, ʉweene atimfumwizye uwukeeti. ");
INSERT INTO mgq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nɨɨmwe bhʉʉlo mutimfumwizyaje uwukeeti, kʉnongwa ye mwámɨle peeka nɨɨne kufuma kʉwandɨlo wɨ mbombo yaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","UYeesu akhajendeelela kʉlonga na bhalandati bhaakwe akhatɨ, “Imbabhuziizye zyonti ziniizi ɨnga mʉtakhaaleshe kʉnɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Abhantʉ bhakhayɨbhabhɨngaga ɨmwe mu masinagoogi gaabho. Khabhɨlɨ akhabhalɨlo khakwɨnza khe bhe bhakʉbhagoga ɨmwe, bhakhayɨsɨɨbha kʉtɨ bhakʉmʉbhombela wʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Abhantʉ bhakhayɨbhabhombela zyonti zɨnɨɨzyo kʉnongwa ye bhatamumanyile ʉTaata, khabhɨlɨ bhatamanyile nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ɨleelo imbabhuziizye zɨnɨɨzyo ɨnga akhabhalɨlo khaakwe khaafikha mʉkhakʉmbʉkhaje kʉtɨ nábhabhuziizye. Intábhabhuziizye zyonti zɨnɨɨzyo kufuma kʉwandɨlo, kʉnongwa ye náamɨle peeka nɨɨmwe.” ");
INSERT INTO mgq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ɨleelo ishi ɨnkʉgalʉkha kʉbhala kwa Taata waanɨ we ánsonteleziizye. Ɨleelo atalɨɨpo wowonti pakaasi yiinyu ʉwa kʉmbʉzɨɨlɨzya kʉtɨ, ‘Ʉkʉbhala kwoshi?’ ");
INSERT INTO mgq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mʉswɨmɨlɨɨye mʉ mooyo giinyu kʉnongwa ye imbabhuziizye ziniizi. ");
INSERT INTO mgq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ɨleelo ɨnkʉbhabhʉʉzya uwanalyoli, kwashi kukwinyu kʉtɨ ɨne ɨnsogole ɨmbale kwa Taata, kʉnongwa ye ɨnga ɨntasogola, wʉnʉʉyo uMwavwi atangɨnza kukwinyu. Ɨleelo ɨnga naabhala, ɨnhayɨmʉsonteelezya kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Woope ɨnga ayɨnza, akhayibhasimishizya abhantʉ abha mʉ nsɨ kʉtɨ imbiibhi zyoni, uwugolosu wʉlɨ bhʉlɨ nu wulonji wa Mʉlʉngʉ wʉlɨ bhʉlɨ. ");
INSERT INTO mgq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Akhayibhasimishizya ku zyi mbiibhi, kʉnongwa ye bhatakʉnɨɨtɨkha ɨne. ");
INSERT INTO mgq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Khabhɨlɨ kʉ zya wugolosu, kʉnongwa ye ɨnkʉbhala kwa Taata, nɨɨmwe te mʉkhandole winza. ");
INSERT INTO mgq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Khabhɨlɨ akhayibhasimishizya kʉ zya wulonji, kʉnongwa ye uSeetani ʉmʉpɨtɨ ʉwa mʉ nsɨ umu alongiilwe. ");
INSERT INTO mgq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ɨndɨ she ɨndɨ nazyo inyinji ɨzya kʉbhabhʉʉzya, ɨleelo ishi mʉtangakhola kʉzɨposheela. ");
INSERT INTO mgq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","We ayɨnza wʉnʉʉyo uMupepu ʉwa nalyoli, atɨbhalongolaje kʉwʉmanya uwanalyoli wonti. Ʉweene te akhalongaje kʉ waamʉlo waakwe wʉʉyo, lyoli akhayɨlongaga zye akwɨmvwa, na kʉbhabhʉʉzya zye zikhayifumila pɨlongolela. ");
INSERT INTO mgq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ʉweene atɨbhalangaje uwumwamu waanɨ, kʉnongwa ye atɨbhabhʉzyaje zyonti zye akʉposheela kufuma kʉkwanɨ. ");
INSERT INTO mgq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ivintu vwonti vwe ʉTaata waanɨ alɨ navwo vwanɨ. Ye nongwa nalonga kʉtɨ uMupepu atɨbhabhʉzyaje zyonti zye atɨposheelaje kufuma kʉkwanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","UYeesu akhajendeelela kʉbhabhʉʉzya akhatɨ, “Khasyalile akhabhalɨlo khashe te mʉkhandole, khabhɨlɨ khasyalile akhabhalɨlo khashe mʉkhayɨndola.” ");
INSERT INTO mgq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pe abhalandati bhaakwe bhamu bhakhabhʉzɨlɨzanya bhakhatɨ, “Kwe kʉtɨ bhʉlɨ shiniishi we akʉtɨ, ‘Khasyalile akhabhalɨlo khashe te mʉkhandole, khabhɨlɨ khasyalile akhabhalɨlo khashe mʉkhayɨndola,’ khabhɨlɨ akʉtɨ, ‘Ɨnkʉgalʉkha kʉbhala kwa Taata waanɨ’?” ");
INSERT INTO mgq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pe bhakhajendeelela kʉbhʉzɨlɨzanya kʉtɨ, “Kwe kʉtɨ bhʉlɨ we akʉtɨ, ‘Khasyalile akhabhalɨlo khashe’? Ɨtwe tʉtakʉzyaganya zɨnɨɨzyo zye akʉlonga.” ");
INSERT INTO mgq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","UYeesu akhamanya kʉtɨ abhalandati bhaakwe bhakwanza kʉmʉbhʉzɨɨlɨzya, pe akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, mʉkʉbhʉzɨlɨzanya kʉ zye nalonga kʉtɨ, ‘Khasyalile akhabhalɨlo khashe te mʉkhandole, khabhɨlɨ khasyalile akhabhalɨlo khashe mʉkhayɨndola’? ");
INSERT INTO mgq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nalyoli ɨnkʉbhabhʉʉzya, ɨmwe mʉkhayɨlɨla na kʉyɨlʉmbʉʉzya, ɨleelo abhantʉ abha mʉ nsɨ bhakhayɨseshela. Mʉkhayɨswɨmɨɨlɨla kʉ khabhalɨlo khashe, ɨleelo uwuswimiilizu wiinyu wʉkhayɨgalʉnhana kʉbha lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","We ʉmwantanda akʉpaapa, akʉbha nu wuswimiilizu kʉnongwa ye akhabhalɨlo akha kushinda khafishile. Ɨleelo ɨnga apaapa, atakʉkʉmbʉkha winza amavune ganaago, kʉnongwa ɨya lʉseshelo kʉtɨ ʉmwana apaapwa mʉ nsɨ. ");
INSERT INTO mgq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Shɨnɨɨsho nɨɨmwe mʉlɨ nu wuswimiilizu kʉ khabhalɨlo ɨkha, ɨleelo ɨnhayɨnza kukwinyu winza, pe mʉkhayɨbha nʉ lʉseshelo mʉ mooyo giinyu. Ʉlʉseshelo lʉnʉʉlwo atalɨɨpo umuntu we angalwefwa kufuma mʉ mooyo giinyu. ");
INSERT INTO mgq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","We akhabhalɨlo khanaakho khaafikha, te mʉkhandaabhe khokhonti. Nalyoli ɨnkʉbhabhʉʉzya, khokhonti khe mʉtɨmʉlaabhaje ʉTaata waanɨ kwɨ taawa lyanɨ, atɨbhapanje. ");
INSERT INTO mgq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kufishila akhabhalɨlo ɨkha, mutalaabhile naakhamu kwɨ taawa lyanɨ. Laabhaji nɨɨmwe mʉtɨposheele, ɨnga ʉlʉseshelo lwinyu lʉkwɨle.” ");
INSERT INTO mgq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","UYeesu akhajendeelela kʉlonga akhatɨ, “Imbabhuziizye zyonti zɨnɨɨzyo kwɨ dala ɨlya miibhi. Ɨleelo akhabhalɨlo khakwɨnza khe te ɨnhalonje nɨɨmwe kwɨ dala ɨlya miibhi, lyoli ɨnhayɨbhabhʉʉzya apazelu kʉ zya Taata. ");
INSERT INTO mgq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Isiku lɨnɨɨlyo, mʉkhayɨlaabha kwɨ taawa lyanɨ. Ɨntakʉbhabhʉʉzya kʉtɨ ɨne ɨntɨmʉlaabhe ʉTaata kʉnongwa yiinyu. ");
INSERT INTO mgq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kwe kʉtɨ ʉTaata wʉʉyo abhaganile ɨmwe kʉnongwa ye ɨmwe munganile ɨne, khabhɨlɨ mwitishile kʉtɨ imfumile kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɨne náfumile kwa Taata ɨnhɨnza mʉ nsɨ umu, ɨleelo ishi ɨnkʉsogola mʉ nsɨ, ɨnkʉgalʉkha kwa Taata.” ");
INSERT INTO mgq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pe abhalandati bhaakwe bhakhamʉbhʉʉzya bhakhatɨ, “Ishi ʉkʉlonga nɨɨtwe apazelu sita kʉlonga ku miibhi! ");
INSERT INTO mgq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ishi twazyaganya kʉtɨ ɨwe umanyile zyonti, khabhɨlɨ yɨtakwanzɨwa umuntu kʉkʉbhʉzɨɨlɨzya lyolyonti. Ku liniili tʉkwɨtɨkha kʉtɨ ufumile kwa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","UYeesu akhabhaamʉla akhatɨ, “Bhʉlɨ, ishi mʉkwɨtɨkha? ");
INSERT INTO mgq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Akhabhalɨlo khakwɨnza, khabhɨlɨ khafishile khe ɨmwe mwenti mʉkhayɨsataana. Umuntu wowonti akhayɨbhalaga ʉlwakwe, ɨne mʉkhayɨndekha nʉmwene. Ɨleelo ɨne ɨntalɨ nʉmwene, kʉnongwa ye ʉTaata alɨ peeka nɨɨne. ");
INSERT INTO mgq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Imbabhuziizye zyonti zɨnɨɨzyo ɨnga mʉbhe nu wutengaanu we mʉlɨ mukaasi yaanɨ. Mʉ nsɨ mʉtɨgaagaje amayɨmba, ɨleelo mʉyɨgomwaje ʉmwoyo, kʉnongwa ye ɨne inzitolile ɨzya mʉ nsɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","We uYeesu aamala kʉlonga ganaago, akheenya kʉmwanya, akhapuuta akhatɨ, “We Taata, akhabhalɨlo khaafikha. Ʉbhalanje abhantʉ uwumwamu wa mwana waakho, ɨnga woope ʉMwana akʉmwamɨshe ɨwe. ");
INSERT INTO mgq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kʉnongwa ye wámupiiye ʉMwana waakho ʉwaamʉlo kʉ bhantʉ bhonti, ɨnga aabhape uwuumi ʉwa wiila na wiila bhaala bhe umupiiye. ");
INSERT INTO mgq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uwuumi ʉwa wiila na wiila we wu wuuwu, bhakʉmanye ɨwe we ʉlɨ wʉmwene, wʉ Mʉlʉngʉ ʉwa nalyoli, khabhɨlɨ bhamʉmanye uYeesu Kilisiti we wámusonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ɨne indolesiizye uwumwamu waakho mʉ nsɨ umu, kwɨ dala ɨlya kʉkwɨlɨzya ɨmbombo ye wánsonteleziizye kʉbhomba. ");
INSERT INTO mgq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ishi Taata, ɨnkʉkʉlaabha ʉmwamɨshe ɨne we ɨndɨ peeka nɨɨwe ku wumwamu we náamɨle nawo peeka nɨɨwe we ɨnsɨ yáshɨɨlɨ kʉpelwa.” ");
INSERT INTO mgq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","UYeesu akhajendeelela kupuuta akhatɨ, “We Taata, imbamanyisiizye she ʉlɨ bhaala bhe wámpiiye kufuma mʉ nsɨ. Bháamɨle bhaakho, ʉkhampa ɨne. Bhoope bhalilemile izwi lyakho. ");
INSERT INTO mgq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ishi bhaamanya kʉtɨ ivintu vwonti vwe wámpiiye, vifumile kʉkwakho, ");
INSERT INTO mgq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kʉnongwa ye imbapiiye intumi zye wámpiiye. Bhoope bhazɨposheleeye, bhamanyile kʉtɨ nalyoli imfumile kʉkwakho, khabhɨlɨ bhitishile kʉtɨ weewe wánsonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Inkubhapuutila bhanaabho, intakubhapuutila abha mʉ nsɨ, lyoli inkubhapuutila bhaala bhe umpiiye, kʉnongwa ye bhantʉ bhaakho. ");
INSERT INTO mgq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abhantʉ bhonti bhe bhaanɨ, bhaakho, khabhɨlɨ abhantʉ bhonti bhe bhaakho, bhaanɨ. Uwumwamu waanɨ wuloleshile mʉ bhanaabho bhe umpiiye. ");
INSERT INTO mgq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ɨne ɨnkwɨnza kʉkwakho, te ɨmbe mʉ nsɨ umu winza. Ɨleelo abheene bhatɨjendeelele kʉbha mʉ nsɨ umu. We Taata we Mufinjile, ʉbhalɨndɨɨlɨle kʉ makha gɨ taawa lyakho lye wámpiiye, ɨnga bhabhe nʉ wʉpeeka anza she ɨtwe tʉlɨ nʉ wʉpeeka. ");
INSERT INTO mgq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","We naamɨle peeka nabho, nabhalɨndɨlɨlaga kwɨ taawa lyakho lye wámpiiye. Ɨnhabhalɨndɨlɨlaga akhinza ɨnga atakhabhe ngaweeka ʉwa kʉteega, lyoli ʉmwana ʉmʉteeje, ɨnga wʉkwɨle uWusimbe uWufinjile. ");
INSERT INTO mgq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“We Taata, ishi ɨnkwɨnza kʉkwakho. Ɨne ɨnkʉbhabhʉʉzya zyonti ziniizi we ɨndɨ mʉ nsɨ, ɨnga bhabhe nʉ lʉseshelo lwanɨ mʉ mooyo gaabho. ");
INSERT INTO mgq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɨne imbabhuziizye amazwi ge wándajiziizye, bhoope abha mʉ nsɨ bhabhavitiliilwe, kʉnongwa ye abheene te bha mʉ nsɨ anza she ɨne te ne wa mʉ nsɨ umu. ");
INSERT INTO mgq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Intakupuuta kʉtɨ ʉbheefwe mʉ nsɨ umu, lyoli ɨnkʉlaabha kʉtɨ ʉbhalɨndɨɨlɨle kwa mʉbhomba mbiibhi uSeetani. ");
INSERT INTO mgq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Abheene te bha mʉ nsɨ anza she ɨne te ne wa mʉ nsɨ umu. ");
INSERT INTO mgq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","We Taata, ɨnkʉkʉlaabha ubhazelufwe bhabhe bhafinjile, kwɨ dala ɨlya wanalyoli, lye lizwi lyakho. ");
INSERT INTO mgq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Anza she wánsonteleziizye ɨne mʉ nsɨ, nɨɨne ɨnkʉbhasonteelezya abheene mʉ nsɨ. ");
INSERT INTO mgq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kʉnongwa yaabho, inkuyifumwa kʉkʉbhombela ɨwe, ɨnga bhoope bhayifumwe kʉkwakho mu wanalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Intakubhapuutila abhalandati ɨbha bheene, lyoli na bhanjɨ bhe bhakhayɨɨtɨkha kʉshɨlɨla mu mazwi gaabho. ");
INSERT INTO mgq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","We Taata, ɨnkʉkʉlaabha kʉtɨ bhabhe nʉ wʉpeeka, anza she ɨwe ʉlɨ mukaasi yaanɨ nɨɨne ɨndɨ mukaasi yaakho. Ɨnkʉlaabha kʉtɨ bhabhe nʉ wʉpeeka, ɨnga abhantʉ abha mʉ nsɨ bhɨɨtɨshe kʉtɨ ɨwe we unsonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ɨne imbapiiye uwumwamu we wámpiiye ɨne, ɨnga bhabhe nʉ wʉpeeka anza she ɨne nɨɨwe tʉlɨ nʉ wʉpeeka. ");
INSERT INTO mgq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɨne ɨmbe mukaasi yaabho, nɨɨwe ʉbhe mukaasi yaanɨ. Inkupuuta ɨnga bhabhe nʉ wʉpeeka uwukwilizu, ɨnga abha mʉ nsɨ bhamanye kʉtɨ ɨwe we unsonteleziizye, khabhɨlɨ kʉtɨ ubhaganile abheene anza she unganile ɨne. ");
INSERT INTO mgq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“We Taata, injiganile kʉtɨ ɨbha bhe umpiiye bhabhe peeka nɨɨne paala pe ɨntɨbhe, ɨnga bhawʉlole uwumwamu we umpiiye. Kʉnongwa ye wánganile we ʉshɨɨlɨ kʉpela ɨnsɨ. ");
INSERT INTO mgq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","We Taata ʉwa Wugolosu, abhantʉ abha mʉ nsɨ umu bhatakumanyile. Ɨleelo ɨne inkumanyile, bhoope abhalandati bhaanɨ bhamanyile kʉtɨ ɨwe we unsonteleziizye. ");
INSERT INTO mgq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɨɨne imbamanyisiizye she ʉlɨ, khabhɨlɨ ɨntɨjendeelele kʉbhomba shɨnɨɨsho, ɨnga ʉlʉgano lwe ʉlɨ nalwo kʉkwanɨ lʉbhe mukaasi yaabho, nɨɨne ɨmbe mukaasi yaabho.” ");
INSERT INTO mgq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","We uYeesu aamala kupuuta, akhasogola na bhalandati bhaakwe, bhakhafumiila ɨkhombe ɨlya Kidulooni. Panaapo páamɨle ni bositaani, uYeesu akhinjila mʉnʉʉmwo peeka na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ɄYʉʉda we akhanzaga kʉmʉlonjeelela uYeesu ápamanyile panaapo, kʉnongwa ye uYeesu akhakhomaanaga akhinji bhʉʉlo kʉnʉʉkwo na bhalandati bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pe ʉYʉʉda akhɨnza mu bositaani yɨnɨɨyo, ayɨlongooye ɨmpʉga ɨya bhasikaali abha Shiluumi, peeka na bhalindiilili abhi Nyumba iMfinjile. Bháamɨle na mataala, ɨnhozyo nɨ vɨlwɨlo. ");
INSERT INTO mgq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","UYeesu ámanyile zyonti zye zɨtɨmwaje. Pe akhafumila pɨlongolela yaabho, akhabhabhʉzɨɨlɨzya akhatɨ, “Mʉkʉmwanza wu naanu?” ");
INSERT INTO mgq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Abheene bhakhamwamʉla bhakhatɨ, “Tʉkʉmwanza uYeesu ʉwa ku Naazaleti.” UYeesu akhabhaamʉla akhatɨ, “Ɨne ne neene.” ɄYʉʉda we ámʉlonjeleeye áyɨmɨlɨɨye peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pe we uYeesu abhabhʉʉzya kʉtɨ, “Ɨne ne neene,” abhasikaali bhaala bhakhagalʉkha kʉlʉsalo na kugwa paasɨ. ");
INSERT INTO mgq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","UYeesu akhabhabhʉzɨɨlɨzya winza akhatɨ, “Mʉkʉmwanza wu naanu?” Bhoope bhakhamwamʉla bhakhatɨ, “Tʉkʉmwanza uYeesu ʉwa ku Naazaleti.” ");
INSERT INTO mgq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","UYeesu akhabhabhʉʉzya akhatɨ, “Imbabhuziizye kʉtɨ ɨne ne neene. Ɨnga mʉkʉnanza neene, bhaleshe abhalandati bhaanɨ ɨbha bhasogolaje.” ");
INSERT INTO mgq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","UYeesu álonjile shɨnɨɨsho ɨnga zɨkwɨle zye álonjile kʉtɨ, “Bhaala bhe wámpiiye intámuteziizye ngaweeka.” ");
INSERT INTO mgq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","USiimoni Peeteli áamɨle nʉ mʉfwo ʉmʉpɨtɨ, pe akhakʉʉla mʉ shɨpata na kumudiba ikutwe ɨlya kʉndɨɨlo umubhombi ʉwa mupuutili ʉmʉpɨtɨ. Umubhombi wʉnʉʉyo ɨtaawa lyakwe áamɨle wu Maalika. ");
INSERT INTO mgq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ɨleelo uYeesu akhamʉbhʉʉzya uPeeteli akhatɨ, “Galʉsya ʉmʉfwo waakho mʉ shɨpata. Bhʉlɨ, ɨntakhondeeye kʉyɨmba anza she ʉTaata waanɨ akwanza kʉtɨ ɨnjɨmbe?” ");
INSERT INTO mgq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pe abhasikaali peeka na bhapɨtɨ bhaabho na bhalindiilili abhi Nyumba iMfinjile, bhakhamʉlema uYeesu na kumupinya. ");
INSERT INTO mgq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pe bhakhamʉtwala kwa Aanasi. UAanasi wʉnʉʉyo áamɨle wʉ tayɨvwala wa Kayaafa, we áamɨle mupuutili mʉpɨtɨ mʉ mwanha wʉnʉʉwo. ");
INSERT INTO mgq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ɄKayaafa wʉnʉʉnʉ we ábhabhuziizye abhalongozi abha Bhayahuudi kʉtɨ, “Kwashi kukwinyu umuntu weeka afwe kʉnongwa ya bhantʉ bhonti.” ");
INSERT INTO mgq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","USiimoni Peeteli peeka nu mulandati ʉwamwabho bhakhamʉlandataga uYeesu kʉlʉsalo. Umulandati ʉwamwabho wʉnʉʉyo ámanyishile kwa mupuutili ʉmʉpɨtɨ, pe akhinjila peeka nu Yeesu mu nyumba ɨya lʉbhʉngaano ɨya mupuutili ʉmʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ɨleelo uPeeteli áyɨmɨlɨɨye kunzi, papɨɨpɨ nʉ mʉlyango. Pe umulandati ʉwamwabho wʉnʉʉyo we ámanyishile kwa mupuutili ʉmʉpɨtɨ, akhafuma kunzi, akhalonga nʉ mʉlɨndʉ we áamɨle mulindiilili pa mʉlyango. Pe akhamwɨtɨshɨzya uPeeteli kwinjila mukaasi. ");
INSERT INTO mgq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Umubhombi ʉmʉlɨndʉ wʉnʉʉyo akhamʉbhʉzɨɨlɨzya uPeeteli akhatɨ, “Bhʉlɨ, nɨɨwe bhʉʉlo ʉtalɨ peeka mu bhalandati bha muntu wʉnʉʉnʉ?” UPeeteli akhamwamʉla akhatɨ, “Ndaali, te neene.” ");
INSERT INTO mgq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kʉnongwa ye kwámɨle ni mpepu, abhatumwa na bhalindiilili bhaala bhápembile ʉmwoto ʉwa mazimwa, bhakhootaga. Woope uPeeteli áyɨmɨlɨɨye peeka nabho, akhootaga ʉmwoto. ");
INSERT INTO mgq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pe umupuutili ʉmʉpɨtɨ ʉla, ɨtaawa lyakwe uAanasi, akhamʉbhʉzɨɨlɨzya uYeesu intumi zya bhalandati bhaakwe nɨ manyɨzyo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","UYeesu akhamwamʉla akhatɨ, “Akhabhalɨlo khonti nalongaga kʉ bhantʉ bhonti apazelu, namanyɨzyaga abhantʉ mu masinagoogi giinyu na mwi linga ilyi Nyumba iMfinjile mwonti mwe aBhayahuudi abhinji bhakʉbhʉngaana peeka. Imanyiziizye ɨmanyɨzyo zyanɨ zyonti apazelu. ");
INSERT INTO mgq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Khooni khe mʉkʉmbʉzɨɨlɨzya ɨne? Bhabhʉzɨɨlɨzye abhantʉ bhe bhantejelezyaga we ɨnkʉmanyɨzya! Abheene bhazimanyile zye nalongaga na kʉmanyɨzya.” ");
INSERT INTO mgq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","UYeesu we alonga zɨnɨɨzyo, umulindiilili weeka we áyɨmɨlɨɨye papɨɨpɨ nawo, akhamʉwaata ni koofi, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ʉkʉmwamʉla anza shɨnɨɨsho umupuutili ʉmʉpɨtɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","UYeesu akhamwamʉla akhatɨ, “Ɨnga nalonga akhabhiibhi, longa uwubhiibhi waanɨ. Ɨleelo ɨnga nalonga zya nalyoli, pe khooni ʉkʉnhoma?” ");
INSERT INTO mgq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pe uYeesu we alɨ she akungiilwe, uAanasi akhalajɨzya kʉtɨ bhamweje na kʉbhala nawo kwa mupuutili ʉmʉpɨtɨ ʉKayaafa. ");
INSERT INTO mgq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pe uSiimoni Peeteli we alɨ she akwota ʉmwoto, abhantʉ bhamu bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, nɨɨwe ʉtalɨ peeka mu bhalandati bha muntu ʉnʉ?” UPeeteli akhakhaana akhatɨ, “Te neene.” ");
INSERT INTO mgq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɨleelo weeka mu bhatumwa bha mupuutili ʉmʉpɨtɨ, we áamɨle wʉ nholo wa muntu ʉla we uPeeteli ámudibile ikutwe, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, te weewe nákulolile we ʉlɨ peeka nu Yeesu mu shiizi?” ");
INSERT INTO mgq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","UPeeteli akhakhaana winza akhatɨ, “Te neene.” Nalʉbhɨlo ɨnhanda yɨkhabhɨlɨshɨla. ");
INSERT INTO mgq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pe shɨlaabhɨla we kwasha, abhalongozi abha Bhayahuudi bhakhamwega uYeesu kufuma kwa Kayaafa na kʉbhala nawo mu ikuulu ɨya mʉpɨtɨ ʉwa Bhaluumi. Ɨleelo abhalongozi bhanaabho bhatakhinjila mukaasi mu ikuulu ɨnga bhatakhayɨkhandamanye, kʉnongwa ye ɨnga bhakhinjilaga nhanɨ bhatítishiliilwe kulya ishaakulya ɨsha shikulukulu ɨshɨ Pasaaka. ");
INSERT INTO mgq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pe umulongozi ʉwa Bhaluumi, ɨtaawa lyakwe ʉPɨlaato, akhafuma kunzi na kʉbhala pe bháamɨle, akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, umuntu wʉnʉʉnʉ abhombile mbiibhi zyoni zye mʉkʉmʉsɨtaaka?” ");
INSERT INTO mgq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Abheene bhakhamwamʉla bhakhatɨ, “Ɨnga umuntu wʉnʉʉnʉ ataamɨle ni mbiibhi, nhanɨ tutinzile nawo kʉkwakho.” ");
INSERT INTO mgq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ɄPɨlaato akhabhabhʉʉzya akhatɨ, “Pe ɨmwe mwegaje, mʉmʉlonje kʉlandatana nɨ ndajɨzyo zyinyu.” Ɨleelo abheene bhakhamwamʉla bhakhatɨ, “Tʉtalɨ nʉ waamʉlo ʉwa kʉmʉlonga umuntu wowonti kʉtɨ afwe.” ");
INSERT INTO mgq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zɨnɨɨzyo zyábhombeshile anza shɨnɨɨsho, ɨnga zye uYeesu álonjile zɨkwɨle kʉlolesya she akhayifwa. ");
INSERT INTO mgq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pe ʉPɨlaato akhinjila winza mukaasi mu ikuulu, akhalajɨzya kʉtɨ bhamʉleete uYeesu kʉkwakwe, akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, ɨwe we Mwene wa Bhayahuudi?” ");
INSERT INTO mgq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ɨleelo uYeesu akhamwamʉla akhatɨ, “Bhʉlɨ, zye ʉkʉmbʉzɨɨlɨzya, zikufuma mʉ nsɨɨbho zyakho awe abhantʉ abhanjɨ bhakubhuziizye intumi zyanɨ?” ");
INSERT INTO mgq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ɄPɨlaato akhamwamʉla akhatɨ, “Bhʉlɨ, ɨne ne Muyahuudi? Abhantʉ abhɨ nsɨ yaakho peeka na bhapɨtɨ abha bhapuutili bhe bhakuleetile kʉkwanɨ ɨnga ɨnkʉlonje. Bhʉlɨ, ubhombile zyoni?” ");
INSERT INTO mgq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","UYeesu akhamwamʉla akhatɨ, “Ʉwʉmwene waanɨ te wa mʉ nsɨ umu. Ɨnga wʉbhanje wa mʉ nsɨ umu, pe abhalandati bhaanɨ bhaamɨle bhangakhola kʉndwɨlɨla kʉtɨ ɨntaalemwe na bhalongozi abha Bhayahuudi. Ɨleelo ʉwʉmwene waanɨ te wa mʉ nsɨ umu.” ");
INSERT INTO mgq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pe ʉPɨlaato akhamʉbhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, zya nalyoli kʉtɨ ɨwe we mwene?” UYeesu akhamwamʉla akhatɨ, “Weewe walonga kʉtɨ ɨne ne mwene. Ɨne nápapiilwe mʉ nsɨ umu, khabhɨlɨ nínzile ɨpa, ɨnga ɨmbamanyɨzye abhantʉ uwanalyoli. Umuntu wowonti we akʉwʉlandata uwanalyoli, akwɨmvwa amazwi gaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ɄPɨlaato akhamʉbhʉzɨɨlɨzya akhatɨ, “Uwanalyoli khe khooni?” We alonga zɨnɨɨzyo, ʉPɨlaato akhafuma kunzi, akhabhabhʉʉzya aBhayahuudi akhatɨ, “Ɨne ɨntayaaga ɨnongwa naayimo ɨya kʉmʉsɨtaaka umuntu ʉnʉ. ");
INSERT INTO mgq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ɨleelo mʉlɨ nɨ mwata ɨya kʉndaabha kʉtɨ ɨmʉsatʉlɨle ʉmʉkʉngwa weeka mʉ khabhalɨlo akhi shikulukulu ɨshɨ Pasaaka. Bhʉlɨ, mʉkwanza ɨmbasatʉlɨle ʉMwene ʉwa Bhayahuudi?” ");
INSERT INTO mgq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɨleelo abhantʉ bhonti bhakhazingula ɨshongo bhakhatɨ, “Ndaali! Ʉtatʉsatʉlɨlaje umuntu wʉnʉʉyo, lyoli ʉtʉsatʉlɨle ʉBalaaba.” ɄBalaaba ákungiilwe kʉnongwa ɨya kʉpɨnga isilikaali ɨya Bhaluumi. ");
INSERT INTO mgq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pe ʉPɨlaato akhamwega uYeesu mukaasi, akhabhalajɨzya abhasikaali bhaakwe kʉtɨ bhamʉkhome nɨ sambogo. ");
INSERT INTO mgq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abhasikaali bhakhatabha ishipambwi ɨsha mimvwa, bhakhamʉkwatɨzya kwi twe. Khabhɨlɨ bhakhamʉkwatɨzya ɨgolole ishamamizu ɨlya shɨmwene. ");
INSERT INTO mgq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakhabhalaga kʉkwakwe, bhakhamʉlamʉkhaga bhakhatɨnjɨ, “Waagona, we Mwene wa Bhayahuudi!” Bhakhamʉkhomaga na makoofi. ");
INSERT INTO mgq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ɄPɨlaato akhafuma kunzi winza, akhayɨbhʉʉzya ɨmpʉga ɨya bhantʉ bhaala akhatɨ, “Tejeelezyi, namʉleeta kunzi kukwinyu umuntu ʉnʉ, ɨnga mʉmanye kʉtɨ ɨntaalola ɨnongwa naayimo ɨya kʉmʉsɨtaaka.” ");
INSERT INTO mgq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pe bhakhamufumwa uYeesu kunzi we akwatile ishipambwi ɨsha mimvwa nɨ nkanzʉ inshamamizu. Pe ʉPɨlaato akhalonga apazelu akhatɨ, “Yeenya umuntu nyeene wʉ wʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Abhapɨtɨ abha bhapuutili na bhalindiilili abhi Nyumba iMfinjile we bhamʉlola uYeesu, bhakhazingula ɨshongo bhakhatɨ, “Mʉkhomeele pa shɨkhobhenhanyo, mʉkhomeele pa shɨkhobhenhanyo!” Pe ʉPɨlaato akhabhabhʉʉzya akhatɨ, “Mwegaje ɨmwe mʉneemwe, mʉmʉkhomeele pa shɨkhobhenhanyo, kʉnongwa ye ɨne ɨntayaaga ɨnongwa naayimo ɨya kʉmʉsɨtaaka.” ");
INSERT INTO mgq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abhalongozi abha Bhayahuudi bhakhamwamʉla bhakhatɨ, “Ɨtwe tʉlɨ nɨ ndajɨzyo. Kʉlandatana nɨ ndajɨzyo yɨnɨɨyo, akwanzɨwa kʉgogwa, kʉnongwa ye akʉyɨlonjela kʉtɨ Mwana wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ɄPɨlaato we ayɨmvwa amazwi ganaago, akhonjezya kwogopa nhaani. ");
INSERT INTO mgq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pe akhinjila winza mu nyumba yaakwe, akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “Wumuntu ɨwe, ufumile kwoshi?” Ɨleelo uYeesu atakhamwamʉla naalimo. ");
INSERT INTO mgq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pe ʉPɨlaato akhamwamʉla akhatɨ, “Khooni ʉtakʉnaamʉla? Bhʉlɨ, utamanyile kʉtɨ ɨndɨ nʉ waamʉlo ʉwa kʉkʉsatʉlɨla, khabhɨlɨ nʉ wa kʉkʉkhomeela pa shɨkhobhenhanyo?” ");
INSERT INTO mgq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","UYeesu akhamwamʉla ʉPɨlaato akhatɨ, “Nhanɨ ʉtalɨ nʉ waamʉlo wowonti kʉkwanɨ ɨnga ʉtapewaaje nʉ Mʉlʉngʉ. Ɨleelo umuntu ʉla we ambiishile mʉ nyoobhe zyakho, alɨ ni mbiibhi ɨmpɨtɨ nhaani kʉshɨla imbiibhi yaakho.” ");
INSERT INTO mgq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pe ʉPɨlaato we ayɨmvwa zɨnɨɨzyo, akhanzaga ɨdala ɨlya kʉmʉsatʉlɨla uYeesu. Ɨleelo abhalongozi abha Bhayahuudi bhakhonjezya kuzingula ɨshongo bhakhatɨ, “Ɨnga wamʉsatʉlɨla umuntu wʉnʉʉyo, pe te we manyani wa Kaisaali. Umuntu wowonti we akʉyɨbhɨɨkha kʉtɨ wʉ mwene, akʉmʉpɨnga wʉ mwene ʉwa Bhaluumi.” ");
INSERT INTO mgq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ɄPɨlaato we ayɨmvwa amazwi ganaago, akhamʉleeta uYeesu kunzi, akhabhala kwɨkhala pɨ tengo ɨlya kʉlonjela ɨnongwa, papaala bhakhatɨnjɨ, “ɄLʉbhʉngo ʉlwa Mawe.” Ɨtaawa liniili mʉ ndongo ɨya Bhayahuudi bhakʉtɨ Gabaata. ");
INSERT INTO mgq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lyámɨle lisiku ɨlya kʉyɨlɨngaanya kʉnongwa ɨya shikulukulu ɨshɨ Pasaaka mʉ khabhalɨlo khe ɨzʉbha lyámɨle pi twe. ɄPɨlaato akhayɨbhʉʉzya ɨmpʉga ɨya bhantʉ akhatɨ, “Yeenya, ʉmwene wiinyu wʉ wʉʉnʉ!” ");
INSERT INTO mgq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Abheene bhakhazingula ɨshongo bhakhatɨ, “Mʉgoje, mʉgoje! Mʉkhomeele pa shɨkhobhenhanyo!” ɄPɨlaato akhabhabhʉzɨɨlɨzya akhatɨ, “Bhʉlɨ, mʉkwanza ɨmʉkhomeele pa shɨkhobhenhanyo ʉmwene wiinyu?” Abhapɨtɨ abha bhapuutili bhakhamwamʉla bhakhatɨ, “Ɨtwe tʉtalɨ nʉ mwene ʉwamwabho, ɨleelo weeka mwene uKaisaali!” ");
INSERT INTO mgq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pe kʉwʉmalɨlɨshɨlo, ʉPɨlaato akhamʉbhɨɨkha uYeesu mʉ nyoobhe zyabho ɨnga bhamʉkhomeele pa shɨkhobhenhanyo. Pe abhasikaali bhakhamwega uYeesu bhakhabhala nawo. ");
INSERT INTO mgq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Akhapɨmba ɨshɨkhobhenhanyo shaakwe, akhafuma kunzi ɨyɨ nhaaya, akhabhala paala pe mʉ ndongo yaabho bhakʉtɨ Goligoota, kwe kʉtɨ, “Pi Fupa ilyi Twe.” ");
INSERT INTO mgq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","We bhaafikha paala, bhakhamʉkhomeela uYeesu pa shɨkhobhenhanyo. Papaala bhálɨɨpo abhantʉ abhanjɨ bhabhɨlɨ bhe bhábhakhomeleeye pa vɨkhobhenhanyo peeka nawo, weeka kʉmbalɨ ɨya kʉndɨɨlo nʉ wamwabho kʉmbalɨ ɨya kʉmongo. ");
INSERT INTO mgq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ɄPɨlaato akhalajɨzya kʉtɨ gasimbwe amazwi na kʉgabhɨɨkha pa shɨkhobhenhanyo sha Yeesu, ge gakʉtɨ, “Ʉnʉ wu Yeesu ʉwa ku Naazaleti, ʉMwene ʉwa Bhayahuudi.” ");
INSERT INTO mgq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Uwusimbe wʉnʉʉwo wásimbiilwe mʉ ndongo ɨya Bhayahuudi, aBhaluumi, na Bhayunaani. ABhayahuudi abhinji bhakhabhazyaga uwusimbe wʉnʉʉwo, kʉnongwa ye panaapo pe bhámʉkhomeleeye pa shɨkhobhenhanyo, páamɨle papɨɨpɨ na mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pe abhapɨtɨ abha bhapuutili bhakhamʉbhʉʉzya ʉPɨlaato kʉtɨ, “Utasimbaje kʉtɨ, ‘Ʉnʉ wʉ Mwene ʉwa Bhayahuudi,’ lyoli usimbe kʉtɨ, ‘Umuntu ʉnʉ álonjile kʉtɨ, ʉweene wʉ Mwene wa Bhayahuudi.’ ” ");
INSERT INTO mgq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ɄPɨlaato akhabhaamʉla akhatɨ, “Ndaali, uwusimbe wʉsyale shɨnɨɨsho anza she indajiziizye.” ");
INSERT INTO mgq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Abhasikaali we bhamʉkhomeela uYeesu pa shɨkhobhenhanyo, bhakheega amenda gaakwe, bhakhagabhʉlanya ɨvɨlʉndo vini. Umusikaali weeka weeka akheega sheeka sheeka. Khabhɨlɨ bhakheega ɨnkanzʉ ye yátabhiilwe, yáamɨle mwenda weeka bhʉʉlo, yɨtáamɨle na pe bhasonile ngapeeka. ");
INSERT INTO mgq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pe bhakhazaabhana bhakhatɨ, “Tutadebulanye ɨnkanzʉ ɨnɨ, lyoli tʉkhome ɨkʉʉla kʉtɨ yɨbhe ya naanu.” Zɨnɨɨzyo zyábhombeshile ɨnga wʉkwɨle uWusimbe uWufinjile we wʉkʉtɨ, “Bhágabhiine amenda gaanɨ, na kʉkhoma ɨkʉʉla kʉ nkanzʉ yaanɨ.” Zye bhábhombile abhasikaali. ");
INSERT INTO mgq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bhálɨɨpo abhantanda abhanjɨ bhani bhe bhɨ́mɨlɨɨye papɨɨpɨ nɨ shɨkhobhenhanyo sha Yeesu. Abhantanda bhanaabho álɨɨpo unyina wa Yeesu, unyina umunsi ʉwa Yeesu, uMaliya ʉmʉshɨ wa Kileopa, nu Maliya ʉwa mʉ nhaaya ɨya mu Magidaala. ");
INSERT INTO mgq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","UYeesu we amʉlola unyina waakwe, nu mulandati we ámuganile nhaani ayɨmɨlɨɨye papɨɨpɨ nu nyina waakwe, akhatɨ, “We nyina waanɨ, mwenye ʉnʉ. Ʉmʉbhɨɨshe abhe mwana waakho.” ");
INSERT INTO mgq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Khabhɨlɨ akhamʉbhʉʉzya umulandati ʉla akhatɨ, “Mwenye ʉnʉ. Ʉmʉbhɨɨshe kʉbha wu nyina waakho.” Pe kufuma akhabhalɨlo khakhaala umulandati ʉla akhamwega unyina wa Yeesu, akhabhala kwɨkhala nawo mu nyumba yaakwe. ");
INSERT INTO mgq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pe uYeesu akhamanya kʉtɨ aamala kʉyɨbhomba ɨmbombo yaakwe. Akhalonga akhatɨ, “Ɨnkʉlola ɨshʉʉmɨlwa ɨsha minzi.” Pe shɨnɨɨsho zɨkhakwɨla zye zisimbiilwe mu Wusimbe uWufinjile. ");
INSERT INTO mgq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Papaala kwámɨle nɨ shɨlɨɨlo she bhizuziizye idivaayi ye yilulile. Pe bhakheega akhagodoolo bhakhatumbikha mu divaayi yɨnɨɨyo, bhakhasyempa mwi lanzi, bhakhamʉleetela uYeesu kwi lomu. ");
INSERT INTO mgq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","We uYeesu alɨnga idivaayi yɨnɨɨyo, akhalonga akhatɨ, “Ɨmbombo yaanɨ yakwɨla!” Pe akhasʉlamɨkha itwe, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lyámɨle lisiku ɨlya kʉyɨlɨngaanya nɨ Sabaato. Abhalongozi abha Bhayahuudi bhatakhanzaga amavimba gasyale pa shɨkhobhenhanyo isiku ɨlyɨ Sabaato, kʉnongwa ye ɨSabaato yɨnɨɨyo nhanɨ yáamɨle shikulukulu. Bhámulaabhile ʉPɨlaato, alajɨzye abhasikaali kʉtɨ bhavunzanye ɨvɨnama vwa bhantʉ bhe bhábhakhomeleeye ɨnga bhafwe nalʉbhɨlo, na kwefwa amavimba gaabho pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pe abhasikaali bhakhabhala, bhakhamuvunza ɨvɨnama umuntu ʉwa kwanda nʉ wa wʉbhɨlɨ bhe bhábhakhomeleeye peeka nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ɨleelo we bhaafikha pa Yeesu, bhakhaaga afuuye, pe bhatakhamuvunza ɨvɨnama. ");
INSERT INTO mgq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ɨleelo umusikaali weeka akhamʉlasa uYeesu nɨ mpalala kʉ lʉbhazʉ, pe ɨbhanda na minzi vikhafuma. ");
INSERT INTO mgq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɨnongwa ziniizi wukeeti wa muntu we akhalolaga zye zɨkhabhombekhaga. Uwusimishizyo waakwe wa nalyoli, khabhɨlɨ amanyile kʉtɨ akʉlonga zya nalyoli, woope akusimishizya ɨnga nɨɨmwe mwɨtɨshe. ");
INSERT INTO mgq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Zɨnɨɨzyo zyábhombeshile ɨnga uWusimbe uWufinjile wʉkwɨle we wʉkʉtɨ, “Lɨtalɨɨpo ifupa lyakwe lye likhayivunzwa.” ");
INSERT INTO mgq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Khabhɨlɨ uWusimbe uWufinjile uwunji wʉkʉtɨ, “Bhakhayɨmwenya we bhámulasile nɨ mpalala.” ");
INSERT INTO mgq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","We zɨnɨɨzyo zyashɨla, uYoosefu ʉmʉkhaaya ʉwa ku Alimasaaya akhamʉlaabha ʉPɨlaato amwɨtɨshɨzye kwega ivimba lya Yeesu. UYoosefu áamɨle mulandati wa Yeesu kukwilu, kʉnongwa ye akhabhogopaga abhalongozi abha Bhayahuudi. Pe ʉPɨlaato, akhamwɨtɨshɨzya, uYoosefu akheega ivimba lya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pe uNikodeemu, we akhabhalɨlo khamu ábhalile kwa Yeesu shawusiku, akhɨnza na mafuta ge gakununshiilila akhinza, nɨ manemaane ge galɨ nu wumwamu kʉshɨla ikiilo amashumi gatatʉ. ");
INSERT INTO mgq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pe bhakheega ivimba lya Yeesu, bhakhalɨsyempa ni kibha na kʉlɨpakha amafuta ge gakununshiilila anza she wáamɨle ʉmwata wa Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Papaala pe bhámʉkhomeleeye uYeesu páamɨle ni bositaani. Mu bositaani muula mwámɨle nɨ mbɨɨpa impwa ye bhatásyɨlɨɨye umuntu naalumo. ");
INSERT INTO mgq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kʉnongwa ye lyámɨle lisiku ɨlya Bhayahuudi kʉyɨlɨngaanya nɨ Sabaato, khabhɨlɨ kʉnongwa ye ɨmbɨɨpa yiila yáamɨle papɨɨpɨ, bhakhamʉsyɨla uYeesu mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Isiku ɨlya Pamʉlʉngʉ ɨshɨlaabhɨla we kʉshɨɨlɨ kuzelupa, uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala akhabhala kʉ mbɨɨpa. Akhaaga iwe liila lye lyámɨle pa mʉlyango ʉwɨ mbɨɨpa libhungulusye. ");
INSERT INTO mgq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pe akhasogola paala, akhashɨmbɨla nalʉbhɨlo kʉbhala kwa Siimoni Peeteli na kwa mulandati ʉla we uYeesu ámuganile nhaani. Akhabhabhʉʉzya akhatɨ, “Bhefwizye ivimba lya Mwene mʉ mbɨɨpa, tutamanyile kwe bhalibhiishile!” ");
INSERT INTO mgq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","UPeeteli nu mulandati ʉwamwabho ʉla, bhakhasogola kʉbhala kʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhonti bhabhɨlɨ bhakhashɨmbɨlaga we bhakʉbhala, ɨleelo umulandati ʉwamwabho ʉla akhonjezya kʉshɨmbɨla kʉmʉshɨla uPeeteli na kʉlongolela kufikha pa mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","We aafikha, akhagunzama, akhɨnanjɨzya mʉ mbɨɨpa, akhalɨlola ikibha, ɨleelo atakhinjila mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pe uSiimoni Peeteli woope akhafikha paala, ɨleelo ʉweene akhinjila mʉ mbɨɨpa akhalɨlola ikibha, ");
INSERT INTO mgq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nɨ shɨtambaala she bhámusyempile uYeesu kwi twe. Ɨshɨtambaala shɨnɨɨsho shɨtáamɨle peeka ni kibha lye bhámʉsyɨlɨlɨɨye uYeesu, lyoli sháamɨle shipintaanye, sháamɨle sheene pambalɨ. ");
INSERT INTO mgq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pe umulandati ʉla ʉwamwabho we átalile kufikha pa mbɨɨpa, woope akhinjila akhalola, akhɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ɨleelo kufishila mʉ khabhalɨlo khanaakho, abhalandati bha Yeesu bháshɨɨlɨ kʉwaaganya uWusimbe uWufinjile kʉtɨ uYeesu akhondeeye kʉzyʉkha kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pe abhalandati bhanaabho bhakhagalʉkha kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ɨleelo uMaliya ʉwa ku Magidaala áyɨmɨlɨɨye panzɨ pa mbɨɨpa, akhalɨlaga. We akʉlɨla, akhagunzama akhɨnanjɨzya mʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akhabhalola abhakhabhɨzya bhabhɨlɨ bhe bhakwatile amenda amazelu, bhɨkhaaye pe bhálambalishile ivimba lya Yeesu. Ʉkhabhɨzya weeka áyɨkhaaye kwe itwe lyámɨle, nʉ wamwabho áyɨkhaaye pe ɨvɨnama vwámɨle. ");
INSERT INTO mgq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Abhakhabhɨzya bhanaabho bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “We maayɨ, ʉkʉlɨla khooni?” Woope akhabhaamʉla akhatɨ, “Ɨnkʉlɨla kʉnongwa ye bhefwizye ivimba lya Mwene waanɨ, khabhɨlɨ intamanyile kwe bhalibhiishile!” ");
INSERT INTO mgq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","We uMaliya alonga zɨnɨɨzyo, akhagalʉnhana kʉlʉsalo, akhamʉlola uYeesu ayɨmɨlɨɨye panaapo. Ɨleelo atakhamʉmanya kʉtɨ wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","UYeesu akhamʉbhʉzɨɨlɨzya akhatɨ, “We maayɨ, ʉkʉlɨla khooni? Ʉkʉmwanza wu naanu?” UMaliya akhasɨɨbhaga kʉtɨ umuntu wʉnʉʉyo mubhombi wa mu bositaani, akhamwamʉla akhatɨ, “Wa lushindikho, ɨnga weewe ulyefwizye ivimba lya Yeesu, ɨnkʉkʉlaabha ʉmbʉʉzye kwe ulibhiishile, nɨɨne ɨntɨbhale kʉlyega.” ");
INSERT INTO mgq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","UYeesu akhamʉbhɨlɨshɨla akhatɨ, “We Maliya!” Pe uMaliya akhagalʉnhana kʉlʉsalo na kʉmʉlola uYeesu, akhalonga mʉ ndongo yaakwe akhatɨ, “Labooni!” Kwe kʉtɨ, “Mumanyizyi.” ");
INSERT INTO mgq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","UYeesu akhamʉbhʉʉzya uMaliya akhatɨ, “Lakha ʉtandemaje, kʉnongwa ye intabhalile kʉmwanya kwa Taata. Ɨleelo bhalaga ʉbhabhʉʉzye abhanholo bhaanɨ kʉtɨ ɨnkʉbhala kʉmwanya kwa Taata waanɨ we wʉ Taata wiinyu, kwa Mʉlʉngʉ waanɨ we wʉ Mʉlʉngʉ wiinyu.” ");
INSERT INTO mgq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pe uMaliya ʉwa mʉ nhaaya ɨya mu Magidaala akhabhala ku bhalandati bha Yeesu. Akhabhabhʉʉzya akhatɨ, “Ɨne imulolile ʉMwene uYeesu!” Akhabhabhʉʉzya zyonti zye uYeesu ámulajiziizye. ");
INSERT INTO mgq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pi siku liliila ɨlya Pamʉlʉngʉ shalyabheela, abhalandati bha Yeesu bhábhungaanile mu nyumba yimo, bhɨ́galɨɨye amalyango kʉnongwa ye bhakhabhogopaga abhalongozi abha Bhayahuudi. Pe uYeesu akhafumila akhɨmɨɨlɨla pakaasi yaabho akhatɨ, “Uwutengaanu wʉbhe peeka nɨɨmwe!” ");
INSERT INTO mgq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","We alonga amazwi ganaago, akhabhalanga ɨnyoobhe zyakwe nʉ lʉbhazʉ lwakwe. Pe abhalandati bhaakwe bhakhaseshela nhaani we bhamʉlola ʉMwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","UYeesu akhabhabhʉʉzya winza akhatɨ, “Uwutengaanu wʉbhe peeka nɨɨmwe. Anza she ʉTaata ʉMʉlʉngʉ ansonteleziizye ɨne, nɨɨne ɨnkʉbhasonteelezya ɨmwe.” ");
INSERT INTO mgq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","We uYeesu alonga amazwi ganaago, akhabhapuutila umwoyi, akhabhabhʉʉzya akhatɨ, “Posheelaji uMupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɨnga mwabhatʉʉyɨla abhantʉ imbiibhi zyabho, ʉMʉlʉngʉ abhatʉyɨɨye. Ɨleelo ɨnga mʉtabhatʉʉyɨla, ʉMʉlʉngʉ atabhatʉyɨɨye imbiibhi zyabho.” ");
INSERT INTO mgq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ɨleelo uToomasi, we bhakhamʉtekhaga kʉtɨ Mwoga, atáamɨle peeka na bhalandati abhamwabho we uYeesu akʉbhaloleshela. ");
INSERT INTO mgq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pe abhalandati abhanjɨ bhaala bhakhamʉbhʉʉzya bhakhatɨ, “Tumulolile ʉMwene uYeesu.” Ɨleelo uToomasi akhatɨ, “Ɨne ɨntagɨɨtɨkha ɨnga ɨntaalola amabhamba aga masumaali mʉ nyoobhe zyakwe, na kʉmʉpalamansya nɨ nsamba zyanɨ mʉ mabhamba ganaago na kʉpalamansya mʉ lʉbhazʉ lwakwe.” ");
INSERT INTO mgq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","We zyashɨla insiku naane, abhalandati bha Yeesu bháamɨle peeka winza mukaasi. UToomasi woope áamɨle peeka nabho. Amalyango gáamɨle magalɨle, ɨleelo uYeesu akhɨnza, akhɨmɨɨlɨla pakaasi yaabho, akhatɨ, “Uwutengaanu wʉbhe peeka nɨɨmwe!” ");
INSERT INTO mgq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pe akhamʉbhʉʉzya uToomasi akhatɨ, “Bhɨɨkha akhasamba khaakho ɨpa, ʉlole ɨnyoobhe zyanɨ, golosya ɨnyoobhe yaakho ʉpalamansye pa lʉbhazʉ lwanɨ. Ʉtabhanje ni nsyosi, lyoli ʉyɨɨtɨshe.” ");
INSERT INTO mgq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","UToomasi akhamwamʉla akhatɨ, “Mwene waanɨ, Mʉlʉngʉ waanɨ!” ");
INSERT INTO mgq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","UYeesu akhamʉbhʉʉzya akhatɨ, “Wɨɨtɨkha kʉnongwa ye wandola. Bhasayiilwe bhaala bhe bhitishile sita kʉndola.” ");
INSERT INTO mgq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","UYeesu ábhombile ɨvɨlolesyo ɨvwamwabho ivwinji pɨlongolela pa bhalandati bhaakwe, vwe vitasimbiilwe mu shitaabu ishi. ");
INSERT INTO mgq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɨleelo viniivi visimbiilwe ɨnga mwɨtɨshe kʉtɨ uYeesu we wu Kilisiti, ʉMwana wa Mʉlʉngʉ. Kwɨ dala ɨlya kʉmwɨtɨkha, mʉwaaje uwuumi ʉwa wiila na wiila, mʉ makha gɨ taawa lyakwe. ");
INSERT INTO mgq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","We zɨnɨɨzyo zyashɨla, uYeesu akhayɨlolesya winza ku bhalandati bhaakwe pambalɨ pa sʉmbɨ ʉwa Tibeeliya, mʉ nsɨ ɨya mʉ Galɨlaaya. ");
INSERT INTO mgq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Isiku limo, uSiimoni Peeteli, uToomasi we bhakhamʉtekhaga kʉtɨ Mwoga, uNasanaeli we akhafumaga mʉ nhaaya ɨya mʉ Kaana ye yɨlɨ mʉ Galɨlaaya, abhaana bhabhɨlɨ abha Zebedaayo na bhalandati abhanjɨ bhabhɨlɨ bháamɨle peeka. ");
INSERT INTO mgq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","USiimoni Peeteli akhabhabhʉʉzya abhamwabho akhatɨ, “Ɨnkʉbhala kʉzʉbhʉla inswi.” Bhoope bhakhamwamʉla bhakhatɨ, “Nɨɨtwe tʉkʉbhala peeka nɨɨwe kʉzʉbhʉla inswi.” Pe bhakhabhala, bhakhazʉbha mʉ shɨtʉʉlɨ, bhakhazʉbhʉla wusiku wonti, ɨleelo bhatakhalema inswi ngayeeka. ");
INSERT INTO mgq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","We kwazelupa, uYeesu akhɨmɨɨlɨla mʉ mʉmbalɨ mwa sʉmbɨ, ɨleelo abhalandati bhaakwe bhatakhamʉmanyaga kʉtɨ wu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pe uYeesu akhabhabhɨlɨshɨla akhatɨ, “Ɨmwe bhamanyani bhaanɨ, mwalema inswi zimo?” Abheene bhakhamwamʉla bhakhatɨ, “Ndaali, tʉtaalema inswi ngazyeka.” ");
INSERT INTO mgq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","UYeesu akhabhabhʉʉzya akhatɨ, “Sumbi inyaavu kʉmbalɨ ɨya kʉndɨɨlo kʉ shɨtʉʉlɨ, nɨɨmwe mʉtɨleme inswi.” Pe bhakhasʉmba inyaavu mwa sʉmbɨ, bhakhalema inswi inyinji nhaani, bhakhapootwa kʉzɨkwesa inyaavu. ");
INSERT INTO mgq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Umulandati ʉla we uYeesu ámuganile nhaani, akhamʉbhʉʉzya uPeeteli akhatɨ, “Umuntu wʉnʉʉnʉ wʉ Mwene uYeesu!” We uSiimoni Peeteli ayɨmvwa kʉtɨ wʉ Mwene, akhakwata ʉmwenda waakwe we ázuulile we ayanda kʉzʉbhʉla inswi, akhayɨsʉmba mwa sʉmbɨ muula. ");
INSERT INTO mgq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abhalandati bhaala abhanjɨ bhakhabhala kʉmbalɨ nɨ shɨtʉʉlɨ we bhakʉkwesa inyaavu zye zyizuuye inswi. Bhatáamɨle ukutali na kʉmbalɨ, lyoli bháamɨle uwutali ʉwa kʉtambʉkha ɨnyaayo imia yeeka (100) bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","We bhaafikha kʉmbalɨ, bhakhaaga ʉmwoto ʉwa mazimwa wupembiilwe. Pamwanya pa mwoto wuula páamɨle ni nswi ni kaati. ");
INSERT INTO mgq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","UYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Nzaaji ɨpa ni nswi nyishe zye mʉzʉbhʉʉye.” ");
INSERT INTO mgq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pe uSiimoni Peeteli akhinjila winza mʉ shɨtʉʉlɨ, akhazɨkwesela kʉmbalɨ inyaavu ziila zye zyizuuye inswi. Mu nyaavu muula mwámɨle inswi ɨmpɨtɨ imia yeeka na mashumi gasaanʉ na zɨtatʉ (153). Peeka na kʉtɨ inswi zyámɨle nyinji nhaani, poope shɨnɨɨsho inyaavu zitádumushile. ");
INSERT INTO mgq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","UYeesu akhabhabhʉʉzya abhalandati bhaakwe akhatɨ, “Nzaaji mulye ishaakulya ɨsha shɨlaabhɨla.” Atálɨɨpo umulandati we álinjile kʉmʉbhʉzɨɨlɨzya kʉtɨ, “Bhʉlɨ, ɨwe we naanu?” Kʉnongwa ye bhámanyile kʉtɨ wʉ Mwene. ");
INSERT INTO mgq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","UYeesu akheega ikaati, akhaabhapa abhalandati bhaakwe. Khabhɨlɨ akheega zyope inswi na kʉbhomba shishiila. ");
INSERT INTO mgq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Khanaakho kháamɨle kha wʉtatʉ uYeesu kʉbhaloleshela abhalandati bhaakwe, we ʉMʉlʉngʉ amʉzyʉsya kufuma kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","We bhaamala, uYeesu akhamʉbhʉzɨɨlɨzya uPeeteli akhatɨ, “We Siimoni mwana wa Yookhani, bhʉlɨ, unganile ɨne nhaani kʉshɨla she ubhaganile abhamwinyu ɨbha?” UPeeteli akhamwamʉla akhatɨ, “She zɨlɨ Mwene, ɨwe umanyile kʉtɨ inkuganile.” UYeesu akhamʉbhʉʉzya akhatɨ, “Sʉnga akhinza abhantʉ bhaanɨ bhe bhalɨ anzɨ ngoole.” ");
INSERT INTO mgq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","UYeesu akhamʉbhʉzɨɨlɨzya uPeeteli akha wʉbhɨlɨ akhatɨ, “We Siimoni mwana wa Yookhani, bhʉlɨ, unganile?” UPeeteli akhamwamʉla akhatɨ, “She zɨlɨ Mwene, ɨwe umanyile kʉtɨ inkuganile.” UYeesu akhamʉbhʉʉzya uPeeteli akhatɨ, “Sʉnga akhinza abhantʉ bhaanɨ bhe bhalɨ anzɨ ngoole.” ");
INSERT INTO mgq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akhamʉbhʉzɨɨlɨzya akha wʉtatʉ akhatɨ, “We Siimoni mwana wa Yookhani, bhʉlɨ, unganile?” Pe uPeeteli akhaswɨmɨɨlɨla kʉnongwa ye uYeesu akhamʉbhʉzɨɨlɨzya akha wʉtatʉ, kʉtɨ, “Bhʉlɨ, unganile?” Akhamwamʉla akhatɨ, “We Mwene, ɨwe umanyile zyonti. Umanyile kʉtɨ inkuganile.” UYeesu akhamʉbhʉʉzya akhatɨ, “Sʉnga akhinza abhantʉ bhaanɨ bhe bhalɨ anzɨ ngoole. ");
INSERT INTO mgq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nalyoli ɨnkʉkʉbhʉʉzya, akhabhalɨlo khe wáamɨle we mutunta, wálʉbhɨɨye kʉyɨkwatɨzya amenda gaakho wʉneewe na kʉbhala kwonti kwe ʉkhanzaga. Ɨleelo we wagoosipa, ʉtɨgolosyaje ɨnyoobhe zyakho, umuntu uwunji atɨkʉkwatɨzyaje amenda gaakho na kʉbhala nɨɨwe kwe ʉtakwanza kʉbhala.” ");
INSERT INTO mgq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","UYeesu álonjile shɨnɨɨsho kʉlolesya ɨdala lye uPeeteli akhayifwa ɨnga amʉpaale ʉMʉlʉngʉ. We uYeesu alonga amazwi ganaago, akhamʉbhʉʉzya uPeeteli akhatɨ, “Ndandate.” ");
INSERT INTO mgq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pe uPeeteli akhashebhela kʉlʉsalo, akhamʉlola umulandati we uYeesu ámuganile nhaani, akʉbhalandata. Umulandati wʉnʉʉyo we wʉ wʉʉla we áyɨkhaaye papɨɨpɨ nu Yeesu we bhalɨ kulya ishaakulya ɨsha shalyabheela. Khabhɨlɨ we wʉ wʉʉla we akhamʉbhʉzɨɨlɨzya uYeesu kʉtɨ, “We Mwene, wu naanu we atɨkʉlonjeelele kʉ bhalʉgʉ?” ");
INSERT INTO mgq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pe we uPeeteli amʉlola umulandati ʉla, akhamʉbhʉzɨɨlɨzya uYeesu akhatɨ, “We Mwene, bhʉlɨ, khooni khe khatifumile kwa mulandati wʉnʉʉyo?” ");
INSERT INTO mgq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","UYeesu akhamwamʉla uPeeteli akhatɨ, “Ɨnga ɨnkwanza kʉtɨ abhe mwumi kufishila akhabhalɨlo khe ɨnhayɨgalʉkha, khooni khe zɨnɨɨzyo zɨkʉkʉyɨmvwa mʉ mwoyo waakho? Ɨwe ndandate.” ");
INSERT INTO mgq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɨnongwa zɨnɨɨzyo zɨkhasaata mu bhalandati, kʉtɨ umulandati wʉnʉʉyo te akhaafwe. Ɨleelo uYeesu atakhamʉbhʉzyaga umulandati wʉnʉʉyo kʉtɨ te akhaafwe naalumo, lyoli álonjile átɨlɨ, “Ɨnga ɨnkwanza kʉtɨ abhe mwumi kufishila akhabhalɨlo khe ɨnhayɨgalʉkha, khooni zɨnɨɨzyo zɨkʉkʉyɨmvwa mʉ mwoyo waakho?” ");
INSERT INTO mgq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Umulandati wʉnʉʉyo we áfumwizye uwukeeti ʉwa ziniizi na kuzisimba. Nɨɨtwe tumanyile kʉtɨ zye álonjile zya nalyoli. ");
INSERT INTO mgq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zɨlɨɨpo ɨnongwa izinji inyinji zye uYeesu akhabhombaga, ɨleelo zitasimbiilwe. Ɨnga zyonti zisimbwaje, ɨnkʉlola kʉtɨ ɨnsɨ yɨtaamɨle yɨbhe na pa kusengula ivitaabu vwonti vɨnɨɨvwo.");
INSERT INTO mgq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nholo waanɨ mʉ lwɨtɨkho Seofiilo, mu shitaabu shaanɨ shiila ɨsha kwanda, násimbile mʉmwo she uYeesu akhabhombaga, na she akhamanyɨzyaga, kufuma kʉwandɨlo ");
INSERT INTO mgq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kufishila isiku lye akhanyamvʉlwa kʉbhala kʉmwanya. We ashɨɨlɨ kʉbhalekha abhasundikwa bhaakwe bhe ábhasebhile, ábhalajiziizye kʉshɨlɨla kwa Mupepu uMufinjile she bhatɨbhombaje ɨmbombo. ");
INSERT INTO mgq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kʉ khabhalɨlo akhi nsiku amashumi gani kufuma pe ázyushile mu wufwe, akhabhaloleshelaga abhasundikwa bhaala akhinji bhʉʉlo, akhabhalangaga apazelu kʉtɨ ʉweene mwumi. Khabhɨlɨ akhabhamanyɨzyaga ɨnongwa ɨzya wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Isiku limo, we uYeesu akulya peeka na bhasundikwa, akhabhalajɨzya akhatɨ, “Mʉtasogolaje mʉ nhaaya ɨya mu Yelusaleemu, lyoli mʉgʉʉlɨle munuumu, paka mufishile akhabhalɨlo khe mʉkhayɨposheela ɨshɨkʉnjɨlwa sha Mupepu uMufinjile. Shɨnɨɨsho she shɨkʉnjɨlwa shiila she ʉTaata ʉMʉlʉngʉ álajile, ʉmʉlajɨ wʉnʉʉwo we ɨne ɨnhabhabhʉzyaga. ");
INSERT INTO mgq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","UYookhani akhabhozyaga abhantʉ ku minzi, ɨleelo kʉ khabhalɨlo khashe bhʉʉlo khe khakwɨnza, ɨmwe mʉtɨyoozelwe kwa Mupepu uMufinjile.” ");
INSERT INTO mgq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","We abhasundikwa bha Yeesu bhabhungaanile peeka na wʉʉyo, bhakhamʉbhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, Mwene, akhabhalɨlo ɨkha khe ʉtɨbhagalʉshɨzye aBhaisilaeli ʉwʉmwene waabho?” ");
INSERT INTO mgq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Akhabhaamʉla akhatɨ, “Insiku na khabhalɨlo akha kʉbhombekha zɨnɨɨzyo, te mbombo yiinyu kʉmanya. ɄTaata we avibhiishile kʉ makha gaakwe amapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɨleelo mʉtɨposheele amakha we uMupepu uMufinjile ayɨnza kukwinyu, ɨmwe mukhayimfumwizyaga uwukeeti mu Yelusaleemu, mʉ mʉkoa wonti ʉwa mu Yudeeya, na mu Samaliya, paka kufishila mwe ɨnsɨ yɨpeleleeye.” ");
INSERT INTO mgq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","We uYeesu aamala kʉbhabhʉʉzya shɨnɨɨsho abhasundikwa bhaakwe, nalʉbhɨlo bhʉʉlo akhanyamvʉlwa pamiiso gaabho kʉbhala kʉmwanya. Ɨbhɨngo likhamugubishila, bhatakhamʉlola winza. ");
INSERT INTO mgq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kʉ khabhalɨlo khanaakho we bhakwenya kʉmwanya we akʉsogola, nalʉbhɨlo bhʉʉlo bhakhɨmɨɨlɨla abhakhabhɨzya bhabhɨlɨ papɨɨpɨ nabho, bhe bhákwatile amenda amazelu. ");
INSERT INTO mgq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bhakhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mʉ Galɨlaaya, khooni khe mwɨmɨlɨɨye ɨpa mʉkwenya kʉmwanya? UYeesu ʉnʉ we anyamvʉlwa kukwinyu kʉbhala kʉmwanya, anza she mwamʉlola asogola, shɨnɨɨsho she akhayɨgalʉkha winza.” ");
INSERT INTO mgq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pe abhasundikwa bha Yeesu bhakhasogola pɨ gamba lye bhakhatɨnjɨ ɨlya Mizeituni, bhakhagalʉkha mu Yelusaleemu, ye yáamɨle uwutali uwi kilomiita yeeka kufuma pɨ gamba lɨnɨɨlyo. ");
INSERT INTO mgq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","We bhinjila mʉ nhaaya, bhakhabhala mu lupitu ʉlwa pamwanya mu nyumba ɨnjelenhanye, mwe bhakhakhomaanaga. Abhasundikwa bhanaabho bhe bha bhɨɨbha: uPeeteli, uYookhani, ʉYaakobo, ʉAndeleeya, uFilipo, uToomasi, ʉBatolomaayo, uMataayi, ʉYaakobo ʉmwana wa Alʉfeeyo, uSiimoni ʉmʉlwɨla nsɨ yaakwe, nʉ Yʉʉda ʉmwana wa Yaakobo. ");
INSERT INTO mgq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhonti bhanaabho bhakhabhʉngaanaga kʉmʉlaabha ʉMʉlʉngʉ, peeka nu Maliya unyina wa Yeesu, abhantanda abhanjɨ, na bhansi bha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Isiku limo, abhantʉ bhe bhámwitishile uYeesu bhábhungaanile peeka, pamu bháfishiiye abhantʉ imia yeeka na mashumi gabhɨlɨ (120). Pe uPeeteli akhɨmɨɨlɨla pakaasi yaabho, ");
INSERT INTO mgq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akhabhabhʉʉzya akhatɨ, “Ɨmwe bhanholo bhɨɨtʉ, zye zyásimbiilwe mu Wusimbe uWufinjile kʉ zya Yʉʉda, zyaakhondeeye kʉbhombekha. Zɨnɨɨzyo zye uMupepu uMufinjile álonjile kwi lomu lya maama wɨɨtʉ uDaudi zibhombeshile kʉtɨ, ʉYʉʉda we aabhalongooye abhantʉ bhaala bhe bhaamulemile uYeesu, ");
INSERT INTO mgq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","she poope aamɨle nɨɨtwe tubhasundikwa, twabhombaga ɨmbombo peeka nawo.” ");
INSERT INTO mgq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","We aposheela ɨnhela ɨzya mabheko, akhakalɨla ishiizi. Mu shiizi shɨnɨɨsho mwe akhagwa shikupama, ʉlwanda lʉkhatʉlʉkha, uwula wonti wʉkhasaata paasɨ. ");
INSERT INTO mgq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Izwi lɨnɨɨlyo lɨkhamanyɨkha mʉ bhantʉ bhonti bhe bhakwɨkhala mu Yelusaleemu. Ishiizi shiila bhakhaashipa ɨtaawa ɨlya Hakelidama mʉ ndongo yaabho kwe kʉtɨ, iShiizi ɨshɨ Bhanda. ");
INSERT INTO mgq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","UPeeteli akhajendeelela kʉlonga kʉtɨ, “Zɨnɨɨzyo zye zisimbiilwe mu shitaabu ɨsha Zabuuli kʉtɨ, ‘Inyumba yaakwe yɨtɨzwɨme, te asyale umuntu nʉʉmo mʉmwo winza.’ Khabhɨlɨ yisimbiilwe kʉtɨ, ‘Ɨmbombo yaakwe ɨya kʉlongozya bhaamupe umuntu uwunji.’ ");
INSERT INTO mgq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kʉnongwa yɨnɨɨyo, yɨkʉtɨ abhe ʉmʉsakhaala uwunji weeka we atɨjendaje peeka nɨɨtwe mʉ mbombo, afumwaje uwukeeti kʉtɨ ʉMwene wɨɨtʉ uYeesu azyushile mʉ bhafwe. Umuntu ʉyo, akwanzɨwa abhe weeka mʉ bhaala bhe bháamɨle nɨɨtwe mʉ khabhalɨlo khonti khe tʉkhamʉlandataga ʉMwene wɨɨtʉ uYeesu, we akʉshɨla mʉ bhantʉ, kufuma akhabhalɨlo khe uYookhani akhozyaga abhantʉ, kufishila isiku liila lye uYeesu akhanyamvʉlwa kʉkwɨtʉ kʉbhala kʉmwanya.” ");
INSERT INTO mgq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pe abhantʉ bhe bhámwitishile uYeesu, bhakhatekha amataawa aga bhasakhaala bhabhɨlɨ. Ʉmo áamɨle wu Yoosefu we bhakhatɨnjɨ ʉBalɨsaaba, awe uYusito, nʉ wa wʉbhɨlɨ, bhakhatɨnjɨ uMasiiya. ");
INSERT INTO mgq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pe bhakhamʉlaabha ʉMʉlʉngʉ bhakhatɨ, “Ɨwe Mwene, umanyile zye zɨlɨ mukaasi mʉ mooyo ga bhantʉ bhonti. Ishi, ʉtʉlanje ʉla we umusebhile mʉ bhɨɨbha, ");
INSERT INTO mgq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ɨnga apwanɨle pa mbombo ɨya wusundikwa ye ʉYʉʉda áyileshile, akhafwa, akhabhala pe pamʉkhondeeye wʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pe bhakhabhakhomela ɨkʉʉla abhantʉ bhabhɨlɨ bhaala, ɨkʉʉla yɨkhamʉgwɨla uMasiiya, we akhabha peeka na bhasundikwa abhanjɨ bhaala ishumi na weeka. ");
INSERT INTO mgq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Isiku ilyi Pentekoositi we lyafikha, abhantʉ bhe bhámwitishile uYeesu, bhonti bhábhungaanile mu nyumba yimo. ");
INSERT INTO mgq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","We bhɨkhaaye mʉmwo, nalʉbhɨlo bhʉʉlo kʉkhavwɨnha izi kufuma kʉmwanya lye lyámɨle anzi mpepu ɨmpɨtɨ ye yikuvugula, inyumba yonti yápatɨɨye izi liila. ");
INSERT INTO mgq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nalʉbhɨlo bhʉʉlo bhakhalola ivintu vwe vɨlɨ anzɨ mbɨɨtʉ ɨzya mwoto, zɨkhasaata, zɨkhabhala zɨkhagwa kwa weeka weeka. ");
INSERT INTO mgq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abhantʉ bhonti bhakhaposheela uMupepu uMufinjile, bhakhanda kʉlonga kʉ ndongo iyinji, anza she uMupepu uMufinjile ábhapiiye. ");
INSERT INTO mgq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa Yelusaleemu paala páamɨle aBhayahuudi bhe bhakhamutinikhaga ʉMʉlʉngʉ bhe bháfumile mʉ nsɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Abhantʉ bhanaabho we bhɨmvwa izi lɨnɨɨlyo, bhakhagandʉkha, bhakhɨnza ku winji pʉʉpo. Weeka weeka waabho akhɨmvwaga ɨndongo yaakwe wʉʉyo yɨkʉlongwa na bhantʉ bhe bhámwitishile uYeesu, pe bhakhakhasama, na ");
INSERT INTO mgq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","kuswiga nhaani. Bhakhanda kʉbhʉzɨlɨzanya bhakhatɨ, “Tejeelezyi! Abhantʉ ɨbha bhe bhakʉlonga shiniishi, te bhapaapɨlwa bha kʉ Galɨlaaya? ");
INSERT INTO mgq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ishi! Bhʉlɨɨbhʉlɨ ɨtwe weeka weeka mʉ ndongo yaakwe ɨya shɨkhaaya akwɨmvwa zye bhakʉlonga? ");
INSERT INTO mgq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mukaasi yɨɨtʉ, bhalɨɨpo abhantʉ bhe bhafumile mʉ nsɨ ɨya Bhapaliti, aBhamediya, aBhaelami, na bha mʉ nsɨ ɨya Mesopotaamiya. Bhamu bha mʉ mɨkoa ɨya mu Yudeeya, Kapadokiya, Ponto, Asiya, ");
INSERT INTO mgq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na bha mʉ nsɨ ɨya mu Filigiya, Pamfiliya, na bha mʉ nsɨ ɨya mu Miisili. Bhamu bhakufuma kʉmbalɨ ɨzyɨ nsɨ ɨya ku Libiya zye zɨlɨ papɨɨpɨ nɨ nhaaya ɨya ku Kileene, na bhe bhinzile kufuma mʉ nhaaya ɨya mu Luumi. ");
INSERT INTO mgq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mʉ bhanaabho bhalɨɨpo aBhayahuudi abha shifumo. Bhalɨɨpo bhamu bhe bhafumile mʉ nsɨ izinji bhe bhitishile ulupuuto lwɨtʉ ʉlwa Shiyahuudi, bhalɨɨpo aBhakileete, na Bhaalabiya. Yeenya twenti, tʉkwɨmvwa abhantʉ ɨbha bhakʉlonga mʉ ndongo zyɨtʉ, bhakʉmʉpaala ʉMʉlʉngʉ kʉ mbombo zyakwe ɨmpɨtɨ!” ");
INSERT INTO mgq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abhantʉ bhonti ɨbho bhakhaswigaga nhaani na kʉzyʉgʉnhana, bhakhabhʉzɨlɨzanya bhakhatɨ, “Shiniishi kwe kʉtɨ bhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ɨleelo bhamu mʉmwo bhakhanda kʉbhasekha abhalandati bha Yeesu, bhakhalongaga bhakhatɨnjɨ, “Ɨbha bhakholiilwe nhombwa.” ");
INSERT INTO mgq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pe uPeeteli akhɨmɨɨlɨla, peeka na bhasundikwa abhamwabho bhaala ishumi na weeka, akhanda kʉbhabhʉʉzya abhantʉ bhaala kwi zi ɨlya kʉdandɨzya akhatɨ, “MuBhayahuudi abhamwɨtʉ, na mwenti mwe mʉkwɨkhala pa Yelusaleemu ɨpa, amazwi ɨgo ge gafumiiye gamanyɨshe kukwinyu, mʉtejeelezye akhinza zye ɨnkʉlonga ishi. ");
INSERT INTO mgq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Poope she mʉkʉlola ngatɨ abhantʉ ɨbha bhakholiilwe, ɨleelo bhatakholiilwe khaala, yeenyi ishi shɨlaabhɨla saala ya wʉtatʉ! ");
INSERT INTO mgq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ziniizi zye zi ziila zye ʉMʉlʉngʉ álonjile kʉshɨlɨla kwa mukuwi uYoeli kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mu nsiku ɨzya kʉmpeleela, akʉlonga ʉMʉlʉngʉ, ɨnhayɨɨbhapa uMupepu waanɨ ku winji abhantʉ bhonti. Abhaana bhiinyu abhasakhaala na bhalɨndʉ bhiinyu bhakhayifumwaga uwukuwi, na bhaana bhiinyu abhatunta bhakhayɨlolaga injozi ɨzya pamiiso amazelu, na bhagoosi bhiinyu bhakhayɨlootaga injozi. ");
INSERT INTO mgq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mu nsiku zɨnɨɨzyo ɨnhayɨɨbhapa uMupepu waanɨ abhabhombi bhaanɨ, abhasakhaala na bhantanda, kʉtɨ bhoope bhafumwaje uwukuwi. ");
INSERT INTO mgq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ɨnhayɨbhombaga amayele kʉmwanya kʉ mabhɨngo, nɨ vɨlolesyo mʉ nsɨ munuumu. Kʉkhayɨbha ɨbhanda, nʉ mwoto, ni lyosi likhayisuukhaga ku winji. ");
INSERT INTO mgq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ɨzʉbha lɨkhayɨgalʉnhana kʉbha khiisi, nu mwezi wʉkhayɨbha mushamamu anzɨ bhanda. Zɨnɨɨzyo zyonti zɨkhayɨbhombekha we uwumwamu wa Mwene wʉshɨɨlɨ kʉlolekha pi siku ɨpɨtɨ liila. ");
INSERT INTO mgq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Umuntu wowonti we akhayɨlaata na kʉmʉsʉʉbhɨla ʉMwene akhayɨtʉʉlwa.’” ");
INSERT INTO mgq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","UPeeteli akhajendeelela kʉlonga akhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mu Isilaeli, mʉtejeelezye amazwi ɨga akhinza! ɄMʉlʉngʉ ábhalolesiizye ɨmwe kʉtɨ akʉbhomba ɨmbombo kʉshɨlɨla mwa Yeesu ʉwa ku Naazaleti. Ɨmwe mʉneemwe mumanyile akhinza kʉtɨ mwa Yeesu wʉnʉʉyo mwe akhalolesyaga amayele aga vɨkholo ivwinji kukwinyu. ");
INSERT INTO mgq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pɨlongolela, ʉMʉlʉngʉ akhamufumwa uYeesu kukwinyu, anza she ásɨbhɨlɨɨye kʉbhomba, pe ɨmwe mʉkhamʉgoga kwɨ dala ɨlya kʉbhasonjeelezya abhantʉ abhabhiibhi bhe te Bhayahuudi kʉtɨ bhamʉkhomeele pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ɨleelo ʉMʉlʉngʉ akhamʉtʉʉla uYeesu mu mavune aga wufwe, akhamʉzyʉsya kʉ bhafwe, kʉnongwa ye yákhaninhiine kʉtɨ uwufwe wʉjendeelele kʉmʉlemeelela uYeesu kwɨlongo. ");
INSERT INTO mgq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","UDaudi woope álonjile ɨzya Yeesu átɨlɨ, ‘Ɨne nálolile kʉtɨ, ʉMwene atɨjendeelele kʉbha peeka nɨɨne insiku zyonti. Kʉnongwa ye ʉweene alɨ kʉmbalɨ yaanɨ ɨya kʉndɨɨlo, intangayingaana ngakheeka. ");
INSERT INTO mgq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pe shɨnɨɨsho, ʉmwoyo waanɨ wʉkhasansamʉkha, ɨnhaseshela ni lomu lyanɨ. Woope nʉ mʉbhɨlɨ waanɨ wʉtɨyɨɨkhale mʉ lʉsʉʉbhɨlo, ");
INSERT INTO mgq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kʉnongwa ye ɨwe te ʉndeshe kwɨlongo, khabhɨlɨ te ʉyɨɨtɨshe kʉmʉlekha uMufinjile waakho, abhole. ");
INSERT INTO mgq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Undanjile amadala aga wuumi. Utimpe ʉlʉseshelo nhaani we ɨndɨ peeka nɨɨwe.’” ");
INSERT INTO mgq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","UPeeteli akhatɨ, “Bhanholo bhaanɨ, ɨngakhola kʉbhabhʉʉzya apazelu kʉtɨ ʉmaama wɨɨtʉ uDaudi áfuuye, bhakhamʉsyɨla, ɨmbɨɨpa yaakwe nʉ mʉsanyʉʉnʉ yɨlɨ panaapa. ");
INSERT INTO mgq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Poope shɨnɨɨsho, uDaudi áamɨle mukuwi, ámanyile kʉtɨ ʉMʉlʉngʉ álapile ku lufingo kʉtɨ atɨmʉbhɨɨshe mʉ wʉmwene waakwe umuntu ʉmo ʉwa shɨkholo shaakwe. ");
INSERT INTO mgq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","UDaudi álolile zye zitifumile, na zye zɨkhamʉbhɨɨkha kʉtɨ alonje ɨzya kʉzyʉkha kwa Kilisiti kʉtɨ, ʉMʉlʉngʉ atámuleshile kwɨlongo, nʉ mʉbhɨlɨ waakwe wutábholile. ");
INSERT INTO mgq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“UYeesu Kilisiti wʉnʉʉyo, ʉMʉlʉngʉ akhamʉzyʉsya kʉ bhafwe, twenti twe bhakeeti bhi zwi liniili. ");
INSERT INTO mgq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","We ʉTaata ʉMʉlʉngʉ amʉzʉvwa, ɨnga atabhaale peeka nawo, akhaamupa uMupepu uMufinjile. Pe uYeesu akhatʉleetela uMupepu uMufinjile we ʉMʉlʉngʉ álajile, zye zɨ zɨɨzyo zye mʉkʉzɨlola, na kʉzyɨmvwa. ");
INSERT INTO mgq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","UDaudi atakhayɨtekhaga wʉʉyo kʉnongwa ye ʉweene atábhalile kʉmwanya. Poope shɨnɨɨsho, ʉweene álonjile átɨlɨ, ‘ɄMwene ámubhuziizye ʉMwene waanɨ átɨlɨ, “Yɨɨkhala kʉmbalɨ ɨyɨ nyoobhe yaanɨ ɨya kʉndɨɨlo, ");
INSERT INTO mgq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","paka we nabhabhɨɨkha abhalʉgʉ bhaakho paasɨ pa vɨnama vwakho.”’” ");
INSERT INTO mgq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","UPeeteli akhatɨ, “Ishi, aBhaisilaeli bhonti bhakwanzɨwa bhamanye akhinza kʉtɨ ʉMʉlʉngʉ akhamʉbhɨɨkha uYeesu kʉbha wʉ Mwene, khabhɨlɨ wu Kilisiti, we ɨmwe mwámʉkhomeleeye pa shɨkhobhenhanyo.” ");
INSERT INTO mgq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ABhayahuudi bhaala, we bhɨmvwa amazwi ganaago, gakhabhalasa nhaani mʉ mooyo gaabho. Bhakhabhabhʉzɨɨlɨzya uPeeteli peeka na bhasundikwa abhamwabho bhakhatɨ, “Bhanholo bhɨɨtʉ, ishi tʉbhombe lyoni?” ");
INSERT INTO mgq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","UPeeteli akhabhaamʉla akhatɨ, “Umuntu weeka weeka kukwinyu alaate imbiibhi zyakwe na kwozelwa kwɨ taawa lya Yeesu Kilisiti, kʉtɨ ɨnga atʉʉyɨlwe na kʉposheela ɨshɨkʉnjɨlwa sha Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","She ʉmʉlajɨ wʉnʉʉwo we ʉMʉlʉngʉ álapile ɨmaandɨ we akʉbhomba ishi kukwinyu, kʉ bhaana bhiinyu, na kʉ bhanjɨ bhonti bhe bhalɨ ukutali. Ganaago ʉMwene ʉMʉlʉngʉ wɨɨtʉ akhayɨɨbhapa abhantʉ bhonti bhe akhayɨbhabhɨlɨshɨla.” ");
INSERT INTO mgq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","UPeeteli akhajendeelela kʉbhabhʉʉzya abhantʉ bhaala amazwi aganjɨ aminji aga kʉbhasokha. Akhabhasundiilila akhatɨ, “Mʉtʉʉlwe nʉ Mʉlʉngʉ mʉtakhalongwe peeka na bhantʉ abha khabhalɨlo ɨkha, bhe bhabhiibhi nhaani!” ");
INSERT INTO mgq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abhantʉ abhinji bhakhagɨɨtɨkha amazwi gaakwe, bhakhoozelwa isiku liila, bhakhonjela abhantʉ bhe bhafishiiye ielufu zɨtatʉ (3,000). ");
INSERT INTO mgq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abhasundikwa bha Yeesu bhakhamanyɨzyaga izwi lya Mʉlʉngʉ kʉ bhe bhámwitishile. Bhonti bháamɨle nʉ mwoyo mʉ wʉpeeka waabho, bhakhamensulanaga ikaati na kulya peeka, na kʉmʉlaabha ʉMʉlʉngʉ peeka. ");
INSERT INTO mgq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abhasundikwa bhakhabhombaga amayele aminji nɨ vɨlolesyo ivwinji, abhantʉ bhonti bhakhaswigaga nhaani, na kumushindikha ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abhantʉ ɨbha bhe bhámwitishile uYeesu, bhonti bháamɨle mʉ wʉpeeka, ivintu vwabho vwope vwámɨle mʉ wʉpeeka. ");
INSERT INTO mgq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bhakhakazyaga ivintu vwabho nɨ nhela zye bhakhapataga, bhakhazɨgabhanyaaga, anza she umuntu weeka weeka ábhuliliilwe. ");
INSERT INTO mgq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bhakhabhʉngaanaga insiku zyonti mwi linga ilyi Nyumba iMfinjile, na mu nyumba zyabho na kumensulana ikaati peeka. Bhakhasangʉlaga ivwakulya kʉ mooyo amasangalusu na kulya peeka kʉ lʉseshelo. ");
INSERT INTO mgq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bhakhamʉpaalaga ʉMʉlʉngʉ, na kʉbhakhondezya abhantʉ bhonti. Insiku zyonti ʉMwene uYeesu akhabhatʉʉlaga abhantʉ abhanjɨ bhe bhakhɨtɨkhaga, bhakhasangaanaga na bhamwabho mʉ wʉpeeka waabho. ");
INSERT INTO mgq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Isiku limo, uPeeteli nu Yookhani bhábhalile mwi linga ilyi Nyumba iMfinjile mʉ saa tisa ɨya shamʉsanya, yɨnɨɨyo ye yáamɨle saala ya Bhayahuudi kumupuuta ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Páamɨle nu muntu ʉmo we álemaaye kufuma kʉpaapwa kwakwe. Wiila bhʉʉlo akhapɨmbwaga na bhantʉ, bhakhamʉbhɨɨkhaga papɨɨpɨ nʉ mʉlyango we bhakhatɨnjɨ ʉMʉlyango uMwinza. Panaapo akhalaabhaga ɨnhela kwa muntu wowonti we akwinjila mwi linga ilyi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Umuntu wʉnʉʉyo, we abhalola uPeeteli nu Yookhani bhakwinjila mwi linga ilyi Nyumba iMfinjile, akhabhalaabha ɨnhela. ");
INSERT INTO mgq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pe uPeeteli nu Yookhani bhakhamʉtontomela na miiso. UPeeteli akhamʉbhʉʉzya akhatɨ, “Twenye ɨtwe!” ");
INSERT INTO mgq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Umuntu ʉla akhabheenya, akhabha nʉ lʉsʉʉbhɨlo kʉtɨ bhalɨ na khantʉ khe bhatiimupe. ");
INSERT INTO mgq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ɨleelo uPeeteli akhamʉbhʉʉzya akhatɨ, “Ɨne ɨntalɨ nɨ nhela, ɨleelo lye ɨngakhola kʉbhomba, ɨntɨkʉbhombele. Ɨnkʉkʉbhʉʉzya kwɨ taawa lya Yeesu Kilisiti ʉwa ku Naazaleti, yɨmɨɨlɨla ʉjendaje!” ");
INSERT INTO mgq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pe uPeeteli akhamʉlema umuntu ʉla ɨnyoobhe ɨya kʉndɨɨlo, akhamwɨmɨɨlɨsya. Panaapo bhʉʉlo ivizuguni ɨvwa vɨnama vwa muntu ʉla vɨkhabha na makha. ");
INSERT INTO mgq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akhɨmɨɨlɨla nalʉbhɨlo, akhanda kʉjenda wʉʉyo. Akhinjila mwi linga ilyi Nyumba iMfinjile peeka nu Peeteli nu Yookhani, akhajendaga kumo akʉmʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abhantʉ bhonti bhakhamʉlola umuntu nyeene akʉjenda nɨ vɨnama vwakwe wʉʉyo, akʉmʉpaala ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhakhamʉmanya kʉtɨ we wʉ wʉʉla we ayɨkhalaga pa mʉlyango uwi Nyumba iMfinjile we bhakhatɨnjɨ ʉMʉlyango uMwinza, akhalaabhaga ivintu pʉʉpo. Bhonti bhakhaswiga nhaani we bhaalola zye zyabhombekha kʉkwakwe. ");
INSERT INTO mgq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mʉ khabhalɨlo khanaakho, umuntu ʉla akhabhalɨlɨlaga uPeeteli nu Yookhani. Abhantʉ bhonti bhakhaswigaga nhaani, bhakhabhashɨmbɨɨlɨla panaapo pe bhakʉtɨ ɨdala itimiilile ɨlya Selemaani. ");
INSERT INTO mgq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","UPeeteli we abhalola abhantʉ bhanaabho, akhabhabhʉʉzya akhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mu Isilaeli, khooni khe ziniizi zikubhaswijizya? Khooni khe mʉkʉtʉdamʉlɨla amiiso? Mʉkʉtɨ umuntu ʉnʉ twamʉponɨa kʉ makha gɨɨtʉ, awe kʉnongwa ye ɨtwe twe bhafinjile pamiiso ga Mʉlʉngʉ? ");
INSERT INTO mgq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ɄMʉlʉngʉ wa Abulahaamu, ʉMʉlʉngʉ wa Isaaka, ʉMʉlʉngʉ wa Yaakobo, ʉMʉlʉngʉ wa bhamaama bhɨɨtʉ, amumwamishile umubhombi waakwe uYeesu kwɨ dala ɨlya kʉmʉponɨa wʉnʉʉyo. Ɨleelo ɨmwe mwámubhiishile uYeesu mʉ nyoobhe zya bhalʉgʉ kʉtɨ bhamʉgoje. Woope ʉPɨlaato akhanzaga kʉtɨ angabhasatʉlɨla uYeesu, ɨmwe mʉkhakhaana, ");
INSERT INTO mgq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","mʉkhalaabha kʉtɨ umugoji we asatʉlwe! Mʉkhamʉkhaana uYeesu, uMufinjile wa Mʉlʉngʉ we Mugolosu. ");
INSERT INTO mgq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Poope she we shindingwi sha wuumi, ɨmwe mʉkhamʉgoga. Ɨleelo ʉMʉlʉngʉ akhamʉzyʉsya mʉ bhafwe, nɨɨtwe twe bhakeeti abha kʉzyʉkha kwakwe. ");
INSERT INTO mgq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Ishi mumanyile akhinza kʉtɨ umuntu wʉnʉʉnʉ we mʉkʉmʉlola ɨpa mumumanyile, ivizuguni vwakwe anza vwagoma kwɨ dala ɨlya kʉbhɨɨkha ʉlwɨtɨkho kwɨ taawa lya Yeesu. Ɨtaawa lɨnɨɨlyo, peeka na kʉbhɨɨkha ʉlwɨtɨkho kʉkwakwe, vwe vwamʉponɨa abha mwinza, anza she mʉkʉmʉlola mwenti. ");
INSERT INTO mgq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ishi ɨmwe mʉbhanholo bhɨɨtʉ, zɨnɨɨzyo zyonti zye mwámʉbhombeeye uYeesu, peeka na bhapɨtɨ bhiinyu, imanyile kʉtɨ mwábhombile mʉ wʉlema. ");
INSERT INTO mgq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Zɨnɨɨzyo zyábhombeshile kʉtɨ ʉMʉlʉngʉ akwɨlɨzye amazwi gaala ge álonjile kʉshɨlɨla mu bhakuwi bhaakwe bhonti, kʉtɨ uKilisiti waakwe akhayɨyɨmba. ");
INSERT INTO mgq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Ishi mʉlaate, mʉzɨleshe imbiibhi zyinyu nalyoli, mʉmʉsʉʉbhɨle ʉMʉlʉngʉ, kʉtɨ azyefwe imbiibhi zyinyu zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Shɨnɨɨsho she ʉMʉlʉngʉ atɨbhavwaje we alɨ peeka nɨɨmwe kʉtɨ mujinjile, pamu atɨbhaleetele uYeesu, abhe wu Kilisiti we ábhasabhʉlɨɨye kufuma khalɨ. ");
INSERT INTO mgq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","UYeesu akhondeeye kʉsyala kʉmwanya kufishila akhabhalɨlo khe ʉMʉlʉngʉ akhayɨgalʉlanya ivintu vwonti kʉbha vipwa, anza she álonjile kufuma ɨmaandɨ kʉshɨlɨla ku bhakuwi bhaakwe abhafinjile. ");
INSERT INTO mgq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Ye nongwa umukuwi ʉwɨ maandɨ ʉMoose álonjile átɨlɨ, ‘Kufuma mumwinyu mwe ʉMʉlʉngʉ akhayɨbhasebhela ɨmwe umukuwi we akholiine nɨɨne. Amazwi gonti ge umukuwi waakwe wʉnʉʉyo akhayɨbhabhʉʉzya, mʉkhagatejelezyaje akhinza. ");
INSERT INTO mgq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kʉnongwa ye umuntu wowonti we akhayisiita kʉmʉtejeelezya umukuwi wʉnʉʉyo, ʉMʉlʉngʉ akhayɨmwefwa mʉ bhantʉ bhaakwe wiila na wiila, na kʉmʉyazya.’ ");
INSERT INTO mgq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Zye zɨkʉbhombekha mu nsiku ɨzya shiishi, abhakuwi bhonti bhoope bháfumwizye uwukuwi, kwandɨla kwa mukuwi waakwe uSamweli, kufishila ku bhakuwi bhonti bhe bhálonjile. ");
INSERT INTO mgq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Zɨnɨɨzyo zye ʉMʉlʉngʉ álonjile kʉshɨlɨla ku bhakuwi bhanaabho, ɨmwe mwe mʉkʉzɨposheela. Khabhɨlɨ ulufingo lwe ábhiishile na bhamaama bhiinyu, lwope ɨmwe mwe mʉkʉlʉposheela. We abhɨɨkha ulufingo, ʉMʉlʉngʉ ámubhuziizye ʉmaama wɨɨtʉ uAbulahaamu kʉtɨ, ‘Kʉshɨlɨla kwa muntu ʉwa shɨkholo shaakho, mwe abhantʉ abha vɨkholo vwonti bhakhayɨlwaga ʉlʉsayo.’ ");
INSERT INTO mgq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pe mʉ khabhalɨlo khe ʉMʉlʉngʉ akhamʉsebha umubhombi waakwe uYeesu, ámusonteleziizye kukwinyu suuti, kʉtɨ ɨnga abhasaye mwepe mu mbiibhi zyinyu.” ");
INSERT INTO mgq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","We uPeeteli nu Yookhani bhakʉbhalʉmbɨɨlɨla abhantʉ bhaala, nalʉbhɨlo bhʉʉlo bhakhɨnza abhapuutili, aBhasadukaayi, peeka nʉ mʉpɨtɨ ʉwa bhalindiilili abhi Nyumba iMfinjile. ");
INSERT INTO mgq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Abhapɨtɨ bhanaabho bhínzile bhavitiilwe kʉnongwa ye uPeeteli nu Yookhani bhakhamanyɨzyaga abhantʉ na kʉlʉmbɨɨlɨla kʉtɨ kʉzyʉkha uYeesu kʉkʉmanyɨsya kʉtɨ abhafwe bhakhayɨzyʉkha. ");
INSERT INTO mgq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Zɨnɨɨzyo zɨkhaazya abhapɨtɨ bhanaabho bhabhaleme uPeeteli nu Yookhani, bhakhabhagonekha mwɨ jeela. Kʉnongwa ye kwámɨle shalyabheela, bhakhagʉʉlɨla we kwasha ɨshɨlaabhɨla. ");
INSERT INTO mgq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Poope shɨnɨɨsho, zɨnɨɨzyo zye uPeeteli nu Yookhani bhábhabhuziizye abhantʉ, abhinji bhaabho bhakhazyɨtɨkha. Uwinji wa bhasakhaala bheene bhe bhámwitishile uYeesu bhakhafikha abhantʉ ielufu zɨsaanʉ (5,000). ");
INSERT INTO mgq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","We kwasha abhapuutili, abhapɨtɨ na bhamanyizyi abhɨ ndajɨzyo bhakhabhʉngaana panaapo pa Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mwɨ balaaza lɨnɨɨlyo, mwámɨle nu mupuutili ʉmʉpɨtɨ uAanasi, peeka nʉ Kayaafa, uYookhani uwunji, uAlekizanda, na bhanholo abhanjɨ abha Aanasi. ");
INSERT INTO mgq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Abhapɨtɨ bhonti bhanaabho bhakhabhaleeta uPeeteli nu Yookhani, bhakhabhɨmɨɨlɨsya pɨlongolela yaabho, bhakhanda kʉbhabhʉzɨɨlɨzya kʉtɨ, “Zɨnɨɨzyo zye mubhombile, mubhombile kʉ makha gooni, awe kʉ waamʉlo wa naanu?” ");
INSERT INTO mgq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","UPeeteli akhalongolwa nu Mupepu uMufinjile, akhabhaamʉla akhatɨ, “Mʉbhapɨtɨ na mʉbhasongo ɨmwe! ");
INSERT INTO mgq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ʉmʉsanyʉʉnʉ mʉkʉtʉbhʉzɨɨlɨzya ɨpa kʉnongwa ye tumwavwizye umuntu ʉnʉ we aamɨle nɨ shɨlema, kʉtɨ aponile bhʉlɨɨbhʉlɨ. ");
INSERT INTO mgq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pe shɨnɨɨsho, ɨmwe mwenti mʉmanye akhinza, peeka na Bhaisilaeli abhanjɨ bhonti, kʉtɨ umuntu ʉnʉ we ayɨmɨlɨɨye pɨlongolela yiinyu, aapona, abha mwinza kʉ makha gɨ taawa lya Yeesu Kilisiti ʉwa ku Naazaleti. Wʉnʉʉyo we ɨmwe mwámʉkhomeleeye pa shɨkhobhenhanyo, ɨleelo ʉMʉlʉngʉ akhamʉzyʉsya kʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","UYeesu alɨ ngatɨ liwe ɨlya pambalɨ pa nyumba, wʉnʉʉyo we wʉ wʉʉla we yisimbiilwe kwa wʉʉyo kʉtɨ, ‘Iwe lye mwálikhaanile ɨmwe mubhazenji, lɨnɨɨlyo lye lyabha liwe ɨlya pambalɨ lye lilemile inyumba yonti.’ ");
INSERT INTO mgq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Atalɨɨpo uwunji nʉʉmo we tʉngawaaga uwuposhi kʉkwakwe, kwe kʉtɨ paasɨ ɨpa lɨtalɨɨpo ɨtaawa ilinji lye ɨtwe tʉlɨ nalyo lye lɨngakhola kʉtʉtʉʉla mu mbiibhi.” ");
INSERT INTO mgq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Abhapɨtɨ bhaala bhakhalola kʉtɨ uPeeteli nu Yookhani bhakʉbhaamʉla ku wudandamazu, khabhɨlɨ bháamɨle bhantʉ bhe bhatáshɨlɨɨye mu nsukuulu, pe bhakhaswiga nhaani. Bhakhazyaganya kʉtɨ uPeeteli nu Yookhani bháamɨle peeka nu Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Abhapɨtɨ bhaala we bhaalola ʉmʉsakhaala ʉla we aponile ayɨmɨlɨɨye panaapo peeka nu Peeteli nu Yookhani, bhakhapootwa amazwi aga kʉlonga. ");
INSERT INTO mgq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bhakhabhalajɨzya uPeeteli nu Yookhani kʉtɨ bhafume mwɨ balaaza lyabho liila. Abheene bhakhasyala bhakʉpanzanya, ");
INSERT INTO mgq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","bhakhabhʉzɨlɨzanya bhakhatɨ, “Tʉtɨbhombe anza bhʉlɨɨbhʉlɨ na bhantʉ ɨbha? Yeenya, abhantʉ bhonti bhe bhakwɨkhala panaapa pa Yelusaleemu bhamanyile kʉtɨ bhabhombile ɨshɨlolesyo ɨshɨpɨtɨ, tʉtangakhola kʉshɨkhaana. ");
INSERT INTO mgq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ishi tʉbhakhaane kwɨ dala ɨlya kʉbhoogofwa, bhaleshe kʉlonga ɨtaawa lɨnɨɨlyo kʉ bhantʉ, kʉtɨ ziniizi zye bhabhombile zɨtajendeelele kʉsaata nhaani mʉ bhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pe abhapɨtɨ bhaala bhakhabhabhɨlɨshɨla uPeeteli nu Yookhani, bhakhabhakhaana kʉ makha bhakhatɨ, “Mʉtakhasheele kʉlonga intumi zya Yeesu na kʉmanyɨzya kʉ makha gɨ taawa lyakwe. Poope kʉlonga, mʉtakhasheele kʉlɨlonga!” ");
INSERT INTO mgq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","UPeeteli nu Yookhani bhakhatɨ, “Ɨmwe mʉneemwe mufumwe ʉwaamʉlo, ɨnga yɨkʉkhondela pamiiso ga Mʉlʉngʉ kʉtɨ ɨmwe mwe tubhatinikhaje kʉshɨla kumutinikha ʉMʉlʉngʉ wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kʉnongwa ye zɨnɨɨzyo zyonti zye ɨtwe twázilolile tʉneetwe, na kʉzyɨmvwa, tʉtakhondeeye kʉtɨ tʉleshe kʉzɨlonga.” ");
INSERT INTO mgq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Abhapɨtɨ bhaala bhakhapootwa zye bhatɨbhasɨtaakɨle uPeeteli nu Yookhani. Bhápotiilwe kʉnongwa ye abhantʉ bhonti bhakhamʉpaalaga nhaani ʉMʉlʉngʉ kʉ shɨlolesyo she uPeeteli nu Yookhani bhábhombile kwa muntu ʉla. Umuntu wʉnʉʉyo we bhámuponiizye áamɨle nɨ shɨlema kufuma kʉpaapwa kʉshɨla amanha amashumi gani. Pe bhakhabhoogofwa winza, bhakhabhɨtɨshɨzya kʉtɨ bhasogolaje. ");
INSERT INTO mgq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","UPeeteli nu Yookhani, we bhasatʉlwa, bhakhagalʉkha kwe abhamwabho bháamɨle. Bhakhabhapanjɨla amazwi ganaago gonti ge abhapɨtɨ abha bhapuutili, peeka na bhasongo abha Bhayahuudi bhábhabhuziizye. ");
INSERT INTO mgq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","We abhamwabho bhaala bhɨmvwa ɨzya mazwi ganaago, bhonti bhakhɨtɨnhana peeka kʉmʉlaabha ʉMʉlʉngʉ bhakhatɨ, “Ɨwe Mwene, we Mʉpɨtɨ wa vwonti. We wápelile kʉmwanya, na paasɨ, ʉsʉmbɨ, na vwonti vwe vɨlɨ mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","We wálonjile kwi lomu lya maama wɨɨtʉ uDaudi, umubhombi waakho, kʉshɨlɨla kwa Mupepu uMufinjile kʉtɨ, ‘Khooni khe abhantʉ abhɨ nsɨ izinji bhakuviitwa, khabhɨlɨ ɨvɨkholo ɨvwa Bhaisilaeli vɨkʉsɨɨbha ʉwaamʉlo ʉwa khasa bhʉʉlo? ");
INSERT INTO mgq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhamwene abhɨ nsɨ bhayilinganyiinye, khabhɨlɨ abhapɨtɨ bhabhungaanile peeka, kʉtɨ bhamʉkhaane ʉMwene nu Kilisiti waakwe we amʉsabhʉʉye.’ ");
INSERT INTO mgq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yɨkʉlolekha apazelu kʉtɨ ʉmwene uHeloodi nu Pontiyo Pɨlaato bhoope bhábhungaanile mʉ nhaaya yɨnɨɨnɨ ɨya mu Yelusaleemu, peeka na Bhaisilaeli na bhantʉ abhɨ nsɨ zyonti, bhamʉkhaane uYeesu umubhombi waakho umufinjile, we wámʉsabhʉʉye kʉtɨ abhe wʉ Mwene. ");
INSERT INTO mgq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zɨnɨɨzyo zye bhábhombile bhanaabho zye ɨwe ʉkhasɨbhɨlɨlaga kufuma ɨmaandɨ kʉtɨ zɨbhombeshe, mʉ makha gaakho na kʉ shɨgane shaakho. ");
INSERT INTO mgq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ishi ɨwe Mwene, yeenya she bhatwogofwa! Ʉtwavwe, ɨtwe tubhabhombi bhaakho, ɨnga tʉlʉmbɨlɨlaje izwi lyakho ku wudandamazu nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɨwe ʉlolesye amakha gaakho aga kʉbhaponɨa abhantʉ, ʉtwavwe kʉtɨ tʉbhombaje amayele aga vɨkholo ivwinji kʉshɨlɨla kwɨ taawa lya Yeesu, umubhombi waakho umufinjile.” ");
INSERT INTO mgq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Abhantʉ bhanaabho we bhaamala kʉlaabha kwa Mʉlʉngʉ, nalʉbhɨlo paala pe bhábhungaanile pakhayingaana. UMupepu uMufinjile akhabhalongozya bhonti, bhakhanda kʉlʉmbɨɨlɨla intumi zya Mʉlʉngʉ ku wudandamazu. ");
INSERT INTO mgq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bhonti bhe bhámwitishile uYeesu bhakhabha nʉ mwoyo weeka, nɨ nsɨɨbho zyabho zyámɨle peeka. Atálɨɨpo umuntu we akhalongaga kʉtɨ ivintu vwe alɨ navwo vwakwe mwene, kʉnongwa ye ivintu vwabho vwonti bhakhasanganɨlaga. ");
INSERT INTO mgq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abhasundikwa bha Yeesu bhakhafumwaga uwukeeti ku wudandamazu nhaani, kʉtɨ ʉMwene uYeesu azyushile mʉ bhafwe, ʉMʉlʉngʉ akhabhasayaga nhaani bhonti. ");
INSERT INTO mgq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Atálɨɨpo umuntu mʉ shɨpʉga shaabho we ábhuliliilwe na khantʉ, kʉnongwa ye bhe bháamɨle ni vwizi awe inyumba, bhakhavɨkazyaga. ");
INSERT INTO mgq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ɨnhela zye bhakhaposheelaga, bhakhabhapanga abhasundikwa bha Yeesu. Zɨnɨɨzyo ɨnhela bhakhagabhaga, anza she umuntu weeka weeka ábhuliliilwe. ");
INSERT INTO mgq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwámɨle nu Mulaawi ʉmo ɨtaawa lyakwe bhakhatɨnjɨ uYoosefu, áamɨle mʉkhaaya ʉwa mʉ nsɨ ɨya mu Kipulo. Abhasundikwa bha Yeesu bhámupiiye ɨtaawa ɨlya Balɨnaaba, kwe kʉtɨ, “Ʉwa kʉtɨlɨzya ʉmwoyo.” ");
INSERT INTO mgq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ɄBalɨnaaba woope akhakazya ishiizi shaakwe, ɨnhela zye áposheleeye, akhazɨtwala ku bhasundikwa. ");
INSERT INTO mgq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Álɨɨpo umuntu ʉmo, ɨtaawa lyakwe bhakhatɨnjɨ uAnaniya. UAnaniya peeka nʉ mʉshɨ waakwe uSafila, bhoope bhakhakazya ishiizi shaabho. ");
INSERT INTO mgq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɨnhela zye bháposheleeye mu shiizi shiila, uAnaniya akhatapʉla zimo kukwilu, ʉmʉshɨ waakwe woope ámanyile. Zye zɨkhasyala, uAnaniya akhazɨtwala ku bhasundikwa bha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ɨleelo uPeeteli akhamʉbhʉʉzya akhatɨ, “Ananiya! Khooni khe waalekha uSeetani ayinjila mʉ mwoyo waakho? Wafishila kʉlonga ɨlenga kwa Mupepu uMufinjile, waafisa ɨnhela zimo zye ʉposheleeye mu shiizi shaakho. ");
INSERT INTO mgq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","We ʉshɨɨlɨ kʉshɨkazya, sháamɨle shiizi shaakho! Poope we washɨkazya, waamɨle nʉ waamʉlo kʉbhombela ɨnhela zɨnɨɨzyo zye ʉposheleeye she ʉkwanza wʉneewe! Ishi! Zyaamɨle bhʉlɨɨbhʉlɨ anza wɨɨtɨkha ɨnongwa ziniizi mʉ mwoyo waakho kʉtɨ ʉbhombe anza ziniizi? Utalonjile lɨlenga kʉ bhantʉ bheene, lyoli ulonjile lɨlenga na kwa Mʉlʉngʉ wʉʉyo!” ");
INSERT INTO mgq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","UAnaniya we ayɨmvwa ganaago amazwi ga Peeteli, akhagwa paasɨ, akhafwa panaapo. Bhonti bhe bhímvwizye ɨnongwa zɨnɨɨzyo bhakhalemwa nɨ lyoga ɨpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pe abhaana abhatunta bhakhagubishila ivimba lyakwe nʉ mwenda, bhakhalifumwa panzɨ, bhakhalɨsyɨla. ");
INSERT INTO mgq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pamu ɨsaala zɨtatʉ we zyashɨla, ʉmʉshɨ wa Ananiya woope akhinjila mu nyumba yiila, sita kʉmanya zye zibhombeshile. ");
INSERT INTO mgq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","UPeeteli akhamʉbhʉzɨɨlɨzya akhatɨ, “Mbʉʉzye, ɨnhela zye mwaakaziizye ishiizi shiinyu, bhʉlɨ zye zi ziniizi nyeene?” Akhamwamʉla akhatɨ, “Nalyoli zye zɨ zɨnɨɨzyo nyeene!” ");
INSERT INTO mgq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","UPeeteli akhamʉbhʉʉzya akhatɨ, “Khooni khe mwivwanile nʉ mʉlʉme waakho kʉmʉlɨnga uMupepu uMufinjile wa Mwene? Tejeelezya! Bhe bhamʉsyɨlɨɨye ʉmʉlʉme waakho, ɨbho bhalɨ panzɨ pa shɨlyango ɨpo, nɨɨwe bhatɨtwale ivimba lyakho panzɨ na kʉlɨsyɨla.” ");
INSERT INTO mgq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Panaapo bhʉʉlo, uSafila woope akhagwa pa vɨnama pa Peeteli, akhafwa. Abhaana abhatunta bhaala we bhinjila, bhakhaaga uSafila woope afuuye. Bhakhafumwa panzɨ ivimba lyakwe, bhakhalɨsyɨla pambalɨ pa mʉlʉme waakwe. ");
INSERT INTO mgq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ɨlyoga ɨpɨtɨ lɨkhabhalema abhantʉ bhonti abha shɨbhanza, peeka na bhanjɨ bhonti bhe bhímvwizye zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kʉ makha ga Mʉlʉngʉ, abhasundikwa bha Yeesu bhakhabhombaga ɨvɨlolesyo na mayele aminji mʉ bhantʉ. Abhantʉ bhe bhámwitishile uYeesu bhonti bhakhabhʉngaanaga mwi linga ilyi Nyumba iMfinjile, mwɨ dala itimiilile ɨlya Selemaani. ");
INSERT INTO mgq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Abhantʉ bhe bhatámwitishile uYeesu bhakhabhapaalaga nhaani. Poope shɨnɨɨsho, nʉʉmo we álinjile kʉbhalandata kʉnongwa ye bhógopile. ");
INSERT INTO mgq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɨleelo uwinji wa bhaala bhe bhámwitishile ʉMwene uYeesu bhakhonjelaga nhaani, abhasakhaala na bhantanda. ");
INSERT INTO mgq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kufumilana na zɨnɨɨzyo, bhakhabhabhɨɨkhaga abhabhinu pɨ dala mʉ vɨtala, na mʉ vɨlɨlɨ, kʉtɨ uPeeteli we akʉshɨla, ɨshɨnzyʉngʉʉlɨ shaakwe shibhafishile bhamu bhapone. ");
INSERT INTO mgq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Abhantʉ abhinji bhakhafumaga mʉ nhaaya ɨzya mʉmbalɨ, bhakhabhʉngaanaga ku winji panaapo pa Yelusaleemu. Bhakhabhaleetaga abhabhinu, na bhaala bhe amapepu amabhiibhi gábhalemile, bhonti bhakhaponaga. ");
INSERT INTO mgq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pe umupuutili ʉmʉpɨtɨ, peeka na bhamwabho bhonti abha shɨpanɨ sha Bhasadukaayi, ʉmwone wʉkhabhalema nhaani kʉnongwa ya bhasundikwa bha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bhakhabhalema, bhakhabhakʉnga mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ɨleelo shawusiku ʉkhabhɨzya wa Mwene akhiigula inyiiji ɨzyɨ jeela, akhabhalongola kʉbhala panzɨ. Akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bhalaji mwɨmɨɨlɨle mwi linga ilyi Nyumba iMfinjile, kʉbhalʉmbɨɨlɨla abhantʉ amazwi gonti aga wuumi ʉwa wiila.” ");
INSERT INTO mgq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pe abhasundikwa bhaala bhakhabhala nakhantandabhɨla mwi linga ilyi Nyumba iMfinjile, anza she ʉkhabhɨzya ábhabhuziizye, bhakhanda kʉbhamanyɨzya abhantʉ mʉmwo. Kʉ khabhalɨlo khanaakho umupuutili ʉmʉpɨtɨ ʉla, peeka na bhamwabho, bhakhabhabhʉngaanya abhapɨtɨ bhonti abhɨ balaaza ɨlya Bhaisilaeli. Bhakhasonteelezya abhalindiilili kwɨ jeela, kʉtɨ bhabhaleete abhasundikwa bhaala. ");
INSERT INTO mgq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɨleelo we bhinjila mʉmwo, bhakhaaga abhasundikwa bhaala naabhamu mwenemwo. Bhakhagalʉkha kʉ bhapɨtɨ, bhakhabhabhʉʉzya bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“We twafikha kwɨ jeela kuula, twajile inyiiji nyɨgalɨle bhʉʉlo, abhalindiilili bhɨmɨlɨɨye pambalɨ bhakʉlɨndɨɨlɨla. Ɨleelo we twigula inyiiji, tutamwajile umuntu nʉʉmo mʉmwo!” ");
INSERT INTO mgq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ʉmʉpɨtɨ wa bhalindiilili peeka na bhapɨtɨ bha bhapuutili bhaala, we bhɨmvwa zɨnɨɨzyo, bhakhazyʉgʉnhana nhaani, bhakhabhʉzɨlɨzanya bhakhatɨ, “Ɨnongwa ziniizi zɨtɨbhe bhʉlɨɨbhʉlɨ?” ");
INSERT INTO mgq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pe akhɨnza umuntu ʉmo, akhabhabhʉʉzya akhatɨ, “Tejeelezyi! Abhantʉ bhaala bhe mwaabhakunjile mwɨ jeela, bhabhaala winza bhɨmɨlɨɨye mwi linga ilyi Nyumba iMfinjile bhakʉmanyɨzya abhantʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pe ʉmʉpɨtɨ wa bhalindiilili, peeka na bhalindiilili bhaakwe, bhakhabhaleeta abhasundikwa bhaala. Ɨleelo bhínzile bhatenguliiye nabho, bhatakhabhabunshilanyaaga, kʉnongwa ye bhógopile kʉtɨ abhantʉ bhatɨbhakhome na mawe. ");
INSERT INTO mgq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","We bhabhafisya, bhakhabhɨmɨɨlɨsya pɨlongolela pɨ balaaza ɨlya bhasongo, umupuutili ʉmʉpɨtɨ ʉla akhanda kʉbhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ɨmwe tubhakhaanile kʉtɨ mʉtamanyɨzyaje abhantʉ kʉ makha gɨ taawa lya Yeesu! Ɨleelo mʉkʉjendeelela kʉsaasya ɨmanyɨzyo zyinyu mʉ nhaaya ɨnɨ yonti ɨya mu Yelusaleemu, mʉkwanza yɨloleshe kʉtɨ nɨɨtwe tʉlɨ nɨ nongwa ɨya kʉmʉgoga!” ");
INSERT INTO mgq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","UPeeteli na bhasundikwa abhamwabho bhakhamwamʉla bhakhatɨ, “Tʉkwanzɨwa kumutinikha ʉMʉlʉngʉ, kʉshɨla kubhatinikha abhantʉ! ");
INSERT INTO mgq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","She poope mwámugojile uYeesu kwɨ dala ɨlya kʉmʉkhomeela pa shɨkhobhenhanyo, ɨleelo ʉMʉlʉngʉ ʉwa bhamaama bhɨɨtʉ akhamʉzyʉsya. ");
INSERT INTO mgq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Akhamʉzʉvwa kʉtɨ atabhaale peeka nawo, abhe Mʉpɨtɨ nu Muposhi, ɨnga ʉMʉlʉngʉ atwavwe tuBhaisilaeli tʉbhe nɨ dala ɨlya kʉlaata imbiibhi zyɨtʉ, na kʉtʉʉyɨlwa. ");
INSERT INTO mgq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yɨkʉtɨ ɨtwe tʉbhabhʉzyaje abhantʉ, kʉnongwa ye twe bhakeeti bha zɨnɨɨzyo zyonti, woope uMupepu uMufinjile, we ʉMʉlʉngʉ abhapiiye bhe bhakumutinikha, akusimishizya.” ");
INSERT INTO mgq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Abhapɨtɨ bhaala we bhɨmvwa zɨnɨɨzyo, bhakhalaswa amooyo nhaani, bhakhanzaga kʉtɨ bhabhagoje. ");
INSERT INTO mgq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pɨ balaaza papaala páamɨle nu Mufalisaayi ʉmo, ɨtaawa lyakwe bhakhatɨnjɨ uGamalieli. Wʉnʉʉyo uGamalieli áamɨle mumanyizyi wɨ ndajɨzyo, we abhantʉ bhonti bhakhamushindikhaga. Pe akhɨmɨɨlɨla mwɨ balaaza liila, akhalajɨzya kʉtɨ bhabhafumwe panzɨ abhasundikwa bha Yeesu kʉ khabhalɨlo khashe. ");
INSERT INTO mgq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pe akhabhabhʉʉzya abhapɨtɨ abhamwabho bhaala akhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mu Isilaeli, liniili lye mʉkwanza kʉbhomba kʉ bhantʉ ɨbha, mutengulile nalyo. ");
INSERT INTO mgq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mʉkʉmbʉshe insiku ɨzya palʉsalo, áfumiiye umuntu ʉmo we akhanzaga kʉpɨndʉla ɨnsɨ, ɨtaawa lyakwe bhakhatɨnjɨ uTeuda. Akhayɨbaadaga kʉtɨ muntu mʉpɨtɨ, abhantʉ bhe bhápalamɨɨye kufikha imia zini (400) bhakhɨɨma peeka nawo. Ɨleelo ku wusililishilo, bhakhamʉgoga, na bhaala bhonti bhe bhakhamʉlandataga bhakhasataana. Ɨmbombo yaakwe yonti yikhasilila panaapo. ");
INSERT INTO mgq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iwinza pɨlongolela, akhabhalɨlo khaala khe isilikaali yábhaziizye uwinji wa bhantʉ, akhafumila ʉMʉgalɨlaaya ʉmo, ɨtaawa lyakwe bhakhatɨnjɨ ʉYʉʉda. Woope akhabhasonjeelezya abhantʉ kʉtɨ abhe nɨ shɨpʉga shaakwe kʉnongwa ye akhanzaga kʉpɨndʉla ɨnsɨ. Ɨleelo woope bhakhamʉgoga, bhaala bhonti bhe bhakhamʉlandataga bhoope bhakhasataana. ");
INSERT INTO mgq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ishi ɨnkʉbhabhʉʉzya kʉtɨ, atakhabhe umuntu ʉwa kʉbhasɨtaaka abhantʉ ɨbha! Mʉbhaleshe bhʉʉlo! Ɨnga ɨnsɨɨbho zyabho, na zyonti zye bhakʉbhomba zikufuma kʉ bhantʉ, zitisile nyeene. ");
INSERT INTO mgq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ɨleelo ɨnga zikufuma kwa Mʉlʉngʉ, te mʉkhole kubhadinda, lyoli we mukumudinda wʉ Mʉlʉngʉ wʉʉyo.” ");
INSERT INTO mgq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Isundo lya Gamalieli liila, abhamwabho bhakhalyɨtɨkha. Pe bhakhabhabhɨlɨshɨla abhasundikwa bhaala, bhakhalajɨzya kʉtɨ bhakhomwe ɨya nalyoli. Bhakhabhakhaana kʉtɨ bhatalongaje kʉ makha gɨ taawa lya Yeesu, bhakhabhɨtɨshɨzya kʉtɨ bhasogolaje kʉkhaaya. ");
INSERT INTO mgq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abhasundikwa bhaala bhakhasogola mwɨ balaaza lya bhasongo kumo bhashiiye, kʉnongwa ye ʉMʉlʉngʉ álolile kʉtɨ bhayiiye kʉshoolanywa kʉ zyɨ taawa lya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bhatakhalekha kʉmanyɨzya abhantʉ na kʉbhalʉmbɨɨlɨla iNtumi iNyinza kʉtɨ uYeesu we wu Kilisiti. Bhakhajendeelela kʉmanyɨzya na kʉlʉmbɨɨlɨla insiku zyonti mwi linga ilyi Nyumba iMfinjile, na mu nyumba zya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu nsiku zɨnɨɨzyo uwinji wa bhalandati bha Yeesu wʉkhajendeelela kwonjela. Kukhafumila kuyibhuna mu Bhayahuudi bhe bhakhalongaga ɨndongo ɨya Shiyunaani na bhaala bhe bhakhalongaga iShiebulaniya. Bhaala bhe bhakhalongaga iShiyunaani bhakhayibhunaga kʉtɨ bhaala bhe bhakhalongaga iShiebulaniya bhatakhabhavwaga abhafwɨle bhaabho kʉbhagabhɨla ivwakulya ivwi nsiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pe abhasundikwa bhaala ishumi na bhabhɨlɨ bhakhabhabhʉngaanya abhalandati bhaala bhonti, bhakhabhabhʉʉzya bhakhatɨ, “Yɨtakhondeeye kʉtɨ tʉleshe kʉmanyɨzya izwi lya Mʉlʉngʉ, ɨnga tʉgabhanyaaje abhantʉ ivwakulya. ");
INSERT INTO mgq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ishi ɨmwe mʉbhanholo bhɨɨtʉ, kufumilana nɨɨmwe mʉsebhe abhasakhaala saba bhe bhamanyishile kʉtɨ uMupepu uMufinjile akʉbhalongola, khabhɨlɨ bhamanyile akhinza ɨnjendo inyinza anza she ʉMʉlʉngʉ akwanza. Bhanaabho bhe tʉtɨbhabhɨɨshe mʉ mbombo ɨnɨ ɨya kʉgabhanya ivwakulya, ");
INSERT INTO mgq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ɨnga nɨɨtwe tʉyɨkʉngʉle kʉmʉlaabha ʉMʉlʉngʉ, na kʉmanyɨzya abhantʉ izwi lyakwe.” ");
INSERT INTO mgq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","We bhɨmvwa izwi lɨnɨɨlyo, bhonti bhakhalɨgana nhaani. Pe bhakhamʉsebha uSiteefani, umuntu we ábhiishile ʉlwɨtɨkho lwonti kwa Mʉlʉngʉ, uMupepu uMufinjile akhamʉlongolaga. Khabhɨlɨ bhakhasebha uFilipo, ʉPolokolo, uNikanola, uTimoni, uPalimena, nu Nikolao ʉwa ku Antiokiya, we akhabhalɨlo khamu áyinjiiye mu lupuuto ʉlwa Shiyahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Abhasakhaala saba bhaala bhakhabhabhɨɨkha pɨlongolela pa bhasundikwa. Pe abhasundikwa bhakhabhapuutila kwa Mʉlʉngʉ, na kʉbhabhɨɨkha ɨnyoobhe, kʉbhasebha pa mbombo. ");
INSERT INTO mgq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Izwi lya Mʉlʉngʉ kʉ zya Yeesu lɨkhajendeelela kʉsaata mʉ bhantʉ. Abhalandati bha Yeesu mu Yelusaleemu bhakhonjela nhaani kʉbha bhinji, poope na bhapuutili abhinji, bhoope bhakhamutinikha ʉMʉlʉngʉ, bhakhamwɨtɨkha ʉMwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ɄMʉlʉngʉ ámupiiye uwiila uwinji uSiteefani, khabhɨlɨ ámupiiye amakha aminji, akhabhombaga amayele nɨ vɨlolesyo ɨvɨpɨtɨ mʉ bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ɨleelo aBhayahuudi bhamu bhakhalɨngaga kʉdalɨnhana nawo. Bhanaabho bháfumile mwi sinagoogi, lye bhakhatɨnjɨ iSinagoogi ɨlya Bhantʉ aBhasatʉlwe. Bhamu mʉ bhanaabho, bháfumile mʉ nhaaya ɨya ku Kileene, na ku Alekizandeeliya, bhamu mʉ bhanaabho bháfumile mʉ mʉkoa ʉwa mu Kilikiya, nʉ wa mu Asiya. She poope aBhayahuudi bhanaabho bhakhadalɨnhanaga nu Siteefani, ");
INSERT INTO mgq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ɨleelo akhabhatolaga kʉnongwa ye akhalongaga amazwi agɨ njeele kʉ makha ga Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pe bhakhabhabheka abhantʉ bhamu, ɨnga bhalonje ɨzyɨ lenga kʉtɨ uSiteefani amusholanyiinye ʉMoose, nʉ Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","We bhalonga shɨnɨɨsho, amazwi ganaago gakhabhaviisya nhaani abhasongo abha Bhayahuudi na bhamanyizyi abhɨ ndajɨzyo zya Moose, peeka na bhantʉ bhʉʉlo. Pe bhakhamʉlema uSiteefani, bhakhamʉtwala mwɨ balaaza lya bhasongo. ");
INSERT INTO mgq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bhakhabhaleeta mwɨ balaaza abhakeeti abhɨ lenga bhe bhakhatɨ, “Umuntu ʉnʉ akʉshoolanya iNyumba iMfinjile ɨnɨ, nɨ ndajɨzyo zya Moose! ");
INSERT INTO mgq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Twámwimvwizye akʉlonga akʉtɨ uYeesu ʉwa ku Naazaleti atɨpongolanye inyumba yɨnɨɨnɨ ɨya Mʉlʉngʉ, khabhɨlɨ atɨgalʉlanye aminho ge ʉMoose átʉlesheeye.” ");
INSERT INTO mgq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abhantʉ bhonti bhe bhɨkhaaye mwɨ balaaza liila bhakhamwenya na miiso uSiteefani, bhakhalola kumiiso yaakwe kwakholana nʉ khabhɨzya. ");
INSERT INTO mgq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Umupuutili ʉmʉpɨtɨ akhamʉbhʉzɨɨlɨzya uSiteefani akhatɨ, “Bhʉlɨ, ziniizi zyonti zye bhalonga, shɨnɨɨsho she zɨlɨ?” ");
INSERT INTO mgq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","USiteefani akhaamʉla akhatɨ, “Ɨmwe mʉbhanholo bhaanɨ na mubhayise bhaanɨ, mʉntejeelezye! ɄMʉlʉngʉ ʉwa Wumwamu ámʉlolesheeye ʉmaama wɨɨtʉ uAbulahaamu mʉ nsɨ ɨya mu Mesopotaamiya, we ashɨɨlɨ kʉsaamɨla mʉ nhaaya ɨya mu Halaani. ");
INSERT INTO mgq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ɄMʉlʉngʉ akhamʉbhʉʉzya akhatɨ, ‘Ʉyeepe mʉ nsɨ yaakho ɨnɨ, ʉbhaleshe mʉnʉʉmwo abhanholo bhaakho, ʉbhale mʉ nsɨ ye ɨntɨkʉlanje.’ ");
INSERT INTO mgq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pe uAbulahaamu akhasaama mʉ nsɨ yaakwe ɨya Bhakalɨdaayo, akhabhala akhɨɨkhala mʉ nhaaya ɨya ku Halaani. We uyise waakwe aafwa kʉʉkwo, ʉMʉlʉngʉ akhamʉsaamwa, akhamʉleeta mʉ nsɨ ɨnɨ ye nɨɨmwe mʉkwɨkhala mʉ khabhalɨlo akha shiishi. ");
INSERT INTO mgq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Poope shɨnɨɨsho, mʉ nsɨ ɨnɨ, ʉMʉlʉngʉ atámupiiye uAbulahaamu ishiizi she shitafishiiye poope ʉlwayo lweka kʉtɨ shɨbhe shaakwe. Ɨleelo álajile kʉtɨ atiimupe ɨnsɨ ɨnɨ yɨbhe yaakwe, peeka na bhantʉ abha shɨkholo shaakwe. Akhabhalɨlo khanaakho uAbulahaamu atáamɨle nʉ mwana ngaweeka. ");
INSERT INTO mgq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ɄMʉlʉngʉ akhamʉbhʉʉzya uAbulahaamu akhatɨ, ‘Abhantʉ abha shɨkholo shaakho bhakhayɨbha bhajeni mʉ nsɨ ɨya bhantʉ abhanjɨ. Kʉnʉʉkwo abhantʉ abhɨ nsɨ yɨnɨɨyo bhakhayɨbhabhɨɨkha bhatumwa bhaabho, bhakhayɨbhayɨmvwaga nhaani kʉ manha imia zini (400). ");
INSERT INTO mgq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ɨleelo bhaala bhe bhakhayɨbhabhɨɨkha kʉbha bhatumwa, ɨne ɨnhayɨɨbhapa ulufundo. We gaashɨla ganaago, abhantʉ bhanaabho abha shɨkholo shaakho bhakhayɨsogola mʉ nsɨ yiila, bhakhayimpuuta panaapa.’ ");
INSERT INTO mgq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kusimishizya zɨnɨɨzyo, pe ʉMʉlʉngʉ akhabhɨɨkha ulufingo nu Abulahaamu, lwe lʉkhabhombekhaga kwɨ dala ɨlya kutahiili abhaana bhonti abha shɨsakhaala. Pe uAbulahaamu akhamʉpaapa uIsaaka, akhamutahiili we aamala insiku naane kufuma apaapwe. UIsaaka woope akhamʉpaapa ʉYaakobo, akhamutahiili, ʉYaakobo woope akhapaapa abhasakhaala ishumi na bhabhɨlɨ, akhabhatahiili, bhanaabho bhe bhakhabha bha bhamaama bhɨɨtʉ. ");
INSERT INTO mgq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abhamaama bhɨɨtʉ bhanaabho ʉmwone wʉkhabhalema nhaani kʉ zya nholo waabho uYoosefu, bhakhamʉkazya abhe mutumwa mʉ nsɨ ɨya mu Miisili. Ɨleelo ʉMʉlʉngʉ áamɨle peeka nu Yoosefu, ");
INSERT INTO mgq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akhamʉtʉʉlaga mʉ mayɨmba gaakwe gonti. ɄMʉlʉngʉ akhamʉpanga uYoosefu ɨnjeele, akhamʉbhɨɨkha ʉFalao ʉmwene ʉwa mu Miisili amʉkʉndɨle. Pe ʉFalao akhamʉbhɨɨkha abhe mʉpɨtɨ mʉ nsɨ yaakwe ɨya mu Miisili, na mu nyumba yaakwe ɨya shɨmwene. ");
INSERT INTO mgq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Pɨlongolela, ɨnzala yɨkhagwa mʉ nsɨ yonti ɨya mu Miisili, mwope mʉ nsɨ ɨya mu Kanaani, abhantʉ bhakhayɨmba nhaani. Abhamaama bhɨɨtʉ bhoope ishaakulya shikhabhasilila. ");
INSERT INTO mgq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ɄYaakobo we ayɨmvwa kʉtɨ mʉ nsɨ ɨya mu Miisili mʉlɨ nɨ ngano, akhabhasonteelezya abhaana bhaakwe, bhanaabho abhamaama bhɨɨtʉ, bhabhale kʉʉkwo. Kʉnʉʉkwo kwe kwámɨle kʉshʉʉla kwabho ʉkwa kwanda, kufikha ku Miisili. ");
INSERT INTO mgq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kʉshʉʉla kwabho ʉkwa wʉbhɨlɨ, uYoosefu akhayɨmanyɨsya kʉkwabho, bhoope bhakhamanyɨkha kwa mwene ʉFalao wʉʉyo ʉwa ku Miisili. ");
INSERT INTO mgq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","UYoosefu akhasonteelezya intumi kwa yise waakwe ʉYaakobo kʉtɨ ayɨnze ku Miisili, peeka nɨ nhaaya yaakwe yonti, bháamɨle abhantʉ amashumi saba na bhasaanʉ. ");
INSERT INTO mgq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pe ʉYaakobo akhabhala ku Miisili, akhafwɨla kʉʉkwo. Abhamaama bhɨɨtʉ bhe bhásyalile, bhoope bhakhafwɨla kʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɨleelo amavimba gaabho, bhakhatwala kʉkwabho mʉ nhaaya ɨya ku Shekeemu, bhakhagasyɨla mʉ mbɨɨpa ye uAbulahaamu ákalile kʉ bhaana bha Hamoli. ");
INSERT INTO mgq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“We akhabhalɨlo khapalamɨla khe ʉMʉlʉngʉ atɨbhombe zye álajile kwa Abulahaamu, uwinji wa bhamaama bhɨɨtʉ wónjeeye na kʉbha wʉpɨtɨ nhaani mʉ nsɨ ɨya mu Miisili. ");
INSERT INTO mgq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pɨlongolela, akhanda kʉtabhaala ʉmwene uwunji we atámanyile naazimo ɨzya Yoosefu. ");
INSERT INTO mgq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ʉmwene wʉnʉʉyo akhanda kʉbhayɨmvwa abhamaama bhɨɨtʉ. Akhabhalajɨzya abhantʉ abha shɨkholo shɨɨtʉ kʉtɨ bhataagaje abhaana bhaabho abheela, ɨnga bhafwanje. ");
INSERT INTO mgq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mʉ khabhalɨlo khanaakho ʉMoose woope akhapaapwa, áamɨle mwana umwinza nhaani pamiiso ga Mʉlʉngʉ. Abhapaafi bhaakwe bhakhamʉsʉnga mu nyumba ameezi gatatʉ. ");
INSERT INTO mgq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ɨleelo we bhapootwa kumufisa, bhakhamʉtaaga, ʉmwalɨ wa mwene ʉFalao akhamʉsebha, akhanda kʉmʉsʉnga ngatɨ mʉvʉlɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bhakhamʉmanyɨzya ʉMoose ɨmanyɨzyo zyonti ɨzya Bhamiisili, akhabha mudandamazu kʉlonga, khabhɨlɨ akhabha mugolosu mʉ njendo zyakwe. ");
INSERT INTO mgq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ɄMoose we aafisya amanha amashumi gani, akhasamba kʉbhala kʉbhalola abhanholo bhaakwe aBhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akhamwaga uMumiisili ʉmo akʉmʉkhoma uMwisilaeli naazimo zimo. Akhamwavwa ʉnholo waakwe ʉla, akhatabhʉlɨzya, akhamʉgoga uMumiisili ʉla. ");
INSERT INTO mgq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ɄMoose akhasɨɨbha kʉtɨ abhanholo bhaakwe bhatɨmanye kʉtɨ ʉMʉlʉngʉ atɨbhatʉʉle kʉshɨlɨla kʉkwakwe, ɨleelo abhanholo bhaakwe bhatakhazyaganya zɨnɨɨzyo. ");
INSERT INTO mgq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“We kwasha, ʉMoose akhafumila ku Bhaisilaeli bhabhɨlɨ bhe bhakhalwanga. Akhanzaga kʉtɨ abhataazanye, akhabhabhʉʉzya akhatɨ, ‘Mʉbhasakhaala ɨmwe, mumanyile kʉtɨ mwe bhanashɨkholo! Khooni khe mʉkʉvwalazanya?’ ");
INSERT INTO mgq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ɨleelo ʉla we akhamʉkhomaga ʉwamwabho akhamubunshila ʉMoose, akhamʉbhʉʉzya akhatɨ, ‘Wu naanu we akubhiishile kʉtɨ ʉbhe we mʉsongo, na kʉbha we mwamuli wɨɨtʉ? ");
INSERT INTO mgq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bhʉlɨ, ʉkwanza kʉngoga nɨɨne anza she waamugojile mazʉbha uMumiisili ʉla?’ ");
INSERT INTO mgq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ɄMoose we ayɨmvwa amazwi ganaago, akhashɨmbɨla akhabhala kʉ nsɨ ɨya mu Midiani, akhɨɨkhala anzu mujeni, akhapaapa abhaana bhabhɨlɨ kʉnʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Amanha amashumi gani we gaafikha, ʉMoose áamɨle mu shilozu papɨɨpɨ nɨ gamba ɨlya Sinaayi. Pe ʉkhabhɨzya wa Mwene akhamʉloleshela mʉ shɨsyeta she shɨkhaakhaga ɨmbɨɨtʉ ɨzya mwoto. ");
INSERT INTO mgq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","We aalola, akhaswiga, akhashɨsejeelela ɨshɨsyeta shiila kʉtɨ asheenye akhinza. Nalʉbhɨlo akhɨmvwa izi lya Mwene, lɨkhamʉbhʉʉzya lɨkhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ɨne ne Mʉlʉngʉ wa bhamaama bhaakho, ne Mʉlʉngʉ wa Abulahaamu, ne Mʉlʉngʉ wa Isaaka, khabhɨlɨ ne Mʉlʉngʉ wa Yaakobo.’ ɄMoose we ayɨmvwa zɨnɨɨzyo, akhanda kuyinga, akhoogopa kʉzyenya ɨmbɨɨtʉ ziila. ");
INSERT INTO mgq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Pe ʉMwene akhamʉbhʉʉzya akhatɨ, ‘Zʉʉla ɨndaala zyakho, kʉnongwa ye panaapo pe ʉyɨmɨlɨɨye pafinjile. ");
INSERT INTO mgq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɨne indolile nalyoli she abhantʉ bhaanɨ bhakʉyɨmba mʉ nsɨ ɨya mu Miisili, inimvwizye na kʉlɨla kwabho, iniishile kʉbhatʉʉla mu wutumwa. Ishi ɨnkʉsonteelezye ʉbhale ku Miisili.’ ");
INSERT INTO mgq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ɄMoose wʉnʉʉyo we abhamaama bhɨɨtʉ bhámusiitile, bhakhamʉbhʉʉzya bhakhatɨ, ‘Wu naanu we akubhiishile kʉtɨ ʉbhe we mʉsongo, na kʉbha we mwamuli wɨɨtʉ?’ We wʉnʉʉyo ʉMoose we ʉMʉlʉngʉ ámusonteleziizye kʉtɨ abhe mʉsongo waabho nu muposhi waabho, kufumilana na she ʉkhabhɨzya ámʉlolesheeye mʉ shɨsyeta shiila. ");
INSERT INTO mgq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pɨlongolela, we ábhalongoziizye kʉbheefwa mʉ nsɨ ɨya mu Miisili, kwɨ dala ɨlya kʉlolesya ɨvɨlolesyo na mayele ge akhabhombaga mu Miisili, mwa sʉmbɨ ʉwa Shaamu, na mu shilozu, kʉ khabhalɨlo akha manha amashumi gani. ");
INSERT INTO mgq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“ɄMoose wʉnʉʉyo we ábhabhuziizye aBhaisilaeli kʉtɨ, ‘Kufuma mumwinyu mwe ʉMʉlʉngʉ akhayɨbhasebhela ɨmwe umukuwi we akholiine nɨɨne.’ ");
INSERT INTO mgq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ɄMoose akhabhanga peeka na bhamaama bhɨɨtʉ mu shilozu. We álonjile nʉ khabhɨzya mwɨ gamba ɨlya Sinaayi, akhaposheela amazwi aga wuumi ɨnga aatupe ɨtwe. ");
INSERT INTO mgq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Poope shɨnɨɨsho, abhamaama bhɨɨtʉ bhatakhanzaga kumutinikha, bhakhamʉkhaana, bhakhasʉngʉkha mʉ mooyo gaabho kʉtɨ bhangagalʉkha mʉ nsɨ ɨya ku Miisili. ");
INSERT INTO mgq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","We ʉMoose akhaabha mwɨ gamba, bhakhamʉbhʉʉzya uAaloni ʉmʉsongo waakwe bhakhatɨ, ‘Ʉtʉgombele ivifwani ɨvwa bhamʉlʉngʉ, bhe bhatɨtʉlongozyaje mwɨ dala. ɄMoose we atʉlongolaga kufuma mʉ nsɨ ɨya mu Miisili, tutamanyile zye zimwajile kʉnʉʉkwo!’ ");
INSERT INTO mgq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mu nsiku zɨnɨɨzyo aBhaisilaeli bhaala bhakhagomba ishifwani she shikholiine nɨ ngwata ɨyɨ ngʼombe. Poope she sháamɨle shintu ɨsha kʉgombwa nɨ nyoobhe zyabho bhɨɨbho, bhakhashifumwizya imfinjile, na kʉshɨbhɨɨshɨla ishikulukulu. ");
INSERT INTO mgq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Zɨnɨɨzyo zɨkhapela kʉtɨ ʉMʉlʉngʉ abhaleshe bhapuutaje ɨzʉbha, umwezi, nɨ nzota, anza she yisimbiilwe mu shitaabu ɨsha bhakuwi kʉtɨ, ‘MuBhaisilaeli ɨmwe, mʉ khabhalɨlo khe mwɨ́khaaye amanha amashumi gani mu shilozu, bhʉlɨ, mʉkhambolelaga ɨne ɨvwʉma kʉtɨ mumfumwizye imfinjile? Ndaali! ");
INSERT INTO mgq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yeenya, mʉkhapɨmbaga isheegwi she sháamɨle ni shifwani sha mʉlʉngʉ uMolooki, mʉkhapɨmbaga ishifwani shɨ nzota ya mʉlʉngʉ wiinyu uLefani. Ivifwani vɨnɨɨvwo, vwe mwávigombile kʉtɨ ɨnga muvipuutaje. Kʉnongwa yɨnɨɨyo, ɨntɨbhabhɨɨshe mʉbhe mwe bhakʉngwa, bhakhayɨbhatwala kʉbhala kʉ nsɨ ɨya kutali kʉshɨla ku Babeeli.’” ");
INSERT INTO mgq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","USiteefani akhatɨ, “Mu shilozu mumuula, abhamaama bhɨɨtʉ bhájendeleeye kʉbha ni sheegwi she shikhasimishizyaga kʉtɨ ʉMʉlʉngʉ alɨ peeka na bhantʉ bhaakwe. Isheegwi shɨnɨɨsho bhágombile anza she ʉMʉlʉngʉ ámulajiziizye ʉMoose kʉshɨgomba kʉkholana ni shifwani she áshiwenyi. ");
INSERT INTO mgq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pɨlongolela, abhamaama bhɨɨtʉ peeka nu Yoshua, ʉmʉsongo waabho, bhakhaposhelezanya, bhakhashɨtwala mʉ nsɨ ye bháfwulile kʉ bhantʉ abhɨ nsɨ izinji, mʉ khabhalɨlo khe ʉMʉlʉngʉ ábhabhinjile abhantʉ bhanaabho kʉ bhamaama bhɨɨtʉ. Shɨkhasyala mumuula mʉ nsɨ yaabho kufishila akhabhalɨlo akha Daudi. ");
INSERT INTO mgq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","“Wʉnʉʉyo uDaudi akhamʉkhondezya ʉMʉlʉngʉ, akhamʉlaabha akhatɨ, ‘We Mʉlʉngʉ wa Yaakobo, ʉnɨtɨshɨzye ɨnkʉzenjele inyumba.’ ");
INSERT INTO mgq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ɨleelo ʉmwana waakwe uSelemaani we ázenjile inyumba yɨnɨɨyo. ");
INSERT INTO mgq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Poope shɨnɨɨsho, ʉMʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya, atakwɨkhala mu nyumba zye abhantʉ bhazenjile. Anza she umukuwi álonjile kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ɄMwene akʉtɨ, “Kʉmwanya kwe lɨtengo lyanɨ ɨlya wʉmwene, paasɨ pe pakʉbhɨɨkha ɨvɨnama vwanɨ. Ishi, nyumba yooni ye mʉnganzenjela? Bhʉlɨ, pooshi pe ɨngatʉʉzya? ");
INSERT INTO mgq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bhʉlɨ, vɨnɨɨvwo vwonti te neene nʉneene návipelile?” ’” ");
INSERT INTO mgq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","USiteefani akhajendeelela kʉlonga kʉtɨ, “Ɨmwe mwe mʉlɨ na matwe amagomu! Amooyo giinyu na makutwe giinyu galɨ anza ga bhantʉ abha panzɨ. Wiila bhʉʉlo ɨmwe mukumudinda uMupepu uMufinjile anza shishiila she abhamaama bhiinyu bhoope bhakhabhombaga! ");
INSERT INTO mgq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bhʉlɨ, kʉlɨ nu mukuwi we bhatámuyimvwizye? Yeenya, bhakhabhagogaga poope na bhakuwi bhe bhakhafumwaga uwukuwi kʉ zya kwɨnza kwa Kilisiti uMugolosu pamiiso ga Mʉlʉngʉ! We nɨɨmwe mʉkhamʉtwala kʉ bhalʉgʉ, mʉkhamʉgoga. ");
INSERT INTO mgq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Poope she ɨmwe mwe mwáposheleeye ɨndajɨzyo zya Mʉlʉngʉ kʉshɨlɨla kwa khabhɨzya waakwe, ɨleelo mukhasiitaga kuzitinikha.” ");
INSERT INTO mgq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Abhapɨtɨ bha Bhayahuudi bhaala we bhɨmvwa amazwi ga Siteefani, bhakhaviitwa nhaani, bhakhamuzyekushizya amiino kʉ mʉlakha. ");
INSERT INTO mgq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ɨleelo uMupepu uMufinjile akhamʉlongolaga uSiteefani. Akheenya kʉmwanya kʉ khabhalɨlo, akhalola uwumwamu wa Mʉlʉngʉ, nu Yeesu ayɨmɨlɨɨye kʉlʉbhazʉ ʉlwa kʉndɨɨlo kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pe akhalonga akhatɨ, “Yeenyi! Naalola kʉmwanya kwigukha, ʉMwana wa Muntu ayɨmɨlɨɨye kʉlʉbhazʉ ʉlwa kʉndɨɨlo kwa Mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pe abhapɨtɨ bha Bhayahuudi bhaala bhakhasiita kʉtejeelezya, bhakhadinda amakutwe gaabho, kumo bhakudwegaana, bhakhamʉtomoshela uSiteefani, ");
INSERT INTO mgq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bhakhamufumwa panzɨ pa nhaaya, bhakhanda kʉmʉkhoma na mawe. We bhashɨɨlɨ kwanda kʉmʉkhoma na mawe, abhakeeti bhaala bhakhakipa amakooti gaabho, bhakhagabhɨɨkha pa vɨnama vwa mwana umutunta ʉmo, we bhakhatɨnjɨ uSauli. ");
INSERT INTO mgq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","We bhakʉmʉkhoma uSiteefani na mawe, akhapuutaga akhatɨnjɨ, “Mwene Yeesu, ʉwʉposheele uwuumi waanɨ!” ");
INSERT INTO mgq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pe akhasʉgamɨla paasɨ, akhakhoola kwi zi akhatɨ, “Mwene, ʉtakhabhalonje ku mbiibhi yaabho ɨnɨ ye bhabhomba.” We alonga zɨnɨɨzyo, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","USauli áamɨle weeka mʉ bhaala bhe bhítishile kʉtɨ bhamʉgoje uSiteefani. Abhantʉ bhe bhakhamutinikhaga ʉMʉlʉngʉ bhakhamʉsyɨla uSiteefani. Bhakhabha nu wuswimiilizu nhaani pa mpʉngo yaakwe. Isiku liliila lye bhámugojile uSiteefani, abhantʉ abha shɨbhanza ɨsha mu Yelusaleemu bhakhanda kʉyɨmba nhaani, bhonti bhakhasaata kʉbhala mu Yudeeya, na mu Samaliya. Abhasundikwa bha Yeesu bheene bhe bhásyalile mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","USauli woope akhanda kʉnanganya ɨshɨbhanza. Akhinjilaga mu nyumba zya bhantʉ, akhabhadendelulaga abhasakhaala na bhantanda, akhabhakʉngaga mwɨ jeela. ");
INSERT INTO mgq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abhantʉ ɨbho we bhasataana, bhakhanda kʉmanyɨsya iNtumi iNyinza mʉ bhantʉ poponti. ");
INSERT INTO mgq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","UFilipo woope akhabhala mʉ nhaaya yimo ɨya mu Samaliya, akhanda kʉlʉmbɨɨlɨla intumi zya Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","We bhɨmvwa amazwi ga Filipo, na kʉlola ɨvɨlolesyo vwe akhabhombaga, abhantʉ bhakhamʉtejelezyaga nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Akhabhɨngaga amapepu amabhiibhi mʉ bhantʉ abhinji, gakhabheepaga kumo gakʉlwetaana. Akhabhaponɨaga abhinji bhe bháfuuye kʉndwɨmo, na bhe bhálemaaye ɨvɨnama. ");
INSERT INTO mgq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Pe mʉ nhaaya yɨnɨɨyo mʉkhabha ʉlʉseshelo nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mʉ nhaaya yɨnɨɨyo, mwámɨle umuntu ʉmo we akhabhombaga amayele aga wulozi, ɨtaawa lyakwe bhakhatɨnjɨ uSiimoni. Akhabhaswijizyaga abhantʉ bhonti mʉ mʉkoa ʉwa mu Samaliya ku wulozi we akhabhombaga, khabhɨlɨ akhayɨbaadaga kʉtɨ ʉweene muntu mʉpɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abhantʉ bhonti, abha bhʉʉlo na bhapɨtɨ, bhakhamʉtejelezyaga kumo bhakhatɨnjɨ, “Umuntu ʉnʉ we makha ga Mʉlʉngʉ ge bhakʉtɨ aMakha aMapɨtɨ.” ");
INSERT INTO mgq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Abhantʉ bhakhamʉtejelezyaga kʉnongwa ye insiku inyinji akhabhaswijizyaga kʉ mbombo zyakwe ɨzya wulozi. ");
INSERT INTO mgq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ɨleelo uFilipo we abhamanyɨsya iNtumi iNyinza ɨzya wʉmwene wa Mʉlʉngʉ, nɨ zyɨ taawa lya Yeesu Kilisiti, bhakhazyɨtɨkhaga, abhasakhaala na bhantanda, bhakhozelwaga. ");
INSERT INTO mgq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","USiimoni woope akhamwɨtɨkha uYeesu, akhoozelwa, akhanda kʉmʉlandata uFilipo poponti. We aalola ɨvɨlolesyo na mayele amapɨtɨ ganaago ge uFilipo akhabhombaga, akhaswiga. ");
INSERT INTO mgq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Abhasundikwa bha Yeesu bhe bhásyalile mu Yelusaleemu, we bhɨmvwa kʉtɨ abhantʉ abha mu Samaliya bhoope bhitishile intumi zya Mʉlʉngʉ, bhakhabhasonteelezya uPeeteli nu Yookhani kʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","We bhaafikha, bhakhabhapuutila abhantʉ bhaala kʉtɨ bhoope bhamʉposheele uMupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kʉnongwa ye atálɨɨpo umuntu ngaweeka mʉ bhanaabho we uMupepu ámwɨnzɨɨye, lyoli bhakhozelwaga bhʉʉlo kwɨ taawa lya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","UPeeteli nu Yookhani bhakhabhabhɨɨshɨla ɨnyoobhe ɨzya lʉsayo, pe bhoope bhakhamʉposheela uMupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","USiimoni we aalola kʉtɨ abhantʉ bhaala bhamʉposheela uMupepu uMufinjile kwɨ dala ɨlya kʉbhabhɨɨkha ɨnyoobhe zya bhasundikwa, akhalɨnga kʉʉbhapa ɨnhela uPeeteli nu Yookhani. Akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Amakha ganaago, mumpe nɨɨne, kʉtɨ umuntu wowonti we ɨntɨmʉbhɨɨkhaje ɨnyoobhe, woope aposheelaje uMupepu uMufinjile.” ");
INSERT INTO mgq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","UPeeteli akhamwamʉla akhatɨ, “Ɨwe peeka nɨ nhela zyakho, mʉfwɨle ukutali! Ʉkʉsɨɨbha kʉtɨ ʉngakala ɨshɨkʉnjɨlwa sha Mʉlʉngʉ nɨ nhela! ");
INSERT INTO mgq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɨwe tʉtalɨ peeka mʉ mbombo ɨnɨ, kʉnongwa ye ʉmwoyo waakho mubhiibhi pamiiso ga Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ʉlaate uwubhiibhi waakho ʉwo, ʉlaabhe ishisa kwa Mwene, kʉtɨ akʉtʉʉyɨle kʉ nsɨɨbho zyakho imbiibhi ziniizi ɨzya mwoyo waakho. ");
INSERT INTO mgq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","She indolile kʉtɨ ʉlɨ nʉ mwone nhaani, ni mbiibhi zyakho zɨkʉlemeleeye.” ");
INSERT INTO mgq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","USiimoni akhamwamʉla akhatɨ, “Ɨmwe mumpuutile kwa Mwene, kʉtɨ lɨtakhanaaje ngalyeka mʉ ganaago ge mwalonga!” ");
INSERT INTO mgq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","We uPeeteli nu Yookhani bhaafumwa uwukeeti, na kʉlʉmbɨɨlɨla intumi zya Mwene uYeesu kʉʉkwo, bhakhagalʉkha mu Yelusaleemu, mwɨ dala bhakhalʉmbɨlɨlaga iNtumi iNyinza mʉ tʉkhaaya utunji utwinji ʉtwa mu Samaliya. ");
INSERT INTO mgq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Isiku limo, ʉkhabhɨzya wa Mwene akhamʉbhʉʉzya uFilipo akhatɨ, “Ʉbhale kʉmbalɨntende kʉshɨlɨla ɨdala liila lye likufuma ku Yelusaleemu kʉbhala kʉ Gaaza.” Ɨdala liniili lyáshilile mu shilozu. ");
INSERT INTO mgq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pe uFilipo akhasogola, akhanda kʉjenda mwɨ dala lɨnɨɨlyo, akhakhomaana nu muntu ʉmo ʉwa mʉ nsɨ ɨya mu Esiopiya we áamɨle wutowashi. Wʉnʉʉyo we akhasengulaga ivintu ɨvwɨ nhela ɨmpɨtɨ ɨvwa Kandake, kwe kʉtɨ, ʉmwene ʉmwantanda ʉwɨ nsɨ yɨnɨɨyo ɨya mu Esiopiya. Ʉmʉpɨtɨ wʉnʉʉyo ábhalile ku Yelusaleemu kumupuuta ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","We akʉgalʉkha kʉkhaaya, áyɨkhaaye mu shidodombwi shaakwe, akhabhazyaga mu shitaabu ɨsha mukuwi ʉYeesaya. ");
INSERT INTO mgq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pe uMupepu uMufinjile akhamʉbhʉʉzya uFilipo akhatɨ, “Ʉbhale nalʉbhɨlo ʉlandate ishidodombwi shiila, ushifishile.” ");
INSERT INTO mgq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pe uFilipo akhashɨshɨmbɨɨlɨla, akhashifishila. Akhamwɨmvwa ʉmʉpɨtɨ wʉnʉʉyo akʉbhaazya mu shitaabu ɨsha mukuwi ʉYeesaya, akhamʉbhʉzɨɨlɨzya akhatɨ, “Amazwi ɨgo ge ʉkʉbhaazya, bhʉlɨ, ʉkʉgaaganya?” ");
INSERT INTO mgq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Akhamwamʉla akhatɨ, “Ɨngagaaganya anza bhʉlɨɨbhʉlɨ we atalɨɨpo umuntu ʉwa kʉndɨnganɨzya amazwi ganaaga?” Akhamʉlaabha uFilipo kʉtɨ ayinjile mu shidodombwi shaakwe, bhɨɨkhale peeka. ");
INSERT INTO mgq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","UWusimbe uWufinjile wʉnʉʉwo we ʉmʉpɨtɨ ʉla akhabhazyaga, wʉkʉtɨ, “Bhámulongoleziizye anzɨ ngoole ye bhakʉbhala kʉyɨbhoola. Akhapʉʉma bhʉʉlo, anzɨ nyaana yɨ ngoole she yɨkʉpʉʉma, we bhakʉyɨbhoola amasepe. ");
INSERT INTO mgq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bhakhamʉsʉʉpɨzya na kʉmʉbhaazya kʉtɨ mʉtʉla nongwa, ɨleelo atátulile naalimo. Atalɨɨpo umuntu we angapanga ɨzya bhaana bhaakwe, kʉnongwa ye bháwefwizye uwuumi waakwe mʉ nsɨ, bhakhamʉgoga.” ");
INSERT INTO mgq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ʉmʉpɨtɨ ʉla akhamʉbhʉʉzya uFilipo akhatɨ, “Ɨnkʉlaabha ʉmbʉʉzye, ganaago amazwi ge umukuwi álonjile gakʉlonga ɨzya naanu? Bhʉlɨ, gakʉlonga ɨzya weene wʉʉyo, awe ɨzya wunji?” ");
INSERT INTO mgq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pe uFilipo akhandɨla mu mazwi ganaago aga Wusimbe uWufinjile kʉmʉlʉmbɨɨlɨla iNtumi iNyinza ɨzya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","We bhakʉjendeelela kʉshʉʉla mwɨ dala, bhakhafikha pe páamɨle na minzi. Ʉmʉpɨtɨ ʉla akhamʉbhʉʉzya uFilipo akhatɨ, “Yeenya! Aminzi angɨɨga galɨ ɨpa. Khooni khe khangandinda kʉtɨ ɨntoozelwe?”  ");
INSERT INTO mgq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","UFilipo akhamwamʉla akhatɨ, “Ɨnga wamwɨtɨkha uYeesu Kilisiti kʉ mwoyo waakho wonti, ʉngoozelwa.” Ʉmʉpɨtɨ ʉla akhamwamʉla akhatɨ, “Ɨnkwɨtɨkha kʉtɨ uYeesu Kilisiti we Mwana wa Mʉlʉngʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pe ʉmʉpɨtɨ ʉla akhalajɨzya kʉtɨ ishidodombwi shiila shɨmɨɨlɨle, bhakhiikha, bhakhinjila mu minzi, uFilipo akhamwozya. ");
INSERT INTO mgq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","We bhaafuma mu minzi muula, nalʉbhɨlo uMupepu wa Mwene akhamʉnyamvʉla uFilipo. Ʉmʉpɨtɨ ʉla atakhamʉlola winza, akhajendeelela kʉshʉʉla kumo asesheeye nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","UFilipo woope akhaaga kwe alɨ mʉ nhaaya ɨya mʉ Azooto. Akhasogola panaapo, we akʉshʉʉla akhashɨlɨlaga mʉ nhaaya zyonti ɨzya mwɨ dala, akhabhalʉmbɨlɨlaga abhantʉ iNtumi iNyinza, pe akhafikha mʉ nhaaya ɨya mu Kaisaliya. ");
INSERT INTO mgq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mʉ khabhalɨlo khanaakho, uSauli akhajendelelaga kʉbhoogofwa abhalandati bha Mwene uYeesu, kʉtɨ bhe bhatakʉlekha kʉmʉlandata ʉMwene, atɨbhagoje. Akhabhala kwa mupuutili ʉmʉpɨtɨ, ");
INSERT INTO mgq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akhamʉlaabha aamupe amakalaata aga kʉmʉmanyɨsya kʉ bhasongo abha masinagoogi aga mʉ nhaaya ɨya mu Dameesiki. Amakalaata ganaago gakhamwɨtɨshɨzyaga kʉtɨ bhonti bhe bhalandati bhɨ Dala lya Mwene uYeesu bhe atɨbhaagaje, bhabhe bhasakhaala awe bhantanda, abhakʉngaje, na kʉbhatwala mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pe uSauli akhagolokha ɨdala ɨlya kʉbhala ku Dameesiki. We apalamɨla, nalʉbhɨlo ʉlʉkhozyo ʉlʉpɨtɨ kufuma kʉmwanya lʉkhamʉlamɨla ɨmbalɨ zyonti. ");
INSERT INTO mgq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akhagwa paasɨ, akhɨmvwa izi lɨkʉmʉbhʉʉzya lɨkʉtɨ, “Sauli! Sauli! Khooni khe ʉkʉnjɨmvwa?” ");
INSERT INTO mgq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","USauli akhabhʉzɨɨlɨzya akhatɨ, “We naanu ɨwe Mwene?” Lɨkhamwamʉla lɨkhatɨ, “Ɨne ne Yeesu ne ɨwe ʉkʉnjɨmvwa. ");
INSERT INTO mgq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yɨmɨɨlɨla! Ʉbhale mʉ nhaaya, mʉnʉʉmwo mwe umuntu ʉmo atɨkʉbhʉʉzye zye ʉkwanzɨwa kʉbhomba.” ");
INSERT INTO mgq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abhasakhaala bhe bhakhashʉʉlaga peeka nu Sauli bhakhɨmɨɨlɨla, bhakhapʉʉma mye ku khaswigo, she bhoope bhímvwizye izi lɨnɨɨlyo, ɨleelo bhatakhamʉlola umuntu nʉʉmo. ");
INSERT INTO mgq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pe uSauli akhɨmɨɨlɨla, akhalɨnjɨzya kʉdaamʉla amiiso, akhaaga atakʉlola. Abhamwabho bhakhamʉlema ɨnyoobhe na kʉmʉlongola, bhakhamʉtwala mu Dameesiki. ");
INSERT INTO mgq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Akhamala insiku zɨtatʉ mʉmwo atakʉlola, iwinza atakulya, na kʉmwela akhantʉ naakhamu. ");
INSERT INTO mgq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mu Dameesiki, mwámɨle umulandati ʉmo ʉwa Mwene uYeesu, ɨtaawa lyakwe bhakhatɨnjɨ uAnaniya. ɄMwene akhamʉbhɨlɨshɨla uAnaniya mu njozi ɨzya pamiiso amazelu akhatɨ, “We Ananiya!” Woope akhatɨ, “Angɨɨne ɨndɨ ɨpa Mwene.” ");
INSERT INTO mgq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ɄMwene akhamʉbhʉʉzya akhatɨ, “Ʉbhale mu nyumba ya Yʉʉda ye yɨlɨ mwɨ dala lye bhakʉtɨ Igolosu, ʉbhʉzɨɨlɨzye mʉmwo umuntu ʉwa mʉ nhaaya ɨya mu Taliso, ɨtaawa lyakwe wu Sauli. Ishi akʉmʉlaabha ʉMʉlʉngʉ, ");
INSERT INTO mgq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","alolile injozi ɨzya pamiiso amazelu. Mu njozi zɨnɨɨzyo, amulolile umuntu we ɨtaawa lyakwe bhakhatɨnjɨ uAnaniya akwinjila mu nyumba mwe alɨ, akʉmʉbhɨɨkha ɨnyoobhe, kʉtɨ ayande kʉlola winza.” ");
INSERT INTO mgq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","UAnaniya akhamwamʉla akhatɨ, “We Mwene, yeenya abhantʉ abhinji bhambuziizye she uSauli wʉnʉʉyo abhabhombeeye imbiibhi abhantʉ bhaakho mu Yelusaleemu! ");
INSERT INTO mgq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ishi alɨ panaapa, abhapɨtɨ abha bhapuutili bhamwitishiziizye kʉtɨ abhakʉngaje bhonti bhe bhakwɨtɨkha ɨtaawa lyakho.” ");
INSERT INTO mgq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ɨleelo ʉMwene akhamʉbhʉʉzya uAnaniya akhatɨ, “Bhalaga bhʉʉlo! Umuntu wʉnʉʉyo, ɨmʉsabhʉʉye kʉtɨ abhe mubhombi waanɨ, amanyɨzyaje ɨtaawa lyanɨ kʉ bhe te Bhaisilaeli, kʉ bhamwene bhaabho, khabhɨlɨ na ku Bhaisilaeli bhɨɨbho. ");
INSERT INTO mgq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɨne nʉneene ɨntɨmʉlanje she yɨkwanzɨwa kʉtɨ ayɨmbe nhaani kʉ zyɨ taawa lyanɨ.” ");
INSERT INTO mgq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pe uAnaniya akhabhala akhinjila mu nyumba ye uSauli áamɨle. Akhamʉbhɨɨshɨla ɨnyoobhe, akhamʉbhʉʉzya akhatɨ, “Nholo waanɨ Sauli, ʉMwene uYeesu ansonteleziizye kʉkwakho, kʉtɨ ʉyande kʉlola, ʉmʉposheele uMupepu uMufinjile. Wʉnʉʉyo uYeesu we ákʉlolesheeye mwɨ dala mʉ khabhalɨlo khe ʉkhɨnzaga ɨpa.” ");
INSERT INTO mgq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nalʉbhɨlo ʉtʉkooko twe tʉlɨ ngatɨ tʉgoola tʉkhalenda mu miiso ga Sauli, akhanda kʉlola. Pe akhɨmɨɨlɨla, akhoozelwa. ");
INSERT INTO mgq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","We aalya ishaakulya, akhabha na makha winza. USauli áyɨkhaaye insiku inyinsi mʉ nhaaya yɨnɨɨyo ɨya mu Dameesiki, áamɨle peeka na bhalandati bha Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Pe akhanda kʉbhala mu masinagoogi, akhabhalʉmbɨlɨlaga kʉtɨ uYeesu we Mwana wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abhantʉ bhonti bhe bhakhatejelezyaga ɨmanyɨzyo zyakwe zɨnɨɨzyo, bhakhaswiga nhaani. Bhakhabhʉzɨlɨzanya bhakhatɨ, “Bhʉlɨ, umuntu ʉnʉ, te we wʉ wʉʉla we ayɨmvwaga abhantʉ bhe bhamwitishile uYeesu ku Yelusaleemu? Bhʉlɨ, wʉnʉʉnʉ atinzile kʉtɨ abhakʉnje abhantʉ anza bhanaabho pa Dameesiki ɨpa na kʉbhatwala kʉ bhapɨtɨ bha bhapuutili?” ");
INSERT INTO mgq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Poope shɨnɨɨsho, uSauli akhonjela nhaani kʉbha mudandamazu, akhabhasimishizyaga aBhayahuudi bhe bhakhɨkhalaga ku Dameesiki kʉtɨ uYeesu we wu Kilisiti, na kʉbhatola. ");
INSERT INTO mgq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","We zyashɨla insiku inyinji, aBhayahuudi bhakhɨtɨnhana kʉtɨ bhamʉgoje. ");
INSERT INTO mgq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bhakhamuzijilaga pa vɨlyango ɨvwɨ nhaaya yiila shawusiku na shamʉsanya, kʉtɨ bhamʉgoje. Ɨleelo yɨnɨɨyo ɨnsɨɨbho ɨya kʉmʉgoga, yɨkhamwaga. ");
INSERT INTO mgq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Shawusiku abhalandati bhaakwe bhakhamʉbhɨɨkha mʉ shɨtʉndʉ ɨshɨpɨtɨ, bhakhamʉshɨzya mwi diliisha lye lyámɨle mʉ lʉbhaga ʉlwa mʉ nhaaya, bhakhamwisya panzɨ. ");
INSERT INTO mgq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pɨlongolela, uSauli akhabhala ku Yelusaleemu, akhalɨngaga kʉsangaana na bhalandati bha Yeesu. Ɨleelo bhonti bhámwogopile, kʉnongwa ye bhatítishile kʉtɨ abha mulandati wa Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ɨleelo ʉBalɨnaaba akhamʉtwala uSauli ku bhasundikwa bha Yeesu. Akhabhabhʉʉzya she uSauli ámulolile ʉMwene mwɨ dala ɨlya kʉbhala mu Dameesiki, na she ʉMwene ámubhuziizye. Akhabhabhʉʉzya she uSauli álʉmbɨlɨɨye abhantʉ abha kʉʉkwo ɨzya Yeesu ku wudandamazu. ");
INSERT INTO mgq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pe uSauli akhasyala peeka na bhasundikwa bha Mwene. Akhazyʉngʉʉlaga mu Yelusaleemu, kumo akʉlʉmbɨɨlɨla abhantʉ ɨzya Mwene ku wudandamazu. ");
INSERT INTO mgq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Akhalongaga na kʉdalɨnhana na Bhayahuudi bhamu bhe bhakhalongaga ɨndongo ɨya Shiyunaani, ɨleelo abheene bhakhalɨnga kʉtɨ bhamʉgoje. ");
INSERT INTO mgq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pe abhantʉ bhe bhámwitishile uYeesu bhakhamanya zɨnɨɨzyo, bhakhamʉloleela, bhakhamufisya mu Kaisaliya, bhakhamʉlekha abhalaje kʉkwabho ku Taliso. ");
INSERT INTO mgq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mu nsiku zɨnɨɨzyo, ɨshɨbhanza shɨkhabha nu wutengaanu mwonti mu Yudeeya, mʉ Galɨlaaya, na mu Samaliya. Abhantʉ abha shɨbhanza poponti bhakhagomaga, na kumutinikha ʉMwene uYeesu. UMupepu uMufinjile akhabhavwaga, nu winji waabho wʉkhonjelaga. ");
INSERT INTO mgq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mʉ khabhalɨlo khanaakho uPeeteli akhashɨlaga uku nʉʉkwo, akhafikha mʉ nhaaya ɨya mu Luuda, kʉtɨ abhalamushe abhantʉ bhe bhamwitishile ʉMʉlʉngʉ bhe bhakhɨkhalaga kʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mʉ nhaaya yɨnɨɨyo, akhamwaga umuntu we álemaaye, ɨtaawa lyakwe wu Ayineeya. Ágonile pa shɨlɨlɨ kʉ khabhalɨlo akha manha naane. ");
INSERT INTO mgq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","UPeeteli akhamʉbhʉʉzya akhatɨ, “Ɨwe Ayineeya, uYeesu Kilisiti akʉponɨa. Yɨmɨɨlɨla! Zinga ɨshɨlɨlɨ shaakho.” Nalʉbhɨlo uAyineeya akhɨmɨɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abhantʉ bhe bhakhɨkhalaga mu Luuda, na mwɨ khombe ɨlya Saloni, we bhamʉlola uAyineeya, bhonti bhakhamwɨtɨkha ʉMwene. ");
INSERT INTO mgq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mʉ nhaaya ɨya mʉ Yaafa álɨɨpo ʉmwantanda ʉmo, umulandati wa Yeesu, ɨtaawa lyakwe bhakhatɨnjɨ uTabita. Mʉ ndongo ɨya Shiyunaani, wu Dolikasi. UDolikasi akhabhavwaga abhapɨɨna na kʉbhomba ɨmbombo izinji inyinza. ");
INSERT INTO mgq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu nsiku zɨnɨɨzyo, uDolikasi akhabhina ɨmpʉngo, akhafwa. Abhantʉ bhakhalɨgeezya ivimba lyakwe, bhakhalɨlambalɨkha ku lupitu ʉlwa pamwanya mu nyumba ɨnjelenhanye. ");
INSERT INTO mgq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mʉ khabhalɨlo khanaakho abhalandati bha Yeesu bhakhɨmvwa kʉtɨ uPeeteli alɨ mu Luuda. Pe bhakhabhasonteelezya kʉkwakwe abhantʉ bhabhɨlɨ, kʉnongwa ye ɨnhaaya yɨnɨɨyo yáamɨle papɨɨpɨ nɨ nhaaya yaabho ɨya mʉ Yaafa. Abhantʉ bhe bhábhasonteleziizye bhakhamʉlamba uPeeteli bhakhatɨ, “Twalamba ʉyɨnze kʉkwɨtʉ sita kʉkhabhɨɨlɨla!” ");
INSERT INTO mgq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pe uPeeteli akhabhala peeka nabho. We bhaafikha mʉ Yaafa muula, bhakhamʉtwala mu lupitu ʉlwa pamwanya mu nyumba ɨnjelenhanye. Abhafwɨle bhonti bhakhamʉbhʉngaanɨla kumo bhakʉlɨla. Bhakhamʉlanga amagolole, na menda aganjɨ ge uDolikasi ábhasoneeye we mwumi. ");
INSERT INTO mgq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","UPeeteli akhabhafumwa bhonti panzɨ, akhasʉgamɨla paasɨ, akhamʉlaabha ʉMʉlʉngʉ. Pe akheenya kwi vimba liila akhatɨ, “We Tabita, daamʉkha!” UTabita akhadaamʉla amiiso. We amʉlola uPeeteli, akhɨɨkhala. ");
INSERT INTO mgq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","UPeeteli akhamʉlema ɨnyoobhe, akhamwɨmɨɨlɨsya. Akhabhabhɨlɨshɨla abhafwɨle bhaala, na bhantʉ abhanjɨ bhe bhámwitishile ʉMʉlʉngʉ, akhabhalanga uTabita kʉtɨ mwumi. ");
INSERT INTO mgq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɨnongwa zɨnɨɨzyo zɨkhasaata mʉ nhaaya yonti ɨya mʉ Yaafa, abhantʉ abhinji bhakhamwɨtɨkha ʉMwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","UPeeteli akhasyala mʉ Yaafa insiku inyinji, akhɨkhalaga mu nyumba ya muntu we akhagombaga amagwembe, ɨtaawa lyakwe bhakhatɨnjɨ uSiimoni. ");
INSERT INTO mgq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mʉ nhaaya ɨya mu Kaisaliya mwámɨle umuntu ʉmo we atáamɨle Muyahuudi, ɨtaawa lyakwe bhakhatɨnjɨ uKolineeliyo. Áamɨle mʉpɨtɨ wa bhasikaali, we akhalongozyaga abhasikaali imia yeeka (100) kufuma mʉ mpʉga ɨmpɨtɨ ɨya bhasikaali ye bhakhatɨnjɨ ɨmpʉga ɨya Bhaitaaliya. ");
INSERT INTO mgq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Khabhɨlɨ áamɨle muntu mwinza we akhamutinikhaga ʉMʉlʉngʉ, peeka na bhantʉ bhonti abha mu nyumba yaakwe. Akhamʉlaabhaga ʉMʉlʉngʉ akhabhalɨlo khonti, na kʉbhaavwa nhaani abhapɨɨna. ");
INSERT INTO mgq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Isiku limo pamu mʉ saa tisa ɨya shamʉsanya, uKolineeliyo akhalola injozi ɨzya pamiiso amazelu. Mu njozi zɨnɨɨzyo, akhalola ʉkhabhɨzya wa Mʉlʉngʉ amʉloleshela. Ʉkhabhɨzya akhamʉbhʉʉzya akhatɨ, “We Kolineeliyo!” ");
INSERT INTO mgq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","UKolineeliyo akhamwenya ʉkhabhɨzya ʉla kʉ lyoga, akhamʉbhʉzɨɨlɨzya akhatɨ, “We mwene, kʉlɨ na khooni?” Ʉkhabhɨzya akhamʉbhʉʉzya akhatɨ, “ɄMʉlʉngʉ ayɨmvwa impuuto zyakho, alolile na she ʉkʉbhaavwa abhapɨɨna. Ganaago gonti agamanyile, akʉgaseshela kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pe leelo ishi, ʉbhasonteelezye abhantʉ mʉ Yaafa, bhamʉbhɨlɨshɨle umuntu we bhakʉtɨ uSiimoni, ɨtaawa ɨlyamwabho bhakʉtɨ uPeeteli. ");
INSERT INTO mgq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Akwɨkhala kwa muntu we bhakʉtɨ uSiimoni, we akʉgomba amagwembe. Inyumba yaakwe yɨlɨ mʉmbalɨ mwa sʉmbɨ.” ");
INSERT INTO mgq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ʉkhabhɨzya we aamala kʉmʉbhʉʉzya uKolineeliyo, akhasogola. Pe uKolineeliyo akhabhabhɨlɨshɨla bhabhɨlɨ mu bhabhombi bhaakwe, peeka nu musikaali weeka mu bhaavwi bhaakwe we akhamutinikhaga ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","UKolineeliyo we aamala kʉbhapanjɨla zyonti zye ʉkhabhɨzya álajiziizye, akhabhasonteelezya kʉ Yaafa. ");
INSERT INTO mgq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Isiku ɨlya wʉbhɨlɨ mʉ saala ɨya mʉtanda shamʉsanya, abhantʉ bhe uKolineeliyo ábhasonteleziizye, bhakhapalamɨla mʉ Yaafa. Mʉ khabhalɨlo khanaakho uPeeteli woope akhazʉbha kwi gulu mu nyumba, kʉtɨ amʉlaabhe ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɨnzala yikhamuluma, akhasʉngʉkha kulya. We bhalɨ kʉtelekha ishaakulya she atilye, akhalola injozi ɨzya pamiiso amazelu. ");
INSERT INTO mgq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mu njozi zɨnɨɨzyo, akhalola kʉmwanya kwigukha, akhantʉ khe khalɨ anzɨ golole ɨpɨtɨ lye lilemiilwe ɨmbalɨ zyakwe zini, likhiikha mʉ nsɨ. ");
INSERT INTO mgq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mukaasi yaakwe mwámɨle ɨvɨkhanʉ ɨvwa vɨkholo vwonti. Mwámɨle ɨvɨkhanʉ ɨvwa vɨnama vini, ɨvɨkhanʉ vwe vikudendelukha, ni nyonyi zye zikubumbulukha. ");
INSERT INTO mgq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pe uPeeteli akhɨmvwa izi, lɨkhamʉbhʉʉzya lɨkhatɨ, “We Peeteli, bhʉʉkha! Ʉbhoole ulye!” ");
INSERT INTO mgq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","UPeeteli akhalyamʉla akhatɨ, “Ndaali, we Mwene! Yeenya, intaliiye naalumo akhantʉ khe khakhandamanu!” ");
INSERT INTO mgq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pe izi lɨkhamʉbhʉʉzya uPeeteli lɨkhatɨ, “Akhantʉ khokhonti khe ʉMʉlʉngʉ akhazelufwizye, ɨwe ʉtakhatekhaje kʉtɨ khakhandamanu.” ");
INSERT INTO mgq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Zɨnɨɨzyo zyábhombeshile khatatʉ khonti, pe ɨgolole liila lɨkhagalʉkha kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","We uPeeteli akʉyɨbhʉzɨɨlɨzya kʉtɨ injozi zɨnɨɨzyo kwe kʉtɨ bhʉlɨ, abhantʉ bhaala bhe uKolineeliyo ábhasonteleziizye bhakhabhʉzɨɨlɨzya, pe bhakhayɨmanya inyumba ya Siimoni, bhakhɨmɨɨlɨla pa mʉlyango. ");
INSERT INTO mgq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhakhabhɨlɨshɨla, bhakhabhʉzɨɨlɨzya bhakhatɨ, “Bhʉlɨ, ɨpa pe akʉdɨɨla uSiimoni we bhakʉtɨ uPeeteli?” ");
INSERT INTO mgq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","We uPeeteli akʉsɨɨbha izyi njozi zɨnɨɨzyo, uMupepu uMufinjile akhamʉbhʉʉzya akhatɨ, “Siimoni, paasɨ ɨpa bhalɨɨpo abhantʉ bhatatʉ bhe bhakʉkwanza. ");
INSERT INTO mgq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Uyiishe, mʉbhale peeka, utakhasingaane, ɨne nʉneene ne imbasonteleziizye.” ");
INSERT INTO mgq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","UPeeteli we ayiikha paasɨ, akhabhabhʉʉzya abhantʉ bhaala akhatɨ, “Ɨne ne neene we mʉkʉmwanza. Ishi! Mʉkʉnanzɨla khantʉ khooni?” ");
INSERT INTO mgq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhakhamwamʉla bhakhatɨ, “Ʉmʉpɨtɨ ʉmo ʉwa bhasikaali atusonteleziizye, ɨtaawa lyakwe wu Kolineeliyo, muntu mugolosu, akumutinikha ʉMʉlʉngʉ, khabhɨlɨ aBhayahuudi bhonti bhakʉmʉpaala. Ishi ʉkhabhɨzya wa Mʉlʉngʉ amubhuziizye kʉtɨ akʉposheele mu nyumba yaakwe, atejeelezye amazwi ge ʉtɨmʉbhʉʉzye.” ");
INSERT INTO mgq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pe uPeeteli akhabhaposheela abhantʉ bhaala mu nyumba, bhakhadɨɨla kʉkwakwe. We kwasha, uPeeteli na bhantʉ bha Kolineeliyo bhakhasogola pa Yaafa, abhantʉ bha Yeesu bhamu abha panaapo bhakhabhaloleela. ");
INSERT INTO mgq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","We kwasha winza, bhakhafikha mu Kaisaliya. Bhakhaaga uKolineeliyo abhabhunganyiinye abhanholo bhaakwe, peeka na bhamanyani bhaakwe, akʉbhagʉʉlɨla. ");
INSERT INTO mgq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","UPeeteli we aafikha, uKolineeliyo akhamʉposheela, akhasʉgamɨla paasɨ pa vɨnama vwakwe kuumupa ulushindikho. ");
INSERT INTO mgq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ɨleelo uPeeteli akhamʉbhʉʉsya, akhamʉbhʉʉzya akhatɨ, “Yɨmɨɨlɨla! Yeenya, nɨɨne ne muntu anza wʉneewe!” ");
INSERT INTO mgq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pe uPeeteli nu Kolineeliyo bhakhinjila mu nyumba yaakwe kumo bhakʉlonga, bhakhaaga abhantʉ abhinji bhabhungaanile muula. ");
INSERT INTO mgq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","UPeeteli akhabhabhʉʉzya akhatɨ, “Ɨmwe mumanyile akhinza kʉtɨ ɨtwe tuBhayahuudi ɨndajɨzyo zyɨtʉ zɨkʉkhaana kʉsangaana na bhantʉ bhe te Bhayahuudi. Poope kʉyatɨlana nabho tʉtakwɨtɨshɨlwa. Ɨleelo ʉMʉlʉngʉ andanjile kʉtɨ ɨntamʉtekhaje umuntu wowonti kʉtɨ mukhandamanu. ");
INSERT INTO mgq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ye nongwa we mwambɨlɨshɨla, ininzile sita kusingaana. Ishi, mʉmbɨlɨshɨlɨɨye zyoni?” ");
INSERT INTO mgq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","UKolineeliyo akhamwamʉla akhatɨ, “Zyashɨla insiku zɨtatʉ kufuma mʉ khabhalɨlo khe ɨnhamʉlaabhaga ʉMʉlʉngʉ mu nyumba yaanɨ ɨnɨ, mʉ khabhalɨlo anza khanaakha akha mʉ saa tisa ɨya shamʉsanya. Nalʉbhɨlo ɨnhalola umuntu ayɨmɨlɨɨye pɨlongolela yaanɨ, akwatile amenda ge gakumeetukha. ");
INSERT INTO mgq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akhambʉʉzya akhatɨ, ‘We Kolineeliyo, ʉMʉlʉngʉ ayɨmvwa impuuto zyakho, akʉseshela na she ʉkʉbhaavwa abhapɨɨna. ");
INSERT INTO mgq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pe leelo, ʉbhasonteelezye abhantʉ bhabhale bhamʉbhɨlɨshɨle umuntu we bhakʉtɨ uSiimoni, ɨtaawa ɨlyamwabho bhakʉtɨ uPeeteli. Akwɨkhala mʉ Yaafa, kwa muntu we ɨtaawa lyakwe bhakʉtɨ uSiimoni we akʉgomba amagwembe. Inyumba yaakwe yɨlɨ mʉmbalɨ mwa sʉmbɨ.’ ");
INSERT INTO mgq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zɨnɨɨzyo zye zimbiishile kʉtɨ ɨnsonteelezye abhantʉ bhakʉbhɨlɨshɨle, nɨɨwe wabhomba akhinza we wɨnza. Ishi twenti tʉlɨ pamiiso ga Mwene ʉMʉlʉngʉ, tʉtejeelezye amazwi gonti ge ʉMwene akulajiziizye kʉtɨ ʉtʉbhʉʉzye.” ");
INSERT INTO mgq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pe uPeeteli akhabhabhʉʉzya abhantʉ bhaala akhatɨ, “Ishi pe naamanya kʉtɨ zya nalyoli, ʉMʉlʉngʉ atakwɨmɨla bha ndwɨmo! ");
INSERT INTO mgq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ɨleelo akʉbhɨɨtɨkha abhantʉ abha vɨkholo vwonti bhe bhakumutinikha na kʉbhomba uwugolosu. ");
INSERT INTO mgq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɨmwe mumanyile kʉtɨ ʉMʉlʉngʉ ásonteleziizye abhantʉ bhaakwe kʉbhalʉmbɨɨlɨla aBhaisilaeli iNtumi iNyinza, kʉtɨ bhawaaje uwutengaanu mwa Yeesu Kilisiti, ʉMwene wa bhantʉ bhonti. ");
INSERT INTO mgq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mumanyile zye zibhombeshile mʉ nsɨ yonti ɨya mu Yudeeya, kwandɨla mʉ Galɨlaaya, we uYookhani akhalʉmbɨlɨlaga abhantʉ kʉtɨ bhoozelwe. ");
INSERT INTO mgq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mumanyile kʉtɨ ʉMʉlʉngʉ ámʉsabhʉʉye uYeesu ʉwa ku Naazaleti, akhaamupa uMupepu uMufinjile, na makha. ɄMʉlʉngʉ áamɨle peeka nawo, akhamʉbhɨɨkha kʉtɨ abhombaje inyinza mʉ bhantʉ poponti, akhaponɨaga bhonti bhe bhakhayɨmbaga na makha ga Seetani. ");
INSERT INTO mgq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Gonti ganaago ge uYeesu ábhombile mʉ nsɨ ɨya Bhayahuudi, na mʉ nhaaya ɨya mu Yelusaleemu, ɨtwe twe bhakeeti. Pɨlongolela, bhakhamʉgoga kwɨ dala ɨlya kʉmʉkhomeela pa shɨkhobhenhanyo. ");
INSERT INTO mgq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ɨleelo isiku ɨlya wʉtatʉ, ʉMʉlʉngʉ akhamʉzyʉsya, akhamʉlolesya kʉ bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Te bhantʉ bhonti bhe bhámulolile, ɨleelo ɨtwe twe twámulolile, twe ʉMʉlʉngʉ átʉsabhʉʉye kʉtɨ tʉtɨbhe twe bhakeeti bha zɨnɨɨzyo. Akhabhalɨlo khanaakho khe uYeesu ázyushile mʉ bhafwe, ɨtwe twe twáliiye na kʉmwela peeka nawo. ");
INSERT INTO mgq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akhatʉlajɨzya kʉtɨ tʉlʉmbɨlɨlaje abhantʉ iNtumi iNyinza, na kufumwa uwukeeti kʉtɨ ʉweene we ʉMʉlʉngʉ amubhiishile kʉtɨ we atɨbhalongaje abhuumi, na bhafwe. ");
INSERT INTO mgq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abhakuwi bhonti bhálonjile ɨzya Yeesu, kʉtɨ wowonti we amwɨtɨkha atɨtʉʉyɨlwe imbiibhi kwɨ taawa lyakwe.” ");
INSERT INTO mgq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","UPeeteli we akʉlonga amazwi ganaago, uMupepu uMufinjile akhabhiishila bhonti bhe bhágimvwizye. ");
INSERT INTO mgq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ABhayahuudi bhe bhámwitishile uYeesu bhámʉloleleeye uPeeteli, we bhaalola kʉtɨ na bhantʉ bhe te Bhayahuudi bhoope uMupepu uMufinjile abhiishila, bhakhaswiga nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bháswijile kʉnongwa ye bhábhimvwizye bhakhalongaga kʉ ndongo ɨzya vɨkholo ivwinji kʉmʉpaala ʉMʉlʉngʉ. Pe uPeeteli akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abhantʉ ɨbha bhoope bhamʉposheleeye uMupepu uMufinjile anza she nɨɨtwe twámʉposheleeye. Nʉʉmo we angabhakhaana kʉtɨ bhatoozelwe ku minzi!” ");
INSERT INTO mgq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pe uPeeteli akhalajɨzya kʉtɨ uKolineeliyo na bhamwabho bhoozelwe kwɨ taawa lya Yeesu Kilisiti. Pɨlongolela, bhakhamʉlaabha kʉtɨ asyale peeka nabho ku nsiku nyishe. ");
INSERT INTO mgq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abhasundikwa na bhalandati bha Yeesu abhanjɨ bhe bhakhɨkhalaga mu Yudeeya, bhakhɨmvwa kʉtɨ bhe te Bhayahuudi bhoope bhitishile intumi zya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pe uPeeteli we agalʉkha ku Yelusaleemu, aBhayahuudi bhanaabho bhakhanda kʉmʉsɨtaaka ");
INSERT INTO mgq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bhakhatɨ, “Khooni ɨwe khe winjilaga mu nyumba ya bhantʉ bhe te Bhayahuudi, wasangaanaga kulya ishaakulya peeka nabho?” ");
INSERT INTO mgq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pe uPeeteli akhanda kʉbhabhʉʉzya izwi lyeka lyeka she zyonti zyábhombeshile, akhabhabhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Isiku limo, náamɨle mʉ Yaafa. We ɨndɨ kʉmʉlaabha ʉMʉlʉngʉ, ɨnhalola injozi ɨzya pamiiso amazelu. Mu njozi zɨnɨɨzyo, ɨnhalola akhantʉ khe khalɨ anzɨ golole ɨpɨtɨ lye lilemiilwe ɨmbalɨ zyakwe zini. Khakhiikhaga kufuma kʉmwanya, khakhiishila pambalɨ papaanɨ. ");
INSERT INTO mgq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","We nakheenya mukaasi yaakwe, ɨnhalola mʉlɨ vɨkhanʉ ɨvwa vɨnama vini, ɨvɨkhanʉ vwe vikudendelukha, ni nyonyi zye zikubumbulukha. ");
INSERT INTO mgq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Pe ɨnhɨmvwa izi, lɨkʉtɨ, ‘We Peeteli, bhʉʉkha! Ʉbhoole ulye!’ ");
INSERT INTO mgq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ɨnhaamʉla ɨnhatɨ, ‘Ndaali, we Mwene! Yeenya, intaliiye naalumo akhantʉ khe khakhandamanu!’ ");
INSERT INTO mgq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ɨleelo izi lɨnɨɨlyo kufuma kʉmwanya lɨkhambʉʉzya winza lɨkhatɨ, ‘Akhantʉ khokhonti khe ʉMʉlʉngʉ akhazelufwizye, ɨwe ʉtakhatekhaje kʉtɨ khakhandamanu.’ ");
INSERT INTO mgq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Zɨnɨɨzyo zyábhombeshile khatatʉ khonti, pe ivintu vɨnɨɨvwo vwonti vɨkhagalʉkha kʉmwanya. ");
INSERT INTO mgq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Nalʉbhɨlo abhantʉ bhatatʉ bhe bhábhasonteleziizye kufuma ku Kaisaliya bhɨ́mɨlɨɨye pɨlongolela pa nyumba ye ɨnhɨkhalaga. ");
INSERT INTO mgq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","UMupepu uMufinjile akhambʉʉzya kʉtɨ ɨmbale peeka nabho sita kusingaana. Pe ɨnhabhala, peeka na bhamwɨtʉ ʉmʉtanda ɨbha. We twinjila mu nyumba ya Kolineeliyo, ");
INSERT INTO mgq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","akhatʉpanjɨla she ʉkhabhɨzya ámʉlolesheeye mu nyumba yaakwe mʉnʉʉmwo. Ʉkhabhɨzya wʉnʉʉyo ámubhuziizye átɨlɨ, ‘Ʉbhasonteelezye abhantʉ bhabhale mʉ Yaafa, bhamʉbhɨlɨshɨle uSiimoni we ɨtaawa ɨlyamwabho bhakʉtɨ uPeeteli. ");
INSERT INTO mgq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wʉnʉʉyo we atɨkʉbhʉʉzye amazwi, kʉshɨlɨla mu mazwi ganaago ʉtɨtʉʉlwe ɨwe, peeka na bhantʉ bhonti mu nyumba yaakho.’ ");
INSERT INTO mgq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“We ɨnkwanda kʉlonga na bhantʉ bhanaabho, nalʉbhɨlo uMupepu uMufinjile akhabhiishila, anza she átwishiiye tʉneetwe kʉwandɨlo. ");
INSERT INTO mgq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ɨnhakʉmbʉkha izwi liila lye ʉMwene uYeesu átubhuziizye átɨlɨ, ‘UYookhani akhabhozyaga abhantʉ ku minzi, ɨleelo ɨmwe mʉtɨyoozelwe kwa Mupepu uMufinjile.’ ");
INSERT INTO mgq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Shɨnɨɨsho shɨkʉnjɨlwa she ʉMʉlʉngʉ átupiiye mʉ khabhalɨlo khe twámwitishile ʉMwene uYeesu Kilisiti, na she shɨ shɨnɨɨsho bhoope abhapiiye. Ishi! Ɨne ne naanu kʉtɨ náamɨle ɨndwanje nʉ Mʉlʉngʉ?” ");
INSERT INTO mgq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","“ABhayahuudi we bhɨmvwa zɨnɨɨzyo, bhakhalekha kʉdalɨkha. Bhakhamʉpaala ʉMʉlʉngʉ bhakhatɨ, ‘Fwanɨ ʉMʉlʉngʉ abhapiiye bhoope abhantʉ bhe te Bhayahuudi ɨdala lye bhangalaata imbiibhi zyabho, bhawaaje uwuumi!’ ” ");
INSERT INTO mgq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Abhantʉ bha Yeesu bhe bhásaatile kʉnongwa ya mayɨmba we bhamʉgoga uSiteefani, bhakhabhala mʉ nsɨ ɨya mu Foinike, mu Kipulo, na mʉ nhaaya ɨya mu Antiokiya. Kʉnʉʉkwo kwonti, bhakhalʉmbɨlɨlaga intumi ɨzya Mwene uYeesu ku Bhayahuudi bheene. ");
INSERT INTO mgq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ɨleelo mu Antiokiya, bhamu mʉ bhanaabho, bhínzile kufuma mʉ nsɨ ɨya mu Kipulo, na mʉ nhaaya ɨya mu Kileene. Abheene bhakhanda kʉlʉmbɨɨlɨla iNtumi iNyinza ɨzya Mwene uYeesu na kʉ bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Amakha ga Mwene gáamɨle peeka nabho, abhantʉ abhinji nhaani bhakhɨɨtɨkha na kʉmʉlandata ʉMwene. ");
INSERT INTO mgq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abhantʉ abha shɨbhanza ɨsha ku Yelusaleemu, we bhɨmvwa zɨnɨɨzyo zye zibhombeshile kʉ bhantʉ bhanaabho abha mu Antiokiya, bhakhamʉsonteelezya ʉBalɨnaaba kʉʉkwo. ");
INSERT INTO mgq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","We aafikha kʉʉkwo, akhalola she ʉMʉlʉngʉ abhasayile. Akhaseshela nhaani, akhabhasundililaga bhonti bhajendeelele kʉbha bhasunde kwa Mwene. ");
INSERT INTO mgq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ɄBalɨnaaba áamɨle muntu mwinza, uMupepu uMufinjile akhamʉlongolaga, khabhɨlɨ áamɨle nʉ lwɨtɨkho nhaani. Pe abhantʉ bha Mwene bhakhonjela kʉbha bhinji nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pɨlongolela, ʉBalɨnaaba akhabhala mʉ nhaaya ɨya mu Taliso kʉmwanza uSauli. ");
INSERT INTO mgq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","We amwaga, akhamʉleeta ku Antiokiya. Pe bhakhɨɨkhala kʉʉkwo ʉmwanha wonti, bhakhabhʉngaanaga peeka na bhantʉ abha shɨbhanza, bhakhamanyɨzyaga abhantʉ abhinji nhaani ɨzya Yeesu. Panaapo pa Antiokiya pe abhantʉ bhándile kʉbhatekha abhalandati bha Yeesu kʉtɨ Bhakilisiti. ");
INSERT INTO mgq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu nsiku zɨnɨɨzyo, bhakhɨnza pa Antiokiya abhakuwi bhamu kufuma mu Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Weeka mʉ bhanaabho, ɨtaawa lyakwe bhakhatɨnjɨ ʉAgaabo, akhɨmɨɨlɨla, akhalonga uwukuwi kʉshɨlɨla mwa Mupepu uMufinjile kʉtɨ, ɨnzala ɨmpɨtɨ yitigwe mʉ nsɨ izinji zyonti. Ɨnzala yɨnɨɨyo ye yáfumiiye we uKaisaali uKilaudiyo akhatabhaalaga. ");
INSERT INTO mgq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kufumilana na zɨnɨɨzyo abhalandati bha Yeesu bhakhɨtɨnhana kʉtɨ, weeka weeka afumwe ivintu, kufumilana na viila vwe alɨ navwo, kʉtɨ vwavwaje abhamwabho bhe bhitishile ku Yudeeya. ");
INSERT INTO mgq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhávibhunganyiinye, bhakhaabhapa ʉBalɨnaaba nu Sauli, kʉtɨ bhavɨtwale kʉ bhasongo abha shɨbhanza ɨsha ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu nsiku zɨnɨɨzyo, ʉmwene uHeloodi akhanda kʉbhayɨmvwa abhantʉ bhamu mʉ shɨbhanza. ");
INSERT INTO mgq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akhalajɨzya kʉtɨ bhamʉgoje nʉ mʉfwo ʉmʉpɨtɨ ʉYaakobo ʉkhambakʉ wa Yookhani. ");
INSERT INTO mgq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","We aalola kʉtɨ zɨnɨɨzyo zyabhakhobhosya aBhayahuudi, akhalajɨzya bhamʉleme nu Peeteli. Zyámɨle nsiku ɨzya shikulukulu ɨsha makaati ge gatabhishiilwe uwusafu. ");
INSERT INTO mgq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","We bhamʉlema uPeeteli, uHeloodi akhamʉkʉnga mwɨ jeela. Akhamʉtwala kʉ vɨpʉga vini ɨvwa bhasikaali bhani bhani, kʉtɨ bhamʉlɨndɨɨlɨle akhinza. Akhasɨɨbha kʉtɨ we ishikulukulu ɨshɨ Pasaaka shaashɨla pe amʉlonje uPeeteli pɨlongolela pa bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mu nsiku zɨnɨɨzyo zye uPeeteli ákungiilwe mwɨ jeela, abhantʉ abha shɨbhanza bhakhayɨkʉngʉlaga nhaani kumupuutila kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Shawusiku, we lɨshɨɨlɨ isiku lye uHeloodi álibhiishile kʉmʉlonga uPeeteli, uPeeteli ágonile mwɨ jeela. Áamɨle pakaasi pa bhasikaali bhabhɨlɨ, bhámʉkʉnjɨlɨɨye mʉ nyoobhe zyabho na manyoloolo gabhɨlɨ. Pa lwiji ʉlwɨ jeela bhálɨɨpo abhasikaali abhamwabho bhakhalɨndɨlɨlaga. ");
INSERT INTO mgq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nalʉbhɨlo akhafumila ʉkhabhɨzya wa Mwene akhɨmɨɨlɨla pe uPeeteli áamɨle, ʉlʉkhozyo lʉkhalama mukaasi mu lupitu muula. Ʉkhabhɨzya akhamuyinzanya uPeeteli kʉ lʉbhazʉ kʉmʉdaamʉsya, akhamʉbhʉʉzya akhatɨ, “Daamʉkha nalʉbhɨlo!” Amanyoloolo ge bhámukunjile uPeeteli mʉ nyoobhe gakhalenda paasɨ! ");
INSERT INTO mgq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pe ʉkhabhɨzya ʉyo akhamʉbhʉʉzya akhatɨ, “Yipinye ɨlambɨ lyakho, ʉkwate nɨ vɨlyatʉ.” UPeeteli we aamala kʉbhomba shɨnɨɨsho, ʉkhabhɨzya akhamʉbhʉʉzya akhatɨ, “Kwata ikooti lyakho, ʉndandataje!” ");
INSERT INTO mgq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pe uPeeteli akhamʉlandata ʉkhabhɨzya, bhakhabhalaga kunzi kwɨ jeela. Atámanyile kʉtɨ zɨnɨɨzyo zye ʉkhabhɨzya ábhombile zyámɨle zya nalyoli, akhasɨɨbha kʉtɨ zyámɨle njozi ɨzya pamiiso amazelu. ");
INSERT INTO mgq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","UPeeteli nʉ khabhɨzya wʉnʉʉyo bhakhashɨla pa bhalindiilili abha kwanda, na bha wʉbhɨlɨ, bhakhafikha kʉ mʉlyango ʉwa majela ʉwa kufumila mwɨ jeela, kwinjila mʉ nhaaya. Ʉmʉlyango wʉnʉʉwo wukhabhigushila mwene, bhakhafuma panzɨ. We bhakʉshɨla mʉ mbalaabala yimo, nalʉbhɨlo ʉkhabhɨzya akhamʉlekha uPeeteli. ");
INSERT INTO mgq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pe uPeeteli akhamanya zye zifumiiye, akhatɨ, “Ishi naamanya nalyoli kʉtɨ ʉMwene andeteeye ʉkhabhɨzya waakwe, kʉtɨ antʉʉle mʉ nyoobhe zya Heloodi na mu mbiibhi zyonti zye aBhayahuudi bhasʉbhɨɨye kʉtɨ atɨmbombe.” ");
INSERT INTO mgq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","We aamanya zɨnɨɨzyo, akhabhala ku nyumba ya Maliya, unyina wa Yookhani we bhakhatɨnjɨ uMaalika. Mu nyumba yɨnɨɨyo bhábhungaanile abhantʉ abhinji bhe bhakhamʉlaabhaga ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","UPeeteli akhiguzyaga pa mʉlyango uwi linga ilyi nyumba yiila. Ʉmʉlɨndʉ ʉmo umubhombi, ɨtaawa lyakwe bhakhatɨnjɨ ʉLooda, akhabhala pa mʉlyango kʉtejeelezya kʉtɨ wu naanu. ");
INSERT INTO mgq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","We ayɨmvwa kʉtɨ lizi lya Peeteli, akhaseshela nhaani, akhɨɨwa kumwigulila, akhashɨmbɨɨlɨla mu nyumba. Akhabhabhʉʉzya abhamwabho akhatɨ, “UPeeteli ayɨmɨlɨɨye pa mʉlyango!” ");
INSERT INTO mgq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Abhamwabho bhakhamʉbhʉʉzya bhakhatɨ, “Wabha we mulaalusi!” Ɨleelo ʉmwana ʉmʉlɨndʉ ʉla akhazeemela kʉlonga kʉtɨ alyimvwizye lizi lya Peeteli, pe bhakhamʉbhʉʉzya bhakhatɨ, “Lumo wʉnʉʉyo wʉ khabhɨzya waakwe.” ");
INSERT INTO mgq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","UPeeteli akhajendeelela kwiguzya pa mʉlyango. We bhiigula ʉmʉlyango, bhakhamʉlola, bhakhagandʉkha. ");
INSERT INTO mgq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","UPeeteli akhabhabhʉʉsɨzya ɨnyoobhe kʉtɨ bhapʉʉme mye, akhabhabhʉʉzya she ʉMwene amwefwizye mwɨ jeela. Akhabhabhʉʉzya akhatɨ, “Ziniizi zye zibhombeshile, mʉmʉbhʉʉzye ʉYaakobo na bhanholo abhanjɨ mʉ lwɨtɨkho.” UPeeteli akhasogola paala, akhabhala apanjɨ. ");
INSERT INTO mgq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","We kwasha, abhasikaali bhaala bhakhabha na khantentemwi nhaani kʉnongwa ye bhatámanyile zye zyámwajile uPeeteli. ");
INSERT INTO mgq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","UHeloodi akhalajɨzya abhasikaali kʉtɨ bhamwanze nhaani uPeeteli. Ɨleelo we bhapootwa kʉmwaga, akhabhabhʉzɨɨlɨzya bhaala bhe bhakhamʉlɨndɨlɨlaga, bhakhapootwa ɨlya kwamʉla, pe akhalajɨzya kʉtɨ bhabhagoje. Pɨlongolela, uHeloodi akhasogola mu Yudeeya, akhɨɨkhala kʉ khabhalɨlo mu Kaisaliya. ");
INSERT INTO mgq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","UHeloodi ábhavitiliilwe nhaani abhantʉ abhɨ nhaaya ɨya mu Tiilo, na mu Sidooni. Ɨleelo abhantʉ abhɨ nhaaya zɨnɨɨzyo bhakhɨɨma peeka kʉtɨ bhabhale bhalolane nu Heloodi. Bhakhamʉsonganya uBulasito, we akhasʉngaga inyumba ya mwene, akhɨɨma peeka nabho. Bhakhabhala kwa mwene, kʉlaabha kʉtɨ kʉbhe nu wutengaanu, kʉnongwa ye ɨnhaaya zɨnɨɨzyo zɨkhasʉbhɨlaga ivwakulya kufuma mʉ nsɨ yaakwe. ");
INSERT INTO mgq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","We lyafikha isiku lye ʉmwene uHeloodi ásebhile, akhakwata amenda gaakwe aga shɨmwene, akhɨɨkhala pɨ tengo lyakwe ɨlya shɨmwene, akhanda kʉlajɨla pɨlongolela pa bhantʉ ɨbho na bhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pe abhantʉ bhaala bhakhanda kʉkhoolela kʉ lʉseshelo bhakhatɨ, “Ili te lizi lya muntu! Ɨlyo lizi lya mʉlʉngʉ!” ");
INSERT INTO mgq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","We bhamʉpaala uHeloodi shɨnɨɨsho, atakhaamupa ʉMʉlʉngʉ uwumwamu. Panaapo bhʉʉlo, ʉkhabhɨzya wa Mwene akhamʉkhoma nɨ mpʉngo ɨya kʉlɨɨwa ni mivinyu, akhafwa. ");
INSERT INTO mgq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Intumi zya Mʉlʉngʉ zɨkhajendeelela kʉsaata mʉ bhantʉ, bhe bhitishile bhakhonjela nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ɄBalɨnaaba nu Sauli we bhaamala ɨmbombo yaabho, bhakhasogola ku Yelusaleemu peeka nu Yookhani we bhakhatɨnjɨ uMaalika, bhakhabhala ku Antiokiya. ");
INSERT INTO mgq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mʉ shɨbhanza ɨsha mu Antiokiya mwámɨle abhakuwi na bhamanyizyi, bhe bha bhɨɨbha: ʉBalɨnaaba, uSimilyoni we bhakhatɨnjɨ uMwilu, uLukiyo ʉwa ku Kileene, uManaeni we ásungiilwe peeka nʉ mwene uHeloodi, nu Sauli. ");
INSERT INTO mgq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bhanaabho bhonti we bhalɨ kumupuuta ʉMwene, bhakuyiima kulya, uMupepu uMufinjile akhabhabhʉʉzya akhatɨ, “Mʉnsebhele ʉBalɨnaaba nu Sauli kʉ mbombo ye ɨmbabhɨlɨshɨlɨɨye.” ");
INSERT INTO mgq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","We bhaamala kumupuuta ʉMʉlʉngʉ na kuyiima kulya, bhakhabhabhɨɨshɨla ɨnyoobhe ʉBalɨnaaba nu Sauli, bhakhabhasonteelezya kʉtɨ bhabhalaje. ");
INSERT INTO mgq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pe we uMupepu uMufinjile abhasonteelezya ʉBalɨnaaba nu Sauli, bhakhiikha mʉ nhaaya ɨya ku Selokiya. Kufuma panaapo bhakhasogola ni meeli kʉbhala mʉ nhaaya ɨya mu Salami ɨnsɨ ɨya mu Kipulo ye yáamɨle pakaasi pa sʉmbɨ. ");
INSERT INTO mgq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","We bhaafikha mu Salami, bhakhalʉmbɨlɨlaga abhantʉ intumi zya Mʉlʉngʉ mu masinagoogi aga Bhayahuudi. Bháamɨle peeka nu Yookhani Maalika, umwavwi waabho. ");
INSERT INTO mgq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bhakhashʉʉla mʉ nsɨ yonti ɨya Kipulo, bhakhafikha mʉ nhaaya yimo ɨya mʉnʉʉmwo ye bhakhatɨnjɨ ɨPaafo. Bhakhamwaga uMuyahuudi ʉmo umulozi, umukuwi ʉwɨ lenga, ɨtaawa lyakwe bhakhatɨnjɨ uBali-Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Áamɨle mwavwi wa Selugiyo Paʉlo ʉmʉpɨtɨ wɨ nsɨ ɨya mu Kipulo, we áamɨle muntu wɨ njeele nhaani. Pe ʉmʉpɨtɨ wʉnʉʉyo akhabhabhɨlɨshɨla ʉBalɨnaaba nu Sauli, kʉtɨ bhabhale kʉkwakwe ɨnga ayɨmvwe wʉʉyo intumi zya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ɨleelo uBali-Yeesu umulozi, ɨtaawa lyakwe mu Shiyunaani wu Elima, akhadalɨnhana nʉ Balɨnaaba nu Sauli, akhalɨnga kʉmʉsonganya ʉmʉpɨtɨ ʉla atakhɨɨtɨshe ɨmanyɨzyo zyabho kʉ zya Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pe uMupepu uMufinjile akhanda kʉmʉlongola uSauli, we ɨtaawa lyakwe ɨlyamwabho bhakhatɨnjɨ ʉPaʉlo. Akhamʉzyamɨla uElima, akhamʉbhʉʉzya akhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ɨwe we mwana wa Seetani, we mʉlʉgʉ wa zyonti ɨzya wanalyoli pamiiso ga Mʉlʉngʉ! Uyizuuye malenga meene nu wushevu ʉwa kʉkhopela abhanjɨ. Khooni khe ʉtakʉlekha kʉgalʉlanya amadala amagolosu aga Mwene, kʉbha mu wubhiibhi? ");
INSERT INTO mgq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yeenya ishi, ʉMwene atiikupe ulufundo, utifwe amiiso, te ʉlole ʉlʉkhozyo ʉlwɨ zʉbha kʉ khabhalɨlo.” Nalʉbhɨlo, imbeesu na khiisi khakhamudinda uElima kumiiso, akhalekha kʉlola, akhanda kʉzyʉngʉʉla-zyʉngʉʉla kwanza umuntu ʉwa kʉmʉlema ɨnyoobhe, na kʉmʉlongola. ");
INSERT INTO mgq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pe ʉmʉpɨtɨ ʉla we aalola zye zyabhombekha, akhamwɨtɨkha ʉMwene. Khabhɨlɨ akhaswigaga nhaani nɨ manyɨzyo kʉ zya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ɄPaʉlo na bhamwabho bhakhasogola pa Paafo ni meeli, bhakhafikha mʉ nhaaya ɨya mu Pelige mʉ mʉkoa ʉwa mu Pamfiliya. Ɨleelo uYookhani uMaalika akhabhalekha panaapo, akhagalʉkha ku Yelusaleemu. ");
INSERT INTO mgq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pe ʉPaʉlo nʉ Balɨnaaba bhakhasogola pa Pelige, bhakhajendeelela kʉshʉʉla, bhakhafikha mʉ nhaaya ɨya mu Antiokiya mʉ nsɨ ɨya mu Pisidiya. Pi siku ɨlyɨ Sabaato, bhakhinjila mwi sinagoogi, bhakhɨɨkhala. ");
INSERT INTO mgq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","We umuntu ʉmo abhaazya mu shitaabu ɨshɨ ndajɨzyo zya Moose, na mu wusimbe wa bhakuwi, abhapɨtɨ abhi sinagoogi bhakhasonteelezya umuntu kwa Paʉlo nʉ Balɨnaaba, abhabhʉʉzye atɨ, “Bhanholo, ɨnga mʉlɨ ni zwi ɨlya kʉbhabhʉʉzya abhantʉ kubhajinjizya ʉmwoyo mʉlonje.” ");
INSERT INTO mgq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pe ʉPaʉlo akhɨmɨɨlɨla, akhabhʉʉsya ɨnyoobhe kʉtɨ bhamʉtejeelezye, akhabhabhʉʉzya abhantʉ bhaala akhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mu Isilaeli, na mwe te mwe Bhayahuudi mwe mwinjiiye mu lupuuto ʉlwa Shiyahuudi, mʉntejeelezye! ");
INSERT INTO mgq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ɄMʉlʉngʉ wɨɨtʉ tuBhaisilaeli we ábhasebhile abhamaama bhɨɨtʉ. Mʉ khabhalɨlo khe bhakhɨkhalaga ku wujeni mʉ nsɨ ɨya mu Miisili, akhabhabhɨɨkha bhakhabha shɨkholo shɨpɨtɨ nhaani. Pɨlongolela, akhabhalongozya, akhabheefwa mu Miisili kʉ makha gaakwe amapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Akhabhajimbiilila amanha amashumi gani mu shilozu. ");
INSERT INTO mgq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akhayazya ɨvɨkholo saba mʉ nsɨ ɨya mu Kanaani, akhaabhapa abhamaama bhɨɨtʉ ɨnsɨ yɨnɨɨyo yɨbhe yaabho. ");
INSERT INTO mgq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zyonti zɨnɨɨzyo zyábhombeshile kʉ khabhalɨlo akha manha ge gáfishiiye imia zini na mashumi gasaanʉ (450). “Pɨlongolela, ʉMʉlʉngʉ akhaabhapa abhamaama bhɨɨtʉ abhaamuli abha kʉbhalongozya, paka mʉ khabhalɨlo khe umukuwi uSamweli akhabhatabhaala. ");
INSERT INTO mgq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pe bhakhalaabha kʉtɨ bhabhe nʉ mwene. ɄMʉlʉngʉ akhaabhapa uSauli, ʉmwana wa Kishi, ʉwa mʉ shɨkholo sha Benjamiini abhe wʉ mwene waabho kʉ manha amashumi gani. ");
INSERT INTO mgq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","We ʉMʉlʉngʉ amwefwa uSauli, akhamʉsebha uDaudi abhe wʉ mwene waabho. ɄMʉlʉngʉ akhamusimishizya uDaudi akhatɨ, ‘Namʉlola uDaudi ʉmwana wa Yeese, akʉwʉkhondezya ʉmwoyo waanɨ, khabhɨlɨ we atɨbhombe zyonti zye ɨnkwanza zɨbhombeshe.’ ");
INSERT INTO mgq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kufuma mʉ shɨkholo sha Daudi mwe ʉMʉlʉngʉ ábhaleteeye aBhaisilaeli uMuposhi uYeesu, anza she álajile. ");
INSERT INTO mgq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","We uYeesu ashɨɨlɨ kwanda ɨmbombo yaakwe, uYookhani álongoleeye kʉbhalʉmbɨɨlɨla aBhaisilaeli bhonti akhatɨnjɨ bhalaate imbiibhi zyabho, na kwozelwa. ");
INSERT INTO mgq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","UYookhani we akʉmalɨɨlɨzya ɨmbombo yaakwe, akhabhabhʉzyaga abhantʉ akhatɨnjɨ, ‘Mʉkʉsɨɨbha kʉtɨ ɨne ne naanu? Ɨne te ne wʉ wʉʉla we mʉkʉmʉgʉʉlɨla! Yeenyi, wʉnʉʉyo we akwɨnza kʉlandata papaanɨ, ɨne ɨntakhondeeye poope kʉsatʉla amakhobha gɨ ndaala zyakwe.’ ");
INSERT INTO mgq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ɨmwe bhanholo bhaanɨ, mʉbhaana abha shɨkholo sha Abulahaamu, na mwe te mwe Bhayahuudi mwe mwinjiiye mu lupuuto ʉlwa Shiyahuudi, intumi ziniizi ɨzya wuposhi zɨtwɨnzɨɨye ɨtwe kufuma kwa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Abhantʉ bhe bhakhaaya mu Yelusaleemu peeka na bhapɨtɨ bhaabho bhatámumanyile uYeesu kʉtɨ we Muposhi, khabhɨlɨ bhatágaganyiinye na mazwi ga bhakuwi kʉ zya Yeesu ge bhakʉbhaazya insiku zyonti ɨzyɨ Sabaato. Bhakhagakwɨlɨzya kwɨ dala ɨlya kʉmʉlonga uYeesu ku lufundo ʉlwa kʉmʉgoga. ");
INSERT INTO mgq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","She poope bhatályajile izwi ɨlya nalyoli lye lɨkʉlolesya kʉtɨ bhakhondeeye kʉmʉgoga uYeesu, ɨleelo bhakhamʉlaabha ʉPɨlaato amʉlonje kʉtɨ bhamʉgoje. ");
INSERT INTO mgq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","We bhakwɨlɨzya zyonti zye uYeesu ásimbiliilwe, bhakhamwisya pa shɨkhobhenhanyo, bhakhamʉsyɨla mʉ mbɨɨpa. ");
INSERT INTO mgq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ɨleelo ʉMʉlʉngʉ akhamʉzyʉsya mʉ bhafwe. ");
INSERT INTO mgq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","UYeesu woope akhayɨlolesyaga insiku inyinji mʉ bhantʉ bhe bhábhalile peeka kufuma kʉ Galɨlaaya, kʉbhala ku Yelusaleemu. Bhanaabho bhe bhakeeti bhaakwe kʉ shɨkholo shɨɨtʉ ɨsha Bhaisilaeli. ");
INSERT INTO mgq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ɨtwe tʉkʉbhalʉmbɨɨlɨla iNtumi iNyinza, kʉtɨ ziila zye ʉMʉlʉngʉ álajile kʉ bhamaama bhɨɨtʉ, ");
INSERT INTO mgq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","abhombile kʉkwɨtʉ tʉbhazʉkʉlʉ bhaabho kwɨ dala ɨlya kʉmʉzyʉsya uYeesu, anza she yisimbiilwe mwa Zabuuli ɨya wʉbhɨlɨ kʉtɨ, ‘Ɨwe we Mwana waanɨ, ʉmʉsanyʉʉnʉ nabha ne Taata waakho.’ ");
INSERT INTO mgq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Khabhɨlɨ ʉMʉlʉngʉ akhamʉzyʉsya uYeesu mʉ bhafwe kʉtɨ atakhaafwe winza. Kʉ zɨnɨɨzyo ʉMʉlʉngʉ átɨlɨ, ‘Nálapile ɨnsayo imfinjile ɨzya nalyoli kwa Daudi, nalyoli ɨnsayo zɨnɨɨzyo zye ɨntɨbhasaye nɨɨmwe.’ ");
INSERT INTO mgq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Izwi lɨnɨɨlyo lisimbiilwe na pamwabho kʉtɨ, ‘Te ʉyɨɨtɨshe kʉmʉlekha uMufinjile waakho, abhole.’” ");
INSERT INTO mgq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ɄPaʉlo akhajendeelela kʉlonga kʉtɨ, “UDaudi we abhomba zyonti zye ʉMʉlʉngʉ akhasɨɨbhaga kʉ bhantʉ abha khabhalɨlo khaakwe, akhafwa. Bhakhamʉsyɨla mʉ mbɨɨpa zya bhayise bhaakwe, akhabhola. ");
INSERT INTO mgq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ɨleelo ʉla we ʉMʉlʉngʉ akhamʉzyʉsya, ʉweene atakhabhola. ");
INSERT INTO mgq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ishi ɨmwe bhanholo bhaanɨ, mʉmanye kʉtɨ kʉshɨlɨla kwa Yeesu wʉnʉʉyo we mʉkʉlʉmbɨɨlɨlwa pe mʉngatʉʉyɨlwa imbiibhi zyinyu. ");
INSERT INTO mgq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mwápotiilwe kʉbhaazɨwa uwugolosu pamiiso ga Mʉlʉngʉ kwɨ dala ɨlya kʉlandata ɨndajɨzyo zya Moose, lyoli kʉ kwɨ dala ɨlya kʉmwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mʉbhe amiiso, gatakhabhaaje ge gasimbiilwe mu vitaabu vwa bhakuwi kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ɨmwe mwe mʉkʉshoolanya, yenyaaji na kuswiga, mʉteejele ukutali. She izi zye ɨnkʉbhomba mu nsiku zyinyu mʉtangazyɨtɨkha naalumo, poope umuntu angabhabhʉʉzya!’” ");
INSERT INTO mgq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ɄPaʉlo nʉ Balɨnaaba, we bhakwepa mwi sinagoogi, abhantʉ bhakhabhalamba kʉtɨ bhagalʉshe pa Sabaato ye yɨkwɨnza, kʉtɨ bhalonje ɨzya mazwi ganaago winza. ");
INSERT INTO mgq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","We abhantʉ bhasogola kʉbhala kʉkhaaya, aBhayahuudi abhinji, peeka na bhantʉ bhe te Bhayahuudi bhe bhakhɨtɨkhaga ulupuuto ʉlwa Shiyahuudi, bhakhabhalandata ʉPaʉlo nʉ Balɨnaaba. Abhasundikwa bhanaabho bhabhɨlɨ bhakhalongaga nabho kʉbhagomwa amooyo, kʉtɨ bhajendeelele kʉbha mu wiila wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Isiku ɨlyɨ Sabaato ye yɨkhalandata, abhantʉ abhinji abha mʉ nhaaya yiila bhakhɨnza kʉtejeelezya intumi zya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ɨleelo abhalongozi abha Bhayahuudi we bhaalola abhantʉ bhabhungaanile ɨmpʉga ɨmpɨtɨ, bhakhabha nʉ mwone nhaani. Bhakhakhaana amazwi ge ʉPaʉlo akhalongaga na kumuliga. ");
INSERT INTO mgq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Poope shɨnɨɨsho, ʉPaʉlo nʉ Balɨnaaba bhakhabhaamʉla aBhayahuudi bhaala ku wudandamazu bhakhatɨ, “Yaakhondeeye intumi zya Mʉlʉngʉ zɨlʉmbɨɨlɨlwe suuti kukwinyu ɨmwe muBhayahuudi. Ɨleelo muzikhaanile, na kʉyɨlola kʉtɨ mʉtakhondeeye kʉbha nu wuumi ʉwa wiila na wiila. Mʉbhe amiiso! Tʉkʉbhalekha, tʉkʉbhala kʉ bhantʉ bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kʉnongwa ye ʉMwene átulajiziizye átɨlɨ, ‘Inkubhiishile ʉbhe we lʉkhozyo kʉ bhantʉ bhe te Bhayahuudi, kʉtɨ ʉbhe we muposhi wa bhantʉ kufishila mwe ɨnsɨ yɨpeleleeye.’” ");
INSERT INTO mgq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Abhantʉ bhe te Bhayahuudi, we bhɨmvwa ganaago amazwi, bhakhaseshela, bhakhazɨpaala intumi zya Mwene uYeesu. Bhonti bhe bhásabhuliilwe kʉbha nu wuumi ʉwa wiila na wiila, bhakhamwɨtɨkha ʉMwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Intumi zya Mwene uYeesu zɨkhasaataga mʉ nsɨ yiila yonti. ");
INSERT INTO mgq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ɨleelo aBhayahuudi bhakhabhasonjeelezya abhantanda abha lushindikho bhe te Bhayahuudi bhe bhakhalandataga ulupuuto ʉlwa Shiyahuudi, na bhapɨtɨ abhɨ nhaaya yiila. Bhanaabho bhakhabhasonjeelezya abhantʉ kʉtɨ bhabhayɨmvwe ʉPaʉlo nʉ Balɨnaaba, bhakhabhabhɨnga mʉ nsɨ yaabho. ");
INSERT INTO mgq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pe ʉPaʉlo nʉ Balɨnaaba bhakhakunyunta ulusuuto mʉ vɨnama vwabho kʉbhasokha, bhakhabhala mʉ nhaaya ɨya mu Ikoniyo. ");
INSERT INTO mgq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ɨleelo, abhalandati bha Yeesu abha pa Antiokiya bhakhaseshelaga nhaani, bhakhalongolwaga nu Mupepu uMufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","We ʉPaʉlo nʉ Balɨnaaba bhalɨ mu Ikoniyo, bhakhinjila mwi sinagoogi ɨlya Bhayahuudi anza she bhálʉbhɨɨye. Bhakhabhamanyɨzya abhantʉ mʉmwo ɨzya Yeesu ku wudandamazu, aBhayahuudi abhinji, peeka na bhantʉ abhinji bhe te Bhayahuudi, bhakhamwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ɨleelo bhamu aBhayahuudi bhe bhákhaanile kʉmwɨtɨkha uYeesu bhakhanda kʉbhasonjeelezya bhe te Bhayahuudi, kʉtɨ bhabhaviitilwe abhalandati bha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pe shɨnɨɨsho, ʉPaʉlo nʉ Balɨnaaba bhakhɨɨkhala insiku inyinji pa Ikoniyo, bhakhabhabhʉzyaga abhantʉ kʉ zya wiila wa Mwene uYeesu ku wudandamazu. ɄMwene akhalolesyaga kʉtɨ amazwi gaabho ga nalyoli, kwɨ dala ɨlya kʉʉbhapa amakha aga kʉbhomba ɨvɨlolesyo na mayele aminji. ");
INSERT INTO mgq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Abhantʉ abhɨ nhaaya yiila bhakhagabhʉnhana, bhamu bhakhabha ku Bhayahuudi, bhamu bhakhabha ku bhasundikwa. ");
INSERT INTO mgq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kʉwʉmalɨlɨshɨlo, aBhayahuudi na bhapɨtɨ bhaabho, peeka na bhantʉ bhe te Bhayahuudi, bhakhɨtɨnhana kʉbhabhomba akhabhiibhi na kʉbhakhoma na mawe ʉPaʉlo nʉ Balɨnaaba. ");
INSERT INTO mgq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Abhasundikwa we bhaamanya lʉnʉʉlwo ʉlwɨtɨnhano, bhakhashɨmbɨɨlɨla mʉ nsɨ ɨya mu Likaoniya, mʉnʉʉmwo bhakhabhala mʉ nhaaya ɨya ku Lisitila na ku Deelibe, na mʉ nhaaya impalamani. ");
INSERT INTO mgq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Poponti bhakhabhalʉmbɨlɨlaga abhantʉ iNtumi iNyinza. ");
INSERT INTO mgq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mu Lisitila, mwámɨle nu muntu ʉmo we álemaaye kufuma kʉpaapwa kwakwe, ɨvɨnama vwakwe vɨtakhajendaga naalumo. ");
INSERT INTO mgq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","We ʉPaʉlo akʉlonga, umuntu ʉla woope áyɨkhaaye papaala akhamʉtejelezyaga. ɄPaʉlo akheenya amiiso kwa muntu ʉla, akhalola kʉtɨ alɨ nʉ lwɨtɨkho lwe lʉngamʉponɨa. ");
INSERT INTO mgq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ɄPaʉlo akhadandɨzya kʉlonga akhatɨ, “Bhʉʉkha! Ʉyɨmɨɨlɨle nɨ vɨnama vwakho!” Pe umuntu ʉla akhɨmɨɨlɨla nalʉbhɨlo, akhanda kʉjenda wʉʉyo. ");
INSERT INTO mgq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Abhantʉ bhe bhábhungaanile ɨmpʉga papaala, we bhaalola she ʉPaʉlo amʉponɨa umuntu ʉla, bhakhanda kuzingula ɨshongo mʉ ndongo yaabho ɨya Shilikaoniya bhakhatɨ, “Abhamʉlʉngʉ bhatwishiiye ku shifwani sha bhantʉ!” ");
INSERT INTO mgq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhakhamʉtaanʉla ʉBalɨnaaba ɨtaawa lya mʉlʉngʉ waabho weeka, we bhakhatɨ uZeu. ɄPaʉlo, bhakhamʉtaanʉla ɨtaawa ɨlya Helime, kʉnongwa ye ʉPaʉlo we akhalongaga nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ishipuuto sha Zeu sháamɨle kunzi yɨ nhaaya. Pe umupuutili ʉwa Zeu akhaleeta ɨnhambakʉ zɨbhɨlɨ, ni vipambwi vwe bhátabhile na mapambo pa mʉlyango ʉwɨ nhaaya. Umupuutili peeka na bhantʉ bhakhanzaga kʉmʉbhoolela ʉPaʉlo nʉ Balɨnaaba zɨnɨɨzyo ɨngʼombe ɨnhambakʉ zɨbhe mpʉmba. ");
INSERT INTO mgq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","We abhasundikwa ʉBalɨnaaba nʉ Paʉlo bhɨmvwa zɨnɨɨzyo, bhakhadeebula amenda gaabho kʉlolesya she bhavitiilwe. Bhakhashɨmbɨla, bhakhinjila mʉ mpʉga ya bhantʉ, bhakhadandɨzya kʉlonga bhakhatɨ, ");
INSERT INTO mgq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mʉbhasakhaala ɨmwe! Khooni khe mʉkʉbhomba ziniizi? Nɨɨtwe twe bhantʉ anza mʉneemwe! Tʉlɨɨpo ɨpa kʉlʉmbɨɨlɨla iNtumi iNyinza, kʉtɨ mʉleshe kupuuta abhamʉlʉngʉ abha khasa, mʉbhe mwe bhantʉ bha Mʉlʉngʉ we mwumi, we ápelile kʉmwanya, na paasɨ, ʉsʉmbɨ, na vwonti vwe vɨlɨ mʉmwo. ");
INSERT INTO mgq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Insiku ɨzya palʉsalo ʉMʉlʉngʉ ábhaleshile abhantʉ bhonti bhe te Bhayahuudi bhajendeelele mʉ zye bhakwanza bhɨɨbho. ");
INSERT INTO mgq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Poope shɨnɨɨsho, atakhalekha kʉlolesya kʉtɨ alɨ peeka nabho. Kʉnongwa ye ʉweene akhabhabhombelaga aminza, kwɨ dala ɨlya kʉʉbhapa imvula, kʉtɨ mʉbhanje nɨ vɨyabho kʉ khabhalɨlo khe khakhondeeye, na kwikuta. Goope amooyo giinyu, akhagapanga ʉlʉseshelo.” ");
INSERT INTO mgq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Poope she ʉPaʉlo nʉ Balɨnaaba bhálonjile ganaago amazwi, ɨleelo yɨkhabha papala kʉbhakhaana abhantʉ kʉtɨ bhatafumwaje imfinjile kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pɨlongolela, bhakhɨnza aBhayahuudi bhamu bhe bháfumile mu Antiokiya, na mu Ikoniyo. Bhakhabhasonjeelezya abhantʉ bhɨɨme peeka na bhɨɨbho, bhonti bhakhamʉkhoma ʉPaʉlo na mawe. Bhakhamudendelula bhakhamʉtwala panzɨ pa nhaaya kʉnongwa ye bhakhasɨɨbhaga kʉtɨ afuuye. ");
INSERT INTO mgq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ɨleelo we abhalandati bha Yeesu bhamʉzyʉngʉlʉʉye, akhadaamʉkha, akhagalʉkha mʉ nhaaya. We kwasha, akhasogola penepo, akhabhala peeka nʉ Balɨnaaba ku Deelibe. ");
INSERT INTO mgq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ɄPaʉlo nʉ Balɨnaaba, we bhalɨ mu Deelibe, bhakhalʉmbɨlɨlaga abhantʉ iNtumi iNyinza, abhinji bhakhabha bhalandati bha Yeesu. Pɨlongolela, bhakhagalʉkha mu Lisitila, mu Ikoniyo, na mu Antiokiya. ");
INSERT INTO mgq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kukuula poponti paala pe bhakʉbhala bhakhabhagomwaga abhalandati amooyo, bhakhabhabhʉzyaga kʉtɨ bhayɨgomwaje mʉ manyɨzyo ɨzya lwɨtɨkho. Bhakhabhabhʉzyaga kʉtɨ, “Kwinjila mʉ wʉmwene wa Mʉlʉngʉ, yɨkhondeeye kʉshɨlɨla mʉ mayɨmba aminji.” ");
INSERT INTO mgq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ɄPaʉlo nʉ Balɨnaaba bhakhabhabhɨɨkhaga abhasongo mʉ vɨbhanza vwonti. Bhakhabhabhɨɨkhaga kwa Mwene uYeesu, we bhámwitishile, ku mpuuto na kuyiima kulya. ");
INSERT INTO mgq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pɨlongolela, ʉPaʉlo nʉ Balɨnaaba bhakhashɨla mʉ nsɨ yɨnɨɨyo ɨya mu Pisidiya, bhakhinjila mʉ mʉkoa ʉwa ku Pamfiliya. ");
INSERT INTO mgq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","We bhamanyɨzya intumi zya Mʉlʉngʉ mu Pelige, bhakhabhala mʉ nhaaya ɨya mu Ataliya. ");
INSERT INTO mgq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bhakhasogola paala ni meeli, bhakhabhala winza ku Antiokiya ɨya mu Siiliya, panaapo pe ɨshɨbhanza shábhabhiishile mu wiila wa Mʉlʉngʉ kʉ mbombo ye bháyimalile. ");
INSERT INTO mgq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","We bhaafikha pa Antiokiya, bhakhabhabhʉngaanɨkha abhantʉ abha shɨbhanza. Bhakhabhabhʉʉzya zyonti zye ʉMʉlʉngʉ abhombile kʉshɨlɨla kʉkwabho, na she abhiguliiye bhe te Bhayahuudi ʉmʉlyango ʉwa kʉmwɨtɨkha uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakhɨɨkhala insiku inyinji pa Antiokiya peeka na bhalandati bha Yeesu. ");
INSERT INTO mgq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abhantʉ bhamu bhakhafuma ku Yudeeya, bhakhabhala mu Antiokiya. Bhakhanda kʉmanyɨzya bhe bhitishile kʉtɨ, “Ɨnga mutatahiliilwe kʉlandatana na minho ge ʉMoose atʉlesheeye, mʉtangakhola kʉwaaga uwuposhi.” ");
INSERT INTO mgq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Izwi lɨnɨɨlyo lɨkhapela amadalɨ nhaani, we ʉPaʉlo nʉ Balɨnaaba bhakʉzaabhana nabho. Kʉwʉmalɨlɨshɨlo, abhantʉ abha shɨbhanza ɨsha pa Antiokiya bhakhafumwa ʉwaamʉlo kʉtɨ bhamu bhabhale ku Yelusaleemu peeka nʉ Paʉlo nʉ Balɨnaaba, ɨnga bhalaabhe amasundo ku bhasundikwa na kʉ bhasongo abha shɨbhanza ku mazwi ganaago. ");
INSERT INTO mgq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pe bhanaabho abhantʉ abha shɨbhanza ɨsha pa Antiokiya bhakhabhasonteelezya. ɄPaʉlo na bhamwabho bhakhashɨla mʉ nsɨ ɨya mu Foinike, na mu Samaliya, bhakhabhabhʉzyaga bhe bhitishile she abhantʉ bhe te Bhayahuudi bhamwitishile uYeesu. Zɨnɨɨzyo ɨnongwa zɨkhabhakhobhosya nhaani bhe bhitishile bhonti. ");
INSERT INTO mgq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ɄPaʉlo na bhamwabho, we bhaafikha mu Yelusaleemu, abhasundikwa, abhasongo na bhantʉ abha shɨbhanza bhakhabhaposheela akhinza. ɄPaʉlo na bhamwabho bhakhabhabhʉʉzya gonti ge ʉMʉlʉngʉ abhombile kʉshɨlɨla kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ɨleelo bhe bhítishile bhamu abha shɨpʉga sha Bhafalisaayi bhakhɨmɨɨlɨla, bhakhatɨ, “Bhoope bhe te Bhayahuudi bhakwanzɨwa kʉtɨ bhatahiliwaaje, khabhɨlɨ bhalajɨzwe kʉtɨ bhatinikhaje ɨndajɨzyo zyonti ɨzya Moose.” ");
INSERT INTO mgq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pe abhasundikwa na bhasongo abha shɨbhanza bhakhabhɨɨkha ʉlʉkhomaano ʉlwa kʉpanzanya, kʉtɨ bhenyeelezye akhinza izwi lɨnɨɨlyo. ");
INSERT INTO mgq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","We abhantʉ ɨbho bhazaabhana kʉ khabhalɨlo akhatali, uPeeteli akhɨmɨɨlɨla, akhabhabhʉʉzya akhatɨ, “Bhanholo bhaanɨ mʉ lwɨtɨkho, ɨmwe mumanyile kʉtɨ akhabhalɨlo khamu khe kháshilile ʉMʉlʉngʉ ánsebhile kufuma mumwinyu, kʉtɨ ɨndʉmbɨɨlɨle iNtumi iNyinza kʉ bhe te Bhayahuudi bhɨmvwe kʉshɨlɨla kʉkwanɨ, na kʉmwɨtɨkha ʉMwene uYeesu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ɄMʉlʉngʉ we amanyile zyonti zye zɨlɨ mʉ mooyo ga bhantʉ, alolesiizye kʉtɨ abhitishile bhe te Bhayahuudi kwɨ dala ɨlya kʉʉbhapa uMupepu uMufinjile, anza she átupiiye nɨɨtwe. ");
INSERT INTO mgq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pe wʉtalɨɨpo ʉwʉgabhʉlanyo we ʉMʉlʉngʉ abhombile kʉkwɨtʉ na kʉ bhɨɨbho, lyoli bhoope abhazelufwizye amooyo gaabho kwɨ dala lɨnɨɨlyo ɨlya kʉmwɨtɨkha ʉMwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ishi! Nongwa yooni ye mʉkʉmʉlɨnga ʉMʉlʉngʉ we mʉkʉbhapɨmbɨzya abhalandati umuzigo wunuuwu ʉwa kʉlandata ɨndajɨzyo, we abhamaama bhɨɨtʉ nɨɨtwe tʉneetwe wátutolile! ");
INSERT INTO mgq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɨtwe tʉkwɨtɨkha kʉtɨ ku wiila wa Mwene wɨɨtʉ uYeesu mwe tʉkʉtʉʉlwa, anza she bhoope bhakʉtʉʉlwa.” ");
INSERT INTO mgq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pe abhantʉ bhonti bhe bháamɨle mwɨ balaaza liila bhakhapʉʉma, bhakhabhatejeelezya ʉPaʉlo nʉ Balɨnaaba we bhakʉbhabhʉʉzya she ʉMʉlʉngʉ akhabhombaga kʉshɨlɨla kʉkwabho amayele nɨ vɨlolesyo ivwinji kʉ bhe te Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","We bhaamala kʉlonga, ʉYaakobo woope akhaamʉla akhatɨ, “Bhanholo bhaanɨ mʉ lwɨtɨkho, mʉtejeelezye! ");
INSERT INTO mgq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","USiimoni atʉbhʉʉzya she ʉMʉlʉngʉ ábhayɨmbɨɨye bhe te Bhayahuudi palʉsalo, akhabhasebha bhamu bhabhe bhantʉ bhaakwe. ");
INSERT INTO mgq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Zɨnɨɨzyo zɨkwɨtɨnhana na zye zisimbiilwe mu vitaabu vwa bhakuwi kʉtɨ, ");
INSERT INTO mgq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ɄMwene álonjile átɨlɨ, “We gaashɨla ganaago, ɨnhayɨgalʉkha, ɨnhayɨzenga winza inyumba ya Daudi ye yiguuye. Ɨnhayɨgomba shipwa ipongoolwi, na kʉyɨmɨɨlɨsya inyumba. ");
INSERT INTO mgq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pe abhantʉ abhanjɨ bhonti, bhaala bhe te Bhayahuudi bhe ɨmbabhɨlɨshɨɨye kʉtɨ bhabhe bhaanɨ, bhakhayɨmʉlandata ʉMwene.” ");
INSERT INTO mgq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Shɨnɨɨsho she akʉlonga ʉMwene, we abhombile akʉtɨ, ziniizi zyámanyishile kufuma khalɨ.’” ");
INSERT INTO mgq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ɄYaakobo akhajendeelela kʉlonga kʉtɨ, “Pe shɨnɨɨsho, bhe te Bhayahuudi bhe bhakʉpɨndʉkha kʉbha bhantʉ bha Mʉlʉngʉ, ɨne ɨnkʉlola tʉtakhondeeye kʉtɨ tʉbhayɨmvwaje. ");
INSERT INTO mgq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lyoli tʉkhondeeye kʉtɨ tubhasimbile ɨkalaata ɨlya kʉbhabhʉʉzya kʉtɨ, bhatalyanje ɨnyama inhandamanu zye bhafumwizye ku lupuuto ʉlwa vifwani vwa bhamʉlʉngʉ, bhatabhombaje uwubhembu, bhatalyanje ɨnyama zye bhanionjile, awe kulya amabhanda. ");
INSERT INTO mgq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kʉnongwa ye kufuma khalɨ, bhakhalʉmbɨlɨlaga ɨndajɨzyo zya Moose mʉ nhaaya zyonti, khabhɨlɨ bhakhabhazyaga mu masinagoogi insiku zyonti ɨzyɨ Sabaato.” ");
INSERT INTO mgq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pe abhasundikwa, abhasongo, nɨ shɨbhanza shonti ɨsha pa Yelusaleemu bhakhafumwa ʉwaamʉlo peeka, kʉtɨ bhasebhe bhamu mʉ bhanaabho bhe bhatɨbhale peeka nʉ Paʉlo nʉ Balɨnaaba ku Antiokiya. Bhakhasebha abhantʉ bhabhɨlɨ, bhe bháamɨle bhalongozi bhamwabho, weeka áamɨle wʉ Yʉʉda, we bhakhatɨnjɨ ʉBalɨsaaba, ʉwamwabho áamɨle wʉ Sɨɨla. ");
INSERT INTO mgq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bhakhabhasonteelezya nɨ kalaata lye lɨkʉtɨ: “Ɨtwe tubhasundikwa peeka na bhasongo abha shɨbhanza, tubhamwinyu, tʉkʉbhalamʉkha ɨmwe mʉbhamwɨtʉ mwe te mwe Bhayahuudi mwe mʉlɨ mu Antiokiya, mʉ nsɨ ɨya mu Siiliya, na bha mʉ nsɨ ɨya mu Kilikiya. ");
INSERT INTO mgq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Twimvwizye kʉtɨ abhamwɨtʉ bhamu kufuma kʉkwɨtʉ bhabhabhuziizye ɨnongwa ɨzya kʉbhayɨmvwa, amooyo giinyu gakhatampile, ɨleelo te twetwe twábhasonteleziizye khaala. ");
INSERT INTO mgq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kufumilana na zɨnɨɨzyo, tʉkhɨtɨnhana kʉtɨ tʉsebhe abhantʉ bhe tʉtɨbhasonteelezye kukwinyu, bhɨnze peeka na bhaganwa bhɨɨtʉ ʉBalɨnaaba nʉ Paʉlo. ");
INSERT INTO mgq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bhanaabho bhakuyifumwa nhaani kʉmʉbhombela ʉMwene wɨɨtʉ uYeesu Kilisiti, poope bhitishile kufwa kʉnongwa yaakwe. ");
INSERT INTO mgq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pe leelo, bhe tʉkʉbhasonteelezya kukwinyu, wʉ Yʉʉda nʉ Sɨɨla, bhe bhatɨbhabhʉʉzye bhɨɨbho ziniizi zye tubhasimbiiye. ");
INSERT INTO mgq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gamukhondeziizye uMupepu uMufinjile nɨɨtwe shishiila, yɨkʉtɨ tʉtabhapɨmbɨzye amazigo aganjɨ, kʉshɨla ɨndajɨzyo ziniizi: ");
INSERT INTO mgq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","mʉtalyanje ɨnyama inhandamanu zye bhafumwizye ku lupuuto ʉlwa vifwani vwa bhamʉlʉngʉ, mʉtalyanje amabhanda, awe ɨnyama zye bhanionjile, khabhɨlɨ mʉtabhombaje uwubhembu. Ɨnga mʉkʉgashɨmbɨla ganaago, we mʉkʉbhomba akhinza. Tʉkhayɨlolanaga.” ");
INSERT INTO mgq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","We bhalagana na bhaala bhe bhábhasonteleziizye, ʉPaʉlo na bhamwabho bhakhabhala ku Antiokiya. Bhakhabhabhʉngaanya abhantʉ abha shɨbhanza, bhakhaabhapa ɨkalaata liila. ");
INSERT INTO mgq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Umuntu we abhabhaazɨzya bhe bhitishile, lɨkhabhakhobhosya ʉmwoyo na kʉbhasansamʉsya. ");
INSERT INTO mgq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ɄYʉʉda nʉ Sɨɨla bhe bhoope bháamɨle bhakuwi, bhakhabhabhʉʉzya abhamwabho mʉ lwɨtɨkho ɨnongwa inyinji ɨzya kʉbhakhobhosya ʉmwoyo, na kʉbhagomwa. ");
INSERT INTO mgq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","We bhɨɨkhala kʉʉkwo kʉ khabhalɨlo, abhamwabho bhakhabhɨtɨshɨzya kʉtɨ bhagalʉkhaje. Bhakhabhabhʉʉzya bhakhatɨ, “Galukhaji ku wutengaanu kʉ bhaala bhe bhabhasonteleziizye.”  ");
INSERT INTO mgq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ɨleelo ʉSɨɨla akhalola kʉtɨ khinza asyale kukuula. ");
INSERT INTO mgq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ɄPaʉlo nʉ Balɨnaaba bhakhasyala ku Antiokiya, abheene na bhantʉ abhanjɨ abhinji bhakhamanyɨzyaga na kʉlʉmbɨɨlɨla intumi zya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Akhabhalɨlo we khaashɨla, ʉPaʉlo akhamʉbhʉʉzya ʉBalɨnaaba akhatɨ, “Tʉgalʉshe mʉ nhaaya ziila zye twaalʉmbɨlɨɨye intumi zya Mwene uYeesu, kʉtɨ twenyeelezye amajendeelelo ga bhanholo bhɨɨtʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ɄBalɨnaaba akhanzaga kʉtɨ bhabhale peeka nu Yookhani we bhakhatɨnjɨ uMaalika. ");
INSERT INTO mgq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ɨleelo ʉPaʉlo akhalola te khinza kʉtɨ bhabhale peeka nu Maalika, kʉnongwa ye ʉweene ábhaleshile mu Pamfiliya, akhasiita kʉjendeelela kʉbhomba ɨmbombo peeka nabho. ");
INSERT INTO mgq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pe kukhafumila amadalɨ nhaani, bhakhalenhaana. ɄBalɨnaaba akhamwega uMaalika, bhakhapanda imeeli bhakhabhala peeka mu Kipulo. ");
INSERT INTO mgq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","We abhamwabho mʉ lwɨtɨkho bhamʉlaabha ʉMwene uYeesu ajendeelele kuumupa uwiila waakwe, ʉPaʉlo akhamwega ʉSɨɨla, akhasogola. ");
INSERT INTO mgq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Akhashɨla mʉ nsɨ ɨya mu Siiliya, nɨ ya mu Kilikiya, akhavɨgomwaga ɨvɨbhanza. ");
INSERT INTO mgq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ɄPaʉlo akhafikha mʉ nhaaya ɨya mu Deelibe, pɨlongolela akhafikha mu Lisitila. Mu Lisitila akhɨkhalaga umulandati wa Yeesu ʉmo, ɨtaawa lyakwe bhakhatɨnjɨ uTiimoti. Unyina waakwe áamɨle Muyahuudi we ámwitishile uYeesu, ɨleelo uyise waakwe áamɨle Muyunaani. ");
INSERT INTO mgq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abhamwabho mʉ lwɨtɨkho ku Lisitila na ku Ikoniyo bhakhamʉpaalaga uTiimoti kʉ njendo inyinza. ");
INSERT INTO mgq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ɄPaʉlo akhanzaga kʉtɨ bhabhale peeka nu Tiimoti mwe akʉshʉʉla, akhamutahiili, kʉnongwa ye aBhayahuudi bhonti abha kukuula bhámanyile kʉtɨ uyise waakwe áamɨle Muyunaani. ");
INSERT INTO mgq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ɄPaʉlo na bhamwabho we bhakʉshɨla mʉ nhaaya ɨzya kukuula, bhakhabhapanga bhe bhitishile ɨndajɨzyo zye zyábhishiilwe na bhasundikwa bha Yeesu na bhasongo abha shɨbhanza ɨsha mu Yelusaleemu, kʉtɨ bhazitinikhaje. ");
INSERT INTO mgq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Shɨnɨɨsho she ɨvɨbhanza vɨkhajendeelela kʉgoma mʉ lwɨtɨkho, bhe bhitishile bhakhonjelaga insiku zyonti. ");
INSERT INTO mgq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","UMupepu uMufinjile ábhakhaanile ʉPaʉlo na bhamwabho kʉtɨ bhatakhasheele kʉlʉmbɨɨlɨla ɨzya Mwene uYeesu mʉ nsɨ ɨya mu Asiya. Pe bhakhashɨla mʉ nsɨ ɨya mu Filigiya, nɨ ya mu Galatiya. ");
INSERT INTO mgq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","We bhaafikha pakaasi pa nyooli ɨya mʉ nsɨ ɨya Misiya nɨ ya Bisiniya, bhakhalɨnjɨzya kwinjila mʉ nsɨ ɨya mu Bisiniya, ɨleelo uMupepu wa Yeesu atakhabhɨtɨshɨzya. ");
INSERT INTO mgq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pe bhakhashɨla mʉ nsɨ ɨya Misiya, bhakhabhala mʉ nhaaya ɨya mʉ Toloa. ");
INSERT INTO mgq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Shawusiku ʉPaʉlo akhalola mu njozi ɨzya pamiiso amazelu ʉmʉsakhaala ʉwa mu Makedoniya ayɨmɨlɨɨye, akʉlamba nhaani akʉtɨ, “Fumiila, ʉyɨnze ku Makedoniya ʉtwavwe.” ");
INSERT INTO mgq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ɄPaʉlo we aalola injozi zɨnɨɨzyo, nalʉbhɨlo bhʉʉlo tʉkhayɨlɨngaanya kʉbhala ku Makedoniya, kʉnongwa ye tʉkhamanya kʉtɨ ʉMʉlʉngʉ atʉbhɨlɨshɨɨye kʉbhalʉmbɨɨlɨla abhantʉ bhaala iNtumi iNyinza. ");
INSERT INTO mgq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pe tʉkhasogola pa Toloa ni meeli, tʉkhabhala tukhashizanya bhʉʉlo tukhafikha mʉ nsɨ ɨya mu Samotilake ye yáamɨle pakaasi pa sʉmbɨ. We kwasha, tʉkhajendeelela kʉshʉʉla, tukhafikha mʉ nhaaya ɨya mu Neapooli. ");
INSERT INTO mgq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Panaapo, tʉkhayɨlekha imeeli, tʉkhashʉʉla tukhafikha mu Filiipi, ye yáamɨle nhaaya mpɨtɨ ɨya mʉ nsɨ ɨya Makedoniya, ye aBhaluumi bhakhatabhaalaga. Twɨ́khaaye mʉ nhaaya yiila insiku nyishe. ");
INSERT INTO mgq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pi siku ɨlyɨ Sabaato tukhafuma kunzi ɨyɨ nhaaya, tʉkhabhala pambalɨ pa lwizi, twásʉbhɨɨye kʉtɨ tʉngapaaga pe abhantʉ bhakumupuuta ʉMʉlʉngʉ. Pe tʉkhɨɨkhala, tʉkhalonga na bhantanda bhe bhábhungaanile papaala. ");
INSERT INTO mgq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mʉ bhaala bhe bhátutejeleziizye, áamɨle mwantanda ʉmo ʉwa mʉ nhaaya ɨya mu Siatila we atáamɨle Muyahuudi, ɨleelo akhɨtɨkhaga ulupuuto ʉlwa Shiyahuudi. Ɨtaawa lyakwe bhakhatɨnjɨ uLidiya, akhabhombaga ɨmbombo ɨya kʉkazya amenda amashamamizu. ɄPaʉlo we abhabhʉʉzya iNtumi iNyinza, ʉMwene uYeesu akhiigula ʉmwoyo wa Lidiya, akhɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","We ayoozelwa peeka na bhantʉ abha mu nyumba yaakwe, akhatʉlambɨɨlɨzya kʉtɨ tʉbhale kʉkwakwe akhatɨ, “Ɨnga mwandola kʉtɨ namwɨtɨkha ʉMwene, saalɨ mwɨkhalaje mu nyumba yaanɨ.” Akhatʉlambɨɨlɨzya nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Isiku limo, we tʉkʉbhala pe abhantʉ bhakhamupuutaga ʉMʉlʉngʉ, akhɨnza ʉmʉlɨndʉ ʉmo umutumwa, we áamɨle ni pepu ibhiibhi lye lɨkhamʉpanga amakha kʉtɨ alagʉlaje zye zɨkwɨnza mwɨlongolela. Kʉshɨlɨla kwa mʉlɨndʉ wʉnʉʉyo abhapɨtɨ bhaakwe bhakhapataga ɨnhela inyinji. ");
INSERT INTO mgq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ʉmʉlɨndʉ wʉnʉʉyo akhatʉlandataga ɨtwe nʉ Paʉlo, kumo akuzingula ɨshongo akʉtɨ, “Abhantʉ ɨbha bhabhombi bha Mʉlʉngʉ ʉMʉpɨtɨ ʉwa kʉmwanya, bhakʉbhalʉmbɨɨlɨla ɨdala lye mʉngayɨtʉʉla!” ");
INSERT INTO mgq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akhabhombaga shɨnɨɨsho insiku inyinji. Ɨleelo isiku limo, ʉPaʉlo akhaviitwa nhaani, akhashebhela, akhalɨbhʉʉzya ipepu ibhiibhi liila akhatɨ, “Ɨnkʉkʉlajɨzya kwɨ taawa lya Yeesu Kilisiti, fuma mwa mʉlɨndʉ ʉnʉ!” Nalʉbhɨlo ipepu liila lɨkhamwepa. ");
INSERT INTO mgq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Abhapɨtɨ bha mʉlɨndʉ ʉla, we bhaalola kʉtɨ ɨdala lye bhatɨzyajɨlaje ɨnhela lyananjɨkha, bhakhamʉlema ʉPaʉlo nʉ Sɨɨla, bhakhabhadendelula, bhakhabhatwala pa bhasongo abhɨ nhaaya. ");
INSERT INTO mgq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bhakhabhasɨtaaka kwɨ balaaza bhakhatɨ, “Abhasakhaala ɨbha Bhayahuudi, bhapelile ibho ɨpɨtɨ mʉ nhaaya yɨɨtʉ ɨnɨ. ");
INSERT INTO mgq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhakʉmanyɨzya kʉtɨ tʉlandataje aminho gaabho ge ɨndajɨzyo zyɨtʉ tuBhaluumi zɨtakwɨtɨshɨzya kʉzyɨtɨkha, poope kʉzɨlandata.” ");
INSERT INTO mgq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ɨmpʉga ya bhantʉ yɨkhɨɨma peeka yikhabhabuda ʉPaʉlo nʉ Sɨɨla. Pe abhasongo bhakhabhazʉʉla amenda ʉPaʉlo nʉ Sɨɨla, bhakhalajɨzya kʉtɨ bhakhomwe nɨ sambogo. ");
INSERT INTO mgq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","We bhabhakhoma nhaani, bhakhabhabunshiilila mwɨ jeela. Pe abhasongo bhakhamʉlajɨzya nhaani umulindiilili kʉtɨ abhalɨndɨɨlɨle akhinza. ");
INSERT INTO mgq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","We bhamʉlajɨzya shɨnɨɨsho, woope umulindiilili akhabhinjizya mu lupitu ʉlwa mukaasi nhaani, akhabhakʉnga ɨvɨnama vwabho mu mapimpi amapɨtɨ. ");
INSERT INTO mgq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","We yaafikha shawusiku pakaasi, ʉPaʉlo nʉ Sɨɨla bhakhamupuutaga ʉMʉlʉngʉ, na kwɨmba ɨnyɨmbo ɨzya kʉmʉpaala, abhakʉngwa abhamwabho bhakhabhatejelezyaga. ");
INSERT INTO mgq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Panaapo bhʉʉlo ishiyingayinga ɨshɨpɨtɨ nhaani shɨkhashɨla mʉ nsɨ, shikhayinzanya ʉlwalo ulwi nyumba ɨyɨ jeela. Inyiiji zyonti zikhiigukha zɨɨzyo nyeene, na manyoloolo gonti ge bhábhakʉnjɨɨye abhakʉngwa gakhasatʉkha. ");
INSERT INTO mgq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Umulindiilili ʉwɨ jeela akhadaamʉkha. We aalola kʉtɨ inyiiji nyigule, akhasakʉla ʉmʉfwo waakwe ʉmʉpɨtɨ kʉtɨ ayɨgoje kʉnongwa ye akhasɨɨbhaga kʉtɨ abhakʉngwa bhonti bhabhelengushile. ");
INSERT INTO mgq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nalʉbhɨlo ʉPaʉlo akhamʉbhɨlɨshɨla kwi zi akhamʉbhʉʉzya akhatɨ, “Ʉtakhayɨgoje! Twenti tʉlɨɨpo munuumu.” ");
INSERT INTO mgq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Umulindiilili akhalajɨzya kʉtɨ abhabhombi bhamʉtwalɨle ʉlʉkhozyo. We bhamʉleetela ʉlʉkhozyo, akhinjila mu nyumba, akhagwa pɨlongolela pa Paʉlo nʉ Sɨɨla kumo akuyinga. ");
INSERT INTO mgq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iwinza akhabhafumwa kunzi, akhabhabhʉzɨɨlɨzya akhatɨ, “Mwe bhapɨtɨ bhaanɨ, ɨnhonzye bhʉlɨ kʉtɨ ɨngwaje uwuposhi?” ");
INSERT INTO mgq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhakhamwamʉla bhakhatɨ, “Ʉmwɨtɨshe ʉMwene uYeesu, atɨkʉtʉʉle peeka na bhantʉ bhe bhalɨ mu nyumba yaakho.” ");
INSERT INTO mgq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","34","Akhabhatwala ʉPaʉlo nʉ Sɨɨla kʉkwakwe, bhakhamʉmanyɨzya intumi zya Mwene uYeesu peeka na bhantʉ bhonti bhe bháamɨle mu nyumba yaakwe, akhoozelwa peeka nabho bhonti. Akhabhalɨlo khakhaala akha shawusiku, akhabhoozya ʉPaʉlo nʉ Sɨɨla amabhamba gaabho, akhaabhapa ishaakulya. Akhasha nhaani peeka na bhaala bhonti bhe bháamɨle mu nyumba yaakwe, kʉnongwa ye bhakhamwɨtɨkha ʉMʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","We kwasha, abhasongo bhakhabhasonteelezya abhapɨtɨ bha bhasikaali kwa mulindiilili ʉwɨ jeela, bhakhamʉbhʉʉzya bhakhatɨ, “Bhasatʉlɨle abhantʉ bhaala.” ");
INSERT INTO mgq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Umulindiilili akhamʉbhʉʉzya ʉPaʉlo akhatɨ, “Abhasongo bhansonteleziizye kʉtɨ ɨmbasatʉlɨle, ishi fumi kunzi, sogolaji mu wutengaanu.” ");
INSERT INTO mgq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ɨleelo ʉPaʉlo akhabhabhʉʉzya abhapɨtɨ bha bhasikaali akhatɨ, “Abhasongo bhatukhomile nhaani pɨlongolela pa bhantʉ na kʉtʉkʉnga mwɨ jeela sita kʉtʉsɨtaaka awe kʉtʉbhʉzɨɨlɨzya, we ɨtwe twe Bhaluumi. Ishi khooni khe bhakwanza kʉtʉsatʉlɨla kukwilu? Zɨtangabha shɨnɨɨsho khaala! Bhɨnze bhɨɨbho bhe bhatʉsatʉlɨle.” ");
INSERT INTO mgq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abhapɨtɨ bha bhasikaali bhakhabhabhʉʉzya zɨnɨɨzyo abhasongo. Abhasongo we bhɨmvwa kʉtɨ ʉPaʉlo nʉ Sɨɨla Bhaluumi, ɨlyoga lɨkhabhalema nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bhakhɨnza kʉbhalamba, bhakhabhafumwa mwɨ jeela, bhakhabhalambaga kʉtɨ bhasogole mʉ nhaaya yiila. ");
INSERT INTO mgq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ɄPaʉlo nʉ Sɨɨla, we bhaafuma mwɨ jeela, bhakhabhala kwa Lidiya. Bhakhakhomaana mʉmwo na bhamwabho mʉ lwɨtɨkho, bhakhabhagomwa ʉmwoyo, bhakhasogola. ");
INSERT INTO mgq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ɄPaʉlo nʉ Sɨɨla bháshilile mʉ nhaaya ɨya mu Amufipooli, nɨ ya Apoloniya, bhakhafikha mʉ nhaaya ɨya mu Tesalonike pe páamɨle isinagoogi ɨlya Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kʉnʉʉkwo ʉPaʉlo akhinjilaga mwi sinagoogi, anza she yáamɨle mwata yaakwe. ƗSabaato zɨtatʉ akhabhalʉmbɨlɨlaga kufuma mu Wusimbe uWufinjile, ");
INSERT INTO mgq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ɨnga abhalɨnganɨzye na kʉbhalanga apazelu kʉtɨ uKilisiti akhondeeye kʉyɨmba na kʉzyʉkha mʉ bhafwe. ɄPaʉlo akhabhabhʉʉzya akhatɨ, “UYeesu wʉnʉʉnʉ we ɨnkʉmʉlʉmbɨɨlɨla kukwinyu we wu Kilisiti.” ");
INSERT INTO mgq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bhamu aBhayahuudi bhakhagɨɨtɨkha amazwi ga Paʉlo. Bhoope aBhayunaani abhinji bhe bhakhɨtɨkhaga ulupuuto ʉlwa Shiyahuudi, peeka na bhantanda abhinji abhapɨtɨ pa mbombo, bhakhɨɨtɨkha, bhakhabha peeka nʉ Paʉlo nʉ Sɨɨla. ");
INSERT INTO mgq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ɨleelo ʉmwone wʉkhabhalema aBhayahuudi abhanjɨ bhe bhatítishile, bhakhabhala mʉ mʉnaalo, bhakhabhalanjɨla abhantʉ abhabhiibhi, bhe bhakhabhʉngaanya abhantʉ abhinji, bhakhanda kʉpela ibho ɨpɨtɨ mʉ nhaaya yonti. Bhakhabhala bhakhinjila kʉ makha mu nyumba ya Yaasoni kʉmwanza ʉPaʉlo nʉ Sɨɨla, ɨnga bhabhatwale apazelu kʉ bhantʉ abha mʉ nhaaya. ");
INSERT INTO mgq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","We bhatabhaaga, bhakhamʉlema uYaasoni wʉʉyo peeka na bhamwabho bhamu mʉ lwɨtɨkho, bhakhabhadendelula paka pa bhapɨtɨ abhɨ nhaaya, kumo bhakuzingula ɨshongo bhakʉtɨ, “Abhantʉ ɨbha bhe bhakʉpela ibho ɨpɨtɨ mʉ nsɨ izinji zyonti, ishi bhinzile panaapa mʉ nhaaya yɨɨtʉ, ");
INSERT INTO mgq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","uYaasoni we abhaposheleeye mu nyumba yaakwe. Bhonti bhakʉshoolanya ɨndajɨzyo zye uKaisaali azibhiishile bhakʉtɨ, ‘Ɨtwe tʉlɨ nʉ mwene uwunji we tʉkʉtɨ uYeesu.’ ” ");
INSERT INTO mgq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Abhapɨtɨ abhɨ nhaaya yiila peeka na bhantʉ we bhɨmvwa ɨnongwa ziila, bhakhazyʉgʉnhana nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bhakhabhabhʉʉzya uYaasoni na bhamwabho bhafumwe ɨvwa kʉbhagombola, bhakhabhɨtɨshɨzya kʉtɨ bhasogolaje kʉkwabho. ");
INSERT INTO mgq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","We kwabha shawusiku, nalʉbhɨlo bhe bhitishile bhakhabhasokha ʉPaʉlo nʉ Sɨɨla kʉtɨ bhasogole bhabhale mʉ nhaaya ɨya kʉ Belooya. We bhaafikha kuula, bhakhinjila mwi sinagoogi ɨlya Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abhantʉ abha pa Belooya bháamɨle bhantʉ bhe bhakhatejelezyaga kʉshɨla abha pa Tesalonike. We ʉPaʉlo akʉbhalʉmbɨɨlɨla intumi zya Mwene uYeesu, bhakhazɨposheela kʉ mwoyo wonti. Bhakhajendeelela kʉbhaazya uWusimbe uWufinjile insiku zyonti, ɨnga bhasimishizye kʉtɨ amazwi ge ʉPaʉlo akʉlonga ga nalyoli. ");
INSERT INTO mgq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ABhayahuudi abhinji bhakhamwɨtɨkha uYeesu, peeka na bhasakhaala na bhantanda abhapɨtɨ abha Shiyunaani. ");
INSERT INTO mgq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ɨleelo aBhayahuudi abha mu Tesalonike, we bhaamanya kʉtɨ ʉPaʉlo akʉlʉmbɨɨlɨla izwi lya Mʉlʉngʉ na kʉ Belooya, kwope bhakhabhala, bhakhapela ibho ɨpɨtɨ na kʉsonganya ɨmpʉga ya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bhe bhitishile pa Belooya bhakhamʉloleela ʉPaʉlo, bhakhamʉtwala nalʉbhɨlo kʉmbalɨ kwa sʉmbɨ, ɨleelo ʉSɨɨla nu Tiimoti abheene bhakhasyala mʉ Belooya. ");
INSERT INTO mgq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhaala bhe bhámʉloleleeye ʉPaʉlo bhakhamufisya mʉ nhaaya ɨya mʉ Aseene. We bhakʉgalʉkha, ʉPaʉlo akhabhasonteelezya nɨ ndajɨlo ɨzya kʉbhatwalɨla uTiimoti nʉ Sɨɨla kʉtɨ bhatakhaabhaje, bhamʉlandate nalʉbhɨlo. ");
INSERT INTO mgq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","We ʉPaʉlo akʉbhagʉʉlɨla uTiimoti nʉ Sɨɨla mʉ Aseene, ʉmwoyo waakwe wʉkhakhatampaga nhaani we aalola kʉtɨ ɨnhaaya yiila yonti yizuuye ivifwani ɨvwa bhamʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pe akhanda kwinjila mwi sinagoogi, akhazabhanaga na Bhayahuudi na Bhayunaani bhe bhakhɨtɨkhaga ulupuuto ʉlwa Shiyahuudi. Khabhɨlɨ insiku zyonti, akhazabhanaga apazelu na bhantʉ bhe akhakhomaanaga nabho mʉ manaalo. ");
INSERT INTO mgq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Abhamanyi bhamu bhe bhakhatɨnjɨ aBhaepikuleeyo na Bhasitoiki bhakhɨnza kʉdalɨnhana nʉ Paʉlo. Bhamu bhakhatɨ, “Akwanza kʉlonga zyoni umulabhanjishi ʉnʉ?” Bhamu bhakhatɨ, “Yɨkʉlolekha kʉtɨ akʉlonga zya bhamʉlʉngʉ bhaakwe abhɨ nsɨ izinji.” Bhálonjile shɨnɨɨsho, kʉnongwa ye ʉPaʉlo akhabhalʉmbɨlɨlaga iNtumi iNyinza ɨzya Yeesu, nɨ zya kʉzyʉkha kwakwe. ");
INSERT INTO mgq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pe abhamanyi bhaala bhakhamʉtwala ʉPaʉlo pɨ balaaza ɨlya bhamanyi lye bhakhatɨnjɨ Aleopago. Abhapɨtɨ abhɨ balaaza bhakhamʉbhʉʉzya bhakhatɨ, “Ɨmanyɨzyo impwa zɨnɨɨzyo zye ʉkʉbhabhʉʉzya abhantʉ, tʉbhʉʉzye nɨɨtwe. ");
INSERT INTO mgq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tuzyimvwizye kʉtɨ zya shɨkholo ishinji, tuyiganile kʉtɨ utwilulile zyenezyo.” ");
INSERT INTO mgq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bhálonjile shɨnɨɨsho, kʉnongwa ye abhantʉ abha kʉ Aseene, peeka na bhajeni abha kutali bhe bhakhɨkhalaga kʉnʉʉkwo, bhakhayɨganaga kʉtejeelezya bhʉʉlo ɨnongwa impwa, na kʉzɨlonga. ");
INSERT INTO mgq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pe ʉPaʉlo akhɨmɨɨlɨla mwɨ balaaza liila ɨlya Aleopago, akhatɨ, “Mʉbhasakhaala ɨmwe mʉbha mʉ Aseene! Ɨnkʉlola kʉtɨ mʉlemeleeye nhaani ɨnongwa zyonti ɨzya lupuuto. ");
INSERT INTO mgq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","We ɨnkʉshɨla mʉ nhaaya yɨnɨɨnɨ, nálolile she mukupuuta abhamʉlʉngʉ. Naashilolile nɨ shɨgemo ɨsha kufumwizya imfinjile she shisimbiilwe amazwi ge gakʉtɨ: KWA MɄLɄNGɄ WE ATAKɄMANYƗKHA. Wʉnʉʉyo ʉMʉlʉngʉ we mukupuuta sita kʉmʉmanya, we ɨne ɨnkwanza kʉbhalʉmbɨɨlɨla. ");
INSERT INTO mgq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“ɄMʉlʉngʉ wʉ Mwene ʉwa kʉmwanya na paasɨ, we ápelile ɨnsɨ, na vwonti vwe vɨlɨ mʉmwo. Ʉweene atakwɨkhala mu nyumba ɨzya kupuutila zye zɨkʉzengwa nɨ nyoobhe zya bhantʉ. ");
INSERT INTO mgq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Atakʉbhombelwa na bhantʉ ngatɨ akwanza khamu kʉkwabho. Ʉweene we akʉʉbhapa abhantʉ bhonti uwuumi na kʉtɨ bhafuutaje, khabhɨlɨ we akʉʉbhapa vwonti. ");
INSERT INTO mgq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kufumilana nu muntu weeka ápelile ɨvɨkholo vwonti ɨvwa bhantʉ, kʉtɨ bhasaate mʉ nsɨ zyonti. Akhabhabhɨɨshɨla akhabhalɨlo kufuma khalɨ, liino na pooshi pe bhatɨyɨkhalaje. ");
INSERT INTO mgq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ɄMʉlʉngʉ akhabhomba ganaago gonti, ɨnga abhantʉ bhamwanze, lumo bhangamufishila kwɨ dala ɨlya kʉpalamansya. Poope shɨnɨɨsho, atalɨ ukutali na wowonti. ");
INSERT INTO mgq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kʉnongwa ye mʉmwakwe mwe tʉkwɨkhala na kʉjendeelela kʉbha twe bhuumi.’ Anza she bhamu mu bhasimbi bhiinyu abhɨ nyɨmbo bhátɨlɨ, ‘Ɨtwe twe bhaana bhaakwe.’ ");
INSERT INTO mgq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kʉnongwa ye ɨtwe twe bhaana bha Mʉlʉngʉ, tʉtakwanzɨwa kukwina kʉtɨ ʉwʉmʉlʉngʉ waakwe wukholiine ni shifwani she bhagombile kʉ mbana iyi zahaabu, awe ɨyɨ nhela, awe ɨya mawe. Vɨnɨɨvwo ivifwani vɨkʉgombwa ku wumanyi wa bhantʉ bhʉʉlo. ");
INSERT INTO mgq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Palʉsalo, mʉ khabhalɨlo khe abhantʉ bhakhabhombaga zɨnɨɨzyo mʉ wʉlema, ʉMʉlʉngʉ áyibhiishile ngatɨ atakʉlola. Ɨleelo ishi akʉbhalajɨzya abhantʉ bhonti abha poponti paala kʉtɨ bhalaate. ");
INSERT INTO mgq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kʉnongwa ye abhiishile isiku lye akhayɨbhalonga abhantʉ bhonti mu wugolosu, kwɨ dala ɨlya muntu we amʉsabhʉʉye. ɄMʉlʉngʉ abhasimishiziizye bhonti zɨnɨɨzyo, kwɨ dala ɨlya kʉmʉzyʉsya wʉnʉʉyo umuntu mʉ bhafwe.” ");
INSERT INTO mgq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Abhapɨtɨ bhaala, we bhɨmvwa kʉtɨ ʉPaʉlo akʉlonga ɨzya kʉzyʉkha kʉ bhafwe, bhamu bhakhamʉshoolanya. Ɨleelo bhamu bhakhamʉbhʉʉzya bhakhatɨ, “Tʉkwanza kʉkʉtejeelezya winza kʉnongwa zɨnɨɨzyo.” ");
INSERT INTO mgq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pe ʉPaʉlo akhafuma mwɨ balaaza akhabhalekha. ");
INSERT INTO mgq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Abhantʉ bhamu bhakhamwɨtɨkha uYeesu, bhakhanda kʉmʉlandata ʉPaʉlo. Mʉ bhanaabho álɨɨpo uDionisiyo, ʉwa mwɨ balaaza ɨlya Aleopago, nʉ mwantanda weeka, ɨtaawa lyakwe wu Damali, peeka na bhantʉ abhanjɨ. ");
INSERT INTO mgq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","We zyashɨla zɨnɨɨzyo, ʉPaʉlo akhasogola mʉ Aseene, akhabhala mʉ nhaaya ɨya mu Kolinso. ");
INSERT INTO mgq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akhakhomaana nu Muyahuudi ʉmo, ɨtaawa lyakwe bhakhatɨnjɨ uAkiila, we ápapiilwe kʉ Ponto. UAkiila peeka nʉ mʉshɨ waakwe uPulisika bhaafumile shiniishi mʉ nhaaya ɨya mu Luumi mʉ nsɨ ɨya mu Itaaliya kʉnongwa ye ʉmwene uKilaudiyo álajiziizye kʉtɨ aBhayahuudi bhonti bhasogole mu Luumi. Pe ʉPaʉlo akhabhala kʉbhalamʉkha uAkiila nʉ mʉshɨ waakwe. ");
INSERT INTO mgq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kʉnongwa ye abheene bhakhabhombaga ɨmbombo ɨya kʉsona amaheema, ɨmbombo ye woope áyimanyile, akhanda kwɨkhala nabho, na kʉbhomba ɨmbombo yiila peeka. ");
INSERT INTO mgq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Isiku lyolyonti ɨlyɨ Sabaato, ʉPaʉlo akhinjilaga mwi sinagoogi, akhazabhanaga na Bhayahuudi na Bhayunaani, kʉtɨ lumo bhoope bhangɨɨtɨkha. ");
INSERT INTO mgq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","We ʉSɨɨla nu Tiimoti bhaafikha kufuma ku Makedoniya, ʉPaʉlo akhanda kʉmanyɨzya izwi lya Mʉlʉngʉ mʉ khabhalɨlo khaakwe khonti ku Bhayahuudi, akhafumwaga uwukeeti kʉtɨ uYeesu wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ɨleelo aBhayahuudi bhakhamʉkhaanaga na kumuliga ʉPaʉlo. Pe akhakunyunta amenda gaakwe, akhabhabhʉʉzya akhatɨ, “Ɨnga ʉMʉlʉngʉ abhafunda lwinyu mʉneemwe! Atalɨɨpo ʉwa kumbuna ɨne kwi zwi lɨnɨɨlyo. Kufuma ishi, ɨntɨbhale kʉbhalʉmbɨɨlɨla abhantʉ bhe te Bhayahuudi.” ");
INSERT INTO mgq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pe ʉPaʉlo akhasogola mwi sinagoogi, akhinjila mu nyumba ya muntu ʉmo we atáamɨle Muyahuudi, ɨleelo akhɨtɨkhaga ulupuuto ʉlwa Shiyahuudi, ɨtaawa lyakwe bhakhatɨnjɨ uTiito Yusito, we akhamupuutaga ʉMʉlʉngʉ. Mʉnʉʉmwo akhajendeelela kʉlʉmbɨɨlɨla intumi zya Mwene uYeesu. Inyumba yɨnɨɨyo yápalamiine ni sinagoogi. ");
INSERT INTO mgq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ʉmʉpɨtɨ uwi sinagoogi liila, we ɨtaawa lyakwe bhakhatɨnjɨ uKilisipo, akhamwɨtɨkha ʉMwene uYeesu, peeka na bhantʉ bhonti mu nyumba yaakwe. ABhakolinso abhinji we bhɨmvwa amazwi ga Paʉlo, bhoope bhakhagɨɨtɨkha, bhakhoozelwa. ");
INSERT INTO mgq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Isiku limo uwusiku, ʉMwene akhamʉbhʉʉzya ʉPaʉlo mu njozi ɨzya pamiiso amazelu akhatɨ, “Ʉtogopaje, ʉjendeelele kʉlʉmbɨɨlɨla, ʉtakhakhatampe, ");
INSERT INTO mgq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kʉnongwa ye ɨne ɨndɨ peeka nɨɨwe. Atalɨɨpo umuntu we angakubuda kʉtɨ akʉvwalazye, kʉnongwa ye mʉ nhaaya yɨnɨɨnɨ insebhile abhantʉ abhinji kʉbha bhalandati bhaanɨ.” ");
INSERT INTO mgq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pe ʉPaʉlo akhɨɨkhala ʉmwanha weeka na meezi ʉmʉtanda mu Kolinso, akhamanyɨzyaga abhantʉ izwi lya Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Akhabhalɨlo khe uGaliyo áamɨle mʉpɨtɨ wɨ nsɨ ɨya mʉ Akaaya, aBhayahuudi bhakhamubuda ʉPaʉlo kʉ mwoyo weeka. Bhakhamʉleeta pɨlongolela pa Galiyo ɨnga alongwe, ");
INSERT INTO mgq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bhakhatɨ, “Umuntu ʉnʉ akʉbhamanyɨzya abhantʉ kʉtɨ bhamupuutaje ʉMʉlʉngʉ kwɨ dala ilinji lye lɨkʉlegana nɨ ndajɨzyo zyɨtʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ɄPaʉlo we akʉtɨ alonje, uGaliyo akhabhabhʉʉzya aBhayahuudi akhatɨ, “Ɨmwe Bhayahuudi ɨnga mʉkʉmʉsɨtaaka umuntu ʉnʉ kʉnongwa ɨya wunanganyi, awe kʉnongwa ɨya wubhiibhi, naakhondeeye kʉbhatejeelezya. ");
INSERT INTO mgq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ɨleelo pe mʉkʉdalɨnhana ku mazwi, amataawa, nɨ ndajɨzyo zyinyu, mʉgamale mʉneemwe. Ɨne ɨntakwanza kʉbha ne mwamuli wa mazwi ganaaga.” ");
INSERT INTO mgq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pe uGaliyo akhalajɨzya kʉtɨ bhabhabhɨnje aBhayahuudi bhanaabho bhasogole pe akʉlonjela ɨnongwa. ");
INSERT INTO mgq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bhonti bhakhamubuda uSositeeni, ʉmʉpɨtɨ uwi sinagoogi, bhakhanda kʉmʉkhoma panzɨ pe akhalonjelaga ɨnongwa. Ɨleelo uGaliyo atázɨsajɨɨye ngakheeka zɨnɨɨzyo zye bhábhombile. ");
INSERT INTO mgq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ɄPaʉlo akhajendeelela kwɨkhala mu Kolinso insiku inyinji. Pɨlongolela, akhabhalaga abhamwabho mʉ lwɨtɨkho, akhabhala peeka nu Akiila nu Pulisika mʉ nhaaya ɨya mu Kenkileya. Abhantʉ bhamu bhakhamusyengula insisi kwi twe kʉmalɨɨlɨzya ulufingo, pe akhapanda imeeli ɨya kʉbhala ku Siiliya. ");
INSERT INTO mgq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","We bhaafikha mʉ Efeeso, ʉPaʉlo akhabhalekha uPulisika nu Akiila kʉtɨ bhɨkhalaje kʉnʉʉkwo. Akhinjila mwi sinagoogi, akhabhalʉmbɨlɨlaga aBhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pe bhakhamʉlaabha ʉPaʉlo kʉtɨ ayonjezye insiku ɨzya kwɨkhala kʉkwabho, ɨleelo akhakhaana. ");
INSERT INTO mgq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Akhabhalaga akhabhabhʉʉzya akhatɨ, “Ɨnga ʉMʉlʉngʉ ayɨgana, ɨnhayɨgalʉkha winza kukwinyu.” Pe akhasogola pa Efeeso ni meeli. ");
INSERT INTO mgq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","We ʉPaʉlo aafikha mu Kaisaliya, akhabhala ku Yelusaleemu kʉlamʉkha ɨvɨbhanza, pe akhabhala ku Antiokiya. ");
INSERT INTO mgq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","We ayɨɨkhala kʉ khabhalɨlo, akhasogola, akhashɨlɨla mu Galatiya, na mu Filigiya, akhabhagomwaga abhalandati bhonti. ");
INSERT INTO mgq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mʉ khabhalɨlo khanaakho, uMuyahuudi ʉmo, ɨtaawa lyakwe ʉApoolo, we ápapiilwe mʉ nhaaya ɨya ku Alekizandeeliya, akhɨnza mʉ Efeeso. Áamɨle mumanyi ʉwa kʉlonga, ámanyile nhaani uWusimbe uWufinjile. ");
INSERT INTO mgq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Umuntu wʉnʉʉyo bhámumanyiziizye palʉsalo ɨdala lya Mwene uYeesu, woope akhamanyɨzyaga abhantʉ ɨzya Yeesu ku wudandamazu mu wugolosu, she poope ámanyile ʉlwozyo ʉlwa Yookhani lwene. ");
INSERT INTO mgq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Akhinjila mwi sinagoogi, akhanda kʉmanyɨzya iNtumi iNyinza ku wudandamazu. UPulisika nu Akiila, we bhɨmvwa ɨmanyɨzyo zya Apoolo, bhakhamwega, bhakhabhala nawo kʉkwabho, bhakhamʉmanyɨzya ɨdala lɨnɨɨlyo ɨlya Mʉlʉngʉ ɨnga alɨmanye akhinza nhaani. ");
INSERT INTO mgq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pɨlongolela, ʉApoolo akhanzaga kufumiila ʉsʉmbɨ kʉbhala mʉ nsɨ ɨya mʉ Akaaya, abhamwabho mʉ lwɨtɨkho bhakhamujinjizya ʉmwoyo. Bhakhabhasimbila ɨkalaata abhalandati abhamwabho abha mʉ Akaaya kʉtɨ bhamʉposheele akhinza. We aafikha kuula, akhabhaavwa nhaani bhe bhámwitishile uYeesu ku wiila wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Akhabhatolaga aBhayahuudi ku wudandamazu pa mbɨmbɨlɨ ya bhantʉ, kwɨ dala ɨlya kubhasimishizya nu Wusimbe uWufinjile kʉtɨ uYeesu wu Kilisiti. ");
INSERT INTO mgq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kʉ khabhalɨlo khanaakho khe ʉApoolo áamɨle pa Kolinso, ʉPaʉlo woope akhashʉʉlaga mʉ nsɨ ɨya mu Asiya, akhafikha mʉ Efeeso. We alɨ pa Efeeso, akhakhomaana na bhalandati bha Yeesu bhamu, ");
INSERT INTO mgq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","akhabhabhʉzɨɨlɨzya akhatɨ, “We mwamwɨtɨkha uYeesu, bhʉlɨ, mwámʉposheleeye uMupepu uMufinjile?” Bhakhamwamʉla bhakhatɨ, “Ndaali, poope na kwɨmvwa kʉtɨ alɨɨpo, tutimvwizye naalumo.” ");
INSERT INTO mgq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Akhabhabhʉzɨɨlɨzya akhatɨ, “Ishi, mwózeliilwe kʉ lwozyo lwoni?” Bhakhamwamʉla bhakhatɨ, “Twózeliilwe kʉ lwozyo ʉlwa Yookhani.” ");
INSERT INTO mgq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ɄPaʉlo akhabhabhʉʉzya akhatɨ, “UYookhani akhabhozyaga abhantʉ kʉlolesya kʉtɨ bhalaatile imbiibhi zyabho. Akhabhabhʉzyaga kʉtɨ bhamwɨtɨshe we atɨlandate kʉlʉsalo kʉkwakwe, we wu Yeesu.” ");
INSERT INTO mgq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Abhantʉ bhaala, we bhɨmvwa ganaago amazwi, bhoope bhakhoozelwa kwɨ taawa lya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ɄPaʉlo we abhabhɨɨshɨla ɨnyoobhe, uMupepu uMufinjile akhabhiishila, bhakhanda kʉlonga kʉ ndongo izinji, na kufumwa uwukuwi. ");
INSERT INTO mgq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Abhantʉ bháfishiiye abhasakhaala ishumi na bhabhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kʉ khabhalɨlo akha meezi gatatʉ, ʉPaʉlo akhinjilaga mwi sinagoogi, akhalongaga na bhantʉ ku wudandamazu we akʉzaabhana nabho kʉtɨ bhɨɨtɨshe ɨzya wʉmwene wa Mʉlʉngʉ. ");
INSERT INTO mgq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ɨleelo bhamu bhakhakhaana kwɨtɨkha, bhakhanda kuziliga ɨmanyɨzyo ɨzyɨ Dala lya Mwene uYeesu pa mbɨmbɨlɨ ya bhantʉ. Pe ʉPaʉlo akhabhalekha, akhabheega abhalandati, akhamanyɨzyaga insiku zyonti mu nyumba ɨya kʉmanyɨɨlɨla ye yáamɨle ya muntu we bhakhatɨnjɨ uTilano. ");
INSERT INTO mgq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ɄPaʉlo akhajendeelela kʉbhomba shɨnɨɨsho kʉ manha gabhɨlɨ, pe bhonti bhe bhakhɨkhalaga mʉ nsɨ ɨya mu Asiya, aBhayahuudi peeka na Bhayunaani bhakhɨmvwa intumi zya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ɄMʉlʉngʉ akhabhombaga amayele amapɨtɨ kʉshɨlɨla kwa Paʉlo. ");
INSERT INTO mgq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Abhantʉ bhakheegaga ɨvɨtambaala na menda aganjɨ agɨ mbombo ge ʉPaʉlo álemile, bhakhagatwalaga ku bhabhinu, bhakhaponaga uwubhinu waabho, khabhɨlɨ amapepu amabhiibhi gakhabhafumaga. ");
INSERT INTO mgq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Páamɨle na Bhayahuudi bhamu bhe bhakhajendangaga uku nʉʉkwo, kʉbhɨnga amapepu amabhiibhi mʉ bhantʉ. Bhakhabhombelaga ɨtaawa lya Mwene uYeesu kʉgabhʉʉzya amapepu amabhiibhi kʉtɨ, “Kwɨ taawa lya Yeesu we ʉPaʉlo akʉmʉlʉmbɨɨlɨla, ɨnkʉbhabhʉʉzya kʉtɨ, mufume mwa muntu ʉnʉ.” ");
INSERT INTO mgq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhamu bhe bhakhabhombaga shɨnɨɨsho bháamɨle bhavʉlɨ saba abha muntu we bhakhatɨnjɨ uSikeewa, weeka mʉ bhapɨtɨ bha bhapuutili abha Bhayahuudi. ");
INSERT INTO mgq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɨleelo isiku limo, ipepu ibhiibhi lɨkhabhaamʉla lɨkhatɨ, “Imumanyile uYeesu, imumanyile nʉ Paʉlo, ɨleelo ɨmwe mwe bhanaanu?” ");
INSERT INTO mgq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pe umuntu ʉla we ipepu ibhiibhi lyámulemile akhabhatomoshela bhonti, akhabhatola amakha. Akhabhakhoma nhaani, bhakhashɨmbɨla, bhakhafuma mu nyumba bhalɨ shitali, na mabhamba mʉ mʉbhɨlɨ. ");
INSERT INTO mgq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ɨnongwa zɨnɨɨzyo zɨkhamanyɨkha nhaani ku Bhayahuudi na Bhayunaani bhonti bhe bhakhɨkhalaga pa Efeeso. Bhonti ɨlyoga lɨkhabhalema, bhakhalɨpaala ɨtaawa lya Mwene uYeesu. ");
INSERT INTO mgq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abhantʉ abhinji bhe bhámwitishile uYeesu bhakhalaata pɨlongolela pa bhantʉ imbiibhi zyabho zye bhábhombile. ");
INSERT INTO mgq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mʉ bhanaabho, bhálɨɨpo abhinji bhe bhakhabhombaga amayele aga wʉganga. Bhakhaleeta ivitaabu vwabho vwe bhakhabhombelaga amayele, bhakhavɨpemba mʉ mwoto pɨlongolela pa bhantʉ bhonti. We bhabhaazya ibeeyi ɨya vitaabu viila, bhakhaaga vikufisya ɨnhela ɨnsabhaazya ielufu amashumi gasaanʉ (50,000) kʉ nhela yaabho. ");
INSERT INTO mgq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Shɨnɨɨsho she intumi zya Mwene uYeesu zɨkhasaata mʉ bhantʉ, na kwonjela kʉbha na makha. ");
INSERT INTO mgq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","We zyashɨla zɨnɨɨzyo zyonti, ʉPaʉlo akhasɨɨbha kʉtɨ abhale ku Yelusaleemu kʉshɨlɨla mu Makedoniya, na mʉ Akaaya. Akhalonga akhatɨ, “We naafikha mu Yelusaleemu, yɨkʉtɨ imfishe na mu Luumi.” ");
INSERT INTO mgq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pe akhabhasonteelezya abhantʉ bhabhɨlɨ mʉ bhaala bhe bhakhamwavwaga, uTiimoti nu Elaasito, kʉtɨ bhalongolele kʉbhala ku Makedoniya, ʉweene akhasyala mu Asiya kʉ khabhalɨl