﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgj_vpl;
CREATE TABLE mgj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgj_vpl WRITE;
INSERT INTO mgj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Od̠ud̠ul wa̠ u̠ge̠ ugboloma̠ ma̠ eghun wa̠ A̠zizo̠s Akrai̠st, o̠nyi̠ ta̠ A̠devidi, o̠nyi̠ ta̠ Ebraham a̠mite bho̠: ");
INSERT INTO mgj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham amar Azi̠ki̠; sa̠ Azi̠ki̠ amar A̠zeko̠pu̠; sa̠ A̠zeko̠pu̠ amar A̠zuda̠ na̠ a̠rumor d̠o̠yo̠; ");
INSERT INTO mgj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","sa̠ A̠zuda̠ amar Ape̠re̠z na̠ Aze̠ra, wa̠ onweni d̠awa aro̠ ma̠ Atama bho̠; sa̠ Ape̠re̠z amar E̠zro̠n; sa̠ E̠zro̠n amar Aram; ");
INSERT INTO mgj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","sa̠ Aram amar Ami̠nadab; sa̠ Ami̠nadab amar Anaso̠n; sa̠ Anaso̠n amar Asalmo̠n; ");
INSERT INTO mgj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","sa̠ Asalmo̠n amar A̠boa̠z wa̠ onweni bho̠ aro̠ ma̠ A̠rehab bho̠; sa̠ A̠boa̠z amar Obe̠di̠, wa̠ onweni bho̠ aro̠ ma̠ A̠rufu bho̠; sa̠ Obe̠di̠ amar Aze̠si̠; ");
INSERT INTO mgj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","sa̠ Aze̠si̠ amar O̠li̠le̠ma A̠devidi; sa̠ A̠devidi amar Aso̠lo̠mo̠n, wa̠ onweni bho̠ aro̠ ma̠ ani̠ ta̠ A̠yuraya bho̠; ");
INSERT INTO mgj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","sa̠ Aso̠lo̠mo̠n amar A̠rihoboa̠m; sa̠ A̠rihoboa̠m amar Abi̠za; sa̠ Abi̠za amar Asaf; ");
INSERT INTO mgj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","sa̠ Asaf amar A̠zehosafat; sa̠ A̠zehosafat amar A̠zoram; sa̠ A̠zoram amar Uzaya; ");
INSERT INTO mgj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","sa̠ Uzaya amar A̠zotam; sa̠ A̠zotam amar Ahaz; sa̠ Ahaz amar E̠zi̠kaya; ");
INSERT INTO mgj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","sa̠ E̠zi̠kaya amar Amanase̠; sa̠ Amanase̠ amar Amo̠n; sa̠ Amo̠n amar A̠zosaya; ");
INSERT INTO mgj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","sa̠ A̠zosaya amar A̠zekonaya na̠ a̠rumor d̠o̠yo̠ d̠a̠ igiel wa̠ ub̠ol awa ka̠ id̠ighom d̠a̠ Ababi̠lo̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Igiel wa̠ na̠ ed̠ighom awa d̠a̠ Ababi̠lo̠n bho̠, sa̠ A̠zekonaya amar A̠seti̠e̠l; sa̠ A̠seti̠e̠l amar A̠zerubabe̠l; ");
INSERT INTO mgj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","sa̠ A̠zerubabe̠l amar Abihud; sa̠ Abihud amar E̠li̠aki̠m; sa̠ E̠li̠aki̠m amar Azo̠; ");
INSERT INTO mgj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","sa̠ Azo̠ amar Azado̠k; sa̠ Azado̠k amar Aki̠m; sa̠ Aki̠m amar E̠li̠ud; ");
INSERT INTO mgj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","sa̠ E̠li̠ud amar E̠li̠aza; sa̠ E̠li̠aza amar Amatan; sa̠ Amatan amar A̠zeko̠pu̠; ");
INSERT INTO mgj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","sa̠ A̠zeko̠pu̠ amar A̠zose̠fu̠ owolom ta̠ A̠meri, wa̠ amar A̠zizo̠s wa̠ ubhelegi ma̠ Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","O̠ku̠a bha̠ eb̠la̠ ramu̠m bho̠, obeton d̠a̠ Ebraham ka̠ o̠te̠i̠ d̠a̠ A̠devidi, bha̠ d̠iobh na̠ inya̠ amu̠m; ya̠a̠ obeton d̠a̠ A̠devidi ka̠ o̠te̠i̠ d̠a̠ igiel e̠d̠u̠a Ababi̠lo̠n bho̠, bha̠ d̠iobh na̠ inya̠ amu̠m; ya̠a̠ ob̠eton igiel e̠d̠u̠a Ababi̠lo̠n bho̠ ka̠ o̠te̠i̠ igiel ta̠ Akrai̠st, bha̠ d̠iobh na̠ inya̠ amu̠m. ");
INSERT INTO mgj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Onon agu̠o̠ ubhin u̠mar A̠zizo̠s Akrai̠st bho̠. A̠zose̠fu̠ a̠sibh A̠meri, onweni D̠o̠yo̠ ma̠ obhin ani̠, ya̠a̠ kisa̠ awa ta̠ eten otu bha̠ A̠meri na̠ a̠mumor o̠nyi̠ ola̠ awo̠l d̠a̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Agu̠o̠ A̠zose̠fu̠ owolom d̠o̠yo̠ aro̠ ma̠ a̠ga̠i o̠ni̠ bho̠, ya̠a̠ o̠bho̠ro̠ghan d̠o̠ ma̠ a̠nwunom o̠ko̠ro̠ A̠meri bho̠, sa̠ aru̠ru̠an ogbogina̠ o̠yo̠ d̠a̠ e̠nwo̠ngi̠na. ");
INSERT INTO mgj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Agu̠o̠ i̠na a̠bhin a̠d̠ighom d̠a̠ i̠ru̠an bho̠, sa̠ otileduom ta̠ Wa̠nwuna̠ a̠mutuma̠ i̠na d̠a̠ amala, a̠fugh ma̠a̠, “A̠zose̠fu̠ o̠nyi̠ ta̠ A̠devidi, ka̠ oghil obhin A̠meri ma̠ o̠ro̠ ani̠ d̠oyom, ezin bho̠ eghun wa̠ i̠na a̠mumor bho̠ awo̠l d̠a̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I̠na ta̠ amar olobhiri o̠nyi̠, sa̠ anwa ta̠ a̠ghol a̠d̠ien d̠o̠yo̠ ma̠ A̠zizo̠s, ezin bho̠ i̠na ta̠ a̠tenemeni ma̠ a̠nwunom d̠o̠yo̠ d̠a̠ i̠karabh d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Eb̠la̠ i̠nye̠n imite ma̠ agu̠o̠ ola̠ omuzoghod̠iom i̠di̠ar ya̠ Wa̠nwuna̠ bho̠ awo̠l d̠a̠ owil bho̠ a̠fugh ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“I̠bi̠ghe̠! E̠kar o̠nyani̠ ta̠ a̠mumor amar olobhiri o̠nyi̠, sa̠ ta̠ oghol I̠na ma̠ I̠manu̠e̠l” (a̠ma̠ra̠ ma̠a̠, “A̠zib̠a̠ od̠i na̠ i̠yar”). ");
INSERT INTO mgj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Igiel wa̠ A̠zose̠fu̠ asu̠ma bho̠, sa̠ a̠gir agu̠o̠ otileduom ta̠ Wa̠nwuna̠ a̠ruom i̠na bho̠ sa̠ a̠bhin ani̠ d̠o̠yo̠ a̠yel. ");
INSERT INTO mgj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ya̠a̠ i̠na na̠ okod̠uom d̠o̠ ma̠ A̠meri tu̠tu̠n amar o̠nyi̠ bho̠, sa̠ a̠ghol a̠d̠ien D̠o̠yo̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Igiel wa̠ u̠mar A̠zizo̠s, d̠a̠ Abe̠ti̠li̠he̠m wa̠ od̠i d̠a̠ A̠zudia̠ bho̠, bha̠ a̠sora̠n igiel wa̠ E̠ro̠d aro̠ ma̠ o̠li̠le̠ma bho̠, sa̠ iloghodi̠ar i̠d̠u̠a d̠a̠ agba opuomite ogogo bho̠ iru d̠a̠ A̠zeruse̠le̠m, ");
INSERT INTO mgj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sa̠ ipura̠n ma̠a̠: “Od̠i d̠a̠ a̠ken O̠li̠le̠ma A̠zu wa̠ u̠mar bho̠? I̠yar u̠bi̠gh e̠ni̠nai̠ny D̠o̠yo̠ ma̠ igiel wa̠ a̠b̠etina̠ bho̠ sa̠ i̠yar uru ra̠ okpud̠ia̠n onigha̠ o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Igiel bho̠ E̠ro̠d amu̠gho̠n bho̠, sa̠ abar bho̠ a̠nyegi i̠na na̠ eb̠la̠ A̠zeruse̠le̠m. ");
INSERT INTO mgj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sa̠ a̠kokod̠i ma̠ eb̠la̠ ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ sa̠ a̠pura̠n ma̠a̠, “Ta̠ o̠mar Akrai̠st bho̠ d̠a̠ a̠ken?” ");
INSERT INTO mgj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sa̠ awa i̠wo̠ran i̠na ma̠a̠: “D̠a̠ Abe̠ti̠li̠he̠m wa̠ od̠i d̠a̠ A̠zudia̠ bho̠, ezin bho̠ owil bho̠ age̠ ma̠ o̠ko̠no̠n a̠guri: ");
INSERT INTO mgj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Anwa Abe̠ti̠li̠he̠m wa̠ od̠i d̠a̠ ebhugh A̠zuda̠ bho̠, anwa i̠ki̠r a̠pu d̠a̠ ogbo irileghom ya̠ od̠i d̠a̠ A̠zuda̠ bho̠, ku̠ku̠m eka̠, o̠ni̠ irileghom ta̠ ad̠u̠a d̠a̠ oyom a̠mite, ma̠ ola̠ ta̠ a̠rileghom a̠nwunom D̠ami̠, Izre̠l.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sa̠ E̠ro̠d a̠bhelegi ma̠ iloghodi̠ar bho̠ d̠a̠ e̠wo̠gi̠na a̠pura̠n a̠loghom a̠ga̠i obhel wa̠ e̠ni̠nai̠ny bho̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sa̠ a̠ruom awa ma̠a̠: “I̠gi̠e̠ d̠a̠ Abe̠ti̠li̠he̠m ka̠ e̠mar epura̠n egboloma̠ ma̠ O̠nyi̠ bho̠. Ka̠ inyin u̠bi̠gh, bha̠ id̠ighi ma̠ agu̠o̠ ola̠ ami̠ ta̠ a̠loghom epa̠, b̠o̠ka̠ ami̠ agi̠ ani̠ ka̠ a̠kpud̠ia̠n I̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Awa i̠mu̠gho̠n a̠fugh ta̠ O̠li̠le̠ma bho̠ i̠we̠le̠, sa̠ agu̠o̠ awa na̠ e̠d̠u̠a bho̠, sa̠ e̠ni̠nai̠ny wa̠ awa i̠bi̠gh d̠a̠ opuomite ogogo bho̠ a̠mite d̠a̠ ed̠ia̠ d̠a̠ awa sa̠ awa i̠tu̠o̠no̠m tu̠tu̠n ka̠ amara d̠a̠ anyu̠ esi wa̠ O̠nyi̠ bho̠ od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sa̠ obhel bho̠ awa i̠bi̠gh e̠ni̠nai̠ny bho̠ sa̠ awa ibhon ologi ma̠ ibom. ");
INSERT INTO mgj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sa̠ awa id̠igh d̠a̠ otu bho̠ ka̠ i̠bi̠gh O̠nyi̠ bho̠ na̠ A̠meri onweni bho̠, sa̠ ikpud̠ia̠n I̠na, sa̠ ikpegion a̠rigba̠ i̠di̠ar edim d̠awa inigha̠ I̠na ma̠ e̠ne̠ghe̠: a̠gol na̠ afraki̠nse̠ns na̠ amaya. ");
INSERT INTO mgj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sa̠ awa i̠wo̠l opa̠n eten imula̠ iyel d̠a̠ ebhugh d̠awa, ezin bho̠ ukikiom awa d̠a̠ amala ma̠a̠ awa omula̠ d̠o̠ e̠gi̠ d̠a̠ E̠ro̠d. ");
INSERT INTO mgj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Agu̠o̠ awa i̠d̠u̠a bho̠, sa̠ otileduom ta̠ Wa̠nwuna̠ a̠mutuma̠ ma̠ A̠zose̠fu̠ d̠a̠ amala a̠fugh ma̠a̠: “B̠etina̠ ma̠ a̠bhin O̠nyi̠ bho̠ na̠ onweni D̠o̠yo̠ ma̠ anu̠r agi̠ d̠a̠ Izipt ka̠ aro̠, tu̠tu̠n anwa ta̠ a̠mula̠ amu̠gho̠n d̠a̠ o̠nu̠ d̠ami̠, ezin bho̠ E̠ro̠d ta̠ abho̠ro̠gh O̠nyi̠ bho̠ ma̠ ogigh.” ");
INSERT INTO mgj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sa̠ i̠na a̠b̠etina̠ epa̠, a̠bhin O̠nyi̠ bho̠ na̠ onweni D̠o̠yo̠ ma̠ a̠d̠ugula̠n obha̠ ad̠u̠a agi̠ d̠a̠ Izipt. ");
INSERT INTO mgj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sa̠ awa i̠ro̠ ma̠ i̠se̠ tu̠tu̠n E̠ro̠d a̠mugh, ma̠ agu̠o̠ ola̠ omuzoghod̠iom a̠fugh ta̠ Wa̠nwuna̠ bho̠ wa̠ awo̠l d̠a̠ owil a̠fugh ma̠a̠: “Ami̠ ibhelegi ma̠ O̠nyi̠ D̠ami̠ d̠a̠ Izipt a̠mutiom.” ");
INSERT INTO mgj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Igiel bho̠ E̠ro̠d abi̠gh ma̠ iloghodi̠ar bho̠ na̠ egelemeni i̠na bho̠, sa̠ ologi do̠yo̠ a̠gurom, sa̠ ato̠ ma̠ a̠nwunom ma̠ o̠gi̠ ka̠ o̠ze̠gi̠ eb̠la̠ i̠gbara ilobhiri anwi̠i̠ny d̠a̠ Abe̠ti̠li̠he̠m na̠ eb̠la̠ eghighira̠ bho̠, ya̠ na̠ ed̠um i̠wal ala ma̠ obhin osor, ma̠ agu̠o̠ ola̠ ta̠ a̠sora̠n a̠ga̠i obhel wa̠ iloghodi̠ar bho̠ i̠gba inigha̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Onon agu̠o̠ ubhin umuzoghod̠iom iwowa̠ ya̠ owil A̠zerimaya a̠wa̠ bho̠, ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“U̠mu̠gho̠n o̠gba igbir d̠a̠ Arama, ed̠i na̠ i̠kparakpar ifinigha̠, A̠rese̠l na̠ a̠leghe ma̠ anwi̠i̠ny d̠o̠yo̠, ma̠ ola̠ na̠ o̠le̠gh i̠na tu̠tu̠n ya̠a̠ i̠na na̠ onima̠ d̠o̠, ezin bho̠ awa na̠ emugughu.” ");
INSERT INTO mgj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Igiel bho̠ E̠ro̠d a̠mugh bho̠, sa̠ otileduom ta̠ Wa̠nwuna̠ a̠mutuma̠ ma̠ A̠zose̠fu̠ d̠a̠ amala d̠a̠ Izipt ");
INSERT INTO mgj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a̠fugh ma̠a̠: “B̠etina̠ ma̠ a̠bhin O̠nyi̠ bho̠ na̠ onweni D̠o̠yo̠ ma̠ agi̠ d̠a̠ ebhugh Izre̠l, ezin bho̠ ogbo ya̠ na̠ eku ma̠ a̠ghud̠um O̠nyi̠ bho̠ na̠ emugh.” ");
INSERT INTO mgj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","O̠ku̠a sa̠ i̠na a̠b̠etina̠ a̠bhin O̠nyi̠ bho̠ na̠ onweni bho̠ agi̠ d̠a̠ ebhugh Izre̠l. ");
INSERT INTO mgj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ya̠a̠ agu̠o̠ i̠na amu̠gho̠n ma̠a̠ Ake̠lo̠s o̠nyi̠ ta̠ E̠ro̠d na̠ a̠rileghom A̠zudia̠ bho̠, sa̠ i̠na a̠ghil o̠gi̠ i̠se̠, sa̠ ukikiom i̠na d̠a̠ amala ma̠ o̠gi̠ d̠a̠ agba Agalili. ");
INSERT INTO mgj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sa̠ i̠na agi̠ ka̠ a̠rugh d̠a̠ e̠ma ola̠ ubhelegi ma̠ Anazare̠t, ma̠ omuzoghod̠iom i̠di̠ar ya̠ u̠wo̠l d̠a̠ owil bho̠ u̠gba ma̠a̠: “Ta̠ obhelegi I̠na ma̠a̠ ola̠ Anazare̠t.” ");
INSERT INTO mgj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","D̠a̠ igiel bho̠ Azo̠n owurmamu̠m bho̠ a̠ru bho̠, sa̠ i̠na agi̠ d̠a̠ e̠ghana A̠zudia̠ ka̠ agba ma̠ ib̠eb̠i asu̠gbagba bho̠ ");
INSERT INTO mgj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma̠a̠: “Itiba̠ra̠ d̠a̠ i̠karabh d̠inyin, ezin bho̠ irileghom ote̠nai̠ny na̠ a̠tua̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Onon bha̠ o̠ni̠ wa̠ owil Azaya agba a̠gboloma̠ bho̠ ma̠a̠: “Okoroko na̠ a̠si na̠ a̠mite d̠a̠ e̠ghana bho̠, na̠ agba ma̠a̠, ‘I̠tu̠ghu̠mane̠ ma̠ eten ta̠ Wa̠nwuna̠ bho̠, ma̠ eselegi ma̠ reten d̠o̠yo̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A̠rukpe ibura̠ ta̠ Azo̠n, bha̠ ubhin ipur e̠nam a̠dol o̠le̠m, sa̠ i̠na akpo̠aghan o̠kara ozu e̠nam a̠kitineni ma̠ ekika̠gh d̠o̠yo̠. Ed̠ia̠n d̠o̠yo̠ bha̠ i̠ganw na̠ ame̠ ya̠ od̠id̠ia̠ d̠a̠ aparapa. ");
INSERT INTO mgj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Igiel obha̠, sa̠ eb̠la̠ A̠zeruse̠le̠m na̠ A̠zudia̠ na̠ ogbo ya̠ na̠ erugh d̠a̠ eghighira̠ Azo̠dan id̠u i̠gi̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sa̠ i̠na a̠wur awa ma̠ amu̠m d̠a̠ o̠bhi̠i̠y Azo̠dan, agu̠o̠ awa iloghoma̠n i̠karabh d̠awa sa̠ i̠gba imutiom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa̠ agu̠o̠ i̠na abi̠gh o̠lo̠gh Rafarisi na̠ Rasadusi na̠ eru ra̠ owura̠ amu̠m bho̠, sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠: “Inyin anwi̠i̠ny i̠bho̠ru̠bho̠ru̠ i̠karabh i̠di̠ar, a̠nyen a̠kikiom inyin oghil o̠d̠u̠a d̠a̠ ibom i̠gam ta̠ A̠zib̠a̠ wa̠ na̠ a̠ru bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, imume ma̠ itu ya̠ ta̠ eleriom ma̠a̠ inyin na̠ otiba̠ra̠ d̠a̠ i̠karabh d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ya̠a̠, o̠ni̠ ko o̠ru̠ru̠an ma̠ e̠re̠ma d̠a̠ rologi d̠inyin ma̠a̠, ‘I̠yar onwuna̠ ma̠ obom o̠we̠de̠ Ebraham.’ Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, A̠zib̠a̠ ta̠ a̠rue a̠bhin ikputu i̠nye̠n a̠tenemeni ma̠ anwi̠i̠ny a̠nigha̠ ma̠ Ebraham. ");
INSERT INTO mgj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","I̠se̠n, na̠ ologhom oguri ma̠ u̠do̠ d̠a̠ igbolo iriren bho̠, ma̠ agu̠o̠ ola̠ kerekere oriren ola̠ omum d̠o̠ ma̠ ib̠eb̠i imuma̠, ta̠ ogu okoton, orobh o̠lo̠gh d̠a̠ anya.” ");
INSERT INTO mgj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ya̠ga̠i, ami̠ na̠ a̠wur inyin amu̠m ma̠ oleriom ma̠a̠ inyin na̠ otiba̠ra̠ d̠a̠ i̠karabh d̠inyin, ya̠a̠ o̠ni̠ ola̠ a̠pu ami̠ na̠ a̠ru ma̠ ola̠ ami̠ olei d̠o̠ ma̠ o̠ko̠gi̠o̠n id̠id̠igh agbaka d̠o̠yo̠. I̠na ta̠ a̠bhin E̠mu̠gh E̠tu̠tu̠ bho̠ na̠ anya a̠wur inyin. ");
INSERT INTO mgj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I̠na na̠ a̠sibh okporoma̠ d̠o̠yo̠ d̠a̠ agu̠o̠, ma̠ obhin o̠b̠i̠r o̠si̠ d̠o̠yo̠ okokod̠i ikpo ed̠ia̠n d̠o̠yo̠ od̠ighom d̠a̠ esi eko bho̠, ya̠a̠ ta̠ anu̠o̠me̠ni̠ ma̠ ibhobho bho̠ d̠a̠ anya ola̠ ka̠ od̠im d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","D̠a̠ igiel obha̠ sa̠ A̠zizo̠s ad̠u̠a d̠a̠ Agalili agi̠ d̠a̠ o̠bhi̠i̠y Azo̠dan ka̠ ate̠i̠ Azo̠n owur o̠yo̠ amu̠m. ");
INSERT INTO mgj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ya̠a̠ Azo̠n na̠ o̠bho̠ro̠ghan d̠o̠ ma̠ ogir o̠ku̠a, sa̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Akpe̠ ku ma̠ anwa ma̠ owur ami̠, bha̠ anwa na̠ a̠ru ku d̠ami̠ ma̠ owur oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ya̠a̠, A̠zizo̠s awo̠ran i̠na ma̠a̠: “Ma̠ra̠ aro̠ ma̠ o̠ku̠a ma̠ i̠se̠n ma̠ agu̠o̠ ola̠ ta̠ omuzoghod̠iom agu̠o̠ a̠sora̠n o̠ro̠ bho̠.” Sa̠ Azo̠n a̠ma̠ra̠ a̠gir o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Azo̠n owur A̠zizo̠s amu̠m o̠we̠le̠ ku̠ku̠m, sa̠ agu̠o̠ i̠na na̠ a̠bhun bho̠ sa̠ ote̠nai̠ny bho̠ a̠gurona̠ sa̠ i̠na abi̠gh ka̠ E̠mu̠gh ta̠ A̠zib̠a̠ a̠sor akpasan i̠na ka̠ ukpugh osege. ");
INSERT INTO mgj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sa̠ okoroko a̠si a̠mite d̠a̠ ote̠nai̠ny ma̠a̠: “Onon o̠nyi̠ d̠ami̠, wa̠ ami̠ itula̠n ibom bho̠, wa̠ ami̠ na̠ a̠bhon ologi na̠ a̠gboloma̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","D̠a̠ obhel obha̠, sa̠ E̠mu̠gh bho̠ a̠rileghom A̠zizo̠s agi̠ d̠a̠ e̠ghana ma̠ eru bho̠ ma̠ o̠d̠agi̠an O̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sa̠ i̠na a̠ne ma̠ o̠ko̠i̠ tu̠tu̠n eruba̠l a̠d̠uga̠la̠n na̠ etita̠n, sa̠ o̠ko̠i̠ a̠d̠ighi i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sa̠ o̠ni̠ ad̠agi̠an bho̠ a̠ru ra̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Agu̠o̠ anwa i̠ro̠ ma̠ o̠nyi̠ ta̠ A̠zib̠a̠ bho̠, bha̠ ruome ma̠ ikpo i̠gbaki̠ghe̠ i̠nye̠n etenegia̠n ed̠ia̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sa̠ A̠zizo̠s awo̠ran ma̠a̠: “Na̠ o̠ge̠ oguri ma̠a̠: ‘O̠nyi̠o̠mo̠ro̠ni̠ ko obhin d̠o̠ d̠a̠ od̠e ed̠ia̠n ku̠ku̠m a̠d̠um, ya̠a̠ d̠a̠ eb̠la̠ ikpo a̠fugh ya̠ na̠ emite d̠a̠ o̠nu̠ ta̠ A̠zib̠a̠.’” ");
INSERT INTO mgj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","O̠tu̠o̠no̠m i̠se̠, sa̠ eru bho̠ a̠bhin i̠na agi̠ d̠a̠ e̠ma e̠tu̠tu̠ bho̠ ka̠ amarame̠ni̠ d̠a̠ asi̠kaka otu ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","sa̠ eru bho̠ a̠fugh a̠nigha̠ I̠na ma̠a̠: “Agu̠o̠ anwa i̠ro̠ ma̠ o̠nyi̠ ta̠ A̠zib̠a̠ bho̠, bha̠ pele ma̠ a̠sor. Ezin bho̠, na̠ o̠ge̠ oguri ma̠a̠: “ ‘I̠na ta̠ a̠ruom itileduom bho̠ ma̠ okponom Oyom, sa̠ ta̠ e̠su̠ar anwa d̠a̠ aru̠gu̠o̠ d̠awa, b̠o̠ka̠ anwa na̠ od̠ighia̠nma̠ ma̠ a̠wel d̠a̠ o̠gbaki̠ghe̠.’” ");
INSERT INTO mgj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠: “Na̠ o̠ge̠ oguri nyen ma̠a̠: ‘Ko o̠d̠agi̠an Wa̠nwuna̠ A̠zib̠a̠ d̠oyom!’” ");
INSERT INTO mgj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","D̠a̠ o̠tu̠o̠no̠m i̠se̠, sa̠ eru bho̠ a̠bhin I̠na agi̠ d̠a̠ anyu̠ igu ola̠ amar agi̠ ma̠ anyu̠ sa̠ atu̠o̠gho̠m a̠leriom I̠na ma̠ eb̠la̠ ra̠dila̠de irileghom e̠mara̠nwunom bho̠ na̠ isosorogia̠n d̠awa, ");
INSERT INTO mgj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sa̠ a̠fugh a̠nigha̠ I̠na ma̠a̠: “Ami̠ ta̠ a̠nigha̠ Nyam eb̠la̠ i̠di̠ar i̠nye̠n, ka̠ Anwa ikpud̠ia̠n i̠ko̠l ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sa̠ A̠zizo̠s awo̠ran ma̠a̠: “Eru, tene ma̠ ad̠u̠a! Na̠ o̠ge̠ oguri ma̠a̠: ‘Ko̠le̠ ma̠ Wa̠nwuna̠ A̠zib̠a̠ d̠oyom ma̠ a̠gir a̠nigha̠ I̠na ku̠ku̠m.’” ");
INSERT INTO mgj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sa̠ eru bho̠ a̠ten ad̠u̠a. I̠se̠ d̠a̠ onin obhel bho̠, sa̠ itileduom ta̠ A̠zib̠a̠ iru ra̠ i̠lo̠gh agu̠o̠ inigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Igiel bho̠ u̠gba unigha̠ I̠na ma̠ na̠ o̠d̠u̠o̠m Azo̠n d̠a̠ ikoli bho̠, sa̠ I̠na ad̠u̠a agi̠ d̠a̠ Agalili. ");
INSERT INTO mgj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sa̠ i̠na awe̠le̠ ma̠ Anazare̠t agi̠ ka̠ a̠rugh d̠a̠ Akapanu̠m d̠a̠ aka abadi̠ d̠a̠ ebhugh Aze̠bu̠lo̠n na̠ Anaftalai̠, ");
INSERT INTO mgj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ma̠ agu̠o̠ ola̠ omuzoghod̠iom iwowa̠ ta̠ owil Azaya ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ebhugh Aze̠bu̠lo̠n na̠ ebhugh Anaftalai̠, d̠a̠ akagara esoroma̠ abadi̠ wa̠ d̠a̠ aku̠b̠o̠ Azo̠dan bho̠, Agalili esi wa̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu na̠ erugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","A̠nwunom ya̠ na̠ erugh d̠a̠ azi̠m bho̠, na̠ e̠bi̠gh e̠b̠alab̠al ola̠ na̠ awar ibom. Ogbo ya̠ na̠ erugh d̠a̠ eghighira̠ okokogh omugh bho̠ eka̠, e̠b̠alab̠al na̠ amu̠o̠m awa.” ");
INSERT INTO mgj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ob̠eton obhel obha̠, sa̠ A̠zizo̠s ake̠ ma̠ o̠gba orile ma̠a̠: “Itiba̠ra̠ d̠a̠ i̠karabh, ezin bho̠ irileghom ote̠nai̠ny na̠ a̠tua̠n!” ");
INSERT INTO mgj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sa̠ A̠zizo̠s a̠rile agbal Abadi̠ Agalili, sa̠ abi̠gh i̠wal a̠rumor, Asai̠mo̠n wa̠ ubhelegi ma̠ A̠pita̠ bho̠ na̠ Anduru umor d̠o̠yo̠ ka̠ na̠ erobh o̠gbo̠ d̠a̠ abadi̠ bho̠. Awa i̠ku̠ ma̠ i̠ku̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “I̠tu̠o̠no̠me̠ Ami̠, sa̠ Ami̠ ta̠ a̠tenemeni inyin i̠ku̠ ma̠ i̠ku̠ a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","I̠se̠ onin obhel bho̠, sa̠ awa i̠we̠le̠ ma̠ i̠gbo̠ d̠awa iten ogbo i̠tu̠o̠no̠m D̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O̠d̠u̠a i̠se̠ o̠gi̠ d̠a̠ ed̠ia̠, sa̠ abi̠gh ipa̠n i̠wal a̠rumor, A̠zemsi o̠nyi̠ ta̠ Aze̠bidi na̠ Azo̠n umor d̠o̠yo̠ d̠a̠ ologi oghugh na̠ o̠we̠de̠ d̠awa Aze̠bidi, na̠ e̠tu̠ghu̠man i̠gbo̠ d̠awa, sa̠ a̠bhelegi awa. ");
INSERT INTO mgj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sa̠ awa i̠we̠le̠ epa̠ ma̠ oghugh bho̠ na̠ o̠we̠de̠ d̠awa iten ogbo i̠tu̠o̠no̠m D̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sa̠ A̠zizo̠s a̠rile d̠a̠ eb̠la̠ Agalili atu̠ghu̠me̠ni̠ d̠a̠ ru̠gala d̠awa, sa̠ agba ma̠ ib̠eb̠i asu̠gbagba irileghom bho̠, sa̠ a̠koko ma̠ eb̠la̠ a̠d̠ien kere kere asu̠nwe̠r na̠ eb̠la̠ a̠d̠ien kere kere ali̠gam a̠ruzu ya̠ na̠ e̠te̠i̠ a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sa̠ o̠du̠ D̠o̠yo̠ asasaragi̠an d̠a̠ eb̠la̠ A̠siria̠, sa̠ awa ibhin eb̠la̠ ogbo ya̠ na̠ e̠nwe̠r a̠d̠ien kere kere rasu̠nwe̠r na̠ i̠nyo̠gho̠nyo̠gh ali̠gam a̠ruzu, na̠ ogbo ya̠ a̠ruru na̠ e̠b̠am, na̠ ogbo ya̠ na̠ e̠nwe̠r asu̠nwe̠r ena̠ bho̠, na̠ ogbo ya̠ a̠risi ozu na̠ eb̠ogina̠, sa̠ i̠na a̠koko awa. ");
INSERT INTO mgj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sa̠ obom o̠lo̠gh a̠nwunom d̠a̠ Agalili, na̠ Ebhugh A̠d̠iobh Re̠ma, na̠ A̠zeruse̠le̠m, na̠ A̠zudia̠, na̠ re̠ma ya̠ od̠i d̠a̠ e̠b̠e̠ye̠ma Azo̠dan bho̠, i̠tu̠o̠no̠m I̠na. ");
INSERT INTO mgj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A̠zizo̠s abi̠gh o̠lo̠gh a̠nwunom bho̠, sa̠ asi̠n d̠a̠ anyu̠ igu ka̠ aro̠ ma̠ a̠dila̠de, sa̠ ogbo atu̠ghan d̠o̠yo̠ iru ra̠ i̠te̠i̠ I̠na. ");
INSERT INTO mgj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sa̠ i̠na akpato̠n o̠nu̠ d̠o̠yo̠ atu̠ghu̠me̠ni̠ awa. Sa̠ agba ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ iloghoma̠n ekulom d̠awa d̠a̠ e̠mu̠gh bho̠, Ezin bho̠ irileghom ote̠nai̠ny ola̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ od̠i d̠a̠ i̠ku̠nu̠ bho̠, Ezin bho̠ ta̠ o̠kpo̠me̠ni̠ ma̠ rologi d̠awa! ");
INSERT INTO mgj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ na̠ erugh ado̠l o̠ki̠ri̠me̠ni̠ ozu bho̠, Ezin bho̠ a̠de bho̠ ta̠ aro̠ a̠nigha̠ awa! ");
INSERT INTO mgj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠, o̠ko̠i̠ na̠ ebhiroma̠ orugh ya̠ igielake̠ na̠ ed̠ighi bho̠, Ezin bho̠ ta̠ elegha̠n awa! ");
INSERT INTO mgj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ na̠ ekpon igbirigbir bho̠, Ezin bho̠ awa ta̠ e̠te̠i̠ okpon igbirigbir! ");
INSERT INTO mgj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ ologi i̠b̠ab̠ala bho̠, Ezin bho̠ awa ta̠ e̠bi̠gh A̠zib̠a̠! ");
INSERT INTO mgj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ na̠ emutiom ekima̠ bho̠, Ezin bho̠ ta̠ obhelegi awa ma̠ anwi̠i̠ny ta̠ A̠zib̠a̠! ");
INSERT INTO mgj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Itutumeni e̠ro̠ enigha̠ ma̠ ogbo ya̠ na̠ odin a̠ma̠rugh igielake̠ d̠awa na̠ ogbikimeni bho̠, Ezin bho̠ irileghom ote̠nai̠ny ta̠ aro̠ a̠nigha̠ awa.” ");
INSERT INTO mgj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Itutumeni e̠ro̠ enigha̠ inyin igiel a̠nwunom na̠ erogi inyin, sa̠ na̠ egbikimeni inyin, sa̠ na̠ e̠gba ma̠ a̠d̠ien kere kere i̠karabh na̠ igunugha̠ na̠ eb̠ologiom inyin ma̠ ebula̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ibhone ma̠ ologi ma̠ ebo, ezin bho̠ alu̠kpe̠ d̠inyin ibom d̠a̠ ote̠nai̠ny. Onin agu̠o̠ bho̠ awa igbikimeni ma̠ a̠riwil ya̠ id̠ia̠ i̠ro̠ na̠ inyin bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Inyin ub̠on e̠mara̠nwunom onon, ya̠a̠ ka̠ ub̠on bho̠ osibh mu̠, ka̠ ta̠ od̠ighi eka̠ ma̠ ola̠ a̠lisibh bho̠ ta̠ a̠nwe a̠mite? Abar ola̠ ta̠ obhin ogir bo̠mu̠, a̠ten ozu orobh ma̠ a̠nwunom o̠ze̠re̠gi̠.” ");
INSERT INTO mgj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Inyin e̠b̠alab̠al e̠mara̠nwunom bho̠. E̠ma ola̠ od̠i d̠a̠ anyu̠ igu ola̠ na̠ anwo̠gi̠na bo̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Obha̠ agu̠o̠ o̠su̠o̠m d̠o̠ ma̠ ato̠di̠ obhin abafu̠ onin o̠to̠ma okpegiom. Ya̠a̠ na̠ o̠gbam ghan d̠a̠ anyu̠ abar ola̠ u̠marame̠ni̠ ma̠ onigha̠ e̠b̠alab̠al eb̠la̠ ogbo ya̠ od̠i d̠a̠ otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","D̠a̠ onin agu̠o̠ bho̠, e̠b̠alab̠al d̠inyin amu̠ d̠a̠ esa̠d̠io a̠nwunom, ma̠ agu̠o̠ ola̠ awa ta̠ e̠bi̠gh ib̠eb̠i ogir d̠inyin, sa̠ ta̠ e̠bu̠ghu̠me̠ni̠ ma̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“O̠ni̠ o̠ru̠ru̠an d̠o̠ ma̠a̠, Ami̠ iru ma̠ ogbogion Oloko ta̠ A̠mozizi, bo̠d̠o̠ atu̠ghu̠me̠ni̠ A̠riwil bho̠. Ami̠ iru d̠o̠ ma̠ ogbogion, ya̠a̠ ami̠ iru ma̠ omuzoghod̠iom. ");
INSERT INTO mgj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, tu̠tu̠n ote̠nai̠ny na̠ a̠de onon ta̠ eten e̠d̠u̠a, bebina̠ e̠pe̠re̠pe̠r bo̠d̠o̠ ekpo abar ola̠ u̠ge̠ d̠a̠ oloko bho̠ ola̠ ta̠ ad̠u̠a bo̠ tu̠tu̠n ta̠ omuzoghod̠iom eb̠la̠ i̠di̠ar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ola̠ a̠guri d̠a̠ aka ma̠ ekpo abar ola̠ u̠ge̠ d̠a̠ oloko bho̠, sa̠ awe̠le̠man o̠b̠ar na̠ obha̠ o̠tu̠ghu̠me̠ni̠, ta̠ obhelegi i̠na ma̠ wa̠ aki̠r a̠pu d̠a̠ irileghom ote̠nai̠ny. Ya̠a̠, o̠ni̠ wa̠ a̠gir i̠di̠ar ya̠ oloko bho̠ ato̠ bho̠ sa̠ atu̠ghu̠me̠ni̠ ma̠ o̠ku̠a nyen, ta̠ obhelegi i̠na ma̠a̠ wa̠ abu̠gh a̠pu d̠a̠ irileghom ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, usigimeni ka̠ igielake̠ d̠inyin ipel ita̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠, inyin ko od̠igh d̠o̠ d̠a̠ irileghom ote̠nai̠ny.” ");
INSERT INTO mgj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Inyin o̠mu̠gho̠n ya̠ u̠gba inigha̠ ma̠ a̠nwunom igied̠i bho̠ ma̠a̠: ‘Ka̠ ogigh o̠ni̠.’O̠ni̠ ola̠ a̠gigh o̠ni̠ ta̠ a̠d̠igh ase̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ko̠ni̠ko̠ni̠ ola̠ agam i̠gam a̠nigha̠ ma̠ umor d̠o̠yo̠ bo̠d̠o̠ u̠marani̠ d̠o̠yo̠, ta̠ a̠d̠igh ase̠. O̠ni̠ ola̠ a̠bhelegi ma̠ umor d̠o̠yo̠ bo̠d̠o̠ u̠marani̠ d̠o̠yo̠ ma̠ ‘Ema̠!’ ta̠ a̠d̠igh ase̠ d̠a̠ a̠misigh ikei A̠zu bho̠. O̠ni̠ ola̠ a̠bhelegi ma̠ o̠ni̠ ma̠a̠, ‘Ob̠ogoro ema̠,’ bha̠ od̠igh d̠a̠ e̠banya bho̠ a̠sugho.” ");
INSERT INTO mgj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ku̠gba ma̠a̠ anwa a̠bhin abar alu̠kpe̠ d̠oyom agi̠ d̠a̠ enwen alu̠kpe̠ bho̠, sa̠ anwa i̠ru̠ru̠an e̠kal abar ola̠ anwa i̠pi̠o̠m umor d̠oyom, ");
INSERT INTO mgj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","We̠le̠ ma̠ abar alu̠kpe̠ d̠oyom i̠se̠ d̠a̠ ukpo bho̠, ma̠ a̠d̠ia̠ ka̠ a̠tulugia̠n umor d̠oyom ma̠ a̠mutiom ekima̠. I̠se̠ ku ma̠ agi̠ ka̠ akpe̠ ma̠ alu̠kpe̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wia̠ne ma̠ a̠tulugia̠n na̠ o̠ni̠ wa̠ na̠ anwa na̠ o̠ku̠anan bho̠ d̠a̠ obhel inyin od̠id̠ia̠ d̠a̠ eten, ma̠ agu̠o̠ ola̠ ko obhin d̠o̠ nyam o̠gi̠o̠m ma̠ osobhmase̠ bho̠, sa̠ osobhmase̠ bho̠ ta̠ a̠bhin anwa agi̠o̠m o̠du̠o̠ma bho̠, sa̠ ta̠ o̠du̠o̠m anwa d̠a̠ ikoli. ");
INSERT INTO mgj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, anwa ko omite d̠o̠ ma̠ i̠se̠ tu̠tu̠n ka̠ anwa na̠ akpe̠ kabar kabar d̠a̠ amu̠kpe̠ ebhumase̠ bho̠ amadon.” ");
INSERT INTO mgj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Inyin na̠ o̠mu̠gho̠n ka̠ u̠gba ma̠a̠: ‘Ko od̠e ma̠ e̠ma.’ ");
INSERT INTO mgj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ya̠a̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠ ko̠ni̠ko̠ni̠ ola̠ a̠kpon ani̠ebhom sa̠ ibhir okod̠uom, bha̠ na̠ a̠d̠e ma̠ e̠ma d̠a̠ ologi d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ku̠gba ma̠a̠ od̠iom ekpo a̠d̠ien d̠oyom na̠ a̠d̠ighi nyam ogir o̠karabh, poko ma̠ asi̠ghe̠ ma̠ a̠robh. Anwa ma̠ orobh onin esi ozu d̠oyom a̠bhon a̠pu ma̠ orobh eb̠la̠ ozu d̠oyom d̠a̠ e̠ba anya bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ku̠gba ma̠a̠ od̠iom agu̠o̠ d̠oyom na̠ a̠d̠ighi nyam ogir i̠karabh, sobhe ma̠ asi̠ghe̠ ma̠ a̠robh. Anwa ma̠ orobh onin esi ozu d̠oyom a̠bhon a̠pu ma̠ obhin eb̠la̠ ozu d̠oyom ka̠ od̠ighom d̠a̠ e̠ba anya bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na̠ o̠gba oguri ma̠a̠: ‘O̠ni̠ ola̠ na̠ a̠gbogina̠ ma̠ ani̠ d̠o̠yo̠, bha̠ a̠nigha̠ i̠na ma̠ a̠d̠ire ogbogina̠ ilom.’ ");
INSERT INTO mgj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠ten ka̠ aro̠ ma̠ ola̠ ani̠ o̠ni̠ a̠d̠e ma̠ e̠ma, ko̠ni̠ko̠ni̠ ola̠ a̠gbogina̠ ma̠ ani̠ d̠o̠yo̠ na̠ a̠tenemeni ma̠ ani̠ d̠o̠yo̠ ma̠ od̠e ma̠ e̠ma. Ko̠ni̠ko̠ni̠ ola̠ a̠bhin ani̠ ola̠ oku̠a, a̠sor oloko od̠e e̠ma.” ");
INSERT INTO mgj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Inyin o̠mu̠gho̠n nyen, ya̠ u̠gba unigha̠ ma̠ a̠nwunom igied̠i ma̠a̠: ‘Ko o̠we̠le̠ ma̠ osibh ogua̠n d̠oyom wa̠ anwa igua̠n bho̠, ya̠a̠ sibhe ma̠ ogua̠n wa̠ anwa igua̠n Wa̠nwuna̠ bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ya̠a̠, ami̠ na̠ aghaghana inyin ma̠a̠, ko od̠e na̠ od̠e ma̠ i̠zo̠, a̠d̠igh obhin ote̠nai̠ny, ezin bho̠, obha̠ a̠dila̠de irileghom ta̠ A̠zib̠a̠; ");
INSERT INTO mgj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bo̠d̠o̠ a̠de bho̠, ezin bho̠, obha̠ okpokpolom o̠gbam a̠wel d̠o̠yo̠; bo̠d̠o̠ A̠zeruse̠le̠m, ezin bho̠, obha̠ e̠ma ta̠ obom O̠li̠le̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bo̠d̠o̠, ko obhin e̠mu̠ d̠oyom aghad̠i̠an, ezin bho̠ anwa ko orue d̠o̠ a̠d̠ighi bebina̠ ekpo asi̠ghal ma̠ oten aso̠n, bo̠d̠o̠ oten o̠zu̠zu̠a. ");
INSERT INTO mgj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ya̠a̠, o̠nu̠o̠kpe̠ d̠oyom aro̠ ma̠a̠, ‘Yii, Yii,’ bo̠d̠o̠ ‘E̠e̠nyi̠, E̠e̠nyi̠.’ Ya̠a̠, ka̠ a̠pel o̠ku̠a, bha̠ ad̠u̠a d̠a̠ agu̠o̠ o̠karabh o̠ni̠ bho̠ a̠ru.” ");
INSERT INTO mgj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Inyin o̠mu̠gho̠n ya̠ u̠gba ma̠a̠: ‘Na̠ obhin ekpo a̠d̠ien na̠ o̠kpe̠ ma̠ ekpo a̠d̠ien, sa̠ na̠ obhin ob̠ub̠ura̠ na̠ o̠kpe̠ ma̠ ob̠ub̠ura̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ya̠a̠, Ami̠ na̠ aghaghana inyin ma̠a̠, ko owia̠n o̠karabh o̠ni̠ bho̠. Kpe̠le̠me̠ni̠, ka̠ o̠ni̠ ab̠abh anwa d̠a̠ od̠iom ab̠akagba d̠oyom, tiba̠ra̠ ma̠ agba uwed̠i ma̠ a̠nigha̠ i̠na nyen. ");
INSERT INTO mgj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ku̠gba ma̠a̠ o̠ni̠ na̠ abho̠ro̠ghan oler onyom iku obhin akapa a̠de d̠oyom, ma̠ra̠ i̠na a̠bhin akapa anyu̠ bho̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ku̠gba ma̠a̠ o̠ni̠ na̠ a̠ponoma̠ nyam ma̠ orol a̠dol d̠o̠yo̠ orile amai̠l,bha̠ d̠ighe na̠ i̠na ma̠ a̠rile ma̠ i̠wal amai̠l. ");
INSERT INTO mgj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nigha̠ ma̠ o̠ni̠ ola̠ a̠puru nyam abar, sa̠ ka̠ o̠ni̠ na̠ abho̠ro̠ghan o̠wo̠lo̠ni̠ abar d̠a̠ agu̠o̠ d̠oyom, ko ogineni.” ");
INSERT INTO mgj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Inyin o̠mu̠gho̠n ya̠ u̠gba ma̠a̠: ‘Tula̠ne ma̠ o̠ni̠ wa̠ na̠ a̠rugh d̠a̠ aka d̠oyom bho̠,ma̠ a̠ghel o̠ni̠ wa̠ na̠ alo̠gh a̠d̠ien anwa bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ya̠a̠, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, itula̠ne ma̠ ogbo ya̠ na̠ e̠lo̠gh a̠d̠ien inyin bho̠, ma̠ siseiny enigha̠ ma̠ ogbo ya̠ na̠ eku inyin na̠ egbikimeni bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","O̠ku̠a sa̠ inyin ta̠ oten anwi̠i̠ny O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. Ezin bho̠, i̠na na̠ a̠d̠ighi ma̠ ola̠ ogogo bho̠ na̠ amu̠o̠m id̠ighi ma̠ i̠karabh bho̠, na̠ ib̠eb̠i a̠nwunom bho̠, sa̠ na̠ a̠nigha̠ ma̠ o̠lo̠bha ma̠ ogbo ya̠ i̠b̠ab̠ala bho̠, na̠ ogbo ya̠ na̠ erugh a̠ma̠rugh i̠te̠i̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka̠ inyin utula̠n ogbo ya̠ na̠ etula̠n inyin bho̠ ku̠ku̠m, asu̠o̠ bho̠ ka̠ ere? Igun ma̠ otua̠-ebhugh bho̠ eka̠ na̠ erugh o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya̠a̠, ku̠gba ma̠ inyin na̠ obheleghom ogbo ya̠ inyin uloghom bho̠ ku̠ku̠m, ka̠ inyin ugir ere opeleni? Ibhebhia̠nbho̠ eka̠ na̠ erugh o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","O̠ku̠a a̠d̠ighi be̠le̠ni̠, irughe ma̠ a̠ma̠rugh igielake̠ d̠a̠ eb̠la̠ re̠kal, ma̠ agu̠o̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny aro̠ ma̠ ola̠ igielake̠ d̠a̠ eb̠la̠ re̠kal bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“I̠mare̠ ma̠ ekpona̠ b̠o̠ka̠ ogir ib̠eb̠i d̠inyin i̠ro̠ ma̠ iya̠ inyin na̠ ogir na̠ oleriom a̠nwunom o̠bi̠gh inyin. Ku̠gba ma̠a̠ inyin ugir o̠ku̠a, bha̠ inyin ko o̠te̠i̠ d̠o̠ ma̠ amu̠kpe̠ d̠a̠ agu̠o̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, igiel anwa na̠ a̠nwo ma̠ inwo, ko od̠ia̠ ma̠ a̠pughe ma̠ od̠od̠ue ma̠ agu̠o̠ ibhelebhel bho̠ na̠ egir d̠a̠ u̠gala A̠zu bho̠, na̠ d̠a̠ reten bho̠, ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ e̠se̠bh awa. Ya̠gia̠ga̠i Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ awa na̠ e̠te̠i̠ amu̠kpe̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ya̠a̠ anwa, nwo ma̠ inwo ma̠ agu̠o̠ ola̠ ekiel agu̠o̠ d̠oyom ko ologhom d̠o̠ ma̠ iya̠ od̠iom agu̠o̠ d̠oyom na̠ a̠gir, ");
INSERT INTO mgj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ma̠ agu̠o̠ ola̠ ogir inwo d̠oyom aro̠ d̠a̠ e̠wo̠gi̠na, sa̠ O̠we̠de̠ d̠oyom wa̠ na̠ abi̠gh d̠a̠ e̠wo̠gi̠na bho̠ ta̠ akpe̠ nyam. ");
INSERT INTO mgj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Igiel inyin na̠ osiseiny, o̠ni̠ ko o̠ro̠ ma̠ agu̠o̠ ogbo ibhelebhelbho̠. Ezin bho̠ awa na̠ eba̠ra̠ ma̠ o̠ro̠ e̠mara d̠a̠ ru̠gala na̠ d̠a̠ aka reten bho̠ osiseiny, ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ e̠bi̠gh awa. Ya̠gia̠ga̠i, awa na̠ e̠te̠i̠ epa̠ ma̠ amu̠kpe̠ d̠awa eleghemeni. ");
INSERT INTO mgj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ya̠a̠ igiel anwa na̠ a̠siseiny, d̠ighe d̠a̠ e̠bhai̠ ma̠ a̠gugi ma̠ egugh bho̠, ma̠ a̠siseiny a̠nigha̠ ma̠ O̠we̠de̠ d̠oyom wa̠ od̠i d̠a̠ e̠wo̠gi̠na bho̠, sa̠ O̠we̠de̠ d̠oyom wa̠ na̠ abi̠gh d̠a̠ e̠wo̠gi̠na bho̠ ta̠ akpe̠ nyam. ");
INSERT INTO mgj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","O̠ni̠ ko ota̠ba̠ ma̠ a̠fugh d̠a̠ a̠siseiny d̠inyin ma̠ agu̠o̠ ibhebhia̠nbho̠, ya̠ na̠ e̠ru̠ru̠an ma̠ ota̠ba̠ a̠fugh d̠a̠ a̠siseiny ta̠ a̠d̠ighi ma̠ ola̠ ta̠ o̠nagha awa. ");
INSERT INTO mgj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko orugh agu̠o̠ awa, ezin bho̠ O̠we̠de̠ d̠inyin a̠loghom abar wa̠ na̠ akparama inyin bho̠, kisa̠ inyin ta̠ opuru i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, onon agu̠o̠ inyin ta̠ osiseiny: “ ‘O̠we̠de̠ d̠i̠yar wa̠ od̠i d̠a̠ ote̠nai̠ny, A̠d̠ien d̠oyom aro̠ ma̠ ola̠ e̠tu̠tu̠, ");
INSERT INTO mgj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Irileghom d̠oyom a̠ru, I̠to̠ d̠oyom e̠ro̠ ani̠ ma̠ i̠se̠n a̠de onon, Ma̠ agu̠o̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ed̠ia̠n ya̠ eb̠la̠ ra̠d̠a̠ma̠ bho̠, Nigha̠ i̠yar ya̠ a̠didon. ");
INSERT INTO mgj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","We̠le̠mane̠ ma̠ i̠karabh d̠i̠yar, Ma̠ agu̠o̠ i̠yar na̠ o̠we̠le̠man i̠karabh ya̠ ipa̠n ogbo na̠ ed̠ighi i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ko oma̠ra̠ i̠yar omel d̠a̠ ad̠agi̠an, Ya̠a̠, tenemeni i̠yar d̠a̠ agu̠o̠ o̠karabh o̠ni̠ bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ku̠gba ma̠a̠, inyin na̠ o̠we̠le̠man i̠karabh ya̠ a̠nwunom na̠ ed̠ighi inyin, O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ ta̠ awe̠le̠man i̠karabh d̠inyin nyen. ");
INSERT INTO mgj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ya̠a̠, ka̠ inyin o̠we̠le̠man d̠o̠ ma̠ i̠karabh ya̠ a̠nwunom na̠ ed̠ighi inyin bho̠, O̠we̠de̠ bho̠ ka̠ o̠we̠le̠man d̠o̠ ma̠ i̠karabh d̠inyin nyen. ");
INSERT INTO mgj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Igiel inyin na̠ one ma̠ o̠ko̠i̠, o̠ni̠ ko o̠ku̠ru̠ru̠ ma̠ agu̠o̠ ibhelebhel a̠nwunom, ya̠ na̠ egurumeni ma̠ ra̠misigh d̠awa ma̠ oleriom a̠nwunom ma̠ awa na̠ ene ma̠ o̠ko̠i̠. Ya̠gia̠ga̠i, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, awa na̠ e̠te̠i̠ epa̠ ma̠ amu̠kpe̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ya̠a̠, igiel anwa na̠ a̠ne ma̠ o̠ko̠i̠, titila̠ ma̠ a̠misigh d̠oyom ma̠ a̠sigha̠ ma̠ elo d̠a̠ e̠mu̠ d̠oyom, ");
INSERT INTO mgj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Agu̠o̠ ola̠ anwa ko oleriom d̠o̠ ma̠ a̠nwunom ma̠a̠ anwa na̠ a̠ne ma̠ o̠ko̠i̠, ya̠a̠ O̠we̠de̠ d̠oyom ku̠ku̠m wa̠ o̠bi̠gh d̠o̠ bho̠. Sa̠ O̠we̠de̠ d̠oyom wa̠ na̠ abi̠gh d̠a̠ e̠wo̠gi̠na bho̠ ta̠ akpe̠ nyam. ");
INSERT INTO mgj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“O̠ni̠ ko okoko ma̠ i̠di̠ar edim d̠inyin d̠a̠ a̠de onon, esi wa̠ ad̠u̠i̠ny na̠ o̠sari̠ ta̠ e̠pi̠e̠gi̠, sa̠ aru̠gba ta̠ eb̠ogion ed̠igh ka̠ eb̠ighogh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ya̠a̠, ikoko ma̠ i̠di̠ar edim d̠inyin d̠a̠ ote̠nai̠ny, esi wa̠ ad̠u̠i̠ny bo̠d̠o̠ o̠sari̠ ko o̠pi̠e̠gi̠ d̠o̠, sa̠ aru̠gba ko ob̠ogion d̠o̠ ed̠igh ka̠ eb̠ighogh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Esi wa̠ i̠di̠ar edim d̠oyom od̠i bho̠, i̠se̠ esi ologi d̠oyom ta̠ aro̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ekpo a̠d̠ien bha̠ ato̠di̠ ozu o̠ni̠. O̠ku̠a a̠d̠ighi be̠le̠ni̠, ku̠gba ma̠ ekpo a̠d̠ien d̠oyom aghu̠a, eb̠la̠ ozu d̠oyom ta̠ amar awar. ");
INSERT INTO mgj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ya̠a̠, ku̠gba ma̠ ekpo ad̠ien d̠oyom na̠ a̠b̠oma̠n, eb̠la̠ ozu d̠oyom ta̠ aro̠ d̠a̠ azi̠m. Ebula̠ o̠ku̠a, ku̠gba ma̠ e̠b̠alab̠al wa̠ od̠i d̠a̠ ozu d̠oyom bho̠ na̠ a̠ten azi̠m, o̠ku̠a ka̠ azi̠m bho̠ ta̠ aro̠ eka̠? ");
INSERT INTO mgj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“O̠ni̠ ola̠ ta̠ a̠rue aro̠ ma̠ ob̠a̠ra̠motu ta̠ i̠wal a̠nwunom aru̠mu̠ bo̠. Ezin bho̠, i̠na ta̠ a̠ghel odi sa̠ ta̠ a̠tula̠n uwed̠i, bo̠d̠o̠ ta̠ a̠zuruna̠ ma̠ eghoiy a̠nigha̠ ma̠ odi, sa̠ ta̠ ab̠agh e̠mu̠ a̠nigha̠ ma̠ uwed̠i. O̠ni̠ ka̠ orue d̠o̠ ako̠l A̠zib̠a̠ na̠ okpoki. ");
INSERT INTO mgj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ebula̠ o̠ku̠a, Ami̠ na̠ agba na̠ a̠nigha̠ inyin, o̠ni̠ ko o̠nyo̠gho̠ghan a̠ghud̠um d̠inyin ma̠ egboloma̠ ma̠ abar ola̠ od̠e, bo̠d̠o̠ abar ola̠ o̠d̠a, bo̠d̠o̠ ipulupul ozu bho̠, na̠ abar ola̠ o̠lagha. A̠ghud̠um na̠ olei d̠o̠ ma̠ abar a̠pu ma̠ ed̠ia̠n, sa̠ ozu olei d̠o̠ ma̠ abar a̠pu ma̠ ibura̠, ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ikpone ma̠ ed̠ighom a̠ghud̠um i̠nu̠r ya̠ na̠ e̠bhe̠bh d̠a̠ anyu̠ bho̠. Awa igbebh d̠o̠, bo̠d̠o̠ ib̠u d̠o̠, bo̠d̠o̠ ikpol d̠o̠ nyen ed̠ia̠n eguri d̠a̠ esi eko, ya̠a̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ na̠ a̠koko awa. Inyin ulei d̠a̠ ma̠ abar opu awa ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A̠nyen inyin ola̠ ta̠ a̠rue a̠bhin d̠a̠ i̠nyo̠gho̠ghan alo̠gho̠m bebina̠ ekud̠i obhel d̠a̠ a̠ghud̠um d̠o̠yo̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ya̠a̠, inyin na̠ o̠nyo̠gho̠ghan ere na̠ ogboloma̠ ma̠ ibura̠? I̠mare̠ ma̠ ekpon ra̠lele ya̠ od̠i d̠a̠ e̠sala bho̠, ma̠ agu̠o̠ awa na̠ ebhin e̠su̠. Awa igir d̠o̠ ma̠ i̠kparakpar ogir, ikpogh d̠o̠ ma̠ i̠di̠ar nyen. ");
INSERT INTO mgj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ya̠a̠, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ Aso̠lo̠mo̠n eka̠, d̠a̠ eb̠la̠ isosorogia̠n d̠o̠yo̠, na̠ obura̠ d̠o̠ ma̠ ibura̠ ya̠ ibhon ile̠i ita̠ odi i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sa̠ ku̠gba ma̠ A̠zib̠a̠ na̠ a̠buri ma̠ i̠gho̠gho̠ ya̠ od̠i ma̠ a̠didon d̠a̠ e̠sala bho̠, sa̠ o̠nyi̠ obhel sa̠ na̠ orobh na̠ o̠lo̠gh d̠a̠ e̠ba anya bho̠, I̠na ka̠ oburi d̠a̠ inyin a̠pu ma̠ o̠ku̠a ke̠re̠? Inyin ogbo ya̠ ologi ima̠ra̠ o̠ghu̠a d̠o̠ bho̠! ");
INSERT INTO mgj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ebula̠ o̠ku̠a, ka̠ o̠nyo̠gho̠ghan efugh ma̠a̠, ‘I̠yar ta̠ od̠e ma̠ ere?’ Bo̠d̠o̠, ‘Ta̠ o̠d̠a ma̠ ere?’ Bo̠d̠o̠ ‘Ta̠ o̠lo̠gi̠an ere?’ ");
INSERT INTO mgj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ezin bho̠ eb̠la̠ i̠nye̠n, bha̠ i̠di̠ar ya̠ ibhebhia̠n bho̠ na̠ ewia̠n o̠te̠i̠ bho̠, ya̠a̠ O̠we̠de̠ d̠inyin d̠a̠ ote̠nai̠ny a̠loghom ma̠ a̠bhon inyin o̠te̠i̠ eb̠la̠ i̠di̠ar i̠ye̠. ");
INSERT INTO mgj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ya̠a̠, abar wa̠ abu̠gh a̠pu bho̠, bha̠ iwia̠ne ma̠ o̠te̠i̠ irileghom ta̠ A̠zib̠a̠, na̠ a̠ghud̠um igielake̠ ta̠ A̠zib̠a̠, sa̠ ta̠ o̠lo̠gho̠m eb̠la̠ i̠di̠ar i̠nye̠n onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko o̠nyo̠gho̠ghan egboloma̠ ma̠ agu̠o̠ elegien ta̠ aro̠. Ezin bho̠, elegien na̠ agu̠o̠ ta̠ anyo̠gho̠ghan a̠gboloma̠ ma̠ agu̠o̠ i̠na ta̠ aro̠. Ezin bho̠ e̠mu̠ a̠d̠a̠ma̠ i̠se̠ a̠wuna̠ ma̠ i̠nyo̠ngho̠yo̠ngh iya̠ o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ka̠ o̠bi̠gh a̠nwunom api̠e̠, b̠o̠ka̠ u̠bi̠gh inyin o̠pi̠e̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A̠d̠ien agu̠o̠ inyin ubhin u̠bi̠gh a̠nwunom u̠pi̠e̠ bho̠, obha̠ agu̠o̠ ta̠ o̠bi̠gh ani̠ inyin o̠pi̠e̠. Sa̠ a̠d̠ien o̠to̠ma wa̠ inyin ubhin u̠to̠ unigha̠ awa bho̠, bha̠ wa̠ ta̠ obhin o̠to̠ onigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ezin ka̠ ere ka̠ anwa na̠ abi̠gh o̠taghatagh d̠a̠ ekpo a̠d̠ien umor d̠oyom, sa̠ anwa na̠ ologhoma̠n d̠o̠ ma̠ ali̠kara wa̠ od̠i d̠a̠ ekpo a̠d̠ien d̠oyom bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Anwa ta̠ atu̠n ere a̠fugh a̠nigha̠ ma̠ umor d̠oyom ma̠a̠, ‘umor, d̠ighi ami̠ i̠si̠ghe̠ ma̠ o̠taghatagh d̠a̠ ekpo a̠d̠ien d̠oyom,’ ya̠a̠ ali̠kara od̠i d̠a̠ ekpo a̠d̠ien d̠oyom? ");
INSERT INTO mgj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Anwa obhelebhel o̠ni̠! D̠ia̠ ma̠ asi̠ghe̠ ma̠ ali̠kara wa̠ od̠i d̠a̠ ekpo a̠d̠ien d̠oyom bho̠; i̠se̠ kisa̠ anwa ta̠ amar abi̠gh abar asi̠ghe̠ ma̠ o̠taghatagh wa̠ od̠i d̠a̠ ekpo a̠d̠ien umor d̠oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“O̠ni̠ ka̠ onigha̠ ma̠ abar e̠tu̠tu̠ ma̠ a̠sib̠ogho, bo̠d̠o̠ ko orobhod̠i ma̠ ri̠b̠o̠lo̠ ibom a̠b̠ua̠ d̠inyin ma̠ enigha̠ ma̠ roporopo, b̠o̠ka̠ ibhin a̠sike d̠awa e̠ze̠re̠gi̠ ed̠iomeni, sa̠ ta̠ etiba̠ra̠ e̠ku̠su̠gi̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ipuru, sa̠ ta̠ onigha̠ inyin. I̠bho̠ro̠ghane̠, sa̠ inyin ta̠ o̠bi̠gh. Ikpukpu, sa̠ ta̠ oguron onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ezin bho̠, ko̠ni̠ ko̠ni̠ ola̠ a̠puru, ta̠ onigha̠, ola̠ abho̠ro̠ghan ta̠ abi̠gh, ola̠ a̠kpukpu, ta̠ oguron onigha̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“A̠nyen inyin ola̠ ka̠ o̠nyi̠ d̠o̠yo̠ a̠puru ma̠ ed̠ia̠n, sa̠ ta̠ a̠b̠eton o̠gbaki̠ghe̠ a̠nigha̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bo̠d̠o̠ ka̠ a̠puru ma̠ ena̠, sa̠ ta̠ a̠b̠eton o̠karabh abar a̠nigha̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ku̠gba ma̠ inyin ogbo ya̠ i̠ro̠ ma̠ i̠karabh a̠nwunom bho̠ eloghom agu̠o̠ onigha̠ anwi̠i̠ny d̠inyin ib̠ebi̠ i̠di̠ar, a̠dina̠mu ma̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. I̠na ta̠ a̠nigha̠ ma̠ ib̠eb̠i i̠di̠ar ma̠ a̠nwunom ya̠ ipuru I̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kere kere abar ola̠ anwa na̠ abho̠ro̠ghan ma̠ a̠nwunom egir enigha̠ nyam, gire ani̠ ma̠ o̠ku̠a ma̠ a̠nigha̠ awa. Ezin bho̠ onon agu̠o̠ Oloko ta̠ A̠mozizi na̠ atu̠ghu̠me̠ni̠ A̠riwil bho̠ ima̠ra̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“I̠wo̠le̠ d̠a̠ o̠nu̠ ogigo wa̠ a̠kporia̠n bho̠ ma̠ ed̠igh. Ezin bho̠, o̠nu̠ ogigo wa̠ are̠gh bho̠, na̠ eten wa̠ a̠bhela̠ bho̠, na̠ a̠bhin o̠ni̠ na̠ a̠d̠ighom d̠a̠ omugh, sa̠ a̠d̠izo a̠nwunom na̠ e̠wo̠l i̠se̠ na̠ ed̠igh. ");
INSERT INTO mgj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ya̠a̠, o̠nu̠ ogigo wa̠ na̠ o̠wo̠l na̠ o̠te̠i̠ a̠ghud̠um bho̠ a̠kporia̠n, sa̠ eten wa̠ na̠ o̠wo̠l na̠ o̠gi̠ bho̠ eka̠ a̠kporia̠n. Igini a̠nwunom ku̠ku̠m na̠ e̠te̠i̠ na̠ ed̠igh. ");
INSERT INTO mgj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“I̠mare̠ ma̠ ekpona̠ ma̠ a̠riwil igunugha̠ ya̠ na̠ eru d̠inyin na̠ ibura̠ ka̠ ro̠nana, ne̠ge̠ i̠gagaman i̠nam. ");
INSERT INTO mgj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Na̠ obhin imuma̠ d̠awa na̠ olelegi awa. A̠nwunom ikpokpo d̠o̠ ma̠ itu a̠grep d̠a̠ ed̠um ib̠ub̠ulom, bo̠d̠o̠ itu a̠fig d̠a̠ e̠ko̠ko̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Obha̠ agu̠o̠ ob̠eb̠i oriren na̠ a̠mum ib̠eb̠i itu, ya̠a̠ o̠karabh oriren na̠ a̠mum i̠karabh itu. ");
INSERT INTO mgj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ob̠eb̠i oriren na̠ orue d̠o̠ a̠mum i̠karabh itu, obha̠ agu̠o̠ o̠karabh oriren eka̠ ka̠ orue d̠o̠ a̠mum ib̠eb̠i itu. ");
INSERT INTO mgj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kere kere oriren ola̠ omum d̠o̠ ma̠ a̠ga̠i otu ta̠ ogu o̠gu̠ro̠m, sa̠ ta̠ orobh o̠lo̠gh d̠a̠ e̠ba anya bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ta̠ obhin imuma̠ d̠awa olelegi awa. ");
INSERT INTO mgj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ko̠ni̠ ko̠ni̠ ola̠ a̠bhelegi Ami̠ ma̠a̠, ‘Wa̠nwuna̠, Wa̠nwuna̠,’ d̠o̠ ma̠ ola̠ ta̠ a̠d̠igh d̠a̠ irileghom ote̠nai̠ny, ya̠a̠ ogbo ya̠ igir i̠to̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","D̠a̠ a̠d̠a̠ma̠ obha̠, a̠d̠izo a̠nwunom ta̠ e̠go̠ya ma̠a̠, ‘Wa̠nwuna̠, Wa̠nwuna̠, i̠yar ubhin d̠o̠ ma̠ a̠d̠ien d̠oyom o̠gba ma̠ asu̠gbagba bho̠, obhin a̠d̠ien d̠oyom oze ma̠ a̠ruru, obhin a̠d̠ien d̠oyom ogir a̠d̠izo ilologia̠n, ke̠re̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yaa̠, ami̠ ta̠ agba a̠nigha̠ awa ma̠a̠, ‘Obhel ola̠ ami̠ iloghom inyin bo̠, itene ma̠ e̠d̠u̠a, inyin ogbo ya̠ irugh i̠te̠i̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kere kere o̠ni̠ ola̠ amu̠gho̠n atu̠ghu̠me̠ni̠ d̠ami̠ i̠nye̠n, sa̠ a̠rugh o̠ku̠a, bha̠ ta̠ obhin o̠tu̠o̠m ologhobar o̠ni̠ wa̠ a̠lo ma̠ otu d̠o̠yo̠ d̠a̠ anyu̠ o̠gbe̠o̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sa̠ igiel a̠d̠io bho̠ alo̠bh bho̠, sa̠ ra̠d̠igho bho̠ iru bho̠, sa̠ rogim bho̠ igim i̠dama ma̠ otu bho̠, otu bho̠ na̠ omel d̠o̠. Ezin bho̠, o̠di̠o̠ma bho̠ bo̠ d̠a̠ anyu̠ o̠gbe̠o̠ma. ");
INSERT INTO mgj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ya̠a̠, ko̠ni̠ ko̠ni̠ ola̠ amu̠gho̠n atu̠ghu̠me̠ni̠ d̠ami̠ i̠nye̠n, sa̠ ogir d̠o̠ ma̠ o̠ku̠a, bha̠ ta̠ obhin o̠tu̠o̠m ema̠ o̠ni̠ wa̠ a̠lo ma̠ otu d̠o̠yo̠ d̠a̠ anyu̠ i̠si̠sar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sa̠ igiel a̠d̠io bho̠ alo̠bh bho̠, sa̠ ra̠d̠igho bho̠ iru bho̠, sa̠ rogim bho̠ igim, i̠dama ma̠ otu bho̠, sa̠ otu bho̠ a̠mel a̠tutughud̠ia̠n. Abu̠gh emel!” ");
INSERT INTO mgj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sa̠ aro̠ ma̠ ola̠, igiel bho̠ A̠zizo̠s na̠ a̠kunugiom atu̠ghu̠me̠ni̠ i̠nye̠n bho̠, sa̠ ro̠lo̠gh a̠nwunom bho̠ ib̠a̠gha̠gha̠ d̠a̠ ebula̠ atu̠ghu̠me̠ni̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ezin bho̠ i̠na atu̠ghu̠me̠ni̠ awa ma̠ agu̠o̠ o̠ni̠ ola̠ od̠i d̠a̠ a̠dila̠de i̠to̠, sa̠ atu̠ghu̠me̠ni̠ bho̠ inwegia̠n ita̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Igiel bho̠ i̠na ad̠u̠a d̠a̠ anyu̠ igu a̠sor bho̠, sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sa̠ o̠ni̠ ola̠ na̠ anwe̠r asu̠nwe̠r ekid̠igh a̠ru ra̠ a̠kpud̠ia̠n i̠na a̠fugh ma̠a̠: “Wa̠nwuna̠! Ku̠gba ma̠ Anwa ta̠ a̠ma̠ra̠, bha̠ koko ami̠ ma̠ ab̠ab̠alame̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sa̠ A̠zizo̠s a̠selegheni epa̠ ma̠ agu̠o̠ d̠o̠yo̠ a̠kula̠n i̠na a̠fugh ma̠a̠: “Ami̠ a̠ma̠ra̠, b̠ab̠ala” Ogbo na̠ onin sa̠ a̠d̠um d̠a̠ asu̠nwe̠r ekid̠igh bho̠ ");
INSERT INTO mgj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠: “Bi̠ghe̠! Ko o̠gba ma̠ a̠nigha̠ ma̠ o̠ni̠, kpe̠le̠me̠ni̠ gi̠e̠ ka̠ a̠leriom ozu d̠oyom okur ta̠ A̠zib̠a̠ bho̠ ma̠ akpe̠ ma̠ alu̠kpe̠ wa̠ A̠mozizi a̠ruom bho̠, ma̠ oleriom ma̠ anwa na̠ a̠d̠um.” ");
INSERT INTO mgj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Igiel bho̠ A̠zizo̠s a̠d̠igh d̠a̠ Akapanu̠m bho̠, sa̠ odi we̠mu̠ o̠lo̠gh e̠gham A̠rom a̠ru ra̠ ate̠i̠ i̠na, sa̠ ale̠gh i̠na ");
INSERT INTO mgj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a̠fugh ma̠a̠: “Wa̠nwuna̠, ob̠a̠ra̠motu d̠ami̠ na̠ anwe̠r a̠b̠ogina̠ d̠a̠ otu sa̠ na̠ abi̠gh ibom ali̠gam a̠ruzu.” ");
INSERT INTO mgj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sa̠ i̠na awo̠ran a̠fugh ma̠a̠: “Ami̠ ta̠ a̠ru ra̠ a̠koko i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sa̠ we̠mu̠ e̠gham bho̠ awo̠ran ma̠a̠: “Wa̠nwuna̠, ami̠ ilei d̠o̠ ma̠ ola̠ od̠ighom oyom d̠a̠ ekpukpu i̠galaga otu d̠ami̠. Kpe̠le̠me̠ni̠, fughe ma̠ i̠na a̠d̠um, sa̠ ob̠a̠ra̠motu d̠ami̠ ta̠ a̠d̠um. ");
INSERT INTO mgj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ami̠ eka̠ bha̠ o̠ni̠ ola̠ od̠i d̠a̠ a̠dila̠de i̠to̠, sa̠ ami̠ inwuna̠ ma̠ a̠limon igboloma̠ ma̠ ogbo e̠gham ya̠ od̠i d̠a̠ ekpukpu d̠ami̠ bho̠. Ka̠ ami̠ iruom o̠ni̠ onon ma̠a̠, ‘Gi̠e̠,’ sa̠ ta̠ agi̠; ka̠ ami̠ iruom opa̠n o̠ni̠ ma̠a̠, ‘Tue,’ sa̠ ta̠ a̠ru. Ka̠ ami̠ iruom ogoni d̠ami̠ ma̠a̠, ‘Gire ma̠ abar onon,’ sa̠ i̠na ta̠ a̠gir.” ");
INSERT INTO mgj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Igiel bho̠ A̠zizo̠s amu̠gho̠n i̠nye̠n bho̠, sa̠ a̠b̠a̠gha̠gha̠, sa̠ a̠fugh a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom ya̠ na̠ e̠tu̠o̠no̠m I̠na bho̠ ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ami̠ ta̠ o̠bi̠gh d̠o̠ ma̠ o̠ni̠ ola̠ ologi ima̠ra̠ bho̠ abu̠gh o̠ko̠no̠n d̠a̠ Izre̠l. ");
INSERT INTO mgj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sa̠ Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠ a̠d̠izo a̠nwunom ta̠ e̠d̠u̠a d̠a̠ agba opuomite na̠ osor ogogo bho̠, ra̠ ed̠igh na̠ Ebraham, na̠ Azi̠ki̠, na̠ A̠zeko̠pu̠ e̠ro̠ ma̠ a̠dila̠de d̠a̠ akpata od̠e d̠a̠ irileghom ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ya̠a̠ ta̠ oze ma̠ idi anwi̠i̠ny Izre̠l ya̠a̠, nab̠o̠, awa anwi̠i̠ny irileghom bho̠, ka̠ o̠lo̠gh d̠a̠ obom azi̠m, esi ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ we̠mu̠ o̠lo̠gh e̠gham bho̠ ma̠a̠: “Gi̠e̠! A̠mite a̠nigha̠ nyam agu̠o̠ anwa ima̠ra̠ bho̠.” Sa̠ ob̠a̠ra̠motu bho̠ a̠d̠um onin obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sa̠ A̠zizo̠s agi̠ d̠a̠ otu ta̠ A̠pita̠, sa̠ abi̠gh o̠yo̠go̠-onweni ta̠ A̠pita̠ d̠a̠ e̠mana asu̠nwe̠r ola̠ amu̠m o̠bhi̠i̠y na̠ a̠sibh sa̠ na̠ a̠bhin igiri. ");
INSERT INTO mgj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sa̠ i̠na a̠kula̠n agu̠o̠ ani̠ bho̠, sa̠ amu̠m-o̠bhi̠i̠y bho̠ ad̠u̠a, sa̠ ani̠ bho̠ a̠b̠etina̠ a̠d̠ighi ma̠ ed̠ia̠n aki̠o̠m i̠na i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ate̠i̠ a̠dule, sa̠ ibhinogh a̠d̠izo ogbo ya̠ i̠karabh aru̠mu̠gh na̠ enyegi iru d̠o̠yo̠, sa̠ i̠na a̠mulughuom a̠ze ma̠ i̠karabh aru̠mu̠gh bho̠ asi̠ghe̠gi̠ na̠ ekpo a̠fugh, sa̠ a̠koko ma̠ eb̠la̠ ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ bho̠ a̠d̠umeni, ");
INSERT INTO mgj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ma̠ agu̠o̠ ola̠ omuzoghod̠iom iwowa̠ ya̠ owil Azaya a̠wa̠ bho̠, ma̠a̠: “I̠na asi̠ghe̠ ma̠ rasu̠nwe̠r d̠a̠ a̠ruzu d̠i̠yar, sa̠ a̠rol a̠dol rasu̠nwe̠r d̠i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Igiel bho̠ A̠zizo̠s abi̠gh agu̠o̠ o̠lo̠gh a̠nwunom na̠ eko i̠na ekiton bho̠, sa̠ a̠ruom ma̠ o̠b̠e̠i̠y d̠a̠ aku̠b̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sa̠ odi o̠ni̠ atu̠ghu̠me̠ni̠ oloko bho̠ a̠ru ra̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “O̠ni̠ Atu̠ghu̠me̠ni̠, ami̠ ta̠ atu̠o̠no̠m anwa agi̠ kesi kesi ola̠ anwa na̠ agi̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Rududu enwuna̠ ma̠ iyol ya̠ awa na̠ erugh, sa̠ i̠nu̠r anyu̠ eka̠ inwuna̠ ma̠ a̠rutu; ya̠a̠ O̠nyi̠ ta̠ O̠ni̠ na̠ onwuna̠ d̠o̠ ma̠ esi ola̠ od̠igh ola̠ ob̠enegiom e̠mu̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sa̠ opa̠n o̠ni̠ atu̠ghan d̠o̠yo̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, d̠ighi ami̠ id̠ia̠ i̠gi̠ ka̠ id̠i ma̠ o̠we̠de̠ d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ya̠a̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Tu̠o̠no̠me̠ ku ami̠, ma̠ awe̠le̠man imumugh a̠nwunom bho̠, ed̠i ma̠ imumugh d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sa̠ I̠na a̠d̠igh d̠a̠ ologi oghugh sa̠ ogbo atu̠ghan D̠o̠yo̠ id̠igh ani̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sa̠ o̠gagaman ogim a̠gim awai̠ d̠a̠ abadi̠ bho̠ ma̠ ola̠ ipoka̠na̠n amu̠m id̠u id̠igh d̠a̠ oghugh bho̠, ma̠ owie, ya̠a̠ I̠na na̠ okod̠u. ");
INSERT INTO mgj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sa̠ ogbo atu̠ghan bho̠ i̠gi̠ ka̠ i̠su̠me̠ni̠ I̠na ifugh ma̠a̠: “Wa̠nwuna̠, tenemeni i̠yar! A̠d̠ugh na̠ a̠bhin i̠yar!” ");
INSERT INTO mgj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sa̠ awo̠ran awa ma̠a̠: “Inyin u̠tu̠n ere na̠ oghil a̠rugugu? Inyin a̠nwunom ya̠ ologi ima̠ra̠ o̠ghu̠a d̠o̠!” Sa̠ I̠na a̠b̠etina̠ a̠mulughuom ogim bho̠ na̠ abadi̠ bho̠, sa̠ ilia̠ i̠ro̠ to̠i̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sa̠ a̠nwunom bho̠ ib̠a̠gha̠gha̠, ifugh ma̠a̠, “Onon ka̠ a̠kere a̠d̠ien o̠ni̠, ma̠ ola̠ ogim na̠ abadi̠ eka̠ na̠ e̠nagha ma̠ o̠nu̠o̠kpe̠ D̠o̠yo̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Igiel bho̠ awa i̠be̠i̠ d̠a̠ agba ebhugh Agadara bho̠ sa̠ i̠na a̠pel a̠bhun. Sa̠ i̠wal ilobhiri a̠nwunom ya̠ i̠karabh aru̠mu̠gh na̠ enyegi i̠d̠u̠a d̠a̠ o̠karabh esi bho̠ iru ra̠ i̠damaghan i̠na. Awa i̠bho̠ru̠ ka̠ i̠te̠i̠ esi ola̠, a̠d̠ien agu̠o̠ o̠ni̠ a̠mon ate̠i̠, orue d̠o̠ ma̠ o̠wo̠l esi bho̠ oten. ");
INSERT INTO mgj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Awa i̠bi̠gh i̠na sa̠ imulughu ifugh ma̠a̠, “Anwa O̠nyi̠ ta̠ A̠zib̠a̠, anwa na̠ abho̠ro̠gh ere d̠a̠ a̠ruzu d̠i̠yar? Anwa iru ma̠ i̠se̠n ma̠ o̠nyo̠gho̠gh i̠yar kisa̠ ta̠ ate̠i̠ ekunuguma̠ obhel bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Igiel obha̠, obom o̠lo̠gh roporopo na̠ ed̠e ma̠ esi ola̠ osigima̠ d̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sa̠ i̠karabh aru̠mu̠gh bho̠ i̠le̠gh i̠na ifugh ma̠a̠: “Agu̠o̠ anwa na̠ a̠ze i̠yar na̠ asi̠ghe̠ bho̠, bha̠ ruome i̠yar o̠gi̠ ka̠ od̠igh d̠a̠ a̠ruzu roporopo bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠: “Imite ma̠ e̠d̠u̠a!” Sa̠ i̠karabh aru̠mu̠gh bho̠ imite i̠gi̠ ka̠ id̠igh d̠a̠ roporopo bho̠, sa̠ eb̠la̠ o̠lo̠gh roporopo bho̠ igbudon ighil isor d̠a̠ a̠gbo bho̠, ka̠ i̠bhu̠ghu̠d̠i̠an imugughu d̠a̠ abadi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sa̠ ogbo ya̠ na̠ ekponom roporopo bho̠ ikpo ma̠ eghil i̠d̠u̠a, i̠gi̠ d̠a̠ e̠ma bho̠ ka̠ i̠gba ma̠ eb̠la̠ i̠di̠ar ya̠ imutuma̠ ma̠ i̠wal ilobhiri a̠nwunom ya̠ i̠karabh aru̠mu̠gh na̠ enyegi bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Obha̠ abar! Sa̠ eb̠la̠ e̠ma bho̠ id̠ua̠n i̠gi̠ ka̠ i̠te̠i̠ A̠zizo̠s, sa̠ ima̠ra̠nua̠n i̠le̠gh i̠na ma̠ oten o̠d̠u̠a d̠a̠ ebhugh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sa̠ i̠na a̠d̠igh d̠a̠ oghugh ab̠e̠i̠ d̠a̠ aku̠b̠o̠ bho̠ agi̠ d̠a̠ e̠ma d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Igiel bho̠ i̠na a̠misi bho̠, sa̠ idi a̠nwunom irol o̠ni̠ ola̠ na̠ a̠b̠ogina̠ d̠a̠ ozu d̠a̠ a̠kporokporo ibhin ka̠ i̠te̠i̠ A̠zizo̠s. Igiel bho̠ A̠zizo̠s abi̠gh e̠mi̠ ologi ima̠ra̠ d̠awa bho̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “O̠nyi̠ d̠ami̠, kpo̠ ma̠ a̠luzu, na̠ o̠we̠le̠man i̠karabh d̠oyom onigha̠ nyam.” ");
INSERT INTO mgj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sa̠ idi ogbo atu̠ghu̠me̠ni̠ oloko bho̠ id̠igh i̠ru̠ru̠an na̠ epura̠n d̠a̠ rologi d̠awa ma̠a̠, “Onon a̠fugh i̠basi̠ ola̠ a̠gboloma̠ ma̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ya̠a̠ A̠zizo̠s a̠loghom i̠ru̠ru̠an d̠awa, sa̠ a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere ka̠ inyin na̠ o̠ru̠ru̠an i̠karabh d̠a̠ rologi d̠inyin? ");
INSERT INTO mgj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Oken wa̠ a̠b̠ur a̠pu ma̠ ofugh bho̠, ‘Na̠ o̠we̠le̠man i̠karabh d̠oyom onigha̠ nyam,’ bo̠d̠o̠, ‘B̠etina̠ ma̠ a̠rile’? ");
INSERT INTO mgj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ya̠a̠ ami̠ na̠ a̠d̠ighi ma̠ agu̠o̠ ola̠ inyin ta̠ o̠mu̠gho̠nyan ma̠a̠ O̠nyi̠ ta̠ O̠ni̠ a̠nwuna̠ ma̠ a̠limon o̠we̠le̠man i̠karabh a̠nwunom d̠a̠ a̠de onon.” Sa̠ i̠na akparame̠ni̠ agba a̠nigha̠ ma̠ ukula̠ bho̠ ma̠a̠, “B̠etina̠, ma̠ a̠b̠eton a̠kporokporo d̠oyom ma̠ a̠ten a̠yel d̠a̠ otu d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sa̠ o̠ni̠ wa̠ na̠ a̠b̠ogina̠ bho̠ a̠b̠etina̠ a̠yel d̠a̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Igiel bho̠ o̠lo̠gh a̠nwunom bho̠ i̠bi̠gh abar wa̠ a̠mite bho̠, sa̠ a̠rugugu isibh awa, sa̠ i̠bu̠ghu̠me̠ni̠ ma̠ A̠zib̠a̠ wa̠ a̠nigha̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠ ma̠ a̠limon ya̠ o̠ku̠a bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Agu̠o̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ a̠d̠igh erile bho̠, sa̠ i̠na abi̠gh o̠ni̠ ola̠ ubhelegi ma̠ Amatiu, ka̠ od̠i ma̠ a̠dila̠de d̠a̠ e̠fe̠m ogun otua̠-ebhugh bho̠, sa̠ a̠bhelegi a̠fugh a̠nigha̠ i̠na ma̠a̠, “Tu̠o̠no̠me̠ ami̠.” Sa̠ Amatiu a̠b̠etina̠ epa̠ atu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sa̠ aro̠ ma̠ ola̠ agu̠o̠ i̠na od̠i d̠a̠ akpata od̠e d̠a̠ otu bho̠, sa̠ a̠d̠izo igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠karabh iru ra̠ id̠igh na̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ id̠e ma̠ ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sa̠ agu̠o̠ Rafarisi bho̠ i̠bi̠gh bho̠, sa̠ ipura̠n ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Ezin ka̠ ere, ka̠ o̠ni̠ atu̠ghu̠me̠ni̠ d̠inyin na̠ a̠d̠ed̠ia̠n igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠ka̠rabh?” ");
INSERT INTO mgj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","O̠mu̠gho̠n a̠pura̠n onon, sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Ogbo ya̠ a̠ruzu i̠ghu̠a bho̠ i̠bho̠ro̠ghan d̠o̠ ma̠ owil, ya̠a̠ ogbo ya̠ na̠ e̠nwe̠r bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","I̠se̠n, i̠gi̠e̠ ka̠ e̠tu̠ghan ezin abar wa̠ u̠gba ma̠a̠: ‘Ami̠ iba̠ra̠ ku ma̠ okpon igbirigbir, ya̠a̠ o̠kpe̠ alu̠kpe̠ d̠o̠.’ Ezin bho̠ ami̠ iru d̠o̠ ma̠ ra̠ olebh ib̠eb̠i a̠nwunom, ya̠a̠ id̠ighi ma̠ i̠karabh.” ");
INSERT INTO mgj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","D̠a̠ obhel obha̠ sa̠ ogbo atu̠ghan ta̠ Azo̠n iru ra̠ ipura̠n i̠na ma̠a̠, “Ezin ka̠ ere wa̠ Rafarisi bho̠ na̠ i̠yar na̠ o̠mar na̠ one ma̠ o̠ko̠i̠, ya̠a̠ ogbo atu̠ghan d̠oyom ine ani̠ d̠o̠ ma̠ o̠ko̠i̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Ogbo erogh bho̠ ta̠ e̠tu̠n ere e̠ro̠ d̠a̠ i̠ku̠nu̠ ma̠ obhel wa̠ o̠ni̠ erogh bho̠ od̠i na̠ awa bho̠? Ya̠a̠, igiel na̠ a̠ru ma̠ ola̠ ta̠ o̠si̠ghe̠ ma̠ o̠ni̠ erogh bho̠ d̠a̠ esa̠d̠io d̠awa, sa̠ awa ta̠ ene ma̠ o̠ko̠i̠ d̠a̠ ra̠d̠a̠ma̠ i̠ye̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“O̠ni̠ ola̠ na̠ a̠bhin o̠go̠go̠ra̠ omom ukpe na̠ ab̠ad̠i̠ ma̠ opupu akapa bo̠. Ezin bho̠, esi wa̠ u̠b̠ad̠i bho̠ ta̠ a̠puruna̠ ad̠u̠a d̠a̠ akapa bho̠ ma̠ ola̠ ta̠ agu̠an a̠peleni ma̠ agu̠o̠ aro̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Obha̠ agu̠o̠ ko o̠lo̠gh d̠o̠ ma̠ imom a̠min d̠a̠ opupu akana ozu e̠nam, bo̠d̠o̠ bha̠ akana ozu e̠nam bho̠ ta̠ a̠pol, sa̠ a̠min bho̠ ta̠ ezugia̠n ebhe, sa̠ akana bho̠ ta̠ api̠an. Kpe̠le̠me̠ni̠, na̠ o̠lo̠gh imom a̠min d̠a̠ imom rakana ozu e̠nam, sa̠ i̠wal a̠yi ta̠ ed̠um ebia̠.” ");
INSERT INTO mgj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Igiel bho̠ i̠na na̠ agba ma̠ i̠nye̠n bho̠, sa̠ odi o̠ni̠ irileghom u̠gala A̠zu bho̠ a̠ru, sa̠ a̠mel a̠kpud̠ia̠n d̠a̠ a̠misigh d̠o̠yo̠ a̠fugh ma̠a̠: “I̠se̠n i̠se̠n kisa̠ ekpo epobh o̠nyani̠ d̠ami̠ a̠sobha̠n. O̠ku̠a eka̠, tue ra̠ agbam agu̠o̠ d̠oyom d̠a̠ ozu d̠o̠yo̠, sa̠ i̠na ta̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um.” ");
INSERT INTO mgj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sa̠ A̠zizo̠s a̠b̠etina̠, sa̠ I̠na na̠ ogbo atu̠ghan d̠o̠yo̠ i̠tu̠o̠no̠m o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sa̠ odi ani̠ ola̠, na̠ a̠lei d̠iobh na̠ i̠wal (12) ala ya̠ asi̠ na̠ e̠gbo̠ d̠a̠ ozu, awo̠l d̠a̠ aman ka̠ a̠kula̠n esi wa̠ u̠labh akapa d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ezin bho̠ i̠na a̠fugh d̠a̠ ologi d̠o̠yo̠ ma̠a̠: “Ka̠ ami̠ irue ikula̠n akapa d̠o̠yo̠, sa̠ ami̠ ta̠ a̠d̠um.” ");
INSERT INTO mgj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sa̠ A̠zizo̠s a̠tiba̠ra̠ abi̠gh i̠na a̠fugh ma̠a̠, “O̠nyani̠ d̠ami̠, ologi d̠oyom akpo̠, ologi ima̠ra̠ d̠oyom na̠ a̠d̠umeni nyam.” Sa̠ ani̠ bho̠ a̠d̠um onin igiel obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sa̠ A̠zizo̠s agi̠ d̠a̠ otu o̠ni̠ irileghom bho̠ sa̠ abi̠gh ogbo ya̠ na̠ epughe ma̠ o̠za na̠ ogbo ya̠ na̠ e̠ko̠ro̠ na̠ eleghe. ");
INSERT INTO mgj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sa̠ a̠fugh ma̠a̠, “Itene ma̠ e̠d̠u̠a. O̠gbara o̠nyani̠ bho̠ na̠ omugh d̠o̠, i̠na na̠ a̠kod̠u a̠kod̠ua̠.” Sa̠ awa i̠ki̠ri̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Igiel bho̠ i̠na na̠ a̠ze ma̠ o̠lo̠gh a̠nwunom bho̠ a̠mutiom bho̠, sa̠ i̠na a̠d̠igh agi̠ ka̠ a̠sibh agu̠o̠ o̠gbara o̠nyani̠ bho̠, sa̠ i̠na a̠b̠etina̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Sa̠ o̠du̠ abar onon asasaragi̠an d̠a̠ eb̠la̠ ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sa̠ agu̠o̠ A̠zizo̠s a̠b̠etina̠ ma̠ i̠se̠ a̠d̠igh erile bho̠, sa̠ i̠wal a̠nwunom ikpom a̠rid̠ien i̠tu̠o̠no̠m i̠na, imulughu i̠le̠gh i̠na ma̠a̠, “O̠nyi̠ ta̠ A̠devidi, kpone i̠yar igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Igiel bho̠ i̠na a̠d̠igh d̠a̠ ologi otu bho̠, sa̠ a̠nwunom ikpom a̠rid̠ien bho̠ i̠gi̠ ka̠ i̠te̠i̠ i̠na, sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin oma̠ra̠ ma̠ ami̠ ta̠ a̠rue a̠gir abar onon ke̠re̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “Yii, Wa̠nwuna̠.” ");
INSERT INTO mgj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ebula̠ o̠ku̠a sa̠ i̠na a̠kula̠n a̠rid̠ien d̠awa a̠fugh ma̠a̠, “Aro̠ a̠nigha̠ inyin agu̠o̠ ologi ima̠ra̠ d̠inyin od̠i bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sa̠ a̠rid̠ien d̠awa i̠kpagi̠na. Sa̠ A̠zizo̠s anyagh ra̠to d̠awa ma̠a̠: “O̠ni̠ ko od̠ighi ma̠ agu̠o̠ ola̠ o̠ni̠ ta̠ a̠loghom.” ");
INSERT INTO mgj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Igiel bho̠ awa i̠d̠u̠a bho̠, sa̠ awa ibhin o̠du̠ ogir ilologia̠n ta̠ A̠zizo̠s i̠gba i̠sasaragi̠ d̠a̠ eb̠la̠ ebhugh obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Igiel bho̠ awa na̠ e̠d̠u̠a ma̠ i̠se̠ bho̠, sa̠ ubhin o̠ni̠ ola̠ eru na̠ a̠tenemeni ma̠ emua̠ ka̠ i̠te̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sa̠ i̠na a̠ze ma̠ eru bho̠ asi̠ghe̠, sa̠ emua̠ o̠ni̠ bho̠ ake̠ ma̠ ofugh abar, sa̠ o̠lo̠gh a̠nwunom bho̠ ib̠a̠gha̠gha̠ ifugh ma̠a̠: “Abar ola̠ o̠ko̠no̠n ta̠ od̠ia̠ d̠o̠ a̠mite d̠a̠ Izre̠l.” ");
INSERT INTO mgj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ya̠a̠ Rafarisi bho̠ i̠gba ma̠a̠: “I̠na na̠ a̠bhin a̠limon ta̠ eru na̠ a̠ze ma̠ a̠ruru.” ");
INSERT INTO mgj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sa̠ A̠zizo̠s ad̠u̠a ma̠ ibom re̠ma a̠ten i̠gbara re̠ma, atu̠ghu̠me̠ni̠ d̠a̠ ru̠gala d̠awa, sa̠ a̠b̠om okpokpo ib̠eb̠i asu̠gbagba irileghom bho̠, sa̠ a̠koko ma̠ a̠d̠ien kere kere rasu̠nwe̠r na̠ a̠d̠ien kere kere ali̠gam a̠ruzu. ");
INSERT INTO mgj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Obhel bho̠ i̠na abi̠gh o̠lo̠gh a̠nwunom bho̠, sa̠ igbirigbir awa id̠ighi i̠na. Ezin bho̠, ali̠gam a̠ruzu d̠awa na̠ ebuiy ka̠ e̠te̠i̠ esi ola̠ na̠ e̠tabh awa, ma̠ agu̠o̠ ro̠nana ya̠ onwuna̠ d̠o̠ ma̠ o̠ni̠ ola̠ okponom. ");
INSERT INTO mgj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","D̠a̠ igiel obha̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠: “Ya̠gia̠ga̠i, ed̠ia̠n ya̠ ob̠u bho̠ eb̠uiy, ya̠a̠, ogbo ogir bho̠ ib̠uiy d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","O̠ku̠a a̠d̠ighi be̠le̠ni̠, isiseinye ma̠ Wa̠nwuna̠ ma̠ ib̠ua̠ bho̠, ma̠ agu̠o̠ ola̠ i̠na ta̠ afi̠ri̠ma ma̠ ogbo ogir alo̠gho̠m d̠a̠ ogir ob̠u ed̠ia̠n d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sa̠ A̠zizo̠s a̠kokod̠i d̠iobh na̠ i̠wal ogbo atu̠ghan d̠o̠yo̠, sa̠ a̠nigha̠ awa ma̠ a̠limon ola̠ ebhin oze i̠karabh aru̠mu̠gh o̠si̠ghe̠gi̠ na̠ okoko a̠d̠ien kerekere rasu̠nwe̠r na̠ kerekere a̠d̠ien ali̠gam a̠ruzu. ");
INSERT INTO mgj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I̠nye̠n bha̠ a̠rid̠ien a̠d̠iobh na̠ i̠wal ogbo ogir bho̠. O̠pu̠r bho̠ bha̠ Asai̠mo̠n, wa̠ ubhelegi ma̠ A̠pita̠ bho̠, na̠ Anduru umor d̠o̠yo̠, na̠ A̠zemsi o̠nyi̠ ta̠ Aze̠bidi na̠ Azo̠n umor d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","A̠filip na̠ Abatolomio, Ato̠mo̠si̠ na̠ Amatiu ogun ma̠ otua̠ ebhugh bho̠, A̠zemsi o̠nyi̠ ta̠ Ali̠fi̠o̠s na̠ Atadi̠o̠s, ");
INSERT INTO mgj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Asai̠mo̠n wa̠ A̠kenan bho̠, na̠ A̠zuda̠s o̠nyi̠ ta̠ I̠skari̠o̠t, wa̠ ra̠ a̠wol I̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","D̠iobh na̠ i̠wal i̠nye̠n bha̠ ya̠ A̠zizo̠s a̠nigha̠ ma̠ a̠limon sa̠ a̠du a̠mutiom bho̠. Kisa̠ i̠na a̠du awa a̠mutiom, i̠na a̠kikiom awa a̠fugh ma̠a̠: “O̠ni̠ ka̠ o̠gi̠ d̠a̠ Ibhebhia̠n bho̠, ka̠ od̠igh nyen d̠a̠ e̠ma Asameria̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ya̠a̠ i̠gi̠e̠ ku̠ d̠a̠ ro̠nana ebhugh Izre̠l ya̠ na̠ ebhe bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","I̠gi̠e̠ ka̠ ob̠om okpokpo ma̠a̠: ‘Irileghom ote̠nai̠ny na̠ a̠tua̠n.’ ");
INSERT INTO mgj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ikoko ma̠ ogbo asu̠nwe̠r, ib̠egione ma̠ imumugh a̠nwunom, i̠b̠ab̠alame̠ni̠ ma̠ ogbo ya̠ na̠ e̠nwe̠r asu̠nwe̠r ekid̠igh, ize ma̠ a̠ruru ma̠ e̠si̠ghe̠gi̠. Inyin u̠te̠i̠ i̠kpo̠, inigha̠ nyen i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“O̠ni̠ ka̠ o̠b̠ar na̠ okpoki, bo̠d̠o̠ o̠ni̠ ka̠ o̠kpo̠a ma̠ o̠kara ikpoki d̠inyin, ");
INSERT INTO mgj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","a̠d̠igh e̠kpa e̠gi̠, bo̠d̠o̠ akapa onwegina̠, bo̠d̠o̠ agbaka bo̠d̠o̠ okpeti i̠ki̠ani̠. O̠ni̠ ogir bho̠ akpe̠ ma̠ o̠te̠i̠ ed̠ia̠n ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ke̠ma ke̠ma ola̠ inyin ud̠igh, ipura̠ne ma̠ wa̠ a̠sora̠n d̠a̠ e̠ma bho̠ ma̠ esul e̠ro̠ ma̠ i̠se̠ tu̠tu̠n inyin ta̠ o̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Id̠ighe ma̠ ebheleguma̠ ma̠ a̠nwunom ya̠ od̠i d̠a̠ otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sa̠ ku̠gba ma̠ a̠nwunom ya̠ od̠i d̠a̠ otu bho̠ a̠d̠ighom inyin, bha̠ ekima̠ d̠inyin a̠d̠igh d̠a̠ otu bho̠. Ya̠a̠ ku̠gba ma̠ awa id̠ighom d̠o̠ inyin, bha̠ ekima̠ d̠inyin a̠mula̠ aro̠ na̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ku̠gba ma̠a̠ o̠ni̠ na̠ o̠da d̠o̠ inyin a̠bhin, bo̠d̠o̠ na̠ o̠nagha d̠o̠ ma̠ atu̠ghu̠me̠ni̠ d̠inyin, bha̠ ikpukpu ma̠ ibhugh d̠a̠ e̠b̠ab̠a a̠sike d̠inyin ma̠ esorogi d̠a̠ otu bho̠ bo̠d̠o̠ d̠a̠ e̠ma bho̠ ma̠ eten e̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ya̠gia̠ga̠i, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, ta̠ okpon igbirigbir Aso̠do̠m na̠ A̠gomora opu ma̠ e̠ma obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iloghome! Ami̠ na̠ a̠du inyin na̠ a̠mutiom na̠ a̠limon, ma̠ agu̠o̠ ro̠nana d̠a̠ esa̠d̠io i̠gagaman i̠nam. O̠ku̠a a̠d̠ighi be̠le̠ni̠, inwuna̠ ma̠ eloghom abar ma̠ agu̠o̠ i̠karabh i̠di̠ar, ya̠a̠ ikima̠ ma̠ agu̠o̠ rukur osege. ");
INSERT INTO mgj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iloghoma̠ne ma̠a̠; a̠nwunom ta̠ eb̠ologh inyin e̠gi̠o̠m d̠a̠ ri̠gada ase̠ d̠a̠ re̠ma bho̠, sa̠ ta̠ e̠gu̠ro̠gh inyin d̠a̠ ru̠gala d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sa̠ ta̠ edin ami̠ ebhin inyin e̠gi̠o̠m Aru̠li̠le̠ma, na̠ ogbo aru̠mu̠ rebhugh bho̠, sa̠ obha̠ ta̠ a̠mutiom e̠ti̠ti̠gha ola̠ inyin ta̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ onigha̠ awa, na̠ ogbo ya̠ ologhom d̠o̠ ma̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ya̠a̠ igiel ib̠eton inyin unigha̠ awa, o̠ni̠ ko o̠nyo̠gho̠ghan egboloma̠ ma̠ agu̠o̠ o̠gba o̠nu̠, bo̠d̠o̠ iya̠ o̠gba, ezin bho̠ ta̠ onigha̠ inyin onin obhel obha̠ ma̠ iya̠ o̠gba. ");
INSERT INTO mgj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ezin bho̠, inyin na̠ agu̠o̠ ko ofugh d̠o̠, ya̠a̠ E̠mu̠gh ta̠ O̠we̠de̠ d̠inyin ta̠ awo̠l d̠a̠ aru̠nu̠ d̠inyin agba. ");
INSERT INTO mgj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Sa̠ umor ta̠ a̠wol umor ma̠ agu̠o̠ ola̠ ta̠ ogigh, sa̠ o̠we̠de̠ ta̠ a̠wol o̠nyi̠, sa̠ anwi̠i̠ny ta̠ ewia̠n ro̠we̠de̠ ma̠ o̠ze̠gi̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sa̠ ko̠ni̠ ko̠ni̠ ta̠ a̠din a̠d̠ien d̠ami̠ alo̠gh inyin a̠d̠ien, ya̠a̠ o̠ni̠ wa̠ a̠ne ka̠ ate̠i̠ d̠a̠ ekunuguma̠ bho̠ ta̠ a̠ten. ");
INSERT INTO mgj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Sa̠ obhel ola̠ na̠ ogbikimeni inyin d̠a̠ odi e̠ma, bha̠ ighile ma̠ e̠gi̠ d̠a̠ opa̠n e̠ma. Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, inyin ka̠ orue d̠o̠ orile d̠a̠ re̠ma Izre̠l e̠b̠e̠i̠, kisa̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","O̠ni̠ atu̠ghan na̠ opu d̠o̠ ma̠ o̠ni̠ atu̠ghu̠me̠ni̠ d̠o̠yo̠, obha̠ agu̠o̠ e̠bana opu d̠o̠ ma̠ wa̠nwuna̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A̠sora̠n o̠ni̠ atu̠ghan bho̠ ma̠ o̠ro̠ ka̠ o̠ni̠ atu̠ghu̠me̠ni̠ d̠o̠yo̠, na̠ e̠bana bho̠ ma̠ o̠ro̠ ka̠ wa̠nwuna̠ d̠o̠yo̠. Ku̠gba ma̠a̠ na̠ obhelegi ma̠ wa̠nwuna̠ ma̠ otu bho̠ ma̠ Abe̠lzibul, ere wa̠ ka̠ obhelegi d̠o̠ ma̠ eghun otu d̠o̠yo̠ ma̠ a̠d̠ien ola̠ a̠gurom a̠pu ma̠ o̠ku̠a bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, ko oghil awa, ezin bho̠ abar ola̠ ukpegi ola̠ ko omite d̠o̠ ma̠ e̠ma bo̠, bo̠d̠o̠ ola̠ odi d̠a̠ e̠wo̠gi̠na ola̠ ko ologhom d̠o̠ bo̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Abar ola̠ ami̠ i̠gba inigha̠ inyin d̠a̠ azi̠m, bha̠ i̠gba ma̠ emutiom d̠a̠ e̠b̠alab̠al, sa̠ abar ola̠ ami̠ ibhobhola̠ inigha̠ inyin d̠a̠ a̠to, ib̠ome ma̠ okpokpo ma̠ e̠gba ma̠ e̠sasaragi̠ d̠a̠ anyu̠ a̠rutu. ");
INSERT INTO mgj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ko oghil ogbo ya̠ na̠ egigh ipulupul ozu bho̠, ya̠a̠ ko orue d̠o̠ egigh eloghoma̠n ozu bho̠. Ya̠a̠, kpe̠le̠me̠ni̠, ighile ku ma̠ wa̠ ta̠ a̠rue api̠e̠gi̠ ma̠ eloghoma̠n ozu bho̠, na̠ ipulupul ozu bho̠, d̠a̠ e̠banya bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Uwol d̠o̠ ma̠ i̠wal ro̠gi̠e̠ ta̠ egule ma̠ ape̠ni̠ ke̠re̠? Ku̠ku̠m eka̠, odi i̠se̠ na̠ omel d̠o̠ d̠a̠ a̠de ma̠ ola̠ O̠we̠de̠ d̠inyin ko ologhom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ya̠a̠, ikpo asi̠ghal e̠mu̠ d̠inyin bho̠ eka̠ A̠zib̠a̠ a̠loghom o̠nu̠ o̠wal bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko oghil a̠rugugu; inyin ulei abar opu, ma̠ o̠lo̠gh ro̠gi̠e̠ ta̠ egule. ");
INSERT INTO mgj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“O̠ni̠ ola̠ agba ami̠ a̠mutiom d̠a̠ a̠misigh a̠nwunom, obha̠ agu̠o̠ ami̠ ta̠ agba ani̠ i̠na a̠mutiom d̠a̠ a̠misigh O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ya̠a̠, o̠ni̠ ola̠ aku̠a ami̠ d̠a̠ a̠misigh a̠nwunom, obha̠ agu̠o̠ ami̠ ta̠ aku̠a ani̠ i̠na d̠a̠ a̠misigh O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“O̠ni̠ ko o̠ru̠ru̠an ma̠a̠, ami̠ iru ra̠ omutiom ekima̠ onigha̠ e̠mara̠nwunom onon, ya̠a̠ ami̠ ibhin alapogidia̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ezin bho̠, ami̠ iru ma̠ o̠bagi̠o̠n, “ ‘O̠nyi̠ ta̠ a̠wia̠n o̠we̠de̠, sa̠ o̠nyani̠ ta̠ a̠wia̠n onweni, sa̠ o̠yo̠go̠-o̠nyani̠ ta̠ a̠wia̠n o̠yo̠go̠-onweni, ");
INSERT INTO mgj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","sa̠ ogbo a̠ghisia̠n o̠ni̠ ta̠ e̠lo̠gh a̠d̠ien o̠ni̠ bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“O̠ni̠ ola̠ a̠tula̠n onweni bo̠d̠o̠ o̠we̠de̠ a̠pu ami̠, na̠ o̠kpe̠ d̠o̠ ma̠ o̠ro̠ o̠ni̠ i̠tu̠o̠no̠m d̠ami̠. Sa̠ ola̠ a̠tula̠n o̠nyani̠ o̠nyi̠ bo̠d̠o̠ olobhiri o̠nyi̠ d̠o̠yo̠ a̠pu ami̠ eka̠, na̠ o̠kpe̠ d̠o̠ ma̠ o̠ro̠ o̠ni̠ i̠tu̠o̠no̠m d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sa̠ o̠ni̠ ola̠ orol d̠o̠ ma̠ e̠mi̠gi̠re̠ni̠an oriren d̠o̠yo̠ atu̠o̠no̠m ami̠, o̠kpe̠ d̠o̠ ma̠ o̠ro̠ o̠ni̠ i̠tu̠o̠no̠m d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","O̠ni̠ wa̠ a̠kighom a̠ghud̠um d̠o̠yo̠ bho̠, ta̠ a̠robh a̠ghud̠um d̠o̠yo̠. Ya̠a̠ o̠ni̠ wa̠ atu̠n ami̠ a̠robh a̠ghud̠um d̠o̠yo̠ bho̠, ta̠ ate̠i̠ a̠ghud̠um.” ");
INSERT INTO mgj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“O̠ni̠ ola̠ ada inyin a̠bhin, bha̠ ada ami̠ a̠bhin. Sa̠ o̠ni̠ ola̠ ada ami̠ a̠bhin, ada ma̠ o̠ni̠ wa̠ a̠ruom ami̠ bho̠ a̠bhin nyen. ");
INSERT INTO mgj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","O̠ni̠ ola̠ ada ma̠ owil a̠bhin d̠a̠ ebula̠ agu̠o̠ aro̠ ma̠ owil bho̠, ta̠ ate̠i̠ a̠d̠ien amu̠kpe̠ ya̠ owil na̠ ate̠i̠ bho̠. Sa̠ o̠ni̠ ola̠ ada ma̠ ob̠eb̠i o̠ni̠ a̠bhin d̠a̠ ebula̠ agu̠o̠ aro̠ ma̠ ob̠eb̠i o̠ni̠ bho̠, ta̠ ate̠i̠ a̠d̠ien amu̠kpe̠ ya̠ ob̠eb̠i o̠ni̠ na̠ ate̠i̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ a̠nigha̠ ma̠ odi o̠ni̠ atu̠ghan d̠ami̠ wa̠ aki̠r a̠pu bho̠ eka̠ ma̠ okpa̠ko eb̠ob̠okum amu̠m, ko o̠we̠le̠ d̠o̠ ma̠ o̠te̠i̠ amu̠kpe̠ d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Igiel bho̠ A̠zizo̠s na̠ a̠kikiom d̠iobh na̠ i̠wal ogbo atu̠ghan d̠o̠yo̠ awe̠le̠ bho̠, sa̠ i̠na ad̠u̠a ma̠ i̠se̠, ka̠ atu̠ghu̠me̠ni̠ agba ma̠ ib̠eb̠i asu̠gbagba bho̠ d̠a̠ re̠ma ya̠ itua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Igiel bho̠ Azo̠n aro̠ d̠a̠ ikoli amu̠gho̠n i̠di̠ar ya̠ Akrai̠st na̠ a̠gir bho̠, sa̠ a̠ruom ogbo atu̠ghan d̠o̠yo̠ ma̠ o̠gi̠, ");
INSERT INTO mgj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ka̠ opura̠n o̠yo̠ ma̠a̠, “Anwa o̠ni̠ wa̠ na̠ a̠ru bho̠ ke̠re̠, bo̠d̠o̠ ka̠ i̠yar ogon opa̠n o̠ni̠?” ");
INSERT INTO mgj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “I̠gi̠e̠ ka̠ e̠gba ma̠ enigha̠ ma̠ Azo̠n i̠di̠ar ya̠ inyin na̠ o̠bi̠gh bho̠, sekina̠ ya̠ inyin na̠ o̠mu̠gho̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ogbo ya̠ ikpom a̠rid̠ien bho̠, na̠ e̠bi̠gh esi, a̠rukula̠ bho̠ na̠ erile, ogbo ya̠ na̠ e̠nwe̠r asu̠nwe̠r ekid̠igh bho̠ na̠ okoko o̠b̠ab̠alame̠ni̠, remua̠ bho̠ na̠ e̠mu̠gho̠n abar, imumugh a̠nwunom na̠ ob̠egion, sa̠ na̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ na̠ onigha̠ ma̠ ronyigoiny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Itutumeni e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ o̠tu̠n d̠o̠ ma̠ rogir ya̠ ami̠ na̠ a̠gir bho̠ a̠ghel ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Igiel bho̠ awa na̠ e̠d̠u̠a bho̠, sa̠ A̠zizo̠s ake̠ ma̠ o̠gba i̠di̠ar ya̠ igboloma̠ ma̠ Azo̠n owurma̠mu̠m bho̠ onigha̠ o̠lo̠gh a̠nwunom bho̠ ma̠a̠: “Inyin u̠gi̠ d̠a̠ e̠sala bho̠, ka̠ inyin u̠ru̠ru̠an o̠bi̠gh ere? Ikpoko ya̠ na̠ eduka̠ d̠a̠ o̠fe̠gu̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ku̠gba ma o̠ku̠a d̠o̠, ka̠ inyin u̠ru̠ru̠an ka̠ o̠bi̠gh o̠ni̠ ola̠ na̠ a̠bura̠ ma̠ ibura̠ e̠no̠gho̠man ke̠re̠? Iloghome ma̠ ogbo ya̠ na̠ ebura̠ ma̠ ibura̠ e̠no̠gho̠man, na̠ erugh d̠a̠ rogigo Aru̠li̠le̠ma! ");
INSERT INTO mgj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya̠a̠, inyin u̠tu̠n ka̠ o̠bi̠gh ere o̠gi̠? Owil ke̠re̠? Yii, owil ga̠i, ya̠a̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ a̠pu ma̠ owil. ");
INSERT INTO mgj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Onon o̠ni̠ wa̠ u̠ge̠ ugboloma̠ bho̠ ma̠a̠: “ ‘Ami̠ ta̠ a̠ruom o̠ni̠ a̠duom d̠ami̠ ma̠ od̠ia̠ o̠gi̠ kisa̠ anwa ta̠ a̠ru, ma̠ o̠tu̠ghu̠man eten d̠oyom ob̠a̠ra̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, d̠a̠ ogbo ya̠ anwani̠ i̠maragi̠ bho̠, o̠ni̠ ola̠ abu̠gh a̠pu ma̠ Azo̠n owurmamu̠m bho̠ ta̠ omite d̠o̠; ya̠a̠ o̠ni̠ wa̠ aki̠r a̠pu d̠a̠ irileghom ote̠nai̠ny bho̠, abu̠gh a̠pu i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ob̠eton d̠a̠ amu̠m ta̠ Azo̠n owurmamu̠m bho̠ ra̠ o̠te̠i̠ i̠se̠n, irileghom ote̠nai̠ny na̠ asu̠ ma̠ onyen o̠kparakpar agu̠o̠, sa̠ i̠kparakpar a̠nwunom ku̠ku̠m na̠ ewia̠n na̠ e̠te̠i̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kisa̠ Azo̠n ta̠ a̠ru, eb̠la̠ a̠riwil bho̠ ewa̠ sa̠ oloko bho̠ eka̠ agba a̠gboloma̠ ma̠ irileghom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sa̠, ku̠gba ma̠a̠ inyin ta̠ o̠da ma̠ asu̠gbagba d̠ami̠ obhin, bha̠ ima̠ra̠ ma̠a̠, i̠na I̠lai̠za wa̠ a̠riwil bho̠ iwa̠ ma̠a̠ ta̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","“Wa̠nwuna̠ ma̠ a̠to, anagha o!” ");
INSERT INTO mgj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“I̠se̠n, ka̠ ta̠ obhin amu̠m onon atu̠o̠m ere? Awa od̠i ma̠ agu̠o̠ i̠gbara anwi̠i̠ny, ya̠ od̠i ma̠ a̠dila̠de d̠a̠ egbolom a̠b̠ua̠, sa̠ odi na̠ a̠kele ma̠ odi ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘I̠yar upughe ma̠ od̠od̠ue onigha̠ inyin, ya̠a̠ inyin u̠ghe̠r d̠o̠ ma̠ i̠gba, I̠yar u̠mo̠r aso̠r ekulom, ya̠a̠ inyin u̠ku̠nu̠ d̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Azo̠n a̠ru bho̠, na̠ od̠e d̠o̠ ma̠ ed̠ia̠n, na̠ o̠d̠a d̠o̠ ma̠ a̠min nyen, sa̠ inyin u̠gba ma̠a̠: ‘Eru na̠ ab̠am.’ ");
INSERT INTO mgj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","O̠nyi̠ ta̠ O̠ni̠ a̠ru bho̠, na̠ a̠d̠e na̠ ad̠a, sa̠ inyin na̠ o̠gba ma̠a̠, ‘I̠bi̠ghe̠ ma̠ o̠d̠o̠gho̠d̠o̠gh na̠ o̠d̠a ma̠ a̠min onon, wa̠ na̠ a̠rologha̠n igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠karabh bho̠.’ Yaa̠, od̠ighi i̠di̠ar o̠ni̠ na̠ eleriom eloghom abar o̠ni̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","D̠a̠ obhel obha̠, sa̠ A̠zizo̠s ake̠ ma̠ osugi re̠ma ya̠ i̠na a̠gir ibom ilologia̠n bho̠, ezin bho̠ awa ima̠ra̠ d̠o̠ ma̠ otiba̠ra̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ekulom inyin a̠nwunom A̠kora̠zin! Ekulom inyin a̠nwunom Abe̠tsai̠da! Ezin bho̠, ilologia̠n ya̠ ugir unigha̠ inyin bho̠ ma̠ ugir onigha̠ ma̠ Ataya na̠ Asi̠do̠n nab̠o̠, awa ka̠ i̠lo̠gi̠an akapa i̠ku̠nu̠, sa̠ ka̠ ibhugha̠ ma̠ i̠ru̠ru̠ etiba̠ra̠ ka̠ ob̠om igiel. ");
INSERT INTO mgj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","O̠ku̠a eka̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ta̠ okpon igbirigbir Ataya na̠ Asi̠do̠n opu inyin d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya̠a̠, inyin a̠nwunom Akapanu̠m, ta̠ o̠bu̠ghu̠me̠ni̠ inyin d̠a̠ ote̠nai̠ny ke̠re̠? E̠nyi̠, ta̠ orobh inyin osoroni d̠a̠ ekud̠um a̠de imumugh bho̠. Ezin bho̠, ilologia̠n ya̠ ugir unigha̠ inyin bho̠, ma̠a̠ ugir d̠a̠ e̠ma Aso̠do̠m nab̠o̠, e̠ma bho̠ ka̠ i̠ro̠ ate̠i̠ a̠didon. ");
INSERT INTO mgj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","O̠ku̠a eka̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ta̠ okpon igbirigbir a̠nwunom Aso̠do̠m opu inyin d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","D̠a̠ onin obhel obha̠, sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Ami̠ na̠ ase̠bh anwa O̠we̠de̠ Wa̠nwuna̠ ma̠ ote̠nai̠ny na̠ a̠de. Ezin bho̠ anwa i̠wo̠gi̠o̠m i̠nye̠n iloghodi̠ar bho̠ sekina̠ iloghod̠ire bho̠, sa̠ anwa ileriom kuma̠ ogbo ya̠ olei d̠o̠ ma̠ i̠d̠iar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ya̠ga̠i, a̠sora̠n O̠we̠de̠. Ezin bho̠, a̠d̠igh anwa ma̠ ologi ma̠ o̠to̠ oguri o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“O̠we̠de̠ d̠ami̠ na̠ a̠nigha̠ ami̠ ma̠ eb̠la̠ i̠di̠ar. O̠ni̠ ola̠ a̠loghom O̠nyi̠ bho̠ bo̠, a̠ten O̠we̠de̠ bho̠. Obha̠ agu̠o̠ o̠ni̠ ola̠ a̠loghom O̠we̠de̠ bho̠ o̠ro̠ d̠o̠, a̠ten O̠nyi̠ bho̠, na̠ a̠nwunom ya̠ O̠nyi̠ bho̠ ato̠ ma̠ obhin O̠we̠de̠ bho̠ oleriom. ");
INSERT INTO mgj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Itue d̠ami̠, eb̠la̠ inyin ya̠ a̠ruzu na̠ edughogh, sa̠ a̠dol na̠ e̠ne̠mu̠o̠m bho̠, sa̠ ami̠ ta̠ a̠nigha̠ inyin osira̠ epobh. ");
INSERT INTO mgj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ib̠etone ma̠ a̠dol d̠a̠ ami̠ ma̠ erol, ma̠ e̠tu̠ghan d̠a̠ agu̠o̠ d̠ami̠, ezin bho̠ ami̠ o̠ni̠ ola̠ inwuna̠ ma̠ ologi ekima̠ na̠ ozuruna̠ eghoi, sa̠ reloghoma̠n a̠ruzu d̠inyin ta̠ e̠ro̠ na̠ ekima̠. ");
INSERT INTO mgj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ezin bho̠ o̠tu̠o̠no̠m ami̠ ob̠ub̠ura̠n abar, sa̠ a̠dol d̠ami̠ a̠bhobhogh.” ");
INSERT INTO mgj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","D̠a̠ igiel obha̠, A̠zizo̠s na̠ a̠ten d̠a̠ ari̠si̠ i̠bu̠kpa ma̠ A̠d̠a̠ma̠ Osirepobh bho̠, ya̠a̠ o̠ko̠i̠ na̠ a̠d̠ighi ma̠ ogbo atu̠ghan d̠o̠yo̠, sa̠ i̠ke̠ ma̠ ob̠oghi itu i̠bu̠kpa bho̠ o̠kpi̠r od̠e. ");
INSERT INTO mgj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Igiel bho̠ Rafarisi bho̠ i̠bi̠gh bho̠, sa̠ ifugh inigha̠ i̠na ma̠a̠, “Bi̠ghe̠, ogbo atu̠ghan d̠oyom na̠ egir abar ola̠ oloko bho̠ oma̠ra̠ d̠o̠ ma̠ a̠nwunom ogir d̠a̠ a̠d̠a̠ma̠ osira̠-epobh bho̠” ");
INSERT INTO mgj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin ta̠ osen d̠o̠ o̠bi̠gh d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ ma̠ abar wa̠ A̠devidi a̠gir igiel bho̠ o̠ko̠i̠ a̠d̠ighi i̠na sekina̠ a̠nwunom d̠o̠yo̠ bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ma̠ agu̠o̠ i̠na a̠d̠igh d̠a̠ otu akpu̠ru̠ ta̠ A̠zib̠a̠ ka̠ a̠d̠e ma̠ abe̠re̠di̠ ya̠ o̠kpe̠ d̠o̠ i̠na, bo̠d̠o̠ a̠nwunom d̠o̠yo̠ ma̠ od̠e, ya̠ i̠ro̠ inigha̠ ma̠ rokur ta̠ A̠zib̠a̠ ku̠ku̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bo̠d̠o̠, inyin ta̠ osen d̠o̠ d̠a̠ oloko bho̠, ma̠ agu̠o̠ rokur i̠ro̠ d̠a̠ Otu ta̠ A̠zib̠a̠ i̠pi̠o̠gho̠m A̠d̠a̠ma̠ Osirepobh bho̠, ya̠a̠ o̠bi̠gh d̠o̠ ma̠ awa esor oloko bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, abar ola̠ a̠pu ma̠ Otu ta̠ A̠zib̠a̠ od̠i ma̠ i̠se̠n. ");
INSERT INTO mgj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","I̠se̠ ma̠ inyin uloghom ezin abar wa̠ u̠gba ma̠a̠: ‘Ami̠ iba̠ra̠ kuma̠ okpon igbirigbir, ya̠ i̠ko̠l d̠o̠,’ nab̠o̠, inyin ka̠ usobh d̠o̠ ma̠ ase̠ obhumeni ma̠ o̠ni̠ wa̠ o̠pi̠o̠gho̠m d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ wa̠nwuna̠ ma̠ A̠d̠a̠ma̠ Osirepobh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A̠zizo̠s ad̠u̠a ma̠ i̠se̠ sa̠ agi̠ ka̠ a̠d̠igh d̠a̠ u̠gala A̠zu bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sa̠ abi̠gh o̠ni̠ ola̠ agu̠o̠ bho̠ na̠ akpari̠an. Sa̠ awa ipura̠n A̠zizo̠s ma̠a̠, “A̠sora̠n okoko o̠ni̠ ma̠ A̠d̠a̠ma̠ Osirepobh bho̠ ke̠re̠?” Awa ipura̠n o̠ku̠a bo̠ka̠ awa ta̠ e̠bi̠gh e̠kal ola̠ obhin oler o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sa̠ i̠na awo̠ran awa ma̠a̠, “A̠nyen o̠ni̠ inyin ola̠ a̠nwuna̠ ma̠ o̠nana, sa̠ ku̠gba ma̠ a̠mel a̠d̠igh d̠a̠ ogugua̠ ma̠ A̠d̠a̠ma̠ Osirepobh bho̠, sa̠ i̠na ka̠ o̠gi̠o̠m d̠o̠ ma̠ agu̠o̠ ka̠ a̠sibh a̠mutiom? ");
INSERT INTO mgj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","O̠nyi̠o̠mo̠ro̠ni̠ na̠ olei d̠o̠ ma̠ abar a̠pu ma̠ o̠nana ke̠re̠? O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠sora̠n ogir ib̠eb̠i ma̠ A̠d̠a̠ma̠ Osirepobh.” ");
INSERT INTO mgj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sa̠ A̠zizo̠s agba a̠nigha ma̠ o̠ni̠ bho̠ ma̠a̠, “Selegheni ma̠ agu̠o̠ d̠oyom.” Sa̠ o̠ni̠ bho̠ a̠selegheni, sa̠ agu̠o̠ bho̠ a̠bhon aro̠ ma̠ agu̠o̠ uwed̠i. ");
INSERT INTO mgj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sa̠ Rafarisi bho̠ i̠d̠u̠a ka̠ i̠mimia̠n igboloma̠ ma̠ agu̠o̠ ogigh o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ya̠a̠ A̠zizo̠s a̠loghoma̠n sa̠ ad̠u̠a ma̠ i̠se̠, sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m I̠na, sa̠ a̠koko ma̠ eb̠la̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sa̠ a̠kikiom awa ma̠a̠ od̠ighi̠ d̠o̠ ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ eloghom ya̠ igboloma̠ I̠na. ");
INSERT INTO mgj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ma̠ agu̠o̠ ola̠ omuzoghod̠iom iwowa̠ ta̠ owil Azaya bho̠ ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Obha̠ ob̠a̠ra̠motu d̠ami̠ wa̠ ami̠ i̠so̠n bho̠, o̠ni̠ wa̠ ami̠ itula̠n bho̠, wa̠ na̠ a̠bhonomeni ma̠ ologi d̠ami̠ bho̠; Ami̠ ta̠ alo̠gh E̠mu̠gh d̠ami̠ d̠a̠ ozu d̠o̠yo̠, sa̠ ta̠ a̠sobh a̠ga̠i ase̠ a̠nigha̠ ma̠ rebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I̠na ko o̠b̠u̠man d̠o̠ ma̠ o̠b̠e̠m, bo̠d̠o̠ omulughu izul, o̠ni̠ ko o̠mu̠gho̠n d̠o̠ ma̠ okoroko d̠o̠yo̠ d̠a̠ reten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I̠na ko onwinigi d̠o̠ ma̠ ikpoko ya̠ na̠ e̠nyu̠bhi̠an, sa̠ i̠na ko od̠imigi d̠o̠ ma̠ i̠tani̠ ola̠ na̠ a̠ru ra̠ od̠im nyen, tu̠tu̠n i̠na ta̠ a̠bhin d̠a̠ igielake̠ a̠sobh ase̠ a̠nigha̠ ma̠ a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sa̠ rebhugh bho̠ ta̠ eb̠em ologi d̠a̠ a̠d̠ien d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","D̠a̠ igiel obha̠ sa̠ idi a̠nwunom ibhin o̠ni̠ ola̠ o̠karabh e̠mu̠gh na̠ anyo̠gho̠gh, ola̠ aro̠ ma̠ emua̠ ola̠ a̠rid̠ien na̠ eb̠omia̠n nyen, iruom i̠na. Sa̠ i̠na a̠koko ma̠ o̠ni̠ bho̠, sa̠ o̠ni̠ bho̠ ake̠ ma̠ ofugh abar, o̠bi̠gh esi. ");
INSERT INTO mgj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sa̠ a̠d̠igh ilologia̠n o̠lo̠gh a̠nwunom bho̠, sa̠ na̠ epupura̠n ma̠a̠, “Onon ko o̠ro̠ d̠o̠ ma̠ o̠nyi̠ ta̠ A̠devidi ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ya̠a̠, igiel bho̠ Rafarisi bho̠ i̠mu̠gho̠n bho̠, sa̠ ifugh ma̠a̠, “I̠na na̠ a̠bhin a̠limon ta̠ Abe̠lzibul, we̠mu̠ a̠ruru bho̠ na̠ a̠ze ma̠ i̠karabh aru̠mu̠gh.” ");
INSERT INTO mgj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ya̠a̠ agu̠o̠ A̠zizo̠s a̠loghom i̠ru̠ru̠an d̠awa bho̠, sa̠ agba a̠nigha̠ awa ma̠a̠, “Irileghom ola̠ aru̠gi̠an na̠ a̠wia̠n ozu d̠o̠yo̠ ta̠ ago̠gu̠an a̠mel, sa̠ e̠ma bo̠d̠o̠ eghun otu ola̠ na̠ a̠wia̠n ozu d̠o̠yo̠ ko o̠mara d̠o̠ gigiribh. ");
INSERT INTO mgj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sa̠ ku̠gba ma̠ Eru bho̠ na̠ a̠ze ma̠ Eru bho̠ na̠ asi̠ghe̠, sa̠ i̠na na̠ agu̠o̠ na̠ a̠wia̠n ozu d̠o̠yo̠ na̠ aru̠gi̠an! O̠ku̠a ka̠ irileghom d̠o̠yo̠ ta̠ a̠d̠ighi eka̠ amara gigiribh? ");
INSERT INTO mgj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sa̠ ku̠gba ma̠ Ami̠ na̠ a̠bhin a̠limon ta̠ Abe̠lzibul na̠ a̠ze ma̠ a̠ruru na̠ asi̠ghe̠gi̠, ka̠ anwi̠i̠ny d̠inyin na̠ e̠bhin ere na̠ eze na̠ e̠si̠ghe̠gi̠? D̠a̠ ebula̠ o̠ku̠a, awa ta̠ e̠ro̠ ma̠ isobhmase̠ d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ya̠a̠, agu̠o̠ ami̠ na̠ a̠bhin E̠mu̠gh ta̠ A̠zib̠a̠ na̠ a̠ze ma̠ a̠ruru na̠ asi̠ghe̠gi̠ bho̠, bha̠ iloghome ma̠ irileghom ta̠ A̠zib̠a̠ na̠ a̠ru ra̠ ate̠i̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bo̠d̠o̠, ka̠ o̠ni̠ ta̠ a̠d̠ighi eka̠ a̠d̠igh d̠a̠ otu omomona̠n ka̠ a̠ghumi ma̠ i̠di̠ar bho̠, a̠sigimeni ka̠ na̠ a̠d̠ia̠ abhad̠i̠ ma̠ omomona̠n bho̠, i̠se̠ kisa̠ i̠na ta̠ a̠rue amar afo̠i̠ny otu omomona̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“O̠ni̠ ola̠ o̠ri̠la d̠o̠ na̠ ami̠, na̠ a̠wia̠n ami̠; sa̠ o̠ni̠ wa̠ od̠igh d̠a̠ na̠ ami̠ okokod̠ia̠n bho̠, na̠ asasaragi̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ebula̠ o̠ku̠a, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, eb̠la̠ i̠karabh ya̠ o̠ni̠ a̠gir na̠ a̠fugh i̠basi̠ ya̠ o̠ni̠ a̠fugh a̠gboloma̠ ma̠ O̠nyi̠ ta̠ O̠ni̠, ta̠ o̠we̠le̠man; ya̠a̠, o̠ni̠ ola̠ a̠fugh i̠basi̠ a̠gboloma̠ ma̠ E̠mu̠gh E̠tu̠tu̠ bho̠, ko o̠we̠le̠man d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sa̠ o̠ni̠ ola̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ O̠nyi̠ ta̠ O̠ni̠, ta̠ o̠we̠le̠man i̠na, ya̠a̠ o̠ni̠ ola̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ E̠mu̠gh E̠tu̠tu̠ bho̠, ka̠ o̠we̠le̠man d̠o̠ i̠na, a̠d̠igh d̠a̠ amu̠m onon, bo̠d̠o̠ d̠a̠ amu̠m wa̠ na̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ku̠gba ma̠ anwa amar a̠koko ma̠ oriren ma̠ agu̠o̠ ola̠ a̠bhon, bha̠ itu oriren bho̠ obhon, ya̠a̠ ku̠gba ma̠ anwa na̠ amar d̠o̠ a̠koko ma̠ oriren bho̠ ma̠ agu̠o̠ ola̠ a̠bhon, bha̠ itu oriren bho̠ ko obhon d̠o̠ nyen. Ezin bho̠ na̠ obhin otu bho̠ na̠ ologhom oriren bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anwi̠i̠ny i̠bho̠ru̠bho̠ru̠ i̠karabh i̠di̠ar. Inyin ogbo ya̠ i̠ro̠ ma̠ id̠ighi ma̠ i̠karabh bho̠ ta̠ ed̠ighi eka̠ efugh ib̠eb̠i a̠fugh. Ezin bho̠, a̠d̠ien i̠di̠ar ya̠ o̠ni̠ a̠kokod̠i a̠muzoghod̠i d̠a̠ ologi bho̠, i̠ye̠ bha̠ iya̠ o̠ni̠ bho̠ na̠ a̠fugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","O̠ni̠ wa̠ ob̠eb̠i ologi bho̠, na̠ a̠mutioghom ib̠eb̠i i̠di̠ar d̠a̠ ib̠eb̠i ya̠ a̠kpol d̠a̠ ologi d̠o̠yo̠ bho̠; sa̠ o̠karabh o̠ni̠ bho̠, na̠ a̠mutioghom i̠karabh i̠di̠ar d̠a̠ i̠karabh ya̠ a̠kpol d̠a̠ ologi d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","I̠se̠n, bha̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, kere kere a̠fugh i̠te̠i̠, ya̠ a̠nwunom ifugh bha̠ ta̠ obhin osobh ase̠ onigha̠ awa d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ezin bho̠ ta̠ ad̠u̠a d̠a̠ a̠d̠ien a̠fugh d̠oyom sa̠ anwa ta̠ a̠bhin eyel ase̠, sa̠ ta̠ ad̠u̠a d̠a̠ a̠fugh d̠oyom sa̠ anwa ta̠ a̠bhin ebhum ase̠.” ");
INSERT INTO mgj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","D̠a̠ obhel obha̠, sa̠ idi i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠ ifugh inigha̠ I̠na ma̠a̠: “O̠ni̠ atu̠ghu̠me̠ni, i̠yar na̠ o̠bho̠ro̠ghan o̠bi̠gh elegh d̠a̠ ozu D̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sa̠ i̠na awo̠ran ma̠a̠: “Amu̠m i̠basi̠ ola̠ oghila̠n d̠o̠ ma̠ A̠zib̠a̠, na̠ a̠puru ma̠ elegh; ya̠a̠ elegh ola̠ ta̠ oleriom i̠na bo̠, a̠ten elegh ta̠ owil A̠zona̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Onin agu̠o̠ wa̠ A̠zona̠ aro̠ d̠a̠ okurogh obom ena̠ ma̠ i̠sar etita̠n na̠ i̠sar a̠d̠ugula̠n bho̠, obha̠ agu̠o̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ d̠a̠ ologi a̠de bho̠ ma̠ i̠sar etita̠n na̠ i̠sar a̠d̠ugula̠n. ");
INSERT INTO mgj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","D̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, a̠nwunom A̠ninive ta̠ e̠mara e̠gba ma̠ onyob̠a̠ ebhumeni ma̠ amu̠m onon; ezin bho̠ awa i̠mu̠gho̠n okpokpo ta̠ A̠zona̠, sa̠ itiba̠ra̠ d̠a̠ i̠karabh d̠awa. Ya̠a̠ o̠ni̠ ola̠ abu̠gh a̠pu ma̠ A̠zona̠ od̠i ma̠ i̠se̠n! ");
INSERT INTO mgj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","D̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, O̠li̠la ani̠ebhom ebhugh Ase̠ba ta̠ a̠b̠etina̠ agba ma̠ onyob̠a̠ ebhumeni ma̠ amu̠m onon; ezin bho̠, i̠na ad̠u̠a ma̠ esi egbeiny a̠ru ra̠ anagha ma̠ eloghom abar ta̠ Aso̠lo̠mo̠n. Ya̠a̠, o̠ni̠ ola̠ abu̠gh a̠pu ma̠ Aso̠lo̠mo̠n od̠i ma̠ i̠se̠n! ");
INSERT INTO mgj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Igiel o̠karabh e̠mu̠gh ad̠u̠a d̠a̠ ozu o̠ni̠, sa̠ na̠ ada na̠ agi̠ na̠ ada na̠ a̠ru ma̠ a̠risisi ya̠ aghi̠ghi̠ra ma̠ o̠bho̠ro̠gh esi ola̠ a̠sora̠n od̠igh o̠ro̠. Sa̠ ku̠gba ma̠a̠ na̠ o̠bi̠gh d̠o̠, ");
INSERT INTO mgj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sa̠ i̠na ta̠ a̠fugh ma̠a̠, ‘Ami̠ ta̠ a̠mula̠ agi̠ d̠a̠ otu wa̠ ami̠ i̠d̠u̠a bho̠.’ Igiel i̠na a̠misi sa̠ abi̠gh ma̠a̠, otu bho̠ ma̠ o̠ni̠ bo̠, na̠ o̠mar ogber oselegi ma̠ i̠di̠ar, ");
INSERT INTO mgj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","i̠se̠, sa̠ i̠na ta̠ agi̠ ka̠ a̠bhin ipa̠n od̠ua̠l i̠karabh aru̠mu̠gh ya̠ i̠bho̠ru̠ ipu i̠na ma̠ o̠b̠aragu̠ma o̠yo̠, sa̠ awa ta̠ ka̠ ed̠igh erugh d̠a̠ ozu o̠ni̠ bho̠. Sa̠ e̠do̠lo̠ghu̠ma o̠ni̠ bho̠ ta̠ a̠gurom a̠pu ma̠ agu̠o̠ aro̠ ma̠ o̠pu̠r igiel bho̠. Obha̠ agu̠o̠ ta̠ aro̠ nyen d̠a̠ o̠karabh amu̠m onon.” ");
INSERT INTO mgj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Agu̠o̠ i̠na od̠id̠ia̠ na̠ a̠fugh na̠ a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠, sa̠ onweni na̠ a̠rumor d̠o̠yo̠ iru ra̠ i̠mara d̠a̠ etire na̠ e̠bho̠ro̠ghan o̠b̠e̠re̠gi̠an o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sa̠ odi o̠ni̠ agba a̠nigha̠ i̠na ma̠a̠, “Bi̠ghe̠, onweni d̠oyom na̠ a̠rumor d̠oyom na̠ e̠mara d̠a̠ etire na̠ e̠bho̠ro̠ghan ofugha̠n onyom.” ");
INSERT INTO mgj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sa̠ awo̠ran o̠ni̠ bho̠ a̠fugh ma̠a̠: “A̠nyen oweni d̠ami̠, ya̠a̠ wa̠ a̠nyen a̠rumor d̠ami̠?” ");
INSERT INTO mgj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sa̠ i̠na a̠selegheni ma̠ agu̠o̠ d̠o̠yo̠ atu̠o̠m ogbo atu̠ghan d̠o̠yo̠ a̠fugh ma̠a̠: “Onweni d̠ami̠ na̠ a̠rumor d̠ami̠ bha̠ ogbo iya̠ od̠i ma̠ i̠se̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ko̠ni̠ko̠ni̠ ola̠ na̠ a̠gir i̠to̠ ta̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠, bha̠ umor d̠ami̠, na̠ u̠marani̠ d̠ami̠, na̠ onweni d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","D̠a̠ onin a̠d̠a̠ma̠ obha̠, sa̠ A̠zizo̠s a̠mite d̠a̠ otu bho̠ agi̠ ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ aka abadi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sa̠ obom o̠lo̠gh a̠nwunom iko i̠na ikiton ma̠ ola̠ i̠na agi̠ ka̠ a̠pel a̠d̠igh d̠a̠ oghugh aro̠ ma̠ a̠dila̠de, sa̠ o̠lo̠gh a̠nwunom bho̠ i̠mara d̠a̠ egbolom. ");
INSERT INTO mgj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sa̠ agba ma̠ a̠d̠izo i̠di̠ar a̠nigha̠ awa d̠a̠ ra̠sidogh ma̠a̠: “I̠nagha o! Ogbebh ma̠ ed̠ia̠n agi̠ d̠a̠ o̠si̠ d̠o̠yo̠ ka̠ ogbebh ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa̠ igiel bho̠ i̠na a̠kpo ikpo ed̠ia̠n bho̠ asar bho̠, sa̠ idi imel d̠a̠ eten, sa̠ i̠nu̠r bho̠ iru ra̠ ikpokpoiny id̠e i̠mado̠n. ");
INSERT INTO mgj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ya̠a̠ idi sa̠ imel d̠a̠ a̠de o̠gbe̠o̠ma, esi ola̠ o̠do̠gho̠l bho̠ okud̠um d̠o̠. Sa̠ i̠rabh epa̠ ma̠ o̠su̠ ma̠ agu̠o̠ o̠do̠gho̠l bho̠ okud̠um d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ya̠a̠ igiel bho̠ ogogo a̠mite bho̠, sa̠ i̠nyu̠n i̠ghaghara d̠a̠ ebula̠ agu̠o̠ i̠ki̠ka o̠ro̠ d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sa̠ idi imel d̠a̠ e̠ku̠ko̠ ib̠ub̠ulom, sa̠ e̠ku̠ko̠ ib̠ub̠ulom bho̠ i̠su̠ ikpegiom ed̠ia̠n bho̠ i̠bhu̠ghu̠d̠i̠ i̠ze̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sa̠ idi imel d̠a̠ ob̠eb̠i a̠de, sa̠ imum imuma̠ ya̠ i̠wal e̠wala na̠ a̠d̠usubh (100) a̠bin, idi e̠rabharabh (60) a̠bin, sa̠ idi imum a̠d̠usubh na̠ d̠iobh (30) a̠bin i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wa̠ a̠nwuna̠ ma̠ a̠to, anagha o!” ");
INSERT INTO mgj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sa̠ ogbo atu̠ghan bho̠ iru ra̠ ipura̠n i̠na ma̠a̠, “Ezin ka̠ ere ka̠ anwa na̠ a̠rogha̠n a̠sidogh na̠ a̠nigha̠ awa bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sa̠ i̠na awo̠ran awa a̠fugh ma̠a̠, “D̠a̠ inyin bha̠ na̠ onigha̠ ma̠ ologhom i̠di̠ar e̠wo̠gi̠na irileghom ote̠nai̠ny; ya̠a̠ unigha̠ ani̠ d̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","I̠na o̠ni̠ wa̠ a̠nwuna̠ bho̠ ta̠ o̠lo̠gho̠m o̠gbam, ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠nwuna̠ ma̠ a̠b̠utu, ya̠a̠ i̠na o̠ni̠ wa̠ onwuna̠ d̠o̠ bho̠, ta̠ o̠wo̠r nyen ya̠ i̠na a̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ami̠ idin o̠ku̠a na̠ a̠bhin a̠sidogh na̠ a̠fugha̠n awa: “Ezin bho̠ ta̠ ekpon, ya̠a̠ ko o̠bi̠gh d̠o̠. Awa ta̠ e̠nagha, ya̠a̠ awa ko o̠mu̠gho̠n d̠o̠ e̠mu̠gho̠nyan nyen.” ");
INSERT INTO mgj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sa̠ ta̠ omuzoghod̠iom onigha̠ awa ma̠ iwowa̠ ta̠ Azaya ma̠a̠: “ ‘D̠a̠ o̠mu̠gho̠n bha̠ ta̠ e̠mu̠gho̠n sa̠ ko o̠mu̠gho̠nya̠n d̠o̠; d̠a̠ o̠bi̠gh bha̠ ta̠ e̠bi̠gh, ya̠a̠ ko olelegi d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na̠ o̠kparame̠ni̠ ma̠ rologi a̠nwunom i̠nye̠n; sa̠ na̠ ob̠ulugi ma̠ ra̠to d̠awa, sa̠ na̠ okpegi ma̠ a̠rid̠ien d̠awa, ma̠ ola̠ awa ibhin d̠o̠ ma̠ a̠rid̠ien d̠awa e̠bi̠gh abar, sa̠ i̠mu̠gho̠n d̠o̠ na̠ ra̠to d̠awa, ma̠ agu̠o̠ ola̠ awa ka̠ o̠mu̠gho̠nyan d̠o̠ eloghoma̠n eten.’ ");
INSERT INTO mgj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ya̠a̠, na̠ otutumeni inyin ogbo ya̠ a̠rid̠ien bho̠ na̠ e̠bi̠gh esi bho̠, sa̠ ra̠to bho̠ na̠ e̠mu̠gho̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ya̠gia̠ga̠i, ami̠ na̠ akparame̠ni̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠d̠izo a̠riwil na̠ ib̠eb̠i a̠nwunom e̠mar e̠bho̠ro̠ghan o̠bi̠gh i̠di̠ar ya̠ inyin na̠ o̠bi̠gh bho̠, ya̠a̠ i̠bi̠gh d̠o̠, na̠ o̠mu̠gho̠n i̠di̠ar ya̠ inyin na̠ o̠mu̠gho̠n bho̠, ya̠a̠ i̠mu̠gho̠n d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ebula̠ o̠ku̠a, i̠mare̠ ma̠ e̠nagha ma̠ ezin a̠sidogh ogbebh ma̠ ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ko̠ni̠ko̠ni̠ ola̠ amu̠gho̠n a̠duom irileghom bho̠, sa̠ i̠na o̠mu̠gho̠nyan d̠o̠, bha̠ o̠karabh o̠ni̠ bho̠ a̠ru ra̠ asi̠ghe̠ ma̠ ikpo ed̠ia̠n ya̠ ugbebh d̠a̠ ologi o̠ni̠ bho̠. I̠nye̠n bha̠ ikpo ed̠ia̠n ya̠ imel d̠a̠ eten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ya̠a̠ ikpo ed̠ia̠n ya̠ imel d̠a̠ a̠de o̠gbe̠o̠ma bho̠, bha̠ a̠nwunom ya̠ i̠mu̠gho̠n asu̠gbagba bho̠, sa̠ i̠da epa̠ ibhin d̠a̠ a̠libhon ologi. ");
INSERT INTO mgj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ya̠a̠ isi d̠o̠ ma̠ i̠ki̠ka iya̠ awa, kpe̠le̠me̠ni̠ ima̠ra̠ ma̠ ekud̠i obhel, sa̠ imel i̠d̠u̠a ma̠ igiel ali̠gam a̠ruzu bo̠d̠o̠ ka̠ uponoma̠ awa d̠a̠ ebula̠ asu̠gbagba bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sa̠ iya̠ imel d̠a̠ ed̠um ib̠ub̠ulom bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n asu̠gbagba bho̠, sa̠ i̠nyo̠gho̠nyo̠gh e̠mara̠nwunom na̠ e̠ralma ogbo e̠li̠la i̠vi̠mo̠m asu̠gbagba bho̠, sa̠ awa orue d̠o̠ ma̠ omum itu. ");
INSERT INTO mgj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ya̠a̠, ikpo ed̠ia̠n ya̠ imel d̠a̠ ob̠eb̠i a̠de bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n asu̠gbagba bho̠ sa̠ i̠mu̠gho̠nyan bho̠, sa̠ imum itu ga̠i, idi i̠wal e̠wala na̠ a̠d̠usubh (100), sa̠ idi e̠rabharabh (60), sa̠ idi a̠d̠usubh na̠ d̠iobh (30) a̠bin i̠se̠, d̠a̠ ikpo ya̠ ubhin ugbebh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa̠ i̠na a̠rogh opa̠n a̠sidogh a̠fugh ma̠a̠: “Irileghom ote̠nai̠ny agu̠b̠an o̠ni̠ ola̠ a̠gbebh ib̠eb̠i ikpo ed̠ia̠n d̠a̠ o̠si̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ya̠a̠ igiel bho̠ a̠nwunom bho̠ na̠ ekod̠u bho̠, sa̠ o̠ni̠ o̠lo̠gi̠an a̠d̠ien d̠o̠yo̠ agi̠ ka̠ alo̠gi̠o̠gho̠m ib̠utula d̠a̠ esa̠d̠io i̠bu̠kpa bho̠ sa̠ a̠ten ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sa̠ igiel i̠mu̠nu̠mu̠n i̠bu̠kpa bho̠ i̠rabh imite bho̠, sa̠ ib̠utula bho̠ eka̠ i̠rabh imite. ");
INSERT INTO mgj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Sa̠ aru̠bana bho̠ i̠gi̠ ka̠ i̠te̠i̠ wa̠nwuna̠ ma̠ o̠si̠ bho̠ ifugh ma̠a̠, ‘We̠mu̠, wokuma̠ ugbebh ib̠eb̠i ikpo i̠bu̠kpa d̠a̠ o̠si̠ d̠oyom? O̠ku̠a ka̠ ib̠utula i̠wo̠l d̠a̠ a̠ken emite?’ ");
INSERT INTO mgj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Sa̠ i̠na awo̠ran awa ma̠a̠, ‘O̠ni̠ o̠lo̠gi̠an a̠d̠ien a̠gir o̠ku̠a.’ “Sa̠ aru̠bana bho̠ ipura̠n i̠na ma̠a̠, ‘I̠yar o̠gi̠ ka̠ ob̠ugion o̠si̠ghe̠gi̠ ke̠re̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Sa̠ i̠na awo̠ran ma̠a̠, ‘E̠e̠nyi̠, bo̠ka̠ inyin u̠b̠aram na̠ i̠bu̠kpa bho̠ ob̠ugion na̠ ib̠utula bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ima̠ra̠ i̠wal a̠yi e̠su̠ emum itu. Sa̠ d̠a̠ igiel ob̠u ed̠ia̠n bho̠, ami̠ ta̠ a̠ruom ogbo ob̠u ed̠ia̠n bho̠, ma̠ ed̠ia̠ eb̠ugion ib̠utula bho̠ ma̠ agu̠o̠ ola̠ to okokod̠i o̠gho̠ro̠gi̠ o̠bhu̠gi̠ orobh. Ya̠a̠ ta̠ okokod̠i ma̠ i̠bu̠kpa bho̠ okpol d̠a̠ esi eko d̠ami̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sa̠ i̠na a̠rogh opa̠n a̠sidogh a̠nigha̠ awa ma̠a̠, “Irileghom ote̠nai̠ny agu̠b̠an ekpo amu̠stad ola̠ o̠ni̠ a̠bhin a̠gbebh d̠a̠ o̠si̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eb̠la̠ agu̠o̠ i̠na aki̠r a̠pu d̠a̠ eb̠la̠ ikpo ya̠ na̠ ogbebh bho̠ eka̠, igiel na̠ asu̠ abu̠gh, bha̠ abu̠gh a̠pu ma̠ agu̠o̠ i̠gho̠gho̠ a̠mobobh na̠ e̠su̠ na̠ e̠te̠i̠ bho̠, sa̠ na̠ a̠ten oriren, ma̠ ola̠ i̠nu̠r anyu̠ bho̠ na̠ e̠gi̠ ka̠ elo ma̠ a̠rutu d̠a̠ i̠gha bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sa̠ i̠na a̠rogh opa̠n a̠sidogh ma̠a̠, “Irileghom ote̠nai̠ny agu̠b̠an o̠nyi̠ki̠kara a̠yist ya̠ ani̠ebhom a̠bhin alo̠gh d̠a̠ o̠to̠ma̠ i̠sar-abafu̠ ed̠ia̠n ibhugh, sa̠ iwubhmeni ma̠ eb̠la̠ ed̠ia̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A̠zizo̠s a̠bhin d̠a̠ a̠sidogh a̠fugh eb̠la̠ i̠di̠ar i̠nye̠n a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠. Sa̠ bebina̠ abar ola̠ i̠na a̠fugh a̠nigha̠ awa ola̠ i̠na obhin d̠o̠ ma̠ a̠sidogh a̠fugh na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O̠ku̠a bho̠ i̠nye̠n imuzoghod̠iom abar wa̠ owil bho̠ a̠wa̠ bho̠ ma̠a̠: “Ami̠ ta̠ akpato̠n o̠nu̠ d̠ami̠ a̠rogh ra̠sidogh, sa̠ ami̠ ta̠ agba ma̠ i̠di̠ar ya̠ od̠i d̠a̠ e̠wo̠gi̠na a̠mutiom, ka̠ d̠a̠ o̠pu̠r ob̠eton e̠mara̠nwunom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sa̠ A̠zizo̠s a̠gbogion a̠kokod̠ia̠n bho̠ agi̠ ka̠ a̠d̠igh d̠a̠ otu, sa̠ ogbo atu̠ghan d̠o̠yo̠ iru ra̠ i̠te̠i̠ i̠na ifugh ma̠a̠, “Gba ma̠ ezin a̠sidogh ib̠utula ya̠ d̠a̠ o̠si̠ bho̠ ma̠ a̠nigha̠ i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sa̠ i̠na awo̠ran a̠fugh ma̠a̠, “O̠ni̠ wa̠ a̠gbebh ib̠eb̠i ikpo ed̠ia̠n bho̠ bha̠ O̠nyi̠ ta̠ O̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","O̠si̠ bho̠ bha̠ e̠mara̠nwunom bho̠, ib̠eb̠i ikpo bho̠ bha̠ anwi̠i̠ny irileghom bho̠, ya̠a̠ ib̠utula bho̠ bha̠ anwi̠i̠ny ta̠ o̠karabh o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sa̠ o̠ni̠ o̠lo̠gi̠an a̠d̠ien wa̠ a̠gbebh ib̠utula̠ bho̠ bha̠ eru bho̠. Ib̠ua̠ bho̠ bha̠ ekunuguma̠ e̠mara̠nwunom bho̠, sa̠ ogbo ob̠u bho̠ bha̠ itileduom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, agu̠o̠ ta̠ ob̠ugion ib̠utula bho̠ okokod̠i o̠bhu̠gi̠ bho̠, obha̠ bha̠ agu̠o̠ ta̠ aro̠ d̠a̠ ekunuguma̠ e̠mara̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠ruom itileduom d̠o̠yo̠, sa̠ ta̠ e̠si̠ghe̠gi̠ d̠a̠ irileghom d̠o̠yo̠ ma̠ o̠kpo̠ ya̠ na̠ e̠le̠ge̠ ma̠ a̠nwunom ma̠ ogir i̠karabh bho̠, na̠ eb̠la̠ idighi ma̠ i̠karabh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Sa̠ ta̠ erobhod̠i awa e̠lo̠gh d̠a̠ e̠ba anya bho̠, d̠a̠ esi wa̠ ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠ od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Igiel obha̠, ib̠eb̠i a̠nwunom bho̠ ta̠ e̠war agu̠o̠ ogogo bho̠ d̠a̠ irileghom ta̠ O̠we̠de̠ d̠awa. Wa̠ a̠nwuna̠ ma̠ ra̠to, amar anagha o! ");
INSERT INTO mgj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Irileghom ote̠nai̠ny agu̠b̠an i̠di̠ar edim ya̠ od̠i d̠a̠ e̠wo̠gi̠na d̠a̠ o̠si̠ ma̠ ola̠ o̠ni̠ agi̠ ka̠ abi̠gh, sa̠ a̠puta̠ awo̠gi̠. Sa̠ d̠a̠ ebula̠ ibo bho̠, sa̠ ad̠u̠a ka̠ a̠wol eb̠la̠ i̠di̠ar ya̠ i̠na a̠nwuna̠ bho̠, sa̠ a̠bhin a̠gho ma̠ egbolom o̠si̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“O̠lo̠gho̠m i̠se̠, irileghom ote̠nai̠ny agu̠b̠an o̠ni̠ a̠b̠ua̠ ola̠ na̠ ad̠u̠a ma̠ esi na̠ a̠ten esi na̠ abho̠ro̠ghan ib̠eb̠i i̠b̠o̠lo̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sa̠ ka̠ abi̠gh odi o̠b̠o̠lo̠ obom a̠b̠ua̠, sa̠ agi̠ ka̠ a̠wol eb̠la̠ i̠di̠ar ya̠ i̠na a̠nwuna̠ bho̠, sa̠ a̠bhin a̠gho ma̠ o̠b̠o̠lo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“O̠lo̠gho̠m i̠se̠, irileghom ote̠nai̠ny agu̠b̠an o̠gbo̠ ola̠ usoroni d̠a̠ abadi̠ sa̠ a̠d̠ien kere kere ina̠ i̠gi̠ ka̠ isin. ");
INSERT INTO mgj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Igiel bho̠ ina̠ bho̠ isin o̠gbo̠ bho̠ imuzo bho̠, sa̠ i̠ku̠mi̠ku̠ bho̠ ikpor o̠gbo̠ bho̠ ibhuneni d̠a̠ egbolom, sa̠ i̠ro̠ ma̠ a̠dila̠de i̠so̠n ib̠eb̠i i̠na bho̠ i̠lo̠gi̠ d̠a̠ egunu, ya̠a̠ i̠karabh bho̠, sa̠ awa irobhod̠i. ");
INSERT INTO mgj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Obha̠ agu̠o̠ ta̠ aro̠ d̠a̠ ekunuguma̠ e̠mara̠nwunom bho̠. Itileduom ta̠ A̠zib̠a̠ ta̠ e̠gi̠ ka̠ e̠so̠n id̠ighi ma̠ i̠karabh bho̠ d̠a̠ esa̠d̠io ib̠eb̠i bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sa̠ ta̠ erobhodi awa e̠lo̠gh d̠a̠ e̠ba anya bho̠, d̠a̠ esi wa̠ ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠ od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Inyin o̠mu̠gho̠nyan eb̠la̠ i̠di̠ar i̠nye̠n ke̠re̠?” Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “Yii.” ");
INSERT INTO mgj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sa̠ i̠na awo̠ran awa ma̠a̠, “Ebula̠ o̠ku̠a, ko̠ni̠ko̠ni̠ atu̠ghu̠me̠ni̠ oloko bho̠ ola̠ ada ma̠ atu̠ghan irileghom ote̠nai̠ny bho̠ a̠bhin, bha̠ agu̠b̠an o̠ni̠ wa̠ a̠nwuna̠ ma̠ otu bho̠, sa̠ a̠mutioghom imom na̠ igba̠iny i̠di̠ar ya̠ i̠na alo̠gi̠ a̠guri d̠a̠ igba̠ i̠d̠i̠ar edim d̠o̠yo̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ ma̠ igiel bho̠ i̠na na̠ a̠rogh a̠sidogh i̠nye̠n awe̠le̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Sa̠ i̠na agi̠ d̠a̠ e̠ma d̠o̠yo̠ ka̠ atu̠ghu̠me̠ni̠ awa d̠a̠ u̠gala d̠awa, ma̠ ola̠ awa ib̠a̠gha̠gha̠. Sa̠ awa na̠ epupura̠n ma̠a̠, “Eloghom abar onon na̠ a̠d̠ien ilologia̠n i̠nye̠n ka̠ ad̠u̠a d̠a̠ a̠ken eru?” ");
INSERT INTO mgj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Onon O̠nyi̠ ta̠ o̠du̠gi̠ ma̠ i̠di̠ar bho̠ d̠o̠ ke̠re̠? Oweni d̠o̠yo̠ ubhelegi d̠o̠ ma̠ A̠meri ke̠re̠? Sa̠ a̠rumor d̠o̠yo̠ bha̠ A̠zemsi na̠ A̠zose̠fu̠ na̠ Asai̠mo̠n na̠ A̠zud d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eb̠la̠ aru̠marani̠ d̠o̠yo̠ bo̠ na̠ i̠yar i̠se̠n ke̠re̠? O̠ku̠a ka̠ eb̠la̠ i̠nye̠n i̠d̠u̠a d̠a̠ a̠ken eru?” ");
INSERT INTO mgj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sa̠ rologi d̠awa igurom d̠a̠ ebula̠ o̠yo̠. Ya̠a̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “Ubhin d̠o̠ ma̠ owil o̠tu̠o̠m abar d̠a̠ e̠ma d̠o̠yo̠ na̠ eghun otu wa̠ i̠na a̠mite bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ebula̠ agu̠o̠ awa od̠umom d̠o̠ bho̠, sa̠ i̠na ogir d̠o̠ ma̠ a̠d̠izo ilologia̠n i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Igiel bho̠ E̠ro̠d we̠mu̠ irileghom odi agba ebhugh bho̠, amu̠gho̠n o̠du̠ ta̠ A̠zizo̠s bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","sa̠ i̠na a̠fugh a̠nigha̠ ma̠ rob̠a̠ra̠motu d̠o̠yo̠ ma̠a̠, “Onon ta̠ aro̠ ma̠ Azo̠n Owurmamu̠m bho̠; i̠na na̠ a̠b̠etina̠ d̠a̠ omugh! Obha̠ ezin bho̠ ra̠limon i̠nye̠n na̠ i̠kpasan i̠na bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ezin bho̠ E̠ro̠d a̠b̠ol Azo̠n, sa̠ adu̠o̠m d̠a̠ ikoli ma̠ ebula̠ E̠ro̠di̠as ani̠ ta̠ A̠filip umor d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ezin bho̠ Azo̠n a̠fugh a̠nigha̠ i̠na ma̠a̠: “Na̠ osora̠n d̠o̠ nyam ma̠ obhin E̠ro̠di̠as ani̠.” ");
INSERT INTO mgj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sa̠ E̠ro̠d abho̠ro̠gh ogigh Azo̠n, ya̠a̠ i̠na a̠ghil a̠nwunom bho̠, ezin bho̠ awa eloghom ma̠ Azo̠n owil. ");
INSERT INTO mgj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","D̠a̠ a̠d̠a̠ma̠ e̠yal i̠mara ta̠ E̠ro̠d, sa̠ o̠nyani̠ ta̠ E̠ro̠di̠as aghe̠r d̠a̠ a̠misigh ogbo o̠d̠e̠ bho̠ ma̠ ola̠ a̠d̠igh ologi ma̠ E̠ro̠d. ");
INSERT INTO mgj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ebula̠ o̠ku̠a, sa̠ E̠ro̠d a̠sibhigha̠ a̠gua̠n onigha̠ o̠nyani̠ bho̠ kere kere abar ola̠ ta̠ a̠puru i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sa̠ o̠nyani̠ bho̠ agi̠ ka̠ a̠pura̠n onweni d̠o̠yo̠ ma̠ abar wa̠ i̠na ta̠ a̠puru bho̠, sa̠ oweni d̠o̠yo̠ a̠ruom i̠na ma̠ o̠gi̠ ka̠ o̠gba onigha̠ E̠ro̠d ma̠a̠, “Nigha̠ ami̠ ma̠ i̠se̠n i̠se̠n e̠mu̠ ta̠ Azo̠n Owurmamu̠m bho̠ d̠a̠ e̠kpa imobh.” ");
INSERT INTO mgj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sa̠ o̠li̠le̠ma bho̠ a̠b̠ogina̠, ya̠a̠ ebula̠ i̠zo̠ bho̠ na̠ ogbo o̠d̠e̠ bho̠, sa̠ i̠na a̠ruom awa ma̠ onigha̠ o̠nyani̠ bho̠ ma̠ abar wa̠ i̠na a̠puru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Sa̠ i̠na ato̠ ma̠ a̠nwunom ma̠ o̠gi̠ ka̠ osobh e̠mu̠ ta̠ Azo̠n d̠a̠ ologi ikoli bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sa̠ awa irol e̠mu̠ bho̠ d̠a̠ e̠kpa imobh ra̠ inigha̠ ma̠ o̠gbara o̠nyani̠ bho̠, sa̠ o̠nyani̠ bho̠ a̠bhin ka̠ a̠nigha̠ ma̠ onweni d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sa̠ ogbo atu̠ghan ta̠ Azo̠n i̠gi̠ ka̠ irol ekuna̠ bho̠ i̠d̠u̠a ka̠ id̠i, sa̠ i̠gi̠ ka̠ i̠gba inigha̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Igiel bho̠ A̠zizo̠s amu̠gho̠n abar wa̠ a̠mutuma̠ ma̠ Azo̠n bho̠, sa̠ i̠na ku̠ku̠m a̠d̠igh d̠a̠ oghugh sa̠ ad̠u̠a agi̠ ma̠ esi ola̠ aro̠ kukunum. Sa̠ agu̠o̠ o̠lo̠gh a̠nwunom bho̠ i̠mu̠gho̠n bho̠, sa̠ awa i̠d̠u̠a d̠a̠ re̠ma d̠awa i̠wo̠l ya̠ a̠wel i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Igiel bho̠ i̠na na̠ a̠bhun d̠a̠ egbolom bho̠, sa̠ i̠na abi̠gh obom o̠lo̠gh a̠nwunom sa̠ igbirigbir awa id̠ighi i̠na, sa̠ a̠koko ma̠ ogbo asu̠nwe̠r ya̠ od̠i d̠a̠ o̠lo̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Igiel bho̠ a̠d̠io na̠ ate̠i̠ a̠dule bho̠, sa̠ ogbo atu̠ghan bho̠ iru ra̠ ifugh inigha̠ i̠na ma̠a̠, “Onon esi ola̠ od̠i kukunum, ya̠a̠ obhel na̠ a̠ten. Ruome ma̠ o̠lo̠gh a̠nwunom bho̠ ma̠ e̠d̠u̠a e̠gi̠ d̠a̠ re̠ma bho̠ ka̠ eghoyogh ed̠ia̠n ya̠ awa ta̠ ed̠e.” ");
INSERT INTO mgj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ya̠a̠ A̠zizo̠s a̠fugh ma̠a̠, “Na̠ osora̠n d̠o̠ awa ma̠ o̠d̠u̠a. Inigha̠ awa ma̠ abar od̠e.” ");
INSERT INTO mgj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sa̠ i̠wo̠ran i̠na ma̠a̠, “I̠yar unwuna̠ d̠o̠ ma̠ abar esi onon, a̠ten ogho ikpokpogh abre̠di̠ na̠ i̠wal ikpo ina̠.” ");
INSERT INTO mgj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sa̠ i̠na awo̠ran ma̠a̠, “Ibhine ma̠ eru ma̠ i̠se̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sa̠ i̠na a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ e̠ro̠ ma̠ a̠dila̠de d̠a̠ i̠gho̠gho̠ bho̠. Sa̠ i̠na a̠bhin ogho ikpokpogh abre̠di̠ bho̠ na̠ i̠wal ikpo ina̠ bho̠, sa̠ a̠b̠eka̠ a̠kpon d̠a̠ ote̠nai̠ny a̠tutumeni ma̠ ed̠ia̠n bho̠. Sa̠ i̠na a̠pupugion a̠nigha̠ ma̠ ogbo atu̠ghan bho̠, sa̠ awa i̠ru̠gi̠ iinigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sa̠ eb̠la̠ awa id̠e, sa̠ ilegha̠n ko̠ni̠ko̠ni̠, sa̠ ikokod̠i ma̠ i̠pe̠re̠pe̠r ya̠ isughia̠n bho̠ imuzoghod̠i d̠iobh na̠ i̠wal (12) a̠rukpuom. ");
INSERT INTO mgj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aro̠ ka̠ d̠iobh na̠ i̠wal o̠ni̠r na̠ ogho e̠wala (5,000) ilobhiri a̠nwunom id̠e. U̠wal ani̠ d̠o̠ ma̠ anwani̠ na̠ i̠gbara anwi̠i̠ny ya̠ id̠e ani̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","D̠a̠ onin obhel obha̠, sa̠ A̠zizo̠s a̠nugi ma̠ ogbo atu̠ghan d̠o̠yo̠, ma̠ ed̠igh d̠a̠ oghugh ed̠ia̠ eb̠etina̠ na̠ i̠na i̠b̠e̠i̠y d̠a̠ aku̠b̠o̠ bho̠, ya̠a̠ i̠na ta̠ aro̠ a̠b̠a̠ra̠ tu̠tu̠n ka̠ i̠na na̠ a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ oyeleghu o̠mado̠n. ");
INSERT INTO mgj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Igiel bho̠ o̠lo̠gh a̠nwunom bho̠ na̠ eyeleghu bho̠, sa̠ i̠na asi̠n d̠a̠ anyu̠ igu ka̠ a̠siseiny tu̠tu̠n a̠d̠io a̠kpegi, sa̠ i̠na ku̠ku̠m aro̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","D̠a̠ obhel obha̠, oghugh bho̠ na̠ agi̠ ma̠ egbeiny d̠a̠ obodo bho̠, sa̠ opoka̠n amu̠m bho̠ na̠ a̠b̠oroghom awa, ezin bho̠ ogim bho̠ na̠ a̠gim na̠ adama awa. ");
INSERT INTO mgj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Igiel bho̠ ate̠i̠ obhel ogir wa̠ ame̠ghe̠le̠ bho̠, sa̠ A̠zizo̠s a̠rile d̠a̠ anyu̠ amu̠m agi̠ ka̠ ate̠i̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ya̠a̠ igiel bho̠ ogbo atu̠ghan bho̠ i̠bi̠gh agu̠o̠ i̠na na̠ a̠rile d̠a̠ anyu̠ amu̠m bho̠, sa̠ rologi d̠awa ikpoyogh, sa̠ ifugh ma̠a̠, “Obha̠ e̠mu̠gh o,” sa̠ ikpo ma̠ izul d̠a̠ ebula̠ a̠rugugu. ");
INSERT INTO mgj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ogbo na̠ onin, sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “I̠kpo̠ ma̠ ologi. O̠ni̠ ko oghil a̠rugugu. Ami̠!” ");
INSERT INTO mgj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sa̠ A̠pita̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, ku̠gba ma̠ anwa na̠ agu̠o̠ ga̠i, bha̠ ruome ami̠ ma̠ orile d̠a̠ anyu̠ amu̠m bho̠ oru d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sa̠ i̠na awo̠ran ma̠a̠, “Tue.” Sa̠ A̠pita̠ ad̠u̠a d̠a̠ oghugh bho̠ a̠sor a̠rile d̠a̠ anyu̠ amu̠m bho̠ na̠ agi̠ d̠a̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sa̠ agu̠o̠ i̠na abi̠gh e̠mi̠ ogim bho̠, sa̠ a̠rugugu isibh i̠na, sa̠ i̠na ake̠ ma̠ od̠in, sa̠ i̠na a̠mulughu a̠fugh ma̠a̠, “Wa̠nwuna̠, tenemeni ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ogbo na̠ onin, sa̠ A̠zizo̠s agi̠o̠m agu̠o̠ d̠o̠yo̠ a̠sibh i̠na sa̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “O̠ni̠ ologi ima̠ra̠ o̠ghu̠a d̠o̠, ologi d̠oyom na̠ a̠kpo ma̠ ere?” ");
INSERT INTO mgj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sa̠ i̠wal awa ipel id̠igh d̠a̠ oghugh bho̠, sa̠ ogim bho̠ a̠lia̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sa̠ ogbo ya̠ od̠i d̠a̠ oghugh bho̠ ikpud̠ia̠n inigha̠ i̠na d̠a̠ ozuruna̠ eghoi, sa̠ ifugh ma̠a̠, “Ya̠gia̠ga̠i, anwa O̠nyi̠ ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sa̠ awa i̠b̠e̠i̠ ka̠ isul d̠a̠ Age̠ne̠sare̠t. ");
INSERT INTO mgj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sa̠ a̠nwunom e̠ma bho̠ ilelegi i̠na, sa̠ iruom ka̠ obhinogh eb̠la̠ ogbo asu̠nwe̠r d̠a̠ eghighira̠ bho̠ oru d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sa̠ awa i̠le̠gh i̠na ma̠a̠ i̠na a̠ma̠ra̠ ma̠ ogbo asu̠nwe̠r bho̠ ma̠ okula̠n bebina̠ esi bho̠ u̠labh akapa d̠o̠yo̠ bho̠, sa̠ eb̠la̠ ogbo ya̠ ikula̠n bho̠ id̠um i̠man. ");
INSERT INTO mgj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","D̠a̠ igiel obha̠, sa̠ Rafarisi bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ i̠d̠u̠a d̠a̠ A̠zeruse̠le̠m i̠gi̠ ka̠ ipura̠n A̠zizo̠s ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ezin ka̠ ere ka̠ ogbo atu̠ghan d̠oyom na̠ e̠pi̠e̠ ma̠ od̠ud̠ul ibom ro̠we̠de̠ bho̠? Awa ititila̠ d̠o̠ ma̠ aru̠gu̠o̠ d̠awa kisa̠ na̠ ed̠e ma̠ ed̠ia̠n!” ");
INSERT INTO mgj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sa̠ i̠na awo̠ran awa ma̠a̠, “Ya̠a̠, inyin eka̠ ka̠ inyin na̠ odin ere na̠ obhin d̠a̠ od̠ud̠ul d̠inyin na̠ okpon oloko ta̠ A̠zib̠a̠ na̠ o̠ki̠ri̠me̠ni̠? ");
INSERT INTO mgj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ezin bho̠ A̠zib̠a̠ agba ma̠a̠, ‘Zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ onweni na̠ o̠we̠de̠ d̠oyom’sa̠ ‘O̠ni̠ wa̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ onweni d̠o̠yo̠ bo̠d̠o̠ o̠we̠de̠ d̠o̠yo̠, ta̠ ogigh.’ ");
INSERT INTO mgj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ya̠a̠ inyin na̠ o̠tu̠ghu̠me̠ni̠ ma̠a̠, o̠kpe̠ bo̠ ku̠gba ma̠ o̠ni̠ agba a̠nigha̠ ma̠ onweni d̠o̠yo̠, bo̠d̠o̠ o̠we̠de̠ d̠o̠yo̠ ma̠a̠, i̠di̠ar ya̠ i̠na ka̠ ibhin alo̠gh agu̠o̠ a̠nigha̠ awa bho̠ ma̠ iya̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sa̠ aro̠ ma̠ ola̠ o̠ni̠ bho̠ ozuruna̠ d̠o̠ ma̠ eghoi a̠nigha̠ ma̠ o̠we̠de̠ d̠o̠yo̠. O̠ku̠a bha̠ inyin na̠ ogbogion oloko ta̠ A̠zib̠a̠ na̠ o̠tu̠o̠no̠m ratu̠ghu̠me̠ni̠ d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Inyin ibhelebhel! A̠sora̠n ga̠i ya̠ Azaya a̠wa̠ a̠gboloma̠ inyin bho̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘A̠nwunom i̠nye̠n na̠ ebhin aru̠nu̠ d̠awa na̠ ebuom ami̠, ya̠a̠ rologi d̠awa isigima̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awa na̠ e̠ko̠l ami̠ ma̠ obhubho i̠kpo̠, sa̠ na̠ e̠tu̠ghu̠me̠ni̠ ma̠ i̠to̠to̠gi̠ a̠nwunom ma̠ agu̠o̠ roloko ta̠ A̠zib̠a̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sa̠ i̠na a̠kokod̠i ma̠ o̠lo̠gh a̠nwunom bho̠ a̠fugh ma̠a̠, “I̠mare̠ ma̠ e̠nagha, ma̠ e̠mu̠gho̠nyan o! ");
INSERT INTO mgj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Abar wa̠ na̠ a̠d̠igh d̠a̠ o̠nu̠ o̠ni̠ bho̠ d̠o̠, ma̠ wa̠ na̠ api̠e̠ ma̠ o̠ni̠ bho̠. Kpe̠le̠me̠ni̠ bha̠ abar wa̠ na̠ a̠mite d̠a̠ o̠nu̠ bho̠ na̠ api̠e̠ ma̠ o̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sa̠ ogbo atu̠ghan bho̠ iru ra̠ ipura̠n i̠na ma̠a̠, “Anwa a̠loghom ma̠a̠ rologi Rafarisi bho̠ na̠ egurom ma̠ igiel bho̠ awa i̠mu̠gho̠n i̠nye̠n bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sa̠ i̠na awo̠ran awa ma̠a̠, “Kere kere oriren ola̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny ogbebh d̠o̠, ta̠ ob̠uron. ");
INSERT INTO mgj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","I̠we̠le̠mane̠ awa, ogbo ya̠ o̠bi̠gh d̠o̠ ma̠ esi na̠ erileghom ogbo ya̠ o̠bi̠gh d̠o̠ ma̠ esi. Sa̠, ku̠gba ma̠ o̠ni̠ ola̠ o̠bi̠gh d̠o̠ ma̠ esi a̠rileghom o̠ni̠ ola̠ o̠bi̠gh d̠o̠ ma̠ esi, i̠wal awa ta̠ emel ed̠igh d̠a̠ ogugua̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sa̠ A̠pita̠ agba a̠nigha̠ i̠na ma̠a̠, “Gba ma̠ ezin a̠sidogh onon asi̠se̠ghe̠ni̠ ma̠ a̠nigha̠ i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sa̠ i̠na awo̠ran ma̠a̠, “I̠se̠n eka̠ bha̠ inyin ta̠ o̠mu̠gho̠nyan d̠o̠ nyen ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Inyin uloghom d̠o̠ ma̠a̠, kere kere abar ola̠ a̠d̠igh d̠a̠ o̠nu̠ na̠ awo̠l d̠a̠ okurogh, sa̠ na̠ a̠tenegia̠n ati̠n ma̠ ola̠ na̠ o̠ni̠ na̠ orobh ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ya̠a̠, i̠di̠ar ya̠ na̠ e̠d̠u̠a d̠a̠ o̠nu̠ na̠ emite bho̠, i̠d̠u̠a d̠a̠ ekpo ologi bho̠ emite eru, i̠ye̠ bha̠ ya̠ na̠ e̠pi̠e̠ ma̠ o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ezin bho̠, d̠a̠ ekpo ologi bho̠, bha̠ esi i̠karabh i̠ru̠ru̠an ya̠ ogigh o̠ni̠, na̠ orile isorogi,od̠e e̠ma, ob̠igh a̠b̠igh, o̠gba onyob̠a̠ igunugha̠, o̠gba o̠ni̠ o̠pi̠e̠ na̠ emite na̠ eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","I̠nye̠n bha̠ ya̠ na̠ e̠pi̠e̠ ma̠ o̠ni̠ bho̠, ya̠a̠ o̠ni̠ ma̠ o̠we̠le̠man otitila̠ agu̠o̠ kisa̠ od̠e ed̠ia̠n na̠ o̠pi̠e̠ d̠o̠ ma̠ o̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ agi̠ d̠a̠ agba Ataya na̠ Asi̠do̠n. ");
INSERT INTO mgj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I̠se̠ sa̠ ani̠ ola̠ ebhugh A̠kenan a̠mite a̠ru ra̠ a̠leghe ma̠a̠, “Wa̠nwuna̠, O̠nyi̠ ta̠ A̠devidi, kpone ami̠ ma̠ igbirigbir! Eru na̠ ab̠am o̠nyani̠ d̠ami̠ ma̠ o̠kparakpar agu̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ya̠a̠, A̠zizo̠s na̠ o̠wo̠ran d̠o̠ i̠na bebina̠ abar. Sa̠ ogbo atu̠ghan bho̠ iru ra̠ i̠le̠gh i̠na ma̠a̠, “Ze i̠na ma̠ asi̠ghe̠, ezin bho̠ i̠na na̠ a̠leghe na̠ atu̠o̠no̠m i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sa̠ A̠zizo̠s awo̠ran ani̠ bho̠ ma̠a̠, “Uruom d̠o̠ ami̠ ma̠ o̠tu̠n ipa̠n ogbo oru, ya̠a̠ uruom ami̠ ma̠ oru d̠a̠ ro̠nana ya̠ na̠ ebhe bho̠, d̠a̠ a̠nwunom Izre̠l.” ");
INSERT INTO mgj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sa̠ ani̠ bho̠ a̠ru ra̠ a̠kpud̠ia̠n a̠nigha̠ i̠na awo̠ran ma̠a̠, “Wa̠nwuna̠, lo̠ghe̠ ma̠ agu̠o̠ ma̠ a̠nigha̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sa̠ i̠na awo̠ran ma̠a̠, “Na̠ osora̠n d̠o̠ ma̠ orobh ed̠ia̠n i̠gbara anwi̠i̠ny bho̠ onigha̠ a̠sib̠ogho.” ");
INSERT INTO mgj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sa̠ ani̠ bho̠ awo̠ran ma̠a̠, “O̠ku̠a ga̠i, Wa̠nwuna̠. Ya̠a̠, anwi̠i̠ny a̠sib̠ogho bho̠ eka̠ na̠ ed̠e ma̠ i̠pe̠re̠pe̠r ya̠ na̠ e̠d̠u̠a d̠a̠ akpata od̠e ta̠ wa̠nwuna̠ awa na̠ emeleghu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ebula̠ o̠ku̠a, sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ani̠ bho̠, alu̠bu̠gh ologi ima̠ra̠ d̠oyom! A̠mite ma̠ agu̠o̠ anwa na̠ abho̠ro̠gh bho̠.” Sa̠ o̠nyani̠ ani̠ bho̠ a̠d̠um epa̠ d̠a̠ ogbo obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ agi̠ d̠a̠ aka abadi̠ Agalili sa̠ asi̠n d̠a̠ anyu̠ igu ka̠ aro̠ ma̠ a̠dila̠de. ");
INSERT INTO mgj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sa̠ obom o̠lo̠gh a̠nwunom iru d̠o̠yo̠. Awa i̠b̠ar na̠ ogbo ya̠ na̠ ed̠ikighu ma̠ re̠gha, ogbo ikpom a̠rid̠ien, a̠rukula̠, remua̠, na̠ ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ ma̠ a̠d̠ien kere kere a̠d̠izo rasu̠nwe̠r ka̠ iguri d̠a̠ aka a̠sike d̠o̠yo̠, sa̠ i̠na a̠koko awa. ");
INSERT INTO mgj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sa̠ o̠lo̠gh a̠nwunom bho̠ ib̠a̠gha̠gha̠ d̠a̠ ebula̠ i̠di̠ar ya̠ awa i̠bi̠gh bho̠. Remua̠ bho̠ na̠ efugh a̠fugh, ogbo ya̠ na̠ eb̠ogina̠ bho̠ na̠ okoko od̠umeni, sa̠ a̠rukula̠ bho̠ na̠ erile, sa̠ a̠nwunom ikpom a̠rid̠ien bho̠ na̠ e̠bi̠gh esi. Sa̠ awa itutumeni ma̠ A̠zib̠a̠ Izre̠l. ");
INSERT INTO mgj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sa̠ A̠zizo̠s a̠kokod̠i ma̠ ogbo atu̠ghan d̠o̠yo̠ agba ma̠a̠, “Igbirigbir o̠lo̠gh a̠nwunom bho̠ na̠ ed̠ighi ami̠. Ezin bho̠ onon oleghemeni i̠sar a̠d̠a̠ma̠ na̠ e̠ro̠ na̠ ami̠ sa̠ bebina̠ abar ola̠ ta̠ ed̠e bo̠. Ya̠a̠, ami̠ i̠bho̠ro̠gh d̠o̠ ma̠ oruom awa ta̠ eyel o̠ko̠i̠, b̠o̠ka̠ awa i̠fu̠mu̠ d̠a̠ eten bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sa̠ ogbo atu̠ghan bho̠ ipura̠n i̠na ma̠a̠, “Ta̠ o̠te̠i̠ d̠a̠ a̠ken ikpokpogh abre̠di̠ ya̠ ta̠ elei onigha̠ obom o̠lo̠gh a̠nwunom i̠nye̠n, d̠a̠ esi ola̠ od̠i kukunum o̠ko̠no̠n?” ");
INSERT INTO mgj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin unwuna̠ i̠ni̠ ikpokpogh abre̠di̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “Od̠ua̠l ikpokpogh abre̠di̠, na̠ o̠nyi̠ki̠kara i̠gbara ikpo ina̠.” ");
INSERT INTO mgj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sa̠ i̠na a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ awa e̠ro̠ ma̠a̠ a̠dila̠de d̠a̠ a̠de. ");
INSERT INTO mgj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sa̠ i̠na a̠bhin od̠ua̠l ikpogh abre̠di̠ bho̠ na̠ ina̠ bho̠, sa̠ a̠nigha̠ ma̠ ali̠se̠bh A̠zib̠a̠, sa̠ a̠pupugion a̠nigha̠ ma̠ ogbo ogir bho̠ ma̠ o̠ru̠gi̠ o̠lo̠gh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sa̠ eb̠la̠ awa id̠e ilegha̠n, sa̠ ikpokpo ma̠ i̠pe̠re̠pe̠r ya̠ isughia̠n bho̠ i̠lo̠gi̠ imuzoghod̠i ma̠ od̠ua̠l a̠rukpuom. ");
INSERT INTO mgj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ogbo ya̠ id̠e ma̠ abre̠di̠ bho̠, bha̠ d̠iobh o̠ni̠r (4,000) ilobhiri. U̠wal ani̠ d̠o̠ ma̠ ranwani̠ na̠ i̠gbara anwi̠i̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sa̠ i̠na a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ oten oyeleghu, sa̠ i̠na a̠d̠igh d̠a̠ oghugh agi̠ d̠a̠ ebhugh Amagadan. ");
INSERT INTO mgj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sa̠ Rafarisi bho̠ na̠ Rasadusi bho̠ iru ra̠ o̠d̠a A̠zizo̠s okpon, sa̠ ipuru ma̠ i̠na a̠leriom awa ma̠ elegh d̠a̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sa̠ i̠na awo̠ran awa ma̠a̠, “Igiel o̠b̠u̠ghu̠bu̠gh bho̠ ab̠am agu̠o̠ ododo ma̠ a̠dule, sa̠ inyin na̠ o̠gba ma̠a̠, ‘E̠mu̠ a̠d̠io bho̠ ta̠ a̠bhon.’ ");
INSERT INTO mgj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ya̠a̠ ka̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ ab̠am agu̠o̠ ododo sa̠ ade̠bh ad̠i̠ro̠, sa̠ inyin na̠ o̠gba ma̠a̠, ‘E̠mu̠ a̠d̠io bho̠ ko obhon d̠o̠ ma̠ a̠didon.’ Inyin na̠ orue na̠ obhin o̠b̠u̠ghu̠b̠u̠gh bho̠ na̠ ologhom agu̠o̠ e̠mu̠ a̠d̠io bho̠ ta̠ aro̠, ya̠a̠ inyin urue d̠o̠ ma̠ o̠mu̠gho̠nyan elegh wa̠ robhel ekunuguma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Amu̠m i̠basi̠ ola̠ oghila̠n d̠o̠ ma̠ A̠zib̠a̠, na̠ a̠puru ma̠ oleriom o̠yo̠ ma̠ elegh, ya̠a̠ elegh ola̠ ta̠ oleriom bo̠, a̠ten elegh ta̠ A̠zona̠.” Sa̠ i̠na awe̠le̠ awa a̠ten ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Igiel bho̠ ogbo atu̠ghan bho̠ na̠ i̠b̠e̠i̠y d̠a̠ aku̠b̠o̠ bho̠, sa̠ awa iloghoma̠n ma̠a̠ awa na̠ eweletia̠n o̠b̠ar na̠ abre̠di̠ obhin o̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sa̠ A̠zizo̠s a̠kikiom awa ma̠a̠, “Ilelegi, ma̠ ekpona̠ ma̠ a̠yist ta̠ Rafarisi bho̠ na̠ Rasadusi bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sa̠ awa ibhin a̠kikiom bho̠ id̠ighom d̠a̠ i̠b̠e̠re̠gi̠an ma̠a̠, “Agu̠o̠ i̠yar obhin d̠o̠ ma̠ abre̠di̠ oru bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ya̠a̠ A̠zizo̠s amu̠gho̠nyan abar wa̠ awa na̠ e̠b̠e̠re̠gi̠an bho̠, sa̠ agba ma̠a̠, “Inyin ogbo ya̠ ologi ima̠ra̠ o̠ghu̠a d̠o̠! Inyin udin ere na̠ o̠ku̠anan na̠ ogboloma̠ ma̠ agu̠o̠ inyin obhin d̠o̠ ma̠ abre̠di̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","I̠se̠n eka̠ bha̠ inyin ta̠ o̠mu̠gho̠nyan d̠o̠, bo̠d̠o̠ inyin urue d̠o̠ ma̠ o̠ru̠ru̠an, ma̠ o̠nu̠ o̠wal a̠rukpuom i̠pe̠re̠pe̠r abre̠di̠ ya̠ ipel d̠a̠ ogho ikpokpogh abre̠di̠ ya̠ d̠iobh na̠ i̠wal o̠ni̠r na̠ ogho e̠wala (5,000) a̠nwunom id̠e bho̠, ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bo̠d̠o̠ o̠nu̠ o̠wal a̠rukpuom ya̠ u̠te̠i̠ d̠a̠ od̠ua̠l ikpokpogh abre̠di̠ ya̠ d̠iobh o̠ni̠r (4,000) a̠nwunom id̠e sa̠ ipel bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eka̠ ma̠ ola̠ inyin o̠mu̠gho̠nyan d̠o̠ ma̠ ami̠ ifugh d̠o̠ a̠gboloma̠ ma̠ abre̠di̠? Ya̠a̠ ikpona̠ ma̠ a̠yist Rafarisi bho̠ na̠ Rasadusi bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I̠se̠ kisa̠ awa i̠mu̠gho̠nyan ma̠a̠, i̠na na̠ ofugh d̠o̠ a̠gboloma̠ ma̠ a̠yist abre̠di̠, ya̠a̠ i̠na agba a̠gboloma̠ ma̠ a̠d̠ien atu̠ghu̠me̠ni̠ ta̠ Rafarisi bho̠ na̠ Rasadusi bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sa̠ A̠zizo̠s agi̠ d̠a̠ ebhugh A̠sizeria̠ d̠a̠ A̠filipai̠, sa̠ a̠pura̠n ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “A̠nwunom na̠ e̠gba ma̠ O̠nyi̠ ta̠ O̠ni̠ ka̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “Idi na̠ e̠gba ma̠ anwa Azo̠n Owurmamu̠m bho̠, ipa̠n sa̠ na̠ e̠gba ma̠ anwa I̠lai̠za, ipa̠n ogbo sa̠ na̠ e̠gba ma̠ anwa A̠zerimaya, bo̠d̠o̠ ma̠ odi o̠ni̠ awa a̠riwil bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ya̠a̠ inyin na̠ o̠gba ma̠ ami̠ ka̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sa̠ Asai̠mo̠n A̠pita̠ awo̠ran ma̠a̠, “Anwa Akrai̠st, O̠nyi̠ ta̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “E̠b̠e̠l oyom Asai̠mo̠n, o̠nyi̠ ta̠ A̠zona̠. Ipulupul na̠ asi̠ i̠gba d̠o̠ ma̠ e̠wo̠gi̠na onon emutiom enigha̠ nyam, ya̠a̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sa̠ ami̠ na̠ ka̠ ab̠aram na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, anwa A̠pita̠, ami̠ ta̠ a̠lo ma̠ aso̠si̠ d̠ami̠ d̠a̠ anyu̠ o̠gbe̠o̠ma onon, sa̠ ra̠limon a̠d̠ugh ko orue d̠o̠ e̠ne̠gi̠me̠ni̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ami̠ ta̠ a̠nigha̠ nyam ri̠sabi̠ irileghom ote̠nai̠ny, sa̠ kere kere abar ola̠ anwa i̠bhad̠i̠ d̠a̠ a̠de bho̠ na̠ o̠bhad̠i̠ d̠a̠ ote̠nai̠ny, sa̠ ola̠ anwa i̠ko̠gi̠o̠n d̠a̠ a̠de bho̠, na̠ o̠ko̠gi̠o̠n d̠a̠ ote̠nai̠ny.” ");
INSERT INTO mgj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","D̠a̠ igiel obha̠ sa̠ i̠na aghaghana ma̠ ogbo atu̠ghan bho̠ ma̠ awa o̠gba d̠o̠ enigha̠ ma̠ o̠ni̠ ma̠ i̠na Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ob̠eton d̠a̠ igiel obha̠, sa̠ A̠zizo̠s ake̠ ma̠ o̠gba o̠se̠ghe̠ni̠ inigha̠ ogbo atu̠ghan d̠o̠yo̠ ma̠ agu̠o̠ akpe̠ i̠na ma̠ o̠gi̠ d̠a̠ A̠zeruse̠le̠m, ka̠ o̠bi̠gh a̠d̠izo ali̠gam a̠ruzu d̠a̠ aru̠gu̠o̠ ikei bho̠, na̠ ogbo aru̠mu̠ rokur bho̠, na̠ ogbo-atu̠ghu̠me̠ni̠ oloko bho̠, sa̠ awa ta̠ egigh I̠na, sa̠ i̠na ta̠ a̠b̠etina̠ d̠a̠ oleghemeni i̠sar a̠d̠a̠ma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sa̠ A̠pita̠ a̠bhin i̠na a̠ten d̠a̠ aka, sa̠ a̠bhin o̠gagaman okoroko a̠fugh a̠nigha̠ i̠na ma̠a̠, “Wa̠nwuna̠, ko ofugh o̠ku̠a. A̠zib̠a̠ a̠d̠ighi ma̠ e̠tu̠tu̠! Abar ola̠ o̠ku̠a omutuma̠ d̠o̠ nyam!” ");
INSERT INTO mgj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sa̠ i̠na a̠tiba̠ra̠ awo̠ran A̠pita̠ ma̠a̠, “Eru, tene d̠a̠ aman d̠ami̠! Anwa na̠ ad̠agi̠an ka̠ ami̠, ezin bho̠ anwa na̠ obhin d̠o̠ ma̠ i̠di̠ar ta̠ A̠zib̠a̠ atu̠o̠m abar, ya̠a̠ ya̠ igboloma̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “O̠ni̠ ola̠ na̠ e̠ral o̠tu̠o̠no̠m ami̠, a̠ghel ozu d̠o̠yo̠, a̠rol e̠mi̠gi̠re̠ni̠an oriren d̠o̠yo̠, atu̠o̠no̠m ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","O̠ni̠ wa̠ na̠ abho̠ro̠gh otenemeni a̠ghud̠um e̠mara̠nwunom d̠o̠yo̠ bho̠, ta̠ a̠robh a̠ghud̠um d̠o̠yo̠. Ya̠a̠, o̠ni̠ wa̠ atu̠n ami̠ a̠robh a̠ghud̠um e̠mara̠nwunom d̠o̠yo̠ bho̠, ta̠ ate̠i̠ a̠ghud̠um. ");
INSERT INTO mgj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ya̠a̠ a̠kere asu̠o̠, wa̠ o̠ni̠ ta̠ ate̠i̠ ka̠ a̠nwuna̠ ma̠ eb̠la̠ e̠mara̠nwunom bho̠, a̠dinom a̠ghud̠um d̠o̠yo̠? Bo̠d̠o̠, ka̠ o̠ni̠ ta̠ a̠bhin ere aru̠r a̠ghud̠um d̠o̠yo̠? ");
INSERT INTO mgj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ na̠ a̠ru na̠ isosorogia̠n ta̠ O̠we̠de̠ bho̠, seki̠na̠ itileduom d̠o̠yo̠, sa̠ ta̠ akpe̠ ma̠ o̠ni̠ i̠se̠ ma̠ ya̠ ilegha̠n ya̠ i̠na a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ya̠gia̠ga̠i, ami̠ na̠ akparame̠ni̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, idi inyin ya̠ i̠mara ma̠ i̠se̠n bho̠, ka̠ omugh d̠o̠ tu̠tu̠n ta̠ e̠bi̠gh eruoma̠ O̠nyi̠ ta̠ O̠ni̠ d̠a̠ irileghom d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Odin a̠d̠a̠ma̠ iten, sa̠ A̠zizo̠s a̠bhin A̠pita̠, na̠ A̠zemsi na̠ Azo̠n umor d̠o̠yo̠, sa̠ a̠bhin awa a̠bhun d̠a̠ anyu̠ igu esi ola̠ awa ku̠ku̠m i̠ro̠. ");
INSERT INTO mgj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sa̠ i̠na a̠nwegina̠ ma̠ ozu d̠a̠ a̠misigh d̠awa, sa̠ a̠misigh d̠o̠yo̠ amu̠ ma̠ agu̠o̠ ogogo bho̠, sa̠ ibura̠ d̠o̠yo̠ i̠war agu̠o̠ e̠b̠alab̠al. ");
INSERT INTO mgj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sa̠ A̠mozizi na̠ I̠lai̠za imite d̠a̠ a̠misigh d̠awa na̠ e̠b̠e̠re̠gi̠an i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sa̠ A̠pita̠ a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “Wa̠nwuna̠, ya̠ a̠bhon agu̠o̠ i̠yar od̠i ma̠ i̠se̠n bho̠! Ku̠gba ma̠ ta̠ a̠sora̠n bha̠, d̠ighi ami̠ igim i̠sar a̠rutu akpu̠ru̠ ma̠ esi onon: odi ta̠ aro̠ ma̠ ola̠ oyom, ya̠a̠ odi ta̠ aro̠ ma̠ ola̠ A̠mozizi, sa̠ odi ta̠ aro̠ ma̠ ola̠ I̠lai̠za.” ");
INSERT INTO mgj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","I̠na od̠id̠ia̠ na̠ a̠fugh, sa̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ a̠kpegiom awa. Sa̠ okoroko ad̠u̠a d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ a̠si a̠mite ma̠a̠, “Onon O̠nyi̠ etula̠n d̠ami̠, wa̠ na̠ a̠gir ya̠ na̠ ed̠igh ami̠ ma̠ ologi bho̠. I̠nagha i̠na!” ");
INSERT INTO mgj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sa̠ igiel bho̠ ogbo atu̠ghan bho̠ i̠mu̠gho̠n okoroko bho̠, sa̠ ibom a̠rugugu isibh awa, sa̠ imel ib̠obhia̠n. ");
INSERT INTO mgj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sa̠ A̠zizo̠s a̠ru ra̠ a̠kula̠n awa a̠fugh a̠nigha̠ awa ma̠a̠, “Ib̠egina̠, o̠ni̠ ko oghil a̠rugugu.” ");
INSERT INTO mgj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sa̠ awa ib̠egion ra̠misigh d̠awa, ya̠a̠ i̠bi̠gh d̠o̠ ma̠ opa̠n o̠ni̠ a̠ten i̠na A̠zizo̠s ku̠ku̠m. ");
INSERT INTO mgj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sa̠ agu̠o̠ awa na̠ esor d̠a̠ igu bho̠, sa̠ A̠zizo̠s anyagh ra̠to d̠awa agba ma̠a̠, “O̠ni̠ ko o̠gba ma̠ aghi̠m bho̠ ma̠ enigha̠ ma̠ o̠ni̠, tu̠tu̠n O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠b̠etina̠ d̠a̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sa̠ ogbo atu̠ghan bho̠ ipura̠n i̠na ma̠a̠, “I̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ i̠tu̠n ere na̠ e̠gba ma̠ I̠lai̠za ta̠ a̠d̠ia̠ a̠ru?” ");
INSERT INTO mgj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sa̠ i̠na awo̠ran a̠fugh ma̠a̠, “I̠lai̠za ta̠ a̠ru ga̠i, sa̠ ta̠ atu̠ghu̠man eb̠la̠ i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ya̠a̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ I̠lai̠za na̠ a̠ru a̠ten, ya̠a̠ a̠nwunom ilelegi d̠o̠ i̠na, kpe̠le̠me̠ni̠, awa irughom i̠na ma̠ iya̠ awa i̠to̠ d̠a̠ rologi d̠awa. Obha̠ agu̠o̠ na̠ a̠tua̠n nyen O̠nyi̠ ta̠ O̠ni̠ ma̠ ogbika̠ d̠a̠ aru̠gu̠o̠ d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","I̠se̠ kisa̠ ogbo atu̠ghan bho̠ i̠mu̠gho̠nyan ma̠a̠, o̠ni̠ wa̠ i̠na a̠fugh na̠ a̠gboloma̠ na̠ a̠nigha̠ awa bho̠ ma̠ Azo̠n owurmamu̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sa̠ awa iru ra̠ i̠te̠i̠ o̠lo̠gh a̠nwunom bho̠, sa̠ odi o̠ni̠ a̠ru d̠o̠yo̠ ra̠ a̠kpuluma̠n a̠nigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Sa̠ o̠ni̠ bho̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, kpone ma̠ igbirigbir o̠nyi̠ d̠ami̠, ezin bho̠ i̠na na̠ anwe̠r asu̠nwe̠r ena̠ ola̠ na̠ a̠nyegi i̠na. A̠d̠izo robhel na̠ a̠robh i̠na na̠ alo̠gh d̠a̠ anya, bo̠d̠o̠ d̠a̠ amu̠m. ");
INSERT INTO mgj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sa̠ ami̠ ibhin i̠na iruom ogbo atu̠ghan d̠oyom, ya̠a̠ awa irue d̠o̠ ma̠ okoko o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sa̠ A̠zizo̠s awo̠ran a̠fugh ma̠a̠, “Sei, amu̠m ola̠ ologi ima̠ra̠ o̠to̠, ya̠ na̠ erugh ado̠l i̠te̠i̠! Ami̠ ta̠ aro̠ na̠ inyin a̠bia̠ eka̠? Ami̠ ta̠ a̠ne ma̠ ado̠l d̠inyin ka̠ ate̠i̠ eka̠? Ibhine ma̠ o̠nyi̠ bho̠ ma̠ eruom ami̠ ma̠ i̠se̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sa̠ A̠zizo̠s ab̠ab̠agi̠na ma̠ o̠karabh e̠mu̠gh bho̠, sa̠ a̠mite ad̠u̠a d̠a̠ ozu o̠nyi̠ bho̠, sa̠ i̠na a̠d̠um epa̠ ma̠ onin obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","I̠se̠, sa̠ ogbo atu̠ghan bho̠ iru ra̠ ipura̠n A̠zizo̠s d̠a̠ a̠d̠ukun ma̠a̠, “Ezin ka̠ ere ma̠ ola̠ i̠yar orue d̠o̠ ma̠ oze o̠karabh e̠mu̠gh bho̠ o̠si̠ghe̠?” ");
INSERT INTO mgj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sa̠ i̠na awo̠ran awa ma̠a̠, “Ezin bho̠ ologi ima̠ra̠ d̠inyin ta̠ o̠ghu̠a d̠o̠. Ya̠gia̠ga̠i, ami̠ na̠ akparame̠ni̠ na̠ agba ma̠a̠, ka̠ inyin u̠te̠i̠ ologi ima̠ra̠ ola̠ od̠i ma̠ agu̠o̠ ekpo oriren amu̠stad sa̠ inyin ufugh unigha̠ ma̠ igu onon ma̠a̠, ‘B̠etina̠ ma̠ i̠se̠n ka̠ aro̠ ma̠ ebha̠,’ sa̠ ta̠ a̠b̠etina̠. Abar ola̠ ta̠ akpar a̠pu inyin ogir ka̠ o̠ro̠ d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ya̠a̠ a̠ten d̠a̠ a̠siseiny na̠ one o̠ko̠i̠ bo̠d̠o̠, ola̠ o̠ko̠no̠n ko orue d̠o̠ ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","D̠a̠ igiel bho̠ awa inwe ikokod̠ia̠n d̠a̠ Agalili bho̠, sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “Na̠ a̠tua̠n igiel ta̠ owol O̠nyi̠ ta̠ O̠ni̠ ob̠eton o̠lo̠gh d̠a̠ agu̠o̠ ogbo ya̠ od̠i d̠a̠ a̠dila̠de a̠limon. ");
INSERT INTO mgj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Sa̠ awa ta̠ egigh i̠na, sa̠ d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠, sa̠ i̠na ta̠ a̠b̠etina̠ d̠a̠ omugh.” Sa̠ ogbo atu̠ghan d̠o̠yo̠ id̠igh ibom i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sa̠ agu̠o̠ awa id̠igh d̠a̠ Akapanu̠m bho̠, sa̠ igunmotua̠ Otu ta̠ A̠zib̠a̠ iru ra̠ i̠te̠i̠ A̠pita̠ ipura̠n ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠ d̠inyin na̠ a̠tua̠gha̠n otua̠ okpoki i̠wal e̠mu̠ a̠d̠uma̠ ogir bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sa̠ i̠na awo̠ran ma̠a̠, “Yii,” i̠na na̠ akpe̠, ya̠a̠ igiel i̠na a̠d̠igh d̠a̠ ologi otu bho̠, sa̠ A̠zizo̠s awalama a̠pura̠n i̠na ma̠a̠, “Asai̠mo̠n, anwa i̠bi̠gh eka̠? Aru̠lala e̠mara̠nwunom bho̠ na̠ esobh otua̠ na̠ enigha̠ ma̠ anwi̠i̠ny d̠awa ke̠re̠, bo̠d̠o̠ ka̠ na̠ egun d̠a̠ agu̠o̠ risoloma̠?” ");
INSERT INTO mgj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sa̠ A̠puta̠ awo̠ran ma̠a̠, “D̠a̠ agu̠o̠ risoloma̠.” Sa̠ A̠zizo̠s a̠fugh ma̠a̠, “O̠ku̠a sa̠ anwi̠i̠ny bho̠ id̠igh ani̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ya̠a̠, agu̠o̠ ola̠ ko o̠gamame̠ni̠ d̠o̠ ma̠ rologi d̠awa, bha̠ sore d̠a̠ o̠bhi̠i̠y ka̠ ato̠ri̠ ma̠ amu̠kpabh, sa̠ o̠pu̠r ena̠ wa̠ anwa ta̠ a̠kor bho̠, bha̠ b̠etone ma̠ akpato̠n o̠nu̠ bho̠, sa̠ anwa ta̠ abi̠gh okpoki. Bhine ma̠ ka̠ a̠tua̠ ma̠ a̠bin d̠ami̠ na̠ ita̠ oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","D̠a̠ igiel obha̠, sa̠ ogbo atu̠ghan bho̠ iru ra̠ ipura̠n A̠zizo̠s ma̠a̠, “A̠nyen o̠ni̠ wa̠ abu̠gh a̠pu d̠a̠ irileghom ote̠nai̠ny bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sa̠ i̠na a̠bhelegi ma̠ o̠gbara o̠nyi̠ ra̠ amarame̠ni̠ d̠a̠ esa̠d̠io d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sa̠ a̠fugh ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ka̠ rologi d̠inyin onwegia̠n d̠o̠ e̠ro̠ ma̠ agu̠o̠ ita̠ i̠gbara anwi̠i̠ny, inyin ko od̠igh d̠o̠ d̠a̠ irileghom ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ezin bho̠, o̠ni̠ wa̠ aki̠ri̠me̠ni̠ ma̠ ozu d̠o̠yo̠ ma̠ agu̠o̠ o̠gbara o̠nyi̠ onon, bha̠ wa̠ abu̠gh a̠pu d̠a̠ irileghom ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sa̠ o̠ni̠ ola̠ a̠d̠ighom o̠nyi̠ ola̠ o̠ku̠a d̠a̠ ebula̠ a̠d̠ien d̠ami̠, bha̠ a̠d̠ighom ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ali̠gam ta̠ o̠ni̠ ola̠ o̠kpu̠o̠m o̠gbe̠o̠ma d̠a̠ orum bho̠ ud̠ineni d̠a̠ esa̠d̠io abadi̠, ta̠ a̠bhon a̠pu ma̠ uta̠ o̠ni̠ ola̠ a̠d̠ighi ma̠ ola̠ odi okubh o̠nyi̠ d̠a̠ anwi̠i̠ny i̠nye̠n ya̠ ima̠ra̠ ami̠ bho̠ ma̠ omel od̠igh d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Olo a̠leghe ma̠ e̠mara̠nwunom d̠a̠ ebula̠ rad̠agi̠an ya̠ na̠ ed̠ighi ma̠ ola̠ a̠nwunom na̠ egir i̠karabh. Rad̠agi̠an ya̠ o̠ku̠a ko o̠we̠le̠ d̠o̠ ma̠ omite, ya̠a̠ olo a̠leghe ma̠ o̠ni̠ wa̠ ad̠agi̠an ta̠ e̠wo̠l d̠o̠yo̠ emite bho̠! ");
INSERT INTO mgj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ku̠gba ma̠a̠ agu̠o̠ bo̠d̠o̠ a̠wel d̠oyom na̠ a̠d̠ighi nyam ogir i̠karabh, sobhe ma̠ asi̠ghe̠ ma̠ a̠robh. Anwa ma̠ obhin ekud̠i agu̠o̠, bo̠d̠o̠ o̠ro̠ ukula̠ ka̠ od̠igh d̠a̠ a̠ghud̠um a̠bhon a̠pu ma̠ aru̠gu̠o̠ d̠oyom bo̠d̠o̠ a̠sike d̠oyom olegha̠n, sa̠ ta̠ orobh anwa o̠lo̠gh d̠a̠ anya wa̠ ko od̠im d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ku̠gba ma̠a̠ ekpo a̠d̠ien d̠oyom na̠ a̠d̠ighi nyam ogir i̠karabh, poko ma̠ asi̠ghe̠ ma̠ a̠robh. Anwa ma̠ obhin onin ekpo a̠d̠ien od̠igh d̠a̠ a̠ghud̠um a̠bhon a̠pu ma̠ anwa ma̠ onwuna̠ i̠wal ikpo a̠rid̠ien, sa̠ ta̠ orobh anwa o̠lo̠gh d̠a̠ ogugua̠ anya. ");
INSERT INTO mgj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“I̠bi̠ghe̠, o̠ni̠ ko okpon bebina̠ onin d̠a̠ ikubh anwi̠i̠ny i̠nye̠n egurumeni. Ezin bho̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, itileduom ta̠ A̠zib̠a̠ d̠awa na̠ e̠ro̠ ma̠ eb̠la̠ obhel d̠a̠ a̠misigh ta̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ a̠ru ra̠ otenemeni ogbo ya̠ na̠ ebhe bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Inyin u̠bi̠gh eka̠, ku̠gba ma̠a̠ o̠ni̠ a̠nwuna̠ ma̠ i̠wal e̠wala na̠ a̠d̠usubh (100) ro̠nana, sa̠ odi d̠a̠ o̠lo̠gh d̠awa a̠bhe, i̠na ka̠ o̠we̠le̠ d̠o̠ ma̠ i̠wal e̠wala na̠ d̠iobh na̠ esugho (99) bho̠ d̠a̠ a̠rugugum bho̠, agi̠ ka̠ abho̠ro̠ghan wa̠ a̠bhe bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sa̠ ku̠gba ma̠a̠ i̠na abi̠gh, ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠na ta̠ a̠bo a̠gboloma̠ ma̠ o̠nana wa̠ a̠bhe bho̠ a̠pu ma̠ i̠wal e̠wala na̠ d̠iobh na̠ esugho (99) ya̠ obhe d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Obha̠ agu̠o̠ od̠i, bo̠ d̠a̠ ologi O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ ma̠ odi o̠nyi̠ d̠a̠ ikubh anwi̠i̠ny i̠nye̠n omugh. ");
INSERT INTO mgj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ku̠gba ma̠a̠, umor d̠oyom a̠d̠ighi nyam ma̠ i̠karabh, gi̠e̠ ka̠ agba ma̠ a̠nigha̠ i̠na ma̠ esi ola̠ i̠wal inyin ku̠ku̠m od̠i. Ku̠gba ma̠a̠ i̠na anagha nyam, bha̠ anwa na̠ a̠mula̠ ate̠i̠ umor d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ya̠a̠, ku̠gba ma̠a̠ i̠na na̠ o̠nagha d̠o̠ nyam, bha̠ barame̠ na̠ opa̠n o̠ni̠ bo̠d̠o̠ i̠wal o̠ni̠ ma̠ agu̠o̠ ola̠ awa ta̠ e̠bi̠gh ani̠. I̠wal bo̠d̠o̠ i̠sar ronyob̠a̠ na̠ e̠gba ma̠ onyob̠a̠ na̠ e̠kparame̠ni̠ ma̠ iku. ");
INSERT INTO mgj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ya̠a̠, ku̠gba ma̠a̠ i̠na na̠ o̠nagha d̠o̠, bha̠ gba d̠a̠ a̠kokod̠ia̠n bho̠. Sa̠ ku̠gba ma̠a̠ i̠na na̠ o̠nagha d̠o̠ ma̠ a̠kikiom a̠kokod̠ia̠n bho̠ nyen, bha̠ ibhine i̠na ma̠ agu̠o̠ obhebhia̠n bo̠d̠o̠ ogun ma̠ otua̠ ebhugh. ");
INSERT INTO mgj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, kerekere abar ola̠ u̠gho̠ro̠gi̠ d̠a̠ a̠de bho̠, na̠ o̠gho̠ro̠gi̠ d̠a̠ ote̠nai̠ny, sa̠ kerekere abar ola̠ u̠ko̠gi̠o̠n d̠a̠ a̠de bho̠, na̠ o̠ko̠gi̠o̠n d̠a̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“O̠lo̠gho̠m i̠se̠, ya̠gia̠ga̠i, ku̠gba ma̠a̠ i̠wal o̠ni̠ inyin enwuna̠ ma̠ onin ologi d̠a̠ a̠de bho̠ egboloma̠ kerekere abar, O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ ta̠ a̠muzughod̠iom a̠nigha̠ awa ma̠ ya̠ ipuru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ezin bho̠, esi ola̠ i̠wal bo̠d̠o̠ i̠sar o̠ni̠ ibhin a̠d̠ien d̠ami̠ ikokod̠ia̠n, ami̠ od̠i ma̠ i̠se̠ d̠a̠ esa̠d̠io d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sa̠ A̠pita̠ a̠ru d̠a̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “Wa̠nwuna̠, i̠ni̠ igiel ya̠ ka̠ umor d̠ami̠ a̠d̠ighi ami̠ ma̠ i̠karabh sa̠ ami̠ ta̠ awe̠le̠man a̠nigha̠ bho̠? Agu̠o̠ od̠ua̠l igiel ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, od̠ua̠l (7) igiel d̠o̠, kpe̠le̠me̠ni̠, od̠ua̠l (7) igiel ta̠ e̠rabharabh na̠ d̠iobh (70). ");
INSERT INTO mgj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, irileghom ote̠nai̠ny agu̠b̠an o̠li̠le̠ma ola̠ na̠ a̠ru ra̠ okpon o̠wal ikpoki ogir ta̠ rob̠a̠ra̠motu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Agu̠o̠ i̠na ake̠ na̠ a̠kpon bho̠, sa̠ ubhin o̠ni̠ ola̠ a̠d̠igh i̠na ma̠ o̠mu̠gh a̠d̠usubh na̠ ogho o̠ni̠r (10,000) ami̠na. ");
INSERT INTO mgj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ya̠a̠, agu̠o̠ orue d̠o̠ ma̠ o̠kpe̠ bho̠ sa̠ wa̠nwuna̠ bho̠ a̠ruom ma̠ owol i̠na, na̠ ani̠ bho̠, na̠ anwi̠i̠ny bho̠, na̠ eb̠la̠ i̠di̠ar d̠o̠yo̠ obhin o̠kpe̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Sa̠ ob̠a̠ra̠motu bho̠ a̠mel a̠de a̠kpud̠ia̠n i̠na a̠fugh ma̠a̠, ‘Kpone ami̠ igbirigbir ma̠ a̠ne ma̠ ekud̠i obhel, sa̠ ami̠ ta̠ akpe̠ nyam kerekere abar.’ ");
INSERT INTO mgj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sa̠ wa̠nwuna̠ bho̠ a̠kpon igbirigbir ob̠a̠ra̠motu bho̠, sa̠ awe̠le̠man i̠na a̠gbogion o̠mu̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ya̠a̠ igiel bho̠ ob̠a̠ra̠motu obha̠ ad̠u̠a sa̠ abi̠gh odi ob̠a̠ra̠motu ola̠ a̠d̠igh o̠mu̠gh i̠wal e̠wala na̠ a̠dusubh (100) a̠dinari̠ d̠a̠ agu̠o̠ d̠o̠yo̠ bho̠, sa̠ a̠ghinigia̠n i̠na, adu̠ ma̠ e̠d̠o̠gh bho̠ a̠fugh ma̠a̠, ‘Kpe̠ ma̠ eb̠la̠ i̠mu̠gh ya̠ anwa na̠ a̠d̠igh d̠a̠ agu̠o̠ d̠ami̠ bho̠!’ ");
INSERT INTO mgj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Sa̠ ob̠a̠ra̠motu wa̠ na̠ i̠na na̠ ogir bho̠, a̠mel d̠a̠ a̠de ale̠gh i̠na a̠fugh ma̠a̠, ‘Kpone ami̠ igbirigbir ma̠ a̠ne ma̠ ekud̠i obhel, sa̠ ami̠ ta̠ akpe̠ nyam kerekere abar.’ ");
INSERT INTO mgj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ya̠a̠, i̠na na̠ oma̠ra̠ d̠o̠, kpe̠le̠me̠ni̠, a̠b̠ol i̠na ka̠ alo̠gh d̠a̠ ikoli tu̠tu̠n akpe̠ ma̠ eb̠la̠ i̠mu̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Igiel bho̠ rob̠a̠ra̠motu iyed̠i i̠mu̠gho̠n bho̠, sa̠ awa i̠kakanyi̠gha ma̠ ibom, sa̠ i̠gi̠ ka̠ i̠gba inigha̠ ma̠ wa̠nwuna̠ d̠awa ma̠ i̠di̠ar ya̠ imite bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ebula̠ o̠ku̠a, sa̠ wa̠nwuna̠ d̠o̠yo̠ a̠lebh i̠na a̠fugh ma̠a̠, ‘Anwa obom o̠karabh ob̠a̠ra̠motu. Ami̠ i̠tu̠n agu̠o̠ anwa i̠le̠gh ami̠ bho̠ awe̠le̠man eb̠la̠ i̠mu̠gh d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na̠ o̠kpe̠ d̠o̠ nyam nyen okpon igbirigbir ob̠a̠ra̠motu wa̠ na̠ anwa na̠ ogir bho̠, ma̠ agu̠o̠ ami̠ ikpon anwa ma̠ igbirigbir bho̠ ke̠re̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sa̠ ologi ta̠ wa̠nwuna̠ d̠o̠yo̠ agam sa̠ a̠bhin i̠na a̠nigha̠ ma̠ ogbo ya̠ na̠ egbikimeni ma̠ a̠nwunom bho̠, tu̠tu̠n ta̠ akpe̠ ma̠ eb̠la̠ i̠mu̠gh bho̠ amado̠n. ");
INSERT INTO mgj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Obha̠ agu̠o̠ O̠we̠de̠ d̠ami̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ ta̠ a̠d̠ighi nyen, ku̠gba ma̠a̠ o̠ni̠ inyin na̠ obhin d̠o̠ d̠a̠ ologi d̠o̠yo̠ awe̠le̠man i̠karabh umor d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Igiel bho̠ A̠zizo̠s a̠kunugiom atu̠ghu̠me̠ni̠ i̠nye̠n bho̠, sa̠ i̠na ad̠u̠a d̠a̠ Agalili agi̠ d̠a̠ Azo̠dan agba ebhugh A̠zudia̠. ");
INSERT INTO mgj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m i̠na, sa̠ i̠na a̠koko awa ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sa̠ idi Rafarisi iru d̠o̠yo̠ ra̠ i̠d̠a i̠na ikpon ipura̠n ma̠a̠, “Ezin ola̠ a̠sora̠n o̠ni̠ ma̠ odin oze ani̠ d̠o̠yo̠ od̠i ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sa̠ i̠na awo̠ran awa ma̠a̠, “Inyin ta̠ osen d̠o̠ o̠bi̠gh ma̠a̠, uwa̠ ale̠m awa d̠a̠ o̠pu̠r ob̠eton bho̠, ale̠m awa ma̠ o̠ya na̠ olobhiri ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sa̠ a̠fugh ma̠a̠, ‘Ebula̠ o̠ku̠a, o̠ni̠ ta̠ awe̠le̠ ma̠ o̠we̠de̠ na̠ oweni d̠o̠yo̠, sa̠ ta̠ agi̠ ka̠ akpabhan ani̠ d̠o̠yo̠, sa̠ i̠wal awa ta̠ eten onin ozu ku̠ku̠m?’ ");
INSERT INTO mgj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sa̠ ta̠ aro̠ ma̠ ola̠ o̠ni̠ ko onwuna̠ mu ma̠ ozu ola̠ o̠yo̠ d̠a̠ i̠wal awa, ya̠a̠ onin ozu ku̠ku̠m. O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠di̠ar iya̠ A̠zib̠a̠ na̠ atu̠lo̠m a̠guri onin bho̠, o̠nyi̠o̠mo̠ro̠ni̠ o̠bagi̠o̠n d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sa̠ awa ipura̠n i̠na ma̠a̠, “Ku̠gba ma̠ o̠ku̠a ka̠ A̠mozizi a̠din ere agba ma̠a̠, o̠ni̠ a̠nigha̠ ma̠ ani̠ d̠o̠yo̠ ma̠ a̠d̠ire ogbogina̠ ilom a̠bhin a̠ze i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “A̠mozizi a̠din rab̠agh e̠mu̠ d̠inyin a̠ma̠ra̠ inyin ozegi ranwani̠ d̠inyin. Ya̠a̠ na̠ o̠ro̠ d̠o̠ ma̠ o̠ku̠a d̠a̠ o̠pu̠r ob̠eton bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya̠a̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ a̠gbogina̠ ma̠ ani̠ d̠o̠yo̠, a̠sigimeni d̠a̠ ebula̠ ari̠gi̠, sa̠ agi̠ ka̠ a̠bhin opa̠n ani̠, bha̠ a̠sor oloko od̠e e̠ma.” ");
INSERT INTO mgj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sa̠ ogbo atu̠ghan d̠o̠yo̠ ifugh inigha̠ i̠na ma̠a̠, “Ku̠gba ma̠a̠ e̠do̠lo̠ghu̠ma ta̠ ani̠ na̠ owolom od̠i ma̠ o̠ko̠no̠n, sa̠ o̠we̠le̠man o̠walan ilom ta̠ a̠bhon a̠pu.” ");
INSERT INTO mgj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Ko̠ni̠ko̠ni̠ ko orue d̠o̠ ada ma̠ ikpo a̠fugh i̠nye̠n a̠bhin, ya̠a̠, ogbo ya̠ na̠ o̠to̠ onigha̠ bho̠ ku̠ku̠m. ");
INSERT INTO mgj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ezin bho̠, ugiri ma̠ idi ka̠ d̠a̠ okurogh onweni ma̠ o̠ro̠ ibhogha̠n ilobhiri kisa̠ u̠maragi̠, ya̠a̠ idi sa̠ a̠nwunom ibhoghi itenemeni ma̠ ibhogha̠n ilobhiri, idi sa̠ awa na̠ agu̠o̠ isibhom ozu iten ibhogha̠n ilobhiri d̠a̠ ebula̠ irileghom ote̠nai̠ny. O̠ni̠ wa̠ ta̠ a̠rue ada ma̠ atu̠ghu̠me̠ni̠ i̠nye̠n a̠bhin bho̠, bha̠ ada a̠bhin!” ");
INSERT INTO mgj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","D̠a̠ obhel obha̠, sa̠ a̠nwunom ibhin i̠gbara anwi̠i̠ny iru d̠o̠yo̠, ma̠ i̠na ma̠ o̠gbam agu̠o̠ otutumeni, sa̠ ogbo atu̠ghan bho̠ ikigima̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ya̠a̠ A̠zizo̠s a̠fugh ma̠a̠, “Ima̠ra̠ ma̠ i̠gbara anwi̠i̠ny bho̠ eru d̠ami̠, o̠ni̠ ko okigima̠ awa, ezin bho̠ irileghom ote̠nai̠ny aro̠ a̠nigha̠ ma̠ ogbo ya̠ od̠i ma̠ agu̠o̠ awa.” ");
INSERT INTO mgj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Igiel bho̠ i̠na na̠ agbam awa ma̠ agu̠o̠ awe̠le̠ bho̠, sa̠ i̠na a̠d̠igh erile ad̠u̠a ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sa̠ odi o̠ni̠ a̠ru ra̠ a̠pura̠n i̠na ma̠a̠, “O̠ni̠-atu̠ghu̠me̠ni̠, ami̠ ta̠ a̠gir a̠kere ob̠eb̠i abar ma̠ agu̠o̠ ola̠ o̠te̠i̠ a̠ghud̠um ya̠ ekunuguma̠ o̠to̠?” ");
INSERT INTO mgj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sa̠ A̠zizo̠s awo̠ran i̠na a̠fugh ma̠a̠, “Anwa i̠tu̠n ere na̠ a̠pura̠n ami̠ ma̠ ya̠ igboloma̠ ma̠ abar ola̠ aro̠ ma̠ ob̠eb̠i? A̠zib̠a̠ ku̠ku̠m ob̠eb̠i. Ya̠a̠, agu̠o̠ anwa na̠ abho̠ro̠ghan o̠te̠i̠ a̠ghud̠um bho̠, bha̠ koko ma̠ roloko bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sa̠ o̠ni̠ bho̠ a̠pura̠n i̠na ma̠a̠, “Iken?” Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “ Ko ogigh o̠ni̠, ko od̠e ma̠ e̠ma, ko ob̠igh a̠b̠igh, ko o̠gba ma̠ onyob̠a̠ igunugha̠, ");
INSERT INTO mgj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ onweni na̠ o̠we̠de̠ d̠oyom,’ ma̠ ‘a̠tula̠n o̠ni̠ wa̠ d̠a̠ aka d̠oyom ma̠ agu̠o̠ ozu d̠oyom.’” ");
INSERT INTO mgj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sa̠ okubh o̠ni̠ bho̠ awo̠ran i̠na ma̠a̠, “Ami̠ na̠ a̠koko ma̠ eb̠la̠ roloko i̠nye̠n. Abar wa̠ a̠sughonom ami̠ ma̠ ogir bho̠, ka̠ ere?” ");
INSERT INTO mgj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “Agu̠o̠ anwa na̠ abho̠ro̠ghan obhon olegha̠n bho̠, gi̠e̠ ka̠ a̠wol eb̠la̠ i̠di̠ar d̠oyom ma̠ a̠bhin a̠nigha̠ ma̠ ronyigoiny bho̠, sa̠ anwa ta̠ ate̠i̠ e̠li̠la d̠a̠ ote̠nai̠ny, ma̠ a̠ru ra̠ atu̠o̠no̠m ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ya̠a̠ igiel bho̠ okubh o̠ni̠ bho̠ amu̠gho̠n e̠kal onon bho̠, sa̠ i̠na aku̠ru̠ru̠ a̠ten ad̠u̠a, ezin bho̠ i̠na obom o̠li̠la. ");
INSERT INTO mgj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ akpar ibom ma̠ o̠li̠la ma̠ od̠igh d̠a̠ irileghom ote̠nai̠ny! ");
INSERT INTO mgj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ami̠ na̠ abaram na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, e̠nam-a̠dol o̠wo̠l d̠a̠ oyol anu̠ga oten ta̠ a̠b̠ur a̠pu ma̠ o̠li̠la o̠ni̠ ma̠ od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Igiel bho̠ ogbo atu̠ghan bho̠ i̠mu̠gho̠n i̠nye̠n bho̠, sa̠ ib̠a̠gha̠gha̠ ma̠ ibom ipura̠n ma̠a̠, “O̠ku̠a ka̠ a̠nyen ta̠ a̠rue ate̠i̠ itenemeni?” ");
INSERT INTO mgj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sa̠ A̠zizo̠s a̠kimeni a̠kpon awa agba ma̠a̠, “D̠a̠ o̠nyi̠o̠mo̠ro̠ni̠, bho̠ onon ka̠ orue d̠o̠ a̠mite, ya̠a̠ d̠a̠ A̠zib̠a̠, bha̠ eb̠la̠ i̠di̠ar eb̠ur.” ");
INSERT INTO mgj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sa̠ A̠pita̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Bi̠ghe̠, i̠yar na̠ o̠we̠le̠man eb̠la̠ i̠di̠ar d̠i̠yar na̠ o̠tu̠o̠no̠m anwa. Ere wa̠ i̠yar ta̠ o̠te̠i̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ya̠gia̠ga̠i, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ya̠ na̠ e̠tu̠o̠no̠m ami̠ bho̠ ma̠a̠, d̠a̠ omom amu̠m bho̠, ma̠ igiel O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ d̠a̠ i̠kasi̠ a̠dila̠de isosorogia̠n d̠o̠yo̠ bho̠, inyin eka̠ ta̠ o̠ro̠ d̠a̠ d̠iobh na̠ i̠wal (12) ri̠kasi̠ erileghom d̠iobh na̠ i̠wal (12) roghol Izre̠l. ");
INSERT INTO mgj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sa̠ ko̠ni̠ko̠ni̠ ola̠ awe̠le̠man eghunotu, bo̠d̠o̠ a̠rumor, bo̠d̠o̠ aru̠marani̠, bo̠d̠o̠ o̠we̠de̠, bo̠d̠o̠ onweni, bo̠d̠o̠ anwi̠i̠ny, bo̠d̠o̠ ari̠si̠ d̠a̠ ebula̠ ami̠, sa̠ i̠na ta̠ ate̠i̠ i̠wal e̠wala na̠ a̠d̠usubh (100) o̠gbam, sa̠ ta̠ a̠nwuna̠ ma̠ a̠ghud̠um ekunuguma̠ o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ya̠a̠, a̠d̠izo a̠nwunom ya̠ od̠i ma̠ i̠pu̠r i̠se̠n bho̠ ta̠ e̠ro̠ ma̠ u̠man, sa̠ a̠d̠izo ya̠ od̠i ma̠ u̠man i̠se̠n bho̠ ta̠ e̠ro̠ ma̠ i̠pu̠r. ");
INSERT INTO mgj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ta̠ obhin irileghom ote̠nai̠ny o̠tu̠o̠m o̠ni̠ ola̠ a̠nwuna̠ ma̠ a̠lei a̠grep, sa̠ a̠mite ma̠ ad̠i̠ro̠ ka̠ ako̠ ma̠ ogbo ogir agu̠o̠ ola̠ ta̠ e̠gi̠ ka̠ egir d̠a̠ a̠lei a̠grep d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sa̠ i̠na amu̠gho̠nyan na̠ ogbo ogir bho̠ ma̠ o̠kpe̠ o̠ni̠ i̠se̠ ma̠ onin a̠dinari̠ ma̠ e̠mu̠ a̠d̠a̠ma̠, sa̠ a̠ruom awa ma̠ e̠gi̠ d̠a̠ a̠lei d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Sa̠ i̠na a̠mula̠ a̠mite d̠a̠ esugho obhel ma̠ asi̠ro̠, sa̠ abi̠gh ipa̠n a̠nwunom ka̠ i̠mara d̠a̠ egbolom a̠b̠ua̠ ya̠a̠ abar ogir bo̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sa̠ i̠na agba ma̠a̠, ‘Inyin eka̠ i̠gi̠e̠ d̠a̠ a̠lei bho̠ sa̠ ami̠ ta̠ a̠kpon ya̠ i̠kpe̠ akpe̠ inyin.’ ");
INSERT INTO mgj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sa̠ awa i̠gi̠ epa̠. “Sa̠ a̠mula̠ a̠mite d̠a̠ d̠iobh na̠ i̠wal obhel na̠ d̠a̠ i̠sar obhel d̠a̠ etita̠n a̠gir onin agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sa̠ a̠mula̠ a̠mite d̠a̠ ogho obhel d̠a̠ a̠dule ka̠ ami̠nana ma̠ ipa̠n ogbo ya̠ od̠i ma̠ e̠mara, sa̠ i̠na a̠pura̠n awa ma̠a̠, ‘Ezin ka̠ ere ma̠ ola̠ inyin na̠ o̠mara ma̠ i̠se̠n eb̠la̠ e̠mu̠ a̠d̠a̠ma̠ bho̠, ugir d̠o̠ abar?’ ");
INSERT INTO mgj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Sa̠ awa i̠wo̠ran i̠na ma̠a̠, ‘O̠ni̠ ola̠ a̠bhin i̠yar ogir bo̠.’ Sa̠ i̠na a̠ruom awa ma̠a̠, ‘Inyin eka̠ i̠gi̠e̠ d̠a̠ a̠lei bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sa̠ agu̠o̠ a̠d̠io na̠ a̠gul bho̠, sa̠ wa̠nwuna̠ ma̠ a̠lei bho̠ a̠ruom we̠mu̠ ogir d̠o̠yo̠ ma̠ a̠bhelegi ma̠ ogbo od̠ighi bho̠ akpe̠gi̠ awa ma̠ ya̠ awa igir bho̠, sa̠ ake̠ d̠a̠ ya̠ o̠gu̠man bho̠ akpe̠ ka̠ a̠kunugiom d̠a̠ i̠pu̠r bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Sa̠ i̠na akpe̠ ma̠ ogbo ya̠ iru d̠a̠ d̠iobh na̠ onin obhel bho̠, o̠ni̠ i̠se̠ onin a̠dinari̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sa̠ ogbo ya̠ ib̠on iru bho̠ i̠ru̠ru̠an ma̠ i̠na ta̠ o̠kpe̠ a̠wa opeleni ma̠ o̠ku̠a, ya̠a̠ u̠kpe̠ awa nyen o̠ni̠ i̠se̠ onin a̠dinari̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Awa i̠da ibhin, sa̠ i̠go̠ya inigha̠ ma̠ wa̠ a̠nwuna̠ ma̠ otu bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ma̠a̠, ‘I̠nye̠n ya̠ o̠gu̠man bho̠ igir onin awa-obhel ku̠ku̠m, sa̠ u̠kpe̠ awa na̠ i̠yar onin agu̠o̠, ogbo ya̠ ugir etita̠n a̠d̠io ub̠ogina̠ bho̠ sa̠ u̠nu̠nu̠an e̠si̠so̠ ogogo bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Sa̠ i̠na awo̠ran odi awa ma̠a̠, ‘A̠tologha̠n, o̠karabh ola̠ ami̠ d̠ighi nyam bo̠. U̠mu̠gho̠nyan d̠o̠ ma̠ akpe̠gi̠an onin a̠dinari̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bhine ma̠ otoyom ma̠ ad̠u̠a, ami̠ i̠kpe̠ ma̠ o̠ni̠ onon wa̠ a̠ru ma̠ o̠gu̠man bho̠ ma̠ onin agu̠o̠ bho̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bo̠d̠o̠, na̠ osora̠n d̠o̠ ami̠ ma̠ obhin ya̠ ologi d̠ami̠ ogir ogboloma̠ i̠di̠ar d̠ami̠ ke̠re̠? Bo̠d̠o̠, anwa na̠ a̠nwuna̠ ma̠ obom ekpo a̠d̠ien na̠ a̠gboloma̠ ma̠ e̠ne̠ghe̠ ya̠ ami̠ i̠ne̠ghe̠ bho̠ ke̠re̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Obha̠ agu̠o̠ ta̠ aro̠, iya̠ o̠gu̠man bho̠ ta̠ eten i̠pu̠r, sa̠ i̠pu̠r bho̠ ta̠ eten iya̠ o̠gu̠man.” ");
INSERT INTO mgj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sa̠ A̠zizo̠s a̠d̠igh erile ma̠ obhun o̠gi̠ d̠a̠ A̠zeruse̠le̠m, sa̠ a̠bhin d̠iobh na̠ i̠wal ogbo atu̠ghan bho̠ a̠ten d̠a̠ a̠d̠ukun, sa̠ agba a̠nigha̠ awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“I̠bi̠ghe̠, i̠yar na̠ obhun o̠gi̠ d̠a̠ A̠zeruse̠le̠m, sa̠ ta̠ owol O̠nyi̠ ta̠ O̠ni̠ onigha̠ ma̠ ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ sa̠ ta̠ esobh ase̠ omugh ebhumeni i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ta̠ ob̠eton i̠na o̠lo̠gh d̠a̠ agu̠o̠ ibhebhia̠n bho̠ ma̠ agu̠o̠ ola̠ ta̠ e̠ki̠ri̠ i̠na, sa̠ ta̠ e̠gu̠ro̠gh i̠na, sa̠ ta̠ e̠du̠ i̠na d̠a̠ e̠mi̠gi̠re̠ni̠an oriren egigh, sa̠ i̠na ta̠ a̠b̠etina̠ d̠a̠ oleghemeni i̠sar a̠d̠a̠ma̠ bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","D̠a̠ obhel obha̠, sa̠ onweni anwi̠i̠ny ta̠ Aze̠bidi a̠ru na̠ i̠wal anwi̠i̠ny d̠o̠yo̠ ra̠ a̠kpud̠ia̠n i̠na ma̠ opuru abar. ");
INSERT INTO mgj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “Anwa iru ra̠ opuru ere?” Sa̠ i̠na awo̠ran a̠fugh ma̠a̠, “Ma̠ra̠ ma̠ agu̠o̠ ola̠, d̠a̠ irileghom d̠oyom, i̠wal anwi̠i̠ny d̠ami̠ ta̠ e̠ro̠ ma̠ a̠dila̠de, odi d̠a̠ od̠iom, ya̠a̠ uwed̠i d̠a̠ ekiel d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sa̠ A̠zizo̠s awo̠ran a̠fugh ma̠a̠, “Inyin uloghom d̠o̠ ma̠ abar wa̠ inyin na̠ a̠puru bho̠. Inyin ta̠ orue o̠d̠a ma̠ i̠d̠i̠ar ya̠ od̠i d̠a̠ okpa̠ko wa̠ ami̠ na̠ a̠ru ra̠ o̠d̠a bho̠ ke̠re̠?” Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “I̠yar ta̠ orue.” ");
INSERT INTO mgj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Ya̠ga̠i, inyin ta̠ o̠d̠a d̠a̠ okpa̠ko d̠ami̠, ya̠a̠ o̠ro̠ a̠dila̠de d̠a̠ od̠iom d̠ami̠ na̠ d̠a̠ ekiel d̠ami̠, bo̠ d̠a̠ i̠to̠ d̠ami̠, kpe̠le̠me̠ni̠ bha̠ aro̠ a̠nigha̠ ma̠ ogbo ya̠ O̠we̠de̠ d̠ami̠ na̠ a̠guri a̠sisa̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Igiel bho̠ d̠iobh iyed̠i i̠mu̠gho̠n bho̠, sa̠ awa i̠gam inigha̠ ma̠ i̠wal a̠rumor bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sa̠ A̠zizo̠s a̠kokod̠i awa agba ma̠a̠, “Inyin ologhom ma̠a̠ ogbo ya̠ na̠ erileghom ibhebhia̠n bho̠ na̠ eponoma̠ awa, sa̠ ibom a̠nwunom bho̠, bha̠ ya̠ awa i̠to̠ ya̠ iten. ");
INSERT INTO mgj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko o̠ro̠ d̠o̠ ma̠ o̠ku̠a d̠a̠ esa̠d̠io d̠inyin. Kpe̠le̠me̠ni̠, o̠ni̠ wa̠ na̠ abho̠ro̠ghan o̠bu̠gh d̠a̠ esa̠d̠io d̠inyin bho̠, aro̠ ma̠ ob̠a̠ra̠motu d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sa̠ o̠ni̠ wa̠ na̠ abho̠ro̠ghan o̠ro̠ d̠a̠ ed̠ia̠ d̠inyin bho̠, aro̠ ma̠ e̠bana d̠inyin: ");
INSERT INTO mgj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ma̠ agu̠o̠ bha̠ O̠nyi̠ ta̠ O̠ni̠ oru d̠o̠ ma̠ ola̠ ta̠ ogir e̠bana onigha̠ i̠na bho̠, ya̠a̠ i̠na a̠ru ma̠ o̠ro̠ ob̠a̠ra̠motu onigha̠ a̠nwunom na̠ onigha̠ a̠ghud̠um d̠o̠yo̠ obhin o̠ta a̠d̠izo ogbo.” ");
INSERT INTO mgj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Igiel bho̠ awa na̠ e̠d̠u̠a d̠a̠ Aze̠riko bho̠, sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","I̠wal a̠nwunom ikpom a̠rid̠ien i̠ro̠ ma̠ a̠dila̠de d̠a̠ aka eten bho̠. Igiel bho̠ awa i̠mu̠gho̠n ma̠ A̠zizo̠s na̠ a̠ten bho̠, sa̠ awa ikele ifugh ma̠a̠, “Wa̠nwuna̠, O̠nyi̠ ta̠ A̠devidi, kpone i̠yar igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ya̠a̠ o̠lo̠gh a̠nwunom bho̠ i̠ghaghana awa, ma̠ awa e̠ro̠ b̠o̠b̠o̠m. Ya̠a̠, awa i̠lo̠gh kuma̠ e̠mi̠ emulughu ma̠a̠, “Wa̠nwuna̠, O̠nyi̠ ta̠ A̠devidi, kpone i̠yar igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sa̠ A̠zizo̠s amara, sa̠ a̠bhelegi awa a̠fugh ma̠a̠, “Inyin na̠ o̠bho̠ro̠ghan ami̠ ma̠ ogir ere onigha̠ inyin?” ");
INSERT INTO mgj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “Wa̠nwuna̠, i̠yar na̠ abho̠ro̠ghan o̠bi̠gh abar.” ");
INSERT INTO mgj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sa̠ igbirigbir awa id̠ighi ma̠ A̠zizo̠s, sa̠ i̠na a̠kula̠n a̠rid̠ien d̠awa, sa̠ d̠a̠ onin obhel obha̠, sa̠ awa inwe i̠bi̠gh abar, sa̠ i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Igiel bho̠ awa na̠ etua̠n A̠zeruse̠le̠m bho̠, sa̠ i̠gbari̠ d̠a̠ igu Roliv d̠a̠ e̠ma Abe̠tfagi̠. Sa̠ A̠zizo̠s a̠ruom a̠duom i̠wal ogbo atu̠ghan d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “I̠gi̠e̠ d̠a̠ e̠ma wa̠ a̠sumogha̠n inyin bho̠, sa̠ inyin ta̠ o̠bi̠gh okubh ado̠ki̠ ola̠ u̠kpu̠o̠m na̠ o̠nyi̠ d̠o̠yo̠. I̠ko̠gi̠o̠ne̠ awa ma̠ ebhin eruom ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sa̠ ku̠gba ma̠ o̠ni̠ a̠pura̠n inyin abar, i̠wo̠rane̠ ma̠a̠, Wa̠nwuna̠ bho̠ na̠ abho̠ro̠ghan orughom, sa̠ i̠na ta̠ a̠ma̠ra̠ a̠nigha̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eb̠la̠ i̠nye̠n imite ma̠ agu̠o̠ ola̠ omuzughod̠iom iwowa̠ ya̠ owil bho̠ a̠wa̠ bho̠, ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“I̠gba ma̠ enigha̠ ma̠ O̠nyani̠ ta̠ Azayo̠n ma̠a̠, ‘Kpone, O̠li̠le̠ma d̠oyom na̠ a̠ru d̠oyom, ti̠to̠i̠ny d̠a̠ anyu̠ ado̠ki̠, olobhiri o̠nyi̠ ado̠ki̠, e̠nam a̠dol.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sa̠ ogbo atu̠ghan bho̠ i̠gi̠ ka̠ igir agu̠o̠ A̠zizo̠s a̠ruom awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sa̠ awa ibhin ado̠ki̠ bho̠ na̠ olobhiri o̠nyi̠ ado̠ki̠ bho̠ iru, sa̠ ibhin rakapa d̠awa i̠de̠ d̠a̠ anyu̠ rado̠ki̠ bho̠, ma̠ A̠zizo̠s od̠igh orile. ");
INSERT INTO mgj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sa̠ obom o̠lo̠gh a̠nwunom i̠de̠de̠gi̠ ma̠ ibom rakapa d̠awa d̠a̠ eten bho̠, sa̠ ipa̠n a̠nwunom isobhi ma̠ igologo a̠d̠e ibhin i̠de̠de̠gi̠ d̠a̠ eten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sa̠ ro̠lo̠gh ogele i̠ro̠ d̠a̠ ed̠ia̠ na̠ d̠a̠ aman d̠o̠yo̠ bho̠ imulughu ma̠a̠, “Itutumeni e̠ro̠ enigha̠ ma̱ O̠nyi̠ ta̠ A̠devidi!” “E̠no̠gho̠man na̠ e̠te̠i̠ o̠ni̠ wa̠ na̠ a̠bhin a̠d̠ien ta̠ Wa̠nwuna̠ na̠ a̠ru bho̠.” “Itutumeni e̠ro̠ enigha̠ ma̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ ote̠nai̠ny, wa̠ agi̠ ma̠ anyu̠ a̠pu bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sa̠ i̠na a̠d̠igh d̠a̠ A̠zeruse̠le̠m, sa̠ eb̠la̠ e̠ma bho̠ na̠ a̠nye̠ge̠re̠, sa̠ na̠ epura̠n ma̠a̠, “Onon ka̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sa̠ a̠nwunom bho̠ i̠wo̠ran ma̠a̠, “Onon owil A̠zizo̠s, wa̠ Anazare̠t d̠a̠ Agalili bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sa̠ A̠zizo̠s a̠d̠igh d̠a̠ otu ta̠ A̠zib̠a̠, sa̠ a̠zegi ma̠ eb̠la̠ ogbo ya̠ na̠ eb̠ua̠ ma̠ a̠b̠ua̠ d̠a̠ otu ta̠ A̠zib̠a̠ bho̠, sa̠ a̠kpululeni ma̠ rakpata ogbo ya̠ na̠ enwegi ma̠ ikpoki bho̠ na̠ i̠kasi̠ ta̠ ogbo ya̠ na̠ ewod̠i ma̠ ukpugh osege bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Na̠ o̠ge̠ oguri ma̠a̠, ‘Otu d̠ami̠ ta̠ aro̠ ma̠ otu a̠siseiny,’ya̠a̠ inyin na̠ otenemeni ma̠ ‘E̠fe̠m aru̠gba.’” ");
INSERT INTO mgj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sa̠ ogbo ya̠ ikpom a̠rid̠ien na̠ a̠rukula̠ bho̠ iru ra̠ i̠te̠i̠ i̠na d̠a̠ otu ta̠ A̠zib̠a̠, sa̠ i̠na a̠koko awa. ");
INSERT INTO mgj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ya̠a̠ igiel bho̠ ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ roloko bho̠ i̠bi̠gh i̠di̠ar ilologia̠n ya̠ na̠ emite bho̠, na̠ agu̠o̠ i̠gbara anwi̠i̠ny bho̠ na̠ emulughu d̠a̠ otu ta̠ A̠zib̠a̠ ma̠a̠, “Itutumeni e̠ro̠ enigha̠ ma̱ O̠nyi̠ ta̠ A̠devidi,” sa̠ rologi d̠awa igurom. ");
INSERT INTO mgj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sa̠ awa ifugh inigha̠ i̠na ma̠a̠, “Anwa na̠ amu̠gho̠n ya̠ i̠nye̠n na̠ efugh bho̠ ke̠re̠?” Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Yii, inyin ta̠ osen d̠o̠ o̠bi̠gh ma̠a̠, “ ‘D̠a̠ aru̠nu̠ i̠gbara anwi̠i̠ny ya̠ od̠id̠ia̠ na̠ e̠mam, bha̠ esi itutumeni d̠oyom na̠ e̠d̠u̠a na̠ eru’?” ");
INSERT INTO mgj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sa̠ i̠na awe̠le̠ awa ad̠u̠a d̠a̠ e̠ma bho̠ agi̠ d̠a̠ Abe̠tani̠ ka̠ a̠kod̠u ab̠al. ");
INSERT INTO mgj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ad̠i̠ro̠, sa̠ i̠na na̠ a̠mula̠ na̠ agi̠ d̠a̠ e̠ma bho̠ na̠ o̠ko̠i̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sa̠ i̠na abi̠gh oriren a̠fig ola̠ a̠tua̠n eten bho̠, sa̠ a̠rile ka̠ ate̠i̠ bha̠ na̠ o̠bi̠gh d̠o̠ ma̠ abar d̠a̠ eb̠o, a̠ten ra̠to ku̠ku̠m. Sa̠ i̠na a̠fugh ma̠a̠, “Otu omite mu d̠oyom tu̠tu̠n ka̠ id̠ud̠ul!” Sa̠ oriren a̠fig bho̠ aghi̠ghi̠ra epa̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Igiel bho̠ ogbo atu̠ghan bho̠ i̠bi̠gh bho̠, sa̠ ib̠a̠gha̠gha̠ ipura̠n ma̠a̠, “Eka̠ ma̠ ola̠ oriren a̠fig bho̠ aghi̠ghi̠ra epa̠ ma̠ ogbo na̠ onin bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sa̠ A̠zizo̠s awo̠ran agba a̠nigha̠ awa ma̠a̠, “Ya̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ka̠ inyin unwuna̠ ma̠ ologi ima̠ra̠ ola̠ o̠gba d̠o̠ i̠wal, inyin ko ogir d̠o̠ ma̠ abar wa̠ ugir ugboloma̠ ma̠ a̠fig bho̠ ku̠ku̠m, ya̠a̠ ka̠ inyin ufugh unigha̠ ma̱ igu onon eka̠, ma̠a̠, ‘B̠etina̠ ka̠ a̠mel d̠a̠ abadi̠,’ sa̠ ta̠ a̠mite ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sa̠ kerekere abar ola̠ inyin ubhin d̠a̠ a̠siseiny upuru, sa̠ inyin uma̠ra̠, bha̠ inyin ta̠ o̠te̠i̠.” ");
INSERT INTO mgj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sa̠ i̠na a̠d̠igh d̠a̠ otu ta̠ A̠zib̠a̠ atu̠ghu̠me̠ni̠, sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ ikei a̠nwunom bho̠ ipura̠n i̠na ma̠a̠, “A̠kere a̠limon wa̠ anwa na̠ a̠bhin na̠ a̠gir i̠nye̠n bho̠, sa̠ a̠nyen a̠nigha̠ nyam a̠limon onon bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sa̠ A̠zizo̠s awo̠ran a̠fugh a̠nigha̠ awa ma̠a̠, “Ami̠ ta̠ opura̠n inyin ipura̠n nyen. Ku̠gba ma̠ inyin o̠wo̠ran ami̠, sa̠ ami̠ ta̠ agba a̠nigha̠ inyin nyen a̠d̠ien a̠limon wa̠ ami̠ na̠ a̠bhin a̠gir i̠di̠ar i̠nye̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Owura̠ amu̠m ta̠ Azo̠n ka̠ ad̠u̠a d̠a̠ a̠ken a̠ru? D̠a̠ ote̠nai̠ny bo̠d̠o̠ d̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠?” Sa̠ awa ibhin id̠igh d̠a̠ i̠b̠e̠re̠gi̠an ifugh ma̠a̠, “Ku̠gba ma̠ i̠yar u̠wo̠ran ma̠a̠, ‘D̠a̠ ote̠nai̠ny,’ sa̠ i̠na ta̠ a̠pura̠n ma̠a̠, ‘O̠ku̠a ka̠, ezin ka̠ ere wa̠ i̠yar oma̠ra̠ d̠o̠ i̠na bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ya̠a̠ ka̠ i̠yar u̠wo̠ran ma̠a̠, ‘D̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠,’ ya̠a̠ i̠yar na̠ oghil a̠nwunom bho̠, ezin bho̠ awa ibhin ma̠ Azo̠n owil.” ");
INSERT INTO mgj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sa̠ awa i̠wo̠ran A̠zizo̠s ma̠a̠, “I̠yar uloghom d̠o̠.” Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Ami̠ ko o̠gba d̠o̠ nyen a̠nigha̠ inyin a̠d̠ien a̠limon wa̠ Ami̠ na̠ a̠bhin a̠gir i̠di̠ar i̠nye̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Inyin u̠bi̠gh ani̠ eka̠ ogboloma̠ ma̠ i̠wal anwi̠i̠ny ta̠ odi o̠ni̠. Odi o̠ni̠ aro̠ ma̠ ola̠ a̠nwuna̠ i̠wal anwi̠i̠ny, sa̠ a̠ruom o̠pu̠r o̠nyi̠ bho̠ ma̠a̠, ‘Gi̠e̠ d̠a̠ a̠lei bho̠ ka̠ a̠gir a̠didon.’ ");
INSERT INTO mgj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Sa̠ i̠na awo̠ran ma̠a̠, ‘Ami̠ ka̠ orue d̠o̠,’ ya̠a̠ a̠tepa̠, sa̠ a̠nwe ma̠ ologi agi̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Sa̠ o̠we̠de̠ bho̠ ate̠i̠ uwed̠i agba ma̠ onin agu̠o̠. Sa̠ i̠na awo̠ran ma̠a̠, ‘Wa̠nwuna̠, ami̠ a̠ma̠ra̠,’ ya̠a̠ na̠ o̠gi̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Oken d̠a̠ i̠wal awa a̠gir i̠to̠ ta̠ o̠we̠de̠ bho̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “O̠pu̠r bho̠.” Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, rogunma̠otua̠ bho̠ na̠ id̠eme̠ma bho̠ od̠i d̠a̠ ed̠ia̠ d̠inyin ka̠ od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ezin bho̠ Azo̠n a̠ru ra̠ oleriom inyin agu̠o̠ orugh a̠ma̠rugh igielake̠, ya̠a̠ inyin uma̠ra̠ d̠o̠ i̠na. Ya̠a̠ rogunma̠otua̠ bho̠ na̠ id̠eme̠ma bho̠ ema̠ra̠ i̠na. Sa̠ eb̠la̠ agu̠o̠ bho̠ inyin u̠bi̠gh ya̠ id̠ighi ma̠ i̠karabh bho̠ itiba̠ra̠ bho̠ eka̠, inyin uloghoma̠n d̠o̠ oma̠ra̠ i̠na otiba̠ra̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“I̠nagha ma̠ opa̠n a̠sidogh: O̠ni̠ ola̠ a̠nwuna̠ ma̠ otu aro̠, sa̠ a̠gbebhegh a̠grep d̠a̠ a̠lei bho̠, sa̠ a̠ko a̠kiton a̠lei bho̠. Sa̠ a̠gbo ma̠ esi ola̠ o̠fi̠d̠igi̠ itu bho̠, sa̠ a̠lo ma̠ otu ipoiny. Sa̠ a̠nigha̠ ma̠ esi bho̠ ma̠ i̠ko̠ ma̠ a̠lei ma̠ o̠ko̠ orughom, sa̠ a̠b̠etina̠ ma̠ e̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ate̠i̠ obhel o̠ku̠ imuma̠ bho̠, sa̠ i̠na a̠ruom rob̠a̠ra̠motu d̠o̠yo̠ ma̠ o̠gi̠ d̠a̠ ikponom ma̠ a̠lei bho̠ ka̠ obhin a̠bin imuma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Sa̠ ikponom ma̠ a̠lei bho̠ ikighom rob̠a̠ra̠motu d̠o̠yo̠, sa̠ i̠mar id̠ul odi, sa̠ igigh opa̠n, sa̠ irobhod̠i ma̠ uwed̠i. ");
INSERT INTO mgj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sa̠ i̠na a̠mula̠ a̠ruom ipa̠n rob̠a̠ra̠motu ya̠ ib̠uiy ipu ma̠ i̠pu̠r bho̠. Sa̠ igir onin agu̠o̠ igboloma̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","D̠a̠ okunugiom, sa̠ a̠ruom o̠nyi̠ d̠o̠yo̠ ka̠ o̠te̠i̠ awa. Sa̠ i̠na a̠fugh ma̠a̠, ‘Ta̠ eghila̠n o̠nyi̠ d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ya̠a̠, igiel bho̠ a̠gbo ya̠ i̠ko̠ ma̠ a̠lei bho̠ i̠bi̠gh i̠na bho̠, sa̠ imimia̠n ma̠a̠, ‘Onon uwa̠ ta̠ a̠d̠e ma̠ ad̠i̠a bho̠, id̠ighi ta̠ ogigh i̠na, b̠o̠ka̠ i̠d̠i̠ar do̠yo̠ eten iyiyar.’ ");
INSERT INTO mgj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sa̠ ikighom i̠na, inuoghom i̠na imutiom d̠a̠ a̠lei bho̠, sa̠ igigh i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Igiel wa̠nwuna̠ ma̠ a̠lei bho̠ ta̠ a̠ru, ta̠ a̠gir eka̠ a̠gboloma̠ ma̠ ikponom ma̠ a̠lei bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Sa̠ awa i̠wo̠ran ma̠a̠, “I̠na ta̠ amar a̠kunugi ma̠ id̠ighi ma̠ i̠karabh bho̠, sa̠ ta̠ a̠nigha̠ ma̠ a̠lei bho̠ ma̠ ipa̠n i̠ko̠ ma̠ a̠lei ya̠ ta̠ enigha̠ gha̠n i̠na ma̠ a̠bin imuma̠ d̠o̠yo̠ d̠a̠ obhel wa̠ akpe̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin ta̠ osen d̠o̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ o̠bi̠gh ma̠a̠: “ ‘Ikputu wa̠ ilo ma̠ a̠rutu ighel bho̠, na̠ a̠ten e̠ko̠ otu bho̠, Onon ad̠u̠a d̠a̠ Wa̠nwuna̠ bho̠ a̠mite, sa̠ a̠d̠igh ilologia̠n d̠a̠ a̠misigh d̠i̠yar, sa̠ a̠bhon o̠bi̠gh’? ");
INSERT INTO mgj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ebula̠ o̠ku̠a, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ta̠ o̠wo̠r inyin irileghom ta̠ A̠zib̠a̠ obhin onigha̠ ma̠ a̠nwunom ya̠ ta̠ emum ib̠eb̠i itu. ");
INSERT INTO mgj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sa̠ o̠ni̠ ola̠ a̠melema̠ ma̠ ikputu onon ta̠ a̠tutughud̠ia̠n, sa̠ o̠ni̠ ola̠ i̠na a̠mel a̠bhum sa̠ i̠na ta̠ agbe̠ ma̠ o̠ni̠ bho̠ a̠tutughud̠i.” ");
INSERT INTO mgj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Igiel bho̠ ogbo aru̠mu̠ rokur bho̠ na̠ Rafarisi bho̠ i̠mu̠gho̠n a̠sidogh d̠o̠yo̠ bho̠, sa̠ iloghoma̠n ma̠ a̠rogh a̠sidogh bho̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sa̠ awa i̠ru̠ru̠an ob̠ol o̠yo̠, ya̠a̠ ighil a̠nwunom bho̠, ezin bho̠ a̠nwunom bho̠ ibhin ma̠ i̠na owil. ");
INSERT INTO mgj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sa̠ A̠zizo̠s alo̠gho̠m opa̠n a̠sidogh a̠rogh a̠nigha̠ awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Irileghom ote̠nai̠ny agu̠b̠an o̠li̠le̠ma ola̠ a̠kokod̠ia̠n o̠d̠e̠ erogh a̠nigha̠ ma̠ o̠nyi̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sa̠ i̠na a̠ruom rob̠a̠ra̠motu d̠o̠yo̠ ma̠ o̠gi̠ ka̠ obhelegi eb̠la̠ ogbo ya̠ u̠tu̠n o̠d̠e̠ erogh ulebh bho̠, ya̠a̠ awa i̠bho̠ro̠ghan d̠o̠ ma̠ oru. ");
INSERT INTO mgj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sa̠ i̠na a̠puta̠ a̠ruom ipa̠n rob̠a̠ra̠motu, agba ma̠a̠, ‘I̠gba ma̠ enigha̠ ma̠ ogbo ya̠ ulebh bho̠ ma̠a̠: I̠bi̠ghe̠, ami̠ na̠ a̠kokod̠ia̠n ed̠ia̠n bho̠ amado̠n. Na̠ ogigh rodughuna̠ na̠ rovi i̠nu̠m d̠ami̠, sa̠ eb̠la̠ i̠di̠ar bho̠ na̠ elegha̠n. Itue d̠a̠ o̠d̠e̠ erogh bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ya̠a̠, awa ibhin d̠o̠ e̠tu̠o̠m abar, sa̠ iten i̠d̠u̠a; odi agi̠ d̠a̠ o̠si̠ d̠o̠yo̠, sa̠ uwed̠i agi̠ d̠a̠ esi a̠b̠ua̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sa̠ ipa̠n isibh rob̠a̠ra̠motu d̠o̠yo̠, irughom i̠te̠i̠ sa̠ i̠ze̠gi̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sa̠ ologi o̠li̠le̠ma bho̠ a̠gurom, sa̠ a̠ruom ogbo e̠gham d̠o̠yo̠ ma̠ o̠gi̠ ka̠ okunugi i̠ze̠gi̠ ma̠ a̠nwunom bho̠, na̠ o̠bhu̠gi̠ e̠ma d̠awa osoroni. ");
INSERT INTO mgj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Sa̠ i̠na agba a̠nigha̠ ma̠ rob̠a̠ra̠motu d̠o̠yo̠ ma̠a̠, ‘O̠d̠e̠ erogh bho̠ na̠ a̠lei, ya̠a̠ ogbo ya̠ ulebh bho̠ i̠bi̠gh ma̠ i̠kpe̠ d̠o̠ awa ma̠ oru. ");
INSERT INTO mgj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ebula̠ o̠ku̠a, i̠gi̠e̠ d̠a̠ reten bho̠, ma̠ elebh ko̠ni̠ko̠ni̠ ola̠ inyin u̠manana ma̠ oru d̠a̠ o̠d̠e̠ erogh bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sa̠ rob̠a̠ra̠motu bho̠ imite i̠gi̠ d̠a̠ reten bho̠ ka̠ ikokod̠i ma̠ ogbo ya̠ awa i̠manana bho̠, a̠d̠igh i̠karabh na̠ ib̠eb̠i a̠nwunom bho̠, sa̠ imuzo d̠a̠ obom ogbo otu erogh bho̠ i̠ro̠ d̠a̠ rakpata od̠e. ");
INSERT INTO mgj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sa̠ o̠li̠le̠ma bho̠ a̠d̠igh okpon ogbo ya̠ od̠i d̠a̠ rakpata od̠e bho̠, sa̠ abi̠gh o̠ni̠ ola̠ o̠lagha d̠o̠ ma̠ ibura̠ erogh e̠yal bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sa̠ a̠pura̠n i̠na ma̠a̠, ‘A̠tologha̠n, anwa id̠ighi eka̠ a̠d̠igh esi onon, ma̠ ola̠ anwa onwuna̠ d̠o̠ ma̠ ibura̠ e̠yal erogh bho̠?’ Ya̠a̠ i̠na na̠ owuna̠ d̠o̠ ma̠ abar ola̠ o̠wo̠ran. ");
INSERT INTO mgj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ebula̠ o̠ku̠a sa̠ o̠li̠le̠ma bho̠ a̠ruom rob̠a̠ra̠motu bho̠ ma̠a̠, ‘I̠bhad̠i̠ ma̠ a̠sike na̠ aru̠gu̠o̠ d̠o̠yo̠ ma̠ enuwoghom i̠na ka̠ ed̠ighom d̠a̠ obom azi̠m. I̠se̠ esi ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠ od̠i.’ ");
INSERT INTO mgj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ezin bho̠ ubhelegi ma̠ iya̠ ib̠uiy, ya̠a̠ ta̠ o̠so̠n o̠nyi̠ki̠kara a̠nwunom obhin.” ");
INSERT INTO mgj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","D̠a̠ igiel obha̠, sa̠ Rafarisi bho̠ i̠d̠u̠a ka̠ i̠mu̠gho̠nyan agu̠o̠ obhin d̠a̠ asu̠gbagba d̠o̠yo̠ o̠kpati̠ ob̠ol o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sa̠ awa iruom ogbo atu̠ghan d̠awa na̠ ita̠ E̠ro̠d ma̠ o̠gi̠ d̠o̠yo̠ ka̠ opura̠n ma̠a̠: “O̠ni̠ atu̠ghu̠me̠ni̠, i̠yar ologhom ma̠ anwa na̠ amar a̠rugh d̠a̠ a̠gia̠ga̠i, sa̠ anwa na̠ atu̠ghu̠me̠ni̠ ma̠ eten ta̠ A̠zib̠a̠ ga̠i, anwa na̠ okpon d̠o̠ bebina̠ o̠ni̠ d̠a̠ a̠misigh, sa̠ anwa obhin d̠o̠ ma̠ imitia̠n o̠ni̠ atu̠o̠m abar. ");
INSERT INTO mgj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ebula̠ o̠ku̠a, gba ma̠ a̠nigha̠ i̠yar, anwa i̠bi̠gh eka̠? A̠sora̠n otua̠ otua̠-ebhugh onigha̠ A̠siza̠ ke̠re̠, bo̠d̠o̠ ka̠ na̠ osora̠n d̠o̠?” ");
INSERT INTO mgj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ya̠a̠, A̠zizo̠s abi̠gho̠m ipesi d̠awa sa̠ a̠fugh ma̠a̠, “Sa̠ ibhelebhel, ere wa̠ inyin na̠ o̠d̠agi̠an ami̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ileriome ami̠ ma̠ okpoki otua̠ bho̠.” Sa̠ awa imutiom a̠dinari̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Onon ka̠ a̠misigh ta̠ a̠nyen, sa̠ u̠ge̠ ma̠ a̠d̠ien ta̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “A̠siza̠.” Ebula̠ o̠ku̠a, sa̠ a̠ruom awa ma̠a̠, “O̠ku̠a a̠d̠ighi be̠le̠ni̠, inigha̠ ma̠ A̠siza̠ ma̠ ita̠ A̠siza̠, ma̠ enigha̠ ma̠ A̠zib̠a̠ ma̠ ita̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Agu̠o̠ awa i̠mu̠gho̠n o̠ku̠a bho̠, sa̠ awa ib̠a̠gha̠gha̠ i̠we̠le̠man i̠na iten i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","D̠a̠ onin a̠d̠a̠ma̠ obha̠, sa̠ Rasadusi bho̠, ogbo ya̠ oma̠ra̠ d̠o̠ ma̠ ob̠etina̠ d̠a̠ omugh odi bho̠, i̠gi̠ ka̠ i̠te̠i̠ i̠na ipura̠n i̠na ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“O̠ni̠ atu̠ghu̠me̠ni̠, A̠mozizi agba ma̠a̠, ku̠gba ma̠ o̠ni̠ a̠mugh ya̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠, umor bho̠ ta̠ a̠bhin ani̠ d̠o̠yo̠ b̠o̠ka̠ amar o̠nyi̠ a̠nigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","I̠se̠n bha̠ od̠ua̠l a̠rumor e̠ro̠ na̠ i̠yar, sa̠ o̠pu̠r bho̠ a̠bhin ani̠ ya̠a̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠, sa̠ a̠mugh awe̠le̠man ani̠ d̠o̠yo̠ a̠nigha̠ ma̠ umor d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sa̠ a̠mutuma̠ ma̠ o̠ku̠a ma̠ oleghemeni i̠wal bho̠ na̠ oleghemeni i̠sar bho̠ ka̠ ate̠i̠ d̠a̠ oleghemeni od̠ua̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","D̠a̠ ekunuguma̠ bho̠, sa̠ ani̠ bho̠ eka̠ a̠mugh. ");
INSERT INTO mgj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","O̠ku̠a ka̠, d̠a̠ ob̠etina̠ d̠a̠ omugh bho̠ ka̠ i̠na ta̠ aro̠ ma̠ ani̠ ta̠ a̠nyen, ma̠ agu̠o̠ eb̠la̠ od̠ua̠l awa na̠ ebhin i̠na bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Inyin na̠ o̠ru̠an o̠pi̠e̠, ezin bho̠ inyin u̠mo̠gho̠yan d̠o̠ ma̠ a̠d̠ire e̠tu̠tu̠ bho̠, a̠d̠igh a̠limon ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","D̠a̠ ob̠etina̠ d̠a̠ omugh bho̠ o̠walan ilom bo̠, unigha̠nom d̠o̠ nyen anwi̠i̠nyan, kpe̠le̠me̠ni̠ a̠nwunom ta̠ e̠ro̠ ma̠ agu̠o̠ itileduom ta̠ A̠zib̠a̠ ya̠ od̠i d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ya̠a̠, ya̠ igboloma̠ ma̠ ob̠etina̠ d̠a̠ omugh imumugh bho̠, inyin ta̠ osen d̠o̠ ma̠ iya̠ A̠zib̠a̠ agba a̠nigha̠ inyin bho̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ami̠ A̠zib̠a̠ ta̠ Ebraham na̠ A̠zib̠a̠ ta̠ Azi̠ki̠ na̠ A̠zib̠a̠ ta̠ A̠zeko̠pu̠ ke̠re̠’? I̠na A̠zib̠a̠ imumugh d̠o̠, ya̠a̠ A̠zib̠a̠ ta̠ ogbo ya̠ od̠i d̠a̠ a̠ghud̠um bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Igiel bho̠ o̠lo̠gh a̠nwunom bho̠ i̠mu̠gho̠n i̠nye̠n bho̠, sa̠ ib̠a̠gha̠gha̠ ma̠ d̠a̠ a̠d̠ien atu̠ghu̠me̠ni̠ d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Igiel bha̠ Rafarisi bho̠ i̠mu̠gho̠n ma̠ A̠zizo̠s na̠ a̠kpegi ma̠ aru̠nu̠ Rasadusi bho̠, sa̠ awa ikokod̠ia̠n ani̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sa̠ odi o̠ni̠ atu̠ghu̠me̠ni̠ oloko bho̠, a̠pura̠n o̠d̠agi̠an o̠yo̠, ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O̠ni̠ atu̠ghu̠me̠ni̠, oloko oken wa̠ abu̠gh a̠pu d̠a̠ oloko bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠: “ ‘Tula̠ne ma̠ Wa̠nwuna̠ A̠zib̠a̠ d̠oyom na̠ eb̠la̠ ekpo ologi d̠oyom, na̠ eb̠la̠ eloghoma̠n ozu d̠oyom, na̠ ebla̠ ologi d̠oyom.’ ");
INSERT INTO mgj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Onon o̠pu̠r oloko bho̠ sa̠ aro̠ ma̠ wa̠ abu̠gh a̠pu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Oleghemeni i̠wal bho̠ od̠i ma̠ agu̠o̠ o̠pu̠r bho̠: ‘Tula̠ne ma̠ o̠ni̠etua̠n d̠oyom ma̠ agu̠o̠ ozu d̠oyom.’ ");
INSERT INTO mgj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Eb̠la̠ roloko bho̠ na̠ a̠riwil bho̠, u̠ke̠ri̠ d̠a̠ i̠wal roloko i̠nye̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Igiel bho̠ Rafarisi bho̠ ikokod̠ia̠n bho̠, sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Inyin na̠ o̠ru̠ru̠an eka̠ na̠ ogboloma̠ ma̠ Akrai̠st? I̠na ka̠ o̠nyi̠ ta̠ a̠nyen?” Sa̠ awa i̠wo̠ran ma̠a̠, “O̠nyi̠ ta̠ A̠devidi.” ");
INSERT INTO mgj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sa̠ i̠na a̠pura̠n awa ma̠a̠: “O̠ku̠a ka̠ ere wa̠ igiel E̠mu̠gh bho̠ a̠d̠igh A̠devidi bho̠ sa̠ a̠bhelegi I̠na ma̠a̠, ‘Wa̠nwuna̠ bho̠’? Sa̠ a̠fugh ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Wa̠nwuna̠ bho̠ a̠fugh a̠nigha̠ ma̠ Wa̠nwuna̠ d̠ami̠: “Ro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ d̠ami̠ tu̠tu̠n ami̠ ta̠ a̠soroni ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom a̠tenemeni ma̠ okpokpolom o̠gbam a̠sike d̠oyom.” ’  ");
INSERT INTO mgj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ku̠gba ma̠ A̠devidi a̠bhelegi i̠na ma̠a̠, ‘Wa̠nwuna̠,’ ka̠ i̠na ta̠ a̠d̠ighi eka̠ aro̠ ma̠ o̠nyi̠ d̠o̠yo̠?” ");
INSERT INTO mgj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sa̠ o̠ni̠ ola̠ a̠rue ma̠ o̠wo̠ran o̠yo̠, bo̠d̠o̠ omula̠ opura̠n o̠yo̠ ma̠ abar na̠ o̠ro̠ d̠o̠, ob̠eton a̠d̠a̠ma̠ obha̠ o̠gi̠ d̠a̠ ed̠ia̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Igiel obha̠, sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠ na̠ ogbo ogir d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ma̠a̠: “I̠tu̠ghe̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠ na̠ e̠ro̠ ma̠ a̠dila̠de d̠a̠ i̠kasi̠ ta̠ A̠mozizi. ");
INSERT INTO mgj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ebula̠ o̠ku̠a, kerekere abar ola̠ awa iruom inyin, igire. Ya̠a̠, o̠ni̠ ko orugh agu̠o̠ awa, ezin bho̠, awa na̠ e̠gba ma̠ ipa̠n na̠ egir ipa̠n. ");
INSERT INTO mgj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Awa na̠ e̠gho̠ro̠gi̠ ma̠ ra̠dol ya̠ i̠mu̠mo̠r ipu ma̠ a̠nwunom orol na̠ e̠gbam d̠a̠ ro̠kpalma a̠nwunom, ya̠a̠ awa ima̠ra̠ d̠o̠ bebina̠ ad̠u̠nu̠ agu̠o̠ d̠awa ma̠ od̠igh orol. ");
INSERT INTO mgj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Eb̠la̠ ogir ya̠ awa na̠ egir bho̠, bha̠ na̠ egir agu̠o̠ ola̠ a̠nwunom ta̠ elelegi awa. Awa na̠ e̠bu̠ghu̠me̠ni̠ ma̠ robhurugho o̠nu̠o̠kpe̠ a̠siseiny d̠awa, sa̠ na̠ eweghemeni ma̠ i̠sabh akapa d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Awa iba̠ra̠ ma̠ ri̠kasi̠ edim d̠a̠ rakpata o̠d̠e̠ na̠ ra̠dila̠de edim d̠a̠ a̠rutu u̠gala A̠zu, ");
INSERT INTO mgj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","sa̠ iba̠ra̠ ma̠ ipeleguma̠ itum d̠a̠ a̠risisi a̠b̠ua̠, na̠ a̠nwunom obhelegi awa ma̠a̠, ‘O̠ni̠ atu̠ghu̠me̠ni̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ya̠a̠, obhelegi d̠o̠ inyin ma̠a̠, ‘O̠ni̠ atu̠ghu̠me̠ni̠.’ Onin o̠ni̠ ku̠ku̠m O̠ni̠ atu̠ghu̠me̠ni̠ d̠inyin, ya̠a̠ eb̠la̠ inyin a̠rumor. ");
INSERT INTO mgj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ko obhelegi ma̠ o̠ni̠ ma̠a̠, ‘O̠we̠de̠’ i̠se̠n a̠de onon. Ezin bho̠ inyin unwuna̠ ma̠ onin O̠we̠de̠ ku̠ku̠m, ola̠ od̠i d̠a̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Obhelegi d̠o̠ inyin ma̠a̠ o̠ni̠ atu̠ghu̠me̠ni̠, ezin bho̠ Akrai̠st ku̠ku̠m bha̠ O̠ni̠ atu̠ghu̠me̠ni̠ d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","O̠ni̠ wa̠ abu̠gh a̠pu d̠a̠ esa̠d̠io d̠inyin bho̠, aro̠ ma̠ ob̠a̠ra̠motu d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya̠a̠, o̠ni̠ wa̠ abu̠ghu̠me̠ni̠ ma̠ ozu d̠o̠yo̠ bho̠ ta̠ o̠ki̠ri̠me̠ni̠, sa̠ o̠ni̠ wa̠ aki̠ri̠me̠ni̠ ma̠ ozu d̠o̠yo̠ bho̠ ta̠ o̠bu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Olo a̠leghe inyin i̠tu̠ghe̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠, Ribhelebhel! Ezi̠n bho̠, inyin na̠ ogugi ma̠ o̠nu̠ otu irileghom ote̠nai̠ny na̠ okigima̠ ma̠ ogbo ya̠ od̠i d̠a̠ ed̠ia̠ d̠inyin bho̠. Inyin ud̠igh d̠o̠ sa̠ inyin na̠ okigima̠ ma̠ ogbo ya̠ na̠ e̠gi̠ ka̠ od̠i̠gh bho̠ ma̠ od̠igh. ");
INSERT INTO mgj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Olo a̠leghe inyin i̠tu̠ghu̠me̠ni̠ ma̠ roloko bho̠ na̠ Rafarisi bho̠, Ribhelebhel! Inyin na̠ oponoma̠ ma̠ rekpukele anwani̠ na̠ o̠wo̠ro̠gh i̠di̠ar, sa̠ inyin na̠ osiseiny iwewegh a̠siseiny b̠o̠ka̠ olelegi inyin. Ta̠ o̠gu̠r inyin agu̠o̠ i̠zagba ola̠ abu̠gh ibom.” ");
INSERT INTO mgj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Itogi e̠ro̠ enigha̠ inyin i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠. Ribhelebhel! Inyin na̠ o̠d̠u̠a ma̠ esi na̠ oten esi ma̠ agu̠o̠ ola̠ o̠te̠i̠ bebina̠ o̠ni̠, sa̠ ka̠ inyin na̠ o̠te̠i̠, sa̠ inyin na̠ omula̠ na̠ od̠ighi ma̠ ola̠ o̠ni̠ bho̠ ta̠ a̠ten o̠nyi̠ e̠banya ola̠ a̠d̠ighi ma̠ i̠karabh a̠pu inyin i̠wal igiel. ");
INSERT INTO mgj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Itogi e̠ro̠ enigha̠ inyin, ogbo ikpom a̠rid̠ien ya̠ na̠ erileghom ipa̠n ogbo! Inyin na̠ o̠gba ma̠a̠, ‘Ku̠gba ma̠ o̠ni̠ a̠bhin otu ta̠ A̠zib̠a̠ aghad̠i̠an, bha̠ o̠kpe̠ bo̠. Ya̠a̠, ku̠gba ma̠ o̠ni̠ a̠bhin a̠gol wa̠ od̠i d̠a̠ otu ta̠ A̠zib̠a̠ bho̠ aghad̠i̠an, bha̠ i̠na na̠ ako̠man.’ ");
INSERT INTO mgj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Rema̠! Ogbo ikpom a̠rid̠ien! Oken abu̠gh a̠pu d̠a̠ i̠wal a̠yi: a̠gol bho̠, bo̠d̠o̠ otu ta̠ A̠zib̠a̠ wa̠ a̠worogi ma̠ a̠gol bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inyin na̠ o̠gba nyen ma̠a̠, ku̠gba ma̠ o̠ni̠ a̠bhin enwen alu̠kpe̠ bho̠ aghad̠i̠an, ma̠ o̠kpe̠ bo̠. Ya̠a̠, ku̠gba ma̠ o̠ni̠ a̠bhin e̠ne̠ghe̠ wa̠ u̠gbam d̠a̠ anyu̠ bho̠ aghad̠i̠an bha̠ na̠ ako̠man. ");
INSERT INTO mgj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ogbo ikpom a̠rid̠ien, oken abu̠gh a̠pu d̠a̠ i̠wal a̠yi: enigha̠ bho̠, bo̠d̠o̠ ka̠ enwen bho̠ wa̠ na̠ a̠worogi ma̠ enigha̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠na o̠ni̠ wa̠ a̠bhin enwen bho̠ aghad̠i̠an bho̠, ab̠aram na̠ eb̠la̠ i̠di̠ar ya̠ u̠gbam d̠a̠ anyu̠ bho̠ aghad̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sa̠ i̠na o̠ni̠ wa̠ a̠bhin otu ta̠ A̠zib̠a̠ aghad̠i̠an bho̠, a̠bhin otu bho̠ na̠ A̠zib̠a̠ wa̠ na̠ a̠rugh d̠a̠ ologi bho̠ aghad̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sa̠ o̠ni̠ ola̠ a̠bhin ote̠nai̠ny aghad̠i̠an, bha̠ a̠bhin a̠dila̠de irileghom ta̠ A̠zib̠a̠, na̠ i̠na wa̠ od̠i ma̠ a̠dila̠de d̠a̠ i̠kasi̠ irileghom bho̠ aghad̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Itogi e̠ro̠ enigha̠ inyin i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠, Ribhelebhel! Ezin bho̠, inyin na̠ obhin aghan-od̠od̠ua̠ na̠ u̠ki̠a na̠ a̠d̠ien kerekere i̠gho̠gho̠ a̠mubobh, na̠ onigha̠ ma̠ A̠zib̠a̠ ma̠ a̠bin d̠a̠ a̠d̠iobh atu̠gi̠, ya̠a̠ inyin ubhin d̠o̠ ma̠ i̠di̠ar ya̠ ilei abar ipu d̠a̠ oloko bho̠ o̠tu̠o̠m abar. A̠ma̠rugh igielake̠, na̠ okpon igbirigbir, na̠ onwuna̠ ologi ima̠ra̠. Akpe̠ inyin ogir i̠di̠ar i̠nye̠n, ya̠a̠ o̠ni̠ ko o̠we̠le̠ ma̠ ogir i̠di̠ar iyed̠i nyen. ");
INSERT INTO mgj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ogbo ikpom a̠rid̠ien! Inyin na̠ omurugha̠ ma̠ e̠gi̠, sa̠ inyin na̠ o̠mi̠n e̠nam-a̠dol. ");
INSERT INTO mgj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Itogi e̠ro̠ enigha̠ inyin i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠. Ribhelebhel! Ezin bho̠ inyin na̠ otitol aman okpa̠ko bho̠, ya̠a̠ d̠a̠ ologi bho̠ bha̠ a̠ponoma̠, na̠ o̠ku̠ku̠, na̠ i̠karabh od̠ighi i̠di̠ar imuzo. ");
INSERT INTO mgj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rafarisi ikpom a̠rid̠ien! Id̠ia̠ ma̠ etitol eb̠la̠ ologi okpa̠ko bho̠ ma̠ agu̠o̠ ola̠ aman bho̠ eka̠ ta̠ ab̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Itogi e̠ro̠ enigha̠ inyin i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠. Ribhelebhel! Ezin bho̠ inyin u̠gu̠b̠an ranyu̠ od̠i ya̠ u̠mar u̠lo̠ sa̠ na̠ ekil d̠a̠ etire, sa̠ i̠gu̠b̠an ya̠ ibhon ibom d̠a̠ ologi. Ne̠ge̠ bha̠ i̠kpo̠kpo̠ imumugh a̠nwunom na̠ a̠d̠ien kerekere i̠gho̠ro̠gho̠r emuzo d̠a̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Obha̠ agu̠o̠ inyin eka̠ u̠gu̠b̠an ogbo ya̠ i̠b̠ab̠ala d̠a̠ anyu̠, sa̠ na̠ erugh a̠ma̠rugh igielake̠, ya̠a̠, ado̠l ibhelebhel na̠ a̠ma̠rugh i̠te̠i̠ imuzo d̠a̠ aghud̠um d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Itogi e̠ro̠ enigha̠ inyin i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ Rafarisi bho̠. Ribhelebhel! Ezin bho̠, inyin na̠ ob̠olob̠ol ranyu̠od̠i a̠riwil bho̠, sa̠ inyin na̠ oburi ma̠ ranyu̠od̠i ib̠eb̠i a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sa̠ inyin na̠ o̠gba ma̠a̠, ‘I̠yar umite d̠a̠ amu̠m igba̠iny ro̠we̠de̠ d̠i̠yar nab̠o̠, i̠yar ka̠ ud̠igh ani̠ d̠o̠ o̠ze̠gi̠ ma̠ a̠riwil bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","O̠ku̠a a̠d̠ighi be̠le̠ni̠, inyin agu̠o̠ ud̠igh onyob̠a̠ ebhum ase̠ d̠inyin, ma̠a̠, inyin anwi̠i̠ny ta̠ ogbo ya̠ i̠ze̠gi̠ ma̠ a̠riwil bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inyin eka̠ i̠gi̠o̠me̠ d̠a̠ ed̠ia̠, ma̠ emuzoghod̠iom ogir ya̠ igba̠iny ro̠we̠de̠ d̠inyin i̠ke̠ bho̠! ");
INSERT INTO mgj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“I̠karabh i̠di̠ar! Anwi̠i̠ny i̠bho̠ru̠bho̠ru̠ i̠karabh i̠di̠ar! Inyin ta̠ od̠ighi eka̠ omiza̠n osobh ase̠ e̠ba anya bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ami̠ na̠ a̠ruom a̠riwil, na̠ iloghom ma̠ i̠di̠ar, na̠ ogbo i̠tu̠ghu̠me̠ni̠ na̠ a̠ruom inyin. Inyin ta̠ o̠ze̠gi̠ ma̠ idi awa, sa̠ inyin ta̠ o̠du̠gi̠ ma̠ idi o̠ze̠gi̠ d̠a̠ e̠mi̠gi̠re̠ni̠an oriren, sa̠ inyin ta̠ o̠gu̠ro̠gh idi d̠a̠ ru̠gala d̠inyin, sa̠ inyin ta̠ o̠d̠u̠a ma̠ e̠ma oten e̠ma ozegi awa. ");
INSERT INTO mgj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","D̠a̠ ebul o̠ku̠a, eb̠la̠ asi̠ ta̠ ib̠eb̠i a̠nwunom ya̠ uzu d̠a̠ a̠de bho̠ ta̠ e̠ro̠ d̠a̠ e̠mu̠ d̠inyin, ob̠eton d̠a̠ asi̠ ta̠ ob̠eb̠i Ebe̠l ka̠ o̠te̠i̠ d̠a̠ asi̠ ta̠ Azakaraya o̠nyi̠ ta̠ Abarakaya wa̠ igigh d̠a̠ esa̠d̠io otu ta̠ A̠zib̠a̠ na̠ enwen i̠ko̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, eb̠la̠ i̠nye̠n ta̠ emite d̠a̠ amu̠m onon. ");
INSERT INTO mgj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“A̠zeruse̠le̠m, A̠zeruse̠le̠m, anwa wa̠ na̠ aze̠ ma̠ a̠riwil bho̠, sa̠ na̠ a̠robhod̠i ma̠ ogbo ya̠ uruom oru d̠oyom bho̠. Ya̠a̠ i̠ni̠ igiel, ka̠ na̠ ebhir ami̠ ma̠ okokod̠i eb̠la̠ anwi̠i̠ny d̠oyom oguri onin esi, ma̠ agu̠o̠ e̠nu̠r-e̠ma na̠ a̠bhin rapu̠ba d̠o̠yo̠ na̠ a̠ghughuom anwi̠i̠ny d̠o̠yo̠ bho̠, ya̠a̠ anwa na̠ oma̠ra̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ya̠ga̠i, na̠ o̠we̠le̠ ma̠ otu d̠oyom oguri ma̠ obhobho i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, inyin ko o̠bi̠gh mu̠ ami̠ tu̠tu̠n inyin ta̠ ofugh ma̠a̠, ‘Itutumeni e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ na̠ a̠bhin a̠d̠ien ta̠ Wa̠nwuna̠ na̠ a̠ru bho̠.’” ");
INSERT INTO mgj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Igiel bho̠ A̠zizo̠s na̠ a̠mite na̠ ad̠u̠a d̠a̠ otu ta̠ A̠zib̠a̠ bho̠, sa̠ ogbo atu̠ghan d̠o̠yo̠ iru ra̠ i̠tu̠o̠gho̠m inigha̠ i̠na ma̠ eloma̠ otu ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sa̠ i̠na awo̠ran awa ma̠a̠, “Inyin na̠ o̠bi̠gh i̠di̠ar i̠nye̠n? Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin, ekpo ikputu ola̠ ta̠ aro̠ d̠a̠ anyu̠ ta̠ opa̠n ola̠ ko ob̠ogion d̠o̠ bo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sa̠ agu̠o̠ A̠zizo̠s aro̠ ma̠ a̠dila̠de d̠a̠ igu Roliv bho̠, sa̠ ogbo atu̠ghan d̠o̠yo̠ iru d̠o̠yo̠ ra̠ ifugh ma̠a̠, “Gba ma̠ a̠nigha̠ i̠yar, a̠kere obhel wa̠ i̠nye̠n ta̠ emite bho̠, na̠ ere wa̠ ta̠ aro̠ ma̠ elegh eruoma̠ d̠oyom na̠ ekunuguma̠ e̠mara̠nwunom bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sa̠ A̠zizo̠s awo̠ran agba a̠nigha̠ awa ma̠a̠: “I̠mare̠ ma̠ ekpona̠ ma̠ agu̠o̠ ola̠ o̠ni̠ ko ogelemeni d̠o̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A̠d̠izo a̠nwunom ta̠ ebhin a̠d̠ien d̠ami̠ eru, sa̠ ta̠ e̠gba ma̠a̠, ‘Ami̠ Akrai̠st,’ sa̠ ta̠ egelemeni ma̠ a̠d̠izo ogbo. ");
INSERT INTO mgj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Inyin ta̠ o̠mu̠gho̠n i̠mu̠mu̠gho̠n re̠gham, o̠ni̠ okpa̠ra̠numa̠ d̠o̠. I̠di̠ar ya̠ o̠ku̠a ta̠ emite, ya̠a̠ ekunuguma̠ obhel bho̠ ta̠ olei d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ebhugh ta̠ ewia̠n ebhugh, sa̠ irileghom ta̠ ewia̠n irileghom. Ibom ro̠ko̠i̠ ta̠ esor, sa̠ ra̠de ta̠ enyegia̠n eb̠omia̠n ekurubh, d̠a̠ a̠d̠izo a̠risi. ");
INSERT INTO mgj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ya̠a̠, eb̠la̠ i̠nye̠n kisa̠ ob̠eton ali̠gam a̠ruzu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Igiel o̠ku̠a, ta̠ ob̠eton inyin onigha̠ ma̠ ogbo ya̠ ta̠ e̠ni̠ni̠gi̠o̠m inyin, sa̠ ta̠ egigh inyin, sa̠ eb̠la̠ ibhebhia̠n bho̠ ta̠ e̠lo̠gh inyin a̠d̠ien d̠a̠ ebula̠ a̠d̠ien d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Igiel o̠ku̠a, a̠d̠izo ogbo ta̠ emel e̠d̠u̠a d̠a̠ ologi ima̠ra̠ bho̠, sa̠ odi ta̠ a̠luom odi, sa̠ awa ta̠ e̠lo̠gi̠an a̠rid̠ien, ");
INSERT INTO mgj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","sa̠ a̠d̠izo a̠riwil igunugha̠ ta̠ emite egelemeni ma̠ a̠d̠izo ogbo. ");
INSERT INTO mgj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sa̠ ebula̠ agu̠o̠ a̠ma̠rugh i̠te̠i̠ ta̠ a̠kpegiom a̠nwunom bho̠, etula̠n ta̠ aki̠r d̠a̠ esa̠d̠io a̠d̠izo ogbo. ");
INSERT INTO mgj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ya̠a̠ o̠ni̠ wa̠ a̠ne ka̠ ate̠i̠ d̠a̠ ekunuguma̠ bho̠ ta̠ a̠ten. ");
INSERT INTO mgj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sa̠ ta̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba irileghom bho̠ d̠a̠ eb̠la̠ e̠mara̠nwunom ma̠ agu̠o̠ ola̠ ko̠ni̠ko̠ni̠ ta̠ amu̠gho̠n, sa̠ ekunuguma̠ obhel bho̠ ta̠ a̠lei. ");
INSERT INTO mgj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, igiel inyin u̠bi̠gh ka̠ abar ola̠ omitegha̠n d̠o̠ na̠ a̠mite amara d̠a̠ esi e̠tu̠tu̠ bho̠, sa̠ i̠d̠i̠ar na̠ e̠pi̠e̠gi̠an, ma̠ agu̠o̠ owil Adani̠e̠l a̠wa̠ bho̠ (o̠ni̠ wa̠ na̠ a̠sen bho̠ amu̠gho̠nyan), ");
INSERT INTO mgj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bha̠, ogbo ya̠ od̠i d̠a̠ A̠zudia̠, eghil ebhun d̠a̠ rebhugh ya̠ i̠gi̠ ma̠ anyu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","O̠ni̠ wa̠ od̠i d̠a̠ anyu̠ otu bho̠ osor d̠o̠ ka̠ a̠bhin abar d̠a̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sa̠ o̠ni̠ wa̠ od̠i d̠a̠ od̠ighi bho̠ omula̠ d̠o̠ ka̠ a̠bhin ibura̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ya̠a̠ ekulom anwani̠ a̠rughun na̠ ogbo ya̠ na̠ enigha̠ ma̠ amu̠mam bho̠, d̠a̠ ra̠d̠a̠ma̠ i̠ye̠, ");
INSERT INTO mgj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Isiseinye ma̠ agu̠o̠ ola̠ e̠d̠u̠a d̠inyin ko osora̠n d̠o̠ d̠a̠ obhel a̠d̠igho, bo̠d̠o̠ d̠a̠ A̠d̠a̠ma̠ Osira̠ Epobh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ezin bho̠, ka̠ a̠sora̠n d̠a̠ igiel ola̠ o̠ku̠a, ali̠gam a̠ruzu bho̠ ta̠ a̠peleni ka̠ ate̠i̠ esi ola̠, ta̠ o̠bi̠gh ma̠ abar ola̠ oku̠a ta̠ od̠ia̠ d̠o̠ a̠mite ma̠ obhin d̠a̠ o̠pu̠r ob̠eton e̠mara̠nwunom bho̠ ra̠ o̠te̠i̠ i̠se̠n, ya̠ ko omite mu nyen. ");
INSERT INTO mgj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Sa̠ ku̠gba ma̠a̠, ukperemeni d̠o̠ ma̠ obhel bho̠, bebina̠ o̠ni̠ ola̠ ta̠ a̠miza̠n a̠d̠um bo̠. Ya̠a̠, d̠a̠ ebula̠ ogbo ya̠ na̠ o̠so̠n bho̠, ta̠ okperemeni ma̠ obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Igiel o̠ku̠a, ku̠gba ma̠ o̠ni̠ agba a̠nigha̠ inyin ma̠a̠, ‘Bi̠ghe̠, Akrai̠st od̠i ma̠ i̠se̠n!’ Bo̠d̠o̠, ‘Od̠i ma̠ ebha̠!’ O̠ni̠ ko od̠umom. ");
INSERT INTO mgj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ra̠krai̠st igunugha̠ na̠ a̠riwil igunugha̠ ta̠ emite sa̠ ta̠ eleriom ibom relegh na̠ ogir ilologia̠n, ma̠ agu̠o̠ ola̠ a̠b̠ur nab̠o̠, ka̠ igelemeni nyen ogbo ya̠ na̠ o̠so̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","I̠bi̠ghe̠! Ami̠ na̠ a̠d̠ia̠ agba a̠nigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, ku̠gba ma̠ o̠ni̠ agba a̠nigha̠ inyin ma̠a̠, ‘I̠bi̠ghe̠, od̠i d̠a̠ e̠ghana bho̠,’ ko o̠gi̠ ka̠ e̠bi̠ghan; bo̠d̠o̠, ‘I̠bi̠ghe̠, od̠i d̠a̠ e̠bhai̠, esi e̠wo̠gi̠na’ ko oma̠ra̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ezin bho̠, agu̠o̠ i̠me̠me̠gi̠na agbararan, ka̠ a̠mite d̠a̠ opu omite ogogo bho̠, sa̠ na̠ awar na̠ a̠misi d̠a̠ osor ogogo bho̠, obha̠ agu̠o̠ eruoma̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kesikesi ola̠ e̠b̠u̠re̠ od̠i, obha̠ esi ro̠de̠le̠ bho̠ na̠ ekokod̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ali̠gam a̠ruzu ra̠d̠a̠ma̠ i̠nye̠n ma̠ oten ku̠ku̠m bha̠, “ ‘Ogogo bho̠ o̠zu̠, sa̠ uwetere bho̠ ko o̠mu̠ mu̠; re̠ni̠nai̠ny bho̠ ta̠ e̠d̠u̠a d̠a̠ e̠nai̠ny emeleghu, sa̠ ra̠limon ya̠ od̠i d̠a̠ re̠nai̠ny bho̠ ta̠ enyegia̠n.’ ");
INSERT INTO mgj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“D̠a̠ obhel obha̠, sa̠ elegh O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠mite d̠a̠ e̠nai̠ny, sa̠ eb̠la̠ rebhugh e̠mara̠nwunom bho̠ ta̠ ed̠igh i̠ku̠nu̠. Sa̠ awa ta̠ e̠bi̠gh ka̠ O̠nyi̠ ta̠ O̠ni̠ na̠ a̠ru d̠a̠ o̠b̠u̠ghu̠b̠ugh ote̠nai̠ny na̠ a̠limon na̠ ibom isosorogia̠n. ");
INSERT INTO mgj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa̠ ta̠ a̠ruom itileduom d̠o̠yo̠ ma̠ opughe od̠od̠ue obom oghur, sa̠ ta̠ ekokod̠i ma̠ ogbo ya̠ i̠na na̠ aso̠n d̠a̠ inya̠ re̠ku̠l bho̠, obeton d̠a̠ ekunuguma̠ odi agba a̠de na̠ e̠nai̠ny o̠gi̠ ka̠ o̠te̠i̠ d̠a̠ esumogha̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“I̠tu̠ghane̠ ma̠ a̠sidogh oriren a̠fig bho̠: Igiel bha̠ i̠gha na̠ edugh na̠ a̠nwegina̠ ma̠ a̠to, bha̠ inyin ologhom ma̠ a̠kozogh na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Obha̠ agu̠o̠ od̠i nyen, igiel inyin u̠bi̠gh eb̠la̠ i̠di̠ar i̠nye̠n, iloghome ma̠ obhel bho̠ od̠i d̠a̠ e̠b̠ab̠a agu̠o̠, na̠ a̠misi d̠a̠ o̠nu̠ otu. ");
INSERT INTO mgj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, amu̠m onon ka̠ oten d̠o̠ a̠munia̠n kisa̠ eb̠la̠ i̠di̠ar i̠nye̠n ta̠ emite. ");
INSERT INTO mgj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A̠de na̠ e̠nai̠ny ta̠ eten e̠d̠u̠a, ya̠a̠ atu̠ghu̠me̠ni̠ d̠ami̠ ko oten d̠o̠ e̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ya̠ igboloma̠ ma̠ ologhom a̠d̠a̠ma̠ bho̠ na̠ obhel bho̠, o̠ni̠ ola̠ a̠loghom bo̠, a̠d̠igh itileduom ya̠ od̠i d̠a̠ ote̠nai̠ny bho̠, a̠d̠igh O̠nyi̠ bho̠. O̠we̠de̠ bho̠ ku̠ku̠m a̠loghom. ");
INSERT INTO mgj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Agu̠o̠ aro̠ d̠a̠ obhel ta̠ A̠nua̠ bho̠, obha̠ agu̠o̠ eruoma̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ezin bho̠ agu̠o̠ aro̠ d̠a̠ obhel bho̠, kisa̠ obom amu̠m a̠d̠igho bho̠ a̠ru bho̠, a̠nwunom na̠ ed̠e na̠ e̠d̠a, na̠ ebhinogh ranwani̠ na̠ enigha̠nom ra̠nwi̠i̠nyan, tu̠tu̠n d̠a̠ a̠d̠a̠ma̠ wa̠ A̠nua̠ a̠d̠igh d̠a̠ ologi obom oghugh bho̠; ");
INSERT INTO mgj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","sa̠ iloghom d̠o̠ ma̠ i̠d̠i̠ar ya̠ ta̠ emite tu̠tu̠n obom amu̠m a̠d̠igho bho̠ a̠ru, sa̠ aze̠ ko̠ni̠ko̠ni̠. Obha̠ agu̠o̠ eruoma̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","D̠a̠ obhel obha̠, i̠wal o̠ni̠ ta̠ e̠ro̠ d̠a̠ o̠si̠, ta̠ obhin odi sa̠ ta̠ o̠we̠le̠ ma̠ uwed̠i. ");
INSERT INTO mgj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","I̠wal anwani̠ ta̠ e̠ro̠ ma̠ esi o̠gbe̠ ed̠ia̠n na̠ e̠gbe̠ ma̠ ed̠ian, sa̠ ta̠ obhin odi o̠we̠le̠ ma̠ uwed̠i. ");
INSERT INTO mgj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, igone, ezin bho̠ inyin uloghom d̠o̠ ma̠ a̠d̠a̠ma̠ wa̠ Wa̠nwuna̠ d̠inyin ta̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","I̠mare̠ ma̠ e̠mu̠gho̠nyan abar onon. Ku̠gba ma̠ wa̠nwuna̠ ma̠ otu bho̠ a̠loghom obhel wa̠ o̠gba bho̠ ta̠ a̠ru bho̠ nab̠o̠, i̠na ka̠ i̠ro̠ ma̠ omom a̠kigima̠ ma̠ o̠gba bho̠ ma̠ ob̠om otu bho̠ od̠igh. ");
INSERT INTO mgj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ebula̠ o̠ku̠a, inyin eka̠ ikokod̠ia̠ne, ezin bho̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠ru ma̠ obhel ola̠ inyin o̠ru̠ru̠an d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“I̠se̠, ka̠ a̠nyen a̠ga̠i ob̠a̠ra̠motu wa̠ a̠loghom abar bho̠, ola̠ wa̠nwuna̠ bho̠ ta̠ a̠sibh, ma̠ okponom rob̠a̠ra̠motu d̠o̠yo̠ onigha̠ awa ma̠ ed̠ia̠n d̠a̠ obhel wa̠ akpe̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","E̠b̠e̠l ob̠a̠ra̠motu wa̠ ka̠ wa̠nwuna̠ i̠na bho̠ a̠ru, sa̠ ta̠ abi̠gh ma̠ i̠na na̠ amar na̠ a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin, wa̠nwuna̠ bho̠ ta̠ a̠b̠eton eb̠la̠ e̠li̠la d̠o̠yo̠ a̠nigha̠ i̠na ma̠ okponom. ");
INSERT INTO mgj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ya̠a̠, ku̠gba ma̠ ob̠a̠ra̠motu obha̠ ma̠ o̠karabh o̠ni̠, sa̠ aru̠ru̠an d̠a̠ ologi d̠o̠yo̠ ma̠a̠, ‘Wa̠nwuna̠ d̠ami̠ ta̠ a̠bia̠ ma̠ oru,’ ");
INSERT INTO mgj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sa̠ ake̠ ma̠ od̠ulogh rob̠a̠ra̠motu iyed̠i, sa̠ na̠ a̠d̠e na̠ ad̠a na̠ ro̠d̠amin. ");
INSERT INTO mgj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wa̠nwuna̠ ma̠ ob̠a̠ra̠motu bho̠ ta̠ a̠ru ma̠ a̠d̠a̠ma̠ ola̠ i̠na o̠ru̠ru̠an d̠o̠, na̠ obhel ola̠ i̠na ologhoma̠n d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa̠ ta̠ agu̠r i̠na ma̠ obom agu̠o̠ i̠zagba, sa̠ ta̠ alo̠gh i̠na d̠a̠ agba ibhelebhel bho̠: i̠se̠ esi bho̠ ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠ od̠i. ");
INSERT INTO mgj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“O̠ku̠a bha̠, ta̠ obhin irileghom ote̠nai̠ny o̠tu̠o̠m d̠iobh re̠kar anwi̠i̠nyan ya̠ ibhin rato̠di̠ d̠awa imite ma̠ agu̠o̠ ola̠ o̠gi̠ ka̠ o̠bi̠ghan o̠ni̠ erogh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ogho d̠a̠ o̠lo̠gh d̠awa bha̠ rema̠, ya̠a̠ ogho bha̠ iloghodi̠ar. ");
INSERT INTO mgj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Obhel bho̠ rema̠ bho̠ ibhin rato̠di̠ d̠awa bho̠, ibhin ani̠ d̠o̠ ma̠ amu̠nu̠ oliv e̠b̠aram. ");
INSERT INTO mgj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ya̠a̠, iloghodi̠ar bho̠ ibhin amu̠nu̠ oliv d̠a̠ rakana e̠b̠aram na̠ ya̠ od̠i d̠a̠ ato̠di̠ d̠awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sa̠ agu̠o̠ o̠ni̠ erogh bho̠ na̠ a̠bia̠ ma̠ oru bho̠, sa̠ eb̠la̠ awa iduka̠ sa̠ adi̠la ibhinom awa. ");
INSERT INTO mgj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“I̠se̠, d̠a̠ egum a̠d̠io, sa̠ awa i̠mu̠gho̠n izul ma̠a̠: ‘O̠ni̠ erogh bho̠ na̠ a̠ru ra̠ a̠misi! Imite ma̠ eru ra̠ e̠bi̠ghan i̠na!’ ");
INSERT INTO mgj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ebula̠ o̠ku̠a, sa̠ eb̠la̠ re̠kar anwi̠i̠nyan bho̠ i̠su̠ma, sa̠ i̠pi̠ki̠ ma̠ rato̠di̠ d̠awa ibu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sa̠ rema̠ bho̠ ifugh inigha̠ ma̠ iloghodi̠ar bho̠ ma̠a̠, ‘Inigha̠ i̠yar idi amu̠nu̠ oliv d̠inyin; ato̠di̠ d̠i̠yar na̠ ed̠im.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ya̠a̠, iloghodi̠ar bho̠ i̠wo̠ran ma̠a̠ ‘E̠nyi̠, ita̠ i̠yar eka̠ ko olei d̠o̠ i̠yar. Kpe̠le̠me̠ni̠, inyin na̠ agu̠o̠ i̠gi̠e̠ d̠a̠ ogbo ya̠ na̠ ewol bho̠ ka̠ egho ma̠ iya̠ inyin.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sa̠ agu̠o̠ awa i̠d̠u̠a ka̠ ogho bho̠, sa̠ o̠ni̠ erogh bho̠ a̠ru. Sa̠ ogbo ya̠ ikokod̠ia̠n bho̠ i̠tu̠o̠no̠m i̠na id̠igh d̠a̠ o̠d̠e̠ erogh bho̠, sa̠ u̠du̠ ma̠ otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“A̠tepa̠, sa̠ re̠kar anwi̠i̠nyan iyed̠i iru nyen, sa̠ ifugh ma̠a̠, ‘Wa̠nwuna̠, Wa̠nwuna̠, gurone ma̠ a̠d̠ighom i̠yar!’ ");
INSERT INTO mgj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ya̠a̠, i̠na awo̠ran awa ma̠a̠, ‘Ya̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ami̠ iloghom d̠o̠ inyin.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, igone, ezin bho̠ inyin uloghom d̠o̠ ma̠ a̠d̠a̠ma̠ bho̠, bo̠d̠o̠ obhel bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Irileghom ote̠nai̠ny od̠i ma̠ agu̠o̠ o̠ni̠ ola̠ na̠ a̠ru ra̠ ob̠etina̠ e̠gi̠, sa̠ i̠na a̠kokod̠i ma̠ rob̠a̠ra̠motu d̠o̠yo̠, sa̠ aru̠gi̠ awa ma̠ i̠di̠ar d̠o̠yo̠ ma̠ okponom. ");
INSERT INTO mgj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sa̠ i̠na a̠nigha̠ ma̠ odi ogho e̠kpa ikpoki,sa̠ a̠nigha̠ ma̠ odi i̠wal, sa̠ odi onin, o̠ni̠ i̠se̠ ma̠ agu̠o̠ e̠mi̠ bho̠ a̠lei bho̠, sa̠ i̠na a̠b̠etina̠ epa̠ ma̠ e̠gi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","O̠ni̠ wa̠ ada ma̠ ogho e̠kpa ikpoki obhel obha̠, sa̠ a̠bhin a̠b̠ua̠ ma̠ a̠b̠ua̠, sa̠ ate̠i̠ asu̠o̠ ogho ab̠aram. ");
INSERT INTO mgj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Onin agu̠o̠ bho̠, wa̠ i̠wal bho̠ eka̠, ate̠i̠ asu̠o̠ i̠wal ab̠aram. ");
INSERT INTO mgj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ya̠a̠, wa̠ unigha̠ ma̠ onin bho̠, agi̠ ka̠ a̠gbo d̠a̠ a̠de awo̠gi̠ ma̠ okpoki ta̠ wa̠nwuna̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Owewegh obhel a̠ten, sa̠ wa̠nwuna̠ ma̠ rob̠a̠ra̠motu bho̠ a̠ru ma̠ oselegi o̠wal ogir d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sa̠ ob̠a̠ra̠motu wa̠ unigha̠ ma̠ ogho e̠kpa ikpoki ab̠ar na̠ ipa̠n ogho e̠kpa a̠ru, sa̠ agba ma̠a̠, ‘Wa̠nwuna̠, anwa inigha̠ ami̠ ogho e̠kpa ikpoki, bi̠ghe̠, ami̠ i̠te̠i̠ asu̠o̠ ipa̠n ogho e̠kpa.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa a̠gir, anwa a̠ga̠i ob̠a̠ra̠motu! Anwa ibhin onyen ologi a̠gir d̠a̠ i̠ki̠kara i̠di̠ar ya̠ ami̠ inigha̠ nyam bho̠, ebula̠ o̠ku̠a, i̠se̠n ami̠ na̠ aso̠n anwa ma̠ orileghom i̠di̠ar ya̠ ib̠uiy ipu ma̠ i̠nye̠n. Ke̠ ma̠ i̠se̠n a̠d̠e ma̠ e̠no̠gho̠man ta̠ wa̠nwuna̠ nyam.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Sa̠ wa̠ unigha̠ i̠wal e̠kpa ikpoki eka̠ a̠ru ra̠ agba ma̠a̠, ‘Wa̠nwuna̠, anwa inigha̠ ami̠ i̠wal e̠kpa ikpoki, bi̠ghe̠, ami̠ i̠te̠i̠ asu̠o̠ ipa̠n i̠wal e̠kpa.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa amar a̠gir, anwa a̠ga̠i ob̠a̠ra̠motu! Anwa ibhin onyen ologi a̠gir d̠a̠ i̠ki̠kara i̠di̠ar ya̠ ami̠ inigha̠ nyam bho̠, ebula̠ o̠ku̠a, i̠se̠n ami̠ na̠ aso̠n anwa ma̠ orileghom i̠di̠ar ya̠ ib̠uiy ipu ma̠ i̠nye̠n. Ke̠ ma̠ i̠se̠n a̠d̠e ma̠ e̠no̠gho̠man ta̠ wa̠nwuna̠ nyam.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sa̠ wa̠ unigha̠ ma̠ onin e̠kpa ikpoki bho̠ eka̠ a̠ru ra̠ a̠fugh ma̠a̠, ‘Wa̠nwuna̠, ami̠ amar a̠loghom anwa, anwa na̠ okpon d̠o̠ ma̠ o̠ni̠ ma̠ igbirigbir, anwa na̠ a̠b̠u ma̠ esi ola̠ anwa ogbebh d̠o̠, sa̠ anwa na̠ a̠kokod̠i ma̠ i̠di̠ar ya̠ anwa okpo d̠o̠ asar. ");
INSERT INTO mgj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ebula̠ o̠ku̠a sa̠ ami̠ ighil a̠rugugu, sa̠ ami̠ i̠gi̠ ka̠ i̠wo̠gi̠ ma̠ ikpoki d̠oyom d̠a̠ a̠de. Kpone, i̠do̠ ma̠ ikpoki d̠oyom.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa o̠gbo̠ro̠gbo̠r obhobho i̠kpo̠ ob̠a̠ra̠motu. Anwa a̠loghom ma̠ ami̠ na̠ a̠b̠u ma̠ esi ola̠ ami̠ ogbebh d̠o̠, sa̠ ami̠ na̠ a̠kokod̠i ma̠ i̠di̠ar ya̠ ami̠ okpo d̠o̠ asar. ");
INSERT INTO mgj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ku̠gba ma̠ o̠ku̠a, sa̠ akpe̠ nyam o̠lo̠gh okpoki d̠ami̠ d̠a̠ otu-ikpoki bho̠, b̠o̠ka̠ igiel ami̠ iru, ami̠ ate̠i̠ ikpoki d̠ami̠ na̠ asu̠o̠ ya̠ ka̠ i̠mar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Ebula̠ o̠ku̠a, ibhine ma̠ ikpoki bho̠ d̠a̠ agu̠o̠ d̠o̠yo̠ ma̠ enigha̠ i̠na wa̠ ate̠i̠ d̠iobh ami̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ezin bho̠, o̠ni̠ wa̠ ate̠i̠ ya̠ ib̠uiy bho̠, ta̠ onigha̠ ma̠ o̠gbam; ya̠a̠, i̠na o̠ni̠ wa̠ o̠te̠i̠ d̠o̠ bho̠, bebina̠ o̠nyi̠ki̠kara ya̠ i̠na ate̠i̠ bho̠ eka̠, ta̠ o̠wo̠r obhin. ");
INSERT INTO mgj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sa̠ a̠ruom ma̠ oze ma̠ ob̠a̠ra̠motu wa̠ omutiom d̠o̠ ma̠ asu̠o̠ bho̠, od̠ighom d̠a̠ obom azi̠m; i̠se̠ bha̠ esi ed̠i na̠ o̠ghi̠r ib̠ub̠ura̠ od̠i.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sa̠ obhel bho̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠ru na̠ isosorogia̠n d̠o̠yo̠ bho̠, eb̠la̠ itileduom ta̠ A̠zib̠a̠ bho̠ ta̠ ed̠igh na̠ i̠na eru, sa̠ i̠na ta̠ aro̠ d̠a̠ i̠kasi̠ a̠dila̠de irileghom isosorogia̠n d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa̠ a̠nwunom eb̠la̠ ra̠dede bho̠ ta̠ ekokod̠ia̠n d̠a̠ a̠misigh d̠o̠yo̠, sa̠ i̠na ta̠ abagi̠o̠n awa ma̠ ebu ebu, agu̠o̠ okponom ro̠nana na̠ abagi̠o̠n ro̠nana bho̠ na̠ iwel bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sa̠ i̠na ta̠ a̠bhin ro̠nana bho̠ amar a̠guri d̠a̠ od̠iom agu̠o̠ d̠o̠yo̠, ya̠a̠ iwel bho̠ d̠a̠ ekiel. ");
INSERT INTO mgj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“D̠a̠ obhel obha̠ sa̠ O̠li̠le̠ma bho̠ ta̠ agba a̠nigha̠ ma̠ ebu wa̠ d̠a̠ agba od̠iom agu̠o̠ d̠o̠yo̠ bho̠ ma̠a̠, ‘Itue ma̠ i̠se̠n, inyin ogbo ya̠ O̠we̠de̠ d̠ami̠ na̠ ane̠ghe̠ ma̠ e̠ne̠ghe̠ ya̠ ukokod̠i uguri isisa̠n inyin ka̠ d̠a̠ o̠pu̠r ob̠eton e̠mara̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ezin bho̠, o̠ko̠i̠ a̠d̠ighi ami̠ sa̠ inyin unigha̠ ami̠ ma̠ ed̠ia̠n, e̠d̠o̠gh amu̠m a̠d̠ighi ami̠, sa̠ inyin unigha̠ ami̠ ma̠ amu̠m o̠d̠a, ami̠ iru ma̠ isuloma̠ sa̠ inyin ud̠ighom ami̠, ");
INSERT INTO mgj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ami̠ i̠ro̠ ma̠ e̠dab̠a sa̠ inyin umuneni ami̠ ma̠ ukpe, ami̠ i̠nwe̠r asu̠nwe̠r sa̠ inyin ukoko ami̠, u̠lo̠gh ami̠ ma̠ ikoli sa̠ inyin uru ra̠ ukpon ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“D̠a̠ obhel obha̠ sa̠ ib̠eb̠i a̠nwunom bho̠ i̠wo̠ran ma̠a̠, ‘Wa̠nwuna̠, a̠kere obhel wa̠ i̠yar u̠bi̠gh ma̠ o̠ko̠i̠ na̠ a̠d̠ighi nyam sa̠ i̠yar unigha̠ nyam ed̠ia̠n bho̠, bo̠d̠o̠ e̠d̠o̠gh amu̠m a̠d̠ighi nyam sa̠ unigha̠ nyam amu̠m o̠d̠a bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A̠kere obhel wa̠ i̠yar u̠bi̠gh anwa ma̠ isuloma̠ sa̠ ud̠ighom anwa bho̠, bo̠d̠o̠ anwa i̠ro̠ ma̠ e̠dab̠a sa̠ umuneni nyam ukpe bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A̠kere obhel wa̠ i̠yar u̠bi̠gh ka̠ anwa na̠ anwe̠r, bo̠d̠o̠ anwa i̠ro̠ d̠a̠ ikoli sa̠ i̠yar u̠gi̠ ka̠ ukpon anwa bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Sa̠ O̠li̠le̠ma bho̠ ta̠ awo̠ran awa ma̠a̠, ‘Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, agu̠o̠ inyin ugir unigha̠ ma̠ odi o̠ni̠ d̠a̠ o̠lo̠gh d̠ami̠ wa̠ ikulom ipu bho̠, bha̠ inyin ugir unigha̠ ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“D̠a̠ obhel obha̠ sa̠ i̠na ta̠ agba a̠nigha̠ nyen ogbo ya̠ d̠a̠ ekiel bho̠ ma̠a̠, ‘Itene ma̠ e̠d̠u̠a d̠a̠ a̠misigh d̠ami̠, inyin ogbo ya̠ na̠ osugi ma̠ od̠igh d̠a̠ e̠ba anya wa̠ ekunuguma̠ o̠to̠ bho̠, wa̠ ugbonogi usisa̠n Eru Bho̠ na̠ itileduom d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ezin bho̠ o̠ko̠i̠ a̠d̠ighi ami̠, ya̠ inyin unigha̠ d̠o̠ ami̠ ma̠ ed̠ia̠n, e̠d̠o̠gh amu̠m a̠d̠ighi ami̠ ya̠ inyin unigha̠ d̠o̠ ami̠ ma̠ amu̠m ya̠ o̠d̠a, ");
INSERT INTO mgj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ami̠ iru ma̠ isuloma̠ ya̠ inyin ud̠ighom d̠o̠ ami̠ d̠a̠ otu, ami̠ i̠ro̠ ma̠ e̠dab̠a ya̠ inyin umuneni d̠o̠ ami̠ ma̠ ukpe, ami̠ i̠nwe̠r asu̠nwe̠r aro̠ nyen d̠a̠ ikoli, ya̠a̠ inyin uru d̠o̠ ra̠ okpon ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“O̠ku̠a sa̠ a̠wa ta̠ e̠wo̠ran nyen ma̠a̠, ‘Wa̠nwuna̠, a̠kere obhel wa̠ i̠yar u̠bi̠gh ka̠ anwa i̠ro̠ ma̠ o̠ko̠i̠, bo̠d̠o̠ e̠d̠o̠gh amu̠m a̠d̠ighi nyam, bo̠d̠o̠ anwa iru ma̠ isuloma̠, bo̠d̠o̠ anwa i̠ro̠ ma̠ e̠dab̠a, bo̠d̠o̠ i̠ro̠ d̠a̠ asu̠nwe̠r, bo̠d̠o̠ i̠ro̠ d̠a̠ ikoli, sa̠ i̠yar u̠we̠le̠man oru ra̠ o̠lo̠gh agu̠o̠ onigha̠ oyom?’ ");
INSERT INTO mgj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sa̠ i̠na ta̠ awo̠ran awa ma̠a̠, ‘Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, agu̠o̠ inyin ogir d̠o̠ onigha̠ ma̠ odi o̠ni̠ awa wa̠ ikulom ipu d̠a̠ o̠lo̠gh d̠ami̠ bho̠, bha̠ inyin ugir d̠o̠ onigha̠ ami̠ nyen.’ ");
INSERT INTO mgj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sa̠ i̠nye̠n ta̠ e̠gi̠ ka̠ ed̠igh d̠a̠ alu̠kpe̠ egbika̠ wa̠ ekunuguma̠ o̠to̠ bho̠, ya̠a̠ ib̠eb̠i a̠nwunom bho̠ ta̠ ed̠igh d̠a̠ esi a̠ghud̠um ekunuguma̠ o̠to̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Igiel bho̠ A̠zizo̠s na̠ a̠munieni ma̠ ratu̠ghu̠me̠ni̠ i̠nye̠n bho̠, sa̠ agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Inyin ologhom ma̠a̠, ka̠ i̠wal a̠d̠a̠ma̠ iten, bha̠ E̠yal Opel Oten bho̠ na̠ a̠lei; sa̠ ta̠ owol O̠nyi̠ ta̠ O̠ni̠ ma̠ agu̠o̠ ola̠ ta̠ o̠du̠ ogigh.” ");
INSERT INTO mgj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","D̠a̠ obhel obha̠, sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ ikei a̠nwunom bho̠ ikokod̠ia̠n d̠a̠ otu irileghom ta̠ we̠mu̠ okur bho̠ wa̠ ubhelegi ma̠ A̠keyafas bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sa̠ awa imimia̠n imutioghom re̠kal ya̠ obhin ikoiny ob̠ol A̠zizo̠s ogigh. ");
INSERT INTO mgj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ya̠a̠ imimia̠n ma̠a̠, “Ko o̠ro̠ d̠o̠ d̠a̠ e̠yal bho̠ b̠o̠ka̠ elobhiri ogbo e̠ma na̠ osor.” ");
INSERT INTO mgj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","I̠se̠n bha̠, A̠zizo̠s od̠i d̠a̠ Abe̠tani̠ d̠a̠ otu ta̠ Asai̠mo̠n wa̠ anwe̠r asu̠nwe̠r ekid̠igh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sa̠ odi ani̠ a̠bhin ololo amu̠nu̠ ed̠u e̠nu̠nu̠ ola̠ ibom a̠b̠ua̠, a̠ru ra̠ a̠zuom d̠a̠ e̠mu̠ d̠o̠yo̠, ma̠ agu̠o̠ i̠na od̠i d̠a̠ akpata od̠e bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ya̠a̠ igiel bho̠ ogbo ogir bho̠ i̠bi̠gh bho̠, sa̠ iguromeni ma̠ rologi ipura̠n ma̠a̠, “A̠din ere na̠ a̠robh amu̠nu̠ ed̠u e̠nu̠nu̠ i̠nye̠n o̠ku̠a?” ");
INSERT INTO mgj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nab̠o̠, amu̠nu̠ i̠nye̠n elei iya̠ ka̠ uwol ibom a̠b̠ua̠ obhin onigha̠ ma̠ ronyigoiny bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya̠a̠, A̠zizo̠s a̠loghom abar wa̠ awa na̠ e̠ru̠ru̠an bho̠, sa̠ a̠fugh a̠nigha̠ awa ma̠a̠, “Inyin udin ere na̠ o̠nyo̠gho̠ghan na̠ ogboloma̠ ma̠ ib̠eb̠i ya̠ ani̠ onon a̠gir a̠nigha̠ ami̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ronyigoiny bho̠ sa̠ od̠i na̠ inyin eb̠la̠ obhel, ya̠a̠ Ami̠ ka̠ o̠ro̠ d̠o̠ na̠ inyin eb̠la̠ obhel. ");
INSERT INTO mgj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ezin bho̠, a̠zuom ami̠ ma̠ amu̠nu̠ ed̠u e̠nu̠nu̠ nyen, ma̠ agu̠o̠ ola̠ o̠tu̠ghu̠man ozu d̠ami̠ ogboloma̠ a̠ma̠d̠i d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, kesikesi ola̠ ta̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba i̠nye̠n d̠a̠ eb̠la̠ e̠mara̠nwunom bho̠, ta̠ o̠gba nyen abar onon wa̠ i̠na a̠gir bho̠ obhin o̠ru̠ru̠an i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sa̠ odi d̠a̠ a̠d̠iobh na̠ i̠wal bho̠, wa̠ ubhelegi ma̠ A̠zuda̠s Iskari̠o̠t bho̠, agi̠ ka̠ ate̠i̠ ogbo aru̠mu̠ rokur bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka̠ a̠pura̠n ma̠a̠, “Inyin ta̠ onigha̠ ami̠ ma̠ ere ka̠ ami̠ ib̠eton i̠na inigha̠ inyin?” Sa̠ awa i̠wal a̠d̠usubh na̠ d̠iobh ikpoki a̠silva̠ inigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ob̠eton d̠a̠ obhel obha̠, sa̠ A̠zuda̠s ake̠ ma̠ o̠bho̠ro̠ghan e̠ti̠ti̠gha ola̠ ta̠ a̠sora̠n i̠na ma̠ owol A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","D̠a̠ o̠pu̠r a̠d̠a̠ma̠ E̠yal Abe̠re̠di̠ wa̠ Owubh d̠o̠ bho̠, sa̠ ogbo atu̠ghan ta̠ A̠zizo̠s iru ra̠ i̠te̠i̠ i̠na ipura̠n ma̠a̠, “A̠kere esi wa̠ anwa na̠ abho̠ro̠ghan i̠yar o̠gi̠ ka̠ o̠tu̠ghu̠man osisa̠n oyom, ma̠ od̠e ed̠ia̠n E̠yal Opel Oten bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “I̠gi̠e̠ d̠a̠ e̠ma bho̠ ka̠ e̠gba ma̠ enigha̠ ma̠ odi o̠ni̠ ma̠a̠, ‘O̠ni̠ atu̠ghu̠me̠ni̠ bho̠ agba ma̠a̠: Obhel d̠ami̠ na̠ a̠tua̠n, ami̠ na̠ ogbo atu̠ghan d̠ami̠ ta̠ od̠e ma̠ E̠yal Opel Oten bho̠ d̠a̠ otu d̠oyom.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sa̠ ogbo atu̠ghan bho̠ igir agu̠o̠ A̠zizo̠s a̠ruom awa bho̠, sa̠ awa ikokod̠ia̠n E̠yal Opel Oten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Agu̠o̠ ate̠i̠ a̠dule bho̠, sa̠ i̠na na̠ a̠d̠iobh na̠ i̠wal bho̠ i̠ro̠ d̠a̠ akpata od̠e, ");
INSERT INTO mgj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","na̠ ed̠e ma̠ ed̠ia̠n bho̠, sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin, odi o̠ni̠ inyin ta̠ a̠wol ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sa̠ awa ib̠ogina̠ ma̠ ibom, sa̠ o̠ni̠ o̠ni̠ i̠se̠ ake̠ ma̠ opura̠n o̠yo̠ ma̠a̠, “Wa̠nwuna̠, ami̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sa̠ i̠na awo̠ran awa ma̠a̠, “O̠ni̠ wa̠ alo̠gh agu̠o̠ na̠ ami̠ d̠a̠ onin e̠kpa ed̠ia̠n bho̠, bha̠ wa̠ ta̠ a̠wol ami̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","O̠nyi̠ ta̠ O̠ni̠ ta̠ agi̠ ma̠ agu̠o̠ u̠ge̠ ugboloma̠ I̠na bho̠, ya̠a̠ itogi e̠ro̠ enigha̠ ma̠ o̠ni̠ wa̠ ta̠ o̠wo̠l ob̠ol O̠nyi̠ ta̠ O̠ni̠ bho̠! O̠we̠le̠man o̠mar o̠yo̠ ka̠ ibhon a̠pu.” ");
INSERT INTO mgj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sa̠ A̠zuda̠s wa̠ ta̠ a̠wol i̠na bho̠ a̠pura̠n i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, anwa na̠ agba ma̠ ami̠, ka̠din?” Sa̠ i̠na awo̠ran ma̠a̠, “Anwa na̠ agu̠o̠ na̠ agba.” ");
INSERT INTO mgj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Obhel bho̠ awa na̠ ed̠e bho̠, sa̠ A̠zizo̠s a̠bhin abe̠re̠di̠, sa̠ a̠tutumeni, sa̠ a̠puron a̠nigha̠ ma̠ ogbo atu̠ghan bho̠ agba ma̠a̠, “Ibhine ma̠ ed̠e; onon ozu d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sa̠ i̠na a̠bhin okpa̠ko bho̠, sa̠ ase̠bh A̠zib̠a̠, sa̠ a̠nigha̠ awa agba ma̠a̠, “Eb̠la̠ inyin ibhine ma̠ e̠d̠a. ");
INSERT INTO mgj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ezin bho̠ i̠nye̠n asi̠ d̠ami̠, wa̠ aghu̠ame̠ni̠ ma̠ i̠zo̠ bho̠, asi̠ wa̠ uzu unigha̠ ma̠ eb̠la̠ a̠nwunom ma̠ agu̠o̠ ola̠ obhin o̠we̠le̠man i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, obhin i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, ami̠ ko o̠d̠a mu̠ ma̠ a̠min itu a̠grep tu̠tu̠n d̠a̠ a̠d̠a̠ma̠ wa̠ ami̠ ta̠ a̠d̠igh na̠ inyin ad̠a ma̠ imom a̠min d̠a̠ irileghom ta̠ O̠we̠de̠ d̠ami̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sa̠ awa i̠mo̠r aso̠r, sa̠ i̠d̠u̠a i̠gi̠ d̠a̠ igu Roliv. ");
INSERT INTO mgj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Eb̠la̠ inyin ta̠ eghil e̠we̠le̠man ami̠ e̠d̠u̠a ma̠ a̠d̠ugula̠n onon ebula̠ ami̠, ezin bho̠ na̠ o̠ge̠ oguri d̠a̠ a̠d̠ire e̠tu̠tu̠ ma̠a̠: “ ‘Ami̠ ta̠ a̠gigh okponom ro̠nana bho̠, sa̠ o̠lo̠gh ro̠nana bho̠ ta̠ e̠sasaragi̠an.’ ");
INSERT INTO mgj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ya̠a̠, igiel ami̠ na̠ a̠b̠etina̠, sa̠ ami̠ ta̠ agi̠ ka̠ aro̠ a̠b̠a̠ra̠ inyin d̠a̠ Agalili.” ");
INSERT INTO mgj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sa̠ A̠pita̠ awo̠ran i̠na ma̠a̠, “Ka̠ aro̠ ma̠ ola̠ eb̠la̠ a̠nwunom ighilighu i̠d̠u̠a eka̠, ami̠ ko oghil ani̠ d̠o̠ ad̠u̠a.” ");
INSERT INTO mgj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ya̠a̠ A̠zizo̠s agba a̠nigha̠ i̠na ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, a̠d̠ugula̠n onon, kisa̠ olobhiri e̠nu̠r bho̠ ta̠ alal, anwa ta̠ aku̠a ma̠ i̠sar igiel ma̠a̠ anwa na̠ ologhom d̠o̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sa̠ A̠pita̠ awo̠ran i̠na ma̠a̠, “Ka̠ aro̠ ma̠ ola̠ ami̠ ta̠ a̠d̠igh na̠ Anwa a̠mugh eka̠, ami̠ ka̠ o̠ku̠a d̠o̠ nyam.” Sa̠ eb̠la̠ ogbo atu̠ghan bho̠ ifugh ani̠ ma̠ onin agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sa̠ A̠zizo̠s na̠ ogbo atu̠ghan do̠yo̠ i̠gi̠ d̠a̠ esi ola̠ ubhelegi ma̠ Age̠tsemani, sa̠ a̠ruom awa ma̠a̠, “I̠ro̠ ma̠ i̠se̠n a̠dila̠de, ya̠ ami̠ ta̠ agi̠ ma̠ ebha̠ ka̠ a̠siseiny.” ");
INSERT INTO mgj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sa̠ i̠na a̠bhin A̠pita̠ na̠ i̠wal anwi̠i̠ny ta̠ Aze̠bidi ab̠aragi̠ma̠ i̠na, sa̠ i̠na asu̠su̠ghu̠d̠i̠an a̠d̠igh i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Eloghoma̠n ozu d̠ami̠ na̠ aku̠nu̠ ma̠ ibom, aro̠ ka̠ omugh a̠sugho. I̠ro̠ omom na̠ ami̠ ma̠ i̠se̠n.” ");
INSERT INTO mgj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sa̠ i̠na agi̠ ma̠ i̠ki̠kara d̠a̠ ed̠ia̠ ka̠ a̠b̠obhia̠n a̠siseiny a̠fugh ma̠a̠, “O̠we̠de̠ d̠ami̠, ku̠gba ma̠ ta̠ a̠b̠ur nab̠o̠, d̠ighi ma̠ ola̠ okpa̠ko onon a̠ten ad̠u̠a d̠ami̠. D̠a̠ o̠ku̠a eka̠, o̠ro̠ d̠o̠ ku̠ d̠a̠ i̠to̠ d̠ami̠, ya̠a̠ d̠a̠ i̠to̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sa̠ A̠zizo̠s agi̠ ka̠ ate̠i̠ ogbo atu̠ghan bho̠ sa̠ abi̠gh ma̠a̠ awa na̠ ekod̠u, sa̠ i̠na a̠pura̠n A̠pita̠ ma̠a̠, “Inyin urue d̠o̠ ma̠ od̠igh na̠ ami̠ o̠ro̠ omom bebina̠ ekud̠i obhel ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","I̠ro̠ ma̠ omom esiseiny b̠o̠ka̠ inyin umel d̠o̠ d̠a̠ ed̠igh d̠a̠ ad̠agi̠an. E̠mu̠gh bho̠ na̠ e̠ral ya̠a̠ ozu bho̠ na̠ a̠dugh.” ");
INSERT INTO mgj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa̠ i̠na a̠mula̠ agi̠ ma̠ oleghemeni i̠wal igiel ka̠ a̠siseiny a̠fugh ma̠a̠, “O̠we̠de̠ d̠ami̠, ku̠gba ma̠ okpa̠ko egbika̠ onon ka̠ orue d̠o̠ a̠ten ad̠u̠a, a̠ten ka̠ Ami̠ i̠d̠a, bha̠ i̠to̠ d̠oyom emite.” ");
INSERT INTO mgj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sa̠ i̠na a̠mula̠ agi̠ ka̠ abi̠gh ma̠ awa na̠ ekod̠u, ezin bho̠ a̠rid̠ien d̠awa na̠ e̠mu̠mo̠r ibom. ");
INSERT INTO mgj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sa̠ i̠na awe̠le̠man awa a̠puta̠ agi̠ ka̠ a̠siseiny oleghemeni i̠sar igiel, a̠fugh onin abar bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sa̠ i̠na a̠mula̠ agi̠ d̠a̠ i̠sar ogbo atu̠ghan bho̠ ka̠ agba a̠nigha̠ awa ma̠a̠, “Inyin od̠idia̠ na̠ ekod̠u na̠ esira̠ ma̠ epobh? Ikpone, iloghome ma̠ obhel wa̠ u̠to̠ ugiri bho̠ na̠ a̠lei, sa̠ ta̠ owol O̠nyi̠ ta̠ O̠ni̠ o̠lo̠gh d̠a̠ agu̠o̠ ta̠ idighi ma̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ib̠egina̠! na̠ a̠lei o̠gi̠! Wa̠ a̠wol ami̠ bho̠ aro̠ ka̠ na̠ a̠misi ma̠ i̠se̠n!” ");
INSERT INTO mgj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","I̠na od̠id̠ia̠ na̠ a̠fugh, sa̠ obom o̠lo̠gh a̠nwunom ya̠ isibhi ma̠ rab̠e̠ge̠re̠ na̠ re̠b̠am ya̠ i̠d̠u̠a d̠a̠ re̠mu̠ rokur bho̠ na̠ ikei bho̠ i̠tu̠o̠no̠m A̠zuda̠s, odi o̠ni̠ d̠a̠ awa a̠d̠iobh na̠ i̠wal bho̠, a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","I̠se̠n, wa̠ a̠wol i̠na bho̠ a̠tu̠o̠m elegh a̠leriom awa ma̠a̠: “O̠ni̠ wa̠ ami̠ ta̠ api̠pi̠o̠bh bho̠ bha̠ O̠ni̠ bho̠, ib̠ole i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","D̠a̠ onin obhel bho̠ sa̠ i̠na agi̠ epa̠ d̠a̠ A̠zizo̠s ka̠ a̠fugh ma̠a̠, “We̠mu̠ Atu̠ghu̠me̠ni̠, ami̠ a̠bheleguma̠ nyam o!” Sa̠ api̠pi̠o̠bh i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “A̠tologha̠n, gire ma̠ abar wa̠ anwa idin iru bho̠.” Sa̠ o̠lo̠gh a̠nwunom bho̠ iru ra̠ isibh A̠zizo̠s, sa̠ ib̠ol i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I̠se̠, sa̠ odi o̠ni̠ ola̠ aro̠ na̠ A̠zizo̠s a̠mutiom ab̠e̠ge̠re̠ do̠yo̠ sa̠ a̠sobh a̠to ta̠ ob̠a̠ra̠motu we̠mu̠ rokur bho̠ a̠b̠uton. ");
INSERT INTO mgj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ya̠a̠, A̠zizo̠s aghaghana i̠na a̠fugh ma̠a̠, “Lo̠ghe̠ ma̠ ab̠e̠ge̠re̠ d̠oyom ma̠ esi wa̠ akpe̠ ma̠ o̠ro̠ bho̠, ezin bho̠ eb̠la̠ ogbo ya̠ na̠ esibh ab̠e̠ge̠re̠, na̠ emugh d̠a̠ ab̠e̠ge̠re̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bo̠d̠o̠ ka̠ anwa na̠ aru̠ru̠an ma̠a̠, ami̠ ka̠ orue d̠o̠ a̠bhelegi ma̠ O̠we̠de̠ d̠ami̠ ma̠ o̠fi̠ri̠ma ami̠ ma̠ d̠iobh na̠ i̠wal ro̠lo̠ghitileduom ta̠ A̠zib̠a̠ ma̠ i̠se̠n i̠se̠n, ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","O̠ku̠a ka̠ ta̠ od̠ighi eka̠ omuzoghod̠iom ya̠ u̠ge̠ d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠, ya̠ i̠kpe̠ ma̠ omite bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","D̠a̠ obhel obha̠, sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠ ma̠a̠, “Ami̠ na̠ a̠wia̠n o̠go̠ ebhugh ke̠re̠, ma̠ ola̠ inyin ubhin rab̠e̠ge̠re̠ na̠ re̠b̠am na̠ oru ra̠ ob̠ol ami̠. Ami̠ i̠ro̠ghan a̠dila̠de d̠a̠ otu ta̠ A̠zib̠a̠ atu̠ghu̠me̠ni̠ ya̠a̠ inyin ub̠ol d̠o̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ya̠a̠, eb̠la̠ i̠nye̠n imite ma̠ agu̠o̠ ola̠ ta̠ omuzoghod̠iom i̠di̠ar ya̠ a̠riwil bho̠ i̠ge̠ iguri d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠.” Sa̠ eb̠la̠ ogbo atu̠ghan bho̠ i̠we̠le̠ i̠na i̠ghil i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ogbo ya̠ ib̠ol A̠zizo̠s bho̠, ibhin i̠na e̠gi̠ d̠a̠ A̠keyafas, we̠mu̠ rokur bho̠, esi wa̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ ikei bho̠ na̠ ekokod̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ya̠a̠, A̠pita̠ aro̠ ma̠ egbeiny atu̠o̠no̠m i̠na ka̠ ate̠i̠ d̠a̠ ogigo ta̠ we̠mu̠ rokur bho̠, sa̠ a̠d̠igh d̠a̠ ologi ka̠ aro̠ ma̠ a̠dila̠de na̠ rokponomotu bho̠, ma̠ o̠bi̠gh agu̠o̠ ta̠ a̠bhin a̠kunugiom. ");
INSERT INTO mgj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ eb̠la̠ ogbo osobh ase̠ bho̠ i̠bho̠ro̠ghan o̠ni̠ ola̠ ta̠ agba ma̠ onyob̠a̠ igunugha̠ a̠b̠ologiom A̠zizo̠s, ma̠ agu̠o̠ ola̠ awa ta̠ ebhin esobh ase̠ bho̠ ebhumeni i̠na egigh. ");
INSERT INTO mgj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A̠d̠izo ronyob̠a̠ igunugha̠ emite, ya̠a̠ abar ola̠ a̠sibh i̠na na̠ o̠ro̠ d̠o̠. D̠a̠ ekunuguma̠ bho̠, sa̠ i̠wal ronyob̠a̠ imite, ");
INSERT INTO mgj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","i̠gba ma̠a̠, “O̠ni̠ onon agba ma̠a̠, ‘Ami̠ ta̠ a̠b̠ogion otu ta̠ A̠zib̠a̠ sa̠ Ami̠ ta̠ a̠mula̠ a̠lo amado̠n d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sa̠ we̠mu̠ rokur bho̠ a̠b̠etina̠ amara a̠fugh a̠nigha̠ i̠na ma̠a̠, “Anwa̠ ka̠ o̠wo̠ran d̠o̠ ke̠re̠? Onon ka̠ a̠kere a̠d̠ien abar ola̠ na̠ o̠gba na̠ ob̠ologiom anwa?” ");
INSERT INTO mgj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ya̠a̠, A̠zizo̠s aro̠ b̠u̠b̠o̠m. Sa̠ we̠mu̠ rokur bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ami̠ na̠ a̠bhin d̠a̠ a̠d̠ien ta̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠, na̠ agba na̠ a̠nigha̠ nyam ma̠a̠: Sibhigha̠ ku̠gba ma̠ anwa Akrai̠st O̠nyi̠ ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Anwa na̠ agu̠o̠ na̠ agba a̠mutiom. O̠ku̠a eka̠, Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, obhin i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, inyin ta̠ o̠bi̠gh O̠nyi̠ ta̠ O̠ni̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ a̠limon ka̠ na̠ a̠ru d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sa̠ we̠mu̠ rokur bho̠ ago̠go̠i̠ny ibura̠ d̠o̠yo̠ a̠fugh ma̠a̠, “I̠na na̠ a̠fugh a̠fugh i̠basi̠ a̠gboloma̠ ma̱ A̠zib̠a̠! Ta̠ odin ere o̠bho̠ro̠ghan opa̠n onyob̠a̠? I̠bi̠ghe̠ ma̠ agu̠o̠ i̠na na̠ a̠fugh a̠fugh i̠basi̠ a̠gboloma̠ ma̱ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Inyin u̠bi̠gh eka̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “I̠na na̠ api̠o̠gho̠m, akpe̠ ma̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sa̠ awa i̠si̠ro̠gho̠m i̠na ma̠ i̠gho̠r d̠a̠ a̠misigh, sa̠ igorogh i̠na, sa̠ ipa̠n a̠nwunom i̠b̠abhagh i̠na, ");
INSERT INTO mgj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ifugh ma̠a̠, “Akrai̠st! Wa̠ ma̠ a̠nigha̠ i̠yar o̠ni̠ wa̠ a̠gor anwa bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","I̠se̠n A̠pita̠ aro̠ ma̠ a̠dila̠de d̠a̠ etire d̠a̠ ologi ogigo bho̠, sa̠ odi ob̠a̠ra̠motu o̠nyani̠ a̠ru ra̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Anwa odi o̠ni̠ wa̠ i̠ro̠ ani̠ na̠ A̠zizo̠s wa̠ Agalili bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ya̠a̠, i̠na aku̠a d̠a̠ esa̠d̠io ta̠ eb̠la̠ awa, sa̠ a̠fugh ma̠a̠, “Ami̠ iloghom d̠o̠ ma̠ abar wa̠ anwa na̠ agba bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sa̠ i̠na ad̠u̠a agi̠ d̠a̠ o̠nu̠ ogigo bho̠, sa̠ opa̠n o̠ni̠ abi̠gh i̠na, sa̠ agba a̠nigha̠ ma̠ ogbo ya̠ od̠i ma̠ i̠se̠ bho̠ ma̠a̠, “Onon odi o̠ni̠ wa̠ a̠rilogha̠n A̠zizo̠s wa̠ Anazare̠t bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sa̠ i̠na a̠puta̠ aku̠a, a̠sibhigha̠ ma̠a̠: “Ami̠ iloghom d̠o̠ ma̠ o̠ni̠ bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","O̠nyi̠ obhel a̠ten, sa̠ ogbo ya̠ i̠mara ma̠ i̠se̠ bho̠ iru ra̠ i̠te̠i̠ A̠pita̠, sa̠ i̠gba inigha̠ i̠na ma̠a̠, “Ya̠gia̠ga̠i, anwa odi o̠ni̠ awa nyen, ezin bho̠ a̠nem d̠oyom na̠ agba nyam na̠ a̠mutiom.” ");
INSERT INTO mgj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","O̠ku̠a sa̠ i̠na ake̠ ma̠ ogurugia̠n, o̠ghad̠i̠an ma̠a̠, “Ami̠ iloghom d̠o̠ ma̠ o̠ni̠ bho̠!” Ogbo na̠ onin sa̠ olobhiri e̠nu̠r alal. ");
INSERT INTO mgj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sa̠ A̠pita̠ aru̠ru̠an iwowa̠ ta̠ A̠zizo̠s wa̠ a̠wa̠ ma̠a̠, “Kisa̠ olobhiri e̠nu̠r ta̠ alal, anwa ta̠ aku̠a ami̠ i̠sar igiel, ma̠a̠ anwa na̠ a̠loghom d̠o̠ ami̠.” Sa̠ i̠na a̠rile a̠mite d̠a̠ ogigo bho̠ ka̠ a̠leghe agba ma̠ igbir. ");
INSERT INTO mgj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ame̠ghe̠le̠, sa̠ eb̠la̠ ogbo aru̠mu̠ rokur bho̠ na̠ ikei bho̠, ikokod̠ia̠n imimia̠n iya̠ ogir ogboloma̠ A̠zizo̠s, ma̠ agu̠o̠ ola̠ ta̠ osobh ase̠ obhumeni o̠yo̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sa̠ awa i̠bhad̠i̠ i̠na ibhin i̠gi̠o̠m Apai̠let we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Igiel bho̠ A̠zuda̠s wa̠ a̠wol i̠na bho̠ abi̠gh ma̠ na̠ osobh ase̠ obhumeni ma̠ A̠zizo̠s bho̠, sa̠ a̠loghoma̠n ma̠ i̠na na̠ a̠gir api̠e̠. Sa̠ a̠mulumeni ma̠ a̠d̠usubh na̠ d̠iobh ikpoki a̠silva̠ bho̠ agi̠o̠m we̠mu̠ rokur bho̠ na̠ ikei bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","agba ma̠a̠, “Ami̠ na̠ a̠gir i̠karabh, a̠wol o̠ni̠ ola̠ o̠pi̠o̠gho̠m d̠o̠, a̠d̠ighi ma̠ ola̠ uzu ma̠ asi̠ d̠o̠yo̠.” Sa̠ awa i̠wo̠ran ma̠a̠, “Ere a̠gboloma̠ i̠yar? Anwa ku kpone ma̠ a̠d̠ighom.” ");
INSERT INTO mgj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sa̠ i̠na a̠zu ma̠ ikpoki bho̠ d̠a̠ otu ta̠ A̠zib̠a̠ sa̠ a̠ten ad̠u̠a ka̠ akpo̠ a̠sina̠ a̠mugh. ");
INSERT INTO mgj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ya̠a̠ ogbo aru̠mu̠ rokur bho̠ ikpokpo ma̠ ikpoki bho̠ e̠gba ma̠a̠, “Na̠ osora̠n d̠o̠ ma̠ obhin ka̠ o̠lo̠gh d̠a̠ esi wa̠ na̠ okoko ma̠ ikpoki bho̠, agu̠o̠ i̠ro̠ ma̠ ikpoki ogigha̠n o̠ni̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","O̠ku̠a sa̠ i̠mu̠gho̠nyan obhin ikpoki bho̠ ka̠ ogho a̠de ta̠ ob̠olob̠ol ma̠ i̠di̠ar bho̠, ma̠ agu̠o̠ ola̠ obhin otenemeni o̠karabh esi ola̠ od̠i risuloma̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ebula̠ o̠ku̠a, obhin obhel obha̠ ra̠ o̠te̠i̠ a̠didon, na̠ obhelegi ma̠ a̠de obha̠, ma̠a̠, “A̠de Asi̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","D̠a̠ obhel obha̠ sa̠ umuzoghod̠iom iwowa̠ wa̠ owil A̠zerimaya a̠wa̠ bho̠ ma̠a̠: “Sa̠ awa ibhin a̠d̠usubh na̠ d̠iobh ikpoki a̠silva̠ bho̠, ikpoki e̠mu̠ o̠ni̠ wa̠ anwi̠i̠ny Izre̠l ima̠ra̠ ma̠ awa ta̠ o̠kpe̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Sa̠ awa ibhin ikpoki bho̠ igho ma̠ a̠de ta̠ ob̠olob̠ol ma̠ i̠di̠ar bho̠, agu̠o̠ Wa̠nwuna̠ a̠ruom ami̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","I̠se̠ sa̠ ibhin A̠zizo̠s ka̠ i̠marame̠ni̠ d̠a̠ a̠misigh ta̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠, sa̠ i̠na a̠pura̠n A̠zizo̠s ma̠a̠, “Anwa o̠li̠le̠ma ogbo A̠zu bho̠ ke̠re̠?” Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Anwa na̠ agba aman.” ");
INSERT INTO mgj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ ikei bho̠ ikpon abarabar ib̠ologiom i̠na, ya̠a̠ i̠na na̠ o̠wo̠ran d̠o̠ ma̠ abar. ");
INSERT INTO mgj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ebula̠ o̠ku̠a, sa̠ Apai̠let a̠pura̠n i̠na ma̠a̠, “Anwa na̠ o̠mu̠gho̠n d̠o̠ ma̠ ya̠ na̠ o̠gba na̠ ob̠ologiom anwa bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ya̠a̠ i̠na na̠ o̠wo̠ran d̠o̠, bebina̠ abar, sa̠ a̠d̠igh ilologia̠n ibom ma̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I̠se̠n d̠a̠ e̠yal bho̠, bha̠ obhel wa̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠ na̠ a̠mutiomgha̠n o̠ni̠ d̠a̠ ikoli ola̠ a̠nwunom bho̠ ipuru. ");
INSERT INTO mgj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","D̠a̠ obhel obha̠, bha̠ odi obom od̠ighi ma̠ i̠karabh ola̠ ubhelegi ma̠a̠ A̠zizo̠s Abarabas aro̠ d̠a̠ ikoli. ");
INSERT INTO mgj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","D̠a̠ obhel bho̠ a̠nwunom bho̠ na̠ ekokod̠ia̠n bho̠, sa̠ Apai̠let a̠pura̠n ma̠a̠, “Inyin na̠ o̠bho̠ro̠ghan ami̠ ma̠ imutiom oken d̠a̠ i̠wal awa onigha̠ inyin: A̠zizo̠s Abarabas, bo̠d̠o̠ ka̠ A̠zizo̠s wa̠ ubhelegi ma̠ Akrai̠st bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ezin bho̠ i̠na a̠loghom ma̠a̠ awa ibhin d̠a̠ egbugbo ologi eb̠eton A̠zizo̠s Akrai̠st enigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Agu̠o̠ i̠na aro̠ ma̠ a̠dila̠de d̠a̠ i̠kasi̠ osobh ase̠ bho̠, sa̠ ani̠ d̠o̠yo̠ a̠ruom a̠duom agi̠o̠m i̠na ma̠a̠, “Ko ogir abar a̠gboloma̠ ma̠ o̠ni̠ wa̠ o̠pi̠o̠m d̠o̠ ma̠ abar bho̠. Ezin bho̠, ami̠ i̠bigh ibom ali̠gam a̠ruzu d̠a̠ amala ma̠ a̠didon d̠a̠ ebula̠ o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ya̠a̠ ogbo aru̠mu̠ rokur bho̠ na̠ ikei bho̠ itumugiom o̠lo̠gh a̠nwunom bho̠ ma̠ epuru ku ma̠ Abarabas, ya̠a̠ ogigh A̠zizo̠s Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sa̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠ a̠pura̠n awa ma̠a̠, “D̠a̠ i̠wal awa ka̠ ami̠ imutiom oken inigha̠ inyin?” Sa̠ awa i̠wo̠ran ma̠a̠, “Abarabas.” ");
INSERT INTO mgj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sa̠ Apai̠let a̠pura̠n awa ma̠a̠, “O̠ku̠a ka̠ ogir ere ogboloma̠ ma̠ A̠zizo̠s wa̠ ubhelegi ma̠ Akrai̠st bho̠?” Sa̠ eb̠la̠ awa i̠wo̠ran ma̠a̠, “Du̠e̠ ma̠ a̠gigh!” ");
INSERT INTO mgj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere, a̠gir a̠kere a̠d̠ien i̠karabh?” Sa̠ imula̠ i̠lo̠gh e̠mi̠ imulughu ma̠a̠, “Du̠e̠ ma̠ a̠gigh!” ");
INSERT INTO mgj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ya̠ Apai̠let a̠loghoma̠n ma̠ abar ola̠ i̠na ta̠ a̠rue a̠gir alo̠gh bo̠ bho̠, kpe̠le̠me̠ni̠ bha̠ a̠nwunom bho̠ na̠ e̠ko̠ro̠, sa̠ a̠bhin amu̠m a̠tita̠la̠ ma̠ aru̠gu̠o̠ d̠o̠yo̠ abhe̠bhi̠la d̠a̠ a̠misigh eb̠la̠ o̠lo̠gh a̠nwunom bho̠ agba ma̠a̠, “Ami̠ id̠igh ani̠ d̠o̠ d̠a̠ o̠kpe̠ ogigha̠n o̠ni̠ onon. Inyin na̠ agu̠o̠ ka̠ ekpon ed̠ighom!” ");
INSERT INTO mgj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sa̠ eb̠la̠ a̠nwunom bho̠ i̠wo̠ran ma̠a̠, “Asi̠ d̠o̠yo̠ e̠ro̠ d̠a̠ e̠mu̠ d̠i̠yar na̠ ranwi̠i̠ny d̠a̠ i̠yar!” ");
INSERT INTO mgj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","O̠ku̠a, sa̠ i̠na a̠mutiom Abarabas a̠nigha̠ awa, ya̠a̠ A̠zizo̠s, sa̠ i̠na a̠nigha̠ awa ma̠ o̠gu̠ro̠gh na̠ o̠du̠ o̠yo̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sa̠ ogbo e̠gham ta̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠ ibhin A̠zizo̠s i̠gi̠ d̠a̠ otu ta̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠ sa̠ ikokod̠i ma̠ eb̠la̠ ogbo e̠gham bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sa̠ i̠ko̠gi̠o̠n ibura̠ d̠o̠yo̠ i̠lo̠gi̠ i̠na ma̠ obom akapa ododo, ");
INSERT INTO mgj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","sa̠ ilo ma̠ eghoi ib̠ub̠ulom izuom e̠mu̠ d̠o̠yo̠, sa̠ i̠lo̠gh okpeti i̠ki̠ani̠ d̠a̠ od̠iom agu̠o̠ d̠o̠yo̠ sa̠ ikpuluma̠n d̠a̠ a̠misigh d̠o̠yo̠ iduom i̠na ma̠a̠, “E O̠li̠le̠ma A̠zu, i̠yar na̠ okpud̠ia̠n o!” ");
INSERT INTO mgj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sa̠ i̠si̠ro̠gho̠m i̠na ma̠ i̠gho̠r, sa̠ ibhin okpeti i̠ki̠ani̠ bho̠ ib̠orogh e̠mu̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sa̠ igiel bho̠ awa na̠ eduom i̠na e̠we̠le̠ bho̠, sa̠ i̠ko̠gi̠o̠n ibura̠ ododo ya̠ awa i̠lo̠gi̠ i̠na bho̠, sa̠ inwe i̠lo̠gi̠ i̠na ma̠ ibura̠ d̠o̠yo̠, sa̠ ibhin i̠na i̠d̠u̠a ma̠ agu̠o̠ ola̠ ka̠ o̠du̠ o̠yo̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Agu̠o̠ awa na̠ emite bho̠, sa̠ awa i̠manana ma̠ o̠ni̠ A̠sirin ola̠ ubhelegi ma̠ Asai̠mo̠n, sa̠ iponoma̠ i̠na ma̠ orol e̠mi̠gi̠re̠ni̠an oriren ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sa̠ i̠gi̠ ka̠ imisi ma̠ esi ola̠ ubhelegi ma̠a̠ Ago̠lgo̠ta, (a̠ma̠ra̠ ma̠a̠, “Esi okpokpo e̠mu̠.”) ");
INSERT INTO mgj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sa̠ awa inigha̠ i̠na ma̠ a̠min ya̠ u̠gu̠a na̠ a̠non; ya̠a̠ igiel bho̠ i̠na ad̠e̠d̠i̠ma bho̠, sa̠ i̠na a̠gin o̠d̠a. ");
INSERT INTO mgj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sa̠ awa i̠du̠ i̠na, sa̠ irobh okob̠a̠ ibhin i̠ru̠gi̠an ibura̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sa̠ awa i̠ro̠ ma̠ i̠se̠ ma̠ a̠dila̠de igon i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa̠ awa i̠ge̠ ma̠ iku wa̠ i̠gba igboloma̠ i̠na bho̠, i̠ke̠ri̠ d̠a̠ anyu̠ d̠o̠yo̠ ma̠a̠: ONON A̠ZIZO̠S, O̠LI̠LE̠MA A̠ZU BHO̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Igiel bho̠ awa i̠du̠ i̠na bho̠, i̠du̠ na̠ i̠wal aru̠gba, odi d̠a̠ od̠iom agba d̠o̠yo̠ ya̠a̠ uwed̠i d̠a̠ okiel. ");
INSERT INTO mgj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sa̠ ogbo ya̠ na̠ eten bho̠ i̠ki̠ri̠ i̠na inyegi ma̠ aru̠mu̠ d̠awa ");
INSERT INTO mgj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ifugh ma̠a̠, “Anwa wa̠ ta̠ a̠rue a̠b̠ogion otu ta̠ A̠zib̠a̠, sa̠ ta̠ a̠mula̠ a̠lo amado̠n d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠ bho̠, tenemeni ma̠ ozu d̠oyom, agu̠o̠ anwa i̠ro̠ ma̠ O̠nyi̠ ta̠ A̠zib̠a̠ bho̠, bha̠ sore ma̠ a̠ru d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Onin agu̠o̠ bho̠ ogbo aru̠mu̠ rokur bho̠, na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠, na̠ ikei bho̠ iduom i̠na nyen efugh ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I̠na na̠ a̠tenemeni ma̠ ipa̠n ogbo, ya̠a̠ na̠ orue d̠o̠ ma̠ otenemeni ozu d̠o̠yo̠! O̠li̠le̠ma Izre̠l! I̠se̠n sore d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ ma̠ a̠ru, sa̠ i̠yar ta̠ oma̠ra̠ nyam. ");
INSERT INTO mgj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I̠na a̠ma̠ra̠ ma̠ A̠zib̠a̠, na̠ a̠lei A̠zib̠a̠ a̠tenemeni i̠na ma̠ i̠se̠n, ku̠gba ma̠ i̠na ta̠ a̠ma̠ra̠! Ezin bho̠ i̠na agba ma̠a̠, ‘Ami̠ O̠nyi̠ ta̠ A̠zib̠a̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sa̠ aru̠gba ya̠ u̠du̠gi̠ d̠a̠ aka ta̠ A̠zizo̠s ma̠ o̠ze̠gi̠ bho̠ eka̠ erogi i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Obeton d̠a̠ obhel wa̠ o̠wal ma̠ obhel bho̠ ate̠i̠ d̠a̠ d̠iobh na̠ i̠wal d̠a̠ e̠sala̠d̠io ka̠ o̠te̠i̠ d̠a̠ i̠sar d̠a̠ etita̠n, sa̠ azi̠m a̠kpegiom eb̠la̠ e̠mara̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sa̠ agu̠o̠ o̠wal ma̠ obhel bho̠ ate̠i̠ d̠a̠ i̠sar d̠a̠ etita̠n, sa̠ A̠zizo̠s a̠mulughu na̠ obom okoroko ma̠a̠, “E̠lai̠, E̠lai̠,lama sabaktani̠?” (onon a̠ma̠ra̠ ma̠a̠, “A̠zib̠a̠ d̠ami̠, A̠zib̠a̠ d̠ami̠, ere wa̠ Anwa na̠ awe̠le̠man ami̠ bho̠?”) ");
INSERT INTO mgj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sa̠ idi awa ya̠ i̠mara ma̠ i̠se̠ bho̠ i̠gba ma̠a̠, “Na̠ a̠bhelegi ma̠ I̠lai̠za.” ");
INSERT INTO mgj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","D̠a̠ ogbo na̠ onin, sa̠ odi awa a̠kpo ma̠ eghil ka̠ a̠bhin asapu̠ ato̠ri̠ d̠a̠ igheghed̠um a̠min, sa̠ akpu̠o̠m d̠a̠ okpeti a̠b̠eton a̠nigha̠ i̠na ma̠ o̠d̠a. ");
INSERT INTO mgj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ya̠a̠ ipa̠n ogbo ifugh ma̠a̠, “I̠we̠le̠, ta̠ o̠bi̠gh ka̠ I̠lai̠za ta̠ a̠ru ra̠ a̠tenemeni i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sa̠ A̠zizo̠s a̠nwe a̠mulughu na̠ obom okoroko, sa̠ ekpo epobh bho̠ a̠sobha̠n. ");
INSERT INTO mgj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sa̠ ukpe wa̠ ubhin usobhom a̠lukpesi e̠tu̠tu̠ d̠a̠ otu ta̠ A̠zib̠a̠ bho̠ a̠b̠eton d̠a̠ eb̠o bho̠ agu̠an a̠sor aru̠gi̠an i̠wal a̠bin, sa̠ a̠de bho̠ a̠nyegia̠n, sa̠ ra̠de o̠gbi̠o̠ma bho̠ ib̠ob̠omia̠n i̠saragi̠an. ");
INSERT INTO mgj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sa̠ ranyu̠ od̠i bho̠ ikpegina̠ sa̠ a̠d̠izo imumugh ya̠ i̠ro̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ ib̠egina̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sa̠ awa imiteghu d̠a̠ a̠rugugua̠ a̠ma̠d̠i bho̠, i̠gi̠ ka̠ imutuma̠ ma̠ a̠d̠izo a̠nwunom d̠a̠ E̠ma E̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sa̠ igiel bho̠ we̠mu̠ ogbo e̠gham bho̠, na̠ ogbo ya̠ od̠i na̠ i̠na na̠ egon A̠zizo̠s bho̠, i̠bi̠gh agu̠o̠ a̠de bho̠ a̠nyegia̠n a̠b̠obomia̠n a̠d̠igh bho̠, na̠ i̠di̠ar ya̠ imite bho̠, sa̠ ibom a̠rugugu isibh awa, sa̠ i̠gba ma̠a̠, “Ya̠gia̠ga̠i, onon O̠nyi̠ ta̠ A̠zib̠a̠!” ");
INSERT INTO mgj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A̠d̠izo anwani̠ ya̠ i̠tu̠o̠no̠mghan A̠zizo̠s igir ogir inigha̠ i̠na bho̠, ob̠eton d̠a̠ Agalili, i̠ro̠ ani̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Idi awa bha̠, A̠meri wa̠ Amagdala bho̠, A̠meri oweni ta̠ A̠zemsi na̠ A̠zose̠fu̠, na̠ oweni anwi̠i̠ny ta̠ Aze̠bidi. ");
INSERT INTO mgj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Agu̠o̠ ate̠i̠ a̠dule bho̠, sa̠ o̠li̠la ola̠ Ari̠mati̠a ola̠ ubhelegi ma̠ A̠zose̠fu̠, ola̠ ra̠ a̠ten ani̠ ma̠ o̠ni̠ atu̠ghan ta̠ A̠zizo̠s a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I̠na agi̠ d̠a̠ Apai̠let ka̠ a̠puru ma̠ ozu ta̠ A̠zizo̠s, sa̠ Apai̠let a̠ruom ma̠ enigha̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sa̠ A̠zose̠fu̠ a̠bhin omom ukpe asi̠ni̠ni̠n ola̠ amar ab̠ab̠ala a̠bhurugi ma̠ egua̠de bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sa̠ a̠d̠i d̠a̠ omom od̠i ola̠ o̠yo̠, ola̠ i̠na a̠b̠u a̠mutiom d̠a̠ a̠de o̠gbi̠o̠ma ola̠ od̠i d̠a̠ anyu̠, sa̠ i̠na a̠kiligi ma̠ obom o̠pad̠i̠ o̠gbi̠o̠ma a̠kpegiom o̠nu̠ od̠i bho̠ sa̠ a̠ten ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sa̠ A̠meri wa̠ Amagdala bho̠ na̠ A̠meri uwed̠i bho̠ i̠ro̠ ma̠ a̠dila̠de isumogha̠n od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","I̠b̠ala bho̠, wa̠ aro̠ ma̠ A̠d̠a̠ma̠ Osira̠ Epobh bho̠, sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ Rafarisi bho̠ i̠gi̠ d̠a̠ Apai̠let, ");
INSERT INTO mgj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ka̠ i̠gba ma̠a̠, “We̠mu̠, ru̠ru̠ane̠ ma̠ abar wa̠ o̠ni̠ igelemeni bho̠ agba ma̠ igiel wa̠ i̠na od̠id̠ia̠ d̠a̠ a̠ghud̠um bho̠ ma̠a̠, ‘Ka̠ i̠sar a̠d̠a̠ma̠ iten, ami̠ ta̠ a̠b̠etina̠ d̠a̠ omugh.’ ");
INSERT INTO mgj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ebula̠ o̠ku̠a, ruome ma̠ agu̠o̠ ola̠ awa ta̠ e̠gi̠ ka̠ e̠mar ekponom od̠i bho̠ tu̠tu̠n d̠a̠ oleghemeni i̠sar a̠d̠a̠ma̠ bho̠, ma̠ agu̠o̠ ola̠ ogbo atu̠ghan d̠o̠yo̠ ka̠ o̠gi̠ d̠o̠ ka̠ eb̠igh e̠si̠ghe̠, sa̠ ta̠ e̠gba a̠nigha̠ ma̠ a̠nwunom bho̠ ma̠ na̠ a̠b̠etina̠ d̠a̠ omugh, sa̠ igelemeni wa̠ o̠gu̠man bho̠ ta̠ a̠gurom a̠pu ma̠ o̠pu̠r bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sa̠ Apai̠let agba a̠nigha̠ awa ma̠a̠, “Ibhine ma̠ ogbo e̠gham ma̠ e̠gi̠ ka̠ ekponom, i̠gi̠e̠ ka̠ ekponom agu̠o̠ inyin uloghom obhin okponom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sa̠ awa i̠gi̠ ka̠ i̠mar i̠lo̠ ma̠ od̠i bho̠ igir, sa̠ i̠lo̠gh elegh a̠dila̠de i̠to̠ ebhugh, sa̠ iguri ma̠ ogbo e̠gham ma̠ o̠ro̠ okponom. ");
INSERT INTO mgj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","A̠d̠a̠ma̠ Osira̠ Epobh bho̠ a̠ten, agu̠o̠ na̠ a̠nyiroghom o̠b̠al d̠a̠ o̠pu̠r a̠d̠a̠ma̠ esi a̠d̠a̠ma̠ bho̠, sa̠ A̠meri wa̠ Amagdala bho̠ na̠ A̠meri uwed̠i i̠gi̠ ka̠ okpon anyu̠ od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","D̠a̠ awai̠, sa̠ a̠de bho̠ a̠nyegia̠n ibom, ezin bho̠ otileduom ta̠ Wa̠nwuna̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠sor a̠ru ra̠ a̠kiligi ma̠ o̠pad̠i̠ o̠gbe̠o̠ma bho̠ a̠guri d̠a̠ aka, sa̠ aro̠ ma̠ a̠dila̠de d̠a̠ anyu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","I̠na a̠mite awar agu̠o̠ i̠me̠me̠gi̠na agbararan, sa̠ ibura̠ d̠o̠yo̠ ab̠al agu̠o̠ ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ebula̠ agu̠o̠ ogbo ya̠ na̠ ekponom esi bho̠, ighil a̠rugugu ka̠ e̠te̠i̠ esi ola̠, awa ibhin igiri imugh onyinye. ");
INSERT INTO mgj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ya̠a̠, otileduom ta̠ A̠zib̠a̠ bho̠ agba a̠nigha̠ ma̠ anwani̠ bho̠ ma̠a̠, “O̠ni̠ ko oghil a̠rugugu, ami̠ a̠loghom ma̠ inyin uru ra̠ okpon A̠zizo̠s wa̠ o̠du̠ ugigh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I̠na bo̠ ma̠ i̠se̠n, i̠na na̠ a̠b̠etina̠ ma̠ agu̠o̠ agba bho̠. Itue ra̠ e̠bi̠gh esi wa̠ uselegi i̠na bho̠, ");
INSERT INTO mgj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ma̠ e̠nu̠r e̠gi̠ ka̠ e̠gba ma̠ enigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠: ‘I̠na na̠ a̠b̠etina̠ d̠a̠ omugh, na̠ agi̠ d̠a̠ Agalili ka̠ ob̠a̠ra̠ inyin. Obha̠ esi wa̠ inyin ta̠ o̠bi̠gh i̠na bho̠.’ I̠nagha, ami̠ na̠ agba na̠ a̠nigha̠ inyin!” ");
INSERT INTO mgj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sa̠ awa inugia̠n i̠d̠u̠a d̠a̠ od̠i bho̠ na̠ a̠rugugu na̠ ibom a̠libhon ologi, sa̠ ikpo ma̠ eghil ka̠ o̠gba onigha̠ ogbo atu̠ghan d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sa̠ A̠zizo̠s a̠mutuma̠ awa a̠fugh ma̠a̠, “Ami̠ a̠bheleguma̠ o!” Sa̠ awa iru ra̠ i̠te̠i̠ i̠na ighinigia̠n a̠sike d̠o̠yo̠ ibuom i̠na. ");
INSERT INTO mgj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ko oghil a̠rugugu. I̠gi̠e̠ ka̠ e̠gba ma̠ enigha̠ ma̠ a̠rumor d̠ami̠ ma̠a̠, ami̠ na̠ agi̠ d̠a̠ Agalili, awa ta̠ e̠bi̠gh ami̠ ma̠ ebha̠.” ");
INSERT INTO mgj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Igiel bho̠ anwani̠ bho̠ na̠ e̠d̠u̠a bho̠, sa̠ idi ogbo ikponom bho̠ id̠igh d̠a̠ e̠ma bho̠ ka̠ i̠gba ma̠ eb̠la̠ i̠di̠ar ya̠ imite bho̠ inigha̠ ma̠ ogbo aru̠mu̠ rokur bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sa̠ ogbo aru̠mu̠ rokur bho̠ imimia̠n na̠ ikei bho̠, sa̠ inigha̠ ma̠ ogbo e̠gham bho̠ ma̠ ikpoki ya̠ i̠mo̠mo̠nya, ");
INSERT INTO mgj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","sa̠ i̠gba inigha̠ awa ma̠a̠, “Inyin ta̠ ogba ma̠a̠, ‘Ogbo atu̠ghan d̠o̠yo̠ iru ma̠ a̠d̠ugula̠n ra̠ eb̠igh i̠na e̠si̠ghe̠, ma̠ obhel ola̠ i̠yar na̠ okod̠u.’ ");
INSERT INTO mgj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ku̠gba ma̠a̠, asu̠gbagba i̠nye̠n ed̠igh d̠a̠ a̠to ta̠ we̠mu̠ a̠dila̠de i̠to̠ ebhugh bho̠, i̠yar ta̠ ob̠okumeni ma̠ ologi d̠o̠yo̠ b̠o̠ka̠ inyin ud̠igh d̠a̠ ali̠gam a̠ruzu.” ");
INSERT INTO mgj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sa̠ awa ibhin ikpoki bho̠ igir agu̠o̠ uruom awa bho̠. A̠nwunom A̠zu od̠id̠ia̠ na̠ e̠gba ma̠ asu̠gbagba i̠nye̠n na̠ e̠sasaragi̠ tu̠tu̠n ka̠ a̠didon. ");
INSERT INTO mgj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sa̠ d̠iobh na̠ onin ogbo ogir bho̠ i̠gi̠ d̠a̠ igu d̠a̠ Agalili, d̠a̠ esi wa̠ A̠zizo̠s a̠ruom awa ma̠ o̠gi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Igiel bho̠ awa i̠bi̠gh i̠na bho̠, sa̠ ibuom i̠na, ya̠a̠ idi awa ima̠ra̠ d̠o̠ ma̠ i̠na A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sa̠ A̠zizo̠s a̠d̠ighoma̠ awa agba ma̠a̠, “Na̠ onigha̠ ami̠ ma̠ eb̠la̠ a̠limon d̠a̠ a̠de na̠ iya̠ d̠a̠ e̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠gi̠e̠ ka̠ egir agu̠o̠ ola̠ a̠nwunom ta̠ eten ogbo atu̠ghan d̠ami̠ d̠a̠ eb̠la̠ ra̠dede, ma̠ ewur awa ma̠ amu̠m d̠a̠ a̠d̠ien ta̠ O̠we̠de̠ bho̠, na̠ O̠nyi̠ bho̠, na̠ E̠mu̠gh E̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","I̠tu̠ghu̠me̠ni̠ awa ma̠ osibh ogir eb̠la̠ i̠di̠ar ya̠ ami̠ iruom inyin ogir bho̠. Iloghome ma̠a̠, ami̠ od̠i na̠ inyin kigiel kigiel tu̠tu̠n d̠a̠ ekunuguma̠ e̠mara̠nwunom bho̠.”");
INSERT INTO mgj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Onon agu̠o̠ Ib̠eb̠i Asu̠gbagba ya̠ igboloma̠ ma̠ A̠zizo̠s Akrai̠st o̠nyi̠ ta̠ A̠zib̠a̠ a̠bhin ake̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","D̠a̠ agu̠o̠ u̠ge̠ d̠a̠ a̠d̠ire ta̠ owil Ai̠zaya bho̠ ma̠a̠: “Nagha o! Ami̠ ta̠ a̠bhin a̠dila̠de i̠to̠ d̠ami̠ a̠ruom o̠ni̠ a̠duom, ma̠ o̠tu̠ghu̠man eten bho̠ ob̠a̠ra̠ oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Okoroko na̠ a̠si na̠ a̠mite d̠a̠ e̠sala a̠de i̠si̠sar bho̠, ma̠a̠, ‘I̠tu̠ghu̠mane̠ ma̠ eten bho̠ ma̠ esisia̠n Wa̠nwuna̠ bho̠, ma̠ eselegi ma̠ reten bho̠.’” ");
INSERT INTO mgj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sa̠ Azo̠n owurmamu̠m bho̠ a̠mite d̠a̠ e̠sala a̠de i̠si̠sar bho̠, sa̠ agba ma̠a̠, a̠nwunom etiba̠ra̠ d̠a̠ i̠karabh d̠awa ewura̠ ma̠ amu̠m, sa̠ A̠zib̠a̠ ta̠ awe̠le̠man i̠karabh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sa̠ eb̠la̠ ebhugh A̠zudia̠ sekina̠ a̠nwunom A̠zeruse̠le̠m id̠u i̠gi̠ do̠yo̠. Sa̠ awa i̠gba ma̠ i̠karabh d̠awa imutiom, sa̠ i̠na a̠wur awa ma̠ amu̠m d̠a̠ o̠bhi̠i̠y Azo̠dan. ");
INSERT INTO mgj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Azo̠n a̠bura̠ ma̠ ibura̠ ya̠ ubhin ipur e̠nam-a̠dol u̠le̠m, sa̠ i̠na akpo̠aghan o̠kara ozu e̠nam d̠a̠ eka̠ka̠gh d̠o̠yo̠. Ed̠ia̠n d̠o̠yo̠ bha̠ i̠ganw na̠ ame̠ ya̠ od̠id̠ia̠ d̠a̠ aparapa. ");
INSERT INTO mgj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sa̠ Azo̠n agba ma̠a̠, “O̠ni̠ wa̠ na̠ a̠ru d̠a̠ aman d̠ami̠ bho̠ abu̠gh a̠pu ami̠, ya̠a̠ ami̠ ilei d̠o̠ ma̠ o̠ni̠ ola̠ ozuma̠n o̠ko̠gi̠o̠n id̠id̠igh ragbaka do̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ami̠ na̠ a̠bhin amu̠m na̠ a̠wur inyin, ya̠a̠, i̠na ta̠ a̠bhin E̠mu̠gh E̠tu̠tu̠ bho̠ a̠wur inyin.” ");
INSERT INTO mgj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","D̠a̠ obhel obha̠, a̠zuzua̠n ola̠ A̠zizo̠s ad̠u̠a d̠a̠ Anazare̠t d̠a̠ ebhugh Agalili ka̠ ate̠i̠ Azo̠n. Sa̠ Azo̠n a̠wur i̠na ma̠ amu̠m d̠a̠ o̠bhi̠i̠y Azo̠dan. ");
INSERT INTO mgj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Agu̠o̠ A̠zizo̠s na̠ a̠bhun bho̠ sa̠ i̠na abi̠gh ka̠ ote̠nai̠ny bho̠ a̠gurona̠, sa̠ E̠mu̠gh ta̠ A̠zib̠a̠ a̠sor ra̠ akpasan i̠na ma̠ agu̠o̠ okur osege. ");
INSERT INTO mgj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa̠ okoroko a̠si a̠mite d̠a̠ ote̠nai̠ny ma̠a̠: “Anwa o̠nyi̠ d̠ami̠, wa̠ ami̠ itula̠n ibom bho̠, wa̠ ologi d̠ami̠ na̠ a̠bhon na̠ a̠ni̠gha̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","D̠a̠ onin obhel obha̠ sa̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠rileghom i̠na ka̠ a̠d̠ighom d̠a̠ e̠sala a̠de i̠si̠sar. ");
INSERT INTO mgj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I̠na aro̠ ma̠ i̠se̠ d̠a̠ e̠sala a̠de i̠si̠sar bho̠ ma̠ eruba̠l ra̠d̠a̠ma̠, sa̠ Eru Bho̠ ad̠agi̠an i̠na. A̠zizo̠s aro̠ na̠ i̠nam ed̠um, sa̠ itileduom ta̠ A̠zib̠a̠ iru ra̠ i̠lo̠gh agu̠o̠ inigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Igiel bho̠ na̠ ob̠ol Azo̠n o̠lo̠gh d̠a̠ ikoli bho̠, sa̠ A̠zizo̠s agi̠ d̠a̠ Agalili ka̠ agba ma̠ ib̠eb̠i asu̠gbagba ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","sa̠ i̠na agba ma̠a̠, “Na̠ ate̠i̠ obhel wa̠ omuzoghod̠iom bho̠, i̠rileghom ta̠ A̠zib̠a̠ na̠ a̠tua̠n. Itiba̠ra̠ d̠a̠ i̠karabh, ma̠ ed̠umom ib̠eb̠i asu̠gbagba bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sa̠ A̠zizo̠s a̠rile agbal Abadi̠ Agalili, sa̠ abi̠gh i̠wal a̠rumor, Asai̠mo̠n na̠ Anduru umor d̠o̠yo̠ ka̠ awa na̠ erobh o̠gbo̠ d̠a̠ abadi̠ bho̠, ezin bho̠ awa i̠ku̠ ma̠ i̠ku̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “I̠tu̠o̠no̠me̠ Ami̠, sa̠ Ami̠ ta̠ a̠tenemeni inyin i̠ku̠ ma̠ i̠ku̠ a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","D̠a̠ onin obhel obha̠ sa̠ awa i̠we̠le̠man i̠gbo̠ d̠awa i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O̠d̠u̠a i̠se̠ o̠gi̠ d̠a̠ ed̠ia̠, sa̠ i̠na abi̠gh A̠zemsi o̠nyi̠ ta̠ Aze̠bidi na̠ Azo̠n umor d̠o̠yo̠ d̠a̠ ologi oghugh na̠ e̠tu̠ghu̠man i̠gbo̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ogbo na̠ onin sa̠ i̠na a̠bhelegi awa, sa̠ awa i̠we̠le̠ epa̠ ma̠ o̠we̠de̠ d̠awa Aze̠bidi d̠a̠ oghugh bho̠ na̠ ipa̠n ogbo ogir ya̠ awa i̠ko̠ bho̠ sa̠ i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Awa i̠gi̠ d̠a̠ Akapanu̠m, sa̠ ate̠i̠ A̠d̠a̠ma̠ Osira̠-epobh a̠nwunom A̠zu bho̠, sa̠ A̠zizo̠s a̠d̠igh d̠a̠ otu u̠gala A̠zu bho̠ aro̠ ma̠ i̠se̠ atu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ed̠igh ilologia̠n a̠nwunom o̠mu̠gho̠n atu̠ghu̠me̠ni d̠o̠yo̠, ezin bho̠ i̠na a̠bhin a̠dila̠de i̠to̠ agba ma̠ asu̠gbagba d̠o̠yo̠, i̠ro̠ d̠o̠ ma̠ agu̠o̠ ita̠ ogbo atu̠ghu̠me̠ni̠ roloko bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Odi o̠ni̠ ola̠ o̠karabh e̠mu̠gh na̠ a̠nyegi, aro̠ d̠a̠ ologi otu u̠gala bho̠, sa̠ i̠na a̠bhin obom okoroko a̠mulughu. Sa̠ a̠fugh ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Anwa na̠ i̠yar ka̠ unwuna̠ ma̠ ere, A̠zizo̠s Anazare̠t? Anwa na̠ a̠ru ra̠ o̠pi̠e̠gi̠ i̠yar o̠man ke̠re̠? I̠yar ologhom ma̠a̠ anwa We̠b̠ab̠ala wa̠ A̠zib̠a̠ a̠bhin a̠ru bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sa̠ A̠zizo̠s aghaghana i̠na ma̠a̠, “Ro̠ b̠o̠b̠o̠m! Mite d̠a̠ ozu d̠o̠yo̠!” ");
INSERT INTO mgj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sa̠ o̠karabh e̠mu̠gh bho̠ a̠teb̠eli i̠na, sa̠ i̠na asalaghu̠ a̠mulughu na̠ obom o̠kparakpar okoroko ad̠u̠a d̠a̠ ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa̠ abar bho̠ a̠d̠igh eb̠la̠ a̠nwunom bho̠ ma̠ ilologia̠n, sa̠ awa imogha̠, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “Woo, onon ka̠ a̠kere a̠d̠ien atu̠ghu̠me̠ni̠! I̠na na̠ a̠bhin d̠a̠ a̠dila̠de i̠to̠ na̠ aghaghana ma̠ i̠karabh aru̠mu̠gh, sa̠ awa na̠ e̠nagha i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","D̠a̠ onin obhel bho̠, sa̠ o̠du̠ ta̠ A̠zizo̠s asi̠saragi̠an ka̠ ate̠i̠ kesi kesi d̠a̠ ebhugh Agalili. ");
INSERT INTO mgj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Awa i̠d̠u̠a d̠a̠ otu u̠gala A̠zu bho̠, sa̠ A̠zizo̠s a̠bhin A̠zemsi̠ na̠ Azo̠n agi̠ d̠a̠ otu ta̠ Asai̠mo̠n na̠ Anduru. ");
INSERT INTO mgj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","D̠a̠ obhel bho̠ awa i̠gi̠ d̠a̠ otu ta̠ Asai̠mo̠n bho̠, sa̠ awa i̠bi̠gh o̠yo̠go̠-onweni ta̠ Asai̠mo̠n d̠a̠ e̠mana na̠ asu̠nwe̠r amu̠m o̠bhi̠i̠y na̠ a̠sibh i̠na, sa̠ awa i̠nu̠r i̠gba i̠nigha̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sa̠ A̠zizo̠s agi̠ ka̠ a̠sibh ani̠ bho̠ d̠a̠ agu̠o̠ a̠b̠eton, sa̠ amu̠m-o̠bhi̠i̠y bho̠ ad̠u̠a, sa̠ ani̠ bho̠ a̠d̠ighi ma̠ ed̠ia̠n aki̠o̠m awa. ");
INSERT INTO mgj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ate̠i̠ a̠dule d̠a̠ obhel ogogo bho̠ na̠ a̠d̠ugh, sa̠ awa ibhinogh eb̠la̠ ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ na̠ ogbo ya̠ i̠karabh aru̠mu̠gh na̠ enyegi iru d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa̠ eb̠la̠ e̠ma bho̠ ikokod̠ia̠n d̠a̠ a̠misigh otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sa̠ A̠zizo̠s a̠koko ma̠ a̠d̠izo ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ ma̠ a̠d̠ien kere kere asu̠nwe̠r bho̠ a̠d̠umeni, sa̠ i̠na a̠zegi ma̠ i̠karabh aru̠mu̠gh bho̠ asi̠ghe̠gi̠, ya̠ i̠na na̠ oma̠ra̠ d̠o̠ ma̠ i̠karabh aru̠mu̠gh bho̠ ma̠ ofugh abar, ezin bho̠ awa e̠mar eloghom ma̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","D̠a̠ ob̠om ame̠ghe̠le̠, sa̠ A̠zizo̠s ad̠u̠a d̠a̠ e̠ma bho̠ agi̠ ka̠ aro̠ d̠a̠ esi ola̠ od̠i kukunum a̠siseiny a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sa̠ Asai̠mo̠n na̠ a̠nwunom ya̠ i̠ro̠ na̠ i̠na bho̠ id̠igh o̠bho̠ro̠gh o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Igiel bho̠ awa i̠bi̠gh i̠na bho̠, sa̠ awa i̠gba inigha̠ i̠na ma̠a̠, “Ko̠ni̠ ko̠ni̠ na̠ o̠bho̠ro̠gh anwa.” ");
INSERT INTO mgj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sa̠ i̠na awo̠ran awa ma̠a̠, “Id̠ighi ta̠ oten o̠gi̠ d̠a̠ ipa̠n a̠risisi, d̠a̠ re̠ma iyed̠i ya̠ itua̠n bho̠, b̠o̠ka̠ ami̠ agba ani̠ ma̠ ib̠eb̠i asu̠gbagba bho̠ a̠nigha̠ awa. Ezin bho̠ ami̠ i̠tu̠n o̠ku̠a a̠ru.” ");
INSERT INTO mgj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sa̠ i̠na ad̠u̠a ma̠ e̠ma a̠ten e̠ma d̠a̠ eb̠la̠ ebhugh Agalili, agba ma̠ ib̠eb̠i asu̠gbagba bho̠ d̠a̠ a̠rutu u̠gala d̠awa, sa̠ a̠zegi ma̠ i̠karabh aru̠mu̠gh asi̠ghe̠ d̠a̠ a̠ruzu a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sa̠ o̠ni̠ ola̠ na̠ anwe̠r asu̠nwe̠r ekid̠igh a̠ru ra̠ a̠kpud̠ia̠n i̠na a̠fugh ma̠a̠: “Wa̠nwuna̠! Ku̠gba ma̠ anwa ta̠ a̠ma̠ra̠, bha̠ koko ami̠ ma̠ ab̠ab̠alame̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sa̠ igbirigbir o̠ni̠ bho̠ id̠ighi ma̠ A̠zizo̠s, sa̠ i̠na a̠selegheni ma̠ agu̠o̠ d̠o̠yo̠ a̠kula̠n i̠na a̠fugh ma̠a̠, “Ami̠ a̠ma̠ra̠. B̠ab̠ala!” ");
INSERT INTO mgj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sa̠ asu̠nwe̠r ekid̠igh bho̠ ad̠u̠a d̠a̠ ozu o̠ni̠ bho̠, sa̠ i̠na ab̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠ a̠ten a̠yel, sa̠ aghaghana i̠na ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Bi̠ghe̠! Ko o̠gba ma̠ a̠nigha̠ ma̠ o̠ni̠, kpe̠le̠me̠ni̠ gi̠e̠ ka̠ a̠leriom ozu d̠oyom ma̠ okur ta̠ A̠zib̠a̠ ma̠ akpe̠ ma̠ alu̠kpe̠ o̠b̠ab̠alame̠ni̠ ozu wa̠ A̠mozizi ato̠ bho̠, ma̠ oleriom ma̠ anwa na̠ a̠d̠um.” ");
INSERT INTO mgj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kpe̠le̠me̠ni̠, i̠na a̠ten agi̠ ka̠ agba ma̠ asu̠gbagba bho̠ kesi kesi, ma̠ ola̠ o̠du̠ ogir ilologia̠n d̠o̠yo̠ asi̠saragi̠an agi̠ ma̠ egbeiny. Ebula̠ o̠ku̠a, A̠zizo̠s na̠ opita̠ d̠o̠ a̠d̠igh d̠a̠ ebhugh bho̠, ya̠a̠ i̠na aro̠ghan d̠a̠ etire a̠risisi ya̠ od̠i kukunum. Ku̠ku̠m eka̠, a̠nwunom i̠d̠u̠a kesi kesi eru d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ra̠d̠a̠ma̠ iten, sa̠ A̠zizo̠s a̠mula̠ a̠d̠igh d̠a̠ Akapanu̠m. Sa̠ a̠nwunom i̠mu̠gho̠n ma̠a̠, i̠na od̠i d̠a̠ otu d̠a̠ e̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sa̠ ro̠lo̠gh a̠nwunom ikokod̠ia̠n d̠a̠ otu bho̠ imuzo ma̠ ola̠ e̠ti̠ti̠gha ola̠ od̠igh d̠a̠ otu bho̠ na̠ o̠mara d̠a̠ o̠nu̠ otu bho̠, na̠ o̠ro̠ d̠o̠. Sa̠ i̠na aro̠ ma̠ i̠se̠ agba ma̠ ib̠eb̠i asu̠gbagba bho̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sa̠ inya̠ a̠nwunom irol o̠ni̠ ola̠ na̠ a̠b̠ogina̠ ma̠ obhin ka̠ o̠te̠i̠ o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Igiel bho̠ awa orue d̠o̠ ma̠ o̠bi̠gh e̠ti̠ti̠gha od̠igh bho̠, d̠a̠ ebula̠ o̠lo̠gh a̠nwunom bho̠. Sa̠ awa i̠si̠n ibhun d̠a̠ anyu̠ otu bho̠, sa̠ i̠kpakpagi̠o̠n imutiom oyol d̠a̠ anyu̠ otu bho̠. Sa̠ i̠wo̠lo̠me̠ni̠ isoroni i̠na d̠a̠ a̠kporokporo bho̠ d̠a̠ a̠misigh ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Igiel bho̠ A̠zizo̠s abi̠gh ologi ima̠ra̠ d̠awa bho̠, sa̠ a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “O̠nyi̠ bho̠, na̠ o̠we̠le̠man i̠karabh d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sa̠ idi ogbo atu̠ghu̠me̠ni̠ oloko bho̠ ya̠ i̠ro̠ ma̠ a̠dila̠de ma̠ i̠se̠ bho̠, id̠igh i̠ru̠ru̠an na̠ epura̠n d̠a̠ rologi d̠awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ezin ka̠ ere ka̠ o̠ni̠ onon na̠ a̠fugh a̠fugh i̠basi̠! A̠nyen ta̠ a̠rue awe̠le̠man i̠karabh ta̠ o̠ni̠, a̠ten A̠zib̠a̠?” ");
INSERT INTO mgj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ya̠a̠, A̠zizo̠s a̠loghoma̠n d̠a̠ e̠mu̠gh d̠o̠yo̠ ma̠ i̠ru̠ru̠an rologi d̠awa, sa̠ a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere ka̠ inyin na̠ o̠ru̠ru̠an o̠ku̠a d̠a̠ rologi d̠inyin? ");
INSERT INTO mgj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Oken wa̠ a̠b̠ur a̠pu ma̠ ofugh onigha̠ o̠ni̠ onon wa̠ na̠ a̠b̠ogina̠ bho̠, ‘Na̠ o̠we̠le̠man i̠karabh d̠oyom,’ bo̠d̠o̠ ofugh ma̠a̠, ‘B̠etina̠ ma̠ a̠bhin a̠kporokporo d̠oyom ma̠ a̠rile’? ");
INSERT INTO mgj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ya̠a̠, ami̠ na̠ a̠d̠ighi ma̠ agu̠o̠ ola̠ inyin ta̠ o̠mu̠gho̠nyan ma̠a̠, O̠nyi̠ ta̠ O̠ni̠ a̠nwuna̠ ma̠ a̠limon o̠we̠le̠man i̠karabh o̠nyi̠o̠mo̠ro̠ni̠ d̠a̠ a̠de onon.” Sa̠ i̠na akparame̠ni̠ a̠fugh a̠nigha̠ ma̠ ukula̠ bho̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, b̠etina̠ ma̠ a̠bhin a̠kporokporo d̠oyom ma̠ a̠yel d̠a̠ otu d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sa̠ i̠na a̠b̠etina̠ a̠bhin a̠kporokporo d̠o̠yo̠ a̠rile d̠a̠ a̠misigh ta̠ eb̠la̠ awa ad̠u̠a, ma̠ ola̠ eb̠la̠ awa ima̠gha̠, sa̠ awa itutumeni ma̠ A̠zib̠a̠ i̠gba ma̠a̠, “I̠yar ta̠ od̠ia̠ d̠o̠ o̠bi̠gh abar ola̠ o̠ko̠no̠n!” ");
INSERT INTO mgj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ a̠mula̠ agi̠ d̠a̠ aka o̠bhi̠i̠y bho̠, sa̠ eb̠la̠ o̠lo̠gh a̠nwunom bho̠ iru d̠o̠yo̠, sa̠ i̠na atu̠ghu̠me̠ni̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Agu̠o̠ A̠zizo̠s a̠d̠igh erile bho̠, sa̠ i̠na abi̠gh A̠livai̠, o̠nyi̠ ta̠ Ali̠fi̠o̠s ka̠ od̠i ma̠ a̠dila̠de d̠a̠ e̠fe̠m ogun otua̠-ebhugh, sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “Tu̠o̠no̠me̠ ami̠,” Sa̠ A̠livai̠ a̠b̠etina̠ atu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sa̠ agu̠o̠ A̠zizo̠s aro̠ ma̠ o̠gho̠ na̠ a̠d̠e ma̠ ed̠ia̠n d̠a̠ otu ta̠ A̠livai̠ bho̠, sa̠ a̠d̠izo igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠karabh iru ra̠ id̠igh na̠ i̠na na̠ ogbo atu̠ghan d̠o̠yo̠ id̠e ma̠ ed̠ia̠n bho̠. Sa̠ aro̠ ma̠ ola̠ a̠d̠izo a̠nwunom iten ogbo i̠tu̠o̠no̠m d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Igiel bho̠ idi ogbo a̠tu̠ghu̠me̠ni̠ oloko bho̠ ya̠ i̠ro̠ ma̠ Rafarisi bho̠ i̠bi̠gh ka̠ i̠na na̠ a̠d̠ed̠ia̠n id̠ighi ma̠ i̠karabh na̠ igun ma̠ otua̠-ebhugh bho̠, sa̠ awa ipura̠n ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Ezin ka̠ ere, ka̠ o̠ni̠ atu̠ghu̠me̠ni̠ d̠inyin na̠ a̠d̠ed̠ia̠n na̠ igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠ka̠rabh bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A̠zizo̠s amu̠gho̠n a̠pura̠n onon, sa̠ i̠na a̠fugh ma̠a̠, “Ogbo ya̠ o̠nwe̠r d̠o̠ i̠bho̠ro̠ghan d̠o̠ ma̠ owil, ya̠a̠ ogbo ya̠ na̠ e̠nwe̠r bho̠. Ami̠ iru ma̠ ra̠ olebh id̠ighi ma̠ i̠karabh, ya̠a̠ ib̠eb̠i a̠nwunom d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aro̠ ma̠ ola̠ ogbo atu̠ghan ta̠ Azo̠n na̠ ogbo atu̠ghan ta̠ Rafarisi bho̠ na̠ ene ma̠ o̠ko̠i̠. Sa̠ awa i̠gi̠ ka̠ ipura̠n A̠zizo̠s ma̠a̠, “Ezin ka̠ ere ka̠ ogbo atu̠ghan ta̠ Azo̠n na̠ ita̠ Rafarisi bho̠ na̠ ene ma̠ o̠ko̠i̠, ya̠a̠ ogbo atu̠ghan d̠oyom ine ani̠ d̠o̠ ma̠ o̠ko̠i̠?” ");
INSERT INTO mgj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Ogbo erogh bho̠ ta̠ e̠tu̠n ere ene ma̠ o̠ko̠i̠ d̠a̠ obhel wa̠ o̠ni̠ erogh bho̠ od̠i na̠ awa bho̠? Yii, awa ko orue d̠o̠ e̠ro̠ ma̠ o̠ko̠i̠, ezin bho̠ o̠ni̠ erogh bho̠ od̠i na̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ya̠a̠, obhel na̠ a̠ru ma̠ ola̠ ta̠ o̠si̠ghe̠ ma̠ o̠ni̠ erogh bho̠ d̠a̠ esa̠d̠io d̠awa, sa̠ awa ta̠ ene ma̠ o̠ko̠i̠ d̠a̠ a̠d̠a̠ma̠ obha̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“O̠ni̠ ola̠ na̠ a̠bhin o̠go̠go̠ra omom ukpe na̠ ab̠ad̠i̠ ma̠ opupu akapa bo̠. Ezin bho̠, esi wa̠ u̠b̠ad̠i̠ bho̠ ta̠ a̠puruna̠ ad̠u̠a d̠a̠ akapa bho̠ ma̠ ola̠ ta̠ agu̠an a̠peleni ma̠ agu̠o̠ aro̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Obha̠ agu̠o̠ o̠ni̠ ko o̠lo̠gh d̠o̠ ma̠ imom a̠min d̠a̠ opupu akana ozu-e̠nam, bo̠d̠o̠ bha̠ akana ozu-e̠nam bho̠ ta̠ a̠pol, sa̠ a̠min bho̠ ta̠ ezugia̠n ebhe, sa̠ akana bho̠ ta̠ api̠an. Kpe̠le̠me̠ni̠, na̠ o̠lo̠gh imom a̠min d̠a̠ imom rakana ozu-e̠nam.” ");
INSERT INTO mgj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A̠mite ma̠ ola̠ d̠a̠ odi A̠d̠a̠ma̠ Osirepobh bho̠, A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ na̠ eten d̠a̠ ari̠si̠ i̠bu̠kpa, sa̠ ogbo atu̠ghan d̠o̠yo̠ ib̠oghi ma̠ itu i̠bu̠kpa bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sa̠ Rafarisi bho̠ ipura̠n i̠na ma̠a̠, “Nagha! Ezin ka̠ ere ka̠ awa na̠ egir abar ola̠ oloko bho̠ oma̠ra̠ d̠o̠ d̠a̠ a̠d̠a̠ma̠ osira̠-epobh bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin ta̠ osen d̠o̠ o̠bi̠gh ma̠ abar wa̠ A̠devidi a̠gir igiel bho̠ o̠ko̠i̠ a̠d̠ighi i̠na sekina̠ a̠nwunom ya̠ i̠ro̠ na̠ i̠na bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ma̠ agu̠o̠ i̠na a̠d̠igh d̠a̠ otu akpu̠ru̠ ta̠ A̠zib̠a̠ d̠a̠ amu̠m wa̠ Abi̠ata aro̠ ma̠ we̠mu̠ okur bho̠, sa̠ a̠d̠e ma̠ abe̠re̠di̠ e̠tu̠tu̠ ya̠ i̠ro̠ inigha̠ ma̠ rokur ta̠ A̠zib̠a̠ ku̠ku̠m ma̠ od̠e. Sa̠ i̠na a̠nigha̠ nyen a̠nwunom ya̠ i̠ro̠ na̠ i̠na bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Umutiom A̠d̠a̠ma̠ Osira̠-epobh bho̠ onigha̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠, ya̠a̠ u̠le̠m d̠o̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠ o̠nigha̠ ma̠ A̠d̠a̠ma̠ Osira̠ epobh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ bha̠ Wa̠nwuna̠ ma̠ A̠d̠a̠ma̠ osira̠ epobh a̠nwunom A̠zu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sa̠ A̠zizo̠s a̠mina̠ ka̠ a̠d̠igh d̠a̠ otu u̠gala A̠zu bho̠. Odi o̠ni̠ ola̠ agu̠o̠ bho̠ na̠ akpari̠an aro̠ ani̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Idi ogbo d̠a̠ o̠lo̠gh d̠awa na̠ e̠bho̠ro̠ghan e̠kal abar ola̠ odin ob̠ologiom A̠zizo̠s, sa̠ awa ikimeni na̠ egon o̠bi̠gh ku̠gba ma̠ i̠na ta̠ a̠koko ma̠ o̠ni̠ bho̠ d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ o̠ni̠ wa̠ agu̠o̠ na̠ akpari̠an bho̠ ma̠a̠, “B̠etina̠ ma̠ amara d̠a̠ a̠misigh eb̠la̠ ogbo.” ");
INSERT INTO mgj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ere ma̠ abar wa̠ oloko bho̠ a̠ma̠ra̠ ma̠ ogir d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠: ogir ib̠eb̠i bo̠d̠o̠ ka̠ ogir i̠karabh, otenemeni o̠ni̠ onigha̠ a̠ghud̠um bo̠d̠o̠ ka̠ ogigh o̠ni̠?” Ya̠a̠, awa inima̠ i̠ro̠ b̠o̠b̠o̠m. ");
INSERT INTO mgj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sa̠ i̠na a̠kpon eb̠la̠ awa a̠kitineni̠ na̠ ibom i̠gam, ma̠ agu̠o̠ awa na̠ e̠kparame̠ni̠ ma̠ rologi d̠awa bho̠, sa̠ a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “Selegheni ma̠ agu̠o̠ d̠oyom.” Sa̠ i̠na a̠selegheni ma̠ agu̠o̠ d̠o̠yo̠, sa̠ agu̠o̠ bho̠ a̠selegha̠n a̠bhon. ");
INSERT INTO mgj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sa̠ Rafarisi bho̠ i̠d̠u̠a ka̠ imimia̠n na̠ ogbo i̠tu̠o̠no̠m ta̠ E̠ro̠d igboloma̠ i̠na, ma̠ agu̠o̠ awa ta̠ ebhin egigh i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sa̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ i̠d̠u̠a ma̠ i̠se̠ i̠gi̠ d̠a̠ aka o̠bhi̠i̠y eko. Sa̠ obom o̠lo̠gh a̠nwunom ya̠ Agalili na̠ A̠zudia̠ i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ipa̠n ro̠lo̠gh ya̠ i̠tu̠o̠no̠m i̠na bho̠ i̠d̠u̠a d̠a̠ A̠zeruse̠le̠m, na̠ Idumia̠ na̠ d̠a̠ aku̠b̠o̠ o̠bhi̠i̠y Azo̠dan, na̠ d̠a̠ e̠ma Ataya na̠ Asi̠do̠n. Eb̠la̠ awa iru d̠a̠ A̠zizo̠s ma̠ agu̠o̠ awa i̠mu̠gho̠n e̠mi̠ i̠di̠ar ya̠ i̠na na̠ a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa̠ i̠na agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠ awa eguri ma̠ oghugh esisa̠n i̠na ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠d̠igh, bo̠ka̠ o̠lo̠gh a̠nwunom bho̠ na̠ i̠ni̠ro̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ezin bho̠ i̠na na̠ a̠koko ma̠ a̠d̠izo a̠nwunom ya̠ i̠ro̠ d̠a̠ ali̠gam a̠ruzu asu̠nwe̠r, ma̠ ola̠ ogbo ya̠ inwuna̠ ma̠ ad̠ien kere kere asu̠nwe̠r na̠ ekukurugha̠n o̠gi̠ d̠a̠ ed̠ia̠ ka̠ okula̠n o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka̠ obhel ka̠ obhel ola̠ ogbo ya̠ i̠karabh aru̠mu̠gh na̠ e̠b̠am i̠bi̠gh i̠na, sa̠ awa ta̠ emeleghu d̠a̠ a̠de emulughu d̠a̠ a̠misigh ta̠ A̠zizo̠s na̠ efugh ma̠a̠, “Anwa O̠nyi̠ ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sa̠ i̠na alo̠gh e̠mi̠ ab̠ab̠agi̠na awa ma̠a̠, od̠ighi̠ d̠o̠ ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ eloghom i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A̠zizo̠s asi̠n d̠a̠ anyu̠ igu sa̠ a̠bhelegi ma̠ ogbo ya̠ i̠na na̠ abho̠ro̠ghan oru d̠o̠yo̠ bho̠. Sa̠ awa iru. ");
INSERT INTO mgj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sa̠ i̠na aso̠n d̠iobh na̠ i̠wal, a̠ghol awa ma̠ ogbo-ogir d̠o̠yo̠, ma̠ agu̠o̠ ola̠ awa ta̠ ed̠igh na̠ i̠na e̠ro̠, na̠ oruom awa o̠gba ib̠eb̠i asu̠gbagba bho̠ o̠sasaragi̠, ");
INSERT INTO mgj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na̠ onigha̠ awa ma̠ a̠limon obhin ozegi i̠karabh aru̠mu̠gh o̠si̠ghe̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I̠nye̠n d̠iobh na̠ i̠wal ogbo ya̠ i̠na aso̠n bho̠: Asai̠mo̠n wa̠ i̠na a̠ghol A̠pita̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","A̠zemsi̠ o̠nyi̠ ta̠ Aze̠bidi, na̠ umor d̠o̠yo̠ Azo̠n (ya̠ A̠zizo̠s a̠ghol ma̠ A̠boanazis, wa̠ a̠ma̠ra̠ ma̠a̠, “anwi̠i̠ny agbararan bho̠”), ");
INSERT INTO mgj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na̠ Anduru, na̠ A̠filip, na̠ Abatolomio, na̠ Amatiu, na̠ Ato̠mo̠si̠, na̠ A̠zemsi o̠nyi̠ ta̠ Ali̠fi̠o̠s, na̠ Atadi̠o̠s, na̠ Asai̠mo̠n wa̠ ughol a̠d̠ien ma̠ A̠zilo̠t bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na̠ A̠zuda̠s I̠skari̠o̠t, wa̠ ra̠ a̠wol i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Odi obhel A̠zizo̠s a̠d̠igh d̠a̠ otu wa̠ i̠na na̠ aro̠ghan bho̠, sa̠ obom o̠lo̠gh a̠nwunom ikokod̠ia̠n, ma̠ ola̠ i̠na sekina̠ ogbo atu̠ghan d̠o̠yo̠ irue d̠o̠ ma̠ o̠te̠i̠ e̠ti̠ti̠gha ola̠ od̠e ed̠ia̠n nyen. ");
INSERT INTO mgj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","D̠a̠ obhel bho̠ ogbo a̠ghisia̠n ta̠ A̠zizo̠s i̠mu̠gho̠n i̠di̠ar ya̠ na̠ emite bho̠, sa̠ awa i̠gi̠ ka̠ obhin o̠yo̠ o̠d̠u̠a, ezin bho̠ na̠ o̠gba ma̠a̠, “I̠na bo̠ ma̠ o̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sa̠ ogbo a̠tu̠ghu̠me̠ni̠ oloko bho̠ ya̠ i̠d̠u̠a d̠a̠ A̠zeruse̠le̠m iru ra̠ ifugh ma̠a̠, “O̠ni̠ onon na̠ a̠bhum A̠belzibul, sa̠ na̠ a̠bhin a̠limon ta̠ A̠belzibul, we̠mu̠ a̠ruru bho̠ na̠ a̠ze ma̠ i̠karabh aru̠mu̠gh na̠ a̠zegi.” ");
INSERT INTO mgj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sa̠ A̠zizo̠s a̠bhelegi awa a̠kokod̠i. Sa̠ i̠na a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠: “Eru bho̠ ta̠ a̠d̠ighi eka̠ a̠ze ma̠ eru asi̠ghe̠? ");
INSERT INTO mgj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ku̠gba ma̠a̠ a̠de e̠ma na̠ aru̠gi̠an na̠ a̠wia̠n ozu d̠o̠yo̠, a̠de e̠ma obha̠ ko orue d̠o̠ amara. ");
INSERT INTO mgj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ku̠gba ma̠a̠ eghun otu na̠ aru̠gi̠an na̠ a̠wia̠n ozu d̠o̠yo̠, eghun otu obha̠ ko orue d̠o̠ amara. ");
INSERT INTO mgj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sa̠, ku̠gba ma̠a̠ Eru bho̠ na̠ aru̠gi̠an na̠ a̠wia̠n ozu d̠o̠yo̠, sa̠ i̠na ko orue d̠o̠ amara; o̠ku̠a bha̠ ita̠ o̠yo̠ na̠ ekunugiom. ");
INSERT INTO mgj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ya̠a̠ opa̠n agu̠o̠ o̠gba. A̠nyen o̠ni̠ wa̠ ta̠ a̠rue a̠d̠igh d̠a̠ otu omomona̠n ka̠ a̠ghumi ma̠ i̠di̠ar d̠o̠yo̠ bho̠, a̠sigimeni ka̠ i̠na na̠ a̠d̠ia̠ abhad̠i̠ ma̠ omomona̠n bho̠? I̠se̠ kisa̠ i̠na ta̠ a̠rue afo̠i̠ny otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠karabh ka̠ i̠karabh ya̠ o̠ni̠ a̠gir, bo̠d̠o̠ a̠fugh i̠basi̠ ya̠ o̠ni̠ a̠fugh a̠gboloma̠ ma̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ o̠we̠le̠man. ");
INSERT INTO mgj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ya̠a̠, o̠ni̠ ola̠ a̠fugh i̠basi̠ a̠gboloma̠ ma̠ E̠mu̠gh E̠tu̠tu̠ bho̠, ko o̠we̠le̠man d̠o̠. Ezin bho̠ o̠ni̠ bho̠ a̠sor oloko ogir i̠karabh ola̠ ta̠ aro̠ kid̠ud̠ul.” ");
INSERT INTO mgj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","A̠zizo̠s agba ma̠ i̠di̠ar i̠nye̠n a̠nigha̠ awa, ezin bho̠ awa na̠ e̠gba ma̠a̠ i̠na na̠ a̠bhin a̠limon i̠karabh aru̠mu̠gh na̠ a̠gir ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sa̠ onweni na̠ a̠rumor ta̠ A̠zizo̠s iru ra̠ i̠mara d̠a̠ etire. Sa̠ awa iruom a̠duom odi o̠ni̠ ma̠ o̠gi̠ ka̠ o̠gba onigha̠ o̠yo̠ ma̠ i̠na a̠ru ra̠ abi̠ghan awa. ");
INSERT INTO mgj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ya̠a̠, o̠lo̠gh a̠nwunom na̠ e̠ro̠ ma̠ a̠dila̠de eko i̠na, sa̠ i̠gba inigha̠ i̠na ma̠a̠, onweni d̠oyom na̠ a̠rumor d̠oyom od̠i d̠a̠ etire na̠ e̠bho̠ro̠ghan o̠bi̠ghan oyom. ");
INSERT INTO mgj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sa̠ A̠zizo̠s awo̠ran awa a̠pura̠n ma̠a̠, “Onweni d̠ami̠ na̠ a̠rumor d̠ami̠ ka̠ wa̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sa̠ i̠na a̠kpon awa ogbo ya̠ od̠i ma̠ a̠dila̠de bho̠ a̠kitineni, sa̠ a̠fugh ma̠a̠, “Ikpone, i̠nye̠n onweni d̠ami̠ na̠ a̠rumor d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ko̠ni̠ko̠ni̠ ola̠ na̠ a̠gir agu̠o̠ A̠zib̠a̠ ato̠ bho̠, bha̠ umor d̠ami̠, na̠ u̠marani̠ d̠ami̠, na̠ onweni d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sa̠ A̠zizo̠s a̠puta̠ ake̠ ma̠ o̠tu̠ghu̠me̠ni̠ d̠a̠ aka o̠bhi̠i̠y eko. Sa̠ obom o̠lo̠gh a̠nwunom isor esi bho̠. Ebula̠ o̠ku̠a sa̠ i̠na a̠d̠igh d̠a̠ oghugh d̠a̠ o̠bhi̠i̠y eko bho̠ aro̠ ma̠ a̠dila̠de, sa̠ eb̠la̠ o̠lo̠gh a̠nwunom bho̠ i̠ro̠ d̠a̠ egbolom. ");
INSERT INTO mgj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sa̠ i̠na a̠bhin ra̠sidogh atu̠ghu̠me̠ni awa ma̠ a̠d̠izo i̠di̠ar agba ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“I̠mare̠ ma̠ e̠nagha o! Ogbebh ma̠ ed̠ia̠n agi̠ d̠a̠ o̠si̠ d̠o̠yo̠ ka̠ ogbebh ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa̠ a̠mite ma̠ ola̠ igiel bho̠ i̠na a̠kpo ma̠ ikpo ed̠ia̠n bho̠ asar bho̠, sa̠ idi ikpo imel d̠a̠ eten, sa̠ i̠nu̠r iru ra̠ ikpokpoiny id̠e i̠mado̠n. ");
INSERT INTO mgj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ya̠a̠, idi ikpo sa̠ imel d̠a̠ a̠de o̠gbe̠o̠ma, esi ola̠ o̠do̠gho̠l bho̠ okud̠um d̠o̠. Sa̠ awa i̠rabh epa̠ ma̠ o̠su̠ ma̠ agu̠o̠ o̠do̠gho̠l bho̠ okud̠um d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ya̠a̠ igiel ogogo a̠mite bho̠, sa̠ i̠nyu̠n i̠ghaghara d̠a̠ ebula̠ agu̠o̠ osi d̠o̠ ma̠ i̠ki̠ka bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sa̠ idi ikpo imel d̠a̠ e̠ko̠ko̠ ib̠ub̠ulom, sa̠ ib̠ub̠ulom bho̠ i̠su̠ ikpegiom ed̠ia̠n bho̠ i̠bhu̠ghu̠d̠i̠, ma̠ ola̠ awa o̠su̠ d̠o̠ emum itu. ");
INSERT INTO mgj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Ya̠a̠, idi ikpo bho̠ imel d̠a̠ ob̠eb̠i a̠de, sa̠ i̠su̠ imite, imum a̠d̠izo itu. Idi imum a̠d̠usubh na̠ d̠iobh (30) a̠bin ya̠ ubhin ugbebh bho̠, idi e̠rabharabh (60) a̠bin, idi i̠wal e̠wala na̠ a̠d̠usubh (100) a̠bin.” ");
INSERT INTO mgj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Wa̠ a̠nwuna̠ ma̠ a̠to, anagha o!” ");
INSERT INTO mgj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","D̠a̠ obhel ola̠ A̠zizo̠s ku̠ku̠m odi ma̠ esi, sa̠ d̠iobh na̠ i̠wal ogbo ogir bho̠, na̠ ipa̠n ogbo ya̠ i̠ro̠ ani̠ ma̠ i̠se̠, ipura̠n i̠na ya̠ igboloma̠ ma̠ ra̠sidogh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “D̠a̠ inyin bha̠, na̠ onigha̠ ma̠ ologhom i̠di̠ar e̠wo̠gi̠na irileghom ta̠ A̠zib̠a̠. Ya̠a̠, ogbo ya̠ o̠ro̠ ani̠ d̠o̠ d̠a̠ o̠lo̠gh d̠inyin bho̠, kabar kabar bha̠ awa ta̠ e̠mu̠gho̠n d̠a̠ a̠sidogh. ");
INSERT INTO mgj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ebula̠ o̠ku̠a, “ ‘awa ta̠ e̠ro̠ ma̠ okpon okpon, ya̠a̠ awa ko o̠bi̠gh d̠o̠, ta̠ e̠mu̠gho̠n ya̠a̠ awa ko o̠mu̠gho̠nyan d̠o̠. B̠o̠ka̠ awa itiba̠ra̠ ma̠ ola̠ ta̠ o̠we̠le̠man i̠karabh d̠awa!’” ");
INSERT INTO mgj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin u̠mu̠gho̠nyan d̠o̠ ma̠ ezin a̠sidogh onon ke̠re̠? O̠ku̠a ka̠ inyin ta̠ od̠ighi eka̠ o̠mu̠gho̠nyan eb̠la̠ ra̠sidogh? ");
INSERT INTO mgj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ogbebhma̠ ed̠ia̠n bho̠ a̠gbebh ikpo a̠fugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ikpo ya̠ imel d̠a̠ eten bho̠, bha̠ ogbo ya̠, agu̠o̠ i̠mu̠gho̠n ikpo a̠fugh bho̠ ku̠ku̠m, sa̠ Eru bho̠ a̠ru ra̠ asi̠ghe̠gi̠ ma̠ ikpo a̠fugh bho̠ d̠a̠ rologi d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ya̠a̠, ikpo ya̠ imel d̠a̠ a̠de o̠gbe̠o̠ma bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n ikpo a̠fugh bho̠ ku̠ku̠m, sa̠ ibhin d̠a̠ a̠libhon ologi i̠da ibhin. ");
INSERT INTO mgj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ya̠a̠, isi d̠o̠ ma̠ i̠ki̠ka, sa̠ i̠ro̠ ma̠ ekud̠i obhel. Ebula̠ o̠ku̠a, ali̠gam a̠ruzu na̠ ad̠agi̠an ma̠ o̠te̠i̠ awa ku̠ku̠m, d̠a̠ ebula̠ ikpo a̠fugh bho̠, sa̠ imel i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ikpo ed̠ia̠n ya̠ imel d̠a̠ ed̠um ib̠ub̠ulom bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n ikpo a̠fugh bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ya̠a̠ a̠tepa̠ sa̠ i̠nyo̠gho̠nyo̠gh e̠mara̠nwunom, e̠li̠la na̠ e̠me̠me̠m e̠mara̠nwunom i̠su̠ i̠mi̠no̠m ma̠ ikpo a̠fugh bho̠ ma̠ ola̠ orue d̠o̠ ma̠ omum itu. ");
INSERT INTO mgj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ya̠a̠, ikpo ed̠ia̠n ya̠ imel d̠a̠ ob̠eb̠i a̠de bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n ikpo a̠fugh bho̠ sa̠ i̠da ibhin, sa̠ imum itu: idi a̠d̠usubh na̠ d̠iobh (30), idi e̠rabharabh (60), idi i̠wal e̠wala na̠ a̠d̠usubh (100), d̠a̠ ikpo ya̠ ubhin ugbebh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ola̠ ta̠ asu̠o̠m ato̠di̠, sa̠ ta̠ a̠bhin abafu̠ a̠kpegiom bo̠d̠o̠ ta̠ oguri d̠a̠ ekpukpu akpata od̠i ke̠re̠? I̠na ko o̠gbam d̠o̠ d̠a̠ anyu̠ esi ola̠ a̠sora̠n ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Abar ola̠ od̠i d̠a̠ e̠wo̠gi̠na ola̠ ko omutiom d̠o̠ bo̠, bo̠d̠o̠ abar ola̠ u̠wo̠gi̠ ola̠ ko o̠bi̠gh d̠o̠ obhin omutiom oyol bo̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","O̠ni̠ ola̠ a̠nwuna̠ ma̠ a̠to, amar amu̠gho̠n o!” ");
INSERT INTO mgj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sa̠ i̠na a̠mina̠ a̠fugh ma̠a̠, “Ibhine ma̠ i̠d̠i̠ar ya̠ inyin na̠ o̠mu̠gho̠n bho̠ ma̠ e̠tu̠o̠m abar. A̠d̠ien agu̠o̠ inyin ibhin u̠tu̠o̠m abar bho̠ bha̠ a̠d̠ien agu̠o̠ inyin ta̠ obhin o̠mu̠gho̠nyan, sa̠ ta̠ o̠lo̠gho̠m o̠gbam. ");
INSERT INTO mgj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","O̠ni̠ ola̠ ate̠i̠ ya̠ ib̠ui ta̠ o̠lo̠gho̠m o̠gbam. Ya̠a̠, o̠ni̠ ola̠ ate̠i̠ i̠ki̠kara, iya̠ i̠na ate̠i̠ bho̠ eka̠, ta̠ o̠wo̠r obhin.” ");
INSERT INTO mgj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sa̠ A̠zizo̠s agba ma̠a̠, “Irileghom ta̠ A̠zib̠a̠ bha̠ od̠i ma̠ agu̠o̠ ogbebh ma̠ ed̠ia̠n ola̠ a̠kpo ma̠ ikpo ed̠ia̠n sa̠ asar d̠a̠ o̠si̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A̠d̠igh a̠d̠uga̠la̠n, bo̠d̠o̠ etita̠n, ogbebh ma̠ ed̠ia̠n bho̠ na̠ a̠kod̠u na̠ asu̠ma, ya̠a̠ ikpo ed̠ia̠n bho̠ na̠ e̠mu̠r na̠ e̠su̠ na̠ emite. Ya̠a̠, i̠na na̠ o̠mu̠gho̠nyan d̠o̠ ma̠ agu̠o̠ ikpo ed̠ia̠n bho̠ na̠ ebhin na̠ e̠su̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A̠de bho̠ na̠ agu̠o̠ na̠ a̠d̠ighi ma̠ ola̠ ekpo ed̠ia̠n na̠ asu̠ na̠ a̠mum otu; ta̠ a̠d̠ia̠ a̠pol a̠mutiom i̠mu̠nu̠mu̠n, sa̠ ta̠ a̠mutiom egum, ka̠ a̠tepa̠ sa̠ ta̠ a̠mum otu ola̠ ta̠ amar akpo̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Otu o̠bu̠kpa bho̠ ma̠ o̠kpo̠ ku̠ku̠m, sa̠ ogbebh ma̠ ed̠ia̠n bho̠ ta̠ a̠b̠ogh, ezin bho̠ obhel ib̠ua̠ bho̠ na̠ a̠lei.” ");
INSERT INTO mgj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sa̠ A̠zizo̠s agba ma̠a̠, “Irileghom ta̠ A̠zib̠a̠ ka̠ ta̠ obhin o̠tu̠o̠m ere? Bo̠d̠o̠, ka̠ i̠yar ta̠ obhin a̠kere a̠sidogh o̠tu̠o̠m? ");
INSERT INTO mgj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Agu̠b̠an ekpo amu̠stadola̠ o̠ni̠ a̠bhin a̠gbebh d̠a̠ a̠lei, ya̠a̠ ekpo bho̠ aki̠r a̠pu ma̠ eb̠la̠ ipa̠n ikpo ed̠ia̠n, ");
INSERT INTO mgj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","sa̠ asu̠ a̠mite a̠ten obom oriren wa̠ abu̠gh a̠pu d̠a̠ a̠lei bho̠, sa̠ a̠nwuna̠ ma̠ i̠gha, sa̠ i̠nu̠r iru ra̠ ilo ma̠ a̠rutu d̠a̠ i̠gha bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sa̠ A̠zizo̠s a̠rogh a̠d̠izo a̠sidogh ya̠ o̠ku̠a, a̠bhin atu̠ghu̠me̠ni̠ awa ma̠ i̠d̠i̠ar ya̠ awa ta̠ erue e̠mu̠gho̠nyan. ");
INSERT INTO mgj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I̠na na̠ o̠gba d̠o̠ ma̠ abar a̠nigha̠ awa, ma̠ ola̠ i̠na obhin d̠o̠ d̠a̠ a̠sidogh agba. Ya̠a̠, igiel i̠na sekina̠ ogbo atu̠ghan d̠o̠yo̠ ku̠ku̠m od̠i, sa̠ i̠na na̠ amar na̠ agba kabar kabar na̠ asi̠si̠ghe̠ni̠ na̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A̠dule a̠d̠a̠ma̠ obha̠, sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Id̠ighi ta̠ o̠b̠e̠i̠y d̠a̠ aku̠b̠o̠ o̠bhi̠i̠y eko bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠we̠le̠man o̠lo̠gh a̠nwunom bho̠ ka̠ id̠igh d̠a̠ oghugh wa̠ A̠zizo̠s od̠i bho̠, sa̠ i̠ke̠ ma̠ o̠b̠e̠i̠y. Sa̠, idi ipa̠n a̠rughugh i̠gbo̠gbu̠an awa i̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sa̠ obom ebiri a̠sor d̠a̠ o̠bhi̠i̠y-eko bho̠, sa̠ abadi̠ bho̠ agam ma̠ ola̠ amu̠m ipoka̠n id̠igh na̠ emuzo d̠a̠ oghugh bho̠ ma̠ owiyom. ");
INSERT INTO mgj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ya̠a̠, A̠zizo̠s amanaghan d̠a̠ agba eti oghugh bho̠ agbam e̠mu̠ d̠o̠yo̠ d̠a̠ ob̠enegioma̠ e̠mu̠, sa̠ ro̠ ma̠ i̠se̠ na̠ a̠kod̠u. Sa̠ ogbo atu̠ghan bho̠ i̠gi̠ ka̠ i̠su̠me̠ni̠ i̠na ifugh ma̠a̠: “O̠ni̠ atu̠ghu̠me̠ni̠, a̠d̠ugh wa̠ na̠ a̠bhin i̠yar bho̠, na̠ ogboloma̠ d̠o̠ nyam ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sa̠ A̠zizo̠s a̠b̠etina̠ ab̠ab̠agi̠na ma̠ ebiri bho̠ ma̠a̠ “Kima̠!” Sa̠ a̠fugh a̠nigha̠ ma̠ abadi̠ bho̠ ma̠a̠, “B̠okume!” Sa̠ ebiri bho̠ a̠kima̠, sa̠ abadi̠ bho̠ a̠b̠okum, sa̠ ekima̠ a̠mite. ");
INSERT INTO mgj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sa̠ i̠na a̠fugh awa ma̠a̠, “Ere ka̠ inyin na̠ oghil a̠rugugu? Ere wa̠ inyin ta̠ o̠te̠i̠ d̠o̠ ma̠ ologi ima̠ra̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sa̠ a̠rugugu isibh awa ma̠ ibom, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “Onon ka̠ a̠kere a̠d̠ien o̠ni̠, ma̠ ola̠ ebiri na̠ abadi̠ eka̠ na̠ e̠nagha i̠na?” ");
INSERT INTO mgj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sa̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ i̠b̠e̠i̠ d̠a̠ aku̠b̠o̠ o̠bhi̠i̠y eko Agalili d̠a̠ agba ebhugh Age̠rasa. ");
INSERT INTO mgj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Igiel bho̠ i̠na a̠sor d̠a̠ oghugh bho̠, sa̠ odi o̠ni̠ ola̠ o̠karabh e̠mu̠gh na̠ aro̠ d̠a̠ ozu bho̠ a̠bia̠, ad̠u̠a d̠a̠ o̠karabh esi bho̠ ra̠ ami̠nana i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","O̠ni̠ bho̠ a̠rugh d̠a̠ o̠karabh esi, ya̠a̠ bebina̠ o̠ni̠ ola̠ a̠rue ma̠ o̠bhad̠i̠ o̠yo̠ na̠ o̠ro̠ d̠o̠, ubhin eka̠ ma̠ i̠go̠ro̠go̠ro̠ o̠bhad̠i̠ i̠na isibhom d̠o̠ eguri ma̠ onin esi nyen. ");
INSERT INTO mgj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A̠d̠izo igiel, ubhin gha̠n i̠go̠ro̠go̠ro̠ na̠ ikoli o̠du̠o̠m i̠na d̠a̠ aru̠gu̠o̠ na̠ a̠sike oguri ma̠ esi, ya̠a̠ i̠na a̠gbugbo gha̠n i̠go̠ro̠go̠ro̠ na̠ ikoli ya̠ ubhin u̠du̠o̠m i̠na bho̠, sa̠ a̠nwinigi gha̠n ikpo a̠rukurogh ya̠ ubhin u̠du̠o̠m a̠sike d̠o̠yo̠ bho̠ nyen. Sa̠, o̠ni̠ ola̠ a̠nwuna̠ ma̠ igba̠ ya̠ obhin osibh o̠yo̠ oguri onin esi na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A̠d̠uga̠la̠n na̠ etita̠n a̠d̠io i̠na na̠ aro̠ d̠a̠ o̠karabh esi na̠ d̠a̠ ranyu̠ od̠i na̠ d̠a̠ a̠rugugum, na̠ a̠mulughu na̠ a̠bhin i̠pad̠i̠ i̠gbaki̠ghe̠ na̠ a̠guyogh ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ya̠a̠, igiel bho̠ i̠na abi̠gh A̠zizo̠s ma̠ esi egbeiny bho̠, sa̠ i̠na a̠ghil ka̠ a̠mel a̠kpud̠ia̠n a̠nigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sa̠ a̠bhin obom okoroko a̠mulughu a̠fugh ma̠a̠, “Anwa na̠ ami̠ ka̠ odi a̠nwuna̠ ma̠ ere a̠gboloma̠ ma̠ odi? A̠zizo̠s, O̠nyi̠ ta̠ A̠zib̠a̠ Wagi̠manyu̠ A̠pu bho̠. Ami̠ na̠ a̠siseiny anwa d̠a̠ a̠d̠ien ta̠ A̠zib̠a̠, ko ogbikimeni ami̠!” ");
INSERT INTO mgj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ezin bho̠ bha̠ A̠zizo̠s na̠ a̠fugh ma̠a̠, “O̠karabh e̠mu̠gh mite ma̠ ad̠u̠a d̠a̠ ozu o̠ni̠ onon.” ");
INSERT INTO mgj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “A̠d̠ien d̠oyom ka̠ ubhelegi eka̠?” Sa̠ i̠na awo̠ran ma̠a̠, “A̠d̠izo,” ezin bho̠ i̠yar a̠b̠utu. ");
INSERT INTO mgj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sa̠ i̠na akparame̠ni̠ ale̠gh A̠zizo̠s ma̠ i̠na oze d̠o̠ awa asi̠ghe̠ d̠a̠ ebhugh obha̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","D̠a̠ obhel obha̠, obom o̠lo̠gh roporopo i̠ro̠ d̠a̠ eb̠ub̠um a̠de d̠a̠ aka esi bho̠, na̠ eb̠u na̠ ed̠e. ");
INSERT INTO mgj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sa̠ i̠karabh aru̠mu̠gh bho̠ i̠le̠gh i̠na ma̠a̠, “Ruome i̠yar o̠gi̠ ka̠ od̠igh d̠a̠ a̠ruzu roporopo bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sa̠ A̠zizo̠s a̠ma̠ra̠ a̠nigha̠ awa. Sa̠ i̠karabh aru̠mu̠gh bho̠ imite ka̠ id̠igh d̠a̠ roporopo bho̠. Roporopo bho̠ ta̠ elei agu̠o̠ o̠gho̠ o̠ni̠r (2,000), sa̠ eb̠la̠ awa i̠d̠u̠a d̠a̠ eb̠ub̠um a̠de bho̠ ighil isor d̠a̠ o̠bhi̠i̠y-eko bho̠, i̠bhu̠ghu̠d̠i̠an imugughu. ");
INSERT INTO mgj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sa̠ ogbo ya̠ na̠ ekponom roporopo bho̠ ighil ka̠ i̠gba d̠a̠ ibom na̠ i̠gbara re̠ma bho̠, ma̠ i̠di̠ar ya̠ imite bho̠. Sa̠ a̠nwunom bho̠ imite iru ra̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Igiel bho̠ awa iru d̠a̠ A̠zizo̠s bho̠, sa̠ i̠bi̠gh o̠ni̠ wa̠ i̠karabh aru̠mu̠gh i̠d̠u̠a d̠a̠ ozu bho̠ ka̠ od̠i ma̠ a̠dila̠de, na̠ a̠loghoma̠n ozu, a̠bura̠ ma̠ ibura̠, sa̠ a̠rugugu isibh awa. ");
INSERT INTO mgj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sa̠ ogbo ya̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠, i̠gba ma̠ a̠d̠ien agu̠o̠ o̠ni̠ wa̠ i̠karabh aru̠mu̠gh i̠ro̠ d̠a̠ ozu bho̠ a̠bhin a̠d̠um, sekina̠ iya̠ igboloma̠ ma̠ roporopo bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sa̠ o̠lo̠gh a̠nwunom bho̠ i̠le̠gh A̠zizo̠s ma̠ i̠na ad̠u̠a d̠a̠ ebhugh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Agu̠o̠ A̠zizo̠s ad̠u̠a agi̠ ka̠ a̠d̠igh d̠a̠ oghugh bho̠, sa̠ o̠ni̠ wa̠ i̠karabh aru̠mu̠gh i̠ro̠ d̠a̠ ozu bho̠ a̠puru ma̠ A̠zizo̠s ma̠a̠, “Ma̠ra̠ ami̠ i̠tu̠o̠no̠m anwa.” ");
INSERT INTO mgj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ya̠a̠, A̠zizo̠s na̠ oma̠ra̠ d̠o̠, ya̠a̠ awo̠ran i̠na ma̠a̠, “Mula̠ ma̠ agi̠ d̠a̠ otu d̠oyom, ma̠ ka̠ agba ma̠ a̠mutiom ibom i̠di̠ar ya̠ Wa̠nwuna̠ bho̠ na̠ a̠gir a̠nigha̠ nyam bho̠, na̠ okpon igbirigbir ya̠ i̠na a̠leriom anwa bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sa̠ o̠ni̠ bho̠ a̠ten agi̠ ka̠ agba asasaragi̠ d̠a̠ eb̠la̠ ebhugh A̠d̠iobh Re̠ma bho̠, ma̠ ibom i̠di̠ar ya̠ A̠zizo̠s a̠gir a̠nigha̠ i̠na bho̠, sa̠ a̠d̠igh ilologia̠n ogbo ya̠ i̠mu̠gho̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa̠ A̠zizo̠s a̠puta̠ a̠d̠igh d̠a̠ oghugh ab̠e̠i̠ d̠a̠ aku̠b̠o̠ bho̠, sa̠ obom o̠lo̠gh a̠nwunom ikokod̠ia̠n iru d̠o̠yo̠ d̠a̠ aka o̠bhi̠i̠y eko bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sa̠ odi we̠mu̠ okponom ma̠ otu u̠gala A̠zu bho̠, ola̠ ubhelegi ma̠ Azari̠o̠s a̠ru ani̠ ma̠ i̠se̠. Igiel bho̠ i̠na abi̠gh A̠zizo̠s bho̠, sa̠ i̠na agi̠ ka̠ a̠kpud̠ia̠n d̠a̠ a̠sike d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ale̠gh i̠na akparame̠ni̠ agba ma̠a̠, “O̠gbara o̠nyani̠ d̠ami̠ na̠ ra̠ omugh. Siseiny, tue ra̠ agbam agu̠o̠ d̠oyom d̠a̠ ozu d̠o̠yo̠ ma̠ a̠koko i̠na ma̠ a̠d̠umeni.” ");
INSERT INTO mgj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sa̠ A̠zizo̠s a̠d̠igh na̠ i̠na agi̠, sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m A̠zizo̠s iko i̠na ikiton. ");
INSERT INTO mgj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Odi ani̠ ola̠ asi̠ na̠ e̠gbo̠ d̠a̠ ozu bho̠ ma̠ a̠d̠iobh na̠ i̠wal (12) ala aro̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","I̠na na̠ a̠gbika̠ ma̠ ibom d̠a̠ aru̠gu̠o̠ a̠d̠izo a̠riwil, a̠robh eb̠la̠ ikpoki d̠o̠yo̠ ma̠ okokua̠n, ya̠a̠ esi bho̠ aro̠ ku ma̠ opu opu. ");
INSERT INTO mgj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Igiel bho̠ i̠na amu̠gho̠n iya̠ igboloma̠ ma̠ A̠zizo̠s bho̠, sa̠ i̠na a̠kukurugha̠n d̠a̠ o̠lo̠gh bho̠, awo̠l d̠a̠ aman ta̠ A̠zizo̠s ka̠ a̠kula̠n ibura̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ezin bho̠, i̠na a̠ma̠ra̠ d̠a̠ ologi d̠o̠yo̠ ma̠a̠, “Ku̠gba ma̠ ami̠ ta̠ a̠rue a̠kula̠n ibura̠ d̠o̠yo̠ ku̠ku̠m eka̠, bha̠ ami̠ od̠um.” ");
INSERT INTO mgj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","D̠a̠ onin obhel bho̠, sa̠ asi̠ ya̠ na̠ e̠gbo̠ bho̠ isobha̠n, sa̠ i̠na a̠loghoma̠n ma̠a̠ i̠na na̠ a̠d̠um d̠a̠ asu̠nwe̠r bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sa̠ A̠zizo̠s a̠loghoma̠n ma̠a̠ a̠limon na̠ e̠d̠u̠a d̠a̠ ozu d̠o̠yo̠. Ebula̠ o̠ku̠a, sa̠ i̠na a̠tiba̠ra̠ adama ma̠ o̠lo̠gh bho̠ a̠pura̠n ma̠a̠, “A̠nyen a̠kula̠n ibura̠ d̠ami̠?” ");
INSERT INTO mgj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠wo̠ran i̠na ma̠a̠, “Anwa na̠ abi̠gh agu̠o̠ o̠lo̠gh a̠nwunom na̠ e̠ni̠ran eko nyam ekiton, sa̠ anwa na̠ a̠pura̠n ma̠a̠, ‘A̠nyen a̠kula̠n ami̠?’” ");
INSERT INTO mgj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ya̠a̠, A̠zizo̠s a̠kpon d̠a̠ o̠lo̠gh bho̠ a̠kitineni ma̠ o̠bi̠gh o̠ni̠ wa̠ a̠kula̠n i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Igiel bho̠ ani̠ bho̠ a̠loghoma̠n abar wa̠ na̠ a̠mutuma̠ i̠na bho̠, sa̠ i̠na a̠bhin d̠a̠ a̠rugugu, a̠bhin igiri a̠ru ra̠ a̠kpud̠ia̠n d̠a̠ a̠misigh d̠o̠yo̠, sa̠ a̠bhin ya̠gia̠ga̠i agba ma̠ eb̠la̠ agu̠o̠ abar bho̠ a̠mite a̠nigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sa̠ A̠zizo̠s agba a̠nigha̠ i̠na ma̠a̠, “O̠nyani̠ bho̠, ologi ima̠ra̠ d̠oyom na̠ a̠koko nyam. Gi̠e̠ na̠ ekima̠ ma̠ a̠miza̠n d̠a̠ egbika̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A̠zizo̠s od̠id̠ia̠ na̠ agba ma̠ i̠nye̠n, sa̠ idi a̠nwunom i̠d̠u̠a d̠a̠ otu ta̠ Azari̠o̠s ra̠ i̠gba i̠nigha̠ i̠na ma̠a̠, “Ekpo epobh o̠nyani̠ d̠oyom na̠ a̠sobha̠n! Ko onyegi mu ma̠ o̠ni̠ a̠tu̠ghu̠me̠ni̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ya̠a̠ A̠zizo̠s a̠bhogia̠n asu̠gbagba d̠awa, sa̠ agba a̠nigha̠ ma̠ we̠mu̠ u̠gala A̠zu bho̠ ma̠a̠, “Ko oghil a̠rugugu, ma̠ra̠ ka̠ a̠ma̠ra̠.” ");
INSERT INTO mgj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I̠na na̠ oma̠ra̠ d̠o̠ ma̠ opa̠n o̠ni̠ ma̠ o̠tu̠o̠no̠m o̠yo̠, a̠ten A̠puta̠, na̠ A̠zemsi na̠ Azo̠n umor ta̠ A̠zemsi. ");
INSERT INTO mgj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Igiel bho̠ awa i̠gi̠ ka̠ i̠te̠i̠ d̠a̠ otu ta̠ we̠mu̠ otu u̠gala A̠zu bho̠, sa̠ A̠zizo̠s abi̠gh ka̠ a̠nwunom od̠i d̠a̠ asu̠su̠ghu̠d̠i̠an, sa̠ na̠ emulughu na̠ eleghe na̠ e̠gba ma̠ igbir. ");
INSERT INTO mgj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sa̠ A̠zizo̠s a̠d̠igh d̠a̠ ologi otu bho̠, sa̠ a̠pura̠n awa ma̠a̠, “Inyin na̠ odin ere na̠ o̠su̠su̠ghu̠d̠i̠an, na̠ oleghe ma̠ o̠ku̠a? O̠nyani̠ bho̠ ta̠ omugh d̠o̠, ya̠a̠ na̠ a̠kod̠u ma̠ adala.” ");
INSERT INTO mgj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sa̠ a̠nwunom bho̠ i̠mo̠lo̠gh i̠ki̠ri̠ i̠na. Ya̠a̠, i̠na a̠ze awa a̠mutiom, sa̠ a̠bhin onweni na̠ o̠we̠de̠ o̠nyani̠ bho̠, na̠ ogbo ya̠ i̠tu̠o̠no̠m i̠na bho̠, a̠d̠igh agi̠ d̠a̠ esi wa̠ o̠nyani̠ bho̠ aro̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sa̠ i̠na a̠sibh o̠nyani̠ bho̠ d̠a̠ agu̠o̠ a̠fugh a̠nigha̠ ma̠a̠, “Talita, Kumi!” wa̠ a̠ma̠ra̠ ma̠a̠, “O̠gbara o̠nyani̠, b̠etina̠!” ");
INSERT INTO mgj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sa̠ o̠nyani̠ bho̠ a̠b̠etina̠ d̠a̠ onin obhel obha̠ ake̠ ma̠ orile (i̠na d̠iobh na̠ i̠wal ala). Sa̠ abar bho̠ a̠d̠igh ilologia̠n a̠nwunom bho̠ ma̠ ibom. ");
INSERT INTO mgj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ya̠a̠, A̠zizo̠s a̠bukiom awa ma̠a̠ awa o̠gba d̠o̠ ma̠ abar wa̠ a̠mite bho̠ enigha̠ ma̠ o̠ni̠ na̠ o̠ni̠. Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Inigha̠ i̠na ma̠ abar ta̠ a̠d̠e.” ");
INSERT INTO mgj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A̠zizo̠s na̠ Ogbo atu̠ghan d̠o̠yo̠ i̠d̠u̠a ma̠ i̠se̠ a̠ten e̠gi̠ d̠a̠ e̠ma wa̠ i̠na a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ate̠i̠ A̠d̠a̠ma̠ Osira̠ Epobh a̠nwunom A̠zu bho̠, sa̠ i̠na ake̠ ma̠ o̠tu̠ghu̠me̠ni̠ d̠a̠ otu u̠gala bho̠. Sa̠ a̠d̠igh ilologia̠n a̠d̠izo ogbo ya̠ i̠mu̠gho̠n i̠na bho̠. Sa̠ awa ipura̠n ma̠a̠, “I̠na ate̠i̠ i̠di̠ar i̠nye̠n d̠a̠ a̠ken? I̠nye̠n ka̠ a̠kere a̠d̠ien eloghom abar ya̠ unigha̠ i̠na bho̠? Ma̠ ola̠ i̠na na̠ a̠gir ibom ilologia̠n ya̠ o̠ko̠no̠n? ");
INSERT INTO mgj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Onon o̠du̠gi̠ ma̠ i̠di̠ar o̠nyi̠ ta̠ A̠meri bho̠ d̠o̠ ke̠re̠? Umor ta̠ A̠zemsi̠ na̠ A̠zosisi na̠ A̠zud na̠ Asai̠mo̠n d̠o̠ ke̠re̠? Aru̠marani̠ d̠o̠yo̠ bo̠ na̠ i̠yar i̠se̠n ke̠re̠?” Ebula̠ o̠ku̠a, sa̠ awa ighel i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Esi ola̠ owil olei d̠o̠ ma̠ abar bo̠, a̠ten d̠a̠ e̠ma wa̠ i̠na a̠mite bho̠, sekina̠ d̠a̠ esa̠d̠io ogbo a̠ghisia̠n, na̠ d̠a̠ eghun otu d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I̠na na̠ orue d̠o̠ ma̠ ogir bebina̠ onin ilologia̠n i̠se̠, a̠ten o̠gbamagi̠ aru̠gu̠o̠ d̠o̠yo̠ d̠a̠ a̠ruzu i̠ki̠kara a̠nwunom ya̠ na̠ e̠nwe̠re̠ghu̠, okoko awa od̠umeni. ");
INSERT INTO mgj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sa̠ a̠d̠igh i̠na ma̠ ilologia̠n ma̠ agu̠o̠ awa onwuna̠ d̠o̠ ma̠ ologi ima̠ra̠ bho̠. Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ a̠ten agi̠ d̠a̠ re̠ma ya̠ od̠i d̠a̠ eghighira̠ bho̠ atu̠ghu̠me̠ni̠ ma̠ a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sa̠ i̠na a̠bhelegi ma̠ d̠iobh na̠ i̠wal bho̠, sa̠ a̠ruom awa ma̠ ob̠etina̠ erile, i̠wal o̠ni̠ ma̠ ebu, a̠nigha̠ awa ma̠ a̠limon ya̠ obhin oze i̠karabh aru̠mu̠gh, ");
INSERT INTO mgj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","sa̠ akparame̠ni̠ agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ko obhin bebina̠ abar ma̠ eb̠etina̠ ma̠ e̠gi̠ bho̠, a̠ten okpeti. Ed̠ia̠n o̠ro̠ d̠o̠, e̠kpa o̠ro̠ d̠o̠, okpoki o̠ro̠ d̠o̠ d̠a̠ ro̠kara ikpoki d̠inyin nyen. ");
INSERT INTO mgj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","I̠lo̠gi̠ane̠ ma̠ ragbaka, ya̠a̠ o̠ni̠ ko obhin akapa onwegina̠.” ");
INSERT INTO mgj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Igiel inyin ud̠igh d̠a̠ otu-esul, i̠ro̠ ma̠ i̠se̠ tu̠tu̠n inyin ta̠ o̠d̠u̠a d̠a̠ e̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya̠a̠, ka̠ inyin u̠gi̠ d̠a̠ e̠ma ola̠ a̠nwunom bho̠ o̠da d̠o̠ inyin ebhin, bo̠d̠o̠ o̠nagha d̠o̠ inyin, bha̠ i̠d̠u̠a d̠a̠ e̠ma bho̠ ma̠ ekpukpu ma̠ ibhugh bho̠ ma̠ e̠si̠ghe̠ d̠a̠ re̠b̠ab̠a a̠sike d̠inyin. Obha̠ ta̠ aro̠ ma̠ elegh ebhum ase̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sa̠ ogbo ogir bho̠ i̠gi̠ ka̠ i̠gba imutiom ma̠ a̠nwunom etiba̠ra̠ d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Awa ize ma̠ a̠d̠izo i̠karabh aru̠mu̠gh sa̠ izugioghom a̠d̠izo ogbo asu̠nwe̠r ma̠ amu̠nu̠, ikoko awa id̠umeni. ");
INSERT INTO mgj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sa̠ o̠du̠ ta̠ A̠zizo̠s asi̠saragi̠an ate̠i̠ kesikesi, ma̠ ola̠ O̠li̠le̠ma E̠ro̠d amu̠gho̠n a̠gboloma̠ i̠na. Idi ogbo i̠ru̠ru̠an ma̠a̠, i̠na Azo̠n owurmamu̠m bho̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um, bha̠ ezin bho̠ i̠na ate̠i̠ a̠limon ya̠ obhin ogir ilologia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ipa̠n ogbo sa̠ i̠gba ma̠a̠, “I̠na I̠lai̠za.” Ipa̠n sa̠ i̠gba ma̠a̠, “I̠na odi owil wa̠ aro̠ ma̠ igied̠i bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ya̠a̠, igiel bho̠ E̠ro̠d amu̠gho̠n a̠gboloma̠ i̠na bho̠, sa̠ i̠na agba ma̠a̠, “Azo̠n wa̠ ami̠ isobh e̠mu̠ igigh bho̠ na̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um.” ");
INSERT INTO mgj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","E̠ro̠d na̠ agu̠o̠ a̠bhin i̠to̠ d̠o̠yo̠ a̠ruom a̠nwunom ob̠ol Azo̠n, o̠bhad̠i̠ o̠yo̠ od̠ighom ikoli, ma̠ ebula̠ E̠ro̠di̠as ani̠ ta̠ A̠filip umor d̠o̠yo̠, wa̠ i̠na E̠ro̠d akpakpa a̠bhin bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Azo̠n aro̠ ma̠ o̠gba o̠gba onigha̠ E̠ro̠d ma̠a̠, “Na̠ osora̠n d̠o̠ nyam o̠kpakpa ani̠ umor d̠oyom obhi̠n.” ");
INSERT INTO mgj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","E̠ro̠di̠as a̠din o̠ku̠a a̠gurumeni ma̠ ologi a̠nigha̠ ma̠ Azo̠n sa̠ abho̠ro̠gh ogigh o̠yo̠, ya̠a̠ i̠na na̠ orue d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","E̠ro̠d a̠ghila̠n Azo̠n sa̠ a̠kponom i̠na, ezin bho̠ i̠na a̠loghom ma̠a̠ Azo̠n o̠ni̠ igielake̠ sa̠ a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ A̠zib̠a̠. A̠d̠izo i̠di̠ar ya̠ Azo̠n agba bho̠ e̠su̠su̠ghu̠d̠i̠ ma̠ ologi ta̠ E̠ro̠d, ku̠ku̠m eka̠, i̠na a̠ba̠ra̠ ma̠ o̠nagha asu̠gbagba d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ekunuguma̠ bho̠, sa̠ a̠sora̠n a̠d̠a̠ma̠ ola̠ E̠ro̠d a̠soroni ma̠ o̠d̠e̠ a̠nigha̠ ma̠ eb̠la̠ ogbo aru̠mu̠ irileghom ebhugh bho̠, na̠ ogbo aru̠mu̠ e̠gham, na̠ ogbo ya̠ ilei abar d̠a̠ Agalili, ma̠ o̠ghe̠re̠ghu̠o̠m a̠d̠a̠ma̠ wa̠ u̠mar i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sa̠ o̠nyani̠ ta̠ E̠ro̠di̠as a̠d̠igh a̠ru ra̠ aghe̠r i̠gba d̠a̠ o̠d̠e̠ bho̠, sa̠ i̠gba bho̠ id̠igh ologi ma̠ E̠ro̠d na̠ ogbo ya̠ isor d̠a̠ o̠d̠e̠ bho̠ ka̠ i̠te̠i̠ esi ola̠ E̠ro̠d agba a̠nigha̠ ma̠ o̠gbara o̠nyani̠ bho̠ ma̠a̠, “Puru ami̠ ma̠ abar na̠ abar ola̠ na̠ ebhir anwa ma̠ o̠te̠i̠, sa̠ ami̠ ta̠ a̠nigha̠ nyam.” ");
INSERT INTO mgj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sa̠ i̠na a̠d̠ia̠n i̠zo̠ a̠gua̠n a̠nigha̠ i̠na ma̠a̠ “Kabar kabar ola̠ anwa ipuru, ami̠ ta̠ a̠nigha̠ nyam, aro̠ ku̠ ma̠ atu̠gi̠an irileghom d̠ami̠ eka̠.” ");
INSERT INTO mgj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sa̠ o̠nyani̠ bho̠ ad̠u̠a agi̠ ka̠ a̠pura̠n onweni d̠o̠yo̠ ma̠a̠, “Ami̠ ipuru ma̠ ere?” Sa̠ onweni d̠o̠yo̠ awo̠ran ma̠a̠, “E̠mu̠ ta̠ Azo̠n owurmamu̠m bho̠,” ");
INSERT INTO mgj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sa̠ o̠nyani̠ bho̠ a̠nugia̠n ka̠ agba a̠nigha̠ ma̠ O̠li̠le̠ma bho̠ ma̠a̠, “Ami̠ na̠ abho̠ro̠gh anwa ma̠ onigha̠ ami̠ ma̠ i̠se̠n epa̠ ma̠ e̠mu̠ ta̠ Azo̠n owurmamu̠m bho̠ d̠a̠ e̠kpa imobh” ");
INSERT INTO mgj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sa̠ E̠ro̠d a̠kpon igbirigbir ozu d̠o̠yo̠ ma̠ ibom, ku̠ku̠m eka̠ i̠na na̠ one d̠o̠ ma̠ ogineni o̠yo̠ d̠a̠ ebula̠ ri̠zo̠ ya̠ i̠na a̠d̠ia̠n d̠a̠ a̠misigh eb̠la̠ ogbo ya̠ isor d̠a̠ o̠d̠e̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ebula̠ o̠ku̠a sa̠ i̠na a̠ruom epa̠ ma̠ odi o̠ni̠ wa̠ na̠ a̠kponom i̠na bho̠ ma̠ o̠gi̠ d̠a̠ otu ikoli bho̠ ka̠ osobh e̠mu̠ ta̠ Azo̠n. Sa̠ o̠ni̠ bho̠ agi̠ ka̠ a̠sobh e̠mu̠ ta̠ Azo̠n, ");
INSERT INTO mgj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","sa̠ i̠na alo̠gh e̠mu̠ ta̠ Azo̠n d̠a̠ e̠kpa imobh bho̠ a̠bhin a̠ruom o̠nyani̠ bho̠, sa̠ o̠nyani̠ bho̠ a̠bhin agi̠o̠m onweni d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Igiel bho̠ ogbo atu̠ghan ta̠ Azo̠n i̠mu̠gho̠n abar bho̠, sa̠ awa iru ra̠ ibhin eputa̠ ozu bho̠ i̠gi̠ ka̠ id̠i. ");
INSERT INTO mgj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sa̠ ogbo ogir bho̠ imula̠ iru d̠a̠ A̠zizo̠s ra̠ i̠gba inigha̠ i̠na ma̠ eb̠la̠ i̠di̠ar ya̠ awa igir bho̠ na̠ eb̠la̠ agu̠o̠ awa ubhin i̠tu̠ghu̠me̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sa̠ aro̠ ma̠ ola̠ a̠d̠izo a̠nwunom idi na̠ eru, idi na̠ e̠gi̠, ma̠ ola̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ o̠te̠i̠ d̠o̠ bebina̠ e̠ti̠ti̠gha obhel ola̠ od̠e abar. Ebula̠ o̠ku̠a, sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Itue oten o̠gi̠ ma̠ esi ola̠ i̠yar ku̠ku̠m ta̠ o̠ro̠, b̠o̠ka̠ inyin osira̠ ma̠ epobh ekud̠i obhel.” ");
INSERT INTO mgj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sa̠ awa id̠igh d̠a̠ oghugh iten i̠gi̠ ma̠ esi ola̠ awa ku̠ku̠m ta̠ e̠ro̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ya̠a̠, a̠d̠izo a̠nwunom e̠bi̠gh igiel bho̠ awa na̠ e̠d̠u̠a bho̠ sa̠ i̠wal iloghom esi bho̠ awa na̠ e̠gi̠ bho̠. Sa̠ a̠d̠izo a̠nwunom d̠a̠ eb̠la̠ re̠ma bho̠, ikpo ma̠ eghil i̠wo̠l ya̠ a̠wel ka̠ id̠ia̠ imisi ma̠ esi bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Igiel bho̠ awa isul bho̠, sa̠ A̠zizo̠s a̠pel a̠bhun, abi̠gh obom o̠lo̠gh a̠nwunom, sa̠ igbirigbir a̠nwunom bho̠ id̠ighi i̠na, ezin bho̠ awa i̠gu̠b̠an ro̠nana ya̠ o̠ni̠ okponom o̠to̠. Ebula̠ o̠ku̠a sa̠ i̠na a̠bhin obhel atu̠ghu̠me̠ni̠ awa ma̠ a̠d̠izo i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Igiel bho̠ a̠d̠io na̠ ate̠i̠ a̠dule bho̠, sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠gi̠ ka̠ i̠te̠i̠ i̠na i̠gba ma̠a̠, “Onon esi ola̠ od̠i kukunum, ya̠a̠ obhel bho̠ na̠ a̠ten. ");
INSERT INTO mgj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ruome ma̠ a̠nwunom bho̠ eten e̠gi̠ d̠a̠ e̠sala ari̠si̠ na̠ d̠a̠ re̠ma ya̠ itua̠n bho̠, b̠o̠ka̠ awa e̠bho̠ro̠gh abar egho ed̠e.” ");
INSERT INTO mgj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Inyin na̠ agu̠o̠ inigha̠ awa ma̠ abar ed̠e.” Sa̠ awa ipura̠n i̠na ma̠a̠, “O̠ku̠a bha̠ i̠yar obhin ikpoki ya̠ ta̠ elei agu̠o̠ ogho e̠wala (200) a̠dinari̠ o̠gi̠ ka̠ ogho ma̠ abe̠re̠di̠ onigha̠ awa ma̠ od̠e ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin unwuna̠ ma̠ i̠ni̠ ikpokpogh abe̠re̠di̠? I̠gi̠e̠ ka̠ ekpon.” Sa̠ awa i̠gi̠ ka̠ ikpon sa̠ iru ra̠ i̠wo̠ran ma̠a̠, “I̠yar unwuna̠ ogho ikpokpogh abe̠re̠di̠ na̠ i̠wal ikpo ina̠.” ");
INSERT INTO mgj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sa̠ A̠zizo̠s a̠ruom ogbo atu̠ghan d̠o̠yo̠ ma̠ e̠gba enigha̠ ma̠ a̠nwunom bho̠ ma̠ o̠ro̠ a̠dila̠de d̠a̠ i̠gho̠gho̠ bho̠ ma̠ ebu ebu. ");
INSERT INTO mgj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sa̠ awa i̠ro̠ ma̠ a̠dila̠de d̠a̠ rebu i̠wal e̠wala na̠ a̠d̠usubh (100) na̠ eruba̠l na̠ d̠iobh (50) o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sa̠ i̠na a̠bhin ogho ikpokpogh abe̠re̠di̠ bho̠ na̠ i̠wal ikpo ina̠ bho̠, sa̠ a̠b̠eka̠ a̠kpon d̠a̠ ote̠nai̠ny a̠tutumeni ma̠ ed̠ia̠n bho̠. Sa̠ i̠na a̠puinyogh ikpokpogh abe̠re̠di̠ bho̠ na̠ ina̠ bho̠ a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠ o̠ru̠gi̠ onigha̠ ko̠ni̠ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sa̠ eb̠la̠ awa id̠e ilegha̠n, ");
INSERT INTO mgj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","sa̠ ogbo atu̠ghan bho̠ ikokod̠i ma̠ i̠pe̠re̠pe̠r abe̠re̠di̠ na̠ ina̠ ya̠ isugho bho̠, sa̠ imuzo ma̠ d̠iobh na̠ i̠wal (12) a̠rukpuom. ");
INSERT INTO mgj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","O̠nu̠ ilobhiri a̠nwunom ya̠ id̠e ani̠ ma̠ ed̠ia̠n bho̠, ilei d̠iobh na̠ i̠wal o̠ni̠r na̠ ogho e̠wala (5,000). ");
INSERT INTO mgj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","O̠tu̠o̠no̠m i̠se̠, sa̠ A̠zizo̠s a̠nugi ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠ od̠igh d̠a̠ oghugh od̠ia̠ ob̠etina̠ o̠gi̠ d̠a̠ Abe̠tsai̠da d̠a̠ aku̠b̠o̠ o̠bhi̠i̠y eko bho̠, ya̠a̠ i̠na ta̠ aro̠ a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ oyeleghu. ");
INSERT INTO mgj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Igiel bho̠ a̠nwunom bho̠ na̠ eyeleghu bho̠, sa̠ i̠na asi̠n igu ka̠ a̠d̠igh a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","D̠a̠ a̠dule a̠d̠a̠ma̠ obha̠, ma̠ igiel ola̠ oghugh bho̠ na̠ a̠misi d̠a̠ esa̠d̠io o̠bhi̠i̠y eko bho̠, bha̠ A̠zizo̠s ku̠ku̠m od̠id̠ia̠ d̠a̠ egbolom. ");
INSERT INTO mgj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sa̠ i̠na abi̠gh ka̠ ogbo atu̠ghan d̠o̠yo̠ na̠ e̠gbaghala ma̠ i̠d̠o̠m, ezin bho̠ awa i̠zo̠ghu̠ na̠ e̠dama ma̠ okukugh bho̠. D̠a̠ ame̠ghe̠le̠, sa̠ A̠zizo̠s a̠rile d̠a̠ anyu̠ amu̠m agi̠ ka̠ ate̠i̠ awa, sa̠ a̠ru ra̠ orile oten. ");
INSERT INTO mgj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ya̠a̠, igiel bho̠ awa i̠bi̠gh ka̠ i̠na na̠ a̠rile d̠a̠ anyu̠ amu̠m bho̠, sa̠ awa i̠ru̠ru̠an ma̠a̠ awa na̠ e̠bi̠gh egua̠de, sa̠ awa ikpogion izul imulughu. ");
INSERT INTO mgj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A̠rugugu isibh ko̠ni̠ko̠ni̠ ma̠ igiel bho̠ awa i̠bi̠gh i̠na bho̠. Sa̠ A̠zizo̠s anu̠r agba a̠nigha awa ma̠a̠, “I̠kpo̠me̠ni̠ ma̠ rologi d̠inyin! Ami̠-o! O̠ni̠ ko oghil a̠rugugu!” ");
INSERT INTO mgj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sa̠ i̠na a̠pel a̠d̠igh d̠a̠ oghugh wa̠ awa od̠i bho̠, sa̠ okukugh bho̠ a̠kugh a̠kunugiom. Sa̠ id̠igh ilologia̠n ma̠ ogbo atu̠ghan bho̠ ma̠ ibom, ");
INSERT INTO mgj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ezin bho̠ awa ta̠ orue d̠o̠ ma̠ obhin ogir ilologia̠n wa̠ ina̠ a̠b̠uyumeni ma̠ abe̠re̠di̠ bho̠, o̠mu̠gho̠nyan e̠mi̠ a̠limon ya̠ i̠na a̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I̠nye̠n iten, sa̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ i̠b̠e̠i̠ ka̠ isul d̠a̠ aku̠b̠o̠, d̠a̠ Age̠ne̠sare̠t. ");
INSERT INTO mgj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Igiel bho̠ awa ipel ibhun d̠a̠ egbolom bho̠, sa̠ a̠nwunom ilelegi epa̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sa̠ a̠nwunom bho̠ ighil igir eb̠la̠ ebhugh bho̠ ka̠ i̠gba inigha̠ ma̠ ipa̠n ogbo. Sa̠ a̠nwunom irod̠i d̠a̠ ra̠kporokporo ma̠ ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ ka̠ i̠te̠i̠ i̠na kesikesi ola̠ i̠na a̠misi. ");
INSERT INTO mgj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kesikesi ola̠ A̠zizo̠s a̠misi, a̠d̠igh o̠gbara e̠ma, bo̠d̠o̠ d̠a̠ obom e̠ma, bo̠d̠o̠ d̠a̠ re̠sala ari̠si̠, a̠nwunom ibhin ogbo asu̠nwe̠r e̠gi̠ ka̠ e̠te̠i̠ i̠na d̠a̠ regbolom a̠b̠ua̠, ma̠ i̠na ma̠ okoko. Sa̠ awa i̠le̠gh i̠na ma̠ oma̠ra̠ agu̠o̠ ola̠ ogbo asu̠nwe̠r bho̠ ta̠ ekula̠n bebina̠ akapa anyu̠ d̠o̠yo̠, d̠a̠ esi bho̠ u̠labh bho̠. Sa̠ eb̠la̠ ogbo ya̠ ikula̠n i̠na bho̠ id̠um. ");
INSERT INTO mgj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sa̠ Rafarisi bho̠ na̠ idi i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ i̠d̠u̠a d̠a̠ A̠zeruse̠le̠m iru ra̠ ikokod̠ia̠n sa̠ i̠te̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sa̠ awa i̠bi̠gh ma̠, idi ogbo atu̠ghan d̠o̠yo̠ ibhin aru̠gu̠o̠ ya̠ o̠b̠ab̠ala d̠o̠ na̠ ed̠e ma̠ ed̠ia̠n, o̠ku̠a bha̠ awa ititila̠ d̠o̠ ma̠ aru̠gu̠o̠ kisa̠ na̠ ed̠e. ");
INSERT INTO mgj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ya̠a̠, Rafarisi bho̠ na̠ eb̠la̠ ogbo A̠zu bho̠ id̠egha̠n d̠o̠ ma̠ ed̠ia̠n ku̠gba ma̠ awa i̠mar d̠o̠ etitila̠ ma̠ aru̠gu̠o̠ d̠awa. Awa na̠ esibhom i̠to̠to̠gi̠ ibom ro̠we̠de̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ka̠ awa i̠d̠u̠a d̠a̠ esi a̠b̠ua̠ iru, ka̠ awa otitila̠ d̠o̠ ma̠ aru̠gu̠o̠ ma̠ agu̠o̠ awa na̠ egirghan bho̠, awa id̠e d̠o̠ ma̠ ed̠ia̠n. Sa̠ isibhom ipa̠n a̠d̠izo i̠di̠ar iya̠ awa i̠tu̠ghan d̠a̠ i̠to̠to̠gi̠ bho̠, iya̠ i̠ro̠ ma̠ agu̠o̠: otitol rokpa̠ko amu̠m, oloko amu̠m, ra̠sugh e̠ko̠lo̠gho̠l amu̠m. ");
INSERT INTO mgj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sa̠ Rafarisi bho̠ na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠ ipura̠n i̠na ma̠a̠, “Ezin kere ma̠ ola̠ ogbo atu̠ghan d̠oyom o̠tu̠o̠no̠m d̠o̠ ma̠ i̠to̠to̠gi̠ ibom ro̠we̠de̠ bho̠, sa̠ na̠ ebhin aru̠gu̠o̠ ya̠ o̠b̠ab̠ala d̠o̠ na̠ ed̠e ma̠ ed̠ia̠n?” ");
INSERT INTO mgj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sa̠ i̠na awo̠ran awa ma̠a̠, “Azaya a̠wa̠ ga̠i a̠gboloma̠ inyin, ma̠ inyin ribhelebhel, ma̠ agu̠o̠ u̠ge̠ uguri bho̠ ma̠a̠, “ ‘A̠nwunom i̠nye̠n na̠ ebhin aru̠nu̠ d̠awa na̠ edoni ami̠, ya̠a̠ rologi d̠awa esigima̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awa na̠ e̠ko̠l ami̠ ma̠ obhobho i̠kpo̠, sa̠ na̠ e̠tu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠ iya̠ o̠nyi̠o̠mo̠ro̠ni̠.’ ");
INSERT INTO mgj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Inyin ubhin d̠o̠ ma̠ oloko ta̠ A̠zib̠a̠ o̠tu̠o̠m abar, sa̠ inyin na̠ o̠tu̠o̠no̠m ku ma̠ i̠to̠to̠gi̠ ta̠ o̠nyi̠o̠mo̠ro̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sa̠ i̠na ab̠aram agba ma̠a̠, “Inyin o̠mar ologhom agu̠o̠ oguri roloko ta̠ A̠zib̠a̠ d̠a̠ aka, b̠o̠ka̠ inyin omutiom ita̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A̠mozizi agba ma̠a̠, izuruna̠ ma̠ eghoi enigha̠ ma̠ onweni na̠ o̠we̠de̠ d̠inyin, sa̠ o̠ni̠ ola̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ onweni bo̠d̠o̠ o̠we̠de̠ d̠o̠yo̠ bha̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ya̠a̠ inyin na̠ ogba ma̠a̠, ku̠gba ma̠ o̠ni̠ a̠fugh a̠nigha̠ ma̠ oweni bo̠d̠o̠ o̠we̠de̠ d̠o̠yo̠ ma̠a̠, ‘Kere kere e̠ne̠ghe̠ ola̠ inyin ka̠ u̠te̠i̠ d̠a̠ agu̠o̠ d̠ami̠ ma̠ e̠ne̠ghe̠ e̠tu̠tu̠ ola̠ A̠zib̠a̠,’ ");
INSERT INTO mgj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","inyin uma̠ra̠ mu ma̠ awa egir abar enigha̠ ma̠ onweni bo̠d̠o̠ o̠we̠de̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Inyin na̠ orughom ikpo a̠fugh ta̠ A̠zib̠a̠ wokuma̠ a̠limon bo̠, ma̠ ola̠ inyin na̠ obhin i̠to̠to̠gi̠ d̠inyin na̠ onigha̠ ma̠ anwi̠i̠ny o̠gu̠man bho̠, sa̠ inyin na̠ ogir a̠d̠izo i̠di̠ar iya̠ i̠gu̠b̠an o̠ku̠a.” ");
INSERT INTO mgj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sa̠ a̠mula̠ a̠kokod̠i ma̠ o̠lo̠gh a̠nwunom bho̠ agba a̠nigha̠ awa ma̠a̠, “I̠mare̠ ma̠ e̠nagha ami̠, kere kere o̠ni̠, ma̠a̠ e̠mu̠gho̠nyan. ");
INSERT INTO mgj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Abar ola̠ na̠ ad̠u̠a d̠a̠ etire na̠ a̠d̠igh d̠a̠ ozu o̠nyi̠o̠mo̠ro̠ni̠ d̠o̠ na̠ api̠e̠ ma̠ o̠ni̠, kpe̠le̠me̠ni̠ bha̠ iya̠ na̠ e̠d̠u̠a d̠a̠ o̠ni̠ na̠ emite bho̠ na̠ e̠pi̠e̠ ma̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","O̠ni̠ ola̠ a̠nwuna̠ ma̠ a̠to, amar amu̠gho̠n o!” ");
INSERT INTO mgj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sa̠ igiel bho̠ i̠na ad̠u̠a d̠a̠ o̠lo̠gh a̠nwunom bho̠ ka̠ a̠d̠igh d̠a̠ otu bho̠, sa̠ ogbo atu̠ghan d̠o̠yo̠ ipura̠n i̠na igboloma̠ ma̠ a̠sidogh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sa̠ i̠na awo̠ran awa ma̠a̠, “Inyin u̠mu̠gho̠nyan d̠o̠ nyen ke̠re̠? I̠mu̠gho̠nyane̠ ma̠a̠, kabar kabar ola̠ na̠ ad̠u̠a d̠a̠ etire na̠ a̠d̠igh d̠a̠ ozu o̠ni̠ d̠o̠, ma̠ ola̠ ta̠ a̠rue api̠e̠ ma̠ o̠ni̠? ");
INSERT INTO mgj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ezin bho̠ na̠ od̠igh d̠o̠ d̠a̠ ekpo ologi bho̠, ya̠a̠ d̠a̠ okurogh, sa̠ na̠ a̠ten ati̠n na̠ a̠mite na̠ ad̠u̠a.” (O̠ku̠a bha̠, A̠zizo̠s agba a̠soroni ma̠a̠, eb̠la̠ ed̠ia̠n e̠b̠ab̠ala.) ");
INSERT INTO mgj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sa̠ agba alo̠gho̠m ma̠a̠: “Abar wa̠ na̠ ad̠u̠a d̠a̠ o̠ni̠ na̠ a̠mite bho̠, bha̠ wa̠ na̠ api̠e̠ ma̠ o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ezin bho̠ na̠ ad̠u̠a d̠a̠ ologi bho̠, d̠a̠ ekpo ologi o̠ni̠ bho̠ na̠ emite: i̠karabh i̠ru̠ru̠an, ari̠gi̠, a̠b̠igh, ogigh o̠ni̠, ");
INSERT INTO mgj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","od̠e e̠ma d̠a̠ ilom, o̠ku̠ku̠, igurumia̠n ologi, igelemeni, ipesi, a̠gbokia̠n, o̠gba o̠ni̠ o̠pi̠e̠, i̠re̠ma (obhuneni, o̠bu̠ghu̠me̠ni̠ ozu), ema̠ (esusula̠). ");
INSERT INTO mgj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eb̠la̠ i̠karabh i̠nye̠n na̠ e̠d̠u̠a d̠a̠ ologi na̠ emite sa̠ na̠ e̠pi̠e̠ ma̠ o̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A̠zizo̠s ad̠u̠a ma̠ i̠se̠ agi̠ d̠a̠ ebhugh Ataya sa̠ a̠d̠igh d̠a̠ otu ya̠a̠ i̠na na̠ o̠bho̠ro̠ghan d̠o̠ ma̠ o̠ni̠ a̠loghom, ya̠a̠ i̠na na̠ orue d̠o̠ ma̠ o̠wo̠gi̠na. ");
INSERT INTO mgj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kpe̠le̠me̠ni̠, ani̠ ola̠ o̠karabh e̠mu̠gh a̠nyegi ma̠ o̠nyani̠ bho̠ amu̠gho̠n bho̠, sa̠ a̠ru ra̠ a̠mel agu̠ran d̠a̠ a̠sike d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ani̠ bho̠ ola̠ A̠zu d̠o̠, ya̠a̠ ola̠ A̠fonisia̠ d̠a̠ ebhugh A̠siria̠, sa̠ ale̠gh A̠zizo̠s ma̠ oze o̠karabh e̠mu̠gh bho̠ o̠si̠ghe̠ d̠a̠ ozu o̠nyani̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Anwi̠i̠ny bho̠ ed̠ia̠ ed̠e elegha̠n, na̠ osora̠n d̠o̠ ma̠ obhin ed̠ia̠n anwi̠i̠ny bho̠ orobhod̠i onigha̠ a̠sib̠ogho.” ");
INSERT INTO mgj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sa̠ ani̠ bho̠ awo̠ran i̠na ma̠a̠, “Wa̠nwuna̠, a̠sib̠ogho ya̠ na̠ e̠ro̠ d̠a̠ ekpukpu akpata od̠e bho̠ eka̠ na̠ ed̠e ma̠ i̠pe̠re̠pe̠r ya̠ na̠ e̠d̠u̠a d̠a̠ anwi̠i̠ny bho̠ na̠ emeleghu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sa̠ i̠na agba a̠nigha̠ ma̠ ani̠ bho̠ ma̠a̠, “D̠a̠ ebula̠ awo̠ran d̠oyom, gi̠e̠, o̠karabh e̠mu̠gh bho̠ na̠ a̠mite d̠a̠ ozu o̠nyani̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sa̠ i̠na agi̠ d̠a̠ otu d̠o̠yo̠ ka̠ abi̠gh ka̠ o̠nyani̠ bho̠ na̠ amanaghan d̠a̠ e̠mana, sa̠ abi̠gh nyen ma̠ o̠karabh e̠mu̠gh bho̠ na̠ a̠mite d̠a̠ ozu o̠nyani̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sa̠ A̠zizo̠s a̠mula̠ ad̠u̠a d̠a̠ eghighira̠ Ataya agi̠ d̠a̠ agba A̠sido̠n d̠a̠ abadi̠ Agalili wa̠ a̠tua̠n Ebhugh A̠d̠iobh Re̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sa̠ idi a̠nwunom ibhin o̠b̠aghab̠agh o̠ni̠ ola̠ orue d̠o̠ ma̠ o̠mar ofugh a̠fugh iru ra̠ i̠te̠i̠ i̠na, i̠le̠gh agu̠o̠ ola̠ i̠na ta̠ agbam agu̠o̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sa̠ A̠zizo̠s a̠bhin i̠na d̠a̠ o̠lo̠gh a̠nwunom bho̠ a̠ten d̠a̠ aka, sa̠ azo̠l asu̠nu̠ aru̠gu̠o̠ d̠o̠yo̠ d̠a̠ ra̠to o̠ni̠ bho̠, sa̠ asi̠r i̠gho̠r d̠a̠ ad̠u̠nu̠ agu̠o̠ a̠bhin a̠kula̠n a̠nem o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sa̠ A̠zizo̠s a̠b̠eka̠ a̠kpon d̠a̠ ote̠nai̠ny afi̠o̠ghu̠, sa̠ a̠fugh ma̠a̠, “E̠fata!” (a̠ma̠ra̠ ma̠a̠, “Guruna̠!” ) ");
INSERT INTO mgj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sa̠ ra̠to o̠ni̠ bho̠ iguruna̠ epa̠, sa̠ abar wa̠ na̠ a̠sibhom a̠nem d̠o̠yo̠ ako̠ti̠na, sa̠ i̠na a̠fugh abar geregere. ");
INSERT INTO mgj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa̠ A̠zizo̠s aghaghana ma̠ a̠nwunom bho̠ ma̠a̠, awa o̠gba d̠o̠ ma̠ iya̠ imite bho̠ e̠sasaragi̠, ya̠a̠ agu̠o̠ i̠na na̠ a̠bhin aghaghana awa bho̠, bha̠ agu̠o̠ awa ibhin i̠gba i̠sasaragi̠. ");
INSERT INTO mgj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa̠ a̠d̠igh ilologia̠n a̠nwunom. Sa̠ awa i̠gba ma̠a̠, “I̠na na̠ amar a̠gir eb̠la̠ i̠di̠ar. Remua̠ bho̠ na̠ efugh a̠fugh, sa̠ i̠b̠aghab̠agh bho̠ na̠ e̠mu̠gho̠n abar.” ");
INSERT INTO mgj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","D̠a̠ obhel obha̠, obom o̠lo̠gh a̠nwunom emula̠ ekokod̠ia̠n na̠ i̠na, ma̠ ola̠ abar ola̠ awa ta̠ ed̠e na̠ o̠ro̠ d̠o̠, sa̠ i̠na a̠bhelegi ma̠ ogbo atu̠ghan bho̠ agba a̠nigha̠ awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Igbirigbir a̠nwunom bho̠ na̠ ed̠ighi ami̠, ezin bho̠ awa na̠ e̠ro̠ na̠ ami̠ i̠sar a̠d̠a̠ma̠, sa̠ unwuna̠ d̠o̠ ma̠ abar ola̠ awa ta̠ ed̠e. ");
INSERT INTO mgj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ku̠gba ma̠ ami̠ a̠ruom awa ma̠ oyel o̠ko̠i̠, bha̠ idi ta̠ e̠fu̠mu̠ d̠a̠ eten bho̠. Idi awa i̠d̠u̠a ma̠ esi egbeiny eru.” ");
INSERT INTO mgj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠wo̠ran i̠na ma̠a̠, “I̠yar ta̠ orue o̠te̠i̠ ed̠ia̠n d̠a̠ a̠ken, d̠a̠ esi ola̠ kukunum o̠ko̠no̠n, ma̠ ola̠ ta̠ elei awa ma̠ od̠e?” ");
INSERT INTO mgj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin unwuna̠ ma̠ i̠ni̠ ikpokpogh abe̠re̠di̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “Od̠ua̠l.” ");
INSERT INTO mgj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sa̠ i̠na a̠ruom o̠lo̠gh a̠nwunom bho̠ ma̠ e̠ro̠ ma̠ a̠dila̠de d̠a̠ a̠de, sa̠ i̠na a̠bhin od̠ua̠l ikpogh abre̠di̠ bho̠, sa̠ a̠nigha̠ ma̠ ali̠se̠bh A̠zib̠a̠, sa̠ a̠pupugion a̠nigha̠ ma̠ ogbo atu̠ghan bho̠ ma̠ o̠ru̠gi̠, sa̠ awa i̠ru̠gi̠ inigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","O̠nyi̠ki̠kara i̠gbara ina̠ e̠ro̠, sa̠ i̠na a̠tutumeni a̠ruom awa nyen o̠ru̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sa̠ awa id̠e, sa̠ id̠e ilegha̠n. Ogbo atu̠ghan bho̠ ikpokpo ma̠ i̠pe̠re̠pe̠r isughia̠n bho̠, bha̠ ilei od̠ua̠l a̠rukpuom. ");
INSERT INTO mgj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A̠nwunom bho̠ ilei agu̠o̠ d̠iobh o̠ni̠r (4,000) o̠ni̠, sa̠ i̠na a̠ruom awa ma̠ oten oyel. ");
INSERT INTO mgj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sa̠ i̠na a̠d̠igh d̠a̠ oghugh na̠ ogbo atu̠ghan d̠o̠yo̠, sa̠ i̠gi̠ d̠a̠ ebhugh Adalmanuta. ");
INSERT INTO mgj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sa̠ Rafarisi bho̠ iru sa̠ i̠ke̠ ma̠ o̠ku̠anan o̠yo̠. D̠a̠ agu̠o̠ ola̠ o̠d̠a o̠yo̠ okpon, sa̠ awa ipuru ma̠ i̠na a̠leriom elegh ola̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru. ");
INSERT INTO mgj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sa̠ i̠na afi̠o̠ghu̠ ma̠ ibom d̠a̠ e̠mu̠gh a̠pura̠n ma̠a̠, “Ezin ka̠ ere ma̠ ola̠ amu̠m onon na̠ epuru ma̠ elegh bho̠? Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ elegh ola̠ ta̠ onigha̠ ma̠ amu̠m onon bo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sa̠ i̠na awe̠le̠man awa ad̠u̠a ka̠ a̠d̠igh d̠a̠ oghugh ab̠e̠i̠ d̠a̠ agba uwed̠i. ");
INSERT INTO mgj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Awa iweleta̠n obhin ed̠ia̠n, a̠sigimeni ma̠ onin ekpokpogh abe̠re̠di̠ ola̠ awa inwuna̠ d̠a̠ oghugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sa̠ A̠zizo̠s a̠kikiom awa agba ma̠a̠, “Ilelegi, ma̠ ekpona̠ ma̠ a̠yist ta̠ Rafarisi bho̠ na̠ a̠yist ta̠ E̠ro̠d.” ");
INSERT INTO mgj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sa̠ awa id̠igh i̠b̠e̠re̠gi̠an ma̠a̠, “Agu̠o̠ i̠yar onwuna̠ d̠o̠ ma̠ ed̠ia̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ya̠a̠, A̠zizo̠s amu̠gho̠nyan, sa̠ a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere ma̠ ola̠ inyin na̠ o̠b̠e̠re̠gi̠an ogboloma̠ ma̠ agu̠o̠ onwuna̠ d̠o̠ ma̠ ed̠ia̠n bho̠? I̠se̠n eka̠ bha̠ inyin ta̠ o̠bi̠gh d̠o̠ o̠mu̠gho̠nyan ke̠re̠? Rologi d̠inyin ta̠ okperina̠ d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ikpo a̠rid̠ien od̠i inyin, ya̠a̠ inyin urue d̠o̠ ma̠ o̠bi̠gh abar ke̠re̠? Ra̠to od̠i inyin, ya̠a̠ inyin urue d̠o̠ ma̠ o̠mu̠gho̠n abar ke̠re̠? Inyin urue d̠o̠ ma̠ o̠ru̠ru̠an ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Obhel bho̠ ami̠ ipuinyogh ogho ikpokpogh abe̠re̠di̠ inigha̠ ma̠ d̠iobh na̠ i̠wal o̠ni̠r na̠ ogho e̠wala (5,000) o̠nu̠ a̠nwunom bho̠, ka̠ i̠ni̠ a̠rukpuom i̠pe̠re̠pe̠r isughia̠n ya̠ inyin ukpokpo?” Sa̠ awa i̠wo̠ran ma̠, “D̠iobh na̠ i̠wal.” ");
INSERT INTO mgj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Obhel bho̠ ami̠ ibhin od̠ua̠l ikoko ma̠ d̠iobh o̠ni̠r bho̠, ka̠ inyin ukpokpo ma̠ i̠ni̠ a̠rukpuom i̠pe̠re̠pe̠r isughia̠n?” Sa̠ awa i̠wo̠ran ma̠a̠, “Od̠ua̠l.” ");
INSERT INTO mgj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin ta̠ o̠mu̠gho̠nyan d̠o̠ nyen, ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sa̠ awa iten i̠gi̠ d̠a̠ Abe̠tsai̠da. Sa̠ idi a̠nwunom ibhin o̠ni̠ ikpom a̠rid̠ien iru ra̠ i̠le̠gh i̠na ma̠ okula̠n o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sa̠ i̠na a̠sibh o̠ni̠ bho̠ d̠a̠ agu̠o̠ a̠rileghom ad̠u̠a d̠a̠ e̠ma bho̠, asi̠r i̠gho̠r d̠a̠ a̠rid̠ien o̠ni̠ bho̠, a̠bhin aru̠gu̠o̠ d̠o̠yo̠ a̠puom a̠rid̠ien o̠ni̠ bho̠, sa̠ a̠pura̠n i̠na ma̠a̠, “Anwa na̠ abi̠gh abar ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sa̠ i̠na a̠b̠eka̠ a̠kpon d̠a̠ anyu̠, sa̠ awo̠ran ma̠a̠, “Ami̠ na̠ abi̠gh a̠nwunom agu̠o̠ iriren iya̠ na̠ erile.” ");
INSERT INTO mgj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sa̠ A̠zizo̠s a̠puta̠ a̠bhin aru̠gu̠o̠ d̠o̠yo̠ a̠puom a̠rid̠ien o̠ni̠ bho̠. Sa̠ o̠ni̠ bho̠ a̠kimigi a̠kpon, sa̠ a̠rid̠ien bho̠ imula̠ ibhon, sa̠ amar abi̠gh eb̠la̠ i̠di̠ar geregere. ");
INSERT INTO mgj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa̠ A̠zizo̠s a̠ruom i̠na ma̠a̠, i̠na a̠yel d̠a̠ otu d̠o̠yo̠, sa̠ aghaghana i̠na ma̠a̠, “Ko od̠igh mu d̠a̠ e̠ma bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sa̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ i̠d̠u̠a i̠gi̠ d̠a̠ re̠ma A̠sizeria̠ A̠filipai̠ bho̠. Agu̠o̠ awa na̠ e̠gi̠ bho̠ sa̠ i̠na a̠pura̠n ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “A̠nwunom na̠ e̠gba ma̠ ami̠ ka̠ a̠kere a̠d̠ien o̠ni̠?” ");
INSERT INTO mgj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sa̠ awa i̠gba inigha̠ i̠na ma̠a̠, “Azo̠n owurmamu̠m bho̠; ipa̠n ma̠a̠, I̠lai̠za; ya̠a̠ idi na̠ e̠gba ma̠a̠, odi owil bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ya̠a̠ inyin na̠ o̠gba ma̠ ami̠ ka̠ a̠kere a̠d̠ien o̠ni̠?” Sa̠ A̠puta̠ agba a̠mutiom ma̠a̠, “Anwa Akrai̠st.” ");
INSERT INTO mgj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sa̠ A̠zizo̠s aghaghana awa ma̠a̠, awa obhin d̠o̠ ma̠ iya̠ igboloma̠ i̠na e̠gba enigha̠ ma̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sa̠ A̠zizo̠s ake̠ ma̠ o̠tu̠ghu̠me̠ni̠ awa ma̠ agu̠o̠ akpe̠ ma̠ O̠nyi̠ ta̠ O̠ni̠ ma̠ ogbika̠ d̠a̠ a̠d̠izo i̠di̠ar, sa̠ ikei bho̠ na̠ aru̠mu̠ rokur bho̠, na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ ta̠ eghel i̠na, sa̠ ta̠ egigh i̠na, sa̠ ka̠ i̠sar a̠d̠a̠ma̠ na̠ eten, sa̠ i̠na ta̠ a̠b̠etina̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sa̠ agu̠o̠ i̠na na̠ agba ma̠ i̠nye̠n na̠ asi̠si̠ghe̠ni̠ bho̠, sa̠ A̠puta̠ a̠bhin i̠na ma̠ o̠nu̠ ma̠a̠, i̠na ofugh d̠o̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sa̠ i̠na a̠tiba̠ra̠ a̠kpon ogbo atu̠ghan d̠o̠yo̠, sa̠ awo̠ran A̠puta̠ ab̠ab̠agi̠na ma̠a̠, “Eru bho̠, tene d̠a̠ aman d̠ami̠! Ezin bho̠ anwa na̠ obhin d̠o̠ ma̠ i̠di̠ar ta̠ A̠zib̠a̠ atu̠o̠m abar, ya̠a̠ iya̠ igboloma̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sa̠ i̠na a̠kokod̠i ma̠ o̠lo̠gh a̠nwunom bho̠ na̠ ogbo atu̠ghan d̠o̠yo̠ agba a̠nigha̠ awa ma̠a̠: “O̠ni̠ ola̠ na̠ ebhir o̠tu̠o̠no̠m ami̠ ta̠ aku̠a ma̠ ozu d̠o̠yo̠ aman, sa̠ ta̠ a̠b̠eton e̠mi̠gi̠re̠ni̠an oriren d̠o̠yo̠ atu̠o̠no̠m ami̠. ");
INSERT INTO mgj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","O̠ni̠ wa̠ ato̠ma ma̠ okighom a̠ghud̠um e̠mara̠nwunom d̠o̠yo̠ bho̠, ta̠ a̠robh a̠ghud̠um d̠o̠yo̠, ya̠a̠ o̠ni̠ wa̠ a̠ma̠ra̠ ma̠ orobh a̠ghud̠um e̠mara̠nwunom d̠o̠yo̠ d̠a̠ ebula̠ ami̠ na̠ ebula̠ asu̠gbagba bho̠, ta̠ ate̠i̠ a̠ghud̠um kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asu̠o̠ bho̠ ka̠ ere, ka̠ o̠ni̠ ate̠i̠ eb̠la̠ e̠mara̠nwunom onon, sa̠ a̠robh a̠ghud̠um d̠o̠yo̠? ");
INSERT INTO mgj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ere ta̠ a̠lei o̠ni̠ ma̠ obhin onwegia̠n a̠ghud̠um d̠o̠yo̠? ");
INSERT INTO mgj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","O̠ni̠ ola̠ a̠din ami̠ na̠ atu̠ghu̠me̠ni̠ d̠ami̠ a̠d̠igh ari̠ghe̠l d̠a̠ amu̠m onon wa̠ od̠umom d̠a̠ ma̠ A̠zib̠a̠ bho̠, na̠ erugh i̠karabh ado̠l bho̠, O̠nyi̠ ta̠ O̠ni̠ eka̠ ta̠ a̠din i̠na a̠d̠igh ari̠ghe̠l ma̠ obhel itileduom e̠tu̠tu̠ bho̠ ta̠ ed̠igh na̠ i̠na eru d̠a̠ isosorogia̠n ta̠ O̠we̠de̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠ idi inyin ya̠ i̠mara ma̠ i̠se̠n bho̠ ko omugh d̠o̠ tu̠tu̠n awa ta̠ e̠bi̠gh ka̠ irileghom ta̠ A̠zib̠a̠ ná̠ a̠ru na̠ a̠limon.” ");
INSERT INTO mgj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Odin a̠d̠a̠ma̠ iten, sa̠ A̠zizo̠s a̠bhin A̠pita̠, na̠ A̠zemsi na̠ Azo̠n asi̠n igu ola̠ agi̠ ma̠ anyu̠, d̠a̠ esi ola̠ awa ku̠ku̠m i̠ro̠. I̠se̠ sa̠ ozu d̠o̠yo̠ a̠nwegia̠n d̠a̠ a̠misigh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sa̠ ibura̠ d̠o̠yo̠ i̠b̠al, i̠mu̠, isosorogia̠n ka̠ i̠te̠i̠ esi ola̠ bebina̠ o̠ni̠ ola̠ od̠i d̠a̠ a̠de onon ola̠ ta̠ a̠rue ab̠ab̠alame̠ni̠ ma̠ o̠ku̠a bo̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sa̠ I̠lai̠za na̠ A̠mozizi imite ma̠ i̠se̠ ra̠ id̠igh na̠ A̠zizo̠s i̠b̠e̠re̠gi̠an. ");
INSERT INTO mgj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sa̠ A̠pita̠ a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “Wa̠nwuna̠, agu̠o̠ a̠bhon i̠yar o̠ro̠ i̠se̠n! D̠ighi i̠yar ogim i̠sar a̠rutu akpu̠ru̠: odi ta̠ aro̠ ma̠ ola̠ oyom, odi ta̠ aro̠ ma̠ ola̠ A̠mozizi, sa̠ odi ta̠ aro̠ ma̠ ola̠ I̠lai̠za.” ");
INSERT INTO mgj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ezin bho̠ a̠rugugu isibh awa ka̠ e̠te̠i̠ esi ola̠ A̠pita̠ ologhom d̠o̠ ma̠ abar ola̠ ofugh). ");
INSERT INTO mgj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sa̠ o̠b̠u̠ghu̠b̠u̠gh a̠kpegiom awa. Sa̠ okoroko a̠si d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ ma̠a̠, “Onon O̠nyi̠ etula̠n d̠ami̠. I̠nagha i̠na!” ");
INSERT INTO mgj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","D̠a̠ awai̠, sa̠ awa i̠bi̠gh ka̠ A̠zizo̠s ku̠ku̠m od̠i ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Agu̠o̠ awa na̠ esor d̠a̠ anyu̠ igu bho̠, sa̠ A̠zizo̠s aghaghana awa ma̠a̠, awa o̠gba d̠o̠ ma̠ iya̠ awa i̠bi̠gh bho̠ enigha̠ bebina̠ o̠ni̠, a̠ten ka̠ O̠nyi̠ ta̠ O̠ni̠ na̠ a̠b̠etina̠ d̠a̠ omugh. ");
INSERT INTO mgj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sa̠ awa ikighom abar bho̠ d̠a̠ rologi d̠awa, sa̠ awa iguri i̠b̠e̠re̠gi̠an igboloma̠ ma̠ abar wa̠ “Ob̠etina̠ d̠a̠ omugh” a̠ma̠ra̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sa̠ awa ipura̠n i̠na ma̠a̠, “Ere wa̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ e̠gba ma̠ I̠lai̠za ta̠ a̠d̠ia̠ a̠ru bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sa̠ i̠na awo̠ran ma̠a̠, “Ya̠gia̠ga̠i, I̠lai̠za ta̠ a̠d̠ia̠ a̠ru, ra̠ a̠selegi ma̠ eb̠la̠ i̠di̠ar. Ere wa̠ u̠ge̠ ma̠a̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠gbika̠ ma̠ ibom sa̠ ta̠ oghel bho̠? ");
INSERT INTO mgj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠; I̠lai̠za a̠ru, sa̠ awa ikpon abar abar igir igboloma̠ i̠na ma̠ agu̠o̠ A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠ ta̠ emutuma̠ i̠na bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa̠ awa iru d̠a̠ ogbo atu̠ghan iyed̠i, sa̠ i̠bi̠gh obom o̠lo̠gh a̠nwunom ya̠ na̠ eko awa ikiton, ya̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠ na̠ e̠ku̠anan awa. ");
INSERT INTO mgj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","I̠se̠, sa̠ eb̠la̠ o̠lo̠gh a̠nwunom bho̠ i̠bi̠gh i̠na sa̠ id̠igh awa ma̠ ilologia̠n ma̠ o̠bi̠gh o̠yo̠, sa̠ ikpo ma̠ eghil ka̠ ibheleguma̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sa̠ A̠zizo̠s a̠pura̠n o̠lo̠gh bho̠ ma̠a̠, “Inyin na̠ o̠ku̠anan awa ma̠ ere?” ");
INSERT INTO mgj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sa̠ o̠ni̠ ola̠ od̠i d̠a̠ o̠lo̠gh bho̠ agba ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, ami̠ ibhin o̠nyi̠ d̠ami̠ ola̠ e̠mu̠gh emua̠ na̠ anyo̠gho̠gh a̠ru d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ka̠ e̠mu̠gh bho̠ a̠puom i̠na, sa̠ na̠ agu̠ro̠m i̠na, sa̠ i̠na na̠ a̠fuko d̠a̠ o̠nu̠, na̠ aghi̠r ib̠ub̠ura̠, sa̠ eb̠la̠ ozu bho̠ na̠ a̠kpari̠an. Sa̠ ami̠ iruom ogbo atu̠ghan d̠oyom ma̠ oze o̠si̠ghe̠, ya̠a̠ irue d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sa̠ A̠zizo̠s awo̠ran a̠fugh ma̠a̠, “Sei! Amu̠m ologi ima̠ra̠ o̠to̠! Ami̠ ta̠ aro̠ na̠ inyin a̠bia̠ eka̠, kisa̠ inyin ta̠ oma̠ra̠? Ami̠ ta̠ a̠ne ma̠ ado̠l ologi ima̠ra̠ o̠to̠ d̠inyin a̠bia̠ eka̠? Ibhine ma̠ o̠nyi̠ bho̠ ma̠ eru.” ");
INSERT INTO mgj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sa̠ awa ibhin i̠na i̠gi̠. Agu̠o̠ o̠karabh e̠mu̠gh bho̠ abi̠gh A̠zizo̠s bho̠, sa̠ agu̠ro̠m epa̠ ma̠ o̠nyi̠ bho̠ d̠a̠ a̠de sa̠ o̠nyi̠ bho̠ asasalaghu̠, a̠kikila̠, a̠fuko ma̠ i̠gho̠r. ");
INSERT INTO mgj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sa̠ A̠zizo̠s a̠pura̠n o̠we̠de̠ o̠nyi̠ bho̠ ma̠a̠, “Abar onon ka̠ ake̠ ma̠ a̠kere obhel od̠ighi o̠yo̠?” Sa̠ o̠we̠de̠ bho̠ awo̠ran ma̠a̠, “Ake̠ d̠a̠ i̠gbara d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na̠ a̠robh gha̠n i̠na na̠ alo̠gh d̠a̠ anya na̠ d̠a̠ amu̠m ma̠ agu̠o̠ ola̠ ogigh o̠yo̠. O̠ku̠a eka̠, ku̠gba ma̠a̠ anwa ta̠ a̠rue a̠gir abar a̠gboloma̠, bha̠ kpone i̠yar igbirigbir ma̠ alo̠gh agu̠o̠ ma̠ a̠nigha̠ i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “Anwa i̠tu̠n ere na̠ a̠pura̠n ka̠ ‘anwa ta̠ a̠rue’? Ku̠gba ma̠a̠ anwa a̠nwuna̠ ma̠ ologi ima̠ra̠, kabar kabar ta̠ a̠rue a̠mite.” ");
INSERT INTO mgj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sa̠ o̠we̠de̠ o̠nyi̠ bho̠ awo̠ran ma̠a̠, “Ami̠ a̠d̠umom; ologi ima̠ra̠ d̠ami̠ olei d̠a̠ eka̠, bhe̠le̠ ami̠!” ");
INSERT INTO mgj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A̠zizo̠s ra̠ abi̠gh ma̠a̠, o̠lo̠gh a̠nwunom na̠ eghil na̠ eru bho̠, sa̠ i̠na ab̠ab̠agi̠na ma̠ o̠karabh e̠mu̠gh bho̠ a̠fugh ma̠a̠, “Anwa e̠mu̠gh emua̠ na̠ ab̠agh, ami̠ na̠ a̠mulughuom anwa, d̠u̠a d̠a̠ ozu o̠nyi̠ bho̠, ka̠ onyegi mu i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sa̠ e̠mu̠gh bho̠ a̠mulughu, sa̠ alo̠gh e̠mi̠ a̠nuoghom i̠na ma̠ o̠si̠si̠laghu̠, sa̠ a̠mite ad̠u̠a. Sa̠ o̠nyi̠ bho̠ aro̠ woma̠ na̠ a̠mugh, ma̠ ola̠ a̠d̠izo a̠nwunom i̠ru̠ru̠an ma̠ i̠na na̠ a̠mugh. ");
INSERT INTO mgj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ya̠a̠, A̠zizo̠s a̠sibh i̠na d̠a̠ agu̠o̠ a̠b̠eton, sa̠ amara. ");
INSERT INTO mgj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Igiel bho̠ A̠zizo̠s na̠ a̠d̠igh d̠a̠ otu bho̠, sa̠ ogbo atu̠ghan d̠o̠yo̠ ipura̠n i̠na d̠a̠ e̠wo̠gi̠na ma̠a̠, “Ere wa̠ i̠yar orue d̠o̠ ma̠ oze o̠karabh e̠mu̠gh bho̠ o̠si̠ghe̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ola̠ o̠ko̠no̠n ka̠ o̠d̠u̠a d̠o̠, a̠ten a̠siseiny.” ");
INSERT INTO mgj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̠zizo̠s ad̠u̠a ma̠ i̠se̠ agi̠ ma̠ esi ola̠ i̠na o̠bho̠ro̠ghan d̠o̠ ma̠ o̠ni̠ a̠loghom. I̠na awo̠l d̠a̠ Agalili, ");
INSERT INTO mgj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ezin bho̠ i̠na na̠ atu̠ghu̠me̠ni̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠ abar. Sa̠ agba a̠nigha̠ awa ma̠a̠, “Ta̠ owol O̠nyi̠ ta̠ O̠ni̠ onigha̠ ma̠ ogbo i̠to̠ ma̠ agu̠o̠ ola̠ ta̠ egigh, sa̠ ta̠ egigh i̠na. Sa̠ d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠ sa̠ ta̠ a̠b̠etina̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Awa i̠mu̠gho̠nyan d̠o̠ ma̠ iwowa̠ bho̠, ya̠a̠ ighil opura̠n o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Awa ka̠ i̠te̠i̠ d̠a̠ Akapani̠o̠m, sa̠ id̠igh d̠a̠ otu. Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Inyin u̠b̠e̠re̠gi̠an ere d̠a̠ eten bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ya̠a̠, awa i̠ro̠ b̠u̠b̠o̠m, ezin bho̠ awa i̠ku̠anan igboloma̠ ma̠ o̠ni̠ wa̠ abu̠gh a̠pu d̠a̠ o̠lo̠gh d̠awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sa̠ i̠na aro̠ ma̠ a̠dila̠de, sa̠ a̠bhelegi ma̠ a̠d̠iobh na̠ i̠wal bho̠ a̠fugh a̠nigha̠ awa ma̠a̠, “Ku̠gba ma̠ o̠ni̠ na̠ abho̠ro̠gh o̠ro̠ o̠pu̠r, bha̠ i̠na a̠d̠ia̠ aro̠ ma̠ wa̠ o̠gu̠man na̠ agu̠o̠ ob̠a̠ra̠motu ta̠ eb̠la̠ a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sa̠ A̠zizo̠s a̠bhin o̠gbara o̠nyi̠ amarame̠ni̠ d̠a̠ esa̠d̠io d̠awa, sa̠ a̠sibh agu̠o̠ bho̠ a̠fugh a̠ni̠gha̠ awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“O̠ni̠ ola̠ atu̠n a̠d̠ien d̠ami̠ ada ma̠ odi d̠a̠ i̠gbara anwi̠i̠ny i̠nye̠n a̠bhin, bha̠ ada ami̠ a̠bhin. O̠ni̠ ola̠ ada ami̠ a̠bhin, bha̠ na̠ o̠da d̠o̠ ka̠ ami̠ a̠bhin, ya̠a̠ o̠ni̠ wa̠ a̠ruom ami̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Azo̠n agba a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, i̠yar u̠bi̠gh ka̠ o̠ni̠ na̠ a̠bhin a̠d̠ien d̠oyom na̠ a̠ze ma̠ a̠ruru, sa̠ i̠yar ukigima̠ i̠na, ezin bho̠ i̠na bo̠ ani̠ d̠o̠ d̠a̠ o̠lo̠gh d̠i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ya̠a̠, A̠zizo̠s agba ma̠a̠, “O̠ni̠ ko okigima̠ i̠na, ezin bho̠ o̠ni̠ ola̠ a̠bhin a̠d̠ien d̠ami̠ a̠gir ilologia̠n ko o̠nu̠r d̠o̠ epa̠ a̠fugh i̠karabh a̠gboloma̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","O̠ni̠ ola̠ owia̠n d̠o̠ i̠yar bha̠ od̠i na̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ atu̠n a̠d̠ien ta̠ Akrai̠st a̠nigha̠ inyin okpa̠ko amu̠m ko o̠we̠le̠ d̠o̠ ma̠ o̠te̠i̠ amu̠kpe̠ d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","O̠gho̠ro̠gi̠o̠m o̠gbe̠o̠ma d̠a̠ orum o̠ni̠ orobh o̠ni̠ bho̠ d̠a̠ abadi̠, ta̠ a̠bhon a̠pu ma̠ alu̠kpe̠ ta̠ o̠ni̠ ola̠ a̠d̠ighi ma̠ odi o̠gbara o̠nyi̠ ola̠ a̠ma̠ra̠ ami̠, ma̠ omel od̠igh d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ku̠gba ma̠ agu̠o̠ d̠oyom na̠ a̠d̠ighi nyam omel o̠d̠u̠a d̠a̠ A̠zib̠a̠, sobhe ma̠ asi̠ghe̠. Anwa ma̠ obhin e̠gha ka̠ od̠igh d̠a̠ a̠ghud̠um kid̠ud̠ul a̠bhon a̠pu ma̠ obhin i̠wal aru̠gu̠o̠ o̠gi̠ ka̠ od̠igh d̠a̠ e̠banya, wa̠ ka̠ od̠im d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ku̠gba ma̠ a̠wel d̠oyom na̠ a̠d̠ighi nyam omel o̠d̠u̠a d̠a̠ A̠zib̠a̠, sobhe ma̠ asi̠ghe̠. Anwa ma̠ o̠ro̠ ukula̠ od̠igh d̠a̠ a̠ghud̠um kid̠ud̠ul a̠bhon a̠pu ma̠ onwuna̠ i̠wal a̠sike, sa̠ ta̠ orobh anwa o̠lo̠gh d̠a̠ e̠banya. ");
INSERT INTO mgj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ku̠gba ma̠ ekpo a̠d̠ien d̠oyom na̠ a̠d̠ighi nyam omel o̠d̠u̠a d̠a̠ A̠zib̠a̠, poko ma̠ asi̠ghe̠. Anwa ma̠ obhin onin ekpo a̠d̠ien od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠ a̠bhon a̠pu ma̠ owuna̠ i̠wal a̠rid̠ien, sa̠ ta̠ orobh anwa o̠lo̠gh d̠a̠ e̠banya, ");
INSERT INTO mgj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Esi wa̠ igbukuma̠ ya̠ na̠ ed̠e ma̠ a̠ruzu d̠awa bho̠ ko omugh d̠o̠, sa̠ anya bho̠ od̠im d̠o̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ta̠ obhin anya o̠sa ko̠ni̠ ko̠ni̠ o̠me̠me̠ni̠, ma̠ agu̠o̠ na̠ obhin ub̠on na̠ o̠me̠me̠ni̠ ma̠ ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ub̠on ob̠eb̠i abar, ya̠a̠, ku̠gba ma̠ ub̠on bho̠ na̠ a̠robh a̠lisibh d̠o̠yo̠, ka̠ ub̠on bho̠ ta̠ ed̠ighi eka̠ emula̠ esibh? Inwuna̠ ma̠ a̠lisibh ta̠ ub̠on d̠a̠ a̠ruzu d̠inyin, ya̠ ekima̠ aro̠ d̠a̠ esa̠d̠io d̠inyin.” ");
INSERT INTO mgj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sa̠ A̠zizo̠s ad̠u̠a ma̠ i̠se̠ agi̠ d̠a̠ ebhugh A̠zudia̠, sa̠ ab̠e̠i̠ d̠a̠ aku̠b̠o̠ Azo̠dan. Sa̠ o̠lo̠gh a̠nwunom ipita̠ iko i̠na ikiton, sa̠ a̠puta̠ atu̠ghu̠me̠ni̠ awa ma̠ agu̠o̠ i̠na na̠ a̠gir gha̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sa̠ Rafarisi bho̠ iru ma̠ o̠da o̠yo̠ okpon, sa̠ ipura̠n i̠na ma̠a̠, “Owolom ta̠ a̠rue a̠soroni ma̠ ani̠ d̠o̠yo̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sa̠ i̠na awo̠ran awa ma̠a̠, “A̠mozizi agba eka̠ a̠nigha̠ inyin, a̠gboloma̠ ma̠ ogbogina̠ ilom?” ");
INSERT INTO mgj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Sa̠ awa i̠wo̠ran ma̠a̠, “A̠mozizi a̠ma̠ra̠ ma̠a̠ onigha̠ ma̠ a̠d̠ire ogbogina̠ ilom, obhin osoroni ani̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ya̠a̠, A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “A̠mozizi a̠din ab̠agh e̠mu̠ d̠inyin age̠ ma̠ oloko obha̠ a̠nigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ya̠a̠, d̠a̠ o̠pu̠r ob̠eton bho̠, A̠zib̠a̠ ale̠m awa ma̠ ‘o̠ya na̠ olobhiri.’ ");
INSERT INTO mgj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ebula̠ o̠ku̠a, olobhiri o̠ni̠ ta̠ awe̠le̠ ma̠ oweni na̠ o̠we̠de̠ d̠o̠yo̠, sa̠ ta̠ agi̠ ka̠ ab̠araguma ma̠ ani̠ d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sa̠ i̠wal awa ta̠ eten onin ozu.’ O̠ku̠a bha̠ awa bo̠mu̠ i̠wal, kpe̠le̠me̠ni̠ awa na̠ eten onin ozu. ");
INSERT INTO mgj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","O̠ku̠a a̠d̠ighi be̠le̠ni̠, abar wa̠ A̠zib̠a̠ na̠ atu̠lo̠m bho̠, o̠nyi̠o̠mo̠ro̠ni̠ o̠bagi̠o̠n d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Igiel bha̠ awa imula̠ i̠gi̠ d̠a̠ otu bho̠, sa̠ ogbo atu̠ghan bho̠ ipura̠n i̠na igboloma̠ ma̠ abar onon. ");
INSERT INTO mgj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ola̠ a̠soroni ma̠ ani̠ d̠o̠yo̠ sa̠ a̠bhin opa̠n, bha̠ a̠sor oloko od̠e e̠ma a̠gboloma̠ ma̠ ani̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ani̠ ola̠ a̠gbogina̠ ma̠ owolom d̠o̠yo̠ sa̠ awal opa̠n, a̠sor oloko od̠e e̠ma.” ");
INSERT INTO mgj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A̠nwunom ibhin i̠gbara anwi̠i̠ny d̠awa eru d̠a̠ A̠zizo̠s agu̠o̠ ola̠ i̠na ta̠ a̠kula̠n awa, ya̠a̠ ogbo atu̠ghan d̠o̠yo̠ i̠b̠ab̠agi̠na ikigima̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","A̠zizo̠s abi̠gh o̠ku̠a bho̠, sa̠ agam a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠, sa̠ agba a̠nigha̠ awa ma̠a̠, “Ima̠ra̠ i̠gbara anwi̠i̠ny bho̠ eru d̠ami̠, ya̠a̠ ka̠ okigima̠ awa, ezin bho̠ irileghom ta̠ A̠zib̠a̠ aro̠ a̠nigha̠ ma̠ a̠nwunom ya̠ od̠i ma̠ agu̠o̠ i̠gbara anwi̠i̠ny. ");
INSERT INTO mgj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin, o̠ni̠ ola̠ o̠da d̠o̠ ma̠ irileghom ta̠ A̠zib̠a̠ a̠bhin agu̠o̠ o̠gbara o̠nyi̠ ko od̠igh d̠o̠ d̠a̠ ologi.” ");
INSERT INTO mgj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sa̠ a̠b̠ola̠n o̠gbara o̠nyi̠, o̠gbara o̠nyi̠ i̠se̠, agbam agu̠o̠ a̠tutumeni. ");
INSERT INTO mgj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sa̠ A̠zizo̠s a̠b̠etina̠ ma̠ erile, sa̠ odi o̠ni̠ a̠kpo ma̠ eghil ka̠ a̠kpud̠ia̠n i̠na a̠pura̠n ma̠a̠, “Ob̠eb̠i o̠ni̠ atu̠ghu̠me̠ni̠, ere ma̠ abar wa̠ ami̠ ta̠ a̠d̠ighi ma̠ ola̠ ami̠ ta̠ ate̠i̠ a̠ghud̠um ekunuguma̠ o̠to̠?” ");
INSERT INTO mgj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Anwa na̠ atu̠n ere na̠ a̠bhelegi ami̠ ma̠ ob̠eb̠i o̠ni̠? O̠ni̠ ola̠ aro̠ ma̠ ob̠eb̠i bo̠, a̠ten A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Anwa a̠loghom roloko bho̠: ‘Ko ogigh o̠ni̠, ko od̠e ma̠ e̠ma, ko ob̠igh a̠b̠igh, ko o̠gba ma̠ onyob̠a̠ igunugha̠, ko oniniom o̠ni̠, zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ onweni na̠ o̠we̠de̠ d̠oyom.’” ");
INSERT INTO mgj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sa̠ i̠na agba ma̠a̠, “O̠ni̠ Atu̠ghu̠me̠ni̠, ami̠ na̠ a̠koko ma̠ roloko i̠nye̠n keka̠ d̠a̠ i̠gbara d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sa̠ A̠zizo̠s a̠bhin obhel a̠kpon i̠na, sa̠ a̠ba̠ra̠ i̠na, sa̠ agba a̠nigha̠ i̠na ma̠a̠, “Onin abar a̠sugho, gi̠e̠ ka̠ a̠wol eb̠la̠ i̠di̠ar ya̠ anwa inwuna̠ bho̠ ma̠ a̠nigha̠ ma̠ ronyigoiny bho̠, sa̠ anwa ta̠ ate̠i̠ e̠li̠la d̠a̠ ote̠nai̠ny, ma̠ a̠ru ra̠ atu̠o̠no̠m ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sa̠ o̠ni̠ bho̠ a̠zum d̠a̠ ebula̠ awo̠ran bho̠, sa̠ a̠ten ad̠u̠a, ezin bho̠ i̠na a̠gbo ma̠ ibom e̠li̠la. ");
INSERT INTO mgj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sa̠ A̠zizo̠s a̠kpon ogbo atu̠ghan d̠o̠yo̠ a̠gir sa̠ agba ma̠a̠, “Agu̠o̠ akpar aru̠lala ma̠ od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠!” ");
INSERT INTO mgj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sa̠ ogbo atu̠ghan bho̠ ib̠a̠gha̠gha̠ d̠a̠ ebula̠ atu̠ghu̠me̠ni̠ d̠o̠yo̠. Ya̠a̠ A̠zizo̠s a̠mula̠ alo̠gho̠m ma̠a̠, “Anwi̠i̠ny d̠ami̠, amar akpar od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠! ");
INSERT INTO mgj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A̠b̠ur e̠nam a̠dol o̠wo̠l d̠a̠ oyol anu̠ga oten a̠pu ma̠ o̠li̠la ma̠ od̠igh d̠a̠ irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sa̠ awa imula̠ ib̠ogina̠ ma̠ o̠gbam, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “O̠ku̠a ka̠ a̠nyen ta̠ a̠rue a̠ten?” ");
INSERT INTO mgj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sa̠ A̠zizo̠s a̠bhin obhel a̠kpon awa awo̠ran ma̠a̠, “D̠a̠ o̠nyi̠o̠mo̠ro̠ni̠ bha̠ na̠ orue d̠o̠ a̠mite, ya̠a̠ d̠a̠ A̠zib̠a̠ d̠o̠, d̠a̠ A̠zib̠a̠ kabar kabar ta̠ a̠rue a̠mite.” ");
INSERT INTO mgj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sa̠ A̠puta̠ agba ma̠a̠, “Kpone! I̠yar na̠ o̠we̠le̠man kabar kabar na̠ o̠tu̠o̠no̠m anwa!” ");
INSERT INTO mgj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ awe̠le̠man eghun otu, bo̠d̠o̠ a̠rumor, bo̠d̠o̠ aru̠marani̠, bo̠d̠o̠ onweni, bo̠d̠o̠ o̠we̠de̠, bo̠d̠o̠ anwi̠i̠ny, bo̠d̠o̠ od̠ighi, d̠a̠ ebula̠ ami̠ na̠ asu̠gbagba bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ola̠ ko o̠te̠i̠ d̠o̠ ma̠ i̠wal e̠wala na̠ a̠d̠usubh igiel ma̠ i̠se̠n d̠a̠ obhel onon bo̠: a̠d̠igh eghun otu, a̠rumor, aru̠marani̠, onweni, anwi̠i̠ny, a̠de od̠ighi na̠ a̠nwunom oponoma̠ ogbikimeni o̠yo̠ nyen, na̠ a̠ghud̠um kid̠ud̠ul d̠a̠ amu̠m wa̠ na̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ya̠a̠, a̠d̠izo ogbo ya̠ od̠i d̠a̠ ed̠ia̠ ta̠ eten d̠a̠ aman, sa̠ ogbo ya̠ od̠i d̠a̠ aman bho̠ ta̠ eten d̠a̠ ed̠ia̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","D̠a̠ obhel bho̠ awa na̠ eten na̠ e̠gi̠ d̠a̠ A̠zeruse̠le̠m bho̠, A̠zizo̠s aro̠ d̠a̠ ed̠ia̠ d̠a̠ awa. Sa̠ ekpoyogh ologi na̠ a̠rugugu isibh ogbo ya̠ na̠ e̠tu̠o̠no̠m bho̠. Sa̠ i̠na a̠puta̠ a̠bhin d̠iobh na̠ i̠wal bho̠ a̠ten d̠a̠ aka, sa̠ ake̠ ma̠ o̠gba i̠di̠ar ya̠ na̠ eru ra̠ omutuma̠ o̠yo̠ bho̠ onigha̠ awa, ");
INSERT INTO mgj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ma̠a̠, “I̠nagha o! I̠yar na̠ o̠gi̠ d̠a̠ A̠zeruse̠le̠m, sa̠ ta̠ owol O̠nyi̠ ta̠ O̠ni̠ onigha̠ ma̠ ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠, sa̠ ta̠ esobh ase̠ omugh ebhumeni i̠na. Ta̠ eb̠eton i̠na o̠lo̠gh d̠a̠ agu̠o̠ ibhebhia̠n bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","sa̠ ta̠ e̠ki̠ri̠ i̠na, sa̠ ta̠ emurughom i̠na ma̠ i̠gho̠r, sa̠ ta̠ e̠gu̠ro̠gh i̠na, sa̠ ta̠ egigh i̠na, a̠bin i̠sar a̠d̠a̠ma̠ bho̠ sa̠ ta̠ a̠b̠etina̠ d̠a̠ omugh!” ");
INSERT INTO mgj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sa̠ A̠zemsi na̠ Azo̠n, anwi̠i̠ny ta̠ Aze̠bidi iru d̠a̠ o̠yo̠ ra̠ ifugh inigha̠ i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, i̠yar na̠ o̠bho̠ro̠gh agu̠o̠ ola̠ anwa ta̠ a̠gir a̠nigha̠ i̠yar kabar kabar ola̠ i̠yar upuru nyam.” ");
INSERT INTO mgj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sa̠ i̠na awo̠ran ma̠a̠, “Ere ma̠ abar wa̠ inyin na̠ o̠bho̠ro̠gh ami̠ ma̠ ogir onigha̠ inyin bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sa̠ awa i̠wo̠ran ma̠a̠, “D̠ighi odi i̠yar aro̠ ma̠ a̠dila̠de d̠a̠ od̠iom d̠oyom, sa̠ uwed̠i ta̠ aro̠ d̠a̠ okiel d̠a̠ isosorogia̠n d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ya̠a̠, A̠zizo̠s agba ma̠a̠, “Inyin u̠mu̠gho̠nyan d̠o̠ ma̠ abar wa̠ inyin na̠ opuru bho̠. Inyin ta̠ orue o̠d̠a d̠a̠ okpa̠ko wa̠ ami̠ ta̠ ad̠a bho̠, bo̠d̠o̠ a̠d̠ien owura̠ amu̠m wa̠ ta̠ owur ami̠ bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sa̠ awa i̠wo̠ran ma̠a̠, “I̠yar ta̠ orue.” Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Inyin ta̠ o̠d̠a d̠a̠ okpa̠ko wa̠ ami̠ ta̠ ad̠a bho̠, sa̠ inyin ta̠ owura̠ ma̠ a̠d̠ien amu̠m wa̠ ta̠ owur ami̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ya̠a̠, o̠ro̠ a̠dila̠de d̠a̠ od̠iom d̠ami̠ bo̠d̠o̠ d̠a̠ okiel d̠ami̠, bha̠ ami̠ o̠ni̠ wa̠ ta̠ ato̠ bho̠ d̠o̠. A̠dila̠de i̠nye̠n i̠ro̠ inigha̠ ma̠ ogbo ya̠ na̠ oguri osisa̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Igiel wa̠ d̠iobh ogbo ogir iyed̠i i̠mu̠gho̠n bho̠, sa̠ rologi d̠awa igurom inigha̠ ma̠ A̠zemsi na̠ Azo̠n. ");
INSERT INTO mgj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sa̠ A̠zizo̠s a̠bhelegi awa agba a̠nigha̠ awa ma̠a̠, “Inyin ologhom ma̠a̠, ogbo aru̠mu̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ A̠zu bho̠ inwuna̠ ma̠ a̠limon i̠to̠ egboloma̠ awa, sa̠ ogbo ya̠ i̠bu̠gh e̠mi̠ bho̠ na̠ eponoma̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ya̠a̠, o̠ro̠ d̠o̠ ma̠ o̠ku̠a d̠a̠ esa̠d̠io d̠inyin. Kpe̠le̠me̠ni̠, o̠ni̠ wa̠ na̠ abho̠ro̠gh o̠bu̠gh e̠mi̠ d̠a̠ esa̠d̠io d̠inyin bho̠, aro̠ ma̠ ob̠a̠ra̠motu d̠inyin, ");
INSERT INTO mgj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","sa̠ o̠ni̠ ola̠ na̠ abho̠ro̠gh o̠ro̠ o̠pu̠r, a̠d̠ia̠ aro̠ ma̠ e̠bana ta̠ eb̠la̠ a̠nwu̠nom. ");
INSERT INTO mgj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ na̠ oru d̠o̠ ma̠ a̠nwunom o̠ro̠ rob̠a̠ra̠motu d̠o̠yo̠, ya̠a̠ i̠na a̠ru ma̠ o̠ro̠ ob̠a̠ra̠motu onigha̠ a̠nwunom, na̠ onigha̠ a̠ghud̠um d̠o̠yo̠ obhin o̠ta a̠d̠izo ogbo.” ");
INSERT INTO mgj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sa̠ awa iten i̠gi̠ d̠a̠ Aze̠riko. Agu̠o̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ na̠ o̠lo̠gh a̠nwunom na̠ e̠d̠u̠a d̠a̠ Aze̠riko bho̠, bha̠ Abatimi̠o̠s o̠ni̠ ikpom a̠rid̠ien o̠nyi̠ ta̠ A̠timi̠o̠s aro̠ ma̠ a̠dila̠de d̠a̠ aka eten, na̠ a̠puru ma̠ ipupuru. ");
INSERT INTO mgj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Igiel bho̠ i̠na amu̠gho̠n ma̠ A̠zizo̠s wa̠ Anazare̠t na̠ a̠ten bho̠, sa̠ i̠na ake̠ ma̠ izul, a̠mulughu ma̠a̠, “A̠zizo̠s, O̠nyi̠ ta̠ A̠devidi, kpone ami̠ ma̠ igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sa̠ o̠lo̠gh a̠nwunom bho̠ i̠b̠ab̠agi̠na i̠na ma̠a̠ i̠na a̠nima̠, ya̠a̠, i̠na alo̠gh e̠mi̠ omulughu ma̠a̠, “O̠nyi̠ ta̠ A̠devidi, kpone ami̠ ma̠ igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sa̠ A̠zizo̠s amara kpom, sa̠ a̠ruom awa ma̠ obhelegi o̠ni̠ ikpom a̠rid̠ien bho̠ oruom o̠yo̠, sa̠ awa ibhelegi i̠na i̠gba ma̠a̠, “Kpo̠luzu! B̠etina̠! I̠na na̠ a̠bhelegi nyam.” ");
INSERT INTO mgj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sa̠ i̠na ake̠gi̠na ma̠ akapa anyu̠ d̠o̠yo̠ a̠robh, sa̠ a̠pel amara a̠rile agi̠ ka̠ ate̠i̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “Anwa na̠ abho̠ro̠gh ami̠ ma̠ ogir ere onigha̠ oyom?” Sa̠ o̠ni̠ ikpom a̠rid̠ien bho̠ awo̠ran ma̠a̠, “We̠mu̠ atu̠ghu̠me̠ni̠, ami̠ na̠ abho̠ro̠gh omula̠ o̠bi̠gh abar.” ");
INSERT INTO mgj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sa̠ A̠zizo̠s agba ma̠a̠, “Yele, ologi ima̠ra̠ d̠oyom na̠ a̠koko nyam.” Ogbo na̠ onin, sa̠ i̠na a̠mula̠ abi̠gh abar, sa̠ i̠na atu̠o̠no̠m A̠zizo̠s agi̠ d̠a̠ eten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Igiel bho̠ awa na̠ eten na̠ e̠gi̠ d̠a̠ A̠zeruse̠le̠m, sa̠ iru ra̠ itua̠n Abe̠ti̠fagi̠ na̠ Abe̠tani d̠a̠ aka Igu Oliv bho̠, sa̠ A̠zizo̠s a̠ruom i̠wal ogbo atu̠ghan d̠o̠yo̠ ma̠ od̠ia̠ o̠gi̠ na̠ awa, ");
INSERT INTO mgj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","sa̠ agba a̠nigha awa ma̠a̠, “I̠gi̠e̠ d̠a̠ e̠ma wa̠ a̠sumogha̠n inyin bho̠. Sa̠ agu̠o̠ inyin na̠ od̠igh bho̠, inyin ta̠ o̠bi̠gh o̠nyi̠ ado̠ki̠ ola̠ o̠ni̠ ta̠ od̠igh d̠o̠ a̠rile. I̠ko̠to̠ne̠ ma̠ ado̠ki̠ bho̠ ma̠ ebhin eru. ");
INSERT INTO mgj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sa̠, ka̠ o̠ni̠ a̠pura̠n inyin ma̠a̠, ‘Inyin na̠ udin ere na̠ ogir abar onon?’ Ma̠ e̠wo̠ran ma̠a̠, ‘Wa̠nwuna̠ bho̠ na̠ abho̠ro̠gh orughom, sa̠ ta̠ anu̠r a̠mulumeni a̠ru ma̠ i̠se̠n i̠se̠n.’ ” ");
INSERT INTO mgj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sa̠ awa iten i̠gi̠, sa̠ awa i̠bi̠gh o̠nyi̠ ado̠ki̠ ola̠ na̠ o̠kpo̠ d̠a̠ o̠nu̠ ogigo d̠a̠ aka eten bho̠. Igiel bho̠ awa na̠ e̠ko̠to̠n bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","sa̠ idi a̠nwunom ya̠ i̠mara ma̠ i̠se̠ ipura̠n ma̠a̠, “Inyin na̠ odin ere na̠ o̠ko̠to̠n o̠nyi̠ ado̠ki̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sa̠ awa i̠wo̠ran a̠nwunom bho̠ ma̠ agu̠o̠ A̠zizo̠s a̠ruom awa bho̠, sa̠ ima̠ra̠ awa ma̠ obhin. ");
INSERT INTO mgj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sa̠ awa ibhin o̠nyi̠ ado̠ki̠ bho̠ iruom A̠zizo̠s, sa̠ i̠gbamagi̠ ma̠ rakapa anyu̠ d̠awa d̠a̠ anyu̠ e̠nam bho̠, sa̠ A̠zizo̠s asi̠n d̠a̠ anyu̠ e̠nam bho̠ aro̠ ma̠ a̠dila̠de. ");
INSERT INTO mgj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A̠d̠izo a̠nwunom i̠de̠ ma̠ rakapa anyu̠ d̠awa d̠a̠ eten bho̠, sa̠ ipa̠n ogbo igbodo ma̠ ra̠to iriren d̠a̠ e̠sala bho̠ ibhin i̠de̠ d̠a̠ eten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sa̠ ogbo ya̠ i̠ro̠ d̠a̠ ed̠ia̠ bho̠ na̠ ogbo ya̠ i̠ro̠ d̠a̠ aman bho̠ i̠ke̠ ma̠ omulughu o̠gba okue ma̠a̠, “Ozana! Itutumeni e̠ro̠ enigha̠ ma̠ A̠zib̠a̠! A̠zib̠a̠ a̠tutumeni i̠na wa̠ na̠ a̠ru d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ bho̠! ");
INSERT INTO mgj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E̠no̠gho̠man e̠te̠i̠ irileghom ta̠ obom o̠we̠de̠ d̠i̠yar A̠devidi wa̠ na̠ a̠ru bho̠. Itutumeni e̠ro̠ enigha̠ ma̠ A̠zib̠a̠ wa̠ agi̠ ma̠ anyu̠ a̠pu bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Igiel bho̠ A̠zizo̠s ate̠i̠ d̠a̠ A̠zeruse̠le̠m bho̠, sa̠ i̠na agi̠ ka̠ a̠d̠igh d̠a̠ ogigo Otu ta̠ A̠zib̠a̠, sa̠ a̠kpon a̠kitineni abi̠gh agu̠o̠ i̠di̠ar od̠i. Ya̠a̠ agu̠o̠ obhel bho̠ na̠ a̠ten a̠pu d̠a̠ e̠mu̠ a̠d̠a̠ma̠ bho̠, sa̠ i̠na na̠ ogbo atu̠ghan d̠o̠yo̠ iten i̠gi̠ d̠a̠ Abe̠tani̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","I̠b̠ala bho̠, ma̠ igiel bho̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ na̠ e̠d̠u̠a d̠a̠ Abe̠tani na̠ emula̠ na̠ eru bho̠, sa̠ o̠ko̠i̠ a̠d̠ighi i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sa̠ A̠zizo̠s aro̠ ma̠ egbeiny abi̠gh oriren a̠fig ola̠ ra̠to a̠to imuzo, sa̠ i̠na a̠d̠ighoma̠ ka̠ i̠na ta̠ abi̠gh itu. Igiel bho̠ i̠na ate̠i̠ bho̠, i̠na na̠ o̠bi̠gh d̠o̠ bebina̠ otu oriren a̠ten ra̠to, ezin bho̠ ta̠ o̠te̠i̠ d̠o̠ ma̠ obhel ra̠fig. ");
INSERT INTO mgj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sa̠ a̠fugh a̠nigha̠ ma̠ a̠fig bho̠ ma̠a̠, “O̠ni̠ o̠bi̠gh mu̠ ma̠ otu d̠oyom a̠d̠e tu̠tu̠n kid̠ud̠ul!” Sa̠ ogbo atu̠ghan d̠o̠yo̠ e̠mu̠gho̠n i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Igiel bho̠ awa imisi d̠a̠ A̠zeruse̠le̠m bho̠, sa̠ A̠zizo̠s agi̠ ka̠ a̠d̠igh d̠a̠ Otu ta̠ A̠zib̠a̠, sa̠ i̠na ake̠ ma̠ ozegi eb̠la̠ ogbo ya̠ na̠ eghoyogh i̠di̠ar na̠ eb̠ua̠ ma̠ a̠b̠ua̠ ma̠ i̠se̠ bho̠. I̠na a̠kpululeni ma̠ rakpata a̠b̠ua̠ ta̠ ogbo ya̠ na̠ enwegi ma̠ ikpoki bho̠ na̠ ri̠kasi̠ ogbo ya̠ na̠ ewod̠i ma̠ rukurosege bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sa̠ na̠ oma̠ra̠ d̠o̠ ma̠ o̠ni̠ a̠bhin abar a̠b̠ua̠ awo̠l d̠a̠ rogigo Otu ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sa̠ i̠na atu̠ghu̠me̠ni̠ ma̠ a̠nwunom bho̠ agba ma̠a̠, “U̠ge̠ d̠o̠ d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ ma̠a̠ A̠zib̠a̠ agba ma̠a̠, ‘Ta̠ obhelegi ma̠ otu d̠ami̠ ma̠ otu a̠siseiny eb̠la̠ ra̠dede’? Ya̠a̠, inyin na̠ otenemeni ma̠ e̠fe̠m ib̠igh ma̠ a̠b̠igh!” ");
INSERT INTO mgj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Igiel bho̠ ogbo aru̠mu̠ rokur bho̠ na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠ i̠mu̠gho̠n i̠nye̠n bho̠, sa̠ awa i̠ke̠ ma̠ o̠bho̠ro̠ghan agu̠o̠ obhin ogigh A̠zizo̠s. Awa ighil i̠na, ezin bho̠ eb̠la̠ o̠lo̠gh a̠nwunom bho̠ na̠ ema̠gha̠ ma̠ ebula̠ ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ate̠i̠ a̠dule, sa̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ i̠d̠u̠a d̠a̠ e̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","I̠b̠ala bho̠ ma̠ ame̠ghe̠le̠, ma̠ igiel bho̠ awa na̠ erile d̠a̠ eten bho̠, sa̠ awa i̠bi̠gh oriren a̠fig bho̠ ka̠ na̠ aghi̠ghara d̠a̠ eb̠o a̠sor d̠a̠ i̠ki̠ka bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sa̠ A̠puta̠ aru̠ru̠an abar wa̠ a̠mite bho̠ sa̠ i̠na agba a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, kpone! Oriren a̠fig wa̠ anwa irogi bho̠ na̠ aghi̠ghara.” ");
INSERT INTO mgj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Inwuna̠ ma̠ ologi ima̠ra̠ d̠a̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Ya̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ a̠fugh a̠nigha̠ ma̠ igu onon ma̠, ‘B̠uruna̠ ka̠ a̠mel d̠a̠ abadi̠,’ sa̠ o̠ni̠ bho̠ onwuna̠ d̠o̠ i̠wal rologi, ya̠a̠ i̠na a̠ma̠ra̠, bha̠ omite epa̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ebula̠ o̠ku̠a, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, kabar kabar ola̠ inyin na̠ esiseiny na̠ opuru, bha̠ ima̠ra̠ ma̠ inyin na̠ o̠te̠i̠ abar bho̠, sa̠ ta̠ a̠mite ma̠ o̠ku̠a a̠nigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Igiel inyin ub̠etina̠ u̠mara ma̠ osiseiny a̠siseiny, bha̠ i̠we̠le̠mane̠ ma̠ i̠karabh ya̠ inyin unwuna̠ ugboloma̠ ma̠ o̠ni̠, b̠o̠ka̠ o̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ eka̠ awe̠le̠man i̠karabh od̠ighi̠ i̠di̠ar d̠oyom.  ");
INSERT INTO mgj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ya̠a̠, ku̠gba ma̠a̠ anwa na̠ o̠we̠le̠man d̠o̠ ma̠ i̠karabh opa̠n o̠ni̠, bha̠ O̠we̠de̠ d̠oyom wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ eka̠ ko o̠we̠le̠man d̠o̠ ma̠ i̠karabh od̠ighi̠ i̠di̠ar d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa̠ A̠zizo̠s na̠ ogbo ogir d̠o̠yo̠ imula̠ iru d̠a̠ A̠zeruse̠le̠m. Agu̠o̠ i̠na na̠ a̠rile na̠ a̠gir d̠a̠ ologi Otu ta̠ A̠zib̠a̠ bho̠, sa̠ ogbo aru̠mu̠ rokur bho̠, na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠, na̠ ikei bho̠, iru ra̠ i̠te̠i̠ i̠na, ");
INSERT INTO mgj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","sa̠ ipura̠n ma̠a̠, “Anwa na̠ a̠bhin a̠kere a̠d̠ien a̠limon na̠ a̠gir i̠di̠ar i̠nye̠n? A̠nyen a̠nigha̠ nyam a̠limon obhin ogir ogir i̠nye̠n?” ");
INSERT INTO mgj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ya̠a̠, A̠zizo̠s awo̠ran awa ma̠a̠, “Ami̠ a̠nwuna̠ ma̠ onin ipura̠n ola̠ ami̠ ta̠ a̠pura̠n inyin. Ka̠ inyin u̠wo̠ran, sa̠ ami̠ ta̠ agba ma̠ esi bho̠ ami̠ i̠te̠i̠ a̠dila̠de i̠to̠ na̠ a̠gir i̠di̠ar i̠nye̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Owura̠ amu̠m ta̠ Azo̠n ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru, bo̠d̠o̠ d̠a̠ o̠nyi̠o̠mo̠ro̠ni̠? I̠wo̠rane̠ Ami̠!” ");
INSERT INTO mgj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sa̠ awa ibhin i̠b̠e̠re̠gi̠an d̠a̠ esa̠d̠io d̠awa i̠gba ma̠a̠, “Ka̠ i̠yar u̠gba ma̠a̠, ‘Ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru,’ sa̠ i̠na ta̠ a̠pura̠n i̠yar ma̠a̠, ‘Inyin udin ere o̠we̠le̠ ma̠ oma̠ra̠ asu̠gbagba ta̠ Azo̠n?’ ");
INSERT INTO mgj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ya̠a̠, ka̠ i̠yar u̠gba ma̠a̠, ‘Ad̠u̠a d̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ a̠ru’ ...” (Awa ighil a̠nwunom bho̠, ezin bho̠ ko̠ni̠ko̠ni̠ a̠ma̠ra̠ ma̠a̠ Azo̠n owil ta̠ A̠zib̠a̠.) ");
INSERT INTO mgj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sa̠ awa i̠wo̠ran A̠zizo̠s ma̠a̠, “I̠yar uloghom d̠o̠.” Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Ami̠ eka̠ ami̠ ko o̠gba d̠o̠ a̠nigha̠ inyin a̠dila̠de a̠limon wa̠ ami̠ na̠ a̠bhin na̠ a̠gir i̠di̠ar i̠nye̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sa̠ A̠zizo̠s ake̠ ma̠ orogh a̠sidogh onigha̠ awa ma̠a̠: “Odi o̠ni̠ aro̠ ma̠ ola̠ a̠gbebh ra̠grep d̠a̠ a̠lei d̠o̠yo̠. Sa̠ a̠ko ma̠ a̠lei bho̠ a̠kiton, sa̠ a̠gbo ma̠ ogugua̠ ola̠ omumogh a̠min a̠grep bho̠ omutiom. I̠na a̠lo ma̠ otu ipoiny nyen, sa̠ a̠nigha̠ ma̠ a̠nwunom o̠ko̠ a̠lei bho̠, sa̠ i̠na a̠b̠etina̠ agi̠ ma̠ e̠gi̠ d̠a̠ opa̠n ebhugh. ");
INSERT INTO mgj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Igiel bho̠ a̠lei obhel o̠ku̠ a̠grep bho̠, sa̠ i̠na a̠nigha̠ ma̠ a̠limon odi e̠bana d̠o̠yo̠ ma̠ o̠gi̠ ka̠ obhin a̠bin imuma̠ d̠o̠yo̠ d̠a̠ aru̠gu̠o̠ ogbo ya̠ i̠ko̠ ma̠ a̠lei bho̠ oru. ");
INSERT INTO mgj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sa̠ ogbo ya̠ i̠ko̠ ma̠ a̠lei bho̠ ipuom i̠na, sa̠ id̠ul, sa̠ imulumeni i̠na ma̠ obhobho i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Opa̠n igiel, sa̠ i̠na a̠nigha̠ ma̠ a̠limon opa̠n e̠bana d̠o̠yo̠ ma̠ o̠gi̠ ka̠ obhin a̠bin imuma̠ d̠o̠yo̠ d̠a̠ aru̠gu̠o̠ ogbo ya̠ i̠ko̠ ma̠ a̠lei bho̠ oru. Sa̠ awa id̠ul i̠na, ib̠om e̠mu̠, i̠lo̠gh i̠na ma̠ ari̠ghe̠l. ");
INSERT INTO mgj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sa̠ a̠puta̠ a̠ruom opa̠n e̠bana ma̠ o̠gi̠, sa̠ awa igigh obha̠. Obha̠ agu̠o̠ awa id̠ulogh ipa̠n iya̠ uruom, ya̠a̠ i̠ze̠gi̠ ma̠ idi. ");
INSERT INTO mgj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Opa̠n o̠ni̠ ola̠ i̠na a̠nwuna̠ ma̠ oruom bo̠, a̠ten ogini o̠nyi̠ d̠o̠yo̠ wa̠ i̠na a̠tula̠n ibom bho̠. Ekunuguma̠ bho̠ sa̠ i̠na a̠nigha̠ ma̠ o̠nyi̠ d̠o̠yo̠ ma̠ a̠limon o̠gi̠ ka̠ o̠te̠i̠ awa, ezin bho̠ i̠na a̠fugh ma̠a̠, ‘Ami̠ na̠ a̠ma̠ra̠ ma̠a̠ awa ta̠ ezuruna̠ ma̠ eghoi enigha̠ ma̠ o̠nyi̠ d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ya̠a̠ ogbo ya̠ i̠ko̠ ma̠ a̠lei bho̠, odi a̠fugh a̠nigha̠ ma̠ odi ma̠a̠, ‘Onon o̠nyi̠ o̠ni̠ wa̠nwuna̠ ma̠ a̠lei bho̠. Itue ta̠ ogigh i̠na, sa̠ i̠di̠ar ad̠i̠a d̠o̠yo̠ ta̠ a̠ten iya̠ i̠yar.’ ");
INSERT INTO mgj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sa̠ awa ipuom o̠nyi̠ bho̠, sa̠ igigh i̠na, sa̠ id̠ud̠ur ozu bho̠ irobh d̠a̠ etire.” ");
INSERT INTO mgj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sa̠ A̠zizo̠s a̠pura̠n ma̠a̠, “O̠ku̠a ka̠ o̠ni̠ wa̠ a̠nwuna̠ ma̠ a̠lei bho̠ ta̠ a̠d̠ighi ma̠ ere? I̠na ta̠ a̠ru ra̠ aze̠gi̠ ma̠ a̠nwunom i̠ye̠ ya̠ i̠ko̠ ma̠ a̠lei bho̠, sa̠ ta̠ a̠b̠eton a̠lei bho̠ a̠nigha̠ ma̠ ipa̠n ogbo. ");
INSERT INTO mgj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Inyin ta̠ osen d̠o̠ o̠bi̠gh d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ke̠re̠, ma̠ esi bho̠ u̠ge̠ ma̠a̠: “ ‘Ekpokpogh ikputu wa̠ iloma̠rutu bho̠ ighel bho̠ na̠ ra̠ a̠ten e̠ko̠ wa̠ a̠lei abar a̠pu bho̠; ");
INSERT INTO mgj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","onon abar ola̠ Wa̠nwuna̠ bho̠ a̠gir, sa̠ amar a̠bhon d̠a̠ a̠misigh d̠i̠yar o̠bi̠gh’?” ");
INSERT INTO mgj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ ikei bho̠ eloghom ma̠a̠ A̠zizo̠s a̠rogh a̠sidogh bho̠ a̠gboloma̠ awa, sa̠ awa i̠ru̠ru̠an ob̠ol o̠yo̠. Ya̠a̠ awa ighil o̠lo̠gh a̠nwunom bho̠, ebula̠ o̠ku̠a sa̠ awa i̠we̠le̠man i̠na iten i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sa̠ awa ya̠ od̠i d̠a̠ a̠dila̠de i̠to̠ bho̠ iruom idi Afarisi na̠ idi ogbo i̠tu̠o̠no̠m ta̠ E̠ro̠d ma̠ o̠gi̠ ka̠ o̠kpati̠ o̠yo̠ ka̠ i̠na ta̠ a̠fugh abar api̠o̠m. ");
INSERT INTO mgj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sa̠ awa i̠gi̠ ka̠ i̠te̠i̠ i̠na ipura̠n ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, i̠yar ologhom ma̠ anwa na̠ amar na̠ a̠gir d̠a̠ o̠nu̠o̠kpe̠ atu̠ghu̠me̠ni̠ d̠oyom, sa̠ anwa na̠ okpon d̠o̠ ma̠ odi o̠ni̠ a̠gurumeni abhe̠l opa̠n, sa̠ anwa na̠ a̠bhin ya̠gia̠ga̠i bho̠ na̠ atu̠ghu̠me̠ni̠ ma̠ agu̠o̠ o̠tu̠o̠no̠m A̠zib̠a̠. Gba ma̠ a̠nigha̠ i̠yar, A̠sora̠n i̠yar otua̠ otua̠-ebhugh onigha̠ A̠siza̠ ke̠re̠? I̠yar otua̠ bo̠d̠o̠ ka̠ i̠yar otua̠ d̠o̠?” ");
INSERT INTO mgj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ya̠a̠ A̠zizo̠s a̠loghom ikoiny d̠awa sa̠ awo̠ran awa ma̠a̠, “Inyin udin ere na̠ o̠kpati̠ ami̠? Ibhine ma̠ a̠dinari̠ ma̠ eru ami̠ ta̠ abi̠gh.” ");
INSERT INTO mgj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sa̠ awa ibhin a̠dinari̠ bho̠ iruom i̠na, sa̠ i̠na a̠pura̠n ma̠a̠, “Onon ka̠ a̠misigh ta̠ a̠nyen, sa̠ u̠ge̠ ma̠ a̠d̠ien ta̠ a̠nyen d̠a̠ anyu̠ bho̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “Ita̠ A̠siza̠.” ");
INSERT INTO mgj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “O̠ku̠a bha̠, inigha̠ ma̠ A̠siza̠ ma̠ i̠di̠ar ta̠ A̠siza̠, ma̠ enigha̠ ma̠ A̠zib̠a̠ ma̠ ita̠ A̠zib̠a̠.” Sa̠ awa ib̠a̠gha̠gha̠ d̠a̠ ebul awo̠ran d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ogbo Asadusi ya̠ oma̠ra̠ d̠o̠ ma̠ ob̠etina̠ d̠a̠ omugh od̠i bho̠, i̠gi̠ ka̠ i̠te̠i̠ A̠zizo̠s epura̠n ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“O̠ni̠ atu̠ghu̠me̠ni̠, A̠mozizi age̠ a̠nigha̠ i̠yar ma̠a̠, ku̠gba ma̠ umor o̠ni̠ a̠mugh awe̠le̠man ani̠ d̠o̠yo̠ ad̠u̠a, ya̠a̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠, ma̠a̠, o̠ni̠ bho̠ ta̠ a̠bhin ani̠ umor bho̠ b̠o̠ka̠ amar anwi̠i̠ny a̠nigha̠ ma̠ umor d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","I̠se̠n bha̠ od̠ua̠l a̠rumor e̠ro̠; sa̠ okei bho̠ a̠bhin ani̠ ya̠a̠ i̠na na̠ o̠mar d̠o̠ ma̠ o̠nyi̠ sa̠ a̠mugh awe̠le̠man ani̠ bho̠ ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sa̠ oleghemeni i̠wal umor bho̠ a̠bhin ani̠ bho̠, i̠na eka̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠ sa̠ a̠mugh. Obha̠ onin agu̠o̠ a̠mutuma̠ ma̠ wa̠leghemeni i̠sar umor bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A̠mite ma̠ o̠ku̠a oku̠a tu̠tu̠n sa̠ eb̠la̠ od̠ua̠l a̠rumor ya̠ ibhin ani̠ bho̠ imugughu, i̠mar d̠o̠ bebina̠ ekpo o̠nyi̠. Ekunuguma̠ bho̠ sa̠ ani̠ bho̠ a̠mugh nyen. ");
INSERT INTO mgj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Igiel ob̠etina̠ d̠a̠ omugh bho̠ ka̠, ani̠ bho̠ ta̠ aro̠ ma̠ ani̠ ta̠ a̠nyen, d̠a̠ ebula̠ agu̠o̠ ani̠ bho̠ na̠ awal eb̠la̠ od̠ua̠l a̠rumor bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Inyin ta̠ o̠ru̠ru̠an d̠o̠ o̠pi̠e, ebula̠ agu̠o̠ inyin u̠mu̠gho̠nyan d̠o̠ ma̠ ratu̠ghu̠me̠ni̠ A̠d̠ire E̠tu̠tu̠ bho̠, bo̠d̠o̠ a̠limon ta̠ A̠zib̠a̠ bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Igiel imumugh bho̠ ta̠ eb̠egina̠, awa ta̠ e̠ro̠ ma̠ agu̠o̠ itileduom ta̠ A̠zib̠a̠ d̠a̠ ote̠nai̠ny. Awa ko obhinogh d̠o̠ ma̠ anwani̠, sa̠ ko onigha̠nom d̠o̠ ma̠ anwi̠nyan anwi̠i̠ny nyen. ");
INSERT INTO mgj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iya̠ igboloma̠ ma̠ ogbo ya̠ ta̠ eb̠egina̠ d̠a̠ omugh bho̠, inyin ta̠ osen d̠o̠ o̠bi̠gh d̠a̠ a̠d̠ire ta̠ A̠mozizi ma̠ asu̠gbagba ed̠um bho̠ ma̠ iya̠ A̠zib̠a̠ agba a̠nigha̠ i̠na bho̠ ke̠re̠? Ma̠a̠, ‘Ami̠ A̠zib̠a̠ ta̠ Ebraham, na̠ A̠zib̠a̠ ta̠ Azi̠ki̠, na̠ A̠zib̠a̠ ta̠ A̠zeko̠pu̠.’ ");
INSERT INTO mgj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I̠na A̠zib̠a̠ imumugh d̠o̠, ya̠a̠ i̠na ola̠ ogbo ya̠ od̠i d̠a̠ a̠ghud̠um. Inyin o̠mar o̠ru̠ru̠an o̠pi̠e̠!” ");
INSERT INTO mgj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Odi o̠ni̠ atu̠ghu̠me̠ni̠ oloko bho̠ a̠ru ra̠ amu̠gho̠n i̠b̠e̠re̠gi̠an d̠awa, sa̠ abi̠gh ma̠ I̠na amar awo̠ran awa, sa̠ a̠pura̠n ma̠a̠, “Eb̠la̠ roloko bho̠ ka̠ oken a̠lei abar a̠pu?” ");
INSERT INTO mgj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Onon wa̠ a̠lei abar a̠pu bho̠: ‘I̠nagha, E Izre̠l! Wa̠nwuna̠ A̠zib̠a̠ d̠i̠yar, i̠na ku̠ku̠m Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bhine ma̠ eb̠la̠ ekpo ologi d̠oyom, na̠ eb̠la̠ eloghoma̠n ozu d̠oyom, na̠ eb̠la̠ i̠ru̠ru̠an ologi d̠oyom, na̠ eb̠la̠ e̠mi̠ d̠oyom, ma̠ a̠tula̠n Wa̠nwuna̠ A̠zib̠a̠ d̠oyom.’ ");
INSERT INTO mgj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oleghemeni i̠wal bho̠, bha̠ onon: ‘Tula̠ne ma̠ o̠ni̠ wa̠ od̠i d̠a̠ aka d̠oyom bho̠, ma̠ agu̠o̠ anwa itula̠n ozu d̠oyom bho̠.’ Oloko ola̠ a̠pu ma̠ i̠nye̠n bo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sa̠ o̠ni̠ atu̠ghu̠me̠ni̠ oloko bho̠ awo̠ran ma̠a̠, “Anwa amar agba ma̠ iya̠gia̠ga̠i bho̠. Onin A̠zib̠a̠ ku̠ku̠m od̠i, opa̠n bo̠, a̠ten i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sa̠ anwa ta̠ a̠bhin eb̠la̠ ekpo ologi d̠oyom, na̠ eb̠la̠ i̠ru̠ru̠an ologi d̠oyom, na̠ eb̠la̠ e̠mi̠ d̠oyom a̠tula̠n Wa̠nwuna̠ A̠zib̠a̠ d̠oyom. Sa̠ anwa ta̠ a̠tula̠n o̠ni̠ etua̠n d̠oyom ma̠ agu̠o̠ ozu d̠oyom, a̠lei abar a̠pu ma̠ obhin i̠nam o̠kpe̠ alu̠kpe̠ na̠ ipa̠n ralu̠kpe̠.” ");
INSERT INTO mgj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Igiel bho̠ A̠zizo̠s abi̠gh ma̠a̠ i̠na amar awo̠ran bho̠, sa̠ agba a̠nigha̠ i̠na ma̠a̠, “Irileghom ta̠ A̠zib̠a̠ na̠ osigima̠ mu nyam.” Sa̠ o̠ni̠ ola̠ a̠ne ma̠ opita̠ opura̠n abar na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Agu̠o̠ A̠zizo̠s na̠ atu̠ghu̠me̠ni̠ d̠a̠ Otu ta̠ A̠zib̠a̠ bho̠, sa̠ i̠na a̠pura̠n ma̠a̠, “Ogbo atu̠ghu̠me̠ni̠ oloko bho̠ na̠ edin ere na̠ e̠gba ma̠a̠ Witenemeni bho̠ ma̠a̠ o̠nyi̠ ta̠ A̠devidi? ");
INSERT INTO mgj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","E̠mu̠gh E̠tu̠tu̠ bho̠ awo̠l d̠a̠ o̠nu̠ ta̠ A̠devidi na̠ agu̠o̠ agba ma̠a̠, “ ‘Wa̠nwuna̠ A̠zib̠a̠ agba a̠nigha̠ ma̠ Wa̠nwuna̠ d̠ami̠ ma̠a̠: “Ro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ d̠ami̠ tu̠tu̠n ami̠ ta̠ a̠guri ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom d̠a̠ ekpukpu a̠sike d̠oyom.” ’ ");
INSERT INTO mgj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A̠devidi na̠ agu̠o̠ a̠bhelegi i̠na ma̠ ‘Wa̠nwuna̠.’ O̠ku̠a ka̠ I̠na aro̠ eka̠ ma̠ o̠nyi̠ d̠o̠yo̠?” Sa̠ o̠lo̠gh a̠nwunom bho̠ ibhin a̠libhon ologi i̠nagha ma̠ atu̠ghu̠me̠ni̠ ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Igiel bho̠ A̠zizo̠s na̠ atu̠ghu̠me̠ni̠ bho̠, sa̠ i̠na agba ma̠a̠, “I̠mare̠ ma̠ ekpona̠ ma̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠. Awa iba̠ra̠ ma̠ opa̠n obura̠ ibom isosora̠n rakapa, sa̠ iba̠ra̠ ma̠ a̠nwunom obhin d̠a̠ ozuruna̠ eghoi obheleguma̠ awa d̠a̠ regbolom a̠b̠ua̠, ");
INSERT INTO mgj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","sekina̠ o̠ro̠ d̠a̠ ra̠dila̠de edim d̠a̠ a̠rutu u̠gala A̠zu bho̠, na̠ o̠ro̠ d̠a̠ a̠risisi edim d̠a̠ ro̠d̠e̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Awa na̠ eponoma̠ ma̠ rekpukele anwani̠ na̠ e̠wo̠ro̠gh i̠di̠ar, sa̠ awa na̠ esiseiny iwewegh ra̠siseiny b̠o̠ka̠ olelegi awa. Awa ta̠ e̠te̠i̠ ibom ebhum ase̠.” ");
INSERT INTO mgj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A̠zizo̠s aro̠ ma̠ a̠dila̠de a̠sumogha̠n igba̠ alu̠kpe̠ bho̠, sa̠ a̠kpon agu̠o̠ a̠nwunom na̠ ebhin na̠ e̠lo̠gi̠ ma̠ ikpoki ali̠se̠bh d̠awa bho̠. Sa̠ i̠na abi̠gh ka̠ a̠d̠izo aru̠lala na̠ e̠lo̠gi̠ ma̠ a̠b̠utu ikpoki d̠a̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sa̠ odi onyigoiny ekpukele ani̠, agi̠ ka̠ alo̠gh i̠wal i̠gbara ikpoki ako̠pa, ya̠ ilei ape̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sa̠ i̠na a̠bhelegi ma̠ ogbo atu̠ghan d̠o̠yo̠ agba a̠nigha̠ awa ma̠a̠: “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, eb̠la̠ ogbo ya̠ i̠lo̠gi̠ ma̠ i̠di̠ar e̠ne̠ghe̠ d̠a̠ igba̠ bho̠, onyigoiny ekpukele ani̠ onon alo̠gh a̠pu. ");
INSERT INTO mgj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ezin bho̠, eb̠la̠ a̠nwunom i̠nye̠n na̠ ibom e̠li̠la d̠awa, wa̠ a̠ru, ape̠to̠n o̠nyi̠ esi d̠a̠ e̠li̠la d̠o̠yo̠ alo̠gh. Ya̠a̠, d̠a̠ ologi igoiny d̠o̠yo̠, i̠na a̠kpukpu ma̠ eb̠la̠ ya̠ i̠na a̠nwuna̠ bho̠ alo̠gh.” ");
INSERT INTO mgj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Igiel bho̠ A̠zizo̠s na̠ a̠mite d̠a̠ Otu ta̠ A̠zib̠a̠ bho̠, sa̠ odi o̠ni̠ atu̠ghan d̠o̠yo̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Kpone! A̠libhon ikputu bho̠ na̠ a̠rutu bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya̠a̠ A̠zizo̠s awo̠ran ma̠a̠, “Inyin na̠ o̠bi̠gh ibom a̠rutu i̠nye̠n? Bebina̠ ikputu ola̠ ta̠ a̠sughonom i̠se̠n ola̠ odi ta̠ aro̠ d̠a̠ anyu̠ ta̠ odi bo̠, ola̠ ko ob̠ogion d̠o̠ bo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A̠zizo̠s aro̠ ma̠ a̠dila̠de d̠a̠ anyu̠ Igu Oliv d̠a̠ esumogha̠n Otu ta̠ A̠zib̠a̠, sa̠ A̠puta̠, na̠ A̠zemsi, na̠ Azo̠n, na̠ Anduru, iru ra̠ ipura̠n i̠na d̠a̠ e̠wo̠gi̠na ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“O̠ni̠ atu̠ghu̠me̠ni̠, gba ma̠ a̠nigha̠ i̠yar, i̠di̠ar i̠nye̠n ka̠ ta̠ emite ma̠ a̠kere obhel? Sa̠ i̠yar ta̠ obhin a̠kere a̠d̠ien elegh ologhom ma̠ i̠di̠ar i̠nye̠n na̠ etua̠n omite?” ");
INSERT INTO mgj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “I̠mare̠ ma̠ ekpona̠ ma̠ agu̠o̠ ola̠ o̠ni̠ ko ogelemeni d̠o̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","A̠d̠izo a̠nwunom ta̠ ebhin a̠d̠ien d̠ami̠ eru ra̠ e̠gba ma̠a̠, ‘Ami̠ i̠na!’ sa̠ awa ta̠ egelemeni ma̠ a̠d̠izo ogbo. ");
INSERT INTO mgj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ya̠a̠, o̠ni̠ ko okperenuma̠ ma̠ igiel inyin u̠mu̠gho̠n oghur re̠gham na̠ i̠mu̠mu̠gho̠n re̠gham. O̠kpo̠ ya̠ o̠ku̠a ta̠ emite, ya̠a̠ o̠ku̠a na̠ oma̠ra̠ d̠o̠ ma̠ na̠ ate̠i̠ ekunuguma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ebhugh ta̠ a̠wia̠n ebhugh, sa̠ a̠de e̠ma ta̠ a̠wia̠n a̠de e̠ma. Ra̠de ta̠ eb̠ob̠omia̠n kesi kesi, sa̠ o̠ko̠i̠ ed̠ia̠n ta̠ a̠sor. Ya̠a̠, i̠nye̠n ta̠ e̠ro̠ ma̠ o̠pu̠r o̠ke̠ ali̠gam a̠ruzu ma̠ agu̠o̠ iguna̠ i̠mara. ");
INSERT INTO mgj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Be̠le̠ni̠, i̠mare̠ ma̠ ekpona̠. Ta̠ ob̠ologh inyin obhin o̠gi̠ d̠a̠ a̠rutu osobh ase̠ d̠a̠ re̠ma bho̠ na̠ d̠a̠ a̠rutu u̠gala A̠zu, sa̠ ta̠ o̠gu̠ro̠gh inyin. Sa̠ ta̠ o̠marame̠ni̠ inyin d̠a̠ a̠misigh ogbo aru̠mu̠ ebhugh na̠ aru̠lala e̠ma d̠a̠ ebula̠ ami̠, ma̠ agu̠o̠ ola̠ inyin ta̠ o̠gba ami̠ onigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta̠ od̠ia̠ o̠gba nyen ib̠eb̠i asu̠gbagba bho̠ omutiom onigha̠ ma̠ eb̠la̠ ra̠dede. ");
INSERT INTO mgj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sa̠ igiel ubhin inyin u̠gi̠o̠m awa, o̠ni̠ ko od̠ia̠ ma̠ e̠ku̠nu̠ ma̠ agu̠o̠ obhin o̠gba o̠nu̠. Kpe̠le̠me̠ni̠, i̠gba ma̠ i̠di̠ar iya̠ unigha̠ inyin d̠a̠ ogbo obhel bha̠. Ezin bho̠, inyin d̠o̠ ma̠ ogbo ya̠ ta̠ e̠gba bho̠, ya̠a̠ E̠mu̠gh E̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Umor ta̠ a̠wol umor ma̠ agu̠o̠ ola̠ ogigh, sa̠ o̠we̠de̠ ta̠ a̠wol o̠nyi̠, sa̠ anwi̠i̠ny ta̠ ewia̠n ronweni na̠ ro̠we̠de̠ ma̠ o̠ze̠gi̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sa̠ ko̠ni̠ ko̠ni̠ ta̠ asu̠a inyin d̠a̠ ebula̠ a̠d̠ien d̠ami̠. Ya̠a̠, o̠ni̠ wa̠ a̠ne tu̠tu̠n ka̠ a̠kunugiom bho̠, bha̠ oten. ");
INSERT INTO mgj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Igiel inyin u̠bi̠gh ‘ka̠ ibom i̠pi̠o̠gho̠m wa̠ na̠ api̠e̠gi̠ ma̠ i̠di̠ar bho̠’ na̠ amara ma̠ esi bho̠ osora̠n d̠o̠ i̠na ma̠ o̠ro̠ bho̠, (bha̠ o̠ni̠ wa̠ na̠ a̠sen bho̠ amu̠gho̠nyan), o̠ni̠ wa̠ od̠i d̠a̠ A̠zudia̠ bho̠ a̠kpo ma̠ eghil ad̠u̠a agi̠ d̠a̠ ebhugh rigu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","O̠ni̠ ola̠ od̠i d̠a̠ anyu̠ otu osor d̠o̠ a̠ru ra̠ a̠bhin abar d̠a̠ otu d̠o̠yo̠ a̠mite. ");
INSERT INTO mgj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","O̠ni̠ ola̠ od̠i d̠a̠ o̠si̠ omula̠ d̠o̠ agi̠ ka̠ a̠bhin akapa anyu̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ekulom anwani̠ a̠rughun na̠ iya̠ anwi̠i̠ny od̠id̠ia̠ na̠ e̠mam d̠a̠ ra̠d̠a̠ma̠ i̠ye̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ya̠a̠, isiseinye ma̠ o̠kpo̠ i̠nye̠n omite d̠o̠ ma̠ obhel a̠d̠igho. ");
INSERT INTO mgj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ezin bho̠, a̠d̠ien egbika̠ ra̠d̠a̠ma̠ i̠ye̠ ta̠ omite d̠o̠ ka̠ d̠a̠ o̠pu̠r ob̠eton o̠le̠me̠gh i̠di̠ar ya̠ A̠zib̠a̠ ale̠m bho̠ tu̠tu̠n ra̠ ate̠i̠ i̠se̠n, sa̠ ka̠ omula̠ mu emite. ");
INSERT INTO mgj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Sa̠ ku̠gba ma̠ Wa̠nwuna̠ bho̠ na̠ okperemeni d̠o̠ ma̠ obhel bho̠, bha̠ o̠ni̠ ola̠ ta̠ a̠miza̠n bo̠. O̠ku̠a eka̠, d̠a̠ ebula̠ ogbo ya̠ i̠na na̠ aso̠n a̠bhin bho̠, bha̠ i̠na na̠ a̠kperemeni ma̠ obhel bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sa̠ d̠a̠ obhel obha̠, ka̠ o̠ni̠ a̠ru ra̠ agba ma̠a̠, ‘Ikpone! Akrai̠st od̠i ma̠ i̠se̠n!’ bo̠d̠o̠, ‘Ikpone! I̠na od̠i ma̠ ebha̠,’ o̠ni̠ ko oma̠ra̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rakrai̠st igunugha̠ na̠ a̠riwil igunugha̠ ta̠ emite eru ra̠ egir ilologia̠n, sa̠ ta̠ emutioghom relegh ya̠ obhin ogelemeni a̠nwunom, ku̠gba ma̠ a̠b̠ur, bha̠ ogbo iya̠ na̠ o̠so̠n bho̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ikpona̠ o! Ami̠ nà̠ agba kabar kabar a̠nigha̠ inyin i̠se̠n kisa̠ obhel bho̠ ta̠ a̠lei. ");
INSERT INTO mgj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“D̠a̠ ra̠d̠a̠ma̠ i̠ye̠, ma̠ igiel ali̠gam a̠ruzu bho̠ na̠ eten, “ ‘sa̠ ogogo bho̠ ta̠ azu̠, sa̠ uwetire bho̠ ko o̠mu̠ mu̠; ");
INSERT INTO mgj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sa̠ i̠ni̠nai̠ny bho̠ ta̠ e̠d̠u̠a d̠a̠ e̠nai̠ny emeleghu, sa̠ ra̠limon e̠nai̠ny ta̠ enyegia̠n.’ ");
INSERT INTO mgj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Sa̠ d̠a̠ obhel obha̠, a̠nwunom ta̠ o̠bi̠gh ka̠ O̠nyi̠ ta̠ O̠ni̠ na̠ a̠bhin d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ na̠ a̠ru na̠ ibom a̠limon na̠ isosorogia̠n. ");
INSERT INTO mgj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sa̠ i̠na ta̠ a̠ruom itileduom d̠o̠yo̠ ma̠ o̠gi̠ ka̠ okokod̠i ogbo ya̠ i̠na na̠ aso̠n bho̠, d̠a̠ inya̠ re̠ku̠l e̠mara̠nwunom bho̠, ob̠eton d̠a̠ ekunuguma̠ o̠gbaki̠ a̠de ka̠ o̠te̠i̠ d̠a̠ ekunuguma̠ obhubhulom. ");
INSERT INTO mgj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“I̠se̠n, ibhine ma̠ a̠sidogh oriren a̠figbho̠ ma̠ e̠tu̠ghan abar. Igiel i̠gha d̠o̠yo̠ na̠ edugh sa̠ i̠mu̠nu̠mu̠n bho̠ na̠ e̠mu̠r na̠ emite, bha̠ inyin na̠ ologhom ma̠ a̠kozogh na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Onin agu̠o̠ bho̠, igiel inyin u̠bi̠gh ka̠ i̠di̠ar i̠nye̠n na̠ emite, bha̠ iloghome ma̠a̠, na̠ a̠tua̠n, na̠ a̠misi d̠a̠ o̠nu̠otu. ");
INSERT INTO mgj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, amu̠m onon ko oten d̠o̠ kisa̠ eb̠la̠ i̠di̠ar i̠nye̠n ta̠ emite. ");
INSERT INTO mgj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A̠de na̠ e̠nai̠ny ta̠ eten e̠d̠u̠a, ya̠a̠ ikpo a̠fugh d̠ami̠ ko oten d̠o̠ na̠ oten e̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“I̠se̠n, iya̠ igboloma̠ ma̠ a̠d̠a̠ma̠ bo̠d̠o̠ obhel bho̠, bebina̠ o̠ni̠ ola̠ a̠loghom bo̠, a̠d̠igh itileduom ta̠ A̠zib̠a̠ d̠a̠ ote̠nai̠ny, O̠nyi̠ bho̠ eka̠, a̠sigimeni ma̠ O̠we̠de̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ikpona̠! Igone! Ezin bho̠ inyin uloghom d̠o̠ ma̠ obhel bho̠ ekunuguma̠ obhel bho̠ ta̠ aro̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Agu̠o̠ o̠ni̠ ola̠ a̠b̠etina̠ ma̠ e̠gi̠, sa̠ awe̠le̠man eghun otu d̠o̠yo̠ a̠nigha̠ ma̠ igoni d̠o̠yo̠ ma̠ okponom, o̠ni̠no̠ o̠ni̠no̠ ma̠ abar ola̠ ta̠ a̠gir, sa̠ a̠ruom okponomotubho̠ ma̠a̠, aro̠ ma̠ omom a̠gon. ");
INSERT INTO mgj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“O̠ku̠a a̠d̠ighi be̠le̠ni̠, igone, ezin bho̠ inyin uloghom d̠o̠ ma̠ obhel bho̠ wa̠nwuna̠ ma̠ otu bho̠ ta̠ a̠mula̠ a̠ru. Ta̠ a̠rue aro̠ ma̠ a̠dule, bo̠d̠o̠ egum a̠d̠io, bo̠d̠o̠ d̠a̠ obhel olobhiri e̠nu̠r na̠ alal, bo̠d̠o̠ ame̠ghe̠le̠. ");
INSERT INTO mgj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma̠ agu̠o̠ ola̠ ka̠ a̠ru ma̠ awai̠, i̠na o̠bi̠gh d̠o̠ ma̠ anwa na̠ a̠kod̠u. ");
INSERT INTO mgj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa̠ abar wa̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin bho̠, bha̠ ami̠ na̠ agba na̠ a̠nigha̠ ko̠ni̠ ko̠ni̠. ‘Igone!’ ” ");
INSERT INTO mgj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I̠se̠n bha̠ i̠wal a̠d̠a̠ma̠ isugho ma̠ o̠te̠i̠ E̠yal Opel Oten bho̠ sekina̠ E̠yal Abe̠re̠di̠ ya̠ Owubh d̠o̠ bho̠, sa̠ ogbo aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ imimia̠n agu̠o̠ awa ta̠ ebhin ikoiny eb̠ol A̠zizo̠s egigh. ");
INSERT INTO mgj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ya̠a̠, awa i̠gba ma̠a̠, o̠ro̠ d̠o̠ ma̠ a̠d̠a̠ma̠ e̠yal bho̠, bo̠d̠o̠ bha̠ a̠nwunom bho̠ ta̠ esoroni ma̠ elobhiri. ");
INSERT INTO mgj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","I̠se̠n, bha̠ A̠zizo̠s od̠i d̠a̠ Abe̠tani̠ ma̠ a̠dila̠de d̠a̠ otu ta̠ Asai̠mo̠n wa̠ anwe̠r asu̠nwe̠r ekid̠igh bho̠. Sa̠ odi ani̠ a̠bhin ololo alabasta ola̠ u̠lo̠gh a̠ga̠i amu̠nu̠ Aspai̠knad obom a̠b̠ua̠ a̠ru. Sa̠ a̠b̠om o̠nu̠no̠nu̠ ololo bho̠ a̠zugioghom amu̠nu̠ bho̠ d̠a̠ e̠mu̠ ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sa̠ idi ogbo ya̠ od̠i ma̠ i̠se̠ bho̠ i̠ki̠kai̠ngha, sa̠ odi a̠fugh a̠nigha̠ ma̠ odi ma̠a̠, “I̠na a̠din ere na̠ a̠robh amu̠nu̠ ed̠u e̠nu̠nu̠ bho̠ ma̠ o̠ku̠a? ");
INSERT INTO mgj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Onon sa̠ ka̠ urue owol opeleni ma̠ od̠ua̠l e̠wala na̠ a̠d̠usubh a̠dinari̠ (300) obhin o̠lo̠gh agu̠o̠ onigha̠ ma̠ ronyigoiny bho̠.” Sa̠ awa i̠li̠o̠m ani̠ bho̠ ma̠ ibom. ");
INSERT INTO mgj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ya̠a̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “I̠we̠le̠ ma̠ ani̠ bho̠ ma̠ agu̠o̠. Inyin udin ere na̠ onigha̠ i̠na ma̠ ali̠gam a̠luzu? I̠na na̠ a̠gir ob̠eb̠i abar a̠nigha̠ ami̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ronyigoiny bho̠ sa̠ od̠i na̠ inyin eb̠la̠ obhel, inyin ta̠ orue o̠lo̠gh agu̠o̠ onigha̠ awa kere kere obhel ola̠ a̠d̠igh inyin ologi. Ya̠a̠ ami̠ ko o̠ro̠ d̠o̠ na̠ inyin eb̠la̠ obhel. ");
INSERT INTO mgj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I̠na a̠gir abar wa̠ i̠na a̠rue ma̠ ogir bho̠, ma̠ od̠ia̠ ozuom ami̠ amu̠nu̠ iya̠ o̠tu̠ghu̠man ozu d̠ami̠ ma̠ ola̠ a̠ma̠d̠i. ");
INSERT INTO mgj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, kesi kesi ola̠ ta̠ o̠gba ma̠ ib̠ebi̠ asu̠gbagba i̠nye̠n d̠a̠ eb̠la̠ e̠mara̠nwunom bho̠, ta̠ o̠gba nyen, ogir onon wa̠ ani̠ onon a̠gir bho̠, ma̠ obhin o̠ru̠ru̠an o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sa̠ A̠zuda̠s I̠skari̠o̠t, odi o̠ni̠ d̠a̠ d̠iobh na̠ i̠wal bho̠, a̠ten agi̠ ka̠ ate̠i̠ ogbo aru̠mu̠ rokur bho̠ ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠wol A̠zizo̠s a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sa̠ ogbo aru̠mu̠ rokur bho̠ ibhon ologi ma̠ agu̠o̠ awa i̠mu̠gho̠n ya̠ i̠na agba bho̠, sa̠ igua̠n onigha̠ o̠yo̠ ma̠ ikpoki. Ob̠eton d̠a̠ obhel obha̠ sa̠ A̠zuda̠s abho̠ro̠gh e̠ti̠ti̠gha ola̠ ta̠ a̠sora̠n owol A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","D̠a̠ o̠pu̠r a̠d̠a̠ma̠ E̠yal Abe̠re̠di̠ wa̠ Owubh d̠o̠ bho̠, a̠d̠a̠ma̠ wa̠ na̠ ogigh o̠nyi̠ o̠nana E̠yal Opel Oten bho̠, sa̠ ogbo ogir ta̠ A̠zizo̠s iru ra̠ i̠te̠i̠ i̠na, ipura̠n ma̠a̠, “A̠kere esi wa̠ anwa na̠ abho̠ro̠ghan i̠yar o̠gi̠ ka̠ o̠tu̠ghu̠man osisa̠n oyom ma̠ od̠e ed̠ia̠n E̠yal Opel Oten bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sa̠ i̠na a̠ruom i̠wal ogbo ogir d̠o̠yo̠ a̠fugh a̠nigha̠ awa ma̠a̠, “I̠gi̠e̠ d̠a̠ e̠ma bho̠, sa̠ inyin ta̠ o̠bi̠gh od̠i o̠ni̠ ola̠ na̠ a̠rol izoko amu̠m, i̠tu̠o̠no̠me̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sa̠ i̠gba ma̠ enigha̠ ma̠ o̠ni̠ wa̠ a̠nwuna̠ ma̠ otu wa̠ i̠na ta̠ a̠d̠igh bho̠ ma̠a̠: ‘O̠ni̠ atu̠ghu̠me̠ni̠ bho̠ na̠ a̠pura̠n ma̠a̠: oken e̠kpe̠ isuloma̠ wa̠ ami̠ ta̠ a̠d̠igh na̠ ogbo ogir d̠ami̠ a̠d̠e ma̠ E̠yal Opel Oten bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sa̠ i̠na ta̠ atu̠o̠m a̠leriom inyin obom e̠kpe̠ d̠a̠ anyu̠ otu a̠b̠ekei bho̠, ola̠ na̠ o̠mar oburi oguri, ma̠ e̠tu̠ghu̠man i̠se̠ ma̠ esisa̠n i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sa̠ ogbo atu̠ghan bho̠ iten i̠gi̠ d̠a̠ e̠ma bho̠, sa̠ awa i̠bi̠gh ma̠ eb̠la̠ i̠di̠ar bho̠ od̠i ma̠ agu̠o̠ agba a̠nigha̠ awa bho̠, sa̠ awa i̠tu̠ghu̠man ed̠ia̠n Opel Oten bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ate̠i̠ a̠dule, sa̠ A̠zizo̠s na̠ d̠iobh na̠ i̠wal bho̠ iten i̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Agu̠o̠ awa od̠i d̠a̠ akpata od̠e na̠ ed̠e ma̠ ed̠ia̠n bho̠, sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin, odi o̠ni̠ inyin wa̠ na̠ a̠d̠igh na̠ ami̠ na̠ a̠d̠e bho̠, ta̠ a̠wol ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sa̠ awa id̠igh i̠ku̠nu̠ ma̠ ibom, sa̠ o̠ni̠ o̠ni̠ i̠se̠ ake̠ ma̠ opura̠n o̠yo̠ ma̠a̠, “Wa̠nwuna̠, ami̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Odi o̠ni̠ inyin d̠a̠ d̠iobh na̠ i̠wal bho̠, wa̠ na̠ a̠tiom d̠a̠ onin e̠kpa ed̠ia̠n na̠ ami̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ya̠gia̠ga̠i, O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠mugh agu̠o̠ u̠ge̠ ogboloma̠ ina̠ bho̠, ya̠a̠ itogi e̠ro̠ enigha̠ ma̠ o̠ni̠ wa̠ ta̠ a̠wol O̠nyi̠ ta̠ O̠ni̠ bho̠. Ka̠ ibhon a̠pu ma̠ u̠mar d̠o̠ ma̠ o̠ni̠ obha̠!” ");
INSERT INTO mgj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","D̠a̠ agu̠o̠ awa na̠ ed̠e bho̠, sa̠ A̠zizo̠s a̠bhin abe̠re̠di̠ a̠tutumeni, sa̠ a̠puiny a̠nigha̠ awa sa̠ a̠fugh ma̠a̠, “Ibhine, onon ozu d̠ami̠ wa̠ na̠ onigha̠ inyin bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sa̠ a̠bhin okpa̠ko a̠min, sa̠ a̠nigha̠ ma̠ ali̠se̠bh, sa̠ a̠nigha̠ awa, sa̠ eb̠la̠ awa ibhin i̠d̠a. ");
INSERT INTO mgj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Onon asi̠ d̠ami̠ wa̠ d̠a̠ omom i̠zo̠ bho̠, wa̠ uzu, ma̠ o̠ta eb̠la̠ a̠nwunom o̠si̠ghe̠ d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠ ami̠ ko o̠d̠a mu̠ ma̠ a̠min itu a̠grep tu̠tu̠n a̠d̠a̠ma̠ wa̠ ami̠ ta̠ ad̠a ma̠ omom bho̠ d̠a̠ irileghom ta̠ A̠zib̠a̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sa̠ awa i̠mo̠r aso̠r, sa̠ i̠d̠u̠a i̠gi̠ d̠a̠ Igu Roliv. ");
INSERT INTO mgj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ta̠ aro̠ ma̠ ola̠ eb̠la̠ inyin ta̠ oghel A̠zib̠a̠, ma̠ agu̠o̠ na̠ o̠ge̠ oguri d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠: “ ‘Ami̠ ta̠ agu̠r okponom ro̠nana bho̠ a̠teb̠eli, sa̠ o̠lo̠gh ro̠nana bho̠ ta̠ e̠sasaragi̠an.’ ");
INSERT INTO mgj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ya̠a̠, igiel ami̠ na̠ a̠b̠etina̠, sa̠ ami̠ ta̠ a̠ten agi̠ d̠a̠ Agalili ka̠ a̠b̠a̠ra̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sa̠ A̠puta̠ awo̠ran i̠na ma̠a̠, “Ka̠ aro̠ ma̠ ola̠ eb̠la̠ a̠nwunom i̠we̠le̠man anwa iten i̠d̠u̠a eka̠, ami̠ ko oghil ani̠ d̠o̠ ad̠u̠a.” ");
INSERT INTO mgj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ya̠a̠ A̠zizo̠s agba a̠nigha̠ i̠na ma̠a̠, “Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, a̠d̠ugula̠n onon, kisa̠ olobhiri e̠nu̠r ta̠ alal i̠wal igiel, anwa ta̠ aku̠a ami̠ ma̠ i̠sar igiel, ma̠a̠ anwa na̠ ologhom d̠o̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sa̠ A̠puta̠ akparame̠ni̠ awo̠ran i̠na ma̠a̠, “Ka̠ aro̠ ma̠ ola̠ ami̠ ta̠ a̠d̠igh na̠ anwa a̠mugh eka̠, ami̠ ko o̠ku̠a d̠o̠ nyam.” Sa̠ eb̠la̠ a̠nwunom iyed̠i ifugh ani̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa̠ A̠zizo̠s na̠ ogbo atu̠ghan do̠yo̠ i̠gi̠ d̠a̠ esi ola̠ ubhelegi ma̠ Age̠tse̠mane̠, sa̠ agba a̠nigha̠ awa ma̠a̠, “I̠ro̠ ma̠ a̠dila̠de ma̠ i̠se̠n, ya̠ ami̠ ta̠ agi̠ ka̠ a̠siseiny.” ");
INSERT INTO mgj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sa̠ i̠na a̠bhin A̠puta̠ na̠ A̠zemsi na̠ Azo̠n ab̠aragu̠ma i̠na, sa̠ ibom asu̠su̠ghu̠d̠i̠an na̠ i̠ku̠nu̠ ra̠ id̠igh i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Eloghoma̠n ozu d̠ami̠ na̠ ku̠nu̠ ma̠ ibom, aro̠ ka̠ omugh a̠sugho. I̠ro̠ ma̠ omom ma̠ i̠se̠n.” ");
INSERT INTO mgj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sa̠ i̠na agi̠ d̠a̠ ed̠ia̠ ma̠ i̠ki̠kara ka̠ a̠mel a̠b̠obhia̠n d̠a̠ a̠de, sa̠ a̠siseiny ma̠a̠, ta̠ a̠b̠ur nab̠o̠, obhel onon ka̠ iten ad̠u̠a d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Sa̠ i̠na a̠fugh ma̠a̠: “Ada, O̠we̠de̠, anwa ta̠ a̠rue a̠gir kabar kabar, si̠ghe̠ ma̠ okpa̠ko onon d̠a̠ ozu d̠ami̠. Ya̠ o̠ro̠ d̠o̠ ku d̠a̠ i̠to̠ d̠ami̠, aro̠ d̠a̠ i̠to̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sa̠ i̠na a̠mula̠ agi̠ ka̠ ate̠i̠ awa, sa̠ abi̠gh ma̠ awa na̠ ekod̠u, sa̠ a̠pura̠n A̠puta̠ ma̠a̠, “Asai̠mo̠n, anwa na̠ a̠kod̠u ke̠re̠? Kpo̠ruzu ma̠ e̠ro̠ ma̠ omom bebina̠ o̠nyi̠ obhel. ");
INSERT INTO mgj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","I̠ro̠ ma̠ omom ma̠ esiseiny b̠o̠ka̠ inyin umel d̠o̠ od̠igh d̠a̠ ad̠agi̠an. Na̠ ebhir e̠mu̠gh bho̠, ya̠a̠ ozu bho̠ na̠ a̠dugh.” ");
INSERT INTO mgj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sa̠ i̠na a̠puta̠ agi̠ ka̠ a̠siseiny onin agu̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sa̠ i̠na a̠mula̠ a̠ru ra̠ abi̠gh ma̠ awa na̠ ekod̠u eten, ezin bho̠ a̠rid̠ien d̠awa na̠ e̠mu̠mo̠r ibom ma̠ ola̠ awa iloghom mu ma̠ abar ola̠ o̠wo̠ran o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A̠zizo̠s a̠ru ma̠ oleghemeni i̠sar igiel bho̠, sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠: “Inyin od̠id̠ia̠ na̠ okod̠u na̠ osira̠ ma̠ epobh ke̠re̠? Na̠ a̠bhon! Obhel wa̠ u̠to̠ uguri bho̠ na̠ a̠lei. Ikpone, na̠ owol O̠nyi̠ ta̠ O̠ni̠ o̠lo̠gh d̠a̠ aru̠gu̠o̠ id̠ighi ma̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ib̠egina̠! Id̠ighi ta̠ oten o̠gi̠. O̠ni̠ wa̠ a̠wol ami̠ bho̠ od̠i d̠a̠ aka.” ");
INSERT INTO mgj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A̠zizo̠s od̠id̠ia̠ na̠ a̠fugh, sa̠ A̠zuda̠s odi o̠ni̠ d̠a̠ d̠iobh na̠ i̠wal bho̠ a̠ru na̠ o̠lo̠gh a̠nwunom ya̠ i̠kpanaki̠an ralapa ogidi na̠ re̠b̠am, iya̠ aru̠mu̠ rokur bho̠ na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ na̠ ikei bho̠ iruom. ");
INSERT INTO mgj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","I̠se̠n, o̠ni̠ wa̠ ta̠ a̠wol i̠na bho̠ na̠ agba a̠nigha̠ awa ma̠a̠: “O̠ni̠ wa̠ ami̠ ta̠ api̠pi̠o̠bh bho̠ bha̠ o̠ni̠ bho̠, ib̠ole i̠na ma̠ esibhom e̠kparame̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sa̠ A̠zuda̠s a̠ru d̠a̠ A̠zizo̠s a̠fugh ma̠a̠, “O̠ni̠ Atu̠ghu̠me̠ni̠,” sa̠ api̠pi̠o̠bh i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sa̠ a̠nwunom bho̠ iru ra̠ ipuom A̠zizo̠s d̠a̠ agu̠o̠, sa̠ ib̠ol i̠na, isibhom i̠kparame̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sa̠ odi o̠ni̠ ola̠ aro̠ d̠a̠ etua̠n, abho̠ro̠n alapa ogidi d̠o̠yo̠ sa̠ a̠sobh a̠to ta̠ ob̠a̠ra̠motu we̠mu̠ rokur bho̠ a̠b̠uton. ");
INSERT INTO mgj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “Ami̠ na̠ a̠wia̠n o̠go̠ ebhugh ke̠re̠, ma̠ ola̠ inyin ubhin alapa a̠rigidi na̠ re̠b̠am uru ra̠ ob̠ol ami̠? ");
INSERT INTO mgj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ka̠ a̠d̠a̠ma̠ ka̠ a̠d̠a̠ma̠ ami̠ i̠ro̠ na̠ inyin d̠a̠ Otu ta̠ A̠zib̠a̠ atu̠ghu̠me̠ni̠, ya̠a̠ inyin ub̠ol d̠o̠ ami̠. Ya̠a̠, eb̠la̠ i̠nye̠n na̠ emite ma̠ agu̠o̠ ola̠ ta̠ omuzoghod̠iom i̠di̠ar ya̠ u̠ge̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sa̠ eb̠la̠ awa i̠we̠le̠ i̠na ighil i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Odi o̠nyi̠ oyel ola̠ atu̠o̠no̠m ani̠ ma̠ A̠zizo̠s aro̠ ma̠ i̠se̠, i̠na alagha ma̠ ososora̠n akapa asi̠ni̠ni̠n ku̠ku̠m. A̠nwunom bho̠ i̠b̠ar na̠ i̠na esibh, ");
INSERT INTO mgj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sa̠ i̠na a̠gbugbugha̠ awe̠le̠ ma̠ ososora̠n akapa asi̠ni̠ni̠n bho̠ a̠ghil ad̠u̠a ma̠ e̠dab̠a. ");
INSERT INTO mgj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sa̠ awa ibhin A̠zizo̠s i̠gi̠o̠m we̠mu̠ rokur bho̠, sa̠ eb̠la̠ aru̠mu̠ okur bho̠ na̠ ikei bho̠ na̠ i̠tu̠ghu̠me̠ni̠ oloko bho̠ ikokod̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sa̠ A̠puta̠ aro̠ ma̠ egbeny atu̠o̠no̠m i̠na tu̠tu̠n ka̠ a̠d̠igh d̠a̠ ogigo i̠gada ase̠ ta̠ we̠mu̠ rokur bho̠. Sa̠ a̠d̠igh na̠ rob̠a̠ra̠motu bho̠ aro̠ ma̠ a̠dila̠de a̠sumogha̠n e̠banya bho̠ na̠ amu̠ga. ");
INSERT INTO mgj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I̠se̠ sa̠ ibom rokur bho̠ na̠ eb̠la̠ Ogbo Osobh Ase̠ A̠zu bho̠ i̠bho̠ro̠ghan a̠nwunom ya̠ ta̠ e̠gba ma̠ onyob̠a̠ igunugha̠ eb̠ologiom A̠zizo̠s, ma̠ agu̠o̠ ola̠ awa ta̠ ebhin esobh ase̠ ebhumeni i̠na egigh, ya̠a̠ i̠bi̠gh d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A̠d̠izo ronyob̠a̠ igunugha̠ emite ra̠ e̠gba ma̠ o̠nu̠ eb̠ologiom i̠na, ya̠a̠ o̠nu̠ d̠awa id̠igh d̠o̠ ma̠ onin. ");
INSERT INTO mgj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sa̠ idi ronyob̠a̠ imite, sa̠ i̠gba ma̠ igunugha̠ ib̠ologiom i̠na ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“I̠yar u̠mo̠gho̠n ka̠ o̠ni̠ onon a̠fugh ma̠a̠, ‘Ami̠ ta̠ a̠b̠ogion Otu ta̠ A̠zib̠a̠ wa̠ o̠nyi̠o̠mo̠ro̠ni̠ a̠lo bho̠, sa̠ d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠, sa̠ ami̠ ta̠ a̠mula̠ a̠lo ma̠ opa̠n ola̠ obhin d̠o̠ ma̠ agu̠o̠ olo.’ ” ");
INSERT INTO mgj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eb̠la̠ i̠se̠ eka̠ i̠d̠i̠ar ya̠ awa i̠gba ib̠ologiom A̠zizo̠s bho̠ id̠igh d̠o̠ onin. ");
INSERT INTO mgj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sa̠ We̠mu̠ rokur bho̠ a̠rile a̠d̠igh d̠a̠ esa̠d̠io d̠awa a̠pura̠n A̠zizo̠s ma̠a̠, “Anwa na̠ o̠wo̠ran d̠o̠ ke̠re̠? Onon ka̠ a̠kere a̠d̠ien abar ola̠ na̠ o̠gba na̠ ob̠ologiom anwa?” ");
INSERT INTO mgj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ya̠a̠, A̠zizo̠s aro̠ b̠u̠b̠o̠m, na̠ o̠wo̠ran d̠o̠ ma̠ abar. Sa̠ we̠mu̠ rokur bho̠ a̠puta̠ a̠pura̠n i̠na ma̠a̠, “Anwa Akrai̠st O̠nyi̠ ta̠ A̠zib̠a̠ wa̠ akpe̠ ma̠ otutumeni bho̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ami̠ i̠na. Inyin ta̠ o̠bi̠gh ka̠ O̠nyi̠ ta̠ O̠ni̠ na̠ aro̠ ma̠ a̠dila̠de d̠a̠ agba od̠iom ta̠ A̠zib̠a̠ wa̠ a̠nwuna̠ ma̠ A̠limon A̠pu bho̠. Sekina̠ agu̠o̠ i̠na na̠ a̠ru na̠ ro̠b̠u̠ghu̠b̠u̠gh bho̠ d̠a̠ e̠nai̠ny.” ");
INSERT INTO mgj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sa̠ we̠mu̠ rokur bho̠ ago̠ ma̠ ibura̠ d̠o̠yo̠ a̠fugh ma̠a̠, “Ta̠ odin ere o̠bho̠ro̠ghan ipa̠n ronyob̠a̠?” ");
INSERT INTO mgj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“I̠bi̠ghe̠ ma̠ agu̠o̠ i̠na na̠ a̠fugh a̠fugh i̠basi̠ na̠ a̠gboloma̠ ma̠ A̠zib̠a̠. Inyin u̠bi̠gh eka̠?” Sa̠ eb̠la̠ awa i̠wo̠ran ma̠a̠, “I̠na na̠ api̠o̠gho̠m, akpe̠ ma̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sa̠ idi awa i̠ke̠ ma̠ o̠si̠ro̠gho̠m o̠yo̠ ma̠ i̠gho̠r, sa̠ ibinom a̠misigh d̠o̠yo̠, sa̠ ib̠orogh i̠na, sa̠ ifugh inigha̠ i̠na ma̠a̠ “Wa̠.” Sa̠ rob̠a̠ra̠motu bho̠ ibhin i̠na ib̠orogh. ");
INSERT INTO mgj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa̠ agu̠o̠ A̠puta̠ od̠i ma̠ agba wa̠ ade̠bh d̠a̠ ologi ogigo bho̠, sa̠ odi o̠nyani̠, ob̠a̠ra̠motu ta̠ we̠mu̠ rokur bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","abi̠gh ka̠ A̠puta̠ na̠ amu̠ga ma̠ anya, sa̠ a̠gbiom a̠kpon i̠na, sa̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Anwa odi o̠ni̠ wa̠ i̠ro̠ ani̠ na̠ A̠zizo̠s wa̠ Anazare̠t bho̠.” ");
INSERT INTO mgj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sa̠, A̠puta̠ aku̠a a̠fugh ma̠a̠, “Ami̠ iloghom d̠o̠ ma̠ abar wa̠ anwa na̠ agba bho̠, ami̠ i̠mu̠gho̠nyan d̠o̠ nyam nyen.” Sa̠ A̠puta̠ a̠mite agi̠ ka̠ amara d̠a̠ o̠nu̠ ogigo bho̠, sa̠ olobhiri e̠nu̠r alal. ");
INSERT INTO mgj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sa̠ o̠nyani̠ bho̠ abi̠gh i̠na sa̠ agba a̠nigha̠ ma̠ ogbo ya̠ odi d̠a̠ aka bho̠ ma̠a̠, “Onon odi o̠ni̠ awa!” ");
INSERT INTO mgj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sa̠ a̠mula̠ aku̠a. O̠nyi̠ obhel oten, sa̠ ogbo ya̠ od̠i d̠a̠ aka bho̠ ifugh inigha̠ ma̠ A̠puta̠ ma̠a̠, “Ya̠gia̠ga̠i anwa odi o̠ni̠ awa, ezin bho̠ anwa ola̠ Agalili.” ");
INSERT INTO mgj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","O̠ku̠a sa̠ i̠na ake̠ ma̠ osibhigha̠, ogurugia̠n ma̠a̠, “Ami̠ iloghom d̠o̠ ma̠ o̠ni̠ onon wa̠ inyin na̠ ofugh ogboloma̠ bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I̠se̠ sa̠ olobhiri e̠nu̠r alal wa̠ a̠leghemeni i̠wal igiel. Sa̠ A̠puta̠ aru̠ru̠an agu̠o̠ A̠zizo̠s agba a̠nigha̠ i̠na ma̠a̠, “Kisa̠ e̠nu̠r ta̠ alal i̠wal igiel, anwa ta̠ aku̠a ami̠ ma̠ i̠sar igiel” Sa̠ A̠puta̠ aku̠ru̠ru̠ a̠sorogi ma̠ izin. ");
INSERT INTO mgj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","O̠tu̠o̠no̠m i̠se̠, d̠a̠ obom ame̠ghe̠le̠, sa̠ ogbo aru̠mu̠ okur bho̠ na̠ ikei bho̠, na̠ ogbo atu̠ghu̠me̠ni̠ oloko, na̠ eb̠la̠ ogbo i̠gada ase̠ bho̠ imimia̠n iya̠ ogir ogboloma̠ A̠zizo̠s. Sa̠ i̠bhad̠i̠ i̠na, irileghom i̠gi̠ d̠a̠ Apai̠let. ");
INSERT INTO mgj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sa̠ Apai̠let a̠pura̠n i̠na ma̠a̠: “Anwa o̠li̠le̠ma A̠nwunom A̠zu bho̠ ke̠re̠?” Sa̠ i̠na awo̠ran ma̠a̠, “Anwa na̠ agba.” ");
INSERT INTO mgj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sa̠ ogbo aru̠mu̠ okur bho̠ i̠gba ma̠ a̠d̠izo o̠kpo̠ ib̠ologiom i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sa̠ Apai̠let a̠mula̠ a̠pura̠n i̠na ma̠a̠, “Abar ola̠ anwa inwuna̠ ma̠ o̠wo̠ran bo̠ ke̠re̠? Mu̠gho̠ne̠ ma̠ a̠d̠izo riku ya̠ uler anwa bho̠!” ");
INSERT INTO mgj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ya̠a̠, A̠zizo̠s na̠ omula̠ d̠o̠ awo̠ran abar, ma̠ ola̠ a̠d̠igh Apai̠let ilologia̠n. ");
INSERT INTO mgj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kigiel kigiel ola̠ E̠yal Opel Oten a̠sor, bha̠ na̠ omutiom gha̠n d̠a̠ ikoli ma̠ onin o̠ni̠ ola̠ a̠nwunom bho̠ ipuru. ");
INSERT INTO mgj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","D̠a̠ igiel obha̠, o̠ni̠ ola̠ ubhelegi ma̠ Abarabas, ola̠ a̠d̠igh na̠ ipa̠n ogbo a̠wia̠n a̠dila̠de i̠to̠ ebhugh bho̠, sa̠ igigh o̠ni̠ ma̠ agu̠o̠ e̠ma bho̠ na̠ a̠bhighibhighi bho̠, aro̠ d̠a̠ ikoli. ");
INSERT INTO mgj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sa̠ o̠lo̠gh a̠nwunom bho̠ i̠ke̠ ma̠ opuru agu̠o̠ ola̠ ta̠ ogir agu̠o̠ na̠ ogir gha̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sa̠ Apai̠let awo̠ran awa ma̠a̠, “Inyin na̠ o̠bho̠ro̠gh ma̠ ami̠ imutiom o̠li̠le̠ma A̠zu bho̠ inigha̠ inyin ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ezin bho̠ i̠na abi̠gh ma̠ ogbo aru̠mu̠ okur bho̠ ibhin d̠a̠ egbugbo ologi eb̠ol i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ya̠a̠, ogbo aru̠mu̠ rokur bho̠ itumugiom o̠lo̠gh a̠nwunom bho̠ ma̠ opuru agu̠o̠ ola̠ ta̠ omutiom Abarabas onigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sa̠, Apai̠let a̠puta̠ a̠pura̠n awa ma̠a̠, “O̠ku̠a ka̠ inyin na̠ o̠bho̠ro̠gh ma̠ ami̠ igir ere igboloma̠ ma̠ o̠ni̠ wa̠ inyin na̠ obhelegi ma̠ o̠li̠le̠ma A̠zu bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sa̠ awa ipita̠ i̠ko̠ro̠ ma̠a̠, “I̠du̠e̠ i̠na ma̠ a̠gigh!” ");
INSERT INTO mgj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ya̠a̠, Apai̠let a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere? I̠na a̠gir ere api̠e̠?” Sa̠ awa imula̠ i̠lo̠gh e̠mi̠ imulughu ma̠a̠, “Du̠e̠ i̠na ma̠ a̠gigh!” ");
INSERT INTO mgj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Od̠ighi agu̠o̠ ola̠ ologi a̠nwunom bho̠ ta̠ ab̠al, sa̠ Apai̠let a̠mutiom Abarabas a̠nigha̠ awa. Sa̠ a̠ruom ma̠ o̠gu̠ro̠gh A̠zizo̠s, sa̠ a̠b̠eton a̠nigha̠ awa ma̠ o̠du̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sa̠ ogbo e̠gham bho̠ ibhin A̠zizo̠s i̠gi̠ d̠a̠ otu a̠dila̠de i̠to̠ ta̠ we̠mu̠ ebhugh bho̠, sa̠ ikokod̠i ma̠ eb̠la̠ odi ebu ogbo e̠gham bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sa̠ iburi i̠na ma̠ ososora̠n akapa ozu a̠dolo, sa̠ ilo ma̠ eghoi ib̠ub̠ulom izuom i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sa̠ awa i̠ke̠ ma̠ obhelegima̠ o̠yo̠ ma̠a̠, “E O̠li̠le̠ma A̠zu! I̠yar na̠ obheleguma̠ nyam o!” ");
INSERT INTO mgj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sa̠ ibhin okpeti ib̠orogh e̠mu̠ d̠o̠yo̠, sa̠ i̠si̠ro̠gho̠m i̠na ma̠ i̠gho̠r, sa̠ ikpud̠ia̠n i̠na izuruna̠ ma̠ eghoi. ");
INSERT INTO mgj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sa̠ igiel bho̠ awa na̠ e̠ki̠ri̠ i̠na e̠we̠le̠ bho̠, sa̠ i̠ko̠gi̠o̠n ibura̠ ozu a̠dolo bho̠, sa̠ inwe i̠lo̠gi̠ i̠na ma̠ ibura̠ d̠o̠yo̠, sa̠ irileghom i̠na i̠d̠u̠a ma̠ ka̠ o̠du̠ o̠yo̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa̠ awa i̠mi̠nana ma̠ odi o̠ni̠ ola̠ A̠sirin ola̠ ubhelegi ma̠ Asai̠mo̠n, o̠we̠de̠ ta̠ Ale̠gzanda na̠ A̠rufo̠si̠, d̠a̠ na̠ ad̠u̠a d̠a̠ e̠sala na̠ a̠ru, sa̠ iponoma̠ i̠na ma̠ orol e̠mi̠gi̠re̠ni̠an oriren ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sa̠ inuoghom A̠zizo̠s i̠gi̠ d̠a̠ Ago̠lgo̠ta (a̠ma̠ra̠ ma̠a̠, “Esi okpokpo e̠mu̠.”) ");
INSERT INTO mgj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sa̠ i̠gu̠a ma̠ amaya d̠a̠ a̠min inigha̠ i̠na ma̠ o̠d̠a, ma̠ agu̠o̠ ola̠ i̠na ko ologhoma̠n d̠o̠ ma̠ ali̠gam, ya̠ i̠na na̠ o̠d̠a d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sa̠ ogbo e̠gham bho̠ i̠du̠ i̠na d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠. Sa̠ awa irobh okob̠a̠ ibhin i̠ru̠gi̠an ibura̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I̠du̠ i̠na d̠a̠ esugho o̠wal-obhel ma̠ asi̠ro̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sa̠ i̠ge̠ ma̠ iku ase̠ d̠o̠yo̠ i̠du̠o̠m d̠a̠ anyu̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ ma̠a̠: “O̠LI̠LE̠MA A̠NWUNOM A̠ZU BHO̠.” ");
INSERT INTO mgj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sa̠ i̠du̠ nyen i̠wal i̠bho̠ru̠bho̠ru̠ aru̠gba, odi d̠a̠ agba od̠iom d̠o̠yo̠, ya̠a̠ uwed̠i d̠a̠ okiel.  ");
INSERT INTO mgj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","I̠nye̠n imuzoghod̠iom agu̠o̠ u̠ge̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠; “U̠wal ani̠ i̠na o̠lo̠gh d̠a̠ ogbo id̠ighi ma̠ i̠karabh.” ");
INSERT INTO mgj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa̠ ogbo ya̠ na̠ eten bho̠ i̠ki̠ri̠ i̠na izizigha̠ ma̠ aru̠mu̠ d̠awa inigha̠ i̠na ma̠ e̠ka ifugh ma̠a̠, “A̠soroma̠ nyam! Anwa wa̠ i̠gba ma̠ anwa ta̠ a̠rue a̠b̠ogion Otu ta̠ A̠zib̠a̠, sa̠ ta̠ a̠mula̠ a̠lo amado̠n d̠a̠ a̠bin i̠sar a̠d̠a̠ma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tenemeni ma̠ ozu d̠oyom, ma̠ a̠sor d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ ma̠ a̠ru!” ");
INSERT INTO mgj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Onin agu̠o̠ bho̠ ogbo aru̠mu̠ rokur bho̠ id̠igh na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ i̠ki̠ri̠ i̠na, sa̠ odi na̠ a̠fugh na̠ a̠nigha̠ ma̠ odi ma̠a̠: “I̠na na̠ a̠tenemeni ma̠ ipa̠n ogbo, ya̠a̠ na̠ orue d̠o̠ ma̠ otenemeni ozu d̠o̠yo̠! ");
INSERT INTO mgj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Akrai̠st O̠li̠le̠ma Izre̠l bho̠! I̠se̠n, sore d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ ma̠ a̠ru, sa̠ i̠yar ta̠ od̠umom anwa!” Sa̠ ogbo ya̠ u̠du̠ na̠ i̠na bho̠ i̠ki̠ri̠ ani̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","O̠te̠i̠ d̠a̠ d̠iobh na̠ i̠wal o̠wal-obhel d̠a̠ azai̠ny, sa̠ azi̠m a̠kpegiom eb̠la̠ ebhugh bho̠ tu̠tu̠n ka̠ ate̠i̠ d̠a̠ i̠sar o̠wal-obhel ma̠ etita̠n. ");
INSERT INTO mgj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","D̠a̠ i̠sar o̠wal-obhel bho̠, sa̠ A̠zizo̠s a̠mulughu na̠ obom okoroko ma̠a̠, “E̠lo̠i̠, E̠lo̠i̠, lama sabaktani̠?” (onon a̠ma̠ra̠ ma̠a̠, “A̠zib̠a̠ d̠ami̠, A̠zib̠a̠ d̠ami̠, anwa idin ere na̠ a̠gin ami̠?”) ");
INSERT INTO mgj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sa̠ idi awa ya̠ i̠mara ma̠ i̠se̠ bho̠ ifugh ma̠a̠, “Na̠ a̠bhelegi ma̠ I̠lai̠za.” ");
INSERT INTO mgj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sa̠ odi o̠ni̠ awa a̠ghil ka̠ ato̠ri̠ ma̠ asapu̠ d̠a̠ igheghed̠um a̠min, sa̠ akpu̠o̠m d̠a̠ o̠lo̠ a̠b̠eton a̠nigha̠ i̠na ma̠ o̠d̠a, sa̠ a̠fugh ma̠a̠, “I̠we̠le̠, ta̠ o̠bi̠gh ka̠ I̠lai̠za ta̠ a̠ru ra̠ a̠soroni i̠na.” ");
INSERT INTO mgj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sa̠ A̠zizo̠s a̠bhin obom okoroko a̠mulughu, sa̠ ekpo epobh bho̠ a̠sobha̠n. ");
INSERT INTO mgj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sa̠ ukpe wa̠ d̠a̠ Otu ta̠ A̠zib̠a̠ bho̠, ake̠ d̠a̠ eb̠o bho̠ agu̠an a̠sor i̠wal a̠bin. ");
INSERT INTO mgj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sa̠ igiel bho̠ we̠mu̠ o̠lo̠gh e̠gham wa̠ aro̠ d̠a̠ aka a̠sumogha̠n A̠zizo̠s, abi̠gh agu̠o̠ bho̠ i̠na a̠bhin a̠mugh bho̠, sa̠ a̠fugh ma̠a̠, “Ya̠gia̠ga̠i, onon O̠nyi̠ ta̠ A̠zib̠a̠!” ");
INSERT INTO mgj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Idi anwani̠ e̠ro̠ nyen ma̠ ya̠ i̠mara ma̠ egbeny ekpon. Anwani̠ i̠ye̠ A̠meri wa̠ Amagdala bho̠, na̠ A̠meri onweni ta̠ A̠zemsi o̠gbara bho̠ na̠ A̠zosisi o̠gbara bho̠, na̠ Asalomi. ");
INSERT INTO mgj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Awa i̠tu̠o̠no̠m i̠na e̠lo̠gh agu̠o̠ enigha̠ i̠na ma̠ obhel bho̠ i̠na aro̠ d̠a̠ Agalili bho̠. A̠d̠izo ipa̠n anwani̠ ya̠ id̠igh na̠ i̠na i̠gi̠ d̠a̠ A̠zeruse̠le̠m bho̠ e̠ro̠ ani̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Igiel bho̠ ate̠i̠ a̠dule A̠d̠a̠ma̠ A̠kokod̠ia̠n bho̠, wa̠ i̠b̠ala bho̠ aro̠ ma̠ A̠d̠a̠ma̠ Osira̠ Epobh bho̠, ");
INSERT INTO mgj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","sa̠ A̠zose̠fu̠ wa̠ Ari̠mati̠a bho̠, odi o̠ni̠ i̠gada ase̠ bho̠, ola̠ ubhin i̠tu̠o̠m abar ibom, ola̠ na̠ a̠gon irileghom ta̠ A̠zib̠a̠, akpo̠ ma̠ ologi agi̠ d̠a̠ Apai̠let ka̠ a̠puru ma̠ ozu ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sa̠ a̠d̠igh ilologia̠n Apai̠let ma̠ o̠mu̠gho̠n ma̠ A̠zizo̠s na̠ a̠mugh ka̠ a̠mugha̠. Sa̠ i̠na a̠bhelegi ma̠ we̠mu̠ o̠lo̠gh e̠gham bho̠ a̠pura̠n ku̠gba ma̠ A̠zizo̠s na̠ a̠mugh ga̠i. ");
INSERT INTO mgj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sa̠ igiel bho̠ Apai̠let na̠ amu̠gho̠n d̠a̠ o̠nu̠ we̠mu̠ e̠gham bho̠, sa̠ a̠nigha̠ ma̠ ozu bho̠ ma̠ A̠zose̠fu̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sa̠ A̠zose̠fu̠ a̠gho ma̠ ukpe asi̠ni̠ni̠n, sa̠ a̠soroni ma̠ egua̠de bho̠, sa̠ a̠bhin ukpe bho̠ a̠bhurugi. Sa̠ a̠d̠i i̠na d̠a̠ od̠i ola̠ i̠na a̠b̠u a̠mutiom d̠a̠ a̠gbo o̠gbi̠o̠ma, sa̠ a̠kikiligi ma̠ o̠gbi̠o̠ma a̠kpegiom od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sa̠ A̠meri wa̠ Amagdala bho̠ na̠ A̠meri onweni ta̠ A̠zosisi i̠bi̠gh esi wa̠ ud̠i i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A̠d̠a̠ma̠ Osira̠ Epobh bho̠ a̠ten, sa̠ A̠meri wa̠ Amagdala bho̠ na̠ A̠meri onweni ta̠ A̠zemsi na̠ Asalomi, igho ma̠ i̠gho̠gho̠ ed̠u e̠nu̠nu̠ ma̠ agu̠o̠ ola̠ awa ta̠ e̠gi̠ ka̠ eduduom ozu ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Obom ogbo asi̠ro̠ i̠b̠ala A̠d̠a̠ma̠ Osira̠ Epobh bho̠, sa̠ awa iten i̠gi̠ d̠a̠ od̠i bho̠ ma̠ agu̠o̠ ogogo bho̠ a̠pu na̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Igiel bho̠ awa na̠ e̠gi̠ bho̠, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “A̠nyen ta̠ a̠kikiligi ma̠ o̠gbe̠o̠ma bho̠ asi̠ghe̠ d̠a̠ o̠nu̠ od̠i bho̠?” ");
INSERT INTO mgj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sa̠ awa ikpon d̠a̠ ed̠ia̠ bha̠ na̠ okikiligi ma̠ o̠gbe̠o̠ma bho̠ o̠si̠ghe̠. Ezin bho̠ o̠gbe̠o̠ma bho̠ abu̠gh ibom. ");
INSERT INTO mgj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sa̠ awa id̠igh d̠a̠ ologi od̠i bho̠ i̠bi̠gh o̠nyi̠ oyel ola̠ od̠i ma̠ a̠dila̠de d̠a̠ od̠iom agba bho̠, ibura̠ bho̠ na̠ esosorogia̠n, sa̠ a̠rugugu isibh awa. ");
INSERT INTO mgj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sa̠ o̠ni̠ bho̠ a̠fugh a̠nigha̠ awa ma̠a̠, “O̠ni̠ ko o̠ku̠nu̠! Inyin na̠ o̠bho̠ro̠gh A̠zizo̠s wa̠ Anazare̠t bho̠, wa̠ u̠du̠ ugigh d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠. I̠na na̠ b̠etina̠. I̠na bo̠ ma̠ i̠se̠n! I̠bi̠ghe̠ ma̠ esi bho̠ u̠mu̠ni̠e̠ni̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ebula̠ o̠ku̠a, i̠gi̠e̠ ma̠ i̠se̠n ka̠ e̠gba ma̠ enigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ na̠ i̠na A̠puta̠ ma̠a̠, ‘I̠na na̠ a̠b̠etina̠ d̠a̠ omugh, na̠ a̠ten na̠ agi̠ d̠a̠ Agalili ka̠ ob̠a̠ra̠ inyin. Obha̠ esi inyin ta̠ o̠bi̠gh i̠na, ma̠ agu̠o̠ i̠na agba a̠nigha̠ inyin bho̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sa̠ awa ighil i̠d̠u̠a d̠a̠ od̠i bho̠ d̠a̠ ekpoyogha̠n ologi na̠ a̠rugugu. Ya̠a̠, awa i̠gba d̠o̠ ma̠ abar enigha̠ ma̠ o̠ni̠, ma̠ ebula̠ a̠rugugu.  ");
INSERT INTO mgj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Obhel bho̠ A̠zizo̠s a̠b̠etina̠ d̠a̠ omugh bho̠, ma̠ ame̠ghe̠le̠ d̠a̠ o̠pu̠r a̠d̠a̠ma̠ d̠a̠ esi a̠d̠a̠ma̠ bho̠, bha̠ i̠na a̠d̠ia̠ a̠mutuma̠ ma̠ A̠meri wa̠ Amagdala bho̠, ani̠ wa̠ i̠na a̠ze ma̠ od̠ua̠l i̠karabh aru̠mu̠gh asi̠ghe̠ d̠a̠ ozu bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sa̠ i̠na a̠ten agi̠ ka̠ agba a̠nigha̠ ma̠ ogbo ya̠ i̠ro̠ na̠ A̠zizo̠s bho̠, ya̠ od̠i d̠a̠ i̠ku̠nu̠ na̠ ed̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sa̠ obhel bho̠ awa i̠mu̠gho̠n ma̠a̠ A̠zizo̠s na̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um bho̠, ya̠ ma̠a̠ i̠na na̠ abi̠gh bho̠, ku̠ku̠m eka̠ awa id̠umom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Onon a̠ten, sa̠ A̠zizo̠s a̠mutuma̠ ma̠ i̠wal ogbo i̠tu̠o̠no̠m d̠o̠yo̠ ma̠ opa̠n a̠d̠ien agu̠o̠, d̠a̠ obhel ola̠ awa na̠ erile na̠ e̠gi̠ d̠a̠ odi o̠gbara e̠ma. ");
INSERT INTO mgj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sa̠ awa imula̠ i̠gi̠ ka̠ i̠gba inigha̠ ma̠ iyed̠i, ku̠ku̠m eka̠, id̠umom d̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sa̠ A̠zizo̠s a̠mutuma̠ ma̠ d̠iobh na̠ onin bho̠ ma̠ obhel ola̠ awa na̠ ed̠e ma̠ ed̠ia̠n, sa̠ ali̠o̠m awa ma̠ ebula̠ ab̠agh e̠mu̠ ma̠ agu̠o̠ awa od̠umom d̠o̠ bho̠. Ezin bho̠ awa ima̠ra̠ d̠o̠ ma̠ ogbo iya̠ i̠bi̠gh i̠na d̠a̠ obhel wa̠ i̠na na̠ a̠b̠etina̠ d̠a̠ omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sa̠ a̠ruom awa ma̠a̠: “I̠gi̠e̠ d̠a̠ eb̠la̠ e̠mara̠nwunom bho̠ ka̠ e̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ ma̠ enigha̠ ko̠ni̠ ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","O̠ni̠ ola̠ a̠ma̠ra̠ sa̠ uwur amu̠m bha̠ oten, ya̠a̠ ola̠ oma̠ra̠ d̠o̠ bha̠ ta̠ a̠bhin ebhum ase̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sa̠ relegh i̠nye̠n ta̠ e̠tu̠o̠no̠m ogbo ya̠ id̠umom bho̠; d̠a̠ a̠d̠ien d̠ami̠, awa ta̠ eze ma̠ i̠karabh aru̠mu̠gh, sa̠ ta̠ efugh irorua̠ aru̠nu̠ e̠ma, ");
INSERT INTO mgj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","sa̠ awa ta̠ ebhin aru̠gu̠o̠ d̠awa esibhi ma̠ i̠karabh i̠di̠ar, ya̠a̠ abar ka̠ o̠te̠i̠ d̠o̠ awa, sa̠ ka̠ awa i̠d̠a ma̠ abar ola̠ na̠ a̠gigh o̠ni̠ eka̠, abar ka̠ o̠te̠i̠ d̠o̠ awa, ta̠ e̠gbam aru̠gu̠o̠ d̠a̠ ogbo ya̠ na̠ e̠nwe̠r asu̠nwe̠r, sa̠ awa ta̠ ed̠um.” ");
INSERT INTO mgj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Igiel bho̠ Wa̠nwuna̠ A̠zizo̠s agba ma̠ i̠di̠ar i̠nye̠n a̠nigha̠ awa awe̠le̠ bho̠, sa̠ ubhin i̠na ubhuneni d̠a̠ ote̠nai̠ny, sa̠ i̠na ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sa̠ ogbo atu̠ghan bho̠ iten imite ka̠ i̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ kesi kesi, sa̠ Wa̠nwuna̠ bho̠ a̠d̠igh na̠ awa a̠gir, sa̠ a̠muzoghod̠iom o̠nu̠o̠kpe̠ bho̠ na̠ ogir ilologia̠n.");
INSERT INTO mgj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","E! Wa̠ a̠lei abar A̠tiofilo̠s, a̠d̠izo a̠nwunom na̠ e̠ge̠ ma̠ i̠di̠ar ya̠ na̠ omuzoghod̠iom d̠a̠ esa̠d̠io d̠a̠ i̠yar, ");
INSERT INTO mgj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ma̠ agu̠o̠ i̠pu̠r ronyob̠a̠ bho̠ i̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ inigha̠ i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","O̠ku̠a a̠d̠ighi be̠le̠ni̠, agu̠o̠ bho̠ ami̠ na̠ amar a̠bhin obhel a̠lelegi ma̠ eb̠la̠ i̠di̠ar ka̠ d̠a̠ o̠pu̠r ob̠eton bho̠, akpe̠ ami̠ ma̠ o̠ge̠ i̠di̠ar i̠nye̠n oselegi onigha̠ onyom, ");
INSERT INTO mgj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ma̠ agu̠o̠ ola̠ anwa ta̠ amar a̠loghom iya̠gia̠ga̠i bho̠, ma̠ d̠a̠ i̠di̠ar ya̠ na̠ o̠tu̠ghu̠me̠ni̠ ma̠ anwa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","D̠a̠ obhel ola̠ E̠ro̠d aro̠ ma̠ O̠li̠la ebhugh A̠zudia̠, okur ta̠ A̠zib̠a̠ ola̠ ubhelegi ma̠ Azakaraya d̠a̠ ebu rokur ta̠ Abi̠za aro̠. E̠li̠zabe̠t ani̠ d̠o̠yo̠ eka̠ ola̠ eghun ta̠ Ero̠n. ");
INSERT INTO mgj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","I̠wal awa irugh a̠ma̠rugh igielake̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠, sa̠ ikoko ma̠ eb̠la̠ roloko na̠ i̠to̠to̠gi̠ ta̠ Wa̠nwuna̠ bho̠; e̠kal ola̠ o̠li̠o̠m awa na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ya̠a̠ awa o̠nyi̠ na̠ o̠ro̠ d̠o̠, ezin bho̠ E̠li̠zabe̠t aro̠ ma̠ e̠marani̠. Awa na̠ e̠mar eten ikei-a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Igiel bho̠ a̠gir ate̠i̠ ebu rokur ta̠ Azakaraya ma̠ ogir ogir-okur ta̠ A̠zib̠a̠ d̠a̠ Otuta̠zib̠a̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","sa̠ awa irobh okob̠a̠ ibhin i̠so̠n Azakaraya ma̠ d̠a̠ ed̠ighiom i̠di̠ar rokur bho̠, ma̠ od̠igh d̠a̠ Otu ta̠ A̠zib̠a̠ o̠su̠o̠m i̠tani̠ ed̠u-e̠nu̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Igiel bho̠ a̠lei o̠su̠o̠m i̠tani̠ ed̠u-e̠nu̠nu̠ bho̠, eb̠la̠ o̠lo̠gh a̠nwunom ya̠ i̠ro̠ d̠a̠ a̠kokod̠ia̠n bho̠, i̠ro̠ d̠a̠ etire na̠ esiseiny. ");
INSERT INTO mgj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sa̠ orileduom ta̠ Wa̠nwuna̠ bho̠ a̠mutuma̠ i̠na d̠a̠ agba od̠iom enwen i̠ko̠l i̠tani̠ ed̠u-e̠nu̠nu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Igiel bho̠ Azakaraya abi̠gh orileduom ta̠ A̠zib̠a̠ bho̠, sa̠ Azakaraya a̠kpa̠ra̠noma̠, sa̠ a̠rugugu isibh i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ya̠a̠, orileduom ta̠ A̠zib̠a̠ bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠: “Azakaraya, ko oghil a̠rugugu; na̠ o̠mu̠gho̠n a̠siseiny d̠oyom. Ani̠ d̠oyom E̠li̠zabe̠t ta̠ amar olobhiri o̠nyi̠ a̠nigha̠ nya̠m, sa̠ anwa ta̠ a̠ghol i̠na ma̠ Azo̠n. ");
INSERT INTO mgj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","I̠na ta̠ a̠bhin a̠libhon ologi na̠ ibo a̠ruom anwa, sa̠ a̠d̠izo a̠nwunom ta̠ ebhon ologi d̠a̠ ebula̠ i̠mara d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","I̠na ta̠ abu̠gh d̠a̠ a̠misigh ta̠ Wa̠nwuna̠ bho̠. I̠na ko o̠d̠a d̠o̠ na̠ o̠d̠a ma̠ a̠min ya̠ na̠ epuru ma̠ o̠ni̠, ya̠a̠ ta̠ obhin E̠mu̠gh E̠tu̠tu̠ bho̠ o̠lo̠gh d̠a̠ ozu d̠o̠yo̠, omuzoghod̠i d̠a̠ okurogh, kisa̠ ta̠ o̠mar i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I̠na ta̠ a̠d̠ighi ma̠ ola̠ a̠d̠izo a̠nwunom Izre̠l ta̠ etiba̠ra̠ eru d̠a̠ Wa̠nwuna̠ A̠zib̠a̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I̠na ta̠ a̠d̠ia̠ a̠ru na̠ Wa̠nwuna̠ bho̠, sa̠ ta̠ a̠bhin a̠d̠ien e̠mu̠gh na̠ a̠limon ya̠ I̠lai̠za a̠rughom bho̠, a̠tulugi ma̠ rologi ta̠ ronweni na̠ ro̠we̠de̠, na̠ anwi̠i̠ny d̠awa; sa̠ ogbo ya̠ na̠ e̠b̠agh e̠mu̠ bho̠ ta̠ etiba̠ra̠ erugh a̠ghud̠um igielake̠, na̠ o̠tu̠ghu̠man a̠nwunom ya̠ ta̠ e̠ro̠ eb̠a̠ra̠ ma̠ Wa̠nwuna̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sa̠ Azakaraya a̠pura̠n orileduom ta̠ A̠zib̠a̠ bho̠ ma̠a̠, “Ami̠ ta̠ a̠d̠ighi eka̠ a̠ma̠ra̠ ma̠ abar onon, i̠se̠n wa̠ ani̠ d̠ami̠ na̠ ami̠ na̠ o̠kpo̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sa̠ orileduom ta̠ A̠zib̠a̠ bho̠ awo̠ran i̠na ma̠a̠, “Ami̠ A̠gebre̠l. Ami̠ na̠ aro̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠, sa̠ I̠na a̠ruom ami̠ ma̠ o̠gba ib̠eb̠i asu̠gbagba i̠nye̠n onigha̠ oyom. ");
INSERT INTO mgj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nagha, anwa ko orue mu a̠fugh abar tu̠tu̠n ta̠ ate̠i̠ a̠d̠a̠ma̠ wa̠ i̠di̠ar i̠nye̠n ta̠ emite bho̠; ezin bho̠, anwa na̠ oma̠ra̠ d̠o̠ ma̠ asu̠gbagba d̠ami̠ ya̠ ta̠ emite d̠a̠ obhel bho̠ na̠ o̠to̠ oguri bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Igiel bho̠ a̠nwunom na̠ e̠ro̠ na̠ eb̠a̠ra̠ ma̠ Azakaraya bho̠, sa̠ a̠d̠igh awa ma̠ ilologia̠n o̠bi̠gh ma̠ i̠na na̠ aro̠ na̠ a̠bia̠ d̠a̠ Otu ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Igiel bho̠ i̠na a̠mite a̠ru bho̠, i̠na na̠ orue d̠o̠ ma̠ ofugh abar, sa̠ awa iloghom ma̠a̠ i̠na na̠ abi̠gh aghi̠m d̠a̠ Otu ta̠ A̠zib̠a̠, ezin bho̠ i̠na aro̠ ma̠ i̠tu̠o̠gho̠m i̠tu̠o̠gho̠m ya̠ na̠ orue d̠o̠ ma̠ ofugh abar omutiom. ");
INSERT INTO mgj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Obhel bho̠ i̠na na̠ a̠gir a̠muzoghod̠iom d̠a̠ ra̠d̠a̠ma̠ ya̠ u̠to̠ unigha̠ i̠na bho̠, sa̠ i̠na a̠ten a̠yel d̠a̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na̠ obia̠ d̠o̠, sa̠ ani̠ d̠o̠yo̠ E̠li̠zabe̠t a̠mumor, sa̠ a̠bhin ogho uwetire aro̠ ma̠ esi ola̠ o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Sa̠ E̠li̠zabe̠t a̠fugh ma̠a̠, “I̠se̠n Wa̠nwuna̠ bho̠ na̠ a̠kpon ami̠ ma̠ igbirigbir asi̠ghe̠ ma̠ ari̠ghe̠l d̠ami̠ d̠a̠ esa̠d̠io a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Igiel bho̠ eghun ta̠ E̠li̠zabe̠t a̠lei odin uwetire bho̠, sa̠ A̠zib̠a̠ a̠ruom orileduom d̠o̠yo̠ A̠gebre̠l, ma̠ o̠gi̠ d̠a̠ Anazare̠t e̠ma ola̠ od̠i d̠a̠ Agalili, ");
INSERT INTO mgj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ka̠ o̠bi̠ghan e̠kar o̠nyani̠, ola̠ ubhelegi ma̠ A̠meri, ola̠ odi o̠nyi̠ eghun ta̠ A̠devidi, ola̠ ubhelegi ma̠ A̠zose̠fu̠, na̠ a̠sibh obhin ani̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sa̠ orileduom ta̠ A̠zib̠a̠ bho̠ a̠mutuma̠ ma̠ A̠meri a̠fugh ma̠a̠, “Ami̠ a̠bheleguma̠ ma̠ anwa o, anwa wa̠ e̠no̠gho̠man na̠ e̠te̠i̠ bho̠! Wa̠nwuna̠ bho̠ od̠i na̠ anwa.” ");
INSERT INTO mgj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sa̠ ikpo a̠fugh d̠o̠yo̠ i̠lo̠gh e̠mi̠ i̠su̠su̠ghu̠d̠i̠ ma̠ A̠meri, sa̠ i̠na aru̠ru̠an a̠gboloma̠ ma̠ ezin ipelegima̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sa̠ orileduom ta̠ A̠zib̠a̠ bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “A̠meri, ko oghil a̠rugugu, e̠ne̠ghe̠ ta̠ A̠zib̠a̠ na̠ e̠te̠i̠ anwa. ");
INSERT INTO mgj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Anwa ta̠ a̠mumor amar olobhiri o̠nyi̠, sa̠ anwa ta̠ a̠ghol a̠d̠ien d̠o̠yo̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I̠na ta̠ abu̠gh e̠mi̠ sa̠ ta̠ obhelegi i̠na ma̠ O̠nyi̠ ta̠ Wagi̠manyu̠ A̠pu bho̠. Wa̠nwuna̠ A̠zib̠a̠ ta̠ a̠nigha̠ i̠na ma̠ i̠kasi̠ o̠li̠le̠ma e̠ma o̠we̠de̠ d̠o̠yo̠ A̠devidi, ");
INSERT INTO mgj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","sa̠ i̠na ta̠ a̠rileghom otu ta̠ A̠zeko̠pu̠, ad̠u̠a ma̠ amu̠m a̠ten amu̠m; ekunuguma̠ ko o̠ro̠ d̠o̠ d̠a̠ irileghom d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sa̠ A̠meri a̠pura̠n orileduom ta̠ A̠zib̠a̠ bho̠ ma̠a̠, “Abar onon ta̠ a̠d̠ighi eka̠ a̠mite, ma̠ agu̠o̠ ami̠ ta̠ ologhom d̠o̠ ma̠ olobhiri-o̠ni̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sa̠ orileduom ta̠ A̠zib̠a̠ bho̠ awo̠ran ma̠a̠, “E̠mu̠gh E̠tu̠tu̠ bho̠ ta̠ a̠sor a̠ru ra̠ a̠mutuma̠ nyam, sa̠ a̠limon ta̠ Wagi̠manyu̠ A̠pu bho̠ ta̠ a̠ghughuom anwa; ma̠ agu̠o̠ ola̠ o̠nyi̠ e̠tu̠tu̠ wa̠ ta̠ o̠mar bho̠, ta̠ obhelegi ma̠a̠ O̠nyi̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kpone, E̠li̠zabe̠t a̠ghisia̠n d̠oyom eka̠ na̠ a̠mumor olobhiri-o̠nyi̠ ma̠ i̠se̠n i̠na na̠ akpo̠ bho̠. Ughol gha̠n i̠na ma̠ a̠d̠ien ma̠ i̠na e̠marani̠, ya̠a̠ onon odin uwetire i̠na od̠i na̠ eghun. ");
INSERT INTO mgj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ezin bho̠, abar ola̠ akpar a̠pu ma̠ A̠zib̠a̠ ma̠ ogir bo̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sa̠ A̠meri awo̠ran ma̠a̠, “Ami̠ ob̠a̠ra̠motu ta̠ Wa̠nwuna̠. Omuzughod̠iom onigha̠ ami̠ ma̠ agu̠o̠ anwa i̠gba bho̠.” Sa̠ orileduom ta̠ A̠zib̠a̠ bho̠ awe̠le̠man i̠na a̠ten ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","D̠a̠ obhel obha̠, sa̠ A̠meri a̠nugia̠n a̠kokod̠ia̠n agi̠ d̠a̠ e̠ma ola̠ od̠i d̠a̠ ebhugh a̠rugugum d̠a̠ A̠zudia̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","sa̠ a̠d̠igh d̠a̠ otu ta̠ Azakaraya sa̠ a̠bheleguma̠ ma̠ E̠li̠zabe̠t. ");
INSERT INTO mgj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Igiel bho̠ E̠li̠zabe̠t amu̠gho̠n ibheleguma̠ ta̠ A̠meri bho̠, sa̠ o̠nyi̠ wa̠ ta̠ o̠mar d̠o̠ bho̠, wa̠ od̠i d̠a̠ otu-imara d̠o̠yo̠ bho̠ a̠nyegia̠n, sa̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠d̠igh d̠a̠ ozu ta̠ E̠li̠zabe̠t a̠muzo. ");
INSERT INTO mgj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sa̠ a̠bhin okoroko ola̠ agi̠ ma̠ anyu̠ a̠fugh ma̠a̠: “A̠zib̠a̠ na̠ a̠tutumeni ma̠ anwa a̠pu d̠a̠ e̠ma ra̠ anwani̠, na̠ a̠tutumeni ma̠ o̠nyi̠ wa̠ od̠i d̠a̠ otu-imara d̠oyom bho̠! ");
INSERT INTO mgj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ezin ka̠ ere ka̠ e̠no̠gho̠man iya̠ o̠ko̠no̠n na̠ eru ra̠ e̠te̠i̠ ami̠, ma̠ ola̠ onweni ta̠ Wa̠nwuna̠ d̠ami̠ ta̠ a̠ru ra̠ a̠zua̠n ami̠? ");
INSERT INTO mgj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Agu̠o̠ okoroko ibheleguma̠ d̠oyom a̠d̠igh d̠a̠ a̠to d̠ami̠ bho̠, sa̠ o̠nyi̠ wa̠ od̠i d̠a̠ okurogh d̠ami̠ bho̠ a̠bhin a̠libhon ologi a̠nyegia̠n. ");
INSERT INTO mgj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Itutumeni e̠ro̠ enigha̠ i̠na wa̠ a̠ma̠ra̠ ma̠a̠ Wa̠nwuna̠ bho̠ ta̠ a̠muzoghod̠iom i̠di̠ar ya̠ i̠na a̠gua̠n a̠nigha̠ i̠na bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sa̠ A̠meri a̠fugh ma̠a̠, “Eloghoma̠n ozu d̠ami̠ na̠ a̠tutumeni ma̠ Wa̠nwuna̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","E̠mu̠gh d̠ami̠ na̠ a̠bhon ologi na̠ a̠nigha̠ ma̠ A̠zib̠a̠ Witenemeni d̠ami̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ezin bho̠ i̠na a̠loghom ado̠l o̠ki̠ri̠me̠ni̠ ozu ob̠a̠ra̠motu d̠o̠yo̠. A̠b̠eton i̠se̠n agi̠ d̠a̠ ed̠ia̠, ad̠u̠a ma̠ amu̠m a̠ten amu̠m ta̠ obhelegi ami̠ ma̠a̠, wa̠ na̠ otutumeni bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ezin bho̠, i̠na Wa̠ A̠limon i̠bu̠gh ipu bho̠ na̠ a̠gir ibom i̠di̠ar a̠nigha̠ ami̠. E̠tu̠tu̠ bha̠ a̠d̠ien d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Igbirigbir d̠o̠yo̠ na̠ e̠te̠i̠ ogbo ya̠ na̠ eghila̠n i̠na bho̠, ad̠u̠a ma̠ amu̠m a̠ten amu̠m. ");
INSERT INTO mgj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I̠na na̠ a̠bhin aru̠gu̠o̠ d̠o̠yo̠ a̠gir ibom i̠di̠ar; i̠na na̠ asasaragi̠ ma̠ ogbo ya̠ na̠ e̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu d̠a̠ i̠ru̠ru̠an d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I̠na na̠ a̠sorogi ma̠ ogbo i̠rileghom bho̠ d̠a̠ ra̠dila̠de d̠awa, ya̠a̠ i̠na na̠ a̠b̠egion ogbo ya̠ olei d̠o̠ ma̠ abar bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I̠na na̠ a̠nigha̠ ma̠ ib̠eb̠i i̠di̠ar ogbo ya̠ od̠i ma̠ o̠ko̠i̠ bho̠ ma̠ od̠e olegha̠n, sa̠ a̠ze ma̠ aru̠li̠la bho̠ ma̠ oyel obhobho i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I̠na aru̠ru̠an okpon igbirigbir d̠o̠yo̠ abhe̠l ob̠a̠ra̠motu d̠o̠yo̠ Izre̠l, ");
INSERT INTO mgj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","na̠ Ebraham na̠ anwi̠i̠ny igha̠la̠ d̠o̠yo̠ kid̠ud̠ul, ma̠ agu̠o̠ i̠na a̠gua̠n a̠nigha̠ ma̠ ro̠we̠de̠ d̠i̠yar bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A̠meri a̠bhin agu̠o̠ i̠sar uwetire aro̠ na̠ E̠li̠zabe̠t ka̠ a̠mula̠ a̠yel d̠a̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Obhel bho̠ eghun ta̠ E̠li̠zabe̠t a̠legha̠n bho̠, sa̠ amar olobhiri o̠nyi̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sa̠ ogbo ya̠ na̠ erugh na̠ etua̠n i̠na bho̠, na̠ ogbo a̠ghisia̠n d̠o̠yo̠ id̠igh na̠ i̠na ibhon ologi ma̠ d̠a̠ obhel wa̠ awa i̠mu̠gho̠n ma̠ Wa̠nwuna̠ bho̠ na̠ a̠kpon i̠na ma̠ ibom igbirigbir bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","D̠a̠ obhel wa̠ o̠nyi̠ bho̠ na̠ a̠lei o̠bhabhanya a̠d̠a̠ma̠ bho̠, sa̠ awa iru ra̠ oti ipo d̠o̠yo̠. Sa̠ awa iru ra̠ ogholom o̠yo̠ ma̠ a̠d̠ien o̠we̠de̠ d̠o̠yo̠ Azakaraya, ");
INSERT INTO mgj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ya̠a̠ onweni d̠o̠yo̠ a̠fugh ma̠a̠, “E̠nyi̠! Ta̠ oghol i̠na ma̠ Azo̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sa̠ awa i̠gba inigha̠ i̠na ma̠a̠, “Eb̠la̠ a̠ghisia̠n d̠inyin, o̠ni̠ ola̠ na̠ a̠d̠e ma̠ a̠d̠ien obha̠ bo̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sa̠ awa ibhin i̠tu̠o̠gho̠m ipura̠n o̠we̠de̠ d̠o̠yo̠ ma̠ a̠d̠ien wa̠ i̠na ta̠ a̠ghol o̠nyi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sa̠ i̠na a̠bhin i̠tu̠o̠gho̠m a̠puru ma̠ ad̠u̠b̠o̠ ola̠ obhin o̠ge̠ abar, sa̠ age̠ ma̠a̠, “A̠d̠ien d̠o̠yo̠ Azo̠n.” Sa̠ eb̠la̠ awa ib̠a̠gha̠gha̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","D̠a̠ onin obhel bho̠ sa̠ o̠nu̠ d̠o̠yo̠ akpati̠na, sa̠ a̠nem d̠o̠yo̠ ako̠gi̠na, sa̠ i̠na ake̠ ma̠ ofugh abar, sa̠ a̠tutumeni ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sa̠ a̠rugugu isibh ogbo ya̠ na̠ erugh d̠a̠ eghighira̠ d̠awa bho̠. Sa̠ asu̠gbagba bho̠ i̠te̠i̠ eb̠la̠ ebhugh a̠rugugum A̠zudia̠, sa̠ a̠nwunom na̠ e̠b̠e̠re̠gi̠an na̠ egboloma̠ ma̠ i̠di̠ar i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sa̠ eb̠la̠ ogbo ya̠ i̠mu̠gho̠n asu̠gbagba bho̠ ibhin i̠lo̠gh d̠a̠ rologi d̠awa, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “O̠gbara-o̠nyi̠ onon ta̠ a̠mite aro̠ eka̠?” Agu̠o̠ ta̠ Wa̠nwuna̠ bho̠ od̠i na̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sa̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠d̠igh d̠a̠ ozu o̠we̠de̠ d̠o̠yo̠ Azakaraya a̠muzo, sa̠ i̠na a̠wa̠ ma̠ iwowa̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Itutumeni e̠ro̠ enigha̠ ma̠ Wa̠nwuna̠, A̠zib̠a̠ Izre̠l, ezin bho̠, I̠na na̠ a̠zua̠n a̠nwunom d̠o̠yo̠, ata awa a̠bhin. ");
INSERT INTO mgj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","I̠na na̠ a̠b̠eton o̠bhal itenemeni a̠nigha̠ i̠yar d̠a̠ eghun otu ta̠ A̠devidi ob̠a̠ra̠motu d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","agu̠o̠ i̠na a̠rughom a̠riwil e̠tu̠tu̠ d̠o̠yo̠ a̠gua̠n d̠a̠ obhel ola̠ na̠ a̠bia̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ma̠ omiza̠n d̠a̠ agu̠o̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠i̠yar, na̠ d̠a̠ a̠limon ogbo ya̠ na̠ e̠su̠a i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I̠na aru̠ru̠an i̠zo̠ e̠tu̠tu̠ d̠o̠yo̠, sa̠ i̠na a̠nwuna̠ ma̠ okpon igbirigbir a̠nigha̠ ma̠ ibom ro̠we̠de̠ id̠ud̠ul d̠i̠yar, ");
INSERT INTO mgj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","i̠zo̠ ya̠ i̠na a̠d̠ed̠ia̠n na̠ o̠we̠de̠ d̠i̠yar Ebraham bho̠: ");
INSERT INTO mgj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ma̠ otenemeni i̠yar d̠a̠ aru̠gu̠o̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠i̠yar, b̠o̠ka̠ i̠yar ubhin a̠rugugu o̠ko̠l i̠na, ");
INSERT INTO mgj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ya̠a̠ obhin d̠a̠ e̠b̠ab̠ala na̠ ado̠l igielake̠ o̠ro̠ d̠a̠ a̠misigh d̠o̠yo̠, ma̠ eb̠la̠ ra̠d̠a̠ma̠ a̠ghud̠um d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sa̠ anwa, o̠nyi̠ d̠ami̠, ta̠ obhelegi nyam ma̠ owil ta̠ Wagi̠manyu̠ A̠pu bho̠; ezin bho̠ anwa ta̠ aro̠ d̠a̠ ed̠ia̠ ta̠ Wa̠nwuna̠ bho̠, ma̠ o̠tu̠ghu̠man eten bho̠ onigha̠ o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na̠ o̠tu̠ghu̠me̠ni̠ a̠nwunom d̠o̠yo̠ ma̠ eloghom abar oten, wa̠ awo̠l d̠a̠ okpon i̠karabh o̠si̠ghe̠ a̠d̠ien a̠ru bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","d̠a̠ ebula̠ okpon igbirigbir ta̠ A̠zib̠a̠ d̠i̠yar, ogogo wa̠ na̠ a̠b̠etina̠ ma̠ ad̠i̠ro̠ bho̠ ta̠ ad̠u̠a d̠a̠ ote̠nai̠ny amu̠o̠m i̠yar ");
INSERT INTO mgj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ma̠ onigha̠ e̠b̠alab̠al ogbo ya̠ od̠i d̠a̠ azi̠m, na̠ ogbo ya̠ od̠i d̠a̠ i̠ku̠nu̠ omugh bho̠, na̠ orileghom re̠b̠ab̠a a̠sike d̠i̠yar ka̠ od̠ighom d̠a̠ eten ekima̠.” ");
INSERT INTO mgj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sa̠ o̠nyi̠ bho̠ a̠bhobh sa̠ aghu̠a d̠a̠ e̠mu̠gh. A̠rugh d̠a̠ e̠ghana tu̠tu̠n ate̠i̠ obhel wa̠ i̠na ake̠ ma̠ ogir d̠o̠yo̠ d̠a̠ Izre̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","D̠a̠ ra̠d̠a̠ma̠ i̠nye̠, sa̠ A̠siza̠ O̠go̠sto̠s alo̠gh oloko ma̠a̠, o̠wal eb̠la̠ a̠nwunom ya̠ od̠i d̠a̠ ekpukpu ebhugh A̠rom. ");
INSERT INTO mgj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Onon o̠pu̠r o̠wal a̠nwunom wa̠ a̠mite d̠a̠ amu̠m igiel wa̠ Akwi̠ri̠ni̠o̠s na̠ a̠rileghom ebhugh A̠siria̠.) ");
INSERT INTO mgj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa̠ ko̠ni̠ko̠ni̠ a̠ten agi̠ d̠a̠ e̠ma d̠o̠yo̠ ma̠ ka̠ o̠ge̠ a̠d̠ien d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ebula̠ o̠ku̠a, sa̠ A̠zose̠fu̠ eka̠ ad̠u̠a d̠a̠ e̠ma Anazare̠t d̠a̠ Agalili a̠ten agi̠ d̠a̠ e̠ma Abe̠ti̠li̠he̠m wa̠ od̠i d̠a̠ A̠zudia̠ bho̠, ezin bho̠ i̠na ola̠ eghun otu ta̠ A̠devidi. ");
INSERT INTO mgj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I̠na ab̠ar na̠ A̠meri, wa̠ i̠na na̠ a̠sibh obhin ani̠ bho̠ a̠bhin agi̠ d̠a̠ o̠wal a̠nwunom bho̠, d̠a̠ obhel ola̠ eghun bho̠ na̠ a̠legha̠n. ");
INSERT INTO mgj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","D̠a̠ agu̠o̠ awa od̠i ma̠ i̠se̠ bho̠ sa̠ eghun ta̠ A̠meri ake̠ ma̠ ogun. ");
INSERT INTO mgj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sa̠ i̠na amar o̠kpana o̠nyi̠ d̠o̠yo̠, olobhiri. Sa̠ a̠bhin a̠rukpe a̠bhurugi i̠na, sa̠ amu̠ni̠e̠ni̠ i̠na d̠a̠ igba̠ ola̠ na̠ obhin na̠ o̠lo̠gh ed̠ia̠n na̠ onigha̠ ma̠ i̠nam, ezin bho̠ e̠kpe̠ na̠ o̠ro̠ d̠o̠ d̠a̠ otu esul bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ikponom ro̠nana e̠ro̠ d̠a̠ e̠sala i̠gho̠gho̠ ola̠ a̠tua̠n, na̠ ekponom i̠nam d̠awa ma̠ a̠d̠uga̠la̠n obha̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Odi orileduom ta̠ A̠zib̠a̠ a̠mutuma̠ awa, sa̠ isosorogia̠n ta̠ Wa̠nwuna̠ amu̠o̠m awa ma̠ ola̠ a̠rugugu isibh awa. ");
INSERT INTO mgj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ya̠a̠, orileduom ta̠ A̠zib̠a̠ bho̠ agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ko oghil a̠rugugu. Ami̠ ibhin ib̠eb̠i asu̠gbagba ibom a̠libhon ologi ya̠ ta̠ e̠ro̠ enigha̠ ma̠ eb̠la̠ a̠nwunom a̠ruom inyin. ");
INSERT INTO mgj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na̠ o̠mar Witenemeni bho̠ onigha̠ inyin d̠a̠ e̠ma ta̠ A̠devidi ma̠ a̠didon. I̠na Akrai̠st Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Onon ta̠ aro̠ ma̠ elegh a̠nigha̠ inyin: Inyin ta̠ o̠bi̠gh o̠nyi̠ ola̠ ubhin a̠rukpe ubhurugi, sa̠ u̠mu̠ni̠e̠ni̠ d̠a̠ igba̠ ola̠ na̠ obhin na̠ o̠lo̠gh ed̠ia̠n na̠ onigha̠ ma̠ i̠nam.” ");
INSERT INTO mgj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","D̠a̠ awai̠, sa̠ o̠lo̠gh itileduom ta̠ A̠zib̠a̠ d̠a̠ ote̠nai̠ny iru ra̠ i̠b̠aragu̠ma ma̠ orileduom ta̠ A̠zib̠a̠ bho̠, sa̠ itutumeni ma̠ A̠zib̠a̠ na̠ efugh ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Itutumeni e̠ro̠ enigha̠ ma̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ ote̠nai̠ny wa̠ agi̠ ma̠ anyu̠ a̠pu bho̠, ya̠a̠ ekima̠ aro̠ d̠a̠ a̠de onon a̠nigha̠ ma̠ ogbo ya̠ e̠ne̠ghe̠ d̠o̠yo̠ na̠ e̠te̠i̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","D̠a̠ obhel wa̠ itileduom ta̠ A̠zib̠a̠ bho̠ i̠we̠le̠ awa ibhun d̠a̠ ote̠nai̠ny bho̠, sa̠ ikponom ro̠nana bho̠ odi a̠fugh a̠nigha̠ ma̠ odi ma̠a̠, “Id̠ighi o̠gi̠ d̠a̠ Abe̠ti̠li̠he̠m ka̠ o̠bi̠gh abar onon wa̠ na̠ a̠mite bho̠, wa̠ Wa̠nwuna̠ na̠ agba a̠nigha̠ i̠yar bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sa̠ awa inugia̠n i̠gi̠ sa̠ i̠bi̠gh A̠meri na̠ A̠zose̠fu̠ na̠ o̠nyi̠ bho̠, wa̠ awa i̠mu̠ni̠e̠ni̠ d̠a̠ igba̠ ola̠ na̠ obhin na̠ o̠lo̠gh ed̠ia̠n na̠ onigha̠ ma̠ i̠nam bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Igiel bho̠ awa na̠ e̠bi̠gh o̠nyi̠ bho̠, sa̠ awa i̠gba i̠sasaragi̠ ma̠ i̠di̠ar ya̠ imite bho̠, na̠ iya̠ orileduom ta̠ A̠zib̠a̠ agba a̠gboloma̠ ma̠ o̠nyi̠ onon a̠nigha̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sa̠ a̠d̠igh ilologia̠n eb̠la̠ ogbo ya̠ i̠mu̠gho̠n asu̠gbagba ya̠ ikponom ro̠nana bho̠ i̠gba inigha̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ya̠a̠ A̠meri a̠bhin eb̠la̠ i̠di̠ar i̠nye̠n alo̠gh d̠a̠ ologi d̠o̠yo̠ a̠guri, sa̠ aru̠ru̠an ghan a̠gboloma̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ikponom ro̠nana bho̠ imula̠ iyel, sa̠ itutumeni ma̠ A̠zib̠a̠, sa̠ i̠bu̠ghu̠me̠ni̠ i̠na d̠a̠ eb̠la̠ i̠di̠ar ya̠ awa i̠mu̠gho̠n, sa̠ i̠bi̠gh bho̠, d̠a̠ agu̠o̠ u̠gba unigha̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Oleghemeni o̠bhabhanya a̠d̠a̠ma̠ i̠mara bho̠, d̠a̠ obhel ola̠ na̠ a̠lei oti ipo o̠nyi̠ bho̠, sa̠ ughol i̠na ma̠ A̠zizo̠s, a̠d̠ien wa̠ orileduom ta̠ A̠zib̠a̠ bho̠ a̠ghol kisa̠ umumor i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Obhel wa̠ ate̠i̠ i̠ko̠l o̠b̠ab̠alame̠ni̠ ozu bho̠, d̠a̠ agu̠o̠ u̠ge̠ d̠a̠ oloko ta̠ A̠mozizi bho̠, sa̠ A̠zose̠fu̠ na̠ A̠meri ibhin i̠na i̠gi̠ d̠a̠ A̠zeruse̠le̠m ma̠ ob̠eton o̠yo̠ onigha̠ Wa̠nwuna̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(ma̠ agu̠o̠ u̠ge̠ d̠a̠ oloko ta̠ Wa̠nwuna̠ bho̠ ma̠a̠, “Kerekere o̠kpana olobhiri o̠nyi̠ ma̠ ta̠ ob̠eton onigha̠ ma̠ Wa̠nwuna̠.”) ");
INSERT INTO mgj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sa̠ awa i̠gi̠ ka̠ i̠ko̠l i̠ko̠l o̠b̠ab̠alame̠ni̠ ozu, ma̠ agu̠o̠ u̠to̠ d̠a̠ oloko ta̠ Wa̠nwuna̠ bho̠. I̠di̠ar i̠ko̠l bho̠ bha̠ i̠wal ikpo rokur osege, bo̠d̠o̠ i̠wal ikubh rukpugh. ");
INSERT INTO mgj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","D̠a̠ obhel obha̠, odi o̠ni̠ ola̠ ubhelegi ma̠ A̠simio̠n aro̠ d̠a̠ A̠zeruse̠le̠m, ma̠ ola̠ a̠rugh ado̠l igielake̠, sa̠ a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ A̠zib̠a̠. I̠na aro̠ na̠ a̠gon Witenemeni bho̠ ma̠ oru ra̠ otenemeni Izre̠l. E̠mu̠gh E̠tu̠tu̠ bho̠ aro̠ d̠a̠ ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","E̠mu̠gh E̠tu̠tu̠ bho̠ agba a̠nigha i̠na ma̠ i̠na ko omugh d̠o̠, a̠ten ka̠ i̠na na̠ abi̠gh Witenemeni wa̠ A̠zib̠a̠ a̠gua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E̠mu̠gh E̠tu̠tu̠ bho̠ a̠rileghom i̠na ka̠ a̠d̠ighom d̠a̠ ologi Otu ta̠ A̠zib̠a̠. Obha̠ onin obhel wa̠ A̠meri na̠ A̠zose̠fu̠ ibhin o̠gbara o̠nyi̠ A̠zizo̠s id̠igh bho̠, ma̠ omuzoghod̠iom i̠to̠to̠gi̠ oloko bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sa̠ A̠simio̠n a̠bube i̠na sa̠ a̠tutumeni ma̠ A̠zib̠a̠, sa̠ a̠fugh ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wa̠nwuna̠ ma̠ eb̠la̠ a̠limon bho̠, d̠ighi ob̠a̠ra̠motu d̠oyom agi̠ d̠a̠ ekima̠, ma̠ agu̠o̠ anwa igua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","A̠rid̠ien d̠ami̠ na̠ e̠bi̠gh itenemeni d̠oyom, ");
INSERT INTO mgj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wa̠ anwa i̠to̠ iguri ma̠ agu̠o̠ ola̠ a̠nwunom eb̠la̠ ra̠dede ta̠ e̠bi̠gh bho̠: ");
INSERT INTO mgj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ma̠ o̠ro̠ e̠b̠alab̠al onigha̠ ogbo o̠ro̠ d̠o̠ ma̠ A̠zu bho̠, b̠o̠ka̠ awa eloghom itenemeni ta̠ A̠zib̠a̠, na̠ obhin edim onigha̠ a̠nwunom d̠oyom Izre̠l.” ");
INSERT INTO mgj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ed̠igh ilologia̠n onweni na̠ o̠we̠de̠ ta̠ A̠zizo̠s o̠mu̠gho̠n i̠di̠ar ya̠ u̠gba̠ ugboloma̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sa̠ A̠simio̠n a̠du ma̠ o̠gho̠r a̠tutumeni awa sa̠ a̠fugh a̠nigha̠ ma̠ A̠meri, onweni o̠nyi̠ bho̠ ma̠a̠: “A̠zib̠a̠ na̠ aso̠n o̠nyi̠ onon obhin emel na̠ ob̠etina̠ oruom a̠d̠izo a̠nwunom d̠a̠ Izre̠l, na̠ o̠ro̠ elegh ola̠ a̠nwunom ta̠ eghel. ");
INSERT INTO mgj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sa̠ i̠ru̠ru̠an e̠wo̠gi̠na ya̠ od̠i d̠a̠ ologi a̠d̠izo ogbo bho̠ ta̠ eb̠ugh emite. Sa̠ anwa ta̠ aku̠nu̠ ma̠ e̠mi̠ i̠ku̠nu̠ ya̠ ta̠ e̠gu̠b̠an ka̠ alapa ogidi a̠gim ologi d̠oyom awo̠lo̠me̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Owil ani̠ ola̠ ubhelegi ma̠ Ana, o̠nyani̠ ta̠ Afanu̠e̠l d̠a̠ eghun ta̠ Asa eka̠ aro̠. I̠na a̠d̠um, akpo̠ zighizighi. I̠na awal ilom, sa̠ irugha̠n od̠ua̠l ala ku̠ku̠m, sa̠ owolom d̠o̠yo̠ a̠mugh. ");
INSERT INTO mgj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sa̠ i̠na a̠ten ekpukele ani̠ ola̠ na̠ a̠d̠um i̠wal e̠wala na̠ inya̠ ala ma̠ igiel bho̠. I̠na na̠ o̠we̠le̠ d̠o̠ ma̠ o̠gi̠ ghan d̠a̠ Otu ta̠ A̠zib̠a̠ ka̠ ogir ogir, sa̠ aro̠ ma̠ i̠se̠ ako̠l ghan A̠zib̠a, a̠ne ma̠ o̠ko̠i̠, a̠siseiny a̠siseiny, a̠d̠uga̠la̠n na̠ etita̠n. ");
INSERT INTO mgj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","D̠a̠ onin obhel obha̠, sa̠ i̠na agi̠ ka̠ ate̠i̠ awa, sa̠ a̠tutumeni ma̠ A̠zib̠a̠. Sa̠ agba a̠gboloma̠ ma̠ o̠nyi̠ bho̠ a̠nigha̠ ma̠ eb̠la̠ ogbo ya̠ na̠ egon itenemeni A̠zeruse̠le̠m. ");
INSERT INTO mgj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","D̠a̠ obhel wa̠ A̠meri na̠ A̠zose̠fu̠ na̠ egir eb̠la̠ i̠di̠ar ya̠ Oloko ta̠ Wa̠nwuna̠ bho̠ ato̠ bho̠, sa̠ awa imula̠ iyel d̠a̠ e̠ma d̠awa Anazare̠t, d̠a̠ ebhugh Agalili. ");
INSERT INTO mgj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sa̠ o̠nyi̠ bho̠ a̠bhobh na̠ alu̠kpo̠ a̠luzu, sa̠ eloghom abar imuzo d̠a̠ ozu d̠o̠yo̠, sa̠ e̠ne̠ghe̠ ta̠ A̠zib̠a̠ i̠ro̠ na̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kerekere ala o̠we̠de̠ na̠ onweni d̠o̠yo̠ i̠gi̠ghan d̠a̠ A̠zeruse̠le̠m ka̠ od̠e E̠yal Opel Oten. ");
INSERT INTO mgj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Igiel bho̠ i̠na na̠ a̠lei d̠iobh na̠ i̠wal ala bho̠, sa̠ awa i̠gi̠ d̠a̠ e̠yal bho̠ ma̠ agu̠o̠ od̠i d̠a̠ od̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","E̠yal bho̠ a̠ten, sa̠ awa na̠ emula̠, sa̠ A̠zizo̠s a̠sobha̠n aro̠ d̠a̠ A̠zeruse̠le̠m, ya̠a̠ awa iloghoma̠n d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Awa na̠ erile ma̠ e̠mu̠ a̠d̠a̠ma̠ kisa̠ awa iloghoma̠n ma̠ i̠na bo̠ d̠a̠ esa̠d̠io d̠awa, ezin bho̠, awa i̠ru̠ru̠an ma̠ i̠na od̠i ani̠ d̠a̠ o̠lo̠gh d̠awa. Sa̠ awa i̠ke̠ ma̠ o̠bho̠ro̠ghan o̠yo̠ d̠a̠ rebu a̠ghisia̠n na̠ ra̠tologha̠n d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Agu̠o̠ awa o̠bi̠gh d̠o̠ i̠na bho̠, sa̠ awa imula̠ i̠gi̠ d̠a̠ A̠zeruse̠le̠m ka̠ o̠bho̠ro̠ghan o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I̠sar a̠d̠a̠ma̠ iten, kisa̠ awa i̠gi̠ ka̠ i̠bi̠gh i̠na d̠a̠ Otu ta̠ A̠zib̠a̠ d̠a̠ od̠i ma̠ a̠dila̠de, d̠a̠ esa̠d̠io ogbo atu̠ghu̠me̠ni̠. I̠na aro̠ na̠ anagha awa, na̠ a̠pura̠n ipupura̠n. ");
INSERT INTO mgj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ilologia̠n ed̠igh eb̠la̠ ogbo ya̠ i̠mu̠gho̠n i̠na bho̠, d̠a̠ e̠mi̠ amu̠gho̠nyan na̠ awo̠yo̠ghan d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Obhel awa i̠bi̠gh i̠na bho̠, sa̠ awa ib̠a̠gha̠gha̠. Sa̠ onweni d̠o̠yo̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “O o̠nyi̠ d̠ami̠, a̠mite eka̠ ka̠ anwa na̠ a̠d̠ighi i̠yar o̠ko̠no̠n? O̠we̠de̠ d̠oyom na̠ ami̠ na̠ obhin ekpoyogh ologi na̠ o̠bho̠ro̠ghan anwa kesikesi.” ");
INSERT INTO mgj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sa̠ i̠na awo̠ran ma̠a̠, “Inyin u̠tu̠n ere na̠ o̠bho̠ro̠ghan ami̠? Inyin uloghom d̠o̠ ma̠ ami̠ ta̠ aro̠ d̠a̠ otu O̠we̠de̠ d̠ami̠, d̠u̠ko̠?” ");
INSERT INTO mgj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ya̠a̠, awa i̠mu̠gho̠nyan d̠o̠ ma̠ abar wa̠ i̠na na̠ agba bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sa̠ i̠na a̠d̠igh na̠ awa a̠sor agi̠ d̠a̠ Anazare̠t, sa̠ anagha ma̠ o̠nu̠o̠kpe̠ d̠awa. Ya̠a̠, oweni d̠o̠yo̠ a̠koko ma̠ eb̠la̠ i̠di̠ar i̠nye̠n a̠guri ma̠ iya̠ eko d̠a̠ ologi d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sa̠ A̠zizo̠s a̠bhobh d̠a̠ eloghom abar na̠ d̠a̠ ozu, sa̠ ate̠i̠ e̠ne̠ghe̠ d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠ na̠ o̠nyi̠o̠mo̠ro̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Oleghemeni a̠d̠iobh na̠ ogho ala wa̠ A̠siza̠ A̠tiberi̠o̠s, o̠li̠le̠ma A̠rom, na̠ a̠rileghom ebhugh bho̠, Apo̠nti̠o̠s Apai̠let aro̠ ma̠ o̠li̠la ebhugh A̠zudia̠, sa̠ E̠ro̠d na̠ a̠rileghom Agalili, odi a̠bin ebhugh bho̠, ya̠a̠ umor d̠o̠yo̠ A̠filip sa̠ na̠ a̠rileghom Ituria̠ na̠ Atrakonitis, odi a̠bin ebhugh bho̠, sa̠ Ali̠sani̠as na̠ a̠rileghom A̠bilene, odi a̠bin ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","D̠a̠ obhel obha̠, Anas na̠ Akai̠afas i̠ro̠ ma̠ ogbo aru̠mu̠ rokur bho̠, sa̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ ate̠i̠ Azo̠n o̠nyi̠ ta̠ Azakaraya d̠a̠ e̠ghana. ");
INSERT INTO mgj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","I̠na a̠rile ma̠ eb̠la̠ eghighira̠ O̠bhi̠i̠y Azo̠dan agba ma̠ asu̠gbagba otiba̠ra̠ d̠a̠ i̠karabh, na̠ owura̠ amu̠m oleriom ma̠ awa na̠ etiba̠ra̠ d̠a̠ i̠karabh d̠awa e̠te̠i̠ o̠we̠le̠man i̠karabh d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ma̠ agu̠o̠ u̠ge̠ d̠a̠ a̠d̠ire ta̠ Ai̠zaya owil bho̠ ma̠a̠: “Okoroko o̠ni̠ na̠ a̠si na̠ a̠mite d̠a̠ e̠ghana bho̠ ma̠a̠, ‘I̠tu̠ghu̠mane̠ ma̠ eten ta̠ Wa̠nwuna̠ bho̠ ma̠ eguri, ma̠ eselegi ma̠ reten bho̠ ma̠ enigha̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kerekere ogugua̠ ta̠ ob̠a̠la̠me̠ni̠, kerekere igu na̠ egugum ta̠ ogbo o̠de̠bhe̠me̠ni̠. Sa̠ reten ya̠ ib̠eb̠elegia̠n bho̠ ta̠ oselegi, sa̠ ta̠ otulugi ma̠ rigbogolo reten bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sa̠ eb̠la̠ a̠nwunom d̠a̠ ra̠dede bho̠ ta̠ ebi̠gh itenemeni ta̠ A̠zib̠a̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Igiel bho̠ eb̠olob̠ol a̠nwunom na̠ eru d̠a̠ Azo̠n ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠wur awa ma̠ amu̠m bho̠, sa̠ Azo̠n a̠fugh a̠nigha̠ awa ma̠a̠, “Inyin anwi̠i̠ny i̠bho̠ru̠bho̠ru̠ i̠karabh i̠di̠ar! A̠nyen a̠kikiom inyin oghil o̠d̠u̠a d̠a̠ ibom i̠gam ta̠ A̠zib̠a̠ ya̠ na̠ eru bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Imume ma̠ itu otiba̠ra̠ d̠a̠ i̠karabh. Ya̠a̠ o̠ni̠ ko o̠ro̠ ma̠ i̠se̠ ma̠ efugh enigha̠ ma̠ a̠ruzu d̠inyin ma̠a̠, ‘I̠yar unwuna̠ ma̠ obom o̠we̠de̠ a̠ko Ebraham.’ Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, A̠zib̠a̠ ta̠ a̠rue a̠d̠ighi ma̠ ola̠ ikputu i̠nye̠n ta̠ eten anwi̠i̠ny enigha̠ ma̠ Ebraham. ");
INSERT INTO mgj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na̠ oguri ma̠ u̠do̠ d̠a̠ igbolo iriren bho̠, ma̠ agu̠o̠ ola̠ kerekere oriren ola̠ omum d̠o̠ ma̠ ib̠eb̠i imuma̠ sa̠ ta̠ ogu okoton, orobh o̠lo̠gh d̠a̠ anya bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sa̠ a̠nwunom bho̠ ipura̠n i̠na ma̠a̠, “O̠ku̠a ka̠ i̠yar ta̠ od̠ighi eka̠?” ");
INSERT INTO mgj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sa̠ Azo̠n awo̠ran awa ma̠a̠, “I̠na o̠ni̠ wa̠ a̠nwuna̠ ma̠ i̠wal rakapa bho̠ a̠nigha̠ ma̠ odi ma̠ o̠ni̠ wa̠ onwuna̠ d̠o̠ bho̠. I̠na o̠ni̠ wa̠ a̠nwuna̠ ma̠ ed̠ia̠n bho̠ eka̠ aru̠gi̠ a̠nigha̠ ma̠ ogbo ya̠ o̠te̠i̠ d̠o̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Igun ma̠ otua̠-ebhugh bho̠ eka̠ eru ma̠ agu̠o̠ ola̠ ta̠ owur awa ma̠ amu̠m. Sa̠ awa ipura̠n ma̠a̠, “O̠ni̠ a̠tu̠ghu̠me̠ni̠, i̠yar ta̠ od̠ighi eka̠?” ");
INSERT INTO mgj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sa̠ i̠na awo̠ran awa ma̠a̠, “O̠ni̠ ko obhin epeleni ma̠ agu̠o̠ usobh otua̠ bho̠,” ");
INSERT INTO mgj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sa̠ idi iweme̠gham bho̠ ipura̠n i̠na ma̠a̠, “Ya̠a̠ i̠yar ka̠ eka̠, i̠yar ta̠ od̠ighi eka̠?” I̠na awo̠ran ma̠a̠, “O̠ni̠ ko oghum okpoki d̠a̠ agu̠o̠ o̠ni̠ ma̠ ebhin; o̠ni̠ ko obhin d̠a̠ igunugha̠ ma̠ eb̠ologiom a̠nwunom abar nyen, ikpoki ya̠ na̠ o̠kpe̠ inyin bho̠ elegha̠n inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A̠nwunom bho̠ i̠ro̠ na̠ egon Witenemeni bho̠, sa̠ awa na̠ e̠ru̠ru̠an d̠a̠ rologi d̠awa ku̠gba ma̠ Azo̠n Witenemeni bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Azo̠n awo̠ran eb̠la̠ awa ma̠a̠, “Ami̠ na̠ a̠bhin amu̠m na̠ a̠wur inyin; ya̠a̠, o̠ni̠ ola̠ a̠nwuna̠ ma̠ a̠limon a̠pu ami̠ na̠ a̠ru. I̠na o̠ni̠ ola̠ a̠dila̠de d̠ami̠ olei d̠o̠ ma̠ o̠ko̠gi̠o̠n id̠id̠igh ragbaka d̠o̠yo̠. I̠na ta̠ a̠bhin E̠mu̠gh E̠tu̠tu̠ bho̠ na̠ anya a̠wur inyin. ");
INSERT INTO mgj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I̠na na̠ a̠sibh okporoma̠ d̠o̠yo̠ d̠a̠ agu̠o̠, ma̠ obhin ozeghe, okokod̠i i̠bu̠kpa bho̠ od̠ighom d̠a̠ esi eko d̠o̠yo̠ oguri. Sa̠ i̠na ta̠ ab̠i̠r esi ogir bho̠ a̠kpo ma̠ ibhobho bho̠ alo̠gh d̠a̠ anya wa̠ od̠im d̠o̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Azo̠n a̠bhin a̠d̠izo ro̠nu̠ o̠kpe̠ ya̠ o̠ku̠a a̠kikiom a̠nwunom bho̠, sa̠ agba ma̠ ib̠eb̠i asu̠gbagba bho̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","D̠a̠ obhel onon, Azo̠n agam a̠nigha̠ ma̠ E̠ro̠d o̠li̠la ebhugh Agalili, ezin bho̠ i̠na akpakpa ma̠ E̠ro̠di̠as ani̠ umor d̠o̠yo̠ a̠bhin, na̠ d̠a̠ ebula̠ eb̠la̠ ipa̠n i̠karabh ya̠ i̠na a̠gir. ");
INSERT INTO mgj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","E̠ro̠d a̠din o̠ku̠a adu̠o̠m Azo̠n d̠a̠ ikoli, sa̠ a̠bhin i̠karabh i̠nye̠n ab̠aram d̠a̠ eb̠la̠ i̠karabh d̠o̠yo̠ iyed̠i. ");
INSERT INTO mgj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","D̠a̠ obhel wa̠ na̠ owur eb̠la̠ a̠nwunom amu̠m bho̠, sa̠ uwur ani̠ ma̠ A̠zizo̠s. Sa̠ d̠a̠ igiel bho̠ i̠na na̠ a̠siseiny bho̠, sa̠ ote̠nai̠ny bho̠ a̠gurona̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Sa̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠sor a̠ru d̠a̠ i̠pulupul ozu ma̠ agu̠o̠ okur osege, sa̠ okoroko ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru ma̠a̠: “Anwa o̠nyi̠ d̠ami̠, wa̠ ami̠ itula̠n ibom bho̠, wa̠ ologi d̠ami̠ na̠ a̠bhon na̠ a̠ni̠gha̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A̠zizo̠s na̠ a̠lei agu̠o̠ a̠d̠usubh d̠iobh ala d̠a̠ obhel bho̠ i̠na ake̠ ma̠ ogir d̠o̠yo̠ bho̠. A̠nwunom iloghom i̠na ma̠ i̠na o̠nyi̠ ta̠ A̠zose̠fu̠, a̠wa̠ i̠ru̠ru̠an o̠ku̠a. A̠zose̠fu̠ o̠nyi̠ ta̠ E̠li̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","E̠li̠ o̠nyi̠ ta̠ Amatat. Amatat o̠nyi̠ ta̠ A̠livai̠. A̠livai̠ o̠nyi̠ ta̠ Ame̠lki̠. Ame̠lki̠ o̠nyi̠ ta̠ Azana. Azana o̠nyi̠ ta̠ A̠zose̠fu̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A̠zose̠fu̠ o̠nyi̠ ta̠ Amatatayas. Amatatayas o̠nyi̠ ta̠ Emo̠si̠. Emo̠si̠ o̠nyi̠ ta̠ Anahu̠m. Anahu̠m o̠nyi̠ ta̠ Esili. Esili o̠nyi̠ ta̠ Anagayi̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Anagayi̠ o̠nyi̠ ta̠ Amat. Amat o̠nyi̠ ta̠ Amatatayas. Amatatayas o̠nyi̠ ta̠ A̠semeiny. A̠semeiny o̠nyi̠ ta̠ A̠zose̠fu̠. A̠zose̠fu̠ o̠nyi̠ ta̠ A̠zuda̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","A̠zuda̠ o̠nyi̠ ta̠ Azo̠anan. Azo̠anan o̠nyi̠ ta̠ Are̠sa. Are̠sa o̠nyi̠ ta̠ A̠zorobabe̠l. A̠zorobabe̠l o̠nyi̠ ta̠ Ase̠lati̠e̠l. Ase̠lati̠e̠l o̠nyi̠ ta̠ A̠neri. ");
INSERT INTO mgj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","A̠neri o̠nyi̠ ta̠ Ame̠lki̠. Ame̠lki̠ o̠nyi̠ ta̠ Adi̠. Adi̠ o̠nyi̠ ta̠ A̠kosam. A̠kosam o̠nyi̠ ta̠ E̠lmadam. E̠lmadam o̠nyi̠ ta̠ E̠r. ");
INSERT INTO mgj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","E̠r o̠nyi̠ ta̠ A̠zosu̠a. A̠zosu̠a o̠nyi̠ ta̠ E̠li̠eza̠. E̠li̠eza̠ o̠nyi̠ ta̠ A̠zorim. A̠zorim o̠nyi̠ ta̠ Amatat. Amatat o̠nyi̠ ta̠ A̠livai̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","A̠livai̠ o̠nyi̠ ta̠ A̠simio̠n. A̠simio̠n o̠nyi̠ ta̠ A̠zuda̠. A̠zuda̠ o̠nyi̠ ta̠ A̠zose̠fu̠. A̠zose̠fu̠ o̠nyi̠ ta̠ A̠zonam. A̠zonam o̠nyi̠ ta̠ E̠li̠aki̠m. ");
INSERT INTO mgj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","E̠li̠aki̠m o̠nyi̠ ta̠ A̠melea̠. A̠melea̠ o̠nyi̠ ta̠ Ame̠na. Ame̠na o̠nyi̠ ta̠ Amatata. Amatata o̠nyi̠ ta̠ A̠netan. A̠netan o̠nyi̠ ta̠ A̠devidi. ");
INSERT INTO mgj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","A̠devidi o̠nyi̠ ta̠ Aze̠si̠. Aze̠si̠ o̠nyi̠ ta̠ Obe̠di̠. Obe̠di̠ o̠nyi̠ ta̠ A̠boa̠z. A̠boa̠z o̠nyi̠ ta̠ Asalmo̠n. Asalmo̠n o̠nyi̠ ta̠ Anaso̠n. ");
INSERT INTO mgj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Anaso̠n o̠nyi̠ ta̠ Ami̠nadab. Ami̠nadab o̠nyi̠ ta̠ Admin. Admin o̠nyi̠ ta̠ Arni̠. Arni̠ o̠nyi̠ ta̠ E̠zro̠n. E̠zro̠n o̠nyi̠ ta̠ Ape̠re̠zi̠. Ape̠re̠zi̠ o̠nyi̠ ta̠ A̠zuda̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","A̠zuda̠ o̠nyi̠ ta̠ A̠zeko̠pu̠. A̠zeko̠pu̠ o̠nyi̠ ta̠ Azi̠ki̠. Azi̠ki̠ o̠nyi̠ ta̠ Ebraham. Ebraham o̠nyi̠ ta̠ Ate̠ra. Ate̠ra o̠nyi̠ ta̠ Anaho̠. ");
INSERT INTO mgj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Anaho̠ o̠nyi̠ ta̠ Ase̠ru̠g. Ase̠ru̠g o̠nyi̠ ta̠ A̠rewu. A̠rewu o̠nyi̠ ta̠ Ape̠le̠g. Ape̠le̠g o̠nyi̠ ta̠ E̠be̠r. E̠be̠r o̠nyi̠ ta̠ Ase̠la. ");
INSERT INTO mgj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ase̠la o̠nyi̠ ta̠ Akayi̠nan. Akayi̠nan o̠nyi̠ ta̠ Afakzad. Afakzad o̠nyi̠ ta̠ Ase̠m. Ase̠m o̠nyi̠ ta̠ A̠nua̠. A̠nua̠ o̠nyi̠ ta̠ Alame̠k. ");
INSERT INTO mgj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Alame̠k o̠nyi̠ ta̠ Ame̠tuse̠la. Ame̠tuse̠la o̠nyi̠ ta̠ E̠no̠k. E̠no̠k o̠nyi̠ ta̠ Azare̠d. Azare̠d o̠nyi̠ ta̠ Ame̠halale̠l. Ame̠halale̠l o̠nyi̠ ta̠ A̠kenan. ");
INSERT INTO mgj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","A̠kenan o̠nyi̠ ta̠ Eno̠s. Eno̠s o̠nyi̠ ta̠ Ase̠fu̠. Ase̠fu̠ o̠nyi̠ ta̠ Adam. Adam o̠nyi̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Agu̠o̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠d̠igh d̠a̠ ozu ta̠ A̠zizo̠s a̠muzo bho̠, sa̠ i̠na ad̠u̠a d̠a̠ O̠bhi̠i̠y Azo̠dan. Sa̠ E̠mu̠gh bho̠ a̠rileghom i̠na ka̠ a̠d̠ighom d̠a̠ e̠ghana. ");
INSERT INTO mgj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eru bho̠ ad̠agi̠an i̠na d̠a̠ eruba̠l ra̠d̠a̠ma̠ ya̠ i̠na aro̠ ma̠ i̠se̠ bho̠. I̠na na̠ od̠e d̠o̠ ma̠ abar eb̠la̠ ra̠d̠a̠ma̠ i̠nye̠, sa̠ d̠a̠ ekunuguma̠ bho̠ sa̠ o̠ko̠i̠ a̠d̠ighi i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sa̠ Eru bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ku̠gba ma̠ anwa O̠nyi̠ ta̠ A̠zib̠a̠, bha̠ d̠ighi o̠gbaki̠ghe̠ onon a̠tenegia̠n ed̠ia̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Na̠ o̠ge̠ oguri d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠: ‘O̠nyi̠o̠mo̠ro̠ni̠ ko obhin d̠o̠ ma̠ od̠e ed̠ia̠n ku̠ku̠m a̠d̠um.’” ");
INSERT INTO mgj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sa̠ Eru bho̠ a̠rileghom i̠na agi̠ ma̠ esi ola̠ agi̠ ma̠ anyu̠, sa̠ a̠leriom i̠na d̠a̠ ekud̠i obhel ma̠ eb̠la̠ ra̠de e̠ma e̠mara̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sa̠ Eru bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ami̠ ta̠ a̠nigha̠ nyam eb̠la̠ a̠limon na̠ isosorogia̠n d̠awa. Ezin bho̠ na̠ onigha̠ ami̠ ma̠ eb̠la̠ a̠yi, ma̠ ola̠ ami̠ ta̠ a̠rue a̠nigha̠ ko̠ni̠ko̠ni̠ ola̠ a̠d̠igh ami̠ ma̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Oku̠a a̠d̠ighi be̠le̠ni̠, ka̠ anwa ikpud̠ia̠n i̠ko̠l ami̠, ami̠ ta̠ a̠nigha̠ nyam eb̠la̠ a̠yi.” ");
INSERT INTO mgj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Na̠ o̠ge̠ oguri d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠: ‘Kpud̠ia̠ne ma̠ a̠siseiny Wa̠nwuna̠ A̠zib̠a̠ d̠oyom ma̠ ako̠l i̠na ku̠ku̠m.’” ");
INSERT INTO mgj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sa̠ Eru bho̠ a̠rileghom i̠na agi̠ d̠a̠ A̠zeruse̠le̠m, sa̠ a̠bhin i̠na ka̠ amarame̠ni̠ ma̠ esi wa̠ agi̠ ma̠ anyu̠ a̠pu d̠a̠ Otu ta̠ A̠zib̠a̠ bho̠. Sa̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ku̠gba ma̠ anwa O̠nyi̠ ta̠ A̠zib̠a̠, bha̠ pele ma̠ a̠sor d̠a̠ a̠de. ");
INSERT INTO mgj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ezin bho̠, u̠ge̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠: “ ‘A̠zib̠a̠ ta̠ a̠nugiom itileduom d̠o̠yo̠ ma̠ o̠mar okponom onyom. ");
INSERT INTO mgj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Awa ta̠ e̠le̠l aru̠gu̠o̠ d̠awa e̠su̠ar anwa, b̠o̠ka̠ anwa na̠ omel a̠d̠ighia̠nma̠ ma̠ a̠wel d̠oyom d̠a̠ o̠gbaki̠ghe̠.’” ");
INSERT INTO mgj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “U̠gba d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠: ‘Ko o̠d̠agi̠an Wa̠nwuna̠ A̠zib̠a̠ d̠oyom.’” ");
INSERT INTO mgj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Igiel bho̠ Eru bho̠ ad̠agi̠an i̠na awe̠le̠ bho̠, sa̠ i̠na ad̠u̠a na̠ a̠b̠a̠ra̠ ma̠ opa̠n igiel ola̠ ta̠ a̠sora̠n i̠na ma̠ omula̠ o̠d̠agi̠an o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Agu̠o̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠d̠igh d̠a̠ ozu ta̠ A̠zizo̠s a̠muzo bho̠, sa̠ i̠na a̠mula̠ agi̠ d̠a̠ Agalili. Na̠ obia̠ d̠o̠ sa̠ eb̠la̠ ebhugh bho̠ i̠mu̠gho̠n oghur d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I̠na a̠d̠igh d̠a̠ a̠rutu u̠gala d̠awa atu̠ghu̠me̠ni̠, sa̠ ko̠ni̠ko̠ni̠ a̠tutumeni i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sa̠ i̠na agi̠ d̠a̠ Anazare̠t, esi bho̠ i̠na aro̠ a̠d̠igh e̠mu̠ bho̠. Sa̠ i̠na agi̠ d̠a̠ otu u̠gala bho̠ ma̠ a̠d̠a̠ma̠ osira̠-epobh d̠awa, ma̠ agu̠o̠ i̠na na̠ a̠gir gha̠n bho̠. Sa̠ i̠na a̠b̠etina̠ amara ma̠ osen A̠d̠ire E̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sa̠ unigha̠ i̠na ma̠ obhurugho a̠d̠ire ta̠ owil Ai̠zaya. I̠na agbado̠n a̠d̠ire bho̠ sa̠ abi̠gh esi bho̠ u̠ge̠ ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“E̠mu̠gh ta̠ Wa̠nwuna̠ bho̠ na̠ akpasan ami̠, ezin bho̠ i̠na na̠ a̠zuom ami̠ ma̠ amu̠nu̠ ma̠ o̠gba ib̠eb̠i asu̠gbagba o̠nigha̠ ronyigoiny bho̠. I̠na na̠ a̠ruom ami̠ ma̠ o̠gba ma̠ na̠ o̠kagi̠o̠n igoni bho̠ omutioghom d̠a̠ ikoli d̠awa, na̠ o̠kpagi̠on a̠rid̠ien ogbo ya̠ o̠bi̠gh d̠o̠ ma̠ abar bho̠, na̠ otenemeni ogbo ya̠ na̠ oponoma̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na̠ o̠gba omutiom ma̠a̠ obhel wa̠ Wa̠nwuna̠ ta̠ a̠leriom e̠ne̠ghe̠ d̠o̠yo̠ bho̠ na̠ a̠lei.” ");
INSERT INTO mgj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sa̠ i̠na a̠kpor a̠d̠ire bho̠ a̠nigha̠ ma̠ o̠ni̠ ogir otu u̠gala bho̠, sa̠ i̠na aro̠ ma̠ a̠dila̠de. Sa̠ eb̠la̠ a̠nwunom ya̠ i̠ro̠ d̠a̠ otu u̠gala bho̠ igbi ma̠ a̠rid̠ien na̠ ekpon i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sa̠ i̠na ake̠ ma̠ o̠gba onigha̠ awa ma̠a̠, “I̠di̠ar ya̠ inyin u̠mo̠gho̠n ya̠ usen unigha̠ inyin d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠, na̠ omuzoghod̠iom a̠didon d̠a̠ a̠misigh d̠inyin!” ");
INSERT INTO mgj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eb̠la̠ a̠nwunom i̠se̠n i̠na ma̠ ib̠eb̠i. Sa̠ id̠igh awa ma̠ ilologia̠n o̠mu̠gho̠n a̠d̠ien ib̠eb̠i ikpo a̠fugh ya̠ imite d̠a̠ o̠nu̠ d̠o̠yo̠ bho̠. Sa̠ awa ipura̠n ma̠a̠, “Onon o̠nyi̠ ta̠ A̠zose̠fu̠ d̠o̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ami̠ na̠ abi̠gh ma̠ inyin ta̠ orogh a̠sidogh onon onigha̠ ami̠ ma̠a̠: ‘Owil, koko ma̠ ozu d̠oyom!’ Sa̠ inyin ta̠ omula̠ ofugh ma̠a̠, ‘Gire ma̠ i̠se̠n d̠a̠ e̠ma d̠oyom ma̠ a̠d̠ien ilologia̠n ya̠ anwa igir d̠a̠ Akapanu̠m bho̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sa̠ A̠zizo̠s agba alo̠gho̠m ma̠a̠, “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, owil ogbo e̠ma na̠ olei d̠o̠ ma̠ abar. ");
INSERT INTO mgj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ami̠ na̠ agba na̠ a̠nigha̠ inyin d̠a̠ a̠gi̠a̠ga̠i̠ ma̠a̠, rekpukele anwani̠ e̠ro̠ d̠a̠ ebhugh Izre̠l d̠a̠ amu̠m ta̠ I̠lai̠za, ma̠ igiel bho̠ ote̠nai̠ny bho̠ a̠gugia̠n a̠sibhom o̠lo̠bha ma̠ i̠sar ala na̠ atu̠gi̠an bho̠, sa̠ o̠ko̠i̠ ed̠ia̠n a̠sor d̠a̠ eb̠la̠ a̠de bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ku̠ku̠m eka̠, uruom d̠o̠ ma̠ I̠lai̠za ma̠ o̠gi̠ ka̠ o̠te̠i̠ odi awa. Kpe̠le̠me̠ni̠, uruom i̠na ma̠ o̠gi̠ ka̠ o̠te̠i̠ ekpukele ani̠ ola̠ Azare̠fat d̠a̠ ebhugh Asi̠do̠n. ");
INSERT INTO mgj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A̠d̠izo a̠nwunom ya̠ i̠nwe̠r asu̠nwe̠r ekid̠igh e̠ro̠ d̠a̠ ebhugh Izre̠l d̠a̠ amu̠m ta̠ owil I̠lai̠sa, ya̠a̠ o̠ni̠ awa ola̠ ukoko na̠ o̠ro̠ d̠o̠, a̠ten A̠neman wa̠ A̠siria̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Igiel bho̠ eb̠la̠ a̠nwunom ya̠ i̠ro̠ d̠a̠ otu u̠gala bho̠, i̠mu̠gho̠n i̠nye̠n bho̠, sa̠ rologi d̠awa igurom ibom. ");
INSERT INTO mgj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sa̠ awa ib̠etina̠ sa̠ inugi i̠na imutiom d̠a̠ e̠ma bho̠ i̠gi̠ ka̠ i̠te̠i̠ d̠a̠ anyu̠ igu esi bho̠ ulo ma̠ e̠ma bho̠. Awa i̠ru̠ru̠an onu o̠yo̠ oteb̠eli d̠a̠ a̠gbo bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ya̠a̠, i̠na awo̠l d̠a̠ esa̠d̠io o̠lo̠gh a̠nwunom bho̠ a̠rile a̠ten ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sa̠ i̠na a̠sor agi̠ d̠a̠ Akapanu̠m, e̠ma ola̠ od̠i d̠a̠ ebhugh Agalili, sa̠ i̠na aro̠ ma̠ i̠se̠ atu̠ghu̠me̠ni̠ ma̠ a̠nwunom d̠a̠ otu u̠gala bho̠ ma̠ d̠a̠ ra̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Atu̠ghu̠me̠ni̠ d̠o̠yo̠ ed̠igh awa ma̠ ilologia̠n o̠mu̠gho̠n, ezin bho̠, i̠na a̠bhin a̠dila̠de i̠to̠ agba ma̠ asu̠gbagba d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Odi o̠ni̠ ola̠ o̠karabh e̠mu̠gh na̠ a̠nyegi, aro̠ d̠a̠ ologi otu u̠gala bho̠. Sa̠ i̠na a̠bhin obom okoroko a̠mulughuom A̠zizo̠s ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tene ma̠ ad̠u̠a! A̠zizo̠s Anazare̠t, anwa idin ere na̠ a̠ru d̠a̠ i̠yar? Anwa na̠ a̠ru ra̠ o̠pi̠e̠gi̠ i̠yar o̠man ke̠re̠? Ami̠ a̠loghom anwa. Anwa We̠b̠ab̠ala wa̠ A̠zib̠a̠ a̠bhin a̠ru bho̠!” ");
INSERT INTO mgj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sa̠ A̠zizo̠s a̠mulughuom i̠na ma̠a̠, “Nima̠ ma̠ aro̠ b̠o̠b̠o̠m! Ma̠ a̠mite d̠a̠ ozu d̠o̠yo̠!” Sa̠ o̠karabh e̠mu̠gh bho̠ a̠robh i̠na a̠teb̠eli d̠a̠ a̠de, d̠a̠ a̠misigh a̠nwunom bho̠, sa̠ ad̠u̠a d̠a̠ ozu d̠o̠yo̠, ya̠a̠ e̠d̠ighia̠n ola̠ ate̠i̠ o̠ni̠ bho̠ na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sa̠ eb̠la̠ a̠nwunom bho̠ imogha̠, sa̠ odi na̠ a̠pura̠n odi ma̠a̠, “Woo, i̠nye̠n ka̠ a̠kere a̠d̠ien atu̠ghu̠me̠ni̠! I̠na na̠ a̠bhin d̠a̠ a̠dila̠de i̠to̠ na̠ a̠limon na̠ a̠mulughuom i̠karabh aru̠mu̠gh, sa̠ awa na̠ emite na̠ e̠d̠u̠a!” ");
INSERT INTO mgj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sa̠ i̠di̠ar ya̠ na̠ o̠mu̠gho̠n na̠ ogboloma̠ ma̠ A̠zizo̠s bho̠, i̠si̠saragi̠an i̠te̠i̠ eb̠la̠ ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A̠zizo̠s ad̠u̠a d̠a̠ otu u̠gala bho̠ a̠ten agi̠ d̠a̠ otu ta̠ Asai̠mo̠n. Obom amu̠m-o̠bhi̠i̠y a̠sibh o̠yo̠go̠-onweni ta̠ Asai̠mo̠n ma̠ igiel bho̠, sa̠ awa i̠te̠i̠ A̠zizo̠s o̠lo̠gh agu̠o̠ okoko o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sa̠ i̠na a̠zuma̠n a̠mulughuom amu̠m-o̠bhi̠i̠y bho̠ a̠ze asi̠ghe̠. Sa̠ amu̠m-o̠bhi̠i̠y bho̠ ad̠u̠a, sa̠ o̠yo̠go̠-onweni ta̠ Asai̠mo̠n a̠b̠etina̠ ma̠ i̠se̠ d̠a̠ onin obhel bho̠ a̠d̠ighi ma̠ ed̠ia̠n aki̠o̠m awa. ");
INSERT INTO mgj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","D̠a̠ obhel bho̠ ogogo bho̠ na̠ a̠sor bho̠, sa̠ a̠nwunom ibhin ogbo ya̠ na̠ e̠nwe̠re̠ghu̠ ma̠ a̠d̠ien kerekere rasu̠nwe̠r iruom i̠na. Sa̠ i̠na agbam agu̠o̠ d̠o̠yo̠ ma̠ o̠ni̠ a̠ten o̠ni̠ a̠koko ma̠ eb̠la̠ awa a̠d̠umeni. ");
INSERT INTO mgj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","I̠karabh aru̠mu̠gh emiteghu d̠a̠ a̠ruzu a̠d̠izo a̠nwunom, sa̠ imulughu ma̠a̠, “Anwa O̠nyi̠ ta̠ A̠zib̠a̠.” Ya̠a̠, i̠na a̠bhin o̠kparakpar okoroko a̠mulughuom awa, sa̠ aghaghana awa ma̠ ofugh abar. Ezin bho̠, awa eloghom ma̠ i̠na Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A̠d̠io ab̠al sa̠ A̠zizo̠s ku̠ku̠m a̠mite agi̠ ka̠ aro̠ ma̠ esi ola̠ a̠sigima̠ ma̠ a̠nwunom bho̠. Sa̠ ro̠lo̠gh a̠nwunom i̠bho̠ro̠gha̠n i̠na kesikesi. Igiel bho̠ awa i̠ki̠karaghan i̠bi̠gh i̠na bho̠, sa̠ awa iwia̠n agu̠o̠ ola̠ i̠na ko o̠we̠le̠man d̠o̠ awa a̠ten agi̠ ma̠ opa̠n esi. ");
INSERT INTO mgj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ya̠a̠, i̠na agba a̠nigha̠ awa ma̠a̠, “Ami̠ ta̠ agi̠ ka̠ agba ani̠ a̠nigha̠ ma̠ re̠ma iyed̠i, ma̠ ib̠eb̠i asu̠gbagba irileghom ta̠ A̠zib̠a̠, ezin bho̠ A̠zib̠a̠ atu̠n o̠ku̠a a̠ruom ami̠ ma̠ oru.” ");
INSERT INTO mgj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sa̠ i̠na aro̠ ma̠ o̠gba o̠gba ib̠eb̠i asu̠gbagba bho̠ d̠a̠ a̠rutu u̠gala d̠a̠ ebhugh A̠zudia̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Odi a̠d̠a̠ma̠ A̠zizo̠s amara d̠a̠ aka o̠bhi̠i̠y-eko Age̠ne̠sare̠t sa̠ o̠lo̠gh a̠nwunom iwia̠n o̠gi̠ ka̠ o̠te̠i̠ o̠yo̠, sa̠ awa i̠ni̠ran iko i̠na ikiton agu̠o̠ ola̠ o̠nagha o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ ya̠ i̠na na̠ agba bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sa̠ i̠na abi̠gh i̠wal a̠rughugh d̠a̠ o̠bhi̠i̠y bho̠, ya̠ i̠ku̠mi̠ku̠ bho̠ isul iguri na̠ etitol i̠gbo̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sa̠ i̠na a̠d̠igh d̠a̠ odi oghugh bho̠, wa̠ Asai̠mo̠n a̠nwuna̠ bho̠, sa̠ a̠ruom i̠na ma̠ onu oghugh bho̠ d̠a̠ esi wa̠ i̠na a̠sul bho̠ omutiom d̠a̠ obodo ma̠ i̠ki̠kara. Sa̠ i̠na aro̠ ma̠ a̠dila̠de d̠a̠ oghugh bho̠ atu̠ghu̠me̠ni̠ ma̠ o̠lo̠gh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Igiel i̠na na̠ agba awe̠le̠ bho̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ Asai̠mo̠n ma̠a̠, “Nue ma̠ oghugh bho̠ ma̠ a̠mutiom d̠a̠ obodo, ma̠ a̠sorogi ma̠ i̠gbo̠ bho̠ b̠o̠ka̠ esin ina̠.” ");
INSERT INTO mgj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sa̠ Asai̠mo̠n awo̠ran i̠na ma̠a̠, “Wa̠nwuna̠, i̠yar ugbologhu ma̠ eb̠la̠ a̠d̠uga̠la̠n bho̠; ya̠a̠, i̠yar u̠te̠i̠ d̠o̠ ma̠ abar. O̠ku̠a eka̠, agu̠o̠ bho̠ anwa na̠ a̠fugh bho̠, ami̠ ta̠ a̠sorogi ma̠ i̠gbo̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Igiel awa igir o̠ku̠a bho̠, sa̠ i̠gbo̠ bho̠ isin obom o̠lo̠gh ina̠ ka̠ i̠te̠i̠ esi ola̠ i̠gbo̠ bho̠ i̠ke̠ ma̠ o̠go̠gu̠a̠n. ");
INSERT INTO mgj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ebula̠ o̠ku̠a, sa̠ awa ibhelegi ma̠ ogbo i̠ku̠ ya̠ od̠i d̠a̠ oghugh uwed̠i bho̠ ma̠ oru ra̠ o̠lo̠gh agu̠o̠ onigha̠ awa. Sa̠ i̠sai̠ ina̠ bho̠ imuzoghod̠i ma̠ i̠wal a̠rughugh bho̠, sa̠ i̠de̠bh ka̠ i̠te̠i̠ esi ola̠ iru ra̠ owi. ");
INSERT INTO mgj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Igiel bho̠ Asai̠mo̠n A̠pita̠ abi̠gh abar wa̠ na̠ a̠mite bho̠, sa̠ i̠na a̠kpud̠ia̠n d̠a̠ a̠misigh ta̠ A̠zizo̠s sa̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, d̠u̠a d̠a̠ d̠ami̠; ami̠ od̠ighi ma̠ i̠karabh o̠ni̠!” ");
INSERT INTO mgj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ezin bho̠, ed̠igh i̠na ma̠ ilologia̠n na̠ eb̠la̠ ogbo ya̠ na̠ i̠na id̠igh onin oghugh bho̠, ma̠ o̠bi̠gh e̠mi̠ ina̠ ya̠ awa i̠ze̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Onin agu̠o̠ bho̠ id̠igh ilologia̠n A̠zemsi̠ na̠ Azo̠n, anwi̠i̠ny ta̠ Aze̠bidi, ogbo ya̠ na̠ ed̠igh na̠ Asai̠mo̠n na̠ e̠ku̠ ghan i̠ku̠ bho̠. Sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ Asai̠mo̠n ma̠a̠, “Ko oghil a̠rugugu! Ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, anwa ta̠ aku̠ ma̠ i̠ku̠ a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sa̠ awa id̠ur a̠rughugh d̠awa ibhuneni d̠a̠ egbolom, sa̠ awa i̠we̠le̠man kabar kabar i̠se̠ i̠tu̠o̠no̠m A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Obhel aro̠ ma̠ ola̠ A̠zizo̠s agi̠ d̠a̠ odi e̠ma bho̠. D̠a̠ e̠ma obha̠, o̠ni̠ ola̠ asu̠nwe̠r ekid̠igh na̠ a̠bhin eb̠la̠ ozu bho̠, abi̠gh A̠zizo̠s sa̠ a̠mel a̠b̠obhia̠n d̠a̠ a̠de. Sa̠ a̠siseiny i̠na ma̠a̠, “Wa̠nwuna̠, ka̠ anwa ima̠ra̠, anwa ta̠ a̠koko ami̠ ab̠ab̠alame̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sa̠ A̠zizo̠s a̠selegheni ma̠ agu̠o̠ d̠o̠yo̠ a̠kula̠n o̠ni̠ bho̠, sa̠ awo̠ran i̠na ma̠a̠, “Yii, ami̠ a̠ma̠ra̠ ma̠ okoko oyom. B̠ab̠ala!” Onin obhel bho̠, sa̠ asu̠nwe̠r ekid̠igh bho̠ ad̠u̠a d̠a̠ ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sa̠ A̠zizo̠s a̠bhin o̠kparakpar okoroko a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ko o̠gba ma̠ a̠nigha̠ ma̠ o̠ni̠ na̠ o̠ni̠, ya̠a̠ gi̠e̠ ka̠ a̠leriom ozu d̠oyom ma̠ okur bho̠, ma̠ ako̠l i̠ko̠l o̠b̠ab̠alame̠ni̠ ozu ya̠ A̠mozizi ato̠ a̠guri bho̠. Obha̠ ta̠ aro̠ ma̠ elegh ola̠ a̠nwunom ta̠ ebhin eloghom ma̠ ozu d̠oyom na̠ ab̠ab̠ala.” ");
INSERT INTO mgj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Eb̠la̠ agu̠o̠ i̠na a̠kikiom o̠ku̠a bho̠ eka̠, o̠du̠ ogir ilologia̠n d̠o̠yo̠ asi̠saragi̠an agi̠ ma̠ egbeiny, ma̠ ola̠ ro̠lo̠gh a̠nwunom iru d̠o̠yo̠ ma̠ o̠mu̠gho̠n ani̠ asu̠gbagba bho̠, na̠ okokua̠n d̠a̠ rasu̠nwe̠r d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ya̠a̠, A̠zizo̠s ad̠u̠a ghan a̠d̠igh d̠a̠ esi ola̠ od̠i kukunum ka̠ a̠siseiny a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Odi a̠d̠a̠ma̠ A̠zizo̠s na̠ atu̠ghu̠me̠ni̠, a̠nwunom Afarisi na̠ i̠tu̠ghu̠me̠ni̠ ma̠ oloko bho̠ e̠ro̠ ani̠ ma̠ i̠se̠. Awa i̠d̠u̠a ke̠ma ke̠ma d̠a̠ rebhugh Agalili na̠ A̠zudia̠, na̠ A̠zeruse̠le̠m e̠gi̠ ma̠ i̠se̠. Sa̠ a̠limon ta̠ Wa̠nwuna̠ bho̠ i̠ro̠ na̠ A̠zizo̠s ma̠ obhin okoko a̠nwunom d̠a̠ rasu̠nwe̠r d̠awa od̠umeni. ");
INSERT INTO mgj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sa̠ idi a̠nwunom irol o̠ni̠ wa̠ na̠ a̠b̠oga̠na̠ bho̠ d̠a̠ a̠kporokporo, sa̠ iwia̠n od̠igh ka̠ o̠mu̠ni̠e̠ni̠ o̠yo̠ d̠a̠ a̠misigh ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Igiel bho̠ awa orue d̠o̠ ma̠ o̠bi̠gh e̠ti̠ti̠gha od̠igh ma̠ ebula̠ o̠lo̠gh a̠nwunom bho̠, sa̠ a̠wa i̠si̠n ibhun d̠a̠ anyu̠ otu bho̠, sa̠ i̠wo̠lo̠me̠ni̠ i̠na d̠a̠ ipopula̠ repele ya̠ ubhin uzu ma̠ i̠galaga bho̠, sa̠ isoroni i̠na d̠a̠ a̠kporokporo d̠a̠ a̠misigh ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Igiel bho̠ A̠zizo̠s abi̠gh e̠mi̠ ologi ima̠ra̠ d̠awa bho̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “A̠tologha̠n, na̠ o̠we̠le̠man i̠karabh d̠oyom onigha̠ nyam.” ");
INSERT INTO mgj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sa̠ a̠nwunom Afarisi bho̠, na̠ ogbo-atu̠ghu̠me̠ni̠ oloko bho̠, ibhin id̠igh d̠a̠ i̠ru̠ru̠an na̠ epura̠n d̠a̠ rologi d̠awa ma̠a̠, “A̠nyen o̠ni̠ onon wa̠ ozuruna̠ d̠o̠ ma̠ eghoi, sa̠ na̠ a̠fugh e̠mi̠ a̠fugh i̠basi̠ iya̠ o̠ko̠no̠n bho̠? A̠nyen o̠ni̠ wa̠ ta̠ a̠rue awe̠le̠man i̠karabh a̠nigha̠ ma̠ o̠ni̠ bho̠, a̠ten A̠zib̠a̠?” ");
INSERT INTO mgj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ya̠a̠, A̠zizo̠s a̠loghom i̠di̠ar ya̠ awa na̠ e̠ru̠ru̠an d̠a̠ rologi d̠awa bho̠ sa̠ a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere, ka̠ inyin na̠ o̠ru̠ru̠an na̠ opura̠n i̠di̠ar ya̠ o̠ku̠a, d̠a̠ rologi d̠inyin? ");
INSERT INTO mgj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Oken a̠b̠ur a̠pu ma̠ ofugh, ‘I̠karabh d̠oyom na̠ o̠we̠le̠man onigha̠ nyam,’ bo̠d̠o̠ ofugh ma̠a̠, ‘B̠etina̠ ma̠ a̠rile?’ ");
INSERT INTO mgj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ya̠a̠, ami̠ na̠ abho̠ro̠gh inyin ologhom ma̠ O̠nyi̠ ta̠ O̠ni̠ a̠nwuna̠ ma̠ a̠limon o̠we̠le̠man i̠karabh onigha̠ a̠nwunom i̠se̠n a̠de no̠.” Ebula̠ o̠ku̠a sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ wa̠ na̠ a̠b̠oga̠na̠ bho̠ ma̠a̠, “Ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, b̠etina̠, ma̠ a̠bhin a̠kporokporo d̠oyom ma̠ a̠yel d̠a̠ otu d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","D̠a̠ onin obhel bho̠ sa̠ i̠na a̠b̠etina̠ d̠a̠ a̠misigh d̠awa, sa̠ a̠b̠eton abar wa̠ i̠na a̠bhin gha̠n amanaghan bho̠, sa̠ a̠ten a̠yel d̠a̠ otu d̠o̠yo̠, na̠ a̠tutumeni ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sa̠ a̠d̠igh ko̠ni̠ko̠ni̠ ma̠ ilologia̠n, sa̠ awa inigha̠ ma̠ itutumeni ma̠ A̠zib̠a̠, ifugh ma̠a̠, “I̠yar na̠ o̠bi̠gh irorua̠ i̠di̠ar ilologia̠n a̠didon.” ");
INSERT INTO mgj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Onon a̠ten sa̠ A̠zizo̠s a̠mite, sa̠ abi̠gh odi ogun ma̠ otua̠-ebhugh ola̠ ubhelegi ma̠ A̠livai̠ ola̠ aro̠ ma̠ a̠dila̠de d̠a̠ e̠fe̠m ogir d̠o̠yo̠. Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “Tu̠o̠no̠me̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sa̠ A̠livai̠ a̠b̠etina̠ amara, sa̠ awe̠le̠man kabar kabar atu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sa̠ A̠livai̠ a̠soroni ma̠ obom o̠d̠e̠ d̠a̠ ologi otu d̠o̠yo̠ a̠nigha̠ ma̠ A̠zizo̠s, sa̠ obom o̠lo̠gh igun ma̠ otua̠-ebhugh na̠ ipa̠n a̠nwunom id̠igh na̠ awa i̠d̠e̠ ma̠ o̠d̠e̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ya̠a̠, a̠nwunom Afarisi bho̠ na̠ ogbo atu̠ghu̠me̠ni̠ oloko ya̠ id̠umom ani̠ ma̠ e̠kal id̠umom d̠awa bho̠, i̠go̠ya inigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Ezin ka̠ ere, ka̠ inyin na̠ od̠igh na̠ igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠ka̠rabh a̠nwunom na̠ od̠e na̠ o̠d̠a?” ");
INSERT INTO mgj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “A̠nwunom ya̠ a̠ruzu ibhon ko o̠bho̠ro̠gh d̠o̠ ma̠ owil; ya̠a̠ i̠na o̠ni̠ wa̠ na̠ anwe̠r bho̠ ta̠ agi̠ ka̠ ate̠i̠ owil. ");
INSERT INTO mgj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ami̠ iru d̠o̠ ma̠ ra̠ obhelegi ib̠eb̠i a̠nwunom, ya̠a̠ ami̠ i̠tu̠n id̠ighi ma̠ i̠karabh a̠ru, b̠o̠ka̠ awa etiba̠ra̠ d̠a̠ i̠karabh d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sa̠ awa ifugh inigha̠ i̠na ma̠a̠, “Ogbo atu̠ghan ta̠ Azo̠n na̠ ene gha̠n o̠ko̠i̠ na̠ esiseiny a̠siseiny, ogbo atu̠ghan Afarisi bho̠ eka̠ na̠ egir o̠ku̠a nyen; ya̠a̠ itoyom obha̠ na̠ e̠ro̠ ma̠ od̠e o̠d̠a od̠e o̠d̠a.” ");
INSERT INTO mgj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Inyin ta̠ orue od̠ighi̠ ma̠ ola̠ ra̠tologha̠n o̠ni̠ erogh bho̠, ta̠ e̠ro̠ ma̠ o̠ko̠i̠ d̠a̠ obhel ola̠ i̠na od̠i na̠ awa d̠a̠ otu erogh bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ya̠a̠, obhel na̠ a̠ru ma̠ ola̠ ta̠ o̠si̠ghe̠ ma̠ o̠ni̠ erogh bho̠ d̠a̠ esa̠d̠io d̠awa. D̠a̠ ra̠d̠a̠ma̠ i̠nye̠ sa̠ awa ta̠ ene ma̠ o̠ko̠i̠.” ");
INSERT INTO mgj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sa̠ A̠zizo̠s a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠: “O̠ni̠ ko o̠ghe̠r d̠o̠ ma̠ o̠go̠go̠ra ukpe d̠a̠ omom akapa a̠bhin ab̠ad̠i̠ ma̠ ugba̠iny akapa. Ka̠ o̠ni̠ a̠gir o̠ku̠a, bha̠ na̠ api̠e̠ ma̠ omom akapa bho̠, sa̠ o̠go̠go̠ra ukpe wa̠ u̠ghe̠r u̠si̠ghe̠ d̠a̠ omom bho̠, ko osora̠n d̠o̠ ma̠ ugba̠iny akapa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","O̠ni̠ ola̠ na̠ alo̠gh imom a̠min d̠a̠ ugba̠iny akana ozu e̠nam bo̠; ka̠ o̠ni̠ a̠gir o̠ku̠a, bha̠ imom a̠min bho̠ ta̠ ed̠ighi ma̠ ola̠ akana ozu-e̠nam bho̠ ta̠ a̠pol, sa̠ a̠min bho̠ ta̠ ezugia̠n ebhe, sa̠ ko orue mu orughom akana bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ya̠a̠, imom a̠min na̠ o̠lo̠gh ghan d̠a̠ imom rakana ozu e̠nam. ");
INSERT INTO mgj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ya̠a̠, o̠ni̠ ola̠ na̠ ad̠a ma̠ igba̠iny a̠min a̠b̠eghenom, ola̠ na̠ abho̠ro̠ghan o̠d̠a imom a̠min bo̠, ezin bho̠ i̠na ta̠ a̠fugh ma̠a̠, ‘Igba̠iny bho̠ ibhon epu.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Odi a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu, A̠zizo̠s na̠ a̠ten d̠a̠ ari̠si̠ i̠bu̠kpa, sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠ku̠ ma̠ idi itu bho̠, sa̠ i̠kpi̠r ikpo bho̠ i̠lo̠gi̠ d̠a̠ aru̠gu̠o̠ d̠awa id̠e. ");
INSERT INTO mgj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sa̠ idi Afarisi bho̠ ipura̠n i̠na ma̠a̠, “Ezin ka̠ ere ka̠ anwa na̠ a̠gir abar ola̠ oloko bho̠ oma̠ra̠ d̠o̠ ma̠ o̠ni̠ ma̠ ogir d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu?” ");
INSERT INTO mgj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Inyin ta̠ osen d̠o̠ ma̠ a̠d̠ire e̠tu̠tu̠ bho̠ o̠bi̠gh agu̠o̠ A̠devidi a̠gir igiel bho̠ o̠ko̠i̠ a̠d̠ighi i̠na sekina̠ a̠nwunom ya̠ i̠ro̠ na̠ i̠na bho̠, ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I̠na a̠d̠igh d̠a̠ otu akpu̠ru̠ ta̠ A̠zib̠a̠, sa̠ a̠bhin abe̠re̠di̠ e̠tu̠tu̠, ya̠ uguri usisa̠n rokur ta̠ A̠zib̠a̠ ku̠ku̠m ma̠ od̠e bho̠, a̠d̠e. Sa̠ i̠na a̠b̠eton idi abe̠re̠di̠ bho̠ a̠nigha̠ ma̠ a̠nwunom ya̠ i̠ro̠ na̠ i̠na bho̠ nyen.” ");
INSERT INTO mgj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “O̠nyi̠ ta̠ O̠ni̠ bha̠ Wa̠nwuna̠ ma̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Opa̠n a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu aro̠, ma̠ ola̠ i̠na a̠d̠igh d̠a̠ otu u̠gala A̠zu bho̠ atu̠ghu̠me̠ni̠. Odi o̠ni̠ ola̠ od̠iom agu̠o̠ bho̠ na̠ akpari̠an aro̠ ani̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Idi ogbo atu̠ghu̠me̠ni̠ oloko bho̠, na̠ idi Afarisi e̠ro̠ na̠ e̠bho̠ro̠ghan e̠kal abar ola̠ odin ob̠ologiom A̠zizo̠s. Sa̠ awa ikimeni na̠ egon o̠bi̠gh ka̠ i̠na ta̠ a̠koko ma̠ a̠likoko ma̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ya̠a̠ A̠zizo̠s a̠loghom i̠ru̠ru̠an d̠awa, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ wa̠ agu̠o̠ na̠ akpari̠an bho̠ ma̠a̠, “B̠etina̠ ma̠ a̠ru, ra̠ amara d̠a̠ ed̠ia̠.” Sa̠ o̠ni̠ bho̠ a̠b̠etina̠ ka̠ amara d̠a̠ esa̠d̠io bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “Ami̠ na̠ a̠pura̠n inyin, oken abar wa̠ oloko bho̠ a̠ma̠ra̠ i̠yar ogir d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠: ogir ib̠eb̠i bo̠d̠o̠ ogir i̠karabh, otenemeni o̠ni̠ onigha̠ a̠ghud̠um bo̠d̠o̠ ka̠ o̠pi̠e̠gi̠?” ");
INSERT INTO mgj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa̠ i̠na a̠kpon eb̠la̠ awa a̠kitineni̠, sa̠ a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “Selegheni ma̠ agu̠o̠ d̠oyom.” I̠na a̠gir o̠ku̠a, sa̠ agu̠o̠ d̠o̠yo̠ a̠selegha̠n. ");
INSERT INTO mgj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sa̠ a̠likoko bho̠ agamame̠ni̠ ma̠ rologi ogbo Afarisi bho̠ na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠. Sa̠ awa i̠ke̠ ma̠ o̠b̠e̠re̠gi̠an d̠a̠ esa̠d̠io d̠awa, oma̠ra̠nua̠n abar awa ta̠ ed̠ighi ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Odi a̠d̠a̠ma̠ d̠a̠ ra̠d̠a̠ma̠ i̠nye̠ sa̠ A̠zizo̠s asi̠n d̠a̠ anyu̠ igu bho̠ ma̠ osiseiny; sa̠ i̠na a̠bhin eb̠la̠ a̠d̠uga̠la̠n bho̠ a̠siseiny A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A̠d̠io ra̠ ab̠al sa̠ i̠na a̠bhelegi ma̠ ogbo atu̠ghan d̠o̠yo̠ a̠kokod̠i, sa̠ aso̠n d̠iobh na̠ i̠wal a̠mutiom, sa̠ a̠doni awa a̠guri ma̠ ogbo ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I̠nye̠n a̠rid̠ien d̠awa: Asai̠mo̠n, wa̠ i̠na a̠ghol A̠pita̠ bho̠, na̠ umor d̠o̠yo̠ Anduru, A̠zemsi̠ na̠ Azo̠n, A̠filip na̠ Abatolomio, ");
INSERT INTO mgj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Amatiu na̠ Ato̠mo̠si̠, A̠zemsi̠ o̠nyi̠ ta̠ Ali̠fi̠o̠s na̠ Asai̠mo̠n, wa̠ ubhelegi ma̠ A̠zilo̠t bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","A̠zuda̠s o̠nyi̠ ta̠ A̠zemsi̠ na̠ A̠zuda̠s I̠skari̠o̠t, wa̠ a̠wol i̠na ma̠ o̠gu̠man bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa̠ I̠na na̠ awa isor ka̠ i̠mara d̠a̠ otutula̠n a̠de. O̠lo̠gh ogbo atu̠ghan d̠o̠yo̠, na̠ obom o̠lo̠gh a̠nwunom ya̠ i̠d̠u̠a d̠a̠ eb̠la̠ ebhugh A̠zudia̠ na̠ A̠zeruse̠le̠m, na̠ d̠a̠ rakagara Ataya na̠ Asi̠do̠n e̠ro̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Awa iru ra̠ o̠nagha o̠yo̠ na̠ okokua̠n d̠a̠ rasu̠nwe̠r d̠awa. Ogbo ya̠ i̠karabh aru̠mu̠gh na̠ enyegi eka̠ eru ra̠ ekokua̠n. ");
INSERT INTO mgj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sa̠ eb̠la̠ a̠nwunom bho̠ iwia̠n okula̠n o̠yo̠, ezin bho̠ a̠limon na̠ emite d̠a̠ ozu d̠o̠yo̠ na̠ ekoko ko̠ni̠ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sa̠ A̠zizo̠s a̠tiba̠ra̠ a̠kpon ogbo atu̠ghan d̠o̠yo̠ sa̠ a̠fugh ma̠a̠, “Itutumeni e̠ro̠ enigha̠ inyin ronyigoiny bho̠, irileghom ta̠ A̠zib̠a̠ ola̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Itutumeni e̠ro̠ enigha̠ inyin ogbo ya̠ od̠i ma̠ o̠ko̠i̠ i̠se̠n bho̠, inyin ta̠ od̠e olegha̠n. Itutumeni e̠ro̠ enigha̠ inyin ogbo ya̠ na̠ esorogi ma̠ izin i̠se̠n bho̠, inyin ta̠ o̠mo̠lo̠gh adi̠e̠l. ");
INSERT INTO mgj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Itutumeni e̠ro̠ enigha̠ inyin d̠a̠ obhel ola̠ a̠nwunom na̠ e̠su̠a inyin, na̠ obhel ola̠ awa na̠ eghirom inyin, sa̠ na̠ eduom inyin, sa̠ ighel a̠d̠ien d̠a̠ inyin ma̠a̠ i̠nyin i̠karabh, d̠a̠ ebula̠ O̠nyi̠ ta̠ O̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ya̠a̠, ibo ma̠ epeleghu na̠ a̠libhon ologi, ezin bho̠ asu̠o̠ ya̠ i̠mar i̠bu̠gh na̠ eb̠a̠ra̠ inyin d̠a̠ ote̠nai̠ny; ya̠a̠ iloghome ma̠ igba̠iny ro̠we̠de̠ d̠awa igir o̠ku̠a egboloma̠ ma̠ a̠riwil bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ya̠a̠ olo a̠leghe inyin ogbo ya̠ od̠i d̠a̠ e̠li̠la ma̠ i̠se̠n bho̠, ezin bho̠ inyin na̠ o̠te̠i̠ e̠no̠gho̠man d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Olo a̠leghe inyin ogbo ya̠ na̠ ed̠e na̠ elegha̠n i̠se̠n bho̠, ezin bho̠ inyin ta̠ o̠ri̠la ma̠ o̠ko̠i̠ d̠a̠ ed̠ia̠. Olo a̠leghe inyin ogbo ya̠ na̠ e̠mo̠lo̠gh adi̠e̠l i̠se̠n bho̠, ezin bho̠ inyin ta̠ od̠igh i̠ku̠nu̠ o̠gba ma̠ igbir. ");
INSERT INTO mgj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Olo a̠leghe inyin ka̠ eb̠la̠ a̠nwunom na̠ esen inyin ib̠eb̠i, obha̠ agu̠o̠ igba̠iny ro̠we̠de̠ d̠awa igir igboloma̠ ma̠ a̠riwil igunugha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ya̠a̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ogbo ya̠ na̠ e̠nagha ami̠ bho̠ ma̠a̠: Itula̠ne ma̠ ogbo o̠lo̠gi̠an a̠rid̠ien d̠inyin, igire ma̠ ib̠eb̠i ma̠ enigha̠ ma̠ ogbo ya̠ na̠ e̠su̠a inyin bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Itutumeni ma̠ ogbo ya̠ na̠ e̠ghad̠i̠ inyin bho̠, ma̠ esiseiny enigha̠ ma̠ ogbo ya̠ na̠ ed̠ighi inyin i̠karabh nyen. ");
INSERT INTO mgj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka̠ o̠ni̠ ab̠abh anwa d̠a̠ odi ab̠akagba d̠oyom, tiba̠ra̠ ma̠ agba uwed̠i ma̠ a̠nigha̠ i̠na nyen. Ka̠ o̠ni̠ a̠ghum akapa-anyu̠ d̠oyom a̠bhin, ko okigima̠ i̠na ma̠ o̠b̠aram na̠ akapa-a̠de d̠oyom obhin. ");
INSERT INTO mgj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nigha̠ ko̠ni̠ko̠ni̠ ola̠ a̠puru ma̠ anwa ma̠ abar; ya̠a̠ ka̠ o̠ni̠ a̠bhin abar oyom, ko opuru i̠na ma̠ omulumeni abar bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gire ma̠ a̠nigha̠ ma̠ ipa̠n ogbo ma̠ agu̠o̠ anwa na̠ abho̠ro̠gh awa ma̠ ogir onigha̠ oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ka̠ u̠gba ma̠ inyin otula̠n ogbo etula̠n d̠inyin ku̠ku̠m, ka̠ asu̠o̠ d̠inyin ka̠ ere? Id̠ighi ma̠ i̠karabh bho̠ eka̠ na̠ etula̠n ogbo ya̠ itula̠n awa bho̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ya̠a̠, ka̠ inyin ugir ib̠eb̠i unigha̠ ma̠ ogbo ya̠ na̠ egir ib̠eb̠i na̠ enigha̠ inyin bho̠, ka̠ asu̠o̠ d̠inyin ka̠ ere? Id̠ighi ma̠ i̠karabh bho̠ eka̠ na̠ egir o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka̠ inyin i̠wo̠lo̠ni̠an abar ogbo ya̠ ta̠ erue e̠kpe̠ inyin bho̠, ka̠ asu̠o̠ d̠inyin ka̠ ere? Onin agu̠o̠ rod̠ighi ma̠ i̠karabh a̠nwunom na̠ e̠wo̠lo̠ni̠an i̠di̠ar ma̠ rod̠ighi ma̠ i̠karabh, sa̠ awa na̠ e̠ro̠ na̠ egon a̠nwunom bho̠ ma̠ o̠kpe̠ awa ma̠ eb̠la̠ i̠mu̠gh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ya̠a̠ itula̠ne ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠inyin, igire ma̠ ib̠ebi̠ ma̠ enigha̠ awa, i̠wo̠lo̠ni̠ane̠ ma̠ ogbo ya̠ inyin ko ogon d̠o̠ ma̠ amu̠kpe̠. Sa̠ inyin ta̠ o̠te̠i̠ ibom alu̠kpe̠, sa̠ inyin ta̠ oten anwi̠i̠ny ta̠ O̠ni̠ Wagi̠manyu̠ A̠pu bho̠. Ezin bho̠, i̠na na̠ a̠gir ib̠eb̠i na̠ a̠nigha̠ ma̠ ogbo ya̠ o̠bi̠gh ghan ib̠eb̠i ya̠ ugir ugir unigha̠ awa bho̠, na̠ rod̠ighi ma̠ i̠karabh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikpone ma̠ igbirigbir a̠d̠ien agu̠o̠ O̠we̠de̠ d̠inyin na̠ a̠kpon igbirigbir bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“O̠ni̠ ko o̠nu̠r e̠bi̠gh o̠ni̠ ma̠ e̠pi̠e̠, b̠o̠ka̠ u̠nu̠r o̠bi̠gh inyin o̠pi̠e. O̠ni̠ ko obhin ib̠ologiom esobh ase̠ ma̠ ebhumeni ma̠ o̠ni̠, b̠o̠ka̠ ubhin ib̠ologiom osobh ase̠ obhumeni inyin. I̠we̠le̠mane̠ ma̠ i̠karabh a̠nwunom enigha̠ awa, b̠o̠ka̠ o̠we̠le̠man i̠karabh d̠inyin onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","I̠ne̠ghe̠ ma̠ e̠ne̠ghe̠, sa̠ a̠nwunom ta̠ e̠ne̠ghe̠ ma̠ e̠ne̠ghe̠ enigha̠ inyin nyen. Ib̠eb̠i atu̠gi̠, ya̠ u̠mar u̠zo̠, sa̠ unyegi umuzoghod̠i sa̠ ipel na̠ ezugia̠n, sa̠ ubhin uzuom ru̠gbo̠ d̠inyin. Agu̠o̠ inyin ugir unigha̠ ma̠ ipa̠n a̠nwunom bho̠, obha̠ agu̠o̠ A̠zib̠a̠ ta̠ a̠gir a̠nigha̠ inyin. Ezin bho̠, i̠di̠ar ya̠ inyin ubhin u̠to̠ unigha̠ ma̠ a̠nwunom bho̠, i̠nye̠ i̠di̠ar ya̠ ta̠ obhin o̠to̠ onigha̠ inyin bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sa̠ A̠zizo̠s a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠: “O̠ni̠ ikpom a̠rid̠ien ta̠ a̠rue a̠rileghom opa̠n o̠ni̠ ikpom a̠rid̠ien ke̠re̠? I̠wal awa ko omel d̠o̠ ed̠igh d̠a̠ ogugua̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","O̠ni̠ atu̠ghan na̠ o̠bu̠gh d̠o̠ a̠pu ma̠ o̠ni̠ atu̠ghu̠me̠ni̠ d̠o̠yo̠. Ya̠a̠, i̠na wa̠ amar atu̠ghan aku̠ro̠m bho̠ ta̠ aro̠ ka̠ o̠ni̠ atu̠ghu̠me̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ezin ka̠ ere ka̠ anwa na̠ abi̠gh o̠taghatagh wa̠ od̠i d̠a̠ ekpo a̠d̠ien umor d̠oyom bho̠, sa̠ anwa na̠ ologhoma̠n d̠o̠ ma̠ egum oriren wa̠ od̠i d̠a̠ ekpo a̠d̠ien d̠oyom bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Anwa ta̠ a̠din ere a̠fugh a̠nigha̠ ma̠ umor d̠oyom ma̠a̠, ‘Umor, d̠ighi ami̠ ta̠ asi̠ghe̠ ma̠ o̠taghatagh d̠a̠ a̠d̠ien d̠oyom,’ ma̠ igiel anwa o̠bi̠gh d̠o̠ ma̠ egum oriren wa̠ od̠i d̠a̠ ekpo a̠d̠ien d̠oyom bho̠? Anwa obhelebhel o̠ni̠! D̠ia̠ ma̠ asi̠ghe̠ ma̠ egum oriren wa̠ od̠i d̠a̠ ekpo a̠d̠ien d̠oyom bho̠; i̠se̠ kisa̠ anwa ta̠ a̠rue abi̠gh esi asi̠ghe̠ ma̠ o̠taghatagh wa̠ od̠i d̠a̠ ekpo a̠d̠ien umor d̠oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ob̠eb̠i oriren ola̠ na̠ a̠mum o̠karabh otu bo̠. Onin agu̠o̠ o̠karabh oriren omum d̠o̠ ma̠ ob̠eb̠i otu. ");
INSERT INTO mgj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Na̠ obhin otu oriren na̠ olelegi ma̠ a̠d̠ien oriren bho̠. A̠nwunom ikpokpo d̠o̠ ma̠ itu a̠fig d̠a̠ ed̠um ib̠ub̠ulom; bo̠d̠o̠, sa̠ awa na̠ ekpokpo ma̠ itu oriren a̠grep d̠a̠ e̠ko̠ko̠ esi iriren i̠su̠ ya̠ od̠i ka̠ ib̠e na̠ id̠id̠igh na̠ i̠ze̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ob̠eb̠i o̠ni̠ na̠ a̠mutioghom ib̠eb̠i i̠di̠ar d̠a̠ ib̠eb̠i ya̠ i̠na a̠kokod̠i a̠guri d̠a̠ ologi d̠o̠yo̠ bho̠. Onin agu̠o̠ o̠karabh o̠ni̠ na̠ a̠mutioghom i̠karabh i̠di̠ar d̠a̠ i̠karabh ya̠ i̠na a̠kokod̠i a̠guri d̠a̠ ologi d̠o̠yo̠ bho̠. A̠d̠ien i̠di̠ar ya̠ o̠ni̠ a̠kokod̠i a̠muzoghod̠i d̠a̠ ologi o̠ni̠, i̠nye̠ i̠di̠ar ya̠ o̠nu̠ o̠ni̠ bho̠ na̠ a̠fugh na̠ a̠mutiom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Anwa i̠tu̠n ere na̠ a̠bhelegi ami̠ ma̠a̠, ‘Wa̠nwuna̠, Wa̠nwuna̠,’ ya̠a̠ anwa na̠ ogir d̠o̠ ma̠ i̠di̠ar ya̠ ami̠ na̠ agba bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ami̠ ta̠ a̠leriom inyin o̠le̠m o̠ni̠ ola̠ a̠ru d̠ami̠, sa̠ anagha ma̠ o̠nu̠o̠kpe̠ d̠ami̠, sa̠ a̠kpon o̠ku̠a a̠rugh. ");
INSERT INTO mgj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I̠na od̠i ka̠ o̠ni̠ ola̠ a̠lo ma̠ otu, sa̠ a̠gbo ma̠ a̠de bho̠ a̠kud̠umeni sa̠ a̠bho ma̠ otu bho̠ agbam d̠a̠ anyu̠ o̠gbe̠o̠ma. Igiel a̠d̠igho a̠ru bho̠, sa̠ obom amu̠m bho̠ aro̠bho̠m otu bho̠, ya̠a̠ otu bho̠ amara gigiribh, ezin bho̠ o̠mar olo ma̠ otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ya̠a̠, i̠na o̠ni̠ wa̠ amu̠gho̠n sa̠ o̠nagha d̠o̠ ma̠ o̠nu̠o̠kpe̠ d̠ami̠ bho̠, i̠na od̠i ka̠ o̠ni̠ ola̠ a̠lo ma̠ otu o̠kpo̠kpo̠ o̠to̠. Sa̠ igiel obom amu̠m a̠d̠igho a̠ru bho̠, sa̠ a̠nu ma̠ otu bho̠ a̠teb̠eli a̠tutughud̠i. Abu̠gh emel!” ");
INSERT INTO mgj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Igiel bho̠ A̠zizo̠s na̠ agba ma̠ eb̠la̠ i̠di̠ar i̠nye̠n a̠nigha̠ ma̠ a̠nwunom bho̠ amado̠n bho̠, sa̠ i̠na a̠d̠igh d̠a̠ e̠ma Akapanu̠m. ");
INSERT INTO mgj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","D̠a̠ obhel obha̠, odi we̠mu̠ o̠lo̠gh e̠gham A̠rom, a̠nwuna̠ ma̠ ogoni ola̠ i̠na a̠bhin atu̠o̠m abar ibom. Ogoni bho̠ na̠ anwe̠r na̠ a̠tua̠n omugh. ");
INSERT INTO mgj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Igiel bho̠ o̠ni̠ we̠mu̠ o̠lo̠gh e̠gham bho̠ amu̠gho̠n a̠gboloma̠ ma̠ A̠zizo̠s bho̠, sa̠ i̠na a̠ruom ikei a̠nwunom A̠zu bho̠ ma̠ o̠gi̠ ka̠ o̠te̠i̠ A̠zizo̠s opuru agu̠o̠ ola̠ i̠na ta̠ a̠ru ra̠ a̠koko ma̠ ogoni d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Igiel bho̠ awa na̠ e̠gi̠ ka̠ i̠te̠i̠ A̠zizo̠s bho̠, sa̠ awa i̠le̠gh i̠na ma̠ o̠kparakpar agu̠o̠, i̠gba inigha̠ i̠na ma̠a̠: “O̠ni̠ onon akpe̠ ma̠ o̠te̠i̠ o̠lo̠gh agu̠o̠ d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ezin bho̠, i̠na a̠tula̠n ebhugh d̠i̠yar, sa̠ a̠lo ma̠ otu u̠gala d̠i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sa̠ A̠zizo̠s a̠d̠igh na̠ awa agi̠. Igiel bho̠ i̠na na̠ a̠tua̠n otu bho̠ sa̠ o̠ni̠ we̠mu̠ o̠lo̠gh e̠gham bho̠ a̠ruom ra̠tologha̠n d̠o̠yo̠ ma̠ o̠gi̠ ka̠ o̠gba onigha̠ o̠yo̠ ma̠a̠: “Wa̠nwuna̠, ko onyegi ma̠ ozu d̠oyom, ezin bho̠ ami̠ ilei d̠o̠ ma̠ ola̠ od̠ighom oyom d̠a̠ ekpukpu i̠galaga otu d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Odi abar eka̠, ami̠ na̠ aru̠ru̠an ma̠ ami̠ ilei d̠o̠ ma̠ oru ra̠ o̠bi̠ghan oyom nyen. Ya̠a̠, fughe ka̠ ma̠ abar a̠gboloma̠, sa̠ ogoni d̠ami̠ ta̠ a̠d̠um. ");
INSERT INTO mgj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ami̠ eka̠, o̠ni̠ ola̠ od̠i d̠a̠ a̠dila̠de a̠limon, sa̠ ami̠ inwuna̠ ma̠ a̠limon igboloma̠ ma̠ o̠lo̠gh e̠gham wa̠ od̠i d̠a̠ ekpukpu d̠ami̠ bho̠. Ka̠ ami̠ iruom o̠ni̠ onon ma̠a̠, ‘Gi̠e̠,’ sa̠ i̠na ta̠ agi̠; ka̠ ami̠ iruom opa̠n o̠ni̠ ma̠a̠, ‘Tue,’ sa̠ i̠na ta̠ a̠ru. Ka̠ ami̠ iruom ogoni d̠ami̠ ma̠a̠, ‘Gire ma̠ abar onon,’ sa̠ i̠na ta̠ a̠gir.” ");
INSERT INTO mgj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Obhel bho̠ A̠zizo̠s amu̠gho̠n i̠nye̠n bho̠, sa̠ a̠d̠igh i̠na ma̠ ilologia̠n, sa̠ a̠tiba̠ra̠ adama ma̠ o̠lo̠gh a̠nwunom ya̠ na̠ e̠tu̠o̠no̠m i̠na bho̠ sa̠ a̠fugh ma̠a̠, “Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, d̠a̠ ebhugh Izre̠l eka̠, ami̠ ta̠ o̠bi̠gh d̠o̠ ma̠ ologi ima̠ra̠ ola̠ abu̠gh o̠ko̠no̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sa̠ a̠nwunom ya̠ uruom a̠duom bho̠ imula̠ ka̠ i̠te̠i̠ d̠a̠ otu, sa̠ awa i̠bi̠gh ma̠ ogoni bho̠ na̠ a̠d̠um. ");
INSERT INTO mgj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Obhel a̠ten, sa̠ A̠zizo̠s agi̠ d̠a̠ odi e̠ma ola̠ ubhelegi ma̠ A̠nen, sa̠ ogbo atu̠ghan d̠o̠yo̠ na̠ obom o̠lo̠gh a̠nwunom id̠igh na̠ i̠na i̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Agu̠o̠ i̠na na̠ a̠tua̠n o̠nu̠ ogigo e̠ma bho̠, bha̠ a̠nwunom na̠ erol egua̠de na̠ emite d̠a̠ ogigo bho̠. O̠ni̠ wa̠ a̠mugh bho̠ ogini olobhiri o̠nyi̠ ta̠ odi ekpukele ani̠. Sa̠ obom o̠lo̠gh a̠nwunom d̠a̠ e̠ma bho̠ i̠ro̠ ma̠ i̠se̠ na̠ ekpon ani̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Igiel bho̠ Wa̠nwuna̠ bho̠ abi̠gh ani̠ bho̠, sa̠ igbirigbir ani̠ bho̠ id̠ighi i̠na. Sa̠ a̠fugh a̠nigha̠ ani̠ bho̠ ma̠a̠, “Ko oleghe mu.” ");
INSERT INTO mgj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sa̠ i̠na agi̠ ka̠ ate̠i̠ a̠nwunom ya̠ na̠ erol egua̠de bho̠, sa̠ a̠kula̠n abar wa̠ awa na̠ ebhin na̠ erol egua̠de bho̠, sa̠ awa i̠mara kpom. Sa̠ i̠na a̠fugh ma̠a̠, “O̠nyi̠ bho̠, ami̠ na̠ a̠fugh na̠ a̠nigha̠ ma̠ anwa, b̠etina̠!” ");
INSERT INTO mgj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sa̠ o̠ni̠ wa̠ a̠mugh bho̠ asu̠ma aro̠ ma̠ a̠dila̠de, sa̠ ake̠ ma̠ ofugh a̠fugh, sa̠ A̠zizo̠s a̠b̠eton i̠na a̠nigha̠ ma̠ onweni d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sa̠ a̠d̠igh awa ma̠ ilologia̠n, sa̠ awa itutumeni ma̠ A̠zib̠a̠ ifugh ma̠a̠, “Obom owil na̠ a̠mite d̠a̠ esa̠d̠io d̠i̠yar. A̠zib̠a̠ na̠ a̠ru ra̠ alo̠gh agu̠o̠ a̠nigha̠ ma̠ a̠nwunom d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sa̠ o̠du̠ ogir ilologia̠n ta̠ A̠zizo̠s onon asi̠saragi̠an d̠a̠ eb̠la̠ A̠zudia̠ sekina̠ d̠a̠ eghighira̠ ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sa̠ ogbo atu̠ghan ta̠ Azo̠n i̠gba ma̠ eb̠la̠ i̠di̠ar ya̠ A̠zizo̠s na̠ a̠gir bho̠ inigha̠ i̠na. Sa̠ Azo̠n a̠bhelegi i̠wal o̠ni̠ d̠a̠ esa̠d̠io d̠awa, ");
INSERT INTO mgj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","sa̠ a̠ruom awa ma̠ o̠gi̠ ka̠ opura̠n Wa̠nwuna̠ bho̠ ma̠a̠, “Anwa Witenemeni wa̠ ta̠ a̠ru bho̠ ke̠re̠, bo̠d̠o̠ ka̠ i̠yar ogon opa̠n o̠ni̠?” ");
INSERT INTO mgj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Igiel bho̠ i̠wal ogbo atu̠ghan ta̠ Azo̠n iru ra̠ i̠te̠i̠ A̠zizo̠s bho̠, sa̠ awa i̠gba inigha̠ i̠na ma̠a̠, “Azo̠n owurmamu̠m a̠ruom i̠yar oru ra̠ o̠te̠i̠ oyom opura̠n ma̠a̠, ‘Anwa o̠ni̠ wa̠ ta̠ a̠ru bho̠ ke̠re̠, bo̠d̠o̠ ka̠ i̠yar ogon opa̠n o̠ni̠?’ ” ");
INSERT INTO mgj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","D̠a̠ onin obhel obha̠, A̠zizo̠s a̠koko ma̠ a̠d̠izo a̠nwunom a̠d̠umeni d̠a̠ rasu̠nwe̠r d̠awa, sa̠ a̠ze ma̠ i̠karabh aru̠mu̠gh, sa̠ a̠d̠ighi ma̠ ola̠ ogbo ya̠ o̠bi̠gh d̠o̠ ma̠ abar na̠ e̠bi̠gh. ");
INSERT INTO mgj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sa̠ i̠na awo̠ran awa ma̠a̠, “Imula̠ ma̠ e̠gi̠ d̠a̠ Azo̠n ma̠ ebhin i̠di̠ar ya̠ inyin na̠ o̠bi̠gh bho̠, sekina̠ ya̠ inyin na̠ o̠mu̠gho̠n bho̠, ma̠ e̠gba ma̠ enigha̠ i̠na ma̠a̠: ogbo ya̠ a̠rid̠ien ib̠omia̠n bho̠ na̠ e̠bi̠gh esi, a̠rukula̠ bho̠ na̠ erile, ogbo ya̠ na̠ e̠nwe̠r asu̠nwe̠r ekid̠igh bho̠ na̠ okoko o̠b̠ab̠alame̠ni̠, remua̠ bho̠ na̠ e̠mu̠gho̠n abar, imumugh a̠nwunom na̠ ob̠egion, sa̠ na̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ na̠ onigha̠ ma̠ ronyigoiny bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Itutumeni e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠, d̠a̠ ebula̠ ami̠, sa̠ ologi ima̠ra̠ odugh d̠o̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Obhel bho̠ itileduom ta̠ Azo̠n na̠ e̠d̠u̠a bho̠, sa̠ A̠zizo̠s ake̠ ma̠ o̠gba i̠di̠ar ya̠ igboloma̠ ma̠ Azo̠n onigha̠ ro̠lo̠gh a̠nwunom bho̠ ma̠a̠: “Inyin u̠gi̠ d̠a̠ obom e̠sala ed̠um bho̠ ka̠ o̠bi̠gh ere? Ikpoko ya̠ na̠ eduka̠ d̠a̠ o̠fe̠gu̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ku̠gba ma̠ o̠ku̠a d̠o̠, ka̠ inyin u̠gi̠ ka̠ u̠bi̠gh ere? O̠ni̠ ola̠ na̠ a̠bura̠ ma̠ ib̠eb̠i ibura̠ ke̠re̠? E̠e̠nyi̠, a̠nwunom ya̠ na̠ e̠lo̠gi̠an rakapa ibom a̠b̠ua̠, na̠ ogbo ya̠ na̠ enigha̠ ma̠ a̠ruzu d̠awa ma̠ e̠me̠me̠m e̠mara̠nwunom bho̠, od̠i d̠a̠ rogigo aru̠li̠le̠ma. ");
INSERT INTO mgj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ya̠a̠, inyin u̠gi̠ ka̠ u̠bi̠gh ere? Owil ke̠re̠? Yii, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ a̠pu ma̠ owil. ");
INSERT INTO mgj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Onon o̠ni̠ wa̠ u̠ge̠ ugboloma̠ bho̠, ma̠a̠: “ ‘Ami̠ ta̠ a̠ruom o̠ni̠ a̠duom d̠ami̠ ma̠ od̠ia̠ o̠gi̠, ka̠ o̠tu̠ghu̠man eten bho̠, kisa̠ anwa ta̠ ake̠ ma̠ o̠gi̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, d̠a̠ ogbo ya̠ anwani̠ i̠maragi̠ bho̠, o̠ni̠ ola̠ abu̠gh a̠pu ma̠ Azo̠n bo̠; ya̠a̠, o̠ni̠ wa̠ aki̠r a̠pu d̠a̠ irileghom ta̠ A̠zib̠a̠ bho̠ abu̠gh a̠pu i̠na.” ");
INSERT INTO mgj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Igiel bho̠ eb̠la̠ a̠nwunom bho̠, na̠ igun ma̠ otua̠-ebhugh bho̠ i̠mu̠gho̠n a̠fugh ta̠ A̠zizo̠s bho̠, sa̠ awa id̠igh ani̠ i̠bi̠gh ma̠ eten ta̠ A̠zib̠a̠ ob̠eb̠i, ezin bho̠ Azo̠n na̠ a̠wur awa ma̠ amu̠m. ");
INSERT INTO mgj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ya̠a̠, a̠nwunom Afarisi bho̠, sekina̠ ogbo ya̠ na̠ e̠ku̠ro̠m d̠a̠ oloko bho̠, ighel i̠to̠ ta̠ A̠zib̠a̠ ya̠ igboloma̠ ma̠ a̠ghud̠um d̠awa bho̠, ezin bho̠ awa ima̠ra̠ d̠o̠ ma̠ Azo̠n owur awa ma̠ amu̠m. ");
INSERT INTO mgj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa̠ Azizo̠s a̠pura̠n ma̠a̠, “Ami̠ ta̠ a̠bhin ere atu̠o̠m a̠nwunom amu̠m onon? Awa i̠gu̠b̠an ere? ");
INSERT INTO mgj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Awa od̠i ka̠ i̠gbara anwi̠i̠ny ya̠ od̠i ma̠ a̠dila̠de d̠a̠ egbolom a̠b̠ua̠, sa̠ odi na̠ a̠bhelegi ma̠ odi na̠ e̠go̠ya ma̠a̠: “ ‘I̠yar upughe ma̠ od̠od̠ue onigha̠ inyin, ya̠a̠ inyin u̠ghe̠r d̠o̠ ma̠ i̠gba, i̠yar u̠mo̠r aso̠r ekulom onigha̠ inyin eka̠, inyin uleghe d̠o̠ osorogi ma̠ izin nyen.’ ");
INSERT INTO mgj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Azo̠n owurmamu̠m a̠ru bho̠, i̠na na̠ od̠e d̠o̠ ma̠ a̠ga̠i ed̠ia̠n, na̠ o̠d̠a d̠o̠ ma̠ a̠min, sa̠ inyin u̠gba ma̠a̠, ‘O̠karabh e̠mu̠gh na̠ ab̠am i̠na.’ ");
INSERT INTO mgj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","O̠nyi̠ ta̠ O̠ni̠ a̠ru, i̠na a̠d̠e na̠ ad̠a, sa̠ inyin u̠gba ma̠a̠, ‘Onon o̠d̠o̠gho̠d̠o̠gh sekina̠ o̠d̠a ma̠ a̠min, na̠ a̠tologha̠n ta̠ igun ma̠ otua̠-ebhugh na̠ rod̠ighi ma̠ i̠karabh.’ ");
INSERT INTO mgj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yaa̠, a̠nwunom ya̠ inwuna̠ ma̠ eloghom abar ta̠ A̠zib̠a̠ na̠ erugh na̠ eleriom ma̠ eloghom abar a̠bhon.” ");
INSERT INTO mgj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Odi o̠ni̠ Afarisi a̠lebh A̠zizo̠s ma̠ oru ra̠ od̠igh na̠ o̠yo̠ od̠e abar, sa̠ i̠na a̠ten agi̠ d̠a̠ otu o̠ni̠ bho̠ ka̠ aro̠ ma̠ a̠dila̠de ma̠ o̠gho̠ d̠a̠ a̠de, d̠a̠ aka akpata od̠e bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sa̠ odi ani̠ ola̠ e̠ma bho̠, ola̠ na̠ a̠rugh i̠karabh a̠ma̠rugh, amu̠gho̠n ma̠ A̠zizo̠s na̠ a̠d̠e ma̠ abar d̠a̠ otu o̠ni̠ Afarisi bho̠, sa̠ i̠na a̠bhin ololo ola̠ ubhin ob̠eb̠i o̠gbe̠o̠ma ola̠ ubhelegi ma̠ alabasta u̠le̠m, ola̠ elo ed̠u e̠nu̠nu̠ i̠ro̠ d̠a̠ ologi bho̠ agi̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sa̠ i̠na amara d̠a̠ aman ta̠ A̠zizo̠s d̠a̠ aka a̠sike d̠o̠yo̠, sa̠ na̠ a̠leghe, sa̠ izin d̠o̠yo̠ na̠ e̠b̠o̠ro̠gi̠ ma̠ a̠sike ta̠ A̠zizo̠s. Sa̠ a̠bhin asi̠ghal d̠o̠yo̠ a̠gbul izin bho̠ asi̠ghe̠ d̠a̠ a̠sike ta̠ A̠zizo̠s, na̠ api̠pi̠o̠bh a̠sike bho̠, sa̠ a̠bhin elo ed̠u e̠nu̠nu̠ bho̠ a̠zugioghom. ");
INSERT INTO mgj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Igiel bho̠ o̠ni̠ Afarisi wa̠ a̠lebh i̠na bho̠ abi̠gh abar onon bho̠, sa̠ i̠na a̠fugh d̠a̠ ologi d̠o̠yo̠ ma̠a̠, “O̠ni̠ onon aro̠ ma̠ owil nab̠o̠, i̠na ka̠ iloghom o̠le̠m ani̠ wa̠ na̠ a̠kula̠n i̠na bho̠, ma̠ ani̠ bho̠ od̠ighi ma̠ i̠karabh.” ");
INSERT INTO mgj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sa̠ A̠zizo̠s a̠fugh a̠mutiom awo̠ran i̠na ma̠a̠, “Asai̠mo̠n, ami̠ a̠nwuna̠ ma̠ abar ola̠ o̠gba onigha̠ oyom.” Sa̠ i̠na awo̠ran ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, gba ma̠ a̠nigha̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“I̠wal a̠nwunom id̠ikighu ma̠ i̠mu̠gh d̠a̠ agu̠o̠ odi o̠ni̠ ola̠ na̠ awo̠lo̠gi̠ ma̠ a̠nwunom ikpoki. Odi o̠ni̠ bho̠ a̠d̠igh o̠mu̠gh o̠ni̠r na̠ i̠wal e̠wala na̠ a̠d̠usubh (500) adi̠nari̠, uwed̠i sa̠ a̠d̠igh o̠mu̠gh eruba̠l na̠ d̠iobh (50) adi̠nari̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","O̠ni̠ awa ola̠ a̠rue ma̠ o̠kpe̠ o̠mu̠gh d̠o̠yo̠ na̠ o̠ro̠ d̠o̠. Ebula̠ o̠ku̠a sa̠ i̠na awe̠le̠man i̠mu̠gh bho̠ a̠nigha̠ awa. I̠se̠ ka̠, d̠a̠ i̠wal a̠nwunom i̠nye̠ ka̠ oken ta̠ a̠tula̠n i̠na a̠pu?” ");
INSERT INTO mgj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Asai̠mo̠n awo̠ran ma̠a̠, “Ami̠ na̠ aru̠ru̠an ma̠ o̠ni̠ wa̠ u̠we̠le̠man o̠mu̠gh wa̠ abu̠gh a̠pu bho̠.” Sa̠ A̠zizo̠s agba a̠nigha̠ i̠na ma̠a̠, “Anwa na̠ a̠sobh ase̠ bho̠ ma̠ iya̠ igielake̠.” ");
INSERT INTO mgj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sa̠ i̠na a̠tiba̠ra̠ adama ma̠ ani̠ bho̠ sa̠ a̠fugh a̠nigha̠ ma̠ Asai̠mo̠n ma̠a̠, “Anwa na̠ abi̠gh ani̠ onon? Ami̠ iru d̠a̠ otu d̠oyom, ya̠a̠ anwa na̠ onigha̠ d̠o̠ ami̠ ma̠ amu̠m ya̠ obhin otitola̠ a̠sike d̠ami̠. Ya̠a̠, i̠na na̠ a̠bhin izin d̠o̠yo̠ a̠b̠o̠ro̠gi̠ ma̠ a̠sike d̠ami̠ sa̠ a̠bhin asi̠ghal d̠o̠yo̠ a̠gbul asi̠ghe̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Anwa na̠ o̠pi̠pi̠o̠bh d̠o̠ ami̠, ya̠a̠ ani̠ onon ka̠ obhel bho̠ ami̠ id̠igh iru ma̠ i̠se̠n bho̠, i̠na ta̠ o̠we̠le̠ d̠o̠ ma̠ o̠pi̠pi̠o̠bh a̠sike d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Anwa na̠ ozuom d̠o̠ ma̠ e̠mu̠ d̠ami̠ ma̠ amu̠nu̠, ya̠a̠ ani̠ onon na̠ a̠zugioghom a̠sike d̠ami̠ ma̠ elo ed̠u e̠nu̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ami̠ na̠ agba na̠ a̠nigha̠ ma̠ anwa ma̠a̠, na̠ o̠we̠le̠man i̠karabh d̠o̠yo̠ ya̠ ib̠uiy opa̠n bho̠ onigha̠ i̠na, ma̠ agu̠o̠ i̠na na̠ a̠leriom ibom etula̠n bho̠. Ya̠a̠, i̠na o̠ni̠ wa̠ u̠we̠le̠man o̠nyi̠ki̠kara i̠karabh unigha̠ bho̠, ta̠ a̠leriom o̠nyi̠ki̠kara etula̠n ku̠ku̠m.” ");
INSERT INTO mgj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ ani̠ bho̠ ma̠a̠, “I̠karabh d̠oyom na̠ o̠we̠le̠man onigha̠ ma̠ anwa.” ");
INSERT INTO mgj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sa̠ a̠nwunom iyed̠i ya̠ id̠igh na̠ i̠na na̠ ed̠e ma̠ ed̠ia̠n bho̠, i̠ke̠ ma̠ ofugh d̠a̠ esa̠d̠io d̠awa ma̠a̠, “Onon ka̠ a̠nyen, wa̠ na̠ awe̠le̠man i̠karabh na̠ a̠nigha̠ ma̠ a̠nwunom bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ ani̠ bho̠ ma̠a̠, “Ologi ima̠ra̠ d̠oyom na̠ etenemeni ma̠ anwa; gi̠e̠ na̠ ekima̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Onon a̠ru a̠ten, sa̠ A̠zizo̠s ad̠u̠a ma̠ e̠ma a̠ten e̠ma, na̠ agba na̠ a̠mutiom ib̠eb̠i asu̠gbagba irileghom ta̠ A̠zib̠a̠ d̠a̠ eb̠la̠ ibom na̠ i̠gbara re̠ma bho̠. D̠iobh na̠ i̠wal ogbo-ogir bho̠ e̠ro̠ na̠ i̠na, ");
INSERT INTO mgj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na̠ idi anwani̠ ya̠ i̠na asi̠ghe̠gi̠ ma̠ i̠karabh aru̠mu̠gh d̠a̠ ozu na̠ iya̠ a̠koko d̠a̠ rasu̠nwe̠r a̠d̠umeni. A̠meri wa̠ Amagdala bho̠ wa̠ u̠si̠ghe̠ ma̠ od̠ua̠l i̠karabh aru̠mu̠gh d̠a̠ ozu bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","A̠zoana ani̠ ta̠ A̠suza̠, okponom ma̠ otu ta̠ E̠ro̠d, na̠ A̠suzana, na̠ ipa̠n a̠nwunom ya̠ ib̠uiy ibhin ghan i̠di̠ar ya̠ awa inwuna̠ bho̠ e̠lo̠gh agu̠o̠ enigha̠ ma̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","D̠a̠ obhel ola̠ a̠d̠izo a̠nwunom na̠ e̠d̠u̠a ke̠ma ke̠ma eru ra̠ ed̠igh na̠ i̠na ekokod̠ia̠n onin esi bho̠, sa̠ i̠na a̠rogh a̠sidogh ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ogbebhma̠ agi̠ ka̠ ogbebh ikpo ed̠ia̠n. Igiel bho̠ i̠na a̠kpo asar bho̠, sa̠ idi imel d̠a̠ eten sa̠ u̠ze̠re̠gi̠, sa̠ i̠nu̠r iru ra̠ ikpokpoiny id̠e i̠mado̠n. ");
INSERT INTO mgj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Idi imel d̠a̠ a̠de o̠gbe̠o̠ma, i̠ke̠ aka ma̠ o̠su̠ sa̠ imugughu d̠a̠ agu̠o̠ bho̠ irue d̠o̠ ma̠ o̠te̠i̠ amu̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Idi imel d̠a̠ ed̠um ib̠ub̠ulom. Sa̠ iriren ib̠ub̠ulom bho̠ na̠ ikpo ed̠ia̠n i̠nye̠ i̠su̠ imite, sa̠ iriren ib̠ub̠ulom bho̠ ikpegiom i̠bhu̠ghu̠d̠i̠ awa i̠ze̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ya̠a̠ idi imel d̠a̠ ob̠eb̠i a̠de, sa̠ i̠mar i̠su̠ imum imutiom i̠wal e̠wala na̠ a̠d̠usubh a̠bin o̠nu̠ ya̠ ubhin ugbebh bho̠.” A̠fugh i̠nye̠n awe̠le̠ sa̠ a̠mulughu a̠fugh ma̠a̠, “I̠na wa̠ a̠nwuna̠ ma̠ a̠to ma̠ o̠mu̠gho̠n bho̠, amu̠gho̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sa̠ ogbo atu̠ghan d̠o̠yo̠ ipura̠n I̠na ma̠a̠, “Ezin a̠sidogh bho̠ ka̠ ere?” ");
INSERT INTO mgj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sa̠ I̠na awo̠ran ma̠a̠, “D̠a̠ inyin, na̠ onigha̠ ma̠ ologhom i̠di̠ar e̠wo̠gi̠na irileghom ta̠ A̠zib̠a̠; ya̠a̠, d̠a̠ a̠nwunom iyed̠i, urogh a̠sidogh onigha̠ b̠o̠ka̠, “ ‘awa ta̠ ekpon ya̠a̠ awa ko o̠bi̠gh d̠o̠, ta̠ e̠mu̠gho̠n ya̠a̠ awa ko o̠mu̠gho̠nyan d̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ezin a̠sidogh bho̠, bha̠ o̠ko̠no̠n: Ikpo ed̠ia̠n bho̠, bha̠ ikpo-a̠fugh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ikpo ya̠ imel d̠a̠ eten bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n; sa̠ eru bho̠ a̠ru ra̠ asi̠ghe̠gi̠ ma̠ ikpo a̠fugh bho̠ d̠a̠ rologi d̠awa, b̠o̠ka̠ awa id̠umom eten. ");
INSERT INTO mgj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya̠a̠ ikpo ya̠ imel d̠a̠ a̠de o̠gbe̠o̠ma bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n, sa̠ ibhin d̠a̠ a̠libhon ologi i̠da ma̠ ikpo a̠fugh bho̠ ibhin; ya̠a̠ i̠te̠i̠ d̠o̠ ma̠ i̠kaka, awa ima̠ra̠ ma̠ ekud̠i obhel sa̠ imel i̠d̠u̠a d̠a̠ obhel ad̠agi̠an. ");
INSERT INTO mgj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ikpo ya̠ imel d̠a̠ ed̠um ib̠ub̠ulom bho̠, bha̠ ogbo ya̠ i̠mu̠gho̠n, ya̠a̠ a̠tepa̠ sa̠ i̠nyo̠gho̠nyo̠gh e̠mara̠nwunom, e̠li̠la na̠ e̠me̠me̠m e̠mara̠nwunom i̠vi̠mo̠m ola̠ irue d̠o̠ ma̠ omum itu ya̠ ta̠ e̠ro̠ e̠kpo̠ e̠b̠am. ");
INSERT INTO mgj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ya̠a̠, ikpo ya̠ imel d̠a̠ ob̠eb̠i a̠de bho̠, bha̠ ogbo ya̠ ibhin ob̠eb̠i ologi i̠mu̠gho̠n ikpo a̠fugh bho̠, sa̠ i̠da ibhin i̠b̠ar na̠ a̠ma̠ne, sa̠ imum itu ya̠ i̠kpo̠ sa̠ i̠b̠am. ");
INSERT INTO mgj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“O̠ni̠ ola̠ ta̠ asu̠o̠m ato̠di̠, sa̠ ta̠ awo̠gi̠ d̠a̠ ekpukpu abafu̠ bo̠d̠o̠ d̠a̠ ekpukpu akpata bo̠. Kpe̠le̠me̠ni̠, i̠na ta̠ agbam d̠a̠ anyu̠ esi ola̠, ka̠ a̠nwunom ud̠igh esi bho̠ ta̠ e̠bi̠gh abar. ");
INSERT INTO mgj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Abar ola̠ e̠wo̠gi̠na ola̠ ko omutiom d̠o̠ ma̠ a̠nwunom o̠bi̠gh bo̠, bo̠d̠o̠ abar ola̠ u̠wo̠gi̠ ola̠ ko o̠bi̠gh d̠o̠ obhin omutiom d̠a̠ e̠b̠alab̠al bo̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠mare̠ ma̠ e̠nagha ma̠ e̠mu̠gho̠n. O̠ni̠ ola̠ ate̠i̠ ta̠ onigha̠ ma̠ o̠gbam; ya̠a̠, o̠ni̠ ola̠ o̠te̠i̠ d̠o̠, iya̠ i̠na na̠ aru̠ru̠an ma̠ i̠na ate̠i̠ bho̠ eka̠, ta̠ o̠wo̠r obhin.” ");
INSERT INTO mgj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","I̠se̠n onweni na̠ a̠rumor d̠o̠yo̠ iru ra̠ o̠bi̠ghan o̠yo̠, ya̠a̠ d̠a̠ ebula̠ o̠lo̠gh a̠nwunom bho̠, awa irue d̠o̠ ma̠ o̠te̠i̠ o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sa̠ odi o̠ni̠ agba a̠nigha̠ i̠na ma̠a̠, “Onweni d̠oyom na̠ a̠rumor d̠oyom na̠ e̠mara d̠a̠ etire na̠ e̠bho̠ro̠gh o̠bi̠ghan onyom.” ");
INSERT INTO mgj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Onweni d̠ami̠ na̠ a̠rumor d̠ami̠ bha̠ ogbo ya̠ i̠mu̠gho̠n ikpo a̠fugh ta̠ A̠zib̠a̠ sa̠ igir o̠ku̠a bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Odi a̠d̠a̠ma̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠ id̠igh oghugh. Sa̠ i̠na a̠fugh ma̠a̠, “Id̠ighi o̠b̠e̠i̠y d̠a̠ aku̠b̠o̠ o̠bhi̠i̠y-eko bho̠.” Sa̠ awa igim avala bho̠ imutiom oghugh bho̠ ma̠ o̠b̠e̠i̠y. ");
INSERT INTO mgj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Igiel bho̠ awa na̠ e̠b̠e̠i̠y bho̠ sa̠ adi̠la ibhinom i̠na. Sa̠ ogim a̠gim awai̠ d̠a̠ o̠bhi̠i̠y-eko bho̠ sa̠ abadi̠ bho̠ agam. Sa̠ amu̠m ipoka̠n na̠ ed̠igh na̠ emuzo d̠a̠ oghugh bho̠, sa̠ awa iloghoma̠n ma̠ obom a̠d̠ugh na̠ ate̠i̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sa̠ awa i̠gi̠ ka̠ i̠su̠me̠ni̠ i̠na, ifugh ma̠a̠, “Wa̠nwuna̠, Wa̠nwuna̠, i̠yar na̠ owi-o!” Sa̠ i̠na a̠b̠etina̠ ab̠ab̠agi̠na ma̠ ogim bho̠ na̠ abadi̠ wa̠ na̠ agam bho̠, sa̠ ogim bho̠ a̠b̠okum sa̠ ekima̠ a̠mite. ");
INSERT INTO mgj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ya̠a̠, i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Ologi ima̠ra̠ d̠inyin ka̠ od̠i d̠a̠ken?” Sa̠ id̠igh awa ma̠ a̠rugugu na̠ ilologia̠n, sa̠ odi na̠ a̠fugh na̠ a̠nigha̠ ma̠ odi ma̠a̠, “Onon ka̠ a̠kere a̠d̠ien o̠ni̠? Ka̠ i̠na ab̠ab̠agi̠na ma̠ ogim na̠ opoka̠n amu̠m eka̠, sa̠ awa na̠ e̠mu̠gho̠n na̠ e̠ro̠ to̠i̠ny, ma̠ agu̠o̠ i̠na a̠fugh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Awa i̠zo̠ghu̠ ka̠ isul d̠a̠ agba ebhugh Age̠rasa, d̠a̠ aku̠b̠o̠ Agalili. ");
INSERT INTO mgj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I̠na a̠pel a̠bhun d̠a̠ egbolom, sa̠ o̠ni̠ ola̠ e̠ma bho̠ ola̠ i̠karabh aru̠mu̠gh na̠ e̠ro̠ d̠a̠ ozu bho̠ ebia̠ ami̠nana i̠na. O̠ni̠ bho̠ na̠ o̠lo̠gi̠an d̠o̠ ma̠ ibura̠ ma̠ owewegh obhel, na̠ orugh d̠o̠ d̠a̠ otu nyen; ya̠a̠ a̠rugh ka̠ d̠a̠ o̠karabh esi. ");
INSERT INTO mgj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","O̠ni̠ bho̠ abi̠gh A̠zizo̠s, sa̠ a̠mulughu, sa̠ a̠mel a̠kpud̠ia̠n d̠a̠ a̠misigh d̠o̠yo̠, sa̠ a̠bhin obom okoroko a̠fugh ma̠a̠, “Anwa na̠ ami̠ ka̠ unwuna̠ ma̠ ere, A̠zizo̠s, O̠nyi̠ ta̠ A̠zib̠a̠ Wagi̠manyu̠ A̠pu bho̠? Siseiny, ko ogbikimeni ami̠!” ");
INSERT INTO mgj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ezin bho̠, A̠zizo̠s na̠ ab̠ab̠agi̠na ma̠ o̠karabh e̠mu̠gh bho̠ ma̠ omite o̠d̠u̠a d̠a̠ ozu o̠ni̠ bho̠. A̠d̠izo robhel na̠ a̠guri ghan na̠ a̠b̠oroghom o̠ni̠ bho̠, sa̠ ubhin i̠go̠ro̠go̠ro̠ na̠ ikoli u̠du̠o̠m ghan i̠na d̠a̠ aru̠gu̠o̠ na̠ a̠sike, sa̠ uguri ma̠ esi ukponom, ya̠a̠ i̠na a̠gbugbo ma̠ i̠go̠ro̠go̠ro̠ na̠ ikoli ya̠ ubhin ghan u̠du̠o̠m i̠na bho̠, sa̠ o̠karabh e̠mu̠gh bho̠ a̠b̠or i̠na a̠d̠ighom d̠a̠ e̠ghana. ");
INSERT INTO mgj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “A̠d̠ien d̠oyom ka̠ ubhelegi eka̠?” Sa̠ i̠na awo̠ran ma̠a̠, “A̠d̠izo,” ezin bho̠ a̠d̠izo i̠karabh aru̠mu̠gh na̠ erugh d̠a̠ ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sa̠ i̠karabh aru̠mu̠gh bho̠, i̠le̠gh i̠na ma̠ i̠na oze d̠o̠ awa a̠d̠ighom, d̠a̠ ogugua̠ ekunuguma̠ o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","D̠a̠ obhel obha̠, obom o̠lo̠gh roporopo i̠ro̠ ma̠ i̠se̠ d̠a̠ a̠gbo bho̠ na̠ eb̠u na̠ ed̠e. Sa̠ i̠karabh aru̠mu̠gh bho̠ i̠le̠gh i̠na ma̠ i̠na a̠ma̠ra̠ awa ma̠ o̠gi̠ ka̠ od̠igh d̠a̠ rozu roporopo bho̠. Sa̠ i̠na a̠ma̠ra̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sa̠ i̠karabh aru̠mu̠gh bho̠ imite i̠d̠u̠a d̠a̠ o̠ni̠ bho̠ ka̠ id̠igh d̠a̠ roporopo bho̠. Sa̠ roporopo bho̠ i̠d̠u̠a d̠a̠ a̠gbo bho̠ ighil isor d̠a̠ o̠bhi̠i̠y-eko bho̠ i̠bhu̠ghu̠d̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","D̠a̠ obhel bho̠ ogbo ya̠ na̠ ekponom roporopo bho̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠, sa̠ awa ighil i̠d̠u̠a ka̠ i̠gba d̠a̠ ibom na̠ i̠gbara re̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sa̠ a̠nwunom bho̠ i̠gi̠ ka̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠. Sa̠ awa iru d̠a̠ A̠zizo̠s ra̠ i̠bi̠gh ma̠ o̠ni̠ wa̠ i̠karabh aru̠mu̠gh bho̠ i̠d̠u̠a d̠a̠ ozu bho̠ na̠ a̠loghoma̠n ozu, a̠bura̠ ma̠ ibura̠, ari̠la ma̠ a̠dila̠de d̠a̠ aka a̠sike ta̠ A̠zizo̠s. Sa̠ a̠rugugu isibh awa. ");
INSERT INTO mgj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sa̠ ogbo ya̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠, i̠gba ma̠ a̠d̠ien agu̠o̠ o̠ni̠ wa̠ i̠karabh aru̠mu̠gh i̠ro̠ d̠a̠ ozu bho̠ a̠bhin a̠d̠um. ");
INSERT INTO mgj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","O̠ku̠a sa̠ eb̠la̠ o̠lo̠gh a̠nwunom d̠a̠ ebhugh Age̠rasa ize ma̠ A̠zizo̠s ma̠ a̠ten ad̠u̠a d̠a̠ ebhugh d̠awa, d̠a̠ agu̠o̠ bho̠ ibom a̠rugugu na̠ esibh awa bho̠. Sa̠ i̠na a̠d̠igh d̠a̠ oghugh a̠mula̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O̠ni̠ wa̠ i̠karabh aru̠mu̠gh i̠d̠u̠a d̠a̠ ozu bho̠ ale̠gh A̠zizo̠s ma̠a̠, “Ma̠ra̠ ami̠ id̠igh na̠ anwa i̠ro̠.” Ya̠a̠, A̠zizo̠s a̠bhin o̠kparakpar okoroko a̠fugh a̠nigha̠ i̠na ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mula̠ ma̠ agi̠ d̠a̠ otu d̠oyom, ma̠ agba ma̠ a̠mutiom ibom i̠di̠ar ya̠ A̠zib̠a̠ na̠ a̠gir a̠nigha̠ ma̠ anwa bho̠.” Sa̠ i̠na a̠d̠igh eten agba asasaragi̠ d̠a̠ eb̠la̠ e̠ma bho̠ ma̠ ibom i̠di̠ar ya̠ A̠zizo̠s a̠gir a̠nigha̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","D̠a̠ obhel wa̠ A̠zizo̠s ab̠e̠i̠ a̠mula̠ d̠a̠ aku̠b̠o̠ uwed̠i bho̠, sa̠ o̠lo̠gh a̠nwunom bho̠ i̠da i̠na ibhin, ezin bho̠ eb̠la̠ awa i̠ro̠ na̠ egon i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sa̠ o̠ni̠ ola̠ ubhelegi ma̠ Azai̠ru̠s, we̠mu̠ u̠gala A̠zu a̠ru, sa̠ a̠mel a̠kpud̠ia̠n d̠a̠ a̠misigh ta̠ A̠zizo̠s ale̠gh i̠na ma̠ oru d̠a̠ otu d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ezin bho̠ onin ekpo o̠nyani̠ d̠o̠yo̠ ola̠ na̠ a̠lei agu̠o̠ a̠d̠iobh na̠ i̠wal rala, na̠ anwe̠r na̠ a̠ru ra̠ omugh. I̠na a̠b̠etina̠ na̠ agi̠, sa̠ obom o̠lo̠gh a̠nwunom iko i̠na ikiton na̠ e̠ni̠r i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Odi ani̠ aro̠ d̠a̠ o̠lo̠gh bho̠, ma̠ ola̠ na̠ a̠rughom eb̠la̠ ikpoki d̠o̠yo̠, ad̠u̠a ma̠ owil a̠ten owil ma̠ okokua̠n asu̠nwe̠r anwani̠ ola̠ asi̠ na̠ e̠gbo̠ d̠iobh na̠ i̠wal ala, ya̠a̠ o̠ni̠ ola̠ a̠rue ma̠ okoko o̠yo̠ na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ani̠ bho̠ awo̠l d̠a̠ aman a̠ru, sa̠ ra̠ a̠kula̠n akapa ta̠ A̠zizo̠s, ma̠ esi bho̠ u̠labh d̠a̠ a̠de bho̠. D̠a̠ onin obhel obha̠ sa̠ asi̠ bho̠ isobha̠n. ");
INSERT INTO mgj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa̠ A̠zizo̠s a̠pura̠n ma̠a̠, “A̠nyen a̠kula̠n ami̠?” Sa̠ eb̠la̠ awa i̠ku̠a, sa̠ A̠pita̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Wa̠nwuna̠, o̠lo̠gh a̠nwunom bho̠ na̠ e̠ni̠ran na̠ ekulugha̠n anwa.” ");
INSERT INTO mgj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ya̠a̠ A̠zizo̠s a̠fugh ma̠a̠, “O̠ni̠ a̠kula̠n ami̠, ezin bho̠ ami̠ na̠ a̠loghoma̠n ma̠ a̠limon na̠ e̠d̠u̠a d̠a̠ ozu d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Igiel bho̠ ani̠ bho̠ a̠loghoma̠n ma̠ i̠na ko orue d̠o̠ awo̠gi̠na ad̠u̠a bho̠, sa̠ i̠na a̠bhin a̠rugugu a̠mutuma̠, a̠mel a̠kpud̠ia̠n d̠a̠ a̠misigh ta̠ A̠zizo̠s. Sa̠ i̠na agba d̠a̠ esa̠d̠io eb̠la̠ o̠lo̠gh a̠nwunom bho̠, ma̠ ezin wa̠ i̠na atu̠n a̠kula̠n i̠na bho̠, sekina̠ a̠d̠ien agu̠o̠ i̠na a̠d̠um d̠a̠ onin obhel obha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Sa̠ A̠zizo̠s a̠fugh ma̠a̠, “O̠nyani̠ bho̠, ologi ima̠ra̠ d̠oyom na̠ a̠d̠umeni nyam. Gi̠e̠ na̠ ekima̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Agu̠o̠ A̠zizo̠s od̠id̠ia̠ na̠ a̠fugh bho̠, sa̠ odi o̠ni̠ ad̠u̠a d̠a̠ otu ta̠ Azari̠o̠s, we̠mu̠ u̠gala A̠zu bho̠, a̠ru ra̠ agba a̠nigha̠ i̠na ma̠a̠, “O̠nyani̠ d̠oyom na̠ a̠mugh. Ko onyegi mu ma̠ o̠ni̠ atu̠ghu̠me̠ni̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ya̠a̠, obhel bho̠ A̠zizo̠s amu̠gho̠n bho̠, sa̠ a̠fugh a̠nigha̠ ma̠ Azari̠o̠s ma̠a̠, “Ko oghil a̠rugugu; d̠umome ku̠ku̠m, sa̠ i̠na ta̠ a̠d̠um.” ");
INSERT INTO mgj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Igiel bho̠ i̠na a̠misi d̠a̠ otu bho̠, i̠na na̠ oma̠ra̠ d̠o̠ ma̠ opa̠n o̠ni̠ ma̠ od̠igh d̠a̠ ologi, a̠ten A̠pita̠, Azo̠n na̠ A̠zemsi, na̠ onweni na̠ o̠we̠de̠ o̠nyani̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ko̠ni̠ko̠ni̠ na̠ a̠sorogi ma̠ izin na̠ e̠ku̠nu̠. Ya̠a̠ i̠na a̠fugh ma̠a̠, “O̠ni̠ ko oleghe mu, o̠nyani̠ bho̠ na̠ omugh d̠o̠, na̠ a̠kod̠u a̠kod̠ua̠.” ");
INSERT INTO mgj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sa̠ awa i̠ki̠ri̠ i̠na, d̠a̠ a̠d̠ien agu̠o̠ awa iloghom ma̠ o̠nyani̠ bho̠ na̠ a̠mugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ya̠a̠ A̠zizo̠s a̠sibh o̠nyani̠ bho̠ d̠a̠ agu̠o̠ a̠fugh ma̠a̠, “O̠nyani̠ bho̠, b̠etina̠!” ");
INSERT INTO mgj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sa̠ e̠mu̠gh o̠nyani̠ bho̠ a̠mula̠ a̠ru, sa̠ i̠na a̠b̠etina̠ ma̠ egbo. Sa̠ A̠zizo̠s a̠ruom awa ma̠ onigha̠ o̠nyani̠ bho̠ ma̠ ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sa̠ id̠igh ilologia̠n ma̠ oweni na̠ o̠we̠de̠ o̠nyani̠ bho̠. Ya̠a̠, A̠zizo̠s anyagh ra̠to d̠awa a̠fugh ma̠ awa o̠gba d̠o̠ ma̠ abar wa̠ a̠mite bho̠ enigha̠ bebina̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A̠zizo̠s a̠kokod̠i ma̠ d̠iobh na̠ i̠wal bho̠, sa̠ i̠na a̠nigha̠ awa ma̠ a̠limon na̠ a̠dila̠de obhin oze eb̠la̠ i̠karabh aru̠mu̠gh o̠sighe̠gi̠ na̠ okoko rasu̠nwe̠r. ");
INSERT INTO mgj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sa̠ i̠na a̠ruom awa ma̠ o̠gi̠ ka̠ o̠gba ya̠ igboloma̠ ma̠ irileghom ta̠ A̠zib̠a̠ omutiom, na̠ okoko ogbo asu̠nwe̠r. ");
INSERT INTO mgj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “O̠ni̠ ko obhin bebina̠ abar eb̠etina̠ ma̠ e̠gi̠ bho̠: a̠d̠igh okpeti, a̠d̠igh e̠kpa e̠gi̠, a̠d̠igh ed̠ia̠n, a̠d̠igh okpoki; ukpe onwegina̠ o̠ro̠ d̠o̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","E̠ma ola̠ inyin ud̠igh, ikpone ma̠ onin otu ma̠ esul e̠ro̠ ma̠ i̠se̠, tu̠tu̠n inyin ta̠ ob̠etina̠ o̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","E̠ma ola̠ a̠nwunom bho̠ o̠d̠a d̠o̠ inyin ebhin, ikpukpu ma̠ ibhugh e̠b̠ab̠a a̠sike d̠inyin ma̠ esorogi, ma̠ eten e̠d̠u̠a. Obha̠ ta̠ aro̠ ma̠ elegh ma̠a̠ awa na̠ e̠so̠n ebhum ase̠ ebhin.” ");
INSERT INTO mgj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sa̠ awa ib̠etina̠ ma̠ e̠gi̠ bho̠, i̠d̠u̠a ma̠ e̠ma iten e̠ma, i̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠, sa̠ ikoko ma̠ a̠nwunom kesikesi. ");
INSERT INTO mgj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Igiel bho̠ E̠ro̠d o̠li̠la ebhugh Agalili amu̠gho̠n a̠gboloma̠ ma̠ eb̠la̠ i̠di̠ar ya̠ na̠ emite bho̠, sa̠ asu̠su̠ghu̠d̠i̠an. Ezin bho̠ idi a̠nwunom na̠ e̠gba ma̠ Azo̠n owurmamu̠m bho̠ na̠ a̠b̠etina̠ d̠a̠ omugh. ");
INSERT INTO mgj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Idi ogbo sa̠ na̠ e̠gba ma̠ owil I̠lai̠za a̠mula̠ a̠ru, ya̠a̠ ipa̠n ogbo sa̠ na̠ e̠gba ma̠ odi opa̠n owil igied̠i a̠mula̠ a̠ru d̠a̠ a̠ghud̠um. ");
INSERT INTO mgj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","E̠ro̠d sa̠ a̠fugh ma̠a̠, “Azo̠n, sa̠ ami̠ na̠ a̠sobh e̠mu̠ bho̠. Ya̠a̠ onon ka̠ a̠nyen wa̠ ami̠ na̠ amu̠gho̠n i̠di̠ar i̠nye̠n na̠ a̠gboloma̠ bho̠?” Sa̠ i̠na a̠wia̠n ibom o̠bi̠gh A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Igiel bho̠ ogbo ogir ta̠ A̠zizo̠s imula̠ iru bho̠, sa̠ awa i̠gba inigha̠ i̠na ma̠ agu̠o̠ awa ibhin irile d̠a̠ e̠gi̠ bho̠. Sa̠ i̠na a̠bhin awa ab̠o̠i̠ny ad̠u̠a agi̠ d̠a̠ aka e̠ma Abe̠tsai̠da. ");
INSERT INTO mgj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ya̠a̠ igiel bho̠ o̠lo̠gh a̠nwunom bho̠ iloghom agba wa̠ awa iten bho̠, sa̠ i̠tu̠ ma̠ e̠b̠a i̠gi̠ ani̠ ma̠ esi bho̠. Sa̠ i̠na ada awa a̠bhin, agba ma̠ ya̠ igboloma̠ ma̠ irileghom ta̠ A̠zib̠a̠ a̠nigha̠ awa, sa̠ a̠koko ma̠ ogbo ya̠ na̠ e̠bho̠ro̠ghan a̠li̠kokua̠n. ");
INSERT INTO mgj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","D̠a̠ obhel ola̠ na̠ a̠tua̠n a̠dule, sa̠ d̠iobh na̠ i̠wal ogbo ogir d̠o̠yo̠ i̠gi̠ ka̠ i̠te̠i̠ i̠na, sa̠ ifugh inigha̠ i̠na ma̠a̠ “Gba ma̠ a̠nigha̠ ma̠ a̠nwunom bho̠ eten e̠gi̠ d̠a̠ re̠ma na̠ a̠risi ya̠ od̠i d̠a̠ eghighira̠ bho̠, b̠o̠ka̠ awa e̠bho̠ro̠gh e̠te̠i̠ ed̠ia̠n na̠ a̠risi ya̠ okod̠u. Ezin bho̠ onon esi ola̠ a̠nwunom orugh d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ya̠a̠ i̠na awo̠ran awa ma̠a̠, “Inigha̠ awa ma̠ abar od̠e.” Sa̠ awa i̠wo̠ran ma̠a̠, “I̠yar unwuna̠ ogho ikpokpogh abe̠re̠di̠ na̠ i̠wal ikpo ina̠ ku̠ku̠m; a̠ten ka̠ i̠yar ta̠ o̠gi̠ ka̠ ogho ma̠ ed̠ia̠n ya̠ ta̠ elei eb̠la̠ o̠lo̠gh a̠nwunom i̠nye̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(O̠lo̠gh a̠nwunom bho̠ ta̠ elei agu̠o̠ d̠iobh na̠ i̠wal o̠ni̠r na̠ ogho e̠wala (5,000) i̠ro̠.) Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Gba ma̠ awa e̠ro̠ ma̠ a̠dila̠de ebu ebu; ebu i̠se̠ eruba̠l na̠ d̠iobh o̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sa̠ ogbo atu̠ghan bho̠ igir agu̠o̠ i̠na ato̠ bho̠, sa̠ eb̠la̠ a̠nwunom bho̠ i̠ro̠ ma̠ a̠dila̠de. ");
INSERT INTO mgj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","I̠na a̠bhin ogho ikpokpogh abe̠re̠di̠ bho̠ na̠ i̠wal ikpo ina̠ bho̠, sa̠ a̠b̠eka̠ a̠kpon ote̠nai̠ny, sa̠ a̠tutumeni ma̠ ed̠ia̠n bho̠. Sa̠ i̠na a̠pupugion a̠nigha̠ ma̠ ogbo atu̠ghan bho̠ ma̠ o̠ru̠gi̠ onigha̠ a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eb̠la̠ awa id̠e ilegha̠n sa̠ idi ed̠ia̠n bho̠ isugho. Sa̠ ogbo atu̠ghan d̠o̠yo̠ ikpokpo ma̠ i̠pe̠re̠pe̠r ya̠ imuzo ma̠ d̠iobh na̠ i̠wal a̠rukpuom. ");
INSERT INTO mgj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Odi a̠d̠a̠ma̠ aro̠ ma̠ ola̠ A̠zizo̠s aro̠ ma̠ esi na̠ a̠siseiny, sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠gi̠ ka̠ i̠te̠i̠ i̠na. Sa̠ i̠na a̠pura̠n awa ma̠a̠, “A̠nwunom na̠ e̠gba ma̠ ami̠ ka̠ a̠nyen?” ");
INSERT INTO mgj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “Idi ogbo na̠ e̠gba ma̠ anwa Azo̠n owurmamu̠m bho̠; idi sa̠ na̠ e̠gba ma̠ anwa I̠lai̠za; ya̠a̠ ipa̠n sa̠ na̠ e̠gba ma̠ odi owil igied̠i a̠b̠etina̠ d̠a̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin u̠bi̠gh ani̠ eka̠. Inyin na̠ o̠gba ma̠ ami̠ ka̠ a̠nyen?” Sa̠ A̠pita̠ awo̠ran i̠na ma̠a̠, “Anwa Akrai̠st wa̠ A̠zib̠a̠ afi̠ri̠ma bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sa̠ A̠zizo̠s anyagh ra̠to d̠awa ma̠ awa o̠gba d̠o̠ ma̠ abar onon enigha̠ ma̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sa̠ i̠na a̠fugh ma̠a̠, “Na̠ o̠to̠ oguri ma̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ abi̠gh a̠d̠izo ali̠gam a̠ruzu, sa̠ ikei bho̠ na̠ aru̠li̠la bho̠, na̠ ogbo aru̠mu̠ rokur bho̠, na̠ ogbo-atu̠ghu̠me̠ni̠ oloko bho̠, ta̠ eghel i̠na, sa̠ ta̠ egigh i̠na. Sa̠, oleghemeni i̠sar a̠d̠a̠ma̠ bho̠ sa̠ i̠na ta̠ a̠b̠etina̠ d̠a̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sa̠ i̠na agba a̠nigha̠ ma̠ eb̠la̠ awa ma̠a̠, “O̠ni̠ ola̠ na̠ ebhir o̠tu̠o̠no̠m ami̠, o̠ni̠ bho̠ ta̠ a̠d̠ia̠ a̠gineni ma̠ ozu d̠o̠yo̠ ma̠ i̠di̠ar, a̠b̠eton e̠mi̠gi̠re̠ni̠an oriren d̠o̠yo̠ ka̠ a̠d̠a̠ma̠ ka̠ a̠d̠a̠ma̠ atu̠o̠no̠m ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","O̠ni̠ ola̠ na̠ abho̠ro̠gh otenemeni a̠ghud̠um d̠o̠yo̠, ko o̠te̠i̠ d̠o̠ ma̠ a̠ghud̠um kid̠ud̠ul. Ya̠a̠, ka̠ i̠na atu̠n ami̠ a̠robh a̠ghud̠um d̠o̠yo̠, i̠na ta̠ ate̠i̠ a̠ghud̠um kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ere ma̠ asu̠o̠ bho̠, ka̠ o̠ni̠ ate̠i̠ eb̠la̠ e̠mara̠nwunom, sa̠ a̠robh a̠ghud̠um d̠o̠yo̠ a̠dinom? ");
INSERT INTO mgj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ko̠ni̠ko̠ni̠ ola̠ a̠din ami̠ na̠ o̠nu̠o̠kpe̠ d̠ami̠ a̠ghil ari̠ghe̠l, O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠d̠igh ari̠ghe̠l a̠gboloma̠ ma̠ o̠ni̠ obha̠, ma̠ igiel i̠na ta̠ a̠mula̠ a̠ru d̠a̠ isosorogia̠n d̠o̠yo̠, na̠ ita̠ O̠we̠de̠ bho̠ na̠ ita̠ itileduom e̠b̠ab̠ala d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ya̠gia̠ga̠i, idi inyin ya̠ i̠mara ma̠ i̠se̠n bho̠, ko omugh d̠o̠ tu̠tu̠n awa ta̠ e̠bi̠gh irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","D̠a̠ a̠bin o̠bhabhanya a̠d̠a̠ma̠, sa̠ A̠zizo̠s a̠bhin A̠pita̠ na̠ A̠zemsi̠ na̠ Azo̠n asi̠n igu ka̠ a̠d̠igh a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Igiel bho̠ i̠na na̠ a̠siseiny bho̠, sa̠ a̠misigh d̠o̠yo̠ a̠nwegia̠n, sa̠ ibura̠ d̠o̠yo̠ i̠mu̠ isosorogia̠n e̠b̠alab̠al. ");
INSERT INTO mgj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sa̠ i̠wal a̠nwunom, A̠mozizi na̠ I̠lai̠za imite ma̠ awai̠ id̠igh na̠ i̠na i̠b̠e̠re̠gi̠an. ");
INSERT INTO mgj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","A̠mozizi na̠ I̠lai̠za esosorogia̠n o̠bi̠gh, sa̠ i̠b̠e̠re̠gi̠an igboloma̠ ma̠ agu̠o̠ A̠zizo̠s ta̠ a̠bhin a̠muzoghod̠iom i̠to̠ ta̠ A̠zib̠a̠ d̠a̠ A̠zeruse̠le̠m ma̠ obhel ola̠ ko obia̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Adi̠la ibhinom A̠pita̠ na̠ i̠wal ogbo-ogir iyed̠i ma̠ igiel bho̠; ya̠a̠, igiel bho̠ awa i̠su̠ma iloghoma̠n ozu bho̠, sa̠ awa i̠bi̠gh isosorogia̠n ta̠ A̠zizo̠s, sa̠ i̠bi̠gh ma̠ i̠wal a̠nwunom na̠ ed̠igh na̠ i̠na e̠mara. ");
INSERT INTO mgj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Igiel bho̠ A̠mozizi na̠ I̠lai̠za ib̠etina̠ na̠ e̠d̠u̠a bho̠, sa̠ A̠pita̠ a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “E Wa̠nwuna̠, ya̠ a̠bhon i̠yar o̠ro̠ i̠se̠n! D̠ighi i̠yar ta̠ ogim i̠sar a̠rutu akpu̠ru̠; odi ta̠ aro̠ ma̠ ola̠ oyom, odi ta̠ aro̠ ma̠ ola̠ A̠mozizi, sa̠ odi ta̠ aro̠ ma̠ ola̠ I̠lai̠za.” (I̠na na̠ o̠da d̠o̠ a̠loghom abar wa̠ i̠na a̠fugh bho̠ nyen.) ");
INSERT INTO mgj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","I̠na od̠id̠ia̠ na̠ a̠fugh sa̠ o̠b̠u̠ghu̠b̠u̠gh a̠mite a̠kpegiom eb̠la̠ awa; sa̠ a̠rugugu isibh A̠pita̠, A̠zemsi̠ na̠ Azo̠n d̠a̠ ebula̠ agu̠o̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ a̠kpegiom awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sa̠ okoroko a̠si a̠mite d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ ma̠a̠, “Onon O̠nyi̠ d̠ami̠, wa̠ Ami̠ na̠ aso̠n bho̠. I̠nagha i̠na!” ");
INSERT INTO mgj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Igiel bho̠ okoroko bho̠ na̠ a̠fugh awe̠le̠ bho̠, sa̠ awa i̠bi̠gh ma̠ A̠zizo̠s ku̠ku̠m a̠sughonom esi bho̠. Ogbo-ogir bho̠ iguri ma̠ i̠di̠ar ya̠ awa i̠bi̠gh bho̠ d̠a̠ rologi d̠awa; bebina̠ o̠ni̠ ola̠ awa i̠gba inigha̠ na̠ o̠ro̠ d̠o̠ d̠a̠ obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","I̠b̠ala bho̠ sa̠ awa isor d̠a̠ igu bho̠, sa̠ obom o̠lo̠gh a̠nwunom i̠gi̠ ka̠ i̠te̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sa̠ odi o̠ni̠ aro̠ d̠a̠ ologi o̠lo̠gh a̠nwunom bho̠ a̠kele i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠! Siseiny, kpone ma̠ ogini o̠nyi̠ d̠ami̠ ma̠ igbirigbir. ");
INSERT INTO mgj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","O̠karabh e̠mu̠gh na̠ a̠puom gha̠n i̠na, sa̠ i̠na ta̠ a̠kpogion na̠ a̠mulughu ma̠ izul. Sa̠ i̠na na̠ asalaghu̠ na̠ a̠mutioghom ofuko d̠a̠ o̠nu̠ d̠o̠yo̠. Na̠ a̠guri gha̠n na̠ a̠gbikimeni i̠na ma̠ o̠ku̠a na̠ alo̠gi̠ i̠na ma̠ i̠ne̠m, sa̠ na̠ o̠nu̠r ghan d̠o̠ ma̠ o̠we̠le̠man o̠yo̠ ma̠ agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ami̠ i̠le̠gh ogbo atu̠ghan d̠oyom ma̠ oze o̠karabh e̠mu̠gh bho̠ o̠si̠ghe̠, ya̠a̠ irue d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “E! Amu̠m ologi ima̠ra̠ o̠to̠, ya̠ ogir d̠o̠ ma̠ iya̠ i̠kpe̠! Ami̠ ta̠ a̠d̠igh na̠ inyin aro̠ a̠bia̠ eka̠? Ami̠ ta̠ a̠ne ma̠ ado̠l d̠inyin a̠bia̠ eka̠?” Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ bho̠ ma̠a̠, “Bhine ma̠ o̠nyi̠ d̠oyom a̠ru ma̠ enen.” ");
INSERT INTO mgj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Igiel bho̠ o̠nyi̠ bho̠ na̠ a̠rile na̠ a̠ru bho̠, sa̠ o̠karabh e̠mu̠gh bho̠ agu̠ro̠m i̠na, sa̠ o̠nyi̠ bho̠ asasalaghu̠ a̠mutiom ofuko d̠a̠ o̠nu̠. Ya̠a̠ A̠zizo̠s ab̠ab̠agi̠na ma̠ o̠karabh e̠mu̠gh bho̠, sa̠ a̠koko ma̠ o̠nyi̠ bho̠, sa̠ a̠mulumeni i̠na a̠nigha̠ ma̠ o̠we̠de̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sa̠ a̠d̠igh eb̠la̠ a̠nwunom bho̠ ma̠ ilologia̠n o̠bi̠gh ibom e̠mi̠ a̠limon ta̠ A̠zib̠a̠. Ya̠a̠, igiel bho̠ eb̠la̠ awa od̠id̠ia̠ na̠ ema̠gha̠, na̠ e̠ru̠ru̠an na̠ egboloma̠ ma̠ eb̠la̠ ogir ta̠ A̠zizo̠s bho̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“I̠mare̠ ma̠ e̠nagha ma̠ i̠di̠ar ya̠ ami̠ na̠ a̠ru ro̠ o̠gba a̠nigha̠ inyin bho̠, ma̠ e̠kpabh e̠bham: ta̠ owol O̠nyi̠ ta̠ O̠ni̠ o̠lo̠gh d̠a̠ agu̠o̠ a̠nwunom.” ");
INSERT INTO mgj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ya̠a̠, awa i̠mu̠gho̠nyan d̠o̠ ma̠ abar wa̠ i̠na agba bho̠. U̠wo̠gi̠o̠m awa, sa̠ awa o̠mu̠gho̠nyan d̠o̠, ya̠a̠ awa ighil opura̠n o̠yo̠ ma̠ ezin bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sa̠ aku̠anan a̠sor d̠a̠ esa̠d̠io d̠awa, ma̠ o̠ni̠ wa̠ abu̠gh a̠pu d̠a̠ o̠lo̠gh d̠awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ya̠a̠ A̠zizo̠s a̠loghom i̠ru̠ru̠an d̠awa, sa̠ a̠bhin o̠gbara o̠nyi̠ amarame̠ni̠ d̠a̠ aka d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Sa̠ agba a̠nigha̠ awa ma̠a̠, “O̠ni̠ ola̠ atu̠n a̠d̠ien d̠ami̠ ada ma̠ o̠gbara o̠nyi̠ onon a̠bhin, bha̠ ada ami̠ a̠bhin. O̠ni̠ ola̠ o̠ku̠a ab̠aram na̠ i̠na o̠ni̠ wa̠ a̠ruom ami̠ ma̠ oru bho̠ ada a̠bhin. O̠ni̠ wa̠ aki̠ri̠me̠ni̠ ma̠ ozu a̠pu d̠a̠ esa̠d̠io d̠inyin bho̠, abu̠gh a̠pu.” ");
INSERT INTO mgj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sa̠ Azo̠n agba a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “Wa̠nwuna̠, i̠yar u̠bi̠gh odi o̠ni̠ ola̠ a̠bhin a̠d̠ien d̠oyom na̠ a̠ze ma̠ i̠karabh aru̠mu̠gh sa̠ i̠yar u̠ghaghana i̠na, ezin bho̠ i̠na bo̠ ani̠ d̠o̠ d̠a̠ o̠lo̠gh d̠i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “O̠ni̠ ko o̠ghaghana i̠na; ezin bho̠ o̠ni̠ ola̠ owia̠n d̠o̠ inyin od̠i na̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Igiel bho̠ na̠ a̠tua̠n A̠zizo̠s obhun d̠a̠ ote̠nai̠ny bho̠, sa̠ i̠na ato̠ d̠a̠ ologi d̠o̠yo̠ ma̠ o̠gi̠ d̠a̠ A̠zeruse̠le̠m. ");
INSERT INTO mgj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa̠ i̠na a̠ruom a̠nwunom od̠ia̠ o̠gi̠ d̠a̠ odi e̠ma Asameria̠, okokod̠ia̠n ob̠a̠ra̠ o̠yo̠; ");
INSERT INTO mgj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ya̠a̠ a̠nwunom e̠ma bho̠ i̠da d̠o̠ ma̠ A̠zizo̠s ebhin, ezin bho̠ i̠na na̠ ada na̠ agi̠ d̠a̠ A̠zeruse̠le̠m be̠le̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Igiel bho̠ ogbo atu̠ghan d̠o̠yo̠, A̠zemsi na̠ Azo̠n i̠bi̠gh o̠ku̠a bho̠, sa̠ awa ipura̠n A̠zizo̠s ma̠a̠, “Wa̠nwuna̠, i̠yar okele ma̠ anya ad̠u̠a d̠a̠ ote̠nai̠ny a̠sor abhu̠gi̠ awa ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ya̠a̠ A̠zizo̠s a̠tiba̠ra̠ agamam awa. (Inyin uloghom d̠o̠ ma̠ a̠d̠ien e̠mu̠gh wa̠ inyin u̠te̠i̠ bho̠. O̠nyi̠ ta̠ O̠ni̠ na̠ oru d̠o̠ ma̠ o̠ze̠ a̠nwunom; ya̠a̠ i̠na atu̠n otenemeni a̠nwunom a̠ru). ");
INSERT INTO mgj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sa̠ awa iten i̠gi̠ d̠a̠ opa̠n o̠gbara e̠ma. ");
INSERT INTO mgj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Igiel bho̠ awa na̠ erile d̠a̠ eten na̠ e̠gi̠ bho̠, sa̠ odi o̠ni̠ a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “Ami̠ ta̠ atu̠o̠no̠m anwa agi̠ kesikesi ola̠ anwa na̠ agi̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Rududu enwuna̠ ma̠ iyol ya̠ awa na̠ erugh, i̠nu̠r eka̠ enwuna̠ ma̠ a̠rutu; ya̠a̠ O̠nyi̠ ta̠ O̠ni̠ na̠ onwuna̠ d̠o̠ ma̠ esi ola̠ od̠igh ob̠enegiom e̠mu̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ opa̠n o̠ni̠ ma̠a̠, “Tu̠o̠no̠me̠ ami̠.” Ya̠a̠ o̠ni̠ bho̠ awo̠ran ma̠a̠, “Wa̠nwuna̠, d̠ighi ami̠ id̠ia̠ i̠gi̠ ka̠ id̠i ma̠ o̠we̠de̠ d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “We̠le̠mane̠ ma̠ a̠nwunom ya̠ na̠ e̠mu̠gh bho̠ ma̠ od̠i imumugh d̠awa. Ya̠a̠, anwa gi̠e̠ ka̠ agba ma̠ ib̠eb̠i asu̠gbagba irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sa̠ opa̠n o̠ni̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, ami̠ ta̠ atu̠o̠no̠m anwa, ya̠a̠ d̠ighi ami̠ ta̠ a̠d̠ia̠ agi̠ ka̠ a̠fugh a̠nigha̠ ma̠ eghun otu d̠ami̠ ma̠a̠ awa e̠mar e̠ro̠.” ");
INSERT INTO mgj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ya̠a̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “O̠ni̠ ola̠ a̠sibh e̠su̠a ola̠ u̠kpu̠o̠m d̠a̠ i̠nam na̠ ob̠u ma̠ a̠de, sa̠ a̠tiba̠ra̠ a̠kpon d̠a̠ aman, na̠ o̠kpe̠ d̠o̠ ma̠ ogir ogir irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","O̠tu̠o̠no̠m i̠se̠, sa̠ Wa̠nwuna̠ bho̠ aso̠n ipa̠n e̠rabharabh na̠ d̠iobh na̠ i̠wal ogbo atu̠ghan d̠o̠yo̠, sa̠ ato̠to̠gi̠ awa, ma̠ i̠wal o̠ni̠ ma̠ ebu, ma̠ o̠gi̠ d̠a̠ re̠ma na̠ a̠risi ya̠ i̠na na̠ ato̠ ma̠ o̠gi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Ed̠ia̠n ob̠u eb̠uiy, ya̠a̠, ogbo od̠ighi bho̠ e̠ki̠r; ebula̠ o̠ku̠a, isiseinye ma̠ Wa̠nwuna̠ ib̠ua̠ bho̠ ma̠ i̠na a̠ruom ogbo od̠ighi a̠d̠ighom d̠a̠ o̠si̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","I̠gi̠e̠! Ami̠ na̠ a̠ruom inyin agu̠o̠ ro̠nana d̠a̠ esa̠d̠io o̠lo̠gh i̠gagaman i̠nam. ");
INSERT INTO mgj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","O̠ni̠ ko obhin e̠kpa ola̠ ikpoki, bo̠d̠o̠ e̠kpa e̠gi̠, bo̠d̠o̠ ragbaka. O̠ni̠ ko obhelegima̠ ma̠ o̠ni̠ d̠a̠ eten nyen. ");
INSERT INTO mgj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kotukotu ola̠ inyin ud̠igh id̠ia̠ ma̠ efugh ma̠a̠, ‘Ekima̠ aro̠ a̠nigha̠ ma̠ otu onon!’ ");
INSERT INTO mgj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ya̠a̠, ka̠ o̠ni̠ ekima̠ od̠i d̠a̠ otu bho̠, sa̠ ekima̠ d̠inyin ta̠ e̠ro̠ na̠ awa. Ya̠a̠ o̠ku̠a bo̠, ekima̠ d̠inyin ta̠ e̠ro̠ na̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka̠ inyin ud̠igh d̠a̠ e̠ma, o̠ni̠ o̠d̠u̠a ma̠ otu ma̠ eten otu. I̠ri̠la d̠a̠ onin otu bho̠. Id̠e ma̠ ed̠ia̠n, ma̠ e̠d̠a ma̠ amu̠m ya̠ awa ta̠ enigha̠ inyin bho̠. Ezin bho̠, o̠ni̠ ogir bho̠ a̠sora̠n o̠te̠i̠ alu̠kpe̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ka̠ inyin ud̠i̠gh d̠a̠ e̠ma i̠se̠, sa̠ awa i̠da inyin ibhin, id̠e ma̠ ed̠ia̠n ya̠ awa ta̠ enigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ikoko ma̠ ogbo ya̠ na̠ e̠nwe̠r bho̠, ma̠ e̠gba ma̠ enigha̠ awa ma̠a̠, ‘Irileghom ta̠ A̠zib̠a̠, od̠i d̠a̠ e̠b̠ab̠a agu̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka̠ inyin ud̠igh d̠a̠ e̠ma, sa̠ o̠da d̠o̠ inyin ebhin, bha̠ i̠gi̠e̠ ka̠ e̠ro̠ d̠a̠ reten ma̠ e̠gba ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ibhugh a̠de e̠ma d̠inyin ya̠ i̠kpabh d̠a̠ a̠sike d̠i̠yar bho̠ eka̠, i̠yar na̠ okpukpu osoroni onigha̠ inyin. Obha̠ elegh ola̠ ta̠ a̠leriom ma̠ A̠zib̠a̠ ta̠ a̠sobh ase̠ a̠bhumeni inyin. Ya̠a̠ iloghome ma̠ irileghom ta̠ A̠zib̠a̠ na̠ a̠tua̠n.’ ");
INSERT INTO mgj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ami̠ na̠ amar na̠ agba na̠ a̠nigha̠ inyin ma̠ d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, ma̠ A̠zib̠a̠ ta̠ a̠leriom okpon igbirigbir Aso̠do̠m a̠pu ma̠ a̠nwunom e̠ma obha̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Itogi e̠ro̠ enigha̠ ma̠ anwa, A̠kora̠zin! Itogi e̠ro̠ enigha̠ ma̠ anwa, Abe̠tsai̠da! Ezin bho̠, ilologia̠n ya̠ ugir unigha̠ inyin bho̠ ma̠ ugir onigha̠ ma̠ Ataya na̠ Asi̠do̠n nab̠o̠, awa na̠ etiba̠ra̠ ka̠ obom igiel, sa̠ awa ka̠ izum e̠ro̠ na̠ akapa i̠ku̠nu̠ na̠ i̠ru̠ru̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Okpon igbirigbir ta̠ e̠ro̠ enigha̠ ma̠ Ataya na̠ Asi̠do̠n epu inyin d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya̠a̠, inyin a̠nwunom Akapanu̠m, ta̠ obhuneni inyin d̠a̠ ote̠nai̠ny ke̠re̠? E̠nyi̠, ta̠ orobh inyin osoroni d̠a̠ imumugh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan do̠yo̠ ma̠a̠, “O̠ni̠ ola̠ ada ma̠ a̠duom d̠inyin a̠bhin ada ami̠ a̠bhin. Ya̠a̠, o̠ni̠ ola̠ a̠ghel inyin a̠ghel ami̠. O̠ku̠a a̠ma̠ra̠ ma̠ o̠ni̠ ola̠ a̠ghel ami̠ ab̠aram na̠ A̠zib̠a̠ wa̠ a̠ruom ami̠ ma̠ a̠duom bho̠ a̠ghel.” ");
INSERT INTO mgj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","E̠rabharabh na̠ d̠iobh na̠ i̠wal ogbo ya̠ i̠na aso̠n bho̠ imula̠ iru na̠ a̠libhon ologi sa̠ i̠gba ma̠a̠, “Wa̠nwuna̠, i̠karabh aru̠mu̠gh eka̠ ezuruna̠ ma̠ eghoi enigha̠ i̠yar d̠a̠ a̠d̠ien d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sa̠ i̠na awo̠ran awa ma̠a̠, “Yii, ami̠ i̠bi̠gh ka̠ Eru bho̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠mel a̠sor, ka̠ i̠me̠me̠gi̠na agbararan. ");
INSERT INTO mgj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ikpone! Ami̠ na̠ a̠ni̠gha̠ inyin a̠limon ya̠ obhin o̠ze̠re̠gi̠ i̠karabh-i̠di̠ar na̠ id̠ekebi, na̠ a̠limon ya̠ i̠kpo̠luzu ipel eb̠la̠ a̠li̠mon ta̠ Eru; bebina̠ abar ola̠ ta̠ a̠d̠ighi ma̠ ola̠ inyin ta̠ od̠ighia̠nma̠ bo̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na̠ aro̠ ma̠ o̠ku̠a bho̠ eka̠, o̠ni̠ ko obhon ologi d̠a̠ ebula̠ agu̠o̠ a̠ruru bho̠ na̠ ezuruna̠ ma̠ eghoi na̠ enigha̠ inyin bho̠, ya̠a̠ ibhone ma̠ ologi ma̠ na̠ o̠ge̠ ma̠ a̠rid̠ien d̠inyin d̠a̠ ote̠nai̠ny.” ");
INSERT INTO mgj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","D̠a̠ onin obhel obha̠, sa̠ A̠zizo̠s a̠muzo na̠ a̠li̠bhon ologi ta̠ E̠mu̠gh E̠tu̠tu̠ bho̠, sa̠ i̠na a̠fugh ma̠a̠, “Ami̠ na̠ ase̠bh anwa O̠we̠de̠ Wa̠nwuna̠ ma̠ ote̠nai̠ny na̠ a̠de ma̠ agu̠o̠ anwa i̠wo̠gi̠o̠m i̠di̠ar i̠nye̠n iloghom ma̠ i̠di̠ar sekina̠ iloghom ma̠ a̠d̠ire bho̠, ya̠a̠ anwa ileriom ka̠ ma̠ i̠gbara anwi̠i̠ny i̠nye̠n. Yii, o̠we̠de̠, a̠d̠igh anwa ma̠ ologi ma̠ ogir o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“O̠we̠de̠ d̠ami̠ na̠ a̠nigha̠ ami̠ ma̠ eb̠la̠ i̠di̠ar. Ya̠a̠ o̠ni̠ ola̠ a̠loghom O̠nyi̠ bho̠ bo̠, a̠ten O̠we̠de̠ bho̠, sa̠ o̠ni̠ ola̠ a̠loghom O̠we̠de̠ bho̠ o̠ro̠ d̠o̠ a̠ten O̠nyi̠ bho̠ na̠ a̠nwunom ya̠ O̠nyi̠ bho̠ aso̠n oleriom o̠yo̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sa̠ A̠zizo̠s a̠tiba̠ra̠ a̠kpon ogbo atu̠ghan bho̠, sa̠ agba a̠nigha̠ awa d̠a̠ e̠wo̠gi̠na ma̠a̠, “Itutumeni e̠ro̠ enigha̠ ma̠ a̠rid̠ien ya̠ na̠ e̠bi̠gh i̠di̠ar ya̠ inyin na̠ o̠bi̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠ ebhir a̠d̠izo a̠riwil na̠ aru̠li̠le̠ma ma̠ o̠bi̠gh i̠di̠ar ya̠ inyin na̠ o̠bi̠gh bho̠ ya̠a̠ i̠bi̠gh d̠o̠, na̠ o̠mu̠gho̠n i̠di̠ar ya̠ inyin na̠ o̠mu̠gho̠n bho̠ ya̠a̠ i̠mu̠gho̠n d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Odi a̠d̠a̠ma̠ odi o̠ni̠ ola̠ na̠ aku̠ro̠m d̠a̠ oloko bho̠ a̠b̠etina̠ ad̠a ma̠ A̠zizo̠s a̠kpon. Sa̠ a̠pura̠n i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, ami̠ ta̠ a̠d̠ighi eka̠ ate̠i̠ a̠ghud̠um kid̠ud̠ul?” ");
INSERT INTO mgj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “U̠ge̠ ma̠ ere d̠a̠ a̠d̠ire oloko bho̠? Anwa isen i̠mu̠gho̠nyan eka̠?” ");
INSERT INTO mgj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sa̠ i̠na awo̠ran ma̠a̠, “Anwa ta̠ a̠bhin eb̠la̠ ologi d̠oyom, na̠ eb̠la̠ e̠mu̠gh d̠oyom, na̠ eb̠la̠ a̠limon d̠oyom, na̠ eb̠la̠ i̠ru̠ru̠an d̠oyom a̠tula̠n Wa̠nwuna̠ A̠zib̠a̠ d̠oyom; sa̠ anwa ta̠ a̠tula̠n i̠na o̠ni̠ wa̠ od̠i d̠a̠ aka d̠oyom bho̠ ma̠ agu̠o̠ ozu d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Anwa̠ amar awo̠ran. Gire ma̠ o̠ku̠a sa̠ anwa ta̠ a̠d̠um.” ");
INSERT INTO mgj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","D̠a̠ agu̠o̠ i̠na na̠ abho̠ro̠gh oleriom ma̠ i̠na ab̠ab̠ala bho̠, sa̠ i̠na a̠pura̠n A̠zizo̠s ma̠a̠, “A̠nyen o̠ni̠ wa̠ d̠a̠ aka d̠a̠ ami̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A̠zizo̠s a̠mulumeni agba a̠nigha̠ i̠na ma̠a̠, “O̠ni̠ ad̠u̠a d̠a̠ A̠zeruse̠le̠m na̠ a̠sor na̠ agi̠ d̠a̠ Aze̠riko. Sa̠ i̠na a̠mel a̠d̠igh d̠a̠ agu̠o̠ i̠bi̠gh ma̠ a̠b̠igh. Sa̠ i̠fo̠i̠ny i̠na i̠ke̠gi̠o̠n ibura̠ d̠o̠yo̠, id̠ul i̠na i̠fu̠me̠ni̠, sa̠ iten i̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A̠mite ma̠ ola̠ odi okur ta̠ A̠zib̠a̠ awo̠l ani̠ d̠a̠ onin eten bho̠. Ya̠a̠ igiel bho̠ i̠na abi̠gh o̠ni̠ bho̠, sa̠ i̠na ab̠e̠i̠ eten bho̠ agbal ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Onin agu̠o̠ bho̠, sa̠ o̠nyi̠ eghun ta̠ A̠livai̠, o̠lo̠ghmagu̠o̠ d̠a̠ Otu-a̠siseiny bho̠, a̠ru ra̠ abi̠gh i̠na, sa̠ i̠na ab̠e̠i̠ eten bho̠ agbal ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ya̠a̠ o̠ni̠ Asameria̠ na̠ a̠ten d̠a̠ eten bho̠ sa̠ abi̠gh i̠na, sa̠ igbirigbir o̠ni̠ bho̠ isibh i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I̠na agi̠ ka̠ ate̠i̠ o̠ni̠ bho̠ sa̠ i̠na a̠bhin amu̠nu̠ na̠ a̠min a̠zuom i̠ne̠m bho̠, sa̠ a̠bhin ukpe a̠bhurugi ma̠ i̠ne̠m o̠ni̠ bho̠. Sa̠ a̠bhin i̠na agbam d̠a̠ anyu̠ e̠nam d̠o̠yo̠ wa̠ i̠na na̠ a̠d̠igh gha̠n na̠ a̠rile bho̠, sa̠ a̠bhin i̠na agi̠ ka̠ a̠d̠ighom d̠a̠ otu-esul, sa̠ a̠kponom i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","I̠b̠ala bho̠ sa̠ i̠na a̠mutiom i̠wal adi̠nari̠ a̠nigha̠ ma̠ okponom ma̠ otu-esul bho̠. Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ okponom ma̠ otu-esul bho̠ ma̠a̠, ‘Kponome ma̠ o̠ni̠ onon a̠nigha̠ ami̠. Ami̠ na̠ agi̠ na̠ a̠ru. Ka̠ anwa irughom ipa̠n ikpoki i̠b̠aram, ami̠ ta̠ a̠mulumeni ma̠ anwa.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “D̠a̠ i̠sar a̠nwunom bho̠, ka̠ a̠nyen o̠ni̠ wa̠ a̠leriom ma̠a̠, o̠ni̠ wa̠ a̠mel a̠d̠igh d̠a̠ agu̠o̠ ib̠igh ma̠ a̠b̠igh bho̠, ma̠a̠ o̠ni̠ aka d̠o̠yo̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sa̠ o̠ni̠ wa̠ aku̠ro̠m d̠a̠ oloko bho̠ awo̠ran ma̠a̠, “I̠na wa̠ a̠kpon o̠ni̠ bho̠ ma̠ igbirigbir bho̠.” Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “Gi̠e̠ ka̠ a̠gir ani̠ ma̠ o̠ku̠a.” ");
INSERT INTO mgj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","D̠a̠ erile ta̠ A̠zizo̠s na̠ ogbo atu̠ghan d̠o̠yo̠, sa̠ i̠te̠i̠ odi e̠ma ola̠ odi ani̠ ola̠ ubhelegi ma̠ Amata ada awa a̠bhin a̠d̠ighom d̠a̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I̠na a̠nwuna̠ ma̠ u̠marani̠ ola̠ ubhelegi ma̠ A̠meri, ola̠ aro̠ ma̠ a̠dila̠de d̠a̠ aka ta̠ Wa̠nwuna̠ bho̠ na̠ anagha ma̠ i̠di̠ar ya̠ i̠na na̠ atu̠ghu̠me̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ya̠a̠ a̠d̠izo rogir i̠ki̠o̠m bho̠ na̠ e̠vi̠mo̠m Amata. Sa̠ Amata agi̠ ka̠ ate̠i̠ i̠na sa̠ a̠fugh ma̠a̠, “Wa̠nwuna̠, a̠bhon agu̠o̠ u̠marani̠ d̠ami̠ awe̠le̠man eb̠la̠ ogir i̠ki̠o̠m bho̠ a̠nigha̠ ami̠ bho̠ ke̠re̠? Gba ma̠ a̠nigha̠ i̠na a̠ru ra̠ alo̠gh agu̠o̠ a̠nigha̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sa̠ Wa̠nwuna̠ bho̠ awo̠ran i̠na ma̠a̠, “Amata, O Amata, anwa na̠ anyo̠gho̠ghan na̠ a̠gboloma̠ ma̠ a̠d̠izo i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Onin ob̠eb̠i abar ku̠ku̠m ola̠ akpe̠ ma̠ o̠nyo̠gho̠ghan ogboloma̠. A̠meri na̠ aso̠n abar bho̠ a̠bhin, o̠ni̠ ko orue d̠o̠ awo̠r i̠na a̠bhin.” ");
INSERT INTO mgj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Odi a̠d̠a̠ma̠, A̠zizo̠s na̠ a̠siseiny odi esi, sa̠ obhel bho̠ i̠na na̠ a̠siseiny awe̠le̠ bho̠, sa̠ odi o̠ni̠ atu̠ghan d̠o̠yo̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Wa̠nwuna̠, tu̠ghu̠me̠ni̠ i̠yar agu̠o̠ o̠sisieny a̠sisieny, ma̠ agu̠o̠ Azo̠n a̠tu̠ghu̠me̠ni̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Igiel inyin na̠ osiseiny, ifughe ma̠a̠: “ ‘O̠we̠de̠, a̠d̠ien d̠oyom aro̠ ma̠ ola̠ e̠tu̠tu̠. Irileghom d̠oyom eru. ");
INSERT INTO mgj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ed̠ia̠n ya̠ eb̠la̠ ra̠d̠a̠ma̠ bho̠, nigha̠ i̠yar ya̠ a̠didon. ");
INSERT INTO mgj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","We̠le̠mane̠ ma̠ i̠karabh d̠i̠yar, agu̠o̠ bho̠ i̠yar na̠ o̠we̠le̠man i̠karabh ya̠ ipa̠n ogbo na̠ ed̠ighi i̠yar bho̠. Ya̠a̠, ko oma̠ra̠ i̠yar omel d̠a̠ ad̠agi̠an.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sa̠ i̠na a̠fugh a̠nigha̠ a̠wa̠ ma̠a̠, “A̠nyen inyin ola̠ a̠nwuna̠ ma̠ a̠tologha̠n, sa̠ agi̠ d̠o̠yo̠ ma̠ egum a̠d̠io ka̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, ‘O̠mo̠lo̠l, wo̠lo̠ni̠ane̠ ami̠ ma̠ i̠sar ikpokpogh abe̠re̠di̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ezin bho̠, a̠tologha̠n olami̠ na̠ ad̠u̠a ma̠ e̠gi̠ a̠ru ra̠ a̠suloma̠ ami̠, ya̠a̠ ami̠ inwuna̠ d̠o̠ ma̠ abar ola̠ obhi̠n o̠ki̠o̠m o̠yo̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ku̠gba ma̠ i̠na wa̠ od̠i d̠a̠ ologi otu bho̠ awo̠ran ma̠a̠, ‘Ko onyegi ami̠, na̠ o̠du̠ ma̠ otu bho̠, anwi̠i̠ny d̠ami̠ na̠ ami̠ na̠ od̠igh o̠managhan. Ami̠ ko orue d̠o̠ a̠b̠etina̠ a̠ru ra̠ a̠nigha̠ nyam abar.’ ");
INSERT INTO mgj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠na ko o̠tu̠n d̠o̠ ma̠ awa ra̠tologha̠n be̠le̠ni̠ a̠nigha̠ i̠na; ya̠a̠, d̠a̠ agu̠o̠ bho̠ i̠na od̠igh d̠o̠ ma̠ ari̠ghe̠l sa̠ aro̠ ma̠ okpukpu okpukpu bho̠, i̠na ta̠ a̠b̠etina̠ ka̠ a̠nigha̠ i̠na kabar kabar ola̠ i̠na na̠ a̠puru. ");
INSERT INTO mgj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ebula̠ o̠ku̠a, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠: ipuru sa̠ ta̠ onigha̠ inyin, i̠bho̠ro̠ghane̠ sa̠ inyin ta̠ o̠bi̠gh, ikpukpu sa̠ ta̠ a̠guron. ");
INSERT INTO mgj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ezin bho̠, o̠ni̠ ola̠ a̠puru ta̠ onigha̠; ola̠ abho̠ro̠ghan ta̠ abi̠gh; ola̠ a̠kpukpu ta̠ oguron onigha̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“D̠a̠ esa̠d̠io d̠inyin, ka̠ oken o̠we̠de̠ ola̠ ka̠ o̠nyi̠ d̠o̠yo̠ a̠puru ma̠ ena̠ sa̠ ta̠ a̠nigha̠ ma̠ o̠karabh abar? ");
INSERT INTO mgj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bo̠d̠o̠, ka̠ a̠puru ma̠ aga e̠nu̠r, sa̠ ta̠ a̠nigha̠ ma̠ id̠ekebi? ");
INSERT INTO mgj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ku̠gba ma̠ inyin rod̠ighi ma̠ i̠karabh bho̠, ologhom agu̠o̠ onigha̠ ib̠eb̠i i̠di̠ar anwi̠i̠ny d̠inyin, a̠dina̠mu ma̠ O̠we̠de̠ d̠inyin wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠! I̠na ta̠ a̠nigha̠ inyin E̠mu̠gh E̠tu̠tu̠ bho̠ ka̠ inyin upuru i̠na.” ");
INSERT INTO mgj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Odi a̠d̠a̠ma̠, A̠zizo̠s a̠ze ma̠ o̠karabh e̠mu̠gh emua̠ asi̠ghe̠ d̠a̠ ozu odi o̠ni̠. Igiel bho̠ o̠karabh e̠mu̠gh bho̠ ad̠u̠a bho̠, sa̠ emua̠ o̠ni̠ bho̠ ake̠ ma̠ ofugh abar, sa̠ a̠d̠igh ilologia̠n o̠lo̠gh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ya̠a̠, idi awa d̠a̠ o̠lo̠gh bho̠ ifugh ma̠a̠, “I̠na na̠ a̠bhin a̠limon ta̠ Abe̠lzi̠bu̠l, we̠mu̠ a̠ruru na̠ i̠karabh aru̠mu̠gh, na̠ a̠ze ma̠ i̠karabh aru̠mu̠gh bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ya̠a̠, ipa̠n ogbo, d̠a̠ agu̠o̠ ola̠ o̠d̠a o̠yo̠ okpon, sa̠ i̠bho̠ro̠ghan i̠na ma̠ omutiom elegh ola̠ d̠a̠ ote̠nai̠ny oleriom awa. ");
INSERT INTO mgj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ya̠a̠ A̠zizo̠s a̠loghom rologi d̠awa, sa̠ a̠fugh a̠nigha̠ awa ma̠a̠, “Irileghom ola̠ aru̠gi̠an na̠ a̠wia̠n ozu d̠o̠yo̠ ta̠ ago̠gu̠an a̠mel. Onin agu̠o̠ bho̠, eghun ola̠ na̠ a̠wia̠n ozu ta̠ a̠mel. ");
INSERT INTO mgj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ku̠gba ma̠ Eru bho̠ na̠ a̠wia̠n ozu d̠o̠yo̠, ka̠ irileghom d̠o̠yo̠ ta̠ a̠d̠ighi eka̠ amara? Ezin bho̠, inyin na̠ o̠gba ma̠ ami̠ na̠ a̠bhin a̠limon ta̠ Abe̠lzi̠bu̠l na̠ a̠ze ma̠ a̠ruru. ");
INSERT INTO mgj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ku̠gba ma̠ ami̠ na̠ a̠bhin a̠limon ta̠ Abe̠lzi̠bu̠l na̠ a̠ze ma̠ a̠ruru, ka̠ anwi̠i̠ny d̠inyin na̠ e̠bhin ere na̠ eze na̠ e̠se̠ghe̠gi̠? O̠ku̠a a̠d̠ighi be̠le̠ni̠, awa ta̠ e̠ro̠ ma̠ ogbo osobh ase̠ d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ya̠a̠, ku̠gba ma̠ ami̠ na̠ a̠bhin a̠limon ta̠ A̠zib̠a̠ na̠ a̠ze ma̠ a̠ruru bho̠, bha̠ iloghome ma̠ irileghom ta̠ A̠zib̠a̠ na̠ a̠ru ra̠ ate̠i̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ku̠gba ma̠ omoma̠na̠n o̠ni̠ amar a̠kokod̠ia̠n o̠kpo̠ erorobhi d̠o̠yo̠, sa̠ a̠kponom otu d̠o̠yo̠; i̠di̠ar d̠o̠yo̠ ta̠ e̠ro̠ d̠a̠ ekima̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ya̠a̠, ku̠gba ma̠ o̠ni̠ ola̠ a̠mon a̠pu i̠na a̠wia̠n i̠na, sa̠ ane̠gi̠me̠ni̠ i̠na, o̠ni̠ bho̠ ta̠ a̠ghumi ma̠ eb̠la̠ o̠kpo̠ erorobhi d̠o̠yo̠ ya̠ i̠na a̠bhin a̠b̠em ologi bho̠ a̠bhin. Sa̠ i̠na ta̠ aru̠gi̠ ma̠ a̠nwunom eb̠la̠ i̠di̠ar ya̠ i̠na a̠ghumi bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“O̠ni̠ ola̠ o̠ri̠la d̠o̠ na̠ ami̠ bha̠ na̠ a̠wia̠n ami̠; ya̠a̠, o̠ni̠ ola̠ od̠igh d̠o̠ na̠ ami̠ a̠kokod̠i bha̠ na̠ asasaragi̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Igiel o̠karabh e̠mu̠gh ad̠u̠a d̠a̠ ozu o̠ni̠, ta̠ ad̠u̠a ma̠ esi a̠ten esi abho̠ro̠gh esi ola̠ a̠sora̠n od̠igh o̠ro̠. Ya̠a̠, ka̠ i̠na o̠bi̠gh d̠o̠ ma̠ esi o̠ro̠, sa̠ i̠na ta̠ a̠fugh ma̠a̠, ‘Ami̠ ta̠ a̠mula̠ agi̠ d̠a̠ otu wa̠ ami̠ i̠d̠u̠a bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Igiel i̠na a̠misi sa̠ abi̠gh ma̠ otu bho̠ na̠ o̠mar ogber o̠b̠ab̠alame̠ni̠, oselegi ma̠ i̠di̠ar, ");
INSERT INTO mgj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","sa̠ i̠na ta̠ ka̠ a̠bhin od̠ua̠l ipa̠n i̠karabh aru̠mu̠gh ya̠ i̠bho̠ru̠ ipu i̠na, sa̠ awa ta̠ ka̠ ed̠igh erugh d̠a̠ ozu o̠ni̠ bho̠. Sa̠ e̠do̠lo̠ghu̠ma o̠ni̠ bho̠ ta̠ a̠gurom a̠pu ma̠ agu̠o̠ aro̠ ma̠ o̠pu̠r igiel bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Igiel bho̠ A̠zizo̠s od̠id̠ia̠ na̠ agba ma̠ i̠di̠ar i̠nye̠n bho̠, sa̠ odi ani̠ d̠a̠ o̠lo̠gh bho̠, a̠b̠eton okoroko ma̠a̠, “Itutumeni e̠ro̠ enigha̠ ma̠ otu-i̠mara wa̠ a̠rol anwa bho̠ na̠ amu̠mam ya̠ anwa i̠mam bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sa̠ i̠na awo̠ran ma̠a̠, “Itutumeni ta̠ e̠ro̠ enigha̠ kuma̠ ogbo ya̠ i̠nagha ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ sa̠ igir o̠ku̠a bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Agu̠o̠ o̠lo̠gh bho̠ na̠ abu̠gh bho̠, sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Onon amu̠m rod̠ighi ma̠ i̠karabh. Na̠ e̠bho̠ro̠gh elegh; ya̠a̠, elegh ola̠ ta̠ oleriom awa bo̠, a̠ten elegh ta̠ A̠zona̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Agu̠o̠ A̠zona̠ aro̠ ma̠ elegh a̠nigha̠ ma̠ a̠nwunom A̠ninive bho̠, obha̠ agu̠o̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ ma̠ elegh a̠nigha̠ ma̠ amu̠m onon. ");
INSERT INTO mgj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","D̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, ani̠ebhom O̠li̠la ebhugh Ase̠ba ta̠ a̠b̠etina̠ agba ma̠ a̠nwunom amu̠m onon e̠mar egir e̠pi̠e̠; ezin bho̠, i̠na ad̠u̠a d̠a̠ ekunuguma̠ e̠mara̠nwunom a̠ru ra̠ atu̠ghan eloghom abar ta̠ Aso̠lo̠mo̠n. Ya̠a̠, o̠ni̠ ola̠ abu̠gh a̠pu ma̠ Aso̠lo̠mo̠n od̠i ma̠ i̠se̠n! ");
INSERT INTO mgj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","D̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, a̠nwunom A̠ninive ta̠ e̠mara, sa̠ awa ta̠ e̠gba ma̠a̠ a̠nwunom amu̠m onon e̠mar egir e̠pi̠e̠; ezin bho̠, awa e̠mu̠gho̠n asu̠gbagba ta̠ A̠zona̠ sa̠ awa itiba̠ra̠ d̠a̠ i̠karabh d̠awa. Ya̠a̠, o̠ni̠ ola̠ abu̠gh a̠pu ma̠ A̠zona̠ od̠i ma̠ i̠se̠n! ");
INSERT INTO mgj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“O̠ni̠ ola̠ ta̠ asu̠o̠m ato̠di̠ sa̠ ta̠ alo̠gh esi awo̠gi̠, bo̠d̠o̠ ta̠ a̠guri d̠a̠ ekpukpu abo̠di̠ bo̠. Kpe̠le̠me̠ni̠, i̠na ta̠ agbam d̠a̠ anyu̠ abar, b̠o̠ka̠ ogbo ya̠ na̠ ed̠igh esi bho̠ e̠bi̠gh e̠b̠alab̠al. ");
INSERT INTO mgj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ekpo-a̠d̠ien d̠oyom bha̠ ato̠di̠ ozu d̠oyom. Ku̠gba ma̠ ekpo-a̠d̠ien d̠oyom a̠bhon, bha̠ eb̠la̠ ozu d̠oyom ta̠ a̠muzo na̠ e̠b̠alab̠al. Ya̠a̠, ku̠gba ma̠ ekpo-a̠d̠ien d̠oyom na̠ obhon d̠o̠, bha̠ eb̠la̠ ozu d̠oyom ta̠ a̠muzo na̠ azi̠m. ");
INSERT INTO mgj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","O̠ku̠a a̠d̠ighi be̠le̠ni̠, mare̠ ma̠ a̠kpona̠ ma̠ a̠d̠ighi ma̠ agu̠o̠ ola̠ e̠b̠alab̠al wa̠ od̠i d̠a̠ ozu d̠oyom bho̠ ko o̠ro̠ d̠o̠ ma̠ azi̠m. ");
INSERT INTO mgj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ku̠gba ma̠ eb̠la̠ ozu d̠oyom a̠muzo na̠ e̠b̠alab̠al, sa̠ azi̠m o̠ro̠ d̠o̠ ma̠ esi, bha̠ ta̠ a̠muzo na̠ e̠b̠alab̠al kesikesi woma̠ ato̠di̠ na̠ awar e̠b̠alab̠al na̠ a̠zuom anwa.” ");
INSERT INTO mgj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Igiel bho̠ A̠zizo̠s na̠ agba ma̠ asu̠gbagba bho̠, sa̠ odi Afarisi ale̠gh i̠na ma̠ oru ra̠ od̠igh na̠ o̠yo̠ od̠e abar. Sa̠ i̠na agi̠ ka̠ aro̠ ma̠ a̠dila̠de ab̠e̠d̠i̠an d̠a̠ akpata od̠e bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sa̠ a̠d̠igh ilologia̠n o̠ni̠ Afarisi bho̠ ma̠ o̠bi̠gh ma̠ A̠zizo̠s na̠ od̠ia̠ d̠o̠ a̠tita̠la̠ ma̠ aru̠gu̠o̠ d̠o̠yo̠ kisa̠ i̠na aro̠ ma̠ a̠dila̠de ma̠ od̠e ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sa̠ Wa̠nwuna̠ bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “Inyin Rafarisi bho̠, inyin na̠ otitol aman okpa̠ko bho̠ na̠ e̠kpa bho̠; ya̠a̠, d̠a̠ rologi d̠inyin bha̠ o̠ku̠ku̠ na̠ i̠karabh imuzo! ");
INSERT INTO mgj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sa̠ rema̠! Wale̠m aman bho̠ na̠ o̠b̠aram d̠o̠ na̠ ologi bho̠ ale̠m ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ibhine ma̠ onyen ologi ma̠ ebhin i̠di̠ar ya̠ inyin unwuna̠ bho̠ ma̠ e̠ne̠ghe̠ ma̠ e̠ne̠ghe̠ ma̠ enigha̠ ma̠ ronyigoiny bho̠, sa̠ eb̠la̠ i̠di̠ar ta̠ e̠b̠ab̠ala enigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ekulom inyin Rafarisi! Ezin bho̠, inyin na̠ obhin aghan-od̠od̠ua̠ na̠ u̠ki̠a na̠ a̠d̠ien kerekere i̠gho̠gho̠ a̠mubobh, na̠ onigha̠ ma̠ A̠zib̠a̠ ma̠ odi a̠bin d̠a̠ a̠d̠iobh, sa̠ inyin ugin a̠ma̠rugh igielake̠ na̠ etula̠n ta̠ A̠zib̠a̠. I̠nye̠n i̠di̠ar ya̠ i̠kpe̠ inyin ogir, ya̠a̠ o̠ni̠ ko o̠we̠le̠ ma̠ onigha̠ a̠bin a̠d̠iobh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ekulom inyin Rafarisi bho̠! Ezin bho̠ inyin uba̠ra̠ ma̠ ra̠dila̠de idoni d̠a̠ ru̠gala A̠zu, na̠ ipelegima̠ d̠a̠ regbolom a̠b̠ua̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ekulom inyin Rafarisi bho̠! Ezin bho̠, inyin od̠i ka̠ ranyu̠od̠i ya̠ elegh o̠to̠, ya̠ a̠nwunom ologhom d̠o̠ sa̠ na̠ erile d̠a̠ anyu̠ na̠ eten.” ");
INSERT INTO mgj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sa̠ odi o̠ni̠ awa ola̠ na̠ aku̠ro̠m d̠a̠ oloko bho̠ awo̠ran i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, anwa i̠b̠aram na̠ i̠yar a̠rogi d̠a̠ a̠fugh i̠nye̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ekulom inyin ogbo ya̠ na̠ e̠ku̠ro̠m d̠a̠ roloko bho̠! Ezin bho̠, inyin na̠ obhin a̠dol ya̠ i̠mu̠mo̠r na̠ o̠gbam d̠a̠ aru̠mu̠ a̠nwonom orol; ya̠a̠, inyin ub̠eton d̠o̠ ma̠ ad̠u̠nu̠ agu̠o̠ okula̠n a̠dol bho̠ o̠lo̠gh agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ekulom inyin! Ezin bho̠, inyin na̠ ob̠olob̠ol na̠ oburi ma̠ ranyu̠od̠i a̠riwil ya̠ ro̠we̠de̠ d̠inyin igigh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ebula̠ o̠ku̠a, sa̠ inyin na̠ oleriom ma̠a̠, inyin oma̠ra̠ ma̠ i̠di̠ar ya̠ ro̠we̠de̠ d̠inyin igir bho̠. Awa i̠ze̠ ma̠ a̠riwil bho̠, sa̠ inyin na̠ ob̠olob̠ol ranyu̠od̠i d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","O̠ku̠a a̠d̠ighi be̠le̠ni̠, d̠a̠ ibom eloghom abar ta̠ A̠zib̠a̠ sa̠ a̠fugh ma̠a̠, ‘Ami̠ ta̠ afi̠ri̠ma ma̠ a̠riwil sekina̠ ogbo ogir agi̠o̠m a̠wa̠. Idi sa̠ a̠wa̠ ta̠ egigh, ipa̠n sa̠ a̠wa̠ ta̠ egbikimeni.’ ");
INSERT INTO mgj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ta̠ osibh a̠nwunom a̠mu̠m onon odinom ebula̠ asi̠ ta̠ eb̠la̠ a̠riwil ya̠ u̠ze̠gi̠ bho̠, d̠a̠ o̠pu̠r ob̠eton e̠mara̠nwunom bho̠ tu̠tu̠n ate̠i̠ i̠se̠n; ");
INSERT INTO mgj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ob̠eton d̠a̠ asi̠ ta̠ Ebe̠l ka̠ ate̠i̠ d̠a̠ asi̠ ta̠ Azakaraya wa̠ ugigh d̠a̠ esa̠d̠io enwen i̠ko̠l bho̠ na̠ a̠lukpesi e̠tu̠tu̠ bho̠. Ya̠gia̠ga̠i, ta̠ opuru ma̠ amu̠m onon ma̠ asi̠ i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ekulom inyin ogbo ya̠ na̠ e̠ku̠ro̠m d̠a̠ roloko A̠zu bho̠! Ezi̠n bho̠, inyin na̠ o̠si̠ghe̠ ma̠ i̠sabi̠ eloghom abar bho̠. Inyin na̠ agu̠o̠ ud̠igh d̠o̠ ya̠a̠ inyin na̠ okigima̠ ma̠ ipa̠n a̠nwunom od̠i̠gh.” ");
INSERT INTO mgj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Igiel bho̠ A̠zizo̠s na̠ ad̠u̠a bho̠, sa̠ Rafarisi bho̠ na̠ ogbo a̠tu̠ghu̠me̠ni̠ oloko bho̠ i̠ke̠ ma̠ owia̠n o̠yo̠, opupura̠n o̠yo̠ a̠d̠i̠zo i̠di̠ar, ");
INSERT INTO mgj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","opoiny o̠yo̠ ma̠ o̠nu̠ ka̠ i̠na ta̠ a̠fugh abar ola̠ awa ta̠ edin esibh i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","D̠a̠ onin obhel bho̠, sa̠ ro̠lo̠gh a̠nwunom ya̠ ipel a̠d̠usubh o̠ni̠r na̠ ogho e̠wala, id̠u iru ra̠ i̠te̠i̠ esi ola̠ odi na̠ aze̠r odi. Sa̠ A̠zizo̠s a̠d̠ia̠ a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “I̠mare̠ ma̠ ekpona̠ ma̠ a̠yist Rafarisi bho̠, ya̠ awa na̠ e̠gba ma̠ ipa̠n na̠ egir ipa̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Abar ola̠ ukpegiom ola̠ ko omite d̠o̠ ma̠ e̠ma bo̠, bo̠d̠o̠ ola̠ odi d̠a̠ e̠wo̠gi̠na ola̠ ko ologhom d̠o̠ bo̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Abar ola̠ inyin ufugh d̠a̠ a̠d̠io azi̠m, ola̠ a̠nwunom ka̠ o̠mu̠gho̠n d̠o̠ ma̠ etita̠n a̠d̠io bo̠, abar ola̠ inyin ubhobhula̠ d̠a̠ re̠bhai̠, ta̠ o̠ro̠ d̠a̠ anyu̠ a̠rutu o̠gba o̠sasaragi̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ra̠tologha̠n d̠ami̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ko oghil ogbo ya̠ na̠ egigh ozu bho̠ sa̠ ko orue mu egir opa̠n abar e̠lo̠gho̠m. ");
INSERT INTO mgj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ya̠a̠, ami̠ na̠ a̠bhin o̠kparakpar okoroko na̠ a̠kikiom inyin o̠ni̠ wa̠ akpe̠ inyin oghil bho̠: ighile i̠na wa̠, ka̠ i̠na na̠ a̠gigh ozu bho̠ awe̠le̠, sa̠ a̠nwuna̠ ma̠ a̠limon orobh inyin o̠lo̠gh d̠a̠ e̠banya bho̠. Yii, ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠na wa̠ oghil bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Uwol d̠o̠ ma̠ ogho ikpo ro̠gi̠e̠ ta̠ egule ma̠ i̠wal ape̠ni̠ ke̠re̠? Ku̠ku̠m eka̠, bebina̠ onin awa ola̠ A̠zib̠a̠ na̠ a̠weleta̠n bo̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ya̠gia̠ga̠i, eb̠la̠ ikpo asi̠ghal aru̠mu̠ d̠inyin eka̠ na̠ o̠wal. O̠ni̠ ko oghil a̠rugugu; inyin ulei abar opu ma̠ o̠lo̠gh ro̠gi̠e̠ ta̠ egule. ");
INSERT INTO mgj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ko̠ni̠ko̠ni̠ ola̠ agba ami̠ a̠mutiom d̠a̠ a̠misigh a̠nwunom, O̠nyi̠ ta̠ O̠ni̠ ta̠ agba ani̠ i̠na a̠mutiom d̠a̠ a̠misigh itileduom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ya̠a̠, ko̠ni̠ko̠ni̠ ola̠ aku̠a ami̠ d̠a̠ a̠misigh a̠nwunom, ta̠ o̠ku̠a ani̠ i̠na d̠a̠ a̠misigh itileduom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ko̠ni̠ko̠ni̠ ola̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ O̠nyi̠ ta̠ O̠ni̠, ta̠ okpon o̠si̠ghe̠ ma̠ a̠d̠ien; ya̠a̠, o̠ni̠ ola̠ a̠fugh i̠basi̠ a̠gboloma̠ ma̠ E̠mu̠gh E̠tu̠tu̠ bho̠, ko okpon d̠o̠ o̠si̠ghe̠ ma̠ a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Igiel uler inyin iku d̠a̠ u̠gala A̠zu, sa̠ u̠marame̠ni̠ inyin d̠a̠ a̠misigh ogbo ya̠ na̠ erileghom ebhugh bho̠ na̠ ogbo aru̠mu̠ a̠dila̠de i̠to̠ bho̠, o̠ni̠ ko o̠ku̠nu̠ ma̠ agu̠o̠ o̠wo̠yo̠ghan awa, bo̠d̠o̠ agu̠o̠ obhin o̠gba o̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ezin bho̠, E̠mu̠gh E̠tu̠tu̠ bho̠ ta̠ atu̠ghu̠me̠ni̠ inyin d̠a̠ obhel ola̠ o̠ku̠a, ma̠ i̠di̠ar ya̠ isora̠n o̠gba omutiom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sa̠ odi o̠ni̠ d̠a̠ o̠lo̠gh bho̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, fughe ma̠ a̠nigha̠ ma̠ umor d̠ami̠ ma̠ agu̠o̠ ola̠ i̠na na̠ ami̠ ta̠ o̠ru̠gi̠an ad̠i̠a o̠we̠de̠ d̠i̠yar.” ");
INSERT INTO mgj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “O̠ni̠ bho̠, a̠nyen aso̠n ami̠ ma̠ o̠ro̠ o̠ni̠ osobh ma̠ ase̠, bo̠d̠o̠ wi̠to̠to̠gi̠ d̠inyin?” ");
INSERT INTO mgj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sa̠ i̠na agba ma̠a̠, “I̠mare̠ ma̠ ekpona̠! I̠we̠le̠mane̠ ma̠ a̠d̠ien kerekere ado̠l o̠ku̠ku̠; a̠ga̠i a̠ghud̠um o̠nyi̠o̠mo̠ro̠ni̠ bo̠ d̠a̠ e̠mi̠ e̠li̠la ya̠ i̠na a̠gbo bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa̠ i̠na a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠, “O̠si̠ odi o̠li̠la o̠ni̠ a̠mite ma̠ opa̠n. ");
INSERT INTO mgj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa̠ i̠na aru̠ru̠an d̠a̠ ologi d̠o̠yo̠ ma̠a̠, ‘I̠se̠n ka̠ ami̠ ta̠ a̠d̠ighi eka̠? Ami̠ inwuna̠ mu ma̠ esi okpol ed̠ia̠n d̠ami̠ oguri ya̠ eko.’ ");
INSERT INTO mgj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Sa̠ i̠na a̠fugh ma̠a̠, ‘Ami̠ ta̠ a̠b̠ogion re̠kpe̠ okoko ed̠ia̠n d̠ami̠ a̠lo ma̠ ipa̠n ya̠ i̠bu̠gh ipu ma̠ i̠nye̠n. Sa̠ ami̠ ta̠ a̠d̠ighoghom eb̠la̠ ed̠ia̠n ib̠ua̠ d̠ami̠ a̠kpol d̠a̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sa̠ ami̠ ta̠ a̠fugh a̠nigha̠ ma̠ ozu d̠ami̠ ma̠a̠, “Anwa na̠ a̠kpol ed̠ia̠n a̠guri ma̠ iya̠ eko ya̠ ta̠ elei od̠e a̠d̠izo rala d̠a̠ ed̠ia̠. O̠ku̠a a̠d̠ighi be̠le̠ni̠, ri̠la ti̠to̠i̠ny ma̠ a̠d̠e, ma̠ ad̠a, ma̠ ad̠e̠ ma̠ o̠d̠e̠.” ’ ");
INSERT INTO mgj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ya̠a̠, A̠zib̠a̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, ‘Sa̠ ema̠! A̠d̠uga̠la̠n onon, ta̠ opuru nyam a̠ghud̠um d̠oyom. Sa̠ eb̠la̠ i̠di̠ar ya̠ anwa ikokod̠i iguri bho̠ ta̠ e̠ro̠ enigha̠ ma̠ a̠nyen?’ ");
INSERT INTO mgj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Obha̠ agu̠o̠ ta̠ aro̠ a̠nigha̠ ma̠ o̠ni̠ ola̠ a̠kpol i̠di̠ar a̠guri a̠sisa̠n ozu d̠o̠yo̠, sa̠ awe̠le̠man ogbo e̠li̠la d̠a̠ i̠di̠ar ya̠ igboloma̠ ma̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠: “O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko o̠nyo̠gho̠ghan ologi ma̠ egboloma̠ ma̠ a̠ghud̠um d̠inyin, a̠d̠igh abar ola̠ inyin ta̠ od̠e; bo̠d̠o̠ abar ola̠ inyin ta̠ o̠lagha. ");
INSERT INTO mgj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ezin bho̠, a̠ghud̠um a̠lei abar a̠pu ma̠ ed̠ia̠n, sa̠ ozu o̠ni̠ a̠lei abar a̠pu ma̠ ibura̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ikpone ma̠ ed̠ighom a̠ghud̠um i̠nu̠r ya̠ od̠i ka̠ e̠gbar bho̠: Awa igbebh d̠o̠, awa ib̠u d̠o̠, inwuna̠ d̠o̠ nyen e̠bhai̠, bo̠d̠o̠ e̠kpe̠ ola̠ okpol ed̠ia̠n. Ku̠ku̠m eka̠, A̠zib̠a̠ na̠ a̠koko awa. Ya̠a̠, inyin ulei abar opu ma̠ i̠nu̠r ya̠ na̠ e̠bhe̠bh d̠a̠ anyu̠ bho̠! ");
INSERT INTO mgj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","O̠ni̠ inyin ola̠ ta̠ a̠rue a̠bhin o̠nyo̠gho̠ghan ologi alo̠gho̠m ekud̠i obhel d̠a̠ a̠ghud̠um d̠o̠yo̠ od̠i ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ku̠gba ma̠ inyin ko orue d̠o̠ ogir o̠gbara abar ola̠ o̠ku̠a, ka̠ inyin ta̠ odin ere o̠nyo̠gho̠ghan ologi ogboloma̠ ma̠ ipa̠n i̠di̠ar? ");
INSERT INTO mgj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ikpone ma̠ ed̠ighom d̠a̠ a̠ghud̠um ra̠lele bho̠, ma̠ agu̠o̠ awa na̠ ebhin na̠ e̠su̠ bho̠. Awa igir d̠o̠ ma̠ i̠kparakpar ogir, awa ilo d̠o̠ ma̠ a̠ma̠lo nyen. Ku̠ku̠m eka̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠ a̠ga̠i Aso̠lo̠mo̠n eka̠, d̠a̠ eb̠la̠ isosorogia̠n d̠o̠yo̠ na̠ obura̠ d̠o̠ ma̠ ibura̠ ya̠ ibhon ile̠i ita̠ odi a̠lele i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ku̠gba ma̠ obha̠ agu̠o̠ A̠zib̠a̠ na̠ a̠buri ma̠ i̠gho̠gho̠ ya̠ od̠i d̠a̠ e̠sala bho̠, ya̠ a̠didon od̠i sa̠ elegien ta̠ orobh o̠lo̠gh d̠a̠ anya bho̠, o̠ku̠a sa̠ i̠na ta̠ a̠buri inyin a̠peleni ma̠ o̠ku̠a-inyin ogbo ya̠ ologi ima̠ra̠ o̠ghu̠a d̠o̠ bho̠! ");
INSERT INTO mgj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ebula̠ o̠ku̠a, o̠ni̠ ko onigha̠ ma̠ rologi d̠inyin ma̠ ali̠gam a̠ruzu ma̠ egboloma̠ ma̠ i̠di̠ar ya̠ od̠e, bo̠d̠o̠ ya̠ o̠d̠a; o̠ni̠ ko o̠nyo̠gho̠ghan egboloma̠ ma̠ i̠di̠ar ya̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ezin bho̠, a̠nwunom e̠mara̠nwunom onon, na̠ ewia̠n o̠te̠i̠ eb̠la̠ i̠di̠ar i̠nye̠, ya̠a̠ O̠we̠de̠ d̠inyin a̠loghom ma̠ a̠bhon inyin o̠te̠i̠ i̠di̠ar i̠nye̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kpe̠le̠me̠ni̠, i̠bho̠ro̠ghe̠ ma̠ o̠te̠i̠ irileghom ta̠ A̠zib̠a̠, sa̠ ta̠ o̠b̠ar na̠ i̠di̠ar i̠nye̠n onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Inyin o̠gbara o̠lo̠gh, o̠ni̠ ko oghil a̠rugugu. Ezin bho̠, a̠d̠igh ologi ma̠ O̠we̠de̠ d̠inyin onigha̠ inyin irileghom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Iwole ma̠ i̠di̠ar ya̠ inyin unwuna̠ bho̠ ma̠ ebhin e̠lo̠gh agu̠o̠ ma̠ enigha̠ ma̠ ronyigoiny bho̠. Iguri ma̠ i̠di̠ar ya̠ eko d̠inyin d̠a̠ e̠kpa ola̠ ko o̠ghu̠r d̠o̠, i̠di̠ar ya̠ ilei abar d̠a̠ ote̠nai̠ny ya̠ ko omunia̠n d̠o̠; d̠a̠ esi ola̠ aru̠gba ko otua̠n d̠o̠, sa̠ afi̠ ola̠ ta̠ a̠d̠e api̠e̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Esi wa̠ i̠di̠ar ya̠ ilei abar d̠inyin od̠i bho̠, i̠se̠ esi rologi d̠inyin ta̠ e̠ro̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“I̠kpaki̠ane̠ ma̠ e̠kpo̠a ma̠ ro̠kara, ma̠ e̠su̠o̠m rato̠di̠ d̠inyin e̠ro̠ ma̠ omumor omumor, ");
INSERT INTO mgj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ma̠ agu̠o̠ ib̠a̠ra̠motu ya̠ na̠ egon wa̠nwuna̠ d̠awa ma̠ o̠d̠u̠a d̠a̠ o̠d̠e̠ erogh omula̠ oru, b̠o̠ka̠ obhel i̠na ra̠ a̠kpukpu awa e̠nu̠r eguron enigha̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta̠ ebhon enigha̠ ma̠ rob̠a̠ra̠motu ya̠ wa̠nwuna̠ d̠awa ta̠ ra̠ abi̠gh ma̠ awa i̠ro̠ na̠ egon i̠na, ma̠ igiel i̠na ta̠ a̠mula̠ a̠ru. Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠na na̠ agu̠o̠ ta̠ a̠bura̠ ma̠ ibura̠ ogir iyo̠yo̠, sa̠ i̠na ta̠ a̠fugh awa ma̠ o̠ro̠ a̠dila̠de, sa̠ i̠na ta̠ aru̠gi̠ ma̠ ed̠ia̠n a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ta̠ ebhon enigha̠ ma̠ rob̠a̠ra̠motu ya̠ wa̠nwuna̠ d̠awa ta̠ ra̠ abi̠gh ma̠ awa i̠ro̠ na̠ egon i̠na; i̠na a̠ru ka̠ ma̠ egum a̠d̠io, bo̠d̠o̠ ame̠ghe̠le̠ eka̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ya̠a̠, i̠mare̠ ma̠ e̠mu̠gho̠nyan abar onon: Ku̠gba ma̠ wa̠nwuna̠ ma̠ otu bho̠ amar a̠loghom obhel wa̠ o̠gba bho̠ ta̠ a̠ru bho̠, i̠na ta̠ a̠d̠ighi ma̠ agu̠o̠ ola̠ ko orue d̠o̠ a̠b̠om otu d̠o̠yo̠ a̠d̠igh. ");
INSERT INTO mgj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Inyin eka̠ ikokod̠ia̠ne ma̠ eb̠a̠ra̠, ezin bho̠, O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠ru d̠a̠ obhel ola̠ inyin o̠ru̠ru̠an d̠o̠ na̠ o̠ru̠ru̠an.” ");
INSERT INTO mgj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sa̠ A̠pita̠ a̠pura̠n ma̠a̠, “Wa̠nwuna̠, anwa na̠ a̠rogh a̠sidogh onon na̠ a̠nigha̠ i̠yar ku̠ku̠m ke̠re̠, bo̠d̠o̠ ka̠ ola̠ eb̠la̠ ogbo?” ");
INSERT INTO mgj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sa̠ Wa̠nwuna̠ bho̠ awo̠ran ma̠a̠, “O̠ku̠a ka̠ a̠nyen ob̠eb̠i o̠ni̠ wa̠ wa̠nwuna̠ bho̠ ta̠ aso̠n o̠ro̠ we̠mu̠ okponom rob̠a̠ra̠motu d̠o̠yo̠, onigha̠ gha̠n awa ra̠bin ed̠ia̠n d̠awa ma̠ obhel wa̠ akpe̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta̠ ebhon enigha̠ ma̠ ogoni bho̠, ka̠ wa̠nwuna̠ d̠o̠yo̠ a̠mula̠ a̠ru sa̠ ta̠ abi̠gh ma̠a̠ i̠na na̠ a̠gir agu̠o̠ u̠to̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, wa̠nwuna̠ d̠o̠yo̠ ta̠ a̠b̠eton eb̠la̠ i̠d̠i̠ar d̠o̠yo̠ a̠nigha̠ i̠na ma̠ okponom. ");
INSERT INTO mgj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ya̠a̠ ta̠ aro̠ eka̠, ku̠gba ma̠ ob̠a̠ra̠motu bho̠ a̠fugh d̠a̠ ologi d̠o̠yo̠ ma̠a̠, ‘Wa̠nwuna̠ d̠ami̠ na̠ a̠bia̠ ma̠ oru,’ sa̠ i̠na ake̠ ma̠ od̠ulogh rob̠a̠ra̠motu iyed̠i, anwani̠ na̠ ilobhiri, sa̠ a̠d̠e ad̠a ka̠ ate̠i̠ esi ola̠ a̠min bho̠ na̠ epuru i̠na? ");
INSERT INTO mgj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wa̠nwuna̠ ma̠ ob̠a̠ra̠motu obha̠ ta̠ a̠mula̠ a̠ru ma̠ a̠d̠a̠ma̠ ola̠ i̠na o̠ru̠ru̠an d̠o̠, d̠a̠ obhel ola̠ i̠na ologhom d̠o̠ nyen. Sa̠ i̠na ta̠ a̠gbikimeni i̠na ma̠ egbika̠ ya̠ igurom ipu bho̠, a̠d̠ighom i̠na ma̠ esi wa̠ ogbo ya̠ ologhom d̠o̠ ma̠ A̠zib̠a̠ ta̠ e̠ro̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ob̠a̠ra̠motu wa̠ a̠loghom abar wa̠ wa̠nwuna̠ i̠na na̠ a̠puru i̠na ma̠ ogir bho̠, sa̠ awe̠le̠man okokod̠ia̠n ob̠a̠ra̠, bo̠d̠o̠ ogir agu̠o̠ bho̠ akpe̠ i̠na ma̠ ogir bho̠, ta̠ o̠gu̠ro̠gh ibom. ");
INSERT INTO mgj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ya̠a̠, i̠na wa̠ ologhom d̠o̠, sa̠ a̠gir i̠di̠ar ya̠ i̠kpe̠ ma̠ o̠gu̠r o̠yo̠ bho̠, ta̠ o̠gu̠ro̠gh o̠nyi̠ki̠kara ku̠ku̠m. O̠ni̠ ola̠ unigha̠ ma̠ ya̠ ib̠uiy, ta̠ opuru i̠na ma̠ iya̠ ib̠uiy. Ya̠a̠ o̠ni̠ ola̠ unigha̠ ma̠ ya̠ ib̠uiy ibom, ta̠ opuru i̠na ma̠ iya̠ ib̠uiy ibom. ");
INSERT INTO mgj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ami̠ iru ma̠ ra̠ o̠lo̠gh anya d̠a̠ e̠mara̠nwunom onon. Ya̠ i̠se̠n anya bho̠ na̠ e̠ke̠ na̠ emumor na̠ ab̠o̠, ka̠ id̠igh ami̠ ma̠ ologi! ");
INSERT INTO mgj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ami̠ a̠nwuna̠ ma̠ owura̠ amu̠m ali̠gam a̠luzu d̠a̠ ed̠ia̠ ola̠ agu̠o̠ omiza̠n o̠ro̠ d̠o̠, sa̠ na̠ ane̠mu̠o̠m ami̠ a̠guri tu̠tu̠n ta̠ a̠ten! ");
INSERT INTO mgj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inyin u̠ru̠ru̠an ma̠ ami̠ iru ra̠ omutiom ekima̠ d̠a̠ e̠mara̠nwunom onon d̠u̠ko̠? E̠nyi̠, ami̠ iru ra̠ o̠bagi̠o̠n a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, eghun otu ogho o̠ni̠ ta̠ abagi̠na; i̠sar ta̠ e̠ro̠ ma̠ agba, sa̠ i̠wal ta̠ ewia̠n awa, bo̠d̠o̠, i̠wal ta̠ e̠ro̠ ma̠ agba, sa̠ i̠sar ta̠ ewia̠n awa. ");
INSERT INTO mgj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awa ta̠ e̠bagi̠na, o̠we̠de̠ ta̠ a̠wia̠n o̠nyi̠, sa̠ o̠nyi̠ ta̠ a̠wia̠n o̠we̠de̠; onweni ta̠ a̠wia̠n o̠nyani̠, sa̠ o̠nyani̠ ta̠ a̠wia̠n onweni; o̠yo̠go̠-onweni ta̠ a̠wia̠n o̠yo̠go̠-o̠nyani̠, sa̠ o̠yo̠go̠-o̠nyani̠ ta̠ a̠wia̠n o̠yo̠go̠-onweni.” ");
INSERT INTO mgj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sa̠ i̠na agba a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠ ma̠a̠, “Igiel inyin u̠bi̠gh ka̠ o̠b̠u̠ghu̠b̠u̠gh bho̠ na̠ a̠lo na̠ a̠ru d̠a̠ agba wa̠ ogogo bho̠ na̠ a̠sor bho̠, onin obhel bho̠ sa̠ inyin ta̠ o̠gba ma̠a̠, ‘A̠d̠io ta̠ alo̠bh,’ sa̠ na̠ a̠mite ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya̠a̠, igiel o̠fe̠gu̠ ad̠u̠a d̠a̠ esoroma̠ e̠mara̠nwunom bho̠ na̠ a̠ru, sa̠ inyin ta̠ o̠gba ma̠a̠, ‘A̠d̠io ta̠ asi̠so̠,’ sa̠ na̠ a̠mite ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sa̠ ribhelebhel! Inyin na̠ orue na̠ okpon a̠de na̠ e̠nai̠ na̠ o̠mu̠gho̠nyan agu̠o̠ a̠d̠io na̠ a̠bhin na̠ a̠lologia̠n; ya̠a̠, ezin ka̠ ere ma̠ wa̠ inyin orue d̠o̠ ma̠ o̠mu̠gho̠nyan i̠di̠ar ya̠ na̠ emite d̠a̠ obhel onon bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ya̠a̠, ezin ka̠ ere wa̠ inyin orue ani̠ d̠o̠, ma̠ o̠wal ologho̠m abar wa̠ a̠bhon bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Igiel anwa na̠ agi̠ ka̠ o̠b̠e̠re̠gi̠an o̠kpe̠ na̠ o̠ni̠ wa̠ a̠ler anwa ma̠ iku bho̠, wia̠ne ma̠ a̠tulugia̠n na̠ i̠na d̠a̠ eten, kisa̠ inyin ta̠ o̠te̠i̠ esi osobh ase̠ bho̠. Bo̠d̠o̠ bha̠, i̠na ta̠ a̠bhin anwa agi̠o̠m osobh ma̠ ase̠ bho̠, sa̠ i̠na ta̠ a̠nu nyam agi̠o̠m o̠ni̠-oloko bho̠, sa̠ o̠ni̠-oloko bho̠ ta̠ a̠sibh anwa alo̠gh d̠a̠ ikoli. ");
INSERT INTO mgj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, anwa ko orue d̠o̠ a̠mite d̠a̠ ikoli bho̠ a̠ten ka̠ anwa na̠ akpe̠ kabar kabar amado̠n, ma̠ ola̠ bebina̠ ape̠ni̠ eka̠ ko osugho d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","D̠a̠ obhel obha̠, sa̠ idi a̠nwunom iru ra̠ i̠gba inigha̠ ma̠ A̠zizo̠s ma̠a̠, Apai̠let aze̠ ma̠ idi a̠nwunom Agalili d̠a̠ obhel ola̠ awa na̠ e̠ko̠l i̠ko̠l, ma̠ ola̠ asi̠ d̠awa i̠gu̠a na̠ asi̠ i̠nam i̠ko̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin na̠ o̠ru̠ru̠an ma̠a̠, ezin wa̠ a̠nwunom Agalili i̠nye̠n ya̠ i̠mu̠gh o̠ko̠no̠n bho̠, ma̠a̠ awa igir i̠karabh epu ma̠ eb̠la̠ a̠nwunom Agalili iyed̠i ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","E̠e̠nyi̠! Ya̠a̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠ten ka̠ inyin utiba̠ra̠ d̠a̠ i̠karabh d̠inyin, eb̠la̠ inyin eka̠ ta̠ omugh obhe. ");
INSERT INTO mgj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bo̠d̠o̠ ka̠, d̠iobh na̠ o̠bhabhanya o̠ni̠ ya̠ owewegh otu-ipoiny d̠a̠ Asi̠lo̠m a̠mel a̠bhum bho̠, ka̠ awa igir i̠karabh epu ma̠ eb̠la̠ a̠nwunom ya̠ na̠ erugh d̠a̠ A̠zeruse̠le̠m bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","E̠e̠nyi̠! Ya̠a̠, ami̠ na̠ ka̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠ten ka̠ inyin utiba̠ra̠ d̠a̠ i̠karabh d̠inyin, eb̠la̠ inyin eka̠ ta̠ omugh obhe.” ");
INSERT INTO mgj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sa̠ A̠zizo̠s a̠rogh a̠sidogh onon: “Odi o̠ni̠ a̠gbebh a̠fig d̠a̠ a̠lei d̠o̠yo̠; sa̠ agi̠gha̠n ka̠ a̠kpon ka̠ i̠na ta̠ abi̠gh itu aku̠, ya̠a̠ i̠na na̠ o̠bi̠gh d̠o̠ bebina̠ onin otu. ");
INSERT INTO mgj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠ni̠ wa̠ na̠ a̠kponom a̠lei bho̠ ma̠a̠, ‘Onon sa̠ i̠sar ala ami̠ na̠ a̠guri gha̠n na̠ a̠ru ma̠ i̠se̠n ra̠ okpon ka̠ ami̠ ta̠ abi̠gh otu d̠a̠ a̠fig onon, ya̠a̠ ami̠ ta̠ o̠bi̠gh d̠o̠ bebina̠ onin otu. O̠ku̠a a̠d̠ighi be̠le̠ni̠, gue ma̠ oriren bho̠ ma̠ a̠teb̠eli! Ta̠ atu̠n ere aro̠ ma̠ i̠se̠ a̠robh a̠b̠uruko a̠de bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Sa̠ o̠ni̠ wa̠ na̠ a̠kponom a̠lei bho̠ awo̠ran i̠na ma̠a̠, ‘Wa̠nwuna̠, we̠le̠mane̠ ma̠ a̠guri ma̠ opa̠n ala, sa̠ ami̠ ta̠ a̠gbo ma̠ a̠de bho̠ a̠gir esin oriren bho̠ a̠bhin a̠b̠uruko a̠b̠ologhom. ");
INSERT INTO mgj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ku̠gba ma̠ a̠fig bho̠ a̠mum otu ma̠ ala wa̠ na̠ a̠ru, bha̠ ob̠eb̠i; bo̠d̠o̠ bha̠ gue ma̠ a̠teb̠eli.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Odi a̠d̠a̠ma̠ osira̠-epobh, A̠zizo̠s na̠ atu̠ghu̠me̠ni̠ d̠a̠ odi otu u̠gala A̠zu, ");
INSERT INTO mgj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ya̠a̠ odi ani̠ ola̠ o̠karabh e̠mu̠gh alo̠gh e̠gha-aman d̠iobh na̠ o̠bhabhanya ala aro̠. Ani̠ bho̠ akpu̠lan ola̠ orue d̠o̠ ma̠ o̠mara oselegha̠n. ");
INSERT INTO mgj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Igiel bho̠ A̠zizo̠s abi̠gh ani̠ bho̠, sa̠ a̠bhelegi a̠mutiom a̠fugh a̠nigha̠ i̠na ma̠a̠, “Ani̠ bho̠, na̠ okoko ma̠ anwa od̠umeni d̠a̠ asu̠nwe̠r d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sa̠ A̠zizo̠s agbam aru̠gu̠o̠ d̠o̠yo̠ d̠a̠ ozu ani̠ bho̠. D̠a̠ onin obhel bho̠, sa̠ i̠na a̠nwe amara a̠selegha̠n sa̠ a̠tutumeni ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ya̠a̠ ologi ta̠ we̠mu̠ u̠gala A̠zu bho̠, a̠gurom ma̠ agu̠o̠ A̠zizo̠s a̠koko ma̠ a̠likoko d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠. Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ o̠lo̠gh a̠nwunom bho̠ ma̠a̠, “Odin a̠d̠a̠ma̠ od̠i d̠a̠ esi-a̠d̠a̠ma̠ d̠i̠yar ma̠ obhin ogir ogir. O̠ku̠a a̠d̠ighi be̠le̠ni̠, itue d̠a̠ ra̠d̠a̠ma̠ i̠nye̠ ma̠ ra̠ ekokua̠n; o̠ni̠ ko oru ma̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ya̠a̠, Wa̠nwuna̠ bho̠ awo̠ran ma̠a̠, “Inyin ibhelebhel! O̠ni̠ inyin ola̠ o̠ko̠to̠n d̠o̠ ma̠ anam d̠o̠yo̠, bo̠d̠o̠ o̠su̠ d̠o̠yo̠ a̠mutiom d̠a̠ otu i̠nam bho̠ a̠nigha̠ ma̠ amu̠m, ma̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠, od̠i ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","O̠ku̠a ka̠, na̠ o̠kpe̠ d̠o̠ ma̠ o̠nyani̠ ta̠ Ebraham onon wa̠ Eru bho̠ abhad̠i̠ a̠guri ma̠ d̠iobh na̠ o̠bhabhanya ala bho̠, ma̠ omiza̠n d̠a̠ a̠d̠a̠ma̠ osira̠-epobh a̠nwunom A̠zu bho̠, ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Igiel bho̠ i̠na a̠fugh o̠ku̠a bho̠, sa̠ ari̠ghe̠l isibh eb̠la̠ ogbo ya̠ i̠dama i̠na bho̠; ya̠a̠, o̠lo̠gh a̠nwunom bho̠ ebhon ologi d̠a̠ ebula̠ rogir ilologia̠n ya̠ A̠zizo̠s na̠ a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sa̠ A̠zizo̠s a̠fugh ma̠a̠, “Irileghom ta̠ A̠zib̠a̠ ka̠ od̠i eka̠? Ami̠ ta̠ a̠bhin ere atu̠o̠m? ");
INSERT INTO mgj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Od̠i ka̠ ekpo amu̠stad ola̠ o̠ni̠ a̠bhin a̠gbebh d̠a̠ a̠lei d̠o̠yo̠; sa̠ asu̠ a̠mite a̠ten oriren, sa̠ i̠nu̠r iru ra̠ ilo ma̠ a̠rutu d̠a̠ i̠gha bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sa̠ i̠na a̠mula̠ a̠pura̠n ma̠a̠, “Ami̠ ta̠ a̠bhin ere atu̠o̠m irileghom ta̠ A̠zib̠a̠? ");
INSERT INTO mgj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Od̠i ka̠ o̠nyi̠ki̠kara a̠yist ya̠ ani̠ebhom a̠bhin alo̠gh d̠a̠ o̠to̠ma̠ i̠sar-abafu̠ ed̠ia̠n ibhugh sa̠ iwubhmeni ma̠ eb̠la̠ ed̠ia̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sa̠ A̠zizo̠s awo̠l d̠a̠ ibom na̠ i̠gbara re̠ma a̠ten, na̠ atu̠ghu̠me̠ni̠ ma̠ a̠nwunom kesikesi d̠a̠ agu̠o̠ i̠na na̠ a̠ten na̠ agi̠ d̠a̠ A̠zeruse̠le̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sa̠ odi o̠ni̠ a̠pura̠n i̠na ma̠a̠, “Wa̠nwuna̠, o̠nyi̠ki̠kara a̠nwunom ku̠ku̠m ta̠ eten ke̠re̠?” Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Iwia̠ne ma̠ ibom ma̠ o̠wo̠l d̠a̠ o̠nu̠-otu wa̠ a̠kporia̠n bho̠; ezin bho̠, a̠d̠izo ogbo ta̠ e̠bho̠ro̠ghan o̠wo̠l i̠se̠ od̠igh, ya̠a̠ ko orue d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ku̠gba ma̠ wa̠nwuna̠ ma̠ otu bho̠ a̠b̠etina̠ adu̠ ma̠ o̠nu̠-otu bho̠, sa̠ inyin uru ra̠ u̠mara d̠a̠ etire u̠kpukpu ma̠ egugh bho̠ i̠le̠gh i̠na ma̠a̠, ‘Wa̠nwuna̠, gurone ma̠ otu bho̠ ma̠ a̠nigha̠ i̠yar.’ “I̠na ta̠ awo̠ran ma̠a̠, ‘Ami̠ iloghom d̠o̠ inyin, esi inyin na̠ o̠d̠u̠a na̠ oru eka̠ ami̠ iloghom d̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Sa̠ inyin ta̠ o̠ke̠ ma̠ o̠go̠ya ma̠a̠, ‘I̠yar od̠igh na̠ anwa od̠e, o̠d̠a; sa̠ anwa i̠tu̠ghu̠me̠ni̠ d̠a̠ reten d̠i̠yar nyen.’ ");
INSERT INTO mgj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Yaa̠, i̠na ta̠ awo̠ran ma̠a̠, ‘Ami̠ iloghom d̠o̠ inyin, na̠ esi inyin na̠ o̠d̠u̠a na̠ oru. Itene ma̠ e̠d̠u̠a ma̠ i̠se̠n, eb̠la̠ inyin rod̠ighi ma̠ i̠karabh.’ ");
INSERT INTO mgj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“A̠nwunom ta̠ e̠gba ma̠ igbir, e̠ghi̠r ib̠ub̠ura̠, ma̠ igiel inyin ta̠ o̠bi̠gh Ebraham, na̠ Azi̠ki̠, na̠ A̠zeko̠pu̠, na̠ eb̠la̠ a̠riwil d̠a̠ irileghom ta̠ A̠zib̠a̠, ya̠a̠ inyin sa̠ ta̠ orobh omutiom d̠a̠ etire. ");
INSERT INTO mgj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A̠nwunom ta̠ e̠d̠u̠a d̠a̠ agba wa̠ ogogo na̠ a̠pu na̠ a̠mite bho̠, na̠ agba wa̠ ogogo na̠ a̠sor bho̠, na̠ d̠a̠ eb̠o na̠ d̠a̠ esoroma̠ e̠mara̠nwunom eru ra̠ ebhin ra̠dila̠de d̠awa, d̠a̠ o̠d̠e̠ wa̠ ta̠ a̠sor d̠a̠ irileghom ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ya̠ga̠i, ta̠ a̠mite ma̠ ola̠ idi ogbo ya̠ o̠gu̠man bho̠ ta̠ eten i̠pu̠r, sa̠ idi i̠pu̠r bho̠ ta̠ e̠ro̠ ma̠ u̠man.” ");
INSERT INTO mgj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","D̠a̠ obhel wa̠ i̠na na̠ agba ma̠ o̠ku̠a bho̠, sa̠ idi ogbo Afarisi iru ra̠ i̠gba inigha̠ i̠na ma̠a̠, “D̠u̠a ma̠ i̠se̠n a̠ten agi̠ ma̠ opa̠n esi. E̠ro̠d na̠ abho̠ro̠gh ogigh oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Sa̠ i̠na awo̠ran ma̠a̠, “I̠gi̠e̠ ka̠ e̠gba ma̠ enigha̠ ma̠ ududu obha̠ ma̠a̠, ‘Ami̠ ta̠ aro̠ ma̠ ozegi ozegi i̠karabh aru̠mu̠gh na̠ okoko okoko a̠nwunom od̠umeni, ma̠ a̠didon na̠ elegien a̠ru; oleghemeni i̠sar a̠d̠a̠ma̠ bho̠, sa̠ ami̠ ta̠ a̠muzoghod̠iom ogir d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","O̠ku̠a eka̠, ami̠ ta̠ agi̠o̠m d̠a̠ ed̠ia̠ ma̠ erile d̠ami̠ ma̠ a̠didon, na̠ elegien a̠ru, na̠ a̠melegien. Ezin bho̠, ugigh gha̠n d̠o̠ ma̠ owil opa̠n esi, a̠ten d̠a̠ A̠zeruse̠le̠m! ");
INSERT INTO mgj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“A̠zeruse̠le̠m, E A̠zeruse̠le̠m, e̠ma wa̠ na̠ a̠guri gha̠n na̠ a̠robhod̠i na̠ aze̠gi̠ ma̠ a̠riwil na̠ ogbo ya̠ A̠zib̠a̠ a̠bhin a̠dila̠de-i̠to̠ a̠ruom oru d̠o̠yo̠ bho̠! Ya̠a̠ i̠ni̠ igiel ma̠ iya̠, na̠ ebhir ami̠ ma̠ okokod̠i eb̠la̠ anwi̠i̠ny d̠oyom oguri onin esi, ma̠ agu̠o̠ e̠nu̠r-e̠ma na̠ a̠bhin rapu̠ba d̠o̠yo̠ na̠ a̠ghughuom anwi̠i̠ny d̠o̠yo̠ bho̠, ya̠a̠ anwa na̠ oma̠ra̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ebula̠ o̠ku̠a, nagha ma̠ abar wa̠ ta̠ a̠mite bho̠! Ta̠ ogin otu d̠inyin oguri ma̠ obhobho i̠kpo̠. Sa̠ ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, inyin ko o̠bi̠gh mu ami̠ tu̠tu̠n ta̠ ate̠i̠ igiel inyin ta̠ ofugh ma̠a̠, ‘Itutumeni e̠ro̠ enigha̠ i̠na wa̠ na̠ a̠bhin a̠d̠ien ta̠ Wa̠nwuna̠ na̠ a̠ru bho̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Odi a̠d̠a̠ma̠ osira̠-epobh aro̠ ma̠ ola̠ A̠zizo̠s agi̠ d̠a̠ otu odi we̠mu̠ ogbo Afarisi, ka̠ od̠igh na̠ awa od̠e ed̠ia̠n, sa̠ a̠nwunom i̠ro̠ ma̠ i̠se̠ na̠ epoiny ");
INSERT INTO mgj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","na̠ e̠nagha i̠na! I̠se̠ d̠a̠ a̠misigh d̠o̠yo̠ bha̠ odi o̠ni̠ aro̠ ma̠ ola̠ na̠ anwe̠r asu̠nwe̠r wa̠nopelbho̠. ");
INSERT INTO mgj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sa̠ A̠zizo̠s a̠pura̠n ogbo ya̠ na̠ e̠ku̠ro̠m d̠a̠ oloko bho̠ na̠ ogbo Afarisi bho̠ ma̠a̠, “Oloko bho̠ a̠ma̠ra̠ ma̠ okoko o̠ni̠ od̠umeni ma̠ a̠d̠a̠ma̠ osira̠-epobh ke̠re̠, bo̠d̠o̠ ka̠ na̠ oma̠ra̠ d̠o̠?” ");
INSERT INTO mgj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ya̠a̠ awa inima̠ i̠ro̠ b̠o̠b̠o̠m. Ebula̠ o̠ku̠a sa̠ A̠zizo̠s a̠sibh o̠ni̠ bho̠ a̠b̠eton, sa̠ a̠koko i̠na a̠d̠umeni, sa̠ a̠ruom i̠na ma̠ oten oyel. ");
INSERT INTO mgj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ku̠gba ma̠ o̠ni̠ inyin a̠nwuna̠ ma̠ o̠gbara o̠nyi̠, bo̠d̠o̠ anam ola̠ a̠mel a̠d̠igh d̠a̠ ogugua̠-amu̠m ma̠ a̠d̠a̠ma̠ osira̠-epobh, i̠na ko o̠nu̠r d̠o̠ agi̠ ka̠ ato̠ro̠n ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ya̠a̠ awa irue d̠o̠ ma̠ o̠wo̠ran a̠pura̠n onon. ");
INSERT INTO mgj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Igiel bho̠ i̠na abi̠gh a̠d̠ien agu̠o̠ ogbo ya̠ iru d̠a̠ o̠d̠e̠ bho̠ na̠ e̠so̠n ra̠dila̠de edim na̠ e̠ro̠ d̠a̠ akpata-od̠e bho̠, sa̠ i̠na a̠rogh a̠sidogh onon a̠nigha̠ awa: ");
INSERT INTO mgj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ku̠gba ma̠ o̠ni̠ a̠lebh anwa ma̠ o̠gi̠ d̠a̠ o̠d̠e̠ erogh, ko o̠so̠n a̠dila̠de edim aro̠; ka̠din olebh ani̠ ma̠ o̠ni̠ ola̠ abu̠gh e̠mi̠ a̠pu nyam. ");
INSERT INTO mgj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ku̠gba ma̠ oku̠a, sa̠ o̠ni̠ wa̠ a̠lebh inyin bho̠ ta̠ a̠ru ra̠ ate̠i̠ anwa a̠fugh ma̠a̠, ‘B̠etina̠ d̠a̠ a̠dila̠de d̠oyom ma̠ a̠nigha̠ ma̠ o̠ni̠ onon.’ Obhel o̠ku̠a, sa̠ ari̠ghe̠l ta̠ esibh anwa, sa̠ anwa ta̠ a̠kpon bo̠ agi̠ ka̠ aro̠ ma̠ esi ola̠ aki̠r edim. ");
INSERT INTO mgj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ya̠a̠, ku̠gba ma̠ o̠ni̠ a̠lebh anwa, gi̠e̠ ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ esi wa̠ aki̠r edim a̠pu bho̠, b̠o̠ka̠ igiel o̠ni̠ wa̠ a̠lebh anwa bho̠ ta̠ a̠ru, i̠na a̠fugh a̠nigha̠ nyam ma̠a̠, ‘A̠tologha̠n, b̠etina̠ ma̠ a̠bhun ka̠ aro̠ d̠a̠ a̠dila̠de ola̠ a̠bhon a̠pu ma̠ onon.’ Sa̠ anwa ta̠ a̠d̠igh edim d̠a̠ esa̠d̠io eb̠la̠ a̠nwunom iyed̠i ya̠ ulebh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ezin bho̠, ogbo ya̠ i̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu d̠awa bho̠, ta̠ o̠ki̠ri̠me̠ni̠; ya̠a̠, ogbo ya̠ i̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu d̠awa bho̠, ta̠ o̠bu̠ghu̠me̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ o̠ni̠ wa̠ a̠nwuna̠ ma̠ otu bho̠, wa̠ a̠lebh i̠na bho̠ ma̠a̠, “Igiel anwa na̠ a̠soroni ma̠ o̠d̠e̠, a̠d̠igh etita̠n bo̠d̠o̠ a̠dule, ko olebh ra̠tologha̠n d̠oyom, na̠ a̠rumor d̠oyom, bo̠d̠o̠ aru̠marani̠ d̠oyom, na̠ ogbo a̠ghisia̠n, bo̠d̠o̠ aru̠li̠la eghighira̠ d̠oyom. Ka̠ anwa igir o̠ku̠a, awa ta̠ emula̠ elebh ani̠ nyam e̠kpe̠, sa̠ obha̠ ta̠ aro̠ ma̠ eb̠la̠ amu̠kpe̠ d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yaa̠, igiel anwa na̠ a̠soroni ma̠ o̠d̠e̠, lebhe ma̠ ronyigoiny bho̠, na̠ ogbo ya̠ a̠risisi ozu na̠ e̠kpari̠an bho̠, na̠ a̠rukula̠ bho̠, na̠ ogbo ya̠ a̠rid̠ien na̠ eb̠omia̠n bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","sa̠ anwa ta̠ ate̠i̠ itutumeni. Awa ko orue d̠o̠ e̠kpe̠ nyam emulumeni; ya̠a̠, ta̠ o̠kpe̠ nyam d̠a̠ igiel ob̠etina̠ d̠a̠ omugh i̠b̠ab̠alab̠ab̠ala bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Igiel bho̠ odi o̠ni̠ ola̠ aro̠ ani̠ d̠a̠ akpata-od̠e bho̠ amu̠gho̠n abar onon bho̠, sa̠ i̠na a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “Itutumeni od̠i na̠ i̠na o̠ni̠ wa̠ ta̠ ad̠e̠ ma̠ o̠d̠e̠ d̠a̠ esi irileghom ta̠ A̠zib̠a̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Odi o̠ni̠ a̠kokod̠ia̠n osoroni obom o̠d̠e̠ sa̠ a̠lebh a̠d̠izo a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ate̠i̠ obhel o̠d̠e̠ bho̠, sa̠ i̠na a̠ruom ob̠a̠ra̠motu d̠o̠yo̠ ma̠ o̠gba onigha̠ ogbo ya̠ i̠na a̠lebh bho̠ ma̠a̠, ‘Itue, ezin bho̠ na̠ okokod̠i̠an kabarkabar ola̠ a̠gboloma̠ ma̠ o̠d̠e̠ bho̠ oguri.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ya̠a̠, eb̠la̠ awa sa̠ i̠ke̠ ma̠ omutioghom reb̠ologuma̠ ya̠ awa ko orue d̠o̠ e̠gi̠ d̠a̠ o̠d̠e̠ bho̠. O̠pu̠r bho̠ agba ma̠a̠, ‘I̠se̠n kisa̠ ami̠ igho ma̠ egbolom, sa̠ a̠bhon ami̠ ma̠ o̠gi̠ ka̠ o̠bi̠gh esi bho̠. Ko o̠gam, ami̠ ko orue d̠o̠ a̠ru.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Wa̠leghemeni i̠wal bho̠ sa̠ agba ma̠a̠, ‘I̠se̠n kisa̠ ami̠ igho ma̠ o̠gho̠ etire anam-ogir, ami̠ ta̠ agi̠ ka̠ ad̠a awa a̠kpon. Ko o̠gam, ami̠ ko orue d̠o̠ a̠ru.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Wa̠leghemeni i̠sar bho̠ sa̠ agba ma̠a̠, ‘I̠se̠n kisa̠ ami̠ ibhin ani̠, ebula̠ o̠ku̠a, ami̠ ko orue d̠o̠ a̠ru.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Sa̠ ob̠a̠ra̠motu d̠o̠yo̠ a̠mula̠ agi̠ ka̠ agba a̠nigha̠ ma̠ wa̠nwuna̠ i̠na bho̠ ma̠ agu̠o̠ awa i̠wo̠ran bho̠. Sa̠ ologi ta̠ wa̠nwuna̠ ma̠ otu bho̠ a̠gurom, sa̠ i̠na a̠bhin d̠a̠ i̠gam bho̠ a̠ruom ob̠a̠ra̠motu d̠o̠yo̠ ma̠a̠, ‘Nu̠re̠ ma̠ a̠ten agi̠ ka̠ a̠d̠igh d̠a̠ reten bho̠, na̠ d̠a̠ reten-a̠kposi bho̠, ma̠ a̠gun ronyigoiny bho̠, ogbo ya̠ a̠risisi ozu na̠ e̠kpari̠an bho̠, a̠nwunom ya̠ ikpom a̠rid̠ien bho̠, na̠ a̠rukula̠ bho̠ ma̠ a̠ru.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Sa̠ ob̠a̠ra̠motu bho̠ a̠mula̠ a̠ru ra̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Wa̠nwuna̠, ami̠ na̠ a̠gir agu̠o̠ anwa iruom ami̠ bho̠, ya̠a̠ esi bho̠ ta̠ omuzo d̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Sa̠ wa̠nwuna̠ ma̠ otu bho̠ agba a̠nigha̠ ma̠ ob̠a̠ra̠motu d̠o̠yo̠ ma̠a̠, ‘Tene ma̠ agi̠ ka̠ a̠d̠igh d̠a̠ ibom reten bho̠, na̠ reten d̠a̠ eb̠la̠ eghighira̠ bho̠, ma̠ a̠wia̠n a̠d̠ighi ma̠ agu̠o̠ ola̠ awa ta̠ ed̠igh eru, b̠o̠ka̠ otu d̠ami̠ a̠muzo. ");
INSERT INTO mgj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, bebina̠ o̠ni̠ d̠a̠ ogbo ya̠ ulebh bho̠ ko od̠igh d̠o̠ ad̠e̠d̠i̠ma ma̠ o̠d̠e̠ d̠ami̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","I̠se̠n obom o̠lo̠gh a̠nwunom id̠igh na̠ A̠zizo̠s na̠ e̠gi̠ ma̠ e̠gi̠ bho̠, sa̠ i̠na a̠tiba̠ra̠ a̠kpon awa a̠fugh ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ku̠gba ma̠ o̠ni̠ a̠ru d̠ami̠, sa̠ o̠ni̠ bho̠ otula̠n d̠o̠ ami̠ a̠pu ma̠ o̠we̠de̠ d̠o̠yo̠, na̠ onweni d̠o̠yo̠, na̠ ani̠ d̠o̠yo̠, na̠ anwi̠i̠ny d̠o̠yo̠, a̠rumor na̠ aru̠marani̠ d̠o̠yo̠, na̠ a̠ghud̠um d̠o̠yo̠, o̠ni̠ ola̠ o̠ku̠a ko orue d̠o̠ aro̠ ma̠ o̠ni̠ atu̠ghan d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O̠ni̠ ola̠ ko orue d̠o̠ a̠rol e̠mi̠gi̠re̠ni̠an oriren d̠o̠yo̠ atu̠o̠no̠m ami̠, ko orue d̠o̠ aro̠ ma̠ o̠ni̠ atu̠ghan d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Obhin o̠tu̠o̠m ma̠ na̠ ebhir odi o̠ni̠ inyin ma̠ olo owewegh otu-ipoiny, o̠ni̠ bho̠ ko od̠ia̠ d̠o̠ aro̠ ma̠ a̠dila̠de awal a̠b̠ua̠ i̠di̠ar bho̠ a̠kpon, ma̠ ologhom ka̠ i̠na ate̠i̠ ikpoki ya̠ ta̠ elei obhin omunieni ogir bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ezin bho̠, ka̠ anwa i̠ke̠ ma̠ ozu o̠de̠-otu bho̠, sa̠ anwa orue d̠o̠ ma̠ omunieni, ko̠ni̠ko̠ni̠ ola̠ abi̠gh o̠ku̠a ta̠ aki̠ri̠ nyam, ");
INSERT INTO mgj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a̠fugh ma̠a̠, ‘O̠ni̠ onon ake̠ ma̠ olo otu, ya̠a̠ i̠na na̠ orue d̠o̠ ma̠ omunieni.’ ");
INSERT INTO mgj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Bo̠d̠o̠, obhin o̠tu̠o̠m o̠li̠la ebhugh ola̠ na̠ agi̠ ka̠ owe e̠gham ma̠ o̠li̠la opa̠n ebhugh. I̠na ko od̠ia̠ d̠o̠ aro̠ ma̠ a̠dila̠de awal a̠kpon ka̠ i̠na ta̠ a̠rue a̠bhin o̠lo̠gh e̠gham a̠d̠usubh na̠ ogho o̠ni̠r (10,000) o̠ni̠ d̠o̠yo̠, adama ma̠ i̠na wa̠ na̠ a̠bhin o̠lo̠gh e̠gham eruba̠l na̠ d̠iobh o̠ni̠r (20,000) o̠ni̠, na̠ a̠ru ra̠ owe o̠yo̠ bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ku̠gba ma̠ i̠na ko orue d̠o̠, sa̠ i̠na ta̠ ato̠ ma̠ a̠nwunom ma̠ o̠gi̠ ka̠ o̠te̠i̠ o̠li̠la ebhugh uwed̠i ma̠ obhel ola̠ o̠lo̠gh e̠gham d̠o̠yo̠ od̠id̠ia̠ ma̠ esi egbeiny. Sa̠ i̠na ta̠ a̠puru ma̠ o̠b̠e̠re̠gi̠an omutiom ekima̠ d̠a̠ esa̠d̠io d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Onin agu̠o̠ bho̠, o̠ni̠ ko orue d̠o̠ aro̠ ma̠ o̠ni̠ atu̠ghan d̠ami̠, a̠ten ka̠ i̠na ta̠ a̠rue awe̠le̠man eb̠la̠ i̠di̠ar ya̠ i̠na a̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ub̠on ob̠eb̠i abar, ya̠a̠, ku̠gba ma̠ ub̠on bho̠ na̠ a̠robh a̠lisibh d̠o̠yo̠, ka̠ ub̠on bho̠ ta̠ a̠d̠ighi eka̠ a̠mula̠ ate̠i̠ a̠lisibh d̠o̠yo̠? ");
INSERT INTO mgj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ub̠on ya̠ o̠ku̠a ibhon d̠o̠ ma̠ od̠i d̠a̠ a̠de, bo̠d̠o̠ oguri d̠a̠ esi ola̠ na̠ okpol a̠b̠uruko nyen; ya̠a̠ ta̠ ozu orobh. “Wa̠ a̠nwuna̠ ma̠ a̠to ma̠ o̠mu̠gho̠n, i̠na amu̠gho̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Odi a̠d̠a̠ma̠, igun ma̠ otua̠-ebhugh na̠ id̠ighi ma̠ i̠karabh a̠nwunom na̠ ekokod̠ia̠n na̠ ekin A̠zizo̠s ma̠ o̠nagha atu̠ghu̠me̠ni̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ya̠a̠ a̠nwunom Afarisi bho̠ na̠ ogbo atu̠ghu̠me̠ni̠ oloko ta̠ A̠mozizi bho̠, i̠ro̠ ma̠ i̠se̠ na̠ eghunuma̠ ma̠a̠, “O̠ni̠ onon na̠ ada ma̠ id̠ighi ma̠ i̠karabh na̠ a̠bhin, sa̠ i̠na na̠ a̠d̠igh na̠ awa na̠ a̠d̠ed̠ia̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sa̠ A̠zizo̠s a̠rogh a̠sidogh onon a̠nigha̠ awa ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Obhin o̠tu̠o̠m ma̠ odi o̠ni̠ inyin a̠nwuna̠ ma̠ o̠lo̠gh ro̠nana ya̠ ilei i̠wal e̠wala na̠ a̠d̠usubh (100), sa̠ odi o̠nana bho̠ a̠bhe, i̠na ko o̠we̠le̠ d̠o̠ ma̠ i̠wal e̠wala na̠ d̠iobh na̠ esugho (99) ro̠nana iyed̠i d̠a̠ e̠sala bho̠, agi̠ ka̠ abho̠ro̠ghan o̠nana wa̠ a̠bhe bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Igiel i̠na abi̠gh o̠nana bho̠, i̠na ta̠ a̠bhin a̠libhon ologi a̠b̠eton o̠nana bho̠ ale̠ti̠an d̠a̠ o̠kpalu̠ma d̠o̠yo̠ a̠rol a̠bhin a̠yel. ");
INSERT INTO mgj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Igiel i̠na na̠ a̠misi d̠a̠ otu, i̠na ta̠ a̠kokod̠i ma̠ ra̠tologha̠n d̠o̠yo̠, na̠ ogbo ya̠ na̠ erugh na̠ etua̠n i̠na bho̠ agba ma̠a̠, ‘Id̠ighe na̠ ami̠ ma̠ ebhon ologi, ezin bho̠, ami̠ na̠ abi̠gh o̠nana d̠ami̠ wa̠ a̠bhe bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, onin agu̠o̠ bho̠ ibo d̠a̠ ote̠nai̠ny d̠a̠ ebula̠ onin od̠ighi ma̠ i̠karabh o̠ni̠ ola̠ a̠tiba̠ra̠, ta̠ epu ma̠ ibo d̠a̠ ebula̠ i̠wal e̠wala na̠ d̠iobh na̠ esugho (99) a̠nwunom ya̠ na̠ e̠b̠ab̠ala bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Bo̠d̠o̠, ani̠ ola̠ a̠nwuna̠ ma̠ d̠iobh adrakma sa̠ odi a̠bhe. I̠na ko o̠su̠o̠m d̠o̠ ma̠ ato̠di̠, a̠gber otu bho̠, a̠bhin obhel abho̠ro̠ghan tu̠tu̠n i̠na ta̠ abi̠gh ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Igiel i̠na abi̠gh okpoki bho̠, i̠na ta̠ a̠bhelegi ma̠ ra̠tologha̠n d̠o̠yo̠, na̠ ogbo ya̠ na̠ erugh na̠ etua̠n i̠na bho̠ agba ma̠a̠, ‘Id̠ighe na̠ ami̠ ma̠ ebhon ologi, ezin bho̠ ami̠ na̠ abi̠gh okpoki d̠ami̠ wa̠ a̠bhe bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Onin agu̠o̠ bho̠, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ibo od̠i d̠a̠ esa̠d̠io itileduom ta̠ A̠zib̠a̠, ka̠ od̠ighi ma̠ i̠karabh o̠ni̠ a̠tiba̠ra̠.” ");
INSERT INTO mgj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sa̠ A̠zizo̠s a̠rogh opa̠n a̠sidogh amar agba a̠mutiom ma̠a̠, “Odi o̠ni̠ aro̠ ma̠ ola̠ a̠nwuna̠ i̠wal anwi̠i̠ny. ");
INSERT INTO mgj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sa̠ o̠gbara bho̠ a̠fugh a̠nigha̠ ma̠ o̠we̠de̠ d̠awa ma̠a̠, ‘O̠we̠de̠ d̠ami̠, ru̠gi̠ ma̠ ad̠i̠a d̠oyom ma̠ a̠nigha̠ ami̠ ma̠ a̠bin d̠ami̠.’ Sa̠ o̠we̠de̠ bho̠ aru̠gi̠ ma̠ i̠di̠ar ya̠ i̠na a̠nwuna̠ bho̠ a̠nigha̠ ma̠ i̠wal awa. ");
INSERT INTO mgj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Na̠ obia̠ d̠o̠, sa̠ o̠gbara bho̠ a̠kokod̠i ma̠ eb̠la̠ i̠di̠ar d̠o̠yo̠, sa̠ a̠bhin a̠b̠etina̠ ma̠ e̠gi̠ d̠a̠ opa̠n ebhugh ola̠ a̠gbeiny, sa̠ a̠rugh ado̠l i̠te̠i̠ a̠d̠e ma̠ eb̠la̠ e̠li̠la d̠o̠yo̠ ma̠ iyobh. ");
INSERT INTO mgj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Igiel bho̠ i̠na na̠ a̠d̠e ma̠ eb̠la̠ ikpoki d̠o̠yo̠ amado̠n bho̠, sa̠ o̠ko̠i̠ ed̠ia̠n a̠sor d̠a̠ eb̠la̠ ebhugh bho̠, sa̠ e̠kparama ado̠l ate̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ebula̠ o̠ku̠a sa̠ i̠na agi̠ ka̠ ate̠i̠ odi o̠nyi̠ eghun ebhugh bho̠, ma̠ onigha̠ o̠yo̠ ma̠ ogir. Sa̠ o̠ni̠ bho̠ a̠ruom i̠na ma̠ o̠gi̠ ka̠ okponom roporopo d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa̠, o̠ko̠i̠ a̠d̠ighi i̠na ate̠i̠ esi ola̠, i̠na ra̠ a̠nwuna̠ ma̠ e̠d̠o̠gh od̠e ani̠ ed̠ia̠n ya̠ roporopo bho̠ na̠ ed̠e bho̠, ya̠a̠ o̠ni̠ ola̠ a̠nigha̠ i̠na bebina̠ abar od̠e na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Igiel bho̠ i̠na ra̠ a̠loghoma̠n ozu bho̠, sa̠ i̠na ma̠a̠, ‘I̠ni̠ ma̠ rob̠a̠ra̠motu ya̠ o̠we̠de̠ d̠ami̠ ako̠ ma̠ ogir ogir onigha̠ o̠yo̠, ya̠ o̠te̠i̠ d̠o̠ ma̠ ed̠ia̠n ed̠e esughieni bho̠? Ya̠a̠ ami̠ od̠i ma̠ enen na̠ a̠mugh o̠ko̠i̠! ");
INSERT INTO mgj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ami̠ ta̠ a̠ten a̠yel ka̠ ate̠i̠ o̠we̠de̠ d̠ami̠ a̠fugh a̠nigha̠ i̠na ma̠a̠: O̠we̠de̠, ami̠ na̠ a̠gir i̠karabh a̠gboloma̠ ma̠ anwa na̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ami̠ i̠kpe̠ mu̠ ma̠ o̠ro̠ o̠nyi̠ d̠oyom. Bhine ami̠ ma̠ a̠guri ma̠ agu̠o̠ odi ob̠a̠ra̠motu ola̠ anwa i̠ko̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sa̠ i̠na a̠b̠etina̠ agi̠ ka̠ ate̠i̠ o̠we̠de̠ d̠o̠yo̠. “I̠na od̠id̠ia̠ ma̠ esi egbeiny sa̠ o̠we̠de̠ d̠o̠yo̠ abi̠gh ka̠ i̠na na̠ a̠ru, sa̠ igbirigbir na̠ etula̠n o̠nyi̠ bho̠ isibh i̠na, sa̠ i̠na a̠ghil agi̠ ka̠ ate̠i̠ o̠nyi̠ bho̠ sa̠ a̠b̠ola̠n i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Sa̠ o̠nyi̠ bho̠ a̠fugh a̠nigha̠ ma̠ o̠we̠de̠ d̠o̠yo̠ ma̠a̠, ‘O̠we̠de̠, ami̠ na̠ a̠gir i̠karabh a̠gboloma̠ ma̠ anwa na̠ ote̠nai̠ny. Ami̠ i̠kpe̠ mu̠ ma̠ o̠ro̠ o̠nyi̠ d̠oyom.’ ");
INSERT INTO mgj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Sa̠, o̠we̠de̠ bho̠ a̠fugh a̠nigha̠ ma̠ rob̠a̠ra̠motu d̠o̠yo̠ ma̠a̠, ‘I̠nu̠re̠! Ibhine ma̠ akapa wa̠ a̠bhon a̠pu bho̠ ma̠ eburi i̠na, ma̠ e̠lo̠gh a̠gulu d̠a̠ ad̠u̠nu̠ agu̠o̠ d̠o̠yo̠, ma̠ e̠lo̠gi̠ i̠na ma̠ ragbaka. ");
INSERT INTO mgj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ibhine ma̠ e̠nam e̠nu̠m bho̠ ma̠ eru ra̠ egigh, sa̠ ta̠ od̠e ma̠ e̠yal obhon ologi. ");
INSERT INTO mgj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ezin bho̠, o̠nyi̠ d̠ami̠ onon a̠mugh a̠mugha̠ sa̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um i̠se̠n; i̠na a̠bhe a̠bha̠ sa̠ na̠ o̠bi̠gh i̠na ma̠ i̠se̠n.’ Sa̠ awa i̠ke̠ ma̠ od̠e e̠yal bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“D̠a̠ onin obhel wa̠ i̠nye̠n na̠ emite bho̠, okei o̠nyi̠ bho̠ aro̠ d̠a̠ ed̠um na̠ a̠gir ogir. Igiel bho̠ i̠na na̠ a̠mula̠ na̠ a̠yel na̠ a̠tua̠n otu d̠awa bho̠, sa̠ i̠na amu̠gho̠n okoroko a̠ma̠ti na̠ aso̠r na̠ i̠gba. ");
INSERT INTO mgj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sa̠ i̠na a̠bhelegi ma̠ odi ob̠a̠ra̠motu bho̠ a̠pura̠n abar wa̠ na̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sa̠ i̠na awo̠ran ma̠a̠, ‘Umor d̠oyom na̠ a̠mula̠ a̠ru, sa̠ o̠we̠de̠ d̠oyom a̠gigh e̠nam e̠nu̠m bho̠ sa̠ na̠ o̠ghe̠re̠ghu̠o̠m. Ezin bho̠, i̠na na̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um na̠ alu̠kpo̠ a̠luzu.’ ");
INSERT INTO mgj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Sa̠ ologi ta̠ okei umor bho̠ a̠gurom sa̠ i̠na a̠gin od̠igh d̠a̠ ologi otu. Sa̠ o̠we̠de̠ d̠o̠yo̠ a̠mite agi̠ ka̠ ale̠gh i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sa̠, i̠na awo̠ran o̠we̠de̠ d̠o̠yo̠ ma̠a̠, ‘Kpone! Eb̠la̠ rala i̠nye̠n ya̠ ami̠ na̠ a̠gir a̠nigha̠ ma̠ anwa ma̠ agu̠o̠ ogoni bho̠, a̠d̠a̠ma̠ ola̠ ami̠ i̠pi̠o̠m i̠to̠to̠gi̠ d̠oyom na̠ o̠ro̠ d̠o̠. O̠ku̠a eka̠, a̠d̠a̠ma̠ ola̠ anwa inigha̠ ami̠ bebina̠ o̠nyi̠ ewel ola̠ obhin od̠igh na̠ ra̠tologha̠n d̠ami̠ od̠e e̠yal na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ya̠a̠, o̠nyi̠ d̠oyom onon wa̠ agi̠ ka̠ a̠d̠e ma̠ e̠li̠la d̠oyom iyobh na̠ id̠eme̠ma a̠mula̠ a̠ru bho̠, sa̠ anwa igigh e̠nam e̠nu̠m bho̠ inigha̠ i̠na!’ ");
INSERT INTO mgj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Sa̠ o̠we̠de̠ d̠o̠yo̠ a̠fugh a̠nigha̠ i̠na ma̠a̠, ‘O̠nyi̠ d̠ami̠, anwa od̠i na̠ ami̠ ma̠ eb̠la̠ igiel. Kabarkabar ola̠ ami̠ inwuna̠, oloyom. ");
INSERT INTO mgj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Akpe̠ i̠yar od̠e e̠yal obhon ologi. Ezin bho̠, umor d̠oyom onon a̠mugh a̠mugha̠ sa̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um, i̠na a̠bhe a̠bha̠ sa̠ na̠ o̠bi̠gh i̠na.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Odi o̠li̠la aro̠ ma̠ ola̠ a̠guri ma̠ o̠ni̠ ma̠ o̠ro̠ we̠mu̠ ogir d̠o̠yo̠. Sa̠ u̠gba unigha̠ i̠na ma̠a̠ we̠mu̠ ogir d̠o̠yo̠ na̠ a̠rughom i̠di̠ar d̠o̠yo̠ ma̠ ya̠ i̠te̠i̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sa̠ i̠na a̠bhelegi i̠na a̠fugh ma̠a̠, ‘I̠gho̠r i̠nye̠n ya̠ ami̠ na̠ amu̠gho̠n na̠ a̠gboloma̠ nyam bho̠, ka̠ imite eka̠? Gba ma̠ a̠mutiom ma̠ agu̠o̠ anwa na̠ a̠bhin na̠ a̠rileghom ogir d̠ami̠, ezin bho̠, anwa ko orileghom mu ma̠ ogir bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Sa̠ we̠mu̠ ogir bho̠ aru̠ru̠an d̠a̠ ologi d̠o̠yo̠ ma̠a̠, ‘Ami̠ ta̠ a̠d̠ighi eka̠ ma̠ i̠se̠n wa̠ wa̠nwuna̠ d̠ami̠ na̠ asi̠ghe̠ ma̠ ogir bho̠ d̠a̠ agu̠o̠ d̠ami̠ bho̠? Ami̠ i̠te̠i̠ d̠o̠ ma̠ a̠limon ogbo a̠de, sa̠ ari̠ghe̠l na̠ esibh ami̠ ma̠ opuru ipupuru. ");
INSERT INTO mgj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ami̠ na̠ a̠loghom abar ami̠ ta̠ a̠gir, b̠o̠ka̠ igiel uze ami̠ d̠a̠ ogir bho̠, a̠nwunom e̠da ami̠ ed̠ighom d̠a̠ a̠rutu d̠awa.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ebula̠ o̠ku̠a, sa̠ i̠na a̠lebh eb̠la̠ ogbo ya̠ id̠ikighu i̠mu̠gh d̠a̠ agu̠o̠ ta̠ wa̠nwuna̠ d̠o̠yo̠ bho̠ ma̠ oru. Sa̠ i̠na a̠pura̠n o̠pu̠r bho̠ ma̠a̠, ‘I̠mu̠gh ya̠ anwa id̠igh d̠a̠ agu̠o̠ ta̠ wa̠nwuna̠ d̠ami̠ bho̠ ka̠ i̠ni̠?’ ");
INSERT INTO mgj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Sa̠ o̠ni̠ bho̠ awo̠ran ma̠a̠, ‘I̠wal e̠wala na̠ a̠d̠usubh a̠tini amu̠nu̠ oliv.’ “Sa̠ we̠mu̠ ogir bho̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Bhine ma̠ a̠d̠ire o̠mu̠gh d̠oyom, ma̠ anu̠r aro̠ ma̠ a̠dila̠de, ma̠ a̠nwe ma̠ age̠ ma̠ eruba̠l na̠ d̠iobh.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Sa̠ i̠na a̠pura̠n oleghemeni i̠wal o̠ni̠ bho̠ ma̠a̠, ‘Anwa ka̠ o̠mu̠gh d̠oyom ka̠ i̠ni̠?’ “Sa̠ o̠ni̠ bho̠ awo̠ran ma̠a̠, ‘I̠wal o̠ni̠r na̠ ogho e̠wala re̠kpa i̠bu̠kpa.’ “Sa̠ we̠mu̠ ogir bho̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Bhine ma̠ a̠d̠ire o̠mu̠gh d̠oyom, ma̠ a̠nwe ma̠ age̠ ma̠ i̠wal o̠ni̠r.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Sa̠ wa̠nwuna̠ ma̠ ogir bho̠ ase̠bh oniniom ma̠ a̠niniom we̠mu̠ ogir bho̠, d̠a̠ ebula̠ agu̠o̠ i̠na a̠bhin a̠koiny ikoiny bho̠. Ezin bho̠, a̠nwunom e̠mara̠nwunom onon na̠ ekoiny na̠ egboloma̠ ma̠ a̠nwunom amu̠m d̠awa na̠ epu ma̠ agu̠o̠ anwi̠i̠ny e̠b̠alab̠al na̠ erughom e̠ne̠ghe̠ d̠awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ibhine ma̠ e̠li̠la e̠mara̠nwunom e̠te̠i̠ ra̠tologha̠n iya̠ inyin, b̠o̠ka̠ igiel e̠li̠la d̠inyin na̠ ekun, od̠ighom inyin d̠a̠ a̠rutu esul ya̠ ekunuguma̠ o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“O̠ni̠ ola̠ na̠ a̠rugh ya̠ igielake̠ d̠a̠ i̠gbara i̠di̠ar, ta̠ a̠rugh ya̠ igielake̠ d̠a̠ ibom i̠di̠ar. Ya̠a̠, o̠ni̠ a̠niniom d̠a̠ i̠gbara i̠di̠ar, ta̠ a̠niniom d̠a̠ ibom i̠di̠ar nyen. ");
INSERT INTO mgj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","O̠ku̠a a̠d̠ighi be̠le̠ni, ku̠gba ma̠ inyin ta̠ orue d̠o̠ ma̠ obhin d̠a̠ igielake̠ orileghom e̠li̠la e̠mara̠nwunom, ka̠ a̠nyen ta̠ a̠nigha̠ inyin a̠ga̠i e̠li̠la ma̠ okponom? ");
INSERT INTO mgj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sa̠, ku̠gba ma̠ inyin urue d̠o̠ ma̠ obhin d̠a̠ igielake̠ okponom i̠di̠ar opa̠n o̠ni̠, ka̠ a̠nyen ta̠ a̠nigha̠ inyin i̠di̠ar iya̠ inyin? ");
INSERT INTO mgj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“O̠ni̠ ola̠ ta̠ a̠rue aro̠ ma̠ ob̠a̠ra̠motu a̠nigha̠ ma̠ i̠wal a̠nwunom ya̠ inwuna̠ i̠na bo̠. O̠ni̠ ola̠ o̠ku̠a ta̠ alo̠gh a̠d̠ien odi sa̠ i̠na ta̠ a̠tula̠n uwed̠i, bo̠d̠o̠ ta̠ a̠bhin eb̠la̠ ologi d̠o̠yo̠ a̠gir a̠nigha̠ ma̠ odi, sa̠ ta̠ a̠kpon uwed̠i ado̠ti̠me̠ni̠. O̠ni̠ ka̠ orue d̠o̠ aro̠ ma̠ ob̠a̠ra̠motu ta̠ A̠zib̠a̠ na̠ okpoki.” ");
INSERT INTO mgj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Igiel bho̠ Rafarisi ya̠ iba̠ra̠ ma̠ okpoki i̠mu̠gho̠n eb̠la̠ i̠nye̠n bho̠, sa̠ awa i̠ki̠ri̠ ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Inyin na̠ agu̠o̠ na̠ oleriom a̠ruzu d̠inyin ma̠ inyin ib̠eb̠i d̠a̠ a̠misigh a̠nwunom, ya̠a̠ A̠zib̠a̠ a̠loghom rologi d̠inyin. I̠di̠ar ya̠ a̠nwunom na̠ ebhin na̠ e̠tu̠o̠m abar ibom bho̠, i̠nye̠ e̠tu̠tu̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Oloko ta̠ A̠mozizi na̠ i̠di̠ar ya̠ a̠riwil bho̠ i̠ge̠ bho̠ e̠ro̠ erileghom i̠to̠to̠gi̠ bho̠ tu̠tu̠n ate̠i̠ igiel bho̠ Azo̠n a̠ru bho̠. Ob̠eton obhel obha̠, na̠ o̠gba ma̠ ib̠eb̠i asu̠gbagba irileghom ta̠ A̠zib̠a̠ na̠ onigha̠ ma̠ a̠nwunom, sa̠ ko̠ni̠ko̠ni̠ na̠ alo̠gh e̠mi̠ na̠ a̠wia̠n od̠igh d̠a̠ ologi ma̠ onyen. ");
INSERT INTO mgj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A̠b̠ur a̠de na̠ e̠nai̠ny o̠mai̠ny o̠d̠u̠a a̠pu, ma̠ ekpo abar ola̠ u̠ge̠ d̠a̠ oloko bho̠ ma̠ o̠pe̠ti̠na omel obhe. ");
INSERT INTO mgj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“O̠ni̠ ola̠ a̠gbogina̠ ma̠ ani̠ d̠o̠yo̠ sa̠ agi̠ ka̠ a̠bhin opa̠n ani̠ a̠sor oloko od̠e e̠ma, sa̠ o̠ni̠ wa̠ agi̠ ka̠ a̠bhin ani̠ wa̠ owolom a̠gbogina̠ bho̠ eka̠, a̠sor oloko od̠e e̠ma.” ");
INSERT INTO mgj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Odi o̠li̠la o̠ni̠ aro̠ ma̠ ola̠ a̠bhin ib̠eb̠i a̠rukpe ododo na̠ asi̠ni̠ni̠n a̠bura̠ gha̠n ibura̠ d̠o̠yo̠, sa̠ a̠duduga̠na̠ a̠d̠e ma̠ e̠li̠la ka̠d̠a̠ma̠ ka̠d̠a̠ma̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Odi onyigoiny o̠ni̠ ola̠ ubhelegi ma̠ Alazaro̠s eka̠ aro̠, ola̠ re̠b̠e̠ imuzo d̠a̠ ozu bho̠, ola̠ ubhin gha̠n uru d̠a̠ o̠nu̠ ogigo o̠li̠la bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sa̠ ibhir i̠na ma̠ okpokpo i̠pe̠re̠pe̠r ed̠ia̠n ya̠ na̠ emeleghu d̠a̠ akpata-od̠e o̠li̠la bho̠ od̠e. A̠sib̠ogho eka̠ e̠gi̠ ghan ka̠ e̠lai̠ re̠b̠e̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ekunuguma̠ bho̠, sa̠ onyigoiny bho̠ a̠mugh, sa̠ itileduom ta̠ A̠zib̠a̠ irileghom i̠na ka̠ id̠ighom d̠a̠ agba ta̠ Ebraham. O̠li̠la bho̠ eka̠ sa̠ a̠mugh, sa̠ ud̠i i̠na, ");
INSERT INTO mgj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","sa̠ e̠mu̠gh d̠o̠yo̠ agi̠ d̠a̠ e̠ma imumugh. D̠a̠ esa̠d̠io ibom ali̠gam a̠ruzu ya̠ i̠te̠i̠ i̠na bho̠, sa̠ i̠na a̠kpon d̠a̠ anyu̠ abi̠gh Ebraham esi egbeiny na̠ Alazaro̠s d̠a̠ aka d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sa̠ o̠li̠la bho̠ a̠kele ma̠ Ebraham ma̠a̠, ‘E O̠we̠de̠ Ebraham, kpone ami̠ ma̠ igbirigbir, ma̠ a̠ruom Alazaro̠s ato̠ri̠ ma̠ ad̠u̠nu̠ agu̠o̠ d̠o̠yo̠ d̠a̠ amu̠m ra̠ a̠b̠okumeni ma̠ a̠nem d̠ami̠. Ezin bho̠, ami̠ od̠i d̠a̠ obom ali̠gam a̠luzu d̠a̠ ologi e̠banya onon.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ya̠a̠ Ebraham awo̠ran ma̠a̠, ‘O̠nyi̠ ru̠ru̠ane̠ ma̠a̠, d̠a̠ a̠ghud̠um d̠oyom d̠a̠ e̠mara̠nwunom, anwa i̠te̠i̠ ib̠eb̠i i̠di̠ar, ya̠a̠ Alazaro̠s ate̠i̠ i̠karabh sa̠ a̠gbika̠ ma̠ egbika̠. Ya̠a̠ i̠se̠n, i̠na od̠i d̠a̠ e̠no̠gho̠man enen, ya̠a̠ anwa od̠i d̠a̠ ali̠gam a̠luzu na̠ a̠gbika̠. ");
INSERT INTO mgj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","O̠ku̠a ku̠ku̠m d̠o̠, obom okud̠umkud̠um oghololo od̠i d̠a̠ esa̠d̠io d̠inyin na̠ d̠i̠yar, b̠o̠ka̠ ogbo ya̠ na̠ ebhir o̠d̠u̠a d̠inyin o̠b̠e̠i̠y oru d̠i̠yar irue; o̠ni̠ ko orue d̠o̠ ad̠u̠a ma̠ ebha̠ d̠inyin ab̠e̠i̠ a̠ru ma̠ enen d̠i̠yar.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Sa̠ o̠li̠la bho̠ awo̠ran ma̠a̠, ‘Siseiny O̠we̠de̠ Ebraham, ruome ma̠ Alazaro̠s agi̠ ka̠ ate̠i̠ eghun-otu o̠we̠de̠ d̠ami̠, ");
INSERT INTO mgj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ezin bho̠ ami̠ inwuna̠ ogho a̠rumor. I̠na agi̠ ka̠ anyagh ra̠to d̠awa, b̠o̠ka̠ awa eka̠ iru d̠a̠ esi onon wa̠ ibom ali̠gam a̠ruzu od̠i bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Sa̠ Ebraham awo̠ran ma̠a̠, ‘A̠mozizi na̠ a̠riwil bho̠ od̠i na̠ awa. Awa e̠nagha ma̠ a̠kikiom d̠awa.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Sa̠ o̠li̠la bho̠ awo̠ran ma̠a̠, ‘E̠nyi̠, E o̠we̠de̠ Ebraham! Ku̠gba ma̠ o̠ni̠ ad̠u̠a ma̠ enen d̠a̠ e̠ma imumugh agi̠ ka̠ ate̠i̠ awa, awa ta̠ ed̠umom etiba̠ra̠ d̠a̠ i̠karabh.’ ");
INSERT INTO mgj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Sa̠ Ebraham awo̠ran i̠na ma̠a̠, ‘Ku̠gba ma̠ awa i̠nagha d̠o̠ ma̠ A̠mozizi na̠ a̠riwil bho̠, o̠ni̠ a̠b̠etina̠ eka̠ d̠a̠ omugh agi̠ ka̠ ate̠i̠ awa, awa ko od̠umom d̠o̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Ad̠agi̠an ya̠ ta̠ ed̠ighi ma̠ a̠nwunom ma̠ omel od̠igh d̠a̠ i̠karabh ko o̠we̠le̠ d̠o̠ ma̠ omite; ya̠a̠, itogi e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ ad̠agi̠an i̠nye̠ ta̠ e̠wo̠l emite bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","O̠gho̠ro̠gi̠o̠m obom o̠gbe̠o̠ma d̠a̠ orum o̠ni̠ ola̠ o̠ku̠a orobh o̠yo̠ d̠a̠ abadi̠, ta̠ a̠bhon a̠pu ma̠ o̠ni̠ bho̠ ma̠ od̠ighi ola̠ odi o̠gbara o̠nyi̠ i̠se̠ ta̠ a̠mel a̠d̠igh d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠mare̠ ma̠ ekpona̠ ma̠ a̠ruzu d̠inyin. “Ku̠gba ma̠ umor d̠oyom, bo̠d̠o̠ u̠marani̠ d̠oyom a̠d̠ighi nyam ma̠ i̠karabh, kikiome̠ i̠na; ka̠ i̠na a̠tiba̠ra̠ d̠a̠ i̠karabh d̠o̠yo̠, kpone i̠na ma̠ asi̠ghe̠ ma̠ a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ku̠gba ma̠ o̠ni̠ obha̠ a̠d̠ighi nyam i̠karabh ma̠ od̠ua̠l igiel d̠a̠ e̠mu̠ a̠d̠a̠ma̠ eka̠, sa̠ a̠mula̠ a̠ru ra̠ a̠siseiny anwa ma̠ od̠ua̠l igiel sa̠ a̠fugh ma̠a̠, ‘Ami̠ na̠ a̠tiba̠ra̠ d̠a̠ i̠karabh d̠ami̠,’ kpone i̠na ma̠ asi̠ghe̠ ma̠ a̠d̠ien.” ");
INSERT INTO mgj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sa̠ ogbo ogir bho̠ ifugh inigha̠ ma̠ Wa̠nwuna̠ bho̠ ma̠a̠, “Bu̠ghu̠me̠ni̠ ma̠ ologi ima̠ra̠ d̠i̠yar!” ");
INSERT INTO mgj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sa̠ I̠na awo̠ran ma̠a̠, “Ka̠ inyin u̠te̠i̠ ologi ima̠ra̠ ola̠ aki̠r ka̠ ekpo amu̠stad, inyin ta̠ orue ofugh onigha̠ ma̠ obom oriren onon ma̠a̠, ‘B̠uruna̠ ma̠ ka̠ a̠gbebha̠n d̠a̠ abadi̠,’ sa̠ oriren bho̠ ta̠ anagha ma̠ o̠nu̠o̠kpe̠ d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A̠nyen o̠ni̠ inyin ola̠ a̠nwuna̠ ma̠ ob̠a̠ra̠motu ola̠ na̠ a̠d̠ighi ma̠ ari̠si̠, bo̠d̠o̠ na̠ a̠kponom ro̠nana, sa̠ ka̠ i̠na a̠mutiom a̠ru, wa̠nwuna̠ bho̠ ta̠ a̠fugh ma̠a̠, ‘Dighe ma̠ a̠ru ra̠ a̠d̠e ma̠ abar ke̠re̠’? ");
INSERT INTO mgj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","E̠nyi̠, i̠na ko ofugh d̠o̠ ma̠ o̠ku̠a. I̠na ta̠ a̠fugh ma̠a̠, ‘D̠ighi ma̠ ed̠ia̠n a̠dule d̠ami̠ ma̠ a̠nigha̠ ami̠; ma̠ a̠kokod̠ia̠n aro̠ ma̠ a̠b̠a̠ra̠ ami̠ ta̠ a̠d̠e ad̠a. Igiel ami̠ na̠ a̠d̠e awe̠le̠ ka̠ ma̠ a̠d̠e ma̠ ad̠a ma̠ itoyom’? ");
INSERT INTO mgj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ta̠ a̠sora̠n wa̠nwuna̠ ma̠ ob̠a̠ra̠motu bho̠ ma̠ o̠se̠bh o̠yo̠ d̠a̠ rogir ya̠ uruom i̠na ma̠ ogir bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onin agu̠o̠ bho̠, igiel inyin ugir eb̠la̠ i̠di̠ar ya̠ uruom inyin ogir bho̠, inyin ta̠ ofugh ma̠a̠, ‘I̠yar ibhobho i̠kpo̠ ib̠a̠ra̠motu; i̠yar ugir i̠di̠ar ya̠ i̠kpe̠ i̠yar ogir bho̠ ku̠ku̠m.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Igiel bho̠ A̠zizo̠s na̠ a̠ten na̠ agi̠ d̠a̠ A̠zeruse̠le̠m bho̠, i̠na awo̠l d̠a̠ o̠gbaki̠ Asameria̠ na̠ Agalili. ");
INSERT INTO mgj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Igiel bho̠ i̠na na̠ a̠tua̠n od̠igh d̠a̠ odi o̠gbara e̠ma bho̠, sa̠ d̠iobh a̠nwunom ya̠ na̠ e̠nwe̠r asu̠nwe̠r ekid̠igh i̠gi̠ ka̠ i̠te̠i̠ i̠na. Awa i̠mara ma̠ esi ola̠ a̠sigima̠ i̠na, ");
INSERT INTO mgj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sa̠ awa ibhin obom okoroko ikele i̠na ma̠a̠, “A̠zizo̠s, Wa̠nwuna̠, kpone i̠yar igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Igiel bho̠ i̠na abi̠gh awa bho̠ sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “I̠gi̠e̠, ka̠ eleriom a̠ruzu d̠inyin rokur bho̠.” Sa̠ igiel bho̠ awa iten na̠ e̠gi̠ bho̠, sa̠ awa id̠um i̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Igiel bho̠ odi o̠ni̠ awa abi̠gh ma̠ i̠na na̠ a̠d̠um bho̠, sa̠ i̠na a̠mula̠ agi̠ d̠a̠ A̠zizo̠s, na̠ a̠tutumeni ma̠ A̠zib̠a̠ na̠ obom okoroko. ");
INSERT INTO mgj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sa̠ i̠na a̠mel a̠b̠obhia̠n d̠a̠ a̠sike ta̠ A̠zizo̠s ase̠bh i̠na. Ya̠a̠ o̠ni̠ onon ola̠ Asameria̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sa̠ A̠zizo̠s a̠pura̠n ma̠a̠, “Ukoko d̠o̠ ma̠ a̠d̠iobh a̠nwunom o̠b̠ab̠alame̠ni̠ ke̠re̠? Ya̠a̠, iken esugho a̠nwunom iyed̠i? ");
INSERT INTO mgj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ka̠ na̠ a̠ten isuloma̠ onon, o̠ni̠ awa ola̠ na̠ a̠mula̠ a̠ru ma̠ ra̠ onigha̠ A̠zib̠a̠ ma̠ itutumeni bo̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sa̠ i̠na a̠fugh a̠nigha̠ i̠na ma̠a̠, “B̠etina̠ ma̠ a̠yel, ologi ima̠ra̠ d̠oyom na̠ a̠koko nyam a̠d̠umeni.” ");
INSERT INTO mgj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Odi a̠d̠a̠ma̠ aro̠ ma̠ ola̠ Rafarisi bho̠ ipura̠n A̠zizo̠s ma̠ ologhom igiel irileghom ta̠ A̠zib̠a̠ ta̠ a̠ru, sa̠ i̠na awo̠ran ma̠a̠, “Eruoma̠ irileghom ta̠ A̠zib̠a̠ bo̠ ma̠ ola̠ ta̠ obhin elegh olelegi, ");
INSERT INTO mgj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","bo̠d̠o̠ ma̠ ola̠ a̠nwunom ta̠ e̠gba ma̠a̠, ‘Od̠i ma̠ i̠se̠n,’ bo̠d̠o̠, ‘Od̠i ma̠ ebha̠,’ ezin bho̠ irileghom ta̠ A̠zib̠a̠ od̠i d̠a̠ esa̠d̠io inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sa̠ i̠na agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, “Obhel na̠ a̠ru ma̠ ola̠ ta̠ ebhir inyin o̠bi̠gh odi a̠d̠a̠ma̠ O̠nyi̠ ta̠ O̠ni̠, ya̠a̠ inyin ko o̠bi̠gh d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A̠nwunom ta̠ e̠gba enigha̠ inyin ma̠a̠, ‘Ikpone, i̠na od̠i ma̠ ebha̠,’ bo̠d̠o̠, ‘Ikpone, i̠na od̠i ma̠ enen,’ ya̠a̠ o̠ni̠ ko o̠tu̠o̠no̠m awa. ");
INSERT INTO mgj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A̠d̠ien agu̠o̠ i̠me̠me̠gi̠na agbararan na̠ ame̠me̠gi̠na na̠ a̠mutiom e̠b̠alab̠al d̠a̠ odi e̠ku̠l o̠b̠u̠ghu̠b̠u̠gh bho̠, sa̠ na̠ ame̠me̠gi̠na na̠ ab̠e̠i̠ d̠a̠ opa̠n e̠ku̠l bho̠, obha̠ agu̠o̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ ma̠ a̠d̠a̠ma̠ wa̠ i̠na ta̠ a̠mula̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ya̠a̠, i̠na ta̠ a̠d̠ia̠ amar abi̠gh a̠d̠izo ali̠gam a̠ruzu, sa̠ a̠nwunom amu̠m onon ta̠ eghel i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“A̠d̠ien agu̠o̠ aro̠ d̠a̠ ra̠d̠a̠ma̠ ta̠ A̠nua̠ bho̠, onin agu̠o̠ ta̠ aro̠ d̠a̠ ra̠d̠a̠ma̠ ta̠ O̠nyi̠ ta̠ O̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A̠nwunom i̠ro̠ na̠ ed̠e na̠ e̠d̠a, na̠ ebhinogh anwani̠, na̠ enigha̠nom anwi̠nyan d̠awa tu̠tu̠n ate̠i̠ a̠d̠a̠ma̠ wa̠ A̠nua̠ a̠d̠igh d̠a̠ obom oghugh bho̠. Sa̠ obom amu̠m a̠d̠igho a̠ru ra̠ a̠kunugi ma̠ eb̠la̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Obha̠ agu̠o̠ aro̠ d̠a̠ ra̠d̠a̠ma̠ ta̠ Alo̠t nyen. A̠nwunom i̠ro̠ na̠ ed̠e na̠ e̠d̠a, na̠ egho na̠ ewod̠i ma̠ i̠di̠ar, na̠ egbebhegh ed̠ia̠n, na̠ eloyogh a̠rutu, ");
INSERT INTO mgj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","tu̠tu̠n ate̠i̠ a̠d̠a̠ma̠ wa̠ Alo̠t ad̠u̠a d̠a̠ Aso̠do̠m bho̠. Sa̠ anya na̠ aso̠lfo̠, i̠lo̠bh d̠a̠ e̠nai̠ny isor ra̠ ikunugi ma̠ eb̠la̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Obha̠ agu̠o̠ ta̠ aro̠ ma̠ a̠d̠a̠ma̠ wa̠ O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠mula̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","D̠a̠ a̠d̠a̠ma̠ obha̠, o̠ni̠ ola̠ od̠i d̠a̠ anyu̠ otu, osor d̠o̠ agi̠ ka̠ a̠bhin abar d̠a̠ ologi otu. Onin agu̠o̠ bho̠ o̠ni̠ ola̠ od̠i d̠a̠ e̠sala bo̠d̠o̠ d̠a̠ o̠si̠ omula̠ d̠o̠ a̠yel d̠a̠ otu. ");
INSERT INTO mgj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","I̠ru̠ru̠ane̠ ma̠ abar wa̠ a̠mutuma̠ ma̠ ani̠ ta̠ Alo̠t bho̠! ");
INSERT INTO mgj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","O̠ni̠ ola̠ a̠wia̠n otenemeni a̠ghud̠um d̠o̠yo̠, ta̠ a̠robh a̠ghud̠um d̠o̠yo̠; ya̠a̠, o̠ni̠ ola̠ a̠robh a̠ghud̠um d̠o̠yo̠ ta̠ a̠tenemeni ma̠ a̠ghud̠um d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠d̠uga̠la̠n obha̠, i̠wal a̠nwunom ta̠ ekod̠u d̠a̠ onin akpata; odi ta̠ obhin, uwed̠i sa̠ ta̠ o̠we̠le̠man i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","I̠wal anwani̠ ta̠ e̠ro̠ ma̠ onin esi e̠gbe̠ ma̠ i̠di̠ar; odi ta̠ obhin, uwed̠i sa̠ ta̠ o̠we̠le̠man i̠se̠.” ");
INSERT INTO mgj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","I̠wal a̠nwunom ta̠ e̠ro̠ d̠a̠ o̠si̠ egir ogir, odi ta̠ obhin, uwed̠i sa̠ ta̠ o̠we̠le̠man i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sa̠ awa ipura̠n ma̠a̠, “Wa̠nwuna̠, i̠di̠ar i̠nye̠n ta̠ emite d̠a̠ken?” Sa̠ i̠na awo̠ran awa ma̠a̠, “Esi ola̠ omumugh ozu od̠i, bha̠ esi ola̠ ro̠de̠le̠ ta̠ ekokod̠ia̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sa̠ A̠zizo̠s a̠rogh a̠sidogh a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ a̠kikiom ma̠a̠, awa e̠ro̠ ma̠ osiseiny osiseiny A̠zib̠a̠ ya̠ o̠tabh d̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I̠na agba ma̠a̠, “D̠a̠ odi e̠ma, odi osobh ma̠ ase̠ aro̠ ma̠ ola̠ oghila̠n d̠o̠ ma̠ A̠zib̠a̠, sa̠ i̠na na̠ obhin d̠o̠ ma̠ opa̠n o̠ni̠ atu̠o̠m abar nyen. ");
INSERT INTO mgj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa̠ odi ekpukele ani̠ d̠a̠ e̠ma bho̠ aro̠ ma̠ o̠gi̠ o̠gi̠ ka̠ o̠te̠i̠ o̠yo̠, d̠a̠ ebula̠ ali̠gam a̠luzu ola̠ ate̠i̠ i̠na, sa̠ ale̠gh i̠na ma̠a̠, ‘Sobhe ma̠ ase̠ igielake̠ ma̠ a̠tenemeni ami̠, d̠a̠ agu̠o̠ o̠ni̠ o̠lo̠gi̠an a̠d̠ien d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“I̠na na̠ oma̠ra̠ d̠o̠ ma̠ ogir abar ogboloma̠ ani̠ bho̠ ma̠ owewegh obhel; ya̠a̠, d̠a̠ ekunuguma̠ bho̠ sa̠ i̠na a̠fugh a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠a̠, ‘Ami̠ a̠loghom ma̠ ami̠ ighila̠n d̠o̠ ma̠ A̠zib̠a̠, sa̠ ami̠ obhin d̠o̠ ma̠ opa̠n o̠ni̠ atu̠o̠m abar nyen. ");
INSERT INTO mgj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ku̠ku̠m eka̠, ebula̠ agu̠o̠ ekpukele ani̠ onon na̠ a̠guri na̠ a̠nyegi ami̠ bho̠, ami̠ ta̠ a̠sobh ase̠ bho̠ ma̠ ya̠ igielake̠, b̠o̠ka̠ awe̠le̠man ami̠ ma̠ agu̠o̠!’ ” ");
INSERT INTO mgj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sa̠ Wa̠nwuna̠ bho̠ agba ma̠a̠, “I̠nagha ma̠ abar wa̠ o̠karabh osobh ma̠ ase̠ onon a̠fugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A̠zib̠a̠ ko osobh d̠o̠ ma̠ ase̠ igielake̠ a̠nigha̠ ma̠ ogbo ya̠ i̠na na̠ aso̠n bho̠, ya̠ na̠ eleghe na̠ enigha̠ i̠na ma̠ etita̠n na̠ a̠d̠uga̠la̠n bho̠ ke̠re̠? I̠na ta̠ a̠bhogia̠n awa a̠guri ma̠ esi egbeiny ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, i̠na ta̠ a̠bhin onyen a̠sobh ase̠ bho̠ ma̠ ya̠ igielake̠ a̠nigha̠ awa. Aro̠ eka̠ ma̠ o̠ku̠a, igiel O̠nyi̠ ta̠ O̠ni̠ ta̠ a̠mula̠ a̠ru, i̠na ta̠ abi̠gh a̠nwunom ya̠ inwuna̠ ma̠ ologi ima̠ra̠ ma̠ i̠se̠n a̠de onon ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A̠zizo̠s ab̠ar na̠ a̠sidogh onon a̠rogh a̠nigha̠ ma̠ ogbo ya̠ id̠umom d̠a̠ rologi d̠awa ma̠ awa na̠ e̠b̠ab̠ala bho̠, sa̠ na̠ ekpon ipa̠n a̠nwunom na̠ e̠do̠ti̠me̠ni̠ bho̠ ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“I̠wal a̠nwunom iten i̠gi̠ d̠a̠ Otu ta̠ A̠zib̠a̠ ma̠ osiseiny a̠siseiny. Odi, Afarisi; ya̠a̠ o̠ni̠ uwed̠i, ogun ma̠ otua̠-ebhugh. ");
INSERT INTO mgj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Afarisi bho̠ a̠b̠etina̠ amara sa̠ a̠siseiny o̠ko̠no̠n: ‘A̠zib̠a̠, anwa a̠d̠ighi ami̠ o̠ro̠ d̠o̠ ma̠ agu̠o̠ ipa̠n a̠nwunom. Ami̠ bo̠ ma̠ agu̠o̠ i̠bi̠gh ma̠ a̠b̠igh, na̠ id̠ighi ma̠ i̠karabh, na̠ id̠e ma̠ e̠ma, bo̠d̠o̠ ma̠ agu̠o̠ ogun ma̠ otua̠-ebhugh onon nyen. ");
INSERT INTO mgj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ami̠ na̠ a̠ne ma̠ o̠ko̠i̠ i̠wal igiel d̠a̠ ologi od̠ua̠l ra̠d̠a̠ma̠, sa̠ ami̠ na̠ a̠nigha̠ gha̠n A̠zib̠a̠ ma̠ odi a̠bin atu̠gi̠-a̠d̠iobh bho̠, d̠a̠ i̠di̠ar ya̠ ami̠ inwuna̠ bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ya̠a̠, ogun ma̠ otua̠-ebhugh bho̠ amara ma̠ esi egbeiny. I̠na na̠ one d̠o̠ ma̠ ob̠eka̠ okpon d̠a̠ ote̠nai̠ny nyen; Kpe̠le̠me̠ni̠ i̠na a̠bhuma̠ ma̠ ekpa̠kpa̠gh d̠o̠yo̠ a̠fugh ma̠a̠, ‘E A̠zib̠a̠! Kpone ami̠ ma̠ igbirigbir, ezin bho̠ ami̠ od̠ighi ma̠ i̠karabh.’ ");
INSERT INTO mgj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, A̠zib̠a̠ ada ma̠ a̠siseiny od̠ighi ma̠ i̠karabh onon a̠bhin, sa̠ i̠na a̠yel agu̠o̠ ob̠eb̠i o̠ni̠, ya̠a̠ Afarisi bho̠ d̠o̠. Ezin bho̠, eb̠la̠ ogbo ya̠ i̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu d̠awa bho̠ ta̠ o̠ki̠ri̠me̠ni̠; sa̠ ogbo ya̠ i̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu d̠awa bho̠ sa̠ ta̠ o̠bu̠ghu̠me̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A̠nwunom i̠b̠aram na̠ i̠gbara anwi̠i̠ny ebhin eru d̠a̠ A̠zizo̠s, ma̠ i̠na ma̠ o̠gbam agu̠o̠ otutumeni. Igiel bho̠ ogbo atu̠ghan d̠o̠yo̠ i̠bi̠gh oku̠a bho̠, sa̠ ikigima̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sa̠ A̠zizo̠s a̠bhelegi ma̠ i̠gbara anwi̠i̠ny bho̠ sa̠ agba a̠nigha̠ ma̠ ogbo atu̠ghan bho̠ ma̠a̠, “Ima̠ra̠ i̠gbara anwi̠i̠ny bho̠ eru d̠ami̠. O̠ni̠ ko okigima̠ awa, ezin bho̠ irileghom ta̠ A̠zib̠a̠ aro̠ a̠nigha̠ ma̠ ogbo ya̠ od̠i ma̠ agu̠o̠ i̠gbara anwi̠i̠ny i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ya̠gia̠ga̠i, ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, o̠ni̠ ola̠ o̠da d̠o̠ ma̠ irileghom ta̠ A̠zib̠a̠ a̠bhin ma̠ agu̠o̠ o̠gbara o̠nyi̠, ko od̠igh d̠o̠ d̠a̠ ologi.” ");
INSERT INTO mgj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Odi o̠li̠la ebhugh A̠zu a̠pura̠n i̠na ma̠a̠, “Ob̠eb̠i o̠ni̠-atu̠ghu̠me̠ni̠, ami̠ ta̠ a̠d̠ighi eka̠ ate̠i̠ a̠ghud̠um ya̠ ekunuguma̠ o̠to̠?” ");
INSERT INTO mgj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ere a̠d̠ighi ka̠ anwa na̠ a̠bhelegi ami̠ ma̠ ob̠eb̠i o̠ni̠? Ob̠eb̠i o̠ni̠ bo̠, usigimeni ma̠ A̠zib̠a̠ ku̠ku̠m. ");
INSERT INTO mgj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Anwa a̠loghom oloko wa̠ agba ma̠a̠: ‘Anwa ko od̠e d̠o̠ ma̠ e̠ma. Anwa ko ogigh d̠o̠ ma̠ o̠ni̠. Anwa ko ob̠igh d̠o̠ ma̠ a̠b̠igh. Anwa ko o̠gba d̠o̠ ma̠ onyob̠a̠ igunugha̠. Zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ onweni na̠ d̠oyom.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Sa̠ o̠ni̠ bho̠ awo̠ran ma̠a̠, “Eb̠la̠ roloko i̠nye̠n ami̠ na̠ a̠koko ka̠ d̠a̠ i̠gbara d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Igiel bho̠ A̠zizo̠s amu̠gho̠n o̠ku̠a bho̠, sa̠ i̠na agba a̠nigha̠ i̠na ma̠a̠, “Odi abar od̠id̠ia̠ ma̠ anwa ma̠ ogir. Wole ma̠ eb̠la̠ i̠di̠ar ya̠ anwa inwuna̠ bho̠ ma̠ a̠nigha̠ ma̠ ikpoki bho̠ ma̠ inyigoiny bho̠, sa̠ anwa ta̠ ate̠i̠ e̠li̠la d̠a̠ ote̠nai̠ny. Igiel anwa na̠ a̠gir o̠ku̠a awe̠le̠, ma̠ a̠mula̠ ma̠ a̠ru ra̠ ato̠no̠m ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ya̠a̠, igiel bho̠ i̠na amu̠gho̠n e̠kal onon bho̠, sa̠ i̠na aku̠ru̠ru̠, ezin bho̠ i̠na a̠gbo ma̠ e̠li̠la ma̠ ibom. ");
INSERT INTO mgj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Igiel bho̠ A̠zizo̠s abi̠gh agu̠o̠ o̠ni̠ bho̠ a̠bhin aku̠ru̠ru̠ bho̠, sa̠ a̠fugh ma̠a̠, “Amar akpar ogbo ya̠ igbo ma̠ e̠li̠la ma̠ od̠igh d̠a̠ ologi irileghom ta̠ A̠zib̠a̠! ");
INSERT INTO mgj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ya̠gia̠ga̠i, e̠nam-a̠dol o̠wo̠l d̠a̠ oyol anu̠ga oten ta̠ a̠b̠ur a̠pu, ma̠ o̠ni̠ ola̠ a̠gbo ma̠ e̠li̠la ma̠ od̠igh d̠a̠ ologi irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A̠nwunom ya̠ i̠mu̠gho̠n i̠nye̠n bho̠ sa̠ ipura̠n ma̠a̠, “O̠ku̠a ka̠ a̠nyen ta̠ a̠rue a̠ten?” ");
INSERT INTO mgj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Abar ola̠ o̠nyi̠o̠mo̠ro̠ni̠ ko orue d̠o̠ na̠ orue a̠gir, A̠zib̠a̠ ta̠ a̠rue a̠gir.” ");
INSERT INTO mgj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sa̠ A̠pita̠ agba a̠nigha̠ i̠na ma̠a̠, “I̠yar na̠ o̠we̠le̠man eb̠la̠ i̠di̠ar ya̠ i̠yar unwuna̠ bho̠ na̠ o̠tu̠o̠no̠m anwa.” ");
INSERT INTO mgj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠, o̠ni̠ ola̠ awe̠le̠man otu, bo̠d̠o̠ ani̠, bo̠d̠o̠ a̠rumor, bo̠d̠o̠ aru̠marani̠, bo̠d̠o̠ onweni na̠ o̠we̠de̠, bo̠d̠o̠ anwi̠i̠ny, ma̠ ebula̠ irileghom ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","o̠ni̠ bho̠ ko o̠we̠le̠ d̠o̠ ma̠ o̠te̠i̠ i̠di̠ar ya̠ ipel o̠ku̠a d̠a̠ amu̠m onon, sa̠ i̠na ta̠ ate̠i̠ a̠ghud̠um ya̠ ekunuguma̠ o̠to̠ d̠a̠ amu̠m wa̠ na̠ a̠ru d̠a̠ ed̠ia̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A̠zizo̠s a̠bhin d̠iobh na̠ i̠wal ogbo atu̠ghan bho̠ a̠ten d̠a̠ a̠d̠ukun, sa̠ agba a̠nigha̠ awa ma̠a̠, “I̠nagha, i̠yar ta̠ obhun o̠gi̠ d̠a̠ A̠zeruse̠le̠m, esi bho̠ ta̠ omuzoghod̠iom eb̠la̠ iwowa̠ ya̠ a̠riwil bho̠ i̠ge̠ igboloma̠ ma̠ O̠nyi̠ ta̠ O̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta̠ ob̠eton i̠na o̠lo̠gh d̠a̠ agu̠o̠ ogbo o̠ro̠ d̠o̠ ma̠ A̠zu bho̠. A̠nwunom ta̠ e̠ki̠ri̠ i̠na, sa̠ awa ta̠ erogi i̠na ekpon e̠do̠ti̠me̠ni̠, sa̠ awa ta̠ e̠si̠ro̠gho̠m i̠na ma̠ i̠gho̠r. ");
INSERT INTO mgj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Awa ta̠ e̠gu̠ro̠gh i̠na, sa̠ ta̠ egigh i̠na. Sa̠ oleghemeni i̠sar a̠d̠a̠ma̠ bho̠, sa̠ i̠na ta̠ a̠b̠etina̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um.” ");
INSERT INTO mgj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ya̠a̠, awa i̠mu̠gho̠nyan d̠o̠ bebina̠ abar d̠a̠ i̠di̠ar i̠nye̠n ya̠ i̠na agba bho̠. U̠wo̠gi̠o̠m awa ma̠ ezin i̠di̠ar ya̠ i̠na agba bho̠, sa̠ awa ologhom d̠o̠ ma̠ i̠di̠ar ya̠ i̠na na̠ agba na̠ a̠gboloma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","I̠se̠n a̠mite ma̠ ola̠, agu̠o̠ A̠zizo̠s na̠ a̠tua̠n Aze̠riko bho̠, bha̠ odi o̠ni̠ ikpom a̠rid̠ien aro̠ ma̠ a̠dila̠de d̠a̠ aka eten bho̠ na̠ a̠puru ma̠ ipupuru. ");
INSERT INTO mgj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Igiel bho̠ i̠na amu̠gho̠n oghoroghor o̠lo̠gh a̠nwunom ya̠ na̠ eten bho̠, sa̠ i̠na a̠pura̠n ologhom abar wa̠ na̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Sa̠ awa i̠gba inigha̠ i̠na ma̠a̠, “A̠zizo̠s wa̠ Anazare̠t bho̠ na̠ a̠ten.” ");
INSERT INTO mgj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sa̠ i̠na a̠mulughu a̠kele ma̠a̠, “A̠zizo̠s, o̠nyi̠ ta̠ A̠devidi, kpone ami̠ ma̠ igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sa̠ ogbo ya̠ i̠ro̠ d̠a̠ ed̠ia̠ o̠lo̠gh bho̠, imulughuom i̠na ma̠ i̠na aro̠ b̠o̠b̠o̠m. Ya̠a̠, i̠na aro̠ ma̠ omulughu omulughu izul d̠o̠yo̠ o̠gi̠o̠m anyu̠ ma̠a̠, “O̠nyi̠ ta̠ A̠devidi, kpone ami̠ ma̠ igbirigbir!” ");
INSERT INTO mgj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sa̠ A̠zizo̠s amara kpom, sa̠ a̠bhin okparakpar okoroko a̠ruom agu̠o̠ ola̠ ta̠ obhin o̠ni̠ bho̠ oru d̠o̠yo̠. Igiel bho̠ o̠ni̠ bho̠ na̠ a̠tua̠n bho̠, sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠, ");
INSERT INTO mgj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ere ma̠ abar wa̠ anwa na̠ abho̠ro̠gh ami̠ ma̠ ogir onigha̠ oyom bho̠?” Sa̠ i̠na awo̠ran ma̠a̠. “Wa̠nwuna̠, ami̠ na̠ abho̠ro̠gh o̠bi̠gh abar.” ");
INSERT INTO mgj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ i̠na ma̠a̠, “A̠rid̠ien d̠oyom e̠kpagi̠na! Ologi ima̠ra̠ d̠oyom na̠ a̠koko nyam a̠d̠umeni.” ");
INSERT INTO mgj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","D̠a̠ onin obhel obha̠, sa̠ i̠na ake̠ ma̠ o̠bi̠gh abar, sa̠ atu̠o̠no̠m A̠zizo̠s, na̠ a̠tutumeni ma̠ A̠zib̠a̠. Igiel bho̠ eb̠la̠ a̠nwunom bho̠ i̠bi̠gh o̠ku̠a bho̠, sa̠ awa itutumeni ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A̠zizo̠s a̠d̠igh d̠a̠ Aze̠riko sa̠ awo̠l na̠ a̠ten d̠a̠ e̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Odi o̠li̠la o̠ni̠ ola̠ ubhelegi ma̠ Azaki̠o̠s aro̠. I̠na we̠mu̠ igun ma̠ otua̠-ebhugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I̠na a̠wia̠n o̠bi̠gh ani̠ A̠zizo̠s, ya̠a̠ d̠a̠ ebula̠ a̠lukper d̠o̠yo̠ i̠na na̠ orue d̠o̠ ma̠ okpon opeleni o̠lo̠gh a̠nwunom bho̠ o̠bi̠gh o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ebula̠ o̠ku̠a, sa̠ i̠na a̠ghil a̠ten o̠lo̠gh a̠nwunom bho̠ agi̠ d̠a̠ ed̠ia̠, sa̠ asi̠n oriren ola̠ ubhelegi ma̠ a̠sikamo̠; b̠o̠ka̠ i̠na a̠rue abi̠gh i̠na, ezin bho̠ A̠zizo̠s ta̠ awo̠l i̠se̠ a̠ten. ");
INSERT INTO mgj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Igiel bho̠ A̠zizo̠s ate̠i̠ esi bho̠, sa̠ i̠na a̠b̠eka̠ a̠kpon d̠a̠ anyu̠ a̠bhelegi i̠na a̠fugh ma̠a̠, “Azaki̠o̠s! Nu̠re̠ ma̠ a̠sor a̠ru; ami̠ ta̠ a̠d̠igh aro̠ d̠a̠ otu d̠oyom a̠didon.” ");
INSERT INTO mgj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Onin obhel obha̠, sa̠ i̠na anu̠r a̠sor agi̠ ka̠ ada i̠na a̠bhin na̠ a̠libhon ologi. ");
INSERT INTO mgj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa̠ eb̠la̠ a̠nwunom ya̠ i̠bi̠gh o̠ku̠a bho̠, i̠ke̠ ma̠ oghunuma̠ ma̠a̠, “I̠na na̠ agi̠ ka̠ a̠suloma̠ ma̠ od̠ighi ma̠ i̠karabh.” ");
INSERT INTO mgj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sa̠ Azaki̠o̠s a̠b̠etina̠ agba a̠nigha̠ ma̠ Wa̠nwuna̠ bho̠ ma̠a̠, “Kpone, E Wa̠nwuna̠, ami̠ ta̠ aru̠gi̠ ma̠ e̠li̠la d̠ami̠ i̠wal a̠bin a̠nigha̠ ma̠ odi a̠bin ronyigoiny bho̠; ya̠a̠ o̠ni̠ ola̠ ami̠ ininiom abar, sa̠ ami̠ ta̠ akpe̠ ma̠ o̠ni̠ bho̠ ma̠ inya̠ a̠bin abar i̠se̠.” ");
INSERT INTO mgj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “A̠didon, itenemeni na̠ eru d̠a̠ otu onon, ezin bho̠, o̠ni̠ onon eka̠ o̠nyi̠ ola̠ Ebraham. ");
INSERT INTO mgj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ya̠gia̠ga̠i, O̠nyi̠ ta̠ O̠ni̠ atu̠n o̠bho̠ro̠gh, na̠ otenemeni ogbo ya̠ na̠ ebhe bho̠ a̠ru.” ");
INSERT INTO mgj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Agu̠o̠ o̠lo̠gh a̠nwunom bho̠ na̠ e̠nagha ma̠ iya̠ A̠zizo̠s na̠ agba bho̠, sa̠ i̠na a̠rogh a̠sidogh ab̠aram. Ezin bho̠, awa na̠ e̠walama ma̠a̠, agu̠o̠ i̠na na̠ a̠tua̠n A̠zeruse̠le̠m bho̠ ma̠a̠, irileghom ta̠ A̠zib̠a̠ na̠ a̠ru ra̠ omite i̠se̠ onin obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sa̠ i̠na agba ma̠a̠, “Odi obom o̠ni̠ ola̠ amar agbi̠r a̠mitia̠n, a̠b̠etina̠ ma̠ e̠gi̠ esi egbeiny d̠a̠ opa̠n ebhugh, ola̠ ta̠ o̠lo̠gh i̠na ma̠ O̠li̠le̠ma sa̠ i̠na ta̠ a̠mula̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kisa̠ i̠na ta̠ a̠b̠etina̠ ma̠ e̠gi̠ bho̠, i̠na a̠bhelegi ma̠ d̠iobh rob̠a̠ra̠motu d̠o̠yo̠ a̠nigha̠ ma̠ o̠ni̠ i̠se̠ ami̠na, sa̠ agba a̠nigha̠ awa ma̠a̠, ‘Ibhine ma̠ ikpoki i̠nye̠n ma̠ eb̠ua̠ ma̠ a̠b̠ua̠ ma̠ i̠se̠n ami̠ na̠ agi̠ ma̠ e̠gi̠ bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ya̠a̠, a̠nwunom ebhugh d̠o̠yo̠ e̠su̠a i̠na, sa̠ awa i̠to̠ ma̠ a̠nwunom obha̠ra̠nom o̠yo̠ o̠gi̠ ka̠ o̠go̠ya d̠a̠ esi bho̠ i̠na na̠ agi̠ bho̠ ma̠a̠, ‘I̠yar u̠bho̠ro̠ghan d̠o̠ ma̠ o̠ni̠ onon o̠ro̠ o̠li̠le̠ma d̠i̠yar.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“A̠mite ma̠ ola̠ u̠lo̠gh i̠na ma̠ o̠li̠la ebhugh d̠awa, sa̠ i̠na a̠mula̠ a̠yel. Sa̠ i̠na a̠ruom obhelegi rob̠a̠ra̠motu d̠o̠yo̠ ya̠ i̠na a̠nigha̠ ma̠ ikpoki bho̠, ma̠ opura̠n ologhom asu̠o̠ ya̠ awa igir imutiom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“O̠pu̠r bho̠ a̠ru sa̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Wa̠nwuna̠, okpoki d̠oyom amar ipa̠n a̠d̠iobh ami̠na a̠mutiom.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa amar a̠gir. Anwa ob̠eb̠i ob̠a̠ra̠motu! Ebula̠ agu̠o̠ anwa ileriom ma̠a̠, ta̠ orue obhin anwa ob̠em ologi d̠a̠ o̠nyo̠gbara abar bho̠, anwa ta̠ aro̠ ma̠ a̠dila̠de i̠to̠ ola̠ orileghom a̠d̠iobh ibom re̠ma.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“O̠tu̠o̠no̠m i̠se̠ sa̠ oleghemeni i̠wal ob̠a̠ra̠motu bho̠ a̠ru ra̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Wa̠nwuna̠, okpoki d̠oyom amar ipa̠n ogho ami̠na a̠mutiom.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa ta̠ aro̠ ma̠ a̠dila̠de i̠to̠ ola̠ orileghom ogho ibom re̠ma.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“O̠tu̠o̠no̠m i̠se̠ sa̠ oleghemeni i̠sar ob̠a̠ra̠motu bho̠ a̠ru ra̠ agba a̠nigha̠ i̠na ma̠a̠, ‘Wa̠nwuna̠, onon okpoki d̠oyom; ami̠ i̠gho̠ro̠gi̠ d̠a̠ ukpe a̠guri a̠sisa̠n anwa. ");
INSERT INTO mgj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ami̠ ighil anwa, ezin bho̠ anwa o̠kparakpar o̠ni̠ ola̠ na̠ a̠bhin abar o̠la o̠ro̠ d̠o̠ ma̠ oloyom, sa̠ anwa na̠ a̠b̠u ma̠ esi ola̠ anwa ogbebh d̠o̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Sa̠ wa̠nwuna̠ do̠yo̠ awo̠ran i̠na ma̠a̠, ‘Anwa o̠karabh ob̠a̠ra̠motu onon, Ami̠ ta̠ a̠bhin okoroko d̠oyom a̠sobh ase̠ a̠bhumeni nyam. Anwa amar a̠loghom ma̠a̠, ami̠ o̠kparakpar o̠ni̠ ola̠ na̠ a̠bhin abar ola̠ o̠ro̠ d̠o̠ ma̠ olami̠, sa̠ ami̠ na̠ a̠b̠u ma̠ esi ola̠ ami̠ ogbebh d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","O̠ku̠a ka̠ a̠mite eka̠, ma̠ ola̠ anwa oguri d̠o̠ ma̠ okpoki d̠ami̠ ma̠ esi ola̠ ta̠ amar ipa̠n a̠mutiom, b̠o̠ka̠ i̠se̠n ami̠ imula̠ iru bho̠ ami̠ ate̠i̠ okpoki d̠ami̠ na̠ asu̠o̠ bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Sa̠ i̠na a̠tiba̠ra̠ adama ma̠ ogbo ya̠ i̠mara ma̠ i̠se̠ bho̠ a̠fugh a̠nigha̠ awa ma̠a̠, ‘Ibhine ma̠ okpoki wa̠ od̠i d̠a̠ agu̠o̠ d̠o̠yo̠ bho̠ ma̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ a̠nwuna̠ ma̠ d̠iobh ami̠na bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Sa̠ awa i̠wo̠ran i̠na ma̠a̠, ‘Wa̠nwuna̠, o̠ni̠ obha̠ na̠ a̠nwuna̠ ma̠ d̠iobh ami̠na d̠a̠ agu̠o̠ d̠o̠yo̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Sa̠ i̠na awo̠ran ma̠a̠, ‘Yii, i̠na o̠ni̠ wa̠ ate̠i̠ bho̠, ta̠ o̠lo̠gho̠m ipa̠n ya̠ ib̠uiy ipu ma̠ o̠ku̠a onigha̠ i̠na; ya̠a̠, i̠na o̠ni̠ wa̠ o̠te̠i̠ d̠o̠ bho̠, bebina̠ o̠nyi̠ki̠kara ya̠ i̠na ate̠i̠ bho̠ eka̠, ta̠ o̠wo̠r obhin. ");
INSERT INTO mgj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ya̠a̠, ogbo o̠lo̠gi̠an a̠d̠ien d̠ami̠ i̠nye̠n ya̠ oma̠ra̠ d̠o̠ ka̠ ami̠ ta̠ aro̠ ma̠ oli̠le̠ma d̠awa bho̠, ibhine awa ma̠ eru ma̠ i̠se̠n ma̠ e̠ze̠gi̠ awa d̠a̠ a̠misigh d̠ami̠.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Igiel bho̠ A̠zizo̠s na̠ agba ma̠ i̠nye̠n awe̠le̠ bho̠, sa̠ i̠na a̠ten d̠a̠ ed̠ia̠ d̠awa a̠rile adama ma̠ A̠zeruse̠le̠m. ");
INSERT INTO mgj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Igiel bho̠ i̠na na̠ a̠tua̠n e̠ma Abe̠ti̠fagi̠ na̠ e̠ma Abe̠tani̠ bho̠, ya̠ od̠i d̠a̠ igu Oliv bho̠, sa̠ i̠na a̠ruom a̠duom i̠wal ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Itene ma̠ e̠gi̠ d̠a̠ e̠ma wa̠ od̠i d̠a̠ ed̠ia̠ d̠inyin bho̠, sa̠ ka̠ inyin ud̠igh a̠d̠igha̠ d̠a̠ e̠ma bho̠ sa̠ inyin ta̠ o̠bi̠gh okubh ado̠ki̠ ola̠ o̠ni̠ ta̠ od̠ia̠ d̠o̠ a̠d̠igh a̠rile. ");
INSERT INTO mgj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ku̠gba ma̠ o̠ni̠ a̠pura̠n inyin ma̠a̠, ‘Inyin na̠ o̠tu̠n ere na̠ o̠ko̠to̠n okubh ado̠ki̠ bho̠?’ I̠wo̠rane̠ ma̠a̠, ‘Wa̠nwuna̠ bho̠ na̠ abho̠ro̠gh orughom.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sa̠ ogbo atu̠ghan ya̠ A̠zizo̠s a̠ruom a̠duom bho̠ iten i̠gi̠, sa̠ i̠bi̠gh ma̠ ado̠ki̠ bho̠ od̠i ma̠ agu̠o̠ i̠na agba a̠nigha̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Igiel bho̠ awa na̠ e̠ko̠to̠n okubh ado̠ki̠ bho̠, sa̠ ogbo ya̠ inwuna̠ bho̠ ipura̠n awa ma̠a̠, “Inyin na̠ o̠tu̠n ere na̠ o̠ko̠to̠n okubh ado̠ki̠ bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Sa̠ awa i̠wo̠ran ma̠a̠, “Wa̠nwuna̠ bho̠ na̠ abho̠ro̠gh orughom.” ");
INSERT INTO mgj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sa̠ awa ibhin ado̠ki̠ bho̠ iruom A̠zizo̠s, sa̠ awa i̠ke̠gi̠na ma̠ ibom rakapa d̠awa ibhin i̠de̠ d̠a̠ anyu̠ ado̠ki̠ bho̠, sa̠ i̠ri̠lo̠me̠ni̠ ma̠ A̠zizo̠s d̠a̠ anyu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Igiel bho̠ i̠na na̠ a̠rile na̠ agi̠ bho̠, sa̠ a̠nwunom i̠ke̠gi̠na ma̠ ibom rakapa d̠awa ibhin i̠de̠ d̠a̠ eten bho̠ d̠a̠ e̠d̠ia̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Igiel bho̠ i̠na na̠ a̠tua̠n esi bho̠ eten bho̠ ake̠ ma̠ okubh d̠a̠ igu Oliv osor bho̠, sa̠ eb̠la̠ o̠lo̠gh ogbo atu̠ghan bho̠, ibhin d̠a̠ a̠libhon ologi i̠ke̠ ma̠ o̠mo̠r aso̠r otutumeni A̠zib̠a̠, d̠a̠ ebula̠ ogir ilologia̠n ya̠ awa na̠ e̠bi̠gh bho̠, ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Itutumeni ta̠ A̠zib̠a e̠ro̠ enigha̠ ma̠ O̠li̠le̠ma wa̠ na̠ a̠bhin d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ na̠ a̠ru bho̠!” “Ekima̠ d̠a̠ ote̠nai̠ny na̠ isosorogia̠n ta̠ A̠zib̠a̠ wa̠ agi̠ ma̠ anyu̠ a̠pu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Idi ogbo Afarisi ya̠ i̠ro̠ ani̠ d̠a̠ o̠lo̠gh a̠nwunom bho̠ sa̠ ifugh inigha̠ ma̠ A̠zizo̠s ma̠a̠, “O̠ni̠ Atu̠ghu̠me̠ni̠, ghi̠ghana ma̠ ogbo atu̠ghan d̠oyom ma̠ ofugh i̠di̠ar ya̠ i̠ro̠ ma̠ o̠ku̠a!” ");
INSERT INTO mgj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sa̠ i̠na awo̠ran awa ma̠a̠, “Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ka̠ awa inima̠ i̠ro̠ b̠o̠b̠o̠m, ikpokpogh i̠gbaki̠ghe̠ bho̠ ta̠ ekpogion izul emulughu etutumeni ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ya̠a̠, igiel bho̠ i̠na na̠ a̠tua̠n abi̠gh e̠ma bho̠, sa̠ i̠na a̠leghe ma̠ ekulom e̠ma bho̠ ");
INSERT INTO mgj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a̠fugh ma̠a̠, “A̠didon ma̠ inyin na̠ ologhom i̠di̠ar ya̠ ta̠ emutiom ekima̠ enigha̠ inyin bho̠ nab̠o̠! Ya̠a̠, na̠ o̠wo̠gi̠o̠m inyin amu̠gho̠nyan i̠di̠ar i̠nye̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ya̠ a̠ga̠i, ra̠d̠a̠ma̠ na̠ eru d̠a̠ ed̠ia̠ ma̠ iya̠, ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom ta̠ elo ma̠ e̠b̠agh ekitineni ma̠ anwa, e̠du̠o̠m a̠nwunom d̠oyom eguri awa d̠a̠ ologi d̠a̠ eb̠la̠ ragba bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Awa ta̠ e̠kpi̠ghi̠d̠i̠ nyam d̠a̠ a̠de, erobhom anwa na̠ anwi̠i̠ny d̠oyom d̠a̠ re̠b̠agh d̠oyom e̠ze̠gi̠ inyin. Ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom ko oguri d̠o̠ bebina̠ ekpo o̠gbaki̠ghe̠ d̠a̠ anyu̠ ta̠ odi, ezin bho̠ anwa na̠ olelegi d̠o̠ ma̠ a̠ma̠zua̠n ta̠ A̠zib̠a̠, ada i̠na a̠bhin d̠a̠ obhel bho̠ i̠na a̠ru d̠oyom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Igiel bho̠ i̠na a̠d̠igh d̠a̠ ologi Otu ta̠ A̠zib̠a̠, sa̠ i̠na ake̠ ma̠ ozegi ogbo ya̠ i̠ro̠ ma̠ i̠se̠ na̠ eb̠ua̠ ma̠ a̠b̠ua̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Na̠ o̠ge̠ oguri d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ ma̠a̠, ‘Otu d̠ami̠ ta̠ aro̠ ma̠ otu-a̠siseiny,’ ya̠a̠ inyin na̠ obhin otenemeni ma̠ ‘e̠fe̠m i̠bi̠gh ma̠ a̠b̠igh.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka̠d̠a̠ma̠ ka̠d̠a̠ma̠ sa̠ i̠na aro̠ d̠a̠ Otu ta̠ A̠zib̠a̠ atu̠ghu̠me̠ni̠ghan atu̠ghu̠me̠ni̠. Ya̠a̠, ogbo aru̠mu̠ rokur bho̠, na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠, na̠ ikei bho̠, sa̠ i̠ke̠ ma̠ omimia̠n agu̠o̠ obhin ogigh o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ku̠ku̠m eka̠, awa irue d̠o̠ ma̠ o̠bi̠gh abar ola̠ odin ogigh o̠yo̠, ezin bho̠ eb̠la̠ a̠nwunom ya̠ i̠ro̠ ma̠ i̠se̠ bho̠, na̠ ebhin obhel na̠ e̠nagha ma̠ asu̠gbagba d̠o̠yo̠ na̠ e̠da na̠ ebhin. ");
INSERT INTO mgj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Odi a̠d̠a̠ma̠ aro̠ ma̠ ola̠ A̠zizo̠s na̠ agba ma̠ ib̠eb̠i asu̠gbagba bho̠ d̠a̠ Otu ta̠ A̠zib̠a̠, sa̠ ogbo aru̠mu̠ rokur bho̠, na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠, na̠ ikei bho̠ iru ra̠ i̠te̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sa̠ awa ipura̠n i̠na ma̠a̠, “Gba ma̠ a̠nigha̠ i̠yar, anwa na̠ a̠bhin d̠a̠ a̠limon ta̠ a̠nyen na̠ a̠gir i̠di̠ar i̠nye̠n? A̠nyen a̠nigha̠ nyam a̠limon bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sa̠ i̠na awo̠ran awa ma̠a̠, “Ami̠ ta̠ a̠pura̠n ani̠ inyin odi a̠pura̠n: ");
INSERT INTO mgj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Owur amu̠m ta̠ Azo̠n ka̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru ke̠re̠, bo̠d̠o̠ ka̠ ad̠u̠a d̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ a̠ru?” ");
INSERT INTO mgj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sa̠ awa ibhin i̠b̠e̠re̠gi̠an d̠a̠ esa̠d̠io d̠awa ma̠a̠, “Ku̠gba ma̠ i̠yar o̠gba ma̠a̠, ‘Ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru,’ sa̠ i̠na ta̠ a̠pura̠n ma̠a̠, ‘Inyin udin ere na̠ o̠we̠le̠man od̠umom o̠yo̠?’ ");
INSERT INTO mgj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ya̠a̠, ka̠ i̠yar u̠gba ma̠a̠, ‘Ad̠u̠a d̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ a̠ru,’ sa̠ eb̠la̠ a̠nwunom bho̠ ta̠ erobhod̠i i̠yar egigh; ezin bho̠, a̠nwunom bho̠ na̠ ema̠ra̠ d̠a̠ rologi d̠awa ma̠ Azo̠n owil.” ");
INSERT INTO mgj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ebula̠ o̠ku̠a sa̠ awa i̠wo̠ran i̠na ma̠a̠, “I̠yar uloghom d̠o̠ ma̠ agu̠o̠ owur amu̠m ta̠ Azo̠n a̠bhin a̠mite.” ");
INSERT INTO mgj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sa̠ A̠zizo̠s agba a̠nigha̠ awa ma̠a̠, “Ami̠ eka̠, ami̠ ko o̠gba d̠o̠ a̠nigha̠ inyin ma̠ o̠ni̠ wa̠ a̠nigha̠ ami̠ ma̠ a̠limon obhin ogir i̠di̠ar i̠nye̠n bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","O̠tu̠o̠no̠m i̠se̠ sa̠ i̠na a̠tiba̠ra̠ adama ma̠ a̠nwunom bho̠ a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠, “Odi o̠ni̠ aro̠ ma̠ ola̠ a̠nwuna̠ ma̠ a̠lei a̠grep, sa̠ i̠na a̠nigha̠ ma̠ esi bho̠ ma̠ igbebh ma̠ ed̠ia̠n o̠ko̠ orughom, sa̠ a̠b̠etina̠ agi̠ ma̠ e̠gi̠ d̠a̠ opa̠n ebhugh aro̠ ma̠ owewegh obhel. ");
INSERT INTO mgj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ate̠i̠ obhel o̠ku̠ imuma̠ bho̠, sa̠ i̠na a̠ruom odi ob̠a̠ra̠motu d̠o̠yo̠ ma̠ o̠gi̠ ka̠ o̠te̠i̠ awa, obhin a̠bin imuma̠ d̠o̠yo̠ ya̠ awa i̠ku̠ d̠a̠ a̠lei bho̠. Ya̠a̠ ogbo ya̠ i̠ko̠ ma̠ a̠lei bho̠ id̠ul i̠na, sa̠ imulumeni i̠na ma̠ i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sa̠ i̠na a̠ruom opa̠n ob̠a̠ra̠motu. Obha̠ eka̠ sa̠ awa id̠ul, ikpon i̠do̠ti̠me̠ni̠, sa̠ imulumeni ma̠ i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sa̠ i̠na a̠ruom epa̠ ma̠ oleghemeni i̠sar ob̠a̠ra̠motu d̠o̠yo̠; onon eka̠ sa̠ awa id̠ul i̠lo̠gi̠ ma̠ i̠ne̠m, ize imutiom. ");
INSERT INTO mgj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Sa̠ o̠ni̠ wa̠ a̠nwuna̠ ma̠ a̠lei bho̠ aru̠ru̠an opa̠n agu̠o̠ ogir, sa̠ a̠fugh ma̠a̠, ‘Ami̠ ta̠ a̠d̠ighi eka̠? Ami̠ ta̠ a̠ruom o̠nyi̠ d̠ami̠ wa̠ ami̠ itula̠n ibom bho̠; ka̠din awa ta̠ ezuruna̠ ma̠ eghoi enigha̠ i̠na.’ ");
INSERT INTO mgj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Igiel bho̠ ogbo ya̠ na̠ erughom a̠lei bho̠ i̠bi̠gh i̠na bho̠, sa̠ awa ima̠ra̠nua̠n ma̠a̠, ‘Onon ta̠ a̠d̠e ma̠ ad̠i̠a a̠lei bho̠, id̠ighi ogigh i̠na b̠o̠ka̠ eb̠la̠ i̠di̠ar o̠ni̠ bho̠ eten iyiyar.’ ");
INSERT INTO mgj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ebula̠ o̠ku̠a sa̠ awa inu i̠na imutiom d̠a̠ a̠lei bho̠, sa̠ igigh i̠na.” Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “O̠ku̠a ka̠, wa̠nwuna̠ ma̠ a̠lei bho̠ ta̠ a̠gir ere a̠gboloma̠ awa? ");
INSERT INTO mgj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I̠na ta̠ a̠ru ra̠ aze̠gi̠ ma̠ eb̠la̠ igbebh ma̠ ed̠ia̠n ya̠ i̠ko̠ ma̠ esi bho̠ i̠ro̠ bho̠, sa̠ i̠na ta̠ a̠b̠eton a̠lei bho̠ a̠nigha̠ ma̠ ipa̠n ogbo.” Igiel bho̠ awa i̠mu̠gho̠n asu̠gbagba i̠nye̠n bho̠, sa̠ awa ifugh ma̠a̠, “A̠zib̠a̠ a̠d̠ighi ma̠ e̠tu̠tu̠ ma̠ abar ola̠ o̠ku̠a ma̠ omite!” ");
INSERT INTO mgj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sa̠ A̠zizo̠s a̠kpon awa d̠a̠ a̠misigh sa̠ a̠pura̠n ma̠a̠, “Abar wa̠ u̠ge̠ d̠a̠ A̠d̠ire-E̠tu̠tu̠ bho̠ ma̠a̠: “ ‘Ikputu wa̠ ilo ma̠ a̠rutu bho̠ ighel bho̠ na̠ a̠ten e̠ko̠ otu bho̠,’ ka̠ a̠ma̠ra̠ ma̠ ere? ");
INSERT INTO mgj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ko̠ni̠ko̠ni̠ ola̠ a̠melema̠ ma̠ ikputu bho̠ ta̠ a̠b̠ob̠omia̠n; sa̠, o̠ni̠ ola̠ ikputu bho̠ a̠mel a̠bhum eka̠ ta̠ a̠tutughud̠ia̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ogbo atu̠ghu̠me̠ni̠ oloko bho̠ na̠ ogbo aru̠mu̠ rokur bho̠ sa̠ i̠bho̠ro̠gh e̠ti̠ti̠gha o̠wo̠l ob̠ol o̠yo̠ ma̠ i̠se̠ d̠a̠ onin obhel bho̠, ezin bho̠ awa iloghoma̠n ma̠ i̠na a̠rogh a̠sidogh bho̠ a̠gboloma̠ awa. Ya̠a̠, awa ighil a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Awa i̠ro̠ igon o̠bi̠gh e̠ti̠ti̠gha ola̠ ob̠ol A̠zizo̠s, obhin o̠gi̠o̠m ogbo ya̠ od̠i d̠a̠ a̠dila̠de i̠to̠ na̠ a̠limon d̠a̠ ebhugh bho̠. Sa̠ awa iruom ogbo ipoiny ma̠ o̠gi̠ ka̠ o̠ro̠ agu̠o̠ a̠ga̠i a̠nwunom, o̠nagha abar i̠na ta̠ a̠fugh a̠rima̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sa̠ ogbo ipoiny bho̠ ipura̠n i̠na ma̠a̠: “O̠ni̠ atu̠ghu̠me̠ni̠, i̠yar ologhom ma̠ anwa na̠ amar na̠ a̠gir d̠a̠ o̠nu̠o̠kpe̠ atu̠ghu̠me̠ni̠ d̠oyom, sa̠ anwa na̠ okpon d̠o̠ ma̠ odi o̠ni̠ a̠gurumeni, abhe̠l opa̠n, sa̠ anwa na̠ a̠bhin iya̠gia̠ga̠i bho̠ na̠ atu̠ghu̠me̠ni̠ ma̠ od̠ighi i̠di̠ar eten ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A̠bhon otua̠ otua̠-ebhugh onigha̠ A̠siza̠ ke̠re̠, bo̠d̠o̠ ka̠ na̠ obhon d̠o̠?” ");
INSERT INTO mgj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ya̠a̠, i̠na abi̠gho̠m ipesi d̠awa sa̠ i̠na awo̠ran awa ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ileriome ami̠ ma̠ adi̠nari̠. U̠le̠m a̠misigh ta̠ a̠nyen, sa̠ u̠ge̠ ma̠ a̠d̠ien ta̠ a̠nyen d̠a̠ anyu̠ bho̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “A̠misigh ta̠ A̠siza̠.” ");
INSERT INTO mgj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Sa̠ i̠na awo̠ran awa ma̠a̠, “O̠ku̠a bha̠, imulumeni ma̠ enigha̠ ma̠ A̠siza̠ ma̠ i̠di̠ar ta̠ A̠siza̠, ma̠ enigha̠ ma̠ A̠zib̠a̠ ma̠ ita̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Awa i̠kpati̠ i̠na ma̠ osor, ya̠a̠ awo̠ran d̠o̠yo̠ a̠d̠ighi ma̠ ola̠ awa orue d̠o̠ ma̠ osibh o̠yo̠ d̠a̠ esa̠d̠io a̠nwunom bho̠. Kpe̠le̠me̠ni̠ bha̠ awo̠ran d̠o̠yo̠ a̠d̠igh awa ma̠ ilologia̠n o̠mu̠gho̠n, sa̠ awa inima̠ i̠ro̠ b̠o̠b̠o̠m. ");
INSERT INTO mgj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Idi Rasadusi, ya̠ oma̠ra̠ d̠o̠ ma̠ ob̠etina̠ d̠a̠ omugh odi bho̠, i̠gi̠ ka̠ i̠te̠i̠ A̠zizo̠s epura̠n ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“O̠ni̠ atu̠ghu̠me̠ni̠, A̠mozizi age̠ a̠nigha̠ i̠yar ma̠a̠, ku̠gba ma̠ umor o̠ni̠ a̠mugh awe̠le̠man ani̠ d̠o̠yo̠ ad̠u̠a, ya̠a̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠, ma̠a̠, o̠ni̠ bho̠ ta̠ a̠bhin ani̠ umor bho̠ b̠o̠ka̠ ate̠i̠ anwi̠i̠ny a̠nigha̠ ma̠ umor d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","I̠se̠n bha̠ od̠ua̠l a̠rumor e̠ro̠; sa̠ o̠pu̠r bho̠ a̠bhin ani̠ ya̠a̠ i̠na na̠ o̠mar d̠o̠ sa̠ a̠mugh awe̠le̠man ani̠ bho̠ ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sa̠ oleghemeni i̠wal umor bho̠ a̠bhin ani̠ bho̠, i̠na eka̠ na̠ o̠mar d̠o̠ ma̠ o̠nyi̠ sa̠ a̠mugh. ");
INSERT INTO mgj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sa̠ oleghemeni i̠sar umor bho̠ a̠bhin ani̠ bho̠. O̠ku̠a oku̠a tu̠tu̠n eb̠la̠ a̠rumor bho̠ ibhin ani̠ bho̠ sa̠ imugughu, i̠mar d̠o̠ ma̠ anwi̠i̠ny eguri. ");
INSERT INTO mgj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ekunuguma̠ bho̠ sa̠ ani̠ bho̠ a̠mugh nyen. ");
INSERT INTO mgj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gba ma̠ a̠nigha̠ i̠yar, igiel ob̠etina̠ d̠a̠ omugh bho̠ ka̠, ani̠ bho̠ ta̠ aro̠ ma̠ ani̠ ta̠ a̠nyen, d̠a̠ ebula̠ agu̠o̠ ani̠ bho̠ na̠ awal eb̠la̠ od̠ua̠l a̠rumor bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sa̠ A̠zizo̠s awo̠ran ma̠a̠, “A̠nwunom ya̠ i̠ro̠ igboloma̠ ma̠ amu̠m onon bho̠ ta̠ ebhinogh anwani̠, sa̠ ta̠ onigha̠nom anwi̠nyan anwi̠i̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ya̠a̠, d̠a̠ ogbo ya̠ A̠zib̠a̠ na̠ ada a̠bhin, ma̠ awa e̠kpe̠ ma̠ ob̠egina̠ d̠a̠ omugh od̠igh d̠a̠ amu̠m wa̠ na̠ a̠ru bho̠, ilom bo̠; ");
INSERT INTO mgj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","awa ko omugh mu, ezin bho̠ awa ta̠ e̠ro̠ ka̠ itileduom ta̠ A̠zib̠a̠. Awa anwi̠i̠ny ta̠ A̠zib̠a̠, ezin bho̠ awa anwi̠i̠ny ya̠ na̠ eb̠egina̠ d̠a̠ omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ya̠a̠ d̠a̠ i̠di̠ar ya̠ igboloma̠ ma̠ ob̠etina̠ d̠a̠ omugh bho̠, A̠mozizi eka̠ agba a̠mutiom d̠a̠ asu̠gbagba d̠o̠yo̠, wa̠ ed̠um bho̠ a̠mumor ya̠a̠ o̠nu̠ d̠o̠ bho̠. A̠mozizi a̠bhelegi ma̠ Wa̠nwuna̠ bho̠ ma̠a̠, ‘A̠zib̠a̠ ta̠ Ebraham, A̠zib̠a̠ ta̠ Azi̠ki̠, na̠ A̠zib̠a̠ ta̠ A̠zeko̠pu̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠na A̠zib̠a̠ imumugh d̠o̠, ya̠a̠ i̠na ola̠ ogbo ya̠ od̠i d̠a̠ a̠ghud̠um; ezin bho̠, d̠o̠yo̠ eb̠la̠ awa od̠i d̠a̠ a̠ghud̠um.” ");
INSERT INTO mgj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sa̠ idi ogbo atu̠ghu̠me̠ni̠ oloko bho̠ i̠wo̠ran ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, anwa amar agba ma̠ asu̠gbagba bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ebula̠ o̠ku̠a, o̠ni̠ ola̠ a̠mula̠ a̠ne ma̠ o̠kpato̠n o̠nu̠ opura̠n abar na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere wa̠ u̠gba ma̠a̠, Akrai̠st wa̠ A̠zib̠a̠ aso̠n a̠doni bho̠ ma̠ o̠nyi̠ ta̠ A̠devidi bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ezin bho̠, A̠devidi na̠ agu̠o̠ agba a̠mutiom d̠a̠ A̠d̠ire Raso̠r bho̠ ma̠a̠, “ ‘Wa̠nwuna̠ bho̠ agba a̠nigha̠ ma̠ Wa̠nwuna̠ d̠ami̠ ma̠a̠: “Ri̠la d̠a̠ od̠iom agu̠o̠ d̠ami̠, ");
INSERT INTO mgj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tu̠tu̠n ami̠ ta̠ a̠tenemeni ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom ma̠ okpokpolom ola̠ o̠gbam a̠sike d̠oyom.” ’ ");
INSERT INTO mgj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A̠devidi a̠bhelegi gha̠n i̠na ma̠a̠, ‘Wa̠nwuna̠.’ O̠ku̠a ka̠ i̠na a̠ten eka̠ aro̠ ma̠ o̠nyi̠ d̠o̠yo̠?” ");
INSERT INTO mgj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Igiel bho̠ eb̠la̠ a̠nwunom bho̠ na̠ e̠nagha i̠na bho̠, sa̠ A̠zizo̠s agba a̠nigha̠ ma̠ ogbo atu̠ghan d̠o̠yo̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“I̠mare̠ ma̠ ekpona̠ ma̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠. Awa iba̠ra̠ ma̠ opa̠n obura̠ ibom rakapa isosor, sa̠ iba̠ra̠ ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ ebhin d̠a̠ ozuruna̠ eghoi ebheleguma̠ awa d̠a̠ regbolom a̠b̠ua̠, sekina̠ o̠ro̠ d̠a̠ ra̠dila̠de edim d̠a̠ a̠rutu u̠gala A̠zu, na̠ o̠ro̠ d̠a̠ rakpata o̠d̠e̠ ya̠ edim. ");
INSERT INTO mgj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Awa na̠ eponoma̠ ma̠ rekpukele anwani̠ na̠ e̠wo̠ro̠gh i̠di̠ar, sa̠ awa na̠ esiseiny iwewegh a̠siseiny b̠o̠ka̠ olelegi awa. Ta̠ o̠gu̠r awa ma̠ agu̠o̠ i̠zagba ola̠ abu̠gh ibom.” ");
INSERT INTO mgj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Igiel bho̠ A̠zizo̠s a̠b̠eka̠ a̠kpon bho̠, sa̠ i̠na abi̠gh a̠d̠ien agu̠o̠ aru̠li̠la bho̠ na̠ ebhin na̠ e̠lo̠gi̠ ma̠ ikpoki ali̠se̠bh d̠awa d̠a̠ igba̠ o̠da ikpoki bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","I̠na abi̠gh nyen ka̠ odi onyigoiny ekpukele ani̠, agi̠ ka̠ alo̠gh i̠wal i̠gbara ikpoki ako̠pa d̠a̠ ologi igba̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sa̠ i̠na a̠mutiom okoroko ma̠a̠: “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, eb̠la̠ ogbo ya̠ i̠lo̠gi̠ ma̠ i̠di̠ar e̠ne̠ghe̠ d̠a̠ igba̠ bho̠, onyigoiny ekpukele ani̠ onon alo̠gh a̠pu. ");
INSERT INTO mgj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ezin bho̠, eb̠la̠ a̠nwunom i̠nye̠n na̠ ibom e̠li̠la d̠awa, wa̠ a̠ru, ape̠to̠n o̠nyi̠ esi d̠a̠ e̠li̠la d̠o̠yo̠ alo̠gh. Ya̠a̠, d̠a̠ ologi igoiny d̠o̠yo̠, i̠na a̠kpukpu ma̠ eb̠la̠ ya̠ i̠na a̠nwuna̠ bho̠ alo̠gh.” ");
INSERT INTO mgj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Idi ogbo atu̠ghan d̠o̠yo̠ i̠ro̠ na̠ e̠b̠e̠re̠gi̠an na̠ egboloma̠ ma̠ a̠libhon Otu ta̠ A̠zib̠a̠, d̠a̠ e̠mi̠ agu̠o̠ ubhin ib̠eb̠i i̠gbaki̠ghe̠, na̠ i̠d̠i̠ar e̠ne̠ghe̠ ya̠ ub̠eton u̠lo̠gh d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠ uburi ma̠ otu bho̠. Ya̠a̠ A̠zizo̠s agba ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“I̠di̠ar i̠nye̠n ya̠ inyin na̠ o̠bi̠gh i̠se̠n bho̠, obhel na̠ a̠ru ma̠ ola̠ bebina̠ ekpo o̠gbaki̠ghe̠ ko o̠ro̠ d̠o̠ d̠a̠ anyu̠ ta̠ odi; ta̠ ob̠ogion eb̠la̠yi osoroni.” ");
INSERT INTO mgj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sa̠ awa ipura̠n i̠na ma̠a̠, “O̠ni̠ atu̠ghu̠me̠ni̠, i̠di̠ar i̠nye̠n ka̠ ta̠ emite ma̠ a̠kere igiel? Sa̠ a̠nwunom ta̠ ebhin a̠kere a̠d̠ien elegh eloghom ma̠ i̠di̠ar i̠nye̠n na̠ etua̠n omite?” ");
INSERT INTO mgj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sa̠ i̠na awo̠ran ma̠a̠, “I̠mare̠ ma̠ ekpona̠ b̠o̠ka̠ ugelemeni inyin; ezin bho̠ a̠d̠izo a̠nwunom ta̠ ebhin a̠d̠ien d̠ami̠ eru, sa̠ awa ta̠ ekue inyin e̠gba ma̠a̠, ‘Ami̠ Witenemeni bho̠, obhel bho̠ na̠ a̠tua̠n!’ Ya̠a̠, o̠ni̠ ko od̠umom e̠tu̠o̠no̠m awa. ");
INSERT INTO mgj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Igiel inyin umugho̠n i̠mu̠mu̠gho̠n e̠gham na̠ a̠d̠ien kerekere a̠d̠ugh e̠mu̠, o̠ni̠ ko okpa̠ra̠noma̠. Ezin bho̠, i̠di̠ar i̠nye̠n ta̠ ed̠ia̠ emite; ku̠ku̠m eka̠, ta̠ o̠te̠i̠ d̠o̠ ma̠ ekunuguma̠ ma̠ i̠se̠ onin obhel bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “Ebhugh ta̠ a̠b̠etina̠ a̠wia̠n ebhugh, sa̠ a̠de e̠ma ta̠ a̠wia̠n a̠de e̠ma. ");
INSERT INTO mgj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sa̠ a̠d̠izo ibom ib̠ob̠omia̠n a̠de ta̠ emite, sa̠ o̠ko̠i̠ ed̠ia̠n na̠ i̠karabh asu̠nwe̠r ta̠ esor a̠d̠izo a̠risisi; sa̠ ra̠d̠ugh ibom a̠rugugu na̠ ibom ilologia̠n ta̠ e̠d̠u̠a d̠a̠ ote̠nai̠ny emite. ");
INSERT INTO mgj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ya̠a̠, kisa̠ eb̠la̠ i̠nye̠n ta̠ emite, ta̠ ogbikimeni inyin ibom. Ta̠ ob̠ologh inyin, sa̠ ta̠ obhin inyin ka̠ od̠ighom d̠a̠ ru̠gala A̠zu na̠ a̠rutu ikoli, sa̠ ta̠ obhin inyin ka̠ o̠marame̠ni̠ d̠a̠ a̠misigh aru̠li̠le̠ma na̠ ogbo aru̠mu̠ rebhugh, d̠a̠ ebula̠ a̠d̠ien d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sa̠ onon ta̠ a̠nigha̠ inyin e̠ti̠ti̠gha ola̠ obhin o̠gba ami̠ omutiom. ");
INSERT INTO mgj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko o̠nyo̠gho̠ghan egboloma̠ ma̠ agu̠o̠ obhin o̠gba o̠nu̠ o̠bhe̠la, d̠a̠ riku ya̠ awa ta̠ eleregi inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ezin bho̠, ami̠ ta̠ a̠nigha̠ inyin a̠ga̠i o̠nu̠o̠kpe̠ na̠ eloghom abar ya̠ ogbo o̠lo̠gi̠an a̠rid̠ien d̠inyin ko orue d̠o̠ e̠damaghan, bo̠d̠o̠ e̠gba e̠ne̠gi̠me̠ni̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ogbo ya̠ i̠mar itua̠n inyin eka̠-roweni na̠ rowede d̠inyin, a̠rumor na̠ a̠ghisia̠n, na̠ ra̠tologha̠n ta̠ ewol inyin. Sa̠ awa ta̠ e̠ze̠gi̠ ma̠ idi inyin. ");
INSERT INTO mgj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ko̠ni̠ko̠ni̠ ta̠ a̠din ami̠ alo̠gh inyin a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ya̠a̠, ekpo asi̠ghal e̠mu̠ d̠inyin ola̠ ta̠ akadi̠na a̠bhe ko o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","O̠ku̠a a̠d̠ighi be̠le̠ni̠ ine ma̠ e̠ro̠, sa̠ inyin ta̠ otenemeni ma̠ aru̠mu̠gh d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Igiel inyin u̠bi̠gh ka̠ ro̠lo̠gh ogbo-e̠gham na̠ eko ma̠ e̠ma A̠zeruse̠le̠m ekiton, bha̠ iloghome ma̠ obhel okunugi o̠yo̠ na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Obhel o̠ku̠a, ogbo ya̠ od̠i d̠a̠ A̠zudia̠ bho̠ ekpo ma̠ eghil e̠gi̠ d̠a̠ rigu bho̠, ogbo ya̠ od̠i d̠a̠ esa̠d̠io e̠ma bho̠ eten e̠d̠u̠a, ogbo ya̠ od̠i d̠a̠ re̠sala aka e̠ma bho̠, ya̠ od̠i ma̠ ipa̠n a̠risisi bho̠ eka̠, omula̠ d̠o̠ ed̠igh d̠a̠ e̠ma bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ezin bho̠ i̠nye̠ ta̠ e̠ro̠ ma̠ ra̠d̠a̠ma̠ od̠e olo ta̠ A̠zib̠a̠, ma̠ omuzoghod̠iom iwowa̠ ya̠ u̠ge̠ uguri bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ekulom anwani̠ a̠rughun na̠ anwani̠ amu̠gbo̠ d̠a̠ ra̠d̠a̠ma̠ i̠nye̠! Ezin bho̠ ibom i̠kparama ado̠l ta̠ emuzo d̠a̠ a̠de bho̠ na̠ ibom i̠gam ya̠ A̠zib̠a̠ ta̠ agam a̠nigha̠ ma̠ a̠nwunom i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Idi awa ta̠ emugughu d̠a̠ alapa ogidi, sa̠ ta̠ obhin idi awa od̠ighom ikoli d̠a̠ eb̠la̠ rebhugh e̠mara̠nwunom. Sa̠ ogbo o̠ro̠ d̠o̠ ma̠ A̠zu bho̠ ta̠ ebhin a̠de ma̠ A̠zeruse̠le̠m, tu̠tu̠n ta̠ omuzoghod̠iom obhel ta̠ ogbo o̠ro̠ d̠o̠ ma̠ A̠zu bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Relegh ta̠ emite d̠a̠ ogogo bho̠, na̠ uwetire bho̠ na̠ i̠ni̠nai̠ny bho̠. D̠a̠ a̠de onon sa̠ a̠d̠ugh ta̠ a̠bhin rebhugh bho̠, sa̠ e̠mi̠ oghur rabadi̠ bho̠ na̠ e̠gi̠o̠m anyu̠ ropoka̠n amu̠m bho̠, na̠ irorua̠ amu̠m o̠bhaghan na̠ okeleghel bho̠ ta̠ ed̠igh awa ma̠ ilologia̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A̠nwunom ta̠ e̠fu̠mu̠ d̠a̠ ebula̠ a̠rugugu i̠di̠ar ya̠ ta̠ emite d̠a̠ e̠mara̠nwunom bho̠. Ezin bho̠ ra̠limon e̠nai̠ny bho̠ ta̠ enyegia̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","D̠a̠ obhel obha̠, sa̠ awa ta̠ e̠bi̠gh O̠nyi̠ ta̠ O̠ni̠ d̠a̠ o̠b̠u̠ghu̠b̠u̠gh bho̠, ya̠ na̠ a̠ru na̠ a̠limon na̠ ibom isosorogia̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Igiel i̠di̠ar i̠nye̠n na̠ e̠ke̠ na̠ emite, bha̠ ib̠etina̠ ma̠ e̠mara, ma̠ eb̠eka̠ ma̠ ekpon d̠a̠ anyu̠; ezin bho̠ oten d̠inyin na̠ a̠tua̠n.” ");
INSERT INTO mgj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sa̠ i̠na a̠rogh a̠sidogh a̠nigha̠ awa ma̠a̠: “Ikpone ma̠ oriren wa̠ ubhelegi ma̠ a̠fig bho̠ na̠ eb̠la̠ iriren bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Igiel i̠mu̠nu̠mu̠n d̠awa na̠ e̠mu̠r na̠ emite, bha̠ inyin na̠ ologhom ma̠ a̠d̠io a̠kozogh na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Onin agu̠o̠ bho̠, igiel inyin u̠bi̠gh ka̠ i̠di̠ar i̠nye̠n na̠ emite, bha̠ iloghome ma̠a̠, irileghom ta̠ A̠zib̠a̠ na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, a̠nwunom ya̠ od̠i d̠a̠ a̠ghud̠um d̠a̠ amu̠m onon bho̠, ko omugughu d̠o̠ e̠man, kisa̠ eb̠la̠ i̠di̠ar i̠nye̠n ta̠ emite e̠man. ");
INSERT INTO mgj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A̠de na̠ e̠nai̠ny na̠ ta̠ eten emunia̠n, ya̠a̠ o̠nu̠-o̠kpe̠ d̠ami̠ ta̠ e̠ri̠la tu̠tu̠n ka̠ id̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","I̠mare̠ ma̠ ekpona̠! O̠ni̠ ko oma̠ra̠ ma̠ i̠karabh i̠ru̠ru̠an na̠ i̠ku̠nu̠, na̠ e̠ye̠gha ogir o̠d̠a a̠min, na̠ i̠nyo̠gho̠nyo̠gh a̠ghud̠um ma̠ odughumeni rologi d̠inyin, ma̠ ola̠ a̠d̠a̠ma̠ obha̠ ta̠ a̠ru ra̠ a̠bhin inyin awai̠ ");
INSERT INTO mgj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ma̠ agu̠o̠ abar ola̠ u̠kpati̠. I̠di̠ar i̠nye̠ ta̠ emutuma̠ ko̠ni̠ko̠ni̠ ola̠ na̠ a̠rugh d̠a̠ a̠de no̠. ");
INSERT INTO mgj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Igone ma̠ esiseiny kigiel kigiel, b̠o̠ka̠ inyin o̠te̠i̠ e̠mi̠ omiza̠n eb̠la̠ ra̠d̠ugh ya̠ ta̠ emite bho̠, na̠ orue o̠mara d̠a̠ a̠misigh ta̠ O̠nyi̠ ta̠ O̠ni̠.” ");
INSERT INTO mgj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ka̠d̠a̠ma̠ ka̠d̠a̠ma̠, A̠zizo̠s atu̠ghu̠me̠ni̠ghan a̠nwunom d̠a̠ otu ta̠ A̠zib̠a̠, sa̠ i̠na agi̠gha̠n ka̠ aro̠ d̠a̠ igu wa̠ ubhelegi ma̠ Oliv bho̠ ma̠ a̠d̠uga̠la̠n. ");
INSERT INTO mgj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sa̠ eb̠la̠ a̠nwunom bho̠ ib̠on gha̠n ib̠etina̠ ma̠ ame̠ghe̠le̠ i̠gi̠ ka̠ i̠nagha i̠na d̠a̠ otu ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Igiel bho̠ na̠ a̠tua̠n E̠yal Abe̠re̠di̠ Ya̠ Owubh D̠o̠ bho̠, wa̠ ubhelegi ma̠ E̠yal Opel Oten bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sa̠ we̠mu̠ rokur bho̠ na̠ ogbo ya̠ na̠ e̠ku̠ro̠m d̠a̠ roloko bho̠ ima̠ra̠nua̠n ogigh A̠zizo̠s. Ya̠a̠, awa ighil a̠nwunom bho̠, ezin bho̠ awa ipuru d̠o̠ ma̠ elobhiri ma̠ osor. ");
INSERT INTO mgj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sa̠ Eru Bho̠ a̠d̠igh A̠zuda̠s wa̠ ubhelegi ma̠ Iskari̠o̠t bho̠, wa̠ aro̠ ma̠ odi o̠ni̠ d̠a̠ ologi a̠d̠iobh na̠ i̠wal ogbo atu̠ghan bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sa̠ i̠na agi̠ ka̠ ate̠i̠ ogbo aru̠mu̠ rokur ta̠ A̠zib̠a̠ na̠ ogbo aru̠mu̠ ogbo ya̠ na̠ ekponom otu ta̠ A̠zib̠a̠ bho̠, ma̠ o̠mu̠gho̠nyan agu̠o̠ owol A̠zizo̠s onigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Sa̠ a̠d̠igh awa ma̠ ologi ma̠ opa̠n, sa̠ awa ima̠ra̠nua̠n onigha̠ o̠yo̠ ma̠ ikpoki. ");
INSERT INTO mgj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sa̠ i̠na a̠ma̠ra̠nua̠n awa, sa̠ i̠na ake̠ ma̠ o̠bho̠ro̠ghan obhel ola̠ ta̠ a̠sora̠n i̠na ma̠ owol A̠zizo̠s onigha̠ awa, b̠o̠ka̠ awa eb̠ol i̠na ma̠ obhel ola̠ a̠nwunom o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","I̠se̠n wa̠ a̠d̠a̠ma̠ E̠yal Abe̠re̠di̠ Ya̠ Owubh D̠o̠ na̠ a̠lei bho̠, ta̠ ogigh o̠nyi̠ o̠nana i̠ko̠l E̠yal Opel Oten. ");
INSERT INTO mgj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sa̠ A̠zizo̠s a̠ruom A̠pita̠ na̠ Azo̠n, sa̠ a̠fugh a̠nigha̠ awa ma̠a̠, “I̠gi̠e̠ ma̠ ka̠ ekokod̠ia̠n ed̠ia̠n E̠yal Opel Oten bho̠ ma̠ enigha̠ i̠yar, b̠o̠ka̠ i̠yar od̠e ma̠ onin esi.” ");
INSERT INTO mgj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sa̠ awa ipura̠n i̠na ma̠a̠, “I̠yar o̠gi̠ d̠a̠ken ka̠ okokod̠ia̠n e̠yal bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Agu̠o̠ bho̠ inyin ud̠igh d̠a̠ e̠ma bho̠, o̠ni̠ ola̠ na̠ a̠rol afa amu̠m ta̠ abi̠ghan inyin. I̠tu̠o̠no̠me̠ i̠na ma̠ e̠gi̠ ka̠ ed̠igh d̠a̠ otu wa̠ i̠na ta̠ a̠pel a̠d̠igh bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma̠ e̠gba ma̠ enigha̠ ma̠ o̠ni̠ wa̠nwuna̠ ma̠ otu bho̠ ma̠a̠, ‘O̠ni̠ atu̠ghu̠me̠ni̠ bho̠ na̠ a̠pura̠n anwa ma̠a̠: Oken e̠kpe̠ isuloma̠ wa̠ ami̠ ta̠ a̠d̠igh na̠ ogbo atu̠ghan d̠ami̠ a̠d̠e ma̠ E̠yal Opel Oten bho̠?’ ");
INSERT INTO mgj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sa̠ i̠na ta̠ a̠leriom inyin obom e̠kpe̠ otu ola̠ na̠ o̠mar oburi oguri d̠a̠ otu anyu̠. I̠ro̠ ma̠ i̠se̠ ma̠ ekokod̠ia̠n ed̠ia̠n E̠yal Opel Oten bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Sa̠ awa iten i̠gi̠, sa̠ i̠bi̠gh ma̠ eb̠la̠ i̠di̠ar bho̠ od̠i ma̠ agu̠o̠ i̠na agba a̠nigha̠ awa bho̠: sa̠ awa i̠ro̠ ma̠ i̠se̠ ikokod̠ia̠n ed̠ia̠n E̠yal Opel Oten bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Igiel obhel bho̠ a̠lei bho̠, sa̠ A̠zizo̠s na̠ ogbo ogir d̠o̠yo̠ i̠ro̠ ma̠ a̠dila̠de. ");
INSERT INTO mgj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Na̠ ebhir ami̠ ka̠ obom igiel od̠igh na̠ inyin od̠e E̠yal Opel Oten onon, kisa̠ ami̠ ta̠ a̠gbika̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ami̠ ko od̠e mu ma̠ ed̠ia̠n i̠nye̠n, a̠ten ka̠ na̠ omuzoghod̠iom d̠a̠ irileghom ta̠ A̠zib̠a̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sa̠ i̠na a̠bhin okpa̠ko a̠min bho̠, sa̠ ase̠bh A̠zib̠a̠, sa̠ a̠fugh ma̠a̠, “Ibhine ma̠ e̠ru̠gi̠an e̠d̠a. ");
INSERT INTO mgj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ami̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ami̠ ko o̠d̠a mu ma̠ a̠min a̠grep, a̠ten ka̠ irileghom ta̠ A̠zib̠a̠ na̠ a̠ru.” ");
INSERT INTO mgj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sa̠ i̠na a̠bhin abe̠re̠di̠ bho̠, sa̠ i̠na ase̠bh A̠zib̠a̠, sa̠ a̠puiny a̠nigha̠ awa, sa̠ a̠fugh ma̠a̠, “Onon ozu d̠ami̠ wa̠ na̠ onigha̠ inyin bho̠. Igire ma̠ o̠ko̠no̠n ma̠ e̠ru̠ru̠an ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Onin agu̠o̠ bho̠, ma̠ igiel bho̠ awa na̠ ed̠e e̠we̠le̠ bho̠, sa̠ i̠na a̠fugh ma̠a̠, “Okpa̠ko onon omom i̠zo̠ ta̠ A̠zib̠a̠, ola̠ na̠ ozu ma̠ asi̠ d̠ami̠, ma̠ obhin o̠ta inyin. ");
INSERT INTO mgj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ya̠a̠, ikpone! Agu̠o̠ o̠ni̠ wa̠ ta̠ a̠wol ami̠ bho̠, od̠i na̠ ami̠ d̠a̠ onin akpata od̠e bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta̠ ogir onigha̠ ma̠ O̠nyi̠ ta̠ O̠ni̠, ma̠ agu̠o̠ na̠ o̠to̠ oguri bho̠. Ya̠a̠, itogi e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ ta̠ a̠wol i̠na bho̠!” ");
INSERT INTO mgj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sa̠ odi ake̠ ma̠ opura̠n odi ma̠a̠, a̠nyen o̠ni̠ wa̠ ta̠ a̠gir o̠ku̠a bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sa̠ aku̠a̠nan a̠sor d̠a̠ esa̠d̠io d̠awa ma̠a̠: “A̠nyen o̠ni̠ wa̠ ta̠ o̠bi̠gh ma̠ i̠na abu̠gh a̠pu bho̠?” ");
INSERT INTO mgj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ awa ma̠a̠, “Aru̠li̠le̠ma ogbo o̠ro̠ d̠o̠ ma̠ A̠zu bho̠, na̠ ebhin ibom a̠limon na̠ erileghom a̠nwunom d̠awa, sa̠ ogbo ya̠ awa na̠ erileghom bho̠ na̠ ebhelegi awa ma̠ ib̠eb̠i a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ya̠a̠, o̠ri̠la d̠o̠ ma̠ o̠ku̠a d̠a̠ esa̠d̠io d̠inyin. Ari̠la ka̠ ma̠ ola̠ o̠ni̠ wa̠ abu̠gh a̠pu d̠a̠ esa̠d̠io d̠inyin bho̠, ta̠ o̠bi̠gh ma̠ i̠na aki̠r a̠pu; ya̠a̠, i̠na o̠ni̠ wa̠ na̠ a̠rileghom bho̠ ta̠ aro̠ ka̠ ob̠a̠ra̠motu. ");
INSERT INTO mgj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","D̠a̠ inyin ka̠ a̠nyen abu̠gh a̠pu? I̠na wa̠ d̠a̠ akpata od̠e bho̠ ke̠re̠, bo̠d̠o̠ ka̠ i̠na wa̠ na̠ aru̠gi̠ ma̠ ed̠ia̠n bho̠? I̠na wa̠ od̠i d̠a̠ akpata od̠e bho̠! Ya̠a̠, ami̠ od̠i d̠a̠ esa̠d̠io d̠inyin ka̠ o̠ni̠ wa̠ na̠ aru̠gi̠ ma̠ ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Inyin ogbo ya̠ na̠ ed̠igh na̠ ami̠ e̠ro̠ d̠a̠ eb̠la̠ rad̠agi̠an d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agu̠o̠ O̠we̠de̠ d̠ami̠ a̠nigha̠ ami̠ ma̠ a̠dila̠de irileghom d̠o̠yo̠ bho̠, onin agu̠o̠ bho̠ ami̠ na̠ a̠nigha̠ inyin a̠dila̠de irileghom bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","b̠o̠ka̠ inyin od̠igh na̠ ami̠ od̠e, o̠d̠a d̠a̠ akpata od̠e d̠ami̠ d̠a̠ irileghom d̠ami̠. Sa̠ inyin ta̠ o̠ri̠la d̠a̠ ibom ra̠dila̠de irileghom, orileghom d̠iobh na̠ i̠wal roghol Izre̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Asai̠mo̠n, Asai̠mo̠n, kpona̠! Eru Bho̠ na̠ a̠puru ma̠ onyegi eb̠la̠ inyin, ma̠ agu̠o̠ na̠ obhin ozeghema̠ na̠ ozeghe ma̠ i̠bu̠kpa. ");
INSERT INTO mgj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ya̠a̠, ami̠ na̠ a̠siseiny a̠nigha̠ nyam, ma̠ agu̠o̠ ola̠ ologi ima̠ra̠ d̠oyom ko od̠im d̠o̠. Igiel anwa na̠ a̠tiba̠ra̠, ghu̠ame̠ni̠ ma̠ a̠rumor d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sa̠ A̠pita̠ awo̠ran i̠na ma̠a̠, “Wa̠nwuna̠, ami̠ na̠ a̠kokod̠ia̠n o̠tu̠o̠no̠m oyom o̠gi̠ ikoli sekina̠ omugh.” ");
INSERT INTO mgj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sa̠ A̠zizo̠s awo̠ran A̠pita̠ ma̠a̠, “A̠pita̠, ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, kisa̠ olobhiri e̠nu̠r-e̠ma ta̠ alal a̠didon, anwa ta̠ aku̠a ami̠ i̠sar igiel ma̠ anwa na̠ ologhom d̠o̠ ami̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sa̠ A̠zizo̠s a̠pura̠n awa ma̠a̠, “Obhel bho̠ ami̠ iruom inyin ka̠ o̠gba ib̠eb̠i asu̠gbagba bho̠, sa̠ ami̠ ifugh ma̠ o̠ni̠ ko o̠b̠ar na̠ o̠kara, e̠kpa, bo̠d̠o̠ agbaka ma̠ ebhin e̠gi̠ bho̠, abar ola̠ akparama inyin aro̠ ke̠re̠?” Sa̠ awa i̠wo̠ran ma̠a̠, “E̠e̠nyi̠, abar ola̠ akparama i̠yar na̠ o̠ro̠ d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “A̠b̠eton i̠se̠n agi̠ d̠a̠ ed̠ia̠, o̠ni̠ ola̠ a̠nwuna̠ ma̠ e̠kpa ikpoki a̠bhin; onin agu̠o̠ bho̠, wa̠ a̠nwuna̠ ma̠ okuru anya. Ya̠a̠ o̠ni̠ ola̠ onwuna̠ d̠o̠ ma̠ alapa ogidi, a̠wol obom akapa d̠o̠yo̠ wa̠ na̠ o̠lagha d̠a̠ anyu̠ bho̠ a̠gho ma̠ odi. ");
INSERT INTO mgj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ami̠ na̠ agba na̠ a̠nigha inyin ma̠a̠, ta̠ omuzoghod̠iom abar wa̠ u̠ge̠ ugboloma̠ ami̠ d̠a̠ ra̠d̠ire iwowa̠ bho̠ ma̠a̠, ‘U̠wal ani̠ i̠na o̠lo̠gh d̠a̠ ogbo id̠ighi ma̠ i̠karabh.’ Sa̠, eb̠la̠ i̠di̠ar ya̠ a̠riwil bho̠ i̠ge̠ ugboloma̠ ami̠ bho̠ ta̠ emite ga̠i.” ");
INSERT INTO mgj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sa̠ ogbo atu̠ghan bho̠ i̠gba inigha̠ i̠na ma̠a̠, “Wa̠nwuna̠, kpone, i̠nye̠n i̠wal ipod̠i ralapa ogidi.” Sa̠ i̠na awo̠ran awa ma̠a̠, “I̠marame̠ni̠ ma̠ i̠se̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A̠zizo̠s ad̠u̠a d̠a̠ e̠ma bho̠ agi̠ d̠a̠ igu Oliv ma̠ agu̠o̠ bho̠ i̠na na̠ a̠guri gha̠n na̠ a̠gir bho̠; sa̠ ogbo atu̠ghan d̠o̠yo̠ i̠tu̠o̠no̠m i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Igiel bho̠ i̠na a̠misi ma̠ esi bho̠, sa̠ i̠na a̠kikiom awa ma̠a̠, “Isiseinye b̠o̠ka̠ ad̠agi̠an i̠te̠i̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sa̠ i̠na a̠toka̠n ka̠ aro̠ ma̠ esi ola̠ ogbeiny d̠o̠. Sa̠ i̠na a̠kpuluma̠n a̠siseiny ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O̠we̠de̠, ku̠gba ma̠ od̠i d̠a̠ i̠to̠ d̠oyom, si̠ghe̠ ma̠ okpa̠ko onon d̠a̠ ozu d̠ami̠; ku̠ku̠m eka̠, o̠ro̠ d̠o̠ d̠a̠ i̠to̠ d̠ami̠, aro̠ d̠a̠ i̠to̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sa̠ orileduom ta̠ A̠zib̠a̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru ra̠ aghu̠ame̠ni̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ya̠a̠, d̠a̠ ebula̠ i̠ku̠nu̠ i̠di̠ar ya̠ ta̠ emutuma̠ i̠na bho̠, sa̠ i̠na alo̠gh e̠mi̠ a̠siseiny ka̠ ate̠i̠ esi ola̠, onumor d̠o̠yo̠ na̠ e̠gharaghu̠ d̠a̠ a̠de ma̠ agu̠o̠ ikpokpogh asi̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Igiel bho̠ i̠na a̠b̠etina̠ d̠a̠ a̠siseiny bho̠ ka̠ ate̠i̠ ogbo atu̠ghan d̠o̠yo̠ bho̠, sa̠ i̠na abi̠gh ka̠ awa na̠ ekod̠u d̠a̠ ebula̠ i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Ezin ka̠ ere ka̠ inyin na̠ okod̠u? Ib̠etina̠ ma̠ esiseiny, b̠o̠ka̠ ad̠agi̠an na̠ o̠te̠i̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","I̠na od̠id̠ia̠ na̠ a̠fugh, sa̠ o̠lo̠gh a̠nwunom iru. O̠ni̠ wa̠ ubhelegi ma̠ A̠zuda̠s bho̠, odi o̠ni̠ d̠a̠ d̠iobh na̠ i̠wal ogbo atu̠ghan bho̠, a̠rileghom awa a̠ru. Sa̠ i̠na agi̠ ka̠ a̠bhin i̠pi̠pi̠o̠bh a̠bhelegi ma̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sa̠ A̠zizo̠s a̠pura̠n i̠na ma̠a̠, “A̠zuda̠s, anwa na̠ a̠bhin ibheleguma̠ i̠pi̠pi̠o̠bh na̠ a̠wol O̠nyi̠ ta̠ O̠ni̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Igiel bho̠ ogbo atu̠ghan bho̠ i̠bi̠gh i̠di̠ar ya̠ na̠ eru ra̠ omite bho̠, sa̠ awa ipura̠n i̠na ma̠a̠, “Wa̠nwuna̠, i̠yar obhin ralapa ogidi bho̠ owe awa ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sa̠ odi awa a̠sobh od̠iom a̠to ogoni ta̠ we̠mu̠ okur bho̠ a̠b̠uton. ");
INSERT INTO mgj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sa̠ A̠zizo̠s awo̠ran ma̠a̠: “Na̠ a̠bhon. O̠ni̠ ka̠ ogir o̠ku̠a!” Sa̠ i̠na a̠kula̠n a̠to o̠ni̠ bho̠ a̠koko. ");
INSERT INTO mgj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sa̠ A̠zizo̠s a̠fugh a̠nigha̠ ma̠ ogbo aru̠mu̠ rokur bho̠, na̠ we̠mu̠ ogbo ya̠ na̠ ekponom otu ta̠ A̠zib̠a̠ bho̠, na̠ ikei bho̠, ya̠ iru ra̠ ob̠ol o̠yo̠ bho̠ ma̠a̠, “Ami̠ na̠ a̠wia̠n o̠ni̠ ke̠re̠ ma̠ ola̠ inyin na̠ obhin ralapa ogidi na̠ re̠ba̠m na̠ oru ra̠ ob̠ol ami̠? ");
INSERT INTO mgj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ami̠ i̠ri̠la na̠ inyin ka̠d̠a̠ma̠ ka̠d̠a̠ma̠ d̠a̠ otu ta̠ A̠zib̠a̠, ya̠a̠ inyin ub̠ol d̠o̠ ami̠. Ya̠a̠, onon obhel d̠inyin wa̠ a̠limon a̠d̠io azi̠m na̠ a̠rileghom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sa̠ awa ib̠ol i̠na irileghom i̠gi̠ d̠a̠ otu ta̠ we̠mu̠ rokur bho̠, ya̠a̠ A̠pita̠ aro̠ ma̠ esi egbeiny atu̠o̠no̠m awa. ");
INSERT INTO mgj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Obhel bho̠ awa na̠ egbonogi ma̠ anya d̠a̠ esa̠d̠io etire bho̠, sa̠ eb̠la̠ awa i̠ro̠ ma̠ a̠dila̠de ikiton anya bho̠, sa̠ A̠pita̠ a̠d̠igh na̠ awa ari̠la ani̠ ma̠ i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sa̠ odi ob̠a̠ra̠motu o̠nyani̠ a̠bhin e̠b̠alab̠al anya bho̠ a̠lelegi ma̠ A̠pita̠, sa̠ a̠fugh ma̠a̠: “O̠ni̠ onon ari̠la na̠ A̠zizo̠s.” ");
INSERT INTO mgj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sa̠ i̠na aku̠a a̠fugh ma̠a̠: “Ani̠ bho̠, ami̠ iloghom d̠o̠ i̠na.” ");
INSERT INTO mgj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","O̠nyi̠-o̠gbara obhel a̠ten, sa̠ opa̠n o̠ni̠ abi̠gh i̠na sa̠ a̠fugh ma̠a̠, “Anwa odi o̠ni̠ awa.” Ya̠a̠ A̠pita̠ awo̠ran ma̠a̠, “O̠ni̠ bho̠, ami̠ ani̠ d̠o̠!” ");
INSERT INTO mgj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Obhel a̠ten, sa̠ opa̠n o̠ni̠ ari̠la ma̠ ofugh ofugh ma̠a̠, “Kagu̠o̠ kagu̠o̠ u̠gba, i̠na odi o̠ni̠ bho̠, ezin bho̠ i̠na ola̠ Agalili.” ");
INSERT INTO mgj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sa̠ A̠pita̠ awo̠ran ma̠a̠, “O̠ni̠ bho̠, ami̠ iloghom d̠o̠ ma̠ abar anwa na̠ agba.” I̠na od̠id̠ia̠ na̠ awi̠oghan sa̠ olobhiri e̠nu̠r-e̠ma bho̠ alal. ");
INSERT INTO mgj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sa̠ Wa̠nwuna̠ bho̠ a̠tiba̠ra̠ a̠kpon A̠pita̠. Sa̠ i̠na aru̠ru̠an ikpo a̠fugh ta̠ Wa̠nwuna̠ bho̠, ya̠ a̠fugh a̠nigha̠ i̠na bho̠, ma̠a̠, “Anwa ta̠ aku̠a ami̠ ma̠ i̠sar igiel kisa̠ e̠nu̠r ta̠ alal a̠didon.” ");
INSERT INTO mgj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sa̠ i̠na a̠mite d̠a̠ etire ka̠ a̠leghe agba igbir. ");
INSERT INTO mgj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ogbo e̠gham ya̠ na̠ ekponom A̠zizo̠s bho̠, i̠ki̠ri̠ i̠na ed̠ul i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sa̠ awa ibhin abar ibinom a̠rid̠ien d̠o̠yo̠. Sa̠ isorogiom i̠na ma̠ adi̠e̠l ipura̠n ma̠a̠, “Wa̠, ma̠ agba ma̠ o̠ni̠ wa̠ a̠b̠or anwa bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sa̠ awa ikpon abar abar ifugh i̠na, ikpon i̠do̠ti̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A̠d̠io ab̠al a̠sor, sa̠ ikei irileghom bho̠, na̠ ogbo aru̠mu̠ rokur bho̠, na̠ ogbo atu̠ghu̠me̠ni̠ oloko bho̠, ikokod̠ia̠n id̠igh ezue, sa̠ irileghom A̠zizo̠s ka̠ i̠marame̠ni̠ d̠a̠ a̠misigh ogbo aru̠mu̠ i̠to̠ ebhugh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Sa̠ ipura̠n i̠na ma̠a̠, “Anwa Akrai̠st bho̠ ke̠re̠.” Sa̠ A̠zizo̠s awo̠ran awa ma̠a̠, “Ami̠ i̠gba eka̠ a̠nigha̠ inyin, inyin ko oma̠ra̠ d̠o̠, ");
INSERT INTO mgj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka̠ ami̠ ipura̠n inyin abar eka̠, inyin ko oma̠ra̠ d̠o̠ o̠wo̠ran ami̠. ");
INSERT INTO mgj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ya̠a̠ ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, O̠nyi̠ ta̠ O̠ni̠ ta̠ aro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ ta̠ A̠zib̠a̠ wa̠ a̠nwuna̠ ma̠ a̠limon a̠pu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sa̠ eb̠la̠ awa ipura̠n i̠na ma̠a̠, “O̠ku̠a bha̠ anwa O̠nyi̠ ta̠ A̠zib̠a̠, d̠u̠ko̠?” Sa̠ i̠na awo̠ran awa ma̠a̠, “Od̠i ma̠ agu̠o̠ anwa i̠gba bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sa̠ awa i̠gba ma̠a̠, “Ezin ola̠ i̠yar ta̠ o̠tu̠n o̠bho̠ro̠gh opa̠n onyob̠a̠ d̠a̠ e̠kal abar onon, od̠i ke̠re̠? I̠yar na̠ agu̠o̠ na̠ o̠mu̠gho̠n abar bho̠ d̠a̠ o̠nu̠ d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sa̠ eb̠la̠ o̠lo̠gh a̠nwunom bho̠ ib̠egina̠ irileghom A̠zizo̠s ka̠ i̠marame̠ni̠ d̠a̠ a̠misigh ta̠ Apai̠let ");
INSERT INTO mgj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sa̠ awa iler i̠na ma̠ riku, ib̠ologiom i̠na ma̠a̠, “I̠yar u̠bi̠gh ka̠ o̠ni̠ onon na̠ abho̠ro̠gh od̠ineni ebhugh d̠i̠yar, sa̠ na̠ a̠kigima̠ ma̠ a̠nwunom otua̠ otua̠-ebhugh onigha̠ A̠siza̠, sa̠ na̠ are̠ma ma̠ i̠na Akrai̠st, O̠li̠le̠ma.” ");
INSERT INTO mgj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sa̠ Apai̠let a̠pura̠n A̠zizo̠s ma̠a̠, “Anwa O̠li̠le̠ma a̠nwunom A̠zu ke̠re̠?” Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Od̠i ma̠ agu̠o̠ anwa i̠gba bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sa̠ Apai̠let a̠tiba̠ra̠ adama ma̠ ogbo aru̠mu̠ rokur ta̠ A̠zib̠a̠ bho̠, na̠ o̠lo̠gh a̠nwunom bho̠, agba a̠nigha̠ awa ma̠a̠, “Ami̠ i̠bi̠gh d̠o̠ ma̠ abar ola̠ o̠ni̠ onon a̠gir api̠e̠ d̠a̠ riku wa̠ inyin uleregi i̠na bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ya̠a̠, awa i̠ro̠ ma̠ o̠gba o̠gba o̠kparame̠ni̠ ma̠a̠, “I̠na na̠ a̠bhin atu̠ghu̠me̠ni̠ d̠o̠yo̠ na̠ a̠tumugi ma̠ a̠nwunom osorogi akpe̠ d̠a̠ eb̠la̠ A̠zudia̠, ob̠eton d̠a̠ Agalili esi bho̠ i̠na ake̠ bho̠ tu̠tu̠n ra̠ ate̠i̠ enen.” ");
INSERT INTO mgj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Igiel bho̠ Apai̠let amu̠gho̠n e̠kal onon bho̠, sa̠ i̠na a̠pura̠n ku̠gba ma̠ A̠zizo̠s o̠nyi̠ eghun Agalili. ");
INSERT INTO mgj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Igiel bho̠ i̠na ra̠ a̠loghom ma̠ A̠zizo̠s od̠i d̠a̠ ebu i̠to̠ ta̠ E̠ro̠d bho̠, sa̠ i̠na a̠ruom awa ma̠ obhin A̠zizo̠s o̠gi̠o̠m E̠ro̠d. A̠sora̠n ola̠ E̠ro̠d na̠ agu̠o̠ aro̠ d̠a̠ A̠zeruse̠le̠m ma̠ obhel obha̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Obhel igiel E̠ro̠d abi̠gh A̠zizo̠s bho̠, sa̠ i̠na a̠bhon ologi ma̠ ibom, ezin bho̠ na̠ a̠bia̠ i̠na na̠ a̠gon o̠bi̠gh ani̠ A̠zizo̠s. I̠na na̠ amu̠gho̠n o̠du̠ d̠o̠yo̠, sa̠ i̠na na̠ a̠b̠em ologi ma̠ o̠bi̠gh obhel A̠zizo̠s ta̠ a̠gir ilologia̠n d̠a̠ a̠misigh d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","I̠na a̠bhin obhel a̠pura̠n A̠zizo̠s a̠d̠ien kerekere ipura̠n, ya̠a̠ ekpo abar ola̠ A̠zizo̠s awo̠ran i̠na na̠ o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ogbo aru̠mu̠ rokur ta̠ A̠zib̠a̠ bho̠, na̠ ogbo a̠tu̠ghu̠me̠ni̠ oloko ta̠ A̠mozizi bho̠, i̠mara ma̠ i̠se̠ na̠ emulughuom i̠na, na̠ eb̠ologiom i̠na ma̠ ibom ib̠ologiom. ");
INSERT INTO mgj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A̠ga̠i E̠ro̠d na̠ o̠lo̠gh e̠gham d̠o̠yo̠ eka̠, esorogiom i̠na ma̠ adi̠e̠l, e̠ki̠ri̠ i̠na. Sa̠ ibhin obom ob̠eb̠i akapa aru̠li̠la iburi i̠na, sa̠ imulumeni i̠na i̠gi̠o̠m Apai̠let. ");
INSERT INTO mgj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A̠d̠a̠ma̠ obha̠ sa̠ E̠ro̠d na̠ Apai̠let itulugia̠n iten ra̠tologha̠n; ma̠ i̠wal a̠nwunom ya̠ i̠ro̠ ma̠ ogbo o̠lo̠gi̠an a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sa̠ Apai̠let a̠kokod̠i ma̠ ogbo aru̠mu̠ rokur ta̠ A̠zib̠a̠ bho̠, na̠ ikei ogbo ya̠ na̠ erileghom ebhugh bho̠, na̠ a̠nwunom bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","sa̠ agba a̠nigha̠ awa ma̠a̠, “Inyin ubhin o̠ni̠ onon oruom ami̠, o̠gba ma̠ i̠na na̠ a̠tumugi ma̠ a̠nwunom ma̠ osorogi akpe̠. Ami̠ na̠ ad̠a i̠na a̠kpon d̠a̠ a̠misigh d̠inyin, ku̠ku̠m eka̠, ami̠ i̠bi̠gh d̠o̠ ma̠ ezin ola̠ odin osobh ase̠ obhumeni o̠yo̠ d̠a̠ riku ya̠ inyin uleregi i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E̠ro̠d eka̠ na̠ o̠bi̠gh d̠o̠ i̠na api̠e̠, obha̠ ezin bho̠ i̠na a̠mulumeni i̠na a̠ruom i̠yar bho̠. Inyin o̠mar o̠bi̠gh ma̠a̠, abar ola̠ o̠ni̠ onon api̠o̠m ola̠ odin ogigh o̠yo̠ o̠lo̠gh bo̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","D̠a̠ ebula̠ o̠ku̠a, ami̠ ta̠ a̠ruom agu̠o̠ ola̠ ta̠ o̠gu̠ro̠gh i̠na, sa̠ ami̠ ta̠ awe̠le̠man i̠na ma̠ oten oyel.” ");
INSERT INTO mgj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","D̠a̠ i̠to̠to̠gi̠ E̠yal Opel Oten bho̠, akpe̠ ma̠ Apai̠let omutiom odi o̠ni̠, d̠a̠ awa ogbo ya̠ u̠lo̠gh ikoli bho̠ onigha̠ awa ");
INSERT INTO mgj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ya̠a̠, eb̠la̠ o̠lo̠gh a̠nwunom bho̠ ibhin onin okoroko emulughu, e̠gba ma̠a̠, “Si̠ghe̠ ma̠ o̠ni̠ onon ma̠ ebhin ka̠ egigh, ma̠ a̠mutiom Abarabas a̠nigha̠ i̠yar!” ");
INSERT INTO mgj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Abarabas o̠ni̠ ola̠ u̠du̠o̠m d̠a̠ ikoli, d̠a̠ ebula̠ agu̠o̠ i̠na a̠d̠igh na̠ ipa̠n ogbo a̠sorogi ma̠ rakpe̠ d̠a̠ e̠ma bho̠, na̠ owia̠n oghum a̠dila̠de i̠to̠ ebhugh bho̠ obhin, sa̠ a̠gigh o̠ni̠ nyen.) ");
INSERT INTO mgj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa̠ Apai̠let a̠nwe a̠bhelegi awa a̠kikiom, ezin bho̠ i̠na na̠ abho̠ro̠gh omutiom A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ya̠a̠, awa i̠ro̠ ma̠ omulughu omulughu izul ma̠a̠, “I̠du̠ i̠na ma̠ egigh d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠! I̠du̠ i̠na ma̠ egigh d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠!” ");
INSERT INTO mgj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sa̠ i̠na a̠nwe a̠fugh a̠nigha̠ awa ma̠ oleghemeni i̠sar igiel ma̠a̠, “Ezin ka̠ ere, i̠na a̠gir a̠kere a̠d̠ien i̠karabh? Ami̠ i̠bi̠gh d̠o̠ ma̠ ezin ola̠ odin ogigh o̠yo̠. Ebula̠ o̠ku̠a, ami̠ ta̠ a̠ruom o̠gu̠ro̠gh o̠yo̠, sa̠ ami̠ ta̠ a̠mutiom i̠na.” ");
INSERT INTO mgj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sa̠ eb̠la̠ awa i̠ro̠ ma̠ izul izul i̠nyagh ma̠a̠, o̠du̠ ma̠ A̠zizo̠s d̠a̠ e̠mi̠gi̠re̠ni̠an oriren ogigh, sa̠ Apai̠let a̠ma̠ra̠ a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sa̠ Apai̠let a̠sobh ase̠ bho̠ a̠guri ma̠ agu̠o̠ awa na̠ epuru bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sa̠ i̠na a̠mutiom d̠a̠ ikoli bho̠ ma̠ Abarabas, o̠ni̠ wa̠ awa i̠bho̠ro̠gh omutiom onigha̠ awa bho̠, wa̠ a̠d̠igh na̠ ipa̠n ogbo a̠sorogi ma̠ rakpe̠ d̠a̠ e̠ma bho̠, na̠ owia̠n oghum a̠dila̠de i̠to̠ ebhugh bho̠ obhin bho̠, sa̠ a̠gigh nyen o̠ni̠ bho̠. Sa̠ i̠na a̠b̠eton A̠zizo̠s alo̠gh d̠a̠ agu̠o̠ d̠awa ma̠ ogir abar rologi d̠awa ibhir. ");
INSERT INTO mgj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Igiel bho̠ awa na̠ erileghom A̠zizo̠s na̠ e̠d̠u̠a bho̠, sa̠ awa isibh Asai̠mo̠n wa̠ A̠sirin bho̠, d̠a̠ obhel ola̠ i̠na na̠ ad̠u̠a d̠a̠ e̠sala bho̠ na̠ a̠ru ra̠ od̠igh d̠a̠ e̠ma bho̠. Sa̠ awa inigha̠ i̠na ma̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ ma̠ orol o̠tu̠o̠no̠m A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sa̠ obom o̠lo̠gh a̠nwunom i̠tu̠o̠no̠m i̠na d̠a̠ aman. Idi a̠nwunom d̠a̠ o̠lo̠gh bho̠ anwani̠, ya̠ i̠ro̠ ma̠ i̠ku̠nu̠ na̠ e̠gba ma̠ igbir d̠a̠ ebula̠ o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa̠ A̠zizo̠s a̠tiba̠ra̠ a̠kpon awa a̠fugh ma̠a̠, “E-e anwani̠ A̠zeruse̠le̠m! O̠ni̠ ko o̠tu̠n ami̠ ma̠ e̠gba ma̠ igbir, ya̠a̠ i̠gba ma̠ igbir egboloma̠ ma̠ a̠ruzu d̠inyin sekina̠ anwi̠i̠ny d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ezin bho̠ ra̠d̠a̠ma̠ na̠ eru d̠a̠ ed̠ia̠ ma̠ igiel ola̠ awa ta̠ e̠gba ma̠a̠, ‘E̠b̠e̠l re̠mar anwani̠, na̠ a̠rutu-i̠mara ya̠ ta̠ o̠mara̠gi̠ d̠o̠ bho̠, na̠ aru̠mu̠mam ya̠ ta̠ o̠nigha̠ d̠o̠ ma̠ anwi̠i̠ny amu̠mam bho̠.’ ");
INSERT INTO mgj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa̠ “ ‘Awa ta̠ e̠le̠gh rigu bho̠ ma̠a̠, “Imele ma̠ ebhum i̠yar!” Sa̠ awa ta̠ etiba̠ra̠ efugh enigha̠ ma̠ a̠rugugum bho̠ ma̠a̠, “Ikpegiome i̠yar!” ’ ");
INSERT INTO mgj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ku̠gba ma̠ a̠nwunom na̠ egir i̠di̠ar i̠nye̠n obhel ola̠ oriren bho̠ od̠id̠ia̠ ma̠ omom, ka̠a̠, ere ta̠ a̠mite ma̠ obhel ola̠ oriren bho̠ na̠ aghi̠ghara?” ");
INSERT INTO mgj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Awa irileghom ipa̠n i̠wal a̠nwunom, ibom id̠ighi ma̠ i̠karabh, e̠b̠aram na̠ A̠zizo̠s ebhin e̠gi̠ ka̠ ogigh. ");
INSERT INTO mgj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Igiel bho̠ awa i̠gi̠ ka̠ imisi d̠a̠ esi wa̠ ubhelegi ma̠ “Okpokoro E̠mu̠ Bho̠,” sa̠ awa i̠du̠ i̠na d̠a̠ e̠mi̠gi̠re̠ni̠an oriren. Awa i̠b̠aram na̠ ibom id̠ighi ma̠ i̠karabh bho̠ e̠du̠ d̠a̠ re̠mi̠gi̠re̠ni̠an iriren, odi d̠a̠ agba od̠iom d̠o̠yo̠, uwed̠i d̠a̠ ekiel. ");
INSERT INTO mgj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sa̠ A̠zizo̠s a̠mution okoroko ma̠a̠, “O̠we̠de̠, we̠le̠mane̠ ma̠ i̠karabh d̠awa ma̠ a̠nigha̠ awa! Ezin bho̠, awa iloghom d̠o̠ ma̠ abar awa na̠ egir.” Sa̠ awa irobh okob̠a̠ ma̠ o̠loghom agu̠o̠ awa ta̠ ebhin e̠ru̠gi̠an ibura̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A̠nwunom i̠ro̠ ma̠ i̠se̠ na̠ ekpon; ya̠a̠, ogbo aru̠mu̠ bho̠ sa̠ isorogiom i̠na ma̠ adi̠e̠l ma̠a̠, “I̠na a̠tenemeni gha̠n ipa̠n ogbo; i̠se̠n i̠na a̠tenemeni ani̠ ma̠ ozu d̠o̠yo̠, ku̠gba ma̠ i̠na Akrai̠st, O̠ni̠ Wa̠ A̠zib̠a̠ Aso̠n bho̠ ga̠i.” ");
INSERT INTO mgj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ogbo e̠gham bho̠ eka̠ e̠d̠igh ani̠ esorogiom i̠na ma̠ adi̠e̠l, sa̠ inigha̠ i̠na ma̠ a̠min a̠viniga̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Sa̠ i̠ro̠ ma̠ i̠se̠ iduom i̠na ifugh ma̠a̠, “Ku̠gba ma̠ anwa O̠li̠la ebhugh ogbo A̠zu ga̠i, bha̠ tenemeni ma̠ ozu d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Elegh ola̠ u̠du̠ d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠ d̠a̠ agba e̠mu̠ d̠o̠yo̠ aro̠ ma̠ ola̠ u̠ge̠ ma̠a̠, “ONON O̠LI̠LE̠MA OGBO A̠ZU.” ");
INSERT INTO mgj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Odi od̠ighi ma̠ i̠karabh wa̠ u̠b̠aram u̠du̠ u̠ke̠ri̠ bho̠ eka̠, a̠duom i̠na a̠fugh ma̠a̠, “Anwa Akrai̠st bho̠ d̠o̠ ke̠re̠? Tenemeni ma̠ ozu d̠oyom, ma̠ ab̠ar na̠ i̠yar a̠tenemeni!” ");
INSERT INTO mgj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ya̠a̠, od̠ighi ma̠ i̠karabh uwed̠i agam a̠nigha̠ i̠na, a̠fugh ma̠a̠, “Ya̠! Ya̠! Anwa na̠ oghila̠n d̠o̠ ma̠ A̠zib̠a̠ ke̠re̠, ma̠ o̠bi̠gh ma̠ o̠ni̠ onon na̠ i̠yar u̠te̠i̠ onin e̠kal ebhum ase̠ bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","D̠a̠ agba d̠i̠yar, sa̠ a̠sora̠n agu̠o̠ usobh ase̠ bho̠ ubhumeni i̠yar bho̠, ezin bho̠ i̠yar na̠ ob̠u ma̠ asu̠wo̠ i̠karabh ya̠ i̠yar ugir bho̠. Ya̠a̠, o̠ni̠ onon na̠ o̠pi̠o̠m d̠o̠ ma̠ abar.” ");
INSERT INTO mgj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sa̠ i̠na a̠fugh a̠nigha̠ ma̠ A̠zizo̠s ma̠a̠, “A̠zizo̠s, siseiny ru̠ru̠ane̠ ami̠ ma̠ igiel anwa na̠ a̠d̠igh d̠a̠ irileghom d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sa̠ A̠zizo̠s awo̠ran i̠na ma̠a̠, “Ya̠gia̠ga̠i ami̠ na̠ agba na̠ a̠nigha̠ nyam ma̠a̠, a̠didon anwa ta̠ a̠d̠igh na̠ ami̠ aro̠ d̠a̠ Ob̠eb̠i A̠lei bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A̠d̠io bho̠ aro̠ ka̠ na̠ ate̠i̠ azai̠ny, sa̠ azi̠m a̠ru ra̠ a̠kpegiom eb̠la̠ a̠de bho̠ tu̠tu̠n ate̠i̠ i̠sar aki̠lo̠ki̠ d̠a̠ etita̠n a̠d̠io. ");
INSERT INTO mgj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa̠ e̠b̠alab̠al ogogo bho̠ a̠d̠im; sa̠ ukpe wa̠ ubhin usobhom a̠lukpesi e̠tu̠tu̠ d̠a̠ Otu ta̠ A̠zib̠a̠ bho̠, agu̠an d̠a̠ esa̠d̠io aru̠gi̠an i̠wal a̠bin. ");
INSERT INTO mgj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sa̠ A̠zizo̠s a̠bhin obom okoroko ed̠i a̠mulughu ma̠a̠, “O̠we̠de̠, ami̠ na̠ a̠b̠eton e̠mu̠gh d̠ami̠ na̠ alo̠gh d̠a̠ agu̠o̠ d̠oyom.” O̠gba o̠ku̠a o̠we̠le̠ ku̠ku̠m, sa̠ ekpo-epobh d̠o̠yo̠ a̠sobha̠n. ");
INSERT INTO mgj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Igiel bho̠ o̠ni̠ wa̠ na̠ a̠rileghom o̠lo̠gh e̠gham bho̠ abi̠gh i̠di̠ar ya̠ imite bho̠, sa̠ i̠na a̠tutumeni ma̠ A̠zib̠a̠ a̠mutiom okoroko ma̠a̠, “Ya̠ a̠ga̠i, onon aro̠ ma̠ o̠ni̠ e̠b̠ab̠ala.” ");
INSERT INTO mgj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Igiel bho̠ eb̠la̠ ogbo ya̠ isor esi bho̠ i̠bi̠gh i̠di̠ar ya̠ imite bho̠, sa̠ awa ikonya̠ imula̠ iyel na̠ i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ya̠a̠, eb̠la̠ ogbo ya̠ iloghom i̠na bho̠, ka̠ u̠b̠aram na̠ anwani̠ ya̠ i̠ke̠ d̠a̠ Agalili i̠tu̠o̠no̠m i̠na bho̠, i̠mara ma̠ esi egbeiny ekpon i̠di̠ar i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Odi ob̠eb̠i o̠ni̠ ola̠ a̠rugh ado̠l igielake̠ ola̠ ubhelegi ma̠ A̠zose̠fu̠ aro̠, i̠na odi o̠ni̠ d̠a̠ Ogbo I̠to̠ A̠zu. ");
INSERT INTO mgj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Ya̠a̠, i̠na na̠ oma̠ra̠ ani̠ d̠o̠ ma̠ i̠to̠ ogbo aru̠mu̠ iyed̠i.) I̠na ola̠ e̠ma Ari̠mati̠a d̠a̠ ebhugh A̠zudia̠, sa̠ i̠na a̠bhin d̠a̠ ebhiroma̠ na̠ a̠gon eruoma̠ irileghom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I̠na agi̠ ka̠ ate̠i̠ Apai̠let a̠puru ma̠ ozu ta̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sa̠ i̠na agi̠ ka̠ a̠soroni ma̠ egua̠de bho̠ d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠, sa̠ a̠bhin ob̠eb̠i ukpe asi̠ni̠ni̠n a̠bhurugi ma̠ egua̠de bho̠. I̠na asu̠ ma̠ egua̠de bho̠ awe̠le̠ sa̠ a̠bhin ka̠ a̠d̠i d̠a̠ omom od̠i, esi ola̠ ub̠u d̠a̠ o̠gbi̠o̠ma umutiom, ola̠ ta̠ od̠i d̠o̠ ma̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Obha̠ A̠d̠a̠ma̠ A̠kokod̠ia̠n ob̠a̠ra̠ A̠d̠a̠ma̠ Osira̠-epobh. Obhel bho̠ aro̠ ka̠ na̠ ate̠i̠ osira̠ epobh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Anwani̠ ya̠ i̠d̠u̠a d̠a̠ Agalili id̠igh na̠ A̠zizo̠s iru bho̠, i̠tu̠o̠no̠m A̠zose̠fu̠ ka̠ emisi d̠a̠ ogugua̠ bho̠, sa̠ i̠bi̠gh a̠d̠ien agu̠o̠ ubhin u̠mu̠ni̠e̠ni̠ ma̠ egua̠de bho̠ d̠a̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sa̠ awa imula̠ iyel i̠gi̠ ka̠ i̠gu̠a ma̠ i̠gagaman i̠gho̠gho̠ na̠ relo ed̠u e̠nu̠nu̠. Ya̠a̠, awa esira̠ ma̠ epobh A̠d̠a̠ma̠ Osira̠-epobh bho̠, ma̠ agu̠o̠ oloko bho̠ ato̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","I̠b̠ala A̠d̠a̠ma̠ Osira̠ Epobh bho̠, wa̠ aro̠ ma̠ o̠pu̠r a̠d̠a̠ma̠ d̠a̠ esi-a̠d̠a̠ma̠ bho̠, sa̠ anwani̠ bho̠ ib̠on ib̠etina̠ ma̠ obom ame̠ghe̠le̠, sa̠ ibhin i̠gho̠gho̠ ed̠ue̠nu̠nu̠ ya̠ awa i̠gbe̠ bho̠ iten i̠gi̠ d̠a̠ od̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Awa i̠bi̠gh ka̠ na̠ od̠ur okpegima̠ od̠i bho̠ otenemeni d̠a̠ a̠d̠ukun, ");
INSERT INTO mgj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ya̠a̠ igiel bho̠ awa id̠igh d̠a̠ ologi bho̠, awa i̠bi̠gh d̠o̠ ma̠ ozu ta̠ Wa̠nwuna̠ A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Igiel bho̠ awa od̠i ma̠ i̠se̠ na̠ e̠ru̠ru̠an na̠ egboloma̠ ma̠ abar bho̠, sa̠ i̠wal a̠nwunom imite ma̠ awai̠ i̠mara d̠a̠ aka d̠awa, na̠ ibura̠ ya̠ na̠ esosorogia̠n ka̠ i̠me̠me̠gi̠na e̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","D̠a̠ ebula̠ a̠rugugu wa̠ a̠sibh awa bho̠, sa̠ awa izuda̠ id̠i ma̠ ra̠misigh d̠awa d̠a̠ a̠de. Ya̠a̠ a̠nwunom bho̠ ipura̠n awa ma̠a̠, “A̠mite eka̠ ma̠ ola̠ inyin na̠ o̠bho̠ro̠gh o̠ni̠ ola̠ od̠i d̠a̠ a̠ghud̠um d̠a̠ esa̠d̠io imumugh? ");
INSERT INTO mgj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I̠na bo̠ ma̠ i̠se̠n; i̠na na̠ a̠b̠etina̠ d̠a̠ omugh! I̠ru̠ru̠ane̠ ma̠ i̠di̠ar ya̠ i̠na agba a̠nigha̠ inyin igiel bho̠ i̠na aro̠ na̠ inyin d̠a̠ Agalili bho̠, ");
INSERT INTO mgj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ma̠a̠, ‘Ta̠ ob̠eton O̠nyi̠ ta̠ O̠ni̠ o̠lo̠gh d̠a̠ aru̠gu̠o̠ id̠ighi ma̠ i̠karabh, sa̠ ta̠ o̠du̠ i̠na d̠a̠ e̠mi̠gi̠re̠ni̠an oriren ogigh. Oleghemeni i̠sar a̠d̠a̠ma̠ bho̠, sa̠ i̠na ta̠ a̠b̠etina̠ a̠mula̠ a̠ru d̠a̠ a̠ghud̠um.’ ” ");
INSERT INTO mgj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sa̠ awa i̠ru̠ru̠an iloghoma̠n o̠nu̠o̠kpe̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Igiel bho̠ awa i̠d̠u̠a d̠a̠ od̠i bho̠ imula̠ iyel bho̠, sa̠ awa i̠gba ma̠ eb̠la̠ i̠di̠ar i̠nye̠n inigha̠ ma̠ d̠iobh na̠ onin ogbo ogir bho̠ na̠ eb̠la̠ a̠nwunom iyed̠i. ");
INSERT INTO mgj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A̠meri wa̠ Amagdala bho̠, na̠ A̠zoana, na̠ A̠meri onweni ta̠ A̠zemsi, na̠ ipa̠n anwani̠ ya̠ id̠igh na̠ awa irile bho̠, i̠gba ma̠ abar wa̠ a̠mite bho̠ enigha̠ ma̠ ogbo ogir bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ya̠a̠, asu̠gbagba i̠nye̠n i̠gu̠b̠an ibhelebhel o̠nu̠ d̠a̠ ra̠to ilobhiri bho̠ ma̠ o̠mu̠ghon, ebula̠ o̠ku̠a awa id̠umom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ku̠ku̠m eka̠, A̠pita̠ a̠b̠etina̠ a̠kpo ma̠ eghil agi̠ d̠a̠ od̠i bho̠. I̠na a̠zuma̠n anwi̠nagi̠an d̠a̠ ologi od̠i bho̠, sa̠ i̠na abi̠gh i̠go̠ro̠go̠r a̠rukpe asi̠ni̠ni̠n ya̠ ubhin ubhurugi ma̠ egua̠de bho̠ d̠a̠ a̠de ma̠ obhobho i̠kpo̠. Sa̠ i̠na a̠kpon bo̠ a̠mula̠ a̠yel, a̠bhin obhel aru̠ru̠an a̠gboloma̠ ma̠ abar wa̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Onin a̠d̠a̠ma̠ obha̠, idi i̠wal ogbo atu̠ghan ta̠ A̠zizo̠s irile na̠ e̠gi̠ d̠a̠ e̠ma E̠mayo̠s, esi erile ola̠ a̠lei agu̠o̠ od̠ua̠l amai̠l ma̠ obhin d̠a̠ A̠zeruse̠le̠m ka̠ o̠te̠i̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sa̠ awa od̠i na̠ e̠b̠e̠re̠gi̠an na̠ egboloma̠ ma̠ eb̠la̠ i̠di̠ar ya̠ imite bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Igiel bho̠ awa na̠ e̠b̠e̠re̠gi̠an i̠di̠ar i̠nye̠n bho̠, sa̠ A̠zizo̠s na̠ agu̠o̠ a̠ru ra̠ a̠d̠igh na̠ awa agbo̠gbu̠an a̠rile. ");
INSERT INTO mgj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ya̠a̠, A̠zib̠a̠ a̠sibhom ma̠ ikpo a̠rid̠ien d̠awa ma̠ agu̠o̠ ola̠ awa ko orue d̠o̠ elelegi i̠na. ");
INSERT INTO mgj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin na̠ orile na̠ o̠b̠e̠re̠gi̠an o̠ku̠a na̠ ogboloma̠ ma̠ ere?” Sa̠ awa i̠mara kpom ikonya̠ na̠ i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sa̠ odi o̠ni̠ d̠a̠ i̠wal awa, wa̠ ubhelegi ma̠ A̠kilopas bho̠, awo̠ran i̠na ma̠a̠, “Anwa ku̠ku̠m o̠ni̠ ola̠ na̠ a̠ru ma̠ isuloma̠ d̠a̠ A̠zeruse̠le̠m, ola̠ ta̠ o̠mu̠gho̠n ani̠ d̠o̠ ma̠ i̠di̠ar ya̠ imite ma̠ ra̠d̠a̠ma̠ i̠nye̠n bho̠ d̠u̠ko̠?” ");
INSERT INTO mgj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “A̠kere a̠d̠ien i̠di̠ar imite?” Sa̠ awa i̠wo̠ran i̠na ma̠a̠, “I̠di̠ar ya̠ igboloma̠ ma̠ A̠zizo̠s wa̠ Anazare̠t bho̠. I̠na aro̠ ma̠ owil ola̠ A̠zib̠a̠ na̠ eb̠la̠ e̠mara̠nwunom ilelegi, d̠a̠ ebula̠ e̠mi̠ a̠limon o̠nu̠o̠kpe̠ d̠o̠yo̠ na̠ ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ogbo aru̠mu̠ rokur ta̠ A̠zib̠a̠ bho̠ na̠ ipa̠n ogbo aru̠mu̠ d̠i̠yar ya̠ od̠i d̠a̠ a̠dila̠de i̠to̠, ib̠eton i̠na e̠lo̠gh d̠a̠ agu̠o̠ a̠nwunom ma̠ ogigh, sa̠ i̠du̠ i̠na d̠a̠ e̠mi̠gi̠re̠ni̠an oriren igigh; ");
INSERT INTO mgj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ya̠a̠, i̠yar ubhin i̠na ob̠em ologi ma̠ i̠na Witenemeni wa̠ na̠ a̠ru ra̠ o̠bhe̠l ebhugh Izre̠l bho̠. O̠tu̠o̠no̠m i̠se̠, a̠didon oleghemeni i̠sar a̠d̠a̠ma̠ i̠di̠ar i̠nye̠n imite. ");
INSERT INTO mgj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","O̠ku̠a bha̠, idi anwani̠ d̠a̠ o̠lo̠gh d̠i̠yar ogbo ya̠ i̠tu̠o̠no̠m i̠na bho̠, iru ra̠ i̠gba ma̠ asu̠gbagba ya̠ id̠igh i̠yar ilologia̠n o̠mu̠gho̠n. Awa iten i̠gi̠ d̠a̠ od̠i d̠o̠yo̠ ma̠ ame̠ghe̠le̠ a̠didon, ");
INSERT INTO mgj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ya̠a̠ awa i̠bi̠gh d̠o̠ ma̠ ozu d̠o̠yo̠ d̠a̠ ologi. Sa̠ awa imula̠ iru ra̠ i̠gba inigha̠ i̠yar ma̠a̠, awa i̠bi̠gh aghi̠m ola̠ itileduom ta̠ A̠zib̠a̠ imutuma̠ awa e̠gba ma̠a̠, A̠zizo̠s od̠i d̠a̠ a̠ghud̠um! ");
INSERT INTO mgj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sa̠ idi ogbo ya̠ id̠igh na̠ i̠yar i̠ro̠ bho̠, iten i̠gi̠ d̠a̠ od̠i bho̠ ma̠ o̠bi̠gh ani̠. Ya̠gia̠ga̠i, awa i̠bi̠gh od̠i bho̠ ma̠ onin agu̠o̠ bho̠ anwani̠ bho̠ i̠gba bho̠, ya̠a̠ awa i̠bi̠gh d̠o̠ ma̠ A̠zizo̠s.” ");
INSERT INTO mgj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sa̠ i̠na a̠fugh a̠nigha̠ awa ma̠a̠, “Rema̠ a̠nwunom! Agu̠o̠ na̠ akparama inyin od̠umom eb̠la̠ iwowa̠ ya̠ a̠riwil bho̠ iwa̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","U̠gba d̠o̠ o̠se̠se̠ghe̠ni̠ ma̠a̠, Akrai̠st bho̠ ta̠ a̠d̠ia̠ abi̠gh ali̠gam a̠ruzu i̠nye̠n kisa̠ i̠na ta̠ a̠ten a̠d̠igh d̠a̠ a̠dila̠de isosorogia̠n d̠o̠yo̠ ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sa̠ A̠zizo̠s a̠bhin obhel agba ase̠se̠ghe̠ni̠ ma̠ eb̠la̠ iwowa̠ ya̠ u̠ge̠ ugboloma̠ i̠na d̠a̠ a̠d̠ire e̠tu̠tu̠ od̠ud̠ul bho̠, ob̠eton d̠a̠ ra̠d̠ire ta̠ A̠mozizi ka̠ ate̠i̠ i̠di̠ar ya̠ a̠riwil bho̠ i̠ge̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Igiel bho̠ awa na̠ etua̠n e̠ma wa̠ awa na̠ e̠gi̠ bho̠, sa̠ A̠zizo̠s a̠rile a̠ten awa a̠kue a̠d̠ighi woma̠ i̠na od̠idia̠ na̠ agi̠ d̠a̠ ed̠ia̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yaa̠, awa ikikiom i̠na e̠kparame̠ni̠ ma̠a̠, “To̠ na̠ i̠yar. I̠se̠n na̠ ate̠i̠ a̠dule, okpegi osor a̠sughonom.” Ebula̠ o̠ku̠a sa̠ i̠na agi̠ ka̠ a̠d̠igh na̠ awa aro̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Igiel bho̠ i̠na aro̠ d̠a̠ akpata od̠e bho̠, sa̠ i̠na a̠bhin abe̠re̠di̠, sa̠ a̠tutumeni, sa̠ i̠na a̠puiny a̠b̠eton a̠nigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","I̠se̠ kisa̠ a̠rid̠ien d̠awa i̠kpakpagi̠na sa̠ awa ililegi i̠na. D̠a̠ onin obhel bho̠, sa̠ i̠na amai̠ny ad̠u̠a d̠a̠ a̠misigh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sa̠ odi a̠tiba̠ra̠ a̠kpon odi a̠pura̠n ma̠a̠, “To̠ ti̠to̠i̠ny ku, i̠di̠ar ya̠ i̠na a̠bhin d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ agba a̠nigha̠ i̠yar igiel bho̠ i̠na a̠d̠igh na̠ i̠yar a̠rile bho̠, ikul d̠o̠ ma̠ rologi d̠i̠yar ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","D̠a̠ onin obhel bho̠ sa̠ awa imula̠ i̠gi̠ d̠a̠ A̠zeruse̠le̠m. Sa̠ awa i̠bi̠gh d̠iobh na̠ onin ogbo ogir bho̠, na̠ ipa̠n ogbo ya̠ na̠ ed̠igh gha̠n awa na̠ erile bho̠, na̠ ekokod̠ia̠n i̠se̠ ");
INSERT INTO mgj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na̠ e̠gba ma̠a̠, “Ya̠gia̠ga̠i! Wa̠nwuna̠ bho̠ na̠ a̠b̠etina̠ d̠a̠ omugh, sa̠ na̠ a̠mutuma̠ ma̠ Asai̠mo̠n nyen.” ");
INSERT INTO mgj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sa̠ i̠wal awa ya̠ i̠d̠u̠a d̠a̠ E̠mayo̠s imula̠ iru bho̠ eka̠, i̠gba ma̠ i̠di̠ar ya̠ imutuma̠ awa d̠a̠ eten bho̠, sekina̠ a̠d̠ien agu̠o̠ awa ibhin ilelegi i̠na, ma̠ obhel bho̠ i̠na a̠b̠eton abe̠re̠di̠ a̠puiny a̠ni̠gha awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Awa od̠id̠ia̠ na̠ e̠b̠e̠re̠gi̠an i̠nye̠n, sa̠ A̠zizo̠s na̠ agu̠o̠ a̠mite amara d̠a̠ esa̠d̠io d̠awa, sa̠ a̠du ma̠ o̠gho̠r a̠nigha̠ awa ma̠a̠, “Ekima̠ aro̠ na̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sa̠ eb̠la̠ o̠lo̠gh bho̠ ikpa̠ra̠numa̠, sa̠ a̠rugugu isibh awa, ezin bho̠ awa i̠ru̠ru̠an ma̠ awa i̠bi̠gh egua̠de. ");
INSERT INTO mgj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin na̠ o̠tu̠n ere na̠ okpa̠ra̠noma̠. Ezin ka̠ ere wa̠ rologi d̠inyin na̠ e̠gba i̠wal i̠wal bho̠? ");
INSERT INTO mgj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ikpone ma̠ aru̠gu̠o̠ d̠ami̠ na̠ a̠sike d̠ami̠, sa̠ inyin ta̠ ologhom ma̠ ami̠ na̠ agu̠o̠. Ikula̠ne ami̠ ma̠ ekpon; egua̠de na̠ onwuna̠ d̠o̠ ma̠ ipulupul ozu o̠nyi̠o̠mo̠ro̠ni̠ na̠ i̠kpo̠kpo̠, ma̠ a̠d̠ien agu̠o̠ inyin na̠ o̠bi̠gh ozu d̠ami̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Igiel bho̠ i̠na na̠ a̠mutiom okoroko onon bho̠, sa̠ i̠na a̠leriom awa ma̠ aru̠gu̠o̠ d̠o̠yo̠ na̠ a̠sike d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ku̠ku̠m eka̠, awa id̠umom d̠o̠, ya̠a̠ awa imuzo na̠ a̠libhon ologi na̠ ilologia̠n. Sa̠ i̠na a̠pura̠n awa ma̠a̠, “Inyin onwuna̠ abar od̠e ma̠ i̠se̠n ke̠re̠?” ");
INSERT INTO mgj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sa̠ awa ib̠eton o̠bhu̠gi̠an ena̠ i̠nigha̠ i̠na, ");
INSERT INTO mgj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","sa̠ i̠na a̠bhin ena̠ bho̠ a̠puron awa d̠a̠ a̠misigh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sa̠ i̠na agba a̠nigha̠ awa ma̠a̠, “I̠nye̠n i̠di̠ar ya̠ ami̠ i̠kpe̠re̠me̠ni̠ i̠tu̠ghu̠me̠ni̠ inyin igiel bho̠ ami̠ i̠ro̠ na̠ inyin bho̠ ma̠a̠, ta̠ omuzoghod̠iom eb̠la̠ i̠di̠ar ya̠ u̠ge̠ ugboloma̠ ami̠ d̠a̠ a̠d̠ire oloko ta̠ A̠mozizi bho̠, na̠ a̠riwil bho̠, na̠ d̠a̠ A̠d̠ire Raso̠r bho̠.” ");
INSERT INTO mgj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sa̠ i̠na a̠kpekpegion rologi d̠awa ma̠ o̠mu̠gho̠nyan o̠nu̠o̠kpe̠ A̠d̠ire E̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sa̠ i̠na a̠nimeta̠n awa ma̠a̠, “U̠ge̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ ta̠ A̠zib̠a̠ ma̠a̠, Akrai̠st ta̠ abi̠gh ali̠gam a̠ruzu, sa̠ ta̠ a̠mugh, sa̠ i̠na ta̠ a̠b̠etina̠ d̠a̠ omugh oleghemeni i̠sar a̠d̠a̠ma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","U̠b̠aram u̠ge̠ ma̠a̠, ta̠ o̠ke̠ d̠a̠ A̠zeruse̠le̠m obhin a̠d̠ien d̠o̠yo̠, o̠gba ma̠ ib̠eb̠i asu̠gbagba ya̠ otiba̠ra̠ d̠a̠ i̠karabh, na̠ o̠we̠le̠man i̠karabh onigha̠ o̠ni̠, o̠saragi̠ d̠a̠ eb̠la̠ e̠mara̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inyin ronyob̠a̠ i̠di̠ar i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ami̠ ta̠ afi̠ri̠ma inyin abar wa̠ O̠we̠de̠ d̠ami̠ a̠gua̠n bho̠; o̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠ro̠ ma̠ i̠se̠n d̠a̠ e̠ma bho̠ tu̠tu̠n a̠limon ta̠ ad̠u̠a d̠a̠ ote̠nai̠ny ra̠ ate̠i̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sa̠ i̠na a̠rileghom awa a̠mutiom ka̠ ate̠i̠ d̠a̠ Abe̠tani̠, sa̠ a̠b̠egion aru̠gu̠o̠ d̠o̠yo̠ agi̠o̠m anyu̠, sa̠ a̠tutumeni awa. ");
INSERT INTO mgj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Od̠id̠ia̠ d̠a̠ ologi agu̠o̠ i̠na na̠ a̠tutumeni awa bho̠, sa̠ i̠na a̠toka̠n ad̠u̠a d̠awa, sa̠ ukpobh i̠na ubhuneni d̠a̠ ote̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sa̠ awa ikpud̠ia̠n i̠ko̠l i̠na, sa̠ awa imula̠ i̠gi̠ d̠a̠ A̠zeruse̠le̠m na̠ ibom a̠libhon ologi. ");
INSERT INTO mgj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sa̠ awa ibhin eb̠la̠ obhel d̠awa, i̠ro̠ d̠a̠ Otu ta̠ A̠zib̠a̠ itututumeni ma̠ A̠zib̠a̠.");
INSERT INTO mgj_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Ami̠ Apo̠l, wa̠ ad̠u̠a d̠a̠ i̠to̠ ta̠ A̠zib̠a̠, sa̠ a̠ten o̠ni̠ogir ta̠ A̠zizo̠s Akrai̠st bho̠, na̠ age̠ na̠ a̠ruom a̠nwunom ta̠ A̠zib̠a̠ ya̠ od̠i d̠a̠ E̠fi̠so̠s, na̠ ogbo id̠umom ta̠ Akrai̠st A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","E̠no̠gho̠man na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ d̠i̠yar na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st e̠ro̠ na̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Itutumeni e̠ro̠ enigha̠ ma̠ A̠zib̠a̠ O̠we̠de̠ ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st, wa̠ na̠ a̠bhin eb̠la̠ itutumeni d̠a̠ e̠mu̠gh d̠a̠ ote̠nai̠ny a̠doni i̠yar d̠a̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Ezin bho̠ i̠na aso̠n i̠yar d̠a̠ Akrai̠st kisa̠ i̠na ale̠m e̠mara̠nwunom bho̠, ma̠ agu̠o̠ ola̠ i̠yar ta̠ o̠ro̠ ma̠ a̠nwunom e̠b̠ab̠ala, orugh a̠ma̠rugh ola̠ abar ola̠ o̠li̠o̠m i̠yar ko o̠ro̠ d̠o̠ d̠a̠ a̠misigh d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","D̠a̠ etula̠n d̠o̠yo̠, sa̠ i̠na ato̠ a̠guri ma̠ agu̠o̠ ola̠ ta̠ o̠wo̠l d̠a̠ A̠zizo̠s Akrai̠st obhin i̠yar ma̠ agu̠o̠ anwi̠i̠ny d̠o̠yo̠, d̠a̠ ebula̠ ib̠eb̠i i̠to̠ d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ma̠ agu̠o̠ ola̠ i̠yar ta̠ otutumeni i̠na d̠a̠ ibom e̠ne̠ghe̠ d̠o̠yo̠, wa̠ ibom e̠no̠gho̠man na̠ e̠wo̠l d̠a̠ Wetula̠n bho̠ na̠ e̠te̠i̠ i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","D̠a̠ ebula̠ Akrai̠st sa̠ i̠yar u̠te̠i̠ itenemeni wa̠ ad̠u̠a d̠a̠ alu̠kpe̠ omugh d̠o̠yo̠ a̠ru bho̠, sa̠ u̠we̠le̠man i̠karabh d̠i̠yar, d̠a̠ ebula̠ ibom e̠no̠gho̠man d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ya̠ i̠na a̠nigha̠ i̠yar a̠muzoghod̠i d̠a̠ a̠d̠ien kerekere eloghom abar na̠ amu̠gho̠nyan, ");
INSERT INTO mgj_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ma̠ i̠yar ologhom e̠wo̠gi̠na i̠to̠ d̠o̠yo̠, ya̠ isora̠n na̠ ib̠eb̠i i̠walama d̠o̠yo̠, wa̠ i̠na ato̠ d̠a̠ Akrai̠st bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ma̠ agu̠o̠ ola̠ ta̠ omuzoghod̠iom i̠walama d̠o̠yo̠ d̠a̠ ekunuguma̠ obhel bho̠, ma̠ otulugi eb̠la̠ i̠di̠ar d̠a̠ Akrai̠st, d̠a̠ ote̠nai̠ny na̠ d̠a̠ a̠de onon. ");
INSERT INTO mgj_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","D̠a̠ ebula̠ Akrai̠st nyen, sa̠ u̠so̠n i̠yar ma̠ id̠e ma̠ ad̠i̠a, ma̠ agu̠o̠ na̠ od̠ia̠ o̠to̠ oguri bho̠ d̠a̠ ebula̠ agu̠o̠ eb̠la̠ i̠di̠ar od̠i ma̠ agu̠o̠ a̠sora̠n d̠a̠ i̠to̠ d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ma̠ agu̠o̠ ola̠ i̠yar ya̠ u̠ro̠ ma̠ i̠pu̠r ogbo ya̠ na̠ eb̠em ologi d̠a̠ Akrai̠st bho̠ ta̠ o̠ro̠ ma̠ iya̠ itutumeni isosorogia̠n d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","D̠a̠ ebula̠ o̠yo̠ sa̠ inyin u̠mu̠gho̠n nyen a̠ga̠i O̠nu̠o̠kpe̠ oten d̠inyin, wa̠ inyin ud̠umom sa̠ u̠tu̠n o̠ku̠a unigha̠ inyin E̠mu̠gh E̠tu̠tu̠ bho̠ ma̠ o̠ro̠ elegh, ma̠ agu̠o̠ ugua̠n bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","wa̠ na̠ akparame̠ni̠ ma̠ ogua̠n bho̠ ma̠a̠, i̠yar ta̠ od̠e ma̠ ad̠i̠a d̠i̠yar bho̠, tu̠tu̠n i̠na ta̠ tenemeni ma̠ a̠nwunom d̠o̠yo̠ aman, ma̠ agu̠o̠ ola̠ onigha̠ o̠yo̠ ma̠ itutumeni d̠a̠ isosorogia̠n d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","D̠a̠ ebul abar onon, na̠ o̠gba nyen onigha̠ ami̠ ma̠ ologi ima̠ra̠ wa̠ inyin unwuna̠ ugboloma̠ ma̠ Wa̠nwuna̠ A̠zizo̠s, na̠ etula̠n wa̠ inyin unwuna̠ igboloma̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","O̠ku̠a sa̠ ami̠ ko o̠we̠le̠ d̠o̠ ma̠ o̠tu̠n ebula̠ inyin onigha̠ gha̠n ali̠se̠bh ma̠ igiel ami̠ i̠ru̠ru̠an igboloma̠ inyin d̠a̠ a̠siseiny d̠ami̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ma̠ agu̠o̠ ola̠ A̠zib̠a̠ ta̠ Wa̠nwuna̠ d̠i̠yar A̠zizo̠s Akrai̠st, O̠we̠de̠ isosorogia̠n bho̠, ta̠ a̠nigha̠ inyin E̠mu̠gh eloghom abar na̠ aghi̠m ya̠ o̠mar ologhom o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","na̠ okperon ologi d̠inyin ma̠ agu̠o̠ ola̠ inyin ta̠ o̠mu̠gho̠nyan abar wa̠ i̠na atu̠n a̠bhelegi inyin bho̠, na̠ a̠b̠utu e̠li̠la ya̠ i̠na na̠ a̠gua̠n anwi̠i̠ny d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","sekina̠ ibom a̠limon d̠o̠yo̠ wa̠ abar ola̠ obhin o̠tu̠o̠m o̠ro̠ d̠o̠ bho̠, ya̠ i̠ro̠ inigha̠ ma̠ ogbo ya̠ id̠umom bho̠, d̠a̠ agu̠o̠ od̠i d̠a̠ e̠mi̠ a̠limon ogir agu̠o̠ d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","wa̠ i̠na a̠gir d̠a̠ ob̠eton Akrai̠st d̠a̠ omugh bho̠, sa̠ ari̠lo̠me̠ni̠ i̠na ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ d̠o̠yo̠ d̠a̠ ote̠nai̠ny, ");
INSERT INTO mgj_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","a̠peleni ma̠ eb̠la̠ ra̠ a̠dila̠de na̠ a̠limon na̠ i̠to̠, sekina̠ kerekere a̠d̠ien ola̠ uloghom, i̠se̠n d̠a̠ amu̠m onon sekina̠ wa̠ na̠ a̠ru bho̠, nyen. ");
INSERT INTO mgj_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","A̠zib̠a̠ na̠ a̠bhin kabar kabar a̠guri d̠a̠ ekpukpu ta̠ Akrai̠st, sa̠ ato̠ ma̠a̠ i̠na we̠mu̠ eb̠la̠ i̠d̠i̠ar d̠a̠ ebula̠ aso̠si̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","wa̠ aro̠ ma̠ ozu d̠o̠yo̠ bho̠, wa̠ a̠muzo na̠ i̠na bho̠, wa̠ a̠muzo ma̠ eb̠la̠ i̠d̠i̠ar bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","D̠a̠ obhel ola̠ na̠ a̠ten, inyin u̠ro̠ ma̠ imumugh d̠a̠ e̠mu̠gh d̠a̠ ebula̠ ab̠agh e̠mu̠ na̠ i̠karabh d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","D̠a̠ obhel obha̠, inyin u̠tu̠o̠no̠m i̠karabh od̠ighi i̠di̠ar e̠mara̠nwunom onon, ya̠ izuzua̠n a̠limon ta̠ Eru bho̠, wa̠ na̠ a̠rileghom ra̠limon d̠a̠ e̠nai̠ny bho̠. I̠na e̠mu̠gh wa̠ od̠i ma̠ i̠se̠n bho̠, sa̠ na̠ a̠rileghom ogbo ya̠ na̠ e̠b̠agh e̠mu̠ na̠ enigha̠ ma̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","I̠ye̠ a̠ma̠rugh ya̠ eb̠la̠ i̠yar na̠ od̠ia̠ orugh otenemeni nyen, ya̠ i̠ro̠ ma̠ i̠karabh ebhiroma̠ ipulupul ozu, sa̠ i̠yar u̠tu̠o̠no̠m gha̠n ebhiroma̠ ipulupul ozu na̠ iya̠ rologi d̠i̠yar ipuru bho̠. Sa̠ d̠a̠ e̠d̠o̠lo̠gho̠ma d̠a̠ i̠yar bho̠, sa̠ i̠yar u̠ro̠ ma̠ anwi̠i̠ny ya̠ i̠kpe̠ ma̠ ogbika̠ d̠a̠ i̠gam ta̠ A̠zib̠a̠ ma̠ agu̠o̠ ipa̠n ogbo. ");
INSERT INTO mgj_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Ya̠a̠, A̠zib̠a̠ wa̠ a̠muzo na̠ okpon igbirigbir bho̠, d̠a̠ ebula̠ ibom etula̠n ya̠ i̠na a̠tula̠n i̠yar bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","d̠a̠ igiel bho̠ i̠yar u̠ro̠ ma̠ imumugh d̠a̠ e̠mu̠gh d̠a̠ ebula̠ ab̠agh e̠mu̠ bho̠, sa̠ i̠na a̠nigha̠ i̠yar a̠ghud̠um d̠a̠ Akrai̠st. Ad̠u̠a d̠a̠ e̠ne̠ghe̠ d̠o̠yo̠ kisa̠ i̠yar uten. ");
INSERT INTO mgj_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Sa̠ A̠zib̠a̠ a̠b̠eton i̠yar na̠ Akrai̠st ari̠lo̠me̠ni̠ ma̠ a̠dila̠de d̠a̠ a̠risisi ote̠nai̠ny na̠ Akrai̠st A̠zizo̠s, d̠a̠ ebula̠ od̠ighonin na̠ Akrai̠st, ");
INSERT INTO mgj_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠leriom amu̠m wa̠ na̠ a̠ru bho̠ ma̠ ibom e̠ne̠ghe̠ d̠o̠yo̠ ya̠ agu̠o̠ o̠gba o̠ro̠d̠o̠ bho̠ na̠ ib̠eb̠i ogir d̠o̠yo̠ ya̠ i̠te̠i̠ i̠yar ogbo ya̠ od̠i na̠ Akrai̠st A̠zizo̠s bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ad̠u̠a d̠a̠ e̠ne̠ghe̠ d̠o̠yo̠ sa̠ inyin u̠wo̠l d̠a̠ ologi ima̠ra̠ uten, inyin na̠ agu̠o̠ d̠o̠, onon bha̠ enigha̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Na̠ o̠d̠u̠a d̠o̠ d̠a̠ o̠gir agu̠o̠ a̠ru ma̠ ola̠ o̠nyi̠o̠mo̠ro̠ni̠ ta̠ a̠bhin are̠ma. ");
INSERT INTO mgj_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ezin bho̠, i̠yar ogir agu̠o̠ d̠o̠yo̠, ya̠ u̠le̠m d̠a̠ Akrai̠st A̠zizo̠s ma̠ ogir ib̠eb̠i rogir ya̠ i̠na na̠ ato̠ a̠guri, ma̠ i̠yar okpon o̠ku̠a ogir. ");
INSERT INTO mgj_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠ru̠ru̠ane̠ ma̠ agu̠o̠ inyin ogbo ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu d̠a̠ imitia̠n, sa̠ ogbo A̠zu ya̠ i̠gba ma̠a̠ awa na̠ otia̠ ma̠ ipo bho̠, ibhelegi inyin ma̠ ogbo ya̠ otia̠ d̠o̠ ma̠ ipo, wa̠ aro̠ ma̠ ogir agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ d̠a̠ ipulupul bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Ya̠a̠, d̠a̠ obhel bho̠, inyin usia̠n d̠o̠ ma̠ Akrai̠st, inyin u̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun Izre̠l, u̠wal ani̠ d̠o̠ inyin o̠lo̠gh d̠a̠ ri̠zo̠ na̠ rogua̠n ta̠ A̠zib̠a̠, eb̠em ologi na̠ o̠ro̠ d̠o̠ inyin, inyin u̠ro̠ ma̠ a̠nwunom e̠mara̠nwunom ya̠ onwuna̠ d̠o̠ ma̠ abar egboloma̠ ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Ya̠a̠ i̠se̠n, d̠a̠ Akrai̠st A̠zizo̠s, inyin ogbo ya̠ i̠ro̠ ma̠ esi egbeiny bho̠, na̠ obhin otueneni, d̠a̠ o̠wo̠l oten i̠ko̠l omugh ta̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Ezin bho̠ i̠na na̠ agu̠o̠ bha̠ ekima̠ d̠i̠yar, wa̠ a̠bhin i̠yar a̠guri onin bho̠, sa̠ a̠bhin omugh d̠o̠yo̠ a̠b̠ogion e̠b̠agh wa̠ abagi̠o̠n i̠yar a̠guri ma̠ ogbo ologi̠an a̠d̠ien bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","I̠na a̠gbogion oloko i̠to̠to̠gi̠ a̠ma̠rugh bho̠, ma̠ agu̠o̠ ola̠ onwe o̠le̠m i̠wal rebhugh bho̠ otenemeni onin a̠nwunom iya̠ o̠yo̠, ya̠ ibhon ipu ma̠ agu̠o̠ awa i̠ro̠ bho̠, omutiom ekima̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","D̠a̠ egbika̠ e̠mi̠gi̠re̠ni̠an oriren bho̠, sa̠ Akrai̠st a̠tulugi ma̠ i̠wal a̠nwunom bho̠ a̠tenemeni ma̠ onin d̠a̠ A̠zib̠a̠, sa̠ a̠kunugiom o̠lo̠gi̠an a̠d̠ien wa̠ aro̠ d̠a̠ esa̠d̠io d̠i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Sa̠ Akrai̠st a̠ru ra̠ agba ma̠ ib̠eb̠i asu̠gbagba ekima̠ bho̠ a̠nigha̠ inyin ogbo ya̠ o̠ro̠d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu bho̠, ya̠ isigima̠ ma̠ A̠zib̠a̠ bho̠ na̠ i̠yar a̠nwunom A̠zu, ya̠ itua̠n A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","I̠se̠n bha̠ i̠wal rekun bho̠ ta̠ e̠wo̠l d̠o̠yo̠, ebhin d̠a̠ onin E̠mu̠gh bho̠ e̠te̠i̠ O̠we̠d̠e̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Ebula̠ o̠ku̠a, inyin bo̠ mu̠ ma̠ isuloma̠ ya̠ onwuna̠ d̠o̠ ma̠ a̠dila̠de anwi̠i̠ny a̠rughun, ya̠a̠ inyin na̠ oten anwi̠i̠ny a̠rughun ya̠ i̠ro̠ ma̠ onin na̠ a̠nwunom ta̠ A̠zib̠a̠, d̠a̠ eghun otu ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ya̠ ulo d̠a̠ anyu̠ o̠de̠ ogbo ogir bho̠ sekina̠ a̠riwil bho̠, wa̠ Akrai̠st A̠zizo̠s na̠ agu̠o̠ aro̠ ma̠ we̠mu̠ o̠gbi̠o̠ma e̠ko̠ otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","D̠a̠ o̠yo̠ sa̠ eb̠la̠ otu bho̠ a̠tulugia̠n a̠ten onin, sa̠ abu̠gh a̠ten otupp ta̠ A̠zib̠a̠, sa̠ aro̠ ma̠ ola̠ e̠tu̠tu̠ d̠a̠ Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","D̠a̠ ebula̠ o̠yo̠, sa̠ ulo inyin utulugi nyen, utenemeni ma̠ otu ola̠ A̠zib̠a̠ ta̠ a̠rugh d̠a̠ E̠mu̠gh. ");
INSERT INTO mgj_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Onon abar wa̠ ami̠ Apo̠l, o̠ni̠ ikoli ta̠ Akrai̠st A̠zizo̠s, d̠a̠ ebula̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu bho̠, na̠ atu̠n na̠ a̠siseiny na̠ a̠nigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Ami̠ na̠ a̠ma̠ra̠ ma̠a̠ na̠ o̠gba onigha̠ inyin i̠to̠to̠gi̠ ya̠ A̠zib̠a̠ na̠ aghu̠ame̠ni̠ ami̠ ma̠ ogir ogboloma̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Uleriom ami̠ ma̠ i̠di̠ar e̠wo̠gina ya̠ ami̠ na̠ a̠d̠ia̠ age̠ ma̠ i̠ki̠kara a̠gboloma̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ma̠ agu̠o̠ ola̠ inyin ta̠ orue osen o̠mu̠gho̠nyan i̠di̠ar ya̠ ami̠ iloghom igboloma̠ ma̠ i̠di̠ar e̠wo̠gi̠na ta̠ Akrai̠st, ");
INSERT INTO mgj_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ya̠ uleriom d̠o̠ ma̠ ipa̠n ramu̠m, ya̠a̠ i̠se̠n na̠ awo̠l d̠a̠ E̠mu̠gh bho̠ a̠mutiom a̠leriom ogbo ogir na̠ a̠riwil d̠o̠yo̠ ya̠ inigha̠ ma̠ a̠ghud̠um d̠awa ma̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","E̠wo̠gi̠na bho̠ bha̠, ta̠ awo̠l d̠a̠ Ib̠eb̠i Asu̠gbagba bho̠, sa̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ iya̠ A̠zu ta̠ ed̠igh na̠ Ogbo A̠zu bho̠ e̠ro̠ ma̠ id̠e ma̠ ad̠i̠a, sa̠ awa ta̠ ed̠igh onin e̠ru̠gi̠an ogua̠n ta̠ A̠zib̠a̠ d̠a̠ Akrai̠st A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Ami̠ iru ra̠ iten o̠ni̠ ola̠ na̠ agba ma̠ Ib̠eb̠i Asu̠gbagba bho̠, d̠a̠ ebula̠ e̠ne̠ghe̠ wa̠ A̠zib̠a̠ a̠nigha̠ ami̠ bho̠, wa̠ ad̠u̠a d̠a̠ a̠limon ogir d̠o̠yo̠ a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Ami̠ i̠ki̠r a̠pu d̠a̠ eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠ ya̠ unigha̠ ma̠ a̠limon obhin o̠gba Ib̠eb̠i Asu̠gbagba onigha̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu bho̠, d̠a̠ e̠no̠gho̠man ya̠ imuzo d̠a̠ Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Sa̠ a̠d̠ighi ma̠ ola̠ eb̠la̠ a̠nwunom ta̠ e̠mar eloghom kabar kabar, d̠a̠ i̠to̠to̠gi̠ ilologia̠n na̠ i̠d̠i̠ar e̠wo̠gi̠na̠ id̠ud̠ul ta̠ A̠zib̠a̠ wa̠ ale̠m eb̠la̠ i̠d̠i̠ar bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ma̠ agu̠o̠ ola̠ i̠se̠n, ta̠ awo̠l d̠a̠ aso̠si̠ bho̠ a̠leriom ogbo irileghom na̠ a̠limon ya̠ od̠i d̠a̠ e̠nai̠ny bho̠, ma̠ a̠d̠izo re̠kal eloghom abar ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","I̠na atu̠n ebula̠ i̠walama id̠ud̠ul d̠o̠yo̠ ya̠ igboloma̠ ma̠ ramu̠m bho̠ a̠muzughod̠iom d̠a̠ Akrai̠st A̠zizo̠s Wa̠nwuna̠ d̠i̠yar, ");
INSERT INTO mgj_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","wa̠ i̠yar ubhin d̠a̠ ologi ima̠ra̠ u̠te̠i̠ alu̠kpo̠ ologi ola̠ o̠gi̠ ka̠ omutuma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ologi d̠inyin odugh d̠o̠ d̠a̠ ebula̠ ali̠gam a̠ruzu ya̠ ami̠ na̠ a̠din inyin na̠ abi̠gh bho̠, ya̠ i̠ro̠ ma̠ itum d̠inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Onon ezin bho̠ ami̠ na̠ a̠kpud̠ia̠n O̠we̠de̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","wa̠ u̠wo̠l ughol a̠d̠ien eb̠la̠ a̠nwunom d̠a̠ re̠nai̠ny na̠ a̠de bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ma̠a̠ i̠na a̠bhin d̠a̠ ibom a̠b̠utu e̠no̠gho̠man isosorogia̠n d̠o̠yo̠, awo̠l d̠a̠ E̠mu̠gh bho̠ a̠nigha̠ inyin a̠limon ya̠ ta̠ e̠ghu̠ame̠ni̠ ma̠ rologi d̠inyin, ");
INSERT INTO mgj_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ma̠ ola̠ ta̠ ad̠u̠a d̠a̠ ologi ima̠ra̠, sa̠ Akrai̠st ta̠ a̠rugh d̠a̠ rologi d̠inyin ma̠ ola̠ inyin ta̠ o̠zu̠ o̠mara, o̠ro̠ gigiribh d̠a̠ etula̠n d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","b̠o̠ka̠ inyin od̠igh na̠ eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠ o̠mar o̠mu̠gho̠nyan e̠re̠ghe̠, na̠ eweghe, na̠ e̠gi̠o̠m anyu̠, na̠ ekud̠um ");
INSERT INTO mgj_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","etula̠n ta̠ Akrai̠st wa̠ ob̠ur d̠o̠ ma̠ o̠mu̠gho̠nyan o̠man bho̠, ma̠ agu̠o̠ ola̠ inyin ta̠ omuzo na̠ ado̠l ta̠ A̠zib̠a̠ d̠a̠ eb̠la̠ re̠kal. ");
INSERT INTO mgj_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","I̠na wa̠ na̠ a̠rue na̠ a̠gir na̠ a̠peleni ma̠ agu̠o̠ i̠yar na̠ opuru bho̠ na̠ iya̠ i̠yar na̠ o̠ru̠ru̠an bho̠, ma̠ agu̠o̠ a̠limon d̠o̠yo̠ na̠ a̠gir d̠a̠ a̠ruzu d̠i̠yar bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","a̠bhin itutumeni d̠a̠ agu̠o̠ ogbo ya̠ ima̠ra̠ i̠na bho̠ sekina̠ Akrai̠st A̠zizo̠s, ad̠u̠a ma̠ amu̠m a̠ten amu̠m tu̠tu̠n ka̠ id̠ud̠ul. Aro̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ami̠ wa̠ od̠i d̠a̠ ikoli d̠a̠ ebula̠ Wa̠nwuna̠ bho̠, na̠ akpo̠me̠ni̠ ma̠ rologi d̠inyin ma̠ orugh a̠ma̠rugh ya̠ isora̠n agu̠o̠ ubhin ubhelegi inyin bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","d̠a̠ ibom o̠ki̠ri̠me̠ni̠ ozu, na̠ ekima̠, na̠ a̠ma̠ne ya̠ odi ta̠ a̠ne ma̠ odi d̠a̠ ebula̠ etula̠n. ");
INSERT INTO mgj_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Iwia̠ne ma̠ o̠ro̠ onin d̠a̠ E̠mu̠gh bho̠, ma̠ agu̠o̠ ola̠ ekima̠ ta̠ aro̠ ma̠ abar wa̠ akpu̠o̠m inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Onin ozu na̠ onin E̠mu̠gh od̠i, ma̠ agu̠o̠ ubhelegi inyin nyen ra̠ ud̠ighom d̠a̠ onin eb̠em ologi bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","onin Wa̠nwuna̠, onin ologi ima̠ra̠, onin owura̠mu̠m, ");
INSERT INTO mgj_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","onin A̠zib̠a̠ na̠ O̠we̠de̠ ta̠ eb̠la̠ i̠yar, wa̠ a̠pu kabar kabar bho̠, sa̠ na̠ awo̠l d̠a̠ eb̠la̠ a̠nwunom d̠o̠yo̠ na̠ a̠gir eb̠la̠ i̠di̠ar bho̠, sa̠ na̠ a̠rugh d̠a̠ eb̠la̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Ya̠a̠, Akrai̠st a̠nigha̠ ko̠ni̠ ko̠ni̠ i̠yar enigha̠ ya̠ o̠ni̠ o̠ni̠ ta̠ a̠rue a̠bhin a̠gir e̠kal ogir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Obha̠ ezin bho̠ u̠ge̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠, “Ogiel bho̠ i̠na a̠bhun d̠a̠ anyu̠ bho̠, sa̠ i̠na a̠bhin i̠di̠ar e̠ne̠ghe̠ d̠a̠ agu̠o̠ ogbo ikoli e̠gham bho̠ a̠nigha̠ ma̠ a̠nwunom d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","I̠se̠n ka̠ “I̠na a̠bhun,” ka̠ a̠ma̠ra̠ eka̠, a̠sigimeni ma̠ o̠ro̠ ma̠a̠, i̠na a̠sor d̠a̠ agba wa̠ ade̠bh a̠pu d̠a̠ a̠de bho̠? ");
INSERT INTO mgj_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","I̠na wa̠ a̠sor bho̠ bha̠ uwa̠ a̠bhun bho̠ a̠pel eb̠la̠ re̠nai̠ny bho̠ nyen, ma̠ omuzo eb̠la̠ e̠mara̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","I̠na bha̠ wa̠ aso̠n idi ma̠ ogbogir, idi a̠riwil, idi i̠gba ma̠ asu̠gbagba, idi ikponom ma̠ a̠nwunom ta̠ A̠zib̠a̠, na̠ i̠tu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ma̠ agu̠o̠ ola̠ o̠ghu̠ame̠ni̠ a̠nwunom ta̠ A̠zib̠a̠ d̠a̠ ogir olo ozu ta̠ Akrai̠st obhuneni bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","tu̠tu̠n ta̠ o̠te̠i̠ a̠dila̠de ola̠ eb̠la̠ i̠yar ta̠ oten onin d̠a̠ ologi ima̠ra̠ bho̠, o̠mar ologhom O̠nyi̠ ta̠ A̠zib̠a̠, na̠ o̠mar od̠igh e̠mu̠ olegha̠n ka̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Sa̠ i̠yar ko o̠ro̠ mu̠ ma̠ agu̠o̠ i̠gbara anwi̠i̠ny, iya̠ ipoka̠na̠n amu̠m na̠ eb̠oroghom, na̠ a̠bhin na̠ agi̠ ma̠ ebha̠ na̠ enen d̠a̠ a̠d̠ien kere kere oghur atu̠ghu̠me̠ni̠, na̠ i̠le̠ge̠ na̠ ikoiny ogbo ya̠ na̠ egon ogelemeni a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Kpe̠le̠me̠ni̠ bha̠ i̠yar obhin d̠a̠ etula̠n o̠gba ma̠ iya̠ a̠ga̠i bho̠, sa̠ i̠yar ta̠ obhobh d̠a̠ eb̠la̠ re̠kal o̠ro̠ ma̠ agu̠o̠ Akrai̠st we̠mu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Ad̠u̠a d̠o̠yo̠ sa̠ u̠tu̠lu̠gi̠ ma̠ eb̠la̠ a̠risisi ozu bho̠ na̠ id̠id̠igh uguri ma̠ onin, sa̠ esi i̠se̠ na̠ a̠gir agu̠o̠ u̠to̠ unigha̠ i̠na ma̠ ogir bho̠, b̠o̠ka̠ ozu bho̠ a̠bhobh, aghu̠a, a̠muzo na̠ etula̠n. ");
INSERT INTO mgj_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ami̠ na̠ a̠bhin d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ bho̠ na̠ akparame̠ni̠ na̠ agba na̠ a̠nigha̠ inyin ma̠a̠, ob̠eton i̠se̠n o̠gi̠ d̠a̠ ed̠ia̠, o̠ni̠ ko orugh mu ma̠ agu̠o̠ a̠nwunom ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu na̠ erugh bho̠, ya̠ na̠ ebhin agu̠o̠ awa eb̠em ologi o̠ro̠ d̠o̠ bho̠ na̠ e̠su̠su̠ghu̠d̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Awa irue d̠o̠ ma̠ o̠mu̠gho̠nyan abar, ma̠ ola̠ awa na̠ esigima̠ d̠a̠ a̠ghud̠um wa̠ A̠zib̠a̠ na̠ a̠nigha̠ ma̠ a̠nwunom bho̠. Ezin bho̠, awa iloghom d̠o̠ ma̠ a̠ga̠i abar, d̠a̠ ebula̠ o̠kparakpar ologi d̠awa. ");
INSERT INTO mgj_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Awa inwuna̠ mu ma̠ igbiriri ozu, ma̠ ola̠ awa na̠ eb̠eton a̠ruzu d̠awa enigha̠ ma̠ a̠d̠ien kere kere i̠karabh, na̠ a̠ma̠rugh o̠ku̠ku̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Ya̠a̠, i̠nye̠n i̠di̠ar ya̠ inyin u̠tu̠ghan ugboloma̠ ma̠ Akrai̠st bho̠ d̠o̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ku̠gba ma̠a̠, inyin o̠mar o̠mu̠gho̠n i̠di̠ar ya̠ igboloma̠ i̠na bho̠, sa̠ i̠na atu̠ghu̠me̠ni̠ inyin a̠gia̠ga̠i ya̠ od̠i na̠ A̠zizo̠s bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","bha̠ i̠si̠ghe̠ ma̠ ado̠l ugba̠iny o̠ni̠ wa̠ obhon d̠o̠ bho̠ ma̠ erobh, ya̠ i̠d̠u̠a d̠a̠ i̠karabh ebhiroma̠ igelemeni iru bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","E̠mu̠gh bho̠ a̠nwe ma̠ i̠ru̠ru̠an d̠inyin a̠tenemeni ma̠ imom, ");
INSERT INTO mgj_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ma̠ erugh a̠ma̠rugh emobh o̠ni̠ ola̠ ed̠ighiom i̠di̠ar bho̠ i̠gu̠b̠an ita̠ A̠zib̠a̠, d̠a̠ a̠ga̠i e̠b̠ab̠ala, na̠ igielake̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠we̠le̠mane̠ ma̠ o̠gba igunugha̠, ya̠a̠ odi agba ma̠ iya̠gia̠ga̠i a̠nigha̠ ma̠ odi, ezin bho̠ eb̠la̠ i̠yar onin d̠a̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Inyin ta̠ orue o̠gam i̠gam, ya̠a̠ i̠gam bho̠ od̠ighi d̠o̠ ma̠ ola̠ inyin ta̠ ogir i̠karabh. I̠gam bho̠ o̠ro̠ d̠o̠ tu̠tu̠n ogogo bho̠ ta̠ a̠sor. ");
INSERT INTO mgj_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","O̠ni̠ ko onigha̠ ma̠ Eru bho̠ ma̠ e̠ti̠ti̠gha. ");
INSERT INTO mgj_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","O̠ni̠ ola̠ na̠ a̠rugh ado̠l a̠b̠igh ob̠igh mu, ya̠a̠ a̠bhin aru̠gu̠o̠ d̠o̠yo̠ akparame̠ni̠ a̠gir ogir ola̠ asu̠o̠, b̠o̠ka̠ i̠na ate̠i̠ abar ola̠ onigha̠ ani̠ o̠ni̠ ola̠ a̠dila̠de bho̠ na̠ a̠puru ma̠ o̠lo̠gh agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","I̠karabh a̠fugh omite d̠o̠ d̠a̠ aru̠nu̠ d̠inyin. Kpe̠le̠me̠ni̠ bha̠ aro̠ ma̠ ob̠eb̠i abar ola̠ ta̠ akpo̠me̠ni̠ ma̠ rologi ogbo ya̠ i̠mu̠gho̠n bho̠, sa̠ ta̠ ed̠igh asu̠o̠ enigha̠ awa. ");
INSERT INTO mgj_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","O̠ni̠ ko od̠ighi ma̠ ola̠ E̠mu̠gh E̠tu̠tu̠ ta̠ A̠zib̠a̠ ta̠ a̠d̠igh i̠ku̠nu̠, i̠na wa̠ aro̠ ma̠ elegh wa̠ A̠zib̠a̠ na̠ a̠bhin na̠ a̠lelegi ma̠a̠ inyin iya̠ o̠yo̠ bho̠, na̠ oleriom ma̠a̠ inyin ta̠ oten d̠a̠ a̠d̠a̠ma̠ itenemeni bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","I̠si̠ghe̠ ma̠ eb̠la̠ igurumia̠n ologi, na̠ ibom i̠gam, na̠ i̠karabh ebhiroma̠, izul o̠te̠i̠ abar onyen, na̠ a̠fugh i̠basi̠, na̠ ado̠l o̠lo̠gi̠an a̠d̠ien, sekina̠ eghir ologi d̠a̠ a̠ghud̠um d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Kpe̠le̠me̠ni̠ bha̠ odi alo̠gh agu̠o̠ a̠nigha̠ ma̠ odi, odi a̠kpon odi ma̠ igbirigbir, odi a̠kpon i̠karabh ta̠ odi asi̠ghe̠ ma̠ a̠d̠ien, ma̠ agu̠o̠ A̠zib̠a̠ atu̠n ebula̠ Akrai̠st a̠kpon i̠karabh d̠inyin asi̠ghe̠ ma̠ a̠d̠ien bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠ta ma̠ ed̠ighiom i̠di̠ar ta̠ A̠zib̠a̠ ma̠ agu̠o̠ inyin u̠ro̠ ma̠ anwi̠i̠ny ed̠ighologi d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Irughe ma̠ a̠ma̠rugh etula̠n agu̠o̠ Akrai̠st a̠tula̠n i̠yar bho̠, sa̠ a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ o̠ro̠ abar alu̠kpe̠, ola̠ u̠kpe̠ unigha̠ ma̠ A̠zib̠a̠ sa̠ a̠bhur ed̠u e̠nu̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Agu̠o̠ inyin u̠ro̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ bho̠, o̠ro̠ d̠o̠ ma̠ ola̠ ta̠ o̠gba ma̠a̠, odi o̠ni̠ inyin na̠ a̠d̠e ma̠ e̠ma, bo̠d̠o̠ na̠ a̠pesi ma̠ a̠d̠ien kere kere ipesi, bo̠d̠o̠ na̠ a̠kori ma̠ i̠di̠ar na̠ a̠bhin. A̠ghud̠um i̠nye̠n ibhon d̠o̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ ma̠ orugh. ");
INSERT INTO mgj_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Bo̠d̠o̠ osenegi isenegi, ofugh a̠fugh iya̠ i̠te̠i̠, bo̠d̠o̠ okue ikue ya̠ osora̠n d̠o̠. Ado̠l i̠nye̠n ibhon d̠o̠, kpe̠le̠me̠ni̠ bha̠ i̠se̠bhe̠ ma̠ ali̠se̠bh. ");
INSERT INTO mgj_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Iloghome ma̠a̠, od̠e ma̠ e̠ma, bo̠d̠o̠ opesipesi, bo̠d̠o̠ okorikori (wa̠ aro̠ ma̠ o̠ko̠l ma̠ eru bho̠), ko od̠igh d̠o̠ d̠a̠ a̠de onwuna̠ e̠ma ta̠ Akrai̠st na̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","O̠ni̠ ko oma̠ra̠ ma̠ o̠ni̠ ma̠ obhin ibhelebhel o̠nu̠ oru ra̠ ogelemeni inyin. Ezin bho̠, A̠zib̠a̠ ta̠ a̠din o̠kpo̠ ya̠ o̠ko̠no̠n agam ibom i̠gam a̠gboloma̠ ma̠ ogbo ya̠ na̠ e̠b̠agh e̠mu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","O̠ni̠ ko od̠igh awa ma̠ egir a̠d̠ien i̠d̠i̠ar ya̠ awa na̠ egir bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Ezin bho̠, obhel aro̠ ma̠ ola̠ inyin u̠ro̠ d̠a̠ azi̠m, ya̠a̠ i̠se̠n inyin na̠ oten a̠nwunom ta̠ Wa̠nwuna̠ ya̠ od̠i d̠a̠ e̠b̠alab̠al bho̠, bha̠, irughe ma̠ a̠ma̠rugh ya̠ i̠gu̠b̠an ogbo ya̠ od̠i d̠a̠ e̠b̠alab̠al. ");
INSERT INTO mgj_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Ezin bho̠, e̠b̠alab̠al onon wa̠ od̠i na̠ inyin bho̠, na̠ amu̠ na̠ a̠mutiom ib̠eb̠i, na̠ igielake̠, na̠ a̠gia̠ga̠i, ");
INSERT INTO mgj_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ma̠ agu̠o̠ inyin na̠ owia̠n ogir ya̠ i̠kpe̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","O̠ni̠ ko od̠igh ani̠ ma̠ egir i̠d̠i̠ar obhobho i̠kpo̠ i̠ye̠ ya̠ igboloma̠ ma̠ azi̠m bho̠, kpe̠le̠me̠ni̠ bha̠ i̠gba ma̠ emutiom agu̠o̠ igurom i̠te̠i̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","O̠kpo̠ i̠ye̠ ya̠ awa na̠ egir d̠a̠ e̠wo̠gi̠na bho̠, iya̠ ari̠ghe̠l nyen ma̠ ofugh ogboloma̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Ya̠a̠, ka̠ umutiom eb̠la̠ o̠kpo̠ i̠ye̠ d̠a̠ e̠b̠alab̠al, sa̠ ta̠ ologhom agu̠o̠ obhin od̠i. ");
INSERT INTO mgj_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Ezin bho̠ e̠b̠alab̠al na̠ a̠leriom kabar kabar, agu̠o̠ A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠a̠, “B̠etina̠ d̠a̠ adi̠la d̠oyom, b̠etina̠ d̠a̠ omugh, sa̠ Akrai̠st ta̠ a̠nigha̠ nyam amu̠gho̠nyan.” ");
INSERT INTO mgj_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","O̠ku̠a a̠d̠ighi be̠le̠ni̠ ikpona̠, o̠ni̠ ko orugh agu̠o̠ rema̠ a̠nwunom, ya̠ i̠ro̠ ma̠ agu̠o̠ iloghodi̠ar a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","I̠mare̠ ma̠ egir i̠di̠ar ya̠ i̠kpe̠ inyin ogir d̠a̠ obhel bho̠, ezin bho̠ ra̠d̠a̠ma̠ i̠nye̠n i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Ebula̠ o̠ku̠a, o̠ni̠ ko o̠ro̠ ma̠ rema̠, ya̠a̠ iwia̠ne ma̠ o̠mu̠gho̠nyan i̠to̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","O̠ni̠ ko o̠d̠a ma̠ a̠min e̠te̠i̠ esi ola̠ ta̠ epuru inyin, b̠o̠ka̠ i̠ye̠me̠ni̠ inyin. Kpe̠le̠me̠ni̠ bha̠ E̠mu̠gh bho̠ a̠muzo d̠a̠ a̠ruzu d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Ibhine ma̠ raso̠r ya̠ od̠i d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠, na̠ raso̠r ya̠ a̠nwunom ima̠ra̠, na̠ raso̠r ya̠ E̠mu̠gh E̠tu̠tu̠ bho̠ ta̠ a̠nigha̠ inyin, ma̠ e̠mo̠r d̠a̠ esa̠d̠io d̠inyin, ma̠ etutumeni ma̠ A̠zib̠a̠ d̠a̠ rologi d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","I̠se̠bhe̠ ma̠ A̠zib̠a̠ O̠we̠de̠ bho̠ kigiel kigiel ma̠ egboloma̠ ma̠ eb̠la̠ i̠di̠ar, d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Odi a̠zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ odi d̠a̠ ebula̠ oghila̠n Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Inyin anwani̠, izuruna̠ ma̠ eghoi ma̠ enigha̠ ma̠ a̠siwolom d̠inyin, ma̠ a̠d̠ien agu̠o̠ inyin na̠ ogir na̠ onigha̠ ma̠ Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Ezin bho̠, owolom we̠mu̠ ani̠ d̠o̠yo̠, ma̠ onin agu̠o̠ Akrai̠st aro̠ ma̠ we̠mu̠ na̠ Witenemeni aso̠si̠ bho̠, wa̠ aro̠ ma̠ ozu d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠d̠ien agu̠o̠ aso̠si̠ bho̠ na̠ a̠zuruna̠ ma̠ eghoi na̠ a̠nigha̠ ma̠ Akrai̠st bho̠, anwani̠ eka̠ ezuruna̠ ma̠ eghoi enigha̠ ma̠ a̠siwolom d̠awa d̠a̠ eb̠la̠ i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Inyin a̠siwolom, itula̠ne ma̠ anwani̠ d̠inyin, ma̠ onin agu̠o̠ Akrai̠st a̠tula̠n aso̠si̠ bho̠, sa̠ a̠nigha̠ ma̠ a̠ghud̠um d̠o̠yo̠ a̠dinom. ");
INSERT INTO mgj_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","I̠na a̠gir o̠ku̠a b̠o̠ka̠ i̠na a̠bhin o̠nu̠o̠kpe̠ d̠o̠yo̠ a̠wur amu̠m ma̠ aso̠si̠ bho̠ a̠guri d̠a̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Akrai̠st a̠gir o̠ko̠no̠n b̠o̠ka̠ i̠na ate̠i̠ aso̠si̠ ola̠ edim, ola̠ onwuna̠ d̠o̠ bebina̠ abar ola̠ o̠li̠o̠m, bo̠d̠o̠ ipa̠n i̠di̠ar ya̠ na̠ e̠pi̠e̠ ma̠ a̠nwunom. Kpe̠le̠me̠ni̠ bha̠ aso̠si̠ bho̠ aro̠ d̠a̠ e̠b̠ab̠ala na̠ ola̠ ko o̠bi̠gh d̠o̠ o̠pi̠e̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Onin agu̠o̠ bho̠ a̠siwolom e̠kpe̠ ma̠ otula̠n anwani̠ d̠awa ma̠ agu̠o̠ awa itula̠n a̠ruzu d̠awa bho̠. I̠na o̠ni̠ wa̠ a̠tula̠n ani̠ d̠o̠yo̠ bho̠, bha̠ a̠tula̠n ozu d̠o̠yo̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Ezin bho̠, bebina̠ o̠ni̠ ola̠ asu̠a ma̠ ozu d̠o̠yo̠ bo̠. Kpe̠le̠me̠ni̠ bha̠ o̠ni̠ bho̠ na̠ amar na̠ a̠d̠e ma̠ ed̠ia̠n na̠ a̠kponom ozu d̠o̠yo̠, onin agu̠o̠ bho̠ Akrai̠st na̠ a̠gir na̠ a̠gboloma̠ ma̠ aso̠si̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ezin bho̠ i̠yar a̠risisi ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Onin agu̠o̠ A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠a̠, “Olobho̠ro̠ni̠ ta̠ awe̠le̠man onweni na̠ o̠we̠de̠ d̠o̠yo̠ ka̠ akpabhan ani̠ d̠o̠yo̠, sa̠ i̠wal awa ta̠ eten onin ozu.” ");
INSERT INTO mgj_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Onon obom e̠wo̠gi̠na, ya̠a̠ ami̠ na̠ agba na̠ a̠gboloma̠ ma̠ Akrai̠st na̠ aso̠si̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Ku̠ku̠m eka̠, id̠ighi ma̠ agu̠o̠ ola̠ ko̠ni̠ ko̠ni̠ inyin ta̠ a̠tula̠n ani̠ d̠o̠yo̠ ma̠ agu̠o̠ i̠na a̠tula̠n ozu d̠o̠yo̠ bho̠, ani̠ a̠zuruna̠ ma̠ eghoi a̠nigha̠ ma̠ owolom d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","I̠gbara anwi̠i̠ny i̠nagha ma̠ o̠nu̠o̠kpe̠ onweni na̠ o̠we̠de̠ d̠inyin ma̠ agu̠o̠ inyin u̠ro̠ ma̠ a̠ga̠i anwi̠i̠ny ta̠ Wa̠nwuna̠ bho̠, onon agu̠o̠ akpe̠ ma̠ o̠ro̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“Izuruna̠ ma̠ eghoi enigha̠ ma̠ onweni na̠ o̠we̠de̠ d̠inyin.” Obha̠ o̠pu̠r oloko wa̠ u̠b̠aram na̠ ogua̠n bho̠ ma̠a̠, ");
INSERT INTO mgj_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","“sa̠ ta̠ ebhon enigha̠ inyin, sa̠ inyin ta̠ od̠um iwewegh a̠ghud̠um d̠a̠ a̠de onon.” ");
INSERT INTO mgj_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Ro̠we̠de̠, o̠ni̠ ko orugh ado̠l ya̠ o̠gamame̠ni̠ rologi anwi̠i̠ny d̠inyin, kpe̠le̠me̠ni̠ bha̠ ibhine d̠a̠ a̠kikiom na̠ atu̠ghu̠me̠ni̠ ta̠ Wa̠nwuna̠ bho̠ ma̠ ekponom awa ma̠ ed̠ighom aru̠mu̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Aru̠bana, izuruna̠ ma̠ eghoi enigha̠ ma̠ ogbo ya̠ inwuna̠ inyin i̠se̠n a̠de onon bho̠, ma̠ e̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu na̠ eb̠la̠ rologi d̠inyin, ma̠ enigha̠ awa ma̠ agu̠o̠ inyin ta̠ oghila̠n Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","O̠ni̠ ko ogir agu̠o̠ ola̠ a̠nwunom ta̠ e̠bi̠gh inyin, ya̠a̠ igire kuma̠ agu̠o̠ aru̠bana ta̠ Akrai̠st ya̠ na̠ ebhin eb̠la̠ rologi d̠awa na̠ egir i̠to̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Ibhine ma̠ onyen ologi ma̠ egir rogir d̠inyin, sa̠ aro̠ ma̠ agu̠o̠ ola̠ inyin na̠ ogir na̠ onigha̠ ma̠ Wa̠nwuna̠ bho̠ ya̠a̠ a̠nwunom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Iloghome ma̠a̠ ko̠ni̠ ko̠ni̠ ta̠ ate̠i̠ asu̠o̠ ib̠eb̠i ogir d̠o̠yo̠ d̠a̠ agu̠o̠ ta̠ Wa̠nwuna̠ bho̠, a̠d̠igh e̠bana, a̠d̠igh o̠ni̠ ola̠ o̠ro̠ d̠o̠ ma̠ e̠bana. ");
INSERT INTO mgj_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Inyin ogbo ya̠ inwuna̠ ma̠ aru̠bana, igire ma̠ onin agu̠o̠ bho̠ ma̠ enigha̠ awa. O̠ni̠ ko o̠pa awa. Iloghome ma̠a̠, Wa̠nwuna̠ wa̠ od̠i d̠a̠ ote̠nai̠ny bho̠ a̠nwuna̠ inyin sekina̠ awa, sa̠ aro̠ ma̠ ola̠ i̠na o̠bhe̠l d̠o̠ ma̠ odi a̠kpon odi a̠gurumeni. ");
INSERT INTO mgj_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","D̠a̠ okunugiom bho̠, bha̠ i̠mara gigiribh d̠a̠ Wa̠nwuna̠ bho̠, na̠ d̠a̠ ibom e̠mi̠ a̠limon d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","I̠lo̠gi̠ane̠ ma̠ eb̠la̠ o̠kpo̠ erorobhi ta̠ A̠zib̠a̠, b̠o̠ka̠ inyin orue o̠damaghan i̠karabh akpati̠an ta̠ Eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Ezin bho̠, i̠yar uwia̠n d̠o̠ ma̠ asi̠ na̠ ipulupul, ya̠a̠ na̠ owia̠n ogbo irileghom, na̠ ogbo ya̠ od̠i d̠a̠ ra̠dila̠de i̠to̠, na̠ ogbo irileghom e̠mara̠nwunom azi̠m onon, na̠ a̠limon i̠karabh aru̠mu̠gh ya̠ od̠i d̠a̠ re̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ibhine ma̠ eb̠la̠ o̠kpo̠ erorobhi ta̠ A̠zib̠a̠ ma̠ e̠kpaki̠an, b̠o̠ka̠ inyin orue o̠marama ma̠ o̠karabh a̠d̠a̠ma̠ bho̠ ma̠ igiel ta̠ a̠ru. Sa̠ igiel inyin na̠ o̠ne̠gi̠me̠ni̠ kabar kabar, sa̠ inyin ta̠ o̠mara gigiribh. ");
INSERT INTO mgj_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Ebula̠ o̠ku̠a, i̠mara gigiribh ma̠ ebhin ya̠gia̠ga̠i ma̠ e̠kpo̠a ma̠ agu̠o̠ o̠kara d̠a̠ eka̠ka̠gh d̠inyin, ma̠ ebhin a̠ghud̠um igielake̠ ma̠ eguri ma̠ agu̠o̠ ekpeke d̠a̠ ekpa̠kpa̠gh d̠inyin, ");
INSERT INTO mgj_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ma̠ ebhin ebhiroma̠ o̠gba ib̠eb̠i asu̠gbagba ekima̠ bho̠ ma̠ e̠lo̠gi̠an agu̠o̠ agbaka. ");
INSERT INTO mgj_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Wa̠ a̠lei abar a̠pu bho̠, i̠lo̠gi̠ane̠ ma̠ ekpeke ologi ima̠ra̠, b̠o̠ka̠ inyin orue o̠damaghan eb̠la̠ i̠so̠bh ya̠ na̠ emumor anya bho̠, ya̠ o̠karabh o̠ni̠ bho̠ na̠ a̠robhod̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Ibhine ma̠ itenemeni e̠mu̠gh ma̠ ezuoma̠ ka̠ eghoi e̠gham, ma̠ esibh ogidi e̠gham ta̠ E̠mu̠gh E̠tu̠tu̠ bho̠, wa̠ aro̠ ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Isiseinye ma̠ a̠d̠ien kerekere a̠siseiny ma̠ eb̠la̠ igiel d̠a̠ E̠mu̠gh bho̠, ma̠ e̠mar ekpona̠ na̠ a̠ma̠ne, ma̠ esiseiny egboloma̠ ma̠ eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Isiseinye ma̠ enigha̠ ami̠ nyen, ma̠ agu̠o̠ ola̠ A̠zib̠a̠ ta̠ a̠nigha̠ ami̠ ma̠ o̠nu̠o̠kpe̠, b̠o̠ka̠ igiel ami̠ i̠kpato̠n o̠nu̠ d̠ami̠, ami̠ a̠bhin d̠a̠ alu̠kpo̠ ologi agba ma̠ e̠wo̠gi̠na ib̠eb̠i asu̠gbagba bho̠ a̠mutiom. ");
INSERT INTO mgj_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","U̠tu̠n ib̠eb̠i asu̠gbagba bho̠ o̠so̠n ami̠ ma̠ obhin a̠d̠ien ta̠ Akrai̠st o̠mara, sa̠ ami̠ od̠i ma̠ ikoli ma̠ ebula̠ o̠ku̠a. Isiseinye ma̠ enigha̠ ami̠ ma̠ agu̠o̠ ola̠ ami̠ ta̠ a̠bhin d̠a̠ alu̠kpo̠ ologi agba ma̠ ib̠eb̠i asu̠gbagba bho̠ ma̠ agu̠o̠ akpe̠ ami̠ ma̠ o̠gba bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Od̠ighi agu̠o̠ ola̠ inyin ta̠ eloghom agu̠o̠ ami̠ od̠i, na̠ i̠di̠ar ya̠ ami̠ na̠ a̠gir bho̠, sa̠ ami̠ iruom Atai̠siku̠s, umor ed̠ighologi d̠a̠ ami̠ d̠a̠ onin ima̠ra̠ ologi bho̠, na̠ o̠ni̠ogir igielake̠ ta̠ Wa̠nwuna̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ma̠ oru ra̠ o̠gba agu̠o̠ eb̠la̠ i̠di̠ar od̠i onigha̠ inyin, na̠ o̠kpo̠me̠ni̠ rologi d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st, sekina̠ etula̠n na̠ ologi ima̠ra̠, e̠ro̠ na̠ inyin a̠rumor na̠ aru̠marani̠ d̠a̠ ami̠ ya̠ onin ima̠ra̠ ologi bho̠. ");
INSERT INTO mgj_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","E̠ne̠ghe̠ ta̠ A̠zib̠a̠ aro̠ na̠ eb̠la̠ inyin ogbo ya̠ na̠ etula̠n Wa̠nwuna̠ d̠i̠yar A̠zizo̠s Akrai̠st na̠ etula̠n wa̠ ekunuguma̠ o̠to̠ bho̠.");
INSERT INTO mgj_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Ami̠ Apo̠l na̠ Asai̠las na̠ A̠timoti, na̠ o̠ge̠ na̠ oruom inyin ogbo ya̠ na̠ e̠gi̠ ma̠ aso̠si̠ d̠a̠ Ate̠saloni̠ka bho̠, ya̠ i̠ro̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st ma̠a̠: “E̠no̠gho̠man na̠ ekima̠ e̠ro̠ na̠ inyin.” ");
INSERT INTO mgj_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","I̠yar na̠ o̠se̠bh A̠zib̠a̠ na̠ ogboloma̠ inyin kigiel kigiel, sa̠ i̠yar na̠ osenegi inyin d̠a̠ ra̠siseiny d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","I̠yar na̠ o̠ru̠ru̠an na̠ ogboloma̠ inyin d̠a̠ a̠siseiny, ma̠ agu̠o̠ inyin na̠ obhin ologi ima̠ra̠ na̠ ogir ogir bho̠, na̠ agu̠o̠ etula̠n d̠inyin na̠ a̠nu inyin ogir ogir bho̠, na̠ agu̠o̠ inyin na̠ o̠kparame̠ni̠ ma̠ eb̠em ologi d̠inyin d̠a̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","A̠rumor na̠ aru̠marani̠ ed̠ighologi d̠i̠yar ya̠ ima̠ra̠ ma̠ A̠zib̠a̠ bho̠, i̠yar ologhom ma̠a̠ A̠zib̠a̠ a̠tula̠n inyin, sa̠ aso̠n inyin o̠ro̠ a̠nwunom d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Ezin bho̠, i̠yar ubhin d̠o̠ ma̠ Ib̠eb̠i Asu̠gbagba bho̠ d̠a̠ o̠nu̠ ku̠ku̠m oruom inyin, ya̠a̠ u̠b̠aram na̠ a̠limon na̠ E̠mu̠gh E̠tu̠tu̠ bho̠ na̠ a̠ga̠i amu̠gho̠nyan. Inyin ologhom ado̠l d̠i̠yar igiel bho̠ i̠yar u̠ro̠ na̠ inyin bho̠, na̠ o̠lo̠gh agu̠o̠ d̠i̠yar d̠a̠ ebula̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Sa̠ inyin u̠ta ma̠ od̠ighi i̠di̠ar d̠i̠yar na̠ ita̠ Wa̠nwuna̠, ma̠ ola̠ d̠a̠ esa̠d̠io ibom ali̠gam a̠ruzu eka̠, bha̠ inyin u̠da ma̠ asu̠gbagba bho̠ obhin na̠ a̠libhon ologi wa̠ na̠ ad̠u̠a d̠a̠ E̠mu̠gh E̠tu̠tu̠ bho̠ na̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Ebula̠ o̠ku̠a, inyin na̠ oten a̠nwunom ya̠ ogbo ya̠ na̠ ema̠ra̠ ma̠ asu̠gbagba bho̠ d̠a̠ Ame̠sidonia̠ na̠ Akai̠ya ta̠ e̠ta ma̠ ado̠l bho̠ erugh. ");
INSERT INTO mgj_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Ebula̠ inyin, o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ na̠ o̠sasaragi̠an d̠o̠ d̠a̠ Ame̠sidonia̠ na̠ Akai̠ya ku̠ku̠m, ya̠a̠ na̠ o̠mu̠gho̠n o̠du̠ ologi ima̠ra̠ d̠inyin a̠d̠izo a̠risisi. O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠yar unwuna̠ d̠o̠ ma̠ abar ola̠ omula̠ ofugh. ");
INSERT INTO mgj_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Ezin bho̠, a̠nwunom i̠ye̠ na̠ agu̠o̠ na̠ e̠gba ma̠ agu̠o̠ inyin u̠da i̠yar ubhin, na̠ agu̠o̠ inyin utiba̠ra̠ d̠a̠ o̠ko̠l ro̠ye̠bo̠ iru na̠ o̠ko̠l a̠ga̠i A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠, ");
INSERT INTO mgj_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","na̠ ogon O̠nyi̠ d̠o̠yo̠ ma̠ o̠d̠u̠a d̠a̠ ote̠nai̠ny oru, O̠nyi̠ d̠o̠yo̠ A̠zizo̠s wa̠ i̠na a̠b̠eton d̠a̠ omugh bho̠, wa̠ a̠tenemeni i̠yar d̠a̠ ibom i̠gam ta̠ A̠zib̠a̠ wa̠ na̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","A̠rumor na̠ aru̠marani̠ d̠i̠yar, inyin ologhom ma̠a̠, e̠gi̠ d̠i̠yar wa̠ i̠yar uru ra̠ uzua̠n inyin bho̠ na̠ obhe d̠o̠ ma̠ i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Inyin ologhom agu̠o̠ ugbikimeni i̠yar, sa̠ u̠ki̠ri̠ i̠yar d̠a̠ A̠filipai̠ kisa̠ i̠yar uten uru d̠inyin. D̠a̠ eb̠la̠ ibom i̠damaghan bho̠ eka̠, A̠zib̠a̠ a̠nigha̠ i̠yar alu̠kpo̠ ologi o̠gba Ib̠eb̠i Asu̠gbagba ya̠ na̠ e̠d̠u̠a d̠o̠yo̠ na̠ eru bho̠ onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Agu̠o̠ i̠yar na̠ o̠le̠gh inyin bho̠, bo̠ ma̠ ola̠ i̠yar ubhin d̠a̠ e̠kal ola̠ amu̠gho̠nyan ibhioma̠ i̠yar, bo̠d̠o̠ d̠a̠ i̠karabh i̠walama, bo̠d̠o̠ ma̠a̠, i̠yar na̠ o̠le̠ge̠ ma̠ o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Kpe̠le̠me̠ni̠ bha̠, i̠yar na̠ o̠gba ma̠ i̠di̠ar agu̠o̠ ogbo ya̠ A̠zib̠a̠ a̠b̠eton Ib̠eb̠i Asu̠gbagba bho̠ alo̠gh d̠a̠ agu̠o̠. I̠yar uwia̠n d̠o̠ ma̠ obhononmeni rologi a̠nwunom, a̠ten A̠zib̠a̠ wa̠ na̠ ad̠a ma̠ rologi d̠i̠yar na̠ a̠kpon bho̠. ");
INSERT INTO mgj_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Inyin ologhom ma̠a̠ i̠yar ubhin d̠o̠ ma̠ ibhelebhel aru̠nu̠ oru d̠inyin, bo̠d̠o̠ ma̠a̠ i̠yar na̠ obhelebhel na̠ okpegiom ado̠l o̠ku̠ku̠. A̠zib̠a̠ onyob̠a̠ d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","I̠yar uwia̠n d̠o̠ ma̠ o̠te̠i̠ itutumeni d̠a̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠, ya̠ ta̠ e̠d̠u̠a d̠inyin eru, bo̠d̠o̠ d̠a̠ ipa̠n ogbo. ");
INSERT INTO mgj_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Agu̠o̠ i̠yar u̠ro̠ ma̠ ogbogir ta̠ Akrai̠st bho̠, akpe̠ i̠yar obhin a̠dila̠de i̠to̠ d̠i̠yar o̠te̠i̠ i̠d̠iar d̠a̠ agu̠o̠ d̠inyin na̠ otutumeni i̠yar, kpe̠le̠me̠ni̠ bha̠ i̠yar u̠ro̠ ma̠ agu̠o̠ i̠gbara anwi̠i̠ny d̠a̠ esa̠d̠io d̠inyin, ma̠ a̠d̠ien agu̠o̠ onweni na̠ a̠kponom anwi̠i̠ny d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","obha̠ onin agu̠o̠ bho̠ i̠yar ukponom inyin. I̠yar otula̠n inyin ibom. Ebula̠ o̠ku̠a, i̠yar ubhin d̠o̠ d̠a̠ onyen ologi o̠gba ma̠ Ib̠eb̠i Asu̠gbagba bho̠ ku̠ku̠m o̠nigha̠ inyin, ya̠a̠ i̠yar u̠b̠aram na̠ a̠ghud̠um d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","A̠rumor na̠ aru̠marani̠, inyin ta̠ orue o̠ru̠ru̠an agu̠o̠ i̠yar ugbosuom a̠ruzu d̠i̠yar na̠ e̠kparama ado̠l, ugir a̠d̠uga̠la̠n na̠ etita̠n, bo̠ka̠ i̠yar u̠ro̠ ma̠ a̠dol d̠a̠ e̠mu̠ o̠ni̠ ma̠ igiel bho̠ i̠yar u̠ro̠ u̠gba ma̠ Ib̠eb̠i Asu̠gbagba ta̠ A̠zib̠a̠ unigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Inyin ronyob̠a̠, A̠zib̠a̠ onyob̠a̠ nyen, ma̠a̠, i̠yar urugha̠n inyin ogbo ya̠ uma̠ra̠ bho̠, d̠a̠ e̠b̠ab̠ala na̠ igielake̠, sa̠ abar ola̠ o̠li̠o̠m i̠yar o̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Inyin ologhom ma̠a̠, i̠yar urughom ko̠ni̠ko̠ni̠ inyin agu̠o̠ o̠we̠de̠ na̠ a̠rughom anwi̠i̠ny iyo̠yo̠ na̠ agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","I̠yar o̠le̠gh inyin, o̠kpo̠me̠ni̠ ma̠ rologi d̠inyin, sa̠ ukpon inyin d̠a̠ obhel i̠ku̠nu̠, sa̠ unuom gha̠n inyin orugh a̠ma̠rugh ya̠ ta̠ etutumeni ma̠ A̠zib̠a̠ wa̠ a̠bhelegi inyin a̠d̠ighom ani̠ d̠a̠ irileghom, na̠ isosorogia̠n d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Opa̠n abar ola̠ i̠yar na̠ o̠tu̠n na̠ otutumeni ma̠ A̠zib̠a̠ bha̠, inyin u̠nagha ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ d̠a̠ aru̠nu̠ d̠i̠yar, sa̠ inyin u̠da ubhin agu̠o̠ aro̠ ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ ga̠i bho̠, ma̠a̠ o̠nu̠o̠kpe̠ a̠nwunom e̠mara̠nwunom d̠o̠. Sa̠ A̠zib̠a̠ na̠ a̠d̠ighi ma̠ ola̠ o̠nu̠o̠kpe̠ bho̠ na̠ elol nyen d̠a̠ a̠ghud̠um d̠inyin ogbo ya̠ uma̠ra̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","A̠rumor na̠ aru̠marani̠ d̠i̠yar, inyin uten a̠nwunom ya̠ i̠ta ma̠ ado̠l ogbo ya̠ ima̠ra̠ ma̠ A̠zizo̠s Akrai̠st d̠a̠ raso̠si̠ A̠zudia̠ bho̠. Inyin ugbika̠ ma̠ onin a̠d̠ien regbika̠ d̠a̠ aru̠gu̠o̠ a̠nwunom d̠inyin agu̠o̠ raso̠si̠ i̠ye̠ igbika̠ d̠a̠ aru̠gu̠o̠ ogbo A̠zu bho̠, ");
INSERT INTO mgj_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","ya̠ igigh Wa̠nwuna̠ A̠zizo̠s Akrai̠st, sa̠ i̠ze̠gi̠ ma̠ a̠riwil bho̠, sa̠ izegi i̠yar oten o̠d̠u̠a nyen bho̠. Od̠ighi i̠di̠ar d̠awa id̠igh d̠o̠ ma̠ A̠zib̠a̠ ma̠ ologi, sa̠ ighir eb̠la̠ a̠nwunom ologi. ");
INSERT INTO mgj_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Awa na̠ e̠ghaghana i̠yar o̠gba Ib̠eb̠i Asu̠gbagba bho̠ onigha̠ ogbo ya̠ o̠ro̠ d̠o̠ ma̠ anwi̠i̠ny a̠rughun A̠zu, od̠ighi agu̠o̠ ola̠ awa ta̠ eten. Ka̠ ukpon ud̠ighom, bha̠ awa na̠ egir i̠ye̠ kigiel kigiel ma̠ omuzoghod̠i i̠karabh d̠awa. Ya̠a̠ i̠se̠n, i̠gam ta̠ A̠zib̠a̠ na̠ a̠ru ra̠ ate̠i̠ awa d̠a̠ ekunuguma̠. ");
INSERT INTO mgj_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","A̠rumor na̠ aru̠marani̠ d̠i̠yar, i̠yar u̠bagi̠na inyin awai̠ (d̠a̠ ipulupul, ya̠a̠ d̠a̠ ekpo ologi d̠o̠), ebula̠ o̠ku̠a sa̠ ebhebhia̠ inyin i̠mar id̠ighi i̠yar, ma̠ ola̠ i̠yar uwia̠n ibom omula̠ ra̠ o̠bi̠gh inyin a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","E̠mar ebhir i̠yar omula̠ oru d̠inyin. Ami̠ Apo̠l na̠ agu̠o̠ amar a̠wia̠n oru ra̠ o̠bi̠gh inyin, ya̠a̠ Eru bho̠ a̠kigima̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Eb̠em ologi d̠i̠yar, na̠ a̠libhon ologi d̠i̠yar, na̠ asu̠o̠ ibo d̠i̠yar d̠a̠ a̠misigh ta̠ Wa̠nwuna̠ A̠zizo̠s ma̠ igiel i̠na ta̠ a̠ru ka̠ ere? Inyin d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Yii, inyin asu̠o̠ ibo d̠i̠yar na̠ a̠libhon ologi d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Igiel bho̠ i̠yar orue mu̠ ma̠ one bho̠, sa̠ i̠yar u̠mu̠gho̠nyan ma̠a̠, i̠yar o̠ro̠ esi ola̠ i̠yar d̠a̠ Ate̠ns ta̠ a̠bhon a̠pu. ");
INSERT INTO mgj_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Sa̠ i̠yar uruom A̠timoti umor d̠i̠yar wa̠ na̠ i̠yar na̠ ogir ogir ta̠ A̠zib̠a̠, na̠ wa̠ na̠ agba ma̠ ib̠eb̠i asu̠gbagba ta̠ Akrai̠st na̠ asasaragi̠ bho̠, ma̠ oru ra̠ o̠ghu̠ame̠ni̠ ologi ima̠ra̠ d̠inyin na̠ o̠kpo̠me̠ni̠ rologi d̠inyin, ");
INSERT INTO mgj_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","b̠o̠ka̠ egbika̠ i̠nye̠n ko odughumeni ma̠ ologi odi o̠ni̠ inyin. Inyin o̠mar ologhom ma̠a̠, i̠ye̠ idi regbika̠ ya̠ ta̠ e̠te̠i̠ i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Igiel bho̠ i̠yar u̠ro̠ na̠ inyin bho̠, i̠yar u̠ro̠ ma̠ o̠gba o̠gba onigha̠ inyin ma̠a̠ i̠yar ta̠ ogbika̠, sa̠ na̠ emite ma̠ o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Obha̠ ezin bho̠ igiel bho̠ ami̠ one mu bho̠, sa̠ ami̠ iruom A̠timoti ma̠ oru ra̠ ologhom agu̠o̠ ologi ima̠ra̠ d̠inyin od̠i. Ami̠ ighil ka̠ Eru bho̠ na̠ ad̠agi̠an inyin ola̠ eb̠la̠ ogir d̠i̠yar na̠ ebhe ma̠ i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ya̠a̠ i̠se̠n A̠timoti na̠ ad̠u̠a d̠inyin a̠mula̠ a̠ru ra̠ agba ma̠ ib̠eb̠i asu̠gbagba ya̠ igboloma̠ ma̠ ologi ima̠ra̠ d̠inyin na̠ etula̠n d̠inyin a̠nigha̠ i̠yar. I̠na agba a̠nigha̠ i̠yar ma̠a̠ inyin na̠ o̠ru̠ru̠an na̠ ogboloma̠ i̠yar kigiel kigiel, sa̠ ebhebhia̠ i̠yar na̠ ed̠ighi inyin agu̠o̠ ebhebhia̠ inyin na̠ ed̠ighi i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠rumor na̠ aru̠marani̠ d̠i̠yar, iloghome ma̠a̠, d̠a̠ esa̠d̠io i̠nyo̠gho̠nyo̠gh na̠ ali̠gam a̠ruzu ya̠ na̠ e̠te̠i̠ i̠yar bho̠, ma̠a̠, ologi ima̠ra̠ d̠inyin na̠ akpo̠me̠ni̠ ma̠ ologi d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","I̠se̠n agu̠o̠ ologi ima̠ra̠ d̠inyin na̠ aghu̠a d̠a̠ Wa̠nwuna̠ bho̠, bha̠ na̠ a̠nigha̠ i̠yar e̠mi̠ a̠ghud̠um. ");
INSERT INTO mgj_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","I̠yar ta̠ o̠se̠bh A̠zib̠a̠ eka̠ ma̠ ebula̠ inyin? I̠yar na̠ o̠se̠bh i̠na ma̠ a̠libhon ologi wa̠ i̠yar unwuna̠ d̠a̠ a̠misigh d̠o̠yo̠ ma̠ ebula̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","A̠d̠uga̠la̠n na̠ etita̠n, i̠yar na̠ obhin eb̠la̠ ologi d̠i̠yar na̠ osiseiny A̠zib̠a̠ ma̠ od̠ighi agu̠o̠ ola̠ i̠yar ta̠ oru ra̠ o̠bi̠gh inyin a̠d̠ien, onigha̠ inyin i̠di̠ar ya̠ o̠ghu̠ame̠ni̠ ologi ima̠ra̠ d̠inyin opeleni agu̠o̠ od̠i ma̠ i̠se̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","A̠zib̠a̠ O̠we̠de̠ d̠i̠yar na̠ agu̠o̠, na̠ Wa̠nwuna̠ d̠i̠yar A̠zizo̠s erileghom i̠yar a̠ru ra̠ ate̠i̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Wa̠nwuna̠ A̠zib̠a̠ bho̠ a̠d̠ighi ma̠ agu̠o̠ ola̠, e̠mi̠ etula̠n wa̠ od̠i d̠a̠ esa̠d̠io d̠inyin na̠ ipa̠n ogbo bho̠, ta̠ agi̠ ma̠ anyu̠, ma̠ onin agu̠o̠ i̠yar utula̠n inyin u̠te̠i̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","I̠na akparame̠ni̠ inyin ma̠ agu̠o̠ ola̠ abar o̠li̠o̠m inyin ko o̠ro̠ d̠o̠, ya̠a̠ inyin ta̠ o̠ro̠ d̠a̠ e̠b̠ab̠ala d̠a̠ a̠misigh ta̠ A̠zib̠a̠ O̠we̠de̠ d̠i̠yar, ma̠ igiel Wa̠nwuna̠ A̠zizo̠s ta̠ a̠ru na̠ eb̠la̠ a̠nwunom e̠b̠ab̠ala d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","A̠rumor na̠ aru̠marani̠, d̠a̠ okunugiom bha̠, iloghome ma̠a̠, i̠yar na̠ o̠tu̠ghu̠me̠ni̠ inyin agu̠o̠ orugh ado̠l ya̠ ta̠ ed̠igh A̠zib̠a̠ ma̠ ologi, sa̠ inyin na̠ orugh o̠ku̠a nyen. I̠se̠n i̠yar na̠ obhin d̠a̠ a̠d̠ien ta̠ A̠zizo̠s na̠ o̠le̠gh inyin, na̠ o̠kparame̠ni̠ ma̠ rologi d̠inyin, ogir opeleni o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Ezin bho̠, inyin ologhom ra̠kikiom ya̠ i̠yar ubhin a̠limon ta̠ Wa̠nwuna̠ A̠zizo̠s ukikiom inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","A̠zib̠a̠ na̠ abho̠ro̠ghan inyin o̠b̠ab̠ala. O̠ku̠a a̠d̠ighi be̠le̠ni̠, ighele ma̠ ado̠l od̠e e̠ma. ");
INSERT INTO mgj_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Ko̠ni̠ko̠ni̠ inyin, a̠sibhom ozu d̠o̠yo̠ a̠rugh ado̠l e̠b̠ab̠ala na̠ edim, ");
INSERT INTO mgj_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","o̠ro̠ d̠o̠ ma̠ ola̠ inyin ta̠ obhibhirigha̠n a̠ruzu ya̠ ipesi, ma̠ agu̠o̠ ogbo ya̠ ologhom d̠o̠ ma̠ A̠zib̠a̠ na̠ egir bho̠. ");
INSERT INTO mgj_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","D̠a̠ e̠kal abar onon, o̠ro̠ d̠o̠ ma̠ ola̠ odi o̠ni̠ inyin ta̠ a̠bhin ikoiny a̠gir i̠karabh a̠gboloma̠ ma̠ umor, bo̠d̠o̠ a̠pesiom u̠marani̠. I̠yar na̠ od̠ia̠ o̠gba onigha̠ inyin ma̠a̠, A̠zib̠a̠ ta̠ a̠gbikimeni ko̠ni̠ko̠ni̠ ola̠ a̠gir i̠karabh ya̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","A̠zib̠a̠ na̠ obhelegi d̠o̠ i̠yar orugh ado̠l od̠e e̠ma, ya̠a̠ i̠yar orugh a̠ghud̠um e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ola̠ a̠gin i̠tu̠ghu̠me̠ni̠ i̠nye̠n na̠ ogin d̠o̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠, ya̠a̠ a̠ghel A̠zib̠a̠ wa̠ na̠ a̠nigha̠ inyin E̠mu̠gh E̠tu̠tu̠ d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Ezin ola̠ i̠yar ta̠ o̠tu̠n o̠ge̠ oruom inyin agu̠o̠ ola̠ odi ta̠ a̠tula̠n odi bo̠, ezin bho̠ inyin na̠ agu̠o̠ na̠ o̠tu̠ghan d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠ ma̠ agu̠o̠ odi ta̠ a̠tula̠n odi. ");
INSERT INTO mgj_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Sa̠ inyin na̠ ogir o̠ku̠a nyen. Ya̠gia̠ga̠i, inyin na̠ otula̠n eb̠la̠ ogbo ya̠ na̠ inyin uma̠ra̠ ya̠ od̠i d̠a̠ Ame̠sidonia̠ bho̠. Ku̠ku̠m eka̠, i̠yar na̠ o̠le̠gh inyin ogir opeleni o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Iguri d̠a̠ i̠walama d̠inyin orugh ado̠l ekima̠, ma̠ e̠ro̠ ma̠ esi ola̠ inyin, ma̠ ebhin aru̠gu̠o̠ d̠inyin egir ogir, ma̠ agu̠o̠ i̠yar ud̠ia̠ ukikiom inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Ka̠ inyin ugir o̠ku̠a sa̠ inyin ta̠ od̠igh edim d̠a̠ a̠misigh ogbo ya̠ d̠a̠ etire ya̠ ologhom d̠o̠ ma̠ Wa̠nwuna̠ bho̠, sa̠ ko o̠ro̠ d̠o̠ ma̠ ola̠ inyin ta̠ obhin o̠ni̠ ob̠em ologi. ");
INSERT INTO mgj_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","A̠rumor na̠ aru̠marani̠ d̠i̠yar, i̠yar na̠ o̠bho̠ro̠ghan inyin onwuna̠ amu̠gho̠nyan ogboloma̠ ogbo ya̠ na̠ emugughu bho̠, b̠o̠ka̠ inyin u̠ku̠nu̠ ma̠ i̠ku̠nu̠ ma̠ agu̠o̠ a̠nwunom ya̠ onwuna̠ d̠o̠ ma̠ eb̠em ologi. ");
INSERT INTO mgj_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Agu̠o̠ i̠yar uma̠ra̠ ma̠ A̠zizo̠s a̠mugh sa̠ a̠b̠etina̠ d̠a̠ omugh bho̠, obha̠ onin agu̠o̠ i̠yar uma̠ra̠ ma̠a̠, igiel i̠na ta̠ a̠mula̠ a̠ru, A̠zib̠a̠ ta̠ a̠b̠egion imumugh ya̠ ima̠ra̠ ma̠ A̠zizo̠s d̠a̠ a̠ghud̠um d̠awa bho̠ ab̠aram a̠bhin a̠ru. ");
INSERT INTO mgj_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","I̠yar na̠ obhin d̠a̠ o̠nu̠o̠kpe̠ ta̠ Wa̠nwuna̠ bho̠ na̠ o̠gba na̠ onigha̠ inyin ma̠a̠, igiel Wa̠nwuna̠ bho̠ ta̠ a̠mula̠ a̠ru, i̠yar ogbo ya̠ ta̠ o̠ro̠ d̠a̠ a̠ghud̠um o̠te̠i̠ igiel i̠na ta̠ a̠ru bho̠, ko od̠ia̠ d̠o̠ na̠ ogbo ya̠ na̠ emugughu bho̠ ka̠ o̠te̠i̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Wa̠nwuna̠ bho̠ na̠ agu̠o̠ ta̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠sor a̠ru na̠ obom okoroko izul, na̠ izul ta̠ we̠mu̠ itileduom bho̠, na̠ okoroko od̠od̠ue ta̠ A̠zib̠a̠, sa̠ ogbo ya̠ ima̠ra̠ ma̠ Akrai̠st kisa̠ imugh bho̠ ta̠ ed̠ia̠ eb̠egina̠. ");
INSERT INTO mgj_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","O̠tu̠o̠no̠m i̠se̠ sa̠ A̠zib̠a ta̠ a̠kpobh i̠yar ogbo ya̠ od̠id̠ia̠ d̠a̠ a̠ghud̠um d̠a̠ obhel obha̠ bho̠ a̠bhuneni, ka̠ a̠d̠ighom na̠ awa d̠a̠ o̠b̠u̠ghu̠b̠u̠gh ka̠ e̠te̠i̠ Wa̠nwuna̠ bho̠ d̠a̠ e̠nai̠ny. Ob̠eton d̠a̠ obhel obha̠ o̠gi̠ d̠a̠ ed̠ia̠ sa̠ i̠yar ta̠ od̠igh na̠ Wa̠nwuna̠ bho̠ o̠ro̠ tu̠tu̠n kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","O̠ku̠a a̠d̠ighi be̠le̠ni̠, odi a̠bhin ro̠nu̠o̠kpe̠ i̠nye̠n akpo̠me̠ni̠ ma̠ ologi ta̠ odi. ");
INSERT INTO mgj_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","A̠rumor na̠ aru̠marani̠, ezin bo̠ ma̠ ola̠ o̠tu̠n o̠ge̠ ogboloma̠ obhel wa̠ i̠di̠ar i̠nye̠n ta̠ emite bho̠ oruom inyin. ");
INSERT INTO mgj_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Ezin bho̠ inyin o̠mar ologhom ma̠a̠ A̠d̠a̠ma̠ ta̠ A̠zib̠a̠ bho̠ ta̠ a̠ru ma̠ agu̠o̠ o̠gba ma̠ a̠d̠uga̠la̠n. ");
INSERT INTO mgj_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Igiel a̠nwunom na̠ e̠gba ma̠a̠, “Kabar kabar od̠i d̠a̠ ekima̠ na̠ d̠a̠ eko,” bha̠ a̠d̠ugh ta̠ a̠ru ra̠ ate̠i̠ awa ma̠ awai̠ ma̠ agu̠o̠ iguna̠ na̠ ate̠i̠ ani̠ eghun, sa̠ awa ko orue d̠o̠ emiza̠n. ");
INSERT INTO mgj_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Ya̠a̠ inyin a̠rumor na̠ aru̠marani̠ d̠ami̠ bo̠ d̠a̠ azi̠m, ma̠ ola̠ A̠d̠a̠ma̠ ta̠ Wa̠nwuna̠ bho̠ ta̠ a̠ru ra̠ a̠b̠ol inyin u̠man ma̠ agu̠o̠ o̠gba. ");
INSERT INTO mgj_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Eb̠la̠ inyin anwi̠i̠ny e̠b̠alab̠al na̠ etita̠n a̠d̠io. I̠yar iya̠ a̠d̠uga̠la̠n a̠d̠io na̠ azi̠m d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠yar okod̠u d̠o̠ ma̠ agu̠o̠ ipa̠n ogbo, ya̠a̠, i̠yar o̠ro̠ ma̠ omom okpon okimeni ma̠ a̠ruzu. ");
INSERT INTO mgj_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Ogbo ya̠ na̠ ekod̠u ma̠ adi̠la na̠ ekod̠u ma̠ a̠d̠uga̠la̠n, sa̠ i̠d̠ama̠min bho̠ na̠ e̠d̠a na̠ e̠bhu̠ghu̠d̠i̠an a̠d̠uga̠la̠n. ");
INSERT INTO mgj_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Ya̠a̠ agu̠o̠ i̠yar u̠ro̠ ma̠ anwi̠i̠ny etita̠n bho̠, i̠yar okimeni ma̠ a̠ruzu. I̠yar o̠lo̠gi̠an ologi ima̠ra̠ na̠ etula̠n ka̠ ekpeke-e̠gham, ozuoma̠ ma̠ eb̠em ologi itenemeni ka̠ eghoiy-e̠gham. ");
INSERT INTO mgj_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Ezin bho̠, A̠zib̠a̠ na̠ odin d̠o̠ i̠yar o̠bi̠gh ali̠gam a̠ruzu i̠gam d̠o̠yo̠ aso̠n i̠yar, ya̠a̠ atu̠n i̠yar o̠te̠i̠ itenemeni d̠a̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","I̠na a̠mugh a̠nigha̠ i̠yar agu̠o̠ ola̠ i̠yar ta̠ od̠igh na̠ i̠na orugha̠n, d̠a̠ obhel ola̠ i̠yar od̠i d̠a̠ a̠ghud̠um, bo̠d̠o̠ d̠a̠ obhel ola̠ i̠yar na̠ omugughu eka̠. ");
INSERT INTO mgj_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","O̠ku̠a a̠d̠ighi be̠le̠ni̠, odi akpo̠me̠ni̠ ma̠ ologi ta̠ odi, alo̠gh agu̠o̠ a̠nigha̠ ma̠ o̠ni̠no̠ni̠no̠, ma̠ agu̠o̠ inyin na̠ ogir i̠se̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","A̠rumor na̠ aru̠marani̠, i̠yar na̠ o̠le̠gh inyin olelegi ogbo ya̠ na̠ egir ibom d̠a̠ esa̠d̠io d̠inyin bho̠, sa̠ na̠ erileghom, na̠ e̠tu̠ghu̠me̠ni̠ inyin agu̠o̠ orugh a̠ghud̠um igielake̠ onigha̠ Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Ibhine awa ma̠ e̠tu̠o̠m abar ma̠ etula̠n awa d̠a̠ ebula̠ ogir d̠awa. Ekima̠ aro̠ d̠a̠ esa̠d̠io d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","A̠rumor na̠ aru̠marani̠, i̠yar na̠ o̠kparame̠ni̠ na̠ o̠gba na̠ onigha̠ inyin ma̠a̠, ikikiome ma̠ i̠gbu̠o̠ro̠gbu̠o̠r, ma̠ e̠kpo̠me̠ni̠ ma̠ ogbo ya̠ na̠ e̠ku̠ ma̠ a̠d̠ien bho̠, ma̠ e̠lo̠gh agu̠o̠ ma̠ enigha̠ ma̠ ogbo ya̠ na̠ edugh bho̠, ma̠ ene ma̠ egboloma̠ ko̠ni̠ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Iwia̠ne ma̠ agu̠o̠ ola̠ odi ko od̠e d̠o̠ ma̠ odi ma̠ olo, ya̠a̠ id̠ighi odi a̠gir abar wa̠ a̠bhon ogir bho̠ a̠nigha̠ ma̠ odi na̠ eb̠la̠ ipa̠n ogbo. ");
INSERT INTO mgj_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","I̠ro̠ d̠a̠ a̠libhon ologi kigiel kigiel. ");
INSERT INTO mgj_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Isiseinye ma̠ eb̠la̠ igiel. ");
INSERT INTO mgj_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Kabar kabar ola̠ a̠mite, i̠se̠bhe̠ ma̠ A̠zib̠a̠. Ezin bho̠ onon abar wa̠ A̠zib̠a̠ na̠ abho̠ro̠gh inyin ogir bho̠, d̠a̠ agu̠o̠ inyin u̠ro̠ ma̠ iya̠ A̠zizo̠s Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","O̠ni̠ ko odughumeni ma̠ E̠mu̠gh e̠tu̠tu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","O̠ni̠ ko o̠ki̠ri̠ ma̠ iwowa̠, ");
INSERT INTO mgj_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ya̠a̠ i̠d̠a kabar kabar ekpon, ma̠ e̠da ma̠ iya̠ ibhon bho̠ ma̠ ebhin, ");
INSERT INTO mgj_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ma̠ eghel ka̠d̠ien ka̠d̠ien i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","A̠zib̠a̠ wa̠ aro̠ ma̠ A̠zib̠a̠ ekima̠ bho̠ na̠ agu̠o̠, ab̠ab̠alame̠ni̠ inyin d̠a̠ eb̠la̠ re̠kal a̠ghud̠um d̠inyin, d̠a̠ e̠mu̠gh, d̠a̠ eloghoma̠n ozu, na̠ d̠a̠ ipulupul ozu. A̠zib̠a̠ a̠guri inyin agu̠o̠ ola̠ ko o̠bi̠gh d̠o̠ ma̠ abar ola̠ o̠li̠o̠m inyin ma̠ igiel A̠zizo̠s Akrai̠st ta̠ a̠mula̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","I̠na wa̠ a̠bhelegi inyin bho̠ na̠ a̠sibh ogua̠n, sa̠ ta̠ a̠gir agu̠o̠ agba bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","A̠rumor na̠ aru̠marani̠, isiseinye ma̠ enigha̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Ipura̠ne ma̠ eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠ d̠a̠ a̠libhon ologi na̠ etula̠n. ");
INSERT INTO mgj_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Ami̠ na̠ akparame̠ni̠ na̠ a̠bhin d̠a̠ a̠limon ta̠ Wa̠nwuna̠ bho̠ na̠ a̠ruom inyin osen a̠d̠ire a̠lebh onon onigha̠ eb̠la̠ ogbo ya̠ ima̠ra̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","E̠no̠gho̠man ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st e̠ro̠ na̠ inyin.");
INSERT INTO mgj_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Ami̠ Apo̠l, na̠ Asai̠las, na̠ A̠timoti, na̠ o̠ge̠ na̠ oruom inyin ogbo ya̠ na̠ e̠gi̠ ma̠ aso̠si̠ d̠a̠ Ate̠salonia̠ bho̠, ya̠ i̠ro̠ ma̠ a̠nwunom ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","E̠no̠gho̠man na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠, na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st e̠ro̠ na̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","A̠rumor na̠ aru̠marani̠, akpe̠ i̠yar o̠se̠bh A̠zib̠a̠ eb̠la̠ kigiel ebula̠ agu̠o̠ ologi ima̠ra̠ d̠inyin na̠ a̠bhobh bho̠, sa̠ etula̠n wa̠ od̠i d̠a̠ esa̠d̠io d̠inyin na̠ abu̠gh e̠mi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Obha̠ bha̠ ezin wa̠ i̠yar na̠ obhin inyin na̠ obo d̠a̠ raso̠si̠ ta̠ A̠zib̠a̠ bho̠. I̠yar na̠ obo d̠a̠ a̠ma̠ne d̠inyin, na̠ ologi ima̠ra̠ d̠inyin, na̠ agu̠o̠ inyin na̠ osibhom a̠ruzu d̠a̠ esa̠d̠io i̠damaghan na̠ egbika̠ ya̠ na̠ e̠te̠i̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","I̠nye̠n na̠ eleriom ma̠a̠, A̠zib̠a̠ na̠ a̠sobh ase̠ igielake̠, sa̠ na̠ e̠gba na̠ emutiom ma̠a̠ inyin o̠kpe̠ ma̠ od̠igh d̠a̠ irileghom d̠o̠yo̠, ma̠ agu̠o̠ inyin na̠ one ma̠ ali̠gam a̠ruzu ya̠ na̠ e̠te̠i̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Agu̠o̠ A̠zib̠a̠ aro̠ ma̠ ola̠ igielake̠ bho̠, i̠na ta̠ a̠nigha̠ ma̠ ali̠gam a̠ruzu ma̠ ogbo ya̠ na̠ enigha̠ inyin ali̠gam a̠ruzu bho̠, ");
INSERT INTO mgj_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","sa̠ i̠na ta̠ a̠tenemeni inyin d̠a̠ ali̠gam a̠ruzu ya̠ na̠ e̠te̠i̠ inyin bho̠, sa̠ ta̠ ab̠aram na̠ i̠yar a̠tenemeni. I̠na ta̠ a̠gir o̠ku̠a ma̠ igiel Wa̠nwuna̠ A̠zizo̠s ta̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠mite a̠ru na̠ imoma̠na̠n itileduom ta̠ A̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","na̠ e̠ba anya ola̠ na̠ a̠mumor belembelem na̠ a̠rubhula̠, ma̠ obhin o̠kpe̠ ogbo ya̠ ologhom d̠o̠ ma̠ A̠zib̠a̠, sa̠ i̠b̠agh e̠mu̠ igboloma̠ ma̠ Ib̠eb̠i O̠nu̠o̠kpe̠ ta̠ Wa̠nwuna̠ d̠i̠yar A̠zizo̠s bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ta̠ ogbikimeni awa ma̠ egbika̠ kid̠ud̠ul, sa̠ ta̠ o̠bagi̠o̠n awa o̠si̠ghe̠ d̠a̠ a̠misigh ta̠ Wa̠nwuna̠ bho̠ na̠ a̠limon isosorogia̠n d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Igiel i̠na ta̠ a̠mula̠ a̠ru, eb̠la̠ a̠nwunom ya̠ ima̠ra̠ i̠na bho̠ ta̠ e̠bu̠ghu̠me̠ni̠ i̠na, sa̠ ta̠ a̠d̠igh awa ma̠ ilologia̠n. Inyin od̠i ani̠ d̠a̠ o̠lo̠gh d̠awa, ezin bho̠ inyin oma̠ra̠ ma̠ i̠di̠ar ya̠ i̠yar u̠gba unigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Ebula̠ o̠ku̠a sa̠ i̠yar na̠ osiseiny na̠ onigha̠ inyin kigiel kigiel, ma̠ agu̠o̠ ola̠ A̠zib̠a̠ ta̠ alo̠gh agu̠o̠ a̠nigha̠ inyin ma̠ o̠ro̠ agu̠o̠ a̠nwunom ya̠ ta̠ erugh ado̠l wa̠ akpe̠ ma̠ agu̠o̠ ogbo ya̠ i̠na na̠ aso̠n bho̠ ma̠ orugh. I̠na a̠bhin a̠limon d̠o̠yo̠ a̠muzoghod̠iom eb̠la̠ ib̠eb̠i i̠walama d̠inyin, na̠ rogir ya̠ ologi ima̠ra̠ d̠inyin na̠ enuom inyin ogir bho̠. ");
INSERT INTO mgj_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","I̠yar na̠ osiseiny o̠ku̠a b̠o̠ka̠ otutumeni ma̠ a̠d̠ien ta̠ Wa̠nwuna̠ A̠zizo̠s ma̠ ebula̠ inyin, sa̠ i̠na ta̠ a̠tutumeni inyin nyen, d̠a̠ e̠ne̠ghe̠ ta̠ A̠zib̠a̠ d̠i̠yar na̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","A̠rumor na̠ aru̠marani̠, i̠yar na̠ o̠le̠gh inyin, ya̠ igboloma̠ ma̠ omula̠ oru ta̠ Wa̠nwuna̠ A̠zizo̠s, na̠ a̠kokod̠ia̠n wa̠ i̠yar ta̠ ka̠ o̠te̠i̠ i̠na bho̠, ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","o̠ni̠ ko o̠su̠su̠ghu̠d̠i̠an d̠a̠ i̠ru̠ru̠an, o̠ni̠ ko okpa̠ra̠noma̠ nyen egboloma̠ ma̠ atu̠ghu̠me̠ni̠ ya̠ ta̠ ekue e̠gba ma̠a̠ i̠d̠u̠a d̠a̠ iwowa̠ d̠i̠yar, bo̠d̠o̠ d̠a̠ a̠fugh o̠nu̠, bo̠d̠o̠ d̠a̠ a̠lebh eru, sa̠ ta̠ e̠gba ma̠a̠ A̠d̠a̠ma̠ ta̠ Wa̠nwuna̠ bho̠ na̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Agu̠o̠ ka̠ agu̠o̠ ta̠ e̠bhi̠bhi̠ri̠gi̠, o̠ni̠ ko oma̠ra̠ ma̠ o̠ni̠ ma̠ ogelemeni inyin. Ezin bho̠, kisa̠ A̠d̠a̠ma̠ bho̠ ta̠ a̠ru, a̠nwunom ta̠ ewia̠n a̠limon ta̠ A̠zib̠a̠ sa̠ ta̠ e̠damaghan i̠na ma̠ o̠kparakpar agu̠o̠, sa̠ O̠karabh O̠ni̠ wa̠ ta̠ orobh o̠lo̠gh d̠a̠ e̠ba anya od̠im o̠to̠ bho̠ ta̠ a̠mutiom ozu. ");
INSERT INTO mgj_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","O̠karabh O̠ni̠ bho̠ ta̠ adamaghan kabar kabar ola̠ a̠gboloma̠ ma̠ A̠zib̠a̠, sa̠ ta̠ abu̠ghu̠me̠ni̠ ma̠ ozu d̠o̠yo̠ a̠peleni kabar kabar ola̠ na̠ obhelegi ma̠ a̠zib̠a̠, bo̠d̠o̠ ola̠ na̠ o̠ko̠l. I̠na ta̠ agi̠ ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ Otu ta̠ A̠zib̠a̠ nyen are̠ma ma̠a̠ i̠na A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Ka̠ inyin ta̠ orue o̠ru̠ru̠an, ami̠ agba gha̠n i̠di̠ar i̠nye̠n a̠nigha̠ inyin igiel bho̠ ami̠ i̠ro̠ na̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Ya̠a̠, i̠se̠n inyin na̠ ologhom abar wa̠ na̠ a̠sibh O̠karabh O̠ni̠ bho̠ na̠ a̠guri tu̠tu̠n ta̠ ate̠i̠ a̠ga̠i obhel wa̠ i̠na ta̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","I̠se̠n bha̠ a̠limon e̠wo̠gi̠na wa̠ na̠ a̠d̠ighi ma̠ a̠nwunom o̠we̠le̠ osibh oloko bho̠ na̠ ake̠ ma̠ ogir. Ya̠a̠ o̠ni̠ wa̠ na̠ a̠sibh a̠limon bho̠ na̠ a̠guri bho̠ ta̠ a̠sibh tu̠tu̠n i̠na ta̠ a̠toka̠n. ");
INSERT INTO mgj_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","I̠se̠ kisa̠ o̠ni̠ wa̠ osibh d̠o̠ ma̠ oloko bho̠ ta̠ a̠mutiom ozu. Ya̠a̠, igiel Wa̠nwuna̠ A̠zizo̠s ta̠ a̠mula̠ a̠ru sa̠ ta̠ a̠pughe ma̠ obhubhulom d̠a̠ o̠nu̠ d̠o̠yo̠ a̠gigh O̠ni̠ wa̠ osibh d̠o̠ ma̠ oloko bho̠, sa̠ ta̠ a̠bhin isosorogia̠n d̠o̠yo̠ a̠kunugi i̠na. ");
INSERT INTO mgj_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Eruoma̠ O̠ni̠ wa̠ osibh d̠o̠ ma̠ oloko bho̠ ta̠ agi̠ na̠ od̠ighi i̠di̠ar ta̠ Eru bho̠, sa̠ ta̠ a̠bhin a̠d̠ien kere kere a̠limon a̠mutioghom relegh, a̠gir ilologia̠n igunugha̠, ");
INSERT INTO mgj_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","sa̠ ta̠ a̠bhin a̠d̠ien kerekere i̠karabh ikoiny a̠gelemeni ma̠ ogbo ya̠ ta̠ ebhe bho̠. Awa ta̠ emugughu ekun, ezin bho̠ awa ima̠ra̠ d̠o̠ ma̠ otula̠n a̠gia̠ga̠i bho̠ o̠da obhin b̠o̠ka̠ awa eten. ");
INSERT INTO mgj_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Ebula̠ o̠ku̠a, A̠zib̠a̠ ta̠ afi̠ri̠ma ma̠ a̠limon ola̠ o̠su̠su̠ghu̠d̠i̠ i̠ru̠ru̠an d̠awa b̠o̠ka̠ awa ema̠ra̠ ma̠ igunugha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Sa̠ ta̠ a̠mite ma̠ ola̠ ta̠ osobh ase̠ obhumeni ma̠ eb̠la̠ ogbo ya̠ oma̠ra̠ d̠o̠ ma̠ a̠gia̠ga̠i bho̠, ya̠a̠ na̠ eba̠ra̠ kuma̠ od̠ighi i̠karabh bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","A̠rumor na̠ aru̠marani̠, i̠yar na̠ o̠se̠bh A̠zib̠a̠ kigiel kigiel ebula̠ inyin ogbo ya̠ Wa̠nwuna̠ bho̠ a̠tula̠n bho̠. Ezin bho̠ A̠zib̠a̠ aso̠n inyin oten ka̠ o̠pu̠r ob̠eton bho̠, d̠a̠ o̠wo̠l oten a̠limon ta̠ E̠mu̠gh E̠tu̠tu̠ bho̠, wa̠ ta̠ a̠d̠ighi ma̠ ola̠ inyin ta̠ o̠b̠ab̠ala d̠a̠ ebula̠ agu̠o̠ inyin uma̠ra̠ ma̠ a̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","I̠na awo̠l d̠a̠ Ib̠eb̠i Asu̠gbagba d̠o̠yo̠ ya̠ i̠yar u̠gba unigha̠ inyin bho̠ a̠bhelegi inyin, ma̠ inyin o̠te̠i̠ a̠bin d̠inyin d̠a̠ isosorogia̠n ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠rumor na̠ aru̠marani̠, i̠kpo̠ ma̠ ologi ma̠ e̠mara d̠a̠ atu̠ghu̠me̠ni̠ ya̠ i̠yar u̠tu̠ghu̠me̠ni̠ inyin bho̠, ya̠ i̠d̠u̠a d̠a̠ aru̠nu̠ d̠i̠yar imite bho̠ bo̠d̠o̠ d̠a̠ ra̠lebh ya̠ i̠yar u̠ge̠ uruom inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Wa̠nwuna̠ A̠zizo̠s Akrai̠st na̠ agu̠o̠ na̠ A̠zib̠a̠ O̠we̠de̠ d̠i̠yar, wa̠ a̠tula̠n i̠yar bho̠, d̠a̠ ebula̠ igbirigbir d̠o̠yo̠ sa̠ a̠nigha̠ i̠yar alu̠kpo̠ ologi ya̠ ekunuguma̠ o̠to̠ na̠ a̠ga̠i eb̠em ologi bho̠, ");
INSERT INTO mgj_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","akpo̠me̠ni̠ ma̠ rologi na̠ a̠ruzu d̠inyin d̠a̠ ob̠eb̠i ka̠ ob̠eb̠i abar ola̠ inyin na̠ ogir na̠ iya̠ inyin na̠ ofugh. ");
INSERT INTO mgj_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","D̠a̠ ipa̠n i̠di̠ar bha̠ i̠yar na̠ o̠gba na̠ onigha̠ inyin a̠rumor na̠ aru̠marani̠ ma̠a̠, isiseinye ma̠ enigha̠ i̠yar agu̠o̠ ola̠ Ib̠eb̠i O̠nu̠o̠kpe̠ ta̠ Wa̠nwuna̠ bho̠ ta̠ e̠sasaragi̠an onyen, na̠ a̠nwunom o̠da obhin na̠ edim, agu̠o̠ aro̠ na̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Isiseinye ma̠ agu̠o̠ ola̠ A̠zib̠a̠ ta̠ a̠tenemeni i̠yar d̠a̠ aru̠gu̠o̠ id̠im na̠ id̠ighi ma̠ i̠karabh a̠nwunom, ezin bho̠ ko̠ni̠ko̠ni̠ ta̠ oma̠ra̠ d̠o̠ ma̠ O̠nu̠o̠kpe̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Ya̠a̠ Wa̠nwuna̠ wa̠ na̠ a̠sibh ogua̠n bho̠, ta̠ akpo̠me̠ni̠ ma̠ a̠ruzu d̠inyin a̠guri inyin esi eko a̠sigimeni ma̠ O̠karabh O̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","I̠yar onwuna̠ ma̠ alu̠kpo̠ ologi d̠a̠ Wa̠nwuna̠ bho̠ ma̠a̠, inyin na̠ ogir agu̠o̠ i̠yar u̠gba unigha̠ inyin bho̠, sa̠ inyin ta̠ o̠ro̠ ma̠ ogir ogir o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Wa̠nwuna̠ bho̠ a̠rileghom rologi d̠inyin d̠a̠ etula̠n ta̠ A̠zib̠a̠ na̠ a̠ma̠ne wa̠ Akrai̠st na̠ a̠nigha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","A̠rumor na̠ aru̠marani̠, i̠yar na̠ obhin d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st na̠ o̠kparame̠ni̠ na̠ o̠gba na̠ onigha̠ inyin ma̠a̠, isigima̠ ma̠ ogbo ya̠ od̠i d̠a̠ onin ologi ima̠ra̠ bho̠ ya̠ na̠ erugh ado̠l e̠gbu̠o̠r, na̠ ogbo ya̠ o̠tu̠o̠no̠m d̠o̠ ma̠ atu̠ghu̠me̠ni̠ ya̠ i̠yar u̠tu̠ghu̠me̠ni̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Inyin o̠mar ologhom ma̠a̠, akpe̠ inyin o̠ta ado̠l d̠i̠yar agu̠o̠ i̠yar o̠ro̠ d̠o̠ ma̠ i̠gbu̠o̠ro̠gbu̠o̠r d̠a̠ igiel bho̠ i̠yar u̠ro̠ na̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","I̠yar ubhin d̠o̠ ma̠ ed̠ia̠n d̠a̠ agu̠o̠ o̠ni̠ od̠e ma̠ inwo nyen. Kpe̠le̠me̠ni̠ bha̠ i̠yar ugir ogir a̠d̠uga̠la̠n na̠ etita̠n, ogbosuom a̠ruzu, ma̠ agu̠o̠ ola̠ i̠yar ko onigha̠ d̠o̠ ma̠ o̠ni̠ inyin a̠dol. ");
INSERT INTO mgj_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Bo̠d̠o̠ ma̠ ola̠ i̠yar onwuna̠ d̠o̠ ma̠ a̠dila̠de a̠limon opuru inyin o̠lo̠gh agu̠o̠ onigha̠ i̠yar, ya̠a̠ i̠yar ugir o̠ku̠a b̠o̠ka̠ inyin o̠ta ma̠ a̠ma̠rugh d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Odi abar eka̠, i̠yar u̠lo̠gh oloko onigha̠ inyin ma̠ igiel bho̠ i̠yar u̠ro̠ na̠ inyin bho̠ ma̠a̠, “O̠ni̠ ola̠ oma̠ra̠ d̠o̠ ma̠ ogir ogir o̠te̠i̠ d̠o̠ ma̠ abar d̠a̠ agu̠o̠ opa̠n o̠ni̠ a̠d̠e. O̠ni̠ ola̠ ogir d̠o̠ od̠e d̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","I̠yar na̠ o̠mu̠gho̠n ma̠a̠, idi inyin na̠ orugh ado̠l e̠gbu̠o̠r, sa̠ opa̠n abar ola̠ na̠ egir bo̠ a̠ten o̠d̠u̠a esi oten esi na̠ i̠me̠ghe̠nyan. ");
INSERT INTO mgj_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","I̠yar na̠ o̠gba na̠ o̠kparame̠ni̠ na̠ onigha̠ ma̠ a̠nwunom ya̠ o̠ku̠a, sa̠ i̠yar na̠ o̠le̠gh awa d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st, ma̠ o̠ro̠ d̠a̠ ekima̠, obhin aru̠gu̠o̠ d̠awa ogir o̠te̠i̠ ed̠ia̠n ya̠ awa ta̠ ed̠e. ");
INSERT INTO mgj_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Ya̠a̠ inyin a̠rumor na̠ aru̠marani̠, ogir ib̠eb̠i o̠tabh d̠o̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","I̠mare̠ ma̠ ekpon elelegi ma̠ o̠ni̠ ola̠ oma̠ra̠ d̠o̠ ma̠ o̠nagha o̠nu̠o̠kpe̠ d̠i̠yar, ya̠ i̠yar u̠ge̠ d̠a̠ a̠lebh onon bho̠. O̠ni̠ ko od̠ed̠ia̠n o̠ni̠ ola̠ oku̠a, b̠o̠ka̠ i̠na a̠d̠igh ari̠ghe̠l. ");
INSERT INTO mgj_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ku̠ku̠m eka̠, o̠ni̠ ko oguri i̠na ma̠ agu̠o̠ o̠ni̠ o̠lo̠gi̠an a̠d̠ien, ya̠a̠ ikikiome i̠na ma̠ agu̠o̠ umor bo̠d̠o̠ u̠marani̠ d̠a̠ onin ologi ima̠ra̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Wa̠nwuna̠ bho̠ na̠ agu̠o̠, wa̠ na̠ a̠nigha̠ ma̠ ekima̠ bho̠, a̠nigha̠ inyin ekima̠ kigiel kigiel d̠a̠ eb̠la̠ re̠kal. Wa̠nwuna̠ bho̠ aro̠ na̠ eb̠la̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Ami̠ Apo̠l na̠ agu̠o̠, ibhin agu̠o̠ d̠ami̠ age̠ ma̠ ibheleguma̠ ya̠ od̠i d̠a̠ a̠lebh onon bho̠. Ami̠ na̠ age̠ ma̠ o̠ku̠a ma̠ o̠ro̠ elegh d̠a̠ eb̠la̠ ra̠lebh d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","E̠no̠gho̠man ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st e̠ro̠ na̠ eb̠la̠ inyin.");
INSERT INTO mgj_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","A̠lebh onon ad̠u̠a d̠a̠ agu̠o̠ d̠ami̠ Apo̠l, o̠ni̠ogir ta̠ Akrai̠st A̠zizo̠s a̠ru, d̠a̠ i̠to̠ ta̠ A̠zib̠a̠ Witenemeni d̠i̠yar, na̠ Akrai̠st A̠zizo̠s wa̠ eb̠em ologi d̠i̠yar bho̠, ");
INSERT INTO mgj_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","ma̠ onigha̠ oyom A̠timoti, a̠ga̠i o̠nyi̠ d̠ami̠ d̠a̠ ologi ima̠ra̠ bho̠. E̠ne̠ghe̠, okpon igbirigbir, na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ Akrai̠st A̠zizo̠s Wa̠nwuna̠ i̠yar bho̠ e̠ro̠ na̠ anwa. ");
INSERT INTO mgj_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Agu̠o̠ ami̠ akpo̠me̠ni̠ ma̠ ologi d̠oyom ma̠ o̠ro̠ d̠a̠ E̠fi̠so̠s, igiel bho̠ ami̠ na̠ a̠ten na̠ agi̠ d̠a̠ Ame̠sidonia̠ bho̠, ma̠ agu̠o̠ ola̠ anwa ta̠ aghaghana ma̠ ogbo ya̠ na̠ e̠tu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠ igunugha̠ bho̠ ma̠ o̠we̠le̠man ogir o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Gba ma̠a̠, awa e̠we̠le̠man rasu̠gbagba ezin o̠to̠ na̠ id̠udul ibom ro̠we̠de̠ d̠awa ya̠ ekunuguma̠ o̠ro̠d̠o̠ bho̠, ya̠ na̠ emutiom raku̠anan ku̠ku̠m, ya̠ o̠lo̠gh d̠o̠ ma̠ agu̠o̠ enigha̠ ma̠ a̠nwunom ma̠ orugh a̠ghud̠um ologi ima̠ra̠ ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Ezin abar wa̠ u̠tu̠n u̠to̠ ma̠ i̠to̠ i̠nye̠n bho̠ bha̠, od̠ighi agu̠o̠ ola̠ odi ta̠ a̠bhin d̠a̠ ologi e̠b̠ab̠ala, na̠ ob̠eb̠i eloghoma̠n, na̠ a̠ga̠i ologi ima̠ra̠ a̠tula̠n odi. ");
INSERT INTO mgj_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Idi ogbo na̠ e̠baro̠n e̠d̠u̠a d̠a̠ od̠ighi i̠di̠ar i̠nye̠n e̠gi̠ ka̠ ed̠igh d̠a̠ ibhelebhel a̠fugh. ");
INSERT INTO mgj_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Awa na̠ e̠bho̠ro̠gh oten i̠tu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠ oloko bho̠, ya̠a̠ i̠mu̠gho̠nyan d̠o̠ ma̠ iya̠ awa na̠ efugh, na̠ ezin asu̠gbagba ya̠ awa na̠ ebhin alu̠kpo̠ ologi na̠ e̠gba bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","I̠yar ologhom ma̠a̠ oloko bho̠ a̠bhon, ku̠gba ma̠a̠ orughom agu̠o̠ a̠soran bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","I̠yar ologhom nyen ma̠a̠, udin d̠o̠ ma̠ a̠nwunom ya̠ na̠ erugh ya̠ igielake̠ omutiom oloko bho̠, ya̠a̠ udin isorogi ma̠ ro̠kpe̠, na̠ iwia̠n ma̠ ra̠dila̠de irileghom, na̠ ighel ma̠ A̠zib̠a̠, na̠ idighi ma̠ i̠karabh, na̠ ogbo ya̠ na̠ erugh ado̠l i̠te̠i̠, na̠ ogbo ya̠ orugh d̠o̠ ma̠ ado̠l igielake̠, na̠ ogbo ya̠ abar ola̠ ima̠ra̠ o̠ro̠d̠o̠, na̠ i̠ze̠ ma̠ ronweni na̠ ro̠we̠de̠, na̠ i̠ze̠ ma̠ a̠nwunom, ");
INSERT INTO mgj_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","na̠ id̠eme̠ma, na̠ ilobhiri ya̠ na̠ ekod̠uom ilobhiri, na̠ anwani̠ ya̠ na̠ ekod̠uom anwani̠, na̠ ib̠ua̠ ma̠ a̠nwunom, na̠ i̠gba ma̠ igunugha̠, na̠ ronyob̠a̠ igunugha̠, na̠ ogbo ya̠ na̠ ewia̠n a̠ga̠i atu̠ghu̠me̠ni̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","ya̠ i̠d̠u̠a d̠a̠ ib̠eb̠i asu̠gbagba ya̠ igboloma̠ ma̠ isosorogia̠n ta̠ A̠zib̠a̠ Itutumeni iru, sa̠ i̠na a̠b̠eton alo̠gh d̠a̠ agu̠o̠ d̠ami̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Ami̠ na̠ ase̠bh Akrai̠st A̠zizo̠s Wa̠nwuna̠ d̠i̠yar, wa̠ abi̠gh ma̠ ami̠ akpe̠ sa̠ aso̠n ami̠ a̠d̠ighom d̠a̠ ogir o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","D̠a̠ obhel ola̠ na̠ a̠ten, ami̠ ifugh gha̠n a̠fugh i̠basi̠ a̠gboloma̠ i̠na, sa̠ ami̠ igbikimeni ma̠ a̠nwunom d̠o̠yo̠, sa̠ ami̠ i̠ki̠ri̠ i̠na. Ku̠ku̠m eka̠, A̠zib̠a̠ a̠kpon ami̠ ma̠ igbirigbir agu̠o̠ ami̠ ologhom d̠o̠ ma̠a̠ ami̠ na̠ a̠gir i̠karabh bho̠, ezin bho̠ ami̠ ima̠ra̠ d̠o̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Sa̠ Wa̠nwuna̠ d̠i̠yar a̠bhin d̠a̠ e̠ne̠ghe̠ d̠o̠yo̠ a̠nigha̠ ami̠ ma̠ ologi ima̠ra̠ na̠ etula̠n, ya̠ i̠wo̠l d̠a̠ Akrai̠st A̠zizo̠s iru bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Onon a̠ga̠i o̠nu̠o̠kpe̠ ola̠ akpe̠ ma̠ a̠nwunom o̠da obhin, ma̠a̠: “Akrai̠st A̠zizo̠s a̠ru ma̠ i̠se̠n e̠mara̠nwunom bho̠ ma̠ otenemeni id̠ighi ma̠ i̠karabh.” Sa̠ ami̠ i̠ro̠ ma̠ od̠ighi ma̠ i̠karabh wa̠ igurom ipu bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Ya̠a̠ A̠zib̠a̠ a̠kpon ami̠ ma̠ igbirigbir ma̠ agu̠o̠ ola̠ Akrai̠st A̠zizo̠s ta̠ a̠rughom ami̠ a̠guri ma̠ agu̠o̠ elegh a̠ma̠ne d̠o̠yo̠, eb̠la̠ agu̠o̠ ami̠ i̠ro̠ ma̠ od̠ighi ma̠ i̠karabh wa̠ a̠gurom a̠pu bho̠ eka̠. Obha̠ na̠ a̠leriom agu̠o̠ i̠di̠ar ta̠ e̠ro̠ egboloma̠ ma̠ ogbo ya̠, d̠a̠ o̠gu̠man, sa̠ ta̠ ema̠ra̠ i̠na, sa̠ ta̠ e̠te̠i̠ a̠ghud̠um kid̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","I̠se̠n bha̠, edim na̠ isosorogia̠n e̠ro̠ enigha̠ ma̠ O̠li̠le̠ma wa̠ ka̠ kid̠ud̠ul bho̠, wa̠ omugh d̠o̠ bho̠, wa̠ o̠bi̠gh d̠o̠ ma̠ a̠d̠ien bho̠, wa̠ i̠na ku̠ku̠m aro̠ ma̠ A̠zib̠a̠ ga̠i bho̠, tu̠tu̠n kid̠ud̠ul. Aro̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","O̠nyi̠ d̠ami̠ A̠timoti, ami̠ na̠ ato̠ ma̠ i̠to̠ i̠nye̠n na̠ a̠nigha̠ nyam ma̠ omuzoghod̠iom iwowa̠ ya̠ uwa̠ ugboloma̠ nyam d̠a̠ obhel ola̠ na̠ a̠ten bho̠, bo̠ka̠ igiel anwa i̠ru̠ru̠an, anwa amar a̠we ma̠ e̠gham bho̠. ");
INSERT INTO mgj_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Sibhe ma̠ eloghoma̠n d̠oyom ma̠ akparame̠ni̠, ma̠ a̠nwuna̠ ma̠ ologi e̠b̠ab̠ala. Idi ogbo ighel i̠ye̠, sa̠ i̠we̠le̠man o̠nagha iya̠ ologi na̠ agba. Ebula̠ o̠ku̠a, sa̠ i̠pi̠e̠ ma̠ ologi ima̠ra̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Ahi̠me̠ni̠o̠s na̠ Ale̠kzanda bha̠ idi ogbo ya̠ na̠ egir o̠ku̠a d̠a̠ esa̠d̠io d̠inyin. Ami̠ na̠ a̠b̠eton awa alo̠gh d̠a̠ agu̠o̠ ta̠ Eru bho̠ ma̠ ogbikimeni, b̠o̠ka̠ awa e̠we̠le̠man a̠fugh i̠basi̠ ogboloma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","O̠pu̠r abar bho̠, ami̠ na̠ a̠kikiom inyin ma̠a̠, ipuru ma̠ i̠d̠i̠ar ya̠ inyin na̠ o̠bho̠ro̠gh bho̠, ma̠ esiseiny, ma̠ e̠mara ma̠ eni, ma̠ e̠se̠bh A̠zib̠a̠ ma̠ egboloma̠ ko̠ni̠ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Isiseinye ma̠ enigha̠ ma̠ Aru̠li̠le̠ma na̠ ipa̠n ogbo ya̠ od̠i d̠a̠ a̠dila̠de i̠to̠, b̠o̠ka̠ i̠yar orugh a̠ghud̠um eb̠okum na̠ ekima̠, na̠ oghila̠n A̠zib̠a̠, na̠ orugh a̠ghud̠um edim. ");
INSERT INTO mgj_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Osiseiny o̠ko̠no̠n a̠bhon, sa̠ a̠d̠igh ologi ma̠ A̠zib̠a̠ Witenemeni d̠i̠yar, ");
INSERT INTO mgj_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","wa̠ na̠ abho̠ro̠gh ko̠ni̠ko̠ni̠ ma̠ oten na̠ ologhom a̠ga̠i a̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Ezin bho̠ onin A̠zib̠a̠ na̠ onin o̠mara ma̠ enie ku̠ku̠m od̠i d̠a̠ esa̠d̠io a̠nwunom na̠ A̠zib̠a̠. I̠na Akrai̠st A̠zizo̠s, ");
INSERT INTO mgj_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","wa̠ a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ obhin o̠ta eb̠la̠ a̠nwunom, sa̠ aro̠ ma̠ elegh ola̠ umutiom d̠a̠ obhel wa̠ u̠to̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Obha̠ ezin bho̠ u̠so̠n ami̠ ma̠ o̠ro̠ o̠ni̠-ogir na̠ o̠ni̠ atu̠ghu̠me̠ni̠ ola̠ o̠tu̠ghu̠me̠ni̠ o̠nu̠o̠kpe̠ ima̠ra̠ ologi na̠ a̠ga̠i onigha̠ Ibhebhia̠n bho̠. Ami̠ na̠ agba ma̠ ya̠gia̠ga̠i, igunugha̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Ami̠ na̠ abho̠ro̠gh agu̠o̠ ola̠ kesi kesi ilobhiri a̠nwunom na̠ esiseiny a̠siseiny, awa eb̠egion aru̠gu̠o̠ e̠b̠ab̠ala e̠gi̠o̠m anyu̠, aro̠ ma̠ ola̠ awa ko ogurumia̠n d̠o̠ ma̠ rologi, bo̠d̠o̠ ko o̠ku̠anan d̠o̠ ma̠ aku̠anan. ");
INSERT INTO mgj_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Ami̠ na̠ abho̠ro̠gh nyen agu̠o̠ ola̠ anwani̠ ta̠ e̠mar ebura̠ ma̠ ibura̠ ya̠ awa ta̠ ed̠igh edim o̠bi̠gh. Awa oguri d̠o̠ ma̠ asi̠ghal d̠awa ma̠ ya̠ ipe ya̠ osorogi adi̠e̠l, bo̠d̠o̠ o̠ke̠le̠gi̠an a̠goli, na̠ i̠ge̠, na̠ i̠ku̠ta, na̠ i̠b̠o̠lo̠, ya̠ ubhin a̠gol bo̠d̠o̠ i̠di̠ar ya̠ na̠ e̠mu̠ u̠le̠m, ya̠ ibom a̠b̠ua̠. ");
INSERT INTO mgj_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Kpe̠le̠me̠ni̠, bha̠ e̠ro̠ ma̠ anwani̠ ya̠ na̠ egir ib̠eb̠i ya̠ izuzua̠n i̠re̠ma agu̠o̠ awa na̠ obuom A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Ani̠ebhom aro̠ b̠o̠b̠o̠m atu̠ghan d̠a̠ o̠ki̠ri̠me̠ni̠ ozu. ");
INSERT INTO mgj_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Ami̠ i̠bho̠ro̠gh d̠o̠ ma̠ agu̠o̠ ola̠ ani̠ebhom ta̠ atu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠, bo̠d̠o̠ ta̠ aragha ma̠ a̠limon a̠rileghom olobhiri o̠ni̠, ya̠a̠ aro̠ b̠o̠b̠o̠m. ");
INSERT INTO mgj_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Iloghome ma̠a̠, A̠zib̠a̠ a̠d̠ia̠ ale̠m Adam kisa̠ ale̠m Ivu. ");
INSERT INTO mgj_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Adam d̠o̠ ma̠ o̠ni̠ wa̠ ugelemeni bho̠, ya̠a̠ ani̠ebhom bho̠, sa̠ i̠na a̠gir i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Aro̠ ku ma̠ o̠ku̠a eka̠, i̠na ta̠ a̠ten d̠a̠ i̠mara, ku̠gba ma̠a̠ i̠na a̠bhin ologi ima̠ra̠, na̠ etula̠n, na̠ onyen ologi d̠o̠yo̠ d̠a̠ A̠zib̠a̠ agi̠o̠m d̠a̠ ed̠ia̠, d̠a̠ osibhom ozu. ");
INSERT INTO mgj_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Onon a̠kikiom ola̠ a̠d̠igh esi, ma̠a̠: O̠ni̠ ola̠ na̠ ebhir oten o̠ni̠ irileghom aso̠si̠, bha̠ na̠ abho̠ro̠gh ob̠eb̠i ogir. ");
INSERT INTO mgj_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","O̠ku̠a a̠d̠ighi be̠le̠ni̠, e̠kal ali̠o̠m o̠ro̠ d̠o̠ ma̠ o̠ni̠ irileghom, a̠bhin onin ani̠, a̠kimeni ma̠ ozu, ato̠to̠gi̠o̠m a̠ma̠rugh, ologhom abar, a̠d̠igh edim, ada ma̠ isuloma̠ a̠bhin na̠ onyen ologi, atu̠ghu̠me̠ni̠ na̠ e̠mar, ");
INSERT INTO mgj_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","o̠ro̠ d̠o̠ ma̠ o̠d̠amin, oponoma̠ d̠o̠ ma̠ o̠ni̠, kpe̠le̠me̠ni̠ aro̠ ma̠ okima̠kima̠ o̠ni̠, o̠ni̠ ola̠ o̠b̠e̠m d̠o̠, o̠ro̠ d̠o̠ ma̠ ola̠ e̠d̠o̠gh okpoki. ");
INSERT INTO mgj_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","I̠na aro̠ ma̠ o̠ni̠ ola̠ na̠ amar na̠ a̠rileghom eghun otu d̠o̠yo̠, sa̠ na̠ a̠d̠ighi ma̠ agu̠o̠ ola̠ anwi̠i̠ny d̠o̠yo̠ na̠ e̠nagha ma̠ o̠nu̠o̠kpe̠, sa̠ na̠ erugh a̠ma̠rugh ozuruna̠ eghoi. ");
INSERT INTO mgj_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Ya̠a̠, ku̠gba ma̠a̠ o̠ni̠ na̠ orue d̠o̠ ma̠ orileghom eghun otu d̠o̠yo̠, ka̠ i̠na ta̠ a̠d̠ighi eka̠ a̠loghom agu̠o̠ okponom aso̠si̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","I̠na o̠ro̠ d̠o̠ ma̠ ororua̠ o̠ni̠-i̠tu̠o̠no̠m ta̠ Akrai̠st, b̠o̠ka̠ i̠na na̠ o̠bu̠ghu̠me̠ni̠ ma̠ ozu a̠mel onin emel wa̠ udin usobh ase̠ ubhumeni ma̠ Eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Ob̠eb̠i a̠ma̠rugh d̠o̠yo̠ agba i̠na a̠leriom a̠nwunom ya̠ o̠gi̠ d̠o̠ ma̠ aso̠si̠, b̠o̠ka̠ i̠na na̠ omel a̠d̠igh ari̠ghe̠l, sekina̠ osor e̠te̠ i̠kpati̠ ta̠ eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Onin agu̠o̠ bho̠ ogbo i̠to̠to̠gi̠ d̠a̠ aso̠si̠, e̠ro̠ ma̠ a̠nwunom ya̠ na̠ erugh ado̠l ya̠ a̠nwunom ta̠ ezuruna̠ ma̠ eghoi enigha̠. Awa o̠ro̠ d̠o̠ ma̠ ogbo igelemeni, bo̠d̠o̠ ro̠d̠a ma̠ a̠min, bo̠d̠o̠ ogbo ya̠ na̠ e̠bho̠ro̠gh o̠te̠i̠ i̠karabh asu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Awa ebhin e̠b̠ab̠ala eloghoma̠n esibhom ima̠ra̠ ologi ilologia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","O̠d̠a okpon a̠nwunom ya̠ o̠ku̠a, kisa̠ e̠ro̠ ma̠ ogbo i̠to̠to̠gi̠ aso̠si̠ ku̠gba ma̠ e̠kal ola̠ o̠li̠o̠m bo̠. ");
INSERT INTO mgj_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Anwani̠ d̠awa eka̠ erugh ado̠l ya̠ i̠kpe̠ ma̠ iya̠ ta̠ ozuruna̠ ma̠ eghoi, ogbo i̠me̠ghe̠nyan d̠o̠. Awa e̠ro̠ ma̠ ogbo ya̠ na̠ ekimeni ma̠ a̠ruzu, sa̠ na̠ ebhin d̠a̠ igielake̠ na̠ egir kabar kabar. ");
INSERT INTO mgj_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","O̠ni̠ i̠to̠to̠gi̠ d̠a̠ aso̠si̠ a̠nwuna̠ ma̠ onin ani̠, aro̠ ma̠ o̠ni̠ ola̠ na̠ amar na̠ erileghom anwi̠i̠ny d̠o̠yo̠, na̠ otu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","A̠nwunom ta̠ ezuruna̠ ma̠ eghoi enigha̠ ma̠ ogbo i̠to̠to̠gi̠ d̠a̠ aso̠si̠ ya̠ na̠ e̠mar na̠ egir ogir d̠awa. Sa̠ awa ta̠ enwuna̠ ma̠ obom alu̠kpo̠ ologi d̠a̠ ima̠ra̠ ologi d̠a̠ awa d̠a̠ Akrai̠st A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Agu̠o̠ ami̠ na̠ age̠ ma̠ a̠lebh onon na̠ a̠ruom anwa bho̠, bha̠ na̠ ebhir ami̠ ma̠ o̠nu̠r oru ra̠ ozua̠n oyom. ");
INSERT INTO mgj_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Ya̠a̠, ka̠ ami̠ ibia̠ ma̠ oru, agu̠o̠ ola̠ anwa ta̠ a̠loghom agu̠o̠ a̠nwunom i̠kpe̠ ma̠ orugh d̠a̠ otu ta̠ A̠zib̠a̠, wa̠ aro̠ ma̠ aso̠si̠ ta̠ A̠zib̠a̠ ga̠i bho̠, wa̠ od̠i d̠a̠ a̠ghud̠um bho̠, wa̠ aro̠ ma̠ e̠ko̠ na̠ o̠de̠ a̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Ya̠gia̠ga̠i, o̠nu̠o̠kpe̠ wa̠ A̠zib̠a̠ a̠mutiom a̠leriom i̠yar bho̠ obom ilologia̠n: Akrai̠st a̠ru d̠a̠ ipulupul ozu, sa̠ E̠mu̠gh E̠tu̠tu̠ bho̠ agba a̠mutiom ma̠a̠, i̠na amar a̠rugh d̠a̠ a̠misigh ta̠ A̠zib̠a̠, sa̠ itileduom ta̠ A̠zib̠a̠ i̠bi̠gh i̠na, sa̠ u̠gba i̠na umutiom d̠a̠ esa̠d̠io a̠nwunom, sa̠ a̠nwunom e̠mara̠nwunom bho̠ ima̠ra̠ i̠na, sa̠ ukpobh i̠na ubhuneni d̠a̠ ote̠nai̠ny d̠a̠ isosorogia̠n. ");
INSERT INTO mgj_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","E̠mu̠gh E̠tu̠tu̠ bho̠ amar agba a̠mutiom ma̠a̠, d̠a̠ rekunuguma̠ a̠d̠a̠ma̠ bho̠, idi a̠nwunom ta̠ etiba̠ra̠ e̠d̠u̠a d̠a̠ ologi ima̠ra̠ bho̠, sa̠ ta̠ e̠nagha ma̠ aru̠mu̠gh igunugha̠ na̠ i̠tu̠ghu̠me̠ni̠ a̠ruru. ");
INSERT INTO mgj_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Wa̠ ibhelebhel i̠gbamigunugha̠ na̠ a̠d̠ighi ma̠ ola̠ eloghoma̠n bho̠ na̠ asa ma̠ ari̠ghe̠l awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Awa ibhin ma̠ o̠walan ilom bha̠ e̠tu̠tu̠, sa̠ na̠ edin od̠e idi ra̠d̠ien ya̠ A̠zib̠a̠ ale̠m agu̠o̠ ola̠ a̠nwunom ogbo ya̠ ima̠ra̠ bho̠ ta̠ e̠da ebhin na̠ ali̠se̠bh sa̠ ta̠ eleriom ya̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Kabar kabar A̠zib̠a̠ ale̠m, o̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠yar oghel d̠o̠ ma̠ odi abar i̠se̠, ya̠a̠ o̠da obhi̠n na̠ ali̠se̠bh. ");
INSERT INTO mgj_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Ezin bho̠, o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ na̠ a̠siseiny na̠ e̠b̠ab̠alame̠ni̠ ma̠ ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ku̠gba ma̠a̠ anwa a̠tu̠ghu̠me̠ni̠ ma̠ i̠di̠ar i̠nye̠n ma̠ a̠rumor na̠ aru̠marani̠, bha̠ anwa oten ob̠eb̠i ob̠a̠ra̠motu ta̠ Akrai̠st A̠zizo̠s, o̠ni̠ ola̠ o̠nu̠o̠kpe̠ ologi ima̠ra̠ bho̠, na̠ ib̠eb̠i i̠tu̠ghu̠me̠ni̠ ya̠ anwa ibhin onyen ologi i̠nagha bho̠, imuzo d̠a̠ ozu. ");
INSERT INTO mgj_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Ya̠a̠, ko onwuna̠ ma̠ abar a̠gboloma̠ ma̠ i̠karabh asu̠gbagba na̠ id̠ud̠ul ya̠ emirobh. Kpe̠le̠me̠ni̠ tu̠ghane̠ ma̠ orugh a̠ghud̠um ola̠ ta̠ a̠nigha̠ ma̠ A̠zib̠a̠ ma̠ itutumeni. ");
INSERT INTO mgj_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Oselegi ma̠ ozu d̠a̠ i̠di̠ar ya̠ ta̠ e̠lo̠gh agu̠o̠, ya̠a̠ orugh a̠ma̠rugh oghila̠n A̠zib̠a̠ d̠a̠ eb̠la̠ re̠kal ya̠ ta̠ e̠lo̠gh agu̠o̠. Isibhe ma̠ ogua̠n i̠se̠n oghud̠um onon na̠ wa̠ na̠ a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Onon a̠ga̠i atu̠ghu̠me̠ni̠ ola̠ akpe̠ ko̠ni̠ko̠ni̠ ma̠ o̠mar o̠da obhin. ");
INSERT INTO mgj_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Ebula̠ o̠ku̠a sa̠ i̠yar na̠ owia̠n na̠ ogir ibom, ezin bho̠ i̠yar na̠ obhin A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠ na̠ ob̠em ologi, i̠na bha̠ Witenemeni eb̠la̠ a̠nwunom bho̠, okunukun ogbo ya̠ ima̠ra̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Kparame̠ni̠ ma̠ agba ma̠ i̠di̠ar i̠nye̠n a̠nigha̠ awa, ma̠ atu̠ghu̠me̠ni̠ awa nyen. ");
INSERT INTO mgj_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Ko oma̠ra̠ ka̠ o̠ni̠ ta̠ a̠din agu̠o̠ anwa i̠ro̠ ma̠ okubh o̠ni̠ bho̠ a̠kpon anwa aki̠ri̠me̠ni̠. Ya̠a̠, rughe ma̠ ado̠l ya̠ ipa̠n ogbo ima̠ra̠ bho̠ ta̠ e̠ta, d̠a̠ a̠fugh o̠nu̠ na̠ od̠ighi i̠di̠ar d̠oyom, d̠a̠ etula̠n d̠oyom, d̠a̠ ologi ima̠ra̠ d̠oyom, na̠ d̠a̠ e̠b̠ab̠ala ologi d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Kisa̠ ami̠ ta̠ a̠ru, bha̠ bhine gha̠n ma̠ obhel a̠sen A̠d̠ire E̠tu̠tu̠ bho̠ d̠a̠ a̠kokod̠ia̠n, kikiome, ma̠ atu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Ko oghel enigha̠ e̠mu̠gh wa̠ od̠i na̠ anwa bho̠, wa̠ unigha̠ nyam igiel bho̠ ikei bho̠ i̠gbamagi̠ ma̠ aru̠gu̠o̠ d̠awa d̠a̠ ozu d̠oyom, iwa̠ igboloma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Ru̠ru̠ane̠ ma̠ a̠gboloma̠ ma̠ i̠di̠ar i̠nye̠n, bo̠ka̠ eloloma̠ ogir d̠oyom emite ma̠ ola̠ ko̠ni̠ko̠ni̠ ta̠ abi̠gh ");
INSERT INTO mgj_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Mare̠ ma̠ a̠kpona̠ ma̠ od̠ighi i̠d̠i̠ar d̠oyom na̠ atu̠ghu̠me̠ni̠ d̠oyom. Ro̠ ma̠ ogir ogir i̠di̠ar i̠nye̠n, ezin bho̠, ka̠ anwa igir o̠ku̠a sa̠ anwa ta̠ a̠tenemeni ma̠ ozu d̠oyom na̠ a̠nwunom ya̠ na̠ e̠nagha nyam bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ko obhin i̠gam a̠kikiom ikei o̠ni̠, kpe̠le̠me̠ni̠ kpo̠me̠ni̠ ma̠ ologi d̠o̠yo̠ ma̠ agu̠o̠ o̠we̠de̠. Kikiome ma̠ ikubh-anwi̠i̠ny agu̠o̠ a̠rumor. ");
INSERT INTO mgj_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Rugha̠ne ma̠ ikei a̠nwunom anwani̠ ma̠ agu̠o̠ ronweni, ikubh-anwi̠nyan ma̠ agu̠o̠ aru̠marani̠, d̠a̠ e̠b̠ab̠ala ma̠ agu̠o̠ ola̠ anwa ko o̠pi̠o̠gho̠m d̠o̠ awa d̠a̠ eb̠la̠ re̠kal. ");
INSERT INTO mgj_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Lo̠ghe̠ ma̠ agu̠o̠ ma̠ a̠nigha̠ ma̠ rekpukele anwani̠ ya̠ i̠ro̠ ma̠ rekpukele anwani̠ ga̠i. ");
INSERT INTO mgj_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Ya̠a̠, ku̠gba ma̠a̠ ekpukele ani̠ a̠nwuna̠ ma̠ anwi̠i̠ny bo̠d̠o̠ anwi̠i̠ny igha̠la̠, bha̠ awa ekponom i̠na, ezin bho̠ i̠na na̠ a̠d̠ia̠ a̠kponom awa, sa̠ ogir o̠ku̠a a̠bhon d̠a̠ a̠misigh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Ya̠a̠, ekpukele ani̠ ola̠ aro̠ ma̠ ekpukele ani̠ ga̠i, ya̠ onwuna̠ d̠o̠ ma̠ o̠ni̠ o̠lo̠gh agu̠o̠, bha̠ na̠ a̠bhin A̠zib̠a̠ na̠ a̠b̠em ologi, sa̠ na̠ a̠bhin d̠a̠ a̠ma̠ne na̠ aro̠ ma̠ a̠siseiny a̠siseiny a̠d̠uga̠la̠n na̠ etita̠n, na̠ a̠puru i̠na ma̠ o̠lo̠gh agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Ya̠a̠, ekpukele ani̠ ola̠ a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ e̠me̠me̠m e̠mara̠nwunom onon, bha̠ na̠ a̠mugh, aro̠ ku ma̠ i̠na od̠id̠ia̠ d̠a̠ a̠ghud̠um eka̠. ");
INSERT INTO mgj_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Kikiome awa ma̠ ra̠kikiom i̠nye̠n b̠o̠ka̠ u̠bi̠gh abar e̠kal obhin o̠li̠o̠m awa. ");
INSERT INTO mgj_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ya̠a̠, o̠ni̠ ola̠ orue d̠o̠ ma̠ okponom ogbo a̠ghisia̠n d̠o̠yo̠, okunukun a̠nwunom eghunotu d̠o̠yo̠, bha̠ o̠ni̠ bho̠ na̠ aku̠a ma̠ ima̠ra̠ ologi bho̠ sa̠ a̠gurom a̠pu ma̠ o̠ni̠ ola̠ oma̠ra̠ d̠o̠ ma̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Ko o̠ge̠ ma̠ a̠d̠ien ekpukele ani̠ ma̠ alo̠gh d̠a̠ a̠d̠ire rekpukele anwani̠ bho̠, a̠ten ola̠ o̠nu̠ ala bho̠ na̠ epel e̠rabharabh (60), ola̠ awal owolom d̠o̠yo̠ ku̠ku̠m, sa̠ od̠e d̠o̠ ma̠ e̠ma. ");
INSERT INTO mgj_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","I̠na aro̠ ma̠ ani̠ ola̠ a̠d̠igh edim d̠a̠ a̠misigh eb̠la̠ ogbo sa̠ u̠gba ma̠ ib̠eb̠i ogir d̠o̠yo̠, sa̠ amar a̠rughom anwi̠i̠ny d̠o̠yo̠, sa̠ a̠nwuna̠ ma̠ onyen ologi ola̠ o̠ki̠o̠gho̠m risuloma̠, na̠ otitologh a̠sike a̠nwunom ta̠ A̠zib̠a̠, sa̠ alo̠gh gha̠n agu̠o̠ a̠nigha̠ ma̠ ogbo ya̠ od̠i d̠a̠ i̠kparama ado̠l, sa̠ a̠nwuna̠ ma̠ obhel a̠nigha̠ ma̠ a̠d̠ien kere kere ogir ib̠eb̠i. ");
INSERT INTO mgj_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Ko o̠lo̠gh a̠rid̠ien rekpukele anwani̠ ya̠ od̠id̠ia̠ ma̠ ikubh, i̠kparakpar rebhiroma̠ ozu d̠awa ta̠ epel iya̠ awa inwuna̠ igboloma̠ ma̠ Akrai̠st bho̠, sa̠ ta̠ e̠bho̠ro̠gh omula̠ o̠wal ilom, ");
INSERT INTO mgj_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","sa̠ awa ta̠ e̠te̠i̠ ebhum ase̠ ma̠ agu̠o̠ awa osibh d̠o̠ ma̠ o̠pu̠r ogua̠n awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","D̠a̠ onin obhel bho̠, awa ta̠ eten i̠gbu̠o̠ro̠gbu̠o̠r, sa̠ ta̠ erugh rado̠l ya̠ o̠d̠u̠a otu oten otu. Ka̠ o̠ro̠ d̠o̠ ma̠ i̠gbu̠o̠ro̠gbu̠o̠r ku̠ku̠m, ya̠a̠ ta̠ eten ogbo i̠me̠ghe̠nyan, na̠ ra̠d̠ikelekpum, efughogh i̠di̠ar ya̠ o̠kpe̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Oku̠a a̠d̠ighi be̠le̠ni̠, ami̠ na̠ a̠kikiom agu̠o̠ ola̠ ikubh rekpukele anwani̠ ta̠ emula̠ e̠wal ilom, e̠maragi̠ ma̠ anwi̠i̠ny, ekponom a̠rutu d̠awa. Sa̠ o̠ni̠ o̠lo̠gi̠an a̠d̠ien bho̠ ko onwuna̠ d̠o̠ ma̠ ezin ola̠ odin ofugh i̠karabh ogboloma̠ awa. ");
INSERT INTO mgj_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","I̠bi̠ghe̠ ma̠ i̠se̠n d̠a̠ idi awa na̠ e̠baro̠n e̠d̠u̠a na̠ e̠tu̠o̠no̠m Eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Ku̠gba ma̠a̠, ani̠ ola̠ na̠ a̠ma̠ra̠ ma̠ Akrai̠st a̠nwuna̠ ma̠ ogbo a̠ghisia̠n ya̠ i̠ro̠ ma̠ rekpukele anwani̠, bha̠ i̠na alo̠gh agu̠o̠ a̠kponom awa. O̠we̠le̠man d̠o̠ ma̠ a̠dol bho̠ a̠nigha̠ ma̠ aso̠si̠ bho̠ ku̠ku̠m, b̠o̠ka̠ aso̠si̠ bho̠ ekponom a̠ga̠i rekpukele anwani̠ ya̠ i̠kpe̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Ikei ya̠ na̠ e̠mar na̠ erileghom aso̠si̠ bho̠ e̠kpe̠ ma̠ o̠te̠i̠ asu̠wo̠ i̠wal a̠bin, okunukun ogbo ya̠ na̠ e̠kparame̠ni̠ na̠ e̠gba ma̠ Ib̠eb̠i Asu̠gbagba bho̠ na̠ e̠sasaragi̠, sekina̠ ogbo ya̠ na̠ e̠tu̠ghu̠me̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Ezin bho̠, A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠a̠, “Ko o̠gho̠ro̠gi̠ ma̠ a̠kpegi ma̠ o̠nu̠ e̠nam ogir bho̠ ma̠ igiel i̠na na̠ aze̠re̠gi̠ na̠ akagi̠o̠n ikpo ed̠ia̠n bho̠.” Opa̠n esi eka̠ sa̠ agba ma̠a̠, “O̠ni̠ ogir akpe̠ ma̠ o̠te̠i̠ asu̠wo̠ ogir d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Ko o̠nagha ma̠ iku ola̠ uler ugboloma̠ ma̠ okei-o̠ni̠, a̠ten ka̠ i̠wal o̠ni̠ bo̠d̠o̠ i̠sar o̠ni̠ iru ra̠ i̠gba ma̠ onyob̠a̠ onin o̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Ya̠a̠, game̠ ma̠ a̠nigha̠ ma̠ ogbo ya̠ na̠ egir i̠karabh bho̠ d̠a̠ a̠misigh eb̠la̠ ogbo, bo̠ka̠ a̠d̠igh a̠rugugu a̠nigha̠ ma̠ ipa̠n ogbo. ");
INSERT INTO mgj_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Ami̠ na̠ a̠bhin o̠kparakpar okoroko na̠ a̠kikiom anwa d̠a̠ a̠misigh ta̠ A̠zib̠a̠, na̠ Akrai̠st A̠zizo̠s, na̠ itileduom ta̠ A̠zib̠a̠ ya̠ i̠na na̠ aso̠n bho̠, ma̠ agu̠o̠ ola̠ anwa ta̠ a̠bhin d̠a̠ igielake̠ atu̠o̠no̠m i̠to̠to̠gi̠ i̠nye̠n, ya̠a̠ o̠ro̠ d̠o̠ ma̠ ola̠ anwa ta̠ abhe̠l odi a̠kpon odi a̠gurumeni. ");
INSERT INTO mgj_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Ko onugia̠n o̠gbamagi̠ aru̠gu̠o̠ d̠a̠ a̠ruzu a̠nwunom d̠a̠ o̠so̠n ogbo a̠dila̠de, b̠o̠ka̠ anwa na̠ od̠igh aru̠gi̠an i̠karabh ipa̠n ogbo. Ya̠a̠, rughe ma̠ ado̠l d̠oyom a̠guri d̠a̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Ko o̠d̠a ma̠ amu̠m ku̠ku̠m, ya̠a̠, d̠a̠ ma̠ i̠ki̠kara a̠min d̠a̠ ebula̠ okurogh d̠oyom, na̠ rasu̠nwe̠r ya̠ na̠ e̠d̠u̠a ma̠ obhel na̠ eten obhel na̠ e̠nwe̠re̠me̠ni̠ nyam bho̠. ");
INSERT INTO mgj_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","I̠karabh idi ogbo od̠i ma̠ iya̠ na̠ ologhom na̠ o̠bi̠gh geregere, sa̠ na̠ ebhin awa ka̠ ed̠ighom d̠a̠ ebhum ase̠. Ya̠a̠, i̠karabh idi ogbo na̠ e̠tu̠o̠no̠m awa d̠a̠ aman. ");
INSERT INTO mgj_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Onin agu̠o̠ bho̠, ib̠eb̠i ogir na̠ e̠ro̠ geregere. Ya̠a̠, ib̠eb̠i ogir ya̠ od̠i d̠a̠ e̠wo̠gi̠na bho̠ eka̠, ko orue d̠o̠ o̠wo̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Ogbo ya̠ od̠i ma̠ aru̠bana eloghom ma̠a̠ akpe̠ awa ma̠ ozuruna̠ eghoi onigha̠ ogbo ya̠ inwuna̠ awa bho̠. O̠ku̠a ta̠ a̠d̠ighi ma̠ ola̠ a̠nwunom ko ofugh d̠o̠ ma̠ a̠fugh i̠basi̠ egboloma̠ ma̠ a̠d̠ien ta̠ A̠zib̠a̠ na̠ atu̠ghu̠me̠ni̠ d̠i̠yar. ");
INSERT INTO mgj_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Aru̠bana ya̠ ogbo ya̠ inwuna̠ awa bho̠ i̠ro̠ ma̠ a̠nwunom d̠a̠ onin ima̠ra̠ ologi bho̠, okpon d̠o̠ awa e̠ki̠ri̠me̠ni̠, ezin bho̠ awa a̠rumor na̠ aru̠marani̠ d̠awa. Kpe̠le̠me̠ni̠ bha̠ awa egir epeleni enigha̠ awa, ezin bho̠ ogbo ya̠ na̠ e̠te̠i̠ asu̠wo̠ ogir d̠awa bho̠ bha̠ ogbo etula̠n ya̠ od̠i d̠a̠ onin ima̠ra̠ ologi bho̠. Tu̠ghu̠me̠ni̠ awa ma̠ i̠di̠ar i̠nye̠n ma̠ akpo̠me̠ni̠ ma̠ rologi d̠awa ma̠ ogir o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","O̠ni̠ ola̠ atu̠ghu̠me̠ni̠ ma̠ opa̠n abar ola̠ a̠nwegia̠n na̠ atu̠ghu̠me̠ni̠ igielake̠ ta̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st, na̠ atu̠ghu̠me̠ni̠ a̠ga̠i ima̠ra̠ ologi d̠i̠yar, ");
INSERT INTO mgj_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","bha̠ o̠ni̠ ola̠ na̠ agaga na̠ abu̠ghu̠me̠ni̠ ma̠ ozu, sa̠ ologhom d̠o̠ bebina̠ abar. I̠na a̠nwuna̠ ma̠ i̠karabh ebhiroma̠ o̠ku̠anan kabar kabar ola̠ ufugh usoroni. Sa̠ obha̠ na̠ a̠mutiom a̠gbokia̠n, na̠ elobhiri, na̠ a̠fugh i̠te̠i̠, na̠ igurumia̠n ologi, ");
INSERT INTO mgj_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","na̠ iwia̠n d̠a̠ a̠nwunom ya̠ inwuna̠ ma̠ i̠karabh rologi ya̠ na̠ e̠d̠u̠a d̠a̠ a̠gia̠ga̠i bho̠. Awa ibhin ma̠a̠ o̠tu̠o̠no̠m A̠zib̠a̠ ma̠a̠ eten o̠wo̠l ogbo e̠li̠la. ");
INSERT INTO mgj_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Ya̠a̠, ado̠l igielake̠ na̠ orugh agu̠o̠ ola̠ i̠di̠ar ya̠ o̠ni̠ ate̠i̠ ta̠ elegha̠n o̠ni̠, na̠ ebhin ibom asu̠o̠ na̠ eruom o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Abar ola̠ i̠yar ubhin uru d̠a̠ e̠mara̠nwunom onon bo̠, sa̠ bebina̠ abar ola̠ i̠yar ta̠ orue obhin o̠d̠u̠a bo̠. ");
INSERT INTO mgj_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ku̠gba ma̠ i̠yar o̠te̠i̠ ed̠ia̠n od̠e na̠ ibura̠ o̠lo̠gi̠an ma̠ i̠se̠n, bha̠ i̠nye̠n elegha̠n i̠yar. ");
INSERT INTO mgj_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Ya̠a̠, a̠nwunom ya̠ na̠ e̠bho̠ro̠gh ogbo e̠li̠la na̠ emel na̠ ed̠igh d̠a̠ ad̠agi̠an, na̠ akpati̠an, na̠ a̠d̠izo i̠karabh i̠walama ibhobho i̠kpo̠ ya̠ a̠d̠ugh, ya̠ ta̠ orobh awa od̠ighom d̠a̠ egbika̠ okunugi awa. ");
INSERT INTO mgj_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Ezin bho̠ otula̠n okpoki na̠ a̠mutiom eb̠la̠ i̠karabh od̠ighi i̠di̠ar. Idi ogbo d̠a̠ a̠d̠ien agu̠o̠ na̠ ewia̠n o̠te̠i̠ bho̠, na̠ ebhe d̠a̠ ologi ima̠ra̠ bho̠ ka̠ ed̠igh d̠a̠ ibom i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Ya̠a̠, anwa A̠timoti o̠ni̠ ta̠ A̠zib̠a̠, ghele ma̠ o̠kpo̠ i̠ye̠. Kpe̠le̠me̠ni̠, wia̠ne ma̠ a̠rugh ado̠l igielake̠, na̠ a̠ghud̠um oghila̠n A̠zib̠a̠, na̠ ologi ima̠ra̠, na̠ etula̠n, na̠ a̠ma̠ne, na̠ o̠ki̠ri̠me̠ni̠ ozu. ");
INSERT INTO mgj_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Wia̠ne ma̠ ibom d̠a̠ ologi ima̠ra̠ bho̠ ma̠ ate̠i̠ a̠ghud̠um kid̠ud̠ul wa̠ A̠zib̠a̠ a̠bhelegi nyam ra̠ a̠d̠ighom bho̠, wa̠ anwa i̠gba imutuma̠ d̠a̠ a̠misigh a̠d̠izo ogbo ma̠ anwa ta̠ atu̠o̠no̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Ami̠ na̠ a̠ruom anwa d̠a̠ a̠misigh ta̠ A̠zib̠a̠ wa̠ na̠ a̠nigha̠ ma̠ a̠ghud̠um eb̠la̠ i̠di̠ar, na̠ A̠zizo̠s Akrai̠st wa̠ amara d̠a̠ a̠misigh ta̠ Apo̠nti̠o̠s Apai̠let agba ma̠ iya̠gia̠ga̠i a̠gboloma̠ ma̠ ozu d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ma̠ agu̠o̠ ola̠ o̠nagha o̠nu̠o̠kpe̠ oloko bho̠ b̠o̠ka̠ u̠pi̠e̠ nyam, o̠li̠o̠m d̠o̠ nyam, tu̠tu̠n Wa̠nwuna̠ A̠zizo̠s Akrai̠st ta̠ a̠mula̠ a̠ru, ");
INSERT INTO mgj_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","d̠a̠ a̠ga̠i obhel wa̠ A̠zib̠a̠ itutumeni bho̠, wa̠ i̠na ku̠ku̠m aro̠ ma̠ Wirileghom bho̠, na̠ O̠li̠le̠ma ta̠ Aru̠li̠le̠ma bho̠, na̠ Wa̠nwuna̠ ma̠ ogbo ya̠ inwuna̠ bho̠, ta̠ ato̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Ya̠gia̠ga̠i, i̠na ku̠ku̠m ola̠ ko omugh d̠o̠, sa̠ na̠ a̠rugh d̠a̠ esi e̠b̠alab̠al ola̠ o̠ni̠ ko orue d̠o̠ a̠tua̠n. O̠nyi̠o̠mo̠ro̠ni̠ ola̠ na̠ a̠d̠ia̠ abi̠gh i̠na bo̠, sa̠ o̠ni̠ ola̠ ta̠ a̠rue abi̠gh i̠na bo̠ nyen. Edim na̠ a̠limon ya̠ o̠pu̠r ob̠eton na̠ ekunuguma̠ o̠to̠, e̠ro̠ enigha̠ i̠na. Aro̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ghaghana ma̠ ogbo ya̠ igbo ma̠ e̠li̠la d̠a̠ i̠di̠ar e̠mara̠nwunom onon bho̠ ma̠a̠, awa o̠bu̠ghu̠me̠ni̠ d̠o̠ ma̠ a̠ruzu bo̠d̠o̠ obhin d̠o̠ ma̠ e̠li̠la ya̠ na̠ ekpokolo eb̠em ologi. Kpe̠le̠me̠ni̠ bha̠ eb̠em ologi d̠awa aro̠ d̠a̠ A̠zib̠a̠ wa̠ na̠ a̠bhin d̠a̠ onyen ologi na̠ a̠nigha̠ i̠yar eb̠la̠ i̠di̠ar e̠nu̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Ggba ma̠ a̠nigha̠ awa ma̠ egir ib̠eb̠i, egbo ma̠ ibome e̠li̠la d̠a̠ ib̠eb̠i od̠ighi i̠di̠ar, enwuna̠ ma̠ onyen ologi, e̠ne̠ghe̠ na̠ onyen ologi. ");
INSERT INTO mgj_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Ka̠ awa igir o̠ku̠a bha̠ awa na̠ ekpol e̠li̠la iya̠ awa, ya̠ ta̠ e̠ro̠ ma̠ ob̠eb̠i o̠de̠o̠ma d̠a̠ ed̠ia̠, b̠o̠ka̠ awa e̠te̠i̠ a̠ga̠i a̠ghud̠um bho̠. ");
INSERT INTO mgj_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","O A̠timoti, mare̠ ma̠ a̠sibh abar wa̠ ub̠eton u̠lo̠gh d̠a̠ agu̠o̠ d̠oyom bho̠. Ko o̠nagha ma̠ ibhelebhel a̠fugh, bo̠d̠o̠, i̠b̠e̠re̠gi̠an na̠ aku̠anan ya̠ od̠igh d̠o̠ ma̠ esi ya̠ idi ogbo na̠ ekue na̠ ebhelegi ma̠ “eloghomabar.” ");
INSERT INTO mgj_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Idi ogbo na̠ ebhin e̠re̠ma ma̠ ola̠ na̠ emel e̠d̠u̠a d̠a̠ ologi ima̠ra̠ bho̠. E̠ne̠ghe̠ ta̠ A̠zib̠a̠ aro̠ na̠ eb̠la̠ inyin.");
INSERT INTO mgj_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Ami̠ Apo̠l o̠ni̠ogir ta̠ A̠zizo̠s Akrai̠st d̠a̠ i̠to̠ ta̠ A̠zib̠a̠, wa̠ uruom o̠gba a̠ghud̠um ogua̠n wa̠ od̠i d̠a̠ Akrai̠st A̠zizo̠s o̠sasaragi̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","na̠ age̠ na̠ a̠ruom anwa A̠timoti o̠nyi̠ ed̠igh ologi d̠ami̠. E̠ne̠ghe̠, igbirigbir, na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ Akrai̠st A̠zizo̠s Wa̠nwuna̠ i̠yar e̠ro̠ na̠ anwa. ");
INSERT INTO mgj_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Ami̠ na̠ ase̠bh A̠zib̠a̠ wa̠ ami̠ na̠ a̠bhin e̠b̠ab̠ala eloghoma̠n na̠ ako̠l bho̠, ma̠ agu̠o̠ ibom ro̠we̠de̠ d̠ami̠ igir bho̠. Ami̠ na̠ ka̠ ase̠bh A̠zib̠a̠ kigiel kigiel ami̠ i̠ru̠ru̠an igboloma̠ ma̠ anwa d̠a̠ ra̠siseiny d̠ami̠ ma̠ a̠d̠uga̠la̠n na̠ etita̠n. ");
INSERT INTO mgj_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Ami̠ na̠ aru̠ru̠an agu̠o̠ anwa ibhin ileghe bho̠ sa̠ na̠ ebhir ami̠ ma̠ o̠bi̠gh oyom, b̠o̠ka̠ ologi d̠ami̠ a̠muzo na̠ ibo ma̠ igiel i̠yar ta̠ ozua̠n. ");
INSERT INTO mgj_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Ami̠ na̠ aru̠ru̠an na̠ a̠gboloma̠ ma̠ ologi ima̠ra̠ igielake̠ onweni a̠ko d̠oyom A̠luwis na̠ onweni d̠oyom A̠yunasi̠, sa̠ ami̠ i̠mar ima̠ra̠ ma̠a̠ od̠i nyen d̠a̠ ozu d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Obha̠ ezin bho̠ ami̠ na̠ a̠nimeta̠n anwa ma̠ o̠so̠so̠me̠ni̠ enigha̠ wa̠ A̠zib̠a̠ a̠b̠eton a̠nigha̠ nyam igiel bho̠ ami̠ i̠gbamagi̠ aru̠gu̠o̠ d̠ami̠ d̠a̠ ozu d̠oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","A̠zib̠a̠ na̠ onigha̠ d̠o̠ i̠yar e̠mu̠gh a̠rugugu na̠ alu̠ku̠ a̠d̠ien, ya̠a̠, ola̠ a̠limon, na̠ etula̠n, na̠ osibhom ozu. ");
INSERT INTO mgj_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ko oghil ari̠ghe̠l ma̠ o̠gba Ib̠eb̠i Asu̠gbagba ta̠ Wa̠nwuna̠ d̠i̠yar onigha̠ ipa̠n ogbo. Ko odin nyen ma̠a̠ u̠du̠o̠m ami̠ ma̠ ikoli ma̠ ebula̠ o̠yo̠, ma̠ a̠ghil ari̠ghe̠l osen ami̠. Kpe̠le̠me̠ni̠ bha̠ bhine ma̠ a̠limon ya̠ A̠zib̠a̠ na̠ a̠nigha̠ nyam bho̠ ma̠ a̠d̠igh na̠ ami̠ ma̠ a̠gbika̠ ma̠ ebula̠ Ib̠eb̠i Asu̠gbagba bho̠. ");
INSERT INTO mgj_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","A̠zib̠a̠ a̠tenemeni i̠yar sa̠ aso̠n i̠yar ma̠ orugh a̠ghud̠um e̠b̠ab̠ala. Abar ola̠ i̠yar ugir ola̠ akpe̠ i̠yar o̠te̠i̠ e̠ne̠ghe̠ i̠nye̠n bo̠, ya̠a̠ ad̠u̠a d̠a̠ i̠to̠ d̠o̠yo̠ na̠ okpon igbirigbir d̠o̠yo̠. Kisa̠ ta̠ ate̠i̠ o̠pu̠r ob̠eton bho̠, i̠na ato̠ ma̠ agu̠o̠ ola̠ i̠yar ta̠ o̠wo̠l d̠a̠ A̠zizo̠s Akrai̠st o̠te̠i̠ e̠ne̠ghe̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","I̠se̠n bha̠ ubhin eruoma̠ ta̠ Witenemeni d̠i̠yar Akrai̠st A̠zizo̠s oleriom i̠yar e̠ne̠ghe̠ bho̠. I̠na ane̠gi̠me̠ni̠ ma̠ omugh, ma̠ i̠yar o̠gba ib̠eb̠i asu̠gbagba ya̠ i̠na a̠bhin a̠ruom i̠yar bho̠ o̠te̠i̠ a̠ghud̠um, na̠ ozu ola̠ ko omugh mu. ");
INSERT INTO mgj_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Sa̠ u̠so̠n ami̠ ma̠ o̠ro̠ o̠ni̠ ola̠ ta̠ agba ma̠ asu̠gbagba bho̠ asasaragi̠, na̠ o̠ni̠ogir, na̠ o̠ni̠ atu̠ghu̠me̠ni̠ ib̠eb̠i asu̠gbagba bho̠. ");
INSERT INTO mgj_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Obha̠ ezin bho̠ ami̠ na̠ abi̠gh nyen ali̠gam a̠ruzu i̠nye̠n bho̠. Ku̠ku̠m eka̠, ami̠ id̠igh d̠o̠ ma̠ ari̠ghe̠l, ezin bho̠ ami̠ a̠loghom i̠na o̠ni̠ wa̠ ami̠ id̠umom bho̠, sa̠ ami̠ ima̠ra̠ ma̠ i̠na ta̠ a̠rue a̠kponom abar ola̠ ub̠eton u̠lo̠gh d̠a̠ agu̠o̠ d̠o̠yo̠ tu̠tu̠n ta̠ ate̠i̠ a̠d̠a̠ma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Sibhe ma̠ i̠di̠ar ya̠ anwa i̠mu̠gho̠n d̠a̠ o̠nu̠ d̠ami̠ bho̠ ma̠ akparame̠ni̠, ma̠ agu̠o̠ ola̠ ta̠ e̠ro̠ ma̠ ed̠ighiom i̠di̠ar ya̠ a̠ga̠i atu̠ghu̠me̠ni̠. Bhine d̠a̠ ima̠ra̠ ologi na̠ etula̠n ta̠ Akrai̠st A̠zizo̠s ma̠ a̠gir. ");
INSERT INTO mgj_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Mare̠ ma̠ a̠kponom ob̠eb̠i abar wa̠ ub̠eton u̠lo̠gh d̠a̠ agu̠o̠ d̠oyom bho̠ d̠a̠ a̠limon ta̠ E̠mu̠gh E̠tu̠tu̠ wa̠ na̠ a̠rugh d̠a̠ rologi d̠a̠ i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Anwa a̠loghom ma̠a̠ ko̠ni̠ ko̠ni̠ d̠a̠ ebhugh Esia̠ na̠ eghel ami̠, sa̠ A̠figelus na̠ Ahe̠mo̠ze̠ne̠s eka̠ id̠igh ani̠. ");
INSERT INTO mgj_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Wa̠nwuna̠ bho̠ a̠kpon igbirigbir Onisiforus na̠ eghun otu d̠o̠yo̠ ma̠ agu̠o̠ awa iguri gha̠n i̠kpo̠me̠ni̠ ma̠ ologi d̠ami̠ bho̠, sa̠ awa odin d̠o̠ ma̠a̠ ami̠ od̠i d̠a̠ ikoli be̠le̠ni̠ eghil ari̠ghe̠l. ");
INSERT INTO mgj_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Igiel bho̠ i̠na a̠ru d̠a̠ A̠rom bho̠, i̠na abho̠ro̠ghan ami̠ kesi kesi tu̠tu̠n i̠na abi̠gh ami̠. ");
INSERT INTO mgj_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Wa̠nwuna̠ bho̠ a̠kpon Onisiforus igbirigbir d̠a̠ a̠d̠a̠ma̠ obha̠. Anwa a̠loghom e̠mi̠ agu̠o̠ Onisiforus a̠bhin alo̠gh agu̠o̠ a̠nigha̠ ami̠ d̠a̠ a̠d̠izo re̠kal d̠a̠ E̠fi̠so̠s. ");
INSERT INTO mgj_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni̠, anwa o̠nyi̠ d̠ami̠, kpo̠ ma̠ a̠luzu d̠a̠ e̠ne̠ghe̠ wa̠ od̠i d̠a̠ Akrai̠st A̠zizo̠s bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Bhine ma̠ i̠di̠ar ya̠ anwa i̠mu̠gho̠n ya̠ ami̠ i̠gba d̠a̠ esa̠d̠io a̠d̠izo a̠nwunom bho̠ ma̠ atu̠ghu̠me̠ni̠ ma̠ ipa̠n ogbo ya̠ na̠ obhin ob̠em ologi ma̠a̠ awa ta̠ erue ani̠ e̠tu̠ghu̠me̠ni̠ ma̠ ipa̠n a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","D̠ighe na̠ ami̠ ma̠ a̠gbika̠ ma̠ egbika̠ ma̠ agu̠o̠ ob̠eb̠i o̠ni̠e̠gham ta̠ Akrai̠st A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","O̠ni̠e̠gham na̠ o̠ko̠mo̠gi̠an gha̠n d̠o̠ na̠ od̠ighi i̠di̠ar a̠nwunom ya̠ o̠ro̠ d̠o̠ ma̠ ogbo-e̠gham, ka̠ a̠gir o̠ku̠a bha̠ ko od̠igh d̠o̠ ma̠ we̠mu̠-e̠gham bho̠ ma̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Odi abar eka̠, o̠ni̠ ola̠ od̠i d̠a̠ a̠pigia̠n eghil, ko orue d̠o̠ ane̠gi̠me̠ni̠ ma̠ ola̠ ta̠ ozuom i̠na ma̠ eghoi, a̠ten ka̠ i̠na atu̠o̠no̠m i̠to̠to̠gi̠ a̠pigia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Sa̠ od̠i ma̠ ola̠, od̠ighi ma̠ ari̠si̠ ola̠ na̠ a̠wia̠n na̠ a̠gir ogir ibom bho̠, akpe̠ ma̠ o̠ro̠ o̠ni̠ wa̠ ta̠ a̠d̠ia̠ a̠d̠e ma̠ ed̠ia̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Ru̠ru̠ane̠ ma̠ a̠gboloma̠ ma̠ i̠di̠ar ya̠ ami̠ na̠ agba na̠ a̠nigha̠ nyam bho̠. Wa̠nwuna̠ bho̠ alo̠gh agu̠o̠ a̠nigha̠ nyam o̠mu̠gho̠nyan eb̠la̠ i̠di̠ar i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Guri d̠a̠ ologi d̠oyom ma̠a̠ A̠zizo̠s Akrai̠st wa̠ ub̠eton d̠a̠ omugh bho̠ ma̠ odi o̠nyi̠ i̠sabh ikpele ta̠ O̠li̠le̠ma A̠devidi. Onon Ob̠eb̠i Asu̠gbagba wa̠ ami̠ na̠ agba na̠ asasaragi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Ebula̠ o̠ku̠a sa̠ ami̠ na̠ abi̠gh ali̠gam ozu na̠ ate̠i̠ esi ola̠ na̠ o̠du̠gi̠ ami̠ ma̠ rikoli ma̠ agu̠o̠ od̠ighi ma̠ i̠karabh. Ya̠a̠, o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ abar ola̠ ta̠ orue o̠du̠o̠m ikoli d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Ebula̠ o̠ku̠a, ami̠ na̠ a̠ne kabar kabar, ma̠ agu̠o̠ ola̠ ogbo ya̠ A̠zib̠a̠ na̠ aso̠n bho̠ e̠te̠i̠ itenemeni d̠a̠ Akrai̠st A̠zizo̠s na̠ isosorogia̠n ya̠ ekunuguma̠ o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Onon o̠nu̠o̠kpe̠ ola̠ a̠lei abar ola̠ u̠gba ma̠a̠, “Ku̠gba ma̠a̠ i̠yar od̠igh na̠ i̠na omugh, i̠yar ta̠ orugha̠n i̠na nyen. ");
INSERT INTO mgj_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Ku̠gba ma̠a̠ i̠yar one ma̠ a̠ma̠ne, bha̠ i̠yar ta̠ od̠igh na̠ i̠na orileghom irileghom d̠o̠yo̠, Ku̠gba ma̠a̠ i̠yar o̠ku̠a i̠na, sa̠ i̠na ta̠ aku̠a i̠yar nyen. ");
INSERT INTO mgj_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Ku̠gba ma̠a̠ i̠yar usibh d̠o̠ ma̠ ogua̠n, i̠na od̠id̠ia̠ na̠ a̠sibh ogua̠n, ezin bho̠ i̠na ko orue d̠o̠ aku̠a ma̠ ozu d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Nimeta̠ne ko̠ni̠ko̠ni̠ ma̠ i̠di̠ar i̠nye̠n, ma̠ a̠bhin d̠a̠ a̠d̠ien ta̠ A̠zib̠a̠ ma̠ akparame̠ni̠ ma̠ agba ma̠ a̠nigha̠ awa ma̠a̠, awa e̠we̠le̠man aku̠anan ya̠ igboloma̠ ma̠ ikpo a̠fugh. Aku̠anan i̠ye̠ id̠igh d̠o̠ ma̠ asu̠o̠ enigha̠ ma̠ o̠ni̠, kpe̠le̠me̠ni̠ bha̠ na̠ e̠pi̠e̠ ma̠ ogbo ya̠ na̠ e̠nagha bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Wia̠ne ma̠ agu̠o̠ ola̠ A̠zib̠a̠ ta̠ ada ma̠ anwa a̠bhin agu̠o̠ o̠ni̠ogir ola̠ onwuna̠ d̠o̠ ma̠ ezin ola̠ odin oghil ari̠ghe̠l, ola̠ na̠ a̠bhin ya̠ igielake̠ na̠ atu̠ghu̠me̠ni̠ ma̠ a̠ga̠i asu̠gbagba bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Ya̠a̠, ghele ma̠ a̠fugh i̠te̠i̠ na̠ i̠b̠e̠re̠gi̠an ya̠ od̠igh d̠o̠ ma̠ esi, ezin bho̠ i̠ye̠ na̠ eb̠uimeni ma̠ i̠karabh d̠a̠ ozu o̠ni̠, sa̠ na̠ esigimeni ma̠ o̠ni̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Ta̠ obhin o̠nu̠o̠kpe̠ d̠awa i̠ye̠ o̠tu̠o̠m e̠ke̠te̠ ola̠ o̠d̠u̠a d̠o̠ ola̠ na̠ a̠d̠e na̠ are̠gh d̠a̠ ozu o̠ni̠. Ahi̠me̠ni̠o̠s na̠ A̠filetos na̠ erugh ado̠l i̠ye̠. ");
INSERT INTO mgj_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Awa na̠ emel e̠d̠u̠a d̠a̠ a̠ga̠i eten bho̠, sa̠ na̠ e̠gba ma̠a̠ ob̠etina̠ d̠a̠ omugh bho̠ na̠ a̠mite a̠ten, obha̠ sa̠ na̠ api̠e̠ ma̠ ologi ima̠ra̠ a̠d̠izo ogbo. ");
INSERT INTO mgj_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Ya̠a̠, A̠zib̠a̠ na̠ ade̠ ma̠ o̠kparakpar o̠de̠o̠ma ola̠ ka̠ orue d̠o̠ onu o̠si̠ghe̠, sa̠ u̠ge̠ d̠a̠ anyu̠ bho̠ ma̠a̠, “Wa̠nwuna̠ a̠loghom ogbo ya̠ i̠ro̠ ma̠ iya̠ o̠yo̠ bho̠.” O̠ku̠a a̠d̠ighi be̠le̠ni̠, “Ko̠ni̠ko̠ni̠ ola̠ na̠ a̠sen a̠d̠ien d̠o̠yo̠ a̠ghel i̠karabh.” ");
INSERT INTO mgj_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","D̠a̠ otu ola̠ abu̠gh, a̠d̠ien kere kere i̠di̠ar a̠ma̠rugh otu od̠i, idi ubhin a̠silva̠ o̠le̠m, idi a̠gol, ipa̠n sa̠ ubhin iriren bo̠d̠o̠ i̠do̠gho̠l u̠le̠m. Idi ed̠igh edim, ya̠a̠ idi id̠igh d̠o̠ ma̠ edim. ");
INSERT INTO mgj_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","O̠ku̠a a̠d̠ighi be̠le̠ni, o̠ni̠ ola̠ ab̠ab̠alame̠ni̠ ma̠ ozu d̠o̠yo̠ d̠a̠ i̠karabh i̠ye̠ bha̠ oten abar edim, ola̠ Wa̠nwuna̠ bho̠ ta̠ a̠doni a̠bhin a̠gir a̠d̠ien kere kere ib̠eb̠i ogir. ");
INSERT INTO mgj_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Kpo ma̠ eghil ad̠u̠a d̠a̠ i̠karabh ebhiroma̠ ya̠ na̠ e̠nyagh ikubh a̠nwunom. Kpe̠le̠me̠ni̠ bha̠ bha̠ra̠nome ma̠ a̠ghud̠um igielake̠, ologi ima̠ra̠, etula̠n na̠ ekima̠, ma̠ a̠bhin a̠rilogha̠n ogbo ya̠ na̠ ebhin a̠ga̠i ologi na̠ esen Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Si̠ghe̠ ma̠ ozu d̠oyom d̠a̠ raku̠anan ema̠ na̠ iya̠ od̠igh d̠o̠ ma̠ esi, ezin bho̠ i̠ye̠ na̠ ekunugiom d̠a̠ o̠b̠e̠m. ");
INSERT INTO mgj_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Ob̠a̠ra̠motu ta̠ Wa̠nwuna̠ bho̠ na̠ o̠kpe̠ d̠o̠ ma̠ o̠b̠u̠man o̠b̠e̠m. Kpe̠le̠me̠ni̠, a̠bhin d̠a̠ o̠ki̠ri̠me̠ni̠ ozu na̠ d̠a̠ od̠ighi ib̠eb̠i na̠ e̠mar atu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠, a̠ne ma̠ a̠nwunom i̠kpalagi̠an. ");
INSERT INTO mgj_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Bhine d̠a̠ o̠ki̠ri̠me̠ni̠ ozu ma̠ atu̠ghu̠me̠ni̠ ogbo ya̠ na̠ e̠damaghan anwa bho̠. Ka̠din A̠zib̠a̠ ta̠ a̠rileghom awa ma̠ o̠wo̠l i̠se̠ otiba̠ra̠ d̠a̠ i̠karabh na̠ o̠mar ologhom eb̠la̠ a̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Sa̠ awa ta̠ eloghoma̠n a̠ruzu e̠d̠u̠a d̠a̠ e̠te̠ akpati̠ ta̠ Eru bho̠, wa̠ akpu̠o̠m awa a̠guri d̠a̠ ekpukpu i̠to̠ d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Loghome ma̠a̠ e̠kparama ado̠l ta̠ aro̠ d̠a̠ ra̠d̠a̠ma̠ ekunuguma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Ezin bho̠ a̠nwunom ta̠ etula̠n a̠ruzu d̠awa na̠ otula̠n ikpoki, ebhubhugha̠, e̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu, efugh a̠fugh i̠basi̠, sa̠ ko o̠nagha d̠o̠ ma̠ o̠nu̠o̠kpe̠ onweni na̠ o̠we̠de̠, ko o̠se̠bh d̠o̠ ma̠ ali̠se̠bh, sa̠ ko orugh d̠o̠ ma̠ ado̠l igielake̠. ");
INSERT INTO mgj_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","A̠nwunom ta̠ erugh ado̠l ya̠ igbiriri ozu o̠to̠, sa̠ okpon o̠si̠ghe̠ a̠d̠ien ko̠ o̠ro̠ mu̠, ta̠ efugh i̠basi̠, ko osibhom d̠o̠ ma̠ a̠ruzu, ta̠ e̠pi̠e̠gi̠ ma̠ i̠pi̠e̠gi̠, sa̠ ta̠ e̠su̠a kabar kabar ola̠ aro̠ ma̠ ob̠eb̠i. ");
INSERT INTO mgj_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Awa ta̠ ewol iwola̠, e̠basi̠ ma̠ i̠basi̠, erugh ado̠l o̠bu̠ghu̠me̠ni̠ a̠ruzu, etula̠n e̠me̠me̠m e̠mara̠nwunom, kpe̠le̠me̠ni̠ ma̠ otula̠n A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Awa ta̠ ekue egir agu̠o̠ a̠nwunom ya̠ na̠ erugh iya̠ igielake̠, ya̠a̠, na̠ eghel a̠ga̠i a̠limon bho̠. O̠ku̠a a̠d̠ighi be̠le̠ni̠, sigima̠ ma̠ ozu d̠oyom d̠a̠ a̠nwunom ya̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Idi awa na̠ e̠b̠o̠i̠ny na̠ ed̠ikighu d̠a̠ a̠rutu a̠nwunom na̠ eponoma̠ ma̠ anwani̠ idudugha̠n ologi ya̠ i̠karabh na̠ e̠ne̠mu̠o̠m bho̠, sa̠ na̠ erileghom awa na̠ ed̠ighom d̠a̠ a̠d̠ien kere kere ebhiroma̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Anwani̠ i̠ye̠ bha̠, eb̠la̠ igiel od̠i d̠a̠ atu̠ghan, ya̠a̠ irue d̠o̠ ma̠ o̠mu̠gho̠nyan a̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","A̠d̠ien agu̠o̠ Azane̠s na̠ Azambre̠s i̠damaghan A̠mozizi bho̠, obha̠ agu̠o̠ a̠nwunom i̠nye̠n eka̠ na̠ e̠damaghan a̠gia̠ga̠i bho̠. Awa a̠nwunom ya̠ inwuna̠ ma̠ i̠karabh i̠walama na̠ ologi ima̠ra̠ igunugha̠. ");
INSERT INTO mgj_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Ya̠a̠, awa ko obhin d̠o̠ ma̠ esusula̠ d̠awa e̠gi̠ ma̠ egbeiny, ezin bho̠ ko obia̠ d̠o̠ sa̠ ko̠ni̠ko̠ni̠ ta̠ a̠loghom a̠gia̠ga̠i bho̠ a̠gboloma̠ awa, ma̠ agu̠o̠ imutuma̠ ma̠ Azane̠s na̠ Azambre̠s bho̠. ");
INSERT INTO mgj_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Ya̠a̠, anwa na̠ amar amu̠gho̠nyan atu̠ghu̠me̠ni̠ d̠ami̠, na̠ a̠ma̠rugh d̠ami̠, na̠ ezin a̠ghud̠um d̠ami̠, na̠ ologi ima̠ra̠ d̠ami̠, na̠ a̠ma̠ne d̠ami̠, na̠ etula̠n d̠ami̠, na̠ i̠kparagi̠o̠m d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Anwa a̠loghom a̠ponoma̠ egbika̠ ya̠ i̠te̠i̠ ami̠ bho̠ na̠ a̠d̠ien kere kere ali̠gam a̠ruzu ya̠ i̠te̠i̠ ami̠ d̠a̠ Anti̠o̠k, na̠ Ikoni̠o̠m, na̠ A̠listara̠ bho̠. Ku̠ku̠m eka̠, ami̠ ane̠, sa̠ Wa̠nwuna̠ bho̠ a̠tenemeni ami̠ d̠a̠ eb̠la̠ ali̠gam a̠ruzu i̠ye̠. ");
INSERT INTO mgj_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Ya̠gia̠ga̠i, o̠ni̠ ola̠ na̠ ebhir obhin eb̠la̠ ologi d̠o̠yo̠ orugh a̠ma̠rugh igielake̠ d̠a̠ Akrai̠st A̠zizo̠s ta̠ abi̠gh a̠ponoma̠ egbika̠. ");
INSERT INTO mgj_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Sa̠ ta̠ a̠mite ma̠ ola̠ i̠karabh a̠nwunom, na̠ ogbo igelemeni ta̠ egurom epeleni, sa̠ ta̠ egelemeni ma̠ a̠nwunom, sa̠ ta̠ ogelemeni awa nyen. ");
INSERT INTO mgj_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Ya̠a̠ anwa, rughe ma̠ a̠ma̠rugh od̠ighi i̠di̠ar ya̠ anwa i̠tu̠ghan sa̠ anwa i̠mar ima̠ra̠ bho̠ d̠a̠ ogbo ya̠ i̠tu̠ghu̠me̠ni̠ nyam bho̠. ");
INSERT INTO mgj_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Loghome ma̠a̠, anwa iloghom O̠nu̠o̠kpe̠ E̠tu̠tu̠ bho̠ ka̠ d̠a̠ i̠gbara d̠oyom, ya̠ inigha̠ nyam eloghomabar ya̠ na̠ ebhin itenemeni na̠ eru d̠a̠ o̠wo̠l oten ologi ima̠ra̠ d̠a̠ Akrai̠st A̠zizo̠s. ");
INSERT INTO mgj_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","A̠zib̠a̠ a̠b̠ugh a̠mutiom eb̠la̠ o̠nu̠o̠kpe̠ E̠tu̠tu̠ bho̠, sa̠ a̠bhon ola̠ obhin o̠tu̠ghu̠me̠ni̠ atu̠ghu̠me̠ni̠, na̠ a̠kikiom, na̠ oselegi i̠di̠ar ya̠ obhon d̠o̠, na̠ atu̠ghan od̠igh e̠mu̠ d̠a̠ a̠ghud̠um igielake̠, ");
INSERT INTO mgj_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","ma̠ agu̠o̠ ola̠ o̠ni̠ ta̠ A̠zib̠a̠, ta̠ amar a̠kokod̠ia̠n ogir eb̠la̠ ib̠eb̠i ogir. ");
INSERT INTO mgj_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Ami̠ na̠ akparame̠ni̠ na̠ agba na̠ a̠nigha̠ nyam d̠a̠ a̠misigh ta̠ A̠zib̠a̠ na̠ Akrai̠st A̠zizo̠s wa̠ ta̠ a̠sobh ase̠ a̠gboloma̠ ma̠ ogbo ya̠ od̠i d̠a̠ a̠ghud̠um na̠ imumugh bho̠, na̠ d̠a̠ ebula̠ agu̠o̠ i̠na ta̠ a̠mula̠ a̠ru ma̠ agu̠o̠ o̠li̠le̠ma d̠a̠ irileghom d̠o̠yo̠ bho̠: ");
INSERT INTO mgj_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Gba ma̠ ib̠eb̠i asu̠gbagba ta̠ A̠zib̠a̠ ma̠ eb̠la̠ obhel. Bhine d̠a̠ a̠ma̠ne na̠ a̠kikiom ma̠ a̠rubhugiom, na̠ o̠nyagh ra̠to, o̠kpo̠me̠ni̠ rologi a̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Obhel na̠ a̠ru ma̠ ola̠ a̠nwunom ko o̠nagha d̠o̠ ma̠ a̠ga̠i atu̠ghu̠me̠ni̠. Kpe̠le̠me̠ni̠ bha̠ awa ta̠ e̠tu̠o̠no̠m i̠karabh rebhiroma̠ ologi d̠awa, sa̠ ta̠ eko ma̠ a̠ruzu d̠awa ekitineni na̠ ogbo atu̠ghu̠me̠ni̠ ya̠ ta̠ e̠tu̠ghu̠me̠ni̠ awa ma̠ i̠di̠ar ya̠ na̠ ebhir awa ma̠ o̠mu̠gho̠n. ");
INSERT INTO mgj_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Sa̠ awa ta̠ etiba̠ra̠ e̠d̠u̠a d̠a̠ a̠gia̠ga̠i bho̠ sa̠ ta̠ e̠tu̠o̠no̠m asu̠gbagba id̠ud̠ul ya̠ od̠igh d̠o̠ ma̠ esi. ");
INSERT INTO mgj_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Ya̠a̠ anwa, kimeni ma̠ ozu d̠a̠ eb̠la̠ i̠di̠ar, ma̠ a̠ne ma̠ egbika̠, ma̠ aro̠ ma̠ o̠ni̠ ola̠ o̠gba Ib̠eb̠i Asu̠gbagba bho̠ o̠d̠u̠a esi oten esi, ma̠ a̠gir ogir wa̠ ubhelegi nyam ogir bho̠ ma̠ a̠muzoghod̠iom. ");
INSERT INTO mgj_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","I̠se̠n bha̠ na̠ ozu ma̠ asi̠ d̠ami̠ ma̠ agu̠o̠ a̠min i̠ko̠l, sa̠ obhel wa̠ ami̠ ta̠ a̠b̠etina̠ ad̠u̠a d̠a̠ e̠mara̠nwunom onon bho̠ na̠ a̠tua̠n. ");
INSERT INTO mgj_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Ami̠ na̠ a̠we ma̠ ob̠eb̠i elobhiri, ami̠ na̠ amar a̠ghil eghil bho̠ ka̠ kunugiom, ami̠ na̠ a̠sibhom ologi ima̠ra̠ bho̠ ka̠ a̠kunugiom. ");
INSERT INTO mgj_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","O̠ku̠a bha̠ i̠se̠n na̠ oguri ma̠ eghoi ane̠gi̠me̠ni̠ bho̠ osisa̠n ami̠, wa̠ aro̠ ma̠ amu̠kpe̠ ola̠ ta̠ oleriom d̠a̠ A̠d̠a̠ma̠ Osobh Ase̠ bho̠ ma̠a̠, ami̠ a̠rugh iya̠ igielake̠ d̠a̠ a̠misigh ta̠ Wa̠nwuna̠, osobhmase̠ igielake̠ bho̠. Ebula̠ o̠ku̠a, amu̠kpe̠ bho̠ ko o̠ro̠ d̠o̠ enigha̠ ami̠ ku̠ku̠m, ya̠a̠ ta̠ e̠ro̠ enigha̠ ani̠ ma̠ eb̠la̠ ogbo ya̠ itula̠n eruoma̠ d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Wia̠ne ma̠ anu̠r a̠ru d̠ami̠ ma̠ obhel ola̠ ko obia̠ d̠o̠, ");
INSERT INTO mgj_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ezin bho̠ Ade̠mas na̠ a̠ba̠ra̠ ma̠ e̠mara̠nwunom amu̠m onon, sa̠ na̠ awe̠le̠man ami̠ a̠ten agi̠ d̠a̠ Ate̠saloni̠ka, A̠krise̠ns na̠ agi̠ d̠a̠ Agalesia̠, ya̠a̠ Atai̠to̠s na̠ agi̠ d̠a̠ Adalmatia̠. ");
INSERT INTO mgj_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","A̠luk ku̠ku̠m od̠i na̠ ami̠. Te̠ye̠ ma̠ Amaki̠ ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠d̠igh na̠ anwa a̠ru, ezin bho̠ i̠na ta̠ alo̠gh agu̠o̠ a̠nigha̠ ami̠ d̠a̠ ogir d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Ami̠ na̠ a̠bhin a̠dila̠de a̠limon d̠ami̠ a̠ruom Ata̠i̠siku̠s oten o̠gi̠ d̠a̠ E̠fi̠so̠s. ");
INSERT INTO mgj_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Igiel anwa na̠ a̠ru, bhine ma̠ akapa anyu̠ d̠ami̠ wa̠ od̠i na̠ Akarpu̠s d̠a̠ A̠troa̠s bho̠. B̠arame̠ na̠ ra̠d̠ire bho̠, okunukun iya̠ ozu i̠nam bho̠. ");
INSERT INTO mgj_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Ale̠kzanda o̠le̠ma i̠d̠i̠ar a̠rukurogh bho̠ a̠gir i̠karabh a̠gboloma̠ ami̠ d̠a̠ a̠d̠izo re̠kal. Wa̠nwuna̠ bho̠ akpe̠ i̠na ma̠ ogir ya̠ i̠na a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Anwa eka̠ kpona̠ ma̠ a̠sigima̠ i̠na, ezin bho̠ i̠na adamaghan i̠tu̠ghu̠me̠ni̠ d̠i̠yar ibom. ");
INSERT INTO mgj_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","O̠ni̠ ola̠ a̠d̠igh d̠a̠ agba d̠ami̠ na̠ o̠ro̠ d̠o̠ ma̠ o̠pu̠r igiel wa̠ ami̠ i̠gba ma̠ o̠nu̠ d̠a̠ iku wa̠ uler ami̠ bho̠. Kpe̠le̠me̠ni̠ bha̠ eb̠la̠ ogbo ighel ami̠, ya̠a̠ ami̠ na̠ a̠siseiny ma̠a̠ o̠wal d̠o̠ o̠lo̠gh d̠a̠ i̠karabh d̠awa. ");
INSERT INTO mgj_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Ya̠a̠, Wa̠nwuna̠ bho̠ aro̠ na̠ ami̠ sa̠ alo̠gh agu̠o̠ akparame̠ni̠ ami̠, ma̠ o̠gba Ib̠eb̠i Asu̠gbagba bho̠ omuzoghod̠iom onigha̠ eb̠la̠ Ibhebhia̠n bho̠. Sa̠ a̠tenemeni ami̠ d̠a̠ o̠nu̠ odughunub̠agu̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Ya̠ga̠i, Wa̠nwuna̠ bho̠ ta̠ a̠tenemeni ami̠ d̠a̠ eb̠la̠ i̠karabh od̠ighi i̠di̠ar, a̠guri ami̠ ma̠ ola̠ eko ka̠ a̠d̠ighom d̠a̠ irileghom ote̠nai̠ny d̠o̠yo̠. Itutumeni e̠ro̠ enigha̠ i̠na ad̠u̠a ma̠ amu̠m a̠ten amu̠m. Aro̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Pura̠ne ma̠ A̠priska na̠ A̠kwila̠, na̠ eghun otu ta̠ Onisiforus. ");
INSERT INTO mgj_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","E̠rasto̠s aro̠ d̠a̠ Ako̠ri̠nt, ya̠a̠ ami̠ i̠we̠le̠man A̠trofimo̠s d̠a̠ A̠militus ezin bho̠ ozu d̠o̠yo̠ na̠ obhon d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Wia̠ne ma̠ anu̠r a̠ru ra̠ ate̠i̠ ami̠ kisa̠ ta̠ ate̠i̠ obhel eb̠okum bho̠. A̠yubulus, na̠ Apu̠de̠ns, na̠ Alai̠no̠s, na̠ A̠kilodia̠, na̠ eb̠la̠ a̠rumor na̠ aru̠marani̠ bho̠ epura̠n anwa nyen. ");
INSERT INTO mgj_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Wa̠nwuna̠ bho̠ aro̠ na̠ e̠mu̠gh d̠oyom. E̠ne̠ghe̠ ta̠ A̠zib̠a̠ e̠ro̠ na̠ eb̠la̠ inyin.");
INSERT INTO mgj_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Ami̠ Apo̠l ob̠a̠ra̠motu ta̠ A̠zib̠a̠, o̠ni̠ogir ta̠ A̠zizo̠s Akrai̠st na̠ age̠ ma̠ a̠lebh onon na̠ a̠ruom anwa. Na̠ oruom ami̠ ma̠ o̠kpo̠me̠ni̠ rologi ima̠ra̠ ta̠ ogbo ya̠ A̠zib̠a̠ na̠ aso̠n bho̠, ma̠ od̠ighi agu̠o̠ ola̠ awa ta̠ e̠mar e̠mu̠gho̠nyan a̠ga̠i a̠ma̠rugh ya̠ ta̠ etutumeni ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Ta̠ awo̠l i̠se̠ sa̠ awa ta̠ e̠te̠i̠ eb̠em ologi a̠ghud̠um kid̠ud̠ul wa̠ A̠zib̠a̠ wa̠ o̠gba d̠o̠ ma̠ igunugha̠ bho̠, a̠gua̠n kisa̠ e̠mara̠nwunom a̠mite bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","D̠a̠ ebula̠ o̠ku̠a sa̠ A̠zib̠a̠ Witenemeni d̠i̠yar a̠muzoghod̠iom a̠d̠ighi ma̠ ola̠ uloghom o̠nu̠o̠kpe̠ d̠o̠yo̠ d̠a̠ obhel wa̠ i̠na ato̠ a̠guri bho̠, sa̠ i̠na a̠b̠eton ogir bho̠ alo̠gh d̠a̠ agu̠o̠ d̠ami̠ ma̠ o̠gba omutiom, d̠a̠ a̠d̠ien agu̠o̠ i̠na a̠ruom ami̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Ami̠ Apo̠l na̠ age̠ na̠ a̠ruom anwa Atai̠to̠s, a̠ga̠i o̠nyi̠ d̠ami̠ d̠a̠ onin ologi ima̠ra̠ bho̠. E̠no̠gho̠man na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠ na̠ A̠zizo̠s Akrai̠st Witenemeni d̠i̠yar e̠ro̠ na̠ anwa. ");
INSERT INTO mgj_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Ami̠ i̠we̠le̠man anwa d̠a̠ ekpe A̠kriti ma̠ agu̠o̠ ola̠ anwa ta̠ a̠selegi ma̠ i̠di̠ar ya̠ od̠id̠ia̠ ma̠ ogir bho̠ omunieni, na̠ o̠so̠n ikei omutiom ke̠ma ke̠ma ma̠ agu̠o̠ ami̠ i̠to̠ inigha̠ nyam bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Okei aro̠ ma̠ o̠ni̠ ola̠ abar o̠li̠o̠m o̠ro̠ d̠o̠, owolom ta̠ onin ani̠ ku̠ku̠m, anwi̠i̠ny d̠o̠yo̠ e̠ro̠ ma̠ iya̠ ima̠ra̠ ma̠ Akrai̠st na̠ iya̠ ta̠ obhin ob̠em ologi, iya̠ i̠karabh ya̠ ob̠ologiom o̠ro̠ d̠o̠ ma̠, iya̠ orugh d̠o̠ ma̠ ado̠l i̠te̠i̠, bo̠d̠o̠ o̠b̠agh d̠o̠ ma̠ e̠mu̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Agu̠o̠ aro̠ ma̠ ola̠ o̠ni̠ ola̠ na̠ a̠rileghom aso̠si̠ na̠ a̠kponom otu ta̠ A̠zib̠a̠ bho̠, i̠na na̠ o̠kpe̠ d̠o̠ ma̠ onwuna̠ e̠kal abar ola̠ o̠li̠o̠m, ya̠a̠ aro̠ ma̠ agu̠o̠ ob̠a̠ra̠motu ta̠ A̠zib̠a̠. I̠na ko o̠bu̠ghu̠me̠ni̠ d̠o̠ ma̠ ozu, ko o̠nu̠r d̠o̠ agam i̠gam, o̠d̠a ma̠ a̠min d̠o̠, o̠ni̠ a̠ponoma̠ d̠o̠. I̠na ko ogba̠gba̠ra̠gha̠n d̠o̠ ma̠ ogbo e̠li̠la ma̠ awai̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Kpe̠le̠me̠ni̠, i̠na aro̠ ma̠ o̠ni̠ ola̠ na̠ a̠bhin onyen ologi na̠ a̠d̠ighom isuloma̠, sa̠ a̠ba̠ra̠ ma̠ a̠ma̠rugh igielake̠, sa̠ na̠ a̠sibhom ozu, o̠ni̠ igielake̠, o̠ni̠ e̠b̠ab̠ala, sa̠ na̠ a̠gir iya̠ i̠kpe̠ d̠a̠ obhel wa̠ a̠sora̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","I̠na na̠ a̠sibh a̠ga̠i o̠nu̠o̠kpe̠ bho̠ ma̠ agu̠o̠ u̠tu̠ghu̠me̠ni̠ i̠na bho̠ akparame̠ni̠, ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠rue a̠bhin a̠ga̠i atu̠ghu̠me̠ni̠ bho̠ akpo̠me̠ni̠ ma̠ rologi ipa̠n ogbo, na̠ oselegi amu̠gho̠nyan ogbo ya̠ na̠ e̠damaghan bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ezin bho̠, a̠d̠izo awa na̠ e̠pagi̠raghan, sa̠ na̠ efugh iya̠ i̠te̠i̠ na̠ egelemeni ma̠ igelemeni, okunukun d̠a̠ esa̠d̠io awa ogbo ya̠ na̠ etia̠ ma̠ ipo bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Ya̠a̠, akpe̠ ma̠ okpegi aru̠nu̠ d̠awa, ezin bho̠ awa na̠ e̠tu̠ghu̠me̠ni̠ ma̠ atu̠ghu̠me̠ni̠ ya̠ osora̠n d̠o̠, sa̠ na̠ e̠pi̠e̠gi̠ ma̠ eb̠la̠ eghun a̠rutu, ma̠ ebula̠ ikpoki. ");
INSERT INTO mgj_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Odi owil ola̠ A̠kriti na̠ agu̠o̠ eka̠ agba ma̠a̠, “A̠nwunom A̠kriti na̠ e̠gba ma̠ igunugha̠ kigiel kigiel, ibom id̠ighi ma̠ i̠karabh ya̠ na̠ e̠basi̠o̠m a̠nwunom, na̠ i̠gbu̠o̠ro̠gbu̠o̠r i̠d̠o̠gho̠d̠o̠gh.” ");
INSERT INTO mgj_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Asu̠gbagba bho̠ ya̠gia̠ga̠i. O̠ku̠a a̠d̠ighi be̠le̠ni̠, game̠ ma̠ a̠nigha̠ awa ma̠ ibom bo̠ka̠ rologi ima̠ra̠ d̠awa e̠ghu̠a. ");
INSERT INTO mgj_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Ma̠ agu̠o̠ ola̠ awa ko o̠nagha d̠o̠ ma̠ i̠karabh id̠ud̠ul na̠ asi̠b̠o̠m Ogbo A̠zu bho̠, na̠ i̠to̠to̠gi̠ ogbo ya̠ na̠ eghel ya̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Kabar kabar ab̠ab̠ala d̠awa ogbo ya̠ i̠b̠ab̠ala bho̠; ya̠a̠, d̠awa ogbo ya̠ na̠ e̠pi̠o̠gho̠m sa̠ od̠umom d̠o̠ bho̠, abar e̠b̠ab̠ala ola̠ od̠i na̠ awa bo̠, ya̠a̠, rologi d̠awa na̠ egbiriri a̠ruzu d̠awa na̠ e̠pi̠an. ");
INSERT INTO mgj_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Awa na̠ e̠re̠ma ma̠a̠ awa eloghom A̠zib̠a̠, ya̠a̠ rod̠ighi i̠di̠ar d̠awa na̠ eghel i̠na. Eghenegia̠n awa, i̠b̠agh ma̠ aru̠mu̠ ya̠ o̠nagha d̠o̠ ma̠ o̠nu̠o̠kpe̠, ya̠ orue d̠o̠ ma̠ ogir bebina̠ abar ola̠ aro̠ ma̠ ob̠eb̠i. ");
INSERT INTO mgj_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Ya̠a̠ anwa, tu̠ghu̠me̠ni̠ ma̠ i̠di̠ar ya̠ isora̠n o̠ro̠ a̠ga̠i atu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Kikiome ma̠ ikei ilobhiri a̠nwunom bho̠ ma̠ awa ekimeni ma̠ a̠ruzu, ed̠igh edim, esibhom a̠ruzu, e̠ghu̠a d̠a̠ ima̠ra̠ ologi, enwuna̠ ma̠ etula̠n, na̠ a̠ma̠ne. ");
INSERT INTO mgj_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Onin agu̠o̠ bho̠, kikiome ma̠ iguda̠ anwani̠ bho̠ ma̠ orugh ado̠l d̠awa o̠gu̠b̠e̠ni̠ a̠ma̠rugh anwani̠ e̠b̠ab̠ala. Awa o̠ro̠ d̠o̠ ma̠ ogbo isorogiom, bo̠d̠o̠ re̠bana ta̠ a̠min, ya̠a̠, awa e̠tu̠ghu̠me̠ni̠ ma̠ ib̠eb̠i i̠tu̠ghu̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Sa̠ awa ta̠ ebhin i̠se̠ e̠tu̠ghu̠me̠ni̠ ma̠ ikubh anwani̠ bho̠ ma̠ otula̠n a̠riwolom na̠ anwi̠i̠ny d̠awa, ");
INSERT INTO mgj_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","na̠ osibhom a̠ruzu d̠awa, na̠ orugh ado̠l e̠b̠ab̠ala, na̠ ogir ogir d̠a̠ a̠rutu d̠awa, na̠ ogir ib̠eb̠i, na̠ ozuruna̠ eghoi onigha̠ a̠riwolom d̠awa, b̠o̠ka̠ o̠ni̠ na̠ ofugh a̠fugh i̠basi̠ a̠gboloma̠ ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Onin agu̠o̠ bho̠, kpo̠me̠ni̠ ma̠ rologi anwi̠i̠ny oyel bho̠ ma̠ agu̠o̠ ola̠ awa ta̠ esibhom a̠ruzu d̠awa d̠a̠ eb̠la̠ i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","A̠ma̠rugh d̠oyom ebhon d̠a̠ eb̠la̠ i̠d̠i̠ar ma̠ agu̠o̠ ola̠ a̠nwunom ta̠ e̠bi̠gh e̠ta. Bhine d̠a̠ a̠ghud̠um igielake̠ na̠ edim, ma̠ a̠leriom ma̠ agu̠o̠ atu̠ghu̠me̠ni̠ d̠oyom a̠lei abar ate̠i̠. ");
INSERT INTO mgj_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Ro̠nu̠o̠kpe̠ d̠oyom ebhon e̠ro̠ ma̠ iya̠ ko orue d̠o̠ o̠bi̠gh o̠pi̠e̠, b̠o̠ka̠ ogbo ya̠ na̠ e̠damaghan bho̠ ed̠igh ari̠ghe̠l, ma̠ agu̠o̠ ola̠ awa ko o̠bi̠gh d̠o̠ ma̠ i̠karabh ola̠ ofugh ogboloma̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Re̠bana bho̠ ezuruna̠ ma̠ eghoi enigha̠ ma̠ ogbo ya̠ inwuna̠ awa bho̠ d̠a̠ eb̠la̠ i̠di̠ar iya̠ isora̠n. Awa o̠kpalatu̠an d̠o̠ ma̠ ogbo ya̠ inwuna̠ awa bho̠, ");
INSERT INTO mgj_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","bo̠d̠o̠ oniniom d̠o̠ awa. Kpe̠le̠me̠ni̠, awa erugh a̠ghud̠um igielake̠ iya̠ ta̠ obhin awa ob̠em ologi, b̠o̠ka̠ eb̠la̠ atu̠ghu̠me̠ni̠ ya̠ igboloma̠ ma̠ A̠zib̠a̠ Witenemeni d̠i̠yar bho̠ ed̠igh e̠b̠e̠l enigha̠ ma̠ a̠nwunom d̠a̠ eb̠la̠ i̠di̠ar. ");
INSERT INTO mgj_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Ezin bho̠, A̠zib̠a̠ na̠ a̠leriom e̠ne̠ghe̠ d̠o̠yo̠ wa̠ na̠ a̠bhin itenemeni na̠ a̠ruom eb̠la̠ a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","E̠ne̠ghe̠ ta̠ A̠zib̠a̠ bho̠ na̠ atu̠ghu̠me̠ni̠ i̠yar ogin a̠ma̠rugh ya̠ ko onigha̠ d̠o̠ ma̠ A̠zib̠a̠ ma̠ itutumeni, na̠ i̠karabh e̠ralma e̠mara̠nwunom, ya̠a̠ i̠yar osibhom a̠ruzu d̠i̠yar, orugh a̠ma̠rugh igielake̠ d̠a̠ amu̠m onon. ");
INSERT INTO mgj_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","D̠a̠ a̠d̠ien agu̠o̠ i̠yar na̠ ogon itutumeni eb̠em ologi bho̠ na̠ eruoma̠ isosorogia̠n ta̠ Obom A̠zib̠a̠ na̠ Witenemeni d̠i̠yar A̠zizo̠s Akrai̠st ");
INSERT INTO mgj_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","wa̠ a̠nigha̠ ma̠ a̠ghud̠um d̠o̠yo̠ ma̠ obhin o̠ta i̠yar o̠si̠ghe̠ d̠a̠ a̠d̠ien kere kere i̠karabh, na̠ o̠b̠ab̠alame̠ni̠ i̠yar oguri a̠nwunom iyo̠yo̠, ya̠ ta̠ ebhir ogir ib̠eb̠i. ");
INSERT INTO mgj_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Tu̠ghu̠me̠ni̠ ma̠ i̠di̠ar i̠nye̠n, ma̠ akpo̠me̠ni̠ ma̠ rologi ogbo ya̠ na̠ e̠nagha nyam bho̠, ma̠ a̠bhin eb̠la̠ a̠limon d̠oyom ma̠ a̠selegi ma̠ a̠risi ya̠ awa na̠ erima̠. Ko orugh agu̠o̠ ola̠ o̠ni̠ ta̠ a̠kpon anwa aki̠ri̠me̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Nemeta̠ne awa, ma̠ awa ezuruna̠ ma̠ eghoi enigha̠ ma̠ ogbo irileghom na̠ ra̠dila̠de i̠to̠, e̠nagha ma̠ o̠nu̠o̠kpe̠ d̠awa, ema̠ra̠ ma̠ obhin onyen ologi ogir ib̠eb̠i d̠a̠ eb̠la̠ re̠kal. ");
INSERT INTO mgj_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Awa o̠gba d̠o̠ ma̠ o̠ni̠ e̠pi̠e̠, o̠b̠u̠man d̠o̠ ma̠ o̠b̠e̠m, ya̠a̠ awa erugh ado̠l ekima̠, na̠ a̠ma̠rugh o̠ki̠ri̠me̠ni̠ ozu egboloma̠ ko̠ni̠ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Ezin bho̠, d̠a̠ obhel ola̠ na̠ a̠ten, abar ola̠ i̠yar u̠mu̠gho̠nyan na̠ o̠ri̠la d̠o̠. I̠yar u̠b̠agh aru̠mu̠, sa̠ a̠d̠ien kere kere i̠karabh e̠ralma, na̠ e̠ralma ipulupul ozu na̠ ipesi, na̠ i̠karabh i̠walama, i̠le̠ge̠ i̠yar ka̠ id̠ighom re̠bana, ma̠ ola̠ i̠yar urugh ado̠l igurumia̠n ologi na̠ a̠gbokia̠n, na̠ o̠lo̠gi̠an a̠d̠ien, sa̠ odi a̠ghir ologi ma̠ odi. ");
INSERT INTO mgj_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Ya̠a̠, igiel bho̠ A̠zib̠a̠ Witenemeni d̠i̠yar a̠leriom i̠yar okpon igbirigbir na̠ etula̠n d̠o̠yo̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","sa̠ i̠yar u̠te̠i̠ itenemeni d̠a̠ agu̠o̠ d̠o̠yo̠. Na̠ o̠d̠u̠a d̠o̠ d̠a̠ ib̠eb̠i ya̠ i̠yar ugir, ya̠a̠ ad̠u̠a ku d̠a̠ igbirigbir d̠o̠yo̠ sa̠ i̠na a̠tenemeni i̠yar. I̠na awo̠l d̠a̠ E̠mu̠gh E̠tu̠tu̠ bho̠ a̠titol i̠karabh d̠i̠yar, sa̠ a̠nigha̠ i̠yar omom i̠mara, na̠ omom a̠ghud̠um. ");
INSERT INTO mgj_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","I̠na awo̠l d̠a̠ A̠zizo̠s Akrai̠st Witenemeni d̠i̠yar a̠bhin onyen ologi a̠zuom i̠yar E̠mu̠gh E̠tu̠tu̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ma̠ agu̠o̠ ola̠ o̠b̠ab̠alame̠ni̠ i̠yar d̠a̠ igbirigbir d̠o̠yo̠, ma̠ ola̠ i̠yar na̠ onwuna̠ ma̠ eb̠em ologi od̠e ad̠i̠a a̠ghud̠um kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Onon a̠ga̠i o̠nu̠o̠kpe̠, sa̠ ami̠ na̠ abho̠ro̠gh anwa ma̠ o̠gba o̠kparame̠ni̠, ma̠ agu̠o̠ ola̠ ogbo ya̠ na̠ ema̠ra̠ ma̠ A̠zib̠a̠ bho̠ ta̠ ebhin eb̠la̠ rologi d̠awa egir ib̠eb̠i. I̠di̠ar i̠nye̠n ebhon sa̠ ta̠ e̠ro̠ ma̠ asu̠o̠ inigha̠ ko̠ni̠ ko̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Ya̠a̠ anwa, sigima̠ ma̠ raku̠anan obhobho i̠kpo̠, na̠ i̠re̠ma imitia̠n, na̠ o̠b̠e̠m, na̠ aku̠anan ya̠ igboloma̠ ma̠ oloko bho̠. Ezin bho̠, i̠ye̠ asu̠o̠ bo̠, sa̠ i̠ro̠ ma̠ ogir ema̠ obhobho i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Kikiome ma̠ o̠go̠me̠ma, ma̠ onin bo̠d̠o̠ i̠wal igiel, ka̠ a̠ten i̠se̠, sigima̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Loghome ma̠a̠ o̠ni̠ ola̠ o̠ku̠a na̠ a̠mel ad̠u̠a d̠a̠ ologi ima̠ra̠ bho̠, sa̠ i̠karabh d̠o̠yo̠ na̠ esobh ase̠ ebhumeni i̠na. ");
INSERT INTO mgj_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Igiel ami̠ iruom Ate̠mas bo̠d̠o̠ Atai̠kiku̠s oru d̠oyom, bha̠ nugia̠ne ma̠ a̠ru ra̠ ate̠i̠ ami̠ d̠a̠ A̠nikopolis, ezin bho̠ ami̠ ta̠ aro̠ ma̠ i̠se̠ ma̠ obhel okogoro bho̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Wia̠ne ma̠ anu̠r alo̠gh agu̠o̠ ma̠ a̠nigha̠ ma̠ Aze̠nas o̠ni̠ oloko bho̠, na̠ Apo̠lo̠s ma̠ d̠a̠ e̠gi̠ d̠awa, ma̠ agu̠o̠ ola̠ abar ko o̠kparama d̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Akpe̠ ma̠ a̠nwunom d̠i̠yar o̠tu̠ghan agu̠o̠ obhin obhel d̠awa ogir ib̠eb̠i ogir, b̠o̠ka̠ awa e̠te̠i̠ a̠ga̠i i̠di̠ar ya̠ i̠kpe̠ awa ma̠ o̠te̠i̠, kpe̠le̠me̠ni̠ ma̠ o̠ro̠ a̠nwunom ya̠ ko omum d̠o̠ ma̠ imuma̠. ");
INSERT INTO mgj_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Eb̠la̠ ogbo ya̠ od̠i na̠ ami̠ ma̠ enen bho̠ epura̠n anwa. Pura̠ne ma̠ eb̠la̠ ra̠tologha̠n ya̠ itula̠n i̠yar bho̠, ya̠ awa na̠ i̠yar unwuna̠ ma̠ onin ologi ima̠ra̠ bho̠. E̠no̠gho̠man ta̠ A̠zib̠a e̠ro̠ na̠ eb̠la̠ inyin.");
INSERT INTO mgj_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Ami̠ Apo̠l o̠ni̠ ikoli ta̠ Akrai̠st A̠zizo̠s, na̠ A̠timoti umor d̠i̠yar na̠ o̠ge̠ na̠ oruom anwa A̠filimo̠n wa̠ na̠ i̠yar uma̠ra̠ ma̠ Akrai̠st bho̠, wa̠ na̠ a̠d̠igh na̠ i̠yar na̠ a̠gir bho̠, ");
INSERT INTO mgj_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","na̠ u̠marani̠ d̠i̠yar Afi̠a, na̠ Aki̠pu̠s wa̠ na̠ i̠yar na̠ owe ma̠ e̠gham bho̠, na̠ ogbo ya̠ na̠ ed̠igh aso̠si̠ d̠a̠ otu d̠oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","E̠ne̠ghe̠ na̠ ekima̠ ta̠ A̠zib̠a̠ O̠we̠de̠ d̠i̠yar na̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st e̠ro̠ na̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ami̠ na̠ ase̠bh A̠zib̠a̠ na̠ a̠gboloma̠ nyam kigiel kigiel ola̠ ami̠ i̠ru̠ru̠an anwa d̠a̠ a̠siseiny d̠ami̠, ");
INSERT INTO mgj_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ezin bho̠, ami̠ na̠ amu̠gho̠n agu̠o̠ anwa na̠ a̠tula̠n eb̠la̠ a̠nwunom ta̠ A̠zib̠a, na̠ ologi ima̠ra̠ wa̠ anwa inwuna̠ igboloma̠ ma̠ Wa̠nwuna̠ A̠zizo̠s bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","A̠siseiny d̠ami̠ bha̠, a̠ghisia̠n wa̠ od̠i d̠a̠ esa̠d̠io d̠i̠yar ogbo-ima̠ra̠ ta̠ Akrai̠st bho̠, a̠d̠ighi ma̠ ola̠ i̠yar ta̠ o̠mar o̠mu̠gho̠nyan eb̠la̠ e̠no̠gho̠man ya̠ na̠ i̠te̠i̠ i̠yar d̠a̠ a̠ghud̠um, d̠a̠ ebula̠ Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Umor d̠ami̠, etula̠n d̠oyom na̠ a̠nigha̠ ami̠ ma̠ ibom a̠libhon ologi, akpo̠me̠ni̠ ma̠ ologi d̠ami̠. Sa̠ anwa na̠ ame̠me̠me̠ni̠ ma̠ rologi eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","O̠ku̠a a̠d̠ighi be̠le̠ni̠, ami̠ ka̠ ibhin agu̠o̠ ami̠ i̠ro̠ ma̠ umor d̠oyom d̠a̠ Akrai̠st bho̠, akpo̠me̠ni̠ ma̠ ologi akparame̠ni̠ a̠ruom anwa ma̠ ogir i̠di̠ar ya̠ i̠kpe̠ nyam ogir bho̠, ");
INSERT INTO mgj_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","kpe̠le̠me̠ni̠ bha̠ ami̠ na̠ ale̠gh ale̠gha ma̠ anwa d̠a̠ ebula̠ etula̠n. Ami̠ okei-o̠ni̠ Apo̠l, o̠ni̠ wa̠ na̠ a̠bhin a̠d̠ien ta̠ Akrai̠st A̠zizo̠s na̠ amara bho̠, wa̠ udin i̠na u̠lo̠gh ikoli ma̠ i̠se̠n nyen bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","Ami̠ na̠ a̠siseiny anwa na̠ a̠gboloma̠ ma̠ Onisimo̠s, wa̠ ra̠ a̠ten o̠nyi̠ ola̠ ami̠ i̠ro̠ ma̠ o̠we̠de̠ ma̠ igiel bho̠ u̠du̠o̠m ami̠ d̠a̠ ikoli bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Obhel ola̠ na̠ a̠ten, i̠na na̠ olei d̠o̠ ma̠ abar d̠a̠ a̠misigh d̠oyom, ya̠a̠ i̠se̠n i̠na na̠ a̠ten o̠ni̠ ola̠ a̠lei abar d̠a̠ a̠misigh ta̠ i̠wal i̠yar. ");
INSERT INTO mgj_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Ami̠ na̠ a̠mulumeni i̠na wa̠ ed̠igh ologi d̠ami̠ bho̠, na̠ a̠ruom anwa. ");
INSERT INTO mgj_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Nab̠o̠, ebhir ami̠ ma̠ oguri o̠yo̠, ma̠ agu̠o̠ ola̠ i̠na ta̠ a̠bhin esi d̠oyom alo̠gh agu̠o̠ a̠nigha̠ ami̠ ma̠ i̠se̠n u̠du̠o̠m ami̠ ma̠ ikoli d̠a̠ ebula̠ o̠gba ib̠eb̠i asu̠gbagba bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Ya̠a̠, ami̠ i̠bho̠ro̠gh d̠o̠ ma̠ oponoma̠ oyom ma̠ o̠lo̠gh agu̠o̠ onigha̠ ami̠, kpe̠le̠me̠ni̠ bha̠ ad̠u̠a d̠a̠ onyen ologi d̠oyom na̠ agu̠o̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Ka̠din Onisimo̠s abagi̠na nyam ekud̠i obhel b̠o̠ka̠ i̠na a̠mula̠ a̠ru ra̠ a̠d̠igh na̠ anwa aro̠ ma̠ owewegh obhel, ");
INSERT INTO mgj_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","i̠se̠n bha̠, agu̠o̠ e̠bana d̠o̠, a̠pel e̠bana. D̠ami̠ bha̠ i̠na umor ed̠igh ologi d̠a̠ Akrai̠st, ya̠a̠, d̠oyom bha̠ i̠na o̠ni̠ ola̠ a̠pel o̠ku̠a, ma̠ agu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ na̠ agu̠o̠ umor d̠a̠ Akrai̠st. ");
INSERT INTO mgj_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Ku̠gba ma̠a̠ anwa ibhin ami̠ ma̠ agu̠o̠ o̠ni̠ i̠b̠aragu̠ma d̠oyom, bha̠ d̠a̠ ma̠ Onisimo̠s a̠bhin onin agu̠o̠ anwa ta̠ ada ami̠ a̠bhin bho̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Ku̠gba ma̠ i̠na a̠gir i̠karabh a̠gboloma̠ nyam, bo̠d̠o̠ a̠d̠igh o̠mu̠gh d̠a̠ agu̠o̠ d̠oyom, bha̠ aro̠ d̠a̠ e̠mu̠ d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Ami̠ Apo̠l na̠ agu̠o̠ ibhin agu̠o̠ d̠ami̠ age̠ ma̠a̠, ami̠ ta̠ akpe̠ nyam a̠mulumeni. Ami̠ i̠bho̠ro̠gh d̠o̠ ma̠ onemeta̠n oyom ma̠a̠, a̠ghud̠um d̠oyom bha̠ o̠mu̠gh ola̠ anwa id̠igh d̠a̠ agu̠o̠ d̠ami̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Ob̠eb̠i umor ed̠igh ologi d̠ami̠ d̠a̠ onin ima̠ra̠ ologi d̠a̠ Akrai̠st, gire ma̠ abar onon a̠nigha̠ ami̠ d̠a̠ ebula̠ Akrai̠st, ma̠ ame̠me̠me̠ni̠ ma̠ ologi d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Agu̠o̠ ami̠ na̠ age̠ na̠ a̠ruom anwa bho̠, ami̠ ima̠ra̠ ma̠a̠ anwa ta̠ a̠gir abar wa̠ ami̠ na̠ abho̠ro̠gh anwa ma̠ ogir bho̠, sa̠ anwa ta̠ a̠gir a̠peleni ma̠ o̠ku̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","O̠b̠aragi̠o̠m i̠se̠, tu̠ghu̠mane̠ ma̠ otu-esul a̠guri ma̠ a̠sisa̠n ami̠, ezin bho̠ ami̠ na̠ a̠b̠em ologi ma̠a̠ ta̠ o̠wo̠ran ra̠siseiny d̠inyin omutiom ami̠ onigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epafras wa̠ od̠i na̠ ami̠ d̠a̠ ikoli d̠a̠ ebula̠ Akrai̠st A̠zizo̠s bho̠, agba ma̠a̠ ami̠ ipura̠n anwa. ");
INSERT INTO mgj_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Amaki̠, na̠ Ari̠staku̠s, na̠ Ade̠mas, na̠ A̠luk, ogbo ya̠ na̠ ed̠igh na̠ ami̠ na̠ egir bho̠ eka̠ epura̠n anwa. ");
INSERT INTO mgj_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","E̠ne̠ghe̠ ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st aro̠ na̠ inyin.");
INSERT INTO mgj_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","D̠a̠ obhel ola̠ na̠ a̠ten, A̠zib̠a̠ awo̠l d̠a̠ aru̠nu̠ a̠riwil bho̠ agba ma̠ a̠d̠izo i̠di̠ar a̠nigha̠ ma̠ ibom ro̠we̠de̠ d̠i̠yar ma̠ a̠d̠izo igiel, ");
INSERT INTO mgj_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ya̠a̠ i̠se̠n d̠a̠ ra̠d̠a̠ma̠ ekunuguma̠ i̠nye̠n, i̠na na̠ a̠bhin O̠nyi̠ d̠o̠yo̠ na̠ agba ma̠ i̠di̠ar na̠ a̠nigha̠ i̠yar. A̠zib̠a̠ awo̠l d̠a̠ o̠nu̠ O̠nyi̠ d̠o̠yo̠, wa̠ i̠na a̠b̠eton eb̠la̠ i̠di̠ar a̠nigha̠ bho̠, ale̠m eb̠la̠ i̠di̠ar d̠a̠ a̠de na̠ e̠nai̠ny. ");
INSERT INTO mgj_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","O̠nyi̠ bho̠ na̠ a̠mutioghom e̠b̠alab̠al isosorogia̠n ta̠ A̠zib̠a̠ na̠ o̠le̠m d̠o̠yo̠, sa̠ na̠ a̠bhin ibom a̠limon o̠nu̠ o̠kpe̠ d̠o̠yo̠ na̠ a̠sibh eb̠la̠ i̠di̠ar ya̠ od̠i d̠a̠ e̠ma ra̠ a̠nwunom bho̠ na̠ a̠guri. Igiel bho̠ i̠na na̠ ab̠ab̠alame̠ni̠ i̠yar d̠a̠ i̠karabh bho̠, sa̠ i̠na agi̠ ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ ta̠ A̠zib̠a̠ wa̠ a̠nwuna̠ ma̠ a̠limon a̠pu bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","O̠nyi̠ bho̠ abu̠gh a̠pu ma̠ itileduom ta̠ A̠zib̠a̠, ma̠ agu̠o̠ a̠d̠ien wa̠ A̠zib̠a̠ a̠ghol i̠na bho̠ a̠lei abar a̠pu ma̠ ita̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","D̠a̠ itileduom ta̠ A̠zib̠a̠ bho̠, ka̠ oken wa̠ I̠na a̠fugh a̠nigha̠ ma̠a̠: “Anwa O̠nyi̠ d̠ami̠; anwa na̠ a̠ten O̠nyi̠ d̠ami̠ ma̠ a̠didon.” Bo̠d̠o̠ sa̠ a̠fugh ma̠a̠, “Ami̠ ta̠ aro̠ ma̠ O̠we̠de̠ d̠o̠yo̠, sa̠ i̠na ta̠ a̠ten O̠nyi̠ d̠ami̠”? ");
INSERT INTO mgj_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Ya̠a̠, igiel bho̠ A̠zib̠a̠ a̠bhin o̠kpana o̠nyi̠ d̠o̠yo̠ a̠ru d̠a̠ e̠ma ra̠ a̠nwunom bho̠, sa̠ agba ma̠a̠, “Eb̠la̠ itileduom ta̠ A̠zib̠a̠ e̠ko̠l i̠na.” ");
INSERT INTO mgj_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","I̠na agba a̠gboloma̠ ma̠ itileduom ta̠ A̠zib̠a̠ bho̠ ma̠a̠, “I̠na na̠ a̠tenemeni awa ma̠ itileduom d̠o̠yo̠ ma̠ aru̠mu̠gh, sa̠ rob̠a̠ra̠motu d̠o̠yo̠ i̠ro̠ ma̠ re̠ba anya.” ");
INSERT INTO mgj_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Ya̠a̠, d̠a̠ O̠nyi̠ bho̠ sa̠ I̠na agba ma̠a̠, “E A̠zib̠a̠, a̠dila̠de irileghom d̠oyom ta̠ ad̠u̠a ma̠ id̠ud̠ul a̠ten id̠ud̠ul, sa̠ anwa ta̠ a̠rileghom a̠nwunom d̠oyom d̠a̠ igielake̠. ");
INSERT INTO mgj_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Anwa a̠ba̠ra̠ ma̠ e̠b̠ab̠ala sa̠ i̠karabh na̠ eghir anwa ma̠ ologi. Ebula̠ o̠ku̠a, sa̠ A̠zib̠a̠ wa̠ aro̠ ma̠ A̠zib̠a̠ d̠oyom bho̠, aso̠n anwa a̠doni, a̠nigha̠ ma̠ a̠libhon ologi ya̠ id̠igh edim ipu ma̠ ita̠ ipa̠n ogbo.” ");
INSERT INTO mgj_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","I̠na ab̠aram agba a̠nigha̠ ma̠ O̠nyi̠ bho̠ ma̠a̠, “Anwa, Wa̠nwuna̠ bho̠, i̠le̠m a̠de bho̠ d̠a̠ o̠pu̠r ob̠eton bho̠, sa̠ ro̠b̠u̠ghu̠b̠u̠gh bho̠ i̠ro̠ ma̠ ogir a̠limon d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Awa ta̠ ekun, ya̠a̠ anwa ta̠ aro̠ kid̠ud̠ul. Awa ta̠ e̠ghu̠r eten igba̠iny ka̠ a̠rukpe ibura̠. ");
INSERT INTO mgj_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","Anwa ta̠ a̠kporokpor awa ma̠ agu̠o̠ akapa, sa̠ ta̠ obhin awa onwegina̠ ka̠ a̠rukpe ibura̠ nyen. Ya̠a̠, anwa ta̠ aro̠ ma̠ onin agu̠o̠ bho̠, sa̠ ekunuguma ko o̠ro̠ d̠o̠ d̠a̠ rala d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Orileduom ta̠ A̠zib̠a̠ aro̠ nyen ke̠re̠, ma̠ ola̠ i̠na agba a̠nigha̠ ma̠a̠, “Ro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ d̠ami̠ tu̠tu̠n ami̠ ta̠ a̠tenemeni ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠oyom okpokpolom o̠gbam a̠sike d̠inyin.” ");
INSERT INTO mgj_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","O̠ku̠a ka̠ itileduom ta̠ A̠zib̠a̠ ka̠ ogbo ya̠ i̠ro̠ eka̠? Awa aru̠mu̠gh, sa̠ i̠ro̠ ma̠ rob̠a̠ra̠motu ya̠ na̠ egir na̠ enigha̠ ma̠ ogbo ya̠ ta̠ e̠te̠i̠ itenemeni bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni̠, akpe̠ i̠yar o̠mar o̠nagha i̠di̠ar ya̠ i̠yar na̠ o̠mu̠gho̠n bho̠, b̠o̠ka̠ i̠yar umel o̠d̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Ezin bho̠ a̠duom wa̠ itileduom ta̠ A̠zib̠a̠ bho̠ i̠gba imutiom bho̠ ya̠gia̠ga̠i, sa̠ na̠ osobh ase̠ ya̠ igielake̠ na̠ ogboloma̠ ma̠ eb̠la̠ ogbo ya̠ na̠ e̠pi̠o̠gho̠m bho̠, na̠ iya̠ o̠nagha d̠o̠ ma̠ o̠nu̠o̠kpe̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","I̠yar ta̠ od̠ighi eka̠ omiza̠n ku̠gba ma̠ i̠yar oghel obom ogir itenemeni ola̠ o̠ku̠a? Wa̠nwuna̠ bho̠ na̠ agu̠o̠ a̠d̠ia̠ agba ma̠ ogir itenemeni onon a̠mutiom, sa̠ ogbo ya̠ i̠mu̠gho̠n bho̠ ibhin ra̠ i̠gba inigha̠ i̠yar ma̠ iya̠gia̠ga̠i. ");
INSERT INTO mgj_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","Sa̠ A̠zib̠a̠ a̠bhin relegh, na̠ ilologia̠n na̠ a̠d̠ien kere kere ogir ilologia̠n, na̠ atu̠gi̠ re̠ne̠ghe̠ E̠mu̠gh E̠tu̠tu̠ bho̠, a̠muzoghod̠iom asu̠gbagba d̠awa d̠a̠ i̠to̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","I̠na na̠ onigha̠ d̠o̠ ma̠ itileduom ta̠ A̠zib̠a̠ bho̠ ma̠ orileghom e̠ma ra̠ a̠nwunom, wa̠ i̠yar na̠ o̠gba na̠ ogboloma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","Kpe̠le̠me̠ni̠, u̠gba ma̠ odi esi d̠a̠ ra̠d̠ire e̠tu̠tu̠ bho̠ ma̠a̠, “ ‘O̠nyi̠o̠mo̠ro̠ni̠ ka̠ ere ma̠ ola̠ anwa na̠ aru̠ru̠an na̠ a̠gboloma̠, bo̠d̠o̠ ka̠ i̠na o̠nyi̠ ta̠ o̠ni̠ ke̠re̠ ma̠ ola̠ anwa na̠ a̠kponom’? ");
INSERT INTO mgj_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","Anwa i̠le̠m i̠na aki̠ri̠me̠ni̠ ma̠ i̠ki̠ki̠ra a̠pu ma̠ itileduom ta̠ A̠zib̠a̠, sa̠ anwa ibhin eghoi isosorogia̠n na̠ edim izuom i̠na, ");
INSERT INTO mgj_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","iguri ma̠ eb̠la̠ i̠di̠ar d̠a̠ ekpukpu a̠sike d̠o̠yo̠ ma̠ orileghom.’ ” U̠ge̠ ma̠a̠, ‘eb̠la̠ i̠di̠ar,’ o̠ku̠a na̠ a̠ma̠ra̠ ma̠a̠ abar ola̠ usigimeni bo̠. Ya̠a̠, i̠yar ta̠ o̠bi̠gh d̠o̠ ka̠ o̠nyi̠o̠mo̠ro̠ni̠ na̠ orileghom eb̠la̠ i̠di̠ar i̠se̠n. ");
INSERT INTO mgj_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","Ya̠a̠ i̠yar na̠ o̠bi̠gh A̠zizo̠s wa, ekud̠i obhel sa̠ uguri ma̠ a̠dila̠de ola̠ aki̠r a̠pu ma̠ ita̠ itileduom ta̠ A̠zib̠a̠ bho̠, b̠o̠ka̠ d̠a̠ igbirigbir ta̠ A̠zib̠a̠ i̠na a̠gbika̠ a̠mugh ebula̠ i̠yar. I̠se̠n i̠yar na̠ o̠bi̠gh ka̠ na̠ ozuom i̠na ma̠ eghoi isosorogia̠n na̠ edim, d̠a̠ ebula̠ egbika̠ omugh d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","A̠zib̠a̠ wa̠ ale̠m eb̠la̠ i̠di̠ar bho̠, ato̠ ma̠ obhin a̠d̠izo anwi̠i̠ny od̠ighom d̠a̠ isosorogia̠n d̠o̠yo̠. Sa̠ a̠bhon agu̠o̠ i̠na ab̠ab̠alame̠ni̠ ma̠ A̠zizo̠s amado̠n bho̠, d̠a̠ ebula̠ egbika̠ ya̠ A̠zizo̠s atu̠n otenemeni awa a̠gbika̠ d̠a̠ omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","O̠ku̠a bha̠ i̠se̠n, A̠zizo̠s na̠ ogbo ya̠ i̠na na̠ ab̠ab̠alame̠ni̠ a̠nigha̠ ma̠ A̠zib̠a bho̠, na̠ eten anwi̠i̠ny onin eghun. Obha̠ ezin bho̠ i̠na od̠igh d̠o̠ ma̠ ari̠ghe̠l obhelegi awa ma̠ a̠rumor na̠ aru̠marani̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","Ezin bho̠ i̠na agba a̠nigha̠ ma̠ A̠zib̠a̠ ma̠a̠, “Ami̠ ta̠ a̠sen ib̠eb̠i ya̠ d̠a̠ a̠d̠ien d̠oyom bho̠ a̠nigha̠ ma̠ a̠rumor na̠ aru̠marani̠ da̠mi̠. Ami̠ ta̠ amo̠r aso̠r a̠tutumeni nyam d̠a̠ a̠kokod̠ia̠n a̠nwunom bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","O̠lo̠gho̠m i̠se̠ sa̠ i̠na agba ma̠a̠, “Eb̠em ologi d̠ami̠ ta̠ aro̠ d̠a̠ A̠zib̠a̠.” Sa̠ a̠mula̠ agba ma̠a̠, “Ami̠ od̠i ma̠ i̠se̠n na̠ anwi̠i̠ny ya̠ A̠zib̠a̠ a̠nigha̠ ami̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","Ebula̠ agu̠o̠ anwi̠i̠ny ta̠ A̠zib̠a̠ i̠ro̠ ma̠ a̠nwunom ya̠ inwuna̠ ma̠ asi̠ na̠ ipulupul bho̠, sa̠ A̠zizo̠s a̠ten o̠ni̠ ola̠ asi̠ na̠ ipulupul. I̠na a̠gir o̠ku̠a ma̠ o̠wo̠l d̠a̠ omugh d̠o̠yo̠ o̠pi̠e̠gi̠ a̠limon ta̠ Eru bho̠, wa̠ na̠ a̠sibh a̠limon omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","Ogir o̠ko̠no̠n a̠d̠ighi kisa̠ i̠na a̠rue a̠tenemeni ma̠ ogbo ya̠, d̠a̠ eb̠la̠ a̠ghud̠um d̠awa, i̠ro̠ ma̠ igoni d̠a̠ ebula̠ i̠ku̠nu̠ omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Ya̠gia̠ga̠i i̠na na̠ alo̠gh agu̠o̠ na̠ a̠nigha̠ ma̠ anwi̠i̠ny a̠rughun ta̠ Ebraham, ya̠a̠ itileduom ta̠ A̠zib̠a̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Ebula̠ o̠ku̠a, sa̠ u̠le̠m i̠na u̠gu̠b̠e̠ni̠ ma̠ a̠rumor na̠ aru̠marani̠ d̠o̠yo̠ d̠a̠ eb̠la̠ re̠kal, b̠o̠ka̠ i̠na a̠bhin d̠a̠ igbirigbir na̠ iya̠ igielake̠ aro̠ ma̠ We̠mu̠ Okur d̠i̠yar d̠a̠ a̠misigh ta̠ A̠zib̠a̠. Sa̠ na̠ a̠d̠ighi ma̠ ola̠ a̠nwunom bho̠ na̠ e̠te̠i̠ itulugia̠n na̠ okpon i̠karabh o̠si̠ghe̠ a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","I̠se̠n i̠na na̠ a̠rue na̠ alo̠gh agu̠o̠ na̠ a̠nigha̠ ma̠ ogbo ya̠ ad̠agi̠an i̠te̠i̠, ezin bho̠ i̠na na̠ agu̠o̠ a̠gbika̠ sa̠ ad̠agi̠an i̠te̠i̠ i̠na nyen. ");
INSERT INTO mgj_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Ebula̠ o̠ku̠a, inyin a̠rumor na̠ aru̠marani̠ d̠ami̠, ogbo ya̠ A̠zib̠a̠ ab̠aram a̠bhelegi a̠d̠ighom d̠a̠ e̠gi̠ ote̠nai̠ny bho̠. Iloghoma̠ne ma̠ A̠zizo̠s wa̠ i̠yar na̠ osen bho̠ ma̠a̠, i̠na wa̠ A̠zib̠a̠ afi̠ri̠ma ma̠ o̠ro̠ o̠ni̠ ogir na̠ We̠mu̠ Okur ologi ima̠ra̠ d̠i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","I̠na a̠rugh ado̠l igielake̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠ wa̠ aso̠n i̠na bho̠, ma̠ agu̠o̠ A̠mozizi a̠gir igiel bho̠ ub̠eton eb̠la̠ eghun otu ta̠ A̠zib̠a̠ unigha̠ i̠na ma̠ orileghom bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","Ya̠a̠, akpe̠ ma̠ o̠bu̠ghu̠me̠ni̠ A̠zizo̠s opu A̠mozizi, a̠d̠ien agu̠o̠ o̠ni̠ wa̠ a̠lo ma̠ otu bho̠ a̠lei abar a̠pu ma̠ otu wa̠ i̠na a̠lo bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Ezin bho̠, eb̠la̠ a̠rutu ya̠ od̠i bho̠, o̠ni̠ na̠ a̠lo ma̠ odi i̠se̠. Ya̠a̠, A̠zib̠a̠ a̠lo kabar kabar. ");
INSERT INTO mgj_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","A̠mozizi ob̠a̠ra̠motu ola̠ a̠rugh ya̠ igielake̠ d̠a̠ otu ta̠ A̠zib̠a̠. Ogir d̠o̠yo̠ i̠ro̠ ma̠ elegh egboloma̠ ma̠ i̠di̠ar ya̠ A̠zib̠a̠ ta̠ agba a̠mutiom d̠a̠ ed̠ia̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","Ya̠a̠, Akrai̠st a̠bhin d̠a̠ a̠dila̠de O̠nyi̠ na̠ a̠rileghom otu ta̠ A̠zib̠a̠ d̠a̠ igielake̠. I̠yar eghun otu d̠o̠yo̠ ku̠gba ma̠ i̠yar o̠kparame̠ni̠ ma̠ ologi ima̠ra̠ d̠i̠yar, d̠a̠ abar wa̠ i̠yar na̠ o̠tu̠n na̠ obo d̠a̠ eb̠em ologi bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","O̠ku̠a bha̠ od̠i ma̠ agu̠o̠ E̠mu̠gh Etu̠tu̠ bho̠ agba ma̠a̠, “Ka̠ inyin u̠mu̠gho̠n okoroko d̠o̠yo̠ ma̠ a̠didon, ");
INSERT INTO mgj_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","o̠ni̠ ko o̠kparame̠ni̠ ma̠ rologi d̠inyin agu̠o̠ ibom ro̠we̠de̠ id̠ud̠ul d̠inyin iwia̠n a̠limon ta̠ A̠zib̠a̠ sa̠ i̠d̠agi̠an i̠na d̠a̠ e̠ghana bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","Awa i̠d̠agi̠an ami̠ d̠a̠ ebla̠ agu̠o̠ awa i̠bi̠gh i̠di̠ar ya̠ ami̠ igir ");
INSERT INTO mgj_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","d̠a̠ eruba̠l ala bho̠. Ebula̠ o̠ku̠a, sa̠ ologi d̠ami̠ agam a̠nigha̠ ma̠ amu̠m obha̠ ifugh ma̠a̠, ‘Rologi d̠awa na̠ e̠ru̠ru̠an ipa̠n eb̠la̠ igiel, sa̠ awa na̠ e̠b̠agh e̠mu̠ na̠ egboloma̠ ma̠ i̠to̠ d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","Sa̠ d̠a̠ i̠gam d̠ami̠, sa̠ ami̠ igurugia̠n ma̠a̠, awa ko o̠gi̠ d̠o̠ ka̠ ed̠igh ed̠e ma̠ e̠nu̠m d̠a̠ esi osira̠ epobh d̠ami̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","A̠rumor d̠ami̠ na̠ aru̠marani̠ d̠ami̠, o̠ku̠a a̠d̠ighi be̠le̠ni, o̠ni̠ inyin onwuna̠ d̠o̠ ma̠ o̠karabh ologi na̠ ab̠agh e̠mu̠ o̠d̠u̠a d̠a̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Kpe̠le̠me̠ni̠, odi akpo̠me̠ni̠ ma̠ ologi ta̠ odi ka̠d̠a̠ma̠ ka̠d̠a̠ma̠, d̠a̠ i̠to̠ e̠mu̠ a̠d̠a̠ma̠ bho̠, b̠o̠ka̠ i̠karabh igelemeni ma̠ o̠ni̠ inyin ma̠ ola̠ i̠na ta̠ ab̠agh e̠mu̠ a̠nigha̠ ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","O̠ku̠a na̠ a̠ma̠ra̠ ma̠a̠, eb̠la̠ i̠yar ta̠ o̠te̠i̠ od̠e ma̠ e̠nu̠m ogir ta̠ Akrai̠st, ku̠gba ma̠a̠ i̠yar osibh o̠pu̠r ima̠ra̠ ologi d̠i̠yar o̠kparame̠ni̠, tu̠tu̠n ta̠ ate̠i̠ ekunuguma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","I̠ru̠ru̠ane̠ ma̠ iya̠ u̠gba d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ ma̠a̠: “Igiel inyin u̠mu̠gho̠n okoroko d̠o̠yo̠ ma̠ a̠didon, o̠ni̠ ko o̠b̠agh e̠mu̠ ma̠ agu̠o̠ ibom ro̠we̠de̠ id̠ud̠ul d̠inyin, ma̠ igiel bho̠ awa iwia̠n a̠limon ta̠ A̠zib̠a̠ igurumeni ma̠ ologi d̠o̠yo̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","Ya̠a̠, wa̠ a̠nyen ogbo ya̠ i̠mu̠gho̠n okoroko ta̠ A̠zib̠a̠, ku̠ku̠m eka̠ sa̠ iwia̠n a̠limon d̠o̠yo̠ igurumeni ma̠ ologi bho̠? Eb̠la̠ a̠nwunom ya̠ A̠mozizi a̠rileghom a̠mutiom d̠a̠ Izipt bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Wa̠ a̠nyen ogbo ya̠ i̠na agam i̠gam a̠nigha̠ ma̠ eruba̠l rala bho̠? I̠nye̠ ogbo ya̠ igir i̠karabh sa̠ imugughu, sa̠ regua̠de d̠awa i̠ro̠ i̠b̠o̠r d̠a̠ e̠ghana bho̠ d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Ya̠a̠, wa̠ a̠nyen ogbo ya̠ agba a̠gboloma̠ ma̠ igiel bho̠ i̠na a̠gurugia̠n ma̠a̠, “Awa ko o̠gi̠ d̠o̠ ka̠ ed̠igh d̠a̠ esi osira̠ epobh d̠ami̠” bho̠? Ogbo ya̠ i̠b̠agh e̠mu̠ inigha̠ i̠na bho̠ d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","O̠ku̠a sa̠ i̠yar na̠ o̠bi̠gh ma̠ agbo̠ d̠a̠ agu̠o̠ awa oma̠ra̠ d̠o̠ bho̠, sa̠ awa orue d̠o̠ ma̠ od̠igh d̠a̠ esi osira̠ epobh d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","A̠zib̠a̠ na̠ a̠sibh ogua̠n wa̠ i̠na a̠gua̠n ma̠a̠, i̠yar ta̠ od̠igh d̠a̠ esi osira̠ epobh d̠o̠yo̠ bho̠. Ku̠ku̠m eka̠, i̠yar ta̠ okpona̠, b̠o̠ka̠ bebena̠ o̠ni̠ inyin na̠ o̠pi̠o̠m (omel ad̠u̠a) ma̠ ola̠ i̠na ko o̠te̠i̠ d̠o̠ a̠d̠igh. ");
INSERT INTO mgj_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","O̠lo̠gho̠m i̠se̠, i̠yar na̠ o̠mu̠gho̠n ani̠ ma̠ ib̠eb̠i asu̠gbagba ya̠ u̠gba unigha̠ i̠yar bho̠, ma̠ agu̠o̠ awa i̠mu̠gho̠n bho̠. Ya̠a̠, id̠igh d̠o̠ ma̠ asu̠o̠ enigha̠ awa ma̠ igiel bho̠ awa i̠mu̠gho̠n bho̠, ezin bho̠ awa inwuna̠ d̠o̠ ma̠ ologi ima̠ra̠ wa̠ o̠da asu̠gbagba bho̠ obhin. ");
INSERT INTO mgj_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","I̠yar ogbo ya̠ na̠ oma̠ra̠ ma̠ i̠se̠n bho̠ na̠ o̠te̠i̠ od̠igh d̠a̠ esi osira̠ epobh wa̠ A̠zib̠a̠ a̠gua̠n bho̠ ma̠ agu̠o̠ i̠na agba ma̠a̠, “Ami̠ ibhin d̠a̠ i̠gam a̠gurugia̠n ma̠a̠, awa ko od̠igh d̠o̠ d̠a̠ esi osira̠ epobh d̠ami̠.” A̠zib̠a̠ a̠kunugiom o̠le̠m i̠di̠ar ka̠ igiel bho̠ i̠na alem e̠ma ra̠nwunom awe̠le̠ bho̠; ku̠ku̠m eka̠, i̠na agba ma̠ o̠ku̠a a̠mutiom. ");
INSERT INTO mgj_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","I̠na agba ma̠ odi esi d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ a̠gboloma̠ ma̠ oleghemeni od̠ua̠l a̠d̠a̠ma̠ bho̠ ma̠a̠, “Igiel bho̠ A̠zib̠a̠ ale̠m i̠di̠ar a̠kunugiom bho̠, sa̠ i̠na a̠sira̠ ma̠ epobh oleghemeni od̠ua̠l a̠d̠a̠ma̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","D̠a̠ onin esi obha̠ sa̠ i̠na agba a̠numeta̠n ma̠a̠, “Awa ko od̠igh d̠o̠ d̠a̠ esi osira̠ epobh d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Agu̠o̠ na̠ aro̠ ma̠ ola̠ idi ogbo ta̠ ed̠igh d̠a̠ esi osira̠ epobh bho̠, sa ogbo ya̠ ud̠ia̠ u̠gba ma̠ ib̠eb̠i asu̠gbagba bho̠ unigha̠ bho̠ ko od̠igh d̠o̠, d̠a̠ ebula̠ agu̠o̠ awa i̠b̠agh e̠mu̠ i̠we̠le̠ ma̠ o̠da obhin bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","sa̠ A̠zib̠a̠ a̠nwe a̠gua̠n opa̠n a̠d̠a̠ma̠ ola̠ i̠yar ta̠ orue od̠igh. “A̠didon” a̠d̠a̠ma̠ bho̠. D̠a̠ obhel ola̠ na̠ a̠bia̠ ma̠ o̠gu̠man, sa̠ i̠na awo̠l d̠a̠ o̠nu̠ ta̠ A̠devidi agba a̠mutiom agu̠o̠ i̠na agba ma̠ i̠se bho̠ ma̠a̠, “Ka̠ inyin u̠mu̠gho̠n okoroko ta̠ A̠zib̠a̠ ma̠ a̠didon, o̠ni̠ ko o̠b̠agh e̠mu̠ ma̠ e̠we̠le̠man o̠nagha.” ");
INSERT INTO mgj_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","Aro̠ ma̠ ola̠ A̠zosu̠a a̠rileghom awa ka̠ a̠d̠ighom d̠a̠ esi osira̠ epobh nab̠o̠, A̠zib̠a̠ ka̠ ifugh d̠o̠ a̠gboloma̠ ma̠ a̠d̠a̠ma̠ onon d̠a̠ obhel o̠gu̠man. ");
INSERT INTO mgj_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","Ebula̠ o̠ku̠a, na̠ oguri ma̠ A̠d̠a̠ma̠ Osira̠-epobh osisa̠n a̠nwunom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","O̠ku̠a bha̠, o̠ni̠ ola̠ ta̠ a̠bhin d̠a̠ e̠b̠e̠l a̠d̠igh a̠d̠e d̠a̠ esi osira̠ epobh ta̠ A̠zib̠a̠, o̠ni̠ bho̠ eka̠ ta̠ a̠gir ogir o̠yo̠ a̠sira̠ ma̠ epobh, ma̠ agu̠o̠ A̠zib̠a̠ a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","O̠ku̠a a̠d̠ighi be̠le̠ni̠, owia̠n od̠igh d̠a̠ esi osira̠ epobh obha̠ d̠a̠ e̠b̠e̠l, b̠o̠ka̠ o̠ni̠ i̠yar na̠ omugh a̠bhe d̠a̠ ebula̠ ab̠agh e̠mu̠ ma̠ agu̠o̠ awa. ");
INSERT INTO mgj_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Ezin bho̠, o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ od̠i d̠a̠ a̠ghud̠um sa̠ na̠ a̠lol, sa̠ a̠sibh a̠pu ma̠ ab̠e̠ge̠re̠ (ogidi i̠wal-aman). Sa̠ na̠ a̠gu na̠ a̠d̠igh d̠a̠ eloghoma̠n ozu na̠ e̠mu̠gh o̠ni̠, ma̠ o̠bagi̠o̠n awa d̠a̠ re̠tu̠tu̠la na̠ ali̠si̠, sa̠ na̠ a̠rue na̠ agba ma̠ e̠wo̠gi̠na i̠ru̠ruan na̠ i̠walama ologi. ");
INSERT INTO mgj_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Bebina̠ abar ola̠ u̠le̠m usoroni d̠a̠ a̠de onon, ola̠ awo̠gi̠na d̠a̠ a̠misigh ta̠ A̠zib̠a̠ bo̠. Kpe̠le̠me̠ni̠ bha̠, na̠ ob̠ugh kabarkabar omutiom e̠ma, d̠a̠ a̠misigh o̠ni̠ wa̠ i̠yar ta̠ o̠gba ma̠ ado̠l d̠i̠yar onigha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠kpaghano̠m id̠umom d̠i̠yar. Ezin bho̠, i̠yar onwuna̠ ma̠ A̠zizo̠s O̠nyi̠ ta̠ A̠zib̠a̠, obom We̠mu̠ Okur wa̠ na̠ a̠bhun d̠a̠ ote̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","I̠yar unwuna̠ d̠o̠ ma̠ We̠mu̠ Okur ola̠ orue d̠o̠ ma̠ okpon i̠yar igbirigbir d̠a̠ rasu̠nwe̠r d̠i̠yar. Ya̠a̠, i̠yar unwuna̠ ma̠ We̠mu̠ Okur ola̠ a̠d̠izo re̠kal ad̠agi̠an i̠te̠i̠ agu̠o̠ na̠ e̠te̠i̠ i̠yar i̠se̠n bho̠, ku̠ku̠m eka̠ i̠na na̠ omel d̠o̠ a̠d̠igh d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Ebula̠ o̠ku̠a, obhin d̠a̠ alu̠kpo̠ ologi od̠igh d̠a̠ a̠lukpesi e̠ne̠ghe̠ ta̠ A̠zib̠a̠, b̠o̠ka̠ i̠yar o̠te̠i̠ okpon igbirigbir na̠ o̠lo̠gh agu̠o̠, d̠a̠ obhel i̠kparama ado̠l. ");
INSERT INTO mgj_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Na̠ okpon d̠a̠ esa̠d̠io a̠nwunom bho̠ na̠ o̠so̠n ghan we̠mu̠ rokur, b̠o̠ka̠ i̠na amara ma̠ eni d̠a̠ a̠misigh ta̠ A̠zib̠a̠ ako̠l i̠ko̠l akpe̠ ma̠ alu̠kpe̠ ya̠ otenemeni awa d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","Agu̠o̠ i̠na eka̠ na̠ a̠dugh a̠ludugh bho̠, sa̠ i̠na na̠ a̠rue na̠ a̠bhin odudugha̠n ologi na̠ a̠kpon ogbo ya̠ ologhoma̠n d̠o̠ sa̠ na̠ egir i̠karabh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Ebula̠ o̠ku̠a, sa̠ aro̠ ma̠ ola̠ i̠na ta̠ akpe̠ ma̠ alu̠kpe̠ a̠gboloma̠ ma̠ i̠karabh d̠o̠yo̠, na̠ i̠karabh a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","O̠ni̠ ola̠ i̠na na̠ agu̠o̠ ta̠ a̠rue ate̠i̠ a̠d̠ien a̠dila̠de edim onon bo̠, a̠ten ka̠ A̠zib̠a̠ a̠bhelegi i̠na ma̠ agu̠o̠ a̠bhelegi ma̠ Ero̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","Onin agu̠o̠ bho̠ Akrai̠st na̠ agu̠o̠ o̠re̠ma d̠o̠ ma̠ alu̠bu̠gh a̠ten we̠mu̠ rokur. Kpe̠le̠me̠ni̠ bha̠ A̠zib̠a̠ ka̠ agba a̠nigha̠ i̠na ma̠a̠, “Anwa O̠nyi̠ d̠ami̠. Ob̠eton a̠didon, ami̠ na̠ a̠ten o̠we̠de̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","Onin agu̠o̠ bho̠ A̠zib̠a̠ agba ma̠ opa̠n esi ma̠a̠, “Anwa okur ola̠ ta̠ aro̠ tu̠tu̠n ka̠ id̠ud̠ul, ola̠ a̠d̠ien e̠mar ed̠ighiom i̠di̠ar ta̠ Ame̠lki̠ze̠de̠k. ");
INSERT INTO mgj_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","D̠a̠ a̠ghud̠um d̠o̠yo̠ d̠a̠ e̠mara̠nwunom, i̠na a̠siseiny a̠siseiny, a̠puru ma̠ okpon igbirigbir, a̠leghe ma̠ ed̠i agba ma̠ igbir a̠nigha̠ ma̠ A̠zib̠a̠ wa̠ a̠nwuna̠ ma̠ a̠limon otenemeni o̠yo̠ d̠a̠ omugh bho̠. Sa̠ A̠zib̠a̠ awo̠ran i̠na d̠a̠ ebula̠ o̠ki̠ri̠me̠ni̠ o̠zu igielake̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","Ebla̠ agu̠o̠ i̠na aro̠ ma̠ Onyi̠ ta̠ A̠zib̠a̠ bho̠ eka̠, i̠na a̠bhin egbika̠ ya̠ i̠na a̠gbika̠ bho̠ atu̠ghan o̠ki̠ri̠me̠ni̠ o̠zu. ");
INSERT INTO mgj_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","Igiel bho̠ na̠ o̠b̠ab̠a̠le̠ni̠ i̠na o̠mado̠n bho̠, sa̠ i̠na aro̠ ma̠ eten wa̠ ogbo ya̠ id̠umom i̠na ta̠ e̠wol e̠te̠i̠ a̠ghud̠um ka̠ id̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","Sa̠ A̠zib̠a̠ a̠guri i̠na ma̠ a̠dila̠de we̠mu̠ rokur, ola̠ a̠d̠ien e̠mar ed̠ighiom i̠di̠ar ta̠ Ame̠lki̠ze̠de̠k. ");
INSERT INTO mgj_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","I̠di̠ar ya̠ o̠gba ogboloma̠ o̠yo̠ a̠b̠utu, ya̠a̠ ta̠ akpar ogba o̠si̠se̠ghe̠ni̠ onigha̠ inyin, ezin bho̠ i̠nyin na̠ o̠b̠o̠ri̠o̠m o̠mu̠gho̠nyan abar. ");
INSERT INTO mgj_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","Obhel amar aro̠ a̠nigha̠ inyin oten ogbo atu̠ghu̠me̠ni̠ ma̠ i̠se̠n, ya̠a̠ od̠id̠ia̠ ma̠ ola̠ opa̠n o̠ni̠ ta̠ a̠mula̠ atu̠ghu̠me̠ni̠ inyin i̠pu̠r ed̠ighiom i̠di̠ar imutuma̠ ta̠ A̠zib̠a̠. O̠ku̠a̠ bha̠ inyin na̠ oten ogbo ya̠ ta̠ onigha̠ amu̠mam amu̠mam, kpe̠le̠me̠ni̠ ma̠ ikpo ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Ko̠ni̠ko̠ni̠ ola̠ na̠ amam amu̠mam od̠id̠ia̠ ma̠ o̠gbara o̠nyi̠, ola̠ ta̠ o̠mu̠gho̠nyan d̠o̠ ma̠ atu̠ghu̠me̠ni̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","Ya̠a̠, ikpo ed̠ia̠n i̠ro̠ inigha̠ ma̠ ogbo ya̠ na̠ ed̠ikighu ma̠ aru̠mu̠, ya̠ na̠ e̠tu̠ghan e̠ku̠ro̠m sa̠ na̠ erue na̠ eloghom a̠nwegia̠n ta̠ i̠karabh na̠ ib̠eb̠i. ");
INSERT INTO mgj_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni, owia̠n eloghom abar d̠i̠yar d̠a̠ Akrai̠st a̠pel ya̠ i̠yar u̠tu̠ghan d̠a̠ o̠pu̠r ob̠eton bho̠. Omula̠ d̠o̠ o̠gi̠ d̠a̠ a̠dila̠de ola̠ na̠ a̠puru ma̠ okpon i̠karabh o̠si̠ghe̠ a̠d̠ien, d̠a̠ ebula̠ od̠ighi i̠di̠ar ya̠ eb̠em ologi o̠to̠ d̠a̠ A̠zib̠a̠; ");
INSERT INTO mgj_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","na̠ i̠to̠to̠gi̠ o̠b̠ab̠alame̠ni̠ ozu, na̠ o̠gbamagi̠ aru̠gu̠o̠, na̠ ob̠etina̠ d̠a̠ omugh, na̠ ebhum ase̠ ekunuguma̠ o̠to̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","Akpe̠ i̠yar ogir o̠ku̠a, d̠a̠ okpon igbirigbir ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Ta̠ akpar ogbo ya̠ na̠ ed̠ia̠ e̠ro̠ d̠a̠ e̠b̠alab̠al bho̠ e̠d̠e̠d̠i̠ma ma̠ e̠ne̠ghe̠ ote̠nai̠ny, sa̠ id̠e̠d̠ia̠n na̠ Ob̠eb̠i E̠mu̠gh bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","e̠bi̠gh e̠no̠gho̠man o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ na̠ ra̠limon amu̠m wa̠ na̠ a̠ru bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ma̠ orue otiba̠ra̠ d̠a̠ i̠karabh ku̠gba ma̠ awa emel e̠d̠u̠a. O̠ku̠a bha̠ awa na̠ enwe na̠ egigh o̠nyi̠ ta̠ A̠zib̠a̠ d̠a̠ e̠mi̠gi̠re̠ni̠an oriren bho̠, na̠ e̠lo̠gi̠ i̠na ma̠ ari̠ghe̠l na̠ emutiom e̠ma. ");
INSERT INTO mgj_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","A̠zib̠a̠ na̠ a̠tutumeni ma̠ a̠de wa̠ na̠ a̠mibh gha̠n amu̠m o̠lo̠bha wa̠ na̠ a̠ba̠ra̠ ma̠ o̠lo̠bho̠m o̠yo̠ bho̠, sa̠ na̠ a̠b̠om ib̠eb̠i ed̠ia̠n na̠ a̠nigha̠ ma̠ ogbo ya̠ igbebh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","Ya̠a̠, a̠de ola̠ a̠d̠igh ib̠ub̠ulom na̠ ralai̠-agbo̠gi̠ri̠ bha̠ obhobho i̠kpo̠ a̠de, ola̠ na̠ orogi sa̠ ta̠ o̠bhu̠gi̠ d̠a̠ ekunuguma̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","Ib̠eb̠i ra̠tologha̠n d̠i̠yar, eb̠la̠ agu̠o̠ o̠nu̠o̠kpe̠ d̠i̠yar aro̠ ma̠ o̠ku̠a bho̠ eka̠, i̠yar uma̠ra̠ ma̠a̠ inyin ta̠ o̠te̠i̠ ibom e̠no̠gho̠man ya̠ uguri usisa̠n ogbo ya̠ na̠ otenemeni bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","A̠zib̠a̠ na̠ o̠gba d̠o̠ ma̠ ipa̠n a̠gir ipa̠n. I̠na ko oweleta̠n d̠o̠ ma̠ ogir d̠inyin, na̠ agu̠o̠ inyin na̠ obhin na̠ otula̠n a̠d̠ien d̠o̠yo̠ bho̠, ma̠ o̠lo̠gh agu̠o̠ ya̠ inyin na̠ o̠lo̠gh na̠ onigha̠ ma̠ ogbo-ogir d̠o̠yo̠ bho̠, sa̠ inyin od̠id̠ia̠ na̠ ogir o̠ku̠a bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Na̠ ebhir i̠yar o̠bi̠gh ma̠a̠, ko̠ni̠ko̠ni̠ inyin na̠ a̠bhin d̠a̠ onin onyen ologi bho̠ na̠ a̠gir ya̠ o̠te̠i̠ imuzoghod̠iom eb̠em ologi d̠o̠yo̠ tu̠tu̠n ekunuguma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","I̠yar u̠bho̠ro̠gh d̠o̠ inyin o̠gbu̠o̠r, ya̠a̠ i̠ta ma̠ ogbo ya̠ ibhin d̠a̠ ologi ima̠ra̠ na̠ a̠ma̠ne i̠te̠i̠ i̠d̠i̠ar ya̠ ugua̠n uguri bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","Igiel bho̠ A̠zib̠a̠ a̠gua̠n a̠nigha̠ ma̠ Ebraham bho̠, i̠na na̠ agu̠o̠ a̠sibhigha̠n d̠a̠ ebula̠ agu̠o̠ o̠ni̠ ola̠ a̠pu i̠na o̠ro̠ d̠o̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","agba ma̠a̠, “D̠a̠ itutumeni, ami̠ ta̠ a̠tutumeni nyam ga̠i, d̠a̠ i̠mara sa̠ ami̠ ta̠ a̠d̠ighi ma̠ o̠la anwa ta̠ amaragi̠an a̠b̠utu anwi̠i̠ny. ");
INSERT INTO mgj_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","Igiel bho̠ i̠na na̠ a̠ne a̠b̠ara̠ bho̠, sa̠ i̠na ate̠i̠ abar wa̠ uguan unigha̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","A̠nwunom na̠ ebhin a̠d̠ien o̠ni̠ ola̠ a̠pu awa na̠ esibhigha̠, sa̠ eb̠la̠ raku̠anan d̠awa na̠ ekun agu̠o̠ ola̠ i̠zo̠ bho̠ ta̠ amara. ");
INSERT INTO mgj_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","A̠zib̠a̠ abho̠ro̠gh o̠mar oleriom ogbo ya̠ ta̠ e̠te̠i̠ abar wa̠ i̠na a̠gua̠n a̠nigha̠ awa bho̠, ma̠ i̠na na̠ onwe gha̠n o̠nu̠ d̠a̠ i̠to̠ d̠o̠yo̠, sa̠ a̠d̠ia̠n i̠zo̠ alo̠gho̠m. ");
INSERT INTO mgj_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","A̠zib̠a̠ a̠gir o̠ku̠a ma̠ agu̠o̠ ola̠, ta̠ awo̠l d̠a̠ i̠wal i̠di̠ar ya̠ onwegia̠n gha̠n sa̠ i̠mara ma̠ A̠zib̠a̠ na̠ o̠gba d̠o̠ ma̠ igunugha̠. Ebula̠ o̠ku̠a, akpe̠ i̠yar ogbo ya̠ na̠ od̠igh ed̠oghotu d̠a̠ agu̠o̠ d̠o̠yo̠ bho̠, ma̠ osibh abar eb̠em ologi wa̠ uguri usisa̠n i̠yar bho̠ o̠kparame̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Eb̠em ologi onon wa̠ i̠yar unwuna̠ bho̠, bha̠ a̠limon wa̠ na̠ a̠sibh rologi d̠i̠yar na̠ akparame̠ni̠ na̠ a̠guri d̠a̠ eko bho̠. Na̠ awo̠l na̠ a̠ten e̠nu̠ bho̠ na̠ a̠d̠igh d̠a̠ a̠lukpesi e̠tu̠tu̠ d̠a̠ otuta̠zib̠a̠, ");
INSERT INTO mgj_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","esi wa̠ A̠zizo̠s a̠d̠ia̠ agi̠ ka̠ a̠d̠igh d̠a̠ ebula̠ i̠yar bho̠. I̠se̠n i̠na na̠ a̠ten we̠mu̠ rokur kid̠ud̠ul, d̠a̠ a̠d̠ien ed̠ighiom i̠di̠ar ta̠ Ame̠lkize̠de̠k. ");
INSERT INTO mgj_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Ame̠lkize̠de̠k onon aro̠ ma̠ o̠li̠le̠ma Asale̠m na̠ okur ta̠ A̠zib̠a̠ Wagi̠manyu̠ A̠pu bho̠. I̠na a̠mutuma̠ ma̠ Ebraham a̠tutumeni, ma̠ igiel bho̠ Ebraham ane̠gi̠me̠ni̠ ma̠ aru̠lala e̠ma bho̠ sa̠ na̠ a̠mula̠ na̠ a̠yel bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","sa̠ Ebraham a̠nigha̠ i̠na ma̠ odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh d̠a̠ eb̠la̠ i̠di̠ar ya̠ i̠na a̠bhin bho̠. O̠pu̠r ezin a̠d̠ien ta̠ Ame̠lkizede̠k bha̠ “o̠li̠le̠ma e̠b̠ab̠ala”, opa̠n ezin sa̠ aro̠ ma̠ “o̠li̠le̠ma ekima̠.” ");
INSERT INTO mgj_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","I̠na o̠wede̠ bo̠ onweni bo̠, o̠la-imitia̠n ibom ro̠we̠de̠ na̠ ronweni id̠ud̠ul bo̠, i̠na na̠ onwuna̠ d̠o̠ ma̠ obhel eru a̠ghud̠um na̠ obhel oyel nyen, ya̠a̠ u̠le̠m i̠na o̠gu̠b̠e̠ni̠ ma̠ O̠nyi̠ ta̠ A̠zib̠a̠, sa̠ aro̠ ma̠ okur tu̠tu̠n kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","Ikpone ma̠ ed̠ighom e̠mi̠ alu̠bu̠gh d̠o̠yo̠; aga̠i Ebraham wa̠ aro̠ ma̠ obom o̠we̠de̠ id̠ud̠ul bho̠ eka̠, a̠nigha̠ i̠na ma̠ odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh d̠a̠ i̠di̠ar ya̠ ilei abar ipu d̠a̠ ologi i̠di̠ar ya̠ i̠na a̠bhin bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","Oloko bho̠ a̠nigha̠ ma̠ a̠limon anwi̠i̠ny imitia̠n ta̠ A̠livai̠ ya̠ id̠igh rokur bho̠, ma̠ obhin odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh d̠a̠ aru̠gu̠o̠ a̠nwunom bho̠. O̠ku̠a na̠ a̠ma̠ra̠ ma̠a̠, awa na̠ ebhin d̠a̠ aru̠gu̠o̠ a̠nwunom ya̠ i̠ro̠ ma̠ anwi̠i̠ny a̠rughun Izre̠l agu̠o̠ awa, ya̠ i̠ro̠ ani̠ ma̠ imitia̠n ta̠ Ebraham bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","Ame̠lkize̠de̠k na̠ omite̠ d̠o̠ d̠a̠ o̠la ta̠ A̠livai̠, ku̠ku̠m eka̠ i̠na a̠bhin odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh bho̠ d̠a̠ agu̠o̠ ta̠ Ebraham a̠tutumeni i̠na o̠ni̠ wa̠ rogua̠n ta̠ A̠zib̠a̠ i̠ro̠ inigha̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","Ologhom ma̠a̠ o̠ni̠ wa̠ a̠lei abar a̠pu bho̠ na̠ a̠tutumeni gha̠n o̠ni̠ wa̠ aki̠r a̠pu i̠na bho̠, aku̠anan bo̠no̠bo̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","D̠a̠ e̠kal wa̠ igboloma̠ ma̠ rokur bho̠, bha̠ a̠nwunom ya̠ ta̠ emugughu na̠ ebhin odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh bho̠; ya̠a̠ d̠a̠ opa̠n e̠kal, bha̠ i̠na wa̠ u̠gba umutiom ma̠ od̠i d̠a̠ a̠ghud̠um bho̠ na̠ a̠bhin. ");
INSERT INTO mgj_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","D̠a̠ agu̠o̠ o̠gba bha̠, aga̠i A̠levai̠ wa̠ na̠ a̠bhin odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh bho̠ eka̠, awo̠l d̠a̠ Ebraham akpe̠ ghan odi a̠bin d̠a̠ atu̠gi̠ a̠d̠iobh bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","ezin bho̠ A̠livai̠ od̠id̠ia̠ d̠a̠ eghun obom o̠we̠de̠ id̠ud̠ul d̠o̠yo̠ ma̠ igiel bho̠ Ame̠lkize̠de̠k ate̠i̠ Ebraham bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","Ku̠gba ma̠a̠, a̠nwunom ta̠ erue e̠wo̠l d̠a̠ i̠to̠to̠gi̠ ta̠ rokur ya̠ i̠ro̠ ma̠ imitia̠n ta̠ A̠livai̠ bho̠ e̠te̠i̠ e̠b̠ab̠ala, ma̠ agu̠o̠ i̠nye̠ i̠gbo̠ d̠a̠ oloko bho̠ imite bho̠, ka̠ ezin wa̠ opa̠n okur ola̠ a̠nwuna̠ ma̠ a̠d̠ien ed̠ighiom i̠di̠ar ta̠ Ame̠lkize̠de̠k ta̠ a̠mite a̠ru bho̠, ola̠ obhin d̠o̠ ma̠ ita̠ Ero̠n bho̠, ka̠ ere? ");
INSERT INTO mgj_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","Ezin bho̠, igiel a̠dila̠de okur bho̠ a̠nwegia̠n, bha̠ oloko bho̠ eka̠ ta̠ awegia̠n nyen. ");
INSERT INTO mgj_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","O̠ni̠ wa̠ na̠ o̠gba ma̠ i̠di̠ar i̠nye̠n na̠ ogboloma̠ bho̠, a̠mite d̠a̠ opa̠n ebhugh. Ebhugh d̠o̠yo̠ ta̠ od̠ia̠ d̠o̠ emutiom o̠ni̠ ola̠ na̠ aro̠ ato̠to̠gi̠ ma̠ i̠to̠to̠gi̠ d̠a̠ enwen bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","O̠mar ologhom ma̠a̠, Wa̠nwuna̠ wa̠ na̠ o̠gba ma̠ i̠di̠ar i̠nye̠n na̠ ogboloma̠ bho̠ a̠mite d̠a̠ eghun ta̠ A̠zuda̠, sa̠ A̠mozizi na̠ osen d̠o̠ ma̠ eghun obha̠ a̠gboloma̠ ma̠ a̠dila̠de okur. ");
INSERT INTO mgj_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","Ta̠ o̠mar o̠mu̠gho̠nyan abar wa̠ i̠yar u̠gba bho̠, ma̠ agu̠o̠ opa̠n okur ola̠ a̠nwuna̠ ma̠ a̠d̠ien ed̠ighiom i̠di̠ar ta̠ Ame̠lkize̠de̠k na̠ a̠mite bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","i̠na wa̠ od̠i ma̠ a̠dila̠de okur, ola̠ o̠tu̠o̠no̠m d̠o̠ ma̠ i̠to̠to̠gi̠ oloko e̠ma-ra̠nwunom o̠ri̠lo̠me̠ni̠, ya̠a̠ ubhin d̠a̠ a̠limon a̠ghud̠um wa̠ ekunuguma̠ o̠to̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","U̠gba d̠a̠ a̠d̠ire e̠tu̠tu̠ bho̠ omutiom ma̠a̠, “Anwa ta̠ aro̠ ma̠ okur tu̠tu̠n kid̠ud̠ul, ola̠ a̠nwuna̠ ma̠ a̠d̠ien ed̠ighiom i̠di̠ar ta̠ Ame̠lkize̠de̠k.” ");
INSERT INTO mgj_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","Na̠ ogbogion ugba̠iny oloko bho̠, ezin bho̠ odudugha̠n na̠ obhobho i̠kpo̠ abar. ");
INSERT INTO mgj_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","Ezin bho̠, abar ola̠ oloko bho̠ a̠rue ma̠ o̠b̠ab̠alame̠ni̠ bo̠, ya̠a̠ na̠ omutiom eb̠em ologi ola̠ a̠bhon a̠pu, ola̠ ta̠ o̠wo̠l o̠te̠i̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","O̠tu̠o̠no̠m i̠se̠ bha̠, i̠na na̠ od̠igh d̠o̠ ma̠ okur ola̠ A̠zib̠a̠ od̠ia̠n d̠o̠ ma̠ i̠zo̠ a̠gboloma̠, ya̠a̠ ubhin d̠o̠ ma̠ i̠zo̠ o̠lo̠gi̠ ma̠ a̠nwunom iyed̠i ma̠ rokur. ");
INSERT INTO mgj_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","Ya̠a̠ A̠zib̠a̠ a̠d̠ia̠n i̠zo̠ alo̠gh i̠na ma̠ okur agba a̠nigha̠ i̠na ma̠a̠, “Wa̠nwuna̠ bho̠ na̠ a̠sibhigha̠ sa̠ i̠na ko onwe d̠o̠ ma̠ o̠nu̠. Anwa ta̠ aro̠ ma̠ okur tu̠tu̠n kid̠ud̠ul.” ");
INSERT INTO mgj_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Ebula̠ o̠ku̠a, sa̠ A̠zizo̠s a̠ten o̠ni̠ wa̠ na̠ amara ma̠ eni na̠ a̠leriom ma̠a̠ omom i̠zo̠ bho̠ a̠bhon a̠pu. ");
INSERT INTO mgj_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","Opa̠n a̠nwegia̠n od̠i, ezin bho̠, a̠d̠izo rokur iyed̠i imugughu d̠a̠ egum sa̠ i̠ro̠ d̠o̠ d̠a̠ a̠dila̠de bho̠ egir e̠gi̠o̠m d̠a̠ ed̠ia̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","Agu̠o̠ A̠zizo̠s od̠i d̠a̠ a̠ghud̠um tu̠tu̠n kid̠ud̠ul bho̠, bha̠ ogir okur d̠o̠yo̠ na̠ okunugiom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","Ebula̠ o̠ku̠a sa̠ i̠na na̠ a̠rue na̠ a̠tenemeni ma̠ ogbo ya̠ na̠ e̠wo̠l d̠o̠yo̠ ma̠ o̠te̠i̠ A̠zib̠a̠ bho̠. Ezin bho̠ i̠na na̠ a̠rugh a̠ghud̠um o̠mara eni onigha̠ awa d̠a̠ a̠misigh ta̠ A̠zib̠a̠ kigiel kigiel. ");
INSERT INTO mgj_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","O̠ku̠a bha̠ i̠na we̠mu̠ okur ola̠ igielake̠ na̠ e̠b̠ab̠ala, o̠ni̠ abar o̠li̠o̠m o̠to̠ na̠ i̠karabh o̠to̠. Uguri i̠na osigimeni ma̠ id̠ighi ma̠ i̠karabh, sa̠ ub̠eton i̠na u̠gi̠o̠m anyu̠ upeleni ma̠ re̠nai̠ny bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","I̠na bo̠ ma̠ agu̠o̠ ogbo aru̠mu̠ rokur iyed̠i. A̠dila̠de okur d̠o̠yo̠ na̠ opuru d̠o̠ i̠na ma̠ o̠kpe̠gi̠ ralu̠kpe̠ ka̠d̠a̠ma̠ ka̠d̠a̠ma̠, ya̠ od̠ia̠ obhin otenemeni i̠karabh d̠o̠yo̠, sa̠ i̠na ta̠ akpe̠gi̠ ma̠ iya̠ otenemeni i̠karabh a̠nwunom bho̠. I̠na a̠nigha̠ ma̠ a̠ghud̠um d̠o̠yo̠ a̠bhin akpe̠ ma̠ i̠karabh d̠awa ma̠ onin ogbudon sa̠ a̠munia̠n i̠se̠. ");
INSERT INTO mgj_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","Ogbo aru̠mu̠ rokur ya̠ oloko bho̠ na̠ alo̠gi̠ bho̠ idudugha̠n d̠a̠ re̠kal, ya̠a̠ i̠zo̠ wa̠ a̠ru ma̠ o̠gu̠man bho̠ aso̠n i̠na O̠nyi̠ bho̠, wa̠ na̠ o̠b̠ab̠alame̠ni̠ oguri tu̠tu̠n kid̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","Onon e̠mu̠ abar wa̠ i̠yar na̠ o̠gba bho̠. I̠yar unwuna̠ ma̠ we̠mu̠ okur ola̠ od̠i ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ a̠lukpesi ta̠ Wa̠lei Abar A̠pu bho̠ d̠a̠ renai̠ny. ");
INSERT INTO mgj_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","I̠na ob̠a̠ra̠motu e̠b̠ab̠ala d̠a̠ a̠lukpesi e̠tu̠tu̠ bho̠ na̠ a̠ga̠i otu-akpu̠ru̠ wa̠ A̠zib̠a̠ a̠gim bho̠, wa̠ o̠nyi̠o̠mo̠ro̠ni̠ ogim d̠o̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","We̠mu̠ okur we̠mu̠ okur ola̠ u̠so̠n na̠ a̠bhin gha̠n i̠di̠ar e̠ne̠ghe̠ na̠ i̠nam i̠ko̠l na̠ ako̠l i̠ko̠l. O̠ku̠a a̠d̠ighi be̠le̠ni̠, sa̠ a̠bhon we̠mu̠ okur onon onwuna̠ ani̠ abar ola̠ obhin o̠kpe̠ alu̠kpe̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","Aro̠ ma̠ ola̠ i̠na od̠i d̠a̠ e̠mara̠nwunom nab̠o̠, i̠na ka̠ id̠igh d̠o̠ na̠ od̠igh okur, ezin bho̠ rokur ya̠ na̠ e̠tu̠o̠no̠m oloko bho̠ na̠ ebhin i̠di̠ar e̠ne̠ghe̠ na̠ e̠kpe̠ ma̠ alu̠kpe̠ od̠i. ");
INSERT INTO mgj_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","I̠ko̠l d̠awa od̠i ka̠ o̠ru̠ran abar ola̠ na̠ egir na̠ e̠gu̠b̠e̠ni̠ ma̠ od̠ighi i̠di̠ar ote̠nai̠ny. Obha̠ ezin bho̠ u̠kparame̠ni̠ ukikiom A̠mozizi ma̠ igiel bho̠ i̠na na̠ ra̠ ogim otu-akpu̠ru̠ ta̠ A̠zib̠a̠ bho̠ ma̠a̠, “Mare̠ ma̠ a̠kpon a̠gir kabar kabar agu̠b̠e̠ni̠ ma̠ agu̠o̠ uleriom anwa d̠a̠ igu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","Ya̠a̠ i̠se̠n, na̠ onigha̠ ma̠ A̠zizo̠s opa̠n a̠d̠ien ed̠ighiom i̠di̠ar okur ya̠ ilei abar ipu ma̠ ita̠ awa. Od̠i ma̠ agu̠o̠ rogua̠n d̠a̠ i̠zo̠ wa̠ i̠na na̠ amara eni bho̠, ibhon ipu ma̠ ita̠ oloko bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","I̠se̠ ma̠ abar ola̠ api̠an d̠a̠ o̠pu̠r i̠zo̠ bho̠ na̠ o̠ro̠ d̠o̠ na̠b̠o̠, ezin ola̠ o̠tu̠n omutiom wa̠leghemeni i̠wal bho̠ ka̠ i̠ro̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","Agu̠o̠ A̠zib̠a̠ abi̠gh ma̠ awa na̠ egir na̠ e̠pi̠e̠ bho̠, sa̠ i̠na agba ma̠a̠, “I̠nagha! Ra̠d̠a̠ma̠ na̠ eru ma̠ igiel ami̠ ta̠ a̠mutiom omom i̠zo̠ a̠d̠ia̠n na̠ a̠nwunom Izre̠l na̠ a̠nwunom A̠zuda̠. ");
INSERT INTO mgj_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","Obha̠ ko o̠ro̠ d̠o̠ ma̠ agu̠o̠ i̠zo̠ wa̠ ami̠ id̠ia̠n na̠ ibom ro̠we̠de̠ id̠ud̠ul d̠awa bho̠, ma̠ igiel bho̠ ami̠ isibh awa d̠a̠ agu̠o̠ irileghom imutiom d̠a̠ Izipt bho̠. Igiel obha̠, awa i̠b̠agh aru̠mu̠ e̠we̠le̠man obhin d̠a̠ igielake̠ okoko i̠zo̠ bho̠, sa̠ ami̠ ighel awa.” ");
INSERT INTO mgj_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","Wa̠nwuna̠ bho̠ na̠ agba ma̠a̠, “Onon i̠zo̠ wa̠ ami̠ ta̠ a̠d̠ia̠n na̠ a̠nwunom Izre̠l ma̠a̠, ‘D̠a̠ ra̠d̠a̠ma̠ i̠nye̠, ami̠ ta̠ alo̠gi̠ ma̠ roloko d̠ami̠ d̠a̠ rologi d̠awa, age̠ d̠a̠ rekpo ologi d̠awa. Ami̠ ta̠ aro̠ ma̠ A̠zib̠a̠ da̠wa, sa̠ awa ta̠ e̠ro̠ ma̠ a̠nwunom d̠ami̠.’ ");
INSERT INTO mgj_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","o̠ni̠ awa ola̠ ta̠ atu̠ghu̠me̠ni̠, bo̠d̠o̠ agba a̠nigha̠ ma̠ opa̠n o̠nyi̠ eghun ma̠a̠, ‘Loghome ma̠ A̠zib̠a̠,’ ko o̠ro̠ d̠o̠, ezin bho̠ eb̠la̠ awa ta̠ eloghom ami̠, i̠gbara na̠ ikei. ");
INSERT INTO mgj_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","Ami̠ ta̠ a̠kpon i̠karabh d̠awa asi̠ghe̠ ma̠ a̠d̠ien, sa̠ ami̠ ko o̠ru̠ru̠an mu ma̠ i̠karabh od̠ighi i̠di̠ar d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","Agu̠o̠ i̠na na̠ agba ma̠a̠ omom i̠zo̠ onon a̠bhon a̠pu bho̠, bha̠ i̠na na̠ a̠tenemeni ma̠ o̠pu̠r bho̠ ma̠ ugba̠iny. Ologhom ma̠a̠, abar ola̠ na̠ a̠ten ugba̠iny sa̠ ko orue mu orughom ma̠a̠, na̠ a̠tua̠n ebhi abar bho̠ ma̠ oghur oten. ");
INSERT INTO mgj_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","O̠pu̠r i̠zo̠ bho̠ a̠nwuna̠ ma̠ i̠to̠to̠gi̠ na̠ a̠lukpesi ola̠ o̠ro̠ o̠ko̠l i̠ko̠l. ");
INSERT INTO mgj_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","Otu-akpu̠ru̠ ta̠ A̠zib̠a̠ aro̠ ma̠ ola̠ ugim. O̠pu̠r e̠kpe̠ bho̠ ubhelegi ma̠ A̠lukpesi E̠tu̠tu̠, esi ola̠ uguri ma̠ o̠lo̠ ato̠di̠ na̠ akpata ola̠ u̠gbamagi̠ ikpokpogh abre̠di̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","D̠a̠ aman wa̠leghemeni i̠wal ukpe wa̠ ubhin usobhom A̠lukpesi E̠tu̠tu̠ bho̠, bha̠ opa̠n e̠kpe̠ od̠i ma̠ ola̠ ubhelegi ma̠a̠ Obom A̠lukpesi E̠tu̠tu̠, ");
INSERT INTO mgj_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","esi bho̠ enwen i̠tani̠ ed̠u-e̠nu̠nu̠ ola̠ ubhin a̠gol u̠le̠m, na̠ obom igba̠ ta̠ A̠zib̠a̠ ola̠ ubhin a̠gol ukelema̠ ma̠ eb̠la̠ ozu sa̠ ud̠ighom okpa̠ko ola̠ ubhin a̠gol u̠le̠m od̠i bho̠. U̠b̠aram na̠ okpeti ta̠ Ero̠n wa̠ na̠ aghu̠r bho̠, na̠ ipopola̠ ro̠gbi̠o̠ma ya̠ u̠ge̠ ma̠ oloko bho̠ od̠ighom d̠a̠ ologi obom igba̠ ta̠ A̠zib̠a̠ bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","sa̠ Itileduom isosorogia̠n od̠i d̠a̠ anyu̠ bho̠ na̠ eghughuom a̠lukpesi wa̠ na̠ okpon i̠karabh na̠ o̠si̠ghe̠ ma̠ a̠d̠ien bho̠. Ya̠a̠ i̠yar ko orue d̠o̠ o̠gba ma̠ i̠di̠ar i̠nye̠n o̠si̠se̠ghe̠ni̠ ma̠ i̠se̠n. ");
INSERT INTO mgj_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Igiel na̠ o̠mar o̠to̠to̠gi̠ ma̠ i̠di̠ar bho̠ oguri ma̠ o̠ko̠no̠n, sa̠ rokur bho̠ na̠ e̠gi̠ ka̠ ed̠igh d̠a̠ e̠kpe̠ wa̠ d̠a̠ ed̠ia̠ bho̠ na̠ egir gha̠n ogir ya̠ a̠d̠a̠ma̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","Ya̠a̠, We̠mu̠ Okur bho̠ ku̠ku̠m na̠ a̠d̠igh d̠a̠ e̠kpe̠ wa̠ d̠a̠ ologi bho̠. I̠na na̠ a̠d̠igh gha̠n i̠se̠ ma̠ onin igiel d̠a̠ e̠mu̠ ala, sa̠ na̠ o̠we̠le̠ d̠o̠ ma̠ o̠b̠aram na̠ asi̠ ya̠ obhin o̠kpe̠ alu̠kpe̠ otenemeni ozu d̠o̠yo̠, na̠ i̠karabh ya̠ a̠nwunom bho̠ ologhoma̠n d̠o̠ sa̠ igir. ");
INSERT INTO mgj_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","Ob̠eb̠i E̠mu̠gh bho̠ a̠bhin i̠nye̠ na̠ a̠leriom ma̠a̠, ta̠ o̠gba d̠o̠ omutiom agu̠o̠ o̠wo̠l od̠igh d̠a̠ Obom A̠lukpesi E̠tu̠tu̠ bho̠, ebula̠ agu̠o̠ o̠pu̠r e̠kpe̠ Otu-akpu̠ru̠ ta̠ A̠zib̠a̠ bho̠ od̠id̠ia̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","Onon elegh ola̠ na̠ a̠leriom agu̠o̠ i̠di̠ar ta̠ e̠ro̠ d̠a̠ amu̠m onon, ma̠ i̠di̠ar e̠ne̠ghe̠ na̠ ralu̠kpe̠ ya̠ na̠ o̠kpe̠ na̠ onigha̠ ma̠ A̠zib̠a̠ bho̠ irue d̠o̠ e̠b̠ab̠alame̠ni̠ ma̠ ologi o̠ni̠ i̠ko̠l bho̠ a̠guri d̠a̠ igielake̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","Ri̠to̠to̠gi̠ i̠ye̠ igboloma̠ ma̠ od̠e na̠ o̠d̠a ku̠ku̠m na̠ a̠d̠ien kere kere agu̠o̠ obhin o̠b̠ab̠alame̠ni̠ a̠ruzu d̠i̠yar. I̠ye̠ i̠to̠to̠gi̠ ipulupul ozu ya̠ ta̠ e̠ro̠ ka̠ e̠te̠i̠ obhel wa̠ ta̠ omutiom imom i̠di̠ar onwe awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","Ya̠a̠, Akrai̠st a̠ru ma̠ agu̠o̠ Obom Okur ib̠eb̠i i̠di̠ar, sa̠ i̠ye̠ ologhom od̠i ma̠ i̠se̠. I̠na agi̠ ka̠ a̠d̠igh nyen d̠a̠ otu-akpu̠ru̠ ola̠ abu̠gh a̠pu sa̠ a̠bhon a̠pu, ola̠ obhin d̠o̠ ma̠ aru̠gu̠o̠ o̠nyi̠o̠mo̠ro̠ni̠ ogim (olo), ola̠ o̠ro̠ d̠o̠ ma̠ abar ola̠ u̠le̠m ani̠ d̠a̠ e̠mara̠nwunom onon. ");
INSERT INTO mgj_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","Igiel bho̠ Akrai̠st agi̠ ka̠ a̠d̠igh d̠a̠ A̠lukpesi Obom E̠tu̠tu̠ bho̠ ma̠ obhel sa̠ opa̠n igiel ko o̠ro̠ mu̠ bho̠, i̠na na̠ obhin d̠o̠ ma̠ asi̠ iwel na̠ anwi̠ny ranama, ya̠a̠ i̠na a̠bhin asi̠ d̠o̠yo̠ na̠ agu̠o̠ ata̠ i̠yar asi̠ghe̠ d̠a̠ i̠karabh, ma̠ i̠yar o̠te̠i̠ itenemeni ekunuguma̠ o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","Agu̠o̠ aro̠ ma̠ ola̠ ogbo ya̠ na̠ eru ra̠ o̠ko̠l i̠ko̠l o̠b̠ab̠ala d̠o̠, sa̠ na̠ ozughoghom asi̠ rekpe na̠ ilobhiri anama na̠ o̠b̠ab̠alame̠ni̠ awa d̠a̠ ozu bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","sa̠ asi̠ ta̠ Akrai̠st ta̠ a̠gir a̠peleni ma̠ o̠ku̠a. Ezin bho̠ i̠na o̠ni̠ i̠karabh o̠to̠, ola̠ a̠bhin ozu d̠o̠yo̠ akpe̠ ma̠ alu̠kpe̠ e̠mu̠gh ola̠ ta̠ aro̠ kid̠ud̠ul a̠nigha̠ ma̠ A̠zib̠a̠, ma̠ o̠bab̠alame̠ni̠ i̠walama ologi o̠si̠ghe̠ d̠a̠ i̠karabh od̠ighi i̠di̠ar, b̠o̠ka̠ i̠yar ogir ogir onigha̠ ma̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","Ebula̠ o̠ku̠a, sa̠ i̠na a̠ten o̠ni̠ wa̠ na̠ amara ma̠ enie d̠a̠ omom i̠zo̠ onon wa̠ a̠bhon a̠pu (ma̠ ugbany) bho̠, b̠o̠ka̠ ogbo ya̠ na̠ obhelegi bho̠ ed̠e ma̠ ad̠i̠a e̠no̠gho̠man kid̠ud̠ul ya̠ i̠na a̠gua̠n bho̠. Ezin bho̠ i̠na na̠ a̠mugh a̠tenemeni awa d̠a̠ i̠karabh ya̠ awa igir d̠a̠ ekpukpu i̠zo̠ wa̠ a̠d̠ia̠ aro̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","Ku̠gba ma̠a̠ o̠ni̠ a̠gurigia̠n igurugia̠n bha̠, na̠ ob̠a̠ra̠ gha̠n ka̠ o̠ni̠ bho̠ na̠ a̠mugh kisa̠ na̠ okpon na̠ o̠to̠to̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","Ezin bho̠ igurugia̠n bho̠ id̠igh d̠o̠ ma̠ esi ku̠gba ma̠a̠ o̠ni̠ wa̠ a̠gurigia̠n bho̠ od̠id̠ia̠ d̠a̠ a̠ghud̠um. Igiel o̠ni̠ bho̠ na̠ a̠mugh kisa̠ na̠ okpon (agu̠o̠ o̠ni̠ bho̠ a̠gurugia̠n bho̠) na̠ o̠to̠to̠gi̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","Obha̠ ezin bho̠ aro̠ ma̠ ola̠, d̠a̠ ugba̠ny i̠zo̠ bho̠ eka̠, ubhin asi̠ u̠kpo̠ ma̠ e̠la. ");
INSERT INTO mgj_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","A̠mozizi agba a̠nigha̠ ma̠ eb̠la̠ a̠nwunom bho̠ ma̠ eb̠la̠ roloko ya̠ i̠kpe̠ awa ma̠ okoko bho̠. Sa̠ i̠na agu̠a ma̠ asi̠ olobhiri anama na̠ ekpe d̠a̠ amu̠m, sa̠ ato̠ri̠ ma̠ afu̠lafu̠ ododo na̠ i̠mu̠n ahi̠so̠p a̠bhin asi̠saragi̠o̠m obhurugho a̠d̠ire bho̠ na̠ eb̠la̠ a̠nwunom bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","Sa̠ i̠na agba a̠nigha̠ ma̠ a̠nwunom bho̠ ma̠a̠, “I̠nye̠n asi̠ ya̠ ubhin u̠kpo̠ ma̠ e̠la d̠a̠ i̠zo̠ wa̠ A̠zib̠a̠ a̠d̠ia̠n na̠ i̠nyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","Onin agu̠o̠ bho̠ A̠mozizi asi̠saragi̠o̠m otu-akpu̠ru̠ bho̠ na̠ eb̠la̠ rokpa̠ko i̠ko̠lo̠gi̠ bho̠ ma̠ asi̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","D̠a̠ i̠to̠to̠gi̠ Oloko bho̠, aro̠ ka̠ na̠ obhin asi̠ na̠ o̠b̠ab̠alame̠ni̠ kabar kabar, sa̠ aro̠ ma̠ ola̠ okpon i̠karabh o̠si̠ghe̠ a̠d̠ien ko omite d̠o̠, a̠ten ka̠ uzu ma̠ asi̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","Obha̠ a̠d̠ighi kisa̠ na̠ obhin i̠to̠to̠gi̠ i̠ye̠ na̠ o̠b̠ab̠alame̠ni̠ ma̠ i̠di̠ar ya̠ u̠ta d̠a̠ ote̠nany bho̠. Ya̠a̠ na̠ obhin i̠di̠ar i̠ko̠l ya̠ ibhon ipu ma̠ i̠ye̠ na̠ o̠b̠ab̠alame̠ni̠ ma̠ i̠di̠ar ya̠ od̠i d̠a̠ o̠te̠nany na̠ agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","Ezin bho̠, Akrai̠st na̠ o̠gi̠ d̠o̠ d̠a̠ ra̠lukpesi e̠b̠ab̠ala ya̠ a̠nwunom i̠le̠m ya̠ i̠gu̠b̠a̠n kuma̠ aga̠i a̠yi bho̠, ya̠a̠, i̠na a̠d̠igh d̠a̠ aga̠i o̠yo̠. I̠na a̠d̠igh d̠a̠ ote̠nany na̠ agu̠o̠, d̠a̠ esi bho̠ od̠i na̠ amara ma̠ enie na̠ a̠nigha̠ i̠yar d̠a̠ a̠misigh ta̠ A̠zib̠a̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","I̠na na̠ o̠gi̠ d̠o̠ nyen d̠a̠ A̠lukpesi E̠tu̠tu̠ bho̠ ma̠ obhin ozu d̠o̠yo̠ o̠kpe̠ alu̠kpe̠ ma̠ a̠d̠izo igiel, agu̠o̠ Obokur A̠zu na̠ a̠d̠igh gha̠n d̠a̠ ologi na̠ a̠bhin asi̠ ya̠ o̠ro̠ d̠o̠ ma̠ iya̠ o̠yo̠ na̠ ako̠lo̠gi̠ kala kala bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","Aro̠ ma̠ ola̠ i̠na a̠bhin ozu d̠o̠yo̠ ako̠l i̠ko̠l kala kala nab̠o̠, sa̠ i̠na ka̠ i̠bi̠gh ali̠gam a̠luzu ma̠ a̠d̠izo igiel ka̠ o̠pu̠r ob̠eton e̠mara̠nwunom bho̠. Ya̠a̠, i̠se̠n ekunuguma̠ ramu̠m bho̠ na̠ a̠tua̠n bho̠, sa̠ i̠na a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ onin igiel amado̠n, ma̠ obhin o̠kpe̠ a̠lu̠kpe̠ okunugiom a̠limon i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","Ko̠ni̠ ko̠ni̠ ta̠ a̠mugh onin igiel, sa̠ ka̠ a̠ten i̠se̠ sa̠ ta̠ osobh ase̠ ogboloma̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","Ebula̠ o̠ku̠a sa̠ Akrai̠st a̠nigha̠ ma̠ ozu d̠o̠yo̠ ma̠ onin igiel amado̠n, ma̠ obhin o̠kpe̠ a̠lu̠kpe̠ o̠si̠ghe̠ i̠karabh d̠a̠ a̠ruzu a̠d̠izo ogbo. Ya̠a̠, obhel i̠na ta̠ a̠mite a̠ru ma̠ oleghemeni i̠wal igiel bho̠, i̠na ko oru d̠o̠ ma̠ ra̠ o̠si̠ghe̠ i̠karabh. I̠na ta̠ atu̠n ra̠ otenemeni ogbo ya̠ na̠ ebhin d̠a̠ ebhiroma̠ na̠ egon i̠na bho̠ a̠ru. ");
INSERT INTO mgj_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","Ta̠ obhin Oloko ta̠ A̠mozizi o̠tu̠o̠m okokogh ib̠eb̠i i̠di̠ar ya̠ na̠ eru bho̠. Okokogh onon ib̠eb̠i i̠di̠ar bho̠ na̠ agu̠o̠ d̠o̠, ezin bho̠, ko o̠wo̠l d̠o̠ d̠a̠ onin a̠d̠ien ralu̠kpe̠ ya̠ na̠ o̠ro̠ ma̠ o̠kpe̠ o̠kpe̠ kala kala bho̠ sa̠ ogbo ya̠ na̠ eru ra̠ o̠ko̠l o̠yo̠ bho̠ ta̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","I̠se̠ ma̠ ogbo ya̠ na̠ eru ra̠ o̠ko̠l o̠yo̠ bho̠ na̠ e̠b̠ab̠ala nab̠o̠, sa̠ awa ka̠ i̠ru̠ru̠an mu ma̠a̠ awa e̠pi̠o̠gho̠m (na̠ egir i̠karabh), sa̠ ezin ola̠ odin o̠kpe̠ alu̠kpe̠ ka̠ i̠ro̠ mu̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","Kpe̠le̠me̠ni̠ bha̠ ralu̠kpe̠ i̠ye̠ na̠ enumeta̠n awa ma̠ i̠karabh d̠awa kala kala. ");
INSERT INTO mgj_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","Ezin bho̠, asi̠ ilobhiri anama na̠ rekpe i̠si̠ghe̠ d̠o̠ ma̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","Ebula̠ o̠ku̠a, igiel bho̠ Akrai̠st na̠ ra̠ oru d̠a̠ e̠mara̠nwunom bho̠, sa̠ i̠na agba a̠nigha̠ ma̠ A̠zib̠a̠ ma̠a̠, “Anwa na̠ o̠bho̠ro̠gh d̠o̠ ma̠ i̠ko̠lo̠gi̠ na̠ ralu̠kpe̠, ya̠a̠ ozu d̠ami̠ wa̠ anwa na̠ atu̠ghu̠man a̠guri bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","O̠bhu̠gi̠ ikpo i̠nam alu̠kpe̠ ya̠ obhin o̠si̠ghe̠ i̠karabh d̠o̠ na̠ ebhonomeni ma̠ ologi d̠oyom. ");
INSERT INTO mgj_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","D̠a̠ obhel obha̠, sa̠ i̠na a̠fugh ma̠a̠, “E A̠zib̠a̠, ami̠ na̠ a̠ru ma̠ agu̠o̠ u̠ge̠ ugboloma̠ ami̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠, ma̠ ami̠ igir d̠a̠ i̠to̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","I̠na na̠ a̠d̠ia̠ agba ma̠a̠, “Anwa na̠ o̠bho̠ro̠gh d̠o̠ ma̠ i̠ko̠lo̠gi̠ na̠ ralu̠kpe̠, bo̠d̠o̠ ikpo i̠nam alu̠kpe̠ apu̠gi̠ ya̠ na̠ odin i̠karabh na̠ o̠kpe̠, d̠a̠ eb̠ula̠ agu̠o̠ na̠ o̠tu̠o̠no̠m i̠to̠to̠gi̠ Oloko wa̠ od̠i ma̠ i̠se̠n bho̠ eka̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","Sa̠ i̠na a̠fugh ma̠a̠, “Ami̠ od̠i ma̠ i̠se̠n ogir agu̠o̠ anwa i̠to̠ bho̠.” Sa̠ A̠zib̠a̠ a̠gbogion eb̠la̠ igba̠iny i̠ko̠lo̠gi̠ bho̠, sa̠ a̠bhin alu̠kpe̠ ta̠ Akra̠ist wa̠ aro̠ ma̠ omom bho̠ a̠dinom. ");
INSERT INTO mgj_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","Ebula̠ agu̠o̠ A̠zizo̠s Akrai̠st a̠gir agu̠o̠ A̠zib̠a̠ ato̠ bho̠, sa̠ i̠yar u̠wo̠l d̠a̠ onin obhel alu̠kpe̠ wa̠ i̠na a̠bhin ozu d̠o̠yo̠ akpe̠ bho̠, uten a̠nwunom ya̠ na̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","Ad̠u̠a ma̠ a̠d̠a̠ma̠ a̠ten a̠d̠a̠ma̠, kokur kokur na̠ amara na̠ a̠bhin onin a̠d̠ien alu̠kpe̠ na̠ ako̠lo̠gi̠ ma̠ i̠ko̠l d̠a̠ i̠to̠to̠gi̠ ogir d̠o̠yo̠, ku̠ku̠m eka̠ ri̠ko̠l i̠ye̠ irue d̠o̠ ma̠ o̠si̠ghe̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","Ya̠a̠ igiel bho̠ Akrai̠st a̠bhin ozu d̠o̠yo̠ akpe̠ ma̠ onin obhel alu̠kpe̠ ata ma̠ i̠karabh awe̠le̠ bho̠, ma̠ alu̠kpe̠ wa̠ ta̠ aro̠ tu̠tu̠n kid̠ud̠ul bho̠, sa̠ i̠na agi̠ ka̠ aro̠ ma̠ a̠dila̠de d̠a̠ od̠iom agu̠o̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","Ob̠eton d̠a̠ obhel obha̠, sa̠ i̠na od̠i na̠ a̠gon igiel ta̠ otenemeni ma̠ ogbo o̠lo̠gi̠an a̠d̠ien d̠o̠yo̠ ma̠ okpokpolom o̠gbam a̠sike d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","Ezin bho̠, ta̠ o̠wo̠l d̠a̠ alu̠kpe̠ wa̠ i̠na akpe̠ ma̠ onin obhel bho̠ o̠b̠ab̠alame̠ni̠ ma̠ ogbo ya̠ A̠zib̠a̠ aso̠n bho̠ tu̠tu̠n kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","E̠mu̠gh E̠tu̠tu̠ (E̠mu̠gh E̠b̠ab̠ala, Ob̠eb̠i E̠mu̠gh) bho̠ agba nyen a̠nigha̠ i̠yar agu̠o̠ i̠di̠ar i̠nye̠n i̠ro̠ ma̠ ya̠gia̠ga̠i bho̠ ma̠a̠: ");
INSERT INTO mgj_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","“Igiel ta̠ ate̠i̠ obhel bho̠, ami̠ ta̠ a̠d̠ia̠n awa ma̠ i̠zo̠, sa̠ ami̠ ta̠ age̠ ma̠ roloko d̠ami̠ d̠a̠ rekpo ologi d̠awa na̠ d̠a̠ amu̠gho̠nyan (i̠walama ologi) d̠awa. ");
INSERT INTO mgj_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","Sa̠ ami̠ ko o̠ru̠ru̠an mu̠ a̠gboloma̠ ma̠ i̠karabh d̠awa na̠ ado̠l i̠te̠i̠ d̠awa.” ");
INSERT INTO mgj_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","Igiel A̠zib̠a̠ na̠ a̠kpon i̠karabh o̠ni̠ asi̠ghe̠ ma̠ a̠d̠ien, ezin ola̠ odin o̠kpe̠ alu̠kpe̠ ya̠ o̠ta i̠karabh o̠ni̠ bho̠ bo̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","A̠rumor na̠ aru̠marani̠ d̠ami̠ d̠a̠ onin ima̠ra̠ ologi bho̠, awo̠l d̠a̠ asi̠ ta̠ A̠zizo̠s sa̠ i̠yar unwuna̠ ma̠ alu̠kpo̠ ologi od̠igh d̠a̠ Obom A̠lukpesi E̠tu̠tu̠ (E̠b̠ab̠ala) bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","wa̠ aro̠ ma̠ omom eten a̠ghud̠um ola̠ ubhin ozu d̠o̠yo̠ uguron unigha̠ i̠yar. ");
INSERT INTO mgj_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","I̠yar onwuna̠ ma̠ obom okur ola̠ na̠ a̠kponom Otuta̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","O̠ku̠a a̠d̠ighi be̠le̠ni̠, id̠ighi obhin rologi e̠b̠ab̠ala na̠ alu̠kpo̠ ologi id̠umom d̠i̠yar oru d̠a̠ A̠zib̠a̠. Id̠ighi oguri ma̠ rologi d̠i̠yar d̠a̠ e̠b̠ab̠ala, o̠si̠ghe̠ ma̠ i̠karabh i̠walama, obhin amu̠m otitol a̠ruzu d̠i̠yar o̠b̠ab̠alame̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","Id̠ighi osibh o̠kparame̠ni̠ ma̠ eb̠em ologi wa̠ i̠yar na̠ oma̠ra̠ bho̠, ezin bho̠ A̠zib̠a̠ wa̠ a̠gua̠n a̠nigha̠ i̠yar bho̠ ola̠ obhin ob̠em ologi. ");
INSERT INTO mgj_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","Odi akpo̠me̠ni̠ ma̠ ologi ta̠ odi ma̠ ogir ib̠eb̠i d̠a̠ etula̠n. ");
INSERT INTO mgj_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","I̠yar o̠we̠le̠ d̠o̠ ma̠ osor gha̠n ezue od̠igh onin, ma̠ agu̠o̠ idi ogbo na̠ egir bho̠, ya̠a̠ odi akpo̠me̠ni̠ ma̠ ologi ta̠ odi, okunukun i̠se̠n wa̠ eruoma̠ d̠o̠yo̠ (ta̠ Akrai̠st) na̠ a̠tua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","Ku̠gba ma̠a̠ i̠yar o̠ro̠ ma̠ ogir ogir i̠karabh i̠se̠n i̠yar na̠ o̠mar ologhom ya̠gia̠ga̠i bho̠, sa̠ opa̠n alu̠kpe̠ ola̠ ta̠ orue obhin o̠kpe̠ otenemeni i̠yar d̠a̠ i̠karabh ko o̠ro̠ mu̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","Abar wa̠ od̠i bho̠ bha̠ ogbo o̠lo̠gi̠an a̠d̠ien ta̠ A̠zib̠a̠ ta̠ e̠ro̠ d̠a̠ a̠rugugu egon osobh ase̠ d̠o̠yo̠ na̠ obom e̠ba anya wa̠ ta̠ anu̠o̠me̠ni̠ (a̠kunugi) awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","Ezin bho̠ u̠to̠ ma̠a̠, ku̠gba ma̠a̠ o̠ni̠ a̠sor oloko ta̠ A̠mozizi sa̠ i̠wal a̠nwunom imite i̠gba ma̠ onyob̠a̠, bha̠ ta̠ ogigh o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","O̠ku̠a ka̠a̠, inyin na̠ o̠ru̠ru̠an ma̠a̠ agu̠o̠ i̠zagba wa̠ ta̠ o̠gu̠r ogbo ya̠ na̠ ekpon O̠nyi̠ ta̠ O̠ni̠ na̠ e̠do̠ti̠me̠ni̠ bho̠, sa̠ na̠ e̠pi̠o̠gho̠m i̠zo̠ asi̠ wa̠ ab̠ab̠alame̠ni̠ awa bho̠, sa̠ na̠ efugh i̠basi̠ ma̠ E̠mu̠gh E̠tu̠tu̠ bho̠, ka̠ ta̠ aro̠ (abu̠gh a̠lei) eka̠? ");
INSERT INTO mgj_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","I̠yar ologhom ma̠a̠, A̠zib̠a̠ agba ma̠a̠, “Ami̠ ta̠ a̠d̠e awa ma̠ olo. Ami̠ ta̠ akpe̠ awa.” I̠na agba nyen ma̠a̠, “WA̠NWUNA̠ bho̠ ta̠ a̠sobh ase̠ a̠gboloma̠ ma̠ a̠nwunom d̠o̠yo̠.” ");
INSERT INTO mgj_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","Ta̠ aro̠ ma̠ abar a̠rugugu ma̠ o̠ni̠ ma̠ omel od̠igh d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠ wa̠ a̠nwuna̠ ma̠ eb̠la̠ a̠limon wa̠ od̠i d̠a̠ a̠ghud̠um bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","I̠ru̠ru̠ane̠ ma̠ o̠pu̠r igiel wa̠ inyin ud̠ia̠ uloghom Akrai̠st bho̠, ma̠ agu̠o̠ inyin uwia̠n une ma̠ a̠ma̠ne d̠a̠ esa̠d̠io ali̠gam a̠ruzu (egbika̠). ");
INSERT INTO mgj_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","A̠mite ma̠ ola̠ urogi gha̠n inyin sa̠ ugbikimeni inyin d̠a̠ etire, ipa̠n igiel sa̠ inyin ud̠igh na̠ ipa̠n ogbo u̠bi̠gh ani̠ ma̠ ali̠gam a̠ruzu̠ ya̠ na̠ e̠te̠i̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","Inyin o̠lo̠gh agu̠o̠ onigha̠ ma̠ (okpon igbirigbir) ogbo ikoli, sa̠ igiel bho̠ ughumi ma̠ i̠di̠ar d̠inyin ubhinogh bho̠, sa̠ inyin ubhin d̠a̠ ibo na̠ a̠ma̠ne u̠da ubhin, ezin bho̠, inyin ologhom ma̠a̠ inyin onwuna̠ ma̠ i̠di̠ar ya̠ ibhon ipu ma̠ i̠ye̠ ya̠ ta̠ e̠ro̠ tu̠tu̠n kid̠ud̠ul. ");
INSERT INTO mgj_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko orobh alu̠kpo̠ ologi wa̠ inyin unwuna̠ bho̠, ezin bho̠ ta̠ a̠bhin ibom asu̠wo̠ a̠ruom inyin. ");
INSERT INTO mgj_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","Akpe̠ inyin one a̠ma̠ne, b̠o̠ka̠ inyin orue ogir agu̠o̠ A̠zib̠a̠ ato̠ bho̠, sa̠ i̠nyin ta̠ o̠te̠i̠ i̠di̠ar ya̠ i̠na a̠gua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","Ezin bho̠, A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠a̠, “Ekud̠i obhel ku̠ku̠m a̠sugho, sa̠ i̠na wa̠ ta̠ a̠ru bho̠ ta̠ a̠ru. I̠na ko orobh d̠o̠ ma̠ obhel.” ");
INSERT INTO mgj_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","Sa̠, “A̠nwunom ya̠ od̠i na̠ e̠b̠ab̠ala bho̠ ta̠ ed̠um ebula̠ ologi ima̠ra̠ d̠awa. Ya̠a̠, ologi d̠ami̠ ko obhon d̠o̠ a̠nigha̠ ma̠ o̠ni̠ awa ola̠ ta̠ a̠mula̠ d̠a̠ aman.” ");
INSERT INTO mgj_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","I̠yar bo̠ ani̠ d̠o̠ d̠a̠ o̠lo̠gh a̠nwunom ya̠ na̠ emula̠ d̠a̠ aman sa̠ a̠d̠ugh a̠bhin (sa̠ imugh ibhe) bho̠, ya̠a̠ i̠yar od̠i d̠a̠ ogbo ya̠ inwuna̠ ma̠ ologi ima̠ra̠ ma̠a̠ A̠zib̠a̠ na̠ (ta̠) a̠tenemeni awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","Ologi ima̠ra̠ bha̠ abar ola̠ na̠ a̠nigha̠ i̠yar eb̠em ologi na̠ a̠gboloma̠ ma̠ i̠di̠ar ya̠ i̠yar ko orue d̠o̠ o̠bi̠gh. ");
INSERT INTO mgj_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ ibom ro̠we̠de̠ na̠ ronweni d̠i̠yar igied̠i i̠te̠i̠ e̠ne̠ghe̠ d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","Na̠ ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ i̠yar u̠mu̠gho̠nyan ma̠a̠ A̠zib̠a̠ a̠bhin o̠nu̠o̠kpe̠ d̠o̠yo̠ ale̠m e̠mara̠nwunom bho̠ a̠soroni. Sa̠ a̠mite ma̠ ola̠ ubhin i̠di̠ar ya̠ i̠yar ko orue d̠o̠ o̠bi̠gh bho̠ u̠le̠m i̠di̠ar ya̠ i̠yar na̠ o̠bi̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","Ebe̠l a̠bhin d̠a̠ ologi ima̠ra̠ akpe̠ ma̠ alu̠kpe̠ ola̠ a̠bhon a̠pu ma̠ alu̠kpe̠ ta̠ A̠ken. Ad̠u̠a d̠a̠ ologi ima̠ra̠ d̠o̠yo̠ sa̠ A̠zib̠a̠ ada i̠na a̠bhin agu̠o̠ o̠ni̠ igielake̠. I̠di̠ar e̠ne̠ghe̠ ta̠ Ebe̠l ed̠igh A̠zib̠a̠ ma̠ ologi, sa̠ eb̠la̠ agu̠o̠ i̠na na̠ a̠mugh bho̠ eka̠, bha̠ ologi ima̠ra̠ d̠o̠yo̠ od̠id̠ia̠ na̠ agba ma̠ abar na̠ a̠gboloma̠ i̠na. ");
INSERT INTO mgj_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ I̠no̠k omugh d̠o̠. Kpe̠le̠me̠ni̠ bha̠ A̠zib̠a̠ a̠bhuneni i̠na d̠a̠ o̠te̠nany, obha̠ ezin bho̠ a̠nwunom orue d̠o̠ ma̠ o̠bi̠gh ozu d̠o̠yo̠ bho̠. I̠no̠k a̠rugh a̠ma̠rugh igielake̠ sa̠ i̠na a̠d̠igh A̠zib̠a̠ ma̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","O̠ni̠ ola̠ ta̠ a̠rue a̠rugh a̠ma̠rugh ya̠ ta̠ ed̠igh A̠zib̠a̠ ma̠ ologi bo̠, a̠ten ka̠ o̠ni̠ bho̠ a̠nwuna̠ ma̠ ologi ima̠ra̠. O̠ni̠ ola̠ na̠ ebhir oru d̠a̠ A̠zib̠a̠ ta̠ a̠d̠ia̠ a̠loghoma̠n ma̠a̠ A̠zib̠a̠ od̠i, sa̠ na̠ akpe̠ ma̠ ogbo ya̠ na̠ e̠bho̠ro̠gh ologhom o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠noa̠ anagha ma̠ o̠kparakpar a̠kikiom ola̠ a̠gboloma̠ ma̠ i̠d̠iar ya̠ i̠na ta̠ od̠ia̠ d̠o̠ abi̠gh. I̠na anagha ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠, sa̠ i̠na ale̠m obom oghugh abadi̠ ola̠ ta̠ obhin otenemeni ma̠ eghun otu d̠o̠yo̠ na̠ i̠na. Agbo̠ ma̠ i̠se̠ sa̠ A̠zib̠a̠ a̠kunugi ma̠ e̠mara̠nwunom bho̠, sa̠ A̠noa̠ ra̠ a̠ten o̠ni̠ (a̠d̠e ma̠ ad̠i̠a) e̠b̠ab̠ala d̠a̠ ebula̠ ologi ima̠ra̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ Ebraham anagha ma̠ o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ ma̠ igiel bho̠ A̠zib̠a̠ a̠bhelegi i̠na ma̠ o̠d̠u̠a o̠gi̠ d̠a̠ a̠de wa̠ i̠na a̠gua̠n a̠nigha̠ o̠yo̠ bho̠. Ebraham ad̠u̠a d̠a̠ ebhugh d̠o̠yo̠ agi̠ ma̠ esi ola̠ i̠na ologhom d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","I̠na a̠bhin d̠a̠ ologi ima̠ra̠ a̠rugh agu̠o̠ isuloma̠ d̠a̠ ebhugh wa̠ A̠zib̠a̠ a̠gua̠n a̠nigha̠ i̠na bho̠. I̠na a̠rugh d̠a̠ a̠rutu akpu̠ru̠, onin agu̠o̠ bho̠ Azi̠ki̠ na̠ A̠zeko̠pu̠ irugh d̠a̠ a̠rutu akpu̠ru̠ nyen, sa̠ i̠te̠i̠ ani̠ ma̠ onin ogua̠n bho̠ d̠a̠ agu̠o̠ ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","Ebraham a̠gir o̠ku̠a, ezin bho̠ i̠na aro̠ a̠gon e̠ma wa̠ A̠zib̠a̠ na̠ a̠gbonogi a̠lo a̠guri bho̠, wa̠ ta̠ aro̠ tu̠tu̠n kid̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","Ad̠u̠a d̠a̠ ologi ima̠ra̠ nyen sa̠ Ebraham a̠ten o̠we̠de̠ d̠a̠ obhel ola̠ A̠sera na̠ akpo̠ a̠pu ma̠ omumor o̠nyi̠ sa̠ i̠na eka̠ na̠ akpo̠. I̠na a̠nwuna̠ ma̠ ologi ima̠ra̠ ma̠a̠ A̠zib̠a̠ ta̠ a̠sibh ogua̠n d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","O̠ku̠a bha̠ eb̠la̠ ekpom ebhugh awo̠l a̠mite d̠a̠ onin o̠ni̠ onon wa̠ aro̠ ka̠ na̠ a̠ten e̠mar bho̠. Ebhugh ola̠ ibom a̠b̠utu (a̠d̠izo) a̠nwunom od̠i ma̠ agu̠o̠ i̠ni̠nany d̠a̠ ote̠nany na̠ i̠si̠sar d̠a̠ esoroma̠ abadi̠, ma̠ iya̠ o̠nu̠ o̠wal o̠to̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","Eb̠la̠ a̠nwunom i̠nye̠n emugughu ya̠a̠ enwuna̠ ma̠ ologi ima̠ra̠ egboloma̠ ma̠ abar wa̠ A̠zib̠a̠ a̠gua̠n a̠nigha̠ awa bho̠. Awa i̠te̠i̠ d̠o̠ ma̠ abar wa̠ A̠zib̠a̠ a̠gua̠n a̠nigha̠ awa bho̠, ya̠a̠ awa i̠ro̠ ma̠ esi egbeny e̠bi̠gh, sa̠ awa i̠da ibhin. Awa ima̠ra̠ ma̠a̠ awa risuloma̠ ya̠ ta̠ e̠d̠u̠a ma̠ esi eten esi ma̠ i̠se̠n a̠de onon. ");
INSERT INTO mgj_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","A̠nwunom ya̠ na̠ e̠gba ma̠ i̠di̠ar ya̠ o̠ku̠a, ibhin ma̠a̠ awa na̠ o̠bho̠ro̠gh ebhugh ola̠ awa ta̠ obhelegi ma̠ ola̠ awa. ");
INSERT INTO mgj_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","Aro̠ ma̠ ola̠ awa i̠ru̠ru̠an ghan igboloma̠ ma̠ ebhugh wa̠ awa i̠d̠u̠a iru bho̠ nab̠o̠, obhel ka̠ i̠ro̠ ma̠ ola̠ awa ka̠ imula̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","Ya̠a̠, ibhir awa ma̠ o̠te̠i̠ abar ola̠ a̠d̠igh asu̠wo̠ a̠pu ola̠ od̠i d̠a̠ ote̠nany. Obha̠ ezin bho̠ od̠igh d̠o̠ ma̠ ari̠ghe̠l ma̠ awa ma̠ obhelegi o̠yo̠ ma̠ i̠na o̠we̠de̠ d̠awa. I̠na a̠lo nyen e̠ma a̠guri a̠sisa̠n awa. ");
INSERT INTO mgj_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","Ugua̠n unigha̠ ma̠ Ebraham ma̠a̠ ta̠ o̠wo̠l d̠a̠ Azi̠ki̠ o̠nyi̠ i̠mara ilologia̠n d̠o̠yo̠ omuzoghod̠iom i̠di̠ar i̠ye̠. Ku̠ku̠m eka̠, i̠na a̠bhin d̠a̠ ologi ima̠ra̠ a̠kokod̠ia̠n obhin Azi̠ki̠ o̠kpe̠ alu̠kpe̠, ");
INSERT INTO mgj_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","ma̠ eb̠la̠ agu̠o̠ A̠zib̠a̠ agba a̠nigha̠ i̠na ma̠a̠, “Azi̠ki̠ o̠nyi̠ wa̠ anwi̠ny i̠sabh ikpele (anwi̠ny o̠gu̠man) d̠oyom ta̠ e̠wo̠l emite bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","Ebraham aru̠ru̠an ma̠a̠, ka̠ aro̠ ma̠ ola̠ Azi̠ki̠ a̠mugh eka̠, ma̠a̠ A̠zib̠a̠ ta̠ a̠rue a̠mulumeni i̠na a̠ru d̠a̠ a̠ghud̠um. Agu̠o̠ o̠gba bha̠, umulumeni ma̠ o̠nyi̠ ta̠ Ebraham d̠a̠ omugh oruom i̠na. ");
INSERT INTO mgj_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ Azi̠ki̠ a̠du ma̠ o̠gho̠r ib̠eb̠i ya̠ od̠i d̠a̠ ed̠ia̠ a̠nigha̠ (a̠tutumeni) ma̠ anwi̠ny d̠o̠yo̠ A̠zeko̠pu̠ na̠ I̠so̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠zeko̠pu̠ a̠du ma̠ o̠gho̠r ib̠eb̠i a̠nigha̠ (a̠tutumeni) ma̠ anwi̠ny ta̠ A̠zose̠fu̠ ma̠ odi odi i̠se̠, ma̠ igiel bho̠ i̠na na̠ a̠ten okei-o̠ni̠ a̠tua̠n omugh bho̠, sa̠ i̠na ab̠e̠d̠i̠an d̠a̠ okpeti d̠o̠yo̠ a̠zuma̠n d̠a̠ a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠zose̠fu̠ a̠bhin d̠a̠ alu̠kpo̠ ologi agba a̠nigha̠ ma̠ a̠nwi̠ny Izre̠l ma̠ awa ta̠ e̠d̠u̠a d̠a̠ Izipt, ma̠ igiel bho̠ i̠na na̠ a̠ru ra̠ omugh bho̠, sa̠ a̠ruom nyen agu̠o̠ awa ta̠ egir egboloma̠ ma̠ i̠kpo̠kpo̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ onweni na̠ o̠we̠de̠ ta̠ A̠mozizi i̠wo̠gi̠ i̠na ma̠ obhel ola̠ a̠lei i̠sar uwetire ma̠ igiel bho̠ u̠mar i̠na bho̠. Ezin bho̠, awa i̠bi̠gh a̠libhon o̠nyi̠ bho̠ sa̠ ighil d̠o̠ ma̠ oloko wa̠ o̠li̠le̠ma alo̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠mozizi oma̠ra̠ d̠o̠ ma̠ obhelegi i̠na ma̠ i̠na o̠nyi̠ o̠nyani̠ ta̠ Afe̠ro. ");
INSERT INTO mgj_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","I̠na a̠bhin a̠bin wa̠ od̠igh na̠ a̠nwunom ta̠ A̠zib̠a̠ ogbika̠ bho̠, kpe̠le̠me̠ni̠ ma̠ od̠e e̠nu̠m i̠karabh ya̠ na̠ e̠ro̠ ma̠ ekud̠i obhel ku̠ku̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","A̠mozizi a̠loghom ma̠a̠, i̠na ma̠ ogbika̠ d̠a̠ ebula̠ Akrai̠st ta̠ a̠nigha̠ i̠na ma̠ asu̠wo̠ ya̠ ilei abar a̠pu ma̠ e̠no̠gho̠man Izipt bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠mozizi ad̠u̠a d̠a̠ Izipt sa̠ i̠na oghil d̠o̠ ma̠ i̠gam ta̠ o̠li̠le̠ma. I̠na a̠ne, aro̠ ma̠ o̠gi̠ o̠gi̠ d̠a̠ ed̠ia̠, ezin bho̠ i̠na abi̠gh i̠na o̠ni̠ wa̠ a̠nwunom o̠bi̠gh d̠o̠ ma̠ a̠d̠ien bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ A̠mozizi a̠koko ma̠ E̠yal Opel Oten bho̠, na̠ ozu asi̠ b̠o̠ka̠ a̠d̠ugh wa̠ na̠ aze̠ ma̠ i̠kpana anwi̠ny bho̠ ko okula̠n (o̠ze̠) d̠o̠ ma̠ i̠kpana anwi̠ny Isre̠l. ");
INSERT INTO mgj_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ a̠nwunom bho̠ i̠wo̠l d̠a̠ Abadi̠ Ododo bho̠ iten d̠a̠ egbolom a̠de, ya̠a̠ igiel bho̠ a̠nwunom Izipt iwia̠n oten ani̠ bho̠, sa̠ awa i̠bhu̠ghu̠d̠i̠an. ");
INSERT INTO mgj_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ re̠b̠agh Aze̠riko imel wa̠leghemeni od̠ua̠l a̠d̠a̠ma̠ bho̠, ma̠ igiel bho̠ o̠lo̠gh e̠gham bho̠ irile igir bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","Ad̠u̠a d̠a̠ ologi ima̠ra̠ sa̠ Arehab od̠eme̠ma bho̠ ada ma̠ ogbo ipoiny bho̠ a̠bhin, ebula̠ o̠ku̠a, u̠b̠aram ani̠ d̠o̠ i̠na ogigh igiel bho̠ ukunugi ma̠ ogbo ya̠ o̠da d̠o̠ awa ebhin na̠ ekima̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","Ipa̠n i̠di̠ar ya̠ ami̠ ta̠ a̠mula̠ agba d̠a̠ i̠nye̠n od̠i ke̠re̠? Ya̠a̠, ami̠ ko o̠we̠le̠ d̠o̠ ma̠ o̠gba o̠si̠se̠ghe̠ni̠ i̠di̠ar ya̠ igboloma̠ ma̠ A̠gidio̠n, na̠ Abarak, na̠ Asamsi̠n, na̠ Aze̠fta, na̠ A̠devidi, na̠ Asamu̠e̠l, na̠ a̠riwil bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","Awa ibhin d̠a̠ ologi ima̠ra̠ e̠ne̠gi̠me̠ni̠ ma̠ ra̠dema (rebhugh), sa̠ irileghom a̠nwunom d̠a̠ igielake̠, sa̠ i̠te̠i̠ i̠di̠ar ya̠ ugua̠n bho̠, sa̠ ikpegi ma̠ aru̠nu̠ ta̠ rodughunub̠agu̠, ");
INSERT INTO mgj_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","sa̠ id̠imigi ma̠ ibom re̠ba anya, sa̠ imiza̠n d̠a̠ ra̠nem a̠rigidi e̠gham (ralapogidi). Awa edugh, ya̠a̠ utenemeni awa ma̠ imoma̠na̠n e̠gham ya̠ inwuna̠ ma̠ a̠limon okunugi ogbo o̠lo̠gi̠an a̠d̠ien. ");
INSERT INTO mgj_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","Ub̠egion ogbo etula̠n idi anwani̠ d̠a̠ omugh. Sa̠ ugbikimeni ma̠ idi a̠nwunom i̠nye̠n. Ipa̠n ogbo sa̠ igin agu̠o̠ ola̠ ta̠ otenemeni awa d̠a̠ a̠d̠ugh, kpe̠le̠me̠ni̠ bha̠ awa ibhin a̠bin wa̠ ta̠ omugh sa̠ awa ta̠ ob̠etina̠ d̠a̠ omugh bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","Ipa̠n ogbo sa̠ usorogiom adi̠e̠l (u̠ki̠ri̠), sa̠ u̠gu̠ro̠gh, sa̠ usobh ase̠ ugboloma̠, idi sa̠ u̠du̠o̠m rikoli, idi sa̠ u̠du̠o̠m d̠a̠ a̠rutu ikoli. ");
INSERT INTO mgj_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","Idi awa sa̠ urobhod̠i ugigh, idi ogbo sa̠ ugbodo i̠wal i̠wal, idi sa̠ ubhin ogidi e̠gham (alapogidi) ugigh. Idi awa i̠lo̠gi̠an ikpora̠n a̠ruzu o̠na̠na na̠ ikpora̠n a̠ruzu iwel, sa̠ i̠d̠u̠a ma̠ esi eten esi, sa̠ ugbikimeni awa, ");
INSERT INTO mgj_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","sa̠ iten ogbo ya̠ o̠kpe̠ d̠o̠ ma̠ orugh d̠a̠ e̠mara̠nwunom bho̠. Awa i̠d̠u̠a ma̠ esi eten esi d̠a̠ ra̠de i̠si̠sar (re̠ghana), na̠ d̠a̠ rigu, na̠ d̠a̠ iyol igu, na̠ d̠a̠ iyol d̠a̠ a̠de (d̠a̠ ro̠nu̠ d̠a̠ a̠de). ");
INSERT INTO mgj_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","Eb̠la̠ awa ed̠igh A̠zib̠a̠ ma̠ ologi d̠a̠ ebula̠ ologi ima̠ra̠ d̠awa, ku̠ku̠m eka̠, awa i̠te̠i̠ d̠o̠ ma̠ abar wa̠ ugua̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","Ezin bho̠, A̠zib̠a̠ na̠ a̠guri ma̠ abar ola̠ a̠d̠igh asu̠wo̠ a̠pu a̠sisa̠n i̠yar. I̠na na̠ o̠bho̠ro̠gh d̠o̠ awa ma̠ od̠ia̠ o̠te̠i̠ e̠ne̠ghe̠ bho̠ ma̠ igiel i̠yar o̠ro̠ ani̠ d̠o̠ d̠a̠ e̠b̠ab̠ala bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠bhon i̠yar o̠ru̠ru̠an ogboloma̠ obom o̠lo̠gh a̠nwunom i̠ye̠ ya̠ i̠ro̠ ma̠ ronyob̠a̠ a̠ma̠rugh ologi ima̠ra̠ bho̠, o̠tu̠o̠no̠m i̠se̠ osorogi ma̠ eb̠la̠ ra̠dol ya̠ na̠ e̠mu̠mo̠ro̠me̠ni̠ i̠yar bho̠, okunukun i̠karabh ya̠ na̠ e̠bhad̠i̠ i̠yar onyen bho̠. Id̠ighi obhin d̠a̠ a̠ma̠ne oghil eghil wa̠ A̠zib̠a̠ na̠ a̠bho a̠mutiom d̠a̠ ed̠ia̠ d̠i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","Akpe̠ i̠yar ogbi ma̠ a̠rid̠ien d̠i̠yar okpon A̠zizo̠s wa̠ a̠bho ma̠ ologi ima̠ra̠ a̠mutiom sa̠ a̠rugh akpe̠re̠me̠ni̠ bho̠. I̠na a̠ne ma̠ a̠ma̠ne a̠d̠igh ari̠ghe̠l sa̠ a̠gbika̠ d̠a̠ e̠mi̠gi̠re̠ni̠an oriren, ezin bho̠ i̠na a̠loghom ma̠a̠, d̠a̠ ed̠ia̠ i̠na ta̠ a̠bhon ologi a̠gboloma̠ ma̠ ogir wa̠ i̠na a̠gir bho̠. I̠se̠n i̠na od̠i ma̠ a̠dila̠de d̠a̠ od̠iom agba ukpo ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","I̠mare̠ ma̠ e̠ru̠ru̠an egboloma̠ ma̠ a̠d̠ien egbika̠ ya̠ i̠na a̠ne d̠a̠ aru̠gu̠o̠ id̠ighi ma̠ i̠karabh bho̠ ma̠ agu̠o̠ ola̠ a̠ruzu d̠inyin na̠ rologi d̠inyin ko odugh d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","Inyin na̠ owia̠n agu̠o̠ ola̠ inyin ko ogir d̠o̠ ma̠ i̠karabh, ya̠a̠ inyin ta̠ orugh d̠o̠ o̠te̠i̠ ma̠ esi ola̠ na̠ ogigh inyin ebula̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","O̠ku̠a ka̠ inyin na̠ oweleta̠n a̠kikiom wa̠ ubhin u̠kpo̠me̠ni̠ ma̠ rologi d̠inyin agu̠o̠ o̠we̠de̠ na̠ a̠kikiom o̠nyi̠ d̠o̠yo̠ bho̠ ke̠re̠? Agba ma̠a̠, “O̠nyi̠ d̠ami̠, ko obhin a̠kikiom ikighom (agu̠o̠ i̠zagba) ta̠ Wa̠nwuna̠ bho̠ ma̠ a̠degh, sa̠ ko o̠ku̠nu̠ (ologi d̠oyom odugh d̠o̠) ma̠ igiel i̠na na̠ agu̠r anwa ma̠ i̠zagba, ");
INSERT INTO mgj_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","ezin bho̠ A̠zib̠a̠ na̠ a̠kikiom (agu̠r i̠zagba) ma̠ o̠ni̠ wa̠ i̠na a̠tula̠n bho̠, sa̠ na̠ amar na̠ agam na̠ a̠nigha̠ ko̠nyi̠ ko̠nyi̠ ola̠ i̠na na̠ ada a̠bhin.” ");
INSERT INTO mgj_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","A̠zib̠a̠ na̠ atu̠n o̠tu̠ghu̠me̠ni̠ inyin na̠ abho̠ro̠gh inyin one a̠ma̠ne, ezin bho̠ i̠na na̠ a̠rughom inyin agu̠o̠ anwi̠ny d̠o̠yo̠. O̠ken o̠we̠de̠ wa̠ ko okikiom d̠o̠ ma̠ o̠nyi̠ d̠o̠yo̠ a̠kighom bho̠? ");
INSERT INTO mgj_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","Ku̠gba ma̠a̠ inyin ta̠ o̠te̠i̠ ani̠ d̠o̠ ma̠ a̠kikiom ikighom d̠o̠yo̠ ma̠ agu̠o̠ i̠na na̠ a̠kikiom na̠ a̠kighom eb̠la̠ anwi̠ny d̠o̠yo̠ iyeyi bho̠, sa̠ i̠nyin obhobho i̠kpo̠ anwi̠ny, o̠ku̠a sa̠ inyin anwi̠ny d̠o̠yo̠ d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","O̠tu̠o̠no̠m i̠se̠, ro̠we̠de̠ d̠i̠yar d̠a̠ e̠mara̠nwunom na̠ ekikiom i̠yar na̠ ekighom, sa̠ i̠yar na̠ ozuruna̠ ma̠ eghoi na̠ onigha̠ awa ma̠ ebula̠ o̠ku̠a. O̠ku̠a a̠d̠ighi be̠le̠ni̠, obhin d̠a̠ onyen ologi o̠da ma̠ a̠kikiom ikighom ta̠ O̠we̠de̠ aru̠mu̠gh bho̠ opeleni ma̠ o̠ku̠a od̠um. ");
INSERT INTO mgj_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","Ro̠we̠de̠ d̠i̠yar ekikiom i̠yar ekighom ekud̠i obhel ku̠ku̠m. Awa ibhin agu̠o̠ a̠bhon d̠a̠ rologi d̠awa egir o̠ku̠a, ya̠a̠ A̠zib̠a̠ na̠ a̠kikiom i̠yar na̠ a̠kighom ma̠ i̠yar o̠te̠i̠ asu̠wo̠ wa̠ od̠ed̠ia̠n o̠yo̠ d̠a̠ e̠b̠ab̠ala d̠o̠yo̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","Agu̠o̠ i̠zagba ola̠ ame̠me̠m o̠pu̠r igiel bho̠ bo̠, a̠ten o̠ro̠ agu̠o̠ abar i̠ku̠nu̠. Ya̠a̠, ka̠ a̠tepa̠, sa̠ na̠ a̠mum imuma̠ e̠b̠ab̠ala na̠ ekima̠ na̠ a̠nigha̠ ma̠ ogbo ya̠ u̠tu̠ghu̠me̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠kpe̠re̠me̠ni̠ ma̠ idudugha̠n aru̠gu̠o̠ d̠inyin na̠ i̠kpo̠kpu̠an-kpo̠kpu̠an asu̠kpu̠lo̠m d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","Reten a̠sike d̠inyin esel, b̠o̠ka̠ ogbo ya̠ na̠ edugh bho̠ na̠ a̠rukula̠ bho̠ imel e̠d̠u̠a, kpe̠le̠me̠ni̠ bha̠ awa ta̠ e̠kpo̠ ma̠ a̠ruzu. ");
INSERT INTO mgj_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","Iwia̠ne ma̠ erugha̠n eb̠la̠ a̠nwunom d̠a̠ ekima̠, ma̠ e̠b̠ab̠ala d̠a̠ a̠misigh ta̠ A̠zib̠a̠, ezin bho̠ o̠ni̠ ola̠ ta̠ a̠rue abi̠gh Wa̠nwuna̠ bho̠ bo̠, a̠ten ka̠ o̠ni̠ bho̠ ab̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","Iwia̠ne ma̠ agu̠o̠ ola̠ o̠ni̠ ko omel d̠o̠ ad̠u̠a d̠a̠ e̠ne̠ghe̠ ta̠ A̠zib̠a̠, na̠ agu̠o̠ ola̠ igurumia̠n ologi ko omite d̠o̠ a̠soroni ma̠ akpe̠ sa̠ ta̠ awo̠l i̠se̠ api̠e̠ ma̠ eb̠la̠ ogbo. ");
INSERT INTO mgj_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","O̠ni̠ ko oma̠ra̠ ma̠ o̠ni̠ ma̠ od̠e e̠ma, bo̠d̠o̠ orugh ado̠l i̠te̠i̠ agu̠o̠ I̠so̠, wa̠ a̠bhin e̠kpa ed̠ia̠n a̠dinom e̠no̠gho̠man o̠kpana o̠nyi̠ wa̠ i̠na aro̠ bho̠ (wa̠ a̠wol a̠dila̠de o̠kpana o̠nyi̠ ma̠ e̠kpa ed̠ia̠n bho̠). ");
INSERT INTO mgj_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","Obhel a̠ten, ma̠ agu̠o̠ inyin uloghom bho̠, bha̠ i̠na agi̠ ka̠ o̠te̠i̠ e̠no̠gho̠man o̠kpana o̠nyi̠ wa̠ i̠na aro̠ bho̠, ya̠a̠ ughel i̠na. Eb̠la̠ agu̠o̠ i̠na a̠bhin d̠a̠ ed̠i a̠puru ma̠ e̠no̠gho̠man bho̠ eka̠, i̠na na̠ orue d̠o̠ ma̠ onwe abar wa̠ i̠na a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","Inyin uru d̠o̠ d̠a̠ esi ola̠ od̠i ma̠ agu̠o̠ Igu Asai̠nai̠ wa̠ ta̠ orue o̠bi̠gh okula̠n bho̠, bo̠d̠o̠ d̠a̠ e̠ba anya, bo̠d̠o̠ d̠a̠ o̠b̠u̠ghu̠b̠u̠gh ola̠ na̠ a̠lo, bo̠d̠o̠ d̠a̠ o̠sai̠ (obom o̠fe̠gu̠), ");
INSERT INTO mgj_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","bo̠d̠o̠ oghur od̠od̠ue, bo̠d̠o̠ d̠a̠ okoroko ola̠ na̠ agba ma̠ i̠di̠ar ya̠ a̠nwunom ya̠ na̠ e̠mu̠gho̠n bho̠ na̠ e̠le̠gh agu̠o̠ ola̠ ta̠ osobh asu̠gbagba ya̠ na̠ o̠gba na̠ onigha̠ awa bho̠, ");
INSERT INTO mgj_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","ezin bho̠ awa irue d̠o̠ ma̠ ogir agu̠o̠ u̠to̠ unigha̠ awa bho̠ ma̠a̠, “E̠nam ka̠ a̠kula̠n igu bho̠ eka̠, bha̠ irobhod̠i ma̠ egigh.” ");
INSERT INTO mgj_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","Abar bho̠ a̠d̠igh a̠rugugu ka̠ ate̠i̠ esi ola̠ A̠mozizi a̠fugh ma̠a̠, “Ami̠ na̠ a̠bhin igiri ma̠ ebla̠ a̠rugugu.” ");
INSERT INTO mgj_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","Ya̠a̠, inyin na̠ uru d̠a̠ Igu A̠zio̠n, obom e̠ma ta̠ A̠zib̠a̠ wa̠ od̠i d̠a̠ a̠ghud̠um bho̠, wa̠ aro̠ ma̠ A̠zeruse̠le̠m ote̠nany bho̠. Inyin na̠ oru d̠a̠ o̠d̠e̠ ta̠ ibom ro̠lo̠gh itileduom ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","Inyin na̠ oru d̠a̠ a̠kokod̠ia̠n i̠kpana anwi̠ny ta̠ A̠zib̠a̠, ogbo ya̠ na̠ o̠ge̠ ma̠ a̠rid̠ien d̠a̠ ote̠nai̠ny bho̠. Inyin na̠ oru d̠a̠ A̠zib̠a̠ na̠ agu̠o̠ wa̠ na̠ a̠sobh o̠kpe̠ na̠ a̠gboloma̠ ma̠ eb̠la̠ i̠di̠ar bho̠. Inyin na̠ oru d̠a̠ aru̠mu̠gh ogbo ya̠ i̠b̠ab̠ala, sa̠ na̠ eten i̠b̠ab̠alab̠ab̠ala ma̠ i̠se̠n e̠mado̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","Inyin na̠ oru d̠a̠ A̠zizo̠s, wa̠ na̠ amara ma̠ enie d̠a̠ esa̠d̠io omom i̠zo̠ bho̠ na̠ A̠zib̠a̠ bho̠, na̠ d̠a̠ asi̠ ya̠ i̠na a̠zu bho̠, ya̠ id̠igh asu̠wo̠ ipu ma̠ ekekuwa̠ (ed̠i) ta̠ Ebe̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","Ikpona̠ b̠o̠ka̠ inyin ughel o̠ni̠ wa̠ na̠ agba ma̠ i̠d̠i̠ar i̠nye̠n na̠ a̠nigha̠ inyin bho̠. Ku̠gba ma̠a̠ awa imiza̠n d̠o̠ ma̠ igiel bho̠ awa ighel i̠na wa̠ anyagh ra̠to d̠awa ma̠ i̠se̠n a̠de onon bho̠, a̠dina̠mu i̠yar, ku̠gba ma̠a̠ i̠yar oghil o̠d̠u̠a d̠o̠yo̠, wa̠ od̠i d̠a̠ ote̠nany na̠ a̠bhin aghi̠m na̠ a̠kikiom i̠yar bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","D̠a̠ obhel obha̠, okoroko d̠o̠yo̠ a̠nyegi ma̠ e̠mara̠nwunom bho̠, ya̠a̠ i̠se̠n, i̠na na̠ agba ma̠a̠, “Ami̠ ta̠ a̠mula̠ a̠nyegi epa̠ ma̠ e̠mara̠nwunom bho̠, ab̠aram na̠ e̠nai̠ny bho̠.” ");
INSERT INTO mgj_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","Onon (omula̠ onyegi epa̠) na̠ a̠ma̠ra̠ ma̠a̠ ta̠ od̠ur eb̠la̠ i̠di̠ar ya̠ u̠le̠m bho̠ o̠si̠ghe̠, b̠o̠ka̠ i̠di̠ar ya̠ ko orue d̠o̠ ed̠ura̠n bho̠ e̠ri̠la. ");
INSERT INTO mgj_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠se̠bh A̠zib̠a̠ ma̠ agu̠o̠ i̠yar na̠ o̠te̠i̠ ani̠ ma̠ e̠ne̠ghe̠ od̠igh d̠a̠ irileghom (a̠de onwuna̠ e̠ma) wa̠ ko onwegia̠n d̠o̠ bho̠. Id̠ighi obhin d̠a̠ o̠ki̠ri̠me̠ni̠ ozu igielake̠ na̠ a̠rugugu o̠ko̠l i̠na d̠a̠ agu̠o̠ ola̠ ta̠ ed̠igh i̠na ma̠ ologi bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","Ezin bho̠, A̠zib̠a̠ d̠i̠yar anya ola̠ na̠ a̠d̠e na̠ a̠kunugi. ");
INSERT INTO mgj_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","Odi aro̠ ma̠ otula̠n otula̠n odi ma̠ agu̠o̠ a̠rumor na̠ aru̠marani̠ ya̠ onin ologi ima̠ra̠ (id̠umom) bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","O̠ni̠ ko o̠we̠le̠man ma̠ o̠da isuloma̠ obhin, ezin bho̠, idi a̠nwunom na̠ e̠da ma̠ itileduom ta̠ A̠zib̠a̠ ebhin ya̠a̠ iloghoma̠n d̠o̠ ma̠ oku̠a. ");
INSERT INTO mgj_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","I̠ru̠ru̠ane̠ ma̠ egboloma̠ ma̠ ogbo ya̠ od̠i ma̠ ikoli bho̠, ma̠ agu̠o̠ ola̠ ta̠ agu̠b̠an ka̠ inyin od̠i na̠ awa d̠a̠ ikoli bho̠. I̠ru̠ru̠ane̠ nyen ogbo ya̠ na̠ e̠bi̠gh ali̠gam a̠ruzu bho̠, ma̠ agu̠o̠ ola̠ ta̠ agu̠b̠an ka̠ inyin na̠ o̠bi̠gh ani̠ ma̠ a̠d̠ien ali̠gam a̠ruzu d̠awa. ");
INSERT INTO mgj_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","Ilom abar ola̠ akpe̠ ma̠ eb̠la̠ ogbo ma̠ obu̠ghu̠me̠ni̠ (obhin o̠tu̠o̠m abar), sa̠ akpe̠ ma̠ a̠siwolom na̠ a̠nwani̠ d̠awa ma̠ obhin odi od̠ia̠n i̠zo̠. Ezin bho̠, A̠zib̠a̠ ta̠ a̠sobh ase̠ a̠bhumeni ma̠ rod̠eme̠ma ya̠ o̠ro̠ d̠o̠ d̠a̠ ilom na iya̠ od̠i d̠a̠ ilom. ");
INSERT INTO mgj_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","Irughe ma̠ ra̠ghud̠um d̠inyin eguri ma̠ agu̠o̠ ola̠ inyin ko oba̠ra̠ d̠o̠ ma̠ okpoki, ya̠a̠ i̠di̠ar ya̠ inyin unwuna̠ bho̠ elegha̠n inyin, ezin bho̠ A̠zib̠a̠ agba ma̠a̠, “Bebina̠ obhel ola̠ ami̠ ta̠ awe̠le̠man anwa bo̠; ami̠ ko oghel/ogin d̠o̠ na̠ oghel/ogin anwa nyen.” ");
INSERT INTO mgj_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","Ebula̠ o̠ku̠a, i̠yar na̠ o̠kpo̠ ma̠ ologi na̠ o̠gba ma̠a̠, “Wa̠nwuna̠ bho̠ i̠na wa̠ o̠lo̠gh agu̠o̠ d̠ami̠; ami̠ ko oghil d̠o̠ ma̠ a̠rugugu. O̠nyi̠o̠mo̠ro̠ni̠ ta̠ a̠rue a̠gir ere a̠gboloma̠ ami̠?” ");
INSERT INTO mgj_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","I̠ru̠ru̠ane̠ ma̠ igba̠iny ogbo irileghom d̠inyin ya̠ i̠gba ma̠ a̠duom/o̠nu̠o̠kpe̠ ta̠ A̠zib̠a̠ inigha̠ inyin bho̠. I̠mare̠ ma̠ ekpon ed̠ighom d̠a̠ a̠ghud̠um d̠awa na̠ agu̠o̠ ibhin ikunugiom bho̠, ma̠ e̠ta ma̠ ologi ima̠ra̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","A̠zizo̠s Akrai̠st onin bho̠, wa̠ aro̠ ma̠ elegien a̠ten bho̠, wa̠ od̠i ma̠ a̠didon, na̠ wa̠ ta̠ aro̠ tu̠tu̠n kid̠ud̠ul bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠d̠ien kere kere na̠ irorua̠ atu̠ghu̠me̠ni ogelemeni d̠o̠ inyin. A̠limon a̠luzu ma̠ o̠wo̠l d̠a̠ e̠ne̠ghe̠ ta̠ A̠zib̠a̠ o̠te̠i̠ o̠ni̠, a̠bhon a̠pu ma̠ o̠ni̠ ma̠ obhin ed̠ia̠n ob̠em ologi. Ed̠ia̠n i̠ye̠ id̠igh d̠o̠ ma̠ asu̠o̠ enigha̠ ma̠ ogbo ya̠ na̠ ed̠e bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","I̠yar unwuna̠ ma̠ enwen ola̠ ogbo ya̠ na̠ egir d̠a̠ Otu-akpu̠ru̠ bho̠ eka̠ (rob̠a̠ra̠motu Otu-akpu̠ru̠ bho̠ eka̠) onwuna̠ d̠o̠ ma̠ a̠limon o̠te̠i̠ asu̠o̠ i̠ko̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","We̠mu̠ rokur bho̠ na̠ a̠bhin asi̠ i̠nam na̠ a̠d̠igh d̠a̠ A̠lukpesi Obom E̠tu̠tu̠ bho̠ ma̠ obhin o̠kpe̠ alu̠kpe̠ i̠karabh, ya̠a̠ na̠ omite d̠a̠ esi a̠kokod̠ia̠n (d̠a̠ otu-akpu̠ru̠) bho̠ na̠ o̠bhu̠gi̠ ma̠ rozu i̠nam bho̠ d̠a̠ etire. ");
INSERT INTO mgj_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","Onin agu̠o̠ bho̠ ubhin A̠zizo̠s umutiom d̠a̠ o̠nu̠ ogigo e̠ma bho̠ ka̠ ugbikimeni d̠a̠ etire, b̠o̠ka̠ a̠nwunom e̠wo̠l d̠a̠ asi̠ d̠o̠yo̠ e̠b̠ab̠ala. ");
INSERT INTO mgj_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","O̠ku̠a a̠d̠ighi be̠le̠ni̠, id̠ighi omite d̠a̠ otu-akpu̠ru̠ bho̠ ka̠ o̠te̠i̠ i̠na d̠a̠ etire, ma̠ i̠yar ogbika̠ ani̠ a̠d̠ien egbika̠ ya̠ i̠na a̠gbika̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","Ezin bho̠, i̠se̠n i̠yar unwuna̠ d̠o̠ ma̠ e̠ma ola̠ ta̠ aro̠ tu̠tu̠n kid̠ud̠ul, ya̠a̠ i̠yar na̠ ogon ema̠ ola̠ o̠ku̠a ma̠ oru. ");
INSERT INTO mgj_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","O̠ku̠a a̠d̠ighi be̠le̠ni̠, id̠ighi o̠wo̠l d̠a̠ a̠d̠ien ta̠ A̠zizo̠s o̠kpe̠ ma̠ alu̠kpe̠ itutumeni onigha̠ ma̠ A̠zib̠a̠ kigiel kigiel. ");
INSERT INTO mgj_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","Ya̠a̠ ko o̠we̠le̠man o̠lo̠gh agu̠o̠ onigha̠ ipa̠n a̠nwunom na̠ anwa ma̠ onigha̠ (o̠ru̠gi̠) gha̠n awa i̠di̠ar ya̠ anwa i̠te̠i̠. Ogir o̠ku̠a bha̠ od̠i ma̠ agu̠o̠ abar alu̠kpe̠ ola̠ a̠d̠igh A̠zib̠a̠ ma̠ ologi. ");
INSERT INTO mgj_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","I̠nagha ma̠ o̠nu̠o̠kpe̠ ogbo ya̠ na̠ erileghom inyin bho̠, ma̠ egir i̠di̠ar ya̠ awa na̠ o̠to̠ bho̠. Ezin bho̠ awa na̠ ekponom inyin sa̠ ta̠ e̠gba ma̠ agu̠o̠ awa igir enigha̠ ma̠ A̠zib̠a̠. O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ko ogurumeni ma̠ rologi b̠o̠ka̠ awa ebhin d̠a̠ a̠libhon ologi egir ogir d̠awa, kpe̠le̠me̠ni̠ ma̠ ogir na̠ ighunuma̠ sa̠ ko omutiom d̠o̠ ma̠ asu̠wo̠ enigha̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","Isiseinye ma̠ enigha̠ i̠yar, ezin bho̠ i̠yar uma̠ra̠ ma̠a̠ i̠walama d̠i̠yar ib̠eb̠i sa̠ na̠ ebhir i̠yar orugh ado̠l igielake̠ d̠a̠ eb̠la̠ i̠di̠ar (re̠kal). ");
INSERT INTO mgj_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","Abar wa̠ a̠lei abar a̠pu bho̠ bha̠, isiseinye ma̠ agu̠o̠ ola̠ ami̠ ta̠ anu̠r a̠ru ra̠ a̠zua̠n inyin (a̠d̠igh na̠ inyin aro̠). ");
INSERT INTO mgj_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","A̠zib̠a̠ wa̠ na̠ a̠nigha̠ ma̠ ekima̠ bho̠ a̠b̠eton Wa̠nwuna̠ i̠yar A̠zizo̠s d̠a̠ omugh. I̠se̠n bha̠ A̠zizo̠s od̠i ma̠ agu̠o̠ Obom Okponom Ro̠na̠na ola̠ A̠zib̠a̠ a̠bhin asi̠ bho̠ a̠d̠ia̠n i̠zo̠ wa̠ ekunuguma̠ o̠to̠ bho̠ na̠ ro̠nana d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","Ami̠ na̠ a̠siseiny agu̠o̠ ola̠ A̠zib̠a̠ ta̠ a̠d̠ighi ma̠ ola̠ inyin ta̠ o̠nagha ma̠ o̠nu̠o̠kpe̠ d̠o̠yo̠, na̠ agu̠o̠ ola̠ ta̠ ebhir inyin ogir ya̠ igielake̠ kigiel kigiel. A̠zizo̠s alo̠gh agu̠o̠ a̠nigha̠ inyin ogir ya̠ i̠kpe̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠. Isosorogia̠n e̠ro̠ enigha̠ ma̠ A̠zizo̠s Akrai̠st tu̠tu̠n ka̠ od̠ua̠l id̠ud̠ul. Aro̠ ma̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","A̠rumor na̠ aru̠marani̠ d̠ami̠ ya̠ onin ima̠ra̠ ologi bho̠, ami̠ na̠ a̠siseiny inyin o̠nagha a̠kikiom ya̠ ami̠ ibhin d̠a̠ a̠lebh na̠ akpo̠me̠ni̠ ma̠ rologi d̠inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","Iloghome ma̠ na̠ omutiom A̠timoti d̠a̠ ikoli. D̠a̠ obhel ola̠ ko obia̠ d̠o̠, i̠na ta̠ a̠ru ra̠ a̠misi ma̠ i̠se̠n, sa̠ i̠na ta̠ a̠d̠igh na̠ ami̠ ra̠ a̠zua̠n inyin. ");
INSERT INTO mgj_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","Ipura̠ne ma̠ eb̠la̠ ogbo aru̠mu̠ d̠inyin na̠ eb̠la̠ a̠nwunom ta̠ A̠zib̠a̠ iyed̠i. A̠nwunom ta̠ A̠zib̠a̠ ya̠ od̠i d̠a̠ ebhugh Ita̠li (Itili) bho̠ i̠gba ma̠a̠ ami̠ ipura̠n inyin. ");
INSERT INTO mgj_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","E̠ne̠ghe̠ (Igbirigbir) ta̠ A̠zib̠a̠ e̠ro̠ na̠ inyin.");
INSERT INTO mgj_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Ami̠ A̠zemsi̠ ob̠a̠ra̠motu ta̠ A̠zib̠a̠ na̠ ta̠ Wa̠nwuna̠ A̠zizo̠s Akrai̠st na̠ age̠ na̠ a̠ruom inyin ra̠ d̠iobh na̠ i̠wal (12) roghol ya̠ na̠ e̠sasaragi̠an d̠a̠ rebhugh e̠mara̠nwunom bho̠. Ami̠ na̠ a̠bheleguma̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","A̠rumor na̠ aru̠marani̠ d̠ami̠, ibhone ma̠ ologi ma̠ igiel a̠d̠ien kere kere ro̠d̠aokpon na̠ e̠te̠i̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Iloghome ma̠a̠, ro̠d̠aokpon i̠ye̠ na̠ e̠d̠a ma̠ ologi ima̠ra̠ d̠inyin na̠ ekpon, sa̠ na̠ ed̠ighi ma̠ ola̠ inyin ta̠ orue one ma̠ a̠ma̠ne. ");
INSERT INTO mgj_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Ya̠a̠, iwia̠ne ma̠ agu̠o̠ ola̠ inyin ta̠ one kabar kabar obhin ka̠ okunugiom, b̠o̠ka̠ inyin od̠ikighu ma̠ aru̠mu̠, o̠ghu̠a oleghemeni, sa̠ abar ko o̠kparama d̠o̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Ya̠a̠, ku̠gba ma̠a̠ na̠ ebhir o̠ni̠ inyin o̠te̠i̠ eloghomabar, bha̠ o̠ni̠ bho̠ a̠puru ma̠ A̠zib̠a̠ wa̠ na̠ a̠bhin onyen ologi na̠ a̠nigha̠ ko̠ni̠ko̠ni̠ bho̠, sa̠ ta̠ a̠nigha̠ i̠na. A̠zib̠a̠ na̠ o̠gam d̠o̠ a̠nigha ma̠ o̠ni̠ ola̠ a̠puru i̠na ma̠ abar. ");
INSERT INTO mgj_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Ya̠a̠, ogiel ola̠ anwa na̠ a̠puru ma̠ abar, bhine d̠a̠ ologi ima̠ra̠ ma̠ a̠puru. Ologi d̠oyom o̠gba d̠o̠ i̠wal i̠wal, ezin bho̠ o̠ni̠ ola̠ ologi na̠ agba i̠wal i̠wal od̠i ka̠ opoka̠na̠n amu̠m d̠a̠ abadi̠ wa̠ okukugh na̠ a̠pughe na̠ a̠nuom na̠ agi̠, na̠ a̠nuom a̠ru bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","O̠ni̠ ola̠ o̠ku̠a o̠ru̠ru̠an d̠o̠ ma̠a̠ i̠na ta̠ a̠rue ate̠i̠ abar d̠a̠ agu̠o̠ ta̠ Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","O̠ni̠ ola̠ o̠ku̠a, bha̠ ologi na̠ agba i̠wal i̠wal, sa̠ na̠ a̠kpokolo d̠a̠ eb̠la̠ od̠ighi i̠di̠ar d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Ya̠a̠, o̠ni̠ ola̠ od̠i d̠a̠ onin id̠umom ta̠ Akrai̠st, ola̠ a̠goiny d̠a̠ e̠kal abar, bha̠ a̠bhon ologi ma̠ igiel A̠zib̠a̠ na̠ a̠b̠eton i̠na. ");
INSERT INTO mgj_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Ya̠a̠, o̠li̠la o̠ni̠ ola̠ od̠i d̠a̠ onin id̠umom ta̠ Akrai̠st, a̠bhon ologi ma̠ igiel A̠zib̠a̠ na̠ a̠guri i̠na d̠a̠ a̠dila̠de o̠ki̠ri̠me̠ni̠ ozu. Ezin bho̠, o̠li̠la o̠ni̠ ta̠ a̠ru sa̠ ta̠ a̠ten ad̠u̠a, ma̠ agu̠o̠ ra̠lele i̠gho̠gho̠ ologi ed̠um na̠ e̠nyu̠n na̠ emugughu bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Ra̠lele bho̠ na̠ e̠nyu̠n d̠a̠ ebula̠ e̠si̠so̠ ogogo bho̠. Obom e̠si̠so̠ bho̠ na̠ api̠e̠ ma̠ i̠mu̠nu̠mu̠n na̠ a̠libhon ra̠lele bho̠. Obha̠ onin agu̠o̠ od̠ighi i̠di̠ar o̠li̠la bho̠ ta̠ eten emunia̠n. ");
INSERT INTO mgj_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Itutumeni ta̠ e̠ro̠ enigha̠ ma̠ i̠na o̠ni̠ wa̠ a̠ne amara gigiribh d̠a̠ ad̠agi̠an bho̠, ezin bho̠ ta̠ ozuom i̠na ma̠ eghoiy a̠ghud̠um wa̠ Wa̠nwuna̠ bho̠ a̠gua̠n onigha̠ ogbo ya̠ itula̠n i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","O̠ni̠ ola̠ ad̠agi̠an i̠te̠i̠ o̠gba d̠o̠ ma̠a̠, “A̠zib̠a na̠ ad̠agi̠an ami̠.” Ezin bho̠, ko orue d̠o̠ o̠d̠agi̠an A̠zib̠a ma̠ ogir i̠karabh, sa̠ i̠na na̠ agu̠o̠ eka̠ o̠d̠agi̠an d̠o̠ ma̠ o̠ni̠ nyen. ");
INSERT INTO mgj_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Ya̠a̠, i̠karabh ebhiroma̠ o̠ni̠ na̠ agu̠o̠, na̠ e̠le̠ge̠ ma̠ o̠ni̠, na̠ e̠nyagh o̠ni̠ bho̠ na̠ ed̠ighom d̠a̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Sa̠, igiel o̠ni̠ a̠guri ma̠ i̠karabh ebhiroma̠ d̠a̠ ologi, sa̠ na̠ e̠mar i̠karabh na̠ emutiom, sa̠ igiel i̠karabh bho̠ na̠ e̠te̠i̠ d̠a̠ ekunuguma̠ bho̠, sa̠ na̠ eruom omugh. ");
INSERT INTO mgj_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","A̠rumor na̠ aru̠marani̠ ed̠ighologi d̠ami̠, o̠ni̠ ogelemeni d̠o̠ inyin. ");
INSERT INTO mgj_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Kerekere ob̠eb̠i abar na̠ ob̠eb̠i e̠ne̠ghe̠ na̠ ad̠u̠a d̠a̠ ote̠nai̠ny na̠ a̠ru, d̠a̠ agu̠o̠ O̠we̠de̠ wa̠ ale̠m re̠b̠alab̠al ya̠ od̠i d̠a̠ e̠nai̠ny bho̠. I̠na na̠ onwegia̠n d̠o̠, i̠na na̠ od̠ura̠n d̠o̠ a̠mutiom okokogh azi̠m nyen. ");
INSERT INTO mgj_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","D̠a̠ i̠to̠ d̠o̠yo̠, sa̠ i̠na a̠bhin o̠nu̠o̠kpe̠ a̠gia̠ga̠i d̠o̠yo̠ a̠nwe amar i̠yar, a̠tenemeni ma̠ i̠pu̠r imuma̠ d̠a̠ i̠di̠ar ya̠ i̠na ale̠m bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","A̠rumor na̠ aru̠marani̠ ed̠ighologi d̠ami̠, i̠mu̠gho̠nyane̠ ma̠a̠: a̠bhon ko̠ni̠ko̠ni̠ ma̠ obhin d̠a̠ onyen o̠nagha abar, na̠ okimeni ozu kisa̠ ofugh abar. I̠na o̠nu̠r d̠o̠ agam i̠gam, ");
INSERT INTO mgj_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","ezin bho̠ i̠gam o̠nyi̠o̠mo̠ro̠ni̠ ko orue d̠o̠ emutiom a̠ma̠rugh igielake̠ ya̠ A̠zib̠a̠ na̠ abho̠ro̠gh o̠bi̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠we̠le̠mane̠ kerekere ado̠l i̠b̠i̠si̠ghe̠ni̠an na̠ i̠karabh ya̠ na̠ e̠ro̠ ma̠ omite omite bho̠. Kpe̠le̠me̠ni̠, i̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu ma̠ e̠da ma̠ o̠nu̠o̠kpe̠ wa̠ i̠na a̠gbebh d̠a̠ rologi d̠inyin bho̠, wa̠ ta̠ a̠rue a̠tenemeni inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","O̠ni̠ ko o̠gaga ma̠ e̠nagha ma̠ o̠nu̠o̠kpe̠ bho̠ ku̠ku̠m, ma̠ egelemeni ma̠ a̠ruzu d̠inyin, ya̠a̠ igire ma̠ i̠di̠ar ya̠ o̠nu̠o̠kpe̠ bho̠ na̠ agba bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","O̠ni̠ ola̠ amu̠gho̠n o̠nu̠o̠kpe̠ bho̠, sa̠ awe̠le̠man ogir agu̠o̠ agba bho̠, bha̠ agu̠b̠an o̠ni̠ ola̠ a̠bha̠gha̠ ma̠ a̠misigh d̠o̠yo̠ d̠a̠ obha̠gha̠ma̠, ");
INSERT INTO mgj_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","sa̠ a̠ten ad̠u̠a, sa̠ a̠weleta̠n agu̠o̠ ozu d̠o̠yo̠ od̠i, ma̠ i̠se̠ onin obhel bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Ya̠a̠, o̠ni̠ ola̠ amar a̠kimeni a̠kpon eb̠la̠ oloko wa̠ na̠ a̠tenemeni ma̠ a̠nwunom bho̠, sa̠ aro̠ ma̠ ogir ogir o̠ku̠a, sa̠ oweleta̠n d̠o̠ ma̠ i̠di̠ar ya̠ i̠na amu̠gho̠n bho̠, bha̠ A̠zib̠a ta̠ a̠tutumeni ma̠ ogir o̠ni̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","O̠ni̠ ola̠ na̠ aru̠ru̠an ma̠a̠ i̠na na̠ a̠loghom A̠zib̠a̠, ya̠a̠ na̠ orue d̠o̠ ma̠ osibhom a̠nem d̠o̠yo̠, bha̠ na̠ a̠gelemeni ma̠ ozu d̠o̠yo̠, sa̠ ologhom A̠zib̠a̠ d̠o̠yo̠ aro̠ ma̠ obhobho i̠kpo̠. ");
INSERT INTO mgj_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Ologhom A̠zib̠a̠ d̠a̠ a̠gi̠a̠ga̠i̠ sa̠ abar o̠li̠o̠m o̠ro̠ d̠o̠ d̠a̠ a̠misigh ta̠ A̠zib̠a̠ O̠we̠de̠ bho̠, bha̠ o̠lo̠gh agu̠o̠ onigha̠ anwi̠i̠ny ya̠ onweni na̠ o̠we̠de̠ o̠to̠, na̠ rekpukele anwani̠ d̠a̠ ali̠gam a̠ruzu d̠awa, na̠ oghel i̠karabh ado̠l e̠mara̠nwunom. ");
INSERT INTO mgj_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","A̠rumor na̠ aru̠marani̠ d̠ami̠, ogbo ya̠ ima̠ra̠ ma̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st wa̠ isosorogia̠n bho̠, o̠ni̠ ko okpon o̠ni̠ d̠a̠ a̠misigh ma̠ egir abar. ");
INSERT INTO mgj_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Obhin o̠tu̠o̠m ma̠a̠, odi o̠li̠la o̠ni̠ ola̠ alo̠gi̠an ra̠gulu a̠gol sa̠ a̠bhin ib̠ebi̠ a̠rukpe a̠bura̠, na̠ onyigoiny o̠ni̠ ola̠ a̠bhin igba̠iny ipupu a̠rukpe a̠bura̠, ed̠igh eru d̠a̠ esi a̠kokod̠ia̠n d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ka̠ inyin ubhin o̠ni̠ wa̠ a̠bura̠ ma̠ ib̠eb̠i ibura̠ bho̠ i̠tu̠o̠m abar upu, sa̠ inyin u̠gba inigha̠ i̠na ma̠a̠, “Ro̠ ma̠ a̠dila̠de d̠a̠ ob̠eb̠i esi onon,” sa̠ inyin u̠gba unigha̠ ma̠ onyigoiny bho̠ ma̠a̠, “Mara ma̠ i̠se̠,” bo̠d̠o̠ “Ro̠ ma̠ a̠dila̠de d̠a̠ a̠de d̠a̠ aka i̠kasi̠ o̠gbam a̠wel d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","O̠ku̠a sa̠ na̠ aro̠ ma̠ ola̠, inyin na̠ o̠bhe̠l odi na̠ okpon odi na̠ ogurumeni d̠a̠ esa̠d̠io d̠inyin, sa̠ inyin na̠ oten ogbo osobh ase̠ i̠karabh i̠walama. ");
INSERT INTO mgj_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","A̠rumor na̠ aru̠marani̠ d̠ami̠, i̠mare̠ ma̠ e̠nagha. A̠zib̠a̠ aso̠n inyigoiny a̠nwunom e̠mara̠nwunom bho̠ ma̠ onwuna̠ ibom ologi ima̠ra̠, na̠ od̠igh na̠ o̠yo̠ od̠ed̠ia̠n d̠a̠ irileghom d̠o̠yo̠, ma̠ agu̠o̠ i̠na a̠gua̠n a̠nigha̠ ma̠ ogbo ya̠ itula̠n i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Ya̠a̠, inyin na̠ okpon ronyigoiny bho̠ na̠ ogurumeni. Aru̠lala bho̠ d̠o̠ ke̠re̠ ma̠ ogbo ya̠ na̠ eponoma̠ inyin bho̠? Awa d̠o̠ ma̠ ogbo ya̠ na̠ ed̠ud̠ur inyin na̠ ka̠ ed̠ighom d̠a̠ a̠rutu ase̠ bho̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Awa d̠o̠ ma̠ ogbo ya̠ na̠ efugh i̠basi̠ na̠ egboloma̠ ma̠ ob̠eb̠i a̠d̠ien wa̠ na̠ oseniom inyin bho̠ d̠o̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Ku̠gba ma̠a̠, inyin na̠ okoko ma̠ oloko wa̠ a̠lei abar a̠pu d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠, wa̠ agba ma̠a̠, “Tula̠ne ma̠ o̠ni̠ etua̠n d̠oyom ma̠ agu̠o̠ anwa itula̠n ozu d̠oyom bho̠,” bha̠ inyin na̠ o̠mar na̠ ogir. ");
INSERT INTO mgj_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ya̠a̠, ku̠gba ma̠a̠, inyin okpon a̠nwunom d̠a̠ a̠misigh ogir abar, bha̠ inyin u̠mar d̠o̠ ogir, sa̠ oloko bho̠ ta̠ a̠sobh ase̠ a̠bhumeni inyin ma̠a̠ inyin id̠ighi ma̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ku̠gba ma̠a̠, o̠ni̠ a̠koko ma̠ eb̠la̠ roloko bho̠ sa̠ a̠sor odi, bha̠ i̠na a̠sor eb̠la̠yi. ");
INSERT INTO mgj_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Onin A̠zib̠a̠ wa̠ agba ma̠a̠, “Ko od̠e ma̠ e̠ma” bho̠, agba ma̠a̠, “Ko ogigh o̠ni̠.” Ka̠ aro̠ ma̠ ola̠ anwa od̠e d̠o̠ ma̠ e̠ma, sa̠ anwa igigh o̠ni̠, bha̠ anwa na̠ a̠ten o̠ni̠ ola̠ a̠sor oloko bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠fugh o̠nu̠ d̠inyin, na̠ od̠ighi i̠di̠ar d̠inyin, e̠ro̠ ma̠ agu̠o̠ ita̠ a̠nwunom ya̠ ta̠ obhin oloko wa̠ a̠tenemeni i̠yar bho̠ osobh ase̠ ogboloma̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Igire ma̠ o̠ku̠a, ezin bho̠, d̠a̠ a̠d̠a̠ma̠ osobh ase̠ bho̠, ko okpon d̠o̠ ma̠ igbirigbir ogboloma̠ ma̠ ogbo ya̠ okpon d̠o̠ ma̠ ipa̠n ogbo ma̠ igbirigbir. Igbirigbir na̠ ane̠gi̠me̠ni̠ ma̠ osobh ase̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","A̠rumor na̠ aru̠marani̠ d̠ami̠, ku̠gba ma̠a̠ o̠ni̠ agba ma̠a̠ i̠na a̠nwuna̠ ma̠ ologi ima̠ra̠, ya̠a̠ i̠na na̠ obhin d̠o̠ a̠gir abar, ka̠ ologi ima̠ra̠ ola̠ o̠ku̠a ta̠ a̠rue a̠tenemeni i̠na ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Ku̠gba ma̠a̠ inyin ologhom umor, bo̠d̠o̠ u̠marani̠ ola̠ onwuna̠ d̠o̠ ma̠ a̠ga̠i akapa, bo̠d̠o̠ ed̠ia̠n ya̠ od̠e, ");
INSERT INTO mgj_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","sa̠ odi o̠ni̠ inyin agba a̠nigha̠ i̠na ma̠a̠, “Gi̠e̠ na̠ ekima̠! Okirika̠ od̠ighi d̠o̠ nya̠m, ma̠ ate̠i̠ ed̠ia̠n ya̠ od̠e olegha̠n!” Ya̠a̠, anwa na̠ onigha̠ d̠o̠ i̠na ma̠ i̠di̠ar ya̠ ozu d̠o̠yo̠ na̠ a̠puru bho̠, ka̠ asu̠o̠ bho̠ ka̠ ere? ");
INSERT INTO mgj_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Onin agu̠o̠ bho̠ ologi ima̠ra̠ ola̠ ogir o̠tu̠o̠no̠m d̠o̠ aro̠ ma̠ omumugh. ");
INSERT INTO mgj_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Obhin o̠tu̠o̠m ma̠a̠ odi o̠ni̠ agba ma̠a̠, “Anwa a̠nwuna̠ ma̠ ologi ima̠ra̠, ya̠a̠ ami̠ inwuna̠ ma̠ ogir.” Sa̠ ami̠ ta̠ awo̠ran ma̠a̠, “Leriome ami̠ ma̠a̠ ologi ima̠ra̠ d̠oyom ya̠ ogir o̠ro̠ d̠o̠ bho̠, sa̠ ami̠ ta̠ a̠bhin rogir d̠ami̠ a̠leriom anwa ma̠ ologi ima̠ra̠ d̠ami̠.” ");
INSERT INTO mgj_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Anwa a̠ma̠ra̠ ma̠a̠ onin A̠zib̠a̠ od̠i. A̠bhon o̠ku̠a. A̠ruru bho̠ eka̠ ema̠ra̠ ma̠ o̠ku̠a, sa̠ na̠ eghil a̠rugugu na̠ ebhin igiri. ");
INSERT INTO mgj_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Anwa ema̠ o̠ni̠! Anwa na̠ abho̠ro̠gh o̠bi̠gh elegh ola̠ ta̠ a̠leriom ma̠a̠, ologi ima̠ra̠ ogir o̠to̠ ma̠ obhobho i̠kpo̠, d̠u̠ko̠? ");
INSERT INTO mgj_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Obom o̠we̠de̠ d̠i̠yar Ebraham, sa̠ A̠zib̠a̠ a̠bhelegi ma̠a̠ o̠ni̠ igielake̠ d̠a̠ ebula̠ ogir wa̠ a̠gir igiel bho̠ i̠na agbam o̠nyi̠ d̠o̠yo̠ Azi̠ki̠ d̠a̠ enwen i̠ko̠l bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Anwa na̠ abi̠gh agu̠o̠ i̠na a̠tulugi ma̠ ologi ima̠ra̠ d̠o̠yo̠ na̠ rogir d̠o̠yo̠. Sa̠ ubhin rogir d̠o̠yo̠ umuzoghod̠iom ologi ima̠ra̠ d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Onon a̠muzoghod̠iom agu̠o̠ u̠gba d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠, “Ebraham a̠ma̠ra̠ ma̠ A̠zib̠a̠, sa̠ i̠ye̠ iten od̠ighi i̠d̠iar igielake̠ ya̠ u̠lo̠gho̠m unigha̠ i̠na.” Sa̠ ubhelegi i̠na ma̠ a̠tologha̠n ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","I̠se̠n, inyin na̠ o̠bi̠gh ma̠a̠ ogir ya̠ a̠nwunom na̠ egir na̠ eguri awa ma̠ a̠dila̠de e̠b̠ab̠ala d̠a̠ a̠misigh ta̠ A̠zib̠a̠, ologi ima̠ra̠ d̠awa ku̠ku̠m d̠o̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Obha̠ onin agu̠o̠ ubhin u̠bi̠gh A̠rehab od̠eme̠ma bho̠ ma̠ ani̠ e̠b̠ab̠ala, d̠a̠ ebula̠ ogir ya̠ i̠na a̠gir igiel bho̠ i̠na ada ma̠ ogbo ipoiny bho̠ a̠bhin, sa̠ a̠ruom awa ma̠ o̠wo̠l opa̠n agba o̠d̠u̠a bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Agu̠o̠ ozu o̠nyi̠o̠mo̠ro̠ni̠ ola̠ ipoghu o̠to̠ aro̠ ma̠ omumugh bho̠, obha̠ onin agu̠o̠ ologi ima̠ra̠ ola̠ ogir o̠to̠ aro̠ ma̠ omumugh. ");
INSERT INTO mgj_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","A̠rumor na̠ aru̠marani̠ d̠ami̠, o̠ni̠ ko owia̠n agu̠o̠ ola̠ a̠d̠izo inyin ta̠ oten ogbo atu̠ghu̠me̠ni̠. Ezin bho̠, inyin ologhom ma̠a̠ osobh ase̠ d̠i̠yar ogbo atu̠ghu̠me̠ni̠ bho̠ i̠kpar epu. ");
INSERT INTO mgj_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Eb̠la̠ i̠yar, o̠ni̠ ola̠ o̠pi̠o̠mghan d̠o̠ ma̠ abar d̠a̠ a̠d̠izo re̠kal bo̠. Ya̠a̠, ku̠gba ma̠a̠ o̠ni̠ ta̠ a̠rue a̠sibhom a̠nem d̠o̠yo̠ ma̠ ola̠ ko ofugh d̠o̠ ma̠ abar api̠e̠, bha̠ o̠ni̠ bho̠ na̠ a̠legha̠n d̠a̠ a̠ma̠rugh igielake̠, i̠na ta̠ a̠rue a̠sibhom eb̠la̠ ozu d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","I̠yar na̠ o̠kpu̠o̠m rikoli d̠a̠ aru̠nu̠ ro̠su̠ bo̠ka̠ i̠yar orue orileghom awa obhin o̠gi̠ kesikesi ola̠ a̠d̠igh i̠yar ologi. ");
INSERT INTO mgj_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Bo̠d̠o̠, ikpone ma̠ agu̠o̠ a̠rughugh abadi̠ i̠bu̠gh i̠te̠i̠, na̠ agu̠o̠ i̠kparakpar rogim na̠ egim na̠ eb̠oroghom, ku̠ku̠m eka̠, na̠ obhin o̠nyi̠ o̠gbara o̠d̠o̠m na̠ ob̠or, sa̠ na̠ agi̠ ma̠ agba o̠la ibhir i̠yar ob̠or o̠gi̠o̠m. ");
INSERT INTO mgj_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Onin agu̠o̠ a̠nem od̠i. D̠a̠ eb̠la̠ ali̠ki̠r d̠o̠yo̠ eka̠, na̠ are̠ma ma̠ ibom i̠di̠ar ya̠ i̠na ta̠ a̠rue a̠gir. Obha̠ agu̠o̠ o̠gbara eb̠olob̠ol anya ta̠ a̠rue a̠mumor anu̠o̠me̠ni̠ ma̠ obom e̠ghana. ");
INSERT INTO mgj_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","A̠nem od̠i ma̠ agu̠o̠ anya. A̠nem o̠karabh a̠limon ola̠ na̠ api̠e̠gi̠ ma̠ eb̠la̠ a̠risisi ozu o̠ni̠, sa̠ na̠ ata ma̠ anya ma̠ eb̠la̠ a̠ghud̠um o̠ni̠, sa̠ i̠na na̠ agu̠o̠ eka̠ na̠ a̠mumor na̠ anya ya̠ e̠banya ekunuguma̠ o̠to̠ bho̠ ata i̠na. ");
INSERT INTO mgj_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","O̠nyi̠o̠mo̠ro̠ni̠ a̠nwuna̠ ma̠ a̠limon a̠gboloma̠ ma̠ eb̠la̠ i̠nam ologi ed̠um, a̠d̠igh i̠di̠ar ya̠ na̠ e̠bhe̠bhe̠ghu̠, a̠d̠igh i̠nam ya̠ na̠ ekpulughu, na̠ i̠nam abadi̠, na̠ ina̠, sa̠ na̠ a̠rue na̠ a̠kponom awa. ");
INSERT INTO mgj_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Ya̠a̠, o̠nyi̠o̠mo̠ro̠ni̠ ta̠ orue d̠o̠ ma̠ osibhom a̠nem d̠o̠yo̠. I̠karabh ya̠ enen na̠ ebha̠, na̠ i̠d̠ai̠ iya̠ na̠ eruom omugh, imuzo d̠a̠ a̠nem o̠ni̠. ");
INSERT INTO mgj_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","I̠yar na̠ obhin a̠nem na̠ otutumeni ma̠ Wa̠nwuna̠ na̠ O̠we̠de̠ d̠i̠yar, sa̠ na̠ obhin onin a̠nem bho̠ na̠ orogi ma̠ a̠nwunom ya̠ A̠zib̠a̠ ale̠m agu̠b̠e̠ni̠ ma̠ ozu d̠o̠yo̠ bho̠ ");
INSERT INTO mgj_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","I̠yar na̠ obhin onin o̠nu̠ bho̠ na̠ a̠mutioghom itutumeni na̠ itogi. A̠rumor na̠ aru̠marani̠ d̠ami̠, na̠ obhon d̠o̠ ma̠ o̠ro̠ o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Amu̠m a̠b̠ugu na̠ amu̠m ala ta̠ erue emite d̠a̠ onin ogugua̠ amu̠m ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","A̠rumor na̠ aru̠marani̠ d̠ami̠, oriren a̠fig ta̠ a̠rue a̠mum itu oliv ke̠re̠, bo̠d̠o̠ ka̠ od̠id̠igh a̠grep ta̠ a̠rue a̠mum itu a̠fig ke̠re̠? Amu̠m a̠b̠ugu ta̠ erue emite d̠a̠ ogugua̠ amu̠m ola̠ amu̠m ala imuzo ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ogbo ya̠ iloghom abar sa̠ inwuna̠ ma̠ amu̠gho̠nyan od̠i d̠a̠ esa̠d̠io d̠inyin ke̠re̠? Ku̠gba ma̠a̠ od̠i, bha̠ awa ebhin d̠a̠ a̠ma̠rugh igielake̠, na̠ o̠ki̠ri̠me̠ni̠ ozu, na̠ eloghom abar d̠a̠ eb̠la̠ i̠di̠ar, eleriom o̠ku̠a. ");
INSERT INTO mgj_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Ya̠a̠, ku̠gba ma̠a̠ i̠kparakpar a̠gbokia̠n na̠ o̠ku̠ku̠ imuzo d̠a̠ rologi d̠inyin, bha̠ o̠ro̠ d̠o̠ ma̠ ola̠ inyin ta̠ obhin obo, bo̠d̠o̠ ta̠ o̠gba ma̠ igunugha̠ okpegiom a̠gia̠ga̠i bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Eloghom abar ya̠ o̠ku̠a i̠d̠u̠a d̠o̠ d̠a̠ ote̠nai̠ny eru, ya̠a̠, i̠d̠u̠a d̠a̠ e̠mara̠nwunom eru, sa̠ i̠ro̠ ma̠ iya̠ Eru bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Esi ola̠ a̠gbokia̠n na̠ o̠ku̠ku̠ od̠i, i̠se̠ esi asu̠su̠ghu̠d̠i̠an na̠ a̠d̠ien kerekere i̠karabh od̠i nyen. ");
INSERT INTO mgj_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Ya̠a̠, eloghom abar ola̠ ad̠u̠a d̠a̠ ote̠nai̠ny a̠ru, bha̠ ta̠ a̠d̠ia̠ aro̠ ma̠ abar ola̠ e̠b̠ab̠ala, sa̠ ta̠ a̠mutiom ekima̠, na̠ o̠ki̠ri̠me̠ni̠ ozu, na̠ etula̠n. Ta̠ a̠muzo na̠ okpon igbirigbir, sa̠ ta̠ a̠mum imuma̠ ib̠eb̠i od̠ighi i̠di̠ar, ko o̠bhe̠l d̠o̠ ma̠ odi o̠ni̠ a̠kpon opa̠n a̠gurumeni, sa̠ ko o̠gba d̠o̠ ma̠ opa̠n abar a̠gir opa̠n nyen. ");
INSERT INTO mgj_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","A̠nwunom ya̠ na̠ ed̠ighi ma̠ ekima̠ na̠ egbebh ikpo ekima̠, sa̠ ta̠ eb̠u ma̠ ikpo ed̠ia̠n igielake̠. ");
INSERT INTO mgj_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Eb̠la̠ relobhiri na̠ ro̠b̠e̠m d̠inyin ka̠ na̠ e̠d̠u̠a d̠a̠ a̠ken na̠ eru? Awa i̠d̠u̠a d̠a̠ ebhiroma̠ e̠me̠me̠m i̠di̠ar e̠mara̠nwunom, ya̠ na̠ ewia̠n inyin kigiel kigiel d̠a̠ rologi d̠inyin bho̠ eru, ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Inyin na̠ o̠bho̠ro̠gh o̠te̠i̠ i̠di̠ar, ya̠a̠, inyin urue d̠o̠ ma̠ o̠te̠i̠, sa̠ inyin na̠ o̠ze̠gi̠ ma̠ a̠nwunom. Inyin na̠ o̠si̠matan i̠d̠i̠ar, ya̠a̠ inyin u̠te̠i̠ d̠o̠, sa̠ inyin na̠ o̠bu̠man na̠ owe. Inyin u̠te̠i̠ d̠o̠ ma̠ i̠di̠ar ya̠ inyin na̠ o̠bho̠ro̠gh bho̠, ezin bho̠ inyin upuru d̠o̠ ma̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ya̠a̠, igiel inyin upuru, inyin u̠te̠i̠ d̠o̠, ezin bho̠ inyin upuru ma̠ agu̠o̠ ola̠ osora̠n d̠o̠. Inyin na̠ opuru ma̠ o̠te̠i̠ i̠di̠ar e̠me̠me̠m e̠mara̠nwunom ya̠ igboloma̠ ma̠ a̠ruzu d̠inyin. ");
INSERT INTO mgj_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Inyin rod̠eme̠ma! Inyin uloghom d̠o̠ ma̠a̠, od̠igh na̠ e̠mara̠nwunom orilogha̠n na̠ a̠tenemeni inyin ogbo o̠lo̠gi̠an a̠d̠ien ta̠ A̠zib̠a̠ ke̠re̠? O̠ku̠a a̠d̠ighi be̠le̠ni̠, ko̠ni̠ko̠ni̠ ola̠ aso̠n otula̠n e̠mara̠nwunom na̠ a̠ten o̠ni̠ o̠lo̠gi̠an a̠d̠ien ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Bo̠d̠o̠ ka̠, inyin na̠ o̠ru̠ru̠an ma̠a̠, abar wa̠ A̠d̠ire E̠tu̠tu̠ bho̠ agba ma̠a̠, “E̠mu̠gh d̠o̠yo̠ wa̠ i̠na alo̠gh a̠guri d̠a̠ rologi d̠i̠yar bho̠, a̠nwuna̠ ma̠ obom etula̠n ya̠ a̠gbokia̠n a̠gboloma̠ i̠yar, sa̠ na̠ abho̠ro̠gh i̠yar o̠ro̠ iyo̠yo̠ ku̠ku̠m,” ma̠ ezin bo̠ ke̠re̠? ");
INSERT INTO mgj_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Ya̠a̠, A̠zib̠a̠ na̠ ane̠ghe̠ ma̠ e̠ne̠ghe̠ ya̠ i̠bu̠gh ipu ma̠ o̠ku̠a. Obha̠ ezin bho̠ u̠gba d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠a̠, “A̠zib̠a̠ na̠ adamaghan ogbo ya̠ na̠ e̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu bho̠, sa̠ na̠ abhe̠l ogbo ya̠ na̠ e̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu bho̠.” ");
INSERT INTO mgj_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","O̠ku̠a a̠d̠ighi be̠le̠ni̠, i̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu d̠inyin ma̠ enigha̠ ma̠ A̠zib̠a. I̠damaghane̠ ma̠ Eru bho̠, sa̠ i̠na ta̠ a̠kpo ma̠ eghil awe̠le̠ inyin ad̠u̠a. ");
INSERT INTO mgj_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Itua̠ne ma̠ A̠zib̠a̠, sa̠ i̠na ta̠ a̠tua̠n inyin. I̠titola̠ ma̠ aru̠gu̠o̠ d̠inyin, inyin rod̠ighi ma̠ i̠karabh! I̠b̠ab̠alame̠ni̠ ma̠ rologi d̠inyin, inyin ibhelebhel! ");
INSERT INTO mgj_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","I̠ku̠nu̠, ileghe, ma̠ e̠gba ma̠ igbir, ma̠ etenemeni ma̠ adi̠e̠l d̠inyin ed̠i, ado̠l o̠d̠e̠ d̠inyin eten i̠ku̠nu̠. ");
INSERT INTO mgj_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","I̠ki̠ri̠me̠ni̠ ma̠ a̠ruzu d̠a̠ a̠misigh ta̠ A̠zib̠a̠, sa̠ i̠na ta̠ a̠b̠eton inyin. ");
INSERT INTO mgj_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","A̠rumor na̠ aru̠marani̠, odi ofugh d̠o̠ ma̠ i̠karabh a̠fugh a̠gboloma̠ ma̠ odi. Ku̠gba ma̠a̠, o̠ni̠ a̠fugh i̠karabh a̠gboloma̠ ma̠ ogbo ya̠ na̠ ema̠ra̠ ma̠ Akrai̠st bho̠, bo̠d̠o̠ a̠sobh ase̠ a̠gboloma̠ awa, bha̠ i̠na abi̠gh Oloko bho̠ api̠e̠, sa̠ a̠sobh ase̠ a̠gboloma̠. Ku̠gba ma̠a̠ inyin osobh ase̠ ogboloma̠ ma̠ Oloko bho̠, bha̠ inyin ukoko d̠o̠ ma̠ Oloko bho̠, ya̠a̠ inyin na̠ oten ogbo osobh ase̠. ");
INSERT INTO mgj_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","A̠zib̠a̠ ku̠ku̠m a̠nigha̠ ma̠ Oloko bho̠, sa̠ aro̠ ma̠ osobh ma̠ ase̠ bho̠. I̠na ku̠ku̠m a̠nwuna̠ ma̠ a̠limon otenemeni na̠ o̠pi̠e̠gi̠. O̠ku̠a ka̠ anwa inwuna̠ ma̠ a̠kere a̠limon osobh ase̠ onigha̠ o̠ni̠ etua̠n d̠oyom? ");
INSERT INTO mgj_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","I̠se̠n i̠nagha, inyin ogbo ya̠ na̠ e̠gba ma̠a̠, “A̠didon bo̠d̠o̠ elegien a̠ru, i̠yar ta̠ o̠gi̠ d̠a̠ e̠ma onon bo̠d̠o̠ e̠ma obha̠, ka̠ o̠ro̠ ma̠ e̠mu̠ ala, ob̠ua̠ ma̠ a̠b̠ua̠ o̠te̠i̠ asu̠o̠.” ");
INSERT INTO mgj_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ya̠a̠, inyin ologhom agu̠o̠ ra̠ghud̠um d̠inyin ta̠ e̠ro̠ ma̠ elegien a̠ru, ke̠re̠? Inyin od̠i ma̠ agu̠o̠ o̠bhu̠bhu̠lu̠gi̠ ya̠ imite i̠ro̠ ma̠ ekud̠i obhel, a̠tepa̠ sa̠ iten obhobho i̠kpo̠ i̠mai̠ny i̠d̠u̠a nyen. ");
INSERT INTO mgj_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Kpe̠le̠me̠ni̠ bha̠ inyin ta̠ o̠gba kuma̠ o̠ko̠no̠n, “Ku̠gba ma̠a̠ od̠i d̠a̠ i̠to̠ ta̠ Wa̠nwuna̠ bho̠, bha̠ na̠ ebhir i̠yar o̠ro̠ d̠a̠ a̠ghud̠um ogir abar onon, bo̠d̠o̠, abar obha̠.” ");
INSERT INTO mgj_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Ya̠a̠, i̠se̠n bha̠ inyin na̠ o̠bu̠ghu̠me̠ni̠ ma̠ a̠ruzu, na̠ okue na̠ otutuma̠. Eb̠la̠ o̠bu̠ghu̠me̠ni̠ a̠ruzu i̠ye̠ i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","O̠ku̠a a̠d̠ighi be̠le̠ni̠, o̠ni̠ ola̠ a̠loghom ib̠eb̠i ya̠ i̠kpe̠ i̠na ma̠ ogir, sa̠ awe̠le̠ ma̠ ogir, bha̠ i̠na na̠ a̠gir i̠karabh. ");
INSERT INTO mgj_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Inyin aru̠lala bho̠ i̠nagha ami̠! Ileghe ma̠ e̠gba ma̠ igbir ma̠ egboloma̠ ma̠ e̠kparama ado̠l wa̠ na̠ a̠ru ra̠ o̠te̠i̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","E̠li̠la d̠inyin na̠ e̠b̠o̠ro̠ghu̠ ebhe, sa̠ ad̠u̠i̠ny na̠ ed̠e ma̠ a̠rukpe d̠inyin e̠pi̠e̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","A̠gol na̠ a̠silva̠ d̠inyin na̠ ed̠ikighu ma̠ o̠sari̠, sa̠ o̠sari̠ bho̠ ta̠ e̠ro̠ ma̠ elegh ebhum ase̠ d̠inyin, sa̠ o̠sari̠ bho̠ ta̠ ed̠e ma̠ ipulupul ozu d̠inyin agu̠o̠ anya. Ku̠ku̠m eka̠, inyin od̠id̠ia̠ na̠ okpol e̠li̠la d̠a̠ ra̠d̠a̠ma̠ ekunuguma̠ i̠nye̠n. ");
INSERT INTO mgj_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Bi̠ghe̠! Anwa ta̠ o̠kpe̠gi̠ d̠o̠ ma̠ ikpoki ogbo ya̠ anwa i̠ko̠ ma̠ ogir onigha̠ oyom d̠a̠ ari̠si̠ d̠oyom bho̠, sa̠ i̠se̠n sa̠ ikpoki ya̠ anwa ta̠ o̠kpe̠gi̠ d̠o̠ awa bho̠ na̠ eleghe na̠ emulughu ma̠a̠ olo aro̠ a̠nigha̠ nyam. I̠nagha, Wa̠nwuna̠ ma̠ eb̠la̠ a̠limon bho̠ na̠ amu̠gho̠n red̠i ogbo ob̠u ed̠ia̠n d̠oyom bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","I̠se̠n d̠a̠ e̠mara̠nwunom, inyin na̠ orugh ado̠l od̠e e̠li̠la odudugina̠, na̠ ogir i̠di̠ar ya̠ obhonomeni rologi d̠inyin. Inyin na̠ ob̠ologh ekpo na̠ ob̠a̠ra̠ ma̠ a̠d̠a̠ma̠ wa̠ ta̠ o̠ze̠ inyin o̠kanyo̠gh bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Inyin na̠ osobh ase̠ obhumeni ma̠ a̠nwunom, na̠ o̠ze̠ ma̠ ogbo ya̠ o̠pi̠o̠m d̠o̠ ma̠ abar, ya̠ orue d̠o̠ ma̠ owia̠n inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","O̠ku̠a a̠d̠ighi be̠le̠ni̠, a̠rumor na̠ aru̠marani̠ d̠ami̠, ine ma̠ eb̠a̠ra̠ ma̠ obhel Wa̠nwuna̠ bho̠ ta̠ a̠ru. I̠bi̠ghe̠ ma̠ agu̠o̠ ogbebh ma̠ ed̠ia̠n aro̠ na̠ a̠b̠a̠ra̠ ma̠ obhel ikpo ya̠ i̠na a̠gbebh bho̠ ta̠ eb̠om ed̠ia̠n ya̠ ilei abar. I̠na na̠ a̠ne na̠ a̠b̠a̠ra̠ ma̠ o̠lo̠bha wa̠ ta̠ a̠b̠on alo̠bh bho̠, na̠ o̠lo̠bha wa̠ ta̠ alo̠bh o̠gu̠man bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Inyin eka̠, ine ma̠ eb̠a̠ra̠. O̠ni̠ ko odugh, eb̠em ologi d̠inyin abu̠gh, ezin bho̠ eruoma̠ ta̠ Wa̠nwuna̠ bho̠ na̠ ate̠i̠ d̠a̠ e̠b̠ab̠a agu̠o̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","A̠rumor na̠ aru̠marani̠ d̠ami̠, odi oghunuma̠ d̠o̠ a̠gboloma̠ ma̠ odi, bo̠ka̠ A̠zib̠a̠ na̠ osobh ase̠ a̠bhumeni inyin. O̠ni̠ osobh ase̠ bho̠ na̠ a̠loghom amara d̠a̠ o̠nu̠otu bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","A̠rumor na̠ aru̠marani̠ d̠ami̠, i̠ta ma̠ ado̠l a̠ma̠ne ta̠ a̠riwil ya̠ ibhin a̠d̠ien ta̠ A̠zib̠a̠ i̠gba ma̠ asu̠gbagba bho̠. Awa ine ma̠ a̠ma̠ne d̠a̠ esa̠d̠io ali̠gam a̠ruzu ya̠ i̠te̠i̠ awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","I̠nagha! I̠yar na̠ obhin ma̠a̠ na̠ otutumeni ma̠ ogbo ya̠ ine ma̠ a̠ma̠ne d̠a̠ esa̠d̠io ali̠gam a̠ruzu bho̠. Inyin na̠ o̠mu̠gho̠n ogboloma̠ ma̠ a̠ma̠ne ta̠ A̠zobu, sa̠ inyin uloghom agu̠o̠ A̠zib̠a̠ alo̠gh agu̠o̠ a̠nigha̠ i̠na d̠a̠ ekunuguma̠ bho̠. Wa̠nwuna̠ bho̠ a̠muzo na̠ okpon igbirigbir, obha̠ ezin bho̠ i̠na a̠gir o̠ku̠a bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","A̠rumor na̠ aru̠marani̠ d̠ami̠, wa̠ a̠lei abar a̠pu bho̠, o̠ni̠ ko osibhigha̠ ma̠ ebhin a̠de bho̠, bo̠d̠o̠ ote̠nai̠ny, bo̠d̠o̠ opa̠n abar ed̠ia̠n i̠zo̠. Eb̠la̠ abar wa̠ inyin ta̠ ofugh bho̠, bha̠, “Yii” bo̠d̠o̠, “E̠e̠nyi̠” b̠o̠ka̠ usobh ase̠ obhumeni inyin. ");
INSERT INTO mgj_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","O̠ni̠ ola̠ na̠ abi̠gh ali̠gam a̠ruzu d̠a̠ esa̠d̠io d̠inyin od̠i ke̠re̠? I̠na a̠siseiny. O̠ni̠ inyin od̠i d̠a̠ ibo ke̠re̠? I̠na amo̠r aso̠r itutumeni. ");
INSERT INTO mgj_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","O̠ni̠ ola̠ na̠ anwe̠r od̠i d̠a̠ esa̠d̠io d̠inyin ke̠re̠? I̠na a̠lebh ikei aso̠si̠ bho̠ eru ra̠ esiseiny enigha̠ i̠na, ebhin amu̠nu̠ esigh i̠na, d̠a̠ a̠d̠ien ta̠ Wa̠nwuna̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","A̠siseiny ola̠ ologi ima̠ra̠ na̠ a̠lol na̠ a̠koko ma̠ o̠ni̠ asu̠nwe̠r na̠ a̠d̠umeni, sa̠ Wa̠nwuna̠ bho̠ na̠ a̠b̠eton i̠na. Ka̠ aro̠ ma̠ ola̠ o̠ni̠ bho̠ a̠gir i̠karabh eka̠, sa̠ na̠ o̠we̠le̠man i̠karabh bho̠. ");
INSERT INTO mgj_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","O̠ku̠a a̠d̠ighi be̠le̠ni̠, odi agba ma̠ i̠karabh d̠o̠yo̠ a̠nigha̠ ma̠ odi, odi a̠siseiny a̠nigha̠ ma̠ odi, bo̠ka̠ awa ed̠um. I̠kparapkar a̠siseiny ta̠ o̠ni̠ igielake̠ enwuna̠ ma̠ a̠limon, sa̠ na̠ elol ibom. ");
INSERT INTO mgj_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","I̠lai̠za aro̠ ma̠ o̠nyi̠o̠mo̠ro̠ni̠ ma̠ agu̠o̠ i̠yar od̠i bho̠, sa̠ i̠na a̠siseiny agu̠o̠ ola̠ a̠d̠io ko o̠lo̠bh d̠o̠, sa̠ a̠mite ma̠ ola̠ a̠d̠io o̠lo̠bh d̠o̠ d̠a̠ a̠de bho̠ i̠sar ala na̠ odin uwetire. ");
INSERT INTO mgj_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Sa̠ i̠na a̠mula̠ a̠siseiny, sa̠ e̠nai̠ny bho̠ a̠soroni ma̠ o̠lo̠bha sa̠ a̠de bho̠ a̠b̠om ed̠ia̠n. ");
INSERT INTO mgj_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","A̠rumor na̠ aru̠marani̠, ku̠gba ma̠ odi o̠ni̠ d̠a̠ esa̠d̠io d̠inyin a̠mel ad̠u̠a d̠a̠ a̠gia̠ga̠i bho̠, sa̠ odi o̠ni̠ a̠rileghom i̠na a̠mulumeni, ");
INSERT INTO mgj_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","bha̠ o̠ni̠ bho̠ a̠loghom ma̠a̠: o̠ni̠ wa̠ a̠d̠ighi ma̠ ola̠ od̠ighi ma̠ i̠karabh a̠tiba̠ra̠ d̠a̠ i̠karabh d̠o̠yo̠ bho̠ a̠tenemeni ma̠ eloghoma̠n ozu ta̠ od̠ighi ma̠ i̠karabh bho̠ d̠a̠ omugh, sa̠ na̠ a̠d̠ighi ma̠ ola̠ na̠ okpon a̠d̠izo i̠karabh na̠ o̠si̠ghe̠ ma̠ a̠d̠ien.");
INSERT INTO mgj_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","A̠zud, ob̠a̠ra̠motu ta̠ A̠zizo̠s Akrai̠st na̠ umor ta̠ A̠zemsi, na̠ age̠ na̠ agi̠o̠m ogbo ya̠ A̠zib̠a̠ O̠we̠de̠ bho̠ a̠tula̠n, sa̠ a̠bhelegi, sa̠ na̠ a̠guri a̠sisa̠n A̠zizo̠s Akrai̠st bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Igbirigbir, na̠ ekima̠, na̠ etula̠n e̠ro̠ na̠ inyin ibom. ");
INSERT INTO mgj_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","A̠rumor ed̠igh ologi d̠ami̠, ami̠ na̠ a̠bhin agu̠o̠ e̠mi̠ d̠ami̠ a̠lei bho̠ na̠ a̠wia̠n o̠ge̠ a̠lebh onon oruom inyin, ma̠ agu̠o̠ a̠gboloma̠ ma̠ onin itenemeni d̠i̠yar, d̠a̠ obhel ola̠ ami̠ i̠bi̠gh ma̠a̠ a̠sora̠n ami̠ ma̠ o̠nu̠r o̠kparame̠ni̠ o̠ge̠ onigha̠ inyin agu̠o̠ ola̠, inyin ta̠ o̠kpo̠ ma̠ ologi o̠damaghan a̠limon wa̠ na̠ a̠wia̠n atu̠ghu̠me̠ni̠ ologi ima̠ra̠ wa̠ A̠zib̠a̠ a̠b̠eton a̠nigha̠ ma̠ ogbo e̠b̠ab̠ala bho̠ amado̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Ezin bho̠, idi ogbo ya̠ oghila̠n d̠o̠ ma̠ A̠zib̠a̠ na̠ ebhin ikoiny ed̠igh d̠a̠ esa̠d̠io d̠i̠yar. Awa ogbo ya̠ na̠ enwe ma̠ ib̠eb̠i o̠nu̠o̠kpe̠ e̠ne̠ghe̠ ta̠ A̠zib̠a̠ d̠i̠yar bho̠, ma̠ agu̠o̠ ola̠ okpegiom i̠karabh od̠ighi i̠di̠ar d̠awa, sa̠ na̠ eghel A̠zizo̠s Akrai̠st wa̠ i̠na ku̠ku̠m aro̠ ma̠ We̠mu̠ na̠ Wa̠nwuna̠ d̠i̠yar bho̠. D̠a̠ owewegh obhel, owa̠ d̠a̠ A̠d̠ire E̠tu̠tu̠ bho̠ ma̠ a̠d̠ien ase̠ egbika̠ wa̠ usobh unigha̠ ma̠ a̠nwunom ya̠ o̠ku̠a bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Inyin ologhom abar onon, ya̠a̠ ami̠ na̠ a̠nimeta̠n inyin ma̠a̠, obhel aro̠ ma̠ ola̠ A̠zib̠a̠ a̠tenemeni ma̠ a̠nwunom d̠o̠yo̠ d̠a̠ Izipt, ya̠a̠ ate̠i̠ o̠gu̠man sa̠ i̠na aze̠ ma̠ ogbo ya̠ oma̠ra̠ d̠o̠ i̠na bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","I̠ru̠ru̠ane̠ ma̠ egboloma̠ ma̠ itileduom ta̠ A̠zib̠a̠ ya̠ one d̠o̠ ma̠ osibhom a̠ruzu d̠awa oguri d̠a̠ ekpukpu oloko bho̠, kpe̠le̠me̠ni̠ bha̠ awa i̠we̠le̠man a̠risi ya̠ i̠kpe̠ awa ma̠ o̠ro̠ bho̠. Sa̠ A̠zib̠a̠ alo̠gi̠ awa ma̠ ikoli ekunuguma̠ o̠to̠ d̠a̠ obom azi̠m, ma̠ awa ma̠ o̠ro̠ i̠se̠ tu̠tu̠n obom a̠d̠a̠ma̠ osobh ase̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","I̠ru̠ru̠ane̠ nyen egboloma̠ ma̠ a̠nwunom Aso̠do̠m na̠ A̠gomora, na̠ re̠ma ya̠ d̠a̠ eghighira̠ bho̠. Awa eka̠ igir a̠d̠ien agu̠o̠ bho̠ itileduom ta̠ A̠zib̠a̠ igir bho̠. Awa id̠e ma̠ e̠ma, e̠gi̠ ma̠ a̠d̠ien kere kere ari̠gi̠ ya̠ agu̠o̠ o̠gba o̠to̠. Sa̠ A̠zib̠a̠ a̠din o̠ku̠a a̠gbikimeni awa d̠a̠ e̠ba anya, sa̠ na̠ a̠bhin awa na̠ akparame̠ni̠ na̠ a̠kikiom a̠nwunom na̠ a̠gboloma̠ ma̠ e̠banya wa̠ ekunuguma̠ o̠to̠, wa̠ ta̠ ate̠i̠ ogbo ya̠ na̠ egir a̠d̠ien i̠karabh i̠nye̠ bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Onin agu̠o̠ bho̠ i̠mala ma̠ ramala i̠nye̠n na̠ egir i̠karabh na̠ egboloma̠ ma̠ a̠ruzu d̠awa bho̠, sa̠ na̠ eghel ra̠dila̠de a̠limon, sa̠ na̠ efugh itileduom ta̠ A̠zib̠a̠ ma̠ a̠fugh i̠basi̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Ya̠a̠, Amai̠ki̠e̠l we̠mu̠ itileduom ta̠ A̠zib̠a̠ bho̠ eka̠, na̠ ofugh d̠o̠ ma̠ Eru bho̠ ma̠ i̠basi̠ ma̠ igiel bho̠ awa i̠ku̠anan igboloma̠ ma̠ omumugh ozu ta̠ A̠mozizi bho̠. Kpe̠le̠me̠ni̠ bha̠ i̠na a̠fugh Eru bho̠ ma̠a̠, “Wa̠nwuna̠ bho̠ a̠kpegi ma̠ o̠nu̠ d̠oyom.” ");
INSERT INTO mgj_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Ya̠a̠, a̠nwunom i̠nye̠n na̠ efugh a̠fugh i̠basi̠ na̠ egboloma̠ kabar kabar ola̠ awa o̠mu̠gho̠nyan d̠o̠, sa̠ na̠ ebhin ebhi ku̠ku̠m na̠ ebhira̠nom o̠kpo̠ ya̠ awa i̠mu̠gho̠nyan bho̠ ma̠ agu̠o̠ i̠nam ebhi, ya̠a̠ i̠nye̠ o̠kpo̠ ya̠ ta̠ ekunugi awa bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Itogi e̠ro̠ enigha̠ awa! Ezin bho̠, awa na̠ e̠wo̠l onin eten ta̠ A̠ken, sa̠ na̠ e̠tu̠o̠no̠m emel ta̠ A̠balam wa̠ a̠nwuna̠ ma̠ obom e̠d̠o̠gh okpoki bho̠. Awa na̠ ewia̠n nyen na̠ egboloma̠ ma̠ a̠limon ta̠ A̠zib̠a̠, ma̠ agu̠o̠ A̠kora̠ a̠gir bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Ta̠ obhin a̠nwunom i̠nye̠n o̠tu̠o̠m i̠taghatagh d̠a̠ ologi ed̠ia̠n ro̠d̠e̠ etula̠n d̠inyin, ogbo ya̠ na̠ ed̠e ma̠ omuzoghod̠i re̠mi̠no̠ma d̠awa bho̠ ku̠ku̠m. Awa od̠i ma̠ agu̠o̠ ro̠b̠u̠ghu̠b̠u̠gh ya̠ okukugh na̠ a̠kugh na̠ a̠nuoghom, ya̠a̠ osorogi d̠o̠ ma̠ o̠lo̠bha. Awa od̠i ma̠ agu̠o̠ iriren ya̠ omum d̠o̠ ma̠ itu d̠a̠ obhel wa̠ akpe̠ awa ma̠ omum bho̠, sa̠ urubhi, sa̠ imugughu i̠man bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Awa od̠i ma̠ agu̠o̠ ibom ipoka̠na̠n amu̠m abadi̠ ya̠ na̠ efuko na̠ esorogi ma̠ ari̠ghe̠l d̠awa, na̠ agu̠o̠ i̠ni̠nai̠ny ya̠ na̠ erile na̠ e̠gi̠ na̠ erile na̠ eru bho̠. Awa ogbo ya̠ uguri ma̠ okud̠um-kud̠um azi̠m wa̠ ekunuguma̠ o̠to̠ usisa̠n bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","I̠no̠k, wa̠ aro̠ ma̠ oleghemeni od̠ua̠l o̠nyi̠ i̠sabh ikpele ta̠ Adam bho̠, a̠wa̠ a̠gboloma̠ awa, ma̠a̠, “I̠nagha! A̠zib̠a̠ ta̠ a̠bhin itileduom e̠tu̠tu̠, ya̠ o̠nu̠ o̠wal o̠to̠ ");
INSERT INTO mgj_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","ra̠ a̠sobh ase̠ a̠gboloma̠ ko̠ni̠ko̠ni̠, sa̠ ta̠ a̠gbikimeni ma̠ eb̠la̠ id̠ighi ma̠ i̠karabh, d̠a̠ ebula̠ i̠karabh ya̠ awa igir, na̠ a̠fugh i̠basi̠ ya̠ awa ifugh igboloma̠ ma̠ A̠zib̠a̠ bho̠.” ");
INSERT INTO mgj_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","A̠nwunom i̠nye̠n na̠ e̠ro̠ ma̠ ighunuma̠ ighunuma̠ na̠ i̠go̠ya i̠go̠ya, sa̠ na̠ erugh i̠karabh ado̠l ya̠ ibhir ibhir, sa̠ na̠ ebhelebhel aru̠nu̠ na̠ egelemeni ma̠ a̠nwunom ma̠ agu̠o̠ ola̠ o̠te̠i̠ abar d̠a̠ aru̠gu̠o̠ d̠awa. ");
INSERT INTO mgj_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Ya̠a̠, ogbo ed̠igh ologi d̠ami̠, i̠ru̠ru̠ane̠ ma̠ i̠di̠ar ya̠ ogbogir ta̠ Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st id̠ia̠ i̠gba inigha̠ inyin bho̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Awa i̠gba inigha̠ inyin ma̠a̠, “D̠a̠ ra̠d̠a̠ma̠ ekunuguma̠ bho̠, ogbo ya̠ ologhom d̠o̠ ma̠ A̠zib̠a̠ ta̠ emite eru ra̠ e̠ki̠ri̠ inyin, sa̠ ta̠ erugh i̠karabh ado̠l ya̠ ibhir ibhir awa.” ");
INSERT INTO mgj_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","I̠nye̠n a̠nwunom ya̠ na̠ ed̠ighi ma̠ ola̠ inyin na̠ o̠bagi̠na. Awa inwuna̠ d̠o̠ ma̠ igbiriri ozu, na̠ e̠tu̠o̠no̠m ya̠ ologi d̠awa ato̠, inwuna̠ d̠o̠ ma̠ E̠mu̠gh ta̠ A̠zib̠a̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Ya̠a̠, inyin ogbo ed̠igh ologi d̠ami̠, iwia̠ne ma̠ e̠ghu̠a d̠a̠ ima̠ra̠ ologi e̠b̠ab̠ala d̠inyin, ma̠ e̠tu̠o̠no̠m irileghom ta̠ E̠mu̠gh E̠tu̠tu̠ bho̠ ma̠ esiseiny a̠siseiny. ");
INSERT INTO mgj_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","I̠ro̠ na̠ etula̠n ta̠ A̠zib̠a̠ ma̠ agu̠o̠ inyin na̠ ogon Wa̠nwuna̠ i̠yar A̠zizo̠s Akrai̠st ma̠ onigha̠ inyin a̠ghud̠um kid̠ud̠ul d̠a̠ okpon igbirigbir d̠o̠yo̠. ");
INSERT INTO mgj_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Ikpone ma̠ igbirigbir ogbo ya̠ rologi bho̠ na̠ e̠gba i̠wal i̠wal, ");
INSERT INTO mgj_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","ma̠ ekpobh ipa̠n ogbo d̠a̠ anya ma̠ etenemeni awa, ma̠ ebhin d̠a̠ ologi a̠rugugu ma̠ ekpon igbirigbir ogbo ya̠ i̠kpe̠ ma̠ okpon igbirigbir bho̠. Ya̠a̠, i̠b̠arame̠ na̠ rakapa ogbo ya̠ ogir i̠karabh d̠awa na̠ e̠pi̠e̠ bho̠ ma̠ eghel. ");
INSERT INTO mgj_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","I̠na wa̠ na̠ a̠sibh inyin na̠ a̠guri ma̠ agu̠o̠ ola̠ inyin ko omel d̠o̠ bho̠, sa̠ ta̠ a̠bhin inyin d̠a̠ e̠b̠ab̠ala na̠ a̠libhon ologi a̠ru d̠a̠ a̠misigh isosorogia̠n d̠o̠yo̠, ");
INSERT INTO mgj_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","wa̠ i̠na ku̠ku̠m aro̠ ma̠ A̠zib̠a̠ Witenemeni d̠i̠yar bho̠, d̠a̠ o̠wo̠l oten A̠zizo̠s Akrai̠st Wa̠nwuna̠ i̠yar, a̠bhin itutumeni, na̠ alu̠bu̠gh, na̠ a̠limon, na̠ a̠dila̠de i̠to̠, ob̠eton d̠a̠ owewegh obhel ola̠ na̠ a̠ten, na̠ i̠se̠n, tu̠tu̠n kid̠ud̠ul. Aro̠ ma̠ o̠ku̠a!");
ALTER TABLE mgj_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
