﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgh_vpl;
CREATE TABLE mgh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgh_vpl WRITE;
INSERT INTO mgh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Wuupaceroni Nluku hopattusa irimu ni itthaya. ");
INSERT INTO mgh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ilapo yaari yoohinnanna ni yoohitthu; ipiphi yahokhuneela ipahari ni Nnepa wa Nluku wanaweettakaca waculu maasi. ");
INSERT INTO mgh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ni Nluku aheera: Ukhale waarya, ni uhokhala waarya. ");
INSERT INTO mgh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nluku ahoona wiira waarya uri wooreera, phimaana ahokawaniha waarya ni ipiphi. ");
INSERT INTO mgh_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nluku aheehana waarya nwe uthana, nuuripela nwe aheehana uhiyu. Wahela nuusa; nno naari nihuku noopacera. ");
INSERT INTO mgh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Wahoolo Nluku aheera tho: Iriyari yo maasi nikhale nlaka ninhala ukawaniha maasi wawaya wawaya. ");
INSERT INTO mgh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Vano Nluku ahopanka nlaka ni ahokawanihaca maasi yari vathi ni ale yaari uculu. Ni commo waheerannyaa. ");
INSERT INTO mgh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nlaka nno Nluku aheehana irimu. Waheela nuusa; nno naari nihuku nonayeeli. ");
INSERT INTO mgh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Vaavale Nluku aheera: Maasi ari vathi waya irimu, athukumane nipuro nimoca, ikhale itthaya yowuuma. Ni commo waheerannyaa. ");
INSERT INTO mgh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mphantte wo wuuma Nluku aheehana itthaya, ni nthukumano wo maasi aheehana ipahari. Ni Nluku ahoona wiira wari wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Vano Nluku aheera: Itthaya yothene ikhuneeliye ni itakhwa, maphumpulu ni miri cimmaha mihokorokho ni ipyo co khula nnanna. Ni commo waheerannyaa. ");
INSERT INTO mgh_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Itthaya yahomela itakhwa yaarina maphunpulu o khula nnanna. Ni miri cowiima cavaha inuku co khula nnanna. Nluku ahoona wiira wari wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Waheela nuusa; nno naari nihuku noneeraru. ");
INSERT INTO mgh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nluku aheera: Cikhale imwaleelo wirimu wiira cikawanihe uthana ni uhiyu. Wiira cikhale cennyo nthoonyero wo ukati, mahuku ni myakha, ");
INSERT INTO mgh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ni cikhale coomwaleela wirimu ni vathi. Ni commo waheerannyaa. ");
INSERT INTO mgh_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nluku ahopanka imwaleelo piili cuulupale; imwaleelo yuulupale iyo wiira ilamulele uthana ni yankani iyo wiira ilamulele uhiyu. Ciicammo ahopanka itthoottwa cinci. ");
INSERT INTO mgh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nluku aheesa cennyo wanlakani no wirimu wiira cimwaleele itthaya, ");
INSERT INTO mgh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","cilamulele uthana ni uhiyu, ni cikawanihe waarya ni ipiphi ni Nluku ahoona wiira wari wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Wahovira ucoocilo ni wicisu; nno naari nihuku noneecese. ");
INSERT INTO mgh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ciicammo Nluku aheera: Mmaasini mmo akhale makoto onama coomumula, ni iriyariru irimu ni itthaya avaave asaanuni. ");
INSERT INTO mgh_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Commo Nluku ahopattusa inama cuulupale co mpahari ni inama cikhwawe coomumula cinkhala mpharya co khula nnanna, ni asaanuni othene o khula nnanna. Ni Nluku ahoona wiira wari wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Vano Nluku ahoreeriha eeraka: Ntotholane ni muncereranyee! Ncare mmasini o mpahari! Ni inuni citotholane vathi va! ");
INSERT INTO mgh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Waheela nuusa; nno naari nihuku noneethanu. ");
INSERT INTO mgh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ni vaavale Nluku aheera: Itthaya ikhale inama cikumi co khula nnanna; nhuwo ni inama contakhwani ni masene o mwiilaponi, o khula nnanna. Ni commo waheerannyaa. ");
INSERT INTO mgh_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nluku ahopanka masene o khula nnanna, nhuwo wo khula nnanna, ni inama cineepurula co mwiilaponi co khula nnanna. Ni Nluku ahoona wiira wari wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Vano Nluku aheera; nimpanke ntthu oolattana ni hi ni ookhala toko hii. Uyo alamulele ihopa cothene co mpahari, inuni cothene co wirimu ni inama cothene cuulupale co mwiilaponi, ni inama cothene cikani cineepurula vathi. ");
INSERT INTO mgh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nluku ahompattusa ntthu oonlattana naawe oolattana ni Nluku ahompattusa; nlopwana ni nthiyana phaapattusilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nluku ahaareerihaca, ni aheerelaca: Ntotholane ni muncereranyee! Ncare ni mmwareele ilapo yothene! Nlamulele ihopa cothene co mpahari, inuni cothene co wirimu ni inama cothene cineetta vathi. ");
INSERT INTO mgh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nluku aheera tho: Kinawuuvaha miri cothene cowiima cimenle ilapo yothene ni cinvaha ipyo, ni miri cothene cinvaha mihokorokho ni inuku. Cennyo cinwookhala coolya cinyu. ");
INSERT INTO mgh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ni kinawuvahani mataakhuru othene wiira akhale yoolya eenyu mpaka ciicammo inama cothene cirina ukumi: inama cothene cuulupale co mwiilaponi, ni inuni cothene co wirimu ni inama cothene cineettakaca ilapo yo vathi. Ni commo waheeranya. ");
INSERT INTO mgh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Phimaana Nluku hoona wiira citthu cothene cipankilyawe, ciri cooreera venci cinenne. Wahela nuusa; nno naari nihuku nonasiita. ");
INSERT INTO mgh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Commo, cahomala upankiya irimu ni itthaya ni citthu cothene ciriwo. ");
INSERT INTO mgh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nluku namalihilene uvara miteko cothene carinawe, nihuku noonasaapa ahomumula. ");
INSERT INTO mgh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nluku ahoreeriha nihuku nonasaapa ni ahottakattifiha, kontha nenno nihuku nno ahomumulela miteko cothene cavanryawe waapattusawe ilapo. ");
INSERT INTO mgh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nnya phicookhumelela cinttonka cinryaya woopattusiya irimu ni itthaya, ukati Apwiya Nluku waapattusilyaya itthaya ni irimu. ");
INSERT INTO mgh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Naari nihinamela niphumpulu, ni hata mwiri mmoca mwiilaponi, kontha Apwiya Nluku yaari ahinawaana ipula ilapo yothene yo vathi, ni ciicammo khaariwo ntthu oolima itthaya iyo. ");
INSERT INTO mgh_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Maasi yanacekuwa vathi phimiceraka ilapo yothene. ");
INSERT INTO mgh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Vano Apwiya Nluku yahomuumpa ntthu ni ntthupi notthaya ni yahommucelela mphulani iphumu cookumi, ni ntthu ule ahothatuwa nkumi. ");
INSERT INTO mgh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Vaavale, Apwiya Nluku yahopanka iluwani yo Eeteni yaari mphantte unkela ncuwa, ni yahomweesa ntthu yampankilyaya. ");
INSERT INTO mgh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Wahoolo, Apwiya Nluku yahomeliha itthaya yothene miri co khula nnanna, cooreera wa miithoni ni coociva ulya. Ni wariyari iluwani wahaawo mwiri wookumi ni mwiri nkina uncuweliha yooreera ni yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","UEeteni wahophattuwa mooloko waamicera iluwani. Ni uhoolo nwo wahekawanihaca nuukhala myoloko micese. ");
INSERT INTO mgh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Mooloko woopacera uyo uneehaninya Pisomi. Uvinre ilapo yothene yo Havila, uri iwooru. ");
INSERT INTO mgh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Iwooru yo yeeyo ilapo iyo iri yooreera; ciicammo, wonwo haawo lumpani ni maluku ocaayira. ");
INSERT INTO mgh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wonayeeli uvinre ilapo yothene yo Kuusi uneehaninya Kihoni. ");
INSERT INTO mgh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Woneeraru uvinre mphantte unkhuma ncuwa weemelaka ilapo yo Usiiriya, uneehaninya Tikire; ni woneecese uneehaninya Ufarati. ");
INSERT INTO mgh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Apwiya Nluku yahomweesa ntthu iluwani yo Eeteni wiira awehawehe ni alime. ");
INSERT INTO mgh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Vano Apwiya Nluku yahonlamulela ntthu yiiraka: Ulyeeke wootthunawaa mihokorokho cothene ciri nluwani mmo, ");
INSERT INTO mgh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nanso uhilye nhokorokho wo mwiri uncuweliha yooreera ni yoonanara, kontha nihuku ninhalaa ulya, khweeli unaakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Wahoolo, Apwiya Nluku yahoolumaca yiiraka, khawanreera nlopwana ukhala veekha. Kinaampankela oonkavihera wiira amwiiwanane. ");
INSERT INTO mgh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Vano noompileene itthaya ni inama cothene co ntakhwani, ni asaanuni othene ooculu, Apwiya Nluku yahomwiihera nlopwana ule, wiira amoone caahalawe wiihana, ni wo khula ncina nivahilyawe nlopwana, khula itthu yoomumula, nenno phiri ncina naya. ");
INSERT INTO mgh_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Phimaana nlopwana ule hovaha macina mihuwo cothene, asaanuni ooculu ni inama cothene contakhwani. Nanso Attamu khaaphwannye oonkavihera wiira amwiiwanane. ");
INSERT INTO mgh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Vano Apwiya Nluku yahonvaha ikhove cinci nlopwana ule, ni waarupawe vaa yahonkumiha niparari nimoca nuuttiya nenno nipuro nno ni ithayi. ");
INSERT INTO mgh_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Niparari nakumihiyawe nlopwana ule, Apwiya Nluku yahompanka nthiyana nunrwehela nlopwana. ");
INSERT INTO mgh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Vano nlopwana aheera: Khweeli nna nikhuva no makhuva aka ni ithayi yothayi aka! Ula nohala wiihaninya nthiyana, kontha khumile mwa nlopwana. ");
INSERT INTO mgh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Phimaana nlopwana haana aahiyaka athumwane ni anumwane aluttaanaka na amwaarawe, ni oyeeli ankhala irutthu imoca. ");
INSERT INTO mgh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nlopwana na amwaarawe yaakhalaca woohiwara nanso khayoonelana ihaaya. ");
INSERT INTO mgh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yooyo ukati uyo inwaa phaari yotepa ulavilavi wopwaha cikhwamwe capankilyaya Apwiya. Inwaa yahaakoha athiyana yiiraka: Nluku phinryawe ciicammo, wiira nhilye mihokhorokho cothene ciri nluwani? ");
INSERT INTO mgh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Vano athiyana yahaakhula yiiraka: Mihokhorokho co miri ciri nluwani niireliye nilyeke, ");
INSERT INTO mgh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","nanso nhokhorokho wo mwiri uri iriyari iluwani, Nluku eenre nhilye, ni nhikwanyakwanye wiira nhikwe. ");
INSERT INTO mgh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Vano inwaa yaheerela athiyana ale: Khweeli khannokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kontha Nluku naacuwela wiira, nihuku ninhaleenyu ulya, anawuuhulyani miitho enyu nuukhala toko Nluku, nuupacera ucuwela yooreera ni yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Woonyaya athiyana wiira mwiri ule uri wooreera ulya ni woociva wamiithoni, ni mwiri woophwanela uvaha ankhili, yahorukula nhokorokho aya ni ulya, ni ciicammo yahaavaha awaanyaya nayo yaholya. ");
INSERT INTO mgh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Phimaana oyeeli yahotthukuwa miitho aya ni yahopacera ucuwela wiira ari phwitipwiti. Yahottotthanihaca matakhuru o mwiri ni yahowaraca. ");
INSERT INTO mgh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Watthekuwaya ncuwa, yaheewa uwuka wophyoo wawaaya Apwiya Nluku weettakaca nluwani. Vano nlopwana wamoca na amwaarawe yaheepitthaca Apwiya Nluku mmirini co nluwani. ");
INSERT INTO mgh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Vaavale Apwiya Nluku yahomwiihana nlopwana ule yiiraka: Uri vayi? ");
INSERT INTO mgh_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ule ahaakhula: Kihowiiwa uwuka wophyoo yawinyu nluwani, vano mi kihoova, kontha kiri pwitipwiti phimaana wiipithilyaka. ");
INSERT INTO mgh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ni Nluku ahonkoha: Tipani uthonyenre wiira uri pwitipwiti? Uholya nhokhorokho wo mwiri uwirenlyaka wiira uhilye? ");
INSERT INTO mgh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Vano nlopwana ule ahaakhula eeraka: Athiyana akivahilyaa ayo wiira akhale nkhwaaka, yaayo phikivahile mi nhokorokho uyo, ni kiholya. ");
INSERT INTO mgh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Apwiya Nluku yahaakoha athiyana ale: Nyu mpankacenreni ciicammo? Athiyana ale yahaakhula yiiraka: Inwaa phikithepile, ni mi kiholya. ");
INSERT INTO mgh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Phimaana Apwiya Nluku yaheerela inwaa: Upanka waa commo, kihoolapha woopwaha mihuwo cothene ni inama cothene co ntakhwani, unhala weettela wamirimani, ni yoolyaa inhala ukhala ntthupi mahuku othene ookumi aa. ");
INSERT INTO mgh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ni wariyari waa we ni athiyana ayo, ni wariyari wo ucuulu aa we ni ucuulu wa nthiyana uyo, kinaweesa umwiinani. Yooyo ucuulu uyo unaahala wuurakaliha muru we, ni we unkoorakaliha ikottokottho aya. ");
INSERT INTO mgh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Vano Apwiya yaheerela athiyana ale: Kinawuuncerera coowerya cinyu ukati unkeelenyu ukhala ni irukulu; ni ukati wooyara nnokowoona uwerya; nyu nnokoophavela waapwaha awannyu nanso ayo phinhala wuulamulani. ");
INSERT INTO mgh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Vano Apwiya yahomwiirela Atamu: Ukhala wiira we uheewelela amwaaraa, ni uholya nhokhorokho wawiirenlyaka uhilye, iholaphyaa itthaya iyo mwanlattu wawaa we; muuhuvani unarwaa weelihe mahuku othene ookumi aa. ");
INSERT INTO mgh_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Itthaya iyo inkomeela miiwa ni malasi, ni we unkoolya matakhuru o ntakhwani. ");
INSERT INTO mgh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ni unhala ulya ni nttukuttha nomwiirutthuni mwa, mpaka wanhalaa uturuwela watthayani; kontha we wuupiye ni itthaya, nna va uri ntthupi, ni unaturuwela ukhala ntthupi. ");
INSERT INTO mgh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Vaavale nlopwana ule ahaavaha amwaarawe ayo ncina na Hawa; kontha ayo yaari anumwanaya atthu othene. ");
INSERT INTO mgh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Vano Apwiya Nluku, yahompakela nlopwana ule na amwaarawe ikuwo co nrapala ni yahaawarihaca. ");
INSERT INTO mgh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Wahoolo Apwiya Nluku yaheera: Nkoonani, ntthu ula ri toko hii, naacuwela yooreera ni yoonanara; vano wiira hitaphule ntata nawe, ciicammo arukulaka nhokorokho womwiri wookumi, alyaka nukhala wohikhwa. ");
INSERT INTO mgh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Apwiya Nluku, yahomoomola ule nluwani yo Eeteni wiira alime itthaya yakumihiyaawe. ");
INSERT INTO mgh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Paahi, noomoliyene ntthu ule, yaheesiya Makerupii ookhaliha, mphantte unkhuma ncuwa woluwani yo Eeteni, ni ikatana yoopharela yaarukurerya nceresere mothene, wiira isunke iphiro inrwaa uryaya mwiri wookumi. ");
INSERT INTO mgh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Atamu ahaathukumanana amwaarawe yeehaninya Eva, ni ale yahorupala irukulu ni yahonnyara Kayini. Ale yaheera: Ni nkavihero na Mwaneene Nluku kihomphwanya nlopwana. ");
INSERT INTO mgh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ahorupala tho irukulu. Ula nkwaha ula ahonnyara Apeli, nhimaawe Kayini. Apeli aari nhakheli okhontwaa, ni Kayini aari mayoolima. ");
INSERT INTO mgh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Unaphilieene ukati, Kayini ahowana mihokorokho co mmattani wiira anvelelihere Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Apeli ahowana nlipu no mihuwo cawe cootepa uneneva ni Mwaneene Nluku ahomwakhelela Apeli ni itthuvo cawe. ");
INSERT INTO mgh_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Nanso ayo khayaamwakhelenle Kayini ni itthuvo cawe. Vaavale Kayini ahorusiya ni ahotthuka iyuuci. ");
INSERT INTO mgh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Vano Mwaneene Nluku ahomwiirela Kayini: Nlattuni we urusiyaka? Untthukelani iyuuci aa? ");
INSERT INTO mgh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","We wapankaka yooreera, khunhala ukupaliya? Nanso waahipankeke yooreera, ucuwele wiira itampi iri wankhora ni inoowipithela. Iyo imphavela wuutthema, nanso we unlamuliya usintta. ");
INSERT INTO mgh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Wahoolo, Kayini ahomwiirela Apeli nhimaawe: Nrwee umattani. Ukati wakhalacilyaya umattani, Kayini ahontuphela nhimaawe nuumwiiva. ");
INSERT INTO mgh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Vano Nluku ahonkoha Kayini: Nhimaa Apeli ri vayi? Uyo ahaakhula eeraka: Akincuwela. Mi kihokhala mayonsunka nhimaaka? ");
INSERT INTO mgh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Vano Nluku ahonkoha eeraka: Ipankilyaa ila isiyani? Ukiviriyane: Ukhuma watthayani, iphome ya munnaa inakhuwela. ");
INSERT INTO mgh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Vano uholaphiya we ni itthaya ihunle malaku wiira yaakhelele mmatatani mwaa iphome ya munnaa. ");
INSERT INTO mgh_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ukati unkelaa ulima watthayani, ila khinkela yoovahaka tho icaayira. We unkokhala namatthawatthawa ni nannyatha umwilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayini aheerela Apwiya: Uttarusiya waka nwo uhotepa. Nkilevelele. ");
INSERT INTO mgh_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ilelo nnakoomola mwiilaponi mu, kiwiipithakani ni kitthawatthawaka toko nannyatha, kontha ntthu phi ntthu nohala ukikumanana uyo nokookiiva. ");
INSERT INTO mgh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nanso Mwaneene Nluku ahomwaakhula: Khunhala ukhala commo. Ntthu amwiivaka Kayini, nokowiiveleliya ikuhukuhu imaara saapa. Ni Mwaneene Nluku ahomweesera Kayini nthonyero, wiira ntthu phi ntthu nohala unkumanana uyo himwiive. ");
INSERT INTO mgh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Vano Kayini ahokhuma wamiithoni wa Mwaneene Nluku ni ahorwaa ukhala ilapo yo Nooti, mphantte unkhuma ncuwa wo Eeteni. ");
INSERT INTO mgh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayini ahaathukumanana amwaarawe ni yahorupala irukulu ni unnyara Enoki. Wahoolo Kayini ahoteka iparasa awe, yaavahilyawe ncina na mwamwanawe Enoki. ");
INSERT INTO mgh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki ahonnyara Iraati. Iraati ahonnyara Mewucayeli. Mewucayeli ahonnyara Metusayeli ni Metusayeli ahonnyara Lameki. ");
INSERT INTO mgh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki ahaathela athiyana eeli. Amoca ayo yeehaninya Aata ni akina ayo, Silaa. ");
INSERT INTO mgh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aata ahonnyara Yapaali. Yaari athumwanaya atthu ankhalakhalaca mmaheemani ni mayoohuwa inama. ");
INSERT INTO mgh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ncina na munnaawe neehaninya Yupaali, yaari athumwanaya atthu othene ammoopa ceece ni mpetta. ");
INSERT INTO mgh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siila ciicammo ahonnyara mwana mmoca eehaninya Tupalakayimi, aahana ikaruma cothene co ncukhuma ni coyuuma. Tupalakayimi ahaana mwanrokorawe eehaninya Naama. ");
INSERT INTO mgh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameke aheerela asaarawe yeehaninya: Aata ni Silaa: Nkiiwace asaara a Lameki, mwiiwelele moolumo aka: Mi kihomwiiva nlopwana mmoca kontha hookirakaliha, ni mmirawo mmoca kontha hookinyakela. ");
INSERT INTO mgh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Wakhalaka wiira Kayini nawiivelelihiya ikuhukuhu imaara saapa, Lameki wanwookhala sapini (70) uyo umwaakulelaca imaara saapa (490). ");
INSERT INTO mgh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atamu ahaathukumanana tho amwaarawe ni ale yahonnyara mwana nkina, yanvahile aya ncina na Seeti, yiiraka: Nluku hokivaha mwana nipuro na Apeli, yoole Kayini mwiivilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seeti ciicammo ahonnyara mwana anvahile awe ncina na Enosi. Vano Yooyo ukati uyo, phapaceriyaya ulapeliya ncina na Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ila phi iliivuru yomayaranacelo o nloko na Atamu. Ukati Nluku waampankilyawe ntthu, eelattanihaka mwaneene, ");
INSERT INTO mgh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ahaapanka nlopwana ni nthiyana. Ukati waapankilyawe, uyo ahaareeriha ni aheehana atthu. ");
INSERT INTO mgh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Wapihenryawe Atamu myakha iminya nuuwa talaathini (130) ahonnyara mwana mmoca oolikana nuuyo ni oonlatta venci, ni ahonvaha ncina na Seeti. ");
INSERT INTO mgh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Nannyanreene Seeti, Atamu ahokhala nkumi myakha iminya naane (800) ni ahaayara asaana akina asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mahuku othene ookumi awe Atamu yahophiyera myakha iminya khentta nuuwa talaathini (930) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seeti waapihenre awe myakha iminya nuuwa mithanu (105), ahonnyara Enosi. ");
INSERT INTO mgh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seeti nannyanreene Enosi ahokhala nkumi myakha iminya naane nuuwa saapa (807) ni ahaayara tho asaana akina asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mahuku othene ookumi awe, yaari myakha iminya khentta nuuwa khumi na miili (912) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Wapihenryawe Enosi myakha miloko khentta (90) ahonnyara Kenani. ");
INSERT INTO mgh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosi nannyanreene Kenani, ahokhala nkumi mpaka myakha iminya naane nuuwa khumi na mithanu (815) ni ahaayara asaana akina asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mahuku othene ookumi awe, yaari myakha iminya khentta nuuwa mithanu (905) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Waapihenryawe Kenani myakha sapini (70) ahonnyara Malaleli. ");
INSERT INTO mgh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenani nannyanreene Malaleli, ahokhala nkumi mpaka myakha iminya naane nuuwa arupayini (840) ni ahaayara asaana asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mahuku othene ookumi awe, yaari myakha iminya khentta nuuwa khumi (910) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Wapihenryawe Malaleli myakha sitiini nuuwa mithanu (65) ahonnyara Yereti. ");
INSERT INTO mgh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nanyanreene Yereti Malaleli, ahokhala nkumi mpaka myakha iminya naane nuuwa talathini (830) ni ahaayara asaana asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahuku othene okumi awe, yaari myakha iminya naane nuuwa miloko khentta na mithanu (895) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Wapihenryawe Yereti myakha iminya wo sitiini na miili (162) ahonnyara Enoki. ");
INSERT INTO mgh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nannyanreene Enoki Yereti ahokhala nkumi mpaka myakha iminya naane 800 ni ahaayara asaana asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mahuku othene ookumi awe, yaari myakha iminya khentta nuuwa sitiini na miili (962) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Wapihenryawe Enoki myakha sitiini na mithanu (65) ahonnyara Metusalemu. ");
INSERT INTO mgh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Nannyanreene Metusalemu, Enoki aheetta ni Nluku myakha iminya ttharu (300) ni ahaayara asaana asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Mahuku othene ookumi awe, yaari myakha iminya tthaaru wo sitiini nuuwa mithanu (365). ");
INSERT INTO mgh_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki aheetta ni Nluku, ni ahorimyarimya kontha Nluku ahonkusa. ");
INSERT INTO mgh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Wapihenryawe Metusamemu myakha iminya nuuwa miloko khentta na saapa (187) ahonnyara Lameke. ");
INSERT INTO mgh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nannyanreene Metusalemu Lameke ahokhala nkumi mpaka, myakha iminya saapa nuuwa miloko khentta na miili (782) ni ahaayara asaana asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mahuku othene okumi awe, yaari myakha iminya khentta wo sitiini nuuwa naane (969) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Wapihenryawe Lameke myakha iminya nuuwa miloko khentta na miili (192), ahonnyara mwana mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ahonvaha ncina na Nowee ni aheera: Ula naahala uniwukula miteko cihu ni uhuva wo mmatatani mwihu ommwaaninya ni itthaya ilaphiye ni Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nannyanreene Lameke, Nowee ahokhala nkumi mpaka myakha iminya thanu nimiloko khentta nuuwa mithanu (595) ni ahaayara asaana akina asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mahuku othene ookumi awe, yaari myakha iminya saapa ni miloko saapa nuuwa saapa (777) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Wapihenryawe Nowee myakha iminya thanu (500) ahaayara tho asaana akina yeehaninnya: Seemu, Kani ni Yafeti. ");
INSERT INTO mgh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Waapacenryaya atthu wuncererannyaa mwiilaponi ni yaayaracaka asaana asithiyana, ");
INSERT INTO mgh_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","asaana asilopwana a Nluku yahoona wiira asaana asithiyana aatthu ayo yaari ooreeraca, ni yahaathanla ale yatepile wacivela. ");
INSERT INTO mgh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Vano Mwaneene Nluku aheera: Nlattu wotaampi ca atthu, Nnepa aka khunhala ukhala ukati wothene ni atthu, kontha ule ri irutthu. Uyo nohala ukhala myakha iminya wo sirini (120) paahi. ");
INSERT INTO mgh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Yoole ukati ule, mwiilaponi yahaawo atthu oosancamaca. Wahoolo asaana asilopwana a Nluku wathukumaanannyaya asaana asithiyana a atthu ni yayaranacaka asaana. Ayo phaari anakhotto okuru ni ooruma ncina okhalayi. ");
INSERT INTO mgh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mwaneene Nluku ahoona wiira itampi ca atthu caanatepa winciva mwiilaponi ni moopuwelo, omunrimani mwaya yaari ukati wothene upanka paahi coonanara. ");
INSERT INTO mgh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Vano Mwaneene Nluku aheera: Koonne wene kaapankaka atthu mwiilaponi mu, ni iyo yahonrusiha venci wanrimani wawe. ");
INSERT INTO mgh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mwaneene Nluku aheera: Kinawaamalamaliha mwiilaponi atthu yapankilyaka, atthu ni ciicammo inama cuulupale ni cikani ni asaanuni o wirimu. Koonne wene kipattusaka cothene nnya. ");
INSERT INTO mgh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nanso Nowee ahophwanya nnema wamiithoni wa Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nnya phi cokhumelela co neethi wa Nowee. Nowee aari ntthu mayasariya, ookhweeli na atthu o yooyo ukati uyo. Uyo eetta ni Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowee ahaayara asaana araru: Semu, Kani ni Yafeti. ");
INSERT INTO mgh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Vaavale, ilapo yahohononnya wamiithoni wa Nluku ni yahocara coonanara capankaya atthu. ");
INSERT INTO mgh_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Woonnyawe wiira ilapo ihotankannyaa, kontha atthu othene omwiilaponi ahohapuwa malamulo aka. ");
INSERT INTO mgh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nluku ahomwiirela Nowe: Kinawamalamaliha atthu othene, kontha ilapo yothene ihocara coonanara cimpankaya. Phimaana mi kinawakwanyulaca ni ilapo eyo. ");
INSERT INTO mgh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nanso we, upanke ikalawa yothaapwa co mpila. Ukawanihace, cikhale ikatti mwiittayi mwaya ni uttiyace ni uloko nhina ni vate. ");
INSERT INTO mgh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mwiittayi mwaya ulike imaara iminya tharu (300), mwiikhuvi mwaya imaara hansini (50) ni yeemelelo aya imaara talathini (30). ");
INSERT INTO mgh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Upanke ithari ni upanke icanela nliko wo nuusu no moono mmoca ithari ni isiri yokalawa. Upanke nkhora nceresere ikalawa ni upanke ithari; waculu, iriyari ni vathi. ");
INSERT INTO mgh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nkoonani. Kinnowiha maasi o naphuvu mwiilaponi, wiira kikwanyulace ilapo yothene ni citthu cothene coomumula cipattusilyaka. Cothene ciri mwiilaponi cimmomala. ");
INSERT INTO mgh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nanso, ni we, kimmopanka nleehano naka, ni ummokela nkalawani mmo, we na asaanaa, na amwaaraa ni asaaraya asaanaa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ni cothene cimmumula co khula ikhapila yonama, yo nlopwana ni yo nthiyana unlamuliya ukelana nkalawani mmo piili piili, wiira usunke ukumi aya ni we. ");
INSERT INTO mgh_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Asaanuni o khula ikhapila, inama co khula ikhapila, inama cowiipurula co khula ikhapila; cinari piili piili cinawuuwela we, wiira usunke ukumi aya. ");
INSERT INTO mgh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Vano we, ukuse coolya cothene cinliya ni wiisunkere, cinhala ukhala coolya ca waa ni coolya conama. ");
INSERT INTO mgh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ahopanka Nowee toko cahimeriyawe ni Nluku. Commo phaapankilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Wahoolo Mwaneene Nluku ahomwiirela Nowee: Ukele nkalawani, we ni ntthoko naa nothene, kontha kihowoona we ukhala ntthu oosariya wariyari wa atthu othene. ");
INSERT INTO mgh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ukuse inama saapa co nlopwana ni inama saapa co nthiyana co khula ikhapila cinari cohalali. Nanso ciri coharamu nnyo, ukuse piili piili co nlopwana ni co nthiyana. ");
INSERT INTO mgh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ciicammo ukuse inuni cooculu saapa co nlopwana ni saapa co nthiyana, wiira cikhale cikumi ni ipyo yo mwiilaponi mothene. ");
INSERT INTO mgh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kontha yaviraru mahuku saapa, kinawana ipula mwiilaponi mothene, mahuku arupayini uhiyu ni uthana. Ni kinakhwanyulaca citthu cothene cipankilyaka vathi va. ");
INSERT INTO mgh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowee ahopanka cothene ceereliyawe ni Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yooyo ukati uyo Nowee aahaana myakha iminya siita ceyarelo, ukati wawilyawe naphuvu oocara maasi ilapo yothene. ");
INSERT INTO mgh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowee, na asaanawe, na amwaarawe, na asaaraya asaana awe ayo, yahokelaca nkalawani, mwanlattu wo maasi o naphuvu. ");
INSERT INTO mgh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ukhuma inama cohalali, inama coharamu, asaanuni, ni inama cothene cowiipurula ciri vathi va, ");
INSERT INTO mgh_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","cahonwela Nowee, nuukela piili piili nkalawani mmo, toko Nluku canlamunlenlyawe Nowee. ");
INSERT INTO mgh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Wanowiira avirakaru mahuku saapa ale, phapacenryaya uwa maasi o naphuvu vathi wothene. ");
INSERT INTO mgh_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ukati warinawe Nowee myakha iminya siita (600) cokumi awe, weettelaya mweeri wo nayeeli, waaphiyeraya mahuku khumi na saapa o mweeri, nenno nihuku nno, cahottinwa miliwi co maasi, ni mikhora cothene co wirimu cahohulya, ");
INSERT INTO mgh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ni yahorupa ipula mwiilaponi mothene, mahuku arupayini, uhiyu ni uthana. ");
INSERT INTO mgh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Vano nenno nihuku nno Nowee na asaanawe, Seemu, Kani ni Yafeti, ciicammo amwaara a Nowee na asaaraya asaanawe ooraru yahokelaca nkalawani. ");
INSERT INTO mgh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ale ni inama cothene co khula ikhapila, mihuwo cothene co khula ikhapila, inama cothene cowiipurula co khula ikhapila, covava cothene co khula ikhapila, asaanuni othene o khula ikhapila, ");
INSERT INTO mgh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ni inama cothene carina ukumi, cahokela piili piili ni Nowee nkalawani. ");
INSERT INTO mgh_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Paahi, inama cothene caakenle caari cowiiraana, co nlopwana ni co nthiyana, toko Nluku canlamulenlyawe. Wiimaleloni, Mwaneene Nluku ahotthyaa nkhora vate. ");
INSERT INTO mgh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Vaavale, naphuvu ule ahokhala mahuku arupayini nari mwiilaponi, maasi yaheenciva, ni yahoteesa ikalawa iyo, ni ile yahohiya itthaya. ");
INSERT INTO mgh_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Vano maasi ale yahocara venci cinenne mwiilaponi mothene; nanso ikalawa iyo yaamphempa waculu maasi. ");
INSERT INTO mgh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Vano maasi ayo yanatepa wuncereryaana mwiilaponi, mpaka myako coorekama cothene cari vathi waya irimu cahomiriya ni maasi. ");
INSERT INTO mgh_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maasi ayo yahocara tapha mpaka upwaha miyoono saapa ni nuusu, mpaka myako nnyo cahomiriya. ");
INSERT INTO mgh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Phimaana cahokhwa inama cothene cariwo vathi va, ukhuma mihuwo, inuni, masene, inama cowiipurula cothene mpaka atthu othene. ");
INSERT INTO mgh_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Cothene carina ukumi, cimumulelaka mphulani mwaya, caakhala vathiva, cahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Paahi, cahotankanyaa cothene cariwo vathi va, ukhuma ntthu mpaka inama cowiipurula ni nnyo coweetta, mpaka asaanuni oovava uculu, yahomalamalihiya mwiilaponi. Aahanle paahi phi Nowee ni ayo yarinawe nkalawani. ");
INSERT INTO mgh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maasi ayo yahokhala nlaponi mpaka mahuku iminya wo hansiini (150). ");
INSERT INTO mgh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Vano, Nluku ahomuupuwela Nowee wamoca ni inama cothene co ntakhwani ni coohuwiya caarinawe nkalawani, ni ahowana iphyoo yuulupale mwiilaponi ni maasi yahopacera uwukuwa. ");
INSERT INTO mgh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Miliwi co vathi ni mikhora co wirimu cahottiyannyaa ni ipula yahohiya urupa. ");
INSERT INTO mgh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Maasi yahopacera uwukuwa vakani vakani mwiilaponi. Wiimaleloni wo mahuku iminya wohansiini (150), maasi ale yahowukuwa, ");
INSERT INTO mgh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ni nihuku nonakhuumi na saapa no mweeri wonasaapa, ikalawa ile yaheemela umyakoni co Ararati. ");
INSERT INTO mgh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maasi naanlelo yeera awukuwaka, mpaka mweeri wonakhumi. Vano nihuku noopacera no mweeri wonakhumi cahopacera woonnyaa myako. ");
INSERT INTO mgh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Anavinre mahuku arupayiini, Nowee ahohula icanela yapankilyawe nkalawani. ");
INSERT INTO mgh_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Vano ahonkumiha nakhuku mmoca, aamakenle urukureryaca paahi, awehereryaka maasi ale wuuma vathi wothene. ");
INSERT INTO mgh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Wahoolo ahotthukulela ikhuntta wiira oone yakhala wiira maasi ayo yahowukuwa mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nanso ikhuntta khayaaphwanyile nipuro nookotela kontha maasi yahokhuneela itthaya yothene. Phimaana ikhuntta ile yahoturuwela nkalawani mwaaryawe Nowee. Ule ahotaphulela moono awe vate ni ahovara ikhuntta ile awaanaka nkalawani mmwe. ");
INSERT INTO mgh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Vaavale Nowee ahowehererya tho mahuku saapa ni ahoruma tho ikhuntta ile. ");
INSERT INTO mgh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Utthekuwa waya ncuwa, ukati waturuwilyaya ikhuntta ile, yahowa inapapile umalakuni nwo ntaakhuru no mwiri. Nowee ahokhala oocuwela wiira maasi ayo ahowukuwa mwiilaponi mmo. ");
INSERT INTO mgh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ahowehererya tho mahuku saapa ni ahoruma tho ikhuntta, nanso ila ikwaha ila ikhuntta khayaaturuwile tho. ");
INSERT INTO mgh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nihuku noopacera no mweeri woopacera wo mwakha iminya siita na mmoca (601), maasi ale yahowelela mwiilaponi mmo. Nowee ahopattakula nivatho nokalawa. ni aheera: mwiilaponi mmo itthaya iyo ihooma. ");
INSERT INTO mgh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Khweeli, nihuku nonasiriini na saapa no mweeri wonayeeli, itthaya yahomalela wuuma. ");
INSERT INTO mgh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Vano Nluku ahomwiirela Nowee: ");
INSERT INTO mgh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ukhume nkalawani mmo, we na amwaaraa, wamoca na asaanaa ni asaaraya asaanaa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ni ukumihace inama cothene cirinaa nnyo: asaanuni, inama cuulupale ni cikani cineetta ciipurulaka. Ukumihe wiira cimwareele mwiilaponi, cikhale cocaayiira ni citotholane. ");
INSERT INTO mgh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Phimaana, Nowee na amwaarawe, wamoca na asaana awe na asaraya yahokhumaca nkalawani. ");
INSERT INTO mgh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Inama cothene cuulupale ni cikani cineetta wowiipurula, ni asaanuni othene, cothene coweetta mwiilaponi caari nkalawani, cahokhuma. ");
INSERT INTO mgh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Wahoolo Nowee ahopanka ikhilompi yoonlapelela Mwaneene Nluku, ni ahokusa inama cikina ni asaanuni oohalali, ni ahaavelelihera isataka yoopahiya. ");
INSERT INTO mgh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mwaneene Nluku ahoona unukhela ni aheera: Akinhala tho ulapha itthaya mwanlattu wa pinattamu, kontha wuupuwela wa pinattamu uri woonanara ikhumelo. Ni akinhala wiivakaca tho citthu cikumi cothene toko cipankilyaka ula nkwaha ula. ");
INSERT INTO mgh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Paahi, ilapo ela yapicaru nuumala, waala nuhepha, uririya ni nttukuttha, ilimwe ni iyiita, uhiyu nuuthana kunhala umala. ");
INSERT INTO mgh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nluku ahonreeriha Nowee na asaanawe amwiirelaka coo: Nnyaranace, muncereryane ni ncarace mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Inama cothene co mwiilaponi cinkowuttettemelani ciwoovakani nyu; inama co ntakhwani, asaanuni o wirimu, inama cineepurula vathi ni ihopa co mpahari, cothene nhovahiya mmatatani mwinyu. ");
INSERT INTO mgh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Citthu cothene cirina ukumi ni ceettaka cinkokhala coolya cinyu; toko cuvahilyakani mataakhuru, nna vaa kinawuvahani citthu cothene. ");
INSERT INTO mgh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nanso nhikhure inama ni iphome aya, kontha iphome aya phiri ukumi. ");
INSERT INTO mgh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ntthu phi ntthu nohala umwarusa iphome, pooti ukhala ya ntthu atthuna yonama, kinkoonkohaca; wo khula ntthu kinkohukhumu nlattu wokumi wa nkhwawe. ");
INSERT INTO mgh_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ntthu nohala umwarusa iphome ya nkhwamwe, iphome awe inhala umwarusiya ciicammo ni ntthu, kontha, ni ilatta ya Nluku, phipankiyawe ntthu. ");
INSERT INTO mgh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nanso nyu, nkhale ooyaranaca ni muncereryane. Mmwaryeele mwiilaponi ni ncaranace mommo. ");
INSERT INTO mgh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Vano Nluku ahomwiirela Nowe, na asaanawe: ");
INSERT INTO mgh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Nkoonani, kinkopanka nleehano naka ni nyu wamoca ni ucuulu inyu wohoolo, ");
INSERT INTO mgh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ni citthu cothene cirina ukumi ciri ni nyu; asaanuni, inama coohuwiya ni inama co ntakhwani, citthu cothene co mwiilaponi cirina ukumi. ");
INSERT INTO mgh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kinapanka nleehano naka ni nyu. Itthu phi itthu irina ukumi khinhala tho wiiviya ni maasi oocara mwiilaponi. Khaanhala tho ucara maasi mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nluku ahopwaherera wuulumaca eeraka: Ila phi ikanyero yo nleehano naka ninoopankelaakani, ukhuma nyu mpaka citthu cothene cirineenyu, cirina ukumi; mpaka maloko othene oohoolo. ");
INSERT INTO mgh_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nikhwii naka kiheesa mmahutteni. Ninkookhala ikanyero yo waataana waka ni ilapo. ");
INSERT INTO mgh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ukati unkelaka uwaana mahutte mwiilaponi ni nawaaka nikhwii, ");
INSERT INTO mgh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","vano mi kinkowuupuwela nleehano naka ni nyu wamoca ni citthu cothene cirina ukumi co khula nnanna. Maasi khaanhala tho ucara mwiilaponi wiira yiivakace citthu cirina ukumi. ");
INSERT INTO mgh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ukati wothene unkelaya woonnyaa nikhwii mmahutteni, kinkooweha ni kinkowuupuwela nleehano noohimala na atthu ni citthu cothene coomumula co khula nnanna, cinkhala mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Namalihileene wuulumaca, Nluku ahomwiirela Nowee coo: Ila phi ikanyero yo nleehano nipankilyaka mi ni citthu cothene cirina ukumi mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Vano asaana a Nowee yakhumile nkalawani yaari: Seemu, Kani, ni Yafeti. Kani phiri athumwanaya Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ala phaari asaana araru a Nowee. Ukhuma mwa yaayo, ilapo yothene yahokhaliya na atthu. ");
INSERT INTO mgh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowee aari mayoolima, phapacenre waala ivinya yoopacera. ");
INSERT INTO mgh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nowee ahowurya ivinyu, ahohapaliya, ni ahokhala pwitipwiti nheemani mwawe. ");
INSERT INTO mgh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kaamu, athumwanaya Kanaa, ahoona uhiwara waathumwane ni ahorwaa waahimyacera asunnawe eeli yaari vate. ");
INSERT INTO mgh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nanso Seemu ni Yafeti yahokusaca ikacako, yaheesaca wanikhatani ni, yeettaka nttuli nttuli wiira ahoonace athumwanaya anari pwitipwiti, yahaakhuneelaca. ");
INSERT INTO mgh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowee, ukati wonwilyawe muuhapaliyani, ni oonenelaka yapankilyawe mwanawe omwankaani ule, ");
INSERT INTO mgh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","aheera coo: Kanaa holaphiya! Unkookhala ipottha copottha ca asunnaa. ");
INSERT INTO mgh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Aheera tho coo: Attittimihinye Mwaneene Nluku, Nluku a Seemu! Ni Kanaa akhale ipottha awe. ");
INSERT INTO mgh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nluku uncerere ncoko wa Yafeti; uyo akhale mmaheemani mwa Seemu, ni Kanaa akhale ipottha awe. ");
INSERT INTO mgh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Uvira waya ucara wo maasi mwiilaponi, Nowee ahokhala nkumi myakha iminya tthaaru wo hansiini (350). ");
INSERT INTO mgh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mahuku othene ookumi awe, yaari myakha iminya khentta wo hansiini (950) ni ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ala phi mayaranacelo aya asaana a Nowee: Seemu, Kaamu, ni Yafeti. Ni ayo yahoyaranaca uvira wawe naphuvu. ");
INSERT INTO mgh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ala pha asaana a Yafeti: Komeri, Makoki, Mattaayi, Yavani, Tupali, Mesekhi ni Tirasi. ");
INSERT INTO mgh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ni asaana a Komeri yaari pha ala: Asikenasi, Rafiki ni Tokarima. ");
INSERT INTO mgh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Asaana a Yavani yaari pha ala: Elisa, Tarisisi, Kitimi, ni Tamini. ");
INSERT INTO mgh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nhina wo yaala, phikhumakhumilyaya atthu ankhalakhala mmaacivirini, akawanacaka ncoko aya nhina wo nuulumo naya, wo khula ntthu nhina wo nihimo neelapo awe. ");
INSERT INTO mgh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ala phaari asaana a Kaamu: Kuusi, Misirayimi, Fuute ni Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ala phaari asaana a Kuusi: Sepaa, Havila, Sapita, Ramaa ni Sapiteka. Ala phaari asaana a Ramaa: Sapaa ni Tetaa. ");
INSERT INTO mgh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuusi ciicammo ahonnyara Ninroti, nlopwana oopacera ookhomaala cinenne mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ule ari nlupa muulupale wamiithoni wa Mwaneene Nluku, phimaana wiiriyaka: Nlupa toko Ninroti wamiithoni wa Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Wiipaceroni umwene awe wamphiya uPapeli, Ereki, Akkate ni Kalineha, ilapo yo Sinari. ");
INSERT INTO mgh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ukhuma wawe yeela ilapo ela ahorwaa waAsiiriya wantekilyawe Ninive, Riyopoti-Iri, Kalaa ");
INSERT INTO mgh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ni Resemi, inkhala ncoko wo Ninive ni Ukalaa, iparasa yuulupale. ");
INSERT INTO mgh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirayimi ahaayara annalutita, annamita, annaleyapita, annafutuwita, ");
INSERT INTO mgh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","annapaturusita, annakasuluwita, mwa yaala phikhumelenle annafilisitiya ni annakaftori. ");
INSERT INTO mgh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaa ahonnyara Sitomi, mwana omuulupale, ni Hetee, ");
INSERT INTO mgh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ciicammo toko annayepusi, annamori, annakirkasiti, ");
INSERT INTO mgh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","annahiviti, annarkiti, annasiniti, ");
INSERT INTO mgh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","annarivati, annasemara ni annahatitha. Wahoolo mahimo o annakanani yahomwaryaca. ");
INSERT INTO mgh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Miinano co Kanaa caakhuma uSitomi, ni carwaa mpaka uKerari, ni camphiya uKaasa ni, ukhuma wonwo, canrwaa mpaka uSotoma, uKomora, uHatamaa ni Sepoyimi ciphiyaka mpaka uLaasa. ");
INSERT INTO mgh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ala phi mayaranacelo a Kaamu, nhina mahimo aya ni moolumo aya, mmicokoni ni mwiilaponi mwaya. ");
INSERT INTO mgh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemu aari nhimaawe Yafeti ni ciicammo ahaayaraca asaana. Ule phaari muulupale a atthu othene oHeperi. ");
INSERT INTO mgh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ala phaari asaana a Seemu: Elawu, Asuuri, Arifacate, Luuti ni Arami. ");
INSERT INTO mgh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ala phaari asaana a Arami: Usi, Huli, Kether ni Meseki. ");
INSERT INTO mgh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifacate ahonnyara Selah, ni Selah ahonnyara Heperi. ");
INSERT INTO mgh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heperi ahaayarela asaana eeli: Mmoca uyo eehaninya Peleki, kontha ukati awe ilapo yahokawaninya; ni nhimaawe eehaninya Yokitani. ");
INSERT INTO mgh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani ahonnyara Almotati, Salefi, Hasaramarvete, Yerah, ");
INSERT INTO mgh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Haturami, Usaali, Tikala, ");
INSERT INTO mgh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Opal, Apimayeli, Sepaa, ");
INSERT INTO mgh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havilaa ni Yopapi. Ala othene ala yaari asaana a Yokitani. ");
INSERT INTO mgh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ncoko wakhalacaya uyo weecatala ukhuma uMeesa mpaka uSefari, mmwakoni uri mphantte unkhuma ncuwa. ");
INSERT INTO mgh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ala phi mayaranacelo a Seemu, nhina mahimo aya ni moolumo aya, mmicokoni ni mwiilaponi mwaya. ");
INSERT INTO mgh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ala phi mahimo a asaana a Nowee, ookawanaceene mwiilaponi mwaya, toko ciriyaya mayaranacelo aya. Ukhuma wo yaayo, atthu ahomwareela mwiilaponi, uvira wawe naphuvu. ");
INSERT INTO mgh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mwiilaponi mothene nariwo paahi nuulumo nimoca ni moolumeliyo mamoca. ");
INSERT INTO mgh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Vano atthu akhumaka mphantte unkhuma ncuwa, yahophwanyaca nikuwa uSinari ni vaavale yahokhalaca. ");
INSERT INTO mgh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yaheerelana ayaayoru coo: Nrwee nuupe incirwa ni nipaheehe sana sana. Yatthuminri incirwa nnyo nipuro no maluku, ni alikatarawu nipuro no mattope. ");
INSERT INTO mgh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wahoolo yaheerelana tho: Nrwee niteke iparasa ni inupa yoorekama yoophiya wirimu. Commo ncina nihu ninkoruma ni khaninhala umwaruseliya mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Vano Mwaneene Nluku ahokhuruwa wiira oone iparasa ile ni inupa yatekaya atthu ale. ");
INSERT INTO mgh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ni Mwaneene Nluku aheera coo: Nkoonani, atthu ala ari nloko nimoca paahi, anoolumaca nuulumo nimoca paahi, ni ahopacera nteko ule. Woohipica khiiwo inhala waahiha uvara yuupuwenlyaya. ");
INSERT INTO mgh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nrwee, nikhuruwe ni naavirikanihe nuulumo naya, wiira ahiiwanane ntthu ni nkhwawe. ");
INSERT INTO mgh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Vaavale, Mwaneene Nluku ahaamwarusela atthu ale ilapo yothene, ni yahohiyaca uteka iparasa ile. ");
INSERT INTO mgh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Phimaana waheehaninya uPapeli, kontha vaavale Mwaneene Nluku ahovirikaniha moolumelo ottuniya yothene. Ukhuma vaavale Mwaneene Nluku ahaamwaruselaca atthu ale mwiilaponi mothene. ");
INSERT INTO mgh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ala phi mayaranacelo o nloko na Seemu: Uvira wawe naphuvu mwiilaponi, cahovira myakha miili, ni Seemu ahopiihera myakha iminya (100) ceyarelo ni ahonnyara Arifacate. ");
INSERT INTO mgh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Nannyanreene Arifacate, Seemu ahokhala nkumi mpaka myakha iminya thanu (500) ceyarelo ni ahaayara asaana akina asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arifacate wapiihenryawe myakha talathini nuwa mithanu (35) ceyarelo, ahonnyara Selah. ");
INSERT INTO mgh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nannyareene Selah, Arifacate ahokhala nkumi mpaka myakha iminya cese nuwa miraru (403) ceyarelo ni ahaayara asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Upiihera wawe myakha talathini (30) ceyarelo, Selah ahonnyara Heperi. ");
INSERT INTO mgh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nannyareene Heperi, Salah ahokhala nkumi myakha iminya cese nuwa miraru (403) ceyarelo ni ahaayara asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Upiihera wawe Heperi myakha talathini nuwa micese (34) ceyarelo, ahonnyara Peleki. ");
INSERT INTO mgh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Heperi unyara wawe Peleki, ahokhala nkumi mpaka myakha iminya cese nuwa talathini (430) ceyarelo ni ahaayara asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleki upiihera wawe myakha talathini (30), ahonnyara Rewu. ");
INSERT INTO mgh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleeki unnyara wawe Rewu, ahokhala nkumi mpaka myakha iminya piili na khenta (209) ni ahaayaraca asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rewu upiihera wawe myakha talathini na miili (32) ceyarelo, ahonnyara Sirukwe. ");
INSERT INTO mgh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rewu ahokhala nkumi mpaka myakha iminya piili na saapa (207) ni ahaayaraca asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sirukwe upiihera wawe myakha talathini (30) ceyarelo, ahonnyara Nahori. ");
INSERT INTO mgh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sirukwe nannyareene Nahori, ahokhala nkumi mpaka myakha iminya piili (200) ceyarelo ni ahaayaraca asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahori upiihera wawe myakha sirini na khenta (29) ceyarelo, ahonnyara Tera. ");
INSERT INTO mgh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Unyara wawe Tera, Nahori ahokhala nkumi mpaka myakha iminya imoca nuwa khumi na khenta (119) ceyarelo ni ahaayaraca asaana akina, asilopwana na asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera upiihera wawe myakha sapini (70) ceyarelo, ahonnyara Aparamu, Nahori ni Harani. ");
INSERT INTO mgh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ala phi mayaranacelo o nloko na Tera: Tera ahonnyara Aparamu, Nahori ni Harani; ni Harani ahonnyara Loti. ");
INSERT INTO mgh_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani akhwenle uUri yo Kasiti wayareenlyawe, ukati waryaya athumwane akumi. ");
INSERT INTO mgh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aparamu ni Nahori yahaathelaca asaaraya. Ncina na amwaarawe Aparamu naari Sarayi, ni ncina na amwaarawe Nahori naari Milika; ula aari mwana a Harani, athumwane Milika ni Isikaa. ");
INSERT INTO mgh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Vano Sarayi aari oohiyara, khaarina asaana. ");
INSERT INTO mgh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera ahonkusa Aparamu mwanawe, wamoca ni Loti mwanculawe, mwana a Harani, ni Sarayi mwaara a mwanawe ni othene yahorwaa ikwaha yookhuma uUri yo Kasiti arwaaka uKanaa. Nanso uphiyaca waya yahokhalaca wonwo. ");
INSERT INTO mgh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ahokhala nkumi mpaka myakha iminya piili na thanu (205) ceyarelo ni ahokhwela uHarani. ");
INSERT INTO mgh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nkwaha mmoca Mwaneene Nluku ahomwiirela Aparamu: Ukhume ilapo aa iyo, iriyari ya alokwaa ni wapuwani wa athumwana, ni urwee ilapo inhalaka wuthonyera. ");
INSERT INTO mgh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kinawuvaha atthu enci ookhuma mwirutthuni mwa mmo ni kinawuvaha iparakha, ni kinawunnuwiha ncina naa nno ni we unhala ukhala iparakha. ");
INSERT INTO mgh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kinawareeriha anhala wureeriha ayo ni watapaniha anhala wulaphakaca ayo. Vano mwanlattu wo we, atthu othene omwiilaponi anakhala ooreerihiya. ");
INSERT INTO mgh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Vaavale Aparamu ahokhuma toko Mwaneene Nluku camwiirenlyawe, ni warwawe va ahontthukana ikwaha Loti. Ukati wakhumawe uHarani, Aparamu ahaana myakha sapini na mithanu. ");
INSERT INTO mgh_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Wakhumawe va ahonkusa Sarayi mwaarawe, Loti mwana amunnawe, mihakhu cawe cothene caphwanyilyawe ni ipottha cawe cathumilyawe uHarani. Yahokhumaca arwaka ilapo yo Kanaa ni yahophiyaca salama. ");
INSERT INTO mgh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Aparamu ahottupulaniha ilapo eyo mpaka uphiya nipuro no Sikeni. Yooyo ukati uyo annakanaa phakhala ilapo eyo. ");
INSERT INTO mgh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mwaneene Nluku ahonkhumelela Aparamu phimwiirelaka: Ipyo aa iyo kinaahala uvaha ila itthaya ela. Vano ahoteka ikhilompi yoonalapelela Mwaneene Nluku ankhumelenle. ");
INSERT INTO mgh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Vaavale aheetta arwaka myako ciri ncoko woohitto wo Peteli. Wonwo ahonkhurutula heema awe, akakhelaka uPeteli moono unkela ncuwa ni Ayi unkhuma ncuwa. Vano ahontekela ikhilompi Mwaneene Nluku ni ahonlapela Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Wahoolo Aparamu ahokhuma arwaka mphantte wo Nekepi. ");
INSERT INTO mgh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Yooyo ukati uyo ilapo iyo yahovola itala yinci. Vano Aparamu ahokhuruwela ilapo yo Wiciipitu wiira akhale ukati vakani kontha itala eyo yanatepa mwilaponi mmo. ");
INSERT INTO mgh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ukati wattamenryawe Wiciipitu, ahomwiirela Sarayi mwaarawe: Yoowe! Mi kihocuwela wiira we uri nthiyana ooreera venci. ");
INSERT INTO mgh_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Phimaana annaciipitu ayo yakela yawoonaka, ankocuwela wiira: Ala amwaarawe! Vano ankokiiva ni wuhiya we nkumi. ");
INSERT INTO mgh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Sontte weere mwanrokoraka wiira yakipanke nnema mwanlattu wo we ni commo khanhala ukiivaca. ");
INSERT INTO mgh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Khweeli Aparamu uphiya wawe Wiciipitu, annaciipitu yahoonaca wiira amwaarawe ayo ari ooreera venci. ");
INSERT INTO mgh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Asuulupale a Farawoo yahomoonaca Sarayi nunttottopela venci, mpaka Sarayi yahonkusaca uhano wa Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Vano mwanlattu wa Sarayi, Aparamu ahopankiya nnema. Ule ahovahiya ikhontwaa, imope, apuuru, ipottha cilopwana ni cithiyana, apuuru onthiyana ni inkamela. ");
INSERT INTO mgh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Nanso Mwaneene Nluku ahonrakaliha Farawoo na akhuulupale awe othene ni iretta cowoopiha mwanlattu wa Sarayi, amwaara a Aparamu. ");
INSERT INTO mgh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Phimaana Farawoo ahomwiihana Aparamu, ni ahomwiirela: Isiyani yeeyo ikipankilyaa iyo? Wahakihimyacenryaa wiira ala mi amwaaraka? ");
INSERT INTO mgh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Weerelani wiira ula mi mwanrokoraka? Hapo mi kahonthela! Pahi, yakhala amwaaraa wakuseke ni urweke. ");
INSERT INTO mgh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farawoo ahomwiirela Aparamu na amwaarawe wiira akhume mWiciipitu mmo ni ahaaruma anakhotto awe wiira anvelele mpaka umpikani ni citthu cothene carinawe. ");
INSERT INTO mgh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Vano Aparamu ahokhuma Wiciipitu ni ahorwaa uNekepi na amwaarawe ayo, ni citthu cothene carinawe ni Loti ahontthukana ikwaha. ");
INSERT INTO mgh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aparamu ahothaciri venci, ahaana inama, ipheeta ni iwooru. ");
INSERT INTO mgh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ule ahokhuma uNekepi arwaka uPeteli, mpaka ahophiya nipuro naapacenryawe unkhurutula heema nipuro niri iriyari uPeteli nu Ayi. ");
INSERT INTO mgh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ahophiya nipuro naapacennyawe uteka ikhilompi ni Aparamu ahonlapela Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ciicammo Loti, antthukannyawe ikwaha Aparamu ahaana mihuwo cawe, imope na aheema. ");
INSERT INTO mgh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Vano nipuro nno khanaatosa wiira oyeeli akhalace nttetthe mmoca, kontha yahaanaca mihakhu cinci cahaalamuliyaya ukhala khala nipuro nimoca. ");
INSERT INTO mgh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Phimaana yahokhuma ipokoho ya ahakheli a Aparamu na ayo a Loti; ni yooyo ukati uyo maKananewu ni maPerisewu yakhalaca yeeyo ilapo eyo. ");
INSERT INTO mgh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Vano Aparamu ahomwiirela Loti: Va ihikhume ipokoho we ni mi, ni ihikhume ipokoho ya ahakheli aa na ahakheli aka kontha va niri ayaayoru. ");
INSERT INTO mgh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ilapo eyo khimala, va nrwee nimelane. Weeraka kinthanla moono nthiyana mi kinhala urwa moono nlopwana; atthuna weeraka kinthanla moono nlopwana mi kinrwa moono nthiyana. ");
INSERT INTO mgh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Vaavale ahoweha Loti micoko cothene niwahoncivela uthako wo Yoortani, wari wowunttelana ratta mpaka uSowari; wari toko iluwani ya Mwaneene Nluku, toko wenryaya itthaya yo Wiciipitu. Iyo yeeranele Mwaneene Nluku hinakwanyula uSotoma nuKomora. ");
INSERT INTO mgh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Loti ahothanla uthako wo Yortani eettaka arwaka unkhuma ncuwa, ni oyeeli yahomwalaanaca. ");
INSERT INTO mgh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aparamu ahokhala ilapo yo Kanaa. Nanso Loti ahorwaa wakhurutula aheema awe mmaparasa ciri muuthakoni cooco uSotoma. ");
INSERT INTO mgh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Nanso alopwana yaakhalakhalaca uSotoma ayo yaari oohiloka ni yaanankosera Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Aparamu namwalanne ni Loti, ni Mwaneene Nluku ahomwiirela: Uwuse miitho aa ayo ni uwehe ukhuma nipuro niryaa mpaka mphantte wooculu ni woohitto, unkhuma ncuwa mpaka unkela ncuwa. ");
INSERT INTO mgh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Kontha ilapo yothene inoonaa eyo, kimmowuvaha we ni ucuulu aa wothene mpaka khalayi. ");
INSERT INTO mgh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ni ipyo aa kinopanka toko ntthupi no mwiilaponi mothene; maana aya ntthu ooryaka waalikela ntthupi no mwiilaponi mothene, ciicammo ni ipyo aa nahala woorya waalikela. ");
INSERT INTO mgh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wunwe ni weettakace ilapo yothene. Mwiittayi waya ni mwikhuvi waya kontha kimmowuvaha we. ");
INSERT INTO mgh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ni Aparamu ahonkhuna heema awe, mpaka urwaa ukhala ilapo yo Manree iri cooco Heporoni, ni anttitthimihaka Nluku ahontekela ikhilompi. ");
INSERT INTO mgh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ila yaakhumelenle ukati waryawe mwene uSineyari eehaninya Anrafeli, Ariyoki ari mwene o Elasari, Ketolameri nari mwene o Lamu ni Titali ari mwene o Koyimi. ");
INSERT INTO mgh_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Yahowana ikhotto ni Peera, mwene o Sotoma, ni Pirisa mwene o Komora, ni Sinape mwene o Atama, ni Semeperi mwene o Sepoyimi ni amwananaka ni mwene o Pela weehaninya Sowari. ");
INSERT INTO mgh_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Othene ale yahaatakaniha anakhotto aya unikuwani no Sitimi, niri ipharyaa yo maakha. ");
INSERT INTO mgh_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Myakha khumi na miili yahommarela nteko Ketolameri, nanso mwakha wonakhumi na miraru yahonhanyurihela. ");
INSERT INTO mgh_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mwakha wonakhumi ni micese, ahowa Ketolameri ni mamwene yarinawe ni yahaatthema Amarefayimi o Asteroti-Karimeyimi ni Asusimi o Hamu ni a Emini o Save-Kiriyatayimi. ");
INSERT INTO mgh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ni Mahorewu o myakoni co Seyiri, mpaka El-Parani uri vakhiviru ni itakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Wahoolo yahoturuwa ni yahophiyaca o En-Misipati uneehaninya uKate ni yahotthema ilapo cothene ca Amalekita ni ca Amorewu, yakhala uHasasoni-Tamar. ");
INSERT INTO mgh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Vano yahokhuma mamwene o Sotoma, ni o Komora, o Atima, o Sepowimi ni o Pela uneehaninya Sowari ni yaholamulelana ni wanca ikhotto yaananaka yaale onikuwani no Sitimi, ");
INSERT INTO mgh_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","amwaananaka Ketolameri, mwene o Lamu ni Titali mwene o Koyimi ni Anrafel, mwene o Sinar, ni Ariyoke, mwene o Elasar. Mamwene macese yaanaanaka mamwene mathanu. ");
INSERT INTO mgh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Vano nikuwa no Sitimi nahocara maliti o marove. Mamwene o Sotoma nu Komora yahotthawa. Akina yahovariya ni yahanle ayo yahotthawela umwakoni. ");
INSERT INTO mgh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Yahokusaca mihakhu cothene co Sotoma ni uKomora ni coolya caya cothene ni yahorwaca. ");
INSERT INTO mgh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ni ciicammo ahovariya Loti, mwana a munnaawe Aparamu, akhala oSotoma, ni mihakhu cawe ni yahokhumaca. ");
INSERT INTO mgh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Nanso ahowa mmoca ootopweele, phunttonkelaka Aparamu, Nheperewu; aakhala ncoko wo Manre, Mmorewu, munnaawe Esikole ni Aneri, othene yari asikhwawe Aparamu. ");
INSERT INTO mgh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Wiiwa wawe Aparamu wiira mwana amunnawe hotthukiya, ahaakumiha alopwana iminya ttharu nuwa khumi na nanne (318), yayareliye wapuwani wawe ni yahoomolanihaca mpaka uTani. ");
INSERT INTO mgh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ni yahokawanaca uhiyu yaavyaka mananna owaatthema. Uyo ni ipottha cawe, yaheevaca eenani ni akina ayo woomolanihaca mpaka uHopaa, unkhala mphantte wonthiyana wo Tamasiku. ");
INSERT INTO mgh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ni ahaakihera mihakhu cothene ni ahomwakihera Loti mwana amunnawe, ni mihakhu cawe, athiyana othene ni anantthukiya othene yariwo. ");
INSERT INTO mgh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mwene o Sotoma ahomwikamela Aparamu akhumaka okhottoni yonrakaliha Ketolameri ni mamwene yarinawe onikuwani no Save, niri nikuwa na amwene. ");
INSERT INTO mgh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melekesatiki, mwene o Salemu, ahowiha nkatthe ni ivinyu ni yooyo ari nhooleli ottiini ya Nluku o wirimu. ");
INSERT INTO mgh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ahonreeriha numwiirela: Nluku muulupale mwaneene irimu ni itthaya oreeriheni Aparamu. ");
INSERT INTO mgh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ni attottopeliye Nluku o wirimu oovahile eenani mmatatani mwaa. Ni ahommaha mphantte wonakhumi wo citthu cothene carinawe. ");
INSERT INTO mgh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ni mwene o Sotoma ahomwiirela Aparamu: Ukivaheke atthu ayo, weva ukuseke mihakhu nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nanso Aparamu ahomwiirela mwene o Sotoma: Kihowusa matata aka kilupelaka wa Mwaneene Nluku, Nluku Ooculu, mwaneene irimu ni itthaya. ");
INSERT INTO mgh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Akintthuna itthu phi itthu iri yawaa, hata nripwe wokwakwaatta caa, wiira we uhikiirele: Kihonthaciriha Aparamu. ");
INSERT INTO mgh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Khiiwo imphavelaka, kahiki yoolya ililyaya ipottha caka ni mphantte ommwaca Aneri, Esikoli ni Manree, yakiveleenle. Ayo yakheleke mphantte aya. ");
INSERT INTO mgh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Cinavinrene nnya citthu nnya, nuulumo na Mwaneene Nluku nahowa waAparamu munttorani: Uhoove, Aparamu! Mi phi mi, mwaakihi aa. Itthuvo aa inhala ukhala yuulupale. ");
INSERT INTO mgh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Nanso Aparamu ahokoha: Pwiya Nluku, unhala ukivahani, kamana nanlelo akirina mwana ni nohala uhalana cirinaka phi Eliyeseri o Tamasiku? ");
INSERT INTO mgh_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ni ahoncerera tho eeraka: We khukivahile mena mwana! Karumeya aka phinhala ukhala nkalanupa aka. ");
INSERT INTO mgh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Vano Mwaneene Nluku ahomwaakhula eeraka: Nkalanupa aa khanhala ukhala uyo. Mwana oonyara yo weva phinhala wuuranttela. ");
INSERT INTO mgh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ankumiheraka vate inupa, ahomwiirela: Uwehe wirimu ni waalikele itthoottwa, wooryaka waalikela. Ni ahopwaherera eeraka: Nloko naa nno phinhalaya ukhala toko nnya itthoottwa nnya. ");
INSERT INTO mgh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aparamu ahonkupali Mwaneene Nluku ni yeeyo yahopankiya ukhala ikhweeli aya. ");
INSERT INTO mgh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ahomwiirela nanlelo: Mi Mwaneene Nluku kuukumihile Ur yo Kasiti wiira kuvahe ila ilapo ela ukhala yawaa. ");
INSERT INTO mgh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aparamu ahonkoha eeraka: Pwiya Nluku, kinhala ucuwela cani wiira khweeli kimmopattha? ");
INSERT INTO mgh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ule ahomwaakhula: Ukiwiihere mwamope, ipuri ni ikhontwaa, cothene cokhalana myakha miraru cookumi ni ciicammo nciiya nimoca ni ikhuntta imoca. ");
INSERT INTO mgh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aparamu ahowiha cothene cenye inama nnye, ahottupula iriyariru ni aheekathi khula mphantte uhoolo wa nkhwaya, nanso asanuni ayo khattupulanihile. ");
INSERT INTO mgh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Vano inaka cahopacera ukhuruwela vanamani vale, nanso Aparamu anhakha. ");
INSERT INTO mgh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wakelaya ncuwa, Aparamu cahomola ikhove cuulupale ni yahommwela ipiphi yiinci. ");
INSERT INTO mgh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Vano Apwiya yahomwiirela: Ucuwele wiira uneethi aa unkokhala ilapo ihiri yawaya, inkelaya upankiye ipottha ni uhuvihiya myakha iminya cese. ");
INSERT INTO mgh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nanso mi kimmottarusa ilapo inhala wupankani ipottha ni wahoolo mumokhuma ni mihakhu cinci. ");
INSERT INTO mgh_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nanso we unaahala urwaa ni mpuha waanhakhalayi aa ni unhala uvithiya unooluvanle cinenne. ");
INSERT INTO mgh_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nloko noneecese, uneethi aa unaturuwela va kontha utakhali wa Amorewu khunaya uphiya nlipa naya. ");
INSERT INTO mgh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Wahoolo ncuwa ninakenlene ni iwaaka ipiphi, yahoonnya niikho yotthuwa mwiisi ni nthuko woopharela wahovira nnamani coottupulanihaciya nye. ");
INSERT INTO mgh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nenne nihuku nne Mwaneene Nluku aholeehana ni Aparamu. Uneethi aa kihovaha ilapo ela ukhuma mooloko wo Wiciipitu mpaka mooloko muulupale uneehaninya Ufarati, ");
INSERT INTO mgh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ilapo yo maKenii, yo maKenesii, yo maKetimonii; ");
INSERT INTO mgh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","yo maHitita, yo maFeresii; yo maRefayinii, ");
INSERT INTO mgh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ya Amorewu, yo maKanaa, yo maKirkasii ni yo maYepusii. ");
INSERT INTO mgh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Vano, Sarayi, amwaarawe Aparamu khaayanre. Kamana ahaana ipottha awe yo mwanthiyana o Wiciipitu, eehaninya Hakari. ");
INSERT INTO mgh_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi ahomwiirela Aparamu: Kamana Mwaneene Nluku hokateliha uyara, nkuseke ipottha aka. Pooti kinapanka nloko nhina mo yeeyo. Aparamu aheewelela yahimilyawe Sarayi. ");
INSERT INTO mgh_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wakhumelenlyaya ukati wapiihenryaya Aparamu awaanyawe myakha khumi akhalaka uKanaa. Wari yooyo ukati uyo, Sarayi wanvahile awe Aparamu ipottha awe yo Wiciipitu yiihaniyaka Hakari. ");
INSERT INTO mgh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Uyo ahonthukumanana Hakari ni ahorupala. Woonyaya irukulu, Hakari ahopacera waweha nseru athiyana a akunya awe. ");
INSERT INTO mgh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Vano Sarayi ahomwiirela Aparamu: Wumorele yo weva ula uruttu ula ukihuviha waa. Kihoovaha ipottha aka mmatatani mwaa, vano woonyaya wiira ihorupala, inakitarawa. Mwaneene Nluku akhale mayohukhumu; ni mayonihukhumu mi ni we. ");
INSERT INTO mgh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aparamu ahomwaakhula Sarayi: Ipottha aa iri mmatatani mwaa. Upanke inhala wucivela. Vano Sarayi ahonhuviha Hakari mpaka ule utthawa. ");
INSERT INTO mgh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ncelo aApwiya ahomphwanya Hakari vakhiviru ni ilusi muthakoni, ni iphiro inrwaa uSuri, ");
INSERT INTO mgh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ni ahonkoha: Hakari, ipottha ya Sarayi, unkhuma vayi? Unkela vayi? Ule ahaakhula eeraka: Kinontthawa Sarayi, nkunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ncelo a Mwaneene Nluku ahomwiirela: Uturuwele wa nkunya aa ni weevaherere wa yooyo. ");
INSERT INTO mgh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ncelo aheera tho: Kimmowuncerera nloko naa ni khaawo nohala woorya waalikela. ");
INSERT INTO mgh_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Aheereliya tho ni Ncelo a Mwaneene Nluku: We uhorupala ni unamphwanya mwana ni urwaa ummaha ncina na Sumayili, kontha Mwaneene Nluku homwiiwa muhuvani mwaa. ");
INSERT INTO mgh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Uyo nohala ukhala toko mwaapuru oontakhwani. Ntata nawe ninhala ukhala no waanana othene ni matata a atthu othene anhala ukhala umwanana uyo, ni makhalelo awe anhala ukhala uwaana na asunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nna phi ncina nanvahilyawe Mwaneene Nluku amuulumannyawe: We El Royi, kontha eenre: Kihomoona ule nokoona? ");
INSERT INTO mgh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Phimaana ilusi iri iriyariru o Kattes ni Perete, wiihaninye Iluusi yo Lahayi-Royi. ");
INSERT INTO mgh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hakari ahonnyara mwana a Aparamu ni ule ahommaha ncina na Sumayili. ");
INSERT INTO mgh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aparamu aarina myakha thamanini na siita (86) ceyarelo ukati wannyanryawe Hakari Sumayili. ");
INSERT INTO mgh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aparamu unhaleelaka mwakha mmoca wiira apiihere iminya (99) ceyarelo, ahomphwanyinya ni Mwaneene Nluku ni ahomwiirela: Phi mi Nluku Okuru Cothene. Weette toko cintthunaka ni wiivaherere wa mi. ");
INSERT INTO mgh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kinawuleehanana we. Kinawuncerera venci ucuulu aa. ");
INSERT INTO mgh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aparamu ahooromela vathi ni Nluku ahomwiirela: ");
INSERT INTO mgh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Uviriyane. Nna phi nleehano naka we ni mi. We unhala ukhala athumwanaya ilapo cinci. ");
INSERT INTO mgh_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Khunhala wiihaninya tho Aparamu. Ncina naa ninhala ukhala Aparahamu, kontha mi kihoohela ukhala athumwanaya ilapo cinci. ");
INSERT INTO mgh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kinaahala uwunnuwiha venci ni nhina mwawe kinapanka maloko menci mwawe ammokhuma mamwene. ");
INSERT INTO mgh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kimmopanka nleehano naka mi ni we ni ucuulu aa uttuli waya mmalokoni mwaya, wiira kikhale Nluku aa ni Nluku a alokwaa, nimmokhala nleehano noohimala. ");
INSERT INTO mgh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ilapo yothene yo Kanaa, uryaa nletto, kimmowuvaha toko yawaa mpaka khalayi; we ni ucuulu aa ni mi kinhala ukhala Nluku aya. ");
INSERT INTO mgh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Vaavale Nluku ahomwiirela tho Aparahamu: Usunke nleehano naka, ukhuma we mpaka ucuulu aa wothene unhalaa ukhalana. ");
INSERT INTO mgh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nna phi nleehano naka kimpankaka we nu ucuulu aa, ninlamuliya usunkiya, alopwana othene nhina wa nyu, anlamuliya wuula icantto. ");
INSERT INTO mgh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nnolamuliya upanka ila icantto ela toko ikanyero yo nleehano naka mi ni we. ");
INSERT INTO mgh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ukhuma nloko naa urwaka uhoolo, mwana mwanlopwana rina mahuku nanne, nolamuliya wuula icantto, akhale ooyariya wapuwani waa hata nayo oothuminya toko ipottha pooti ohikhala alokwaa. ");
INSERT INTO mgh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Akhale ooyariya wapuwani waa, atthuna oothuminya ni nsuruku, anlamuliya wuulihiya icantto wiira nleehano naka nooheliya ikanyero mwirutthuni mwinyu nikhale nleehano noohimala. ");
INSERT INTO mgh_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ntthu phi ntthu mwanlopwana oohuula icantto, nolamuliya ukumihinya iriyari wo uneethi aka, hohanyuriha nleehano naka. ");
INSERT INTO mgh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nluku ahomwiirela tho Aparahamu: Ukhuma nenna vaa mpaka wahoolo, amwaaraa khanhala wiihaninya tho Sarayi. Ncina naya ninhala ukhala Asaara. ");
INSERT INTO mgh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mi kinawareeriha ni nhina wa yaayo kinnowuvaha mwana. Khweeli, mi kinawareeriha ni mwa yaayo ammokhuma maloko, mamwene ni ilapo ca atthu. ");
INSERT INTO mgh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Vano, Aparahamu ahooromela vathi, ahothyaa ni aheera: Wanawooryaa nlopwana o myakha iminya (100) ceyarelo unnyara mwana? Wanawooryaa Asaara uyara toko warinaya myakha miloko mithanu na micesei (90)? ");
INSERT INTO mgh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Aparahamu ahomwiirela Nluku: Unhiye Sumayili akhale nkumi wamiithoni waa. ");
INSERT INTO mgh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Vano Nluku ahomwaakhula: Khweeli Asaara amwaaraa, unannyarana mwana ni we unnomwiihana Isaki. Ni yooyo kimmopankana nleehano noohimala wamoca nu ucuulu awe wothene. ");
INSERT INTO mgh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mwaha wa Sumayili, kiheewa. Uviriyane. Kinonreeriha, kinnonvaha atthu enci ni kimmowuncerera ucuulu awe. Uyo nohala ukhala athumwanaya mamwene khumi na meeli ni nhina wo yooyo immokhuma ilapo yuulupale. ");
INSERT INTO mgh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nanso nleehano naka, mi kinhala upanka ni Isaki, mwana nohala unnyara Asaara mwahiyu yoola ukati ula. ");
INSERT INTO mgh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wamanlyawe wuulumaca na Aparahamu, Nluku ahothama nuuwela. ");
INSERT INTO mgh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nenno nihuku nno, Aparahamu ahonkusa Sumayili ni othene yayarenle wapuwani wawe na ale yathuminye, alopwana othene owapuwani wawe ahooliha icantto toko Nluku canlamulenlyawe. ");
INSERT INTO mgh_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ukati woolihiyaya, Aparahamu wahalela mwakha mmoca wiira apiihere iminya (99) ceyarelo ");
INSERT INTO mgh_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ni mwanaya aarina myakha khumi na miraru. ");
INSERT INTO mgh_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aparahamu ni Sumayili yoonle icantto nenno nihuku nno. ");
INSERT INTO mgh_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Wamoca na Aparahamu, yahoolihiya icantto atthu othene owapuwani wawe, ooyareela vava na ale oothuminya uttayi. ");
INSERT INTO mgh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nihuku nimoca ukati woothana Mwaneene Nluku ahonkhumelela Aparahamu nonkomile wankhora wo heema ankhuruttunlyawe mmitthucini co mooko co Manree. ");
INSERT INTO mgh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Aparahamu ahowusa miittho awe ni ahoona alopwana araru anamwemeleenle vakhiviru. Woona wawe ahonwa wankhora wonkomilyawe ni wowakuvyaca wene aheekamela ni ahooromela mpaka vathi. ");
INSERT INTO mgh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Aheera: Pwiya, wakhala wiira wanakiphwanela, nhipwahe wakarumeya enyu, woheemela. ");
INSERT INTO mgh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kinaruma wiira awaaniye maasi wiira nrapihe inyaa cinyu ni mmumule vathi mwiri ula. ");
INSERT INTO mgh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kinawuwiiherani yoolya wiira mphwanye ikuru, wahoolo nnapwahaka ukhala wiira nhophiya wakarumeya enyu. Ale yahaakhulaca: Aye, upanke toko cuulumacilyaa. ");
INSERT INTO mgh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Wowakuvyaca wene, Aparahamu ahokela nheemani ni aheerela Asaara wiira ahaawule iphepa yotteela ya atthu araru, ni anyatte ni apanke mikatthe. ");
INSERT INTO mgh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Wahoolo ahorwaa muncicini ni ahonthanla mwaamope omaana, ahonvaha ipottha awe wiira antthenkace wowakuvyaca. ");
INSERT INTO mgh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ahowana nhuci wookikitthiya, ileeti ni ipilipica conama catthenkaciye ni ahaavahaca. Alyacaka ono, yaheemelelaca wantthucini. ");
INSERT INTO mgh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Vano yahonkohaca: Amwaara Asaara ayo, ari vayi? Ule ahaakhula: Ari nheemani mwe. ");
INSERT INTO mgh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Vano nlopwana mmoca aheera: Kinawuphwanya tho mwaahiyu ni amwaaraa Asaara kinhala waaphwanya ni mwana. Asaara yeera yiiwaka moolumo ayo nari wiithela nkhora wo heema. ");
INSERT INTO mgh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aparahamu ni Asaara yahooluvalaca venci ni Asaara wahaanvirela ukati wooyara. ");
INSERT INTO mgh_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Phimaana yahothyaa veekhawe yupuwelaka wiira, kinooluvanlene wanaahala ukitteeliha tho nrima? ");
INSERT INTO mgh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nanso Mwaneene Nluku ahomwiirela Aparahamu: Asaara ayo anthyani yiiraka: Khweeli kinaahala uyara mi kinooluvanlene? ");
INSERT INTO mgh_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ihaawo itthu inolwanawe Mwaneene Nluku? Kinawuphwanya tho mwaahiyu yoola ukati ula ni Asaara kinhala waphwanya anayanre. ");
INSERT INTO mgh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Vano Asaara yahoova phimaana yahoruna yiiraka: Mi akithyele. Ule aheerela: Nhirune, nhothyaa nyu. ");
INSERT INTO mgh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Vano alopwana ale warwaya yahoona uhitto nwo ilapo yo Sotoma. Aparahamu ahaaveleela ni waleeha. ");
INSERT INTO mgh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Vaavale Mwaneene Nluku aheera: Kinanvithela Aparahamu itthu inhalaka upanka, ");
INSERT INTO mgh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ukhala wiira Aparahamu nohala ukhala athumwanaya ilapo yuulupale ni yokuru, ni mwanlattu wo yooyo ilapo cothene cinareerihiya. ");
INSERT INTO mgh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kontha mi kihonthanla wiira aahimerye asaanawe ayo ni ucuulu awe uyo wiira yiisunke mphironi mwa Mwaneene Nluku, apaankaka coosariya ni ceekhweeli wiira Mwaneene Nluku anvahe Aparahamu citthu cinkhuluvelihilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mwaneene Nluku aheera tho: Cinriyeleliyaya a Sotoma ni a Komora ciri ciinci ni itaampi caya nnyo cihotepa. ");
INSERT INTO mgh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kinakhuruwela wonwo koone wakhala wiira cinhiminya nnyo ciri ceekhweeli, cakhala cowoothiya kacuwele. ");
INSERT INTO mgh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Vano alopwana ale yahokhumaca arwaka uSotoma nanso Aparahamu ahohala ninlelo ni Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aparahamu ahaattamerya ni aheerela: Unantankanyaa nasariya wamoca ni nkaafiri? ");
INSERT INTO mgh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kaahiki yakhalaka anasariya hansiini mparasa mmo nanlelo nnatankanyaa ni khannohala unemecera nipuro nno mwanlattu wo wafenta anasariya hansiini ariwo ayo? ");
INSERT INTO mgh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Yukhaleni uttayi upanka yeeyo itthu iyo, umwiiva nasariya wamoca ni nkaafiri toko wiira oyeeli ayo analikana, yukhaleki uttayi! Khanhala wuuluma wosariya hukhumu olapo yothene? ");
INSERT INTO mgh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mwaneene Nluku ahaakhula: Mi kaaphwanyaka anasariya hansiini uSotoma nwo, mwanlattu wo wafenta yaayo, kinaahala unemecera iparasa eyo yothene. ");
INSERT INTO mgh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aparahamu ahaakulela tho: Kihocuwela wiira kihoocurweelani uwuulumanani Pwiya, mi kinari ntthupi ni ittura. ");
INSERT INTO mgh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nanlelo kinakoha: Kaahiki yahalaka athanu wiira aphiyere anasariya hansiini? Nnatankanyaa iparasa eyo mwanlattu wo yaayo athanu ayo? Ayo yahaakhula: Kaaphwanyaka nwo arupayini nathanu akintankanya. ");
INSERT INTO mgh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ahaakhanyereriha Aparahamu: Kaahiki mwaphwanyaka arupayini paahi? Ayo yahomwaakhula: Mwanlattu wowafenta atthu arupayini ayo, akintankanya. ");
INSERT INTO mgh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Vano ule ahopwaherera: Nhiviruwe Pwiya, nkilevele kuulume. Kaahiki mwaphwanyaka talathini pahi? Mwaneene Nluku ahomwaakhula: Kaaphwanyaka talathini akintankanya. ");
INSERT INTO mgh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aparahamu aheera tho: Kihocuwela wiira kihoocurweelani uwuulumanani Pwiya; kaahiki mwaphanyaka nwo siriini? Mwaneene Nluku ahaakhula: Mwanlattu wowafenta siriini ayo, akintankanya. ");
INSERT INTO mgh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Vano Aparahamu aheera tho: Nhiviruwe Pwiya, nanso nkilevele wiira kuulume ikwaha imoca pahi. Kaahiki mwaphwanyaka khumi pahi? Mwaneene Nluku ahaakhula: Mwanlattu wo wafenta khumi ayo, akintankanya. ");
INSERT INTO mgh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Namanleene umuulumana Aparahamu, Mwaneene Nluku ahokhuma ni Aparahamu ahoturuwela uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Wakelaya ncuwa nno ancelo eeli ale yahophiyaca uSotoma, ni Loti onkomile wankhora woparasa. Ukati woonnyawe ahoonwa ni ahorwaa wakhelelaca. Ahokhoroma ni ahopiiha iyuci awe vathi, ");
INSERT INTO mgh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ni aheerelaca: Asuulupale aka, sontte. Nkivelele mpani wa karumeyi inyu. Wonwo nnaahala urupa nuurapa. Wasaka meelo mpwaheke nrwaka. Ayo yahaakhulaca: Mena, ninkorupa vate. ");
INSERT INTO mgh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nanso ule ahaakhanyererihaca, ni ale yahommelelaca ni yahokelaca mpani. Loti ahoruma watthonkomaniheraca yoolya ni woosa mikatthe cohi miropo, ni ale yaholyaca. ");
INSERT INTO mgh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ahinaya urwaca wurupani, alopwana othene o miphantte cothene co Sotoma, ukhuma acikani ni oolupale yahovirelaca inupa eyo. ");
INSERT INTO mgh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ni yahomwiihanaca Loti amwiirelaka: Ari vayi alopwana awacile wapuwani waa ayo ula uhiyu ula? Uniwiihere vate va nimphavela waarupana. ");
INSERT INTO mgh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti ahokhuma mpani mmo, ni ahotthyaa nkhora uyo nttuli nttuli, ");
INSERT INTO mgh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ni aheerelaca: Mena asimpwanaka! Nhipankace itthu yoonanara! ");
INSERT INTO mgh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Moonace, kihaana asaana eeli asithiyana asimwarusi. Kinawawana wiira nyu mwapankace itthu imphavelenyu. Nanso ala asilopwana ala nhaapankace itthu, kontha ari mmatatani mwaka ni ankhikicera ipuwa aka. ");
INSERT INTO mgh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yahokhuwelaca yiiraka: Ukhume va! Ni yaheeraca tho: Ula nlopwana ula ri nletto, vano nophavela ukhala mayoohukhumu! Ninkowupanka we itthu yootepa wavikana ayo. Vano yahonkakhaca Loti wonkhitto ni yahorwaca uhoolo wiira yaakace nkhora. ");
INSERT INTO mgh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Commo, aletto eeli ale yahonvaraca Loti nuumpurulela mpani ni yahotthyaca nkhora oyo. ");
INSERT INTO mgh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Vano yaharakalihaca ni iretta yohoona alopwana yari wankhora wonupa ayo, ukhuma acikani mpaka asuulupale ayo, mpaka wahinooryaya uphwanya nkhora. ");
INSERT INTO mgh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Alopwana eeli ale yahonkohaca Loti: We uhaana tho ntthu mparasani mu, mivokohica, asaana asilopwana na asithiyana, atthuna mmuci nkina? Mwatamihace va, ");
INSERT INTO mgh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kontha nimphavela ukwanyulaca nna nipuro nna. Cinariyelelawe Mwaneene Nluku ala atthu ala ciri cinci, phimaana honiruma ukwanyula iparasa. ");
INSERT INTO mgh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Vano Loti ahorwaa wuulumana mivokohi cawe, ale yahala waathelaca asaanawe, ni yaheerelaca: Nkhumace wowakuvyaca nna nipuro nna, kontha Mwaneene Nluku nophavela ukwanyulaca iparasa ela! Nanso ayo yahopuwelaca wiira uyo aanawathwelana. ");
INSERT INTO mgh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ukhuma waya ncuwa, ancelo ale yahonkhanyererihaca Loti yiiraka: Wakuve! Wakuse amwaaraa na asaanaa eeli, atthuna ni nyu nnaahala ukhwaca wanhalaya uttarusiya iparasa eyo. ");
INSERT INTO mgh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Amananihaka ukhotta, asilopwana ale yahommaraca moono oyo, wamoca na amwaarawe na asaanawe, ni yahaakumihaca nipuro nno wokuru ni yahohiyaciya uta waya iparasa, kontha Mwaneene Nluku ahoonelaca ikiriri. ");
INSERT INTO mgh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ukumihiya waya mparasa mmo, ncelo mmoca ahomwiirela Loti: Ntthawe mwanlattu wofenta ukumi! Uhiwehe uttuli wala uheemele nipuro nnikuwani! Utthawele umyakoni, atthuna we unaahala wiiviya! ");
INSERT INTO mgh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Wahoolo Loti aheerelaca: Mena, Pwiya aka! ");
INSERT INTO mgh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Karumeyi inyu hokhala uwoopwa mwanlattu wokiriri cinyu, kontha nyu nhokoonela ikiriri nrattavelelaka ukumi aka. Akinoorya utthawela mpaka umwakoni, wiira yowerya ila ihikiphwanye ni mi kikhwaaka. ");
INSERT INTO mgh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Vakhiviru va ihaawo iparasa yankani. Iri vakhiviru cinenne wahoreera utthawa mpaka uphiya wonwo. Nkihiye kirwee wonwo! Hata ikhale yankani cinenne, kinkokhala uwoopwene. ");
INSERT INTO mgh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ule ahaakhula: Wahoreera. Mi kinaahala wukavihera yeeyo ivekenlyaa eyo. Akinhala ukwanyula iparasa inhimilya eyo. ");
INSERT INTO mgh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Wakuve utthawe. Akinhala upanka itthu we uhinaya uphiya wonwo. Phimaana iparasa iyo yiihaniyaka Sowari, manaaya ikani. ");
INSERT INTO mgh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti, uphiya wawe uSowari, ncuwa nahokhuma mwilaponi mmo. ");
INSERT INTO mgh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Vano Mwaneene Nluku ahokurusela ilapo yo Sotoma nuKomora mooro wowopiha wookhuma wirimu. ");
INSERT INTO mgh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Commo yahokwanyula nye iparasa nye ni nikuwa nothene, wamoca na atthu yakhalaca ayo ni imatta caya nyo. ");
INSERT INTO mgh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nanso amwaarawe Loti yahoweha uttuli ni yahothatuwa iruwa yo maakha. ");
INSERT INTO mgh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wasilyaya, Aparahamu ahonwa ni ahoturuwela nipuro namoonananyawe Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ni ahoweha uSotoma nuKomora, nu nikuwani nothene, ni ahoona mwiisi mwinci uwelaka ukhuma vathi, toko mwiisi wo nttukutthani. ");
INSERT INTO mgh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ukati wakwanyunlyawe iparasa ciri unikuwani, Nluku ahomuupuwela Aparahamu ni ahonkumiha Loti mmasakhani wokwanyuliya iparasa cakhalawe. ");
INSERT INTO mgh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti ahokhuma uSowari na asaanawe eeli asithiyana ni yahorwaca ukhala umyakoni, kontha anawoova ukhala uSowari. Ule akhala nnikhukuni wamoca na asaanawe eeli asithiyana. ");
INSERT INTO mgh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nihuku nimoca, mwana mwanthiyana omuulupale, ahomwiirela omwankani uyo: Apaapehu ahooluvala, ni khaawo nlopwana vakhiviru unithela toko ilemalelo yolapo yothene. ");
INSERT INTO mgh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nrwee naavahe nipha apaapehu ni wahoolo va nathukumananeke wiira nloko nihu nihikhwelakhwele. ");
INSERT INTO mgh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Yoole uhiyu ule yahaavahaca nipha apaapaya. Vano mwana mwanthiyana oomuulupale uyo ahokela ni ahaathukumanana athumwane. Ni ale khayaacuwelenle ukati warupilyawe ni wonwilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Usa waya, mwana mwanthiyana omuulupale uyo ahomwiirela omwankani uyo wiira: Uhiyu kihaathukumanana apaapa. Nrwee naavahe tho nipha ula uhiyu ula, ni we unaahala waathukumanana, wiira nihikhwelakhwele nloko na apaapehu. ");
INSERT INTO mgh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Vano tho yahaavahaca nipha athumwanaya yoole uhiyu ule, ni mwana mwanthiyana omwankani uyo ahorwaa wathukumanana. Ni ayo khayaacuwelenle ukati warupawe ni wonwilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Commo, asaana oyeeli a Loti yahorupalihaciya na athumwanaya. ");
INSERT INTO mgh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Omuulupale uyo ahonnyara mwana, ni ahommaha ncina na Mwape. Yooyo phiri athumwane Amwape oleelo. ");
INSERT INTO mgh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Omwankani uyo ciicammo ahonnyara mwana, ni ahommaha ncina na Pin-Amii. Ula phiri athumwane atthu Amonii oleelo. ");
INSERT INTO mgh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aparahamu ahokhuma vale arwaaka nttetthe wo Nekepe ni ahorwaa ukhala iriyariru Katesi nuSuri. Wahoolo ahokhala ukati vakani uKerari. ");
INSERT INTO mgh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Uyo eerela: Asaara wiira mwanrokoraka. Vano, Apimeleke, mwene uKerari ahoruma urweliya Asaara ni ahaakusa ukhala awawe. ");
INSERT INTO mgh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Yooyo uhiyu uyo Nluku ahowa waApimeleke munttorani ni ahomwiirela: We unaakhwa! Athiyana yakusilyaa ayo ahotheliya. ");
INSERT INTO mgh_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nanso Apimeleke, hinaya waarupana aheera: Pwiya, nnowa ukwanyula uneethi wohicuwela itthu? ");
INSERT INTO mgh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kahimmwe yooyo phikiirenle: Nthiyana ola mwanrokoraka? Ni ayo khayinre: Nlopwana ola nrokoraka? Ipankilyaka iri yo nrima wooreera ni wohinlattu. ");
INSERT INTO mgh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Vano Nluku ahomwaakhula munttorani: Aye, mi kinacuwela wiira upankile itthu iyo ni nrima wooreera. Mi kihohiiha wiira uhikufuru phimaana kiwatelihaka warupana. ");
INSERT INTO mgh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Vano waturusele athiyana ayo wa awannyaya. awannyaya Ayo nnapiyu, ni anawuswalela wowufentelela, wiira we uhikhwe. Nanso wahaturuseke ukupali wiira we ni awaa othene nnakhwaca. ");
INSERT INTO mgh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wasilyaya wicisuru Apimeleke ahaalattula mahumu awe ni wattonkela cothene cankhumelenle, ni yahoovaca venci. ");
INSERT INTO mgh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Wahoolo Apimeleke ahomwiihana Aparahamu ni ahomwiirela: Unipankile cani? Kukosenre isiyani mpaka ukikosiha venci ni omwene aka wothene? Ikipankile iyo khampankiya ntthu. ");
INSERT INTO mgh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ni Apimeleke ahonkoha Aparahamu: Yupankihile isiyani commo? ");
INSERT INTO mgh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aparahamu ahaakhula: Kahoopuwela wiira: Khweeli khaawo nomoova Nluku nna nipuro nna ni kinawiiviya nlattu wa amwaaraka. ");
INSERT INTO mgh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Uhiya commo, ayo khweeli mwanrokoraka mphantte wa apaapa, nanso wohikhala mpantte wa maama. Vano ahokhala amwaaraka. ");
INSERT INTO mgh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ni Nluku wakikumihilyawe uwaani wa apaapa, mi kaheerela amwaaraka ayo: Nkiweele iraati: Nipuro phi nipuro ninhalehu uphiya, nkiireleke wiira: Ule nrokoraka. ");
INSERT INTO mgh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Vano Apimeleke ahowiha ikhontwaa ni imope, ipottha cilopwana ni cithiyana, ahommaha Aparahamu ni ahonturusela amwaarawe ayo. ");
INSERT INTO mgh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ni Apimeleke aheera: Ilapo aka iri ni we. Ukhaleke nipuro phi nipuro ninoocivela. ");
INSERT INTO mgh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Apimeleke ahomwiirela Asaara: Arokoraa ayo kihaavaha ncurukhu elufu (1000) wopheeta, wiira walivyane wutthekenlyaka va wamiithoni wa atthu othene. Commo othene phinhalaya ucuwela wiira we khiiwo incuwelaa yookosa. ");
INSERT INTO mgh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Wahoolo, Aparahamu ahonvekela Nluku wiira avone, ni Nluku ahomvoniha ni amwaarawe ni ipottha cawe, mpaka yahanca uyaraca, ");
INSERT INTO mgh_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","kontha Mwaneene Nluku ahaapankaca eekupa asithiyana othene a Apimeleke nlattu wa Asaara, amwaara a Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mwaneene Nluku ari ooloka ni Asaara, toko camwiirenlyawe, ni ahompanka toko cankhuluvelihilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ukati wacilyawe Nluku, Asaara ahonnyara mwana ni ahommaha Aparahamu nooluvanle. ");
INSERT INTO mgh_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Mwana annyarannyawe Asaara, Aparahamu ahommaha ncina na Isaki. ");
INSERT INTO mgh_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaki wapiihenryawe mahuku mathanu na mararu ookumi, Aparahamu ahomuuliha icaantto, toko calamuleliyawe ni Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ukati wannyanryawe Isaki, Aparahamu ahaana myakha iminya (100). ");
INSERT INTO mgh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Asaara aheera: Nluku hokiteeha, ni othene anhala ucuwela ila itthu ila anaahala uthyaa ni mi wamoca. ");
INSERT INTO mgh_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ni ahopwaherera eeraka: Aacuwela tipani wiira Asaara anhala umwaamwiha mwana? Mothene mmo, mi kihommaha mwana Aparahamu nooluvanle. ");
INSERT INTO mgh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaki ahonnuwa ni ahohiihiya nipele. Ni nenno nihuku nno Aparahamu ahopanka isukuhuulu. ");
INSERT INTO mgh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Woonnyaya Asaara wiira mwana a Akaari, munnaciipitu, annanveha Isaki, ");
INSERT INTO mgh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","yahomwiirela Aparahamu: Umoomole Akaari ni mwanawe uyo, kontha mwanaka mi khanhala ukhala nkelanupa wamoca ni ula mwana ula. ");
INSERT INTO mgh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Iyo yahoncukuliha venci Aparahamu kontha ahokela mpwiini mmo mwanawe. ");
INSERT INTO mgh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nanso Nluku ahomwiirela Aparahamu: Uhicukulace nlattu wo mwana ni wopottha. Upanke yothene inhalaya uhimya Asaara, kontha nhina mwa Isaki phinhalaya ulemelihiya amucyaa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Nanso, ciicammo nhina wa mwana eepottha unakhala uneethi, kontha ni uyo ri mwanaa. ");
INSERT INTO mgh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wasilyaya wicisuru, Aparahamu ahokusa mikatthe ni nipinka no maasi oocareene, phunvahaka Akaari wiira akuse wanikhatani wawe ni ahonleeha wamoca ni mwanawe ule. Uyo ahottotta nttala, phurwaaka arukureryacaka itakhwa yo Peresepa. ");
INSERT INTO mgh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wamanlyaya maasi nnipinkani mmwe, ahonhiya mwanawe waniphumpuluni ");
INSERT INTO mgh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ni ahonkoma vakhiviru wene, mattalivelo aya yaari toko wanvelavelaya muupa wovonyinya ni muura, kontha eera: Akintthuna umoona mwanaka akhwaka. Ni nonkomilene vaavale, ahopacera wunla. ");
INSERT INTO mgh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nluku aheewa wunla wo mwana, ni ncelo a Nluku o wirimu, ahomwiihana Akaari ni ahomwiirela: Unocukulani, Akaari? Uhoove, kontha Nluku heewa wunla wa mwanaa nwo nipuro nimweesilyaa nno. ");
INSERT INTO mgh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Unkuse mwanaa uyo, kontha nhina mwa yooyo kimmopanka uneethi mwinci. ");
INSERT INTO mgh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Vano Nluku ahontthukula wiitho Akaari ni ahoona iluusi. Ahorwaa mpaka nenne nipuro nne, ahocariha maasi nnipinkani mmwe nuunvaha mwanawe wiira awurye. ");
INSERT INTO mgh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nluku ari ni mwana uyo. Uyo ahonnuwa, ahokhala ntakhwani ni ahokhala mayolupattha ni muura. ");
INSERT INTO mgh_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Aakhala itakhwa yo Paraa, ni anumwane yahomphavelela nthiyana olapo yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Yoole ukati ule, Apimeleke naveleeliyene ni Fikoli, nhooleli aanakhotto awe, ahomwiirela Aparahamu: Nluku ri ni we ni citthu cothene cimpankaa. ");
INSERT INTO mgh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Vano, ukilupelele, wamiithoni wa Nluku, wiira khunkithepya tho, ukhuma mi mpaka asaanaka nu ucuulu aka wothene. Ulokihe ilapo iwakhelenle unari nletto ni malokelo yupakilyaka. ");
INSERT INTO mgh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aparahamu ahaakhula eeraka: mi Kiholupela. ");
INSERT INTO mgh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Nanso Aparahamu ahonkuphula Apimeleke nlattu woluusi yakhiyaya ipottha cawe ni nkhitto. ");
INSERT INTO mgh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Nanso Apimeleke ahomwaakhula: Akinoncuwela pankile iyo itthu iyo. Khunakihimerya itthu, ilelo va phincuwelaka. ");
INSERT INTO mgh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Paahi, Aparahamu ahowiha ikhontwaa ni imope, phimmahaka Apimeleke ni othene yaholehana itthu imoca. ");
INSERT INTO mgh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aparahamu ahothanlela nipuro naya ikhontwaa saapa. ");
INSERT INTO mgh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Apimeleke ahonkoha eeraka: Inthoonyera isiyani ikhontwaa saapa cikumihilyaa munhuwoni mmo? ");
INSERT INTO mgh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Uyo ahaakhula: Utthune ikhontwaa cinoovahaaka nnya, toko usaahiti wocuwanyaa wiira thi mi kithipile ilusi ila. ");
INSERT INTO mgh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Phimaana nne nipuro nne nihaaninyaka uPeresepa, kontha oyeeli wonwo phaatanacilyaya. ");
INSERT INTO mgh_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Anaatanacilene uPeresepa, Apimeleke ni Fikoli, nhooleli anakhotto awe, yahohokoleela ilapo yo mafilistiya. ");
INSERT INTO mgh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aparahamu arwaaka ahomphattyaa wepa uPerisepa ni vaavale aholapela ncina na Mwaneene Nluku Oohimala. ");
INSERT INTO mgh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ni Aparahamu ahokhala ukati mwinci ilapo yo mafilistiya. ");
INSERT INTO mgh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Unavinre ukati vakani, Nluku ahonlawiha Aparahamu, amwiirelaka: Aparahamu. Uyo ahaakhula: Phi mi va. ");
INSERT INTO mgh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Vano Nluku aheera: Unkuse mwanaa, mwanaa mmoca yooyo, Isaki nonfentesaa uyo, ni urwee nttetthe wo Muriyaa. Wakipankele yooyo wonwo isataka yoopahiya wamwaakoni unhalaaka wuthoonyera. ");
INSERT INTO mgh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wasilyaya vale, Aparahamu ahonwa ni ahontthenkemaniha puuru awe, ahaatthukana nloko amirawo awe eeli wamoca ni Isaki mwamwanawe, ahopharula ikhuni cosataka, ahopwaha arwaaka nipuro nahimeriyawe ni Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nihuku noneeraru, Aparahamu ahowusa miittho awe ni ahoona nipuro nno nari uttayi. ");
INSERT INTO mgh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ule aheerela amirawo awe: Nhalaceke va ni puuru ula. Mi ni mmirawo ola ninrwaa uswali nwe ninawuphwanyacani. ");
INSERT INTO mgh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aparahamu ahokusa ikhuni nnye coorwa upaha isataka ni ahonrya Isaki, ni uyo ahokusa makhala o mooro ni mwaalo. Ni yeettacaka wamoca. ");
INSERT INTO mgh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaki aheerela athumwane: Paapa! Aparahamu ahaakhula: Phi mi va, mwanaka. Isaki ahaakoha: Makhala o mooro ni ikhuni phi nnya, vano iri vayi ikhontwaa yotthuvo yoopahiya. ");
INSERT INTO mgh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aparahamu ahaakhula: Mwanaka, Nluku nanivaha ikhontwaa yotthuvo yoopahiya. Ni yahopwahaca yeettacaka wamoca. ");
INSERT INTO mgh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Waphilyaya nipuro nathoonyeriyawe ni Nluku, Aparahamu ahoteka ikhilompi yoopaha isataka ni ahotataanihaca ikhuni vaavale. Ahontthuka Isaki, phumweesaka waculu ikhuni vale. ");
INSERT INTO mgh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Vano ahaawula ntata nakusilyawe mwalo ule wiira anhitte mwanawe. ");
INSERT INTO mgh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nanso Ncelo a Mwaneene Nluku ahomwiihana eeraka: Aparahamu! Aparahamu! Ule ahaakhula: Phi mi va. ");
INSERT INTO mgh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Vano Ncelo ule aheera: Uhinhonone mmirawo uyo. Uhimpanke itthu. Vano kihocuwela wiira we unamoova Nluku, kontha khukithuwile mwanaa, mwanaa yooyo rinaa mmoca paahi. ");
INSERT INTO mgh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aparahamu ahowusa miitho awe ni ahoona ikhontwaa inaphanre inyaka caya nnyo wataparikhwani. Ahorwaa ukusa ni ahovaherera itthuvo yoopahiya nipuro no mwanawe. ");
INSERT INTO mgh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aparahamu ahovaha nenno nipuro nno ncina na Mwaneene Nluku Naavaha. Phimaana mpaka ilelo waneereliyaya: Mmwaakoni mwa Mwaneene Nluku naavaha. ");
INSERT INTO mgh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ikwaha yonayeeli Ncelo a Mwaneene Nluku ahomwiihana Aparahamu ");
INSERT INTO mgh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","eeraka: Mwaneene Nluku heera: Kinalupela, mwanlattu wa yeela itthu ipankilyaa, uhikithuwaka mwanaa, mwanaa mmoca yooyo urinaa, ");
INSERT INTO mgh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","waamini wiira kinawureeriha ni nloko naa kinapanka ninci toko itthoottwa co wirimu ni toko nhava wo mpharyaa. Nloko naa nimmotthema isittatti ceenani aya, ");
INSERT INTO mgh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ni nhina mwa nenno nloko nno, ilapo cothene cimmoreerihiya, kontha we uhokiiwelela. ");
INSERT INTO mgh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Vano ahohokoleela Aparahamu waariaya amirawo awe ni othene wamoca yahoturuwela uPereseepa wakhalawe. ");
INSERT INTO mgh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Unavinre ukati vakani, ahohimerya Aparahamu wiira Milka ahaayara asaana ni Nahori, munnaawe Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ussi ari oontthara, Pussi munnaawe, Kemuweli, athumwane Arani, ");
INSERT INTO mgh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesette, Haso, Piltasi, Yitlafi ni Petuweli, ");
INSERT INTO mgh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","athumwane Repeka. Ala asaana athanu na araru yaayanryawe Milka ni Nahori, munnaawe Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ni mwaarawe oohitteliheraninya, neehaninya Reuma, ahaayara asaana ala: Tevaa, Kahami, Tahasi ni Maaka. ");
INSERT INTO mgh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Vano Asaara yahokhala myakha iminya wo siriini na saapa (127) ceyarelo, ");
INSERT INTO mgh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ni yahokhwa anari uKiriati-Arapaa uneehaninya Eforoni, ilapo yo Kanaa. Aparahamu aheekhupanya ni wonlela Asaara. ");
INSERT INTO mgh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ni Aparahamu ahiyaka mayithi awe ahonwa arwaaka wa asaana a Heti ni aheerela: ");
INSERT INTO mgh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Mi ki nletto, ni mweettakaci. Kinaalepela nipuro noopanka mahiye wiira kivithe mayithi aka. ");
INSERT INTO mgh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Vano asaana a Heti yahomwaakhula Aparahamu yiiraka: ");
INSERT INTO mgh_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Univiriyane muulupale, nhooleli a Nluku uri ni hi. Waavithe amwaaraa ayo mahiye anhalaa utthuna. Khaawo nohala wuuthuwa mahiye wiira waavithe amwaaraa. ");
INSERT INTO mgh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Vaavale, Aparahamu ahonwa ni ahooromela vathi wamiithoni wasineene ilapo, asaana a Heti. ");
INSERT INTO mgh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ule aheera: Wakhala wiira nhokitthunihera wavitha amwaaraka mu, nkiviriyane. Mwakulumele Eforoni, mwana a Sowari, ");
INSERT INTO mgh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","wiira akivahe nikhuku no Makipela niri umaverihela imatta awe iyo, ni akihimerye ihisapu enoncivela wiira akhale mahiye aka. ");
INSERT INTO mgh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Vano Eforoni onkomile wamoca na asaana a Heti, ni Eforoni, nHitita, ahomwaakhula Aparahamu, yiiwaka asaana a Heti ni atthu othene yaari wa nkhora woparasa eeraka: ");
INSERT INTO mgh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Mena, muulupale, ukiviriyane. Imatta iyo kinawuvaha, ciicammo nikhuku niri mmattani ni kinawuvaha wa miithoni wa amucyaka, uvitthe mayithi aa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Vaavale Aparahamu ahooromela wiitho waya asineene ilapo. ");
INSERT INTO mgh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ni ahomwiirela Heporoni yiiwaka atthu othene: Ukiiwe, wakhala wiira unakupali ukihimerye ihisapu yomatta iyo mi kinawuliva, wakhelele ncurukhu aka uyo wiira kivithe mayithi aka. ");
INSERT INTO mgh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Vano Eforoni ahomwaakhula Aparahamu eeraka: ");
INSERT INTO mgh_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ukiiwe muulupale aka: Imatta iyo ncurukhu aya uri iminya cese wopheeta. Isiyani vava vaa we ni mi? Uvithe mayithi aa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aparahamu ahokupali ihisapu ile ni ahokumiha ncurukhu nuunliva Eforoni wahimyacilyawe yiiwaka asaana othene a Heti, ncurukhu iminya cese wopheeta wathumeliya itthu nnakosoni. ");
INSERT INTO mgh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Phimaana nthala na Efromi naari uMakipela uhoolo waya uManre; ukhuma nthala nno, nikhuku naari munthalani mmo, ni miri cari munthalani mmo ni nnyo cari nceresere nnyo, ");
INSERT INTO mgh_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","cahokhala ca Aparahamu maana ahothuma yoonaka asaana othene a Heti naale yari wa nkhora woparasa. ");
INSERT INTO mgh_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Wahoolo Aparahamu ahaavitha amwarawe yeehaninya Asaara nnikhukuni niri imatta yo Makipela uhoolo waya uManre uneehaninya Eforoni, ilapo yo Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Phimaana imatta iyo ni nikhuku nari mmattani mmo yahokhala mahiye Aparahamu kontha anotumiheriya na asaana a Heti. ");
INSERT INTO mgh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yooyo ukati uyo Aparahamu ahooluvala ni Mwaneene Nluku ahonvaha iparakha wo citthu cothene. ");
INSERT INTO mgh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Vano Aparahamu amwiihanaka karumeyi awe omuulupale owapuwani arina nlamulo no citthu cothene cariwo, ahomwiirela: Weese ntata naa nno wanatarani waka, ");
INSERT INTO mgh_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ni ulupele wa Mwaneene Nluku, mwaneene irimu ni itthaya wiira wamphavele nthiyana oonthela mwamwanaka uhinthanle iriyari ya asithiyana annakanaa anakhalaneehu ala mu. ");
INSERT INTO mgh_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nanso urwee uwaani, ilapo iyareliyaka ni wamucyaka ni wanthanle nthiyana nohala unthela mwanaka Isaki. ");
INSERT INTO mgh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Vano karumeya uyo ahokoha: Kaahiki nthiyana uyo ahitthuneke uwa ni miyano uno, kaankuseke mwamwaninyu uyo nuunrwana ilapo ikhumileenyu? ");
INSERT INTO mgh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aparahamu ahomwiirela: Kaasope. Akinphela wiira mwamwanaka uyo unturusele uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mwaneene Nluku, Nluku o wirimu kikumihile ilapo yo mayapaapa ni iyareelyaka aholupela ni ahokikhuluveliha ukivaha mi ni ucuulu aka ila ilapo ela. Ayo anaahala wuveleelihera ncelo uhoolo waa, wiira we waanthanle woonwo nthiyana omaana oohala unthela mwanaka. ");
INSERT INTO mgh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nanso nthiyana uyo ahithuneke uwa ni we uno, unahala wothopwa ulupela waa nwo. Itthu ihimphavelaka iri unturusela mwana uyo uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Vano karumeya ule aheesa ntata nawe wanatarani wa Aparahamu nkunya awe ni aholupela upanka. ");
INSERT INTO mgh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Vaavale karumeya ule ahokusa inkamira khumi ca nkunya awe, ni ahokhuma ni mihakhu ca nkunya awe ule mmatatani mwawe, ni ahorwaa uMesapotamiya, iparasa yo Nakoori. ");
INSERT INTO mgh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ni ahokhoromihaca inkamira cawe uta woparasa, vakhiviru ni iluusi, yocoocilo ukati asithiyana unrwaya urika maasi. ");
INSERT INTO mgh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Vano aheera: Mwaneene Nluku, Nluku a nkunya aka Aparahamu, ukivahe ilelo ukumaana wooreera, ni umpanke nnema nkunya aka Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kinawoona va kemeenle waluusi, ni asaana asithiyana a atthu oparasa ela ammweesa urika maasi va. ");
INSERT INTO mgh_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nna va kinoolepelani wiira, mwali nohalaka umwiirela uyo: Wiinamihe mwaapu uyo kiwuryee; ni uyo akiirelaka mmuryeke ni kinavaha maasi inkamira cinyu nnyo; yooyo phimwacileenyu wiira anthele karumeya enyu Isaki, ni mi kinahala ucuwela wiira nhonpanka nnema nkunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Vaavale, hinamaliha uswali, ahowa Repeka, mwana a Petuweli, mwana a Milka, amwaara a Nakori, munnaawe Aparahamu, nakusile mwaapu wanikhatani. ");
INSERT INTO mgh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mwanthiyana ole aari ooreera venci, mwali oohipaca urupa ni nlopwana; ahophiya waluusi nuucariha mwaapu awe nuuturuwa. ");
INSERT INTO mgh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Karumeya awe Aparahamu ahontthimakela nuumwiirela ukivahe maasi aari mmwapuni ayo kiwurye. ");
INSERT INTO mgh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ule ahaakhula: Uwuryeke nkunya. Wowakuvyaca ahorula mwaapu ule nuunvaha mmatatani mwawe wiira awurye. ");
INSERT INTO mgh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Vano namanleene unvaha maasi owurya aheera: Kinarika tho maasi kivahe inkamira caa nnyo wiira ciwurye maasi ootosa. ");
INSERT INTO mgh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wowakuvyacawene aheetthela maasi ale nwuryeryoni monkamira, ni ahorwaa tho uluusi urika maasi mpaka uvaha inkamira cothene. ");
INSERT INTO mgh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nlopwana ole anomaala aweehaka ni awehereryaka wakhala wiira Mwaneene Nluku khaamweettihacile mahala ikwaha awe eyo. ");
INSERT INTO mgh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Wahoolo inkamira nnyo umala waya uwurya, karumeya a Aparahamu ahokumiha ipaara imoca yopirinku cowooru cookhala imaara siita ceelemelelo aya ni ikhankani piili cowooru cookhala imaara iminya wosirini ceelemelelo aya nuunvaha mmatatani mwawe. ");
INSERT INTO mgh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Vano ahonkoha eeraka: We mwana awani? Kinawulepela ukihimyacere. Ni kahiki nihaawo nipuro waathumwana nwo wiira nomake? ");
INSERT INTO mgh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mwanthiyana ole ahaakhula eeraka: Mi ki mwana a Petuweli, mwana awannyawe Milka, yariye ni Nakori. ");
INSERT INTO mgh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ahomwiirela tho: Nihaana malasi, coolya cinci ni nipuro noorupa. ");
INSERT INTO mgh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Vano nlopwana ule ahooroma phinlepelaka Nluku ");
INSERT INTO mgh_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","eeraka: Areerihiye Mwaneene Nluku a nkunya aka Aparahamu, hitamihile nifento neekhweeli wa nkunya aka. Ni Nluku uhokihola mi ikwaha yothene mpaka ukipiha walokwawe nkunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Vaavale mwanthiyana ole ahokhuma atthawaka mpaka waanumwane ni ahottonka yakhumeleenle. ");
INSERT INTO mgh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Repeka ahaana nrokorawe eehaniya Lapanu. Ni Lapanu wiiwa wawe mwaha oyo, wowakuvyaca ahokhuma atthawaka mpaka umphwanya nlopwana ule uluusi. ");
INSERT INTO mgh_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kontha weenre coo: Lapanu wamonnyawe mwanrokorawe nawanre ipirinku ni ikhankani nnye, ni wamwiiwilyawe mwanrokorawe uyo ni weewilyawe moolumu amwanrokorawe ayo eeraka: Coo phikulumacenryawe nlopwana uyo. Vano Lapanu ahonrwela ni ahomphwanya neemenle waluusi ni inkamira cawe nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ni ahomwiirela: Nrwee uwaani we ooreerihiya ni Nluku unhala urupelani vate? Kontha mi uwaani nwo kihotthenkemaniha mapuro oorupa we mpaka inkamira caa nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Vaavale nlopwana ule uphiya wawe uwaanyawe Lapanu, ahovahiya nipuro noorupa, maasi oorapiha inyaa cawe, wamoca na atthu yarinawe, ni inkamira nnye cahoheleliya malasi ni makukhu. ");
INSERT INTO mgh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Vano nawiiheriyeene yoolya, ule aheera: Akinlya mpaka kipacereke uhimyaca itthu yawenlyaka eyo. Lapanu ahomwaakhula eeraka: Wuulumaceke. ");
INSERT INTO mgh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ule phenryawe: Mi ki karumeya a Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mwaneene Nluku honvaha iparakha ciinci nkunya aka, hokhala thaciri, honvaha ikhontwaa ni imope ciinci, ipheeta ni iwooru, haana ipottha cilopwana ni cithiyana, inkamira ni apuuru. ");
INSERT INTO mgh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mpaka Asaara mwaara a nkunya aka, honnyarana mwana nooluvanleene ni citthu cothene honvaha mwana uyo. ");
INSERT INTO mgh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Vano nkunya aka hokilupeliha mi eeraka: Uhinkuse nthiyana Annakanaa ri yeela ilapo inkhalaka ila unvahaka mwanaka wiira anthele, ");
INSERT INTO mgh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nanso urwee uwaani, ilapo yo mayapaapa ni wamucyaka wonwo wanthanle nthiyana nohala unthela mwanaka. ");
INSERT INTO mgh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Phimaana mi kahonkoha nkunya aka, wiira kaahiki nthiyana uyo ahitthuneke ukitthara uno? ");
INSERT INTO mgh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ule ahokaakhula eeraka: Mwaneene Nluku ri ni mi. Uyo naahala wuuvelelihera ncelo owuuhola iphiro wiira wankuse nthiyana o wanrukuluni waka, o wapuwani wa apaapa wiira anthele mwanaka. ");
INSERT INTO mgh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nna unhala wothopwa itthu yurumilyaka weeraka uphiya wamucyaka nwo ukhottiheriyaka uvahiya nthiyana oyo. Paahi uhotopwa itthu yurumilyaka eyo ");
INSERT INTO mgh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Phimaana ilelo uphiya waka uluusi kiholepela kiiraka: Sontte Mwaneene Nluku, Nluku a ankuya aka Aparahamu, wakhalaka wiira ikwaha impankaka ila iri yotthuna winyu nkeettihe ratta. ");
INSERT INTO mgh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nna va kiri waluusi yo maasi, nkiiwe, mwali nohala uwa urika maasi uyo, ni mi kimwiirelaka: Ukivahe maasi kiwurye ommwaapuni mwa ayo; ");
INSERT INTO mgh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ni uyo akiirelaka: Uwuryeke we, ni ciicammo kinahala uvaha maasi inkamira caa nnyo paahi yooyo phi nthiyana mwacilyawe Mwaneene Nluku wiira akhale amwaara a mwana a nkunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Wanowiira kihinamaliha uswali nwo, pha wawe waluusi va Repeka nakusile mwaapu awe wanikhatani ahophiya mpaka waluusi ni ahorika maasi. Vano mi kahomwiirela: Ukivahe maasi kiwurye. ");
INSERT INTO mgh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ule wowakuvyaca aheenamiha mwaapu awe nuukiirela uwuryeke, ni ahovaha uwurya inkamira caka nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Vano kahonkoha wiira we mwana awani? Uyo ahokaakhula eeraka: Mi ki mwana a Petuweli mwana a Nakori nnyanryawe ni Milika. Phimaana kihommwariha ipirinku nnyo, ni ikhankani mmyononi mmo; ");
INSERT INTO mgh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ni kahoromela vathi kinlapelaka nuunsukuru Mwaneene Nluku, Nluku a nkunyaka Aparahamu, kiveleenle iphiro yomaana wiira koonkuse mwana a alokwawe nkunya aka wiira anthele mwanawe. ");
INSERT INTO mgh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nna va munthonyihere ikhweeli nkunya aka, mwatthuna nkihimyacere, ciicammo mwahitthune nkihimyacere wiira mi kicuwele yoweettela. ");
INSERT INTO mgh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Vaavale Lapanu ni Petuweli yahaakhula: Cothene cipankaciye ni Mwaneene Nluku, hi khaninoona yowuhimerya yoonanara atthuna yooreera. ");
INSERT INTO mgh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nna va Repeka uyo phu ula. Unkuseke ni urweke wiira atheliye ni mwana akunya aa, toko cihimilyawe Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Vano karumeya Aparahamu, ahoromela vathi anlapelaka Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ni ahokumiha mihaca copheeta, cowooru ni ikuwo phummahaka Repeka. Ciicammo ahokumiha citthu comaana phummahaka nrokorawe eehaninya Lapanu ni anumwane. ");
INSERT INTO mgh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Wahoolo, ule na alopwana yarinawe ale aholya nuurupa. Usa waya, karumeya Aparahamu aholeeha eeraka kihorwaa wankunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nanso anumwane ni mwanrokorawe Repeka yaheera: Unihiyere mwanthiyana ula mahuku vakani, atthuna mahuku khumi paahi uhoolo nwo naarwaka. ");
INSERT INTO mgh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Vano ule aheerela nhikiporonkanihe. Ikwaha ila Mwaneene Nluku hokireeriha. Nkihiye kituruwele ratta wankunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ale yaheeraca: Nrwee nimwiihane mwanthiyana uyo nankohe. ");
INSERT INTO mgh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Vaavale yahomwiihana Repeka phunkohaka: Unatthuna urwaa ni ula nlopwana ola? Ule ahaakhula eeraka: Kinatthuna. ");
INSERT INTO mgh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Vano amucyawe yahonleeha Repeka wamoca ni nthiyana amwamwihile, karumeya Aparahamu na alopwana yarinawe. ");
INSERT INTO mgh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ni yahonreeriha Repeka amwiirelaka: Mwanrokorihu, wunnuwe ni waayarace asaana iminya iminya cene, ni ucuulu aa uyo waattheme eenani! ");
INSERT INTO mgh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Vaavale Repeka nacikhwawe yahowelaca inkamira, nuntthara karumeya ule. Phimaana karumeya ule ahonkusa Repeka nuurwa. ");
INSERT INTO mgh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Yooyo ukati uyo Isaki aakhuma iphiro yoluusi Ulayi-Royi, kontha akhala ilapo yohitto. ");
INSERT INTO mgh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Nihuku nimoca ukati wococilo, Isaki anaswali mmattani, ahowusa miitho awe ayo ni ahoona inkamira ciwaka. ");
INSERT INTO mgh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ciicammo Repeka, ahowusa miitho awe ayo ahomoona Isaki, ni ahokhuruwa munkamirani, ");
INSERT INTO mgh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ni ahonkoha karumeya ule eeraka: Tipani ule nonisicerya mmattani ule? Karumeya ule ahaakhula: Yoole phi nkunya aka. Wowakuvyaca wene Repeka ahekhunela wiitho nwo nikuwo. ");
INSERT INTO mgh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Wahoolo karumeya uyo ahonttonkela Isaki citthu cothene ceeranele. ");
INSERT INTO mgh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Paahi, Isaki ahonkusa Repeka mpaka nheemani mwa anumwane yeehaniya Asaara, ahonthela nuunfenta. Phimaana Isaki ahomaalihiya ni Repeka, ukhwa waya anumwane. ");
INSERT INTO mgh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aparahamu ahonthela nthiyana nkina, eehaninya Ketura. ");
INSERT INTO mgh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura ahonnyarana Aparahamu ala asaana ala: Sinra, Yookisa, Meeta, Miitiya, Isipaki, ni Suwaa. ");
INSERT INTO mgh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yookisa ahonnyara Sapaa ni Tetaa. Ucuulu wa Tetaa waari Asurita, Letusi ni Lewuma. ");
INSERT INTO mgh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Asaanawe Miitiya yari Efa, Eferi, Enoki, Apita ni Elita. Othene ale yaari ucuulu wa Ketura. ");
INSERT INTO mgh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aparahamu ahonhiyera Isaki mihakhu cawe cothene. ");
INSERT INTO mgh_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Nanso asaana a Aparahamu yayanryawe na asaarawe oohitteeliheraninya, aavahacile itthuvo vakani; nari nkumi, ahamwalaaniha ni mwanawe Isaki nuwarweha uttayi, ilapo iri mphantte unkhuma ncuwa. ");
INSERT INTO mgh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aparahamu ahokhalana ukumi mpaka ahopiiha myakha iminya wo sapini na thanu (175) ceyarelo. ");
INSERT INTO mgh_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Aakhwile noluvaleehile ni myakha cinci ceyarelo ni ahaatthara mayathumwane. ");
INSERT INTO mgh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nanso, asaana a Aparahamu, Isaki ni Sumayili, yahaavithaca athumwanaya nnikhukuni no Makipela, vakhiviru ni uManree, nthala na Eforomi, mwana a Suwari, nHitita, ");
INSERT INTO mgh_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","nenne nthala, Aparahamu nathumanannyawe maHitita. Vaavale phivithiyawe Aparahamu wamoca ni Asaara amwaarawe. ");
INSERT INTO mgh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Nanso nakhwileene Aparahamu, Nluku ahonreeriha Isaki. Vano Isaki aakhala vakhiviru ni Iluusi yo Lahayi-Royi. ");
INSERT INTO mgh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Vano ula phu ucuulu wa Sumayili, mwana annyanryawe Aparahamu ni Akaari o Wiciipitu, ipottha ya Asaara. ");
INSERT INTO mgh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ala phi macina a asaana a Sumayili, yantikhaciye ittharihiyaka eyareelo aya: Nepawoti, mwana omuulupale a Sumayili, Ketari, Apeteli, Mipisamu, ");
INSERT INTO mgh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Tumaa, Masaa, ");
INSERT INTO mgh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hattatti, Temaa, Yeturi, Nafisi ni Ketemaa. ");
INSERT INTO mgh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ala phaari asaana a Sumayili, yakhalacile ahooleli o mahimo, mmawaani mwaya ni mmapuroni mwamakiya yeehaneliya yaala macina ala. Ahooleli ayo yaari khumi nuuwa eeli. ");
INSERT INTO mgh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumayili ahokhala myakha iminya wo talathiini na saapa (137) ceyarelo. Ahokhwa ni watthara mayathumwane okhalayi. ");
INSERT INTO mgh_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ucuulu awe wahokhala nttetthe unkhuma o Havila urwaka o Suuri, vakhiviru ni mwiinano wo Wiciipitu, mphantte unrwaa o Siiriya. Ni yaheeserana mpika na asunnaya. ");
INSERT INTO mgh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ala phi mayaranacelo o nrukulu na Isaki, mwana Aparahamu: Aparahamu ahonnyara Isaki. ");
INSERT INTO mgh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaki narina myakha arupayini ceyarelo, ahonthela Repeka, mwana a Petuweli, Nramewu o Patan-Aramu, aari mwanrokorawe Lapanu, ni uyo ciicammo Nramewu. ");
INSERT INTO mgh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Vano Isaki ahonlepela Nluku, kontha amwaarawe ayo yari mwali eekupa. Phimaana Mwaneene Nluku ahaakhula iswali cawe nnyo ni Repeka ahorupala irukulu. ");
INSERT INTO mgh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Urupala wawe, asaana ayo munthukwani mmo yaanawaanaca, ni Repeka aheera: Nlattuni ikikhumelelaka ila itthu ila? Ni ahorwaa unkoha Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Vano Mwaneene Nluku ahomwaakhula: Ilapo piili phiriwo munthuukwani mwaa mmo, phimaana anakhuma mommo atthu eeli ni anaahala umwalana: Mmoca uyo nokookhala okuru oompwaha nkhwawe, nanso omuulupale uyo naahala unvarela nteko omwankani uyo. ");
INSERT INTO mgh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Vaavale, waphiilyaya ukati wooyara, khweeli ahorumelelihiya wiira yaari mavatta munthukwani mwawe mmwe. ");
INSERT INTO mgh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Oopacera uyariya uyo aari okharari cookhwiila, ni irutthu awe yothene yaari yo mapururu; phimaana ahovahiya ncina na Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wahoolo ahoyarya mwanhimaawe, ntata nawe naavarenle ikottokottho ya Isawu; phimaana ahovahiya ncina na Yakopi. Ukati waayarawe Repeka, Isaki aarina myakha sitiini ceyarelo. ");
INSERT INTO mgh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Asaana ale yahonuwaca. Isawu aari nlupa oocuwela utotha ni aari nantakhwani. Nanso Yakopi waari nteko awe paahi uhakhela imope ni aakhala mmaheemani. ");
INSERT INTO mgh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaki anfenta Isawu, kontha cancivela ukhura inama ceevawe; ni ciicammo Repeka anfenta Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nanso ikwaha imoca, Yakopi aapyaacaka yoolya, ahowa Isawu navoliye itala, akhumaka utakhwani, ");
INSERT INTO mgh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ni ahommekela eeraka: Ukimeele vakani nhuci woserya uyo. Ukivola itala! Phimaana eehaninyaka ciicammo Eetomu. ");
INSERT INTO mgh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Vano Yakopi ahomwaakhula eeraka: Woopacera ukitumihereke iyuulupale aa. ");
INSERT INTO mgh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Vaavale Isawu aheera: Nna vaa kihanle vakani ukhwa. Kimphurela isiyani iyuulupale eyo? ");
INSERT INTO mgh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Wahoolo Yakopi ahonkhanyereriha Isawu eeraka: Woopacera unlamuliya ulupela. Ni ule aholupela untumihera Yakopi iyuulupale eyo. ");
INSERT INTO mgh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Vano Yakopi ahonvaha Isawu isima ni maruru. Ule aholya nuwurerya, ahonwa nurwaa. Commo Isawu ahovyavyeeha iyuulupale awe. ");
INSERT INTO mgh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Yahovola itala yeele ilapo ele, toko weracilyaya ukati wa Aparahamu. Phimaana Isaki ahorwaa ilapo yo Kerari, wonwo Apimeleke waaryawe mwene o mafilisitiya. ");
INSERT INTO mgh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Vano Mwaneene Nluku ahomphwanya Isaki ni ahomwiirela: Uhikhuruwele Wiciipitu. Urwee wakhale ilapo inhalaka wuthoonyera. ");
INSERT INTO mgh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ukhale ila ilapo ela, mi kinaakhala ni we ni kinawureeriha. Kontha we nuucuulu aa uyo kinaahala wuuvahani ila ilapo ela, ni kinarwa uttharihelela yolumacenryaka athumwaninyu aneehaniya Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kinaahala wuncerera ucuulu aa toko itthoottwa co wirimu ni waavaha nnya ilapo nnya cothene; ni nhina wo ucuulu aa atthu othene omwiilaponi anaahala ureerihiya, ");
INSERT INTO mgh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","kontha Aparahamu hosunka malamulo aka inrumilyaka ni isariya caka. ");
INSERT INTO mgh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Commo Isaki ahokhala o Kerari. ");
INSERT INTO mgh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Vano alopwana o nenno nipuro nno ukati waankohilyaya wiira ala phamwaaraa, ule ahaakhula eeraka: Mwanrokoraka. Anawoova uhimyaca wiira amwaaraka, kontha oopuwela wiira, alopwana o yeela ilapo ela anaahala ukiiva nlattu wa Repeka, kontha ahotepa ooreera. ");
INSERT INTO mgh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaki ahokhala o Kerari ukati mwinci. Nihuku nimoca, Apimeleke, mwene o mafilisitiya, anawehecesa wacanelani yaari uculu, phuukati wamonnyawe Isaki anthwelanaka Repeka amwaarawe. ");
INSERT INTO mgh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Vano Apimeleke ahomwiihana Isaki ni ahomwiirela: Khweeli, uhirune. Ale amwaaraa. Vano weerelani mwanrokoraka? Isaki ahaakhula eeraka: Kontha kineenre amwaaraka kanawoova wiiviya. ");
INSERT INTO mgh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Apimeleke aheera: Unipankenleni commo? Kontha nlopwana phi nlopwana uyo aanawaarupana amwaaraa ayo, ni wananiwiihera ikoosi. ");
INSERT INTO mgh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Vaavale Apimeleke ahaahimyacera atthu othene eeraka: Ntthu nohala umwiiriha itthu ula nlopwana ula atthuna amwaarawe ala, naahala ukhwa! ");
INSERT INTO mgh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Vano Isaki ahotthimpula imatta ni yooyo mwakha uyo ahoruwerya venci, kontha Mwaneene Nluku ahonreeriha. ");
INSERT INTO mgh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ule ahothaciri ni nhakhu awe wahoncererya mpaka ahothacireeha. ");
INSERT INTO mgh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ahaana ikhontwaa ni imope cinci ni ipottha cinci mpaka mafilisitiya upacera unrama. ");
INSERT INTO mgh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Phimaana, mafilistiya yahotthunttuwanihaca nuuwuhelelaca iluusi cothene cathipiye ni ipottha ukati wa Aparahamu, athumwane Isaki. ");
INSERT INTO mgh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Vano Apimeleke ahomwiirela Isaki: Ukhume mwilaponi mwihu mu, kontha uri ntthu oonhakhu cinenne woonipwaha hi. ");
INSERT INTO mgh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Phimaana Isaki ahokhuma nuthamela wuuthakoni wo Kerari waakhalawe khalayi. ");
INSERT INTO mgh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Wahoolo Isaki ahowuhulaca iluusi caathipiye ukati wathumwane. Nnye cawuhelelaciye ni mafilisitiya ukhwa wawe Aparahamu ni ahovaha macina yavahilyaya athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Vano ipottha ca Isaki cahothipaca muuthakoni mmwe ni cahottenla maasi menci oociva. ");
INSERT INTO mgh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Vano ahakheli o Kerari yahonyakulihana na ahakheli a Isaki, yiirelanaka: Maasi ala awihu! Phimaana Isaki ahovaha iluusi ile ncina na Eseke, nlattu woonyakuliheraninya. ");
INSERT INTO mgh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Vano ipottha nnye cahothipaca iluusi ikina, ni ile yahonyakuliheraniya. Phimaana aheehana Sitina. ");
INSERT INTO mgh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Wahoolo Isaki ahothama nne nipuro nne ni ahothipa iluusi ikina ni khayanyakuliheraniye tho. Phimaana ahovaha ncina na Riyopoti, eeraka: Vano Mwaneene Nluku honihulela ikhato ninaahala wiithawala yeela ilapo ela. ");
INSERT INTO mgh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ukhuma vaavale Isaki ahorwaa o Peresepa. ");
INSERT INTO mgh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yoole uhiyu ule, Mwaneene Nluku ahomphwanya ni ahomwiirela: Mi kiri Nluku a Aparahamu athumwanaa. Uhoove, kontha kiri ni we. Mi kinaahala wureeriha ni wuncerera ucuulu aa mwanlattu woofenta karumeya aka Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaki ahoteka ikhilompi ni aholapela ncina na Mwaneene Nluku. Vaavale ahomaka ni ipottha cawe yahothipaca iluusi ikina. ");
INSERT INTO mgh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yoole ukati ule, Apimeleki ahowa akhumaka o Kerari wamoca ni Awusate nlakakano awe ni Fikoli, muulupale aanakhotto awe. ");
INSERT INTO mgh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Vaavale Isaki ahaakohaca eeraka: Nlattuni mmwaaka ukiweha, mi mwahokipanka mwiinani ni mwahokoomola? ");
INSERT INTO mgh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ale yahomwaakhulaca yiiracaka: Kontha nihowoona weekhweeli wiira Mwaneene Nluku ri ni we, phimaana niiraka: Nrwee nilupelace we ni hi. Nimphavela waatana ni we. ");
INSERT INTO mgh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","We uhinipanke yoonanara, toko hi cihupankileehu itthu, nanso nihoopanka ratta ni wuleeha wo mpuha. Vano nihocuwela wiira Mwaneene Nluku hooreeriha. ");
INSERT INTO mgh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Vano Isaki ahaavahaca yoolya ni ale yaholyaca nuuwuryaca. ");
INSERT INTO mgh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Usa waya oyeeli yaholupelihana. Isaki ahaalehaca ni ale yahorwaca ni mpuha. ");
INSERT INTO mgh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nenno nihuku nno ipottha ca Isaki cahowaaca unhimerya ciiraka: Iluusi yathipehu iyo nihottenla maasi! ");
INSERT INTO mgh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaki ahovaha iluusi ile ncina na Sepa, phimaana mpaka nihuku nolelo, ile iparasa ile icuweliyaka ncina no Peresepa. ");
INSERT INTO mgh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isawu naphihenrene myakha arupayini ceyarelo ahonthela Yutiti, mwana a Peeri, nhitita, ni ciicammo ahonthela Pasimati, mwana a Elomi, nhitita. ");
INSERT INTO mgh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ale asithiyana ale yahaacukulihaca Isaki ni Repeka. ");
INSERT INTO mgh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ukati wooluvanlyawe Isaki wiitho wawe wahonripela ni khoona. Vano ahomwiihana mwanawe omuulupale eehaniya Isawu, eeraka: Mwanaka. Ni ule ahomwaakhula eeraka: Kiri va. ");
INSERT INTO mgh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ule ahomwiirela: Mi kihooluvala ni akincuwela nihuku ninkhwaka. ");
INSERT INTO mgh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nna va, ukuse myuupa, muura ni nivaka naa nno, urwee utakhwani wakaaverye inama. ");
INSERT INTO mgh_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Vano waakaapyele sankanya ookicivela ni ukiwiihere kaanlye wiira kuuvahe iparakha kihinakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ukati woolumacawe Isaki anhimeryaka mwanawe Isawu, moolumo ale Repeka eera eewaka. Vano Isawu ahorwaa utakhwani wiiva inama wiira aawiihere athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Phimaana Repeka ahonhimerya mwanawe eehaninya Yakopi eeraka: Kiheewa athumwana ayo amwiirelaka munnaa Isawu: ");
INSERT INTO mgh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Wakilupatthele inama ni wakaapyeele sankanya oociva wiira kinlye ni kuuvahe iparakha wamiithoni wa Mwaneene Nluku kihinakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Nna vaa mwanaka, uviriyane inoohimeryaka ila. ");
INSERT INTO mgh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Urwee muncicini mmo wakuse ipuri piili. Mi kinnowaapyela sankanya oociva toko athumwana cinaacivelaya, ");
INSERT INTO mgh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ni waarwehele athumwana yanlye wiira yuvahe iparakha ahinakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Nanso Yakopi aheerela anumwane: Kinawoona amunna Isawu irutthu aya iyo iri yo mapururu. Mi kiri oohimapururu. ");
INSERT INTO mgh_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pooti apaapa ayo ankokapaapela ni wamiithoni waya kinkokhala mayowootha. Commo kinawiiwaanela mahusi woohikhala iparakha. ");
INSERT INTO mgh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Anumwane yahomwiirela: Mwanaka, nihusi naa nno ninhala ukhala nawaka. Wiiwelele paahi nuulumo naka. Urwele ni ukiwaanele. ");
INSERT INTO mgh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Vano ule ahorwela ni waawiihera anumwane, ni ale yahomwaapyela sankanya oociva, toko athumwane caacivelaya. ");
INSERT INTO mgh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Wahoolo, Repeka ahokusa coowara comaana ca Isawu, mwana omuulupale, carinawe uwaani ni ahommwariha Yakopi, mwana omwankani. ");
INSERT INTO mgh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Vano ahommwariha nrapala nopuri nsiko ni mmatatani, ");
INSERT INTO mgh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ni ahonvaha mmatatani mwa Yakopi, mwana omwankani, sankanya oociva ni nkatthe watthenkacilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Vano Yakopi ahorwaa woolumana athumwane ni aheerela: Paapa! Athumwane yahomwaakhula yiiraka: Kiri va. We tupani mwanaka? ");
INSERT INTO mgh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakopi ahaakhula athumwane eeraka: Mi Isawu mwaninyu oontthaara. Kihopanka toko caakirenlenyu. Vano, munkome ni nlye ilupatthilyaka wiira nkireerihe. ");
INSERT INTO mgh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaki ahonkoha mwanawe eeraka: Weeraceele cani wakuvaka ulupattha? Ule ahaakhula: Mwaneene Nluku, Nluku inyu ahokaakuvyehera umphwanya mwannama. ");
INSERT INTO mgh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Vaavale Isaki ahomwiirela Yakopi: Mwanaka, ukaattamerye wiira kiwaapaapele ni kuucuwelele wakhala wiira we khweeli mwanaka Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakopi ahaattamerya athumwane ni ale yahomwapapela ni yaheera: Ncu nno na Yakopi nanso myoono nnyo ca Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaki khaancuwelenle Yakopi kontha myoono cawe caari co mapururu toko ca Isawu munnaawe, phimaana ahonreeriha. ");
INSERT INTO mgh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wahoolo Isaki ahonkoha tho eeraka: We khweeli mwanaka Isawu? Ni ule ahaakhula eeraka: Phi yeemi. ");
INSERT INTO mgh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Vaavale Isaki ahomwiirela: Mwanaka, ukiwiihere ilupatthilyaa eyo wiira kilye ni kuureerihe. Yakopi ahaawiihera ni athumwane yaholya, ni ciicammo ahaawiihera ivinyu ni ale yahowurya. ");
INSERT INTO mgh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Vano Isaki ahomwiirela Yakopi: Nkaawe woono mwanaka ni ukivahe alaahuma. ");
INSERT INTO mgh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ule ahaattamerya ni ahaavaha alaahuma. Ukati wonnyawe ikuwo cawe nnyo nhiriri wonama, Isaki ahonreeriha eeraka: Nhiriri wa mwanaka uri toko inukhelelo yotakhwa ireerihilyawe Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nluku oovahe ukame wo wirimu, uruwerye vathi va, itiriku yinci ni malaaso menci. ");
INSERT INTO mgh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Wiira atthu othene waarume, ni ilapo cuulemelihe, ni ukhale nkunya a asihimaa, na asaana a anumwane yuulemelihe we, natakhaliya ule nohala wuulapha, ni nareeriya ule nohala wureeriha. ");
INSERT INTO mgh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaki umaliha wawe unreeriha Yakopi ni nakhumileene wamiithoni wa athumwane, phawawe Isawu akhumaka wulupatthani. ");
INSERT INTO mgh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ni ule ahomwaapya sankanya oociva ni ahaawiihera athumwane ni aheerela: Paapa, munnwe ni nkhuureke inama ilupatthilyaka wiira nkireerihe. ");
INSERT INTO mgh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Vano athumwane yahonkoha yiiraka: We tupani? Ule ahaakhula: Mi Isawu, mwaninyu oontthara. ");
INSERT INTO mgh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Vaavale Isaki ahothukumela venci cinenne ni aheera: Tupani ule kiwiihenre inama yoolupatthiya? Mi kihokhuura yothene we uhinaya uwa. Yooyo ntthu uyo, mi kihonvaha iparakha ni ciicammo nakhala ooreerihiya. ");
INSERT INTO mgh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Vano Isawu weewilyawe moolumo athumwane ale, ahothulana ni unlaka ahokhuwa wowirunya eerelaka athumwane: Nkireerihe ni mi, paapa. ");
INSERT INTO mgh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaki ahomwaakhula phimwiirelaka: Mwanhimaa ahowa va mmirukuni, ni hokusa iparakha caa nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Vaavale Isawu ahopwaherera eeraka: Khweeli ule uhomphwanela wavahiyawe ncina na Yakopi, kontha imaara piili nnya akithepyaka. Woopacera hokaakha iyuulupale aka, nna va hokaakha iparakha caka. Vano Isawu aheera tho: Khankihalihenre tho mi iparakha? ");
INSERT INTO mgh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Vano Isaki ahomwaakhula Isawu eeraka: Kinawoona kihompanka ukhala owulamula we, ni asunnaa ayo othene kihonvaha ukhala ananrumiya awe; mpaka itiriku ni malaaso kihomuncerera. Vano we mwanaka kiwiiriheke cani? ");
INSERT INTO mgh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Vano Isawu aheerela athumwane: Nrina iparakha imoca paahi? Paapa, nkireerihe ni mi ciicammo. Vaavale Isawu ahokhuwa ni wunla. ");
INSERT INTO mgh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Vano Isaki, athumwane, yahomwaakhula yiiraka: We unkookhala uttayi ni mapuro oocayira ni oohikhuruwa ukame. ");
INSERT INTO mgh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Malelyo aa ankokhala okhotto, ni unhala ukhala nanrumiya a nhimaa. Nanso we wooryaka wiicopola phinhalaa urula nipisi niri nsiko mwaa mmo. ");
INSERT INTO mgh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Vano Isawu ahoncukula Yakopi mwanlattu womwakha iparakha yavahiyawe na athumwane. Phimaana ahoopuwela wanrimani wawe eeraka: Anaphiya mahuku ookhwa apaapa. Kimwomwiiva nhimaka Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Vano Repeka ahohimerya yalakenlyawe Isawu, mwana omuulupale, ahomwiihana Yakopi mwanawe omwankani, phimwiirelaka: Munnaa Isawu neepisiha nrima ni hoolakela uwiiva. ");
INSERT INTO mgh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nna vaa, mwanaka, wiiwe inhalaka wuuhimerya: Wunwe ni urwee wamwanrokoraka Lapanu, ilapo yo Harani, ");
INSERT INTO mgh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","wakhale wonwo mahuku vakani, mpaka uvire uviruwa wa munnaa, ");
INSERT INTO mgh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","mpaka uvire urusiya wa munnaa, ni aliyale itthu impankilyaa. Mi kinaahala uleehera ni wuhokolosiha. Isiyani inhalaka wuhalelacerani oyeeli nihuku nimoca? ");
INSERT INTO mgh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Phimaana Repeka ahomwiirela Isaki coo: Ahokitosa asaana a Heeti, kontha Yakopi aathelaka athiyana o yeela ilapo ela, mi phatari kikhwe. ");
INSERT INTO mgh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Vano Isaki ahomwiihana Yakopi, ahonreeriha nunhimerya eeraka: Uhaathele athiyana o Nkanani mu. ");
INSERT INTO mgh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ukhume ni urwee uPatan-Aramu, wa Petuweli, athumwanaya anumwana ni wanthele mwana a Lapanu, mwanrokoraya anumwana. ");
INSERT INTO mgh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ni Nluku Okuru Cothene ureerihe, upanke mayoyara ni awuncereryanihe wiira nkhale atthu enci, ");
INSERT INTO mgh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ni uvahe iparakha ca Aparahamu, we ni ucuulu aa uyo, wiira uhalane ilapo iryaa nletto, Nluku invahilyawe Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Phimaana Isaki ahonveleeliha Yakopi ilapo yo Patan-Aramu, wa Lapanu, mwana a Petuweli Nramewu, mwanrokorawe Repeka, anumwane Yakopi ni Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Vano Isawu woonyawe wiira Isaki honreeriha Yakopi ni honveleeliha uPatan-Aramu wiira anthele nthiyana wonwo ni waanreerihawe va ahomwiirela: Uhaathele athiyana o Nkanani mu. ");
INSERT INTO mgh_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakopi aheewelela athumwane na anumwane ni ahorwaa uPatan-Aramu. ");
INSERT INTO mgh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isawu woonyawe athumwane wiira khayatteeliye nrima na athiyana o Nkanaa, ");
INSERT INTO mgh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ule ahorwaa wa Sumayili ni ahonthela nthiyana, eehaninya Malati, mwana a Sumayili, mwana a Aparahamu, mwanrokorawe Nepakoti, woohatakanihera athiyana yarinawe akina. ");
INSERT INTO mgh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yooyo ukati uyo Yakopi ahokhuma uPerisepa arwaka uHarani ");
INSERT INTO mgh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ni ahophiya nipuro narupilyawe kontha waheela. Nenno nipuro nno ahokusa nluku nimoca, aheesa wiimuru ni aheecatalela. ");
INSERT INTO mgh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Vano aholoha nttora woonyawe makwantta aneemesiye vathi mpaka ukwanya irimu ni phoonawe ancelo a Nluku awelaka ni akhuruwaka makwantta ayo. ");
INSERT INTO mgh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mwaneene Nluku phaari uculu waya makwantta ni aheera: Mi kiri Mwaneene Nluku, Nluku a Aparahamu, athumwana, ni Nluku a Isaki; yeela ilapo irupilyaa ila kinawuvaha we ni ucuulu aa uyo. ");
INSERT INTO mgh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ucuulu aa unhala ukhala toko ntthupi no vathi, ni unhala umwaryeela urwaka unkhuma ncuwa mpaka unkela ncuwa, urwaka uculu mpaka uhitto, ni mwanlattu wawaa we ni ucuulu aa uyo, unkophwanya iparakha uneethi wothene wo mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Phi mi kiri ni we. Kinawusunka mapuro othene ankela uvira, kinawuturusela tho ila ilapo ela, kontha akinhala wuuhiya mpaka kipankeke itthu yukhuluvelihilyaka. ");
INSERT INTO mgh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Vano Yakopi wunwa wawe nkhoveni aheera: Khweeli Mwaneene Nluku ri nna nipuro nna. Mi akaacuwela. ");
INSERT INTO mgh_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ni uvaka aheera: Wopihilyaya nna nipuro nna! Nna khaninakhala nipuro nikina; iri inupa ya Nluku. Ula nkhora wo wirimu. ");
INSERT INTO mgh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Paahi, Yakopi ahonwa wicisuru, ahokusa nluku neesilyawe wiimuru nne, aheemesa, ni ahomiinela makhura waculu waya va. ");
INSERT INTO mgh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Phimaana ahovaha ncina nenno nipuro nno Peteli, nanso yeeyo iparasa eyo ncina naya nokhalayi neehaniya Luusi. ");
INSERT INTO mgh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ni Yakopi ahomoopa natiri eeraka: Nluku akhalaka ni mi ni akisunkaka ila ikwaha ila, akivahaka yoolya, ni ikuwo coowara, ");
INSERT INTO mgh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ni kituruwelaka wosalama uwaani wa apaapa, Mwaneene Nluku nahala ukhala Nluku aka. ");
INSERT INTO mgh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ni nenna nluku neemesilyaka nna ninwa ukhala inupa ya Nluku ni cothene cinhalaa ukivaha, khweeli kinawuvaha mphantte wonakhumi. ");
INSERT INTO mgh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Vaavale Yakopi ahokhuma arwaka ilapo iri mphantte unkhuma ncuwa. ");
INSERT INTO mgh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Nanaanoru ahoona iluusi mmathalani ni mihuwo miraru cokhontwaa cinarupile nceresere mmo, kontha yeeyo iluusi iyo phawuryaya ikhontwaa nnyo. Nahaawo nluku nuulupale nakhuneliya iluusi iyo. ");
INSERT INTO mgh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Nenne nipuro nne canthukumana mihuwo, ahakheli yantamiha nluku nakhuneliya iluusi iyo nuurika maasi wiira avahe mihuwo caya nuukhunela tho iluusi iyo. ");
INSERT INTO mgh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Vano Yakopi ahaakohaca eeraka: Asunnnaka nnokhumaca vayi? Ni ale yahaakhulaca yiiraka: Ninkhuma uHarani. ");
INSERT INTO mgh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ni uyo aheerelaca: Nnancuwela Lapanu, mwana a Nahori? Nale yahaakhulaca yiiraka: Ninancuwela. ");
INSERT INTO mgh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ahaakohaca tho eeraka: Haawo nkumi? Ni ale yahomwaakhulaca: Haawo nkumi, ni mwanawe mwanthiyana neehaniya Rakeli phuula wiihile nnya ikhontwaa nnya. ");
INSERT INTO mgh_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ule aheera tho: Nanlelo uthana, khunaphiya ukati wothukumaniha ikhontwaa nnyo. Nvahe maasi ciwurye ni nvira nliha. ");
INSERT INTO mgh_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Vano ale yaheeraca coo: Khaninoorya, mpaka cithukumanihiyeke ikhontwaa cothene ni nluku nikhuneeliye iluusi iyo nitamihiye wiira nivahe ratta maasi oowurya. ");
INSERT INTO mgh_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Nanlelo oolumacaka nale, ahowa Rakeli ni ikhontwaa ca athumwane kontha uyo aari nhakheli. ");
INSERT INTO mgh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ni waakhumelenle coo, Yakopi umoona wawe Rakeli mwana a Lapanu arokoraya anumwane, ni ikhontwaa ca Lapanu, Yakopi ahorwaa walusi ni ahotamiha nluku nakhuneleliye nuuvaha uwurya ikhontwaa ca Lapanu, mwanrokoraya anumwane. ");
INSERT INTO mgh_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Vaavale Yakopi ahonsalameeha Rakeli, mpaka upacera wunla. ");
INSERT INTO mgh_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakopi ahonhimerya Rakeli wiira ule mwamunnaya athumwane ni ari mwana a Repeka. Vano Rakeli ahokhuma atthawaka urwaa wahimyacera athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ukati weewilyawe Lapanu ihapari ca Yakopi, mwana a mwanrokorawe, ahomwiikamela nuunkapatta nuunsalameeha mpaka umpiiha uwaanyawe, ni ule ahonttonkacera Lapanu citthu cothene caankhumelenle munkwahani mwawe. ");
INSERT INTO mgh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Vano Lapanu ahomwiirela: Khweeli we uri nikhuva ni irutthu aka. Ni ahokhala ni ule mweeri mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Wahoolo Lapanu ahomwiirela Yakopi: Kamana we uri nhimaaka unaakivarela nteko wo mahala? Ukihimerye ihisapu yowuliva. ");
INSERT INTO mgh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lapanu ahaana asaana eeli asithiyana. Omuulupale uyo ncina nawe Leya ni omwankani uyo ncina nawe Rakeli. ");
INSERT INTO mgh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Vano Leya arina miitho oolocwaca nanso Rakeli arina irutthu yooreera ni ikhove yomaana. ");
INSERT INTO mgh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ni Yakopi anancivela venci Rakeli ni aheera: Kinaawuvarela nteko myakha saapa nlattu wa Rakeli, mwanaa oomwankani. ");
INSERT INTO mgh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Vano Lapanu ahaakhula eeraka: Wanaareera wuvaha we woohikhala wumvaha nlopwana nkina. Ukhale va ni mi. ");
INSERT INTO mgh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yakopi ahovara nteko myakha saapa amphavelaka Rakeli, cenyo myakha nnyo oonne ukhala mahuku vakani kontha anancivela cineene. ");
INSERT INTO mgh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Wahoolo Yakopi ahomwiirela Lapanu: Ukivahe amwaaraka, kontha kihomalihera mahuku aka ayo ni kimphavela waathela. ");
INSERT INTO mgh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Vano Lapanu ahaathukumaniha alopwana othene o yoole nttetthe ole ni ahopanka isikuhuulu. ");
INSERT INTO mgh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Vaavale uhiyu, Lapanu ahonkusa Leya ni ahommwiihera Yakopi. Ni ahonthukumanana. ");
INSERT INTO mgh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Vano Lapanu ahokumiha ipottha awe yeehaniya Silipa ni ahonvaha mwanawe wiira arumeke. ");
INSERT INTO mgh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nanso usa waya amoone Leya. Vano Yakopi ahomwiirela Lapanu: We ukipankile cani? Mi akivanre nteko kimphavelaka Rakeli? Nlattuni we ukithepyacaka? ");
INSERT INTO mgh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lapanu ahaakhula: Uno khinakhalaka ilemalelo upacera utheliya mwana omwankani, omuulupale hinaya utheliya. ");
INSERT INTO mgh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Vano uhiye umala isumana ithenlyaa ila, ninaahala wuuvaha tho omwankani uyo, nanso uvareke tho nteko myakha saapa. ");
INSERT INTO mgh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Vaavale Yakopi ahokupali. Yahovira isumana yanthenlyawe Leya ni Lapanu ahonvaha Rakeli ukhala amwaarawe. ");
INSERT INTO mgh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lapanu ahonvaha Rakeli ipottha awe yeehaninya Piila wiira arumeke. ");
INSERT INTO mgh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakopi ahonthukumanana Rakeli. Yoole aancivenle wompwaha Leya ni ahonvarela nteko Lapanu myakha saapa. ");
INSERT INTO mgh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ukati woonnyawe Mwaneene Nluku wiira Leya anavyavyehiya, ahonvaha asaana, nanso Rakeli ari mwali eekupa. ");
INSERT INTO mgh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya ahorupala irukulu, ni ahonnyara mwana ni ahonvaha ncina na Rupeni, kontha eera: Mwaneene Nluku hoona icuku caka. Vano, weekhweeli awannyaka anaahala ukifenta. ");
INSERT INTO mgh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya ahorupala tho irukulu, ni unnyara wawe mwana nkina aheera: Kontha Mwaneene Nluku heewa wiira kinavyavyehiya, hokivaha tho ula, ni yahonvaha ncina na Simeyoni. ");
INSERT INTO mgh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ahorupala tho irukulu ikina ni wannyanryawe mwana, aheera: Paahi, awannyaka anaahala waatana ni mi, kontha kihaayarana asaana araru. Phimaana yahonvaha ncina na Levi. ");
INSERT INTO mgh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ahorupala tho irukulu ni unnyara wawe mwana aheera: Ula nkwaha ola kinamunnuwiha Mwaneene Nluku. Commo yahonvaha ncina na Yutta. Ni ahohiya uyara. ");
INSERT INTO mgh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Vano ukati woonnyawe Rakeli wiira khannyaranne asaana Yakopi, ahopacera unrama munnaawe ni ahomwiirela Yakopi: Ukiyarane asaana, atthuna phatari kikhwe. ");
INSERT INTO mgh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakopi ahorusiya ni Rakeli ni aheera: Kinokhala Nluku, watelihile uyara? ");
INSERT INTO mgh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Vano ule ahaakhula: Haawo Piila ula, ipottha aka, unthukumananeke wiira aayare asaana toko waahalaka waayara mi, wiira nhina mwa yaayo kaakhalane asaana. ");
INSERT INTO mgh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Phimaana ule ahonvaha Yakopi uthela ipottha awe yeehaninya Piila, ni ahonthukumanana. ");
INSERT INTO mgh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Piila ahorupala irukulu ni ahonnyarana Yakopi mwana. ");
INSERT INTO mgh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Vano Rakeli aheera: Nluku hooluma, heewa ncu naka ni hokivaha mwana. Phimaana ahonvaha ncina na Tani. ");
INSERT INTO mgh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Piila, ipottha ya Rakeli, ahorupala tho irukulu ni ahonnyarana Yakopi mwana onayeeli. ");
INSERT INTO mgh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Vaavale Rakeli aheera: Kaari ni ikhotto yuulupale ni munnaka ni kihotthema. Phimaana ahonvaha ncina na Nafitalii. ");
INSERT INTO mgh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ukati woonnyawe Leya wiira hohiya uyara, ahonkusa Siilipa ipottha awe ni ahonvaha uthela Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Siilipa, ipottha ya Leya, ahoyarana Yakopi mwana mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Vano Leya aheera: Ila iparakha! Phimaana ahomwiihana Kaate. ");
INSERT INTO mgh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Wahoolo, Siilipa, ipottha ya Leya ahonnyarana tho Yakopi mwana onayeeli. ");
INSERT INTO mgh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Vano Leya aheera: Kihotteeliya! Athiyana ayo ankokiirela kiri ootteeliya, ni aahonvaha ncina na Aseri. ");
INSERT INTO mgh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ukati woohephiya itiriku, Rupeni ahorwaa umattani ni ahophwanya mirette cooyariha ni ahaawiihera anumwane. Vano Rakeli ahomwiirela Leya: Ukivahe mirette cooyariha ca mwanaa nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nanso ule ahomwaakhula: Khawutosile wakaakhilyaa alopwana ayo? Umphavela ukaakha tho mirette ciwiihilyawe mwanaka nnyo? Vano Rakeli ahaakhula: Ula uhiyu ula Yakopi naahala wuthukumanana. Naakakhanihaka ni mirette ciwiihilyawe mwanaa nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ucoocilo, ukati waturuwilyawe Yakopi umattani, Leya ahomwiikamela numwiirela: Ilelo we unaahala ukithukumanana, kontha kihowuthumani ni mirette ca mwanaka. Ni yoole uhiyu ule ahonthukumanana. ");
INSERT INTO mgh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nluku ahomwiiwa Leya. Ule ahorupala irukulu ni ahonnyarana Yakopi mwana oneethanu. ");
INSERT INTO mgh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Vano Leya aheera: Nluku hokiliva wammahilyaka ipottha aka waathukumanana awannyaka. Phimaana ahonvaha ncina na Isakari. ");
INSERT INTO mgh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya ahorupala tho irukulu ni ahonnyarana Yakopi mwana onasiita. ");
INSERT INTO mgh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya aheera: Nluku hokitthuva itthuvo yomaana. Ula nkwaha ula awannyaka anakunkomana, kontha kihaayarana asaana siita. Phimaana ahonvaha ncina na Sepulomi. ");
INSERT INTO mgh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ukati vakani tho, ule ahonnyara mwana mwanthiyana ammahilyawe ncina na Tina. ");
INSERT INTO mgh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Vano Nluku ahomuupuwela Rakeli. Nluku aheewa ukhuwela wawe ni ahompanka mayooyara. ");
INSERT INTO mgh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ule ahorupala irukulu nuunnyara mwana ni aheera: Nluku hotamiha ihaaya caka nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ahonvaha ncina na Yusufu ni aheera: Mwaneene Nluku akivahe tho mwana nkina. ");
INSERT INTO mgh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rakeli nannyanreene Yusufu, Yakopi ahomwiirela Lapanu: Ukihiye kituruwele uwaani, ilapo aka. ");
INSERT INTO mgh_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ukivahe asaaraka ayo yuvarenlyaka nteko, na asaanaka ayo, kontha mi kimphavela urwaa uwaani. We uhocuwela ciinryaka wowuuvarela nteko. ");
INSERT INTO mgh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Nanso Lapanu ahomwiirela: Wakhala wiira kihophwanya iparakha wa miithoni waa kinawulepela wiira ukhale ni mi. Kihoona wiira Mwaneene Nluku hokivaha iparakha nlattu wawaa we. ");
INSERT INTO mgh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ni ahopwahera eeraka: Ukihimerye ihisapu yowuuliva; mi kinaahala wuuliva. ");
INSERT INTO mgh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakopi ahomwaakhula: We uhocuwela cuvarenlyaka nteko, ni mihuwo caa cihoncererya nlattu wowehaweha mi. ");
INSERT INTO mgh_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ni citthu vakani caarinaa kihinawa, cihoncererya venci, kontha Mwaneene Nluku hovaha iparakha ukati uwilyaka uno. Vano mi kinhala upanka yakhani itthu yowakavihera alokwaka? ");
INSERT INTO mgh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Vano Lapanu ahonkoha: Untthuna kuuvaheke isiyani? Yakopi ahaakhula eeraka: Uhikivahe itthu. Kinaahokoleela uwacawaca nuuhakhela mihuwo cinyu wakhala wiira nnakupali imphavelaka. ");
INSERT INTO mgh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ilelo kinaahala uvira mmihuwoni mwinyu ni kimmothanla ikhontwaa co manepa ni co mitthottwe, ni asikhontwaa othene ooripa, ni ipuri co manepa ni co mitthottwe, cole phinhalaka ukhala mpokerero aka. ");
INSERT INTO mgh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ni isariya aka inkowuvaha uhoolo usaahiti, ukati unhalaa uwehaweha mapokerero aka. Yakhalaka mmatatani mwaka ipuri yohimanepa ni yohimitthottwe, ikhontwaa cohiripa, pooti wiira cowiinyinya. ");
INSERT INTO mgh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lapanu aheera: Nihotthukelana, weerannyee toko cihimilyaa. ");
INSERT INTO mgh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nanso, nenno nihuku nno Lapanu ahaakawaniha apeperu o mitthottwe ni o manepa ni ipuri cothene co mitthottwe ni co manepa cothene cari cotteelatteela ni asikhontwaa othene ooripa ni ahohiya mmatatani mwa asaanawe. ");
INSERT INTO mgh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Vano Yakopi ahokhuma nipuro nne arwaka ncoko woweettiya mahuku mararu. Wahoolo Yakopi ahopwaherera uliha mihuwo ca Lapanu. ");
INSERT INTO mgh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Vaavale Yakopi ahokusa miri cikithi co mphari, ntholo ni rokoci ni ahokhava apankaka mitthottwe. ");
INSERT INTO mgh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wakhavaawe, aheesa uhoolo waya mihuwo, mmakuwani, mawureryoni ni mapuro yarupaya ni canapepheryana ukati wawaya uwurya. ");
INSERT INTO mgh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ni campepheryana uhoolo waya miritta, cantotholiya co marephurephu, co manepa ni co mitthottwe. ");
INSERT INTO mgh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Vano Yakopi anawawayaniha cikani nnyo, ni aanapanka wiira cennyo cikhale wamoca ni inama co marephurephu ni cooripa ca Lapanu. Commo antthonkomaniha mihuwo cawe woohitakanihera ca Lapanu. ");
INSERT INTO mgh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ukati warupalaya ikhontwaa coonenevaca nnye, Yakopi anaweesa uhoolo waya nwo miritta, cineemelacilene mmasepani, wiira citotholele mmirittani mmo. ");
INSERT INTO mgh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nanso kheesa miritta nnye uhoolo waya inama cokenkennya, kontha cokenkennya nnyo caakhala ca Lapanu ni cooneneva nnyo cakhala ca Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Phimaana Yakopi ahothaciri venci mpaka ahaana mihuwo cinci, ipottha cithiyana ni cilopwana, inkamira ni apuuru. ");
INSERT INTO mgh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakopi aheewa wiira, asaana a Lapanu yanawuulumaca yiiraka: Yakopi howyaa citthu ni mihakhu cothene carinaya apaapa ehu, phimaana athaciriki. ");
INSERT INTO mgh_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakopi ahoona wiira makhalelo a Lapanu ni uyo khayari toko khalayi. ");
INSERT INTO mgh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Vano Mwaneene Nluku ahomwiirela Yakopi: Uturuwele ilapo yo mayathumwanaa ni wamucyaa. Mi kinkokhala ni we. ");
INSERT INTO mgh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Vaavale Yakopi ahoruma wiihaninya Rakeli ni Leya wiira arwace utakhwani yoone mihuwo cawe. ");
INSERT INTO mgh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Uwaca waya aheerelaca coo: Kinawoona makhalelo athumwaninyu ayo ni miyano khaanakhala toko khalayi. Nanso Nluku Apaapa ari ni mi. ");
INSERT INTO mgh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nyu nnaacuwela wiira kihaavarela ratta nteko athumwaninyu, ");
INSERT INTO mgh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","nanso ayo ankipanka mi ntirikhi, avirikanihacaka mpokerero aka imaara khumi. Nanso Nluku khaatthunihenre wiira akipanke yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Yakiirelaka wiira inama co manepa nnyo cikhaleke cawaa, phuupokera waa; vano mihuwo cothene cakhala co manepa. Ni yakiirelaka coorephuwaca nnyo cothene cikhaleke cawaa, wonwo phuupokera waa, vano mihuwo cothene caatothola asaana oorephuwaca. ");
INSERT INTO mgh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nluku ala mananna ala phipankilyawe wowaakha mihuwo athumwaninyu akivahaka mi. ");
INSERT INTO mgh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Weeracele coo: Ukati warupalaya mihuwo nnyo, mi kahoweha ni kahoona munttorani mmo anapinkula athukumananaka ikhontwaa cithiyana nnyo cari co manepa, co marephurephu ni co mitthottwe. ");
INSERT INTO mgh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Vano ncelo a Nluku ahokiirela munttorani: Yakopi, mi kahomwaakhula kiiraka: Kiri va. ");
INSERT INTO mgh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ni ule ahomwiirela tho: Uwuse miitho aa ayo, ni unawoona anapinkula othene anthukumanana ikhontwaa cithiyana nnyo, ari o manepa, o marephurephu ni o mitthottwe, kontha kihoona cothene cuupankilyawe Lapanu. ");
INSERT INTO mgh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mi phi mi Nluku o Peeteli wonwe wemeesilyaa nluku uttikitthelaka makhura ni ukoopelaka natiri. Wunwe nna va, ukhume ila ilapo ela ni uturuwele ilapo ya alokwaa. ");
INSERT INTO mgh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Vano Rakeli ni Leya yahonkoha Yakopi yiiraka: Wapaapa nwo uhaawo mphantte wonhakhu unnaaca? ");
INSERT INTO mgh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Khannalikelela ukhala amalaponi? Maana ahonitumiha ni aholya ncurukhu uyo. ");
INSERT INTO mgh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kontha nhakhu wothene Nluku ukumihilyawe wathumwanihu uri wawihu ni wa asaanehu. Nna vaa upanke cothene cinoohimeryawe Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Vano Yakopi ahaaweliha asaarawe na asaanawe ayo mmankamirani. ");
INSERT INTO mgh_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ahokusa mihuwo cawe cothene ni mihakhu caphwanyilyawe uPatan-Arami, wiira arwee ilapo yo Kanaa, uri Isaki athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ukati Lapanu warwelyawe uthikila mapururu okhontwaa, Rakeli aheennya ananttuntta a athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ni Yakopi ahomwiita Lapanu nramewu wohinhimerya itthu kontha anatthawa. ");
INSERT INTO mgh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ahonwa nuutthawana cothene carinawe ni aholapuwa mooloko awehaka muru mwaako wo Kiliyati. ");
INSERT INTO mgh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nihuku noneeraru Lapanu ahohimerya wiira Yakopi hotthawa. ");
INSERT INTO mgh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Vano ahaakusa asunnawe ni ahontthimakela mahuku saapa eettaka ni ahomphwanya nari mwaako wo Kiliyati. ");
INSERT INTO mgh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Vano Lapanu Nramewu ahophwanyinya ni Nluku, uhiyu munttorani phimwiirelaka: Wiisunke, uhuulume itthu ni Yakopi, hata ikhale itthu yooreera atthuna yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lapanu ahomphwanya Yakopi naakhurutunle aheema awe umyakoni co Kiliyati. Ciicammo Lapanu na asunnawe ahaakhurutula aheema awe umwaakoni. ");
INSERT INTO mgh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Vano Lapanu ahonkoha Yakopi eeraka: Ukipankile cani? Yokiita iyo wakusaka asaana ayo toko ipottha coovariya ukhottoni? ");
INSERT INTO mgh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nlattuni ukitthawaka womwiitiho ni ukisempaka, wohikihimyacera itthu? Hapo mi kanawuveleliha wootteeliya ni icipo, ikoma ni ceece. ");
INSERT INTO mgh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ciicammo khukihile kavahaka alaahuma asaanaka nu ucuulu aka wiira kaaleehe. Uheetta wootirikhi. ");
INSERT INTO mgh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kahaana ikuru cooreera wuuttarusa, nanso Nluku athumwaninyu, hokuulumana ncana uhiyu eeraka: Wiisunke uhimuulumele itthu hata ikhale yooreera atthuna yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Vano we wapheela urwaa, kontha wahoonukhela uturuwela waathumwanaa, kahiki wennyerani anluku aka ayo? ");
INSERT INTO mgh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakopi ahomwaakhula Lapanu eeraka: Kanawoova. Kontha kooniha wiira unakaakha asaanaa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ule nohalaa umphwanyana anluku aa ayo umwiive. Unikukhuryace mi na asunnaka ayo waphwanya itthu yawaa ukuse. Kontha Yakopi khaacuwela wiira Rakeli pheennyile anluku ayo. ");
INSERT INTO mgh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Vano ahokela Lapanu nheemani mwa Yakopi, nheemani mwa Leya, nheemani mwa ipottha cithiyana piili nanso wohaphwanya anluku ayo. Ni ukhuma wawe nheemani mwa Leya, ahokela nheemani mwa Rakeli. ");
INSERT INTO mgh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Nanso Rakeli ahaakusa ananttuntta ayo ni wattukhunyera munhukhoni yonkamira ni ahonkomela. Vano Lapanu ahaakukhurya nheemani mothene, ni khaaphwanyile. ");
INSERT INTO mgh_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakeli aheerela athumwane: Paapa, nhikiviruwele akinlamuliya wunwa kontha kiri ni nteko wathiyana. Lapanu ahaawehaweha ananttunntta ayo, nanso khaaphwanyile. ");
INSERT INTO mgh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Vaavale Yakopi ahorusiya nunviruwela Lapanu amwiirelaka: Kitthekileni? Kukosenre isiyani yooreera we uviruwa ni ukoomolanihaca? ");
INSERT INTO mgh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","We uhokukhuryaca mirintti caka cothene wakhala wiira uhophwanya itthu yawaa, uwiihe va yoonaka alokwaa ayo ni alokwaka wiira anihukhumu. ");
INSERT INTO mgh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Myakha sirini kihoovarela nteko. Ikhontwaa ni ipuri cinyu akinarihakaciha ni akinakhura inama yo nhuwo enyu. ");
INSERT INTO mgh_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kakinowiiherani inama yoorakalaca. Nkilivihaka inama cothene cenyinya uhiyu atthuna uthana. ");
INSERT INTO mgh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Uthana kaakhwa nttukuttha ni uhiyu kaakhwa uriiriya ni nkaarupa. ");
INSERT INTO mgh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kihokhala myakha sirini, kuuvarelakani nteko. Myakha khumi na micese kihovarelani nteko wiira kaathele asaanaa eeli, ni myakha siita kihovarelani nteko nkipokerihaka inama, nanso nyu nhorukunusaca mapokerero aka imaara khumi. ");
INSERT INTO mgh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ahaari Nluku a apaapa, Nluku a Aparahamu, Nluku ri ihisima ya Isaki, khweeli nyu mwankoomola wohiitthu. Nluku heewa icuku caka ni hoona nteko uvanryaka, phimaana hookuphulani uhiyu wo ncana. ");
INSERT INTO mgh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Vaavale Lapanu ahomwaakhula Yakopi eeraka: Ala asithiyana ala asaanaka ni asilopwana ayo ucuulu aka, nnya mihuwo caka ni cothene cinoonaa nnyo ciri cawaka. Ilelo kinhala weeriha cani asaanaka ala ni asaana yayanryaya ayo? ");
INSERT INTO mgh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nna va nileehane wiira ukhale usaahiti we ni mi. ");
INSERT INTO mgh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Vano Yakopi ahokusa nluku ni aheemesa upanka nivatta. ");
INSERT INTO mgh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ni Yakopi aheerela asunnawe: Mpanke nikuttha no maluku. Ni ale yahopankaca nikuttha no maluku ni othene yaholelyaca wanikutthani vale. ");
INSERT INTO mgh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lapanu aheehana nipuro nno Yekar-Saatuta, nanso Yakopi eehane Kaleeti. ");
INSERT INTO mgh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Vano Lapanu aheera: Nna nikuttha nna nikhale saahiti ehu we ni mi. Phimaana wiihaninyaka uKaleeti ");
INSERT INTO mgh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ni Misipa, kontha heera: Mwaneene Nluku nniwehawehe we ni mi ni anihukhumu hata nimwalane ntthu ni nkhwawe. ");
INSERT INTO mgh_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Waahuvihaka asaanaka ala, waathelaka athiyana akina mi hata kihikhale, ucuwele wiira Nluku nawoona. ");
INSERT INTO mgh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lapanu ahomwiirela tho Yakopi: Nikuttha phi nna, ni nivatta neemesilyaka iriyari yo we ni mi phi nna. ");
INSERT INTO mgh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Nikuttha nna nikhale saahiti. Ciicammo nivatta nna nikhale saahiti wiira yakhala yoonanara kihitupihe nikuttha nna kiwanaka nwo, ni we yakhala yoonanara uhituphane nikuttha nna ni nivatta nna uwaka uno. ");
INSERT INTO mgh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nluku a Aparahamu, Nluku a Nahori, Nluku o mayathumwanaya anihukhumu. Ni Yakopi, mwanlattu wo ihisima ya Isaki athumwane, aholupela. ");
INSERT INTO mgh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakopi ahopanka isataka umwaakoni, ni aheehana asilokwawe yaari wonwo wiira alye. Yaholyaca ni yarupacile umwaakoni wonwo. ");
INSERT INTO mgh_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lapanu ahonwa wicisuru ahaavaha alaahuma asaanawe asilopwana na asithiyana, ahaareeriha ni ahoturuwela uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wahoolo Yakopi ahokhuma ni ahaakumanana ancelo a Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Vano woona wawe, Yakopi aheera: Ala anakhotto a Nluku! Ni ahovaha nipuro nno ncina na Manayimu. ");
INSERT INTO mgh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Vaavale, Yakopi ahaaveleliha mayanhupi awe wa Isawu munnaawe, akhala uSeyiri ilapo yo Eetomu. ");
INSERT INTO mgh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ni aheerela mwanhimerye nkunyaka Isawu wiira: Mi karumeya enyu Yakopi kari wamoca ni Lapanu, kihaawo mpaka ilelo. ");
INSERT INTO mgh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kihaana imope na apuuru, ikhontwaa, ipuri, ipottha cithiyana ni cilopwana. Nkunya, kinovelelihera ula nhupi ula, wiira ukakhelele wosalaama. ");
INSERT INTO mgh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Vano mayanhupi yahoturuwela wa Yakopi phimwiirelaka: Nihomphwanya munnaa Isawu ni uyo nowa wonwo, nawuphavela, ni haana alopwana iminya cese. ");
INSERT INTO mgh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vano Yakopi ahoova venci ni ahocukula. Phimaana ahaakawaniha atthu ayo miphwinko miili, ciicammo ahokawaniha ikhontwaa, ipuri, imope ni inkamira miphwinko miili, ");
INSERT INTO mgh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","kontha oopuwela coo: Isawu awaaka na anakhotto awe aatuphelaka mphwinko mmoca nkina uyo unkohala. ");
INSERT INTO mgh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Vano Yakopi ahoswali eeraka: Nluku a paapa Aparahamu, Nluku a paapa Isaki, we Mwaneene Nluku ukireenle wiira: Uturuwele uwannyaa waalokwaa kinawupanka yooreera. ");
INSERT INTO mgh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mi kinacuwela wiira khaninkiphwanela nifento neekhweeli ninkipankaa mi karumeyaa. Kilapuwile mooloko Yortani ni nttontto aka paahi, nanso nna va kihaana miphwinko miili. ");
INSERT INTO mgh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Sontte ukoopole mmatatani mwa munnaka Isawu, kontha mi kinamoova, wiira hiiwe ukiiva mi, asaana wamoca na anumwanaya. ");
INSERT INTO mgh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kontha we uheera: Kinaweettiha ratta. Kinawuvaha ucuulu mwinci toko nhava wo mpharyaa ni mphwinko wa atthu wohaalikelyaa. ");
INSERT INTO mgh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yoole uhiyu ule Yakopi ahorupa nenne nipuro nne ni ahothanla mihuwo commaha munnaawe Isawu: ");
INSERT INTO mgh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ipuri cithiyana iminya piili ni anapinkula sirini, ikhontwaa cithiyana iminya piili ni anapinkula sirini okhontwaa, ");
INSERT INTO mgh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","inkamira talathini cithiyana co wamwinya na asaana aya, imope cithiyana arupayini ni imope khumi cilopwana, apuuru onthiyana sirini ni apuuru onlopwana khumi. ");
INSERT INTO mgh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ahaakawela mihuwo nnyo ipottha cawe wiira awacawace, ni wo khula nhuwo wari mphantte aya, ni aheerela: Nhoolelaceke ni nhiye ikhato nhuwo ni nhuwo nkhwaya. ");
INSERT INTO mgh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ahonlamulela oopacera ole: Munnaka Isawu oophwanyaka, ni ookohaka wiira: We uri naani, unrwa vayi ni nhuwo urinaa ula wawani? ");
INSERT INTO mgh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Vano umwakhuleke wiira ca karumeya enyu Yakopi. Ciri itthuvo cinonveleliherawe nkunya awe Isawu ni uyo neera awaka uttuli wihu. ");
INSERT INTO mgh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ciicammo ahonlamulela onayeeli, oneeraru nale othene yawa uttuli mihuwo eeraka: Uphwanyakani Isawu othene munhimyacere nuulumo nimoca nenna. ");
INSERT INTO mgh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Munhimerye tho wiira: Karumeya aa Yakopi nawa uttuli uno. Kontha Yakopi hoopuwela coo: Kahoolihaka itthuvo caka nnyo, kinattipiha urusiya wawe nwo, vano nakumanacaka ni mi uyo, atthunaka nakakhelela wooreera. ");
INSERT INTO mgh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Phimaana inama cotthuvo nnye cahohoolihiya, nanso ule ahohala veekhawe nipuro nomakiya nne ni ahorupa uhiyu wothene. ");
INSERT INTO mgh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yoole uhiyu ule ahonwa ni ahaakusa asaarawe eeli, na asaarawe eeli oohitteeliheraninya, wamoca na asaanawe khumi na mmoca, ni yaholapuwaca nsepa no Yappoko. ");
INSERT INTO mgh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ahaalapusaca nsepa nno asaarawe ayo ni citthu cothene carinawe. ");
INSERT INTO mgh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Vano Yakopi ahohala veekhawe ni ahomwanana nlopwana mmoca uhiyu wothene mpaka usa. ");
INSERT INTO mgh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Nlopwana ule, woona wawe wiira khamoorya untthema, ahomwaatta wakumanacile makhuva oonatara, ni Yakopi ahorepenyuwa wakumanacile makhuva ni amwananaka ono. ");
INSERT INTO mgh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nlopwana ule aheera ukihiye kirwee kontha uhosa. Nanso Yakopi ahomwaakhula eeraka: Akinoohiya urwaka wahikireeriheke. ");
INSERT INTO mgh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ni ahonkoha: Ncina naa tipani? Ule ahomwaakhula: Mi kineehaninya Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Vano nlopwana ule aheera: Ncina naa khaninhala wiihaninya tho Yakopi, nanso Israyeli, kontha we uhomwaanana Nluku na atthu ni uhotthema. ");
INSERT INTO mgh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ni Yakopi ahonkoha eeraka: Kinapheela ucuwela ncina naa. Ule aheera: Unkikoherani ncina? Vaavale ahonreeriha. ");
INSERT INTO mgh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Vano Yakopi ahovaha ncina na Peniyeli nenno nipuro nno, eeraka: Kontha kihomoona Nluku ni miitho aka ala ni mi kinkumi. ");
INSERT INTO mgh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aakhumile uPeniyeli, ukati wakhumaya ncuwa ni Yakopi anattumpela. ");
INSERT INTO mgh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Phimaana mpaka nihuku noleelo annasirayeli khankhuraca ntinka unluttaniha natara ni iyuunu, kontha Yakopi ahaattiya wantinkani ukumanihile natara ni iyuunu. ");
INSERT INTO mgh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yoole ukati ule, Yakopi ahoweha ni phamoonawe Isawu awaaka, nari na alopwana iminya cese. Vano ahaakawa asaanawe ayo anvahaka Leya, Rakeli na asaarawe eeli oohitteeliheraninya. ");
INSERT INTO mgh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Vano ahaaholiha asaarawe eeli oohitteeliheraninya na asaanaya ayo, ahomweesa Leya na asaanawe ayo uttuli waasaarawe oohitteliheraniya Rakeli ni Yusufu phaari oomalihera. ");
INSERT INTO mgh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Wahoolo Yakopi ahaapwahaca nukhala uhoolo, ni ahoromela vathi imaara saapa mpaka waphilyawe wamunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Vaavale Isawu ahontthimakela, ahonkapatta nuunvaha alaahuma nuunsalameeha, ni othene yahonlaca. ");
INSERT INTO mgh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wahoolo ahoweha ni ahoona athiyana na amirawo ni ahokoha eeraka: Ala phaasipani arinaa ala? Ule ahaakhula eeraka: Ala pha asaana anvahilyawe Nluku wotthuna wawe karumeya aa. ");
INSERT INTO mgh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Vano yahophiyaca asaarawe eeli oohitteliheraniya wamoca na asaanaya ayo ni yahoroma. ");
INSERT INTO mgh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ciicammo ahophiya Leya wamoca na asaanawe, ni ahoroma. Wiimaliheroni ahophiya Yusufu ni Rakeli, na ayo yahoromaca. ");
INSERT INTO mgh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Nanlelo Isawu anakoha: Unhala wiirihani mihuwo cothene ciphwanyilyaka niphiro nnyo? Yakopi ahomwaakhula: Keera kiphwanye nnema wamiithoni wankunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Nanso Isawu ahomwiirela: Mwanhimaka, mi kihaana mihuwo cinci. Cirinaa nnyo uhalaneke. ");
INSERT INTO mgh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Vano Yakopi ahomwaakhula: Mena, wakhala wiira uhaana nnema ni mi ukuse itthuvo yuvahilyaka ela, phimaana koonaka ikhove aa, toko wiira koonne ikhove ya Nluku, kontha we uhokaakhelela. ");
INSERT INTO mgh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kinawulepela ukuse iparakhaka iwaneliyaa kontha Nluku wo nnema hokivaha, ni kihaana ciinci. Ni ahonkhanyereriha mpaka Isawu waakhelela. ");
INSERT INTO mgh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Isawu aheera: Nrwee neette. Mi kinahoola. ");
INSERT INTO mgh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nanso Yakopi aheera: Nkunya, kinawoona asaanaka ayo ukenkenyaca ni kihaana ikhontwaa ni imope cotothola naanano kaakuvihacaka, wonihuku nimoca kinawoova ukikhwacera cothene. ");
INSERT INTO mgh_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Fatari uhooleke nkunya, mi kinawa uttuli nwo keettaka vakani vakani. Kintthariha malonce onama ciri uhoolo nnya ni amirawo arinaka ala. Kinawuphwanya uSeyiri. ");
INSERT INTO mgh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Vano, Isawu aheera: Kinawuhiyera atthu arinaka ala. Ule ahonkoha: Nlattuni? Wanaatosa mi kaphwanyaru nnema ni nkunya aka. ");
INSERT INTO mgh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Phimaana Isawu ahoturuwela iphiro yaweenlyawe ahokoleelaka uSeyiri. ");
INSERT INTO mgh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nanso Yakopi ahopwahera arwaka uSukoti. Uphiya wawe ahoteka inupa ni macici onama cawe. Phimaana wiihaninyaka nenno nipuro nno uSukoti. ");
INSERT INTO mgh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Paahi Yakopi ahophiya nari nkumi iparasa yo uSikeni ni ilapo yo Kanaa, akhumaka uPatan-Arami; ni ahomaka vakhiviru nuparasa. ");
INSERT INTO mgh_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ni ahothuma nthala nankhurutunlyawe heema munthalani na asaana a Hemori, athumwane Sikeni ni nsurukhu iminya imoca. ");
INSERT INTO mgh_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Vaavale ahoteka ikhilompi ni ahovaha ncina na Nluku, Nluku o Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nkwaha mmoca, Tina, mwana a Leya ayanryawe ni Yakopi, ahokhuma wiira aacuwelane athiyana oyeele ilapo ele. ");
INSERT INTO mgh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sikeni, mwanawe Hamori, nHevewu, mwene o yoole nttetthe ule, ahomoona ni ahontuphela. ");
INSERT INTO mgh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Nanso nrima awe wahonphelyaa nlattu wa Tina, mwana a Yakopi, ni ule ahoncivela mwanthiyana ole ni ahomuulumana wonifento. ");
INSERT INTO mgh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Phimaana Sikeni ahorwaa waahimerya athumwane eerelaka: Nkuulumele ule nthiyana ole wiira akhale mwaaraka. ");
INSERT INTO mgh_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakopi wacuwenlyawe wiira mwamwanawe Tina ahotankanyinya iharusi, asaanawe anari utakhwani walihaaya mihuwo; ahomaala awehereryaka uturuwaca. ");
INSERT INTO mgh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Vano Hamori, athumwane Sikeni yahorwaa woopa mwaha ni Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ukati waturuwacilyaya utakhwani asaana a Yakopi yahocuwelaca cothene ni yahocukulaca nuurusiya venci cinenne kontha Sikeni ahopanka itthu yowuulihaca muru uIsirayeli, wanrupanyawe mwana a Yakopi; itthu ihimpankiya. ");
INSERT INTO mgh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Nanso Hamori aheerelaca: Mwanaka Sikeni hociveliya ni mwaninyu. Kinawuvekelani wiira munvahe akhale mwaarawe. ");
INSERT INTO mgh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ni niyaranace nyu ni hi, nnivahaka asaanenyu asithiyana ayo ni hi ninawuvahani awihu ayo, ");
INSERT INTO mgh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ni nkhale wamoca ni hi. Ilapo inoonenyu ila nkhale wohitwana. Mpanke marontta enyu ni nkhalane mathala. ");
INSERT INTO mgh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Vano Sikeni aheerela athumwane ni asunnawe mwanthiyana ole: Nkikupali. Nkivahe mwanthiyana oyo. Mi kinawuulivani ihisapu yothene inhalenyu ukilamula. ");
INSERT INTO mgh_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mwatthuna mmwelihe ihisapu yoothela ni contthuva mwali uyo. Mi kinakumiha cothene cinhalenyu uhimya, nanso nkivahe mwali uyo kinthele. ");
INSERT INTO mgh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Vaavale, asaana a Yakopi yahonthepyaca Sikeni ni athumwane yeehaninya Hamori nlattu wootankanyaa iharusi ya Tina, mwanrokoraya. ");
INSERT INTO mgh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ni yahomwiirelaca: Khaninlamuliya upanka commo, unvaha mwanrokorihu nlopwana oohuula icantto kontha iri itthu yowuuliha muru. ");
INSERT INTO mgh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Phimaana ninhala wutthunani nyu mwakhalaka toko hi. Mooliheke alopwana othene toko hi. ");
INSERT INTO mgh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Vano ninawuvahani asaanehu ayo wiira mwaatheleke, ni hi, asaanenyu ayo ninawathela. Ni ninhala ukhala wamoca ni amocaru ni nyu. ");
INSERT INTO mgh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nanso mwahiniweke ni mwahuuleke icantto, ninankusa mwanihu uyo nuuthama. ");
INSERT INTO mgh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yaayo moolumo ayo yahoncivela Hamori ni mwanawe Sikeni. ");
INSERT INTO mgh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikeni khapicile nuupanka yeereliyawe iyo kontha ahoncivela venci mwana a Yakopi. Ni Sikeni phaari oofentiya venci wowapwaha atthu othene yaariwo ntthoko na athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Phimaana ahorwaa Hamori ni Sikeni wathukumaniha alopwana othene oparasa ni wahimerya eeraka: ");
INSERT INTO mgh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ale atthu ale ari osalaama ni hi, phimaana naahiye akhale ilapo ehu ila ni apanke marontta aya. Kinawoona ilapo ihu iyo iri yinci. Ananivaha waathela asaanaya ayo ni hi ninawavaha asaanehu ayo. ");
INSERT INTO mgh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nanso ayo atthu ayo anhala ukupali ukhala ni hi ni ukhala amocaru. Hi alopwana va othene nolaka icantto, toko ayo cunlyaya. ");
INSERT INTO mgh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nnoona cani, imope caya nyo, ni nhakhu aya uyo, ni mihuwo caya nyo, khacinhala ukhala cawihu? Neewanane paahi ni anaahala ukhala wamoca ni hi. ");
INSERT INTO mgh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Vaavale atthu othene yavira nkhora wo oparasa, yahomwiiwelela Hamori ni mwanawe Sikeni, ni alopwana othene yaavira wa nkhora woparasa, yahoolihiya icantto. ");
INSERT INTO mgh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Waphilyaya nihuku noneeraru, ukati waryaya muhuvani ni yaweryaka venci makhwatta ayo, asaana eeli a Yakopi, Simeyoni ni Levi, asirokorawe Tina, yahokusaca khula ntthu ikatana awe, yahokelaca mparasa mmwe ni yaheevakaca alopwana othene. ");
INSERT INTO mgh_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ciicammo yahomwiivaca ni ikatana Hamori ni mwanawe ni yahonkusaca Tina aari inupa ya Sikeni ni yahokhumaca. ");
INSERT INTO mgh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Asaanawe Yakopi yahophiyaca wa atthu ookhwa ni yahohukhaca mparasa mmo mothene kontha yanootankanyinya iharusi ya mwanrokoraya Tina. ");
INSERT INTO mgh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yahokusaca ikhontwaa, imope, apuuru caari mparasa ni cothene caari mmattani. ");
INSERT INTO mgh_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Yahokusaca mihakhu ni yahavarakaca asaana na athiyana urwaa wapanka ipottha, ni yahohukhaca mmapaani mothene. ");
INSERT INTO mgh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Phimaana Yakopi ahomwiirela Simeyoni ni Levi: Mokivelaveliha, nhokiputaniha na atthu ankhala ilapo ela, ni makanani ni maperesewu ncuwelaka wiira hi niri vakani, anaahala ulattulana nuuhonona ntthoko ehu. ");
INSERT INTO mgh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Vano ale yahaakhulaca: Mpaka uyo umpanka mwanrokorihu toko puuta? ");
INSERT INTO mgh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nluku ahonlamulela Yakopi: Wunwe, urwee uPeteli ni wakhale wonwo ni wampankele ikhilompi Nluku ookhumelenle ukati wantthawa munnaa Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Vano Yakopi ahohimerya ntthoko nawe na atthu othene yarinawe eeraka: Mwakumihe anluku a malaponi othene wariyari winyu mwiirapihe ni mmware ikuwo cikina. ");
INSERT INTO mgh_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Vano nunwe nirwe uPeteli wonwo kinkontekela ikhilompi Nluku akaakhunle nihuku narinaka masukuli ni hokiveleela mmaphironi mothene mweettaka. ");
INSERT INTO mgh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Vaavale Yakopi ahovahiya anluku othene oohimaana yari mmatatani ni ipirinku caari mmanyaruni ni Yakopi ahothipela vathi mooko uri wamoca nuSikeni. ");
INSERT INTO mgh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Vano yahokhumaca, na atthu yakhala yeeyo ilapo eyo Nluku ahaacariha woova mpaka woolwana wattharatthara asaana a Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Commo, Yakopi na atthu othene yarinawe yahophiyaca o Lusu uneehaniya uPeteli uri ilapo yo Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Vaavale ahoteka ikhilompi ni nenno nipuro nno ahovaha ncina no El-Peteli, kontha Nluku ahonkhumelela ukati wantthawawe munnaawe. ");
INSERT INTO mgh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ahokhwa Teepora, karumeya a Repeka, ni ahovithiya vakhiviru nuPeteli vathi waya mooko ni ahovaha ncina na Alompakuti. ");
INSERT INTO mgh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Wahoolo Nluku ahonkhumelela tho Yakopi, akhumaka uPatan-Arami ni ahonreeriha. ");
INSERT INTO mgh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Vano Nluku ahomwiirela: We ncina naa Yakopi. Ukhuma ilelo ncina naa khaninhala wiihaniya tho Yakopi nanso ncina naa ninhala wiihaniya Isirayeli. Ni aheehaneliya ncina na Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nluku ahomwiirela tho: Mi phi mi Nluku okuru cothene. Uyarace ni ukhalane ucuulu mwinci. Mwiirutthuni mwa we, inaakhumelela ilapo cinci na atthu enci, ni ammokhumelela mamwene menci. ");
INSERT INTO mgh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mi kimmowuvaha we ilapo invahilyaka Aparahamu ni Isaki. Wahoolo ilapo eyo kinavaha ucuulu aa. ");
INSERT INTO mgh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Vaavale, wuulumaca wawe Yakopi, Nluku ahowela. ");
INSERT INTO mgh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Vano aheesa nivatta no nluku nipuro noolumaninyawe ni Nluku, ni aheetthela yoowuriya ni makhura waculu waya nivatta. ");
INSERT INTO mgh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Phimaana Yakopi ahovaha ncina no Peteli nipuro namuulumanyawe Nluku. ");
INSERT INTO mgh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Wakhumilyaya uPeteli, unahanle ncoko vakani wiira aphiye ilapo yo Efarata, Rakeli ahonnyara mwana, nanso uyara wawe waari wookukuryaca. ");
INSERT INTO mgh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Nari mmekho, mayoyariha ahomwiirela: Uhoove, kontha uhaana tho mwana mwanlopwana. ");
INSERT INTO mgh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Vano wakhumaya nnepa awe, kontha hokhwa, ahonvaha mwana ule ncina na Penoni, nanso athumwane yahonvaha ncina na Pencamii. ");
INSERT INTO mgh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ni ala mananna ala pheeracilyawe wookhwa Rakeli ni ahovithiya ni iphiro yorwaa o Farata uneehaniya uPetelehemu. ");
INSERT INTO mgh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Waculu waya mahiye, Yakopi aheemesa nivatta no nluku. Mpaka nihuku noleelo, nenne nivatta nne ninathonyera mahiye a Rakeli. ");
INSERT INTO mgh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Vano Isirayeli ahokhuma arwaka unkhurutula heema awe withela Miktal-Eteri. ");
INSERT INTO mgh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Anowiira Isirayeli athamelaka yeeyo ilapo eyo, Rupeni ahorwaa unthukumanana Piila, amwaara athumwane oohitteeliheraninya, ni Isirayeli ahocuwela. Yakopi ahaana asaana khumi nuuwa eeli: ");
INSERT INTO mgh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Rupeni, ntthara na Yakopi, Simeyoni, Levi, Yutta, Isakari ni Sepuloni, ala yari asaana a Leya; ");
INSERT INTO mgh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Yusufu ni Pencamii asaana a Rakeli; ");
INSERT INTO mgh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Taani ni Nafitali asaana a Piila, ipottha ya Rakeli; ");
INSERT INTO mgh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kaate ni Aseri yaari asaana a Silipa ipottha ya Leya. Ala phaasaana yayarelyawe o Patan-Arami. ");
INSERT INTO mgh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakopi ahorwaa unthotola Isaki, athumwane, o Manree yo Kiriyate-Arapa o Heporoni wakhalawe Aparahamu ni Isaki. ");
INSERT INTO mgh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Mahuku ookumi a Isaki yari myakha iminya imoca ni myakha nuwa thamanini (180) ceyarelo. ");
INSERT INTO mgh_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaki ahomumula nuukhwa nooluvanle ni ahaatthara mayathumwane. Isawu ni Yakopi, asaanawe, yahonvitha. ");
INSERT INTO mgh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ula phu ucuulu wa Isawu, neehaniya Etomi. ");
INSERT INTO mgh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isawu ahaathela athiyana iriyari ya asaana uKanaa: Ata mwana a Eloni, nHitita; Oholipama mwana a Anaa, mwana a Sipeyone nHivita; ");
INSERT INTO mgh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ni Pasimati mwana a Sumayili, mwanrokorawe Nepayote. ");
INSERT INTO mgh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Isawu ahonnyarana Ata, Elifasi, ni Pasimati ahonnyarana Reweli. ");
INSERT INTO mgh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholipama ahonnyara Yewusi, Yalawu ni Korani. Ala pha asaana a Isawu yayarenlawe ilapo yo Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Vaavale Isawu ahaakusa asaarawe othene, asaanawe asilopwana na asithiyana na atthu othene ovatthokoni wawe; ni ahokusa mihuwo cawe, imope, mihakhu cawe ni citthu cothene caphwanyilyawe ilapo yo Kanaa, ni amwalanaka ni nhimaawe Yakopi ahothamela ilapo ikina. ");
INSERT INTO mgh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kontha mihakhu caya nnyo cari cinci, ni khacareerana ukhalakhala nipuro nimoca, ni ilapo yakhalakhalaya eyo khayarina coolya cootosa mwanlattu wonama carinaya nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Phimaana Isawu, neehaniya Etomi, ahorwaa ukhala mwako wo Seyiri. ");
INSERT INTO mgh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ula phu ucuulu wa Isawu athumwanaya annaEtomi, yakhalaca mwako wo Seyiri. ");
INSERT INTO mgh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ala phi macina asaanawe Isawu: Elifasi mwana a Ata, mwaarawe Isawu; Ruweli mwanawe Pisamate, mwaarawe Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Asaana a Elifasi: Teemani, Umari, Seefu, Kaayita ni Keenasi. ");
INSERT INTO mgh_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timina ari mwaarawe oohitteeliheraninya a Elifasi, mwana a Isawu, ni ahonnyarana Elifasi Maalike; ala pha asaanawe Ata amwaara a Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ala pha asaana a Ruweli: Naate, Seraa, Samaa ni Miisa; ala yari asaana a Pasimati, amwaarawe Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ala pha asaana a Oholipama, mwanawe Anaa, mwanawe Sipeyone, athiyana oneeraru a Isawu; ni ahayarana Isawu: Yewusi, Yalawu ni Koraa. ");
INSERT INTO mgh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Vano ala phi mamwene asaana a Isawu, asaana a Elifasi, ntthara na Isawu: Mwene Temaani, mwene Umari, mwene Seefu, mwene Keenasi, ");
INSERT INTO mgh_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","mwene Koraa, mwene Kayeta, mwene Maliki; ala phi mamwene yayanryawe Elifasi ilapo yo Etomi; asaana a Ata athiyana oolupale a Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ala pha asaana a Ruweli mwana a Isawu: Mwene Naate, mwene Seraa, mwene Samaa, mwene Misaa; ala phi mamwene yayanryawe Ruweli ilapo yo Etomi, asaana a Pasimati mwaara a Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ala pha asaana a Oholipama mwaara a Isawu: Mwene Yewusi, mwene Yalamu, mwene Koraa; ala phi mamwene akhumakhumile ni Oholipama, mwana a Anaa, mwaara a Isawu. ");
INSERT INTO mgh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ala pha asaana a Isawu ni mamwene aya; ule neehaniya Etomi. ");
INSERT INTO mgh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ala pha asaana a Seyiri nHorewu, yakhalakhala ilapo eyo: Lotanimu, Sopalimu, Sipeyonemu ni Anaamu, ");
INSERT INTO mgh_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Tiisomimu, Eserimu ni Tisaamu. Ala phi mamwene o mahorewu, asaana a Seyiiri ilapo yo Etomi. ");
INSERT INTO mgh_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ala pha asaana a Lotani: Hoti ni Homa. Mwanrokorawe Lotani eehaninya Timina. ");
INSERT INTO mgh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ala pha asaana a Soopali: Alvani, Manaate, Epali, Seefo ni Oona. ");
INSERT INTO mgh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ala pha asaana a Sipeyone: Ayaa ni Anaa; naaciya Anaa oonenenle iluusi co maasi oohiwelela ntakhwani, waahakhelawe apuuru a Sipeyone, athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ala pha asaana a Anaa: Tisomi ni Oholipama, mwana mwanthiyana a Anaa. ");
INSERT INTO mgh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ala pha asaana a Tisomi: Hentta, Eesipa, Itera ni Kerani. ");
INSERT INTO mgh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ala pha asaana a Eseri: Piila, Saava ni Akaa. ");
INSERT INTO mgh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ala pha asaana a Tisomi: Usii ni Araa. ");
INSERT INTO mgh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ala phi mamwene o mahorewu: mwene Lotamu, mwene Soopelamu, mwene Sipeyamu, mwene Anamu, ");
INSERT INTO mgh_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","mwene Tisomu, mwene Eserimu, mwene Tisomu; ala phi mamwene o mahorewu, toko caaryaya mamwene aya ilapo yo Seyiri. ");
INSERT INTO mgh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ala phi mamwene yathawaanle ilapo yo Etomi hinapaca ukhala mwene mwasaana o wIsirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","O Etomi aholamula Peelamu, mwana a Peyori, ni ncina noparasa awe naari Tinapa. ");
INSERT INTO mgh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ahokhwa Peela, ni nipuru nawe, ahothawala Yopapimu, mwana a Seraa, o Posira. ");
INSERT INTO mgh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ahokhwa Yopapi, ni nipuru nawe, aholamulula Husamu, olapo yo Matanamita. ");
INSERT INTO mgh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ahokhwa Husamu, ni nipuro nawe, aholamula Hatatemu, mwana a Peetati, aarakalihile a Miitiya ncoko wo Mwape; ncina noparasa awe nari Avite. ");
INSERT INTO mgh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ahokhwa Hatatemu, ni nipuro nawe, aholamula Samulamu, o Masireka. ");
INSERT INTO mgh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ahokhwa Samulamu, ni nipuro nawe, aholamula Sawulumu, o Reyopoti, wamoca ni mooloko Ufarati. ");
INSERT INTO mgh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ahokhwa Sawulumu, ni nipuro nawe, aholamula Paali-Hanamu, mwana a Akipori. ");
INSERT INTO mgh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ahokhwa Paali-Hanamu, mwana a Akipori, ni nipuro nawe, aholamula Hatarimu; ncina noparasa awe nari Pawu; ni na amwaarawe nari Meetapeli, mwana a Materete, mwana Min-saape. ");
INSERT INTO mgh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ala phi macina o mamwene a Isawu, toko caryaya malokwawe, mapuro aya ni macina aya: Mwene Timinamu, mwene Aluvamu, mwene Yetetemu, ");
INSERT INTO mgh_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","mwene Oholipamu, mwene Elaamu, mwene Pinomu, ");
INSERT INTO mgh_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","mwene Kinasimu, mwene Temamu, mwene Mipisarimu, ");
INSERT INTO mgh_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","mwene Makitiyelimu ni mwene Iramu. Ala phi mamwene o Etomi, toko caakhaliyaya ilapo aya. Ula phi Isawu, athumwane o annaEtomi. ");
INSERT INTO mgh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakopi ahokhala ilapo yo Kanaa wonwo athumwane warwelyaya weettakaca. ");
INSERT INTO mgh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ila phi yookhumelela ya nloko na Yakopi. Yusufu warinawe myakha khumi na saapa aahakhela inama na asunnawe. Anawaakavihera asaana a Pila na asaana a Silpa asaara athumwane ni anawaahimerya athumwane coonanara caapankaya asunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Vano, Israel aananfenta venci Yusufu woopwaha asaana akina ayo kontha ayareele athumwane anooluvanle, phimaana yahonttotthihera ihancu yoorekama. ");
INSERT INTO mgh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ni wacuwenlyaya asunnawe wiira phinfentiya venci na athumwane woopwaha mwana phi mwana, yahonramaca ni khayamulumana wo nnema. ");
INSERT INTO mgh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Vano aaholoha Yusufu nttora ni wahimenryawe asunnawe ale yahanca onrama wootepa. ");
INSERT INTO mgh_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ni aheerela: Nviriyane nttora olohilyaka: ");
INSERT INTO mgh_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Natthukaca ihayi co tiriku omattani. Vano ihayi aka yahonwa ni weemela ni ihayi cinyu nnyo cahorukurerya ni wooromela ihayi aka. ");
INSERT INTO mgh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ni asunnawe yahomwiirelaca: Vano, weva onoona wiira unaahala unilamula? Ni yahonrama tho woopwaha nlattu wo nttora ni itthu yahimilyawe. ");
INSERT INTO mgh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Wahoolo aaholoha tho nttora ni wahimerya asunnawe eeraka: Kiholoha tho nttora nkina. Ila ikwaha ila ncuwa, mweri ni itthoottwa khumi ni imoca cahokikhoromela. ");
INSERT INTO mgh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wahimenryawe athumwane na asunnawe, athumwane ayo yahoncaceraca yiiraka: Nttorani yooyo olohilyaa uyo? Maanaya wiira mi, anumwana na asunnaa ninwoworomela weva mpaka vathi? ");
INSERT INTO mgh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Phimaana asunnawe othene Yanaanramaca. Nanso athumwane yeera yuupuwelaka itthu iyo. ");
INSERT INTO mgh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Asunnawe Yusufu yahorwaa uhakhela inama ca athumwanaya vakhiviru nuuSikeni, ");
INSERT INTO mgh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ni Isirayeli ahomwiirela Yusufu: Toko cincuwelaa asunnaa anhakela inama vakhiviru ni nuuSikeni. Kimphela wuruma urwee wonwo. Yusufu ahaakhula eeraka: Aye. Kiheewa. ");
INSERT INTO mgh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Athumwane yahomwiirela: Urwee wonwo woone unari ukhaliyaka ratta, ukhuma asunnaa ni inama ciyo ni ukiwiihere ihapari. Yakopi anrumile nari nikuwa no Heporoni, ni Yusufu ahophiya uSikeni. ");
INSERT INTO mgh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Vano nlopwana mmoca ahomphwanya akomankomacaka muthakoni ni ahonkoha eeraka: We, unaavyani? ");
INSERT INTO mgh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu ahaakhula: Kinaavya asunnaka. Nkihimerye nipuro ninhakhelaya inama nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nlopwana ule ahaakhula: Ayo ahokhumaca va. Mi kiheewa yiiracaka nrwee uTotaani. Vano Yusufu ahaatthara asunnawe. Ni ahaaphwanya anari vakhiviru ni uTotaani. ");
INSERT INTO mgh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nanso ale yahomoonaca nttayi nttayi, ni hinaphiya Yusufu, yahovanela umwiiva. ");
INSERT INTO mgh_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ni yahohimeryana yiiraka: Hophiya nanttora uyo. ");
INSERT INTO mgh_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Vano nrwee nimwiive nunrihela nluusi, ni neereke hokhuriya ni nsene noone vano cinhalaya wiira ittora cawe nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Vano, wiiwa wawe Rupeni ahomananiha umwaakiha eeraka: Nihimwiive! ");
INSERT INTO mgh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ni aheera tho: Nhivuvihe iphome. Munrihele nluusi iri muthakoni mu, yooyo uyo nhinvaravare. Rupeni olumacenre coommo aavyaka mananna omwaakiha ni wiira anturusele wathumwane. ");
INSERT INTO mgh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Uphiya wawe Yusufu, asunnawe yahonrulaca ihancu awe, yoorekama eyo, ");
INSERT INTO mgh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nunvaraca nunrihela nluusi moohimasi. ");
INSERT INTO mgh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wookomacilyaya wiira alye yahoona nttayi nttayi mphwinko wa Annasumayili wakhuma uKiliyati. Ikamelo caya capakhinre ikaruma coonukhela, makhura o nrette ni makhura oonukhela caarwanaya Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yutta aheerela asunnawe: Ninhala uphwanyani namwiivaka nhimeehu uyo, nimaalanaka ukhwa wawe nwo. ");
INSERT INTO mgh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Nrwee naathumihere Annasumayili. Nihinhasare ula nhimeehu iphula ni niitho. Ni asunnawe Yutta yahokupali. ");
INSERT INTO mgh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wattamenryaya anamarontta Annasumayili o Mitiyani, asunnawe Yusufu yahonkumiha Yusufu nluusi ni yahathumihera Annasumayili ni ncurukhu siriini nunkusa Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rupeni warwelyawe unweha nluusi mmo, khaamphwanyile. Woona wawe wiira Yusufu khaawo ahaahula coowara cawe, ");
INSERT INTO mgh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","aturuwelaka waasunnawe ni aheera: Mmirawo uyo mmwe khaawo! Kinhala wiira cani? ");
INSERT INTO mgh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Vano yahomwiivaca napinkula nuruwyaa mphomeni ihancu ya Yusufu. ");
INSERT INTO mgh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ni yahorwaca waathonyera athumwanaya yiiracaka: Nihottotta ihancu ila kahiki khinakhala ihancu ya mwaninyu Yusufu? ");
INSERT INTO mgh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ni Yakopi ahoona wiira phi yeeyo ni aheera: Ila ihancu ila ya mwanaka! Nsene nihonhasara. Yusufu hokhuriya! ");
INSERT INTO mgh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Vano Yakopi ahaahula coowara cawe nuwara icakho ni ahomunlela mwanawe mahuku menci. ");
INSERT INTO mgh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Asaanawe othene, asilopwana na asithiyana yanawa ummaaliha, nanso aanakhotta umaalihiya nwo eeraka: Mena! Kinaahala wunla mpaka mmahiye nryawe mwanaka. Ni ahopwaherera umunlela. ");
INSERT INTO mgh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yooyo ukati uyo uWiciipitu, Annamitiyani yahontumiha Yusufu waPutifari, nhooleli a mayoorontta inupa ya Farawoo, mwene o Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yooyo ukati uyo, Yutta ahaahiya asunnawe ni ahorwaa ukhala inupa ya nlopwana mmoca eehaninya Hiira, ilapo yo Atulami. ");
INSERT INTO mgh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Vano Yutta ahomoona mwanthiyana mmoca nKanaa eehaninya Suuwa. Ule ahonkusa nuunthela. ");
INSERT INTO mgh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ni mwanthiyana ole ahorupala ni onyara mwana nuummaha ncina na Eeri. ");
INSERT INTO mgh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ahorupala tho irukulu, ahonnyara mwana nlopwana nuunvaha ncina na Onani. ");
INSERT INTO mgh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ahaakulela tho nuunyara mwana ni ahonvaha ncina na Seela. Yooyo annyanre nari uKisipi. ");
INSERT INTO mgh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Vano Yutta ahomwaverya Eeri, mwanawe oontthaara, nthiyana eehaninya Tamari wiira anthele. ");
INSERT INTO mgh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nanso Eeri, mwana oontthaara a Yutta, aari oohiloka wamiithoni wa Mwaneene Nluku, phimaana Mwaneene Nluku ahomwiiva. ");
INSERT INTO mgh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Vano Yutta ahomwiirela Onani: Ukhale nkelanupa a munnaa, wiira munnaa akhalane ipyo. ");
INSERT INTO mgh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nanso Onani wacuwenlyawe wiira asaana ayo khanhala ukhala awawe, ukati wathukumananawe amwaara a munnaawe, aarihakacela vathi wiira hinyarele asaana munnaawe. ");
INSERT INTO mgh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ni yaapankawe ile yaari yoonanara wamiithoni wa Apwiya, phimaana nuuyo yahomwiiva. ");
INSERT INTO mgh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Vano Yutta ahomwiirela Tamari: Weenaneleke unankhwelyaa uyo wapuwani wa athumwana mpaka wanhalawe wunnuwa mwanaka Seela. Kinawuvaha wiira unthele, kontha Yutta oolumacenre commo aaceraka wiira Seela ni uyo hikhwe toko cikhwilyaya asunnawe. Phimaana Tamari ahorwaa waathumwane. ");
INSERT INTO mgh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Anavinrene mahuku menci, yahokhwa amwaara a Yutta, yaari mwana a Suuwa. Wahoolo Yutta aheepisiha nrima ni ahorwaa ni mpwanawe Hiira, Nnatulami, waweha ahakheli awe okhontwaa oTimina. ");
INSERT INTO mgh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Vano ahohimerya Tamari wiira atiithyaa anrwaa oTimina uthikila mapururu okhontwaa. ");
INSERT INTO mgh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamari ahorula ikuwo coonankhwele ni aheettiyelela wiitho nwo ni nleso wiira hicuweliye, ni ahonkoma wankhora wo Nayimi, uri iphiro yo Timina, kontha ahoona wiira Seela honnuwa ni khanvahiya tho wiira akhale awannyawe. ");
INSERT INTO mgh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Vaavale Yutta umoona wawe Tamari amoonihile toko puuta, kontha anookhuneela ikhove awe iyo. ");
INSERT INTO mgh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yutta ahorwaa waryawe Tamari nuumwiirela: Nkawe, kinawuvekela kuuthukumanane. Kontha khacuwela wiira amwaara-mwanaka. Ni ule ahonkoha: Unhala ukivahani wowiira ukithukumanane? ");
INSERT INTO mgh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ule ahaakhula eeraka: Kinawuveleelihera ipuri yo muncicini mwaka. Ni Tamari aheera: Mwemesere itthu mpaka wanhalenyu uwiiha. ");
INSERT INTO mgh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Vano ule ahonkoha eeraka: Kemesereke isiyani? Ule ahomwaakhula: Ikanyero eyo, ni nleso naa nno ni nttontto uri mmatatani mwa uyo. Yutta ahonvaha calepenlyawe, nuunrupana mpaka unrupaliha. ");
INSERT INTO mgh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Wahoolo Tamari ahonwa nuurula nleso nawanryawe, ni ahowara ikuwo coonankhwele cawe. ");
INSERT INTO mgh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yutta ahonvaherera mpwanawe Nnatulami wiira oopole citthu cemesenryawe mmatatani mwa nthiyana ole, nanso khaamphwanyile. ");
INSERT INTO mgh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hiira ahaakoha alopwana o yoole nttetthe ole eeraka: Ri vayi namararuwa nonkomesa vakhiviru waya iluusi piili ciri ni iphiro yo Nayimi? Ayo yahomwaakhulaca: Mu mmwani mu khanirina namararuwa. ");
INSERT INTO mgh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Vano uyo ahohokoleela wa Yutta ni ahomwiirela: Akimphwanyile. Uhiya commo, atthu o yoole nttetthe ule yiinre nwo khaawo nthiyana namararuwa. ");
INSERT INTO mgh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yutta aheera: Mweeco, ahalaneke cennyo cinhiyenryaka nyo. Akintthuna wiira nitarawyaace. Maana mi kahoovaherera ila ipuri ila wiira wanvahe, nanso we khumphwanyile. ");
INSERT INTO mgh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cinavinre myeeri miraru, Yutta ahohimerya wiira: Tamari aheetta uluva ni horupala irukulu. Vano Yutta aheera: Akumiheriye vate ni apahiye. ");
INSERT INTO mgh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ukati wakumiheriya awe vate wiira apahiye, Tamari aholeehera nhupi wa amaathi awe eeraka: Kirupalihile phi mwaneene nnya citthu nnya. Ni ahopwaherera eeraka: Nkoonani nnya, ni mmwaavye mwaneene ila ikanyero ila, nna nleso nna ni ula nttontto ola. ");
INSERT INTO mgh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Vano Yutta ahocuwela citthu nnyo ni aheera: Amwaara-mwanaka ayo ahaana isariya yookivikana mi kontha kinoohavaha mwanaka Seela. Ni khaathukumananne tho. ");
INSERT INTO mgh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Vano waphiilyaya ukati wooyara, wahoonnyaa wiira haana mavatta mmirimani mmo. ");
INSERT INTO mgh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Wayaraawe va, mmoca uyo ahokumihera ntata nawe vate ni nthiyana mayooyariha ahonvara moono uyo nuuntthuka nluuci nookhwiila, eeraka: Ula phi oopacera. ");
INSERT INTO mgh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ukati waturusa awe mwana ule ntata nawe nno, nhimaawe ule phaphovawe nuupacera uyaryaa, ni nthiyana mayoyariha aheera: Uphwanyile cani ikhato yoovira? Ni ahovahiya ncina na Peresi manaaya wiira ikhato. ");
INSERT INTO mgh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Wahoolo ahoyarya munnaawe, natthukiye mmoononi nluuci nookhwiila, ni ahovahiya ncina na Seera. ");
INSERT INTO mgh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusufu ahorwaaninya Wiciipitu. Wonwo Putifari wanthumilyawe Yusufu mmatatani mwAnnasumayili. Putifari ari nhooleli a mayoorontta inupa ya Farawoomu, mwene o Wiciipitu, ahonthuma mmatatani mwAnnasumayili yammwiihile. ");
INSERT INTO mgh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mwaneene Nluku ari ni Yusufu, ni uyo anareeriya venci, nuupwaherera ni aakhala wapuwani wa nkunya awe munnaciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Putifari ucuwela wawe wiira Mwaneene Nluku ari ni Yusufu ni yaammunnuwiha nuureeriha miteko cothene cavarawe, ");
INSERT INTO mgh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ni ahoncivela Yusufu mpaka onvaha ukhala nlamuli o wapuwani wawe wothene. Putifari ahonhiyera Yusufu ulamula wapuwani wawe wothene ni citthu cothene caarinawe. ");
INSERT INTO mgh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ukhuma ukati wanhiyenryawe ulamula wapuwani wothene ni citthu cothene, Mwaneene Nluku ahovaha iparakha inupa ya munnaciipitu, mwanlattu wa Yusufu. Iparakha ca Mwaneene Nluku cahomwareela mwa citthu cothene carinawe Putifari, ukhuma wapuwani mpaka umattani. ");
INSERT INTO mgh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Vano, ahohiya citthu cothene carinawe, mmatatani mwa Yusufu, ni khaarina isukuli weetthu phi itthu, aawehererya ulya paahi. Yusufu aari ooreera ni aancivela na atthu. ");
INSERT INTO mgh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wakhanlyawe ukati vakani, amwaara a nkunya awe yahanca unthokoca numwiihana yiiraka: Uwe wakirupane! ");
INSERT INTO mgh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nanso ule ahokhotta ni aheera: Nkunya aka khanasukuli weetthu phi itthu ciri wapuwani ni cothene cirinawe hiile mmatatani mwaka. ");
INSERT INTO mgh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Khaawo wapuwani va ookipwaha mi, ni khiiwo ikateelihilyawe, nanso nyu paahi, kontha amwaarawe. Kaahala upankelani itthu yoonanara toko ila, nuunkosera Nluku? ");
INSERT INTO mgh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Toko coo, ale yaanankhanyereriha Yusufu khula nihuku, nanso uyo anawakhotta ni khaatthuna waattamanana. ");
INSERT INTO mgh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nihuku nimoca ahokela mpani wiira avare miteko cawe ni yooyo ukati uyo, khaariwo ntthu hata mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Vano ale yahovara ikuwo awe ni yahomwiirela tho: Nrwee, ukirupane! Nanso uyo ahokhuma mpani mmo ni waahiyera ikuwo eyo mmatatani mwaya. ");
INSERT INTO mgh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Waatthawawe va, yahoona wiira hohiya ikuwo awe mmatatani mwaya, ");
INSERT INTO mgh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ni yaheehana akarumeya ni weerelaca: Nkoonani! Ula Nheperewu ula niwiiheriyehu ula uwa uniruwana! Ule hokela mu ni aphavela ukirupana, nanso mi kihokhuwela. ");
INSERT INTO mgh_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Wakiwiilyawe kikhuwaka, hokihiyera ikuwo awe nuukhuma mpani mmo. ");
INSERT INTO mgh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Vano ale yahosunka ikuwo eyo mpaka wawilyawe nkunya uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Vano yahaakulela uttonka itthu yakhumile yiiraka: Ile ipottha yo uHeperewu ile iniwiihenryaa eyo, yahokiwela mi ukiruwana. ");
INSERT INTO mgh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nanso wakhuwenlyaka wiira kaakuveliye, uyo hokihiyera ikuwo eyo nutthawa. ");
INSERT INTO mgh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wewilyawe nkunya awe itthu yattonkaya amwaarawe yiiraka: Coo phikipankilyaya ipottha iyo. Ahorusiya. ");
INSERT INTO mgh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ahoruma wiira arweeliye Yusufu ni ahovonyeriya nkalaposo mwatthukeliyaya anantthukiya a amwene. Yusufu ahokhala nkalaposo, ");
INSERT INTO mgh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","nanso Mwaneene Nluku ari nuule, yahomweettiha nnema, mpaka wiiwanana ni nhooleli onkalaposo. ");
INSERT INTO mgh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Phimaana nhooleli onkalaposo ahomvaha Yusufu iyuulupale ya anantthukiya, ni yooyo phakhulela citthu cothene cakhumelela nkalaposo mmo. ");
INSERT INTO mgh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Nhooleli khaarina masukuli ni Yusufu, kontha Mwaneene Nluku ari ni Yusufu ni yahonvaha iparakha wo miteko cothene cavarawe. ");
INSERT INTO mgh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Unavinre ukati vakani, hutumu ni mayamikatthe o wamwene o Wiciipitu, yahonkosera nkunya aya, mwene o Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farawoo ahorusiya na ahooleli awe ale, nhooleli o mahutumu ni nhooleli o mayamikatthe, ");
INSERT INTO mgh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ni aholamula utthukelaciya uwannyawe nhooleli o mayoorontta, nkalaposo mwaryawe Yusufu. ");
INSERT INTO mgh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nhooleli o mayorontta ahiile anantthukiya mmatatani mwa Yusufu ni eera aawehawehaka, ni yahokhala ukati vakani nkalaposo. ");
INSERT INTO mgh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Vano yaholohaca hutumu ni mayamikatthe a mwene o Wiciipitu, yatthukeliye nkalaposo. Khula ntthu aholoha nttora nawe, oyeeli uhiyu mmoca yooyo ni khula nttora wahaana mataphuleleliyo aya. ");
INSERT INTO mgh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu warwawe waweha wicisu, ahoona wiira yanacukulaca. ");
INSERT INTO mgh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Phimaana ahaakoha akhuulupale a Farawoo, ni ale yaatthukiye wawaanyawe nkunya aya, eeraka: Nlattuni nyu ilelo nkhalaka oohitta? ");
INSERT INTO mgh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ale yahaakhulaca yiiraka: Nihaana nttora ehu ni khaawo oonitaphulela. Yusufu aheerelaca: Utaphulela nwo khunakhala wa Nluku? Nkihimerye mittora nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Vano hutumu ahonttonkela Yusufu nttora awe uyo: Munttorani mwaka kihoona mwiri unari vakhiviru ni mi, ");
INSERT INTO mgh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ni mwiri uyo wahaana miritta miraru. Ni uyo wahophuwa, mpaka ukhalana ithutu ni wiima ni uttokottha mavareene. ");
INSERT INTO mgh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ikoomisi ya Farawoo yaari mmatatani mwaka. Kahokusa cowiima nnye ni waamela nkoomisini mwa Farawoo nuumvaha mmatatani mwawe. ");
INSERT INTO mgh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu ahomwiirela: Mataphuleleliyo aya pha ala: Miritta miraru nnyo phi mahuku mararu. ");
INSERT INTO mgh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nhina wo mahuku mararu, Farawoo nowoowusa muru aa, ni nowowuutaphula ni wuuhokolosera nteko aa ni we ummomvaha ikoomisi mmatatani mwawe toko caalemalenlyaa umpanka waarya hutumu awe. ");
INSERT INTO mgh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ukiviriyane cothene caweettelaka ratta ukuupuweleleke mi, wakihimye wooreera wa Farawoo nwo, wiira kikhume nkalaposo mu. ");
INSERT INTO mgh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Maana kiwiihiye utthuna nuuhitthuna, ukhuma ilapo yo maheperewu, ni ciicammo, uno khiiwo ipankilyaka yooreerela utthukeliya nkalapooso mu. ");
INSERT INTO mgh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Weewilyawe muulupale omayamikatthe mataphuleleliyo omaana ale, ahomwiirela Yusufu: Ni mi ciicammo kihaana nttora aka: Wamuru waka cahaawo itthuttu tthaaru co mikatthe cootteela. ");
INSERT INTO mgh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Itthuttu yooculu iyo cahaawo mikatthe co khula nnanna ni cooviyola cikina caancivela Farawoo, nanso asaanuni yaanaawa ulya ntthuttuni yarinaaka wamuru iyo. ");
INSERT INTO mgh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ni Yusufu aheera: Ala phi mataphuleleliyo aya: Itthuttu tthaaru nnyo, phi mahuku mararu. ");
INSERT INTO mgh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nhina wo mahuku mararu, Farawoo nowowutthukacera ni wuuthomya mmwirini, ni asaanuni ammoolya irutthu aa. ");
INSERT INTO mgh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Waphilyaya nihuku noneeraru, naari nihuku napiiherawe Farawoo myakha ceyarelo ni ahaalattula mayoonlaka othene ni waavaha yoolya. Wamiithoni waya atthu ale ahaawusaca myuru nhooleli o mahutumu ni nhooleli o mayamikatthe. ");
INSERT INTO mgh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ahonhokolosera nteko awe hutumu, mpaka wakhanlyawe tho yoole mayonvaha ikoomisi Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Nanso, ahoruma wiiviya wootthukaceriya nhooleli o mayamikatthe toko Yusufu caahimenryawe muutaphulelani nttora. ");
INSERT INTO mgh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Paahi, nhooleli o mahutumu ule khamuupuwenle tho Yusufu, mpaka ahonliyala. ");
INSERT INTO mgh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wumaleloni wo myakha miili, Farawoo ahaana nttora awe. Ule anoweemela nceresere mooloko Niilu. ");
INSERT INTO mgh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Vano cahokhumaca mmoolokoni mmo imope saapa cooreera ni cooneneva, caalya nceresere mooloko. ");
INSERT INTO mgh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Wahoolo cahokhuma mmoolokoni mmo imope tho saapa, coonanaraca ni cowoottaca, carweele utakaneela ni cikhunanaya nnye nceresere mooloko. ");
INSERT INTO mgh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Vano imope coonanaraca nnyo ni cowoottaca nnyo cahokhura imope cooreeraca nnyo ni cooneneva nnyo. Vano Farawoo ahonwa. ");
INSERT INTO mgh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ahohokoleela tho urupa ni aholoha tho nttora nikina. Miphapa saapa, cuulupale ni comaana, coocara ni cooreera, cahothapuruwa ntathi mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Vano cahophuwela tho miphapa cikina saapa, cooyeevaca ni coowuuma mu ncasini mmo, caapahiye ni iphyoo yaakhuma wuuthakoni. ");
INSERT INTO mgh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Miphapa cooyeevaca nnyo cahomirya miphapa saapa coocara ni comaana nnyo. Vano Farawoo ahonwa, ni ahoona wiira aari nttora. ");
INSERT INTO mgh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wicisuru, cinancanre cowuupuwela coonkukuryeeha, ahoruma wiihanaciya mayaahako ni mayoocuwelaca o Wiciipitu ni ahaattonkela mittora nnyo, nanso khaawo oonrye utaphulela. ");
INSERT INTO mgh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Vano nhooleli o mahutumu ahomwiirela Farawoo: Ilelo phinoopuwelaka caaliyanlyaka. ");
INSERT INTO mgh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ikwaha imoca Farawoo wahorusiya na arumeyi aa eeli ni waholamula otthukiya mi ni nhooleli omayamikatthe owannyawe nhooleli omayoorontta. ");
INSERT INTO mgh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Uhiyu mmoca, khula ntthu wa hi, aholoha nttora ni khula nttora wahaana mataphuleleliyo aya. ");
INSERT INTO mgh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wahoreera! Ahaawo ni hi mommo mmirawo mmoca Nheperewu, karumeya a nhooleli omayoorontta. Nahonttonkela cennye mittora cihu nnye ni ule ahotaphulela, anihimeryaka wo khula ntthu manaaya nttora awe. ");
INSERT INTO mgh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ni cothene cahokhumelela toko canihimenryawe. Mi kihoturuseliya nteko aka ni nkina uyo heeviya wootthukeleliya. ");
INSERT INTO mgh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Farawoo ahoruma wiihaninya Yusufu eeraka: Awiihiye wowakuvyaa akhumihiyaka ukalapooso. Nametthileene irori nuuwara ikuwo cikina aheethoonyera wa Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farawoo ahomwiirela Yusufu: Kahaana nttora nimoca ni khaawo noorya utaphulela. Nanso kiheewa wiira we, weewaka nttora unawoorya utaphulela. ");
INSERT INTO mgh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu ahomwaakhula: Iyo khinkhuma ni mi, nanso Nluku nawuvahani nyu ntaphulelo no nnema. ");
INSERT INTO mgh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Vano Farawoo ahonttonkela nttora ule Yusufu: Kiholoha kineemenle nceresere mooloko Niilu. ");
INSERT INTO mgh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Cahokhuma mmoolokoni mmo imope saapa cooreera ni cooneneva, caalya ni mooloko uyo. ");
INSERT INTO mgh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Wahoolo cahokhuma cikina tho saapa coonanara ni cowootta. Akinoona imope coonanara mwiilaponi mothene. ");
INSERT INTO mgh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Imope coonanara ni cowootta nnyo cahokhura imope saapa cooneneva nnyo cakhumelenle woopacera nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Hata cinakhuunreene, khacacuwannyaa wiira ciholya canvira cikhalaka yooyo nkhalelo uyo. Vano kahonwa. ");
INSERT INTO mgh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Wahoolo kaholoha tho nttora nkina. Kahoona miphapa saapa, coocara ni cooreera, cathapuruwa ntathi mmoca. ");
INSERT INTO mgh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Vano cahophuwela tho saapa coonyaala ni cooyevaca, cowumihinya ni iphyoo yooviha yakhuma muuthakoni. ");
INSERT INTO mgh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Miphapa cooyevaca nnyo cahomirya miphapa saapa comaana nnyo. Kihaattonkela iyo acuweli, nanso khaawo oonrye utaphulela. ");
INSERT INTO mgh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Farawoo, mwarina nttora mmoca, eera phi Yusufu. Nluku hoohimeryani Farawoo, itthu imphavelawe upanka. ");
INSERT INTO mgh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Imope saapa cooreera nnyo, ciri myakha saapa ni miphapa saapa comaana nnyo, ciicammo ciri myakha saapa, va uri nttora mmocaru. ");
INSERT INTO mgh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Imope saapa cowootta ni coonanara nnyo cakhumelenle uttuli waya cikina nnyo, ni miphapa saapa cohicara ni coomihiye ni iphyoo yooviha yakhuma muthakoni, ciri myakha saapa. Cinhala ukhala myakha saapa cotala. ");
INSERT INTO mgh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Phi ciicammo toko cuuhimenryaka Farawoo, Nluku hoothoonyera itthu inhalawe upanka. ");
INSERT INTO mgh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Myaakha saapa cooruweriya cihanle vakani uwa ilapo yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Wahoolo cimmowa myakha saapa cotala. Vano ukati wothene wooruweriya ummooliyaliya, kontha itala eyo immohasara ilapo yothene. ");
INSERT INTO mgh_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Itala inhala uwa immokhala yootepa, woovikana ukati waruweriye khunhala wuupuweleliya tho mwiilaponi. ");
INSERT INTO mgh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nttora uhowela imaara piili Farawoo, kontha itthu ila iholakeliya ni Nluku ni immwa yakuvyaka. ");
INSERT INTO mgh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","We Farawoo umphavele nlopwana oocuwelaca ni unhele ulamulela ilapo yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Farawoo waahele atthu oowehaweha, anhala utotokaniha mphantte woneethanu wo coolya co Wiciipitu nhina wo myakha saapa cooruweriya nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ayo anlamuliya utotokaniha yoolya yootosa inhalaya wooryaniha ukati wooruweriya uyo, nuusunka itiriku, ni we Farawoo unlamuliya uwehawehaka ni usunkiha mmakhupini ummasittatti. ");
INSERT INTO mgh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yeeyo yoolya iyo inhala usunkiya eyo, phinhala ulaminya myakha cotala cinhala uwa mWiciipitu mu, wiira ilapo ihihasaryee ni itala. ");
INSERT INTO mgh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ala moopuwelo ala yahoncivela Farawoo na anamiruku awe othene. ");
INSERT INTO mgh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Phimaana Farawoo ahaakoha: Nanso ninaahala umphwanya ntthu toko ula ookhalana Nnepa wa Nluku? ");
INSERT INTO mgh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farawoo ahomwiirela Yusufu: Toko ciinryawe wowuthonyera Nluku citthu nnya cothene, khaawo ntthu annkhili nuucuwelaca toko we. ");
INSERT INTO mgh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","We thi we unhala ulamulela inupa aka, ni uneethi aka wothene unhala wiiwelela nlamulo naa, nanso wahiceni, thi mi muulupale wowuupwaha we. ");
INSERT INTO mgh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ni Farawoo ahopwaherera: Kinawuuvaha nenna vaa ulamulela ilapo yo Wiciipitu yothene. ");
INSERT INTO mgh_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Wahoolo, Farawoo ahonrula nnikokhoni nneela antthittelawe nuummwariha Yusufu nnikokhoni mwawe. Aholamula uwarihiya ihaancu yoovevyaala, ni ahommwariha nkuhu wowooru nsiko. ");
INSERT INTO mgh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ni ahommweliha ikaaro awe yonayeeli yo omwene ni uhoolo wawe yahaawo anamakhuwela yeera: Nhule iphiro. Yusufu heesiya ulamulela ilapo yothene yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farawoo ahomwiirela tho Yusufu: Mi Farawoo, nanso wohinuulumo naa, khaawo nolamuliya upanka itthu phi itthu mWiciipitu mothene. ");
INSERT INTO mgh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farawoo ahommaha Yusufu ncina na Safenate-Paneya ni ahommaha nthiyana wiira akhale mwaarawe, Asenate, mwana a Potifera, nhooleli osataka yo Oni. Wahoolo Yusufu ahorwaa wonoona ilapo yothene yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu aarina myakha talathini ceyarelo wapacenryawe unvarela nteko Farawoo, mwene o Wiciiputu. Uyo ahonhiya Farawoo ni ahorwaa woonoona ilapo yothene yo Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ukati wo myakha saapa cooruweriya, ilapo yothene yahaana yoolya yinci. ");
INSERT INTO mgh_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu ahototokaniha yoolya yalikeleliye usunkiya, yo myakha saapa cooruweriya Wiciipitu ni ahosunka mmakhupini ummaparasa khula iparasa ahototokaniha itiriku yo mmattani. ");
INSERT INTO mgh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Commo, Yusufu ahosunka itiriku yinci, toko nhaava wompharyaa. Uyo ahohiya waalikela yoolya iyo kontha khaawo tho oorya uphima mwanlattu wowinciva. ");
INSERT INTO mgh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Cihinaya uphiya myakha cotala, Asenate, mwana a Potifera, nhooleli osataka yo Oni, ahonnyarana Yusufu asaana eeli. ");
INSERT INTO mgh_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Oopacera uyo, Yusufu ahommaha ncina na Manasesi, eeraka: Nluku hokiliyaliha mahuviho aka othene ni inupa yothene ya apaapa. ");
INSERT INTO mgh_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana onayeeli ahommaha ncina no Farayimi, eeraka: Nluku hokipanka ocayra ilapo yahuvaka. ");
INSERT INTO mgh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Commo, cahophiya ummaleloni myakha cooruweriya Wiciipitu, ");
INSERT INTO mgh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ni cahopacera myakha saapa cotala, toko Yusufu wahoolelihenryawe uhimya. Yahaawo itala ilapo cothene, nanso ilapo yo Wiciipitu yahaawo yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wancenryaya uvola itala ilapo yothene yo Wiciipitu, uneethi wahanca unlepela Farawoo yoolya. Uyo ahaakhula atthu o Wiciipitu, eeraka: Nrwee wa Yusufu ni mpanke inhalaawe wuuhimeryani. ");
INSERT INTO mgh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Wamwaryenlyaya itala ilapo cothene, Yusufu aholamula uhuliya makhupi ni ahopacera utumiha itiriku, aatumiheraka atthu o Wiciipitu, maana itala yahotepa. ");
INSERT INTO mgh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ni atthu ookhuma ilapo cothene, yammwa Wiciipitu wiira yathume itiriku wa Yusufu, kontha itala yaanvira itepaka ilapo cothene. ");
INSERT INTO mgh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakopi Wacuwenlyawe wiira ihawo itiriku Wiciipitu, aheerela asaanawe: Isiyani umakelaka uwehanaca paahi? ");
INSERT INTO mgh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Aheera tho: Kiheewa yiiriyaka ihaawo itiriku Wiciipitu. Nrwee wonwo mwanithumele itiriku wiira nipwaherere ukumi ni nihikhwe itala. ");
INSERT INTO mgh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Toko coo, asunnawe khumi a Yusufu yahorwaaca Wiciipitu uthuma itiriku. ");
INSERT INTO mgh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakopi khantthunihile Pencamii, nhimaawe Yusufu, wiira aatthukane ikwaha, kontha aanawoova unkhumelela itthu yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Asaana a Isirayeli yaari na atthu akina yarwaca uthuma itiriku, nlattu wotala yavonnle uKanaa. ");
INSERT INTO mgh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yusufu aari nlamuli olapo yo Wiciipitu ni yooyo phaatumihera itiriku atthu othene. Phimaana uphiya waya asunnawe Yusufu yahomuramela mpaka uphiya vathi. ");
INSERT INTO mgh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Woona wawe, Yusufu ahaacuwelela asunnawe, nanso aakhanle toko khaacuwenle ni ahoopopiha eeraka: Nyu nnokhumakhuma vayi? Yahaakhulaca: Ninkhuma ilapo yo Kanaa naawile uthuma yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu ahaacuwela asunnawe, nanso ayo khayancuwelacile. ");
INSERT INTO mgh_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Vano ahoopuwela ittora calohilyawe nari na asunnawe ni aheerela: Nyu nri mayoohottela! Mwawile uhottelaca ilapo ehu ila wiira ncuwele nipuro nookhwyaa. ");
INSERT INTO mgh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ale yahaakhulaca: Mena, nkunya. Asaanenyu yawile uthuma yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Hi othene, athumwanihu ari amoca. Asaanaa ari atthu omaana, khaanakhala oohottela. ");
INSERT INTO mgh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nanso Yusufu ahaakhanyereriha eeraka: Mena! Nyu mwile uhottela wiira moonenele nipuro nookhwyaa ilapo ehu ila. ");
INSERT INTO mgh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ni ale yaheeraca: Asaanaa yaari khumi neeli, othene athumwanaya ari amoca ilapo yo Kanaa. Itthyaako eyo ihanle uwaani na athumwanaya ni nkina uyo hokhwa. ");
INSERT INTO mgh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu ahaakulela eeraka: Phi vaava kihimilyaaka va. Nyu nri mayoohottela. ");
INSERT INTO mgh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nyu nnaahala ulawihiya. Kinalupela mwancina na Farawoo, nyu mu khannokhuma, mwahimmwaneke uno mwanhimenyu eetthyako uyo. ");
INSERT INTO mgh_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Munrume mmoca anrweele mwanhimenyu uyo vano akina vaa nhotthukiya. Commo phinhaleehu ucuwela wiira cinhimyenyu nnyo ciri citthu ceekhweeli atthuna cowoothiya. Cahikhaleke ceekhweeli, kinalupela mwancina na Farawoo wiira wanaahala ucuwanyaa wiira nyu khweeli nri atthu oohottela! ");
INSERT INTO mgh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ni ahaatthukela nkalapooso mahuku mararu. ");
INSERT INTO mgh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Nihuku noneeraru Yusufu aheerelaca: Mi kinamoova Nluku. Mwapheela woopwaa, mpanke coo: ");
INSERT INTO mgh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mwakhala wiira nyu atthu omaana, munhiye munniinyu mmoca nkalapooso mu. Vano akina vaa nturuwaceke nuukusaka itiriku wiira mwalye uwaani. ");
INSERT INTO mgh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Nkiwiihere vaa nhimeenyu eetthyako uyo wiira acuwannyee moolumo enyu yakhala wiira eekhweeli ni nyu phinhaleenyu uhikhwa. ");
INSERT INTO mgh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ayo yahotthuna upanka yahiminye eyo ni yaheerelana: Khweeli va ninattarusiya mwanlattu weetthu impankileehu nhimeehu uyo. Naammoonaka caacukula awe, ni waanisonttelelawe vaa, wiira ninhiye nkumi, nanso khanaantthunenle. Phimaana uniphwanyaka uno utapana uno. ");
INSERT INTO mgh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruupeni ahaakhula: Akoohimenryeni wiira nhinhuvihe mmirawo uyo, nanso nyu khamwatthunne ukiiwa! Vano ninlamuliya waakhulela iphome awe eyo. ");
INSERT INTO mgh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nanso ale khayaacuwela wiira Yusufu naweewa, kontha oolumana ni ntthu aataphulela ni nuulumo naya. ");
INSERT INTO mgh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Vaavale Yusufu ahothama ni wunla. Vano ahohokoleela tho ni ahoolumaca wiira atthukiye Simeyoni, othene amoonacaka. ");
INSERT INTO mgh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Wahoolo Yusufu aholamula wiira icarihiye itiriku mmirupani mwaya mmo ni ituruseliye ipheeta yo khula ntthu munrupani mwawe, ni avahiye iphika coovira alyaaka. Ni commo wahopankiya. ");
INSERT INTO mgh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ale yahopakhira mirintti caya co tiriku mwa apuuru aya nuukhumaca. ");
INSERT INTO mgh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nipuro naamakilyaya nlattu wo wiileliya, mmoca uyo ahotthukula nrupa awe wiira ankumihe nankanka oonliha puuru awe, ni ahoona ipheeta umalakuni wonrupa awe. ");
INSERT INTO mgh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ni aheerela asunnawe: Kihoturuseliya ipheeta aka eyo. Ila mu munrupani mwaka mu. Yoovaka wanrimani waya ni attettemelaka yaheerelana: Isiyani ila Nluku inipankilyawe ela? ");
INSERT INTO mgh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Waaphilyaya wathumwanaya, ilapo yo Kanaa, yahohimyaca cothene caakhumelenle, yiiraka: ");
INSERT INTO mgh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Nlopwana mwaneene ilapo eyo honuulumacera ni honihela ukhala hi atthu oohottela. ");
INSERT INTO mgh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nanso hi nihonroromeliha wiira khanihiwena atthu oohottela niri atthu eekhweeli. ");
INSERT INTO mgh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Niheera tho wiira naari asaana khuumi neeli athumwanihu ari amoca ni mwana mmoca uyo hokhwa, ni eethyako uyo ri na athumwanihu uKanaa. ");
INSERT INTO mgh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Vano nlopwana mwaneene ilapo eyo honiirela: Nrwee noone mwakhala atthu eekhweeli: Nhimeenyu mmoca nolamuliya uhala vaava ni mi. Akina ayo aturuweke ni akuseke yoolya yalyeke uwaani na akhwaya. ");
INSERT INTO mgh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nanso mwakiwiihere nhimenyu eetthyako uyo phinhalaaka ukupali mi wiira nyu atthu omaana ni khannakhala mayoohottela. Vano phinhalaka wuhokoloserani munninyu uyo ni wutthuniherani upanka marontta ila ilapo ela. ");
INSERT INTO mgh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Weetthiyaaya mirintti nnyo, wo khula nrintti wahophwanyinya nhukho woocara ipheeta. Yakopi na asaanawe woonnyaya mihukho nnye, yahoovaca. ");
INSERT INTO mgh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ni Yakopi aheerelaca: Nyu nnakimalihera asaanaka ayo! Kihanle wohi Yusufu, nnavaa kiri wohi Simeyoni, ninlelo nna nnopheela unkusa Pencamii? Cothene cinkikhuma mi! ");
INSERT INTO mgh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Vano Rupeni aheerela athumwane: Kahinturuwaneke Pencamii uyo, mweevakace asaanaka oyeeli khaweetthu. Nkihiyere Pencamii uyo, thi mi kinhala unwacawaca. ");
INSERT INTO mgh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nanso athumwane yahaakhula: Mwanaka uyo khannonkusa. Munnawe hokhwa. Uyo nna phihanle. Itthu phi itthu yoonanara inhala unkhumelela eyo munkwahani mmo, vano phinhalenyu uvitha ipwi caka nnyo mmahiye kinari ni icuku. ");
INSERT INTO mgh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Itala yaanatepa mwiilaponi mmo. ");
INSERT INTO mgh_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Vano wamanlyaya itiriku yothene yawiihilyaya asaana a Yakopi akhumanaka Wiciipitu, athumwanaya yaheerelaca: Nhokoleelace ni mwathume tho yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nanso Yutta aheerela: Nlopwana uyo ahonileehera venci eeraka: Nhihokoleelace waryaaka wohimmwiiha nhimenyu uyo. ");
INSERT INTO mgh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mwanivahaka nhimehu uyo ninrwaanaka, ninaarwa, ninkoothuma ni wuthumelani yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nanso mwahinivaheke ninrwanaka, khaninrwaa, kontha nlopwana uyo hoolumacile coo: Nhihokoleelace waryaka kahiki mwammwiihaka nhimenyu uyo. ");
INSERT INTO mgh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isirayeli ahokoha: Nkipankenleni yoonanara toko ila, munhimeryaka nlopwana uyo wiira nhaanaca nhimenyu nkina? ");
INSERT INTO mgh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ni ale yahomwaakhulaca: Uyo honikohakoha hi na amucihu. Ni honikoha tho eeraka: Athumwaninyu nanlelo ahaawo akumi? Nyu nhaana nhimenyu nkina? Hi nimwaakhunle paahi itthu yanikohawe. Nahala ucuwela cani wiira nohala uniirela mummwiihe nhimenyu. ");
INSERT INTO mgh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Vano Yutta ahomwiirela Isirayeli athumwane: Munhiye mmirawo uyo kinrwaane, ninarwaca, wiira nyu ni hi na asaanehu nikhale akumi ni nihikhwe. ");
INSERT INTO mgh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ni kinawiilupelela veekhaka unvarelela uyo. Nkiheleke mi ukhala mayonvarelela mwana uyo. Kahinturuwaneke mpaka wuthonyerani wamiithoni winyu, phi mi cinhala ukikhalela ikhirini nnyo wamiithoni winyu ukati wothene. ");
INSERT INTO mgh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Toko cinoonenyu, yiiriyaka khanapicile cono ninarwele ni ninaturuwile imaara piili. ");
INSERT INTO mgh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Vano Isirayeli, athumwane Yutta, yahomwiirela: Wakhala wiira phinhalaya wiirannyaa, haya wakhale ciicammo. Nhele munrupani mwinyu mmo coolya comaana co mwiilaponi mwihu mu ni munkusere yooyo nlopwana uyo; makhura onrette vakani, urawo vakani, citthu coonukhela cikina ni miira, cowiima ni amentowa: ");
INSERT INTO mgh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nkuse ipheeta yoopitaanihinya, imaara piili piili ni nhokolose ipheeta yaheliye munrupani mwinyu waturuwenyu wa malakuni wo nrupa enyu. Kahiki itthu iyo ikhumelenle nlattu woovonyanihinya. ");
INSERT INTO mgh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Munkuseke nhimenyu uyo ni nhokoleele wa nlopwana uyo. ");
INSERT INTO mgh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nluku Okuru-Cothene awooneleni ikiriri iriyari ya nlopwana uyo wiira ootthunihereni onturuwana nhimeenyu Pencamii ni nhimeenyu nkina uyo. Mi, kakhalaka woohasaana, kinakhalaka. ");
INSERT INTO mgh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Vano asilopwana ale yahorwaa ni yahokhuruwela Wiciipitu anakusileene coovaha, ipheeta yoopitaanihinya piili piili ni Pencamii, ni yahorwaa wa Yusufu. ");
INSERT INTO mgh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu, wamoonnyawe Pencamii na asunnawe, ahomwiirela nhooleli owapuwani wawe: Waakuse alopwana ala owaanyaka, wamwiive mwanama ni onlokihace, kontha ayo yoolya yoothana anhala ulya ni mi. ");
INSERT INTO mgh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ni ule ahopanka yahimeriyawe ni ahaakusaca mpaka inupa ya Yusufu. ");
INSERT INTO mgh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ayo yahoovaca wakusiyaya arwaaninyaka owaanyawe Yusufu ni yahoopuwela yiiraka: Niwiiheriye va nlattu wopheeta ihokoloseriye munrinttini mwihu ikwaha yoopacera: Uyo nophavela onittarusa, onihuviha, onipanka ipottha nuukusa inama cihu nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Phimaana, yahorwaa wa nhooleli onupa ya Yusufu ni yahomwiirela wakelaya wankhora. ");
INSERT INTO mgh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Uviriyane, yoowe nkunya! Ikwaha yoopacera yawilehu va khweeli nawile othuma yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Nanso nipuro neemenlehu wiira nimake, nahotthukula mirintti cihu ni utthukula woono khula ntthu wakhalacenrehu ahophwanya ipheeta yawiihilyawe uwaani yoolikaneene. Phimaana nihohokolosa, ");
INSERT INTO mgh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","nuwiiha ipheeta ikina wiira nithume yoolya. Khanincuwenle ntthu nihelenle ipheeta mmirinttini mwihu mmo. ");
INSERT INTO mgh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Vano nhooleli ule aheera: Nkhalane nnema. Nluku inyu, phi Nluku a athumwaninyu, phuvahileni nhakhu munrinttini mwinyu mmo, kontha ipheeta enyu kahaakhela. Vano ahontthukula Simiyoni nunrweha waryaya asunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wahoolo, ahaarwana inupa ya Yusufu, ni ahaavaha maasi, uwiwululacera inyaa ni inama caya nnyo ahovaha yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Vano ayo yahototokaniha coovaha caya cahalaya unvaha Yusufu uthana, kontha yahocuwela wiira phahalaya unlyana. ");
INSERT INTO mgh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Waphilyawe Yusufu yahonvaha cammwiihenryaya ni yahonlapela yooromaka mpaka vathi. ");
INSERT INTO mgh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Vano uyo ahaakohaca isalaama ni aheerela tho: Ari eehalini athumwaninyu, nlopwana oowuluvala kihimenryenyu uyo? Nanlelo haawo nkumi? ");
INSERT INTO mgh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ayo yahaakhulaca: Nrumeyaa, athumwanihu, nanlelo akumi, ahaawo salaama, ni othene yahonlapela. ");
INSERT INTO mgh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Awehaka nceresere ni amoonaka nhimaawe Pencamii, mwana aanumwane, Yusufu ahokoha: Ula phi yooyo nhimenyu etthyako kihimenryenyu uyo? Ni ahopwaherera tho eeraka: Nluku oovahe nnema, mwanaka, ");
INSERT INTO mgh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","nlattu wootteeliya woomoona nhimaawe, Yusufu ahokhuma akuvyacaka wiira aphavele nipuro nowunla, ni akelaka mpaani, ahoonla. ");
INSERT INTO mgh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Wakhucilyawe, ahokhuma ni eewehawehaka, aheera: Aliyeke yoolya eyo. ");
INSERT INTO mgh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ahomeeliya yoolya veekhawe Yusufu, woohatakanelana asunnawe ale, ni annaciipitu yalyanawe na ayo yahomeeliya veekha, kontha annaciipitu khayaalamuliya walyana annaperewu. Uyo waari mwiikho aya. ");
INSERT INTO mgh_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Asunnawe yaheesiya wameca, attharanihiyaka mookomelo ayo, maciso eeyareelo, ukhuma omuulupale mpaka omwankani ni yammwehanaca atikhinacaka. ");
INSERT INTO mgh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Vano yahomeeliya yoolya ya Yusufu wa meeca. Ni mencivelo o yoolya ya Pencamii yari yoopwaha imaara thanu menciviheriyo o yoolya ya asunnawe, ni yahoolyaca venci nuuwurya catthunaya. ");
INSERT INTO mgh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yusufu ahonvaha nhooleli owapuwani wawe, nna nlamulo nna: Ncarihe mmirinttini mwaya ala atthu ala yoolya yo khula nkwaratati mpaka cinhalaya woorya ukusa ni nhele ipheeta iwannyawe khula ntthu omalakuni womirinttini cawe. ");
INSERT INTO mgh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Wahoolo nhele ikoomisi aka, yopheeta, munrinttini mwa mwana eetthyako uyo, ni wamoca ni ipheeta inthumenlyawe tiriku. Ni uyo ahopanka cothene toko cahimeriyawe ni Yusufu. ");
INSERT INTO mgh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wasilyaya, yaholehaca atthu ale ni inama caya. ");
INSERT INTO mgh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Yaari ahinayaca upwaha iparasa eyo, phu ukati Yusufu wamwiirenlyawe nhooleli owapuwani wawe: Wunwe ni watthimakele atthu ale ni waaphwanyaka weerele: Nnakakhaniherani itthu yooreera ni yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Khinakhala ila ikoomisi immureryawe nkunya aka ni immwaserera awe ihako? Nyu nhopanka yoonanara. ");
INSERT INTO mgh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Waaphwanyilyawe ahaakuleliha ala moolumo ala. ");
INSERT INTO mgh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nanso ayo yahomwiirelaca: Nlattuni nkunya wuulumacaka commo? Uttayi ni yeeyo itthu iyo mpankaca arumeyaa. ");
INSERT INTO mgh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Wooneke nsurukhu ula, uphwanyileehu umalakuni wo mirupa cihu, nihooturuselani nikhumaka ilapo yo uKanaa, naahala winnyacerani inupa ya nkunyaa ipheeta ni iwooru. ");
INSERT INTO mgh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Akhalaka wiira mmoca wa arumeyi aa naphwanyaninya, eeviye, ni hi akina va ninakhala ipottha ca nkunya ehu. ");
INSERT INTO mgh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Uyo aheera: Kihokupali. Yooyo nohala uphwanyaninya uyo, phinhala ukhala ipottha aka, akina ayo anawoopwaa. ");
INSERT INTO mgh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Khula ntthu ahokurusa mirintti cawe wowakuvyaa ni wanca utaphula. ");
INSERT INTO mgh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nhooleli uyo ahanca uphavelaca wo khula nrintti, apaceraka wa muulupale mpaka umalihera wa mwana eethyako uyo. Ni ikoomisi iyo yahophwanyinya munnrinttini wa Pencamii. ");
INSERT INTO mgh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wakhumelenlyaya commo, ayo yahaahulaca coowara caya. Wahoolo, othene yahopakhiraca mirintti caya nuuturuwela arwaaka uparasa. ");
INSERT INTO mgh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yutta na asunnawe waphiyacilyaya inupa ya Yusufu, ni ule ari wonwo. Vano ale yahoromaca wamiithoni waawe ula, mpaka uphiya vathi. ");
INSERT INTO mgh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu ahaakohaca: Ikipankacilenyu iyo isiyani? Nyu khannocuwelaca wiira ntthu toko mi kinawoorya uwasera ihako? ");
INSERT INTO mgh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Vano Yutta aheera: Ninhala uwaakhulani nkunya? Ninhala uhimyani? Ninhala upanka cani mwaavi wiira niphwanye isariya? Nluku hokumihera wonene unyali ihu. Nkunya hi nna va ipottha caa. Wamoca ni uyo phwanyaninye ikoomisi iyo. ");
INSERT INTO mgh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Vano aheera Yusufu: Akimpanka mi commo. Yooyo ntthu mphwanyaninye ikoomisi iyo phinhala ukhala ipottha aka. Wiireke nyu akina vaa, nturuweleke ni nnema waathumwaninyu. ");
INSERT INTO mgh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Vano Yutta ahonciserera yoole, ni aheera: Sontte nkunya ukihiye, kinawulepela, kihaana nuulumo noophela wuulumaca wamiithoni waa, nkunnya aka, ni nhikiviruwele, kontha nyu nri toko Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nkunya aka uhaakoha arumeyi aa wiiraka: Nhaanaca athumwaninyu atthuna nhimenyu? ");
INSERT INTO mgh_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hi nihoohimyacera nkunya niiraka: Nihaana athumwanihu owuuluvala ni mmirawo mmoca nnyanryaya anooluvanle, nhimehu. Ahaawo munnaawe yooyo ooyaraninya nrukulu nimoca hookhwa. Anumwane ayo anhalanne yooyo, ni athumwane ananfenta venci. ");
INSERT INTO mgh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Vano we nkunya uhonireela: Nkiwiihere komoone mmiithoni mwaka. ");
INSERT INTO mgh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ni hi nihowiirela: Nkunya, mmirawo uyo khanhala waahiya athumwane, kontha arimelaru uyo apapeehu anaakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Vano nyu nheerela karumeya enyu: Mwahinmwanaceke mwanhimenyu uyo, khannohala woonaca ikhove aka. ");
INSERT INTO mgh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Weeraka coo: Hi karumeya aa, nihorwaa waathumwanihu nihattonkela moolumo yoolumacilyaa nkunya. ");
INSERT INTO mgh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Athumwanihu wanirenlyaya tho wiira nturuwele mwathume yoolya. ");
INSERT INTO mgh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Hi niheerela: Khanintthuna urwaa nwo veekhehu. Ninhala uturuwela tho nwo mwanhimehu eetthyako uyo nanrwaanaka, kontha khaninkela namoonaka nkunya uyo ikhove awe mwanhimehu ahirweke ni hi. ");
INSERT INTO mgh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Vano honirela karumeya aa, athumwanihu, coo: Nyu nhocuwelaca wiira amwaaraka yayanre asaana eeli. ");
INSERT INTO mgh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mmoco uyo heetta ni mi kiinre, khweeli yooyo hokhuriya, ni akimmoona tho mpaka nna. ");
INSERT INTO mgh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Vano mwankusaka ula waamiithoni waka, ni imwiirannyaka itthu phi itthu iyo, nnaahala uvitha irutthu aka mmahiye ni icuku. ");
INSERT INTO mgh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nna va mi karwaka waathumwanihu, karumeya aa, woohinrwana mmirawo uyo, athumwanihu cinryaaya wonvarecesa. ");
INSERT INTO mgh_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Anaahala ukhwa ucukula yakela yanoonaka uturuwa veekha wohi mmirawo ula. Ni hi ninaahala wavitha apaapehu ayo ni masukuli. ");
INSERT INTO mgh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Phimaana mi kiceemesaka wamiithoni waa unsunka mmirawo uyo ni kiheerela: Aahituruwele tho uno ikikhalele mi ikhirini iyo mahuku othene. ");
INSERT INTO mgh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Vano nna mi kikhale ipottha ya nkunya aka nipuro nahalawe ukhala mmirawo uyo. Vano uyo arweeke uwaani na asunnawe ayo. ");
INSERT INTO mgh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kinkohimya isiyani mi karwaka waathumwane wohinkusa mmirawo uyo? Akintthuna woona mi yoonanara inhala wakhuma apaapa ayo. ");
INSERT INTO mgh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yooyo ukati uyo Yusufu anawoolwana wiivithavitha nwo wamiithoni wa atthu othene, phimaana ahokhuwa eeraka: Mwakumihe ananrumeya ayo othene va. Co khaawo ahanle nenno nipuro nno, ukati ule Yusufu weecuwanehilyawe na asunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Vaavale ule ahanca wunla venci mpaka Annaciipitu wiiwa ni ihapari iyo yahophiya waFarawoo. ");
INSERT INTO mgh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Vano aheerela Yusufu asunnawe ale: Mi Yusufu. Apaapa nannelo ahaawo akumi? Nanso asunnawe ale yahosankaca venci, mpaka woolwana umwaakhula. ");
INSERT INTO mgh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ni aheerelaca Yusufu asunnawe ale: Nciserace woono. Umwattameryaca waya, aheerelaca: Mi nhimeenyu Yusufu, yoole nyu munthumihileenyu arwaninyaka Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Vano va nhicukulace ni nhiiriyelele mwanlattu nyu wookithumiha kiwaaninyaka uno, kontha Nluku aacenre wiira woopwe ukumi watthu enci, phimaana akiholihaka uno. ");
INSERT INTO mgh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nna nhina woomyakha miili niri nhina ntalani ilapo yothene, ni cinaahala myakha mithanu khacinhala waaliya ni hata wuruliya. ");
INSERT INTO mgh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nanso Nluku hokihooliha uno wiira kikhale ipyo yoomuci mwiilaponi mu ni kiwoopoleni ni wuukhikicerani venci. ");
INSERT INTO mgh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Khannakhala thi nyu nkiwanne uno, nanso Nluku, ni hokipanka ukhala namanantthu a Farawoo ni nlamuli o uhano ni nlamuli o Wiciipitu wothene. ");
INSERT INTO mgh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nturuwele wowakuvyaa waapaapa ni mwaahimerye: Nohimya co mwaninyu Yusufu: Nluku mi hokipanka mwaneene ilapo yothene yo Wiciipitu. Mmwe woono, woohipica. ");
INSERT INTO mgh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nyu nnowokhala nttetthe wo Koseni, vakhiviru ni mi. Ukhuma nyu, asaanenyu ayo, ucuulu inyu uyo, ikhontwaa cinyu nnyo, imope cinyu nnyo ni ikaruma cinyu nnyo cothene mmwane. ");
INSERT INTO mgh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mi kinnowulihani kontha cinaahala tho va myakha mithano cotala. Mwahitthuneke nyu na amucinyu othene ni mihuwo cinyu cothene nnahala uhuva. ");
INSERT INTO mgh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Cothene nnawoona ni miitho enyu, ni nhimaka Pencamii phi saahiti. Nawoona wiira khweeli thi mi kinoolumaca nnya citthu nnya. ");
INSERT INTO mgh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mwahimerye apaapa waneerihiyaka woolemelihiya mi Wiciipitu ni citthu cothene cinoonenyu. Ni mwaawihe apaapa woono wowaakuvyaa. ");
INSERT INTO mgh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Vano ule ahonkapatta Pencamii nhimaawe oonlaka uno, ni Pencamii ciicammo ahonvara mmakhatani mmo ni uyo oonlaka uno. ");
INSERT INTO mgh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Wahoolo ahaavaha alaahuma asunnawe ni othene yahoonlaca. Waculuru asunnawe ayo phoonryaya umuulumana. ");
INSERT INTO mgh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Vano weewiiyaya uhano wiira asunnawe Yusufu ahowaca, Farawoo ni mahumu awe othene yahotteeliya. ");
INSERT INTO mgh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Vano Farawoo ahomwiirela Yusufu: Waahimerye asunnaayo yapakhirihe mirintti nnyo asinama ayo, aturuwele ilapo yo Kanaa. ");
INSERT INTO mgh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ni yaturuwele woono, yaawihe athumwana na alokwaa othene. Mi kinnowavaha itthaya yomaana mWiciipitu mu ni nyu nnaahala ulawa nhakhu weelapo ila. ");
INSERT INTO mgh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Waarume yakuse ampakhira o Wiciipitu wiira yaawiihe asaaraya, asaanaya na athumwaninyu. ");
INSERT INTO mgh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Cihukukureheni citthu cinyu, kontha mapuro ooreera o Wiciipitu anhala ukhala awinyu. ");
INSERT INTO mgh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Commo yahopanka asaana a Isirayeli. Yusufu ahaavaha asunnawe ampakhira ni iphika toko Farawoo calamunlyawe. ");
INSERT INTO mgh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Wo khula ntthu ahonvaha nrintti wokuwo conaanano, nanso ni Pencamii ahomvaha makoopiri opheeta iminya ttharu ni mirintti mithanu cokuwo conaanano. ");
INSERT INTO mgh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Athumwane ahaavelelihera inama coopakhira khumi, cinapakhinre citthu cootepa ooreera co Wiciipitu, ni inama khumi coopakhira cinakusile itiriku, mikatthe ni iphika cikina co munkwahani. ");
INSERT INTO mgh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Wahoolo aholeehana na asunnawe, ni wakhumaya aheerelaca: Nhinyakulihane ni iphiro! ");
INSERT INTO mgh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yahohokolya Wiciipitu aturuwelaka wathumwanaya aneehaninya Yakoopi ilapo yo Kanaa, ");
INSERT INTO mgh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ni yahottonkaca ihapari yiiraka: Yusufu ninlelo haawo nkumi! Khweeli yooyo phi nlamuli olapo yothene yo Wiciipitu. Vaavale nrima wa Yakopi wahomwattakyaa ni ahovittikhuwa. Ni khaalamuliya waakupali asaanawe ayo. ");
INSERT INTO mgh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Nanso wahimeriyawe cothene calehenryawe Yusufu, ni Yakopi oonaka ampakhira yavelelihilyawe Yusufu wiira arweliye, nnepa awe wahokhala mmapuroni. ");
INSERT INTO mgh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isirayeli aheera: Paahi! Mwanaka Yusufu ninlelo haawo nkumi. Kinkomoona kihinakhwa. ");
INSERT INTO mgh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isirayeli ahokhuma ni citthu cothene carinawe. Uphiya wawe uPeresepa, ahovaha citthu anlapelaka Nluku a Isaki, athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ni Nluku ahomuulumana Isirayeli uhiyu nnyoonini eeraka: Yakopi, Yakopi! Uyo ahaakhula eeraka: Kiri va. ");
INSERT INTO mgh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nluku aheera: Mi kiri Nluku, Nluku a athumwana. Uhoove urwaa Wiciipitu, kontha wonwo kinkowupanka nloko nuulupale. ");
INSERT INTO mgh_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mi kinaahala urwaa Wiciipitu wamoca ni we, ni khweeli kinaahala wuuhokolosa. Ni ntata na Yusufu ninaahala uputthaputtha miitho aa. ");
INSERT INTO mgh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Vaavale Yakopi ahokhuma uPeresepa. Asaana a Isirayeli yahaakusaca athumwanaya, asaanaya ni asaaraya mwampakhira yakumihilyawe Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ciicammo yakokusa inama caya ni mihakhu cothene caphwannyilyaya uKanaa. Commo Yakopi ahorwaa Wiciipitu ni ucuulu awe wothene. ");
INSERT INTO mgh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ahaakusa Wiciipitu asaanawe, ucuulu awe, asaanawe asithiyana na asiculawe asithiyana, manaaya wiira, nloko nawe nothene. ");
INSERT INTO mgh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ala phi macina a atthu o nloko na Yakopi yarwele Wiciipitu: Rupeni, ntthaara na Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ala phaari assana a Rupeni: Enoki, Palu, Esiroomi ni Karimu. ");
INSERT INTO mgh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ala pha asaana a Simeyoni: Yemuweli, Yamini, Owati, Yakimi, Sowari ni Sawulu, mwana a nthiyana nKanaa. ");
INSERT INTO mgh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ala phaari asaana a Levi: Kerisoni, Kowate ni Merari. ");
INSERT INTO mgh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ala phaari asaana a Yutta: Eri, Onani, Selaa, Peresi ni Seraa. Eri ni Onani yakhwile ilapo yo Kanaa. Ala phaari asaana a Peresi: Esiromi ni Hamuli. ");
INSERT INTO mgh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ala phaari asaana a Isakaari: Tolaa, Puwaa, Yaasupe ni Sinromi. ");
INSERT INTO mgh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ala phaari asaana a Sepuloni: Serete, Eloni ni Yaleeli. ");
INSERT INTO mgh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ala phaari asaana yayanryawe Leya ni Yakopi uPatani-Aramu, unhiya mwanawe Tina. Ucuulu awe wothene waari talathini na araru (33). ");
INSERT INTO mgh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ala phaari asaana a Kaate: Sefomi, Haaci, Suuni, Esipomi, Eri, Aroti ni Areli. ");
INSERT INTO mgh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ala phaari asaana a Aseri: Imina, Isivaa, Isivii ni Periyasi, ni mwanrokoraya Sera. Ala phaari asaana a Periya: Heperi ni Malekiyeli. ");
INSERT INTO mgh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ala pha asaana khuumi na siita yayanryawe Yakopi ni Siilipa, ipottha ya Lapanu, anvahaka mwanawe Leeya. ");
INSERT INTO mgh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ala phaari asaana a Rakeli, amwaara a Yakopi: Yusufu ni Pencamii. ");
INSERT INTO mgh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asenate, mwana a Potifera, nhooleli osataka yo Oni, ahommaha asaana eeli Yusufu Wiciipitu: Manasesi ni Farayimi. ");
INSERT INTO mgh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ala phaari asaana a Pencamii: Pelaa, Pekeri, Asipeli, Sera, Namani, Eyi, Rosi, Mupimi, Hupimi ni Aarite. ");
INSERT INTO mgh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ala phaari asaana a Rakeli ayanryawe ni Yakopi othene yaari khumi na cese. ");
INSERT INTO mgh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana a Tani aari Husimi. ");
INSERT INTO mgh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ala phaari asaana a Nafitali: Yaseeli, Kuni, Yeseri ni Silemi. ");
INSERT INTO mgh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ala phaari atthu saapa onrukulu na Piila, ipottha ya Lapanu aamahilyawe mwanawe Rakeli, ayanryawe ni Yakopi ahomwiihana Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Othene yarwele Wiciipitu ni Yakopi, ucuulu awe wothene woohalikelela asaara asaanawe, yaari sitiini na siita atthwene. ");
INSERT INTO mgh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Woncerera asaana eeli a Yusufu yayanryawe Wiciipitu, nloko na Yakopi naarwele Wiciipitu nahophiya Sapiini (70). ");
INSERT INTO mgh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Vano, Yakopi ahonhooliha Yutta wa Yusufu, wiira acuwele maphiyero o Koseni. Uphiya waya nwo, ");
INSERT INTO mgh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu, na ampakhira awe oolikana, ahorwaa uKoseni wiira aakumanane athumwane. Vano woona wawe, aheekamela ni waakapatta, vano nakapattilene, ahoonla ukati mwinci. ");
INSERT INTO mgh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isirayeli ahomwiirela Yusufu: Nna miva pooti ukhwa, kontha kihoona ikhove aa ni kihocuwela wiira ninlelo we uri nkumi. ");
INSERT INTO mgh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Vano Yusufu aheerela asunnawe na amuci aya othene athumwane: Kinarwa unhimerya Farawoo wiira asunnaka na amuci aya apaapa yakhala uKanaa ahowa woono. ");
INSERT INTO mgh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kinkowiira, alopwana ayo ahakheli, anhakhela inama ni ahowana ikhontwaa caya, imope caya ni cothene ciri cawaya. ");
INSERT INTO mgh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Farawoo awiihanakani ookohakani wiira: Nnovarani va? ");
INSERT INTO mgh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mmwaakhuleke coo: Arumeyi aa anhuwa inama ikhumelo ni nari acikani, toko capankaya amuci ihu okhalayi. Commo phinhalenyu utthuniheriya ukhala nttetthe wo Koseni, kontha ahakheli othene anathanyiya na annaciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusufu ahorwaa wa Farawoo unvaha ihapari eeraka: Apaapa na asunnaka ahowa. Ankhuma uKanaa ni ikhontwaa caya, imope caya ni mihakhu cothene cirinaya. Nna ari uKoseni. ");
INSERT INTO mgh_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Wahoolo ahaathanla asunnawe athanu ni ahonthoonyihera Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farawoo ahaakoha: Nnovara ntekoni? Ayo yahomwaakhulaca: Karumeya aa ari ahakheli onama toko amuci ihu okhalayi. ");
INSERT INTO mgh_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Yahomwiirelaca tho: Naawile ukhala mu ukati vakani kontha itala uKanaa nwo inaatepa, ni inama ca karumeya aa khacinoona yoolya. Sontte, watthunihere karumeya aa ukhala uKoseni. ");
INSERT INTO mgh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Vano Farawoo ahomwiirela Yusufu: Athumwana na asunnaa yowenle we ");
INSERT INTO mgh_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ni ilapo yo Wiciipitu iri ni we. Upanke mananna ooreera, wiira athumwanaa na asunnaa akhale mapuro omaana. Waahiye akhale uKoseni. Woona wiira akina ayo ari atthu ankhili, waavahe nteko woohakhela inama caka. ");
INSERT INTO mgh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Vano Yusufu ahaakusa athumwane mpaka wa Farawoo, ni Yakopi ahonreeriha Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farawoo ahonkoha Yakopi eeraka: Urina myakha mikavi? ");
INSERT INTO mgh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakopi ahomwaakhula Farawoo eeraka: Myaaka caka co weettakaca ciri iminya wo talathini (130). Ciri vakani ni coorika, ni khacimphiya toko cakhalaya mayapaapa. ");
INSERT INTO mgh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Vano Yakopi ahonreeriha Farawoo ni ahorwaa. ");
INSERT INTO mgh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu aheesa ni waavaha athumwane ni asunnawe mapuro oocayira olapo yo Wiciipitu, nttetthe wo uRamacese, toko calamunlyawe Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ahaavaha yoolya yo watosa, ukhuma athumwane, asunnawe ni amucyawe othene mpaka asaana yarinawe khula ntthu. ");
INSERT INTO mgh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Khayaariwo yoolya ilapo yothene kontha itala yanatepa, ukhuma Wiciipitu mpaka uKanaa wanaakhwiya nlattu wotala. ");
INSERT INTO mgh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu ahototokaniha ncurukhu wothene waari Wiciipitu mpaka uKanaa wathumeliye itiriku ni ahorwana waFarawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Waamanlyaya ncurukhu wothene Wiciipitu mpaka uKanaa, annaciipitu yahorwaa unlepela Yusufu yiiraka: Univahe yoolya! Uhinihiye nikhwaaka itala nlattu woomala ncurukhu ihu. ");
INSERT INTO mgh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu aheerela, paahi mmwihe inama cinyu nnyo mwaakakhanihe ni itiriku, kamana ncurukhu inyu uyo uhomala. ");
INSERT INTO mgh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Yusufu ahowiiheriya inama nnyo ni ule ahaavaha itiriku akakhanihaka ni ikhavalu, ikhontwaa, imope ni apuuru. Mwakha wothene ahaaliha annaciipitu yakakhanihaka yoolya ni inama. ");
INSERT INTO mgh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwakha oyo wahovira ni wawilyaya mwakha nkina, yahoturuwela tho wa Yusufu yiiraka: Khaninoona tho mananna oowiipitha we kontha ncurukhu ihu uyo uhomala ni inama cihu nnyo cihokhala cawaa, khiiwo tho inihalenle uvaha cihikhanle irutthu cihu ni imatta cihu. ");
INSERT INTO mgh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Uhinihiye nikhwaaka ni ukhwelakhwela imatta cihu wa miithoni waa, unithume hi ni uthume imatta cihu nnyo wakakhanihaka ni itiriku, vano hi ni imatta cihu nnyo, ninakhala ipottha ca Farawoo. Univahe yoolya wiira nikhale akumi, nihikhwe itala ni ciicammo imatta cihu cihihononyee. ");
INSERT INTO mgh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Commo Yusufu ahothuma imatta cothene co Wiciipitu anthumelaka Farawoo. Annaciipitu yahothumiha imatta caya cothene kontha itala pheerihile commo. Phimaana ilapo yothene yahokhala ya Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ukhuma wariyari mpaka mmaceresere mothene molapo yo Wiciipitu, Yusufu ahaapanka ipottha atthu othene. ");
INSERT INTO mgh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Cahanle coohithuminya caari paahi imatta ca ahooleli osataka kontha Farawoo aholamula uvahiya coolya, cennyo phaapisiha nrima phimaana ahithumihaka imatta caya. ");
INSERT INTO mgh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Vano Yusufu aheerela atthu ale: Nviriyane. Ilelo kihoothumani nyu ni imatta cinyu nnyo, nna vaa nri a Farawoo, ipyo phi ila, nlimeke ni waala ittima nnyo. ");
INSERT INTO mgh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nanso nhaana munvahaka Farawoo mphantte woneethanu wo coolya cinhalenyu wuurula. Mphantte woneecese uyo unhala ukhala wawinyu wiira mpanke ipyo ni yoolya yawinyu ni ya asaana enyu ni atthu othene ankhala uwaannyu nwo. ");
INSERT INTO mgh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ale yahomwiirelaca: Nkunya, we uhoopola ukumi ihu kamana uhonipanka nnema ninakhala ipottha ca Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Toko coo, itthaya yothene yo Wiciipitu, Yusufu ahokumiha nlamulo niriwo mpaka ilelo. Mphantte wonethanu wo coolya unkhala wa Farawoo, nanso imatta ca ahooleli osataka khacinkhala ca Farawoo. ");
INSERT INTO mgh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Annasirayeli yahokhala Wiciipitu, ncoko wo uKoseni. Wonwo yahophwanya imatta cinci ni yahoyaranaca ni wuncereranyaa venci. ");
INSERT INTO mgh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakopi ahokhala myakha khumi na saapa Wiciipitu ni myakha cookumi awe cari iminya wa arupayini na saapa (147). ");
INSERT INTO mgh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wonnyawe wiira uhaattamerya ukati wookhwa, Isirayeli ahomwiihana mwamwanawe ni ahomwiirela: Wakhala wiira unakifenta, ukivare mweetto ni ulupele wiira unaahala ukhala eekhweeli ni mi. Vano kinwiirela uhikivithe mWiciipitu mu. ");
INSERT INTO mgh_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kakhwaka vale, uhikivithe mWiciipitu mu nanso ukirwaane mahiye avithiye mayapaapa uKanaa. Yusufu ahaakhula: Kinkopanka toko cinkilepelenyu. ");
INSERT INTO mgh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Vano Isirayeli ahonkhanyereriha eeraka: Ulupele. Yusufu aholupela ni Isirayeli aheecatalela wankorini. ");
INSERT INTO mgh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Unavinre ukati vakani, Yusufu ahohimerya wiira: Athumwanaa anawerennya ni ule ahorwaa waathotola, warwaawe vaa ahaakusa asaana awe eeli, Manasesi ni Farayimi. ");
INSERT INTO mgh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakopi ahohimerya wiira: Mwamwanaa Yusufu howa wuuthotola. Isirayeli aheemananiha wunwa mpaka woorya wunkoma wankorini. ");
INSERT INTO mgh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ni ahomwiirela Yusufu: Nluku Okuru-Cothene hokiphwanya uPeteeli, ilapo yo uKanaa ni hokireeriha, ");
INSERT INTO mgh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","eeraka: Nloko naa nno ninahala uyaraca ni winciva ni mommo, cinkokhumelela ilapo cinci ca atthu ni kinkowuvahani ilapo ela ukhala yawinyu ukati wothene. ");
INSERT INTO mgh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Vano, asaanaa eeli, Farayimi ni Manasesi waayarenlyaa Wiciipitu mi kihinaya uwa uno, ari awaka; toko ciryawe Rupeni ni Simiyoni. ");
INSERT INTO mgh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Vano asaana anhalaa waayara ayo awaa, nanso mwanlattu wookhala nrukulu nimoca na Manasesi ni Farayimi na ayo anaahala waakhela mphantte wohiyeriya unaaca asunnaya. ");
INSERT INTO mgh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mi kikhumaka uPatani, keettaka ni iphiro kihocukula nlattu wokikhwela Rakeli ilapo yo uKanaa unahanle vakani uphiya uFarata. Kihonvitha ni iphiro yoorwaa uFarata, uneehaninya uPetelehemu. ");
INSERT INTO mgh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Woonnyawe Isirayeli asaana a Yusufu, ahokoha eeraka: Ala tasipani? ");
INSERT INTO mgh_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ala pha asaana Nluku akivahilyawe. Vano Isirayeli aheera: Waawane woono kawareerihe. ");
INSERT INTO mgh_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Miitho a Isirayeli yahoririyaca mwanlattu wo wuuluvala ni ule khoonaca ratta. Phimaana Yusufu ahaakusa asaanawe ayo ni weemesa vakhiviru waya athumwane. Vano Isirayeli ahaavaha alaahuma ni waakapatta, ");
INSERT INTO mgh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ni ahomwiirela Yusufu: Akaacuwela wiira kinawoona tho ikhovyaa, nna vaa Nluku hokitthunihera woona asaanaa. ");
INSERT INTO mgh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Vano Yusufu ahaatamiha wamweettoni wa athumwane ni ahooroma mpaka iyuuci awe uphiya vathi. ");
INSERT INTO mgh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Vano Yusufu ahaakusa oyeeli, Farayimi ahomweesa moono nlopwana vakhiviru waya moono nthiyana wa Isirayeli, ni Manasesi ahomweesa moono nthiyana vakhiviru waya moono nlopwana wa Isirayeli ni oyeeli ahaaciserihaca wa Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Vaavale Isirayeli ahotaphula ntata no moono nlopwana nuuthatela wa muru wa Farayimi mwana omwankani, ni avirikanihaka myoono nnyo, ahokusa ntata no moono nthiyana nuuthatela wa muru wa Manasesi mwana omuulupale. ");
INSERT INTO mgh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Vano ahonreeriha Yusufu eeraka: Nluku amweettelaya mayaapaapa Aparahamu ni Isaki, Nluku kihaakhenle meettelo aka mpaka nihuku noleelo. ");
INSERT INTO mgh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ncelo kooponle coonanara cothene, waareerihe ala amirawo ala. Yihaneliye ncina naka ni macina o mayapaapa Aprahamu ni Isaki, ni wincive uneethi aya vathiva. ");
INSERT INTO mgh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Woonnyawe Yusufu athumwane yeesaka ntata no moono nlopwana wa muru wa Farayimi, khawancivenle. Phimaana ahovara ntata na athumwane apheelaka waakakhaniha naari wa muru wa Manasesi weesa wa Farayimi ni naari wa muru wa Farayimi weesa wa muru wa Manasesi. ");
INSERT INTO mgh_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ni aheerela: Nhipanke commo paapa. Ula phi omuulupale, mweeseke ntata ninyu no moono nlopwana wa muru wawe vaa. ");
INSERT INTO mgh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nanso athumwane yahokhotta ni yahomwiirela coo: Mi kinacuwela, mwanaka, mi kinacuwela. Ni uyo naahala ukhalana uneethi mwinci ni naahala ukhala nkhuulupale. Nanso unokhalaru ciicammo, nhimaawe uyo phinhala utepa ukhala muulupale wompwaha munnaawe uyo ni uneethi awe unaahala ukhala mwinci. ");
INSERT INTO mgh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Commo Yakopi ahaareerihaca wowaareeriha nenno nihuku nno eeraka: Uneethi wo Isirayeli wapheelaka ureerihana unahala uromola macina enyu wiiraka coo: Nluku opanke we toko campankilyawe Farayimi ni Manasesi. Ni ahomweesa Farayimi uhoolo wa Manasesi. ");
INSERT INTO mgh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Wahoolo Isirayeli ahomwiirela Yusufu: Kihanle vakani ukhwa, nanso Nluku nohala ukhala ni nyu ni naahala wuuturuselani ilapo ya amuci inyu okhalayi. ");
INSERT INTO mgh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Vano we ukhala wiira uhaana iyuulupale yo wapwaha asunna ayo, kinawuvaha nttetthe uri myako wakhilyaka Amorewu ni ikatana ni myura caka. ");
INSERT INTO mgh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Vano Yakopi aheehana asaanawe ni weerelaca: Mmwaace woono wiira kuuhimeryeni citthu cinhala wuukhumelelani uhoolo. ");
INSERT INTO mgh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nthukumanace va wiira mwiiwe nyu asaana a Yakopi, mwiiwe inhimyawe Isirayeli, athumwaninyu. ");
INSERT INTO mgh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rupeni, we uri ntthaara naka, ikuru caka, nhokorokho woopacera wo mwiirutthuni mwaka, ootepa uttitthimihinya ni ootepa ikuru. ");
INSERT INTO mgh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Unaviluwa toko maasi. Khunkhalana tho iyuulupale kontha we uhowela ikori ya athumwana; uhaawela amweettyaka ni uhaaveeha. ");
INSERT INTO mgh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyoni ni Levi ari ntthu ni munnaawe, ikatana caya nnyo ciri ikaruma cookhwiri. ");
INSERT INTO mgh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Akintthuna upanka mphantte miruku caya nnyo, akintthuna ukhala mmikuttanoni mwaya mmo kontha waviruwacilyaya aheeva atthu enci, nuusama waya nwo ahokwanyulaca ni uthikilaca mitinka imope. ");
INSERT INTO mgh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Uhotakhaliya urusiya waya nwo wowoopiha, uhotakhaliya uviruwa waya nwo wookhwiri. Mi kinawaakawanihaca ilapo ya Yakopi ni kinawaamwarusela ilapo yo Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yutta, asunnaa anaahala wulemeliha, ntata naa ninaahala wavara nsiko eenani aa, asaana a Yakopi anaahala umoromela Yutta wiitho wawe. ");
INSERT INTO mgh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yutta ri toko mwaakharamu, we, mwamwanaka, uneetta toko kharamu oovara. Unonkoma toko kharamu nlopwana ni unrupa toko kharamu nthiyana, tipani nohala woorya wuuwusa? ");
INSERT INTO mgh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Nttontto wo omwene khunhala unkhuma Yutta, hata ikopo yo nlamulo khinhala unkhuma mmatatani mwa, mpaka ukati unhalawe uwa mwaneene ni uyo naahala ulemelihiya ni ilapo cothene. ");
INSERT INTO mgh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yooyo naahala untthukelela puuru awe wanrittani woolipa; ikuwo cawe naahala ukattha ni ivinyu, iphome yo uva inamwareela nkuwoni mwawe. ");
INSERT INTO mgh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Miitho awe ankootepa uriipa woopwaha ivinyu. Miino awe utepa utteela woopwaha iphepa. ");
INSERT INTO mgh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sepulooni nokokhala nceresere ipharyaa nipuro ninkelaya weemela apaketi, mipika cawe cinaphiya mpaka oSitoni. ");
INSERT INTO mgh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakaari uri puuru oolipa rupile iriyari mirintti cawe. ");
INSERT INTO mgh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Oonaka wiira nipuro nimmumulawe nno niri nooreera ni itthaya eyo iri yoocivela, makhata ayo ahokusa mirintti nuuvara miteko co makokoromwa. ");
INSERT INTO mgh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Tani naahala waakihera citthu cikhanle coneethi awe toko nihimo phi nihimo no Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Tani nokokhala toko mwiikhomya unceresere iparapara, ivili inari nceresere iphiro, inluma ikottokottho yo khavalu ni inammulusa ntthu nowela uyo. ");
INSERT INTO mgh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Nyenyu Mwaneene Nluku, mi kinawehererya woopola winyu! ");
INSERT INTO mgh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kaate naahala wananiinya ikhotto ni miphwinko, nanso uyo phinhala waatthema ni woomolanihaca. ");
INSERT INTO mgh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Meeca a Aseri anhala ucara coolya; Yooyo phinhala uvaha coolya co mamwene. ");
INSERT INTO mgh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafitali ri toko naahe ookwattula muntthapweni, phimaana napanka isukuhuulu. ");
INSERT INTO mgh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu uri mwiri wo mihokorokho, woomela nceresere iluusi, miritta caya nnyo cinavira waculu waya isiri. ");
INSERT INTO mgh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nuuviruwa wa anamyuupa uhomwaattakanana anvonyeraka myuupa caya nnyo wo nceece. ");
INSERT INTO mgh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nanso muura awe uyo khattinkihile, myoono cawe ciri cokuru ni cowoorya uvonya myuupa, mwanlattu wo ntata na muulupale a Yakopi mwancina na nhakheli, mwala wo Isirayeli. ");
INSERT INTO mgh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mwancina na Nluku a athumwane, ookavihere we, Mwancina na Nluku Okuru Cothene oovahe cinenne iparakha co wirimu, iparakha cowiiserya cinenne, iparakha cocaayira ni cootosa. ");
INSERT INTO mgh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Iparakha ca athumwane cinapwaha iparakha co myako cookhalayi. Makhalelo o myako coohimala cennya iparakha nnya cothene cirwee mwiirutthuni mwa Yusufu. Cirwee uhoolo wawe ule aakhanle oomwalanihinya na asunnawe. ");
INSERT INTO mgh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Pencamii ri toko mwiici wooluwa wicisuru unakhura inama, ni ucoocilo unakawaniha yahanle. ");
INSERT INTO mgh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ari phi yaala ala apankile mahimo khumi na meeli o Israyeli. Ciicammo athumwanaya phaahimenryaya wowavahaca iparakha, avahiyaka khula ntthu iparakha camwaacile. ");
INSERT INTO mgh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Wahoolo Yakopi ahaattonkela asaanawe eerelaka: Kihanle vakani urwaa wa amuci aka akhwile khalayi. Mwakivithe wamoca ni miyapaapa nnikhukuni niri imatta ya Foromi nHitiita. ");
INSERT INTO mgh_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Nikhuku niri imatta yo Makipela, vakhiviru ni uManree, uKanaa, imatta Aparahamu inthumanannyawe Foromi, nhitita, aaceraka wiira akhale mahiye a amuci awe othene. ");
INSERT INTO mgh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Wonwo hovithiya Aparahamu na amwaarawe, Isaki na amwaarawe. Ciicammo wonwo kihonvitha Leya. ");
INSERT INTO mgh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ukhuma imatta eyo ni nikhuku niri mmattani mmo cothene aathumananinye ahitita. ");
INSERT INTO mgh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Aanowiira amalihaka wattonkela asaana awe nnya citthu nnya, Yakopi aheecatalela nuukhwa. Vano aahovithiya wamoca na amuci awe. ");
INSERT INTO mgh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu ahaawuluwela athumwane, ahonlela ni waakapatta. ");
INSERT INTO mgh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Wahoolo ahaavaha nlamulo akulukhano yaavara nteko nenno nipuro nno wiira yattikitthele nrette wohunttiha irutthu ya athumwane, ni ale yahaattikitthela. ");
INSERT INTO mgh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Yahovira mahuku arupayini oolikana, kontha yooyo phaari ukati waalamunliyaya uttikittheliya makhura nrutthu na annaciipitu yahonla mahuku miloko mithanu na miili. ");
INSERT INTO mgh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wavinryaya mahuku onokhwa ayo, Yusufu ahoolumaca ni mahumu a Farawoo eeraka: Wakhala wiira nyu nnakifenta mwamuulumane Farawoo mwancina naka mi. ");
INSERT INTO mgh_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Apaapa ahokilupeliha yiiraka: Kihanle vakani ukhwa. Mwakivithe mahiiye yiitthenkacenryaka ilapo yo Kanaa. Vano va, mwanvekele wiira akitthunihere urwaa waavitha apaapa akinkela kaapicaka kinawa naanano. ");
INSERT INTO mgh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ahaakhula Farawoo eeraka: Urwee wavithe athumwana ayo toko aneene cuulupelihilyaya. ");
INSERT INTO mgh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Vaavale Yusufu ahorwaa waavitha athumwane. Ule ahaatthukana ikwaha malaka kano othene a Farawoo, alamuli yavaranawe nteko wamoca na alamuli othene o Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Vano wahiya alamuli ayo, yahorwaa ciicammo amuci o ntthoko na Yusufu asunnawe na atthu othene yaari mmatatani mwa Yakopi. Yahinnye uKoseni nwo yaari paahi asaana, imope ni ikhontwaa. ");
INSERT INTO mgh_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ciicammo yahavelela atthu uwela ikhavalu naampakhira omope. Ikwaha iyo yaari ya atthu enci. ");
INSERT INTO mgh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Uphinnya waya ipuwa ya Atate, vakhiviru ni mooloko Yortani yahocukula ni wunla venci; mpaka Yusufu ahokhala mahuku saapa onlelaka athumwane. ");
INSERT INTO mgh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Atthu o Kanaa yakhalakhala yaayo mapuro ayo woona waya wunliya venci wapuwani ya Atate yaheeraca: Annaciipitu ampanka matthanka, phimaana nne nipuro nne nattamanne mooloko Yortani nihaninyaka Apeli-Misirayimi. ");
INSERT INTO mgh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Commo asaana a Yakopi yahopanka toko caahimeeriyaya na athumwanaya. ");
INSERT INTO mgh_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yahaakusaca athumwanaya mpaka ilapo yo uKanaa ni yahaavithaca nikhuku niri imatta yo Makipela vakhiviru ni uManree, imatta ile yathumiheriyawe Aparahamu ni Foromi Nhitita wiira ikhale ikhapuri coohala uvithana alokwawe Aparahamu. ");
INSERT INTO mgh_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Naavithileene athumwane ale Yusufu ahoturuwela Wiciipitu na asunnawe na atthu othene yanvelenle. ");
INSERT INTO mgh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Asunnawe Yusufu woona waya wiira athumwanaya ahokhwa yaheeraca: Wakhala wiira Yusufu haana itwaana ni hi, ni aphavelaka onivihera ikuhukuhu mwanlattu wa yoonanara yampankilehu, niireke cani? ");
INSERT INTO mgh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Phimaana yaholeeheraca nhupi woonhimerya Yusufu wiira: Athumwana ahinaya ukhwa yahoniruma ");
INSERT INTO mgh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","wiira munhimyacere coo: Kinawuuvekela waalevelele coonanara ni itaampi cuupankilyaya. Nnna vaa ulevelele itaampi ca karumeya a Nluku a athumwanaa. Vano Yusufu wakhela wawe nhupi ule, aahoonla. ");
INSERT INTO mgh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Wahoolo yahowaca asunnawe Yusufu ni yahonkhoromela wiitho weene ni yaheeraca: Hi nihowa va, wiira nikhale ipottha caa. ");
INSERT INTO mgh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Vano Yusufu aheerelaca coo: Nhoovace, mi kinalamuliya ukhala nipuro na Nluku? ");
INSERT INTO mgh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nyu nhokipankaca mi itthu yoonanara, nanso Nluku hopanka yeeyo itthu iyo ukhala yooreera, wiira mi ilelo kisunke ukumi wa atthu enci. ");
INSERT INTO mgh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Phimaana nhoovace, mi kinaahala wuuvahani nyu yoolya wamoca na asaanenyu ayo. Commo phenryawe Yusufu wowamaaliha asunnawe ni ahoolumacera wo nifento. ");
INSERT INTO mgh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Vano Yusufu ahokhala Wiciipitu myakha iminya nuuwa khumi, nari wamoca na amuci awe othene na athumwane, ");
INSERT INTO mgh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","mpaka ahoona ucuulu woneeraru wa asaana a Farayimi. Ni ahaakhelela asaana a Makhiri, mwana a Manasesi ukhala awawe. ");
INSERT INTO mgh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Vano Yusufu hinaya ukhwa aheerela asunnawe ayo coo: Kihanle vakani ukhwa, nanso khweeli Nluku naahala wuukaviherani nyu, mpaka naahala wuukumihani ila ilapo ela, oorwehakani ilapo yilupelenlyawe Nluku unvaha Aparahamu, Isaki ni Yakopi. ");
INSERT INTO mgh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Vaavale Yusufu aheerelaca asaana a Isirayeli wiira nnolamuliya ulupela, eeraka coo: Nluku ookavihereni nyu, nhala nkumihaca makhuva aka ayo mu. ");
INSERT INTO mgh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Phimaana Yusufu aakhwile narina myakha iminya nuuwa khumi (110) ceyarelo. Nrutthu wa Yusufu wahottikittheliya makhura oohunttiha irutthu, nuuheliya ncaneesani ni yahosunkiya Wiciipitu. ");
INSERT INTO mgh_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Vano nihuku nimoca nuulumo na Mwaneene Nluku nahowa waYona mwana a Amitayi niiraka: ");
INSERT INTO mgh_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Wunweke ni urweke isitati yuulupale yo Ninive waahimyacereke moolumo aka kontha coonanara caya cowela mpaka waryaka. ");
INSERT INTO mgh_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Nanso Yona ahonwa atthawaka wamiithoni waMwaneene Nluku arwaka uTarisi, ahokhuruwela uYopa, waaphwanyalyawe ikalawa yarwaa uTarisi, aholivela ikwaha ni ahokela, wiira aatthukane nloko anakalawa yarwaa uTarisi, apheelaka waatthawela uttayi Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Vano Mwaneene Nluku ahoruma iphyoo yuulupale mpaharini ni ahopanka nkhaya mpaka ikalawa yahanle vakani uphwyaa. ");
INSERT INTO mgh_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Vaavale anakalawa yahoovaca venci, ni khula ntthu ananlepela nluku awe, ni yahorihela mpaharini mirintti carinaya nkalawani, wiira awukule ulemeliya nwo. Vaavale Yona ahokhuruwela nhina ikalawa weecatalenlyawe arupaka ikhove. ");
INSERT INTO mgh_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Nhooleli okalawa ahorwaa waYona ni ahonkoha wiira unrupani? Wunwe ni unlepele nluku aa, noone toko nanoonela ikiriri wiira nihikhwe. ");
INSERT INTO mgh_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Wahoolo yaheerelana nrwee nipanke mwavi wiira nincuwele tipani uniwiihenre nenna nihusinna. Ni yahopanka mwavi ni wahomorela waYona. ");
INSERT INTO mgh_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Vano yahomwiirela: Unihimerye nenna va, uniwiiherenreni nenna nihusinna. Nteko aa phuvi? Unkhuma vayi? Ilapo aa phivi ni ikhapilani? ");
INSERT INTO mgh_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yona ahaakhula: mi Heperewu, ni kinawoova Mwaneene Nluku, Nluku o wirimu, apattusile ipahari ni itthaya. ");
INSERT INTO mgh_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Vaavale atthu ale yahanca woova venci ni yahomwiirela: Isiyani yeela ipankile ela? Kontha atthu ale yahocuwela wiira atthawile wamiithoni waMwaneene Nluku, maana ahaahimyacera. ");
INSERT INTO mgh_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Yahomwiirelaca: Nuupankeke isiyani wiira ipahari imaale? Kontha nkhaya natepaca mpaharini. ");
INSERT INTO mgh_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yona ahaakhula: Nkikuse ni nkivonyere mpaharini; ipahari inaahala umaala. Ni kinacuwela wiira nkhaya ula wile mwanlattu wa waka. ");
INSERT INTO mgh_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Vaavale anakalawa yaanvira yeettihaka ni ikuru caya apheelaka uphiya ukhopela. Nanso khayoonrye, kontha mpaharini nkhaya aantepa. ");
INSERT INTO mgh_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Vano yahaalepela Mwaneene Nluku a Yona, yiiraka: Contte Mwaneene Nluku, nhinihiye nikhwaka nlattu wa coonanara ca Yona, nhinootherye hi va ukhwa wawe kontha nyu Mwaneene Nluku nhopanka wootthuna winyu. ");
INSERT INTO mgh_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Vaavale yahonteesa Yona ni yahonvonyera mpaharini, ni nkhaya ahomaala ucaca. ");
INSERT INTO mgh_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Vano atthu ale yahoovaca venci Mwaneene Nluku, ni yahaavahaca itthuvo Mwaneene Nluku ciicammo yakhuluvelihaka waatthara. ");
INSERT INTO mgh_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Mwaneene Nluku ahoruma ihopa yuulupale wiira immirye Yona. Ni Yona ahokhala mmirimani mohopa mahuku mararu uthana ni uhiyu. ");
INSERT INTO mgh_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Vano Yona nari mmirimani mohopa ahoswali aasukuruku Mwaneene Nluku ");
INSERT INTO mgh_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","eeraka: Mmahuvihoni kihokhuwelela Mwaneene Nluku ni ahokaakhula. Mmirimani mahiye kihokhuwa, ni nyu nheewa ncu naka. ");
INSERT INTO mgh_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nhokirihela mpaharini mapuro oowiisya cinenne ni kihokhala oorukureriya ni maasi ni mawimpi moolupale othene yaavira waculu waka. ");
INSERT INTO mgh_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Kihoona toko kihomwalaanihiya ni nyu. Akaacuwela wiira kaanhala woona tho inupa enyu ittakattifu. ");
INSERT INTO mgh_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Maasi othene yahokikhuneela mpaka ukittiya iphumu; ni ipahari yahokimirya ni makukhu o mpaharini yahokivilikelela mmuru. ");
INSERT INTO mgh_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Kihokhuruwela mpaka vathi waya myaako, mpaka ilapo ya atthu ookhwa ni mikhora caya cahokitthukela mommo. Nanso nyu nhokikumiha mapuro oowiisa, nuukivaha ukumi; Mwaneene Nluku; Nluku aka! ");
INSERT INTO mgh_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Upheelaka nnepa aka urimela mi kihowuupuwelelani nyu, Mwaneene Nluku, ni iswali caka cowela warinyu, mpaani mwinyu moottakattifihiya. ");
INSERT INTO mgh_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ale anaswalela anluku oohimaana ahiyaka ikiriri ca Nluku. ");
INSERT INTO mgh_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Nanso mi kinaahala uwiipelani macipo oowunnuwihani ni wuuvahani itthuvo. Kinkopanka ile yookhuluvelihilyakani. Woopwa ukhuma wa Mwaneene Nluku. ");
INSERT INTO mgh_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Vano Mwaneene Nluku ahoolumana ihopa wiira inraphye Yona, ni Yona ahoraphenya ucenkweni. ");
INSERT INTO mgh_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Imaara yonayeeli nuulumo na Mwaneene Nluku nahowa waYona niiraka: ");
INSERT INTO mgh_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Wunwe ni urwee isitati yuulupale cinenne yo Ninive waahimyacere atthu o Ninive moolumo yuuhimyacenryaka. ");
INSERT INTO mgh_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yona aheetthenkaca, ahonwa toko cakhanlyawe oohimeriya na Mwaneene Nluku. Ahorwaa uNinive. Ninive yaari isitati yuulupale cinenne yeettiya mahuku mararu uttupulaniha iriyariru. ");
INSERT INTO mgh_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yona ahophiya uNinive. Aheetta nihuku nimoca akhalaka uwaahimyaca eeraka: Anhala mahuku arupayini Ninive ukwanyulaciya. ");
INSERT INTO mgh_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Vano atthu othene uNinive yahonkupali Nluku ni yahorukunusa mirima, ciicammo yaholeehana untthuka ramatani ukhuma atthu oolupale, mpaka acikani, othene yahommwaraca nakotto athoonyiheraka wiira ahorukunusa mirima caya. ");
INSERT INTO mgh_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Mwene o Ninive weewilyawe ni uyo ahonwa wahiceni wawe phurulaka ikuwo cawe cothene nuummwara nakotto phunkomaka wattuurani. ");
INSERT INTO mgh_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ciicammo Mwene na ahooleli awe yahokumiha nlamulo nowahimyacera atthu othene unsitati wiira: Hikhale nohala ulya hata uwurya ukhuma atthu, inama coohuwiya, toko imope ni ikhontwaa, cihivahiye coolya ni maasi wala cihihuleliye cirwaka ulawiha coolya. ");
INSERT INTO mgh_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Atthu othene (ni inama cothene) amware nakotto anlapele Nluku ni ikuru, arukunuse mirima caya ni uhiya coopanka caya coonanara cothene. ");
INSERT INTO mgh_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Atthuna commo Nluku nahala unoonela ikiriri, ni urusiya wawe unahala uvira ni khaninhala ukhwa. ");
INSERT INTO mgh_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Nluku ahoona mananna cakhanlyaya oorukunusa mirima caya akhalaka oohiya coonanara caya ni Nluku khaahuvihile tho atthu ayo. ");
INSERT INTO mgh_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Nanso vaavale, Yona ahorusiya ni ahocaca. ");
INSERT INTO mgh_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Vano ahoswali akohaka Mwaneene Nluku toko co: We Mwaneene Nluku, mi akeenre kihinaaya ukhuma ilapo aka wiira phi yeeyo yahalaa upanka? Phimaana kipankaka mananna ootthawela uTarisi! Mi kahocuwela wiira we uri Nluku ookiriri ni oothunku, wiira we uri Nluku oopica ucaca, eemaani ni ooreera, ciicammo ukati wothene uri oolevelela. ");
INSERT INTO mgh_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Pahi, nyu Mwaneene Nluku, nkiive, kontha fatari kikhwe kihikhale nkumi. ");
INSERT INTO mgh_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Mwaneene Nluku ahaakhula: We Yona wookupali wiira uhaana isariya yoorusiya toko co? ");
INSERT INTO mgh_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Vaavale Yona ahokhuma uNinive, phurwaaka mphante unkhuma ncuwa ni ahonkoma. Vano ahoteka nrapattha ni ahonkoma wantthuucini waya, awehereryaka woona itthu yahala wiiranyaa nsitati mmo. ");
INSERT INTO mgh_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Vano Mwaneene Nluku ahomeliha mwamwiri wootthavelaca wiira Yona amumule wantthuucini ni atteeliye. Vaavale Yona ahotteeliya venci. ");
INSERT INTO mgh_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Nanso usa waya, ncuwa nipheelaka ukhuma, Nluku ahonruma mwaamunku wiira eeve mwamwiri uyo ni wahokhwa. ");
INSERT INTO mgh_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Wakhumilyaya ncuwa, Nluku ahowiha iphyoo yooviha cinenne ikhumaka unkela ncuwa. Yona ahociriphuwa nlattu wo nttukuttha ni ncuwa nampaha mmuruni mwawe. Vano ahopheela ukhwa ni aheera: Fatari kikhwe kihikhale nkumi. ");
INSERT INTO mgh_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Nluku ahonkoha Yona eeraka: Uhaamini urusiya nlattu wo yoola mwamwiri ula? Yona ahaakhula: Khweeli kihaana isariya yoorusiya toko co mpaka ukhwa. ");
INSERT INTO mgh_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Vano Mwaneene Nluku aheera: Ula mwamwiri ula wunnuwile uhiyu, ni uhiyu nkhwawe uyo wahokhwa. We khiiwo ipankenlyaa ula mwamwiri ula ni khawunnuwihile, vano unawoonela uthunku. ");
INSERT INTO mgh_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Mi ni isariya caka cothene akinlamuliya woonela ikiriri isitati yo Ninive, uryaya atthu enci oohicuwela itthu yooreera ni yoonanara woopwaha elufu iminya wosirini (120.000) ni inama cinci ciriwo? ");
INSERT INTO mgh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wiipaceroni wa Nhupi Wooreera wa Yesu Kristu, Mwanawe Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ohaantikhiya ni nnapiyu Isaya: Kimmonrumiha uhoolo wa mayanhupi aka, nohala wulokiherani iphiro. ");
INSERT INTO mgh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ncu ninkhuwa ntakhwani, Nlokihe iphiro ya Apwiya, mookole mittala. ");
INSERT INTO mgh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ciicale, Yohani Mpatisa phooneliye ntakhwani wiira eetthucihe opatiso wo urukunusa nrima wiira itaampi cileveleliye. ");
INSERT INTO mgh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yaanamwikamela atthu othene olapo ya Yutteya, na atthu ankhala uYerusalemu, ni yaanapatisiya ni ule umooloko Yorttani, alaphaka itaampi caya. ");
INSERT INTO mgh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohani awara ikuwo yo mapururu onkamira, eethukelaka nyununi mo nrapala, yoolya awe yari mattettentte ni urawo wo ntakhwani. ");
INSERT INTO mgh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ni wowaalaka anaahimya coo: Uttuli waka mi nawa nkinaku rina ikuru impwaha yawaka, ni mi akimphwanela wooroma wiira kitthukule miripwe cokwakwatta cawe. ");
INSERT INTO mgh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi kinawuupatisani ni maasi, nanso Ule naahala wuupatisani muNnepa Nttakattifu. ");
INSERT INTO mgh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Waheranyaa, mahuku ale, Yesu awaaka ukhuma uNasaree yo Kalileya, mpaka upatisiya ni Yohani umooloko Yorttani. ");
INSERT INTO mgh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wakhumawe mmaasini mmo, ahoona irimu ihulyaka, ni Nnepa, woonnya toko ikhuntta inkhuruwelaka. ");
INSERT INTO mgh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ni ukhuma wirimu nineewiya ncu nnohimya: We uri Mwanaka oofentiya, nokiphela nrima. ");
INSERT INTO mgh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wahoolo Nnepa Nttakattifu wahoonrweha utakhwani, ni ");
INSERT INTO mgh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ahokhala wonwo mahuku arupayini, ni ahothokociya ni Sotwani; ni cahawo wonwo inama cowoopiha, ni ancelo yahonkavihera. ");
INSERT INTO mgh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Utthukiya wawe Yohani, Yesu akenle uKalileya, wahimerya atthu Nhupi Wooreera wa Nluku, eeraka: ");
INSERT INTO mgh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ukati uhophiya ni ciicammo Omwene wa Nluku uhophiya. Nrukunuseke nrima, nkupalelaka Nhupi Wooreera. ");
INSERT INTO mgh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aviraka nceresere ntthiya no Kalileya, ahomoona Simoni ni nhimaawe Anteree avonyeraka matthavi aya mpaharini mmo, nlattu yaari mayototha ihopa. ");
INSERT INTO mgh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu aheerela: Nkitthare Mi, ni Mi kimmowupankani mayowatotha atthu. ");
INSERT INTO mgh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ahiyaka nanaanoru matthavi aya, yahontthara Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Napwahile vakani, ahomoona Yakopu, mwana a Sepeteu ni nhimaawe Yohani, alokihaka nkalawani matthavi aya pweehanaka nananoru. ");
INSERT INTO mgh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ni ale yahonhiya Sepeteu athumwanaya ni mayanteko aya, yahontthara. ");
INSERT INTO mgh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yaanarwa uKafarnaum. Nihuku no Ntivela ahokela nnsinakokani, ni aheetthuciha atthu. ");
INSERT INTO mgh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na atthu othene yaanawumiya mwaano ni miitthuciho cawe, nlattu aheetthuciha toko ntthu nolamula ni khari toko mayowantikha. ");
INSERT INTO mgh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ahaawo nnsinakokani mmo ntthu arina nnepa woonanara, apacile ukhuwa: ");
INSERT INTO mgh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","We urinani ni hi, Yesu o Nasaree? Wawenle unikwanyulaca? Mi kihocuwela wiira uri Nttakattifu a Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ahonkuphula, eeraka: Omaale we, ni ukhume wantthu ula. ");
INSERT INTO mgh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Vano, nnepa woonanara, unantathile ni ikuru, ukhuwacaka, wahokhuma wantthu ule. ");
INSERT INTO mgh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Othene yahotikhinaca, mpaka ukohana ayayoru: Isiyani ila? Moone meetthuciho oonaanano, uromoliya ni nlamulo mpaka ulamulela minepa coonanara ni nnya cinamwiiwelela. ");
INSERT INTO mgh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ni ncina nawe nahorumannya nttetthe wothene, ilapo yo Kalileya. ");
INSERT INTO mgh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Akhumaka unsinakoka ahokela mpani mwa Simoni ni Anteree, wamoca ni Yakopu ni Yohani. ");
INSERT INTO mgh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Amaathyawe Simoni yaanawerenya wakorini, awerenyaka irutthu yothene, ni nananoru yahonhimerya ca iretta ila. ");
INSERT INTO mgh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Attameryaka, Yesu ahaavarela ntata mpaka waawusa. Iretta yahaahiya, na ale yahopacera wakaavihera. ");
INSERT INTO mgh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ucoocilo, ncuwa ninakwattuwile, yahomwiihera aretta na ale yahoosiya ni nnepa woonanara, ");
INSERT INTO mgh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","na atthu othene owatthokoni yahothukumana wankhora. ");
INSERT INTO mgh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ahaavoniha aretta enci, yahoosiye ni coowerya, ni ahoomola minepa coonanara cinci; nanso khahiya wuulumaca minepa nlattu yaanancuwela. ");
INSERT INTO mgh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wicisuru, uhinasa ahoonwa ni ahokhuma; phurwaka ntakhwani wiira aswali. ");
INSERT INTO mgh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni, na ale yaari ni Yesu yahontthara. ");
INSERT INTO mgh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Umphwanya waya, yahomwiirela: Atthu othene anawuphavelani. ");
INSERT INTO mgh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nanso ahaakhula: Nirwe ncoko nkina, itthoko co vakhiviru, neetthucihe wonwo, nlattu wo yela phikumenlyaka. ");
INSERT INTO mgh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ni ahorwaa ilapo yothene yo Kalileya, eetthucihaka mmasinakokani, ni oomolaka minepa coonanara. ");
INSERT INTO mgh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ntthu o makuttula ahonrwela Yesu ni ankhoromelaka ahonlepela: Watthunaka vale unawoorya ukivoniha. ");
INSERT INTO mgh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Amoonelaka ikiriri, Yesu ahonthatela ntata mpaka unkwanya, eeraka: Kinatthuna, uvone. ");
INSERT INTO mgh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nananoru, makuttula yahonhiya, ni irutthu yahokhala toko khalayi. ");
INSERT INTO mgh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ni Yesu ahonleeha phunlakaka, ni moolumo ala: ");
INSERT INTO mgh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ukiiwe ahinhimerye ntthu itthu ila. Nanso upacera urwaa wamayasataka ni uvelelihe itthu ilamuliye ni Musa; nlattu wa atthu anhapihiya makuttula, wiira akhale saahiti aa. ");
INSERT INTO mgh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ule, mweeco, urwaa wawe ahopacera ulattula ni uhimya itthu yeeranele, mpaka Yesu uhoorya ukela ooniyaka mmawaani phukhalaka ntakhwani; na atthu olapo ile yaananrwela. ");
INSERT INTO mgh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Anavinre mahuku vakani, ni Yesu naturuwile uKafarnaum wahorumanyaa wiira ri uwaani. ");
INSERT INTO mgh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yahothukumana atthu enci, mpaka uphunyana wankhora, ni Yesu aheetthuciha moolumo. ");
INSERT INTO mgh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vano yahomwiihera ntthu oowuntakyaa, akusiye na atthu acese. ");
INSERT INTO mgh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ukhala wiira khayoorya unkusa mpaka waryawe, nlattu wo mphwinko, yahokhunula nivatho nipuro naryawe Yesu, ni ciicale, anahunle iparo, yahokurusela nrepa naryawe ntthu oowuntakyaa. ");
INSERT INTO mgh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wowoona ukupali waya atthu ale, Yesu ahomwiirela ntthu oowuntakyaa: Mwanaka, itaampi caa ciholeveleliya. ");
INSERT INTO mgh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wonwo mweeco, yahoonkoma mayowantikha vakani yaakakaka munrimani mwaya: ");
INSERT INTO mgh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nlattuni, Ule uulumacaka co? Nakufuru. Noorya tipani ulevelela itaampi, hiri Nluku paahi? ");
INSERT INTO mgh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu, nanso acuwelaka moopuwelo aya mpaka ahaakoha: Nlattuni muupuwelaka ciicale munrimani mwinyu? ");
INSERT INTO mgh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Itthu yootepa urika phivi, umwiirela oowuntakyaa, Itaampi caa ciholeveleliya, atthuna umwiirela, Wunwe, ukuse nrepa naa ni weette? ");
INSERT INTO mgh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vano paahi; wiira ncuwele wiira Mwanawe Pinattamu haana ikuru vathiva yolevelela itaampi, ");
INSERT INTO mgh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","kinawuulamula amwaacaka ntthu oowuntakyaa ukuse nrepa naa ni urwee uwaanyaa. ");
INSERT INTO mgh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ntthu ule ahoonwa, ahokusa nrepa nawe ni ahokhuma ooniyaka na atthu ale othene, mpaka othene wumiya mwaano, ni yaananttottopela Nluku yiiraka: Khaninoona itthu co nikhalakaru. ");
INSERT INTO mgh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Imaara ikina tho ahokhumela vate mphante wo ipharyaa; ni mphwinko wa atthu othene wahontthara, Ule eetthucihaka. ");
INSERT INTO mgh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nanso aviraka uyo ahomoona Levi, mwanawe Alfeu nonkomile inupa yowaakheleliya nsoko, ni ahomwiirela: We, ukitthare Mi. Ni Levi ahonwa anttharaka Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nari wamoca, itthoko ya Levi, mayoliviha nsoko enci na atthu ookosakosa yahoonkomaca wameeca wamoca ni Yesu ni uwiitthuca awe, nlattu khayaamala urunwa atthu yaantthara. ");
INSERT INTO mgh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mayowantikha yanrumelelihana ni mafarisi, amoonaka ulya na atthu ookosakosa ni mayoliviha nsoko, yaheerela uwiitthuca awe: Nlattuni, nalya na atthu ookosakosa? ");
INSERT INTO mgh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu eewaka cothene ahaakhula: Kahiwena akumi phimmwavya tothoro, nanso, aretta. Mi akiwenle weehana atthu aattakattifu, nanso atthu ookosakosa. ");
INSERT INTO mgh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Owiitthuca a Yohani ni mafarisi yaantthuka, yahowa unkoha Yesu: Owiitthuca a Yohani ni mafarisi anatthuka ni uwiitthuca aa ahitthukaka isiyani? ");
INSERT INTO mgh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ahaakhula: Asimpwana awe mayothela anawoorya utthuka, mayothela nari na ale? Mahuku othene ankhalaya wamoca ni mayothela khanoorya utthuka. ");
INSERT INTO mgh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anaahala uphiya mahuku anhalaya waakhiya mayothela, vano phankelaya utthuka. ");
INSERT INTO mgh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Khaawo neesera icaapha yonaanano ikuwoni yookhalayi, nlattu icaapha yonaanano inatepereriha mphantte wookhalayi, ni nikhwata ninatepa wunnuwa. ");
INSERT INTO mgh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni khaawo nohela ivinyu yonaanano mmapikani ookhalayi, ahelaka vale, ivinyu inaahala upwesa mapika ookhalayi, ni ivinyu inarihakyaa wamoca ni mapika. Nanso ivinyu yonaanano inheliya mmapikani oonaanano. ");
INSERT INTO mgh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nihuku nimoca no ntivela Yesu anavira mmamattani na owiitthuca awe. Yeettaka mphironi, owitthuca awe yahoonta ncasi. ");
INSERT INTO mgh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafarisi yahontthara, yiiraka: Nkoona, nlattuni ale apankaka itthu yowatelihiya upanka nihuku no ntivela? ");
INSERT INTO mgh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ahaakhula: Khannasoma itthu yapankilyawe Taviti, wammoonlyawe itala, ule na atthu yarinawe? ");
INSERT INTO mgh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wakenlyawe inupa ya Nluku, ukati wa mayasataka muulupale Apiyatari, ni walilyawe mikatthe coottakattifihiya coolamuliya ulya mayasataka paahi, ni ahaavaha atthu yarinawe? ");
INSERT INTO mgh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ni ahopwahera: Ntivela nihopankeliya ntthu, ni kahiwena ntthu phipankeliye ntivela. ");
INSERT INTO mgh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mwanawe Pinattamu phi mwaneene ntivela. ");
INSERT INTO mgh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu ahokela tho nnsinakokani. Ahokhala wonwo ntthu oonririya ntata. ");
INSERT INTO mgh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vano ale yaananhottela wiira amoone ammoonihaka nihuku no ntivela wiira ankasari. ");
INSERT INTO mgh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ahonhimerya ntthu arina ntata noonririya: Wunwe ni uwe iriyari ila va. ");
INSERT INTO mgh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wahoolo ahaakoha: Inoleveliya, nihuku no Ntivela, upanka itthu yooreera atthuna itthu yoonanara, woopola ukumi atthuna uhiya uharipwyaka? Ale yahomaalaca. ");
INSERT INTO mgh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Vano, awehaka ni urusiya, ni ummweryaka nrima nlattu woturumala mirima caya, ahomwiirela ntthu: Wookole ntata. Ahookola ntata ni nna nahovona. ");
INSERT INTO mgh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wakhumilyaya, mafarisi yahothukumana na aHerotiyano wiira avaanele mamwiivelo. ");
INSERT INTO mgh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ahorwaa untthiyani na owiitthuca awe, atthariyaka ni mphwinko muulupale wakhuma uKalileya, ni Yutteya, ");
INSERT INTO mgh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","uYerusalemu, uItumeya, ukhopela Yorttani, ni nceresere Tiro ni Sittoniya. Ahophwanyinya ni mphwinko muulupale, wewiilyaya itthu yaapankawe. ");
INSERT INTO mgh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ahaahimerya owiitthuca awe, anlokihere ikalawa yaankani, wiira hiphunyererihiye ni mphwinko uyo. ");
INSERT INTO mgh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Woona ahaavoniha atthu enci, ni nlattu weetthu ila, ale yanawaaninya ni ikwerere wiira ankwanye. ");
INSERT INTO mgh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Minepa coonanara, wamoonaya, caanankhoromela wamiithoni wawe ni caanakhuwa: We uri Mwana a Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ule nanso anawaateliha wiira ahicuwelihe. ");
INSERT INTO mgh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wahoolo ahowela mmwaakoni, ni aheehana ale yatthunyawe, na ale yahomwaattamerya. ");
INSERT INTO mgh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ahaathanla khumi na eeli phwaavahaka ncina na amitthenka wiira yakhaleke ni Uyo, ni aarume, wiitthuciha, ");
INSERT INTO mgh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni yaphwanyeke ikuru yo woomola minepa coonanara. ");
INSERT INTO mgh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ahaathanla khumi na eeli ala: Simoni, ammahilyawe ncina na Peturu, ");
INSERT INTO mgh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakopu, mwanawe Sepetteu, ni Yohani nhimaawe Yakopu, ammahilyawe ncina Powanerce, manaaya asaana utari; ");
INSERT INTO mgh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anteree, Filipe, Partimeu, Mateu, Tomee, Yakopu mwanawe Alfeu, Tateu, Simoni Selote, ");
INSERT INTO mgh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yutta Iskariyoti, anthumihile Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Waphilyaya uwaani, mphwinko wa atthu wahothukumana tho, mpaka wahinoryaya ulya. ");
INSERT INTO mgh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ni amawaawe, wiiwawaya itthu ila, yahokhuma wiira ammare, nlattu yeeriya: Hoolociya. ");
INSERT INTO mgh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ni mayowantikha, yakhuruwenle o Yerusalemu yahohimya: Hovariya ni Peelsepu. Ni thotho. Nawoomola minepa coonanara ni ikuru ca mwene a minepa coonanara. ");
INSERT INTO mgh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Vano Yesu aheehana ni wahimerya mmalikaniheroni: Noorya cani, Sotwani umoomola Sotwani? ");
INSERT INTO mgh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Omwene wakawaniyaka, omwene ule khunoorya ukhala. ");
INSERT INTO mgh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ni inupa yakawanihiyaka, inupa ile khinoorya ukhala. ");
INSERT INTO mgh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Phimaana, akhalaka Sotwani eecanihaka ikhotto mwaneene eekawanihaka, ni khanoorya ukhala tho, homala. ");
INSERT INTO mgh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Khaawo noorya ukela inupa ya ntthu ookhomaala ni unhukhela mihakhu cawe woohipaca ummara phooryaka unhukhela wahoolo. ");
INSERT INTO mgh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Khweeli kinawuhimeryani: Itaampi cothene ni ikufuru cothene cinkhala coromoliya na atthu, cothene cimmoleveleliya, ");
INSERT INTO mgh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nanso, ntthu nohala ukufuru Nnepa Nttakattifu khammwa uleveleliyaka akhalakaru; nowookhala ni itaampi awe mahuku othene. ");
INSERT INTO mgh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ahaahimerya itthu ila nlattu yahimenrye: Ule navariya ni nnepa woonanara. ");
INSERT INTO mgh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Vano yahophiya anumwane na asihimaawe, ni anemenle utaa, yahaaruma atthu umwihana. ");
INSERT INTO mgh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mphwinko wa atthu wahoonkoma ntotho wawe, atthu yahonhimerya: Ahaawo vate anumwana na asihimaa, anawuphavela. ");
INSERT INTO mgh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ahaakhula: Amanyi ni asihimaaka phapani? ");
INSERT INTO mgh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ni athetulaka miitho mwaatthu ale yanrukurenrye, aheera: Ala pha manyi na asihimaaka. ");
INSERT INTO mgh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ntthu nopanka utthuna wawe Nluku, ule phi nhimaaka, mwanrokoraka ni amanyi. ");
INSERT INTO mgh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ahopacera tho wiitthuciha nceresere ntthiya. Mphwinko muulupale wahothukumana ntotho wawe, phimaana ahowela nkalawani ni ahoonkoma mmwe, phukhalaka mphwinko woonene. ");
INSERT INTO mgh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Anaweetthuciha citthu cinci mmalikaniheroni ni anawahimerya mmeetthucihoni mwawe: ");
INSERT INTO mgh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Mmiriyane. Mayowaala ahokhuma arwaka uwaalani. ");
INSERT INTO mgh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waalaawe, ipyo ikina yahomorela nceresere iphiro ni yahowaca asanuni, yaholya. ");
INSERT INTO mgh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ipyo ikina yahomorela wakokotthoni, wonwo wahakhanle itthaya yinci, khipicile umela nlattu itthaya khayaakenle uttayi. ");
INSERT INTO mgh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nanso, ncuwa, ukhuma waya, yahopahiya, nlattu wohikhalana itthaya yinci mitithari cahooma. ");
INSERT INTO mgh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ikina yahomorela wamwiwani, ni miwa cahoonuwa, cahomirya ipyo ni khayeemile. ");
INSERT INTO mgh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ikina yahomorela itthaya yooreera ni yunuwaka, ni inarenre, yaheema, ni wuncereriya mpaka ukhala talathini, sitiini ni iminya khila ipyo. ");
INSERT INTO mgh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ni ahopwahera eeraka: Urina manyaru uwiwelela, eeweke. ");
INSERT INTO mgh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nahanle veekha, atthu yanrukurerya wamoca ni owiitthuca awe khumi na eeli yahonkoha manaaya nlikanihero nne. ");
INSERT INTO mgh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ahaakhula: Nyu nhovahiya ucuwelaca ikano yo omwene wa Nluku, nanso, atthu ari utaa citthu cothene anahimeriya ni malikanihero, ");
INSERT INTO mgh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","wiira yoonaka, yoone, ni ahicuwelele; yiiwaka, yiiwe, ni ahiiwehe wiira ahirukunuse mirima, aleveleliyaka itaampi caya. ");
INSERT INTO mgh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ni ahopwahera: Khanneeweeha manaaya nlikanihero nna? Nnohala mweeco, wiitthuca cani malikanihero makina ayo? ");
INSERT INTO mgh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mayowaala nawaala nuulumo, ");
INSERT INTO mgh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ari nceresere iphiro, pha ale yahimerye nuulumo, aneewile nuulumo. Sotwani nawa waatamiha nuulumo naaliye. ");
INSERT INTO mgh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ciicammo, ale yaakhenle ipyo mapuro ookokoottho, pha ale yiinre aneewile nuulumo, woohipica anawaakhelela ni nrima wootteeliya, ");
INSERT INTO mgh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","nanso kharina mitithari mwaale, khankhala nthiti ni yawaaka mahuviho, atthuna yomolanihaciyaka nlattu wo nuulumo, wohipica anattittha. ");
INSERT INTO mgh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ahaawo akina, anaakhela nuulumo mapuro o miiwa. Ala anawiiwa nuulumo, ");
INSERT INTO mgh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nanso nlattu woramela itthu yo nttuniyani, wothokociya ni mihakhu ni citthu cikina cinonlelaya, cinakela munrimani mwaya anattitthiha nuulumo ni khaneema. ");
INSERT INTO mgh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Atthu anakhela nuulumo itthaya yooreera pha ale aneewa nuulumo, anaakhelela, aneewa mpaka wiima ni wincereriya talathini, sitiini ni iminya khila ipyo. ");
INSERT INTO mgh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ahaahimerya tho: Pooti inaweesiya isamaninya nhina mwaya itthuttu atthuna vathi waya nkori? Keera ineesiya waculu mmutto? ");
INSERT INTO mgh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nlattu khiiwo yovithiya ihinhala wooneleliya, ni khiiwo yowipithya ihinhala ukhumela woonene. ");
INSERT INTO mgh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ntthu akhalanaka manyaru oowiiwelela, eeweke! ");
INSERT INTO mgh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ni ahopwahera: Mmiriyaneke ratta itthu ineewenyu. Nnowophimiya ni itthuttu inhalenyu uphimela, ni thotho nnowowincereriya. ");
INSERT INTO mgh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vano ntthu rina, nowowuncereriya, ni ntthu hirina, nowowaakhiya, mpaka citthu cirinawe. ");
INSERT INTO mgh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ni anawiira: Omwene wa Nluku uri toko ntthu avonyenre ipyo awe vathi. ");
INSERT INTO mgh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Arupe, unwe, uhiyu ni uthana, ipyo inamela ni inawunuwa, ule woohicuwela cani. ");
INSERT INTO mgh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Itthaya inavaha veekhaya, woopacera ntathi, wahoolo ncasi, ni umwiisoni ncasi nocara meele. ");
INSERT INTO mgh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ni yowiima yattokotthaka, naahepha nlattu wahophiya ukati woohephiya. ");
INSERT INTO mgh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Vano aheera: Ninhala ulikanihera ni isiyani omwene wa Nluku? Atthuna ninhala utaphulela ni nlikaniheroni? ");
INSERT INTO mgh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uri toko inuku yo nrale, ineera inaliye vathi, iri yootepa uyeva mweenuku cothene; ");
INSERT INTO mgh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","nanso, yaaliyakaru, inawunuwa, inathatuwa mwiri muulupale woopwaha miri co mmattani ni inamwarya miritta caya mpaka asanuni o wirimu woorya uteka ipuuru muntthucini mwaya. ");
INSERT INTO mgh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ni malikanihero menci toko ala Yesu anaweetthuciha nuulumo, toko woonawe wiira anawiiweha. ");
INSERT INTO mgh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Khoolumacera woohikhala ni malikanihero; nanso uyo anawataphulela cothene owiitthuca awe anari veekhaya. ");
INSERT INTO mgh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nihuku nne, unaripenle, ahaahimerya: Nrwee nilapuwele ukhopela. ");
INSERT INTO mgh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ahiyaka miphwinko, owiitthuca yahonkusa, toko caryawe nkalawani, ni cahommelela ikalawa cikina. ");
INSERT INTO mgh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Vano ahokhumelela naphuvo muulupale ophyoo ni mawiimpi yanawicattakanihaca ni ikalawa mpaka yahala vakani ucara maasi. ");
INSERT INTO mgh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu, nari mphantte wottuli wokalawa, anarupa naphitenrye nsawu. ");
INSERT INTO mgh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yahoommusa ni umwiirela: Mwalimu, khunoona wiira ninakumpwela? Unwaka, aholamulela iphyoo ni aheerela ipahari: Imaale, ihittinke! Iphyoo yahomaala, ni ipahari yothene yaheera riya-riya. ");
INSERT INTO mgh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wahoolo ahaahimerya: Nlattuni nkhalaka atthu oowoova osilili? Nhikupaliki? ");
INSERT INTO mgh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yanawoova venci ni yaanahimeryana: Tipani Yoola? Hata iphyoo, ni ipahari cinamwiiwelela? ");
INSERT INTO mgh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yahophiya nikhopela nikhwaya ntthiya, ilapo yo Yeraseno. ");
INSERT INTO mgh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu nalapuwile ahosiceriya ni ntthu aakhuma umahiye, avariye ni nnepa woonanara. ");
INSERT INTO mgh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Akhala umahiye, ni khaawo oorya ummara, mena vakani untthuka ni unyolo, ");
INSERT INTO mgh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","nlattu imaara cinci ahotthukiya ni unyolo mpaka wuntakaca unyolo ni unyakataca ikatiyato; khaawo oorya ummoniha. ");
INSERT INTO mgh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mahuku othene anaweetta, uthana ni uhiyu mmarekhano ni mmyaakoni, akhuwaka ni eerakalihaka ni maluku. ");
INSERT INTO mgh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Amoonaka Yesu uttayi, ahotthimakaca ni ahonkhoromela ni ");
INSERT INTO mgh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ahokhuwa ni ncu nowirunya: Nyu nrinani ni miyano, Yesu Mwana a Nluku Ooculu. Nhikoopopihe! ");
INSERT INTO mgh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ni khweeli, Yesu anamwiirela: Ukhume mwantthuni mu, nnepa woohiloka. ");
INSERT INTO mgh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wahoolo ahonkoha: Ncina naa tipani? Ahaakhula: Mphwinko phi ncina naka, nlattu niri enci. ");
INSERT INTO mgh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ni yahonlepela ankhanyererihaka wiira ahomoliye nttetthe ule. ");
INSERT INTO mgh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Caanalya vano ikuluwe nceresere mwaako, ");
INSERT INTO mgh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ni minepa coonanara cahonlepela Yesu: Nnilamulele nakele nkuluweni mmwe. ");
INSERT INTO mgh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ahorumelela, ni nenna nna minepa coonanara cahokhuma wantthuni ni cahokela nkuluweni, ni nikhoto nne nari toko ikuluwe elufu piili (2000) naheevonyera muntthiyani ni nahottittha. ");
INSERT INTO mgh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ahakheli yahotthawa ni yahovira alattulaka mmawaani; na atthu enci yahowa woona itthu yeeranele. ");
INSERT INTO mgh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Waphiyaya nipuro naryawe Yesu, yahomoona ntthu avariye ni minepa coonanara noonkomile, nawanre ni nakhalanne ankhili, ni yahoova. ");
INSERT INTO mgh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Asaahiti a ntthu oovariya ni minepa coonanara ni itthu yeranele ni ikuluwe yahottonka itthu yeranele. ");
INSERT INTO mgh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Vano yahoonlepela Yesu wiira athame ilapo aya. ");
INSERT INTO mgh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ahoturuwela okalawani; ni ntthu avariye ni minepa ");
INSERT INTO mgh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu khantthunihenre, nanso ahomwiirela: Urwee uwaanyaa, wamawaa ni wattonkacere citthu cothene cupankenlyaya Apwiya, ni toko ciwoonenlyaya ikiriri. ");
INSERT INTO mgh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ahokhuma wonwo, ni ahopacera uTekapoli itthu yampankenlyawe Yesu, na atthu othene yahotikhinaca. ");
INSERT INTO mgh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu nalapuwile ntthiya ni ikalawa, ni neemenle nceresere ntthiya wahothukumana mphwinko muulupale wa atthu. ");
INSERT INTO mgh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ahophiya vano muulupale o nsinakoka, eehaninya Cayro, ni umoona wawe Yesu, ahonkhoromela, ");
INSERT INTO mgh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ni ahonlepela ankhanyererihaka: Mwanaka mwanthiyana hanle vakani ukhwa; uwe unthatele matata akhale nkumi. ");
INSERT INTO mgh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu ahommeleela phutthariyaka ni mphwinko muulupale wamphunyereriha. ");
INSERT INTO mgh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vano, nthiyana mmoca awuva iphome iyakha khumi na piili, ");
INSERT INTO mgh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ni anaweettihiya venci mmatatani mwaya mayoovoniha enci, ni arihile mihakhu cawe cothene, nanso woohiphwanya nafasi, hata iretta awe yaanavira etepacaka. ");
INSERT INTO mgh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Neewile ca Yesu, ahotakaneela ni mphwinko, ni awaaka uttuli wawe ahonkwanya nihancu nawe; ");
INSERT INTO mgh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","aheecirela mweeco: Mena kakwanyaru cowara cawe, kimmovona. ");
INSERT INTO mgh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nananoru iphome yaheemela, ni ahoona mwirutthuni mwawe wiira ikwerere awe ihovona. ");
INSERT INTO mgh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nenna nna, Yesu, oonaka wiira ikuru awe yahokhuma mwirutthuni mwawe, ahorukunuwela mphwinko akohaka: Kikwanyile tipani? ");
INSERT INTO mgh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Owiitthuca awe yahomwiirela: Unawoona wiira miphwinko cinawuphunyereriha miphantte cothene, ni unakoha: Akikwanyile tipani? ");
INSERT INTO mgh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nanso Yesu ahoweha nceresere aphavelaka umoona ntthu apankile itthu ile. ");
INSERT INTO mgh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vano nthiyana ahocuwela ciheeranya mwirutthuni mwawe oovaka ni athukumelaka ahokhuma ahonkhoromela Yesu ni ahonhimerya citthu cothene. ");
INSERT INTO mgh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ni ule ahomwiirela: Mwanaka, ukupali waa uhowoopola. Urwee ni nnema ni uvone ikwerere aa. ");
INSERT INTO mgh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu uulumacaka ninlelo yahowa atthu akina akhumaka inupa awe muulupale o nsinakoka phwiiraka: Mwana aa hokhwa. ");
INSERT INTO mgh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu, nanso, neewile moolumo ale, ahomwiirela muulupale o nsinakoka: Uhituthuwe, ukupaliki paahi. ");
INSERT INTO mgh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ahaateliha othene wiira: Hikivelele ntthu, hikhanle Peturu, Yakopu ni Yohani, nhimaawe Yakopu. ");
INSERT INTO mgh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Uphiya waya uwaanyawe muulupale o nsinakoka, Yesu aheewa ikuttho yuulupale ya atthu enci yunlaka mpani. ");
INSERT INTO mgh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ni akelaka, ahaahimerya: Ikuttho ila wunla nwe isiyani? Mwana uyo kakhwile, narupa paahi. ");
INSERT INTO mgh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nanso atthu ale yaananthyaa, Yesu ahaakumihera utaa atthu ale othene ni aakusaka athumwane na anumwane, na ale yammelenle, yahokela mpani mwataleliye mwanamwane. ");
INSERT INTO mgh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ni ammaraka ntata, aheera: Mwanaka kinawulamulela, wunwe. ");
INSERT INTO mgh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nananoru mwanamwane ahoonwa ni ahopacera weetta, ari mweeco, ni iyaakha khumi na piili. Othene yahooma mwaano. ");
INSERT INTO mgh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ahaalepela wiira itthu ile ihicuweliye ni ntthu, ni aholamula uvahiya yoolya mwanthiyana. ");
INSERT INTO mgh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ukhuma wawe wenwe, ahorwaa wamoca ni owiitthuca awe. ");
INSERT INTO mgh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nihuku no ntivela ahopacera wiitthuciha nnsinakoka na atthu enci yamwiiwa, wanawooma mwaano ni yaanahimya: Inonkhuma vayi itthu ila ni ucuwelani uno uvahiyawe uno? Cinopankya cani cotikineeha nya ni ntata nawe? ");
INSERT INTO mgh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kahi nkarapintero, mwanawe Mariya, ni nhimaawe Yakopu, Yosefi, Yutta ni Simoni? Ni asirokorawe khari ni hi? Yahoviruwaca. ");
INSERT INTO mgh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu aheerela: Namilohi notarawiya uwaanyawe paahi, waama wawe ni wapuwani wawe. ");
INSERT INTO mgh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ni wonwo khoonrye upanka cotikineeha hata mena. Ahaavooniha aretta vakani paahi, athatelaka matata. ");
INSERT INTO mgh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ahotikhinaca uhikupali waatthu ale. Vano ahoviravira itthoko co wattamana eetthucihaka wonwo. ");
INSERT INTO mgh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aheehana khumi na eeli, ni ahopacera waruma eeli eeli, ni ahaavaha ikuru yolamulela minepa coonanara. ");
INSERT INTO mgh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ahaalamulela wiira ahikuse itthu yootthumiri ni iphiro, wala nkatthe, wala nrupa, mena nsurukhu nyununi, akuse ikopo paahi. ");
INSERT INTO mgh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aware ikwakwatta ni ahiwye ihancu piili. ");
INSERT INTO mgh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni ahaahimerya tho: Mwakelaka inupa, nkhale wonwo mpaka wunwa nipuro nno. ");
INSERT INTO mgh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ni mwahaakheleliyeke nipuro nno, na atthu ale yahiwiwekeni, woothama vale, nkukutthe ntthupi no manyaa enyu, wiira ikhale itthu inthoonyera mirima caya atthu ale. ");
INSERT INTO mgh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amitthenka yahorwaca ni yahaalaka atthu oottharuwela itaampi. ");
INSERT INTO mgh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yahoomola minepa coonanara ciinci, yahaattikitthela ni makhura aretta enci mpaka waavoniha. ");
INSERT INTO mgh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mwene Heroti aheewa cuulumaceriyaka ca Yesu, nanruma ncina nawe ni anawiira: Ula phi Yohani Mpatisa oonwelenle mwaatthu ookhwa, phimaana cinawithoonyera mwa ule ikuru coopanka cotikhineeha. ");
INSERT INTO mgh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Akina yaanawiira: Phi Eliya. Akina yanalipihera: Ri nnapiyu toko anapiyu akina. ");
INSERT INTO mgh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heroti nanso, wowiiwa itthu ila anahimya eeraka: Yohani unthikinlyaka isiko phunwelenle. ");
INSERT INTO mgh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Khweeli, Heroti phalamunle utthukiya Yohani ni weesiya nkalaposo, nlattu wa Herotiyata, amwaarawe Filipe nhimaawe, anthenlyawe. ");
INSERT INTO mgh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nlattu Yohani anamwiirela Heroti: Khunleveliya ukhalana amwaarawe nhimaa. ");
INSERT INTO mgh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herotiyata hopophela nreca ni anatthuna umwiiva, nanso khoorya, ");
INSERT INTO mgh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nlattu Heroti anamoova Yohani ni, acuwelaka wiira ari ntthu ooloka ni nttakattifu, anamwaakhiha; wamwiiwawe anasanka, nanso anammiriyana ni uciveliya. ");
INSERT INTO mgh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nanso nahophiya nihuku nooreera, Heroti wopuwelenlyawe nihuku nayariyawe ahophavela yoolya yinci yowaavaha oolupale owahano, oolupale anakhotto, ni mamwene o Kalileya. ");
INSERT INTO mgh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nakenle wiina mwana nthiyana a Herotiyata wahoncivela Heroti na atthu yaalattuliye. Mwene ahomwiirela mwali: Ukilepele itthu phi itthu intthunaa ni mi kimmowuvaha. ");
INSERT INTO mgh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ni ahopwahera: Kimmowuvaha itthu yothene inhalaa ukilepela hata ukhalaka mwanusu omwene aka. ");
INSERT INTO mgh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwali ahokhuma waakoha anumwane wiira: Kilepele isiyani? Ala yahaakhula: Muru wa Yohani Mpatisa. ");
INSERT INTO mgh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mwali akelaka tho nenna nna, ahonlepela mwene, eeraka: Kintthuna uvahiya nananoru, unaheliye munttiisini muru wa Yohani Mpatisa. ");
INSERT INTO mgh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mwene ahotuthuwa, nanso nlattu woolupela wawe ni, nlattu waatthu yaalatuliye, khathunne unthuwa. ");
INSERT INTO mgh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nenna nna ahonlamulela mayorontta uwiha muru wa Yohani. Mayorontta ahorwaa nkalaposo ni ahothikila isiko ya Yohani, ");
INSERT INTO mgh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ni wahoolo ahowiha muru munttiisini mpaka ummaha mwali, ni ula ahaavaha anumwane. ");
INSERT INTO mgh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ucuwela waya itthu ila owiitthuca a Yohani, yahokusa nrutthu ni yahothipela mmahiyeni. ");
INSERT INTO mgh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Amitthenka yahothukumana wa Yesu ni yahonttonkacera citthu cothene capankilyaya ni citthu cihilyaya. ");
INSERT INTO mgh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ni Yesu ahaahimerya: Mmweeke, nirwe nipuro nowiipithyaa ni mmumule vakani, nlattu yaari enci yaarwa ni yaawa mpaka uhikhalana ukati woolya. ");
INSERT INTO mgh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Vano yahorwaa ni ikalawa nipuro nowiipithyaa nahaariwo hata ntthu. ");
INSERT INTO mgh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yoonaka arwaka, enci yahocuwela ukitthu unkelaya. Ni mmatthokoni mothene yahorwaa, yeetaka vathi, nipuro nne, ni yahophiya nraci. ");
INSERT INTO mgh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wakhuruwawe nkalawani, Yesu ahoona mphwinko muulupale ni ahoonela ikiriri, nlattu yaari toko ikhontwaa cohikhalana nhaakheli. Vano ahopacera weetthuciha ukati mwinci. ");
INSERT INTO mgh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ncuwa wakelaya utthekuwa, owiitthuca awe yahomwattamerya nuunhimerya: Nipuro nna niri toko mwini, ni ncuwa notthekuwa. ");
INSERT INTO mgh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Walamulele urwaa mmawaani ni mmatthokoni cowattamana wiira yathume yoolya. ");
INSERT INTO mgh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ahaakhula: Mwaavahe nyenyu wa yoolya. Na ale yahonhimerya: Wothuma mikatthe cowavaha atthu ale othene, nimphavela ncurukhu iminya piili. ");
INSERT INTO mgh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu ahopwahera: Nhaana mikatthe mikavi? Nrwee moone. Anakohile atthu, yahaakhula: Mikatthe mithanu ni ihopa piili. ");
INSERT INTO mgh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ahaalamulela wonkomiha atthu vakani khila nipuro mmalasini makithi. ");
INSERT INTO mgh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ni yaanawunkoma khila ipuwa atthu iminya ni ipuwa ikhwawe atthu hansini. ");
INSERT INTO mgh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Vano ahokusa mikatthe mithanu ni ihopa piili ni, aweehaka wirimu, ahosukurela. Ahomyaniha mikatthe ni ahaavaha owiitthuca awe wiira yakawele atthu. Ni ahaakawela ihopa piili, ");
INSERT INTO mgh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","na atthu ale yaholya mpaka uvona. ");
INSERT INTO mgh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ni ahocariha tho itthuttu khumi na piili ikalakathela cahanle co mikatthe ni co ihopa. ");
INSERT INTO mgh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vano yalilyayo mikatthe nye yaari atthu elufu thanu. ");
INSERT INTO mgh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nananoru ahaakhanyereriha owiitthuca awe ukela nkalawani nuulapuwela nikhopela nikhwawe no Petsayita; mwaneene alaseraka mphwinko. ");
INSERT INTO mgh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Analasenre mphwinko ule, ahowela umwakoni, uswali. ");
INSERT INTO mgh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wiila waya, ikalawa yari iriyari ntthiya, ni Yesu aheemela nceresere veekhawe. ");
INSERT INTO mgh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Woona wawe wiira yahoocya weettiha ikalawa nlattu iphyoo yanavirikana, aheekamela weeraka mapikoosa, eettaka wamaasini mpaka utthuna uhapuwa. ");
INSERT INTO mgh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nanso owiitthuca yamoonaka weetta wamaasini yahopuwela wiira nnepa, ni yahokhuwa. ");
INSERT INTO mgh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Othene mweeco yahomoona ni yahotuthuwa. Mwaneene nanso aholumacera, eeraka: Mpise nrima, phi mi, nhoove! ");
INSERT INTO mgh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wahoolo, ahokela nkalawani mwariyaya, ni iphyoo yahowukuwa. Othene yanawoova venci. ");
INSERT INTO mgh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Khayeewehile ni nlelo itthu yeranele ni mikatthe nye nlattu woolipa mirima caya. ");
INSERT INTO mgh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Analapuwenle ukhopela, ahophiya ilapo yo Yenesare ni ahovonyera vathi nankura. ");
INSERT INTO mgh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Anakhumile nkalawani, atthu uwonwo yahoncuwela. ");
INSERT INTO mgh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yahophiya atthu enci olapo ile ni yahopacera wawiha aretta mmarepani ni aharweha nipuro nacuwenlyaya wiira phiryawe. ");
INSERT INTO mgh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mmatthokoni makani, itthoko cuulupale ni mmawaani, nipuro phi nipuro nakelawe yanaweesiya aretta mparaparani ni yahoonlepela wiira aleve mena ukwanyiya nlempe no nhancu awe. Na atthu othene yankwanya yanavona. ");
INSERT INTO mgh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mayowantikha ni mafarisi akina, akhumaka o Yerusalemu, yahothukumana ntotho wawe Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yahoona wiira owiitthuca awe akina yanalya nkatthe ni matata oohirya, manaaya woohinyawa. ");
INSERT INTO mgh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafarisi ni Ayutta othene khanlya woohinyawa ratta ratta, toko calemalenlyaya atthu ookhalayi. ");
INSERT INTO mgh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Waturuwaya uparasa, khayalya ihinaya unyawa; ni cihaawo tho citthu cinci cikina cimpankaya attharaka citthu cookhalayi, toko urapiha ikahi, myaapu, ni myaapu co ncukhuma ni mikori. ");
INSERT INTO mgh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yahonkoha vano, mafarisi ni mayowantikha: Owiitthuca aa ahiwelelaka citthu cookhalayi, alyaka ahinyawile, isiyani? ");
INSERT INTO mgh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ahaakhula: Hohimya ratta nnapiyu Isayiya, awacakani nyu, atthu o mirima miili, toko cantikhiyaya: Mphwinko ula unakittitthimiha ni mattere, nanso nrima aya unkhala uttayi waka. ");
INSERT INTO mgh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Anakilapela vathiru, ni yeetthucihaka malamulo a atthu paahi. ");
INSERT INTO mgh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ahiyaka nlamulo na Nluku, phuttharaka coohiyerana ca atthu, toko urapiha myaapu ni ikahi ni citthu cinci colikana nnya. ");
INSERT INTO mgh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ni aheerela: Nnahiya ntteeliyaka nlamulo na Nluku wiira nthareke coohiyerana cinyu. ");
INSERT INTO mgh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa, mweeco, heera: Wattittimihe athumwanaa na anumwanaa; ni Ntthu nohala walapha athumwane na anumwane attarusiye ni eeviye. ");
INSERT INTO mgh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nyu nanso nneera: Ntthu nohala wahimerya athumwane atthuna anumwane: Itthu yahalaka wuvahani nyuva phi ila 'korpan' manaaya, itthu yoovahiya Apwiya. ");
INSERT INTO mgh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ciicammo khanonhiyera ntthu itthu yowapankela athumwane atthuna anumwane, ");
INSERT INTO mgh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","mmalihaka ciicammo nuulumo na Nluku nlattu wo coohiyerana cookhalayi cinvahenyu. Ni napanka citthu cinci toko nnya. ");
INSERT INTO mgh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eehanaka tho mphwinko, Yesu anawahimerya: Nkiviriyane othene, ni mwavye wiiweha. ");
INSERT INTO mgh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khiiwo iri utaa wawe ntthu, ineera inakenle nhina mwawe, phoorya untatusa iharamu; nanso inkhuma muntthuni, ila phinoorya untatusa iharamu. ");
INSERT INTO mgh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ntthu urina manyaru uwiiwelela, eewe! ");
INSERT INTO mgh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wakenlyawe mpaani, nahile mphwinko, owiitthuca awe yahonkoha manaaya nlikanihero nna. ");
INSERT INTO mgh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ahaakhula: Nyu ciicammo khaneeweha? Khannocuwela wiira, citthu cothene co utaa cinkela muntthuni, khacinoorya untatusa iharamu, ");
INSERT INTO mgh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","nlattu khinkela munrimani, nanso nnapwiipwini mwawe, ni wahoolo inakhumela wanipuroni waya? Ciicale anahimya wiira coolya cothene cooreera. ");
INSERT INTO mgh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ni ahohimya tho: Itthu inkhuma muntthuni, yeeyo phinontatusa iharamu. ");
INSERT INTO mgh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nlattu nhina nrima wantthu phinkhumaya moopuwelo oonanara: ulavalava, wiinya, wiiva, ");
INSERT INTO mgh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uraruwa, isoyo, wunlela coonanara, uthepya, uhilemeliha irutthu, urama, ukufuru, wiicona, uhiwacera itthu yomaana. ");
INSERT INTO mgh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Citthu nnye cothene coonanara cinkhuma nhina, ni cinantatusa ntthu nharamu. ");
INSERT INTO mgh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Akhoolaka nipuro nne, ahorwaa nttetthe wo Tiro ni wo Sittoniya. Ahokela mpani ni khatthuna wiira acuweliye ni ntthu, nanso khoonrye wiipitha. ");
INSERT INTO mgh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vano wohipica nthiyana arina mwanawe mwanthiyana avariye ni nnepa woonanara weewilyawe wuulumaciya ca Yesu, ahowa unkhoromela wamettoni wawe. ");
INSERT INTO mgh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ari nthiyana nsenci, olapo yo Siriya-Fenisiya, ni ananlepela wiira oomole ncini wa mwanawe. ");
INSERT INTO mgh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ahaakhula: Wareerihe, toko, avone oopacera asaana; woona khavanreera ukusa nkatthe wa asaana ni warihela asilapwa! ");
INSERT INTO mgh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ale mweeco, yahomwakhula: Khweeli, Pwiya, nanso hata asilapwa analya vathivaya meeca coolya ca asaana cimmora-mora. ");
INSERT INTO mgh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu ahomwiirela: Nlattu wo nuulumo nna, urweke, ncini nookhuma mwa mwanaa. ");
INSERT INTO mgh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ahoturuwela uwaani ni ahomphwanya mwamhima nonkomile wakorini. Ncini nahonhiya. ");
INSERT INTO mgh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nakhumile tho nttetthe wo Tiro, ahowela o Sittoniya, mpaka ntthiya no Kalileya, aphulanihaka nttetthe wo Kapole. ");
INSERT INTO mgh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yahomwiihera ntthu oohiwa, ni wanrikarikela wuulumaca, ni yahonlepela wiira anthatele ntata. ");
INSERT INTO mgh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu antamihaka waatthuni ahonhela makokho mmanyaruni ahonsuwela ni ukwanya nlimi ni isene. ");
INSERT INTO mgh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ni awusaka miitho wirimu ahohihimerya, eeraka: 'Effatha' manaaya 'wiihule.' ");
INSERT INTO mgh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Manyaru yahonhulya namarweele, nlimi nawe nahontthukuwa ni ahopacera wuuluma ratta. ");
INSERT INTO mgh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu aheera wiira hinhimerye ntthu itthu yeraneele, nanso waatepawe waateliha, phaatepaya umwarusela. ");
INSERT INTO mgh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atikhinacaka, yaanawiira: Cothene nopanka cotikhineeha, heewiha atthu uhiwa, ni wuulumaciha atthu oohuulumaca. ");
INSERT INTO mgh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mahuku ale, ukhala wiira wahotthukumana tho mphwinko muulupale na atthu khayarina yoolya, Yesu aheehana owiitthuca awe ni ahaahimerya: ");
INSERT INTO mgh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ukiiriha ihaaya mphwinko ula. Nna va ahovira mahuku mararu anari ni mi ni kharina yoolya. ");
INSERT INTO mgh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kaalaseraka ciicale woohilyetthu, wiira arwe mmwanyaya anaahala ukhwa mahile ni iphiro, kontha akina akhumile uttayi. ");
INSERT INTO mgh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Owiitthuca awe yahomwaakhula: Nohala woorya cani ntthu waaliha nkatthe, watakhwani va? ");
INSERT INTO mgh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nanso ahaakoha: Nrina mikatthe mikavi? Yahaakhula: Mithanu na miili. ");
INSERT INTO mgh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aholamula wiira atthu yunkome vathi. Ni, akusaka mikatthe mithanu na miili, ahoreeriha, ahomyaniha ni ahaavaha owiitthuca awe, wiira yakawele na ale yahaakawela atthu. ");
INSERT INTO mgh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yahaana tho asihopa vakani. Ahoreeriha ni aholamula wiira yaakawele. ");
INSERT INTO mgh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yaholya mpaka urupala, ni ikalakathela cahanle nyo owiitthuca awe yahottottela itthuttu thanu na piili. ");
INSERT INTO mgh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Atthu ale yaari elufu cese (4000). Wahoolo ahaalasera. ");
INSERT INTO mgh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ni awelaka vano nkalawani ni owiitthuca awe, ahorwaa mittetthe co Talmanuta. ");
INSERT INTO mgh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yahowa mafarisi yapacenre unyakulihana ni Yesu ni woontteha yahoonlepela ikanyero yo wirimu. ");
INSERT INTO mgh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu ahihimeryaka ni nrima wothene, aheera: Nlattuni weesiyani nihimo nna ninalepelela ikanyero? Khweeli kinawuhimeryani wiira nihimo nna khaninhala uvahiya ikanyero hata vakani. ");
INSERT INTO mgh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ni aahiyaka, ahokela nkalawani, mpaka ulapuwela ikhopela ikina. ");
INSERT INTO mgh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Owiitthuca yaholiyala uwya mikatthe, ni nkalawani khayaarina tho waari nkatthe mmoca paahi. ");
INSERT INTO mgh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu aheerela: Moone, nkhale miitho mmwehaka ratta miropo co mafarisi ni miropo ca Heroti. ");
INSERT INTO mgh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na ale yahopacera uvanyihana, yoopuwelaka wiira waaciye uhikhalana nkatthe. ");
INSERT INTO mgh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu nanso, weewilyawe moolumo ale, ahaahimerya: Nlattu isiyani moopelaka mwaha o itthu yohikhalana nkatthe? Nanlelo khannahelelela ni khanneeweha? Nri ni nrima woturumala. ");
INSERT INTO mgh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nhaana miitho ni khannoona? Nhana manyaru nanso kanneewa ni khannopuwela. ");
INSERT INTO mgh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Itthuttu kavi coocara ni coohala caattottenlenyu, wamyanihilyaka mikatthe mithanu kaakawelaka atthu elufu thanu? Yahaakhula: Khumi na piili. ");
INSERT INTO mgh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ni wamyanihilyaka mikatthe saapa pwaavahaka atthu elufu cese, mwacarihile itthuttu kavi cokalakathela co mikatthe? Yahaakhula: Saapa. ");
INSERT INTO mgh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ni anaweerela: Nanlelo khanneewa? ");
INSERT INTO mgh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ni owiitthuca awe yahophiya o Petsayita ni yahomwiihera ntthu oohoona, anlepelaka wiira ankwanye. ");
INSERT INTO mgh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ahommarela ntata ntthu oohoona ni ahonrweha nceresere itthoko, ahonhela isenye mmithoni mwawe, ahonthatela matata nuunkoha: Unawoonaka itthu? ");
INSERT INTO mgh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ule ahoteesa miitho ni aheerela: Kinawoona atthu, yeettaka ankhala toko miri. ");
INSERT INTO mgh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ahonthatela tho matata mmiithoni, ni ule ahopacera woona uparapara, ni ahovona, oonaka rattaratta uttayi ni uparapara citthu cothene. ");
INSERT INTO mgh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu vano ahonlamulela urwaa uwaani, ni ahomwiirela: Uhikele mena umawaani. ");
INSERT INTO mgh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ahoonwa na owiitthuca awe, akelaka umawaani co Sesareya wo Filipe. Mphironi ahaakoha owiitthuca awe, eeraka: Atthu ayo aneera wiira Mi kipani? ");
INSERT INTO mgh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yahomwiirela: Yohani Mpatisa, akina Eliya, ni akina tho aneera wiira uri mmoca mwa anapiyu. ");
INSERT INTO mgh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ni ahaakoha: Ni nyu nneera Mi kipani? Peturu ahaakhula: We uri Kristu. ");
INSERT INTO mgh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ahaalamulela vano, wiira ahinhimerye ntthu itthu ila. ");
INSERT INTO mgh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wahoolo ahopacera weetthuciha wiira Mwanawe Pinattamu naahala uhuva venci ni ukhottiya ni mahumu, ni oolupale a mayasataka, ni mayowantikha, mpaka wiiviya ni wunwelela anavinre mahuku mararu; ");
INSERT INTO mgh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ni anawahimerya itthu ila wohakhuwa-khuwa. Peturu ahomwiihana Yesu ni ahopacera unkuphula. ");
INSERT INTO mgh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu nanso arukunuwaka, ni awehaka owiitthuca ahonkuphula Peturu, eeraka: Uthame wiitho aka, Sotwani, kontha khummwacera citthu ca Nluku, nanso paahi citthu ca atthu. ");
INSERT INTO mgh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eehanaka mphwinko wa atthu wamoca ni owiitthuca awe, aheerela: Ntthu, atthunaka ukitthara, eerune mwaneene, akuse nsalapa awe ni akitthare. ");
INSERT INTO mgh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nlattu, ntthu nohala uphavela woopola ukumi awe unanrihya, ni unhala unrihya nlattu wo miyano, ni nlattu wo Nhupi Wooreera nowowopola. ");
INSERT INTO mgh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Enhala ukhuma isiyani, ntthu uphwanya ittuniya yothene ni arihaka nnepa awe? ");
INSERT INTO mgh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Atthuna ntthu nohala uvaha isiyani wo wakakhaniha nnepa awe? ");
INSERT INTO mgh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ntthu mweeco nohala wuliya muru nlattu wo Miyano ni nlattu wo moolumo aka wamiithoni wanloko nna nookosakosa nimwalaanne ni Mi, ciicammo, Mwanawe Pinattamu naahala wuliya muru nlattu wa ale aphiyaka o nnemani wa Athumwane wamoca ni Ancelo attakattifu. ");
INSERT INTO mgh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ahaahimerya tho: Khweeli kinawuhimeryani wiira akina mwaala ari vava khanhala ukhwa ahinaya woona omwene wa Nluku uwaka ni ikuru caya. ");
INSERT INTO mgh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Anavinre mahuku siita, Yesu ahaakusa Peturu, Yakopu ni Yohani, ni ahaaweliha veekhaya, mwaako woorekama. Ni aheetatusa wamiithoni waya. ");
INSERT INTO mgh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Coowara cawe cahothatuwa coowarya, cootteela usilili toko khaawo mayokattha vathiva uwoorya utteeliha ciicale. ");
INSERT INTO mgh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ahaakhumelela Eliya wamoca ni Musa ni ooyeli yanawuulumaca ni Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peturu ahomwiirela Yesu: Mwalimu oreera ukhala vava, niteke marapattha mararu, nimoca na waa, nikina na Musa nikhwawe na Eliya. ");
INSERT INTO mgh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kontha khayaacuwela itthu yaahimyawe nlattu yanawoova venci. ");
INSERT INTO mgh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ni nahokhuruwa nihutte nakhunenle ni ntthuuci, ni nahokhuma ncu nnihutteni neera: Ula mwanaka oofentiya. Yooyo mwiiwe. ");
INSERT INTO mgh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nenna nna, awehaka, khayamoonne tho ntthu, ari Yesu veekhawe. ");
INSERT INTO mgh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wakhuruwaya mmwakoni, Yesu ahaalamulela wiira ahihimerye ntthu itthu yoonyaya, mpaka wahoolo Mwanawe Pinattamu nonwelenle mwaatthu ookhwa. ");
INSERT INTO mgh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ale yahotthara moolumo ale, nanso yaanakohana ayayoru manaaya, 'wunwelela mwaatthu ookhwa.' ");
INSERT INTO mgh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ni yahonkoha yiiraka: Mayowantikha aneerelani wiira woopacera Eliya phinhala uwa? ");
INSERT INTO mgh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ahaakhula: Aye, Eliya, awaaka woopacera naahala weesa wanipuroni waya citthu cothene, nanso yantikhiye isiyani ya Mwanawe Pinattamu, wiira nalamuliya uhuva venci, nuunyoholiya. ");
INSERT INTO mgh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ni mi mweeco kinawuhimeryani: Eliya ahowa, ni yahompankela cothene catthunaya, toko caantikhiye. ");
INSERT INTO mgh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Naphile waryaya owiitthuca awe ahoona mphwinko muulupale wa atthu warukurenrye ayoca, ni mayowantikha anyakulihanaka na ale. ");
INSERT INTO mgh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Amoonakaru Yesu yahotikhina ni yahotthimakaca unkoha isalama. ");
INSERT INTO mgh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ni ule ahaakoha ale: Nnonyakulihanani? ");
INSERT INTO mgh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ntthu mmoca mwa mphwinko ule, ahomwiirela: Mwalimu, kihowiihera mwanaka, rina nnepa woohuulumaca. ");
INSERT INTO mgh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wammaraka vale, unamphatela vathi ni ule napacera ukhuma niphooru, ucekesa miino ni phuumaka teyeye. Kihaalepela owiitthuca aa wiira yoomole ncini, nanso khayoonrye. ");
INSERT INTO mgh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu aheerela: Nyu, nloko noohikupali, kinhala ukhala ni nyu mpaka yakhani? Kinhala wuvilelani mpaka yakhani? Nkiwiihere woono. ");
INSERT INTO mgh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yahommwiihera. Nimoonakaru Yesu, ncini nahompukunyaa mwanhima ni ikuru, mpaka umphatela vathi, ni ahopacera uphirikyaa akhumaka niphooru mwano. ");
INSERT INTO mgh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu ahaakoha athumwane: Itthu ile inomwiiryanyaa ikhumelo yakhani. Na ale yahaakhula: Ikhumelo mwanamwane, ");
INSERT INTO mgh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ni imaara cinci nahommonyera wamooroni ni mmasini wiira amwiive, nanso wooryaka vale upanka itthu, unoonele ikiriri, nuunikhavihere. ");
INSERT INTO mgh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ahomwiirela: Wooryaka! Ntthu nokupali citthu cothene cinawooryanyaa. ");
INSERT INTO mgh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nenna nna, athumwane mwana oyo yahokhuwa: Kinakupali; nkikavihere uhikupali waka! ");
INSERT INTO mgh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu, oonaka wiira atthu enci yanawa, aholamulela nnepa woonanara ni aheerela: Nnepa wohuulumaca ni wohiwa, Mi kinawulamulela, ukhume wamwana ola, nuuhinturuwele tho. ");
INSERT INTO mgh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ni nnepa, ukhuwaka ni wicipulacaka ni ikuru, wahokhuma. Mwanhima ahokhala toko ookhwa, mpaka atthu enci wiira hokhwa. ");
INSERT INTO mgh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nanso, ammaraka ntata, Yesu ahommusa, ni ule aheemela. ");
INSERT INTO mgh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ukelawawe mpani, owiitthuca yahonkoka veekhawe: Nlattuni hiyano khanoonrye woomola? ");
INSERT INTO mgh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ahaakhula: Nloko nna ninoomoliya ni iswali ni utthuka paahi. ");
INSERT INTO mgh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Akhumaka wonwo yahottupulaniha ilapo yo Kalileya, ni Yesu khatthuna wiira acuweliye ni ntthu, ");
INSERT INTO mgh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nlattu anavira eetthucihaka owiitthuca awe ni anaweerela: Mwanawe Pinattamu naahala urwehiya mmatatani mwaatthu anhala umwiiva, nanso, nakhwile nowowunwelela anavinre mahuku mararu. ");
INSERT INTO mgh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nanso ayo khayeewehile nuulumo nne, ni yanamoova unkoha. ");
INSERT INTO mgh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yahophiya uKafarnaum, ni, anari uwaani, Yesu ahaakoha: Mwavanyihanani mphironi? ");
INSERT INTO mgh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yahomaalaca, nlattu mphironi yanavanyihana ayayoru, wiira tipani ri muulupale mwaale. ");
INSERT INTO mgh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Unkomaka, Yesu aheehana owiitthuca awe khumi na eeli ni ahaahimerya: Ntthu aphavelaka ukhala muulupale, eepanke mwankani mwaatthu, ni akhale nrumeyi a atthu othene. ");
INSERT INTO mgh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ni ankusaka mwanamwane, ahomweesa iriyari aya, ahommarela ni aheerela: ");
INSERT INTO mgh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ntthu nomwaakhela mwanamwane toko ula mwancina naka, nokaakhela Miyano, ni ntthu nokaakhela Mi, khankaakhela Mi, nanso Ule kirumile. ");
INSERT INTO mgh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohani ahonhimerya: Mwalimu, nihomoona ntthu oomolaka macini mwancina naa, ni ntthu ule khannitthara, ni nihomwaateliha. ");
INSERT INTO mgh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ahaahimerya: Nhimwaatelihe, nlattu khaawo nopanka cotikhineeha mwancina naka phukaapa mi nenna nna. ");
INSERT INTO mgh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ntthu hinoniina, nawiraana ni hi. ");
INSERT INTO mgh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ntthu novahani ikoopu yo maasi wiira mmurye nlattu wokhala owiitthuca awe Kristu, khweeli, kinawuhimeryani, khankela ahalelaka itthuvo awe mena vakani. ");
INSERT INTO mgh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ntthu nohala unkosiha mmoca mwaasinamwane ala ankikupali Mi, fatari atthukeleliye nsiko mmo nsilo noosileliya ni avonyeriye mpaharini. ");
INSERT INTO mgh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ntata naa nookosihaka, uthikile. Unareera ukela wokumini ni ntata noopahuwa, wahohiyana ukhalana matata oomeli ni urwaa umooroni oohinttiphyaa. ");
INSERT INTO mgh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wonwo uhinkhwa asunku, ni mooro khunttiphyaa. ");
INSERT INTO mgh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nnya naa nookosihaka, uthikile. Unareera ukela wokumini unapahuwile, wahohiyana ukhalana oomeli uvonyeriyaka umooroni. ");
INSERT INTO mgh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wonwo uhinkhwa asunku, ni mooro khunttiphyaa. ");
INSERT INTO mgh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ni niitho naa nookosihaka, uphele. Unareera ukela umweneni wa Nluku ni niitho nimoca, wahohiyana ukhalana oomeli uvonyeriyaka umooroni. ");
INSERT INTO mgh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wonwo uhinkhwa asunku, ni mooro khunttiphyaa. ");
INSERT INTO mgh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Phimaana khula ntthu naahala ulukiya ni mooro. ");
INSERT INTO mgh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maakha phi itthu yooreera; nanso yathatuwaka ooririya, ammolukiya ni isiyani? Nkhalaneke maakha mwanyu ni mweetteke ni mpuha ntthu ni nkhwawe. ");
INSERT INTO mgh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nakhumile wonwo, ahokela nttetthe wo Yutteya ni ukhopela mooloko Yorttani, ni mphwinko unathukumanne tho nipuro naryawe, anaweetthuciha tho, toko calemalenlyawe. ");
INSERT INTO mgh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yahomwattamerya mafarisi ni yahonkoha anttehaka: Iri yooreera nlopwana wamwalaana amwaarawe? ");
INSERT INTO mgh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ahaakhula: Musa holamulenleni isiyani? ");
INSERT INTO mgh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yahomwaakhula: Musa holevela waavaha iwarakha yoomwalaana, ni waahiya. ");
INSERT INTO mgh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ahaakhula tho: Nlattu woolipa winyu nrima phuvahilyaweni nlamulo nno. ");
INSERT INTO mgh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nanso, wupattusoni wolapo, Nluku ahompanka nlopwana ni nthiyana. ");
INSERT INTO mgh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Phimaana, nlopwana naahala waahiya athumwane na anumwane ni nokookhala na amwaarawe. ");
INSERT INTO mgh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ni ooyeli ankookhala irutthu imoca. Phimaana, khankhala tho eeli, nanso irutthu imoca. ");
INSERT INTO mgh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vano, yooluttanihiya ni Nluku, khimwalaanihiya ni ntthu. ");
INSERT INTO mgh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anaphile uwaani, owiitthuca awe yahonkoha tho itthu ile. ");
INSERT INTO mgh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ahaahimerya: Ntthu nohala wamwalaana amwaarawe ni waathela akina, neetta uluva ni nthiyana ule, ");
INSERT INTO mgh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ni nthiyana ammwalaanaka mannawe nuutheliya ni nkina, neetta uluva. ");
INSERT INTO mgh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yahomwiihera asinamwane wiira aakwanye, nanso owiitthuca yahakuphula ale yawihile asaana. ");
INSERT INTO mgh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu, oonaka itthu ile ahonyonyiya ni aheerela: Mwalevele, amirawo akiweele, ni nhoomole, nlattu omwene wa Nluku uri wa waya. ");
INSERT INTO mgh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Khweeli kinawuhimeryani, ntthu hinhala waakhela omwene wa Nluku toko mmirawo, khanhala ukela wonwo. ");
INSERT INTO mgh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wahoolo ahaakusa vayawani phwathatelaka matata ni ahaareeriha. ");
INSERT INTO mgh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wakhumilyawe eettaka ni iphiro, ahomwattamerya ntthu atthimakacaka, ni akhoromelaka ahonkoha: Mwalimu ooreera, kipankekeni wiira kiphwanye ukumi woohimala? ");
INSERT INTO mgh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ahonhimerya: Nnokihanelani ooreera? Khaawo ooreera hikhanle Nluku paahi. ");
INSERT INTO mgh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Unacuwela malamulo: Uhiive, uheette uluva, uhiinye, uhoothe, uhithepye, waalemelihe athumwanaa na anumwanaa. ");
INSERT INTO mgh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ahomwaakhula: Mwalimu, cothene nnya kihosunka ikhumelo mmirawo. ");
INSERT INTO mgh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ammwehecesaka, ahomfenta, ni ahomwaakhula: Inawuhaleela itthu imoca paahi; Urwee, watumihe citthu cothene cirinaa, waavahe nsurukhu uyo atthu oothwenya, ni ommokhalana nhakhu wirimu; uwe ni ukitthare. ");
INSERT INTO mgh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nanso, weewilyawe moolumo ale, ahothulana ni ahothama ni icuku, nlattu arina mihakhu cinci. ");
INSERT INTO mgh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Awehaka nceresere, Yesu aheerela owiitthuca awe: Urikarika venci, atthu oothaciri ukela wumweneni wa Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Owiitthuca wahooma uwanoni, wowiiwa moolumo ala. Nanso Yesu ahopwahera: Asaana aka, cirikarikilyaya ukela wumweneni wa Nluku, ale ankhuluvela mihakhu. ");
INSERT INTO mgh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Khavarikile uvira nkamira mwiithe wo sinkano, uhohiyana ukela thaciri wumweneni wa Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ale yahotikhina wootepa nanlelo ni yanawiirelana ayayoru: Vano, tupani nohala woopwa! ");
INSERT INTO mgh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Awehecesaka, Yesu ahaakhula: Na atthu khinooryaniya, nanso ni Nluku citthu cothene cinawooryaniya. ");
INSERT INTO mgh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peturu ahopacera unhimerya: Hi nihohiya cothene nihottharani. ");
INSERT INTO mgh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ahaakhula: Khweeli kinawuhimeryani wiira khaawo ntthu nohala uhiya inupa awe, asunnawe, asirokorawe, athumwane na anumwane, asaana atthuna imatta awe nlattu wo Miyano, ni nlattu wo Nhupi Wooreera, ");
INSERT INTO mgh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","phihaakhela mpaka imaara iminya, nanano ukati ula urihula, inupa, asunnawe, asirokorawe, anumwane, asaana ni imatta, wamoca ni womolanihaciya, ni wahoolo ukumi woohimala. ");
INSERT INTO mgh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Enci oopacera ankokhala uwiheerya, ni uwiheerya ankokhala oopacera. ");
INSERT INTO mgh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Owiitthuca yaanaweetta ni iphiro, awelaka uYerusalemu, ni Yesu anaweetta uhoolo waya. Yanatikhina ni yaanantthara ni woova. Ahaakusa tho owiitthuca khumi na eeli, ahopacera wahimerya itthu yahala umwiiranela, ");
INSERT INTO mgh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","eeraka: Mwiiwe, ninawela oYerusalemu, ni Mwanawe Pinattamu naahala urwehiya mmatatani moolupale a mayasataka ni mayowantikha, na ale anaahala ummaanela umwiiva nuunrweha waasenci. ");
INSERT INTO mgh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Anaahala untarawa, unsuwela wiitho, umwapsyulaca nuumwiiva, nanso nihuku noneeraru naahala wunwelela. ");
INSERT INTO mgh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakopu ni Yohani, asaana a Sepetteu, yahomwattamerya ni yahomwiirela: Mwalimu, nimphavela, unipankele yothene inhalehu wulepela. ");
INSERT INTO mgh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ahaakoha: Nnophavela kuupankeleni isiyani? ");
INSERT INTO mgh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yahomwaakhula: Wumweneni waa, nunkome, mmoca mono nlopwana, ni nkina mono nthiyana. ");
INSERT INTO mgh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ahaakhula: Khannocuwela itthu inlepelenyu. Nnawoorya uwurya ikoopu inhalaka uwurya, ni waakhela upatiso unhalaka waakhela? ");
INSERT INTO mgh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yahomwaakhula: Aye, ninawoorya. Yesu ahaahimerya: Nnowowurya ikoopu inhalaka uwurya, ni nnowopatisiya ni upatiso unhalaka upatiseriya, ");
INSERT INTO mgh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","nanso, wunkoma mono nlopwana atthuna nthiyana kahi phi Mi kinvaha, anovahiya ale asunkeriye. ");
INSERT INTO mgh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Akina khumi, yiiwakaru itthu ile, yahonyonyiya ni Yakopu ni Yohani. ");
INSERT INTO mgh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu aheehana ni aheerela: Nhocuwela cimpankaya alamuli onlaponi wiira acuwanehe iyulupale aya mmalokoni ni mahumu aya. ");
INSERT INTO mgh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nanso ni nyuva khunhala ukhala commo. Ntthu nophavela ukhala muulupale mwa nyu eepanke nrumeyi, ");
INSERT INTO mgh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ni nophavela ukhala oopacera mwa nyu eepanke ipottha ya atthu othene, ");
INSERT INTO mgh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","nlattu Mwanawe Pinattamu khaawile uvareliya nteko, nanso uvara nteko ni uvaha ukumi awe wiira oopole atthu enci. ");
INSERT INTO mgh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yahophiya uYeriko. Wakhumaya uYeriko ni owiitthuca awe, ni mphwinko muulupale, Partimeu, mayoolepela oohoona, mwanawe Timeu, ahonkoma nceresere iphiro aphavelaka ulola. ");
INSERT INTO mgh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Weewilyawe wiira Yesu o Nasaree anavira, ahokhuwa: Yesu, Mwanawe Taviti, ukoonele ikiriri. ");
INSERT INTO mgh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Atthu enci yanankuphula wiira ammaalihe, nanso anapwaha ukhuwa khula imaara wootepa eeraka: Mwana a Taviti, ukoonele ikiriri. ");
INSERT INTO mgh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu aheemela ni aheera: Mmwiihane. Yahomwiihana ntthu uhoona yiiraka: Ulipe nrima, wunwe, nawiihana. ");
INSERT INTO mgh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ni ule, arulaka ikacako awe, ahotupha ni ahorwaa waYesu. ");
INSERT INTO mgh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ahonkoha: Untthuna kupankele isiyani? Oohoona ahaakhula: Mwalimu, koone. ");
INSERT INTO mgh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ahonhimerya: Urwee, ikupalelo aa ihowoopola. Ni nananoru ahoona ni ahontthara Yesu mphironi. ");
INSERT INTO mgh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Naattamenrye uYerusalemu, vakhiviru ni Petifaki ni Petaniya, cooco ni mwako Olivera, Yesu ahaaruma owitthuca awe eeli, ");
INSERT INTO mgh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ni ahaahimerya: Nrwee iwaani yowaattamana, mwakelaka nnamphwanya mwaapuru ootthukiya, hinaya uweliya ni ntthu. Mwantthukule ni nkiwiihere. ");
INSERT INTO mgh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Akhalaka ntthu nookohani, nlattuni mpankaka ciicammo. Mwaakhule Apwiya anamphavela, ni ankowuturuselani wowakuvyaca. ");
INSERT INTO mgh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yahorwaa phumphwanyaka mwaapuru natthukeleliye wankhorani, mphante wovate woluwani, ni yahontthukula. ");
INSERT INTO mgh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ni atthu yaari wonwo yahokoha: Nnopankani muntthukulaka mwaapuru? ");
INSERT INTO mgh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yahaakhula toko Yesu cahimenrawe, ni yahaahiya urwaca. ");
INSERT INTO mgh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yahonrwehela Yesu mwaapuru uyo, yahonkhunela cowara caya, ni Yesu ahomwela. ");
INSERT INTO mgh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Atthu enci yaanawatala cowara caya mphironi, akina yamwarusela miritha cikithi caathikinlyaya mmattani. ");
INSERT INTO mgh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Atthu yahoonle na ale yantthara yanakhuwa: Hosaana, noreeriya nowa mwancina na Apwiya. ");
INSERT INTO mgh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uhoreeriya omwene umwa wa athumwanihu Taviti. Hosaana wonculu. ");
INSERT INTO mgh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ahophiya uYerusalemu, Yesu ahokela Inupa ya Nluku, ni namanle uweha citthu cothene canrukurenrye, wahokhala yocoocilo, ahokhuma, phurwaka uPetaniya ni owiitthuca awe khumi na eeli. ");
INSERT INTO mgh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wasilyaya wicisu wakhumaya uPetaniya, Yesu yahommola itala. ");
INSERT INTO mgh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Oonaka uttayi mwiri wonhokorokho waari ni matakhuru aya makithi, ahorwaa uweha wakhala wiira uhaawo nhokorokho wowiima, nanso attameryaka, khaphwanyile, aphwanyile matakhuru paahi, kontha khawari ukati wowiima mihokorokho. ");
INSERT INTO mgh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aheerela vano: Hikhale tho nohala ulya cowiima caa. Ni owiitthuca awe yaheewa itthu ile. ");
INSERT INTO mgh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yahophiya uYerusalemu, ni akelaka Inupa ya Nluku ahopacera woomola mayothumiha, na ale yathuma wonwo, ahokakhela vathi meeca a atthu yaakakhaniha, ni ihice ca atthu yathuma ikhuntta. ");
INSERT INTO mgh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ni khaalevela wiira ikusiye itthu yakhuma Inupa ya Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ni anaweetthuciha eeraka: Ihantikhiya: Inupa aka inowowihaninya inupa yoswali uneethi wothene. Nanso nyu nhotatusa nikhuku na namwiinya. ");
INSERT INTO mgh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oolupale a mayasataka ni mayowantikha yaheewa itthu ile, ni yaanaphavela mananna umwiiva, nanso yaanamoova, nlattu mphwinko wothene wanawuminya mwaano ni meetthuciho awe. ");
INSERT INTO mgh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wiila waya, yahorwaa utaa waya iparasa. ");
INSERT INTO mgh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Uvira waya, wicisu, yahoona mwiri wonhokorokho unoomile, ni mitithari caya cothene. ");
INSERT INTO mgh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ni Peturu oopuwelaka, ahomwiirela Yesu: Wooneke mwalimu, mwiri wonhokorokho ulaphilyaa, uhooma. ");
INSERT INTO mgh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu aheerela: Munkupali Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Khweeli kinawuhimeryani, ntthu eerelaka mwako ula: 'Wiiphele nipuro niryaa wivonyere upahari', ni ahaanyihereke munrimani mwawe nanso akupaliki wiira itthu ihimilyawe inaahala wiiranyaa; khweeli, inawiiranyaa. ");
INSERT INTO mgh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Phimaana, kinawuhimeryani wiira citthu cothene cinhalenyu ulepela nswaliki, nkupaliki wiira nnawaakhela, ni nnapattha. ");
INSERT INTO mgh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mwemelaka vale wiira nswali, mwakhalanaka mwamweetthu ni nkhwiinyu, munleveleke wiira Athumwaninyu, ari wirimu, yuuleveleleni cookosa cinyu. ");
INSERT INTO mgh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nlattu, mwahaleveleleke akhwinyu, Athumwaninyu ari wirimu khanhala ulevelela cookosa cinyu. ");
INSERT INTO mgh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yahoturuwela uYerusalemu, ni Yesu eettaka Mpani mwaNluku, oolupale a mayasataka, mayowantikha ni mahumu, yahomwaattamerya ");
INSERT INTO mgh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ni yahoonkoha: Umpanka citthu nnya ni nlamulo nawani? Ulamulenle tipani upanka citthu nnya? ");
INSERT INTO mgh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ahaakhula: Hata ni mi, kinawukohani itthu. Nkaakhule vano kinaahala wuhimeryani cineeraka woopanka citthu nnya ni nlamulo nawani. ");
INSERT INTO mgh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Upatisu wa Yohani waari wo wirimu, atthuna wa atthu? Nkaakhule. ");
INSERT INTO mgh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yahopacera ukohana ayayoru, yiiraka: Neeraka, wo wirimu, naahala wiira, 'Nhinkupalenleni mweeco?' ");
INSERT INTO mgh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Neeraka, wa atthu, ninawoova mphwinko. Nlattu othene yanamoona Yohani toko nnapiyu. ");
INSERT INTO mgh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Umwiisoni yahomwaakhula: Khanincuwela. Ni Yesu aheerela: Hata ni Mi akinohimeryani ni nlamulo nawani kimpankaka citthu nnya. ");
INSERT INTO mgh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu ahopacera woolumacera ni malikanihero: Ahaawo ntthu aanle imatta yo vinyu, ahopophela nkuco, ahothipa nlitti no waameliya ivinyu ni ahoteka ipwaro. Wahoolo ahaahiyera ananteko arwaka ikwaha awe yoottayi. ");
INSERT INTO mgh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ukati woohephiya, ahonruma nrumeyi awe wiira aakhele nuusu no cowiima co mmattani. ");
INSERT INTO mgh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ale nanso, yahommara, yahomwaatta nuunturusela uttuli wohiitthu. ");
INSERT INTO mgh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ni ahonruma nrumeyi nkina. Ni uyo tho yahompwesa muru ni yahontarawa venci. ");
INSERT INTO mgh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ahonruma nkina, ni ule yahomwiiva. Ahaaruma akina enci, na ale yahaatta ni akina weeva. ");
INSERT INTO mgh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nahalenle nlelo mwanawe oofentiya, umwisoni ahonruma ule, eeraka: Anaahala unlemeliha mwanaka. ");
INSERT INTO mgh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nanso, ananteko yaheerelana ayayoru: Ule phinkokhalana imatta ila! Nrwee, nimwiive, ni imatta inakhala yawihu. ");
INSERT INTO mgh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yahommara ni yahomwiiva, nuunrihela nceresere imatta. ");
INSERT INTO mgh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mwaneene imatta ile nohala upankani? Nahala uturuwa ni weeva ananteko ayo, ni wahoolo, naahala waavaha imatta ananteko akina. ");
INSERT INTO mgh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Khansomile cowantikhiya cittakattifu? Nluku nikhottiye ni mayoteka, nihothatuwa nluku no wanlothoni nowokolela inupa. ");
INSERT INTO mgh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Itthu ila inkhuma wa Apwiya, ni iri yoothamaliya wamiithoni wihu. ");
INSERT INTO mgh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yaanawavya ummara, nanso yanawoova mphwinko, nlattu yaheeweha ratta, wiira nlikanihero nne naaca yaayo. Yahonhiya ni yahorwaca. ");
INSERT INTO mgh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wahoolo yahonrumihela mafarisi ni maherotiyano akina wiira ammare mmoolumoni. ");
INSERT INTO mgh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Amwaattameryaka yahomwiirela: Mwalimu, nihocuwela wiira uri nlopwana eekhweeli, khaawo nonramelaa, nlattu khumweha makhalelo a ntthu, nanso unawiitthuciha iphiro ya Nluku, toko cinkhalaya yeekhweeli. Unihimerye, iri itthu yooloka atthuna yoohiloka unvaha nsoko Sesari? Ninvahe atthuna nihinvahe? ");
INSERT INTO mgh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu acuwelaka wototha waya, ahaakhula: Nnokittehacerani? Nkiwiihere nikopiri, koone. ");
INSERT INTO mgh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yahomwiihera ni ahaakoha: Yawani ila yocaphariya, ni yowantikhiya ila? Yahaakhula: Ya Sesari. ");
INSERT INTO mgh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu aheerela: Mumvahe Sesari itthu ya Sesari, ni Nluku itthu ya Nluku. Ni yahotikhinaca venci. ");
INSERT INTO mgh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wahoolo yahowa masatuseu, ale aneera khuwo wunwelela wa atthu ookhwa, yahomwaattamerya, ni yahonkoha Yesu: ");
INSERT INTO mgh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Mwalimu, Musa honantikhela wiira ntthu ankhwelaka munnawe, pwahiyaka amwaarawe woohikhalana asaana, nhimaawe nolamuliya unthela nthiyana oohinnya wiira ahiye ipyo ya munnawe. ");
INSERT INTO mgh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vano yahaawo asunna saapa, ni oopacera uyo ahonthela ni ahokhwa woohahiya asaana. ");
INSERT INTO mgh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oonayeeli ahonthela nthiyana ahinye, ni uyo ahokhwa woohahiya asaana, ni ooneeraru uyo waheerannyaa ciicammo, ");
INSERT INTO mgh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ni othene saapa yahokhwa woohahiya asaana. Wiimaleloni waya nthiyana uyo ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vanhala wunweleliya, nthiyana nohala ukhala amwaara awani, nlattu asilopwana saapa ale yahonthela nthiyana ule? ");
INSERT INTO mgh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ahaakhula: Nyu nnawithepyaca nlattu woohicuwela cowantikhiya cittakattifu hata ikuru ca Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Phimaana wanhalaya wunwelela mwaatthu ookhwa, khuwo utheliya, mena khuwo uthelana, nanso ammokhala toko ancelo o wirimu. ");
INSERT INTO mgh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nanso itthu inaciya mowunwelelani mwaatthu ookhwa, khansomile ikitapu ya Musa, itthu yeeranele ni nikukhu napharela woohivya, toko Nluku caamuulumacenryawe eeraka: Mi kiri Nluku a Aprahamu, Nluku a Isaaki, ni Nluku a Yakopu? ");
INSERT INTO mgh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Khankhala Nluku a atthu ookhwa, nanso Nluku a atthu akumi. Nyu khanreere weetta ni ututhi. ");
INSERT INTO mgh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ahomwaattamerya mayowantikha eewile avanyihanaka, ni oonaka wiira Yesu aakhunle ratta, ahonkoha: Phinni nlamulo noopacera o malamuloni othene? ");
INSERT INTO mgh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ahaakhula: Noopacera phi nna: Wiiwe Israel, Apwiya Nluku ihu pha Mwaneene Nluku veekhaya. ");
INSERT INTO mgh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wafente Mwaneene Nluku aa, ni nrima aa wothene, ni nnepa aa wothene, na ankhili aa othene, ni ikuru caa cothene. ");
INSERT INTO mgh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nonayeeli phi nna: Umfente nkhwaa toko we o mwaneene. Khaniwo nlamulo noopwaha ala. ");
INSERT INTO mgh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mayowantikha yahomwiirela: Ureera cinene, Mwalimu, khaawoothile eenryaa wiira Ule ri veekhawe ni khaawo tho nkina noompwaha Ule; ");
INSERT INTO mgh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","nuumfenta ni nrima wothene, ni ankhili othene, ni nnepa wothene ni ikuru cothene, nuumfenta nkhwaa toko mwaneene, iri itthu yootepa woovikana isataka coopahiya ni coovelelihiya cothene. ");
INSERT INTO mgh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu, oonaka wiira ntthu ule ahaakhula ni nruku, ahomwiirela: Khuri uttayi ni omwene wa Nluku. Ni khariwo tho unkoha itthu. ");
INSERT INTO mgh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eetthucihaka Mpani mwa Nluku, Yesu ahokoha: Mayowantikha ahimyaka cani wiira Mesiya phiri mwanawe Taviti? ");
INSERT INTO mgh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Taviti mwaneene, athoonyeriyaka ni Nnepa Nttakattifu, heera: Apwiya yaheerela Apwiya aka: Wonkome moono aka nlopwana, mpaka Mi keese eenani aa vathivaya manyaa aa. ");
INSERT INTO mgh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Taviti mwaneene namwiihana, Apwiya. Nokhalaka cani mwanawe? Ni mphwinko muulupale wanamwiiwa ni utteeliya nrima. ");
INSERT INTO mgh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wowiitthuciha, Yesu anawiira: Nkhale miitho, mwisunke ni mayowantikha unacivela uthoonyera coowara coorekama nuukohiya isalama mmapuwani; ");
INSERT INTO mgh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","wonkoma mapuro uhoolo nnsinakokani ni mapuro anliya isukuhuulu. ");
INSERT INTO mgh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anawalyacera anankwele yoothereryaka ni iswali coottaliva. Ala anowowaakhela ihukhumu yootepa. ");
INSERT INTO mgh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nonkomile nipuro naheliya coovelela yawehaka atthu yahela nsurukhu nkasani mwe. Mathaciri menci yanahela nsurukhu mwinci. ");
INSERT INTO mgh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ahowa nthiyana nankwele oothwenya, ahelaka makopiri meli ooyevaca, manaaya nikupatta nonecese. ");
INSERT INTO mgh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eehanaka owiitthuca awe, Yesu ahaahimerya: Khweeli kinawuhimeryani wiira nthiyana ula nankhwele oothwenya hohela woopwaha atthu othene ahenle nkasani yo nhakhu. ");
INSERT INTO mgh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nlattu, othene yahenle yohalahala muthacirini mwaya, nanso nthiyana oothwenya ahenle yothene yarinawe, ni khahalanne itthu hata yankani. ");
INSERT INTO mgh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wakhumaawe Mpani mwa Nluku owiitthuca mmoca ahonhimerya: Mwalimu, moone, maluku menci ale ni cootekiya nnya! ");
INSERT INTO mgh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ahaakhula: Unawoona cootekiya nnye cuulupale? Khaninkela naahalaka nluku nimoca waculu nluku nikhwaya, cothene cimmotankuliya. ");
INSERT INTO mgh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ni nonkomile mmwako wo Olivera uhoolo waya Inupa ya Nluku, Peturu, Yakopu, Yohani ni Anteree, yahonkoha ntthikini: ");
INSERT INTO mgh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Unihimerye wiira citthu nnye cinhala wiiranyaa yaakhani, ni ikanyero inhala uthonyera wiira citthu nnye ciri vakhiviru. ");
INSERT INTO mgh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ahopacera wahimerya: Mwisunke wiira hikhale ntthu noothepyani. ");
INSERT INTO mgh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kontha, anaahala uwa atthu enci mwancina naka yiiraka 'Phi mi!' mpaka wathepya atthu enci. ");
INSERT INTO mgh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mwiiwaka cuulumaciyaka cokhotto, ni myaha cokhotto, nhituthuwe. Citthu nnye cinalamuliya wiiranyaa nanso khunakhalaka mwiso. ");
INSERT INTO mgh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nloko nimoca ninhala uvaraana ni nloko nikhwaya, omwene mmoca ni omwene nkhwaya. Ilapo inaahala uthukumela mapuro makina, ni immovola itala. Citthu nnye ciri mapacerero woona coowerya. ");
INSERT INTO mgh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nkhale miitho! Anaahala wurwehani upwaroni, nnaahala wapsyuliya nnsinakokani. Nnaahala weemesiya wa miithoni wa mayansatoro ni mamwene nlattu wo Miyano, wiira mmahe usaahiti wamiithoni waya. ");
INSERT INTO mgh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nanso woopacera Nhupi Wooreera unaahala uhimeriya maloko othene. ");
INSERT INTO mgh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vano mwakusiyaka wiira moolumaciye makhuce, nhoove itthu inhalenyu uhimya. Nanso nhimye itthu inhalenyu uvahiya ukati yooyo, kahi mweeco nyuva nnohala wuulumaca, nanso Nnepa Nttakattifu. ");
INSERT INTO mgh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Munna naahala unrweha unokhwani munnawe, ni athumwane mwanawe; ni asaana ammowuulumacera makhuce athumwanaya, mpaka weeva. ");
INSERT INTO mgh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ni nnaahala wiinananinya nlattu wo ncina naka, nanso ntthu nohala ukhalana nthiti mpaka umwisoni, nowowoopwa. ");
INSERT INTO mgh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Moonaka citthu co miikho cikhumelelaka toko itankuleliyo wahimphwanelaya ukhala (nosoma uyo eeweehe), vano ale ari uYutteya atthawele mmwakoni. ");
INSERT INTO mgh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ari wancarani ahikhuruwe hata ahikele mpani wiira akuse citthu caya. ");
INSERT INTO mgh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ari mmattani ahituruwele uwaani wiira yakuse coowara caya. ");
INSERT INTO mgh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Atakhaliye pha ale ari ni irukulu, na ale anamwiha asaana mahuku ale! ");
INSERT INTO mgh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nswali wiira itthu ile ihiiranye ukati weyiita. ");
INSERT INTO mgh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nlattu mahuku ale coohosiya cinkokhala toko caharyaya ukhalakaru, ikhumelo wapattusilyawe Nluku ittuniya, mpaka nnava, hata khacinkela cakhalaka tho. ");
INSERT INTO mgh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ni yahari Apwiya akhuvehaka mahuku ale, hata ntthu khoopwa, nanso nlattu wa atthu oothanliya naahala ukhuveha. ");
INSERT INTO mgh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Akhalaka ntthu nohimeryani: 'Mesiya ri vava!' atthuna, 'Umoone wonwo!', nhikupali, ");
INSERT INTO mgh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","kontha anaahala wunwa amesiya oowootha ni anapiyu oowootha ni ankopanka ikanyero ni cootikhineeha wiira yaathepye, wanooranyaya, hata oothanliya. ");
INSERT INTO mgh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nanso nyu, mwisunke; kihohimeryani cothene marapuroru. ");
INSERT INTO mgh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nanso mahuku ale, anamanle mahuviho ale, ncuwa ninaahala uripela, ni mweeri khunhala waarya, ");
INSERT INTO mgh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","itthoottwa cinaahala umora wirimu, ni ikuru conculu cinaahala upukunyiya. ");
INSERT INTO mgh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Vano naahala wooniya, awaka mmahutteni Mwanawe Pinattamu ni ikuru cuulupale ni waarya. ");
INSERT INTO mgh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nahala waruma ancelo awe ni wathukumaniha atthu yathanlilyawe mittetthe co micese cophyoo, umalenlyaya ilapo nuumalenlyaya irimu. ");
INSERT INTO mgh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mwiitthuce, mweeco, nlikanihero no mwiri wonhokorokho. Miritta caya cakhalaka miheenya, ni capaceraka uphuwa, nhocuwela wiira iyiita iri vakhiviru. ");
INSERT INTO mgh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ciicammo nyu, moonaka ukumelela citthu nnya, ncuwele wiira Mwanawe Pinattamu ri vakhiviru, wankhora. ");
INSERT INTO mgh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Khweeli kinawuhimeryani: Khanimmira nloko nna cihiraneele citthu cothene nnya. ");
INSERT INTO mgh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Irimu ni ilapo cinaahala uvira, nanso moolumo aka khanhala uvira. ");
INSERT INTO mgh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nanso khaawo nocuwela nihuku nne, hata ukati ule, mena ancelo o wirimu, mena Mwana, nanso Athumwane paahi phincuwela. ");
INSERT INTO mgh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nkhale miitho, nrontte! Nlattu khannocuwela nihuku ninhalaya uphiya ukati ule. ");
INSERT INTO mgh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Uri toko ntthu alakenle ikhwaha awe, ahiyaka inupa awe, ahaahiyera iyuulupale arumeyi awe, khula ntthu ahovahiya nteko woovara, ni ahonlamulela mayokhaliha wiira arontte. ");
INSERT INTO mgh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vano nrontte, nlattu khannocuwela ukati unhalaawe uwa mwaneene itthoko; toko yocoocilo, atthuna uhiyu iriyari, atthuna uneepile nthupi, atthuna wicisu, ");
INSERT INTO mgh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","wahikhumelele wiira, nawile ni wututuserani, huphwanyeni nrupaka. ");
INSERT INTO mgh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Itthu inohimeryakani nyu, kinahimerya atthu othene: Nrontte! ");
INSERT INTO mgh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yahanle mahuku meeli uphiya isukuhuulu yo Pasikuwa ni nihuku ninliyaya mikatthe coohimiropo, oolupale a mayasataka ni mayowantikha yanawaavya mananna untthuka wo makhuce nuumwiiva. ");
INSERT INTO mgh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yanawiira: Itthu ila ihiiriye mahuku osukuhuulu wiira atthu ayo ahipanke ipokoho. ");
INSERT INTO mgh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu nari uPetaniya, nonkomile wameeca mpani mwawe Simoni omakunttula, ahowa nthiyana, acisile iphotiri yo nluku ya alapasturo inheliya makhura oonukhela yeehaninya narttu, anthumihiya ncurukhu mwinci, napwesile iphotiri, aheetthela makhura mmuru mwaYesu. ");
INSERT INTO mgh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nanso akina yahonyonyinya, yiirelanaka ayayooru: Ariheliyeni ciicammo makhura ala? ");
INSERT INTO mgh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yanawoorya uthumihiya ni ncurukhu iminya tharu, mpaka wakawela atthu oothwenya. Ni yahonkuphula nthiyana ule. ");
INSERT INTO mgh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu nanso aheera: Nhiyeke. Munkuphulelaka isiyani? Hokipankela itthu yooreera; ");
INSERT INTO mgh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kontha, atthu oothwenya phinakhalaneenyu, ni mwatthunaka nnawoorya waapankela cooreera, nanso miyano akinkhala ni nyu mahuku othene. ");
INSERT INTO mgh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ale ahopanka itthu yoonryaya. Ahoottiha ni makhura irutthu aka ahoolelihaka uvithiya waka kihinaaya ukhwa. ");
INSERT INTO mgh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Khweeli kinawuhimeryani, wiira mwiilaponi mothene unhalaya ulalyaa Nhupi Wooreera, inaahala tho uhimiya itthu yapankilyawe wiira upuweleliye. ");
INSERT INTO mgh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Vano, Yutta Iskariyoti, mmoca mwaale khumi na eeli, akenle woolupale a mayasataka wiira amulume makhuce Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Weewilyaya moolumo ale, cahaatteela mirima ni yahovanela ummaha nsurukhu. Yutta anawavya ukati wontumiha Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nihuku noopacera no mikatthe coohimiropo, ukati waveleelihiya mwakhontwa o Pasikuwa, owiitthuca yahonkoha Yesu: Nnotthuna ulokiheriya vayi nipuro noonlya Pasikuwa? ");
INSERT INTO mgh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ahaaruma owiitthuca eeli ni aheerela: Murwee uparasa. Nnaahala umphwanya ntthu oocisa mwaapu wo maasi. Muntthare, ");
INSERT INTO mgh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ni unkelaawe, munhimerye mwaneene inupa: Mwalimu nakoha: Inupa inhalaka umaka iri vayi, kinlyaka Pasikuwa ni owiitthuca aka? ");
INSERT INTO mgh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ni naahala wuthonyerani nsana nuulupale uculu nooreerihiya ni nowaaya; mwanilokihere nenno. ");
INSERT INTO mgh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Akhumaka owiitthuca awe, yahorwaa uparasa, ni yahophwanya toko cahimeriyaya; ni yahontthonkomaniha Pasikuwa. ");
INSERT INTO mgh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wiila waya, Yesu ahophiya na owiitthuca awe khumi na eeli. ");
INSERT INTO mgh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Anonkomacile alyaka, Yesu aheera: Khweeli kinawuhimeryani, mmoca mwa nyu, nolya ni mi, naahala ukuuluma makhuce. ");
INSERT INTO mgh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yahanca ucukulaca, yiirelanaka ayayoru: Kahi thi mi? ");
INSERT INTO mgh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ahaakhula: Phi mmoca mwa nyu khumi na eeli, nokilyana nttiisi nimoca. ");
INSERT INTO mgh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nlattu, Mwanawe Pinattamu narwa, toko cantikhelyawe, nanso natakhaliya ntthu nohala unthumiha! Phatari ahiyariye. ");
INSERT INTO mgh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Walyaya, Yesu ahokusa nkatthe ni nareerihile, ahomyaniha ni ahaavaha owiitthuca awe, eeraka: Nkuseke, nlyeke, ila phi irutthu aka. ");
INSERT INTO mgh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wahoolo ahokusa ikikhompe, ahosukuru ni ahaavaha ni othene yahowurya. ");
INSERT INTO mgh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ni ahaahimerya: Ila phi iphome aka, iphome yo waatana wonaanano, invuviheriya atthu enci. ");
INSERT INTO mgh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Khweeli kinawuhimeryani wiira akinhala tho uwurya yowiima ila yo viteera mpaka nihuku ninhalaka uwurya tho wumweneni wa Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aneepile ncipo, yahokhumaca arwaka umwako wo Olivera. ");
INSERT INTO mgh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ahaahimerya: Nyu othene, uhiyu ula, nnaahala uhiya ikupalelo nlattu wo miyano, kontha ihantikhiya: Kinanrakaliha nhakheli ni ikhontwaa cinkomwaryaca. ");
INSERT INTO mgh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nanso kinonwelenle, kimmowuhoolelani wokela uKalileya. ");
INSERT INTO mgh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peturu aheera: Hata othene ahiye ikupalelo aya, nanso mi, mena. ");
INSERT INTO mgh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ahomwaakhula: Khweeli kinawuhimeryani, ilelo uhiyu ula, nthupi uhinaya wiipa imaara piili, unakikhotta imaara tharu. ");
INSERT INTO mgh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nanso Peturu ahopwahera wakhula ni ikuru eeraka: Hata kilamuliye ukhwa ni nyu, akinookhottani. Ni othene yahoolumaca ciicale. ");
INSERT INTO mgh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yahorwaa nipuro neehaninya Yetsemani, ni Yesu ahaahimerya owiitthuca awe: Munkome vava mi kiswaliki. ");
INSERT INTO mgh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ahonkusa Peturu, Yakopu, ni Yohani, ni ahanca woova ni ucukula. ");
INSERT INTO mgh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ahaahimerya: Nnepa aka unacukula, icuku yo nokhwa. Nkhale vava ni nrontte. ");
INSERT INTO mgh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Apwahaka vakani, ahowuluwela vathi ni ahoswali wiira wooryanyaa, ukati ula ukipwahe. ");
INSERT INTO mgh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni ahohimya: Apa, Tiithi; Nyu nnawoorya cothene. Nkitamihe mmahuvihoni! Nanso, cihipankiye cintthunaka, nanso cintthuneenyu. ");
INSERT INTO mgh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Uturuwa wawe, aphwanyile arupaka, ni ahomwiirela Peturu: Simoni unarupa? Khawoonrye wiliphila iwora imoca? ");
INSERT INTO mgh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mwiliphile ni nswaliki wiira nhithokociye. Nrima unatthuna ratta, nanso irutthu khinlipa. ");
INSERT INTO mgh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ahorwaa tho uswalini, akulelaka moolumo yaayo. ");
INSERT INTO mgh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ahoturuwa, ni ahaaphwanya arupaka kontha miitho aya yahocara ikhove. Ni khayoona yomwakhula. ");
INSERT INTO mgh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ahowa imaara yoneeraru mpaka waahimerya: Mpaka nna nnaarupa ni nnamumula tho? Wahotosa! Ukati uhophiya. Mwanawe Pinattamu naahala urwehiya mmatatani mwaatthu ookosakosa. ");
INSERT INTO mgh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Muunwe, Nrwee! Kitumihile uyo hophiya. ");
INSERT INTO mgh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu oolumacaka nanlelo phaphilyawe Yutta, ari mmoca mwaale khumi na eeli, ni mphwinko muulupale wakhumile woolupale a mayasataka, mayowantikha ni mahumu ni warina ikatana ni ikopo. ");
INSERT INTO mgh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Namakhuce ahaahimerya ikanyero eeraka: Nohalaaka unkoha isalaama, phi yooyo, mumvare ni munkuse natthukiye ratta. ");
INSERT INTO mgh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Uphiya wawe, ahomwaattamerya ni ahomwiirela: Mwalimu! Ni ahonkoha isalaama. ");
INSERT INTO mgh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yahommara Yesu, ni yahontthuka. ");
INSERT INTO mgh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Vano, mmoca mwaale eemenle wonwo, ahokumiha ikatana ahorakaliha ipottha ya nkhulupale a mayasataka, ahonthikila nnyaru. ");
INSERT INTO mgh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu ahaahimerya: Nkhumile ni ikatana ni ikopo uwa ukitthuka, toko mayohukha. ");
INSERT INTO mgh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaari ni nyu mahuku othene mpani mwa Nluku, kiitthucihaka ni khamwakitthukile. Nanso wiira citthariheleliye toko caantikhiyaya. ");
INSERT INTO mgh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vano, anhiyaka, othene yahotthawa. ");
INSERT INTO mgh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ni ahontthara mmirawo mmoca eekhunenle ikuwo. Yahommara, ");
INSERT INTO mgh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nanso ahiyaka ikuwo ile, ahotthawa pwitipwiti. ");
INSERT INTO mgh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yahonrweha Yesu wankhulupale a mayastaka wathukumannyaya othene oolupale a mayasataka, mayowantikha ni mahumu. ");
INSERT INTO mgh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peturu ahontthara uttayittayi mpaka nhina ipuwa ya nkhulupale a mayasataka. Peturu wonkomilyawe wamoca ni ananteko ootthaka mooro. ");
INSERT INTO mgh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vano, oolupale a mayasataka ni mayothukumana othene yaavya osaahiti, wowiira amwiive Yesu, nanso khayaaphwanyile. ");
INSERT INTO mgh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Enci yaanahimya cowootha, nanso cahimilyaya khaweerana. ");
INSERT INTO mgh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ahaawo yeemenle ni uromola yowootha ila yiiraka: ");
INSERT INTO mgh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Hi nihomwiiwa ahimyaka: Kinhala ukwanyula inupa ila, itekiye ni matata a atthu, ni mahuku mararu kinaahala uteka ikina yoohitekiya ni matata a atthu. ");
INSERT INTO mgh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nanso, hata ciicammo usaahiti aya khaweeranne. ");
INSERT INTO mgh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Vano, muulupale o mayasataka aheemela iriyari aya atthu yathukumanne ni ahonkoha Yesu: Khunakhula itthu nhina osaahiti ommahaya atthu ala? ");
INSERT INTO mgh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu nanso ahomaala ni khaakhunle itthu. Muulupale a mayasataka ahonkoha tho: We uri Kristu, Mwana a Nluku Ooreerihiya? ");
INSERT INTO mgh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ahaakhula: Kiri mi, ni nnaahala umoona Mwanawe Pinattamu nonkomile moono nlopwana wa Nluku Okuru, ni awaka mmahutteni o wirimu. ");
INSERT INTO mgh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Vano, muulupale a mayasataka ahaahula coowara cawe ni aheera: Nimphavela tho vayi osaahiti? ");
INSERT INTO mgh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwanamwiiwa ukufuru nwo. Nneera cani? Na atthu othene yahonhukhumu ukhwa. ");
INSERT INTO mgh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wahoolo, akina yaanapacera unsuwela, yahonkhunela wiitho ni ikuwo nuumwaatta yiiraka: Uhimyace nnapiyu! Ni mayorontta yahonkusa nuumwaattakaca. ");
INSERT INTO mgh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peturu neemenle vate wapuwani, ahophiya nanteko mwanthiyana a muulupale a mayasataka, ");
INSERT INTO mgh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ni umoona wawe Peturu ootthaka mooro, ahomwehecesa ni ahomwiirela: We khweeli wari ni Yesu o Nasaree. ");
INSERT INTO mgh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ule nanso ahoruna, eeraka: Akinoncuwela, hata akineeweha inhimyaa iyo. Wahoolo ahokhumela vate iluwani, ni nthupi waheepa. ");
INSERT INTO mgh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nanteko mwanthiyana, umoona wawe tho, ahaahimerya atthu yaatamananyawe: Ula phi mmocaru. ");
INSERT INTO mgh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nanso ahoruna imaara yonapiili. Ukati vakani tho, ale yaari mmo, yahonhimerya Peturu: Khweeli we phi mmocaru, kontha uri nkalileya. ");
INSERT INTO mgh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nanso aholapha ni aholupela eeraka: Akinoncuwela ntthu nnomwaacenyu. ");
INSERT INTO mgh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ni nenna nna nthupi waheepa imaara yonapiili. Vano, Peturu ahoopuwela itthu yahimilyawe Yesu: Nthupi uhinaya wiipa imaara piili, we unaahala ukiruna imaara tharu. Ni vava ahopacera wunla. ");
INSERT INTO mgh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Usakaru, yahothukumana oolupale a mayasataka wamoca ni mahumu ni mayowantikha, ni mayonthukumano othene; ni untthuka waya Yesu, yahonkusa ni yahommelela waPilatu. ");
INSERT INTO mgh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu ahonkoha: We uri Mwene a Ayutta? Yesu ahomwaakhula: We uhohimya. ");
INSERT INTO mgh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ni oolupale a mayasataka yahonriyelela citthu cinci. ");
INSERT INTO mgh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu ahonkoha tho eeraka: Khunakhula itthu? Woone, citthu cinci cinriyeleliyaa na atthu ala. ");
INSERT INTO mgh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu nanso khaakhunle tho itthu, ni Pilatu ahotikhina. ");
INSERT INTO mgh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nihuku nosukuhuulu, Pilatu aholemalela untthukula nantthukiya mmoca yantthunaya atthu. ");
INSERT INTO mgh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ahaawo nlopwana mmoca, eehaninya Parapasi, atthukiye wamoca na anaporonka nlattu yamwiivile ntthu ukati wonkhitto. ");
INSERT INTO mgh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mphwinko wa atthu, wahonwa ni wahopacera ulepela itthu yalemalenlyawe wapankela. ");
INSERT INTO mgh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu ahaakhula: Nnotthuna wiira kutthukuleleni Mwene a Ayutta? ");
INSERT INTO mgh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nlattu ahocuwela wiira oolupale a mayasataka yamwiihenre nlattu woonrama. ");
INSERT INTO mgh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nanso oolupale a mayasataka yanatheperya mphwinko wiira phatari Pilatu antthukule Parapasi. ");
INSERT INTO mgh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu ahaakoha: Kinhala umwiiriha isiyani ula nnomwiihanenyu Mwene a Ayutta? ");
INSERT INTO mgh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na ale yankhuwaca tho: Unkhomele wansalapani! ");
INSERT INTO mgh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Vano Pilatu aheera: Tthekileni? Nanso ale yanakhuwaca: Unkhomele wansalapani! ");
INSERT INTO mgh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu, atthunaka wamaaliha atthu ale, ahaataphulela Parapasi. Ni aholamula wiira Yesu apsuliye ni akhomeliye wansalapani. ");
INSERT INTO mgh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anakhotto yahonkusa upwaroni ya nsatoro, ni yaheehaninya anakhotto othene. ");
INSERT INTO mgh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yahomwariha ihancu yookhwiila, ni yahomweesa ikhilempa yo miiwa wamuru wawe. ");
INSERT INTO mgh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wahoolo yahopacera unkoha nretele yiiraka: Salaama, Mwene a Ayutta! ");
INSERT INTO mgh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yanamwaatta wamuru ni nthale ni yanansuwela ni ankhoromelaka yananlapela. ");
INSERT INTO mgh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wamanlyaya untarawaca yahonrula ihancu yokhwiila ni umwariha tho cawawe. Vano yahonkusa wiira akhomeliye wansalapani. ");
INSERT INTO mgh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yahommara athumwane Alisantere ni Rufu, eehaninya Simoni o Sirene aakhuma umawaani ni ahokanyererihiya ukusa nsalapa. ");
INSERT INTO mgh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yahonrweha nipuro neehaninya Kolokootha, manaaya, nipuro nokohi. ");
INSERT INTO mgh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yahommaha ivinyu yootakaniheriya ni miira, nanso ahokhotta uwurya. ");
INSERT INTO mgh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wahoolo yahonkhomela wansalapani. Ni akawelanaka cowara cawe, yahopanka mwaavi wiira yoone yahalaawe uphwanya khula ntthu. ");
INSERT INTO mgh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yaari iwora yoneeraru wakhomeliyawe wansalapani. ");
INSERT INTO mgh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Waculu wawe yahantikhiya yariyeleliyawe: MWENE A AYUTTA. ");
INSERT INTO mgh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yahokhomeliya wamoca ni Ule, mayohukha eeli, mmoca, moono nlopwana, nkina moono nthiyana. ");
INSERT INTO mgh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ciicammo cootthariheleliya cowantikhiya cineera: Ahaalikeliya na atthu oonanara nrima. ");
INSERT INTO mgh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Atthu yaavira ayo, yananruwana, apukunyaka muru, yiiraka: We! Watankulaca Inupa ya Nluku ni uteka tho mahuku mararu. ");
INSERT INTO mgh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","We wicoopole o mwaneene nuukhuruwe wansalapani! ");
INSERT INTO mgh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Oolupale a mayasataka ni mayowantikha yanateehana, yiiraka: Hoopola akina ni khanoorya wicoopola mwaneene. ");
INSERT INTO mgh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Akhuruwe naanano wansalapani uyo Kristu, Mwene o Israel, wiira nimoone ni ninkupali. Na atthu ale yakhomeliye ni Ule, yananruwana. ");
INSERT INTO mgh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Waphilyaya ukati woothana ipiphi yahokhunela ilapo yothene mpaka yocoocilo. ");
INSERT INTO mgh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uphiya waya yocoocilo Yesu ahokhuwa ni ncu noorunya: Eloi, Eloi, lama sapaktani! Manaaya: Nluku aka! Nluku aka! Ukihiyenreni veekhaka? ");
INSERT INTO mgh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Umwiiwa waya, akina yaari wonwo, yaheera: Moone, nomwiihana Eliya! ");
INSERT INTO mgh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mmoca mwaale ahothimakaca uwiha ntthoce nooheliya makari ahotthukelela muntathini ni ahommaha wiira awurye, ni ahohimya: Noone wiira Eliya nawa unkurusela vathi. ");
INSERT INTO mgh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Akhuwaka ni ncu noorunya, Yesu ahokhwa. ");
INSERT INTO mgh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Vano ikuwo yo Mpani mwaNluku yahaahuwa iriyariru ukhuma uculu mpaka vathi. ");
INSERT INTO mgh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Muulupale a anakhotto eemenle cooco wariyawe Yesu, umoona wawe akhwaka ciicale, aheera: Khweeli ula ari Mwana a Nluku! ");
INSERT INTO mgh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yahaawo tho athiyana yemenle uttayi amwehaka; mwaale ahaawo Mariya Mantalena, Mariya anumwane Yakopu mwankani ni Yosefi, ni Saloome. ");
INSERT INTO mgh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wariyawe Yesu uKalileya yaayo yahontthara nunvarela nteko, ni athiyana akina enci yanvelenle wakenlyawe uYerusalemu. ");
INSERT INTO mgh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wiila waya, hapo wari ukati wowiitthenkaciya nihuku nontivela, ");
INSERT INTO mgh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ahowa Yosefi o Arimateya, humu oocuwanyaa ni oottitthima, akhuluvenle uwa waya omwene wa Nluku, alipile nrima wokela waPilatu ni aholepela nrutthu wa Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ni Pilatu ahaakaaka wiiwa wawe wiira hokhwa, ni amwiihanaka muulupale anakhotto ni ahonkoha akhala wiira khwile mwakhalayi. ");
INSERT INTO mgh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ni nahimeriye ni muulupale uyo, nrutthu ahovahiya Yosefi. ");
INSERT INTO mgh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefi nathumile ikuwo, ahokurusa nrutthu wansalapani, ni ahokhuneela ni ikuwo eyo. Wahoolo ahommitha mmahiye yathipiye wamwalani ni ahopirikisela nluku nuulupale wankhora wo mahiye. ");
INSERT INTO mgh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Mantalena, ni Mariya anumwane Yosefi yahoona nipuro navithiyawe. ");
INSERT INTO mgh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Uvira waya nihuku no ntivela, Mariya Mantalena, Mariya anumwane Yakopu ni Saloome yahothuma makhura oonukhela ni yahorwaa uttikitthela nrutthu wa Yesu. ");
INSERT INTO mgh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wicisu ncuwa nikhumaka nihuku noopacera nosumana, yahorwaca umahiye. ");
INSERT INTO mgh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yanawaakaaka yiiraka: Tipani nokela unipirikisela nluku nno wankhora wo mahiye? ");
INSERT INTO mgh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nanso, awehaka, yahoona wiira nluku nopirikiseliya nceresere ni nari nluku nuulupale cinene. ");
INSERT INTO mgh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ukela waya mmahiye yahomoona mmirawo nonkomile moono nlopwana, awanre ihancu yooteela, ni yahotuthuwa. ");
INSERT INTO mgh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Uyo nanso, ahaahimerya: Nhituthuwe. Nnomwavya Yesu o Nasaree akhomeliye wansalapani. Honwelela, khaawo va. Moone nipuro namweesilyaya. ");
INSERT INTO mgh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vano, murwee, mwahimerye owiitthuca awe ni Peturu wiira Yesu naahala wuhoolelani uKalileya. Wonwo nnaahala umoona toko coohimenryaweni. ");
INSERT INTO mgh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Akhumaka umahiye yanatthawa ni uthukumela nlattu wo woova. Khayanhimenrye ntthu itthu ile nlattu wo woova. ");
INSERT INTO mgh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nonwelenle, wicisu aya nihuku noopacera isumana, Yesu ahonkhumelela woopacera Mariya Mantalena, yola ankumihilyawe macini saapa. ");
INSERT INTO mgh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Uyo ahorwaa wacuweliha ale yakhanle ni Yesu, yeetta acukulaka ni yiikhupanyaka. ");
INSERT INTO mgh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ale nanso, wiiwa waya wiira Yesu ri nkumi, ni Mariya ahomoona, khayaakupanli. ");
INSERT INTO mgh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wahoolo aheeconeha nnanna nkina wasilopwana eeli yeetta ni iphiro, arwaaka umawaani. ");
INSERT INTO mgh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ayo yahoturuwa wiira yacuwelihe akhwaya, nanso na ayo khayaakupanli. ");
INSERT INTO mgh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wahoolo waya, ahaakhumelela owiitthuca awe khumi na mmoca alyaka, ni ahaakuphula nlattu wohikupali ni uturumala waya nrima, kontha khayaakupanli ale yamoonne nonwelenle. ");
INSERT INTO mgh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ni aheerela: Murwee ilapo yothene mwaalake atthu othene ni Nhupi Wooreera. ");
INSERT INTO mgh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ntthu nohala ukupali ni upatisiya naahala woopwa, nanso ntthu hinhala ukupali, naahala uhukhumwiya. ");
INSERT INTO mgh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ikanyero cinhala waatthara atthu ookupali phi nnya: Mwancina naka, ankowomola minepa coonanara, ankowuuluma moolumo oonaanano; ");
INSERT INTO mgh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ankovara inwaa, ni yawuryaka itthu yowiiva, khinhala wapanka itthu; ammowathatela matata aretta, na ale anaahala uvona. ");
INSERT INTO mgh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Vano, Apwiya Yesu anoolumanne owiitthuca awe yahakheleliya wirimu, ni ahonkoma moono nlopwana wa Nluku. ");
INSERT INTO mgh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vano arumeyi yahokhuma ni yahorwaa ulaka mapuro othene ni Apwiya yahaakavihera, yoneehaka nuulumo na Apwiya ni ikanyero cavelenle. ");
INSERT INTO mgh_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Mi Yakopu, ipottha ya Nluku ni ya Apwiya Yesu Krisitu, kinasalameeha mahimo khumi na meeli, amwareenle mwilaponi mothene. ");
INSERT INTO mgh_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Asunnaka, nkhalane utteeliya cinene wophwanyakani ukati woottehattehiya, ");
INSERT INTO mgh_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ncuwelaka wiira nroromelo ninyu nno nalawihiyaka phinkhalanaya nlipihero. ");
INSERT INTO mgh_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Nlipihero nihaana nivaraka nteko woomalela wiira nyuva nkhale oomalela, weeyiintthu ni wohihaleela itthu. ");
INSERT INTO mgh_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Wakhala wiira haawo hirina ankhili, anlepele Nluku, navaha atthu othene woohimatthepwa ni nawaakawa. ");
INSERT INTO mgh_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Nanso alepele nuuroromela woohaakanyaca; kontha ule nakanyaca ri toko mawimpi ompharyaa, ankusiya ni wuutuwanyinya ni iphyoo. ");
INSERT INTO mgh_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Uyo huupuwele wiira nawaakhela itthu ya Apwiya, ");
INSERT INTO mgh_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","maana ri ntthu oohilakela ni oohilipelela iphiro cothene cineettawe. ");
INSERT INTO mgh_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Munnihu oothwennya atteeliye nlattu wowuunuwihiya, ");
INSERT INTO mgh_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","ni oopuha atteeliye nlattu wowiiyeviha, kontha nacuwela wiira mahuku awe ari vakani toko ithutu contakhwani. ");
INSERT INTO mgh_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Ncuwa noopaka ni nivihaka, yowaaliya inawuuma, ni ithutu aya inanyaala ni ureera waya unaamala. Ciicammo, mayoopuha naakhala oonyaala mphironi mwawe. ");
INSERT INTO mgh_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Horeeriya ntthu noovilela waphiyaka ukati woottehattehiya; kontha, alawihiyaka, nowa uvahiya ikhwerempa yookumi, yeeyo Apwiya yaroromelihilyaya ale anafenta. ");
INSERT INTO mgh_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Hikhale neera, attehattehiyaka eeraka: Nluku phinkitteha. Kontha khanlamuliya uttehattehiya ni itthu yoonanara ni uyo khaawo nonttehawe. ");
INSERT INTO mgh_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Uhiya commo, khula ntthu nottehattehiya ni wunlela wawe citthu, vano wunlela wawe nwo wantepelaka unamooryaca. ");
INSERT INTO mgh_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Vano wunlela nwo wanttokotthelaka untothola itaampi; ni itaampi iyo inontothola nookhwa. ");
INSERT INTO mgh_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Asunnaka oofentiya, nhithepiye. ");
INSERT INTO mgh_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Khula ivahiya yooreera ni khula itthuvo yoomalela inkhuma wirimu, cikhuruwaka wa athumwanaya waarya, ahinrukunuwa toko mitthuuci cihirina nipuro noweemela. ");
INSERT INTO mgh_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Ni wootthuna wawe, ule honipattusa ni nuulumo neekhweeli, wiira nikhale nlipu nokhiyumpe cawe. ");
INSERT INTO mgh_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Asunnaka oofentiya, nkiiwe: Nyu ncuweleke nnya citthu nnya: ntthu phi ntthu nolamuliya ukhala owaakuva wiiwa, oohipuphela wuulumaca, ni oopica uviruwa; ");
INSERT INTO mgh_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","kontha uviruwa wa ntthu khunphwanyiha isariya ya Nluku. ");
INSERT INTO mgh_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Phimaana, nhiye unyala winyu nwo ni coonanara cimpankenyu nnyo, nkuse ni imaani nuulumo niphatteeliyenyu nno, nenno nihaana ikuru cowoopola iroho cinyu. ");
INSERT INTO mgh_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Vano, nkhale oweettela nuulumo, nhimakele wiiwa paahi, mwithepyaka veekhenyu. ");
INSERT INTO mgh_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Kontha, ntthu eewaka nuulumo nno ni heettelaka, nolikana toko ntthu neewehera waloolani, oonaka ikhove awe yeephattuwelo. ");
INSERT INTO mgh_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Wahoolo neewehenrene naathama, ni wowaakuvyaca naaliyala weenryaya ikhove awe iyo. ");
INSERT INTO mgh_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Nanso ule nohelelela aviriyanaka nlamulo noomalela, nlamulo nowoopola, akhanyereraka weettela, wohiira wiiwa nuuhiya, nanso woorya uvarela nteko, ula ntthu ula nokhala ooreerihiya mpaka ni nteko umpankawe uyo. ");
INSERT INTO mgh_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ntthu eehelaka ukhala nattiini, ahiyaka ulokiha nlimi nawe, nanso phiithepyaka, ittiini awe iyo iri yo mahala. ");
INSERT INTO mgh_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Ittiini yomaana ni yeekhweeli inoncivela Nluku Athumwanihu, phi ila: Waathotola akhwaacuni ni minankhwele ukati unhuvaaya ni wiisunka omwaneene woohinyala toko cineettiyaya ntuniyani. ");
INSERT INTO mgh_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Asunnaka, nakupaliki Apwiya ehu Yesu Kirisitu aneene uttitthima, nihaahiyaniheke atthu ayo. ");
INSERT INTO mgh_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Phimaana, awaaka ntthu mapuro anthukumanenyu, oonwara nnela owooru mmakokhoni mmo, nawaracile ikuwo comaana, wahoolo phikelaka tho ntthu nkina oohuva ni oothaaleliya, ");
INSERT INTO mgh_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","vano phaahawulanihaka wowaakhelela vaa, ni phimwiirelaka oowaraca ikuwo comaana uyo: Nyu vaa, mmweke mowunkomeke va nipuro noolemela nuuphwanenleeni. Vano oohuva uyo phimwiirelaka: We, weemeleke vaa, atthuna uweke wawonkomeke waryaka va. ");
INSERT INTO mgh_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Mwapankaka ciicammo nheehawulaniha ayaayoru ni nheepanka mayahukhumu owuupuwela coonanara. ");
INSERT INTO mgh_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Nkiiwe, asunnaka oofentiya: Nluku haathanla atthu owooninya uhuva mwilaponi wiira akhale athaaciri muukupalini ni akhale mayoophwanya umwene wo wirimu waalupelenlyawe ale anonfenta. ");
INSERT INTO mgh_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Nanso, nyu akina vaa, nnawannyohola mayoohuva. Khaanakhala athaaciri phinootulumuni? Khaanakhala yaayo phinoorwanani upwaroni onoolumiya milattu? ");
INSERT INTO mgh_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Khaanakhala yaayo phinnyohola ncina nomaana ninromoleliyeenyu? ");
INSERT INTO mgh_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Nyu mweettela malamulo o omwene wa Nluku, mwanapanka toko cinhimyaya cowantikhiya: Unfente nkhwaa toko cineefentaa umwaneene, unapanka yooreera. ");
INSERT INTO mgh_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Nanso, mwaahiyanihaka atthu nnopanka itaampi, ni nnaahala uhukhumwinya ni malamulo toko mayootthekaca. ");
INSERT INTO mgh_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ule noorya weettela malamulo othene, nanso phivonyanihaka nipuro nimoca, nalikeleliya ukosera othene. ");
INSERT INTO mgh_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Phimaana, ule eenre: Nheette uluva, ciicammo holamula eeraka: Nhiive. Vano, waheetteke uluva, nanso unawiiva, unkhala ntthu oovonyiha nlamulo. ");
INSERT INTO mgh_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Toko cineerenyu ni cinoolumacenyu, mpankeke ciicammo ncuwelaka wiira nnohala uhukhumwinya ni nlamulo nowiithawala. ");
INSERT INTO mgh_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Kontha ule hirina ikiriri naahala uhukhumwinya wohi ikiriri. Ikiriri cinatthema ihukhumu. ");
INSERT INTO mgh_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Asunnaka, nohala uphurani ntthu neera: Mi kihaana nroromelo nanso woohivarela nteko? Unoona wiira nenno nroromelo nno khaninoopola. ");
INSERT INTO mgh_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Akhala wiira mwamunninyu atthuna mwanrokorinyu hothaaleliya atthuna hovoliya itala yo khula nihuku, ");
INSERT INTO mgh_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ni mmoca wa nyu phimwiirelaka: Urweke ni mpuha, wawareke ni walyeke womaana, wohinvaha imphavelawe; mpankileni yooreera? ");
INSERT INTO mgh_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Ciicammo, nroromeloru paahi, noohivareliya nteko, ninkhala nookhwa. ");
INSERT INTO mgh_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Vano haawo nohala wiira: We uhaana nroromelo, ni mi kihaana miteko. Ukithoonyere nroromelo naa noohimiteko ni mi kinawuthonyera nroromelo naka ni miteko caka. ");
INSERT INTO mgh_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","We unakupali wiira ri Nluku mmoca paahi. Wahoreera! Ciicammo asotwani anakupali ni anattettemela! ");
INSERT INTO mgh_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","We, oomphuku! Khuncuwela wiira nroromelo noohivareliya nteko khanirina icaayira? ");
INSERT INTO mgh_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Aparahamu athumwanihu ookhalayii, khayaavahiye isariya nlattu wo miteko waanvaherenraaya mwanaya Isaki wanipuroni noosataka. ");
INSERT INTO mgh_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Vano wooneke wiira nroromelo ni miteko cineetta wamoca, ni nroromelo nimaliheriya ni miteko. ");
INSERT INTO mgh_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Coo phitthariheleliyaya yowantikhiya yiiraka: Aparahamu honkupali Nluku ni hoheeliya ukhala nasariya, ni uyo heehaninya mpwanawe Nluku. ");
INSERT INTO mgh_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Mooneke wiira ntthu novahiya isariya nlattu wo miteko, woohikhala nroromeloru. ");
INSERT INTO mgh_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Wanlikana toko puuta Rahapi; waavahiyawe isariya nlattu wopanka yooreera, aavahaka nipuro atthu oohottela ni wathonyera iphiro ikina. ");
INSERT INTO mgh_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Ciicammo irutthu yohiroho inkhala yookhwa, philikanaya nroromelo nohikhalana coopankiya ninkhala nookhwa. ");
INSERT INTO mgh_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Asunnaka, nhunlele ukhala othene mayoosomiha, maana nhocuwela wiira hii, nineetthuciha, phi hii ninkela utepa uhukhumwiya. ");
INSERT INTO mgh_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Othene ninakosa wo mananna oovirikana. Ntthu aahikoseke nlattu wo wuulumaca, uyo ri nttuntthu, ciicammo nawoorya usunka irutthu awe yothene. ");
INSERT INTO mgh_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Nahelelaka iyuma malaku okhavalu wiira ciniiwelele, ciicammo ninawoorya weettiha irutthu aya yothene. ");
INSERT INTO mgh_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Nthonyero enyu ukhale wokalawa; cinookhalaru cuulupale ni cittinkihiyaka ni iphyoo cuulupale, cineettihiya ni ileemi yankani cinene, toko cintthunawe nocika. ");
INSERT INTO mgh_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Ni ciicammo phinlikanaya, nlimi waryaya itthu yankani iri mwiirutthuni, ninawiittottopa nlattu woopanka citthu cuulupale. Nkoonani, itakhwa yuulupale impariheliyaya ni mooro mwankani. ");
INSERT INTO mgh_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Phi ciicammo, nlimi nihu niri mooro; nlimi niri ituniya yotaampi. Ninaheliyeene iriyari yorutthu ihu ninaannanariha irutthu yothene, ninaparihela makhalelo ookumi, ni mpaka ni nno ninapariheliya omooroni. ");
INSERT INTO mgh_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Phimaana ikhapila cothene conama, coovava, cowiipurula ni compharyaa cinasinnttiya ni cinsinnttiya na atthu, ");
INSERT INTO mgh_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","nanso nlimi khaawo ntthu noorya usinntta. Niri noonanara woohimala ni noocara nrette wo wiiva. ");
INSERT INTO mgh_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Ni nenno, ninanttitthimiha Pwiya Athumwanihu; ciicammo ninawaalapha atthu, apattusiye oolattana ni Nluku. ");
INSERT INTO mgh_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Malaku mamoca yaayo paahi, inakhuma iparakha ni ikilapho. Asunnaka, khavanreera wiira citthu nnya cikhaleke coo. ");
INSERT INTO mgh_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Uhopaca woona waluusi akhumaka maasi oociva na ayo ootumpurya nipuro nimoca nenno? ");
INSERT INTO mgh_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Asunnaka, nrale uhopaca wiima maphepu atthuna mphepu wiima nrale? Hata vakani, khawanoorya iluusi yo maasi ootumpurya ukhuma maasi oociva. ");
INSERT INTO mgh_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Tipani iriyari inyu ri aankhili ni oocuwelaca? Aathonyihere makhalelo omaana nuupisa nrima wa ankhili. ");
INSERT INTO mgh_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Waahikhaleke commo, munrimani mwinyu mmo nhaana urama wootepa ni wiihelela, vano nhiittottope ni nhoothe nveehaka ikhweeli. ");
INSERT INTO mgh_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Ala ankhili ala, khaankhuma wirimu, nanso ari omwiilaponi moomu; khaanakhala o munnepani, nanso asotwani. ");
INSERT INTO mgh_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Phimaana nipuro niri uramana ni wiihelela, ciri iporonka ni coonanara cinci. ");
INSERT INTO mgh_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Nanso ankhili ankhuma wirimu ari ooreera, osalaama, onnema, eemaani ni oocara ikiriri, ookumiha mihokorokho comaana, oohihawulaniha ni oohiithepya. ");
INSERT INTO mgh_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Ni wosalaama phinwiihaya isalaama ale anaala nhokorokho wosariya. ");
INSERT INTO mgh_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Cinkhumelela vayi ikhotto nnyo ni waanaca winyu ayaayoru nwo? Cinkhuma nkhwiluni cinaana mwirutthuni mwinyu mmo. ");
INSERT INTO mgh_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Nnakhalela nttima ca akhwinyu ni khannophwanya. Nnawiiva ni nnarama nanso khannophwanya. Makhalelo enyu ari owiiva ni waana ikhotto. Nnavekela nanso khannakhela, kontha khannovekela ratta. ");
INSERT INTO mgh_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Nnophavela mwaphwanyaka nrihakaceleke nkhwiluni mwinyu mmo. ");
INSERT INTO mgh_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Nyu mayooluva, khannocuwela wiira upatthanana ituniya unkhala mwiinani awe Nluku? Ule nophavela ukhala mpwana awe ituniya, neepanka mwiinani a Nluku. ");
INSERT INTO mgh_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Atthuna nnoona wiira waari wopure cihimilyaya cowantikhiya ciiraka: Nnepa univahilyawe wiira ukhale ni hii uhaana ihace? ");
INSERT INTO mgh_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Nanso uyo nanivaha nnema nuulupale. Phimaana cowantikhiya ciiraka: Nluku nawaarusanana owiittottopa nanso nawaavaha nnema oowiyeviha. ");
INSERT INTO mgh_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Phimaana, mmwiiwelele Nluku. Munkhottele sotwani ni uyo phinhalawe wuutthawani. ");
INSERT INTO mgh_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Mphiyeke wa Nluku, ni uyo phinhalawe wuuphiyerani! Anataampi, nnyaweke ni nrapiheke nrima, nyu anamirima miili. ");
INSERT INTO mgh_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Ncukuleke ni muunleke. Mwakakhaniheke uthyaa ni wunla, utteeliya ni ucukula. ");
INSERT INTO mgh_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Mwiiyevihe wa miithoni wa Apwiya ni ayo phinhalaya uwunnuwihani. ");
INSERT INTO mgh_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Asunnaka, nhaapanane. Ule nomwaapa munnaawe atthuna unhukhumu munnaawe, noolumacera yoonanara ni nohukhumu malamulo. We wamakelaka uhukhumu malamulo, khuneettela, nanso wiyeesile ukhala mayoohukhumu. ");
INSERT INTO mgh_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Nlamuli ni hukhumu ri mmoca paahi, yoole noorya woopola nuukwanyula. Vano we, tipani oonhukhumu nkhwaa? ");
INSERT INTO mgh_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Vano nviriyane, nyu nneeresa: Ilelo atthuna meelo, ninaarwa iparasa yonese, ni ninkookhala mwakha mmoca nimweettaka nakoso nuuphwanya nhakhu. ");
INSERT INTO mgh_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Nyu khancuwenle itthu inhala wuukhumelelani meelo. Ukumi inyu uyo unookhala isiyani? Nyu nri toko itthapwe inkhuma ni ukati vakani inamwaryaca. ");
INSERT INTO mgh_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Uhiya wuulumaca commo, fatari wiira: Apwiya yatthunaka ni anivahaka ukumi, ninapanka ila ni ile. ");
INSERT INTO mgh_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Nanso, nna, nnasamela citthu cinoopuwelenyu upanka. Wiisamiha toko coo inkhala itthu yoonanara. ");
INSERT INTO mgh_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Phimaana muupuwele ratta: Ule nocuwela wiira nolamuliya upanka yooreera, pihipankaka, naakosa. ");
INSERT INTO mgh_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Vano nviriyane, nyu mathaaciri! Ncukule ni munle mwanlattu wo mahuviho anhala wuphwanyani. ");
INSERT INTO mgh_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Mihakhu cinyu nnyo, ikuwo cinyu ni coolya cinyu, cihontta ni ciholiya ikuttihi. ");
INSERT INTO mgh_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Iwooru inyu ni ipheeta enyu cihonyela urenci. Vano urenci uyo phinhala ukhala saahiti owuuttonkani ni wuulalihani toko waneerihaya mooro. Nyu nhothacirera mahuku oomalela. ");
INSERT INTO mgh_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Mooneke. Ncurukhu wa ananteko yoorula mmattani mwinyu ayo, nhaalivaka, unakhuwela wuttonkakani nyenyu vaa. Wiikhupanya wa anakanyari uhophiya mpaka mmanyaruni mwa Apwiya a anakhotto. ");
INSERT INTO mgh_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Nyu nheetta mpuhaka ni nhovolela ikhwilu cothene cucivenleni vathi va. Nhorittimalihera mirima cinyu nnyo nihuku noohitiya. ");
INSERT INTO mgh_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Nnanhukhumu nuumwiiva nasariya, wohiwiirihani itthu. ");
INSERT INTO mgh_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Phimaana asunnaka, nkhale oovilela, mpaka wanhalaya uwa Apwiya. Kinawoona mayoolima navilela awehereryaka yoolya yo mmattani, mpaka wammwaya ipula coopacera ni coomalihera. ");
INSERT INTO mgh_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Ciicammo nyu nkhale oovilela ni oolipa nrima, kontha uwa wa Apwiya uri wakhiviru. ");
INSERT INTO mgh_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Asunnaka, nhittokuttani ayaayoru wiira nhihukhumwinye. Hukhumu uyo ri wankhora! ");
INSERT INTO mgh_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Asunnaka, niwehere minapiyu coolumaca mwa ncina na Apwiya, ciinryaya woohuva nuuvilela. ");
INSERT INTO mgh_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Kinawoona nineerela ahoreeriya ale yiisunkile ni uvilela. Nnawiiwaka uvilela wa Yopi ni nhoona yaceenryaya. Apwiya ari oocara uthunku ni ikiriri. ");
INSERT INTO mgh_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Asunnaka, hata mwiirihiye cani, nhilupele nromolaka wirimu, atthuna vathi va, ni hata itthu phi itthu iheliye nhilupelele. Yakhalaka khweeli, mwiireke khweeli, yakhalaka mena, mena, wiira nhihukhumwinye. ");
INSERT INTO mgh_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Wariyari winyu vaa haawo nohuva? Aswaliki. Haawo tteeliye? Eepeke icipo coolemeliha. ");
INSERT INTO mgh_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Wariyari winyu vaa haawo nowerennya? Arume urweliya ahooleli okereeca, wiira yoonswalele ni anttikitthele makhura, mwancina na Apwiya. ");
INSERT INTO mgh_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Iswali yowaamini navona nretta ni Apwiya anaanwusa; ni wakhala wiira nookosa, naleveleliya. ");
INSERT INTO mgh_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Phimaana, nlaphulule itaampi cinyu nnyo waakhwinyu ni nswalelaneke wiira nvonihiye. Ulapa wa nasariya uhaana ikuru yoolipa. ");
INSERT INTO mgh_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Eliya aari ntthu, oolikana makhalelo ayo toko hii. Ule ahoswali venci wiira ihirupe ipula, ni khweeli ilapo yothene khayaarupile ipula mpaka umala myakha miraru ni nuuso. ");
INSERT INTO mgh_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Ahaakulela tho uswali, vano irimu yahovaha ipula vathi nuumela mihokorokho. ");
INSERT INTO mgh_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Asunnaka, wariyari winyu vaa akhalaka ntthu hiile ikhweeli, vano aturuselihiyaka ni nkhwawe, ");
INSERT INTO mgh_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","ncuwele wiira ule nonturusiha nataampi warukurerya cawe, nawoopola iroho awe wuukhwani ni cinakhuneelya itaampi cinci. ");
ALTER TABLE mgh_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
