﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgh2016_vpl;
CREATE TABLE mgh2016_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgh2016_vpl WRITE;
INSERT INTO mgh2016_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Alha phi machina a manyaapwiiya awe Yesu Kuristo o iyari ya Adaudi o iyari ya Aburahimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburahimu ni Naisaka ni Nayakhobo ni Nayuda ni achihimaya, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Nayuda nkaayara Nafarisi ni Nazera anumwanaya yaari Atamari. Nafarisi ahaayara Nahezironi, Nahezironi nkaayara Narami, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Narami nkaayara Naaminaadabu, Naaminadabu nkaayara Nanashoni, Nanashoni nkaayara Nasalmoni. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Nasalmoni nkaayara Naboazi, anumwanaya aari Narahabu, Naboazi ni Naruthu yaari manyanaangoro a Naobedi athumwanaya Nayese, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Naobedi nkaayara Nayese, Nayese nkaayara Amwene Adaudi. Adaudi nkaayara Naselemani (anumwanaya Naselemani aari Nabethsheba, mahanu a Nauriya). ");
INSERT INTO mgh2016_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Naselemani nkaayara Narehoboamu, Narehoboamu nkaayara Naabiya, Naabiya nkaayara Naasafu, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Naasafu nkaayara Nayehoshafati, Nayehoshafati nkaayara Nayoramu, Nayoramu nkaayara Nauziya, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Nauziya nkaayara Nayothamu, Nayothamu nkaayara Naahazi, Naahazi nkaayara Nahezekiya, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Nahezekiya nkaayara Namanase, Namanase nkaayara Naamoni, Naamoni nkaayara Nayosiya, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Nayosiya nkaayara Nayekoniya ni achihimaya. Yeyo yaari ikatema Ayahudi vaari aya upottani Ubabeli. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ikatema Ayahudi vaarwehiye aya upottani Ubabeli, Nayekoniya nkaayara Nashaltieli, Nashaltieli nkaayara Nazerubabeli, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Nazerubabeli nkaayara Naabihudi, Naabihudi nkaayara Naeliakimu, Naeliakimu nkaayara Naazori, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Naazori nkaayara Nasadoki, Nasadoki nkaayara Naakimu, Naakimu nkaayara Naeliudi ");
INSERT INTO mgh2016_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Naeliudi nkaayara Naeliazeri, Naeliazeri nkaayara Amathani, Amathani nkaayara Nayakhobo, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Nayakhobo nkaayara Nayusufu owannyaya Amariamu anumwanawe Yesu neehaniya Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Paahi etu, iyari chaari khumi ni ncheshe toka wa Aburahimu mpaka wa Adaudi, ni iyari khumi ni ncheshe toka wa Adaudi mpaka Ayahudi vaakushiye aya upottani Ubabeli ni iyari khumi ni ncheshe toka ukushiya ipotta mpaka vaayarelhe awe Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Paahi etu, cho phi chiichammo chenre aya wo uyaria Yesu Kuristo. Amariamu anumwanawe aari anavekiye ni Nayusufu, nansho uhinaya ukhalhiya vamoka thoko nlhopwana ni ahanu awe, Amariamu ahoonia wiira aari veruttuni wo woorihiya ni Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nansho ukhalhawaya Nayusufu owannyaya ayo, aari attu o nrima woombone, khaathananne woolhiha muru Amariamu vaattuni. Paahi etu aholhakelha waahiya wo nivitho, wo uhichuwania ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Vaari aya oopuwelhaka nenno nlhove nno etu, Nnepa wo wiirimu wa Athithi wahaakhuruwelha ntorani weeraka, “Inyu Nayusufu, mwaana a Adaudi, nhoove waakusha Amariamu akhalhe ahanu inyu, ukhalhawaya iweyi aya iyo iri wo worihiya ni Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Anowa wiittukulha mwaana mwanlhopwana, ni inyu mmweeke mwaamwihana nchina nawe Yesu, ukhalhawaya yoyo phi nolhoha woopolha attu ukhuma mu uwonyani mwaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Paahi alha onkhaye alha yaakhumelhenlhe nitimire nlhove ni Athithi naahimiye ni anamilhohi wiira, ");
INSERT INTO mgh2016_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwalhi hinaatameriya nowa urupalha irukulhu ni unnyara mwaana mwanlhopwana nchina nawe nowa wiihaniya Imanueli.” Maana aya, “Nlhuku ri vamoka ni hii.” ");
INSERT INTO mgh2016_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nayusufu vonkwilhe aya nkhoveni ahopanga thoko Nnepa wo wiirimu wa Athithi chenre aya wo ulhehera. Nkaakusha ni waakhalhana ahanu aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nansho khawaarupiye vamoka mpaka vannyanre aya mwaana mwanlhopwana. Ni ayo nkayammaha nchina nawe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu aayarelhe iwani yo Ubethelehemu ilhapo yo Uyudea mahuku Naherode vaari aya amwene. Avireke mahuku, achuwelhi o ittotwa ukhuma unosha nchuwa yahowa Uyerusalemu ");
INSERT INTO mgh2016_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nkayaakoha, “Mwaana nowa ukhalha mwene a Ayahudi yariye vayi? Ukhalhawaya nihoona ittotwa awe vaakhumelhenlhe aya unosha nchuwa, ni hii nihowa unthimichani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amwene Naherode yeeweke yayo malhove ayo, ahokelhiya nipampa chinene, vamoka ni attu onkhaye o Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nkeehanacha Opochera ishaani Olhupalhe onkhaye vamoka ni attu owiittuchiha Malhehero a ashinna Musa nkaakoha, “Kuristo nohalha uyaria vayi?” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ni ayo nkayaakhulha, “Ubethelehemu ilhapo yo Uyudea. Phi chiichammo anamilhohi chaalhempe aya, ");
INSERT INTO mgh2016_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Inyu attu o Ubethelehemu ilhapo yo Uyudea, Inyuva kanhiwe akani variyari wo iwani cho uchuwania cho Uyudea, Ukhalhawaya uwaninyu nowa ukhuma nholhelhi Nolhoha waaholhelha attu aka o Uisraeli.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Vavawo Naherode nkayeehana untemerani achuwelhi o ittotwa yaakohe wiira yoonelhe yaakhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yamalheke nkaaruma arwee Ubethelehemu yeeraka. “Nrweeke mwakoherere ikekhia yo malhove o mwaana uyo, mwamwoonaka, nkiwiihereke nttenga ni mii kirwee kanthimiche.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baada yo wiiwa malhove a Naherode, nkayaarwaa. Vaari aya mphironi nkayoona ittotwa ilhe yaaholhelhaka ikhumaka unosha nchuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Vonne aya nkayaatelhiya chinene ni iyo nkayaaholhelha mpaka vaari awe mwaana. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nkayaakelhacha mpaani, nkayaamwona mwaana uyo vamoka ni Amariamu anumwane, nkayaakhoroma unthimicha. Nkayaathaphulha mirupa chaya ni ukumiha izawadi, idhahabu ni ubani ni manemane ummaha mwaana. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nkayaahokolhia umawannyaya aviraka iphiro chikina, ukhalhawaya Nlhuku ahaamuka ntorani wiira ahihokolhelhe tho u Naherode. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Alheto alhe athameke, nnepa wo wiirimu wa Athithi nkawaakhumelhelha Nayusufu ntorani ni weerelha, “Naherode anothanana umwiiva mwaana uyo. Munkweke etu munkushe mwaana vamoka ni anumwanawe ntawelheke Umisri. Mwakhalheke wowo mpaka vanohalha aka uhimeriani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Paahi etu Nayusufu nkayonkwa nkayankusha mwaana vamoka ni anumwanawe nkayaathama ni uhiyu nkayaarwaa Umisri. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nkayaakhalha wowo mpaka Naherode vaakhwilhe aya. Nenno nlhove nno naapangia nitimire nlhove ni Athithi wo iphiro yo anamilhohi neera, “Kahomwiihana mwaamwanaka ukhuma Umisri.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naherode yachuwelheke wiira achuwelhi o ttotwa alhe ahaathepiacha, ahorushiya chinene. Nkaalhehera wiira ashaana ashilhopwana onkhaye o iwani yo Ubethelehemu ni iwani cho waatamana, o malhipa o iyaakha pilhi ukhuruwa vathi yeevakachiye. Aapangilhe chiicho uttwaraana ni mahuku veewilhe aya yoyo mwaha uyo ukhuma wa achuwelhi o ttotwa alhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Phi chiichammo chenre aya wo utimira malhove yaahimiye wo iphiro ya anamilhohi Nayeremiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nlhove niheewania Uraama. Ikutto yulhupalhe. Araheli yonlhelhaka achishaana aya, Akhotaka umalhihiya, Ukhalhawaya khaawo tho.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Naherode yarimeelheke, nnepa wo wiirimu wa Athithi wahaakhumelhelha Nayusufu ntorani Umisri ");
INSERT INTO mgh2016_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nkaweerelha, “Munkweke, munkusheke mwaana vamoka ni anumwanawe nhokolhieke tho ilhapo yo Uisraeli, ukhalhawaya alhe yaathanana ukumi wa mwaana uyo ahokhwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Paahi etu Nayusufu ahonkwa, nkankusha mwaana vamoka ni anumwanawe nkayaahokolhia wi ilhapo yo Uisraeli. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nansho Nayusufu yeeweke wiira Akelao mwaana a Naherode aari phi mwene o Uyudea nipuro ni athumwanawe, ahoova uhokolhia wowo. Ni ayo ahovahiya malhove makina ntorani o uchiichihiya, nkaarwa Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nkaathamelha iwani yo Unazareti. Phenre aya wo utimira malhove yahimiye ni anamilhohi wiira “Nowa wiihaniya Nnazarayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yayo mahuku ayo Nayohana Obatiiza ahokumelhelha uthako wo Uyudea, nkaachokholha wettuchiha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yaari yeeraka, “Nkhoromeke ni uhiya uwonya winyu, ukhalhawaya Imwene yo wiirimu ihaatameria!” ");
INSERT INTO mgh2016_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nayohana phi alhe aahimiye ni anamilhohi ashinna Isaya venre aya, “Ntu nookhuwelha muuthakoni, ‘Nkooroshe iphiro ya Athithi, Mwookolhe iphiro chaya cho uvira!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nayohana ayo yaawara ikuwo chaatottiye wo mapururu o ingamiya, ni nchako nnyununi mwaya, cholhia chaya chaari nashombe ni urawo wo umwiini. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Attu ukhuma Uyerusalemu ni ilhapo yonkhaye yo Uyudea, ni ilhapo cho nchereshere mwoolhoko wo Uyorodani ahowa uwiiwelhelhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nkayaakhoroma ni uhimiacha uwonya waya, nkaabatiizacha mmwoolhokoni Uyorodani. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nayohana yooneke Amafarisayo ni Amasadukayo enchi awaachaka athananaka ubatiiziya nkeerelha, “Inyu iyari yo inwaa nhimeriye ni apani wiira nttawe ntwarusho Nlhuku unowiiha awe? ");
INSERT INTO mgh2016_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mwooniheke etu wo mitheko wiira nhorukunuwa ni uhiya uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nhaanyihere wiira nihanaa athumwanihu, Aburahimu ukhalhawaya kinouhimeriani wiira Nlhuku noworia uthathusha alha malhuku alha nkaakhalha ashaana a Aburahimu! ");
INSERT INTO mgh2016_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ipacho iri tayari ukakha mwiri vamithithaarini, kila mwiri uhinemma rata unookakhiya ni urihelhiya vamooroni. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","mii kinobatiizani wo maashi wooniha wiira nhokhoroma, nansho nowa vatulhi waka nowa uubatiizani wo Iphumu ya Nlhuku ni mooro. Akhalhaka muulhupahe ukipwaha mii, kihiphwanelhiyaka inakhalhaka ukusha iratu chawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yoyo novarelha mmononi ithelho yo uveerelha cholhia, wiira akhungure cholhia chawe, athokorerie ingaano nnikhupini, ni upaha iphepuwa vamooroni vahintiphiaa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yeyo ikatema iyo Yesu nkaawa akhumaka Ugalilaya, nkaawa u Nayohana umwolhokoni Uyorodani ni uyo abatiiziye ni Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nansho Nayohana aholhikacha unkhotelha eeraka, “Mii phi nophwanelhiya ubatiiziya ni inyuva, chani woonaka nnowa uwannyaka mii!” ");
INSERT INTO mgh2016_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nansho Yesu nkeera, “Nhiye chikhalhe chiicho wo naanano va, ukhalhawaya wo yeyo iphiro iyo ninoopanga chittu chinothanana awe Nlhuku chonkhaye.” Vavawo Nayohana nkayaarumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu amalheke ubatiiziya, ahokhuma mmaashini. Irimu nkayaahulhiaa, nkamwoona Iphumu ya Nlhuku akhuruwaka thoko kaulha ni unkorweelha vachulhu vawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nlhove ukhuma wiirimu nkaneera, “Ulha phi mwaamwanaka kinonttuna aka, hokichivelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yamalheke, Iphumu ya Nlhuku ahonholhelha Yesu mpaka uthakoni alhikachye ni Nakare. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nkaattuka wo mahuku makhumi ncheshe uthana ni uhiyu wo uhilhia, nkaawolhiya ithalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Paahi etu Nthepi nkanrwelha nkeera, “Wakhalhaka uwe phi mwaana a Nlhuku, wiireke etu alha malhuku alha athathuwe ukhalha mikatte.” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nansho Yesu nkaakhulha, “Iholhepiya, ‘Ntu khanolhama wo nkatte vekha, nansho wo nlhove ninohimiya ni Nlhuku.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nakare nkankusha mpaka Uyerusalemu, Iwani Itakatifu, nkaamwemesha vachulhu ishanja yo Inupa ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nkeera, “Wakhalhaka uwe phi mwaana a Nlhuku uthupheke mpaka vathi ukhalhawaya iholhepiya wiira. ‘Nlhuku nowaalhehera minepa cho wiirimu awe chiwe wo nlhatu winyu, Okusheni mmathathani mwaya, Nhiwe mwaakwakwathuwa mmalhukuni.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu nkaakhulha nkeera, “Iholhepiya tho wiira, ‘Nhaalhikache Athithi, Nlhuku inyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yamalheke Nakare nkankusha vachulhu mwaako wo urekama, nkaamwoniha imwene chonkhaye cho velhaponi va ni urera waya wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nkeera, “Chii chonkhaye chi kinowuvaha wakikhoromelhaka ni ukithimicha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Vavawo Yesu nkaakhulha, “Uthame vaa uwe Nakare! Iholhepiya, ‘Mwaathimicheke Athithi, Nlhuku inyu vekha aya ni uvara mitheko chaya!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Paahi Nakare nkanhiya Yesu, ni minepa cho wiirimu nkachaawa ni unkavihera. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu eeweke wiira Nayohana ahottukiya, ahohokolhia Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nansho kaakhanlhe Unazareti, nkaarwaa Ukapenaumu, ilhapo iri vachereshere nttiya no Ugalilaya, mmwinanoni mwo Uzabuloni ni Unaftali. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Phi chiicho chenre aya wo utimira nlhove naahimiye ni anamilhohi ashinna Isaya venre aya, ");
INSERT INTO mgh2016_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ilhapo yo Uzabuloni ni ilhapo yo Unaftali, Iphiro yo unttiyani, ukhopelhelhe Uyorodani, Ugalilaya, ilhapo ya attu ahinchuwenlhe Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Attu anokhalha mwiipiphini Anowa woona nthuko mulhupalhe. Wa attu anokhalha nhina ilhapo yo irungu yo nookhwa Nthuko unowa waamwalhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Toka yeyo ikatema iyo Yesu nkaachokholha wiittuchiha eeraka “Nkhoromeke nhiyeke uwonya winyu, ukhalhawaya Imwene yo wiirimu ihaatameria!” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu vaari awe eetaka vachereshere nttiya no Ugalilaya, ahoona attu o uvara ihopa elhi, Nasimoni eehaniya Peturo ni ahima aya Naandorea, ariaka ihopa ni nttavi munttiyani. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu nkeerelha, “Nkittware, ni mii kinowittuchihani woopolha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nkayaahiyacha ittavi chaya ni unttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Arweeke miholho nkoona attu akina elhi, Nayakhobo ashaana a Nazebedayo ni nhima aya Yohana. Yayo yaari nkalhavani vamoka ni athumwanaya Nazebedayo ayo alhokihachaka ittavi chaya. Yesu nkeehanacha, ");
INSERT INTO mgh2016_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ni ayo nkayaahiyera ikalhava iyo athumwanaya, nkayanttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu aari eetakachaka ni wiittuchiha mu inupa cho unlhapelha Nlhuku ilhapo yonkhaye yo Ugalilaya ahimiachaka Malhove Orera anohimia Imwene yo wiirimu, ni waalhamiha attu kila mareta yaarina aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mwaha wawe nkawaawanelha ilhapo chonkhaye cho Usiriya, nkaawiiheriya attu aawereiya, yaari ni mareta ni alhe aahuvihachiya, attu aakelhiye ni mashoka o unanara, ichilhichilhi ni attu o remara ni Yesu nkaalhamihacha onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Milhoko cha attu chinchi nkachanttwara ukhuma Ugalilaya, Udekapoli, Uyerusalemu, Uyudea ni ukhopelhelhe mwoolhoko wo Uyorodani. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ooneke milhoko cha owiittucha awe, nkaawelha vamwaakoni, nkaakhalha. Owiittucha awe nkayaawacha, ");
INSERT INTO mgh2016_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ni uyo nkaapatakulha malhaku awe nkaachokholha weettuchiha. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ahoreeriya attu o nrima unohuvelha uchuwelha nlhove na Nlhuku Ukhalhawaya Imwene ya Nlhuku phi yawaya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ahoreeriya attu anonlha, Ukhalhawaya anomaalhihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ahoreeriya attu arii ni nrima wo wiitimarikha, Ukhalhawaya phi nohalha uhiyeriya ilhapo!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ahoreeriya attu ammolhiya ithalha ni nttona no upanga chittu chinothanana awe Nlhuku, Ukhalhawaya anowa uwonihiya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ahoreeriya attu o ikiriri, Ukhalhawaya Nlhuku nowa waahiyerera milhatu chaya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ahoreeriya attu o nrima worera, Ukhalhawaya anowa umwoona Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ahoreeriya attu aneewananiha attu, Ukhalhawaya anowa wiihaniya ashaana a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ahoreeriya attu anohuvihiya wo nlhatu wo upanga chittu chinothanana awe Nlhuku, Ukhalhawaya Imwene yo wiirimu phi yawaya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nhoreeriya inyu mwaattiva, attu oruwanakani ni uthurulhani ni uwotheriani wo kila iphiro yo unanara wo nlhatu no ukirumelhelha mii. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nteelhiyeke ni uttapelhelha ukhalhawaya uttuviya winyu uhenchiva wiirimu. Phi chiichammo chaathurulhachiye aya anamilhohi yaari nhinaaya inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwaattiva phi maakha a attu onkhaye. Nansho maakha athuwaka anohalha uchivihani? Khanolhoka tho, yaahikhalhe urihiya vattayani ni unyikalhiya ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwaattiva phi nthuko wo velhaponi. Iwani ithekiye vachulhu mwaako khineevitha. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Khaawo ntu noparihelha ikhandiri ni ukhunelha ndebe. Nansho ikhandiri inothomeiya vachulhu ikiango, yaamwalhelheke onkhaye ari mpaani. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chiichammo etu, nthuko inyu unothananiya umwalhieke mwaattuni, attu oone meetelho inyu oombone, wiira aavahe nthimicho Athumwaninyu ari wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nhaanyihere wiira kiwiilhe uchiichiha Malhehero a ashinna Musa ni ikano cha anamilhohi. Akiwiilhe uchiichiha, nansho uhimiechesha. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kinouhimeriani we ikekhiaye wiira mpaka irimu ni ilhapo vanohalha aya uvira, khiiwo inakhalhaka inukuta imoka ama vakittu vakani chinene nhina Malhehero a ashinna Musa, vanohalha uwukulhiya mpaka onkhaye vanohalha aya uphiyelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Paahi etu, ntu riyoothe nolhoha uhiya nlheheriyo nimoka nikani upwaha onkhaye, ni weettuchiha attu akina apange chiicho, yoyo nowa waalhakelhiya mwankani nhina Imwene yo wiirimu. Nansho nolhoha uvara ni weettuchiha attu akina yoyo nookhalha mulhupalhe mu Imwene yo wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Paahi kinouhimeriani, ikekhia inyu yaahipwaheke ulhoka wa Amafarisayo, ni attu owiittuchiha Malhehero khannowa mwaakelha mena nhina Imwene yo wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nhomalha wiiwa wiira attu o khalhayi yeerelhiye, “Nhiive, nolhoha wiiva nohukumulhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nansho mii vano kinouhimeriani wiira, ntu riyoothe nonthunanelha mmuchi awe yoyo arweehiye umilhatuni ahukumulhiye. Ntu nolhoha umwiirelha munnawe, Khannolhoka inyu! Yoyo arweehiyeke umilhatuni wulhupalhe, ni uyo hechatameriha umooroni Ujehannamu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mwarweehaka isadaka umadhubahuni uno muupuwelhaka wiira nhima inyu rii ni nlhove ni inyu, ");
INSERT INTO mgh2016_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nhiyeke isadaka inyu umadhubahuni nhokolhieke thoko mwamwiwanane nhima inyu, vavawo mmweeke tho ni ukumiha ishaani inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mmwiiwananeke ntu muntekenlhe inyu nhinaphiya umilhatuni. Mwaphiyaka wowo nhineewanana nowa uuhelhani mmathathani mwa attu o uhukumulha, ni ayo anowaavaha manyaasikari anaattuka attu, mwattukiye. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kinouhimeriani wo ikekhiaye, wowo khannokhuma mpaka nholhiva nchurukhu wo umalhihera nlhatu winyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nheewa wiira attu yeerelhiye ‘Nhilhuve!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nansho mii kinouhimeriani, ntu nommweha nthiyana wonthanana, honlhuvana munrimani mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Paahi etu niitho ninyu no wiimonono nottekihakani, nkhulheke ni urihelha uwo shoro! Nambaya chinene uhikhalha ni itturi imoka mwiiruttuni mwinyu, iruttu yonkhaye ihiwe yaarihiya umooroni. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni moono inyu wo wiimonono wo uttekihakani, ntupulheke ni urihelha utayi! Nambaya mpoterihe itturi imoka mwiiruttuni mwinyu, iruttu inyu ihiwe yaatikhelhiya yonkhaye umooroni Ujehannamu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tho, yaheeriya wiira, ‘ntu naahiya ahanu awe, aavaheke italaka yo umwalhaana.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nansho mii kinouhimeriani wiira ntu aahiyaka ahanu awe ni waavaha italaka yo umwalhaana vahirii nlhatu no ulhavalhava, haalhavalhaviha, ni ntu nottuna waathelha ni uyo holhavalhava. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Tho nheewa wiira attu o khalhayi yeerelhiye ‘Nhilhiyalhe ulhupelha winyu, nansho ntimiriheke naapo ninyu wa Athithi.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nansho mii kinowirelhani nna, nhilhupelhe irimu, ukhalhawaya phi ihiche ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","mena wo ilhapo, ukhalhawaya phi nipuro chineesha aya mieto chaya, mena wo Uyerusalemu, ukhalhawaya phi iwani ya Amwene olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nhilhupelhe wo muru inyu, ukhalhawaya khannoria uthathusha ikharari inyu imoka ukhalha ipwii ama yooripa. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mweeraka ‘Eiyo’ ikhalheke ‘Eiyo!’ Mweeraka ‘Kachihena’ ikhalheke ‘Kachihena.’ Ittu iriyoothe yo upwaha yayo inokhuma wa Nakare. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nheewa yeeriye wiira ‘Niitho wo niitho ni niino wo niino.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nansho mii kinouhimeriani wiira nhinhokolhoshere ntu no upangelhani cho uhilhoka. Ntu riyoothe o watakani nrama no wilhopwana, munrukunushelheke nikina no wiimushi nno. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni ntu riyoothe o urwehakani uhukumulhiyani athananaka uuthurulhani mwinjiro winyu, munhiyereke awieke ni nikoti ninyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ni ntu okhanyererihakani wiira munkushere nsigo awe nkwaha wo imaili imoka, munrwaaneke imaili pilhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ntu noovekelhani ittu mummaheke, nowaashimani ittu mmwaashimeke. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nheewa wiira yeeriye, ‘Munttuneke mmuchi inyu ni waavenga amalhaponi inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nansho mii kinolhelhani wiira mwaattuneke amalhaponi inyu ni waalhapelhelha attu anowomolhani mwaattiva, ");
INSERT INTO mgh2016_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","mmwe mwaakhalha ashaana a Athumwaninyu ari wiirimu. Ukhalhawaya yayo phi naapharelhiha nchuwa naya attu o uhilhoka ni attu o nrima woombone ni waarupelha ipulha attu oombone ni attu o unanara mirima. ");
INSERT INTO mgh2016_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chani Nlhuku nolhoha uttuvani ittu yaani wo waattuna attu anouttunani vekha aya? Ata attu anolhiviha ikhodi aneera chiicho! ");
INSERT INTO mgh2016_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mwaakohachaka ashilhoko inyu vekha aya, chani vavawo nhopanga ittu yo ulhoka? Ata attu ahinchuwenlhe Nlhuku ni ayo anopanga chiichammo! ");
INSERT INTO mgh2016_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Paahi etu nkhalheke o wiiraniha thoko Athumwanihu o wiirimu chiri aya! ");
INSERT INTO mgh2016_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwiichinanelheke nhiwe mwaapanga chittu chinothanana awe Nlhuku vaattuni, mwoonachiye ni attu. Mwapangaka chiicho vaattuni, khiiwo inohalha inyu uttuvelhiya ni Athumwaninyu o wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Paahi etu vanommaha inyu ittu ntu hirina ittu nhiikhuwelhelhe, nhipange thoko chineera aya anafiki mu inupa cho unlhapelha Nlhuku ni mmaphironi. Aneera chiicho wiira yoonachiye ni attu avahiye nthimicho. Ikekhia kinouhimeriani, yayo ahomalha upochera uttuviya waya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nansho inyuva vanommaha inyu ntu novekelha ittu, mpangeke wo munrimani mwinyu ata ampwana inyu ahichuwelhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mummaheke wo nivitho. Ni Athithi anoona nnivithoni anowuttuvani. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Vanolhapelha inyu, nhipange thoko anafiki! Anottuna ulhapelha aneemenlhe mu inupa cho unlhapelha Nlhuku ni mmaphironi wiira yoonachiye ni attu. Ikekhiaye kinouhimeriani, yayo ahomalha uttuvelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nansho inyu vanolhapelha inyu, mwiittelheke mpaani, ni waalhapelha Athithi inyu ahinoonia. Athithi anoona chiivinthe anowuttuvani. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Vanolhapelha inyu, nhipwapwache malhove thoko attu ahinchuwenlhe Nlhuku, anaanyihera wiira milhuku chaya chinowewelhelha wo nlhatu no malhove menchi. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nhilhikaane thoko yayo. Athumwaninyu ahochuwelha anohalha inyu uthanana nhinaalhepelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Vano etu, iphiro inothananiya inyu wulhumacha vanolhapelha inyu phi ilha, mwiireke ‘Athithi nri Wiirimu, Nchina ninyu nithimichiye, ");
INSERT INTO mgh2016_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Imwene inyu iwe, Chinothanana inyu, chipangieke velhaponi va thoko wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nnivaheke lhelho cholhia chihu cho kila nihuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nnihiyerereke uwonya wihu, Thoko ni hii chineera ihu waahiyerera attu annittekelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nhinihelhe mu ulhikachiyani Nansho nnoopolheke ni ulhe o mitheko cho unanara ulhe.’ (Ukhalhawaya umwene uri wawinyu ni machiri ni nthimicho wo mahuku o uhimalha. Aye.) ");
INSERT INTO mgh2016_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ukhalhawaya mwaahiyereraka attu milhatu chaya, Athumwaninyu o wiirimu anouhiyererani uwonya ni inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nansho mwaahahiyerereke attu akina milhatu chaya, ni ayo Athumwaninyu khanouhiyererani uwonya winyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Vanottuka inyu, nhoonihe ichuku wiitho thoko anafiki chineera aya. Yayo anokhunyanyihacha wiitho yoonachiye ni attu wiira ahottuka. Kinouhimeriani wo ikekhiaye wiira, yayo ahomalha uttuviya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Vanottuka inyu mwiihikeke makhura mmuruni, nkhucheke wiitho ni uvacha ikharari chinyu, ");
INSERT INTO mgh2016_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","attu akina ahichuwelhe wiira nhottuka. Nansho ichuwaniaka tu ni Athumwaninyu ahinoonia. Ni ayo Athumwaninyu anoona chiivinthe, anowuttuvani. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nhiicheshere nhakhu velhaponi va, vari ni ucheshe ni nrenje unotanganya ni attu owiiya aphomolhaka inupa ni wiiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nansho mwiicheeshereke nhakhu inyu wiirimu, ucheshe ni nrenje uhinooria aya utanganyacha ni attu owiiya khanooria uphomolha ni wiiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ukhalhawaya vari nhakhu inyu ni nrima inyu phi nohalha aya ukhalha vavawo. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Miitho phi nthuko wo iruttu. Miitho inyu akhalhaka makumi iruttu yonkhaye iri voonene. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nansho miitho inyu akhalhaka mareta iruttu yonkhaye inohalha ukhalha mwo unanara mwiipiphini. Nthuko uri mwiiruttuni mwinyu wakelhiyaka ipiphi paahi etu, yeyo ipiphi iyo iri yo woopiha chinene! ");
INSERT INTO mgh2016_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Khaawo ntu nokhalha ipotta yo uvara ntheko wa attu elhi ukhalhawaya nohalha unttuna mmoka ni unvenga nkina, nokhalha o ukhulhuvelhiya wa ntu mmoka, ni uhikulhuvelhiya wa ntu nkina uyo. Khannoria ukavihera mitheko cha Athithi Nlhuku ni nhakhu vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Phi iyo inouhimeriakani wiira, nhikhalhe ni nipampa no yolhia ni cho uwuriya chinothananiya ni ukumi inyu wiira nlhame, mena no ikuwo cho uwara mwiiruttuni. Chani ulhia yolhia phi ulhama? Ni iruttu chani ngati phi thempe upwaha ikuwo? ");
INSERT INTO mgh2016_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwooneke ashinuni, khanaalha imbeyu, khanokhungura mena khanoshunga nnikhupini, nansho Athithi o wiirimu anowaalhiha. Chani mwaattiva kanhiwena o ulhoka waapwaha ashaanuni? ");
INSERT INTO mgh2016_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Phi mpani munlhokoni mwinyu ri ni nipampa ninchi nooria wuncherera mahuku o ulhokelha wawe? ");
INSERT INTO mgh2016_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ni nlhatuni no ukhalha ni nipampa no ikuwo? Mwooneke ituva cho mmatimani chineera aya wookonda, khachinopanga mitheko mena utiva. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nansho kinouhimeriani wiira anakhalhaka Amwene Naselemani anene ni upuha waya wonkhaye, khayaapante uwara ikuwo cho nthimicho thoko ituva imoka aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nlhuku phi nokondiha thoko chiicho mathaakhuru o mmatani arii lhelho ahawo meelho ahorihiya vamooroni. Chani khanoria uwarihani mwaattiva wo upwaha chinene? Mwaattiva, chani woonaka mirima chinyu chiri chikani? ");
INSERT INTO mgh2016_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Paahi etu nhikelhiye nipampa ‘Ninohalha ulhiani? Ama ninohalha uwuriani? Ama ninohalha uwarani!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ukhalhawaya chechiyo chonkhaye chiyo chinohuvelhiya ni attu ahinchuwenlhe Nlhuku. Athithi inyu o wiirimu ahochuwelha wiira nnothanana chechiyo chittu chonkhaye chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nansho, mwaatti mwaavieke thoko umwene wa Nlhuku ni chittu chinothananiya ni chiyo chonkhaye nnowunchereriya. ");
INSERT INTO mgh2016_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Paahi etu nhikhelhiye nipampa wo nlhatu no meelho, meelho nihawo nihuku naya. Uthemwa wo nihuku nimoka unowuthoshani wo nenno nihuku nno. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nhaahukumulhe attu akina nhiwe ni inyu mwaahukumulhiya ni Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ukhalhawaya chinohalha inyu waahukumulha attu akina phi chiichammo ni inyu chinohalha inyu uhukumulhiya. Ni uphimelhiya thoko yayo nnaaphimelha inyu attu ayo, Nlhuku phi nohalha awe uphimelhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nnooria chani woona ikokholha nniithoni mwa nhima inyu uno nhoonaka nipattu niri nniithoni mwinyu mwaanene? ");
INSERT INTO mgh2016_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ama inoriacha chani umwiirelha nhima inyu, ‘Munna nkankani kuuthamiheni ikokholha nniithoni mwinyu,’ uno mwaanene nhithamihaka nipattu nniithoni mwinyu? ");
INSERT INTO mgh2016_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Anafiki inyu! Nthamiheke thoko nipattu nirii nniithoni mwinyu, vavawo phi nohalha inyu wooria uthamiha ikokholha irii nniithoni mwa nhima inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nhaavahe ashipwa chittu chitakatifu ahiwe arukunuwaka ni ulhumani mwaanene. Mena nhirihelhe nhakhu inyu nkulhuweni ahiwe anyikalhachaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nvekelheke nnoovahiya, mwaavieke nnoopatta, nhodisheke vankhorani nnoohulhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ukhalhawaya ntu riyoothe novekelha noovahiya, ni ntu riyoothe naavia noopatta ni uyo nohodisha, vankhorani noohulhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Chani haawo ntu riyoothe naangoro munlhokoni mwinyu, nommaha nlhuku mwaamwanawe vanovekelha awe nkatte? ");
INSERT INTO mgh2016_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ama nommaha inwaa vanovekelha awe ihopa? ");
INSERT INTO mgh2016_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ata nhookhalharu attu o unanara mirima, nhochuwelha waavaha achishaana inyu chittu choombone. Malhehero Athumwanihu o wiirimu anoopanga uthepa vavawo anowaavaha chittu choombone attu anaavekelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chittu chonkhaye chinothanana inyu mpangelhiye ni attu ni inyu mwaapangelheke ni ayo chiichammo. Yayo phi Malhehero a ashinna Musa ni ikano cha anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nkelheke wo uvira nlhako wo uyevayeva ukhalhawaya iphiro inokelha uhinlhoka iri yo khanuwa ni nlhako wo ukelha ulhakalhihiyani uwo uri wo khanuwa ni ayo anovira yoyo nlhako uyo ari enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nansho iphiro inoholhelha muukumini iri yo uyevayeva ni attu anooria uvira yoyo nlhako uyo kheechinve. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwiichinanelheke ni anamilhohi o woothacha, anooweelhani ooniaka wo vathe thoko ikhondoro, nansho nhina miichi cho uchacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nnowaachuwelha wo mitheko chaya. Chani attu anowooria urukulha izabibu mmiiwani ama ittini munrokani? Mena! ");
INSERT INTO mgh2016_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Paahi etu mwiri wookonda phi nemma maphepu oombone ni mwiri wo uhikonda uneema maphepu o unanara. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mwiri wookonda khunooria wiimma maphepu o uhilhoka ni mwiri wo uhikonda khunemma maphephu oombone. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mwiri unemma maphepu o unanara unookakhiya ni upahiya vamooroni. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Paahi etu nnowa waachuwelha anamilhohi o woothacha wo mitheko chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kahiwe kila ntu mena nokiirelha ‘Thithi, thithi’ nohalha ukelha Imwene yo wiirimu yaahikalhe alhe anopanga chinthanana aya Athithi ari wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Attu enchi anowa nenno nihuku no uhukumulhiya nno yeeraka, ‘Thithi, Thithi! Wo nchina ninyu nahohimiacha nttenga inyu ni wo nchina ninyu nahoomolha mashoka o unanara ni upanga cho ushangiha chinchi.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Vavawo kinowa weerelha ‘Wo ikekhiaye akuuchuwenlheni mwaattiva. Nthame va inyu mwaatti o uwonya va!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Vavawo ntu neewa malhove aka ni uvarechesha no ulhikaanihiya ni ntu o irusho aathekilhe inupa awe vamwalhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ipulha nkayaarupa ni miolhoko nkachaachara ni iphioo yo machiri nkayaawuka ni inupa kayaatikhinyelhe ukhalhawaya yaathekiye vamwalhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nansho ntu riyoothe neewa malhove aka wo uhivarechesha nolhikaanihiya ni nthirikhi aathekilhe inupa awe vanhaavani. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ipulha yarupeke miolhoko nkachaachara ni iphioo yo machiri nkayaawuka nkayaakakha inupa iyo nkayaawulhuwa wo nkhito!” ");
INSERT INTO mgh2016_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu amalheke wulhumacha yayo malhove ayo nlhoko wa attu uyo nkawoomiya uwanoni wo meettuchiho eetuchiha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ukhalhawaya kheetuchiha thoko owiittuchiha Malhehero a ashinna Musa cheera aya, nansho eettuchiha wo ikuru. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu akhuruweke umwaakoni milhoko chinchi cha attu chahonttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ntu mmoka o makutulha nkaawa wa Yesu, nkaakhoroma eeraka, “Thithi mwattunaka nnookilhamiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu nkookolha moono nkammara eeraka, “Kinothanana nlhameke etu.” Wo uhipicha nkaalhama makutulha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu nkaamwirelha “Nhinhimerie ntu riyoothe. Nansho nrweeke mweechoniheke wa attu opochera ishaani ni ukumiha isadaka thoko chinohimia aya malhehero a ashinna Musa uhimiechesha wiira nholhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu vaakelha awe iwani yo Ukapenaumu nholhelhi mmoka o weemelhelha manyaasikari ahowa ni unlhepelha ");
INSERT INTO mgh2016_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nkeera, “Thithi, karumiya aka ri vanlhilhini nreta hoririyacha iruttu nowereiya chinene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu nkaamwirelha, “Kinoowa unlhamihani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nansho yoyo ntu uyo nkaakhulha, “Thithi, mii akiphwanelhiye wiira inyu nkelhe unupani waka. Nansho nromolheke nlhove tu namitheko aka noolhama. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ukhalhawaya, ni mii kirii ntu kinowehiya ni mamulaka a attu akina, kikhalhanaka ikuru wa anamitheko. Kamwiirelhaka mmoka, ‘Urweeke!’ Khurwaaka. Kamwiirelhaka nkina, ‘Nkaawa va,’ khuwaaka. Nkina, kamwirelhaka ‘Upangeke ilha!’ Khupangaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu eeweke chiicho, nkaashanga chinene nkaahimeria attu anttwara ayo, “Kinohimia wo ikekhiaye wiira, akinapatta umwoona ntu riyoothe mu Israeli ri ni nrima thoko yolha. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paahi etu, kinouhimeriani wiira attu enchi anoowa ukhuma unosha nchuwa ni akina uneelha nchuwa, akhalhaka vakaraamuni vamoka ni Aburahimu, Naisaka, ni Nayakhobo urii Imwene yo wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nansho alhe yaathananiye ukhalha muyoyo Umwene uyo anookakhelhiya vathe wiipiphini, uri nunlhiho ni ukhura miino.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amalheke, Yesu nkaamwirelha nholhelhi a manyaasikari Nrumi uyo, “Nrweeke uwani, ni iyo ikhalhekeke thoko mwinre inyu wo uvara nrima.” Ni yeyo isaa iyo karumiya awe nkaalhama. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu nkaaphiya uwani u Napeturo, wowo nkaaphwanya ahokohi aya Napeturo anari areta vanlhilhini, awereiyaka iruttu. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu nkaavara moono, ureta nkawaalhama. Nkayeemelha, nkayaachokholha waaterekhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uchechilho, Yesu nkaawiheriya attu enchi aari ni mashoka o unanara. Ni uyo wo wulhumacha nlhove tu, nkoomolhacha mashoka ni waalhamiha areta onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aapanga chiicho utimiriha malhove yaahimie ni anamilhohi ashinna Isaya wiira, “Yoyo howia uhichooria wihu, nkaakusha mareta ihu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu vonne awe nlhoko wa attu ananrukurenrie, nkeerelha owiittucha awe arwee ukhopelhelhe nttiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Owiittuchiha Malhehero amoka nkanrwelha eeraka, “Owiittuchiha, ni mii kinouttwarani uriwoothe unohalha inyu urwaa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu nkaakhulha, “Anancheto ahanaa milhiwi chaya ni ashanuni o uchulhu ahanaa iphuuru urimu, nansho Mwaana a Ntu kharina nipuro no waathalhelha muru awe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ntu owiittucha nkina munlhokoni mwawe nkaamwirelha Yesu, “Thithi, nkihiye thoko kirwee kaavithe athumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nansho Yesu nkaamwirelha, “Nkittwareke mii, mwaahiyeke attu akhwilhe avitheke mitembo chaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu nkaawelha nkalhavani, owiittucha awe nkayanttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vahipincheru iphioo yo machiri nkayaawukelha munttiyani, maashi nkaakelha nkalhavani. Nansho Yesu aari narumpe ikhove. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Owiittucha awe nkayanrwelha, nkayammusha yiiraka, “Thithi, nnoopolhe, ninootitimira!” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu nkaakhulha, “Mwaattiva o nrima mwankani, chani nnoovani?” Nkeemelha nkaachachera iphioo ni maashi, nttiya nkanaamaalha shiriri. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Attu nkayoomiya uwanoni yiiraka, “Phi ntu ani yolha? Ata iphioo ni nttiya chinomwiiwelhelha!” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ni owiittucha awe nkayaaphiya ukhopelhelhe nttiya no Ugalilaya wi iwani yo Uagadara, wowo attu elhi yaavariye ni mashoka o unanara nkayankumaana akhumachaka umahiyeni. Yayo attu ayo yaari o woopiha chinene, mena khaawo ntu aavira yeyo iphiro iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ni ayo nkayaachokholha unyakulhacha yeeraka, “Urinani ni hii, uwe Mwaana a Nlhuku? Chani uwilhe unitwarusha nihuku nihu nihinaya?” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vakhiviru ni vavawo vaari vahuwiyaka miphingo cho ikulhuwe. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mashoka o unanara ayo nkayanlhepelha Yesu wiira, “Mwanoomolhaka, nnihiyeke nakelheke mphingo wo ikulhuwe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu nkeerelha, “Nrwaacheke etu.” Vavawo nkayaakhuma attu o mashoka alhe, nkayaakelha nkulhuweni. Miphingo chonkhaye cho kulhuwe nkachaakhuruwelha uhito, nkachaakelha mmaashini nkachaakhwacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Attu yaahuwa ikulhuwe ayo nkayaattawacha nkayaarwaa, wowo nkayaahimiacha mmamatani chittu chonkhaye chaakumelhenlhe, ni mwaha wa attu o mashoka elhi alhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Paahi attu onkhaye o yeyo iwani iyo yahokhuma ni unrwelha Yesu, yamwooneke nkayanlhepelha wiira athame mwiilhaponi mwaya mmo. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu nkaawelha nkalhavani nkaalhapuwa nttiya nkaaphiya iwani yo uwannyawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Vavawo nkayaawacha attu anakunshe nkori wankushilhe aya ntu mmoka oheeta. Yesu vonne awe nrima aya, nkaamwirelha ntu oheeta uyo, “Upisheke nrima, mwaamwanaka! Uhohiyereriya uwonya wawo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Owiittuchiha Malhehero nkayaachukulhacha ashineneru wiira, “Yolha ntu ulha nonlhava Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ahochuwelha ichuku chaya chiyo nkeera, “Nlhatu waani wo uchukulhacha mmamirimani mwinyu chittu cho uhilhoka chiyo? ");
INSERT INTO mgh2016_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Varenre vayi, umwiirelha, ‘uwonya winyu uhohiyereriya’ ama wiira ‘wunkweke, weeteke?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Paahi etu kinothanana nchuwelheke wiira Mwaana a Ntu hanaa ikuru velhaponi yo uhiyerera uwonya wa attu.” Vavawo nkaamwirelha ntu oheeta ulhe, “Wunkweke etu, ukusheke ikori awo urweeke uwani!” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ntu oheeta ulhe nkeemelha nkaarwa uwannyawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Attu onkhaye munlhokoni mmwe yooneke yayo, yahoomiya uwanoni ni woova, nkayanthimicha Nlhuku avanhee attu ikuru thoko yeyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ahothama vavawo. Vaari awe mphironi ahomwoona ntu mmoka eehaniya Matayo nakhanlhe wi inupa mwaalhivelhiya ikhodi. Yesu nkaamwiirelha “Nkittware.” Ni uyo nkeemelha ni unttwara Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nkayaakhalha etu, vaari awe mpaani unupani u Namatayo alhiaka yolhia, attu yaalhiviha ikhodi enchi ni attu o uwonya yahorwaa nkayaakalha vamoka ni Yesu ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Amafarisayo yooneke chiicho, nkayaakoha owiittucha awe, “Chani woonaka owiittuchiha inyu anolhia vamoka ni attu anolhiviha ikhodi ni attu o uwonya?” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu veewilhe awe nkaakhulha eeraka, “Attu akumi khanaavia abwana mganga ihikhalhe areta phi naavia abwana mganga. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Paahi etu mwiittucheke yayo malhove aneera ayo, ‘Ikiriri phi nothanana aka, mena kuhiwe isadaka ya ashinama.’ Akiwilhe weehana attu o nrima woombone nansho attu o uwonya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yamalhekeru, owiittucha a Nayohana obatiiza yahommwelha Yesu nkayankoha, “Hii ni Amafarisayo va ninottuka venchi, nansho chani woonaka owiittucha inyu khanottuka?” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu nkaakhulha, “Chani, attu alhalheiye wa arusini anowooria uttuka uno abwana arusi anari vavawo? Mena, kuhiwe! Nansho ikatema inowa uphiya abwana arusi vanohalha aya uthama vavawo, yeyo ikatema iyo attu phi nohalha aya uttuka. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ikuwo yo khalhayi kinotottelhiya imbaati ikumi, ukhalhawaya yeyo imbaati iyo inototokora ikuwo yo khalhayi iyo ni wuncherera vathanlhe vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mena ntumpa wo wulhuvalha khunohelhiya idivai yoochasha. Yakhalhaka chiicho mwaapu unophwiaa ni idivai nkayaarihiaa. Nansho attu anhelha idivai yoochasha nhina mitumpa chikumi, ni chopilhi ntumpa ni idivai chinoolhama chonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu vaari awe olhumachaka yayo, nholhelhi mmoka a Ayahudi nkaawa, nkankhoromelha ni wulhumacha eeraka, “Mwalhi aka hokhwa naanano vaa, nansho chonte nngwe mwamweeshere moono, ni uyo noolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu ni owiittucha awe nkayaathama nkayanttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Opani amoka, aari awereiyaka ireta yo ukhuma iphome, nchorochoro iyaakha khumi ni pilhi, ahonttwara Yesu vatulhi vawe, nkaavara ikuwo awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aapangilhe chiicho opuwelhaka munrimani eeraka wiira, “Kavaraka tu ikuwo awe kinoolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu nkaarukunuwa nkoona, nkeera, “Mwaamwanaka, wiilhipiheke nrima ao uhoolhamiha!” Opani ayo nkayaalhama yeyo isaa iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yamalheke Yesu nkaakelha mpaani mwa yoyo nholhelhi uyo. Oneekeru attu aamopa mpeta ni attu onlhacha, ");
INSERT INTO mgh2016_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nkeera, “Nthamache va attu onkhaye! Mwalhi ulha kanakhwa, howiraka urupa!” Attu yaamwiwilhe ayo nkayanthiacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Paahi etu attu athameke, Yesu nkaakelha mpaani waarumpe awe mwalhi, nkammara moono, ni uyo nkeemelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nenno nlhove nno nkanaawanelha ilhapo yonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu nkaathama vavawo, ni vaari awe arwaaka, attu ohoona elhi yahonttwara anyakulhachaka yiiraka, “Mwaana a Adaudi, nnoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu akelheke mpaani ohoona elhi alhe nkayanrwelha, ni uyo nkaakoha, “Chani? Nnoorumelhelha wiira kinowooria uulhamihani?” Ni ayo nkayaamwaakhulha “Eiyo Thithi!” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Vavawo Yesu nkaakwakwanya miitho, nkeera “Ikhalheke thoko nrima inyu chinothanana aya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miitho aya nkayaapatakuwa. Yesu nkaamukacha wo uchacha eeraka, “Nhinhimerie ntu riyoothe ulha mwaha ulha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nansho yathamacheke nkayaavira awanelhihaka mwaha wo Yesu ilhapo yonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Attu vaarwacha aya umawannyaya, attu akina nkayanrwehelha Yesu ntu mmoka o uhulhumacha attukiye ni nshoka no unanara. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Wo uhipicha mashoka ayo yomolhachiyeke, ntu o uhulhumacha uyo nkaachokholha wulhumacha tho. Nlhoko wa attu nkawoomiya uwanoni nkayeera “Khaninapacha woona mwaha thoko yolha mu Israeli mu!” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nansho Amafarisayo nkayaahalha yiiraka, “Noomolha mashoka wo ikuru yo nholhelhi o mashoka o unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu aheetakachera iwani chonkhaye ni ittoko chaya ettuchihaka mu inupa chaya cho unlhapelha Nlhuku. Aari ettuchihaka Malhove Orera o Imwene ya Nlhuku, ni ulhamiha mareta onkhaye ni uhuperia wo kila iphiro. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Paahi ooneke attu milhoko wo milhoko, ahoonelha ikiriri ukhalhawaya yaari anoocheelhe chinene achariyaka ni nipampa thoko ikhondoro chihiri ni nshunga. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Vavawo nkeerelha owiittucha awe, “Nlhaalha uri mwinchi, nansho anamitheko ari vakani. ");
INSERT INTO mgh2016_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Paahi etu mwaalhapelheke Athithi, anene nlhaalha yaawiihe anamitheko o uwa ukhungurani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu aheehana owiittucha awe khumi ni elhi, nkhaavaha ikuru yo woomolha mashoka o unanara ni waalhamiha attu ikwerere ni mareta onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Machina aya akarumiya khumi ni elhi ayo phi alha, o upachera Nasimoni eehaniya Peturo ni ahima aya Naandorea, Nayakhobo ashaana a Nazebedayo, Nayohana nhima aya, ");
INSERT INTO mgh2016_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nafilipo, Nabatolomayo, Natomaso, Namatayo aalhiviha ikhodi, Nayakhobo ashaana a Naalufayo, ni Natadayo, ");
INSERT INTO mgh2016_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nasimoni o Ukaanani, ni Nayuda Isikariote anthuminhe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nkaaruma khumi ni elhi ayo ni waalhehera choo, “Nhirwee iwani cha attu ahiri Ayahudi, mena nhikelhe mmawani mwa Asamariya. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nansho, nrweeke wa attu o inupa yo Israeli apotenre thoko ikhondoro chihiri ni nshunga. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vanorwaa inyu mwettuchiheke wiira, ‘Umwene wo wiirimu uhatameria!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwaalhamiheke areta, mwaahihimusheke attu akhwilhee, mwaalhamiheke attu o makutulha, mwoomolheke mashoka. Nvahiye wo maphathi mwakumiheke wo maphathi. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nhikushe mmirupani mwinyu idhahabu mena nchurukhu mena nchurukhu wo shaba. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nhikushe nrupa wo uvekelhelha mphironi mena mwiinjiro wo nayelhi, mena iratu cho nayelhi mena ikopo. Ukhalhawaya namitheko hophwanelhiya malhivo. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Vanophiya inyu vawani ama ittoko iriyoothe, mwamwaavieke mommo ntu nottuna upocherani, mwakhalheke vavawo mpaka vanohalha inyu uthama vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vanokelha inyu mpaani mwa ntu mweereke ‘Mpuha ukhalhe ni inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yakhalhaka anenchi o yeyo inupa iyo anowupocherani mwaattiva, nhiyeke mpuha unolhapelha inyu ukhalhe ni ayo. Nansho yaahupocherekeni mwaattiva, paahi nhokolhosheke mpuha nnolhapelha inyu uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yakhalhaka inupa ama iwani khayopochenreni, paahi vanokhuma inyu yeyo inupa iyo au yeyo iwani iyo, ni ukukutta ntukurukhu nnyaani mwinyu ikhalheke phi iphiro yo waamuka. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kinouhimeriani wo ikekhiaye wiira, Nihuku no Uhukumulhiya attu nno, ilhapo cho Usodoma ni Ugomora chinowa chaavilhelha ntwarusho, upwaha yeyo iwani iyo! ");
INSERT INTO mgh2016_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mwiiweke! Vano mii, kinourumani mwaattiva thoko ikhondoro umiichini. Mpenyeke thoko inwaa, ni wiitimarikha thoko kaulha. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwiichiinanelheke ni attu, ukhalhawaya nnoowa mwaavariya ni urwehiya umilhatuni ni waatiya ikopo mmanupani mwaya mwo unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nnoowa mwaarweehiya wa attu antawara ni wo mamwene, mwahimiecheshe Malhove Orera uwannyaya ni wa attu ahiri Ayahudi wo nlhatu waka. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Paahi etu, vanohalha aya urwehani mwaattiva umilhatuni vawo, nhikelhiye nipampa chinohalha inyu wulhumacha ama nlhove naani ninohalha inyu uhimiacha, ikatema yaphiyaka, nnoowa uvahiya ittu yo uhimia. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ukhalhawaya malhove anohalha inyu wulhumacha ayo kahiwe awinyu, anowa ukhuma wa Iphumu ya Athithi inyu olhumachaka wo malhaku inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Attu anowa waathumiha achihimaya eeviye, ni manyanaangoro anowa waathumiha achishaana aya, ni ashaana anowa wapitikulhelha manyanaangoro ni weevakacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Attu onkhaye anowa uuvengani wo nlhatu wo nchina naka. Nansho nohalha uvilhelha mpaka nihuku no umalhelha phi uyo nohalha woopolhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Mwavengiyaka iwani imoka, nttawelheke iwani ikina. Ikekhia kinouhimeriani kannomalhiha nkwaha inyu iwani chonkhaye cho Uisraeli Mwaana a Ntu hinaphiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Khaawo owiittucha naapwaha owiittuchiha awe, mena karumiya nompwaha mwanene ntheko awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wo chiichammo ihothosha owiittucha ukhalha ni ikuru thoko owiittuchiha awe ni karumiya ukhalha thoko mwanene ntheko. Yakhalhaka aneehana anene imbumba ya Belzebuli, chani akina khaneehana wo machina o uhilhoka! ");
INSERT INTO mgh2016_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Wo chiichammo etu nhoove attu. Ittu ikhunelhiye inowa yaapatakulhiya, ni ittu ivithiye inowa uhumbukulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Chinouhimeriakani mwaattiva mwiipiphini, nhimiacheke voonene, nlhove niiwilhe inyu naapiyaka mmweeke mwaahimiacha nneemenlhe vanchaarani. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nhoove attu aneeva iruttu nansho ahooriaka wiiva nnepa, nansho mmwooveke Nlhuku, nooria wiiva chonkhaye iruttu vamoka ni nnepa umooroni Ujehannamu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Athooche elhi anothumihiya wo isenti imoka, nansho khaawo ata mmoka nomora vathi Athithi inyu wo uhichuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nansho uwaninyu mwaattiva, ata ikharari chinyu cho mmuruni chihaalhakelhiya chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nhoove etu, mwaattiva nri o ukhulhuvelhiya chinene waapwaha athooche enchi! ");
INSERT INTO mgh2016_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Attu onkhaye anorumelhelha vaattuni wiira phi awaka, ni mii chiicho kinoowa kaarumelhelha wa Athumwanaka arii wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nansho ntu riyoothe nohalha ukikhota vaattuni, ni mii kinowa kankhota wa Athumwanaka ari wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nhaanyihere wiira kiwiihilhe mpuha velhaponi. Mena, akiwanne mpuha, nansho uphanga. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kiwiihilhe umwalhaana ntu ni athumwanawe, mwalhi ni anumwanawe, mmokohi ni ahokohi awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","amalhaponi inyu anowa ukhalha phi attu o mmanupani mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ntu naattuna athumwanawe ama anumwanawe chinene ukhiphwaha mii, yoyo khamphwanelhiya ukhalha owiittucha aka, ni ntu naattuna achishaana awe ashilhophwana ni ashithiyana chinene ukiphwaha mii yoyo khaphwanelhiye ukhalha owiittucha aka. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ntu hinokusha nsalaaba awe ni ukittwara inyaa chaka khanooria ukhalha owiittucha aka. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ntu novarechesha ukumi awe unonkulhuphuwa, nansho ntu hinovarechesha ukumi awe wo nlhatu waka nowa upatta tho. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ntu riyoothe no upocherani mwaattiva nokipochera mii, ni uyo nokipochera mii naapochera akirumilhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ntu nompochera namilhohi a Nlhuku wo nlhatu no ukhalha namilhohi a Nlhuku, nowa upochera nttuvo no namilhohi. Ni ntu riyoothe nompochera ntu o nrima woombone wo nlhatu wo urera nrima, nowa upatta nttuvo no utawara. ");
INSERT INTO mgh2016_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kinouhimeriani wo ikekhiaye wiira, ntu riyoothe nohalha ummaha mmoka aya alha ashinkani alha nkawo wo maashi o uririya wo nlhatu wo ukhalha owiittucha aka, we ikeekhene khanowa aathuwiya nttuvo nawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu amalheke waalhehera owiittucha awe khumi ni elhi malhehero, ahothama vavawo nkaarwa uwiittuchihani ni uhimiacha Malhove Orera iwani cho vakhiviru. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nayohana Obatiiza veewilhe aya ujeerani mwaha wo chittu chinopangacha awe Kuristo, nkaaruma owiittucha aya wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nkayaarwaa unkohani yeeraka, “Nnihimerieke, ana inyuva phi ntu anhimmie aya Nayohana wiira haawo nowa, ama nimmweherereke ntu nkina?” ");
INSERT INTO mgh2016_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu nkaakhulha, “Nhokolhieke mwaahimerieke Nayohana chittu chiwilhe inyu ni woona, ");
INSERT INTO mgh2016_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","attu ohoona anowoona tho ni attu oheeta anoweeta ni attu o makutulha anoolhamihiya, attu ohiiwa anowiiwa, attu akhwilhe anoohihimushiya ni attu amashikini anoohimeriya Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ahoreeriya attu ahiri ni nipampa ni mii!” ");
INSERT INTO mgh2016_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ikatema owiittucha a Nayohana vaathamanche aya, Yesu ahochokholha waahimeria milhoko cha attu mwaha unaacha Nayohana eeraka, “Vaarwelhe inyu u Nayohana uthakoni ulhe mwaakhenlhe woonani? Chani mwaarweelhe woona nthalhe utikhinyiyaka ni iphioo? ");
INSERT INTO mgh2016_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mwaakenlhe woonani? Mwaakenlhe umwoona ntu warenlhe ikuwo cho uphwanelha? Attu anowara ikuwo cho uphwanelha anokhalha mmanupani mwa mamwene. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nkihimerieke mwaakenlhe woonani? Umwoona namilhohi? Eiyo, nansho nkamwoona chittu cho unthepa namilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Ukhalhawaya Nayohana phi ayo ahimiachiye ni Malhove Matakatifu, ‘Nlhuku heera, Kinonruma karumiya aka oholhelheni, akooroshe iphiro inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Wo ikekhiaye kinouhimeriani wiira Nayohana Obatiiza phi olhupalhe umpwaha ntu riyoothe aapantte uyaria. Nansho ulhe rii mwankani chinene mu Imwene yo wiirimu ulhe phi mulhupalhe waapwaha Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ukhuma ikatema Nayohana Obatiiza vaahimianche aya nttenga mpaka nna, Umwene wo wiirimu uri uttwaruwaka chinene, ni attu o machiri alhikachaka uthurulha wo machiri. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mpaka Nayohana vawiilhe aya, meettuchiho onkhaye a anamilhohi ni Malhehero a ashinna Musa inoolhumacha mwaha wo Umwene, ");
INSERT INTO mgh2016_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ni inyu mwarumelhelhaka nttenga aya, Nayohana phi Naeliya, aalhoheriye uwa waya. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ri ni maaru eeweke etu! ");
INSERT INTO mgh2016_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Paahi etu, kinohalha ulhikaaniha ni ittu yaani ilha iyari ya alha mahuku ilha? Attu aya ari thoko ashimirawo anokhalhacha mmapuwani nnopangiya maronda. Nkutiro mmoka waakhuwelhelhaka akhunanaya, ");
INSERT INTO mgh2016_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mwaatti nahowopelhani ikoma, nansho khamwenne! Naheepa ichipo cho nunlhiho nansho khamwonlhilhe!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nayohana vaawilhe aya, ahottuka mena khaawunrie idivai, ni mwaatti nkamweera, ‘Ri ni nshoka no unanara!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwaana a Ntu wiilhe awe, noolhia ni uwuria, mwaattiva nkamweera, ‘Mummweheke ulha ntu ulha! Ntu o umenyekha ni uhapalhiya, mpwana aya attu anolhiviha ikhodi ni attu o uwonya!’ Ata chiicho etu, irusho cha Nlhuku chinowonihiya wiira chiri choombone wo ulhikaana ni mitheko chaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu nkaachokholha waakuphulhacha attu o mmawani mwaapannge awe cho ushangiha nansho khayaarumelhenlhe ni ukhoroma uhiya uwonya waya. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nhothapana inyu attu o Ukorazini! Nhothapana inyu attu o Ubethsaida! Ukhalhawaya cho ushangiha chipangiye uwaninyu chikaapangiye Utiro ni Usidoni, attu o wowo yammwara majuniya ni wiihika ituura wooniha wiira ahokhoroma ni uhiya uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nansho kinouhimeriani wiira, inowa ukhalha ittu yo waalhuwa wo attu o Utiro ni attu o Usidoni uvilhelha ntwarusho uupwahani mwaattiva! ");
INSERT INTO mgh2016_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ni inyu Nakapenaumu! Chani nnothanana wiiwelhiha mwaanene wiirimu? Nnoowa mwaawulhusheriya unaminepa etu! Ukhalhawaya, ikaari cho ushangiha chipangiye uwaninyu chikaapangiye Usodoma, yeyo iwani iyo yanlhokelha mpaka nna. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nansho kinouhimeriani wiira, inowa ukhalha ittu yo waalhuwa wo attu o ilhapo yo Usodoma uvilhelha ntwarusho nawe uupwahani inyuva!” ");
INSERT INTO mgh2016_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yeyo ikatema iyo Yesu nkeera, “Thithi, Athithi o wiirimu ni o velhaponi! Kinoushukuruni ukhalhawaya nhaavitha attu o irusho ni attu anochuwelha alha malhove alha, nkamwaapatakulhelha attu ahiri ni irusho. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aye, Thithi, phinre aya wo uteelhani. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Athithi ahokivaha chittu chonkhaye. Khaawo ntu nonchuwelha Mwaana yaahikalhe Athithi, mena khaawo naachuwelha Athithi ahikhalhe Mwaana, ni attu athanlhiye ni Mwaana nkaapatakulhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mmweeke uwannyaka mwaattiva onkhaye, nnohuva ni ulhemelhiya misigo va, ni mii kinowiittuwihani. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mwiittukeke nikonkwa naka, nkusheke irusho uwannyaka, ukhalhawaya mii kiri ntu o maalha ni wiitimarikha munrimani, ni inyu nnowa mwaapatta nipuro no wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ukhalhawaya nikonkwa ninouvahakani mii niri no wolhwaa, ni nsigo kinouvahaakani khulhemenlhe uri pheruu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yeyo ikatema iyo, Yesu aari aviraka variyari imata cho ingaano Nihuku no Wiittuwa. Owiittucha awe aari anawolhiye ithalha, nkayontha machashi o ingaano ni ukhuura imbeyu chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Amafarisayo yooneke chiicho, nkayaamwirelha Yesu, “Mwooneke, owiittucha inyu anopanga ittu ichiichihiye ni Malhehero wiira ihipangiye Nihuku no Wiittuwa!” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu nkaakhulha, “Chani mwaatti khannashoma chaapannge aya Adaudi vamoka ni ashikhunanaya vaawolhiye aya ithalha? ");
INSERT INTO mgh2016_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ahokelha Inupa ya Nlhuku, anene vamoka ni ashikhunanaya nkayaalhia mikatte chaakumihiye isadaka wa Nlhuku, inakhalhaka yaari ahittwaraka Malhehero a ashinna Musa wo ulhia chechiyo mikatte chiyo. Ukhalhawaya opochera ishaani vekha aya phi ahaachiichihiya ulhia. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama chani, khanashoma nhina Malhehero wiira kila Nihuku no Wiittuwa attu opochera ishaani wi Inupa ya Nlhuku ari ahivaraka malhehero o Nihuku no Wiittuwa, nansho ahiirelhiyaka wiira ahotteka? ");
INSERT INTO mgh2016_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Paahi, kinouhimeriani vano wiira hawo vaa ntu ri mulhupalhe upwaha Inupa ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Malhove Matakatifu aneera, ‘Ikiriri phi nothanana aka ni mena kihiwe isadaka ya ashinama.’ Mwachuwelhaka maana aya, khannaahukumulha attu ahittekilhe, ");
INSERT INTO mgh2016_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ukhalhawaya Mwaana a Ntu phi Mwanene Nihuku no Wiittuwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ahothama vavawo nkaakelha mu inupa yo unlhapelha Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","mwaari awe ntu mmoka o moono wo uririyacha. Attu yaathanana umwootheria Yesu wiira hotteka, nkayankoha, “Chani, vahorera unlhamiha ntu Nihuku no Wiittuwa?” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu nkaakhulha, “Mpani munlhokoni mwinyu ikhondoro awe yawulhuwelhaka munlhikitini Nihuku no Wiittuwa, hinorwaa ni ukumiha munlhikitini mmo? ");
INSERT INTO mgh2016_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ntu phi ri o waalhakelhelhiya chinene upwaha ikhondoro! Paahi etu, khanichiichihiye umoopolha ntu Nihuku no Wiittuwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Amalheke nkaamwirelha ntu o moono wo uririyacha ulhe, “Wookolheke moono awo.” Nkookolha, ni uyo nkawaakhalha nkumi tho, thoko moono nkina uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Paahi etu Amafarisayo nkayaakhumacha vathe, nkayeewanana iphiro yo umwiiva Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nansho Yesu vaachuwenlhe awe nenno nlhove nno, nkaathama vavawo vakitu vawo, ni attu enchi nkayanttwara. Nkaalhamiha areta onkhaye ");
INSERT INTO mgh2016_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nkaalhehera wiira ahaahimerie attu akina yayo malhove ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Enre chiicho wiira malhove aahimiye ni Nlhuku wo iphiro ya anamilhohi ashinna Isaya atimire, ");
INSERT INTO mgh2016_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ulha phi namitheko aka kinthanlhe aka, Nonttuna aka, nokiteelhiha munrimani. Kinonruma Iphumu aka vachulhu vawe, Ni uyo nouhimeriani ihukumu aka wa ahiri Ayahudi onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Khanokhalha ni nikhanyerero mena khannyakulha, Mena nlhove nawe khaninewaniaa mmaphironi. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Khanontha nthalhe unyakathelhe, Mena khantiphiha utambi unottuwa mwiishi. Nolhokelha mpaka vanohalha awe uhimeriani ihukumu aka wa makosho onkhaye, ");
INSERT INTO mgh2016_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wo yoyo, makosho onkhaye anoowa aakhulhuvelha nchina nawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Vavawo attu nkayanrwehelha Yesu ntu mmoka o hoona ni uhulhumacha aattukiye ni nshoka no unanara. Yesu nkanlhamiha, nkoolhumacha ni woona. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nlhoko wa attu nkawoomiya uwanoni nkayeera, “Chani, nowooria ulha ukhalha mwaana a Adaudi?” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amafarisayo yeeweke ulha mwaha ulha, nkayeera, “Ulha ntu ulha noomolha mashoka wo ikuru yo Belzebuli, nholhelhi o mashoka o unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu nkaachuwelha choopuwelha aya munrimani, nkeerelha, “Imwene iriyoothe imianelhe milhoko miilhi chihineewanana, yeyo khinolhokelha. Ni iwani iriyoothe ama nikosho niriyoothe nimianne milhoko milhoko chihineewanana inowulhuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yakhalhaka umwene mmoka unaatakana ni umwene nkina wo machiri a Nakare, yoyo uhomalha umwalhaana unowulhuwa! ");
INSERT INTO mgh2016_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwaattiva nneera eti kinoomolha mashoka wo ikuru yo Belzebuli. Chani, owiittucha inyu etu anoomolha wo ikuru ya apani? Wo yoyo nlhatu uyo yayo phi nohalha uhukumulhani wiira nhotteka! ");
INSERT INTO mgh2016_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mena kahiwe Nakare, nansho Iphumu ya Nlhuku, phi nokivaha ikuru yo woomolha mashoka, uhimiechesha wiira, Umwene wa Nlhuku uhooweelhani mwaattiva. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Wo ikekhiaye, khaawo ntu nooria ukelha inupa ya ntu o machiri ni umwaakha nhakhu awe, mpaka anttukeke thoko ntu o machiri uyo, vavawo pinohalha awe wooria umwaakha nhakhu awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ntu riyothe hirii vamoka ni mii yoyo nookivinga, ntu hinokikaviha ukhungura yoyo noomwarusha. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ni mii kinouhimeriani wiira attu anoohiyereriya uwonya ni ulhava waya wonkhaye, nansho khanowa aahiyereriya nlhatu wo unruwana Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ntu riyoothe noolhumacha nlhove no unlhava Mwaana a Ntu nohiyereriya, nansho ntu noolhumacha nlhove no unlhava Iphumu ya Nlhuku, khanohiyeriya, mwiilhaponi mu, mena ilhapo inowa. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Wiira mpatte maphepu oombone nnothananiya waalha mwiri wookonda, mwiri waahikondeke, maphepu aya khanolhoka. Mwiri unochuwaniaa chineera aya wo wimma. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwaati iyari yo inwaa vaa nnohalha wooria chani uhimia malhove oombone uno nnari o uhilhoka? Ukhalhawaya malhaku a ntu anohimia chittu chiri munrimani. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ntu o nrima woombone noyara chittu choombone munhakhuni mwo chittu chawe choombone, ni ntu o uhilhoka noyara chittu cho uhilhoka munhakhuni mwawe mwo uhilhoka mmo. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Paahi, kinouhimeriani nchuwelhe wiira, Nihuku no Uhukumulhiya attu, kila ntu nowa aakhulha vachulhu wo kila nlhove no uhikhalha marumbo noolhumanche awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Malhove inyu phi nohalha uhukumulhani wiira nhotteka ama nhopanga moombone.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yamalheke, owiittuchiha Malhehero akina ni Amafarisayo nkayanlhelha Yesu, “Owiittuchiha, ninothanana woona mpangaka ithikineha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu nkaakhulha, “Mwinre chani attu o uhilhoka o ulhuva va! Nnovekelha woona cho ushangiha? Mena! Ithikineha inohalha inyu woonihiya iri ya anamilhohi Nayona vekha aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iphiro yaakhanlhe aya Nayona mahuku mararu uthana ni uhiyu mmirimani mwo nankumi, phi chiicho Mwaana a Ntu chinohalha awe ulhokelha unaminepa wuuthi ilhapo mahuku mararu uthana ni uhiyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nihuku no Uhukumulhiya attu, attu o Uninavi anowa weemelha ni uhimia milhatu chinyu, ukhalhawaya ahomalha ukhoroma ni uhiya uwonya veewilhe aya nttenga u Nayona, ni mii vano kinouhimeriani wiira hawo mulhupalhe vaa naapwaha Nayona! ");
INSERT INTO mgh2016_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nihuku no Uhukumulhiya attu nno, Ahano o Usheeba anowa weemelha ni uhimiacha milhatu chinyu, ukhalhawaya yayo aheeta ukhuma utayi, nkaawa wiiwelhelha malhove o irusho a Naselemani. Nansho kinouhimeriani wiira vaa hawo ri mulhupalhe waapwaha Naselemani! ");
INSERT INTO mgh2016_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nshoka no unanara vanoomolhiya aya mwiiruttuni mwa ntu, ninoovira naarukureriacha muuthakoni naaviaka vakittu vo wiittuwa. Naahooneke, ");
INSERT INTO mgh2016_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","vavawo phi neera aya, ‘Kinohokolhiaa unupani waka.’ Kuhokolhiaka ni uphwanya inupa mwaari, inakwechiye ni urerihiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Phi norwaa aya ni waakusha mashoka makina saba o uhilhoka upwaha uyo, nkayaawacha ni ukhalha mwiiruttuni mwa ntu uyo. Vanomalha aya, ukumi wa ntu uyo vano unokhalha wo unanara upwaha khalhayi. Phi chiicho chinohalha aya ukhalha wa attu o uhilhoka a alha mahuku alha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu aari olhumachaka ni nlhoko wa attu ikatema anumwane ni ashilhoko awe vaawilhe aya. Nkayeemelhacha vathe, athananaka umulhumana. ");
INSERT INTO mgh2016_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Paahi ntu mmoka nkaamwirelha, “Nkoonani, anumwaninyu ni ashihima inyu arii vathe vawo, anothanana uwoonani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nansho Yesu nkaakhulha, “Anumwanaka phi apani? Ashilhoko aka phi apani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Amalheke nkaathonya owiittucha awe, nkeera, “Mwooneke alha va! Alha phi manyaanumwanaka ni ashilhoko aka! ");
INSERT INTO mgh2016_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ukhalhawaya ntu riyoothe nopanga chinothanana aya Athithi ari wiirimu, yoyo phi nhima aka ni mwanrokoraka ni phi anumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nenno nihuku, Yesu ahothama yeyo inupa iyo, nkaarwa ni ukhalha vachereshere nttiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Milhoko cha attu chanrukurenrie chaari chinchi mpaka nkaawelha nkalhavani, nkaakhalha. Attu nkayeemelha vachengweni, vachereshere nttiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu nkaahimiacha chittu chinchi wo ulhikaanihacha. “Ahaawo ntu aarweelhe uumwaalhani nakhuwo. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Vaalha awe imbeyu mmatani, chahaawo chaamonre mphironi, ashanuni nkayaalhia. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chikina nkachaamora vamalhukuni vahirii ittaya yinchi. Nkaachamelha wo uhipicha ukhalhawaya ittaya yaari vakani. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nansho nchuwa vaapharenlhe aya nkachaavia, ukhalhawaya mithithaari chaya khachethipenlhe, chahonyalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeyu chikina chaakorenlhe vamiiwani, nkachonnuwa nkachaatiyelhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nansho imbeyu chikina chaamorenlhe vachaayirani, nkachaamelha rata, nkachemma, chikina inuku imia imoka, chikina makhumi sita ni chikina makhumi mararu. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Rii ni maaru eeweke!” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nkayaawa Owiittucha awe, nkayankoha, “Nlhatu waani no wulhumana attu wo malhikaaniho?” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu nkaakhulha, “Mwaattiva nhovaheriya uchuwelha chittu chivithiye cho Umwene wo wiirimu, nansho ayo khavaheriye. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ukhalhawaya ntu rina ittu nowunchereriya, ni ukhalhana chinchi, nansho ntu hirina ittu, ata ikani irinawe iyo ni iyo inookushiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nlhatu nowulhumacha wo malhikaaniho niri wiira, anooweha nansho khaanona, anowiwelhelha nansho khaneewa, mena khanochuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nihotimira vano nlhove ni anamilhohi ashinna Isaya, ‘Wo ikekhiaye alha attu alha wiiwa anowiiwa, nansho khanochuwelha inohimiya, Uweha anoweha, nansho khanoona, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ukhalhawaya irusho chaya chihophupuwalha, Ahotiyelha maaru aya, Ni utiyelhelha miitho aya. Ihikaari chiicho miitho aya yaanoona, Ni manyaru aya yaaneewa, Mirima chaya chanchuwelha, Ni ayo anokirukunuwelha mii, neera Nlhuku, Ni mii kaanalhamiha.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nansho nhoreeriya mwaatti! Ukhalhawaya miitho inyu anowoona ni maaru inyu anowiiwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ikekhia kinouhimeriani wiira, anamilhohi enchi ni attu enchi o nrima woombone yahothanana woona alha anoona inyu alha, ahoone, ni wiiwa alha nneewa inyu alha, ahiiwe. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Paahi mwiiweke, ni wiittucha malhikaaniho o ntu o waalha imbeyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Attu ariyoothe aneewa nlhove no Imwene ya Nlhuku nansho ahichuwelhaka, ari thoko imbeyu chaamorenlhe vaphironi. Nakare nowa ni uthesha imbeyu chaalhiye munrimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbeyu chaamonre vanagagani chinokhalha thoko attu vaneewa aya nttenga anopochera uno ateelhiyaka munrimani. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nansho nttenga khunolhokelha munrimani mwaya ukhalhawaya khachinkhalha ni mithithaari nhina mwaya. Uhuvihiya vanowa aya wo nlhatu no nttenga nno, anookhwa nrima wo uhipicha. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbeyu chaamonre vamiiwani chineemelhelha attu aneewa nttenga, nansho nipampa naacharaka ni nikakata no velhaponi nivaravaraka nttenga uyo, ni ayo khaneemma maphepu. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ni imbeyu chaalhiye vachaayirani chinene chineemelhelha attu aneewa nttenga ni uchuwelha chihimiye, khwimmaka rata maphepu, mmoka imia, nkina makhumi sita ni nkina makhumi mararu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nkaahimiachera nlhikaaniho nikina eeraka, “Umwene wo wiirimu uri thoko ntu aanlhe imbeyu choombone mmatani mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Uhiyu attu anarumpe, mmalhaponi nkaawa, nkaaphateelha mahichi mmeelheni nkaarwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Minyepu vonnuwa aya ni meelhe aphiyaka vanothaphuruwa aya, mahichi ni ayo phi nothaphuruwa aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Akarumiya o mwanene imata nkaawa ni umwiirelha mwanene imata, ‘Munna, kwaani khamwaanlhe imbeyu choombone umatani ulhe, vano mahichi alhe ankhuma vayi?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Anene imata phi naakhulha aya, ‘Amalhaponi phi phateelhe yayo mahichi ayo.’ Ni anamitheko ayo khunkohaka mwanene imata ‘Nnoona chani vano etu, nirweeke ngati naphelhacheke mahichi ayo?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mwanene imata khwaakulhaka tho. ‘Mena, nhirwee, ukhalhawaya mwarwaaka, nnokoophelha mahichi ni meelhe vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nhiyeke chonkhaye chunnuweke rata mpaka nlhaalha vanohalha aya waaya. Vavawo kinowa koohimierani wiira nrweeke mwaphelhacheke thoko mahichi ayo, mwattukacheke matita matita, ni upaha vamooroni. Mwamalhaka mwakhwacheke meelhe ayo ni uthokoreria nnikhupini.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu nkaalhamulhelha nlhikaaniho nikina, “Imwene yo Wiirimu iri thoko choo. Ntu ahaalha imbeyu yo iharadali umatani wawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeyu inene iyo iri yooyeva upwaha imbeyu chikina chonkhaye, nansho vanonnuwa aya unokhalha mwiri mulhupalhe chinene upwaha miri chikina. Khukhalhaka mwiri unothekiya iphuuru cha ashinuni o wiirimu mmarittani mwaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu nkaahimeria nlhikaaniho nikhwawe tho, “Imwene yo wiirimu iri thoko opani anowiaa ihengedure vakani ni uthuwaniha ni iphepa madebe melhi ni ntikha, nkayaarurummwa yonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ahaahimiachera attu yayo onkhaye ayo wo ulhikaanihacha, khoolhumanche nlhove wo uhikhalha ni malhikaaniho. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Eera chiicho wo utimiriha chaahimiye ni anamilhohi wiira, “Kinowulhumacha wo ulhikaaniha vanohalha aka wolhumana, Kinoowa kaapatakulha malhove ahinapacha aya wiiwa toka wuupiya ilhapo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu vaathamme awe ni ukelha mpaani, owiittucha awe nkayaawa ni umwiirelha, “Nkanihimerieni maana o nlhikaaniho no mahichi amenlhe umatani, phi ishiyani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu nkaakhulha, “Ntu aanlhe imbeyu choombone phi Mwaana a Ntu, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","imata phi ilhapo ilha, imbeyu choombone phi attu o Imwene, mahichi phi attu a Nakare, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ni amalhaponi anlhe mahichi phi Nakare. Nlhaalha phi umalha wo ilhapo, ni attu o khungura phi minepa o wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chenre aya wo uphelhiya mahichi ni upahiya vamooroni, phi nohalha aya ukhalha nihuku no umalha ilhapo, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwaana a Ntu nowa waaruma minepa o wiirimu awe avire aakhungura attu ukhuma Umweneni wawe, alhe onkhaye aattekihilhe attu ni ayo o uwonya, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ni waariha umooroni, unohalha aya wunlha ni ushilha miino. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Vavawo attu o rera nrima anowa waaria thoko nchuwa wi Umweneni wa Athithi. Mwiiweke, nri ni maaru!” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Umwene wo wiirimu uri thoko, ntu novitulha nhakhu waavithiye umatani. Nkaawuhelha, nkaahokolhia uwani nateelhiye urwaa uuthumihani kila ittu irinawe, ni uhokolhia urwaa uwoopolhani imata iyo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Tho, Umwene wo wiirimu uri thoko ntu naavia ilulu yo nhakhu, ");
INSERT INTO mgh2016_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","vanovitulha awe imoka yorera chinene, khurwaaka uuthumihani kila ittu irinawe, ni woopolha ilulu iyo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tho, Umwene wo wiirimu uri thoko attu o wiiva ihopa anriaa nttavi munttiyani ni uvara ihopa yo kila nikosho. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nttavi vanchara aya, khupurulhaka ni ukhalha nipuro vachereshere nttiya, athanlhe ihopa. Choombone chiyo kuhelhiyaka mmakayani, nansho cho uhilhokalhoka chiyo khurihiyaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Inohalha ukhalha thoko chommo nihuku noomalhelha ilhapo, minepa o wiirimu anowa aavira aakhunguraka attu o uhilhoka mwa attu o nrima woombone ");
INSERT INTO mgh2016_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ni waariha umooroni, unohalha aya wunlha ni ushilha miino.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu nkaakoha, “Chani nhochuwelha ulha mwaha ulha?” Nkayaakhulha, “Eiyo nihochuwelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Paahi etu nkeera, “Kila ntu owiittuchiha Malhehero neettucha ukhuma Imwene yo wiirimu nokhalha thoko ntu ri ni inupa nokumiha chittu cho naanano ni chittu cho khalhayi ukhuma munhakhuni mwawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu amalhiheke uhimia yayo malhikaaniho ayo, nkaathama vavawo ");
INSERT INTO mgh2016_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nkaahokolhia uwannyawe. Nkeettuchiha mu inupa cho unlhapelha Nlhuku, ni attu amwiiwa nkaashangacha. Nkayaakohanacha eeraka. “Ana yolha pantte vayi chechilha irusho chilha? Ni wooria upanga cho ushangiha chi? ");
INSERT INTO mgh2016_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ana yolha kahiwe phi ulhe mwaana a ntu nokoorosha milhako ni ihiche ulhe? Amariamu kahiwe phi anumwanawe, ni achihimawe kahiwe Nayakhobo ni Nayusufu ni Nasimoni ni Nayuda? ");
INSERT INTO mgh2016_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ashirokorawe onkhaye kahiwe phi alha anokhalha ni hii alha vaa?” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Paahi etu nkayankhotacha. Yesu nkeera, “Namilhohi nolhohiya wa amalhaponi, nansho uwannyawe wa ashilhoko awe nookhotiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wo nlhatu no ulhipa waya nrima, khaapannge yo ushangiha iriyoothe wowo. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yeyo ikatema iyo Naherode amwene, o Ugalilaya yaheewa mwaha wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nkayeerelha anamitheko aya eeraka, “Ulha ntu ulha phi Nayohana Obatiiza, hohihimmwa ukhuma nnookhwani, phi nlhatu no woona ikuru yo ushangiha inopanga ntheko mwiiruttuni mwawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Naherode phi alhehenre wiira Nayohana avariye ni uttukiya mittondoro ni urweehiya ujeerani, wo nlhatu ni Naherodiya, mahanu a Nafilipo, ahima aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nlhatu waari Nayohana waamuka Naherode wiira, “Khavanorera inyu waathelha Naherodiya ahanu a ahima inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naherode nkayaathanana weeva Nayohana, nansho yaari oovaka attu ukhalhawaya yaari achuwelhaka wiira Nayohana aari anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nihuku no wuupuwelhiya uyaria waya Naherode, mwalhi mwaana a Naherodiya aheena machoma rata vaalhetoni. Naherode nkayaateelhiya, ");
INSERT INTO mgh2016_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ata nkayanlhupelha eeraka, “Kinouvaha ittu iriyoothe inottuna awo uvekelha!” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ni mwalhi uyo wo uchopelhiya ni anumwanawe, nkaavekelha eeraka, “Kinothanana naanano vava muru u Nayohana Obatiiza uneeshiye mphacheni.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amwene Naherode nkayaakelhiya ihuzuni, nansho wo naapo naalhupenlhe aya vaattuni, nkayaalhehera wiira avahiye. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Paahi nkayanruma ntu arwee ujerani aahithe Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Muru nkawaawiihiya mphacheni, nkaavahiya mwalhi ulhe, ni uyo nkaarwehelha anumwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Owiittucha a Nayohana nkayaawa, nkayaakusha iruttu iyo, urwaa uwavithani, nkayaarwaa unhimeriani Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu eeweke mwaha u Nayohana, nkaathama vavawo vakittu vawo nkayaawelhacha nkalhavani, nkaarwa vakittu vo wiivitha yeekha awe. Attu yeeweke, nkayaathama mmawannyaya nkayanttwara wo mieto. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu akhuruweke nkalhavani, nkoona nlhoko mulhupalhe wa attu, nrima awe nkawaakelhiya ikiriri, nkaalhamiha areta mareta aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Vaari aya uchechilho, owiittucha awe nkayanrweelha ni umwiirelha, “Uheelha vano, ni va vakittu va vauthakoni. Paahi etu mwaalheheke attu wiira athamache ahokolhieke mmawani athumeke yolhia.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu nkaakhulha, “Khavanooria waahiya chiicho, mwaavaheke yolhia mwaattiva!” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ayo nkayamwaakhulha, “Khanirina yolhia, nirina mikatte mithanu ni ihopa pilhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu nkeera, “Nkiwiihereke vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nkaalhehera attu akhalhe vathi mmanyashini, nkaakusha mikatte mithanu chilhe ni ihopa pilhi chilhe, nkaaweha wiirimu, nkalhapelhelha ibarakha, nkaamianihacha nkaavaha owiittucha awe yaakawelhe attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Attu onkhaye nkayaalhia ni uwona. Yamalheke owiittucha nkayaakusha mikatte chaahanlhe, nkayaachariha makaya khumi ni melhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Attu yaalhilhie yaari manyaalhopwana maelufu nthanu, wo uhaalhakelha manyaathiyana ni ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu nkaakhanyereriha owiittucha awe awelhe nkalhavani aaholhelhe ukhopelhelhe nttiya, mwanene vaahiya awe ni waalheha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Amalheke waalheha attu, ahothama nkaawelha umwaakoni ulhapelhani. Yesu aari wowo yeekha awe mpaka uchechilho, ");
INSERT INTO mgh2016_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","yeyo ikatema iyo ikalhava ilhe yaari inaphiilhe variyari nttiya, nansho yaari ithemwihiyaka ni iphioo yaawuka yaakakhaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mapikoosha, Yesu nkaawa wa owiittucha awe eetaka vachulhu maashi. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Owiittucha awe vaamwonne aya eetaka vachulhu maashi nkayoova chinene, nkayeera, “Nshoka!” Nkayaakhuwelha yoovaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu nkoolhumacha eeraka, “Nvareke nrima! Phi mii. Nhoove” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Napeturo nkayaamwakhulha eeraka, “Thithi, akhalhaka phi inyuva we ikekhiaye, mwiireke etu ni mii keete vachulhu maashi kiwe varii inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu nkeera, “Mmweeke.” Paahi Napeturo nkayaakhuruwa nkalhavani, nkayeeta vachulhu maashi, arwaaka vaari awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nansho yooneke iphioo iwukaka, nkayoova, nkayaachokholha utitimira akhuwelhaka, “Thithi, nkoopolhe!” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu nkaavara moono nkeerelha, “Nrima wani mwankani nrina inyu! Woonaka nnowoova?” ");
INSERT INTO mgh2016_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yamalheke o yelhi nkayaawelha nkalhavani, ni iphioo nkayaatondova. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Owiittucha onkhaye yaari nkalhavani nkayanthimicha, eeraka, we ikekhiaye inyuva phi Mwaana a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nkayaalhapuwa nttiya nkayaaphiya Ugenesareti, ");
INSERT INTO mgh2016_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","attu nkayanchuwelha Yesu. Paahi nkayanrweehelha areta onkhaye yaari mmawani. ");
INSERT INTO mgh2016_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nkayanlhepelha aahiyere avare inakhalhaka nlhuto no ikuwo chawe, ni attu onkhaye yaavanre aholhamacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Amafarisayo akina ni owiittuchiha Malhehero yahonttwara Yesu ukhuma Uyerusalemu uwa unkohani, ");
INSERT INTO mgh2016_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nlhatu waani owiittucha inyu khantuna meettuchiho nipochenre ihu wa ashulhupalhe? Khanonyawa mathatha rata thoko chinolheheriya aya ahinaya ulhia yolhia!” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu nkaakhulha, “Wo nlhatu waani mwaatti khannottwara malheheriyo a Nlhuku, nansho nttwaraka meettuchiho inyu mwaashinene? ");
INSERT INTO mgh2016_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nlhuku heera wiira, ‘Mwaathimicheke athumwaninyu ni anumwaninyu, ni ntu riyoothe naaruwana athumwanawe ama anumwanawe, yoyo nambaya eeviye.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nansho mwaattiva nnettuchiha wiira ntu akhalhanaka ittu yo waavaha athumwanawe ama anumwanawe, nansho eeraka, ‘Ilha ittu ilha kihommaha isadaka Nlhuku,’ ");
INSERT INTO mgh2016_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","paahi, ahaalhohe tho athumwanawe! Chiichammo etu phi hinolhoha inyu malheheriyo a Nlhuku, nlhatu no uttwara meettuchiho inyu mwaanene. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwaattiva va, anafiki! Ashinna Isaya aholhohera rata o waachakani mwaatti! ");
INSERT INTO mgh2016_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nlhuku neera, Alha attu alha anokithimicha wo malhoveru, nansho munrimani mwaya arii utayi ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ukithimicha waya khunolhoka, Ukhalhawaya aneettuchiha malhove a attu, nansho anari malheheriyo aka!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu nkeehana nlhoko wa attu, nkeerelha, “Mwiiweke ni uchuwelha! ");
INSERT INTO mgh2016_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ittu inonhelha ntu nsheru kihiwe inokelha vamalhakuni, nansho chilhe chinokhuma mmwano phi chechiyo chinonnanariha ntu,” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yamalheke owiittucha nkayaawa, nkayeera, “Chani, nhochuwelha wiira Amafarisayo ahorushiya veewilhe aya malhove inyu?” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu nkaakhulha, “Kila ntepo uhaalhiye ni Athithi o wiirimu unoophelhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Nhoove yayo manyaattu ayo! Yayo phi aholhelhi o hoona, aaholhelhaka o hoona akhunanaya, onkhaye elhi ayo anootumbuchira munlhikitini.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Napeturo nkayeera, “Nkanilhamulhelheni nenno nlhikaaniho nno.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu nkeera, “Ata mwaattiva khannochuwelha mpaka nna? ");
INSERT INTO mgh2016_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Chani, khanchuwenlhe wiira ittu inokelha mmwano inokelha munthunkwani, kaanyuma khukumihiyaka urindini? ");
INSERT INTO mgh2016_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nansho chittu chinokhumelha uwano chinokhuma munrimani, ni chiyo phi nonnanariha ntu. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ukhalhawaya munrimani mwa ntu phi nokhuma malhove o uhilhoka, o wiiva, o ulhuva, o ulhavalhava, o wiiya, o woothacha ni o uruwana. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yayo phi no nnanariha ntu. Nansho ulhia yolhia wo uhinyawa mathatha thoko chineera inyu khunonnanariha ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nkaathama vavawo vakitu vawo nkaarwa uukhalhani ilhapo yaatamana ni iwani cho Utiro ni Usidoni. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Opani amoka Akananayo aakhalha yeyo ilhapo iyo ahonrweelha Yesu nkayaakhuwelha eeraka, “Mwaana a Adaudi, ukoonelhe ikiriri Thithi! Mwaamwanaka, mwalhi noohuvihiya ni mashoka o unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nansho Yesu khaakhunlhe nlhove. Paahi owiittucha awe yahonrwelha, nkayaamwirelha, “Mwaahiyeke arwee! Khannoona wiira anonittwarattwara ni uninyakulha!” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu nkaakhulha, “Kirumiye wa attu o inupa yo Israeli vekha aya, apotenre thoko ikhondoro chihiri ni nshunga.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Opani ayo nkayaawa, nkayaakhoroma, nkayeera, “Thithi nkoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu nkaakhulha, “Khavanorera waathurulha ashaana yolhia aya ni waawonyera ashipwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Opani ayo nkaayakhulha, “Eiyo Thithi, nansho ata ashipwa ayo anoorokottacha cholhia chinomoramora vamezani va apwiiya aya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Vavawo Yesu nkaakhulha, “Maanyi nrima inyu mulhupalhe! Paahi etu, mpangelhiyeke thoko chinothanana inyu.” Yeyo isaa, mwalhi aya uyo nkaalhama. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nkaathama vavawo nkaarwa uchereshere ibahari yo Ugalilaya. Nkaawelha mmwaakoni, nkaakhalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Attu enchi nkayammweelha, yaawihaka attu o heeta ni o uhiweha ni o remara ni o uhulhumacha ni attu akina enchi yaari areta, nkayeeshiya vamietoni va Yesu, nkaalhamihacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nlhoko wa attu nkawoomiya uwanoni chinene yooneke attu ohulhumacha yuulhumachaka, oremara alhamaka, oheeta yeetaka ni attu o hoona yoonaka, attu nkayanthimicha Nlhuku o Uisraeli. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu nkeehana owiittucha awe, nkeera, “Kinowoonelha ikiriri alha attu alha wo nlhatu no ukhalha ni mii wo mahuku mararu wo uhilhia. Ni mii khakinooria waahiya wo uhilhia, anookomwaacha mphironi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Owiittucha awe nkayankoha, “Ninohalha upatta vayi yolhia yo uwanelha attu enchi thoko alha?” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu nkaakoha, “Nrina mikatte nchani?” Nkayaamwakhulha, “Chiri mikatte saba ni achihopa vakani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Paahi, Yesu nkaalhehera wiira attu akhalhihiye vathi. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nkaawiaa mikatte chilhe ni achihopa alhe, nkanthimicha Nlhuku, nkaamianihacha, nkaavaha owiittucha, ni ayo nkayaakawelha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Attu onkhaye nkayaalhia, nkayaawonacha. Yamalheke owiittucha nkayaakusha mahalha aahanlhe, nkayaachariha makaya saba. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Attu yaalhilhie yaari manyaalhopwana maelufu ncheshe, wo uhaalhakelha manyopani ni ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Paahi Yesu nkaalheha attu, nkaathama nkaawelha nkalhavani, nkaarwa ilhapo yo Umagadani. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amafarisayo akina ni Amasadukayo nkayanrwelha Yesu, athananaka unlhikacha. Nkayanlhepelha oonihe cho ushangiha cho wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nansho Yesu nkaakhulha, “Vaneelha aya nchuwa mwaattiva nneera, ‘Uheelha rata, ukhalhawaya irimu ihokhwilha.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Vanosha nchuwa nneera, ‘Ipulha inoorupa lhelho, nlhatu no ukhwiilha irimu ni ipiphi.’ Nnohukumulha mahuku wo uweha irimu, nansho nkelhiyaka nipampa wo uhichuwelha ithikineha cha alha mahuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mwinre chani mwaatti o uhilhoka attu a alha mahuku o ulhuva va! Nnovekelha woona ithikineha? Ithikineha nnohalha inyu uvahiya phi i Nayona.” Paahi etu nkayaathamacha ni uhokolhia umawannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Owiittucha vaalhapuwilhe aya nthelha wo nayelhi wo nttiya, yaari analhiyanlhe ukusha mikatte. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu nkeerelha, “Nhiitialhe, mwiichinanelheke ni ihengedure ya Amafarisayo ni ya Amasadukayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nansho nkayaahalha akohanachaka ashineneru, “Ana, neera chiicho wo nlhatu no uhikusha mikatte?” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu ahochuwelha ittu yaanyihera aya, nkeera, “Inyu attu nrii ni nrima mwankani! Chani woonaka nnarerihelha mwaha wo ulhiyalha ukusha mikatte? ");
INSERT INTO mgh2016_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Chani khannachuwelha? Khannoopuwelha vaamianihilhe aka mikatte nthanu ni waalhiha attu maelufu nthanu? Makaya nchani yaacharihilhe inyu mahalhahalha o mikatte yaahalhenlhe? ");
INSERT INTO mgh2016_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chani khannopuwelha mwaha wo mikatte saba chaakawelhiye aya attu maelufu ncheshe chilhe, chani mwaarokontte makaya nchani o mahalhahalha? ");
INSERT INTO mgh2016_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Chani khannopuwelha wiira akahimmie ittu inaacha mikatte? Mwiichinanelheke meettuchiho o uhilhoka a Amafarisayo ni Amasadukayo!” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Vavawo owiittucha nkayaachuwelha wiira eerelha wiira eechinanelhe kuhii ni ihengedure yo ururumulha mikatte, nansho ni meettuchiho o uhilhoka a Amafarisayo ni Amasadukayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu nkaarwa ilhapo cho Ukaisariya Filipi, waakohilhe awe owiittucha awe, “Attu aneera Mwaana a Ntu phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nkayaamwaakulha, “Akina aneera Nayohana Obatiiza, akina aneera Naeliya, akina Nayeremiya ama namilhohi nkina.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu nkaakoha, “Ni mwaattiva chani, nneera mii phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nasimoni Peturo nkayaakulha, “Inyuva phi Kuristo Moopolhi, Mwaana a Nlhuku rii nkumi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu nkeera, “Nhoreeriya inyuva Nasimoni ashaana a Bariyona. Ukhalhawaya iruttu ni iphome khachipatakunlhe uwaninyu nna nlhove nna, yaahikalhe Athumwanaka arii wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni mii kinouhimeriani, inyuva Napeturo, inyuva phi mwalha, ni vachulhu ulha mwalha ulha kinootheka nlhoko wa attu anrumelhenlhe Kuristo, mena machiri o unaminepa khanowa ooriaka uphomolha. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kinowuvahani mittukulho cho Umwene wo wiirimu, chinohalha inyu uttuka velhaponi va chinoottukiya chiicho wiirimu, chinohalha inyu uttukulha velhaponi va, chinoottukulhiya chiicho wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu amalheke wulhumacha, nkaachiichiha owiittucha wiira ahinhimiachere ntu riyoothe wiira aari phi Kuristo Moopolhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uchokholhelha vavawo, Yesu nkaachokholha uhimiacha mwaari wo owiittucha awe wiira, “Ihokiphwanelha wiira kirwee Uyerusalemu kahuvihachiye chinene ni ashulhupalhe ni Opochera ishaani olhupalhe ni attu owiittuchiha Malhehero. Kinowiiviya, nansho nihuku no neraru kinowa kaahihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Vavawo Napeturo nkayankusha Yesu vachereshere, nkayaamwamuka, “Nlhuku khanooria wiira chiicho Thithi! Khavanooria!” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nansho Yesu nkaarukunuwa, nkeerelha Napeturo, “Uthame va uwe Nakare! Inyuva phi itiyelhelho uwannyaka, ukhalhawaya irusho chinyu khachinokhuma wa Nlhuku, chinokhuma wa ntuni.” ");
INSERT INTO mgh2016_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yamalheke, Yesu nkaahimeria owiittucha awe, “Ntu riyoothe nothanana ukittwara mii, eeruneke mwanene, akusheke nsalaaba awe, akittwareke. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ukhalhawaya, ntu nothanana woopolha ukumi awe mwanene, nowa upoteriha, nansho noriha ukumi awe wo nlhatu waka nowa upatta. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chani, ntu nolhoha upuha ittu yaani apattaka mpuha wonkhaye wo velhaponi va ni uno apoteriha ukumi awe? Khiiwo mena! Khiiwo nolhoha awe ukumiha wiira apatte ukumi awe tho. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ukhalhawaya, Mwaana a Ntu nolhoha uwa ni nthimicho wa Athumwanawe vamoka ni minepa cho wiirimu chawe, vavawo phi nohalha awe unlhiva kila ntu inomphwanelha wo ulhikaana ni mitheko chawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wo ikekhiaye kinouhimeriani wiira, ahawo akina va khanonlhawiha nookhwa ahinaya umwoona Mwaana a Ntu awaaka ni Umwene awe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yavireke mahuku sita, Yesu nkaakusha Napeturo ni Nayakhobo ni Nayohana nhima aya, nkaarwana vekha ayaru vachulhu mwaako wo urekama. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Vammweha aya, Yesu nkaarukunuwa ikhove, ikhove awe nkayaapharelha thoko nchuwa ni ikuwo chawe nkachaateelha ttuuu. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Owiittucha araru ayo nkayoona ashinna Musa ni Naeliya yaarerihaka ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Vavawo Napeturo nkaamwiirelha Yesu, “Thithi, ihorera hii ukhalha vaa! Mwathananaka kinookorosha mahema mararu, nimoka nawinyu, nimoka ni ashinna Musa nimoka ni Naeliya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Vaari awe olhumachaka chiicho, nihute nooteelha nkanaakhuneelha, ni nlhove nkaneewaniaa nnihuteni niiraka, “Ulha phi Mwaamwanaka kinonttuna aka, nookitelhiha nrima, mmwiiwelhelheke yoyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Owiittucha yeeweke chiicho nkayaawulhuwa makukhu, nkayoova chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu nkaarwelha, nkaavaracha. Nkeera, “Mwemelheke, nhoove!” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Vaawenhe aya uchulhu khayamwoonne ntu nkina, ahikhalhe Yesu vekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Paahi, vaakhuruwa aya umwaakoni, Yesu nkaamuka nkeerelha wiira, “Nhinhimiachere ntu ritoothe ulha mwaha upatakulhelhiye inyu ulha mpaka nihuku no uhihimmwa Mwaana a Ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yamalheke owiittucha nkayankoha Yesu, “Chani woonaka owiittuchiha Malhehero a ashinna Musa aneera wiira Naeliya phi nohalha uholhelha uwa?” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu nkaakhulha eeraka, “Wo ikekhiaye, Naeliya phi nohalha uholhelha uwa, uweeshani tayari chittu chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nansho kinouhimeriani wiira, Naeliya ahomalha uwa nansho attu khayaachuwenlhe, nkayaapangelha chaathananne aya. Mwaana a Ntu ni uyo noowa aahuvihiya chiichammo mmathathani mwaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Paahi etu owiittucha nkayaachuwelha wiira aari aahimeriaka mwaha unaacha Nayohana Obatiiza. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Vaahokolhelhe aya wa attu, ntu mmoka nkaawa wa Yesu, nkankhoromelha, ");
INSERT INTO mgh2016_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nkeera, “Thithi, mmwonelhe ikiriri mwaamwanaka! Nreta ichilhichilhi, noohuva chinene. Ikatema chinchi noowulhuwelha vamooroni ama mmaashini. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kahommwiiha wa owiittucha inyu, nansho khayonrie unlhamiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu nkaakhulha, “Mwaattiva attu o iyari ihiri ni nrima, ipotenre! Kinohalha ukhalha ni inyu mpaka iyaakhani? Kuuvilhelhekeni mpaka iyaakhani? Mummwiiheke mmirawo inyu uyo vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Paahi Yesu nkaachachera nshoka nno, nkanankhuma mwaana uyo, yeyo isaa nkaalhama. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Owiittucha nkayaawacha wa Yesu nkayankoha wo ntemera wiira, “Ana chani woonaka hii khanoonrie woomolha nshoka nne?” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu nkaakhulha eeraka, “Wo ikekhiaye kinouhimeriani wiira, mwakhalhaka ni nrima inakhalhaka vakani thoko imbeyu yo iharadali, nnowooria wiirelha ulha mwaako ulha, ‘Nthame vaa nrwee uwo!’ Ni uyo unoorwaa. Nnowooria upanga ittu iriyoothe!” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Mwoochenlhe wo nlhatu no ulhipa mirima chinyu. Nansho nshoka thoko nenno ninothamihiya wo iphiro yo unlhepelha Nlhuku uttuka ulhia.” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vaari awe akhalhaka ni owiittucha awe onkhaye Ugalilaya, Yesu aheerelhacha, “Mwaana a Ntu haatameria vo uhelhiya mmathathani mwa attu ");
INSERT INTO mgh2016_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anohalha umwiiva, nansho nihuku no neraru nowa aahihimushiya muukumini.” Owiittucha awe nkayaakelhiya ihuzuni chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ni owiittucha awe vaaphilhe aya Ukapenaumu, attu o ulhiviha ikhodi yo Inupa ya Nlhuku nkayaawa u Napeturo ni waakoha, “Owiittuchiha inyu anoolhiva ikhodi yo inupa ya Nlhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Napeturo nkayaakhulha, “Eiyo, anoolhiva.” Napeturo vaakenlhe aya mpaani, Yesu nkaaholhelha wulhumacha eeraka, “Nasimoni, nnoopuwelha chani? Apani amphwanelhiya ulhiva ikhodi wa mamwene o velhaponi va? Anenchi ama alheto?” ");
INSERT INTO mgh2016_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Napeturo nkayaakhulha eeraka, “Alheto phi nophwanelhiya.” Yesu nkaakhulha, “Aye, anenchi khanlhivihiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nansho wo wiira nihaahuvihe munrimani, nrweeke etu unttiyani mwariheke indoana mmenjeke, mwakusheke ihopa inohalha inyu uvara iyo, mwapatakulheke iyano aya nnokoophwanya nchurukhu unthosha ulhiva ikhodi yawaka ni yawinyu. Mwaavaheke wiira ninoolhiva ikhodi yo inupa ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yeyo ikatema iyo owiittucha nkayaawa wa Yesu, nkayankoha, “Phi mpani ri mulhupalhe chinene mu Imwene yo wiirimu?” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu nkaamwiihana mwanhima, nkaamwemesha variyari aya, ");
INSERT INTO mgh2016_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nkeera, “Kinouhimeriani ikekhiaye, mwaahirukunuweke ni ukhalha thoko achihima, khannowa mwaakelha wi Imwene yo wiirimu mena. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mulhupalhe nhina Imwene yo wiirimu, ri phi ntu neetimarikha thoko ulha mwanhima ulha. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ntu riyoothe nompochera mwanhima thoko ulha wo nchina naka, nokipochera mii.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ntu riyoothe nohalha unttekiha mmoka aya alha ashinkani anokirumelhelha alha, irii mbaya yoyo ntu uyo attukelhelhiye nshilho nulhupalhe nshikoni ni utitimerihiya ubaharini wo wiisha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ihothapana ilhapo wo nlhatu no ulhikachiya unaawulhusha attu mu uwonyani! Ulhikachiya thoko chiicho unoowa waakhumelhelha, nansho ahothapana attu anohalha upanga chiicho! ");
INSERT INTO mgh2016_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Yakhalhaka moono inyu ama mweto inyu uhoottekihakani, ntupulheke ni urihelha uwo shoro! Iri mbaya inyuva ukelha mu ukumini wo uhikhalha ni moono ama mweto, kuliko urihiya umooroni uhintiphia mahuku o uhimalha nnari ni miono miilhi ni mieto chinyu miilhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni niitho ninyu noottekihakani, nkhulheke nrihelheke utayi. Iri nambaya wo inyuva ukelha mu ukumini nnari ni niitho nimoka, kuliko utikhelhiya vamooroni Ujehannamu nnari ni miitho melhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mwiishungeke! Nhimpangelhe niphiondho mmoka aya ashinkani alha. Kinouhimeriani wiira minepa chaya cho wiirimu chiri muulhokelhani wo mahuku onkhaye wa Athumwanaka o wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Ukhalhawaya Mwaana a Ntu wiilhe woopolha attu apotenre. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nnoona chani, ntu akhalhaka ni ikhondoro imia imoka, yapoteraka imoka, nopangani? Noohiya chilhe makhumi tisa ni tisa umwaakoni, nkaarwa uuthothani ikhondoro imoka ipotenre. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Vanoona awe, we ikekhiaye vavawo phi nottapelhelha awe wo nlhatu no ikhondoro imoka iyo, ipwahaka chikhwawe makhumi tisa ni tisa chaahanlhe chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Phi chiichammo, Athumwanihu o wiirimu vahinotuna aya inakhalhaka mmoka aya alha ashinkani alha apotere.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Yakhalhaka munninyu hoottekelhani, nrweeke mwamwaamukeke. Nansho mwamwaamukeke nnari elhi vekha inyu. Owiiwaakani, nhompatta nhima inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nansho aahiwelhelheke, munkusheke ntu mmoka ama attu elhi mwaarwaneke, akhalhe phi attu o uhimiechesha nenno nlhove nno, thoko chinohimiya ni Malhove Matakatifu, attu elhi ama araru. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aahiwelhelheke yayo attu ayo, nhimiacheke wa attu anrumelhenlhe Kuristo. Aahiwelhelheke nlhoko wa attu anrumelhenlhe Kuristo, ooniyeke etu thoko attu ahinchuwenlhe Nlhuku ama attu anolhiviha ikhodi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Vavawo, kinouhimeriani wo ikekhiaye mwaatti wiira, chinohalha inyu uttuka velhaponi va, chinoottukiya chiicho wiirimu, ni chittu chinohalha inyu uttukulha velhaponi va, chinoottukulhiya chiicho wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tho kinouhimeriani wo ikekhiaye wiira, attu o irusho cho uchuwelha mu nlhokoni mwinyu yeewananaka velhaponi va nlhove niriyoothe no ulhepelha, Athumwanaka o wiirimu anoupangelhani nenno nlhove nno. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ukhalhawaya variwoothe wanthukumana aya attu elhi ama araru wo nchina naka, mii kirii vavawo vamoka ni ayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Napeturo nkayanttwara Yesu, nkankoha, “Eti Thithi, nhimaaka akittekelhaka, kinlhevelheke vachani? Mikwaha saba?” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu nkaakhulha, “Akineera vathanu ni velhi, nansho makhumi saba mikwaha saba. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ukhalhawaya Umwene wo wiirimu unolhikaana ni mwene mmoka aalhakenlhe uwehaweha maalhakelho a anamitheko aari nhina mamulaka awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Vaachokhonlhe awe, nkaawiheriya ntu mmoka aari ni nlhatu wo nchurukhu ishilingi maelufu khumi. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yoyo ntu uyo khaarina ittu iriyoothe yo ulhiva nlhatu awe, paahi eti anene ntheko ayo nkayaalhehera wiira athumihiye ipotta, ahanu awe, achishaana awe ni chittu chonkhaye chirinawe, alhive nlhatu. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Paahi yoyo karumiya uyo nkaakhoroma wa mwanene nhakhu uyo, nkeera, ‘Nkilhite, ni mii kinoulhivani nlhatu winyu!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mwanene ntheko uyo nkayaamwonelha ikiriri namitheko uyo, nkanhiyerera nlhatu wonkhaye, nkanhiya arweeke.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nansho namitheko uyo mwanene nkaathama, nkamphwanya mmoka a anamitheko akhunanawe aari ni nlhatu wo nchurukhu ishilingi imia imoka. Nkammara, nkaamwama ishiko eeraka, ‘Nkilhive nlhatu aka!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Karumiya nkhunanawe nkaakhoroma, nkammenda eeraka, ‘Nkilhite ni mii kinowulhivani.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nansho uyo khaattunne, nkanttuka ujeerani mpaka vaalhinve awe nlhatu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Paahi, anamitheko ashikhunanawe yooneke yayo yahochukulha chinene, nkayaarwaa uwaahimeriani amwene mwaha wonkhaye ukhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Vavawo anene ntheko nkayaamwiihana yoyo karumiya uyo, nkaamwirelha, ‘Uwe karumiya o uhilhoka chinene! Wahokilhepelha, ni mii nkakoohiyerera nlhatu wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nhothananiya umonelha ikiriri karumiya nkhunaninyu thoko mii chowonenlhe akani ikiriri.’” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Amwene nkayaarushiya chinene, nkantikhelha ujerani atwarushiye mpaka vanohalha awe ulhiva nlhatu wonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ni Athumwanaka arii wiirimu, anoupangelhani chiichammo yakhalhaka kila mmoka inyu khanohiyerera uwonya wa nhima awe wo nrima awe wonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu amalheke wulhumacha yayo malhove ayo, ahothama Ugalilaya, nkaarwa Uyudea, ukhopelhelhe mwoolhoko wo Uyorodani. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Attu enchi nkayanttwara, ni uyo nkaalhamiha wowo mareta aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amafarisayo akina nkayanttwara, nkayankoha wo unlhikacha, “Eti, inorera nlhopwana waahiya ahanu awe wo nlhatu uriyoothe?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu nkaakhulha, “Chani, khannashoma Malhove Matakatifu alhepiye wiira Nlhuku voopilhe awe ilhapo ahomuupa nlhopwana ni nthiyana? ");
INSERT INTO mgh2016_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nlhuku nkeera, ‘Wo yoyo nlhatu uyo etu nlhopwana nowaahiya athumwanawe ni anumwanawe, ni ulhutaana ni ahanu awe ni ukhalha iruttu imoka?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wo chiichammo etu, yayo kahena attu elhi tho, nansho iruttu imoka. Paahi, chilhutanihiye ni Nlhuku, ntu himwalhaanihe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amafarisayo nkayankoha yeeraka, “Nlhatu waani etu, ashinna Musa unilhehera wiira nthiyana avahiyeke italaka ni uhiiya?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu nkaakhulha, “Ashinna Musa ovahilheni nlhove no waahiya manyaahanu inyu wo nlhatu no ulhipa mirima winyu. Nansho khachaakhanlhe chiicho voopiye aya ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Paahi kinouhimeriani wiira, nlhopwana riyoothe nohalha waamwalhaana ahanu awe yaahikalhe wo nlhatu wo ulhavalhava, ni uyo nolhavalhava aathelhaka athiyana akina.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Owiittucha awe nkayaamwirelha, “Yakhalhaka mwaha wa nlhopwana ni nthiyana phiri aya chiicho, nambaya etu ukhalha wo uhithelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu nkeerelha, “Kaahiwe attu onkhaye anooria upochera meettuchiho thoko alha, yaahikalhe attu areeriye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ukhalhawaya chihawo milhatu chikina chinaapanga alhopwana ahithelhe, ukhalhawaya akina aayarelhe chiicho toka munthunkwani mwa anumwanaya, akina wo nlhatu nopangiya chiicho ni attu, ni attu akina athananne anene uhithelha wo nlhatu no Umwene wo wiirimu. Nolhoha wooria urumelhelha nna nlhove nna, akhalheke chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yamalheke attu nkayammwiihera Yesu ashaana ashinkani awe eeshera miono ni waalhapelhelha, nansho owiittucha nkayaachiichihacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu nkeera, “Mwaahiyeke ashaana awe uwannyaka, mena nhaachiichihe, ukhalhawaya Imwene yo wiirimu iri ya attu arii thoko alha ashaana alha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Paahi nkeesheracha miono, amalheke nkaathama vavawo. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ntu mmoka nkaawa wa Yesu, nkankoha, “Owiittuchiha, kipangeke ittu yaani yoombone ni mii kipatte ukumi wo uhimalha?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu nkaamwiirelha, “Woonaka nnokikoherera ittu yaani iri yorera? Orera ri mmoka tu. Mwathananaka ukelha mu ukumini, mmarechesheke malheheriyo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yoyo ntu uyo nkaakoha, “Malheheriyo ani?” Yesu nkeera, “Nhiive, Nhilhavelhave, Nhiiye, nhoothache, ");
INSERT INTO mgh2016_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mwaathimicheke athumwaninyu ni anumwaninyu, ni waattuna amwaatamana inyu thoko chineettuna inyu mwaanene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mmirawo uyo nkaamwirelha Yesu, “Yayo onkhaye ayo kihovarechesha, kipangeke ittu yaani vano yo uthepa vavawo?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu nkaamwirelha, “Mwathananaka ulhikaanelhiya nrweeke mwathumiheke nhakhu inyu wonkhaye, ni nchurukhu uyo mwaakawelheke attu ashikini, ni inyu nnowiicheshera nhakhu wiirimu, mwamalhihaka nkittwareke.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yoyo mmirawo uyo eeweke chiicho, nkaathama narushiye, ukhalhawaya aari ntu o nhakhu chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vavawo Yesu nkaahimeria owiittucha awe wiira, “Ikekhiaye kinouhimeriani, inowa urikarika chinene wo ntu o nhakhu ukelha wi Imwene yo wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kinouhimeriani tho, iri vo urikarika chinene wo ntu o nhakhu ukhelha Imwene ya Nlhuku, upwaha ingamiya uperetta niitho no ntotto no utottelha ikuwo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Owiittucha yeeweke chiicho nkayoomiya uwanoni chinene, nkayankoha Yesu, “Phi mpani etu, nohalha ulhama?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu nkaaweha, nkeera, “Vaattuni khavanooria nansho kuhiwe wa Nlhuku, ukhalhawaya wa Nlhuku chonkhaye chinowooriacha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yamalheke Napeturo nkayeera, “Ni hii nihohiya chonkhaye nihoottwarani inyuva, ninohalha upattani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu nkaahimeria wiira, “Kinouhimeriani ikekhiaye, Mwaana a Ntu vanohalha awe ukhalhelha ihiche awe yo nthimicho wi Ilhapo yo Naanano, mwaattiva khumi ni elhi nkittwarilhe, nnoowa mwaakhalha mu imwene yo utawara, mwaahukumulhaka makosho khumi ni melhi o Uisraeli. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ni kila ntu hiilhe inupa ama aahilhe ashihima awe, ama ashirokorawe, ama athumwanawe, ama anumwanawe, ama ashaana awe, ama imata chawe, wo nlhatu no nchina naka, nowa upochera wo mamia ni upwaha, ni upatta ukumi wo uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nansho attu enchi anoholhelha vano anowa ukhalha o umalhelha, ni attu ari utulhi anowa ukhalha o uholhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Umwene wo wiirimu unolhikaana ni ntu aari ni imata yo zabibu, aalhawenlhe wichishuru waavaha attu ntheko umatani wawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nkeewanana waalhiva thoko chaari aya chilhiviyaka, nchurukhu idinari imoka wo nihuku, nkaarweha u imata awe yo zabibu. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Vaari aya saa tatu wichishu, nkaarwa weehanani attu akina, nkoona attu ahirina ntheko aneemenlhe wo uhikhalha ni ntheko vanopangiya maronda, ");
INSERT INTO mgh2016_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","nkeerelhacha, ‘Nrweeke ni inyu mwaattiva mwavareke ntheko imata yo zabibu, ni mii kinoulhivani iri ye ikekhiaye.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Paahi nkayaarwaa. Saa sita uthana ni saa tisa nkeera chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ata vaari aya saa khumi ni moja uchechilho, nkaarwa tho, nkaaphwanya attu akina anemelhanche vasokoni vawo. ‘Paahi nkaakoha, woonaka nhowemelhacha vaa uthana wonkhaye ulha wo uhikhalha ntheko?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nkayamwaakulha, ‘Khaawo ntu nivanhe ntheko.’ Ni uyo nkeerelhacha nrwaacheke ni inyu mwaattiva mwavare ntheko imata yo zabibu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Weelhekeru, mwanene imata yo zabibu nkanlhehera ntu noshunga nhakhu awe, ‘Mweehane attu ammara ntheko umatani ayo, mwaalhiveke malhivo aya, mpacheraka waalhiva attu awilhee katashi, ni wamalhihera o upacha alhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Attu yaachokhonlhe ntheko saa khumi ni moja nkayaalhiviya nchurukhu idinari imoka kila mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Attu o upacha yaweeke, aari yaanyiheraka wiira anohalha ulhiviya waapwaha akina, nansho ata ni ayo yaavahiye kila mmoka idinari imoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nkayaakhelha nchurukhu aya, ni unchukulhachera mwanene ntheko. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nkayeera, ‘Attu avahiye ntheko katashi apannge ntheko wo isaa imoka tu, woonaka nnilhivilhe thoko yayo uno hii ninavilhenlhe ntheko woorika uthana wonkhaye niviaka nchuwa!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Vavawo mwanene ntheko nkaamwaakhulha mmoka aya, ‘Mpwana, akupangenlheni chittu cho uhilhoka. Chani, khanewananne ni mii malhivo o idinari imoka? ");
INSERT INTO mgh2016_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nkusheke iri yawinyu, nrweeke. Kihothanana ummaha ulha o umalhihera thoko nlhiviye inyu inyuva. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Chani kinopanga ittu yo uhilhoka upanga chiicho wo nhakhu aka, thoko chinothanana aka? Ama nnoona ihache wo nlhatu no ukhalha ni nrima worera?’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu nkaamalhiha wo wiira, “Chiicho, arii o umalhihera anowa ukhalha o upacha, ni o upacha anowa ukhalha o umalhihera.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu vaari awe awelhaka urwaa Uyerusalemu, ahaattukana owiittucha awe khumi ni elhi ni waarerihana wo ntemera mphironi. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nkeerelha, “Mwiiwelhelheke, vano ninokelha Uyerusalemu, wowo Mwaana a Ntu nokoohelhiya mmathathani mwa attu opochera ishaani olhupalhe ni owiittuchiha Malhehero a ashinna Musa. Ni ayo anonhukumulha wiira eeviye ");
INSERT INTO mgh2016_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ni uvahiya attu ahinchuwenlhe Nlhuku, ampangelhe ncheche ni umwaata ikopo ni unkhomelhelha vansalaabani, nansho nihuku no neraru noohihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vavawo anumwanaya ashaana a Nazebedayo yahonrwelha Yesu vamoka ni ashaana aya, nkaakhoroma vaari awe ni unlhepelha nlhove. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu nkaakoha “Nnothananani?” Nkayaakhulha, “Nlhupelheke wo uhimia wiira mu Imweneni winyu, alha ashaana aka elhi alha anowa ukhalha mmoka wiimonono winyu ni nkina uyo wiimushi winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu nkaakhulha, “Khanchuwenlhe ittu inolhepelha inyu, chani, nnowooria uwureria ikikombe yo ntwarusho inohalha aka uwureria mii?” Nkayaamwaakulha, “Eiyo ninowooria.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu nkaahimeria wiira, “Wo ikekhiaye nnowureria ikikombe aka, nansho akirina ikuru yo unthanlha nohalha ukhalha wiimonono ama wiimushi waka. Yayo mapuro ayo anohalha uvahiya attu eesheriye tayari ni Athumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Owiittucha akina khumi alhe yeeweke yoyo mwaha uyo, nkayaarushiya nkayaathunalhelha yayo ashilhoko elhi ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Paahi Yesu nkeehanacha, nkaahimeria wiira, “Nnoochuwelha wiira attu anaatawara attu ahinchuwenlhe Nlhuku, anaatawara attu wo machiri, ni nholhelhi aya aatawaraka attu aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nansho ihikalhe chiicho uwaninyu mwaattiva, namitheko nothanana ukhalha mulhupalhe munlhokoni mwinyu hothananiya ukhalha namitheko inyu, ");
INSERT INTO mgh2016_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ni ntu nothanana ukhalha o upacha nhina mwinyu hothananiya ukhalha ipotta inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wo yeyo iphiro iyo etu, Mwaana a Ntu khaawilhe awe aapangelhiya mitheko ni attu, nansho ukaviherani ni ukumiha ukumi awe ukhalha noopo wa attu akina.” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu vaathama awe iwani yo Uyeriko, nlhoko wa attu wahonttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Paahi ahokhalha attu ohoona elhi yaakhanlhe vachereshere iphiro, yeeweke wiira Yesu noovira vavawo, nkayaakhuwelha, “Thithi, Mwaana a Adaudi, unoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nlhoko wa attu nkawaachiichiha ni waamaalhiha. Nansho ayo nkayaathepa ukhuwelha, “Thithi Mwaana a Adaudi nnoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu nkeemelha nkeehana ni waakoha “Nnothanana kupangelhekeni ittu yaani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nkayaaamwakulha, “Thithi ninolhepelha miitho ihu apatakuwe!” ");
INSERT INTO mgh2016_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Paahi etu Yesu nkoona ikiriri, nkaatonya miitho aya, ni vavawo nkayoona tho, nkayanttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ni owiittucha awe vaatamenrie aya Uyerusalemu ahophiya Ubetifage waari mwaako wo Mizeituni. Wowo Yesu ahaaruma owiittucha awe elhi, ");
INSERT INTO mgh2016_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eerelhaka, “Nrweeke mpaka iwani iri miholho mwinyu ni wowo nnokoophwanya iphuta ihottukelhelhiya vamoka ni mwaamwanawe. Mwaathapulheke nkiwiihereke vaa. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ntu riyoothe okohakani ittu, mwamwiirelheke, ‘Athithi anonthanana,’ ni uyo nouhiyerani vavawo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nlhove nna naapangelhe atimire malhove aatangiye ni anamilhohi yeera, ");
INSERT INTO mgh2016_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwiirelheke iwani yo Usayuni, Mmweheke, mwene inyu noowa! O wiitimarikha nawenlhe iphuta Mwaaphuta, mwaana o phuta.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Chiicho etu, owiittucha nkayaarwaa nkayaapanga thoko Yesu chaalheherilhe awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","nkayammwiiha mwaaphuta uyo, nkayaathalhacha ikuwo chaya vachulhu wawe, ni Yesu nkaakhalha vachulhu vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nlhoko mulhupalhe wa attu nkawaathalhacha ikuwo chaya mphironi, ni attu akina nkayontha maphumbulhu o miri nkayaathalhacha mphironi. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Milhoko cha attu yaanholhenlhe ni alhe yanttwara yaari akhuwelhachaka yeeraka, “Hosana, Atotopelhiye Mwaana a Adaudi! Vahiye ibarakha, nowa wo nchina na Athithi! Athimichiye Nlhuku, wiirimu!” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu vaaphiya awe Uyerusalemu, iwani yonkhaye nkayaakhalha yakariyakari wo uhiiwananiya. Attu nkayaakoha, “Ulha phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nlhoko wa attu nkawaakhulha, “Ulha phi namilhohi Yesu o Unazareti yo Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu nkaakelha Inupa ya Nlhuku, nkoomolha vathe attu onkhaye yaathumiha ni uthuma chittu mommo. Nkaapitikulhacha imeza cha attu yaakakaniha nchurukhu ni ihiche cha attu yaathumiha ikhunda, ");
INSERT INTO mgh2016_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","nkeerelha, “Iholhepiya nhina Malhove Matakatifu wiira, Nlhuku heera, ‘Inupa aka inowa wiihaniya inupa yo ulhapelha.’ Nansho mwaattiva nhorukunusha ukhalha nikhuku no attu o uvara makhuche!” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Attu o hoona ni attu o heeta nkayanrweelha Yesu u Inupa ya Nlhuku, nkaalhamihacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Opochera ishaani olhupalhe ni attu owiittuchiha Malhehero a ashinna Musa nkayaarushiya wo woona cho ushangiha chaapannge awe ni ashinamwane yeepachaka u Inupa ya Nlhuku yiiraka, “Hosana, uthimichiye Mwaana a Adaudi!” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Paahi nkayankoha Yesu, “Chani, nnowiiwa chineera aya?” Yesu nkaakhulha, “Eiyo kinowiiwa. Chani khannashoma malhove alhepiye? ‘Wo malhaku a ashinamwane ni ashaana ashinkani unototopelhiya we ikekhiaye.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu nkaahiya, nkaakhuma vathe ni urwaa Ubethaniya nkaakhalha wowo. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu vaari awe ahokolhiaka vawani mapikoosha, aari nawolhiye ithalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nkoona mwiri wo ntiini vacheshere iphiro, nkaachushera, nansho khaapwannye ittu ihikhalhe mathaakhururu. Paahi, nkeerelha mwiri uyo, “Uhimme maphepu tho mahuku onkhaye!” Vavawo vavawo mwiri uyo nkawooma. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Owiittucha yooneke nkayoomiya uwanoni yiiraka, “Mwiri ulha wuumilhe chani, vavawo vavawo?” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu nkaakhulha, “Ikekhiaye kinouhimeriani, Mwakhalhaka ni nrima wo urumelhelha uhiri ni nipampa, nnowooria kuhena wo upangaru chiicho, nansho ata mweerelhaka ulha mwaako ulha, ‘Uthame weerihelhe ubaharini,’ chinopangia chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ni inyu mwakhalhaka ni nrima, chittu chiri choothe chinohalha inyu ulhepelha munlhapelhaka Nlhuku nnoovahiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu nkaakelha tho Inupa ya Nlhuku, ni uyo vaari awe eetuchihaka, attu opochera ishaani olhupalhe vamoka ni ashulhupalhe nkayankoha, “Nnopanga chechi chittu chi wo ikuru ya apani? Apani yuvanheni chechi ikuru chi?” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu nkaakhulha, “Ni mii kinoukohani nlhove nimoka, mwakaakhulhaka, ni mii kinouhimeriani kinopanga chechi chittu chi wo ikuru yaani. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Eti ikuru i Nayohana obatiiza yaakhumme uyi? Chani yaakumme wiirimu ama wa attu?” Nansho nkayaahalha olhumachaka ashineneru, “Nimwaakhulheke chani? Neeraka, ‘yaakhumme wiirimu, noonikoha, woonaka etu khamwaarumelhelha Nayohana ayo?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Vavawo neeraka, ‘yaakhumme wa attuni,’ ninowoova nlhoko wa attu ukhalhawaya attu onkhaye anorumelhelha wiira Nayohana anamilhohi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Paahi, nkayaamwaakhulha, “Khanichuwenlhe hii!” Ni uyo Yesu nkaakhulha “Ni mii akinouhimeriani kimpanga chechi chittu chi wo ikuru yaani. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwaattiva nnoona chani? Ahaawo ntu mmoka aari ni ashaana elhi. Nkaamwirelha mulhupalhe uyo, ‘Mwaamwanaka, lhelho urweeke wavare ntheko imata yo zabibu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mmirawo uyo nkaakhulha, ‘Akinottuna!’ Nansho vahipincheru nkaarukunusha nulhumo nawe, nkaarwa uvarani ntheko. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yayo athithi ayo nkaarwa wa o nayelhi uyo nkaamwirelha chiichammo, ni uyo nkaakhulha, ‘Eiyo thithi!’ Nansho khaarwelhe unthekoni. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chani vavawo etu, wa yayo elhi ayo, phuuyi aathiminche athumwane?” Nkayaamwaakhulha, “Ulhe mwaana mulhupalhe ulhe.” Paahi, Yesu nkaahimeria wiira, “Ikekhiaye kinouhimeriani, attu anolhiviha ikhodi ni attu o ishembwere anowa yaakelha mu Imwene ya Nlhuku oholhelhakani. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ukhalhawaya Nayohana obatiiza ahowa uwaninyu uwonihani iphiro yo ikekhia, nansho mwaattiva khamwaarumelhenlhe, nansho attu anolhiviha ikhodi ni attu o ishembwere yahaarumelhelha. Ata nnoonaka chi chonkhaye chi, mwaattiva khankhoromme ni urumelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu nkeera, “Mwiiwelhelheke nlhikaaniho nikina. Ntu mmoka mwanene imata aalhilhe izabibu, nkarukureriha ukucho, nkaathipa ilhushi yo waamelha idivai, nkaatheka ishanja mommo. Amalheke nkaashimiha anamalhima, nkeeta nkwaha ilhapo yo utayi. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ikatema yo nlhaalha yaphiyeke, nkaaruma anamitheko awe wa anamalhima alhe arwee apochere mahalha o nlhaalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nansho anamalhima alhe nkaayavara akarumiya ayo, nkayaamwata mmoka ni umwiiva nkina ni umwata malhuku nkina uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mwanene imata uyo nkaaruma tho anamitheko akina, enchi upwaha o upacha alhe, ni ayo nkayaapangelhiya thoko o upacha alhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wo umalhihera nkanruma mwaamwanaya aanyiheraka wiira, ‘Anonlhoha mwaamwanaka kinonttuna aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nansho anamalhima alhe yamwooneke mwaamwanaya uyo nkayeerelhana ashineneru, ‘Ulha vano phi mwaamwanaya anene imata nohalha ukhalha phi mwanene nhakhu. Haya nngwe nimwiiveke etu, nipatte hii nhakhu awe uyo!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Paahi etu, nkayammara, nkayankakhelha vachereshere imata yo zabibu nkayaamwiiva. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Vanova vavawo etu, mwanene imata yo zabibu uyo vanohalha awe uwa nohalha waapangelhani yayo anamalhima ayo?” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nkayaamwaakulha, “Noweeva yayo attu o uhilhoka ayo, ni imata yo zabibu iyo nowaashimiha attu akina anohalha ummaha mahalha nlhaalha vanohalha aya uphiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu nkeera, “Chani, khannashoma Malhove Matakatifu chinohimia aya? ‘Nlhuku nikhotiye ni atheki wiira khaninlhoka Nihokhalha vano nlhuku no nsingi no vakhoonani. Athithi phi pangilhe nenna nlhove nna, Ninno niri no ushangiha chinene uwanihu!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Wo chiichammo etu, kinouhimeriani wiira Umwene wa Nlhuku unookushiya ni uvahiya attu ahiri Ayahudi, anohalha wiima maphepu oombone.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Nohalha uwulhuwelha nenno nlhuku nno nowunthakiacha, ni nno nammulhuwelhaka ntu riyoothe, ninonhararia.” ");
INSERT INTO mgh2016_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Opochera ishaani olhupalhe ni Amafarisayo yeeweke yayo malhikaaniho ayo, nkayaachuwelha wiira aachiya ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wo chiichammo etu nkayaahalha yaaviaka iphiro yo unhelha mmachirini, nansho yaari yoovaka attu wo nlhatu no uchuwelhiya wiira Yesu aari namilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu nkoolhumacha tho nlhove no ulhikaaniha voolhumana awe attu eeraka, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Umwene wo wiirimu uholhikaana ni mwene anterekhenlhe mwaamwanawe ikaramu ya arusi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Paahi, nkaaruma anamitheko avire eehanaka attu yaalhalheiye wa arusini, nansho yayo attu yaalhalheiye ayo khaattunne uwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Nkaaruma tho anamitheko akina, eeraka, mwaahimerieke attu alhalheiye u arusini ayo wiira, Ikaramu ihaaya, madume ni ikhondoro chihohithiya, awaacheke u arusini vano.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Nansho attu yaalhalheiye ayo khayaalhohilhe, nkayaathepa uvaracha mitheko chaya. kila mmoka, nkaarwa waakelhenlhe awe, mmoka umatani wawe, nkina uthumihani maronda awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ni akina nkayaavara akarumiya ayo ni waapangelha chittu cho uhilhoka ni uweevakacha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Amwene ayo nkayaarushiya chinene, nkayaaruma manyaasikari aya arwee yeevakache yayo attu o niiviho ayo ni upaha mooro iwani chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Amalheke, nkeerelha akarumiya aya, ikaramu ya arusi ihaaya kataashiru, nansho alhalheiye ayo khawaachilhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Paahi etu, nrweeke etu mmaphironi, mwaalhalhieke attu ariyoothe anohalha inyu waaphwanya awaacheke u arusini. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Anamitheko alhe nkayaathama, nkayaarwaa mmaphironi waarumiye aya, nkayaawiihacha attu onkhaye, attu orera nrima ni attu o uhilhoka nrima, nkayaakhalhacha, inupa nkayaachara alheto too.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Amwene vaakenlhe aya uwaakohachani alheto, nkaamwona ntu mmoka ahawanre isaare ya arusi hokhalha mwommo. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amwene nkayankoha, ‘Mpwana ukenlhe chani mu ni uwe khurina isaare ya arusi?’ Nansho uyo nkaamalha yii. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Vavawo amwene nkeerelha anamitheko, ‘Munttukeke mieto ni miono munkakhelheke vathe wiipiphini. Wowo nokowunlha ni ukhuura miino.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu nkaamalhiha wo wiira, “Attu enchi aholhalheiya, nansho attu vakani phi thanlhiye.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Amafarisayo nkayaarwaacha, nkayeewanana iphiro inolhoha aya ummara Yesu wo malhove awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Paahi, nkayaaruma owiittucha aya vamoka ni attu anttwara nlhoko wa Naherode. Nkayankoha, “Owiittuchiha, wo ikekhiaye nihochuwelha wiira inyuva phi ntu omanya, ni wiira nnohimiacha Ikeekhene ya Nlhuku. Khannomwoova ntu riyoothe, ukhalhawaya ikuru ya ntu khava ittu uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Haya, etu nnihimerie chinoona inyu. Chani, vahorera waalhiva ikhodi Nakaisari ama khinorera?” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nansho Yesu ahochuwelha yoyo unafiki waya uyo, nkeerelha, mwaattiva anafiki, woonaka nnookilhikacha? ");
INSERT INTO mgh2016_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nkooniheke etu nchurukhu unlhivelhiya ikhodi uyo. Ni ayo nkayakumiha nikhobilhi nimoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Paahi, Yesu nkaakoha, “Ikhove ilha ni nchina nna na apani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nkayaamwaakulha, “Ya Nakaisari.” Vavawo Yesu nkeerelha, “Paahi, iri ya Amwene avahiyeke Amwene, ni ya Nlhuku avahiyeke Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yeeweke chiicho nkayoomiya uwanoni nkayanhiya nkayaarwaacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nenno nihuku nno, Amasadukayo akina aneera wiira attu akhwilhe kanohihimmwa nnookhwani nkaawacha wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nkayeera, “Owiittuchiha, ashinna Musa yenre ntu thenlhe akhwaaka wo uhahiya ashaana, nhimawe akelheke manupa annyarelheke ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Paahi, ahaawo attu saba. O upacha ahothelha nkaakhwa wo uhaahiya ashaana, nhima aya nkaakhelha manupa wa anankhwelhi ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nkayeera chiicho wo manyaattu o nayelhi, ni o neraru, mpaka o saba aamalhihera. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yamalheke onkhaye ukhwaacha, opani ayo ni ayo nkayaakhwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Vano etu, nihuku no uhihimushiya akhwilhe nno, anankhwelhi ayo anohalha ukhalha ahanu apani? Ukhalhawaya ahopacha uthelhiya ni attu onkhaye saba ayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu nkaakhulha, “Nhowonya mwaattiva ayi! Ukhalhawaya khanchuwenlhe Malhove Matakatifu mena ikuru cha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ukhalhawaya attu akhwilhe vanohalha aya uhihimushiya khanowa aathelha mena uthelhiya, anohalha ukhalha thoko minepa o wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nansho inaacha uhihimmwa wa attu akhwilhe, chani khannashoma mwaahimeriye inyu ni Nlhuku? Mwanene aheera, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mii phi Nlhuku a Aburahimu, Nlhuku a Naisaka ni Nlhuku a Nayakhobo!’ Paahi, yoyo kahiwe Nlhuku a attu akhwilhe, nansho Nlhuku a attu akumi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Attu yeeweke chiicho, nkayaashangihiya wo meettuchiho awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Amafarisayo yeeweke wiira Yesu hamaalhiha Amasadukayo, nkayathukumana vamoka, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","mmoka aya, ntu owiittuchiha Malhehero a ashinna Musa, nkankoha Yesu wo unlhikacha, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Owiittuchiha, nlheheriyo naani niri nulhupalhe nhina Malhehero a ashinna Musa?” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu nkaamwaakhulha, “ ‘Mwaattune Athithi Nlhuku inyu wo nrima inyu wonkhaye, ni wo nnepa inyu wonkhaye ni wo irusho chinyu chonkhaye.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nna phi nlheheriyo nulhupalhe ni phi no upacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","No nayelhi ninolhikaana ni nno, ‘Munttune nomwaatamana inyu thoko chinettuna inyu mwaanene.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malhehero a ashinna Musa onkhaye ni meettuchiho a anamilhohi anokhulhuvelha alha malheheriyo melhi alha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amafarisayo vaathukumanne aya vamoka, Yesu nkaakoha, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwaattiva nnochuwelha chani mwaha unomwaacha Kuristo Moopolhi? Chani, yoyo iyari ya apani?” Nkayaamwaakhulha, “Mwaana a Adaudi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu nkaakoha, “Paahi inooria chani wiira wo ikuru cho Iphumu ya Nlhuku Adaudi amwihane yoyo Thithi?” “Ukhalhawaya aheera, ");
INSERT INTO mgh2016_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Athithi aherelha Athumwanaka, Nkhalheke wiimonono waka, Mpaka vanohalha aka waathalha amalhaponi inyu wuuthi inyaa chinyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Paahi, yakhalhaka Adaudi ahomwiihana yoyo ‘Thithi’ inooriacha chani etu ukhalha mwaamwanaya?” ");
INSERT INTO mgh2016_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Khaariwo ntu riyoothe onrie umwaakhulha nlhove. Ni toka nenno nihuku nno khaawo ntu aalhikanche tho unkoha ittu. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Amalheke Yesu nkaahimeria nlhoko wa attu ni owiittucha awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Owiittuchiha Malhehero a ashinna Musa ni Amafarisayo ahanaa ikuru yo ulhamulha Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wo chiichammo etu, nvarechesheke ni uttwara nlhove niriyoothe ninohalha aya uwiirelhani, nansho nhithakihe chinopanga aya, ukhalhawaya khanopanga chineettuchiha aya. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Anoottuka misigo cho ulhemelha ni waathatha attu mmakhathani, nansho ashinene ahittunaka wookolha inakhalhaka nikokho wiira akushe chechiyo misigo chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yayo anopanga mitheko chaya chonkhaye wiira yooniye ni attu. Anowara itepe chilhepiye Malhehero a ashinna Musa mmiononi ni ukhanulha miono cho miinjiro chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anothananacha ukhalha mapuro o urera mwaattuni ni ihiche cho nthimicho mu inupa cho unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Anoteelhiya ukohachiya wo nthimicho vanopangiya maronda ni uchivelhiya wiihaniya ni attu, ‘Owiittuchiha.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nansho mwaattiva nhiteelhiye wiihaniya ‘Owiittuchiha,’ ukhalhawaya Owiittuchiha arii amoka tu, ni mwaattiva onkhaye nri attu o nlhoko mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mena nhimwiihane ntu riyoothe velhaponi va, ‘Thithi’ ukhalhawaya athumwaninyu ari amoka tu, arii wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mena nhiihaniye ‘Aholhelhi,’ ukhalhawaya nholhelhi inyu ri mmoka tu, phi Kuristo Moopolhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Rii mulhupalhe munlhokoni mwinyu yoyo akhalheke phi karumiya inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Neewelhiha nookurushiya, neekurusha noowelhihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nhothapana inyu owiittuchiha Malhehero a ashinna Musa ni inyu Amafarisayo! Mwa anafiki inyu! Nnootiyelhelha nlhako wo umwene wo wiirimu vamiithoni va attu. Mwaashinene nhikelhaka mpaani, mena khannaahulhelha attu anthanana ukelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nhothapana inyu owiittuchiha Malhehero a ashinna Musa ni Amafarisayo! Nneepanga o urera nrima! Nnoonelha anankhwelhi ni wi chootheriha ukhalha attu o nrima woombone wo ulhapelha wo malhove menchi. Wo yoyo nlhatu uyo etu nnoowa mwaatwarushiya wo uweria.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nhothapana inyu mwaatti o nkutiro wa owiittuchiha Malhehero a ashinna Musa ni Amafarisayo! Mwa anafiki! Nneetakacha ubaharini ni velhaponi mumpatte ntu o uttwara meettuchiho inyu. Vanompatta inyu, nnonttekiha velhi wiira atikhelhiye vamooroni Ujehannamu, o uhiyakani mwaashinene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nhothapana inyu aholhelhi ohoona! Mwaattiva nneera eti ntu alhupelhaka Inupa ya Nlhuku, naapo nawe khani ittu, nansho alhupelhaka wo idhahabu iri Nnupani mwa Nlhuku, naapo nno ninommara. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwaattiva ohoona o uphupuwalha! Ittuni iri yoombone chinene, idhahabu ama Inupa ya Nlhuku inohapiha idhahabu iyo? ");
INSERT INTO mgh2016_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tho nneettuchiha wiira, ‘Ntu alhupelhaka wo madhubahu, khava ittu, nansho alhupelhaka wo izawadi yeeshiye vamadhubahuni, nenno naapo nno ninommara.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwaattiva ohoona va! Ittu yaani iri yoombone chinene, izawadi ama madhubahu anohapiha izawadi ithimichiye iyo? ");
INSERT INTO mgh2016_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ntu nolhupelha vamadhubahuni holhupelha wo madhubahu ayo, ni wo ittu chonkhaye cheeshiye vachulhu waya, ");
INSERT INTO mgh2016_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ni ntu alhupelhaka wo ulhupelha Inupa ya Nlhuku, holhupelha wo yeyo Inupa ya Nlhuku iyo, ni wa Nlhuku, nokhalha nhina mwaya, ");
INSERT INTO mgh2016_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ni ntu alhupelhaka irimu, holhupelha varii ihiche yo Umwene ya Nlhuku ni wa Nlhuku nokhalha vachulhu waya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nhothapana, inyu owiittuchiha Malhehero a ashinna Musa ni Amafarisayo! Mwa anafiki! Nnaalhiviha attu isadaka yo nifungu no khumi, ata yo mathaakhuru o nihiriri noonukhelha, manjano ni ijira, uno nhiyaka chittu cho uchuwania cho Malhehero a ashinna Musa, ikiriri ni upisha nrima ni ukhulhuvelhiya. Kinouhimeriani wiira alha phi ayo mwaathananiye inyu uvarelhelha chinene, nhilhiyalhaka makina ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aholhelhi ohoona! Nnothamiha iphepelhe iri nhina cho uwuriya, nansho mmiriaka ingamiya!” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nhothapana inyu owiittuchiha Malhehero a ashinna Musa ni Amafarisayo va! Mwa anafiki! Nnohapiha ikahi ni inyipo wo vathe, nansho nnohiya nhina chinananre chittu cho nanrokotolhe ni chittu chipante inyu wo uhichooria winyu, wo waathurulha attu ni ilhema. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Afarisayo ohoona inyu! Nhapiheke ikahi nhina thoko ni vathe vawo vanoorera chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nhothapana inyu owiittuchiha Malhehero a ashinna Musa ni Amafarisayo! Mwa anafiki! Nri thoko mahiye ahikiye ishwaakara wo vathe yooniaka orera, nansho nhina anachanre makhuva a attu akhwilhe ni kila ittu iri yo unanara. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wo vathe mwaattiva nnoonia ni attu thoko attu o nrima woombone, nansho nhina anafiki ni o nrima wo uhilhoka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nhothapana mwaatti owiittuchiha Malhehero a ashinna Musa ni Amafarisayo! Mwa anafiki va! Nnothekelha mahiye a anamilhohi ni ushiringa mahiye a attu orera nrima. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwiiraka wiira yakaari mwahokhalha yeyo ikatema ya ashulhupalhe ihu iyo, khamwaakaviha chittu chenre aya, weevakacha anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chiichammo etu, nnowiihimiechesha wiira mwaattiva mwaashinene phi ashaana a attu yeevilhe anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Haya etu, mmalhihereke ntheko waachokholhiye ni ashulhupalhe inyu! ");
INSERT INTO mgh2016_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inyu nri inwaa ni iyari yo inwaa! Nnoorieke chani ushemba ihukumu yo mooro wo Ujehannamu? ");
INSERT INTO mgh2016_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Phi nlhatu etu, mii kinouwiherani mwaattiva anamilhohi ni attu o irusho ni owiittuchiha, mmwaaka mweevaka ni waakhomelhelhacha akina aya, ni waatakacha ikopo mu inupa chinyu cho unlhapelha Nlhuku ni waavia avia kila iwani. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Paahi etu, utwarushiya wo nlhatu no weeva attu o rera nrima vahirii nlhatu, unowupatani wo nlhatu no iphome aya. Eiyo, toka urihia wo iphome i Nahabilu ahaattenke, mpaka ya Nazakariya, mwaana a Abarakiya, mweevilhe inyu iriyari yo madhubahu u Inupa ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wo ikekhiaye kinouhimeriani tho wiira, utwarushiya waya alha attu o niiviho alha unoowa waawulhuwelhaka attu a alha mahuku alha! ");
INSERT INTO mgh2016_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Uyerusalemu! Uyerusalemu! Nneeva anamilhohi nnaata malhuku akarumiya arumiye ni Nlhuku uwaninyu! Vachani kilhikanche aka waathukumaniha ashaana inyu uwannyaka, thoko nankutu chinaathukumaniha awe achishaana awe mmapuphani mwawe, nansho khamwaattunne. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Haya etu, Inupa inyu ya Nlhuku inoohiiya mathalha. ");
INSERT INTO mgh2016_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kinouhimeriani uchokholha nna va wiira, khannokoona tho, mpaka ikatema vanohalha inyu wiira ‘Avahiye ibarakha uyo nowa wo nchina ni Athithi uyo.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ahokhuma Inupa ya Nlhuku, owiittucha awe vaawilhe aya nkayaamoniha manupa o Inupa ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu nkeerelha, “Eiyo, nnowoona alha manupa onkhaye alha! Ikekhia kinouhimeriani, khaninhalha ata nlhuku nimoka ninohalha uhalha vaa vachulhu nikina, kila nlhuku ninowa uwulhushiya vathi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu vaari awe nakhanlhe vachulhu Mwaako wo Mizeituni, owiittucha yahonttwara untemerani, nkayaamwirelha, “Nnihimerie yoyo mwaha uyo unohalha ukhumelhelha iyaakhani? Ni ithikineha chani chinohalha ukhumelhelha unichuwelhiha uwa winyu ni umalha wo ilhapo?” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu nkaakhulha, “Mwiishungeke nhiwe mwaathepiachiya ni ntu. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ukhalhawaya attu enchi anowa aakhumelhelha eeraka kila mmoka wiira phi Kuristo ni ayo anoowa yaapoteriha attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nnoowa mweewa mwaha ikhoto ni itetesi cho ikhoto, nansho nhihuvihachiye. Ukhalhawaya yayo ahothananiya ukhumelhelha, nansho umalha unene uhinaaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nikosho nimoka inoowa yaatakana ni nikosho nikina, umwene mmoka unowa waatakana ni umwene nkina. Ikuruna ni utetemelha wo ilhapo unoowa waakhumelhelha vawo ni valhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yayo onkhaye ayo ari thoko nkuri wo uweria wo wiittukulha mwaana.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Yamalhaka nnoowa mwaavariya mwapangelhiye ichimwa ni wiiviya. Makosho onkhaye anoowa aarushiya wo nlhatu wo nchina naka. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Attu enchi anoowa aahiya mirima chaya, anoowa aathumihana ni uvengana ashineneru. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anoowa aakhumelhelha anamilhohi o woothacha enchi anohalha waapoteriha attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Uhilhoka wa attu unoowa wunchereria, ni uttunana wa attu unowa uwolha. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nansho ntu riyoothe noohalha uvilhelha mpaka umalhelha yoyo phi nohalha woopolhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nansho umalhelha uhinaya uphiya, alha Malhove Orera o Umwene wa Nlhuku alha, anoowa aahimiachiya ilhapo yonkhaye wo uhimiechesha wo attu onkhaye, vavawo umalhelha wo makosho phi nohalha aya uwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nnoowa mwoona ‘Nrusho no utanganya’ naahimiye ni anamilhohi Nadanieli ninemenlhe vamapuroni vatakatifu, noshoma achuwelheke maana aya! ");
INSERT INTO mgh2016_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Vavawo, arii Uyudea attawelheke umiakoni. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ntu rii vanchaarani hikhuruwe vathi uukushani ittu mpaani mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ntu rii umatani hihokolhie uwani ukusha ikuwo awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ahothapana manyopani anohalha ukhalha ve iruttuni ni manyopani anaamwiha yayo mahuku ayo! ");
INSERT INTO mgh2016_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Munlhapelheke Nlhuku wiira uttawa winyu uhiwe nlhaalha wo uririya ama Nihuku no Wiittuwa! ");
INSERT INTO mgh2016_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ukhalhawaya uhuva wo yeyo ikatema iyo unolhoha ukhalha wulhupalhe uhinapacha woonia toka woopiya ilhapo mpaka lhelho nna. Mena kunowa waakhumelhelha tho. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nansho Nlhuku homalha uwukulha yayo mahuku ayo, ahakaawukulhiye, khaawo ntu riyoothe akoopolhiye. Nansho wo nlhatu ni attu athanlhiye etu, Nlhuku noowa aawukulha yayo mahuku ayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Paahi etu, ntu owirelhakani yayo mahuku ayo, ‘Kuristo rii vaa’ ama ‘rii valhe,’ nhinrumelhelhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ukhalhawaya anoowa aakhumelhelha ashi kuristo o woothacha ni anamilhohi o woothacha, anoowa upanga cho ushangiha chulhupalhe ni woopiha cho waarimelhiha ata attu athanlhiye ni Nlhuku, yooriachaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mwiiwelhelheke etu, mii kinowaamukani mahuku ahinaya uphiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Paahi etu yowiirelhakani, ‘Mummweheke, rii uthakoni!’ Nhirumelhelhe, ama yeeraka ‘Mmweheke, eevinthe vaa!’ Nhirumelhelhe mena. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ukhalhawaya Mwaana a Ntu nohalha uwa thoko chineera aya wo uverunya vanomwalhelha aya unosha nchuwa mpaka uneelha nchuwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Vari ntembo, phi vakittu vanothukumana marepo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wamalhakaru uhuva wo yayo mahuku ayo, nchuwa ninohelhiya ipiphi, mweeri khunowa waapharelha, ittotwa chinoomora wiirimu, ni machiri o wiirimu anoowa aatikhinyiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ithikineha yo Mwaana a Ntu inoowa woonia wiirimu, ni makosho onkhaye o velhaponi anoowa aachukulhacha vanohalha aya umwoona Mwaana a Ntu awaaka vachulhu mahute o wiirimu wo ikuru ni nthimicho mulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nrombe nulhupalhe no mapalhapata ninowa uruma, ni uyo noowa waaruma minepa o wiirimu awe avire mithelha micheshe cho iphioo, ni waathukumaniha attu athanlhiye ukhuma mithelha chonkhaye ncheshe cho ilhapo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mwiiittucheke etu malhikaaniho o mwiri wo nkhuyu. Maritta vanophuwa aya mathaakhuru, vavawo phi nochuwelha inyu wiira, ilhimwe ihaatameria. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chiichammo etu, mwaattiva vanohalha inyu woona alha onkhaye alha apangiaka, mmweeke mwaachuwelha wiira ikatema ihaaya, wa ayo ukhumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wo ikekhiaye muupuwelheke wiira ulha mwaha wonkhaye ulha, unohalha ukhumelhelha ilha iyari ilha ihinavira. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Irimu ni ilhapo chinoovira, nansho malhove aka khanovira mena.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Khaawo ntu chuwenlhe, nihuku mena ikatema, inolhoha uwa yaakhani, anakhalhaka minepa o wiirimu, mena Mwaana. Athithi vekha aya phi chuwenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Uwa wa Mwaana a Ntu unohalha ukhalha thoko chenre aya ikatema ya Anuhu. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mahuku igarika ihinaphiya, attu yaari alhiaka ni uwuria, athelhaka ni uthelhiya, mpaka nihuku Anuhu vaakenlhe aya ikalhava yuulhupalhe, isafina, ");
INSERT INTO mgh2016_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","attu khayaachuwenlhe irini mpaka maashi o igarika vaawilhe aya, nkayaakusha onkhaye. Chiicho phi nohalha aya ukhalha nihuku Mwaana a Ntu vanolhoha awe uwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yeyo ikatema iyo attu elhi anowa ukhalha umatani, mmoka noochishiya, ni nkina noohiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Manyopani elhi anowa ushilha vamoka, mmoka nowa ukushiya, nkina nowa uhiiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Paahi etu nshiheke, ukhalhawaya khanchuwenlhe nihuku no uhokolhia Athithi inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mwanene inupa akaachuwenlhe nihuku noowa attu owiiya, nchuwelheke wiira anshelhelhiha, mena kaahiya inupa awe iphomolhiye. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wo chiichammo etu, ni inyu mwaatti nkalheke tayari, ukhalhawaya Mwaana a Ntu nolhoha uwa ikatema ihinaanyihera inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Phi mpani etu, rii karumiya o ukhulhuvelhiya, o irusho? Ri ntu novahiya ntheko ni anene ntheko, wo weemelhelha akhunanawe ni waavaha cholhia ikatema yaayaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Horeeriya yoyo karumiya nohalha uphwanyiya ni mwanene ntheko apangaka ntheko awe rata vanohokolhia aya uwani! ");
INSERT INTO mgh2016_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kinouhimeriani wo ikekhiaye wiira, mwanene ntheko uyo nommaha yoyo karumiya uyo ntheko wo weemelhelha nhakhu awe wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nansho akhalhaka karumiya o uhikhulhuvelhiya, nowiichirelha munrimani mwawe wiira, anene ntheko kanohokolhia phiyaru, ");
INSERT INTO mgh2016_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nkaachokholha waatakacha anamitheko akhunanawe, nkaalhia cholhia chiyo vekha awe ni uwuria vamoka ni attu o uhapalhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nansho mwanene ntheko noohokolhia nihuku nihinoweherera awe ni isaa ihichuwenlhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Phi vavawo mwanene ntheko, vanowa awe untwarusha, ni umweesha nlhoko mmoka ni anafiki. Wowo phi nohalha aya ukhalha ikutto ni ushilha miino.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Yeyo ikatema iyo, Umwene wo wiirimu unowa ulhikaana ni mialhi khumi yaakunshe ikhandiri chaya, nkayaarwaa u wekamelhani abwana arusi. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Athanu aya yaari o uhikhalha ni irusho ni athanu yaari o irusho. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Athanu o uhikhalha ni irusho ayo yaakunshe akhandiri aya wo uhikusha makhura a akhiba, ");
INSERT INTO mgh2016_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","nansho o irusho ayo yahokusha makhura a akhiba nchuupani vamoka ni ikhandiri chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Abwana arusi nkaacherewa uwa, imialhi alhe onkhaye nkayaarupacha ikhove.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Uhiyu iriyari nkaneewiya nlhove nikhuwelhaka wiira, ‘Haya abwana arusi ahowa! Nrwee mweekamelhe!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Vavawo imialhi onkhaye nkayonkwacha, nkayaaparihelha ikhandiri chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Imialhi o uhikhalha ni irusho ayo nkayerelha imialhi o irusho alhe, ‘Nnivaheke makhura inyu vakani, ukhalhawaya ikhandiri chihu chihotiphiaa.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nansho o irusho alhe nkayaakhulha, ‘Khanthosha ari vakani, mbaya nrweeke unothumihiya aya mwathumeke mwaashinene!’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Paahi, imialhi o uhikhalha ni irusho alhe nkayaarwaa uuthumani makhura, vaarwaa aya, abwana arusi nkayaawa. Imialhi yaari tayari alhe, nkayaakelha mpaani vamoka ni ayo, inupa ya arusi, nkhora nkawaatteiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Vahipinche imialhi akina ayo nkayaahokolhia, nkayeehana, ‘Pwiiya, abwana arusi, pwiiya abwana arusi! Nnihulhelhe!’” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nansho abwana arusi ayo nkayaakhulha, ‘Kinouhimeriani ikekhiaye, akuuchuwenlheni mwaattiva.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yamalheke Yesu nkeera, “Nshelhelhiheke etu, ukhalhawaya khanchuwenlhe nihuku mena ikatema.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yeyo ikatema iyo Umwene wo wiirimu unowa ukhalha thoko ntu mmoka aathananne urwaa nkwaha wo utayi, nkeehana anamitheko awe, nkaaruma ntheko wo weemelhelha nhakhu awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nkammaha kila mmoka ntheko wo ulhikaana chinooria awe, mmoka nhakhu ichipande cho italanta nthanu ni nkina italanta pilhi ni nkina italanta imoka thoko chooria awe. Amalheke nkaarwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Karumiya aavahiye nhakhu italanta nthanu nkaapanga maronda nkaapatta italanta chikina nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ni chiichammo ntu aavahiye nhakhu italanta pilhi nkaapatta italanta chikina pilhi. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nansho ntu aavahiye italanta imoka nkaarwa uuthipelhani vathi, nkaavitha nhakhu wa mwanene uyo.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Yavireke mahuku menchi, mwanene ntheko ulhe nkaahokolhia, nkaachokholha waalhakelha nhakhu awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Karumiya aavahiye nhakhu italanta nthanu nkaawa ni italanta nthanu chikina. Nkeera, ‘Pwiiya mwaakivanhe italanta nthanu. Mwooneke etu, kihopatta italanta nthanu chikina.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mwanene ntheko nkeera, ‘Morera, anamitheko oombone ni o ukhulhuvelhiya! Nhokhulhuvelhiya wo nhakhu vakani, vano etu kinouhiyerani ntheko mulhupalhe. Mmweeke etu niwe naapuha vamoka ni mii!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Karumiya aavahiye nhakhu italanta pilhi nkaawa, nkaakumiha italanta pilhi chikina chaayarinhe awe nkeera, ‘Pwiiya mwaakivanhe italanta pilhi. Mwooneke etu italanta chikina chipantte aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mwanene ntheko nkaamwirelha, ‘Morera, anamitheko oombone ni o ukhulhuvelhiya. Nhokhalha o ukhulhuvelhiya wo nhakhu vakani, vano kinouhiyerani ntheko mulhupalhe. Mmweeke etu, mmwe mwaapuha vamoka ni mii.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nansho namitheko aavahiye italanta imoka nkaawa, nkeera, ‘Pwiiya, kihochuwelha wiira inyuva nri attu orikarika, inyuva nnokhungura vahaanlhe inyu, ni ukukhulhulha vahaamwanche inyu. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kahoova, nkakaavitha nhakhu inyu vathi. Mmwieke etu nhakhu inyu!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mwanene ntheko nkaamwirelha, ‘Uweva uri karumiya o uhilhoka ni uhuva! Uhochuwelha wiira mii kinokhungura vakittu vahaanlhe aka, ni ukukhulhulha vahimwanche aka. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Paahi etu, waaphwanelhiye weesha nchurukhu aka unoshungiya nchurukhu, ni mii kaanopatta nchurukhu aka ni ifaida aya! ");
INSERT INTO mgh2016_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vano etu munthurulheke nchurukhu uyo, nkusheke nrweeke mwammaheke ulhe rina italanta khumi ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ukhalhawaya, ntu ri ni ittu noovahiya ni wunchereriya. Nansho ntu hirina ittu, hata ikani irinawe iyo inookushiya. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nansho ulha karumiya o uhikhulhuvelhiya ulha, akakhelhiyeke vathe wiipiphini uwo! Wowo phi unohalha ukhalha ikutto ni ushilha miino.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ikatema Mwaana a Ntu vanohalha awe uwa nari Mwene vamoka ni minepa o wiirimu atakatifu onkhaye, vavawo nowa aakhalha vahicheni vawe vo nthimicho, ");
INSERT INTO mgh2016_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ni attu o makosho onkhaye anowa uthukumana vari awe, ni uyo nowa waanyulhacha attu milhoko miilhi, thoko nshunga vanaanyulhacha awe ikhondoro ni ipuri. Ikhondoro mpatta mmoka wo wiimonono ni ipuri mpatta wo wiimushi. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Noowa weesha attu anrumelhenlhe wiimonono wawe ni attu akina ahinrumelhenlhe wiimushi wawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Yamalhaka Amwene anowa weerelha alhe arii mpatta wawe wo wiimonono, ‘Mmweeke mwaattiva nvahiye ibarakha ni Athithi! Mmweeke mwaapochera umwene mwesheriye inyu toka voopiye aya ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ulhalhawaya kahowolhiya ithalha ni inyu nkamwaakivaha yolhia, kahowolhiya nttona ni inyu mwaattiva mwahokivaha maashi, kaari nlheto ni mwaattiva nkamwaakipochera, ");
INSERT INTO mgh2016_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","akawanre, nkamwaakiwariha, kaari ki nreta ni inyu nkamwaawa uukonani, kaari muuttukiyani ni inyu mwaattiva nkamwaawa ukishukuriani.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Vavawo, attu orera nrima anowa waakhulha Amwene, ‘Thithi, yaakhani nowonneni nnawolhiye ithalha ni hii nkanoovahani yolhia, ama nnari ni nttona ni hii nkanowurihani maashi? ");
INSERT INTO mgh2016_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ni yaakhani mwaari inyu alheto ni hii nkanoopocherani, ama mwaari wo uhikhalha ni ikuwo ni hii nkanoowarihani? ");
INSERT INTO mgh2016_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ama yaakhani nowonneni nnari areta ama nnattukiye ni hii nkanaawa uwoonani?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Amwene anoowa waakhulha, ‘Ikekhia kinouhimeriani, kila ittu champangenlhe inyu mmoka aya ashilhoko aka akani aakirumelhenlhe alha, mwaakipangenlhe mii!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Amalhaka anowa weerelha attu arii mpatta waya wo wiimushi, ‘Nthamache vari aka inyu mwaatti nlhaviye ni Nlhuku va! Nrwaacheke uri mooro wo hitiphiaa mahuku o uhimalha wesheriye Nakare ni minepa chawe! ");
INSERT INTO mgh2016_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ukhalhawaya kahowolhiya ithalha ni mwaattiva khamwakivanhe yolhia ni kaari ni nttona mwaattiva khamwakivanhe maashi. ");
INSERT INTO mgh2016_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kaari nlheto mwaattiva khamwakipochenre ni kaari nreta ni ntu o ttukiye mwaattiva khamwaawilhe uukiwehani.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Vavawo attu ayo anowa ukoha, ‘Thithi, yaakhani nowonilhe inyu nnawolhiye ithalha ama nttona, nnari nlheto ama wo uhikhalha ni ikuwo, nnari areta, ni hii khanokavihenreni?’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Amwene anowa waakhulha, ‘Kinouhimeriani ikekhia, kila vaakhonte inyu umpangelha ittu yoombone mmoka aya alha ashinkani alha, mwaakhonte ukipangelha mii.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Paahi, alha attu alha anowa urweehiya urii ntwarusho no uhimalha, nansho attu orera nrima alhe anowa urweehiya urii ukumi wo uhimalha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu amalhiheke wiittuchiha yayo meettuchiho onkhaye ayo, nkaahimeria owiittucha awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nhochuwelha wiira mahuku melhi anowa, phi nihuku no Pasaka, ni Mwaana a Ntu nookumihiya akhomelhelhiye munsalaabani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yeyo ikatema iyo opochera ishaani olhupalhe ni ashulhupalhe ahokumaana vamoka upuwani u Nakayafa, opochera ishaani olhupalhe, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","nkayeewanana miruku cho unhelha Yesu mmachirini wo umwoonelha, amwiive. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nansho ewananne wiira, “Nihipange nenna nlhove nna ikatema yo Pasaka, ihiwe ikhumelhelhaka injoove mwaattuni.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu vaari awe Ubethaniya, uwani u Nasimoni, ntu o makutulha, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","opani amoka aawelhe ichupa yo malhuku o alabasta yo makhura o unukhelha o nchurukhu mwinchi, nkayaawa wa Yesu vamezani vaakhalha awe ulhia yolhia. Nkaamminelha makhura ayo mmuruni. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Owiittucha awe nkoona yeyo nkayaarushiya. Nkayaakoha, “Yeeshiyani urihakacha alha makhura alha? ");
INSERT INTO mgh2016_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Makhura thoko alha anthumihiya wo nchurukhu mwinchi, ni nchurukhu uyo waanooria uvahiya attu amashikini.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu ahochuwelha chaanyihera aya, nkaahimeria, “Woonaka nnowahuviha alha opani alha? Yayo ahokipangelha ittu yoombone. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Attu ahirina ittu ari mahuku onkhaye vamoka ni inyu, nansho mii akinkhalha vamoka ni inyu mahuku onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Alha opani alha ahokimiinelha makhura o unukhelha wo weesha iruttu aka tayari wo nihuku no uvithiya waka. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Vano etu, kinouhimeriani ikekhiaye wiira, vakittu variwoothe velhaponi va vanohalha uhimiachiya alha Malhove Orera alha, mwaha upangilhe aya alha opani alha, unowa uhimiachiya wo wuupuwelhiya waya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yamalheke Nayuda Isikariote, mmoka aya owiittucha khumi ni elhi, nkarwa wa attu opochera ishaani olhupalhe, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nkeerelha, “Nnohalha ukivaha ittu yaani kanthumihaka Yesu uwaninyu?” Nkayaamwalhakelha nchurukhu makhobilhi makhumi mararu. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ni toka yeyo ikatema iyo Nayuda nkaavia nipesha no unthumiha Yesu wa attu opochera isadaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nihuku naaholhelha nihuku no Pasaka, nihuku no mikatte cho uhihelhiya ihengedure, owiittucha yahonttwara Yesu nkayankoha, “Nnothanana nooterekhelhekeni vayi yolhia yo Pasaka?” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu nkaakhulha, “Nrweeke wa ntu mmoka urii iwani mwanhimerieke, ‘Owiittuchiha aneera, ikatema aka ihophiya, mii ni owiittucha aka ninowa unlhelhia Pasaka uwaninyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Owiittucha nkayeera thoko Yesu chaalhehenre awe nkayaakoorosha yolhia yo Pasaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Uchechilho, Yesu nkaakhalha vamezani vamoka ni owiittucha awe khumi ni elhi, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Vaari aya alhiaka, Yesu nkeera, “Kinouhimeriani ikekhia wiira, mmoka inyu nookithumiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Owiittucha nkayaachukulha chinene, nkayankohacha mmoka mmoka, “Thithi! Chani phi mii?” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu nkaakhulha, “Ntu nopapha nkatte vamoka ni mii nnyiponi phi yoyo nohalha ukithumiha. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwaana a Ntu noorwaa unkelha awe thoko Malhove Matakatifu chinohimia aya, nansho hothapana ntu ulhe nolhoha unthumiha Mwaana a Ntu! Ikaari mbaya wa yoyo ntu uyo ahikaayarelhe!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nayuda, aari phi ayo yaathanana unthumiha, nkayankoha, “Owiittuchiha! Chani, phi mii?” Yesu nkaakhulha, “Inyuva mwaanene nheeromolha.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Vaari aya alhiachaka, Yesu nkaakusha nkatte, nkaalhapelhelha wa Nlhuku, nkaamia, nkaavahacha owiittucha awe eeraka, “Mmwieke nlhieke, ilha phi iruttu aka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amalhiheke nkaathesha ikikombe yo idivai, nkanthimicha Nlhuku, nkaavahacha eeraka, “Mmwurieke onkhaye, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ilha phi iphome aka inotimiriha malhehano a Nlhuku, iphome aka inrihiaa wo nlhatu ni attu enchi wo uhiyereriya uwonya waya. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kinouhimeriani, akinowuria tho idivai yo zabibu mpaka nihuku vanohalha aka uwuria idivai yo naanano vamoka ninyu mu Umweneni wa Athumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Vaamanlhe aya wiipa ichipo, nkayaathama, nkayaarwaa waari Mwako wo Mizeituni. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yamalheke Yesu nkeerelha, “Uhiyu wo lhelho ulha, mwaattiva onkhaye nnowa uttawa ni ukihiya, ukhalhawaya Malhove Matakatifu anohimia wiira, ‘Kinoomwata nshunga Ni ikhondoro chinoomwaria.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nansho baada yo uhihimmwa, kinouholhelhani Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Napeturo nkaamwirelha Yesu, “Akinowa koohiyani, ata attu onkhaye anattawaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu nkeerelha, “Ikekhia kinouhimeriani, ulha uhiyu ulha nthupi uhinaya wiipa, nnowa mwaakikhota vararu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Napeturo nkayeera, “Ata yakhalhaka ukhwa, mbaya ni mii kikhwe vamoka ni inyu, akinookhotani mena.” Ni ayo owiittucha akina onkhaye nkayeera chiichammo. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yamalheke Yesu nkaarwa vamoka ni owiittucha awe waari imata yeehaniya Gethsemane, nkeerelha wiira, “Nkhalheke vaa ni mii kirwee vaholho vawo kalhapelhe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nkaakusha Napeturo ni ashaana elhi a Nazebedayo. Ihuzuni ni uthemwa nkawanchokholha, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","nkeerelha, “Nrima aka uhochariya ihuzuni yinchi, uthananaka ukiwulhusha. Nkhalheke vaa nshiheke vamoka ni mii.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Paahi, nkaarwa miholho vakani, nkaawulhuwa makukhu, nkaalhapelha, “Thithi, yakhalhaka inoworiacha, ilha ikikombe ilha ikivire! Nansho ihikalhe thoko chinthanana aka mii, nansho chinottuna inyu inyuva mwaanene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nkaahokolhia vaari aya owiittucha, nkaaphwanyacha anarumpe. Nkeerelha Napeturo, “Chani khamwonrie ushelhelhiha vamoka ni mii inakhalhaka isaa imoka? ");
INSERT INTO mgh2016_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nshelhelhiheke ni ulhapelha nhiwe mwaakelha muulhikachiyani. Nrima uhottuna nansho iruttu inoohuperia.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nkaarwa tho no nayelhi nkaalhapelha, “Thithi, yakhalhaka khinooriacha wiira, ilha ikikombe yo uweria ilha ikivire wo uhiwureria, paahi etu, chikhalheke thoko chinothanana inyu mwaanene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nkaarwelha tho, nkaaphwanyacha anarupilhe, ukhalhawaya miitho aya aari anachanre ikhove. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Paahi, nkaahiyacha, nkaarwa tho ulhapelhani no neraru olhumachaka yayo malhove ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yamalheke nkaarwelha owiittucha, nkeerelha, “Chani, nri muurupani ni wiittuwa mpaka nna? Mwooneke! Ikatema vano ihophiya, ni Mwaana a Ntu nookumihiya wa attu o uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Munkweke etu, nirweeke. Ntu nokithumiha uyo ulha vaa howa!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu aari olhumachaka ikatema Nayuda, owiittucha mmoka aya khumi ni elhi alhe vaawilhe aya. Vamoka ni ayo nkayaawa attu enchi arii ni maphanga ni indonga yaarumiye ni attu opochera ishaani olhupalhe ni ashulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ntu anthumiha Yesu ahomalha waahimeria nlhove no uthikineha wiira, “Ulhe nohalha aka unkumbatira uyo, phi yoyo nothananiya. Mummareke!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Paahi, Nayuda nkaamwatameria Yesu, nkankohacha eeraka, “Mpuha ukhalhe ni inyu Owiittuchiha!” Nkankumbatira. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu nkaamwirelha, “Mpwana, upangeke uwenlhe ao.” Vavawo attu alhe nkayaawa, nkayammara Yesu, nkayanhelha mmachirini. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ntu mmoka aari vamoka ni Yesu nkaatholholha mwaalho awe mulhupalhe, nkanthikilha nnyaru no wiimonono karumiya a Opochera ishaani Olhupalhe, nkankwatulha. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nansho Yesu nkaamwirelha, “Nhokolhoshe uphanga inyu nnigonereni, ukhalhawaya ntu riyoothe neeva wo uphanga, nookhwa wo uphanga. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Chani, khanchuwenlhe wiira kaanooria waalhepelha Athithi, ni ayo wo uhipicha yankiwihera minepa o wiirimu milhoko cho upwaha milhoko khumi ni melhi? ");
INSERT INTO mgh2016_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nansho anohalha utimira chani Malhove Matakatifu anohimiacha wiira phi chiicho chinophwanelhiya aya chikhalhe?” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yeyo ikatema iyo Yesu nkaahimeria attu o nlhoko waawilhe ummarani, “Chani, mmwilhee ukivara ni mialho chulhupalhe ni indonga thoko wiira ki ntu o uvara makhuche? Kila nihuku kaari keettuchihaka attu wi Inupa ya Nlhuku, ni inyu khamwaakivanre! ");
INSERT INTO mgh2016_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nansho alha onkhaye alha apangelhe wiira Malhove Matakatifu aalhempe aya anamilhohi atimire.” Yamalheke, owiittucha awe nkayanhiya nkayaattawacha. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Paahi, attu yammanre Yesu nkayanrweha upuwani u Nakayafa, Opochera ishaani Olhupalhe, waathukumanne aya attu owiittuchiha Malhehero a ashinna Musa vamoka ni ashulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Napeturo nkayanttwara wo utayi mpaka upuwani wa Opochera ishaani Olhupalhe, nkayaakelha mpaani vamoka ni anamitheko nkayaakhalha vathi yoone chittu chinohalha aya wiira. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paahi, Opochera ishaani Olhupalhe ni nkutiro wonkhaye nkayaavia nlhove no uhimiechesha woothacha, umootheria Yesu wiira amwiive, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nansho khayaapante nlhove niriyoothe no uhimiechesha, inakhalhaka yahowa attu enchi eepanga uhimiechesha wo malhove o woothacha. Wo umalhihera nkayaawa attu elhi o uhimiechesha, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nkayeera, “Ulha ntu ulha aheera, ‘Kinowooria uphomolha Inupa ya Nlhuku ni utheka tho wo mahuku mararu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Opochera ishaani Olhupalhe nkayeemelha, nkayankoha Yesu, “Chani, woonaka khannaakhulha nlhove? Alha attu alha anohimiecheshani uwaachani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nansho Yesu nkaamalha yii. Opochera ishaani Olhupalhe nkayaamwirelha, “Kinowulhupelhihani wa Nlhuku rii nkumi, nnihimerie yakhalhaka ikekhia inyuva phi Kuristo Moopolhi, Mwaana a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu nkaakhulha eeraka, “Eiyo inyuva nhohimia! Nansho kinouhimeriani mwaattiva onkhaye, toka vano nnoomwona Mwaana a Ntu nakhanlhe wiimonono wa Athithi, awaaka wo ikuru umahuteni wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Vavawo, Opochera ishaani Olhupalhe nkaahulha ikuwo chaya, eeraka, “Holhava! Ni rini vano tho yowaavia attu o uhimiechesha? Vano mwaatti nheewa mwaanene ulhava wawe. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Haya mwaatti nnoona chani?” Attu ayo nkayaamwaakhulha, “Hotteka, hophwanelhiya ukhwa!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yamalheke nkayanshuwelha ishenye wiitho, nkayaamwata makofi, ni attu akina nkayaamwata makofi chiicho, ");
INSERT INTO mgh2016_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nkayaamwiirelha, “Inyuva na Kuristo, nlhamulhelheke etu, mpani owatilheni!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Napeturo yaari anakhanlhe vathe ulhuwanini karumiya mmoka nthiyana a Opochera ishaani Olhupalhe vaawilhe awe nkeera, “Ni inyu, chiicho, mwaari vamoka ni Yesu o Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Napeturo nkaaruna vaattuni eeraka, “Akichuwelhe ittu inoolhumacha inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nkaakhuma vathe, nansho vaakhuma aya, vankhorani, karumiya nkina nthiyana nkoona, nkeerelha attu yaari vavawo ayo, “Ulha ntu ulha aari vamoka ni Yesu o Unazareti.” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Napeturo nkaaruna tho eeraka, “Kinoolhupelha wiira akinchuwenlhe yoyo ntu uyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Miholho vakani, attu yaari vavawo ayo, nkayaarwelha Napeturo, nkayeera, “We ikekhiaye, inyuva mwaari mmoka aya, ukhalhawaya nulhumo ninyu ninouhimiecheshani!” ");
INSERT INTO mgh2016_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Vavawo Napeturo nkayeera, “Kinoolhupelha wiira kinoolhumacha aka phi ikeekhene! Nlhuku akihukumulheke etu koothachaka! Akinchuwelhaka ulha ntu ulha!” Vahipinche nthupi nkaweepa. ");
INSERT INTO mgh2016_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Napeturo nkayoopuwelha malhove aahimeriye aya ni Yesu wiira, “Nthupi uhinaya wiipa, nnoowa mwaakiruna mikwaha miraru.” Paahi, nkaakhuma vathe, nkonlha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Washeeke waya attu opochera ishaani olhupalhe ni ashulhupalhe yahopanga miruku cho umwiiva Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nkayanttuka mittondoro cho yuuma, nkayankusha, nkayanrweeha u Napilato yaari agavana. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Vavawo Nayuda, anthuminhe Yesu vonne aya wiira Yesu homalha uhukumulhiya, nkaachukulha munrimani, nkaarwa waahokolhoshera opochera ishaani olhupalhe ni ashulhupalhe makhobilhi makhumi mararu o nchurukhu. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nkeerelha, “Kihotteka wo unthumiha ntu hittenke eeviye.” Nansho ayo nkayaamwiirelha. “Hiyaano ninochuwelha chani yayo malhove ayo? Nlhatu inyu mwaanene.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nayuda nkayaarihelha makhobilhi o nchurukhu alhe mpaani u Inupa ya Nlhuku, nkayaathama, nkaarwa uwiittukelhelhani anene. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Opochera ishaani Olhupalhe nkayaakusha makhobilhi o nchurukhu ulhe, nkayeera, “Khavanorera weesha Nnupani mwa Nlhuku ulha nchurukhu ulha ukhalhawaya uri nchurukhu wo iphome.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Paahi, yeewananeke, nkayoopolha imata ya ntu oopa miapu vakhalhe vakittu vo uvithiya alheto. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Phi nlhatu mpaka lhelho yeyo imata iyo ineehaniya imata yo iphome. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wo chiichammo etu, malhove a anamilhohi Nayeremiya chaatiminre aya venre aya, “Yahokusha nchurukhu makhobilhi makhumi mararu, nhakhu waakumihiye ni attu o Israeli vewananne aya malhivo awe, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nkayoopolha imata ya ntu o wuupa miapu, thoko Athithi chaakilhehenre aya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu nkeemeshiya wa Aholhelhi o Urumi, ankonhe wiira, “Chani, inyuva phi Amwene a Ayahudi?” Yesu nkaakhulha, “Inyuva nhohimia.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nansho khaakhunlhe ittu wo milhatu chaareiya awe ni attu opochera ishaani olhupalhe ni ashulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chiicho Napilato nkayankoha, “Chani, khannewa milhatu chonkhaye chinohimiya chuwaachakani?” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nansho Yesu khaakhunlhe ata nlhove nimoka, mpaka Napilato nkayoomiya uwanoni chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Napilato ahokhalhana malhemalhelho ikatema yo Pasaka unhiyerera ntu ttukiye mmoka aathananiye ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Yeyo ikatema iyo Yesu vaahukumulhiya awe, ahaawo ntu ottukiya mmoka aachuwanelhe chinene, nchina nawe aari Baraba. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Paahi attu vaathukumanne aya vamoka, Napilato nkayaakoha, “Mwaatti nnothanana kinhiyerereke mpani? Baraba ama Yesu neehaniya Kuristo?” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Napilato yahochuwelha wiira aholhelhi a Ayahudi yanrwehilhe Yesu wo nlhatu no mwoonelha ihache. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Napilato vaari aya anakhanlhe vachulhu ihiche yo waahukumulhelha attu, ahanu aya nkayaarwehelha nttenga wiira, “Nhikhalhe ni nlhove niriyoothe ni uyo ntu orera nrima hittenke uyo, ukhalhawaya lhelho uhiyu kihothemwihiya chinene ntorani wo nlhatu nawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nansho attu opochera ishaani olhupalhe ni ashulhupalhe nkayapepechacha attu avekelhe wiira Baraba attukulhiye ni Yesu eeviye. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nansho Napilato nkaakoha, “Phi mpani wa alha attu elhi alha nnothanana inyu kinhiyerere?” Attu nkayaakulha, “Ninonthanana Baraba!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Napilato nkayaakoha tho, “Vano, kimwiiriheke ittu yaani Yesu neehaniya Kuristo ulha?” Attu onkhaye nkayeera “Akhomelhelhiye vansalaabani!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Napilato nkayaathepa ukoha, “Wo nlhatu waani? Panngeni yo uhilhoka?” Attu nkayaathepa ukhuwelha, “Akhomelhelhiye vansalaabani!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paahi, Napilato yachuwelheke wiira khavanshichira tho, ni attu yaari achokholhaka uhelha injoove, nkayaawia maashi nkaanyawa mathatha aya vaattuni, nkayeera, “Mii akirina nlhatu vachulhulhu iphome awe ulha ntu ulha! Nlhatu winyu mwaashinene!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Attu onkhaye nkayeera, “Iphome awe inihokolheelheke vachulhu wihu ni achishaana ihu!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Vavawo Napilato nkayanhulhelha Baraba ukhuma waattukiye awe, nkaamwata Yesu ikopo ni waavaha Yesu akhomelhelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yamalheke manyaasikari a Napilato nkayanrweeha Yesu mpaani, ni attu onkhaye nkayancharaanelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nkayanrulha ikuwo chawe, nkayammwariha ikanzu yokhwilha. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yamalheke nkayaativa mphumburu wo miiwa, nkayammwariha mmuruni, nkayammariha nthalhe moono wo wiimonono. Nkayaakhoroma vaari awe, nkayampangelha mattepwa yiiraka, “Moyoo Amwene a Ayahudi!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nkayanshuwelha ishenye, nkayaakusha nthalhe ulhe, nkayaamwatelha mmuruni. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yamalheke umpangelhacha ncheche, nkayanrulha ikanzu ilhe, nkayammwariha ikuwo chawe. Nkayanrweha unkhomelhelhani munsalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vaari aya arwaaka nkayankumaana ntu mmoka nchina nawe Simoni nnenchi o Ukirene, nkayanchuchumiha ni unkhanyereriha wiira akushe nsalaaba wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yaphiyeke vakittu vaneehaniya Gologota, maana aya, “Nikhurukucha no muru.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nkayammaha idivai yaathakanihiye ni ittu yo uhapalha, nansho Yesu alhawiheke khaawunrie. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nkayankhomelhelha vansalaabani. Yamalheke nkayaakawana ikuwo chawe wo woopa ikhura. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nkayaakhalha, anlhitelhelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Vamuruni vawe, nkawaalhepiya milhatu chawe cheera, “Ulha phi Yesu, Mwene a Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nkayaakhomelhelha tho attu elhi o uvara makhuche, mmoka wiimushi ni nkina wiimonono. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Attu yaavira vavawo vakitu vawo ahopukhunyacha miuru ni unruwana eeraka, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Inyuva! Ngati mweera nnowooria uphomolha Inupa ya Nlhuku ni utheka tho wo mahuku mararu! Mwiichoopolheke etu mwanene mwakhalhaka inyuva phi Mwaana a Nlhuku! Paahi, nkhuruweke vansalaabani vawo!” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wo yeyo iphiro iyo opochera ishaani olhupalhe vamoka ni attu owiittuchiha Malhehero a ashinna Musa ni ashulhupalhe yahonnyoholhacha yeeraka, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ahoopolha akina, nansho wiiyopolha khanooria wiiyopolha mwanene! Kahiwe phi yoyo Mwene a Ayahudi? Paahi, ooriaka wiikurusha vansalaabani, hii ninonrumelhelha! ");
INSERT INTO mgh2016_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ahonrumelhelha Nlhuku ni wiira eti yoyo phi Mwaana a Nlhuku, paahi, Nlhuku amwopolheke yakhalhaka nonttuna.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ni ayo o uvara makhuche akhomelhelhiye vamoka ayo, yahonruwanakacha chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vaari aya saa sita uthana ilhapo yonkhaye nkayaakelhiya ipiphi, yaalhokenlhe wo isaa taaru. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yaphiyeke isaa tisa Yesu nkaakhuwelha wo nlhove nuulhupalhe eeraka, “Eloi, Eloi, lama sabakthani?” Maana aya, “Nlhuku aka, Nlhuku aka, woonaka nhookihiya?” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nansho attu yeemenlhe vavawo yeeweke chiicho nkayeera, “Neehana Naeliya.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mmoka aya nkaattimakacha, nkaakusha ndodoki, nkaanelhiha nsiikini, nkeesha munthalheni, nkammaha awurie. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nansho attu akina nkayeera, “Nhiye noone yakhalhaka Naeliya anowa uumopolhani.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Paahi, Yesu nkaakhuwelha tho, nkaahiya nrima. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Vavawo nipaziya nulhupalhe no u Inupa ya Nlhuku nkanaahuwa ipaande pilhi, ukhuma nchulhu mpaka vathi. Ilhapo nkayaatetemelha, mialha nkachaphwiaa, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mahiye nkayaapatakuwa ni iruttu cha atakatifu enchi yaakhwilhe, nkachaahihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nkayaakhuma mmahiyeni, ni Yesu vaahihimmwe awe nkayaarwaa Iwani Itakatifu, nkayoonachiya ni attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Paahi, olhupalhe a manyaasikari ni manyaasikari yaariwo, anlhitelhelhaka Yesu yooneke ntetemelho no ilhapo ni attu aakhumelhenlhe, nkayoova chinene, nkayeera, “Ikekhiaye yolha ntu ulha aari Mwaana a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vavawo vakittu vawo yahawo manyopani enchi awehaka wo utayi. Yayo phi alhe yanttwarilhe Yesu ukhuma Ugalilaya ankavihaka ntheko. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mommo munlhokoni mwaya mmo yahaawo Amariamu Magidalena, Amariamu anumwanaya Nayakhobo ni Nayusufu, vamoka ni ahanu a Nazebedayo. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uchechilho, nkaawa ntu mmoka o nhakhu nnenchi o Uarimathaya, eehaniya Nayusufu. Ni ayo chiicho aari owiittucha a Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nkayaarwelha Napilato, nkayaalhepelha wiira avahiye iruttu ya Yesu. Paahi, Napilato nkayaalhehera wiira avahiye. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nayusufu ahokusha iruttu ilhe, nkaavilhikelhelha isaanda yorera yo hariri, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nkayaavitha mu nihiye no naanano naahemme aya vamwalhani. Amalheke nkaapirikisha nlhuku nulhupalhe utiya vanlhakoni, nkaarwa uwani. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Amariamu Magidalena ni Amariamu akina yaari anakhanlhe awehaka miitho unihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nihuku no nayelhi naari Nihuku no Wiittuwa. Opochera ishaani olhupalhe ni Amafarisayo nkayaakumaana ni Napilato, ");
INSERT INTO mgh2016_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nkayeera, “Pwiiya, nihoopuwelha wiira ulhe ntu othepiacha ulhe aheera hinaya ukhwa eti, ‘yaviraka mahuku mararu kinohihimmwa.’ ");
INSERT INTO mgh2016_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wo chiichammo etu nlheehereke wiira nihiye nilhitelhelhiye mpaka nihuku no neraru, owiittucha awe ahiwe eiyaka iruttu awe, ni werelha attu wiira hohihimmwa. Woothacha wo umalhihera uwo unowa unanara upwaha wo upacha ulhe.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Napilato nkeerelha, “Haya etu, nrweeke mwakhalhelheke nihiye nno thoko chinoona inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Paahi, nkayaarwaa ulhitelhelhani nihiye, nkayaashiringa vachulhu nlhuku nne ni waahiya vavawo manyaasikari o lhitelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Navireke Nihuku no Wiittuwa, mapikoosha o nihuku no jumaapili, Amariamu Magidalena ni Amariamu akina yahorwaa uwehani nihiye nne. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wo uhipicha nkawaakhumelhelha utetemelha wo ilhapo wo machiri, nnepa wo wiirimu wa Athithi wahokuruwa ukhuma wiirimu, nkawaapikirisha nlhuku ni ukhalhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Waaria waya waari thoko wo uverunya, ni ikuwo chawe chaari chootelha twetwetwetwe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Attu yaalhitelhelha nihiye nkayaatetemelha wo woova chinene, nkayaakhalha thoko attu akhwilhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nnepa wo wiirimu nkawoolhumacha weerelha manyopani alhe, “Mwaatti nhoove, ukhalhawaya kihochuwelha wiira nnomwaavia Yesu, aakhomelhelhiye vansalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Khaawo vaa, hohihimmwa, thoko chenre awe wo uhimia. Mmweeke mwoona vakittu veeshiye awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Paahi, nrweeke chitema mwerelheke owiittucha awe wiira hohihimmwa ukhuma unookhwani, ni vano hooholhelhani urwaa Ugalilaya, wowo nnokoomwona! Muupuwelheke nlhove kiuhimenriakani nno.” ");
INSERT INTO mgh2016_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Manyopani ayo nkayaathama unihiyeni wo waakuviacha, anari oovaka uno atelhiyaka chinene, nkayaattimakacha urwaa uwaalhelhani owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vahipinche, Yesu nkaakumaana nkeera “Mpuha ukhalhe ni inyu.” Nkayamwaatameria, nkayankhoromelha ni ummara mieto chawe, nkayanthimicha. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu nkeerelha, “Nhoove, nrweeke mwaahimerieke ashilhoko aka wiira arwee Ugalilaya, wowo anookona.” ");
INSERT INTO mgh2016_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Manyopani alhe vaari aya mphironi arwaachaka, attu yaalhitelhelha nihiye nkayaarwaa uwani uwahimiacherani opochera ishaani olhupalhe mwaha wonkhaye ukhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Paahi, opochera ishaani olhupalhe nkayaakumaanacha vamoka ni ashulhupalhe nkayeewanana, nkayaavaha manyaasikari yaalhitelhelha nihiye alhe nchurukhu mwinchi ");
INSERT INTO mgh2016_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yiiraka, “Mwaatti mweereke wiira, owiittucha awe yahowa uhiyu, nkayeeiya iruttu awe hii ninarupilhe ikhove. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ni aholhelhi o utawara eewakaru, hii ninowolhumana ni waahimeria ikekhiaye wiira mwaattiva khanttenke, ni inyu khannopatta milhatu.” ");
INSERT INTO mgh2016_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Manyaasikari ayo nkayaawia nchurukhu ulhe, nkayeera thoko chenre aya wo wiittuchihiya. Yoyo mwaha uyo nkawaawanelha mwa Ayahudi mpaka lhelho nna. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Owiittucha khumi ni mmoka nkayaarwaa umwaakoni Ugalilaya waalhehenre awe Yesu wiira arwaacheke wowo. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yamwooneke nkayanthimicha, yaahokhalharu akina yahaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu nkachushera vakhiviru waya, nkaahimia wiira, “Kihovahiya ikuru yonkhaye yo wiirimu ni yo velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nrwaacheke etu, wa attu o makosho onkhaye mwaapangeke ukhalha owiittucha aka, mwaabatiizeke wo nchina ni Athithi, ni no Mwaana, ni Iphumu ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mwettuchiheke uvara malhehero onkhaye yuvanheakani. Ni mii kinolhokelha vamoka ni inyu mahuku onkhaye, mpaka umalha wo ilhapo.”");
INSERT INTO mgh2016_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Alha phi Malhove Orera a Yesu Kuristo, Mwaana a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anochokholha thoko anamilhohi ashinna Isaya chaalhempe aya, “Nlhuku heera, ‘Kinonruma karumiya aka nohalha ukoorosha iphiro inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nlhove na ntu ninookhuwelha muuthakoni, nineera, ‘Muuheke iphiro ya Athithi, Mwookolhe mitalha chinohalha aya uvira!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Paahi etu Nayohana nkaakhumelhelha uthakoni, abatiizaka ni waahimeria attu akhoromeke ni uhiya uwonya waya, abatiiziyeke, wiira Nlhuku ahiyerere milhatu chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Attu enchi ukhuma ilhapo yonkhaye yo Uyudea ni Uyerusalemu ahokhuruwa uwewelhelhani Nayohana. Nkayaahimiacha uwonya waya, ni ayo nkaabatiizacha mmwoolhokoni Uyorodani. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nayohana aawara ikuwo cho mapururu o ingamiya ni nchako wo nrapalha nnyununi, cholhia chaya chaari nashombe ni urawo wo umwiini. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ikatema chonkhaye aahimeria attu wiira, “Hawo nowa utulhi waka ri ni ikuru kihinooria aka umphiyelha. Akinooria ata uthaphulha miripwe cho iratu chawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mii kinaabatiiza attu wo maashi nansho yoyo nowa waabatiiza attu wo Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yayo mahuku ayo Yesu ahowa akhumaka Unazareti yo Ugalilaya, nkaabatiiziya ni Nayohana mmwoolhokoni Uyorodani. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Vaakhuma awe mmaashini, nkoona irimu ihulhiaka ni Iphumu ya Nlhuku aari thoko kaulha nkawankorweelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nlhove nkanaakhuma wiirimu niiraka, “Uwe phi mwaamwanaka kinonttuna aka, nokichivelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yeyo ikatema, Iphumu ya Nlhuku nkanholhelha urwaa uthakoni, ");
INSERT INTO mgh2016_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","waakhanlhe mahuku makhumi ncheshe, alhikachiyaka ni Nakare. Aari wowo vamoka ni ashinama o umwiini, nansho minepa cho wiirimu nkachaawa ni unkavihera. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vaattukiye aya Nayohana, Yesu ahohokolhia Ugalilaya, nkaahimiacha Malhove Orera aakhuma wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ahimiachaka wiira, “Ikatema ihaaya, Imwene ya Nlhuku ihaatameria! Nrukunuweke nkhoromeke ni uhiya uwonya, nrumelhelheke Malhove Orera!” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu veeta awe nchereshere nttiya no Ugalilaya nkoona Nasimoni ni ahima aya Naandorea ariaka nttavi no ihopa. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu nkeerelha wiira, “Nkittware, kuuvaheni mitheko cho woopolha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yeyo ikatema nkayaahiyacha ittavi chaya, ni unttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Vaari aya miholho nkayamwoona Yakhobo ni nhima awe Yohana ashaana a Nazebedayo anari nkalhavani ni ayo alhokihaka ittavi chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Vonne awe nkeehanacha ni ayo, nkaayaahiya athumwanaya Nazebedayo nkalhavani vamoka ni anamitheko ni unttwara Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ni owiittucha awe nkayaarwaa Ukapenaumu Nihuku no Wiittuwa, nkaakelha inupa yo unlhapelha Nlhuku ni weetuchiha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Attu yaamwiwelhelha nkayaashanga woona wiira aari eettuchihaka upwaha cheetuchihiya aya ni owiittuchiha Malhehero a ashinna Musa eetuchiha kila nihuku, ukhalhawaya eetuchiha wo ikuru. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Wo uhipicha nkaawa mommo wi inupa yo unlhapelha Nlhuku mmo, ntu awereiya mashoka o unanara aakhuwelha wiira, ");
INSERT INTO mgh2016_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Unonaaviani uwe Yesu o Unazareti? Ukhalhawaya nihochuwelha wiira uwe phi karumiya Ntakatifu a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu nkaachachera nenno nshoka nno, “Mmaalhe, nthame munhiyerere!” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nshoka no unanara nno nkanantikhinyacha ntu ulhe, nkanaankuwelhiha ni unthama. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Attu onkhaye nkayaashanga ni wiikoha, “Ineria chani? Chilha vano phi meettuchiho o naanano? Ntu hanaa ikuru yo ulhehera ni uchacheracha mashoka o unanara ni umwiiwelhelha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Paahi etu yoyo mwaha uyo nkawaaruma wo uhipicha ilhapo yonkhaye yo Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ni owiittucha awe Nayakhobo ni Nayohana nkaathama wi inupa yo unlhapelha Nlhuku nkayaarwaa uwani u Nasimoni ni Naandorea. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Vavawo vawani vawo ahokohi aya Nasimoni aari areta ni Yesu nkaahimeriya phiyaru. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nkaakelha mpaani vaarumpe aya, nkaavara moono ni waakalhiha nipuro. Ureta nkawaalhama ni ukhalha akumi tho. Nkayaachokholha waaterekhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uchechilho nkaawiheriya areta onkhaye vamoka ni attu o mashoka o unanara. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Attu o ilhapo yonkhaye nkayancharaanelha vapuwani vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu nkaalhamiha areta onkhaye ni woomolha mashoka o unanara onkhaye. Nkaachiichiha ahuulhumache tho ukhalhawaya aari anchuwelhaka wiira aari phi mpani. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nkonkwa mapikoosha nkaathama ni ukelha vakittu vaakanlhe awe vekha awe anlhapelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nansho Nasimoni ni ashikhunanaya nkayaarwaa umwaaviani. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vaamwonne aya nkayaamwirelha wiira, “Attu onkhaye anowaaviani inyuva.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nansho Yesu nkaakhulha eeraka, “Nngwee nithame nirwee iwani chiriyoothe cho vakhiviru. Ukhalhawaya ni uwo kihothananiya kirwee kahimiache Malhove Orera ukhalhawaya kiwilhe wo yayo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nkaavira ilhapo yonkhaye yo Ugalilaya akelhaka inupa cho unlhapelha Nlhuku aahimeriaka attu Malhove Orera ni woomolha mashoka. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ntu o makutulha nkaawa wa Yesu nkaakhoroma ni unlhepelha eeraka “Mwattunaka nnookilhamiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu nkaakelhiya ikiriri nkammara moono ni umwiirelha, “Kihothanana nlhameke etu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Vavawo makutulha nkayaafutiaa nkaalhama. ");
INSERT INTO mgh2016_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu nkoolhumacha ni umwiirelha athame uno anchiichihaka wiira, ");
INSERT INTO mgh2016_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nhihimerie ntu. Nansho nrweeke mweechoniheke wa attu opochera ishaani mwahimiechesheke wiira nholhamihiya ni wiihapiha thoko chilheheriye aya ni ashinna Musa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nansho yoyo ntu uyo nkaavira ahimiachaka mwaha awe uyo, mpaka Yesu nkoochelha uwa vawani. Nkaakhalha vanipuroni vo yekha awe. Nansho ata inakhalhaka chiicho, attu ahonrweelha ukhuma iwani chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wo uhipicha mahuku menchi Yesu nkaawa tho Ukapenaumu. Uwa wawe nkaweewania ni attu enchi wiira Yesu hohokolhia uwani. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Attu enchi nkayaawa vavawo ni uchara woochelhiyaka upatta nipuro mpaka vathe. Yesu nkeettuchihacha Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nkayaawacha attu yankushilhe ntu aaririyanche iruttu ummwiiha wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nansho chenre aya wo uchara attu chinene, khawoorielhe umpiiha nreta uyo mpaka vaari awe Yesu. Nkayaawelha vanchaarani ni ukhunulha nivatho vo unkurushelha nreta ni nkori awe mpaka mpaani mwaari awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ooneke yoyo nrima uyo, nkaamwirelha ntu o ririyacha moono uyo “Mwaamwanaka uhohiyereriya uwonya wawo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Owiittuchiha Malhehero a ashinna Musa akina yaari vavawo ayo nkayaachokholha uthikhina ashineneru munrimani yeeraka, ");
INSERT INTO mgh2016_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wo nlhatu waani noolhumacha chommo? Honlhava Nlhuku! Khaawo ntu nooria uhiyerera uwonya ihikhalhe Nlhuku mwanene.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Vavawo Yesu ahochuwelha ichuku chaya chiyo munrimani mwawe nkaakoha, “Nlhatu waani wo uchukulhacha chiicho? ");
INSERT INTO mgh2016_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Vaalhuwilhe vayi, umwiirelha, ‘Nhohiyereriya uwonya winyu’ ama wiira ‘Nkusheke ikori inyu nrweeke uwani’? ");
INSERT INTO mgh2016_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kinoowoonihani wiira, Mwaana a Ntu hanaa ikuru velhaponi yo uhiyerera uwonya wa attu.” Nkaamwirelha ntu o uririyacha iruttu ulhe ");
INSERT INTO mgh2016_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kinouhimeria wunkweke etu, nkusheke ikori inyu nhokolhieke uwani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yeyo ikatema, attu vaari aya awehaka, nkeemelha ni ukusha ikori mwanene ni uhokolhia uwannyawe. Attu onkhaye yaari vavawo nkayaathikhina, nkayanthimicha Nlhuku wo wiira, “Khaninapacha mena woona chittu thoko chechilha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu nkaahokolhia tho uchereshere nttiya no Ugalilaya. Attu enchi nkayanttwara ni uyo nkaachokholha weettuchiha. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Vaari awe mphironi awaaka ahomwoona ntu aalhiviha ikhodi eehaniya Lawi mwaana a Naalufayo, nakhanlhe waari inupa yo upocherera ikhodi nkaamwiirelha “Nkittware.” Nalawi nkeemelha ni unttwara. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nkaaphiya unupani u Nalawi, ni ukhalha ulhia yolhia. Attu o lhiviha ikhodi enchi ni attu akina o uwonyani owiittucha awe yanttwara, yahokhalha vamoka ulhia yolhia ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Owiittuchiha Malhehero a ashinna Musa akina yaari Amafarisayo, nkayoona wiira Yesu aari alhiaka ni attu o uwonyani attu olhiviha ikhodi, nkayoona mbaya yaakohe owiittucha awe, “Nlhatu waani Owiittuchiha inyu anolhia vamoka ni attu o uwonyani attu olhiviha ikhodi?” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu nkeewa ni waakhulha wo weerelha wiira, “Attu akumi khanaavia abwana mganga, ihikhalhe areta. Ukhalhawaya mii akiwilhe weehana attu anopamga chittu cho rera nansho attu onkhaye awonyilhe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Owiittucha a Nayohana ni owiittucha a Amafarisayo aari attukaka. Nkayaawa attu ni unkoha Yesu, “Woonaka owiittucha inyu kanottuka uno akina attukaka?” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu nkaakhulha, “Chani vanowooriaa attu ari u arusini ukhalha ni ithalha? Vakittu thoko vavawo khavanooria attu uttuka wo uhilhia abwana arusi anari vavawo, mena khiyooriaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nansho nihuku ninowa abwana arusi vanohalha aya uthamihiya, vavawo nnowoona attu attukaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Khaawo ntu notottelha imbaati yo ikuwo yo naanano vachulhu ikuwo yoothalha. Ukhalhawaya yapangaka chiicho, imbaati iyo inoototokwaa ni ikuwo iyo inoothepihiya waahuwa uwo. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mena khaawo attu anohelha idivai yo uchasha mu ntumpa wo khalhayi. Ukhalhawaya unoophwiaa ni idivai iyo inorihiaa. Nansho ntumpa wo naanano phi nohelhiya idivai yo uchasha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu vamoka ni owiittucha awe yaari eetakachaka imata chaalhimiya ingaano Nihuku no Wiittuwa. Owiittucha awe nkayontha machashi o ingaano ni ukhuura imbeyu chaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Paahi etu Amafarisayo yoonekeru nkayaamwirelha Yesu, “Woonaka o wiittucha inyu anopanga chittu ichiichihiye ni Malhehero wiira ihipangiye Nihuku no Wiittuwa?” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu nkaakhulha, “Chani mwaatti khannashoma Adaudi ni ashikhunanaya chaapannge aya vaari aya anawolhiye ithalha? ");
INSERT INTO mgh2016_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mahuku Naabiatha vaari aya Opochera ishaani Olhupalhe, Adaudi vaakenlhe aya Inupa ya Nlhuku nkayaalhia mikatte chaakumihiye isadaka wa Nlhuku, mikatte chaachiichihiye ulhiya ni attu akina, ahikhalhe opochera ishaani vekha aya, nkaakawelha ni ashikhunanaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu nkaahimia wiira, “Nihuku no Wiittuwa neeshiye wa attu, kuhena attu eeshiye wo Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Paahi etu, Mwaana a Ntu phi mwanene Nihuku no Wiittuwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu ahokelha tho wi inupa yo unlhapelha Nlhuku, mwaari awe ntu mmoka o moono wo uririyacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Attu nkayammweha awehereraka yoone yakhalhaka Yesu nonlhamiha ntu uyo Nihuku no Wiittuwa nno, apatte nlhatu wo mwootheria wiira howonya. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu nkaamwiihana ntu ulhe, “Mmweeke variyari vavaa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nkaakoha attu eeraka, “Malhehero a ashinna Musa ihu anolhehera chani cho upanga Nihuku no Wiittuwa? Upanga ittu yo urera ama yo uhilhoka? Woopolha ukumi wa ntu ama wiiva.” Wo uhikhalha no waakhulha nkayaamaalha shiriri. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu nkaarushiya vaaweha awe attu, ni uwonelha ikiriri, ukhalhawaya mirima chaya chaari choolhipa. Nkamwirelha ntu uyo “Wookolheke moono awo uyo.” Nkookolha nkawaalhama. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Paahi etu Amafarisayo nkayaakhumacha vathe ni ukumaana ni attu o nlhoko wa Naherode, waapa iphiro yo mwiivelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ni owiittucha awe ahothamacha vavawo, nkaarwa mpaka uchereshere nttiya no Ugalilaya ni milhoko cha attu chaari chinttwaraka. Attu aakhumme ilhapo cho Ugalilaya ni cho Uyudea, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Uyerusalemu ni Udumea akina akhumaka ukhopelhelhe mwoolhoko wo Yorodani iwani cho Utiro ni Usidoni. Yayo attu onkhaye ayo aawa wa Yesu wo wiiwa chittu chaapangacha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Milhoko chaari chinchi mpaka Yesu nkeerelha o wiittucha awe amweeshere ikalhava rata, hiwe aathuriya ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ahaalhamiha attu enchi, mpaka areta akhwawe ahuramanaka athananaka inakhalhaka unkwakwanya. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Attu o mashoka o unanara vaamwonne aya, nkayankhoromelha akhuwelhaka wiira, “Inyuva phi Mwaana a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu nkaachiichiha mashoka o unanara ahinromolhache wiira aari mpani. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu nkaawelha vamwaakoni ni weehana aathananne awe. Nkayaawa, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nkaathanlha attu khumi ni elhi, ehanne awe akarumiya, nkeerelhacha, “Kihoothanlhani wiira nkhalhe vamoka ni mii, kuurumeni nvira nhimiachaka malhove, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ni inyu nnookhalha ni ikuru yo woomolhacha mashoka o unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Alha phi khumi ni elhi aathanlhiye, Nasimoni aavahiye ni Yesu nchina Napeturo, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nayakhobo ni ahima aya Nayohana, ashaana a Nazebedayo aavahiye ni Yesu nchina no Buanege, maana aya “Ashaana o uritima”, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Naandorea ni Nafilipo ni Nabatolomayo ni Namatayo ni Natomaso ni Nayakhobo mwaana a Naalufayo ni Natadayo ni Nasimoni nnenchi o Ukaanani, ");
INSERT INTO mgh2016_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Yuda Isikariote aapannge miruku cho nthumiha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu nkaahokolhia uwannyawe. Milhoko cha attu nkachaawa tho, mpaka Yesu ni owiittucha awe nkayoochelha upatta nipesha no ulhia yolhia. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Manyaalhoko awe veewilhe aya, nkayathanana ummara, ukhalhawaya attu eera wiira, “Hokelhiya ihalhahalha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Owiittuchiha Malhehero a ashinna Musa akina aakhumme Uyerusalemu nkoolhumacha wiira, “Ri ni Belzebuli! Nshoka nholhelhi ninommaha machiri o wooomolha mashoka o unanara makina.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu nkeehanacha ni wolhumana wo malhikaaniho eeraka wiira, “Inooria chani Nakare umoomolha Nakare nkina?” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Imwene imianelhe yaatakanaka ineneru, yeyo khinolhokelha inowulhuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ni iwani iriyoothe yeemianihaka ni waatakana ineneru, yeyo khinolhama inowulhuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yakhalhaka etu imwene yo Nakare inowiimianiha ineeneru, yeyo khineemelha, inowulhuwa ni ulhakalhaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Wo ikekhiaye khaawo ntu nokelha inupa ya ntu o machiri ni uwiaa nhakhu awe aahichokholheke thoko unttuka mwanene uyo wo machiri, vavawo phi nowiaa awe chittu chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kinouhimeriani wo ikekhiaye wiira, Nlhuku nowa waahiyerera attu uwonya waya wonkhaye ni ulhava waya wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nansho ntu nolhava ni unttekelha Iphumu ya Nlhuku, yoyo kanohiyereriya uwonya ngu! Ukhalhawaya hotteka nlhatu wo uhimalha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu aahimiacha chechiyo ukhalhawaya attu amwiirelha, “Ri ni nshoka no unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anumwanawe ni ashihimawe nkayaawa. Nkayeemelha vathe anrumaka ntu wiira ehaniye. ");
INSERT INTO mgh2016_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Veehaniya awe attu enchi aari ananrukurenrie nkayaamwiirelha, “Anumwaninyu ni ashilhoko inyu arii vathe vawo, anowiihanani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu nkaakhulha wiira, “Anumwanaka phi apani? Ashilhoko aka phi apani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","olhumachaka uno aawehaka attu anrukurenrie, nkeera, “Mwooneke alha va! Alha phi manyaanumwanaka ni ashihimaka! ");
INSERT INTO mgh2016_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ntu riyoothe nopanga chittu chinonteelhiha Nlhuku yoyo phi mwanhimaka phi mwanrokoraka ni uyo phi anumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu nkaachokholha tho weetuchiha attu enchi uchereshere nttiya no Ugalilaya. Attu enchi nkaachara nkayanrukureria mpaka nkaawelha nkalhavani nkaakhalha. Ikalhava inari mmaashini, attu yaari anakhanlhe vachengweni. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aari eetuchiha malhove menchi wo ulhikaaniha chittu, eeraka, ");
INSERT INTO mgh2016_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nkeewani! Ntu mmoka ahorwaa uumwachani imbeyu. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Vaamwacha awe imbeyu vathi, chahaawo chaamonre vaphironi, nkachaalhiya ni ashinuni. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chikhwawe chamorenlhe vanagagani, vahaari ni ittaya yinchi. Nkachaamelha, nansho nkachaanyaalha ukhalhawaya ittaya yaari vakani. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nchuwa nkanaapharelha, nkachaavia, ukhalhawaya mithithaari khacheevarenlhe nttayani, nkachooma. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chahaawo chikina chaakorenlhe vamiiwani, nkachavaravariya, chunnuwaka wo uhimma. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nansho chahaawo imbeyu chikina chaamorenlhe vachaayirani, nkachaamelha rata, ni wiima rata, chikina inuku makhumi mararu, chikina makhumi sita, ni chikina imia imoka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu nkaamalhiha eeraka, “Ri ni maaru eeweke!” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Vaari awe nakhanlhe vekha awe, attu akina yamwiiwelhelha nkayaawa vamoka ni owiittucha awe khumi ni elhi anlhepelhaka wiira alhamulhe malhikaaniho awe alhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu nkaakhulha, “Mwaatti nhovaheriya uchuwelha chittu chivithiye wi Imwene ya Nlhuku.” Nansho arii vathe alhe anoohimeriya yayo malhove ayo wo malhikaaniho, ");
INSERT INTO mgh2016_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ikhalhe wiira, “ ‘Wo ikekhiaye anooweha nansho khanoona, Anowiiwelhelha, Nansho khaneewa. Ukhalhawaya eeraka chiicho, Anonrukunuwelha Nlhuku, Nkaahiyerera uwonya waya.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu nkaakoha eeraka, “Chani woonaka khannochuwelha nna nlhikaaniho nna? Nnottuna uchuwelha chani nlhikaaniho niriyoothe? ");
INSERT INTO mgh2016_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ntu o waalha phi naalha nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Attu akina anokhalha thoko imbeyu chinomorelha vaphironi, eewakaru tu nlhove, Nakare noowa ni uthamiha mmamirimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Attu akina anokhalha thoko imbeyu chaamonre vanagagani. Vaneewa aya nttenga anoopochera uno ateelhiyaka munrimani. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nansho khaninaakelha ni ukhalha ni mithithaari nhina mwaya, ahivilhelhaka. Vanokwana aya, khanopicha uhiya nlhove ni ukhwa nrima wo uhipicha. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Attu akina anokhalha thoko imbeyu chaamonre vamiiwani. Yalha phi alhe aneewa nttenga, ");
INSERT INTO mgh2016_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nansho nipampa no velhaponi va, no nhakhu, ni nikakata ninoothemwiha nlhove nipochenre aya, ni wuumiha wiira nikhalhe wo uhimma. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nansho akhwawe ayo anokhalha thoko imbeyu chaamonre vachaayirani, aneewa nttenga, khupocheraka, ni uyariha imbeyu makhumi mararu, akina makhumi sita akina imia imoka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu nkaathepa tho wulhumacha, “Chani hawo ntu noparihelha ikhandiri awe ni uwiiha mpaani ni ukhunelha ittutu ama neesha nkhwikwichiri? Mena! Anothomia vachulhu ikiango. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ittu iriyoothe ivithiye inowa uhumbukulhiya, ama ittu ikhuneelhiye inowa yaapatakulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri ni maaru, eewechesheke!” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nkaahimia tho, “Mwiiwelhelheke mwaha uneewa inyu! Maphimelho anaaphimelha inyu attu, phi chiichammo chinohalha inyu uphimelhiya ni Nlhuku, munchereriyaka chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ntu rina ittu nowunchereriya, ni ayo ahirina ittu anothurulhiya, ata ikani irinawe iyo inookushiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu nkaathepa uhimia wiira, “Imwene ya Nlhuku iri thoko cho. Ntu nowaalha imbeyu vattayani. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Uhiyu arupaka, uthana akhalhaka miitho, nnyepu wunnuwaka. Ni uyo hichuwelhaka ittu. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ittaya ineneru phi nonnuwiha nnyepu ni uyariha, ichokholhaka ukhumelha vathe, ituva, ni ikatema yaphiyaka wiima. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chakhomaalhaka, phi nochokholha awe ntu uthikilhacha ni imboopo awe, ukhalhawaya nlhaalha uhaaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu nkeera, “Nilhikaaniheke ni ishiyani Imwene ya Nlhuku? Nulhumacheke nlhikaaniho naani? ");
INSERT INTO mgh2016_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Irii thoko cho. Ntu nookusha imbeyu ikaani chinene yo haradali iri imbeyu ikani chinene velhaponi, khwaalhaka vathi. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nansho yaalhiyaka inoomelha ni wunnuwa ukhalha mwiri mulhupalhe upwaha miri chonkhaye. Umelhaka iphata chulhupalhe chinokorelha ashinuni o wiirimu ni utheka iphuuru munttuuchini mwaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu aheettuchiha nlhove nawe wo malhikaaniho thoko yayo, aahimeriaka attu chooria aya wiiwelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kholhumanche nlhove wo uhilhikaaniha, ihikhalhe vaari awe vekha ni owiittucha awe, wowo ahaalhamulhelha malhikaaniho ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Uchechilho nenno nihuku nno, nkaahimeriacha owiittucha awe wiira, “Nngwe nilhapuwe nirwee ukhopelhelhe nttiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Paahi nkayaahiyacha attu ayo, nkayaawelha nkalhavani, owiittucha nkayanttwara, nkayaathama. Ikalhava chikina nkachaattwara. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wo uhipicha nkawaawuka iphioo yo machiri, maashi achokholhaka uthemwathemwa athemwihaka ikalhava, ni maashi nkayaakelha nkalhavani. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu aari narumpe utulhi ikalhava. Owiittucha awe nkayammusha eeraka, “Owiittuchiha, khannona wiira niri ntatakoni?” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu nkoonkwa ni uchachera iphioo iyo, nkeera, “Mmaalhe! Ntondove!” Iphioo nkayaamaalha nkawakhalha shiriri. ");
INSERT INTO mgh2016_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yamalheke, Yesu nkeerelha owiittucha awe, “Chani woonaka mwaatti nrima inyu mwankani? Mwoovani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nansho yaari yoovaka chinene eerelhanaka ashineneru, “Phi ntu ani yolha? Mpaka iphioo chinomwiiwelhelha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ni owiittucha awe nkayaaphiya ukhopelhelhe nttiya no Ugalilaya, ilhapo yo Ugerasi. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Vavawo vaakhuruwa aya nkalhavani vawo, nkayankumaana ntu aakhuma umahiyeni. Yoyo aari ni mashoka o unanara, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","iyaakha chonkhaye aari akhalhaka umahiyeni, woochelhiyaka ummara mena unttuka mittondoro, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","wo mahuku onkhaye aari attukiyaka mittondoro mmietoni ni ipingu mmiononi mwoothe, nansho akwatulhachaka mittondoro ni ipingu chiyo. Aari ni machiri ahinooria uvariya ni ntu. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Uhiyu ni uthana woothe aari eetakachaka mmahiyeni ni mmiakoni, akhuwelhachaka ni wiikhavakacha ni malhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Vaamwonne awe Yesu utayi awaaka, ahontimakelha, ni unkhoromelha, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","akhuwelhaka, “Yesu, Mwaana a Nlhuku mulhupalhe! Urinani ni mii? Wo nchina na Nlhuku, kinoulhepelha ukihiye ukihitwarushe!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Olhumacha chiicho ukhalhawaya Yesu ari eeraka, “Nshoka no unanara, unhiye ulha ntu ulha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu nkankoha, “Nchina ninyu apani?” Ntu uyo nkaakhulha, “Nchina naka ‘Nlhoko’ hii niri enchi!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nkaathepaka ulhepelha ahoomolhelhiye vathe wo yeyo ilhapo iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vavawo vakittu vaari vahuwiyaka ikulhuwe chinchi chilhihiyaka vamwaakoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Paahi mashoka o unanara ayo nkayanlhepelha Yesu wiira “Nnirweeheke etu ukulhuweni, naakelheke.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu nkaarumelhelha, ni mashoka o unanara ayo nkayankhuma ntu ulhe arwaaka ukulhuweni. Ikulhuwe chiyo chaari chiphiyaka maelufu melhi. Nkachaattawa chikhuruwaka uhito mpaka munttiyani waatitiminre mmaashini. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Attu yaahuwa ikulhuwe ayo, nkayaattawacha awanelhihaka mwaha uyo mmawani ni mmamatani mwoothe. Attu nkayaawa onecheshe ikhumelhenlhe, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","vaaphilhe aya wa Yesu, nkayaamwona ntu o mashoka o unanara ulhe. Aari nakhanlhe ni Yesu, nawanre ikuwo ni irusho chawe mmuruni, onkhaye nkayoovacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Attu yoonne nkayaahimiachera akhunanaya yoyo mwaha uyo wa ntu aari ni mashoka o unanara ni ikulhuwe chilhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nkayanlhepelha Yesu wiira athame yeyo ilhapo aya iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu vaawelha awe nkalhavani, ntu anlhaminhe awe ikwerere yo mashoka o unanara ulhe ni uyo nkaalhepellha wiira, “Ni mii nkittukaneke.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nansho Yesu nkaankhotelha. Nkamwirelha, “Nhokolhieke uwani mwaahimiachereke amuchi inyu Athithi chinre aya wo uwonelhani ikiriri ni mitheko chiupangenlheni aya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Paahi etu ntu uyo nkaarwa Udekapoli, ahimiachaka chipangelhiye awe ni Yesu. Ni kila ntu eewa nkaashanga chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu nkaalhapuwa ukhopelhelhe nttiya. Wowo attu enchi nkayaawa umwiiwelhelhani. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nkaawa ntu eehaniya Yairo, mmoka aya emelhelha inupa yo unlhapelha Nlhuku, awaaka ni ukhoroma vamietoni wa Yesu ");
INSERT INTO mgh2016_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","anlhepelhaka wiira, “Mwaamwanaka nnati ri muukhwani. Chonte nngwe mwa mweeshere miono, alhame akhalhe nkumi!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu nkaarwa vamoka ni ayo wowo. Attu enchi nkayanttwara ananrukurenrie uno ni uno. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mmoka a attu anttwara yaari opani aawereia ireta yo ukhuma iphome, nchorochoro wo iyaakha khumi ni pilhi, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","akhalhaka anavinre wa anamirete enchi. Wo mahuku menchi yaari muuhuvani, amalhihaka nhakhu waya wonkhaye mmireteni athepaka uhuva. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nkeewa mwaha wa Yesu, ni ayo nkayaawa apephenyaka vatulhi vawe, ");
INSERT INTO mgh2016_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","echerelhaka munrimani wiira, “Kavarakaru tu ikuwo chawe, kinoolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nkammara mwiinjiro wawe iphome nkayatondova vavawo vavawo, eechonaka wiira aholhama ikwerere aya iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yeyo ikatema iyo Yesu nkaachuwelha wiira machiri ahonkhuma, ntu holhamihiya, nkaarukunuwa ni ukoha, “Mpani vanre mwiinjiro aka?” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Owiittucha awe nkayaamwaakulha, “Uno nnoonaka chinre aya wo uchara attu, nnokohani wiira mpani vanre mwiinjiro winyu?” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nansho Yesu nkaathepa umwaavia wo miitho ntu avanre mwiinjiro wawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wo uchuwelha wiira ahochuwelhiya, opani ayo nkaawa wiichonihani, athukumelhaka, nkaakhoroma, ni uhimiacha ikekhia yonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu nkaamwiirelha, “Mwaamwanaka, nrima ao uhoolhamiha. Urweeke wo mpuha, uhiwereiye tho yeyo ikwerere iyo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu vaari awe arerihaka nenno nlhove nno, nkaawa karumiya aya Nayairo, yayo o weemelhelha inupa yo unlhapelha Nlhuku ayo ni uhimia wiira, “Mwalhi inyu uyo hokhwa. Vano veeshiyani etu uthepa waahuvihacha Owiittuchiha?” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu khaalhonhe nenno nlhove nno, nkoolhumacha, eerelhaka o weemelhelha inupa yo unlhapelha Nlhuku ayo, “Pishakani nrima, nrumelhelheke. Mwalhi inyu nookhalha nkumi tho.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nkaachiichihacha attu unttwara, yaahikhalhe Napeturo ni Nayakhobo ni ahima aya Nayohana vekha. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nkayaaphiyacha uwani wa o weemelhelha inupa yo unlhapelha Nlhuku ayo, nkayaaphwanya ikutto yulhupalhe attu onlhachaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nkaakelha mpaani ni waakoha, “Mwaatti woonaka nnookhuwelha, nnonlhani? Mwalhi ulha khanakhwa, howiraka urupa!” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Attu nkayanthiacha, nkeerelha attu onkhaye akhume vathe, aahalhanaka manyanaangoro ni owiittucha awe araru, nkaarwa vaathalhalhiye awe mwalhi uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nkanthesha ni umwiirelha, “Talitha khumi.” Ulhamulhiya waya, “Mwalhi nkonkwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mwalhi nkeemelha ni uchokholha weeta. Aari nnati o iyaakha khumi ni miilhi. Vaapangia aya chechiyo attu aahanlhe anoomiye uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nansho Yesu nkaamuka wiira ahihimiache wa ntu, nkeerelha, “Mwalhi uyo avahiye yolhia.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu nkaathama wowo, nkahokolhia uwannyawe, attwariyaka ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nihuku no Wiittuwa nkaachokholha wiittuchiha wi inupa yo unlhapelha Nlhuku. Attu enchi aari mwommo, veewelhenlhe aya nkayaashangacha ni wiikoha, “Yolha pantte vayi chechilha irusho chilha? Apani anvanhee ikuru yo upanga cho ushangiha chi? ");
INSERT INTO mgh2016_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ama! Ulha kahiwe phi yolhe nokooroshacha milhako ni ihiche ulhe, mwaana a Amariamu, munnaya ashi Yakhobo ni Nayose ni Nayuda ni Nasimoni? Ashirokorawe kahiwena phi alha ninaakhalhana ihu alha?” Paahi etu nkayankhota. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu nkaahimeria wiira, “Namilhohi nottuniya ilhapo chonkhaye, yaahikhalhe uwannyawe ni wa amuchi awe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu khaapannge cho ushangiha vavawo, ihikalhe yo weeshera miono areta vakani nkaalhamiha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nkaashanga chinene, ukhalhawaya attu khayaari ni nrima. Yesu nkaavira eetakachaka iwani cho vakhiviru, eetuchihaka attu Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nkeehana owiittucha awe khumi ni elhi, ni waaruma elhielhi. Nkaavaha ikuru yo woomolha mashoka o unanara ");
INSERT INTO mgh2016_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","nkaalhehera wiira, “Vanorwaa inyu nhikushe ittu iriyoothe, nhiwie nrupa mena mashurupu mena nchurukhu vachiroroni, ihikalhe ikopo mmathathani. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mmwareke ikwakwata mmietoni, nansho nhikushe mwiinjiro wo nayelhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nkaahimeria tho wiira, “Vanophiya inyu vawani vanopocheria inyu, mwakhalheke vavawo mpaka vanohalha inyu uthama vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Vawani vahinopocheriya inyu ama uwiwelhelhani uhimiechesha winyu, mwathameke wo uhipicha uno ni ukukutta ntukurukhu nnyaani mwinyu wo waamuka!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Paahi etu nkayaarwaa uwaahimiacherani attu iphiro cho ukhoroma ni uhiya uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nkayoomolhacha mashoka enchi o unanara, ni waahika makhura areta enchi, ni waalhamiha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Paahi amwene Naherode o Ugalilaya nkayeewa mwaha wonkhaye, ukhalhawaya nchina na Yesu naari niwanelhaka ilhapo yonkhaye. Nkawaakhalha attu akina eera wiira, “Nayohana Obatiiza ahohihimmwa! Phi ayo ari ni ikuru cho upangacha cho ushangiha chi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ni attu akina eera, “Alha phi Naeliya.” Akhwawe nkayeera, “Ulha phi namilhohi, rii thoko mmoka a anamilhohi o khalhayi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nansho Naherode veewilhe aya ni ayo nkayeera, “Yalha phi Nayohana Obatiiza, kaahinthe aka alhe! Nansho vano ahohihimmwa!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ukhalhawaya Naherode phi alhehenre uvariya u Nayohana, ni waattuka ujeerani. Naherode enre chiicho wo nlhatu ni Naherodiya, aathenlhe aya, achuwelhaka wiira yaari ahanu a Nafilipo ahima aya Naherode ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nayohana ahaamuka Naherode wiira “Vavawo khampannge ittu yo urera ukelha manupa wa ahima inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chiichammo etu, Naherodiya ahorushiya chinene athananaka weeva Nayohana nansho wo uhoria oovaka Naherode. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Naherode aari oovaka Nayohana, ukhalhawaya ahochuwelha wiira aari ntu ntakatifu, ntu o nrima woombone, paahi etu nkeenanelha. Nkaachivelhiya weewelhelha, nansho uno achukulhaka munrimani wo malhove aahimeriya aya. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nkanaawa nihuku Naherodiya vaapantte aya nipesha. Naari nihuku no wuupuwelhiya uyaria u Naherode, vaalhatulhiye aya attu uwa uttapelhelhani. Yaalhatulhiye attu yaavara mitheko chulhupalhe, ni aholhelhi o Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwaamwanaya Naherodiya mwalhi, ahowa wiina vavawo, nkaatelhiha Naherode vamoka ni alheto aya onkhaye. Wo uteelhiya chinene, Amwene Naherode nkaamwirelha mwalhi uyo, “Unothanana kuuttuveke ishiyani? Uvekelheke ittu iriyoothe unothanana awo kinouvaha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nkayaalhupelha ni umwiirelha mwalhi uyo, “Kinoulhupelha wiira kinouvaha ittu iriyoothe unovekelha awo, inakhalhaka unvekelha umeelhiya inusu yo imwene aka!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwalhi uyo nkaarwa wa anumwanawe ni waakoha “Kavekelhekeni?” Nkaamwakhulha, “Muru u Nayohana Obatiiza.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nkaahokolhia wo waakuviaa wa Amwene ni uvekelha, “Kinothanana nkivahe naanano va muru u Nayohana Obatiiza mphacheni!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Amwene nkayaakelhiya ihuzuni chinene, nansho wo nlhatu wo ulhupelha waalhupenlhe aya, ni alheto yaakhalhanche vakaraamuni alhe, khayonrie unkhotelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Paahi nkaayanlhehera nsikari arwee awiihe muru u Nayohana. Nsikari nkaarwa, nkaahitha Nayohana, ");
INSERT INTO mgh2016_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nkaawiha muru mphacheni nkammaha mwaamwana a Naherodiya, ni uyo nkaavaha anumwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Owiittucha a Nayohana nkayeewa, nkayaawa ni ukusha iruttu aya, nkayaavitha umahiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Akarumiya nkayaahokolhiacha wa Yesu, nkayaahimiacha chittu chonkhaye chapannge aya ni weetuchiha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Attu yaawaachilhe aari milhoko minchi cha attu, Yesu ni owiittucha awe nkayoochelha ukhalha ni ulhia yolhia. Paahi nkeehanacha ni uwerelha wiira, “Nkanngwe neevithe mwiittuwe vakani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nkayaawelhacha nkalhavani nkaarwa vakittu vo wiivitha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nansho attu enchi nkayoona Yesu ni owiittucha awe vaathama aya nkayaachuwelha waarwaa aya, paahi nkayantwarelhelha wowo attimakachaka ni uphiya Yesu ni owiittucha awe ahinaphiyacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu vaakhuruwa awe nkalhavani, nkoona nlhoko mulhupalhe wa attu, nrima awe nkawaakelhiya ikiriri, ukhalhawaya attu yaari ahuvaka thoko ikhondoro chihiri ni nshunga. Paahi etu nkaachokholha weettuchiha chittu chinchi. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nchuwa veelha aya, owiittucha awe nkayanrweelha ni unhimeria wiira, “Uheelha vano, ni va vakittu va vauthakoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mwaahiyeke attu ayo wiira ahokolhie mmawannyaya ni mmamatani mmo arwee athume choolhia.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nansho Yesu nkaakhulha eeraka, “Mwaavaheke yolhia mwaattiva.” Owiittucha ayo nkayaakoha, “Nnothana wiira nirweeke nathumeke yolhia cho idinari imia pilhi?” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu nkaakohacha, “Nrina mikatte nchani? Nkarwaani mwaweheke.” Vaawenhe aya nkayaakhulha, “Chiri mikatte nthanu ni ihopa pilhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu nkaalhehera owiittucha awe tho wiira aanyulhacheke attu onkhaye ni waakhalhiha vathi vamanyashini. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Attu nkaakhalhihiya mmapuroni, va imia imoka, akina mapuro a attu makhumi nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu nkaakusha mikatte nthanu ni ihopa pilhi chiyo, nkaaweha miitho wiirimu ni unlhapelhelha Nlhuku. Nkaamianihacha ni waavaha owiittucha awe wiira yaakawelhacheke attu. Ni ihopa pilhi chiyo nkeera chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Attu onkhaye nkayaalhia ni uwona. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Paahi owiittucha nkayaarokottacha mahalhahalha o mikatte ni ihopa alhe, nkaakushacha ni uchariha makaya khumi ni melhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Milhoko cha manyaalhopwana chaalhilhie chaari attu maelufu nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yamalhekeru Yesu nkaakhanyereriha owiittucha awe awelhe nkalhavani anholhelhe Ubethsaida, ukhopelhelhe nttiya, uyo aahiyaka ni waalheha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Vaamanlhe awe waalheha attu nkaawelha umwaakoni ulhapelhani. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vaari aya uchechilho, ikalhava yaari variyari nttiya, ni Yesu aari vekha awe hinalhapuwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nkoona wiira owiittucha awe yaari athemwihiyaka ni iphioo, paahi vaatameria aya mapikoosha nkaawa, eetaka vachulhu maashi. Aari aatameriaka waaphwanya, ");
INSERT INTO mgh2016_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","vaamwona aya eetaka vachulhu maashi, nkayaanyihera wiira aari “Nshoka!” Nkayaakhuwelhacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Onkhaye yaari yoovaka chinene vaamwonne aya. Yesu nkoolhumacha eeraka, “Nvareke nrima! Phi mii Nhoove!” ");
INSERT INTO mgh2016_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nkaawelha nkalhavani, iphioo nkayaamaalha. Owiittucha ayo aari anoomiye uwanoni, ");
INSERT INTO mgh2016_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ukhalhawaya aari bado ahinachuwelhacha mwaha wo mikatte nthanu waalhiha attu maelufu nthanu. Mirima chaya chaari chihinachuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nkayaalhapuwa nttiya ni uphiya ilhapo yo Ugenesareti, veemenshe aya ikalhava. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Attu nkayanchuwelha Yesu vaakhuruwa awe nkalhavani. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nkayaarwaa ilhapo yonkhaye iyo, kila eewa wiira howa, nkaawiha areta aari mmalhilhini ni waarweha wowo. ");
INSERT INTO mgh2016_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nkaaviravira mmamatani ni mmawani mwonkhaye aalhamihaka attu aathalhelhiye mmapuwani mwaavira awe, akina anlhepelhaka inakhalhaka ammare ikuwo chawe, ni ayo ammanre onkhaye aholhama. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Amafarisayo akina ni owiittuchiha Malhehero yaakhumme Uyerusalemu nkayaathukumana wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nkayoona wiira owiittucha awe aalhia wo uhinyawa mathatha thoko cheera aya Amafarisayo wo weetuchiha attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ukhalhawaya Amafarisayo, ni Ayahudi onkhaye yaari avaraka ikano yeetuchihiye ni ashulhupalhe aya, yo uhilhia mpaka anyaweke mathatha rata thoko, ");
INSERT INTO mgh2016_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","mena khayoria ulhia ittu ithumiye unopangiya maronda wo uhihapihiya kaye. Ni vavawo yaari attwaraka ikano chikina chaahiye ni manyaapwiiya aya cho uhapiha ikahi ni chittu cho uterekelha chikooroshiye wo ishaba. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Paahi etu Amafarisayo ni owiittuchiha Malhehero a ashinna Musa nkayankoha Yesu wiira, “Veeshiyani owiittucha inyu khanottwara ikano cha ashulhupalhe, ni ulhia wo uhinyawa mathatha rata thoko chaalheheriye?” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu nkaakhulha, “Mwa anafiki inyu, ashinna Isaya ahoolhumacha rata thoko chilhepilhe aya wiira, ‘Nlhuku hohimia, anokithimicha wo malhove aya, Nansho mirima chaya chiri utayi ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ukithimicha waya khunlhoka, Ukhalhawaya aneetuchiha malheheriyo o mwaattuniru, Thoko aneetuchiha malhehero a Nlhuku!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mwaatti nhohiya malhehero a Nlhuku ni uvara ikano cha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu nkaathepa wiira, “Mwaatti nhanaa irusho chinene cho urukunusha malheheriyo a Nlhuku ni uttwara meettuchiho inyu mwaashinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ukhalhawaya ashinna Musa aheera wiira ‘Mwaathimicheke athumwaninyu ni anumwaninyu, ni ntu riyoothe naaruwana athumwanawe ama anumwanawe yoyo nambaya eeviye.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nansho mwaattiva nneetuchiha wiira yakhalhaka ntu hanaa ittu yo waavaha athumwanawe ama anumwanawe uno ehanaka yeyo ikorobani, maana aya izawadi ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yeyo khinolholka tho uvahiya athumwanawe ama anumwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chiichammo etu, phi norukunusha inyu nlhove na Nlhuku wo chittu chinchi thoko chii nnopangacha inyu chi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu nkeehanacha milhoko cha attu eerelhaka, “Nkakiiwelhelheni mwaattiva, ni uchuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khiiwo ittu inonkelha ntu mwiiruttuni mwawe inonnanariha. Nansho ittu inokhuma munrimani phi no nnanariha ntu. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri ni maaru, eeweeke!” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Athameke vaattuni vawo ni ukelha nnupani, owiittucha awe nkanvekelha wiira aalhamulhelhe nenno nlhikaaniho nno. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu nkeera, “Ata mwaatti khanchuwenlhe waapwaha attu akina ayo? Inyu khanchuwenlhe wiira khiiwo ittu inonkelha ntu mwiiruttuni ikhumaka vathe inonnanariha ntu? ");
INSERT INTO mgh2016_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ukhalhawaya khinkelha munrimani mwawe, nansho munthunkwani kaye, kaanyuma kukhumaka mwiiruttuni, urindini. Wo uhimia chiicho Yesu ahoreriha cholhia chonkhaye wiira chihorera ulhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nkaathepa uhimia wiira, “Ilhe inonkhuma ntu ilhe phinonnanariha. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ukhalhawaya munrimani mwa ntu, mwommo phi nokhumelhelha chittu cho unanara, cho wiiya, cho niiviho, cho ulhavalhava ");
INSERT INTO mgh2016_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cho ulhuva, ilhema, ihache, itiamaru, wiichoona, uruwana ni chittu cho uhilhoka ");
INSERT INTO mgh2016_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","chechiyo cho uhilhoka chiyo chinokhuma munrimani mwa ntu chinonnanariha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu nkaathama vavawo, ni urwaa ilhapo yaatamana ni iwani yo Utiro. Nkaakelha inupa yaaphiyenlhe awe hittunaka attu achuwelhe wiira aari wowo, nansho khoonrie wiivitha. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Opani amoka, aari ni mwaamwanaya nnati aavariye ni nshoka no unanara, nkayeewa nkayanrweelha Yesu, nkayeewulhusha vamietoni vawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yayo khayaari Ayahudi, nansho aari o nikosho no Ayunani o ilhapo yo Usiriya. Nkayanlhepelha Yesu oomolhe nshoka no unanara nammara mwannati aya uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nansho Yesu nkaakhulha eeraka, “Naawoniheke thoko ashaana. Ukhalhawaya khavanorera waathurulha ashaana yolhia aya ni waawonyera ashipwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yayo opani ayo nkaamwakhulha Yesu eeraka, “Eiyo Thithi, nansho ata yayo ashipwa ari wuuthi imeza ayo anoorokottacha chittu chinomoramora chiyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu nkeera, “Chinre inyu wo waakhulha rata chiyo, nhokolhieke uwani, nnokophwanya nshoka nno ninanthamme mwaninyu uyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Paahi etu nkaahokolhia uwani ni umphwanya mwannati aya narumpe vankorini, nshoka ninanthamme. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yamalhekeru Yesu nkaathama ilhapo yaatamana Utiro nkaarwa mpaka ibahari yo Ugalilaya avirelhaka Usidoni, apwahaka ilhapo yo Udekapoli. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Attu nkayammwihera ntu ohiiwa ni uhuulhumacha rata, anlhepelhaka wiira amweeshere miono. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Paahi etu Yesu nkaamweemesha vachereshere wo vekha awe, nkanhelha makokho mmaaruni, nkanshuwelha ishenye ni unkwakwanya nlhimi. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nkaaweha wiirimu ni umumulha wo machiri eeraka, “Efatha” ikhalhaka, “Nttukuwe!” ");
INSERT INTO mgh2016_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Maaru nkaatiuwa ni nlhimi nkanaattukuwa nkoolhumacha rata. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu nkaamuka wiira ahivire ahimiachaka, nansho cheera awe wo waachiichiha ni ayo phi athepa aya uvira ahimiachaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ni kila ntu eewa aari ashangaka. Aahalha eerelhanachaka wiira, “Hopanga chonkhaye voombone! Weewiha ohiiwa ni waattukulha o uhulhumacha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Navireke nihuku nimoka, nlhoko wa attu enchi akhwawe nkawaawa. Attu vaari aya awolhiyaka ithalha, Yesu nkeehanacha owiittucha awe ni weerelha, ");
INSERT INTO mgh2016_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kinowoonelha ikiriri attu alha, wiira ari ni hii wo mahuku mararu wo uhilhia. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kaahiyaka wiira ahokolhie mmawannyaya wo uhilhia, anookomwaacha mphironi, ni akina ayo akhume utayi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Owiittucha awe nkayankoha, “Ninohalha upatta vayi yolhia yo uwanelha attu onkhaye alha ni va vanari vauthakoni?” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu nkaakoha, “Nrina mikatte nchani?” Nkayaamwakhulha wiira, “Chiri mikatte saba.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu nkaalhehera wiira attu akhalhihiye vathi. Nkaawiaa mikatte saba chilhe, nkanthimicha Nlhuku, nkaamianihacha, nkaavaha owiittucha awe avire aakawelhaka attu onkhaye. Ni ayo nkayaakhawelhacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ni vavawo chahokhalha tho ihopa vakani. Yesu nkaakusha ni ulhapelhelha wa Nlhuku ni weerelha owiittucha awe avira aakawa ni chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kila ntu nkaalhia nkaawona. Owiittucha nkayaakusha makaya saba ni uvira aakhupachaka mahalhahalha aahalhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Attu yaalhilhie ayo yaari maelufu ncheshe. Paahi etu Yesu nkaalheha attu wiira athamache, ahokolhiacheke mmawannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","wo uhipicha nkaawelha nkalhavani, nkaarwa ilhapo yo Damanuta vamoka ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amafarisayo nkayanrwelha Yesu ni uchokholha umwaakhulhana. Yaari athananaka unria wiira apange cho ushangiha chihimiecheshe ithikineha cho wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu nkaachukulha chinene munrimani, nkaahimia wiira, “Chani mwaatti o ilha iyari ilha woonaka nnochukulhelha woona cho ushangiha? Ikekhia kinouhimeriani wiira, khiiwo ithikineha inohalha woonia ni ilha iyari ilha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nkaathama vavawo, ni uwelha tho nkalhavani, alhapuwelhaka ukhopelhelhe nttiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Owiittucha yaari analhiyanlhe ukusha mikatte, yaakunshe nkatte mmoka tu. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu nkaamuka eeraka, “Nhiitialhe, mwiichinanelheke ni ihengedure ya Amafarisayo ni uhilhoka u Naherode.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Owiittucha nkayaahalha akohanachaka ashineneru, “Ana neera chiicho wo nlhatu no uhikusha mikatte?” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu nkaachuwelha munrimani ittu yaachukulhacha aya, nkaakoha, “Nlhatu wani woonaka nnowiithemwiha wo nlhatu no uhikusha mikatte? Khannaya uchuwelha? Mirima chinyu chiri chikani? ");
INSERT INTO mgh2016_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Woonaka miitho nhanaa nansho khannoona, nhanaa maaru nansho woonaka khanneewa? Khannoopuwelha ");
INSERT INTO mgh2016_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","vaamelhe aka mikatte nthanu ni waalhiha attu maelufu nthanu? Mwaakushilhe makaya nchani yaachanre mahalhahalha o mikatte?” Nkayaakhulha “Khumi ni melhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu nkaakoha tho, “Vaamelhe aka mikatte saba ni waavaha attu maelufu ncheshe valhe mwaarokottanche ni ukusha makaya nchani o mahalhahalha?” Nkayaakhulha “Saba.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu nkeera, “Khannachuwelha mpaka nna?” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu nkaaphiya Ubethsaida, wowo attu nkayammwiihera ntu ohoona ammare anlhamihe. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu nkammara moono ntu ohoona uyo mpaka uchereshere iwani. Nkanshuwelha ishenye mmiithoni, nkaamweeshera miono ni unkoha, “Chani nnowona vano?” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yoyo ntu uyo nkaaweha uchulhu, nkeera, “Eiyo, kinowoona attu, nansho anoonia thoko miri chineeta.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu nkaamweeshera miono tho vamiithoni. Ni uyo nkaaweha chinene, nkoona rata. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu nkaamwirelha wiira ahokolhie uwani uno anchiichihaka wiira, “Nhihokolhelhe vawani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ni owiittucha awe nkayaarwaacha iwani chaatamana ni Ukaisariya Filipi. Mphironi nkaakohacha, “Nkakihimerieni mwaatti, attu aneera mii phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nkayaamwaakhulha, “Akina aneera Nayohana Obatiiza, akina anowiihanani Naeliya, akina anowiihanani namilhohi nkina.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nkaakohacha ni ayo, “Aye, ni inyu mwaattiva nneera mii phi mpani?” Napeturo phi aakhunlhe eeraka, “Inyuva phi Kuristo Moopolhi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu nkaamuka wiira, ahinhimiachere ntu riyoothe yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu nkaachokholha weettuchiha owiittucha awe wiira, Ihokhalha lazima Mwaana a Ntu ahuvihachiye ni ukhotiya ni ashulhupalhe, o opochera ishaani olhupalhe ni owiittuchiha Malhehero a ashinna Musa. Nowa eeviya nansho nihuku no neraru nohihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu nkaahimiacha chechiyo mwaari. Napeturo nkayankusha Yesu vachereshere urwaa unchacherani. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nansho Yesu nkaarukunuwa, ni waaweha owiittucha awe ni wachachera Napeturo eeraka, “Uthame vaa, uwe Nakare irusho chawo chinoopuwelha chittu cho mwiiruttuni va, wo uhupuwelha chittu chinommweha Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yamalhekeru, Yesu nkeehanacha nlhoko wa attu vamoka ni owiittucha awe ni weerelha wiira, “Yakhalhaka hawo ntu nothanana ukitwara, paahi eeruneke mwanene akusheke nsalaaba awe akittwareke. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ukhalhawaya ntu neechopolha ukumi awe mwanene, yoyo nowiipoteriha, nansho nohiya ukumi awe wo nlhatu na angu mii ni wo Malhove Orera yoyo nowichoopolha. ");
INSERT INTO mgh2016_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chani attu anopattani vanopatta aya mpuha wo mwiilhaponi, uno apoterihaka ukumi aya? Khiiwo! ");
INSERT INTO mgh2016_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ama ntu nohalha ukumiha ittu yaani yo ulhikaanihiya, apatte tho ukumi? ");
INSERT INTO mgh2016_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ntu o iyari yo uwonya ilha, oonaka ishoni ukihimiacha ni woonelha ishoni malhove kineetuchiha aka, Mwaana a Ntu nowa umoonelha ishoni vanottuna awe uwa wo nthimicho wa Athumwane ni minepa cho wiirimu chitakatifu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu nkaathepa uhimiacha eraka, “Wo ikekhiaye, kinouhimeriani wiira, ahawo akina vaa ahinowa aakhwa mpaka vanohalha aya woona Imwene ya Nlhuku ikhuruwaka wo machiri.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yavireke mahuku sita, Yesu nkaakusha Napeturo ni Nayakhobo ni Nayohana umwaakoni waakhalhanne awe vekha aya. Wowo Yesu nkaarukunuwa ikhove, ");
INSERT INTO mgh2016_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ikuwo chaawanre awe nkachaatelha ttuuu utelha vahinooria awe ntu riyoothe velhaponi vaa uteelhiha thoko chiichammo. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Paahi owiittucha araru ayo nkayoona Naeliya ni ashinna Musa yaarerihaka ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Napeturo nkaamwiirelha Yesu wiira, “Owiittuchiha, vahorera wiira nirii vaa! Ninouthekelhani mahema mararu, nawinyu ni Ashinna Musa ni Naeliya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Olhumacha chiicho wo uhichuwelha, vamoka ni akhunanaya ayo yaari ahalhaka anoomiye uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nkanaakhuruwa nihute nkanaakhunelha, ni nlhove nkaneewaniaa nnihuteni neeraka, “Ulha phi Mwaamwanaka kinonttuna aka, mmwiwelhelheke yoyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Vaawenhe aya tho, khaawo ntu oonelhe ahikhalhe Yesu vekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Vaakhuruwa aya umwaakoni, Yesu nkaamuka wiira, “Nhinhimiachere ntu riyoothe chittu chonne inyu, mpaka nihuku no uhihimmwa Mwaana a Ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nkayanrumelhelha, nansho akakohanachaka ashineneru, “Phi nlhove naani nenno no uhihimmwa unookhwani nno?” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nkayankoha Yesu, “Woonaka owiittuchiha Malhehero a ashinna Musa aneera wiira Naeliya phi nohalha uchokholha uwa?” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu nkaakhulha eeraka, “Naeliya phi nohalha uholhelha uwa awe eesha tayari chittu chonkhaye. Nansho veeshiyani ulhepiya wiira Mwaana a Ntu nowa uhuvihiya ni ukhotiya? ");
INSERT INTO mgh2016_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kinouhimeriani wiira, Naeliya ahomalha uwa ni ayo nkaapangelhachiya chaathananne aya thoko chilhepiye ni Malhove Matakatifu, chaachaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Veethakaniha aya ni owiittucha akina aahanlhe utulhi ayo, nkayaaphwanya attu enchi anaarukurenrie vamoka ni owiittuchiha Malhehero akina akohanachaka malhove. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Attu vaamwonne aya Yesu nkayaashangacha, nkayanttimakelha unshikuriani. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu nkaakoha owiittucha awe, “Nnokohanachani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nkaakhulha ntu mmoka eeraka, “Owiittuchiha, mii kihommwiiha mwaamwanaka uwaninyu hovariya ni mashoka o unanara hooriaka wulhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vanonchokholhacha aya, ninommulhushaka vathi ni niphoru ninkhumaka mmwano, ni ukhuura miino, iruttu imuumaka nko. Kahaalhepelha owiittucha inyu, nansho khayonrie unlhamiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu nkaahimia wiira, “Inyu mwaatti iyari yo wuuma mirima va! Kinohalha ukhalha ni inyu mpaka iyaakhani? Kuuvilhelhekeni mpaka iyaakhani? Mummwiiheke mmirawo uyo vaa!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nkanrweha mwammirawo uyo wa Yesu. Nshoka vaamwonne awe Yesu, mwaana vaarweehiya awe, nkanammulhusha mmirawo uyo vathi ni umuumiha, ni unkumiha niphoru uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu nkaakoha athumwanawe mmirawo ayo. “Nothemwihiya toka iyaakhani?” Athumwanawe mwammirawo ayo nkayaakhulha, “Uchokholha vaari awe mwaana mwankani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Athepaka uhimiacha wiira, “Venchi vanowulhushia awe, nshoka nithananaka umwiiva wo ummulhushera vamooroni ni vakina mmaashini. Nnonelhe ikiriri, mworiakaru munlhamihe!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu nkeera, “Nneera kooriaka! Kila ittu inoworia wa ntu norumelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Vavawo athumwanawe mmirawo ayo nkayaakhuwelha yiiraka, “Kinorumelhelha, nansho vakani. Nkihelheke nrima!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu nkoona wiira attu anoothepa uncharaanelha, paahi nkaachachera nshoka nno, “Kinolheherani inyu nshoka no unanara no ohiiwa ni uhuulhumacha nthame, nhinhokolhelhe tho!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nshoka nkanaakhuwelha, nimmulhushaka mmirawo vathi ninhelhaka ichilhichilhi ni unthama. Mmirawo nkaahalha narumpe thoko ntembo, yeeriaka, “Hokhwa!” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nansho Yesu nkanthesha ammaraka moono umweemesha, nkeemelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Vaakenlhe awe nnupani, owiittucha awe nkayankoha wo ntemera wiira, “Ana chani woonaka hii khanoonrie woomolha nshoka nne?” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu nkaakhulha eeraka wiira, “Nshoka no nikosho thoko nna khaninooria uthama wo uhittuka ni ulhapelhiya kaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ni owiittucha awe nkayaathama vavawo ni ulhukama ilhapo cho Ugalilaya. Yesu khaathananne attu achuwelhe wiira ri vayi, ");
INSERT INTO mgh2016_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ukhalhawaya aari eetuchihaka owiittucha awe. Eetuchiha wiira, “Mwaana a Ntu nowa uvariya ni urweehiya wa attu anohalha umwiiva. Nansho, nowa uhihimmwa nihuku noneraru naya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nansho khayaachuwenlhe ittu yeetuchihiya aya, nkayamwoova unkoha. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nkayaaphiya Ukapenaumu. Vaari aya mpaani, Yesu nkaakoha owiittucha awe wo wiira, “Mwaatti mwaarerihani mphironi mmwe?” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Khaawo aakhunlhe, ukhalhawaya vaari aya mphironi ittu yaakokohanacha aya ashineneru yaari mpani ri mulhupalhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu nkaakhalha nipuro, ni weehana owiittucha khumi ni elhi, ni waahimeria wiira, “Ntu nothanana uholhelha yoyo hothananiya ukhalha o uttia nkhora uno akhalhaka namitheko a attu onkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nkankusha mwanhima, nkaamwemesha variyari aya. Nkankwapata ni uhimia wiira, ");
INSERT INTO mgh2016_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ntu nompochera mwanhima thoko ulha, aromolhaka nchina naka, hokipochera mii, ni uyo nokipochera, khakiponchere mii vekha haapochera ni ayo akirumilhe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nayohana nkayeera, “Owiittuchiha, nahomwona ntu omochalhaka mashoka o unanara aromolhaka nchina ninyu, ni hii nkananchiichiha, ukhalhawaya kahena mmoka ninonttukana ihu munlhokoni mwihu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu nkaakhulha nkeerelha, “Nhaachiichihe khaawo ntu nooria upanga cho ushangiha wo nchina naka nkoolhumacha chittu cho uhilhoka. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ukhalhawaya kila ntu hinonikhota yoyo ri awihu. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kinouhimeriani wo ikekhiaye wiira ntu nohalha uvahani maashi o uwuria wo nchina naka, ukhalhawaya mwaatti phi attu a Kuristo, yoyo nowa upatta nttuvo nawe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ntu riyoothe nohalha waattekiha alha ashinkani anokirumelhelha alha, yoyo nambaya attukelhelhiye nshilho nshikoni mwawe ni utumbucherihiya mbaharini. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mwoonaka moono inyu uhoottekihani, nambaya utupulhiye! Iri nambaya uhikhalha ni moono mmoka ni ukelha uukumini kuliko urihiya umooroni Ujehannamu nnari ni miono miilhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mwommo miunku chaya khachinokhwa ni mooro uyo khunotiphia. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mweto chiicho, wo uttekihakani, ntupulheke! Nambaya ukelha uukumini ni mweto mmoka kuliko urihiya umooroni Ujehannamu. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wowo miunku chaya khachinokhwa ni mooro uyo khunotiphia. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Niitho ninno noottekihakani, nkhulheke! Nambaya ukelha uphioni wi Imwene ya Nlhuku nnari ni niitho nimoka kuliko urihiya umooroni Ujehannamu mmwehaka ni miitho melhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wowo ‘miunku chaya khachinokhwa, ni mooro aya khuntiphia.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila mmoka, noteelhihiya wo mooro thoko inama chinohelhiya aya maakha. ");
INSERT INTO mgh2016_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maakha ari o uchiva, nansho athuwaka anohalha uchiva chani tho?” “Nchiveke thoko maakha wo wiiwanana mwaashineneru, nkhalheke mumpuhani mmanupani mwinyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ahothama yeyo ilhapo iyo nkaarwa Uyudea, alhapuwaka mwoolhoko wo Uyorodani. Attu enchi nkayaawacha umwiiwelhelhani, nkeettuchihacha thoko chaalhemalhenlhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amafarisayo akina nkayaawacha unlhikachani unkoha, “Chani nnihimerie inoorera ntu waahiya amwaarawe?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu nkaakhulha eeraka, “Ashinna Musa aalhehenre chani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ni ayo nkayeera, “Ashinna Musa aalhehenre wiira, nlhopwana aahiyeke amwaarawe ni waavaha italaka yo umwalhaana.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu nkaahimia tho, “Ashinna Musa alhempe nlheheriyo nno chiicho ukhalhawaya mwaatti nri o ulhipa mirima. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nansho toka woopiye aya ilhapo, ‘Nlhuku ahomuupa nlhopwana ni nthiyana,’ thoko chilhepiye aya. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Wo yoyo nlhatu uyo etu nlhopwana noothama uwannyawe wa athumwane ni wa anumwane ni ulhutaana ni ahanu awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ni yayo elhi ayo anothathuwa ukhalha iruttu imoka. Ahikhalhaka elhi tho ihikhalhe iruttu imoka.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Paahi etu chilhutaanihiye ni Nlhuku, ntu himwalhaanihe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Vaari aya mpaani, owiittucha awe nkayankoha Yesu nenno nlhove nno. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nkaakhulha eeraka, “Ntu naamwalhaana ahanu awe, ni waaveka athiyana akina yoyo holhavalhava waattekelha ahanu awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ni athiyana chiicho, anaamwalhaana owannyaya ni uthelhiya ni alhopwana akina ahowonya, aholhavalhava.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nkaawihachiya achishaana ashinkani awe eeshera miono, nansho owiittucha nkayaachiichihacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu vonne awe nkaarushiya nkeera, “Mwaahiyekeni ashaana awe uwannyaka, ukhalhawaya Imwene ya Nlhuku phi yawaya achishaana thoko yayo. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kinouhimeriani ikekhiaye wiira, ntu riyoothe hinopochera Imwene ya Nlhuku thoko vanompochera awe mwaana mwankani khanowa ukelha mwommo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nkaapocheracha mmiononi mwawe nkaakumbatira, nkeesheracha miono ni waavaha ibarakha. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu vaarwaa awe nkwaha nkhwawe, ntu mmoka nkaanttimakelha, nkankhoromelha, ni unkoha, “Owiittuchiha orera nrima, kipangekeni kipatte ukumi wo uhimalha?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu nkankoha, “Woonaka nnokiihana orera nrima? Khaawo ntu ri orera nrima ahikhalhe Nlhuku vekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nhochuwelha malheheriyo, ‘Nhilhavelhave, nhiive, nhiiye, nhimwootherie ntu, nhoothache, mwaathimicheke athumwaninyu ni anumwaninyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ni uyo nkaarumelhelha wo wiira, “Eiyo Owiittuchiha chechiyo chonkhaye chiyo kihovara toka kinari mwanhima.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu nkammweha wo unttuna ni umwiirelha, “Nhohalhiha ittu imoka. Vano nrweeke mwathumiheke chonkhaye chirina inyu ni wakawelhacha attu ahirina, mwiicheshereke nhakhu wiirimu. Mwamalhihaka nkittwareke.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yoyo ntu uyo eeweke chiicho, nkaathama achukulhaka munrimani ukhalhawaya aari ntu o nhakhu chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu nkaaweha uno ni uno nkeerelha owiittucha awe, “Vanowa urika wa attu o nhakhu ukelha wi Imwene ya Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Owiittucha awe nkayaashangacha wiiwa malhove ayo, nansho Yesu nkaahimia tho eeraka, “Achishaanaka, varii vakittu voorika wa ntu ukelha wi Imwene ya Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nansho iri vo urikarika chinene wa ntu o nhakhu ukelha Imwene ya Nlhuku upwaha ingamiya uperetta niitho no ntotto no utottelha ikuwo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Owiittucha awe ayo nkayaathepa ushanga, nkaahalha akohanaka, “Apani etu, anohalha ulhama?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu nkaaweha tho, nkeera, “Vaattuni khavanooria, nansho kuhiwe wa Nlhuku, ukhalhawaya wa Nlhuku chonkhaye chinowooriacha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Napeturo nkayaahimia wiira, “Ni hii, nihohiya chittu chonkhaye nihoottwarani inyuva.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu nkaakhulha, “Eiyo, kinouhimeriani wo ikekhiaye wiira kila ntu hiilhe inupa awe ni achihimawe ni manyaarokorawe ni athumwanawe ni anumwanawe ni achishaana awe ama imata chawe ni ukitwara mii, ni Malhove Orera, ");
INSERT INTO mgh2016_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nowa ulhiviya imara imia ikatema yo naanano ilha. Mamia menchi upwaha inupa, manyaarokorawe ni manyaonnawe ni anumwanawe ni ashaana ni imata ni uhuva, ikatema inowa nowa upochera ukumi wo uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nansho attu anoholhelha vano anowa ukhalha utulhi, ni ayo ari vatulhi vano anowa uholhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ni owiittucha awe yaari munkwahani arwaaka Uyerusalemu. Yesu mwanene aari naholhenlhe, owiittucha awe yaari yoovaka, vamoka ni attu onkhaye aattukanne aya yaari yoovaka. Yesu nkaawiacha tho untemerani uchereshere khumi ni elhi alhe, uwaahimeriani mwaha wo chittu chinohalha unkhumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesu nkeerelhacha, “Mwiiwelhelheke mwaatti, nna vano ninokelha Uyerusalemu ni uwo Mwaana a Ntu nokoohelhiya mmathathani mwa attu opochera ishaani olhupalhe ni owiittuchiha Malhehero, ni ayo anowa unhukumulha wiira eeviye arweehiyaka wa attu ahiri Ayahudi, ");
INSERT INTO mgh2016_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","anohalha untikulhacha ni unshuwelha ishenye ni umwaata ikopo ni umwiiva, nansho nihuku no neraru noohihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nayakhobo ni Nayohana ashaana a Nazebedayo yahonrwelha Yesu ni umwiirelha, “Owiittuchiha, ninolhepelha nnipangelhe ittu ninothanana ihu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu nkaakoha, “Nnothanana kuupangelhekeni ittu yaani?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nkayeera, “ninolhepelha wiira mmwe mwaanesha amoka wiimonono winyu ni nkina wiimushi winyu vanohalha inyu ukhalha unthimichoni wi Imweneni wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu nkaahimia “Kinoona wiira mwaattiva khanchuwenlhe ittu inolhepelha inyu. Nnoworia mwaattiva uwureria ikikombe kinohalha aka uwureria mii? Ama nnoworia ubatiiziya ubatiizo kinohalha aka ubatiiziya mii?” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nkayaamwaakhulha, “Eiyo ninoworia.” Yesu nkaahimia wiira, “Eiyo nnoworiaa uwureria ikikombe inohalha aka uwureria ni ubatiiziya thoko kinohalha aka ubatiiziya mii. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nansho mwaha wa apani akhalhe wiimonono ama wiimushi, yoyo khuri mmathathani mwaka. Nlhuku phi nohalha waavaha yayo mapuro ayo attu athanlhiye.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Owiittucha akina khumi alhe veewilhe aya, nkayaarushiya nkayaathunalhelha Nayakhobo ni Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu nkeehanacha onkhaye ni waahimeria wiira, “Nhochuwelha wiira attu anaatawara attu ahiri Ayahudi wo machiri ni aholhelhi aya ahanaa ikuru wa attu anaatawara aya. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nansho uwaninyu mwaattiva ihikhalhe chiicho, namitheko nothanana ukhalha mulhupalhe inyu yoyo apachereke thoko ukhalha namitheko a ashikhunanawe. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ntu riyoothe nothanana woonia nari miholho, yoyo hothananiya ukhalha ipotta ya akhunanawe kaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ukhalhawaya Mwaana a Ntu khaawilhe awe aapangelhiya mitheko, aawiilhe ukavihera ni ukumiha ukumi awe woopolha attu enchi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nkayaaphiya Uyeriko, ni vavawo Yesu vaathama awe vamoka ni owiittucha awe ni nlhoko wa attu uttwaraka, ntu mmoka ohoona aakhalha avekelhaka, mwaana a Natimayo ehaniya Batimayo aari nakhanlhe vachereshere iphiro. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Veewilhe awe wiira aari Yesu o Unazareti phi novira, nkaachokholha ukhuwelha, “Yesu! Mwaana a Adaudi! Ukoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nkaachacheriya ni attu wiira amaalhe. Nansho uyo nkaathepa ukhuwelha “Mwaana a Adaudi, ukoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu nkeemelha ni wiira, “Nkamwiihaneni.” Nkeehaniya eerelhiyaka, “Uvareke nrima! Wunkweke, howiihana.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nkaariha mwiinjiro awe nkaaathupulhuwa ni urwaa wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu nkankoha, “Unothanana kuupangelheke ittu yaani?” Batimayo nkaakhulha, “Owiittuchiha kinolhepelha wiira koone.” ");
INSERT INTO mgh2016_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu nkaamwirelha, “Urweeke, nrima ao uhoolhamiha.” Yeyo ikatema nkaalhama ni uweha nkanttwara Yesu mwaavira awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Vaatameria aya Uyerusalemu, ahophiya iwani cho Ubetifage ni Ubethaniya, nkayaarwaacha waatamana Mwaako wo Mizeituni. Vavawo Yesu nkaaruma owiittucha awe elhi uholhelha ");
INSERT INTO mgh2016_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aalheheraka wiira, “Rwaakani yeyo iwani iri uholho iyo. Wowo nnokomphwanya mwaaphuta nattukelhelhiye hineetihiya ni ntu. Mwanthaphulheke ni ummwiiha vaa. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ntu riyoothe okohakani ‘nlhatu waani’ mwaakhulheke wiira, ‘Athithi phi nonthanana, anonhokolhosha chitema.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nkayaarwaa ni umphwanya mwaaphuta nattukelhelhiye vanlhakoni. Vanthaphulha aya ");
INSERT INTO mgh2016_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ashinene nkayaakohacha, “Chani woonaka nnothaphulha mwaaphuta uyo?” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ni ayo nkayaakhulha eeraka thoko cheetuchihiye aya ni Yesu, ashinene ayo, nkayaahiyera. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nkayanrwehelha Yesu mwaaphuta uyo, nkayaathalhacha ikuwo chaya vanthanani uno Yesu akhalhaka vachulhu vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Attu enchi, nkayaathalhacha ikuwo mphironi akina athalhaka maphumbulhu o miri yaatupunlhanche aya mmamatani ni waathalhacha mphironi mwaavira awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Attu aaholhenlhe ni alhe aattwara utulhi nkayaakhuwelha eeraka, “Hosana, atotopelhiye uyo nowa wo nchina na Athithi uyo! ");
INSERT INTO mgh2016_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uvahiye ibarakha umwene unowehereriya wa athumwanihu Amwene Adaudi, Atotopelhiye Nlhuku wiirimu!” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu nkaaphiya Uyerusalemu, nkaarwa mpaka Inupa ya Nlhuku, nkaawehaweha chittu chonkhaye. Nansho ukhalhawaya waheelha, nkaarwa Ubethaniya vamoka ni owiittucha awe khumi ni elhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nihuku no nayelhi, vaakhuma aya Ubethaniya, Yesu aari nawolhiye ithalha. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nkoona utayi mwiri wo ntini unaphuwilhe, nkaachushera awehe yakhalhaka uhemma arukulhe ittini alhie. Nansho aphiyeke khoonne ittu ahikhalhe mathaakhururu, ukhalhawaya waari uhinemma. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu nkaalhava mwiri wo ntiini uyo eeraka, “Khaawo ntu nohalha ulhia ittini chinyu tho mahuku onkhaye!” Owiittucha awe nkayeewa voolhumacha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Vaaphilhe aya Uyerusalemu, Yesu nkaarwa u Inupa ya Nlhuku yulhupalhe, nkoomolhelha vathe attu onkhaye yaathumiha chittu ni ayo yaathuma. Nkaapitingushacha imeza cha attu yaakakanihana nchurukhu, ni ihiche cha attu othumiha ikhunda, ");
INSERT INTO mgh2016_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ahinhiyereraka ntu riyoothe ukusha ittu u Inupa ya Nlhuku mmo. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yamalhekeru, nkaachokholha weettuchiha attu, “Malhove Matakatifu aneera, Nlhuku hohimia wiira, ‘Inupa aka inowa wiihaniya inupa yo ulhapelha ya attu o makosho onkhaye.’ Nansho mwaattiva nhorukunusha ni upanga nikhuku no attu o uvara makhuche!” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Opochera ishaani olhupalhe ni owiittuchiha Malhehero veewilhe aya, nkayaachokholhacha waavia iphiro yo umwiivelha Yesu. Nansho yaari amwoovaka, ukhalhawaya milhoko chonkhaye cha attu chaahanlhe muushangani wo meettuchiho awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Uchechilho, Yesu ni owiittucha awe nkayaathamacha vawani vawo. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wichishuru, vaari aya aviraka mphironi, nkayoona mwiri wo ntiini. Waari unoomilhe uchulhu mpaka vanteponi. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Napeturo nkayoopuwelha ni umwiirelha Yesu, “Owiittuchiha mwooneke! Mwiri wo ntiini waalhanve inyu ulhe uhooma!” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu nkaakhulha eeraka, “Mpisheke nrima, munkhulhuvelheke Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kinouhimeriani wo ikekhiaye wiira ntu erelhaka ulha mwaako ulha uthame waatitiminre ubaharini, wo nrima wo uhiri ni nipampa, wiira inowooria, inowooriacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Paahi etu kinouhimeriani wiira, vanolhapelha inyu ni uvekelha chittu chiri choothe, nrumelhelheke wiira nnoopochera, ni inyu nnoovahiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Vaneemelha inyu ulhapelha, nchokholheke thoko uhiyerera milhatu cha attu ottekenlheni ni Athumwaninyu ari wiirimu anouhiyererani milhatu chinyu. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nansho mwaahahiyerereke akina milhatu chaya, Athumwaninyu o wiirimu khanouhiyererani ni inyu uwonya winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nkayaawa tho Uyerusalemu. Yesu veetakacha awe Inupa ya Nlhuku, opochera ishaani olhupalhe ni owiittuchiha Malhehero ni ashulhupalhe nkayanrwelha ");
INSERT INTO mgh2016_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nkayankoha yeeraka, “Nrina ikuru yaani yo upanga chilha chinopanga inyu chilha? Apani ovanheni ikuru yo upangacha?” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu nkaakhulha eeraka, “Kinoukohani ittu imoka, mwakaakhulhaka, kinouhimeriani kinopanga chi wo ikuru yaani. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nkihimerieke, ikuru yaapanga aya Nayohana, yo waabatiiza attu, yaakhumme uyi, yaakhumme wa Nlhuku wiirimu ama wa attu?” ");
INSERT INTO mgh2016_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nkayaachokholha ukohanacha ashineneru, “Nimwaakhulheke chani? Neeraka wiira ‘yaakhumme wa Nlhuku wiirimu’ noonikoha woonaka mwaattiva khamwaarumelhelha Nayohana ayo? ");
INSERT INTO mgh2016_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ni vavawo wo ikekhiaye neeraka, ‘Yaakhumme wa attuni.’ ” Nkayoova attu, ukhalhawaya attu onkhaye aachuwelha wiira Nayohana aari anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Paahi etu nkayaamwaakhulha Yesu wiira, “Hii khanichuwenlhe.” Yesu nkeera, “Ni mii akinouhimeriani kinopanga chi wo ikuru yo ukhuma uuyi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Paahi etu Yesu nkoolhumana wo malhikaaniho, “Ahaawo ntu aalhimme imata yo zabibu, nkaarukureriha ukucho, nkaathipa nlhikiti no waamelha izabibu ni ishanja yo ulhitelhelha imata. Nkaashimiha imata awe iyo anamalhima, nkaarwa nkwaha wo utayi. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nlhaalha wo utokotta izabibu waayilhe aya, nkanruma karumiya arwee apochere mahalha. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anamalhima alhe nkayammara karumiya uyo, nkayaamwata, nkayanhokolhosha mathatharu. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nkanruma tho karumiya nkina, anamalhima nkayaamwata mmuruni ni umpangelhacha chittu cho wulhiha muru. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anene imata nkayanruma karumiya nkina, nkeeviya, ni akina enchi yaarumiye aapangelhiya thoko chiicho, akina waatiya ni wiivakachiya akina. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ntu mmoka aari hinarumiya aari mwaamwanaya onnyara anttuna aya chinene. Nkanruma ni uyo eecherelhaka wiira, ‘Kinoona wiira anokonlhoha mwaamwanaka kinonttuna aka ulha.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nansho yamwooneke, anamalhima nkayaahimerianacha ashineneru, ‘Ulha vano phi mwaamwanaya anene imata. Nngwe nimwive, ni nhakhu ulha ukhalheke wawihu!’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Paahi etu nkayammara ni umwiiva ni unrihelha uchereshere ukucho wo imata yo zabibu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu nkaakoha, “Vano mwanene imata yo zabibu ulhe nohalha wiira chani? Nowa weeva anamalhima onkhaye ni waashimiha imata awe iyo attu akina. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nhoshoma Malhove Matakatifu wiira, ‘Nlhuku nikhotiye ni atheki wiira khaninlhoka, nihothathuwa ukhalha vano no nsingi no vakhoonani. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Athithi anene phi pannge, chi chinooshangihani chi!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aholhelhi a Ayahudi nkayaalhikacha ummara Yesu, ukhalhawaya yaari achuwelhaka wiira nenno nlhikaaniho nno naari naachaka. Nansho nkayoova attu. Nkayanhiya arwee. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Amafarisayo akina ni attu o nlhoko wa Naherode nkayaarumiya urwaa unriaa Yesu wo unkoha chookohiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nkayaawa ni unkoha, “Owiittuchiha, nihochuwelha wiira inyu nri mu uhimiani ikeekhene, wo uhimwoova ntu. Khannonlhoha ntu chinre awe, nansho chineetuchiha inyu chiri cho ikekhia ya Nlhuku. Nnihimerieke etu, chani vahorera waalhiva Nakaisari ikhodi? Naalhiveke ama nihaalhive?” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nansho Yesu ahochuwelha yoyo unafiki uyo nkaakhulha eeraka, “Veeshiyani ukiriaa? Kivahekeni etu nikobilhi nno koone.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nkayammaha nikhobilhi nimoka, ni uyo nkaakoha, “Ilha ikhove ilha, ni nna nchina nna niri na apani?” Nkayaakhulhacha wiira, “Chi Nakaisari.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu nkaahimia tho wiira, “Mwaalhiveke Nakaisari iri ya Nakaisari ni ummaha Nlhuku iri ya Nlhuku.” Nkayaanshanga Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Attu akina munkutirani mwa Amasadukayo, aavanyiha wiira khuuwo uhihimmwa, nkayaawacha wa Yesu unkohani, nkayeera, ");
INSERT INTO mgh2016_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Owiittuchiha, ashinna Musa aholhepa anihimeriaka wiira, ‘Ntu arimeelhaka aahiyaka amwarawe ahinayara, ahima awe anowooria ukelha manupa ni waayarelha ashaana arimeelhe ayo.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yakhalhaka yaari ashilhoko saba, olhupalhe ayo ahothelha nkaakhwa wo uhaahiya ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","O nayelhi ayo ni ayo chiicho, nkaakhwa wo uhaahiya ashaana. Ni o neraru chiicho, ");
INSERT INTO mgh2016_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ni akina aahalhenlhe ayo, onkhaye saba akelhaka manupa ni ukhwa wo uhahiya ashaana. Wo umalhihera, athiyana ayo nkayaakhwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Vano etu, nihuku no uhihimushiya attu akhwilhe nno, mpani nohalha ukhalha phi owannyaya athiyana alhe? Ukhalhawaya onkhaye saba ahaathelha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu nkaakhulha eeraka wiira, “Nhowonya mwaattiva ayi! Nchuwelhaka wo nlhatu wani? Ukhalhawaya khanchuwenlhe Malhove Matakatifu ama machiri a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ukhalhawaya attu akhwilhe vanohalha aya uhihimushiya khanowa aathelha ama uthelhiya, onohalha ukhalha thoko minepa o wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Vano vavawo, wo uhihimmwa attu mwaattiva khannaye ushoma Malhove Matakatifu a ashinna Musa nlhako unhimiacha mwaha wo ithuphi yaapharelha mooro? Iholhepiya vavawo, Nlhuku aheerelha ashinna Musa wiira, ‘Mii phi Nlhuku a Aburahimu ni Naisaka ni Nayakhobo.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Paahi ri Nlhuku a attu akumi, kahiwe akhwilhe. Mwaattiva onkhaye nhopotera chinene!” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Owiittuchiha Malhehero amoka aari vavawo eewelhelhaka. Nkoona wiira Yesu ahaakhulha Asadukayo ayo nlhove noolhoka, ni uyo nkaawa ankohaka Yesu eeraka, “Nlheheriyo naani niri nulhupalhe upwaha nikina?” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu nkaakhulha, “Nooholhelha phi nna, ‘Nkeewani inyu Naisraeli! Apwiiya Nlhuku phi Nlhuku Athithi ari vekha! ");
INSERT INTO mgh2016_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mwaattune Athithi Nlhuku inyu wo nrima inyu wonkhaye ni wo nnepa winyu wonkhaye ni wo irusho chinyu chonkhaye ni wo machiri inyu onkhaye.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No nayelhi phi nna, ‘Mwaattuneke amwaatamana inyu thoko chineettuna inyu mwaanene.’ Khaawo malheheriyo makina ari molhupalhe tho upwaha alha melhi alha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Owiittuchiha Malhehero ulhe, nkeera, “Nhomanya, Owiittuchiha! Nhohimia ikeekhene wiira Apwiiya Nlhuku phi yayo ari vekha, khaawo nkina olhupalhe ahikhalhe yayo. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ni kila ntu hothananiya waattuna wo nrima wawe wonkhaye ni wo irusho chawe chonkhaye ni wo machiri awe onkhaye, ni waattuna amwaatamana aya thoko chineettuna aya ashinene, ilhokaka upwaha wo ukumiha isadaka cha ashinama ni isadaka chikina wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu nkoona wiira yayo owiittuchiha ayo ahaakhulha rata, nkaahimeria wiira, “Khanrii utayi ni Imwene ya Nlhuku.” Wo umalhihera vavawo, khaawo tho ntu ankohakonhe Yesu chookohiya chikina. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu vaari awe eetuchihaka Inupa ya Nlhuku, nkaakoha, “Woonaka owiittuchiha Malhehero anohimiechesha wiira Kuristo Moopolhi nohalha ukhalha mwaana a Adaudi? ");
INSERT INTO mgh2016_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Adaudi anene wo uholhelhiya ni Iphumu ya Nlhuku aheera, ‘Athithi ahaahimeria Athithi, Nkakhalhani wiimonono waka Mpaka nihuku vanohalha aka waathalha amalhaponi inyu wuuthi inyaa chinyu wiira mwaanyikalhelhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Adaudi anene anehana yayo ‘Athithi.’ Chommo nlhatu wani Kuristo Moopolhi ukhalha mwaana a Adaudi?” Attu enchi aari amwiwelhelhaka Yesu ateelhiyaka nrima. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu veettuchiha awe nkeera, nkaahimia tho eeraka, “Mwiichinanelheke ni Owiittuchiha Malhehero anoviravira anawerenlhe miinjiro cho utalhiva achivelhiyaka ukohachiya wo nthimicho vakittu vanopangachiya maronda, ");
INSERT INTO mgh2016_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ateelhiyaka ukhalha mapuro o miholho, mmanupani mwo unlhapelha Nlhuku ni vakittu vanokumaana aya attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anowaathurulhacha anankhwelhi chittu mmanupani mwaya, eepangaka attu o ulhapelha wo uhoochaa. Nihuku ni uhukumulhiya anowa utwarushiya wo uweria chinene!” ");
INSERT INTO mgh2016_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu aari nakhanlhe vachereshere iphache yo uhelhiya isadaka wi Inupa ya Nlhuku, nkoona attu cheera aya wo ukumiha isadaka chaya. Attu o nhakhu enchi aakumiha nchurukhu mwinchi. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Paahi vavawo nkaawa anankhwelhi amoka ahirina ittu, nkaakumiha isenti pilhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu nkeehanacha owiittucha awe ni uwerelha, “Kinouhimeriani wo ikekhiaye wiira, alha anankhwelhi ashikini alha ahohelha mphacheni isadaka yinchi waapwaha attu onkhaye akumihilhe mu. ");
INSERT INTO mgh2016_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ukhalhawaya attu akhwawe ayo akuminhe chithempe munhakhuni mwaya, nansho alha apwiyawe ashikini alha, akuminhe chonkhaye chaakhulhuvelha aya ulhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu vaakhuma awe Inupa ya Nlhuku, owiittucha mmoka nkeera, “Owiittuchiha! Nkoonani inupa chi ni malhuku athekelhiye chinre aya worera chiyo!” ");
INSERT INTO mgh2016_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu nkaamwakhulha, eeraka, “Nnowoona chi inupa chulhupalhe chi? Khaniwo nlhuku ninottuna uhalha vaa, kila ittu inowa uphomolhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu aari nakanlhe vachulhu Mwaako wo Mizeituni, miitho anari awehaka Inupa ya Nlhuku, Napeturo ni Nayakhobo ni Nayohana ni Naandorea nkayaawacha unkoha wo ntemera. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nkanihimerieni yoyo mwaha uyo unohalha ukhalha iyaakhani? Ni ithikineha chani chinohalha unichuwelhiha wiira uhaatameria?” ");
INSERT INTO mgh2016_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu nkaahimiachera eeraka, “Mwiishungeke nhiwe mwaathepiachiya ni ntu. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anoowa attu enchi aromolhachaka nchina naka eepangaka, Phi mii! Aapoterihaka attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Vanottuna inyu wiiwa mwaha wo ikhoto chinaatakaniya vakhiviru ni cho utayi nhithemwe. Chonkhaye chiyo chinowa upangia, nansho ihikhalhaka umalha wo ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Makosho anowa waatakana, imwene ni imwene ikina. Ilhapo inowa utikhinyachiya mwonkhaye, attu akelhiyaka ni ikuruna yo woopiha. Chonkhaye chiyo chinowa uholhelha thoko chinera aya nkuri vanoyariaa awe mwaana. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nansho mwaattiva nthepeke ukhalha mwiishungaka. Ukhalhawaya nnoowa mwaavariya ni urweehiya umilhatuni. Nnowa waatakachiya mu inupa cho unlhapelha Nlhuku, nnowa weemeshiya wa attu o utawara ni wo mamwene wo nlhatu waka ni uhimiechesha Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nansho umalha uhinaaya, Malhove Orera anowa wiittuchihiya wa makosho onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ni vawo vanottuna inyu uvariya ni urweehiya umilhatuni vawo, nhiwe mwoova wiira nnottuna wulhumachani, mmweeke mwolhumacha iriyoothe ivahiye inyu. Ukhalhawaya malhove ayo khanowa ukhalha awinyu, anottuna wuulhumachiya ni Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Attu anowa waathumiha achihimaya eeviye, manyanaangoro anowa waathumiha achishaana aya. Ashaana ni ayo anowa waathumiha manyanaangoro ni uweeva. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Attu onkhaye anowa uuvengani wo nlhatu waka. Nansho nohalha uvilhelha wo uhoochaa nowa woopolhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nnowa woona ‘Nrusho no utanganya’ ninemenlhe vamapuroni vatakatifu.” Noshoma achuwelheke chinohimiya! “Vavawo arii Uyudea attawelheke umiakoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ntu ri vachulhu nchaara no inupa awe, hikhuruwe vathi uukushani ittu. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ntu ri umatani hihokolhie uwani uukushani ikuwo awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ahothapana manyopani ari ni iweyi ni alhe anaamwiha ashaana yayo mahuku ayo! ");
INSERT INTO mgh2016_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Munlhapelheke Nlhuku wiira yayo mahuku ayo ahiwe nlhaalha wo uririya! ");
INSERT INTO mgh2016_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ukhalhawaya uhuva waya unowa uweria chinene vahinapacha woonia toka Nlhuku voopilhe awe ilhapo mpaka nna. Mena khanowa upangia tho. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nansho Athithi ahokuwukulha yayo mahuku ayo, ihikaari chiicho, khaawo ntu akoopolhiye. Ilha inottuna upangia wo woonelha ikiriri attu athanlhiye, phi chiichammo etu mahuku ayo ahowukulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ni vavawo awaakaru ntu eeraka, ‘Mwooneke, Kuristo ri va!’ Ama ‘Mwooneke rii valhe!’ Nhinrumelhelhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ukhalhawaya ashi kuristo o woothacha ni anamilhohi o woothacha enchi anowa woonia. Anowa upanga cho ushangiha ni ithikineha chinchi wo waapoteriha ata attu athanlhiye ni Nlhuku, yooriaaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nhiittialhe! Kihouhimeriani chi chittu chonkhaye chi mahuku ahinaya uphiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Paahi etu, umalha wo yayo mahuku o uhuva ayo, nchuwa ninowa uhelhiya ipiphi, ni mweeri khunowa waapharelha. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ittotwa chinowa umora ni machiri o wiirimu anowa utikhinyia. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Vavawo Mwaana a Ntu nowa woonia, awaaka mmahuteni wo ikuru ni nthimicho. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nowa waaruma minepa o wiirimu avire mithelha ncheshe chonkhaye cho iphioo aakhungurachaka attu athanlhiye ni Nlhuku aviraka uno ni uno. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mwiittucheke malhikaaniho o nkhuyu. Vanochokholha aya uphuwa mathaakhuru makithi, vavawo inoochuwania wiira nlhaalha uhaatama. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wo chiichammo etu, vanohalha inyu woona chiicho, nnowa uchuwelha wiira uwa wo Mwaana a Ntu uhaatama. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wo ikekhiaye muupuwelheke wiira yayo anowa upangia ilha iyari ilha ihinavira. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Irimu ni ilhapo chinowa uvira, nansho malhove aka mii khanovira mena. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Khaawo ntu chuwenlhe, chiripothe, iyaakhani au nihuku naani noowa, uchokholha wo minepa cho wiirimu, mena Mwaana, ahikhalhe Athithi anene phi chuwenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nshelhelhiheke, nhiittialhe, nlhapelheke ukhalhawaya khanchuwenlhe nihuku naani. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Inowa ukhalha thoko ntu nothama uwannyawe ni urwaa nkwaha wo utayi chinaalhehera awe ni waavaha ikuru anamitheko awe, ni unruma ntu o ushunga inupa awe wiira hiitialhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nkhalheke miitho etu, ukhalhawaya khanchuwenlhe wiira anene inupa anohalha uhokolhia nihuku naani, uchechilho ama uhiyu variyari ama mapikoosha ama wichishu. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ahokolhiaka wo uhichuwania, ahuuphwanyeni nnarumpe. ");
INSERT INTO mgh2016_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nlhove kinohimiaka uwaninyu mwaattiva, phi nno kinohimiaka wa attu onkhaye, Nshelhelhiheke!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ahohalha mahuku melhi nihinaphiya nihuku no Pasaka, ni no mikatte cho uhihelhiya ihengedure. Opochera ishaani olhupalhe ni owiittuchiha Malhehero yaari yaaviaka iphiro yo ummara Yesu wo nivitho ni umwiiva wo uhichuwania ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yaari yeeraka wiira, “Nihimmare alha mahuku o sikuukuu alha, nihiwe naatharamulha injoove.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu aari Ubethaniya uwani u Nasimoni, ntu o makutulha. Vaari awe alhiaka yolhia, ahowa opani amoka aawelhe ichupa yo alabasta yo makhura o unukhelha o uhithakanihiya, aathumihiya nchurukhu mwinchi. Nkayaatiulha ichupa iyo ni ummiinelha Yesu makhura mmuruni. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Attu akina vavawo ahothunalha nkayaakohanacha aneneru, “Nlhatu waani wo urihakacha makhura thoko yalha? ");
INSERT INTO mgh2016_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yaanooria uthumihiya wo idinari imia taaru, nchurukhu uyo nkayaavahachiya amashikini!” Nkayaachacheracha opani ayo. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nansho Yesu nkoolhumacha eeraka wiira, “Mwaahiyeke, nnaahuvinerani? Alha ahokipangelha ittu yoombone. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Attu ahirina ittu arii mwaakhalhanaka iyaakha chonkhaye, vanottuna inyu nnoworia waavaha. Nansho mii akiri vamoka ni inyu iyaakha chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ahopanga yonrie aya, ahokihika makhura iruttu aka ni weesha tayari wo nihuku no uvithiya waka. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kinouhimeriani ikekhiaye wiira, vakittu variwoothe vanohalha uhimiachiya Malhove Orera velhaponi va, mwaha upangilhe aya alha opani alha unowa uhimiachiya wo wuupuwelhiya waya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Miholho waya Nayuda Isikariote, mmoka aya owiittucha khumi ni elhi, nkaarwa wa opochera ishaani olhupalhe upangani miruku cho unthumiha Yesu eeviye. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Opochera ishaani olhupalhe nkayaatelhachiya veewilhe aya, nkayaalhehana ummaha nchurukhu waalhepenlhe aya. Paahi etu Nayuda nkaachokholha waavia iphiro cho utimiriha. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nihuku naaholha isikuukuu yo mikatte cho uhihelhiya ihengedure, nihuku no ukumihiya isadaka yo uhithiya mwaakhondoro o sikuukuu, owiittucha awe ahonkoha Yesu eeraka, “Nnothanana nirweeke vayi nooterekhelhekeni yolhia yo nihuku no Pasaka?” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu nkaaruma owiittucha awe elhi eerelhaka, “Nrweeke mpaka vawani nnokonkumana ntu weelhe mwaapu wo maashi. Mwanttwareke ");
INSERT INTO mgh2016_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mpaka inupa inohalha awe ukelha, ni unhimeria wiira, ‘Owiittuchiha aneera, Irivayi ichuumba aka yo ulhelhia nihuku no Pasaka ni owiittucha aka?’ ");
INSERT INTO mgh2016_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yoyo nokowoonihani ichuumba yulhupalhe iri inupa yo nchulhu ikooroshiye ni urerihiya. Mwaterekhelheke mwommo.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Owiittucha nkayaathama, ni urwaa vawani, ni uphwanya kila ittu inari thoko chaahimeriye aya ni Yesu, nkayaaterekha yolhia yo Pasaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Uchechilho, Yesu nkaawa ni owiittucha awe khumi ni elhi. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ikatema vaari aya alhiaka yolhia, Yesu nkaahimia wiira, “Kinouhimeriani ikekhiaye wiira, mmoka inyu nolhia vamoka ni mii nookithumiha.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Owiittucha ayo nkayaakelhiya ihuzuni, nkayaankohacha mmoka mmoka, “Nkihimerie, chani mii?” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu nkaakhulha eeraka, “Mmoka inyu mwaatti khumi ni elhi va, nopapha nkatte vamoka ni mii nnyiponi, phi yoyo nohalha ukithumiha. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwaana a Ntu nookhwa thoko chilhepiye aya, nansho hothapana yoyo ntu uyo nohalha unthumiha Mwaana a Ntu uyo. Ikaari nambaya yoyo ntu uyo hikayaarelhe!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Vaari aya alhiachaka, Yesu ahokusha nkatte, nkaalhapelhelha, nkaamia ni uwakawelha owiittucha awe eeraka, “Mmwieke nlhieke, ilha phi iruttu aka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tho nkaawia ikikombe yo idivai, nkaalhapelha wa Nlhuku, nkaavaha, onkhaye nkayaawureria vamoka ikikombe iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu nkeera, “Ilha phi iphome aka inohimiechesha malhehano a Nlhuku, inorihia wo nlhatu wo attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kinouhimeriani wo ikekhiaye wiira, Akinowuria tho idivai yo zabibu mpaka nihuku vanohalha aka uwuria idivai yo naanano wi Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nkayeepacha ichipo, nkayaathamacha ni urwaa waari Mwaako wo Mizeituni. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu nkaahimeria wiira, “Mwaatti onkhaye va nnowa uttawa ni ukihiya vekha, thoko Malhove Matakatifu chinre aya wo ulhepiya, ‘Nlhuku nomwiiva nshunga, ni ikhondoro chinomwaria.’ ");
INSERT INTO mgh2016_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nansho baada yo uhihimmwa, kinouholhelhani Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Napeturo nkayeera, “Akinowa koohiyani, ata attu onkhaye anattawaka!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu nkeerelha Napeturo, “Kinouhimeriani wo ikekhiaye wiira nthupi uhinaya wiipa wo nayelhi uhiyu wo lhelho, nnowa ukikhota vararu mwiiraka wiira khankichuwenlhe.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nansho Napeturo nkayeera amindaka, “Akooriaka mii wiira chiicho, ata ukhwa mbaya kikhwe vamoka ni inyu!” Ni owiittucha akina ayo nkeera chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Paahi etu nkayaaphiya imata yeehaniya Gethsemane, Yesu eerelhaka owiittucha awe, “Nkhalheke vaa mii kilhapelhaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nkaakusha Napeturo ni Nayakhobo ni Nayohana. Nkaachokholha wiipulhelha ni uthemwa munrimani, ");
INSERT INTO mgh2016_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ahimiaka wiira, “Kihokelhiya ihuzuni munrimani mwaka ithananaka ukiiva. Nkhalheke vaa nshelhelhihaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nkaarwa uholho vakani, nkaawulhuwa makukhu vathi, alhapelhaka wiira yooriaka hivire yeyo ikatema yo uweria iyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aalhapelha eeraka, “Thithi, nri Athumwanaka! Chonkhaye chinowooriaa uwaninyu. Nthamiheke ilha ikahi yo uweria ilha. Nansho nhiwehe uttuna waka nansho uttuna winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nkaahokolhiaa waari owiittucha araru alhe ni waaphwanya anarumpe. Nkaakoha Napeturo, “Nasimoni chani nhorupa? Khamwonrie ushelhelhiha miitho ata isaa imoka?” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nkaathepa waahimeria wiira, “Nshelhelhiheke nlhapelhaka nhiwe mwaakelha muulhikachiyani. Nrima uhottuna nansho iruttu inoohuperia.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nkaarwa tho ulhapelhani, ahokolhelhaka malhove olhumacha awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nkaahokolhia tho nkaaphwanyacha anarupilhe. Miitho anaalhemenlhe ikhove. Khayaachuwenlhe no umwaakhulha. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Vaawilhe awe nkwaha wo neraru, nkeerelhacha, “Nnoorupa ni wiittuwa mpaka nna? Ihothosha! Isaa ihophiya! Mwooneke vano Mwaana a Ntu noovariya ni uhelhiya mmathathani mwa attu o uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Munkweke etu, nirweeke. Mmwooneke, ntu nokithumiha ulha va!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu aari olhumachaka, Yuda mmoka aya owiittucha khumi ni elhi, nkaawa. Aawa vamoka ni mphingo wa attu aawelhe mialho chulhupalhe ni indonga anarumiye ni opochera ishaani olhupalhe ni owiittuchiha Malhehero a ashinna Musa ni ashulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda aari anaahimenrie choopanga vanottuna aya uphiya, wiira, “Ntu kinohalha aka unkumbatira uyo phi yoyo. Mummareke ni unrweha munshungaka.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nayuda vaapilhe aya, nkanchusherera Yesu eeraka, “Owiittuchiha.” Nkankumbatira. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Paahi etu nkayammara Yesu ni unrweeha nattukiye. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nansho mmoka aya owiittucha awe aatamenrie vavawo, nkaatholholha mwaalho awe mulhupalhe ni unthikilha nnyaru karumiya a Opochera ishaani Olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu nkaakoha attu alhe, “Woonaka mwaatti nnowa ukivara nnawelhe mialho chulhupalhe ni indonga thoko wiira ki ntu o uvara makhuche? ");
INSERT INTO mgh2016_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila nihuku kaari ni inyu keetuchihaka attu Inupa ya Nlhuku, nkoonaka wo uhikivara. Nansho nambaya Malhove Matakatifu atimire.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Owiittucha awe onkhaye nkayanhiya nkayanttawacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ahokhalha mmirawo nkhwawe, aawanre ishuka anttwara Yesu vatulhi. Nkaalhikachiya uvariya ni uyo. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nansho nkaattawa ikuwo immoraka, attawaka pwithipwithi. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Wamalheke Yesu nkaarwehiya upuwani wa Opochera ishaani Olhupalhe waari aya ni aholhelhi a attu opochera ishaani onkhaye, ashulhupalhe vamoka ni owiittuchiha Malhehero akuumaanachaka. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Napeturo nkayaattwara utayiutayi mpaka upuwani wa Opochera ishaani olhupalhe. Vavawo nkaakhalha vamoka ni anamitheko yoottaka mooro. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Opochera ishaani olhupalhe ni mphingo wonkhaye yaari aaviaka milhatu cho uhimiechesha umwootheria Yesu, chinohalha wooriha unhukumulha ni umwiiva, nansho wo uhipatta nlhatu uripothe. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Attu enchi o uhimiechesha ahoolhumacha malhove o umwootheria Yesu, nansho khayaalhikanne. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Paahi attu akina aheemelha amoootheriachaka Yesu wiira, ");
INSERT INTO mgh2016_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nahomwiiwa eeraka ‘kinoophomolha Inupa ya Nlhuku ithekiye ni attu ilha, ni utheka ikhwawe wo mahuku mararu, ihithekiye wo machiri a attu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nansho aneeraka chiicho, uhimiechesha waya khawaalhikanne. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Opochera ishaani olhupalhe nkayeemelha variyari aya ni unkoha Yesu, “Chani woonaka khannaakhulha, milhatu chinoreiya inyu chi?” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu nkaamalha shiriri. Opochera ishaani olhupalhe nkaakoha tho, “Ana inyuva phi Kuristo Moopolhi mwaana a Nlhuku vahiye ibarakha?” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu nkaakhulha eeraka, “Eiyo, Phi Mii, ni inyu nnowa umwoona Mwaana a Ntu nakhanlhe wiimonono wa Apwiiya Nlhuku O machiri, vanohalha awe uwa umahuteni wiirimu!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Opochera ishaani olhupalhe nkaarulha mwiinjiro waya eeraka, “Khaninttuna uhimiecheshiya tho! ");
INSERT INTO mgh2016_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nheewa mwaashinene ulhava wawe! Mwaatti nnona chani?” Attu onkhaye nkayaakuwelha eeraka wiira hotteka, hophwanelhiya uhukumulhiya ukhwa. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Attu akina nkayanshuwelha Yesu ishenye, nkayantiyelhelha wiitho ni unkhoma mmuruni amwirelhaka, “Nkalhamulhani apani okhommeni?” Ni manyaasikari ni ayo nkayaamwata makofi. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Napeturo aari anakhanlhe vapuwani, vaawilhe awe karumiya mwalhi mmoka aarumiya wa Opochera ishaani olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Vonne aya Napeturo anakhanlhe oottaka mooro nkaaweha wiitho ni weerelha, “Ni inyu ngati mwaari ni Yesu o Unazareti.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nansho Napeturo nkaaruna vaattuni eeraka, “Akinchuwenlhe mena ittu inoolhumacha inyu.” Nkaakhuma vathe. Nthupi nkaweepa. ");
INSERT INTO mgh2016_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mwalhi namitheko ulhe vonne awe tho Napeturo nkaahimeria attu aatamanne ayo wiira, “Ni alha aari mmoka aya!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Napeturo nkayaaruna tho. Nansho miholho vakani tho, attu aari vavawo ni ayo nkayeerelha Napeturo, “Ninohimia ikekhiaye wiira, ni inyu mwaari mmoka aya, ukhalhawaya ni inyuva ntu o Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nkaathepa uminda Napeturo eeraka wiira, “Kinolhupelha wiira akinchuwelhaka yoyo nnomwacha inyu uyo! Nlhuku akihukumulheke etu yakhalhaka kinowoothacha!” ");
INSERT INTO mgh2016_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ni vavawo nthupi nkaweepa nkwaha wo nayelhi. Napeturo nkayopuwelha chenre aya wo uhimeriya ni Yesu venre awe, “Nthupi uhinaya wiipa wo nayelhi lhelho, nnoowa mwaakiruna mikwaha miraru.” Miithori nkachaamora Napeturo. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mapikoosha, opochera ishaani olhupalhe nkayaakumaanacha vamoka ni ashulhupalhe ni owiittuchiha Malhehero uwoopani ntemera. Nkayanttuka Yesu mittondoro cho yuuma ni unrweeha u Napilato. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Napilato nkankoha “Phi inyu amwene a Ayahudi?” Yesu nkaakhulha, “Inyuva nhohimia.” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Opochera ishaani olhupalhe nkayaamotheriacha Yesu milhatu chinchi, ");
INSERT INTO mgh2016_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Napilato ahonkoha tho, “Woonaka khannaakhulha? Mwiiweke chineera aya wo uriani milhatu chinchi!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu nkaamalha tho, aashangihaka Napilato. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila nihuku no isikuukuu yo Pasaka, Napilato aari ni malhemalhelho o unthaphulha ntu ttukiye mmoka, aavekelhiye aya ni attu wiira athaphulhiye. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wo nenno nihuku nno ahawo ntu mmoka eehaniya Baraba, aattukiye vamoka ni attu o uwonya akina wo milhatu cho wiiva u njooveni. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Attu enchi nkaarwaa uwaavekelhani Napilato apange thoko cheera aya wo ulhemalhelhihiya, ");
INSERT INTO mgh2016_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Napilato nkayaakoha, “Mwaatti nnonthananani, kinhiyerereke mwene a Ayahudi?” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Eera chiicho achuwelhaka wiira opochera ishaani olhupalhe ammanre Yesu wo umwonelha ihache. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nansho opochera ishaani olhupalhe aari aachopeachaka attu wiira avekelhe uthaphulhiya wa Baraba. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nkaakoha tho Napilato waakoha attu eeraka, “Kimpangekeni etu, ulha ntu nnomwiihana inyu mwene a Ayahudi ulha?” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Attu onkhaye nkayaakhuwelhacha, “Akhomelhelhiye vansalaabani!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Napilato nkayaakoha tho, “Wo nlhatu wani! Ttekilheni?” Nansho attu nkaathepa ukhuwelhacha, eeraka “Akhomelhelhiye vansalaabani!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Napilato wo waateelhiha attu nrima, nkayanthaphulha Baraba. Nkaalhehera wiira Yesu aatiye ikopo ni urweehiya akhomelhelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manyaasikari nkayammwia Yesu mpaka upuwani wa atawara ilhapo. Nkayeehana miphingo cha manyaasikari. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nkayankhunelha Yesu ikuwo ye imwene, ni ukoorosha mphumburu wo miiwa ni ummwariha mmuruni. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nkayanramuchira, “Moyoo, Amwene a Ayahudi!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nkayaamwaatakacha mmuruni ni nthalhe, nkayanshuwelha ishenye ni unkhoromelha eepangaka unthimicha. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yamalhiheke unheulhacha, nkayanrulha ikuwo ye imwene ni ummwariha tho ikuwo chawe. Nkayaathama ni unrweeha unkhomelhelhani vansalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mphironi nkaakumaaniya ntu mmoka eehaniya Simoni ntu nnenchi o Ukirene aakhuma umatani. Nkayankhanyereriha wiira ankavihe Yesu ukusha nsalaaba. Yoyo aari athumwanaya Naalekizanda ni Naruufo. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nkayanvelhelha Yesu mpaka vakittu veehaniya Gologota, maana aya “Nikhurukucha no Muru.” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wowo nkayammaha idivai yaathakanihiye nrete wo uhapalha weehaniya manemane, nansho Yesu khaawunrie. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Paahi etu nkayankhomelhelha vansalaabani, nkayaakusha ikuwo chawe ni ukawana wo woopa ikhura. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yeyo yaari saa tatu wichishu vaakhomelhelhiye awe vansalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nkayaalhepa nlhatu no wiiviya wawe niiraka “Mwene a Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Vamoka ni uyo ahokhomelhelhiya attu elhi tho, yaari attu o uvara makhuche, mmoka wiimonono ni nkina wiimushi. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","29","Attu yaavira mphironi, ni ayo nkayeewiya anruwanaka apukhunyachaka miuru eeraka, “Inyu! o uphomolha Inupa ya Nlhuku ni utheka tho wo mahuku mararu! ");
INSERT INTO mgh2016_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nkhuruweke etu vansalaabani vawo, mwiichopolheke mwaanene!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ni ayo opochera ishaani olhupalhe ni owiittuchiha Malhehero a ashinna Musa ahonheulhacha eeraka, “Ahooria woopolha akina, nansho khanooria wiichoopolha mwaneneru! ");
INSERT INTO mgh2016_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nngwe nimwone vano eepanga Kuristo Moopolhi, mwene a Ayahudi vanokhuruwa awe vansalaabani, noone etu ninrumelhelhe!” Ata ni ayo elhi aakhomelhelhiye vamoka ni Yesu ayo, ni ayo ahonruwanakacha. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Toka saa sita uthana mpaka saa tisa, ilhapo yonkhaye nkayaakelhia ipiphi. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa uthana, Yesu nkaakhuwelha eeraka, “Eloi, Eloi, lama sabakthani?” Maana aya “Nlhuku aka, Nlhuku aka, woonaka nnookihiya?” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Attu akina eemenlhe vavawo ayo nkayaamwiwa, nkeera, “Mmwiiweke, neehana Naeliya.” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ntu mmoka nkaattimakacha ni ukusha ntapwata naatapwihiye nrete wo utipiha uweria ni ummaha Yesu munthalheni eeraka, “Haya noone yakhalhaka Naeliya anowa ukurushani vansalaabani.” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu nkaakhuwelha, nkaahiya nrima. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nipaziya nulhupalhe naatukelhelhiye u Inupa ya Nlhuku, nkanaahuwa velhi nchulhu mpaka vathi. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nholhelhi a manyaasikari eemenlhe vachereshere nsalaaba ahomwoona Yesu vaakhwa awe, ni uyo nkeera, “Wo ikekhiaye yolha ntu ulha aari Mwaana a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ahaawo manyopani eemenlhe, awehaka utayi utayi. Amoka aya aari Amariamu Magidalena, Nasalome, Amariamu anumwanaya Nayakhobo akani ni Nayose. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Alha phi aari manyopani anttukannne Yesu munkwahani toka vaari awe Ugalilaya ankavihaka mitheko. Ni manyopani akina enchi yaari aawilhe vamoka ni uyo Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Vavawo yaari uchechilho. Ni nihuku nenenno naari no wiicheesha rata wo Nihuku no Wiittuwa naawa meelho aya. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nkaawa Nayusufu ntu Uarimathaya, ntu aarumelhelhiya ni attu chinene. Yoyo aari ntu aaweherera uwa wo Imwene ya Nlhuku. Wo uhoova nkaarwa u Napilato ulhepelhani iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Napilato nkayaashanga chinene veewilhe aya wiira Yesu hokhwa. Nkaamwiihana nholhelhi a manyaasikari ni unkoherera yakhalhaka Yesu hokhwa kataashi. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Veewilhe awe wiira Yesu hokhwa kataashiru, nkaahiyera Nayusufu wiira akushe iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Paahi, nkayaathuma isaanda yo hariri ni ukurusha iruttu ya Yesu vansalaabani, ni uvilhikelha. Nkaavitha iruttu iyo nnihiyeni mwaahemiye vamwalhani. Nkayaakhunelha nlhuku vanlhakoni. ");
INSERT INTO mgh2016_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Amariamu Magidalena ni Amariamu anumwanaya Nayose nkayoona veeshiye aya iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Navireke Nihuku no Wiittuwa, Amariamu Magidalena, Nasalome ni Amariamu anumwanaya Nayakhobo, nkayaathuma makhura o unukhelha o urwaa uhikacha iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wichishuru nihuku no Jumaapili, nchuwa vaakhuma aya, nkayaarwaa unihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Vaari aya mphironi ahokohanacha ashineneru, “Mpani nohalha unipirikishelha nlhuku nikhunelhiye vanihiyeni nne?” ");
INSERT INTO mgh2016_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nansho vaawenhe aya, nkayoona wiira nlhuku nihopirikishiya vanlhakoni vawo. Nlhuku nno naari nulhupalhe chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Paahi etu nkayaakelhacha nnihiyeni mmo, nkayaamwona mmirawo nawanre ikuwo chootelha twetwetwetwe nakhanlhe wiimonono, nkayaashangacha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nansho mmirawo uyo nkaahimia wiira, “Nhishange. Kihochuwelha wiira nnomwaavia Yesu o Unazareti aakhomelhelhiye vansalaabani. Khaawo va, hohihimmwa! Mwooneke etu veeshiye awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nrweeke etu mwaahimerieke owiittucha awe, vamoka ni Napeturo wiira ‘Nouholhelhani Ugalilaya, nnokoomwona wowo thoko chenre awe wo uhimia.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Paahi etu Napeturo nkayaakhuma unihiyeni waavithiye awe Yesu, nkayaattimakacha uno oovaka ni ushanga. Nkaamalha wo uhinhimeria ntu riyoothe ukhalhawaya yaari oovaka chinene. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu vaahihimmwe awe, mapikoosha o nihuku no Jumaapili, echoninhe thoko wa Amariamu Magidalena akuminhe awe mashoka o unanara saba. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Amariamu Magidalena nkaarwa uwaahimeriani attu aari vamoka ni Yesu alhe. Yayo manyaattu ayo aari mu wunlhani, ");
INSERT INTO mgh2016_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","veewilhe aya wiira Yesu hohihimmwa ni Amariamu Magidalena ahomwoona khayaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Katashi miholho, Yesu nkaakhumelhelha owiittucha elhi awe ooniaka wo ikhove ikina vaari aya akelhaka iwani cho mmamatani. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nkayaahokolhia ni waahimeria akhunanaya, nansho ni ayo khayaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kaanyuma Yesu nkaakhumelhelha owiittucha awe khumi ni mmoka vaalhia aya yolhia. Nkaachacheracha chinene wo nlhatu no ulhipa mirima, ukhalhawaya aari ahirumelhelhaka malhove a attu ankumanne vaahihimmwe awe. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Paahi nkeerelha onkhaye wiira, “Nrweeke velhaponi vonkhaye mwahimiacheke Malhove Orera wa attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ntu nohalha urumelhelha ni ubatiiziya nowoopolhiya, hinorumelhelha nohukumulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Attu anohalha urumelhelha ayo anovaahiya ikuru yo upangacha ithikineha, wo nchina naka anowa woomolha mashoka o unanara, ni wulhumacha nulhumo nilheto, ");
INSERT INTO mgh2016_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","avaraka inwaa, ama awuriaka ittu iriyoothe yo uhapalha, khinowa yaahapalha. Anoweeshera areta miono ni ureta uyo unowaahiya, anoolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Paahi etu, Athithi Yesu vaamalhinhe aya wulhumacha ni owiittucha aya ayo, ahokushiya wiirimu, ukhanlhe aya wiimonono wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Owiittucha aya nkayaarwaacha ahimiachaka Malhove Orera ilhapo chonkhaye, Athithi nkaatamana vamoka aavahaka ikuru wo mitheko chonkhaye wo ukhomaalhiha malhove aarwaa vamoka ni mitheko cho ushangiha chaapangiya.");
INSERT INTO mgh2016_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Munna nnottuniya Nateofilo, Attu enchi aholhepa rata mwaha waapangeelhe variyari ihu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aalhempe thoko chenre ihu wo weewa attu yoonechenshe ni anamitheko o nenno nlhove nno toka machokholhelho aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Paahi etu, Munna Nateofilo, ukhalhawaya kihowehaweha wo ikekhiaye chittu chonkhaye rata chene toka khalhayi, kihoona vahorera etu ulhepa wo nlhatu winyu, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ni inyu nchuwelhe mwaanene ikeekhene yiituchihiye inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naherode vaari aya amwene o Uyudea, ahawo anamilhohi eehaniya Azakariya, o nlhoko wa opochera ishaani eehaniya Naabiya. Ahanu aya Azakariya eehaniya Naelisabeti, o nihimo na anamilhohi Naharuni. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Onkhaye elhi ayo aari attu aapanga chittu cho ikekhiaye mmiholho wa Nlhuku, attwaraka iphiro cho malhehero ni ikano cha Athithi wo uhikhalha ni nlhatu wo ukhuwachiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nansho yaari ahirina ashaana ukhalhawaya Naelisabeti yaari o uhiyara, ni ayo onkhaye ayo aari anoolhuvanlhe chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nihuku nimoka Azakariya yaari avaraka ntheko aya wo upochera ishaani Unupani wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yaari vaathanlhiye aya thoko chaari aya chipangiyaka ni opochera ishaani, urwaa uutusherani ubani umadhubahuni. Paahi etu nkayaarwaa u Inupa ya Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Attu akina yaari vathe awehereraka anlhapelhaka Nlhuku ubani vaatusheriya aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nnepa wo wiirimu wa Athithi nkawaakhumelhelha mpaani mmo, nkaweemelha wiimonono wo madhubahu mwaatusheriya ubani. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Azakariya vonne aya nnepa uyo nkayaathukumelha ni woova chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nansho nnepa wo wiirimu nkaweera, “Azakariya, nhoove! Nlhuku heewa ulhapelha winyu, ni ahanu inyu Naelisabeti anonnyara mwaana mwanlhopwana. Mmweeke mwaamwiihana nchina nawe Yohana. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kihochuwelha wiira nnowa mwaateelhiya chinene, ni attu enchi akina anowa uteelhiya chiicho vanohalha awe uyaria! ");
INSERT INTO mgh2016_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nowa ukhalha ntu mulhupalhe mmiholho wa Athithi. Khanowa aawuria idivai mena utheka uriwoothe. Toka vanohalha awe uyaria ni anumwanawe noowa aachariya Iphumu ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ni weewananiha rata attu enchi o Israeli ni waapiiha wa Athithi ri Nlhuku aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nowa waaholhelha Athithi, wo machiri ni Iphumu thoko ya Naeliya. Noowa weewananiha manyanaangoro ni achishaana aya, nowa urukunusha mirima cha attu o itiyamaru wiira avire iphiro choombone, ni weesha tayari attu a Atithi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Azakariya nkaakhulha nnepa wo wiirimu eeraka, “Kinohalha uchuwelha chani yayo malhove ayo? Mii kihoolhuvalha ni ahanu aka chiicho ahoolhuvalha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nnepa wo wiirimu nkawaakhulha, “Mii kinoolhumacha va phi Gabrieli kineemelha mmiholho wa Nlhuku, kirumme uwa uhimeriani yoyo nttenga wo urera uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nansho ukhalhawaya khanrumelhenlhe nttenga aka, unowa utimira waayaka. Wo yoyo nlhatu uyo etu, nnottukiya malhaku inyu, nnookhalha chiicho wo uhulhumacha mpaka nihuku vanohalha aya utimira malheheriyo aka alha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yeyo ikatema iyo attu yaari yaawehereraka Azakariya uno ashangaka chani woonaka ahothepa ulhokelha chinene u Inupa ya Nlhuku mmo. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Vaakhumme aya vathe, khooria wulhumacha, paahi attu nkayaachuwelha wiira ahoona ithikineha vaari aya u Inupa ya Nlhuku. Yaari athoonyaka wo mathatha. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ikatema aya yo uvara ntheko wo upochera ishaani Unupani wa Nlhuku vaamanlhe aya, Azakariya nkayaahokolhia uwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Baada yo uvira mahuku, ahanu aya, Naelisabeti nkayaarupalha irukulhu. Nkayeettelha mpaani mieri nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nkayoolhumacha yiiraka, “Athithi ahokuupuwelha vano, ahothamiha ishoni yoona aka mwaattuni!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mweri wo sita wo iweyi i Naelisabeti Nlhuku nkanruma nnepa wo wiirimu Gabrieli arwee iwani wi ilhapo yo Ugalilaya yeehaniya Nazareti. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Arweehe wowo nttenga wa mwalhi mmoka aavekiye ni ntu mmoka o iyari ya Adaudi nchina nawe Yusufu. Mwalhi aarweehelhiya nttenga uyo eehaniya Mariamu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nnepa nkawaaphiya wa Amariamu nkaweera, “Mpuha ukhalhe ni inyu! Athithi ari ni inyu, nhovahiya nnema mulhupalhe!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Amariamu veewilhe aya yayo malhove ayo nkayaathemwa chinene, nkayaashanga wo uhichuwelha maana o yayo malhove ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nnepa wo wiirimu nkaweera, “Amariamu, nhoove, Nlhuku hoovahani nnema. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nnoorupalha iweyi ni unnyara mwaana mwanlhopwana, nnohalha inyu umwiihana nchina nawe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yoyo nowa wiihaniya Mwaana a Nlhuku Mulhupalhe, noovahiya ihiche yo imwene thoko apwiiya awe Adaudi chenre aya, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ni uwa ukhalha mwene aya iyari i Nayakhobo mahuku o uhimalha, umwene wawe khunowa waamalha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Amariamu nkaakhulha nnepa wo wiirimu, “Mii ki mwalhi kihinaatameriya. Inohalha wiiria chani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nnepa wo wiirimu nkawaakhulha, “Iphumu ya Nlhuku nowuukhuruwelhani, ni ikuru ya Nlhuku inowa ukhunelhani. Wo yoyo nlhatu uyo etu, mwaana ntakatifu nowa wiihaniya Mwaana a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Moopuwelheke tho alhoko inyu Naelisabeti, Yayo yeeriya wiira khannyara, nansho vano ari veruttuni iweyi yo mieri sita, ni wulhuvalha waya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Khiiwo ihinooria wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Amariamu nkayeera, “Mii, karumiya a Athithi, yiirieke etu thoko chinre inyu wo wulhumacha.” Nnepa uyo nkawaathama. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mahuku vaavinre aya, Amariamu wo uhipicha nkayaarwaa mpaka iwani yo umiakoni Uyudea. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aarweelhe mpaka uwani wa Azakariya ni waashikuria Naelisabeti. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Naelisabeti veewilhe aya Amariamu aashikuriaka, mwaana mwankani nkaathuphathupha munthunkwani mwaya. Naelisabeti nkayaachariya Iphumu ya Nlhuku ");
INSERT INTO mgh2016_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nkayoolhumacha akhuwelhaka wiira, “Nhovahiya ibarakha waapwaha manyopani onkhaye, ni mwaana inyu nohalha uyaria hovahiya nnema! ");
INSERT INTO mgh2016_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ki mpani mii mpaka alha akhumelhelhe uwannyaka, anumwanaya Athithi akeetelhelhe? ");
INSERT INTO mgh2016_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kinouhimeriani wiira, veewilhe aka tu nlhove ninyu, mwaana mwankani hothupha munthunkwani mwaka ateelhiyaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nhoreeriya inyu mwaarumelhenlhe wiira anowa aatimira malhove o nttenga wa Athithi ahimeriye inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Amariamu nkayeera, “Nrima aka unowaathimicha Athithi, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nrima aka uhoteelhiya ukhalhawaya Nlhuku phi moopolhi aka, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ukhalhawaya hokuupuwelha, mii karumiya kihiphwanelhiye! Uchokholha lhelho attu onkhaye anowa ukiihana mii o mpuha, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ukhalhawaya Nlhuku o ikuru yulhupalhe hokipangelha chittu chulhupalhe. Nchina nawe nitakatifu, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","uchokholha iyari imoka mpaka iyari chikina hooniha ikiriri wa attu onkhaye anaathimicha. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ahopanga mitheko chulhupalhe wo moono aya wo machiri ni waamwarushacha attu o mahuchuru anoopuwelha chittu cho mu nrimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Haakurushacha mamwene aholhelhi vahicheni waya, nkaawelhihacha attu o wiitimarikha. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Haawoniha chittu choombone attu awolhiye ithalha, ni woomolhacha attu o nhakhu nkaahiya mathatharu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hotimiriha malhehano aapannge awe ni manyaapwiiya ihu, ni umwoonelha ikiriri namitheko aya Israeli. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hoopuwelha ikiriri awe wa Aburahimu ni iyari aya mahuku o uhimalha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Amariamu nkayaalhokelha mieri miraru u Naelisabeti nkayaahokolhia uwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nkawaaya wa Naelisabeti wiithaphulha, nkayannyara mwaana mwanlhopwana. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Amwaatamana aya vamoka ni ashilhoko aya nkayeewa Athithi chinre awe wo woonelha ikiriri, nkawaattapelhelhiya vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwaana vaapihilhe nihuku no nane, nkaarwehiya uwiinelhiyani unyawo, ni urwaa ummahani nchina na athumwane Zakariya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nansho anumwane nkayeera, “Mena! Nchina nawe Yohana.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Attu nkayeera, “Nansho woonaka khaawo nlhoko inyu neehaniya chiicho!” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Paahi etu, nkayaathoonya waakoha athumwane wiira ehaniyeke nchina naani. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Azakariya nkayaavekelha wiira avahiye ikibau alhepe, nkayaalhepa wiira, “Nchina nawe Yohana.” Attu onkhaye nkayaashangacha! ");
INSERT INTO mgh2016_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ni vavawo Azakariya nkayaattukuwa malhaku ni nlhimi naya, nkayoolhumacha tho, nkaachokholha untotopelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Amwaatamana nkayoovacha chinene, ni mwaha uyo nkawaawanelha ilhapo yonkhaye yo miakoni Uyudea. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kila ntu eewilhe nkaahalha oopuwelhaka munrimani ni ukoha, “Nohalha ukhalha chani yolha mwaana ulha?” Ukhalhawaya machiri a Athithi aari vachulhu vawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Azakariya nkayaachariya Iphumu ya Nlhuku, nkayoolhumacha nttenga wa Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atotopelhiye Athithi, Nlhuku a attu o Israeli! Haaweelha attu awe woopolhani. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Honivaha Moopolhi o machiri unupani waya, karumiya a Adaudi. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aholhumacha toka ikatema yo machokholhelho wo iphiro ya anamilhohi awe atakatifu, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","wiira anowa anoopolha wa amalhaponi ihu, mmathathani mwa attu annipangelha ichimwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aheera wiira anowoonelha ikiriri manyaapwiiya ihu ni wuupuwelha malhehano aya matakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ahaalheha apwiiya Aburahimu wiira, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","anonoopolha wa amalhaponi ni univaha ntheko wa waakaviha wo uhoova, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wiira nkhalheke wo utakatifu mpangaka chittu chinothanana awe Nlhuku, mahuku ihu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ni uwe mwanaka, unowa wiihaniya namilhohi a Nlhuku ri Mulhupalhe. Unowa waaholhelha Athithi wookolhelha iphiro aya, ");
INSERT INTO mgh2016_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","waahimeria attu aya wiira anowa woopolhiya wo uhiyereriya uwonya waya. ");
INSERT INTO mgh2016_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nlhuku ihu ri o kiriri ni nrima woombone. Noniwiihera nthuko unokhuma wiirimu ");
INSERT INTO mgh2016_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ni waamwalhelha nthuko attu onkhaye ari mwiipiphini mwo nookhwa, ni unooniha iphiro yo urwaa umpuhani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwaana nkonnuwa, nkaachara machiri mwiiruttuni ni munnepani. Nkaakhalha uthakoni mpaka veechoninhe awe vaattuni wa attu o Israeli. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yayo mahuku ayo naholheheriya nlhove ni Akaisari Augusto no waahimeria attu onkhaye aari imwene yo Rumi wiira aalhakelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Waalhakelhiya attu wo upacha waari ikatema Akurenio vaari aya atawaraka ilhapo yo Usiriya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila ntu nkaarwa urii iwani awe wiira aalhakelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nayusufu ni ayo ahottuka nkwaha ukhuma iwani yaakhalha aya yo Unazareti Ugalilaya ni ukelha Ubethelehemu ilhapo yo Uyudea, waayarelhe aya Amwene Adaudi. Aarweelhe wowo ukhalhawaya yaari o iyari ya Adaudi. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aarweelhe uwaalhakelhiyani vamoka ni Amariamu, ahanu aavekilhe aya aari ve iruttuni, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","vaari aya Ubethelehemu uwo, ikatema aya yo wiithaphulha yahophiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nkayeethaphulha nttara naya, mwaana mwanlhopwana, nkayanvilhikelha ikuwo ni umwaathalhelha nnikulhani mwaalhiheriya ashinama nhiilhini ukhalhawaya khayapantte nipuro nhina inupa ya alheto. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vakhiviru ni yeyo iwani iyo ahokhalha attu aashunga mihuwo ashelhelhihaka mwiithuphini, alhitelhelhaka mihuwo chaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nnepa wo wiirimu wa Athithi nkawaakhumelhelha, ni nthimicho wa Athithi nkawaamwalheelha kila vakittu. Nkayoovacha chinene, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","nansho nnepa wo wiirimu nkaweera, “Nhoove mwaatti! Kinouhimiacherani nttenga wo urera, unohalha waateelhiha mirima attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ukhalhawaya lhelho nna iwani ya Amwene Adaudi Moopolhi inyu hoyaria, Athithi Kuristo aalhehiye ni Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni nna phi nthonyero nnohalha inyu uhimiechesha, nnokoomwoona mwaana navilhikelhelhiye ikuwo che inamwane ni waathalhelhiya nhiilhini.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wo uhipicha nlhoko mulhupalhe wo minepa o wiirimu nkawaawa vamoka ni nnepa ulhe, chiipaka ichipo cho untotopelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nthimicho wa Nlhuku wiirimu uchulhu, ni mpuha velhaponi va wa attu anochivelhiya awe!” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Minepa vaathamme aya ni uhokolhia wiirimu, ashunga alhe nkeerelhana ashineneru wiira, “Ngwee etu Ubethelehemu noonecheshe chikhumelhenlhe, chi ninohimeriya ihu na Apwiiya chi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Paahi etu nkayaakuviacha ni waaphwanya Amariamu ni Nayusufu ni umwoona mwaana naathalhelhiye nhiilhini. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ashunga vaamwonne aya, nkayaahimeria mwaha waahimeriye aya ni nnepa. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Attu onkhaye yeewa ahoshanga choolhumachiya na ashunga. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amariamu nkaathepa wuupuwelha mwaha wonkhaye munrimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ashunga nkayaahokolhia eepachaka ichipo cho untotopelha Nlhuku wo mwaha weewilhe aya ni woonechesha, waari thoko chaahimeriye aya ni nnepa. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yavireke mahuku nane, vaayilhe aya ikatema yo wiinelhiya unyawo mwaana, nkaavahiya nchina nawe Yesu, nchina naakumihiye ni nnepa wo wiirimu hinaya urupalhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mahuku nkaaya wo Nayusufu ni Amariamu urwaa uttukuriyani, thoko chaalheheriya ni Malhehero a ashinna Musa. Paahi etu nkayankusha mwaana unrweeha Uyerusalemu, uttukuriyani wa Athithi, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","thoko chaalhepiye aya nhina Malhehero a Athithi, “Kila nttara nilhopwana niihaniyeke ntakatifu a Athithi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yaarweelhe tho uukumihani isadaka ya akaulha elhi ama makhandi o ikhunda melhi, thoko chaalheheriya ni malheheriyo a Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yayo mahuku ayo ahokhalha ntu eehaniya Nasimeoni aakhalha Uyerusalemu. Yaari ntu orera nrima aapanga chaathanana awe Nlhuku awehereraka woopolhiya wo Israeli, Iphumu ya Nlhuku akhalhaka ni ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Iphumu ya Nlhuku aari anaahimiachenre wiira khanokhwa ahinaya umwoona Kuristo aalhehiye ni Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aholhelhiyaka ni Iphumu ya Nlhuku, Nasimeoni ahorwaa Inupa ya Nlhuku. Ni yeyo ikatema iyo manyanaangoro ahommwiiha mwaana Yesu wi Inupa ya Nlhuku uttukuriyani thoko chaalheheriya ni Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nasimeoni yahompochera mwaana mmiononi mwaya ni untotopelha Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Vano Pwiiya, nhotimiriha malhehano inyu, munhiyeke vano karumiya inyu arwee wo mpuha. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wo miitho aka kimwanene kihoona unoopolha winyu, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nkoronshe inyu wooniye ni attu inyu onkhaye, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nthuko wo wamwalhelha attu ahiri Ayahudi, ni nthuko wo nthimicho wa attu inyu Israeli.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Manyanaangoro o mwaana aahanlhe anoomiye uwanoni wo chittu chaahimiya ni Nasimeoni chimwaachaka mwaana. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nasimeoni nkaalhepelhelha ibarakha ni weerelha Amariamu anumwanawe, “Mwaana inyu ulha hothanlhiya ni Nlhuku wo nlhatu no upotera ni uhihimulhiya wa attu enchi o Uisraeli. Nohalha ukhalha ithikineha yo uvengiya ni attu ");
INSERT INTO mgh2016_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","chiicho wuupuwelha wa attu enchi unowa uchuwania. Ni inyu mwaanene nnowa ukelhiya ihuzuni yo uweria thoko uphanga wo wiithia, inoohomani munrimani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ahokhalha anamilhohi anankhwelhi o wulhuvalha, eehaniya Ana abiti Fanueli o nikosho ni Naasheri. Aakhanlhe ni owannyaya iyaakha saba tu. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aari o wulhuvalha, aaphiya iyaakha makhumi nane ni ncheshe, ni mahuku onkhaye yaari alhokelhaka wi Inupa ya Nlhuku uthana ni uhiyu, anthimichaka Nlhuku, attukaka ni unlhapelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yeyo ikatema iyo yaari anawiilhe unthimichani Nlhuku olhumachaka malhove anomwaacha mwaana wa attu onkhaye aaweherera woopolhiya wo Yerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nayusufu ni Amariamu vaamalhinhe aya upanga thoko chaalheheriye aya ni Malhehero a Apwiiya, yahohokolhia uwani Unazareti ilhapo yo Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwaana nkonnuwa ni upatta machiri, nkaachara irusho, ni nnema wa Nlhuku waari vamoka ni uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila iyaakha manyanaangoro a Yesu yaari arwaaka Uyerusalemu unlhiani Pasaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu vaari awe ni malhipa o iyaakha khumi khuwa miilhi, yahorwaa unlhiani Pasaka thoko cheera aya mahuku ene. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pasaka vaamanlhe awe, nkayaachokholha nkwaha wo uhokolhia uwani, nansho mwaana mwanhima Yesu aahanlhe Uyerusalemu. Manyanaangoro awe yaari ahichuwelhaka, ");
INSERT INTO mgh2016_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","yaari aanyiheraka wiira aari munkwahani mmo, paahi etu nkayeeta nkwaha wo nihuku phi yaachokhonlhe aya umwaavia mwaashilhoko aya ni manyampwana aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Khayaamwoonne, paahi nkayaahokolhia tho Uyerusalemu umwaaviani. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nihuku no neraru, nkayamphwanya nari wi Inupa ya Nlhuku, nakhanlhe vamoka ni owiittuchiha e Iyahudi, eewelhelhaka ni waakoha chookohiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Attu onkhaye yaamwiiwa ahoshanga cheera awe wo waakhulha wo irusho. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Manyanaangoro nkayoomiya uwanoni vaamwonne aya, ni anumwanawe nkayeera, “Mwaamwanaka, nlhatu waani wo upanga chiicho? Athumwana ni mii naari nuwaaviaka ninashannge.” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nkaakhulha, “Mwaakavierani? Khamwaachuwenlhe wiira ihokiphwanelha ukhalha nnupani mwa Athithi?” ");
INSERT INTO mgh2016_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nansho khayaachuwenlhe maana o malhove olhumacha awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Paahi etu Yesu nkahokolhia Unazareti vamoka ni manyanaangoro awe, nkeewelhelha ni wiitimarikha. Anumwanawe nkayaashunga mwaha wonkhaye uyo munrimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nkonnuwa nchusha ni ukhalha o irusho, athepaka uttuniya ni Nlhuku vamoka ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Iyaakha yo khumi ni nthanu yo utawara wa Nakaisari Natiberiyo, Apontio Pilato phi aari aatawara ilhapo yo Uyudea, Naherode aari atawaraka Ugalilaya ni ahima aya Nafilipo yaari atawaraka ilhapo cho Uturea ni Utrikoni. Alusaniya aatawara Uabileni, ");
INSERT INTO mgh2016_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ashinna Anasi ni Nakayafa phi yaari Opochera Ishaani Olhupalhe. Yayo mahuku ayo Nlhove na Nlhuku nkanaakhuruwelha Nayohana mwaana a Azakariya uthakoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Paahi etu Nayohana nkayaarwaa ilhapo chonkhaye chaatamana mwoolhoko wo Uyorodani, eettuchihaka wiira, “Nkhoromeke ni uhiya uwonya winyu mbatiiziyeke, Nlhuku nouhiyererani uwonya winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Phi lhepiye aya nkitabuni mwa anamilhohi ashinna Isaya wiira, “Ntu mmoka nookhuwelha muthakoni, ‘Nkooroshe iphiro yo uvira Apwiiya, mwookolhe mitalha chinohalha aya uvira! ");
INSERT INTO mgh2016_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila nlhikiti ninoowuhelhiya, kila mwalha ni mwaako unoolhokihiya. Iphiro cho uhookwaa chinowookolhiya, ni mitalha chinananre chinoorerihiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Attu onkhaye anomwona Nlhuku opolhaka attu!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Paahi etu, milhoko cha attu enchi nkayaawa u Nayohana uubatiiziyani. Nayohana nkayakoha, “Inyu iyari yo inwaa va, nhimeriye ni apani wiira nttawe ntwarusho Nlhuku unowiiha awe? ");
INSERT INTO mgh2016_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mpangeke etu mitheko cho wooniha etu wiira nhokhoroma ni uhiya uwonya winyu. Nhichokholhe vano etu wiira Aburahimu phi athumwaninyu. Kinouhimeriani wiira Nlhuku noworia uthathusha alha malhuku alha ukhalha ashaana a Aburahimu! ");
INSERT INTO mgh2016_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ipacho iri tayari ukakha mwiri vamithithaarini, miri chonkhaye chihinemma rata chinookakhiya ni urihelhiya vamooroni.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Attu nkayaakoha, “Niireke chani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nayohana nkayaakhulha, “Ntu ri ni ikuwo pilhi ammaheke imoka ntu hirina, ni ntu rini yolhia ankawelheke nkhunanawe hirina.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Attu yaalhiviha ikhodi nkayaawa uubatiiziyani, nkayaakoha Nayohana, “Owiittuchiha, ni hii niireke chani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nayohana nkayaakhulha yeeraka, “Nhinlhivihe ntu upwaha chilheheriye inyu waalhiviha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Manyaasikaari akina ni ayo nkayaakoha, “Ni hii chiicho, niireke chani?” Ni ayo nkayaakhulha, nkayeera, “Nhinthurulhe ntu nchurukhu awe ama umwootheria choomwotheria. Nthoshiyeke nchurukhu unolhiviya inyu uyo.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Attu nkaayaakhulhuvelha ittu, nkayaahalha oopuwelhaka munrimani wiira Nayohana ayo aari phi Kuristo Moopolhi aathanlhiye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Paahi etu Nayohana nkayeera, “Mii kinoubatiizani ni maashi, nansho ntu mmoka noowa ri mulhupalhe ukipwaha mii kihinooriaka inakhalhaka uthapulha miripwe cho iratu chawe. Yoyo noowa uubatiizani wo Iphumu ya Nlhuku ni mooro. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yoyo hanaa ithelho mmoononi yo ukhungurelha cholhia, akwechaka ipuwa awe yo weepettelha ni uthokoreria ingaano nnikhupini, ni upaha iphepuwa vamooroni vahintiphiaa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Paahi etu, vamoka ni meettuchiho o Malhove Orera makina menchi, Nayohana ahaakurumicha attu urukunusha makhalhelho aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nansho Nayohana yahaachacheracha Amwene Naherode nlhatu no waathelha Naherodiya, aari ahanu a ahima aya ni mwaha wo uhilhoka mwinchi waapanga aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Paahi etu Naherode nkayaathepiha uwonya waya, nkayaavara Nayohana ni waattuka ujeerani. ");
INSERT INTO mgh2016_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Attu onkhaye vaamanlhe aya ubatiiziya, Yesu ni uyo ahobatiiziya. Vaari awe anlhapelhaka Nlhuku, irimu nkachaahulhia, ");
INSERT INTO mgh2016_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ni Iphumu ya Nlhuku aari ni iruttu thoko kaulha nkayankorwelha. Ni nlhove nkaneewiya ukhuma wiirimu niiraka, “Uwe phi Mwaamwanaka kinonttuna aka. Uhokichivelha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu vaachokhonlhe awe ntheko mwaattuni, aari ni iyaakha makhumi mararu. Attu yaari amwaanyiheraka wiira aari mwaana a Nayusufu mwaana a Naheli, ");
INSERT INTO mgh2016_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwaana a Namaatati, mwaana a Lawi, mwaana a Nameliki, mwaana a Nayanai, mwaana a Nayusufu ");
INSERT INTO mgh2016_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwaana a Namatatiya, mwaana a ashinna Amosi, mwaana a Nanahumu, mwaana a Naesili, mwaana a Nanagai ");
INSERT INTO mgh2016_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwaana a Namaathi, mwaana a Namatatiya, mwaana a Nasemeini, mwaana a Nayoseki, mwaana a Nayoda ");
INSERT INTO mgh2016_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwaana a Nayoanani, mwaana a Nareesa, mwaana a Nazerubabeli, mwaana a Nashaltieli, mwaana a Naneeri ");
INSERT INTO mgh2016_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwaana a Nameliki, mwaana a Naadi, mwaana a Nakosamu, mwaana a Naelimadamu, mwaana a Nanaeri ");
INSERT INTO mgh2016_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwaana a Nayoshua, mwaana a Naelieza, mwaana a Nayorimu, mwaana a Namaatati, mwaana a Nalawi, ");
INSERT INTO mgh2016_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwaana a Nasimeoni, mwaana a Nayuda, mwaana a Nayusufu, mwaana a Nayonamu, mwaana a Naeliakimu ");
INSERT INTO mgh2016_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwaana a Namelea, mwaana a Namena, mwaana a Namatata, mwaana a Nanathani, mwaana a Adaudi ");
INSERT INTO mgh2016_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwaana a Nayese, mwaana a Naobedi, mwaana a Naboazi, mwaana a Nasalmoni, mwaana a Nanashoni ");
INSERT INTO mgh2016_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwaana a Naaminaadabu, mwaana a Naadimini, mwaana a Naarni, mwaana a Nahezironi, mwaana a Nafarisi, mwaana a Nayuda ");
INSERT INTO mgh2016_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwaana a Nayakhobo, mwaana a Naisaka, mwaana a Aburahimu, mwaana a Natera, mwaana a Nanaahori ");
INSERT INTO mgh2016_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwaana a Naserugi, mwaana a Nareu, mwaana a Napelegi, mwaana a Naeberi, mwaana a Nashela ");
INSERT INTO mgh2016_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwaana a Nakainani, mwaana a Naarfakisadi, mwaana a Nashemu, mwaana a Anuhu, mwaana a Nalameki, ");
INSERT INTO mgh2016_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwaana a Nametusela, mwaana a Nahenoko, mwaana a Nayaredi, mwaana a Namahalaleli, mwaana a Nakainamu ");
INSERT INTO mgh2016_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","aari mwaana a Naenoshi, mwaana a Naseeti, mwaana a Adamu, aari mwaana a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu nkaahokolhia Uyorodani nachanre Iphumu ya Nlhuku, nkaaholhelhiya ni Iphumu mpaka uthakoni, ");
INSERT INTO mgh2016_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","waalhikachiye awe ni Nakare wo mahuku makhumi ncheshe. Mahuku onkhaye ayo ahottuka wo uhilhia ittu, paahi etu avireke yayo mahuku ayo nkaawolhiya ithalha. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nakare nkaamwirelha, “Wakhalhaka uwe phi Mwaana a Nlhuku, ulheehereke etu wiira alha malhuku alha athathuwe nkatte.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nansho Yesu nkaakhulha, “Malhove Matakatifu aneera, ‘Ntu khanlhama wo ulhia nkatte vekha.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nakare nkankusha tho mpaka vachulhu ni umwooniha imwene chonkhaye cho velhaponi va. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nakare nkeera, “Kinouvaha ikuru wo chilha imwene chonkhaye chi ni urera waya. Chonkhaye chi chiri mmathathani mwaka, kathananaka ummaha ntu kinowooria. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mwakikhoromelhaka ni ukithimicha, chonkhaye chi chinookhalha chawinyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu nkaakhulha, “iholhepiya, ‘Mwaathimicheke Athithi, Nlhuku inyu vekha aya ni uvara mitheko chaya!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nakare nkanrweeha mpaka Uyerusalemu vachulhu ishanja yo Inupa ya Nlhuku, nkeera, “Wakhalhaka uwe phi Mwaana a Nlhuku, paahi etu uthupeke mpaka vathi. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ukhalhawaya Malhove Matakatifu aneera, ‘Nlhuku noolhehera minepa chawe chiwe chuwopolheni.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ni vawo tho aneera wiira, ‘Anoukushani mmathathani mwaya nhiwe mwaarakalha mmalhukuni.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nansho Yesu nkaakhulha, “Iholhepiya, ‘Nhinlhikache Nlhuku, Athithi inyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nakare amalheke unlhikacha Yesu wo kila iphiro, nkanhiya mpaka ikatema inothananiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Paahi Yesu ahohokolhia Ugalilaya, ni ikuru yo Iphumu ya Nlhuku yaari vamoka ni uyo. Mwaha unomwaacha nkawaawanelha mwiilhaponi mwonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nkeettuchiha mu inupa chaya cho unlhapelha Nlhuku, nkaatotopelhiya ni attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Paahi etu Yesu nkaarwa Unazareti, iwani yonnuwenlhe awe, ni Nihuku no Wiittuwa nkaarwa u inupa yo unlhapelha Nlhuku thoko chaalhemalhenlhe awe. Nkeemelha ushoma Malhove Matakatifu ");
INSERT INTO mgh2016_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nkaavahiya nrapalha naalhepiye Malhove Matakatifu ni anamilhohi ashinna Isaya wiira ashome. Nkaapatakulha ni ushoma vakittu valhepiye wiira, ");
INSERT INTO mgh2016_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Iphumu ya Athithi uri vamoka ni mii, ukhalhawaya ahokihika makhura wiira kaahimerie Malhove Orera amashikini. Ahokiruma kihimiache uhiyereriya attu attukiye ni woonihiya tho attu ahinoona, ni woopolha attu anohuvihiya ");
INSERT INTO mgh2016_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ni uhimiacha wiira ikatema ihaaya Athithi vanohalha aya woopolha attu aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu nkaavilhika ikitabu ni uhokolhosha wa namitheko aashunga, nkaakhalha vathi. Attu onkhaye wi inupa yo unlhapelha Nlhuku mmo nkayammweha wo miitho melhi paranda, ");
INSERT INTO mgh2016_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","venre awe, “Alha Malhove Matakatifu alha ahotimira lhelho, thoko chinre inyu wo wiiwa kishomaka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Attu onkhaye nkayaachivelhiya, nkayaashangacha wiiwa malhove o nnema aahimiacha awe. Nkayaakohanacha yeeraka, “Ana ulha kahiwena mwaana a Nayusufu ulha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nkeerelha wiira, “Kihochuwelha wiira nnookiirelha nlhikaaniho no wiira, ‘Namirete, wiilhamiheke umwanene.’ Ni ukiirelha tho kipangache chittu mwiiwilhe inyu kipangachaka Ukapenaumu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Kinouhimeriani wo ikekhiaye tho wiira, anamilhohi khanolhohiya uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nansho nkakiiweni, wo ikekhiaye, wahokhalha anankhwelhi enchi mwiilhaponi mu Israeli mwonkhaye mu ikatema i Naeliya, irimu vaattukiye aya, ni ipulha khayarumpe iyaakha taaru ni nusu ni ikuruna nkayaawanelha ilhapo yonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ni Naeliya khayaarumiye wa anankhwelhi ariyoothe ahikhalhe anankhwelhi yaakhalha Userepta umwiinanoni ni ilhapo yo Usidoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tho, yahaawo attu enchi yaawereiya makutulha mwiilhaponi mu Israeli Naelisha vaari aya anamilhohi, nansho khaawo ntu aalhamme ahikhalhe Nanaamani, ntu o Usiriya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Attu onkhaye yaari inupa yo unlhapelha Nlhuku veewilhe aya chiicho, nkayaarushiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nkayeemelhacha, nkayankhweremiha uchereshere iwani ni unkusha mpaka vachereshere mwaako wiira ankakhelhe vathi wuuthi mwaako, ");
INSERT INTO mgh2016_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","nansho nkaavira variyari aya ni urwaa. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Paahi Yesu nkaarwa Ukapenaumu, iwani yaari Ugalilaya, nkeettuchiha attu Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Attu onkhaye yaari ashangaka chettuchiha awe, ukhalhawaya olhumacha wo ikuru. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nkaakhalha ntu o mashoka o unanara wi inupa yo unlhapelha Nlhuku mmo, akhuwelha chinene, ");
INSERT INTO mgh2016_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Niuttekenlheni hii, uwe Yesu o Nazareti? Uwilhe unoomolha? Kihochuwelha chinre awo, uwe phi karumiya ntakatifu a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu nkoomolha nshoka no unanara nno, “Mmaalhe munkhume ulha ntu ulha!” Nshoka nkanammulhusha ntu ulhe vathi, nkanaathama wo hinrakalhiha. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Attu onkhaye nkayoomiya uwanoni olhumachaka ashineneru, “Ilha phi ishiyani vano? Wo machiri ni ikuru yolha ntu ulha nolhehera wiira mashoka o unanara, athamache, ni ayo anoothamacha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mwaha wa Yesu nkawaawanelha kila vakittu velhaponi vawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nkaathama wi inupa yo unlhapelha Nlhuku nkaakelha unupani wa Nasimoni. Wowo ahokohi aya Nasimoni yaari areta iruttu, Yesu nkaahimeriya. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nkaarwa vaathalhelhiye aya ni weemelha vachereshere ikori ni woomolha ureta waathame apwiyawe ayo. Ureta nkawaalhama, nkayaachokholha waaterekhelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Uchechilho, attu yaari ni manyampwana aya yaawereia nkayaawiihacha areta ayo wa Yesu, ni uyo nkeesheracha miono chawe kila mmoka nkayaalhamacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mashoka o unanara ni ayo nkaayathamacha attu enchi, olhumachaka, “Uweva phi Mwaana a Nlhuku!” Yesu nkoomolha mashoka o unanara wiira ahihokolhiache tho ni ayo khayoolhumanche tho, ukhalhawaya ahochuwelha wiira aari phi Kuristo Moopolhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Waashelhe waya Yesu ahothama vawani vawo, nkaarwa vakittu vaari awe yeekha. Attu khayaachokholha umwaavia, vaamwonne aya, nkayanchiichiha wiira hithame uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nansho nkeerelhacha, “Kihophwanelhiya uhimiacha Malhove Orera o Imwene ya Nlhuku iwani chikina, ukhalhawaya Nlhuku kirumme wiira kipange yoyo ntheko uyo.” ");
INSERT INTO mgh2016_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Paahi etu nkaavira eettuchihachaka attu mu inupa cho unlhapelha Nlhuku ilhapo yonkhaye yo Uyudea. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nihuku nimoka Yesu aari neemenlhe vachengweni nttiya no Genesareti, attu vaathothokanacha aya uwa uwiiwelhelhani nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nkoona ikalhava pilhi vachereshere nttiya, ashinene yaari anakhuruwilhe alhokihachaka ittavi chaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu nkaawelha ikalhava imoka i Nasimoni, nkaalhepelha anene ayo wiira athame vachengweni vawo achusheriheke miholho vakani. Nkaakhalha nkalhavani mmo ni weettuchiha milhoko cha attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Amalhiheke weettuchiha attu, nkeerelha Nasimoni, “Nchusheriheke ikalhava inyu mpaka variyari nttiya, mwarieke ittavi chinyu chiyo mwavare ihopa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nasimoni nkayaakhulha, “Thithi, nihoshelhelhiha wo uhipatta ittu. Nansho wo nlhove ninyu, kinokoriaa ittavi vano.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Arieke ittavi mmaashini, nkayaarulha ihopa chinchi, mpaka ittavi waatameria upaphuwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nkayeehana ashikhunanaya yaari ikalhava ikina, awe aakaviha. Nkayaawacha, nkayaacharihacha ihopa ikalhava pilhi chonkhaye chaatameriaka utitimira mmaashini. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nasimoni Peturo voonne aya ikhumelhenlhe, nkayankhoromelha Yesu amwiirelhaka, “Nthame vawannnyaka va, Thithi! Ki ntu o uwonya mii!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Napeturo anene vamoka ni ashikhunanaya nkayoomachiya uwanoni wo woona ihopa chinchi thoko chechiyo chaavarilhe aya chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yaari chiicho ata u Nayakhobo ni Nayohana ashaana a Nazebedayo, akavihi nanaya Nasimoni. Yesu nkeerelha, “Nhoovache mwaatti, uchokholha lhelho va nnookhalha o woopolha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nkayaapurulha ikalhava mpaka uchengweni, nkayaahiya kila ittu ni unttwara Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nkayaakhalha wiira Yesu vaari awe iwani imoka ntu mmoka aawereiya makutulha ahomwoona, nkaawa wa Yesu. Nkeewulhusha makukhu ni unlhepelha Yesu, “Thithi, mwattunaka, nnowooria ukilhamiha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu nkookolha moono awe ni ummara ntu o makutulha uyo nkaamwiirelha, “Kihothanana, nlhameke etu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nkanlhehera ntu uyo wiira, “Nhirwee uhimiecheshani wa attu, nansho nrweeke mweechoniheke wa opochera ishaani, mwakumiheke isadaka inyu mwiittukurie wiira nholhama thoko chilheheriye aya ni ashinna Musa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nansho mwaha waapannge awe Yesu nkawaawanelha kila vakittu. Attu enchi nkayaathukumana uumwiiwelhelhani ni ulhamihiya mareta aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nansho nkaathama ni urwaa vakittu vo yekha awe, nkaakhalha wowo anlhapelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nihuku nimoka Yesu aari eettuchihaka, Amafarisayo akina ni owiittuchiha Malhehero yaakhumme iwani cho Ugalilaya ni Uyudea ni Uyerusalemu, yaakhalhanche eewelhelhaka. Machiri a Athithi aari vamoka ni uyo wiira aalhamihe areta. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nkayaawa attu yankushilhe vankorini ntu o uririyacha iruttu, nkayaalhikacha unkelhiha mpaani mwaari awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nansho attu chenre aya wo uchara, khayoonrie ukelha mpaani. Paahi etu, nkayankusha mpaka vachulhu nchaara, nkayaakhunulha nivatho wiira anvirihe ni ikori awe mpaka vaari awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu vonne awe yoyo nrima aya uyo, nkaamwirelha ntu o ririyacha moono uyo, “Uhohiyereriya uwonya wao, mpwana aka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Owiittuchiha Malhehero ni Amafarisayo nkayaachokholha wiikoha ashineneru, “Ana phi mpani yolha nonlhava Nlhuku ulha! Nlhuku vekha awe phi nohiyerera uwonya!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu ahochuwelha ichuku chaya, nkeera, “Nlhatu waani wo uchukulhacha munrimani chiicho? ");
INSERT INTO mgh2016_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Vaalhuwilhe vayi ana, wiira, ‘Uwonya winyu uhohiyereriya,’ ama wiira, ‘Munkweke nrweeke?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kinowoonihani etu wiira, Mwaana a Ntu hanaa ikuru velhaponi va yo uhiyerera uwonya wa attu.” Paahi etu nkaamwiirelha ntu o moono wo uririyacha ulhe, “Kinoohimeriani wiira, munkweke, mwiirieke nkori inyu nhokolhieke uwani!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Vavawo vavawo ntu ulhe nkeemelha attu yoonaka, nkaakusha nkori waarupelha awe, nkaahokolhia uwannyawe, anthimichaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Attu onkhaye nkayaahalha malhaku mwaari! Aari yoovaka, nkayanthimicha Nlhuku yiiraka, “Nihoona chittu cho ushangiha lhelho!” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yamalhekeru, Yesu nkaakhuma vathe nkaamwona ntu aalhiviha ikhodi eehaniya Lawi, nakhanlhe vanupani vaalhiviha awe ikhodi. Yesu nkaamwiirelha, “Nkittware.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nalawi nkayeemelha, nkayaahiya kila ittu ni unttwara Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yamalheke Nalawi nkayanterekhelha Yesu yolhia yo uchechilho, ni alheto yaalhalheiye yaari attu olhiviha ikhodi enchi aakhanlhe unlhiana Yesu vamoka ni attu akina. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amafarisayo akina ni owiittuchiha Malhehero nkayaachukulha, nkayaakoha owiittucha a Yesu yeeraka, “Chani woonaka mwaatti nnolhia ni uwuria vamoka ni attu o ulhiviha ikhodi ni attu o uwonya?” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu nkaakhulha, “Attu arii akumi khanaavia abwana mganga, ihikhalhe areta phi naavia. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Akiwiilhe u weehanani attu anopanga chittu cho urera wiira akhorome, nansho attu o uwonya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Attu akina nkayaamwiirelha Yesu, “Owiittucha a Nayohana anoottuka venchi ni ulhapelha, ni owiittucha a Amafarisayo anopanga chiicho, nansho owiittucha inyu anolhia ni uwuria.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu nkaakhulha, “Chani attu alhalheiye u arusini ahophwanelhiya uttuka abwana arusi anari vavawo? Mena! ");
INSERT INTO mgh2016_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nansho nihuku ninoowa abwana arusi vanowa aya uthamihiya, vavawo attu phi nowa aya aattuka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu nkaahimeria tho nna nlhikaaniho nna, “Khaawo ntu neesha imbaati yo naanano vachulhu ikuwo yoothalha. Eeraka chiicho, noothepiha ikuwo iyo waahuwa, ni imbaati iyo khinaathana ni ikuwo yo khalhayi. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chiicho khaawo ntu nohelha idivai yoochasha ntumpa wo nrapalha wo wuulhuvalha, ukhalhawaya idivai yoochasha iyo inoopwesha ntumpa uyo ni urihiaa. ");
INSERT INTO mgh2016_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nansho, idivai yoochasha inohelhiya mu nrupa nkumi! ");
INSERT INTO mgh2016_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Khaawo ntu nothanana uwuria idivai ihinachasha amalhihaka uwuria idivai yoochasha. Attu aneera, ‘Ittu yo khalhayi phi nlhoka chinene.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu aari etakachaka mmamatani Nihuku no Wiittuwa. Owiittucha awe nkayonthacha machashi o meelhe, nkayaatikitta ni ukhuura imbeyu chaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amafarisayo akina nkayaakoha, “Nlhatu waani upanga ittu ichiichihiye ni Malhehero wiira ihipangiye Nihuku no Wiittuwa?” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu nkaakhulha, “Ana khannashoma yaapannge aya Adaudi ni ashikhunanaya vaawolhiye aya ithalha? ");
INSERT INTO mgh2016_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ahokelha Inupa ya Nlhuku, nkayaalha mikatte chaakumihiye isadaka wa Nlhuku, nkayaalhia, ni waakawelha ashikhunanaya. Mikatte chaachiichihiye ulhiya ni attu akina yaakhihale opochera ishaani vekha aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu nkaamalhiha eeraka, “Mwaana a Ntu phi Mwanene Nihuku no Wiittuwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nihuku no Wiittuwa nikina, Yesu ahorwaa wi inupa yo unlhapelha Nlhuku ni wettuchiha attu. Ahokhalha mwommo ntu o moono wo uririyacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Owiittuchiha Malhehero akina ni Amafarisayo nkayaavia nlhatu wo mwootheria wiira hotteka, paahi etu nkayammweha paranda yoone yakhalhaka nonlhamiha ntu uyo Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nansho Yesu ahochuwelha ichuku chaya nkaamwirelha ntu ulhe, “Munkweke mmweeke. Mweemelhe uholho unouno.” Nkeemelha nkaawa uholho. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Paahi Yesu nkeerelha, “Kinoukohani mwaatti, Ikekhia ihu inaacha Nihuku no Wiittuwa inonilhehera nipangekeni lhelho? Upanga ittu yo urera ama yo uhilhoka? Woopolha ukumi wa ntu ama wiiva?” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nkaaweha attu onkhaye yaari vavawo, nkaamwirelha ntu o moono wo uririyacha ulhe, “Wookolheke moono awo uyo.” Nkookolha, nkawaalhama nkawaakhalha nkumi tho. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nansho attu yanvenga Yesu nkayaathunalhacha, nkayaakhalha ashineneru yaaviaka nlhatu wo umwiiriha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yesu nkaarwa umwaakoni ulhepelhani, nkaashelhelhiha wowo anlhapelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Waashelhe waya, nkeehanacha owiittucha awe ni waathanlha khumi ni elhi, ehanne awe akarumiya, ");
INSERT INTO mgh2016_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nasimoni aavanhe awe nchina Napeturo ni ahima aya Naandorea ni Nayakhobo ni Nayohana ni Nafilipo ni Nabatolomayo ");
INSERT INTO mgh2016_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Namatayo ni Natomaso ni Nayakhobo ashaana a Alufayo ni Nasimoni eehaniya nnenchi ");
INSERT INTO mgh2016_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nayuda mwaamwanaa Nayakhobo ni Yuda Isikariote, anthuminhe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Vaakhuruwilhe awe umwaakoni ni akarumiya awe, nkeemelha ni waaphwanya owiittuchiha awe enchi anathothokanne vamoka. Yayo yaari attu yaakhumme ilhapo cho Uyudea ni Uyerusalemu ni iwani cho umbwaani cho Utiro ni Usidoni, ");
INSERT INTO mgh2016_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","aawachilhe umwiiwelhelhani ni uwa uulhamihiyani mareta aya. Attu yaahuvihiya ni mashoka o unanara ni ayo ahowaacha uulhamihiyani. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Attu onkhaye yaari athananaka inakhalhaka uvara mwiinjiro wawe, ukhalhawaya machiri aari ankhumaka ni waalhamiha attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu nkaaweha owiittucha awe nkeera, “Nhoreeriya mwaatti nnohuvelha unchuwelha Nlhuku va, umwene wa Nlhuku phi wawinyu! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nhoreeriya mwaatti nnowolhiya ithalha va, ukhalhawaya nnoowa mwaawonihiya! Nhoreeriya mwaatti nnonlha vano, ukhalhawaya nnoowa mwaathiaa ni uteelhiya!” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nhoreeriya mwaatti vanopangelhiya inyu ichimwa ni attu, okhotakani, oruwanakani ni uheulhacha nchina ninyu wiira nhopanga ittu yo uhilhoka wo nlhatu wo Mwaana a Ntu! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nteelhiyeke vanohalha aya ukhumelhelha yayo, ntapelhelheke wo ushangarara, ukhalhawaya wo ikekhiaye nhoshungeriya nttuvo nulhupalhe wiirimu. Kwaani ata manyaapwiiya aya aapannge chiicho, waapangelha anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nansho nhothapana mwaatti attu o nhakhu va, ukhalhawaya nhomalha upuha! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nhothapana mwaatti nnorupalha vano va, ukhalhawaya nnoowa mwaawolhiya ithalha! Nhothapana mwaatti nnothiaa vano va, ukhalhawaya nnoowa mwonlha ni uthuthelha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Nhothapana mwaatti vanototopelhiya inyu ni attu, ukhalhawaya manyaapwiiya aya ahaapangelha chiicho anamilhohi o woothacha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nansho kinouhimeriani mwaatti nnokiiwa va, mwaattuneke attu anoupangelhani ichimwa, ");
INSERT INTO mgh2016_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mwaalhapelhelheke ibarakha anoulhavani, mwaalhapelhelheke attu anoupangelhani ichimwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ntu owaatakani nrama ninyu nimoka, munhiyereke owatekeni nikina no nayelhi nno, ntu othurulhakani nikoti ninyu, munhiyereke ni mwiinjiro winyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ntu noovekelhani mummaheke, ntu akushaka nhakhu inyu nhintware wiira ohokolhoshereni. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chineera inyu wo uthanana wiira mpangelhiye ni attu, mwaapangelheke ni ayo chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mwaattunaka attu anouttunani vekha aya, nnohalha chani upochera nnema? Ata attu o uwonya anaattuna attu anaattuna aya! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mwapangaka moombone wa attu anoupangelhani moombone, chani nnohalha upatta chani ibarakha? Ata attu o uwonya aneera chiicho wa attu anaapangelha moombone! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Vavawo mwaashimihaka attu nnokhulhuvelha wiira anouhokolhosherani, nnohalha upatta chani ibarakha? Ata attu o uwonya anaashimiha attu anaahokolhoshera! ");
INSERT INTO mgh2016_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mena! Mwaattuneke amalhaponi inyu ni waapangelha moombone, mwaashimiheke nhikhulhuvelhaka uhokolhosheriya. Vavawo nnoowa mwaapatta nttuvo mwinchi, ni ukhalha ashaana a Nlhuku Mulhupalhe Chinene. Ukhalhawaya ri o uwiiha mpuha wa attu ahichuwenlhe ushukuru ni o unanara mirima. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nkhalheke attu o kiriri thoko Athumwaninyu chiri aya o ikiriri.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nhaahukumulhe attu akina, Nlhuku khanowa ohukumulhani, nhaakuphulhache attu akina, ni inyu nhiwe mwaakuphulhachiya, mwaahiyerereke attu akina, Nlhuku ohiyererekeni ni inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwaavaheke attu akina, Nlhuku nouvahani ni inyu. Chiicho etu nnoowa mwaapochera wo winchiva chinene, nikaviho mmathathani mwinyu. Maphimelho inyu wa attu, phi maphimelho nnohalha inyu uphimelhiya ni Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu nkaahimeria nna nlhikaaniho nna, “Ntu ohoona khanooria unholhelha ntu ohoona nanawe, eeraka chiicho, onkhaye elhi ayo anootumbuchira munlhikitini. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Khaawo owiittucha naapwaha owiittuchiha awe, nansho owiittucha amalhaka wiittucha phi nolhikaana awe ni owittuchiha awe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nlhatuni etu no woona ikokholha nnithoni mwa nhima inyu uno nhoonaka nipattu niri nnithoni mwinyu mwaanene? ");
INSERT INTO mgh2016_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nnohalha wiira chani wa nhima inyu, ‘Nhima aka nkankani kuuthamihe ikokholha nnithoni mwao,’ nansho nhithamihaka nipattu niri nnithoni mwinyu mwaanene? Mwa anafiki inyu! Nthamiheke thoko nipattu nnithoni mwinyu, vavawo phi nohalha inyu wooria uthamiha ikokholha nnithoni mwa munninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mwiri wo ukonda khunemma pufia, mena mwiri wo uhikonda khunemma maphepu oombone. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mwiri uriwoothe unchuwania wo maphepu unemma aya, khavanooria urukulha ittini munrokani ama urukulha izabibu va mwiri wo miiwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ntu o nrima woombone nopanga mitheko choombone chiri munrimani mwawe, ntu o uhilhoka nopanga chittu cho unanara chiri munrimani mwawe. Malhaku anoolhumacha chittu chichanre munrimani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nlhatuni no ukiihana mii, ‘Thithi, Thithi,’ uno nhipangaka thoko chineera aka wo ulheherani? ");
INSERT INTO mgh2016_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ntu nokiweelha ni wiiwelhelha malhove aka ni uvarechesha Kinouhimeriani chiri awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nokhalha thoko ntu, notheka inupa awe, athipaka chinene ni utheka nsingi vamwalhani. Mwoolhoko nkawaapaphulha maashi ni ukhita inupa iyo nansho kayaatikhinyelhe, ukhalhawaya yaaholhipihiya vaathekiya aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nansho ntu riyoothe neewa malhove aka wo uhivarechesha, nokhalha thoko ntu notheka inupa awe wo uhithipa nsingi vathi, maashi atikhinyeke inupa iyo, yahowulhuwa phiyaru wo nkhito urrrr!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu amalhiheke waahimeria attu yayo malhove onkhaye ayo, nkaarwa iwani yo Ukapenaumu. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nholhelhi o manyaasikari o Urumi ahaana namitheko anttuna aya chinene, yoyo aari nreta chinene amwaatameriaka nookhwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nholhelhi uyo veewilhe aya mwaha wa Yesu, nkaaruma ashulhupalhe Ayahudi amwiirelhe awe anlhamiha namitheko awe uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nkayaarwaa wa Yesu ni ummenda, ampepechaka wiira, “Yolha ntu ulha hophwanelhiya wiira mwankavihe. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Noottuna ilhapo ihu, tho honikaviha utheka inupa yo unlhapelha Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Paahi etu Yesu nkaattukana. Vaari awe naatamenrie vawani, nholhelhi uyo nkaaruma attu anhimerie Yesu wiira, “Thithi, mii akiphwanelhiye wiira inyu nkelhe unupani waka, ");
INSERT INTO mgh2016_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","phi nlhatu etu akoonrie uwa kimwanene uwiihanani. Mulhumacheke nlhove tu, namitheko aka noolhama. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mii kimwanene, ki ntu o ipilhi wa attu akina, kihanaa ikuru yo wemelhelha manyaasikari. Kamwiirelhaka mmoka, ‘Nrweeke!’ Khurwaaka, nkina kamwiirelhaka, ‘Nkaawa va!’ Khuwaaka, kaarumaka anamitheko aka, ‘Mpangeke ilha!’ Khupangaka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu nkaashanga veewilhe awe nna nlhove nna, nkaarukunuwa ni weerelha attu anttwara ayo, “Kinohimia wiira, akinapacha woona nrima thoko ulha, ata mwiilhaponi mu Israeli mwonkhaye!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Anamitheko nkayaahokolhiacha waarumiye aya ni umphwanya karumiya nreta ulhe nalhamme. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kaanyuma vakani, Yesu nkaarwa iwani yeehaniya Unaini, aattukanaka vamoka owiittucha awe ni mphingo mulhupalhe wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vaaphiya awe wowo, nkaakumaana attu aarwaa unvithani ntu. Ntu aakhwilhe uyo aari mwammirawo o yekha wa anumwane, yaari anankhwelhi, avelhelhiyaka ni nlhoko mulhupalhe wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Athithi vonne aya anankhwelhi ayo, nrima waya nkawaakelhiya ihuzuni yo woonelha ikiriri anankhwelhi ayo, nkeerelha, “Nhunlhe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nkaachushera, nkaapaapelha ikori yaatheshelhiye ntembo uyo, attu aawelhe ayo nkayeemelhacha. Yesu nkeera, “Mmirawo! Kinowiirelha wiira, wunkweke!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mmirawo aakhwilhe uyo nkaakhalha ni uchokholha wulhumacha, Yesu nkanhokolhosha wa anumwane. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Attu onkhaye nkayoovacha chinene, nkayanthimicha Nlhuku, yiiraka, “Namilhohi a Nlhuku mulhupalhe honikhumelhelha! Nlhuku howa uwoopolhani attu awe!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yoyo mwaha waapannge awe Yesu uyo, nkawaawanelha ilhapo yo Uyudea yonkhaye ni ilhapo chaatamana aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Owiittucha a Nayohana nkayaahimeria Nayohana yoyo mwaha wonkhaye uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nayohana etu, nkaaruma owiittucha ya elhi arwee yaakohe Athithi wiira, “Chani inyuva phi alhe aahimiye ni Nayohana wiira, phi nowa ama naaweherereke akina?” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Paahi vaaphilhe aya wa Yesu, nkayeera, “Nayohana Obatiiza ahoniruma nuukoheni wiira inyuva phi alhe aaromonlhe aya wiira haawo nowa ama nimmweherereke ntu nkina?” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yeyo ikatema iyo Yesu aari aavahaka attu enchi nnema wo ulhamihiya mareta aya, ikwerere ni mashoka o unanara ni waattukulha miitho attu ohoona. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nkaakhulha akarumiya a Nayohana wiira, “Nhokolhieke mwaahimerieke Nayohana chittu chonne inyu, attu ohoona anowoona, attu oheeta anoweeta, attu o makutulha anoolhamihiya, attu ohiiwa anowiiwa, attu akhwilhe anoohihimushiya ni attu anokwana anoohimeriya Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ahoreeriya attu ahiri ni nipampa ni mii!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Owiittucha yaarumiye ni Nayohana vaathamanche aya, Yesu ahochokholha waahimeria attu mwaha unaacha Nayohana, “Vaarwelhe inyu u Nayohana uthakoni ulhe, mwaanyihera wiira nnokowoonani? Nthalhe utikhinyiyaka ni iphioo? ");
INSERT INTO mgh2016_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mwaanyihera anoonieke chani? Thoko ntu warenlhe ikuwo chorera? Attu anowara chittu cho nthimicho ni ukhalha apuhaka yayo anokhalhacha uttato! ");
INSERT INTO mgh2016_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nkihimerieke etu, mwaakenlhe woonani? Woona anamilhohi a Nlhuku? Eiyo, nansho nkamwoona chaathempe anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ukhalhawaya Nayohana phi alhe ahimiye ni Malhove Matakatifu wiira, ‘Nlhuku heera, Kinonruma karumiya aka oholhelheni akooroshe iphiro inyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu nkeera tho, “Nayohana phi olhupalhe waapwaha attu onkhaye apanche ukhalha velhaponi va. Nansho ntu ri mwankani nhina Imwene ya Nlhuku phi mulhupalhe waapwaha Nayohana Obatiiza.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Attu onkhaye nkayaamwiwa, attu aalhiviha ikhodi nkayaarumelhelhacha ni utotopelha mitheko choombone cha Nlhuku, akhalhaka phi attu yaapochenre ubatiizo u Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nansho Amafarisayo ni owiittuchiha Malhehero a ashinna Musa ahokhotacha unrumelhelha Nlhuku, ni ukhota ubatiiziya ni Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu nkeera tho, “Vano etu, kinohalha ulhikaaniha ni ittu yaani ilha iyari ilha? Attu aya ari thoko chani? ");
INSERT INTO mgh2016_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ari thoko ashimirawo aakhalhanche mmapuwani nnopangiya maronda ni wiichiirelha ashineneru, ‘Nahowopelhani ikoma nansho khamwenne! Naheepa ichipo cho nunlhiho nansho khamwonlhilhe!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nayohana Obatiiza yahowa, ahottuka, khaawunrie idivai, mwaatti nkamweera, ‘Mmwooneke, ri ni nshoka no unanara!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwaana a Ntu nkaawa, nkaalhia ni uwuria, ni mwaattiva nkamweera, ‘Nkamwooneni yolha ntu ulha! Ntu o menyekha ni uhapalhiya, mpwana aya attu anolhiviha ikhodi ni attu o uwonya!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Irusho cha Nlhuku, inakhalhaka chiicho, chinohimiecheshiya wiira cho ikekhia ni attu anrumelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Afarisayo yahonlhalhia Yesu wiira alhie yolhia vamoka ni ayo, nkarwaa uwannyaya nkaakhalha ulhia yolhia. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yeyo iwani iyo ahokhalha opani amoka aapangacha chittu cho uhilhokalhoka. Nkayeewa wiira Yesu aari alhiaka yolhia wa Afarisayo, nkayaakusha ichupa yo malhuku o alabasta yaachanre makhura o unukhelha ");
INSERT INTO mgh2016_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","nkayeemelha amwaatameriaka Yesu uno onlhaka, nkayaammorihelha miithori chaya, vamietoni. Nkayaapoholha ni ikharari mmuruni, nkayaanukhanukha, nkayanhikahika makhura o unukhelha ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Afarisayo ayo vonne aya, nkayeera munrimani mwaya, “Ulha ntu ulha akaari namilhohi, anochuwelha chiri aya alha opani anommarakacha alha, aanachuwelha chiri aya ntu o uwonya!” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu nkoolhumacha eeraka, “Nasimoni, kihanaa nlhove no uhimeriani.” Afarisayo nkayaakhulha, “Aye, Owiittuchiha, nkihimerieke.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu nkeera, “Ahaawo attu elhi yaashimme nchurukhu wa ntu. Mmoka aashimme nchurukhu idinari imia nthanu ni nkina aashimme nhakhu idinari makhumi nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Attu ayo voochenlhe aya ulhiva, aheehanacha ni waahiyerera milhatu chaya onkhaye. Paahi etu, wa yayo attu elhi ayo, phuuyi nohalha waattuna chinene attu aashiminhe nchurukhu alhe?” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nasimoni nkayaakhulha, “Mii kinoona wiira, ntu aahiyereriye nchurukhu mwinchi ulhe, phi nohalha unttuna chinene yoyo ntu uyo.” Yesu nkeera, “Vavawo nhohukumulha rata.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nkaarukunuwelha opani alhe nkeerelha Nasimoni, “Nnoowona alha opani alha? Vaawilhe aka unupani winyu, khamwaakivanhe maashi o ukhucha mieto chaka, nansho alha opani alha ahokikhuchiha inyaa ni miithori aya nkayaapoholha ni ikharari chaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Khankipochenre rata ni ukibuusu, nansho alha ikatema yonkhaye ari vaa vamoka ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Khankivanhe makhura o wiihika mmuruni, nansho alha ahokootiha makhura o unukhelha mmietoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kinouhimeriani wiira, uttuna woninhe aya uhaapanga ahiyereriye uwonya waya wonkhaye. Nansho nohiyereriya makani, yoyo nottuna vakani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu nkeerelha opani alhe, “Nhohiyereriya uwonya winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Attu akina yaakhalhanche vayolhiani vawo, nkayoolhumacha ashineneru, “Phi ntu ani yolha, naahiyerera attu o uwonya ulha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nansho Yesu nkeerelha opani alhe, “Nrima inyu uhowoopolhani, nrweeke wo mpuha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Athameke vavawo, Yesu ahorwaa nkwaha wo mmawani ni ittoko ahimiachaka Malhove Orera o Imwene ya Nlhuku. Akarumiya awe khumi ni elhi yaari anttukanaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tho, akina yaari manyopani oomolhelhiye mashoka o unanara ni Yesu ni ulhamihiya mareta aya. Yayo phi anganya Amariamu eehaniya Magidalena, omolhelhiye mashoka saba, ");
INSERT INTO mgh2016_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nayoana mahanu a Nakuuza attu aapanga ntheko upuwani u Naherode, Asusaana ni manyopani enchi akina aakumiha nhakhu waya unkavihera Yesu ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Milhoko cha attu nkachaarwa wa Yesu chikhumaka iwani imoka baada ye ikina. Vaari aya anachanre, Yesu nkaahimeria nna nlhikaaniho nna, ");
INSERT INTO mgh2016_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ahokhalha ntu mmoka aarweelhe uwaalhani imbeyu cho meelhe. Vaalha awe aari amichaka, nkachaakhalha chaamonre vaphironi, nkachaanyikalhachiya na attu, ni ashinuni o wiirimu nkayaalhiacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chikina chaamorenlhe vamwalhani, vaamenlhe aya nkachaanyalha, ukhalhawaya ittaya khayaari ni maashi. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imbeyu chikhwawe chaamorenlhe vaari ittaya yoombone, chahomelha ni utiyelhelhiya ni miiwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chikina chaamorenlhe vachaayirani chinene, minyepu nkachonnuwa ni uyara meelhe, kila nchashi imbeyu imia imoka.” Yesu nkaamalhiha eeraka, “Ri ni maaru eeweke!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Owiittucha awe nkayankoha Yesu maana o yayo malhikaaniho ayo, ");
INSERT INTO mgh2016_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ni uyo nkaakhulha, “Irusho cho uchuwelha chittu cho Imwene ya Nlhuku nvahiye mwaattiva, nansho attu akina yayo anohalha uchuwelha wo malhikaaniho, vano anooweha nansho khanoona, anowiiwa nansho khanowa aachuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Maana o nlhikaaniho nno phi wiira, imbeyu phi nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeyu chaamonre vaphironi chinooniha attu aneewa, nansho Nakare noowa ni ukusha nttenga uyo mmamirimani mwaya wo waachiichiha wiira ahirumelhelhe ni woopolhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imbeyu chaamonre vamwalhani chinooniha attu aneewa nttenga ni upochera ateelhiyaka munrimani. Nansho khachinkhalha ni mithithaari nhina mwaya, anorumelhelha wo ikatema ikani, ni ulhikachiya wawaakaru anowulhuwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeyu chaamonre vamiiwani chinokhalha phi attu onkhaye aneewa, nansho nipampa ni nikakata ninowaakelha ni waatiyelhelha wiira ahiyare. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Imbeyu chaamorenlhe vachaayirani chinooniha attu aneewa nttenga ni upochera wo nrima worera, ni ayo khuvilhelhaka mpaka vanoyara aya maphepu oombone. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Attu khanoparihelha ikhandiri ni ukhuneelha ittutu ama weesha nkhwikwichiri. Nansho anothomia vachulhu ikiango, wiira attu yoone nthuko aya uyo amwalheelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ittu iriyoothe ivithiye inowa yaawiihiya voonene, ni ittu iriyoothe ikhuneelhiye inowa yaapatakulhiya ni uwiihiya voonene. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nhiittialhe, mmweheke rata chittu chineewa inyu chiyo, ukhalhawaya attu ari ni ittu anowunchereriya, nansho attu ahirina ittu, ata ikani anaanyihera aya wiira ahanaa iyo inookushiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Vavawo anumwanawe Yesu vamoka ni ashihima awe nkayaawa, nansho ahoochelha umwaatameria wo nlhatu no uchara attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ntu mmoka nkaamwirelha Yesu, “Anumwaninyu ni ashihima inyu arii vathe vawo anothanana uwoonani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu nkeera, “Anumwanaka ni ashilhoko aka ari phi attu onkhaye aneewelhelha malhove a Nlhuku ni uvarechesha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nihuku nimoka Yesu ahowelha nkalhavani owiittucha awe nkayanttwara, nkeerelha, “Nngwee nilhapuwe nttiya nirwee ukhopelhelhe.” Paahi etu nkwaha nkawaachokholha. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mphironi, Yesu ahowolhiya ikhove nkaarupa. Vahipinche, iphioo yo machiri nkayaawuka munttiyani, ikalhava nkayaachokholha uchara maashi, ni attu onkhaye yaari ntatakoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Owiittucha nkayanrwelha ummushani, yeeraka, “Owiittuchiha, Owiittuchiha! Niri ntatakoni!” Yesu nkonkwa ni umaalhiha iphioo ni iyo nkayaamaalha, nttiya nkanaakhalha shiriri. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nkaakoha owiittucha, “Uri vayi nrima inyu?” Nansho yaari anoomiye uwanoni yoovachaka, yeerelhanaka ashineneru, “Phi ntu ani yolha? Nochachera iphioo ni mawimbi wiira chimaalhe, ni chiyo chinomwiiwelhelha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ni owiittucha awe nkayaaphiya iwani yo Ugerasi, inowehana ni nttiya no Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Vaakhuruwa awe umbwaani, nkankumaana ntu mmoka o mashoka o unanara. Wo iyaakha chinchi, yoyo ntu uyo aari eetaka wo uhiwara ikuwo hikhalhaka uwani, alhokelhaka umahiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Vaamwonne awe Yesu, nkaakhuwelha, eewulhushaka vamietoni vawe, ni ukhuwelhacha, “Yesu, Mwaana a Nlhuku Mulhupalhe Chinene! Unothanani uwannyaka? Kinoulhepelha wiira, uhikoomolhe!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","olhumacha chiicho ukhalhawaya Yesu ahoolhumacha nlhove no ulhehera uthama nshoka nno. Ni nenno nshoka nno naari nimmaraka ikatema chinchi, ata vaattukiya awe mittondoro wiira heetakache aari akwatulhachaka, attawihiyaka ni nshoka no unanara nno wiithuphini. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu nkankoha, “Nchina ninyu apani?” Nkaakhulha, “Nchina naka ‘Nlhoko,’ ” ukhalhawaya mashoka enchi aari anankenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mashoka nkayanlhepelha Yesu wiira, hilhehere wiira oomolhelhiye unaminepa unohalha aya utwarushiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vavawo vakittu vawo vaari vahuwiyaka ikulhuwe, chilhiachaka umwakoni. Paahi mashoka nkayanlhepelha Yesu wiira aahiye akelhe nkulhuweni, ni uyo nkaahiyerera. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mashoka nkayankhuma ntu ulhe ni ukhelha nkulhuweni. Mphingo wonkhaye wo ikulhuwe nkawaattawelha vathi uhito ni ukelha chititimiraka mmaashini. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Attu yaahuwacha ikulhuwe ayo nkayaattawacha, vonne aya ittu ikhumelhenlhe, ni urwaa uwanelhihani mwaha uyo mmawani ni mmamatani mwonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Attu nkayaawa yoone chikhumelhenlhe. Vaaphilhe aya wa Yesu, nkayamphwanya ntu aakumihiye mashoka nakhanlhe vamietoni va Yesu, nawanre ikuwo ni irusho chinankhanlhe rata mmuruni, attu onkhaye nkayoovacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Alhe yonne, nkayaahimiachera akhunanaya chinre awe wo ulhamihiya mashoka wa ntu ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Attu o iwani yo Ugerasi ayo nkayoovacha chinene. Nkayanlhepelha Yesu wiira athame. Paahi etu nkaawelha ikalhava nkaathama. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ntu aalhamihiye mashoka ulhe ahonlhepelha Yesu wiira, “Ni mii nkittukane.” Nansho Yesu nkankhotelha, amwiirelhaka, ");
INSERT INTO mgh2016_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nhokolhieke uwani mwahimieke chipangelhiye inyu ni Nlhuku.” Ntu uyo nkaavira mmawani ahimiachaka chinre awe wo upangelhiya ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu vaahokolhelhe awe ukhopelhelhe nttiya, attu yahompochera, ukhalhawaya yaari ammwehereraka. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Paahi ntu eehaniya Yairo nkaawa, aari nholhelhi neemelhelha inupa yo unlhapelha Nlhuku. Nkeewulhusha makukhu ammekelhaka Yesu wiira arwee uwannyawe, ");
INSERT INTO mgh2016_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ukhalhawaya mwaamwanaya o vekhawe, mwamwalhi o malhipa o iyaakha khumi ni pilhi aari nnookhwani. Yesu vaari awe arwaaka, attu yaari anthothokelhaka uno ni uno. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mmoka aya aari opani amoka aawereiya ireta yo ukhuma iphome, nchorochoro wo iyaakha khumi ni pilhi, amalhihaka nhakhu aya uvira mmireteni, nansho ahilhamaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nkayanttwara Yesu utulhi, nkayaavara ikuwo awe, iphome nkayaamaalha vavawo vavawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu nkaakoha, “Apani akivanre?” Kila ntu nkaakhota, ni Napeturo nkayeera, “Owiittuchiha, attu ahourukureriani uno ni uno!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nansho Yesu nkeera, “Hawo ntu kivanre, kihochuwelha ukhalhawaya machiri ahokikhuma.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Opani alhe vonne aya wiira khanooria wiivitha, nkayeewiha uno athukhumelhaka ni wiiwulhusha vamietoni va Yesu. Nkayeehimiacha vaattuni vawo, ahimiachaka nlhatu waani wo uvara mwiinjiro ni chinre aya wo ulhama ikwerere aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu nkeera, “Mwaamwanaka, nrima ao uhoolhamiha. Urweeke wo mpuha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu voolhumacha awe chiicho, karumiya aya o weemelhelha inupa yo unlhapelha Nlhuku nkaawa, nkeerelha, “Mwamwalhi inyu hokhwa, nhaahuvihe tho Owiittuchiha ayo.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nansho Yesu nkeewa, nkeerelha Nayairo, “Nhoove, mpisheke nrima, noolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Vaaphilhe aya vanupani, nkaachiichiha ntu unkelhana mpaani ahikhalhe Napeturo ni Nayohana ni Nayakhobo ni manyanaangoro o mwalhi uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kila ntu vavawo aari onlhaka umunlhelha mwalhi uyo. Yesu nkeera, “Umaalhiye uhuunlhiye. Mwalhi ulha kanakhwa, howiraka urupa!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Attu onkhaye nkayanthiacha, ukhalhawaya yaari achuwelhaka wiira hokhwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nansho Yesu nkammara moono nkeera, “Mwalhi, wunkweke!” ");
INSERT INTO mgh2016_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nrima awe nkawanhokolhelha, nkonkwa, Yesu nkaalhehera wiira avahiye yolhia. ");
INSERT INTO mgh2016_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Manyanaangoro awe yaari anashannge, nansho Yesu nkaalhehera wiira ahinhimerie ntu riyoothe mwaha ukhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu nkeehana owiittucha khumi ni elhi alhe, nkaavaha machiri ni ikuru yo woomolha mashoka o unanara ni waalhamiha areta. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Paahi nkaaruma yayo khumi ni elhi ayo avire ahimiachaka Imwene ya Nlhuku, ni waalhamiha areta onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nkeerelhacha, “Nhikushe ittu iriyoothe munkwahani, nhiwie ikopo mena nrupa mena mashurupu mena nchurukhu, ni mena mmoka inyu hikushe mwiinjiro wo nayelhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Inupa iriyoothe inohalha inyu upocheriya iyo, mwakhalheke vavawo mpaka vanohalha inyu uthama vawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Vahinopocheriya uhimiechesha winyu, mwathameke yeyo iwani iyo ni ukukutta ntukurukhu nnyaani wo waamuka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Owiittucha nkayaathamacha nkayaarwa mmawani, ahimiachaka Malhove Orera o Imwene ya Nlhuku ni waalhamiha attu awereiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naherode Amwene o Ugalilaya veewilhe aya chittu chaapangiaa, nkayoova, ukhalhawaya attu akina yeera wiira Nayohana Obatiiza ahohihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Attu akina eera wiira Naeliya ahoonia, akina yiiraka anamilhohi o khalhayi ahohihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Naherode nkayeera, “Nayohana kihaahitha, nansho ulha ntu kinomwiiwaaka ulha phi mpani?” Nkayaathanana umwoona Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Akarumiya yahokolhieke, nkayanhimeria Yesu kila ittu yaapannge aya. Nkaakushacha nkayaarwa iwani yo Ubethsaida. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Attu vanchuwenlhe aya, nkayanttwara. Nkaapochera, nkoolhumacha mwaha wo Malhove Orera o Imwene ya Nlhuku, ni waalhamiha mareta yaarina aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nchuwa veelha aya, akarumiya khumi ni elhi nkayanrweelha ni unhimeria wiira, “Mwaahiyeke attu ayo ahokolhiacheke uwannyaya ni uvira yaaviaka yolhia mmawani ni mmamatani, yaavie yolhia ni mapuro o urupa, ukhalhawaya vari ihu va vauthakoni.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nansho Yesu nkeera, “Mwaavaheke yolhia mwaattiva.” Nkayaakhulha, “Ittu nirina ihu iri mikatte nthanu ni ihopa pilhi. Chani nirweeke nathumeke yolhia yo waavaha attu onkhaye alha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Attu yaari vavawo aari alhopwana maelufu nthanu. Yesu nkeerelha owiittucha awe, “Mwaakhalhiheke attu vathi milhoko cha attu makhumi nthanu kila nimoka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Owiittucha yamalheke waakhalhiha attu mmapuroni, ");
INSERT INTO mgh2016_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu nkaakusha mikatte nthanu ni ihopa pilhi, nkaaweha wiirimu, nkalhapelhelha ibarakha, nkaamianihacha, nkaavaha owiittucha yaakawelhe attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Attu onkhaye nkayaalhia, nkayaawonacha, ni owiittucha nkayaarokottacha mahalhahalha aahanlhe, nkayaachariha ni ukusha makaya khumi ni melhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nihuku nimoka Yesu aari alhapelhaka vekha awe, owiittucha nkayaawacha, nkaakohacha, “Ana attu aneera mii phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nkayaakhulhacha yiiraka, “Akina aneera, Nayohana Obatiiza, akina aneera Naeliya, ni akina aneera inyuva mmoka a anamilhohi o khalhayi hihimmwe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nkaakoha, “Ni inyu mwaatti chani, nneera mii phi mpani?” Napeturo nkayaakhulha, “Inyuva phi Kuristo Moopolhi thanlhiye ni Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Paahi Yesu nkaachiichiha wiira ahinhimiachere ntu riyoothe yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nkaahimeria tho, “Mwaana a Ntu nowa utwarushiya ni ukhotiya ni ashulhupalhe ni opochera ishaani olhupalhe ni owiittuchiha Malhehero. Noowa eeviya nansho nihuku no neraru nowa uhihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nkeerelha attu onkhaye, “Ntu riyoothe nothanana ukittwara eeruneke mwanene, akusheke nsalaaba awe kila nihuku akittwareke, ");
INSERT INTO mgh2016_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ukhalhawaya ntu riyoothe nothanana woopolha ukumi awe, noopoteriha, nansho ntu riyoothe noriha ukumi awe wo nlhatu waka nowa woopolha. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ntu nohalha upattani wo upatta mpuha wonkhaye wo velhaponi va, nansho apoterihaka ukumi awe mwanene? Mena khiiwo! ");
INSERT INTO mgh2016_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ntu oonaka ishoni wo nlhatu naka ni meettuchiho aka, Mwaana a Ntu ni uyo nowa umwoonelha ishoni vanohalha awe uwa wo nthimicho wa Athithi ni minepa chitakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kinoohimeriani ikekhia wiira, ahawo akina vaa ahinowa aakhwa ahinaya woona Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yavireke ijuma imoka toka voolhumanche awe yayo malhove ayo, Yesu nkaakusha Napeturo ni Nayohana ni Nayakhobo nkayaarwaa umwaakoni ulhapelhani. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Vaari aya alhapelhachaka, ikhove awe nkayaarukunuwa, ni ikuwo chawe nkachaateelha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nkoonia attu elhi amwaarerihanaka Yesu, ni ayo yaari ashinna Musa ni Naeliya, ");
INSERT INTO mgh2016_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","aakhumelhenlhe wo nthimicho, nkaamwaarerihana mwaha wo umalhiha ntheko wa Nlhuku nnookhwani ukhumelhelha Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Napeturo ni akhunanaya yaari anarumpe, yeyo ikatema nkayonkwa ni woona nthimicho wa Yesu ni attu elhi emenlhe vamoka ni uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Attu elhi ayo vaathama aya wa Yesu, Napeturo nkeera, “Owiittuchiha, ihorera hii ukhalha vaa! Ninootheka etu mahema mararu, nimoka nawinyu nikina na ashinna Musa ni nikina ni Naeliya.” We ikekhiaye khayaari achuwelhaka inoolhumacha aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Napeturo voolhumacha aya, nihute nkanaakhuruwa ni waakhuneelha, vaawa aya owiittucha alhe yaari yoovaka chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nlhove nkaneewiya ukhuma wiirimu neeraka, “Ulha phi Mwaamwanaka, kinonttuna aka, mmwiiwelhelheke yoyo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nlhove vaamaanlhe aya, Yesu aari vekha awe. Owiittucha nkayaamaalha wo unhihimeria ntu riyoothe yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Waashelhe waya Yesu ni owiittucha araru ahokhuruwa umwaakoni, ni nlhoko mwinchi wa attu nkawankumaana Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Vavawo, ntu mmoka nkaakhuwelha, “Owiittuchiha! Kinoulhepelhani chonte mummwehe mwanaka, mwanaka o yekha awe! ");
INSERT INTO mgh2016_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nshoka ninonkelhakelha, khummulhushaka venchi, khukumaka niphoru mmwano, khunhuvihachaka chinene wo uhinhiya! ");
INSERT INTO mgh2016_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kahaalhepelha owiittucha inyu wiira oomolhe nshoka nno, nansho khayonrie.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu nkaakhulha, “Mwaatti iyari ihiri ni nrima, iwonnye va! Kinohalha ulhokelha ni uvilhelhani mpaka iyaakhani?” Nkeerelha athumwanawe mwaana ayo, “Mummwiiheke mwaamwaninyu uyo vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mwaana vaawihiya awe, nshoka no unanara nkanammulhusha vathi ni unhelha ichilhichilhi. Yesu nkaachachera nshoka nno, mwaana nkaalhama, nkanhokolhosha wa athumwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Attu onkhaye nkayoomiya uwanoni woona ikuru chulhupalhe cha Nlhuku. Attu yaari ashangaka chittu chonkhaye chaapangiye ni Yesu, venre awe wo owiittucha awe, ");
INSERT INTO mgh2016_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mwiiwelhelheke alha kinohalha aka uhimeriani! Mwaana a Ntu nokelha uhelhiya mmathathani mwa attu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nansho owiittucha khayaachuwenlhe yaahimia awe, ukhalhawaya yaari inavithiye uwannyaya. Nkayoova unkoha maana aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nkawaachokholha ukohaniya owiittucha ashineneru wiira phi mpani ri mulhupalhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu nkaachuwelha choopuwelha aya munrimani, paahi etu nkankusha mwanhima, nkaamweemesha vaari aya, ");
INSERT INTO mgh2016_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nkeera, “Ntu riyoothe nompochera mwanhima thoko ulha wo nchina naka nokipochera mii, ni ntu nokipochera mii, naapochera akirumilhe. Ukhalhawaya ri mwankani waapwaha onkhaye munlhokoni mwinyu, yoyo phi mulhupalhe inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nayohana nkayoolhumacha, “Owiittuchiha, nahomwoona ntu oomolhaka mashoka wo nchina ninyu, nkananchiichiha, ukhalhawaya khari nyu ninonttukana ihu vamoka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu nkeerelha, “Nhichiichihe, ukhalhawaya ntu riyoothe hinoovengani yoyo ri vamoka ni inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ikatema vaatamenrie aya ukushiya Yesu wiirimu, nkoona mbaya arwee Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nkaaruma akarumiya anholhelhe, arwee Usamariya akooroshe vakittu vanohalha awe uphiyelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nansho anenchi o Usamariya ahokhota umpochera ukhalhawaya aari alhukamaka Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Paahi etu owiittucha Nayakhobo ni Nayohana vonne aya chiicho, nkayeera, “Thithi, chani niihaniheke mooro wo wiirimu naamalhihe yalha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu nkaarukunuwa ni waachachera. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Paahi Yesu nkaathama mwanene vamoka ni owiittucha awe nkayaarwaa iwani ikina. ");
INSERT INTO mgh2016_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Vaari aya munkwahani, ntu mmoka nkaamwirelha Yesu, “Kinouttwarani uriwoothe unohalha inyu urwaa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu nkaamwaakhulha, “Anancheto ahana milhiwi ni ashinuni o uchulhu urimu ahanaa iphuuru chaya nansho Mwaana a Ntu kharina nipuro no waathalhelha muru awe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nkaamwirelha ntu nkhwawe, “Nkittware.” Nansho ntu ulhe nkeera, “Thithi, nkihiye thoko kirwee kaavithe athumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu nkaakhulha, nkeerelha, “Mwaahiyeke attu akhwilhe yaavitheke attu aya khwilhe. Inyu nrweeke mwahimiacheke Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ntu nkina nkeera, “Thithi kinouttwarani, nansho nkihiye thoko kalhehe uwani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu nkeera, “Ntu riyoothe nolhima uno awehaka utulhi, yoyo khanooria ittu nhina Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yamalheke yayo, Athithi nkayaathanlha akina makhumi saba ni elhi, nkaaruma elhielhi arwee aholhelhe kila iwani ni kila vakittu vaathanana awe urwaa. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nkeerelhacha, “Nlhaalha uri mwinchi, nansho anamitheko o ukhungura ari vakani. Nlhepelheke etu anene nlhaalha yaawihe anamitheko oowa ukhungurani cholhia chaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nrweeke etu! Kinourumani mwaattiva thoko ikhondoro umiichini. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nhikushe nchako wo nchurukhu mena nrupa mena iratu, nhinkohache ntu riyoothe mphironi. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Vanophiya inyu vawani, nchokholheke wo wiira, ‘Mpuha ukhalhe ni inyu,’ ");
INSERT INTO mgh2016_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akhalhaka haawo ntu noopocherani mwommo, nhiyeke mpuha inyu vavawo, aahikhalheke, nhokolhosheke mpuha inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mwakhalheke vavawo, mwalhieke ni uwuria ittu iriyoothe nnohalha inyu uvahiya, ukhalhawaya namitheko hophwanelhiya malhivo. Nhikelhe mwaakukuriacha uno ni uno. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mwaphiyaka vawani mpocheriyaka, nlhieke yolhia nterekhelhiye inyu iyo, ");
INSERT INTO mgh2016_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mwaalhamiheke areta ni waahimeria attu o wowo wiira, ‘Imwene ya Nlhuku ihaatameria.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nansho mwaphiyaka vawani vahinopocheriya inyu, nthameke, ni vanovira inyu mmaphironi mwaya mweereke, ");
INSERT INTO mgh2016_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ata ntukurukhu no vawani winyu ninivanre nnyani nno, ninookukutta vano wooniha wiira nihouhiyerani mwaashinene! Nansho nchuwelheke wiira, Imwene ya Nlhuku ihaatameria.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kinouhimeriani ikekhiaye wiira, Nihuku no uhukumulhiya attu nno, inowa ukhalha ittu yo waalhuwa chinene wo iwani yo Usodoma uvilhelha ntwarusho upwaha yeyo iwani iyo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nhothapana inyu iwani yo Ukorazini! Nhothapana iwani yo Ubethsaida! Ukhalhawaya cho ushangiha chipangiye uwaninyu chikaapangiye Utiro ni Usidoni, attu yammwara majuniya ni wuupuruwa vaatuurani wooniha wiira ahokhoroma uhiya uwonya waya! ");
INSERT INTO mgh2016_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nansho nihuku no ihukumu nno, inowa ukhalha ittu yo waalhuwa wo iwani cho Utiro ni Usidoni wooria uvilhelha ntwarusho naya upwahani mwaattiva. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ni inyu Nakapenaumu! Chani nnothanana wiiwelhiha mwaanene wiirimu? Nnoowa mwaawulhusheriya unaminepa!” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu nkeerelha owiittucha awe, “Ntu riyoothe nowiiwelhelhani, hokiiwelhelha mii, ntu riyoothe nookhottani nokikhota mii, ni ntu nokikhota mii naakhota akirumme.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Makhumi saba ni elhi aarumiye alhe nkayaahokolhia, yaari anateelhiye chinene yeeraka, “Thithi, ata mashoka ahoniiwa vaaromonlhe ihu nchina ninyu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu nkaakhulha, “Kahomwoona Nakare awulhuwaka thoko uverunya ukhuma wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mwiiweke etu! Kihohuvahani ikuru, yo unyikalha inwaa ni makharang'andha ni ikuru yo unnyikalha mmalhaponi inyu ulhe, ihikhalhaka ittu cho uhilhoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nansho nhiteelhiye ukhalhawaya nshoka nihowiiwani, nansho nteelhiyeke ukhalhawaya machina inyu aholhepiya wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yeyo ikatema iyo, Yesu ahoteelhiya wo ikuru yo Iphumu ya Nlhuku nkeera, “Thithi, Athithi o wiirimu ni o velhaponi! Kinoushukuruni ukhalhawaya nhaavitha attu o irusho ulha mwaha ulha, nkamwaapatakulhelha akani. Aye, Thithi, phinre aya wo uchivelhani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nkeera tho, “Athithi ahokivaha chittu chonkhaye. Khaawo nchuwenlhe Mwaana ahikhalhe Athithi ni khaawo aachuwenlhe Athithi ihikhalhe Mwaana ni attu athanlhiye ni Mwaana wiira aapatakulhelhe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu nkaarukunuwelha owiittucha awe nkaahimeria wo nivitho, “Nhoreeriya mwaatti ukhalhawaya miitho inyu ahoona chi chittu chinoona inyu chi! ");
INSERT INTO mgh2016_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kinouhimeriani wiira, anamilhohi a Nlhuku ni mamwene enchi yahothanana alha anoona inyu alha, ahoone ni wiiwa, nansho khayoonne, ahottuna wiiwa thoko mwaattiva nansho khayeewilhe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Owiittuchiha Malhehero rata nkayaawa ni unkoha Yesu wo unlhikacha. “Owittuchiha, kipangekeni kipatte ukumi wo uhimalha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu nkaakhulha, “Malhehero alhepiye chani? Nnoshomani?” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yoyo ntu uyo nkaakhulha, “Munttuneke Nlhuku inyu wo nrima inyu wonkhaye ni nnepa inyu wonkhaye ni machiri inyu onkhaye ni irusho chinyu chonkhaye ni waattuna amwaatamana inyu thoko chineettuna inyu mwaanene.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu nkeerelha, “Nhaakhulha rata. Mpangeke etu ni ukhalha thoko chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nansho ochuwelha Malhehero rata ayo nkayaathanana wiichooniha wiira aari ntu o nrima woombone, paahi ahonkoha Yesu, “Amwaatamana aka phi apani?” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu nkaakhulha, “Ntu mmoka aari alhukamaka Uyeriko akhumaka Uyerusalemu. Nkaavariya ni attu o uvara makhuche, nkayanrulha ikuwo, nkayanthurulha nhakhu awe nkayaamwata chinene, nkaahiya nakomweelhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Opochera ishaani amoka nkayaavira vavawo, nansho vaamwonne aya khayanlhohilhe, nkayaavira uchereshere. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chiichammo, Nlawi mmoka nkaaphiya vavawo, nkaamwona nkaavira uchereshere. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nansho Nsamariya mmoka eeta munkwahani ahophiya vavawo, vaamwonne awe ahomwonelha ikiriri. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nkaamwaatameria, nkanhapiha makhwata, nkanhika makhura ni idivai ni unttukelha. Amalheke nkammwelhiha vachulhu iphuta awe, nkanrweha inupa ya alheto ammwerehe. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Washeeke, nkaakumiha nchurukhu wo malhivo o mahuku melhi ummaha mwanene inupa ni umwiirelha, ‘Mummwereheke ntu ulha, ni ittu inohalha wunchereria kinoowa kaalhiva vanohalha aka uhokolhia.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Paahi Yesu nkaakoha, “Wo irusho chinyu inyuva, wo yayo attu araru ayo, phi mpani aari namwaatamana e ikekhiaye a ntu aatakachiye ni attu o uvara makhuche ulhe?” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ochuwelha Malhehero rata alhe nkayaakhulha, “Aari ntu amwonenlhe ikiriri ulhe.” Yesu nkeera, “Ni inyu etu nrweeke, mwapangeke thoko chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ni owiittucha awe vaari aya munkwahani, yahophiya iwani yaapocherie awe uwani wa opani amoka eehaniya Namatha. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yayo yaari ni arokoraya eehaniya Amariamu, aakhanlhe vathi vamietoni va Athithi ni wiiwelhelha meettuchiho aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Namatha nkayaathunalha woona wiira aapanga vekha aya ntheko wo waaterekhelha alheto, nkayaarwaa ni wiira, “Thithi, woonaka khannoona wiira arokoraka ayo ahokihiyera ntheko vekha aka? Mweerelheke aweeke aakikaviha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Athithi nkayaakhulha, “Namatha, Namatha! Nnothemwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ittu imoka tu phi renre. Amariamu ahothanlha ittu yoombone ihinooria uthurulhiya ni ntu riyoothe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nihuku nimoka Yesu aari alhapelhaka vo vekha awe. Amalhiheke, owiittucha awe mmoka nkaamwirelha, “Thithi, nniittuchiheke ni hii ulhepelha, thoko chinre aya Nayohana wo weettuchiha owiittucha aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu nkeerelha, “Vanolhapelha inyu mwiireke, ‘Athithi nri wiirimu, Nchina ninyu nithimichiye, imwene inyu iwe. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nnivaheke yolhia ihu kila nihuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nnihiyerereke uwonya wihu, thoko nineera ihu wo waahiyerera anittekenlhe. Nnoopolhe muulhikachiyani.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu nkeerelhacha tho owiittucha awe, “Ikhalhe wiira mmoka inyu norwaa wa ampwana awe uhiyu variyari ni uhimia wiira, ‘Mpwana, nkaashimihe mikatte miraru, ");
INSERT INTO mgh2016_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","alheto ahokiphwanya ampwana aka ari munkwahani, ni mii akirina ittu yo waavaha!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ni ayo anari mpaani nkayaakhulha, ‘Nthame uwo nhikihuvihe mii! Kihottia nlhako, mii ni achishaana aka nihokelha mpaani urupani. Paahi akinonkwa kiwe kouvahani ittu iriyoothe.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Inohalha wiiria chani etu? Kinouhimeriani ikekhia wiira khanoonkwa uwaavahani nkatte wo nlhatu no umpwana waarina aya, mena, nansho wo nlhatu no waanyakulha ni uthepa uvekelha, phi chiichammo chinohalha aya wunkwa ni waavaha ittu inovekelha aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Paahi etu, Nvekelheke nnoovahiya, mwaavieke nnoopatta, nhodisheke vankhorani nnoohulhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ukhalhawaya ntu riyoothe novekelha noovahiya, ni ntu naavia noopatta, ni ntu nohodisha vankhorani noohulhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Chani mwaana vanovekelha awe ihopa wa anaangoro awe, novahiya inwaa kuhiwe ihopa? ");
INSERT INTO mgh2016_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ama novahiya nikharang'andha vanovekelha awe nnyoche? ");
INSERT INTO mgh2016_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Inakhalhaka nri attu o unanara mirima nansho nhochuwelha chittu choombone cho waavaha achishaana inyu. Chani etu, athumwaninyu o wiirimu khanouvahani chittu choombone wo upwaha, anowaavaha Iphumu ya Nlhuku attu anaavekelha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nihuku nimoka Yesu aari omolhaka nshoka no unanara nantunke ntu huulhumache. Paahi etu vankhumme aya, ntu ulhe ahooria wulhumacha tho, mpaka nlhoko wa attu nkawoomiya uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nansho attu akina nkayeera, “Noomolha mashoka wo ikuru yo Belzebuli, nholhelhi o mashoka o unanara, phi nommaha ikuru yo woomolha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Attu akina yaari athananaka unria Yesu, paahi nkayamwiirelha wiira apange cho ushangiha cho wiirimu oonihe wiira Nlhuku ri vamoka ni uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nansho Yesu ahochuwelha choopuwelha aya, nkeera, “Imwene iriyoothe imianelhe yaatakanaka ineeneru yeyo khinolhokelha chinene, chiicho iwani imianelhe yaatakanaka ineneru inowulhuwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Paahi yakhalhaka etu imwene yo Nakare iheemianiha yaatakanaka ineeneru, inohalha ulhokelha chani? Mwaatti nneera wiira eti kinoomolha mashoka wo uvahiya ikuru ni Belzebuli. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yakhalhaka kinoomolha mashoka wo ikuru yo Belzebuli, owiittucha inyu etu anoomolha wo ikuru ya apani? Wo yoyo nlhatu uyo etu ashaana inyu mwaashinene phi nowa uhukumulhani mwaatti. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nansho yakhalhaka kinoomolha mashoka wo ikuru ya Nlhuku, nchuwelheke wiira Imwene ya Nlhuku ihomalha uphiya uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ntu o machiri vanolhitelhelha awe inupa awe ni ikerero, inupa ni nhakhu awe chinoolhama. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nansho awaaka ntu o machiri chinene o mpwaha ni umwaata ni ummulhusha, yoyo nookusha ikerero chaakhulhuvelha awe chiyo ni umwaakha nhakhu. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ntu riyoothe hiri vamoka ni mii, yoyo nookivinga, hinokhungura vamoka ni mii yoyo phi noomwarusha. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nshoka no unanara vanoomolhiya aya mwiiruttuni mwa ntu, nivovira neetakachaka uhiri maashi naaviaka nipuro no wiittuwa. Naahooneke, vavawo phi neera aya, ‘Kinoohokolhia unupani waka.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Paahi noohokolhia ni uphwanya inupa mwaari inakwechiye ni urerihiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Paahi tho, phi norwaa aya ni waakusha mashoka makina saba o uhilhoka umphwaha uyo, ni uwa uukhalhani vamoka ni uyo. Vanomalha aya, ntu uyo nokhalha muuhuvani chinene upwaha khalhayi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu voolhumacha awe, opani amoka nkayeera, “Ahopuha athiyana uyanreni ni uwaamwiihani!” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nansho Yesu nkaakhulha, “Nansho areeriye chinene, phi ayo aneewa nlhove na Nlhuku ni uvarechesha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nlhoko wa attu voonchereria aya, Yesu nkeera tho, “Ilha iyari ilha iri yo uhilhoka ilha! Inovekelha woona cho ushangiha, nansho khinoonihiya yo ushangiha iriyoothe ihikhalhe i Nayona. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chiichammo etu Nayona chenre aya wo waashangiha attu o Uninavi, phi chiichammo Mwaana a Ntu chinohalha awe waashangiha attu o ilha iyari ilha. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nihuku no uhukumulhiya attu nno, Ahano o Usheeba anowa weemelha ni waahukumulha attu e ilha iyari ilha, ukhalhawaya ahovira toka utayi awe eewelhelha irusho chi Naselemani, ni mii kinohimia wiira vaa haawo Yesu, ntu mulhupalhe naapwaha Naselemani. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nihuku no uhukumulhiya attu, attu o Uninavi anowa weemelha waahukumulha attu o ilha iyari ilha wiira ahowonya. Ukhalhawaya attu o Uninavi ahokhoroma veewilhe aya meettuchiho a Nayona, nansho vaa hawo mulhupalhe naapwaha Nayona! ");
INSERT INTO mgh2016_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Khaawo ntu noparihelha ikhandiri awe ni ukhuneelha ittutu, nansho nothomia vachulhu ikiango wiira yaamwalhelhe attu anokelha mpaani. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Miitho inyu phi nthuko wo iruttu. Miitho inyu akhalhaka makumi, iruttu yonkhaye inokhalha voonene, nansho miitho awereiyaka iruttu yonkhaye inokhalha yo unanara, inokhalha mwiipiphini. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mwiiraniheke etu, nthuko uri nhina mwinyu uhikhalhe ipiphi. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Paahi etu, iruttu inyu yonkhaye yakhalhaka voonene, wo uhikhalha mwiipiphini, iruttu inokhalha voonene thoko vanomwalhelhiya aya ni nthuko.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu amalhihekeru wulhumacha, Afarisayo amoka ahomwiirelha arwee alhie yolhia uwannyawe. Nkaarwa ulhiani yolhia, nkaakhalha ulhia. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Afarisayo ayo nkayaashanga woona wiira Yesu aari alhiaka wo uhinyawa mathatha rata. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Paahi Athithi nkayeera, “Mwaatti Amafarisayo va, nnohapiha ikahi ni iphache wo vatheru, nansho nhina ncharaka chittu cho nanrokotolhe chihinlhoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nhophupuwalha inyu ayi! Nlhuku phi kooronshe vathe ni nhina chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nansho mwaavaheke attu ahirina chittu chiri nhina, ni chikina chonkhaye chiyo chinookhalha chorera uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nhothapana inyu Mwaamafarisayo va! Ukhalhawaya nnaahukumulha ni waalhiviha attu isadaka yo nifungu no khumi ata yo mathaakhuru o uhelhiya mmathapani, nchicha ni mathaakhuru makina, nansho nhilhohaka mwaha wo uvarechesha ikekhiaye ni uttuna wa Nlhuku. Yayo yaaphwanelhiye wooniya wiira nhovarechesha rata nhilhiyalhaka makina ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nhothapana inyu Mwaamafarisayo va! Mwaatti nnottuna ukhalha miholho mapuro o nthimicho wi inupa yo unlhapelha Nlhuku ni ukohachiya wo nthimicho vanopangiya maronda. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nhothapana inyu! Mwaatti nri thoko mahiye o uhichuwania, attu aneeta aya vachulhu waya ahichuwelhaka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Owiittuchiha Malhehero a ashinna Musa amoka nkayaamwiirelha, “Owiittuchiha, venre inyu chiicho, nhoniruwana!” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu nkaakhulha, “Nhothapana ni inyu Owiittuchiha Malhehero a ashinna Musa va! Nnaaria attu misigo cho ulhemelha, nansho mwaanene nhookolhaka nikokho nhaakavihaka ukusha chechiyo misigo chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nhothapana inyu! Ukhalhawaya nnoovaka mahiye a anamilhohi a Nlhuku eevakachiye ni manyaapwiinyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Paahi etu nnohimiechesha ni uvarechesha mitheko cho manyaapwiiya inyu, ukhalhawaya yayo phi evilhe anamilhohi ni inyu vano nnoovaka mahiye aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wo nenno nlhove nno etu, irusho cha Nlhuku chineera, ‘Kinowaarweehelha anamilhohi ni akarumiya, anokoweeva akina ni waatwarushacha akina.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Paahi etu attu o ilha iyari ilha anowa utwarushachiya wo weeva anamilhohi a Nlhuku onkhaye toka voopiye aya ilhapo, ");
INSERT INTO mgh2016_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","toka wiiviya wa Nahabilu mpaka wiiviya u Nazakariya, yeeviye variyari madhubahu ni Inupa Itakatifu. Eiyo, kinouhimeriani wiira, attu a ilha iyari ilha anowa utwarushiya wo mitheko chaya! ");
INSERT INTO mgh2016_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nhothapana inyu owiittuchiha Malhehero! Ukhalhawaya nhokusha mittukulho cho nlhako wo inupa yo irusho, mwaanene nhikelhaka, mwaachiichihaka attu anlhikacha ukelha wowo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Vaathama awe, Amafarisayo alhe ni owiittuchiha Malhehero nkayaachokholha unchopeyacha chinene wo unkohakoha chookohiya chinchi, ");
INSERT INTO mgh2016_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","alhikachaka unria wiira ammare wo malhove awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Attu maelufu menchi vaathukhumana aya vamoka, anyikalhanachaka ashineneru, Yesu nkeerelhacha owiittucha awe thoko, “Mwiichinanelheke ni ihengedure ya Amafarisayo, yaani unafiki waya. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila ittu ivithiye inowa uhumbukulhiya ni kila ittu ivithiye inowa yaapatakulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Paahi etu, kila ittu yuulhumachilhe inyu mwiipiphini, inowa yeewania voonene, ni ittu yaapilhe inyu nlhako unatteiye, inowa yaahimiachiya vanchaarani. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kinouhimeriani, manyampwana aka, nhoove attu aneeva iruttu nansho ahooriaka ittu ikina iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kinowoonihani vano etu, mpani o umwoova. Mmwooveke Nlhuku, nooria wiiva, amalhaka wiiva, hanaa ikuru yo unrihelha ntu umooroni Ujehannamu. Nkirumelhelheke mii, yoyo phi vekha awe o wooviya! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Chani, athooche athanu khanthumihiya wo isenti pilhi? Nansho Nlhuku khanonlhiyalha ata mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wo ikekhiaye, ata ikharari chinyu cho mmuruni chihaalhakelhiya chonkhaye. Nhoove etu, mwaatti nri o ukhulhuvelhiya chinene waapwaha athooche enchi va! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kinouhimeriani ikekhiaye wiira, kila ntu norumelhelha vaattuni wiira phi awaka, Mwaana a Ntu ni uyo noowa aarumelhelha wo minepa cha Nlhuku wiira phi awawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nansho attu onkhaye anokikhotta vaattuni, Mwaana a Ntu nowa ni uyo nowa unkhota wo minepa cha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ntu riyoothe noolhumacha nlhove no unvinga Mwaana a Ntu nowa uhiyereriya, nansho attu anohalha wulhumacha malhove o nlhava Iphumu ya Nlhuku, khanowa aahiyereriya. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Vanohalha aya uweemeshani mu inupa yo unlhapelha Nlhuku ama wa aholhelhi ama wo attu o ikuru yo utawara, nhikelhiye nipampa wiira nnohalha wulhumachani wiira mwaakhulhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iphumu ya Nlhuku nowa owiittuchihani yeyo ikatema iyo nlhove naani no wulhumacha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ntu mmoka o nhakhu mwaattuni mmo nkaamwirelha Yesu, “Owiittuchiha, mmwiirelheke nhima aka wiira nikawane nhakhu nihiyeriye ihu na athumwanihu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu nkaamwaakhulha, “Mpwana, mpani kivanhe mii ntheko wo uhukumulhani ama ukawaniha nhakhu inyu mwaatti elhi va?” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nkaathepa waahimeria attu onkhaye eeraka, “Mwiichinanelheke ni iphiro chonkhaye cho nlhulha, ukhalhawaya ukumi wa ntu khumpangiaa ni chittu chirinawe ama wo nhakhu urinawe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Paahi Yesu nkaahimeria nlhikaaniho nna, “Ahaawo ntu mmoka o nhakhu wo imata yaaruweria awe chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nkaakhalha oopuwelhaka mwaneneru, ‘Akirina nikhupi no uthokoreria cholhia chaka. Kiireke chani etu?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nkeecheerelha, ‘Kinoophomolha ichikuti chaka ni utheka nikhupi nulhupalhe chinene, ninohalha aka uthokoreria cholhia ni chittu chaka chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Vavawo phi nohalha aka wiira, Nhoreeriya! Nhanaa vano akhiba yo chittu chonkhaye chaathemwelha inyu iyaakha chinchi chinene. Mwiittuweke etu vano, nlhieke, mmwurieke ni ulhia mpuha ene!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nansho Nlhuku nkaamwirelha, ‘Nhophupuwalha inyu! Ulha uhiyu wo lhelho ulha, ukumi inyu phi noweiya aya, ni nhakhu wonkhaye nshungilhe inyu unohalha ukhalha wa apani?’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu nkaamalhiha eeraka, “Phiri aya chiicho wa ntu neecheshera nhakhu awe mwanene, uhikhalhaka nhakhu unomphwanelha Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu nkeerelha owiittucha awe, “Mwaatti kinouhimeriani wiira, nhikelhiye nipampa no mwaha wo yolhia wiira nlhame ama ikuwo cho uwara mwiiruttuni mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ukumi phi renre upwaha yolhia ni iruttu upwaha ikuwo. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mwooneke anakhuku, khanaalha imbeyu ama ukhungura vanlhaalhani, kharina ichikuti mena nikhupi, Nlhuku phi naalhiha! Ni inyu mwaatti nri o ukhulhuvelhiya waapwaha ashinuni! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mpani munlhokoni mwinyu wo ukhalha ni nipampa, nowooria wuncherera ukumi awe vakani? ");
INSERT INTO mgh2016_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Paahi etu, yakhalhaka wiira khannooria ata vakani upanga ittu thoko yeyo, nipampa ne ishiyani etu? ");
INSERT INTO mgh2016_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mwooneke ituva chineera aya wookonda, khachirina ntheko mena khachinotiva. Nansho kinouhimeriani wiira ata Amwene Naselemani anene ayo, ni mpuha waya wonkhaye khayaawanre ikuwo yo nthimicho thoko imoka aya ituva chi. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yakhalhaka etu Nlhuku phi nokondiha chiicho mathaakhuru o mmatani ari lhelho ahaawo, meelho ahorihiya vamooroni, chani khanoria uwarihani mwaatti wo upwaha? Mwaatti chani woonaka mirima chinyu chiri chikani! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Paahi etu nhikelhiye nipampa, nhuvihiyaka ni chittu cho ulhia ni uwuria. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ukhalhawaya chechiyo chittu chonkhaye chiyo chinohuvelhiya velhaponi va ni attu ahinchuwenlhe Nlhuku. Athumwaninyu o wiirimu ahochuwelha chittu chonkhaye nnothanana inyu chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nansho mwaatti nchenjeukelheke thoko Imwene ya Nlhuku, ni inyu nnoowa mwaavahiya ni wuncherereriya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nhoove, inyu mwaatti nri nlhoko mwankani wa owiittucha aka, Athumwaninyu o wiirimu ahochivelhiya uuvahani mwaatti Imwene. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nthumiheke nhakhu inyu ni waavaha nchurukhu uyo amashikini. Nkoorosheke mirupa chihinthaalha, ni wiishungera nhakhu wiirimu uhinowukuwa aya. Wowo, attu o wiiya khaneeiya mena nrenje khunolhia. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vanohalha ukhalha nhakhu inyu, nrima inyu unohalha ukhalha vavawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nhiittialhe, nkhaalheke rata, ni ikhandiri chinyu chikhalheke tayari, ");
INSERT INTO mgh2016_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","thoko anamitheko anaaweherera anene ntheko ahokolhie ukhuma u arusini, awe aahulhelha vanohalha aya wiihana vankhorani. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ahoreeriya yayo anamitheko ayo, anohalha uphwanyiya ni anene ntheko ashelhelhihaka! Kinouhimeriani wo ikekhiaye wiira, anowa urulha nikoti naya, ni waakhalhiha wiira aaterekhelhache. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Areeriye chani yayo anamitheko ayo anohalha uphwanyiya ashelhelhihaka inakhalhaka uhiyu veriyari ama mapikoosha! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nchuwelheke wiira, anene inupa akaachuwenlhe ikatema o wiiya vanowa aya, khaarupa, anshelhelhiha alhitelhelhaka inupa aya ihiphomolhiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ni inyu mwaatti chiicho, nhittialhe, ukhalhawaya Mwaana a Ntu nowaa ikatema ihinaanyihera inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Napeturo nkayeera, “Thithi, nna nlhikaaniho nna nawihu vekha ama ni attu akina chiicho?” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Athithi nkayaakhulha, “Paahi etu, phi karumiya ani nokhulhuvelhiya o irusho? Phi yoyo novahiya ipilhi, weemelhelha ni waalhiha anamitheko nanawe waayakaru. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Horeeriya yoyo karumiya uyo vanophwanyiya awe ni anene ntheko apangaka chiicho vanohokolhia aya uwani! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ikekhiaye nowa ummaha ntheko mulhupalhe wo weemelhelha nhakhu aya wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nansho, karumiya uyo echiirelhaka munrimani mwaneneru wiira anene ntheko khanohokolhia chitema, nkaachokholha waatakacha anamitheko akhunanawe, ashilhopwana ni ashithiyana alhiaka ni uhapalhiya, ");
INSERT INTO mgh2016_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","anene ntheko phi nohokolhia aya chitema nihuku nihinaanyihera awe ni ikatema ihichuwenlhe awe. Anene ntheko anowa untwarusha ni unkakhelha wa attu ahinonrumelhelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Karumiya nochuwelha mathananelho a anene ntheko, nansho hiicheshaka rata, nowaatiya chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nansho karumiya nopanga wo uhichuwelha nowa utwarushiya vakani. Vahiye chinchi nowa ukohiya chinchi, vahiye chinchi chinene nowa ukohiya chinchi chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kiwilhe uparihelha mooro velhaponi, ukaari unapharenlhee! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kihanaa ubatiizo wo utwarushiya ukiphwanenlhe, kinthemwa chani wiira utimire! ");
INSERT INTO mgh2016_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nnaanyihera kiwanne mpuha velhaponi va? Mena, akiwanne mpuha, kiwanne umwalhaana. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Uchokholha vano nna, iwani ya attu athanu inomwalhaana, attu araru wa attu elhi ni elhi wa araru. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Manyanaangoro ashilhopwana avenganaka ni achishaana aya ashilhopwana, ni ashaana ashilhopwana aavengaka ashithumwanaya, manyanaangoro athiyana aavengaka ashaana aya ashithiyana, ni ashaana ashithiyana aavengaka manyanaangoro, ahokohi aavengaka ashihokohi aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu nkaahimeria tho attu, “Vanoona inyu nihute nikhumaka uneelha nchuwa, mwaatti nneera, ipulha inoorupa lhelho, ni iyo khurupaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Vanoona inyu iphioo iwukaka uchawa, nneera, ntukutta ninoopaha lhelho, khuupahakani. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwa anafiki inyu! Nhochuwelha uweha vathi ni wiirimu ni uhukumulha ittu yaani inohalha ukhumelhelha, nnoochelha chani etu uchuwelha maana o ikatema chi? ");
INSERT INTO mgh2016_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Chani woonaka khannooria wiihukumulha ittu yorera yo upanga? ");
INSERT INTO mgh2016_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ukhalhawaya ntu munttekenlhe inyu orwehakani umilhatuni, iri mbaya umwiiwanana nnari mphironi nhinaphiya, huurweeheni wa aholhelhi anohukumulha milhatu, ni inyu nkamwaattukiya wa attu anaatuka attu, nhelhiyaka njeerani. ");
INSERT INTO mgh2016_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ikekhiaye khannowa mwaakhuma wowo mpaka nhomalha ulhiva isenti yo umalhihera nlhatu winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yeyo ikatema iyo, nkayaawa attu akina ni umwiirelha Yesu mwaha wa attu o Ugalilaya yeevakachiye ni Napilato ni iphome aya nkayaathakanihiya ni isadaka yaakumihiya wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu nkaakhulha, “Chani nnaanyihera wiira yayo attu ayo aari o uwonya waapwaha Agalilaya akina, wo wowo uttwaruwa uwo? ");
INSERT INTO mgh2016_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mena! Ni mii kinouhimeriani wiira, mwaahikhoromeke ni uhiya uwonya winyu, nnookhwacha onkhaye thoko chinre aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ama attu khumi ni nane yaawulhuwelhiye ishanja Usiloamu ulhe nkayaakhwa, yaari attu o uwonya waapwaha attu yaakhalha Uyerusalemu? ");
INSERT INTO mgh2016_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mena! Kinouhimeriani wiira, mwaahikhoromeke ni uhiya uwonya winyu, ni inyu nnookhwa chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Paahi Yesu nkaahimeria nna nlhikaaniho nna, “Ahaawo ntu mmoka aalhilhe mwiri wo ntini umatani waanlhe awe izabibu. Nkaawa uuwehani kila iyaakha oone wiira uhemma athomolhe, nansho wo uhiphwanya ittu. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nkaamwiirelha ntu aashunga imata uyo, ‘Nkoonani! Iyaakha taaru chonkhaye chi kihowa va wo uhiphwanya ittu ata mena. Vano etu nkakheke mwiri uyo! Weeshiyani uthepa ulhia ittaya wo uhikhalha maana?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nansho ntu aalhita imata uyo nkaakhulha, ‘Nkahiyani pwiiya, ukhalhe iyaakha imoka ilha, kinookhureria ni uhelha ichaayira. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mwaahiino wemmaka aye, waahimmeke, vavawo etu mmweeke mwaakakha.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nihuku no Wiittuwa nimoka Yesu aari eettuchihaka wi inupa yo unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Vavawo ahokhalha nthiyana mmoka awereiya mashoka o unanara iyaakha choomalhaka khumi ni nane, iruttu aya yaari inaremanre ahookokwaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu vonne awe, nkaamwiihana ni umwiirelha, “Amma, nholhamihiya ikwerere inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nkamweeshera moono awe, ni yeyo ikatema, iruttu awe nkayookwaa tho, nkayanthimicha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nansho olhupalhe emelhelha inupa yo unlhapelha Nlhuku nkayaarushiya chinene woona wiira Yesu honlhamiha ntu Nihuku no Wiittuwa. Paahi etu, nkeerelha attu, “Arii mahuku sita o upanga ntheko, mmweeke yayo mahuku ayo mmwe mwaalhamihiya, nansho kuhiwe Nihuku no Wiittuwa!” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Athithi nkayaakhulha, “Mwa anafiki inyu! Mpani mmoka inyu hinonthaphulha mwannama awe ama iphuta awe nhiilhini wiira awurihe maashi Nihuku no Wiittuwa? ");
INSERT INTO mgh2016_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vano etu vaa hawo Mwaana a Aburahimu aremarihiye ni Nakare iyaakha khumi ni nane. Chani khireenre wiira ahulhelhiye Nihuku no Wiittuwa?” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nlhove naakhunlhe awe, nkanaahelha ishoni amalhaponi awe, nansho attu akina onkhaye yaari anateelhiye wo woona chittu cho nthimicho chaapangelhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu nkaakoha, “Imwene ya Nlhuku inolhikaana ni? Kilhikaaniheke ni ishiyani? ");
INSERT INTO mgh2016_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Inolhikaana thoko choo. Ntu aawelhe imbeyu ikaani chinene yo iharadali nkaalha umatani wawe. Nnyepu nkawonnuwa ukhalha mwiri mulhupalhe, ashinuni o uchulhu wiirimu nkayaathekacha iphuuru chaya mmarittani mwaya mmo.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu nkaakoha tho, “Kilhikaanihekeni ni Imwene ya Nlhuku? ");
INSERT INTO mgh2016_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Thoko, opani amoka aawelhe ihengedure nkoothuwaniha iphepa madebe melhi ni ntikha nkayaarurummwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu nkaarwa miholho nkwaha awe wo Uyerusalemu aviraka mmawani ni nttokoni mwonkhaye, eettuchihaka attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ntu mmoka nkankoha eeraka, “Thithi, chani attu vakani phi nohalha ulhama?” Yesu nkaakhulha, ");
INSERT INTO mgh2016_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mwiikayeke uvira nlhako wo uyevayeva, ukhalhawaya attu enchi anoolhikacha uvira nansho ahooriaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Anoowa mahuku anene inupa vanohalha aya uttia nkhora, ni inyu mwaatti mweemelhaka vathe mwiihanaka mwiiraka, ‘Pwiiya, nnihulhelhe.’ Nansho yayo anowa uwaakhulhani, ‘Akuuchuwenlheni mwaattiva!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ni inyu nnoowa mwaakhulha, ‘Hii phi alhe naalhia ni uwuria vamoka ni inyu, nkamweenittuchiha uwanihu!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ayo anowa wiira vavawo tho, ‘Kinre wiira akuuchuwenlheni mwaatti. Nthamache va, inyu mwaatti o uwonya va!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Phi nohalha aya ukhalha nunlhiho ni ukhura miino, vanohalha inyu woona Aburahimu ni Naisaka ni Nayakhobo ni anamilhohi onkhaye nhina Imwene ya Nlhuku, nansho mwaatti nkamwaakhotiya! ");
INSERT INTO mgh2016_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Attu anoowa ukhuma unosha nchuwa ni akina uneelha nchuwa, uchulhu ni uchawa ni ukhalha ukaraamuni Imwene ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Eiyo, wo ikekhiaye ahanlhe utulhi anowa ukhalha o uholhelha, ni ayo aholhenlhe vano ayo anowa ukhalha o umalhihera.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yeyo ikatema iyo, Amafarisayo akina nkayaawa wa Yesu ni umwiirelha, “Nthame vaa nrwee vakittu vakina, ukhalhawaya Naherode anothanana uwiivani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu nkaamwaakhulha eeraka, “Nrweeke mwaahimerieke anancheto ayo, ‘Kinoomolha mashoka o unanara ni waalhamiha areta lhelho ni meelho, nihuku no neraru kinomalhiha ntheko aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Inakhalhaka chiicho, lhelho, meelho ni nroto kiri munkwahani mwaka, khavanlhoka namilhohi wiiviya uriwoothe ihikhalhe Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Uyerusalemu, Uyerusalemu! Nneeva anamilhohi, nnaata malhuku akarumiya arumiye ni Nlhuku! Vachani kilhikanche aka waathothokaniha achishaana inyu, thoko nankutu chineera awe wo wooramelha achishaana awe mmapuphani mwawe, nansho khamwaattunne. ");
INSERT INTO mgh2016_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haya etu, iwani inyu inoophomolhiya. Kinouhimeriani wiira, khannokoona mpaka vanohalha inyu wiira, ‘Atotopelhiye uyo nowa wo nchina na Athithi uyo.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nihuku no Wiittuwa nimoka, Yesu ahorwaa ulhia yolhia uwani wa Afarisayo aholhelhi, ni attu aari vavawo yaari ammwehawehaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ntu mmoka eepilhe mieto ni miono nkaawa wa Yesu, ");
INSERT INTO mgh2016_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu nkaakoha owiittuchiha malhehero ni Amafarisayo, “Chani, Malhehero ihu anonivaha ikuru yo upanga cho urera unlhamiha nreta Nihuku no Wiittuwa ama uhipanga?” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nansho khayaakhunlhe nlhove. Yesu nkankusha ntu uyo, nkanlhamiha, ni unhiya ahokolhie uwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Paahi nkeerelha attu ayo, “Mpani munlhokoni mwinyu mwaamwanawe ama iphuta awe yatumbuchiraka munlhikitini, hinorwaa ni unkumiha inakhalhaka niri Nihuku no Wiittuwa?” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Attu ayo khayoonrie umwaakhulha ittu. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu nkoona attu akina alhalheiye cheera aya wo uthanlha ihiche choombone, nkeerelha nna nlhikaaniho nna, ");
INSERT INTO mgh2016_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ntu olhalhiakani u arusini, nhikhalhe mapuro o nthimicho, hiwe nlheto nothimichiya uupwahani inyuva. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Vavawo ntu olhalhelheni mwaattiva onkhaye, nowa uwiirelhani, ‘Nthameke mwaaviriheke alha.’ Phi vavawo vanowa inyu wuulhihiya muru vaattuni ni urwaa uukhalhani utulhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nansho, mwalhalheiyaka nrweeke, mwaphiyaka mwakhalheke utulhi, anenchi inyu ayo owihanekeni, eereke, ‘Mpwana uweeke waakhalha uholho unouno.’ Vavawo nnowa mwaapatta nthimicho vaattuni va alheto onkhaye vawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ukhalhawaya ntu riyoothe neewelhiha, nookurushiya, ni ntu neekurusha noowelhihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Paahi Yesu nkeerelha anenchi awe ayo, “Mwaaterekhelhaka attu yolhia, uthana ama uhiyu, nhaalhalhie ashilhoko inyu ama manyampwana inyu ama attu o nhakhu, ukhalhawaya ni ayo anowa uulhalhiani, nkayolhivani. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Vanoterekha inyu yolhia ya ikaramu, mweehanacheke ashikini, attu o uremara, attu o makutulha ni attu ohoona, ");
INSERT INTO mgh2016_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","vavawo nnooreeriya, ukhalhawaya yayo kharina ittu yo ulhivani. Nlhuku phi nohalha uulhivani nihuku na attu orera nrima vanowa aya uhihimushiya nnookhwani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ntu mmoka aari nakhanlhe vavawo veewilhe awe, nkaamwirelha Yesu, “Ahoreeriya yayo attu anohalha ukhalha ukaraamuni alhiaka wi Imwene ya Nlhuku ayo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu nkaakhulha, “Ntu mmoka ahoterekha ikaramu yulhupalhe yeehanne awe attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Vaayilhe aya, nkaamwiirelha karumiya awe arwee ehanache alheto, ‘Mmweeke vano mwaatti, ikaramu ihaaya!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nansho onkhaye khayaawilhe, kila mmoka ahimiaka nlhatu ni urwaa unthekoni wawe, o upacha alhepelhaka eeraka, ‘Nkakihiyeni kirwee kawehe imata kithumme aka, nkihiye etu kirwee wowo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nkhwawe uyo aholhepelha ni wiira, ‘Kihothuma ing'ope khumi cho ulhima elhi elhi ni vaa kiri munkwahani ulhikachani, nkakihiyeni kirwee wowo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nkina nkeera, ‘Kithenlhe naanano, paahi etu akinowa.’” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Karumiya nkaahokolhia ni waahimeria anrumme. Anene ntheko nkayaarushiya chinene nkaamwirelha karumiya uyo, ‘Waakuvieke urweeke mmaphironi ni mmawani, mweehaneke amashikini ni attu oremara ni attu ohoona ni attu oheeta.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Karumiya nkaahokolhia nkeera, ‘Thithi, malhehero inyu ahopangia, nansho attu khari enchi khanachara.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Anene nkayamwiirelha karumiya tho, ‘Urweeke etu vano mmaphironi ni nchereshere mmo, waakhupeke attu awaacheke awe aachariha inupa. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kinouhimeriani wiira, khaawo ata ntu mmoka kinlhalhelhe aka nohalha ulhawiha yolhia iterekhiye ukaraamuni waka va!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Vavawo milhoko minchi cha attu chaari chinttwaraka Yesu, nkaarukunuwa ni weerelha, ");
INSERT INTO mgh2016_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ntu riyoothe nowa uwannyaka, ahikittuneke mii ni waavenga athumwanawe ama anumwanawe ni ahanu awe ni achishaana awe ni ashihima awe ni ashirokorawe ata ni ukumi awe mwanene, khanooria ukhalha owiittucha aka. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ntu hinokusha nsalaaba awe ni ukittwara khanooria ukhalha owiittucha aka. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ntu mmoka inyu athananaka utheka ishanja, nochokholha ukhalha thoko vathi aalhakelhe nhakhu unthananiya, oone wiira nowooria yoyo ntheko uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aahikhalhaneke, khanooria upanga ata ntheko wo utheka nsingi, ni attu onkhaye anowa unthiaa, ");
INSERT INTO mgh2016_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yiiraka, ‘Yolha ntu ulha ahochokholha rata, nansho hoochelha umalhiha!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ama mwene ani nothanana waatakana ikhoto ni mwene nkina hinokhalha nipuro ni wuupuwelha thoko. Noopuwelha wiira, chani manyaasikari elufu khumi arina awe anowooria waatakana ikhoto ni amwene akina? ");
INSERT INTO mgh2016_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Oonaka wiira khanooria, phi naaruma awe attu o urweeha nttenga wo mpuha wo wiiwanana ni yoyo mwene uyo ahinakumaana. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chiichammo etu, khaawo ata mmoka inyu nokhalha owiittucha aka aahihiyereke kila ittu rina awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Maakha ari o uchiva, nansho athuwaka, anohalha uchivihani? ");
INSERT INTO mgh2016_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Khanlhoka tho nttayani mena ukhalha ichaayira, anokhalha o rihiya. Ri ni maaru eeweke!” ");
INSERT INTO mgh2016_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nihuku nimoka attu o ulhiviha ikhodi ni attu o uwonya enchi yahowa umwiiwelhelhani Yesu, ");
INSERT INTO mgh2016_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Amafarisayo ni owiittuchiha Malhehero nkayaachokholha utukutuwacha, “Mmwooneke yolha ntu ulha! Naapochera attu o uwonya ni waalhiana yolhia!” ");
INSERT INTO mgh2016_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Paahi Yesu nkaahimeria nna nlhikaanihero nna, ");
INSERT INTO mgh2016_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ntu ri ni ikhondoro imia imoka, oonaka imoka ihopotera, neera chani? Noohiya chikina makhumi tisa ni tisa chiyo wiithuphini, ni urwaa uuthothani imoka ipotenre iyo mpaka oone. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oonakaru, khuchishaka vanikhathani ");
INSERT INTO mgh2016_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ni uhokolhia attapelhelhaka. Khweehanaka manyampwana awe ni amwatamana eeraka, ‘Nittapelhelheke etu mwaatti, ikhondoro yaapotenre ihoonia!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Chiicho kinouhimeriani wiira, phi nohalha aya uttapelhelhiya wiirimu ntu mmoka o uwonya vanokhoroma awe ni uhiya uwonya, waapwaha akina makhumi tisa ni tisa ahinovarechesha ikekhia. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ama nnoona chani, opani amoka ari ni makhobilhi khumi, naapoteraka nimoka anohalha wiira chani? Anooparihelha ikhandiri ni ukwecha inupa aaviaka rata mpaka oone. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vanoona aya, phi neehana aya manyampwana aya ni amwaatamana vamoka, eeraka, ‘Mwaatti, nkanngwe nittapelhelhe nikhobilhi naakipotenre nihoonia!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Chiichammo etu, kinouhimeriani wiira, minepa cha Nlhuku phi neera aya wo uttapelhelha ntu mmoka o uwonya vanokhoroma awe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu nkaathepa waahimeria eeraka, “Ahaawo ntu aari ni ashaana elhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mwankani uyo nkeerelha athumwane, ‘Athumwanaka, nkivahe nhakhu unkiphwanelha.’ Nkaakawelhachiya elhi ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Avireke mahuku vakani, nkaathumiha nhakhu awe ni urwaa nkwaha wo utayi ni ihera chonkhaye chaarina awe. Wowo nkaakhalha ni ulhia chonkhaye pufia. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Vaamalhinhe awe kila ittu, nkawaakhumelhelha ikuruna, nkaachokholha uthemwathemwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nkaarwa upangani ntheko wa ntu mmoka nnenchi o yeyo ilhapo iyo, anrweehilhe umatani wawe alhihe ikulhuwe. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nkaathanana ata ukhura makova aalhiya ni ikulhuwe, ukhalhawaya khaawo ntu anlhoha. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Voopuwenlhe awe, nkeera, ‘Wa athumwanaka, anamitheko enchi anoolhia ni urupalha, ni mii uno kikhwaaka ithalha! ");
INSERT INTO mgh2016_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kinoohokolhia etu uwani wa athumwanaka keerelhe, Athumwanaka, kihowonya irimu ni uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Akinophwanelhiya wiihaniya mwaamwaninyu, nkipangeke thoko mmoka a anamitheko inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Paahi etu nkaachokholha nkwaha wo uhokolhia uwani.” “Nari utayi, athumwanawe nkaamwona, nrima nkawaakelha ikiriri, nkayaattimakacha, nkayampochera ni unkumbatira mwaamwanaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwaamwanaya nkeera, ‘Athumwanaka, kihowonya wa Nlhuku wiirimu ni uwaninyu. Akiphwanelhiyaka tho wiihaniya mwaamwaninyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nansho athumwanawe nkeehana akarumiya aya, eeraka, ‘Mwaakuvieke, nkawaani! Mmwiiheke ikuwo choombone chiyo, mmwe mwammwariha. Mummwariheke ni pete nnikokhoni ni iratu mmietoni mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mwamalhaka nrweeke mwanhitheke mwang'ope o uneneva uyo, nittapelhelhe! ");
INSERT INTO mgh2016_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ukhalhawaya mwaamwanaka ulha ahokhwa nansho vano ri nkumi, ahopotera, nansho vano hoonia.’ Nkayaachokholha uttapelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yeyo ikatema iyo, mwaana mulhupalhe uyo aari umatani. Vaahokolhia aya, aatameriaka vawani, nkayeewa ikoma choopiyaka attu eenaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Paahi etu nkaamwiihana karumiya mmoka ni unkoha, ‘Ana urini?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Karumiya nkaakhulha eeraka, ‘Nhima inyu hohokolhia uwani, ni athumwaninyu ahonhithelha mwang'ope o uneneva ulhe, ukhalhawaya ahompatta nari nkumi.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mmirawo mulhupalhe uyo nkaathunalha chinene nkaakhota ukelha mpaani, athumwane nkayaawa ni umpepecha wiira akelhe mpaani. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nansho uyo nkaakhulha, ‘Nkoonani thithi, iyaakha chonkhaye chi kinovara ntheko uukavihani thoko ipotta, mena akinawonya malheheriyo inyu. Nkivanheni? Khannakivaha ata mwaapuri wiira kiipuhihe ni manyampwana aka! ");
INSERT INTO mgh2016_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nansho ulha mwamwaninyu ulha, holhia pufia nhakhu wonkhaye ni ashithiyana o ulhavalhava, ni vano vahokolhelhe awe, nhonhithelha mwang'ope o uneneva! ");
INSERT INTO mgh2016_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Athumwanawe nkayaakhulha, ‘Mwaamwanaka, uri ulhokelhaka ni mii, ni kila ittu iri yawawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nansho ninttapelhelha ukhalhawaya nhima inyu ahokhwa, nansho vano ri nkumi, ahopotera nansho vano hoonia.’” ");
INSERT INTO mgh2016_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu nkeerelha owiittucha awe, “Ahaawo ntu o nhakhu aari ni akarani o ipilhi yo weemelhelha nhakhu awe. Nkaahimeriya wiira akarani ayo aari alhiaka pufia nhakhu awe uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Paahi nkeehana ni weerelha, ‘Urini anaa, malhove kineewa aka alha? Nkaalhakelheke etu nhakhu aka, ukhalhawaya khanrina tho ipilhi yo ukhalha akarani aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Akarani nkayeechiirelha aneneru, ‘Anene ntheko alha ankelha ukithurulha ipilhi aka. Kiireke chani vano etu? Akooriaka ulhima, koonaka ishoni unlhepelha ntu. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aye, kihochuwelha cho wiira! Vanohalha aka uhiihiya ipilhi aka munthekoni vawo, kinowa kaapatta manyampwana o kipochera mii mmanupani mwaya.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Paahi nkeehana attu onkhaye aashimihiye nchurukhu ni anene ntheko. Nkaakoha o upacha, ‘Ana mwaashimme nchurukhu nchani?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nkaakhulha, ‘Mapipa imia o makhura o uto, maalhakelhiyo ayo alha vaa.’ Akarani nkayeera, ‘Nkhalheke nlhepeke wiira yaari makhumi nthanu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nkankoha nkina, ‘Haya ni inyu mwaashimme nchani?’ Nkaakhulha, ‘Kaashimme mirupa imia imoka cho ngaano. Maalhakelhiyo ayo phi alha vaa.’ Nkeerelhiya ni uyo, ‘Nlhepeke wiira yaari mirupa makhumi nane.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Paahi etu, anene ntheko ayo nkayaapuhiha yayo akarani o ipilhi o uhilhoka ayo wo irusho chaarina aya. Ukhalhawaya attu o velhaponi ari o upenya waapwaha attu o nthuko.” ");
INSERT INTO mgh2016_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu nkoolhumacha tho, “Ni mii kinowiirelhani wiira, mpangeke umpwana ni nhakhu wo mwiilhaponi, vanohalha aya umalha vawo, mmwe mwaapocheriya mu nihema no mahuku o uhimalha.” Vavawo nkeerelha, “Mwaatti nneepanga orera nrima mwaattuni, nansho Nlhuku achuwelhaka mirima chinyu. Ukhalhawaya ittu inoonia uteelha waattuni, Nlhuku noona wiira phiri yo uhilhoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ntu riyoothe nokhulhuvelhiya wo makani nowa ukhulhuvelhiya wo chittu chuulhupalhe, ntu hinokhulhuvelhiya wo makani, khanowa aakhulhuvelhiya wo chittu chulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mwaahirumelhelhiyeke wo chittu cho mwiilhaponi, nnohalha ukhulhuvelhiya chani etu wo nhakhu we ikekhiaye? ");
INSERT INTO mgh2016_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Vavawo mwaahiphwanelheke munhakhuni mwa ntu nkina, mpani etu nohalha uuvahani ittu?” ");
INSERT INTO mgh2016_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Khaawo namitheko nooria waatumikelha ashinene ntheko elhi, apangaka chiicho, nowa unvenga mmoka ni unttuna akina ama nookhulhuvelhiya wa ntu mmoka ni uhikhulhuvelhiya wa ntu nkina. Khannoria ukaviha ntheko wa Nlhuku ni nhakhu vamoka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Amafarisayo veewilhe aya chaahimiya ni Yesu, nkaayaathunalhacha wo nlhatu no uttuna nchurukhu chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu nkeerelhacha, “Mwaatti phi inyu nneepanga attu o nrima woombone mwaattuni, nansho Nlhuku achuwelhaka uwonya winyu. Ukhalhawaya chittu chinoonia wiira phi chorera mwaattuni chechiyo phi cho uhilhoka wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malhehero a ashinna Musa ni malhove alhepiye ni anamilhohi chaari chihimiyaka mpaka ikatema i Nayohana Obatiiza, ukhuma vavawo, Malhove Orera o Imwene ya Nlhuku phi nohimiachiya, ni kila ntu akelhaka wo machiri. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nansho vari vowaalhuwa irimu ni ilhapo uvira, upwaha inakhalhaka nlhove nimoka nilhepiye no Malhehero ufutiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ntu riyoothe naavaha mahanu awe italaka ni waathelha athiyana akina, holhavalhava, ni ntu naathelha opani ayo, ni uyo holhuva. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ahaawo ntu mmoka o nhakhu aawara ikuwo cho nchurukhu mwinchi cho thereria ni ukhalha mumpuhani mahuku onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nkaakhalha tho ntu nshikini eehaniya Lazaro, aachanre makhwata iruttu yonkhaye, aawiihiya kila nihuku vankhorani va ntu o nhakhu ulhe, ");
INSERT INTO mgh2016_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","amirelhaka ishenye cholhia chaamoramora vamezani va ntu o nhakhu ulhe. Ni ashipwa aari awaaka alhathaka makhwata awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nshikini ulhe, nkaakhwa, nkaakushiya ni minepa wiirimu ukhalhihiyani vamoka ni Aburahimu. Ntu o nhakhu ni uyo nkaakhwa, nkaavithiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Unaminepa nkaakhalha muuttwaruwani chinene, nkaapathusha miitho nkoona Aburahimu anakhanlhe utayi vamoka ni Nalazaro. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Paahi etu nkayeehana, ‘Apwiiya Aburahimu! Nkoonelhe ikiriri, mwaarume Nalazaro inakhalhaka apaphe vachulhu nikokho naya mmaashini, awe aatipiha nlhimi naka nna, ukhalhawaya mooro uri mu ukipahani chinene!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nansho Aburahimu nkayaakhulha, ‘Muupuwelheke anaka, wiira vaari inyu akumi valhe mwaari mpuhaka chinene, Nalazaro ahuvaka. Nansho vano uno ari mumpuhani, ni inyu nhuvaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Inakhalhaka chiicho, variyari ihu hii ni inyu mwaatti, vari nlhikiti nulhupalhe, khavanooria ntu uwa uno ni attu o uno uwa wowo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ntu aari o nhakhu ulhe nkeera, ‘Kinolhepelha etu pwiiya wiira, mwaarume Nalazaro ayo arwee uwannyaka wa athumwanaka, ");
INSERT INTO mgh2016_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ukhalhawaya ahohalha ashihima aka athanu, arwee aamukache, ni ayo ahiwe aaphiyelha nna nipuro no ntwarusho nna.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aburahimu nkayeera, ‘Ashihima inyu ahana malhove alhepiye a ashinna Musa ni anamilhohi akina o waamuka, eewelhelheke yayo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ntu o nhakhu ulhe nkaakhulha, ‘Yeyo vekha aya khinthosha, pwiiya Aburahimu! Nansho ntu akaahihimmwe ni urwaa wowo, vavawo anokhoroma ahiyaka uwonya waya.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nansho Aburahimu nkayeera, ‘Yaahiiweke malhove a ashinna Musa ni anamilhohi, khanowa aarumelhelha attu ariyoothe anakhalhaka ahihimmwe nnookhwani.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu nkaahimiachera owiittucha awe wiira, “Chittu chinaahelha attu mu uwonyani lazima chikhumelhelhe, nansho hothapana ntu naawonyiha attu akina! ");
INSERT INTO mgh2016_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikaari mbaya yoyo ntu uyo akaattukelhelhiye nshilho nshikoni ni urihelhiya ubaharini kuliko ummwonyiha mmoka aya alha ashinkani alha. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Paahi etu mwiichinanelheke! “Nhima inyu awonyaka, munchachereke, akhoromaka munlhevelhelheke. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ottekelhakani imara saba wo nihuku nimoka, ni kila ikatema awaaka ni wiira, ‘kihokhoroma,’ munlhevelhelheke.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Akarumiya nkayeerelha Athithi, “Nnuncherereke nrima.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Athithi nkayaakhulha, “Mwakaari ni nrima wo upisha inakhalhaka mwankani thoko imbeyu yo iharadali, mwaneerelha ulha mwiri wo nkhuyu ulha, ‘Mwiikhulhe mwaanene mweephateelhe ubaharini!’ ni uyo waanowiiwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Niire wiira mmoka inyu hanaa karumiya nonlhimelha ama noshunga ikhondoro chawe. Chani vanohokolhia awe umatani, noomwiirelha, waakuvieke, ukhalheke, ulhieke yolhia? ");
INSERT INTO mgh2016_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mena! Nomwiirelha, ‘Ukiterekhelhe yolhia mii thoko, mwiichesheke rata ni ukitumikelha mii vanolhia aka ni uwuria vawo, wamalhaka uterekheke yawao.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chani aterekhaka nonttuna yoyo karumiya uyo wo ntheko ulheheriye awe? ");
INSERT INTO mgh2016_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ni inyu mwaatti chiicho, mwapangaka ntheko ulheheriye inyu, mwiireke, ‘Hii niri akarumiya o uhikhulhuvelhiya, nihopanga tu thoko chilheeheriye ihu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu vaarwaa awe Uyerusalemu, ahovira mmwiinanoni mwo Usamariya ni Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Vaaphiya awe iwani imoka, nkaakumaana attu khumi o makutulha eemenlhe utayi ");
INSERT INTO mgh2016_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","akhuwelhachaka, “Yesu! Thithi! Nnoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu vonne awe nkeera, “Nrweeke mweechooniheke wa opochera ishaani.” Vaari aya mphironi arwaachaka, nkayaalhamacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmoka vonne awe wiira holhama, nkaahokolhia, anthimichaka Nlhuku wo nlhove nulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nkeewulhusha vathi oopuruwaka vamietoni va Yesu ni unshukuru. Yoyo ntu uyo aari Nsamariya. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu nkeera, “Yaari attu khumi alhamihiye, akina tisa ayo ari vayi etu? ");
INSERT INTO mgh2016_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Chani woonaka ulha nlheto ulha vekha awe phi wilhe unthimichani Nlhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Paahi Yesu nkaamwirelha ntu uyo, “Munkweke nrweeke, nrima inyu uhoolhamihani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amafarisayo akina nkayankoha Yesu Imwene ya Nlhuku inohalha uwa iyaakhani. Aakhunlhe eeraka, “Imwene ya Nlhuku khinowa thoko chinaanyihera inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Khaawo ntu nohalha wiira, ‘Alha va!’ Ama wiira, ‘Irii valhe!’, ukhalhawaya Imwene ya Nlhuku iri nhina mwinyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Paahi nkaahimeria owiittucha awe, “Ikatema inoowa vanohalha inyu wunlhelha woona ikatema yo Mwaana a Ntu, nansho nhoonaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ahawo anohalha uwa uwiirelhani, ‘Nkoonani, rii valhe!’ Ama ‘Nkoonani rii vaa!’ Nansho mwaatti nhirwee ummwehani. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ukhalhawaya thoko chineera aya wo uverunya uno ni uno wiirimu, phi chiichammo Mwaana a Ntu chinohalha awe wiira nenno nihuku nno. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","nansho ahinaya yayo mahuku ayo, hophwanelhiya uhuva chinene ni ukhotiya ni attu o ilha iyari ilha. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Thoko chaari aya ikatema ya Anuhu, phi nohalha aya ukhalha nihuku no Mwaana a Ntu. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Attu yaari alhiaka ni uwuria, athelhaka ni uthelhiya, mpaka nihuku Anuhu vaawelha aya isafina. Igarika nkayaawa nkayeevakacha attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Inottuna ukhalha thoko mahuku a Nalutu. Attu yaari alhiaka awuriaka, athumihaka ni uthuma aalhaka imbeyu ni utheka manupa. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nihuku Nalutu vaathama aya Usodoma, malhuku o mooro nkaarupa thoko ipulha ukhuma wiirimu ni weevakacha attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Phi nohalha aya ukhalha nihuku Mwaana a Ntu vanohalha awe upatakulhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Nenno nihuku nno, ntu riyoothe nohalha uphwanyiya vanchaarani hikhuruwe vathi uwa ukusha nhakhu awe, chiicho ntu riyoothe nohalha uphwanyiya utimani hihokolhie uwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Moopuwelheke ahanu a Nalutu! ");
INSERT INTO mgh2016_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ntu nothanana woopolha ukumi awe noopoteriha, ntu nokumiha ukumi awe nowa woopolha. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yoyo uhiyu uyo, Kinouhimeriani wiira, attu elhi anowa urupa vamoka, mmoka nowa ukushiya, nkina ahiiyaka utulhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Manyopani elhi anowa ushilha meelhe vamoka, amoka anowa ukushiya akina ahiiyaka utulhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Attu elhi anowa ulhima mmatani vamoka, amoka anowa ukushiya akina ahiiyaka.” ");
INSERT INTO mgh2016_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Owiittucha nkayankoha Yesu, “Thithi, vayi wowo?” Yesu nkaakhulha, “Vakittu variwoothe vari ntembo, phi vakittu vanothukumanacha marepo.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Paahi, Yesu nkaahimiachera nlhikaaniho no weettuchiha wiira ikatema yonkhaye anthananiya akhalhe anlhapelhaka Nlhuku wo uhocha ntu. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nkeera, “Iwani i naneshe ahaawo Ohukumulha mmoka ahanthimicha Nlhuku mena waalhoha attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ni wowo akhalhaka anankhwelhi aawa kila ikatema uwaalhepelhani aakavihe apatte yaahuvelha aya, eeraka, ‘Nkikavihe kipatte ikekhia inohuvelha aka ukhuma wa mmalhaponi aka!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wo mahuku menchi Ohukumulha ayo yaari akhotaka, nansho wo umalhihera nkeera aneneru munrimani mwaya, ‘Inakhalhaka akimoovaka Nlhuku ama waalhoha attu, ");
INSERT INTO mgh2016_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nansho wo nlhatu wo uhuvihiya chinene ni anankhwelhi alha, kinowenkelha ikekhia aya. Kaahiireke chiicho anoothepa ukinyoonyiha, ni ukoocheeha!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Athithi nkayaathepa wulhumacha, “Paahi mwiiweke etu, chenre aya wo wulhumacha yayo o uhukumulha o uhilhoka ayo. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Chani etu, Nlhuku khanowa aalhakelhaka ikekhia attu athanlhiye, anomunlhelha kila nihuku uthana ni uhiyu? Chani noocherewa waavaha inonlhelha aya? ");
INSERT INTO mgh2016_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kinouhimeriani wiira, nowaavaha ikekhia wo uhicherewa. Nansho chani, Mwaana a Ntu nowa aaphwanya attu o nrima vanohalha awe uwa?” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu nkaahimiacha tho nna nlhikaaniho nna wa attu eecherumelhelha woona urera nrima ni waaveehacha attu akina. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ahaawo attu elhi aarweelhe u Inupa ya Nlhuku uulhapelhani, amoka yaari Afarisayo, ni akina yaari olhiviha ikhodi. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Afarisayo nkeemelha vachereshere vo vekha aya, nkaalhapelha munrimani, ‘Kinoushukuru Nlhuku, ukhalhawaya akirii thoko akina o uhilhoka, akihiwe ntu omenyekha mena owiiya mena ntu o ishembwere thoko attu akina chiri aya. Kinooshukuru tho akirii thoko ntu olhiviha ikhodi emenlhe ulha va. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kinoottuka mahuku melhi kila ijuma, kikumihaka ikikhumi yo nhakhu kinopatta aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nansho olhiviha ikhodi ayo, eemenlhe utayi oochelhaka upathusha miitho wiirimu, nansho echaataka vakhakaachani onlhaka ahiyereriye, eeraka, ‘Nlhuku nkoonelhe ikiriri mii ntu o uwonya va!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kinouhimeriani wiira, “Ntu olhiviha ikhodi ulhe aahokolheelhe uwani naalhakelhiye ikekhia. Nansho kuhiwe wa Afarisayo ayo, ukhalhawaya kila neewelhiha nookurushiya, ni kila neekurusha noowelhihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Attu nkayammwiihera Yesu ashaana ashinkani awe eesheracha miono chawe. Owiittucha vonne aya nkaachiichihacha ni waachacheracha. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nansho Yesu nkeehanacha eeraka, “Mwaahiye ashaana ashinkani ayo we uwannyaka, mena nhaachiichihe, ukhalhawaya Imwene ya Nlhuku phi yawaya attu thoko alha. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Muupuwelheke wo ikekhiaye wiira, ntu riyoothe hinopochera Imwene ya Nlhuku thoko mwaana mwankani khanowa aakhelha mwiimweneni.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nholhelhi mmoka a Ayahudi nkankoha Yesu, “Owiittuchiha orera nrima, kipangeke ittu yaani kipatte ukumi wo uhimalha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ni uyo nkaakoha, “Chani woonaka nnokiihana orera nrima? Khaawo ri orera nrima ahikhalhe Nlhuku vekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nhochuwelha malheheriyo, ‘Nhilhavelhave, nhiive, nhiiye, nhimwootherie ntu, mwaathimicheke athumwaninyu ni anumwaninyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nholhelhi uyo nkeera, “Mii kihovara yayo meettuchiho ayo toka kinari mwanhima.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu veewilhe awe, nkaamwirelha, “Nhohalhiha nimoka nnothananiya inyu upanga. Nthumiheke chittu chinyu chonkhaye ni nchurukhu uyo mwaavaheke amashikini, ni inyu nnowiishungera nhakhu wiirimu, mwamalhaka vavawo nkittwareke.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nansho ntu ulhe veewilhe awe chiicho, nkaakelhiya ichuku chinene, ukhalhawaya aari ntu o nhakhu chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu nkoona ichuku chawe nkaamwirelha, “Vari voorikarika chinene attu o nhakhu ukelha wi Imwene ya Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eiyo, khavanorikarika wa ingamiya uperetta va niitho no ntotto, kuliko wa ntu o nhakhu ukelha wi Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Attu yeewa nkayeera, “Mpani etu, nohalha ulhama?” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu nkaakhulha, “Chihinooria wa nttuni, chinowooria wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Paahi Napeturo nkayeera, “Mwooneke etu, hii nihohiya kila ittu ni uuttwarani inyuva.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu nkeerelha attu onkhaye, “Eiyo, ikekhia kinouhimeriani, ntu riyoothe hilhe inupa awe ama amwaarawe ama ashihima awe ama manyanaangoro awe ama ashaana awe wo uttwara Imwene ya Nlhuku ");
INSERT INTO mgh2016_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nowa upochera menchi wo upwaha ilha ikatema ilha ni ukumi wo uhimalha ikatema inowa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu nkaakusha owiittucha khumi ni elhi vathetho nkeerelha, “Mwiiwelhelheke! Vano ninorwaa Uyerusalemu, wowo kila ittu ilhepiye ni anamilhohi imwaachaka Mwaana a Ntu inokootimira. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nokoohelhiya mmathathani mwa attu ahiri Ayahudi anohalha umpangelhacha ncheche ni unruwana ni unshuwelha ishenye. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Anokoomwaata ni umwiiva, nansho nihuku no neraru noohihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nansho owiittucha khayaari achuwelhaka yoyo mwaha uyo, maana aya aari anavithiye, ahichuwelhaka ittu yaahimia awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu vaatameria awe Uyeriko, nkamphwanya ntu mmoka ohoona aakhanlhe vachereshere iphiro, avekelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Veewa awe attu enchi aviraka nkaakoha, “Anaa urini?” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nkaakhulhiya wiira, “Yesu o Unazareti phi novira.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nkaakhuwelha eeraka, “Yesu! Mwaana a Adaudi ukoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Attu yaaholhenlhe ayo nkayanchachera wiira amaalhe. Nansho uyo nkaathepa ukhuwelha, “Mwaana a Adaudi, ukoonelhe ikiriri!” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu nkeemelha ni ulhehera wiira ehaniye. Vaawiihiye awe, Yesu nkankoha, ");
INSERT INTO mgh2016_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Unothanana kuupangelheke ittu yaani?” Nkaakhulha, “Thithi, kinolhepelha woona.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu nkaamwirelha, “Uvahiyeke woona etu! Nrima awo uhoolhamiha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yeyo ikatema, ohoona ulhe nkoona, nkanttwara Yesu uno anthimichaka Nlhuku. Attu onkhaye vonne aya, nkayanthimicha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu nkaaphiya Uyeriko, nkeetakacha mmaphironi. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wowo ahaawo ntu olhiviha ikhodi mulhupalhe eehaniya Zakayo. Yoyo aari ntu o nhakhu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aari athananaka umwoona Yesu chiri awe, nansho aari akani o khuvia oocheelhaka umwoona Yesu rata wo nlhatu no uchara attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Paahi etu nkaattimakacha uholho, nkaawelha munkhuyuni amwoone Yesu rata vanohalha awe uvira. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu vaaphilhe awe vavawo, nkaaweha nchulhu ni uwerelha Nazakayo, “Nazakayo, nkhuruweke mwaakuvieke, lhelho mii ki nlheto uwaninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nazakayo nkayaakhuruwa ni umpochera Yesu athaatheelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Attu onkhaye oona nkayaachukulhacha, “Yolha ntu ulha nokelha uukhalhani wa ntu o uwonya!” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nazakayo nkayeemelha ni wiihimia wa Athithi, “Mwiiweke Thithi! Kinookumiha inusu yo nhakhu aka waavaha amashikini, ni yakhalhaka hawo ntu kanthurunlhe aka ittu, kinonhokolhoshera vacheshe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu nkeera, “Lelho, inupa inyu ihoopolhiya, ukhalhawaya ulha ri uwaninyu ulha ri o iyari ya Aburahimu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mwaana a Ntu wiilhe waathotha ni woopolha attu apotenre.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Attu vaamwiwelhelha aya, Yesu nkaathepa nkaahimeria wo malhikaaniho. Vavawo aari aatameriaka uphiya Uyerusalemu, ni attu yaanyiheraka vano wiira Imwene ya Nlhuku waanonia chitema. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Paahi etu nkeera, “Ahaawo ntu o iyari ye Imwene aarweelhe nkwaha wo utayi apochere umwene, vanomalha awe ahokolhie. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Vaari awe hinaya uthama, nkeehanacha akarumiya awe khumi ni waavaha kila mmoka nchurukhu wo ulhikaana ni umwiirelha, ‘Mpangelheke maronda mpaka vanohokolhia aka.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nansho attu o uwannyawe yaari anvengaka, nkayaaruma akarumiya arwee aahimerie attu ammara nchina wiira, ‘Khaninaattuna ahivariye umwene.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ntu uyo nkaavariya umwene nkaahokolhia uwani. Vaahokolhelhe awe, nkaalhehera eeraka wiira akarumiya aavanhe awe nchurukhu ayo ehaniye awe aalhakelha ifaida apantte aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","O upacha nkaawa eeraka, ‘Pwiiya, kihopatta nchurukhu nkina mikwaha khumi wo nchurukhu mmoka mwaakivanhe inyu ulhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nkaakhulhiya, ‘Aye, anamitheko oombone inyu! Nhokhulhuvelhiya wo makani, kinouvahani vano ikuru yulhupalhe yo weemelhelha iwani khumi.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Karumiya o nayelhi nkaawa eeraka, ‘Pwiiya, kihopatta ifaida mikwaha nthanu vachulhu nchurukhu waakivanhe inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yoyo nkaakhulhiya eerelhiyaka, ‘Nnoweemelhelha iwani nthanu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Karumiya nkina nkaawa nkeera, ‘Pwiiya, nchurukhu wo idhahabu inyu ulha va, kahovitha vanlhutoni. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kaari kuwoovakani, ukhalhawaya inyu attu o urikarika. Nnokusha ittu ihiri yawinyu ni ukhungura vahaanlhe inyu.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yoyo aakhulhiye wiira, ‘Karumiya o uhilhoka uwe! Kinouhukumulhani wo nulhumo ninyu! Wahochuwelha wiira mii kiri ntu orikarika, kinokusha ittu ihiri yawaka ni ukhungura vahaanlhe aka. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aye, woonaka khawarweehilhe unoshungiya nchurukhu? Wowo kaanopatta ifaida yo wuncherera vanohalha aka urwa uhokolhoshani.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Paahi etu, nkeerelha attu yeemenlhe vavawo ayo, ‘Munthurulheke nchurukhu uyo, nkusheke nrweeke mwammaheke karumiya pantte ifaida mikwaha khumi uyo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nansho attu ayo nkayeera, ‘Pwiiya woonaka hopatta ifaida mikwaha khumi upwaha nchurukhu waanvanhe inyu!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nkayaakhulha, ‘Kinouhimeriani wiira attu arina ittu, anowunchereriya, nansho attu ahirina ittu, ata ikani irina aya iyo inookushiya ");
INSERT INTO mgh2016_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ni vano kineera, attu anokivenga wiira kihivariye umwene ayo, mwaawiiheke vaa, eevakachiye vava koonaka kimwanene!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu amalhiheke wulhumacha, nkaaholhelha urwaa Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Vaaphiya awe Ubetifage ni Ubethaniya uri Mwaako wo Mizeituni, ahaaruma owiittucha awe elhi anholhelhe ");
INSERT INTO mgh2016_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aalheheraka eeraka, “Nrweeke iwani iri uholho iyo, vanophiya inyu, nnokomphwanya mwaaphuta nattukelhelhiye hinaya weetihiya ni ntu. Mwanthaphulheke mwammwiiheke vaa. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ntu riyoothe okohakani woonaka nnonthaphulha, mwamwiirelheke wiira, Athithi anonthanana.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nkayaarwaacha ni uphwanya kila ittu thoko chaahimeriye aya ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Vanthaphulha aya mwaaphuta uyo, ashinene nkayaakoha, “Chani woonaka mwaatti nnonthaphulha mwaaphuta uyo?” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nkayaakhulha, “Athithi phi nonthanana.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nkayankusha mwaaphuta unrwehelha Yesu. Nkayaathalhacha ikuwo vanthanani ni ummwelhiha Yesu akhalhe vachulhu vawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Vaamweetiha awe, attu nkayaathalhacha ikuwo chaya mphironi nkaavira vachulhu ikuwo vawo. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Vaatameria awe Uyerusalemu, iphiro yaakelha uri Mwaako wo Mizeituni, nlhoko mwinchi wa owiittucha awe nkawaachokholha untotopelha Nlhuku akhuwelhaka voona aya cho ushangiha chonkhaye choona aya, ");
INSERT INTO mgh2016_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yaari akhuwelhaka, “Nlhuku ammahe ibarakha mwene nowa wo nchina no Athithi uyo! Mpuha ukhalhe wiirimu ni nthimicho wa Nlhuku wiirimu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amafarisayo akina munlhokoni mmo nkayaamwiirelha Yesu, “Owiittuchiha, mwaamaalhiheke owiittucha inyu ayo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu nkaakhulha, “Kinouhimeriani wiira, kaamaalhihaka, malhuku anoweemelha ni ukhuwelha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nkaatameria iwani, ni vawo vonne awe, nkaamoriha miithori o nlhelhaka attu o Uyerusalemu, ");
INSERT INTO mgh2016_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","eeraka, “Mwakaachuwenlhe lhelho chittu chimmwiiha mpuha! Nansho chihovithiya uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ukhalhawaya mahuku anoowa amalhaponi inyu vanohalha aya urukurerihani ntuto, othothokelhakani kila mpatta. ");
INSERT INTO mgh2016_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Anowa uunyikalhachani inyuva vamoka ni attu inyu nlhuwanini mwinyu, ahihalhihaka ata nlhuku nimoka vachulhu nlhuku nikina, wo nlhatu noohichuwelha nihuku Nlhuku naawilhe awe uwoopolhani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu nkaarwa ni Inupa ya Nlhuku nkaachokholha woomolha vathe attu yaapanga maronda, ");
INSERT INTO mgh2016_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","eerelhaka, “Iholhepiya, Nlhuku heera, ‘Inupa aka inohalha ukhalha inupa yo lhapelha attu.’ Nansho mwaattiva nhorukunusha ukhalha nikhuku no attu o uvara makhuche!” ");
INSERT INTO mgh2016_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kila nihuku Yesu nkeettuchiha attu upuwani u Inupa ya Nlhuku. Opochera ishaani olhupalhe ni owiittuchiha Malhehero, ni aholhelhi a attu yaari athananaka umwiiva, ");
INSERT INTO mgh2016_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nansho khayaari ni iphiro yo wiira ukhalhawaya attu onkhaye aari amwiiwelhelhaka, ahittunaka ukufia ata nlhove nimoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nihuku nimoka Yesu veettuchiha awe u Inupa ya Nlhuku, ahimiachaka Malhove Orera, opochera ishaani olhupalhe ni owiittuchiha Malhehero, vamoka ni ashulhupalhe wahowiya, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","nkayaamwiirelha, “Nnihimerie! Nnopanga chi chittu chi wo ikuru ya apani?” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu nkaakhulha, “Nkani ni mii kuukoheni nlhove. Nkakihimerieni etu, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ikuru i Nayohana yo waabatiiza attu yaakhumme wa Nlhuku wiirimu ama wa attu?” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nkayaachokholha ukohanacha ashineneru, “Nimwaakhulheke chani? Neeraka, ‘Wa Nlhuku wiirimu’ no wiira, ‘Chani woonaka khamwaarumelhenlhe Nayohana ayo?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Neerakaru, ‘Yaakhumme wa attu,’ alha attu onkhaye alha anoonata malhuku, ukhalhawaya attu onkhaye yanrumelhelha wiira Nayohana aari anamilhohi a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Paahi etu nkayaakhulha wiira, “Hii khanichuwenlhe waakhumme aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu nkeerelha, “Ata mii akinouhimeriani kimpanga chii wo ikuru yo ukhuma vayi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Paahi Yesu nkaahimeria attu nna nlhikaaniho nna, “Ahaawo ntu mmoka aalhimme imata yo zabibu, nkaashimiha wa anamalhima, nkaarwa nkwaha wo utayi. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nlhaalha waayeke, nkanruma karumiya arwee apochere mahalha o izabibu. Nansho anamalhima alhe nkayaamwata karumiya uyo, nkayanhokolhosha mathatharu. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nkayanruma karumiya nkina, nansho anamalhima ayo nkayanruwanakacha, nkaahokolhia mathatharu. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nkanruma tho karumiya o neraru, anamalhima ayo nkayanrakalhiha ni uyo, ni umwoomolha umatani. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yamalhekeru anene imata yo zabibu nkayeera, ‘Vano kiireke chani? Kinonruma mwaamwanaka kinonttuna aka, ulha anokonlhoha!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nansho anamalhima vaamwonne aya, nkayeeracha ashineneru, ‘Ulha phi mwaamwanaya nohalha uhiyeriya nhakhu. Nngwee nimwiive, nhakhu awe uyo ukhalheke wawihu!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Paahi etu nkayankakhelha uchereshere imata yo zabibu nkayaamwiiva.” Yesu nkaakoha, “Vano anene imata ayo, anohalha weeriha chani anamalhima alhe? ");
INSERT INTO mgh2016_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Anene imata ayo anowa weeva yayo anamalhima ayo, ni uwaashimiha attu akina imata aya iyo.” Attu veewilhe aya, nkayeera, “Mena ahiniphwanye hii yayo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu nkaaweha nkaakoha, “Haya etu alha Malhove Matakatifu alha anohimiani? ‘Nlhuku nikhotiye ni atheki wiira khaninlhoka nihokhalha vano nlhuku no nsingi no vakhoonani.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ntu riyoothe nohalha ukwakwathuwa nenno nlhuku nno nowunthakiacha, ni nno nammulhuwelhaka ntu, ninonhararia.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Owiittuchiha Malhehero ni opochera ishaani olhupalhe nkayaalhikacha ummara Yesu vavawo, ukhalhawaya ahochuwelha wiira aahimiacha nenno nlhikaaniho nno aachaka, nansho nkayoova attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Paahi nkayaavia ikatema yoombone. Nkayaahonga attu o wiipangapanga arwee yankohache chookohiya choonria. Vavawo apatte iphiro yo ummara ni unrweeha wa attu o ikuru yo utawara o Urumi. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yayo attu yaarumiye ayo, nkayaamwiirelha, “Owiittuchiha, nihochuwelha wiira, nri o wiiraniha. Nihochuwelha wiira, khannomova ntu, nnohimiacha ikeekhene yo iphiro ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nnihimerieke etu, iri yo urera ama yo unanara hii waalhiva ikhodi Nakaisari?” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nansho Yesu ahochuwelha nriankho aya uyo, nkeerelha, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nkakooniheni nikhobilhi no nchurukhu. Ilha ikhove ni nchina nna cha apani?” Nkayaakhulha, “Chi Nakaisari.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Paahi Yesu nkeera, “Morera, paahi etu, mwaalhiveke Nakaisari iri ya Nakaisari, ni unlhiva Nlhuku iri ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nkayoochelha ummara wo nlhove niriyoothe vaattuni vawo, paahi nkayaamaalha athikhinaka chenre awe wo waakhulha. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amasadukayo akina, attu yaakhota wiira attu akhwilhe kanhihimwa, nkayaawa wa Yesu unkohani, nkayeera, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Owiittuchiha, ashinna Musa ahonilhehera wiira, ‘Nlhopwana akhwaakaru ni waahiya mahanu awe ahinayara, ahima awe akelheke manupa annyarelheke ashaana ntu khwilhe uyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ahaawo ashilhoko saba o irukulhu imoka, olhupalhe ayo ahothelha nkaakhwa wo uhaahiya ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","O nayelhi nkaakhelha manupa, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","o neraru chiicho. Nkayeeriya chiichammo wa attu saba onkhaye nkayaakhwacha wo haahiya ashaana. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wo umalhihera opani ayo nkayaakhwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","vano etu, nihuku no uhihimushiya attu akhwilhe nno, apani anohalha ukhalha phi owannyaya athiyana alhe? Ukhalhawaya onkhaye saba ahaathelha.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu nkaakhulha, “Attu o ilha ilhapo ilha anoothelha ni uthelhiya, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nansho attu Nlhuku nohalha awe waahihimusha ikatema yo uhihimushiya attu, khanowa aathelha mena uthelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anowa ukhalha thoko minepa mena khanowa aakhwa. Anowa ukhalha ashaana a Nlhuku ahihimushiye nnookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nansho ashinna Musa ahomalha uhimiecheshani wiira attu akhwilhe anoohihimushiya nnookhwani. Vari nlhako unohimiacha mwaha wo ithuphi yaapharelha, inohimia wiira, Athithi phi, ‘Nlhuku a Aburahimu ni Nlhuku a Naisaka ni Nlhuku a Nayakhobo.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Paahi etu ri Nlhuku a attu akumi, kahiwe a attu akhwilhe, ukhalhawaya uwannyawe khaawo nookhwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Owiittuchiha akina nkayeera, “Owiittuchiha, vavawo nhaakhulha rata!” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","olhumanche chiicho ukhalhawaya khayaarina chookohiya chikina tho. ");
INSERT INTO mgh2016_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu nkaakoha, “Inooria chani wiira Kuristo thanlhiye ni Nlhuku, mwaana a Adaudi? ");
INSERT INTO mgh2016_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Adaudi anene nhina ichipo cho Izaburi aneera, ‘Athithi aheerelha Athithi, Nkhalheke wiimonono waka ");
INSERT INTO mgh2016_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mpaka vanohalha aka waathalha amalhaponi inyu wuuthi inyaa chinyu wiira mwaakalhelhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yakhalhaka Adaudi ehanne yayo, ‘Athithi’, vano etu, ineeria chani Moopolhi ukhalha mwaana a Adaudi?” ");
INSERT INTO mgh2016_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Attu onkhaye vaari aya amwiiwelhelhaka, Yesu nkeerelha owiittucha awe, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mwiichinanelheke ni owiittuchiha Malhehero, anottuna weetakacha anawanre ikuwo cho utalhiva ni uchivelhiya ukohachiya wo nthimicho vakittu vanopangachiya maronda, athanlhaka mapuro o nthimicho mmanupani mwo unlhapelha Nlhuku ni mmanupani munoterekhiya ikaramu, ");
INSERT INTO mgh2016_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","anaathurulhacha anankhwelhi ni wiipanga attu o ulhapelha wo ulhapelha ikatema yinchi! Yayo anowa uhukumulhiya ntwarusho wo uweria chinene!” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu nkaaweha rata, nkoona attu o nhakhu cheera aya wo ukumiha isadaka chaya mphacheni Inupa ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","nkoona tho, opani ashikini amoka amorihaka isenti pilhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nkeera, “Kinouhimeriani wo ikekhiaye wiira alha opani ashikini alha ahokumiha waapwaha attu onkhaye akuminhe muu. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ukhalhawaya attu o nhakhu ayo akuminhe isadaka inokhuma mu ifaida yo munhakhuni mwaya, nansho opani alha, ni ushikini urina aya, akuminhe ittu yaakhulhuvelha aya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Owiittucha akina aari aarerihaka wi Inupa ya Nlhuku mwaha wo urera malhuku athekelhiye inupa ayo, vamoka ni isadaka chikumihiye wa Nlhuku. Yesu nkeera, ");
INSERT INTO mgh2016_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Alha malhuku athekelhiye ishiri onkhaye nnona inyu alha, anoowa mahuku vanohalha aya uhihalha vaa ata nlhuku nimoka vachulhu nikina, kila ittu inoophomolhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nkayankoha, “Owiittuchiha, yayo malhove ayo anowa ukhumelhelha iyaakhani? Ni ithikineha yaani inowa unichuwelhiha wiira ikatema ihaaya?” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu nkaakhulha, “Nhiitialhe, nhiwe mwaathepiya. Attu enchi, anowa wiipanga phi mii, eeraka, ‘Miyaano phi Kuristo Moopolhi thanlhiye ni Nlhuku!’ Nkina eeraka, ‘Ikatema ihaaya!’ Nansho mwaattiva nhaatware. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nhiwe mwoova vanohalha inyu wiiwa mwaha wo ikhoto ni uthemwathemwa, yayo ahothananiya uwa, nansho kuhiwe phi umalha wo chittu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nkaahimeria tho, “Makosho anowa waatakana nimoka ni nikina, imwene chinowa chaatakana chineneru. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ilhapo inowa utikhinyia chinene ni ikuruna ni mareta. Unowa ukhumelhelha mwaha wo woopiha attu ni ithikineha chulhupalhe chikhumaka wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nansho yayo ahinaya, nnoowa mwaavariya, nkamwaatwarushiya ni urweehiya mu inupa cho unlhapelha Nlhuku ni ujeerani, nnowa urweehiya wo mamwene ni attu o utawara wo nlhatu no nchina naka. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yeyo phi ikatema inyu yo uhimiechesha Malhove Orera uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mirima chinyu chihiwe chaathemwa, mena woova wiira nnohalha wiira chani wo wiivaraanga, ");
INSERT INTO mgh2016_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ukhalhawaya kinoowa koovahani malhove ni irusho chihinooria uvaanyihiya ni amalhaponi inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nnoowa mwaapangelhiya ichimwa ni manyanaangoro inyu ni ashilhoko inyu ni manyampwana inyu, ni akina munlhokoni mwinyu eeviyaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kila ntu nowa uvengani wo nlhatu wo nchina naka. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","nansho khiiwo ata ikharari imoka mmuruni mwinyu inohalha upotera. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wo uvilhelha winyu, nnowiichoopolha ukumi inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Vanohalha inyu woona iwani yo Uyerusalemu inarukureriye ni amalhaponi, vavawo mmweeke mwaachuwelha wiira uhaaya wo uphomolhiya waya. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Vavawo etu attu arii Uyudea attawelheke umiakoni, attu arii vawani athamacheke, ni ayo ahiri vawani ayo ahihokolhie uwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ukhalhawaya yayo mahuku ayo phi ‘Mahuku o ntwarusho’, Malhove Matakatifu atimirihiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ahothapana manyopani ari veruttuni ni ayo anaamwiha ashaana ashinkani yayo mahuku ayo! Ukhaalhawaya milhatu cho uhuva ni ntwarusho chinowa chaakhumelhelha velhaponi va, ni urushiya wa Nlhuku waawulhuwelhaka alha attu alha. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Attu akina anowa wiiviya wo uphanga, ni attu akina anowa ukushiya mateeka velhaponi vonkhaye, ni iwani yo Uyerusalemu inoowa yaanyikalhachiya ni attu ahiri Ayahudi, mpaka ikatema vanohalha aya utimira.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Chinowa woonia ithikineha chinchi wo nchuwa ni mweeri ni ittotwa. Velhaponi, ilhapo chonkhaye chinowa uhuva, wo nipampa no woova nkhito wo iphioo cho mbaharini. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Attu anowa ukomwaa wo nlhatu no woova, awehereraka mwaha unohalha ukhumelhelha velhaponi, ukhalhawaya machiri o wiirimu anowa utikhinyiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vavawo etu, mwaana a Ntu phi nowa awe, awaaka mmahuteni wo machiri ni nthimicho mwinchi. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yayo vanohalha aya uchokholha, mweemelheke rata ni utheesha miuru chinyu wiirimu, ukhalhawaya Moopolhi inyu ri vakhiviru.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu nkaahimeria nlhikaaniho, “Nkoopuwelhani mwiri wo nkhuyu ni miri chikina chinchi. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Vanoona inyu miri chiphuwaka, phi nochuwelha inyu wiira mmalha iyaakha vano. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chiichammo etu vanohalha inyu woona alha onkhaye alha apangiaka, nnowa mwaachuwelha wiira, Imwene ya Nlhuku ihaatameria.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Wo ikekhiaye muupuwelheke wiira, ilha iyari ilha khinovira yayo ahinaya ukhumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Irimu ni ilhapo chinoovira, nansho malhove aka khanovira mena.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nkhalheke miitho! Mirima chinyu chihiwe chaalhemelhiya ni nikakata no chittu cho velhaponi ni uhapalhiya ni nipampa no iphiro cho mwiilhaponi. Mweettialhaka nenno nihuku nno ninowa ");
INSERT INTO mgh2016_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","noovarakani thoko nriankho. Ukhalhawaya ninoowa naaphwanya attu onkhaye velhaponi va. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nhiittialhe etu, nlhapelheke wo uhoochaa, mmwe mwaapatta machiri o uvira rata vanohalha aya uwa yayo malhove ayo, ni weemelha rata uholho wa Mwaana a Ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu nkaalhokelha yayo mahuku ayo eettuchihaka attu Inupa ya Nlhuku, ni nchuwa veelha aya, aarwaa ulhokelhani uhiyu waari Mwaako wo Mizeituni. ");
INSERT INTO mgh2016_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vaasha aya kila nihuku attu aari apeheriaka Inupa ya Nlhuku uumwiiwelhelhani. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nihuku no isikuukuu yo mikatte cho uhihelhiya ihengedure yo Pasaka naari ninaatamenrie. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Opochera ishaani olhupalhe ni owiittuchiha Malhehero yaari yoovaka attu, paahi nkayaavia nipesha no unhelha Yesu mmachirini eeviye wo uhichuwania ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nakare nkaakelha Nayuda ehaniya Isikariote, mmoka aya owiittucha khumi ni elhi a Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Paahi etu Nayuda nkayaarwaa uupangani miruku ni opochera ishaani olhupalhe ni aholhelhi yeemelhelha Inupa ya Nlhuku chinohalha aya unthumiha Yesu uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nkayaateelhiya nkayeewanana ummaha nchurukhu. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nayuda nkayaarumelhelha, nkayaakhalha yaaviaka nipesha noombone no unrweeha Yesu attu ahichuwelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nihuku nkanaaphiya no mikatte cho uhihelhiya ihengedure mwaakhondoro o Pasaka vaakumihiya awe isadaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu nkaaruma Napeturo ni Nayohana eeraka, “Nrweeke mwaterekheke ikaramu yo Pasaka niwe naalhia.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Owiittucha ayo nkayankoha, “Nnothanana nirweeke naterekhelheke uuyi?” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu nkaakhulha, “Vanophiya inyu vawani, nnokomwoona ntu welhe mwaapu wo maashi. Mwanttwareke mpaka inupa inohalha awe ukelha, ");
INSERT INTO mgh2016_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mwamwiirelheke, ‘Owiittuchiha aneera, iri vayi ichuumba inohalha aka unlhelhia pasaka vamoka ni owiittucha aka?’ ");
INSERT INTO mgh2016_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nokowonihani ichuumba yulhupalhe iri inupa yo nchulhu, imanlhe urerihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nkayarwaacha ni uphwanya kila ittu inari thoko chaahimmie awe Yesu, nkayaaterekhacha cholhia cho Pasaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ikatema yaayeke, Yesu nkaakhalha ulhia yolhia vamoka ni akarumiya awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nkeerelhacha, “Kaholhakelha chinene unlhia Pasaka ulha vamoka ni inyu mwaatti kihinaya uhuvihiya! ");
INSERT INTO mgh2016_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kinouhimeriani wiira, Akinowa kanlhia tho mpaka nihuku vanohalha aya utimira wi Imweneni wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nkaawiaa ikikombe yo idivai, nkanshukuru Nlhuku, nkaavahacha eeraka, “Mmwieke nkawanacheke. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ukhalhawaya kinohimia wiira, ukhuma nna akinowuria tho idivai yo zabibu mpaka Imwene ya Nlhuku vanohalha aya uwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nkaakusha nkatte, nkanshukuru Nlhuku, nkaamianiha, nkaavahacha, eeraka, “Ilha phi iruttu aka, nnovahiya inyu. Mpangeke chiicho wo ukuupuwelha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Thoko chiichammo, nkaavahacha ikikombe vaamalhinhe aya ulhia, eeraka, “Ilha ikikombe ilha phi Malhehano o Naanano anohimiecheshiya ni iphome aka, inorihiaa wo nlhatu ninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nansho, mwooneke! Ntu nokithumiha rii vava, nolhia vamoka ni mii! ");
INSERT INTO mgh2016_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mwaana a Ntu nookhwa thoko Nlhuku chenre awe wo uhimia, nansho hothapana yoyo ntu nohalha unthumiha uyo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Paahi nkayaachokholha ukohanacha ashineneru, phi mpani yoyo nohalha wiira chommo. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nkawaakhumelhelha uvaanyihana munlhokoni mwa owiittucha wiira mpani rii mulhupalhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu nkeerelha, “Amwene o velhaponi va anaatawara attu ahiri Ayahudi wo ikuru, ehaniyaka ‘Manyampwana a attu’. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nansho ihikhalhe chiicho uwaninyu mwaatti, ntu ri mulhupalhe munlhokoni mwinyu nophwanelhiya ukhalha mwankani waapwaha onkhaye munlhokoni mwinyu, ni nholhelhi akhalheke thoko namitheko. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Attu anaanyihera mulhupalhe phi mpani? Phi nokhalha uweherera aterekhelhiye ama naaterekhelha akina? Phi yoyo nokhalha ni uterekhelhiya. Nansho mii kiri va ukhalha namitheko inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nholhokelha ni mii ikatema yonkhaye yo ulhikachiya waka, ");
INSERT INTO mgh2016_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ni chiyo thoko chinre aya Athithi wo ukivaha mii Imwene, ni mii kinouvahani mwaatti Imwene iyo. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nnowa mwaalhia ni uwuria vamoka ni mii wi Imwene aka, ni inyu nnowa ukhalhelha ihiche ye Imwene mwaahukumulhaka makosho khumi ni melhi o Uisraeli.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Nasimoni, Nasimoni! Nkeewani! Nakare naavia nipesha no ulhikachani onkhaye, no uveera imbeyu ni iphepuwa, thoko namalhima chinoveera awe mmuka. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nansho mii kihoulhapelhelhani, Nasimoni, wiira nrima winyu uhiwukuwe. Ni inyu vanohalha inyu ukihokolheelha, mmwe mwaahelha nrima ashilhoko inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Napeturo nkayeera, “Thithi, Kiri tayari uttukiya ata ukhwa vamoka ni inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu nkeera, “Napeturo kinouhimeriani wiira, nthupi uhinaya wiipa mapikoosha, nnowa mwaakiruna vararu wiira khankichuwenlhe mii.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu nkaakoha owiittucha awe, “Ikatema korumme akani wo hikusha nrupa wo nchurukhu mena nchako mena iraatu, chani mwahohuvelha ittu iriyoothe?” Nkayaakhulhacha, “Ata mena.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu nkeera, “Nansho vano, ntu ri ni nrupa ama nchako wo nchurukhu akusheke, ni ntu hiri ni uphanga, athumiheke nikoti nawe athumeke. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Paahi kinouhimeriani wiira, Malhove Matakatifu aneera, ‘Aheeshiya nlhoko mmoka ni attu o uwonya,’ anootimira, ukhalhawaya nlhove ninokaacha mii ninootimirihiya.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Owiittucha nkayeeracha, “Thithi, mmweheke! Vaa ahawo maphanga melhi!” Nkaakhulha, “Haya etu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu nkaathama ni urwaa waari Mwaako wo Mizeituni, aattukanaka owiittucha awe thoko cheera awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Vaaphilhe awe wowo, nkeerelhacha, “Nlhapelheke, nhiwe mwaawulhuwa muulhikachiyani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nkaahiyacha, nkaarwa vatayi vakani wo ntu uwonya nlhuku, nkaakhoroma ulhapelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Thithi, mwattunaka nthamiheke ilha ikikombe ilha. Nansho kuhiwe thoko chinothanana aka nansho mattunelho inyu, atimirihiye.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nnepa wo wiirimu nkawaawa unhelha nrima. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ahuvaka chinene munrimani, nkaalhepelha wo machiri chinene, ntukutta thoko iphome nkanankhuma nkanaamora vathi. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Amalhiheke ulhapelha, nkaahokolhelha owiittucha awe, nkaaphwanyacha anarumpe, ukhalhawaya yaari anakelhiye ihuzuni. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nkeerelhacha, “Chani woonaka nnorupa? Mweemelheke nlhapelheke wiira nhiwulhuwe muulhikachiyani.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu aari bado olhumachaka, mphingo wa attu vaawilhe aya, aholhelhiyaka ni Nayuda, mmoka aya owiittucha khumi ni elhi. Nkaawa ni uthanana unkumbatira Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nansho Yesu nkeera, “Nayuda, nnothanana unthumiha Mwaana a Ntu wo unkumbatira?” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Owiittucha awe yooneke, nkayeeracha, “Thithi, chani nikumiheke mialho?” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mmoka aya nkanthikilha karumiya a Opochera ishaani olhupalhe ni unkwatulha nnyaru no wiimonono. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nansho Yesu nkeera, “Nhiyeke, ilha ihothosha!” Nkankwakwanya nnyaru naakhapiye nno, nkaalhamiha. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Paahi etu, Yesu nkeerelhacha opochera ishaani olhupalhe ni aholhelhi ni attu emelhelha Inupa ya Nlhuku ni ashulhupalhe yaawiilhe ummara ayo, “Chani woonaka mmweelhe mialho chulhupalhe ni indonga uwa uukivarani thoko nnowa ummara ntu o uvara makhuche? ");
INSERT INTO mgh2016_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaari ni inyu mwaatti kila nihuku keettuchihaka Inupa ya Nlhuku, nansho khamwakivanre. Nansho vano phi ikatema inyu yo upanga, phi ikatema yo ikuru yo mwiipiphini.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nkayammara Yesu ni unrweeha upuwani wa Opochera ishaani olhupalhe, Napeturo attwaraka utayiutayi. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mooro waari unaparihelhiye variyari ipuwa, Napeturo nkayaakhalha wootta vamoka ni attu akina. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Karumiya mmoka nthiyana vonne aya anakhanlhe oottaka mooro, nkaaweha ni uhimia wiira, “Ulha ntu ulha chiicho aari vamoka ni Yesu!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nansho Napeturo nkayaaruna, “Uwe nthiyana, akinchuwenlhe mii yoyo ntu uyo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Katashi tho, ntu nkina nkoona Napeturo nkeera, “Inyu mwaari mmoka aya!” Nansho Napeturo nkaakhulha, “Uwe, mii akihiwe!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yavireke isaa imoka, ntu nkina nkaamindelha, “Wo ikekhiaye, khiiwo yo ukhota, wiira ulha aari vamoka ni Yesu, ukhalhawaya ni uyo nokhuma Ugalilaya!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nansho Napeturo nkayaakhulha, “Uwena, akichuwenlhe unhimia awo!” Vavawo vavawo, anari olhumachaka, nthupi nkaweepa. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Athithi nkayaarukunuwa ni waaweha Napeturo wiitho. Napeturo nkayoopuwelha cheerelhiye aya ni Athithi, “Nthupi uhinaya wiipa mapikoosha, nnoowa mwaakiruna mikwaha miraru wiira khankichuwenlhe.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Napeturo nkayaakhuma vathe, nkayonlha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Attu anlhitelhelha Yesu ayo, nkayaamwata ni unheulhacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nkayanttuka ikuwo wiitho ni unkoha, “Nlhamulheke mpani owatilheni!” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nkayanruwanakacha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Washeeke, ashulhupalhe ni opochera ishaani olhupalhe ni owiittuchiha Malhehero a ashinna nkayaakumaana uwaamulhani, Yesu nkaawihiya upuwani. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nkayeeracha, “Unihimerieke, Uweva phi Kuristo Moopolhi?” Yesu nkaakhulha, “Mii kahimiaka, mwaatti khannokirumelhelha, ");
INSERT INTO mgh2016_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ni vavawo kookohakani, khannokaakhulha. ");
INSERT INTO mgh2016_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nansho uchokholhelha nna Mwaana a Ntu nowa ukhalha wiimonono wa Athithi Nlhuku o machiri.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Attu onkhaye nkayeera, “Paahi niireke etu, uwe phi Mwaana a Nlhuku?” Yesu nkaakhulha, “Inyu mwaatti nhohimia, wiira phi mii.” ");
INSERT INTO mgh2016_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ni ayo nkayeeracha, “Chani uhawo uhimiechesha ukina tho! Ukhalhawaya hohimiacha wo malhaku awe mwanene ni inyu nheewacha!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nlhoko wonkhaye nkaweemelha ni unrweha Yesu mpaka u Napilato ");
INSERT INTO mgh2016_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","waamwemenshe aya ni uchokholha uhimiacha milhatu, “Nahomwona ulha ntu ulha aapoterihaka attu o velhaponi, eerelhaka wiira ahilhive ikhodi wa Nakaisari ni wiichihana mwanene wiira, Kuristo Moopolhi thanlhiye ni Nlhuku mwene a Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Napilato nkayankoha Yesu, “Inyuva phi amwene a Ayahudi?” Yesu nkaakhulha, “Thoko chinre inyu wo wulhumacha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Napilato nkayeerelha opochera ishaani olhupalhe ni attu wiira, “Akoonaka nlhatu uriwoothe wa ulha ntu ulha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nansho attu nkayaathepa ukuruvalhelha wo machiri chinene, “Nowaachopeacha ni weettuchiha attu apange injoove ilhapo yonkhaye yo Uyudea. Aachokhonlhe Ugalilaya vano rii vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Napilato veewilhe aya, nkayaakoha, “Kwani yolha ntu ulha nokhuma Ugalilaya?” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Vaachuwenlhe aya wiira aari ntu o ilhapo yo ikuru i Naherode, nkayanhokolhosha u Naherode uwo, aari yeyo ikatema iyo Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naherode nkayaateelhiya nrima umwoona Yesu, ukhalhawaya yaari amwiiwaka athananaka umwoona toka khalhayi. Akhulhuvelhaka umwoona Yesu apangaka cho ushangiha. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Paahi etu Naherode nkayankoha Yesu chookohiya chinchi, nansho Yesu khaakhunlhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Opochera ishaani olhupalhe ni owiittuchiha Malhehero yaari miholho ahimiachaka milhatu chinchi choomwootheria Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Naherode ni manyaaasikari aya nkayampangelha Yesu ncheche, nkayammwariha n'golole we imwene nkayanhokolhosha u Napilato. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Toka nenno nihuku nno, Napilato ni Naherode nkayaalhutanaacha umpwana, ukhalhawaya khalhayi vawo kila mmoka khaari ewananaka ni nkhunanawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Napilato nkayeehanacha opochera ishaani olhupalhe ni aholhelhi ni attu vamoka, ");
INSERT INTO mgh2016_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nkayeera, “Nhommwiiha yolha ntu ulha uwannyaka mwiiraka wiira aari aapoterihaka attu. Vano etu, kihonkohacha mwaatti mwiiwaka, ni mii akoonne nlhatu uriwoothe uhimianche inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Akihiwe mii vekha mena Naherode oonne nlhatu, phi nhokolhonshe aya uwanihu. Khuuwo nlhatu wo hii umwiiva. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Paahi mii kinomwaata ikopo ni unhiyerera.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila nihuku no Pasaka, Napilato aari ni malhemalhelho o unhiyerera ntu mmoka ttukiye aathananiya ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nlhoko wonkhaye nkawaakhuwelha, “Eeviye! Munhiyerereke Baraba!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba uyo aattukiye wo nlhatu no injoove yaapangeelhe vawani ni nlhatu no weeva attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Napilato aari athananaka unhiyerera Yesu, paahi nkayoolhumana attu tho. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nansho attu yaari akhuwelhachaka, “Munkhomelhelhe vansalaabani! Munkhomelhelhe vansalaabani!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Napilato nkayeera tho vo neraru, “Nansho ttenkeni? Khuuwo nlhatu kinoona aka wo umwiiva! Kinoomwata ikopo ni unthaphulha.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nansho attu nkayaathepa ukhuwelhacha avekelhaka wiira Yesu akhomelhelhiye, ni nlhove naya nkanaarumelhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paahi etu Napilato nkayanhukumulha Yesu thoko chaalhepelha aya attu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nkayanthaphulha Baraba, ntu aattukiye wo nlhatu no injoove ni niiviho, nkayaavaha Yesu wiira ampangeke ittu yaathanana aya, thoko chaavekelha aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Manyaasikaari nkayanvelhelha Yesu, vaarwaa aya nkayankumaana ntu o Ukirene nchina nawe Simoni aawa akhumaka umatani. Nkayanchuchumiha, nkayanriaa nsalaaba, akushe anttwaraka Yesu utulhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nlhoko mulhupalhe wa attu nkawanttwara, akina aya yaari manyopani onlhacha umunlhelha. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu nkaarukunuwelha, nkeerelha, “Manyopani o Uyerusalemu! Nhikunlhelhe mii, nansho mwichunlhelheke mwaashinene ni achishaana inyu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ukhalhawaya mahuku anowa attu vanowa aya wiira, ‘Ahoreeriya manyaathiyana ahiyanre, ahaayanre ashaana mena ulhelha!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yeyo ikatema iyo, attu phi nowa aya wiirelha miako, ‘Nniwulhuwelheke! Nnivitheke!’ ");
INSERT INTO mgh2016_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vavawo attu aneera chiicho wo mwiri nkithi, mwiri wo wuuma inohalha wiiria chani?” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Attu akina elhi, onkhaye o uwonya, yaari ni ayo arweehiyaka wiiviya vamoka ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vaaphilhe aya vakittu vaneehaniya “Nikhurukucha no muru,” nkayankhomelhelha Yesu vavawo, ni attu elhi o uwonya, mmoka wiimonono ni nkina wiimushi. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu nkeera, “Thithi mwaalhevelheke! Ukhalhawaya khachuwenlhe impanga aya.” Nkayaakawanacha ikuwo chawe wo woopelha ikhura. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Attu nkayeemelhacha aawehaka Aholhelhi a Ayahudi vampangelha aya ncheche, “Ahoopolha attu akina, haya etu echopolheke mwanene yakhalhaka uyo phi Kuristo Moopolhi thanlhiye ni Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Manyaasikaari ni ayo nkayampangelha ncheche chiicho, nkayaawa nkayammaha isiki, ");
INSERT INTO mgh2016_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yiiraka, “Wiichopolheke umwanene wakhalhaka uwe phi mwene a Ayahudi!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vachulhu nsalaaba nkayaakhomelhelha nipattu naalhempe aya malhove eera, “Ulha phi mwene a Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mmoka a attu yaakhomelhelhiye vamoka ni Yesu nkaachokholha unruwana Yesu, “Uwe kuhiwe phi Kuristo Moopolhi? Wiichoopolheke umwanene, unoopolheke ni hii!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nkina uyo nansho, nkanchachera nkhunanawe eeraka, “Uwe khunomoova Nlhuku? Ihukumu ipantte awo iyo phi pantte awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hii, ikekhiaye ihu iyo, phi niphwanenlhe, ukhalhawaya nihopochera malhivo o mitheko chihu, nansho uyo khawonnye ittu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nkaamwiirelha Yesu, “Yesu wakuupuwelheke mii, vanohalha awo uwa unari Amwene vawo!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu nkaamwirelha, “Kinoolhelha wo ikekhiaye wiira lhelho nna, unowa waakhalha ni mii Uphiooni.” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yaari saa sita uthana nchuwa vaatiphiilhe aya, ipiphi nkayaawanelha ilhapo yonkhaye mpaka vaari aya saa tisa, ");
INSERT INTO mgh2016_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nipaziya nulhupalhe naattukelhelhiye variyari u Inupa ya Nlhuku nkanaahuwa velhi. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu nkaakhuwelha, “Thithi! Kinoweesha nnepa aka mmathathani mwinyu!” Voolhumanche awe chiicho, nkaarihiaa. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nholhelhi a manyaasikari o Rumi nkoona cheeria, nkanthimicha Nlhuku, eeraka, “We ikekhiaye ulha aari ntu orera nrima!” ");
INSERT INTO mgh2016_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Attu aathukumanne vavawo uweha chaapangiaa ahoona chikhumelhenlhe, nkayaathuruwa mmawani, echatakachaka ikhakacha wo wooniha ihuzuni. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Attu onkhaye anchuwenlhe Yesu, ikhalhaka vamoka ni manyopani antwanre ukhuma Ugalilaya, yaari aneemenlhe utayi awehaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ahokhalha attu amoka o rera nrima anenchi o Uarimathaya iwani yo Uyudea nchina naya Nayusufu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yayo aari ntu o Uarimathaya, aapanga thoko Nlhuku chaathanana awe attuniyaka ni attu, awehereraka uwa wo Imwene ya Nlhuku. Inakhalhaka aari ntu o Ipuwa yulhupalhe ya Ayahudi, khaari arumelhelhaka ittu ipangiye. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yayo yahorwaa u Napilato nkayaavekelha avahiye iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nkayaakurusha iruttu iyo vathi, nkaavilhikelha ikuwo yo hariri, nkayaavitha nnihiyeni mwaahemiye vamwalhani, nihiye naari bado uvithiya ntu. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nenno naari nihuku no Ijumaa, Nihuku no Wiittuwa niwaaka meelho aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Manyopani yantwanre Yesu ukhuma Ugalilaya nkayarwaa ni Nayusufu uwinnuwelhani nihiye nivithiye awe Yesu. Nkayoona vavithiye aya iruttu awe. ");
INSERT INTO mgh2016_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nkayaahokolhiacha uwani nkayaakooroshacha makhura o unukhelha o uwa uuhikani iruttu ya Yesu. Nihuku no Wiittuwa nkayeettuwa thoko Malhehero chaalhehera aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mapikoosha o nihuku no Jumaapili manyopani yahorwaa unihiyeni, anakushilhe makhura o unukhelha aakoronshe aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nkayaaphwanya nlhuku ninapirikishiye ni uthama vanlhakoni vawo, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","paahi etu nkayaakelhacha nhina, nansho khayaaphwannye iruttu ya Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nkayeemelha ashangachaka yoyo mwaha uyo, wo uhikhulhuvelha, nkayaakhumelhelha attu elhi aawanre ikuwo chootelha chinene, eemelhaka waatameria. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Manyopani ayo yoovaka nkayaakhoromacha vathi, attu ayo veera aya, “Yeeshiyani umwaavia ntu nkumi mwa attu akhwilhe? ");
INSERT INTO mgh2016_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Khaawo vaa, hohihimwa. Muupuwelheke chenre awe wo uhimia vaari inyu Ugalilaya, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwaana a Ntu hophwanelhiya uhelhiya mmathathani mwa attu o uwonya, akhomelhelhiye, ni nihuku no neraru ahihimmwe.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Manyopani nkayoopuwelha malhove awe, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nkayaakhuma nnihiyeni, nkayaahimiacha mwaha wonkhaye waahimiachera owiittucha khumi ni mmoka ahanlhe alhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Manyopani ayo yaari Amariamu Magidalena ni Nayoana ni Amariamu anumwanaya Nayakhobo, yayo ni manyopani akina phi ahimianche wa akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nansho akarumiya nkayoona yayo malhove ayo thoko ncheche, khayaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nansho Napeturo nkayaarwaa unihiyeni attimakachaka, nkayooroma, vaathurumenlhe aya nkayoona ikuworu. Paahi nkayaahokolhia uwani ashangaka mwaha ukhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nenno nihuku, owiittucha elhi a Yesu yaari akelhaka iwani yeehaniya Uemau, imaili saba ukhuma Uyerusalemu, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","arerihaka ashineneru mwaha wonkhaye upangeelhe. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Vaari aya eetaka arerihaka, Yesu mwanene nkaawa aatameriaka ni weeta vamoka ni ayo, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","nkayaamwona, nansho ahinchuwelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu nkeerelhacha, “Nnoopa mwaha waani mwaashineneru uno mweetaka?” Nkayeemelhacha, wiitho anachanre ihuzuni. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmoka aya eehaniya Nakileopa nkankoha, “Kwani inyuva alheto va Yerusalemu va, vekha nhinochuwelha chittu chipangelhe alha mahuku vakani avinre alha?” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu nkaakoha, “Mwaha waani?” Nkayaamwaakhulha, “Mwaha umphwannye Yesu o Unazareti. Yoyo ntu uyo aari namilhohi a Nlhuku aari ni ikuru wa Nlhuku ni wa attu yo upanga chittu ni wiittuchiha. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Opochera ishaani olhupalhe ni aholhelhi ihu yahonkumiha wiira ahukumulhiye, nkaakhomelhelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nansho hii nahonkhulhuvelha wiira phi nowa woopolha attu o Israeli! Upwaha vavawo, lhelho nihuku no neraru toka vaapangeelhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tho manyopani akina munlhokoni mwihu ahonithuthusha, yahorwaa unihiyeni lhelho wichishuru, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nansho khayoonne iruttu iyo. Nkayaahokolhia eeraka wiira ahoona minepa chaahimmie wiira hohihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Attu akina nkayaarwaa unihiyeni ni uphwanya thoko chaahimiye ni manyopani alhe, nansho khayamwonne.” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Vavawo etu Yesu nkeerelha, “Woonaka nhophupuwalha mwaatti ayi, wo mirima chimpicha urumelhelha malhove aahimiye ni anamilhohi a Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Chani, khawalhonke Kuristo Moopolhi thanlhiye ni Nlhuku uhuvihachiya, wiira akelhe rata munthimichoni mwawe?” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nkaapatakulhelha chittu chonkhaye chaamwacha nhina Malhove Matakatifu uchokholha wa ashinna Musa mpaka wa anamilhohi onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vaatameria aya iwani yaalhukama aya, Yesu nkeepanga thoko noopwaha vavawo, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","nansho yayo manyaattu ayo nkayampepecha, eeraka, “Nkhalheke ni hii, uheelha.” Paahi etu nkaarwa uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nkaakhalha ulhia yolhia vamoka, nkaakusha nkatte, nkaalhapelhelha ibarakha, nkaamia, nkaavahacha. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Miitho aya nkayaapatakulhiya nkayanchuwelha, nansho nkaapotera vamiithoni waya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nkayeera ashineneru, “Chani mirima chihu khachaari chipharelhaka mooro volhumachawe unilhamulhelha Malhove Matakatifu mphironi mmwe?” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yeyo ikatema nkayaathama nkayaahokolhia Uyerusalemu, nkayaaphwanyacha owiittucha khumi ni mmoka anathukumanne vamoka, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","eerachaka wiira, “Wo ikekhiaye, Athithi ahohihimmwa! Ahaakhumelhelha Nasimoni!” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Owiittucha elhi nkayaahimiacha mwaha waakhumelhenlhe mphironi, ni chenre aya wo waachuwelha Athithi vaamianinhe aya nkatte wa Owiittucha aya. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Akarumiya elhi ayo vaari aya ahimiachaka yoyo mwaha uyo, wo uhiweherera, Athithi anene nkayeemelha variyari aya eeraka, “Mpuha ukhalhe ni inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nkayaathuthuwacha, yaanyiheraka wiira ahoona nshoka. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nansho nkeerelhacha, “Nnoovani? Nnowelhiyani nipampa mu nrimani? ");
INSERT INTO mgh2016_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mmweheke mathatha ni mieto chaka, nkiweheke ni mii kimwanene. Nkikwakwanyeke, nnowoona wiira akiri nshoka, ukhalhawaya nshoka khanirina iruttu yo ithayi mena makhuva, thoko nnokoona inyu chi.” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nkeera chiicho oonihachaka mathatha awe ni mieto chawe. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Akarumiya vaari aya ahirumelhelhaka ittu yoona aya, uno athepaka wuumiya uwanoni wo uteelhiya, Yesu ahaakohacha, “Nhanaa ittu yo ulhia va?” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nkayammaha ihopa yo waaneelhiya, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","nkaakusha nkaalhia amwoonaka. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Paahi nkaahimeriacha wiira, “Chilha phi chittu chaahimilhe aka ikatema vaari aka ni inyu. Ikhalhe wiira, kila ittu ilhepiye ikaachaka nhina Malhehero a ashinna Musa, chilhepiye ni anamilhohi ni Izaburi chihotimira.” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nkaapatakulha irusho chaya wiira achuwelhe Malhove Matakatifu ");
INSERT INTO mgh2016_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","nkeerelhacha, “Phinre aya wo ulhepiya, Kuristo Moopolhi nowa uhuvihiya ni uhihimmwa nnookhwani aviraka nihuku no neraru, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ni wo nchina nawe nttenga wo uhiyereriya uwonya unohimiachiya mwiilhaponi mwonkhaye, ichokholhaka Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inyu phi o uhimiechesha chittu chonkhaye chi. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ni mii kinommwiiha alhehiye ni Athithi uwaninyu. Nansho nnothananiya uweherera nnari iwani yuulhupalhe mpaka machiri o wiirimu vanohalha aya uwa.” ");
INSERT INTO mgh2016_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Paahi nkaaholhelha uthama vawani mpaka Ubethaniya, vaathenshe awe miono nkaavaha ibarakha. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Vaari awe aavahaka ibarakha, ahaahiya, nkaakushiya wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nkayanthimicha ni uhokolhia Uyerusalemu, wo mpuha mwinchi, ");
INSERT INTO mgh2016_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","nkayaalhokelhacha ikatema yonkhaye akhalhaka Inupa ya Nlhuku antotopelhaka Nlhuku.");
INSERT INTO mgh2016_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Vaachokhonlhe aya chittu chonkhaye chihinoopiya, Nlhove ahaawo, ni uyo aari ni Nlhuku, ni uyo aari Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Toka vaachokhonlhe aya Nlhove aari vamoka ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nlhuku voopilhe awe chittu chonkhaye ahaawo, khiiwo iriyoothe yoopiye wo uhikhalha yoyo ");
INSERT INTO mgh2016_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nlhove phi aari machokholhelho o ukumi ni uyo ukumi uyo nkawaawiha nthuko wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nthuko waamwalhelha mwiipiphini, ni ipiphi khayoonrie utipiha yoyo nthuko uyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nlhuku ahonruma karumiya awe, eehaniya Yohana, ");
INSERT INTO mgh2016_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","aawilhe uhimiechesha wa attu mwaha wo yoyo nthuko uyo, attu eewe ni urumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nayohana khayaari yoyo nthuko uyo, nansho aawilhe uhimiechesha wa attu mwaha wo yoyo nthuko uyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yolha phi nthuko we ikekhiaye, nthuko unowa velhaponi ni wamwalhelha attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nlhove ahaawo velhaponi, ni wo iphiro awe ilhapo yahoopiya, inakhalhaka chiicho, attu o velhaponi khayanchuwenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aawilhe velhaponi vawe mwanene, nansho attu awawe khayampochenre. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Akina, nansho, yampochenre ni unrumelhelha, yayo ahaavaha ikuru yo ukhalha ashaana a Nlhuku phi alhe arumelhenlhe nchina nawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ahikhalhaka ashaana a Nlhuku wo iphiro thoko cho uyariya ni ntu, mena mattunelho a ntu, Nlhuku mwanene phi ari athumwanaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yoyo Nlhove uyo nkaakhalha ntu, nkaakhalha uwanihu. Ni hii nahoona nthimicho wawe, nthimicho wawe yoyo ri Mwaana o vekhawe a Nlhuku chanre nnema ni ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nayohana nkayaahimiechesha wa attu mwaha wawe. Nkayaakhuwelha eeraka, “Yolha phi ulhe kanhimianche aka venre aka wiira, ‘Noowa ntu mmoka vatulhi waka, ri mulhupalhe ukipwaha mii, ukhalhawaya ahaawo kihinayariaa.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wo nnema wawe mwinchi, hiyaano onkhaye nihopochera mpuha umpwaha mpuha uvinre. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nlhuku ahonivaha Malhehero wo iphiro ya ashinna Musa, nansho nnema ni ikeekhene chihoniweelha wo iphiro ya Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Khaawo ntu mwonne Nlhuku ikatema iriyoothe. Mwaana vekha awe, aakhalha vamoka ni Nlhuku, phi nichuwelhinhe Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wu phi uhimiechesha u Nayohana, ikatema aholhelhi a Ayahudi o Yerusalemu vaarumme aya opochera ishaani ni Alawi u Nayohana yaakohe wiira, “Inyuva phi apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nayohana khakhonte waakhulha, nkayeera wo uhivitha wiira, “Miyaano kakihena Kuristo Moopolhi a attu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Vavawo nkayaakohiya tho, “Inyuva phi apani etu? Chani inyuva phi Naeliya?” Nayohana nkaakhulha, “Akihena mii.” Nkayaakohiya tho, “Chani inyuva phi anamilhohi alhe anowehereriya uwa uuromolhani nihuku no uwa Masiya?” Nkaakhulha “Akihena mii.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nkayaakohiya tho, “Paahi etu inyuva phi apani? Nnihimerieke mwaanene nlhove nowahimeria anirumme.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nayohana nkaakhulha, “Miyaano phi yolhe anamilhohi ashinna Isaya aahimmie aya yeeraka, ‘Nlhove na ntu niheewaniya muuthakoni, Chookolhiye iphiro cho uvira Athithi!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yayo akarumiya yaarumiye ni nlhoko wa Amafarisayo ayo, ");
INSERT INTO mgh2016_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nkayaakoha Nayohana, “Yakhalhaka inyuva kanhena Kuristo, kanhena Naeliya ni vavawo kanhena anamilhohi, woonaka nnowaabatiiza attu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nayohana nkayaakhulha, “Miyaano kinaabatiiza attu wo maashi, nansho hawo mmoka eemenlhe munlhokoni mwinyu mwaattiva nhinaaya unchuwelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yoyo nowa utulhi waka, nansho mii kihiphwanelhiyaka inakhalhaka uthaphulha miripwe cho ikwakwata chawe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yoyo mwaha uyo waakhumelhenlhe Ubethaniya, unosha nchuwa ukhopelhelhe mwolhoko wo Uyorodani, Nayohana vaari aya aabatiizaka attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Waashelhe waya, Nayohana ahomwoona Yesu awaaka, nkayeera, “Ulha phi Mwaana o Khondoro a Nlhuku nothamiha uwonya wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yolha phi ulhe kanhimianche aka wiira, ‘Utulhi waka nowa ntu mmoka ri mulhupalhe ukipwaha mii, ukhalhawaya ahaawo mii kihinayariaa.’ ");
INSERT INTO mgh2016_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miyaano kimwanene akanchuwenlhe, nansho kiwiilhe uwabatiiza attu wo maashi ikhalhe wiira attu o Uisraeli anchuwelhe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nayohana nkayaahimiechesha eeraka, “Kahomwoona Iphumu ya Nlhuku akhuruwaka thoko kaulha ukhuma wiirimu ni ukorelha vanikhathani vawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miyaano akanchuwenlhe, nansho Nlhuku kirumme kaabatiize attu wo maashi ahokihimeria wiira, ‘Ulhe ntu nnohalha inyu umwoona akhuruwelhiyaka ni Iphumu ya Nlhuku ni unkorelha vanikhathani vawe, yoyo phi ntu naabatiiza attu wo Iphumu ya Nlhuku.’ ");
INSERT INTO mgh2016_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nayohana nkayeera, kihoona, ni mii kihimiecheshe vano wiira yolha phi Mwaana a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Waashelhe waya, Nayohana aari vavawo tho vamoka ni owiittucha aya elhi. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Vaamwonne aya Yesu aviraka nkayeera, “Mmwooneke! Ulha phi Mwaana o Khondoro a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Owiittucha aheewa Nayohana voolhumacha aya yayo malhove ayo, nkayanttwaracha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu nkaarukunuwa, nkoona owiittucha a Nayohana anttwaraka, nkaakoha, “Nnaaviani?” Ni ayo nkayaakhulhacha “Rabi, nnokhalha vayi?” Rabi maana aya, “Owiittuchiha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu nkaakhulha, “Mmweeke ni inyu nnowoona.” Vavawo waari uchechilho, paahi etu owiittucha ayo nkayaarwaa nkayoona vaakhalha awe, nkayankhalhana uwannyawe nenno nihuku nno. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Naandorea ahima aya Nasimoni Peturo yaari amoka ya attu elhi yeewilhe Nayohana voolhumacha aya, nkayanttwara Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vahiphincheru Naandorea nkayaakumaana Nasimoni ahima aya, nkayaahimeria wiira, “Nihomwoona Masiya.” Masiya maana aya Kuristo, Moopolhi. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nkayaavelhelha Nasimoni wa Yesu, Yesu nkaaweha Nasimoni nkeera, “Inyuva phi Nasimoni mwaana a Nayohana, nansho vano nnohalha wiihaniya Kefa.” Ukhalhawaya we Iyunani nenno nchina nno phi Peturo maana aya mwalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Waashelhe waya Yesu nkoona mbaya arwee Ugalilaya. Nkaaphwanya Nafilipo nkeerelha, “Nkittware!” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nafilipo aari anenchi o Ubethsaida, iwani yaakhalha aya Naandorea ni Napeturo. ");
INSERT INTO mgh2016_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nafilipo ni ayo nkaaphwanya Nanathanieli, nkaahimeria, “Nihomwoona ulhe ashinna Musa anromonlhe aya nhina ikitabu yo Malhehero, ni anamilhohi alhepaka nttenga wawe. Yoyo phi Yesu mwaana a Nayusufu, o Unazareti.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nanathanieli nkayaakoha Nafilipo, “Ittu yoombone inowooria ukhuma Unazareti?” Nafilipo nkayaakhulha, “Mmwe mwoona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu vonne aya Nanathanieli awaaka nkeera, “Mmwooneke! Yolha phi Mwiisraeli mwanenene, khiiwo ittu innananre nhina mwawe!” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nanathanieli nkayankoha, “Nkichuwenlhe chani?” Yesu nkaakhulha, “Vaari inyu wuthi nkhuyu Nafilipo ahinaya uwihanani kahowoonani.” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Vavawo Nanathanieli nkayaamwakhulha Yesu eeraka, “Owiittuchiha, inyuva phi Mwaana a Nlhuku! Inyuva phi Amwene o Uisraeli!” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu nkeerelha, “Chani nnorumelhelha ukhalhawaya kihouhimeriani wiira kahowoonani vaari inyu wuthi nkhuyu? Nnowa mwoona moolhupalhe upwaha alha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu nkaahimeria onkhaye wiira, “Kinouhimeriani ikekhiaye, nnowoona irimu chihulhiaka ni minepa cha Nlhuku chiwelhaka ni ukhuruwa vachulhu vawe Mwaana a Ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nihuku no neraru ahokhalha arusi iwani yo Ukaana, ilhapo yo Ugalilaya, anumwanawe Yesu aari wowo, ");
INSERT INTO mgh2016_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ni Yesu aholhalheiya vamoka ni owiittucha awe wa arusini uwo. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Idivai yamalheke, anumwanawe nkayaamwiirelha Yesu, “Idivai ihomalha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu nkaakhulha, “Maanyi, nlhatu waani nnokiirelha chiicho. Ikatema aka khinaaya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Anumwane Yesu aheerelha akarumiya, “Ittu iriyoothe inohalha awe uhimeriani mpangeke.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayahudi ahanaa malhemalhelho o ukhucha. Wo yoyo nlhatu uyo etu, chahokhalha vavawo miapu cho malhuku nthanu ni mmoka. Ni kila mwaapu mmoka waahelhiya maashi wo umalhaka madumu makani makhumi melhi ama makhumi mararu. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu nkeerelha akarumiya, “Nchariheke maashi mmiapuni mmo.” Ni ayo nkayaacharihacha maashi mpaka nchulhu tetetete. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu nkeerelhacha akarumiya, “Vano nrikeke ni waarwehelha nankawa.” Nkayaarika ni waarwehelha nankawa, ");
INSERT INTO mgh2016_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","maashi yaathathuwilhe vano ukhalha idivai, ni ayo nkayaalhawiha. Nansho khayaachuwenlhe wiira ikhumme uyi. Nansho akarumiya alhe yaari achuwelhaka ukhumelhenlhe aya. Nankawa nkeehana abwana arusi, ");
INSERT INTO mgh2016_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nkoolhumacha eerelhaka, “Attu onkhaye ampachera thoko ukawa idivai yo uchiva, yamalhaka phi nokawa aya idivai yooririya. Nansho inyuva nhoshunga idivai yo uchiva mpaka nna!” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu aapannge yeyo yo ushangiha yo uchokholha iyo Ukaana ilhapo yo Ugalilaya, wowo nkooniha nthimicho wawe, ni owiittucha awe nkayanrumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Arusi amalheke, Yesu ni anumwanawe vamoka ni ashihimawe ni owiittucha awe, nkayaarwaa Ukapenaumu ni ukhalha wowo wo mahuku vakani. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Isikuukuu yo Pasaka ya Ayahudi yaari inaatamenrie, paahi etu Yesu nkarwaa Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wowo, u Inupa ya Nlhuku nkaaphwanya attu athumihaka ing'ope, ikhondoro, ni ikhunda, ni attu o wakakaniha nchurukhu anari anakhanlhanche mmamezani mwaya aakakhanihaka nchurukhu. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nkaakorosha ikopo yo nttondoro, nkoomolhacha ashinama onkhaye vathe, ikhondoro vamoka ni ing'ope, nkaapitikulhacha imeza chaya, ni umwarushacha nchurukhu u Inupa ya Nlhuku mmo, ");
INSERT INTO mgh2016_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","nkeerelha alhe aathumiha ikhunda alhe wiira, “Nthamihache chilha chittu chilha vaa! Nhipange inupa ya Athumwanaka ukhalha nipuro no upangelha maronda!” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Owiittucha awe nkoopuwelha iholhepiya nhina Malhove Matakatifu wiira, “Uttuna waka inupa inyu Apwiiya Nlhuku unokiiva, ukipahaka thoko mooro.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aholhelhi a Ayahudi nkayaamwakhulha Yesu wo unkoha, “Nnaapangeke cho ushangiha chaani wooniha wiira nhanaa ikuru yo upangacha yoyo mwaha uyo?” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu nkaakhulha, “Nkaphomolhani ilha inupa ya Nlhuku ilha, ni mii kinotheka tho wo mahuku mararu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Vavawo Ayahudi nkayeera, “Ilha inupa ya Nlhuku ilha, yaathekiye wo umalhaka iyaakha makhumi ncheshe ni sita, chani, inyuva nnottuna utheka chani wo mahuku mararu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nansho inupa yaarerihelha awe Yesu yaari iruttu awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Paahi etu vaahihimushiye awe ukhuma nnookhwani, owiittucha awe ahoopuwelha wiira aholhohera yayo, nkayaarumelhelha Malhove Matakatifu, yaahimianche awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu vaari awe Uyerusalemu wo isikuukuu yo Pasaka, attu enchi yahorumelhelha nchina nawe yooneke cho ushangiha cheera awe wo uhimiechesha. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nansho Yesu khaari ni nrima ni ayo ukhalhawaya ahaachuwelhacha onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Khaarina nlhatu wo uhimiechesha uriyoothe, ukhalhawaya ahochuwelha rata chene chittu chonkhaye chiri munrimani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ahaawo nholhelhi mmoka Ayahudi, o mphingo wa Amafarisayo, eehaniya Nanikodemo. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nihuku nimoka Nanikodemo nkayaanrwelha Yesu uhiyu, ni umwiirelha, “Rabi, nihochuwelha wiira inyuva phi Owiittuchiha nrumiye ni Nlhuku. Khaawo ntu nooria upanga cho ushangiha chinopangacha inyu Nlhuku ahikhalheke vamoka ni uyo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu nkaakhulha, “Ikekheene kinouhimeriani, ntu khanooria woona Umwene wa Nlhuku ahiyarieke tho.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nanikodemo nkayaakoha, “Ntu nkumi noorieke chani ukelha munthunkwani mwa anumwanawe, ni uyariya wo nayelhi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu nkaakhulha, “Ikekheene kinouhimeriani, ntu ahiyarieke wo maashi ni wo Iphumu ya Nlhuku, ata veeriye chani khanooria ukelha Imwene ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ntu noyaria wo iruttu wa athumwanawe ni anumwanawe, nansho noyaria munnepani wo Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nhishange ukhalhawaya kihouhimeriani wiira ihophwanelhiya mwaattiva onkhaye vaa uyaria wo nayelhi. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iphioo inowuka ni ukelha unothanana aya, nnowiiwa vanowuka aya, nansho khannochuwelha unokhumelhelha aya mena unokelhelha aya. Phiri aya thoko ntu yarelhe wo Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nanikodemo nkayankoha Yesu, “Yoyo mwaha uyo unoorieke chani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu nkaakhulha, “Chani, inyuva ngati phi owiittuchiha attu o Uisraeli nhichuwelhe yoyo mwaha uyo? ");
INSERT INTO mgh2016_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ikekheene kinouhimeriani, hiyaano ninohimiacha ichuwenlhe ihu ni uhimiechesha yonne ihu, nansho mwaattiva khannorumelhelha nttenga wihu. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Akhalhaka kihouhimeriani mwaha wo velhaponi ni inyu khannokirumelhelha, nnorieke chani urumelhelha koohimeriakani mwaha wo wiirimu? ");
INSERT INTO mgh2016_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Khaawo ntu aapanche urwaa uchulhu wiirimu ahikhalhe Mwaana a Ntu, aakhuruwilhe ukhuma wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Thoko ashinna Musa vaatheshilhe aya nchulhu inwaa yo shaba vamwirini uthakoni ulhe, ni uyo Mwaana a Ntu nootheshiya nchulhu chiichammo, ");
INSERT INTO mgh2016_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","wiira kila ntu nonrumelhelha akhalhe ni ukumi wo uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nlhuku ahaattuna attu o velhaponi chinene, wo chiichammo etu, nkankhumiha Mwaana awe o yekha, riyoothe nonrumelhelha hipotere, nansho akhalhe ni ukumi wo uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nlhuku khaanrumme Mwaana awe velhaponi awe aahukumulha attu, nansho oopolhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Attu onkhaye anonrumelhelha Mwaana khanohukumulhiya, ahinonrumelhelha ahomalha uhukumulhiya, ukhalhawaya kharumelhenlhe nchina no Mwaana a Nlhuku o yekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ni ihukumu ene phi ilha, nthuko uhowa velhaponi, nansho attu anothanana ipiphi ahittunaka nthuko, ukhalhawaya chittu chinopangacha aya chiri cho uhilhoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Attu anopanga cho uhilhoka unowarusha nthuko ni ayo khanowa voonene, ukhalhawaya khanottuniha cho uhilhoka chaya chimwalhelhiye. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nansho anovarechesha ikeekhene anoowa unthukoni, mitheko chaya chiwe chooniya chipangiaka wo unthimicha Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yamalhekeru, Yesu nkarwaa ilhapo yo Uyudea vamoka ni owiittucha awe, nkakhalhana wowo vamoka, ni attu aawa nkaabatiiziya. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nayohana chiicho aari aabatiizaka attu Uainoni, iwani yaatameria Usalimu, ukhalhawaya wowo ahokhalha maashi menchi. Attu nkayanrweelha, ni ayo nkaabatiizacha. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yeyo ikatema iyo Nayohana aari ahinaya uttukiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Owiittucha akina a Nayohana nkayaakhulhana ni Nyahudi mmoka wo mwaha wo malhemalhelho o khucha ikatema yo unthimicha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Paahi etu, owiittucha ayo nkayaarwelha Nayohana ni weerelha, “Owiittuchiha, nnomuupuwelha yolhe ntu arina inyu vamoka ukhopelhelhe wo mwoolhoko wo Uyorodani ni inyuva nkamwanhimiechesha ulhe? Vano ni uyo nobatiiza, ni attu onkhaye anonrweelha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nayohana nkayaakhulha, “Ntu khanoria ukhalha ni ittu aahivahiyeke ni Nlhuku o wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ni inyu mwaashinene nnoworia uhimiechesha wiira kahohimia, ‘Miyaano kakihena Kuristo, nansho kirumiye wiira kinholhelhe!’ ");
INSERT INTO mgh2016_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A bibi arusi phi awaya abwana arusi, nansho anlhoko aya abwana arusi, aneemelha ni wiiwelhelha, anoshangarara chinene vaneewa aya abwana arusi yuulhumachaka. Phi chiicho ni mii ushangarara waka vanotimirihiya aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yoyo phi phwanenlhe athepe ukhalha ochuwania chinene, ni miyaano kiwukuwe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nowa ukhuma uchulhu phi mulhupalhe waapwaha onkhaye. Nokhuma velhaponi phi o ilhapo, olhumachaka mwaha wo velhaponi, nansho nowa ukhuma wiirimu phi mulhupalhe waapwaha onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yoyo yonne awe ni wiiwa ayo, phi o uhimiechesha, nansho khaawo ntu nottuna nttenga awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nansho ntu riyoothe nottuna nttenga awe nohimiechesha wiira Nlhuku phi nohimiechesha ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ulhe rumiye ni Nlhuku nohimiacha malhove a Nlhuku, ukhalhawaya Nlhuku nommaha yoyo ntu uyo Iphumu ya Nlhuku wo uhikhalha maphimelho. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Athithi anonttuna Mwaana ni ummaha ikuru chonkhaye mmathathani mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Attu anonrumelhelha Mwaana ahanaa ukumi wo uhimalha, attu ahinomwiiwelhelha Mwaana khanokhalha ni ukumi wo uhimalha, nansho anohalha muurushiyani mwa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Amafarisayo nkayeewa wiira Yesu nowaapatta owiittucha enchi ni wabatiiza waapwaha Nayohana. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu mwanene khambatinze ntu, nansho owiittucha awe phi abatiiza attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Paahi etu Yesu veewilhe awe mwaha wolhumachiya, nkaathama Uyudea nkaahokolhia Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Vaari awe munkwahani mmo, nkaavirelha iwani yo Usamariya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wowo Usamariya uwo nkaaphiya Usukari, iwani yaatamenrie imata i Nayakhobo yaavanhe aya anaya, Nayusufu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ilhushi i Nayakhobo yaari vavawo. Yeyo ikatema iyo yaari uthana variyari, ni Yesu aari noochelhe wo nkwaha, nkeettuwa vachereshere ilhushi. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nthiyana mmoka Nsamariya nkaawa urikani maashi, Yesu nkaamwiirelha, “Nkivahe maashi kiwurie.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yeyo ikatema iyo, owiittucha awe yaari anakelhanche umawani uuthumani yolhia. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nansho yoyo nthiyana uyo nkaamwiirelha Yesu, “Inyuva mwa Ayahudi, miyaano ki Nsamariya, nnooria chani ukivekelha mii maashi o wuria?” Olhumacha chiicho ukhalhawaya Ayahudi khayaari yaathanaka ni Asamariya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nkaakhulha, ikaari nchuwelhaka izawadi ya Nlhuku inothanana awe uuvahani, ni unchuwelha mpani nowiirelhani, “ ‘Nkivahe maashi kiurie’ mwaanonvekelha ni uyo anouvahani maashi anowiiha ukumi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yoyo nthiyana uyo nkeera, “Pwiiya, inyuva khanrina indowo yo urikelha maashi ni ilhushi ene inarekamme. Nnaapatteke vayi maashi ari ni ukumi? ");
INSERT INTO mgh2016_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Athumwanihu Nayakhobo ni achishaana aya ni mihuwo chaya yaawuriacha vava.” Chani etu woonaka nneepanga ukhalha olhupalhe waapwaha yayo Nayakhobo ayo? ");
INSERT INTO mgh2016_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu nkaakhulha, “Onkhaye anowuria alha maashi alha anowolhiya nttona tho, ");
INSERT INTO mgh2016_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nansho ntu nohalha uwuria maashi anohalha aka ummaha mii, khanowolhiya nttona tho. Wo ikekhiaye, maashi anohalha aka ummaha, anowa ukhalha nrapo ninothekhuma maashi anowiiha ukumi. Ukumi wo mahuku o uhimalha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yoyo nthiyana uyo nkeera, “Pwiiya, nkakivaheni yayo maashi ayo! Kihoone nttona tho, mena kihiwe tho uurikani maashi vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu nkeera, “Nrwee mweehane owannyu mwaawane vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nthiyana uyo nkaakhulha “Miyaano khakirina alhopwana,” Yesu nkeera, “Nhohimia ikekhiaye wiira khanrina alhopwana. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ukhalhawaya mwahothelhiya ni manyaalhopwana athanu, ni ayo nnaakhalhana inyu vano ayo kahena owaninyu. Vavawo nhohimia ikekhiaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nthiyana uyo nkaamwiirelha Yesu, “Pwiiya, kinoona wiira inyuva phi anamilhohi. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Manyaapwiiya ihu yanthimicha Nlhuku vachulhu ulha mwaako ulha, nansho mwaattiva Ayahudi va nnoniirelha wiira nipuro no nthimicha Nlhuku phi Uyerusalemu ulhe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu nkaamwiirelha, “Maanyi nkirumelhelheke etu, mahuku anowa vahinowa inyu waathimicha Athithi vachulhu ulha mwaako ulha, mena Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwaattiva Asamariya va nnonthimicha ulhe nhinonchuwelha inyu. Nansho hii Ayahudi va ninonchuwelha ninonthimicha ihu, ukhalhawaya woopolhiya unchokholhelha wa Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nansho mahuku anoowa ni ayo ahomalha uphiya, wo ikuru yo Iphumu ya Nlhuku, attu anowa waathimicha Athithi wo ikeekhene, ni waathimicha wo iphiro ye ikeekhene inothanana aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nlhuku phi Iphumu. Chiichammo etu, attu anonthimicha anthananiya anthimicheke wo Iphumu ya Nlhuku ni ikeekhene thoko chiri awe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nthiyana uyo nkaahimia, “Kihochuwelha wiira Kuristo Moopolhi noowa. Vanohalha awe uwa, nonichuwelhiha chittu chonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu nkaakhulha, “Mii kinoolhumacha ni inyuva va, phi Yoyo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yeyo ikatema iyo owiittucha awe Yesu nkayaahokolhiacha, nkayaashangacha chinene umwoona aarerihaka ni nthiyana. Nansho khaawo ntu ankonhe nthiyana ulhe, “Nnothananani?” Ama unkoha Yesu, “Nnaarerihani ni alha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Paahi etu nthiyana uyo nkaahiya mwaapu awe, nkaarwa umawani u waahimeriani attu, ");
INSERT INTO mgh2016_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nkawaani mmwe mwaamona ntu kihimenrie mwaha kipangilhe aka wonkhaye. Chani khinooria wiira yoyo phi Kuristo Moopolhi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Attu nkayaathamacha mmawani nkayaarwaa uumwonani Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yeyo ikatema iyo owiittucha awe yaari ampepechaka amwirelhaka, “Owiittuchiha, nlhieke yolhia!” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nansho Yesu nkeerelha, “Miyaano kihanaa yolhia nhinochuwelha inyu mwaattiva.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Owiittucha awe nkayaakohanacha ashineneru, “Chani hawo ntu ammwinhenre yolhia?” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu nkeerelhacha, “Yolhia yaangu iri phi uvara mitheko chaya alhe akirumme ni utimiriha chinothanana aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwaattiva nneera, ‘Chihohalha mieri micheshe, nlhaalha uphiye.’ Nansho miyaano kinouhimeriani wiira, mmweheke mmamatani chinre aya, cholhia chihaaya wo ukhunguriya! ");
INSERT INTO mgh2016_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ntu o ukhungura noolhiviya mahalha awe, athokoreriaka cholhia wo nlhatu no ukumi wo mahuku o uhimalha. Chiichammo etu ntu naalha ni ntu nokhungura anowa aashangarara vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wo yoyo nlhatu uyo etu nna nulhumo nna phi ikeekhene, ‘Mmoka phi naalha ni nkina nokhungura.’ ");
INSERT INTO mgh2016_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Miyaano kuurummeni wiira mwakhungure cholhia mmamatani mwahaalhimme inyu, akina phi alhimme, nansho mwaattiva nnopuha wo ntukutta naya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Attu enchi o Usamariya yahonrumelhelha Yesu wo malhove aahimiechesha awe yoyo nthiyana uyo wiira, “Hokihimeria mwaha wonkhaye waapanga aka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Attu o Usamariya nkayanrwelha Yesu, nkayanlhepelha wiira akhalhe vavawo. Nkaalhokelha wowo wo mahuku melhi. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Attu enchi akina nkayaarumelhelha nttenga wa Yesu, ");
INSERT INTO mgh2016_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","nkayerelha athiyana alhe wiira, “Vano hii ninorumelhelha kuhiwe wo nlhatu no malhove inyu. Nansho niheewa naashinene, ni uchuwelha wiira we ikeekhene yolha ntu ulha phi Moopolhi o ilhapo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Avireke mahuku melhi, Yesu nkaathama wowo, nkaarwa Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu aarwaa mwanene ukhalhawaya ahohimiechesha wiira, “Namilhohi khanothimichiya uwannyawe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aphiyeke Ugalilaya, attu yahompochera, ukhalhawaya ni ayo yaari Uyerusalemu uwo unlhiani Pasaka. Nkayoona chittu chonkhaye chaapanganche awe ikatema yo Pasaka iyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu nkaahokolhia tho Ukaana ilhapo yo Ugalilaya waathathunshe awe maashi ukhalha idivai. Wowo ahaawo nholhelhi mmoka upuwani u Naherode, aari ni mwaana mmirawo nreta iwani yo Ukapenaumu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yoyo veewilhe awe wiira Yesu howa Ugalilaya ukhuma Uyudea, nkanrwelha ni unlhepelha wiira anttukane Ukapernaumu anlhamihe mwaana awe mmirawo aari nreta chinene. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu nkaamwirelha, “Khaawo ntu nohalha urumelhelha aahoneke ithikineha ni cho ushangiha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yoyo nholhelhi uyo nkaakhulha, “Thithi, shontee, nngwee mwaana aka hinakhwa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu nkaamwirelha, “Nrweeke etu, mwaana inyu noolhama!” Yoyo ntu uyo nkaarumelhelha malhove a Yesu nkaarwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Vaari awe mphironi ahokolhiaka uwani, akarumiya awe nkayaawa ni unhimeria wiira, “Mwammirawo inyu nreta uyo holhama!” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nkaakoherera ikatema ureta vanhiilhe aya mwaana, ni ayo nkayaakhulha, “Nchana uthana, ureta phi nhiyalhe aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Paahi etu athumwane mwaana ayo nkayoopuwelha wiira, yaari yelhe ikatema yaahimiye ni Yesu ilhe venre awe, “Mwaana inyu noolhama.” Vavawo etu yayo vamoka ni alhoko aya onkhaye, nkayanrumelhelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ilha yaari yo ushangiha yo nayelhi yaapannge awe Yesu vaari awe akhumaka Uyudea alhukamaka Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Umalha wo yayo, Yesu nkaarwa Uyerusalemu wo isikuukuu ya Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wowo Uyerusalemu uwo vanaatameria nlhako uneehaniya Nlhako wo Khondoro nihawo nthapwi nineehaniya wo Iebraniya Betizata, nthotho mwaya nikhalhaka ni ipwaro nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Areta enchi yaari akhalhachaka mmapwaroni mmo, attu ohoona, oremara ni attu oririyacha iruttu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yayo areta ayo yaari awehereraka wiira nnepa wo wiirimu wa Athithi ukhuruwe uwa ututuwanyihani maashi. Nreta aaholhelha ukhelha munthapwini vanotutuwanyihiya aya maashi uyo, aholhama ikwerere iriyoothe yaarina awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Paahi ahaawo ntu mmoka vavawo awereiya ikwerere yo uririyacha iruttu iyaakha makhumi mararu ni nane. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ahomwoona yoyo ntu uyo narumpe vavawo, nkaachuwelha wiira hokhalha vavawo wo iyaakha chinchi, nkankoha, “Chani, nnoothanana ulhama?” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nreta uyo nkaakhulha, “Thithi, khakirina ntu o ukitumbucheriha munthapwini vanotutuwanihiya aya maashi, kila vanolhikacha aka ukelha mmaashini, ntu nkina nookiholhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu nkaamwiirelha ntu o uririyacha iruttu ulhe, “Wunkweke etu, ukusheke nttato nao nno weeteke, urweeke.” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wo uhipicha yoyo ntu uyo nkaalhama, nkaakusha nttato nawe, nkeeta. Nihuku naapangelhe aya yoyo mwaha uyo, naari Nihuku no Wiittuwa, ");
INSERT INTO mgh2016_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","wo chiichammo etu aholhelhi Ayahudi nkayaamwiirelha ntu aalhamihiye ulhe, “Lhelho Nihuku no Wiittuwa, Malhehero ihu anoochiichiha wiira khavanooria ukusha nttato ninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ntu ulhe nkaakhulha eeraka, “Yoyo ntu kilhaminhe uyo phi kiirenlhe, ‘Ukusheke nttato nao, weeteke, urweeke.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ni ayo nkayankoha, “Phi mpani o wirenlheni nkusheke ntatto ninyu mweeteke, nrweeke?” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nansho aalhamihiye uyo khanchuwenlhe Yesu, ukhalhawaya wo nlhatu no uchara attu chinene, Yesu ahomalha ummwia nyerere. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Miholho aya, Yesu nkamphwanya ntu anlhaminhe awe u Inupa ya Nlhuku ulhe, nkeera, “Nholhama vano, nhiwonye tho, nhiwe mwaapatta yo hilhoka chinene.” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yoyo ntu uyo nkaarwa wa aholhelhi a Ayahudi ni waahimeria wiira Yesu phi nlhaminhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Paahi etu Ayahudi nkayaachokholhacha umvenga Yesu, wo nlhatu no nlhamiha ntu Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu nkaakhulha eeraka, “Athumwanaka arii munthekoni, phi chiichammo ni mii kihophwanelhiya upanga mitheko.” ");
INSERT INTO mgh2016_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nenno nlhove nno etu, nkanaathepiha aholhelhi a Ayahudi waavia iphiro yo mwiiva Yesu, kuhena wo nlhatu nohithimicha Malhehero yo Nihuku no Wiittuwa. Nansho ukhalhawaya aahowulhumacha wiira Nlhuku phi Athumwanawe, ni wilhikaaniha ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu nkaakhulha Ayahudi eeraka, “Ikekheene kinouhimeriani, Mwaana khanooria upanga ittu mwanene, nopanga ilhe noona awe Athumwanawe apangaka. Inopanga aya Athumwanawe, Mwaana phi nopanga awe chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ukhalhawaya Athithi anonttuna Mwaana, ni umwooniha chittu chonkhaye chinopanga aya anene, amwoonihaka chittu chulhupalhe upwaha chii cho nlhamiha ntu chii, ni inyu nnowa ushanga chinene. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Thoko Athithi chinaahihimusha aya attu akhwilhe ni waavaha ukumi, phi chiichammo etu Mwaana ni uyo nowaavaha ukumi anaattuna awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Athithi khanonhukumulha ntu riyoothe. Mwaana phi vahiye ikuru yonkhaye yo waahukumulha attu, ");
INSERT INTO mgh2016_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yiireke wiira attu onkhaye anthimicheke Mwaana thoko chinaathimicha aya Athithi. Ntu hinonthimicha Mwaana khanaathimicha Athithi anrumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ikekhiaye kinouhimeriani, aneewa malhove aka ni waarumelhelha akirumme, anoopatta ukumi wo uhimalha. Yayo khanohukumulhiya, nansho ahomalha uvira nnookhwani ni ukelha mu ukumini mwo uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ikekhiaye kinouhimeriani, mahuku anowa, ni ayo ahomalha uwa, akhwilhe vanowa aya wiiwacha nlhove na Mwaana a Nlhuku, ni ayo anottuna wiiwa ayo anokhalha akumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Thoko Athithi chiri aya machokholhelho o ukumi, phi chiichammo etu chinvahe aya Mwaana ukhalha machokholhelho o ukumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tho ahommaha Mwaana ikuru yo uhukumulha, ukhalhawaya yoyo phi Mwaana a Ntu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nhuumiye uwanoni, mahuku anowa onkhaye ari mmahiyeni vanowa aya wiiwacha nlhove nawe ");
INSERT INTO mgh2016_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ni uhihimmwa mmahiyeni. Alhe apangilhe chorera anohihimmwa ni ukhalha akumi, ni alhe aapannge cho uhilhoka anowa uhihimmwa ni uhukumulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Miyaano khakinooria upanga ittu wo ikuru aka kimwanene, Kinohukumulha thoko chineeraka wo uhimeriya ni Athithi, ni iyo ihukumu aka phi yo ikekhiaye, ukhalhawaya akinolhikacha upanga ittu kinothanana aka, nansho chinothanana aya akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Keehimiecheshaka mii kimwanene, uhimiechesha waka khunooria urumelhelhiya wiira we ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nansho hawo nkina nokihimiechesha mii, ni miyaano kihochuwelha wiira chonkhaye chinohimia awe akiromolhaka phi ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwahaaruma attu urweeha nttenga wo ukikoherera u Nayohana, ni ayo ahohimiechesha ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Uhimiechesha wa attu kuhii unokhulhuvelha aka, nansho kinohimiacha alha malhove alha wiira mwoopolhiye. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nayohana yaari thoko nthuko waamwalhelha nkwee, ni inyu mwaatti wo mahuku vakani nkamwaattapelhelha yoyo nthuko uyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nansho miyaano kihanaa malhove kinohimiechesha aka arii molhupalhe upwaha malhove a Nayohana. Ukhalhawaya mitheko kinopanga aka, phi mitheko akivanhe aya Athithi wiira kipange, ni chechiyo phi nokihimiechesha wiira Athithi phi kirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni ayo Athithi akirumme, phi nokihimiechesha. Mwaattiva khannapacha wiiwa nlhove naya, mena woona ikhove aya, ");
INSERT INTO mgh2016_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ni inyu khannarumelhelha nlhove naya munrimani mwinyu, ukhalhawaya nhokhota unrumelhelha nrumme aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwaattiva nnooshoma Malhove Matakatifu mwaanyiheraka wiira mwommo, nnoophwanya ukumi wo uhimalha. Nansho yayo Malhove ayo phi nokihimiechesha mii! ");
INSERT INTO mgh2016_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Inakhalhaka chiicho, mpaka nna mwaattiva khannottuna uwa uwannyaka mmwe mwaapatta ukumi uhinomalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nnikwa aka khurii upatta nthimicho unokhuma wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nansho kihoochuwelhani mwaatti wiira, unttuna Nlhuku khuuwo mu nrimani mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miyaano kiwiilhe wo ikuru ya Athithi, ni inyu khannakipochera, nansho attu akina yawaaka wo ikuru chaya ashinene, nnowaapochera. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwaattiva nnothanana upochera nthimicho winyu mwaashineneru, nhaaviaka upatta nthimicho ukhuma wa uyo ri vekha, Nlhuku, nnoorieke chani etu ukirumelhelha? ");
INSERT INTO mgh2016_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nhaanyihere wiira miyaano phi nowa kaahimiacha milhatu chinyu wa Athithi. Ashinna Musa, mweshenre inyu nikhulhuvelho ninyu, yayo phi nowa uhimiachani milhatu chinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yakaari mwahaarumelhelha ashinna Musa, mwaanokirumelhelha ni mii, ukhalhawaya ashinna Musa yaholhepa malhove anokaacha mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","“Nansho yakhalhaka wiira khamwaarumelhenlhe Malhehero yaalhepiye ni ashinna Musa, nnoorieke chani urumelhelha malhove aka?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Umalhawaya, Yesu nkaalhapuwa nttiya no Ugalilaya ama nttiya no Utiberiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nlhoko mulhupalhe wa attu nkawanttwara, nlhatu no woona cho ushangiha chaari awe apangaka ni waalhamiha areta. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu nkaawelha umwaakoni, nkaakhalha vamoka ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Isikuukuu ya Ayahudi yo Pasaka yaari inaatamenrie. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu apathusheke miitho, nkoona nlhoko mulhupalhe wa attu ummweelhaka. Nkaakoha Nafilipo, “Ninaathumeke vayi yolhia yowaalhiha attu alha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu olhumanche chiicho wo waalhikacha Nafilipo, ukhalhawaya ahochuwelha mwanene chowiira. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nafilipo nkayaakhulha, “Ninathumaka mikatte cho idinari imia pilhi chirina ihu khachimmwanelha waalhiha inakhalhaka vakani alha attu enchi alha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Owiittucha awe mmoka, Naandorea, nhima aya Nasimoni Peturo, nkaamwiirelha, ");
INSERT INTO mgh2016_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hawo vaa mmirawo mmoka rina mikatte nthanu cho shayiri ni ihopa pilhi. Nansho khachinowanelha wa attu enchi thoko alha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu nkeera, “Mwaakalhiheke etu attu ayo vathi.” Manyashi aari menchi vavawo vakittu vawo. Paahi etu attu nkayaakhalha vathi, alhopwana vekha aya aphiyelhaka attu maelufu nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu nkaakusha mikatte chilhe, nkanthimicha Nlhuku, nkaakawelha attu yaakhalhanche. Ni ihopa chiyo nkeera chiicho, kila ntu nkaapatta chaathananne awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Attu vaawonne aya Yesu nkeerelha owiittucha awe, “Nrokottacheke mikatte chihanlhe chiyo chihipotere.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nkayaakhupacha mahalhahalha aahanlhe, nkayaachariha makaya khumi ni melhi. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Attu yooneke yeyo yo ushangiha yaapangilhe awe Yesu iyo, nkayeeracha, “Wo ikekhiaye yolha phi namilhohi aaphwanelhiye uwa velhaponi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu nkaachuwelha wiira attu yaari athananaka ummara umwene, nkaathama tho, nkaarwa umwaakoni vekha awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Waphiyeke uchechilho owiittucha awe nkayaakhuruwa urwaa unttiyani, ");
INSERT INTO mgh2016_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nkayaawelhacha nkalhavani, alhapuwaka urwaa Ukapenaumu. Ipiphi yaari inakenlhe, ni Yesu aari hinaapiyelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nttiya nkanaachokholha ututuwana nlhatu no iphioo yaawuka wo machiri. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Owiittucha vaaphilhe aya nkwaha wo maili nthanu ama sita, nkayaamoona Yesu eetaka vachulhu maashi, aatameriaka ikalhava, nkayoovacha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu nkeerelha, “Phi mii, nhoovache!” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nkayaathanana unkusha Yesu nkalhavani, ni ikalhava yaari inaphiilhe ukhopelhelhe nttiya waalhukama aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Waashelhe waya nlhoko wa attu yaahanlhe ukhopelhelhe nttiya nkawaachuwelha wiira ikalhava ikina yaahanlhe wowo. Ni ayo nkayoopuwelha wiira Yesu khaawenlhe nkalhavani vamoka ni owiittucha awe, owiittucha ayo yaarwachilhe vekha aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tho, ikalhava chikina ukhuma Utiberiya chahowa vavawo vakittu vawo attu vaalhilhie aya mikatte, Athithi vaamanlhe aya unthimicha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Attu ayo yachuwelheke wiira Yesu ni owiittucha awe khayariwo vavawo, nkayaawelhacha nkalhavani nkayaarwaa umwaaviani Ukapenaumu. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nkayamphwanya Yesu ukhopelhelhe nttiya nkayankoha, “Owiittuchiha, mwaawiilhe yaakhani vaa?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu nkaakhulha, “Ikekheene kinouhimeriani, khannokaavia wo nlhatu no woona yo ushangiha iyo, nansho ukhalhawaya mwaaholhia mikatte chilhe nkamwaawona. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nhichenjeukelhe yolhia inochukumana, nchenjeukelheke yolhia ihinochukumana yo ukumi wo uhimalha. Yoyo phi Mwaana a Ntu, ukhalhawaya Athithi, Nlhuku ahonthanlha ni unhimiechesha wiira noowa uvahani yeyo yolhia iyo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ni ayo nkayankohacha, “vano niireke chani etu, ni hii noorie upanga chinothanana awe Nlhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu nkaakhulha, “Ntheko unothanana awe Nlhuku wiira mpange, uri unrumelhelha ntu nrumilhe aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Vavawo nkayankoha, “Unohalha upanga yo ushangiha yaani noone nuurumelhelhe? Unohalha upangani? ");
INSERT INTO mgh2016_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ashulhupalhe ihu yaholhia yolhia yaakhumme wiirimu yeehaniya imana uuthakhoni ulhe, thoko Malhove Matakatifu vaneera aya wiira, ‘Ahaalhiha nkatte waakhumme wiirimu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu nkeera, “Ikekheene kinouhimeriani, ashinna Musa kahiwe ovanheni nkatte wo wiirimu, nansho Athumwanaka phi nouvahani mwaattiva nkatte we ikeekhene unokhuma wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ukhalhawaya nkatte wa Nlhuku nnovahiya inyu phi uyo nokhuruwa ukhuma wiirimu ni uwiiha ukumi wa attu o velhaponi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Paahi nkayaamwiirelha, “Thithi, nkanivaheni yoyo nkatte uyo mahuku onkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu nkeera, “Miyaano phi yolhia inouvahani ukumi. Nokiweelha khanowolhiya ithalha tho, nokirumelhelha khanowolhiya nttona tho. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vano etu, kahouhimeriani wiira nnookona nansho khannokirumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ntu riyoothe anokivaha aya Athithi nookiweelha, ni mii khakinonkhota ntu nokiweelha, ");
INSERT INTO mgh2016_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ukhalhawaya khakiwiilhe ukhuma wiirimu kiwe kaapanga chinothanana aka mii, nansho chinothanana aya Athithi akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni iyo anothanana aya akirumme iri wiira, kihinrihe hata mmoka akivanhe aya, nansho kiwe kanhihimusha ni ummaha ukumi wo uhimalha nihuku no umalha ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ittu inothanana aya Athithi phi ilha, attu onkhaye anomwona Mwaana ni unrumelhelha, akhalhe ni ukumi wo uhimalha. Ni mii kinowaahihimusha nihuku no umalha ilhapo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ayahudi nkayaarushiya, nlhatu Yesu aahowiira, “Miyaano phi nkatte ukhuruwilhe ukhuma wiirimu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nkayeeracha, “Ana ulha ntu ulha kahiwe Yesu, mwaana a Nayusufu? Nihaachuwelha athumwanawe ni anumwanawe. Chani, vano, neera wiira khuruwilhe ukhuma wiirimu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu nkaakhulha, “Nkahiyani uchukulha mwaashineneru. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Khaawo ntu nowa uwannyaka aahiwihiyeke ni Athithi akirumme mii, ni mii kinonhihimusha nihuku no umalha ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Anamilhohi aholhepa wiira, ‘Kila ntu nowiittuchihiya ni Nlhuku.’ Kila ntu neewelhelha Athithi, ni wiittucha uwannyaya yoyo nowa uwannyaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kineera wiira, khaawo ntu riyoothe panche woona Athithi, yoyo khumme wa Nlhuku uyo vekha awe phi onne Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kinouhimeriani ikekhiaye wiira, ntu norumelhelha, yoyo hanaa ukumi wo mahuku o uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mii phi nkatte ummwiha ukumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Manyaapwiiya inyu aholhia imana uthakoni, nansho yahokhwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nansho nkatte unowa ukhuma wiirimu phi nolhikaana wiira ntu riyoothe nolhia khanokhwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mii phi nkatte wo ukumi unowa ukhuma wiirimu. Ntu alhiaka yolha nkatte ulha yoyo khanokhwa, nookhalha nkumi mahuku o uhimalha. Ni uyo ukhalhaka iruttu aka, kinokumiha aka wiira ilhapo ihimalhe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yoyo mwaha uyo nkawaawiha waakhulhaniya mwa Ayahudi ashineneru. Waari ukohaniyaka, “Noorieke chani ulha ntu ulha univaha iruttu awe nilhie?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu nkeerelha, “Ikekheene kinouhimeriani, mwaahilhieke iruttu ya Mwaana a Ntu ni uwuria iphome awe, khannopatta ukumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Onkhaye anolhia iruttu aka ni uwuria iphome aka ahana ukumi wo mahuku o uhimalha, ni mii kinowa kaahihimusha muukumini nihuku noomalha ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yakhalhaka wiira iruttu aka phi yolhia ye ikeekhene, ni iphome aka etu phi yo wuria ye ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Attu onkhaye anolhia iruttu aka ni uwuria iphome aka anookhalha nhina mwaka, ni mii kinookhalha nhina mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Athithi ari akumi ahokiruma mii, ni mii kinokhalha wo nlhatu waya. Wo yoyo nlhatu uyo etu, ntu nokilhia mii noolhama wo nlhatu naka mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Vano etu, nkatte unkhuma wiirimu, khunolhikaana ni nkatte waalhilhie aya manyaapwiiya inyu uthakoni. Aholhia nkaakhwa, nansho anolhia ulha nkatte ulha khanokhwa anookhalha akumi mahuku no uhimalha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu olhumanche yayo vaari awe eettuchihaka mu inupa yo unlhapelha Nlhuku Ukapenaumu. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Owiittucha awe enchi veewilhe aya nkayeera, “Alha meettuchiho alha arii orikarika chinene. Apani anohalha wiiwelhelha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu nkaachuwelha ichuku cha owiittucha wo uhihimeriya ni ntu, paahi etu nkeera, “Chani nhokelhiya nipampa? ");
INSERT INTO mgh2016_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Inottuna ukhalha chani etu vanowa inyu umoona Mwaana a Ntu arwaaka nchulhu waari awe? ");
INSERT INTO mgh2016_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nnepa wa Nlhuku phi nowiiha ukumi, ikuru cha ntu chihikhalhaka ittu. Malhove kuulhumachilhe aka phi nommwiiha Iphumu ya Nlhuku nowiiha ukumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Inakhalhaka chiicho ahawo akina inyu ahinokirumelhelha.” Yesu oolhumacha chiicho ukhalhawaya ahaachuwelha ahinonrumelhelha ni ntu nohalha unthumiha. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nkoncherera eeraka, “Yolha phi nlhatu no uhimeriani wiira khaawo ntu nohalha uwa uwannyaka aahorihiyeke ni Athithi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wo yoyo nlhatu uyo etu, owiittucha enchi anttwarattwara Yesu, nkayaarukunuwa utulhi ni uhinttwara tho. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Paahi etu Yesu nkaakoha owiittucha awe khumi ni elhi alhe eeraka, “Ni inyu mwaatti, chani khannokittwara?” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nasimoni Peturo nkayaakhulha, “Thithi, nirweeke wa apani tho? Inyuva phi ri ni malhove o univaha ukumi wo mahuku o uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ni hii vano nihorumelhelha ni uchuwelha wiira, inyu phi ntakatifu rumiye ni Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu nkaakhulha, “Kahoothanlhani mwaatti khumi ni elhi, ngati? Nansho mmoka inyu, yoyo nakare!” ");
INSERT INTO mgh2016_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Vavawo aari amwaachaka Yuda, mwaana a Nasimoni Isikariote, ukhalhawaya Yuda phi akelha unthumiha, inakhalhaka aari mmoka aya owiittucha khumi ni elhi alhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Umalhawaya yayo, Yesu aari munkwahani alhukamaka Ugalilaya, khaathananne weetakacha ilhapo yo Uyudea ukhalhawaya aholhelhi Ayahudi yaari athananaka umwiiva. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nihuku no Isikuukuu ya Ayahudi yo Marapatta naari ninaatamenrie, ");
INSERT INTO mgh2016_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu nkeerelhiya ni ashihima awe wiira, “Nthameke vaa nrweeke Uyudea, owiittucha inyu yooneke mitheko chinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ntu khanovitha chinopanga awe akhalhaka wiira nothanana uchuwania mwaattuni. Ukhalhawaya nnopanga cho ushangiha, mpangeke etu ilhapo yonkhaye ichuwelheke!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ata ashihima awe khayanrumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu nkeera, “Ikatema aka kinaphiya. Nansho mwaattiva va kila ikatema inouphwanelhani. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ilhapo khiinooria uuvengani mwaattiva, nansho miyaano inookivenga ukhalhawaya mii kinohimiechesha wiira mitheko chaya chiri cho uhilhoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mwaattiva nrweeke etu u sikuukuuni uwo. Miyaano khakinorwaa, ukhalhawaya ikatema aka yo ulhoka khinaphiya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nkoolhumacha yayo malhove ayo, nkaahalha Ugalilaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ashihima awe yamalheke urwaa u sikuukuuni, Yesu ni uyo nkaarwa, nansho khaarweelhe wo wiichooniha, aarweelhe wo wiivitha. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aholhelhi Ayahudi yaari amwaaviaka va sikuukuuni vawo, nkayaakoha, “Ri vayi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Malhove menchi o waapiya nkayeewiya mwaattuni. Attu akina nkayeera, “Ntu orera nrima.” Akina nkayeera, “Mena! Nowiiraka waathwelhelhiha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nansho khaawo ntu aalhikanche wulhumacha mwaha wawe voonene wo woova aholhelhi Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Isikuukuu yaari inaphiyenlhe variyari, Yesu vaarwelhe awe u Inupa ya Nlhuku ni uchokholha weettuchiha attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aholhelhi Ayahudi nkayaashanga chinene ni wiira, “Ulha ntu ulha pantte vayi irusho ni uyo khanashoma?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu nkaakhulha, “Meettuchiho kineettuchiha aka kahiwe awaka, nansho awawe Nlhuku kirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ntu nopanga chinothanana awe Nlhuku, noochuwelha wiira meettuchiho aka akhumme wa Nlhuku, ama miyaano kinoolhumacha wo ikuru aka kimwanene. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ntu noolhumacha wo ikuru awe mwanene naavia nthimicho wawe mwanene. Nansho naavia nthimicho wa ntu nrumme, yoyo ri o ikekhiaye, hinanaraka variwoothe. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Chani, ashinna Musa khayovanheni Malhehero? Nansho khaawo hata mmoka inyu novara Malhehero. Nlhatu waani nnothanana ukiiva?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Attu nkayaamwaakhulha, “Nrii ni nshoka no unanara inyu ayi! Apani anothanana uwiivani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu nkaakhulha, “Kahopanga yo ushangiha imoka, ni inyu onkhaye nkamwaashanga. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ashinna Musa yaholheherani weenelha achishaana inyu, inakhalhaka wiira ashinna Musa kahena aachokhonlhe, nansho manyaapwiiya inyu phi achokhonlhe. Alha mahuku, mwaattiva nnoomwinelha unyawo mwanhima nlhopwana hata Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yakhalhaka etu mwanhima nowiinelhiya unyawo hata Nihuku no Wiittuwa wiira Malhehero a ashinna Musa ihiwonyiye, woonaka nnokithunalhelha wo nlhatu no nlhamiha ntu Nihuku no Wiittuwa? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nhihukumulhe chittu wo vathe, nhukumulheke we ikekhiaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Attu akina o Uyerusalemu nkayeera, “Chani, ntu naaviya wiira eeviye ulhe kahena ulha? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mwooneke vano! Noolhumacha voonene, mena khaawo ntu nonvaanyiha! Chani, inowooria aholhelhi ahochuwelha ikeekhene wiira ulha phi Kuristo? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nansho Kuristo vanohalha awe uwa khaawo ntu nottuna uchuwelha vakittu vanowa awe ukhumelhelha. Nansho hiyaano nihochuwelha ukhumelhenlhe awe ulha ntu ulha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu vaari awe eettuchihaka u Inupa ya Nlhuku nkaakhuwelha eeraka, “Eti nnera wiira nnookichuwelha, ni uchuwelha ukhumme aka? Mii khakiwilhe wo ikuru aka kimwanene. Yayo akirumme miyaano ayo, phi o ikekhiaye. Mwaattiva khannaachuwelha, ");
INSERT INTO mgh2016_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nansho miyaano kinowaachuwelha ukhalhawaya kikhumme uwannyaya, ni ayo phi kirumme.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Attu nkayaalhikacha ummara ni unttuka, nansho khaawo ntu okonlhe moono ummara ukhalhawaya isaa awe yaari ihinaphiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Attu enchi munlhokoni mwa attu alhe yahonrumelhelha, nkayeera, “Chani, Kuristo awaaka noowa aapanga cho ushangiha chulhupalhe chinene uthepa chipangilhe awe ulha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amafarisayo nkayeewa attu yaapaka mwaha wa Yesu. Paahi amafarisayo vamoka ni opochera ishaani olhupalhe nkayaaruma manyaasikari ammare Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu nkeera, “Kinoolhokelha ni inyu wo mahuku vakani, yamalhaka kinoorwaa wo ayo akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nnookavia nansho khannokoona, ukhalhawaya mwaattiva khannooria uphiya wowo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aholhelhi Ayahudi nkayeerelhana ashineneru, “Ulha ntu ulha naarweeke vayi vahinooria ihu umpatta? Naarweeke wa Ayahudi awanenlhe ilhapo ya Ayunani, ni weettuchiha Ayunani? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iri ni maana ani vaneera awe, ‘Nnookaavia nansho khannokipatta, vanottuna aka ukhalha mwaattiva khannooria uphiya?’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nihuku noomalhelha yeyo isikuukuu iyo naari nihuku no yekha aya, Yesu nkeemelha ni wulhumacha wo nlhove nulhupalhe eeraka, “Ntu nowolhiya nttona aweeke uwannyaka, ");
INSERT INTO mgh2016_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ntu nokirumelhelha nowa aawuria. Thoko Malhove Matakatifu chinohimia aya, ‘Ntu nokirumelhelha mii, marapo o maashi anowiiha ukumi anothekhuma munrimani mwawe!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu olhumanche chiicho amwaachaka Iphumu ya Nlhuku, nottuna aya umpochera alhe attu anrumelhenlhe ayo. Yeyo ikatema iyo Iphumu ya Nlhuku aari hinawa ukhalhawaya Yesu aari hinaya upochera nthimicho wawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Attu akina mwaattuni mmo nkayaamwiwa olhumachaka yayo malhove ayo, nkayeera, “Wo ikekhiaye ulha ntu ulha phi Namilhohi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Akina aya nkayeera, “Ulha phi Kuristo Moopolhi!” Nansho akina tho nkayeera, “Kuristo Moopolhi khaanooria ukhuma Ugalilaya! ");
INSERT INTO mgh2016_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Malhove Matakatifu aneera wiira, Kuristo naakhumeke iyari ya Amwene Adaudi, ni uyaria Ubethelehemu, iwani yaakhalha aya Adaudi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Paahi mwaha wa Yesu nkawaamwalhaaniha attu. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Attu akina athananaka unttuka, nansho khaawo ammanre. ");
INSERT INTO mgh2016_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Manyaasikari yahokolhieke, nkayaakohiya ni opochera ishaani olhupalhe ni Amafarisayo, “Chani woonaka khannammanra ni ummwiiha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Manyaasikari nkayaakhulha, “Khaawo ntu o wooria wulhumacha thoko chinoolhumacha awe ulha ntu ulha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Amafarisayo nkayaakoha, “Chani, ni inyu mwaatti chiicho nhothepiya? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Chani ahawo anakhalhaka mmoka a aholhelhi a attu, ama mmoka a Amafarisayo anrumelhenlhe? ");
INSERT INTO mgh2016_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ulha nlhoko ulha khuchuwenlhe Malhehero a ashinna Musa, paahi etu uholhaviya ni Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mmoka a Amafarisayo aari Nanikodemo yanrweenlhe Yesu mahuku avinre alhe. Paahi, yayo nkayeerelha akhunanaya wiira, ");
INSERT INTO mgh2016_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wo ulhikaana ni Malhehero ihu khaninooria unhukumulha ntu nihinaaya umwiiwelhelha ni uchuwelha ttenkeni.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ni ayo nkayaamwakhulha, “Chani ni inyuva chiicho nnokhuma Ugalilaya? Nrweeke mwashomeke Malhove Matakatifu etu ni inyu nnokooshoma wiira, khaawo namilhohi nohalha ukhuma Ugalilaya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Paahi attu onkhaye nkayaahokolhiacha mmawannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kila ntu nkaahokolhia uwannyawe, nansho Yesu nkaarwa waari Mwaako wo Mizeituni. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wichishuru waashelhe waya nkaarwa tho u Inupa ya Nlhuku. Attu onkhaye nkayanrukureriacha, nkaakhalha ni uchokholha wettuchiha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Owiittuchiha Malhehero a ashinna Musa ni Amafarisayo nkayammwiiha nthiyana mmoka aaphwanyeriye mu ulhuvani, nkayaamwemesha variyari aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nkayaamwiirelha Yesu, “Owiittuchiha! Ulha nthiyana ulha hophwanyeriya alhuvaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Malhehero ihu ya ashinna Musa yahoniruma wiira nthiyana thoko ulha awonyeriye malhuku mpaka akhwe. Paahi etu inyuva nneera chani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","olhumacha chiicho wo unria, apatte nlhatu wo umwirelha wiira hotteka. Nansho Yesu nkooroma, nkaakheria vathi ni nikokho nawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yathepeke unkoha, Yesu nkennuwa nkeerelha, “Ntu riyoothe hinawonya munkwahani mwinyu, yoyo awonyeke nlhuku no upacha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nkooroma tho, nkaakheria tho vathi vattayani. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Veewilhe aya chiicho, nkayaachokholha uthama mmokammoka, aholhelhaka ashulhupalhe. Yesu nkaahiya yeekha awe ni athiyana alhe aahanlhe aneemenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu vennuwilhe awe nkaakoha athiyana ayo, “Ari vayi attu ayo? Khaawo hata mmoka hanlhe ohukumulheni?” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nthiyana uyo nkaakhulha, “Thithi, khaawo inakhalhaka mmoka!” Yesu nkeera, “Mena miyaano khakinoohukumulhani. Nrweeke, nansho nhiwonye tho.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu nkoolhumacha weerelha Amafarisayo tho. “Miyaano phi nthuko wo ilhapo, ntu nokittwara mii nookhalha ni nthuko wo ukumi, khaneeta mpiiphini.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amafarisayo nkayaamwirelha, “Inyuva nnehimiacha mwaanene, uhimiechesha winyu kuhiwe we ikekhiaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu nkaakhulha, “Anakhalhaka kineehimiechesha kimwanene, uhimiechesha waka urii we ikeekhene ukhalhawaya miyaano kihochuwelha ukhumme aka ni uwo unokelha aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwaattiva nnohukumulha wo irusho cha attu, nansho miyaano khakinonhukumulha ntu. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Uhukumulha waka, urii we ikeekhene ukhalhawaya miyaano khakirii vekha aka, Athithi akirumme arii vamoka ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iholhepiya nhina Malhehero inyu wiira uhimiechesha wa attu elhi weewananaka, inohimia aya phi ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miyaano kineehimiacha kimwanene, ni ayo Athithi akirumme, anookihimiechesha chiicho.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Vavawo nkayankoha, “Athumwaninyu ayo ari vayi?” Yesu nkaakhulha, “Mwaattiva khannokichuwelha mii mena khannaachuwelha Athumwanaka. Yakhalhaka mwaanokichuwelha mii, mwaanachuwelha ni Athumwanaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu olhumanche yayo malhove ayo u Inupa ya Nlhuku, nchuumbani mwo nikhupi no ushungiya nchurukhu vaari awe ettuchihaka. Mena khaawo ntu ammanre, ukhalhawaya isaa awe yaari ihinaphiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu nkeera tho, “Kinoorwaa, ni inyu nnookaavia, nansho nnookhwa mu uwonyani winyu. Unokelha aka mii, mwaattiva khannooria urwaa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aholhelhi Ayahudi nkayeera, “Chani, nowichiiva? Woonaka neera, ‘Unokelha aka mwaattiva khannooria uphiya?’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu nkaakhulha, “Mwaattiva nkhumme vava vathi vaa, miyaano kikhumme wiirimu uchulhu, mwaattiva o velhaponi va, miyaano kakihiwe o velhaponi va. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Phi nlhatu no uwirelhani wiira nnookhwa mu uwonyani winyu. Paahi wo ikekhiaye, mwaahirumelhelheke etu wiira ‘Miyaano phi Yoyo,’ nnookhwa mu uwonyani winyu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ni ayo nkayankoha, “Inyuva phi apani?” Yesu nkaakhulha, “Kihoohimeriani ukhuma khalhayi! ");
INSERT INTO mgh2016_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kihanaa menchi o wulhumacha ni uhukumulhani. Nansho akirumme mii ayo phi ikeekhene, ni mii kinohimiacha wa attu o velhaponi mwaha kiiwalhe aka uwannyaya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Khayachuwenlhe wiira Yesu olhumacha mwaha wa Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu nkeerelha, “Vanottuna inyu umwiinulha Mwaana a Ntu, vavawo nnowa mwaachuwelha wiira ‘Miyaano phi Yoyo,’ ni wiira khakinopanga iriyoothe miyaano kimwanene, nansho kinoolhumacha wo ikuru ivahiye ni Athithi wiira kuulhumache. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Akirumme arii vamoka ni mii mahuku onkhaye, yayo khanakihiya vekha ukhalhawaya chinopanga aka chinowateelhiha nrima.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Attu enchi yaamwiwilhe Yesu olhumachaka yahonrumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu nkeerelha Ayahudi anrumelhenlhe alhe wiira, “Mwarumelhelhaka meettuchiho aka, nnookhalha owiittucha aka we ikekhiaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Vavawo nnochuwelha ikekhiaye, ni iyo inouhiyererani.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ni ayo nkayaamwaakhulha, “Hiyaano phi iyari ya Aburahimu, nihipachaka ukhalha akavihi a ntu riyoothe. Wo nlhatu waani nneera, ‘Nnohiyereriya?’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu nkaakhulha, “Ikekheene kinouhimeriani, kila ntu nowonya phi ipotta yo uwonya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ipotta khirina ikuru yo lhokelha vawani, nansho mwaana hanaa ikuru yo ulhokelha mahuku onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mwaana ohiyererakani, nnohiyereriya wo ikekhiaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kihochuwelha wiira mwaattiva phi iyari ya Aburahimu. Nansho anakhalhaka chiicho, nnothanana ukiiva ukhalhawaya khannorumelhelha meettuchiho aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miyaano kinohimiacha chilhe chikoonihilhe aya Athithi, nansho mwaattiva nnopanga chilhe chihimeriye inyu ni athumwaninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ayo nkayaamwakhulha, “Athumwanihu phi Aburahimu.” Yesu nkaakhulha, “Thoko mwaattiva mwakaari ashaana a Aburahimu, mwampanga thoko chaapanga aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Miyaano kihoohimeriani ikeekhene ya Nlhuku, nansho anakhalhaka chiicho, mwaattiva nnothanana ukiiva. Aburahimu khayaapannge chiicho! ");
INSERT INTO mgh2016_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwaattiva nnopanga mwaha thoko yoolhe waapanga aya athumwaninyu.” Ayo nkayaamwirelha, “Hiyaano kanihiwe ashaana niyariye muulhuvani! Nihanaa Athithi amoka tu, Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu nkeera, “Ikaari wiira Nlhuku phi Athumwaninyu, mwaanokittuna miyaano, ukhalhawaya miyaano kikhumme wa Nlhuku ni vano kirii vaa. Khakiwilhe wo ikuru aka kimwanene, nansho yayo phi kirumilhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Woonaka khannochuwelha yayo malhove kinoolhumacha aka ayo? Ukhalhawaya khanneewelhelha nttenga aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwaattiva phi ashaana a Nakare, nttwarattwaraka nikakata na athumwaninyu. Toka machokholhelho yayo arii owiiva ahikhalhaka mu ikekhiani, ukhalhawaya ikeekhene khiiwo nhina mwaya. Kila vanolhumacha aya, aneera wo ulhikaana ni mayareelho aya, ukhalhawaya arii owoothacha ni anaangoro o woothacha wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nansho miyaano kinohimiacha ikeekhene, ukhalhaka phi nlhatu winyu wo uhikirumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mpani mmoka inyu nooria wooniha wiira kihowonya? Nansho yakhalhaka wiira kinoolhumacha aka iyo phi ikeekhene, woonaka khannokirumelhelha? ");
INSERT INTO mgh2016_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ntu a Nlhuku nowiiwelhelha malhove a Nlhuku. Nansho, mwaattiva, khanhiwe a Nlhuku, phi ri aya chiichammo etu khanneewelhelha malhove awe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayahudi nkayannyoholhacha Yesu yiiraka, “Chani, khavanlhoka vaneera ihu wiira inyuva mwa Asamariya, nri ni nshoka no unanara?” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu nkaakhulha, “Miyaano khakirina nshoka. Miyaano kinaathimicha Athumwanaka, nansho mwaattiva khannokithimicha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miyaano khakineechaviera nthimicho aka kimwanene. Nansho hawo naavia yoyo nthimicho uyo, ni uyo phi nohukumulha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ikekheene kinouhimeriani, ntu neewelhelha meettuchiho aka khanowa aakhwa nookhalha nkumi mahuku o uhimalha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayahudi nkayaamwakhulha, “Paahi etu nihochuwelha vano wiira nrini nshoka! Aburahimu yahokhwa, anamilhohi ni ayo yahokwa, ni inyu nneera eti, Neewelhelha meettuchiho inyu khanokhwa, nookhalha nkumi mahuku o uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Athumwanihu Aburahimu ahokhwa, chani woonaka inyuva nneepanga olhupalhe waapwaha Aburahimu? Anamilhohi ni ayo ahokhwacha. Ana inyuva nneechoona thoko apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu nkaakhulha, “Keethimichaka kimwanene, nthimicho aka kuhiwe ittu. Amoka anokithimicha mii phi Athumwanaka, aneera inyu mwaattiva wiira phi Nlhuku inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwaattiva khannaachuwelha. Nansho kikenre wiira khakinaachuwelha, kaanothacha thoko mwaattivava. Nansho kihaachuwelha ni uvara nlhove naya. ");
INSERT INTO mgh2016_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Athumwaninyu Aburahimu yahottapelhelha wiira anowoona nihuku naka no uwa, ni ayo yahoona, nkayaateelhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayahudi nkayankoha, “Inyuva khannaphiyelha iyaakha makhumi nthanu, ni inyu nneera wiira nhoona Aburahimu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu nkaakhulha, “Ikekheene kinouhimeriani, Aburahimu ahinayaria, ‘Miyaano kihawo.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vavawo nkayalhokottacha malhuku ammonyere, nansho Yesu nkaathama, nkaakhuma u Inupa ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu vaari awe eetakachaka, ahomwoona ntu mmoka ohoona toka iyareelho. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Owiittucha awe nkayankoha, “Owiittuchiha, phi apani awonyilhe, ulha ntu ulha, ama manyanaangoro awe, hata ayariee hoonaka?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu nkaakhulha, “U uhoona wu, khupangeelhe nlhatu no uwonya wawe, ama uwonya wa manyanaangoro awe. Aayarelhe hoonaka Nlhuku wiira awe ooniha ikuru awe chinopanga aya ntheko. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Uhinaya wiilha, nihothananiya uthepa uvara ntheko waya akirumme, uhiyu unoowa vahinooria awe ntu uvara ntheko. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Vanolhokelha aka velhaponi, miyaano phi nthuko wo ilhapo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Amalheke wulhumacha yayo malhove ayo, nkaashuwa ishenye vathi, nkoothuwa ipephe, nkanhika ntu ohoona ulhe mmiithoni, ");
INSERT INTO mgh2016_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","nkaamwirelha, “Urweeke wakhucheke u nttiya no Siloamu.” Maana o nenno nchina nno nikhalhaka “Rumiye”. Ntu ohoona ulhe nkaarwa, nkaakhucha, nkaahokolhia nari oonaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amwaatamana awe ni attu yaamwoona alhepelhaka, nkayeera, “Chani, ulha kahena ntu aakhalha ni ulhepelha ulhe?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Attu akina yeera, “Phi yoyo.” Nansho attu akhwawe nkayeera, “Mena kahena! Howiiraka ulhikaana ni uyo.” Nansho ntu ahoona ulhe nkeera, “Phi miyaano!” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nkayankohacha, “Miitho inyu ayo yenre chani wo uttukulhiya?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nkaakhulha, “Ntu neehaniya Yesu ulhe ahoothuwa ipephe, nkaakihika mmiithoni, ni ukiirelha, ‘Nrweeke mwakhucheke uri nttiya no Siloamu.’ Nkakaarwaa, vaari aka kikhuchaka, nkakaachokholha woona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nkayankoha, “Yoyo ntu uyo etu ri vayi?” Ni uyo nkaakhulha, “Akichuwenlhe mii.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yamalheke nkayanrweha ntu aari ohoona uyo wa Amafarisayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nenno nihuku Yesu voothuwa awe ipephe ni unttukulha miitho ntu uyo nno, naari Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Amafarisayo nkayankoha yoyo ntu uyo, enre chani wo woona. Ni uyo nkeera, “Ahookihika ipephe mmiithoni, Nkakaakhucha wiitho, ni mii vano kinowoona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amafarisayo akina nkayeera, “Ntu pannge chiicho khakhumme wa Nlhuku, ukhalhawaya khavarechenshe Malhehero o Nihuku no Wiittuwa.” Nansho akina nkayeera, “Ntu o uwonya nooria chani upanga cho ushangiha thoko chilha?” Nkawaakhulhanachiya iriyari aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nkayankoha tho ntu aari ohoona ulhe, “Ukhalhawaya yoyo hoottukulhani miitho, nnomwoona thoko mpani?” Ni uyo nkaakhulha, “Kinomwoona yoyo, phi namilhohi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Inakhalhaka chiicho, Aholhelhi a Ayahudi khayarumelhenlhe wiira yoyo ntu uyo aari ohoona khalhayi vawo nansho vano nowoona, mpaka veehanne aya manyanaangoro awe, ");
INSERT INTO mgh2016_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","nkayaakoha, “Chani ulha phi mwamwaninyu? Nneera inyu aayarelhe hoonaka, vano pantte vayi woona?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Manyanaangoro awe nkayaakhulha, “Eiyo ulha phi mwaamwanihu, aayarelhe hoonaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nansho khanichuwenlhe wiira enre chani wo woona, mena khanichuwenlhe ntu nttukunlhee miitho awe. Munkoheke mwanene, honnuwa, nowooria wulhumacha mwanene!” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Manyanaangoro awe ayo yoolhumanche chiicho ukhalhawaya yaari yoovaka aholhelhi Ayahudi, aalhehenre wiira ntu riyoothe nottuna urumelhelha eeraka wiira Yesu phi Kuristo oomolhiye nnupani mwo unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Phi nlhatu etu no manyanaangoro awe ayo wiira, “Honnuwa, munkoheke mwanene.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nkayaamwiihana nkwaha wo nayelhi ntu aari ohoona chiyareelho uyo, nkayaamwirelha, “Mummaheke Nlhuku nthimicho wiira nnohimia ikeekhene! Hiyaano nihochuwelha wiira ntu olhaminheni uyo rii o uwonya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Uyo nkaakhulha, “Akhalhaka o uwonya miyaano khakichuwenlhe. Nansho ittu imoka kinochuwelha aka, kaari ohona, ni vano kinowoona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nkayaathepa unkoha, “Opangenlheni chani? Ottukunlheni chani miitho inyu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nkaakhulha, “Kihomalha uhimeriani, ni inyu khamwiiwelhenlhe. Nlhatu waani vano nnothanana wiiwa tho? Chani mwaattiva nnothanana ukhalha owiittucha awe?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nansho ayo nkayannyoholhacha yiiraka, “Inyuva phi owiittucha awe, nansho hiyaano owiittucha a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Hiyaano nihochuwelha wiira Nlhuku aholhumana ashinna Musa, nansho ulha ntu ulha khanichuwenlhe khumme vayi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ni uyo nkaakhulha, “Vari vo ushangiha! Mwaattiva khanchuwenlhe khumme vayi, nansho mii hokittukulha miitho aka! ");
INSERT INTO mgh2016_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nihochuwelha wiira Nlhuku khaneewelhelha attu o uwonya, ila neewelhelha attu anonthimicha ni upanga chinothanana awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ukhuma vachokhonlhe aya ilhapo khiinewania wiira ntu honttukulha miitho ntu ayarelhe hoonaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yakhalhaka yoyo ntu uyo khakhumme wa Nlhuku, khanooria upanga ittu iriyoothe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nkayaamwaakhulha, “Inyuva mwaayarelhe ni ulhelhiya mu uwonyani, nnooria chani uniittuchiha hiyaano?” Nkayaamomolha nnupani mwo lhapelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu veewilhe awe yoyo mwaha uyo, nkaamwona ntu oomolhiye nnupani mwo ulhapelha uyo nkankoha, “Chani, inyuva nnonrumelhelha Mwaana a Ntu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yoyo ntu uyo nkaakhulha, “Thithi, nkihimerie yoyo phi mpani, kinrumelhelhe!” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu nkaamwirelha, “Nhomwoona, ni uyo phi noolhumacha ni inyu vano.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Paahi yoyo ntu uyo nkeera, “Thithi! Kinoorumelhelha.” Nkankhoromelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu nkeera, “Miyaano kiwilhe velhaponi uwaahukumulhani attu, ahinoona oone, ni ayo aneechona wiira anowoona akhalhe ohoona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amafarisayo akina yaari vavawo ni uyo nkayeewa yayo malhove ayo, nkayankoha, “Chani, nneera wiira ni hii nirii ohoona chiicho?” ");
INSERT INTO mgh2016_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu nkaakhulha, “Mwakaari ohoona, khamwakhalha ni milhatu cho utteka, nansho nneepanga wiira ‘Hiyaano ninowoona,’ ni iyo phi nooniha wiira bado nhowonya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu nkeera, “Ikekheene kinouhimeriani, ntu hinokelha wo uvira vanlhakoni ihilhi yo ikhondoro, apephenyaka ni uwelha wo iphiro ikina, yoyo ntu owiiya ni o uvara makhuche. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nansho nokelha wo uvira vanlhakoni, yoyo phi nshunga o ikhondoro. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nolhitelhelha ihilhi nonhulhelha nchelhe ni ikhondoro chinowiiwa nlhove nawe. Nowoopa nthuri wiihana ikhondoro chawe kila imoka wo nchina naya, ni uholhelha vathe. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chamalhaka ukhuma vathe, nooholhelha uholho, ni ikhondoro chinonttwara, ukhalhawaya chihonchuwelha nshunga aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ikhondoro khachinooria unttwara ntu hiri mwanene, chinonttawa ukhalhawaya khachichuwenlhe nthuri wawe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ahaahimeria nenno nlhikaaniho nno, nansho ayo khayachuwenlhe maana aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu nkeera tho, “Ikekheene kinouhimeriani, Miyaano phi nlhako wo ikhondoro. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Akina ayo, onkhaye aawilhe kihinaya mii, phi owiiya ni owaakha, ni ikhondoro khacheewelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miyaano phi nlhako. Ntu nokelha wo uvirelha uwannyaka nowoopolhiya, nookelha ni ukhuma, ni upatta malhiho. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Attu owiiya anowa wo nrima wo wiiya, wiiva ni utanganya. Miyaano kiwilhe wiira mwaatti mpatte ukhalha ni ukumi, ukumi wo utimira. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Miyaano phi nshunga orera nrima, nokumiha ukumi awe wo nlhatu no wiinanelha ikhondoro chawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Namitheko o ulhiviya, hirii nshunga, ni ikhondoro chihikhalhaka chawawe, vanoona awe mwiichi uwaaka, noohiya ikhondoro ni uttawa, mwiichi nkawaavara ikhondoro ni umwarushacha. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yoyo noottawa wo uhilhoha ittu, ukhalhawaya uyo rii namitheko o ulhiviya tu. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Miyaano phi nshunga orera nrima. Kinowaachuwelha arii awaka, ni ayo arii awaka anookichuwelha miyaano, ");
INSERT INTO mgh2016_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","thoko Athithi vanokichuwelha aya, ni mii chinaachuwelhaka Athithi. Miyaano kinookumiha ukumi aka wo nlhatu naya. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Chihawo tho ikhondoro chikina chawaka chihiri nhiilhini mu. Kihothananiya uwiiha ni chiyo, ni chiyo chinowiiwa nlhove naka, ni ukhalha mphingo mmoka ni nshunga mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Athithi anokittuna ukhalhawaya kinookumiha ukumi aka wiira kiwe kaapochera tho. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Khaawo ntu o ukithurulha ukumi aka, miyaano kinokumiha wo uttuna waka kimwanene. Kihanaa ikuru yo ukumiha ni yo ukusha tho. Chiichammo phi malheheriyo kirumme aya Athithi kipange.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Uhiiwanana nkawaakhumelhelha tho munlhokoni mwa Ayahudi wo nlhatu no yayo malhove ayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Attu enchi yaari yiiraka, “Ri ni nshoka no unanara. Ri ni ihalhahalha! Ye ishiyani umwiiwelhelha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nansho attu akina nkayeera, “Ntu o nshoka no unanara khanooria wulhumacha malhove thoko alha! Nshoka ninooria chani uttukulha miitho a attu ohona?” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yayo mahuku ayo waari nlhaalha wo uririya, ni nihuku no wuupuwelha uttukuriya Inupa ya Nlhuku naari nittapelhelhiyaka Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu aari eetakachaka u Inupa ya Nlhuku vaari nipirothi ni Naselemani. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayahudi nkayanrukureria ni unkoha, “Nnohalha unihiya nichukulhaka mpaka yaakhani? Nkanihimerieni ikeekhene, chani inyuva phi Kuristo Moopolhi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu nkaakhulha, “Kihoohimeriani, nansho khannorumelhelha. Mitheko chinopanga aka miyaano wo nchina na Athumwanaka phi nokihimiechesha, ");
INSERT INTO mgh2016_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","nansho mwaattiva khannorumelhelha, ukhalhawaya mwaattiva kanhena ikhondoro chaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikhondoro chaka chinowiiwa nlhove naka, ni mii kinochuwelhacha, ni chiyo chinokittwara. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miyaano kinowaavaha attu ukumi wo mahuku o uhimalha, ni ayo khanokhwa tho. Khaawo ntu nooria ukithurulha mmathathani mwaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Athumwanaka akivanhe chechiyo phi olhupalhe waapwaha onkhaye, khaawo nooria waathurulha Athithi mmathathani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Athithi ni Miyaano niri amokaaru.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayahudi nkayaalhokotta malhuku tho wiira amwaate. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu nkeera, “Kihopanga ntheko mwinchi kivahiye aka na Athithi mwoonaka, phi ntheko waani etu wo chechiyo unoopangani nkaate ni malhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayahudi nkayaamwaakhulha, “Khaninowaatani malhuku wo nlhatu no mitheko choombone, nansho wo nlhatu no unlhava Nlhuku! Ukhalhawaya nneepanga Nlhuku, uno nnari ntu thoko hii.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu nkaakhulha, “Chani, kilhepiye nhina Malhehero inyu wiira Nlhuku heera, ‘Miyaano kihohimia, mwaattiva milhuku?’ ");
INSERT INTO mgh2016_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nihochuwelha wiira chinohimiya ni Malhove Matakatifu chiri che ikeekhene mahuku onkhaye, Nlhuku eehanaka yayo attu ayo milhuku, attu arwehelhiye nttenga awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","“Thoko chiri aka mii, Athithi ahokithanlha ni ukiruma velhaponi. Veeshiyani etu, nneera wiira kihonlhava Nlhuku wo wiipanga Mwaana a Nlhuku? ");
INSERT INTO mgh2016_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nhikirumelhelheke etu, yakhalhaka wiira khakinopanga mitheko chilheheriyaka ni Athumwanaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nansho yakhalhaka kinoopanga, ata mwaahikirumelhelheke, mena etu nrumelhelheke mitheko chiyo, wo uchuwelha wiira Athithi anookhalha nhina mwaka, ni mii kinookhalha nhina mwa Athithi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nkayaamwiithelha wiira ammare tho Yesu, nansho nkaakulhupuwa mmathathani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu nkaahokolhia tho ukhopelhelhe mwoolhoko wo Yorodani, vakittu Nayohana vaari aya aabatiizaka attu, nkaakhalha wowo. ");
INSERT INTO mgh2016_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Attu enchi nkayanrwelha nkayeera, “Nayohana khayaapannge yo ushangiha iriyoothe. Nansho yoolhumanche aya Nayohana amwaachaka ulha ntu ulha onkhaye aari e ikeekhene.” ");
INSERT INTO mgh2016_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ni attu enchi vavawo nkayanrumelhelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ntu mmoka eehaniya Lazaro, nnenchi o Bethaniya, aari nreta. Ubethaniya waari ittoko yaakhalha aya Amariamu ni arokoraya Namatha. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Amariamu phi alhe yaahikilhe makhura o unukhelha Athithi mmietoni ni waapoholha ni ikharari chaya. Lazaro, mwanhima aya yayo phi ari nreta. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Paahi yayo manyarokorawe ayo nkayaarweha nttenga wa Yesu, “Thithi, ampwana inyu nnaattuna inyu areta.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu eeweke chiicho, nkeera, “Yoyo ureta uyo khunommwiiha nookhwa, nansho wo nlhatu no unthimicha Nlhuku. Anowereiya ikhalhe phi iphiro yo uthimichiya Mwaana a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ahaattuna Namatha, Amariamu arokoraya ni Nalazaro. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Veewilhe awe nttenga wiira Nalazaro areta, nkaalhokelha vavawo vaari awe vawo wo mahuku melhi tho. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yamalheke nkeerelha owiittucha awe, “Nirweeke nihokolhieke tho Uyudea!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Owiittucha nkayaamwaakhulha, “Owiittuchiha, mahuku vakani tu ahovira toka Ayahudi vaathanana aya uwaatani malhuku ni uwiivani, ni inyu nnothanana urwaa wowo tho?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu nkaakhulha, “Isaa cho uthana khachirii khumi ni pilhi? Paahi etu, ntu neeta uthana khanokwakwathuwa, ukhalhawaya nomwalheelhiya ni nthuko wo ilhapo. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nansho ntu eetaka uhiyu nookwakwathuwa, ukhalhawaya khuuwo nthuko velhaponi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu nkoolhumacha yayo malhove ayo, ni umalhiha eeraka, “Ampwana ihu Nalazaro ahorupa, nansho Miyaano kinokelha waawusha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Owiittucha awe nkayaamwiirelha, “Thithi, akhalhaka ahowiiraka urupa, paahi anolhama.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Owiittucha yaanyihera wiira ahowiiraka urupa nkhoveni, nansho Yesu aari ahimiaka wiira Nalazaro ahokhwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu nkaahimeria wo uhavitha, “Nalazaro ahokhwa, ");
INSERT INTO mgh2016_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","nansho kinootelhiya wo nlhatu ninyu wiira khakaariwo wowo, wiira nrumelhelhe. Paahi etu nngwee nirweeke uwannyaya uwo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Natomaso (eehaniya Nivata) nkayeerelha owiittucha ashikhunanaya wiira, “Nirweeke etu ni hii vamoka ni Owiittuchiha ihu, yakhalhaka ukhwa naakhwaneke vamoka!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu vaaphiilhe awe wowo, nkaaphwanya Nalazaro anamanlhe uvithiya nnihiyeni mahuku macheshe avinre. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ittoko yo Ubethaniya khayaari utayi ni Uyerusalemu, nkwaha wo umalhaka imaili taaru, ");
INSERT INTO mgh2016_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ni Ayahudi enchi yaari anawiilhe u Namatha ni Amariamu uunyikalhachani nookhwa a nhima aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Namatha veewilhe aya wiira Yesu aari awaaka, nkayaarwa uumwikamelhani, nansho Amariamu ahalhaka nnupani. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Namatha nkayaamwiirelha Yesu, “Thithi, mwakaari vaa, nhima aka kaakhwa! ");
INSERT INTO mgh2016_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nansho kihochuwelha wiira hata vano iriyoothe inottuna inyu unlhepelha Nlhuku, nouvahani.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu nkeera, “Mwanhima inyu noohihimmwa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Namatha nkayaakhulha, “Kihochuwelha wiira anoohihimmwa nihuku no uhihimushiya attu, nihuku no umalhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu nkeerelha, “Miyaano phi nihihimusho ni ukumi. Anokirumelhelha mii anokhalha akumi, anakhwaaka, ");
INSERT INTO mgh2016_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ni kila ntu ri nkumi nokirumelhelha, khanokhwa ngu nnokhalha nkumi mahuku o uhimalha. Chani, nnoorumelhelha yayo?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Namatha nkayaakhulha, “Eiyo Thithi! Miyaano kinoorumelhelha wiira inyuva phi Kuristo, Mwaana a Nlhuku, nowa velhaponi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Namatha yamalheke wulhumacha yayo, nkayaarwaa weehanani Amariamu, arokoraya, untemerani, nkayeera, “Owiittuchiha ahowa vaa, anowihanani.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ni ayo yeeweke chiicho, nkayonkwa phiyaru, nkayaamwiikamelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu aari hinaphiya vawani, nansho aari bado wowulhe Namatha waamwiikamenlhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Paahi etu Ayahudi yaakhanlhe mpaani yaavahaka nrima Amariamu, voonne aya yunkwaka ni ukhuma vathe wo uhipicha, nkayaattwara. Yaanyihera wiira anokelha unihiyeni uwunlhani. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Paahi Amariamu vaaphilhe aya vaari awe Yesu ni umwoona, ahokhoroma, nkayeera, “Thithi, thoko mwakaari vaa, nhima aka kaakhwa!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu ooneke Amariamu yunlhaka, ni Ayahudi yaawilhe vamoka ni ayo yunlhaka, nkaakelhiya ikiriri ni ihuzuni munrimani. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yamalheke nkaakoha, “Mwaavinthe vayi?” Nkayaamwakhulha, “Thithi mmweeke mwoona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu nkaamoriha miithori. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Paahi Ayahudi nkayeera, “Mwooneke chinre awe wo unttuna!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nansho attu akina aya nkayeera, “Ahaattukulha miitho attu ohoona, ngati? Chani khoonrie waachiichiha Nalazaro ahikhwe?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu aari onlhaka munrimani, nkaarwa unihiyeni, nihiye naari iphaa, ninakhuneelhiye nlhuku nulhupalhe vanlhakoni. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu nkeera, “Nithamihiye nlhuku nno!” Namatha, akhwelhiye ni mwanrokoraya Lazaro ayo, nkayeera, “Thithi, vanoonukha. Mahuku macheshe vano toka vavithiye aya!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu nkeerelha, “Chani, khakoohimenrieni wiira mwarumelhelhaka nnowoona nthimicho wa Nlhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nkayaathamiha nlhuku nne. Yesu nkaaweha nchulhu wiirimu, nkeera, “Kihopochera Thithi, ukhalhawaya inyuva nnookiwelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kihochuwelha wiira nnookiiwelhelha mahuku onkhaye, nansho kinoolhumacha yayo wo nlhatu na alha attu arii vaa alha, wiira arumelhelhe, wiira inyuva phi kirumme.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu amalhiheke wulhumacha yayo, nkeehana wo nlhove nulhupalhe eeraka, “Nalazaro! Nkhume vathe!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nalazaro nkayaakhuma vathe, uno anattukiye isaanda mmietoni ni mmiononi, wiitho unakhuneelhiye. Yesu nkeera, “Mwaathaphulheke, mwaahiyeke arweeke.” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Paahi Ayahudi enchi yawaachilhe wa Amariamu yooneke cheechiyo chaapannge awe Yesu, nkayanrumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nansho akina aya nkayaarwaa wa Amafarisayo uwaahimeriani mwaha waapannge awe Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wo chiichammo etu opochera ishaani olhupalhe ni Amafarisayo nkayaapanga ntemera wo Ibaraza yuulhupalhe, nkayeera, “Niireke chanii? Mwooneke chineera awe wo upanga cho ushangiha! ");
INSERT INTO mgh2016_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nanhiyaka, kila ntu nonrumelhelha, ni aholhelhi o Urumi anoowa uphomolha Inupa ya Nlhuku ni ukusha ilhapo ihu!” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amoka aya, yeehaniya Nakayafa, yaari opochera ishaani olhupalhe yeyo iyaakha iyo, nkeerelhacha, “Mwaattiva khannochuwelha ittu! ");
INSERT INTO mgh2016_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Chani, khannoona wiira nambaya ntu mmoka akhwe wo nlhatu ni attu, ilhapo yonkhaye ihirimeelhihiye?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yayo khayoolhumanche chiicho wo uttuna waya anene, nansho ukhalhawaya yaari opochera ishaani olhupalhe yeyo iyaakha iyo, yaholhohera wiira Yesu nookhwa wo nlhatu no ilhapo aya, ");
INSERT INTO mgh2016_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","mena kuhena wo nlhatu na Ayahudi vekha, nansho wo waawiha vamoka ashaana a Nlhuku amwareelhe velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ukhuma nenno nihuku nno etu, aholhelhi Ayahudi yahopanga miruku cho uthanana umwiiva Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wo chiichammo etu Yesu kheente tho voonene munlhokoni mwa Ayahudi, nansho nkaathama vavawo nkaarwa waatamenrie uthako, iwani ineehaniya Efuraimu. Nkaakhalha wowo vamoka ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nihuku na Ayahudi no Pasaka naari ninaatamenrie, ni attu enchi yahorwaa Uyerusalemu wiira ehapihe nihinaaya nihuku nno. ");
INSERT INTO mgh2016_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Attu nkayaahalha amwaaviaka Yesu, ni ayo vaathothokanne aya vamoka nnupani Inupa ya Nlhuku, nkayaakohanacha ashineneru, “Ninoona chani mwaatti? Inowooria wiira khanowa usikuukuni, ama noowa?” ");
INSERT INTO mgh2016_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Opochera ishaani olhupalhe ni Amafarisayo nkayaalhehera attu wiira ntu chuwenlhe vakittu vari awe Yesu arwee aahimiachere ni ayo yammare. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mahuku sita nihinaaya nihuku no Pasaka, Yesu ahorwaa Ubethaniya uwannyaya Nalazaro aahihimushiye ni Yesu ukhuma nnookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wowo ahoterekelhiya yolhia yo uchechilho, yaaterekhiye ni Namatha, Nalazaro ni ayo ahokhalha vamezani vamoka ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Paahi etu Amariamu nkayaawia ntikha ilita yo makhura o unukhelha chinene o uhithakanihiya aathumihiya wo nchurukhu mwinchi, nkayanhika makhura Yesu mmietoni ni umpoholha wo ikharari chaya. Nihiriri nkanaachara mpaani mwonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Isikariote, owiittucha mmoka aya khumi ni elhi, nohalha unthumiha Yesu, nkeera, ");
INSERT INTO mgh2016_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Wo nlhatu waani etu alha makhura alha uhithumihiya wo nchurukhu idinari imia taaru, ni uvahiya amashikini?” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","olhumanche chiicho, kuhena wiira anaachukulhelha amashikini, nansho ukhalhawaya aari ntu owiiya. Eiyaka munrupani mwo ushungelha nchurukhu weetana awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nansho Yesu nkeera, “Nhaahuvihe amanyi alha! Mwaahiyeke akeesheke tayari wo nihuku naka no uvithiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Amashikini nnowaakhalhana mahuku onkhaye, nansho khannokhalha ni mii wo mahuku onkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Attu enchi munlhokoni mwa Ayahudi nkayeewa wiira Yesu rii Ubethaniya, paahi etu, nkayaarwaa wowo, kuhiwe nansho wo nlhatu noomwona Yesu, nansho woona Nalazaro yaahihimushiye ni Yesu ukhuma nnookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Opochera ishaani olhupalhe nkayaapanga miruku cho weeva Nalazaro, ");
INSERT INTO mgh2016_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ukhalhawaya wo nlhatu naya Ayahudi enchi yahohiya weewelhelha, nkayanrumelhelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Waashelhe waya, milhoko chinchi cha attu chaawilhe usikuukuni chaheewa wiira Yesu aari mphironi uwa Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Paahi etu, nkayakushacha maritta o mitende, nkayaarwaa umwiikamelhani, akhuwelhaka eeraka, “Atotopelhiye Nlhuku! Athimichiye uyo nowa wo nchina na Athithi. Athimichiye Amwene o Uisraeli.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu nkaawiiheriya mwaaphuta mmoka, nkaawelha vachulhu vawe thoko chinohimiya aya ni Malhove Matakatifu, ");
INSERT INTO mgh2016_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nhoove iwani yo Sayuni! Mummweheke, Mwene inyu noowa, nammwenlhe mwaaphuta!” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Owiittucha awe yaari ahichuwelhaka yoyo mwaha uyo, nansho Yesu amalheke uthimichiya, phi opuwenlhe aya wiira Malhove Matakatifu yaholhepiya, amwaachaka wiira attu yahompangelha yayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Attu yaari vamoka ni Yesu nihuku yeehanne awe Nalazaro ukhuma nnihiyeni, aahihimushaka ukhuma nnookhwani, yahonhimiechesha. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nenno etu phi nlhatu no wiikamelhiya ni nlhoko mwinchi wa attu, ukhalhawaya yaheewa wiira Yesu ahopanga yeyo yo ushangiha iyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Paahi, Amafarisayo nkayeerelhana, “Nnowoona vano? Khaninooria upanga ittu iriyoothe! Mmweheke, ilhapo yonkhaye inonttwara!” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ahokhalha Ayunani mumphingoni mwa attu yaarwelhe Uyerusalemu uuthimichani nihuku no Pasaka nno. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nkayarwaa u Nafilipo, anenchi o Ubethsaida yo Galilaya, ni wiira, “Pwiiya, ninothanana umwoona Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nafilipo nkayaarwaa, nkayeerelha Naandorea, ni ayo oyelhi nkayaarwaa unhimeriani Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu nkeera, “Isaa yo uthimichiya Mwaana a Ntu ihophiya! ");
INSERT INTO mgh2016_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ikekheene kinouhimeriani, imbeyu yo marupi inohalha imbeyuru yaahimoreke vattayani ni ukhwa. Yakhwaaka, phi noyara aya marupi menchi. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Attu anottuna ukumi aya anoopoteriha, anovenga makhalhelho o ukumi wo velhaponi va, anoshungerera wo nlhatu wo ukumi wo mahuku o uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ntu nothanana ukikaviha ntheko, hothananiya ukittwara, ikhalhe wiira variyoothe variaka miyaano ni akarumiya aka anottuna ukhalha vavawo. Ntu nokikaviha, Athumwanaka anonvaha nthimicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Vano nnepa aka unoohuperia, ni mii kuulhumachekeni etu? Chani kiire, ‘Thithi, nkoopolhe ilha ikatema ilha ihikiphiyelhe?’ Nansho phi nlhatu wo uwa waka, wiira kivire ilha ikatema yo uweria ilha. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Thithi, nthimicheke vano nchina ninyu.” Vavawo nlhove nkaneewaniaa ukhuma wiirimu, “Kihothimicha, ni vavawo kinoothimicha tho.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Attu yaari aneemenlhe vavawo yaheewa nenno nlhove nno, ni attu akina aya nkaanyihera ithari nansho akina aya nkayolhumacha, “Nnepa wo wiirimu uholhumacha umuulhumana!” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nansho Yesu nkeerelha, “Nenno nlhove nno khaniiwanelhe wo nlhatu aka miyaano, ila wo nlhatu ninyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vanova phi ikatema yo uhukumulhiya ilhapo, vanova Nakare nholhelhi o ilhapo ilha noopikhulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ni mii kennulhiyaka vachulhu ilhapo kinommwiiha kila ntu uwannyaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wo wulhumacha chiicho ahooniha naakhweke nookhwa ani. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Paahi yoyo nlhoko uyo nkawaamwaakhulha, “Hiyaano ninoohimeriya ni Malhehero ihu wiira Kuristo khaawa aakhwa nookhalha nkumi mahuku o uhimalha. Nnooria chani etu wiira, Mwaana a Ntu nowiinulhiya? Yoyo Mwaana a Ntu uyo phi mpani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu nkaakhulha, “Nthuko bado urii ni inyu wo mahuku vakani. Mweeteke nnari ni yoyo nthuko uyo ipiphi ihuupatteni, ukhalhawaya aneeta mpiiphini khanochuwelha unokelha aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Paahi etu, ikatema nnari ni yoyo nthuko uyo nrumelhelheke nkhalhe attu o nthuko.” Amalheke wulhumacha yayo malhove ayo, Yesu nkaarwa vaari utayi ni ayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anakhalhaka Yesu ahopangacha cho ushangiha chonkhaye chiyo yoonaka, khayaanrumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chiichammo etu malhove yoolhumanche aya anamilhohi ashinna Isaya nkayatimira, “Thithi, apani arumelhenlhe nttenga ihu? Ni ikuru ya Athithi ichuwaneelhe wa apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chiicho khayoonrie urumelhelha, ukhalhawaya ashinna Isaya yahoolhumacha tho wiira, ");
INSERT INTO mgh2016_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nlhuku hotiyelhelha miitho aya ahoone, hophupuwalhiha mirima chaya, ahoone wo miitho aya, ahichuwelhe wo irusho chaya, mena ahikirukunuwelhe, aneera Athithi, wiira kaalhamihe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ashinna Isaya yoolhumanche yayo malhove ayo ukhalhawaya yahoona nthimicho wa Yesu, nkayaahimiacha mwaha wawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata chiicho, aholhelhi enchi Ayahudi yahonrumelhelha Yesu. Nansho wo nlhatu ni Amafarisayo, khayolhumanche mwaha wo unrumelhenlha Yesu voonene, yaari yoovaka wiira anowoomolhiya nnupani mwo unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yaathanana uthimichiya ni attu kuhiwe utotopelhiya ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yamalhekeru Yesu nkaawelhiha nlhove nkaahimia wiira, “Ntu nokirumelhelha, khanokirumelhelha mii tu, ila nowaarumelhelha ni ayo akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Attu anokoona miyaano anoowona akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miyaano kiwiilhe velhaponi kikhalhe nthuko, attu onkhaye anokirumelhelha ahihalhe mwiipiphini. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ntu neewa malhove aka nansho wo uhivarelhelha, miyaano khakinonhukumulha, ukhalhawaya khakiwilhe uhukumulhani ilhapo nansho woopolhani attu o velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Attu ahinovarelhelha malhove aka ahana ntu mmoka owahukumulha. Nlhove nuulhumachilhe aka phinottuna waahukumulha nihuku no umalhelha! ");
INSERT INTO mgh2016_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Miyaano khakuulhumanche wo ikuru aka kimwanene, Athithi akilhehenre malheheriyo ayo phi kivanhe yo wulhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ni mii kinoochuwelha wiira malhehero aya anoowiha ukumi wo uhimalha. Paahi etu, miyaano kinohimiacha Athithi akilheehenre aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nihuku nimoka Pasaka hinaphiya, Yesu ahochuwelha wiira isaa awe yo uthama velhaponi ni urwaa wa Athithi ihophiya. Ahaattuna chinene attu awe arii velhaponi, waattuna uhimmalha! ");
INSERT INTO mgh2016_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Paahi Yesu ni owiittucha awe yaari anakhanlhe ulhia yolhia yo uchechilho. Nakare ahomalha unkelha Yuda mwaana a Nasimoni Isikariote, ni ummaha nrima wo unthumiha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ahochuwelha wiira Athithi yahonvaha chittu chonkhaye mmathathani mwawe. Ni wiira aakhumme wa Nlhuku, ni vano nohokolhia wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Paahi ahothama vamezani nkeesha vathotho mwiinjiro awe, nkaakusha nchako nkeettuka nnyununi. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yamalheke nkaahelha maashi munkhatoni, nkaachokholha waakhuchiha owiittucha awe mieto ni upoholha wo nchako weettunke awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paahi nkaaphiyelha Nasimoni Peturo, nansho Napeturo nkayeera, “Thithi, inyuva nkikhuchihe mii mieto chaka?” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu nkaakhulha, “Khannochuwelha vano ittu kinopanga aka nansho nnochuwelha kaanyuma.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Napeturo nkayamwiirelha Yesu, “Inyuva khannokikhuchiha mieto mahuku onkhaye, ngu!” Yesu nkaakhulha, “Kaahukuchihekeni mieto chinyu khannokhalha owiittucha aka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nasimoni Peturo nkayaakhulha, “Thithi, nkikuchiheke, kuhiwena mietoru, nansho ni miono chaka ni muru ni uyo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu nkeerelha, “Ntu rampe khanothananiya ukhucha yaahikhalheke mieto, ukhalhawaya homalha iruttu awe yonkhaye ihorera. Mwaattiva nhohapihiya, nansho kanhiwe onkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ahonchuwelha ntu nottuna unthumiha, phi nlhatu no wiira, “Mwaattiva nhohapihiya, nansho kanhiwe onkhaye nri orera.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Amalheke waakhuchiha mieto ni uwara tho mwiinjiro awe, ahokhalha vamezani, nkeerelha, “Chani, nhochuwelha yayo kuupangenlheakani ayo? ");
INSERT INTO mgh2016_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mwaattiva nnokiihana Owiittuchiha ni Athithi, vavawo nhoolhumacha rata, ukhalhawaya phi mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Paahi yakhalhaka miyaano kirii Athithi ni Owiittuchiha inyu kihookhuchihani mwaattiva mieto, ni mwaattiva chiicho nkhuchihaneke mieto mwaashineneru. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kihoovahani malhikaaniho, ni inyu mpangelhaneke chiicho thoko chupangenlheakani. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kinouhimeriani wo ikekhiaye wiira, ipotta kirina ikuru yo umpwaha mwanene ntheko awe, mena akarumiya khanokhalha ni ikuru yulhupalhe waapwaha naaruma. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Paahi etu, yakhalhaka nnoochuwelha yayo, mwapangaka nnoopuha. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Alha kinolhumachaka alha khaanowaachani mwaattiva onkhaye. Miyaano kinowaachuwelha alhe kaathanlhalhe aka. Nansho ihophwanelhiya utimire wo Malhove Matakatifu aneera, ‘Ulhe lhilhie yolhia aka hokirukunuwelha kimwanene.’ ");
INSERT INTO mgh2016_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Miyaano kinouhimeriani ihinaya ukhumelhelha, vanottuna aya ukhumelhelha vawo mmwe mwaarumelhelha wiira ‘Miyaano Phi Yoyo.’ ");
INSERT INTO mgh2016_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ikekhiaye kinouhimeriani, nompochera ntu kinonruma aka nokipochera mii, ni ntu nokipochera mii, naapochera akirumilhe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu amalheke wulhumacha, ahokelhiya ihuzuni chinene munrimani, nkeera wo uhivitha, “We ikekhiaye kinohimiechesha wiira mmoka inyu nookithumiha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Owiittucha nkayawehana ashineneru, ashangaka chinene wo uhichuwelha wiira nohimiani. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Owiittucha mmoka, aattuniya ni Yesu chinene, ahokhalha wo umwaatameria Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nasimoni Peturo nkayanthoonyera ni umwiirelha, “Mwaakoheke anaacha apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Owiittucha uyo nkaachushera ni umwaatameria chinene Yesu, nkankoha, “Thithi, phi apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu nkaakhulha, “Ntu kinohalha aka ummaha nkatte kipamphe aka nnyiponi, phi yoyo.” Paahi, nkaakusha ikipande yo nkatte, nkaapapha nnyiponi, nkammaha Yuda mwaamwana a Nasimoni Isikariote. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda Isikariote amalheke upochera yeyo ikipande iyo, Nakare nkaakelha. Paahi Yesu nkaamwirelha, “Inothanana inyu upanga iyo pangakani wo uhipicha!” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nansho khaawo anakhalhaka ntu mmoka aya aakhanlhe va yolhiani aachuwenlhe wo nlhatu waani eerelhiya chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ukhalhawaya Yuda aari ntu o ushunga nrupa wo nchurukhu, owiittucha akina nkayaanyihera wiira Yesu aari anrumaka arwee athume chaathananiya wo nihuku no Pasaka, ama wiira arwee aavahe amashikini. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Paahi Yuda amalheke ukusha ikipande yo nkatte ilhe, nkaakhuma vathe wo uhipicha. Yeyo yaari uhiyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda athameke, Yesu nkeera, “Vano Mwaana a Ntu hothimichiya, ni uyo Nlhuku hothimichiya nhina mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Thoko nthimicho wa Nlhuku chipatakulhiye aya nhina Mwaana a Ntu, ni uyo Nlhuku nowooniha nthimicho wo Mwaana a Ntu nhina mwawe mwanene, ni upanga chiicho wo uhipicha. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Achishaana aka, khakinaya kirii ni inyu wo ikatema vakani tu. Nnookaavia, nansho vano kinouhimeriani alhe yaahimenrie aka aholhelhi Ayahudi, ‘Unokelha aka mii, mwaattiva khannooria urwaa!’ ");
INSERT INTO mgh2016_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kinouvahani malhehero o naanano, nttunaneke mwaashineneru, nttunaneke thoko chuuttunne akani mwaattiva. ");
INSERT INTO mgh2016_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mwattunanaka mwaashineneru, attu onkhaye anoochuwelha wiira mwaattiva phi owiittucha aka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nasimoni Peturo nkayaakoha, “Thithi nnokelha vayi?” Yesu nkaakhulha, “Unokelha aka khannooria ukittwara vano, nansho nnookittwara kaanyuma.” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Napeturo nkayaamwirelha, “Thithi, nlhatu waani kihoorie uuttwarani vanova? Kirii tayari ukumiha ukumi aka wo nlhatu winyu!” ");
INSERT INTO mgh2016_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu nkaakhulha, “Chani nrii tayari ukumiha ukumi inyu wo nlhatu waka? Ikekhiaye kinouhimeriani wiira, nthupi uhinaya wiipa nnowa mwaakikhota vararu mwiiraka khankichuwenlhe mii.” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu nkeerelha, “Nhichukulhe munrimani mwinyu. Munrumelhelheke Nlhuku, nkirumelhelheke ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Uwani wa Athumwanaka mapuro ari menchi, ihikaari chiicho, kanouhimeriani. Vano mii kinokelha ukoroshelhani nipuro. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Karwaaka ni ukoroshelhani nipuro, kinoohokolhia uwa ukushani uwannyaka, ni inyu nkhalhe variaka miyaano. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni inyu nhochuwelha iphiro yo urwaa wowo unokelha aka uwo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Natomaso nkayankoha, “Thithi, khaninchuwelha unokelha inyu, ninohalha uchuwelha chani etu, yeyo iphiro iyo?” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu nkaakhulha, “Miyaano phi iphiro, ikeekhene ni ukumi. Khaawo ntu nooria urwaa wa Athithi aahivireke uwannyaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yakhalhaka nhokichuwelha miyaano, nnowaachuwelha ni Athumwanaka chiicho. Ni toka vano, nnowaachuwelha, tho nhomalha woona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nafilipo nkayaamwiirelha, “Thithi, nnooniheke Athithi, ni hii inonithosha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu nkeerelha, “Kihokhalha ni inyu mahuku onkhaye alha, ni inyu Nafilipo bado khannakichuwelha? Akoonne mii ahoona Athithi. Nnooria chani etu wiira, ‘Nnoonihe Athithi?’ ");
INSERT INTO mgh2016_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Chani Nafilipo khannorumelhelha wiira miyaano kinokhalha nhina Athithi, ni ayo Athithi anokhalha nhina mwaka? Akinoolhumacha malhove wo ikuru aka, Athithi arii nhina mwaka phi nopanga mitheko chaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nhothananiya ukirumelhelha vaneera aka wiira miyaano kinokhalha nhina Athithi ni ayo Athithi anokhalha nhina mwaka. Ama etu, nrumelhelheke wo nlhatu no mitheko chinopanga aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ikekhiaye kinouhimeriani, anokirumelhelha mii anoopanga mitheko chinopanga aka miyaano, eiyo, anoopanga ata moolhupalhe chinene, ukhalhawaya kinokelha wa Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ittu iriyoothe inottuna inyu ulhepelha wo nchina naka kinoopanga, wiira nthimicho wa Athithi wooniye nhina mwawe Mwaana a Ntu. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mwakilhepelhaka ittu iriyoothe wo nchina naka, kinouvahani. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Mwakittunaka, nnoovara malhehero aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kinowaalhepelha Athithi wiira ammwiihe Okaviha nkina, nohalha ukhalha ni inyu mwaattiva wo mahuku o uhimalha. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yoyo phi Iphumu ya Nlhuku nohalha upatakulha ikeekhene ya Nlhuku. Attu o velhaponi khanowa ampochera ukhalhawaya khanowa aamwoona, mena unchuwelha. Nansho mwaattiva nnowa mwanchuwelha ukhalhawaya noowa aakhalha nhina mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Khakinoohiyani mwaattiva thoko ashaana ohiiya, kinoohokolhia tho uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ihohalha vakani attu o velhaponi khanowa yaakona tho. Nansho mwaattiva nnookona, ukhalhawaya miyaano kinkumi, ni inyuva chiicho nnookhalha akumi. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nenno nihuku nno vanohalha aya waaya nnoowa mwaachuwelha wiira miyaano kiri nhina mwa Athithi, ni inyuva nrii nhina mwaka, thoko ni mii kiriaka nhina mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ntu nopochera malhehero aka ni uvara, yoyo phi nokittuna. Ntu nokittuna miyaano noottuniya ni Athumwanaka, ni mii kinowaattuna ni wiichoniha uwannyaya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nayuda, kahiwe Isikariote ulhe, nkayaamwiirelha, “Thithi, vanoorieke chani inyuva wiichooniha uwanihu hii, kuhiwe wa attu o velhaponi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu nkaakhulha, “Ntu akittunaka, noovarelhelha malhove aka. Athumwanaka anonttuna, ni hii ninoowa neesha nipuro uwannyawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ntu hinokittuna khanovarelhelha malhove aka. Nlhove niiwilhe inyu nno kanihiwe nawaka, nansho na Athithi akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kihoohimeriani ulha mwaha ulha vano, kinari vamoka ni inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Okaviha, Iphumu ya Nlhuku, nottuna urumiya ni Athithi wo nchina naka uyo, noowittuchihani kila ittu ni uwupushani chittu chonkhaye chuuhimenrieakani. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mpuha phi nouhiyeraakani, kinouvahani mpuha aka. Akinoovahani thoko attu o velhaponi chineera aya. Nhikhelhiye nipampa munrimani, mena nhoove. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nheewa kuuhimeriakani, ‘Kinoorwaa, nansho kinoohokolhia tho uwaninyu.’ Yakaari mwahokittuna, mwanteelhiya woona wiira kinokelha wa Athithi, ukhalhawaya yayo phi olhupalhe ukipwaha mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kihoohimeriani malhove menchi ihinaya ukhumelhelha, vanohalha aya ukhumelhelha vawo mmwe mwaarumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Khakinoolhumacha ni inyu tho mwaha mulhupalhe, ukhalhawaya nholhelhi o velhaponi, Nakare ri muuwani. Nansho uwannyaka miyaano kharina machiri, ");
INSERT INTO mgh2016_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nansho attu o velhaponi anoothananiya uchuwelha wiira kinowaattuna Athithi, phi nlhatu noopanga kila ittu thoko Athithi chikilheherilhe aya. “Mweemelheke, nirweeke, nngwe nithame vaa. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Miyaano phi nzabibu we ikeekhene, ni Athumwanaka phi namalhima. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila nritta nhina mwaka nihinemma maphepu nenno ninoothamihiya, kila nritta ninemma rata ninookhwacheriya nithepeke wimma. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwaattiva nhokhalha orera wo nlhatu no meettuchiho kuwiittuchinheakani. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nkhalheke nnalhutaanne ni mii, ni mii kikhalhe nhina mwinyu. Nritta khaninooria wimma vekha aya, naahilhutaaneke ni ntepo naya. Phi chiichammo etu ni inyu mwaattiva khannooria wimma izabibu mwaahilhutaaneke ni mii nhina mwaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Miyaano phi ntepo no zabibu, ni inyu mwaatti phi maritta. Nolhutaana ni mii, ni mii kalhutaanaka nhina mwawe, yoyo nowimma maphepu menchi, ukhalhawaya ntu hinokhalha ni mii khanooria upanga ittu iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ntu riyoothe ahilhutaaneke ni mii noorihelhiya vathe thoko nritta ninorihiya aya vachereshere nkanooma. Maritta thoko yayo anookhupiya ni urihelhiya vamooroni avie. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mwakhalhaka nhina mwaka ni malhove aka akhalhaka nhina mwinyu, paahi etu, nlhepelheke ittu iriyoothe nnothanana inyu, nnoovahiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nthimicho wa Athithi unowoonia mwemmaka maphepu menchi, vavawo etu phi noohalha inyu ukhalha owiittucha aka. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kinottunani mwaattiva thoko Athithi chikittunne aya mii, nhalheke nchuwelhaka wiira kinouttunani. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mwavaraka malhehero aka nnookhalha mu uttunani mwaka, thoko ni mii chivanre aka malhehero a Athumwanaka ni ukhalha mu uttunani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kihoohimeriani ulha mwaha ulha ikhalhe wiira uteelhiya waka ukhalhe nhina mwinyu, ni uteelhiya winyu utimire. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Malhehero aka phi alha, nttunaneke mwaashineneru, nttunaneke thoko chuuttunne akani mwaattiva. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Khuuwo uttuna wulhupalhe chinene umpwaha uttuna wo ntu nokumiha ukumi awe wo nlhatu no manyampwana awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwaattiva nnookhalha manyampwana aka mwapangaka kinoolheherakani alha. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Khakinowiihanani tho mwaatti akarumiya, ukhalhawaya karumiya khanochuwelha chinopanga aya anene ntheko anonruma. Nansho miyaano kinowiihanani mwaattiva manyampwana, ukhalhawaya kihouhimeriani chonkhaye chiiwilhe aka wa Athumwanaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kanhiwe mwaatti mwaakithanlhe miyaano, mii phi othanlheni, nkakoorumani nrwee mwemme maphepu menchi, maphepu anolhokelha. Athithi awe yoovahani ittu iriyoothe inaalhepelha inyu wo nchina naka. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Paahi etu, malhehero aka uwaninyu phi alha, nttunaneke mwaashineneru. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ichimwa ya attu o velhaponi yoophwanyakani mwaattiva, muupuwelheke wiira yahokiphwanya miyaano ihinaaya uuphwanyani mwaatti. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yakaari wiira nri attu o velhaponi, ilhapo yaanottunani mwaattiva thoko attu aya. Mwaattiva kanhiwe attu o velhaponi, nansho miyaano kihouthanlhani velhaponi va, wo yoyo nlhatu uyo etu ilhapo inoupangelhani ichimwa. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muupuwelhacheke yohimenrieakani wiira, ‘Ipotta khachirina ikuru umpwaha mwanene ntheko naaruma.’ Yakhalhaka ahokihuviha miyaano, anouhuvihani ni mwaattiva chiicho, yakhalhaka ahovara nlhove naka, anoovara ni nlhove ninyu chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chechiyo chonkhaye chiyo anowa opangelhani mwaattiva wo nlhatu wo urumelhelha nchina naka, ukhalhawaya khayaachuwenlhe akirumme. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yakaari khakaawilhe ni wulhumacha, yayo khayaakhalha ni milhatu, nansho vano kharina nlhove no wiivaraanga wiira khanawonya. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","“Ntu nokipangelha ichimwa miyaano, nowaapangelha ichimwa ni Athumwanaka chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kihikaapannge uwannyaya mwaha uhinapacha upangiya ni ntu nkina khayaakhalha ni nlhatu wiira ahowonya. Nansho vano ahoona chipannge aka nkayaakipangelha ichimwa miyaano, nkayaapangelha ichimwa Athumwanaka chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Paahi etu, malhove arii nhina Malhehero aya, ahophiyelha, ‘Ahokipangelha ichimwa wo uhikhalha nlhatu!’ ");
INSERT INTO mgh2016_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Vanohalha awe uwa Okaviha kinohalha aka unruma uwaninyu uyo, Iphumu ya Nlhuku, nowa aapatakulha ikeekhene ya Nlhuku, yoyo noowa aahimiechesha ikeekhene inokaacha mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni inyu mwaattiva chiicho, nnoowa mwaakihimiechesha ukhalhawaya nri vamoka ni mii ukhuma vaachokhonlhe aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu nkeerelha tho “Kihouhimeriani yayo wiira nhihiye nrima nrina inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Attu anowoomolhani mwaattiva mmanupani mwaya mwo unlhapelha Nlhuku. Eiyo tho, mahuku anoowa, kila ntu nothanana uwiivani mwaattiva naanyihereke wiira nonkaviha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Attu anowa uupangelhani yoyo mwaha uyo ukhalhawaya khaachuwenlhe Athithi, mena khakichuwenlhe mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Paahi etu, kihoohimeriani yayo ikatema yo upangia waya yaphiyaka, mmwe mwoopuwelha wiira kahowaamukani. “Khakoohimenrieni ulha mwaha ulha toka khalhayi ukhalhawaya kaari vamoka ni inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nansho vano kinokelha wa ayo akirumme ayo, nansho khaawo inakhalhaka mmoka inyu nokikoha wiira nnokelha vayi. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ukhalhawaya vano kihouhimeriani yoyo mwaha uyo, ihuzuni ihoucharani mu nrimani mwinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kinouhimeriani ikeekhene wiira, ihorera nambaya miyaano kirwee, ukhalhawaya kaahirweeke, Okaviha uyo khanowa uwaninyu. Paahi etu, karwaakaru, kinonruma uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ni uyo vanottuna awe uwa, nowoopusha attu o velhaponi wiira irusho chaya chihowonya, ahottekelha ikekhia ni ihukumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ahowonya wo nlhatu wo hikirumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ahohiya mwaha wo uvara ikekhia, ni ukhalhawaya vano kinokelha wa Athithi, khannokoona tho. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ahotteka mwaha wo ihukumu ya Nlhuku, ukhalhawaya nholhelhi o velhaponi va, Nakare homalha uhukumulhiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kihanaa malhove menchi o uhimeriani, nansho vano, khannooria uvilhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Vanohalha aya uwa Iphumu ya upatakulha ikeekhene ya Nlhuku, nouchuwelhihani ikeekhene yonkhaye. Khanowa ahimiachaka wo ikuru awe mwanene, nansho noolhumacheke inohalha awe wiiwa ni uchuwelhihani chittu chinowa. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yoyo naakithimicheke mii, ukhalhawaya nowa uuchuwelhihani chinohalha awe wiiwa uwannyaka. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chittu chonkhaye chirina aya Athithi phi chawaka, phi nlhatu no uhimia wiira Iphumu ya Nlhuku nouchuwelhihani chinohalha aka ummaha ovaheni. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ihohalha ikatema vakani mwaatti khannokona, ni ikatema vakani inowa nnookona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Owiittucha awe akina nkayakohana ashineneru, “Ana nohimiani vanoniirelha awe, ‘Wo ikatema vakani khannokoona, ni ikatema vakani inowa nnookona?’ Tho neera, ‘Ukhalhawaya kinokelha wa Athithi!’ ");
INSERT INTO mgh2016_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Rina maana ani vaneera awe, ‘Wo ikatema vakani?’ Khanichuwenlhe inoolhumacha awe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ahochuwelha wiira yaathanana unkoha, paahi etu nkeerelha, “Chani, woonaka nnookohana mwaashineneru mwaha kuulhumanche aka wiira, ‘Wo ikatema vakani khannokoona, ni ikatema vakani inowa nnookona tho?’ ");
INSERT INTO mgh2016_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kinouhimeriani ikekhiaye, mwaattiva nnowunlha ni uwereiya munrimani, nansho ilhapo inootelhiya, nnookhalha ni ihuzuni nansho ihuzuni inyu inoorukunuwa ukhalha uteelhiya nrima. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ikatema opani ari munkurini vaneethaphulha aya anowoona uweria aya ukhalhawaya ikatema yo uweria ihophiya, nansho amalhaka wiithaphulha khaanoopuwelha tho uweria uwo nlhatu no uteelhiya wiira mwaana mwankani hoyaria velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chiichammo phi ri aya uwaninyu mwaatti, vano nri mu wuunlhani, nansho kinowa koowoonani tho, ni mirima chinyu chinowa uteelhiya, uteelhiya uhinooria uthamihiya ni ntu. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nenno nihuku nno nawaaka, khannowa mwaakilhepelha ittu iriyoothe. Ikekheene kinouhimeriani, iriyoothe inottuna inyu waalhepelha Athithi wo nchina naka, anouvahani. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mpaka nna khannavekelha ittu iriyoothe wo nchina naka. Nvekelheke nnoovahiya, ikhalhe wiira uteelhiya winyu utimire. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kihoohimeriani yayo wo malhikaaniho. Nansho ikatema inoowa vahinowa aka wulhumacha wo malhikaaniho, nansho kinowa wulhumacha mwaari wo uhivitha mwaha unaacha Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nenno nihuku nno nawaaka, nnowa mwaalhapelha Athithi wo nchina naka, kuuhimeriakani wiira akinowa kaalhepelha wo ulhepelhelhani mwaattiva, ");
INSERT INTO mgh2016_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ukhalhawaya Athithi anene anouttunani mwaattiva. Anouttunani ukhalhawaya mwaattiva nhokittuna mii ni urumelhelha wiira kikhumme wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Miyaano kaakhumme wa Athithi, nkakaawa velhaponi, uno vano kinoohiya ilhapo ni uhokolhia wa Athithi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Paahi owiittucha awe nkayaamwiirelha, “Eiyo, vano nnoolhumacha wo uhivitha, nhuulhumachaka wo malhikaaniho. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vano nihochuwelha wiira inyuva nnoochuwelha kila ittu, ihooriaka uukohani tho ittu iriyoothe. Yeyo phi nonirumelhelhilha wiira nkhumme wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu nkaakhulhacha, “Chani, nnoorumelhelha vano? ");
INSERT INTO mgh2016_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ikatema inoowa, ni iyo ihomalha uphiya, mwaattiva onkhaye vanottuna inyu umwariaa kila ntu uwannyawe, ni mii kinoohiiya yeekha aka. Nansho miyaano khakirii yekhaaka, ukhalhawaya Athithi arii vamoka ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kihoohimeriani ulha mwaha ulha wiira nkhalheke ni mpuha wo ulhutaana ni mii. Nnoowa mwaahuvihiya velhaponi, nansho mpisheke nrima! Miyaano kihokottolha ilhapo!” ");
INSERT INTO mgh2016_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu amalheke wulhumacha yayo, nkaaweha nchulhu wiirimu, nkeera, “Thithi, ikatema ihophiya! Munthimicheke Mwamwaninyu ni uyo Mwaana othimichekeni. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ukhalhawaya mwahonvaha Mwamwaninyu ikuru wa attu onkhaye, wiira aavahe ukumi wo uhimalha attu onkhaye munvanhe inyu ayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ni ukumi wo uhimalha unari wiira uuchuwelhani inyuva, nrii yeekha inyu Nlhuku e ikeekhene, ni unchuwelha Yesu Kuristo, munrumme inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Miyaano kihoothimichani velhaponi vaa, kihomalhiha ntheko ukivanhe inyu kipange. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Thithi! Nkivaheke nthimicho vano, nthimicho kaarina aka ilhapo ihinaaya wuupiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kihaachuwelhiha attu nchina ninyu, yayo nkivanhe inyu ukhuma velhaponi. Yaari attu awinyu, ni inyuva nkamwaakivaha. Ni ayo ahovara nlhove ninyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ahochuwelha vano wiira kila ittu ikivanhe inyu ikhumme uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Miyaano kihaavaha nttenga ukivanhe inyu, ni ayo ahopochera, ahochuwelha wiira wo ikekhiaye kikhumme uwaninyu, ni ayo anoorumelhelha wiira inyuva nhokiruma. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Kinaalhapelhelha yayo, mena khakinaalhepelhelha attu o velhaponi, nansho kinaalhepelhelha attu akivanhe inyu, ukhalhawaya phiri awinyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Attu onkhaye arina aka phi awinyu, ni awinyu phi awaka, ni nthimicho waka uhoonia wa attu akivanhe inyu. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Vano kinoowa uwaninyu, kakihiwe tho ntu o velhaponi, nansho ayo arii velhaponi. Athithi atakatifu! Wo machiri o nchina ninyu nikivanhe inyu, chonte mwaashunge rata akhalhe ittu imoka thoko hiyaano chiri ihu amoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Vaari aka ni ayo, miyaano kahaashunga rata wo machiri o nchina ninyu nikivahilhe inyu. Miyaano kiheenanelha, mena khaawo anakhalhaka mmoka aya kinrinhe aka, aahikhalhe ulhe ntu nohalha upotera, wiira Malhove Matakatifu atimire. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Paahi etu vano kinowa uwaninyu, ni mii kihoolhumacha ulha mwaha ulha velhaponi va, wiira attu yoorie ulhutaana ni mii muuteelhiyani waka. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Miyaano kihaavaha nttenga inyu, ni attu o velhaponi nkayaapangelha ichimwa, ukhalhawaya yayo kaahiwe amoka aya attu o velhaponi, thoko ni mii kihiri aka ntu o velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Khakinolhapelha wiira mwaathamihe velhaponi, nansho kinolhapelha wiira mwenanelhe ni Nakare. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ayo kaahiwe o velhaponi, thoko ni mii kihiri aka o velhaponi. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mwaathanlheke mwaanene wo ikeekhene, nlhove ninyu nikhalhaka phi ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Thoko chikirumme inyu velhaponi, ni mii chiicho kihaaruma ayo velhaponi, ");
INSERT INTO mgh2016_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ni wo yoyo nlhatu uyo, miyaano kimwanene kinowithanlha kikhalhe isadaka uwaninyu ni ayo chiicho eeshiye isadaka wo ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Khakinaalhapelhelha ayo vekha aya, nansho kinaalhepelhelha ni attu anohalha ukirumelhelha mii wo nlhatu no nttenga waya. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kinolhapelha wiira onkhaye akhalhe ittu imoka. Thithi, kinolhapelha wiira akhalhe nhina mwihu thoko inyuva chiri inyu nhina mwaka ni mii nhina mwinyu. Kinolhapelha wiira akhalhe ittu imoka, ilhapo iwe yaarumelhelha wiira inyuva mwaahokiruma. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Miyaano kihaavaha nthimicho yoolhe ukivanhe inyu, wiira akhalhe ittu imoka thoko ni hiyaano chiri ihu amoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ilha ikhalhe wiira miyaano kikhalhe nhina mwaya, ni inyu Thithi nkhalhe nhina mwaka. Kinolhapelha wiira akhalhe ittu imoka, ilhapo ichuwelhe wiira inyuva mwaahokiruma, ni wiira, nnowaattuna ni ayo thoko chikittunne inyu mii. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Thithi, kinothanana ayo akivanhe inyu ayo akhalhe vamoka ni mii varii aka, awe yoona nthimicho waka ukivanhe inyu. Ukhalhawaya mwahokittuna ilhapo ihinaya wuupiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Thithi orera nrima, attu o velhaponi khanoochuwelhani, nansho miyaano kinouchuwelhani. Alha ni ayo ahochuwelha wiira inyuva mwahokiruma. ");
INSERT INTO mgh2016_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kihaahimeria nchina ninyu, ni mii kinoothepa wiira chiicho, uttuna urina inyu uwannyaka uwe waakhalha nhina mwaya, ni mii kikhalhe nhina mwaya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu amalheke wulhumacha, nkaarwa ukhopelhelhe wo nshepa wo Keduroni, vamoka ni owiittucha awe. Vavawo vakittu vawo vaari ni imata yo miri cho mizeituni, Yesu nkaakelha mommo vamoka ni owiittucha awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda Isikariote, anthuminhe Yesu, ahochuwelha vaari aya, ukhalhawaya mikwaha chinchi Yesu aari akumaanaka ni owiittucha awe wowo. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Paahi etu, Yuda nkaarwa attukanaka mphingo wa manyaasikari ni attu olhitelhelha Inupa ya Nlhuku aarumiye ni Opochera ishaani olhupalhe ni Amafarisayo, nkaawana umatani uwo anaweelhe ikerero, ikhandiri, ni mithuko. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, aari achuwelhaka chonkhaye chinohalha umphwanya, nkaachusherera, nkaakoha, “Nnaavia apani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nkayaamwakhulha, “Yesu o Unazareti!” Yesu nkeerelha, “Phi miyaano.” Yuda, onthumiha Yesu aari neemenlhe vavawo vamoka ni ayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Paahi Yesu eereke, “Phi miyaano,” nkayaahokolhia utulhi, nkayaawulhuwa vathi. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu nkaakoha tho, “Nnaavia apani?” Nkayaamwakhulha, “Yesu o Unazareti!” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu nkeerelha “Kihomalha uhimeriani wiira miyaano phi uyo. Paahi etu, yakhalhaka nnokaavia mii, mwahiyacheke akina alha arwaacheke.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","olhumanche yayo wiira atimire malhove yeera “Attu aakivahilhe inyu Thithi khakinrinhe anakhalhaka mmoka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nasimoni Peturo, nkayaatholholha mwaalho mulhupalhe waarina aya, nkayanthikilha nnyaru no wiimonono namitheko a Opochera ishaani Olhupalhe. Karumiya uyo eehaniya Maliki. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu nkeerelha Napeturo, “Nhokolhoshe mwaalho inyu nnigonerani mwaya. Chani, nnothanana kihiwurerie ikikombe yo ntwarusho ikivahilhe aya Athithi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mphingo wa manyaasikari a Arumi ni mulhupalhe aya, ni akarumiya a Ayahudi, olhitelhelha Inupa ya Nlhuku nkayammara Yesu, nkayanttuka. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nkayanrweeha wa Anasi, aari ahokohi aya Nakayafa opochera ishaani olhupalhe o yeyo iyaakha iyo. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yayo Nakayafa ayo phi alhe olhumanche nlhove no weerelha Ayahudi wiira nambaya ntu mmoka akhwe wo nlhatu no attu enchi. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nasimoni Peturo vamoka ni owiittucha nkina yahonttwara Yesu. Yoyo owiittucha nkina uyo aari achuwelhiyaka ni Opochera ishaani Olhupalhe, paahi etu nkaakelha vamoka ni Yesu upuwani waya Opochera ishaani Olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nansho Napeturo yaari aneemenlhe vathe, vaatameria nlhako. Paahi etu, owiittucha nkina aachuwelhiya ni Opochera ishaani olhupalhe ayo, ahokhuma vathe nkanvekelha mwalhi namitheko o uhulha nlhako wiira aawiihe Napeturo mpaani. Nkaawiiha. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yoyo mwalhi namitheko o uhulha nlhako uyo nkaakoha Napeturo, “Chani, ni inyuva kanhiwe mmoka aya owiittucha awe ulha ntu ulha?” Napeturo nkayaamwaakhulha, “Akihiwe miyaano!” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Anamitheko ni manyaasikari yaari anaparihenlhe mooro wo makhalha ukhalhawaya yaari nlhaalha wo uririya, nkayaarukureria yoottaka mooro ashinene. Napeturo nkayaarwaa ni ayo yootte mooro. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Opochera ishaani Olhupalhe nkayankohakoha Yesu mwaha wo owiittucha awe ni meettuchiho awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu nkaamwakhulha, “Ikatema chonkhaye kaari kuulhumachaka ni attu voonene, meettuchiho aka kiituchihaka mu inupa cho unlhapelha Nlhuku ni wi Inupa yuulhupalhe ya Nlhuku, vakittu vanokumana aya Ayahudi onkhaye. Khakinapacha mena wiittuchiha iriyoothe wo uvitha. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nlhatu waani vano nnokikoha miyaano? Mwaakoheke alhe yeewilhe koolhumanche aka. Yayo phi chuwenlhe kaahimenrie aka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Amalheke wulhumacha yayo, namitheko olhita mmoka emenlhe vavawo nkaamwata nikofi Yesu eeraka, “Chani, nenno phi nlhove nowaakhulha Opochera ishaani Olhupalhe?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu nkaakhulha, “Yakhalhaka kuulhumanche pufia, nkahimiecheshani kittenke vayi, nansho yakhalhaka kihoolhumacha rata, woonaka nnookaata?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasi nkayanrweeha Yesu uno nattukiye, wa Opochera ishaani Olhupalhe Nakayafa. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Napeturo yaari vavawo yoottaka mooro. Attu nkayaakoha, “Chani, ni inyuva kanhena owiittucha awe amoka?” Napeturo nkayaakhota eeraka, “Kakihena miyaano!” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Karumiya aya Opochera ishaani Olhupalhe mmoka, nlhoko awe ntu aakhapiye nnyaru ni Napeturo, nkaakoha, “Chani, miyaano khakowonneni inyuva umatani vamoka ni uyo?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Napeturo nkayakhota tho “Akihiwe mii.” Vavawo nthupi nkaweepa. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Paahi etu, nkayankusha Yesu u Nakayafa, nkayanrweha upuwani wa amwene o Uyudea. Yeyo yaari mapikoosha, ni ayo wiira ahoochelhe unlhia Pasaka, khayaakenlhe mpaani ahiwe ahinanarihiye. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Wo chiichammo etu, Napilato nkayaakhuma vathe, nkayeera, “Nrina milhatu chaani ni ulha ntu ulha?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nkayaakhulha, “Thoko ulha akaari khanatteka khanammwiiha uwaninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Napilato nkayeerelha, “Munkusheke etu mwaattiva mwaashinene, nrweeke mwanhukumulheke wo ulhikaana ni Malhehero inyu.” Ayahudi nkayaakhulha, “Hiyaano nihochiichihiya umwiiva ntu riyoothe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yaapangelhe chiicho wiira atimire malhove yoolhumanche awe Yesu ulhohera naakhweke nookhwa ani. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Napilato nkayaarwaa upuwani tho, nkayaamwiihana Yesu ni unkoha, “Eti inyuva phi Mwene Ayahudi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu nkaakhulha, “Chani, yayo malhove ayo anokhuma mmuruni mwinyu ama attu akina phi uhimenrieni mwaha aka?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Napilato nkayaakhulha, “Chani, ki Nyahudi mii? Attu o velhaponi winyu ni attu opochera ishaani olhupalhe phi uwinheni uwannyaka. Nttekilheni?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu nkaakhulha, “Umwene aka kuhiwe wo velhaponi va. Umwene aka wakaari wo velhaponi va, anamitheko aka aanokinkelha kihivariye ni Ayahudi. Mena, umwene aka kuhiwe wo velhaponi vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Vavawo Napilato nkayaamwiirelha Yesu, “Paahi etu, inyuva Amwene?” Yesu nkaakhulha, “Inyuva nhohimia wiira miyaano Mwene. Miyaano kiyareelhe wo yoyo nlhatu uyo, ni wo yoyo nlhatu uyo kihowa velhaponi uhimiechesha wa attu mwaha we ikeekhene. Kila ntu novara ikeekhene nookiwelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Napilato nkayaakoha, “Ikeekhene phi ishiyani?” Napilato yamalheke wulhumacha yayo, nkayaakhuma tho vathe waari aya Ayahudi, nkayeerelha, “Miyaano khakinoona nlhatu uriyoothe wiira ulha ntu ulha hotteka. ");
INSERT INTO mgh2016_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ukhalhawaya mwaatti nhanaa malhemalhelho o uttukulhelhani ntu mmoka vanophiya aya ikatema yo Pasaka, paahi etu, nnoothanana vano kuuttukulhelheni Mwene Ayahudi?” ");
INSERT INTO mgh2016_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Vavawo nkayakhuwelhacha yiiraka, “Mena! Kahena ulha hii ninonthanana Baraba!” Yoyo Baraba uyo aari ntu o uvara makhuche. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Paahi, Napilato nkaalhehera wiira Yesu aatiye ikopo. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Manyaasikari nkayaavilhika mphumburu wo miiwa, nkayammwariha mmuruni, nkayammwariha mwiinjiro wo irangi yo zambarau. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nkayaawa ni unveehacha yiiraka, “Moyoo, Amwene Ayahudi!” Nkayaamwata makofi. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Napilato nkayakhuma tho vathe, nkayeera, “Nkoonani, kinommwiiha vano uwaninyu, nchuwelheke wiira miyaano khakoonne nlhatu uriyoothe uwannyawe.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Paahi, Yesu nkaakhumihiya vathe nawanre mphumburu wo miiwa ni mwiinjiro we imwene. Napilato nkayeerelha, “Mmweheke! Ntu mwanene uyo phi ulha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Opochera ishaani olhupalhe ni anamitheko olhita Inupa ya Nlhuku vaamwonne aya nkayakhuwelha yiiraka, “Akomelhelhiye vansalaabani! Akhomelhelhiye vansalaabani!” Napilato nkayeerelha, “Munkusheke etu vano mwaattiva mwaashinene, mwamwiiveke. Ukhalhawaya miyaano khakoonne nlhatu uriyoothe wiira hotteka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayahudi nkayaamwakhulha, “Hiyaano nihanaa Malhehero, ineera wiira hophwanelhiya ukhwa, ukhalhawaya heepanga Mwaana a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Napilato yeeweke yayo malhove ayo, nkayaathepa woova. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nkayaakelha tho mpaani, nkayankoha Yesu, “Inyuva nkhume vayi?” Nansho Yesu khaakhunlhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Napilato nkayaamwirelha, “Woonaka khannottuna wulhumacha ni mii? Chani, khanchuwenlhe wiira mii kihanaa ikuru yo uhiyererani ni ikuru yo ukhomelhelhani vansalaabani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu nkaakhulha, “Khamwaakhalha ni ikuru iriyoothe vachulhu waka mwahakaavahiye ukhuma wiirimu. Paahi etu, ntu kiwinhe uwaninyu uyo yoyo ri o uwonya chinene.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ukhuma vavawo, Napilato nkayaavia iphiro yo unhiyerera, nansho Ayahudi nkayaanyakulha yiiraka, “Mwanhiyereraka ulha ntu ulha, inyuva kanhiwe anlhoko aya Akaisari o Urumi, kila ntu neepanga ukhalha mwene nowaathunalhiha Akaisari o Urumi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paahi, Napilato veewilhe aya yayo malhove ayo nkayammwiiha Yesu vathe, nkayakhalhelha ihiche yo waahukumulhelha attu, vakittu vaneehaniya we Iebraniya Gabatha maana aya “Mmuto wo Malhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Waari uthana, nihuku no wiicheesha rata wo nihuku no Pasaka. Napilato nkayeerelha Ayahudi, “Mummweheke, Mwene inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Attu nkayaakhuwelha, “Munthamihe! Munthamihe! Mwankhomelhelhe vansalaabani!” Napilato nkayaakoha, “Chani, kinkhomelhelheke Mwene inyu vansalaabani?” Opochera ishaani Olhupalhe nkayaakhulha, “Hiyaano khanirina mwene nkina ahikhalhe Akaisari o Urumi!” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Vavawo, Napilato nkayankumiha Yesu nkaavaha ammwie anrweehe akhomelhelhiye vansalaabani. Paahi etu, nkayankusha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni uyo nkaakumihiya nakunshe nsalaaba awe arweehiyaka vakittu vaneehaniya we Iebraniya Gologota, maana aya Nikhurukucha no Muru. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Vavawo phi vakittu vaakhomelhelhiye awe Yesu. Aakhomelhelhiye vamoka ni attu akina elhi, mmoka wiimonono ni nkina wiimushi wawe. Yesu aari variyari. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Napilato nkayaalhepa nlhove vakibaoni ni ukhomelhelha vachulhu nsalaaba. Nlhove naalhepiye nno neera, “Yesu o Unazareti, Mwene a Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayahudi enchi yahoshoma nenno nlhove nno, ukhalhawaya vaakhomelhelhiye awe Yesu vawo, vaari vakiviru ni vawani. Ni nlhove nno naari ninalhepiye wo moolhumo e Iebraniya, Ilatini, ni Iyunani. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Opochera ishaani olhupalhe nkayeerelha Napilato, “Nhilhepe wiira, ‘Mwene a Ayahudi,’ nansho nlhepeke, ‘Ntu enre, Miyaano phi Mwene a Ayahudi.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Napilato nkayaakhulha, “Kilhempe aka, kiholhepa!” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Manyaasikari yamalheke unkhomelhelha Yesu vansalaabani, nkayaawia ikuwo chawe, nkayaakawa vacheshe, kila nsikari nifungu nimoka. Nkayaakusha chiicho ni mwiinjiro awe nkina, waari wo ttaviya ikuwo imoka yaalhutanne, wo hitottiya. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Paahi etu, manyaaasikari nkayeewanana ashineneru wiira, “Ilha nihaahulhe, noopeke ikhura yo ulhamulha inaakhalheke ya apani.” Yoyo mwaha uyo waapangia atimire Malhove Matakatifu aneera “Yahokawana ikuwo chaka, ni mwiinjiro aka wahoopelhiya ikhura.” Paahi etu, phi chiicho chapannge aya manyaasikari ayo. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Vaatameria nsalaaba waakhomelhelhiye Yesu yaari aneemenlhe anumwanawe, ni arokoraya anumwanawe, ni Amariamu ahanu a Nakileopa, ni Amariamu Magidalena. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu nkoona anumwanawe, ni owiittucha anttunne awe aneemenlhe, nkeerelha anumwanawe, “Amma! Mummweheke, vano ulha phi mwamwaninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tho nkaamwirelha owiittucha ulhe, “Mwaaweheke, alha phi anumwaninyu vano.” Uchokholhelha vavawo, yoyo owiittucha uyo nkaakusha Amariamu nkaakhalhana uwannyawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yamalhekeru, Yesu nkoona wiira onkhaye ahotimira, ni wo utimiriha Malhove Matakatifu nkeera, “Kinoona nttona.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vavawo yahokhalha ni ikahi yaachanre idivai yo uhichasha. Paahi, nkayaruwia mdodoki mu divaini mmo, nkayaattuka munthalheni, nkayaamweshera vamalhakuni. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu amalheke utoolha idivai iyo, nkeera, “Mitheko chihotimira!” Yamalheke nkooroma muru, nkaahiya nrima. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Paahi aholhelhi Ayahudi nkayaavekelha Napilato wiira oonthe mieto cha attu aakhomelhelhiye, ni ukurusha mitembo chaya vansalaabani. Yaari avekelhaka ukhalhawaya yaari nihuku no ijumaa, nihuku no wiicheesha rata. Wo chiicho, iruttu chihihalhe mmisalaabani Nihuku no Wiittuwa, ukhalhawaya nenno nihuku nno naari nulhupalhe chinene. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Paahi etu, manyaasikari nkayaarwaa, nkayamuntha mieto ntu aakhomelhelhiye wiiminono, ni nkina o wiimushi, attu yaakhomelhelhiye vamoka ni Yesu alhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nansho yamphiyelheke Yesu, nkayoona wiira homalha ukhwa, wo chiichammo etu khayoonthe mieto chawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nsikari mmoka nkanhoma nivaka Yesu vapararini, wo uhipicha nkayaakhuma iphome ni maashi. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni uyo onne chechiyo ahoonechesha inyu mwaatti nrumelhelhe. Ni malhove yuulhumanche awe phi ikeekhene, ni uyo hochuwelha wiira uhimiechesha wawe phi ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yoyo mwaha uyo waapangelhe Malhove Matakatifu atimire, “Khaniwo nikhuva nawe inakhalhaka nimoka ninohalha wunthiya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tho Malhove Matakatifu aneera, “Anommweha ulhe anhomilhe aya nivaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Umalha waya yayo, Nayusufu, anenchi o Uarimathaya, yahaavekelha Napilato nipesha no ukusha iruttu ya Yesu. Nayusufu yaari owiittucha a Yesu, nansho wo wiivitha, ukhalhawaya yaanoova aholhelhi a Ayahudi. Paahi, Napilato nkayaahiyera. Nayusufu nkayarwaa, nkayakurusha iruttu ya Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nayusufu, yaarweelhe vamoka ni Nanikodemo yaathonke mahuku o utulhi ayo unrweelha Yesu uhiyu. Aawiilhe anakunshe manemane aathakanihiye ni ubani wo umalhaka iratili imia imoka o wootiha ntembo wa Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Attu elhi ayo etu, nkayakusha iruttu ya Yesu, nkayaavilhikelha ikuwo yo uvithelha vamoka ni makhura ulhikaana ni malhemalhelho a Ayahudi o uvithaniya. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Vavawo vakittu vakhomelhelhiye awe Yesu vawo vaari ni imata, ni mommo mmatani mmo mwaari ni nihiye no naanano nihinavithiya ntu riyoothe nhina mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ukhalhawaya naari nihuku ni Ayahudi no wiicheesha rata wo Nihuku no Wiittuwa, ni ukhalhawaya nihiye nno naari vakhiviru, nkayeesha iruttu ya Yesu mwommo. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mapikoosha o nihuku no Jumaapili, Amariamu Magidalena yahorwaa unihiyeni, nkayoona wiira nlhuku naakhuneelhiye nihothamihiya vanlhakoni vo nihiye vawo. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nkayaarwaa attimakachaka urwaa wa Nasimoni Peturo ni owiittucha nkina attuniye ni Yesu, nkayeerelha, “Ahaathamiha Athithi nnihiyeni, ni hii khanichuwenlhe weeshiye aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Napeturo vamoka ni owiittucha nkina uyo nkayarwaa unihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Onkhaye oyelhi aari attawaka nansho owiittucha nkina uyo ahottawa chinene waapwaha Napeturo, nkaaholhelha uphiya unihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nkooroma ni uthurumelha, nkoona ikuwo yo uvithelha inavilhikachiye, nansho khaakenlhe nhina. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nasimoni Peturo ni ayo nkayaawa anttwaraka, nkaakelha nnihiyeni, mommo nkayoona ikuwo yaavithelhiye Yesu, ");
INSERT INTO mgh2016_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni ikitambaa yaakhunelhiye awe Yesu mmuruni ilhe. Yeyo ikitambaa iyo khayaari vamoka ni ikuwo iyo, nansho yaari inavilhikiye umuruni, thoko chaari aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yamalheke owiittucha nkina aaholhenlhe uphiya unihiyeni uyo, nkaakelha ni uyo nhina. Nkoona, nkarumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yaari ahinaya uchuwelha Malhove Matakatifu yeenre wiira noohihimmwa ukhuma nnookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Paahi etu owiittucha ayo nkayaahokolhiacha uwani. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Amariamu yaari aneemenlhe vathe vo nihiye, onlhaka. Uno anari onlhaka, nkayooroma ni uthurumelha nnihiyeni, ");
INSERT INTO mgh2016_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nkayoona minepa elhi aawanre ikuwo chootelha ttuuu, anakhanlhe vaathalhelhiye aya iruttu ya Yesu, mmoka umuruni nkina umietoni. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Minepa nkachaakoha Amariamu, “Maanyi, nnonlhani?” Amariamu nkayaakhulha, “Ahaakusha Athithi aka, ni mii akichuwenlhe weeshiye aya!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Amalhiheke wulhumacha yayo, nkaarukunuwa utulhi, nkayamwoona Yesu neemenlhe vavawo, nansho khayanchuwelhe wiira aari phi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu nkaakoha, “Maanyi, nnonlhani? Nnaavia apani?” Amariamu, yaanyiheraka wiira yoyo ntu uyo aari mwanene imata, nkayaakhulha, “Munna, yakhalhaka phi inyuva mwathaminhe, nkihimerie mwenshe vayi, ni mii kinorwaa waakusha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu nkeerelha, “Khu Amariamu!” Ni ayo Amariamu nkayarukunuwa, nkayoolhumacha wo Iebraniya, “Raboni.” Maana aya akhalhaka, “Owiittuchiha.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu nkaachiichiha eeraka, “Nhikivare, khakinarwaa kaye uchulhu wa Athithi. Nansho nrweeke wa ashilhoko mwaahimerieke wiira, kinokelha nchulhu wa Athumwanaka arii Athumwanaya, Nlhuku aka ri Nlhuku aya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Paahi etu Amariamu Magidalena nkayaarwaa ni waahimeria owiittucha alhe wiira, “Kihoona Athithi!” Ni waahimeria malhove aahimenrie aya. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yaari uchechilho yo nenno nihuku no Jumaapili nno, owiittucha yaari anathukumanne vamoka mpaani milhako chaari chinatteiye, nlhatu no woova aholhelhi a Yahudi. Paahi Yesu nkaakhumelhelha ni weemelha variyari aya, nkeerelha, “Mpuha ukhalhe ni inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Amalheke wulhumacha yayo, nkooniha miono chawe ni niparari nawe. Owiittucha nkayaatelhiya chinene woona Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu nkeerelhacha tho, “Mpuha ukhalhe ni inyu! Thoko Athithi chikirumme aya, ni mii kinourumani mwaattiva.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Amalhiheke, nkaawuchelhelha ni weerelha, “Mumpochereke Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mwaahiyereraka attu uwonya waya, anoohiyereriya, mwaahahiyerereke, khaanohiyereriya.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Natomaso amoka aya khumi ni elhi alhe aneehaniya Nivata, khayaatamme ikatema Yesu vaawilhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Paahi etu, owiittucha akina akhunanaya ayo nkayeera, “Nihoona Athithi!” Natomaso nkayeera, “Kaahoneke marottelha o ikhomo mmathathani mwawe ni ukelhiha nikokho naka mmarottelhani mmo, ni uhelha moono aka mpararini mwawe, khakirumelhelhaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yavireke mahuku mathanu ni mararu owiittucha ayo yaari anathukumanne tho vamoka mpaani, Natomaso ahaatama na ayo. Milhako chaari chinatteiye, nansho Yesu nkaakelha, nkeemelha variyari aya, nkeera, “Mpuha ukhalhe ni inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Amalhiheke nkeerelha Natomaso, “Mmwiiheke nikokho ninyu vaa, mmweheke ni miono chaka, mmwiiheke moono inyu uyo nkelhiheke mpararini mwaka. Nhiyeke ulhipa nrima uwo, nrumelhelheke!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Natomaso nkayaakhulha, “Athithi ni Nlhuku aka!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu nkeerelha, “Chani, nnorumelhelha ukhalhawaya nhookoona? Ahoreeriya yayo anorumelhelha, nansho wo hikoona mii!” ");
INSERT INTO mgh2016_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ahopanga cho ushangiha chikina chinchi vaari awe na owiittucha awe chihilhepiye nhina ilha ikitabu ilha. ");
INSERT INTO mgh2016_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nansho chilha chilhepiye mwaatti nrumelhelhe wiira Yesu phi Kuristo Moopolhi, Mwaana a Nlhuku, ni wo urumelhelha winyu mpatte ukhalha ni ukumi wo ikuru yo nchina nawe. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Umalhawaya, Yesu nkaakhumelhelha tho owiittucha awe vachereshere nttiya no Utiberiya. Aakhumelhenlhe choo ");
INSERT INTO mgh2016_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nasimoni Peturo ni Natomaso aneehaniya Nivata, ni Nanathanieli anenchi o Ukaana yo Ugalilaya, ni ashaana elhi a Nazebedayo ni owiittucha awe akina elhi, yaari onkhaye vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nasimoni Peturo nkayeerelha akhunanaya, “Kinokelha uvarani ihopa.” Ni ayo nkayaamwiirelha, “Ni hii ninoorwaa vamoka ni inyu.” Nkayaarwaa nkalhavani, nansho yoyo uhiyu uyo khayaapantte ittu. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nchuwa vaakhuma aya, Yesu nkeemelha vachereshere nttiya, nansho owiittucha awe khayaachuwenlhe wiira aari phi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Paahi etu Yesu nkaakohacha, “Mwaatti, khannapatta ihopa ngati?” Ni ayo nkayaamwaakhulha, “Eiyo khaninapatta ittu.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu nkeerelha, “Ntikhelheke ittavi mpantta wo wiimonono wo ikalhava ni inyu nnoovara ihopa.” Paahi etu, nkayaatikhelha ittavi nansho khayoonrie upurulha, ukhalhawaya ihopa chaavanre aya chahothepa winchiva. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Owiittucha aattuniye ni Yesu ulhe nkeerelha Napeturo, “Athithi!” Napeturo yeeweke wiira aari Athithi, nkayettuka mwiinjiro aya ukhalhawaya aari aneekokotenre, nkayaathuphelha mmaashini. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nansho owiittucha akina nkayaawa uchengweni nkalhavani uno apurulhaka nttavi naachanre ihopa, khawaari utayi, yaari woomalhaka ihatua imia imoka vaneemelha maashi. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yaphiyeke vachengweni nkayoonacha ihopa chinaaneelhiye vamakhalhani ni nkatte. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu nkeerelhacha, “Mmwiiheke vaa vakani ihopa chimennje inyu chiyo.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nasimoni Peturo nkayaawelha nkalhavani, nkayaapurulhelha nttavi vachengweni ninachanre ihopa chulhupalhe imia imoka makhumi nthanu ni taru. Inakhalhaka chiicho, nttavi khanaapaphuwilhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu nkeerelha, “Mmwaacheke vaa etu mmwe mwaalhia.” Khaawo anakhalha owiittucha mmoka onrie unkoha, “Inyuva phi apani?” Ukhalhawaya yahochuwelha wiira yaari Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu nkaawa, nkaakusha nkatte, nkaavaha, nkaapanga chiichammo ni ihopa chilhe. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ulha, waari nkwaha wo neraru Yesu waakhumelhelha owiittucha awe, ukhuma vaahihimmwe awe. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yamalhiheke ulhia, Yesu nkaakoha Nasimoni Peturo, “Nasimoni, mwaana a Nayohana! Chani, nnookittuna mii waapwaha alha akina alha?” Ni ayo nkayaakhulha, “Eiyo, Thithi, nnochuwelha wiira miyaano kinouttunani.” Yesu nkeerelha, “Nshunge ashaana o ikhondoro chaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nkeerelha tho ninayelhi, “Nasimoni mwaana a Nayohana! Chani, nnokittuna?” Napeturo nkayaakhulha, “Eiyo, Thithi, nnoochuwelha wiira kinouttunani.” Yesu nkeerelha, “Nshunge ikhondoro chaka.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nkaakoha yo neraru, “Nasimoni mwaana a Nayohana! Chani, nnokittuna?” Vavawo Napeturo nkayaachukulha wo nlhatu nookohiya wo neraru, “Nnokittuna?” Nkayaakhulha yiiraka, “Thithi, inyuva nhochuwelha chonkhaye, inyuva nnoochuwelha wiira miyaano kinouttunani.” Yesu nkeerelha, “Nshunge ikhondoro chaka! ");
INSERT INTO mgh2016_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ikekheene kinouhimeriani, vaari inyu amirawo mwaholhemalhelha wiittuka nchako ni ukelha uriwoothe waathanana inyu. Nansho vanohalha inyu wuulhuvalha, nnowookolha miono chinyu, ni ntu nkina nouttukani ni urweehani uhinothanana inyu urwaa.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Wo wulhumacha chiicho, ahooniha iphiro yaani Napeturo anohalha aya uvira muukhwani ni unthimicha Nlhuku. Amalhiheke nkeerelha, “Nkittware.” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Vavawo Napeturo nkayarukunuwa, nkayaamwona owiittucha aattuniye ni Yesu ulhe, noottwara. Ulha phi owiittucha aakhanlhe amwaatameriaka chinene Yesu ikatema yaalhiaya yolhia yo uchechilho, ni unkoha “Thithi phi apani anohalha uthumihani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Napeturo vaamwonne aya yoyo attwaraka, nkayankoha Yesu, “Thithi ni alha mwaha aya uri chani?” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu nkaakhulha, “Yakhalhaka wiira kinothanana alha ahalheke mpaka vanohalha aka uwa tho, irini uwaninyu? Inyu nkittwareke mii!” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Paahi etu, yoyo mwaha uyo nkawawanelha munlhokoni mwa attu anttwara na owiittucha awe wiira yoyo owiittucha uyo kanokhwa. Nansho Yesu khenre wiira yoyo owiittucha uyo khankhwa, nansho enre “Yakhalhaka wiira kinothanana alha ahalhe mpaka vanottuna aka uwa, irini uwaninyu?” ");
INSERT INTO mgh2016_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ulha phi owiittucha nohimiechesha ni ulhepa ulha mwaha ulha. Ni hii ninoochuwelha wiira himianche awe iri ye ikekhiaye. ");
INSERT INTO mgh2016_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Chihawo chittu chikina chinchi chaapangilhe awe Yesu, yakaari chaholhepiya chonkhaye, imoka kaanyuma yo ikina, kinaanyihera wiira ilhapo khayooria ukhalha ichitabu chikaalhepiye chiyo.");
INSERT INTO mgh2016_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Munna Nateofilo, Ikitabu yo upachera kaaholhenlhe aka ulhepa ilhe, kaalhempe yaachaka mwaha wonkhaye waapannge awe Yesu ni wiittuchiha toka vaachokhonlhe awe ntheko ");
INSERT INTO mgh2016_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mpaka nihuku naakushiye awe wiirimu. Nansho hinaya ukushiya wiirimu ahaalhehera wo ikuru yo Iphumu ya Nlhuku, akarumiya aathanlhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wo mahuku makhumi macheshe toka vaahihimmwe awe ahaakhumelhelha wo iphiro chinchi uhimiechesha wiira hohihimmwa. Aheechooniha wa akarumiya awe, ni woopana mwaha unaacha Imwene ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ikatema yaakumanne awe vamoka ahaalhehera wiira, “Nhithame va Yerusalemu, nansho mummweherereke Iphumu ya Nlhuku, mpochere izawadi ilhehiye ni Athithi uvahani. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nayohana yaabatinze attu wo maashi, nansho yaviraka mahuku vakani, mwaattiva nnoowa mwaabatiiziya wo Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Paahi akarumiya ikatema vaakumanne aya ni Yesu, yahonkoha, “Thithi, chani ilha ikatema ilha phi naahokolhoshera inyu umwene attu o Uisraeli?” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu nkeerelha, “Mwaatti kuhii ntheko inyu uchuwelha ikatema yo ukhumelhelha waya, yeyo irii mu ikuru ya Athumwanaka vekha aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nansho nnoowa mwaapochera machiri o Iphumu ya Nlhuku vanohalha aya uukhuruwelhani. Ni inyu nnoowa mwaakihimiechesha Uyerusalemu ni ilhapo yonkhaye yo Uyudea ni Usamariya ni kila vakittu velhaponi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Amalhiheke wulhumacha yayo, ahokushiya wiirimu attu onkhaye amwoonaka, nihute nkanankhuneelha ahimwoonaka tho. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nansho vaathepa aya uweha wiirimu, Yesu vaarwaa awe, wo uhipicha attu elhi yaawanre ikuwo cho utakatifu twetwetwe yaheemelha ni waatameria. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nkayeera, “Attu o Ugalilaya! Chani woonaka nheemelha mmwehaka wiirimu? Ulha Yesu kushiye ukhuma uwaninyu urwaa wiirimu ulha, noowa tho thoko chimoonilhe inyu arwaaka wiirimu chiyo.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yamalhekeru akarumiya yahohokolhia Uyerusalemu ukhuma waari mwaako uneehaniya Mwaako wo Mizeituni waari imaili imoka, waatameriaka nkwaha wo Nihuku no Wiittuwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Vaaphilhe aya vawani nkayaakelha uchuumbani inupa yo nchulhu ugoroofani mwaakhalha aya. Yayo yaari Napeturo ni Nayohana vamoka ni Nayakhobo ni Naandorea ni Nafilipo ni Natomaso tho ni Nabatolomayo ni Namatayo ni nkina aari Yakhobo mwaamwanaa Naalufayo ni Nasimoni Nnenchi aakhwelha ilhapo yo Ukaanani ni Nayuda mwaana a ashinna Yakhobo. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nkawakumaaniya akarumiya vamoka ni manyopani akina ni Amariamu anumwanawe Yesu ni ashihima awe unlhapelha Nlhuku wo nrima mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nihuku nimoka Napeturo yaheemelha ni wulhumacha munlhokoni mwa attu aarumelhenlhe Athithi, yaaphiyelha attu imia imoka ni makhumi melhi, ");
INSERT INTO mgh2016_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","nkayeera, “Ashilhoko aka munrumelhenlhe Yesu, wo woorihiya ni machiri o Iphumu ya Nlhuku, Adaudi aholhepa nlhove no waacha Nayuda nhina Malhove Matakatifu, ni nno nihokhumelhelha. Nayuda yaari akhunanihu, nansho phi yayo yaaholhenlhe attu yammanre Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nayuda yaari amoka munkutironi mwihu, ukhalhawaya ahothanlhiya ni Yesu ulhutaana ni hii mu nthekoni wihu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nayuda yahothuma imata wo nchurukhu waalhiviye aya wo uhilhoka waya. Nkayaawulhuwa wowo umatani uwo, nkayaaphwia nthunkwa ni marupo aya nkayaakhuma vathe. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Attu o Uyerusalemu veewilhe aya yoyo mwaha uyo, nkayeehana yeyo imata iyo wo nulhumo naya, Hakelidama, maana aya, “Imata yo Iphome.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ukhalhawaya iholhepiya nhina ikitabu yo Izaburi, ‘Inupa awe ihiiyeke mathalha, riyoothe hikhalhe nhina mwaya.’ Tho iholhepiya, ‘Ntu nkina akusheke ntheko wo ushunga waapanga awe.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Paahi etu athanlhiyeke ntu mmoka o unikaviha ntheko wo uhimiechesha uhihimmwa wa Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yoyo akhalheke ntu mmoka anttukana ihu toka nihuku Athithi Yesu vaabatiiziye aya ni Nayohana mpaka nihuku naakushiye aya wiirimu nne. Yoyo nookhalha o uhimiechesha uhihimmwa wa Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nkayaaromolhiya machina a attu elhi, o upacha yaari Nayusufu yeehaniya Nabarsaba tho yeehaniya Yusto. O nayelhi yaari Namatiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yamalhiheke nkayanlhapelha Nlhuku, “Thithi, inyuva phi nochuwelha mirima cha attu onkhaye chiri aya! Paahi etu, nnooniheke mpani wa alha attu elhi alha munthanlhe phuuyi, ");
INSERT INTO mgh2016_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","wiira akhalhe karumiya ntheko uhiilhe aya Nayuda, nkayaarwaa vakittu vaaphwanenlhe aya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nkayoopa ikhura, nkaathanlhiya Namatiya yonchereriye munlhokoni mwa akarumiya khumi ni mmoka alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nihuku no Pentekote naayeke, attu anrumelhenlhe Kuristo onkhaye yaari anathothokanne vakittu vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wo uhipicha, nkaneewania nlhove naaruma ukhuma wiirimu naaruma thoko iphioo yo machiri! Nkanaachara inupa yonkhaye mwaari aya anakumanne. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Yamalheke, nkachaakhumelhelha chittu choonelhe thoko malhimi o mooro, nkacheemianiha ni ukorweelha vachulhu kila mmoka aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kila mmoka nkaachariya Iphumu ya Nlhuku, nkayaachokholha wulhumacha wo nulhumo nilheto, thoko Iphumu chaavahenre aya wulhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ni Uyerusalemu uwo yahokhalha Ayahudi enchi yaari attu yanthimicha Nlhuku, yaakhumme kila ilhapo yo velhaponi wuuthi irimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Veewilhe aya nenno nlhove nno, nlhoko wa attu enchi wahokumaana. Nansho onkhaye yahothuthuwa chinene, ukhalhawaya yaari eewaka kila ntu olhumachaka wo nulhumo nawe mwanene. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nkayaathikhina ni ushanga yeeraka, “Chani, alha onkhaye aneewa ihu yuulhumachaka alha, kahiwe anenchi o Ugalilaya alha? ");
INSERT INTO mgh2016_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yiireelhe chani, etu, weewa yuulhumachaka wo nulhumo kila ntu niyarelhe awe? ");
INSERT INTO mgh2016_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Attu akina ihu akhumme Uparthi, akina Uamedi, akina Uelami, akina Umesopotamiya, akina Uyudea, akina Ukapadokiya, akina Uponto, akina Uasiya, ");
INSERT INTO mgh2016_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","akina Ufirigiya ni Upamfiliya, akina Umisri ni ilhapo cho Ulibiya waatameriana Ukirene. Ni akina ihu nikhumme Urumi, akina Ayahudi ni akina eettuchilhe idini ya Ayahudi akhumme Ukirete ni Uarabia., ");
INSERT INTO mgh2016_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Hiyaano onkhaye ninowiiwa nkutiro wa Ayahudi ni akina akhumme Ukirete ni Uarabiya, yuulhumachaka wo nulhumo nihu naashinene mitheko cho ushangiha chipangilhe awe Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Attu onkhaye ahoshanga yoovaka chinene ashineneru akohanachaka, “Yelha maana aya phi ishiyani?” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nansho attu akina nkayaapangelha mattepwa attu yarumelhenlhe Athithi alhe, yeeraka, “Alha manyaattu alha ahohapalhiya!” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Napeturo nkayeemelha vamoka ni akarumiya khumi ni mmoka alhe nkayaawelhiha nlhove naya ni uchokholha waahimeria attu yeeraka “Ashilhoko aka Ayahudi ni inyu onkhaye nnokhalha va Yerusalemu va, mwiiwelhelheke kuuhimerieni ulha mwaha ulha. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Alha attu alha kahapalhiye thoko chinaanyihera inyu mwaatti, woonaka vano bado saa tatu yo wichishu? ");
INSERT INTO mgh2016_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kuhiwe chiicho, ulha mwaha ulha phi ulhe waahimmie aya anamilhohi a Nlhuku Nayoeli. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nlhuku neera, kinoopanga cho mahuku o umalhelha, Kinowaamiinelha attu onkhaye Iphumu aka. Achishaana inyu ashilhopwana ni ashithiyana anoohimiacha nttenga wa Nlhuku, Ashimirawo anowa woona chowooniya, Ni ashulhupalhe inyu anoolhoha itora. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eiyo, ata akarumiya aka ashilhopwana ni ashithiyana, Kinowaamiinelha Iphumu aka yayo mahuku ayo, Ni ayo anoowa aahimiacha Malhove aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kinoopanga ithikineha wiirimu uchulhu ni cho ushangiha vathi velhaponi. Vanowa ukhalha iphome ni mooro ni mwiishi wo ulhemelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nchuwa ninookelhiya ipiphi ni mweeri unookhalha wo khwiilha thoko iphome, nihinaaya nihuku nulhupalhe no uwa wa Athithi nne. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Vavawo ntu riyoothe nohalha ulhapelha wo nchina na Athithi, nowoopolhiya.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Anenchi o Uisraeli, nkeewelhelhani alha malhove alha! Thoko chineera inyu wo uchuwelha, Yesu o Unazareti aari ntu o ikuru ya Nlhuku yoonihiye uwaninyu wo ithikineha ni cho ushangiha chaapannge awe iriyari inyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nlhuku ahochuwelha ni ulhakelha wiira Yesu nowa uhelhiya mmathathani mwinyu ni inyu nnoowa mwaavaha attu o uwonya ankhomelhelhe eeviye munsalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nansho Nlhuku ahonhihimusha unookhwani, nkaamoopolha nookhwa ni uweria wawe ukhalhawaya nookhwa khoonrie mena unttuka. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ukhalhawaya Adaudi yahoolhumacha mwaha awe wiira, ‘Athithi arii mmiholho waka ikatema chonkhaye, Ahokaatama ni mii khakinowa kaahuva. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chiichammo etu, nrima aka uhoteelhiya, malhove aka ahochara mpuha, iruttu aka yo ukhwa ilha inowa yaakhulhuvelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ukhalhawaya inyuva Apwiiya Nlhuku khannokihiya unaminepa, Mena khannonhiyerera ntu inyu ntakatifu wiira onte. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nhokooniha iphiro cho ukumi, ukhalha winyu uhokichariha mpuha!’ ");
INSERT INTO mgh2016_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mwaattu ashilhoko aka, ihorera uhimeriani mwaha waapantte apwiiya Adaudi. Yayo yahokhwa, nkayaavithiya ni nihiye naya nirii vava vawanihuva mpaka lhelho nna. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nansho ukhalhawaya Adaudi yaari anamilhohi a Nlhuku, yahochuwelha wiira Nlhuku ahaalheha wiira anommara nchina mmoka o iyari aya ukhalhelha ihiche yo imwene vanipuroni waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Adaudi yahoona chitema mwaha unohalha upangiya ni Nlhuku, chiicho etu nkayoolhumacha mwaha wo uhihimmwa wa Kuristo Moopolhi ikatema venre aya ‘Khahiiye unaminepa, iruttu awe khayontilhe unihiyeni.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nlhuku ahonhihimusha yoyo Yesu uyo ni hiyaano onkhaye phi o uhimiechesha yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Awelhihiyeke wiirimu ni weeshiya wiimonono wa Nlhuku, ahompochera Iphumu ya Nlhuku aalhehiye ni Athithi. Ilha inoona inyu ilha ni wiiwa vano ilha, phi Iphumu ya Nlhuku niminenlhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ukhalhawaya Adaudi anene, khayaawenlhe mpaka wiirimu, ihikhalhe yenre, ‘Athithi yaheerelha Athithi Nkhalheke wiimonono waka, ");
INSERT INTO mgh2016_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mpaka vanohalha aka waathalha amalhaponi inyu wuuthi inyaa chinyu wiira mwaanyikalhelhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Attu onkhaye o inupa yo Israeli achuwelheke we ikekhiaye wiira uyo Yesu aakhomelhelhiye vansalaabani, phi uyo Nlhuku mpannge awe ukhalha Athithi ni Kuristo!” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Paahi etu, attu veewilhe aya yayo malhove ayo, nkayaahomiya mirima chinene, nkayaakoha Napeturo ni akarumiya akhunanaya alhe “Ashilhoko ihu, niireke chani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Napeturo nkayaakhulha nkayeera, “Nkhoromeke, nhiyeke uwonya ni kila mmoka inyu abatiiziyeke wo nchina na Yesu Kuristo, wiira nhiyereriye uwonya winyu, ni inyu nnompochera Iphumu ya Nlhuku aalheehiye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ukhalhawaya malhehano a Nlhuku yaari wo nlhatu ninyu ni achishaana inyu ni attu onkhaye anokhalha utayi ni wo nlhatu no kila ntu nohalha wiihaniya ni Athithi Nlhuku uwannyaya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ni wo malhove makina menchi, Napeturo ahohimiechesha ni waakurumicha attu eeraka, “Mwiichopolheke ni uttwaruwa unaaweelha attu o uwonya o ilha ilhapo ilha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Attu enchi yahorumelhelha malhove aya, nkayaabatiiziya. Nenno nihuku nno attu yaaphiyelha maelufu mararu ahonchereria mu mphingoni mmwe. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nkayaathepa wiittucha wa akarumiya ni ukhalha nlhoko mmoka thoko o uyaraana ni umia nkatte vamoka ni unlhapelha Nlhuku vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ithikineha ni cho ushangiha chinchi chahopangia wo iphiro ya akarumiya ata attu onkhaye nkayaathulhuwa mmakhuvani. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Attu onkhaye yanrumelhenlhe Yesu yahothepa ukhalha ittu imoka akawanaka kila ittu yaarina aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yaari athumihaka chittu chaya, nkayaakawana nchurukhu ulhikaana ni kila mmoka chaahuvelha awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nkayaathepa ukumaana vamoka kila nihuku Inupa ya Nlhuku. Nansho ikatema yo umia nkatte, yaakumaana mmanupani mwaya nkayaamia nkatte vamoka ateelhachiyaka nrima. ");
INSERT INTO mgh2016_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yahontotopelha Nlhuku, nkayaattuniya ni attu onkhaye. Kila nihuku Athithi yahoncherera attu munlhokoni mwa attu oopolhiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nihuku nimoka saa tisa uthana ikatema yo unlhapelha Nlhuku, Napeturo ni Nayohana yaari arwaaka wi Inupa ya Nlhuku ulhapelhani. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ni ntu mmoka o uheeta toka vaayariye awe ni anumwanawe, eeshiya kila nihuku Inupa ya Nlhuku va nlhako weehaniya “Nlhako wo urera,” wiira aavekelhe attu yaakelha Inupa ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","voonne awe Napeturo ni Nayohana akelhaka Inupa ya Nlhuku, ahaavekelha anvahe ittu iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Napeturo nkayammweha wo miitho melhi, ni Nayohana chiicho, nkayaamwiirelha, “Uniweheke hii!” ");
INSERT INTO mgh2016_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nkaaweha, akhulhuvelhaka upochera ittu uwannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nansho Napeturo nkayaamwiirelha, “Khakirina nchurukhu mena idhahabu, nansho kinouvaha ilhe irina aka. Wo nchina na Yesu Kuristo o Unazareti, wunkweke weeteke!” ");
INSERT INTO mgh2016_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nkammara moono wo wiimonono, nkaamweemesha. Vavawo vavawo mieto ni makutha awe nkaahelhiya machiri. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nkeemelha, nkaachokholha weeta. Nkaakelhana vamoka Inupa ya Nlhuku eetaka ni uthuphathupha uno antotopelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Attu onkhaye yaari vavawo ayo yahomwoona eetaka ni untotopelha Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","vaanchuwenlhe aya wiira aari phi ulhe aavekelha va “Nlhako Worera,” Inupa ya Nlhuku, nkayaashangacha chinene ahichuwelhaka chinkhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ntu ulhe vaari awe aattwaraka Napeturo ni Nayohana wi Ipwaro i Naselemani, attu onkhaye yaari ashangaka chinene, nkayaattimakelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Paahi etu, Napeturo vonne aya attu alhe nkayeera, “Anenchi o Uisraeli, nnoshangani ulha mwaha ulha? Woonaka nnooniweha chinene thoko wiira nimwetinhe ulha ntu ulha wo machiri ihu ama wo unthimicha wihu Nlhuku? ");
INSERT INTO mgh2016_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nlhuku a Aburahimu ni Naisaka ni Nayakhobo, Nlhuku a manyaapwiiya ihu honthimicha namitheko awe Yesu. Nansho mwaatti mwahonhelha mmiononi mwa ashulhupalhe wiira eeviye ni unkhota upuwani u Napilato, ata Napilato volhumanche aya nlhove no unhukumulha wiira ahiyereriye. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Aari ntakatifu ni orera nrima, nansho mwaattiva mwahonkhota, nkamwaavekelha wiira ntu aari owiiva ahiyereriye. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Paahi, mwaatti mwahomwiiva ulhe aari machokholhelho o ukumi, nansho Nlhuku ahonhihimusha, ni hii phi o uhimiechesha yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Machiri o nchina na Yesu ni nrima wo nenno nchina nno phi nvanhe machiri ulha ntu nnomwoona inyu ni unchuwelha ulha. Nrima wo unrumelhelha Yesu phi nlhaminhe ulha ntu ulha thoko onkhaye chinoona inyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Vano etu, ashilhoko aka, kihochuwelha wiira mwaattiva ni aholhelhi inyu mwaapannge yayo wo nlhatu no uhichuwelha winyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nlhuku ahohimia khalhayi wo iphiro cha anamilhohi onkhaye wiira Kuristo awe hophwanelhiya uhuva, phi chiichammo etu chitimirinhe awe wo ilha iphiro ilha. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Paahi etu, nkhoromeke, nhiyeke uwonya, munhokolheelheke Nlhuku, ni uyo nouhiyererani uwonya winyu. Mweeraka chiicho, ");
INSERT INTO mgh2016_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ikatema ya Athithi yo uvahani machiri o munnepani inoowa ni ayo anonruma Yesu Kuristo anthanlhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Noolhokelha wiirimu mpaka vanohalha aya uphiya ikatema yo urehelhelhiya chittu chonkhaye, thoko Nlhuku chaahimmie awe toka machokholhelho wo iphiro ya anamilhohi awe atakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Ukhalhawaya ashinna Musa yaheera, ‘Athithi Nlhuku inyu anouwiiherani namilhohi thoko mii ukhuma munlhokoni mwinyu mwaashinene. Ni inyu mwiiwelhelheke ittu iriyoothe inohalha awe uhimeriani. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ntu riyoothe hinowa umwiiwelhelha yoyo namilhohi a Nlhuku uyo, attu a Nlhuku anonhiya utayi ni urimeelhihiya.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wo ikekhiaye, anamilhohi a Nlhuku onkhaye upachera Nasamweli ni alhe yaattwanre, yahohimiacha yolha mwaha unopangia alha mahuku alha. ");
INSERT INTO mgh2016_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Malhehano a Nlhuku, aakuminhe awe wo iphiro ya anamilhohi phi awinyu, ni inyu nri nhina yayo malhehano a Nlhuku ayo, aapannge awe ni manyaapwiiya inyu, thoko cheerenlhe aya Aburahimu, ‘Wo iphiro yo iyari inyu, attu onkhaye o velhaponi anoovahiya ibarakha.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Paahi, Nlhuku ahonhihimusha namitheko awe ni wo upacha ahonruma uwaninyu, owiihereni ibarakha wo umpanga kila mmoka inyu arukunuwe ni uhiya uwonya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Napeturo ni Nayohana yaari bado olhumachaka ni attu, opochera ishaani ni nholhelhi a attu olhitelhelha Inupa ya Nlhuku vamoka ni Amasadukayo akina yahowaacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nkayaathunalhacha chinene, ukhalhawaya akarumiya ayo yaari aahimiacheraka attu wiira Yesu ahohihimmwa, mwaha unohimiechesha wiira akhwilhe anohihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Paahi etu, nkayaavara akarumiya nkayaarweha ujeerani. Nansho ukhalhawaya waari uneelhilhe nkayaalhitelhelha mpaka waashelhe waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nansho attu enchi yeewilhe nttenga u Napeturo ni Nayohana yahorumelhelha. Wo waalhakelhiya manyaalhopwana yaarumelhenlhe yaari maelufu nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waashelhe waya, aholhelhi a Ayahudi ni ashulhupalhe ni owiittuchiha Malhehero a ashinna Musa yahothukumana vamoka Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nkayaakumaana ni ashinna Anasi Opochera ishaani Olhupalhe ni Nakayafa ni Nayohana ni Naalekizanda ni akina yaari o nihimo ni a Opochera ishaani Olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nkayeemeshacha Napeturo ni Nayohana uholho, ni waakoha, “Mwaattiva mpannge ulha mwaha ulha wo machiri ani ni wo nchina na apani?” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Vavawo Napeturo anachariye Iphumu ya Nlhuku, nkayaakhulha, “Aholhelhi a attu ni ashulhupalhe! ");
INSERT INTO mgh2016_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yakhalhaka lhelho nnoonikoha mwaha wo ntheko woombone wiireelhe wa ntu o uheeta ni iphiro chilhamme awe, ");
INSERT INTO mgh2016_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","paahi, mwaattiva ni attu onkhaye o Uisraeli nchuwelheke wiira ulha ntu ulha neemelha uholho winyu lhelho, lhamme wo nchina na Yesu Kuristo o Unazareti aakhomelhelhiye vansalaabani ni inyu mwaatti. Nansho Nlhuku ahonhihimusha unookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu phi ulhe Malhove Matakatifu aneera, ‘Nlhuku mwaakhotilhe inyu mwaatti atheki va wiira khaninlhoka, nihokhalha vano nlhuku nulhupalhe no nsingi no ukhulhuvelhiya.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Noopo nopattiya wa iphiro awe vekha, velhaponi wuuthi irimu vonkhaye khaniwo nchina nikina niriyoothe nikumihiye ni Nlhuku wiira ninoopolhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ashulhupalhe o va Ipuwa ayo, ahoshanga woona Napeturo ni Nayohana yuulhumachaka rata, anakhalhaka yaari attu o uhishoma mena irusho chiriyoothe. Nkayaachuwelha wiira yaari vamoka ni Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nansho vamoonne aya ntu aalhamihiye ni Napeturo ni Nayohana ulhe neemenlhe vamoka ni ayo khayoolhumanche ittu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Paahi etu, nkayeerelhiya akhumache vathe. Ni ashulhupalhe o va Ipuwa ayo nkayaahalha mpaani ashineneru apangaka ntemera. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nkayaakohanacha ashineneru, “Naapangekeni etu alha attu alha? Kila ntu nokhalha va Yerusalemu noochuwelha wiira ilha yo ushangiha yulhupalhe ilha ihopangia, ni hii khaninooria uvaanyiha yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nansho wo wiira nitiyelhelhe ulha mwaha ulha uhiiwaniee chinene mwaattuni, naamukeke wiira ahulhumache tho mwaha wo nchina na Yesu wa ntu riyoothe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Paahi etu, nkayeehanacha tho akarumiya mpaani, nkaalhehera wiira ahuulhumache tho voonene, mena wiittuchiha wo nchina na Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nansho Napeturo ni Nayohana nkayaakhulha, “Yakhalhaka ihorera mmiholho wa Nlhuku uwiiwelhelhani mwaattiva upwaha chinomwiwelhelha ihu Nlhuku, nhukumulheke mwaattiva mwaashinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ukhalhawaya hii khaninooria uhiya wulhumacha naachaka mwaha woonilhe ihu ni wiiwa.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Paahi, ashulhupalhe o va Ipuwa ayo nkayaamuka ni waachachera chinene, nkayaahiyerera. Khayoonrie waatwarusha ukhalhawaya attu onkhaye yaari anthimichaka Nlhuku wo nlhatu wo yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ntu aapangelhiye cho ushangiha uyo aari o malhipa o iyaakha chaapwaha makhumi ncheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Vahipinche baada yo uhiyereriya, Napeturo ni Nayohana yahohokolhia wa ashikhunanaya, nkayaahimiachera chilhe chihimiye ni opochera ishaani olhupalhe ni ashulhupalhe chilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Attu onkhaye veewilhe aya yoyo mwaha uyo aholhutaana vamoka unlhapelha Nlhuku wo nrima mmoka akhuwelhaka yiiraka, “Thithi, inyuva phi inyu Muupilhe irimu ni ilhapo ni ibahari ni chittu chonkhaye chiriwo! ");
INSERT INTO mgh2016_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wo iphiro yo Iphumu ya Nlhuku mwahoolhumacha wo iphiro ya anamitheko inyu, apwiiya Adaudi, venre aya, ‘Attu ahiri Ayahudi arushiyeni? Woonaka attu ahopanga miruku cho nshatha? ");
INSERT INTO mgh2016_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mamwene o velhaponi yahokhalha tayari, ni aholhelhi o utawara yahokumaana vamoka, waakhota Athithi ni unkhota Kuristo hikiye makhura.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ukhalhawaya wo ikekhiaye phi chiichammo etu, Naherode ni Apontio Pilato ni attu o Uisraeli ni attu ahiri Ayahudi chaakumanne aya yelha iwani ilha unkhota Namitheko inyu ntakatifu Yesu, munhinke inyu makhura. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yahopanga ittu mwaalhakenlhe inyu ukhuma khalhayi wo wooria winyu ni uttuna winyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nansho vano, inyu Thithi, mwooneke chinera aya wo unoopopiha. Nnikavihereke hiyaano akarumiya inyu wiittuchiha nlhove ninyu wo uhoovaa. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mwookolheke moono inyu mwaalhamihe attu. Mpangeke ithikineha ni cho ushangiha wo nchina na Yesu, Namitheko inyu ntakatifu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yamalhiheke unlhapelha Nlhuku, vakittu vaakumanne aya valhe nkavaatikhinyia, onkhaye nkayachariya Iphumu ya Nlhuku. Nkayaahimiacha nlhove na Nlhuku wo uhoova. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Attu onkhaye yanrumelhenlhe Yesu yaari nrima mmoka ni nnepa mmoka. Khaawo ata mmoka aari ni ittu iriyoothe enshe ukhalha yo vekha awe, nansho yaari akawanaka ittu iriyoothe yaarina aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Akarumiya yahohimiechesha wo machiri menchi uhihimmwa wa Athithi Yesu. Nlhuku nkaavaha ibarakha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Khaawo ntu riyoothe aakwanne, ukhalhawaya attu yaari ni imata ama inupa yahothumihacha ");
INSERT INTO mgh2016_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nkayaarwehelha akarumiya nchurukhu waapantte aya, nkawaakawiya ulhikaana ni kila mmoka chaahuvelha awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ahokhalha Nlawi mmoka o nnenchi o nikosho no Ukipro eehaniya Nayusufu, tho akarumiya yaamwiihana Nabanaba, maana aya, “Ntu o waahelha attu mirima.” ");
INSERT INTO mgh2016_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yoyo chiicho ahothumiha imata awe, nkaakusha nchurukhu ulhe nkaarweha wa akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ntu mmoka eehaniya Ananiya ni ahanu awe Safira ni ayo chiicho yahothumiha imata aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ni ahanu awe ayo achuwelhaka yoyo mwaha uyo, Ananiya ahovitha nchurukhu nkina waapantte aya ni nkina uyo nkaarwa weesha vamietoni wa akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Napeturo nkayaakoha, “Ananiya, woonaka Nakare houhelhani nrima wo unthepiacha Iphumu ya Nlhuku wo uvitha nchurukhu upantte inyu vaathumihilhe inyu imata ilhe? ");
INSERT INTO mgh2016_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Imata vaari aya ihinathumihiya yaari yawinyu, mwathumiheke, nchurukhu uyo waari wawinyu, mwahanaa ikuru yo upangelha chaathanana inyu. Nlhatu waani etu, no ulhakelha munrimani mwinyu upanga chiicho? Khamunthempie ntu, Nlhuku phi nthempie inyu!” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya yeeweke chiicho, nkaawulhuwa vathi nkaakhwa. Attu onkhaye yeeweke yoyo mwaha uyo yahoovacha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nkayaawacha ashimirawo nkayaavilhikelha isaanda ntembo ulhe, nkaarwehiya uuvithiyani. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chavireke isaa taaru, ahanu aya, ahichuwelhaka ittu ikhumelhenlhe, nkayaakelha mpaani mmwe. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Napeturo nkayeerelha, “Nkihimerie, chani, ulha phi nchurukhu wonkhaye upantte inyu vaathumihilhe inyu imata ilhe?” Asafira ayo nkayaakhulha, “Eiyo, phi yoyo wonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Paahi Napeturo nkayeera, “Woonaka mwaatti nhopanga miruku cho ulhikacha Iphumu ya Athithi? Mwiiwelhelheke! Attu arweelhe uwaavithani owannyu alhe, vano ari vankhorani, anouthathani ni inyu chiicho!” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Vahipincheru Asafira nkaawulhuwa vamietoni va Napeturo, nkayaakhwa. Ashimirawo alhe yaweeke, nkayaaphwanya anakhwilhe, nkayaathatha vathe, nkayaavitha wo waatamana ni owannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Attu anrumelhenlhe Kuristo onkhaye ni attu akina yahokelhiya nipampa veewilhe aya yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Akarumiya ahopangacha ithikineha ni cho ushangiha chinchi mwaattuni. Attu onkhaye yanrumelhenlhe Yesu yaari akumaanaka vamoka va ipuwa ya Naselemani. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Khaariwo ntu nkina riyoothe ahaarumelhenlhe aalhikanche uvaraana ni ayo. Anakhalhaka chiicho, attu yahaatotopelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Manyaalhopwana ni manyopani enchi yaarumelhenlhe Athithi ahonchereria munlhokoni mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ni wo mitheko chaapanga aya akarumiya, attu yaari yaarweehaka areta mmaphironi ni waathalhelha mmikorini ni mmattatoni wiira inakhalhaka irungu ya Napeturo yaakhunelhe vanohalha aya uvira. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Attu enchi o iwani chaatamana Uyerusalemu, yahaawiha areta ni attu o mashoka o unanara. Ni ayo onkhaye yaholhamihiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Opochera ishaani Olhupalhe ni akhunanaya o mphingo wa Amasadukayo o vavawo, yahoonelha ihache akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Paahi nkayaavaracha akarumiya, nkayaattuka ujera yuulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nansho uhiyu nnepa wa Athithi nkawaahulha milhako cho ijera, nkaakumiha vathe, nkeerelhacha, ");
INSERT INTO mgh2016_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nrwaacheke mweemelhe Inupa ya Nlhuku mwaahimeriacheke attu mwaha wonkhaye wo ulha ukumi wo naanano ulha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Akarumiya nkayaarumelhelha. Wichishuru nkayaakelha Inupa ya Nlhuku, nkayaachokholha weettuchiha attu. Opochera ishaani Olhupalhe ni akhunanaya yaholhatulha nkutaano mulhupalhe wo ukumaana ni aholhelhi onkhaye a Ayahudi. Nkayaaruma attu ujerani arwee yaawiihe akarumiya alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nansho yayo attu ayo yaphiyeke wowo, khayaapwannye anamitheko ujeerani mmwe. Paahi nkayaahokolhia, nkayaahimiacha wiira, ");
INSERT INTO mgh2016_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Naphiyeke ujerani naaphwannye ijera inatteiye nti ni attu olhita alhitelhelhaka milhako. Nansho nahulheke nlhako khanamphwannye ntu riyoothe mpaani.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Opochera ishaani olhupalhe ni nholhelhi a attu olhitelhelha Inupa ya Nlhuku veewilhe aya yoyo mwaha uyo nkayaashanga ahichuwelhaka mwaha waapantte akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nkaawa ntu mmoka nkeerelha, “Nkeewani mwaatti! Alhe attu yaattunke inyu ujerani alhe, naanano va arii Inupa ya Nlhuku, aneettuchihacha attu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Paahi nholhelhi olhita Inupa ya Nlhuku vamoka ni anamitheko awe nkayaarwaa uwaakushani. Nansho khayaavanre wo machiri, ukhalhawaya yaari yoovaka attu wiira yanaatiya malhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Paahi akarumiya nkayaakushiya ni uwiihiya, nkayeemeshiya uholho vankutaanoni. Opochera ishaani olhupalhe nkayaakoha, ");
INSERT INTO mgh2016_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nahoochiichihani chinene wiira nhiilhehere wo nchina no ulha ntu ulha, nansho mwooneke chinre inyu vano! Nhowanelhiha meettuchiho inyu Uyerusalemu wonkhaye ni unihambulhiha vachulhu iphome awe yolha ntu ulha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Vavawo Napeturo vamoka ni akarumiya akina alhe, nkayaakhulha, “Nlhuku phi ninothananiya ihu umwiiwelhelha hii, kuhiwe ntu. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nlhuku a manyaapwiiya ihu ahonhihimusha Yesu mwankhomelhenlhe inyu vansalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nlhuku a manyaapwiiya ihu ahommwelhiha mpaka wiimonono wawe, nkaakhalha Nholhelhi ni Moopolhi, wiira attu o Uisraeli akhorome, ahiyereriye uwonya waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hiyaano phi o uhimiechesha yoyo mwaha uyo, vamoka ni Iphumu ya Nlhuku anovahiya aya attu anonrumelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Attu onkhaye vankutaanoni vawo, yeeweke yayo, nkayaarushiya chinene, nkayaathanana weeva. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nansho Afarisayo amoka owiittuchiha Malhehero a ashinna Musa aathimichiya chinene ni attu onkhaye, eehaniya Nagamalieli, nkayeemelha uholho vankutaanoni vawo. Nkaalhehera wiira akarumiya alhe akumihiye vathe kaaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yamalheke nkayeerelha attu vankutaanoni valhe, “Aisraeli nanaka, muupuwelheke kaaye nhinaaya upanga yeyo nnothanana inyu waapangelha alha attu alha iyo! ");
INSERT INTO mgh2016_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nnowuupuwelha wiira katashi vakani, ahokhumelhelha ntu mmoka eehaniya Theuda. Yoyo aheepanga orera nrima ni attu yaatameria imia ncheshe yahonttwara. Nansho aheeviya, attu onkhaye yanttwara nkayaamwariacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kaanyuma tho, ikatema yo waalhakelhiya attu ilhe, ahokhumelhelha Nayuda o Ugalilaya. Ni ayo ahaapatta attu o waattwara, nansho ni ayo chiicho nkeeviya, attu yaatwara nkayaamwariacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ni mii vano, kinouhimeriani chiicho wiira nhaapangelhe alha attu alha ittu iriyoothe, mwaahiyeke! Yakhalhaka ulha mwaha aya ulha uchokholhihiye ni ntu, unoomalha uneneru. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nansho yakhalhaka uchokholhihiye ni Nlhuku, mwaatti khannooria waawulhusha, nneephwanyeke mwaanaka ni Nlhuku.” Paahi, nkayaattwara nlhove ni Nagamalieli. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nkayeehana akarumiya alhe va ipuwa, nkayaalhehera wiira yaatiye mikwaju ni waamukiya wiira ahiittuchihe tho wo nchina na Yesu, yamalheke nkayaahiya arwaacheke. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Paahi etu, akarumiya nkayaathama vankutaanoni valhe anateelhiye mirima chinene, ukhalhawaya Nlhuku ahoona wiira ahophwanelhiya wuulhihiya muru wo nlhatu no nchina na Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kila nihuku nkayaathepa weettuchiha attu ni uhimiacha Malhove Orera a Yesu wiira phi Kuristo nhina Inupa ya Nlhuku ni mmanupani mwa attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mahuku o miholho, owiittucha vaari aya athepaka wunchereria, yahokhumelhelha ichuku wa attu yanrumelhenlhe Kuristo, e Iyunani ni alhe yoolhumacha Iebraniya. Ichuku ya attu olhumacha Iyunani yaari woona wiira anankhwelhi aya yaari alhiyalhiyaka vanokawiya aya cholhia cho kila nihuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Paahi etu, akarumiya khumi ni elhi alhe nkayeehana nlhoko wa owiittucha onkhaye, nkayeera, “Khavalhonke hiyaano uhiya uhimiacha nlhove na Nlhuku wiira nichenjeukelhe mwaha wo ukawacha chittu chinhuvelhiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chiicho etu, manyonnihu, mwaathanlheke attu saba munlhokoni mwinyu ahimiecheshiye ukhalha ni nrima woombone, achariye ni Iphumu ya Nlhuku ni wiitimarikha, ni hii ninowaavariha yoyo ntheko uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nansho hiyaano, ninoohalha nivaraka ntheko wo unlhapelha Nlhuku ni ntheko wo uhimiacha Nlhove na Nlhuku ikatema yonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yoyo mwaha uyo wahaachivelha nkutiro wa attu onkhaye anrumelhenlhe Yesu. Nkaathanlhiya Stefano, ntu o nrima chinene aachariye ni Iphumu ya Nlhuku ni Filipo ni Prokoro ni Nikanori ni Timoni ni Parmena ni Nikolao aari Nyahudi o Uantiokiya, eettuchilhe idini ya Ayahudi ikatema imoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Attu yaathanlhiye alhe nkayeemeshiya uholho wa akarumiya. Vaamalhinhe aya unlhapelha Nlhuku, nkayeesheriya miono. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nlhove na Nlhuku nkanaathepa uwanelha ni owiittucha o Uyerusalemu yaarumelhelha yahonchereria chinene. Mphingo mulhupalhe wa opochera ishaani wahopisha nrima ni unrumelhelha Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nlhuku ahaavaha Nastefano nnema mwinchi ni machiri menchi ata nkayooniha ithikineha ni cho ushangiha iriyari ya attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nansho attu akina o inupa yo unlhapelha Nlhuku imoka yeehaniya “Inupa yo Ulhapelha ya Aneethi,” vamoka ni Ayahudi yaakhumme Ukirene ni Ualekizanderiya aalhapelha mwommo ayo ahovaanyihana ni Nastefano. Akina tho, yaakhumme Ukilikiya ni Uasiya wiikaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nansho khayoriye ukhalhawaya Iphumu ya Nlhuku ahaavaha Nastefano irusho cho wooriha voolhumacha aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Paahi etu, nkayaahonga attu akina yulhumache wiira, “Nihomwiiwa Stefano olhumachaka malhove o waaruwana ashinna Musa ni unhambulhacha Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wo yeyo iphiro iyo etu, yahaathunalhiha attu ni ashulhupalhe ni owiittuchiha Malhehero a ashinna Musa. Paahi, nkayaavara Nastefano, nkayaarweha wi Ipuwa yo milhatu yuulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nkayaawiiha va Ipuwa vawo attu o uhimiechesha wo woothacha yeerilhe, “Ulha ntu ulha khanohiya mena wulhumacha malhove o uhambulha Inupa takatifu ya Nlhuku ni uruwanakacha Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ukhalhawaya nahomwiiwa eeraka eti yoyo Yesu o Unazareti uyo noophomolha Inupa ya Nlhuku ilha ni urukunusha malhemalhelho nipochenre ihu wa ashinna Musa.” ");
INSERT INTO mgh2016_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Attu onkhaye yaari va Ipuwa valhe nkayaakumiha miitho waaweha Nastefano, nkayoona ikhove aya inari thoko yo nnepa wo wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Paahi, Opochera ishaani Olhupalhe nkayaakoha Nastefano, “Chani, yolha mwaha ulha we ikekhiaye?” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nkayaakhulha, “mwaatti, ashilhoko aka, nkakiiwelhelheni! Nlhuku o nthimicho ahaakhumelhelha apwiiya Aburahimu vaari aya Umesopotamiya ahinaya urwaa ukhalhani Uharani. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nkeerelha, ‘Nthame wiilhaponi winyu, mwaahiyeke ashilhoko inyu, nrweeke ilhapo inohalha aka uwoonihani.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Paahi etu, Aburahimu nkayaathama ilhapo yo Ukaldayo, nkayarwaa uukhalhani Uharani. Athumwanaya arimeelheke, Nlhuku ahaathamiha tho Uharani nkayaawa uukhalhani ilha ilhapo nnokhalha inyu vano ilha. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nlhuku khaavanhe inakhalha ikipande imoka yo ilhapo ilha ikhalhe yawaya, inakhalhaka chiicho, ahaalheha waavaha ilha ilhapo ilha ikhalhe yawaya ni iyari aya, inakhalhaka yeyo ikatema iyo Aburahimu khayaarina mwaana. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nlhuku olhumachilhe cho, ‘Iyari inyu inoorweehiya ilhapo ya amalhaponi ni wowo anokoopangiya ipotta ni upangelhiya chittu cho uhilhoka wo iyaakha imia ncheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nansho mii kinowaahukumulha attu o yeyo ilhapo inohalha waapanga ipotta iyo, Nlhuku phi neera awe. Yamalhaka kinowaathamiha yeyo ilhapo iyo wiira awe yaakilhapelha va vakittu va.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yamalheke, Nlhuku aheenelha unyawo Aburahimu ukhalha phi malhehano aya. Aburahimu ni ayo nkayamwiinelha mwaamwanaya Isaka nihuku no nane toka ayariekeru. Ni Naisaka chiicho, yahenelha Nayakhobo. Chiicho etu, Nayakhobo yahenelha unyawo manyaapwiiya ihu khumi ni elhi alhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Manyaapwiiya alhe nkayaamwonelha ihache mwanhimaya Yusufu, nkayanthumiha wiira akhalhe ipotta Umisri. Nansho Nlhuku aari vamoka ni uyo, ");
INSERT INTO mgh2016_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nkaamwoopolha mu uhuvani mwawe mwonkhaye. Nlhuku ahonvahera nnema wo nrima woombone ni irusho, ata vaaphilhe awe u Nafarao amwene o Umisri nkaapangiya ni Nafarao ukhalha o weemelhelha ilhapo ilhe ni inupa ya amwene. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Paahi nkayaakelha ikuruna ilhapo yonkhaye yo Umisri ni Ukanaani, yaahuvinhe chinene. Manyaapwiiya ihu khayoonrie upatta yolhia iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nayakhobo yeeweke wiira chihawo cholhia Umisri uwo, yahaaruma achishaana aya, yaani manyaapwiiya ihu, arwee Umisri wo nkwaha wo upacha athume cholhia. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nkwaha aya wo nayelhi, Nayusufu nkayeechuwelhiha wa manyonnaya ni Nafarao nkayaachuwelhacha ashilhoko aya Nayusufu. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Paahi etu Nayusufu yahoruma nttenga wo weehana Nayakhobo athumwanaya ni ashilhoko aya onkhaye, aaphiyelha attu makhumi saba ni nthanu wiira awe Umisri. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Chiichammo etu, Nayakhobo yahorwaa Umisri, waarimenlhe aya ni manyaapwiiya ihu akina. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mitembo chaya chahokushiya mpaka Ushekemu, nkachaavithiya nnihiyeni mwooponlhe aya Aburahimu ukhuma nikosho na Ahamori.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ikatema yaayekeru Nlhuku wo utimiriha malhehano eerenlhe awe Aburahimu, attu yaari Umisri ulhe yahonchereria chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yamalheke, mwene mmoka ahaachuwenlhe Nayusufu ahochokholha utawara ilhapo yo Umisri. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ahaapangelha attu ihu ushilhilhi, ni waapangelha chittu cho uhilhoka manyaapwiiya ihu wo waakhanyereriha yaarihe vathe achishaana aya ashikaani wiira akhwaache. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Yaari phi ikatema vaayarelhe aya ashinna Musa, akhalhaka mwaana o urera chinene. Nkayaalhelhiya uwani wo mieri miraru unupani wa apwiiya awe, ");
INSERT INTO mgh2016_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ata vaathamihiye aya naarihiya umolhokoni, abiti Farao ahaakusha, ni waalhelha thoko mwaana aya onnyara anene. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ashinna Musa nkayeettuchihiya uchuwelha irusho chonkhaye cha attu o Umisri, nkayaapenya wo wooria wulhumacha ni uvara mitheko. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ashinna Musa vaari aya ni malhipa o iyaakha makhumi ncheshe yaholhakelha munrimani wiira arwee oone ashilhoko aya Aisraeli cheera aya wo utwarushiya ni attu o Umisri. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wowo yahomwoona mu Israeli mmoka apangelhiyaka ittu yo uhilhoka ni Mmisri. Nkayaamwaakiha ni uhokolhoshera wo umwiiva Mmisri ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yaari aanyiheraka wiira Aisraeli ashilhoko aya yanchuwelha wiira Nlhuku haaruma wiira opolhe, nansho khayachuwenlhe chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Waashelhe waya yahoona Aisraeli elhi yaana indewo, nkayaalhikacha waathaniha eeraka, ‘Mwaattiva attu o nlhoko mmoka, nnopangelhana chittu cho uhilhoka mwaashineneru?’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nansho ulhe ampangelha ittu yo uhilhoka nkhunanawe ulhe nkaakakha ashinna Musa uchereshere eeraka, ‘Phi mpani oweensheni inyuva ukhalha nholhelhi o unihukumulha hii? ");
INSERT INTO mgh2016_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Chani, nnothanana ukiiva thoko chaamwiivilhe inyu Mmisri ulhe nchana valhe?’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ashinna Musa yeeweke chiicho yahottawa nkayarwaa uukhalhani ilhapo yo Umidiani ni wowo nkayaapatta ashaana elhi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Iyaakha makhumi ncheshe chatimireke, nnepa wo wiirimu wa Athithi wahaakhumelhelha ashinna Musa va ithuphi yaapharelha mooro uthakoni waatamana mwaako wo Usinai. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ashinna Musa yahoshanga chinene voona aya yeyo ittu iyo, nkayaachushera vakhiviru wiira athurumelhe, nansho nkayeewa nlhove na Athithi, ");
INSERT INTO mgh2016_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mii phi Nlhuku a manyaapwiiya inyu ni Nlhuku a Aburahimu ni Nlhuku a Naisaka ni Nlhuku a Nayakhobo!’ Ashinna Musa nkayaathukumelha wo woova ni mena khayonrie uweha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Athithi nkayeerelha, ‘Nrulhe iratu chinyu ukhalhawaya va vaneemelha inyu va phi vakittu vatakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kihoona chittu cho uhilhoka chinopangelhiya aya attu aka Umisri. Kiheewa ikutto aya ni mii kihowa woopolhani. Paahi vano, kinourumani nrwee Umisri.’” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ashinna Musa ayo phi alhe yaakhotiye Umisri ni attu o Uisraeli yenre, ‘Phi mpani oweensheni inyuva ukhalha nholhelhi o unihukumulha hii?’ Nlhuku ahaaruma yayo ashinna Musa ayo ukhalha aholhelhi ni moopolhi wo iphiro yo nnepa waakhumelhenlhe aya ithuphi vaapharelha aya mooro uthakhwani. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Phi yayo yaholhenlhe attu alhe akhume Umisri wo upanga ithikineha ni cho ushangiha, Umisri ni ubahari yo Shamu ni uthakoni iyaakha makhumi ncheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ashinna Musa phi erenlhe attu o Uisraeli, ‘Nlhuku nouthanlhelhani namilhohi thoko chikirumilhe awe mii, ukhuma munlhokoni mwinyu mwaashinene.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Attu o Uisraeli vaathothokanne aya uthakoni, ashinna Musa yaari wowo vamoka ni ashulhupalhe ihu, ni nnepa waholhumacha ni ayo umwaakoni Usinai ulhe. Phi yayo yaapochenre malhove annivaha ukumi alhe anivahe hiyaano.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nansho manyaapwiiya ihu yahokhota weewelhelha, nkayaakakhelha uchereshere, mirima chaya nkachaathanana uhokolhia Umisri. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nkayeerelha Naharuni, ‘Nnikooroshelhe milhuku chinohalha uniholhelha. Ukhalhawaya khanichuwenlhe chaapantte ashinna Musa anithaminhe ilhapo yo Umisri!’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Yeyo etu phi ikatema vaakoronshe aya isinyago yo mwannama, nkayaakumihera isadaka, ni uttapelhelha ittu ikooronshe aya ashinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nansho Nlhuku ahorukunuwa nkaathama iriyari aya, nkaahiya athimiche ittotwa cho wiirimu, thoko chilhepiye aya nkitaabuni mwa anamilhohi a Nlhuku, ‘Mwaatti attu o Uisraeli! Akihiwe phi mii mwaakihithenlhe ashinama ni ukivaha isadaka wo iyaakha makhumi ncheshe uthakoni ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwaattiva mwahokusha nihema na nlhuku Moleki, ni isinyago yo ittotwa ya nlhuku inyu Refani. Mwaathimicha isinyago chaapanganche inyu. Wo yoyo nlhatu uyo kinourweehani upottani utayi uvira Ubabeli!’ ");
INSERT INTO mgh2016_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Manyaapwiiya ihu yahokoorosha Nihema na Nlhuku no uhimiechesha wiira ri variyari aya uthakoni ulhe. Naakoroshiye thoko Nlhuku chaalhehenre aya ashinna Musa wiira apangache, nilhikaanaka thoko nne noonihiye aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yamalheke manyaapwiiya ihu yahopocherana Nihema ashineneru mpaka ikatema i Nayoshua, vooponlhe aya ilhapo ukhuma wa amalhaponi omonlhe awe Nlhuku umiholho waya. Vavawo naholhokelha mpaka ikatema ya Adaudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Adaudi yahottuniya chinene ni Nlhuku, nkayanvekelha nipesha no utheka nipuro no ukhalha Nlhuku a Nayakhobo. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nansho yanthekenlhe Nlhuku inupa yaari Naselemani.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Inakhalhaka chiicho, Nlhuku Mulhupalhe khanokhalha inupa chithekiye na attu, thoko namilhohi a Nlhuku chineera awe, ");
INSERT INTO mgh2016_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Athithi aneera, ‘Irimu phi machokholhelho o Imwene aka ni ilhapo phi nipitinkwa naka no waathalhelha mieto. Inupa thoko phivi nnohalha inyu ukithekelha? Iri vayi ihiche aka o ukhalhelha? ");
INSERT INTO mgh2016_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mii vekha aka phi upilhe chittu chonkhaye chi.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nastefano nkayaathepa wiira, “Inyu mwaatti o vaanyiha va! Mirima chinyu ni maaru inyu ari thoko attu o mwiilhaponi ahinchuwenlhe Nlhuku. Nrii thoko manyaapwiiya inyu. Mahuku onkhaye nnonvinga Iphumu ya Nlhuku! ");
INSERT INTO mgh2016_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Chani hawo namilhohi a Nlhuku riyoothe hihuvihachiye ni manyaapwiiya inyu? Yaheevakacha attu yaarumiye ni Nlhuku wiira ahimiache uwa wawe uyo ri Karumiya e Ikekhiaye uyo. Ni uyo vano, nhonthumiha nkamwaamwiiva. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwaatti mwahopochera Malhehero a Nlhuku yaawiihiye ni minepa, nansho khamwaarumelhenlhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ashulhupalhe veewilhe aya, yahothunalha chinene, nkayaakhuura miino wo nlhatu no urushiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nansho Nastefano anachariye Iphumu ya Nlhuku, ahoweha wiirimu, nkoona nthimicho wa Nlhuku ni Yesu neemenlhe wiimonono wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nkayeera, “Mwooneke! Kihoona irimu chihohulhiya ni Mwaana a Ntu howeemelha wiimonono wa Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Attu onkhaye va Ipuwa vawo, ahotiyelha maaru aya wo makokho nkayaakhuwelhacha. Paahi, attu onkhaye nkayaathuphelha Nastefano, ");
INSERT INTO mgh2016_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","nkayaapurulhelha uchereshere iwani ni uwaata malhuku. Attu yaahimiechesha ayo, nkayaarulhacha miinjiro chaya ni ummaha mmirawo mmoka eehaniya Sauli wiira alhitelhelhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Vaatiya aya malhuku, Nastefano yaari yaalhapelhaka Athithi nkayaamumulha eeraka, “Thithi Yesu, nrima aka!” ");
INSERT INTO mgh2016_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nkayaakhoroma, nkayaakhuwelha, “Thithi, nhaalhakelhe uwonya waya ulha!” Olhumacheke chiicho, nkayaarimeelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauli aari vavawo ni uyo ahorumelhelha wiiviya wa Nastefano. Nenno nihuku attu anrumelhenlhe Kuristo Uyerusalemu yahochokholha utwarushiya chinene. Attu onkhaye, ahikhalhe akarumiya, ahomwariacha nkayaattawelha mmamatani ilhapo cho Uyudea ni Usamariya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Attu anthimicha Nlhuku yahakusha ni waavitha Nastefano ni wonlhelha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nansho Sauli aholhikacha waatwarusha attu anrumelhenlhe Kuristo, wo urwaa kila inupa. Nkaapurulhacha attu vathe, manyaalhopwana ni manyopani, nkaatikhelha ujeerani. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Attu yaamwarianche alhe, kila waattawenlhe aya yahohimiacha Malhove Orera wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Nafilipo aarweelhe iwani yo Usamariya ni waahimiachera attu wiira Yesu phi Kuristo aathanlhiye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Attu aheewelhelha rata nttenga u Nafilipo uyo, ni woona cho ushangiha chaapanga aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mashoka o unanara yahaakhuma attu enchi akhuwelhachaka, ni attu enchi o uremaracha aholhamihiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iwani yonkhaye yahoteelhiya chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Paahi etu yeyo iwani iyo ahaawo ntu mmoka nkhwiri eehaniya Simoni. Yoyo aari aashangihaka attu o ilhapo yo Usamariya, nkeechoona ukhalha ntu ochuwania. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Attu onkhaye o akani o uhichuwania ni attu o olhupalhe o nhakhu, yahomwiiwelhelha rata yiiraka, “ashinna Simoni phi machiri a Nlhuku aneehaniya ‘Machiri Molhupalhe.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yaachivelhiya chinene ukhalhawaya ukhwiri waya wahaashangiha attu wo iyaakha chinchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nansho vaarumelhenlhe aya nttenga u Nafilipo waahimia Malhove Orera o Imwene ya Nlhuku, manyaalhopwana ni manyaathiyana yahobatiizachiya wo nchina na Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ata Simoni mwanene ahorumelhelha, abatiiziyeke, aari attukanaka ni Nafilipo, ashangaka chinene ithikineha ni cho ushangiha chaapaangiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Akarumiya yaari Uyerusalemu alhe, veewilhe aya wiira attu o Usamariya ahopochera nlhove na Nlhuku, yahaaruma Napeturo ni Nayohana urwaa wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Vaaphilhe aya nkayaalhapelhelha attu wiira ampochere Iphumu ya Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ukhalhawaya yeyo ikatema iyo Iphumu ya Nlhuku khaari anankhuruwelhe ntu riyoothe munlhokoni mwaya, yaari ahowiiraka ubatiiziyaru wo nchina na Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Paahi etu, Napeturo ni Nayohana nkayeesheracha attu miono, nkayampochera Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni nkaachuwelha wiira wo weesheriya miono ni akarumiya, attu yahovahiya Iphumu ya Nlhuku. Paahi nkaakumiha nchurukhu athananaka waahonga Napeturo ni Nayohana ");
INSERT INTO mgh2016_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","eeraka, “Nkivaheke ni mii ikuru iyo ikhalhe wiira vanohalha aka umweeshera miono ntu riyoothe, ampochere Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nansho Napeturo nkayaakhulha, “Mpotereke uwo, ni nchurukhu inyu, ukhalhawaya nnaanyihera wiira nnowooria uthuma ikuru ya Nlhuku wo nchurukhu! ");
INSERT INTO mgh2016_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Khanrina ittu munthekoni mwihu ukhalhawaya nrima inyu uhowonya mmiithoni mwa Nlhuku ");
INSERT INTO mgh2016_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","paahi etu, nkhoromeke nhiyeke uwonya winyu, mwaalhapelheke Athithi anowooria ulhevelhelhani irusho chinyu thoko yayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ukhalhawaya kihoona wiira nhochariya ihache ni uttukiya mu unanarani!” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nasimoni nkayaakhulha Napeturo ni Nayohana, “Nkilhapelheke wa Athithi wiira, nihikipatte no uhilhoka niriyoothe wo yayo malhove muulhumanche inyu ayo.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Napeturo ni Nayohana yamalheke uhimiechesha nttenga wa Athithi, yahohokolhia Uyerusalemu. Vaahokolhia aya, ahovira ahimiachaka Malhove Orera iwani chinchi cho Usamariya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nnepa wa Athithi nkawolhumacha weerelha Nafilipo, “Mwiirehelhelheke nrweeke iphiro cho uthakoni, iphiro inokhuma Uyerusalemu ukhelha Ugaza.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Paahi etu, Nafilipo nkayaakhalha rata, nkaachokholha nkwaha. Yeyo ikatema, ahaawo ntu mmoka nholhelhi mulhupalhe o Uithiopia aheechooria mpaani. Yoyo aari akhumaka Uyerusalemu unthimichani Nlhuku ahokolhiaka Uithiopia waavara awe ntheko mulhupalhe wo ushunga nhakhu wa apwiyamwene Nakandake, apwiyamwene o Uithiopiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nkukuta waawenlhe awe waari wo upurulhiya ni ashinama. Nkaamwiiwa ashomaka wo nlhove ikitabu ya anamilhohi a Nlhuku ashinna Isaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iphumu ya Nlhuku nkeerelha Nafilipo, “Nrweeke unovira aya nkukuta uyo mwaattwareke.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nafilipo nkayaattimakelha nkukuta uyo, kayaamwiiwa ntu o pilhi uyo ashomaka ikitabu ya anamilhohi a Nlhuku ashinna Isaya. Nafilipo nkayankoha, “Chani nhochuwelha ittu inoshoma inyu iyo?” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ntu o pilhi uyo nkaakhulha, “Kinaachuwelheke chani wo uhiittuchihiya ni ntu?” Paahi nkayeehana Nafilipo wiira awelhe munkukutani mmo amwiittuchihe. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nlhako waashoma awe waari Malhove Matakatifu eera, “Aari thoko ikhondoro yaarweehiya uuhithiyani, inamaanlhe thoko mwaakhondoro vanothikilhiya awe mapururu, khaapatakunlhe malhaku awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ahoolhihiya muru ni woonelhiya. Khaawo nolhoha uhukumulha mwaha wo iyari awe, ukhalhawaya ukumi awe uhothamihiya velhaponi va.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ntu o pilhi o Uithiopia uyo nkaalhepelha Nafilipo, “Nkihimerieke, anamilhohi a Nlhuku alha anomwaacha mpani? Aneera echaachaka anene ama anomwaacha ntu nkina?” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Paahi etu, Nafilipo nkayaapatakulha malhaku aya wulhumacha, ni uchokholhaka ni yoyo nlhako wo Malhove Matakatifu uyo, yahohimiacha Malhove Orera a Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nkwaha vaathepa aya, yahophiya vakittu vaari ni maashi, ni ntu o pilhi uyo nkeera “Maashi alha vaa, chani, ittu yaani inohalha ukihiiha wiira kihibatiiziye?” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ntu o pilhi uyo nkaakhulha, “Eiyo, kihorumelhelha wiira Yesu Kuristo phi Mwaana a Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Paahi etu nkaalhehera nkukuta uyo weemeshiye. Onkhaye, Nafilipo ni ntu o pilhi uyo nkayaakhuruwa mmaashini, ni Nafilipo nkayambatiiza. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Vaakhuma aya mmaashini, Iphumu ya Athithi nkawaakusha Nafilipo. Ntu o pilhi ulhe khoonne Nafilipo tho, nansho nkaawelha munkukutani mwawe ateelhiyaka chinene munrimani. ");
INSERT INTO mgh2016_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nafilipo nkayeephwanya anari Uazoto, nkayaavira iwani chonkhaye ahimiachaka Malhove Orera mpaka nkayaaphiya Ukaisariya. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Yeyo ikatema iyo, Sauli ahothepiha ushilhilhi wo weeva owiittucha a Athithi. Nkaarwa wa Opochera ishaani Olhupalhe, ");
INSERT INTO mgh2016_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nkaalhepelha iwarakha yo unchuwelhiha Udameski, wi inupa cho unlhapelha Nlhuku cha Ayahudi wiira aaphwanyaka wowo attu anaarumelhelha Athithi aavare ni waawiiha Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Vaari awe mphironi aatameriaka uphiya Udameski, nchakarimia no wiirimu nahommwalhelha uno ni uno wo gafula, ");
INSERT INTO mgh2016_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","nkaawulhuwa makukhu vathi, nkeewa nlhove neera, “Sauli, Sauli woonaka unookitwarusha?” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli nkaakoha, “Thithi, Inyuva phi apani?” Nkaakhulhiya, “Mii phi Yesu unokitwarusha va. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nansho weemelheke vano, urweeke vawani, wowo unokoohimeriya ittu yo upanga.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Attu yaari munkwahani vamoka ni Sauli ayo, nkayeemelha wo uhikhalha ni nlhove niriyoothe, eewaka nlhove nansho ahimwoonaka ntu noolhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli nkonkwa vathi vawo, vaapatakulha awe miitho khoonne ittu iriyoothe. Nkaavariya moono mpaka Udameski. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli ahokhalha mahuku mararu hoonaka, hilhiaka mena uwuria ittu iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wowo Udameski uwo, ahaawo owiittucha mmoka eehaniya Ananiya. Nkaahimeriya ni Athithi muntorani wiira, “Ananiya!” Nkayaakhulha, “Thithi, phi mii vaa.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Athithi nkayeera, “Mwiichesheke rata, nrweeke iphiro ineehaniya Iphiro yo wookokwaa. Mwaphiyaka unupani u Nayuda mwankoherereke ntu mmoka o Utaso neehaniya Sauli. Nnokomphwanya anlhapelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ntorani, Sauli nkaamwona ntu eehaniya Ananiya akelhaka mpaani mwaari awe ni umweeshera miono wiira awehe tho.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya nkaakhulha, “Thithi, kiheewa attu enchi ahimiachaka mwaha wo uhilhoka waapangelha awe atakatifu inyu Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ni uyo howa vaa ni ikuru ya opochera ishaani olhupalhe yo waavara attu anlhapelha wo nchina ninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Athithi nkayeera, “Nrweeke tu, ukhalhawaya kihonthanlha wiira akhalhe karumiya aka, ahimiache nchina naka wa attu ahiri Ayahudi ni mamwene aya ni wa attu o Uisraeli. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mii kimwanene kinoomwooniha chittu chinchi chinohalha untwarusha wo nlhatu wo nchina naka.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Paahi Ananiya nkayaarwaa mpaka yeyo inupa iyo. Nkaamweeshera Sauli miono chaya nkayeera, “Alhoko aka Nasauli, Athithi arii phi Yesu Kuristo, anene okhumelhenlheni mphironi mmwaaka, ahokiruma wiira mpatte woona tho ni ucharihiya Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wo uhipicha chittu thoko makakahapa nkachaamora mmiithoni mwa Sauli, nkaaweha tho. Nkeemelha nkaabatiiziya. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Vaamanlhe aya ulhia yolhia, machiri nkayanhokolhelha. Nasauli nkayaakhalha wo mahuku vakani vamoka ni owiittucha Udameski. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nkayaarwaa inupa cho unlhapelha Nlhuku cha Ayahudi nkaachokholha uhimiacha wiira Yesu phi Mwaana a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Attu onkhaye yeewilhe yahoshanga, nkayeera, “Chani, ulha ntu ulha kahiwe phi yoolhe eeva attu yaalhapelha wo nna nchina nna Uyerusalemu ulhe? Ni va aawilhe athananaka waavara yayo attu ayo aarweehe wa attu opochera ishaani olhupalhe?” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nasauli nkayaathepa upatta machiri, ni wo iphiro chaahimiechenshe aya wiira Yesu phi Kuristo thanlhiye ni Nlhuku, Ayahudi o Udameski khayari ni nlhove no uwaakhulha. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Avireke mahuku menchi, Ayahudi yahokumaana ni upanga miruku cho weeva Nasauli. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Uthana ni uhiyu yaari alhitiyaka mmamilhakoni mwo ukelhelha vawani wiira yeeviye. Nansho Nasauli yahochuwelha chechiyo miruku chaya chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Uhiyu owiittucha ashikhunanaya yahaakusha, nkayaatemulha ishiri yaarukureria iwani iyo nkayaakurusha vathe anari nhina ichikapu yuulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli ahokolhieke Uyerusalemu yaholhikacha uvaarana ni owiittucha alhe. Nansho onkhaye yaari oovaka ni uhirumelhelha wiira ni uyo hokhalha vano owiittucha a Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Vavawo, Nabanaba nkayaawa nkayaakusha Sauli, nkanrweha wa akarumiya ni waahimeria chenre awe Sauli wo woona Athithi mphironi nkayaarerihana. Tho chaachokhonlhe awe Sauli uhimiacha nchina na Yesu wo uhoova Udameski. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Paahi etu Sauli yahokhalha vamoka ni akarumiya nkayeetakacha ilhapo yonkhaye yo Uyerusalemu ahimiachaka wo machiri nlhove na Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tho, ahohimiacha ni uvaanyihana Ayahudi anoolhumacha Iyunani. Nansho ni yayo manyaattu ayo yaholhikacha weeva Sauli. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nlhoko wa attu yanrumelhenlhe Yesu alhe yachuwelheke yoyo mwaha uyo, nkayankusha Sauli, nkayanrweeha iwani yo Ukaisariya, nkayaahiya wiira arwee Utaso. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yeyo ikatema iyo attu anrumelhenlhe Kuristo onkhaye, Uyudea ni Ugalilaya ni Usamariya yahokhalha mumpuhani. Wo Iphumu ya Nlhuku, attu ahohelhiya nrima ni wunchereria aathimichaka Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Napeturo vaari aya munkwahani aviraka kila vakittu, nihuku nimoka yahophiya wa atakatifu anrumelhenlhe Kuristo yaakhalha Ulida. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wowo yahomphwanya ntu mmoka eehaniya Naenea, aari vanlhilhini wo iyaakha nane wo uririiya iruttu. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Napeturo nkayeerelha, “Naenea, Yesu Kuristo noulhamihani. Munkweke mwaathalheke ikori inyu.” Vavawovavawo Naenea nkayonkwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Attu onkhaye yaakhalha Ulida ni Usaroni vonne aya Naenea, onkhaye yahaarukunuwelha Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ahokhalha owiittucha amoka opani iwani yo Uyafa ehaniya Atabitha we nulhumo ne Iyunani yeehaniya, Adorkasi, ilhamulhiyaka, “Nachoro”. Yayo apwiyawe ayo yaari apangaka mitheko chorera cho waakavihera amashikini iyaakha chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yeyo ikatema iyo yahowereiya, nkayaarimeelha. Attu nkayaarapiha ntembo aya, nkayaathalhelha uchuumbani ugoroofani. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Uyafa ni Ulida chaari iwani cho waatamana chinene, paahi etu, owiittucha veewilhe aya wiira Napeturo arii Ulida, nkayaaruma attu elhi waarwehelha nttenga, “Mmwe uwanihu chitema chinooria inyu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Paahi, Napeturo nkayaattukana vamoka attu ayo. Yaphiyeke nkayaarwehiya ichuumba yo nchulhu ugoroofani. Wowo anankhwelhi enchi yahaarukureria Napeturo yunlhaka ni wooniha miinjiro ni ikuwo chaatottiye ni Adorkasi ikatema vaari aya akumi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Napeturo yaheerelha attu onkhaye akhume vathe, nkayaakhoroma, nkayanlhapelha Nlhuku. Yamalheke nkayaarukunuwelha ntembo ulhe, nkayeera, “Atabitha, munkwe.” Atabitha nkayaapatakulha miitho aya. Vonne aya Napeturo, nkayaakhalha. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Napeturo nkayaavara moono nkayeemesha, nkayeehana atakatifu anrumelhenlhe Yesu ni anankhwelhi alhe, nkayooniha wiira arii akumi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yoyo mwaha uyo nkawawanelha Uyafa uwo ni attu enchi nkayaarumelhelha Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Napeturo yaholhokelha Uyafa wo mahuku menchi, nkayaakhalha uwani wa ntu mmoka o uwamba marapalha ehaniya Simoni. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ahokhalha ntu mmoka Ukaisariya eehaniya Konelio, nholhelhi o mphingo wa manyaasikari weehaniya, “Mphingo wo Italiya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Aari ntu orera nrima, uyo vamoka ni inupa awe onkhaye yaakhalha wo unthimicha Nlhuku, apangachaka menchi o waakavihera amashikini, anlhapelhaka Nlhuku ikatema chonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nihuku nimoka vaaphiyelha aya saa tisa uthana, ahoona itora, nnepa wo wiirimu wa Nlhuku ukelhaka mpaani ni weerelha, “Nakonelio!” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nakonelio nkayaaweha nnepa wo wiirimu ulhe chinene yoovaka, nkayeera, “Munna, urini?” Nnepa wo wiirimu uyo nkaweerelha, “Nlhuku hoteelhiya ulhapelha ni isadaka chinaavaha inyu amashikini. Nowuupuwelha mena khanolhiyalhani. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vano etu, mwaarumeke attu Uyafa yamwiihane ntu mmoka neehaniya Simoni, wo nchina nikina Peturo. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yayo arii uwani u Nasimoni o uwamba marapalha, inupa aya iri vachereshere ibahari.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nnepa wo wiirimu wathameke, Akonelio nkayeehana akarumiya elhi aavara ntheko wo mpaani ni mmoka a olhita aya anthimicha Nlhuku, ");
INSERT INTO mgh2016_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","nkaahimeria chonkhaye chikhumelhenlhe, nkaaruma Uyafa. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Waashelhe waya, vaaphiyelha aya uthana, nchuwa variyari, yayo attu araru ayo anari munkwahani yaatameriaka Uyafa, Napeturo yahowelha uchulhu inupa wiira yanlhapelhe Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nkayaawolhiya ithalha, athananaka ulhia yolhia. Yolhia vaari aya iterekhiyaka, nkayoona itora. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nkayoona irimu inahulhiye ni ishuka yuulhupalhe ikurushiyaka vathi inavarelhiye malhuto aya macheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ashinama onkhaye yaari nhina ishuka mmo, ashinama o mieto micheshe, anaakooko ni ashinuni o uchulhu wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nkayeewa nlhove neerelhaka, “Napeturo, munkwe nhitheke, nlhieke!” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Napeturo nkayaakhulha, “Mena, Thithi, miyaano khakinalhawiha mena ittu iriyoothe yo unyalha ama yo unanara.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nlhove nne nkaneewaniaa nkwaha wo nayelhi tho neerelhaka, “Nhiihane ukhalha cho unyalha chittu chirerihilhe awe Nlhuku ukhalha chitakatifu!” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yoyo mwaha uyo wahopangia mikwaha miraru. Yamalheke ikuwo ilhe nkayaahokushiya wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Napeturo vaari aya anoomiye uwanoni oopuwelhaka yeyo itora yoonilhe aya iyo, attu yaarumiye ni Akonelio alhe yahophiya uwani u Nasimoni. Nkayaachushera vanlhakoni ");
INSERT INTO mgh2016_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nkayeehana ni ukoha, “Chani, ahawo alheto momu aneehaniya Simoni Peturo?” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Napeturo anari alhikachaka wuupuwelha itora ilhe, vavawo Iphumu nkayeerelha, “Mwiiweke! Ahowa attu araru va, anowaaviani. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nkhuruweke chitema mena nhoone nipampa waattukana, ukhalhawaya phi miyaano kaarumilhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Napeturo nkayaakhuruwa vathi, nkayeerelha attu alhe, “Anaavia inyu ayo, phi mii. Mmwanne nlhatu waani?” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ni attu ayo nkayaahimiechesha wiira, “Nakonelio aholhelhi a manyaasikari ri ntu orera nrima, nonthimicha Nlhuku nolhohiya ni Ayahudi onkhaye, ahoniruma uwaninyu. Hohimeriya ni nnepa ntakatifu olhalhieni uwannyawe wiira ewelhelhe iriyoothe inohalha inyu wulhumacha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Napeturo nkayaapochera alheto aya alhe, nkayaaveria vakittu vo urupa uhiyu uyo. Waashelhe waya, Napeturo nkayaachokholha nkwaha aattukanaka nlhoko wa attu alhe ni attu akina o Uyafa. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nihuku no nayelhi yahophiya Ukaisariya. Wowo Akonelio yaari yaawereraka alhoko aya ni vamoka manyampwana aya o uthepa yaalhalhelhe aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Napeturo vaari aya aphiyaka, Nakonelio yahokhuma weekamelhani vathe, nkayaakhoromelha ni wooroma mpaka vathi. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nansho Napeturo nkayeemesha, nkayeerelha, “Mweemelhe, ni mii ki ntu thoko inyuva.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Napeturo nkayaathepa waareriha ni Nakonelio vaakelha aya mpaani mwaaphwannye aya attu enchi anathothokanne. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Napeturo nkayeerelha, “Mwaattiva mwaashinene nnoochuwelha wiira Nyahudi riyoothe hochiichihiya ni ikekhia awe uphakana ni alheto, attu ahiri Ayahudi. Nansho Nlhuku hokihimeria wiira kihimwoone ntu riyoothe ukhalha o uhilhoka ama nnyalha. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Wo yoyo nlhatu uyo etu, vakiihanne inyu kihowa wo uhikhalha nipampa. Paahi etu, kinoukohani, nkiihanenlheni?” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Akonelio nkayeera, “Mahuku mararu avinre ikatema yo uthana thoko yelha, kaari kinlhapelhaka Nlhuku uchuumbani waka. Wo uhiweherera, ntu awanre ikuwo cho uteelha twee aheemelha uholho waka, ");
INSERT INTO mgh2016_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nkeera, ‘Nakonelio! Nlhuku hoteelhiya ulhapelha winyu ni isadaka chinaavaha inyu amashikini. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Munrumeke ntu Uyafa amwiihane ntu mmoka neehaniya Simoni, wo nchina nikina Peturo, rii uwani u Nasimoni o uwamba marapalha anokhalha vachereshere ibahari.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Paahi etu kahoruma nttenga wo uhicherewa, ni inyu nhopanga rata uwa. Vano, hiyaano niheecheesha uholho wa Nlhuku, wiiwelhelha iriyoothe ilheheriye inyu ni Athithi uhimiacha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Vavawo Napeturo nkayaapatakulha malhaku nkayaachokholha uhimiacha, nkayeera, “vano kihochuwelha wiira we ikekhiaye Nlhuku khanthanlha. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ntu o nikosho niriyoothe nonthimicha Nlhuku ni upanga ikekhia, Nlhuku nompochera. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ulha phi ulhe nttenga Nlhuku waarwehilhe awe wa attu o Uisraeli, ahimiachaka Malhove Orera anowiiha mpuha wo iphiro ya Yesu Kuristo rii Athithi wa attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwaattiva nnoochuwelha mwaha waakhumelhenlhe ilhapo yonkhaye yo Uyudea uchokholha Ugalilaya kaanyuma yo ubatiizo waahimiacha aya Nayohana ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nnonchuwelha Yesu o Nazareti ni iphiro Nlhuku chanhikilhe awe makhura wo ummineelha Iphumu ya Nlhuku ni machiri. Yoyo ahorwaa uwo ni uwo nkaapanga mitheko choombone ni waalhamiha onkhaye yaavariye ni Nakare, ukhalhawaya Nlhuku aari ni uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hiyaano phi o uhimiechesha mwaha wonkhaye waapannge awe ilhapo ya Uyahudi ni Uyerusalemu, weeviye awe wo ukhomelhelhiya vansalaabani. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nansho Nlhuku ahonhihimusha nihuku no neraru no wiiviya wawe, nkayampanga ooniye, ");
INSERT INTO mgh2016_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kuhiwe wa attu onkhaye, ihikhalhe o uhimiechesha yaathanlhiye ni Nlhuku, hiyaano naalhilhie ni ummuriana kaanyuma yo uhihimmwa wawe unookhwani. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Nlhuku ahonilhehera wiira nihimiache Malhove Orera wa attu onkhaye, ni uhimiechesha wiira Yesu phi athanlhiye ni Nlhuku akhalhe owaahukumulha attu akumi ni attu akhwiilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Anamilhohi onkhaye yahonhimiechesha wiira kila ntu nohalha unrumelhelha noohiyereriya uwonya wawe wonkhaye wo machiri o nchina nawe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ikatema Napeturo vaari aya yuulhumachaka yayo malhove ayo, Iphumu ya Nlhuku ahaakhuruwelha onkhaye yeewelhelha yoyo nttenga uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayahudi o wiinelhiya unyawo o Uyafa yanrumelhenlhe Yesu yaawilhe vamoka ni Napeturo yahoshanga woona wiira Nlhuku ahaamiinelha machiri o Iphumu ya Nlhuku attu ahiri Ayahudi chiicho, ");
INSERT INTO mgh2016_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ukhalhawaya yaheewa yuulhumachaka wo moolhumo anthimichaka Nlhuku. Vavawo Napeturo nkayeera, ");
INSERT INTO mgh2016_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Alha attu alha ahompochera Iphumu ya Nlhuku thoko chimpochenre ihu hiyaano. Chani, haawo ntu riyoothe o waachiichiha ahibatiiziye wo maashi?” ");
INSERT INTO mgh2016_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Paahi, nkayaalhehera abatiiziye wo nchina na Yesu Kuristo. Yamalheke attu nkayaalhepelha wiira athepe ukhalha vavawo wo mahuku vakani. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Akarumiya ni nlhoko wa attu akina yaari ilhapo yonkhaye yo Uyudea yaheewa wiira attu ahiri Ayahudi ni ayo ahopochera nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Paahi Napeturo vaarwelhe aya uhokolhia Uyerusalemu, ahochukulhachiya ni Ayahudi o wiinelhiya unyawo yeerelhiyaka, ");
INSERT INTO mgh2016_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Inyuva mwahorwaa ni ukhalha ni attu o uhiinelhiya unyawo ni ata ulhia mwahaalhiana! ");
INSERT INTO mgh2016_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Vavawo Napeturo nkayaahimia wo uhivitha mwaha wo chittu chaapangeelhe ukhuma khalhayi, ");
INSERT INTO mgh2016_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nihuku nimoka vaari aka Uyafa, kinari kinlhapelhaka Nlhuku, kahoona itora, kahoona ittu thoko ikuwo yuulhupalhe ikhuruwaka vathi ukhuma wiirimu inavarelhiye malhuto aya macheshe, nkayeeshiya vakhiviru ni mii. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kahothurumelha chinene nhina nkakoona ashinama o mieto micheshe o uhuwiya ni ashinama o umwiini, anaakooko ni ashinuni o uchulhu wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yamalheke nkakeewa nlhove nikiirelhaka, ‘Napeturo munkwe, nhitheke, nlhieke.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nansho mii nkakeera, ‘Thithi, ittu iriyoothe yo nsheru ama yo unanara khinapatta mena ukelha umalhakuni waka.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nlhove nne nkaneewaniaa nkwaha wo nayelhi tho ukhuma wiirimu niiraka, ‘Nhinanarihe chittu chirerihilhe awe Nlhuku ukhalha chitakatifu.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yoyo mwaha uyo wahohokolhelha upangia vararu. Yamalheke chittu chonkhaye chapurulhelhiya tho wiirimu. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wo uhipicha, attu araru yaakhumme Ukaisariya, yaarumiye ukiweelha yahowa unupani waakhalha aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Iphumu ya Nlhuku nkaakihimeria wiira kihikelhiye nipampa, kirweeke kaattukaneke. Nlhoko wa attu sita o Uyafa yahokittukana urwaa Ukaisariya. Ni wowo hii onkhaye va nahokelha unupani wa Nakonelio. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Nakonelio yahonihimeria chenre aya wo woona nnepa uneemenlhe nnupani mwaya ni weerelha, ‘Munrume ntu Uyafa mmwiihane ntu neehaniya Simoni, wo nchina nikina Peturo. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yoyo nouhimeriani malhove ni wo yayo malhove ayo inyuva ni inupa inyu yonkhaye nnowoopolhiya.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Vaachokhonlhe aka tu wulhumacha, Iphumu ya Nlhuku ahaakhuruwelha thoko chaanikhuruwenlhe aya hii khalhayi valhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Vavawo kahoopuwelha malhove yoolhumanche aya Athithi, ‘Nayohana yahabatiiza attu wo maashi, nansho mwaattiva nnobatiiziya wo Iphumu ya Nlhuku.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Yakhalhaka Nlhuku hoona ihorera waavaha attu ahiri Ayahudi machiri anivanhe awe hii vaarumelhenlhe ihu Athithi Yesu Kuristo, chani, mii phi mpani ata kilhikache unvaanyiha Nlhuku?” ");
INSERT INTO mgh2016_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Yeeweke yayo malhove ayo, nkayaahiya uvaanyiha, nkayanthimicha Nlhuku eeraka, “Nlhuku haavaha attu ahiri Ayahudi nipesha no ukhoroma apatte ukumi!” ");
INSERT INTO mgh2016_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Attu akina yanrumelhenlhe Yesu yaamwarielhe wo nlhatu no ntwarusho waakhumelhenlhe ikatema veeviye aya Nastefano, yahorwaa Ufoinike ni Ukipro ni Uantiokiya ahimiachaka nttenga wa Nlhuku wa Ayahudi vekha ayaru. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nansho owiittucha akina yaari attu yaakhumme Ukipro ni Ukirene, yahorwaa Uantiokiya nkayaahimiacha yoyo nttenga uyo wa Ayahudi e Iyunani, yaahimiacheraka Malhove Orera anaacha Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Machiri a Athithi yaari vamoka ni ayo ni attu enchi yahorumelhelha nkayaarukunuwelha Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yoyo mwaha uyo nkaweewania wa attu anrumelhenlhe Kuristo o Uyerusalemu. Paahi etu nkayaaruma Nabanaba arwee Uantiokiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Vaaphilhe aya wowo ni woona Nlhuku chenre awe wo waavaha nnema attu, ahoteelhiya ni waakurumicha onkhaye wiira athepeke waakhulhuvelha Athithi wo nrima waya wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nabanaba yaari ntu o nrima woombone, aachariye Iphumu ya Nlhuku ni o upisha nrima. Nlhoko mwinchi wa attu nkawaarukunuwelha Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yamalheke Nabanaba nkayaarwaa Utaso uwaaviani Nasauli. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Vaavitunlhe aya nkayaawiiha Uantiokiya ni ayo onkhaye oyelhi nkayaakhalha vamoka ni attu alhe wo umalhaka iyaakha, yeettuchihaka nlhoko mulhupalhe wa attu anrumelhenlhe Kuristo, yaari wowo Uantiokiya uwo owiittucha vaachokhonlhe aya wiihaniya Akuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Yeyo ikatema, anamilhohi akina a Nlhuku yahorwaa Uantiokiya akhumaka Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Paahi, mmoka aya eehaniya Naagabo aheemelha. Ni wo machiri o Iphumu ya Nlhuku nkaayalhohera wiira unookhalha ikuruna ilhapo yonkhaye. Yeyo ikuruna iyo yaakhumelhenlhe ikatema Nakilaudiyo vaatawara aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Akuristo o Uantiokiya nkayaalhakelha wiira kila mmoka chooria arweehe ittu iriyoothe yo waakavihera nlhoko wa owiittucha ashikhunanaya anokhalha Uyudea. ");
INSERT INTO mgh2016_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nkayaapanga chiicho, nkayaaruma Nabanaba ni Nasauli urweeha nchurukhu wa ashulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Yeyo ikatema iyo, Amwene Naherode yahochokholha waatwarusha attu anrumelhenlhe Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nkayaavara Nayakhobo ahima aya Nayohana wiira eeviye wo uphanga. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yooneke wiira yoyo mwaha uyo uhaachivelha Ayahudi, nkayaavara ni Napeturo. Chechiyo chaapangeelhe ikatema yo isikuukuu yo mikatte cho uhihelhiya ihengedure. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Napeturo avariyeke ahokushiya mpaka ujeerani nkayaalhitelhelhiya ni milhoko micheshe cha attu olhita acheshe acheshe. Naherode yaalhakenlhe waakumiha vapuwani aviraka Pasaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Napeturo vaari aya anattukiye, attu anrumelhenlhe Kuristo yaari alhapelhaka wa Nlhuku, wo nrima wo ukhulhuvelha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uhiyu, nihinaaya nihuku naathanana aya Naherode waakumiha Napeturo upuwani wiira ahukumulhiye, Napeturo yaari anarumpe variyari yo manyaasikari olhita elhi anattukelhelhiye mittondoro miilhi. Olhita akina yaari alhitaka nlhako. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Wo uhikhulhuvelhiya, nnepa wa Athithi nkawaakhumelhelha vaarumpe aya Napeturo ni nthuko nkawaamwalhia ichuumba yo ijera ilhe. Nnepa wo wiirimu wa Nlhuku nkawaakwakwanya Napeturo vanikhathani nkawaawusha wiiraka, “Mwaakuvie! Munkwe!” Vavawo vavawo mittondoro chaattukiye aya mmiononi nkachaakwatuwa nkachaamora vathi. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nnepa nkaweerelha, “Mwiittukeke nchako inyu, mmwareke iratu chinyu.” Napeturo nkayaapanga chiicho. Nnepa ulhe nkaweerelha, “Mmwareke mwiinjiro inyu, nkittwareke.” ");
INSERT INTO mgh2016_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Napeturo nkayaattwara nnepa wo wiirimu ulhe ukhuma ujeerani ahichuwelhaka wiira yayo anopanga nnepa ayo yaari ye ikeekhene, yaari yaanyiheraka wiira anowiiraka ulhoha. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nkayaavira olhita o upacha ni onayelhi nkayaaphiya nlhako wo umalhihera wo iyuuma wo ukelhelha vawani. Nlhako uyo nkawaahulhia nneeneru, ni ayo nkayaakhuma vathe. Nkayaarwaa yeetaka mphironi, ni ahiwehereraka nnepa ulhe nkawaahiya Napeturo. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Vavawo Napeturo nkayaachuwelha chaakhumelhenlhe, nkayeera, “Vano kihochuwelha we ikekhiaye wiira Athithi ahonruma nnepa aya nkaakoopolha mmiononi mu Naherode ni mwaha wonkhaye waawehereriya ni Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yachuwelheke chiicho nkayaarwaa mpaka unupani wa Amariamu anumwanaya Nayohana aneehaniya Namako. Mommo attu enchi yaari anathothokanne anlhapelhaka Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Napeturo nkayaahodisha vankhorani. Karumiya mmoka mwalhi eehaniya Roda, nkaarwa vankhorani uwaakhulhani. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mwalhi uyo nkaachuwelha nlhove ni Napeturo nkaateelhiya chinene. Nkaahiya uhulha nlhako ulhe, nkaattimakelha mpaani ni weerelha attu wiira Napeturo yaari vathe vawo ahoweemelha vankhorani. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Attu nkayaamwaakhulha, “Nri ni ihalhahalha!” Nansho mwalhi uyo nkaathepa uminda wiira phi Napeturo anene. Ni ayo nkayeera, “Yoyo nnepa aya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yeyo ikatema iyo Napeturo yaari athepaka uhodisha vankhorani. Vavawo attu nkayaarwaa ni uhulha nkhora, nkayoona Napeturo nkayomiya uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Napeturo nkayaathonyera nikokho attu wiira amaalhe, nkayaahimiacha Athithi chinre aya wo waakumiha ujeerani. Yamalheke nkayaalhehera wiira arwehelhiye nttenga Nayakhobo ni ashilhoko ihu anrumelhenlhe Kuristo akina, achuwelhe yoyo mwaha uyo. Napeturo nkayaathama nkayaarwaa vakittu vakina. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Washeeke, attu olhita yahokelhiya nipampa chinene wo ahichuwelhaka mwaha waapantte Napeturo. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Naherode nkayaalhehera wiira Napeturo yaaviye, nansho khayooniye. Paahi nkayaalhehera wiira olhita alhe akohakohiye ni ulhehera wiira eeviye. Paahi Naherode nkayaathama Uyudea nkayarwaa Ukaisariya nkayaakhalha wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naherode ahorushiya chinene ni attu o Utiro ni attu o Usidoni. Paahi milhoko cha attu o chechiyo ilhapo chiyo yahorweha nttenga wo waapepecha. Nkayaachokholha wo waapatta Nabulasto emelhelha inupa ya Amwene, wiira aakavihe. Nkayaarwaa u Naherode ulhepelhani mwaha wo waathaniya, ukhalhawaya ilhapo chaya chaakhulhuvelha cholhia chaakhuma ilhapo ya amwene ayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nkanaathanlhiya nihuku no wuulhumana. Naherode nkayaawa anawarenlhe ikuwo chaya cho utawara. Nkaakhalhelha ihiche aya yo umwene, nkoolhumana attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Attu nkayaakhuwelha eeraka, “Mmoka o milhuku phi noolhumacha, kahena ntu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vavawo nnepa wa Athithi nkawaawulhusha Naherode vathi ukhalhawaya khayammanhe Nlhuku nthimicho, nansho ntu. Nkayaaveethachiya ni ashimwettu nkayaakhwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nansho nlhove na Nlhuku nkanaathepa uwanelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nabanaba ni Nasauli nkayaamalhiha ntheko aya Uyerusalemu, nkayaahokolhia yaakushaka Nayohana aneehaniya Namako. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Munlhokoni mwa attu anrumelhenlhe Kuristo o Uantiokiya yahokhalha akina yaari anamilhohi ni owiittuchiha, Nabanaba ni Nasimeoni aneehaniya Oriipa ni Nalukiyo o Ukirene ni Nasauli ni Namanaeni yaalhelhiye vamoka ni Naherode Antipasi. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nihuku nimoka vaari aya yaalhapelhaka Athithi ni uttuka, Iphumu ya Nlhuku nkeerelha, “Nkeeshereke Nabanaba ni Nasauli apange ntheko weehanenlhe aka.” ");
INSERT INTO mgh2016_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nkaayaattuka ni unlhapelha Nlhuku, nkayeeshera miono, nkayaahiya arwaacheke apange ntheko wo uhimiacha Malhove Orera a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nabanaba ni Nasauli yahorwaa iwani yo Useleukiya waarumiye aya ni Iphumu ya Nlhuku. Uthama wowo yahowelha mmeelini nkayaarwaa u ichirumba yo Ukipro. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Yaphiyeke iwani yo Usalami yahohimiacha Nlhove na Nlhuku mu inupa cho unlhapelha Nlhuku cha Ayahudi. Nayohana eehaniya Namako yaari phi anamitheko aakaviha munthekoni mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nkayaalhapuwa ukhopelhelhe nkayaaphiya Upafo. Wowo nkayamphwanya ntu mmoka namihapo Nyahudi namilhohi o woothacha eehaniya Bariyesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yoyo aari ampwana a Segiyo Paolo, ntu o irusho chinene aatawara yeyo ichirumba iyo. Segiyo Paolo aheehana Nabanaba ni Nasauli wiira awe eewa nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nansho yayo ahovingiya ni nkhwiri o mihapo Elima, thoko cheehaniya awe we Igiriki. Yoyo aholhikacha untiyelhelha Segiyo Paolo hiwe aapisha nrima ni urumelhelha Nlhove na Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Paahi, Nasauli aneehaniya Napaolo, uno anachariye ni Iphumu ya Nlhuku, nkayammweha chinene yoyo nkhwiri uyo, ");
INSERT INTO mgh2016_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nkayaamwiirelha, “Uwe mwaana a Nakare! Inyu nnovinga kila ittu iriyoothe irii yo ikekhiaye. Nhochara uhilhoka wo kila iphiro. Nnaathepiacha attu kila ikatema wiira ikeekhene ya Athithi iri yo wookolhia! ");
INSERT INTO mgh2016_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Moono wa Athithi unowaatani, nnookhalha ohoona ni inyu khannoona nchuwa wo mahuku.” Vavawovavawo Elima nkaakelhiya naawiriphi mmiithoni nkoocheelha woona, nkeeta uno amwaaviaka ntu o ummara moono. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ntawara o iwani ulhe ooneke chikhumelhenlhe, nkaarumelhelha, ukhalhawaya aari noomiye uwanoni veewa awe meettuchiho a Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Napaolo ni akhunanaya yahothama Upafo nkayaawelha mmeelini nkayarwaa Uperga ilhapo yo Upamfiliya. Wowo Nayohana aneehaniya Namako ahaahiya akhunanaya, nkayaahokolhia Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nabanaba ni Napaolo nkayaathama Uperga nkayaaphiya Uantiokiya yo Upisidiya. Nihuku no Wiittuwa nkayaarwaa inupa yo unlhapelha Nlhuku ya Ayahudi nkayaakhalha. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Yamalheke ushomiya ikitabu yo Malhehero a ashinna Musa ni malhove a anamilhohi a Nlhuku, olhupalhe eemelhelha inupa yo unlhapelha Nlhuku ilhe nkayaarwehelha nttenga, “Ashilhoko ihu, yakhalhaka nhanaa nttenga uriyoothe wo waavaha attu nrima, muulhumacheke.” ");
INSERT INTO mgh2016_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Napaolo nkayeemelha nkayaapungelha attu moono, nkayaachokholha wulhumacha, “Aisraeli nanaka ni attu ahiri Ayahudi nnonthimicha Nlhuku, nkiiwelhelheke! ");
INSERT INTO mgh2016_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nlhuku a attu o Uisraeli ahaathanlha manyaapwiiya ihu, nkaapanga ukhalha ilhapo yuulhupalhe vaari aya upottani Umisri. Nlhuku ahaathamiha Umisri wo machiri awe moolhupalhe, ");
INSERT INTO mgh2016_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ni wo iyaakha makhumi ncheshe ahaavilhelha uthakoni ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ahorimeelhiha ilhapo saba cha attu yaakhalhelha ilhapo yo Ukanaani nkaapanga ukhalha ilhapo ya attu awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yayo onkhaye yaapangelhe iyaakha imia ncheshe ni makhumi nthanu. “Nkayaavaha owaahukumulha o waaholhelha mpaka ikatema ya anamilhohi Nasamweli. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Vavawo yavekelheke umpatta mwene, Nlhuku nkaavaha Sauli, mwaana a Naakishi ntu o nikosho ni Nabenyamini, ukhalha mwene wo iyaakha makhumi ncheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yaathamiheke Nasauli, Nlhuku ahaathanlha Adaudi ukhalha mwene aya. Nlhuku aathanlhe wo uhimiechesha vachulhu aya, ‘Kihomwoona Daudi mwaana a Nayese, ntu nokiteelhiha nrima aka nohalha upangacha chittu chonkhaye chinothanana aka upanga.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Nhina iyari ya Adaudi, Nlhuku ahaawiihera attu o Uisraeli Moopolhi, phi Yesu thoko chaalhehilhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu hinaaya uchokholha ntheko awe, Nayohana yahaahimiachera mwaha wo ukhoroma attu onkhaye o Uisraeli, ahiye uwonya waya abatiiziye. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nayohana vaari aya amalhihaka ntheko aya, nkayeerelha attu, Nnaanyihera wiira mii phi Kuristo? Mena! Mii kakihiwe. Nansho mwiiwelhelheke, Yoyo noowa utulhi waka ni mii kihiphwanelhiyaka ata unrulha ikwakwata mmietoni mwawe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ashilhoko aka, Aisraeli nanaka, o nihimo ni Aburahimu ni attu nhiri Ayahudi onkhaye nnonthimicha Nlhuku, ulha nttenga wo noopo ulha uhowiihiya uwanihu! ");
INSERT INTO mgh2016_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ukhalhawaya attu o Uyerusalemu ni aholhelhi aya khayanchuwenlhe wiira Yoyo phi Moopolhi, mena khayaachuwenlhe malhove a anamilhohi anoshomiya kila Nihuku no Wiittuwa. Ata chiicho yahopanga malhove a anamilhohi atimire wo unhukumulha Yesu wiiviya. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Inakhalhaka khayaapantte nlhatu uriyoothe waaphwanenlhe umwiiva, yahaavekelha Napilato wiira anhukumulhe Yesu eeviye. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Vaamalhinhe aya upanga thoko chilhepiye ni Malhove Matakatifu chimwaaka, ahonkurusha vansalaabani, nkayamweesha nnihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nansho Nlhuku ahonhihimusha nnookhwani, ");
INSERT INTO mgh2016_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ni wo mahuku menchi ahaakhumelhelha attu aattukanne awe ukhuma Ugalilaya mpaka Uyerusalemu. Ni yayo vano phi nohimiechesha wa attu o Israeli. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ni hii nihowa vaa niuhimiachereni mwaatti Malhove Orera, Nlhuku aalhehire awe manyaapwiiya ihu wiira, ");
INSERT INTO mgh2016_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nlhuku nowaapangelha, anipangelhaka vano hii nirii iyari aya wo unhihimusha Yesu muukumini. Thoko malhove o izaburi yo nayelhi chineera aya, ‘Uweva phi Mwaamwanaka, lhelho mii phi Athumwana.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nlhuku enre cho vachulhu mwaha wo unhihimusha, wiira khanonta umahiyeni, ‘Kinouvaha nnema wo utakatifu wo ukhulhuvelhiya kaalhenhe aka Adaudi.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tho nlhako nkina wo izaburi uneera, ‘Nlhuku khannonhiya karumiya awe matakatifu ontilhe umahiyeni.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ulha nohimiya ulha kahiwe Adaudi. Ukhalhawaya Adaudi ahotimiriha ntheko wo mattunelho a Nlhuku wo ikatema aya, nkayaarimeelha ni uvithiya wo waatamana ni manyaapwiiya aya, iruttu aya nkayonta nnihiyeni. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nansho uyo Yesu aahihimushiye ni Nlhuku uyo, khontilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Paahi etu ashilhoko aka nchuwelheke wiira, wo iphiro awe Yesu uyo, nttenga unolhehera uhiyereriya uwonya unoohimiachiya uwaninyu vano. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ntu riyoothe nonrumelhelha Yesu, noohiyereriya milhatu chawe chonkhaye, ittu yahooriya upangiya ni Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mwiishungeke etu, nhiwe mwaawulhuwelha mwaahimiye ni anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mwiiwelhelheke inyu mwaatti o nihambu va. Nshangeke ni upotera! Ukhalhawaya ittu kinopanga aka lhelho ilha, phi ittu ihinorumelhelha inyu, ata mwanahimeriyaka chani!’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Napaolo ni Nabanaba vaakhuma aya nnupani mwo lhapelha mmo, yaholhalheiya wiira awe tho Nihuku no Wiittuwa naattwara, awe aahimiachera attu chinene yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nkutaano vaamanlhe aya wi inupa yo unlhapelha Nlhuku, nkutiro wa Ayahudi enchi ni attu ahiri Ayahudi yeettuchilhe idini ya Ayahudi, yahaattwara Napaolo ni Nabanaba. Akarumiya nkayaarerihana ni waahelha nrima wiira athepeke ukhalha akhulhuvelhelhaka nnema wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nihuku no Wiittuwa naatwara, kila ntu o iwani iyo ahowa wiiwelhelha nlhove na Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayahudi vonne aya nlhoko wa attu, nkayaakelhiya ihache, nkayaavinga malhove olhumachiya ni Napaolo nkayaaruwana. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nansho inakhalhaka chiicho etu, Napaolo ni Nabanaba yahoolhumacha wo machiri chinene, eeraka, “Nhochuwelha wiira yaari lazima nlhove na Nlhuku nichokholheke uhimiachiya uwaninyu mwaatti, nansho ukhalhawaya mwahokhota mwiichonaka wiira khamphwanelhiye ukumi wo uhimalha, ninouhiyani ni urwaa wa attu ahiri Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ukhalhawaya Athithi ahonilhehera wiira, ‘Kihoweeshani inyuva ukhalha nthuko wa ahiri Ayahudi, wiira attu oopolhiye velhaponi voothe.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Attu ahiri Ayahudi veewilhe aya yahoteelhiya, nkayaatotopelha wiira nlhove na Athithi noombone, ni attu yaathanlhiye upatta ukumi wo uhimalha, nkayaarumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nlhove ni Athithi nkanaawanelha mwonkhaye velhaponi vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nansho Aholhelhi a Ayahudi yahaahelha ichimwa manyopani o nhakhu ahiri Ayahudi yanthimicha Nlhuku ni manyaalhopwana ochuwania o yeyo iwani iyo. Nkayaachokholha waatwarusha Napaolo ni Nabanaba, nkayoomolhacha athame vawani vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paahi etu, akarumiya nkayaakukuttacha ntukurukhu nnyaani mwaya ikhalhaka iphiro yo waamuka, nkayaathamacha nkayaarwaa Uikoniyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Owiittucha o Uantiokiya yaari anachariye mpuha ni Iphumu ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mwaha thoko yoyo wahokhumelhelha Uikoniyo Napaolo ni Nabanaba vaarwelhe aya wi inupa yo unlhapelha Nlhuku nkayoolhumacha malhove wo wiishipa mpaka mphingo mulhupalhe wa Ayahudi ni Ayunani yahorumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nansho Ayahudi yahaarumelhenlhe yahowiiha ichimwa ni uphateelha mu nrimani mwa attu ahiri Ayahudi wiira yaapangelhe chittu cho uhilhoka ashilhoko ihu yaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nansho Napaolo ni Nabanaba yaholhokelha wowo wo mahuku menchi. Nkayaaminda waahimiacha Athithi, wo uhimiechesha ikeekhene yo nttenga waahimianche aya waachaka nnema waya, wo wooriha upangacha cho ushangiha ni ithikineha. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Attu o yeyo iwani iyo yahomwalhaanacha, akina alhutaanaka ni Ayahudi ni akina aattwaraka akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Paahi etu, attu akina ahiri Ayahudi vamoka ni Ayahudi akavihanaka ni aholhelhi aya, yaholhakelha waapangelha ichimwa akarumiya ayo yo waatakacha malhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Akarumiya vaachuwenlhe aya, yahottawelha Ulistra ni Uderbe, iwani cho Ulukaoniya ni iwani chaatamana. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nkayaahimiacha Malhove Orera wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ahaawo ntu mmoka Ulistra, aari oheeta toka vaayariye awe ni anumwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yoyo ntu uyo aheewelhelha Napaolo vaahimiacha aya Malhove Orera. Napaolo nkayammweha wo miitho melhi, vonne aya wiira hanaa nrima wo ulhamihiya, ");
INSERT INTO mgh2016_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ahokhuwelha amwiirelhaka, “Weemelheke ni mieto chao!” Ntu aremanre mieto uyo nkeemelha yeyo ikatema, nkaachokholha weeta. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nlhoko wa attu vonne aya ittu ipannge aya Napaolo, nkayaachokholha ukhuwelhacha wo nulhumo no Ulukaoniya, “Milhuku chinoonia thoko attu chihonikhuruwelha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nabanaba nkayaavahiya nchina nkayeehaniya Zeu, ni Napaolo nkayeehaniya Heme ukhalhawaya phi aaholhelha wulhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ni ayo opochera ishaani a nlhuku Zeu o inupa yo ulhapelha yaari vachereshere iwani ahowiiha madume o ing'ope ni maua uwiiha vaari nlhako mulhupalhe wo ukhelhelha vawani vawo. Anene ayo ni attu akina yaari athananaka waavaha isadaka akarumiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Akarumiya Nabanaba ni Napaolo veewilhe aya, yahorulha miinjiro chaya cho nchulhu, nkayaatimakacha mpaka waari nlhoko wa attu nkayaakhuwelhacha, ");
INSERT INTO mgh2016_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ashilhoko ihu, nlhatuni no wiira chiicho? Hii attu thoko chiri inyu mwaattiva! Nirii vaa uwa uuhimiacherani malhove Orera wiira nhiye ulhapelha isinyago chii, munrukunuwelhe Nlhuku ri nkumi. Nlhuku oopilhe irimu ni ilhapo ni ibahari ni chittu chonkhaye chiriwo. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Khalhayi vawo Nlhuku ahohiya kila ilhapo ipange thoko chaathanana aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nansho inakhalhaka chiicho, Nlhuku kaahilhe wiihimiechesha wo upanga chittu choombone chinonipangelha awe, nourupelhani ipulha ukhuma wiirimu, nnooruweria nlhaalha vanaaya aya, nouvahani yolhia ni uuvahani mpuha mu nrimani mwinyu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nansho akarumiya anolhumachaka chiicho, ahovara ntheko mulhupalhe chinene wo waachiichiha attu waathimicha ni waavaha isadaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nansho yahowa Ayahudi akina yaakhumme Uantiokiya ilhapo yo Upisidiya ni Uikoniyo, nkaayaapatta attu o waalhuta moono. Nkayaatakacha Napaolo malhuku ni waapurulhelha mpaka vachereshere iwani yaanyiheraka wiira ahomalha ukhwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nansho owiittucha vaathukumanne aya ni waarukureria, ahonkwa nkayaahokolhia vawani. Waashelhe waya, Napaolo ni Nabanaba yahothama nkayaarwaa Uderbe. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Napaolo ni Nabanaba vaamalhinhe aya uhimiacha Malhove Orera ni waapatta owiittucha enchi yaarumelhenlhe Uderbe, yahottuka nkwaha wo urwaa Uantiokiya avirelhaka Ulistra ni Uikoniyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yahaahelha nrima owiittucha o chechiyo iwani chiyo wiira avarecheshe nrima ni uhalha munrimani. Nkayeerelha, “Ihophwanelha hii onkhaye uvira iphiro cho ntwarusho wiira noorie ukelha mu Imwene ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yahaathanlha ashulhupalhe o kila nlhoko wa attu anrumelhenlhe Kuristo wo nlhatu na attu anrumelhenlhe Yesu, ni wo unlhapelha Nlhuku ni uttuka wo uhilhia yolhia, nkayaahiya ashungiyaka ni Athithi yaarumelhelha aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Amalheke uvira ilhapo cho Upisidiya ahophiya iwani yo Upamfiliya. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Amalheke uhimiacha Malhove Orera iwani yo Uperga, yahorwaa Uatalia. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Yathameke wowo yahorwaa wo imeli nkayaahokolhia Uantiokiya waapanche aya weeshiya mmathathani mwo nnema wa Nlhuku wo nlhatu no ntheko waatimiriha aya vano. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Vaaphilhe aya Uantiokiya yaheesha nkutaano wo nlhoko wa attu anrumelhenlhe Kuristo no wowo, nkayaahimia nttenga wo mwaha waapannge awe Nlhuku nhina mwaya ni chenre awe wo waahulhelha attu ahiri Ayahudi nlhako wo upisha nrima. ");
INSERT INTO mgh2016_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nkayaalhokelha vamoka ni owiittucha wo mahuku menchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Attu akina aakhumme Uyudea yahowa Uantiokiya nkayaachokholha weettuchiha nlhoko wa attu arumelhenlhe alhe eeraka, “Yakhalhaka khannenelhiya unyawo ulhikaana ni malhehero nipochenre ihu wa ashinna Musa, khannoopolhiya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Napaolo ni Nabanaba yahovaanyihana ni attu vachulhu yoyo mwaha uyo chinene. Wamalheke ukohanachiya nkayooniya wiira Napaolo ni Nabanaba vamoka ni attu arumelhenlhe akina o Uantiokiya arwee Uyerusalemu uwoonani akarumiya ni ashulhupalhe o nlhoko wa attu anrumelhenlhe Kuristo wo yoyo nlhatu uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Paahi etu nlhoko wa attu anrumelhenlhe Kuristo nkanaalheeha, ni ayo vaavinre aya Ufoinike ni Usamariya yahaahimiachera attu mwaha wa attu ahiri Ayahudi arukunuwilhe unttwara Nlhuku. Yoyo mwaha uyo wahaateelhiha nrima chinene yayo attu ayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Vaaphilhe aya Uyerusalemu, yahopocheriya ni attu anrumelhenlhe Kuristo vamoka ni akarumiya ni ashulhupalhe. Nkayaahimiachera mwaha wonkhaye Nlhuku waapannge awe wo iphiro aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nansho attu yaarumelhenlhe akina, o nkutiro wa Amafarisayo yaheemelha nkayeera, “Ihothananiya attu ahiri Ayahudi wiinelhiya unyawo ni wiittuchihiya Malhehero a ashinna Musa.” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Akarumiya ni ashulhupalhe wahokumaaniya waarerihelha yoyo mwaha uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Waarerihiyeke chinene, Napeturo aheemelha nkayeera, “Ashilhoko aka, mwaatti nhochuwelha wiira wa pachenre aya vawo, Nlhuku ahokithanlha mii munlhokoni mwinyu wiira kihimiache Malhove Orera wa attu ahiri Ayahudi, wiira eewe ni urumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nlhuku, nochuwelha mirima cha attu, ahohimiechesha wiira haapochera ni ayo wo waavaha Iphumu ya Nlhuku thoko chinre awe wo univaha ni hii. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Khaamwalhaaninhe ittu iriyoothe variyari ihu ni yayo manyaattu ayo. Wo uchuwelha waya ahaahapiha mirima chaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Vano etu, nlhatu waani no unlhikacha Nlhuku wo waatwichiriha owiittucha nsigo uhinooria ukushiya upachera wa manyaapwiiya ihu mena hii naashinene? ");
INSERT INTO mgh2016_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ihikhalhe chiicho mena! Nansho ninorumelhelha wiira, hii ninoopolhiya wo nnema wa Athithi Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nlhoko wonkhaye wahomaalha shiriri, weewelhelha Nabanaba ni Napaolo vaahimiacha aya cho ushangiha ni ithikineha chaavahiye aya ni Nlhuku ni upanga wo miono chaya mwa attu ahiri Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Vaamalhinhe aya wulhumacha, Nayakhobo ahoolhumacha wiira, “Mwaatti ashilhoko aka, nkakiiweni! ");
INSERT INTO mgh2016_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nasimoni ahohimia Nlhuku wo uchokholha chenre awe wo wachenjeukelha attu ahiri Ayahudi, aathanlhaka akina aya ukhalha attu awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Malhove aahimiye ni anamilhohi anowiiwanana rata ni ulha mwaha ulha, thoko Malhove Matakatifu chineera aya ");
INSERT INTO mgh2016_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Athithi aneera, wamalhaka ulha mwaha ulha, kinoohokolhia ni utheka tho nrapatta na Adaudi niwulhuwilhe. Kinoolhokiha mathalha, Ni utheka tho wo machiri. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Vavawo attu akina onkhaye ahalhenlhe yaavie Athithi, ni attu onkhaye ahiri Ayahudi keehanne aka ukhalha attu aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Phi neera aya Athithi, apannge ulha mwaha ulha wiira uchuwaniee toka mahuku o uhimalha.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nayakhobo nkayaathepa wiira, “Paahi etu mwaatti, nlhove ninohukumulha aka phi nna, nihaahuvihache attu ahiri Ayahudi anonrukunuwelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nansho naarweehelheke iwarakha yo waahimeria wiira ahilhie cholhia chinyalhihiye wo ulhapelhelhiya isinyago, ahiwehewehe mwaha wo ishembwere, ni uhiya ulhia inama ya ashinama achipulhiye ishiko mena ahiwurie iphome. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ukhalhawaya Malhehero a ashinna Musa ihohimiachiya wo mahuku menchi mmanupani mwo unlhapelha Nlhuku kila Nihuku no Wiittuwa, ni malhove aya anoshomiya kila iwani.” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Akarumiya ni ashulhupalhe ni nlhoko wa attu anrumelhenlhe Kuristo onkhaye yahaathanlha attu akina munlhokoni mwaya ni waaruma Uantiokiya vamoka ni Napaolo ni Nabanaba. Nkayaathanlha attu elhi yaarumelhelhiya ni attu, Nayuda aneehaniya Barsaba ni Nasila. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nkayaavaha iwarakha yeera, “Hii, akarumiya vamoka ni ashulhupalhe, manyonninyu, ninoowiha isalamu wa ashilhoko ihu ahiri Ayahudi anokhalha Uantiokiya ni Usiriya ni Ukilikiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Niheewa wiira attu akhwawe aakhumme uwanihu uno ahowa nkayoothemwihani wo malhove aya anaacha mwaha wo wiinelhiya unyawo, nkayoohelhani nipampa. Nansho hii khanaarumme ahimiache chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Paahi etu, nihokumaana ni woona mbaya waathanlha akarumiya akina ni waaruma uwaninyu. Anowa vamoka ni manyampwana anaattuna ihu Nabanaba ni Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yayo phi attu akuminhe ukumi aya wo uhimiechesha nchina na Athithi Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ninowaaruma tho, Nayuda ni Nasila anowa uuhimeriani mwaatti mwaha thoko nilhemmpe ihu muwarakhani. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Paahi, Iphumu ya Nlhuku ni hii nihorumelhelha wiira nihiurieni tho misigo cho uthepa ulha mwaha ulha, ");
INSERT INTO mgh2016_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nhilhie cholhia chikumihiye ishaani chilhapelhiye isinyago, nhiwurie iphome, nhinkhuure mwannama chipulhiye ishiko, mena nhiwehewehe mwaha wo ishembwere. Inookhalha mwoomboneru mwashembaka upanga chechiyo chittu chiyo. Kwaheri, nihomalhiha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Akarumiya nkayaalheehiya, nkayaarwaa Uantiokiya. Wowo yaheehaniha nkutaano wo nlhoko wa attu anrumelhenlhe Kuristo, nkayaavaha iwarakha iyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Vaashomiye aya, malhove yahaaahelha mirima attu, nkayaateelhachiya chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nayuda ni Nasila yaari ni ayo anamilhohi a Nlhuku, yahoopa mwaha chinene ni yayo manyaattu ashilhoko ihu ayo, aahelhaka nrima ni waalhipiha. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Alhokelheke wo mahuku, yaholheehiya ni ashilhoko o Uantiokiya wo woopelhiya mpuha, nkayaahokolhia waarumiye aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nansho Nasila aahanlhe wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Napaolo ni Nabanaba yahokhalha Uantiokiya wo mahuku, nkayeettuchiha ni uhimiacha wa attu nlhove na Athithi, vamoka ni attu akina enchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Yavireke mahuku, Napaolo nkayeerelha Nabanaba, “Nngwee etu nihokolhie neetelhelhe achihima ihu iwani chaahimianche ihu nlhove na Athithi, noonecheshe chineera aya wo uthepa.” ");
INSERT INTO mgh2016_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nabanaba yaari athananaka waattukana Nayohana Mako. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nansho Napaolo khayaattunne waattukana Namako, ukhalhawaya yayo ahokhota waakaviha mitheko chaya ni waahiya Upamfiliya. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paahi nkayaakhulhanacha ashineneru chinene, nkayaamwalhaanacha. Nabanaba nkayaakusha Namako nkayaawelha mmeelini nkayaarwaa Ukipro. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nansho Napaolo nkayaathanlha Nasila. Nkayaathama alhepelhelhiyaka ni nlhoko ulhe ni weeshiya muushungiyani mwo nnema wa Athithi, nkayaathama. ");
INSERT INTO mgh2016_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Munkwahani mwaya yahorwaa Usiriya ni Ukilikiya, alhipihachaka milhoko cha attu anrumelhenlhe Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Napaolo yahorwaa Uderbe ni Ulistra, waakhalha awe owiittucha mmoka eehaniya Timotheo. Anumwanawe yoyo aari Ayahudi anrumelhenlhe Kuristo, nansho athumwanawe aari Ayunani. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotheo ari ntu ahimiecheshiye ni attu anrumelhenlhe Kuristo onkhaye o Ulistra ni Uikoniyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Napaolo yahothanana unttukana Timotheo munkwahani, paahi etu nkayaamwiinelha unyawo. Yaapannge chiicho ukhalhawaya Ayahudi yaakhalha yeyo ilhapo iyo yahochuwelha wiira athumwanawe aari Ayunani. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vaavira aya mmawani mmwe yahaavaha attu malhehero aahukumulhiye ni akarumiya ni ashulhupalhe o Uyerusalemu, yaakurumichaka wiira avarecheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Paahi etu, attu anrumelhenlhe Kuristo nkayaathepa ukhomaalha nrima chinene, ni attu yaarumelhelha nkayaathepa wunchereria kila nihuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nkayaarwaa aviraka iwani cho Ufirigiya ni Ugalatiya ukhalhawaya Iphumu ya Nlhuku ahaachiichiha uhimiacha nttenga wa Athithi iwani yo Uasiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yaphiyeke miinano cho Umisiya, yaholhikacha urwaa iwani yo Ubithiniya, nansho Iphumu ya Yesu yahaachiichiha. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nkayaavira Umisiya, nkayarwaa mpaka Utroa. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Uhiyu waya, Napaolo nkayamwoona ntorani ntu mmoka o Umakedoniya howeemelha aalhepelhaka wiira, “Nlhapuwe, mmwe Umakedoniya, mmwe mwaanikaviha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Napaolo yamalheke woona yoyo ntora uyo, aheechesha rata urwaa Umakedoniya wo uhipicha, ukhalhawaya nahoona ikekhiaye wiira Nlhuku honiihana naahimiachere Malhove Orera attu o wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nahothama Utroa, nkanaawelha mmelini urwaa nhina ilhapo mpaka Usamotrake. Waashelhe waya nkanaaphiya Uneapoli. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Vaathamme ihu wowo, nahorwaa mpaka Ufilipi, iwani yuulhupalhe yo Umakedoniya, yaatawariya ni Arumi. Nahokhalha yeyo iwani iyo wo mahuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nihuku no Wiittuwa nahothama nkanarwaa uchereshere iwani umwoolhokoni, vakittu vaanyihenre ihu wiira Ayahudi yanokumaana unlhapelha Nlhuku. Nahokhalha nkanoolhumacha ni manyopani yaakumanne vavawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Amoka o manyopani yaaniiwelhelha yaari eehaniya Naridiya, opani anthimicha Nlhuku, anenchi o Uthiatira, aapanga ntheko wo uchurusha ikuwo cho nhakhu mwinchi. Athithi yahotukulha nrima aya nkayaapochera malhove yaahimiachiya ni Napaolo alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yamalheke ubatiiziya vamoka ni manyaalhoko aya, yahonilhalhia uwannyaya eeraka, “Yakhalhaka we ikeekhene nhochuwelha wiira mii kinowaarumelhelha Athithi, mmweeke mwaakhalha uwannyaka.” Nkayaanipepecha wiira nirwee. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nihuku nimoka vaari ihu nirwaaka vakittu vo unlhapelha Nlhuku, nahonkhumaana mwalhi mmoka namitheko aari ni nshoka no unanara nammaha wooria umoopa nttiti. Yoyo nttiti uyo waari waapattelhaka apwiiya awe nchurukhu mwinchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yoyo mwalhi uyo ahaattwara Napaolo anyakhulhaka eeraka, “Alha attu alha phi akarumiya a Nlhuku Mulhupalhe! Anowiittuchihani chinohalha inyu woopolhiya!” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nkaaninyakulha chiicho mahuku menchi, mpaka Napaolo nkayaarushiya, nkayanrukunuwelha nkayaachachera nshoka nne, “Kinoulheherani wo nchina na Yesu Kuristo munthame ulha mwalhi ulha!” Yeyo ikatema nshoka nkanaanthama. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ashinene yanruma mwalhi ulhe yooneke wiira yaakhulhuvelha aya upatta nhakhu ilhe ihomalha, yahaavara Napaolo ni Nasila. Nkayaakwekhweremiha mpaka va ipuwa uholho wa aholhelhi. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nkayaarweha milhatu wa aholhelhi Arumi eeraka, “Alha Ayahudi alha ahopanga injarare vawanihuva. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Aneettuchiha meettuchiho ahinaathana ni ikekhia ihu. Hii Arumi va nihochiichihiya wiira nihirumelhelhe mena uttwarattwara yayo.” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nlhoko wa attu nkawaalhutaana waatwarusha Napaolo ni Nasila. Aholhelhi alhe nkayaarulha ikuwo Napaolo ni Nasila, nkayaalhehera wiira yaatiye mikwaju. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Yamalheke waatiya chinene nkayeeshiya ujeerani ni olhitelhelha nkaalheheriya wiira yaashunge chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wo uvarechesha malhehero alhe, olhita alhe nkayeesha Napaolo ni Nasila ichuumba yo nhina ujeerani ni waattukelhelha mieto chaya wo nkhukhulhu mulhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Uhiyu iriyari Napaolo ni Nasila yaari anlhapelhaka Nlhuku ni wiipa ichipo cho unthimicha Nlhuku, uno attu aattukiye nanaya ewelhelhaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Wo uhikhulhuvelhiya, ilhapo nkayaatetemelha ni utikhinya nsingi wo ijeera. Yeyo ikatema milhako cho ijera nkachaahulhia ni mittondoro chaattukachiye aya nkachaakwatuwacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Olhita ijera olhupalhe yonkweke, nkayoona wiira milhako cho ijera chihohulhiya, yahaanyihera wiira attukiye onkhaye ahottawacha, paahi etu yahotholholha uphanga aya nkayaathanana wiichiiva. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nansho Napaolo nkayaakhuwelha wo nlhove nulhupalhe, “Nhiichiive mwaanene! Hii onkhaye nirii va!” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Olhita aholhelhi nkayaavekelha wiira iwiihiye ikhandiri, nkaattimakelha mpaani, nkeewulhusha vamietoni va Napaolo ni Nasila uno athukumelhaka wo woova. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Paahi nkaakumiha vathe, nkaakoha, “Manyaapwiiya, kipangekeni etu kipatte woopolhiya?” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Napaolo ni Nasila nkayaamwaakhulha, eeraka, “Mwaarumelhelheke Athithi Yesu ni inyu nnowoopolhiya vamoka ni inupa inyu yonkhaye.” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Napaolo ni Nasila nkayaahimiachera nlhove ni Athithi, ayo vamoka ni ashilhoko aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yoyo uhiyu, olhita olhupalhe alhe nkaakusha Napaolo ni Nasila nkaahapihacha makhwata aya. Amalhiheke, yoyo vamoka ni manyaalhoko awe onkhaye nkayaabatiiziya. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Yamalheke vavawo nkaakusha Napaolo ni Nasila uwannyawe, nkaavaha yolhia. Uyo ni manyaalhoko awe nkayaattapelhelha chinene, ukhalhawaya vano yahonrumelhelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Waashelhe waya aholhelhi Arumi alhe nkayaaruma attu aya eerelhaka, “Mwaathaphulheke attu alhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Olhita ijera olhupalhe alhe nkaahimeria Napaolo, “Aholhelhi ahoruma nttenga wiira nttukulhiye. Vano nkhumeke nrweeke wo mpuha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nansho Napaolo nkayaakhulha eeraka, “Inakhalhaka khanaattekilhe ittu iriyoothe, yahonaata mikwaju vapuwani uno ni hii ninari anenchi o Urumi! Tho yahoneesha mpaani, vano anothanana unihiyerera wo nivitho. Khiyooriaka mena! Aweeke yayo ashinene ayo va anihulhelheke.” ");
INSERT INTO mgh2016_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Olhita olhupalhe alhe nkayaahimeria aholhelhi o Urumi yayo malhove ayo ni ayo yeeweke wiira Napaolo ni Nasila yaari anenchi o Urumi, yahoova chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Paahi nkayaarwaa uwaavarani mweto, vaamanlhe aya waakumiha mpaani nkayeerelha wiira athame yelhe iwani ilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Napaolo ni Nasila yahokhuma ujeerani nkayaarwaa uwani u Naridiya. Wowo yahokumaana ni attu anrumelhenlhe Kuristo. Yamalheke woopa mwaha ni nlhoko ulhe wo malhove o waavaha nrima, nkayaathama. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Napaolo ni Nasila nkayaarwaa aviraka iwani cho Uamfipoli ni Uapoloniya mpaka Uthesalonike, waari aya inupa yo unlhapelha Nlhuku ya Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Thoko chenre aya wo ulhemalhelha, Napaolo yahorwaa unupani wo unlhapelha Nlhuku. Ni wo Mahuku Owiittuwa mararu ahoopana attu mwaha unaacha Malhove Matakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ahohimiacha ni wooniha wiira Kuristo ahophwanelhiya wiira atwarushiye ni uhihimmwa unookhwani ahimiaka wiira, “Yesu kinonhimiacha aka phi Kuristo Moopolhi thanlhiye ni Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Akina yahorumelhelha nkayaalhutaana ni Napaolo ni Nasila. Tho, nlhoko mulhupalhe wa Ayunani yanthimicha Nlhuku vamoka ni manyaathiyana enchi o nhakhu, yaholhutaana ni ayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nansho Ayahudi akina nkayaakelhiya ihache, nkayaalhatulha attu o uhilhoka, nkayeesha nkutaano wo nlhatu wo utharamulha injarare iwani yonkhaye. Nkayaakelha unupani wa Nayasoni akhulhuvelhaka wiira anokowaapatta Napaolo ni Nasila yaawiihe upuwani. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nansho khayaapantte, paahi etu nkayaakweremiha Nayasoni vamoka ni ashilhoko akina mpaka wa aholhelhi o iwani, uno anyakulhachaka wiira, “Alha attu alha anootindaniha ilhapo yonkhaye ni vano arii vawanihuva. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ni Nayasoni ahaapochera uwannyaya. Ni ayo onkhaye anopanga mwaha uhinaathana ni malheheriyo a Akaisari, eeraka eti, hawo mwene nkina, neehaniya Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wo yayo malhove ayo yahaahelha ichuku aholhelhi o iwani ni attu onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Aholhelhi nkayaalhiviha Nayasoni ni akhunanaya nchurukhu wiira ahiyereriye, yalhiveke yahohiiya arwaache. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Uhiyu, nlhoko wa attu arumelhenlhe nkayaakurumicha Napaolo ni Nasila arwee Ubereya. Vaaphiilhe aya wowo nkayarwaa inupa yo unlhapelha Nlhuku ya Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Attu o wowo yaari owiiwelhelha chinene waapwaha attu o Uthesalonike alhe. Yahopochera nttenga wo wiiwelhelha chinene, nkayaawehaweha Malhove Matakatifu kila nihuku wiira yoone akhalhaka alhe yaahimiachiya ni Napaolo ni Nasila yaari ye ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Attu enchi yahorumelhelha tho manyaathiyana Ayunani o nhakhu ni manyaalhopwana e Iyunani yahorumelhelha chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nansho Ayahudi o Uthesalonike yeeweke wiira Napaolo yaari ahimiachaka nlhove na Nlhuku Ubereya, yahorwaa wowo, nkayaatharamulha injarare ni waathunalhiha milhoko cha attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nlhoko wa attu aarumelhenlhe alhe nkayaavelheelha Napaolo wo waakuva urwaa umbwaani nansho Nasila ni Natimotheo nkayaahalha Ubereya. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Attu yaavelhenlhe Napaolo alhe nkayaarwaa vamoka ni ayo mpaka Uathene. Yamalheke nkayaahokolhia ni malhehero ukhuma u Napaolo wiira Nasila ni Natimotheo arwee yaattware wo waakuva chinooria aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Napaolo vaari aya yaalhitelhelhaka Nasila ni Natimotheo Uathene, nrima aya nkawaarushiya chinene voonilhe aya iwani yonkhaye inachanre isinyago cho milhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yahoolhumana Ayahudi ni attu akina yanthimicha Nlhuku nnupani mwo unlhapelha Nlhuku, ni kila nihuku yaari olhumanaka vakittu vapangiya maronda ni attu onkhaye yaakhumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Attu akina yaattwara meettuchiho o Epikuro ni o Stoiki yahovaanyihanana ni ayo. Akina aya yeera, “Nothanana uhimiani ulha o upwesha mahulha ulha?” Akina aya nkayaakhulha, “Inowoonia thoko wiira nohimiacha malhove anaacha milhuku chilheto.” Yoolhumanche chiicho ukhalhawaya Napaolo yaahimiacha vachulhu ya Yesu ni vachulhu yo uhihimmwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paahi etu, nkayaakusha Napaolo, nkayaarweha wiipuwa yeehaniya Areopago, eeraka, “Ninothanana uchuwelha ulha mwaha wo naanano nnohimiacha inyu ulha. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nihowiiwani muulhumachaka chittu chilheto. Ninoothanana uchuwelha maana ya phi ishiyani.” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Anenchi o Uathene ni anenchi akina o wowo yaari akhalhaka ikatema aya yonkhaye wo uhimeriana ni wiiwelhelha mwaha wo naanano. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paahi, Napaolo yaheemelha upuwani Uareopago, nkayeera, “Anenchi o Uathene, kinowoona wiira wo iphiro iriyoothe mwaatti nri attu o idini chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Vaavira aka kiviraka uwo ni uwo kiwehawehaka isinyago chinolhapelhacha inyu, kahoona madhubahu ilhepiye, ‘Wa Nlhuku hinochuwania.’ Paahi, uyo nnonthimicha inyu wo uhinchuwelha, phi nonhimiacha aka uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nlhuku oopilhe ilhapo ni chonkhaye chiriwo ni Athithi o irimu ni ilhapo, yayo khanokhalha Inupa cha Nlhuku chithekiye wo miono cha attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mena khanothanana ittu iriyoothe, ukhalhawaya yayo anene phi naalhamiha attu ni wooriha umumulha ni waakawelha attu onkhaye kila ittu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Uchokholha wa ntu mmoka yahoopa ilhapo chonkhaye ni uthikitheria velhaponi vonkhaye. Aholhakelha upanga ilhapo ihinaaya yaakhani ni vayi chechiyo ilhapo chiyo unohalha aya ukhalha. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","“Nlhuku aapannge chiicho wiira chechiyo ilhapo chiyo chinkhulhuvelhe, inakhalhaka wo waapaapelhacha, chiwe champhiyelha, inakhalhaka kharii utayi ni kila mmoka ihu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Thoko chihimmie awe ntu mmoka, nhina mwawe hiyaano ninookhalha akumi, ninowiichooria ni ulhokelha!’ Thoko mmoka inyu owiipa ichipo chenre awe wo ikekhiaye wiira hiyaano phi ashaana awe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Yakhalhaka etu, hiyaano phi ashaana a Nlhuku, khinlhoka umwaanyihera Nlhuku ukhalha thoko idhahabu, nchurukhu ama nlhuku nihaniye ni urerihiya ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nlhuku aheepanga wiira thoko khanoona ikatema attu vaari o uhichuwelha valhe. Nansho vano nowaalhehera attu onkhaye kila vakittu akhorome. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ukhalhawaya homalha weesha nihuku ninohalha awe uhukumulha ilhapo we ikekhiaye wo iphiro yo ntu mmoka nrumelhenlhe awe. Nlhuku hooniha onkhaye ulha mwaha ulha wo unhihimusha unookhwani yoyo ntu uyo!” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Yeeweke Napaolo yuulhumachaka mwaha wo uhihimmwa unookhwani, attu akina aya yahothiaa, nansho akina yaheera, “Ninoothanana uwiiwani nhimiachaka yoyo mwaha uyo tho.” ");
INSERT INTO mgh2016_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Paahi, Napaolo nkayaahiya, nkayaathama vapuwani vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nansho attu enchi yahaattukana, ni ukhalha arumelhenlhe. Munlhokoni mwaya yaari Nadionisi yaari amoka mwa attu o ipuwa yo Areopago ni nthiyana amoka eehaniya Damaresi ni attu akina. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yamalhekeru, Napaolo ahothama Uathene nkayaarwaa Ukorintho. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wowo nkayaankumaana Nyahudi o nikosho no Uponto eehaniya Akwila, aahokolhelhe naanano ukhuma Uitaliya vamoka ni ahanu awe Aprisila. Aahokolhelhe wo nlhatu no woomolhiya na Amwene Nakilaudiyo aalhehenre wiira Ayahudi onkhaye athamache Urumi. Napaolo nkayaarwaa uwaashikuriani. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Naakwila ni Apurisila yaari o koorosha mahema thoko chaari aya Napaolo. Paahi etu nkayaakhalhana vamoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nkayaareriha ni attu wi inupa yo unlhapelha Nlhuku kila Nihuku no Wiittuwa alhikachaka waapatta Ayahudi ni Ayunani. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nasila na Natimotheo vaawiilhe aya ukhuma Umakedoniya, Napaolo yahovarelha nipesha naya nonkhaye no wiittuchiha ni waahimiachera Ayahudi wiira Yesu phi Kuristo Moopolhi thanlhiye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Vaavingiye aya ni uruwaniya, ahokuphulha ikuwo chaya ni weerelha, “Iphome inyu ikhalheke vachulhu inyu mwaashinene, mii akirina ittu iriyoothe yo ukuphulhachiya vachulhu yoyo mwaha uyo! Mii ki ntu orera, akiriwo. Ukhuma lhelho na kinokelha wa attu ahiri Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Paahi etu, nkayaathama vavawo nkayaarwaa uukhalhani unupani wa ntu mmoka ankhulhuvelha Nlhuku yeehaniya Natito Yusto, aakhalha vakhiviru ni inupa yo unlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nakurispo, olhupalhe emelhelha inupa yo unlhapelha Nlhuku iyo, ahaarumelhelha Athithi vamoka ni inupa aya, ni attu akina o Ukorintho ahopochera nttenga, nkayaarumelhelha ni ubatiiziya. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nihuku nimoka uhiyu Napaolo aholhoha itora Athithi eerelhaka wiira, “Nhoove, nthepeke uhimiacha nttenga, ");
INSERT INTO mgh2016_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ukhalhawaya mii kiri vamoka ni inyu. Khaawo nohalha uuhuvihani ukhalhawaya ata iwani ilha vaa, ahaawo attu awaka enchi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paahi Napaolo ahokhalha wowo eettuchihaka attu nlhove na Nlhuku iyaakha imoka ni nusu. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nansho Nagaliyo vaari aya atawara e Rumi o ilhapo yo Uakaya, Ayahudi wowo wo winchiva ahaavara Napaolo ni waarweha umilhatuni. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Nkayeeracha, “Ninommwiiha unlhatuni ulha ntu ulha wo nlhatu wo waashawishi attu unthimicha Nlhuku wo iphiro ihinaathana ni Malhehero.” ");
INSERT INTO mgh2016_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Napaolo ahinaya upatakulha malhaku wulhumacha, ashinna Galiyo nkayeerelha Ayahudi, “Nkeewani mwaatti mwa Ayahudi va! Yakaari ulha nlhatu ulha hopanga chittu cho uhilhoka ama hotteka kanowiiwelhelhani. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nansho yakhalhaka vachulhu mwaha wo waakhulhaniya malhove ni machina ni Malhehero inyu, mwaamulheke mwaashinene. Mii akinttuna ukhalha o uhukumulha milhatu thoko chechiyo!” ");
INSERT INTO mgh2016_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Paahi nkoomolhacha va ipuwa yo uhukumulhelhiya milhatu vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Attu onkhaye nkayaavara Nasositene, ntu mulhupalhe emelhelha inupa yo unlhapelha Nlhuku, nkayaatakachiya vavawo vapuwani va uhukumulhelhiya vawo. Nansho ashinna Galiyo khayalhonhe yeyo ittu iyo ata vakani. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Napaolo nkayaalhokelha Ukorintho wa nlhoko wa attu anrumelhenlhe Yesu wo mahuku menchi. Yamalheke nkaahiyacha, nkaawelha mmeelini nkaarwa Usiriya aattukanaka vamoka Aprisila ni Naakwila. Ahinaya uthama Ukinkreya ahohama ikharari mmuruni, chaashunnge aya ishaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nkayaaphiyacha Uefeso. Wowo Napaolo ahaahiyacha Aprisila ni Naakwila nkayaarwaa u inupa yo unlhapelha Nlhuku nkoopa mwaha ni Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Attu yahaalhepelha wiira athepe ukhalha wo mahuku menchi, nansho khayaattunne. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Vaathama aya enre wiira, “Nlhuku attunaka, kinoowa kaahokolhia tho uwaninyu.” Nkayaathama nkayaawelha mmeelini urwaa Uefeso. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Imeeli nkayaaphiya Ukaisariya, ni Napaolo nkayaarwaa Uyerusalemu uwaathotholhani attu anrumelhenlhe Kuristo Moopolhi, nkayaalheha nkayaarwaa Uantiokiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nkayaakhalha wowo wo mahuku vakani. Yamalheke, nkayaarwaa nkwaha wo uvira iwani cho Ugalatiya ni Ufirigiya aahelhaka nrima owiittucha onkhaye o wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nyahudi mmoka eehaniya Apolo o nikosho no Ualekizanderiya ahowa Uefeso. Yoyo aari ntu o wulhumacha rata ni o uchuwelha chinene Malhove Matakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aari aneettuchihiye mwaha wo Iphiro ya Athithi, apharelhaka unrimani, ahoolhumacha mwaha wa Yesu nkayeettuchiha wo ikekhiaye inakhalhaka yaari achuwelhaka ubatiizo u Nayohana yeekharu. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Aprisila ni Naakwila veewilhe aya ashinna Apolo olhumachaka wo uminda wi inupa yo unlhapelha Nlhuku, yahaakusha uwannyaya nkayeettuchiha yeyo iphiro ya Nlhuku iyo rata chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ashinna Apolo vonne aya wiira arwee Uakaya, nlhoko wa attu o Uefeso ulhe, yaahahelha nrima wo waavaha iwarakha yaalhepiye wa owiittucha wiira yaapochere ashinna Apolo ayo. Vaaphilhe aya wowo, wo nnema wa Nlhuku ahaakaviha rata chinene attu yanrumelhenlhe Yesu, ");
INSERT INTO mgh2016_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ukhalhawaya wo ikuru ahothepa waavaanyiha Ayahudi vaattuni ahimiecheshaka wo Malhove Matakatifu wiira Yesu phi Kuristo thanlhiye ni Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ikatema Naapolo vaari aya Ukorintho, Napaolo yahorwaa nhina ilhapo ni uphiya Uefeso, waaphwannye aya owiittucha enchi, ");
INSERT INTO mgh2016_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","nkayaakoha, “Chani, vaarumelhenlhe inyu mwahompochera Iphumu ya Nlhuku?” Ni ayo nkayaakhulha, “Mena khanineewa wiira haawo Iphumu ya Nlhuku.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Napaolo nkayaakoha, “Vano mwaapantte ubatiizo waani?” Ni ayo nkayaakhulha, “Ubatiizo u Nayohana.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Napaolo nkayeera, “Ubatiizo u Nayohana waari woowoniha attu ahokhoroma uwonya, ni waahimeria attu o Uisraeli wiira anrumelhelhe ulhe nowa kaanyuma aya, yaani Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Yamalheke wiiwa yayo malhove ayo, nkayaabatiiziya wo nchina na Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Napaolo nkayeesheracha miono vamuruni ni Iphumu ya Nlhuku nkaakhuruwelha nkayaachokholha wulhumacha wo nulhumo nilheto ni uhimiacha nttenga wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Attu onkhaye yaari aphiyelhaka khumi ni elhi. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Wo mieri miraru, Napaolo yaari arwaaka inupa yo unlhapelha Nlhuku, nkayaarerihana attu chinene mwaha wo waatelhiha unaacha Umwene wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nansho attu akina yaari o vaanyiha, ahinrumelhelha, yaachokhonlhe wulhumacha malhove o uhilhoka anaacha iphiro ya Athithi vaattuni. Vavawo Napaolo nkayaahiya yayo attu ayo, nkayaakusha owiittucha aya uchereshere nkayaarerihana kila nihuku unupani wo ushomelha i Natirano. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nkayeera chiicho wo iyaakha pilhi mpaka attu onkhaye o Uasiya, Ayahudi ni Ayunani yaheewa Nlhove ni Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nlhuku ahopangacha ithikineha cho ushangiha wo miono chi Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Attu yaari akushachaka ikitambaa ni ikuwo cho ukhuma mwiiruttuni mwa Napaolo, nkayaarwehelha areta ni ayo nkayaalhamihiya mareta aya. Ni mashoka o unanara yahothama wa attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ayahudi akina yoomolha mashoka o unanara yahorwaacha uwo ni uwo alhikachaka woomolha mashoka o unanara wo nchina na Athithi Yesu. Yaari yeerelhaka mashoka o unanara ayo, “Kinowoomolhani wo nchina na Athithi Yesu anohimiachiya ni Napaolo.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ashaana saba a ntu mmoka eehaniya Nasikewa, yaari Opochera ishaani olhupalhe a Ayahudi, yaari mu nlhokoni mwa attu yaapangacha chiicho. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nansho nshoka no unanara nkaneera, “Kinonchuwelha Yesu, ni waachuwelha Napaolo, nansho mwaattiva phi apani etu?” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ntu o mashoka o unanara uyo nkaathuphelha onkhaye wo nkhito, nkaawulhushacha. Nkayaattawacha pwithipwithi ukhuma inupa ya ntu o mashoka iyo anarakalhihachiye. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ayahudi onkhaye ni Ayunani o Uefeso uwo, aheewa yoyo mwaha uyo, nkayoova chinene nkayaathimicha nchina na Athithi Yesu. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Attu yaarumelhenlhe enchi yahowa, nkayaahimiacha vaattuni mwaha waari aya apangaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Akhwiri enchi, yahowiiha ichitabu chaapangelha aya ukhwiri vaattuni, nkayaapahacha mooro. Vaalhekelhiye aya, chahophiyelha uthumihiya wo nchurukhu ichipande maelufu makhumi nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Wo yeyo iphiro iyo, Nlhove na Athithi nkanaathepa uwanelha ni upatta machiri chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wamalheke yoyo mwaha uyo, Napaolo yahoona munrimani mbaya arwee Uyerusalemu wo uvira iwani cho Umakedoniya ni Uakaya. Yeera “Kaphiyaka wowo, kinoothanana uphiya ni Urumi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paahi nkayaaruma Natimotheo ni ashinna Erasto, yaaholhelhe urwaa Umakedoniya, anene ayo nkayaahalha thoko Uasiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Yeyo ikatema iyo nkayaanyuwa injarare yuulhupalhe Uefeso, wo nlhatu no Iphiro ya Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ntu mmoka o uhana iheera eehaniya Demetriyo, aari ni ntheko wo ukooroshacha isinyago cho inupa cha nlhuku nthiyana neehaniya Artemi, yoyo ntheko uyo wahaavaha anamitheko awe mahalha menchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nademetriyo ahaakumaaniha anamitheko ayo vamoka ni attu o mitheko thoko chawaya chiyo, nkayeerelha, “Mwaatti, nhochuwelha wiira nhakhu ihu unowa wa alha maronda alha. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Vano etu, nheewa ni woona mwaashinene mwaha unopangacha aya Napaolo ni ashikhunanaya. Aneera wiira milhuku chinokooroshiya wo miono cha attu chi, kachihiwe milhuku mena. Ahooria waarukunusha attu enchi, Uefeso va ni ata ilhapo yonkhaye yo Uasiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wo chiichammo etu, maronda ihu anookelhiya ikusu ni nchina no uhilhoka. Kuhiwe chiichoru, nansho ulha mwaha ulha unoonanariha inupa ya nlhuku Artemi. Utotopelhiya ni uthimichiya waya ni attu onkhaye o Uasiya ni ilhapo yonkhaye unoorimeelha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Attu yeewekeru yayo, nkayaarushiya chinene, nkayaakhuwelhacha, “Artemi phi olhupalhe o Uefeso!” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Injarare nkayaawanelha iwani yonkhaye. Nkayaavara Nagayo ni Naaristako, anenchi o Umakedoniya, akhunanaya Napaolo munkwahani nkayaattawiha mpaka inupa yaathwelhiya mihapo. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Napaolo anene yahothanana urwaa uvinganani ni yoyo nlhoko wa attu uyo, nansho owiittucha alhe yahaachiichiha. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Manyampwana aya akina, attu o pilhi o iwani yo Uasiya yahaarweehelha Napaolo nttenga wo waapepecha wiira ahirwee inupa yo mihapo anowiihelha itatako. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yeyo ikatema iyo kila ntu aari anyakulhaka, akina ittu imoka akina eeraka ilhe, mpaka nkutano ulhe nkawamwariaa ukhalhawaya attu enchi yaari ahichuwelhaka nlhatu no ukumaana waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayahudi akina nkayoona wiira Naalekizanda phi nlhatu, nkayaakhanyererihiya wiira eemelhe uholho. Paahi Naalekizanda nkayaapunga moono waamaalhiha attu wiira eevaraange vaattuni vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nansho yachuwelheke wiira ni ayo aari Ayahudi, attu onkhaye nkayaakhuwelhacha wo isaa pilhi wo nlhove nimoka eeraka, “Artemi phi mulhupalhe o Uefeso!” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yamalheke, akarani emelhelha iwani, yahooria waamaalhiha attu, venre aya, “Anenchi o Uefeso, kila ntu hochuwelha wiira ilha iwani yo Uefeso ilha phi nolhitelhelha inupa ya nlhuku Artemi ni yo ulhitelhelha nlhuku niteelhihiye naamonre ukhuma wiirimu nne. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Khaawo ntu nooria uruna yoyo mwaha uyo. Paahi etu, nkamaalhani, nhipange ittu iriyoothe yo unanara. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nhaawiiha alha attu alha va, anakhalhaka kheeyilhe nnupani mwa nlhuku mena unruwana nlhuku ihu nthiyana. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Akhalhaka Nademetriyo ni anamitheko aya arii ni milhatu chaya vachulhu ntu riyoothe, chihawo ipuwa cho uhukumulhelha ni attu o uhukumulha, chirweehiyeke milhatu chaya wowo etu. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yakhalhaka nhanaa milhatu chikina, nrweeheke cholhumachiyeke unokumaana aya attu, unoolhumachiya Malhove Orera. ");
INSERT INTO mgh2016_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ukhalhawaya naanooria upatta milhatu cho waatharamulha attu wo chi chikhumelhenlhe lhelho chi. Chi injarare chi khachirina muru mena hiyaano khanirina nlhatu wo uchuwania vachulhu waya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Amalhiheke wulhumacha yayo, ahomwarusha nkutano. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Injoove ilhe yatondoveke, Napaolo yaheehana vamoka owiittucha alhe, nkayaahelha wo waavaha malhove o waahelha nrima. Yamalheke nkayaarwaa Umakedoniya. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Yahovira mmawani mwo cheechiyo ilhapo chiyo yaavahaka attu malhove menchi o waahelha nrima. Nkayaaphiya Uyunani, ");
INSERT INTO mgh2016_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","waakhanlhe aya wo mieri miraru. Vaari aya echeshaka rata wo nkwaha wo Usiriya, yahochuwelha miruku chaapangia ni Ayahudi cho waapangelha chittu cho unanara. Paahi etu nkayaahokolhia wo uvirelha Umakedoniya. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Aattukanne ni Nasopatro mwaana a Napirho, o Ubereya, tho ni Naaristako ni Nasekundo o Uthesalonike ni Nagayo ukhuma Uderbe ni Natimotheo ni Natikiko ni Natrofimo o Uasiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yayo ahoholhelha ni unilhitelhelha Utroa. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ni hii, yamalheke isikuukuu yo mikatte cho uhichukumanihiya, nahowelha imeli Ufilipi ni yavireke mahuku mararu nkanaaphwanya Utroa. Nkanaakhalha wowo ijuma imoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nihuku no Jumaamosi nahokumaana wiira nimiee nkatte. Ukhalhawaya Napaolo yaalhakenlhe uthama waashelhe waya, yahaahimiachera attu Nlhove na Nlhuku ni waarerihana wo uthepa mpaka uhiyu iriyari. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ikhandiri chinchi chahopharihelhiya nchuumbani inupa yo nchulhu mwaari ihu ninakhanlhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Napaolo vaari aya athepaka uhimiacha Nlhove na Nlhuku, mmirawo mmoka eehaniya Yutiko aakhanlhe vandirishani ahochokholha uhichilha vakanivakani. Ikhove nkachankusha, nkaathoromwaa vathi ukhuma inupa yo nchulhu yo neraru. Nkaarokottiya nakhwilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nansho Napaolo nkayaakhuruwa vathi, nkayooroma nkayankumbatira eeraka, “Nhikelhiye nipampa, nkumi ulha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yamalheke nkaawelha tho uchulhu nkayaamia nkatte nkayaalhia. Nkayaathepa uhimiacha Nlhove na Nlhuku mpaka mapikoosha, nkayaathama. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Attu alhe nkayankusha mwammirawo ulhe unrweeha uwaani nari nkumi, uno anateelhiye chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Hiyaano nkanaawelha imeli nkanaholhelha Uaso wakaakushilhe ihu Napaolo. Ukhalhawaya anilhehenre wiira yahothanana uphiya wowo wo iphiro yo vathi. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paahi, nkayaaniphwanya Uaso, nkanaakusha mmelini nkanaarwaa Umitilene. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ukhuma wowo nahorwaa ni uphiya Ukiyo waashelhe waya. Nihuku no nayelhi nahophiya Usamo ni waashelhe waya nahophiya Umileto. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Napaolo yahoona wiira awelhe imeli wo uhivirelha Uefeso wiira ahicherewe chinene Uasiya. Wo uchuwelha wiira yaari yaakuvelhaka uphiya Uyerusalemu nihuku no isikuukuu yo Pentekote yoriaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Vaari aya Umileto Napaolo yahorweha nttenga wa ashulhupalhe o nlhoko wa attu anrumelhenlhe Kuristo no Uefeso wiira awe yaakumanane. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ashulhupalhe alhe yaweekeru, Napaolo nkayeerelha, “Nhochuwelha chenre aka wo ukhalha ni inyu mwaatti mahuku onkhaye uchokholhaka nihuku kiphiilhe aka Uasiya wiikani nne. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nhochuwelha chinre aka wo uvara ntheko wa Athithi, wo wiitimarikha chinene, wo miithori ni itatako chikipantte wo miruku cho uhilhoka cha Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nhochuwelha wiira akaahiilhe ata vakani uuhimiacherani Nlhove na Nlhuku ni uwiittuchihani voonene ni mmanupani mwinyu ittu iriyoothe yo uukavihani. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kahaamuka Ayahudi ni Ayunani wiira onkhaye ahiye uwonya waya anrukunuwelhe Nlhuku, apishe nrima ni waarumelhelha Athithi Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Vano etu, wo wiiwelhelha Iphumu ya Nlhuku, kinokelha Uyerusalemu kihichuwelhaka chinohalha ukipatta wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ittu inochuwelhihiya aka ni Iphumu ya Nlhuku kila iwani, irii imoka. Waamukiya wiira uttukiya ni utwarushiya phi nokilhitelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nansho, khakinolhoha ukumi aka ukhalha ittu chinene uwannyaka, ihikhalhe utimiriha urumiya waka ni ntheko ukivanhe aya Athithi Yesu kipange, yaani kihimiecheshe Malhove Orera o nnema wa Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kihovira mmwannyu mwaattiva onkhaye kihimiachaka Imwene ya Nlhuku. Ni vano etu, kihochuwelha wiira khaawo ata mmoka inyu nohalha ukoona tho. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Paahi etu, lhelho nna kinouhimeriani vo ureraru wiira, akirina nlhatu wo unanara vachulhu iphome ya ntu riyoothe! ");
INSERT INTO mgh2016_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ukhalhawaya akihiilhe ata vakani uuhimeriani mattunelho a Nlhuku onkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Paahi etu, mwiichinanelheke mwaashinene, nshungeke mphingo wa attu nvahiye inyu ni Iphumu ya Nlhuku wiira mwaalhelhe. Nshungeke attu o nlhoko wa attu anrumelhenlhe Kuristo na Nlhuku nipantte awe wo iphome yo Mwaamwanawe. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Kihochuwelha rata chene wiira vanothama aka miichi cho uchacha chinoukelhelhani ni umwarusha mphingo, chihoonelhaka ikiriri yoyo mphingo uyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ikatema inoowa, attu o munlhokoni mwinyu vanohalha aya uhimiacha mwaha wo woothacha wiira yaapoterihe owiittucha anonrumelhelha Kuristo wiira yaatware yayo attu ayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Paahi etu nshiheke muupuwelhaka wiira wo iyaakha taaru, uthana ni uhiyu, kahomwiittuchiha kila mmoka inyu kunlhaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Vano etu, kinouhiyani mmathathani mwaya Athithi Nlhuku ni nttenga wo nnema waya unooria uuthekani ni uuvahani ibarakha yenshe awe wa attu ahapihilhe awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mii ata mena vamoka akanvekenlhe ntu riyoothe nchurukhu mena idhahabu mena ikuwo. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwaattiva mwaashinene mwahokoona vaavara aka mitheko wo wiikavihera wo miono chaka kimwanene, wiira kipatte chaathanana aka ni cha akhunanaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Wo kila iphiro kihowoonihani wiira wo uvara ntheko thoko chommo, ninoothananiya waakavihera attu ahineechoria, nuupuwelhaka malhove a Athithi Yesu anene venre aya, ‘Ahoreeriya chinene anokumiha upwaha ampochera.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Napaolo amalhiheke wulhumacha yayo, ahokhoroma vamoka ni attu alhe onkhaye, nkayaanlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nkayaalhehana wo ukumbatirana ni Napaolo, onkhaye yunlhaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nlhove naahenlhe ihuzuni chinene attu naari noolhumanche aya Napaolo wiira khanowa ooniya tho. Paahi, nkayaavelhelhiya mpaka umeelini. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Namalheke ulheehana ni attu ayo, nahowelha mmeelini nkanaarwaa Ukosi. Waashelhe waya nkanaaphiya Urode, nathameke wowo nkanaarwaa Upatara. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wowo nahophwanya imeli yaarwaa Ufoinike, nkanaawelha nkanaarwaa. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nahophiya vakittu voonrie ihu woona iwani yo Ukipro, nkanaavira mpatta waya wo uchawa nkanaalhukama Usiriya. Nkanaaphiya iwani yo Utiro, imeli ilhe waakurusha aya misigo chaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Wowo nahoona owiittucha yanrumelhenlhe Kuristo, nkanaakhalhana ijuma imoka. Attu anrumelhenlhe Kuristo ayo nkayoolhumacha wo machiri a Iphumu ya Nlhuku nkayeerelha Napaolo wiira ahirwee Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nansho mahuku ihu yamalheke nahothama nkanaarwaa. Akuristo onkhaye, manyaalhopwana vamoka ni manyaahanu aya ni achishaana aya yahonivelhelha mpaka umbwaani. Nkanaakhoroma onkhaye nkananlhapelha Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yamalheke nkanaalhehana kila mmoka, hiyaano nkanaawelha mmeelini ni ayo nkayaahokolhia umawannyaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hiyaano nkanaathepa urwaa munkwahani wihu. Nathameke Utiro nkanaaphiya Utolemaisi waashikunrie ihu ashilhoko ihu Akuristo, nkanaakhalha wo nihuku nimoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Waashelhe waya nahothama nkanaarwaa Ukaisariya. Wowo nahorwaa unupani u Nafilipo yaahimiacha Nlhove na Nlhuku. Yayo yaari amoka aya saba yaathanlhiye ukhalha okaviha o nlhoko wa attu anrumelhenlhe Kuristo no Uyerusalemu alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yayo yahaana imialhi acheshe yaavaheriye ukhalha anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Naholhokelha wowo wo mahuku menchi, vaawilhe awe namilhohi mmoka a Nlhuku aakhumme Uyudea neehaniya Naagabo. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yoyo ahoniweelha, nkaakusha nchako u Napaolo, nkeettuka mmiononi ni mmietoni, nkeera, “Iphumu ya Nlhuku neera wiira, Mwanene ulha nchako ulha nokottukiya thoko cho ni Ayahudi o Uyerusalemu ni uhelhiya mmiononi mwa attu ahiri Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Neeweke chiicho, hiyaano ni attu akina yaari vavawo alhe nahaalhepelha Napaolo wiira ahirwee Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nansho Napaolo nkayaakhulha, “Nnonlhani vano, chani nnothanana ukuntha nrima aka? Kirii tayari kuhiwe uttukiyaru Uyerusalemu, nansho ata ukhwa wo nlhatu no nchina na Athithi Yesu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Noochelheke waachiichiha nkanaamalha, nkaneera, “Chiirieke etu thoko chinothanana aya Athithi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yamalheke, nkanaattuka mirupa chihu cho munkwahani, nkanaarwaa nkwaha ihu wo ukelha Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Owiittucha akina o Ukaisariya alhe nahaattukana, nkayaanirweha uwani u Namnasoni waakelha ihu umakelha wo mahuku. Nanasoni aari nnenchi o Ukipro Akuristo o mahuku menchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Naphiyeke Uyerusalemu, ashilhoko ihu yanrumelhenlhe Kuristo yahonipochera rata chene. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Waashelhe waya Napaolo yahorwaa vamoka ni hii uwoonani Nayakhobo. Ashulhupalhe o nlhoko wa attu anrumelhenlhe Kuristo onkhaye ni ayo yahowa. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Napaolo yaashikurieke attu onkhaye, yahohimiacha chittu chonkhaye Nlhuku chaapannge awe mwa attu ahiri Ayahudi wo iphiro yo ntheko waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Attu ayo yeeweke yayo, yahonthimicha Nlhuku. Yamalheke nkayeerelha Napaolo, “Munna Napaolo, nnowoona vano wiira ahaawo maelufu menchi ya Ayahudi chinre aya wo urumelhelha, ni onkhaye ayo chineera aya wo wiinanelha Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ahohimeriya mwaha inyu wiira nnooweettuchiha Ayahudi anokhalha ilhapo cha attu ahiri Ayahudi, wiira ahilhohe Malhehero a ashinna Musa, aheenelhe achishaana aya unyawo ni uhiya uttwara malhemalhelho a Ayahudi ");
INSERT INTO mgh2016_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Vano inaakhalheke chani etu? Ukhalhawaya we ikekhiaye anowiiwa wiira nhowa vaa. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Paahi etu, cho phi nothanana ihu wiira mpange. Nihanaa va attu acheshe attunke ishaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mwaattukaneke attu uulhapelhani ni wiihapiha. Mwaalhivelheke nchurukhu unothananiya, yamalhaka ahamiyeke ikharari chaya. Yamalhaka etu, attu onkhaye anoochuwelha wiira mwaha uhimeriye aya ulhe uri wowoothachiya ni inyu mwaanene nri mpaka nna nvarecheshaka ni uttwara Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nansho wa attu yanrumelhenlhe Kuristo ahiri Ayahudi, nihaarweehelha iwarakha yo waachuwelhiha mwaha wiiwananne ihu, ahilhie isadaka iriyoothe ilhapelhelhiye mashoka mena ahiwurie iphome mena ahilhie inama yo mwannama chipulhiye ishiko ni mena ahiwehewehe mwaha wo ishembwere.” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paahi etu, Napaolo nkayaakusha attu alhe nkayaalhapelha ni wiittukuria vamoka ni ayo thoko chaalhemalhelhiye aya. Yamalheke nkayaakelha Inupa ya Nlhuku uuhimiachani nihuku no umalhiha wiittukuria, vanohalha aya ukumihiya isadaka wo nlhatu wo kila mmoka aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nansho yayo mahuku saba ayo vaatameria aya umalha, Ayahudi yaakhumme ilhapo yo Uasiya yahoona Napaolo Inupa ya Nlhuku. Paahi, nkayaahelha ichimwa mmamirimani mwo nlhoko wonkhaye wa attu, nkayaavara Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nkayaakhuwelhacha yiiraka, “Anenchi o Uisraeli, nnikavihe! Ulha phi ulhe ntu neettuchiha attu kila vakittu mwaha unovingana attu o Uisraeli, unovinga Malhehero a ashinna Musa ni Inupa ya Nlhuku. Ata vano nna haakelhiha Ayunani wi Inupa ya Nlhuku ni unyalhiha vatakatifu va” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Yoolhumacha chiicho wo waanyihera wiira Natrofimo, anenchi o Uefeso yaari vamoka ni Napaolo vawani, yahokelhihiya ni Napaolo Inupa ya Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Injarare nkayaawanelha iwani yonkhaye, attu nkayaawa uwo ni uwo, nkayaavara Napaolo, nkayaapurulha mpaka vachereshere Inupa ya Nlhuku ni vavawo milhako cho Inupa ya Nlhuku nkachaatteiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Attu vaari aya aatameriaka weeva Napaolo, nttenga wahorwaa ni waaphiyelha olhupalhe a manyaasikari o Urumi wiira injarare ihokelha Uyerusalemu wonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yeyo ikatema mulhupalhe a manyaasikari nkaakusha manyaasikari olhupalhe akina ni manyaasikari aya nkayaattimakelha unjarareni. Ni ayo vamonne aya ni manyaasikari awe, nkayaahiya waakukutta Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mulhupalhe o manyaasikari nkaarwelha Napaolo, nkaavara ni ulhehera wiira attukiye mittondoro miilhi. Yamalheke nkaakoha, “Phi mpani yolha ntu ulha, ana panngeni?” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Attu akina munlhokoni mmo yaari akhuwelhaka ilha, akina akhuwelhaka ilhe. Wo nlhatu no uhiiwananiya uwo, mulhupalhe o manyaasikari khoonrie uchuwelha ikekhiaye yo nlhatu. Paahi etu, ahaalhehera attu awe waarweha Napaolo waari ikambi yo manyaasikari. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Waphiiyeke vanivatoni, manyaasikari yahaathatha vachulhu Napaolo wo nlhatu no injarare chaapangiya ni attu. ");
INSERT INTO mgh2016_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ukhalhawaya nlhoko mulhupalhe wa attu waahaattwara akhuwelhaka, “Eeviye, mwiive!!” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Vaari aya akelhihiyaka nningomeni, Napaolo yahaalhepelha olhupalhe o manyaasikari eraka, “Chani akinochiichihiya uhimeriani ittu?” Olhupalhe alhe nkaakhulha, “Ana ni inyu nnoochuwelha wulhumacha Iyunani! ");
INSERT INTO mgh2016_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ana inyuva kanhiwe phi ulhe Mmisri machurichuri va aanitindanihilhe ni waaholhelha attu o uvara makhuche maelufu ncheshe mpaka uthakoni?” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Napaolo nkayaakhulha, “Miyaano ki Nyahudi, kiyareelhe Utaso ilhapo yo Ukilikiya, miyaano ki nnenchi o iwani yo uchuwania chinene. Kinoulhepelhani, chonte, nkihiye kuulhumache ni attu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mulhupalhe o manyaasikari ulhe nkaahiya yuulhumache. Paahi, Napaolo nkayeemelha vamavatoni nkayaapungelha attu alhe moono, yamaalheke, nkayaachokholha woolhumana wo nulhumo ne Iebraniya. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Manyaalhopwana, ashilhoko aka va, nkiiwelhelheke vano vaneevaranga aka uholho winyu!” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Attu veewilhe aya Napaolo yuulhumachaka wo nulhumo no Iebraniya nkayaathepa umaalha. Ni ayo nkayaathepa wulhumacha eeraka, ");
INSERT INTO mgh2016_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Miyaano ki Nyahudi, ntu yareelhe Utaso ilhapo yo Ukilikiya. Nansho kilhelhiye va Yerusalemu vava mmiononi mwa owiittuchiha Nagamalieli. Kaheettuchihiya rata uttwara wo nrima wonkhaye Malhehero a ashinna Musa. Kaheekumiha wo uminda chinene unrumelhelha Nlhuku thoko chiri inyu mwaattiva mwaashinene lhelho va. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kahaatwarusha ata weeva attu yaatwara ilha iphiro ilha. Kahaavara manyaalhopwana ni manyaathiyana ni waattuka ujeerani. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Opochera ishaani Olhupalhe ni ipuwa yonkhaye ya ashulhupalhe anowooria uhimiechesha yoyo mwaha uyo. Uwannyaya kahopochera iwarakha yaalhepiye urweehiya wa ashilhoko ihu Ayahudi yaari Udameski. Kahorwaa wiira kaavare yayo attu ayo ni waawiiha anattukiye mpaka Uyerusalemu wiira atwarushiye.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Paahi, vaari aka mphironi kaatameriaka uphiya Udameski, uthana variyari, wo uhikhulhuvelha nchakarimia nulhupalhe nahoverunya wiirimu, nkanaakimwalheelha ni ukirukureria. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Vavawo nkakaawulhuwa vathi, nkakeewa nlhove nikiirelhaka, ‘Sauli, Sauli! Woonaka unookitwarusha?’” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ni mii nkakaakoha, ‘Thithi, Apani inyuva?’ Ni ayo nkayaakiirelha, ‘Miyaano phi Yesu o Unazareti. Nnokitwarusha va.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Attu yaari ni mii alhe yahoona nchakarimia nne nansho khayeewilhe nlhove ni ulhe olhumacha ni mii ulhe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“ ‘Paahi etu, Kiireke chani etu Thithi?’ Nkakaakoha. Ni ayo Athithi nkayaakiirelha, “ ‘Mweemelheke, nrweeke Udameski ni wowo nnokoohimeriya chonkhaye chinothanana aka mpange.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wo nlhatu no nthimicho mulhupalhe ulhe khakoona. Paahi etu akhunanaka alhe nkayaakiholhelha wo ukivara moono mpaka Udameski.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Wowo ahokhalha ntu mmoka anthimicha Nlhuku eehaniya Ananiya, ntu owiinanelha Malhehero a ashinna Musa aahimiecheshiya chinene munlhokoni mwa Ayahudi yaakhalha Udameski. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yayo yahowa uukoonani, nkayeemelha wo ukaatama, nkayeera, ‘Munna Nasauli, mwoone tho!’ Yeyo ikatema nkakoona tho, nkakaaweha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ananiya nkayeera, ‘Nlhuku a manyaapwiiya ihu hothanlhani wiira nchuwelhe chinothanana awe ni umoona Uyo e ikekhiaye uyo ni umwiiwa yoyo mwanene arerihaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ukhalhawaya nnowa mwanhimiechesha wa attu onkhaye mwaahimeriaka chilhe choonilhe inyu ni wiiwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Vano etu, nnocherewani? Mweemelheke mwabatiiziyeke ni uhiyereriya uwonya winyu wo ulhapelha nchina nawe.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Paahi kahohokolhia Uyerusalemu ni wowo vaari aka kilhapelhaka Inupa ya Nlhuku, kahoonihiya ntora. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Kahoona Athithi Yesu akiirelhaka, ‘Mwaakuvieke! Nthame Uyerusalemu wo waakuviaa ukhalhawaya attu o va khanorumelhelha uhimiechesha winyu unokaacha mii.’” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nkaakhulha, “ ‘Thithi!’ Ayo ahochuwelha wiira miyaano phi yolhe aaviravira inupa cho unlhapelha Nlhuku nkakaavara ni waatakacha attu yo urumelhelhani alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ata ikatema akarumiya inyu Nastefano o uhimiechesha Kuristo veeviye aya, miyaano kimwanene kaari vavawo, nkakaarumelhelha yoyo mwaha uyo ni ulhitelhelha miinjiro cha attu yeeva alhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Athithi nkayaakiirelha, ‘Nrweeke, kinourumani utayi wa attu ahiri Ayahudi.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Attu yaari yeewelhelhaka Napaolo mpaka vavawo, nansho yoolhumacheke yayo, nkayaakhuwelha, “Mwaathamihe velhaponi! Eeviye! Ntu thoko ulha khaphwanelhiye ukhalha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nkayaathepa ukhuwelha akuphulhachaka miinjiro chaya amwarushaka ntukurukhu wiirimu wo urushiya chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mulhupalhe a manyaasikari Nrumi aheerelha manyaasikari awe yaarweehe Napaolo nningomeni. Nkaalhehera Napaolo yaatiye mikwaju wiira achuwelhe nlhatu no unyakulha wa Ayahudi. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nansho Napaolo yaattukiyeke wiira yaatiye mikwaju, yahonkoha mulhupalhe a manyaasikari mmoka emenlhe vavawo, “Chani, ihorera mwaatti umwaata mikwaju nnenchi o Urumi hinaaya uhukumulhiya?” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Olhita ulhe eeweke yayo nkanhimeria olhita mulhupalhe eeraka, “Nnothanana upanga ittu yaani? Ulha ntu ulha nnenchi o Urumi!” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Paahi etu, mulhupalhe o manyaasikari olhita nkaarwelha Napaolo, nkaakoha eeraka, “Nkakihimerieni, chani, inyuva mwa anenchi o Urumi?” Napaolo nkayaakhulha, “Eiyo.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mulhupalhe o manyaasikari olhita ulhe nkeera, “Mii kihokhalha nnenchi o Urumi wo ulhiva nchurukhu mwinchi.” Napaolo nkayeera, “Nansho miyaano nnenchi o Urumi wo uyaria.” ");
INSERT INTO mgh2016_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Attu yeechenshe rata waakohakoha Napaolo alhe yahothama. Ata olhita mulhupalhe ulhe ahoova wo uchuwelha wiira Napaolo yaari anenchi o Urumi ni wiira yaari mpaani anattukiye. ");
INSERT INTO mgh2016_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mulhupalhe o manyaasikari olhita ahothanana uchuwelha ikekhiaye yo milhatu chonkhaye chaareeiye aya Napaolo ni Ayahudi. Paahi waashelhe waya yahaattukulha Napaolo mittondoro, nkayaalhehera opochera ishaani olhupalhe ni Ipuwa yonkhaye akumaane. Yamalheke nkayaawiiha Napaolo, nkayeemesha wi Ipuwa yo milhatu. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Napaolo nkayaaweha chinene attu o wi Ipuwa ayo nkayeera, “Ashilhoko aka, mpaka lhelho nna nrima aka uri woombone, kikhalhaka mmiholho wa Nlhuku mpaka lhelho nna.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Vavawo Opochera ishaani Olhupalhe ashinna Ananiya nkayaalhehera attu yeemenlhe waatameria Napaolo alhe yaakwatte uwanoni. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paahi, Napaolo nkayeerelha, “Nlhuku mwanene noukwattani inyuva nnepanga orera nrima va! Nnoorieke chani ukihukumulha wo uttwara Malhehero uno mwaanene munthaka, vanolhehera inyu wiira kikwattiye?” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Attu yaatamenrie Napaolo nkayeera, “Inyuva, nnowaaruwana Opochera ishaani Olhupalhe a Nlhuku!” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Napaolo nkayaakhulha, “Ashilhoko aka, mii khakaachuwenlhe wiira yayo phi Opochera ishaani Olhupalhe. Ukhalhawaya Malhove aneera, ‘Nhuulhumache pufia wa nholhelhi inyu.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Vavawo Napaolo yachuwelheke wiira attu akina va Ipuwa vawo yaari Amasadukayo ni akina Amafarisayo, yahokhuwelha, “Ashilhoko aka, miyaano ki Mfarisayo, mwaana a Mfarisayo. Kiri vamilhatuni va ukhalhawaya kinookhulhuvelha wiira akhwilhe anoohihimushiya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Yoolhumacheke yayo, Amafarisayo ni Amasadukayo khayeewananne, nkayemianiha milhoko miilhi. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nlhatu ukhalhaka wiira, Amasadukayo aneera wiira attu akhwilhe khanohihimushiya ni mena khachiwo minepa o wiirimu ama mashoka. Nansho Amafarisayo anoorumelhelha yayo onkhaye mararu ayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Attu nkayaathepa unyakulha, ni owiittuchiha Malhehero a ashinna Musa akina o nkutiro wa Amafarisayo amoka yahothunalha, nkayeemelha ni wulhumacha amindaka wiira, “Khaninoona ittu iriyoothe yo unanara wa ulha ntu ulha. Inowooria wiira nshoka ama nnepa wa Nlhuku uhomuulhumana.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Waakhulhaniya wahothepa ata mulhupalhe o manyaasikari nkoova wiira Napaolo anomianihachiya itturiitturi. Paahi etu nkayaalhehera manyaasikari aya akelhe iriyari yo mphingo ulhe, yaathamihe Napaolo ni waahokolhosha waarweha nningomeni. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Uhiyu waya Athithi nkayeemelha vakhiviru va Napaolo, nkayeerelha, “Nvareke nrima! Nhokihimiechesha va Yerusalemu va, nnokoopanga thoko chiichammo iwani yo Urumi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Washeeke, Ayahudi akina yahokumaana nkayeesha ntemera. Nkayaalhupelha eeraka, khaninolhia mena uwuria ittu iriyoothe mpaka vanohalha ihu weeva Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Attu yeenshe ntemera uyo yaari apwahaka makhumi ncheshe. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nkayaarwaa wa Opochera ishaani Olhupalhe ni ashulhupalhe nkayeera, “Hiyaano niholhupelha wiira khaninolhia ittu iriyoothe mpaka vanohalha ihu weeva Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Vano etu, mwaattiva vamoka ni Ipuwa yo milhatu nrweeheke nttenga wa olhupalhe o manyaasikari o Urumi wiira yaawiihe Napaolo uwaninyu, mwiichootheriaka wiira nnothanana ukohakoha nchuwelhe rata mwaha unaacha. Niri tayari weeva ata ahinaya waatameria va.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nansho mwaana a mwanrokoraya Napaolo aheewa cheechiyo miruku chiyo, paahi nkaarwa uningomeni, nkaalhelha Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Vavawo Napaolo nkayaamwiihana olhita mulhupalhe mmoka, nkayaamwiirelha, “Munkusheke ulha mmirawo ulha munrweeheke wa olhupalhe o manyaasikari, hanaa ittu yo waahimeria.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Olhita mulhupalhe nkankusha mmirawo uyo, nkanrweha wa olhupalhe o manyaasikari, nkeera, “Napaolo, attukiye alhe, yahookihana nkayaakilhepelha kimmwiihe ulha mmirawo ulha uwaninyu ukhalhawaya ri ni nlhove no uhimeriani.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mulhupalhe o manyaasikari ulhe nkammara moono mmirawo ulhe, nkayaathama ni unrweha untemerani, nkayankoha, “Urinani yo ukihimeria?” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mmirawo ulhe nkeera, “Ayahudi aheewanana ovekelheni meelho mwaarweehe Napaolo wi Ipuwa, echotheriaka wiira Ipuwa inothanana uchuwelha rata mwaha unaacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nansho nheewelhelhe, ukhalhawaya ahaawo attu ampwaha makhumi ncheshe aheevitha weethelha wiira avariye. Aholhupelha wiira ahilhie mena uhiwuria ittu mpaka vanohalha aya weeva Napaolo. Arii tayari upanga chiicho, anolhitelhelha nlhove ninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Olhupalhe o manyaasikari nkaanlhehera, “Nhihimie wa ntu riyoothe wiira nhokihimeria ulha mwaha ulha.” Nkanhiya mmirawo uyo arweeke. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Paahi, mulhupalhe o manyaasikari nkeehana olhita olhupalhe elhi nkeerelha, “Mweesheke tayari manyaasikaari imia pilhi, manyaasikaari o uwelha afarasi makhumi saba ni manyaasikaari o mavaka imia pilhi, arwee Ukaisariya, akhalheke tayari uthama ihinaaya uphiya saa tatu uhiyu wo lhelho. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mweesheke afarasi akina o waakusha Napaolo, mwenkelhe ni waapiha u Nafeliksi, atawara Arumi anari akumi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Olhupalhe alhe nkayaalhepa iwarakha yeera cho, ");
INSERT INTO mgh2016_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Isalamu chiuphwanyeni Munna Nafeliksi, atawara o ilhapo yo Uyudea. Mii Kilaudiyo Lusiya kinolhepa iwarakha yo uwa uwaninyu kihimiachaka wiira, ");
INSERT INTO mgh2016_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayahudi yahommara ulha ntu ulha, nkayaaphiyelha umwiiva. Kachuwelheke wiira aari nnenchi o Urumi, nkakaarwaa vamoka ni olhita aka nkakaamoopolha. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nkakaathanana uchuwelha nlhatu waya, paahi nkakanrweha Upuwani waya. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Khakoonne wiira hopanga ittu iriyoothe inophwanelhiya wiiviya ama uttukiya ujeerani, nansho milhatu chene chaari uvaanyihana mwaha wo Malhehero a ashinna Musa. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Vavawo kahimeriyeke wiira Ayahudi ahopanga miruku cho umwiiva, nkakoona kimmwiihe uwaninyu. Nkakaalhehera attu attekelhiye alhe wiira awiiheke milhatu chaya uwaninyu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Manyaasikaari alhe nkayaakusha Napaolo yoyo uhiyu uyo thoko chaalheheriye aya, nkayaarweeha mpaka Uantipatiri. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Waashelhe waya olhita o mieto nkayaahokolhia ungoomeni nkayaahiya olhita o waawelha afarasi arwaaka vamoka ni Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Yaphiyeke Ukaisariya, nkayaavaha iwarakha ilhe atawara olhupalhe o ilhapo ni weesha Napaolo mmathathani mwaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ntawara mulhupalhe o ilhapo ashomeke iwarakha ilhe nkaakoha, Napaolo akhumme ilhapo yaani. Yachuwelheke wiira akhumme ilhapo yo Ukilikiya, ");
INSERT INTO mgh2016_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nkayeerelha Napaolo, “Kinowa wiiwelhelha milhatu chinyu kaanyuma vanohalha aya uwa attu awinhe milhatu chinyu.” Paahi nkayalheehera Napaolo yeeshiye mmathathani mwa attu olhita nhina ingome i Naherode. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Yavireke mahuku nthanu Opochera ishaani Olhupalhe Ananiya, yahowa Ukaisariya vamoka ni ashulhupalhe akina ni o wemelhelha Ikekhia amoka aneehaniya Tetulo. nkayaarwelha Nafeliksi aatawara ilhapo nkayaahimeria milhatu chi Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Napaolo nkayeehaniya ni Natetulo nkayaachokholha milhatu. “Nkayeera, Munna Nafeliksi! Uholhelhi inyu woombone uhowiiha mpuha wo mahuku menchi ni ukooroshiya chinothananiya unopangiya wo nlhatu no ilhapo ihu. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nafeliksi nihopochera yolha mwaha ulha, ikatema chonkhaye wo uteelhiya ni ushukuruni chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nansho akinothanana uwiaa ikatema inyu yinchi, paahi, kinoulhepelhani wo nrima winyu worera, mwiiwelhelhe milhatu chihu wo makhuvi. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nihoona wiira ulha ntu ulha ri o woopiha chinene. Yoyo nootharamulhacha injarare iriyari ya Ayahudi kila ilhapo velhaponi va. Ni uyo phi nholhelhi o nkutiro wa attu o Unazareti ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Yoyo tho, aholhikacha unanariha Inupa ya Nlhuku, ni hii nkanammara. Nkanaathanana unhukumulha wo ikekhia ihu. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nansho Nalusia, olhupalhe o manyaasikari yahowa nkayaanithurulha wo machiri mmiononi mwihu. Nkayaalhehera wiira awiihiye uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nkayaalhehera attu anria milhatu ayo awe uwaninyu. Mwankohakohaka, inyuva mwaanene nnowa woona chi milhatu chonkhaye chi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayahudi nkayaarumelhelha milhatu chonkhaye wiira chaari che ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Paahi Nafeliksi ntawara o ilhapo iyo nkayaathoonyera moono Napaolo wiira yuulhumache, Napaolo nkayeera, “Kihoteelhiya wiivaraanga uwaninyu ukhalhawaya kihochuwelha wiira nri phi o uhukumulha milhatu velhaponi va wo iyaakha chinchi. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Thoko chichuwenlhe inyu mwaanene, wiira mahuku ahimpwaha khumi khuwa melhi avinre kahorwaa Uyerusalemu unthimichani Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayahudi khayakiphwannye mii kaakhulhanaka ni ntu riyoothe Inupa ya Nlhuku, mena akaathunalhinhe attu mmanupani mwo unlhapelha Nlhuku ama vakittu variwoothe vavawo velhaponi vawo. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mena kharina yo uhimiechesha milhatu chikuminhe aya vachulhu waka. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nlhove kinorumelhelha aka uwaninyu phi nna, Mii kinonthimicha Nlhuku a manyaapwiiya ihu kitwaraka Iphiro chineehana aya ayo wiira chowoothiya. Nansho tho, kinorumelhelha chittu chonkhaye chilhepiye nhina Malhehero a ashinna Musa ni ichitabu cha anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mii kinonkhulhuvelha Nlhuku thoko chineera aya ni ayo wo unkhulhuvelha, wiira we ikekhiaye attu onkhaye oombone ni o uhilhoka, anowa uhihimushiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Wo chiichammo etu kiri kimindaka ikatema chonkhaye ukhalha ni nrima woombone mmiholho wa Nlhuku ni waattuni.” ");
INSERT INTO mgh2016_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Kakhalheke utayi iyaakha chinchi, kahohokolhia Uyerusalemu wiira kaarweehelhe attu o ilhapo aka nchurukhu wo waakavihera ni ukumiha isadaka. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Vaari aka kipangaka chiicho phi akiphwannye aya Inupa ya Nlhuku kimalhihaka unlhapelha Nlhuku ni wiihapiha. Khawaariwo nlhoko wa attu mena waakhulhana. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nansho ahokhalha Ayahudi akina yaakhumme Uasiya. Yayo phi akaaphwanelhiye uwa uholho winyu ni uhimia milhatu chaya akhalhaka ahana iriyoothe vachulhu waka. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ama mwaahiyeke alha arii vaa alha ahimiache nlhatu wo uhilhoka ukonne aya ikatema yeemenlhe aka wi Ipuwa yo milhatu. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ahikhalheru malhove koolhumanche aka veemenlhe aka uholho waya kiiraka wiira, ‘Nnokihukumulha lhelhova wo nlhatu no urumelhelha wiira, akhwilhe anoohihimushiya.’ ” ");
INSERT INTO mgh2016_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Vavawo Nafeliksi aachuwelha rata mphingo wa Akuristo, nkayeemesha milhatu chiyo. Nkayeerelha, “Kinoowa kaahukumulha milhatu chi vanohalha aya uwa vaa Nalusiya olhupalhe a manyaasikari.” ");
INSERT INTO mgh2016_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Paahi nkayanlhehera nholhelhi a manyaasikari aatikhelhe Napaolo mpaani, nansho avahiyeke nipesha no ushikuriachiya. Tho manyampwana aya ahiiyeke awiiheke ittu yo waakavihera yaathanana aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Yavireke mahuku vakani, Nafeliksi yahowa vamoka ni Adurusila, ahanu aya yaari Ayahudi. Nkayeehaniha wiira awiihiye Napaolo, nkayeewelhelha vaahimiacha aya mwaha wo nrima wo unrumelhelha Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nansho Napaolo vaachokhonlhe aya uhimiacha mwaha wo meetelho o ikekhiaye ni mwaha wo nlhulha ni mwaha wo Nihuku no Uhukumulhiya attu, Nafeliksi yahoova nkayeera, “Vano nrweeke etu, kinowiihanani tho kapattaka nipesha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Yeyo ikatema iyo, yaari akhulhuvelhelhaka wiira Napaolo yanaahonga nchurukhu. Wo yoyo nlhatu uyo etu, yaari eehanaka Napaolo venchi woopana mwaha. ");
INSERT INTO mgh2016_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Chavireke iyaakha pilhi, Naporkio Festo yahokusha nipuro ni Nafeliksi. Ni wo uttuna waateelhiha Ayahudi, Nafeliksi yaahilhe Napaolo anari mpaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nihuku noneraru toka uphiya waya velhaponi vawo, Nafesto ahothama Ukaisariya nkayaarwaa Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Opochera ishaani olhupalhe vamoka ni aholhelhi a Ayahudi akina yahaahimiachera mwaha wo milhatu chi Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nkayaavekelha Nafesto wiira aapangelhe attu ittu yaattuna aya, waawiha Napaolo Uyerusalemu, ukhalhawaya yaari anapangachilhe miruku cho uweeva Napaolo mphironi. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nansho Nafesto yahaakhulha, “Napaolo anoohalha muuttukiyani Ukaisariya ni mii kinoohokolhia wowo mahuku vakani anowa. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mwaahiyeke aholhelhi inyu akittukaneke mii wowo, arwee ahimiacheke milhatu chaya yakhalhaka ihaawo ittu yo uwonya ipannge aya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nafesto yaholhokelha wowo mahuku nane ama khumi, nkayaahokolhia Ukaisariya. Waashelhe waya yahorwaa va ipuwa yo uhukumulhelhiya milhatu, nkayaalhehera uwiihiya Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Napaolo vaawiihiye aya, Ayahudi yaakhumme Uyerusalemu yahaarukureria ni uchokholha uhimiacha milhatu chinchi chulhupalhe chahooria uhimiechesha ikekhiaye. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wo wiichaakiha, Napaolo yaheera, “Mii akittekilhe ittu iriyoothe inaacha mwaha wo Malhehero a Ayahudi, mena upanga ittu iriyoothe inaacha Inupa ya Nlhuku mena inaacha Nakaisari.” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nafesto yahottuna waatelhiha Ayahudi. Paahi etu nkayaakoha Napaolo, “Chani mwaanothanana urwaa Uyerusalemu mwahukumulhiye ni mii chilha milhatu chilha?” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Napaolo nkayaakhulha, “Kineemelha va ipuwa yo milhatu ya Nakaisari, vaa phi nophwanelhiya aka uhukumulhiya. Thoko chinochuwelha inyu, akaapangenlhe Ayahudi ittu yo uhilhoka ttekenlhe Ayahudi ittu iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Paahi etu, yakhalhaka kihopanga ittu yo uhilhoka vanophwanelha wiiviya, akinlhepelha wiira kihiyereriye kihiiviye. Nansho yakhalhaka khiiwo ikeekhene nhina chi milhatu chihimiachiye chi, khaawo ntu okihelha mmathathani mwaya. Vano etu, kinolhepelha wiira kirweehiyeke kahumulhiye ni Nakaisari!” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nafesto yoolhumaneke attu aya yaakaviha, nkayeerelha Napaolo, “Nholhepelha irufaa yo wiiwelhelhiya ni Nakaisari, paahi etu nnoorweehiya wowo!” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mahuku vakani miholho, amwene Naagiripa yahowa Ukaisariya vamoka ni Nabenike arokoraya uwaashikuriani Nafesto. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Vaalhokenlhe aya wowo wo mahuku vakani, Nafesto yahaahimiachera Amwene mwaha u Napaolo wiira, “Hawo ntu mmoka vaa hiiye mpaani ni Nafeliksi. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Vaarwelhe aka Uyerusalemu opochera ishaani olhupalhe ni ashulhupalhe a Ayahudi yahokihimeria milhatu chawe ni ukilhepelha wiira kinhukumulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nansho mii kahaakhulha wiira kihiwe phi makhalhelho a Arumi unhukumulha ntu hinaya wiiwelhelhiya. Ahiyereriyeke thoko apatte nipesha no wiivaraanga wa attu apangelhiye chittu cho uhirera. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Paahi vaawiilhe aya vaa, akaapichilhe. Waashelhe waya kahokhalha vapuwani va uhukumulhelha milhatu ni ulhehera wiira Napaolo awiihiye. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Attu yaawilhe alhe yahohimiacha milhatu, nansho chihikhalhaka ni mwaha uriwoothe wo unanara thoko chaaweherera aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","“Nansho mwaha waarina aya waari waakhulhana ni attu akina mwaha wo ulhapelha ni mwaha wa ntu mmoka aakhwilhe neehaniya Yesu nansho Napaolo anominda wiira ri nkumi. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Akinochuwelha ittu yo upanga wiira kipatte ikekhiaye nhina mwo yoyo nlhatu uyo. Paahi kahaakoha Napaolo yakhalhaka wiira yanthanana urweehiya uhukumulhiyani Uyerusalemu. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nansho Napaolo nkayaalhepelha irufaa wiira, ahiiyeke mpaani mpaka ahukumulhiye ni Nakaisari. Paahi nkakaalhehera wiira, mbaya akhalhe mpaani mpaka vanohalha aka waahokolhosha wa Nakaisari.” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Paahi Naagiripa nkayeerelha Nafesto, “Kinoothanana umwiiwa kimwanene yoyo ntu uyo.” Nafesto nkayeera, “Nnomwiiwa meelho.” ");
INSERT INTO mgh2016_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Washeeke, Naagiripa ni Nabenike yahowa upuwani attapelhelhiyaka anaattukanne aholhelhi o manyaasikari ni attu o weemelhelha iwani. Nafesto nkayaalhehera wiira Napaolo awiihiye mpaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nafesto nkayeera, “Amwene Naagiripa ni attu onkhaye nrii vaa vamoka ni hii, Vaa haawo ntu mmoka khuwachiye ni Ayahudi onkhaye o vaa ni o Uyerusalemu wiira kaphwanelhiye ukhalha nkumi tho. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nansho mii akoonne wiira hotteka vanohukumulhiya wiira eeviye. Nansho ukhalhawaya Napaolo anene yaholhepelha irufaa wa Amwene o Urumi, kahoona mbaya kaarweehe. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nansho uwannyaka mii akirina ittu yo ulhepa wa apwiiya amwene olhupalhe o Urumi imwaachaka. Phi nlhatu etu no ummwiiha uwaninyu Amwene Naagiripa, mwamalhaka ukohakoha milhatu chawe, kipatteke nlhove no ulhepa. ");
INSERT INTO mgh2016_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ukhalhawaya inowa ukhalha thoko ncheche unrweeha ntu ttukiye wo uhiromolhacha milhatu chawe.” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Naagiripa nkayeerelha Napaolo, “Nhovahiya nipesha mwiivaraangeke etu.” Napaolo yahookolha moono aya nkayevaraanga cho, ");
INSERT INTO mgh2016_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Amwene Naagiripa! Kihoreeriya lhelho wiivaraanga uwaninyu mwaha wo milhatu chonkhaye chihimiachiye ni Ayahudi chikaachaka, ");
INSERT INTO mgh2016_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ukhalhawaya inyuva mwaanene nri o chuwelha malhemalhelho a Ayahudi ni uhiiwelhelha waya. Paahi etu, kinoulhepelhani wiira nkivilhelheke vaneevaraanga aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ayahudi onkhaye ahochuwelha makhalhelho aka toka unamwane aka. Ahochuwelha meetelho aka o khalhayi wiilhaponi waka ni Uyerusalemu uwo. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ahokichuwelha venchi, yathananaka anowooria uhimiechesha wiira, toka khalhayi kaari mmoka ya attu o uttwara chinene Malhehero a ashinna Musa. Kaari mmoka a Amafarisayo. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ni vaa vano, kirii uhukumulhiyani wo nlhatu no ukhulhuvelha malhehano a Nlhuku alheehilhe awe manyaapwiiya ihu. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Yayo malhehano ayo phi alhe anokhulhuvelhiya ni makosho khumi ni melhi o velhaponi wihu, vanonlhapelha aya Nlhuku wo nrima uthana ni uhiyu. Amwene, yoyo phi nlhatu etu, uwiihiye uwaninyu ni Ayahudi! ");
INSERT INTO mgh2016_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nlhatuni etu mwaatti no woochelha upisha nrima ni uchuwelha wiira Nlhuku nowaahihimusha attu akhwilhe? ");
INSERT INTO mgh2016_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Miyaano kimwanene kahoona wiira kaari kirataka chinene ukhota nchina na Yesu o Unazareti. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yoyo phi ulhe mwaha waapanga aka Uyerusalemu. Mii kimwanene kahovahiya ikuru yaakhumme wa opochera ishaani olhupalhe, nkakaattuka ujeerani atakatifu enchi a Nlhuku. Vaahukumulhiye aya wiiviya mii kahoopa ikhura yo urumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kahaatwarusha attu venchi mmanupani mwo unlhapelha Nlhuku mwonkhaye, wo waakhanyereriha unruwana Nlhuku. Urushiya waka waari wo upwaha, mpaka nkakaarwaa iwani cho utayi ni waatwarushacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Wo yoyo nlhatu uyo etu kahorwaa Udameski kinari ni ikuru ni malhehero aakhumme wa opochera ishaani olhupalhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Amwene, vaari aka mphironi ikatema yo uthana, kahoona wiirimu nchakarimia no utheka miitho chinene upwaha nchuwa, nkawaanimwalheelha mii ni attu yaattukanne aka. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Hiyaano onkhaye nahowulhuwa vathi, ni mii nkakeewa nlhove nikiirelhaka wo Iebraniya, ‘Nasauli, Nasauli! Woonaka nnookitwarusha? Woonaka nnowiiweria mwaanene thoko mwannama nokhita ikopo ya apwiiya awe.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nkakaakoha, ‘Thithi, inyuva phi apani?’ Ni Athithi ayo nkayaakaakhulha, ‘Miyaano phi Yesu nnontwarusha inyu. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nansho vano munkweke, mweemelheke. Kihoukhumelhelhani wiira kuweesheni ukhalha namitheko aka. Nnowa uhimiechesha wa attu mwaha woonilhe inyu lhelho ni alhe anohalha aka uwoonihani miholho. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kinowoopolhani wa attu o Uisraeli ni wa attu ahiri Ayahudi unoorumaakani, ");
INSERT INTO mgh2016_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","wiira mwaapatakulhe irusho chaya, akhume mwiipiphini akelhe unthukoni, akhume u ikuru yo Nakare anrukunuwelhe Nlhuku. Arumelhelhaka apatte ibarakha yo uhiyereriya uwonya waya ni ukusha nipuro naya munlhokoni mwa attu a Nlhuku ahapihiye wo iphiro yo upisha nrima.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Wo chiichammo etu, Amwene Naagiripa, khakavaanyinhe chittu choonihiye aka wiirimu chiyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nkakaahimiacha Nlhove na Nlhuku kichokholhaka Udameski, khuwaaka Uyerusalemu ni ilhapo yonkhaye yo Uyudea ni chiicho wo attu ahiri Ayahudi. Kahaakurumicha akhorome, ahiye uwonya anrukunuwelhe Nlhuku oonihaka wo mitheko wiira ahorukunusha mirima chaya. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Wo yoyo nlhatu uyo etu, Ayahudi nkayaakivara kinari Inupa ya Nlhuku, nkayaalhikacha ukiiva. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nansho mahuku onkhaye alha Nlhuku nookinanelha, ni wo chiicho etu mpaka lhelho nna kiheemelha rata kiihimiecheshaka wa attu onkhaye, olhupalhe ni akani. Malhove kinohimiacha aka phi alhe yaahimiye ni anamilhohi a Nlhuku ni ashinna Musa wiira anoowa aakhumelhelha. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kuristo Moopolhi noothananiya utwarushiya ni ukhalha o uchokholha uhihimmwa wa attu akhwilhe, ahimiache wiira nthuko wo noopo unowaamwalheelha vano attu onkhaye, Ayahudi ni attu ahiri Ayahudi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Napaolo evaraangeke mpaka vavawo, Nafesto nkayaakhuwelha, “Napaolo! Inyu nri ni ihalhahalha! Ushoma winyu chinene uhoohelhani ihalhahalha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Napaolo nkayaakhulha, “Khakirina ihalhahalha, Amwene Nafesto. Kinohimia aka phi ye ikeekhene. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Amwene Naagiripa! Kinohimiacha uwaninyu wo uhoova ukhalhawaya nhochuwelha chittu chonkhaye chi. Khakirina nipampa wiira unoochuwania uwaninyu ukhalhawaya khuwaapangeelhe wo nivitho. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Amwene Naagiripa, chani, nnowaarumelhelha anamilhohi a Nlhuku? Kihochuwelha wiira nnowaarumelhelha.” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Amwene Naagiripa nkayaakhulha Napaolo, “Nnaanyihera wo malhove inyu vakani nnowooria ukirukunusha mii ukhalha Nkuristo?” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Napaolo nkayaakhulha, “Kinonlhapelha Nlhuku wiira wo ikatema ikhuvi ama yo urekama, inyuva ni attu onkhaye anokiiwelhelha lhelho mpatte ukhalha thoko mii, nansho ihikhalhe wo mittondoro thoko cho.” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Vavawo amwene Naagiripa ni Nafesto o utawara ilhapo ni Nabenike ni akina onkhaye nkayeemelha nkayaathama. ");
INSERT INTO mgh2016_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Yathameke nkayolhumacha ashineneru, “Ulha ntu ulha khattenke vanophwanelha wiiviya ama uttukiya.” ");
INSERT INTO mgh2016_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Amwene Naagiripa nkayeerelha Nafesto, “Ulha ntu ulha aanooria uthaphulhiya hikaalhepenlhe urweehiya wa Nakaisari.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Wahukumulhiyeke wiira nirwee Uitaliya, yaheesha Napaolo vamoka ni attu attukiye akina mmiononi mwa Nayulio yaari olhita olhupalhe o mphingo weehaniya, “Mphingo wa Amwene o Urumi.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Naaristako nnenchi o Umakedoniya aakhumme Uthesalonike aari vamoka ni hii. Nkanaawelha imeli yo Uadromito yaarwaa ivirelhaka ibandari chinchi cho ilhapo yo Uasiya, nkanaachokholha nkwaha. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Waashelhe waya nahophiya ibandari yo Usidoni. Nayulio yahaapangelha ittu yoombone Napaolo yo waavaha nipesha no woona manyampwana aya ni upatta chaathanana aya. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nathameke wowo nkanaathepa urwaa miholho, nansho ukhalhawaya iphioo yaari iwukaka wo machiri uholho wihu, nkanaavira mpatta wahaawuka iphioo yinchi nkanaakurusha inanga uchulhu ichirumba yo Ukipro. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nkanaavira imbwaani cho Ukilikiya ni Upamfiliya, nkanaaphiya Umura iwani yo Ulukiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Wowo ntu olhita mulhupalhe uyo ahophwanya imeli imoka yaakhuma Ualekizanderiya yaarwaa Uitaliya, paahi etu nkaaniwelhiha mwommo. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wo mahuku menchi nkwaha waari wo uhakuviaa, nihuvahuvaka, vo umalhelha nkanaaphiya Uniido. Ukhalhawaya iphioo yo machiri yaari inivingaka chinene, naheemelha vavawo. Vaawukuwilhe aya, nahorwaa niviraka mpatta wo Ukirete moono wo ilhapo ubahari yo Usalumone. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nkanaavira uchereshere waya nihuvaka ni uphiya weehaniya, “Ibandari Yoombone” waatamana ni Ulaseya. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Naholhokelha chinene wowo, mpaka nlhaalha nkawaananara chinene. Ukhalhawaya vano waari ikatema ihinorera weeta nkwaha wo mmaashini ukhalhawaya mahuku o uttuka ahaatameria. Napaolo nkayaamuka wiira, ");
INSERT INTO mgh2016_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Manyaalhopwana, kinoona wiira nkwaha ulha khunrera, ni itatako yo urimeelha imeli ni misigo iri yuulhupalhe ata ni ukumi wihu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nansho olhita mulhupalhe ulhe ewelhenlhe chinene malhove a ntu oweetiha imeli ni mwanene imeli ilhe upwaha nlhove ni Napaolo. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ni yelhe ibandari ilhe khayaari yoombone ulhokelha ikatema yo nlhaalha wo uririya chinene. Attu yaari alhakelhaka uwelha ni urwaa, wiira yooriachaka yaphiye Ufoinike yalhokelhe wowo nlhaalha wo uririya uyo. Ibandari yo Ufoinike yaari ilhapo yo Ukirete yaaweha uchawa uneelha nchuwa ni uchulhu uneelha nchuwa. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Paahi etu iphioo yo uchawa yahochokholha uwuka, attu nkayaanyihera wiira ahopatta mwaha waaweherera aya, paahi yahokhulha ikhomo yo yuuma yo ulhemelha yaavarelhelha imeli ilhe wiira ihikushiye ni iphioo, nkayeetiha imeli vakhiviru ni imbwaani yo Ukirete. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nansho vahipincheru, iphioo yahorukunuwa. Iphioo yo machiri yeehaniya, “Iphioo yo uchulhu” yahochokholha uwuka ikhumelhelhaka uchirumbani. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nkayaakakha imeli ilhe. Ni hii ukhalhawaya khanoonrie uvingana ni iphioo ilhe, nahohiya wiira ikakhachiye ni iphioo iyo. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nkanaavira ichirumba ikaani ineehaniya Kauda, yaanitiyelhenlhe vakani iphioo ilhe, nkanooria woopolha ikalhava yo imeli ilhe inakhalhaka wo uhuvahuva chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Anamitheko o mmelini alhe yahopurulhelha ikalhava nhina. Nkayaatukelhelhiya wo machiri nttondoro waarukurenrie imeli ilhe. Yaari yoovaka wiira imeli yaanowaya vachengweni veehaniya Sirti, imbwaani yo Ulibiya. Paahi nkayaakurusha mattanga ni uhiya imeli ilhe ikhupiye ni iphioo. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Iphioo nkayaathepa uwuka. Waashelhe waya nkayaachokholha urihelha mmaashini misigo chaari mmeelini chilhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nihuku no neraru nkayaachokholha uriha ata ikerero cho imeli ilhe mmaashini wo mathatha aya ashinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nchuwa naari nihipharelhaka mena ittotwa wiirimu wo mahuku menchi iphioo iwukaka chinene, nkanaakhwa nrima wo uhikhulhuvelha wiira ninoolhama. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nakhalheke ikatema yinchi wo uhilhuma ittu, Napaolo yaheemelha uholho wa attu onkhaye nkayaahelha nrima, “Ashilhoko aka, yakaari mwahokiiwelhelha, nkamweemesha nkwaha Ukirete ulhe, nanshemba wu uhuva wu ni ihasara chonkhaye chilha. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nansho mpisheke nrima! Khaawo anakhalhaka ntu mmoka nohalha urimeelha ukumi awe, imeliru phi nohalha utitimira. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ukhalhawaya uhiyu wo nchana wahokikhumelhelha nnepa wa Nlhuku kinonthimicha aka, ");
INSERT INTO mgh2016_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","nkawaakiirelha, ‘Napaolo nhoove! Ukhalhawaya nhothananiya inyuva weemelha uholho wa Nakaisari. Wo nlhatu winyu Nlhuku nouvahani ibarakha yo woopolha ukumi wa attu onkhaye arii munkwahani vamoka ni inyu ahirimeelhe.’ ");
INSERT INTO mgh2016_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Paahi etu, mwaatti mpisheke nrima! Ukhalhawaya kinoorumelhelha wiira Nlhuku noopanga thoko chinre aka wo wulhumacha. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nansho ninoorihelhiya uchengweni ichirumba ihinachuwelha ihu.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Uhiyu iriyari nihuku no khumi na nne, nithepaka ukakhiya ni iphioo variyari ibahari yo Mediterenia, anamitheko yahaanyihera wiira naari vakhiviru uphiya uchengweni. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Paahi nkayaatumbucheriha ikhwambalha yaattukelhiye iyuuma yolhemelha aphimaka vakittu voohiisha yeemeshe imeli. Nkayaapatta vakittu vaaphiyelha miono makhumi ncheshe. Nkayaaphima tho, wiisha waari miono makhumi nthanu. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nansho wo woova wiira imeli ihiwe yaawaya vamalhukuni, yahokurusha iyuuma cholhemelha ncheshe cho uvarelhelha imeli wo utulhi uno alhapelhaka wiira waakuvie usha. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Anamitheko nkayaalhikacha ummwia nyerere, nkayaakurusha ikalhava mmaashini, athepiachaka wiira anokelha uholho uukurushani iyuuma yo ulhemelha yo uvarelhelha imeli wiira ihiveverushiye. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nansho Napaolo nkayaahimeria olhita olhupalhe ni manyaasikari wiira, “Anamitheko alha yaahihalheke mmeelini mu, khannoopolhia.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Vavawo olhita yahotupulha ikhwambalha chaattukelhelhiye ikalhava ilhe, nkayaahiya ikhupiye ni maashi. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Mapikoosha, Napaolo yahaakurumicha attu alhie yolhia yiiraka, “Wo mahuku khumi na nne vano, mwaatti nrii nnipampani wo uhilhia ittu iriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Paahi kinoulhepelhani wiira nlhieke yolhia, ukumi inyu unokhulhuvelha chechiyo wiira nhokholhie. Ukhalhawaya khiiwo ata ikharari imoka yo mmuruni mwinyu inohalha upotera.” ");
INSERT INTO mgh2016_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Yoolhumacheke chiicho, Napaolo nkayaakusha nkatte, nkayanshukuru Nlhuku onkhaye oonaka, nkayaamia, nkayaalhia. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Vavawo attu onkhaye nkayaapatta nrima ni ayo chiicho nkayaalhia yolhia. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Hii onkhaye mmelini mmo naari attu imia pilhi ni makhumi saba ni sita. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kila ntu alhieke ni urupalha, anamitheko yahowukulha misigo cho cholhia wo urihelha mbaharini. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Washeeke anamitheko khayari achuwelhaka yelhe ilhapo ilhe, nansho yahoona ichengwe yo nhava. Nkayoona yakhalhaka inowooria mbaya weemesha imeli wowo. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Paahi nkayaakwattulha iyuuma ncheshe chilhe ni uhiya mbaharini, nkayaattukulha mittondoro chaattukelhiye nshukani wo imeli. Yamalheke nkayaattukelhelha nttanga nimoka uholho uvara iphioo, nkanaakelhelha umbwaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nansho imeli nkayaaphara naphiyeke vanokumaana aya iphata pilhi cho ibahari. Uholho yaari inatitiminre munhaavani wo uhitikhinyia. Utulhi, imeli yahochokholha wunthakiaa wo nlhatu no machiri o maashi. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Manyaasikaari olhita nkayoona mbaya weeva attu attukiye onkhaye wo woova wiira yanrapelha mpaka umbwaani ni uttawa. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nansho ukhalhawaya mulhupalhe a manyaasikari ulhe ahothanana woopolha Napaolo ahaachiichiha ahiire chiicho. Nkaalhehera alhe anooria urapelha alhe athupheke mmaashini arapelheke mpaka umbwaani. ");
INSERT INTO mgh2016_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ni akina atwareke avarelhelhaka imbau ama ichipande cho imeli yuntheelhe. Phi chiicho chenre ihu onkhaye wo wopolhia ni uphiya uchengweni rata. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nahoopolhia ni aphiya rata uchengweni, nkanaachuwelha wiira yelhe ichirumba ilhe yeehaniya Malta. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Anenchi o vavawo yahonooniha nrima wo unittuna. Ipulha yahochokholha urupa nkawaachokholha uririya, paahi nkayaaparihelha mooro nootte. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Napaolo nkayaakhupa ashithathu vakani nkayaathotheria vamooroni. Vavawo wo nlhatu no uviha mooro ulhe, inwaa nkayaakolhuwa nthathuni mmwe nkayeevilhikelha mmoononi mu Napaolo nkayaalhuma. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Anenchi o Umalta yooneke inwaa iheevilhikelha ni waalhuma Napaolo mmoononi nkayeerelhana ashineneru, “We ikeekhene inowooria ulha ntu ulha o wiiva. Inakhalhaka hookokwaa urimeelha ubaharini, ikekhiaye khinonhiya wiira alhame wo uthepa!” ");
INSERT INTO mgh2016_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nansho Napaolo nkayaakukuttelha inwaa ilhe vamooroni, ahiwereiyaka ata vakani. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Attu alhe yaari awehereraka wiira anochakhulha moono ama anowulhuwa ni ukhwa. Yaweherereke chinene wohoona ittu iriyoothe yaapattaka Napaolo, nkayaarukunusha irusho chaya, nkayeera wiira, ulha phi mmoka o milhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Vakhiviru yo vavawo vakittu vawo chahokhalha imata cha anene yeyo ichirumba iyo eehaniya Napabulo. Yayo yahonipochera rata, nkanaakhalha alheto aya wo mahuku mararu. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Athumwanaya Napabulo ayo yaari vanlhilhini awereiyaka itekusha ni uharisha iphome. Napaolo yahorwaa uwaawehani. Yamalheke unlhapelha Nlhuku, nkayeesha miono chaya vamuruni va areta alhe nkayaalhamiha. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wakhumelhelheke yoyo mwaha uyo, areta akina o yeyo ilhapo iyo yahowaacha u Napaolo nkayaalhamihachiya. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Attu nkayaanivaha izawadi chinchi. Ni vawo vaachokholha ihu nkwaha tho, yahoniwelhihera mmeelini mashurupu yaathanana ihu. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Chavireke mieri miraru nahochokholha tho nkwaha ihu wo uwelha imeli imoka yo Ualekizanderiya ineehaniya “Ashilhoko Mavata.” Yeyo imeli iyo yeemenlhe Umalta nlhaalha wonkhaye wo uririya ulhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nahophiya iwani yo Usirakusa, nkanaakhalha vavawo mahuku mararu. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Vaathamme ihu wowo nkanaarwaa ni uphiya Uregio. Nihuku naatwara iphioo yo uchawa nkayaachokholha uwuka. Baada yo nihuku no nayelhi nkanaaphiya ibandari yo Upotioli. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wowo nahaapwanya ashilhoko ihu anrumelhenlhe Kuristo akina yanrumelhenlhe Yesu yaanilhepenlhe wiira nilhokelhe uwannyaya wo ijuma imoka. Paahi phi chiichammo chaaphilhe ihu Urumi. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ashilhoko ihu anrumelhenlhe Kuristo o Urumi ulhe yaheewa mwaha ihu, nkayaanikamelha waari ipuwa yo maronda yo Uapio ni iwani yo Ihoteli taaru. Napaolo voonne aya, yahonshukuru Nlhuku, nrima nkawaahokolhelha chinene. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Naphiyeke Urumi Napaolo yahovahiya nipesha no ukhalha vekha aya ni owalhita mmoka. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yavireke mahuku mararu, Napaolo yaheehana vamoka aholhelhi a Ayahudi o vavalhe. Wakumaaniyeke, Napaolo nkayeerelha, “Ashilhoko aka Aisraeli nanaka, inakhalhaka mii akaapannge ittu iriyoothe yo uhilhoka wa attu ihu mena uvinga malhemalhelho a manyaapwiiya ihu, kahottukiya u Yerusalemu ulhe nkakeeshiya mmiononi mwa Arumi. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Yakikohakoheke ni woona wiira khakaattenke ittu iriyoothe, Arumi yahothanana ukihiya ukhalhawaya khayonne nlhatu uriyoothe. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nansho Ayahudi akina vaavinga aya yoyo mwaha uyo, mii kahoona mbaya kivekelhe irufaa yo urweehiya wa Nakaisari, anakhalhaka khakaarina milhatu cho weerelha attu o nikosho naka. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yoyo phi nlhatu etu wo uvekelha woonana ni waareriha ni inyu mwaatti, ukhalhawaya kittukiye chii mittondoro chii wo nlhatu no uyo nokhulhuvelhiya ni attu o Uisraeli.” ");
INSERT INTO mgh2016_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Attu ayo nkayaakhulha, “Hiyaano khaninapochera iwarakha iriyoothe ikhumme Uyudea, mena khaawo nlhoko ihu riyoothe wiihilhe va mwaha uriyoothe ama uhimiacha ittu iriyoothe yo uhilhoka inowaachani. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nansho ninowoona inookhalha mbaya vano niiwe nlhove ninyu mwaanene ni mwaha urina inyu. Ukhalhawaya nihochuwelha wiira kila vakittu yoyo mphingo winyu uyo uri uvingiyaka.” ");
INSERT INTO mgh2016_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Paahi, nkaneeshiya nihuku no ukumaana, attu enchi nkayaawa wowo waakhalha aya Napaolo uwo. No wichishu nno totoro Napaolo yahaahimiachera nttenga waarina aya vachulhu Imwene ya Nlhuku. Nkayeettuchiha attu wiira anrumelhelhe Yesu wo woopusha Malhehero a ashinna Musa ni malhove alhepiye ni Anamilhohi a Nlhuku. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Attu akina yahorumelhelha malhove aya, nansho akina khayaarumelhenlhe. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Paahi attu nkayaathamacha, ahiiwananaka ashineneru, Napaolo venre aya, “Ikekhiaye Iphumu ya Nlhuku ahaahimeria manyaapwiiya inyu wo iphiro ya anamilhohi a Nlhuku ashinna Isaya!” ");
INSERT INTO mgh2016_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Eeraka, “Nrweeke wa alha attu alha mwaahimerieke, Wo ikekhiaye wiiwa nnowiiwa, nansho khannochuwelha inohimiya, Uweha nnooweha, nansho khannoona. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ukhalhawaya irusho chaya chihophupuwalha, Ahotiyelha maaru aya, ahohichilha miitho aya. Ama, yanoona wo miitho aya, yaaneewa wo maaru aya, Yanchuwelha wo irusho chaya, Ni ukirukunuwelha, Ni mii kinowaalhamiha.” Nlhuku phi neera awe. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Yamalheke, Napaolo nkayeera, “Nchuwelheke etu, nttenga wa Nlhuku vachulhu noopo uhorweehiya wa attu ahiri Ayahudi. Yayo anokowiiwelhelha!” ");
INSERT INTO mgh2016_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Napaolo amalhiheke wulhumacha yayo, Ayahudi yahothamacha uno athepaka uhiiwanana ashineneru. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Wo iyaakha pilhi Napaolo yaari akhalhaka waari inupa yaashimme aya, aapocheraka attu onkhaye yaarwaa uwaashikuriani. ");
INSERT INTO mgh2016_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yaari ahimiachaka Imwene ya Nlhuku ni wiittuchiha wo ushipa mwaha wa Athithi Yesu Kuristo, ihikhalhaka yo waachiichiha.");
INSERT INTO mgh2016_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mii Paolo, karumiya a Yesu Kuristo, kiihaniye ni Nlhuku ukhalha namitheko ni ukithanlha wiira kaahimiachere attu Malhove Orera, kinoowiiha iwarakha uwaninyu. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Khalhayi vawo Nlhuku ahaalheelha attu Malhove Orera alha wo iphiro ya anamilhohi, thoko chaalhehiye aya ni Malhove Matakatifu. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Malhove Orera alha anomwaacha Mwaana a Nlhuku, Athithi Yesu Kuristo, ayarelhe wo iruttu mwi iyari ya Adaudi, ");
INSERT INTO mgh2016_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","aapangiye ukhalha Mwaana a Nlhuku wo uhimiecheshiya ni Iphumu itakatifu ya Nlhuku, wo machiri molhupalhe wo uhihimushiya nnookhwani, Yesu Kuristo Athithi. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Wo nlhatu no nchina nawe, Nlhuku hokivaha nnema ni ikuru yo ukhalha karumiya wo nlhatu wo waahimeria attu o makosho onkhaye wiira arumelhelhe ni upisha nrima. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ni inyu mwaatti nri Uroma va, Nlhuku hoothanlhani ukhalha attu a Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Paahi etu kinolhepa uwaninyu mwaatti onkhaye atakatifu anottuniya ni Nlhuku nri Uroma va, mwiihaniye ukhalha attu awe. Kinoulhapelhelhani nnema ni mpuha ukhuma wa Nlhuku Athumwanihu ni wa Athithi Yesu Kuristo. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Wo uchokholha, kinonshukuru Nlhuku aka wo iphiro ya Yesu Kuristo wo nlhatu winyu mwaatti onkhaye. Ukhalhawaya mwaha wo upisha nrima winyu uheewania ilhapo yonkhaye. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nlhuku kinonkaviha aka wo nrima waka wonkhaye uhimiechesha Malhove Orera o Mwaamwanawe, hoona chineera aka wo ulhapelhelhani kila ikatema. ");
INSERT INTO mgh2016_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mahu