﻿USE sofia;
DROP TABLE IF EXISTS sofia.mge_vpl;
CREATE TABLE mge_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mge_vpl WRITE;
INSERT INTO mge_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kɔr ginka Jeju Kristɨ kɨ́ ngonka Dabidɨ, kɨ́ ngonka Abrakam ə́n: ");
INSERT INTO mge_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrakam ojɨ Isakɨ; Isakɨ ojɨ Jakobɨ; Jakobɨ ojɨ Juda kɨ̀ ngankɔ̰-é-je; ");
INSERT INTO mge_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda dḛ kɨ̀ Tamar dꞌojɨ Parɛsɨ, kɨ̀ Jera; Parɛsɨ ojɨ Esrɔm; Esrɔm ojɨ Aram; ");
INSERT INTO mge_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ojɨ Aminadabɨ; Aminadabɨ ojɨ Nasɔ̰; Nasɔ̰ ojɨ Salmɔ̰; ");
INSERT INTO mge_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔ̰ dḛ kɨ̀ Rakabɨ dꞌojɨ Bowajɨ; Bowajɨ dḛ kɨ̀ Rutɨ dꞌojɨ Obɛdɨ; Obɛdɨ ojɨ Jese; ");
INSERT INTO mge_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese ojɨ ngar Dabidɨ; Dabidɨ taa ne Uri ojɨ-né Salomɔ̰; ");
INSERT INTO mge_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ̰ ojɨ Robowam; Robowam ojɨ Abiya; Abiya ojɨ Aja; ");
INSERT INTO mge_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aja ojɨ Jojapatɨ; Jojapatɨ ojɨ Joram; Joram ojɨ Ojiyasɨ; ");
INSERT INTO mge_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojiyasɨ ojɨ Jowatam; Jowatam ojɨ Akajɨ; Akajɨ ojɨ Ejekiyasɨ; ");
INSERT INTO mge_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejekiyasɨ ojɨ Manasɨ; Manasɨ ojɨ Amɔ̰; Amɔ̰ ojɨ Jojiyasɨ; ");
INSERT INTO mge_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jojiyasɨ ojɨ Jekoniyasɨ kɨ̀ ngankɔ̰-é-je. Dɔgangɨ ɓal-é-je-tɨ kin ə́ dꞌuwə-né dow-je kɨ́ Jorijalḛm dꞌɔw sə-dé ɓə Babilɔ̰n-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lokɨ dꞌɔw sə-dé Babilɔ̰n-tɨ lé, Jekoniyasɨ ojɨ Salatiyɛl, Salatiyɛl ojɨ Jorobabɛl, ");
INSERT INTO mge_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabɛl ojɨ Abiyudɨ, Abiyudɨ ojɨ Eliyakim, Eliyakim ojɨ Ajɔr ");
INSERT INTO mge_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajɔr ojɨ Sadokɨ, Sadokɨ ojɨ Akim, Akim ojɨ Eliyudɨ, ");
INSERT INTO mge_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudɨ ojɨ Eleyajar, Eleyajar ojɨ Mata̰, Mata̰ ojɨ Jakobɨ, ");
INSERT INTO mge_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobɨ ojɨ Jojepɨ kɨ́ ngɔw Mari. Rəmə Mari ojɨ Jeju kɨ́ ꞌɓa-é Kristɨ. ");
INSERT INTO mge_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kḭ dɔ Abrakam-tɨ sar ree tḛḛ-né dɔ Dabidɨ-tɨ lé, to ginka dɔgɨ gidɨ-é sɔ. Ə kḭ dɔ Dabidɨ-tɨ sar ree tḛḛ-né ɓal-tɨ kɨ́ dꞌuwə-né ngan Israyel-je dꞌɔw-né sə-dé ɓə Babilɔ̰n-tɨ lé, to ginka dɔgɨ gidɨ-é sɔ rəm, kḭ dɔ ɓal-tɨ kɨ́ dꞌuwə-né ngan Israyel-je dꞌɔw-né sə-dé ɓə Babilɔ̰n-tɨ sar ree tḛḛ-né dɔ kojɨ Kristɨ-tɨ, to ginka dɔgɨ gidɨ-é sɔ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kojɨ Jeju Kristɨ lé tò titɨ-na̰ bè: Kɔ̰-é Mari to ngonmandɨ kɨ́ Jojepɨ uwə dɔ-é. Lokɨ ꞌgə-na̰ dené kɨ̀ dingəm-tɨ al ɓəy ya rəmə, Mari ndan ngon kɨ̀ tɔ́gɨ lə Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jojepɨ kɨ́ to njènungɨ-é lé, to dow kɨ́ njururu, adɨ ndigɨ kadɨ nꞌpa ta kin kɨ ndaa-tɨ nꞌulə-né rɔsɔl dɔ-é-tɨ al. Beɓa ḛ ɔjɨ mḛḛ-é-tɨ kdɔ mbatɨ-é kɨ̀ go ngə̰y. ");
INSERT INTO mge_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngà lokɨ ḛ isɨ gɨr ta-é kɨ gɨr ya ɓəy rəmə, malayka lə ꞌƁaɓe tḛḛ kɔy mḛḛ nḭ-tɨ idə-é panè: Jojepɨ, ngonka Dabidɨ, ꞌɓəl al, ꞌtaa Mari lé, kdɔtalə ngon kɨ́ mḛḛ-é-tɨ kinlé to ngon kɨ́ ree kɨ̀ go rəbɨ lə Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ḛ à kojɨ ngon kɨ́ dingəm ə ꞌa kində ri-é lə Jeju, kdɔ ḛ ɓá à to dow kɨ́ à kajɨ dow-je liə mḛḛ majal-je-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Né-je kin lay ra-né bè kdɔ kadɨ ta kɨ́ ꞌƁaɓe adɨ njèpata kɨ́ ta-é-tɨ pa kete lé né-é ra né. ");
INSERT INTO mge_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ꞌƁaɓe adɨ njèpata kɨ́ ta-é-tɨ panè: Ngonmandɨ kɨ́ gə dingəm al ɓəy à ndan ngon! À kojɨ ngon kɨ́ dingəm rəmə dꞌa kində ri-é lə «Emanuɛl», kɔr mḛḛ-é to «Lubə isɨ sə-ji.» ");
INSERT INTO mge_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lokɨ Jojepɨ ḭ dɔ ɓi-tɨ lé, ra titɨ kɨ́ malayka lə ꞌƁaɓe idə-é-né lé, adɨ ḛ taa Mari lé. ");
INSERT INTO mge_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Dḛ ꞌgə-na̰ dené kɨ̀ dingəm al ya sar Mari ojɨ-né ngon kɨ́ dingəm, adɨ Jojepɨ ində ri-é lə Jeju. ");
INSERT INTO mge_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Dꞌojɨ Jeju Bɛtlekɛm, dɔnangɨ Jude-tɨ, ɓal-je-tɨ kɨ́ Erodɨ ɔ̰̀-né ɓe. Go kojɨ-é-tɨ lé, njénégə-je kɨ́ dɔ kərwəḭ-je-tɨ dꞌḭ lo kubə kàdɨ̀-tɨ ꞌree Jorijalḛm ə ");
INSERT INTO mge_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ꞌdəjɨ ꞌpanè: «Ngar lə jipɨ-je kɨ́ dꞌojɨ-é lé tò rá wa? Jꞌoo kərwəḭ liə lo kubə kàdɨ̀-tɨ ɓá jꞌree kdɔ kɔsɨ dɔ-ji nangɨ nɔ̰̀-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lokɨ ngar Erodɨ oo ta kin bè lé, mḛḛ-é gangɨ man rəm, ɓá dow-je kɨ́ Jorijalḛm lay ya mḛḛ-dé gangɨ man siə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Beɓa ḛ ɓa njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je dəjɨ-dé se lo kɨ́ rá ɓá dꞌa kojɨ Kristɨ lé titɨ wa? ");
INSERT INTO mge_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dḛ dꞌidə-é ꞌpanè: «Dꞌa kojɨ-é Bɛtlekɛm, dɔnangɨ Jude-tɨ, kdɔ ta kɨ́ njèpata kɨ́ ta Lubə-tɨ pa ə́n: ");
INSERT INTO mge_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Sə̰i dow-je kɨ́ Bɛtlekɛm kɨ́ dɔnangɨ Jude-tɨ, kadɨ ꞌgəi majɨ kɨ́ ɓe lə-si lé, to ngonɓe kɨ́ sḛ bè ngay dan ɓebo-je-tɨ kɨ́ dɔnangɨ Jude-tɨ al. Kdɔ ngar kɨ́ njèkul dow-je lə-m, kɨ́ ꞌto Israyel-je à tḛḛ dan-si-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Beɓa Erodɨ ɓa njénégə-je kɨ́ dɔ kərwəḭ-je-tɨ gidɨ ngə̰y, dəjɨ-dé se dɔkaglo kɨ́ rá-tɨ ya bangɨ ə́ kərwəḭ lé tḛḛ-né wa? ");
INSERT INTO mge_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɓa go-tɨ, ulə-dé Bɛtlekɛm panè: «Ɔwi ꞌdəji ta kɨ́ tɔgrɔ-tɨ dɔ ngon-tɨ kinlé majɨ-majɨ ooi. Lokɨ ingəi-é rəmə, reei idəi-mi kdɔ kadɨ ma̰ kàrè mꞌɔw mꞌɔsɨ dɔ-m nangɨ nɔ̰̀-é-tɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Go ta-tɨ lə ngar lé, dḛ dꞌɔtɨ dꞌɔw rəmə kərwəḭ kɨ́ dꞌoo-é lo kubə kàdɨ̀-tɨ nṵ lé, ɔr nɔ̰̀-dé sar ree tḛḛ dɔ lo-tɨ kɨ́ ngon kɨ́ bər tò-tɨ lé rəmə a̰ nangɨ. ");
INSERT INTO mge_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lokɨ dꞌoo kərwəḭ a̰ nangɨ lé, rɔ-dé nəl-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Beɓa dꞌɔw mḛḛ kəy-tɨ ə dꞌoo ngon kɨ́ bər lé kɨ̀ kɔ̰-é Mari, rəmə ꞌtɔsɨ məkəjɨ-dé nangɨ ə dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀ ngon kɨ́ bər-tɨ lé. Go-tɨ, dḛ ꞌtḛḛ ta mbu né-je lə-dé kɨ́ dꞌində ngangəm ə dꞌadɨ-é kadkare-je: adɨ to lɔr-je, kɨ̀ dukan-je, kɨ̀ nɔ̰kagɨ-je kɨ́ ətɨ majɨ-majɨ. ");
INSERT INTO mge_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Go-tɨ, Lubə idə-dé mḛḛ nḭ-tɨ kadɨ ꞌtəl kɨ̀ rəbɨ kɨ́ dɔ Erodɨ-tɨ gogɨ al ngá. Beɓa dḛ ꞌtəl dꞌɔw ɓe lə-dé kɨ̀ rəbɨ kɨ́ rangɨ. ");
INSERT INTO mge_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lokɨ njénégə-je kɨ́ dɔ kərwəḭ-je-tɨ dꞌɔw ɓe lé, malayka lə ꞌƁaɓe káre ree mḛḛ nḭ-tɨ idə Jojepɨ panè: «ꞌḬ taá, ꞌun ngon kɨ́ bər kɨ̀ kɔ̰-é, ə ꞌa̰y ɔw sə-dé Ejiptɨ. ꞌIsɨ nṵ sar kadɨ ma̰ ya mꞌidə-i ɓá ꞌtəl ꞌree sə-dé gogɨ, kdɔ Erodɨ lé à sangɨ kadɨ nꞌtɔl ngon kin.» ");
INSERT INTO mge_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Beɓa Jojepɨ ḭ taá ndɔɔ nɔ̰ɔ̰ ya, un ngon kɨ́ bər kɨ̀ kɔ̰-é ɔw sə-dé Ejiptɨ. ");
INSERT INTO mge_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ḛ isɨ Ejiptɨ nɔ̰ɔ̰ sar koy Erodɨ. Tò bè kdɔ kadɨ ta kɨ́ ꞌƁaɓe adɨ njèpata kɨ́ ta-é-tɨ pa kete lé, né-é ra né. ꞌƁaɓe panè: «Mꞌɓa ngon-m kadɨ tḛḛ dɔnangɨ Ejiptɨ-tɨ kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lokɨ Erodɨ oo kɨ́ njénégə-je kɨ́ dɔ kərwəḭ-je-tɨ kin dꞌədɨ-é lé, wɔngɨ ra-é n̰a̰ adɨ un ndu kadɨ ꞌtɔl ngan-je kɨ́ bər kɨ́ dingəm ɓe-tɨ kɨ́ Bɛtlekɛm kɨ̀ lo-je kɨ́ gəə dɔ-é tin ya lay; un kutɨ-é dɔ ngan-je kɨ́ ɓal joo-tɨ təl-né kɨ nangɨ; ɔjɨ-né dɔ gangɨ ndɔ-je-tɨ kɨ́ kərwəḭ ndɔ̰y-né ɓá njénégə-je kɨ́ dɔ kərwəḭ-je-tɨ dꞌidə-é-né lé. ");
INSERT INTO mge_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Beɓa ta kɨ́ Jeremi kɨ́ njèpata kɨ́ ta Lubə-tɨ pa lé né-é ra né. Ḛ panè: ");
INSERT INTO mge_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Sukùkú, kɨ̀ ndi nɔ̰-je, kɨ̀ ɓaata-je ɓa gitɨ-gitɨ mḛḛ ɓe-tɨ kɨ́ Rama̰, Rasəl nɔ̰ kdɔtalə ngan-é, ḛ ndigɨ kadɨ dow gɔr-é al, Kdɔtalə dꞌoy lay.» ");
INSERT INTO mge_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lokɨ Erodɨ oy lé, malayka lə ꞌƁaɓe ree rɔ Jojepɨ-tɨ dɔnangɨ Ejiptɨ-tɨ idə-é mḛḛ nḭ-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ꞌḬ taá, ꞌun ngon kɨ́ bər kɨ̀ kɔ̰-é, ə ꞌtəl ꞌɔw sə-dé dɔnangɨ Israyel-tɨ gogɨ, kdɔ dow-je kɨ́ ꞌsangɨ tɔl ngon kɨ́ bər lé dꞌoy ngá.» ");
INSERT INTO mge_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Beɓa Jojepɨ ḭ taá, un ngon kɨ́ bər kɨ̀ kɔ̰-é, təl ɔw sə-dé dɔnangɨ Israyel-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lokɨ Jojepɨ oo kadɨ Arkelawusɨ ɓá ɔ̰̀ ɓe dɔnangɨ Jude-tɨ tó bɔbɨ-é Erodɨ-tɨ lé, ɓəl kisɨ dɔnangɨ Jude-tɨ. Beɓa Lubə idə-é mḛḛ nḭ-tɨ kadɨ ijə rɔ-é kɨ rangɨ ɔw isɨ dɔnangɨ Galile-tɨ yó. ");
INSERT INTO mge_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ḛ ɔw isɨ mḛḛ ɓebo-tɨ kɨ́ ɓa-é Najarɛtɨ. Tò bè kdɔ kadɨ ta kɨ́ ndɔkɨ njépata-je kɨ́ ta Lubə-tɨ ꞌpa lé, né-é ra né. Ndɔkɨ ꞌpanè: Dꞌa ɓa-é dow kɨ́ Najarɛtɨ. ");
INSERT INTO mge_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɓal-je kɨ́ rangɨ go-tɨ, Ja̰ kɨ́ njèra dow-je batḛm ində lo tḛḛ ə ilə mbḛ diləlo-tɨ kɨ́ dɔnangɨ Jude-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«In̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ, kdɔ kɔ̰ɓe kɨ́ dɔra̰-tɨ ree ngɔsi.» ");
INSERT INTO mge_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja̰ lé ɓá to dow kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ pa ta liə kete panè: «Ooi, ndi dow kɨ́ njèkilə mbḛ diləlo-tɨ panè: ꞌRai go rəbɨ lə ꞌƁaɓe! ꞌRai go ngan rəbɨ-je liə adi a̰ njururu-njururu!» ");
INSERT INTO mge_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja̰ ɔɔ kubɨ kɨ́ ꞌra kɨ̀ bəl jambal, dɔɔ ɓədɨ-é kɨ̀ ndaá dɔɔ ɓədɨ ə nékuso-é to ꞌbete-je, kɨ̀ tojɨ kɨ́ wale. ");
INSERT INTO mge_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dow-je kɨ́ Jorijalḛm, kɨ̀ dow-je kɨ́ dɔnangɨ Jude-tɨ lay, kɨ̀ dow-je kɨ́ mḛḛ ɓe-je-tɨ kɨ́ tò ngɔsi kàdɨ̀ ba Jurdḛ-tɨ lay ya dꞌɔw rɔ-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ꞌpa ta rəsɨ dɔ majal-je-tɨ lə-dé dꞌadɨ-é ra-dé-né batḛm kəm man ba Jurdḛ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lokɨ Ja̰ oo Parisi-je, kɨ̀ Sadusi-je n̰a̰-n̰a̰ ꞌree rɔ-é-tɨ kdɔ kadɨ ra-dé batḛm tɔ lé, ḛ dəjɨ-dé panè: «Sə̰i kɨ́ mḛḛ-si ndul titɨ-na̰ kɨ̀ mḛḛ li pii-je bè kan! Ná̰ ɓá idə-si kadɨ a̰yi wɔngɨ kɨ́ à ree lé wa? ");
INSERT INTO mge_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Adi kullə ra-si tuwə kullə ra dow-je kɨ́ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ɓane. ");
INSERT INTO mge_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ooi nè a ꞌgɨri mḛḛ-si-tɨ painè ꞌtoi nganka Abrakam. Mꞌidə-si rəsɨ mꞌadɨ ooi, kdɔ ər-je kin ya kàrè Lubə asɨ təl-dé nganka Abrakam-tɨ kare. ");
INSERT INTO mge_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dꞌində kungə́ pèrèrè kàdɨ̀ kagɨ-je-tɨ káre-káre lay ngá, adɨ kagɨ kɨ́ kandɨ-é majɨ al lé, dꞌa tugə-é dɔ njirə-é-tɨ kdɔ kilə-é dan pər-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ma̰, mꞌra-si batḛm mani, sɔbɨ-né dɔ panjiyə-si-je kɨ́ majɨ al kɨ́ ꞌtusi in̰əi kɔgɨ lé. Ngà ḛ kɨ́ à ree go-m-tɨ lé, tɔ́gɨ-é itə-m n̰a̰, adɨ saba kɨ́ nja-é-tɨ ya kàrè mꞌtuwə kadɨ mꞌtɔr al. Ḛ lé ɓá, à ra-si batḛm lə Ndil kɨ́ aa njay rəm, batḛm pər rəm. ");
INSERT INTO mge_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ə ḛ ɔw kɨ̀ né tó-né liə ji-é-tɨ nɔ̰ɔ̰; à ra lo tó né liə ə à mbɔ̰ ko liə kungɨ dama̰, ngà tisə-é ɓá à kungɨ dan pər-tɨ kɨ́ à koy al sartagangɨ.» ");
INSERT INTO mge_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jeju ḭ Galile ɔw rɔ Ja̰-tɨ ta ba Jurdḛ-tɨ kdɔ kadɨ ra-é batḛm. ");
INSERT INTO mge_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngà Ja̰ ndigɨ mbatɨ adɨ idə-é panè: «Ma̰ ɓá ꞌa ra-m batḛm, rəmə i tá ꞌree kadɨ mꞌra-i batḛm tɔ ɓəy wa!» ");
INSERT INTO mge_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jeju təl idə-é panè: «Kɨ́ ngɔsnè-tɨ kinlé, ꞌndigɨ sə-m dɔ-tɨ kadɨ jꞌra bè, kadɨ né kɨ́ njururu kɨ́ Lubə ndigɨ lé né-é ra-né né.» Beɓa Ja̰ ndigɨ siə dɔ-tɨ ə ra-é batḛm. ");
INSERT INTO mge_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lokɨ Jeju ra batḛm ɓá tḛḛ kəm man-tɨ bè ya rəmə ta dɔra̰ tḛḛ, adɨ oo Ndil Lubə, titɨ-na̰ kɨ̀ dəngɔdnda bè, ree isɨ dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Rəmə, ndi dow ɓa dɔra̰-tɨ panè: «Ḛ kan to Ngon-m, mꞌində-é dan kəm-m-tɨ, rɔ-m nəl-m dɔ-é-tɨ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Go-tɨ, Ndil Lubə ɔr Jeju ɔw siə diləlo-tɨ kdɔ kadɨ Sú na̰-é. ");
INSERT INTO mge_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jeju ra ndɔ kɔrsɔ ya uso né al, adɨ ɓo ra-é. ");
INSERT INTO mge_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Beɓa njèna̰ dow-je lé ree rɔ-é-tɨ pa siə panè: «Kinə ꞌto Ngon lə Lubə ya rəmə, ꞌun ndu adɨ ər-je kin ꞌtəl mbə̀.» ");
INSERT INTO mge_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngà Jeju idə-é panè: «ꞌNdàngɨ ꞌpanè: “Dow à kisɨ kɨ̀ dɔ-é taá kɨ̀ takul nékuso ya par al, ngà kɨ̀ takul ta-je lay kɨ́ tḛḛ ta Lubə-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go-tɨ, Sú ɔw kɨ̀ Jeju ɓebo-tɨ kɨ́ aa njay, kɨ́ to ɓebo lə Lubə, adɨ-é a̰ taá sam kəy-tɨ lə Lubə ");
INSERT INTO mge_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ɓá idə-é panè: «Kinə ꞌto Ngon lə Lubə ya rəmə, ꞌkilə ꞌusɨ nangɨ. Kdɔ ꞌndàngɨ ꞌpanè: “Lubə à kun ndu kadɨ malayka-je liə kdɔ ta lə-i. Ə dḛ dꞌa kində ji-dé kuwə-i-né taá, nè nja-i à kḭ dar ər.”» ");
INSERT INTO mge_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeju təl idə-é panè: «ꞌNdàngɨ mḛḛ mbete-tɨ lé tɔ ꞌpanè: “ꞌA na̰ ꞌƁaɓe Lubə lə-i al.”» ");
INSERT INTO mge_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sú təl ɔw siə dɔ mbal-tɨ kɨ́ ngal lḛng-lḛng, tɔjɨ-é kɔ̰ɓe-je kɨ́ dɔnangɨ-tɨ nè kin lay, kɨ̀ riɓa-je kɨ́ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ə idə-é panè: «Kinə ꞌtɔsɨ məkəjɨ-i nangɨ ə ꞌɔsɨ dɔ-i nangɨ nɔ̰̀-m-tɨ lé, mꞌa kadɨ-i né-je kin lay.» ");
INSERT INTO mge_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jeju təl idə-é panè: «Sata̰, ꞌɔtɨ rangɨ ta-m-tɨ! Kdɔ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: “ꞌƁaɓe Lubə lə-i ɓá ꞌa kɔsɨ dɔ-i nangɨ nɔ̰̀-é-tɨ ə ḛ ya kɨ̀ kár-é ꞌa pole-é.”» ");
INSERT INTO mge_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Beɓa Sú tusɨ Jeju in̰ə-é. Malayka-je ꞌree ꞌra kɨ̀ Jeju. ");
INSERT INTO mge_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dꞌilə Ja̰ dangay-tɨ, beɓa lokɨ Jeju oo ta-é lé, ḛ ɔtɨ ɔw dɔnangɨ Galile-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Rəmə in̰ə ɓe kɨ́ Najarɛtɨ, ɔw isɨ Kapɛrnayim ta babo-tɨ kɨ́ Galile, kɨ́ to dɔnangɨ lə Jabulɔ̰-je kɨ̀ Néptali-je. ");
INSERT INTO mge_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tò bè kdɔ kadɨ ta kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ pa kete lé né-é ra né. Ḛ panè: ");
INSERT INTO mge_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Dow-je kɨ́ dɔnangɨ-tɨ lə Jabulɔ̰-je Kɨ̀ dɔnangɨ-tɨ lə Néptali-je, Kɨ̀ dow-je kɨ́ njèkisɨ ngɔsi ta babo-tɨ, Kɨ̀ gidɨ ba Jurdḛ-tɨ, dɔnangɨ Galile-tɨ kɨ́ ꞌto jipɨ-je al; ");
INSERT INTO mge_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dow-je kɨ́ dꞌisɨ lo kɨ́ ndul-tɨ, dꞌoo londógɨ kɨ́ boy rəm! Dḛ kɨ́ ndil koy səbɨ dɔ-dé-tɨ kàrè lo ndógɨ dɔ-dé-tɨ rəm tɔ!» ");
INSERT INTO mge_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dɔkaglo-é-tɨ kin ɓá Jeju ulə gin kilə mbḛ ə idə dow-je panè: «In̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ, kdɔ kɔ̰ɓe kɨ́ dɔra̰-tɨ ree ngɔsi!» ");
INSERT INTO mge_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ndɔ káre bè, Jeju ɔw njiyə ta babo Galile-tɨ, rəmə oo ngankɔ̰-na̰-je joo kɨ́ ꞌto mbɔw-je dꞌa̰ dꞌilə burə baa: To Simɔ̰ kɨ́ ꞌɓa-é Piyər dḛ kɨ̀ ngonkɔ̰-é Andre. ");
INSERT INTO mge_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Beɓa Jeju idə-dé panè: «ꞌReei uni go-m ə mꞌa təl-si njésangɨ dow-je-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rəmə tajinatɨ nè ya ꞌtusɨ burə-je lé dꞌin̰ə ə dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lokɨ Jeju ɔtɨ ɔw kete əbɨ rəmə, oo ngankɔ̰-na̰-je kɨ́ rangɨ joo ɓəy, adɨ to Jakɨ dḛ kɨ̀ Ja̰ kɨ́ ꞌto ngan lə Jebede, dꞌisɨ mḛḛ tò-tɨ kɨ̀ bɔbɨ-dé, dꞌisɨ ꞌrakɨ burə-je lə-dé. Jeju ɓa-dé rəmə ");
INSERT INTO mge_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kalangɨ bè ya ꞌtusɨ bɔbɨ-dé kɨ̀ tò dꞌin̰ə-é ə dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeju ɔw kɨ̀ go lo-je lay kɨ́ dɔnangɨ Galile-tɨ, ndó né dow-je mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je, ilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə rəm, ɓá adɨ mɔ̰y-je kɨ̀ mətɨ-je kɨ́ gay-gay lay ɔr dɔ dow-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri Jeju ɓa ɔr lo kɨ́ dɔnangɨ Siri-tɨ njutɨ-njutɨ, adɨ dow-je dꞌɔw kɨ̀ njémɔ̰y-je kɨ́ gay-gay, kɨ́ rɔ-dé to-dé kɨ lo-é lo-é, kɨ̀ dow-je kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé, kɨ̀ dḛ kɨ́ kɔ̰nɔ̰ ɔsɨ-dé, kɨ̀ dḛ kɨ́ rɔ-dé oy mburukɨ-je kɨ rɔ-é-tɨ adɨ adɨ-dé lapiya. ");
INSERT INTO mge_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌun go-é, adɨ to dow-je kɨ́ dꞌḭ dɔnangɨ Galile-tɨ-je, kɨ̀ go dɔnangɨ kɨ́ ɓebo-je kɨ́ dɔgɨ tò-tɨ, kɨ̀ dow-je kɨ́ ɓebo Jorijalḛm-tɨ-je, kɨ̀ dḛ kɨ́ dɔnangɨ Jude-tɨ, kɨ̀ dḛ kɨ́ mḛḛ ɓe-je-tɨ kɨ́ gidɨ ba Jurdḛ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lokɨ Jeju oo kosɨ dow-je lé, ḛ al isɨ taá dɔ mbal-tɨ. Beɓa njéndó né-je liə ꞌree rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Rəmə ulə gin ndó-dé né panè: ");
INSERT INTO mge_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Dow-je kɨ́ dꞌoo rɔ-dé kɨ né al takəm Lubə-tɨ ɓá ꞌto njénékumə̰-je! Kdɔtalə kɔ̰ɓe kɨ́ dɔra̰-tɨ tò kdɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dow-je kɨ́ njéndingə ndoo ɓá ꞌto njénékumə̰-je! Kdɔtalə Lubə à sɔl mḛḛ-dé! ");
INSERT INTO mge_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dow-je kɨ́ njésɔl dɔ-dé ɓá ꞌto njénékumə̰-je! Kdɔtalə Lubə à kadɨ dɔnangɨ təl né dɔji-dé! ");
INSERT INTO mge_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dow-je kɨ́ ɓo ra né kɨ́ njururu ra-dé kin ɓá ꞌto njénékumə̰-je! Kdɔtalə Lubə à kadɨ-dé tɔ́gɨ! ");
INSERT INTO mge_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dow-je kɨ́ njékoo kəmtondoo lə madɨ-dé-je ɓa ꞌto njénékumə̰-je! Kdɔtalə Lubə à koo kəmtondoo lə-dé tɔ! ");
INSERT INTO mge_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dow-je kɨ́ mḛḛ-dé aa njay ɓá ꞌto njénékumə̰-je! Kdɔtalə dꞌa koo Lubə kɨ̀ kəm-dé! ");
INSERT INTO mge_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Njékulə dow-je nojɨ natɨ ɓá ꞌto njénékumə̰-je! Kdɔtalə dꞌa ɓa-dé ngan lə Lubə! ");
INSERT INTO mge_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dow-je kɨ́ dꞌisɨ dꞌulə kəm-dé ndoo kdɔ né ra-dé kɨ́ njururu ɓá ꞌto njénékumə̰-je! Kdɔtalə kɔ̰ɓe kɨ́ dɔra̰-tɨ tò kdɔ ta lə-dé! ");
INSERT INTO mge_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Sə̰i kɨ́ dow-je ꞌtajɨ-si, dꞌulə kəm-si ndoo ꞌtə́tɨ ta-je kɨ́ majɨ al majɨ al ta-si-tɨ kdɔ ta lə-m ɓá ꞌtoi njénékumə̰-je! ");
INSERT INTO mge_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ꞌRai rɔnəl ə ꞌtiləi kole! Kdɔtalə nékugə dɔji kɨ́ boy n̰a̰ ya tò ngəbɨ-si dɔra̰-tɨ nɔ̰ɔ̰. Njépata-je kɨ́ ta Lubə-tɨ kete nɔ̰̀-si-tɨ kàrè dow-je dꞌulə kəm-dé ndoo bè ya tɔ!» ");
INSERT INTO mge_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Sə̰i ɓá ꞌtoi katɨ lə dɔnangɨ. Ngà kinə mbinə̰ katɨ ɔr kɔgɨ lé, dow à ra ban ɓá à təl dɔ̰ gogɨ ɓəy wa? Majɨ-é goto ngá. Təl né kɨ́ tuwə kungɨ kɔgɨ gidɨ lo-tɨ kadɨ dow-je ꞌnjiyə dɔ-tɨ ya par ngá. ");
INSERT INTO mge_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Sə̰i ɓá ꞌtoi londógɨ lə dɔnangɨ. Beɓa ɓebo kɨ́ tò dɔ mbal-tɨ taá lé, à kasɨ ɓɔyɔ rɔ-é al. ");
INSERT INTO mge_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dow à kində pər lampɨ-tɨ kdɔ jəbɨ ngó dɔ-tɨ al. Ngà à na̰a̰ kagna̰a̰ lampɨ-tɨ taá kdɔ kadɨ dow-je kɨ́ mḛḛ kəy-tɨ lay ya dꞌoo-né lo. ");
INSERT INTO mge_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bè ya tɔ, adi dow-je lay ya dꞌoo londógɨ lə-si mḛḛ né ra-tɨ kɨ́ majɨ. Lokɨ dꞌoo-né ra-si kɨ́ majɨ rəmə, dꞌa kɔsɨ gajɨ Bɔbɨ-si Lubə kɨ́ isɨ dɔra̰-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ooi nè a painè, mꞌree kdɔ bujuru ndukun-je lə Moiyijɨ kɨ̀ néndó lə njépata-je kɨ́ ta Lubə-tɨ. Ma̰ lé, mꞌree kdɔ ꞌbujuru kɔgɨ al, ngà mꞌree kdɔ kadɨ ta-je lə-dé lé né-é ra né ngá. ");
INSERT INTO mge_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ooi majɨ, mꞌa kidə-si rəsɨ; ka̰ ya dɔra̰ kɨ̀ dɔnangɨ dꞌa̰ lo ka̰-dé-tɨ ɓəy kinlé, tó ndukun lə Lubə à tò lo tò-é-tɨ rəm, ndajɨ mbete kɨ́ káre-rè ya kàrè dow à bujuru mḛḛ mbete ndukun-tɨ kɔgɨ al sar ya kadɨ né-je lay kinlé ra-né né. ");
INSERT INTO mge_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dow kɨ́ al dɔ ngon ndukun káre dan ndukun-je-tɨ lə Lubə rəm, ndó dow-je adɨ dꞌal dɔ-é siə tɔ lé, dowbé à to dow kɨ́ sḛ bè kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ. Ngà dow kɨ́ təl rɔ-é go ndukun-je-tɨ rəm, ɓá ndó dow-je adɨ ꞌtəl rɔ-dé go-tɨ siə tɔ lé, à to dow kɨ́ boy kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Beɓa mꞌa kidə-si rəsɨ: «Kinə né ra kɨ́ njururu lə-si itə ꞌlə njéndó dow-je ndukun-je kɨ̀ Parisi-je al rəmə, a kandi kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ nda̰ bè al.» ");
INSERT INTO mge_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ꞌpanè: «ꞌA tɔl dow al; dow kɨ́ tɔl dow lé, dꞌa kɔw siə nɔ̰̀ njégangta-je-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngà ma̰ rəmə, mꞌidə-si mꞌpanè: Dow kɨ́ adɨ wɔngɨ ra-é dɔ ngonkɔ̰-é-tɨ lé, dꞌa kɔw siə lo gangta-tɨ. Ngà dow kɨ́ tajɨ ngonkɔ̰-é panè nꞌto dow kɨ́ kɔgɨ kare lé, asɨ kadɨ dꞌɔw kɨ̀ dowbé lo gangɨ ta-tɨ kɨ́ boy, ngà dow kɨ́ ɓa ngonkɔ̰-é mbə́ dow rəmə, à tokɨ kilə dowbé dan pər-tɨ kɨ́ tò sartagangɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lokɨ ꞌɔw kdɔ kadɨ né Lubə logugɨ né-tɨ, ɓá kinə mḛḛ-i ole dɔ ta-tɨ kɨ́ ngonkɔ̰-i ɔw-né sə-i lé, ");
INSERT INTO mge_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ꞌin̰ə kadkare lə-i lé logugɨ né-tɨ nɔ̰ɔ̰ ya ə ꞌɔw ꞌulə nojɨ natɨ siə kete ɓəy taá kadɨ ꞌtəl ꞌree ꞌadɨ kadkare lə-i Lubə. ");
INSERT INTO mge_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Lokɨ ꞌisɨ ꞌɔw lo gangta-tɨ kɨ̀ njèta lə-i lé, ꞌulə nojɨ natɨ siə kalangɨ dɔ rəbɨ-tɨ, nè kinə ɔw tḛḛ sə-i nɔ̰̀ njègangta-tɨ lé, njègangta à kilə-i ji asgar-tɨ kadɨ-é ilə-i dangay-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ꞌOo majɨ, mꞌa kidə-i rəsɨ; ꞌa kugə ngər-ngər, sisi ya kàrè à nà̰y al ɓá ꞌa tḛḛ dangay-tɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ꞌpanè: «ꞌA ra kaya al.» ");
INSERT INTO mge_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngà ma̰ rəmə, mꞌidə-si mꞌpanè: «Dow kɨ́ oo dené sar adɨ ɓo-é ra-é mḛḛ-é-tɨ lé, to kaya ya dowbé ra kɨ̀ dené-é ngá tin.» ");
INSERT INTO mge_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kinə kəm-i kɨ́ kɔ̀l ɔw sə-i adɨ ꞌra majal lé, ꞌɔr-é ꞌilə-é kɔgɨ ngərəngɨ nṵ bè, kdɔ ngon rɔ-i káre-rè ə́ tujɨ kdɔ kadɨ rɔ-i kɨ́ lay ɔw-né dan pər-tɨ kɨ́ tò sartagangɨ kin al ə tò sotɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ngà kinə jikɔl-i ɓá ra-i adɨ ꞌra majal lé, ꞌgangɨ-é ilə-é kɔgɨ ngərəngɨ nṵ bè, kdɔ ngon rɔ-i kɨ́ káre-rè ə́ tujɨ kdɔ kadɨ rɔ-i kɨ́ lay ɔw-né dan pər-tɨ kɨ́ tò sartagangɨ kin al ə tò sotɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ɓəy ꞌpanè: «Dow kɨ́ tubə ne-é rəmə kadɨ ra mbete tubə lé adɨ-é ɓane.» ");
INSERT INTO mge_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngà ma̰ rəmə, mꞌa kidə-si rəsɨ; kinə dow tubə ne-é kdɔ ta lə kaya kɨ́ dené ra ɓane, ɓɨ kinə tubə-é kdɔ né kɨ́ rangɨ rəmə dowbé ya ilə ne-é kaya-tɨ. Ə dow kɨ́ njètaa dené kɨ́ ngɔbɨ-é tubə-é lé, ḛ ra kaya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ꞌpanè: «ꞌA kubɨ rɔ-i al. Né kɨ́ un mindɨ-i dɔ-tɨ adɨ ꞌƁaɓe lé, ꞌa ra né-é ya ɓane.» ");
INSERT INTO mge_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngà ma̰ lé, mꞌɔw kɨ̀ kidə-si kadɨ ubi rɔ-si al kɨ́ kubɨ al ya bè. ꞌA kubɨ rɔ-i kɨ̀ dɔra̰ al, kdɔ dɔra̰ to kalikɔ̰ɓe lə Lubə. ");
INSERT INTO mge_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ꞌA kubɨ rɔ-i kɨ̀ dɔnangɨ al, kdɔ dɔnangɨ to lo kungɨ nja Lubə, ꞌa kubɨ rɔ-i kɨ̀ Jorijalḛm al rəm, kdɔ Jorijalḛm to ɓebo lə ngar kɨ́ boy n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ꞌA kubɨ rɔ-i kɨ̀ dɔ-i al, kdɔ bəl dɔ-i káre ya kàrè ꞌa kasɨ ꞌtəl-é kɨ́ ndaa-tɨ əse kɨ́ ndul-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kinə ta lə-si to: «Oiyo» rəmə a̰i dɔ «oiyo-tɨ», ə kinə ta lə-si to: «Á̰-à̰» rəmə a̰i dɔ «á̰-à̰-tɨ.» Ta kɨ́ rangɨ kɨ́ ree go-tɨ to ta lə Njèmḛḛndul ngá. ");
INSERT INTO mge_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ꞌpanè: «Kinə dow tɔɔ kəm madɨ-é rəmə, dꞌa tɔɔ ꞌliə tɔ, kinə dow tətɨ ngangɨ madɨ-é rəmə dꞌa tətɨ ꞌliə tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngà ma̰ rəmə, mꞌidə-si mꞌpanè: Ijəi rɔ njèmḛḛndul al. Kinə dow ində mbɔ́-i kɨ́ kɔ̀l rəmə, ꞌtəl kɨ́ gəl adɨ-é ində ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kinə dow ndigɨ kɔw sə-i lo gangta-tɨ kdɔ taa kubɨ kɨ́ kàdɨ̀-i-tɨ rəmə adɨ-é kubɨ kul lə-i dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kinə dow uwə-i kɨ́ lə njètɔgɨ-tɨ kdɔ kadɨ ꞌnjiyə kulə buy dɔgɨ lé, ɔw siə kulə buy kɔrjoo. ");
INSERT INTO mge_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dow dəjɨ-i né ə adɨ rəm, ɓá dow ndigɨ tunə̰-i né kàrè ɔgɨ-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sə̰i ꞌgəi kɨ́ dꞌidə dḛ kɨ́ kete lé ꞌpanè: «ꞌA ndigɨ ngonkɔ̰-i, ngà njèba lə-i ɓá ꞌa kɔsɨ-é kɨ̀ ta.» ");
INSERT INTO mge_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngà ma̰ rəmə, mꞌidə-si mꞌpanè: ꞌNdigi njéba-je lə-si, ꞌpai ta kɨ̀ Lubə kdɔ dow-je kɨ́ njékulə kəm-si ndoo. ");
INSERT INTO mge_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Beɓa sə̰i a toi-né ngan lə Bɔbɨ-si kɨ́ taá dɔra̰-tɨ. Kdɔ Bɔbɨ-si lé, adɨ kàdɨ̀ liə ubə dɔ njémḛḛndul-je-tɨ rəm, dɔ njémḛḛmajɨ-je-tɨ rəm, ḛ adɨ ndi ədɨ dɔ njéra né-je-tɨ kɨ́ njururu rəm, dɔ njéra né-je-tɨ kɨ́ njururu al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kdɔ kinə dow-je kɨ́ ꞌndigɨ-si ɓá sə̰i ꞌndigi-dé tɔ lé, nékugə dɔji ri ɓá a kingəi-tɨ wa? Njétaalambo-je kàrè ꞌra bè tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kinə ngankɔ̰-si-je ya par ɓá sə̰i ꞌrai-dé lapiya lé, ri ɓá tò gay rɔ-si-tɨ kɨ̀ dow-je kɨ́ rangɨ wa? Dow-je kɨ́ ꞌto jipɨ-je al kàrè ꞌra bè tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ə́n ə́ adi kullə ra-si majɨ ɔr njutɨ titɨ kɨ́ kullə ra Bɔbɨ-si kɨ́ dɔra̰-tɨ majɨ ɔr-né njutɨ kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ooi bè, majɨ kɨ́ ꞌrai lé, ꞌrai kdɔ kadɨ dow-je dꞌoo-si-né al; bè al rəmə a nali nédɔji-si rɔ Bɔbɨ-si-tɨ kɨ́ njèkisɨ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kinə ꞌadɨ né njèndoo lé, ꞌində gəngɨ dɔ-tɨ titɨ kɨ̀ njékədkəm dow-je dꞌisɨ ꞌra-né mḛḛ kəykəwna̰-tɨ lə jipɨ-je, kɨ̀ kagɨ rəbɨ-je kdɔ kadɨ dow-je ꞌpitɨ-dé-né kin al. Ooi majɨ, mꞌa kidə-si rəsɨ; dowbé-je kinlé dꞌingə né dɔji-dé ngá. ");
INSERT INTO mge_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngà i rəmə, lokɨ ꞌadɨ né njèndoo lé, kadɨ jigəl-i gə né kɨ́ jikɔl-i adɨ kinlé al. ");
INSERT INTO mge_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bè kdɔ kadɨ né kɨ́ ꞌadɨ kinlé tò kɨ̀ go ngə̰y, rəmə Bɔbɨ-i kɨ́ oo né-je kɨ́ tò kɨ̀ go ngə̰y lé, à kugə dɔji-i.» ");
INSERT INTO mge_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Lokɨ isi ꞌpai ta kɨ̀ Lubə lé, ꞌrai tana̰ kɨ́ njékədkəm dow-je dꞌisɨ ꞌra né kin bè al. Dḛ ꞌndigɨ ka̰ taá ɓá pa ta kɨ̀ Lubə mḛḛ kəykəwna̰-je-tɨ lə-ji jə̰i jipɨ-je, kɨ̀ kàdɨ̀ rəbɨ-je rəm tɔ, kdɔ kadɨ dow-je dꞌoo-dé. Ooi majɨ, mꞌa kidə-si rəsɨ; dḛ dꞌingə né dɔji-dé ngá. ");
INSERT INTO mge_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngà i rəmə, lokɨ ꞌndigɨ pa ta kɨ̀ Lubə lé, ꞌandɨ kəy, ꞌutɨ takəy ta-i-tɨ ɓá ꞌpa ta kɨ̀ Bɔbɨ-i, rəmə Bɔbɨ-i kɨ́ njèkoo né-je kɨ́ lo ɓɔyɔrɔ-tɨ, à kugə dɔji-i. ");
INSERT INTO mge_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Lokɨ isi ꞌpai ta kɨ̀ Lubə lé, ꞌpai ta-je n̰a̰-n̰a̰ titɨ-na̰ kɨ́ dow-je kɨ́ ꞌto jipɨ-je al dꞌisɨ ꞌra-né kin bè al. Dḛ ꞌgɨr ꞌpanè ta kɨ́ ꞌpa n̰a̰-n̰a̰ kin ɓá Lubə à koo-né dɔ ndi-dé wa! ");
INSERT INTO mge_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ngà sə̰i rəmə ꞌndaji kəm-dé al, kdɔ Lubə kɨ́ Bɔbɨ-si gə né kɨ́ mḛḛ-si ndigɨ kete ɓəy ɓá kadɨ sə̰i ꞌdəji-é ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ooi, kəm rəbɨ kɨ́ a pai-né ta kɨ̀ Lubə ə́n: “Bɔbɨ-ji kɨ́ ꞌisɨ taá dɔra̰-tɨ! Kadɨ dow-je ꞌgə kɨ́ ꞌaa njay; ");
INSERT INTO mge_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kadɨ kɔ̰ɓe lə-i ree; Kadɨ dow-je kɨ́ dɔnangɨ-tɨ nè ꞌra né kɨ́ mḛḛ-i ndigɨ Titɨ kɨ́ dḛ kɨ́ dɔra̰-tɨ dꞌisɨ ꞌra-né bè tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌAdɨ-ji nékuso kɨ́ asɨ ta-ji mḛḛ ndɔ-tɨ kɨ́ ɓone. ");
INSERT INTO mge_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞌIn̰ə go majal-je lə-ji kɔgɨ, Titɨ kɨ́ jḛ kàrè jꞌin̰ə-né go majal-je kɨ́ dow-je dꞌisɨ ꞌra sə-ji kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ꞌIn̰ə-ji adɨ jꞌusɨ mḛḛ néna̰-tɨ al; Ngà ꞌɔr ji kɔgɨ ji Njèmḛḛndul-tɨ. Kdɔ kɔ̰ɓe, kɨ̀ tɔ́gɨ, kɨ̀ riɓa to kɨ́ lə-i ya sartagangɨ. Amḛn!” ");
INSERT INTO mge_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kinə in̰əi go majal-je kɨ́ dow-je ꞌra sə-si kɔgɨ lé, Bɔbɨ-si kɨ́ isɨ dɔra̰-tɨ à kin̰ə go kɔgɨ kadɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngà kinə in̰əi go kɔgɨ adi dow-je al lé, Bɔbɨ-si à kin̰ə go majal-je lə-si kɔgɨ kadɨ-si al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Lokɨ ɔgi rɔ-si nékuso kɨ̀ man ka̰y kadɨ ꞌpai ta kɨ̀ Lubə lé, adi kəm-si ra ndoo titɨ-na̰ kɨ́ njékədkəm dow-je dꞌisɨ ꞌra-né kin bè al. Dḛ dꞌulə kəm-dé natɨ wur-wur kadɨ dow-je dꞌoo kɨ́ nꞌɔgi rɔ-dé nékuso kɨ̀ man ka̰y kdɔ pa ta kɨ̀ Lubə. Ooi majɨ, mꞌa kidə-si rəsɨ; dḛ dꞌingə nékugə dɔji-dé ngá. ");
INSERT INTO mge_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngà i rəmə lokɨ ꞌndigɨ kɔgɨ rɔ-i nékuso kɨ̀ man ka̰y kdɔ pa ta kɨ̀ Lubə lé, ꞌtogɨ takəm-i sukɨ-sukɨ, ə ꞌndəm ubɨ kɨ́ ətɨ majɨ dɔ-i-tɨ, ");
INSERT INTO mge_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kdɔ kadɨ dow-je ꞌgə kɨ́ ꞌɔgɨ rɔ-i nékuso kɨ̀ man ka̰y kdɔ pa ta kɨ̀ Lubə al, ngà kadɨ Bɔbɨ-i kɨ́ isɨ lo ɓɔyɔrɔ-tɨ ya kɨ̀ kár-é oo, rəmə Bɔbɨ-i kɨ́ oo né kɨ́ lo ɓɔyɔrɔ-tɨ lé à kugə dɔji-i. ");
INSERT INTO mge_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ꞌMbɔ̰i né-je lə-si indəi ngangəm dɔnangɨ-tɨ nè al, kdɔ n̰ɔ̰ à kɔ̰̀ rəm, à nɔ̰ rəm, ɓá njéɓogɨ-je kàrè dꞌa tətɨ takəy kdɔ kɔy rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngà ꞌmbɔ̰i né-je lə-si indəi ngangəm dɔra̰-tɨ taá, kdɔ to lo kɨ́ né kɨ́ titɨ à nɔ̰ al rəm, n̰ɔ̰ à kɔ̰̀ al rəm, ɓá njéɓogɨ-je dꞌa tətɨ takəy kdɔ kɔy al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kdɔ lo kɨ́ né lə-i kɨ́ ində ngangəm tò-tɨ lé, lo-é ya mḛḛ-i à tò dɔ-tɨ gə́rə́rə́ tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kəm-i lé, to lampɨ lə rɔ-i. Kinə kəm-i tò majɨ lé, to ndəgɨ rɔ-i lay ɓá isɨ dan lo kɨ́ ndógɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngà kinə kəm-i tò majɨ al lé, ndəgɨ rɔ-i lay ya tò dan lo kɨ́ ndul-tɨ tɔ; kinə kəm-i kɨ́ to londógɨ lə rɔ-i təl to lo kɨ́ ndul lé, londul kinlé à təl to lo kɨ́ ndul ndḭ-ndḭ. ");
INSERT INTO mge_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Dow kɨ́ à kasɨ ra ɓə lə ngar-je joo ya goto. Kdɔtalə à kɔsɨ ta ḛ kɨ́ káre ə à ndigɨ ḛ kɨ́ káre, al kàrè, à nam kɨ̀ ḛ kɨ́ káre ə nədɨ ḛ kɨ́ káre. Adɨ a kasi kori Lubə kɨ̀ là natɨ joo kdɔ ra kullə kadɨ-dé al. ");
INSERT INTO mge_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Beɓa mꞌa kidə-si rəsɨ panè: Adi mḛḛ-si a̰ kə́kə́kə́ adɨ ꞌpainè: «Ri ɓá jꞌa kuso əse ri ɓá jꞌa ka̰y kdɔ kisɨ-né əse jꞌa kingə kubɨ rá ɓá jꞌa kɔɔ wa» al. Kdɔ kisɨ kɨ̀ dɔ taá lə dow majɨ n̰a̰ itə nékuso rəm, ɓá dajɨ rɔ dow majɨ n̰a̰ itə kubɨ-je rəm tɔ ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ooi, yəl-je kɨ́ ꞌnar taá kin; dḛ ꞌdubɨ ko al rəm, dꞌijə ko dꞌungɨ dama̰ al rəm, ya ngà Bɔbɨ-si kɨ́ dɔra̰-tɨ ya isɨ ul-dé! Ngà sə̰i lé, gatɨ-si itə gatɨ yəl-je kin sa̰y ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ná̰ dan-si-tɨ ɓá à kasɨ kilə ndɔ-é dɔ madɨ-é-tɨ sḛ kɨ̀ takul mḛḛ ka̰ kə́kə́kə́ liə wa? ");
INSERT INTO mge_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ə kdɔ ri ɓá adi mḛḛ-si a̰ kə́kə́kə́ kdɔ kubɨ-je wa? Uni kəm-si ooi-né putɨ wale-je kɨ́ wale kin! Dḛ ꞌra kullə madɨ al rəm, dꞌojɨ kubɨ al rəm, ");
INSERT INTO mge_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ya ngà mꞌa kidə-si rəsɨ kɨ́ Salomɔ̰ kɨ́ to njènékingə kɨ́ n̰a̰ kin ya kàrè, ɔɔ kubɨ-je kɨ́ ndóle asɨ kɨ̀ putɨ wale-je kin nja káre al. ");
INSERT INTO mge_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sə̰i dow-je kɨ́ kadmḛḛ lə-si to kɨ́ ndḛ bè kan! Wale-je kɨ́ dꞌa̰ mḛḛ ndɔr-je-tɨ ɓone ya ə bore pər à kɔ̰̀-dé kin kàrè Lubə adɨ ꞌmɔ̰ne kɨ̀ putɨ-dé mbṵṵ rəm, ngà sə̰i kɨ́ ban ɓá ḛ à kadɨ-si kubɨ al wa? ");
INSERT INTO mge_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Adi mḛḛ-si a̰ kə́kə́kə́ adɨ ꞌpainè: «Ri ɓá jꞌa kuso wa? Ri ɓá jꞌa ka̰y wa? Jꞌa kingə kubɨ rá ɓá jꞌa kulə wa?» al. ");
INSERT INTO mge_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kdɔ né-je lay kinlé, gin dow-je lay kɨ́ rangɨ kin ɓá dꞌadɨ rɔ-dé kɔ̰̀ ꞌsangɨ par-par; ngà sə̰i rəmə, Bɔbɨ-si kɨ́ isɨ dɔra̰-tɨ gə majɨ kɨ́ né-je kinlé ɔwi ndoo-é. ");
INSERT INTO mge_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ꞌSangi kɔ̰ɓe lə Lubə kɨ̀ né ra kɨ́ njururu liə ya kete, rəmə ndəgɨ né-je lay kinlé, Lubə à kadɨ-si dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adi mḛḛ-si a̰ kə́kə́kə́ dɔ ndɔ kɨ́ bore-tɨ al, kdɔ ndɔ kɨ́ bore ɔw kɨ̀ mḛḛ ka̰ kə́kə́kə́ liə tɔ. Ndɔ-je lay ya dꞌɔw kɨ̀ né to rɔ kɨ́ sɔbɨ dɔ-dé dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ꞌGangi ta dɔ dow-tɨ al, nè dꞌa gangta dɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kdɔ kəm rəbɨ kɨ́ sə̰i ꞌgangi-né ta dɔ dow-tɨ kinlé, ḛ ya dꞌa gangɨ-né ta dɔ-si-tɨ tɔ; ə né kɨ́ ꞌmbɔji-né né adi dow kinlé, ḛ ya dꞌa təl mbɔjɨ-né né kadɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ban ɓá i oo wale kɨ́ tò kəm ngonkɔ̰-i-tɨ rəmə, kagɨ kɨ́ boy kɨ́ tò kəm-i-tɨ kin ɓá i oo al wa? ");
INSERT INTO mge_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ban ɓá ꞌa kidə ngonkɔ̰-i panè: «Adɨ mꞌɔr wale kɨ́ tò kəm-i-tɨ» kin kɔgɨ ə i rəmə, ꞌoo kagɨ kɨ́ tò kəm-i-tɨ kin al wa? ");
INSERT INTO mge_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","I njèkədkəm dow-je kan! ꞌƆr kagɨ kɨ́ boy kɨ́ tò kəm-i-tɨ ya pa ɓəy ɓá ꞌa koo wale kɨ́ tò kəm ngonkɔ̰-i-tɨ kdɔ kɔr kadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Adi né kɨ́ aa njay bisɨ-je al, nè dꞌa təl kɨ́ dɔ-si-tɨ kdɔ tɔ̰-si. ꞌTiləi mədkɔsɨ kɨ́ gatɨ-é n̰a̰ nɔ̰̀ kɔsɔngɨ-je-tɨ al, nè dꞌa mbəjrə nja-dé-tɨ nangɨ. ");
INSERT INTO mge_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ꞌDəji ə dꞌa kadɨ-si, ꞌsangi ə a kingəi, indəi tarəbɨ ə dꞌa tḛḛ kadɨ-si. ");
INSERT INTO mge_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kdɔ dow kɨ́ dəjɨ ya ə dꞌadɨ-é, dow kɨ́ sangɨ ə ingə, dow kɨ́ ində tarəbɨ ə ꞌtḛḛ dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ná̰ dan-si-tɨ ɓá ngon-é dəjɨ-é mbə̀ rəmə à kadɨ-é ər wa? ");
INSERT INTO mge_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Əse lokɨ dəjɨ-é kanjɨ rəmə à kadɨ-é li wa? ");
INSERT INTO mge_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ə sə̰i kɨ́ ꞌtoi njémḛḛndul-je kàrè, ꞌgəi kadɨ né-je kɨ́ majɨ-majɨ ngan-si-je rəm, ngà Bɔbɨ-si kɨ́ dɔra̰-tɨ kɨ́ ban ɓá à kadɨ né-je kɨ́ majɨ dow-je kɨ́ ꞌdəjɨ-é lé al wa? ");
INSERT INTO mge_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Né lay kɨ́ ꞌndigi kadɨ dow-je ꞌra dꞌadɨ-si lé, ga̰-é ya ꞌrai adi-dé tɔ. Ḛ kin ɓá to né kɨ́ ndukun lə Moiyijɨ, kɨ̀ mbete-je lə njépata-je kɨ́ ta Lubə-tɨ ꞌndigɨ. ");
INSERT INTO mge_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Andi kɨ̀ tarəbɨ kɨ́ tò mbɔyɔyɔ bè. Ooi, tarəbɨ kɨ́ tatɨ pəl-pəl to rəbɨ kɨ́ lo kun-é ɔ̰̀ al, ḛ ɓá to rəbɨ kɨ́ ɔw kɨ̀ dow-je lo tujɨ-tɨ, rəbɨ-é kinlé dow-je n̰a̰ ya dꞌun. ");
INSERT INTO mge_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Rəmə tarəbɨ kɨ́ tò mbɔyɔyɔ kɨ́ to rəbɨ kɨ́ lo kun-é nga̰ lé, to rəbɨ kɨ́ ɔw kɨ lo kiskəm-tɨ, rəbɨ-é kinlé dow-je n̰a̰ ya dꞌingə al. ");
INSERT INTO mge_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ooi go rɔ-si majɨ rɔ njékədta-je-tɨ kɨ́ njéɓa rɔ-dé njépata-je kɨ́ ta Lubə-tɨ, kdɔtalə dꞌun ndaá batɨ dɔn-né rɔ-dé ɓá ꞌree-né rɔ-si-tɨ, ngà mḛḛ-dé-tɨ rəmə ꞌto jagɨm-je kɨ́ njétɔɔ ko dow-je. ");
INSERT INTO mge_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sə̰i a gəi-dé kɨ̀ takul kullə ra-dé. Dow à tɔr kandɨ nduu dɔ kun pàràrà-tɨ al rəm, ɓá dow à kijə kandɨ kote dɔ nga̰-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kagɨ kɨ́ rá-rá ya kɨ́ majɨ lé, kandɨ-é à majɨ, ə ḛ kɨ́ majɨ al lé, kandɨ-é à majɨ al ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ə kagɨ kɨ́ majɨ lé kandɨ-é à majɨ al al, ɓá kagɨ kɨ́ majɨ al kàrè kandɨ-é à majɨ nda̰ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kagɨ kɨ́ rá-rá kɨ́ kandɨ-é majɨ al lé, dꞌa gangɨ-é kilə-é pərəə. ");
INSERT INTO mge_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Adɨ njékədta-je kɨ́ njéɓa rɔ-dé njépata-je kɨ́ ta Lubə-tɨ lé a gəi-dé kɨ̀ takul kullə ra-dé.» ");
INSERT INTO mge_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Dow-je kɨ́ ꞌɓa-m: «ꞌƁaɓe, ꞌƁaɓe» kin ɓá dꞌa kɔw lay kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ al, ngà dow kɨ́ ra né kɨ́ mḛḛ Bɔbɨ-m kɨ́ dɔra̰-tɨ ndigɨ ya par ɓá à kɔw. ");
INSERT INTO mge_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ndɔ gangta-tɨ lé, dow-je n̰a̰ ya dꞌa pa sə-m panè: «ꞌƁaɓe, ꞌƁaɓe! Jḛ kɨ́ ndɔkɨ jꞌilə mbḛ kɨ̀ ri-i, jꞌtubə ndil-je kɨ́ majɨ al kɨ̀ ri-i, jꞌra nékɔjɨ-je n̰a̰-n̰a̰ kɨ̀ ri-i lé ya wa?» ");
INSERT INTO mge_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Beɓa mꞌa kidə-dé rəsɨ panè: «Mꞌgə-si nja káre al, ɔwi ngərəngɨ nṵ bè, sə̰i njéra né-je kɨ́ majɨ al majɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ooi, ná̰-ná̰ kɨ́ oo ta lə-m ə təl rɔ-é go-tɨ lé, à titɨ-na̰ kɨ̀ njèkəmkaa kɨ́ ində kəy liə jam dɔ́di-tɨ bè. ");
INSERT INTO mge_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Beɓa lokɨ ndi ədɨ, man taa lo lay, yə́lbo ulə dɔ kəy-tɨ lé ya kàrè, kəy-é tɔɔ al, kdɔtalə dꞌində gin-é jam dɔ́di-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngà ná̰-ná̰ kɨ́ oo ta lə-m ɓá təl rɔ-é go-tɨ al lé, à titɨ-na̰ kɨ̀ mbə́ dow kɨ́ ində kəy liə dɔ nangra-tɨ bè. ");
INSERT INTO mge_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lokɨ ndi ədɨ, man taa lo lay, yə́l ulə dɔ kəy-tɨ lé, kəy-é tə́tɨ nangɨ rúm-rúm.» ");
INSERT INTO mge_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lokɨ Jeju tɔl ta ta-je liə lé, néndó liə ɔr ndil dow-je n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kdɔ ḛ ndó né dow-je kəm dow kɨ́ ɔw kɨ̀ tɔ́gɨ ɓɨ ndó né tana̰ kɨ̀ njéndó dow-je ndukun-je al. ");
INSERT INTO mge_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lokɨ Jeju ḭ kɨ dɔ mbal-tɨ isɨ risɨ nangɨ lé, kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌun go-é lo-é-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Beɓa njèbanjɨ káre tḛḛ ree rɔ Jeju-tɨ, səbɨ takəm-é nangɨ nɔ̰̀-é-tɨ ɓá idə-é panè: «ꞌƁaɓe, kinə ꞌndigɨ lé, ꞌa kadɨ banjɨ lə-m kin ur kadɨ mꞌaa njay.» ");
INSERT INTO mge_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeju ulə ji-é ɔdɨ-né rɔ-é ɓá panè: «Mꞌndigɨ dɔ-tɨ sə-i. Kadɨ banjɨ lə-i ur!» Rəmə tajinatɨ nè ya banjɨ liə ur adɨ-é aa njay tɔ. ");
INSERT INTO mge_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Go-tɨ, Jeju idə-é panè: «ꞌIdə ta-é dow kɨ́ rangɨ al, ꞌɔw ꞌɔjɨ rɔ-i njègugné lə Lubə, ə ꞌadɨ kadkare Lubə kɨ́ go ndukun-tɨ lə Moiyijɨ. Bè kdɔ kadɨ dow-je lay ꞌgə kɨ́ banjɨ kɨ́ rɔ-i-tɨ lé ur ngá.» ");
INSERT INTO mge_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lokɨ Jeju isɨ andɨ kɨ́ mḛḛ ɓe-tɨ kɨ́ Kapɛrnayim rəmə, dow káre bè kɨ́ to njèkun dɔ kutɨ asgar-je kɨ́ ɓu ree rɔ-é-tɨ, nɔ̰ kɨ dɔ-é-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ꞌƁaɓe, ngonnjèkullə lə-m káre tò mɔ̰y kəy nɔ̰ɔ̰, nja-é oy ta kutɨ-é-tɨ, adɨ ingə kɔ̰̀ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ɓa Jeju idə-é panè: «Mꞌa kɔw ə mꞌa kadɨ-é lapiya.» ");
INSERT INTO mge_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngà njèkun dɔ asgar-je lé idə-é panè: «ꞌƁaɓe, ma̰ lé mꞌtuwə kadɨ ꞌree mḛḛ kəy-tɨ lə-m al; ə́n ə́ ꞌpa ta káre ya par ə ngonnjèkullə lə-m à kingə lapiya. ");
INSERT INTO mge_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mꞌpa bè kdɔ, ma̰ kɨ̀ dɔ-m mꞌisɨ gin tɔ́gɨ-tɨ lə dow-je kɨ́ dɔ-m-tɨ rəm, mꞌɔw kɨ̀ asgar-je gin tɔ́gɨ-tɨ lə-m rəm. Adɨ kinə mꞌidə ḛ kɨ́ káre mꞌpanè: “ꞌƆw!” ə ɔtɨ ɔw! Ə kinə mꞌidə ḛ kɨ́ rangɨ mꞌpanè: “ꞌRee!” ə ɔtɨ ree! Ə kinə mꞌidə ngonnjèkullə lə-m mꞌpanè: “ꞌRa né kin!” ə ɔtɨ ra né-é lé.» ");
INSERT INTO mge_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lokɨ Jeju oo ta-je kɨ́ tḛḛ ta-é-tɨ kin bè rəmə pitɨ-é, ə idə dḛ kɨ́ dꞌa̰ siə panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dɔnangɨ Israyel-tɨ ya kàrè mꞌingə ko kadmḛḛ kɨ́ tana̰ bè kin nja káre al ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ooi, mꞌa kidə-si rəsɨ kɨ́ kosɨ dow-je kɨ́ ꞌto jipɨ-je al dꞌa kḭ kɨ lo kubə kàdɨ̀-tɨ, kɨ̀ lo kur kàdɨ̀-tɨ kdɔ ree kisɨ ta nékuso-tɨ kɨ̀ Abrakam, kɨ̀ Isakɨ kɨ̀ Jakobɨ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngà ngan njéɓe-je kɨ́ ꞌto jipɨ-je lé dꞌa kungɨ-dé ndaa-tɨ lo-tɨ kɨ́ ndul ndḭ-ndḭ kɨ́ to lo kɨ́ dow-je dꞌa nɔ̰-tɨ rəm, dꞌa kuso ngangɨ-dé titɨ məgəgə-məgəgə rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Beɓa Jeju təl idə njèkun dɔ kutɨ asgar-je kɨ́ ɓu kinlé panè: «ꞌƆw, ngonnjèkullə lə-i lé, à kingə lapiya titɨ kɨ́ tḛḛ-né ta-i-tɨ kɨ́ go kadmḛḛ-tɨ lə-i.» Tajinatɨ nè ya ngonnjèkullə lé ingə lapiya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Go-tɨ, Jeju ɔw mḛḛ kəy-tɨ lə Piyər rəmə, oo məm Piyər kɨ́ dené tò nangɨ, ꞌningə́ ində-é adɨ rɔ-é tungə pil-pil. ");
INSERT INTO mge_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ɓa Jeju ɔdɨ rɔ ji-é rəmə, ꞌningə́ lé in̰ə-é. Go-tɨ, ḛ ḭ taá oo go-dé kɨ̀ nékuso. ");
INSERT INTO mge_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lokɨ kàdɨ̀ ur lé, ꞌree kɨ̀ dow-je n̰a̰ kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé rɔ Jeju-tɨ. Adɨ Jeju tubə ndil-je kɨ́ majɨ al dɔ-dé-tɨ kɔgɨ kɨ̀ ta kɨ́ ta-é-tɨ, ɓá adɨ lapiya njémɔ̰y-je lay tɔ. ");
INSERT INTO mge_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tò bè kdɔ kadɨ ta kɨ́ Ejay kɨ́ njèpata kɨ́ ta Lubə-tɨ pa kete lé, né-é ra né. Ejay panè: «Ḛ ɔy mətɨ-je lə-ji kɨ̀ mɔ̰y-je lə-ji dɔ-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ndɔ káre bè lokɨ Jeju oo kosɨ dow-je n̰a̰ ꞌgəə dɔ-é rəmə, ḛ un ndu adɨ njéndó né-je liə kadɨ ꞌgangɨ babo dꞌɔw turə. ");
INSERT INTO mge_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngá ɓá dow káre bè kɨ́ njèndó dow-je ndukun lə Lubə ree rɔ Jeju-tɨ idə-é panè: «Njèndó dow-je né, mꞌa kun go-i lo lay kɨ́ ꞌa kɔw-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jeju ilə-é-tɨ panè: «Tal-je dꞌɔw kɨ̀ ɓe tò-dé nɔ̰ɔ̰, ɓá yəl-je kɨ́ ꞌnar taá kin kàrè dꞌɔw kɨ̀ kəy tò-dé tɔ. Ngà Ngon lə dow lé, lo kɨ́ kadɨ ulə dɔ-é-tɨ ya kàrè goto.» ");
INSERT INTO mge_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dow káre dan njéndó né-je-tɨ liə idə-é panè: «ꞌƁaɓe, ꞌadɨ-m tarəbɨ adɨ mꞌɔw mꞌdubɨ bɔbɨ-m mɔkɨ tá.» ");
INSERT INTO mge_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngà Jeju təl idə-é panè: «ꞌIn̰ə dḛ kɨ́ dꞌoy ꞌadɨ ꞌdubɨ dow-je lə-dé kɨ́ dꞌoy, ə ꞌree un go-m.» ");
INSERT INTO mge_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jeju al mḛḛ tò-tɨ, ə njéndó né-je liə dꞌal go-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Rəmə, tajinatɨ nè ya yə́lbo tḛḛ sə-dé busɨ, ulə mbḭḭ-mbḭḭ dɔ babo-tɨ adɨ pungum man ɔw kɨ̀ tò yó-je kɨ nè-je adɨ tò ɔw kɨ̀ nduy sə-dé. Ya rəmə Jeju tò tò ɓi. ");
INSERT INTO mge_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngà ɓá njéndó né-je liə ꞌngəsɨ rɔ-é-tɨ, ꞌndəl-é kɨ̀ nɔ̰ ta-dé ꞌpanè: «ꞌƁaɓe, ꞌajɨ-ji, nè ko-ji à tɔɔ!» ");
INSERT INTO mge_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jeju pa sə-dé panè: «Sə̰i dow-je kɨ́ kadmḛḛ lə-si to kɨ́ ndḛ bè kan! ꞌƁəli n̰a̰ bè kdɔ ri wa!» Rəmə ḛ ḭ taá ndángɨ yə́l, kɨ̀ babo lé, adɨ lo təl tò ndingɨ. ");
INSERT INTO mge_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Né kɨ́ ra-né kinlé, ɔr ndil-dé adɨ ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: «Dow kanlé to dow kɨ́ ban ya ɓá yə́l-je kɨ̀ babo-je kàrè ꞌtəl rɔ-dé go ta-tɨ liə bè wa?» ");
INSERT INTO mge_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lokɨ Jeju ree tḛḛ gidɨ babo-tɨ, dɔnangɨ-tɨ lə dow-je kɨ́ Gadara lé, dingəm-je joo kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé, ꞌtḛḛ kɨ dɔ ɓadɨ-je-tɨ ꞌtilə kəm-é. Dingəm-je kinlé ꞌra né majɨ al n̰a̰, adɨ dow-je ꞌɓəl lo kun rəbɨ kɨ́ rɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dḛ ꞌtur kəə ꞌpanè: «Ngon lə Lubə, ꞌge ri rɔ-ji-tɨ wa? ꞌRee kdɔ kadɨ adɨ-ji kɔ̰̀ kete nɔ̰̀ kaglo kɔ̰̀-tɨ lé wa?» ");
INSERT INTO mge_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kosɨ kɔsɔngɨ-je n̰a̰ ya dꞌa̰ dꞌuso né kàdɨ̀ lo-tɨ kɨ́ tò ngərəngɨ sə-dé. ");
INSERT INTO mge_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Beɓa ndil-je kɨ́ majɨ al lé, ꞌra ndoo ta Jeju-tɨ ꞌpanè: «Kinə ꞌtubə-ji rəmə, ꞌadɨ jꞌɔw mḛḛ kɔsɔngɨ-je-tɨ kin.» ");
INSERT INTO mge_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jeju ꞌndigɨ sə-dé adɨ panè: «Ɔwi.» Rəmə dḛ ꞌtḛḛ dꞌɔw ꞌtur mḛḛ kɔsɔngɨ-je-tɨ lé, adɨ kosɨ kɔsɔngɨ-je lé ꞌtətɨ-na̰ yipɨ kàdɨ̀ mbal-tɨ taá, ꞌtusɨ baa dꞌoy lay. ");
INSERT INTO mge_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Njéngəm kɔsɔngɨ-je lé, dꞌa̰y dꞌɔw mḛḛ ɓebo-tɨ, dꞌɔr poy né kɨ́ ra-né rəm, né kɨ́ tḛḛ dɔ dingəm-je-tɨ kɨ́ joo kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé kin lay dꞌadɨ dow-je dꞌoo. ");
INSERT INTO mge_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Beɓa dow-je lay kɨ́ mḛḛ ɓebo-tɨ ꞌtḛḛ ꞌtilə kəm Jeju. Lokɨ dꞌoo-é rəmə ꞌra ndoo ta-é-tɨ kadɨ in̰ə dɔnangɨ lə-dé ə ɔw rangɨ. ");
INSERT INTO mge_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeju al mḛḛ tò-tɨ, ində babo gangɨ, ɔw ɓe kojɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dow-je madɨ dꞌun dow kɨ́ njèrɔkoy mburukɨ mḛḛ tuwə-tɨ ꞌree siə rɔ-é-tɨ. Lokɨ Jeju oo kadmḛḛ lə-dé bè rəmə, idə njèrɔkoy mburukɨ lé panè: «Ngon-m, ꞌore mḛḛ-i, majal-je lə-i tokɨ kin̰ə go-é kɔgɨ!» ");
INSERT INTO mge_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lokɨ njéndó dow-je ndukun-je kɨ́ madɨ-je dꞌoo ta kin bè rəmə, ꞌpa ta mḛḛ-dé-tɨ ꞌpanè: «Dow kanlé pa ta kɔbɨ dɔ Lubə-tɨ!» ");
INSERT INTO mge_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeju gə ta kɨ́ mḛḛ-dé-tɨ gɔw adɨ dəjɨ-dé panè: «Kdɔ ri ɓá ɔwi kɨ̀ tagɨr-je kɨ́ majɨ al bè kin mḛḛ-si-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dan ta-je-tɨ kɨ́ joo kinlé, ḛ kɨ́ rá ɓá tò ɓəl n̰a̰ wa? Kidə dow panè: «Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ» ɓá tò ɓəl n̰a̰ əse kidə-é panè: «ꞌḬ taá ꞌnjiyə» ɓá tò ɓəl n̰a̰ wa? ");
INSERT INTO mge_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Majɨ! Mꞌa kɔjɨ-si kadɨ ꞌgəi kɨ́ Ngon lə dow lé, ɔw kɨ̀ tɔ́gɨ dɔnangɨ-tɨ nè kdɔ kin̰ə-né go majal-je lə dow-je kɔgɨ. Beɓa Jeju təl idə njèrɔkoy mburukɨ lé panè: «ꞌḬ taá, ꞌun tuwə lə-i, ə ꞌɔw ɓee lə-i!» ");
INSERT INTO mge_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Beɓa dingəm lé ḭ taá, ɔw ɓee liə. ");
INSERT INTO mge_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Né kinlé, kosɨ dow-je dꞌoo bè rəmə ɔr ndil-dé n̰a̰, adɨ dꞌɔsɨ gajɨ Lubə kɨ́ njèkadɨ dow-je tɔ́gɨ kɨ́ tana̰ bè kin. ");
INSERT INTO mge_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lokɨ Jeju ḭ lo-é-tɨ kin ɔw kɨ kete lé, oo dingəm kɨ́ ri-é lə Matiye, isɨ lo taa lambo-je-tɨ rəmə idə-é panè: «ꞌUn go-m!» Ə Matiye ḭ taá un go-é. ");
INSERT INTO mge_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Go-tɨ, Jeju isɨ ta nékuso-tɨ mḛḛ kəy-tɨ lə Matiye. Rəmə njétaalambo-je n̰a̰ kɨ̀ njéramajal-je n̰a̰ ꞌree dꞌisɨ ta nékuso-tɨ natɨ kɨ̀ Jeju kɨ̀ njéndó né-je liə. ");
INSERT INTO mge_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lokɨ Parisi-je dꞌoo Jeju isɨ uso né natɨ kɨ̀ dow-je kinlé rəmə, ꞌdəjɨ njéndó né-je liə ꞌpanè: «Kdɔ ri ɓá njèndó-si né isɨ uso né kɨ̀ njétaalambo-je, kɨ̀ njéramajal-je kin wa?» ");
INSERT INTO mge_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jeju oo ndi-dé, adɨ idə-dé panè: «Dow-je kɨ́ rɔ-dé tò kɨ̀ lapiya kare lé dꞌɔw ndoo dɔktur al, ngà njémɔ̰y-je ɓá dꞌɔw ndoo-é. ");
INSERT INTO mge_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kdɔtalə njéramajal-je ɓá mꞌree kdɔ sangɨ nja-dé, ɓɨ mꞌree kdɔ njéra né kɨ́ njururu-je kin al. Ɔwi ꞌsangi kadɨ ꞌgəi mḛḛ ta kɨ́ Lubə pa panè: “Ma̰ Lubə lé, koo kəmtondoo ɓá mꞌndigɨ, ɓɨ məsɨ da̰-je kɨ́ kadɨ-m kin al.”» ");
INSERT INTO mge_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Njéndó né-je lə Ja̰ kɨ́ njèra dow-je batḛm ꞌree dꞌingə Jeju ꞌdəjɨ-é ꞌpanè: «Kdɔ ri ɓá jḛ kɨ̀ Parisi-je jꞌisɨ jꞌɔgɨ rɔ-ji nékuso kɨ̀ man ka̰y kdɔ pa ta kɨ̀ Lubə, ngà njéndó né-je lə-i ꞌra al wa?» ");
INSERT INTO mge_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jeju ilə-dé-tɨ panè: «Dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ kɨ́ lo taana̰-tɨ lé, dꞌa ndingə ndoo kaglo-tɨ kɨ́ njètaa dené sigɨ isɨ-né sə-dé natɨ wa? Ndɔ-je ɔw ree nɔ̰ɔ̰ lé, dꞌa kun njètaa dené sigɨ lé ta-dé-tɨ kɔgɨ ngá ɓá dꞌa kɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Dow à kun takubɨ kɨ́ sigɨ kdɔ kilə-né kəm ndisɨ kubɨ al, kdɔ takubɨ kɨ́ sigɨ lé, à kuwə dɔgangɨ ndisɨ kubɨ lé wuktu kɔr, ə à ra kadɨ kəm kubɨ kɨ́ mbutɨ lé tò wororo ta madɨ-é-tɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bè ya tɔ, dow à tur yibɨ nduu kɨ́ sigɨ mḛḛ mbundaá-je-tɨ kɨ́ low al tɔ, kdɔ lokɨ yibɨ nduu à kḭ lé, à kində mbundaá lé kadɨ riyə́; ə yibɨ nduu à kungɨ kɔgɨ rəm, ɓá mbundaá lé kàrè à təl né kɨ́ tujɨ kɔgɨ rəm tɔ. Beɓa kinə yibɨ nduu to kɨ́ sigɨ rəmə, kadɨ mbundaá kàrè to kɨ́ sigɨ ya tɔ ɓane. Bè rəmə, mbundaá à riyə́ al rəm, yibɨ nduu kàrè à kungɨ kɔgɨ al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lokɨ Jeju isɨ pa sə-dé ta-je kin bè ya ɓəy rəmə, ꞌboy káre kɨ́ dɔ kəykəwna̰-tɨ lə jipɨ-je, ree səbɨ takəm-é nangɨ nɔ̰̀-é-tɨ ɓá idə-é panè: «Ngon-m kɨ́ dené oy tajinatɨ nè ɓəy nɔ̰ɔ̰, ꞌree ꞌində ji-i dɔ-é-tɨ ə à təl kisɨ kɨ̀ dɔ-é taá kadɨ-m.» ");
INSERT INTO mge_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeju kɨ̀ njéndó né-je liə dꞌḭ dꞌɔw siə natɨ. ");
INSERT INTO mge_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dené kɨ́ məsɨ ree rɔ-é-tɨ ɓal dɔgɨ gidɨ-é joo tḛḛ gidɨ Jeju-tɨ, ulə ji-é ɔdɨ-né takubɨ liə. ");
INSERT INTO mge_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kdɔtalə gɨr mḛḛ-é-tɨ panè: «Kinə takubɨ liə ya ɓá lé mꞌɔdɨ rɔ kàrè rɔ-m à kingə lapiya.» ");
INSERT INTO mge_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeju ilə rətɨ oo-é, ə idə-é panè: «Ngon-m kɨ́ dené, ꞌore mḛḛ-i, kadmḛḛ lə-i adɨ-i lapiya.» Rəmə tajinatɨ nè ya dené lé ingə lapiya. ");
INSERT INTO mge_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lokɨ Jeju ɔw tḛḛ kəy lə ꞌboy kɨ́ dɔ kəykəwna̰-tɨ lə jipɨ-je kinlé rəmə, oo njéka̰y nal-je, kɨ̀ kosɨ dow-je kɨ́ ꞌsingə sokro dɔ-na̰-tɨ, ɓá idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ɔri rɔ-si gogɨ, ngon kɨ́ dené lé oy al, ngà tò ɓi kɨ tò.» Rəmə dow-je ꞌsɔkɨ Jeju. ");
INSERT INTO mge_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lokɨ dow-je ꞌtḛḛ ndaa-tɨ lé, Jeju andɨ kəy, uwə ji ngon kɨ́ dené lé adɨ-é ḭ taá. ");
INSERT INTO mge_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Beɓa poy-é ɔr lo kɨ́ dɔnangɨ-tɨ kɨ nɔ̰ɔ̰ lay. ");
INSERT INTO mge_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lokɨ Jeju ḭ lo-é-tɨ kin isɨ ɔw kɨ kete rəmə, njékəmtɔ-je joo dꞌun go-é, ə ꞌtur kəə boy-boy ꞌpanè: «Ngonka Dabidɨ, ꞌoo kəmtondoo lə-ji.» ");
INSERT INTO mge_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jeju ɔw tḛḛ kəy rəmə, njékəmtɔ-je kɨ́ joo kinlé dꞌɔw rɔ-é-tɨ ə ḛ dəjɨ-dé panè: «Ooi kɨ́ mꞌasɨ ra né kɨ́ sə̰i ꞌdəji-mi lé wa?» Dḛ dꞌilə-é-tɨ ꞌpanè: «Oiyo, ꞌƁaɓe, jꞌoo kɨ́ i asɨ.» ");
INSERT INTO mge_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Beɓa, Jeju ɔdɨ rɔ kəm-dé ɓá idə-dé panè: «Kadɨ Lubə ra sə-si kɨ go kadmḛḛ-tɨ lə-si!» ");
INSERT INTO mge_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Rəmə tajinatɨ nè ya kəm-dé oo lo. Ngà go-tɨ, Jeju ndəjɨ-dé panè: «Adi dow gə al.» ");
INSERT INTO mge_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngà lokɨ dꞌɔtɨ dꞌɔw lé, dḛ ꞌpa ta lə Jeju adɨ sane kɨ̀ go dɔnangɨ kɨ́ nɔ̰ɔ̰ lay. ");
INSERT INTO mge_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lokɨ njékəmtɔ-je ꞌtḛḛ dꞌɔw lé, dow-je ꞌree kɨ̀ dingəm káre kɨ́ ndil kɨ́ majɨ al ra-é, adɨ pa ta al, rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jeju tubə ndil kɨ́ majɨ al lé ya rəmə, dingəm lé pa ta. Né kinlé ɔr ndil kosɨ dow-je n̰a̰, adɨ ꞌpanè: «Kay! Jꞌoo né kɨ́ tana̰ bè kin dɔnangɨ Israyel-tɨ nja káre al ɓəy!» ");
INSERT INTO mge_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngà Parisi-je rəmə ꞌpanè: «To tɔ́gɨ lə ꞌboy lə ndil-je kɨ́ majɨ al ɓá ḛ isɨ tubə-né ndil-je kɨ́ majɨ al!» ");
INSERT INTO mge_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeju ɔw kɨ̀ nganɓe-je, kɨ̀ ɓebo-je, ndó né dow-je mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je rəm, ilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə rəm, ɓá adɨ mɔ̰y-je kɨ̀ mətɨ-je kɨ́ gay-gay lay ɔr dɔ dow-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lokɨ ḛ oo kosɨ dow-je lé bè rəmə, ta ɔ̰̀ mḛḛ-é kdɔ ta lə-dé, kdɔ kɔ ra-dé, tɔ́gɨ-dé goto, adɨ tana̰ kɨ̀ batɨ-je kɨ́ njèkul-dé goto bè. ");
INSERT INTO mge_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Beɓa ḛ idə njéndó né-je liə panè: «Ko kɨ́ tò kijə n̰a̰, ngà njékijə-é-je ɓá ꞌn̰a̰ al. ");
INSERT INTO mge_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ə́n ə́ ꞌpai ta kɨ̀ ꞌɓa njèko kɨ́ tò kijə lé, kadɨ ulə kɨ̀ njérakullə-je titɨ.» ");
INSERT INTO mge_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeju ɓa njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo rɔ-é-tɨ ə adɨ-dé tɔ́gɨ kadɨ ꞌtubə-né ndil-je kɨ́ majɨ al rəm, ɓá kadɨ dꞌadɨ mɔ̰y-je kɨ̀ mətɨ-je kɨ́ gay-gay lay ɔr-né dɔ dow-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ri njékɔwkulə-je kɨ́ dɔgɨ gidɨ-é joo lé ə́n: Ḛ kɨ́ dɔsa̰y to Simɔ̰ kɨ́ ꞌɓa-é Piyər dḛ kɨ̀ ngonkɔ̰-é Andre, Jakɨ kɨ̀ ngonkɔ̰-é Ja̰ kɨ́ ꞌto ngan lə Jebede. ");
INSERT INTO mge_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipɨ kɨ̀ Batlemi, Tomasɨ kɨ̀ Matiye kɨ́ njètaalambo, kɨ̀ Tade, kɨ̀ Jakɨ kɨ́ ngon lə Alpe. ");
INSERT INTO mge_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ̰ kɨ́ to dow kɨ́ ta ɓe liə to-é, kɨ̀ Judasɨ Iskariyotɨ kɨ́ njèkun dɔ Jeju. ");
INSERT INTO mge_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeju ulə njékɔwkulə-je liə kɨ́ dɔgɨ gidɨ-é joo kɨ̀ ndu-je kin panè: «Dow-je kɨ́ ꞌto jipɨ-je al lé, ɔwi rɔ-dé-tɨ al, ɓá ɔwi mḛḛ ɓebo-je-tɨ kɨ́ Samari al rəm. ");
INSERT INTO mge_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ɔwi rɔ gin kojɨ-tɨ lə Israyel kɨ́ dꞌɔw tana̰ kɨ̀ batɨ-je kɨ́ ndəm bè kin táà. ");
INSERT INTO mge_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lokɨ isi ɔwi rəmə, iləi mbḛ taá-taá ꞌpainè: “Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò ngɔsi!” ");
INSERT INTO mge_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ə adi lapiya njémɔ̰y-je, adi dow-je kɨ́ dꞌoy ꞌtɔsɨ ꞌndəl rəm, adi njébanjɨ-je dꞌingə lapiya rəm, ɓá ꞌtubəi ndil-je kɨ́ majɨ al dɔ dow-je-tɨ rəm tɔ. To né kɨ́ ingəi kare, ə́n ə́ adi dow-je kare ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uni lɔr ji-si-tɨ al rəm, uni là ji-si-tɨ al rəm, uni sisi uləi posɨ-si-tɨ al rəm, ");
INSERT INTO mge_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","uni mbu kɔw mba al rəm, ɔyi kubɨ joo-joo al rəm, ɔyi saba əse uni salangɨ al rəm tɔ. Kdɔ to tó-é kadɨ njèrakullə ingə nékuso mḛḛ kullə-tɨ kɨ́ isɨ ra. ");
INSERT INTO mge_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mḛḛ ɓebo əse ngonɓe kɨ́ rá-rá kɨ́ ɔwi-tɨ lé, ꞌdəji ta ooi se dow madɨ kɨ́ à kuwə-si kɨ rɔ-é-tɨ isɨ nɔ̰ɔ̰ wa? Rəmə dowbé ya isi rɔ-é-tɨ sar kadɨ ḭi-né. ");
INSERT INTO mge_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lokɨ andi mḛḛ kəy-tɨ rəmə, ꞌrai dow-je kɨ́ mḛḛ kəy-tɨ lapiya. ");
INSERT INTO mge_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kinə dꞌuwə-si kɨ rɔ-dé-tɨ rəmə, kadɨ lapiya lə-si nà̰y sə-dé. Ngà kinə dꞌuwə-si kɨ rɔ-dé-tɨ al tɔ rəmə, kadɨ lapiya lə-si təl kɨ rɔ-si-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lokɨ dꞌuwə-si kɨ rɔ-dé-tɨ al əse dꞌoo ta-je lə-si al rəmə, ꞌtḛḛi mḛḛ kəy-é-tɨ əse mḛḛ ɓe-é-tɨ kinlé, ə ꞌgəki kodɨ kɨ́ nja-si-tɨ kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ooi majɨ, mꞌa kidə-si rəsɨ; ndɔ gangta-tɨ lé, ta kɨ́ gangɨ kɨ́ dɔ ɓebo-é-tɨ kinlé à nga̰ n̰a̰ kitə ta kɨ́ gangɨ kɨ́ dɔ dɔnangɨ Sɔdɔm-tɨ kɨ̀ Gɔmɔr ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yən, mꞌulə-si titɨ-na̰ kɨ̀ batɨ-je bè dan jagɨm-je-tɨ; ə́n ə́ indəi kəmkaa dɔ rɔ-si-tɨ titɨ li-je bè rəm, ɓá kadɨ ꞌsɔli lɔm-lɔm titɨ dəngɔdnda-je bè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ooi go rɔ-si rɔ dow-je-tɨ, kdɔ dꞌa kilə-si ji njégangta-je-tɨ rəm, dꞌa tində-si kɨ̀ ndəy marɔw mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je rəm, ");
INSERT INTO mge_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","dꞌa kɔw sə-si nɔ̰̀ gubərnər-je-tɨ kɨ̀ nɔ̰̀ ngar-je-tɨ kdɔ ta lə-m; beɓa dḛ rəm, dow-je kɨ́ ꞌto jipɨ-je al rəm dꞌa kingə-né ta kɨ́ sɔbɨ dɔ-m ta-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lokɨ dꞌa kuwə-si kdɔ kɔw sə-si lo gangta-tɨ lé, adi mḛḛ-si a̰ kə́kə́kə́ adɨ ꞌpainè: «Se ta ri ɓá jꞌa pa wa, əse jꞌa pa kɨ̀ gosɨ kɨ́ ban wa» al? Ta kɨ́ a pai lé à tokɨ kində ta-si-tɨ dɔkàdɨ̀-é-tɨ kin ya. ");
INSERT INTO mge_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kdɔ to sə̰i ɓá a pai ta lé al, ngà to Ndil Bɔbɨ-si ɓá à kində ta ta-si-tɨ kadɨ ꞌpai. ");
INSERT INTO mge_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dow à kun dɔ ngonkɔ̰-é ya kadɨ ꞌtɔl-é, bɔbɨ ngon à kun dɔ ngon-é kadɨ ꞌtɔl-é; ngan-je dꞌa kɔsɨ ta njékojɨ-dé-je rəm, dꞌa kun dɔ-dé kadɨ ꞌtɔl-dé rəm. ");
INSERT INTO mge_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dow-je lay ya dꞌa kɔsɨ-si kɨ̀ ta kdɔ ta lə-m; ngà dow kɨ́ uwə rɔ-é nga̰ sar tḛḛ sɔ̰y-é-tɨ ə à kajɨ. ");
INSERT INTO mge_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lokɨ dꞌa kulə kəm-si ndoo mḛḛ ɓebo-tɨ kɨ́ káre rəmə a̰yi-na̰ ɔwi mḛḛ ɓebo-tɨ kɨ́ rangɨ. Ooi majɨ, mꞌa kidə-si rəsɨ; a kuləi ta nja ɓebo-je kɨ́ Israyel-tɨ natɨ al ɓəy ya Ngon lə dow à ree. ");
INSERT INTO mge_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Njèndó né à kitə njèndó-é né al rəm, ɓá ngonnjèkullə à kitə ꞌɓa-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Njèndó né lé kinə titɨ-na̰ kɨ̀ njèndó-é né ya rəmə asɨ; ɓá ngonnjèkullə kàrè kinə titɨ-na̰ kɨ̀ ꞌɓa-é ya rəmə asɨ tɔ. Njèkəy ɓəy ə́ ꞌɓa-é Beljebul kin ngà, dow-je kɨ́ mḛḛ kəy-tɨ liə əjè tò ban ngà ə́n wa? ");
INSERT INTO mge_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ꞌƁəli dow al, kdɔ né kɨ́ dow ɓɔyɔ kɨ́ gin-é à tḛḛ al ya goto rəm, ɓá ta kɨ́ tò lo ɓɔyɔ-é-tɨ kɨ́ dow à gə al kàrè goto rəm. ");
INSERT INTO mge_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta kɨ́ mꞌidə-si ndɔɔ lé, ꞌpai kada rəsɨ. Ta kɨ́ dow-je ꞌpa mbi-si-tɨ n̰ɔ̰m-n̰ɔ̰m bè lé, iləi-né mbḛ dɔ kəy-tɨ taá. ");
INSERT INTO mge_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Dow-je kɨ́ dꞌa tɔl dajɨ rɔ-si, ngà dꞌa kasɨ tɔl ndil-si al lé, ꞌɓəli-dé al; ngà ḛ kɨ́ asɨ tujɨ ndil-si kɨ̀ dajɨ rɔ-si natɨ dan pər-tɨ kɨ́ tò sartagangɨ kin ɓá kadɨ ꞌɓəli-é. ");
INSERT INTO mge_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ꞌTḭḭ-je lé, ꞌndogɨ-dé joo kɨ̀ silə káre káre ya al wa? Lé bè ya kàrè, kinə Bɔbɨ-si Lubə ndigɨ al lé, ngon ꞌtḭḭ káre ya kàrè à kusɨ nangɨ al. ");
INSERT INTO mge_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ə sə̰i lé, bəl dɔ-si kin ya kàrè tokɨ gə kɔr-é lay, ");
INSERT INTO mge_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ə́n ə́ ꞌɓəli al, kdɔ gatɨ-si itə gatɨ ꞌtḭḭ-je nja n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Beɓa dow kɨ́ rá-rá kɨ́ pa ta rəsɨ takəm dow-je-tɨ panè nꞌto dow lə-m lé, ma̰ kàrè mꞌa pa ta liə rəsɨ nɔ̰̀ Bɔbɨ-m-tɨ kɨ́ isɨ dɔra̰-tɨ panè to dow lə-m ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngà dow kɨ́ rá-rá kɨ́ ɔr ta kutɨ-m-tɨ takəm dow-je-tɨ panè nꞌgə-m al lé, ma̰ kàrè mꞌa kɔr ta kutɨ-é-tɨ nɔ̰̀ Bɔbɨ-m-tɨ kɨ́ isɨ dɔra̰-tɨ panè mꞌgə-é al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ooi nè a gɨri kɨ́ to lapiya ɓá mꞌree-né dɔnangɨ-tɨ; to lapiya ɓá mꞌree-né dɔnangɨ-tɨ al, ngà to rɔ ɓá mꞌree-né dan dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mꞌree kɨ̀ gángɨ-na̰ dan ngon kɨ́ dingəm-tɨ dḛ kɨ̀ bɔbɨ-é, mꞌree kɨ̀ gángɨ-na̰ dan ngon kɨ́ dené-tɨ dḛ kɨ̀ kɔ̰-é, mꞌree kɨ̀ gángɨ-na̰ dan ngon kɨ́ dené-tɨ dḛ kɨ̀ məm-é kɨ́ dené. ");
INSERT INTO mge_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ə njéba-je lə dow lé, dꞌa to dow-je kɨ́ mḛḛ kəy-tɨ liə ya. ");
INSERT INTO mge_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Dow kɨ́ ndigɨ kɔ̰-é əse bɔbɨ-é itə-m ma̰ lé, asɨ to dow lə-m al. Rəm ɓá dow kɨ́ ndigɨ ngon-é kɨ́ dingəm əse kɨ́ dené itə-m ma̰ lé, asɨ to dow lə-m al tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dow kɨ́ un go-m ɓá un kagdəsɨ liə al lé, asɨ to dow lə-m al. ");
INSERT INTO mge_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dow kɨ́ ngəm rɔ-é rəmə à tujɨ rɔ-é, ngà dow kɨ́ ilə rɔ-é kɔgɨ kdɔ ta lə-m lé à kingə gogɨ.» ");
INSERT INTO mge_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Dow kɨ́ uwə-si kɨ rɔ-é-tɨ lé, to ma̰ ya ɓá uwə-m kɨ rɔ-é-tɨ tin, ə dow kɨ́ uwə-m kɨ rɔ-é-tɨ kin rəmə, to njèkulə-m ɓá ḛ uwə-é kɨ rɔ-é-tɨ tɔ tin. ");
INSERT INTO mge_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dow kɨ́ uwə njèpata kɨ́ ta Lubə-tɨ kɨ rɔ-é-tɨ kdɔtalə to kɨ́ to njèpata kɨ́ ta Lubə-tɨ lé, à kingə né dɔji kɨ́ asɨ-na̰ kɨ̀ ꞌlə njèpata kɨ́ ta Lubə-tɨ ya bè tɔ. Dow kɨ́ uwə dow kɨ́ njururu kɨ rɔ-é-tɨ, kdɔtalə to kɨ́ ḛ to dow kɨ́ njururu lé, à kingə né kugə dɔji kɨ́ asɨ-na̰ kɨ̀ ꞌlə dow kɨ́ njururu ya bè tɔ. ");
INSERT INTO mge_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Dow kɨ́ rá-rá kɨ́ ɔdɨ man kɨ́ sɔl mḛḛ kaman káre-rè ya adɨ kɨ́ káre dan ngan dow-je-tɨ kɨ́ sḛ kan kdɔ to kɨ́ to njèndó né lə-m lé, ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dowbé kin à nal nékugə dɔji-é al.» ");
INSERT INTO mge_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lokɨ Jeju un ndu-je adɨ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo adɨ gin-é gangɨ lé, ḛ ɔtɨ ɔw mḛḛ ɓebo-je-tɨ kɨ́ dɔnangɨ-tɨ kɨ́ nɔ̰ɔ̰ kdɔ ndó né dow-je rəm, kdɔ kilə mbḛ Poyta kɨ́ Majɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lokɨ Ja̰ kɨ́ njèra dow-je batḛm kɨ́ tò dangay-tɨ, oo poy né-je kɨ́ Kristɨ ra lé, ḛ ulə njéndó né-je liə kadɨ ꞌdəjɨ-é ta ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«I ya ɓá ꞌto dow kɨ́ tò kadɨ à ree lé əse tò kadɨ jꞌngəbɨ dow kɨ́ rangɨ ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Beɓa Jeju ilə-dé-tɨ panè: «ꞌTəli ɔwi idəi Ja̰ ta-je kɨ́ ooi kɨ̀ mbi-si, kɨ̀ né-je kɨ́ ooi kɨ̀ kəm-si adɨ to ");
INSERT INTO mge_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","njékəmtɔ-je kɨ́ dꞌoo lo rəm, njémətɨ-je kɨ́ ꞌnjiyə majɨ rəm, njébanjɨ-je kɨ́ banjɨ lə-dé ur adɨ dꞌaa njay rəm, njémbitɔ-je kɨ́ dꞌoo ta rəm, dow-je kɨ́ dꞌoy kɨ́ ꞌtɔsɨ ꞌndəl dꞌində lo ꞌtḛḛ rəm, njéndoo-je kɨ́ mbḛ Poyta kɨ́ Majɨ usɨ mbi-dé-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dow kɨ́ mꞌtəl gin kusɨ liə al ɓá to njènékumə̰!» ");
INSERT INTO mge_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lokɨ njéndó né-je lə Ja̰ dꞌɔtɨ dꞌɔw lé, Jeju pa ta kɨ́ dɔ Ja̰-tɨ adɨ kosɨ dow-je panè: «To ri ɓá ɔwi ooi diləlo-tɨ wa? To tuwətɔ́gɨ kɨ́ yə́l isɨ ɔw siə yó-je kɨ nè-je kin ɓá ɔwi ooi wa? ");
INSERT INTO mge_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kinə bè al, ngà to ri ya ɓá ɔwi ooi wa? To dow kɨ́ tulə kubɨ-je kɨ́ kurə́-kurə́ rɔ-é-tɨ ɓá ɔwi ooi-é wa? Ngà lé to ḛ kàrè, dḛ kɨ́ ꞌtulə kubɨ-je kɨ́ kurə́-kurə́ bè kinlé, dꞌisɨ mḛḛ kəy-tɨ lə ngar-je yó rəm. ");
INSERT INTO mge_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngà se to ri ya dana̰ ɓá ɔwi ooi wa? Se to njèpata kɨ́ ta Lubə-tɨ ɓá ɔwi ooi-é wa? Tɔgrɔ-tɨ, mꞌa kidə-si, to dow kɨ́ itə njèpata kɨ́ ta Lubə-tɨ sa̰y ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kdɔ to Ja̰ kin ya ɓá ndɔkɨ ꞌndàngɨ ta kɨ́ dɔ-é-tɨ ꞌpanè: “Yən, ma̰ Lubə mꞌulə njèkilə mbḛ lə-m nɔ̰̀-i-tɨ kete, kdɔ kadɨ ɔw ra rəbɨ lə-i adɨ-i.” ");
INSERT INTO mge_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Ooi majɨ, mꞌa kidə-si rəsɨ; dan dow-je-tɨ lay kɨ́ dené-je dꞌojɨ-dé lé, dow kɨ́ to kɨ́ ꞌboy itə Ja̰ kɨ́ njèra dow-je batḛm ya goto. Bè ya kàrè ngon dow kɨ́ ndḛ bè mḛḛ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ lé, boy itə-é. ");
INSERT INTO mge_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ulə gin-é dɔkaglo-tɨ kɨ́ Ja̰ kɨ́ njèra dow-je batḛm ilə-né mbḛ sar tḛḛ-né ɓone lé, kɔ̰ɓe kɨ́ dɔra̰-tɨ təl né nagɨ-na̰ ngá, adɨ njétɔ́gɨ-je ꞌsangɨ kdɔ ka̰y rɔ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mbete-je lə njépata-je kɨ́ ta Lubə-tɨ lay, kɨ̀ ndukun-je lə Moiyijɨ lé, ꞌpa ta kdɔ né-je-tɨ kɨ́ à ra né sar tḛḛ-né dɔ Ja̰ kɨ́ njèra dow-je Batḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kinə adi mḛḛ-si ta-je kin rəmə, Ja̰ kin ɓá to Eli njèpata kɨ́ ta Lubə-tɨ kɨ́ ꞌpa ta-é ꞌpanè à ree lé. ");
INSERT INTO mge_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dow kɨ́ mbi-é tò kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé. ");
INSERT INTO mge_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Ná̰ ɓá mꞌa kun-é kɔjɨ-né dow-je kɨ́ ngɔsnè kan wa? Dow-je kɨ́ ngɔsnè kanlé, ꞌtana̰ kɨ̀ ngan-je kɨ́ dꞌisɨ pandangɨ lo-tɨ, ɓá ꞌɓa madɨ-dé-je ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jꞌkɔl nal kàrè ꞌndami-né al rəm! Ɓá jꞌusɨ pa nɔ̰ yo kàrè ꞌndingəi-né ndoo al rəm!”» ");
INSERT INTO mge_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jeju təl ilə dɔ-tɨ panè: «Mꞌpa bè kdɔ lokɨ Ja̰ ree ɓá ḛ uso né al rəm, a̰y man al rəm lé, dow-je ꞌpanè: “To dow kɨ́ ndil kɨ́ majɨ al ra-é!” ");
INSERT INTO mge_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngà lokɨ Ngon lə dow ree, ɓá ḛ uso né-je, a̰y man-je lé, dow-je ꞌpanè: “Ḛ kanlé uso né bore ngay, to njèka̰y né rəm, ɓá to nam njétaalambo-je, kɨ̀ njéramajal-je rəm!” Bè ya kàrè, kullə ra-é-je tɔjɨ kɨ́ gosɨ lə Lubə to gosɨ kɨ́ tɔgrɔ-tɨ ya.» ");
INSERT INTO mge_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɓebo-je kɨ́ ꞌra nékɔjɨ-je n̰a̰-n̰a̰ dan-dé-tɨ ya kàrè, dḛ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ al lé, Jeju ndángɨ-dé panè: ");
INSERT INTO mge_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Tujɨ à kusɨ dɔ-si-tɨ, sə̰i dow-je kɨ́ Korajḛ! Tujɨ à kusɨ dɔ-si-tɨ, sə̰i dow-je kɨ́ Betsayda! Kdɔ nékɔjɨ-je kɨ́ tokɨ ra dan-si-tɨ nè kinlé, lé tokɨ ra dɔnangɨ Tir-tɨ kɨ̀ dɔnangɨ Sidɔ̰-tɨ je bè, rəmə lé dow-je kɨ́ titɨ dꞌa kulə kubɨ sakɨ rɔ-dé-tɨ tò-né buu-tɨ kdɔ kin̰ə-né panjiyə-dé-je kɨ́ majɨ al kɔgɨ low nṵ ngá. ");
INSERT INTO mge_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Beɓa mꞌa kidə-si rəsɨ ya kɨ́ ndɔ gangta-tɨ lé, ta kɨ́ gangɨ kɨ́ dɔ-si-tɨ à nga̰ n̰a̰ kitə ta kɨ́ gangɨ kɨ́ dɔ dɔnangɨ Tir-tɨ, kɨ̀ dɔnangɨ Sidɔ̰ ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngà sə̰i dow-je kɨ́ Kapɛrnayim, ooi ꞌpainè se riɓa lə-si kin à kɔw sə-si sar dɔra̰-tɨ wa? Bè al, à tokɨ təl sə-si kɨ nangɨ sar kɨ mḛḛ lo kɨ́ koó-tɨ. Kdɔ nékɔjɨ-je kɨ́ tokɨ ra mḛḛ ɓe-tɨ lə-si kinlé, lé tokɨ ra Sɔdɔm-tɨ je bè lé, ɓone ɓone ya kàrè Sɔdɔm à tò nè ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Beɓa mꞌa kidə-si rəsɨ ya kɨ́ ndɔ gangta-tɨ lé, ta kɨ́ gangɨ kɨ́ dɔ-si-tɨ à nga̰ n̰a̰ kitə ta kɨ́ gangɨ kɨ́ dɔ dɔnangɨ Sɔdɔm-tɨ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dɔkaglo-é-tɨ kin ɓá, Jeju un ta panè: «Bɔbɨ-m kɨ́ ꞌto ꞌƁa dɔra̰ kɨ̀ dɔnangɨ, mꞌtɔ́y-i, kdɔ ꞌɓɔyɔ dɔ né-je kin kɨ̀ njégosɨ-je kɨ̀ njénégə-je rəmə ngan dow-je kin ɓá ꞌtḛḛ kɨ̀ dɔ-é adɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oiyo, Bɔbɨ-m, mꞌtɔ́y-i kdɔ to ndigɨ lə-i kadɨ né kinlé tò bè. ");
INSERT INTO mge_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Bɔbɨ-m təl kɨ̀ né-je lay adɨ-m. Dow kɨ́ gə-m ma̰ Ngon lə Lubə lé goto. Bɔbɨ-m ya par ə́ gə-m. Ə dow kɨ́ gə Bɔbɨ-m ya goto. Ma̰ ya par ə́ mꞌgə Bɔbɨ-m lé, ə dow kɨ́ ma̰ Ngon-é lé ya mꞌtḛḛ kəm-é dɔ-é-tɨ tɔ ɓá à gə-é.» ");
INSERT INTO mge_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ꞌReei rɔ-m-tɨ, sə̰i dow-je lay kɨ́ ɔɔi rɔgɨ-rɔgɨ gin nékutɨ-tɨ kɨ́ ɔy, ə mꞌa kadɨ-si ꞌtaai koo. ");
INSERT INTO mge_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uni jugɨ lə-m, ə taai néndó lə-m, kdɔ kadɨ ndil-si ingə lo taakoo, kdɔ mꞌto njèsɔl dɔ-m rəm, mꞌsɔl lɔm-lɔm rəm. ");
INSERT INTO mge_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kdɔ jugɨ lə-m lé ɔy al rəm, ɓá nékutɨ kɨ́ mꞌa kadɨ-si uti lé kàrè, ɔle pele-pele rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ndɔ káre bè, lokɨ Jeju njiyə mḛḛ ndɔr gemḛ-je-tɨ kdɔ kində gangɨ ndɔ taakoo-tɨ lə jipɨ-je lé, ɓo ra njéndó né-je liə, adɨ ꞌpuy dɔ gemḛ dꞌuso taá-taá. ");
INSERT INTO mge_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lokɨ Parisi-je dꞌoo-dé lé, ꞌpa kɨ̀ Jeju ꞌpanè: «ꞌOo, njéndó né-je lə-i ꞌra né kɨ́ to tó-é al kadɨ dow ra ndɔ taakoo-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ngà Jeju ilə-dé-tɨ panè: «Né kɨ́ ndɔkɨ Dabidɨ ra kaglo-tɨ liə, lokɨ ɓo ra-dé dḛ kɨ̀ dow-je liə lé, se sə̰i ꞌndói ta-é mḛḛ mbete-tɨ kɨ́ aa njay ooi ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dabidɨ andɨ mḛḛ kəykubɨ-tɨ lə Lubə, dḛ kɨ̀ dow-je liə, dꞌuso mbə̀ kɨ́ dow-je dꞌadɨ Lubə kadkare-tɨ. To mbə̀ kɨ́ sɔbɨ dɔ-é kadɨ uso al rəm, sɔbɨ dɔ dow-je liə kadɨ dꞌuso al rəm, ngà njégugné-je lə Lubə ya par ɓá sɔbɨ dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ngà njégugné-je lə Lubə ya kɨ́ ꞌra kullə mḛḛ kəy kubɨ-tɨ lə Lubə kɨ̀ ndɔ taakoo, adɨ ꞌtəl ndɔ taakoo né kɨ́ kare-tɨ, ya dow gangta dɔ-dé-tɨ al kinlé, sə̰i ꞌndói ta-é mḛḛ ndukun-tɨ ooi ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Beɓa adɨ mꞌidə-si, né kɨ́ boy itə kəy lə Lubə ya tò nè ngá! ");
INSERT INTO mge_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ꞌNdàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: “Ma̰ Lubə lé, koo kəmtondoo ɓá mꞌndigɨ, ɓɨ məsɨ da̰-je kɨ́ kadɨ-m kin al.” Lé tokɨ ꞌgəi mḛḛ ta kin majɨ lé, sə̰i a gangi ta dɔ dow-je-tɨ kɨ́ ta goto dɔ-dé-tɨ kin bè al. ");
INSERT INTO mge_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kdɔ Ngon lə dow ɓá to ꞌɓa ndɔ taakoo lé.» ");
INSERT INTO mge_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jeju ḭ lo-é-tɨ kinlé ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ə dingəm káre kɨ́ ji-é oy mburukɨ isɨ mḛḛ kəy-tɨ lé nɔ̰ɔ̰. Rəmə Parisi-je kɨ́ dꞌisɨ nɔ̰ɔ̰ ꞌsangɨ rəbɨ kilə ta dɔ Jeju-tɨ adɨ ꞌdəjɨ-é ꞌpanè: «Ndɔ taakoo-tɨ lé, to tó-é kadɨ dow adɨ lapiya njèmɔ̰y əse to tó-é al wa?» ");
INSERT INTO mge_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ngà Jeju ilə-dé-tɨ panè: «Ná̰ dan-si-tɨ ɓá ɔw kɨ̀ batɨ káre-rè, ɓá batɨ-é usɨ bole ndɔ taakoo-tɨ ya à kɔr-é tḛḛ siə ndaa-tɨ al wa? ");
INSERT INTO mge_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngà dow lé, itə batɨ nja n̰a̰-n̰a̰! Adɨ to tó-é kadɨ dow ra majɨ ndɔ taakoo-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngá ɓá Jeju təl idə dingəm kɨ́ njèjikoy lé panè: «ꞌSurə ji-i.» Lokɨ ḛ surə ji-é lé ya rəmə, ji-é lé təl tò majɨ titɨ-na̰ kɨ̀ ḛ kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parisi-je kɨ́ dꞌa̰ lo-é-tɨ lé, ꞌtḛḛ dꞌɔw dꞌɔjɨ-na̰ ta dɔ kəm rəbɨ-tɨ kɨ́ kadɨ nꞌtɔli-né Jeju. ");
INSERT INTO mge_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ngà lokɨ Jeju gə ta kɔjɨ lə Parisi-je lé, ḛ tḛḛ ɔw lo kɨ́ rangɨ-tɨ. Dow-je kɨ́ ꞌtò nduy-nduy ya dꞌun go-é, adɨ ḛ adɨ lapiya njémɔ̰y-je lay tɔ. ");
INSERT INTO mge_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ngà ḛ ndəjɨ-dé kadɨ dꞌadɨ dow gə kɨ́ to nꞌḛ̀ Jeju al. ");
INSERT INTO mge_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bè kdɔ kadɨ ta kɨ́ njèpata kɨ́ ta Lubə-tɨ, Ejay pa kin, ra-né né. Lubə panè: ");
INSERT INTO mge_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ooi, ngonnjèkullə lə-m kɨ́ mꞌmbətɨ-é, Mꞌində-é dan kəm-m-tɨ, rɔ-m nəl-m dɔ-é-tɨ n̰a̰, Mꞌa kadɨ Ndil-m səbɨ dɔ-é-tɨ, À kilə mbḛ né ra kɨ́ njururu kadɨ gin dow-je kɨ́ gay-gay. ");
INSERT INTO mge_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dꞌa kɔl-na̰ kɨ̀ dow al rəm, à kur kəə al rəm, Dow à koo ndi-é pandangɨ lo-tɨ al rəm. ");
INSERT INTO mge_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","À tətɨ tuwətɔ́gɨ kɨ́ tò gudɨ nangɨ al rəm, Lampɨ kɨ́ pər isɨ ɔ̰̀-tɨ ngɛl-ngɛl ɓəy kàrè à kɔsɨ suḭ tɔl al rəm tɔ. À ra bè sar kadɨ né ra kɨ́ njururu ilə njirə. ");
INSERT INTO mge_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Beɓa gin ɓe-je kɨ́ dɔnangɨ-tɨ nè lay ya dꞌa kində mḛḛ-dé dɔ-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dow-je ꞌree kɨ̀ dingəm káre kɨ́ ndil kɨ́ majɨ al ra-é adɨ kəm-é tɔ rəm, pa ta al rəm, adɨ Jeju adɨ-é pa ta rəm, oo lo rəm. ");
INSERT INTO mge_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Né kinlé ɔr ndil kosɨ dow-je n̰a̰, adɨ ꞌdəjɨ ta ꞌpanè: «Kay! Dow kin to Ngonka Dabidɨ lé ya al wa?» ");
INSERT INTO mge_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngà lokɨ Parisi-je dꞌoo ta kin rəmə, ꞌpanè: «Ḛ kinlé isɨ tubə ndil-je kɨ́ majɨ al kɨ̀ tɔ́gɨ lə Beljebul, kɨ́ to ꞌboy lə ndil-je kɨ́ majɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Beɓa Jeju gə gɨr ta kɨ́ mḛḛ-dé-tɨ gɔw adɨ idə-dé panè: «Kɔ̰ɓe kɨ́ rá-rá ya ɓá dow-je kɨ́ mḛḛ-é-tɨ ꞌgangɨ-na̰ dꞌɔsɨ-na̰ kɨ̀ ta lé, à təl ndubəɓe rəm, ɓá ɓebo əse kəy kɨ́ rá-rá ya dow-je kɨ́ mḛḛ-é-tɨ ꞌgangɨ-na̰ dꞌɔsɨ-na̰ kɨ̀ ta kàrè, dowbé-je dꞌa kisɨ gərərə al rəm. ");
INSERT INTO mge_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Bè ya tɔ, kinə Sata̰ ya tubə dow-je lə Sata̰ rəmə, to ḛ ya gángɨ rɔ-é dana̰. Bè kinlé, kɔ̰ɓe liə à ka̰ lo ka̰-é-tɨ gərərə ban wa? ");
INSERT INTO mge_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ə kinə to tɔ́gɨ lə Beljebul ɓá mꞌisɨ mꞌtubə-né ndil-je kɨ́ majɨ al, ngà dow-je lə-si ə dꞌisɨ ꞌtubə-dé kɨ̀ tɔ́gɨ lə ná̰ ngá wa? Kullə ra dow-je lə-si ya ilə ta dɔ-si-tɨ! ");
INSERT INTO mge_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngà kinə to tɔ́gɨ lə Ndil Lubə tɔ ɓá mꞌisɨ mꞌtubə-né ndil-je kɨ́ majɨ al rəmə, to kɔ̰ɓe lə Lubə ya ngá ə́ ree tḛḛ rɔ-si-tɨ tin. ");
INSERT INTO mge_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Kinə dow uwə njètɔ́gɨ tɔ́-é njim-njim al lé, dowbé à ra ban ɓá à kur mḛḛ kəy-tɨ lə njètɔ́gɨ kin, kdɔ kəə nékingə-é wa? À tɔ́-é njim-njim ɓəy ɓá à kɔw mḛḛ kəy-tɨ kdɔ kəə nékingə-é. ");
INSERT INTO mge_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Dow kɨ́ ore kàdɨ̀-m al lé, to njèkɔsɨ-m kɨ̀ ta ə dow kɨ́ kəw sə-m né kɨ natɨ al kàrè, to njèsane né kɔgɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«Beɓa mꞌidə-si tokɨ, majal-je lay kɨ́ dow isɨ ra, əse takɔbɨ-je lay kɨ́ dow isɨ pa lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é, ngà ta kɔbɨ kɨ́ dow pa kɨ̀ Ndil Lubə lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é al ya sar. ");
INSERT INTO mge_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dow kɨ́ rá-rá kɨ́ pa ta kɨ́ majɨ al dɔ Ngon lə dow-tɨ lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é, ngà dow ya kɨ́ pa ta kɔbɨ kɨ̀ Ndil kɨ́ aa njay lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é dɔkaglo-tɨ kɨ́ ɓone kin al rəm, bore al rəm, ya sartagangɨ.» ");
INSERT INTO mge_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kinə kagɨ majɨ lé, kandɨ-é à majɨ tɔ, ngà kinə kagɨ majɨ al lé, kandɨ-é kàrè à majɨ al ya tɔ. Kdɔ kandɨ kagɨ ɓá dow à gə-né kagɨ. ");
INSERT INTO mge_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sə̰i kɨ́ mḛḛ-si ndul titɨ-na̰ kɨ̀ mḛḛ li pii-je bè kanlé! Sə̰i a pai ta kɨ́ majɨ ndɔ káre tɔ ɓan wa? Kdɔ né-je kɨ́ mən̰ə̰-na̰ mḛḛ dow-tɨ ya ɓá tḛḛ ta-é-tɨ adɨ-é pa. ");
INSERT INTO mge_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dow kɨ́ majɨ lé, né-je kɨ́ majɨ-majɨ kɨ́ uwə mḛḛ-é kinlé ya ɓá à tḛḛ-né. Ə dow kɨ́ majɨ al kàrè né-je kɨ́ majɨ al majɨ al kɨ́ uwə mḛḛ-é kinlé ya à tḛḛ-né tɔ. ");
INSERT INTO mge_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mꞌa kidə-si, ngan ta-je kɨ́ mḛḛ wəy kare lay kɨ́ isɨ tḛḛ ta dow-je-tɨ kinlé, dꞌa kɔr go-é lay ndɔ gangta-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kdɔtalə ta kɨ́ ta-i-tɨ ɓá ꞌa kɔr-né ta dɔ-i-tɨ rəm, ɓá ta kɨ́ ta-i-tɨ ya ta à kuwə-i-né rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dow-je kɨ́ dan-tɨ-je kɨ́ ꞌto njéndó dow-je ndukun, kɨ̀ Parisi-je kɨ́ ná̰-je dꞌun ta dꞌidə Jeju ꞌpanè: «Njèndó dow-je né, jꞌndigɨ kadɨ ꞌra nékɔjɨ káre adɨ jꞌoo.» ");
INSERT INTO mge_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngà Jeju ilə-dé-tɨ panè: «Dow-je kɨ́ ngɔsnè kɨ́ ꞌto njémḛḛndul-je, kɨ̀ njétəl rɔ-dé go ndu Lubə-tɨ al-je, ꞌdəjɨ kadɨ dꞌoo nékɔjɨ! Ngà dow à ra nékɔjɨ kɨ́ rangɨ kadɨ-dé al ngá; ḛ kɨ́ ndɔkɨ tḛḛ dɔ Jonasɨ-tɨ kɨ́ to njèpata kɨ́ ta Lubə-tɨ kin ya asɨ. ");
INSERT INTO mge_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Titɨ kɨ́ ndɔkɨ Jonasɨ ra-né ndɔ mutə mḛḛ kanjɨ-tɨ kɨ́ boy kinlé, Ngon lə dow kàrè à ra ndɔ mutə gin nangɨ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ndɔ gangta-tɨ lé, dow-je kɨ́ Ninibɨ dꞌa ka̰ takəm dow-je-tɨ kɨ́ ngɔsnè kin kdɔ kilə ta dɔ-dé-tɨ. Kdɔ dow-je kɨ́ Ninibɨ lé, lokɨ dꞌoo mbḛ kilə lə Jonasɨ rəmə, ꞌtusɨ panjiyə-dé-je kɨ́ majɨ al dꞌin̰ə kɔgɨ. Ngá kɨ́ ngɔsnè-tɨ kinlé, dow kɨ́ itə Jonasɨ n̰a̰ ya a̰ nè! ");
INSERT INTO mge_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Bè ya tɔ, ndɔ gangta-tɨ lé, ngar kɨ́ dené kɨ́ go lo-tɨ kɨ́ bəə, à ka̰ takəm dow-je-tɨ kɨ́ ngɔsnè kin kdɔ kilə ta dɔ-dé-tɨ. Kdɔ ndɔkɨ ḛ ḭ sɔ̰y dɔnangɨ-tɨ nṵ ya ree oo gosta-je lə Salomɔ̰. Ngà kɨ́ ngɔsnè-tɨ kinlé, dow kɨ́ itə Salomɔ̰ n̰a̰ ya a̰ nè.» ");
INSERT INTO mge_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Lokɨ ndil kɨ́ majɨ al tḛḛ mḛḛ dow-tɨ, ɔw ilə kɨ̀ diləlo kɨ́ tutɨ sangɨ lo kɨ́ kadɨ nꞌisɨ-tɨ nꞌtaa koo ya ngà, ḛ ingə al lé, ");
INSERT INTO mge_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ḛ panè: “Kəy lə-m kɨ́ mꞌisɨ-tɨ ɓá mꞌtḛḛ lé, mꞌa təl kɔw-tɨ gogɨ.” Lokɨ təl ɔw gogɨ rəmə, oo kɨ́ mḛḛ kəy lé tò kare ə tokɨ kɔy ndətɨ-ndətɨ rəm, ɓá né-je kɨ́ mḛḛ-é-tɨ tokɨ kɔsɨ njɔl-njɔl rəm. ");
INSERT INTO mge_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Beɓa ḛ ɔsɨ təl ɔw sangɨ ndil-je kɨ́ rangɨ siri kɨ́ mḛḛ-dé ndul itə-é ɓəy ɓá ree sə-dé adɨ dꞌandɨ mḛḛ kəy-tɨ lé ə dꞌadɨ to lokisɨ-dé. Gangɨ-é-tɨ kɨ́ gogɨ nè kinlé, kisɨ lə dowbé kin majɨ al n̰a̰ itə kɨ́ kete lé ɓəy. Ə ꞌlə dow-je kɨ́ majɨ al kɨ́ ngɔsnè kanlé kàrè, à tò bè ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lokɨ Jeju a̰ pa ta kɨ̀ kosɨ dow-je ya ɓəy rəmə, kɔ̰-é, kɨ̀ ngankɔ̰-é ꞌree dꞌa̰ ta-é-tɨ ə ꞌsangɨ kadɨ dꞌingə-é ꞌpa siə ta. ");
INSERT INTO mge_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ngá ɓá dow madɨ idə-é panè: «Yən, kɔ̰-i, kɨ̀ ngankɔ̰-i-je dꞌa̰ ndaa-tɨ nɔ̰ɔ̰, ə́ ꞌsangɨ kadɨ ꞌpa sə-i ta.» ");
INSERT INTO mge_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ngà Jeju təl ilə-é-tɨ panè: «Ná̰-je ɓá ꞌto kɔ̰-m-je kɨ̀ ngankɔ̰-m-je wa?» ");
INSERT INTO mge_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Beɓa Jeju ulə ji-é dɔ njéndó né-je-tɨ liə ɓá panè: «Yən, kɔ̰-m-je kɨ̀ ngankɔ̰-m-je ɓá dꞌisɨ tin. ");
INSERT INTO mge_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kdɔ dow kɨ́ ra né kɨ́ mḛḛ Bɔbɨ-m kɨ́ dɔra̰-tɨ ndigɨ kin ɓá to ngonkɔ̰-m, əse kɔ̰nan-m, əse to kɔ̰-m.» ");
INSERT INTO mge_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ndɔ-é-tɨ kinlé ya, Jeju tḛḛ kəy, ɔw isɨ kàdɨ̀ babo-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌree dꞌilə-na̰ ꞌgəə dɔ-é sipɨ, adɨ ḛ al isɨ mḛḛ tò-tɨ. Ngà dḛ ɓá dꞌa̰ ngangɨ ba-tɨ ɗingɨ-ɗingɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jeju pa sə-dé ta n̰a̰ kɨ̀ gosta-je panè: «Njèndɔr, ɔw kdɔ kilə ko. ");
INSERT INTO mge_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lokɨ a̰ ilə ko lé, ka̰a̰ né kɨ́ dan-tɨ-je tusɨ dɔ rəbɨ-tɨ adɨ yəl-je ꞌree ꞌtú lə̰́-lə̰́. ");
INSERT INTO mge_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka̰a̰ né kɨ́ ná̰-je tusɨ dɔ ər-je-tɨ, adɨ lo kadɨ ingə nangɨ kɨ́ asɨ kadɨ ulə njirə-é-tɨ goto. Ngà rəmə kubə ɓá ubə kalangɨ, kdɔ nangɨ ndəə dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lokɨ kàdɨ̀ ɔsɨ rəmə, ngan ko-je kinlé ndole. Go-tɨ rəmə, tutɨ kurum, kdɔ njirə-é ɔw nangɨ n̰a̰ al. ");
INSERT INTO mge_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka̰a̰ né kɨ́ dan-tɨ-je tusɨ dan kun-je-tɨ, adɨ kun tɔgɨ ə ɔ̰̀ rɔ dɔ-tɨ gə́gə́gə́. ");
INSERT INTO mge_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngà ka̰a̰ né kɨ́ ná̰-je tusɨ nangɨ-tɨ kɨ́ majɨ, adɨ ɔr dɔ-é. Beɓa dɔ-é kɨ́ dan-tɨ-je ka̰a̰-é ra-tɨ ɓu-je, ḛ kɨ́ ka̰a̰-é ra-tɨ kɔrmɛkḛ-je, ḛ kɨ́ ra-tɨ kɔrmutə-je.» ");
INSERT INTO mge_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jeju təl ilə dɔ-tɨ ɓəy panè: «Dow kɨ́ mbi-é tò kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé!» ");
INSERT INTO mge_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Njéndó né-je lə Jeju ꞌree rɔ-é-tɨ ꞌdəjɨ-é ꞌpanè: «Kdɔ ri ɓá ꞌpa sə-dé ta kɨ̀ gosta-je wa?» ");
INSERT INTO mge_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jeju təl ilə-dé-tɨ panè: «Kdɔtalə sə̰i lé, né-je kɨ́ tò lo ɓɔyɔ-é-tɨ sɔbɨ dɔ kɔ̰ɓe kɨ́ dɔra̰-tɨ lé tokɨ tḛḛ kɨ̀ dɔ-é kadɨ ꞌgəi, ngà dḛ lé, tokɨ tḛḛ kɨ̀ dɔ-é kadɨ-dé al. ");
INSERT INTO mge_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kdɔ dow kɨ́ né tò ji-é-tɨ ɓá dꞌa kadɨ-é kɨ́ rangɨ dɔ-tɨ, kadɨ isɨ dan majɨ-tɨ mburukɨ-mburukɨ. Ngà dow kɨ́ né liə goto lé, ḛ kɨ́ ji-é-tɨ ya kàrè dꞌa taa. ");
INSERT INTO mge_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Beɓa mꞌidə-dé-né ta kɨ̀ gosta, kdɔ dꞌoo lo kɨ koo ndə̰ bè ya ɓɨ dꞌoo né al rəm, ɓá ta kàrè dꞌoo kɨ koo bè ya ɓɨ ꞌgə mḛḛ-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Beɓa ta kɨ́ Ejay, njèpata kɨ́ ta Lubə-tɨ pa lé, né-é ra né dɔ-dé-tɨ. Lubə panè: “Dꞌa koo ta majɨ ya, ngà dꞌa ꞌgə mḛḛ-é al, Dꞌa koo lo majɨ ya, ngà dꞌa koo né al. ");
INSERT INTO mge_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ooi gin dow-je kanlé ꞌto njémḛḛnga̰-je, ꞌTɔsɨ mbi-dé kə́-kə́ ꞌtɔ́ nè mbi-dé à kḭ koo ta rəm, nè dꞌa kḭ gə né; ꞌNibɨ kəm-dé jibɨ-jibɨ, nè kəm-dé à kḭ koo lo rəm, Nè mbi-dé à kḭ koo ta rəm, nè dꞌa kḭ gə né, Rəmə dꞌa kḭ kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ kadɨ mꞌḭ mꞌajɨ-dé.” ");
INSERT INTO mge_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ngà sə̰i lé, ꞌtoi njénékumə̰-je, kdɔ kəm-si oo lo majɨ rəm, mbi-si kàrè oo ta majɨ rəm tɔ! ");
INSERT INTO mge_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ njépata-je kɨ́ ta Lubə-tɨ n̰a̰, kɨ̀ njéra né-je kɨ́ njururu n̰a̰ ya, ɓo koo né-je kɨ́ sə̰i ooi kin ra-dé ya, ngà dꞌoo al, ɓo koo ta-je kɨ́ sə̰i ooi kin ra-dé ya, ngà dꞌoo al.» ");
INSERT INTO mge_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Sə̰i lé, ꞌyəli mbi-si ooi-né mḛḛ gosta kɨ́ sɔbɨ dɔ njèkilə ko lé. ");
INSERT INTO mge_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Dɔ rəbɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dow kɨ́ oo ta kɨ́ dɔ kɔ̰ɓe-tɨ lə Lubə ya, ngà gə mḛḛ-é al, rəmə Njèmḛḛndul ree ɔr ta kɨ́ ꞌdubɨ mḛḛ-é-tɨ lé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nangɨ ər kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dow kɨ́ oo ta lə Lubə rəmə taa kalangɨ kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngà ta lé ɓá ulə njirə mḛḛ-é-tɨ al; adɨ ḛ a̰ dɔ-tɨ kaglo n̰a̰ al. Beɓa lokɨ kɔ̰̀-je kɨ́ dum natɨ əse kulə kəm ndoo kdɔ ta lə Lubə tḛḛ dɔ-é-tɨ rəmə, kalangɨ bè ya ḛ tusɨ kadmḛḛ liə in̰ə kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dan kun-je kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dow kɨ́ oo ta lə Lubə ya, ngà mḛḛ ka̰ kə́kə́kə́ kdɔ né-je kɨ́ dɔnangɨ-tɨ nè, kɨ̀ ɓo nékingə-je utɨ dɔ ta kɨ́ oo lé, adɨ kandɨ-é goto. ");
INSERT INTO mge_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Rəmə, nangɨ kɨ́ majɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dow kɨ́ oo ta lə Lubə ə gə mḛḛ-é, adɨ kandɨ-é tò; ḛ kɨ́ ka̰a̰-é ra-tɨ ɓu-je, ḛ kɨ́ ka̰a̰-é ra-tɨ kɔrmɛkḛ-je, ḛ kɨ́ ra-tɨ kɔrmutə-je. ");
INSERT INTO mge_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeju pa sə-dé gosta kɨ́ rangɨ ɓəy panè: Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə dow kɨ́ dubɨ ko né kɨ́ majɨ mḛḛ ndɔr-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Rəmə ndɔɔ, lokɨ dow-je ꞌto ɓi lay lé, njèba liə ree dubɨ jə dan ko né-tɨ kɨ́ majɨ kɨ́ ḛ dubɨ lé, ə ɔtɨ ɔw. ");
INSERT INTO mge_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lokɨ ko ubə tɔgɨ, adɨ ɔr dɔ-é lé, jə lé kàrè ɔr dɔ-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Beɓa njérakullə-je lə njèkəy lé ꞌree dꞌidə-é ꞌpanè: «ꞌƁa-ji, to ko né kɨ́ majɨ ɓá i dubɨ mḛḛ ndɔr-tɨ lə-i ya al wa?» Ngà jə kin ḭ rá tɔ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Beɓa ḛ ilə-dé-tɨ panè: «To njèba ə́ ra-né tin.» Ngá ɓá njérakullə-je ꞌdəjɨ-é ꞌpanè: «ꞌNdigɨ kadɨ jꞌɔw jꞌrə̰y jə lé kɔgɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngà ḛ panè: «Bè al, kdɔ kinə kadɨ ꞌrəyḭ jə rəmə a kḭ ꞌrəyḭ-dé kɨ̀ ko natɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ə́ in̰əi-dé adɨ ꞌtɔgɨ natɨ sar ndɔ kijə ko-tɨ. Ndɔ-é-tɨ kin ɓá mꞌa kidə njékijəko-je panè: “ꞌTɔri jə-je ya kete, ə ꞌtɔ́i njɨr-njɨr kadɨ uləi pər, ngá tá je ꞌkəwi ko lə-m dama̰.”» ");
INSERT INTO mge_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeju tḛḛ kɨ̀ gosta kɨ́ rangɨ ɓəy panè: Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə ka̰a̰ kɔl kɨ́ dow madɨ un dubɨ mḛḛ ndɔr-tɨ liə kin bè. ");
INSERT INTO mge_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka̰a̰ kɔl lé ɓá, to ka̰a̰ kagɨ kɨ́ tò ngon-é itə ka̰a̰ kagɨ-je lay, ngà lo kɨ́ ubə tɔgɨ rəmə to kagɨ kɨ́ boy itə kagɨ-je lay kɨ́ mḛḛ ndɔr-tɨ, adɨ yəl-je kɨ́ ꞌnar taá ꞌree ꞌra kəy-dé balkəm-é-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jeju pa sə-dé gosta kɨ́ rangɨ ya ɓəy panè: «Kɔ̰ɓe kɨ́ dɔra̰-tɨ lé titɨ-na̰ kɨ̀ əm kɨ́ dené káre bè un lɔ̰y-né ndujɨ kɨ́ ꞌmbɔjɨ mḛḛ kee mutə, adɨ ndujɨ kɨ́ lɔ̰y lay ya ḭ kin bè.» ");
INSERT INTO mge_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ta-je kin lay ya Jeju idə kosɨ dow-je kɨ̀ gosta. Ta kɨ́ kadɨ ḛ pa kɨ̀ gosta al ya goto. ");
INSERT INTO mge_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","To bè kadɨ ta-je kɨ́ njèpata kɨ́ ta Lubə-tɨ pa kin né-é ra né. Njèpata kɨ́ ta Lubə-tɨ pa panè: «Mꞌa tḛḛ ta-m kadɨ mꞌpa gosta-je, Mꞌa kilə mbḛ né-je kɨ́ tò lo ɓɔyɔ-é-tɨ lo kində gin dɔnangɨ-tɨ nṵ.» ");
INSERT INTO mge_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jeju in̰ə kosɨ dow-je ə ree ɓee. Lokɨ ree ɓee lé, njéndó né-je liə ꞌree rɔ-é-tɨ, ꞌdəjɨ-é ꞌpanè: «ꞌƆr-ji mḛḛ gosta kɨ́ dɔ jə-tɨ kɨ́ a̰ mḛḛ ndɔr-tɨ lé adɨ jꞌoo.» ");
INSERT INTO mge_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Beɓa Jeju idə-dé panè: «Dow kɨ́ njèdubɨ ko né kɨ́ majɨ kinlé, to Ngon lə dow; ");
INSERT INTO mge_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ndɔr lé, to dɔnangɨ; ə ko né kɨ́ majɨ, to dow-je kɨ́ kɔ̰ɓe-tɨ lə Lubə; jə lé to dḛ kɨ́ dꞌun go Njèmḛḛndul. ");
INSERT INTO mge_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Njèba kɨ́ njèdubɨ jə lé, to Sú; na̰y kijə ko lé, to dɔbəy ndɔ; ə njékijəko-je, ꞌto malayka-je tɔ. ");
INSERT INTO mge_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Titɨ kɨ́ ꞌtɔr-né jə dꞌungɨ pərəə lé, dɔbəy ndɔ-tɨ ya kàrè à to bè tɔ: ");
INSERT INTO mge_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngon lə dow, à kulə malayka-je liə kadɨ ꞌtubə dow-je lay kɨ́ njéra madɨ-dé-je kadɨ dꞌusɨ mḛḛ majal-tɨ, kɨ̀ dow-je kɨ́ njéramajal-je kɔ̰ɓe-tɨ liə kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Malayka-je dꞌa kungɨ-dé dan pər-tɨ kɨ́ dum pa ta-é, kɨ́ to lo nɔ̰ rəm, lo kɨ́ dꞌa kuso ngangɨ-dé titɨ məgəgə-məgəgə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngà njéra né-je kɨ́ njururu rəmə, rɔ-dé à ndógɨ titɨ-na̰ kɨ̀ kàdɨ̀ bè mḛḛ kɔ̰ɓe-tɨ lə Bɔbɨ-dé. «Dow kɨ́ mbi-é tò kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé!» ");
INSERT INTO mge_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə nékingə kɨ́ ꞌɓɔyɔ mḛḛ ndɔr-tɨ, ɓá dow madɨ ɔw tḛḛ dɔ-tɨ kin bè. Dowbé kinlé, un ɔw ɓɔyɔ rangɨ ɓəy, rəmə rɔ-é nəl-é n̰a̰, adɨ ɔw ndogɨ né kingə-é lay, ɓá in̰ə la-é ree ndogɨ-né ndɔr kinlé. ");
INSERT INTO mge_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə njèra gatɨ kɨ́ isɨ sangɨ mədɨ kɔsɨ kɨ́ ndole kin bè. ");
INSERT INTO mge_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lokɨ ingə ḛ kɨ́ gatɨ-é n̰a̰ lé, ḛ təl ɔw ndogɨ nékingə-é lay, ɓá in̰ə la-é ree ndogɨ-né mədɨ kɔsɨ kɨ́ káre kinlé.» ");
INSERT INTO mge_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə burə kɨ́ dow ilə baa rəmə uwə-né kanjɨ-je kɨ́ gay-gay kin bè. ");
INSERT INTO mge_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lokɨ burə kin rusɨ lé, mbɔw ndɔr ree-né ngangɨ ba-tɨ, isɨ nangɨ, tɔr kanjɨ-je kɨ́ majɨ-majɨ ungɨ mḛḛ ꞌsḛngɨ-tɨ, ɓá in̰ə dḛ kɨ́ dꞌasɨ ná̰y al ungɨ-dé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dɔbəy ndɔ-tɨ lé, à to titɨ-na̰ bè ya tɔ: Malayka-je dꞌa ree kɔr kəm dow-je kɨ́ njéra né kɨ́ njururu al kɨ̀ njéra né kɨ́ njururu gay-gay. ");
INSERT INTO mge_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dꞌa kungɨ dow-je kɨ́ njéra né kɨ́ njururu al dan pər-tɨ, lo nɔ̰-tɨ, kɨ́ to lokɨ dꞌa kuso ngangɨ-dé titɨ məgəgə-məgəgə. ");
INSERT INTO mge_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Beɓa Jeju dəjɨ njéndó né-je liə panè: «ꞌGəi mḛḛ ta-je kin lay wa?» Dḛ dꞌilə-é-tɨ ꞌpanè: «Oiyo», jꞌgə. ");
INSERT INTO mge_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rəmə Jeju idə-dé panè: «To bè ya tɔ, njèndó dow-je ndukun lə Lubə kɨ́ təl njètaa néndó kɨ́ dɔ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ lé, titɨ-na̰ kɨ̀ njèkəy kɨ́ ingə né-je kɨ́ sigɨ ɓá ore natɨ kɨ̀ né-je kɨ́ low kɨ́ lo ngəm né-tɨ liə ɓá ra-né kullə.» ");
INSERT INTO mge_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lokɨ Jeju pa gosta-je kin adɨ gin-é gangɨ rəmə, ḛ ɔtɨ rangɨ lo kɨ́ a̰-tɨ lé ");
INSERT INTO mge_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ɔw ɓebo-tɨ kɨ́ ḛ tɔgɨ-tɨ ə ndó né dow-je mḛḛ kəykəwna̰-tɨ lə jipɨ-je. Néndó liə ɔr ndil-dé adɨ ꞌpanè: «Kay! Gosta-je, kɨ̀ nékɔjɨ-je kinlé ḭ-né rá-rá ya wa? ");
INSERT INTO mge_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","To ngon lə kɔdɨ kijəkagɨ lé ya al wa? Kɔ̰-é ya ɓá to Mari lé al wa? Ə Jakɨ-je, kɨ̀ Jojepɨ-je kɨ̀ Simɔ̰-je kɨ̀ Jude-je ya ɓá ꞌto ngankɔ̰-é-je al wa? ");
INSERT INTO mge_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ə kɔ̰nan-é-je ya rəm ɓá dꞌisɨ sə-ji nè tɔ tin al wa? Ngà né-je lay kinlé, ḛ ḭ-né rá ya dana̰ wa?» ");
INSERT INTO mge_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Né-je kin ya ra adɨ Jeju təl jigɨ nɔ̰̀-dé-tɨ ɔgɨ-dé kadɨ dꞌadɨ-é mḛḛ-dé. Beɓa ḛ idə-dé panè: «Njèpata kɨ́ ta Lubə-tɨ lé, dow-je kɨ́ mḛḛ ɓekojɨ-é-tɨ, kɨ̀ mḛḛ kəy-tɨ liə ya par dꞌa nədɨ-é.» ");
INSERT INTO mge_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Beɓa Jeju ra nékɔjɨ-je tin n̰a̰ al, kdɔtalə mḛḛnga̰ lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dɔkaglo-é-tɨ kinlé ngar Erodɨ kɨ́ to njèkɔ̰ɓe kɨ́ dɔnangɨ Galile-tɨ oo poy riɓa lə Jeju. ");
INSERT INTO mge_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Beɓa ḛ idə njérakullə-je liə panè: «To Ja̰ kɨ́ njèra dow-je batḛm ɓá tɔsɨ ndəl ində lo tḛḛ! Gin-é kin ɓá ḛ ɔw-né kɨ̀ tɔ́gɨ adɨ ra-né nékɔjɨ-je kin.» ");
INSERT INTO mge_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kdɔ ndɔkɨ Erodɨ adɨ dꞌuwə Ja̰ ꞌdɔɔ-é kɨ̀ kullə gindingɨ, dꞌilə-é dangay-tɨ, kdɔtalə Erodɨ dḛ kɨ̀ Pilipɨ ꞌto ngankɔ̰-na̰-je, ya rəmə Erodɨ təl taa Erodiadɨ, kɨ́ ne Pilipɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ɓa Ja̰ idə-é panè: «Taa kɨ́ ꞌtaa Erodiadɨ kinlé to tó-é al.» ");
INSERT INTO mge_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Beɓa Erodɨ lé ndigɨ tɔl Ja̰, ngà ḛ ɓəl kosɨ dow-je, kdɔ dḛ ꞌgə kɨ́ Ja̰ lé to njèpata kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Beɓa ndɔ ra na̰y kojɨ Erodɨ-tɨ lé, ngon lə Erodiadɨ kɨ́ dené, tḛḛ ndam nɔ̰̀ dow-je-tɨ kɨ́ ꞌɓa-dé lo nékuso-tɨ, adɨ nəl Erodɨ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Beɓa Erodɨ un mindɨ-é ə ubɨ rɔ-é dɔ-tɨ panè: Né lay kɨ́ ꞌdəjɨ-m ya ə mꞌa kadɨ-i. ");
INSERT INTO mge_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Rəmə Erodiadɨ sulə ngon-é lé, adɨ-é panè: «ꞌIlə dɔ Ja̰ kɨ́ njèra dow-je batḛm lé, mḛḛ supra-tɨ tajinatɨ nè ya adɨ-m!» ");
INSERT INTO mge_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rɔ ngar nəl-é al ya, ngà kdɔ kubɨ kɨ́ ḛ ubɨ rɔ-é rəm, kdɔ takəm kosɨ dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ rəm kinlé ya, ra adɨ ḛ un-né ndu kadɨ dꞌadɨ-é-né dɔ Ja̰ lé. ");
INSERT INTO mge_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Beɓa ngar ulə dow kəy dangay-tɨ adɨ-é gangɨ dɔ Ja̰ lé. ");
INSERT INTO mge_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ꞌRee kɨ̀ dɔ Ja̰ mḛḛ supra-tɨ dꞌadɨ ngon kɨ́ dené kinlé, ə ḛ ɔw-né adɨ kɔ̰-é. ");
INSERT INTO mge_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Go-tɨ, njéndó né-je lə Ja̰ ꞌree dꞌun nin-é dꞌɔw ꞌdubɨ, ngá ɓá dꞌɔw dꞌɔr poy-é dꞌadɨ Jeju oo. ");
INSERT INTO mge_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lokɨ Jeju oo ta kinlé, ḛ al mḛḛ tò-tɨ ɔr rɔ-é ngərəngɨ kɨ̀ kár-é diləlo-tɨ. Beɓa kosɨ dow-je dꞌoo ta-é rəmə, dꞌḭ kɨ̀ ɓebo-je kɨ́ gay-gay dꞌɔw kɨ̀ nja-dé go-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ngà lokɨ Jeju ur nangɨ mḛḛ tò-tɨ ɓá oo kosɨ dow-je kɨ́ ꞌtò nduy-nduy kinlé rəmə, ta ɔ̰̀ mḛḛ-é kdɔ ta lə-dé, ə adɨ lapiya njémɔ̰y-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lokɨ ndɔ isɨ il lé, njéndó né-je dꞌɔw rɔ Jeju-tɨ dꞌidə-é ꞌpanè: «Lokɨ jꞌa̰i-tɨ kinlé to diləlo rəm, ɓá kàdɨ̀ kàrè ɔw kɨ dɔ kur-tɨ rəm, ə́n ə́ ꞌɔsɨ kosɨ dow-je kan adɨ dꞌɔw nganɓe-je-tɨ ꞌndogɨ né dꞌuso.» ");
INSERT INTO mge_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jeju ilə-dé-tɨ panè: «Kadɨ dꞌɔw rangɨ lé, to tó-é al, ə́ sə̰i ya adi-dé né dꞌuso!» ");
INSERT INTO mge_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngà dḛ dꞌidə Jeju ꞌpanè: «Jꞌɔw kɨ̀ mbə̀ mḭ kɨ̀ kanjɨ joo-rè ya par.» ");
INSERT INTO mge_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Beɓa Jeju idə-dé panè: «ꞌReei-né adi mḭ.» ");
INSERT INTO mge_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngá ɓá Jeju un ndu adɨ kosɨ dow-je lé dꞌisɨ nangɨ dɔ wale-je-tɨ. Jeju ɔy mbə̀ kɨ́ mḭ kɨ̀ kanjɨ kɨ́ joo lé, ɓá un kəm-é kɨ taá dɔra̰-tɨ ra oiyo Lubə kete ɓá gángɨ mbə̀ lé adɨ njéndó né-je, ə njéndó né-je ꞌtaa ꞌləbɨ kosɨ dow-je tɔ. ");
INSERT INTO mge_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dow-je lay ya dꞌuso né ꞌndan ndə̰́-ndə̰́, adɨ dɔdum-é-je kɨ́ nà̰y ya dꞌɔy rusɨ kàrè dɔgɨ gidɨ-é joo ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dow-je kɨ́ dꞌuso né kinlé, dingəm-je dꞌa ra ɓudɔgɨ lo mḭ je bè; dené-je kɨ̀ ngan-je rəmə tokɨ tidə-dé al. ");
INSERT INTO mge_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lo-é-tɨ lé ya, Jeju ɔsɨ njéndó né-je liə kadɨ dꞌal mḛḛ tò-tɨ, ꞌgangɨ babo dꞌɔw turə kete nɔ̰̀-é-tɨ, ngà ḛ ɓá a̰ ɔsɨ kosɨ dow-je kadɨ ꞌtəl. ");
INSERT INTO mge_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lokɨ Jeju ɔsɨ-dé adɨ dꞌɔw rəmə, ḛ ɔtɨ ɔw al dɔ mbal-tɨ, ɔr rɔ-é kɨ̀ kár-é kdɔ pa ta kɨ̀ Bɔbɨ-é. Kàdɨ̀ ur dɔ-é-tɨ lo-é-tɨ kin kɨ̀ kár-é. ");
INSERT INTO mge_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lokɨ tò a̰ dan ba-tɨ dana̰ bapɨ ya ɓəy rəmə, yə́l tilə kəm tò, adɨ pungum man ɔsɨ tò kɨ gogɨ-gogɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taginlo-tɨ lé, Jeju njiyə dɔ man babo-tɨ, isɨ ɔw kɨ rɔ njéndó né-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngà lokɨ njéndó né-je dꞌoo-é ɔw njiyə dɔ man babo-tɨ lé, ꞌɓəl rəm, dɔ-dé majɨ al, adɨ ꞌpanè: To «ꞌmə̰́ dow!» Adɨ ꞌɓəl ə ꞌtur kɔɔl. ");
INSERT INTO mge_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngà tajinatɨ nè bè ya, Jeju idə-dé panè: «Adi mḛḛ-si usɨ nangɨ, to ma̰ ɓəy, ə́ ꞌɓəli al!» ");
INSERT INTO mge_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bè ɓəy ɓá Piyər panè: «ꞌƁaɓe, kinə to ḭ ya rəmə, ꞌun ndu-i adɨ mꞌnjiyə dɔ man-tɨ mꞌɔw rɔ-i-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ə Jeju təl ilə-é-tɨ panè: «ꞌRee!» Beɓa Piyər ḭ mḛḛ tò-tɨ ur dɔ man-tɨ njiyə ɔw kɨ rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngà lokɨ Piyər oo yə́l kɨ́ isɨ ulə dɔ man-tɨ mbḭ-mbḭ lé, ɓəl ra-é adɨ isɨ nduy, adɨ nɔ̰ panè: «ꞌƁaɓe, ꞌajɨ-m ɓoo!» ");
INSERT INTO mge_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tajinatɨ nè bè ya, Jeju ulə ji-é uwə-é-né ə idə-é, panè: «ꞌTo dow kɨ́ kadmḛḛ lə-i asɨ al. Kdɔ ri ɓá i ꞌtadɨ?» ");
INSERT INTO mge_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lokɨ dḛ dꞌal mḛḛ tò-tɨ rəmə gin yə́l lé gangɨ ɗəsɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Beɓa njéndó né-je kɨ́ dꞌisɨ mḛḛ tò-tɨ lé dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀-é-tɨ ɓá ꞌpanè: «I lé, ꞌto Ngon lə Lubə ya tɔgrɔ-tɨ!» ");
INSERT INTO mge_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lokɨ Jeju kɨ̀ njéndó né-je liə dꞌində babo ꞌgangɨ, ꞌtḛḛ dɔnangɨ Jenejarɛtɨ-tɨ lé, ");
INSERT INTO mge_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","dow-je kɨ́ lo-é-tɨ ꞌgə Jeju, adɨ dꞌulə kulə mḛḛ ɓe-je-tɨ go lo-je-tɨ kɨ́ tin kin lay, adɨ dow-je ꞌree kɨ̀ njémɔ̰y-je lay rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dḛ ꞌra ndoo ta-é-tɨ kadɨ in̰ə-dé adɨ nꞌɔdi rɔ takubɨ liə ya par rəmə, nꞌa kingəi lapiya. Beɓa dow-je lay kɨ́ dꞌɔdɨ takubɨ liə lé, dꞌingə lapiya ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Beɓa Parisi-je kɨ́ dan-tɨ-je, kɨ̀ dow-je kɨ́ ná̰-je kɨ́ ꞌto njéndó dow-je ndukun-je dꞌḭ Jorijalḛm, ꞌree dꞌingə Jeju ꞌdəjɨ-é ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ban ɓá njéndó né-je lə-i ꞌtəl rɔ-dé go nékoɓe-tɨ lə ka-ji-je al wa? ꞌOo, dḛ ꞌtogɨ ji-dé al ya dꞌuso-né né.» ");
INSERT INTO mge_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Beɓa Jeju ilə-dé-tɨ panè: «Ngà sə̰i, ban ɓá ꞌtəli rɔ-si go ndukun-tɨ lə Lubə al, kdɔtalə nékoɓe lə-si wa? ");
INSERT INTO mge_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sə̰i ꞌgəi kɨ́ Lubə panè: “ꞌTətɨ kagɨ bɔbɨ-i kɨ̀ kɔ̰-i.” Ḛ pa ɓəy panè: “Dow kɨ́ pa ta kɨ́ majɨ al dɔ bɔbɨ-é-tɨ əse dɔ kɔ̰-é-tɨ lé kadɨ tokɨ tɔl dowbé kɔgɨ.”» ");
INSERT INTO mge_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngà sə̰i ꞌpainè: Kinə dow pa kɨ̀ bɔbɨ-é əse kɔ̰-é panè: «Né kɨ́ mꞌa ra-né sə-i lé, ma̰ mꞌun mꞌadɨ Lubə kadkare-tɨ rəmə» ");
INSERT INTO mge_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","dowbé kinlé ɔw ndoo tətɨ kagɨ bɔbɨ-é əse kɔ̰-é al ngá. ꞌRai bè kinlé, to ta lə Lubə ɓá sə̰i bujuri kɔgɨ kdɔ nékoɓe lə-si! ");
INSERT INTO mge_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sə̰i lé, ꞌtoi njékədkəm dow-je! Ta kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ pa sɔbɨ-né dɔ-si lé to ta kɨ́ tɔgrɔ-tɨ ya, ḛ panè: ");
INSERT INTO mge_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Gin dow-je kinlé ꞌtətɨ kagɨ-m ndaá ta-dé-tɨ nè, ngà mḛḛ-dé tò gay sə-m. ");
INSERT INTO mge_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pole kɨ́ dḛ ꞌpol-m kàrè to pole kɨ́ mḛḛ wəy kare, kdɔ né-je kɨ́ dꞌisɨ ꞌndó dow-je lé, to ndukun-je lə dow-je.» ");
INSERT INTO mge_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jeju ɓa kosɨ dow-je kɨ rɔ-é-tɨ ə idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","«Ooi ta kin kdɔ kadɨ ꞌgəi mḛḛ-é majɨ. Né kɨ́ ḭ ndaa-tɨ ɔw ta dow-tɨ, ɓá à ra kadɨ dowbé təl dow kɨ́ tò n̰ḛ takəm Lubə-tɨ al. Ngà né kɨ́ tḛḛ ta dow-tɨ kɨ ndaa-tɨ ɓá à ra kadɨ dowbé təl dow kɨ́ tò n̰ḛ takəm Lubə-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Beɓa njéndó né-je liə dꞌidə-é ꞌpanè: «Se i gə kɨ́ ta kɨ́ i ꞌpa lé, tugə Parisi-je jigɨ-tɨ ya wa?» ");
INSERT INTO mge_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jeju ilə-dé-tɨ panè: «Kagɨ-je lay ya kɨ́ to Bɔbɨ-m kɨ́ dɔra̰-tɨ ɓá ma̰-dé al lé, dꞌa kuwə-dé kɔr-dé kɔgɨ kɨ̀ njirə-dé burə. ");
INSERT INTO mge_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","In̰əi-dé, dḛ ꞌto njékəmtɔ-je kɨ́ njéndɔr njékəmtɔ madɨ-dé-je. Kinə njèkəmtɔ ndɔr njèkəmtɔ madɨ-é lé, dḛ joo lay ya dꞌa kungɨ-na̰ ɓe-tɨ lɔ́tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyər un ta idə-é panè: «ꞌƆr mḛḛ gosta kinlé adɨ jꞌoo.» ");
INSERT INTO mge_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jeju idə-dé panè: «Sə̰i lé ya kàrè négə nal-si bè ɓəy tɔ wa? ");
INSERT INTO mge_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sə̰i ꞌgəi kɨ́ né ya kɨ́ ḭ ndaa-tɨ ɔw ta dow-tɨ lé, dəə ɔw mḛḛ-é-tɨ kadɨ à kɔw-né ta wale-tɨ ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngà né kɨ́ tḛḛ ta dow-tɨ lé, ḭ mḛḛ-é-tɨ kəy, ḛ ɓá à ra kadɨ dow təl-né né kɨ́ tò n̰ḛ takəm Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kdɔ tagɨr-je kɨ́ majɨ al kɨ́ tokɨ tɔl dow-je, kɨ̀ ra kaya-je, kɨ̀ kin̰ə ne-i əse ngɔbɨ-i kɔw sangɨ dow kɨ́ rangɨ-je, kɨ̀ ɓogɨ-je, kɨ̀ kulə ta ndil dow-tɨ-je, kɨ̀ tətɨ ta kɨ́ ndángɨ-je kinlé, ḭ mḛḛ dow-tɨ kəy. ");
INSERT INTO mge_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Né-je kin ɓá à ra dow kadɨ təl-né né kɨ́ tò n̰ḛ takəm Lubə-tɨ, ɓɨ togɨ ji al ya kuso-né né kin ɓá à ra kadɨ dow təl dow kɨ́ tò n̰ḛ takəm Lubə-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lokɨ Jeju ɔr rɔ-é ɔw ngɔsi kɨ dɔnangɨ Tir-tɨ kɨ̀ dɔnangɨ Sidɔ̰-tɨ, ");
INSERT INTO mge_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","rəmə dené kɨ́ Kana̰-tɨ, ḭ titɨ nɔ̰ɔ̰, ree nɔ̰ ta Jeju-tɨ ɓərəngɨ-ɓərəngɨ panè: «ꞌƁaɓe, ngonka Dabidɨ, ꞌoo kəmtondoo lə-m! Ndil-je kɨ́ majɨ al ꞌra ngon-m kɨ́ dené n̰a̰!» ");
INSERT INTO mge_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngà Jeju ilə-é-tɨ al. Rəmə njéndó né-je liə dꞌidə-é ꞌpanè: «ꞌTubə dené kinlé kɔgɨ. Kdɔtalə ɔw tur kəə go-ji-tɨ taá-taá.» ");
INSERT INTO mge_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jeju idə-é panè: «Ma̰ lé dꞌulə-m rɔ Israyel-je-tɨ kɨ́ ꞌtitɨ-na̰ kɨ̀ batɨ-je kɨ́ ꞌndəm bè kin ya par.» ");
INSERT INTO mge_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Beɓa dené lé ree səbɨ takəm-é nangɨ nɔ̰̀-é-tɨ ɓá panè: «ꞌƁaɓe, ꞌra sə-m!» ");
INSERT INTO mge_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jeju ilə-é-tɨ panè: «Kun nékuso ta ngan-je-tɨ kilə kadɨ ngan bisɨ-je lé to né kɨ́ tuwə ra al.» ");
INSERT INTO mge_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Beɓa dené panè: «Tɔgrɔ-tɨ ya ꞌƁaɓe, ngà ngan bisɨ-je lé, dꞌa kuso n̰ɔ̰-n̰ɔ̰ né kɨ́ tusɨ gin tablə kuso né-tɨ lə ɓa-dé ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Beɓa Jeju panè: «Bayawə́ə dené! Kadmḛḛ lə-i boy n̰a̰! Kadɨ Lubə ra sə-i titɨ kɨ́ i dəjɨ-né!» Rəmə lo-é-tɨ nɔ̰ɔ̰ ya ngon kɨ́ dené lé ingə lapiya. ");
INSERT INTO mge_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Beɓa Jeju ḭ lo-é-tɨ nɔ̰ɔ̰ ɔw ta babo-tɨ kɨ́ Galile, al isɨ dɔ mbal-tɨ taá. ");
INSERT INTO mge_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Rəmə kosɨ dow-je n̰a̰ ꞌree kɨ̀ njémətɨ-je kɨ̀ njékəmtɔ-je, kɨ̀ njémbitɔ-je, kɨ̀ dow-je kɨ́ rɔ-dé oy mburukɨ-mburukɨ, kɨ̀ njémɔ̰y-je kɨ́ gay-gay dꞌungɨ-dé nja Jeju-tɨ dꞌadɨ adɨ-dé lapiya. ");
INSERT INTO mge_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lokɨ kosɨ dow-je dꞌoo kɨ́ njémbitɔ-je kàrè ꞌpa ta rəm, njérɔkoy mburukɨ-mburukɨ-je kàrè dꞌingə lapiya rəm njémətɨ-je ꞌnjiyə rəm, njékəmtɔ-je kàrè dꞌoo lo rəm lé, ndil-dé ɔr wutɨ adɨ dḛ dꞌɔsɨ gajɨ Lubə lə Israyel-je. ");
INSERT INTO mge_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Beɓa Jeju ɓa njéndó né-je liə idə-dé panè: «Ta ɔ̰̀ mḛḛ-m kdɔ kosɨ dow-je kan! Kdɔ dḛ ꞌra ndɔ mutə sə-m ɓone ya, ngà né kɨ́ kadɨ dꞌuso goto. Adɨ ma̰ mꞌndigɨ kin̰ə-dé kadɨ dꞌɔw kɨ̀ mḛḛ-dé ɓo al, nè dꞌa kḭ gudɨ rəbəə.» ");
INSERT INTO mge_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ngá ɓá njéndó né-je ꞌpanè: «Jꞌa kḭ kɨ̀ mbə̀ rá diləlo-tɨ nè kdɔ kadɨ jꞌadɨ kosɨ dow-je kɨ́ n̰a̰ kan dꞌuso ꞌndan wa?» ");
INSERT INTO mge_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jeju dəjɨ-dé panè: «Mbə̀ ra kandangɨ ji-si-tɨ wa?» Njéndó né-je dꞌilə-é-tɨ ꞌpanè: «Jꞌɔw kɨ̀ mbə̀ siri, ə ngan kanjɨ sḛ tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jeju un ndu adɨ dow-je dꞌisɨ nangɨ. ");
INSERT INTO mge_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Go-tɨ, ɔy mbə̀ kɨ́ siri kɨ̀ ngan kanjɨ kɨ́ sḛ lé, ra oiyo Lubə, gángɨ dana̰ təl-né adɨ njéndó né-je liə ꞌləbɨ kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dow-je lay ya dꞌuso né ꞌndan ndə̰́-ndə̰́ ɓá dɔdum-é-je nà̰y adɨ dꞌɔy rusɨ jangá siri. ");
INSERT INTO mge_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dow-je lay kɨ́ dꞌuso né lé, dingəm-je dḛ ɓudɔgɨ lo sɔ ə dow tidə dené-je kɨ̀ ngan-je al. ");
INSERT INTO mge_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Go-tɨ, Jeju adɨ kosɨ dow-je dꞌɔw, ɓá ḛ al mḛḛ tò-tɨ ɔw dɔnangɨ-tɨ lə Magadan-je. ");
INSERT INTO mge_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi-je kɨ̀ Sadusi-je ꞌree rɔ Jeju-tɨ kdɔ na̰-é koo ta kɨ́ mḛḛ-é-tɨ adɨ ꞌdəjɨ-é kadɨ ra nékɔjɨ kɨ́ ḭ dɔra̰-tɨ kadɨ dꞌoo. ");
INSERT INTO mge_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jeju ilə-dé-tɨ panè: Kàdɨ̀ ur ə ꞌpainè: «Lo à majɨ, kdɔ dɔra̰ kər wəə.» ");
INSERT INTO mge_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ə ndɔge rəmə sə̰i ꞌpainè: «Ɓone ndi à kədɨ», kdɔ dɔra̰ kər wətɨ-wətɨ. Sə̰i ꞌgəi kɔr gangɨ lo kɨ́ dɔra̰-tɨ majɨ rəmə, asi kɔri gangɨ né-je kɨ́ tɔjɨ kaglo-je kɨ́ ɓone kin al wa? ");
INSERT INTO mge_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dow-je kɨ́ ngɔsnè kɨ́ ꞌto njémḛḛndul-je, kɨ̀ njétəl rɔ-dé go ndu Lubə-tɨ al-je ꞌdəjɨ nékɔjɨ. Ngà dow à ra nékɔjɨ kɨ́ rangɨ kadɨ-dé al ngá; ḛ kɨ́ ndɔkɨ tḛḛ dɔ Jonasɨ-tɨ kin ya asɨ. Go-tɨ, Jeju in̰ə-dé ɔtɨ ɔw lo liə. ");
INSERT INTO mge_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lokɨ njéndó né-je dꞌɔw kɨ̀ kal ba kɔw turə rəmə, mḛḛ-dé oy dɔ mbə̀-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Beɓa Jeju idə-dé panè: «Sə̰i kan! Ooi go rɔ-si majɨ kdɔ əm lə Parisi-je, kɨ̀ Sadusi-je.» ");
INSERT INTO mge_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Njéndó né-je ꞌpa ta mḛḛ-dé-tɨ ꞌpanè: «Jeju pa ta kinlé bè kdɔ mbə̀ kɨ́ mḛḛ-ji oy dɔ-tɨ gogɨ lé.» ");
INSERT INTO mge_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jeju gə tagɨr lə-dé, beɓa idə-dé panè: Sə̰i dow-je kɨ́ kadmḛḛ lə-si tokɨ ndḛ bè kan! Kdɔ ri ə́ ꞌpai ta mḛḛ-si-tɨ ꞌpainè to ta lə mbə̀ kɨ́ goto ji-si-tɨ kin wa? ");
INSERT INTO mge_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sə̰i ꞌgəi al ya ɓəy wa? Se mḛḛ-si ole dɔ mbə̀-tɨ kɨ́ mḭ kɨ́ ndɔkɨ dingəm-je ɓudɔgɨ lo mḭ dꞌuso lé al wa? Se ndɔkɨ ɔyi ndəgɨ-é kàrè kandangɨ wa? ");
INSERT INTO mge_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rəm mbə̀ kɨ́ siri kɨ́ ndɔkɨ dingəm-je ɓudɔgɨ lo sɔ dꞌuso lé kàrè, mḛḛ-si ole dɔ-tɨ al tɔ wa? Se ndɔkɨ ɔyi ndəgɨ-é jangá kandangɨ tɔ wa? ");
INSERT INTO mge_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngà ra ban ɓá mꞌpa sə-si ta mꞌpanè: Ooi go rɔ-si majɨ kdɔ əm lə Parisi-je, kɨ̀ Sadusi-je rəmə sə̰i adi to ta lə mbə̀ ɓá mꞌpa sə-si wa? ");
INSERT INTO mge_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bè ɓəy ɓá njéndó né-je ꞌgə kɨ́ to ta kɨ́ sɔbɨ dɔ əm ra mbə̀ al. Ngà to ta lə néndó lə Parisi-je, kɨ̀ Sadusi-je. ");
INSERT INTO mge_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Go-tɨ, Jeju ɔw tḛḛ dɔnangɨ Sejare-tɨ lə Pilipɨ rəmə dəjɨ njéndó né-je liə panè: «Ta ri ɓá dow-je ꞌpa dɔ Ngon lə dow-tɨ lé wa?» ");
INSERT INTO mge_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Beɓa dḛ ꞌpanè: «Dow-je kɨ́ ná̰-je ꞌpanè: “I ꞌto Ja̰ kɨ́ njèra dow-je batḛm”, ə dḛ kɨ́ dan-tɨ-je ꞌpanè: “I ꞌto Eli”, ə dḛ kɨ́ madɨ-je ꞌpanè: “I ꞌto Jeremi əse i ꞌto kɨ́ káre dan njépata-je kɨ́ ta Lubə-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Go-tɨ, Jeju təl dəjɨ-dé panè: «Ngà kɨ́ go gə-é-tɨ lə-si sə̰i ya bè lé, ma̰ mꞌto ná̰ wa?» ");
INSERT INTO mge_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔ̰ kɨ́ ɓa-é Piyər idə-é panè: «ꞌTo Kristɨ, Ngon lə Lubə kɨ́ njèkisɨ kəm.» ");
INSERT INTO mge_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Beɓa Jeju təl idə Piyər panè: «Simɔ̰ kɨ́ ngon lə Jonasɨ, ꞌto njènékumə̰, kdɔtalə to dow ɓá tḛḛ kɨ̀ dɔ ta kin adɨ-i al. To Bɔbɨ-m kɨ́ isɨ dɔra̰-tɨ ɓá tḛḛ kɨ̀ dɔ ta kinlé adɨ-i tin. ");
INSERT INTO mge_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma̰ mꞌidə-i mꞌpanè: “ꞌTo Piyər (kɔr mḛḛ-é to ər) ə dɔ ər-tɨ kinlé ɓá mꞌa kində njékəwna̰-je lə-m dɔ-tɨ. Lo kɨ́ koó ya kàrè à kasɨ ra sə-dé né káre al. ");
INSERT INTO mge_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mꞌa kadɨ-i lakere kɔ̰ɓe kɨ́ dɔra̰-tɨ. Beɓa né kɨ́ i ꞌtɔ́ dɔnangɨ-tɨ nè lé, à tokɨ tɔ́ dɔra̰-tɨ ə né kɨ́ i ꞌtutɨ dɔnangɨ-tɨ nè à tokɨ tutɨ dɔra̰-tɨ tɔ.”» ");
INSERT INTO mge_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Go-tɨ, Jeju ndəjɨ njéndó né-je liə n̰a̰ kadɨ ꞌpa dꞌadɨ dow gə kɨ́ nꞌto Kristɨ al. ");
INSERT INTO mge_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gangɨ ndɔ-é-tɨ kin ya Jeju un kutɨ kidə ta njéndó né-je liə rəsɨ-rəsɨ panè: Tò kadɨ mꞌɔw Jorijalḛm, mꞌɔw mꞌingə kɔ̰̀ n̰a̰ ji ꞌngatɔ́gɨ-je-tɨ lə jipɨ-je rəm, ji njékun dɔ njégugné-je-tɨ lə Lubə rəm, ji njéndó dow-je ndukun-je-tɨ sar kadɨ ꞌtɔl-m, ngà ndɔ kɨ́ njèkungɨ-tɨ mutə rəmə mꞌa tɔsɨ ndəl kində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Rəmə Piyər ɔr-é ɔw siə kəl káre ɔw kɔl siə panè: «I ꞌƁaɓe lé, Lubə à kɔsɨ né-é kin kɨ rangɨ dɔ-i-tɨ. Né-é kinlé à tḛḛ dɔ-i-tɨ nda̰ bè al.» ");
INSERT INTO mge_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngà Jeju təl kəm-é ə idə Piyər lé panè: «ꞌƆtɨ kɨ rangɨ ta-m-tɨ, i Sata̰. ꞌTo jigɨ nɔ̰̀-m-tɨ, kdɔ tagɨr-je lə-i to tagɨr-je lə dow-je, ɓɨ to tagɨr-je lə Lubə al.» ");
INSERT INTO mge_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Beɓa Jeju idə njéndó né-je liə panè: «Kinə dow ndigɨ kun go-m rəmə, kadɨ ta rɔ-é ɔ̰̀-é al, kadɨ un kagdəsɨ liə utɨ ə un go-m. ");
INSERT INTO mge_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kdɔ dow kɨ́ rá-rá ya kɨ́ ndigɨ kajɨ rɔ-é rəmə à tujɨ rɔ-é, ngà dow kɨ́ ilə rɔ-é kɔgɨ kdɔ ta lə-m ɓá à kajɨ rɔ-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kadɨ dow ingə né-je kɨ́ dɔnangɨ-tɨ nè lay ə ndil-é tujɨ lé, majɨ-é to ri wa? Əse ri ɓá dow à kadɨ kdɔ kɔr-né tó ndil-é wa? ");
INSERT INTO mge_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kdɔ Ngon lə dow lé, à ree dan riɓa-tɨ lə Bɔbɨ-é Lubə natɨ kɨ̀ malayka-je liə, ngá ɓá à kugə dow kɨ́ rá-rá kɨ go kullə ra-é-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ooi majɨ, mꞌa kidə-si rəsɨ: Dow-je madɨ dan dḛ-tɨ kɨ́ dꞌa̰ nè kinlé, Ngon lə dow à ree kɨ̀ kɔ̰ɓe liə kadɨ dꞌoo-é kɨ̀ kəm-dé ndə̰́-ndə̰́ ɓəy ɓá dꞌa koy.» ");
INSERT INTO mge_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ndɔ mɛkḛ go-tɨ, Jeju adɨ Piyər dḛ kɨ̀ Jakɨ, ɓá Ja̰ kɨ́ to ngonkɔ̰ Jakɨ dꞌɔw siə ə dꞌɔw dꞌisɨ kɨ̀ kár-dé dɔ mbal-tɨ kɨ́ ngal. ");
INSERT INTO mge_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lo-é-tɨ nɔ̰ɔ̰ ya rɔ Jeju mbəl tò gay, adɨ takəm-é ɔ̰̀ njoy-njoy titɨ-na̰ kɨ̀ kàdɨ̀ bè. Kubɨ-je liə kàrè təl nda mbəy-mbəy titɨ-na̰ kɨ̀ londógɨ bè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rəmə Moiyijɨ dḛ kɨ̀ Eli ꞌtḛḛ sə-dé kɔy, ə dꞌɔjɨ ta kɨ̀ Jeju. ");
INSERT INTO mge_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Beɓa Piyər un ta idə Jeju panè: ꞌƁaɓe, majɨ n̰a̰ kadɨ jꞌisi lo kin-tɨ nè ya ngá. Kinə ꞌndigɨ lé, mꞌa ra kəykubɨ mutə, káre à to ꞌlə-i, káre à to ꞌlə Moiyijɨ ə káre à to ꞌlə Eli tɔ. ");
INSERT INTO mge_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lokɨ Piyər a̰ pa ta lé kɨ pa ya ɓəy rəmə, kilndi kɨ́ ndɔ̰y ngilingɨ-ngilingɨ ree səbɨ dɔ-dé-tɨ rɨpɨ, ngá ɓá ndi dow ɓa dan kilndi-tɨ lé panè: Ḛ kinlé to Ngon-m, mꞌində-é dan kəm-m-tɨ rəm, rɔ-m nəl-m dɔ-é-tɨ n̰a̰ rəm; ooi ta liə. ");
INSERT INTO mge_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lokɨ njéndó né-je lə Jeju dꞌoo ndi dow kinlé bè rəmə, ꞌɓəl n̰a̰ adɨ ꞌtusɨ ꞌsəbɨ takəm-dé nangɨ. ");
INSERT INTO mge_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngá ɓá Jeju ɔtɨ ree rɔ-dé-tɨ, ɔdɨ rɔ-dé, ɓəy ɓá idə-dé panè: «Ḭḭ taá! ꞌƁəli al!» ");
INSERT INTO mge_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Beɓa lokɨ Piyər-je, kɨ̀ Ja̰-je, kɨ̀ Jakɨ-je lé dꞌun kəm-dé kɨ taá rəmə dꞌoo Jeju ya kɨ̀ kár-é. ");
INSERT INTO mge_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Go-tɨ, lokɨ dꞌḭ dɔ mbal-tɨ dꞌisɨ risɨ nangɨ lé, Jeju un ndu adɨ-dé panè: «Né kɨ́ ooi kinlé, ꞌpai ta-é adi dow kɨ́ rangɨ oo al ya sar kadɨ Ngon lə dow tɔsɨ-né ndəl ində lo tḛḛ dan dow-je-tɨ kɨ́ dꞌoy.» ");
INSERT INTO mge_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Go ta-je-tɨ kin ɓá njéndó né-je ꞌdəjɨ-é ꞌpanè: «Ngà kdɔ ri ɓá njéndó dow-je ndukun-je ꞌpanè: “Tò kadɨ Eli ree mɔkɨ tá” wa?» ");
INSERT INTO mge_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jeju təl idə-dé panè: «Tò kadɨ Eli à təl ree kdɔ kɔsɨ nja né-je natɨ kɨ̀ gangɨ-é gangɨ-é lay. ");
INSERT INTO mge_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngà mꞌa kidə-si rəsɨ kɨ́ Eli lé ree ngá. Rəmə dow-je ꞌtəl ꞌgə-é al, adɨ ꞌra siə né-je kɨ́ mḛḛ-dé ndigɨ. Gangɨ-é kin ya dowbé-je dꞌa kadɨ-né kɔ̰̀ Ngon lə dow tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Beɓa njéndó né-je ꞌgə kɨ́ ta kɨ́ Jeju pa sə-dé lé, ḛ pa sɔbɨ-né dɔ Ja̰ kɨ́ njèra dow-je batḛm. ");
INSERT INTO mge_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lokɨ Jeju dḛ kɨ̀ njéndó né-je liə ꞌtəl ꞌree ngɔsi kɨ̀ kosɨ dow-je rəmə, dingəm káre ree tɔsɨ məkəjɨ-é nangɨ nɔ̰̀-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ɓá idə-é panè: ꞌƁaɓe, ꞌoo kəmtondoo lə ngon-m kɨ́ dingəm kin. Kdɔ kɔ̰nɔ̰ ɔsɨ-é adɨ ingə kɔ̰̀ n̰a̰, tusɨ taá-taá. Lokɨ ḭ siə lé, kɨ́ madɨ-je ɔsɨ-é ilə-é dan pər-tɨ, ə kɨ́ ná̰-je ɔsɨ-é ilə-é dan man-tɨ-je. ");
INSERT INTO mge_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Beɓa mꞌree siə rɔ njéndó né-je-tɨ lə-i kadɨ dꞌadɨ-é lapiya rəmə dꞌasɨ al. ");
INSERT INTO mge_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jeju un ndi-é kɨ́ taá pa ta kɨ̀ njéndó né-je liə panè: Sə̰i ko dow-je kɨ́ njémḛḛnga̰-je kɨ̀ njémḛḛndul-je kan! Mꞌa kisɨ sə-si natɨ asɨ kaglo ban ɓəy wa? Mꞌa kisɨ dɔ-tɨ sə-si asɨ kaglo ban ɓəy wa? ꞌReei kɨ̀ ngon lé rɔ-m-tɨ nè bè. ");
INSERT INTO mge_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Beɓa Jeju ndángɨ ndil kɨ́ majɨ al kɨ́ isɨ mḛḛ ngon-tɨ lé adɨ-é tḛḛ kɔgɨ. Rəmə ngon lé, ingə lapiya tajinatɨ nè ya. ");
INSERT INTO mge_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go-tɨ, njéndó né-je dꞌɔw dꞌingə Jeju kɨ̀ kár-é ꞌdəjɨ-é ꞌpanè: «Kdɔ ri ɓá jḛ ya kɨ̀ dɔ-ji jꞌasɨ tubə ndil kɨ́ majɨ al kinlé kɔgɨ al wa?» ");
INSERT INTO mge_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Beɓa Jeju təl idə-dé panè: «Kadmḛḛ lə-si ya ɓá asɨ al. Ooi majɨ, mꞌa kidə-si rəsɨ; kinə kadmḛḛ lə-si asɨ kɨ̀ ka̰a̰ kɔl bè ya kàrè ɓá idəi mbal kin ꞌpainè: “ꞌƆtɨ kɨ rangɨ lo kin-tɨ ə ꞌɔw ꞌa̰ lo kɨ́ yó-tɨ kin ya kàrè à kɔtɨ kɔw.” Né ya kɨ́ à dum dɔ-si goto. ");
INSERT INTO mge_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngà ndil-je kɨ́ ꞌtana̰ bè kinlé, dow à tubə-dé kɨ̀ pa ta kɨ̀ Lubə kɨ̀ go kɔgɨ rɔ nékuso ɗo.» ");
INSERT INTO mge_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndɔ káre bè, lokɨ njéndó né-je dꞌisɨ takəm-na̰-tɨ lay dɔnangɨ Galile-tɨ lé, Jeju idə-dé panè: «Dꞌa kilə Ngon lə dow ji dow-je-tɨ, ");
INSERT INTO mge_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kdɔ kadɨ ꞌtɔl-é, rəmə ndɔ kɨ́ njèkungɨ-tɨ mutə lé, à tɔsɨ ndəl kində lo tḛḛ.» Ta kinlé, ra adɨ rɔ njéndó né-je atɨ-dé kana̰na̰. ");
INSERT INTO mge_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lokɨ Jeju kɨ̀ njéndó né-je ꞌree mḛḛ ɓebo Kapɛrnayim-tɨ lé, njétaalambo kəy lə Lubə, ꞌree rɔ Piyər-tɨ ꞌdəjɨ-é ꞌpanè: Njèndó-si né lé, ḛ ugə lambo kəy lə Lubə al wa? ");
INSERT INTO mge_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyər təl idə-dé panè: Ḛ ugə ugə ya. Ngà lokɨ Piyər lé isɨ andɨ mḛḛ kəy-tɨ ya rəmə Jeju un ta kete dəjɨ-é panè: Simɔ̰, tagɨr lə-i to ban dɔ ta-tɨ kinlé wa? Ná̰ ɓá à kugə lambo-je, kɨ̀ né-je kɨ́ njékɔ̰ɓe-je kɨ́ dɔnangɨ-tɨ nè ꞌgangɨ dɔ dow-je-tɨ lé wa? À to ngan njéɓe-je əse à to mba-je wa? ");
INSERT INTO mge_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyər təl ilə-é-tɨ panè: «To mba-je.» Beɓa Jeju təl idə Piyər panè: Kinə to mba-je ɓá dꞌa kugə lé, ngan njéɓe-je dꞌa kugə al. ");
INSERT INTO mge_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngà kdɔ kadɨ jꞌtəl jigɨ jꞌtugə dow-je kin al lé, ɔtɨ ɔw dan babo-tɨ ilə kuy. Kanjɨ kɨ́ ꞌa kuwə-é dɔsa̰y ya rəmə, ꞌtḛḛ ta-é ə ꞌa kingə là kɨ́ à kasɨ kadɨ ꞌree ugə-né lambo dɔ-ji-tɨ jḛ sə-i joo rɔ njétaalambo-je-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dɔkàdɨ̀-é-tɨ kinlé, njéndó né-je lə Jeju dꞌɔw rɔ-é-tɨ ꞌdəjɨ-é ꞌpanè: Ná̰ ya ɓá to ꞌboy n̰a̰ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Beɓa Jeju ɓa ngon kɨ́ sḛ bè adɨ a̰ dan-dé-tɨ dana̰, ");
INSERT INTO mge_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɓá idə-dé panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; kinə in̰əi panjiyə-si ə ꞌtəli rɔ-si titɨ-na̰ kɨ̀ ngan-je kɨ́ sḛ kin bè al lé, a kandi kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ nda̰ bè al. ");
INSERT INTO mge_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Adɨ dow kɨ́ rá-rá kɨ́ sɔl dɔ-é, təl rɔ-é titɨ-na̰ kɨ̀ ngon kɨ́ sḛ kin bè lé, ḛ ɓá to dow kɨ́ boy n̰a̰ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dow kɨ́ rá-rá kɨ́ uwə ngon kɨ́ titɨ ḛ kan bè kɨ rɔ-é-tɨ kdɔ ta lə-m lé, to ma̰ ya dowbé uwə-m kɨ rɔ-é-tɨ tɔ tin. ");
INSERT INTO mge_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ngà kinə dow madɨ ra dow káre dan ngan dow-je-tɨ kɨ́ dꞌadɨ-m mḛḛ-dé kin adɨ-é ra majal lé, lé ꞌdɔɔ mbal kusɨ ko kɨ́ boy mindɨ-é-tɨ, ɓá dꞌilə-é-né dan babo-tɨ dꞌadɨ-é nduy ya kàrè ꞌliə tò sotɨ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tujɨ à kusɨ dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ, kdɔtalə né-je kɨ́ dꞌisɨ ꞌra dꞌadɨ to gin kusɨ mḛḛ majal-tɨ lə dow-je. Tɔgrɔ-tɨ, né-je kɨ́ à to gin kusɨ mḛḛ majal-tɨ lé à ree ya; ngà dow kɨ́ né-é-je kin ree kɨ̀ kəm rəbɨ kɨ́ rɔ-é-tɨ lé tujɨ à kusɨ dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Beɓa kinə ji-i əse nja-i ra-i adɨ ꞌra majal lé, ꞌgangɨ-é ilə-é kɔgɨ ngərəngɨ nṵ bè; kadɨ ꞌɔw lo kiskəm-tɨ kɨ̀ ji-i əse kɨ̀ nja-i káre lé tò sotɨ itə ngəm ji-i joo kɨ̀ nja-i joo lay, ə dꞌilə-i-né dan pər-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Əse kinə kəm-i ɓá ra-i adɨ ꞌra majal lé, ɔr-é ilə-é kɔgɨ ngərəngɨ; kadɨ ꞌandɨ lo kiskəm-tɨ kɨ̀ kəm-i káre-rè lé tò sotɨ itə ngəm kəm-i joo lay ə dꞌilə-i-né dan pər-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ooi nè a nədi dow káre dan ngan dow-je-tɨ kin. Mꞌa kidə-si rəsɨ kɨ́ dḛ lé, malayka-je lə-dé dꞌa̰ takəm Bɔbɨ-m-tɨ kɨ́ dɔra̰-tɨ kɨ̀ ndɔ-je lay kdɔ ta lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kdɔtalə Ngon lə dow lé, ree kdɔ kajɨ dow-je kɨ́ ꞌndəm. ");
INSERT INTO mge_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sə̰i ya bè lé, tagɨr lə-si tò ban dɔ poyta-tɨ kɨ́ mꞌa kɔr kin wa? Kinə dow ɔw kɨ̀ batɨ-je ɓu, ɓá ḛ kɨ́ káre dan-dé-tɨ ndəm lé, ḛ à kin̰ə dḛ kɨ́ kɔrjinà̰y káre gidɨ-é jinà̰y káre lo kuso né-tɨ kàdɨ̀ mbal-tɨ kdɔ kɔw sangɨ ḛ kɨ́ ndəm lé ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ooi majɨ, mꞌa kidə-si rəsɨ; kinə ɔw ɓá ingə batɨ-é kinlé, rɔ-é à nəl-é dɔ-é-tɨ n̰a̰ kitə batɨ-je kɨ́ kɔrjinà̰y káre gidɨ-é jinà̰y káre kɨ́ ꞌndəm al. ");
INSERT INTO mge_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bè ya tɔ ə́, Bɔbɨ-si kɨ́ dɔra̰-tɨ lé, ndigɨ kadɨ dow káre ya kàrè tujɨ dan ngan dow-je-tɨ kin al. ");
INSERT INTO mge_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kinə ngonkɔ̰-i ra sə-i né kɨ́ majɨ al lé, ꞌɔw ingə-é ḛ ya kɨ̀ kár-é, ꞌtɔjɨ-é majal liə. Kinə oo ta lə-i rəmə, ꞌingə ngonkɔ̰-i gogɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngà kinə ḛ mbatɨ koo ta lə-i lé rəmə, ꞌtəl ꞌree un dow káre əse joo sə-i kdɔ mbete kɨ́ aa njay panè: «Ta-je lay ya kadɨ tokɨ gɔl takəm dow-je-tɨ joo əse mutə tá.» ");
INSERT INTO mge_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngà kinə ḛ mbatɨ koo ta lə-dé ɓəy rəmə, idə njékəwna̰-je. Kinə mbatɨ koo ta lə njékəwna̰-je ya tɔ ɓəy rəmə, kadɨ ooi-é kɨ njèkadmḛḛ al əse ooi-é kɨ dow kɨ́ njètaalambo bè. ");
INSERT INTO mge_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ né-je lay kɨ́ ꞌtɔ́i dɔnangɨ-tɨ nè lé, à tokɨ tɔ́ dɔra̰-tɨ ə né-je lay kɨ́ ꞌtuti dɔnangɨ-tɨ nè lé, à tokɨ tutɨ dɔra̰-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Bè ya tɔ, mꞌa kidə-si ɓəy. Kinə dow-je joo dan-si ndi-dé asɨ-na̰ dɔ né-tɨ kɨ́ rá-rá ya dɔnangɨ-tɨ nè, ɓá ꞌdəjɨ Bɔbɨ-m kɨ́ taá dɔra̰-tɨ lé, à kadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kdɔ lokɨ dow-je joo əse mutə ꞌkəw-na̰ kɨ̀ ri-m lé, ma̰ mꞌisɨ dan-dé-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Beɓa Piyər ɔtɨ kɨ rɔ Jeju-tɨ dəjɨ-é panè: «ꞌƁaɓe, nja kandangɨ ɓá ngonkɔ̰-m ra sə-m né kɨ́ majɨ al ə mꞌa kin̰ə go-é kɔgɨ kadɨ-é wa? Sar nja siri je bè wa?» ");
INSERT INTO mge_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jeju ilə-é-tɨ panè: «Bè al. Mꞌa kidə-i panè sar nja siri par al, ngà kɔrsiri nja siri.» ");
INSERT INTO mge_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Beɓa kɔ̰ɓe kɨ́ dɔra̰-tɨ lé, titɨ-na̰ kɨ̀ ta lə ngar kɨ́ ndigɨ kadɨ ngannjékullə-je liə dꞌɔr go né-je liə dꞌadɨ-é oo kin bè. ");
INSERT INTO mge_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lokɨ ḛ ulə gin-é lé, ꞌree kɨ̀ ngonnjèkullə liə káre kɨ́ ɔw kɨ̀ là kɨ́ dum tidə kɔr-é dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngà dowbé kinlé, là kɨ́ kadɨ ugə-né kurə lé goto. Beɓa ꞌɓa-é lé un ndu kadɨ ꞌndogɨ-é titɨ-na̰ ɓə bè natɨ kɨ̀ ne-é, kɨ̀ ngan-é-je, kɨ̀ nékingə-é-je lay kdɔ kadɨ dꞌugə-né kurə kɨ́ dɔ-é-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Beɓa ngonnjèkullə lé, usɨ nangɨ nɔ̰̀ ngar-tɨ, nɔ̰ uwə nja-é panè: «ꞌƁa-m, ꞌoo kəmtondoo lə-m ə mꞌa kugə-i ngər-ngər ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ꞌƁa-é lé, oo kəmtondoo liə, ɔr kurə lé dɔ-é-tɨ kɔgɨ ə in̰ə-é adɨ-é ɔw. ");
INSERT INTO mge_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ngà lokɨ ngonnjèkullə kinlé, tḛḛ ndaa-tɨ ya rəmə ingə madkullə liə kɨ́ kurə liə tò dɔ-é-tɨ ndḛ bè. Ḛ usɨ mindɨ-é-tɨ uwə, adɨ koo ɔw kɨ̀ gangɨ-é ɓá idə-é panè: «ꞌUgə-m kurə lə-m.» ");
INSERT INTO mge_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Beɓa madɨ-é lé, usɨ nangɨ nɔ̰̀-é-tɨ nɔ̰ uwə-né nja-é panè: ꞌOo kəmtondoo lə-m, ə mꞌa kugə-i ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bè ya kàrè madɨ-é lé, mbatɨ sar ɔw ilə-é dangay-tɨ, kdɔ kadɨ ugə kurə lé lay tá. ");
INSERT INTO mge_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lokɨ ndəgɨ ngannjékullə-je lə ngar lé, dꞌoo né kin bè rəmə, wɔngɨ ra-dé n̰a̰ adɨ dꞌɔw dꞌɔr poy-é dꞌadɨ ꞌɓa-dé oo. ");
INSERT INTO mge_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Beɓa ꞌɓa-é lé, adɨ ꞌree siə rɔ-é-tɨ, ɓá idə-é panè: I ngonnjèkullə kɨ́ njèmḛḛndul kan! Ma̰ mꞌɔr kurə lə-m lay dɔ-i-tɨ, kdɔ ndoo kɨ́ i ꞌra ta-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lé ꞌa koo kəmtondoo lə madɨ-i titɨ-na̰ kɨ́ ma̰ mꞌoo-né kəmtondoo lə-i kin bè ya tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Beɓa wɔngɨ ra ꞌɓa-é lé n̰a̰, adɨ uwə-é adɨ ra kullə kɨ́ nga̰-nga̰ kadɨ ugə-né kurə kɨ́ dɔ-é-tɨ lé lay. ");
INSERT INTO mge_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jeju təl ilə dɔ-tɨ panè: «Gangɨ-é kin ya Bɔbɨ-m kɨ́ dɔra̰-tɨ à ra-né sə-si, kinə ná̰-ná̰ dan-si-tɨ in̰ə go kɔgɨ kɨ̀ mḛḛnda ka̰y adɨ ngonkɔ̰-é al.» ");
INSERT INTO mge_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lokɨ Jeju ndó dow-je né adɨ gin-é gangɨ lé, ḭ dɔnangɨ Galile-tɨ ɔw kəl lo-tɨ kɨ́ dɔnangɨ Jude-tɨ gidɨ ba jurdḛ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Beɓa kosɨ dow-je n̰a̰ ya dꞌɔw go-é-tɨ adɨ adɨ lapiya njémɔ̰y-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Rəmə Parisi-je ꞌree rɔ-é-tɨ kdɔ na̰-é koo ta kɨ́ mḛḛ-é-tɨ adɨ ꞌdəjɨ-é ꞌpanè: «Se to tó-é kadɨ dow tubə ne-é kdɔ né kɨ́ rá-rá ya kɨ́ dené lé ra wa?» ");
INSERT INTO mge_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jeju ilə-dé-tɨ panè: Sə̰i ꞌndói mḛḛ mbete-tɨ kɨ́ aa njay lé ooi al ya sar wa? Lo kində gin-é-tɨ lé, Lubə ra dené kɨ̀ dingəm ");
INSERT INTO mge_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ə panè: «Gin-é kin ɓá dingəm à kin̰ə-né kɔ̰-é kɨ̀ bɔbɨ-é kadɨ ꞌtin̰ə natɨ kɨ̀ ne-é kdɔ kadɨ dḛ joo lay ꞌtəl kubru rɔ kɨ́ káre-rè. ");
INSERT INTO mge_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Adɨ ꞌto dow-je joo al ngá. Ngà ꞌtəl kubru rɔ kɨ́ káre-rè. Gin-é kin ɓá né kɨ́ Lubə tɔ́ natɨ lé, kadɨ dow tutɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisi-je ꞌtəl ꞌdəjɨ Jeju ꞌpanè: Ngà kdɔ ri ɓá Moiyijɨ un ndu kadɨ kinə dow tubə ne-é rəmə ꞌadɨ-é mbete tubə ɓane wa? ");
INSERT INTO mge_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Beɓa Jeju ilə-dé-tɨ panè: «To ta lə mḛḛnga̰ lə-si ɓá Moiyijɨ adɨ-si-né tarəbɨ kadɨ ꞌtubəi-né ne-si-je. Ngà lo kində gin-é-tɨ lé, tò bè al. ");
INSERT INTO mge_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ooi majɨ, mꞌa kidə-si rəsɨ; kinə dow tubə ne-é kdɔ kaya kɨ́ ra ɓane, ɓɨ kinə tubə-é kdɔ né kɨ́ rangɨ ɓá ɔw taa dené kɨ́ rangɨ rəmə, dowbé ra kaya.» ");
INSERT INTO mge_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Beɓa njéndó né-je liə ꞌpanè: Kinə to gangɨ-é kin ɓá tò kadɨ dingəm ra kɨ̀ dené rəmə, taa dené al tò sotɨ. ");
INSERT INTO mge_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jeju təl idə-dé panè: Dow-je lay ɓá dꞌa gə mḛḛ ta kin al. Ngà dḛ kɨ́ Lubə ya tḛḛ kɨ̀ dɔ-é adɨ-dé tá. ");
INSERT INTO mge_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dow-je kɨ́ ná̰-je ꞌtaa dené al, kdɔtalə rɔ-dé oy mburukɨ lo kojɨ-dé-tɨ nṵ. Dḛ kɨ́ dan-tɨ-je ꞌtaa dené al, kdɔtalə ꞌtɔɔ kɔɔ gəm-dé, ngà dḛ kɨ́ madɨ-je ꞌtaa dené al, kdɔ kullə kɔ̰ɓe kɨ́ dɔra̰-tɨ. Dow kɨ́ asɨ gə mḛḛ ta kin rəmə, kadɨ-é gə. ");
INSERT INTO mge_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Beɓa dow-je ꞌree kɨ̀ ngan-je rɔ Jeju-tɨ kdɔ kadɨ ində ji-é dɔ-dé-tɨ rəm, kadɨ pa ta kɨ̀ Lubə kdɔ ta lə-dé rəm. Rəmə njéndó né-je ꞌkɔl sə-dé. ");
INSERT INTO mge_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngà Jeju idə-dé panè: «In̰əi ngan-je adɨ ꞌree rɔ-m-tɨ, ɓɨ ɔgi-dé al, kdɔtalə kɔ̰ɓe kɨ́ dɔra̰-tɨ lé, tò kdɔ dow-je kɨ́ ꞌtana̰ sə-dé bè.» ");
INSERT INTO mge_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Beɓa Jeju ində ji-é dɔ-dé-tɨ ɓá in̰ə-dé ɔw. ");
INSERT INTO mge_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Go-tɨ, Basa káre ree rɔ Jeju-tɨ dəjɨ-é panè: «Njèndó dow-je né, ri kɨ́ majɨ ɓá mꞌa ra kdɔ kadɨ mꞌisɨ-né kəm sartagangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jeju idə-é panè: «Kdɔ ri ə́ ꞌdəjɨ-m ta dɔ né-tɨ kɨ́ majɨ wa? Njèramajɨ lé, ḛ káre-rè. Kinə ꞌndigɨ kiskəm sartagangɨ rəmə ꞌtəl rɔ-i go ndukun-je-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Basa lé, təl dəjɨ Jeju panè: «Ndukun-je kɨ́ rá-rá wa?» Beɓa Jeju ilə-é-tɨ panè: «ꞌA tɔl dow al! ꞌA ra kaya al! ꞌA ɓogɨ al! ꞌA tətɨ ta kɨ́ ndángɨ al! ");
INSERT INTO mge_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ꞌA tətɨ kagɨ bɔbɨ-i kɨ̀ kɔ̰-i rəm, ɓá ꞌa ndigɨ dow madɨ-i tana̰ kɨ̀ rɔ-i bè tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Basa lé idə Jeju panè: «Ma̰ mꞌtəl rɔ-m go né-je-tɨ kin lay ngá. Ngà ri ɓá nà̰y kadɨ mꞌra ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Beɓa Jeju idə-é panè: «Kinə ꞌndigɨ majɨ kɔr njutɨ rəmə, ꞌɔw ꞌndogɨ nékingə-i lay ə ꞌləbɨ la-é njéndoo-je rəmə ndɔ-é ꞌa kingə n̰a̰ dɔra̰-tɨ ə ꞌree un go-m.» ");
INSERT INTO mge_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lokɨ basa lé, oo ta lə Jeju kinlé rəmə, ɔtɨ ɔw kɨ̀ rɔkatɨ kana̰na̰, kdɔ to dow kɨ́ nékingə-é n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jeju idə njéndó né-je liə panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; kadɨ njènékingə ɔw kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ lé, to né kɨ́ nga̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mꞌa kidə-si ya ɓəy; kadɨ Jambal dəə ɓe libri-tɨ lé to né kɨ́ lo-é nga̰ n̰a̰ ya, ngà kadɨ njènékingə ɔw kɔ̰ɓe-tɨ lə Lubə lé to né kɨ́ nga̰ itə-é ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lokɨ njéndó né-je dꞌoo ta kinlé bè rəmə, ꞌɓəl adɨ ꞌpanè: «Tò bè ngà ná̰ ɓá à kajɨ wa!» ");
INSERT INTO mge_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeju oo-dé gə́rə́rə́ rəmə, idə-dé panè: «Né kinlé dow-je ɓá dum dɔ-dé, ngà Lubə lé né kɨ́ dum-é goto.» ");
INSERT INTO mge_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rəmə Piyər un ta dəjɨ-é panè: «Ə jḛ kɨ́ jꞌtusɨ né-je lə-ji lay jꞌin̰ə ɓá jꞌun go-i kinlé, ta kɨ́ dɔ-ji-tɨ à tò ban wa?» ");
INSERT INTO mge_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Beɓa Jeju idə-dé panè: «Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ sə̰i njékun go-m-je kinlé, ndɔ kɨ́ né-je lay à təl kɨ́ sigɨ lé, Ngon lə dow à ree kisɨ dɔ kalikɔ̰ɓe-tɨ liə kɨ́ to kali riɓa kinlé, sə̰i ya kàrè a kisi dɔ kalikɔ̰ɓe-je-tɨ kɨ́ dɔgɨ gidɨ-é joo, kdɔ gangta dɔ gin Israyel-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé tɔ. ");
INSERT INTO mge_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ná̰-ná̰ kɨ́ in̰ə kəy-je liə əse ngankɔ̰-é-je, əse kɔ̰nan-é-je, əse bɔbɨ-é, əse kɔ̰-é, əse ne-é, əse ngan-é-je, əse ndɔr-je liə kdɔ ta lə-m lé, à kingə dɔ-tɨ nja ɓu rəm, ɓá à kingə kiskəm kɨ́ tò sartagangɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngà dow-je n̰a̰ dan dḛ kɨ́ kete-tɨ dꞌa təl to dow-je kɨ́ gogɨ ə dow-je n̰a̰ dan dḛ kɨ́ gogɨ-tɨ dꞌa təl to dow-je kɨ́ kete tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kɔ̰ɓe kɨ́ dɔra̰-tɨ lé tò titɨ-na̰ kɨ̀ ta lə njèndɔr káre kɨ́ tḛḛ kɨ̀ ndɔge ratɨ, kdɔ kɔy dow-je kullə ndɔr nduu-tɨ liə kin bè. ");
INSERT INTO mge_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Lokɨ ingə-dé lé, ta-dé asɨ-na̰ kadɨ à kadɨ-dé là kɨ́ asɨ kəm kullə kɨ́ ndɔ káre, ɓá adɨ dꞌɔw lo ndɔr nduu-tɨ liə lé. ");
INSERT INTO mge_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Go-tɨ, njèndɔr lé tḛḛ ndaa-tɨ kɨ̀ kàdɨ̀ kɨ́ jinà̰y káre kɨ́ ndɔge rəmə, oo dow-je kɨ́ rangɨ kɨ́ dꞌingə kullə al kɨ́ dꞌa̰ pandangɨ lo-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Beɓa ḛ idə-dé panè: Sə̰i kàrè, ɔwi ndɔrɔ lə-m tɔ. Go kullə-tɨ kɨ́ a rai lé, mꞌa kugə-si majɨ ya. ");
INSERT INTO mge_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dḛ kàrè dꞌɔtɨ dꞌɔw tɔ. Ngà lokɨ kàdɨ̀ a̰ jam dɔ ɓe-tɨ, njèndɔr lé tḛḛ ɓəy rəmə, ingə dow-je kɨ́ rangɨ ɓəy rəm, lokɨ kàdɨ̀ a̰ mbɔ́ ɓe-tɨ rəmə, ingə dow-je kɨ́ rangɨ pandangɨ lo-tɨ lé ya ɓəy. Dowbé-je kin kàrè idə-dé panè: Ɔwi ndɔrɔ lə-m go madɨ-si-je-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lokɨ kàdɨ̀ ra bin̰ə-je bole asɨ lé, njèndɔr lé təl tḛḛ ndaa-tɨ ɓəy rəmə, ingə dow-je kɨ́ rangɨ ya ɓəy. Beɓa ḛ dəjɨ-dé panè: Kdɔ ri ɓá a̰i lo-tɨ kin kɨ̀ ndɔge nṵ kare bè wa? ");
INSERT INTO mge_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dḛ dꞌilə-é-tɨ ꞌpanè: Dow un-ji kullə-tɨ al. Beɓa njèndɔr lé təl ilə-dé-tɨ panè: Kinə tò bè rəmə ɔti ɔwi ꞌrai kullə ndɔrɔ lə-m tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lokɨ kàdɨ̀ ur rəmə, njèndɔr nduu lé idə njèkoo go né-je liə panè: ꞌƁa njéra kullə mḛḛ ndɔr nduu-tɨ lə-m lé, ə adɨ-dé nékugə dɔji-dé. ꞌUlə gin-é dɔ dḛ kɨ́ dꞌɔw gogɨ nè-tɨ ɓá ꞌtḛḛ-né dɔ dḛ kɨ́ dꞌɔw kɨ̀ ndɔge-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dḛ kɨ́ dꞌɔw ndɔrɔ kɨ̀ kàdɨ̀ ra bin̰ə-je bole lé, ꞌree rəmə dꞌingə nékugə dɔji-dé asɨ kəm kullə kɨ́ dow ra ndɔ káre lé. ");
INSERT INTO mge_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngà lokɨ dḛ kɨ́ dꞌɔw ndɔrɔ kɨ̀ ndɔge ratɨ ꞌree lé, ꞌgɨr ꞌpanè dḛ rəmə, dꞌa kingə n̰a̰ kitə dḛ kɨ́ dꞌɔw kɨ̀ kàdɨ̀ ra bin̰ə-je bole lé ngá; ya rəmə njèkugə-dé lé, adɨ-dé là asɨ-na̰ kɨ̀ dḛ kɨ́ dꞌɔw ndɔrɔ gogɨ nè lé bè tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Beɓa lokɨ dḛ ꞌtaa là lé rəmə, ꞌpa ta kɨ́ majɨ al dɔ njèkun-dé kullə-tɨ lé, ");
INSERT INTO mge_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ꞌpanè: Kdɔ ri ɓá dḛ kɨ́ ꞌree gogɨ, ꞌra kullə kàdɨ̀ káre ya par rəmə ꞌugə-dé asɨ sə-ji jḛ kɨ́ jꞌree kɨ̀ ndɔge nṵ, adɨ jꞌɔɔ rɔgɨ-rɔgɨ rəm, kàdɨ̀ kàrè nətɨ-ji kərɨm-kərɨm kinlé wa? ");
INSERT INTO mge_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Beɓa njèndɔr lé təl ilə dow kɨ́ káre dan-dé-tɨ panè: Nam-m, mꞌra sə-i ndangɨ al. Lé jꞌadɨ ta-ji asɨ-na̰ kdɔ kadɨ lokɨ ꞌra kullə, ndɔ káre lé, mꞌa kadɨ-i là kɨ́ asɨ kəm kullə kɨ́ ndɔ káre ya al wa? ");
INSERT INTO mge_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yən, ꞌtaa nékugə dɔji-i ə ꞌɔtɨ ꞌɔw lo lə-i. Ə njèree kullə-tɨ gogɨ nè lé to ma̰ ya mꞌndigɨ kadɨ-é nékugə dɔji lé asɨ sə-i. ");
INSERT INTO mge_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nékingə-m lé, to tó-é kadɨ mꞌra-né né kɨ́ mḛḛ-m ndigɨ al wa? To kɨ́ mꞌto dow kɨ́ majɨ kinlé nəl-i al wa? ");
INSERT INTO mge_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jeju təl ilə dɔ gosta-tɨ kinlé panè: Bè ya tɔ, dḛ kɨ́ gogɨ dꞌa təl dḛ kɨ́ kete ə dḛ kɨ́ kete dꞌa təl dḛ kɨ́ gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lokɨ Jeju isɨ ɔw Jorijalḛm lé, ḛ ɔr njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo ngərəngɨ pa sə-dé ta taá-taá dɔ rəbɨ-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Yən, kɔw kɨ́ jꞌisi jꞌɔwi Jorijalḛm kinlé, dꞌa kilə Ngon lə dow ji njékun dɔ njégugné-je-tɨ lə Lubə, kɨ̀ ji njéndó dow-je ndukun-je-tɨ, kadɨ ꞌgangɨ ta koy dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dḛ dꞌa kilə-é ji dow-je-tɨ kɨ́ ꞌto jipɨ-je al, kadɨ ꞌsɔkɨ-é rəm, kadɨ ꞌtində-é kɨ̀ ndəy marɔw ɓá dꞌa ɓə-é kagdəsɨ-tɨ, rəmə à tɔsɨ ndəl kində lo tḛḛ ndɔ-tɨ kɨ́ njèkungɨ-tɨ mutə go-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kɔ̰ ngan lə Jebede ree kɨ̀ ngan-é-je rɔ Jeju-tɨ ə səbɨ takəm-é nangɨ nɔ̰̀-é-tɨ kdɔ dəjɨ-é né. ");
INSERT INTO mge_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Beɓa Jeju dəjɨ-é panè: I ꞌge ri wa? Ḛ panè: Un ndu kdɔ kadɨ ngan-m-je kɨ́ joo kinlé, ḛ kɨ́ káre isɨ dɔ jikɔl-i-tɨ ə kɨ́ káre isɨ dɔ jigəl-i-tɨ kɔ̰ɓe-tɨ lə-i. ");
INSERT INTO mge_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jeju ilə-dé-tɨ panè: Sə̰i lé, ꞌgəi né kɨ́ ꞌdəji lé al. A kasi kingəi kɔ̰̀ kɨ́ mꞌa kingə lé kàrè wa? Beɓa dḛ dꞌilə-é-tɨ ꞌpanè: Oiyo, jꞌa kasɨ kare. ");
INSERT INTO mge_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jeju ilə-dé-tɨ panè: Tɔgrɔ, kɔ̰̀ lə-m ə a kingəi, ngà ta lə kisɨ dɔ jikɔl-m-tɨ kɨ̀ dɔ jigəl-m-tɨ lé, to ma̰ ɓá mꞌa kadɨ al, ngà to Bɔbɨ-m ɓá à kadɨ dow-je kɨ́ ḛ ra go-é kete kdɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lokɨ ndəgɨ njéndó né-je kɨ́ dɔgɨ dꞌoo ta kin bè lé, wɔngɨ ra-dé dɔ ngankɔ̰-na̰-je-tɨ kɨ́ joo kinlé. ");
INSERT INTO mge_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Beɓa Jeju ɓa-dé lay rɔ-é-tɨ idə-dé panè: Sə̰i ꞌgəi kɨ́ njékɔ̰ɓe dɔ gin dow-je-tɨ kɨ́ gay-gay kɨ́ dɔnangɨ-tɨ nè lé, dꞌulə kəm dow-je ndoo n̰a̰ rəm, ɓá dow-je kɨ́ boy-boy kàrè, dꞌɔ̰̀ ɓe dɔ dow-je-tɨ lé kɨ́ go lo njètɔgɨ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngà sə̰i lé, kɔ̰̀-na̰ kɨ́ bè kin à goto dan-si-tɨ. Adɨ dow kɨ́ ndigɨ kadɨ nꞌto ꞌboy dan-si-tɨ lé, kadɨ təl rɔ-é ngonnjèkullə-tɨ lə-si. ");
INSERT INTO mge_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Rəm ɓá dow kɨ́ ndigɨ kadɨ nꞌto kɨ́ dɔsa̰y dan-si-tɨ lé, kadɨ təl rɔ-é ɓə-tɨ lə-si tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bè ya tɔ, Ngon lə dow lé, ree kadɨ dow-je ꞌra kullə dꞌadɨ-é al, ngà ḛ ɓá ree kdɔ ra kullə kadɨ dow-je rəm, ɓá kdɔ kadɨ rɔ-é gangɨ-né dɔ kosɨ dow-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lokɨ Jeju dḛ kɨ̀ njéndó né-je ꞌtḛḛ mḛḛ ɓe-tɨ kɨ́ Jeriko kɨ ndaa-tɨ lé, kosɨ dow-je n̰a̰ ya dꞌun go Jeju. ");
INSERT INTO mge_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ə njékəmtɔ-je joo dꞌisɨ ngangɨ rəbɨ-tɨ ɓá dꞌoo kɨ́ Jeju isɨ dəə lé, dꞌilə bɔbɨ ndi-dé nangɨ ꞌnɔ̰ ꞌpanè: «ꞌƁaɓe, ngonka Dabidɨ, ꞌoo kəmtondoo lə-ji!» ");
INSERT INTO mge_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rəmə kosɨ dow-je ꞌndángɨ-dé kadɨ dꞌutɨ ta-dé, ngà dḛ dꞌilə bɔbɨ ndi-dé nangɨ ꞌnɔ̰ dꞌitə kɨ́ kete lé ɓəy panè: «ꞌƁaɓe, ngonka Dabidɨ, ꞌoo kəmtondoo lə-ji ɓoo.» ");
INSERT INTO mge_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Beɓa Jeju təl a̰ nangɨ ɓa-dé, ə dəjɨ-dé panè: «Ri ɓá ꞌndigi kadɨ mꞌra mꞌadɨ-si wa?» ");
INSERT INTO mge_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dḛ dꞌilə-é-tɨ ꞌpanè: «ꞌƁaɓe, jꞌndigɨ kadɨ kəm-ji ya ꞌadɨ oo lo.» ");
INSERT INTO mge_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Beɓa ta ɔ̰̀ mḛḛ Jeju n̰a̰ kdɔ ta lə-dé adɨ ɔdɨ rɔ kəm-dé lé rəmə, tajinatɨ nè ya kəm-dé oo lo ə dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lokɨ dꞌisɨ dꞌɔw kɨ ɓebo Jorijalḛm-tɨ, ɓá ꞌree ꞌtḛḛ ngɔsi kɨ̀ ɓe kɨ́ Betpaje kɨ́ tò kàdɨ̀ mbal ka̰ kagɨ Olibiye-je-tɨ rəmə, Jeju ulə njéndó né-je liə joo panè: ");
INSERT INTO mge_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Ɔwi mḛḛ ngonɓe-tɨ kɨ́ tò nɔ̰̀-si-tɨ kin, rəmə tajinatɨ nè ya a kingəi ngon koro kɨ̀ kɔ̰-é, kɨ́ ꞌtɔ́-é nangɨ. Lokɨ ingəi-dé lé, ꞌtuti-dé, ə ꞌreei sə-dé adi-mi. ");
INSERT INTO mge_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ngà kinə dow dəjɨ-si ta dɔ-tɨ lé, idəi-é ꞌpainè: “ꞌƁaɓe ɓá ge-dé.” Rəmə lo-é-tɨ nè ya, à kin̰ə-dé kadɨ ꞌreei sə-dé.» ");
INSERT INTO mge_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Né-je kinlé ra-né bè kdɔ kadɨ ta kɨ́ njèpata kɨ́ ta Lubə-tɨ pa lé, né-é ra-né né. Ḛ panè: ");
INSERT INTO mge_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Idəi ngonmandɨ kɨ́ ɓebo Siyɔ̰-tɨ ꞌpainè: ꞌOo! Ngar lə-i isɨ ree rɔ-i-tɨ! To dow kɨ́ sɔl lɔm-lɔm! Ə isɨ dɔ kɔ̰ koro-tɨ! Isɨ dɔ ngon koro-tɨ kɨ́ to ngon nékal!» ");
INSERT INTO mge_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Njéndó né-je dꞌɔw ə ꞌra go ta-tɨ kɨ́ Jeju idə-dé lé, ");
INSERT INTO mge_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","adɨ ꞌree kɨ̀ kɔ̰ koro kɨ̀ ngon-é lé, ꞌlabɨ kubɨ-je lə-dé gidɨ-dé-tɨ, ɓá Jeju al isɨ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kosɨ dow-je n̰a̰ ya ꞌlabɨ kubɨ-je lə-dé dɔ rəbɨ-tɨ, dḛ kɨ́ ná̰-je ꞌtə́tɨ balkəm kagɨ-je ꞌlabɨ dɔ rəbɨ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kosɨ dow-je kɨ́ ꞌnjiyə nɔ̰̀-é-tɨ kɨ̀ dḛ kɨ́ ꞌnjiyə go-é-tɨ ꞌtur kəə boy-boy ꞌpanè: «Kɔsgajɨ kɨ dɔ ngonka Dabidɨ-tɨ! Kadɨ Lubə tɔr ndi-é dɔ dow-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe! Kɔsgajɨ tò dɔ Lubə-tɨ kɨ́ taá nṵ!» ");
INSERT INTO mge_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lokɨ Jeju ɔw tḛḛ mḛḛ ɓebo Jorijalḛm-tɨ lé, dow mḛḛ ɓe-je dꞌa̰y ngɔdɨ dɔ-na̰-tɨ wur-wur, ꞌdəjɨ-na̰ ta ꞌpanè: «To ná̰ ɓá ɔw ree wa?» ");
INSERT INTO mge_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rəmə kosɨ dow-je kɨ́ dꞌɔw siə dꞌilə-dé-tɨ ꞌpanè: «To Jeju kɨ́ Najarɛtɨ kɨ́ dɔnangɨ Galile-tɨ, njèpata kɨ́ ta Lubə-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jeju ɔw takəy-tɨ lə Lubə tubə njéragatɨ-je kɨ̀ njéndogɨ né-je lay. Ḛ titə tablə-je lə njémbəl-na̰ là-je kɨ̀ kagɨ kisɨ-je lə njéragatɨ də-je tilə. ");
INSERT INTO mge_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Beɓa Jeju idə-dé panè: «ꞌNdàngɨ ꞌpanè: “Kəy lə-m lé, dꞌa ɓa-é kəy pa ta kɨ̀ Lubə! Ngà sə̰i adi təl to kəy kisɨ njéɓogɨ-je!”» ");
INSERT INTO mge_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lo-é-tɨ kinlé, njékəmtɔ-je, kɨ̀ njémətɨ-je ꞌree rɔ Jeju-tɨ mḛḛ kəy-tɨ lə Lubə ə ḛ adɨ njékəmtɔ-je dꞋoo lo rəm, adɨ njémətɨ-je Ꞌnjiyə rəm. ");
INSERT INTO mge_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Beɓa wɔngɨ ra njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, kdɔtalə né-je kɨ́ majɨ-majɨ kɨ́ ɔr ndil dow-je kɨ́ Jeju ra rəm, wɔngɨ ra-dé kdɔtalə ngan-je kɨ́ ꞌtur kəə dɔ-é-tɨ, takəy-tɨ lə Lubə ꞌpanè: «Kɔsgajɨ tò dɔ ngonka Dabidɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Beɓa dḛ ꞌpa kɨ̀ Jeju panè: «Ta kɨ́ ngan-je ꞌpa kinlé ꞌoo majɨ ya tá?» Jeju ilə-dé-tɨ panè: «Oiyo, mꞌoo majɨ ya. Ngà ta kɨ́ mbete kɨ́ aa njay pa lé, sə̰i ꞌndói ooi nja káre al ya sar wa?» ꞌNdàngɨ-tɨ ꞌpanè: «Ngan-je kɨ́ tɔgɨ, kɨ̀ dḛ kɨ́ ta mba-tɨ kàrè, i ꞌra mbing ꞌadɨ ꞌtɔ́y-i.» ");
INSERT INTO mge_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Go-tɨ, Jeju in̰ə-dé tḛḛ mḛḛ ɓebo Jorijalḛm-tɨ ɔw tò Betani. ");
INSERT INTO mge_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lo aa go-tɨ kɨ̀ ndɔge ratɨ, lokɨ Jeju təl isɨ ree kɨ Jorijalḛm gogɨ ɓəy lé, ɓo ra-é. ");
INSERT INTO mge_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Beɓa ḛ oo kote ngangɨ rəbɨ-tɨ ɓá tɔɔ ɔw gin-tɨ rəmə mbi-é ya par ɓá tò. Jeju panè: «ꞌA kandɨ gogɨ nda̰ al ya sar.» Rəmə tajinatɨ nè ya kote lé tutɨ kurum. ");
INSERT INTO mge_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lokɨ njéndó né-je dꞌoo kɨ́ kote lé tutɨ kurum rəmə ta igə-dé səl adɨ ꞌdəjɨ Jeju ꞌpanè: «Kay! Ban ə tajinatɨ nè ya kote lé tutɨ kurum wa?» ");
INSERT INTO mge_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jeju ilə-dé-tɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; kinə ɔwi kɨ̀ kadmḛḛ, ɓá kinə ꞌtadi al ya sar lé, né kɨ́ mꞌra kɨ̀ kote kin par ɓá a kasi rai al. Lé mbal kin ya kàrè, kinə idəi-é ꞌpainè: “ꞌƆtɨ kɨ rangɨ lo kin-tɨ, ə ꞌɔw ꞌusɨ dan babo-tɨ”, kàrè né-é à ra né ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Né lay kɨ́ a pai ta kɨ̀ Lubə dəji-é-né kɨ̀ kadmḛḛ lé, a kingəi ya.» ");
INSERT INTO mge_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lokɨ Jeju ɔw takəy-tɨ lə Lubə isɨ ndó né dow-je rəmə, njékun dɔ njégugné-je lə Lubə kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌree rɔ-é-tɨ ꞌdəjɨ-é ꞌpanè: «Ná̰ ɓá adɨ-i tarəbɨ ɓá ꞌra-né né-je kinlé wa? Ná̰ adɨ-i tɔ́gɨ ɓá ꞌra-né wa?» ");
INSERT INTO mge_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jeju ilə-dé-tɨ panè: «Ma̰ kàrè mꞌa dəjɨ-si ta tɔ. Mꞌa dəjɨ-si ta káre ya par, ə́ kinə iləi-mi-tɨ rəmə, mꞌa kidə-si dow kɨ́ adɨ-m tɔ́gɨ mꞌra-né né-je kinlé tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","«Ná̰ ɓá ulə Ja̰ adɨ ra dow-je batḛm wa? To Lubə ɓá ulə-é əse to dow-je wa?» Ngà dḛ ꞌtəl ꞌnajɨ-na̰ ta dan-dé-tɨ ꞌpanè: «Kinə jꞌpainè: “To Lubə ɓá ulə-é” rəmə, ḛ à təl dəjɨ-ji panè: “Ngà kdɔ ri ɓá adi-é mḛḛ-si al wa?” ");
INSERT INTO mge_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ə kinə jꞌidəi-é jꞌpainè: “To dow-je ɓá dꞌulə-é” kàrè, à kḭ to ta dɔ-ji-tɨ, kdɔtalə kosɨ dow-je ꞌgə kɨ́ Ja̰ lé, to njèpata kɨ́ ta Lubə-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Beɓa ꞌree dꞌidə Jeju ꞌpanè: «Jḛ jꞌgə al.» Jeju təl panè: «Majɨ, ma̰ ya kàrè, nda̰ bè ɓá mꞌa kidə-si dow kɨ́ adɨ-m tɔ́gɨ mꞌra-né né-je kinlé al tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jeju təl idə-dé ɓəy panè: Ta ri ɓá sə̰i ꞌgɨri dɔ poy ta-tɨ kɨ́ mꞌa kɔr kin wa? Dingəm káre bè ɔw kɨ̀ ngan-je kɨ́ dingəm joo. Ḛ ɔw rɔ ḛ kɨ́ dɔsa̰y-tɨ idə-é panè: «Ngon-m, ɓone ɔw ꞌra kullə mḛḛ ndɔr nduu-tɨ lə-m adɨ-m.» ");
INSERT INTO mge_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ḛ idə-é panè: «Mꞌa kɔw al.» Ngà go-tɨ rəmə, tagɨr kɨ́ majɨ ree dɔ-é-tɨ, adɨ ḭ ɔw mḛḛ ndɔr nduu-tɨ lə bɔbɨ-é lé. ");
INSERT INTO mge_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bɔbɨ-é ɔw rɔ ngon-é-tɨ kɨ́ njèkungɨ-tɨ joo idə-é ko ta kɨ́ káre kin ya tɔ. Ḛ idə bɔbɨ-é panè: «Oiyo, bɔbɨ-m, mꞌa kɔw ya.» Ngà ḛ mbatɨ kɔw. ");
INSERT INTO mge_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dan ngan-je-tɨ kɨ́ joo kinlé, ḛ kɨ́ ra ɓá ra ndigɨ lə bɔbɨ-é lé wa? Dḛ dꞌilə-é-tɨ ꞌpanè: «Ḛ kɨ́ dɔsa̰y.» Beɓa Jeju təl idə-dé panè: Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ njétaalambo-je kɨ̀ kaya dené-je dꞌa tḛḛ nɔ̰̀-si-tɨ kete mḛḛ kɔ̰ɓe-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kdɔtalə Ja̰ kɨ́ njèra dow-je batḛm ree rɔ-si-tɨ, ɔjɨ-si rəbɨ né ra kɨ́ njururu kadɨ njiyəi-tɨ, rəmə sə̰i adi-é mḛḛ-si al. Ngà njétaalambo-je, kɨ̀ kaya dené-je ɓá dꞌadɨ-é mḛḛ-dé. Ngà sə̰i lé, ooi né kin kɨ̀ kəm-si bè ya kàrè, ꞌmbati kin̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ kdɔ kadɨ-é mḛḛ-si. ");
INSERT INTO mge_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jeju ilə-dé-tɨ panè: Ooi gosta kɨ́ rangɨ ɓəy ə́n. Dow káre bè uwə nduu, ɔr gali dɔ-tɨ, ra ɓe dɔ ər-tɨ kdɔ mbore-né man nduu lé rəm, ur pal ngəm lo titɨ, ɓəy ɓá adɨ njérakullə-é-je dꞌuwə siə dɔ-é kadɨ ꞌra kullə dɔ-tɨ, ə ɔtɨ ɔw mba. ");
INSERT INTO mge_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lokɨ na̰y kijə kandɨ nduu asɨ ngá lé, ḛ ulə ngannjékullə-je liə rɔ njéndɔr nduu-je-tɨ lé, kadɨ ꞌtaa kɨ́ ꞌliə ꞌree-né dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngà njérakullə ndɔr nduu-je dꞌuwə ngannjékullə-je lé, ə ꞌtində káre mbukɨ-mbukɨ, ꞌtɔl ḛ kɨ́ káre ə ꞌtilə ḛ kɨ́ káre kɨ̀ ər ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Beɓa ꞌɓa njèndɔr nduu lé, təl ulə dḛ kɨ́ rangɨ kɨ́ kɔr-dé itə dḛ kɨ́ kete lé ɓəy. Rəmə ko né kɨ́ ꞌra kɨ̀ dḛ kɨ́ kete lé ya ꞌtəl ꞌra sə-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta tɔl ta-é-tɨ rəmə, ulə ngon-é ya rɔ-dé-tɨ, ə gɨr panè: «To ngon-m adɨ dꞌa ɓəl gidɨ-é.» ");
INSERT INTO mge_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngà lokɨ njérakullə ndɔr nduu-je dꞌoo ngon-é lé isɨ ree rəmə dꞌidə-na̰ ta dan-dé-tɨ ꞌpanè: «Ooi ngon-é kɨ́ ndɔ-é à to njènéndubə lé ə́ ɔw ree ɔngɨ! ꞌReei adɨ jꞌtɔli-é kadɨ néndubə liə təl to kɨ́ ꞌlə-ji.» ");
INSERT INTO mge_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Beɓa dꞌuwə-é tḛḛ siə mḛḛ ndɔr nduu-tɨ kɨ ndaa-tɨ ə ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Beɓa Jeju dəjɨ-dé panè: Lokɨ ꞌɓa njèndɔr nduu à ree lé, ri ɓá à ra kɨ̀ njérakullə ndɔr nduu-je kinlé wa? ");
INSERT INTO mge_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dḛ dꞌilə-é-tɨ ꞌpanè: À tɔl njémḛḛndul-je kanlé tɔl kɨ́ tò kəmtondoo n̰a̰. Ngá ɓá à təl kɔy dḛ kɨ́ rangɨ kɨ́ dꞌa kadɨ-é kandɨ nduu lé, kɨ̀ dɔ na̰y-é na̰y-é kdɔ kində-dé ta-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɓəy ɓá Jeju ilə-dé-tɨ panè: Sə̰i ꞌndói ta kinlé mḛḛ mbete-tɨ kɨ́ aa njay nja káre ooi al ya sar wa? ꞌNdàngɨ-tɨ ꞌpanè: «Ər kɨ́ njékində kəy-je dꞌilə pɨrɨngɨ kɔgɨ lé, ɓá təl to ər kɨ́ majɨ kɨ́ sul kəy-tɨ.» Né kinlé to kullə ra ꞌƁaɓe. Ngà kɨ rɔ-ji-tɨ rəmə, to nékɔjɨ. ");
INSERT INTO mge_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Gin-é kin ɓá Jeju idə-dé-né panè: Lubə à taa kɔ̰ɓe liə ji-si-tɨ, kdɔ təl-né kadɨ gin dow-je kɨ́ rangɨ, kɨ́ dꞌa ra kullə-é majɨ. ");
INSERT INTO mge_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Dow kɨ́ rá-rá kɨ́ tḛḛ usɨ dɔ ər-é-tɨ kinlé, rɔ-é à tə́tɨ ɗɛkɨ-ɗɛkɨ rəm, ɓá dow kɨ́ ər kinlé usɨ dɔ-é-tɨ kàrè à lər-é lər-lər rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lokɨ njékun dɔ njégugné-je lə Lubə kɨ̀ Parisi-je dꞌoo gosta kɨ́ Jeju pa kinlé bè rəmə, dḛ ꞌgə kɨ́ ḛ pa ta kinlé sɔbɨ-né dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Beɓa dḛ ꞌsangɨ kəm rəbɨ-je kdɔ kuwə Jeju, ya ngà dḛ ꞌɓəl kosɨ dow-je kɨ́ ꞌgə-é majɨ kɨ́ ḛ to njèpata kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeju un gosta kɨ́ rangɨ ya ɓəy pa-né ta kɨ̀ dow-je panè: ");
INSERT INTO mge_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kɔ̰ɓe kɨ́ dɔra̰-tɨ tò titɨ-na̰ kɨ̀ ta lə ngar kɨ́ ra nékuso n̰a̰ kdɔ taana̰ lə ngon-é bè. ");
INSERT INTO mge_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngar lé ulə ngannjékullə-je go dow-je-tɨ kɨ́ ꞌɓa-dé kdɔ nékuso kɨ́ lo taana̰-tɨ lé. Ngà dowbé-je lé ꞌmbatɨ ree. ");
INSERT INTO mge_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ḛ təl ulə ngannjékullə-je kɨ́ rangɨ ya ɓəy panè: Ɔwi idəi dow-je kɨ́ ꞌɓa-dé lo nékuso kɨ́ lo taana̰-tɨ lé ꞌpainè: «Mꞌɔsɨ dɔ nja né-je natɨ lay ngá. Mꞌtɔl mangɨ-je lə-m, kɨ̀ nékul-je lə-m kɨ́ rɔ-dé tò mbul-mbul, adɨ nékuso tò nangɨ lay ngá, ə́ ꞌreei kdɔ nékuso kɨ́ lo taana̰-tɨ lé.» ");
INSERT INTO mge_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bè ya kàrè, usɨ-dé dɔ ɓa-tɨ kɨ́ ꞌɓa-dé lé al, adɨ ná̰-ná̰ ya ɔw lo liə kɨ́ mḛḛ ndigɨ. Dḛ kɨ́ ná̰-je dꞌɔw ndɔrɔ lə-dé ə dḛ kɨ́ dan-tɨ-je dꞌɔw lo ra gatɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ə ndəgɨ-dé-je tɔ rəmə, dꞌuwə ngannjékullə-je lé dꞌulə kəm-dé ndoo ɓəy ɓá ꞌtɔl-dé dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Né kin ra adɨ wɔngɨ ra ngar lé n̰a̰. Beɓa ulə njérɔ-je liə, adɨ dꞌɔw ꞌtɔl dowbé-je kinlé rəm, ɓá ꞌró ɓebo lə-dé rúkɨ-rúkɨ dɔ-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Go-tɨ, təl idə ngannjékullə-je liə panè: Nékuso tò ngɔsi. Ngà dow-je kɨ́ ꞌɓa-dé lo taana̰-tɨ lé ɓá ꞌto dow-je kɨ́ ꞌtuwə ree al. ");
INSERT INTO mge_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ə́ ɔti ɔwi tagajɨ rəbɨ-je-tɨ, ꞌɓai dow-je lay ya kɨ́ a kingəi-dé, kdɔ kadɨ ꞌree lo nékuso-tɨ kɨ́ lo taana̰-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Beɓa ngannjékullə-je lé dꞌɔtɨ dꞌɔw ta gajɨ rəbɨ-je-tɨ ə ꞌɓa dow-je lay ya kɨ́ dꞌingə-dé, njémḛḛndul-je, kɨ̀ njémḛḛmajɨ-je, ꞌree sə-dé adɨ dow-je ꞌrusɨ mḛḛ kəy nékuso kɨ́ lo taana̰-tɨ lé njḭ-njḭ. ");
INSERT INTO mge_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ngà lokɨ ngar ree andɨ mḛḛ kəy-tɨ kdɔ koo dow-je kɨ́ ꞌree lo nékuso-tɨ kɨ́ lo taana̰-tɨ lé rəmə, kəm-é usɨ dɔ dingəm-tɨ káre kɨ́ isɨ lo nékuso-tɨ kɨ́ lo taana̰-tɨ kɨ̀ kubɨ-é rɔ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Beɓa ngar lé dəjɨ-é panè: Nam-m, ban ɓá ꞌree lo kin-tɨ nal kulə kubɨ-é rɔ-i-tɨ wa? Ngà dingəm lé tḛḛ ta-é ilə-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Beɓa ngar idə ngannjékullə-je liə panè: Ɔti uwəi dow kin ꞌtɔ́i ji-é-je kɨ̀ nja-é-je njim-njim ə iləi-é ndaga lo-tɨ kɨ́ ndul ndḭ-ndḭ. Ḛ ɓá to lo kɨ́ à nɔ̰-tɨ rəm, à kuso ngangɨ-é titɨ məgəgə-məgəgə rəm. ");
INSERT INTO mge_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bè ya tɔ, dḛ kɨ́ Lubə ꞌɓa-dé lé, kɔr-dé n̰a̰. Ngà dḛ kɨ́ ḛ mbətɨ-dé ɓá ꞌto kɨ́ ndḛ bè. ");
INSERT INTO mge_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisi-je dꞌɔw dꞌɔjɨ-na̰ ta kdɔ sangɨ kəm rəbɨ kuwə Jeju kɨ̀ ta kɨ́ ta-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Beɓa dꞌulə njéndó né-je lə-dé rəm, ɓá kutɨ dow-je lə Erodɨ rɔ Jeju-tɨ kadɨ ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, jꞌgə kɨ́ i lé ꞌto njèpata kɨ́ tɔgrɔ-tɨ rəm, i ꞌisɨ ꞌɔjɨ dow-je rəbɨ lə Lubə kɔjɨ kɨ́ tɔgrɔ-tɨ rəm, ɓá i lé ꞌɓəl kəm dow al rəm, kdɔ i ꞌoo majɨ lə dow kɨ́ taga nè kin al. ");
INSERT INTO mge_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ə́n ə́ idə-ji tagɨr lə-i kɨ́ sɔbɨ dɔ ta kin adɨ jꞌoo: «To tó-é kadɨ dow ugə lambo lə ngar Sejar əse to tó-é al wa?» ");
INSERT INTO mge_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngà Jeju gə tagɨr kɨ́ majɨ al kɨ́ mḛḛ-dé-tɨ adɨ idə-dé panè: «Sə̰i njékədkəm dow-je kanlé! Kdɔ ri ɓá ꞌsangi kadɨ ooi ta kɨ́ mḛḛ-m-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɔji-mi là kɨ́ dow-je dꞌisɨ dꞌugə-né lambo lé adi-mi mꞌoo.» Beɓa dḛ dꞌun ka̰ là dꞌɔjɨ-é. Ngá ɓá ḛ dəjɨ-dé panè: ");
INSERT INTO mge_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","«To dɔ ná̰ kɨ̀ ri ná̰ ɓá tò-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rəmə dḛ dꞌilə-é-tɨ ꞌpanè: «To dɔ Sejar kɨ̀ ri-é.» Ngá ɓá ḛ təl idə-dé panè: «Né lə Sejar ə adi Sejar, ngà né lə Lubə rəmə adi Lubə tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta kɨ́ Jeju ilə-dé-tɨ lé ɔr ndil-dé adɨ dꞌin̰ə-é dꞌɔw lo lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rəmə mḛḛ ndɔ-é-tɨ kin ya, Sadusi-je kɨ́ ꞌto njépanè tɔsɨ ndəl kində lo tḛḛ goto lé ꞌree rɔ Jeju-tɨ ə ꞌdəjɨ-é ta ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Njèndó dow-je né, ta kɨ́ Moiyijɨ pa ə́n: Kinə dow taa dené ɓá ojɨ siə ngon al ɓəy ya ə oy rəmə, kadɨ ngonkɔ̰-é taa dené ndubə lé, ində-né ko-é. ");
INSERT INTO mge_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ngà kinə ngankɔ̰-na̰-je siri dan-ji-tɨ nè je bè, ɓá ḛ kɨ́ dɔsa̰y taa dené ə́ ojɨ siə ngon al ɓəy ya ə oy in̰ə dené lé adɨ ngonkɔ̰-é. ");
INSERT INTO mge_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ḛ kɨ́ njèkungɨ-tɨ joo lé kàrè bè ya rəm, ɓá njèkungɨ-dé-tɨ mutə kàrè bè ya sar ngankɔ̰-na̰-je kɨ́ siri dꞌoy-né lay, ");
INSERT INTO mge_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ɓá dené-é lé kàrè oy-né go-dé-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ndɔ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé se, dené kinlé à to ne ná̰ dan-dé-tɨ kɨ́ siri kinlé wa? Kdɔtalə dḛ ꞌtaa-é ya lay. ");
INSERT INTO mge_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Beɓa Jeju ilə-dé-tɨ panè: «Sə̰i uri wale, kdɔ sə̰i ꞌgəi mḛḛ ta kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay lé al rəm, ɓá ꞌgəi tɔ́gɨ Lubə al rəm. ");
INSERT INTO mge_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kdɔtalə ndɔ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé, taana̰ à goto. Dow-je dꞌa kisɨ titɨ-na̰ kɨ́ malayka-je dꞌisɨ-né dɔra̰-tɨ kin bè. ");
INSERT INTO mge_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ta kɨ́ Lubə pa sə-si mḛḛ mbete-tɨ liə sɔbɨ-né dɔ tɔsɨ ndəl kində lo tḛḛ lé, sə̰i ꞌndói nja káre ooi al wa? Lubə pa mḛḛ mbete-tɨ liə panè: ");
INSERT INTO mge_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mꞌto Lubə lə Abrakam, mꞌto Lubə lə Isakɨ kɨ̀ Lubə lə Jakobɨ. Adɨ Lubə lé, to Lubə lə dow-je kɨ́ dꞌoy al, ngà to Lubə lə dow-je kɨ́ dꞌisɨ kəm.”» ");
INSERT INTO mge_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kosɨ dow-je kɨ́ dꞌoo néndó lə Jeju lé, néndó liə ɔr ndil-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lokɨ Parisi-je dꞌoo kɨ́ Jeju uwə ta Sadusi-je lé, dḛ ꞌkəw-na̰ ");
INSERT INTO mge_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","rəmə dow káre dan-dé-tɨ kɨ́ to njèndó dow-je ndukun, ndigɨ koo ta kɨ́ mḛḛ Jeju-tɨ adɨ dəjɨ-é panè: ");
INSERT INTO mge_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Njèndó dow-je né: Dan ndukun-je-tɨ lé, ḛ kɨ́ rá ɓá to kɨ́ boy itə madɨ-é-je wa? ");
INSERT INTO mge_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Beɓa Jeju ilə-é-tɨ panè: ꞌA ndigɨ ꞌƁaɓe Lubə lə-i kɨ̀ mḛḛ-i kɨ́ káre-rè, kɨ̀ ndil-i lay, ɓá kɨ̀ tagɨr lə-i lay rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ḛ ɓá to ndukun kɨ́ dɔsa̰y kɨ́ boy itə madɨ-é-je lay. ");
INSERT INTO mge_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndukun kɨ́ njèkungɨ-tɨ joo kɨ́ tana̰ siə bè tɔ ə́n: ꞌA ndigɨ dow madɨ-i tana̰ kɨ̀ rɔ-i bè. ");
INSERT INTO mge_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndukun-je lə Moiyijɨ lay rəm, ɓá néndó-je lə njépata-je kɨ́ ta Lubə-tɨ lay kin ya ꞌtò gin tɔ́gɨ-tɨ lə ndukun-je kɨ́ joo kinlé. ");
INSERT INTO mge_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lokɨ Parisi-je ꞌkəw-na̰ lé, Jeju dəjɨ ta panè: ");
INSERT INTO mge_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ta ri ɓá ꞌgɨri dɔ Kristɨ-tɨ lé wa? Kristɨ to ngonka ná̰ wa? Dḛ dꞌilə-é-tɨ ꞌpanè: To ngonka Dabidɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Beɓa Jeju dəjɨ-dé ɓəy panè: Ngà ra ban ɓəy ɓá Ndil Lubə ra kullə mḛḛ Dabidɨ-tɨ adɨ ḛ kàrè ɓa-é ꞌƁaɓe ɓəy wa? Kdɔtalə Dabidɨ ya panè: ");
INSERT INTO mge_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ꞌƁaɓe Lubə idə ꞌƁaɓe lə-m panè: ꞌRee isɨ dɔ jikɔl-m-tɨ, sar kadɨ mꞌtəl njéba-je lə-i gin tɔ́gɨ-i-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ngà kɨ́ Dabidɨ ɓa Kristɨ ꞌƁaɓe lé, Kristɨ à to ngonka Dabidɨ ban ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lo-é-tɨ kinlé, dow kɨ́ dan-dé-tɨ kɨ́ asɨ kilə ta Jeju-tɨ goto. Beɓa kḭ dɔ gangɨ ndɔ-é-je-tɨ kinlé, dow kɨ́ ɓo dəjɨ ta Jeju ra-é ya goto ngá. ");
INSERT INTO mge_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Beɓa Jeju idə kosɨ dow-je, dḛ kɨ̀ njéndó né-je liə panè: ");
INSERT INTO mge_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ndukun-je kɨ́ Lubə adɨ Moiyijɨ ndàngɨ lé, njéndó dow-je ndukun-je, kɨ̀ Parisi-je ɓá ꞌto njékɔr mḛḛ-é kadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","To tó-é kadɨ ooi ta lə-dé, kadɨ ꞌrai tó mindɨ-dé-tɨ berere-berere. Ngà ndajɨ ɓá ꞌndaji kullə ra-dé al, kdɔtalə né kɨ́ dꞌisɨ ꞌndó dow-je lé, dḛ ꞌtəl rɔ-dé go-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dḛ lé, né-je kɨ́ ɔy kɨ́ lo kutɨ-é nga̰ ya ꞌtɔ́ ꞌtində dɔ dow-je-tɨ, ngà dḛ rəmə ngon ji-dé ya kàrè ꞌndigɨ kulə gətɨ-né sə-dé al. ");
INSERT INTO mge_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Né lay kɨ́ dḛ ꞌra lé, ꞌra kdɔ kadɨ dow-je dꞌoo-dé-né. Beɓa dḛ ꞌtɔ́ ndukun-je lə Lubə ngan ku né-je-tɨ, ɓá ꞌtɔ́ ta bagɨ-dé-je-tɨ, kɨ̀ natɨ nɔ̰̀-dé-je-tɨ, dꞌu kubɨ-je lə-dé dꞌadɨ boy yul-yul, dꞌɔsɨ kulə sul-é-je-tɨ dꞌadɨ ngal puu-puu. ");
INSERT INTO mge_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dḛ ꞌsangɨ lokisɨ kɨ́ kete nɔ̰̀ dow-je-tɨ lo nékuso ra na̰y-je-tɨ rəm, ꞌndigɨ lokisɨ kɨ́ kete mḛḛ kəykəwna̰-je-tɨ rəm, ");
INSERT INTO mge_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ꞌndigɨ kadɨ dow-je ꞌra-dé lapiya kunta-na̰ lokosɨ-je-tɨ rəm, ɓá ꞌndigɨ kadɨ dow-je ꞌɓa-dé njéndó dow-je né tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngà sə̰i lé, adi dow-je ꞌɓa-si njéndó dow-je né al, kdɔtalə njèndó-si né, ḛ káre-rè bè, ngà sə̰i lé, ꞌtoi ngankɔ̰-na̰-je lay. ");
INSERT INTO mge_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ꞌƁai dow kɨ́ dɔnangɨ-tɨ nè bɔbɨ-si al, kdɔtalə Bɔbɨ-si ra káre-rè, adɨ to njèkisɨ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Adi dow ɓa-si njékun dɔ-je al, kdɔtalə Kristɨ lé, ḛ ya kɨ̀ kár-é to njèkun dɔ-si. ");
INSERT INTO mge_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dow kɨ́ to ꞌboy dan-si-tɨ lé, à to ngonnjèkullə lə-si. ");
INSERT INTO mge_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dow kɨ́ ɔjɨ rɔ-é lé, dꞌa kulə dɔ-é kɨ nangɨ, ngà dow kɨ́ sɔl dɔ-é ɓá dꞌa kitə dɔ-é kɨ taá tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je, kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je! Kdɔtalə sə̰i uti tarəbɨ kandɨ kɔ̰ɓe-tɨ kɨ́ dɔra̰-tɨ dɔ dow-je-tɨ. Sə̰i ya kàrè ɔwi-tɨ al rəm, ɓá dow-je kɨ́ ꞌndigɨ kɔw-tɨ kàrè, sə̰i ɔgi-dé rəm. ");
INSERT INTO mge_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je! Kdɔtalə sə̰i ꞌkəəi né-je kɨ́ mḛḛ kəy-tɨ lə njéngɔwkoy-je kər-kər ə ꞌpai ta kɨ̀ Lubə adi ngal n̰a̰-n̰a̰ kdɔ kadɨ dow-je dꞌoo-si-né. Beɓa ta kɨ́ gangɨ kɨ́ nga̰ n̰a̰ ya à ree dɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je. Kdɔtalə sə̰i asi lo-je kɨ́ dɔnangɨ-tɨ nè, kɨ̀ dan babo-je nakɨ-nakɨ kdɔ kadɨ ingəi dow kɨ́ a təli-é jipɨ-tɨ. Ngà lokɨ ingəi-é adi təl jipɨ ngá rəmə, adi dowbé təl to dow kɨ́ tuwə kɔw dan pər-tɨ kɨ́ tò sartagangɨ tɔ̀y-si nja joo ɓəy! ");
INSERT INTO mge_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njékəmtɔ-je kɨ́ njékɔr nɔ̰̀ dow-je. Sə̰i lé ꞌpainè: Kinə dow ubɨ rɔ-é kɨ̀ kəy lə Lubə, ɓá ra né-é al kàrè to kare. Ngà kinə dow ubɨ rɔ-é kɨ̀ lɔr kɨ́ mḛḛ kəy-tɨ lə Lubə rəmə, kadɨ dowbé ra né-é lé ya ɓane. ");
INSERT INTO mge_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sə̰i mbə́ dow-je kɨ́ njékəmtɔ-je kan! Né kɨ́ ra ɓá boy n̰a̰ wa? Lɔr ɓá boy n̰a̰ əse kəy lə Lubə kɨ́ njètəl lɔr né kɨ́ aa njay-tɨ ɓá boy n̰a̰ wa? ");
INSERT INTO mge_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sə̰i ꞌpai ɓəy ꞌpainè: Kinə dow ubɨ rɔ-é kɨ̀ logugɨ né lə Lubə, ɓá ra né-é al kàrè to kare. Ngà kinə dow ubɨ rɔ-é kɨ̀ kadkare kɨ́ to logugɨ né-tɨ lə Lubə rəmə, kadɨ dowbé ra né-é lé ya ɓane. ");
INSERT INTO mge_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sə̰i njékəmtɔ-je kanlé! Né kɨ́ ra ɓá to né kɨ́ boy n̰a̰ wa? Kadkare ɓá boy n̰a̰ əse logugɨ né lə Lubə kɨ́ ra kadkare adɨ təl né kɨ́ aa njay ɓá boy n̰a̰ wa? ");
INSERT INTO mge_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yən, dow kɨ́ ubɨ rɔ-é kɨ̀ logugɨ né lə Lubə lé, ḛ ubɨ rɔ-é kɨ̀ logugɨ né lə Lubə ya rəm, ɓá ḛ ubɨ rɔ-é kɨ̀ né-je lay kɨ́ tò logugɨ né-tɨ lə Lubə lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dow kɨ́ ubɨ rɔ-é kɨ̀ kəy lə Lubə lé, ḛ ubɨ rɔ-é kɨ̀ kəy lə Lubə ya rəm, ɓá ḛ ubɨ rɔ-é kɨ̀ Lubə kɨ́ njèkisɨ mḛḛ kəy-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dow kɨ́ ubɨ rɔ-é kɨ̀ dɔra̰ lé, ḛ ubɨ rɔ-é kɨ̀ kalikɔ̰ɓe lə Lubə rəm, ɓá ḛ ubɨ rɔ-é kɨ̀ Lubə kɨ́ njèkisɨ dɔ kalikɔ̰ɓe-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je. Kdɔtalə sə̰i lé mbikam-je lə-si kɨ́ ətɨ majɨ-majɨ, kɨ̀ mbikamná̰y-je, kɨ̀ né ndɨr ná̰y-je kin kàrè, sə̰i ɔri káre dan kɨ́ dɔgɨ-tɨ adi Lubə. Rəmə né ra kɨ́ njururu, kɨ̀ koo kəmtondoo, kɨ̀ ka̰dɔndi-tɨ kɨ́ to né-je kɨ́ boy n̰a̰ mḛḛ ndukun-tɨ lé ɓá sə̰i ooi kɨ né al. Né-je kin ɓá lé à to kullə ra-si, ɓá ndəgɨ né-je kinlé kàrè, sə̰i a tusi kin̰əi al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sə̰i njékəmtɔ-je kɨ́ njékɔr nɔ̰̀ dow-je kan! Sə̰i lé tò titɨ-na̰ né kɨ́ ngon kuu kɨ́ sḛ bè kin ɓá sə̰i ooi-é dan man ka̰y-si-tɨ adɨ uni-é kɔgɨ, ngà rəmə Jambal kɨ́ boy kin ɓá sə̰i ooi-é al, adɨ uyi-é mḛḛ-si-tɨ mɨrɨkɨ. ");
INSERT INTO mge_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je! Sə̰i lé, gidɨ kobɨ-je kɨ̀ gidɨ tasa-je ɓá ꞌtogi adɨ aa majɨ rəmə, né-je kɨ́ rusɨ mḛḛ-é njḭ-njḭ lé, to né ɓogɨ-je kɨ̀ né-je kɨ́ ingəi kɨ́ go rəbɨ ɓo né-je kɨ́ majɨ al kɨ́ ra-si. ");
INSERT INTO mge_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","I Parisi kɨ́ njèkəmtɔ! ꞌTogɨ mḛḛ kobɨ ya pá rəmə gidɨ-é kàrè à kaa majɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je! Sə̰i lé, ꞌtiti-na̰ kɨ̀ dɔɓadɨ-je kɨ́ dow-je ꞌra gidɨ-é kɨ́ ndaa-tɨ né kɨ̀ pɔ̰ɔ̰, adɨ nda mbəy-mbəy majɨ, ngà mḛḛ-é rəmə singə dow-je kɨ́ dꞌoy, kɨ̀ né-je kɨ́ ndum ɓá rusɨ bè kin. ");
INSERT INTO mge_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sə̰i lé kàrè, bè ya tɔ. Ta kəm dow-je-tɨ lé, ꞌrai rɔ-si tana̰ kɨ̀ dow-je kɨ́ njéra né njururu-je bè, ya ngà kədkəm dow-je, kɨ̀ né ra kɨ́ majɨ al ya rusɨ mḛḛ-si njḭ-njḭ. ");
INSERT INTO mge_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je kɨ̀ Parisi-je kɨ́ ꞌtoi njékədkəm dow-je! Kdɔtalə ꞌrai dɔɓadɨ njépata-je kɨ́ ta Lubə-tɨ adi majɨ rəm, ɓá ꞌtijəi ndajɨ né-je kɨ́ majɨ-majɨ dɔɓadɨ njéra né njururu-je-tɨ ");
INSERT INTO mge_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ə ꞌpainè: Kinə jḛ ɓá jꞌisɨ kaglo-tɨ lə ka-ji-je kɨ́ ndɔkɨ lé rəmə, jꞌa kində rɔ-ji natɨ sə-dé kdɔ tɔl njépata-je kɨ́ ta Lubə-tɨ lé al. ");
INSERT INTO mge_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Beɓa ta pa-si kɨ̀ kullə ra-si-je ya ꞌtɔji-né kɨ́ ꞌtoi nganka njétɔl njépata-je kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bè rəmə, to tagajɨ kullə ra ka-si-je lé ya uni tin ə́ jè ꞌrai ꞌtɔli ta-é! ");
INSERT INTO mge_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sə̰i kɨ́ mḛḛ-si majɨ al titɨ-na̰ kɨ̀ mḛḛ pii-je bè kan! Sə̰i lé, ta kɨ́ gangɨ kdɔ kadɨ dow-je dꞌɔw-né dan pər-tɨ kɨ́ tò sartagangɨ lé, a tḛḛi kəm-tɨ rá wa? ");
INSERT INTO mge_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gin-é kin ɓá Lubə panè: Yən, mꞌa kulə njépata-je kɨ́ ta-m-tɨ, kɨ̀ njégosɨ-je, kɨ̀ njéndó dow-je ndukun-je lə-m kɨ́ tɔgrɔ-tɨ rɔ-si-tɨ. Sə̰i a tɔli dḛ kɨ́ ná̰-je rəm, a ɓəi dḛ kɨ́ dan-tɨ-je kagdəsɨ-tɨ rəm, a tindəi dḛ kɨ́ ná̰-je kɨ̀ ndəy marɔw mḛḛ kəykəwna̰-je-tɨ lə-si sə̰i jipɨ-je lé rəm, ɓá a kuləi kəm dḛ kɨ́ ná̰-je ndoo kadɨ dꞌa̰y-na̰ kɨ̀ lo-lo rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Né-je kinlé à tò bè kdɔ kadɨ ta məsɨ njéra né kɨ́ njururu kɨ́ a̰y nangɨ puu-puu kɔgɨ kinlé tò dɔ-si-tɨ. Un kutɨ-é dɔ məsɨ Abɛl-tɨ kɨ́ to dow kɨ́ njèra né kɨ́ njururu sar tḛḛ-né dɔ məsɨ Jakari-tɨ kɨ́ to ngon lə Baraki. Jakari lé, sə̰i ꞌtɔli-é mbunə̰ kəy-tɨ lə Lubə kɨ̀ logugɨ né kɨ́ to lo kilə kadkare kadɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ ta kɨ́ gangɨ kɨ́ sɔbɨ dɔ njétɔl dow-je lé à kusɨ dɔ dow-je-tɨ kɨ́ ngɔsnè kin. ");
INSERT INTO mge_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ꞌWa! Sə̰i dow-je kɨ́ Jorijalḛm! ꞌWa! Sə̰i dow-je kɨ́ Jorijalḛm! Sə̰i ꞌtoi njétɔl njépata-je kɨ́ ta Lubə-tɨ, njétilə dow-je kɨ́ Lubə ulə-dé rɔ-si-tɨ kɨ̀ ər tɔl-dé. Nja kandangɨ-kandangɨ ə́ mꞌndigɨ kəw-si kɨ rɔ-m-tɨ tana̰ kɨ́ kɔ̰ kunjə kəw-né ngan-é gin bagɨ-é-tɨ kin bè, ə́ ꞌmbati! ");
INSERT INTO mge_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ooi majɨ, kəy lə-si à tokɨ tusɨ kin̰ə kɨ dɔ-si-tɨ nɔ̰ɔ̰! ");
INSERT INTO mge_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mꞌa kidə-si rəsɨ. Kḭ nè kɔw kɨ kete kinlé, a kooi-mi kɨ̀ kəm-si gogɨ nda̰ al ya sar kaglo-tɨ kɨ́ a pai-né painè: Kadɨ Lubə tɔr ndi-é dɔ dow-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe! ");
INSERT INTO mge_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lokɨ Jeju ɔtɨ takəy-tɨ lə Lubə isɨ ɔw rəmə, njéndó né-je liə ꞌree rɔ-é-tɨ ꞌtɔjɨ-é ꞌpanè: «ꞌOo kəy lə Lubə kɨ́ ꞌra dꞌadɨ ndajɨ-é-je majɨ-majɨ kin.» ");
INSERT INTO mge_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Beɓa Jeju idə-dé panè: «Ooi né-je kin lay ya al wa? Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dꞌa titə tilə káre káre, ngon ər ya kàrè à tò dɔ madɨ-é-tɨ lo kin-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Beɓa lokɨ Jeju ɔw isɨ dɔ mbal ka̰ kagɨ Olibiye-je-tɨ rəmə, njéndó né-je liə ꞌree dꞌingə-é kɨ̀ kár-é ꞌdəjɨ-é ꞌpanè: «ꞌIdə-ji, ndɔ kɨ́ rá ɓá né-é-je kinlé à ra né wa? Əse ri ɓá à tɔjɨ ndɔ ree-i lé wa? Ə ri tɔ ɓá à tɔjɨ dɔbəy ndɔ kɨ́ à ree lé wa?» ");
INSERT INTO mge_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeju ilə-dé-tɨ panè: «Indəi kəmkaa dɔ rɔ-si-tɨ, adi dow ədɨ-si al. ");
INSERT INTO mge_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kdɔ dow-je n̰a̰ ya dꞌa kun ri-m kində dɔ-dé-tɨ ə dꞌa panè: “Dḛ ya ꞌto Kristɨ lé.” Beɓa dꞌa kədɨ-né dow-je n̰a̰ kur-dé-né wale. ");
INSERT INTO mge_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sə̰i a kooi poy rɔ-je kɨ̀ ká rɔ-je. Ooi go rɔ-si nè mḛḛ-si à kḭ gangɨ man. Kdɔ, lé ban-ban ya kàrè né-je kinlé à ra né ya; ngà kḛ ɓá à to sɔ̰y né-je al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gin dow-je madɨ dꞌa kḭ rɔ kɨ̀ gin dow-je kɨ́ madɨ, kɔ̰ɓe káre à kḭ rɔ kɨ̀ kɔ̰ɓe kɨ́ káre, ɓo à kɔ̰̀ rəm, dɔnangɨ à yəkɨ kɨ̀ lo-lo rəm. ");
INSERT INTO mge_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Né-je kinlé à tò titɨ-na̰ kɨ̀ kulə gin ndo kɨ́ ra dené bè. ");
INSERT INTO mge_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Beɓa dꞌa kun dɔ-si kadɨ dow-je dꞌadɨ-si kɔ̰̀ rəm, kadɨ ꞌtɔl-si rəm. Gin dow-je lay ya dꞌa kɔsɨ-si kɨ̀ ta kdɔ ta lə-m. ");
INSERT INTO mge_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ndɔ-é-tɨ kinlé, dow-je n̰a̰ ya dꞌa kilə kadmḛḛ lə-dé kɔgɨ, dꞌa kun dɔ-na̰ rəm, ɓá dꞌa kɔsɨ-na̰ ta rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dow-je n̰a̰ dꞌa ree ɓa rɔ-dé njépata-je kɨ́ ta Lubə-tɨ ə dꞌa kur dow-je n̰a̰ wale. ");
INSERT INTO mge_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Né ra kɨ́ majɨ al à kɔw kəm-é kete-kete, gin-é kin ɓá ndigna̰ lə dow-je n̰a̰ ya à təl sɔl-né. ");
INSERT INTO mge_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngà dow kɨ́ uwə rɔ-é nga̰ sar tḛḛ sɔ̰y-é-tɨ ə à kajɨ. ");
INSERT INTO mge_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə kinlé, dꞌa kilə mbḛ-é dɔnangɨ-tɨ nè lay kdɔ kadɨ gin dow-je lay dꞌoo kɨ̀ mbi-dé, ɓəy ngá ɓá dɔbəy ndɔ lé à ree ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Lokɨ a kooi nékɔbɨ, kɨ̀ né kɨ́ tò n̰ḛ lo-tɨ kɨ́ aa njay titɨ kɨ́ ndɔkɨ Daniyel njèpata kɨ́ ta Lubə-tɨ pa-né lé rəmə, kadɨ dow kɨ́ isɨ ndó mbete kinlé gə mḛḛ-é majɨ rəm, ");
INSERT INTO mge_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ɓá kadɨ dow-je kɨ́ dꞌisɨ dɔnangɨ Jude-tɨ dꞌa̰y dꞌɔw dan mbal-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dow kɨ́ isɨ dɔ kəy-tɨ kàrè kadɨ ur nangɨ kdɔ kɔw kəy kun né madɨ al ngá, ");
INSERT INTO mge_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","rəm dow kɨ́ a̰ ndɔrɔ kàrè, kadɨ ree ɓee un kubɨ kul liə al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ə́ mḛḛ ndɔ-é-je-tɨ kin tujɨ kɨ́ à kusɨ dɔ dené-je-tɨ kɨ́ njésəm kɨ̀ dḛ kɨ́ dꞌisɨ dꞌadɨ mba ngan-je à tò ban ə́n ə! ");
INSERT INTO mge_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞌPai ta kɨ̀ Lubə n̰a̰ kdɔ kadɨ ndɔ ka̰y lə-si tò na̰y kul-tɨ al rəm, kadɨ tò ndɔ taakoo-tɨ lə-ji jə̰i jipɨ-je al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kdɔ ndɔ-je kinlé, à to ndɔ kɔ̰̀ kɨ́ dum natɨ. Ə to kɔ̰̀ kɨ́ lo kində gin dɔnangɨ-tɨ nṵ sar ɓone kin ya kàrè, dow oo nja káre al ɓəy rəm, ɓá dow à koo ga̰-é gogɨ al ya sar rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kinə ꞌƁaɓe gangɨ ta ndɔ-je kinlé adɨ gɔjɨ al rəmə, dow kɨ́ à kajɨ ya goto. Ngà ḛ à kadɨ ndɔ kɔ̰̀-je kɨ́ dum natɨ kinlé gɔjɨ, kdɔ dow-je kɨ́ ḛ mbətɨ-dé adɨ ꞌto dow-je liə. ");
INSERT INTO mge_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kinə dow idə-si panè: “Kristɨ a̰ nè” əse “a̰ yó” kàrè, ꞌtaai ta liə al. ");
INSERT INTO mge_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kdɔtalə njéɓa rɔ-dé Kristɨ-je, kɨ̀ njéɓa rɔ-dé njépata-je kɨ́ ta Lubə-tɨ dꞌa kḭ kdɔ ra nékɔjɨ-je, kɨ̀ né mbəli-je kdɔ kədɨ-né dow-je. Dꞌa ra bè sangɨ-né koo se dꞌa kur dow-je kɨ́ Lubə mbətɨ-dé lé wale kare wa. ");
INSERT INTO mge_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ma̰ mꞌidə-si ngá ə́n! ");
INSERT INTO mge_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kinə dꞌidə-si ꞌpanè: Ooi, Kristɨ, dow kɨ́ Lubə mbətɨ-é, a̰ diləlo-tɨ nɔ̰ɔ̰ rəmə ɔwi lo-é-tɨ al əse lokɨ dow idə-si panè: Ooi, ḛ ɓɔyɔ rɔ-é nè tin, kàrè ꞌtaai ta liə al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kdɔ ree Ngon lə dow lé, à tana̰ kɨ̀ təlndi kɨ́ ḭ lo kubə kàdɨ̀-tɨ ɔw njal lo kur kàdɨ̀-tɨ kin bè. ");
INSERT INTO mge_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lo kɨ́ nin tò-tɨ lé, lo-é ya mal-je dꞌa kəw-na̰-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Go ndɔ kɔ̰̀-je-tɨ kɨ́ dum natɨ kinlé ya rəmə, Londul à kutɨ kəm kàdɨ̀! Na̰y à nda al! Kərwəḭ-je kɨ́ dɔra̰-tɨ dꞌa tusɨ nangɨ! Tɔ́gɨ-je kɨ́ dɔra̰-tɨ à yəy yəkɨ-yəkɨ!» ");
INSERT INTO mge_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Beɓa nékɔjɨ lə Ngon lə dow à tḛḛ dɔra̰-tɨ, rəmə gin kojɨ-je lay kɨ́ dɔnangɨ-tɨ nè dꞌa ndingə rɔ-dé. Dḛ dꞌa koo Ngon lə dow à kḭ dɔra̰-tɨ kisɨ ree dan kilndi-tɨ, kɨ̀ tɔ́gɨ kɨ́ n̰a̰ rəm, ɓá dan riɓa-tɨ kɨ́ n̰a̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lokɨ ndi təbɨ mbanga à ɓa dɔra̰-tɨ pṵ́ṵ́-pṵ́ṵ́ rəmə, Ngon lə dow à kulə malayka-je liə kadɨ ꞌkəw dow-je lay kɨ́ ḛ mbətɨ-dé kɨ dɔ kum dɔnangɨ kɨ́ sɔ kin lay kɨ natɨ. Dꞌa kḭ ngangɨ dɔnangɨ-tɨ kɨ́ káre kɔw njal tḛḛ ngangɨ-é-tɨ kɨ́ káre.» ");
INSERT INTO mge_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Uni néndó mḛḛ gosta-tɨ kɨ́ dɔ kote-tɨ kin ooi. Kote lé lokɨ balkəm-é-je təl tò mbəl ɓá mbi-é tubə dɔ-tɨ lé, sə̰i ꞌgəi kɨ́ na̰y ɓà nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bè ya tɔ, lokɨ ooi kɨ́ né-je lay kinlé isɨ ra né rəmə, kadɨ ꞌgəi kɨ́ Ngon lə dow a̰ tarəbɨ-tɨ pèrèrè ngá. ");
INSERT INTO mge_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow-je kɨ́ dꞌisɨ kəm nè kin, dꞌa koy lay al ya né-je kinlé à ra né. ");
INSERT INTO mge_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dɔra̰-je kɨ̀ dɔnangɨ kin dꞌa goto, ngà ta-je lə-m lé à goto al ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ta lə ndɔ əse kàdɨ̀ ree lə Ngon lə Lubə lé, dow kɨ́ gə goto, malayka-je kɨ́ dɔra̰-tɨ kàrè ꞌgə al rəm, Ngon lə Lubə lé ya kàrè gə al rəm, ngà Bɔbɨ-é ya kɨ̀ kár-é ɓá gə. ");
INSERT INTO mge_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Né kɨ́ ndɔkɨ ra né kaglo-tɨ lə Nuwe lé, ga̰-é ya à ra né ndɔ ree-tɨ lə Ngon lə dow lé tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndɔkɨ kete kadɨ man bəlɨm ree taa lo lay lé, dow-je dꞌuso né-je, dꞌa̰y né-je, ꞌtaa-na̰-je, dꞌadɨ ngan-dé-je ꞌtaa-na̰-je, sar ndɔ-tɨ kɨ́ Nuwe ɔw-né mḛḛ bato-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mḛḛ dow-je oy səl dɔ rɔ-dé-tɨ adɨ man bəlɨm ree tɔl-dé lay. Bè ya tɔ, ndɔ kɨ́ Ngon lə dow à ree lé, lo à tujɨ puktu-puktu. ");
INSERT INTO mge_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Beɓa dow-je joo dꞌa̰ mḛḛ ndɔr-tɨ kɨ́ káre kàrè, Lubə à kun kɨ́ káre ə à kin̰ə kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dené-je joo dꞌa̰ dꞌur né mḛḛ bɨr-tɨ kɨ́ káre kàrè, Lubə à kun kɨ́ káre ə à kin̰ə kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ə́n ə́ isi kəm dɔ rɔ-si-tɨ, kdɔ sə̰i ꞌgəi ndɔ ree ꞌƁaɓe lə-si al. ");
INSERT INTO mge_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kadɨ ꞌgəi né kin majɨ: Kinə ꞌɓa njèkəy gə dɔkàdɨ̀ kɨ́ ndɔɔ kɨ́ njèɓogɨ à ree-né lé, ḛ à kisɨ kəm ɓɨ à kin̰ə-é kadɨ ɔw mḛḛ kəy-tɨ liə al. ");
INSERT INTO mge_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gin-é kin ɓá sə̰i kàrè, isi dɔ nja-si-tɨ, kdɔ Ngon lə dow lé à ree dɔkàdɨ̀-tɨ kɨ́ sə̰i ꞌgɨri dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ná̰ ɓá to ngonnjèkullə kɨ́ njèra né kɨ́ tɔgrɔ-tɨ kɨ́ to njèkəmtutɨ wa? To ḛ kɨ́ ꞌɓa-é ində-é dɔ madkullə-je-tɨ liə kdɔ kadɨ oo go-dé kɨ̀ nékuso kɨ̀ dɔkàdɨ̀-é dɔkàdɨ̀-é. ");
INSERT INTO mge_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngonnjèkullə kɨ́ ꞌɓa-é təl ree mḛḛ kəy-tɨ liə ɓá ingə-é ta kullə-tɨ titɨ-na̰ bè lé, to njènékumə̰. ");
INSERT INTO mge_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ ꞌɓa-é à kin̰ə nékingə-é-je lay mḛḛ ji-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngà kinə to ngonnjèkullə kɨ́ majɨ al lé, à pa mḛḛ-é-tɨ panè: «ꞌƁa-m à təl ree kalangɨ al ɓəy» ");
INSERT INTO mge_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ɓá ḛ a̰ ká tində madkullə-je-tɨ liə, kɨ̀ ká kuso né-tɨ kɨ̀ ká ka̰y né-tɨ kɨ̀ gɔ̰yibɨ-je rəmə, ");
INSERT INTO mge_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ꞌɓa-é à təl ree kubə-é nangɨ busɨ ndɔ-tɨ kɨ́ ḛ ində mḛḛ-é dɔ-tɨ al rəm, dɔkàdɨ̀-tɨ kɨ́ ḛ à gə al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ḛ à kində-é kində kɔjɨ kɨ́ nga̰ n̰a̰ ə à kadɨ-é ingə kɔ̰̀ natɨ kɨ̀ njékədkəm dow-je lo-tɨ kɨ́ dꞌa nɔ̰-tɨ rəm, ɓá dꞌa kuso ngangɨ-dé titɨ məgəgə-məgəgə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Beɓa kɔ̰ɓe kɨ́ dɔra̰-tɨ titɨ-na̰ kɨ̀ poyta lə nganmandɨ-je kɨ́ dɔgɨ kɨ́ ꞌtilə kəm njèdené kɨ̀ lampɨ-je lə-dé ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dḛ kɨ́ mḭ ꞌto njékəmtutɨ al-je ə dḛ kɨ́ mḭ tɔ ɓá ꞌto njékəmtutɨ-je tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Njékəmtutɨ al-je lé dꞌɔw kɨ̀ lampɨ-je lə-dé nal kun ubɨ-é ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngà njékəmtutɨ-je kɨ́ mḭ tɔ rəmə, dꞌɔw kɨ̀ lampɨ-je lə-dé kɨ̀ ku ubɨ-je lə-dé ji-dé-tɨ ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ngà lokɨ njèdené ree kalangɨ al ɓəy lé, nganmandɨ-je lé lay ya kɔ ra-dé adɨ ꞌto ɓi. ");
INSERT INTO mge_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Beɓa dan lo bapɨ rəmə, ndi dow ɓa boy panè: Ooi! Njèdené lé ree ngá, ə́ ḭi taá ꞌtiləi kəm-é. ");
INSERT INTO mge_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Beɓa nganmandɨ-je lé lay ya dꞌḭ dɔ ɓi-tɨ, dꞌoo go lampɨ-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Njékəmtutɨ al-je lé ꞌdəjɨ njékəmtutɨ-je ꞌpanè: Adi-ji ubɨ lə-si lé sḛ-sḛ sə-si kdɔ lampɨ-je lə-ji lé dꞌisɨ dꞌoy. ");
INSERT INTO mge_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Njékəmtutɨ-je lé ꞌpanè: «Á̰-à̰, ubɨ lə-ji lé, jḛ ya kàrè à kasɨ-ji rá ɓá jꞌa kay kadɨ-si wa? Ɔwi ꞌndogi ꞌlə-si ə sotɨ.» ");
INSERT INTO mge_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nganmandɨ-je kɨ́ njékəmtutɨ al-je lé, dꞌɔtɨ dꞌɔw adɨ ꞌnà̰y lo ndogɨ ubɨ-tɨ lé ya ɓəy rəmə, njèdené lé ree, adɨ nganmandɨ-je kɨ́ mḭ kɨ́ dꞌisɨ dɔ nja-dé-tɨ lé, dꞌɔw siə kəy lo taana̰-tɨ, adɨ dꞌutɨ takəy ta-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Go-tɨ, nganmandɨ-je kɨ́ njékəmtutɨ al-je lé ꞌree, ꞌnɔ̰ boy-boy ꞌpanè: «ꞌƁaɓe, ꞌƁaɓe, ꞌtḛḛ takəy adɨ-ji.» ");
INSERT INTO mge_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngà njèdené lé panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; mꞌgə-si al.» ");
INSERT INTO mge_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Beɓa Jeju ilə dɔ ta-tɨ kin panè: «Isi kəm dɔ rɔ-si-tɨ, kdɔ sə̰i ꞌgəi ndɔ-é al rəm, ꞌgəi dɔkàdɨ̀-é al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kɔ̰ɓe lə Lubə à tò titɨ-na̰ kɨ̀ ta lə dingəm káre kɨ́ isɨ ɔw mba ə ɓa ngannjékullə-je liə, ə in̰ə nékingə-é ji-dé-tɨ ɓá ɔtɨ ɔw mba. ");
INSERT INTO mge_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ḛ adɨ ḛ kɨ́ káre lɔr mbu mḭ, adɨ ḛ kɨ́ rangɨ lɔr mbu joo, ə adɨ njèkungɨ-tɨ mutə lə-dé lɔr mbu káre. Ḛ adɨ-dé kɨ́ go tɔ́gɨ-dé-tɨ, ngá ɓá ɔtɨ ɔw mba. ");
INSERT INTO mge_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dow kɨ́ njètaa lɔr mbu mḭ lé, ɔtɨ tajinatɨ nè ya ɔw təl-né ji-é ə ingə kɨ́ rangɨ dɔ-tɨ mbu mḭ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dow kɨ́ njètaa lɔr mbu joo lé kàrè, ɔw təl-né ji-é, ə ingə kɨ́ rangɨ dɔ-tɨ mbu joo ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngà njètaa lɔr mbu káre lé, ḛ ɔw ndər ɓe dubɨ-né lɔr lə ꞌɓa-é lé. ");
INSERT INTO mge_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lokɨ dɔkaglo dəə dɔ-tɨ n̰a̰ ngá lé, ꞌɓa-dé təl ree kadɨ dꞌɔr go né-je liə dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dow kɨ́ njètaa lɔr mbu mḭ lé ree rɔ ꞌɓa-é-tɨ, tidə lɔr mbu mḭ kɨ̀ man-é dɔ-tɨ mbu mḭ ya tɔ, ə panè: «ꞌƁa-m, i ꞌadɨ-m lɔr mbu mḭ, ə ḛ kɨ́ rangɨ kɨ́ mꞌingə dɔ-tɨ ə́ ra mbu mḭ tɔ tin.» ");
INSERT INTO mge_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ꞌƁa-é idə-é panè: «Oiyo! ꞌTo ngonnjèkullə kɨ́ majɨ, njèra né kɨ́ tɔgrɔ-tɨ. Mꞌa kində-i dɔ né-je-tɨ kɨ́ n̰a̰, kdɔ ꞌto njèra né kɨ́ tɔgrɔ-tɨ mḛḛ né-tɨ kɨ́ ndḛ bè. ꞌRee ꞌra sə-m rɔnəl.» ");
INSERT INTO mge_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Go-tɨ, ngonnjèkullə kɨ́ njètaa lɔr mbu joo lé ree rɔ-é-tɨ panè: «ꞌƁa-m, i adɨ-m lɔr mbu joo, ə ḛ kɨ́ rangɨ kɨ́ mꞌingə dɔ-tɨ ə́ ra mbu joo tɔ tin.» ");
INSERT INTO mge_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Beɓa ꞌɓa-é idə-é panè: «Majɨ! I ꞌto ngonnjèkullə kɨ́ majɨ, njéra né kɨ́ tɔgrɔ-tɨ, i tɔsɨ kəm-i go né-tɨ kɨ́ ndḛ bè, beɓa mꞌa kində-i dɔ né-je-tɨ kɨ́ n̰a̰. ꞌRee ꞌra sə-m rɔnəl.» ");
INSERT INTO mge_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ta tɔl ta-é-tɨ, ngonnjèkullə kɨ́ njèkungɨ-dé-tɨ mutə kɨ́ taa lɔr mbu káre lé ree panè: «ꞌƁa-m, i lé mꞌgə kɨ́ ꞌto dow kɨ́ ꞌnga̰ n̰a̰: Lo kɨ́ i ꞌdubɨ né-tɨ al kàrè, i tətɨ-tɨ rəm, ɓá lo kɨ́ i ilə ko-tɨ al kàrè, i ijə ko-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ma̰ mꞌɓəl adɨ mꞌɔw mꞌdubɨ lɔr lə-i lé nangɨ. Yən! Né lə-i lé ə́n, ə́ ꞌtaa.» ");
INSERT INTO mge_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngà ꞌɓa-é idə-é panè: «I lé ꞌto ngonnjèkullə kɨ́ majɨ al, njèdabɨ! I gə kɨ́ ma̰ lé, lo kɨ́ mꞌdubɨ né-tɨ al kàrè, mꞌtətɨ-tɨ rəm, ɓá lo kɨ́ mꞌilə ko-tɨ al kàrè mꞌijə-tɨ rəm kinlé, ");
INSERT INTO mge_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","lé ꞌa kɔw kilə lɔr lə-m lé lo ngəm né-tɨ kdɔ kadɨ mꞌtəl mꞌree bè rəmə, lé mꞌa taa kɨ̀ man-é dɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Beɓa ꞌɓa-é panè: «Ɔti ꞌtaai lɔr kɨ́ ji-é-tɨ ə adi ḛ kɨ́ ɔw kɨ̀ lɔr mbu dɔgɨ lé dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kdɔ dow kɨ́ né tò ji-é-tɨ ɓá dꞌa kadɨ-é kɨ́ rangɨ dɔ-tɨ kadɨ isɨ dan majɨ-tɨ mburukɨ-mburukɨ, ngà dow kɨ́ né liə goto lé, kɨ́ ji-é-tɨ ya kàrè dꞌa taa. ");
INSERT INTO mge_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Beɓa ngonnjèkullə kɨ́ kare kɔgɨ bè kinlé, iləi-é ndaa-tɨ, lo-tɨ kɨ́ ndul ndḭ-ndḭ, lo kɨ́ ḛ à nɔ̰-tɨ rəm, à kuso ngangɨ-é-tɨ məgəgə-məgəgə rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Lokɨ Ngon lə dow à ree kɨ̀ riɓa liə kɨ́ n̰a̰ natɨ kɨ̀ malayka-je lé, ḛ à kisɨ dɔ kali riɓa-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gin dow-je lay kɨ́ dɔnangɨ-tɨ nè ya dꞌa kəw-na̰ nɔ̰̀-é-tɨ, ɓá ḛ à kɔr kəm dow-je gay-gay titɨ-na̰ kɨ́ njèkul né ɔr-né kəm batɨ-je kɨ̀ bin̰ə-je gay-gay kin bè. ");
INSERT INTO mge_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ḛ à kɔr batɨ-je kadɨ dꞌa̰ dɔ jikɔl-é-tɨ, ngà bin̰ə-je rəmə, ḛ à kadɨ dꞌa̰ dɔ-ji gəl-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bè ngá ɓá Ngar à kidə dow-je kɨ́ dɔ jikɔl-é-tɨ lé panè: «ꞌReei, sə̰i kɨ́ Bɔbɨ-m tɔr ndi-é dɔ-si-tɨ, andi kɔ̰ɓe-tɨ liə kɨ́ ḛ ya ra go-é lo kində gin dɔnangɨ-tɨ nṵ kdɔ ta lə-si. ");
INSERT INTO mge_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kdɔtalə sə̰i ɓá ndɔkɨ ɓo ra-m ə́ adi-mi né mꞌuso, kundə ra-m ə́ adi-mi man mꞌa̰y, mꞌto mba ə́ uwəi-mi kɨ rɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sə̰i ɓá ndɔkɨ kutɨ-m tò dum ə́ adi-mi kubɨ mꞌulə rɔ-m-tɨ, rɔ-m to-m ə́ ɔwi dɔ-m-tɨ, mꞌto dangay-tɨ ə́ ɔwi go-m-tɨ ooi-mi.» ");
INSERT INTO mge_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rəmə dow-je kɨ́ njéra né kɨ́ njururu lé dꞌa panè: «ꞌWa! ꞌƁaɓe, ndɔ kɨ́ rá-tɨ ɓá ɓo ra-i ə́ jꞌadɨ-i né uso əse kundə ra-i ə́ jꞌadi man a̰y wa? ");
INSERT INTO mge_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndɔ kɨ́ rá-tɨ ɓá ꞌto mba ə́ jꞌuwəi kɨ rɔ-ji-tɨ əse jꞌoo-i kɨ̀ kutɨ-i dum ə́ jꞌadɨ-i kubɨ ulə rɔ-i-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndɔ kɨ́ rá-tɨ ɓá rɔ-i to-i əse ꞌto dangay-tɨ ə́ jꞌɔw jꞌoo-i wa?» ");
INSERT INTO mge_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Beɓa Ngar à panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dɔkaglo-je lay ya kɨ́ ꞌrai né-je kinlé kɨ̀ dow káre dan ngan dow-je-tɨ kɨ́ sḛ-sḛ bè kɨ́ ꞌto ngankɔ̰-m-je kinlé, to ma̰ ya tɔ ə́ ꞌrai sə-m tin.» ");
INSERT INTO mge_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Go-tɨ, ḛ à təl kidə dḛ kɨ́ dɔ-ji gəl-é-tɨ lé panè: «Ɔti rangɨ ta-m-tɨ, sə̰i dow-je kɨ́ Bɔbɨ-m ində ndɔl dɔ-si-tɨ. Ɔwi dan pər-tɨ kɨ́ tò sartagangɨ kɨ́ tokɨ ra go-é kdɔ Sú dḛ kɨ̀ malayka-je liə. ");
INSERT INTO mge_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kdɔtalə sə̰i lé, ɓo ra-m kàrè, adi-mi né mꞌuso al rəm; kundə ra-m kàrè, adi-mi man mꞌa̰y al rəm; ");
INSERT INTO mge_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mꞌto mba kàrè, uwəi-mi kɨ rɔ-si-tɨ al rəm; kutɨ-m tò dum kàrè, adi-mi kubɨ mꞌulə al rəm; rɔ-m to-m əse mꞌto dangay-tɨ kàrè ɔwi go-m-tɨ al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Beɓa dḛ dꞌa panè: «ꞌWa! ꞌƁaɓe, ɓo ra-i ndɔ kɨ́ rá-tɨ əse kundə ra-i ndɔ kɨ́ rá-tɨ, ꞌto mba ndɔ kɨ́ rá-tɨ əse a̰ kutɨ-i dum ndɔ kɨ́ rá-tɨ, rɔ-i to-i ndɔ kɨ́ rá-tɨ əse ꞌto dangay-tɨ ndɔ kɨ́ rá-tɨ ɓá jꞌra sə-i al wa?» ");
INSERT INTO mge_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngar à təl kilə-dé-tɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dɔkaglo-je lay kɨ́ sə̰i ꞌrai kɨ̀ dow káre dan ngan dow-je kɨ́ sḛ-sḛ kin al lé, to ma̰ ya tɔ ə́ ꞌrai sə-m al tin.» ");
INSERT INTO mge_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Beɓa dḛ kɨ́ dɔ-ji gəl-é-tɨ lé, dꞌa kɔw dan kɔ̰̀-tɨ kɨ́ sartagangɨ, ngà njéra né kɨ́ njururu-je lé, ɓá dꞌa kɔw lo kiskəm-tɨ kɨ́ sartagangɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lokɨ Jeju tɔl ta néndó-je kinlé, ḛ idə njéndó né-je liə panè: ");
INSERT INTO mge_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Sə̰i ꞌgəi kɨ́ nà̰y ndɔ joo kadɨ ndɔ ra na̰y Pakɨ asɨ. Ə dꞌa kilə Ngon lə dow ji dow-je-tɨ kadɨ ꞌɓə-é kagdəsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Rəmə njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je dꞌuwə dɔ-na̰ lo gangta-tɨ panata lə Kayipɨ kɨ́ to burə dɔ njégugné-je lə Lubə ");
INSERT INTO mge_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ə dꞌun ndu-dé kadɨ ꞌra gosɨ dꞌuwə-né Jeju kdɔ kadɨ ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ya ngà dḛ ꞌtəl ꞌpanè: Kḛ ɓá jꞌa kuwəi-é ndɔ ra na̰y Pakɨ-tɨ lé al, nè kosɨ dow-je dꞌa kḭ ɓukɨ-na̰ dɔ-ji-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jeju isɨ mḛḛ ɓe-tɨ kɨ́ Betani, mḛḛ kəy-tɨ lə Simɔ̰ kɨ́ ndɔkɨ to njèbanjɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rəmə dené káre bè ree rɔ-é-tɨ kɨ̀ ubɨ kɨ́ ətɨ majɨ rəm, là-é n̰a̰ rəm, rusɨ ku kɨ́ ꞌra kɨ̀ ər kɨ́ ꞌɓa-é albatrə rəm ya ree mbəl dɔ Jeju-tɨ ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Njéndó né-je dꞌoo né kin bè rəmə, nəl-dé al, adɨ ꞌpanè: «Ə́ kin to né tujɨ kɨ́ ban ɓá tana̰ bè?» ");
INSERT INTO mge_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","To ubɨ kɨ́ lé jꞌa taa-né là kɨ́ tò ɓay-ɓay ya kdɔ ləbɨ njéndoo-je. ");
INSERT INTO mge_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeju gə ta kɨ́ dḛ ꞌpa lé, adɨ idə-dé panè: «Kdɔ ri ə́ sə̰i adi-né kɔ̰̀ dené kinlé bè wa? Ḛ ra né kɨ́ majɨ kdɔ ta lə-m. ");
INSERT INTO mge_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Njéndoo-je lé, dꞌa kisɨ sə-si nè kɨ̀ ndɔ-je lay, ngà ma̰ lé mꞌa kisɨ sə-si kɨ̀ ndɔ-je lay al. ");
INSERT INTO mge_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ubɨ kɨ́ dené kin ungɨ kinlé, tokɨ né kɨ́ ḛ ra rɔ-m-tɨ kdɔ dubɨ-m-né bè. ");
INSERT INTO mge_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ooi majɨ, mꞌa kidə-si rəsɨ; lo lay kɨ́ dɔnangɨ-tɨ nè kɨ́ dꞌa kilə mbḛ Poyta kɨ́ Majɨ kin titɨ lé, dꞌa kɔr poy né kɨ́ dené ra kinlé kadɨ mḛḛ dow-je ole-né dɔ-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Beɓa Judasɨ kɨ́ ꞌɓa-é Iskariyotɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé, ɔw ingə njékun dɔ njégugné-je lə Lubə ");
INSERT INTO mge_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ə idə-dé panè: Ri ɓá sə̰i ꞌndigi kadi-mi kadɨ mꞌilə-né Jeju lé ji-si-tɨ wa? Beɓa dḛ ꞌtidə ka̰ là kɔrmutə dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gangɨ ndɔ-é-tɨ kin ya, Judasɨ sangɨ kəm rəbɨ kɨ́ tuwə kilə-né Jeju ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ndɔ kɨ́ dɔsa̰y lə ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ lé, njéndó né-je lə Jeju ꞌree rɔ-é-tɨ ꞌdəjɨ-é ꞌpanè: «Lo kɨ́ rá ɓá i ꞌndigɨ kadɨ jꞌra nékuso Pakɨ-tɨ jꞌadɨ-i wa?» ");
INSERT INTO mge_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Beɓa Jeju idə-dé panè: «Ɔwi mḛḛ ɓebo-tɨ rɔ dow-tɨ kɨ́ bè kin … ə idəi-é tokɨ njèndó dow-je né panè: Dɔkaglo lə-m nà̰y sḛ bè; ə mꞌa kɔw kəy lə-i kdɔ ꞌra na̰y Pakɨ natɨ kɨ̀ njéndó né-je lə-m.» ");
INSERT INTO mge_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Beɓa njéndó né-je dꞌɔw ə ꞌra go ta-tɨ kɨ́ Jeju idə-dé, adɨ ꞌra nékuso Pakɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Beɓa ta kàdɨ̀ kur-tɨ lé, Jeju isɨ ta nékuso-tɨ kɨ̀ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lokɨ dꞌisɨ dꞌuso né lé Jeju panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dow káre dan-si-tɨ à kun dɔ-m.» ");
INSERT INTO mge_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Beɓa mḛḛkɔ̰̀ ra njéndó né-je adɨ ꞌdəjɨ-é káre-káre lay ꞌpanè: «ꞌƁaɓe, to ma̰ wa?» ");
INSERT INTO mge_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jeju ilə-dé-tɨ panè: «Ḛ kɨ́ ulə ji-é sə-m natɨ mḛḛ ba̰y-tɨ kin ya, ḛ ya à kun dɔ-m. ");
INSERT INTO mge_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngon lə dow lé à koy titɨ kɨ́ mbete kɨ́ aa njay pa-né ta kɨ́ sɔbɨ dɔ-é lé ya, ngà tujɨ ɓá à kusɨ dɔ dow-tɨ kɨ́ njèkun dɔ-é. Tò sotɨ kadɨ dꞌojɨ dowbé kinlé al!» ");
INSERT INTO mge_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Rəmə Judasɨ kɨ́ à kun dɔ Jeju lé, un ta dəjɨ-é panè: «Njèndó dow-je né, to ma̰ wa?» Jeju ilə-é-tɨ panè: «Ta ya tḛḛ ta-i-tɨ tin.» ");
INSERT INTO mge_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lokɨ dꞌisɨ ta nékuso-tɨ lé Jeju un mbə̀, ra oiyo Lubə, uwə gangɨ dana̰, adɨ njéndó né-je ə panè: «ꞌTaai usoi, ḛ kin to dajɨ rɔ-m.» ");
INSERT INTO mge_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Go-tɨ, un kobɨ kɨ́ man nduu tò-tɨ, ra oiyo Lubə, təl-né adɨ-dé ə panè: «Sə̰i lay ya a̰yi. ");
INSERT INTO mge_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kdɔ ḛ kin to məsɨ-m, məsɨ kulənojɨ natɨ kɨ̀ Lubə kɨ́ à kungɨ nangɨ kdɔ kosɨ dow-je, kdɔ kadɨ Lubə in̰ə-né go majal-je kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mꞌa kidə-si rəsɨ; kḭ nè kɔw kete kinlé, mꞌa ka̰y man nduu kin gogɨ al ya sar ndɔ-tɨ kɨ́ mꞌa ka̰y ḛ kɨ́ sigɨ sə-si kɔ̰ɓe-tɨ lə Bɔbɨ-m.» ");
INSERT INTO mge_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Go-tɨ, dꞌusɨ pa-je, ɓəy ɓá dꞌḭ dꞌɔw dɔ mbal ka̰ kagɨ Olibiye-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Beɓa Jeju idə njéndó né-je panè: «Ndɔɔ nè ya sə̰i a tusi-mi kin̰əi-mi kɔgɨ lay, kdɔ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: “Mꞌa tɔl njèkul batɨ-je! Rəmə batɨ-je dꞌa sane-na̰.”» ");
INSERT INTO mge_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngà Jeju təl ilə dɔ-tɨ panè: «Kḛ ɓá lokɨ mꞌa tɔsɨ ndəl kində lo tḛḛ lé, mꞌa kɔw ngəbɨ-si Galile.» ");
INSERT INTO mge_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyər idə-é panè: «Lé dow-je lay ya ꞌtusɨ-i dꞌin̰ə-i kɔgɨ kàrè, ma̰ bè lé mꞌa kin̰ə-i kɔgɨ nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Beɓa Jeju ilə-é-tɨ panè: «ꞌOo majɨ, mꞌa kidə-i rəsɨ; kɨ́ ndɔɔ nè-tɨ kin ya ꞌa najɨ panè ꞌgə-m al nja mutə ɓá kunjə à nɔ̰ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyər idə-é panè: «Kadɨ mꞌnajɨ ta mꞌpanè mꞌgə-i al lé, kɨ́ nja káre ya kàrè à tḛḛ ta-m-tɨ al. Lé asɨ kəm koy ya kàrè mꞌa koy sə-i.» Rəmə ndəgɨ njéndó né-je lay ꞌpa bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Beɓa dꞌɔtɨ dꞌɔw lo-tɨ kɨ́ ꞌɓa-é Getsemane, rəmə Jeju idə njéndó né-je panè: «Isi nangɨ nè, adɨ mꞌɔw ngərəngɨ nṵ mꞌpa ta kɨ̀ Lubə.» ");
INSERT INTO mge_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jeju adɨ Piyər kɨ̀ ngan lə Jebede joo dꞌɔw siə. Lo-tɨ kin ɓá mḛḛkɔ̰̀ kɨ̀ mḛḛ gangɨ man ulə gin ra Jeju. ");
INSERT INTO mge_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Beɓa ḛ idə-dé panè: «Mḛḛkɔ̰̀ ra-m asɨ koy; isi nangɨ nè ə ɔgi kəm-si ɓi sə-m.» ");
INSERT INTO mge_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngà lokɨ ḛ ɔtɨ kete sḛ lé, usɨ nangɨ, səbɨ takəm-é nangɨ ə pa ta kɨ̀ Lubə panè: «Bɔbɨ-m, kinə kəm rəbɨ tò nɔ̰ɔ̰ rəmə, ꞌitə kɔ̰̀ kɨ́ n̰a̰ kin kɨ rangɨ dɔ-m-tɨ. Lé bè ya kàrè, ꞌra kɨ́ go ndigɨ-tɨ lə-m ma̰ al; ngà kadɨ ꞌra kɨ́ go ndigɨ-tɨ lə-i i ya.» ");
INSERT INTO mge_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ḛ təl ree rɔ njéndó né-je-tɨ kɨ́ mutə lé rəmə, ingə-dé dɔ ɓi-tɨ. Beɓa idə Piyər panè: «Kadɨ ɔgi kəm-si ɓi sə-m kàdɨ̀ káre bè ya kàrè asi al wa? ");
INSERT INTO mge_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɔgi kəm-si ɓi ə ꞌpai ta kɨ̀ Lubə kdɔ kadɨ néna̰ tḛḛ dɔ-si-tɨ rəmə usi al. Ndil ndigɨ, ngà dajɨ rɔ dow ɓá tɔ́gɨ-é asɨ al.» ");
INSERT INTO mge_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jeju təl in̰ə-dé kɨ́ nja joo ɔw gogɨ pa ta kɨ̀ Lubə panè: «Bɔbɨ-m, kɔ̰̀-je kɨ́ n̰a̰ kinlé, kinə kəm rəbɨ kɨ́ kadɨ ꞌitə-né kɨ rangɨ kadɨ tḛḛ dɔ-m-tɨ al goto rəmə ꞌɔjɨ ndigɨ lə-i.» ");
INSERT INTO mge_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ḛ təl ree rɔ njéndó né-je-tɨ, rəmə ingə-dé dɔ ɓi-tɨ ya ɓəy; kəm-dé ɔy diriri adɨ lo kadɨ ꞌtḛḛ kəm-dé goto. ");
INSERT INTO mge_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jeju təl in̰ə-dé ɔw pa ta kɨ̀ Lubə kɨ́ nja mutə dɔ ta-je-tɨ kɨ́ káre lé ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Go-tɨ, təl ree rɔ njéndó né-je-tɨ idə-dé panè: «Uwəi rɔ-si ngá, ꞌtoi ɓi. Kàdɨ̀ asɨ; dꞌa kilə Ngon lə dow ji njéramajal-je-tɨ ngá. ");
INSERT INTO mge_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ḭi taá adɨ jꞌɔwi! Ooi, dow kɨ́ njèkilə-m ji-dé-tɨ lé isɨ ree ngá.» ");
INSERT INTO mge_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lokɨ Jeju a̰ pa ta lé kɨ pa ya ɓəy rəmə, Judasɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé, ree kɨ̀ kosɨ dow-je kɨ́ dꞌutɨ kiyərɔ-je, kɨ̀ kagɨ-je ji-dé-tɨ. Njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ɓá dꞌulə dowbé-je kinlé. ");
INSERT INTO mge_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Njèkun dɔ Jeju lé, tɔjɨ-dé né kɨ́ nꞌa ra kadɨ ꞌgə-né Jeju lé panè: «Dow kɨ́ mꞌa ra-é lapiya, kuwə-é kàdɨ̀-m-tɨ kin ya to ḛ, ə́n ə́ jè uwəi-é.» ");
INSERT INTO mge_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lokɨ Judasɨ ree ngɔsi rɔ Jeju-tɨ lé, ḛ panè: «Lapiya, njéndó dow-je né!» Rəmə uwə Jeju kàdɨ̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Beɓa Jeju ilə-é-tɨ panè: «Nam-m, né kɨ́ ꞌree kdɔ ra lé ꞌra tá.» Beɓa dow-je kɨ́ ꞌree lé, dꞌɔtɨ dꞌuwə Jeju. ");
INSERT INTO mge_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngà dow káre dan njéndó né-je-tɨ lə Jeju ɔr kiyərɔ tugə-né mbi ngonnjèkullə lə burə dɔ njégugné-je lə Lubə ndətɨ ya gangɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Beɓa Jeju idə-é panè: «ꞌUlə kiyərɔ lə-i saba-é-tɨ gogɨ; kdɔ dow-je kɨ́ ꞌtɔl madɨ-dé-je kɨ̀ kiyərɔ lé, dꞌa koy yo kiyərɔ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I ꞌgə kɨ́ kinə mꞌnɔ̰ ɓa Bɔbɨ-m lé, tajinatɨ nè ya à kulə kɨ̀ kosɨ njérɔ-je kɨ́ ꞌto malayka-je asɨ ɓudɔgɨ-dɔgɨ lo n̰a̰ al wa? ");
INSERT INTO mge_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngà tokɨ tò titɨ-na̰ bè lé, ta kɨ́ Lubə pa mḛḛ mbete-tɨ kɨ́ aa njay lé, né-é à ra né ɓan wa?» ");
INSERT INTO mge_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Beɓa Jeju təl idə kosɨ dow-je panè: «Sə̰i ooi-mi kɨ bɔkaya dow ɓá ꞌreei kɨ̀ kiyərɔ-je, kɨ̀ salangɨ-je kdɔ kuwəi-mi-né wa? Ndɔ-je lay ya mꞌisɨ sə-si takəy-tɨ lə Lubə, mꞌndó né dow-je ya ə́ sə̰i uwəi-mi al. ");
INSERT INTO mge_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngà né-je lay kinlé, tò bè kdɔ kadɨ ta-je kɨ́ njépata-je kɨ́ ta Lubə-tɨ ꞌndàngɨ lé, né-é ra né.» Beɓa njéndó né-je lay ya dꞌin̰ə Jeju dꞌa̰y-na̰. ");
INSERT INTO mge_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dḛ kɨ́ dꞌuwə Jeju lé, dꞌɔw siə ɓe lə Kayipɨ kɨ́ to burə dɔ njégugné-je lə Lubə. Njéndó dow-je ndukun-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌkəw-na̰ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyər njiyə go-é-tɨ jan-jan adɨ rəbɨ-é rà ɗəkɨ siə, ɔw sar tḛḛ panata lə burə dɔ njégugné-je lə Lubə kinlé. Ḛ andɨ mḛḛ kəy-tɨ isɨ natɨ kɨ̀ ngannjékullə-je kadɨ nꞌoo se né-je kin à tɔl ta-é ban-ban wa? ");
INSERT INTO mge_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je ꞌsangɨ kadɨ dow-je ꞌtə́tɨ ta ta Jeju-tɨ kadɨ nꞌiləi-né ta dɔ-é-tɨ kdɔ kadɨ nꞌgangi-né ta koy dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dow-je n̰a̰ ya ꞌree ꞌtə́tɨ ta ta-é-tɨ, ya ngà dꞌingə ta kɨ́ asɨ kadɨ ꞌtɔl-é-né al. Beɓa dɔbəy-é-tɨ, dow-je joo ꞌtḛḛ ə ");
INSERT INTO mge_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ꞌpanè: «Dow kanlé ndɔkɨ panè: “Mꞌa tɔɔ kəy lə Lubə kin ə ndɔ mutə ya mꞌa kində gogɨ lay.”» ");
INSERT INTO mge_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Beɓa burə dɔ njégugné-je lə Lubə ḭ taá pa ta kɨ̀ Jeju panè: «Se i ꞌa kilə ta-je-tɨ kɨ́ dow-je kin ꞌtilə dɔ-i-tɨ kinlé al wa?» ");
INSERT INTO mge_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ta-é kɨ́ ngarara ya kàrè ḛ tḛḛ ilə-é-né-tɨ al. Burə dɔ njégugné-je təl idə Jeju ɓəy panè: «Mꞌdəjɨ-i kɨ̀ ri Lubə kɨ́ njèkisɨ kəm, kadɨ ꞌubɨ rɔ-i ya ilə-ji-né ta-tɨ kin adɨ jꞌoo: “I lé, kɨ́ tɔgrɔ-tɨ bè lé ꞌto Kristɨ, Ngon lə Lubə lé wa?”» ");
INSERT INTO mge_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jeju ilə-é-tɨ panè: «Ta ya tḛḛ ta-i-tɨ tin. Rəm ɓá, kɨ́ ngɔsnè-tɨ kin ya a kooi Ngon lə dow à kisɨ dɔ jikɔl Lubə-tɨ kɨ́ njètɔ́gɨ rəm, ɓá a kooi-é kɨ́ à kḭ dɔra̰-tɨ kisɨ ree dan kilndi-tɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Beɓa burə dɔ njégugné-je lə Lubə tuwə kubɨ kɨ́ rɔ-é ḛ-tɨ ya gangɨ batɨ-batɨ ə panè: «Ḛ pa ta kɔbɨ kɨ̀ Lubə! Jꞌɔwi ndoo koo ta ta dow kɨ́ rangɨ-tɨ ɓəy ɓan! Ta kɔbɨ kɨ́ ḛ pa kɨ̀ Lubə kinlé, sə̰i ooi kɨ̀ mbi-si. ");
INSERT INTO mge_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta ri ə́ ꞌgɨri dɔ-tɨ wa?» Beɓa dow-je dꞌilə-é-tɨ ꞌpanè: «Koy-é ya ɓá to tó-é.» ");
INSERT INTO mge_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Beɓa dḛ ꞌtubə yoro kəm-é-tɨ rəm, ꞌɓɨr ji-dé ꞌtində-é-né rəm, ɓá dḛ kɨ́ ná̰-je ꞌtində mbɔ́-é ə ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«I ə́ nè ꞌto Kristɨ lé, ꞌadɨ Lubə idə-i ə ꞌpa adɨ jꞌoo sé to ná̰ ɓá ində-i wa?» ");
INSERT INTO mge_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyər isɨ nangɨ mḛḛ ndògɨ-tɨ ndaa-tɨ. Beɓa ngonnjèkullə kɨ́ dené káre ree rɔ-é-tɨ pa siə panè: «I ya kàrè ꞌto njèkɔw kɨ̀ Jeju kɨ́ to dow kɨ́ Galile kinlé tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngà Piyər najɨ nɔ̰̀ dow-je-tɨ lay panè: «I lé, ta ri ɓá ꞌndigɨ pa kàrè ma̰ mꞌgə al.» ");
INSERT INTO mge_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngà lokɨ ɔtɨ isɨ ɔw kɨ tarəbɨ-tɨ kɨ ndaa-tɨ bè rəmə, ngonnjèkullə kɨ́ dené kɨ́ rangɨ oo-é ə idə dow-je kɨ́ dꞌa̰ lo-é-tɨ nɔ̰ɔ̰ panè: «Ḛ kɔngɨ lé, to njèkɔw kɨ̀ Jeju kɨ́ Najarɛtɨ lé ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyər təl najɨ rangɨ ya ɓəy panè: «Mꞌubɨ rɔ-m mꞌadɨ-si! Dingəm kanlé mꞌgə-é al!» ");
INSERT INTO mge_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sḛ go-tɨ, dow-je kɨ́ dꞌa̰ lo-é-tɨ lé dꞌɔtɨ ꞌree rɔ Piyər-tɨ dꞌidə-é ꞌpanè: «Tɔgrɔ-tɨ ya, i lé, ꞌto kɨ́ dan-dé-tɨ ya! Ta pa-i ya kàrè tɔjɨ lo kɨ́ ḭ-tɨ rəm.» ");
INSERT INTO mge_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Rəmə Piyər ilə bɔbɨ ndi-é nangɨ najɨ ə ubɨ-né rɔ-é panè: «Kinə mꞌədɨ-si rəmə, kadɨ Lubə ində-m ɔjɨ-m ya rɔ́tɨ! Mꞌubɨ rɔ-m mꞌadɨ-si, mꞌgə dingəm kanlé al ɓoo.» Beɓa lo-é-tɨ nɔ̰ɔ̰ ya kunjə nɔ̰ ");
INSERT INTO mge_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ə mḛḛ Piyər ole dɔ ta-tɨ kɨ́ Jeju idə-é panè: «Kunjə à nɔ̰ al ya ɓəy rəmə ꞌa najɨ panè: ꞌGə-m al, ꞌgə-m al ya nja mutə.» Beɓa Piyər tḛḛ ndaa-tɨ ə nɔ̰ kɨ̀ mḛḛkɔ̰̀ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɨ̀ ndɔge ratɨ ya, njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je dꞌingə-na̰ ə dꞌun ndu-dé kadɨ nꞌtɔli Jeju kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beɓa ꞌtɔ́-é njim-njim ngá ɓá dꞌɔw siə dꞌilə-é ji Gubərnər-tɨ kɨ́ ri-é lə Pilatɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lokɨ Judasɨ kɨ́ un dɔ Jeju lé, oo kɨ́ ꞌgangɨ ta dɔ Jeju-tɨ kadɨ ꞌtɔl-é rəmə, mḛḛ uwə-é kɨ̀ ta, adɨ təl kɨ̀ là ndogɨ Jeju kɨ́ kɔrmutə lé, ɔw-né adɨ njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je lé gogɨ ");
INSERT INTO mge_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ə panè: «Mꞌra majal, kdɔ mꞌungɨ məsɨ dow kɨ́ ta goto dɔ-é-tɨ kɔgɨ kɨ̀ ndangɨ kare.» Ngà dḛ ꞌtəl dꞌilə-é-tɨ ꞌpanè: «Usɨ-ji né káre al, i ya to ta lə-i.» ");
INSERT INTO mge_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Beɓa Judasɨ sane là lé kɔgɨ mḛḛ kəy-tɨ lə Lubə, ngá ɓá ɔtɨ ɔw ilə kulə oy. ");
INSERT INTO mge_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Njékun dɔ njégugné-je lə Lubə dꞌɔy là lé, ə ꞌtəl ꞌpanè: «Là kɨ́ bè kin ɓá kadɨ jꞌungi ku là-tɨ kɨ́ kəy lə Lubə lé to tó-é al, kdɔ to là məsɨ.» ");
INSERT INTO mge_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Beɓa dꞌɔjɨ-na̰ ta dɔ là-tɨ lé, adɨ ndi-dé usɨ go-na̰-tɨ ngá ɓá dꞌɔw ꞌndogɨ-né lo ndɔr lə kɔdɨ kubə jo, kdɔ kadɨ dꞌilə dɔɓadɨ mba-je titɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Gin-é kin ɓá sar ɓone ya kàrè ꞌɓa-né lo ndɔr kinlé «lo ndɔr kɨ́ ꞌndogɨ kɨ̀ là məsɨ.» ");
INSERT INTO mge_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tò bè kdɔ kadɨ ta kɨ́ njèpata kɨ́ ta Lubə-tɨ Jeremi pa lé, né-é ra-né né. Ḛ panè: «Dḛ ꞌtaa là kɨ́ kɔrmutə lé, kdɔ ngan Israyel-je ꞌgɨr kɨ́ dow kɨ́ bè jè kin ngà là kin ya asɨ ndogɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dꞌɔw ꞌndogɨ-né lo ndɔr lə kɔdɨ kubə jo, titɨ kɨ́ ꞌƁaɓe un-né ndu-é adɨ-m lé bè tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lokɨ Jeju a̰ lo gangta-tɨ nɔ̰̀ gubərnər Pilatɨ-tɨ lé, Pilatɨ dəjɨ-é panè: «Se i ya ɓá ꞌto ngar lə jipɨ-je lé wa?» Jeju ilə-é-tɨ panè: «Ta ya tḛḛ ta-i-tɨ tin.» ");
INSERT INTO mge_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngà go ta-tɨ kɨ́ ḛ pa lé, njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, ꞌtilə ta dɔ-é-tɨ yó-je kɨ nè-je, ngá Jeju tḛḛ ta-é ilə-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Beɓa Pilatɨ idə-é panè: «I ꞌoo ta-je lay kɨ́ ꞌtilə dɔ-i-tɨ kinlé al wa?» ");
INSERT INTO mge_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bè ya kàrè, Jeju ilə-tɨ al. Né kɨ́ Jeju ra kinlé ndɔjɨ Pilatɨ lé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kaglo ra na̰y Pakɨ-je lay ya Gubərnər ilə dangay káre taá. À to dangay kɨ́ kosɨ dow-je ya dꞌɔsɨ kagɨ dɔ-é-tɨ ɓá à kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ngà dɔkaglo-tɨ kinlé, dangay káre kɨ́ ꞌɓa-é Barabasɨ à nɔ̰ɔ̰ ə to dangay kɨ́ ri-é ɓá n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Beɓa Pilatɨ dəjɨ kosɨ dow-je kɨ́ ꞌkəw-na̰ lé panè: «Se ná̰ dana̰ ɓá ꞌndigi kadɨ mꞌilə-é taá madɨ-si wa? Barabasɨ əse Jeju kɨ́ ꞌɓa-é Kristɨ lé wa?» ");
INSERT INTO mge_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatɨ gə kete majɨ kɨ́ dꞌilə Jeju ji-nꞌḛ̀-tɨ kdɔ kim kɨ́ dꞌim-é. ");
INSERT INTO mge_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngà lokɨ Pilatɨ isɨ logangta-tɨ lé ya ɓəy rəmə, ne-é ulə kullə rɔ-é-tɨ panè: «ꞌTɔr ji-i ta-tɨ lə dow kin, kdɔ ḛ to njèra né kɨ́ njururu rəm, ɓá ndɔɔ nè kàrè, mꞌingə kɔ̰̀ n̰a̰ mḛḛ nḭ-tɨ kdɔ ta liə tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌsulə kosɨ dow-je kadɨ ꞌdəjɨ Pilatɨ kadɨ ilə Barabasɨ taá, ngà Jeju tá kadɨ ꞌtɔl-é kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatɨ təl dəjɨ-dé ɓəy panè: «Se ná̰ dan dow-je-tɨ kɨ́ joo kin ə́ ꞌndigi kadɨ mꞌilə-é taá wa?» Dḛ lay ya dꞌilə-é-tɨ ꞌpanè: ꞌIlə Barabasɨ taá. ");
INSERT INTO mge_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatɨ təl dəjɨ-dé ya ɓəy panè: «Ngà ri ɓá kadɨ-m mꞌra kɨ̀ Jeju kɨ́ ꞌɓa-é Kristɨ lé wa?» Dḛ lay ya dꞌilə-é-tɨ ꞌpanè: «ꞌƁə-é kagdəsɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatɨ təl dəjɨ-dé ya ɓəy panè: «Ə to majal ri ya ɓá Jeju lé ra wa?» Ngà dḛ dꞌun ndi-dé kɨ taá ꞌpanè: «ꞌƁə-é kagdəsɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngà lokɨ Pilatɨ oo kɨ́ ta-je liə ra kullə rɔ-dé-tɨ al rəm, ɓá oo kɨ́ kəm dow-je il kiriri, ɓá ꞌsingə wuuu adɨ dꞌɔw dɔ-na̰-tɨ wúr-wùr lé, un man togɨ-né ji-é takəm kosɨ dow-je-tɨ nɔ̰ɔ̰ ya, ngá ɓá idə-dé panè: «Ta məsɨ dow kɨ́ njèra né kɨ́ njururu kin à goto dɔ-m-tɨ! Ta məsɨ-é à tò dɔ-si sə̰i-tɨ ya.» ");
INSERT INTO mge_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Beɓa lay lə dow-je kɨ́ dꞌa̰ logangta-tɨ kinlé ꞌpanè: «Kadɨ ta məsɨ-é tò dɔ-ji-tɨ sar kɨ dɔ ngan-ji-je-tɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Beɓa Pilatɨ ilə Barabasɨ taá, ngà adɨ ꞌtində Jeju kɨ̀ ndəy marɔw, ɓəy ɓá in̰ə-é adɨ-dé kadɨ dꞌɔw ꞌɓə-é kagdəsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Asgar-je lə Gubərnər dꞌuwə Jeju dꞌɔw siə panata liə, ngá ɓá lay lə asgar-je ya dꞌilə-na̰ ꞌgəə dɔ-é sipɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ə ꞌtɔr kubɨ-je kɨ́ rɔ-é-tɨ, ɓəy ɓá dꞌulə kubɨ kɨ́ kər yəl-yəl rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ꞌRa kun dꞌojɨ jɔgɨ ngar-tɨ dꞌulə dɔ-é-tɨ rəm, dꞌulə tuwətɔ́gɨ jikɔl-é-tɨ, ngá ɓá ꞌtɔsɨ məkəjɨ-dé nangɨ nɔ̰̀-é-tɨ ə ꞌsɔkɨ-é ꞌpanè: «Lapiya ɓoo ngar lə jipɨ-je!» ");
INSERT INTO mge_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ə ꞌtubə yoro kəm-é-tɨ rəm, ɓá ꞌtaa tuwətɔ́gɨ kɨ́ ji-é-tɨ lé ꞌtində-né dɔ-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lokɨ asgar-je lé sɔkɨ-é asɨ-dé ngá rəmə, dꞌuwə kubɨ kɨ́ kər lé dꞌɔr kàdɨ̀-é-tɨ, ə ꞌtəl ꞌtulə kubɨ-je liə rɔ-é-tɨ gogɨ, ngá ɓá dꞌɔtɨ dꞌɔw siə kdɔ ɓə-é kagdəsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lokɨ dꞌḭ Jorijalḛm dꞌisɨ dꞌɔw kɨ lo-tɨ kɨ́ dꞌa ɓə Jeju kagdəsɨ-tɨ titɨ lé, dꞌingə dingəm káre kɨ́ ꞌɓa-é Simɔ̰, rəmə asgar-je dꞌində tɔ́gɨ dɔ-é-tɨ dꞌadɨ-é utɨ kagdəsɨ lə Jeju. Ḛ to dow kɨ́ ɓebo Sirḛn-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dꞌɔw tḛḛ lo-tɨ kɨ́ ɓa-é Golgota, kɨ́ kɔr mḛḛ-é to «lo kɨ́ titɨ-na̰ kɨ̀ ka dɔ dow.» ");
INSERT INTO mge_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lo-é-tɨ kin ɓá dḛ dꞌadɨ Jeju man nduu kɨ́ pote natɨ kɨ̀ né kɨ́ atɨ kadɨ-é a̰y. Ngà lokɨ ɔdɨ ta-é rəmə, ḛ mbatɨ ka̰y. ");
INSERT INTO mge_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Asgar-je ꞌɓə Jeju kagdəsɨ-tɨ ngá ɓá ꞌləbɨ-na̰ kubɨ-je liə kɨ̀ kəm rəbɨ mbare kɨ́ kɔsɨ. Bè kdɔ kadɨ ta kɨ́ njèpata kɨ́ ta Lubə-tɨ pa lé, né-é ra né. Ḛ panè: ꞌLəbɨ-na̰ kubɨ-je lə-m kɨ́ gɔjɨ, kɨ̀ ḛ kɨ́ ngal. ");
INSERT INTO mge_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ə ꞌtəl dꞌisɨ lo-é-tɨ nɔ̰ɔ̰ ya dꞌisɨ ngəm ta Jeju. ");
INSERT INTO mge_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lokɨ Jeju a̰ kagdəsɨ-tɨ lé, ꞌndàngɨ ta mḛḛ bəgrə-tɨ ꞌɓə dɔ-é-tɨ taá kdɔ kadɨ ꞌtɔjɨ-né gin né kɨ́ ꞌtɔl-é-né. Ta kɨ́ ꞌndàngɨ lé ə́n: «Dow kin to Jeju kɨ́ ngar lə jipɨ-je!» ");
INSERT INTO mge_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ꞌƁə bɔkaya-je joo kagdəsɨ-je-tɨ lə-dé mbɔ́ Jeju-tɨ. Ḛ kɨ́ káre dɔ jikɔl-é-tɨ ə ḛ kɨ́ káre dɔ jigəl-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ngà dow-je kɨ́ njédəə rəbəə-je, ꞌtugə dɔ-dé ꞌsɔkɨ-é-né ");
INSERT INTO mge_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ə ꞌpanè: «I kɨ́ ꞌpanè ꞌa tɔɔ kəy lə Lubə ə ndɔ mutə ya ꞌa kində gogɨ lé i ya ꞌajɨ rɔ-i ngá nà̰! Kinə ꞌto Ngon lə Lubə ya tɔgrɔ-tɨ rəmə, ꞌḭ dɔ kagdəsɨ-tɨ kin ꞌrisɨ nangɨ adɨ jꞌoo!» ");
INSERT INTO mge_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Beɓa njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je rəm, ɓá ꞌngatɔ́gɨ-je lə jipɨ-je ꞌpa ta ꞌkogɨ-né dɔ Jeju-tɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Dow-je kɨ́ rangɨ ɓá ḛ ajɨ-dé, ngà ḛ asɨ kajɨ rɔ-é al wa! Ngar lə Israyel-je lé ya ɓá a̰ an! Bè rəmə, kḭ ya kadɨ-é ḭ kagdəsɨ-tɨ kin risɨ nangɨ ə jꞌa kadɨ-é mḛḛ-ji lé ngá!» ");
INSERT INTO mge_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","«Ḛ ində mḛḛ dɔ Lubə-tɨ adɨ panè: “Mꞌto Ngon lə Lubə.” Ngà kinə Lubə ndigɨ-é ya tɔgrɔ-tɨ rəmə, ajɨ-é kɨ́ ngɔsnè-tɨ kin ya adɨ joo ngá nà̰.» ");
INSERT INTO mge_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɔkaya-je kɨ́ joo kɨ́ ꞌɓə-dé kagdəsɨ-je-tɨ mbɔ́-é-tɨ lé kàrè ꞌtajɨ-é titɨ-na̰ bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lokɨ kàdɨ̀ a̰ jam dɔ ɓe-tɨ ya ɓəy rəmə, londul dɔnangɨ-tɨ nè lay sar ya kàdɨ̀ kɨ́ mutə kɨ́ losɔlɔ asɨ-né. ");
INSERT INTO mge_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lokɨ kàdɨ̀ kɨ́ mutə kɨ́ losɔlɔ asɨ lé, Jeju ilə bɔbɨ ndi-é nangɨ nɔ̰ panè: «Eli, Eli Lama sabaktani», kɔr mḛḛ-é to: «Lubə lə-m, Lubə lə-m, kdɔ ri ɓá ꞌin̰ə-m kɔgɨ bè wa?» ");
INSERT INTO mge_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dow-je kɨ́ ná̰-je dan dḛ-tɨ kɨ́ dꞌa̰ lo-é-tɨ lé, dꞌoo ndi-é ə ꞌpanè: «Yən! Ḛ ɓa Eli.» ");
INSERT INTO mge_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lo-é-tɨ nɔ̰ɔ̰ ya, dow káre dan-dé-tɨ a̰y ngɔdɨ ɔw un ndɔkrɔ, ulə dan man nduu-tɨ kɨ́ masɨ, ɔsɨ ta tuwətɔ́gɨ-tɨ ə ulə ta Jeju-tɨ kadɨ-é a̰y. ");
INSERT INTO mge_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngà madɨ-é-je dꞌidə-é ꞌpanè: «ꞌNgəbɨ mɔkɨ, adɨ jꞌoo se Eli liə lé à ree kajɨ-é wa!» ");
INSERT INTO mge_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jeju təl ilə bɔbɨ ndi-é nangɨ nɔ̰ rangɨ ya ɓəy, ə ḛ ya in̰ə ndil-é adɨ tḛḛ. ");
INSERT INTO mge_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lo-é-tɨ nɔ̰ɔ̰ ya, kubɨ gangɨ mḛḛ kəy lə Lubə ḭ taá ya til ree njal tḛḛ nangɨ rəm, ɓá dɔnangɨ yəkɨ ɓukɨ-ɓukɨ adɨ mbal-je ribə ə́ktə́-ə́ktə́ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rəm ɓá ta ɓadɨ-je tḛḛ adɨ njékaa njay-je n̰a̰ ya, ꞌtɔsɨ ꞌndəl dꞌində lo tḛḛ rəm. ");
INSERT INTO mge_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rəmə go-tɨ kɨ́ Jeju tɔsɨ ndəl ində lo tḛḛ ɓəy ngá ɓá, dḛ kɨ́ ꞌtɔsɨ ndəl lé dꞌɔw mḛḛ ɓebo Jorijalḛm-tɨ kɨ́ to ɓe kɨ́ aa njay ə dow-je n̰a̰ ya dꞌoo-dé. ");
INSERT INTO mge_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lokɨ njèkun dɔ asgar-je ɓu, dḛ kɨ̀ asgar-je kɨ́ dꞌa̰ ꞌngəm ta Jeju, dꞌoo kɨ́ dɔnangɨ yəkɨ titɨ-na̰ bè rəm, dꞌoo né-je lay kɨ́ ra né titɨ-na̰ bè kin rəm lé, ꞌɓəl n̰a̰ adɨ ꞌpanè: «Dow kinlé, to Ngon lə Lubə ya tɔgrɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dené-je n̰a̰ ya dꞌa̰ lo-é-tɨ nɔ̰ɔ̰; dꞌa̰ ngərəngɨ dꞌa̰ dꞌoo né-je lé. Dené-je kinlé, dꞌun go-é Galile-tɨ nṵ kdɔ ra kullə kadɨ-é. ");
INSERT INTO mge_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mari kɨ́ Magdala, kɨ̀ Mari kɨ́ kɔ̰ Jakɨ kɨ́ to kɔ̰ Jojepɨ tɔ, ɓá kɔ̰ ngan lə Jebede dꞌa̰ dan dené-é-je-tɨ lé nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta kàdɨ̀ kur-tɨ rəmə, dingəm káre kɨ́ njènékingə kɨ́ Arimate, kɨ́ ri-é lə Jojepɨ ree. Ḛ kàrè to kɨ́ káre dan njéndó né-je-tɨ lə Jeju tɔ. ");
INSERT INTO mge_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Beɓa ɔw ingə Pilatɨ dəjɨ-é nin Jeju. Ə Pilatɨ un ndu kadɨ dꞌadɨ-é nin Jeju lé. ");
INSERT INTO mge_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jojepɨ un nin Jeju, ɓɨr kɨ̀ takubɨ kɨ́ nda kɨ́ sigɨ. ");
INSERT INTO mge_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ngà ɓá ɔw ilə-é bole mbal-tɨ liə kɨ́ adɨ ꞌtɔl sigɨ, ɓəy ɓá nduburu ər kɨ́ boy ya utɨ-né ta-é ɓá ɔtɨ ɔw. ");
INSERT INTO mge_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari kɨ́ magdala dḛ kɨ̀ Mari kɨ́ káre lé, dꞌisɨ nangɨ ꞌtəl kəm-dé kɨ ta ɓadɨ-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo aa go-tɨ kɨ́ à to ndɔ kɨ́ ore go ndɔ ra go né-je kdɔ ndɔ taakoo lə jipɨ-je lé, njékun dɔ njégugné-je lə Lubə, kɨ̀ Parisi-je ꞌree natɨ dꞌingə Pilatɨ ");
INSERT INTO mge_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","dꞌidə-é panè: «ꞌƁa-ji, mḛḛ-ji ole dɔ ta-tɨ kɨ́ njèkədɨ dow-je kinlé pa, lokɨ ḛ isɨ-né kɨ̀ dɔ-é taá ɓəy. Ndɔkɨ ḛ panè: “Ndɔ mutə go ndɔ dubɨ-nꞌḛ̀-tɨ lé, nꞌa tɔsɨ ndəl kində lo tḛḛ.” ");
INSERT INTO mge_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Beɓa jꞌdəjɨ-i kadɨ adɨ asgar-je ꞌngəm ta ɓadɨ lé, sar ndɔ kɨ́ njèkungɨ-tɨ mutə lé, al rəmə, njéndó né-je liə dꞌa kḭ kɔw ɓogɨ nin-é ə dꞌa kidə dow-je panè: “Ḛ tɔsɨ ndəl ində lo tḛḛ.” Rəmə takədɨ kɨ́ gogɨ nè kinlé à kitə ḛ kɨ́ kete lé ya ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatɨ idə-dé panè: «Njéngəm né-je lə-si ya dꞌa̰ nɔ̰ɔ̰ ə́ ɔwi sə-dé adɨ ꞌngəm ta ɓadɨ lé titɨ kɨ́ mḛḛ-si ndigɨ-né.» ");
INSERT INTO mge_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Beɓa dḛ dꞌɔw sə-dé ə ꞌtin̰ə ta ɓadɨ lé ɓəy ɓá dꞌində-dé ta-tɨ kadɨ ꞌngəm. ");
INSERT INTO mge_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dimasɨ kɨ̀ ndɔge ratɨ, go ndɔ taakoo-tɨ lə jipɨ-je lé, Mari kɨ́ Magdala dḛ kɨ̀ Mari kɨ́ káre ꞌree dɔɓadɨ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rəmə titɨ kəm kɨ́ kində jipɨ bè ya dɔnangɨ yəkɨ, yəkɨ kɨ́ tò ɓəl n̰a̰, kdɔ malayka lə ꞌƁaɓe káre ḭ dɔra̰-tɨ ree nduburu ndəngrə ər kɨ́ dꞌutɨ-né ta ɓe nin lé kɨ rangɨ ə al isɨ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malayka lé, rɔ-é tò titɨ-na̰ kɨ̀ təlndi bè rəm, ɓá kubɨ liə kàrè nda mbəy-mbəy titɨ-na̰ kɨ̀ kɔsɨ bè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Njéngəm ta ɓadɨ lé, ꞌɓəl n̰a̰ adɨ ꞌdadɨ tikɨ-tikɨ, ꞌto titɨ-na̰ kɨ̀ dow-je kɨ́ dꞌoy bè. ");
INSERT INTO mge_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malayka lé, idə dené-je lé panè: «ꞌƁəli al, kdɔ mꞌgə gɔw kɨ́ sə̰i isi ꞌsangi Jeju kɨ́ ndɔ-é-tɨ ꞌɓə-é kagdəsɨ-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ḛ goto nè ngá; ḛ tɔsɨ ndəl ində lo tḛḛ titɨ kɨ́ ḛ pa-né kete lokɨ isɨ-né sə-si ɓəy lé. ꞌReei ooi lo kɨ́ ndɔ-é-tɨ dꞌilə-é-tɨ lé ");
INSERT INTO mge_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ə ꞌtəli lɔw ɔwi idəi njéndó né-je liə ꞌpainè, ḛ tɔsɨ ndəl ində lo tḛḛ adɨ à kɔw kɨ́ ngɔsnè-tɨ kin ya kdɔ ngəbɨ-si Galile. Ḛ ɓá to lo kɨ́ a kooi-é titɨ. Ḛ kin ɓá to ta kɨ́ kadɨ mꞌidə-si.» ");
INSERT INTO mge_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Beɓa dené-je lé, dꞌɔtɨ kalangɨ dɔɓadɨ-tɨ kɨ̀ ɓəl rəm, kɨ̀ rɔnəl kɨ́ n̰a̰ rəm, dꞌa̰y ngɔdɨ lɔw kadɨ dꞌɔw dꞌilə ta lé mbi njéndó né-je-tɨ lə Jeju. ");
INSERT INTO mge_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tajinatɨ nè ya, Jeju tilə kəm-dé ə idə-dé panè: «Mꞌra-si lapiya!» Ngà rəmə dené-je lé, dꞌɔw rɔ-é-tɨ, dꞌuwə nja-é, dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngà Jeju idə-dé panè: «ꞌƁəli al, ɔwi idəi ngankɔ̰-m-je adɨ dꞌɔw Galile, ḛ ɓá to lo kɨ́ dꞌa koo-m-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ngà lokɨ dené-je lé dꞌisɨ dꞌɔw mḛḛ ɓebo-tɨ kɨ kɔw ya ɓəy rəmə, njérɔ-je kɨ́ dan-tɨ-je kɨ́ njéngəm ta ɓadɨ, dꞌɔw mḛḛ ɓebo-tɨ dꞌɔr poy né-je lay kɨ́ ra né kinlé dꞌadɨ njékun dɔ njégugné-je lə Lubə. ");
INSERT INTO mge_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Njékun dɔ njégugné-je lə Lubə kinlé, dꞌuwə dɔ-na̰ kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, dꞌɔjɨ-na̰ ta. Beɓa go ta kɔjɨ-je-tɨ lə-dé lé, dḛ dꞌun là kɨ́ ɓay-ɓay ya dꞌadɨ njéngəm ta ɓadɨ-je lé. ");
INSERT INTO mge_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Rəmə dꞌidə njérɔ-je lé ꞌpanè: «Ɔwi idəi dow-je ꞌpainè: “Njéndó né-je liə, ꞌree ndɔɔ kɨ́ jḛ jꞌto ɓi ya ree dꞌun nin-é kɨ̀ ngə̰y.”» ");
INSERT INTO mge_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lokɨ ꞌpai bè ɓá lé Gubərnər oo ta-é kàrè, jꞌa taa dɔ-si kadɨ né à ra-si al. ");
INSERT INTO mge_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Njérɔ-je ꞌtaa là lé, ngá ɓá dꞌɔw dꞌidə dow-je titɨ kɨ́ dꞌidə-dé-né lé bè ya tɔ. Né kin ɓá poyta kinlé taa-né lo dan jipɨ-je-tɨ sar ɓone. ");
INSERT INTO mge_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Njéndó né-je lə Jeju kɨ́ dɔgɨ gidɨ-é káre dꞌɔw dɔnangɨ Galile-tɨ dɔ mbal-tɨ kɨ́ Jeju ɔjɨ-dé lé. ");
INSERT INTO mge_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ngà lokɨ dḛ dꞌoo-é rəmə, dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀-é-tɨ. Bè ya kàrè, dḛ kɨ́ ná̰-je kɨ́ dan-dé-tɨ ꞌgɨr tokɨ to Jeju al. ");
INSERT INTO mge_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Beɓa Jeju ɔtɨ ree rɔ-dé-tɨ ɓá idə-dé panè: «Tɔ́gɨ-je lay kɨ́ dɔra̰-tɨ, kɨ̀ dɔnangɨ-tɨ nè lé, Lubə adɨ-m ji-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɔwi, ꞌtəli gin dow-je lay njéndó né-je-tɨ lə-m. ꞌRai-dé batḛm, kɨ̀ ri Bɔbɨ, kɨ̀ ri Ngon, kɨ̀ ri Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ə ꞌndói-dé kadɨ ꞌtəl rɔ-dé go ndukun-je-tɨ lə-m lay kɨ́ mꞌadɨ-si. Ooi majɨ, mꞌa kisɨ sə-si natɨ kɨ̀ ndɔ-je lay sar ya kadɨ dɔbəy ndɔ asɨ-né.»");
INSERT INTO mge_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kəm rəbɨ kɨ́ Poyta kɨ́ Majɨ lə Jeju Kristɨ kɨ́ Ngon lə Lubə ulə-né gin-é ɓan: ");
INSERT INTO mge_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ndɔkɨ Ejay kɨ́ njèpata kɨ́ ta Lubə-tɨ ndàngɨ panè: «Ma̰ Lubə, mꞌulə njèkilə mbḛ lə-m kete nɔ̰̀-i-tɨ kdɔ kadɨ-é ra rəbɨ adɨ-i.» ");
INSERT INTO mge_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndi dow ɓa diləlo-tɨ panè: «ꞌRai go rəbɨ lə ꞌƁaɓe! ꞌRai ngan rəbɨ-je liə adi a̰ njururu-njururu.» ");
INSERT INTO mge_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Beɓa Ja̰ kɨ́ njèra dow-je batḛm tḛḛ ə ra dow-je batḛm diləlo-tɨ rəm, ilə mbḛ batḛm kɨ́ sɔbɨ dɔ kin̰ə panjiyə kɨ́ majɨ al kɔgɨ, kdɔ kadɨ Lubə in̰ə-né go majal-je lə dow-je kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Rəmə dow-je kɨ́ dɔnangɨ Jude-tɨ, kɨ̀ dow-je kɨ́ Jorijalḛm lay ya dꞌɔw rɔ-é-tɨ ta ba Jurdḛ-tɨ ꞌpa ta rəsɨ dɔ majal-je-tɨ lə-dé dꞌadɨ-é ra-dé-né batḛm. ");
INSERT INTO mge_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ja̰ ɔɔ kubɨ kɨ́ ꞌra kɨ̀ bəl jambal, dɔɔ ɓədɨ-é kɨ̀ ndaá dɔɔ ɓədɨ, ə nékuso-é to ꞌbete-je kɨ̀ tojɨ kɨ́ wale. ");
INSERT INTO mge_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ḛ ilə mbḛ idə dow-je panè: «Dow kɨ́ ɔw ree go-m-tɨ lé, tɔ́gɨ-é itə-m n̰a̰, adɨ mꞌtuwə kadɨ mꞌɗugɨ nangɨ mꞌtutɨ kulə saba liə al. ");
INSERT INTO mge_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma̰ mꞌra-si batḛm kɨ́ mani, ngà ḛ lé, à ra-si batḛm lə Ndil kɨ́ aa njay.» ");
INSERT INTO mge_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dɔkaglo-é-tɨ kinlé, Jeju ḭ mḛḛ ɓe-tɨ kɨ́ Najarɛtɨ dɔnangɨ Galile-tɨ, ɔw adɨ Ja̰ ra-é batḛm ta ba Jurdḛ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lokɨ Jeju tḛḛ kəm man batḛm-tɨ lé, ḛ oo kəm dɔra̰ tḛḛ rəm, oo Ndil kɨ́ aa njay tana̰ kɨ̀ dəngɔdnda bè ḭ taá ree isɨ dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ə ndi dow ɓá dɔra̰-tɨ panè: «ꞌTo Ngon-m; mꞌində-i dan kəm-m-tɨ, rɔ-m nəl-m dɔ-i-tɨ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rəmə tajinatɨ nè ya Ndil kɨ́ aa njay ɔsɨ Jeju ɔw siə diləlo-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jeju isɨ diləlo-tɨ kinlé ndɔ kɔrsɔ. Lo-é-tɨ kin ɓá Sata̰ na̰-é-tɨ. Jeju isɨ dan da̰-je-tɨ kɨ́ wale, ə malayka-je ꞌree ꞌra siə. ");
INSERT INTO mge_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Go-tɨ, lokɨ dꞌuwə Ja̰ kɨ́ njèra dow-je batḛm lé, Jeju ɔw dɔnangɨ Galile-tɨ, ɔw ilə mbḛ Poyta kɨ́ Majɨ lə Lubə ");
INSERT INTO mge_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","panè: «Dɔkaglo asɨ ngá, ə kɔ̰ɓe lə Lubə ree ngɔsi. In̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ ə adi mḛḛ-si Poyta kɨ́ Majɨ.» ");
INSERT INTO mge_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lokɨ Jeju ɔw njiyə kɨ̀ go babo Galile rəmə, oo Simɔ̰ dḛ kɨ̀ ngonkɔ̰-é Andre dꞌa̰ dꞌilə burə dan babo-tɨ; kdɔ dḛ ꞌto mbɔw-je. ");
INSERT INTO mge_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Beɓa Jeju idə-dé panè: «ꞌReei uni go-m ə mꞌa təl-si njésangɨ dow-je-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rəmə tajinatɨ nè ya ꞌtusɨ burə-je lə-dé dꞌin̰ə ə dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lokɨ Jeju ɔtɨ ɔw kete əbɨ sḛ rəmə, oo Jakɨ dḛ kɨ̀ ngonkɔ̰-é Ja̰ kɨ́ ꞌto ngan lə Jebede, dꞌisɨ mḛḛ tò-tɨ dꞌisɨ ꞌrakɨ burə-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tajinatɨ nè ya Jeju ɓa-dé. Beɓa dḛ ꞌtusɨ bɔbɨ-dé Jebede dꞌin̰ə-é mḛḛ tò-tɨ kɨ̀ ngannjékullə-je lə-dé, ə dꞌun go Jeju. ");
INSERT INTO mge_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jeju dḛ kɨ̀ njéndó né-je liə dꞌɔw mḛḛ ɓe-tɨ kɨ́ Kapɛrnayim. Beɓa ndɔ taakoo-tɨ lə jipɨ-je lé, ḛ ɔw kəykəwna̰-tɨ lə-dé ndó-dé né. ");
INSERT INTO mge_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dow-je kɨ́ dꞌoo néndó liə lé, néndó liə ɔr ndil-dé. Kdɔ ḛ ndó né kəm dow kɨ́ ɔw kɨ̀ tɔ́gɨ ɓɨ ndó né titɨ njéndó dow-je ndukun-je al. ");
INSERT INTO mge_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, dingəm káre bè kɨ́ ndil kɨ́ majɨ al ra-é isɨ-tɨ nɔ̰ɔ̰ ə ur kəə panè: ");
INSERT INTO mge_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«I Jeju dow kɨ́ Najarɛtɨ lé, ri ɓá ꞌndigɨ rɔ-ji-tɨ wa? ꞌRee kdɔ tujɨ-ji wa? Ma̰ mꞌgə-i majɨ: ꞌTo Njèkaa njay lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeju ndángɨ-é panè: «ꞌUtɨ ta-i ə ꞌtḛḛ kɔgɨ mḛḛ dingəm-tɨ kinlé.» ");
INSERT INTO mge_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndil kɨ́ majɨ al lé, ndɔr dingəm lé mɨr-mɨr, tur kəə boy-boy, ində-né lo tḛḛ mḛḛ-é-tɨ kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Né kinlé ɔr ndil dow-je lay adɨ ꞌdəjɨ-na̰ ta ꞌpanè: «Kay! Kin to ri ɓá tana̰ bè? Néndó kɨ́ ɔw kɨ̀ tɔ́gɨ tana̰ bè kinlé, to néndó kɨ́ sigɨ. Dow kinlé, ndil-je kɨ́ majɨ al kàrè ḛ ndángɨ-dé adɨ ꞌtəl rɔ-dé go-é-tɨ rəm lé ya.» ");
INSERT INTO mge_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Beɓa tajinatɨ nè bè ya dow-je dꞌoo poy Jeju kɨ̀ go lo-je lay kɨ́ dɔnangɨ Galile-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lokɨ dḛ dꞌində lo ꞌtḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, Jeju dḛ kɨ̀ Jakɨ kɨ̀ Ja̰ dꞌɔw mḛḛ kəy-tɨ lə Simɔ̰ dḛ kɨ̀ Andre. ");
INSERT INTO mge_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rəmə məm Simɔ̰ kɨ́ dené tò mɔ̰y nangɨ dɔ tɨrə-tɨ. Mɔ̰y ꞌningə́ ɓá ilə-é nangɨ adɨ rɔ-é tungə pil-pil. Beɓa tajinatɨ nè ya ꞌpa ta liə dꞌadɨ Jeju; ");
INSERT INTO mge_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","adɨ Jeju ɔtɨ ɔw rɔ-é-tɨ uwə ji-é adɨ-é ḭ taá. Rəmə mɔ̰y ꞌningə́ lé in̰ə-é adɨ-é ḭ taá oo go-dé kɨ̀ nékuso. ");
INSERT INTO mge_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta losɔlɔ biri, kɨ́ kàdɨ̀ ur lé, dow-je dꞌutɨ njémɔ̰y-je lay, kɨ̀ dḛ kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé, ꞌree sə-dé rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dow-je lay kɨ́ mḛḛ ɓebo-tɨ ya kəwna̰ takəy-tɨ kɨ́ Jeju isɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeju adɨ lapiya dow-je n̰a̰ kɨ́ mɔ̰y-je kɨ́ gay-gay ulə kəm-dé ndoo rəm, tubə ndil-je kɨ́ majɨ al n̰a̰ dɔ dow-je-tɨ tɔ. Ngà ḛ adɨ ndil-je kɨ́ majɨ al lé ꞌpa ta al, kdɔ dḛ ꞌgə-é lay. ");
INSERT INTO mge_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Taginlo-tɨ, lokɨ lo tijə lay al ɓəy ya, Jeju tḛḛ kəy ɔw diləlo-tɨ, ɔw pa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ̰ dḛ kɨ̀ madɨ-é-je dꞌɔw ꞌndole-é. ");
INSERT INTO mge_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Beɓa lokɨ dḛ dꞌingə-é lé, dꞌidə-é ꞌpanè: «Dow-je lay ya dꞌɔw ꞌsangɨ-i.» ");
INSERT INTO mge_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Rəmə Jeju təl idə-dé panè: «Adɨ jꞌɔwi lo-je-tɨ kɨ́ rangɨ nganɓe-je-tɨ kɨ́ tò ngɔsi-ngɔsi, kdɔ kadɨ mꞌɔw mꞌilə mbḛ Poyta kɨ́ Majɨ-tɨ tɔ. Kdɔtalə ḛ kin ɓá mꞌree kdɔ.» ");
INSERT INTO mge_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Beɓa Jeju ɔw kɨ̀ lo-je lay kɨ́ dɔnangɨ Galile-tɨ ilə mbḛ Poyta kɨ́ Majɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je rəm, ɓá tubə ndil-je kɨ́ majɨ al dɔ dow-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Njèbanjɨ káre bè ree rɔ Jeju-tɨ, tɔsɨ məkəjɨ-é nangɨ nɔ̰̀-é-tɨ, ra-é kɔgri panè: «Kinə ꞌndigɨ lé, ꞌa kadɨ banjɨ lə-m kin ur kadɨ mꞌaa njay kare.» ");
INSERT INTO mge_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Beɓa Jeju oo kəmtondoo liə, ulə ji-é ɔdɨ-né rɔ-é ɓá panè: «Mꞌndigɨ dɔ-tɨ sə-i. Kadɨ banjɨ lə-i ur!» ");
INSERT INTO mge_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rəmə tajinatɨ nè ya banjɨ lé ur adɨ rɔ-é təl aa njay. ");
INSERT INTO mge_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jeju ndángɨ-é ə tajinatɨ nè ya tubə-é go-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","panè: «ꞌOo majɨ nè ꞌa kḭ kɔw pa ta-é kadɨ dow oo, ngà ꞌɔw ꞌtɔjɨ rɔ-i njègugné lə Lubə, ə ꞌadɨ né kdɔ məsɨ kilə kɨ́ sɔbɨ dɔ kaa rɔ lə-i titɨ kɨ́ ndukun lə Moiyijɨ pa-né. Bè kdɔ kadɨ dow-je lay ꞌgə kɨ́ banjɨ kɨ́ rɔ-i-tɨ lé ur ngá.» ");
INSERT INTO mge_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngà lokɨ dowbé kinlé ɔtɨ ɔw rəmə, ḛ ɔw pa ta lə né kɨ́ Jeju ra siə ilə-né mbḛ kɨ̀ lo lay sar adɨ Jeju asɨ kadɨ tɔjɨ rɔ-é mḛḛ ɓebo-tɨ al. Ḛ njiyə-né kɨ̀ nganglo-nganglo, isɨ ngərəngɨ-ngərəngɨ kɨ̀ dow-je. Bè ya kàrè dow-je dꞌḭ kɨ̀ lo-lo ya ꞌree rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mḛḛ ndɔ-je-tɨ kɨ́ rangɨ go-tɨ lé, Jeju təl ree Kapɛrnayim-tɨ. Ə dow-je dꞌoo kɨ́ Jeju isɨ kəy nè. ");
INSERT INTO mge_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Beɓa kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌkəw-na̰ dɔ-é-tɨ, dꞌun lo latɨ-latɨ adɨ lo kɨ́ takəy-tɨ kàrè nà̰y al. Jeju idə-dé ta lə Lubə. ");
INSERT INTO mge_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dow-je sɔ dꞌun dow kɨ́ rɔ-é oy mburukɨ ꞌree siə rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngà kosɨ dow-je kɨ́ ꞌn̰a̰ kinlé ra adɨ lo kɔw siə rɔ Jeju-tɨ goto. Beɓa dḛ dꞌal ꞌngin̰ə jam kəy ꞌsɔbɨ-né dɔ lo kɨ́ Jeju isɨ-tɨ ə dꞌun njèrɔkoy mburukɨ lé kɨ̀ tuwə tò-é, dꞌulə-é kɨ̀ kəm bole jamkəy go Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lokɨ Jeju oo kadmḛḛ lə-dé bè rəmə, idə njèrɔkoy mburukɨ lé panè: «Ngon-m! Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lo-é-tɨ kinlé, dow-je kɨ́ dan-tɨ-je kɨ́ ꞌto njéndó dow-je ndukun-je dꞌisɨ nɔ̰ɔ̰ tɔ; ə ꞌgɨr ta mḛḛ-dé-tɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kdɔ ri ɓá dow kanlé pa ta kɨ́ bè kin wa? To ta kɔbɨ ɓá ḛ pa dɔ Lubə-tɨ tin. Ná̰ ɓá asɨ kin̰ə go majal-je lə dow-je kɔgɨ wa? Lubə ya kɨ̀ kár-é asɨ.» ");
INSERT INTO mge_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tajinatɨ nè ya Jeju gə tagɨr-je kɨ́ mḛḛ-dé-tɨ adɨ idə-dé panè: «Kdɔ ri ɓá ɔwi kɨ̀ tagɨr-je kɨ́ bè kin mḛḛ-si-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kidə njèrɔkoy mburukɨ panè: “Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ” lé ɓá tò ɓəl n̰a̰ əse, kidə-é panè: “ꞌḬ taá ꞌun tuwə lə-i ə ꞌnjiyə ɓá tò ɓəl n̰a̰ wa?”» ");
INSERT INTO mge_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Majɨ! Mꞌa kɔjɨ-si kadɨ ꞌgəi kɨ́ Ngon lə dow lé ɔw kɨ̀ tɔ́gɨ dɔnangɨ-tɨ nè, kdɔ kin̰ə-né go majal-je lə dow-je kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Beɓa Jeju təl idə njèrɔkoy mburukɨ lé panè: Mꞌun ndu mꞌadɨ-i mꞌpanè: «ꞌḬ taá, ꞌun tuwə lə-i ə ꞌɔw ɓee lə-i.» ");
INSERT INTO mge_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rəmə tajinatɨ nè ya njèrɔkoy mburukɨ lé ɔsɨ nangɨ ḭ taá, un tuwə tò-é, ɔtɨ takəm dow-je-tɨ lay adɨ ɔr ndil-dé adɨ dꞌɔsɨ-né gajɨ Lubə ꞌpanè: «Jꞌoo né kɨ́ tana̰ bè kin nja káre al.» ");
INSERT INTO mge_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeju təl ɔw gogɨ ta babo-tɨ kɨ́ Galile. Kosɨ dow-je lay dꞌɔw go-é-tɨ adɨ ḛ isɨ ndó-dé né. ");
INSERT INTO mge_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lokɨ isɨ dəə rəmə, ḛ oo Lebi kɨ́ ngon lə Alpe isɨ lo taa lambo-je-tɨ ə idə-é panè: «ꞌUn go-m.» Beɓa Lebi ḭ taá ə un go-é. ");
INSERT INTO mge_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Go-tɨ, Jeju ɔw mḛḛ kəy-tɨ lə Lebi, isɨ ta nékuso-tɨ natɨ kɨ̀ dow-je n̰a̰ kɨ́ ꞌto njétaalambo-je, kɨ̀ njéramajal-je, kɨ̀ njéndó né-je liə; kdɔ dow-je n̰a̰ ya dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lokɨ njéndó dow-je ndukun-je kɨ́ ꞌto kɨ́ dan Parisi-je-tɨ dꞌoo kɨ́ Jeju isɨ uso né natɨ kɨ̀ njétaalambo-je, kɨ̀ njéramajal-je lé, ꞌpa kɨ̀ njéndó né-je liə ꞌpanè: Kdɔ ri ɓá ḛ uso né natɨ kɨ̀ njétaalambo-je kɨ̀ njéramajal-je kin wa? ");
INSERT INTO mge_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jeju oo ta lə-dé lé, adɨ pa sə-dé panè: «Dow-je kɨ́ rɔ-dé tò kɨ̀ lapiya kare lé dꞌɔw ndoo dɔktur al, ngà njémɔ̰y-je ɓá dꞌɔw ndoo-é. Ma̰ lé, njéra né-je kɨ́ njururu ɓá mꞌree kdɔ ɓa-dé al, ngà mꞌree kdɔ njéramajal-je.» ");
INSERT INTO mge_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Njéndó né-je lə Ja̰ dḛ kɨ̀ Parisi-je lé dꞌun dɔkaglo madɨ dꞌɔgɨ-né rɔ-dé nékuso kɨ̀ man ka̰y. Beɓa dow-je ꞌree rɔ Jeju-tɨ ꞌdəjɨ-é ꞌpanè: «Kdɔ ri ɓá njéndó né-je lə Ja̰ dḛ kɨ̀ njéndó né-je lə Parisi-je dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y, ngà i rəmə, njéndó né-je lə-i dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y al wa?» ");
INSERT INTO mge_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngá ɓá Jeju ilə-dé-tɨ panè: «Dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ kɨ́ lo taana̰-tɨ lé, dꞌa kɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y dɔkaglo-tɨ kɨ́ njètaa dené sigɨ isɨ-né sə-dé natɨ nè wa? Dɔkaglo-tɨ kɨ́ njètaa dené sigɨ isɨ-né sə-dé natɨ nè ɓəy kinlé, dꞌa kɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y al ya sar. ");
INSERT INTO mge_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngà ndɔ-je ɔw ree nɔ̰ɔ̰ lé, dꞌa kun njètaa dené sigɨ lé ta-dé-tɨ kɔgɨ; rəmə mḛḛ ndɔ-é-je-tɨ kinlé ɓá dꞌa kɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dow à kun takubɨ kɨ́ sigɨ kdɔ kilə-né kəm ndisɨ kubɨ al; bin al rəmə takubɨ kɨ́ sigɨ lé, à kuwə dɔgangɨ ndisɨ kubɨ lé wuktu kɔr ə à ra kadɨ kəm kubɨ kɨ́ mbutɨ lé tò wororo ta madɨ-é-tɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Rəm ɓá dow à tur yibɨ nduu kɨ́ sigɨ mḛḛ mbundaá-je-tɨ kɨ́ low al. Bin al rəmə yibɨ nduu kɨ́ sigɨ lé à ra kadɨ mbundaá-je kɨ́ low lé riyə əktə́-əktə́, rəmə yibɨ nduu kɨ́ sigɨ lé à tujɨ rəm, ɓá mbundaá kɨ́ low lé kàrè à tujɨ rəm tɔ; ngà tò kdɔ kadɨ dow tur yibɨ nduu kɨ́ sigɨ mḛḛ mbundaá-tɨ kɨ́ sigɨ ya tɔ ɓane. ");
INSERT INTO mge_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ndɔ káre bè, Jeju njiyə mḛḛ ndɔr gemḛ-je-tɨ kdɔ kində gangɨ ndɔ taakoo-tɨ lə jipɨ-je rəmə, njéndó né-je liə ꞌpuy dɔ gemḛ dꞌuso taá-taá. ");
INSERT INTO mge_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Beɓa Parisi-je ꞌree ꞌpa kɨ̀ Jeju ꞌpanè: «ꞌOo bè! Kdɔ ri ɓá njéndó né-je lə-i ꞌra né kɨ́ to tó-é al kadɨ dow ra ndɔ taakoo-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeju ilə-dé-tɨ panè: «Né kɨ́ ndɔkɨ Dabidɨ ra kaglo-tɨ liə, lokɨ nékuso goto adɨ ɓo ra-dé kɨ̀ dow-je liə lé sə̰i ꞌndói ta-é mḛḛ mbete-tɨ kɨ́ aa njay al ya sar wa? ");
INSERT INTO mge_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ḛ ɔw mḛḛ kəykubɨ-tɨ lə Lubə, uso mbə̀ kɨ́ ꞌree-né nɔ̰̀ Lubə-tɨ dɔkaglo-tɨ kɨ́ Abiyatar ɓá to-né burə dɔ njégugné-je lə Lubə; ə tò kadɨ njégugné-je lə Lubə ya par ɓá dꞌa kuso mbə̀-é kinlé, ya ngà Dabidɨ ɔw mbing adɨ dow-je liə dꞌuso tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jeju pa sə-dé ɓəy panè: «Ndɔ taakoo ɓá tò kdɔ ta lə dow ɓɨ ꞌra dow kdɔ ta lə ndɔ taakoo al. ");
INSERT INTO mge_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Adɨ Ngon lə dow lé ya to ꞌɓa ndɔ taakoo.» ");
INSERT INTO mge_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Go-tɨ, Jeju təl ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, rəmə dingəm káre bè kɨ́ ji-é oy mburukɨ isɨ mḛḛ kəykəwna̰-tɨ lé nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Beɓa dow-je kɨ́ dꞌisɨ mḛḛ kəykəwna̰-tɨ kinlé, dꞌadɨ kəm-dé tò dɔ Jeju-tɨ gə́rə́rə́ kdɔ kadɨ dꞌoo, ə́ kinə adɨ lapiya njèmɔ̰y kin ndɔ taakoo-tɨ rəmə je to kəm rəbɨ kɨ́ kadɨ nꞌiləi-né ta dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeju idə dingəm kɨ́ njèjikoy lé panè: «Ḭ taá ə ꞌree dana̰ nè.» ");
INSERT INTO mge_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Go-tɨ, ḛ dəjɨ-dé panè: «Né kɨ́ rá ɓá to tó-é kadɨ dow ra ndɔ taakoo-tɨ wa? Ra majɨ kɨ̀ dow ɓá to tó-é əse ra siə majɨ al ɓá to tó-é wa? Kajɨ dow ɓá to tó-é əse tɔl-é ɓá to tó-é wa?» Ngà dḛ dꞌilə-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Beɓa wɔngɨ ra Jeju dɔ-dé-tɨ lay, adɨ oo-dé jər-jər rəm, rɔ-é atɨ-é kana̰na̰ kdɔ ta lə mḛḛndə lə-dé rəm. Go-tɨ, ḛ idə dingəm kɨ́ njèjikoy lé panè: «ꞌSurə ji-i.» Lokɨ ḛ surə ji-é lé ya rəmə, ji-é lé təl tò majɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tajinatɨ nè ya Parisi-je lé, dꞌində lo ꞌtḛḛ kəykəwna̰-tɨ, dꞌɔw dꞌingə-na̰ kɨ̀ dow-je lə Erodɨ dꞌɔjɨ-na̰ ta dɔ kəm rəbɨ-tɨ kɨ́ kadɨ nꞌtɔli-né Jeju. ");
INSERT INTO mge_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jeju dḛ kɨ̀ njéndó né-je liə dꞌɔr rɔ-dé dꞌɔw ta babo Galile-tɨ. Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌḭ dɔnangɨ Galile-tɨ ꞌree dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dḛ kɨ́ dan-tɨ-je dꞌḭ dɔnangɨ Jude-tɨ, kɨ̀ ɓebo Jorijalḛm-tɨ, kɨ̀ dɔnangɨ Idume-tɨ, kɨ̀ gidɨ ba Jurdḛ-tɨ, kɨ̀ go lo-je-tɨ kɨ́ dɔnangɨ Tir-tɨ kɨ̀ dɔnangɨ Sidɔ̰-tɨ. Kosɨ dow-je kɨ́ ꞌtò nduy-nduy kɨ́ dꞌoo poy né-je kɨ́ Jeju ra ra kinlé ꞌree rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Beɓa Jeju idə njéndó né-je liə kadɨ ꞌsangɨ ngon tò dꞌadɨ-nꞌḛ̀, kdɔ kadɨ kosɨ dow-je ꞌmbore-nꞌḛ̀ yó-je kɨ nè-je al. ");
INSERT INTO mge_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ə kadɨ kɨ́ Jeju adɨ lapiya dow-je n̰a̰ kinlé ra adɨ dow-je lay ya kɨ́ mɔ̰y ra-dé, dꞌa̰y-na̰ miriri-miriri kɨ rɔ-é-tɨ kadɨ dꞌɔdɨ rɔ-é. ");
INSERT INTO mge_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndil-je kɨ́ majɨ al kàrè lokɨ dḛ dꞌoo Jeju lé, ꞌsəbɨ takəm-dé nangɨ nɔ̰̀-é-tɨ, ꞌtur kəə boy-boy ꞌpanè: «ꞌTo Ngon lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngà Jeju ndángɨ-dé, kəngɨ-dé-né kəngɨ-kəngɨ kadɨ ꞌndogɨ dɔ-nꞌḛ̀-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Go-tɨ, Jeju al dɔ mbal-tɨ ə ɓa dow-je kɨ́ ḛ ndigɨ ɓa-dé adɨ ꞌree rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Beɓa ḛ mbətɨ-dé dɔgɨ gidɨ-é joo, kdɔ kadɨ ꞌnjiyə siə ");
INSERT INTO mge_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ə ulə-dé adɨ dꞌilə mbḛ Poyta kɨ́ Majɨ rəm, adɨ-dé tɔ́gɨ kadɨ ꞌtubə-né ndil-je kɨ́ majɨ al kɔgɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ḛ mbətɨ-dé dɔgɨ gidɨ-é joo adɨ to: Simɔ̰ kɨ́ Jeju ɓa-é Piyər rəm, ");
INSERT INTO mge_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakɨ kɨ́ ngon lə Jebede rəm, Ja̰ kɨ́ ngonkɔ̰ Jakɨ kɨ́ Jeju ɓa-dé «Buwanɛrjɛsɨ» ə kɔr mḛḛ-é to «ngan lə ndàngɨ-ndi», ");
INSERT INTO mge_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kɨ̀ Andre, kɨ̀ Pilipɨ, kɨ̀ Batlemi, kɨ̀ Matiye, kɨ̀ Tomasɨ, kɨ̀ Jakɨ kɨ́ to ngon lə Alpe, kɨ̀ Tade, kɨ̀ Simɔ̰ kɨ́ to dow kɨ́ ta ɓe liə to-é, ");
INSERT INTO mge_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ɓá Judasɨ Iskariyotɨ kɨ́ ḛ ɓá à to njèkun dɔ Jeju lé tɔ. ");
INSERT INTO mge_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Go-tɨ, Jeju kɨ̀ njéndó né-je ꞌtəl ꞌree takəy-tɨ gogɨ rəmə, kosɨ dow-je ꞌtəl ꞌree ꞌkəwna̰ dɔ-é-tɨ sar ya adɨ lo kadɨ dꞌingə mbunə̰ lo dꞌuso-né né kàrè goto. ");
INSERT INTO mge_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lokɨ poy-é ree usɨ mbi nojɨ-é-je-tɨ lé, dḛ dꞌḭ dꞌusɨ dɔ rəbɨ-tɨ kadɨ ꞌree dꞌɔw siə rɔ-dé-tɨ; kdɔ dḛ ꞌpanè: «Dɔ-é majɨ al.» ");
INSERT INTO mge_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Njéndó dow-je ndukun-je kɨ́ dꞌḭ Jorijalḛm ꞌree ꞌpanè: «Jeju ɔw kɨ̀ Beljebul mḛḛ-é-tɨ», adɨ «to ꞌboy lə ndil-je kɨ́ majɨ al ɓá adɨ-é tɔ́gɨ tubə-né ndil-je kɨ́ majɨ al.» ");
INSERT INTO mge_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Beɓa Jeju ɓa-dé rɔ-é-tɨ ə un gosta pa-né sə-dé panè: «Sata̰ à kasɨ tubə Sata̰ ban ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kinə kɔ̰ɓe kɨ́ káre-rè ya dow-je kɨ́ mḛḛ-é-tɨ ꞌgángɨ-na̰ dꞌɔsɨ-na̰ kɨ̀ ta lé, kɔ̰ɓe-é à ka̰ lo ka̰-é-tɨ gərərə al. ");
INSERT INTO mge_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ə kinə kəy kɨ́ káre-rè ya dow-je kɨ́ mḛḛ-é-tɨ ꞌgángɨ-na̰ dꞌɔsɨ-na̰ kɨ̀ ta lé, dowbé-je dꞌa kisɨ gərərə al rəm. ");
INSERT INTO mge_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ə kinə Sata̰ ya rɔ kɨ̀ rɔ-é rəmə, to ḛ ya gángɨ rɔ-é adɨ ḛ à kisɨ gərərə al. Bè kinlé, to kɔ̰ɓe liə ya ində ngangɨ-é ngá tin. ");
INSERT INTO mge_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kinə dow uwə njètɔ́gɨ tɔ́-é njim-njim al lé, dowbé à kasɨ kur mḛḛ kəy-tɨ lə njètɔ́gɨ kin kdɔ kəə nékingə-é al. À tɔ́-é njim-njim ɓəy ɓá à kɔw mḛḛ kəy-tɨ kdɔ kəə nékingə-é. ");
INSERT INTO mge_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ majal-je lay ya kɨ́ dow-je dꞌisɨ ꞌra, kɨ̀ takɔbɨ-je lay kɨ́ dꞌisɨ ꞌpa lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngà dow kɨ́ rá-rá kɨ́ pa ta kɔbɨ kɨ̀ Ndil kɨ́ aa njay lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é nda̰ al. Ta lə majal kɨ́ tò sartagangɨ uwə dɔ-é.» ");
INSERT INTO mge_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jeju pa sə-dé ta kinlé bè kdɔ dḛ ꞌpanè: «Ḛ ɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kɔ̰ Jeju dḛ kɨ̀ ngankɔ̰ Jeju-je ꞌree dꞌa̰ takəy-tɨ, dꞌulə kulə kadɨ ꞌɓa-é dꞌadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kosɨ dow-je dꞌisɨ nangɨ rɨpɨ-rɨpɨ dꞌilə-na̰ ꞌgəə dɔ Jeju sipɨ ɓá dꞌidə-é ꞌpanè: «ꞌOo! Kɔ̰-i kɨ̀ ngankɔ̰-i-je kɨ̀ kɔ̰nan-i-je dꞌa̰ ndaa-tɨ dꞌa̰ ꞌsangɨ-i.» ");
INSERT INTO mge_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jeju ilə-dé-tɨ panè: «Ná̰-je ɓá ꞌto kɔ̰-m-je kɨ̀ ngankɔ̰-m-je wa?» ");
INSERT INTO mge_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Go-tɨ, ḛ un kəm-é oo-né kosɨ dow-je kɨ́ dꞌisɨ nangɨ ꞌgəə dɔ-é lé ngá ɓá panè: «Yən! Kɔ̰-m-je kɨ̀ ngankɔ̰-m-je ə́n. ");
INSERT INTO mge_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kdɔ dow kɨ́ ra né kɨ́ mḛḛ Lubə ndigɨ kin ɓá to ngonkɔ̰-m, əse to kɔ̰nan-m, əse to kɔ̰-m.» ");
INSERT INTO mge_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jeju isɨ ndó né dow-je ta babo-tɨ. Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌree dꞌilə-na̰ ꞌgəə dɔ-é sipɨ adɨ ḛ al isɨ mḛḛ tò-tɨ dan babo-tɨ. Ngà kosɨ dow-je lé ɓá dꞌa̰ ngangɨ ba-tɨ ɗingɨ-ɗingɨ. ");
INSERT INTO mge_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jeju un gosta-je ɓá ndó-dé-né né-je n̰a̰ ə pa sə-dé ta mḛḛ néndó-tɨ liə lé panè: ");
INSERT INTO mge_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ooi! Njèndɔr ɔw kdɔ kilə ko. ");
INSERT INTO mge_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lokɨ a̰ ilə ko lé, ka̰a̰ né kɨ́ dan-tɨ-je tusɨ dɔ rəbɨ-tɨ adɨ yəl-je ꞌree ꞌtú lə̰́-lə̰́. ");
INSERT INTO mge_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka̰a̰ né kɨ́ ná̰-je tusɨ dɔ ər-je-tɨ, lo-tɨ kɨ́ nangɨ n̰a̰-tɨ al; rəmə kubə ɓá ubə kalangɨ, kdɔ nangɨ ndəə dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngà lokɨ kàdɨ̀ ree ɔsɨ dɔ-tɨ lé, ndole ə tutɨ kurum, kdɔ njirə-é ɔw nangɨ n̰a̰ al. ");
INSERT INTO mge_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka̰a̰ né kɨ́ dan-tɨ-je tusɨ dan kun-je-tɨ; lokɨ kun tɔgɨ lé, ɔ̰̀ rɔ dɔ-tɨ gə́gə́gə́ adɨ ko-é ində al. ");
INSERT INTO mge_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka̰a̰ né kɨ́ ná̰-je tusɨ nangɨ-tɨ kɨ́ majɨ, adɨ tɔgɨ ɔr dɔ-é majɨ. Beɓa dɔ-é kɨ́ dan-tɨ-je ka̰a̰-é ra-tɨ kɔrmutə-je, ḛ kɨ́ ka̰a̰-é ra-tɨ kɔrmɛkḛ-je, ḛ kɨ́ ra-tɨ ɓu-je.» ");
INSERT INTO mge_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Go-tɨ, Jeju panè: «Dow kɨ́ mbi-é tò nɔ̰ɔ̰ kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé.» ");
INSERT INTO mge_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lokɨ Jeju ɔr rɔ-é rɔ kosɨ dow-je-tɨ a̰ sa̰y sə-dé rəmə, dow-je kɨ́ ꞌgəə dɔ-é kɨ̀ dḛ kɨ́ dɔgɨ gidɨ-é joo ꞌree ꞌdəjɨ-é ta dɔ gosta-je-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Beɓa ḛ idə-dé panè: «Sə̰i lé, né kɨ́ tò lo ɓɔyɔ-é-tɨ sɔbɨ dɔ kɔ̰ɓe lə Lubə lé tokɨ tḛḛ kɨ̀ dɔ-é kadɨ-si; ngà dḛ kɨ́ ndaa-tɨ lé, né-je lay ya tokɨ kidə-dé kɨ̀ gosta-gosta.» ");
INSERT INTO mge_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","«Kdɔ kadɨ lé dꞌoo lo majɨ ya kàrè, dꞌoo kɨ koo ya ndə̰ bè rəm, Ɓá lé dꞌoo ta majɨ ya kàrè rəmə, ꞌgə mḛḛ-é al rəm, Nè dꞌa kḭ kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ Kadɨ Lubə ḭ in̰ə-né go majal-je lə-dé kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jeju təl idə-dé ɓəy panè: «Gosta kin ya ꞌgəi mḛḛ-é al bè lé, ndəgɨ gosta-je lay kinlé a rai ban ɓá a gəi mḛḛ-é wa? ");
INSERT INTO mge_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Njèkilə ko lé, to njèkilə mbḛ ta lə Lubə. ");
INSERT INTO mge_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dɔ rəbɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə ya rəmə, tajinatɨ nè ya Sata̰ ree ɔr ta lé mḛḛ-dé-tɨ kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bè ya tɔ, nangɨ ər kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə rəmə ꞌtaa kalangɨ kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngà ta kinlé ulə njirə mḛḛ-dé-tɨ al; adɨ dꞌa̰ dɔ-tɨ kaglo n̰a̰ al. Beɓa lokɨ kɔ̰̀-je kɨ́ dum natɨ əse kulə kəm ndoo kdɔ ta lə Lubə tḛḛ dɔ-dé-tɨ rəmə, kalangɨ bè ya dḛ ꞌtusɨ kadmḛḛ lə-dé dꞌin̰ə kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Dan kun-je kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə ya, ");
INSERT INTO mge_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngà go-tɨ rəmə, mḛḛ ka̰ kə́kə́kə́ kdɔ né-je kɨ́ dɔnangɨ-tɨ nè, kɨ̀ ɓo nékingə-je, kɨ̀ ɓo né-je kɨ́ gay-gay utɨ dɔ ta lé adɨ kandɨ-é goto. ");
INSERT INTO mge_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nangɨ kɨ́ majɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə ə ꞌndigɨ dɔ-tɨ adɨ kandɨ-é tò; beɓa dɔ-é kɨ́ dan-tɨ-je kandɨ-é ra-tɨ kɔrmutə-je, ḛ kɨ́ kandɨ-é ra-tɨ kɔrmɛkḛ-je, ḛ kɨ́ kandɨ-é ra-tɨ ɓu-je.» ");
INSERT INTO mge_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jeju təl idə-dé ɓəy panè: «Se lampɨ lé, dow à jəbɨ ngó dɔ-tɨ wa? Əse à kində gin tɨrə-tɨ wa? À na̰a̰ kagna̰a̰ lampɨ-tɨ taá ya al wa? ");
INSERT INTO mge_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kdɔ né kɨ́ dow ɓɔyɔ kɨ́ à ree tò ndaa-tɨ rəsɨ al ya goto rəm, ɓá né kɨ́ ra kɨ̀ gidɨ ngə̰y kɨ́ à tokɨ tḛḛ-né ndaa-tɨ rəsɨ al kàrè goto rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kinə dow kɨ́ mbi-é tò kadɨ oo-né ta rəmə, kadɨ oo.» ");
INSERT INTO mge_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jeju təl idə-dé ɓəy panè: «Indəi kəmkaa dɔ rɔ-si-tɨ sɔbɨ dɔ ta-je kɨ́ ooi. Né kɨ́ ꞌmbɔji-né né adi dow kinlé, ḛ ya dꞌa təl mbɔjɨ-né né kadɨ-si rəm, ɓá dꞌa təl kungɨ kɨ́ rangɨ dɔ-tɨ kadɨ-si ya ɓəy rəm. ");
INSERT INTO mge_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kdɔ dow kɨ́ né tò ji-é-tɨ ɓá dꞌa kadɨ-é kɨ́ rangɨ dɔ-tɨ; ngà dow kɨ́ né goto ji-é-tɨ lé, kɨ́ ji-é-tɨ ya kàrè dꞌa taa.» ");
INSERT INTO mge_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jeju təl idə-dé ɓəy panè: «Kɔ̰ɓe lə Lubə lé tò titɨ-na̰ kɨ̀ ta lə dow kɨ́ tḛḛ ɔw ilə ko mḛḛ ndɔr-tɨ liə bè; ");
INSERT INTO mge_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","lé dowbé tò ɓi əse isɨ kəm ndɔɔ-je kada-je kàrè ko né lé, ubə rəm, tɔgɨ rəm, ɓɨ ḛ gə lo-é al ngá. ");
INSERT INTO mge_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nangɨ ya adɨ ko né-é ubə; dɔsa̰y to mbi ko, go-tɨ ɔr dɔ-é ə kandɨ gemḛ kɨ́ majɨ ində dɔ-tɨ; ");
INSERT INTO mge_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ə lokɨ ka̰a̰-é ɔr majɨ rəmə, kalangɨ bè ya dꞌun ngɔrɔngɨ dꞌijə-né. Kdɔtalə na̰y kijə ko asɨ ngá.» ");
INSERT INTO mge_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jeju pa ɓəy panè: «Ri ɓá jꞌa kɔji-né kɔ̰ɓe lə Lubə wa? Gosta kɨ́ ban ɓá jꞌa kuni tɔji-né kɔ̰ɓe lə Lubə wa? ");
INSERT INTO mge_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kɔ̰ɓe lə Lubə lé, titɨ-na̰ kɨ̀ ka̰a̰ kɔl kɨ́ to ka̰a̰ né kɨ́ tò ngon-é ndḛ bè itə ka̰a̰ né-je lay kɨ́ dɔnangɨ-tɨ nè kɨ́ dow-je ꞌdubɨ. ");
INSERT INTO mge_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngà lokɨ dow dubɨ lé, ḛ tɔgɨ itə kagɨ-je lay kɨ́ mḛḛ ndɔr-tɨ, adɨ balkəm-é-je boy sar tugə ndil, adɨ yəl-je kɨ́ ꞌnar taá ꞌra kəy-dé-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeju ndó dow-je ta lə Lubə kɨ̀ gosta-je kɨ́ bè kin n̰a̰-n̰a̰ kɨ̀ gangɨ-é kɨ́ dꞌasɨ kadɨ ꞌgə-né mḛḛ ta liə. ");
INSERT INTO mge_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Néndó liə kɨ́ nal gosta goto; ngà lokɨ ḛ ɔr rɔ-é isɨ kɨ̀ kár-é kɨ̀ njéndó né-je liə lé, ḛ ɔr mḛḛ gosta-je lé lay adɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mḛḛ ndɔ-é-tɨ kinlé ya, losɔlɔ biriri rəmə, Jeju idə njéndó né-je liə panè: «Adɨ jꞌgangi babo jꞌɔwi turə.» ");
INSERT INTO mge_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Beɓa njéndó né-je ꞌtusɨ kosɨ dow-je dꞌin̰ə-dé ə tò kɨ́ Jeju isɨ mḛḛ-é-tɨ lé ya dḛ dꞌɔtɨ dꞌɔw-né siə. Tò-je kɨ́ rangɨ tò ngɔsi kàdɨ̀ tò-tɨ kɨ́ Jeju isɨ-tɨ lé tɔ. ");
INSERT INTO mge_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ya rəmə, yə́lbo ulə mbḭ-mbḭ, ə pungum man ɔsɨ tò yó-je kɨ né-je adɨ man ɔw mḛḛ tò-tɨ mbing nà̰y n̰a̰ al kadɨ man rusɨ mḛḛ tò. ");
INSERT INTO mge_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ə Jeju gətɨ dɔ-é kɨ̀ négətɨ dɔ mɔngɨ tò-tɨ ə tò tò ɓi. Beɓa njéndó né-je liə ꞌndəl-é dꞌidə-é ꞌpanè: «Njèndó dow-je né! Ko-ji kɨ́ isɨ tɔɔ kinlé ꞌusɨ-i-tɨ al wa?» ");
INSERT INTO mge_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lokɨ Jeju tḛḛ kəm-é rəmə, ḛ ndángɨ yə́lbo lé, ə təl pa kɨ̀ babo panè: «ꞌAdi lo tò ndingɨ! Asɨ bè!» Rəmə gin yə́lbo lé gangɨ adɨ lo təl tò ndingɨ. ");
INSERT INTO mge_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Go-tɨ, ḛ pa sə-dé panè: «ꞌƁəli n̰a̰ bè kdɔ ri wa? ꞌAdi mḛḛ-si al ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓəl ində bandɨ-dé gangɨ adɨ ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: «Kay! Dow kanlé to dow kɨ́ ban ya ɓá yə́l-je kɨ̀ babo-je kàrè ꞌtəl rɔ-dé go ta-tɨ liə bè wa?» ");
INSERT INTO mge_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jeju dḛ kɨ̀ njéndó né-je liə ꞌgangɨ babo dꞌɔw kəl-é kɨ́ nṵ-tɨ dɔnangɨ Gerasa-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lokɨ Jeju ḭ mḛḛ tò-tɨ ur nangɨ bè ya rəmə, dingəm káre kɨ́ ndil-je kɨ́ majɨ al ꞌra-é tḛḛ dan ɓadɨ-je-tɨ ree rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dingəm-é lé, dɔɓadɨ-je ɓá to lo kisɨ-é ə dow kɨ́ asɨ kilə-é sil ya goto. ");
INSERT INTO mge_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Taá-taá ya dꞌulə ngɔwla nja-é-tɨ ɓá dꞌilə-é-né sil, ngà taá-taá ya ḛ gángɨ ngɔwla kɨ́ nja-é-tɨ kɨ̀ sil-je lé, adɨ dow kɨ́ tɔ́gɨ-é asɨ kadɨ taa tɔ́gɨ-é ya goto. ");
INSERT INTO mge_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ndɔɔ-je, kɨ̀ kada-je lay ya lo taakoo liə goto, adɨ ḛ ɔw ilə kɨ̀ dɔ ɓadɨ-je kɨ̀ dɔ ngan mbal-je, tur kəə taá-taá ə rə́tɨ rɔ-é kɨ̀ ər. ");
INSERT INTO mge_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lokɨ un kəm-é oo Jeju sa̰y lé, ḛ a̰y ngɔdɨ ɔw ɔsɨ dɔ-é nangɨ nɔ̰̀-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ə ilə bɔbɨ ndi-é nangɨ panè: «I Jeju, Ngon lə Lubə kɨ́ Njèkisɨ taá dɔra̰-tɨ nṵ lé, ꞌge ri rɔ-m-tɨ wa? Kɔgri ya, kɨ̀ ri Lubə, ꞌulə kəm-m ndoo al!» ");
INSERT INTO mge_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ḛ pa bè kdɔ Jeju panè: «I Ndil kɨ́ majɨ al, ꞌtḛḛ mḛḛ dow-tɨ kin kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jeju təl dəjɨ-é panè: «Ri-i lə ná̰ wa?» Ḛ təl ilə-é-tɨ panè: «Ri-m lə kosɨ-je. Kdɔtalə jḛ lé jꞌn̰a̰.» ");
INSERT INTO mge_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngá ɓá dḛ ꞌtəl ꞌdəjɨ Jeju kɨ̀ nɔ̰ kəm-dé-tɨ kadɨ tubə-dé kɔgɨ dɔnangɨ-tɨ kin al. ");
INSERT INTO mge_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lo-é-tɨ kinlé kosɨ kɔsɔngɨ-je dꞌa̰ kàdɨ̀ mbal-tɨ ngɔsi dꞌa̰ dꞌuso né. ");
INSERT INTO mge_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ə ndil-je kɨ́ majɨ al lé ꞌra ndoo ta Jeju-tɨ ꞌpanè: «ꞌAdɨ jꞌɔw jꞌandɨ mḛḛ kɔsɔngɨ-je-tɨ kan.» ");
INSERT INTO mge_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jeju ndigɨ sə-dé ya tɔ. Beɓa ndil-je kɨ́ majɨ al lé ꞌtḛḛ mḛḛ dingəm-tɨ dꞌɔw ꞌtur mḛḛ kɔsɔngɨ-je-tɨ lé adɨ kɔsɔngɨ-je lé ꞌtətɨ-na̰ yipɨ kàdɨ̀ mbal-tɨ taá, ꞌtusɨ babo-tɨ ꞌnduy man. Kɔsɔngɨ-je lé kɔr-dé à kasɨ ɓudɔgɨ lo joo je bè. ");
INSERT INTO mge_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Go-tɨ, njéngəm kɔsɔngɨ-je lé dꞌa̰y dꞌɔw dꞌɔr poy-é mḛḛ ɓebo-tɨ, mḛḛ nganɓe-je-tɨ rəm. Beɓa dow-je dꞌɔtɨ ꞌree dꞌoo né kɨ́ ra né lé. ");
INSERT INTO mge_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lokɨ dḛ ꞌree rɔ Jeju-tɨ lé, dꞌoo dingəm kɨ́ ɔw kɨ̀ ndil-je kɨ́ majɨ al n̰a̰ mḛḛ-é-tɨ lé, isɨ nangɨ, ulə kubɨ rɔ-é-tɨ, təl isɨ majɨ kare gogɨ; ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dow-je kɨ́ dꞌoo né-je kɨ́ ra-né kin kɨ̀ kəm-dé lé dꞌɔr-dé poy dingəm kɨ́ ndil-je kɨ́ majɨ al ꞌtḛḛ mḛḛ-é-tɨ lé rəm, ɓá dꞌɔr-dé poy né kɨ́ tḛḛ dɔ kɔsɔngɨ-je-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Beɓa dow-je ꞌra ndoo ta Jeju-tɨ kadɨ in̰ə dɔnangɨ lə-dé ə ɔw rangɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lokɨ Jeju təl al mḛḛ tò-tɨ gogɨ rəmə, dingəm kɨ́ ḛ tubə ndil-je kɨ́ majɨ al dɔ-é-tɨ lé dəjɨ-é kadɨ nꞌɔw siə. ");
INSERT INTO mge_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jeju ndigɨ siə al, ngà idə-é panè: «ꞌTəl ꞌɔw ɓee lə-i, rɔ nojɨ-i-je-tɨ, ə koo kɨ́ ꞌƁaɓe oo kəmtondoo lə-i, kɨ̀ né-je lay kɨ́ ḛ ra sə-i kinlé, ɔr poy-é adɨ dꞌoo.» ");
INSERT INTO mge_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Beɓa dingəm lé, ɔw ɔr poy né-je lay ya kɨ́ Jeju ra siə lé mḛḛ ɓebo-je-tɨ kɨ́ dɔgɨ adɨ dow-je lay kɨ́ dꞌoo lé, ta igɨ-dé sə́l. ");
INSERT INTO mge_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jeju al mḛḛ tò-tɨ gangɨ babo ɔw gogɨ. Lokɨ ḛ nà̰y ta babo-tɨ ya ɓəy rəmə, kosɨ dow-je ꞌtəl ꞌree ꞌgəə dɔ-é sipɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Beɓa dingəm káre kɨ́ to kɨ́ dan dḛ-tɨ kɨ́ ꞌto njékun dɔ kəykəwna̰ lə jipɨ-je kɨ́ ri-é lə Jayrusɨ ree, ɓá oo Jeju rəmə usɨ nangɨ nja-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dəjɨ-é kɨ̀ nɔ̰ kəm-é-tɨ panè: «Ngon-m kɨ́ dené tò oy nangɨ nɔ̰ɔ̰, ə kɔgri ya, ꞌree ꞌɔw ꞌində ji-i dɔ-é-tɨ adɨ-é ingə lapiya ə isɨ kɨ̀ dɔ-é taá adɨ-m!» ");
INSERT INTO mge_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Beɓa Jeju ɔtɨ ɔw siə. Ə kosɨ dow-je dꞌun go-é, ꞌmbore-é yó-je kɨ nè-je. ");
INSERT INTO mge_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ə dené kɨ́ məsɨ ree rɔ-é-tɨ ɓal dɔgɨ gidɨ-é joo a̰ dan-dé-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dené-é lé ingə kɔ̰̀ n̰a̰, ilə go dɔktur-je-tɨ kɨ kete-kete; ḛ tujɨ nékingə-é kɔgɨ lay ya kàrè né kɨ́ tò-é sotɨ goto; ngà mɔ̰y lé ɔw kɨ kete ya par-par. ");
INSERT INTO mge_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Beɓa lokɨ ḛ oo poy Jeju rəmə, ree ur dan kosɨ dow-je-tɨ, a̰ gidɨ-é-tɨ, ə ulə ji-é ɔdɨ-né takubɨ liə. ");
INSERT INTO mge_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kdɔtalə ḛ pa mḛḛ-é-tɨ panè: «Kinə kubɨ liə ya mꞌulə ji-m mꞌɔdɨ ə mꞌa kingə lapiya.» ");
INSERT INTO mge_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Rəmə tajinatɨ nè ya gin məsɨ lé gangɨ, adɨ ḛ gə kɨ́ nꞌingə lapiya. ");
INSERT INTO mge_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ə tajinatɨ nè ya Jeju gə kɨ́ tɔ́gɨ kɨ́ rɔ-nꞌḛ̀-tɨ tḛḛ. Beɓa ḛ təl ilə rətɨ dan kosɨ dow-je-tɨ dəjɨ panè: «Ná̰ ɓá ɔdɨ kubɨ lə-m wa?» ");
INSERT INTO mge_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Njéndó né-je liə dꞌilə-é-tɨ ꞌpanè: «Kosɨ dow-je kɨ́ dꞌa̰ ꞌmbor-i yó-je kɨ nè-je kin ya ꞌtəl dəjɨ dow kɨ́ ɔdɨ rɔ-i ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngà ɓá Jeju təl gɔ̰ lo gəə gidɨ-é kadɨ nꞌoo dow kɨ́ njèra né kinlé. ");
INSERT INTO mge_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rəmə dené lé ɓəl rəm, dadɨ rəm, kdɔtalə ḛ gə né kɨ́ tḛḛ dɔ-é-tɨ lé. Beɓa ḛ ree usɨ nangɨ nja Jeju-tɨ ə idə-é ta kɨ́ tɔgrɔ-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jeju təl idə-é panè: «Ngon-m! Kadmḛḛ lə-i ajɨ-i. ꞌƆw kɨ̀ lapiya, kadɨ mɔ̰y lə-i lé in̰ə-i.» ");
INSERT INTO mge_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lokɨ Jeju a̰ pa ta bè ɓəy ya rəmə, ngannjékullə-je dꞌḭ ɓe lə njékun dɔ kəykəwna̰ lə jipɨ-je ꞌree go-é-tɨ dꞌidə-é ꞌpanè: «Ngon-i lé oy ngá. Ngà i ꞌndɔjɨ njèndó dow-je né kdɔ ri ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngà Jeju ilə ká ta-je-tɨ lə-dé lé al, adɨ idə njékun dɔ kəykəwna̰ lé ꞌpanè: «ꞌƁəl al, mḛḛ-i ya ꞌadɨ-m par.» ");
INSERT INTO mge_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jeju adɨ dow kɨ́ rangɨ dan-é al; ngà Piyər, kɨ̀ Jakɨ, kɨ̀ Ja̰ kɨ́ ngonkɔ̰ Jakɨ ya par ꞌdan-é. ");
INSERT INTO mge_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lokɨ dꞌɔw ꞌtḛḛ ɓee lə njékun dɔ kəykəwna̰ lə jipɨ-je lé rəmə, Jeju oo kɨ́ dow-je dꞌɔw dɔ-na̰-tɨ wúr-wùr, ꞌnɔ̰, dꞌində sul-dé boy-boy. ");
INSERT INTO mge_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Beɓa Jeju andɨ kəy go-dé-tɨ pa sə-dé panè: «Kdɔ ri ɓá sə̰i ɔwi-né dɔ-na̰-tɨ wúr-wùr bè wa? Kdɔ ri ɓá sə̰i ꞌnɔ̰i-né bè wa? Ngon kɨ́ dené kinlé oy al, ḛ tò ɓi kɨ tò.» ");
INSERT INTO mge_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Rəmə dow-je ꞌsɔkɨ Jeju. Beɓa ḛ tubə-dé adɨ ꞌtḛḛ ndaa-tɨ ə adɨ bɔbɨ ngon kɨ̀ kɔ̰ ngon kɨ̀ dḛ kɨ́ ꞌdan-é lé dꞌɔw siə lo-tɨ kɨ́ ngon lé tò-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jeju uwə ji ngon lé ə idə-é panè: «Talita kumi!» Kɔr mḛḛ-é to: «Ngonmandɨ! Mꞌidə-i mꞌpanè: ꞌḬ taá.» ");
INSERT INTO mge_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Rəmə tajinatɨ nè ya ngonmandɨ lé ḭ taá njiyə. Kdɔtalə to ngonmandɨ kɨ́ ra ɓal dɔgɨ gidɨ-é joo. Dḛ kɨ́ dꞌa̰ lo-é-tɨ lé ndil-dé tḛḛ sa̰y, ta igɨ-dé sə́l. ");
INSERT INTO mge_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jeju ndəjɨ-dé n̰a̰ kadɨ ꞌpa dꞌadɨ dow oo al ə idə-dé ꞌpanè: «ꞌAdi-é né uso.» ");
INSERT INTO mge_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeju ḭ lo-é-tɨ kinlé ɔw ɓekojɨ-é-tɨ gogɨ. Njéndó né-je liə dꞌɔw siə natɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lokɨ ndɔ taakoo lə jipɨ-je asɨ lé, Jeju ndó dow-je né mḛḛ kəykəwna̰-tɨ lə jipɨ-je. Dow-je n̰a̰ ya kɨ́ dꞌoo néndó liə lé, néndó liə ɔr ndil-dé adɨ ꞌpanè: Kay! Dow kinlé ḭ kɨ̀ né-je kinlé rá wa? Gosɨ kinlé ingə rá wa? Ə ḛ ra ban ɓá ra-né nékɔjɨ-je kɨ́ bè kinlé wa? ");
INSERT INTO mge_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ḛ ya ɓá to kɔdɨ kijə kagɨ kɨ́ ngon lə Mari lé al wa? Ngankɔ̰-é-je ya ꞌto Jakɨ, kɨ̀ Jojɛsɨ, kɨ̀ Jude, kɨ̀ Simɔ̰-je, ə kɔ̰nan-é-je ya dꞌisɨ dan-ji-tɨ nè tin al wa? Né-je kin ya ra adɨ Jeju təl jigɨ nɔ̰̀-dé-tɨ ɔgɨ-dé kadɨ dꞌadɨ-é mḛḛ-dé. ");
INSERT INTO mge_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Beɓa Jeju pa sə-dé panè: «Njèpata kɨ́ ta Lubə-tɨ lé, dow-je kɨ́ mḛḛ ɓekojɨ-é-tɨ, kɨ̀ dan nojɨ-é-je-tɨ, kɨ̀ mḛḛ kəy-tɨ liə ya par dꞌa nədɨ-é.» ");
INSERT INTO mge_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gin-é kin ɓá nékɔjɨ káre ya kàrè Jeju asɨ ra-né ɓekojɨ-é-tɨ al. Njémɔ̰y-je kɨ́ dan-tɨ-je ya par ɓá ḛ ində ji-é dɔ-dé-tɨ adɨ dꞌingə lapiya. ");
INSERT INTO mge_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mḛḛnga̰ lə-dé ra adɨ ta igɨ Jeju səl. Beɓa Jeju ɔw nganɓe-je-tɨ kɨ́ dɔ lo-tɨ nɔ̰ɔ̰ ndó dow-je né. ");
INSERT INTO mge_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jeju ɓa njékɔwkulə-je liə kɨ́ dɔgɨ gidɨ-é joo ə ulə-dé joo-joo ə adɨ-dé tɔ́gɨ dɔ ndil-je-tɨ kɨ́ majɨ al. ");
INSERT INTO mge_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ḛ ndəjɨ-dé panè: Lokɨ isi ɔwi lé, uni né kɔw mba ji-si-tɨ al, salangɨ ya par ə́ uni. Uni mbə̀ al rəm, uni mbu kɔw mba al rəm, ɓá iləi là posɨ-si-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ngà idə-dé panè: «Uləi saba nja-si-tɨ, ə uləi kubɨ dɔ-na̰-tɨ joo al.» ");
INSERT INTO mge_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jeju idə-dé ɓəy panè: Mḛḛ kəy kɨ́ ɔwi-tɨ lé, mḛḛ kəy-é kin ya isi-tɨ sar kadɨ ḭi-né. ");
INSERT INTO mge_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ə kinə dꞌuwə-si kɨ rɔ-dé-tɨ al rəm, dꞌoo ta lə-si al rəm, ɓá isi ꞌtḛḛi mḛḛ ɓe-é-tɨ kinlé rəmə, ꞌgəki kodɨ kɨ́ nja-si-tɨ kɔgɨ kadɨ tɔjɨ kɨ́ ta tò dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Beɓa dḛ dꞌɔw dꞌilə mbḛ kdɔ kadɨ dow-je dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dḛ ꞌtubə ndil-je kɨ́ majɨ al n̰a̰ ya dɔ dow-je-tɨ kɔgɨ rəm, ɓá njémɔ̰y-je n̰a̰ ya dꞌur ubɨ dɔ-dé-tɨ adɨ dꞌingə lapiya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ngar Erodɨ oo poy Jeju; kdɔtalə ri-é ɓa mbing adɨ dow-je ꞌpanè: «To Ja̰ kɨ́ njèra dow-je batḛm kɨ́ ndɔkɨ oy lé ɓá tɔsɨ ndəl ində lo tḛḛ, ɓá ɔw-né kɨ̀ tɔ́gɨ ra-né nékɔjɨ-je kinlé.» ");
INSERT INTO mge_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dḛ kɨ́ dan-tɨ-je ꞌpanè: «To Eli», dḛ kɨ́ ná̰-je ꞌpanè: «To kɨ́ káre dan njépata-je-tɨ kɨ́ ta Lubə-tɨ kɨ́ kete.» ");
INSERT INTO mge_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngà lokɨ Erodɨ oo ta kinlé, ḛ panè: «To Ja̰ kɨ́ njéra dow-je batḛm kɨ́ ndɔkɨ mꞌadɨ ꞌgangɨ dɔ-é lé ɓá təl tɔsɨ ndəl ində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kdɔ ndɔkɨ Erodɨ ya adɨ dꞌuwə Ja̰ ꞌdɔɔ-é kɨ̀ kullə gindingɨ, dꞌilə-é dangay-tɨ, kdɔtalə Erodɨ dḛ kɨ̀ Pilipɨ ꞌto ngankɔ̰-na̰-je, ya rəmə Erodɨ təl taa Erodiadɨ, kɨ́ ne Pilipɨ, ");
INSERT INTO mge_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ɓá Ja̰ idə-é panè: «Taa kɨ́ ꞌtaa Erodiadɨ kɨ́ ne ngonkɔ̰-i kinlé to tó-é al.» ");
INSERT INTO mge_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wɔngɨ ra Erodiadɨ n̰a̰ adɨ sangɨ rəbɨ tɔl-é, ngà ingə rəbɨ-é al, ");
INSERT INTO mge_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kdɔ Erodɨ ɓəl Ja̰, kdɔtalə ḛ gə kɨ́ Ja̰ lé to dow kɨ́ njururu rəm, aa njay rəm adɨ ḛ ngəm-é. Lokɨ ḛ oo ta-je kɨ́ Ja̰ pa pa lé mḛḛ-é uwə-é kɨ̀ ta n̰a̰; bè ya kàrè ta-je liə nəl-é koo. ");
INSERT INTO mge_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngà ndɔ madɨ, Erodiadɨ ingə kəm lo kɨ́ majɨ ndɔ ra na̰y kojɨ Erodɨ-tɨ. Ndɔ-é-tɨ kinlé Erodɨ ra nékuso ɓa-né dow-je kɨ́ boy-boy kɨ́ njékisɨ dɔ ɓe-tɨ, kɨ̀ ꞌboy lə Asgar-je rəm, kɨ̀ dow-je kɨ́ ri-dé ɓa dɔnangɨ Galile-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngon lə Erodiadɨ kɨ́ dené andɨ kəy go-dé-tɨ ə ndam adɨ nəl Erodɨ n̰a̰ rəm, nəl dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ lé n̰a̰ rəm tɔ. Beɓa ngar idə ngon kɨ́ dené lé panè: Né kɨ́ mḛḛ-i ndigɨ ya ꞌdəjɨ-m, ə mꞌa kadɨ-i. ");
INSERT INTO mge_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ngar un mindɨ-é panè: «Mꞌubɨ rɔ-m madɨ-i kadɨ ri-ri ya kɨ́ i dəjɨ-m lé, mꞌa kadɨ-i. Lé to dəbɨ kɔ̰ɓe lə-m ya kàrè mꞌa kadɨ-i.» ");
INSERT INTO mge_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Beɓa ngon kɨ́ dené lé tḛḛ ɔw dəjɨ kɔ̰-é panè: «Ri ɓá kadɨ mꞌdəjɨ ngar lé wa?» Kɔ̰-é idə-é panè: «ꞌDəjɨ dɔ Ja̰ kɨ́ njèra dow-je batḛm.» ");
INSERT INTO mge_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tajinatɨ nè ya ngon kɨ́ dené lé, təl ɔw rɔ Ngar-tɨ panè: «Mꞌndigɨ kadɨ lo kɨ́ nè-tɨ kin ya ꞌilə dɔ Ja̰ kɨ́ njèra dow-je batḛm mḛḛ supra-tɨ adɨ-m.» ");
INSERT INTO mge_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rɔ ngar nəl-é al, ya ngà ḛ asɨ kɔgɨ-é al, kdɔ kubɨ kɨ́ ḛ ubɨ rɔ-é rəm, kdɔ takəm kosɨ dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tajinatɨ nè ya ngar un ndu adɨ asgar káre kadɨ ɔw ree kɨ̀ dɔ Ja̰ kɨ́ njèra dow-je batḛm lé. ");
INSERT INTO mge_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Beɓa asgar lé ɔw kəy dangay-tɨ, ɔw gangɨ dɔ Ja̰ ilə mḛḛ supra-tɨ ree-né adɨ ngon kɨ́ dené lé ə ḛ ɔw-né adɨ kɔ̰-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lokɨ njéndó né-je lə Ja̰ dꞌoo poy-é lé, dḛ ꞌree dꞌun nin-é dꞌɔw ꞌdubɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Njékɔwkulə-je lə Jeju ꞌtəl ree rɔ-é-tɨ dꞌɔr-é poy né-je lay kɨ́ dḛ ꞌra rəm, né-je lay kɨ́ dḛ ꞌndó dow-je lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lo-é-tɨ kinlé kosɨ dow-je kɨ́ dꞌɔw rəm, ꞌtəl rəm lé dꞌɔgɨ Jeju kɨ̀ njékɔwkulə-je liə lo kuso né. Beɓa Jeju idə njékɔwkulə-je panè: «Adɨ jꞌɔri rɔ-ji ngərəngɨ kdɔ kadɨ sə̰i kàrè ꞌtaai koo sḛ tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Beɓa dḛ dꞌal mḛḛ tò-tɨ kdɔ kadɨ dꞌɔw dꞌisɨ diləlo-tɨ ngərəngɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bè ya kàrè, kosɨ dow-je kɨ́ dꞌoo-dé lo kɔw-tɨ ə ꞌgə-dé lé, dꞌḭ kɨ̀ ɓebo-je kɨ́ gay-gay dꞌa̰y kɨ̀ nja-dé dꞌɔw kete nɔ̰̀-dé-tɨ lo-tɨ kɨ́ dꞌisɨ dꞌɔw-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lokɨ Jeju ur nangɨ mḛḛ tò-tɨ rəmə, oo kosɨ dow-je kɨ́ ꞌtò nduy-nduy ə ta ɔ̰̀ mḛḛ-é kdɔ ta lə-dé, kdɔ ꞌto kɨ́ batɨ-je kɨ́ njèkul-dé goto bè. Ḛ ndó-dé né-je n̰a̰ lo-é-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lokɨ kàdɨ̀ ɔw kɨ dɔ kur-tɨ lé, njéndó né-je liə ꞌree rɔ-é-tɨ dꞌidə-é ꞌpanè: «Kàdɨ̀ ɔw kɨ dɔ kur-tɨ ngá rəm, ɓá lo kin kàrè to diləlo rəm; ");
INSERT INTO mge_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ə́n ə́ ꞌɔsɨ-dé adɨ dꞌɔw kɨ kəylo-je-tɨ, kɨ̀ nganɓe-je kɨ́ dɔ lo-tɨ nè kdɔ kadɨ ꞌndogɨ né dꞌuso.» ");
INSERT INTO mge_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jeju təl idə-dé panè: «Sə̰i ya adi-dé né dꞌuso.» Ngà njékɔwkulə-je ꞌtəl dəjɨ-é ꞌpanè: «Kadɨ jꞌɔw jꞌndogɨ mbə̀ kəm là kullə kɨ́ ndɔ ɓujoo jꞌree-né jꞌadɨ dꞌuso wa?» ");
INSERT INTO mge_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Beɓa ḛ təl dəjɨ-dé panè: «Mbə̀ kandangɨ ɓá tò ji-si-tɨ wa? Ɔwi ꞌgɔ̰i ooi.» Lokɨ dꞌɔw dꞌoo lé, ꞌree dꞌidə-é ꞌpanè: «Jꞌɔw kɨ̀ mbə̀ mḭ kɨ̀ kanjɨ joo.» ");
INSERT INTO mge_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ngá ɓá ḛ un ndu adɨ-dé panè: «Uwəi dow-je kɨ̀ kutɨ-é kutɨ-é adi-dé dꞌisɨ dɔ wale-tɨ kɨ́ mbəl.» ");
INSERT INTO mge_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dow-je dꞌisɨ kɨ̀ bar-é bar-é, dꞌuwə-na̰ ɓu-je kɨ̀ kɔrmḭ-je. ");
INSERT INTO mge_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jeju ɔy mbə̀ kɨ́ mḭ kɨ̀ kanjɨ kɨ́ joo lé, un kəm-é kɨ taá dɔra̰-tɨ, ra oiyo Lubə. Go-tɨ, ḛ gangɨ mbə̀ lé dana̰, təl-né adɨ njéndó né-je kdɔ kadɨ ꞌləbɨ dow-je. Ḛ təl gángɨ kanjɨ kɨ́ joo lé kdɔ dow-je lay tɔ. ");
INSERT INTO mge_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dow-je lay ya dꞌuso né ꞌndan ndə̰́-ndə̰́. ");
INSERT INTO mge_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Dɔdum mbə̀ kɨ̀ dɔdum kanjɨ lé nà̰y adɨ njéndó né-je dꞌɔy rusɨ kàrè dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dow-je kɨ́ dꞌuso mbə̀ kinlé, dingəm-je ꞌra ɓudɔgɨ lo mḭ. ");
INSERT INTO mge_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Go-tɨ rəmə, tajinatɨ nè ya Jeju ɔsɨ njéndó né-je liə adɨ dꞌal mḛḛ tò-tɨ kdɔ kadɨ dꞌɔw kete nɔ̰̀-é-tɨ gidɨ babo-tɨ kəl ɓebo-tɨ kɨ́ Betsayda ə ḛ a̰ nangɨ a̰ ɔsɨ kosɨ dow-je kadɨ ꞌtəl. ");
INSERT INTO mge_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lokɨ ḛ in̰ə kosɨ dow-je lé rəmə, ḛ ɔw al dɔ mbal-tɨ, kdɔ pa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lokɨ ndɔ ree il rəmə, tò a̰ dan babo-tɨ dana̰; ngà Jeju a̰ kɨ̀ kár-é nangɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rəmə un kəm-é oo-né njéndó né-je liə kɨ́ dꞌingə kɔ̰̀ n̰a̰ lo nəl tò-tɨ, kdɔtalə yə́l tilə kəm-dé. Taginlo-tɨ ngá ɓá Jeju njiyə dɔ man babo-tɨ ɔw kɨ rɔ-dé-tɨ ə ḛ ndigɨ kində ta-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Lokɨ dꞌoo-é ɔw njiyə dɔ man-tɨ rəmə, dḛ ꞌgɨr ꞌpanè to «ꞌmə̰́ dow!» Adɨ ꞌnɔ̰ mbitɨ-mbitɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kdɔtalə dḛ lay ya dꞌoo-é adɨ ɓəl ində bandɨ-dé gangɨ, rəmə tajinatɨ nè ya Jeju pa sə-dé panè: «Adi mḛḛ-si usɨ nangɨ, to ma̰ ɓəy ə́ ꞌɓəli al.» ");
INSERT INTO mge_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Go-tɨ, ḛ al isɨ sə-dé mḛḛ tò-tɨ rəmə gin yə́l lé gangɨ ɗəsɨ, adɨ ɔr ndil-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kdɔtalə nékɔjɨ kɨ́ sɔbɨ dɔ mbə̀ kɨ́ Jeju ra lé kəm-dé tḛḛ dɔ-tɨ al, kdɔ mḛḛnga̰ lə-dé. ");
INSERT INTO mge_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lokɨ dꞌində babo ꞌgangɨ ꞌtḛḛ dɔnangɨ Jenejarɛtɨ-tɨ rəmə, dꞌur nangɨ ꞌtɔ́ tò lə-dé ngangɨ ba-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lokɨ dꞌḭ mḛḛ tò-tɨ ꞌrusɨ nangɨ rəmə, kalangɨ bè ya dow-je dꞌoo Jeju ꞌgə-é, ");
INSERT INTO mge_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","adɨ dꞌa̰y dꞌɔw mḛḛ ɓe-je-tɨ kɨ́ go lo-je-tɨ kɨ́ tin kin lay ya dꞌotɨ njémɔ̰y-je mḛḛ tuwə-je-tɨ lə-dé ꞌree sə-dé lo-tɨ kɨ́ dꞌoo kɨ́ Jeju isɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lo-je lay kɨ́ Jeju ɔw-tɨ, nganɓe-je, kɨ̀ ɓebo-je, kɨ̀ ta ndɔr-je-tɨ lé, ꞌree kɨ̀ njémɔ̰y-je pandanglo-je-tɨ, ə ꞌra ndoo ta-é-tɨ kdɔ kadɨ adɨ njémɔ̰y-je lé dꞌɔdɨ takubɨ liə ya par. Rəmə dḛ lay kɨ́ dꞌɔdɨ takubɨ liə lé dꞌingə lapiya ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi-je, kɨ̀ dow-je kɨ́ ná̰-je kɨ́ ꞌto njéndó dow-je ndukun-je dꞌḭ mḛḛ ɓebo Jorijalḛm-tɨ ꞌree ꞌkəw-na̰ rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Rəmə dḛ dꞌoo kɨ́ njéndó né-je liə kɨ́ dan-tɨ-je ꞌtogɨ ji-dé al ya dꞌuso-né né, adɨ kɨ́ go né kɨ́ koɓe-tɨ lə-dé rəmə dḛ dꞌoo dꞌadɨ to né kɨ́ tò yoro. ");
INSERT INTO mge_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi-je lé, dḛ kɨ̀ ndəgɨ jipɨ-je lay ya ꞌto njétəl rɔ-dé go nékoɓe-tɨ lə ka-dé-je, adɨ dḛ ꞌtogɨ ji-dé dꞌadɨ aa njay-njay ɓá dꞌuso-né né. ");
INSERT INTO mge_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lokɨ dꞌḭ lokosɨ-tɨ rəmə, dꞌa togɨ rɔ-dé lay ɓəy ɓá dꞌa kuso né. Nékoɓe-je kɨ́ rangɨ n̰a̰ ya kɨ́ dḛ ꞌtəl rɔ-dé go-tɨ adɨ to togɨ kobɨ-je, kɨ̀ gùm-je, kɨ̀ jo sima̰-je. ");
INSERT INTO mge_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Beɓa Parisi-je kɨ̀ njéndó dow-je ndukun-je lé, ꞌdəjɨ Jeju ꞌpanè: Kdɔ ri ɓá njéndó né-je lə-i ꞌtəl rɔ-dé go nékoɓe-tɨ lə ka-ji-je al, adɨ dꞌuso né kɨ̀ ji-dé kɨ́ yoro wa? ");
INSERT INTO mge_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeju ilə-dé-tɨ panè: Sə̰i lé, ꞌtoi njékədkəm dow-je. Ta kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ pa sɔbɨ-né dɔ-si lé to ta kɨ́ tɔgrɔ-tɨ ya. Lubə adɨ Ejay ndàngɨ panè: «Gin dow-je kinlé ꞌtətɨ kagɨ-m ndaá ta-dé-tɨ nè, Ngà mḛḛ-dé tò gay sə-m.» ");
INSERT INTO mge_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pole kɨ́ dḛ ꞌpol-m kàrè to pole kɨ́ mḛḛ wəy kare; Kdɔ né-je kɨ́ dꞌisɨ ꞌndó dow-je lé, to ndukun-je kɨ́ dow-je dꞌun kɨ̀ dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jeju təl pa sə-dé panè: Sə̰i in̰əi ndukun-je lə Lubə kɔgɨ ə isi ꞌtəli rɔ-si go nékoɓe-tɨ lə dow-je. ");
INSERT INTO mge_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Təl pa ɓəy panè: Sə̰i uwəi rɔ-si nga̰ ya ꞌmbati ndukun-je lə Lubə rə́, kdɔ ngəm-né nékoɓe-je lə-si. ");
INSERT INTO mge_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kdɔ Moiyijɨ panè: ꞌTətɨ kagɨ bɔbɨ-i kɨ̀ kɔ̰-i. Ḛ pa ɓəy panè: Dow kɨ́ pa ta kɨ́ majɨ al dɔ bɔbɨ-é-tɨ əse dɔ kɔ̰-é-tɨ rəmə, kadɨ tokɨ tɔl dowbé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngà sə̰i rəmə ꞌpainè: Kinə dow pa kɨ̀ bɔbɨ-é əse kɔ̰-é panè: Né kɨ́ lé mꞌa ra-né sə-i lé, to «kɔrba̰», adɨ kɔr mḛḛ-é to kadkare kɨ́ kadɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Rəmə sə̰i ɔgi dowbé kdɔ kadɨ ra né madɨ kdɔ bɔbɨ-é əse kɔ̰-é ngá. ");
INSERT INTO mge_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ꞌRai bè kin rəmə, to kun ɓá sə̰i uni nékoɓe kɨ́ isi ꞌndói-na̰ lé ꞌbujuri-né ta lə Lubə kɔgɨ; ɓá sə̰i ꞌrai ko né-je kɨ́ rangɨ kɨ́ bè kin n̰a̰ ya ɓəy tɔ. ");
INSERT INTO mge_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jeju təl ɓa kosɨ dow-je kɨ rɔ-é-tɨ ə panè: Sə̰i lay ya ꞌyəli mbi-si ooi-né ta lə-m, ə kadɨ ꞌgəi mḛḛ-é majɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Né kɨ́ à kḭ ndaa-tɨ kɔw mḛḛ dow-tɨ kdɔ təl-é dow-tɨ kɨ́ tò n̰ḛ takəm Lubə-tɨ goto. Ngà né kɨ́ ḭ mḛḛ dow-tɨ tḛḛ ndaa-tɨ ɓá à ra kadɨ dowbé təl to dow kɨ́ tò n̰ḛ takəm Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dow kɨ́ mbi-é tò kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kin. ");
INSERT INTO mge_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lokɨ Jeju in̰ə kosɨ dow-je ɔw mḛḛ kəy-tɨ lé, njéndó né-je liə ꞌdəjɨ-é kadɨ ɔr mḛḛ gosta kinlé adɨ-dé. ");
INSERT INTO mge_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jeju idə-dé panè: Sə̰i lé ya kàrè négə nal-si bè tɔ wa? Ta lə né kɨ́ à kḭ ndaa-tɨ kɔw mḛḛ dow-tɨ kdɔ təl-é dow-tɨ kɨ́ tò n̰ḛ takəm Lubə-tɨ al kinlé, sə̰i kàrè ꞌgəi al tɔ wa? ");
INSERT INTO mge_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kdɔtalə né kɨ́ ḭ ndaa-tɨ lé, ɔw tagɨr-tɨ lə dow al, ngà ɔw mḛḛ-é-tɨ kdɔ tḛḛ kɔgɨ. Jeju pa bè kdɔ nékuso-je lay ya aa njay. ");
INSERT INTO mge_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jeju təl pa ɓəy panè: Né kɨ́ ḭ tagɨr-tɨ lə dow tḛḛ ndaa-tɨ ɓá à təl-é dow-tɨ kɨ́ tò n̰ḛ takəm Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Kdɔ tagɨr-je kɨ́ majɨ al, kɨ̀ ra kaya-je, kɨ̀ ɓogɨ-je, kɨ̀ tɔl dow-je, kɨ̀ kin̰ə ne-i əse ngɔbɨ-i kɔw sangɨ dow kɨ́ rangɨ-je, kɨ̀ kəmkəḭ-je, kɨ̀ mḛḛndul-je, kɨ̀ kədɨ-na̰-je, kɨ̀ néra kɨ go rəbɨ-é-tɨ al-je, kɨ̀ kim-na̰-je, kɨ̀ kulə ta ndil dow-tɨ-je, kɨ̀ kɔjrɔ-je, kɨ̀ néra kɨ́ dɔ mbə́-tɨ-je kinlé ḭ mḛḛ dow-tɨ kəy, lo tagɨr-je-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Né-je kɨ́ majɨ al lay kinlé tḛḛ mḛḛ dow-tɨ, ə ra adɨ dowbé təl né kɨ́ tò n̰ḛ takəm Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jeju ḭ lo-é-tɨ kinlé ɔw dɔnangɨ Tir-tɨ, ə ɔw mḛḛ kəy-tɨ káre bè. Ḛ ndigɨ kadɨ dow gə lo kɨ́ nꞌisɨ-tɨ al, ngà lo kadɨ ɓɔyɔ rɔ-é goto. ");
INSERT INTO mge_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kdɔ dené káre bè, kɨ́ ndil kɨ́ majɨ al ra ngon-é kɨ́ dené, oo poy Jeju rəmə, ree usɨ nja-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dené kinlé, to dené grɛkɨ kɨ́ dꞌojɨ-é Siri, dɔnangɨ Penisi-tɨ. Ḛ nɔ̰ ta Jeju-tɨ kdɔ kadɨ tubə ndil kɨ́ majɨ al dɔ ngon-nꞌḛ̀-tɨ kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngá ɓá Jeju idə-é panè: ꞌAdɨ ngan-je dꞌuso né ꞌndan mɔkɨ, kdɔ kun nékuso ta ngan-je-tɨ kilə kadɨ ngan bisɨ-je lé to né kɨ́ tuwə ra al. ");
INSERT INTO mge_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dené lé təl panè: Tɔgrɔ-tɨ ya ꞌƁaɓe, ngà ngan bisɨ-je kɨ́ dꞌa̰ gin tablə kuso né-tɨ lé, n̰ɔ̰-n̰ɔ̰ ta ngan-je kɨ́ tusɨ nangɨ lé dꞌa kuso kare. ");
INSERT INTO mge_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ngá ɓá Jeju idə-é ꞌpanè: Kdɔ ta kɨ́ ta-i-tɨ kin ya, ɔw, ndil kɨ́ majɨ al lé tḛḛ mḛḛ ngon-i-tɨ kɨ́ dené lé kɔgɨ ngá. ");
INSERT INTO mge_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lokɨ dené təl ɔw mḛḛ kəy-tɨ liə lé, ingə ngon-é lé dɔ tɨrə-tɨ. Ndil kɨ́ majɨ al lé tḛḛ mḛḛ-é-tɨ kɔgɨ ngá. ");
INSERT INTO mge_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jeju ḭ dɔnangɨ Tir-tɨ təl al dɔnangɨ Sidɔ̰-tɨ ə ində dan ɓebo-je kɨ́ dɔgɨ gangɨ ɓá ɔw tḛḛ ta babo-tɨ kɨ́ Galile. ");
INSERT INTO mge_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Rəmə dow-je ꞌree kɨ̀ dingəm káre kɨ́ to njèmbitɔ, adɨ pa ta mukɨ-mukɨ rɔ Jeju-tɨ ə ꞌra ndoo ta-é-tɨ kdɔ kadɨ ində ji-é dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeju ɔr-é dan kosɨ dow-je-tɨ ɔw siə kɨ̀ kár-é mbəngɨ, ḛ tulə ngan ji-é-je mbi njèmbitɔ-tɨ lé ə ra man ta-é ji-é-tɨ ɔdɨ-né ndɔ̰-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Go-tɨ, un kəm-é kɨ dɔra̰-tɨ, ilə koo pṵṵ ə panè: «Epata», kɔr mḛḛ-é to «ꞌtḛḛ.» ");
INSERT INTO mge_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Rəmə tajinatɨ nè ya mbi-é tḛḛ, ndɔ̰-é ɗɨrə́ bə̀rə̀rə̀, adɨ pa ta majɨ. ");
INSERT INTO mge_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeju ndəjɨ-dé kadɨ ꞌpa ta-é dꞌadɨ dow oo al. Ngà ḛ ndəjɨ-dé n̰a̰ rəmə, dḛ dꞌilə mbḛ-é kɨ kete-kete tɔ. ");
INSERT INTO mge_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Né kinlé ɔr ndil-dé n̰a̰ adɨ ꞌpanè: Kay! Né ra-é-je majɨ dɔrɔ, njémbitɔ-je kàrè ḛ adɨ-dé dꞌoo ta rəm, ɓá dḛ kɨ́ ndɔ̰-dé dɔɔ kàrè adɨ-dé ꞌpa ta rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ndɔ-é-tɨ kinlé, kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌtəl kəw-na̰ rɔ Jeju-tɨ rəmə, né kɨ́ kadɨ dꞌuso goto; beɓa Jeju ɓá njéndó né-je liə idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ta ɔ̰̀ mḛḛ-m kdɔ kosɨ dow-je kan! Kdɔ dḛ ꞌra ndɔ mutə sə-m ɓone ya, ngà né kɨ́ kadɨ dꞌuso goto. ");
INSERT INTO mge_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ə kinə mꞌin̰ə-dé mꞌadɨ dꞌɔw ɓee mḛḛ-dé ɓo bè lé, dꞌa gudɨ rəbəə kdɔ dḛ kɨ́ ná̰-je dꞌḭ əbɨ. ");
INSERT INTO mge_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Beɓa njéndó né-je liə dꞌilə-é-tɨ ꞌpanè: Ngà dow à kingə mbə̀ rá diləlo-tɨ nè kdɔ kadɨ dꞌuso ꞌndan wa? ");
INSERT INTO mge_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jeju dəjɨ-dé panè: Mbə̀ ra kandangɨ ji-si-tɨ wa? Dḛ ꞌpanè: Jꞌɔw kɨ̀ mbə̀ siri. ");
INSERT INTO mge_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Beɓa Jeju adɨ dow-je dꞌisɨ nangɨ rəmə ɔy mbə̀ kɨ́ siri lé, ra oiyo Lubə ə gángɨ dana̰, təl-né adɨ njéndó né-je liə kdɔ kadɨ ꞌləbɨ kosɨ dow-je ə dḛ ꞌləbɨ-dé ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Njéndó né-je lé dꞌɔw kɨ̀ ngan kanjɨ sḛ tɔ. Jeju ra oiyo Lubə dɔ ngan kanjɨ-tɨ lé ə ꞌtəl-né adɨ njéndó né-je ꞌləbɨ dow-je dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dow-je dꞌuso né ꞌndan ndə̰́-ndə̰́ ɓá dɔdum-é-je nà̰y adɨ dꞌɔy jangá siri. ");
INSERT INTO mge_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dḛ kɨ́ dꞌuso né lé dꞌa ra ɓudɔgɨ lo sɔ je bè. Go-tɨ, Jeju in̰ə-dé adɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ə tajinatɨ nè ya ḛ al mḛḛ tò-tɨ, natɨ kɨ̀ njéndó né-je liə ə dꞌɔw dɔnangɨ Dalmanuta-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi-je ꞌree rɔ Jeju-tɨ ꞌnajɨ siə ta. Dḛ ꞌndigɨ na̰-é kdɔ koo ta kɨ́ mḛḛ-é-tɨ adɨ ꞌdəjɨ-é kadɨ ra nékɔjɨ kɨ́ ḭ dɔra̰-tɨ kadɨ dꞌoo. ");
INSERT INTO mge_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeju ilə mḛḛ-é pṵṵ ə panè: Kdɔ ri ɓá dow-je kɨ́ ngɔsnè kin dəjɨ-né nékɔjɨ wa? Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow à ra nékɔjɨ kadɨ dow-je kɨ́ ngɔsnè kin al. ");
INSERT INTO mge_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Go-tɨ, Jeju in̰ə-dé, al mḛḛ tò-tɨ gangɨ ba ɔw turə. ");
INSERT INTO mge_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mḛḛ njéndó né-je oy dɔ mbə̀-tɨ adɨ dꞌun al; dḛ dꞌɔw kɨ̀ mbə̀ káre ya par mḛḛ tò-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jeju ndəjɨ-dé panè: «Sə̰i kan! Ooi go rɔ-si majɨ kdɔ əm lə Parisi-je kɨ̀ əm lə Erodɨ.» ");
INSERT INTO mge_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Njéndó né-je ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: Ta lə mbə̀ kɨ́ goto ji-ji-tɨ lé ɓá ḛ pa-né ta kin bè kdɔ. ");
INSERT INTO mge_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeju gə ta kɨ́ mḛḛ-dé-tɨ gɔw adɨ dəjɨ-dé panè: Kdɔ ri ə́ ꞌpai-na̰ ta dan-si-tɨ kdɔ mbə̀ kɨ́ goto ji-si-tɨ lé wa? Sə̰i ꞌgəi al ya ɓəy wa? Kəm-si ijə dɔ-tɨ al wa? ");
INSERT INTO mge_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Se to mḛḛnga̰ wa? Kəm-si tò ya, rəmə ooi-né lo al wa? Mbi-si tò ya, rəmə ooi-né ta al wa? Mḛḛ-si ole dɔ-tɨ al wa? ");
INSERT INTO mge_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lokɨ ndɔkɨ mꞌləbɨ mbə̀ mḭ dow-je ɓudɔgɨ lo mḭ lé se ɔyi dɔdum-é kɨ́ nà̰y kàrè kandangɨ wa? Dḛ ꞌpanè: Dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ə lokɨ ndɔkɨ mꞌləbɨ mbə̀ kɨ́ siri dow-je ɓudɔgɨ lo sɔ lé, ɔyi dɔdum-é kɨ́ nà̰y jangá kandangɨ wa? Dḛ ꞌpanè: «Jꞌɔy jangá Siri.» ");
INSERT INTO mge_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Beɓa Jeju təl idə-dé ꞌpanè: «Kin ya kàrè ꞌgəi gin-é al ya ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lokɨ ꞌree ꞌtḛḛ mḛḛ ɓe-tɨ kɨ́ Betsayda lé, dow-je ꞌree kɨ̀ njèkəmtɔ rɔ Jeju-tɨ, ꞌnɔ̰ ta-é-tɨ kdɔ kadɨ ɔdɨ rɔ-é. ");
INSERT INTO mge_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Beɓa Jeju uwə ji njèkəmtɔ lé, ɔr-é ɔw siə gidɨ ɓe-tɨ, ra man ta-é kəm-é-tɨ ə ində ji-é dɔ-é-tɨ ɓəy ɓá dəjɨ-é panè: Se oo né madɨ wa? ");
INSERT INTO mge_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Njèkəmtɔ lé tḛḛ kəm-é ə panè: Mꞌoo dow-je, ngà mꞌoo-dé ꞌtitɨ-na̰ kɨ̀ kagɨ-je bè ə dꞌɔw njiyə. ");
INSERT INTO mge_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jeju təl ində ji-é kəm-é-tɨ gogɨ; lokɨ njèkəmtɔ lé tḛḛ kəm-é rəmə, ḛ ingə lapiya ə oo né kɨ́ rá-rá ya kàrè gə. ");
INSERT INTO mge_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Beɓa Jeju in̰ə-é kadɨ ɔw ɓee rəmə, idə-é panè: «ꞌƆw mḛḛ ɓe-tɨ al ngá.» ");
INSERT INTO mge_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeju ɔw natɨ kɨ̀ njéndó né-je liə mḛḛ nganɓe-je-tɨ kɨ́ dɔnangɨ Sejare-tɨ lə Pilipɨ. Lokɨ dꞌisɨ dꞌɔw lé ḛ dəjɨ-dé panè: «Dow-je ꞌpanè mꞌto ná̰ wa?» ");
INSERT INTO mge_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Beɓa dḛ dꞌidə-é ꞌpanè: «Dow-je kɨ́ dan-tɨ-je ꞌpanè: “I ꞌto Ja̰ kɨ́ njèra dow-je batḛm”, ə dḛ kɨ́ ná̰-je ꞌpanè: “I ꞌto Eli”, ə dḛ kɨ́ rangɨ ꞌpanè: “I ꞌto kɨ́ káre dan njépata-je kɨ́ ta Lubə-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngà Jeju təl dəjɨ-dé panè: «Ə kɨ́ go gə-é-tɨ lə-si sə̰i ya bè lé, ma̰ mꞌto ná̰ wa?» Piyər idə-é panè: «I ꞌto Kristɨ.» ");
INSERT INTO mge_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Beɓa Jeju ndəjɨ-dé n̰a̰ kadɨ ꞌpa dꞌadɨ dow oo al. ");
INSERT INTO mge_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jeju ndó né njéndó né-je liə panè: «Tò kadɨ Ngon lə dow à kingə kɔ̰̀ n̰a̰, ꞌngatɔ́gɨ-je lə jipɨ-je kɨ̀ njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, dꞌa mbatɨ-é, dꞌa tɔl-é, ngà ndɔ kɨ́ njèkungɨ-tɨ mutə rəmə à tɔsɨ ndəl kində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ḛ idə-dé ta kin rəsɨ, beɓa Piyər ɔr-é ɔw siə kəl káre ɔw kɔl siə. ");
INSERT INTO mge_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ngà Jeju təl kəm-é oo njéndó né-je liə ə ndángɨ Piyər panè: «Sata̰, ꞌɔtɨ kɨ rangɨ ta-m-tɨ, kdɔ tagɨr-je lə-i to tagɨr-je lə dow-je, ɓɨ to tagɨr-je lə Lubə al.» ");
INSERT INTO mge_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Go-tɨ, Jeju ɓa kosɨ dow-je natɨ kɨ̀ njéndó né-je liə idə-dé panè: «Kinə dow ndigɨ kun go-m rəmə, kadɨ ta rɔ-é ɔ̰̀-é al, kadɨ un kagdəsɨ liə utɨ ə un go-m. ");
INSERT INTO mge_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kdɔ dow kɨ́ rá-rá kɨ́ ndigɨ kajɨ rɔ-é rəmə à tujɨ rɔ-é, ngà dow kɨ́ ilə rɔ-é kɔgɨ kdɔ ta lə-m əse kdɔ ta lə Poyta kɨ́ Majɨ lé à kajɨ rɔ-é. ");
INSERT INTO mge_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kadɨ dow ingə né-je kɨ́ dɔnangɨ-tɨ nè lay ə ndil-é tujɨ lé, majɨ-é to ri wa? ");
INSERT INTO mge_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ri ɓá dow à kadɨ kdɔ kɔr-né tó ndil-é wa? ");
INSERT INTO mge_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kdɔtalə dow kɨ́ ra rɔsɔl dɔ-m-tɨ, kɨ̀ dɔ ta-je-tɨ lə-m nɔ̰̀ dow-je-tɨ kɨ́ kaglo-tɨ kɨ́ ngɔsnè kɨ́ ꞌto njérakaya-je, kɨ̀ njéramajal-je kinlé, Ngon lə dow kàrè à ra rɔsɔl dɔ dowbé-tɨ lokɨ ḛ à ree dan riɓa-tɨ lə Bɔbɨ-é natɨ kɨ̀ malayka-je kɨ́ dꞌaa njay lé tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jeju təl idə-dé ɓəy panè: Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow-je madɨ dan dḛ-tɨ kɨ́ dꞌa̰ nè kinlé, dꞌa koo kɔ̰ɓe lə Lubə kɨ́ à ree kɨ̀ tɔ́gɨ kinlé kɨ̀ kəm-dé ɓəy ɓá dꞌa koy. ");
INSERT INTO mge_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ndɔ mɛkḛ go-tɨ, Jeju adɨ Piyər, kɨ̀ Jakɨ, kɨ̀ Ja̰ dꞌɔw siə dꞌɔw dꞌisɨ kɨ̀ kár-dé dɔ mbal-tɨ kɨ́ ngal rəmə rɔ-é mbəl tò gay takəm-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kubɨ-je liə ndɔ̰y ngilingɨ-ngilingɨ, nda mbəy-mbəy ə to nda kɨ́ dow kɨ́ dɔnangɨ-tɨ nè kɨ́ à kasɨ ra né kadɨ nda bin ya goto. ");
INSERT INTO mge_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Rəmə Eli dḛ kɨ̀ Moiyijɨ ꞌtḛḛ sə-dé kɔy ə dꞌa̰ dꞌɔjɨ ta kɨ̀ Jeju. ");
INSERT INTO mge_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Beɓa Piyər idə Jeju panè: Njèndó dow-je né, majɨ n̰a̰ kadɨ jꞌisi nè ya ngá. Adɨ jꞌrai kəykubɨ mutə; káre à to ꞌlə-i, káre to ꞌlə Moiyijɨ ə káre to ꞌlə Eli tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyər gə ta kɨ́ à pa al, kdɔtalə ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kilndi ree səbɨ dɔ-dé-tɨ rɨpɨ rəmə ndi dow ɓa dan kilndi-tɨ lé panè: Ḛ kinlé, to ngon-m; mꞌində-é dan kəm-m-tɨ; ooi ta liə. ");
INSERT INTO mge_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tajinatɨ nè ya njéndó né-je ꞌgɔ̰ lo ꞌgəə dɔ-dé rəmə dꞌoo dow kɨ́ rangɨ al, ngà Jeju ya kɨ̀ kár-é ɓá a̰ sə-dé. ");
INSERT INTO mge_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lokɨ dꞌḭ dɔ mbal-tɨ dꞌisɨ risɨ nangɨ lé, Jeju ndəjɨ-dé panè: «Né kɨ́ ooi kinlé, ꞌpai ta-é adi dow oo al ya sar kadɨ Ngon lə dow tɔsɨ-né ndəl ində lo tḛḛ dan dow-je-tɨ kɨ́ dꞌoy.» ");
INSERT INTO mge_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dḛ təl rɔ-dé go ta-tɨ kinlé ya, ngà dḛ ꞌdəjɨ-na̰ ta ꞌpanè se tɔsɨ ndəl kində lo tḛḛ dan dow-je-tɨ kɨ́ dꞌoy kinlé kɔr mḛḛ-é to ri ə́n wa? ");
INSERT INTO mge_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Beɓa dḛ dəjɨ Jeju ꞌpanè: «Kdɔ ri ɓá njéndó dow-je ndukun-je ꞌpanè: “Tò kadɨ Eli ree mɔkɨ tá” wa?» ");
INSERT INTO mge_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ḛ idə-dé panè: «Eli lé, à təl ree kete ə à kɔsɨ nja né-je natɨ kɨ̀ gangɨ-é gangɨ-é lay. Ngà kdɔ ri ɓá ꞌndàngɨ ꞌpanè: “Ngon lə dow à kingə kɔ̰̀ n̰a̰ rəm, dow-je dꞌa nədɨ-é rəm lé wa”? ");
INSERT INTO mge_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ngà mꞌa kidə-si rəsɨ kɨ́ Eli lé ree ngá ə dow-je ꞌra siə né-je kɨ́ mḛḛ-dé ndigɨ titɨ kɨ́ ꞌndàngɨ-né ta kɨ́ sɔbɨ dɔ-é lé ya.» ");
INSERT INTO mge_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lokɨ ꞌtəl ꞌree ngɔsi kɨ̀ ndəgɨ njéndó né-je lé, dꞌoo kɨ́ kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌilə-na̰ ꞌgəə dɔ-dé ɓá njéndó dow-je ndukun-je dꞌisɨ ꞌnajɨ sə-dé ta. ");
INSERT INTO mge_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Beɓa lokɨ dow-je dꞌun kəm-dé dꞌoo Jeju rəmə, kàdɨ̀-dé uwə-dé pa̰y ə dꞌa̰y ngɔdɨ kɨ rɔ-é-tɨ kdɔ ra-é lapiya. ");
INSERT INTO mge_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jeju dəjɨ njéndó né-je liə panè: Isi naji sə-dé ta dɔ ri-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dow káre dan kosɨ dow-je-tɨ idə-é panè: Njèndó dow-je né, mꞌree kɨ̀ ngon-m rɔ-i-tɨ, kdɔtalə ndil kɨ́ majɨ al ra-é adɨ pa ta al. ");
INSERT INTO mge_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lo lay ya kɨ́ ndil kɨ́ majɨ al kin uwə-é-tɨ lé, itə-é ilə-é nangɨ rəm, əm ta-é ḭ pukɨ-pukɨ rəm, uso ngangɨ-é məgəgə-məgəgə rəm, ɓá ndajɨ-é ndə̰́y-ndə̰́y rəm tɔ. Mꞌdəjɨ njéndó né-je lə-i kadɨ ꞌtubə ndil kɨ́ majɨ al kinlé dɔ-é-tɨ kɔgɨ ya, ngà dḛ dꞌasɨ al. ");
INSERT INTO mge_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Beɓa Jeju idə-dé panè: Sə̰i ko dow-je kɨ́ njémḛḛnga̰-je kan! Mꞌa kisɨ sə-si natɨ asɨ kaglo ban ɓəy wa? Mꞌa kisɨ dɔ-tɨ sə-si asɨ kaglo ban ɓəy wa? ꞌReei kɨ̀ ngon lé rɔ-m-tɨ nè bè. Ə dꞌun ngon lé ꞌree siə rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lokɨ ngon lé oo Jeju taá ya rəmə, ndil kɨ́ majɨ al lé ɔsɨ-é kɨ̀ tɔ́gɨ-é adɨ-é usɨ nangɨ ə ndur kutɨ-kutɨ adɨ əm ta-é ḭ pukɨ-pukɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jeju dəjɨ bɔbɨ ngon lé panè, né kinlé ra-é bè asɨ dɔkaglo ban ngá wa? Ḛ ilə-é-tɨ panè: Ra-é ngon-é-tɨ nṵ ya ə ");
INSERT INTO mge_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","taá-taá ya ndil lé ɔsɨ-é ilə-é pərəə-je, ilə-é mani-je kdɔ kadɨ-é oy. Ngà kinə ꞌa kasɨ ra né madɨ rəmə, ꞌoo kəmtondoo lə-ji ə ꞌra sə-ji. ");
INSERT INTO mge_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeju ilə-é-tɨ panè: I ꞌdəjɨ-m ꞌpanè se mꞌa kasɨ wa? Dow kɨ́ adɨ mḛḛ-é lé, né kɨ́ à dum-é ya goto. ");
INSERT INTO mge_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lo-é-tɨ kin ya bɔbɨ ngon lé ilə bɔbɨ ndi-é nangɨ panè: Mꞌadɨ mḛḛ-m, ꞌra sə-m kdɔ kadmḛḛ lə-m asɨ al. ");
INSERT INTO mge_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lokɨ Jeju oo kɨ́ kosɨ dow-je dꞌa̰y miriri-miriri kɨ rɔ-dé-tɨ rəmə, ndángɨ ndil kɨ́ majɨ al lé panè: «I ndil kɨ́ njèkɔgɨ dow koo ta, njèkɔgɨ dow pa ta kinlé, mꞌun ndu madɨ-i kadɨ ꞌtḛḛ mḛḛ ngon-tɨ kin kɔgɨ ə ꞌtəl ꞌree mḛḛ-é-tɨ gogɨ al ya riw ngá.» ");
INSERT INTO mge_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ə ndil kɨ́ majɨ al ur kəə ə ɔsɨ ngon lé kɨ̀ tɔ́gɨ-é n̰a̰ ɓá tḛḛ-né kɔgɨ mḛḛ-é-tɨ. Ngon lé tò titɨ dow kɨ́ oy bè, adɨ dow-je kɨ́ dꞌa̰ lo-é-tɨ lé ꞌpanè ḛ oy. ");
INSERT INTO mge_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngà Jeju uwə ji-é, un-é-né kɨ taá ə ḛ ḭ a̰ taá. ");
INSERT INTO mge_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lokɨ Jeju ɔw kəy rəmə, njéndó né-je liə dꞌisɨ siə kɨ̀ kár-dé ngá ɓá ꞌdəjɨ-é ꞌpanè: Kdɔ ri ɓá jḛ ya kɨ̀ dɔ-ji jꞌasɨ tubə ndil kɨ́ majɨ al kinlé kɔgɨ al wa? ");
INSERT INTO mge_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Beɓa ḛ idə-dé panè: Ko ndil-je kɨ̀ bè kinlé, ta kɨ̀ pa kɨ̀ Lubə ya par ɓá dow à tubə-dé-né. ");
INSERT INTO mge_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dꞌḭ lo-é-tɨ kinlé dꞌɔw ə dꞌində dɔnangɨ Galile ꞌgangɨ rəmə, Jeju ndigɨ kadɨ dow gə al. ");
INSERT INTO mge_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kdɔ ḛ ndó né njéndó né-je liə taá-taá ə idə-dé panè: «Dꞌa kilə Ngon lə dow ji dow-je-tɨ kdɔ kadɨ ꞌtɔl-é, ngà ndɔ mutə go ndɔ koy-é-tɨ lé, ḛ à tɔsɨ ndəl kində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngà njéndó né-je ꞌgə mḛḛ ta kinlé al rəm, ɓá dḛ ꞌɓəl lo dəjɨ-é ta dɔ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Dḛ ꞌree ꞌtḛḛ Kapɛrnayim. Ə lokɨ dꞌisɨ kəy ngá ɓá Jeju dəjɨ njéndó né-je liə panè: Ri ɓá ꞌnaji-na̰ ta dɔ-tɨ rəbəə lé wa? ");
INSERT INTO mge_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngà dḛ dꞌilə-é-tɨ al, kdɔtalə dɔ rəbɨ-tɨ lé, dꞌɔw ꞌnajɨ-na̰ ta ꞌpanè se ná̰ ɓá to kɨ́ boy n̰a̰ dan-dé-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Beɓa Jeju uwə lo isɨ-tɨ nangɨ ə ɓa njéndó né-je kɨ́ dɔgɨ gidɨ-é joo lé kɨ rɔ-é-tɨ ɓá idə-dé panè: Dow kɨ́ ndigɨ to kɨ́ dɔsa̰y lé, kadɨ təl rɔ-é kɨ sɔ̰y dow-je lay rəm, ɓá kadɨ-é təl rɔ-é ngonnjèkullə-tɨ lə dow-je lay rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Go-tɨ, Jeju un ngon kɨ́ ndḛ bè adɨ-é a̰ dan-dé-tɨ dana̰ ə go-tɨ təl uwə-é kàdɨ̀-é-tɨ ɓá idə-dé-né ta panè: ");
INSERT INTO mge_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Dow kɨ́ rá-rá kɨ́ uwə ngon kɨ́ titɨ ḛ kin bè kɨ rɔ-é-tɨ kdɔ ta lə-m kin rəmə, to ma̰ ya dowbé uwə-m kɨ rɔ-é-tɨ tɔ tin. Ə dow kɨ́ uwə-m kɨ rɔ-é-tɨ lé, to ma̰ bè ɓá dowbé uwə-m kɨ rɔ-é-tɨ al, ngà to njèkulə-m ɓá dowbé uwə-é kɨ rɔ-é-tɨ tin. ");
INSERT INTO mge_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ja̰ idə Jeju panè: «Njèndó dow-je né, jḛ jꞌoo dow káre un ri-i ɓá isɨ tubə-né ndil-je kɨ́ majɨ al dɔ dow-je-tɨ ə́ jꞌsangɨ kadɨ jꞌɔgɨ-é dɔ-tɨ kdɔ ḛ un go-ji al.» ");
INSERT INTO mge_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jeju panè: «Ɔgi-é dɔ-tɨ al, kdɔ dow kɨ́ ra nékɔjɨ kɨ̀ ri-m lé, à təl tajinatɨ nè pa ta kɨ̀ majɨ al dɔ-m-tɨ go-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kdɔ dow kɨ́ ɔsɨ-ji kɨ̀ ta al lé, to dow lə-ji. ");
INSERT INTO mge_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Dow kɨ́ adɨ-si man ka̰y mḛḛ kaman káre kdɔ to kɨ́ sə̰i ꞌtoi dow-je lə-m ma̰ Kristɨ lé, ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dowbé kin à nal nékugə dɔji-é al. ");
INSERT INTO mge_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ngà kinə dow ra dow káre dan ngan dow-je-tɨ kɨ́ dꞌadɨ-m mḛḛ-dé kin adɨ-é ra majal lé, lé ꞌdɔɔ mbal kusɨ ko kɨ́ boy mindɨ-é-tɨ ɓá dꞌilə-é-né dan babo-tɨ ya kàrè ꞌliə tò sotɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kinə ji-i ra-i adɨ ꞌra majal rəmə, ꞌgangɨ-é ilə-é kɔgɨ; kadɨ ꞌɔw lo kiskəm-tɨ kɨ̀ ji-i káre lé tò sotɨ itə kadɨ ꞌngəm ji-i joo lay ə ꞌɔw-né dan pər-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lo-é-tɨ kinlé kode-je kɨ́ rɔ dow-tɨ dꞌa koy al rəm, ɓá pər kɨ́ titɨ kàrè à koy al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kinə nja-i ra-i adɨ ꞌra majal rəmə, ꞌgangɨ-é ilə-é kɔgɨ; kadɨ ꞌɔw lo kiskəm-tɨ kɨ̀ nja-i káre lé, tò sotɨ itə kadɨ ꞌngəm nja-i joo lay ə ꞌɔw-né dan pər-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lo-tɨ kɨ́ kode-je kɨ́ rɔ dow-je-tɨ dꞌa koy al rəm, ɓá pər kɨ́ titɨ kàrè à koy al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kinə kəm-i ɔw sə-i adɨ ꞌra majal rəmə, ꞌɔr-é ꞌilə-é kɔgɨ. Kadɨ ꞌɔw kɔ̰ɓe-tɨ lə Lubə kɨ̀ kəm-i káre-rè lé tò sotɨ itə ngəm kəm-i joo lay ə dꞌilə-i-né dan pər-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lo-tɨ kɨ́ kode-je kɨ́ rɔ dow-je-tɨ dꞌa koy al rəm, ɓá pər kàrè à koy-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kdɔ dow kɨ́ ində dan pər gangɨ lé aa njay-njay ə titɨ-na̰ kɨ̀ katɨ bè. ");
INSERT INTO mge_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Katɨ to né kɨ́ majɨ ya, ngà kinə mbinə̰-é ɔr kɔgɨ lé dow à ra-né ban ɓá à təl dɔ̰ gogɨ ɓəy wa? Adi rɔ-si taa katɨ ə isi-na̰ kɨ̀ lapiya. ");
INSERT INTO mge_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeju ḭ lo-é-tɨ kin ɔw dɔnangɨ Jude-tɨ gidɨ ba jurdḛ-tɨ. Kosɨ dow-je ꞌtəl ꞌkəwna̰ rɔ-é-tɨ, ə titɨ kɨ́ ḛ ra-né low-low lé, ḛ ndó-dé né ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Rəmə Parisi-je ꞌree rɔ-é-tɨ kdɔ na̰-é koo ta kɨ́ mḛḛ-é-tɨ adɨ ꞌdəjɨ-é ꞌpanè se to tó-é kadɨ dow tubə ne-é wa? ");
INSERT INTO mge_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeju ilə-dé-tɨ panè: Moiyijɨ un ndu dɔ-tɨ adɨ-si panè ri wa? ");
INSERT INTO mge_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dḛ təl dꞌidə-é ꞌpanè: Moiyijɨ lé un ndu panè: Kinə dow tubə ne-é rəmə kadɨ ꞌadɨ-é mbete tubə ɓane. ");
INSERT INTO mge_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Beɓa Jeju təl panè: To ta lə mḛḛnga̰ lə-si ɓá Moiyijɨ ndàngɨ-né ndukun kinlé adɨ-si. ");
INSERT INTO mge_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngà lo kulə gin dɔnangɨ-tɨ lé, Lubə ra dené kɨ̀ dingəm. ");
INSERT INTO mge_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gin-é kin ɓá dingəm à kin̰ə-né kɔ̰-é kɨ̀ bɔbɨ-é kdɔ tin̰ə natɨ kɨ̀ ne-é. ");
INSERT INTO mge_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ə dḛ joo lay ya ꞌtəl kubru rɔ kɨ́ káre-rè. Adɨ dḛ ꞌto dow-je joo al ngá; ngà ꞌto kubru rɔ kɨ́ káre-rè. ");
INSERT INTO mge_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Né kɨ́ Lubə tɔ́ natɨ lé, kadɨ dow tutɨ al. ");
INSERT INTO mge_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lokɨ dꞌisɨ mḛḛ kəy-tɨ lé, njéndó né-je ꞌtəl ꞌdəjɨ-é ta dɔ-tɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Beɓa idə-dé panè: Dow kɨ́ tubə ne-é ɓá taa dené kɨ́ rangɨ lé, ḛ ra kaya nɔ̰̀ ne-é-tɨ kɨ́ kete. ");
INSERT INTO mge_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Rəm ɓá dené kɨ́ in̰ə ngɔbɨ-é ə taa dingəm kɨ́ rangɨ kàrè ra kaya ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dow-je ꞌree kɨ̀ ngan-je rɔ Jeju-tɨ kdɔ kadɨ ində ji-é dɔ-dé-tɨ. Ngà njéndó né-je ꞌkɔl sə-dé. ");
INSERT INTO mge_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lokɨ Jeju oo né kɨ́ ꞌra kinlé rəmə, mḛḛ-é ɔ̰̀-é adɨ idə-dé panè: «In̰əi ngan-je adɨ ꞌree rɔ-m-tɨ, ɓɨ ɔgi-dé al, kdɔtalə kɔ̰ɓe lə Lubə tò kdɔ dow-je kɨ́ ꞌtitɨ-na̰ sə-dé bè. ");
INSERT INTO mge_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ooi majɨ, mꞌa kidə-si rəsɨ. Dow kɨ́ ndigɨ kɔ̰ɓe lə Lubə titɨ-na̰ kɨ̀ ngon kɨ́ sḛ ndigɨ-né kin al lé à kɔw-tɨ nda̰ bè al.» ");
INSERT INTO mge_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Go-tɨ, Jeju uwə ngan-je lé kɨ rɔ-é-tɨ, ə ində ji-é dɔ-dé-tɨ ɓá tɔr-né ndi-é dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lokɨ Jeju un rəbɨ isɨ ɔw rəmə, dingəm káre a̰y ngɔdɨ go-é-tɨ, tɔsɨ məkəjɨ-é nangɨ nɔ̰̀-é-tɨ ə dəjɨ-é panè: «Dow kɨ́ majɨ kɨ́ njèndó dow-je né, ri ɓá mꞌa ra ɓá mꞌa kisɨ-né kəm sartagangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jeju idə-é ꞌpanè: «Kdɔ ri ɓá i ꞌɓa-m dow kɨ́ majɨ wa? Dow kɨ́ majɨ goto, Lubə ya kɨ̀ kár-é ə́ majɨ. ");
INSERT INTO mge_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ꞌGə ndukun-je lə Lubə gɔw: “ꞌA tɔl dow al, ꞌa ra kaya al, ꞌa ɓogɨ al, ꞌa tətɨ ta kɨ́ ndángɨ al, ꞌa ra né kɨ́ majɨ al kɨ̀ dow al, ꞌa tətɨ kagɨ bɔbɨ-i kɨ̀ kɔ̰-i.”» ");
INSERT INTO mge_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dingəm lé ilə-é-tɨ panè: «Njéndó dow-je né, basa-m-tɨ nṵ ya mꞌtəl rɔ-m go né-je-tɨ kin lay.» ");
INSERT INTO mge_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeju oo-é gə́rə́rə́, ndigɨ-é ə idə-é panè: «Né káre nal-i ɓəy. ꞌƆw ꞌndogɨ nékingə-i lay ə ꞌləbɨ là-é njéndoo-je rəmə ndɔ-é ꞌa kingə n̰a̰ dɔra̰-tɨ ə ꞌree un go-m.» ");
INSERT INTO mge_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngà rəmə dingəm lé rɔ-é nəl-é dɔ ta-tɨ kinlé al, adɨ ɔtɨ ɔw kɨ̀ rɔkatɨ kana̰na̰, kdɔ to dow kɨ́ nékingə-é n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Beɓa Jeju oo lo gəə dɔ-é, ɓá idə njéndó né-je liə panè: «Kadɨ njénékingə-je dꞌɔw kɔ̰ɓe-tɨ lə Lubə lé, to né kɨ́ nga̰ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta kɨ́ Jeju pa lé ɔr ndil njéndó né-je. Beɓa Jeju təl idə-dé panè: «Ngan-m-je, kɔw kɔ̰ɓe-tɨ lə Lubə lé nga̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kadɨ jambal dəə ɓe libri-tɨ lé to né kɨ́ nga̰ n̰a̰ ya, ngà kadɨ njènékingə ɔw kɔ̰ɓe-tɨ lə Lubə lé to né kɨ́ nga̰ itə-é ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta kinlé ɔr ndil njéndó né-je ta madɨ-é-tɨ ya ɓəy, adɨ ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: «Tò bè ngà ná̰ ɓá à kajɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeju oo-dé gə́rə́rə́ ə ꞌpanè: «Né kinlé dow-je ɓá dum-dé ɓɨ dum Lubə al, kdɔ Lubə lé né kɨ́ dum-é goto.» ");
INSERT INTO mge_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Rəmə Piyər idə-é panè: «Yən, jḛ kinlé, jꞌtusɨ né-je lə-ji jꞌin̰ə ɓá jꞌun go-i tin.» ");
INSERT INTO mge_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Beɓa Jeju ilə-tɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ. Dow kɨ́ in̰ə kəy liə, kɨ̀ ngankɔ̰-é-je, kɨ̀ kɔ̰nan-é-je, kɨ̀ kɔ̰-é, kɨ̀ bɔbɨ-é, kɨ̀ ngan-é-je əse ndɔr-je liə kdɔ ta lə-m rəm, kdɔ Poyta kɨ́ Majɨ rəm lé, ");
INSERT INTO mge_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kisɨ-é kɨ̀ dɔ-é taá nè kin ya à kingə kɨ́ rangɨ dɔ-tɨ nja ɓu, adɨ to kingə kəy-je, kɨ̀ ngankɔ̰-é-je, kɨ̀ kɔ̰nan-é-je, kɨ̀ kɔ̰-é-je, kɨ̀ ngan-é-je, kɨ̀ ndɔr-je rəm, ɓá dꞌa kulə kəm-é ndoo-je rəm, ɓá à kingə kiskəm kɨ́ sartagangɨ kaglo-tɨ kɨ́ à ree ɓəy rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dow-je n̰a̰ dan dḛ kɨ́ kete-tɨ dꞌa təl to dow-je kɨ́ gogɨ ə dow-je n̰a̰ dan dḛ kɨ́ gogɨ-tɨ dꞌa təl to dow-je kɨ́ kete tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Lokɨ Jeju kɨ̀ njéndó né-je liə dꞌun rəbɨ dꞌisɨ dꞌɔw kɨ Jorijalḛm lé, Jeju usɨ nɔ̰̀-dé-tɨ. Mḛḛ njéndó né-je gangɨ man rəm, dow-je kɨ́ dꞌun go-dé kàrè ꞌɓəl rəm tɔ. Beɓa Jeju ɓa njéndó né-je kɨ́ dɔgɨ gidɨ-é joo kɨ rɔ-é-tɨ, pa sə-dé ta kɨ́ dɔ né-tɨ kɨ́ à tḛḛ dɔ-é-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yən, kɔw kɨ́ jꞌisi jꞌɔwi kɨ Jorijalḛm kinlé, dꞌa kilə Ngon lə dow ji njékun dɔ njégugné-je-tɨ lə Lubə, kɨ̀ ji njéndó dow-je ndukun-je-tɨ. Dꞌa gangta koy dɔ-é-tɨ rəm, dꞌa kilə-é ji gin dow-je-tɨ kɨ́ ꞌto jipɨ-je al. ");
INSERT INTO mge_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Dꞌa sɔkɨ-é rəm, dꞌa tubə yoro kəm-é-tɨ rəm, dꞌa tində-é kɨ̀ ndəy marɔw ə dꞌa tɔl-é, ngà ndɔ kɨ́ njèkungɨ-tɨ mutə rəmə, à tɔsɨ ndəl kində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jakɨ kɨ̀ Ja̰ kɨ́ ꞌto ngan lə Jebede lé, ꞌree rɔ Jeju-tɨ ꞌpanè: Njèndó dow-je né, jꞌndigɨ kadɨ ꞌra né kɨ́ jꞌɔw kɨ̀ dəjɨ-i kin adɨ-ji. ");
INSERT INTO mge_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ə Jeju dəjɨ-dé panè: Ri ɓá sə̰i ndigi kadɨ mꞌra mꞌadɨ-si wa? ");
INSERT INTO mge_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Beɓa dḛ dꞌilə-é-tɨ ꞌpanè: Jḛ lé jꞌge kadɨ ndɔ kɨ́ ꞌa kisɨ dan riɓa-tɨ lə-i rəmə, ꞌadɨ dow káre isɨ dɔ jikɔl-i-tɨ ə kɨ́ káre isɨ dɔ jigəl-i-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ḛ ilə-dé-tɨ panè: Sə̰i lé, ꞌgəi né kɨ́ ꞌdəji lé al. A kasi kingəi kɔ̰̀ kɨ́ mꞌa kingə lé kare wa? Əse asi kadɨ ꞌra-si «batḛm» kɔ̰̀ kɨ́ mꞌa ra lé kare wa? Beɓa dꞌilə-é-tɨ ꞌpanè: Oiyo, jꞌa kasɨ kare. ");
INSERT INTO mge_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ə Jeju təl ilə-dé-tɨ panè: Tɔgrɔ-tɨ, kɔ̰̀ kɨ́ mꞌa kingə lé a kingəi rəm, batḛm kɔ̰̀ kɨ́ dꞌa ra-m lé kàrè dꞌa ra-si tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngà ta lə kisɨ dɔ jikɔl-m-tɨ əse dɔ jigəl-m-tɨ lé, to ma̰ ɓá mꞌa kadɨ al. Ngà tò kdɔtalə dow-je kɨ́ Lubə ya ra go-é kete kdɔ-dé. ");
INSERT INTO mge_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lokɨ ndəgɨ-é-je kɨ́ dɔgɨ dꞌoo ta kin bè lé, wɔngɨ ra-dé n̰a̰ dɔ Jakɨ-je-tɨ kɨ̀ Ja̰ lé. ");
INSERT INTO mge_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Beɓa Jeju ɓa-dé ə idə-dé panè: «Sə̰i ꞌgəi kɨ́ dḛ kɨ́ dow-je dꞌoo-dé kɨ njèkɔ̰ɓe dɔ gin dow-je-tɨ kɨ́ gay-gay kɨ́ dɔnangɨ-tɨ nè lé, dꞌulə kəm dow-je ndoo n̰a̰ rəm, ɓá dow-je kɨ́ boy-boy kàrè dꞌɔ̰̀ ɓe dɔ dow-je-tɨ lé kɨ́ go lo njètɔgɨ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngà sə̰i lé, kɔ̰̀-na̰ kɨ́ bè kin à goto dan-si-tɨ. Ngà dow kɨ́ ndigɨ kadɨ nꞌto kɨ́ boy dan-si-tɨ lé, kadɨ təl rɔ-é ngonnjèkullə-tɨ lə-si ɓane; ");
INSERT INTO mge_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ə dow kɨ́ ndigɨ kadɨ nꞌto kɨ́ dɔsa̰y dan-si-tɨ lé, kadɨ təl rɔ-é ɓə-tɨ lə-si lay tɔ. ");
INSERT INTO mge_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kdɔtalə Ngon lə dow lé ree kdɔ kadɨ dow-je ꞌra kullə dꞌadɨ-é al, ngà ḛ ɓá ree kdɔ ra kullə kadɨ dow-je rəm, ɓá kdɔ kadɨ rɔ-é gangɨ-né dɔ kosɨ dow-je rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeju kɨ̀ njéndó né-je ree ꞌtḛḛ ɓebo Jeriko-tɨ. Lokɨ dꞌisɨ ꞌtḛḛ kɨ gidɨ ɓe-tɨ natɨ kɨ̀ njéndó né-je liə, kɨ̀ kosɨ dow-je kɨ́ ꞌtò nduy-nduy rəmə, njèkəmtɔ kɨ́ ꞌɓa-é Bartime kɨ́ to ngon lə Time, isɨ ngangɨ rəbɨ-tɨ isɨ kɔy né. ");
INSERT INTO mge_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lokɨ ḛ oo kɨ́ to Jeju kɨ́ Najarɛtɨ lé, ḛ ilə bɔbɨ ndi-é nangɨ nɔ̰ panè: «Jeju, ngonka Dabidɨ, ꞌoo kəmtondoo lə-m.» ");
INSERT INTO mge_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Rəmə dow-je n̰a̰ ꞌndángɨ-é kadɨ utɨ ta-é. Ngà ḛ ilə bɔbɨ ndi-é nangɨ nɔ̰ itə kɨ́ kete lé ɓəy panè: «Ngonka Dabidɨ, ꞌoo kəmtondoo lə-m ɓoo.» ");
INSERT INTO mge_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Beɓa Jeju təl a̰ nangɨ ə panè: ꞌƁai-é kɨ nè. Ə dḛ ꞌɓa njèkəmtɔ lé dꞌidə-é ꞌpanè: «ꞌUwə rɔ-i nga̰, ḭ taá, ḛ ɓa-i.» ");
INSERT INTO mge_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rəmə njèkəmtɔ lé ilə kubɨ kul liə kɔgɨ, ubə nangɨ ratɨ, ḭ bal ɔw rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ə ḛ dəjɨ-é panè: Ri ɓá i ꞌndigɨ kadɨ mꞌra mꞌadɨ-i wa? Njèkəmtɔ lé ilə-é-tɨ panè: «Njèndó dow-je né, kəm-m ya ꞌadɨ təl oo lo.» ");
INSERT INTO mge_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Beɓa Jeju idə-é panè: «ꞌƆtɨ ꞌɔw, kadɨ mḛḛ lə-i adɨ-i lapiya.» Rəmə tajinatɨ nè ya kəm-é oo lo ə un rəbɨ go Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lokɨ dꞌisɨ dꞌɔw kɨ ɓebo Jorijalḛm-tɨ ɓá ꞌree ꞌtḛḛ ngɔsi kɨ̀ ɓe kɨ́ Betpaje, kɨ̀ Betani kàdɨ̀ mbal ka̰ kagɨ Olibiye-je-tɨ rəmə, Jeju ulə njéndó né-je liə joo panè: ");
INSERT INTO mge_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Ɔwi mḛḛ ngonɓe-tɨ kɨ́ tò nɔ̰̀-si-tɨ kin, rəmə tajinatɨ nè ya a kingəi ngon koro kɨ́ dow al-é al ɓəy kɨ́ ꞌtɔ́-é nangɨ ə ꞌtuti-é, ꞌreei siə. ");
INSERT INTO mge_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kinə dow dəjɨ-si panè: “ꞌTuti-é kdɔ ri wa” rəmə idəi-é ꞌpainè ꞌƁaɓe ɓá ge-é ə tajinatɨ nè ya à kin̰ə-é kadɨ-é ree gogɨ.» ");
INSERT INTO mge_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Beɓa njéndó né-je lé dꞌɔw rəmə dꞌingə ngon koro kɨ́ ꞌtɔ́-é ndaa-tɨ, takəy-tɨ, mbɔ́ rəbɨ-tɨ ə ꞌtutɨ-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dow-je kɨ́ ná̰-je kɨ́ dan dḛ kɨ́ dꞌa̰ lo-é-tɨ lé ꞌdəjɨ-dé ꞌpanè: «To ri ɓá ꞌrai bè wa? ꞌTuti ngon koro kinlé kdɔ ri wa?» ");
INSERT INTO mge_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ə dḛ dꞌilə-dé-tɨ titɨ kɨ́ Jeju idə-dé-né lé, rəmə dꞌin̰ə-dé dꞌadɨ dꞌɔw siə. ");
INSERT INTO mge_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Beɓa ꞌree kɨ̀ ngon koro lé dꞌadɨ Jeju ə ꞌlabɨ kubɨ-je lə-dé gidɨ-é-tɨ adɨ Jeju isɨ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dow-je n̰a̰ ꞌlabɨ kubɨ-je lə-dé dɔ rəbɨ-tɨ ə dḛ kɨ́ ná̰-je ꞌtə́tɨ balkəm kagɨ-je kɨ́ mḛḛ ndɔr-je-tɨ ɓá ꞌlabɨ dɔ rəbɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dow-je kɨ́ dꞌɔw kete nɔ̰̀-é-tɨ kɨ̀ dḛ kɨ́ dꞌɔw go-é-tɨ, ꞌtur kəə boy-boy ꞌpanè: «Kɔsgajɨ tò dɔ Lubə-tɨ! Kadɨ Lubə tɔr ndi-é dɔ dow-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadɨ Lubə tɔr ndi-é dɔ kɔ̰ɓe-tɨ kɨ́ isɨ ree, kadɨ-é tɔr ndi-é dɔ kɔ̰ɓe-tɨ lə ka-ji Dabidɨ! Kɔsgajɨ tò dɔ Lubə-tɨ kɨ́ taá nṵ.» ");
INSERT INTO mge_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jeju ɔw ɓebo Jorijalḛm-tɨ takəy-tɨ lə Lubə. Lokɨ oo né-je lay kɨ́ titɨ rəmə, ḛ tḛḛ ɔw Betani kɨ̀ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo kdɔ ndɔ isɨ il ngá. ");
INSERT INTO mge_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lo aa go-tɨ, lokɨ dꞌində lo ꞌtḛḛ mḛḛ ɓe-tɨ kɨ́ Betani lé ɓo ra Jeju. ");
INSERT INTO mge_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Beɓa ḛ un kəm-é oo lo kete nɔ̰̀-é-tɨ rəmə, oo kote kɨ́ mbi-é itɨ majɨ ə ɔw gin-tɨ kdɔ koo se nꞌa kingə kandɨ-é wa. Ngà lokɨ tḛḛ gin-é-tɨ rəmə, kandɨ-é goto kdɔtalə to na̰y kandɨ liə al ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Beɓa Jeju idə kote lé panè: «Nda̰ ɓá dow à kijə kandɨ-i kuso gogɨ al ngá. Njéndó né-je dꞌoo ta liə kɨ́ pa lé.» ");
INSERT INTO mge_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lokɨ Jeju kɨ̀ njéndó né-je liə ꞌree ꞌtḛḛ Jorijalḛm lé, ḛ ɔw takəy-tɨ lə Lubə rəmə, tubə njéragatɨ-je kɨ̀ njéndogɨ né-je kɔgɨ, titə tablə-je lə njémbəl-na̰ là-je kɨ̀ kagɨ kisɨ-je lə njéragatɨ də-je tilə. ");
INSERT INTO mge_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dow káre ya kàrè in̰ə-é adɨ un né dəə-né takəy-tɨ lə Lubə al. ");
INSERT INTO mge_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ə ḛ ndó-dé né ə ꞌpanè: ꞌNdàngɨ ꞌpanè: «Kəy lə-m lé dꞌa ɓa-é kəy pa ta kɨ̀ Lubə kɨ́ tò kdɔ gin dow-je lay; ngà sə̰i adi təl to kəy kisɨ njéɓogɨ-je.» ");
INSERT INTO mge_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Njékun dɔ njégugné-je lə Lubə kɨ̀ njéndó dow-je ndukun-je dꞌoo ta liə rəmə ꞌsangɨ kəm rəbɨ tɔl-é, ngà dḛ ꞌɓəl-é kdɔ kosɨ dow-je lay ya néndó liə uwə-dé kɨ̀ ta. ");
INSERT INTO mge_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lokɨ kàdɨ̀ ur lé, Jeju ində lo tḛḛ mḛḛ ɓebo-tɨ kɨ̀ njéndó né-je liə. ");
INSERT INTO mge_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɨ̀ ndɔge ta təl-dé-tɨ rəmə, njéndó né-je dꞌoo kɨ́ kote lé ḭ taá ya tutɨ sar tḛḛ njirə-é-tɨ nangɨ. ");
INSERT INTO mge_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Beɓa mḛḛ Piyər ole dɔ né-tɨ kɨ́ ra-né lé adɨ, idə Jeju panè: Njèndó dow-je né ꞌoo, kote kɨ́ ꞌman-é lé tutɨ kurum tin. ");
INSERT INTO mge_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jeju idə-dé panè: «Adi mḛḛ-si Lubə. ");
INSERT INTO mge_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ kinə dow madɨ idə mbal kin panè: “ꞌƆtɨ kɨ rangɨ lo kin-tɨ ə ꞌɔw ꞌusɨ dan babo-tɨ”, ɓá kinə dowbé lé tadɨ ta dɔ-tɨ al ə adɨ mḛḛ kɨ́ né-é à ra né lé, né-é à ra né ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gin-é kin ɓá adɨ mꞌidə-si: Né lay kɨ́ sə̰i ꞌdəji mḛḛ ta-tɨ kɨ́ pa kɨ̀ Lubə lé, kadɨ ꞌndai mḛḛ-si ka̰y kɨ́ ingəi né-é ngá, rəmə a kingəi né-é ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ə lokɨ sə̰i a̰i taá kdɔ pa ta kɨ̀ Lubə ɓá ooi tokɨ ɔwi kɨ̀ ta mḛḛ-si-tɨ kɨ̀ dow rəmə, in̰əi go kɔgɨ adi-é kdɔ kadɨ Bɔbɨ-si Lubə kɨ́ isɨ dɔra̰-tɨ in̰ə-né go majal-je lə-si kɔgɨ adɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ngà kinə in̰əi go majal-je lə madɨ-si-je kɔgɨ al lé, Bɔbɨ-si kɨ́ isɨ dɔra̰-tɨ à kin̰ə go majal-je lə-si kɔgɨ al ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lokɨ ꞌtəl ree Jorijalḛm gogɨ lé, Jeju ɔw njiyə takəy-tɨ lə Lubə rəmə, njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je dꞌɔw rɔ-é-tɨ ");
INSERT INTO mge_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ə ꞌdəjɨ-é ꞌpanè: «Ná̰ ɓá adɨ-i tarəbɨ ɓá ꞌra-né né-je kinlé wa? Ná̰ adɨ-i tɔ́gɨ ɓá ꞌra-né wa?» ");
INSERT INTO mge_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeju ilə-dé-tɨ panè: «Mꞌa dəjɨ-si ta káre bè ya par; iləi-mi-tɨ ə mꞌa kidə-si dow kɨ́ adɨ-m tɔ́gɨ mꞌra-né né-je kinlé tɔ. ");
INSERT INTO mge_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ja̰ lé to Lubə ɓá ulə-é adɨ ra dow-je batḛm əse to dow-je wa? Iləi-mi-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Beɓa dḛ ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: «Kinə jꞌpainè to Lubə ɓá ulə-é lé ḛ à təl panè kdɔ ri ɓá adi-é mḛḛ-si al wa? ");
INSERT INTO mge_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ə kinə jꞌpainè to dow-je ɓá dꞌulə-é ya bè lé, bayawəə … Dḛ ꞌpa bè kdɔ dḛ ꞌɓəl kosɨ dow-je, kdɔ dow-je lay ꞌgə kɨ́ Ja̰ lé to njèpata kɨ́ ta Lubə-tɨ kɨ́ tɔgrɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Beɓa dḛ dꞌidə Jeju ꞌpanè: «Jꞌgə al.» Rəmə Jeju idə-dé panè: «Ma̰ kàrè mꞌa kidə-si dow kɨ́ adɨ-m tɔ́gɨ ɓá mꞌra-né né-je kinlé al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jeju pa ta kɨ̀ gosta panè: Dow káre uwə nduu, ɔr gali dɔ-tɨ, ra ɓe dɔ ər-tɨ kdɔ mbore-né man nduu lé rəm, ur pal ngəm lo titɨ, ɓəy ɓá adɨ njérakullə-é-je dꞌuwə siə dɔ-é kadɨ ꞌra kullə dɔ-tɨ ə ɔtɨ ɔw mba. ");
INSERT INTO mge_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lokɨ na̰y kijə kandɨ nduu asɨ lé, ꞌɓa njèndɔr lé ulə ngonnjèkullə káre rɔ njérakullə-je-tɨ lé, kdɔ kadɨ dꞌadɨ-nꞌḛ̀ kandɨ nduu lə-nꞌḛ̀ kɨ́ sɔbɨ dɔ-nꞌḛ̀. ");
INSERT INTO mge_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rəmə dḛ dꞌuwə-é, ꞌtində-é mbukɨ-mbukɨ ə dꞌin̰ə-é dꞌadɨ təl kɨ̀ ji-é kare. ");
INSERT INTO mge_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ḛ təl adɨ ngonnjèkullə kɨ́ rangɨ ɔw ɓəy; dḛ dꞌuwə-é, ꞌtində dɔ-é mbukɨ-mbukɨ ɓá ꞌtajɨ-é dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ꞌƁa njéndɔr lé təl ulə ngonnjèkullə kɨ́ rangɨ ya ɓəy; ḛ kàrè ꞌtɔl-é rəm, ɓá dḛ kɨ́ rangɨ n̰a̰ kɨ́ ꞌɓa-dé ulə-dé go-tɨ kàrè ꞌtɔl dḛ kɨ́ ná̰-je ɓá ꞌtində dḛ kɨ́ dan-tɨ-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngon kal liə kɨ́ ində-é dan kəm-é-tɨ ya par ngá ə́ nà̰y; adɨ ḛ to sɔ̰y dow kɨ́ ulə-é kɨ rɔ-dé-tɨ ə panè: «To ngon-m adɨ dꞌa ɓəl gidɨ-é.» ");
INSERT INTO mge_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngà lokɨ njérakullə mḛḛ ndɔr nduu-tɨ kinlé dꞌoo-é rəmə, dꞌidə-na̰ ta ꞌpanè: «Ooi, ngon-é kɨ́ ndɔ-é à to njènéndubə lé ə́ ɔw ree ɔngɨ. ꞌReei adɨ jꞌtɔli-é kadɨ néndubə təl to kɨ́ lə-ji.» ");
INSERT INTO mge_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Beɓa dꞌuwə-é, ꞌtɔl-é, ꞌndɔr nin-é dꞌilə wale. ");
INSERT INTO mge_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ngá ɓá Jeju təl panè: Bè kinlé, ri ɓá ꞌɓa njèndɔr nduu lé à ra wa? À ree kdɔ tɔl njérakullə mḛḛ ndɔr nduu-tɨ kin kɔgɨ ə à kɔy dḛ kɨ́ rangɨ kində-dé tó-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","«Ər kɨ́ njékində kəy-je dꞌilə pɨrɨngɨ kɔgɨ lé ɓá təl to ər kɨ́ majɨ kɨ́ sul kəy-tɨ.» Ta kinlé, sə̰i ꞌndói mḛḛ mbete-tɨ kɨ́ aa njay ooi ya al wa? ");
INSERT INTO mge_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Né kinlé to kullə ra ꞌƁaɓe. Ngà kɨ rɔ-ji-tɨ rəmə, to nékɔjɨ. ");
INSERT INTO mge_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌsangɨ rəbɨ kdɔ kuwə Jeju, kdɔ ꞌgə kɨ́ ḛ pa gosta kinlé sɔbɨ-né dɔ-dé, ngà dḛ ꞌɓəl kosɨ dow-je. Beɓa dꞌin̰ə-é ə dꞌɔtɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Go-tɨ, ꞌtəl dꞌulə Parisi-je kɨ́ dan-tɨ-je, kɨ̀ dow-je lə Erodɨ kɨ́ ná̰-je rɔ Jeju-tɨ, kdɔ kadɨ dꞌingə ta madɨ ta-é-tɨ ə dꞌilə-né ta dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lokɨ ꞌree rɔ-é-tɨ lé ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, jꞌgə kɨ́ i lé ꞌto njèpata kɨ́ tɔgrɔ-tɨ rəm, i ꞌɓəl kəm dow al rəm; kdɔ i ꞌoo majɨ lə dow kɨ́ taga nè kin al; ngà i ꞌisɨ ꞌndó dow-je rəbɨ lə Lubə kɨ́ ɔw natɨ kɨ̀ ta tɔgrɔ-tɨ. Beɓa jꞌdəjɨ-i kadɨ ꞌidə-ji se to tó-é kadɨ dow ugə lambo lə ngar Sejar wa? Tò kadɨ jꞌugə əse tò kadɨ jꞌugə al wa? ");
INSERT INTO mge_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngà Jeju gə ta kədkəm dow-je kɨ́ mḛḛ-dé-tɨ lé adɨ idə-dé panè: «Kdɔ ri ɓá ꞌsangi kadɨ ooi ta kɨ́ mḛḛ-m-tɨ wa?» ꞌReei kɨ̀ ka̰ là káre adi-mi mꞌoo. ");
INSERT INTO mge_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Beɓa ꞌree kɨ̀ ka̰ là káre dꞌadɨ-é, ngá ɓá ḛ təl dəjɨ-dé panè: «To dɔ ná̰ kɨ̀ ri ná̰ ɓá tò-tɨ wa?» Rəmə dḛ dꞌilə-é-tɨ ꞌpanè: «To dɔ Sejar kɨ̀ ri-é.» ");
INSERT INTO mge_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ngá ɓá ḛ təl idə-dé panè: «Né lə Sejar ə adi Sejar, ngà né lə Lubə rəmə, adi Lubə tɔ.» Ta kɨ́ Jeju ilə-dé-tɨ kinlé, ɔr ndil-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi-je kɨ́ ꞌto njépanè tɔsɨ ndəl kində lo tḛḛ goto lé, ꞌree rɔ Jeju-tɨ ꞌdəjɨ-é ta ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Njéndó dow-je né, Moiyijɨ un ndu adɨ-ji panè: «Kinə dow taa dené ɓá ojɨ siə ngon al ɓəy ya oy rəmə, ngonkɔ̰ njègoto-je à taa dené ndubə lé kojɨ-né ngan-je kdɔ kində-né ko-é.» ");
INSERT INTO mge_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ngankɔ̰-na̰-je dꞌasɨ siri bè; ḛ kɨ́ dɔsa̰y taa dené ə́ ojɨ siə ngon al ɓəy ya ə oy. ");
INSERT INTO mge_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Beɓa ḛ kɨ́ njèkungɨ-tɨ joo ree taa dené ndubə lé, rəmə ojɨ siə ngon al ya ə oy ɓəy; njèkungɨ-tɨ mutə kàrè bè ya rəm. ");
INSERT INTO mge_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bè-bè ya ngankɔ̰-na̰-je kɨ́ siri kin dꞌojɨ siə ngon al ya dꞌoy-né lay rəm, ɓá dené-é lé kàrè oy-né go-dé-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndɔ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé, se dené kinlé à to ne ná̰ dan-dé-tɨ wa? Kdɔtalə dḛ ꞌtaa-é ya siri lay. ");
INSERT INTO mge_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeju təl idə-dé panè: «Sə̰i uri wale, kdɔ sə̰i ꞌgəi mḛḛ ta kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay lé al rəm, ɓá ꞌgəi tɔ́gɨ lə Lubə al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kdɔ lokɨ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé, taana̰ à goto; dow-je dꞌa kisɨ titɨ-na̰ kɨ́ malayka-je dꞌisɨ-né dɔra̰-tɨ kin bè. ");
INSERT INTO mge_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta lə tɔsɨ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé, sə̰i ꞌndói mḛḛ mbete-tɨ lə Moiyijɨ lo-é-tɨ kɨ́ Lubə pa-né siə ta dan kam-tɨ lé ya al wa? Ḛ pa siə panè: «Mꞌto Lubə lə Abrakam, Lubə lə Isakɨ kɨ̀ Lubə lə Jakobɨ.» ");
INSERT INTO mge_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Lubə lé to Lubə lə dow-je kɨ́ dꞌoy al. Ngà to Lubə lə dow-je kɨ́ dꞌisɨ kəm. Adɨ sə̰i uri wale kur kɨ́ nga̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dow káre dan njéndó dow-je ndukun-je-tɨ oo ndi-dé lo najɨ-na̰ ta-tɨ ə gə kɨ́ Jeju ilə-dé ta-tɨ kin majɨ n̰a̰ lé, ḛ ɔtɨ ree rɔ-é-tɨ dəjɨ-é panè: «Dan ndukun-je-tɨ lay lé, ḛ kɨ́ rá ɓá to kɨ́ boy itə madɨ-é-je wa?» ");
INSERT INTO mge_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeju təl ilə-é-tɨ panè: «Ndukun kɨ́ boy itə madɨ-é-je lay ə́n: “ꞌOo, Israyel! ꞌƁaɓe Lubə lə-ji ya to ꞌƁaɓe kɨ̀ kár-é bè. ");
INSERT INTO mge_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ꞌA ndigɨ ꞌƁaɓe Lubə lə-i kɨ̀ mḛḛ-i kɨ́ káre-rè, kɨ̀ ndil-i lay, kɨ̀ tagɨr lə-i lay, ɓá kɨ̀ tɔ́gɨ-i lay rəm tɔ.” ");
INSERT INTO mge_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndukun kɨ́ ɔsɨ go-é ə́n: “ꞌA ndigɨ dow madɨ-i tokɨ kɨ̀ rɔ-i bè tɔ.” Ndukun-je kɨ́ joo kinlé, ḛ kɨ́ rangɨ kɨ́ boy itə-dé goto.» ");
INSERT INTO mge_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Njèndó dow-je ndukun lé təl idə-é panè: «Oiyo, njèndó dow-je né, ta lə-i to tó-é. Lubə lé ra káre-rè ə ḛ kɨ́ rangɨ kɨ́ ɔsɨ kəl-é goto rəm, ");
INSERT INTO mge_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","kadɨ dow ndigɨ-é kɨ̀ mḛḛ-é kɨ́ káre-rè rəm, kɨ̀ tagɨr liə lay rəm, kɨ̀ tɔ́gɨ-é lay rəm, ɓá kadɨ dow ndigɨ madɨ-é tokɨ rɔ-é bè rəm kinlé, to né-je kɨ́ majɨ itə da̰-je lay kɨ́ ró, kɨ̀ ḛ kɨ́ kilə məsɨ-dé nangɨ kadɨ Lubə.» ");
INSERT INTO mge_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lokɨ Jeju oo kɨ́ ḛ təl ilə-é-tɨ kɨ̀ gosɨ lé, ḛ idə-é panè: «I ꞌa̰ sa̰y kɨ̀ kɔ̰ɓe kɨ́ dɔra̰-tɨ al.» Beɓa go-tɨ lé, dow kɨ́ ɓo dəjɨ ta Jeju ra-é ya goto ngá. ");
INSERT INTO mge_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lokɨ Jeju un ta ə a̰ ndó né dow-je takəy-tɨ lə Lubə rəmə, ḛ dəjɨ ta panè: «Kdɔ ri ɓá njéndó dow-je ndukun-je ꞌpanè Kristɨ to ngonka Dabidɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabidɨ ya kàrè, lokɨ Ndil kɨ́ aa njay tḛḛ kɨ̀ dɔ ta adɨ-é lé ḛ panè: «ꞌƁaɓe idə ꞌƁaɓe lə-m panè: ꞌRee ꞌisɨ dɔ jikɔl-m-tɨ sar kadɨ mꞌtəl njéba-je lə-i gin tɔ́gɨ-i-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dabidɨ ya kɨ̀ dɔ-é ɓa Kristɨ ꞌƁaɓe, ngà ra ban ɓá Kristɨ à to ngonka-é ɓəy wa? Lo-é-tɨ kinlé kosɨ dow-je dꞌoo ta liə kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mḛḛ néndó-tɨ lé, Jeju panè: «Ooi go rɔ-si majɨ kɨ rɔ njéndó dow-je ndukun-je-tɨ. Kdɔ dḛ lé nəl-dé kɔr gama̰ kɨ̀ kubɨ-je kɨ́ ngal puu-puu rəm, ꞌndigɨ kadɨ dow-je ꞌra-dé lapiya kunta-na̰ lokosɨ-je-tɨ rəm, ");
INSERT INTO mge_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ꞌndigɨ lokisɨ-je kɨ́ kete nɔ̰̀ dow-je-tɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je rəm, ɓá ꞌsangɨ lokisɨ-je kɨ́ nɔ̰̀ dow-je-tɨ lo nékuso ra na̰y-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dḛ ꞌkəə né-je kɨ́ mḛḛ kəy-je-tɨ lə njéngɔwkoy-je kər-kər ə ꞌpa ta kɨ̀ Lubə dꞌadɨ ngal n̰a̰-n̰a̰ kadɨ dow-je dꞌoo-dé-né. Ta kɨ́ gangɨ kɨ́ nga̰ n̰a̰ ya à ree dɔ-dé-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Go-tɨ, Jeju isɨ nangɨ sɔbɨ dɔ ku kilə kadkare kɨ́ mḛḛ kəy-tɨ lə Lubə isɨ oo se ban ɓá dow-je dꞌisɨ dꞌadɨ-né né Lubə lə-dé wa? Njénékingə-je ꞌree dꞌadɨ là kɨ́ n̰a̰-n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngà njèngɔwkoy káre kɨ́ to njèndoo ree ungɨ silə joo kɨ́ to né al. ");
INSERT INTO mge_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Beɓa Jeju ɓa njéndó né-je liə idə-dé panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; njèngɔwkoy kɨ́ njèndoo kanlé, adɨ né itə ndəgɨ dow-je lay kɨ́ dꞌadɨ né kinlé. ");
INSERT INTO mge_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kdɔ dḛ kɨ́ lay kinlé, to man dɔ là-je lə-dé kɨ́ tò mburukɨ-mburukɨ ɓá dꞌadɨ tin. Ngà dené kanlé, né liə goto, adɨ ḛ un sɔ̰y nékingə-é ya adɨ ə to sɔ̰y né kɨ́ à kuso kdɔ kisɨ-né ya ɓá un latɨ adɨ tin.» ");
INSERT INTO mge_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lokɨ Jeju tḛḛ kəy-tɨ lə Lubə kɨ ndaa-tɨ lé, dow káre dan njéndó né-je-tɨ liə panè: «Njèndó dow-je né, ꞌoo kəy kɨ́ boy kɨ́ dꞌində kɨ̀ ər-je kɨ́ kurə́-kurə́ kin.» ");
INSERT INTO mge_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Beɓa Jeju ilə-é-tɨ panè «ꞌOo, kəy-je kɨ́ boy-boy kinlé, dꞌa tɔsɨ tilə káre-káre kadɨ ər káre ya kàrè à tò dɔ madɨ-é-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Go-tɨ, Jeju isɨ dɔ mbal ka̰ kagɨ Olibiye-je-tɨ sɔbɨ dɔ kəy lə Lubə rəmə, Piyər, kɨ̀ Jakɨ, kɨ̀ Ja̰, kɨ̀ Andre ꞌɓa-é ngərəngɨ ꞌdəjɨ-é ta ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ꞌIdə-ji, ndɔ kɨ́ rá ɓá né-je kinlé à ra né wa? Ə ri ɓá à tɔjɨ kadɨ jꞌgə-né dɔkaglo-je kɨ́ né-je kinlé à ra né wa?» ");
INSERT INTO mge_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Beɓa Jeju idə-dé panè: «Indəi kəmkaa dɔ rɔ-si-tɨ, adi dow ədɨ-si al. ");
INSERT INTO mge_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kdɔ dow-je n̰a̰ dꞌa kun ri-m kində dɔ-dé-tɨ ə dꞌa panè: “Dḛ ya ꞌto Kristɨ.” Beɓa dꞌa kədɨ-né dow-je n̰a̰ kur-dé-né wale. ");
INSERT INTO mge_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lokɨ a kooi poy rɔ-je, kɨ̀ ká rɔ-je lé, adi mḛḛ-si gangɨ man al. Lé ban-ban ya kàrè né-je kinlé à ra né ya, ngà kḛ ɓá à to sɔ̰y né-je al ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gin dow-je madɨ dꞌa kḭ rɔ kɨ̀ gin dow-je madɨ, kɔ̰ɓe káre à kḭ rɔ kɨ̀ kɨ́ káre, dɔnangɨ à yəkɨ kɨ̀ lo-lo, ɓobo à kusɨ. Bè ya kàrè, à tò titɨ kulə gin ndo lə dené bè ɓəy.» ");
INSERT INTO mge_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ooi go rɔ-si majɨ, kdɔ dꞌa kɔw sə-si nɔ̰̀ njégangta-je-tɨ rəm, dꞌa tində-si mbukɨ-mbukɨ kəykəwna̰-tɨ lə jipɨ-je rəm, dꞌa kɔw sə-si nɔ̰̀ gubərnər-je-tɨ kɨ̀ nɔ̰̀ ngar-je-tɨ kadɨ ꞌgangɨ ta dɔ-si-tɨ kdɔ ta lə-m; beɓa dꞌa kingə-né ta kɨ́ sɔbɨ dɔ-m ta-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngà tò kadɨ mbḛ Poyta kɨ́ Majɨ lə-m lé, à kusɨ mbi gin dow-je-tɨ lay kete ɓəy ɓá né-je kin à ra né. ");
INSERT INTO mge_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lokɨ dꞌɔw sə-si nɔ̰̀ njégangta-je-tɨ lé, adi mḛḛ-si a̰ kə́kə́kə́ kete kdɔ ta-je kɨ́ à pai al; ngà ta kɨ́ à tokɨ kində ta-si-tɨ dɔkàdɨ̀-é-tɨ kin ya ɓá ꞌpai; kdɔ to sə̰i ɓá a pai ta lé al, ngà to Ndil kɨ́ aa njay ɓá à kində ta ta-si-tɨ kadɨ ꞌpai.» ");
INSERT INTO mge_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Dow à kun dɔ ngonkɔ̰-é ya kadɨ ꞌtɔl-é; bɔbɨ ngon à kun dɔ ngon-é kadɨ ꞌtɔl-é; ngan-je dꞌa kɔsɨ ta njékojɨ-dé-je rəm, dꞌa kun dɔ-dé kadɨ ꞌtɔl-dé rəm. ");
INSERT INTO mge_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dow-je lay ya dꞌa kɔsɨ-si kɨ̀ ta kdɔ ta lə-m. Ngà dow kɨ́ uwə rɔ-é nga̰ sar tḛḛ sɔ̰y-é-tɨ ə à kajɨ.» ");
INSERT INTO mge_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Dow kɨ́ isɨ ndó mbete rəmə kadɨ gə mḛḛ ta kin majɨ. Lokɨ a kooi nékɔbɨ, kɨ̀ né kɨ́ tò n̰ḛ lo-tɨ kɨ́ tuwə kadɨ tò-tɨ al rəmə, kadɨ dow-je kɨ́ dꞌisɨ dɔnangɨ Jude-tɨ, dꞌa̰y dꞌɔw dan mbal-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dow kɨ́ isɨ dɔ kəy-tɨ kàrè, kadɨ ur nangɨ kdɔ kɔw kəy kun né madɨ al ngá, ");
INSERT INTO mge_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","rəm ɓá dow kɨ́ a̰ ndɔrɔ kàrè, kadɨ təl ree ɓee un kubɨ kul liə al tɔ. ");
INSERT INTO mge_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ə́ mḛḛ ndɔ-é-je-tɨ kin tujɨ kɨ́ à kusɨ dɔ dené-je-tɨ kɨ́ njésəm kɨ̀ dḛ kɨ́ dꞌisɨ dꞌadɨ mba ngan-je à tò ban ə́n ə!» ");
INSERT INTO mge_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«Beɓa ꞌpai ta kɨ̀ Lubə kdɔ kadɨ né kin ra né na̰y kul-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kdɔ ndɔ-je kinlé, à to ndɔ kɔ̰̀ kɨ́ dum natɨ kɨ́ lokɨ Lubə ində-né dɔnangɨ kin ya dow oo nja káre al ɓəy rəm, ɓá dow à koo ga̰-é gogɨ al ya sar rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kinə ꞌƁaɓe gangɨ ta ndɔ-je kinlé adɨ gɔjɨ al rəmə, dow kɨ́ à kajɨ ya goto. Ngà kḛ ɓá ḛ adɨ ndɔ-je kinlé gɔjɨ, kdɔ dow-je kɨ́ ḛ mbətɨ-dé adɨ ꞌto dow-je liə.» ");
INSERT INTO mge_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Kinə dow idə-si panè: “Kristɨ a̰ nè” əse “a̰ yó”, kàrè ꞌtaai ta liə al. ");
INSERT INTO mge_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kdɔtalə, njéɓa rɔ-dé Kristɨ-je, kɨ̀ njéɓa rɔ-dé njépata-je kɨ́ ta Lubə-tɨ dꞌa kḭ kdɔ ra nékɔjɨ-je, kɨ̀ né mbəli-je kdɔ kədɨ-né dow-je. Dꞌa ra bè sangɨ-né koo se dꞌa kur dow-je kɨ́ Lubə mbətɨ-dé lé wale kare wa. ");
INSERT INTO mge_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ooi go rɔ-si majɨ. Ma̰ mꞌidə-si rəsɨ ngá ə́n!» ");
INSERT INTO mge_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Go ndɔ kɔ̰̀-je-tɨ kɨ́ dum natɨ kinlé, londul à kutɨ kəm kàdɨ̀, na̰y à nda al, ");
INSERT INTO mge_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kərwəḭ-je kɨ́ dɔra̰-tɨ dꞌa tusɨ nangɨ, ɓá tɔ́gɨ-je kɨ́ dɔra̰-tɨ à yəy yəkɨ-yəkɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rəmə dow-je dꞌa koo Ngon lə dow à kḭ dɔra̰-tɨ kisɨ ree dan kilndi-tɨ kɨ̀ tɔ́gɨ kɨ́ n̰a̰ rəm, ɓá kɨ̀ riɓa rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ḛ à kulə malayka-je kadɨ ꞌkəw dow-je kɨ́ ḛ mbətɨ-dé kɨ dɔ kum dɔnangɨ kɨ́ sɔ kin lay kɨ natɨ. Dꞌa kḭ ngangɨ dɔnangɨ-tɨ kɔw njal ngangɨ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Uni néndó mḛḛ gosta-tɨ kɨ́ dɔ kote-tɨ kin ooi. Kote lé, lokɨ balkəm-é-je təl tò mbəl ɓá mbi-é tubə dɔ-tɨ lé, sə̰i ꞌgəi kɨ́ na̰y ɓà nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bè ya tɔ, lokɨ ooi kɨ́ né-je kinlé isɨ ra né rəmə, kadɨ ꞌgəi kɨ́ Ngon lə dow a̰ tarəbɨ-tɨ pèrèrè ngá. ");
INSERT INTO mge_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow-je kɨ́ dꞌisɨ kəm nè kin, dꞌa koy lay al ya né-je kinlé à ra né. ");
INSERT INTO mge_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dɔra̰-je kɨ̀ dɔnangɨ kin dꞌa goto, ngà ta-je lə-m lé à goto al ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ta lə ndɔ əse kàdɨ̀ ree lə Ngon lə Lubə lé, dow kɨ́ gə goto, malayka-je kɨ́ dɔra̰-tɨ ya kàrè ꞌgə al rəm, ɓá Ngon lə Lubə lé ya kàrè gə al, ngà Bɔbɨ-é ya kɨ̀ kár-é ɓá gə. ");
INSERT INTO mge_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Beɓa ooi go rɔ-si majɨ, isi kəm dɔ rɔ-si-tɨ, kdɔ sə̰i ꞌgəi ndɔ kɨ́ né-é à ra-né né al. ");
INSERT INTO mge_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","À tò titɨ-na̰ kɨ̀ njèkəy kɨ́ isɨ ɔw mba rəmə in̰ə kəy liə, ində ngannjékullə-je liə dɔ-tɨ, gángɨ kullə dɔ-dé-tɨ kɨ̀ go-é go-é kadɨ ꞌra, ɓá ndəjɨ njèngəm takəy kadɨ isɨ kəm. ");
INSERT INTO mge_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ə́n ə́ isi kəm dɔ rɔ-si-tɨ tɔ, kdɔ sə̰i ꞌgəi ndɔ kɨ́ njèkəy à təl-né al. À təl ta losɔlɔ pee əse danlo-tɨ, əse kɨ̀ ndi nɔ̰ kunjə əse kɨ̀ ndɔge. ");
INSERT INTO mge_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Beɓa isi kəm dɔ rɔ-si-tɨ nè à kḭ ree kubə-si nangɨ busɨ dɔ ɓi-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta kɨ́ mꞌidə-si kinlé, mꞌidə dow-je lay tɔ, kadɨ isi kəm dɔ rɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ndɔ ra na̰y Pakɨ, kɨ̀ ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ nà̰y ndɔ joo. Njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je ꞌsangɨ kəm rəbɨ kdɔ kədɨ Jeju kuwə-é tɔl-é. ");
INSERT INTO mge_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kdɔtalə dḛ ꞌpanè: «Jꞌa rai ndɔ ra na̰y-tɨ al, kdɔ jꞌa kungi dow-je dɔ-ji-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeju isɨ mḛḛ ɓe-tɨ kɨ́ Betani, mḛḛ kəy-tɨ lə Simɔ̰ kɨ́ ndɔkɨ to njèbanjɨ. Lokɨ dꞌisɨ ta nékuso-tɨ rəmə, dené káre bè andɨ go-dé-tɨ kɨ̀ ku kɨ́ ꞌra kɨ̀ ər kɨ́ ꞌɓa-é «albatrə» ji-é-tɨ. Ku lé, ubɨ kɨ́ ətɨ majɨ rusɨ mḛḛ-é ə to ubɨ wale kɨ́ ꞌɓa-é «nár» kɨ́ yə́rə́rə́ adɨ là-é n̰a̰. Dené lé ində ta ku lé tətɨ, ə ungɨ ubɨ lé dɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rəmə nəl dow-je kɨ́ ná̰-je al, adɨ ꞌpa ta dan-dé-tɨ ꞌpanè: «Ḛ tujɨ ubɨ kin kɔgɨ bè kdɔ ri wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","To ubɨ kɨ́ lé jꞌa taa-né là kɨ́ à dəə là kullə kɨ́ ndɔ ɓumutə kdɔ ləbɨ njéndoo-je al ɓan wa? Rəmə wɔngɨ ra-dé dɔ dené-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngà Jeju panè: In̰əi dené kin jeke. Adi-é kɔ̰̀ bè kdɔ ri wa? Ḛ ra né kɨ́ majɨ kdɔ ta lə-m. ");
INSERT INTO mge_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kdɔ njéndoo-je dꞌa kisɨ sə-si nè kɨ̀ ndɔ-é ndɔ-é, adɨ ndɔ kɨ́ ꞌndigi lé, a rai sə-dé majɨ ɓəy, ngà ma̰ lé mꞌa kisɨ sə-si kɨ̀ ndɔ-je lay al. ");
INSERT INTO mge_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dené kinlé ra né kɨ́ tɔ́gɨ-é asɨ ra; ḛ ndəm-m ubɨ kete kdɔ dubɨ-m-né. ");
INSERT INTO mge_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ooi majɨ, mꞌa kidə-si rəsɨ; lo lay kɨ́ dɔnangɨ-tɨ nè kɨ́ dꞌa kilə mbḛ Poyta kɨ́ Majɨ titɨ lé, dꞌa kɔr poy né kɨ́ dené ra kinlé kadɨ mḛḛ dow-je ole-né dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judasɨ Iskariyotɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ lə Jeju kɨ́ dɔgɨ gidɨ-é joo ɔw ɔjɨ ta kɨ̀ njékun dɔ njégugné-je lə Lubə kadɨ nꞌilə Jeju ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lokɨ dꞌoo ta liə bè lé, rɔ-dé nəl-dé n̰a̰ adɨ dꞌun mindɨ-dé kadɨ dꞌadɨ-é là. Dɔgangɨ-é-tɨ kinlé, Judasɨ sangɨ kəm rəbɨ kɨ́ majɨ kadɨ nꞌilə-é-né ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ndɔ kɨ́ dɔsa̰y lə ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ, ndɔ kɨ́ dꞌilə-né məsɨ batɨ-je nangɨ kdɔ nékuso kɨ́ lo Pakɨ-tɨ lé, njéndó né-je lə Jeju ꞌdəjɨ-é ꞌpanè: «Lo kɨ́ rá ɓá i ꞌndigɨ kadɨ jꞌra nékuso Pakɨ-tɨ jꞌadɨ-i wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Beɓa Jeju ulə njéndó né-je joo kete panè: «Ɔwi mḛḛ ɓebo-tɨ, a kingəi dingəm kɨ́ utɨ gùm man rəmə ꞌndoli go-é. ");
INSERT INTO mge_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mḛḛ kəy kɨ́ ḛ ɔw-tɨ lé, idəi njèkəy ꞌpainè: Njèndó dow-je né panè, mḛḛ kəy kɨ́ rá ɓá nꞌa kuso né Pakɨ-tɨ kɨ̀ njéndó né-je lə-nꞌḛ̀ wa? ");
INSERT INTO mge_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ə ḛ à kɔjɨ-si kəy káre kɨ́ mḛḛ-é tatɨ pəl-pəl kɨ́ tò dɔ madɨ-é-tɨ taá; né-je lay tò-tɨ rəm, tokɨ ra go-é lay rəm; lo kin ɓá a rai nékuso-tɨ kdɔ-ji.» ");
INSERT INTO mge_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ngà lokɨ njéndó né-je dꞌɔtɨ dꞌɔw mḛḛ ɓebo-tɨ lé, dꞌingə né-je lay titɨ kɨ́ Jeju idə-dé-né ə ꞌra nékuso Pakɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta kàdɨ̀ kur-tɨ, Jeju ree kɨ̀ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lokɨ dꞌisɨ ta nékuso-tɨ lé, Jeju panè: «Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow káre dan-si-tɨ kɨ́ isɨ uso sə-m né à kun dɔ-m.» ");
INSERT INTO mge_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Go ta-tɨ kinlé, mḛḛkɔ̰̀ ra njéndó né-je adɨ ꞌdəjɨ-é ta ɔsɨ go-na̰ go-na̰ ꞌpanè «To ma̰ wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeju təl ilə-dé-tɨ panè: «To dow káre dan-si-tɨ sə̰i kɨ́ dɔgɨ gidɨ-é joo kin, kɨ́ ulə ji-é sə-m natɨ mḛḛ ba̰y-tɨ kin ya. ");
INSERT INTO mge_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tɔgrɔ, Ngon lə dow à koy titɨ kɨ́ mbete kɨ́ aa njay pa-né ta kɨ́ sɔbɨ dɔ-é lé ya, ngà tujɨ ɓá à kusɨ dɔ dow-tɨ kɨ́ njèkun dɔ-é. Dowbé kinlé dꞌojɨ-é al kàrè tò sotɨ.» ");
INSERT INTO mge_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lokɨ dꞌisɨ dꞌuso né lé, Jeju un mbə̀ rəmə ra oiyo Lubə ɓá uwə gangɨ adɨ njéndó né-je liə ə panè: «ꞌTaai, né kin to dajɨ rɔ-m.» ");
INSERT INTO mge_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Go-tɨ, un kobɨ kɨ́ man nduu tò-tɨ, ra oiyo Lubə, adɨ-dé ə dḛ lay ya dꞌa̰y. ");
INSERT INTO mge_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jeju idə-dé panè: «Kin to məsɨ-m, məsɨ kulənojɨ natɨ kɨ̀ Lubə kɨ́ ungɨ nangɨ kdɔ kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ooi majɨ, mꞌa kidə-si rəsɨ; mꞌa ka̰y man nduu gogɨ al sar ndɔ kɨ́ mꞌa ka̰y kɨ̀ sigɨ kɔ̰ɓe-tɨ lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Go-tɨ, dꞌusɨ pa-je ɓəy ɓá dꞌḭ dꞌɔw dɔ mbal ka̰ kagɨ Olibiye-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jeju idə njéndó né-je liə panè: «Sə̰i lay ya a tusi-mi kin̰əi-mi, kdɔ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: “Mꞌa tɔl njèkul batɨ-je, rəmə batɨ-je dꞌa sane-na̰.”» ");
INSERT INTO mge_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngà Jeju təl ilə dɔ-tɨ panè: «Kḛ ɓá lokɨ mꞌa tɔsɨ ndəl kində lo tḛḛ lé, mꞌa kɔw ngəbɨ-si Galile.» ");
INSERT INTO mge_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyər idə-é panè: «Lé dow-je lay ꞌtusi dꞌin̰ə-i kɔgɨ kàrè ma̰ bè lé mꞌa kin̰ə-i kɔgɨ nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeju ilə-é-tɨ panè: «ꞌOo majɨ, mꞌa kidə-i rəsɨ; ɓone ə kɨ́ ndɔɔ nè-tɨ kin ya, kunjə à nɔ̰ nja joo al ɓəy ya ꞌa najɨ panè ꞌgə-m al ya nja mutə.» ");
INSERT INTO mge_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyər təl ilə-é-tɨ kɨ̀ tɔ́gɨ-é ya ɓəy panè: «Kadɨ mꞌnajɨ ta mꞌpanè mꞌgə-i al lé, kɨ́ nja káre ya kàrè à tḛḛ ta-m-tɨ al. Lé asɨ kəm koy kàrè mꞌa koy sə-i.» Rəmə ndəgɨ njéndó né-je lay ꞌpa bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lokɨ dꞌɔw ꞌtḛḛ lo-tɨ kɨ́ ꞌɓa-é Getsemane rəmə, Jeju idə njéndó né-je liə panè: «Isi nangɨ nè adɨ mꞌɔw mꞌpa ta kɨ̀ Lubə.» ");
INSERT INTO mge_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ə ḛ adɨ Piyər, kɨ̀ Jakɨ, kɨ̀ Ja̰ dꞌɔw siə rəmə, dɔ gangɨ-é-tɨ kinlé ɓá ɓəl kɨ̀ mḛḛ gangɨ man ulə gin ra Jeju. ");
INSERT INTO mge_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Beɓa idə-dé panè: «Mḛḛkɔ̰̀ ra-m asɨ koy; isi nangɨ nè ə ɔgi kəm-si ɓi.» ");
INSERT INTO mge_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ngà rəmə lokɨ ɔtɨ kete sḛ lé, usɨ nangɨ pa ta kɨ̀ Lubə panè kinə kəm rəbɨ kɨ́ rangɨ tò nɔ̰ɔ̰ rəmə, kadɨ nꞌra nꞌadɨ kàdɨ̀ kɨ́ né kin ɔw kɨ̀ ra-né né kinlé tḛḛ dɔ-nꞌḛ̀-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ḛ panè: «Aba! Bɔbɨ-m, i lé ꞌɔw kɨ̀ tɔ́gɨ dɔ né-je-tɨ lay, ꞌitə kɔ̰̀ kɨ́ n̰a̰ kin kɨ rangɨ dɔ-m-tɨ. Lé bè ya kàrè, ꞌra kɨ́ go ndigɨ-tɨ lə-m ma̰ al; ngà kadɨ ꞌra kɨ́ go ndigɨ-tɨ lə-i i ya.» ");
INSERT INTO mge_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jeju təl ree rɔ njéndó né-je-tɨ kɨ́ mutə lé rəmə ingə-dé dɔ ɓi-tɨ. Beɓa ḛ pa kɨ̀ Piyər panè: «Simɔ̰, ꞌto ɓi wa? Kadɨ ꞌɔgɨ kəm-i ɓi kàdɨ̀ káre bè ya kàrè ꞌasɨ al wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","«Ɔgi kəm-si ɓi ə ꞌpai ta kɨ̀ Lubə kdɔ kadɨ néna̰ tḛḛ dɔ-si-tɨ rəmə usi al. Ndil ndigɨ, ngà dajɨ rɔ dow ɓá tɔ́gɨ-é asɨ al.» ");
INSERT INTO mge_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jeju təl in̰ə-dé ɓəy ə ɔw pa ko ta-je kɨ́ káre kin ya kɨ̀ Lubə ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Go-tɨ, təl ree, rəmə ingə-dé dɔ ɓi-tɨ, kəm-dé ɔy diriri. Dḛ ꞌgə ta kɨ́ dꞌa kidə-é al. ");
INSERT INTO mge_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Təl ree kɨ́ nja mutə idə-dé panè: «ꞌToi ɓi lə-si ngá, uwəi rɔ-si. Gin né-je gangɨ ngá! Kàdɨ̀ asɨ; dꞌa kilə Ngon lə dow ji njéramajal-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ḭi taá adɨ jꞌɔwi! Ooi, dow kɨ́ njèkilə-m ji-dé-tɨ lé isɨ ree ngá!» ");
INSERT INTO mge_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jeju pa ta lé ilə nangɨ al ya ɓəy rəmə Judasɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé, ree kɨ̀ kosɨ dow-je kɨ́ dꞌutɨ kiyərɔ-je kɨ̀ kagɨ-je ji-dé-tɨ. Dow-je kinlé, njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ɓá dꞌulə-dé. ");
INSERT INTO mge_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Njèkun dɔ Jeju lé, tɔjɨ-dé né kɨ́ nꞌa ra kadɨ ꞌgə-né Jeju. Ḛ panè: «Dow kɨ́ mꞌa ra-é lapiya, kuwə-é kàdɨ̀-m-tɨ kin ya to ḛ, ə́n ə́ uwəi-é əjè ꞌngəmi-é majɨ ə ɔwi siə.» ");
INSERT INTO mge_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lokɨ Judasɨ ree tḛḛ rɔ Jeju-tɨ rəmə ɓa-é panè: «Njèndó dow-je né», rəmə uwə-é kàdɨ̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Beɓa dow-je kɨ́ ꞌree siə lé dꞌuwə Jeju. ");
INSERT INTO mge_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kɨ́ káre dan dḛ-tɨ kɨ́ dꞌa̰ siə, ɔr kiyərɔ tugə-né mbi ngonnjèkullə lə burə dɔ njégugné-je lə Lubə ndətɨ ya gangɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jeju idə-dé panè: «Sə̰i ooi-mi kɨ bɔkaya dow ɓá ꞌreei kɨ̀ kiyərɔ-je kɨ̀ salangɨ-je kdɔ kuwəi-mi-né wa? ");
INSERT INTO mge_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma̰ kɨ́ ndɔ-je lay mꞌisɨ natɨ sə-si takəy-tɨ lə Lubə, mꞌndó né dow-je ya ə́ uwəi-mi al, ngà né kinlé tò bè kdɔ kadɨ ta-je kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay kinlé né-é ra né.» ");
INSERT INTO mge_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Beɓa njéndó né-je lay ya ꞌtusɨ-é dꞌin̰ə-é dꞌa̰y-na̰. ");
INSERT INTO mge_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Basa káre bè ɓɨr rɔ-é kɨ̀ kubɨ, ndole go Jeju, beɓa ꞌsangɨ kadɨ dꞌuwə-é. ");
INSERT INTO mge_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lokɨ ꞌsangɨ kadɨ dꞌuwə-é lé, ḛ in̰ə kubɨ liə ji-dé-tɨ, a̰y kɨ̀ rɔ-é kare. ");
INSERT INTO mge_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dꞌɔw kɨ̀ Jeju ɓe lə burə dɔ njégugné-je lə Lubə. Njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, kɨ̀ njéndó dow-je ndukun-je lay ya ꞌkəw-na̰ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyər njiyə go-é-tɨ jan-jan adɨ rəbɨ-é rà ɗəkɨ siə, ɔw sar tḛḛ mḛḛ ndògɨ-tɨ panata lə burə dɔ njégugné-je lé ə isɨ natɨ kɨ̀ ngannjékullə-je isɨ ndibɨ pər. ");
INSERT INTO mge_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je dꞌingə-na̰, ꞌsangɨ kəm rəbɨ kadɨ dꞌingə ta madɨ kɨ́ sɔbɨ dɔ Jeju kdɔ kadɨ ꞌgangɨ-né ta koy dɔ-é-tɨ, ya ngà dꞌingə al. ");
INSERT INTO mge_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dow-je n̰a̰ ya ꞌtə́tɨ ta kɨ́ ndángɨ dɔ-é-tɨ, ngà ta-je lə-dé ɔw go-na̰-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dḛ kɨ́ ná̰-je dꞌubə nangɨ dꞌḭ taá ꞌtə́tɨ ta ta-é-tɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Jꞌoo ta-é-tɨ panè: «Mꞌa tɔɔ kəy lə Lubə kɨ́ dow-je dꞌində kɨ̀ ji-dé kin, ə ndɔ mutə ya mꞌa kində kɨ́ rangɨ kɨ́ ji dow ɓá à ra al.» ");
INSERT INTO mge_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dɔ ta-tɨ kin ya kàrè ndi-dé ɔw go-na̰-tɨ al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Burə dɔ njégugné-je lé ḭ taá dan kosɨ dow-je-tɨ dəjɨ Jeju panè: «I ꞌa kilə ta-je-tɨ kɨ́ dow-je kin ꞌtilə dɔ-i-tɨ kinlé al wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta-é kɨ́ ngarara ya kàrè ḛ tḛḛ ilə-é-né-tɨ al. Burə dɔ njégugné-je təl dəjɨ-é ya ɓəy panè: «I ꞌto Kristɨ kɨ́ Ngon lə Lubə kɨ́ jꞌɔsɨ gajɨ-é lé wa?» ");
INSERT INTO mge_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeju ilə-é-tɨ panè: «Oiyo, to ma̰ ya. Ə a kooi Ngon lə dow à kisɨ dɔ jikɔl Lubə-tɨ kɨ́ njètɔ́gɨ rəm, ɓá a kooi-é kɨ́ à kḭ dɔra̰-tɨ kisɨ ree dan kilndi-tɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Beɓa burə dɔ njégugné-je lé tuwə kubɨ kɨ́ rɔ-é ḛ-tɨ ya gángɨ batɨ-batɨ ə panè: «Jꞌɔwi ndoo koo ta ta dow kɨ́ rangɨ-tɨ ɓəy ɓan wa? ");
INSERT INTO mge_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ta kɔbɨ kɨ́ ḛ pa kɨ̀ Lubə lé, sə̰i ooi kɨ̀ mbi-si; ta ri ə́ ꞌgɨri dɔ-tɨ wa?» Dow-je lay ya ꞌgangɨ ta dɔ-é-tɨ ꞌpanè: «Koy-é ya ɓá to tó-é.» ");
INSERT INTO mge_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Beɓa dḛ kɨ́ ná̰-je dan-dé-tɨ ꞌtubə yoro dɔ-é-tɨ, ꞌdɔɔ kəm-é kɨ̀ takubɨ, ꞌɓɨr ji-dé ꞌtində-é-né ə ꞌpa siə ꞌpanè: «ꞌAdɨ Lubə idə-i ə ꞌpa adɨ jꞌoo sé to ná̰ ɓá ində-i wa?» Ɓá ngannjékullə-je ꞌtində mbɔ́-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dɔgangɨ-é-tɨ kɨ́ Piyər nà̰y-né mḛḛ ndògɨ-tɨ nangɨ ɓəy lé, dené káre dan ngannjékullə-je-tɨ lə burə dɔ njégugné-je lé ree, ");
INSERT INTO mge_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ɓá ḛ oo Piyər isɨ ndibɨ pər rəmə oo-é gə́rə́rə́ ə idə-é panè: «I ya kàrè ꞌto njènjiyə kɨ̀ Jeju, dow kɨ́ Najarɛtɨ kinlé tɔ.» ");
INSERT INTO mge_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngà Piyər təl najɨ panè: «Kuy! Mꞌgə al, i lé ta ri ɓá ꞌndigɨ pa kàrè mꞌgə al.» Go-tɨ rəmə, Piyər tḛḛ ɔw ndaa-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngà dené lé oo Piyər lé ɓəy rəmə, təl idə dow-je panè: «Dow kanlé to kɨ́ dan-dé-tɨ ya.» ");
INSERT INTO mge_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Rəmə Piyər najɨ ya ɓəy. Sḛ go-tɨ ya rəmə, dḛ kɨ́ dꞌa̰ lo-é-tɨ ꞌpa kɨ̀ Piyər ꞌpanè: «Tɔgrɔ-tɨ, i lé ꞌto kɨ́ dan-dé-tɨ ya, kdɔ i ꞌto dow kɨ́ dɔnangɨ Galile-tɨ; ꞌpa ta tana̰ sə-dé rəm.» ");
INSERT INTO mge_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Beɓa Piyər ubɨ rɔ-é panè kadɨ Lubə ində-m ɔjɨ-m: «Mꞌgə dow kɨ́ ꞌpai ta liə kinlé al.» ");
INSERT INTO mge_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tajinatɨ nè ya kunjə nɔ̰ nɔ̰ kɨ́ nja joo, rəmə mḛḛ Piyər ole dɔ ta-tɨ kɨ́ kete Jeju pa siə panè: «Kunjə à nɔ̰ nja joo al ɓəy ya ꞌa najɨ ta panè ꞌgə-m al ꞌgə-m al ya nja mutə.» Beɓa ḛ gɨr tḛḛ dɔ ta-tɨ kin rəmə nɔ̰ ɓuktu-ɓuktu. ");
INSERT INTO mge_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɨ̀ ndɔge ratɨ ya, njékun dɔ njégugné-je lə Lubə ꞌkəw-na̰, dꞌɔjɨ-na̰ ta kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, kɨ̀ njéndó dow-je ndukun-je, adɨ to kuwədɔ-na̰ lə ꞌboy-je kɨ́ njégangta-je lə jipɨ-je lay. Beɓa dḛ dꞌun ndu-dé dꞌadɨ ꞌtɔ́ Jeju njim-njim dꞌɔw siə dꞌilə-é ji Pilatɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Beɓa Pilatɨ dəjɨ-é panè: «Se i ya ɓá ꞌto ngar lə jipɨ-je lé wa?» Jeju ilə-é-tɨ panè: «Ta ya tḛḛ ta-i-tɨ tin.» ");
INSERT INTO mge_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Njékun dɔ njégugné-je lə Lubə ꞌtilə ta-je n̰a̰ dɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatɨ təl dəjɨ-é panè: «ꞌA kilə-dé ta-tɨ kinlé al wa? ꞌOo kɔr ta-je kɨ́ ꞌtilə dɔ-i-tɨ kinlé ya al wa?» ");
INSERT INTO mge_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngà Jeju tḛḛ ta-é kɨ́ ngarara ya kàrè ilə-tɨ al sar adɨ ɔr ndil Pilatɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kaglo ra na̰y Pakɨ-je lay ya, Pilatɨ à kilə dangay káre taá ə à to ḛ kɨ́ kosɨ dow-je ya dꞌɔsɨ kagɨ dɔ-é-tɨ ɓá à kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ə dingəm káre kɨ́ ri-é lə Barabasɨ kɨ́ to kɨ́ káre dan bɔkaya-je-tɨ kɨ́ ndɔkɨ ꞌtɔl dow ndɔ ra wɔngɨ-tɨ a̰ dangay-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kosɨ dow-je dꞌɔw panata lə Pilatɨ ꞌdəjɨ-é kadɨ ra né kɨ́ ḛ ra adɨ-dé kɨ̀ dɔ ɓal-ɓal kinlé. ");
INSERT INTO mge_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatɨ ilə-dé-tɨ panè: «ꞌNdigi kadɨ mꞌilə ngar lə jipɨ-je taá mꞌadɨ-si wa?» ");
INSERT INTO mge_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kdɔ ḛ gə kɨ́ njékun dɔ njégugné-je lə Lubə dꞌilə Jeju ji-nꞌḛ̀-tɨ kdɔ kim kɨ́ dꞌim-é. ");
INSERT INTO mge_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Njékun dɔ njégugné-je lé, ꞌsulə kosɨ dow-je kadɨ ꞌdəjɨ Pilatɨ kadɨ Barabasɨ ɓá ilə-é taá. ");
INSERT INTO mge_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatɨ təl dəjɨ-dé ɓəy panè: «Ngà ꞌndigi kadɨ mꞌra ri kɨ̀ ḛ kɨ́ sə̰i ꞌɓai-é ngar lə jipɨ-je lé wa?» ");
INSERT INTO mge_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dḛ ꞌpa ta kɨ̀ ndi-dé kɨ́ boy-boy ꞌpanè: «ꞌƁə-é kagdəsɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatɨ idə-dé panè: «Ə to majal ri ya ɓá Jeju lé ra wa?» Rəmə ꞌtəl ꞌpa ta kɨ̀ ndi-dé kɨ́ boy itə kɨ́ kete lé ya ɓəy ꞌpanè: «ꞌƁə-é kagdəsɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatɨ ndigɨ kadɨ rɔ kosɨ dow-je nəl-dé, beɓa ilə Barabasɨ taá, rəmə adɨ ꞌtində Jeju kɨ̀ ndəy marɔw ɓá in̰ə-é ji-dé-tɨ kadɨ dꞌɔw ꞌɓə-é kagdəsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asgar-je dꞌɔw kɨ̀ Jeju panata lə Gubərnər, rəmə ꞌɓa kosɨ asgar-je lay. ");
INSERT INTO mge_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dꞌulə kubɨ kɨ́ kər yə̀l-yə̀l kɨ́ là-é n̰a̰ rɔ-é-tɨ, ꞌra kun dꞌojɨ jɔgɨ ngar-tɨ dꞌulə dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rəmə ꞌtəl ꞌra-é lapiya ꞌpanè: «Lapiya ɓoo ngar lə jipɨ-je.» ");
INSERT INTO mge_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ꞌTində dɔ-é kɨ̀ tuwətɔ́gɨ, ꞌtubə yoro kəm-é-tɨ rəm, ꞌtɔsɨ məkəjɨ-dé nangɨ ɓá ꞌsəbɨ takəm-dé nangɨ nɔ̰̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lokɨ ꞌsɔkɨ-é asɨ-dé rəmə, dꞌɔr kubɨ kɨ́ kər lé rɔ-é-tɨ ə dꞌulə kubɨ-je liə rɔ-é-tɨ gogɨ, ɓəy ɓá ꞌtḛḛ siə ndaa-tɨ gidɨ ɓe-tɨ kdɔ ɓə-é kagdəsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Asgar-je dꞌində tɔ́gɨ dɔ dingəm-tɨ káre kɨ́ ri-é lə Simɔ̰ dꞌadɨ-é utɨ kagdəsɨ lə Jeju. Dingəm kinlé, ḭ ndɔrɔ ə to dow kɨ́ ɓebo Sirḛn-tɨ. Ḛ to bɔbɨ Alegjandrə kɨ̀ Rupusɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dꞌɔw kɨ̀ Jeju lo-tɨ kɨ́ ꞌɓa-é Golgota, kɨ́ kɔr mḛḛ-é to «lo kɨ́ titɨ-na̰ kɨ̀ ka dɔ dow.» ");
INSERT INTO mge_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dꞌadɨ-é man nduu kɨ́ ꞌpote natɨ kɨ̀ né kɨ́ ꞌɓa-é mir kadɨ-é a̰y ɓá ḛ mbatɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Go-tɨ, ꞌɓə Jeju kagdəsɨ-tɨ ə dꞌɔsɨ mbare dɔ kubɨ-je-tɨ liə kdɔ koo se ná̰ ɓá à kingə wa? ");
INSERT INTO mge_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ꞌƁə Jeju kagdəsɨ-tɨ kɨ̀ kàdɨ̀ kɨ́ jinà̰y káre kɨ́ ndɔge. ");
INSERT INTO mge_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ꞌNdàngɨ gin né kɨ́ ꞌgangɨ-né ta dɔ Jeju-tɨ taá ꞌpanè: «Ngar lə Jipɨ-je.» ");
INSERT INTO mge_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ꞌƁə bɔkaya-je joo natɨ kɨ̀ siə dɔ kagdəsɨ-je-tɨ lə-dé; ḛ kɨ́ káre dɔ jikɔl-é-tɨ, kɨ́ káre dɔ jigəl-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bè adɨ ta kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay lé né-é ra né. ꞌNdàngɨ ꞌpanè: «ꞌTidə-é natɨ kɨ̀ njéra majal-je.» ");
INSERT INTO mge_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dow-je kɨ́ njédəə rəbəə-je ꞌtugə dɔ-dé ꞌsɔkɨ-é-né ꞌpanè: «A̰a̰! I kɨ́ ꞌpanè ꞌa tɔɔ kəy lə Lubə ə ndɔ mutə ya ꞌa kində gogɨ lé, ");
INSERT INTO mge_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","i ya ꞌajɨ rɔ-i ə ꞌḭ dɔ kagdəsɨ-tɨ ꞌrisɨ nangɨ adɨ jꞌoo nà̰.» ");
INSERT INTO mge_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je kàrè ꞌpa ta dan-dé-tɨ ꞌsɔkɨ-é-né ꞌpanè: «Dow-je kɨ́ rangɨ ɓá ḛ ajɨ-dé, ngà ḛ asɨ kajɨ rɔ-é al wa! ");
INSERT INTO mge_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ḛ ə́ nè nꞌto Kristɨ, ngar lə Israyel-je lé, kḭ ya kadɨ-é ḭ kagdəsɨ-tɨ kin risɨ nangɨ adɨ jꞌoo ya rəmə jꞌa kadɨ-é mḛḛ-ji ngá!» Dḛ kɨ́ ꞌɓə-dé siə natɨ kagdəsɨ-tɨ lé ꞌtajɨ-é tɔ. ");
INSERT INTO mge_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lokɨ kàdɨ̀ a̰ jam dɔ ɓe-tɨ ya ɓəy rəmə, lo ndul dɔnangɨ-tɨ nè lay sar ya kàdɨ̀ kɨ́ mutə kɨ́ losɔlɔ asɨ-né. ");
INSERT INTO mge_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dɔkàdɨ̀-é-tɨ kinlé, Jeju nɔ̰ kɨ̀ ndi-é kɨ́ boy panè: «Eloy, Eloy, lamasabatani?» Kɔr mḛḛ-é to «Lubə lə-m, Lubə lə-m, kdɔ ri ɓá in̰ə-m kɔgɨ bè wa?» ");
INSERT INTO mge_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dow-je kɨ́ ná̰-je dan dḛ-tɨ kɨ́ dꞌa̰ lo-é-tɨ lé dꞌoo ndi-é ə ꞌpanè: «Ooi! Ḛ ɓa Eli!» ");
INSERT INTO mge_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Beɓa dow káre dan-dé-tɨ a̰y ngɔdɨ ulə ndɔkrɔ dan man nduu-tɨ kɨ́ masɨ, ulə ta tuwətɔ́gɨ-tɨ adɨ Jeju kadɨ njibɨ ə panè: «ꞌNgəbi mɔkɨ! Adɨ jꞌooi se Eli liə lé à ree kɔr-é kur-é nangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jeju nɔ̰ kɨ̀ ndi-é kɨ́ boy rəmə uwə ta-é natɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kubɨ gangɨ mḛḛ kəy lə Lubə, ḭ taá ya til ree njal nangɨ. ");
INSERT INTO mge_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Njèkun dɔ asgar-je kɨ́ ɓu kɨ́ a̰ lo-é-tɨ ɓá oo koy kɨ́ Jeju oy lé bè rəmə panè: «Dingəm kinlé to Ngon lə Lubə ya tɔgrɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dené-je madɨ dꞌa̰ ngərəngɨ dꞌa̰ dꞌoo né-je lé tɔ. Mari kɨ́ Magdala, kɨ̀ Mari kɨ́ kɔ̰ Jojɛsɨ-je kɨ̀ Jakɨ kɨ́ to ngon kɨ́ basa rəm, ɓá Salome dꞌa̰ dan dené-é-je-tɨ lé tɔ. ");
INSERT INTO mge_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dené-je kinlé dꞌun go-é ꞌra kullə dꞌadɨ-é lokɨ isɨ-né Galile-tɨ. Dené-je kɨ́ rangɨ n̰a̰ ya kɨ́ ꞌree siə natɨ Jorijalḛm dꞌa̰ dan-dé-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta kàdɨ̀ kur-tɨ kete nɔ̰̀ ndɔ taakoo-tɨ lə jipɨ-je kɨ́ to ndɔ ra go né-je kdɔ ndɔ taakoo lé, ");
INSERT INTO mge_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jojepɨ kɨ́ to dow kɨ́ mḛḛ ɓebo-tɨ kɨ́ Arimate ree; ḛ to kɨ́ káre dan kɨ́ boy-je-tɨ kɨ́ njégangta-je lə jipɨ-je kɨ́ ri-é ɓa n̰a̰. Ḛ kàrè to dow kɨ́ isɨ ngəbɨ kɔ̰ɓe lə Lubə tɔ. Beɓa ḛ uwə mḛḛ-é nga̰ ya ɔw rɔ Gubərnər Pilatɨ-tɨ dəjɨ-é nin Jeju. ");
INSERT INTO mge_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ta igɨ Pilatɨ səl kdɔ koy kɨ́ Jeju oy ngá. Beɓa ḛ ɓa njèkun dɔ asgar-je dəjɨ-é panè se Jeju lé oy mbɔr nṵ wa? ");
INSERT INTO mge_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lokɨ oo ta lə njèkun dɔ asgar-je lé, ḛ adɨ tarəbɨ Jojepɨ kadɨ ɔw un nin Jeju lé. ");
INSERT INTO mge_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Beɓa Jojepɨ ndogɨ takubɨ, ɔr nin Jeju kagdəsɨ-tɨ, ɓɨr-é-né ə ilə-é ɓe nin-tɨ, bole mbal-tɨ kɨ́ ꞌtɔl sigɨ. Ə nduburu ər kɨ́ boy ya utɨ-né ta-é. ");
INSERT INTO mge_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari kɨ́ Magdala kɨ̀ Mari kɨ́ kɔ̰ Jojɛsɨ dꞌoo lo kɨ́ dꞌilə nin Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lokɨ ndɔ taakoo lə jipɨ-je dəə lé, Mari kɨ́ Magdala, kɨ̀ Salome rəm, ɓá Mari kɨ́ kɔ̰ Jakɨ ꞌndogɨ ubɨ-je kɨ́ ətɨ majɨ-majɨ kadɨ dꞌɔw ꞌndəm nin Jeju. ");
INSERT INTO mge_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Beɓa ndɔ Dimasɨ kɨ́ ndɔge ratɨ, kɨ́ kàdɨ̀ ubə al ɓəy ya dḛ dꞌɔw dɔɓadɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ꞌDəjɨ-na̰ ꞌpanè: «Ná̰ ɓá à nduburu ndəngrə ər kin kɨ rangɨ ta ɓadɨ-tɨ kadɨ-ji ə́n wa?» ");
INSERT INTO mge_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngà lokɨ dꞌun kəm-dé taá rəmə dꞌoo kɨ́ ndəngrə ər lé tokɨ nduburu kilə rangɨ ngá. ");
INSERT INTO mge_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lokɨ dꞌandɨ ɓe nin-tɨ lé rəmə, dꞌoo basa káre kɨ́ ulə kubɨ kɨ́ ngal kɨ́ nda isɨ kɨ dɔ jikɔl. Lokɨ dꞌoo-é lé, ꞌɓəl n̰a̰. ");
INSERT INTO mge_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Beɓa basa lé idə-dé panè: «ꞌƁəli al, sə̰i lé, Jeju kɨ́ Najarɛtɨ-tɨ kɨ́ ꞌɓə-é kagdəsɨ-tɨ lé ɓá sə̰i ꞌsangi-é; ḛ tɔsɨ ndəl ində lo tḛḛ, adɨ goto nè; ooi, lo kɨ́ dꞌilə-é-tɨ ə́n. ");
INSERT INTO mge_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ɔwi idəi njéndó né-je liə, ə idəi Piyər tɔ kɨ́ ḛ à ngəbɨ-si Galile-tɨ. Lo kin ɓá a kooi-é-tɨ, titɨ kɨ́ ḛ idə-si-né kete lé.» ");
INSERT INTO mge_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Beɓa dḛ ꞌɓəl rəm, ꞌdadɨ rəm adɨ ꞌtḛḛ ɓe nin-tɨ lé kɨ́ ngɔdɨ dꞌa̰y-na̰. Lo kadɨ ꞌpa ta-é dꞌadɨ dow goto kdɔtalə ɓəl ində mḛḛ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jeju tɔsɨ ndəl ində lo tḛḛ kɨ̀ ndɔ Dimasɨ kɨ̀ ndɔge ratɨ. Ḛ tɔjɨ rɔ-é Mari kɨ́ Magdala kɨ́ ndɔkɨ ḛ tubə ndil-je kɨ́ majɨ al siri dɔ-é-tɨ lé ya kete. ");
INSERT INTO mge_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari ɔw ɔr poy-é adɨ njéndó né-je kɨ́ dꞌisɨ dan mḛḛkɔ̰̀-tɨ dꞌisɨ ꞌnɔ̰. ");
INSERT INTO mge_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngà lokɨ idə-dé panè Jeju isɨ kəm, adɨ nꞌoo-é kɨ̀ kəm-nꞌḛ̀ ya kàrè, dḛ dꞌoo ta liə kɨ ta kɨ́ tɔgrɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Go-tɨ, Jeju tɔjɨ rɔ-é kɨ̀ rɔ kɨ́ mbəl rɔ njéndó né-je-tɨ liə kɨ́ joo kɨ́ dꞌisɨ dꞌɔw kɨ ngonɓe-tɨ kɨ́ wale. ");
INSERT INTO mge_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dḛ ꞌtəl ꞌree dꞌɔr poy-é dꞌadɨ ndəgɨ-é-je, bè ya kàrè dꞌadɨ-dé mḛḛ-dé al. ");
INSERT INTO mge_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Go-tɨ, Jeju tɔjɨ rɔ-é njéndó né-je liə kɨ́ dɔgɨ gidɨ-é káre kɨ́ dꞌisɨ ta nékuso-tɨ; ḛ kɔl sə-dé kdɔ mḛḛnga̰ kɨ̀ mḛḛndə lə-dé kɨ́ ɔgɨ-dé kadɨ dꞌadɨ mḛḛ-dé dḛ kɨ́ dꞌoo-é kɨ́ tɔsɨ ndəl ində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ḛ idə-dé panè: «Ɔwi kɨ̀ lo lay dɔnangɨ-tɨ nè, iləi mbḛ Poyta kɨ́ Majɨ lə-m adi dow-je lay. ");
INSERT INTO mge_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dow kɨ́ adɨ-m mḛḛ-é ə́ ꞌrai-é batḛm lé à kajɨ; ngà dow kɨ́ adɨ mḛḛ-é al lé, ta kɨ́ gangɨ à kusɨ dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nékɔjɨ-je kɨ́ à tɔjɨ kadɨ ꞌgə-né dḛ kɨ́ dꞌadɨ-m mḛḛ-dé ɓan: Dꞌa tubə ndil-je kɨ́ majɨ al kɨ̀ ri-m, dꞌa pa ta kɨ̀ ndɔ̰ ta-je kɨ́ sigɨ, ");
INSERT INTO mge_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","dꞌa kuwə li-je kɨ̀ ji-dé rəm, lé dꞌa̰y man kɨ́ né kɨ́ à tɔl dow tò-tɨ ya kàrè à ra sə-dé né al; dꞌa kində ji-dé dɔ njémɔ̰y-je-tɨ ə njémɔ̰y-je dꞌa kingə lapiya.» ");
INSERT INTO mge_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Go ta-je-tɨ kɨ́ ꞌƁaɓe Jeju pa sə-dé lé, Lubə un-é ɔw siə dɔra̰-tɨ adɨ isɨ dɔ jikɔl-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Njéndó né-je dꞌɔw dꞌilə mbḛ Poyta kɨ́ Majɨ kɨ̀ lo-je lay. ꞌƁaɓe ra sə-dé kullə rəm, ɓá ra nékɔjɨ-je n̰a̰ ya dan-né go Poyta kɨ́ Majɨ kɨ́ dḛ ꞌpa lé tɔjɨ-né kadɨ to ta kɨ́ tɔgrɔ-tɨ.");
INSERT INTO mge_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dow-je n̰a̰ ya dꞌadɨ rɔ-dé ꞌndàngɨ né-je kɨ́ ra né dan-ji-tɨ nè lé, ");
INSERT INTO mge_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ə ꞌndàngɨ kɨ̀ gangɨ-é kɨ́ jꞌoo-né ta njéka̰ lo-é-tɨ lo kulə gin-é-tɨ nṵ ɓá ꞌtəl ngannjékullə-je kɨ́ njékilə mbḛ ta lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Beɓa lokɨ mꞌdəjɨ ta dɔ né-je-tɨ kin lay kɨ̀ gangɨ-é berere-berere lo kulə gin-é-tɨ nṵ ya lé, ma̰ kàrè nəl-m kadɨ mꞌndàngɨ kɨ̀ go-é go-é ya mꞌadɨ-i i Teopil kɨ́ ꞌto dow kɨ́ boy n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mꞌndàngɨ mꞌadɨ-i bè, kdɔ kadɨ ꞌgə majɨ kɨ́ néndó-je kɨ́ ꞌingə kinlé, to néndó-je kɨ́ tɔgrɔ-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ɓal-je-tɨ kɨ́ Erodɨ to-né ngar dɔnangɨ Jude-tɨ lé, njègugné lə Lubə káre isɨ nɔ̰ɔ̰, ri-é lə Jakari. Ḛ to dow kɨ́ dan kutɨ dow-je-tɨ lə Abiya kɨ́ ndɔkɨ to njègugɨ né ə ne-é to kɨ́ gin ka-tɨ lə Arɔ̰ tɔ. Ne-é lé ri-é lə Elijabɛtɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dḛ joo lay ya ꞌto dow-je kɨ́ njéra né kɨ́ njururu nɔ̰̀ Lubə-tɨ, ꞌtəl rɔ-dé go ndukun-je-tɨ lə Lubə lay, ɓá ꞌtəl rɔ-dé go tó mindɨ ꞌƁaɓe-tɨ lay rəm, adɨ ta goto dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngà dḛ dꞌojɨ ngon al, kdɔtalə Elijabɛtɨ lé to kujɨ rəm, ɓá dḛ joo lay ya ꞌɓugə n̰a̰ ngá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ndɔ káre bè, Jakari a̰ ra kullə liə kɨ́ tò kadɨ-é ra nɔ̰̀ Lubə-tɨ, kdɔtalə dḛ kɨ̀ kutɨ dow-je liə ɓá to ta ra kullə lə-dé, ");
INSERT INTO mge_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","beɓa kagɨ usɨ dɔ Jakari-tɨ titɨ kɨ́ njégugné-je ꞌra-né low-low, kadɨ ḛ ɓá ɔw mḛḛ kəy-tɨ lə ꞌƁaɓe, kdɔ kadɨ ɔw ró pər nɔ̰kagɨ kɨ́ ətɨ majɨ logugɨ né-tɨ adɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dɔ kàdɨ̀ ró nɔ̰kagɨ-je-tɨ kɨ́ ətɨ majɨ logugɨ né-tɨ lé, kosɨ dow-je lay dꞌa̰ ꞌpa ta kɨ̀ Lubə takəy-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rəmə tajinatɨ nè ya malayka lə ꞌƁaɓe tḛḛ kɨ̀ Jakari kɔy, a̰ taá dɔ kɔ̀l, kəl logugɨ né-tɨ kɨ́ to lo ró nɔ̰kagɨ-je kɨ́ ətɨ majɨ-majɨ lé. ");
INSERT INTO mge_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lokɨ Jakari un kəm-é oo-é lé, dɔ-é təl, ɓəl ində bandɨ-é batɨ gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngà malayka lé idə-é panè: «Jakari, ꞌɓəl al. Kdɔ ta kɨ́ ꞌpa kɨ̀ Lubə lé, Lubə oo, adɨ ne-i Elijabɛtɨ à kojɨ ngon kɨ́ dingəm kadɨ-i ə ꞌa kində ri-é lə Ja̰. ");
INSERT INTO mge_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ngon lé, à to né rɔnəl n̰a̰ kadɨ-i rəm, ɓá dow-je n̰a̰ ya dꞌa ra rɔnəl dɔ kojɨ-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ḛ à to dow kɨ́ boy n̰a̰ takəm ꞌƁaɓe-tɨ. Yibɨ nduu əse né ka̰y kɨ́ əm tò-tɨ ya ḛ à ka̰y al. Mḛḛ kɔ̰-é-tɨ nṵ ya Ndil kɨ́ aa njay à rusɨ mḛḛ-é. ");
INSERT INTO mge_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ḛ à kadɨ Israyel-je n̰a̰ ꞌtəl kɨ rɔ ꞌƁaɓe Lubə-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ḛ à njiyə nɔ̰̀ ꞌƁaɓe-tɨ kɨ̀ tagɨr-je kɨ̀ tɔ́gɨ kɨ́ ndɔkɨ Eli ɔw-né, kdɔ kadɨ adɨ bɔbɨ ngan-je dꞌulə nojɨ natɨ kɨ̀ ngan-dé-je rəm, njémbatɨ təl rɔ-dé go ta-tɨ dꞌɔw kɨ̀ tagɨr kɨ́ titɨ-na̰ kɨ̀ tagɨr lə njéra né kɨ́ njururu-je rəm tɔ. Bè kdɔ kadɨ dow-je ꞌra rɔ-dé ə dꞌisɨ dɔ nja-dé-tɨ kdɔ ra kullə lə ꞌƁaɓe.» ");
INSERT INTO mge_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari dəjɨ malayka lé panè: «Ri ɓá à tɔjɨ-m kadɨ mꞌgə kɨ́ né kinlé à ra né wa? Kdɔtalə ma̰ mꞌɓugə rəm, ɓá ne-m kàrè ɓal-é n̰a̰ ngá rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malayka lé ilə-é-tɨ panè: «Ma̰ lé, ri-m lə Gabriyel, njèka̰ takəm Lubə-tɨ. Lubə ulə-m kadɨ mꞌree mꞌpa sə-i ta rəm, kadɨ mꞌilə Poyta kɨ́ Majɨ kin mbi-i-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yən, ꞌa kisɨ bè ya, ꞌa kasɨ pa ta al ya sar kadɨ né kɨ́ mꞌpa ta-é kinlé, né-é ra-né né. Kdɔtalə ta-je lə-m kɨ́ mꞌpa kɨ́ to ta-je kɨ́ ndɔ-é asɨ ə né-é à ra né lé, i ꞌoo kɨ ta kɨ́ tɔgrɔ-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gangɨ lo-é-tɨ kinlé, dow-je dꞌa̰ ꞌngəbɨ Jakari ə lo ta igɨ-dé sə́l, kdɔtalə ka̰ kɨ́ ḛ a̰ mḛḛ kəy-tɨ lə Lubə ɓəy ə ɓəy-ɓəy kinlé. ");
INSERT INTO mge_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lokɨ Jakari tḛḛ ndaa-tɨ ngá lé, ḛ asɨ pa sə-dé ta al, ya rəmə dḛ ꞌgə kɨ́ né ra-é tokɨ nḭ bè mḛḛ kəy-tɨ lə Lubə. Ḛ ɔy ji-é ra ta-dé-tɨ pa-né sə-dé ta ə pa ta al bin ya ngá. ");
INSERT INTO mge_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Beɓa lokɨ ndɔ kullə liə tingə ngá lé, Jakari təl ɔw ɓe liə gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Go-tɨ, ne-é Elijabɛtɨ ndan ngon ə ɓɔyɔ rɔ-é kəy ya na̰y mḭ ə ḛ panè: ");
INSERT INTO mge_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Yən, ḛ kin ɓá to né kɨ́ majɨ kɨ́ ꞌƁaɓe ra adɨ-m dɔkaglo-tɨ kɨ́ nè kin, kdɔ kɔr-né rɔsɔl dɔ-m-tɨ takəm dow-je-tɨ!» ");
INSERT INTO mge_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na̰y mɛkḛ go-tɨ lé, Lubə ulə malayka kɨ́ ri-é lə Gabriyel dɔnangɨ Galile-tɨ mḛḛ ɓebo-tɨ káre kɨ́ ꞌɓa-é Najarɛtɨ, ");
INSERT INTO mge_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kadɨ ɔw rɔ ngon mandɨ-tɨ kɨ́ gə dingəm al ɓəy kɨ́ dingəm kɨ́ ri-é lə Jojepɨ kɨ́ to ngon kà Dabidɨ uwə dɔ-é. Ngon mandɨ lé ri-é lə Mari. ");
INSERT INTO mge_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malayka lé ree ɔw kəy go-é-tɨ ə pa siə ta panè: Mꞌra-i lapiya, i kɨ́ Lubə ra sə-i majɨ! ꞌƁaɓe nà̰y sə-i! ");
INSERT INTO mge_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta kinlé təl dɔ Mari adɨ ḛ dəjɨ rɔ-é ta panè sé kin to lapiya kɨ́ ban ɓá tana̰ bè wa? ");
INSERT INTO mge_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malayka lé idə-é panè: Mari, ꞌɓəl al! Kdɔtalə Lubə ra sə-i majɨ! ");
INSERT INTO mge_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ꞌOo bè, ꞌa ndan ngon, ꞌa kojɨ ngon kɨ́ dingəm, ə ꞌa kində ri-é lə Jeju. ");
INSERT INTO mge_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ḛ à to dow kɨ́ boy ə dꞌa ɓa-é Ngon lə Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ ə ꞌƁaɓe Lubə à kadɨ-é isɨ dɔ kalikɔɓe-tɨ lə ka-é Dabidɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ḛ à kɔ̰ɓe dɔ gin kojɨ-tɨ lə Jakobɨ ya sartagangɨ; tɔgrɔ-tɨ, kɔ̰ɓe liə lé sɔ̰y-é à goto. ");
INSERT INTO mge_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Beɓa Mari idə malayka lé panè: Ma̰ mꞌgə dingəm al ɓəy, ngà né kin à ra né ban ɓan wa? ");
INSERT INTO mge_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malayka lé təl ilə-é-tɨ panè: Ndil kɨ́ aa njay à ree dɔ-i-tɨ rəm, tɔ́gɨ Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ à gəə dɔ-i sipɨ rəm tɔ. Gin-é kin ɓá ngon kɨ́ ꞌa kojɨ-é lé à to dow kɨ́ aa njay ə dꞌa ɓa-é Ngon lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yən, nojɨ-i Elijabɛtɨ kàrè ndan ngon tɔ. Ḛ ndan ngon dɔ ɓugə-é-tɨ ə à kojɨ ngon kɨ́ dingəm. Ḛ kɨ́ ndɔkɨ ꞌɓa-é kujɨ dené lé, ndan ngon ra na̰y mɛkḛ ngá. ");
INSERT INTO mge_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kdɔtalə né kɨ́ dum Lubə ya goto. ");
INSERT INTO mge_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Beɓa Mari panè: Ma̰ mꞌto ngonnjèkullə lə ꞌƁaɓe! Kadɨ-é ra sə-m kɨ́ go ta-tɨ kɨ́ i ꞌpa lé ya. Rəmə malayka lé in̰ə Mari ə ɔw. ");
INSERT INTO mge_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mḛḛ ndɔ-é-je-tɨ kinlé ya Mari ḭ usɨ rəbəə ɔw lɔw ɓebo-tɨ káre kɨ́ dan mbal-je-tɨ dɔnangɨ Jude-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lokɨ ɔw tḛḛ lé, ḛ ɔw mḛḛ kəy-tɨ lə Jakari ə ra lapiya Elijabɛtɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Beɓa lokɨ Elijabɛtɨ oo lapiya kɨ́ Mari ra-é lé taá ya, ngon kɨ́ mḛḛ-é-tɨ lé rɔ-é nəl-é adɨ tɔsɨ mḛḛ-é gul-gul ə Ndil kɨ́ aa njay rusɨ mḛḛ Elijabɛtɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elijabɛtɨ pa ta kɨ̀ ndi-é kɨ́ boy panè: Lubə tɔr ndi-é dɔ-i-tɨ dan dené-je-tɨ lay, ngon kɨ́ mḛḛ-i-tɨ kàrè Lubə tɔr ndi-é dɔ-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ə́ ma̰ kin ya mꞌasɨ kadɨ kɔ̰ ꞌƁaɓe lə-m ree ɓe lə-m wa! ");
INSERT INTO mge_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mꞌpa bè kdɔtalə lokɨ lapiya kɨ́ i ꞌra-m lé gangɨ mbi-m-tɨ taá ya rəmə, rɔ ngon kɨ́ mḛḛ-m-tɨ nəl-é adɨ tɔsɨ mḛḛ-m gul-gul. ");
INSERT INTO mge_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","I ꞌto dené kɨ́ njènékumə̰, kdɔtalə i adɨ mḛḛ-i tokɨ né-je lay kɨ́ ꞌƁaɓe idə-i ta-é lé, à ra né ya. ");
INSERT INTO mge_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari panè: Ndil-m ɔsɨ gajɨ ꞌƁaɓe rəm, ");
INSERT INTO mge_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ra rɔnəl dɔ Lubə-tɨ kɨ́ to Njèkajɨ-m, ");
INSERT INTO mge_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kdɔtalə ḛ ilə rətɨ oo-m ma̰ ngonnjèkullə liə kɨ́ dené kɨ́ mꞌasɨ né al, adɨ kḭ nè kɔw kɨ kete kinlé, dow-je lay ya dꞌa ɓa-m njènékumə̰. ");
INSERT INTO mge_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kdɔtalə njètɔ́gɨ-je lay ra né-je kɨ́ boy-boy ya adɨ-m. Ḛ to dow kɨ́ aa njay ");
INSERT INTO mge_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","rəm, koo kəmtondoo liə nà̰y kɨ̀ njéɓəl ndil-é kɨ̀ dɔ ɓal-ɓal ya. ");
INSERT INTO mge_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ḛ ɔjɨ tɔ́gɨ-é; Dow-je kɨ́ dꞌɔw kɨ̀ tagɨr kində kàdɨ̀-dé lé, ḛ sane-dé katɨ-katɨ, ");
INSERT INTO mge_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ꞌboy-je lé, ḛ ɔr-dé kɔgɨ dɔ kalikɔ̰ɓe-je-tɨ lə-dé, dow-je kɨ́ njésɔl dɔ-dé lé, ḛ un-dé kɨ taá, ");
INSERT INTO mge_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","dow-je kɨ́ ɓo ra-dé lé, ḛ adɨ-dé nékingə-je mburukɨ-mburukɨ, ngà njénékingə-je rəmə, ḛ tubə-dé adɨ dꞌɔw kɨ̀ ji-dé kɨ́ dɔgɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mḛḛ-é ole dɔ ta-tɨ kɨ́ ndɔkɨ ḛ pa adɨ ka-ji-je panè, nꞌa koo kəmtondoo lə Abrakam kɨ̀ nganka-é-je ya sartagangɨ lé, beɓa ḛ ra kɨ̀ gin dow-je kɨ́ ꞌto Israyel-je kɨ́ ꞌto ngannjékullə-je liə. ");
INSERT INTO mge_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari isɨ rɔ Elijabɛtɨ-tɨ nɔ̰ɔ̰ ya à kasɨ na̰y mutə je bè ɓá təl ɔw ɓe liə gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lokɨ ndɔ kojɨ ngon lə Elijabɛtɨ asɨ lé, ḛ ojɨ ngon kɨ́ dingəm. ");
INSERT INTO mge_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Njétakəy-je lə Elijabɛtɨ kɨ̀ nojɨ-é-je dꞌoo poy koo kɨ́ ꞌƁaɓe oo kəmtondoo liə lé, dḛ ꞌra rɔnəl siə. ");
INSERT INTO mge_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ndɔ jinà̰y joo go-tɨ lé, dḛ ꞌree kadɨ dꞌijə ngon lé ganjangɨ ə ndigɨ ꞌɓa-é Jakari kɨ́ to ri bɔbɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ngà kɔ̰-é un ta panè: Á̰-à̰! Dꞌa ɓa-é Ja̰. ");
INSERT INTO mge_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rəmə dḛ ꞌtəl ꞌpa siə ꞌpanè: Dow kɨ́ dan nojɨ-i-je-tɨ kɨ́ ri-é tana̰ bè ya goto. ");
INSERT INTO mge_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Go-tɨ, ꞌra ji-dé ꞌdəjɨ-né Jakari sé ḛ ndigɨ kadɨ ꞌɓa ngon lé ná̰ wa? ");
INSERT INTO mge_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Beɓa Jakari dəjɨ-dé bəgrə ə ndàngɨ né-tɨ panè: Ri-é lə Ja̰. Rəmə dḛ lay ya ndil-dé tḛḛ sa̰y. ");
INSERT INTO mge_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tajinatɨ nè ya ta Jakari tḛḛ ə ndɔ̰-é ɗɨrə́ bə̀rə̀rə̀, adɨ pa ta ɔsɨ-né gajɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dow-je lay kɨ́ go lo-tɨ kɨ́ tin kinlé, ɓəl ində bandɨ-dé gangɨ rəm, ɓá dḛ kɨ́ dꞌisɨ dan mbal-je-tɨ lay kɨ́ dɔnangɨ Jude-tɨ kàrè, dꞌɔr-na̰ poy né-je lay kɨ́ ra né kinlé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dḛ lay kɨ́ ta-je kin usɨ mbi-dé-tɨ lé, ꞌgɨr dɔ-tɨ ə ꞌpanè: Ngon kinlé à to dow kɨ́ ban-ban ə́n ə! Kdɔtalə tɔ́gɨ ꞌƁaɓe nà̰y siə. ");
INSERT INTO mge_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndil kɨ́ aa njay rusɨ mḛḛ bɔbɨ-é Jakari, adɨ pa ta kɨ́ ta Lubə-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kɔsgajɨ kɨ́ dɔ ꞌƁaɓe Lubə-tɨ lə Israyel-je, kdɔtalə kilə kɨ́ ilə kəm-é gɔ̰ dow-je liə rəm, taa kɨ́ ḛ taa-dé ilə-dé taá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dan nganka Dabidɨ-tɨ kɨ́ to ngonnjèkullə liə lé, ꞌƁaɓe adɨ njètɔ́gɨ kɨ́ njètaa-ji kilə-ji taá tḛḛ kdɔ ta lə-ji. ");
INSERT INTO mge_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ḛ adɨ njètaa-ji kilə-ji taá tḛḛ titɨ kɨ́ ḛ adɨ njépata-je kɨ́ ta-é-tɨ kɨ́ ꞌto dow-je kɨ́ dꞌaa njay ꞌpa-né kete low nṵ ");
INSERT INTO mge_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ꞌpanè: Nꞌa taa-ji kilə-ji taá ji njéba-je-tɨ lə-ji, ɓá nꞌa kɔr-ji kɔgɨ gin tɔ́gɨ-tɨ lə dow-je kɨ́ njékɔsɨ-ji kɨ̀ ta rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Beɓa ḛ oo kəmtondoo lə ka-ji-je ə mḛḛ-é ole dɔ nojɨ-tɨ kɨ́ aa njay kɨ́ ḛ ulə natɨ sə-dé, ");
INSERT INTO mge_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","titɨ kɨ́ ndɔkɨ ubɨ-né rɔ-é adɨ ka-ji Abrakam panè: ");
INSERT INTO mge_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Mꞌa taa-si ji njéba-je-tɨ lə-si kilə-si taá, mꞌa kadɨ a̰i takəm-m-tɨ ꞌpoli-mi kɨ̀ rɔ-si kɨ́ aa njay, a rai né kɨ́ njururu kɨ̀ ndɔ-je lay kɨ́ a kisi-né kɨ̀ dɔ-si taá nal ɓəl né madɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ə i ngon kɨ́ bər kinlé, dꞌa ɓa-i njèpata kɨ́ ta Lubə-tɨ kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ. Kdɔtalə i a njiyə kete nɔ̰̀ ꞌƁaɓe-tɨ kdɔ ra rəbɨ-je liə rəm, ");
INSERT INTO mge_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kdɔ kadɨ adɨ kəm dow-je liə ijə dɔ kajɨ-tɨ kɨ́ Lubə à kajɨ-dé, kɨ̀ takul kin̰ə kɨ́ à kin̰ə go majal-je lə-dé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kdɔtalə Lubə lə-ji lé to njèkoo kəmtondoo kɨ́ n̰a̰. Koo kəmtondoo liə lé, ɓá adɨ kàdɨ̀ ubə-né taá kdɔ ta lə-ji, ");
INSERT INTO mge_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kdɔ kadɨ ndógɨ dɔ dow-je-tɨ kɨ́ dꞌisɨ lo kɨ́ ndul-tɨ kɨ́ dꞌisɨ ꞌɓəl koy rəm, ɓá kdɔ kadɨ ɔr nɔ̰̀-ji adɨ jꞌisi kɨ̀ lapiya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngà ngon lé, tɔgɨ, ɓá Ndil kɨ́ aa njay adɨ gosɨ liə usɨ dɔ madɨ-é-tɨ rəm tɔ. Ḛ isɨ diləlo-tɨ ya sar ndɔ-tɨ kɨ́ ḛ tḛḛ tɔjɨ-né rɔ-é adɨ Israyel-je ꞌgə-é-né. ");
INSERT INTO mge_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dɔgangɨ ɓal-tɨ kɨ́ dꞌojɨ-né Ja̰ lé, Sejar Ogustɨ kɨ́ to ngar kɨ́ boy un ndu kadɨ dow-je lay kɨ́ mḛḛ ɓekɔ̰-je-tɨ liə dꞌində ri-dé mḛḛ mbete tidə kɔr dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kində ri mḛḛ mbete tidə kɔr dow-je-tɨ kinlé, ḛ ya to kɨ́ dɔsa̰y sakɨ-sakɨ lokɨ Kiriniyusɨ to-né Gubərnər kɨ́ dɔnangɨ Siri-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Beɓa ná̰-ná̰ ya kàrè ɔw ɓebo-tɨ liə kdɔ kadɨ dꞌində ri-é. ");
INSERT INTO mge_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Gangɨ-é-tɨ kin ɓá Jojepɨ kàrè ḭ ɓebo Najarɛtɨ dɔnangɨ Galile-tɨ, ɔw dɔnangɨ Jude-tɨ mḛḛ ɓebo Bɛtlekɛm-tɨ, kɨ́ to ɓekojɨ Dabidɨ, kdɔtalə ḛ to dow kɨ́ gin kojɨ-tɨ lə Dabidɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jojepɨ kɨ̀ Mari kɨ́ ḛ uwə dɔ-é ya ə́ ndan ngon lé, dꞌɔw kdɔ kadɨ dꞌində ri-dé mḛḛ mbete tidə kɔr dow-je-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lokɨ ꞌnà̰y mḛḛ ɓebo Bɛtlekɛm-tɨ lé ya ɓəy rəmə, ndɔ kojɨ ngon lə Mari asɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mari ojɨ ngon kɨ́ dingəm kɨ́ to ngon dɔdər-é ə ɓɨr-é kɨ̀ kubɨ, ilə-é mḛḛ bəgrə kuso né-tɨ lə da̰-je, kdɔtalə lo tò goto kəymba-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Njénékul-je kàrè dꞌisɨ dɔgore lo-tɨ kɨ́ káre kinlé nɔ̰ɔ̰, ꞌto ɓi ndɔɔ al, dꞌisɨ ꞌngəm nékul-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Rəmə, malayka lə ꞌƁaɓe tḛḛ dɔ-dé-tɨ busɨ ə ꞌƁaɓe ra adɨ lo ndógɨ dɔ-dé-tɨ doo adɨ ɓəl ində bandɨ-dé batɨ gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngà malayka lé idə-dé panè: ꞌƁəli al, kdɔtalə mꞌree kɨ̀ Poyta kɨ́ Majɨ kdɔ kilə mbi-si-tɨ. To Poyta kɨ́ à kadɨ dow-je lay rɔnəl n̰a̰. Poyta lé ɓan: ");
INSERT INTO mge_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɓone, mḛḛ ɓebo-tɨ lə Dabidɨ, dꞌojɨ Njèkajɨ dow-je dꞌadɨ-si, adɨ to Kristɨ, kɨ́ to ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ooi bè, né kɨ́ à tɔjɨ kadɨ ꞌgəi-né ə́n: A kooi ngon kɨ́ bər, kɨ́ ꞌɓɨr-é kɨ̀ kubɨ, dꞌilə-é mḛḛ bəgrə kuso né-tɨ lə da̰-je. ");
INSERT INTO mge_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lokɨ idə-dé ta kinlé bè ya rəmə, tajinatɨ nè ya kosɨ malayka-je kɨ́ ꞌto njérɔ-je kɨ́ dɔra̰-tɨ kɨ́ ꞌtò nduy-nduy dꞌində ndi-dé natɨ kɨ́ malayka lé, ꞌtɔ́y Lubə ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kɔsgajɨ kɨ́ dɔ Lubə-tɨ mḛḛ lo-je-tɨ kɨ́ taá nṵ ə lapiya tò dɔnangɨ-tɨ dɔ dow-je-tɨ kɨ́ Lubə ndigɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lokɨ malayka-je dꞌin̰ə njénékul-je, ꞌtəl dꞌɔw dɔra̰-tɨ gogɨ lé, njénékul-je dꞌɔjɨ-na̰ ta ꞌpanè: Adɨ jꞌɔwi njal Bɛtlekɛm, jꞌooi né kɨ́ ra né ɓá ꞌƁaɓe tḛḛ kɨ̀ dɔ-é adɨ jꞌgəi kin. ");
INSERT INTO mge_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dḛ dꞌɔtɨ kɨ̀ nja ngɔdɨ-é ya dꞌɔw ə dꞌingə Jojepɨ-je kɨ̀ Mari, kɨ̀ ngon kɨ́ bər kɨ́ dꞌilə-é mḛḛ nékuso né-tɨ lə da̰-je lé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lokɨ njénékul-je dꞌoo ngon kɨ́ bər lé rəmə, dḛ dꞌɔr poyta kɨ́ malayka lə ꞌƁaɓe idə-dé sɔbɨ dɔ ngon kinlé. ");
INSERT INTO mge_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Poy ta kɨ́ njénékul-je dꞌɔr lé, ɔr ndil dow-je lay kɨ́ dꞌoo. ");
INSERT INTO mge_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngà Mari rəmə, ḛ ngəm ta-je kin lay mḛḛ-é-tɨ ə lajɨ dɔ-tɨ taá-taá. ");
INSERT INTO mge_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lokɨ njénékul-je dꞌisɨ ꞌtəl kɨ gogɨ lé, dḛ ꞌtɔ́y Lubə rəm, ɓá dꞌɔsɨ gajɨ-é taá-taá, kdɔtalə né-je lay kɨ́ dꞌoo ta-é kɨ̀ mbi-dé rəm, dꞌoo kɨ̀ kəm-dé lé, ɔw natɨ berere-berere kɨ̀ ta kɨ́ malayka idə-dé lé ya. ");
INSERT INTO mge_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lokɨ ngon ra ndɔ jinà̰y joo lé, dꞌijə-é ganjangɨ ə dꞌində ri-é lə Jeju kɨ́ to ri kɨ́ malayka idə-dé kete lokɨ ꞌndan-é-né al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lokɨ ndɔ kɨ́ kadɨ dꞌaa rɔ-dé njay kɨ́ go ndukun-tɨ lə Moiyijɨ asɨ lé, Jojepɨ-je kɨ̀ Mari dꞌun ngon lé ꞌree siə mḛḛ ɓebo Jorijalḛm-tɨ kdɔ tɔjɨ-é ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kdɔtalə ꞌndàngɨ mḛḛ mbete ndukun-tɨ lə ꞌƁaɓe ꞌpanè: Ngon dɔdər da̰ kɨ́ to bɔbɨ əse ngon kɨ́ dingəm kɨ́ to dər lé, dꞌa kɔr-é kində-é tagay kadɨ ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Rəm ree-dé ɓebo Jorijalḛm-tɨ lé, ꞌree kdɔ kadɨ kadkare kɨ́ kadɨ tokɨ kilə məsɨ-é nangɨ titɨ kɨ́ ndukun lə ꞌƁaɓe pa-né panè: I a kadɨ dədum-je joo əse ngan dəngɔdnda-je joo. ");
INSERT INTO mge_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dingəm káre bè isɨ ɓebo Jorijalḛm-tɨ nɔ̰ɔ̰ ri-é lə Simiyɔ̰, to dow kɨ́ njèra né kɨ́ njururu rəm, ɓá to njèkilə kujɨ dɔ Lubə-tɨ rəm tɔ. Ḛ isɨ ngəbɨ njèkajɨ Israyel-je; Ndil kɨ́ aa njay isɨ mḛḛ-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ndil kɨ́ aa njay adɨ-é gə kete panè: ꞌA koy al ya sar kadɨ ꞌa koo dow kɨ́ ꞌƁaɓe à kulə siə kɨ́ to Kristɨ lé mɔkɨ tá. ");
INSERT INTO mge_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndil kɨ́ aa njay ɔsɨ Simiyɔ̰ lé adɨ-é ɔw takəy-tɨ lə Lubə, rəmə Jeju kàrè njékojɨ-é-je dꞌun-é dꞌɔw siə takəy-tɨ lə Lubə tɔ; kdɔ kadɨ ꞌra né-je dɔ-é-tɨ kɨ́ go ndukun-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyɔ̰ taa Jeju uwə-é kàdɨ̀-é-tɨ ə ɔsɨ gajɨ Lubə panè: ");
INSERT INTO mge_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Kɨ́ nè kinlé, ꞌƁaɓe, ꞌin̰ə-m ma̰ ngonnjèkullə lə-i adɨ mꞌɔw kɨ̀ lapiya, kdɔ kun mindɨ lə-i lé, né-é ra né ngá. ");
INSERT INTO mge_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kdɔtalə kəm-m oo njèkajɨ dow-je kɨ́ ulə siə lé. ");
INSERT INTO mge_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Njèkajɨ dow-je kɨ́ ꞌuwə dɔ-é kete kdɔ gin dow-je lay. ");
INSERT INTO mge_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ḛ to lo kɨ́ à ndógɨ dɔ gin dow-je-tɨ kɨ́ rangɨ rəm, ɓá ḛ to riɓa lə gin dow-je lə-i kɨ́ ꞌto israyel-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta-je kɨ́ Simiyɔ̰ pa dɔ Jeju-tɨ lé, ɔr ndil njékojɨ-é-je. ");
INSERT INTO mge_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyɔ̰ tɔr ndi-é dɔ-dé-tɨ ə idə Mari kɨ́ kɔ̰ Jeju panè: ꞌOo majɨ, ngon kinlé, Lubə mbətɨ-é kadɨ to gin kusɨ lə Israyel-je n̰a̰ rəm, gin kḭ taá lə Israyel-je n̰a̰ rəm, ḛ à to nékɔjɨ lə Lubə kɨ́ ta dow-je à kasɨ-na̰ dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bè kdɔ kadɨ kujə tagɨr kɨ́ ɓɔyɔ rɔ-é mḛḛ dow-je-tɨ n̰a̰. Ngà i rəmə, né kɨ́ to à ta̰a̰ ɓəngrə-i, titɨ kɨ́ kiyərɔ mbutɨ-né ɓəngrə dow kin bè. ");
INSERT INTO mge_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Dené káre kɨ́ to njèpata kɨ́ ta Lubə-tɨ isɨ nɔ̰ɔ̰ tɔ; ri-é lə An. Ḛ to ngon lə Panuwɛl, gin kojɨ-tɨ lə Ajɛr. To dené kɨ́ ɓugə gurə́-gurə́ ngá. Taa ngɔw mandɨ-é-tɨ ra ɓal siri-rè ɓəy ya ngɔbɨ-é oy, ");
INSERT INTO mge_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","adɨ ḛ təl dené kɨ́ njèngɔwkoy; ɓal-é ra kɔrjinà̰y joo gidɨ-é sɔ. An lé, in̰ə takəy lə Lubə al; ḛ pole Lubə ndɔɔ rəm, kada rəm; ḛ ɔgɨ rɔ-é nékuso kɨ̀ man ka̰y taá-taá, pa ta kɨ̀ Lubə tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dɔkàdɨ̀-é-tɨ kɨ́ dꞌɔw-né kɨ̀ Jeju takəy-tɨ lə Lubə lé, An kàrè ree tḛḛ nɔ̰ɔ̰ tɔ. Ḛ tɔ́y Lubə rəm, pa ta lə Jeju adɨ dow-je lay kɨ́ dꞌisɨ ꞌngəbɨ taa kɨ́ Lubə à taa ɓebo Jorijalḛm kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lokɨ Jojepɨ-je kɨ̀ Mari ꞌra né-je lay kɨ́ ndukun lə ꞌƁaɓe ɔjɨ kadɨ ꞌra lé, dḛ ꞌtəl dꞌɔw lo kisɨ-dé-tɨ ɓebo Najarɛtɨ, dɔnangɨ Galile-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ngon lé, tɔgɨ rəm, rɔ-é nga̰ rəm, ɔw kɨ̀ gosɨ n̰a̰ rəm, ɓá ramajɨ lə Lubə nà̰y siə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jeju lé, ɓal-je lay ya njékojɨ-é-je dꞌɔw ɓebo Jorijalḛm-tɨ lo ra na̰y Pakɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Beɓa lokɨ ḛ ra ɓal dɔgɨ gidɨ-é joo lé, dꞌɔw siə kəm-dé-tɨ ɓebo Jorijalḛm-tɨ lo ra na̰y Pakɨ-tɨ, titɨ kɨ́ ꞌra-né kɨ̀ ɓal-é ɓal-é. ");
INSERT INTO mge_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ngà lokɨ ndɔ ra na̰y Pakɨ tingə lé, njékojɨ-é-je ꞌtəl dꞌisɨ dꞌɔw kɨ́ ɓee gogɨ, ngà ngon-dé Jeju lé, təl nà̰y ɓebo Jorijalḛm-tɨ adɨ dḛ ꞌgə go-é al. ");
INSERT INTO mge_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dḛ ꞌgɨr kɨ́ à kɔw dan madɨ kɔw mba-je-tɨ lə-dé nɔ̰ɔ̰, adɨ ꞌnjiyə ndɔ káre ɓikti ɓəy ɓá ꞌtum gin ndole-é dan nojɨ-dé-je-tɨ, kɨ̀ dan dow-je-tɨ kɨ́ ꞌgə-dé. ");
INSERT INTO mge_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ngà lokɨ dꞌingə-é al lé, dḛ dꞌɔsɨ ꞌtəl dꞌɔw ɓebo Jorijalḛm-tɨ gogɨ kdɔ ndole-é. ");
INSERT INTO mge_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndɔ kɨ́ njèkungɨ-tɨ mutə ɓá dꞌingə-é takəy-tɨ lə Lubə; ḛ isɨ dan njéndó dow-je ndukun-je-tɨ, isɨ oo ta lə-dé rəm, ɓá isɨ dəjɨ-dé ta rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dow-je lay kɨ́ dꞌisɨ dꞌoo ta liə lé, négə liə kɨ̀ ta kɨ́ isɨ ilə-dé-tɨ lé, ɔr ndil-dé. ");
INSERT INTO mge_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lokɨ njékojɨ-é-je dꞌoo-é takəy-tɨ lə Lubə lé, ndil-dé tḛḛ sa̰y adɨ kɔ̰-é pa siə panè: Ngon-m! Kin to ri ə́ ꞌra sə-ji bè? ꞌOo, jḛ kɨ̀ bɔbɨ-i jꞌndol-i kɨ̀ mḛḛ-ji kɨ́ a̰ kə́kə́kə́. ");
INSERT INTO mge_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jeju təl ilə-dé-tɨ panè: Sə̰i ndoli-mi kdɔ ri wa? ꞌGəi kɨ́ tò kadɨ mꞌində kəm-m go kullə-je-tɨ lə Bɔbɨ-m al wa? ");
INSERT INTO mge_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngà ta kɨ́ Jeju pa sə-dé lé, dḛ ꞌgə mḛḛ-é al. ");
INSERT INTO mge_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jeju ɔtɨ ɔw sə-dé ɓebo Najarɛtɨ-tɨ; ḛ sɔl dɔ-é nɔ̰̀ njékojɨ-é-je-tɨ. Kɔ̰-é ngəm né-je kin lay mḛḛ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jeju tɔgɨ ə gosɨ liə usɨ dɔ madɨ-é-tɨ rəm, ramajɨ lə Lubə nà̰y siə rəm, ɓá dow-je ꞌndigɨ-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ɓal kɨ́ njèkungɨ-tɨ dɔgɨ gidɨ-é mḭ kɨ́ Tibɛr Sejar ngar kɨ́ boy ɔ̰̀-né ɓe lé, Pɔ̰sɨ Pilatɨ to gubərnər kɨ́ dɔnangɨ Jude-tɨ, Erodɨ ɔ̰̀ ɓe dɔnangɨ Galile-tɨ, ə ngonkɔ̰-é Pilipɨ ɔ̰̀ ɓe dɔnangɨ Itire-tɨ kɨ̀ dɔnangɨ Trakonitɨ, Lisaniyasɨ ɔ̰̀ ɓe dɔnangɨ Abilḛn-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ɓal-je-tɨ kɨ́ An kɨ̀ Kayipɨ ꞌto-né burə dɔ njégugné-je; ɓal-é-je-tɨ kinlé ɓá Lubə pa-né ta kɨ̀ Ja̰ kɨ́ ngon lə Jakari diləlo-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja̰ ɔw kɨ go dɔnangɨ lay kɨ́ kàdɨ̀ ba Jurdḛ-tɨ, ilə mbḛ kadɨ dow-je ꞌra batḛm dꞌin̰ə-né panjiyə-dé kɨ́ majɨ al kɔgɨ, kdɔ kadɨ Lubə in̰ə-né go majal-je lə-dé kɔgɨ, ");
INSERT INTO mge_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","titɨ kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ ndàngɨ-né mḛḛ mbete-tɨ panè: Ndi dow ɓa diləlo-tɨ panè: ꞌRai rəbɨ lə ꞌƁaɓe! ꞌRai ngan rəbɨ-je liə adi a̰ njururu-njururu! ");
INSERT INTO mge_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ꞌTuləi wol lo-je lay adi asɨ-na̰ pee-pee! Mbal-je kɨ́ ngal kɨ̀ kɨ́ gɔjɨ lay ya, ꞌtugəi-dé kɨ nangɨ! Rəbɨ-je kɨ́ ndu gundi-gundi lé, ꞌndaji adɨ a̰ njururu-njururu! Rəbɨ-je kɨ́ tɔr wutɨ-wutɨ lé, ꞌtuləi adɨ asɨ-na̰ pee-pee. ");
INSERT INTO mge_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ə ná̰-ná̰ ya à koo kajɨ kɨ́ Lubə à kajɨ dow-je lé. ");
INSERT INTO mge_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Beɓa Ja̰ idə kosɨ dow-je kɨ́ ꞌree rɔ-é-tɨ kdɔ kadɨ ra-dé batḛm lé panè: Sə̰i kɨ́ mḛḛ-si ndul titɨ-na̰ kɨ̀ mḛḛ li pii-je bè kan! Ná̰ ɓá idə-si kadɨ a̰yi wɔngɨ kɨ́ à ree lé wa? ");
INSERT INTO mge_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Adi kullə ra-si tuwə kullə ra dow-je kɨ́ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ɓane; ɓɨ ꞌgɨri mḛḛ-si painè ꞌtoi nganka Abrakam ya bè par al. Ə́ mꞌidə-si rəsɨ mꞌadɨ ooi kɨ́ ər-je kin ya kàrè Lubə asɨ təl-dé nganka Abrakam-tɨ kare. ");
INSERT INTO mge_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ə kungə́ ya kàrè dꞌində pèrèrè kàdɨ̀ kagɨ-je-tɨ káre-káre lay ngá, adɨ kagɨ kɨ́ kandɨ-é majɨ al lé, dꞌa tugə-é dɔ njirə-é-tɨ kdɔ kilə-é dan pər-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Beɓa kosɨ dow-je ꞌdəjɨ-é ꞌpanè: Bè ngà, jꞌa ra ban ngá wa? ");
INSERT INTO mge_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ḛ ilə-dé-tɨ panè: Dow kɨ́ ɔw kɨ̀ kubɨ joo rəmə, adɨ káre dow kɨ́ ꞌliə goto, ə dow kɨ́ ɔw kɨ̀ nékuso kàrè kadɨ ra bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Njétaalambo-je kàrè ꞌree kadɨ Ja̰ ra-dé batḛm tɔ. Beɓa ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, jḛ jꞌa ra ban wa? ");
INSERT INTO mge_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ḛ idə-dé panè: Né kɨ́ dꞌun ndu dɔ-tɨ kadɨ dow-je dꞌadɨ lé, iləi kɨ́ rangɨ dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asgar-je ꞌree ꞌdəjɨ-é tɔ ꞌpanè: Ə jḛ, jꞌa ra ban wa? Ḛ idə-dé panè: ꞌTaai né lə dow kɨ́ lə njètɔ́gɨ-tɨ al, ɓá iləi ta dɔ dow-tɨ kɨ̀ ndángɨ kare ꞌtaai-né né liə al rəm tɔ. Ngà ori kəm-si dɔ là kun-si-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Titɨ kɨ́ kosɨ dow-je lay dꞌisɨ ꞌngəbɨ-né pèrèrè lé, ꞌgɨr mḛḛ-dé-tɨ sé Ja̰ ɓá to Kristɨ lé wa? ");
INSERT INTO mge_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngá ɓá Ja̰ idə-dé lay panè: Ma̰ mꞌra-si batḛm kɨ́ mani, ngà ḛ kɨ́ tɔ́gɨ-é itə-m n̰a̰ ya ɔw ree go-m-tɨ nɔ̰ɔ̰, ə kulə saba liə ya kàrè mꞌtuwə kadɨ mꞌtutɨ al. Ḛ à ra-si batḛm kɨ̀ Ndil kɨ́ aa njay rəm, kɨ̀ pər rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ḛ ɔw kɨ̀ né tó-né liə ji-é-tɨ nɔ̰ɔ̰; à ra lo tó né liə, ə à mbɔ̰ ko mḛḛ dama̰ liə, ngà tisə-é ɓá à kungɨ dan pər-tɨ kɨ́ à koy al sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Beɓa Ja̰ ilə mbḛ Poyta kɨ́ Majɨ adɨ dow-je, ə mbusɨ nja-dé kɨ̀ ta-je kɨ́ rangɨ n̰a̰ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngà Erodɨ kɨ́ to njèkɔ̰ɓe dɔnangɨ Galilé-tɨ lé taa Erodiadɨ ne ngonkɔ̰-é rəm, ɓá ra né-je kɨ́ majɨ al majɨ al adɨ Ja̰ kɔl siə. ");
INSERT INTO mge_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Rəmə təl a̰ dɔ-tɨ nɔ̰ɔ̰ ilə Ja̰ dangay-tɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lokɨ dow-je lay ꞌra batḛm lé, Jeju kàrè ꞌra-é batḛm tɔ. Beɓa lokɨ ḛ a̰ pa ta kɨ̀ Lubə lé, ta dɔra̰ tḛḛ; ");
INSERT INTO mge_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ə Ndil kɨ́ aa njay təl titɨ-na̰ kɨ̀ dəngɔdnda bè ree isɨ dɔ-é-tɨ. Rəmə ndi dow ɓá dɔra̰-tɨ panè: «ꞌTo Ngon-m, mꞌində-i dan kəm-m-tɨ, rɔ-m nəl-m dɔ-i-tɨ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jeju ra ɓal kɔrmutə-je bè ɓəy ɓá ulə gin kullə liə. Titɨ kɨ́ dow-je ꞌgɨr-né lé, ḛ to ngon lə Jojepɨ, Jojepɨ to ngon lə Eli, ");
INSERT INTO mge_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli to ngon lə Matatɨ; Matatɨ to ngon lə Lebi; Lebi to ngon lə Melki; Melki to ngon lə Yana̰y; Yana̰y to ngon lə Jojepɨ; ");
INSERT INTO mge_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jojepɨ to ngon lə Matatiyasɨ; Matatiyasɨ to ngon lə Amosɨ; Amosɨ to ngon lə Naum; Naum to ngon lə Esli; Esli to ngon lə Nagay; ");
INSERT INTO mge_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay to ngon lə Maatɨ; Maatɨ to ngon lə Matatiyasɨ; Matatiyasɨ to ngon lə Seməy; Seməy to ngon lə Yose; Yose to ngon lə Yoda; ");
INSERT INTO mge_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda to ngon lə Yonan; Yonan to ngon lə Resa; Resa to ngon lə Jorobabɛl; Jorobabɛl to ngon lə Salatiyɛl; Salatiyɛl to ngon lə Neri; ");
INSERT INTO mge_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri to ngon lə Melki; Melki to ngon lə Adi; Adi to ngon lə Kosam; Kosam to ngon lə Elmadam; Elmadam to ngon lə Ɛr; ");
INSERT INTO mge_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛr to ngon lə Jeju; Jeju to ngon lə Eliyejɛr; Eliyejɛr to ngon lə Yorim; Yorim to ngon lə Matatɨ; Matatɨ to ngon lə Lebi; ");
INSERT INTO mge_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi to ngon lə Simiyɔ̰; Simiyɔ̰ to ngon lə Juda; Juda to ngon lə Jojepɨ; Jojepɨ to ngon lə Yonam; Yonam to ngon lə Eliyakim; ");
INSERT INTO mge_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim to ngon lə Meleya; Meleya to ngon lə Menna; Menna to ngon lə Matata; Matata to ngon lə Nata̰; ");
INSERT INTO mge_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nata̰ to ngon lə Dabidɨ; Dabidɨ to ngon lə Jese; Jese to ngon lə Obɛdɨ; Obɛdɨ to ngon lə Bowajɨ; Bowajɨ to ngon lə Salmɔ̰; Salmɔ̰ to ngon lə Nasɔ̰; ");
INSERT INTO mge_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔ̰ to ngon lə Aminadabɨ; Aminadabɨ to ngon lə Admi; Admi to ngon lə Arni; Arni to ngon lə Esrɔm; Esrɔm to ngon lə Parɛsɨ; Parɛsɨ to ngon lə Juda; ");
INSERT INTO mge_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda to ngon lə Jakobɨ; Jakobɨ to ngon lə Isakɨ; Isakɨ to ngon lə Abrakam; Abrakam to ngon lə Tera; Tera to ngon lə Naɔr; ");
INSERT INTO mge_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naɔr to ngon lə Serugɨ; Serugɨ to ngon lə Reu; Reu to ngon lə Pelɛgɨ; Pelɛgɨ to ngon lə Ebɛr; Ebɛr to ngon lə Sila; ");
INSERT INTO mge_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila to ngon lə Kaynam; Kaynam to ngon lə Arpajadɨ; Arpajadɨ to ngon lə Sɛm; Sɛm to ngon lə Nuwe; Nuwe to ngon lə Lemɛkɨ; ");
INSERT INTO mge_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemɛkɨ to ngon lə Matusalḛm; Matusalḛm to ngon lə Enɔkɨ; Enɔkɨ to ngon lə Yerɛdɨ; Yerɛdɨ to ngon lə Maleleyɛl; Maleleyɛl to ngon lə Kenam; ");
INSERT INTO mge_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenam to ngon lə Enosɨ; Enosɨ to ngon lə Sɛtɨ; Sɛtɨ to ngon lə Adam; Adam to Ngon lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ndil kɨ́ aa njay rusɨ Jeju, beɓa lokɨ ḛ təl ta ba Jurdḛ-tɨ ree rəmə Ndil kɨ́ aa njay lé ɔr nɔ̰̀-é ɔw siə diləlo-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Lo-é-tɨ kin ɓá Sú na̰-é-tɨ ndɔ kɔrsɔ. Ndɔ kɨ́ kɔrsɔ kinlé, né ya kàrè Jeju uso al adɨ go ndɔ-je-tɨ kinlé, ɓo ra-é. ");
INSERT INTO mge_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Beɓa Sú ree rɔ-é-tɨ pa siə panè: «Kinə ꞌto Ngon lə Lubə ya rəmə, ꞌun ndu adɨ ər kin təl mbə̀.» ");
INSERT INTO mge_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ə Jeju ilə-é-tɨ panè: «ꞌNdàngɨ ꞌpanè: “Dow à kisɨ kɨ̀ dɔ-é taá kɨ̀ takul nékuso ya par al.”» ");
INSERT INTO mge_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sú ɔr Jeju ɔw siə lo-tɨ kɨ́ ḭ taá n̰a̰ rəmə, kəm kɨ́ kində jipɨ bè ya tɔjɨ-é kɔ̰ɓe-je kɨ́ dɔnangɨ-tɨ nè kin lay ");
INSERT INTO mge_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ə idə-é panè: «Mꞌa kadɨ-i ɔ̰̀ ɓe dɔ-tɨ lay rəm, mꞌa kadɨ-i riɓa kɨ́ dɔ kɔ̰ɓe-je-tɨ kinlé rəm tɔ. Kdɔtalə to né kɨ́ dꞌadɨ tò mḛḛ ji-m-tɨ, adɨ dow kɨ́ mḛḛ-m ndigɨ kadɨ mꞌadɨ-é ya mꞌa kadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Adɨ kinə dɔ-i ya ꞌɔsɨ nangɨ nɔ̰̀-m-tɨ lé, mꞌa kadɨ to kɨ́ lə-i ya lay.» ");
INSERT INTO mge_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jeju təl ilə-é-tɨ panè: «ꞌNdàngɨ ꞌpanè: “ꞌƁaɓe Lubə lə-i ɓá ꞌa kɔsɨ dɔ-i nangɨ nɔ̰̀-é-tɨ ə ḛ ya kɨ̀ kár-é ɓá ꞌa pole-é.”» ");
INSERT INTO mge_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Go-tɨ, Sú ɔr-é ɔw siə mḛḛ ɓebo Jorijalḛm-tɨ, adɨ-é a̰ taá sam kəy-tɨ lə Lubə ɓá idə-é panè: «Kinə ꞌto Ngon lə Lubə ya rəmə, ꞌa̰ nè ya ꞌkilə ꞌusɨ nangɨ. Kdɔ ꞌndàngɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Lubə à kun ndu kadɨ malayka-je liə kdɔ ta lə-i, kdɔ kadɨ dꞌində kəm-dé go-i-tɨ.” ");
INSERT INTO mge_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ə ꞌndàngɨ ɓəy ꞌpanè: “Dḛ dꞌa kində ji-dé kuwə-i-né taá, nè nja-i à kḭ dar ər.”» ");
INSERT INTO mge_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jeju təl ilə-é-tɨ panè: «ꞌNdàngɨ ꞌpanè: “ꞌA na̰ ꞌƁaɓe Lubə lə-i al.”» ");
INSERT INTO mge_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lokɨ Sú na̰ Jeju mḛḛ né-je-tɨ lay adɨ gin-é gangɨ lé, ḛ ɔr rɔ-é ngərəngɨ in̰ə-é sar ya kdɔ ngəbɨ-né kəm lo kɨ́ rangɨ. ");
INSERT INTO mge_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jeju təl ɔw dɔnangɨ Galile-tɨ gogɨ kɨ̀ tɔ́gɨ kɨ́ Ndil kɨ́ aa njay adɨ-é, ə ri-é ɓa ɔr lo dɔnangɨ-tɨ kɨ́ tin kin lay. ");
INSERT INTO mge_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ḛ ɔw ndó né dow-je mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je ə dow-je lay ya ꞌpitɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Beɓa Jeju ɔw tḛḛ ɓebo Najarɛtɨ kɨ́ to lo kɨ́ dꞌotɨ-é-tɨ, ə ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je ndɔ taakoo-tɨ lə-dé titɨ kɨ́ isɨ ra-né kete-kete. Ḛ ḭ taá kdɔ ndó mbete kɨ́ aa njay kadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Beɓa dꞌun mbete kɨ́ Ejay kɨ́ to njèpata kɨ́ ta Lubə-tɨ ndàngɨ dꞌadɨ-é. Lokɨ ḛ taa lé, tḛḛ mḛḛ-é ə ingə lo kɨ́ ndàngɨ ta-tɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ndil kɨ́ aa njay lə ꞌƁaɓe ree nà̰y sə-m kdɔtalə ꞌƁaɓe mbətɨ-m kdɔ kadɨ mꞌsɔl mḛḛ dow-je kɨ́ mḛḛ-dé gangɨ man rəm, ɓá kdɔ kadɨ mꞌilə mbḛ Poyta kɨ́ Majɨ mꞌadɨ njéndoo-je rəm tɔ. Ḛ ulə-m kadɨ mꞌpa ta rəsɨ mꞌadɨ ɓə-je tokɨ Lubə à taa-dé kilə-dé taá rəm, kadɨ mꞌpa ta rəsɨ mꞌadɨ njékəmtɔ-je tokɨ kəm-dé à koo lo rəm, dow-je kɨ́ dow-je dꞌadɨ-dé kɔ̰̀ lé, ḛ ulə-m kadɨ mꞌtaa-dé mꞌilə-dé taá rəm, ");
INSERT INTO mge_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ɓá ɓal ramajɨ lə ꞌƁaɓe lé, kadɨ mꞌpa ta-é rəsɨ ya mꞌadɨ dow-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Go-tɨ, Jeju ndəm mbete lé natɨ ə təl-né adɨ ngonnjèkullə káre, ngá ɓá təl isɨ nangɨ ɓəy. Rəmə dow-je lay kɨ́ dꞌisɨ mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, kəm-dé tò dɔ-é-tɨ sikɨm. ");
INSERT INTO mge_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Beɓa ḛ un ta idə-dé panè: Ta kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay kɨ́ ooi kinlé, né-é ra né ɓone ngá. ");
INSERT INTO mge_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dow-je lay ya ꞌpa ta kɨ́ dɔ-é-tɨ majɨ n̰a̰ rəm, ta-je kɨ́ sɔbɨ dɔ ramajɨ lə Lubə kɨ́ tḛḛ ta-é-tɨ lé, ɔr ndil-dé adɨ ꞌpanè: Ḛ kan to ngon lə Jojepɨ lé ya al wa! ");
INSERT INTO mge_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Beɓa Jeju pa sə-dé panè: Gosta kɨ́ panè: «Dɔktur, i ya ꞌajɨ rɔ-i» kinlé a pai sə-m ya rɔ́tɨ. Ə a pai sə-m painè: Né-je lay kɨ́ i ꞌra ɓebo Kapɛrnayim-tɨ ə́ jꞌoo ta-é kinlé, ꞌra ɓe kɨ́ i tɔgɨ-tɨ nè kin ya adɨ jꞌoo tɔ. ");
INSERT INTO mge_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Beɓa Jeju idə-dé panè: Ooi majɨ, mꞌa kidə-si rəsɨ; njèpata kɨ́ ta Lubə-tɨ kɨ́ dow-je kɨ́ ɓekojɨ-é-tɨ dꞌa kuwə-é kɨ rɔ-dé-tɨ majɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yən, mꞌa kidə-si ta kɨ́ tɔgrɔ-tɨ: Dɔgangɨ ɓal-je-tɨ lə Eli lé, njéngɔwkoy-je ꞌn̰a̰ dɔnangɨ Israyel-tɨ. Beɓa lokɨ ndi ədɨ al asɨ ɓal mutə kɨ̀ na̰y mɛkḛ lé, go dɔnangɨ-tɨ kɨ́ nè kin lay ya ɓo ra dow-je titɨ n̰a̰ ya, ");
INSERT INTO mge_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ngà dan njéngɔwkoy-je-tɨ kinlé, dow káre ya kàrè Lubə ulə Eli rɔ-é-tɨ al. Ngà ḛ ulə-é rɔ njèngɔwkoy-tɨ káre kɨ́ dɔnangɨ Sidɔ̰-tɨ mḛḛ ɓebo Sarepta-tɨ yó. ");
INSERT INTO mge_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Rəm ɓá kaglo-tɨ lə Elije kɨ́ to njèpata kɨ́ ta Lubə-tɨ lé kàrè njébanjɨ-je ꞌn̰a̰ dɔnangɨ Israyel-tɨ tɔ. Ngà ḛ káre dan-dé-tɨ kɨ́ Lubə adɨ banjɨ liə ur ya goto. Ngà Nama̰ kɨ́ to dow kɨ́ dɔnangɨ Siritɨ yó kin ɓá ḛ adɨ banjɨ liə ur adɨ aa njay. ");
INSERT INTO mge_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lokɨ dow-je lay kɨ́ dꞌisɨ mḛḛ kəykəwna̰-tɨ lə jipɨ-je dꞌoo ta-je kin bè lé, wɔngɨ ra-dé dɔ Jeju-tɨ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Beɓa dꞌḭ dꞌuwə-é, ꞌndɔr-é dꞌɔw siə gidɨ ɓebo-tɨ, ə dꞌɔw siə njal dɔ mbal-tɨ kɨ́ ɓebo lə-dé tò-tɨ kdɔ kadɨ ꞌsurə-é dꞌilə-é nangɨ. ");
INSERT INTO mge_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ya rəmə, Jeju tḛḛ mbunə̰-dé-tɨ ə ɔtɨ ta-dé-tɨ yɔrɔrɔ ɔw. ");
INSERT INTO mge_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeju ɔw tḛḛ ɓebo Kapɛrnayim-tɨ kɨ́ to ɓebo káre kɨ́ dɔnangɨ Galile-tɨ ə ndó né dow-je ndɔ taakoo-tɨ lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Néndó liə lé ɔdɨ rɔ dow-je, kdɔtalə ḛ ndó kɨ̀ tɔ́gɨ. ");
INSERT INTO mge_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, dingəm káre bè kɨ́ ndil kɨ́ majɨ al ra-é isɨ-tɨ nɔ̰ɔ̰ ə ur kəə panè: ");
INSERT INTO mge_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Bɔbɨ-m-je ꞌwə́! I Jeju, dow kɨ́ Najarɛtɨ lé, ri ɓá ꞌge rɔ-ji-tɨ wa? ꞌRee kdɔ tujɨ-ji wa? Ma̰ mꞌgə-i majɨ: «ꞌTo njèkaa njay lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeju ndángɨ-é panè: «ꞌUtɨ ta-i ə ꞌtḛḛ kɔgɨ mḛḛ dingəm-tɨ kinlé!» Rəmə ndil kɨ́ majɨ al un dingəm lé ilə-é birikɨ dan dow-je-tɨ ə ində lo tḛḛ mḛḛ-é-tɨ kɔgɨ, ɓá né kɨ́ majɨ al káre ya kàrè ndil kɨ́ majɨ al kin ra kɨ̀ dingəm lé al. ");
INSERT INTO mge_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Beɓa dow-je lay ya, ndil-dé tḛḛ sa̰y ə ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: To ta kɨ́ ban ɓá tana̰ bè wa? Ḛ un ndu adɨ ndil-je kɨ́ majɨ al kɨ̀ tɔ́gɨ kɨ́ n̰a̰ kɨ́ ḛ ɔw-né lé rəmə, dḛ ꞌtḛḛ tḛḛ tɔ lé ya! ");
INSERT INTO mge_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Né kin ra adɨ poy Jeju taa lo kɨ́ dɔnangɨ-tɨ kɨ́ tin pəl-pəl. ");
INSERT INTO mge_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lokɨ tḛḛ mḛḛ kəykəwna̰-tɨ lé, ḛ ɔw ɓee lə Simɔ̰. ꞌNingə́ ində məm Simɔ̰ kɨ́ dené n̰a̰, adɨ rɔ-é tungə pil-pil ə dḛ ꞌnɔ̰ ta Jeju-tɨ kdɔ ta liə. ");
INSERT INTO mge_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Beɓa Jeju ɗugɨ nangɨ kɨ rɔ-é-tɨ ə ndángɨ ꞌningə́ lé rəmə, ꞌningə́ lé in̰ə-é, adɨ tajinatɨ nè ya məm Simɔ̰ lé, ubə nangɨ ḭ taá oo go-dé kɨ̀ nékuso. ");
INSERT INTO mge_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lokɨ kàdɨ̀ ur rəmə, dow-je lay kɨ́ dꞌɔw kɨ̀ dow-je kɨ́ mɔ̰y-je kɨ́ gay-gay ra-dé lé, dꞌɔy-dé dꞌɔw sə-dé rɔ Jeju-tɨ. Beɓa ḛ ində ji-é dɔ-dé-tɨ káre-káre lay adɨ dꞌingə lapiya. ");
INSERT INTO mge_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ndil-je kɨ́ majɨ al kàrè ꞌtḛḛ mḛḛ dow-je-tɨ n̰a̰ kɨ̀ nɔ̰ ta-dé-tɨ ꞌpanè: «ꞌTo Ngon lə Lubə.» Ngà ḛ ndángɨ-dé ə ɔgɨ-dé pa ta, kdɔtalə dḛ ꞌgə majɨ kɨ́ ḛ to Kristɨ. ");
INSERT INTO mge_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lokɨ lo aa lé, Jeju tḛḛ ɔw diləlo-tɨ. Beɓa kosɨ dow-je ya dꞌungɨ-na̰ sangɨ-é-tɨ ə dꞌɔw njal go-é-tɨ rəmə, ꞌndigɨ kuwə-é nangɨ, kdɔ kadɨ in̰ə-dé ɔw al. ");
INSERT INTO mge_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngà ḛ idə-dé panè: Tò kadɨ mꞌilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə lé, mꞌadɨ dow-je kɨ́ mḛḛ ɓebo-je-tɨ kɨ́ rangɨ tɔ ɓane. Kdɔtalə to ḛ kin ɓá Lubə ulə-m-né lé. ");
INSERT INTO mge_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Beɓa ḛ ilə mbḛ Poyta kɨ́ Majɨ dɔnangɨ Jude-tɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ndɔ káre bè, lokɨ Jeju a̰ ta babo-tɨ kɨ́ Jenejarɛtɨ lé, kosɨ dow-je dꞌɔw dɔ-na̰-tɨ wúr-wùr kdɔ koo ta lə Lubə ta-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lokɨ un kəm-é oo tò-je joo ngangɨ baa-tɨ ə to tò-je kɨ́ mbɔw-je kɨ́ mḛḛ-é-tɨ dꞌur nangɨ dꞌa̰ ꞌtogɨ burə-je lə-dé; ");
INSERT INTO mge_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ḛ al mḛḛ tò-tɨ kɨ́ káre kɨ́ to tò lə Simɔ̰ ə dəjɨ Simɔ̰ adɨ in̰ə ngangɨ ba ə ɔsɨ tò sḛ kɨ́ dan ba-tɨ, ngá ɓá ḛ isɨ mḛḛ tò-tɨ lé, isɨ ndó né kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lokɨ Jeju pa ta lay rəmə, idə Simɔ̰ panè: ꞌƆsɨ tò kɨ́ dan ɓul baa-tɨ ə ungi burə-je lə-si mani kadɨ ꞌrai ndɔ̰. ");
INSERT INTO mge_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔ̰ ilə-é-tɨ panè: Njèndó dow-je né, jḛ jꞌra kullə ndɔɔ sar lo aa-ji taá ya, ngà né káre ya kàrè jꞌuwə al; ngà titɨ kɨ́ i ꞌpa-né lé, mꞌa kungɨ burə mani ya. ");
INSERT INTO mge_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lokɨ dꞌungɨ burə-je mani lé, kanjɨ rusɨ burə-je lə-dé sar adɨ ɔw kɨ̀ gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Beɓa ꞌkəbɨ madkullə-je lə-dé kɨ́ mḛḛ tò-tɨ kɨ́ káre lé kadɨ ꞌree dꞌore kàdɨ̀-dé. Lokɨ madɨ-dé-je ꞌree rəmə, dꞌɔy kanjɨ-je rusɨ tò-je kɨ́ joo lé betete, adɨ tò-je ɔw kɨ̀ nduy sə-dé tɔ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lokɨ Simɔ̰ Piyər oo né kin bè lé, usɨ nangɨ nja Jeju-tɨ panè: ꞌƁaɓe, ꞌɔtɨ kɨ rangɨ rɔ-m-tɨ, kdɔtalə ma̰ lé mꞌto dow kɨ́ njèramajal. ");
INSERT INTO mge_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kanjɨ kɨ́ dꞌuwə al dɔ majɨ kinlé, ra adɨ ɓəl ində bandɨ Simɔ̰ gangɨ, ɓá dow-je lay kɨ́ dꞌa̰ siə natɨ kàrè ɓəl ində bandɨ-dé gangɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bè ya tɔ, madkullə-je lə Simɔ̰, adɨ to Jakɨ-je kɨ̀ Ja̰ kɨ́ ꞌto ngan lə Jebede lé kàrè, ɓəl ində bandɨ-dé batɨ gangɨ tɔ. Beɓa Jeju idə Simɔ̰ panè: ꞌƁəl al, kete lé ꞌto njèndɔ̰ kanjɨ-je, ngà kḭ nè kɔw kɨ kete kinlé, dow-je ngá ɓá ꞌa təl njèsangɨ-dé kadɨ-m. ");
INSERT INTO mge_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Beɓa lokɨ dḛ ꞌree kɨ̀ tò-je lə-dé ngangɨ ba-tɨ gogɨ rəmə, dꞌin̰ə né-je lay ya ə dꞌun go Jeju. ");
INSERT INTO mge_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ndɔ káre bè, lokɨ Jeju isɨ ɓebo-tɨ madɨ lé, dingəm kɨ́ banjɨ taa rɔ-é pəl-pəl da dɔ-é-tɨ. Lokɨ oo Jeju rəmə, ɔsɨ məkəjɨ-é nangɨ ə ɔsɨ dɔ-é nangɨ nɔ̰̀-é-tɨ ɓá dəjɨ-é panè: ꞌƁaɓe, kinə ꞌndigɨ lé, ꞌa kadɨ banjɨ lə-m kin ur kadɨ mꞌaa njay kare! ");
INSERT INTO mge_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeju ulə ji-é ɔdɨ-né rɔ-é ɓá panè: «Mꞌndigɨ dɔ-tɨ sə-i. Kadɨ banjɨ lə-i ur!» Rəmə tajinatɨ nè ya banjɨ kɨ́ rɔ-é-tɨ ur wukɨ adɨ aa njay. ");
INSERT INTO mge_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Go-tɨ, Jeju ndəjɨ-é kadɨ pa ta-é adɨ dow oo al. Ngà idə-é panè: ꞌƆw ꞌɔjɨ rɔ-i njègugné ə ꞌadɨ né kdɔ məsɨ kɨ́ kilə kɨ́ sɔbɨ dɔ kaa rɔ lə-i titɨ kɨ́ ndukun lə Moiyijɨ pa-né. Bè kdɔ kadɨ dow-je lay ꞌgə kɨ́ banjɨ kɨ́ rɔ-i-tɨ lé ur ngá. ");
INSERT INTO mge_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Beɓa ri Jeju ɓa kɨ kete-kete adɨ kosɨ dow-je n̰a̰ ya ꞌɓungə-na̰ ꞌree par-par ꞌkəw-na̰ dɔ-é-tɨ kdɔ koo ta liə, ɓá dḛ kɨ́ ꞌto njémɔ̰y-je kàrè ꞌree kdɔ kadɨ adɨ-dé lapiya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngà Jeju ɔr rɔ-é ɔw diləlo-tɨ, ɔw pa ta kɨ̀ Lubə titɨ kɨ́ isɨ ra-né taá-taá. ");
INSERT INTO mge_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ndɔ káre bè, Jeju isɨ ndó né dow-je ə Parisi-je, kɨ̀ njéndó dow-je ndukun-je kɨ́ dꞌḭ nganɓe-je-tɨ lay kɨ́ dɔnangɨ Galile-tɨ, kɨ̀ dɔnangɨ Jude-tɨ, kɨ̀ dḛ kɨ́ dꞌḭ ɓebo Jorijalḛm-tɨ dꞌisɨ dan-dé-tɨ. Tɔ́gɨ lə ꞌƁaɓe nà̰y kɨ̀ Jeju adɨ Jeju adɨ lapiya njémɔ̰y-je n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Beɓa dow-je dꞌun dingəm kɨ́ rɔ-é oy mburukɨ mḛḛ tuwə-tɨ ꞌree siə, ꞌsangɨ rəbɨ kadɨ dꞌɔw siə kəy nɔ̰̀ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngà kosɨ dow-je kɨ́ ꞌn̰a̰ kinlé ra adɨ lo kadɨ dꞌingə tarəbɨ dꞌɔw-né siə go-é-tɨ goto. Beɓa dꞌal siə dɔ kəy-tɨ, ꞌwan̰a̰ lo dꞌulə-é-né kɨ̀ tuwə burə́ nɔ̰̀ Jeju-tɨ kəy, dan kosɨ dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lokɨ Jeju oo kadmḛḛ lə-dé bè rəmə, idə dingəm lé panè: «Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ kadɨ-i.» ");
INSERT INTO mge_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Njéndó dow-je ndukun-je, kɨ̀ Parisi-je kɨ́ dꞌisɨ lo-é-tɨ lé, ꞌgɨr ta mḛḛ-dé-tɨ ꞌpanè: Dow kanlé oo rɔ-é kɨ ná̰ ya ɓá pa ta kɔbɨ dɔ Lubə-tɨ bè wa? Ná̰ ɓá asɨ kin̰ə go majal-je lə dow kɔgɨ wa? Lubə ya kɨ̀ kár-é asɨ. ");
INSERT INTO mge_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeju gə ta kɨ́ mḛḛ-dé-tɨ ɓətɨ adɨ pa sə-dé panè: Kdɔ ri ɓá ɔwi kɨ̀ tagɨr-je kɨ́ bè kin mḛḛ-si-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dan ta-je-tɨ kɨ́ joo kinlé, ḛ kɨ́ rá ɓá tò ɓəl n̰a̰ wa? Kidə dow panè: «Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ kadɨ-i» ɓá tò ɓəl n̰a̰ əse kidə-é panè: «ꞌḬ taá ꞌnjiyə» ɓá tò ɓəl n̰a̰ wa? ");
INSERT INTO mge_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Majɨ! Mꞌa kɔjɨ-si kadɨ ꞌgəi kɨ́ Ngon lə dow lé, ɔw kɨ̀ tɔ́gɨ dɔnangɨ-tɨ nè kdɔ kin̰ə-né go majal-je lə dow-je kɔgɨ. Beɓa Jeju təl idə njèrɔkoy mburukɨ lé panè: Mꞌun ndu mꞌadɨ-i mꞌpanè: ꞌḬ taá, ꞌun tuwə lə-i ə ꞌɔw ɓee lə-i. ");
INSERT INTO mge_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Rəmə tajinatɨ nè ya dingəm lé, ḭ taá takəm dow-je-tɨ, un tuwə tò-é ə ɔsɨ gajɨ Lubə taá-taá ɔw ɓee. ");
INSERT INTO mge_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Né kinlé, ɔr ndil dow-je lay kɨ́ dꞌa̰ lo-é-tɨ, adɨ dꞌɔsɨ-né gajɨ Lubə rəm, ɓá ɓəl ində bandɨ-dé gangɨ, adɨ ꞌpanè: Né-je kɨ́ dow oo nja káre al ya ɓone jꞌooi. ");
INSERT INTO mge_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Go-tɨ, Jeju tḛḛ rəmə, oo njètaalambo káre kɨ́ ri-é lə Lebi isɨ lo taa lambo-je-tɨ. Jeju idə-é panè: «ꞌUn go-m.» ");
INSERT INTO mge_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rəmə ḛ tusɨ né-je lay in̰ə ə ḭ taá un go Jeju. ");
INSERT INTO mge_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebi ɔw ra nékuso n̰a̰ mḛḛ kəy-tɨ liə un-né ta Jeju. Njétaalambo-je, kɨ̀ dow-je kɨ́ rangɨ n̰a̰ ya dꞌisɨ sə-dé natɨ ta nékuso-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi-je, kɨ̀ njéndó dow-je ndukun-je lə-dé ꞌpa-na̰ ta dan-dé-tɨ n̰ɔ̰m-n̰ɔ̰m ɓá ꞌpa kɨ̀ njéndó né-je lə Jeju ꞌpanè: Kdɔ ri ɓá njétaalambo-je, kɨ̀ njéramajal-je kin ya sə̰i usoi rəm, a̰yi sə-dé rəm wa? ");
INSERT INTO mge_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Beɓa Jeju pa sə-dé panè: «Dow-je kɨ́ rɔ-dé tò kɨ̀ lapiya kare lé dꞌɔw ndoo dɔktur al, ngà njémɔ̰y-je ɓá dꞌɔw ndoo-é. ");
INSERT INTO mge_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Bè ya tɔ, ma̰ lé, dow-je kɨ́ njéra né kɨ́ njururu ɓá mꞌree kdɔ ɓa-dé al, ngà mꞌree kdɔ ɓa njéramajal-je kadɨ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dow-je dꞌidə Jeju ꞌpanè: Njéndó né-je lə Ja̰, kɨ̀ njéndó né-je lə Parisi-je lé, taá-taá ya dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y ə ꞌpa ta kɨ̀ Lubə. Ngà i lé, njéndó né-je lə-i dꞌuso né rəm, dꞌa̰y man rəm. ");
INSERT INTO mge_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jeju ilə-dé-tɨ panè: Lokɨ njètaa dené sigɨ isɨ natɨ kɨ̀ dow-je kɨ́ ḛ ꞌɓa-dé lo nékuso taana̰-tɨ nè ɓəy ya sə̰i ꞌndigi kadɨ dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y wa? ");
INSERT INTO mge_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ndɔ-je ɔw ree nɔ̰ɔ̰ lé, dꞌa kun-é ta-dé-tɨ kɔgɨ, rəmə mḛḛ ndɔ-é-je-tɨ kinlé ɓá dꞌa kɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jeju idə-dé gosta káre ɓəy panè: Kubɨ kɨ́ sigɨ lé, dow à kijə ta-é kdɔ kilə-né kəm ndisɨ kubɨ al. Kinə dowbé ijə rəmə, ijə kɨ̀ ndángɨ kare; ɓá takubɨ kɨ́ sigɨ kɨ́ dowbé ijə lé kàrè à kun-na̰ kɨ̀ ndisɨ kubɨ lé al rəm. ");
INSERT INTO mge_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Rəm ɓá dow à tur yibɨ nduu kɨ́ sigɨ mḛḛ mbundaá-je-tɨ kɨ́ low al rəm. Kinə dow tur-tɨ rəmə, yibɨ nduu kɨ́ sigɨ à kḭ kində mbundaá-je kɨ́ low lé bəndəngɨ gangɨ kadɨ yibɨ nduu à tɔɔ kɔgɨ rəm, ɓá mbundaá-je lé kàrè à tujɨ kɔgɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ngà yibɨ nduu kɨ́ sigɨ lé, tò kadɨ ꞌtur mḛḛ mbundaá-je-tɨ kɨ́ sigɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ə dow kɨ́ a̰y yibɨ nduu kɨ́ low lé, ḛ ndigɨ yibɨ nduu kɨ́ sigɨ al ngá. Kdɔtalə ḛ à panè: Yibɨ nduu kɨ́ low ya ɓá majɨ. ");
INSERT INTO mge_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ndɔ káre bè, kɨ́ to ndɔ taakoo lə jipɨ-je lé, Jeju njiyə mḛḛ ndɔr-je-tɨ kdɔ kində gangɨ ə njéndó né-je liə ꞌpuy dɔ gemḛ, ꞌrii ka̰a̰-é ji-dé-tɨ dꞌuso taá-taá. ");
INSERT INTO mge_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rəmə Parisi-je kɨ́ dan-tɨ-je ꞌpa sə-dé ꞌpanè: «Kdɔ ri ɓá ꞌrai né kɨ́ to tó-é al kadɨ dow ra ndɔ taakoo-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeju təl ilə-dé-tɨ panè: «Né kɨ́ ndɔkɨ Dabidɨ ra kaglo-tɨ liə, lokɨ ɓo ra-dé dḛ kɨ̀ dow-je liə lé, se sə̰i ꞌndói ta-é mḛḛ mbete-tɨ kɨ́ aa njay ooi al ya sar wa? ");
INSERT INTO mge_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ḛ ɔw mḛḛ kəykubɨ-tɨ lə Lubə, ɔy mbə̀ kɨ́ dꞌadɨ Lubə kadkare-tɨ lé uso rəm, adɨ dow-je liə dꞌuso rəm. Ngà kɨ́ go rəbɨ-é-tɨ lé, tò kadɨ njégugné-je ya par ə́ dꞌa kuso ya al wa?» ");
INSERT INTO mge_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Beɓa Jeju idə-dé panè: «Ngon lə dow lé ɓá to ꞌɓa ndɔ taakoo.» ");
INSERT INTO mge_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ndɔ kɨ́ rangɨ kɨ́ to ndɔ taakoo lə jipɨ-je ya ɓəy lé, Jeju isɨ ndó né dow-je mḛḛ kəykəwna̰-tɨ lə jipɨ-je ə dingəm káre kɨ́ jikɔl-é oy mburukɨ isɨ dan-dé-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Njéndó dow-je ndukun-je, kɨ̀ Parisi-je lé, dꞌadɨ kəm-dé tò dɔ Jeju-tɨ gə́rə́rə́ kdɔ kadɨ dꞌoo ə́ kinə ḛ adɨ lapiya dow ndɔ taakoo-tɨ rəmə je to kəm rəbɨ kɨ́ kadɨ nꞌiləi-né ta dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngà Jeju gə tagɨr kɨ́ mḛḛ-dé-tɨ. Beɓa ḛ idə dingəm kɨ́ njèjikoy lé panè: ꞌḬ ꞌa̰ taá dan dow-je-tɨ dana̰ nè; dingəm lé ubə nangɨ ḭ a̰ taá. ");
INSERT INTO mge_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Beɓa Jeju idə-dé panè: Mꞌa dəjɨ-si ta kin koo. Né kɨ́ rá ɓá to tó-é kadɨ dow ra ndɔ taakoo-tɨ wa? Ra majɨ kɨ̀ dow ɓá to tó-é əse ra siə majɨ al ɓá to tó-é wa? Kajɨ dow ɓá to tó-é əse tɔl-é ɓá to tó-é wa? ");
INSERT INTO mge_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ḛ oo-dé kɨ̀ ta bar-é bar-é lay ngá ɓá təl idə dingəm lé panè: ꞌSurə ji-i! Lokɨ ḛ surə ji-é lé ya rəmə, ji-é lé təl tò majɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngà njéndó dow-je ndukun-je, kɨ̀ Parisi-je lé, wɔngɨ ra-dé n̰a̰ adɨ ꞌnajɨ-na̰ ta dɔ né-tɨ kɨ́ kadɨ nꞌrai kɨ̀ Jeju. ");
INSERT INTO mge_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gangɨ ndɔ-é-je-tɨ kinlé, Jeju ɔw dɔ mbal-tɨ kdɔ pa ta kɨ̀ Lubə ə un lo kɨ́ ndɔɔ kin lay ya pa-né ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngà lokɨ lo aa lé, ḛ ɓa njéndó né-je liə ə mbətɨ-dé dɔgɨ gidɨ-é joo, ində ri-dé lə njékɔwkulə-je; adɨ to ");
INSERT INTO mge_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simɔ̰ kɨ́ ḛ ɓa-é Piyər kɨ̀ ngonkɔ̰-é Andre, Jakɨ, Ja̰, Pilipɨ, Batlemi, ");
INSERT INTO mge_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Tomasɨ, Jakɨ kɨ́ ngon lə Alpe, Simɔ̰ kɨ́ ɓa-é dow kɨ́ ta ɓe liə to-é, ");
INSERT INTO mge_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jude kɨ́ to ngon lə Jakɨ, ɓá Judasɨ Iskariyotɨ kɨ́ à təl njèkun dɔ Jeju. ");
INSERT INTO mge_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jeju ḭ sə-dé dɔ mbal-tɨ isɨ risɨ sə-dé nangɨ rəmə, ree a̰ lo-tɨ kɨ́ tatɨ rəsɨ kɨ́ kosɨ njéndó né-je liə n̰a̰ dꞌa̰-tɨ; lo-é-tɨ kinlé tɔ ɓá kosɨ dow-je kɨ́ ꞌtò nduy-nduy kɨ́ dɔnangɨ Jude-tɨ lay, kɨ̀ ɓebo Jorijalḛm-tɨ, kɨ̀ ɓebo-je kɨ́ kàdɨ̀ ba-tɨ, kɨ̀ dɔnangɨ Tir-tɨ, kɨ̀ dɔnangɨ Sidɔ̰-tɨ dꞌa̰-tɨ tɔ. Dḛ ꞌree kdɔ koo ta liə rəm, ɓá kdɔ kadɨ adɨ njémɔ̰y-je dꞌingə lapiya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dḛ kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé lé, dꞌingə lapiya. ");
INSERT INTO mge_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kosɨ dow-je lay ya ꞌsangɨ kadɨ dꞌɔdɨ rɔ-é, kdɔtalə tɔ́gɨ tḛḛ rɔ-é-tɨ rəmə, adɨ-dé lapiya-lapiya ya lay. ");
INSERT INTO mge_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeju un kəm-é kɨ taá oo njéndó né-je liə ə panè: Sə̰i njéndoo-je ɓá ꞌtoi njénékumə̰-je, kdɔtalə kɔ̰ɓe lə Lubə tò kdɔ-si! ");
INSERT INTO mge_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sə̰i kɨ́ ɓo isɨ ra-si ngɔsnè kin ɓá ꞌtoi njénékumə̰-je, kdɔtalə bore a kusoi né ndani ndə̰-ndə̰! Sə̰i kɨ́ isi ꞌnɔ̰i ngɔsnè kin ɓá ꞌtoi njénékumə̰-je, kdɔtalə bore a kogi. ");
INSERT INTO mge_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sə̰i kɨ́ dow-je dꞌɔsɨ-si kɨ̀ ta əse ꞌtubə-si, ꞌtajɨ-si əse ꞌmbatɨ-si titɨ dow-je kɨ́ majɨ al bè kdɔ ta lə Ngon lə dow lé ɓá ꞌtoi njénékumə̰-je. ");
INSERT INTO mge_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kḭ gangɨ ndɔ-é-tɨ kinlé ꞌrai rɔnəl ə ꞌtiləi kole, kdɔtalə nékugə dɔji kɨ́ boy n̰a̰ ya tò ngəbɨ-si dɔra̰-tɨ nɔ̰ɔ̰. Tɔgrɔ-tɨ ya, ka-dé-je kàrè, ndɔkɨ ꞌra né-é kinlé kɨ̀ njépata-je kɨ́ ta Lubə-tɨ bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngà tujɨ à kusɨ dɔ-si-tɨ, sə̰i njénékingə-je, kdɔtalə sə̰i ingəi né kɨ́ sɔl mḛḛ-si ngà! ");
INSERT INTO mge_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i kɨ́ ꞌndani ngɔsnè, kdɔ bore rəmə ɓo à ra-si. Tujɨ à kusɨ dɔ-si-tɨ, sə̰i kɨ́ isi ꞌkogi ngɔsnè, kdɔtalə a kisi dan nékəmtondoo-tɨ, kɨ̀ ta nɔ̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tujɨ à kusɨ dɔ-si-tɨ, lokɨ dow-je ꞌpa ta lə-si majɨ n̰a̰, kdɔtalə ka-dé-je ya kàrè, ndɔkɨ ꞌpa ta kɨ́ majɨ dɔ dow-je-tɨ kɨ́ dꞌədɨ ta ꞌpanè ꞌto njépata kɨ́ ta Lubə-tɨ tɔ! ");
INSERT INTO mge_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngà sə̰i kɨ́ ooi ta lə-m lé, mꞌidə-si mꞌpanè: ꞌNdigi njéba-je lə-si, ꞌrai majɨ kɨ̀ njékɔsɨ-si ta-je, ");
INSERT INTO mge_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ꞌtɔri ndi-si dɔ dow-je kɨ́ njékində ndɔl dɔ-si-tɨ, ꞌpai ta kɨ̀ Lubə kdɔ njékulə kəm-si ndoo-je. ");
INSERT INTO mge_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kinə dow ində mbɔ́-i kɨ́ káre rəmə, ꞌtəl kɨ́ káre adɨ-é ɓəy. Ə kinə dow uwə-i taa kubɨ kul lə-i rəmə, ꞌɔgɨ-é taa kubɨ kɨ́ kàdɨ̀-i-tɨ al ngá. ");
INSERT INTO mge_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dow kɨ́ rá-rá ya dəjɨ-i né ə ꞌadɨ-é, ngà lokɨ dow uwə-i taa nékingə-i rəmə, ꞌdəjɨ go-é al ngá. ");
INSERT INTO mge_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Né kɨ́ ꞌndigi kadɨ dow-je ꞌra dꞌadɨ-si lé, ga̰-é ya ꞌrai adi-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kinə dow-je kɨ́ ꞌndigɨ-si ya ɓá sə̰i ꞌndigi-dé tɔ lé, ri ɓá à tokɨ pitɨ-si kdɔ wa? Njéramajal-je ya kàrè ꞌndigɨ njéndigɨ-dé-je tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kinə dow-je kɨ́ ꞌra sə-si majɨ ya ɓá sə̰i ꞌrai sə-dé majɨ tɔ lé, ri ɓá à tokɨ pitɨ-si kdɔ wa? Njéramajal-je ya kàrè ꞌra bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ə kinə dow-je kɨ́ sə̰i indəi mḛḛ-si dɔ-tɨ kɨ́ ꞌtunə̰-si né ə dꞌa kugə-si ɓá sə̰i adi-dé lé, ri ɓá Lubə à pitɨ-si-né wa? Njéramajal-je ya kàrè, ꞌtunə̰-na̰ né kadɨ dꞌugə-na̰ né-é gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngà sə̰i lé, ꞌndigi njéba-je lə-si, ꞌrai majɨ ə adi dow-je ꞌtunə̰-si né ə ꞌgɨri kadɨ à kingəi gogɨ al. Beɓa nékugə dɔji-si à n̰a̰ rəm, a toi ngan lə Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ, kdɔ ḛ ra majɨ kɨ́ njéra oiyo al-je rəm, kɨ̀ njémḛḛndul-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ooi kəmtondoo lə dow-je titɨ kɨ́ Bɔbɨ-si isɨ oo-né kəmtondoo lə dow-je kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ꞌGangi ta dɔ dow-tɨ al ə dꞌa gangta dɔ-si-tɨ al tɔ. Ɔri ta dɔ dow-tɨ ə dꞌa kɔr ta dɔ-si-tɨ tɔ; in̰əi go kɔgɨ adi dow-je ə dꞌa kin̰ə go kɔgɨ kadɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Adi né ə dꞌa kadɨ-si tɔ. Dꞌa kungɨ né takubɨ-tɨ lə-si kadɨ rusɨ ə dꞌa mbusɨ go-é majɨ, dꞌa yəkɨ kadɨ ga̰y nangɨ wur-wur, kdɔ né kɨ́ ꞌmbɔji-né né adi dow kinlé, ḛ ya dꞌa təl mbɔjɨ-né né kadɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jeju pa sə-dé ta kɨ̀ gosta káre ɓəy panè: Njèkəmtɔ à ndɔr njèkəmtɔ madɨ-é tɔ wa? Sé dꞌa kungɨ-na̰ ɓe-tɨ joo lay ya al wa? ");
INSERT INTO mge_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Njèndó né à kitə njèndó-é né al. Ngà njèndó né kɨ́ rá-rá ya kɨ́ néndó asɨ-é majɨ lé, à titɨ-na̰ kɨ̀ njèndó-é né lé ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ban ɓá i oo wale kɨ́ tò kəm ngonkɔ̰-i-tɨ rəmə, kagɨ kɨ́ boy kɨ́ tò kəm-i-tɨ kin ɓá i oo al wa? ");
INSERT INTO mge_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ban ɓá ꞌa kidə ngonkɔ̰-i panè: «Adɨ mꞌɔr wale kɨ́ tò kəm-i-tɨ kin kɔgɨ» ə i rəmə, ꞌoo kagɨ kɨ́ boy kɨ́ tò kəm-i-tɨ kin al wa? I njèkədkəm dow-je kan! ꞌƆr kagɨ kɨ́ boy kɨ́ tò kəm-i-tɨ ya pa ɓəy ɓá ꞌa koo wale kɨ́ tò kəm ngonkɔ̰-i-tɨ kdɔ kɔr kadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kagɨ kɨ́ majɨ lé, kandɨ-é à majɨ al al ə kagɨ kɨ́ majɨ al kàrè kandɨ-é à majɨ nda̰ al tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kdɔ kagɨ kɨ́ rá-rá ya dꞌa gə-é kɨ̀ takul kandɨ-é. Dow à kijə kandɨ kote dɔ kagɨ kun-tɨ al; bè ya tɔ, dow à tɔr kandɨ nduu dɔ gərgəndi-tɨ al tɔ. ");
INSERT INTO mge_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bè ya tɔ, dow kɨ́ majɨ lé, né-je kɨ́ majɨ-majɨ kɨ́ uwə mḛḛ-é kinlé ya à tḛḛ-né. Ə dow kɨ́ majɨ al kàrè, né-je kɨ́ majɨ al majɨ al kɨ́ uwə mḛḛ-é kinlé ya ḛ à tḛḛ-né tɔ. Kdɔ né-je kɨ́ mən̰ə̰-na̰ mḛḛ dow-tɨ ya ɓá tḛḛ ta-é-tɨ adɨ-é pa. ");
INSERT INTO mge_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kdɔ ri ɓá ꞌɓai-mi «ꞌƁaɓe, ꞌƁaɓe» ya rəmə ꞌtəli rɔ-si go ta-tɨ kɨ́ mꞌpa al wa? ");
INSERT INTO mge_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dow kɨ́ rá-rá kɨ́ ree rɔ-m-tɨ, oo ta-je lə-m ə təl rɔ-é go-tɨ lé, mꞌa tɔjɨ-si kadɨ ooi sé titɨ-na̰ kɨ̀ dow kɨ́ ban wa: ");
INSERT INTO mge_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ḛ titɨ-na̰ kɨ̀ dow kɨ́ ɔw kɨ̀ kində kəy rəmə, ijə ɓe adɨ uu n̰a̰, tḛḛ dɔ ər-tɨ ɓá ində gin kəy titɨ; beɓa lokɨ man ulə, adɨ pungum man ində kəy lé pungum-pungum ya, ngà kəy lé yəkɨ al, kdɔ dow lé ində kəy lé majɨ. ");
INSERT INTO mge_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngà dow kɨ́ oo ta lə-m ɓá təl rɔ-é go-tɨ al lé, titɨ-na̰ kɨ̀ dow kɨ́ ində kəy nangray-tɨ ə ində gin-é majɨ al rəm tɔ. Beɓa lokɨ pungum man ində kəy lé rəmə, tajinatɨ nè ya tɔɔ nangɨ rum-rum adɨ kəy-é tujɨ tujɨ kɨ́ dum natɨ. ");
INSERT INTO mge_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lokɨ Jeju pa ta-je kin lay adɨ dow-je ngá lé, ḛ təl ɔw ɓebo Kapɛrnayim-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ɓe-é-tɨ kinlé njèkun dɔ kutɨ asgar-je kɨ́ ɓu ɔw kɨ̀ ngonnjèkullə liə káre kɨ́ rɔ-é to-é adɨ tò ta koy-tɨ, ə to ngonnjèkullə liə kɨ́ ḛ ndigɨ-é n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Beɓa lokɨ njèkun dɔ kutɨ asgar-je oo poy Jeju lé, ḛ ulə ꞌngatɔ́gɨ-je lə jipɨ-je kadɨ dꞌɔw ꞌra ndoo ta-é-tɨ kadɨ-é ree ajɨ ngonnjèkullə lə nꞌḛ̀ lé. ");
INSERT INTO mge_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ꞌNgatɔ́gɨ-je lé, dꞌɔtɨ dꞌɔw rɔ Jeju-tɨ ə ꞌnɔ̰ ta-é-tɨ n̰a̰ ꞌpanè: Ḛ lé, tuwə kadɨ ꞌra né kɨ́ dəjɨ-i kinlé adɨ-é ya! ");
INSERT INTO mge_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kdɔtalə ḛ ndigɨ gin dow-je lə-ji rəm, ɓá ḛ ya ində kəykəwna̰ lə-ji adɨ-ji rəm tin. ");
INSERT INTO mge_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Beɓa Jeju ɔtɨ ɔw sə-dé, ə lokɨ ꞌtḛḛ ngɔsi kɨ̀ kəy liə ya rəmə, njèkun dɔ asgar-je kɨ́ ɓu lé ulə nam-é-je adɨ dꞌidə Jeju ꞌpanè: «ꞌƁaɓe, ꞌadɨ rɔ-i kɔ̰̀ n̰a̰ bè al, kdɔ ma̰ lé mꞌtuwə kadɨ ꞌree mḛḛ kəy-tɨ lə-m al.» ");
INSERT INTO mge_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Gin-é kin ya ɓá mꞌa ya mꞌoo kɨ́ mꞌtuwə kɔw-né rɔ-i-tɨ al tɔ. Ngà i ꞌpa ta káre-rè ya par ə ngonnjèkullə lə-m lé à kingə lapiya. ");
INSERT INTO mge_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kdɔtalə ma̰ kɨ̀ dɔ-m mꞌisɨ gin tɔ́gɨ-tɨ lə dow-je kɨ́ dɔ-m-tɨ rəm, mꞌɔw kɨ̀ asgar-je gin tɔ́gɨ-tɨ lə-m rəm. Adɨ kinə mꞌidə ḛ kɨ́ káre mꞌpanè: «ꞌƆw!» ə ɔtɨ ɔw. Ə kinə mꞌidə ḛ kɨ́ rangɨ mꞌpanè: «ꞌRee!» ə ɔtɨ ree. Ə kinə mꞌidə ngonnjèkullə lə-m mꞌpanè: «ꞌRa né kin» ə ɔtɨ ra né-é. ");
INSERT INTO mge_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lokɨ Jeju oo ta-je kɨ́ ḛ pa kin bè lé, pitɨ-é ə təl kəm-é kɨ rɔ kosɨ dow-je-tɨ kɨ́ dꞌun go-é ɓá idə-dé panè: Mꞌidə-si mꞌadɨ ooi; dɔnangɨ israyel-tɨ ya kàrè mꞌingə ko kadmḛḛ kɨ́ tana̰ bè kin nja káre al ɓəy! ");
INSERT INTO mge_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lokɨ dḛ kɨ́ njèkun dɔ asgar-je ulə-dé lé, ꞌtəl ꞌree kəy gogɨ rəmə, ngonnjèkullə kɨ́ rɔ-é to-é lé, dḛ dꞌingə-é isɨ kɨ̀ lapiya kare ngá. ");
INSERT INTO mge_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Go-tɨ, Jeju ɔtɨ ɔw kɨ mḛḛ ɓebo-tɨ káre kɨ́ ꞌɓa-é Nayin. Njéndó né-je liə rəm, kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌuwə siə rəbɨ. ");
INSERT INTO mge_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lokɨ Jeju ree tḛḛ ngɔsi kɨ̀ tarəbɨ kɔw mḛḛ ɓebo-tɨ ya rəmə, dow-je dꞌun nin dꞌisɨ dꞌɔw-né kɨ ɓada. To nin ngon kàl lə dené kɨ́ njèngɔwkoy káre bè. Kosɨ dow-je kɨ́ mḛḛ ɓebo-tɨ kɨ́ ꞌtò nduy-nduy ya ꞌdan dené lé bul-bul. ");
INSERT INTO mge_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Beɓa lokɨ ꞌƁaɓe Jeju oo dené lé rəmə, ta ɔ̰̀ mḛḛ-é kdɔ ta liə adɨ idə-é panè: ꞌNɔ̰ al ngá! ");
INSERT INTO mge_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Go-tɨ, Jeju ɔtɨ kɨ kete ɔdɨ rɔ kɛsɨ yo lé, ə dḛ kɨ́ dꞌun kɛsɨ lé ꞌtəl dꞌa̰ nangɨ ə Jeju panè: Basa, mꞌun ndu mꞌadɨ-i, ꞌḭ taá. ");
INSERT INTO mge_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lokɨ ḛ pa bè rəmə, dow kɨ́ oy lé, ḭ isɨ taá ə pa ta. Go-tɨ, Jeju ulə-é ji kɔ̰-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dow-je lay ya ɓəl ində bandɨ-dé gangɨ adɨ dꞌɔsɨ gajɨ Lubə ꞌpanè: Dow kɨ́ boy kɨ́ to njèpata kɨ́ ta Lubə-tɨ ya tḛḛ kɔy dan-ji-tɨ nè rəm, Lubə ree ilə kəm-é dɔ dow-je-tɨ liə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta kɨ́ dow-je ꞌpa dɔ Jeju-tɨ kinlé taa lo kɨ́ dɔnangɨ Jude-tɨ lay rəm, ɓá taa lo-je lay kɨ́ gəə dɔ dɔnangɨ Jude rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Njéndó né-je lə Ja̰ kɨ́ njèra dow-je batḛm dꞌɔr poy né-je kinlé, dꞌadɨ Ja̰ oo. ");
INSERT INTO mge_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Beɓa ḛ ɓa dow-je joo dan njéndó né-je-tɨ liə ulə-dé rɔ ꞌƁaɓe-tɨ kadɨ ꞌdəjɨ-é ꞌpanè: I ya ɓá ꞌto dow kɨ́ tò kadɨ à ree lé əse tò kadɨ jꞌngəbɨ dow kɨ́ rangɨ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dingəm-je kinlé ꞌree ꞌtḛḛ rɔ Jeju-tɨ ə dꞌidə-é ꞌpanè: Ja̰ kɨ́ njèra dow-je batḛm ɓá ulə-ji rɔ-i-tɨ kadɨ jꞌdəjɨ-i jꞌoo sé i ya ɓá ꞌto dow kɨ́ tò kadɨ à ree lé əse tò kadɨ jꞌngəbɨ dow kɨ́ rangɨ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lokɨ dꞌa̰ rɔ Jeju-tɨ lé, njémɔ̰y-je, kɨ̀ njémətɨ-je n̰a̰ ya Jeju adɨ-dé lapiya rəm, tubə ndil-je kɨ́ majɨ al dɔ dow-je-tɨ rəm, ɓá njékəmtɔ-je kàrè adɨ kəm-dé oo lo rəm tɔ ");
INSERT INTO mge_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Beɓa dow-je kɨ́ Ja̰ ulə-dé lé, Jeju ilə-dé-tɨ panè: Né-je kɨ́ ooi kɨ̀ kəm-si, kɨ̀ ta-je kɨ́ ooi kɨ̀ mbi-si lé, ɔwi ɔri poy-é adi Ja̰ lé tokɨ njékəmtɔ-je dꞌoo lo rəm, njémətɨ-je ꞌnjiyə majɨ rəm, njébanjɨ-je kàrè banjɨ lə-dé ur adɨ dꞌaa njay rəm, njémbitɔ-je dꞌoo ta rəm, dow-je kɨ́ dꞌoy kàrè ꞌtɔsɨ ꞌndəl rəm, ɓá njéndoo-je kàrè mbḛ Poyta kɨ́ Majɨ usɨ mbi-dé-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dow kɨ́ mꞌtəl gin kusɨ liə al ɓá to njènékumə̰! ");
INSERT INTO mge_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lokɨ dow-je kɨ́ Ja̰ ulə-dé ꞌtəl dꞌɔw rəmə, Jeju pa ta kɨ́ dɔ Ja̰-tɨ adɨ kosɨ dow-je panè: To ri ɓá ɔwi diləlo-tɨ ooi wa? To tuwətɔ́gɨ kɨ́ yə́l isɨ ɔw siə yó-je kɨ nè-je kin ɓá ɔwi ooi wa? ");
INSERT INTO mge_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kinə bè al, ngà to ri ya ɓá ɔwi ooi wa? To dow kɨ́ tulə kubɨ-je kɨ́ kurə́-kurə́ rɔ-é-tɨ ɓá ɔwi ooi-é wa? Ngà, lé to ḛ kàrè, dḛ kɨ́ ꞌtulə kubɨ-je kɨ́ là-é n̰a̰-n̰a̰ kɨ̀ dḛ kɨ́ dꞌisɨ dan nékingə-je-tɨ mburukɨ-mburukɨ bè kinlé, dꞌisɨ mḛḛ kəy-tɨ lə ngar-je yó rəm. ");
INSERT INTO mge_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngà se to ri ya dana̰ ɓá ɔwi ooi wa? To njèpata kɨ́ ta Lubə-tɨ ɓá ɔwi ooi-é wa? Tɔgrɔ-tɨ, mꞌa kidə-si, to dow kɨ́ itə njèpata kɨ́ ta Lubə-tɨ sa̰y ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kdɔ to Ja̰ kin ɓá ndɔkɨ ꞌndàngɨ ta kɨ́ dɔ-é-tɨ ꞌpanè: Yən, ma̰ Lubə mꞌulə njèkilə mbḛ lə-m nɔ̰̀-i-tɨ kete, kdɔ kadɨ ɔw ra rəbɨ lə-i adɨ-i. ");
INSERT INTO mge_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jeju ilə dɔ-tɨ panè: Mꞌa kidə-si; dan dow-je-tɨ lay kɨ́ dené-je dꞌojɨ-dé lé, ḛ kɨ́ to dow kɨ́ boy itə Ja̰ ya goto. Bè ya kàrè, dow kɨ́ ndḛ bè mḛḛ kɔ̰ɓe-tɨ lə Lubə lé, boy itə-é. ");
INSERT INTO mge_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Njétaalambo-je, kɨ̀ dow-je lay kɨ́ dꞌoo ta ndó lə Ja̰, ɓá ꞌree dꞌadɨ ra-dé batḛm lé, ꞌgə kɨ́ Lubə to njèra né kɨ́ njururu. ");
INSERT INTO mge_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngà Parisi-je, kɨ̀ njéndó dow-je ndukun-je ꞌmbatɨ kɔjɨ ra-je lə Lubə kɨ́ tò kdɔ ta lə-dé, adɨ dꞌadɨ Ja̰ ra-dé batḛm al. ");
INSERT INTO mge_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ná̰ ɓá mꞌa kun-é kɔjɨ-né dow-je kɨ́ ngɔsnè kan wa? Dḛ titɨ-na̰ kɨ̀ ná̰-je ə́n wa? ");
INSERT INTO mge_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dḛ ꞌtitɨ-na̰ kɨ̀ ngan-je kɨ́ dꞌisɨ pandangɨ lo-tɨ ɓá ꞌɓa-na̰ ə ꞌpa-na̰ ta ꞌpanè: «Jꞌkɔl nal kàrè ꞌndami-né al rəm, ɓá jꞌusɨ pa nɔ̰ yo kàrè ꞌnɔ̰i-né al rəm.» ");
INSERT INTO mge_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jeju təl ilə dɔ-tɨ panè: Mꞌpa bè kdɔ lokɨ Ja̰ kɨ́ njèra dow-je batḛm ree, ɓá uso né al rəm, a̰y yibɨ al rəm lé, sə̰i ꞌpai-nè: «To dow kɨ́ ndil kɨ́ majɨ al ra-é.» ");
INSERT INTO mge_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngà Ngon lə dow ree ɓá uso-je, a̰y-je rəmə, sə̰i ꞌpai-nè: Ḛ kanlé uso né bore ngay rəm, to njèka̰y né rəm, ɓá to nam njétaalambo-je, kɨ̀ njéramajal-je rəm. ");
INSERT INTO mge_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngà dow-je lay kɨ́ njétəl rɔ-dé go ta-tɨ lə Lubə lé, ꞌgə kɨ́ gosɨ lə Lubə to gosɨ kɨ́ tɔgrɔ-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi káre bè kɨ́ ri-é lə Simɔ̰, ɓa Jeju kadɨ ɔw uso né. Beɓa ḛ ɔtɨ ɔw ɓe lə Parisi lé ə isɨ ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Rəmə dené káre kɨ́ to njèramajal isɨ mḛḛ ɓebo-tɨ kin nɔ̰ɔ̰. Lokɨ dené lé, oo kɨ́ Jeju isɨ uso né ɓe lə Parisi kinlé nɔ̰ɔ̰ rəmə, ḛ un ku kɨ́ ubɨ kɨ́ ətɨ majɨ rusɨ mḛḛ-é, kɨ́ to ku kɨ́ ꞌra kɨ́ ər kɨ́ ꞌɓa-é «albatrə», ");
INSERT INTO mge_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ree isɨ-né nangɨ nja Jeju-tɨ go-é-tɨ gogɨ. Ḛ nɔ̰ adɨ man kəm-é ndogɨ nja Jeju sukɨ-sukɨ ə uwə bəl dɔ-é bɔr-né ə tɔ̰n nja-é lé rəm, ɓá ur ubɨ kɨ́ ətɨ majɨ lé titɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lokɨ Parisi kɨ́ njèɓa Jeju lé, oo né kin bè rəmə pa mḛḛ-é-tɨ panè: Kinə dingəm kin to njèpata kɨ́ ta Lubə-tɨ ya lé, ḛ à gə dené kɨ́ isɨ ɔdɨ rɔ-é kinlé rəm, ɓá à gə kɨ́ dené kinlé to njèramajal rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Beɓa Jeju un ta panè: Simɔ̰, mꞌɔw kɨ̀ ta nè kadɨ mꞌidə-i. Simɔ̰ ilə-é-tɨ panè: Njèndó dow-je né, ꞌpa. ");
INSERT INTO mge_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Beɓa Jeju panè: Dingəm káre bè kɨ́ to njèkində là tunə̰-tɨ, ɔw kɨ̀ kurə liə dɔ dow-je-tɨ joo. Ḛ kɨ́ káre, kurə tò dɔ-é-tɨ asɨ kəm là kullə kɨ́ dow ra ndɔ ɓumḭ ə ḛ kɨ́ káre, kurə tò dɔ-é-tɨ asɨ kəm là kullə kɨ́ dow ra ndɔ kɔrmḭ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lokɨ dḛ dꞌɔw kɨ̀ né kɨ́ kadɨ dꞌugə-né al lé, ḛ ra sə-dé majɨ adɨ ɔr kurə lé kɔgɨ dɔ-dé-tɨ joo lay. Ná̰ dan-dé-tɨ ɓá à ndigɨ njèkində là tunə̰-tɨ lé tɔy madɨ-é wa? ");
INSERT INTO mge_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ̰ ilə-é-tɨ panè: Ḛ kɨ́ njèkində là tunə̰-tɨ ɔr kurə kɨ́ n̰a̰ dɔ-é-tɨ kɔgɨ kinlé, mꞌgɨr kɨ́ à to ḛ ɓá à ndigɨ njèkində là tunə̰-tɨ lé n̰a̰. Beɓa Jeju panè: Ḛ ya ə́ ꞌpa majɨ tin! ");
INSERT INTO mge_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Go-tɨ, Jeju təl kəm-é kɨ rɔ dené-tɨ lé ngá ɓá idə Simɔ̰ lé panè: ꞌOo dené kinlé majɨ! Mꞌree kəy lə-i ya ə́ adɨ-m man mꞌtogɨ-né nja-m al. Ngà dené kinlé, man kəm-é ndogɨ nja-m sukɨ-sukɨ ɓá təl bɔr kɨ̀ bəl dɔ-é. ");
INSERT INTO mge_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","I uwə-m kɨ kàdɨ̀-i-tɨ al, ngà dené kinlé, kɨ́ low nṵ kɨ́ mꞌree kəy kin ya, ḛ isɨ ká tɔ̰n nja-m-tɨ ya par-par ə́n. ");
INSERT INTO mge_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","I ur ubɨ dɔ-m-tɨ ꞌun-né ta-m al, ngà dené kinlé, ḛ ur ubɨ kɨ́ ətɨ majɨ ya nja-m-tɨ un-né ta-m. ");
INSERT INTO mge_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gin-é kin ɓá mꞌidə-i, majal-je liə kɨ́ n̰a̰ kɨ́ tokɨ kin̰ə go-é kɔgɨ kadɨ-é kin ɓá, ḛ ndigɨ-m-né n̰a̰ tin. Ngà dow kɨ́ majal-je liə tokɨ kin̰ə go-é kɔgɨ n̰a̰ al lé, ḛ ndigɨ-m n̰a̰ al ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Go-tɨ, Jeju idə dené lé panè: Majal-je lə-i tokɨ kin̰ə go-é kɔgɨ! ");
INSERT INTO mge_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Rəmə dḛ kɨ́ dꞌisɨ ta nékuso-tɨ natɨ kɨ̀ Jeju lé ꞌpa ta mḛḛ-dé-tɨ ꞌpanè: Ḛ kanlé to dow kɨ́ ban ya ɓá ɔw mbing ya oo rɔ-é kɨ njèkin̰ə go majal-je lə dow-je kɔgɨ ɓəy tin wa? ");
INSERT INTO mge_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngà Jeju idə dené lé panè: Kadmḛḛ lə-i ajɨ-i, ꞌɔw kɨ̀ lapiya! ");
INSERT INTO mge_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Go ndɔ-je-tɨ kinlé, Jeju ɔw kɨ̀ nganɓe-je kɨ̀ ɓebo-je ɔw ndó dow-je ta lə Lubə, ɓá ilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo dꞌɔw siə natɨ rəm, dené-je kɨ́ dan-tɨ-je kɨ́ ndɔkɨ ḛ tubə ndil-je kɨ́ majɨ al dɔ-dé-tɨ kɨ̀ dḛ kɨ́ mɔ̰y-je kɨ́ gay-gay ra-dé ɓá ḛ adɨ-dé lapiya lé kàrè, dꞌɔw siə natɨ tɔ. Dḛ ɓá ꞌto: Mari kɨ́ ɓa-é Mari kɨ́ Magdala kɨ́ ndɔkɨ Jeju tubə ndil-je kɨ́ majɨ al siri dɔ-é-tɨ kɔgɨ lé rəm, ");
INSERT INTO mge_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jan kɨ́ to ne Suja kɨ́ to njèkoo go né-je lə Ngar Erodɨ rəm, Sujan rəm, ɓá dené-je kɨ́ rangɨ n̰a̰ kɨ́ ꞌto njéra sə-dé kɨ̀ nékingə-dé-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lokɨ kosɨ dow-je kɨ́ ꞌtò nduy-nduy dꞌḭ kɨ̀ ɓebo-je kɨ́ gay-gay ꞌree ꞌkəw-na̰ rɔ Jeju-tɨ lé, ḛ idə-dé gosta kin panè: ");
INSERT INTO mge_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Njèndɔr ɔw kdɔ kilə ko liə. Lokɨ a̰ ilə rəmə, ka̰a̰ né kɨ́ dan-tɨ-je tusɨ dɔ rəbɨ-tɨ adɨ dow-je mbəjrə nja-dé-tɨ ə yəl-je kɨ́ ꞌnar taá ꞌree ꞌtú lə̰́-lə̰́. ");
INSERT INTO mge_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka̰a̰ né kɨ́ ná̰-je tusɨ dɔ ər-tɨ; lokɨ ubə rəmə, tutɨ kurum kdɔtalə ingə lo kɨ́ sɔl al. ");
INSERT INTO mge_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka̰a̰ né kɨ́ madɨ-je tusɨ dan kun-je-tɨ; lokɨ ubə rəmə kun tɔgɨ siə natɨ adɨ ɔ̰̀ rɔ dɔ-tɨ gə́gə́gə́. ");
INSERT INTO mge_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ngà ka̰a̰ né kɨ́ ná̰-je tusɨ nangɨ-tɨ kɨ́ majɨ; lokɨ ubə rəmə, ɔr dɔ-é; dɔ-é káre ya ka̰a̰-é ra-tɨ ɓu-ɓu. Lokɨ Jeju pa ta kin bè rəmə, ilə bɔbɨ ndi-é nangɨ panè: Dow kɨ́ mbi-é tò nɔ̰ɔ̰ kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé! ");
INSERT INTO mge_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Beɓa njéndó né-je liə ꞌdəjɨ-é ꞌpanè: Se gosta kinlé, kɔr mḛḛ-é to ri wa? ");
INSERT INTO mge_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jeju idə-dé panè: Sə̰i lé, né-je kɨ́ tò lo ɓɔyɔ-é-tɨ sɔbɨ dɔ kɔ̰ɓe lə Lubə lé tokɨ tḛḛ kɨ̀ dɔ-é kadɨ-si. Ngà dow-je kɨ́ rangɨ lé, tokɨ kidə-dé kɨ̀ gosta kdɔ kadɨ lé dꞌoo lo kàrè dꞌoo kɨ koo ya ndə̰ bè rəm, ɓá lé dꞌoo ta kàrè kadɨ ꞌgə mḛḛ-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ooi bè, kɔrmḛḛ gosta lé ə́n: Ko né lé, to ta lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dɔ rəbɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dow-je kɨ́ dꞌoo ta lə Lubə ya rəmə, Sú ree ɔr mḛḛ-dé-tɨ kɔgɨ, nè dꞌa kḭ kadɨ mḛḛ-dé kdɔ kajɨ-né. ");
INSERT INTO mge_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka̰a̰ né kɨ́ tusɨ dɔ ər-tɨ lé, to dḛ kɨ́ lokɨ dꞌoo ta lə Lubə ə ꞌtaa kɨ̀ rɔnəl ya, ngà kulə ɓá ulə njirə mḛḛ-dé-tɨ al; adɨ dꞌadɨ mḛḛ-dé kɨ mbɔr al; ə lokɨ kɔ̰̀-je ree tḛḛ dɔ-dé-tɨ rəmə, dḛ ꞌtusɨ kadmḛḛ lə-dé dꞌin̰ə kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dan kun-je kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə ya, ngà lokɨ dꞌɔtɨ dꞌɔw rəmə, mḛḛ ka̰ kə́kə́kə́-je, kɨ̀ ɓo nékingə-je, kɨ̀ ɓo né-je kɨ́ dɔnangɨ-tɨ nè ɔ̰̀ ɓe dɔ-dé-tɨ adɨ kadmḛḛ lə-dé lé kandɨ-é goto. ");
INSERT INTO mge_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ngà nangɨ kɨ́ majɨ kɨ́ ka̰a̰ né tusɨ-tɨ lé, to dḛ kɨ́ dꞌoo ta lə Lubə ə ndigɨ dɔ-tɨ ndigɨ kɨ́ tɔgrɔ-tɨ rəm, dꞌuwə rɔ-dé nga̰ mḛḛ-é-tɨ adɨ kandɨ kadmḛḛ lə-dé tò. ");
INSERT INTO mge_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Dow ində pər lampɨ-tɨ ə à səbɨ ngó dɔ-tɨ al ngá; ɓá à kində gin tɨrə-tɨ al rəm; ngà à na̰a̰ kagna̰a̰ lampɨ-tɨ taá, kdɔ kadɨ dow-je kɨ́ dꞌɔw mḛḛ kəy-tɨ dꞌoo ndógɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kdɔ né kɨ́ dow ɓɔyɔ kɨ́ à ree tò ndaa-tɨ rəsɨ al ya goto rəm, né kɨ́ dow ra kɨ̀ gidɨ ngə̰y kɨ́ à tokɨ gə al ya goto rəm, ɓá kɨ́ à tokɨ tḛḛ-né ndaa-tɨ rəsɨ al ya goto rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ooi majɨ, lokɨ isɨ ooi ta lé, indəi mbi-si majɨ ya ooi-né, kdɔ dow kɨ́ né tò ji-é-tɨ ɓá dꞌa kadɨ-é kɨ́ rangɨ dɔ-tɨ, ngà dow kɨ́ né liə goto lé, né kɨ́ ḛ gɨr panè to ꞌlə-nꞌḛ̀ kin ya kàrè dꞌa taa ji-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kɔ̰ Jeju kɨ̀ ngankɔ̰-é-je ꞌree rɔ-é-tɨ; ngà lo kadɨ dꞌingə-é goto, kdɔ kosɨ dow-je dꞌutɨ lo kə́kə́. ");
INSERT INTO mge_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Beɓa dꞌidə-é ꞌpanè: Kɔ̰-i kɨ̀ ngankɔ̰-i-je dꞌa̰ ta-i-tɨ ndaa-tɨ nɔ̰ɔ̰, ꞌndigɨ koo-i. ");
INSERT INTO mge_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngà Jeju ilə-dé-tɨ panè: Dow-je kɨ́ dꞌoo ta lə Lubə ə ꞌtəl rɔ-dé go-tɨ kin ɓá ꞌto kɔ̰-m-je kɨ̀ ngankɔ̰-m-je. ");
INSERT INTO mge_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ndɔ káre bè, Jeju al mḛḛ tò-tɨ kɨ̀ njéndó né-je liə ɓá idə-dé panè: «Adɨ jꞌgangi babo jꞌɔwi turə.» Beɓa dḛ dꞌɔtɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lokɨ ꞌnəl tò dꞌisɨ dꞌɔw rəmə, Jeju tò ɓi ə yə́lbo ubə-dé nangɨ busɨ, ulə mbḭ-mbḭ dɔ ba-tɨ, man ɔw kɨ̀ rusɨ tò, adɨ dḛ dꞌisɨ ta tujɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Beɓa ꞌngəsɨ kɨ rɔ Jeju-tɨ ꞌndəl-é panè: «Njèndó dow-je né, njèndó dow-je né, ko-ji à tɔɔ ɓoo!» Lokɨ Jeju tḛḛ kəm-é lé, ḛ ndángɨ yə́l-je kɨ̀ pungum man-je adɨ ꞌtaa koo adɨ lo təl tò ndingɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Go-tɨ, Jeju dəjɨ-dé panè: Kadmḛḛ lə-si tò rá wa? Ngà njéndó né-je rəmə, né kɨ́ ra né lé, ra-dé ɓəl n̰a̰ rəm, ɔr ndil-dé rəm, adɨ ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: Kay! Dow kanlé, to dow kɨ́ ban wa? Ooi, yə́l-je kɨ̀ man-je kàrè, ḛ ndángɨ-dé rəmə dḛ ꞌtəl rɔ-dé go ta-tɨ liə! ");
INSERT INTO mge_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dḛ ꞌgangɨ babo dꞌɔw dɔnangɨ Gerasa-tɨ kɨ́ sɔbɨ dɔ-na̰ kɨ́ dɔnangɨ Galile. ");
INSERT INTO mge_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lokɨ Jeju ḭ mḛḛ tò-tɨ ur nangɨ ya rəmə, dingəm káre kɨ́ mḛḛ ɓebo-tɨ nɔ̰ɔ̰, kɨ́ to dingəm kɨ́ ndil-je kɨ́ majɨ al ꞌra-é, ḭ ree rɔ-é-tɨ. Dingəm kinlé, ulə kubɨ rɔ-é-tɨ al ya low nṵ, ɓá tò kəy al rəm; ngà lo tò-é tò dɔɓadɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lokɨ oo Jeju rəmə, ur kɔɔl, usɨ nja-é-tɨ ɓá ilə bɔbɨ ndi-é nangɨ panè: Jeju, Ngon lə Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ, ꞌge ri rɔ-m-tɨ wa, mꞌnɔ̰ ta-i-tɨ, ꞌra-m majɨ al al. ");
INSERT INTO mge_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Dingəm lé pa bè, kdɔtalə Jeju ndángɨ ndil kɨ́ majɨ al lé kadɨ-é tḛḛ mḛḛ-é-tɨ kɔgɨ. Ndil kɨ́ majɨ al kinlé isɨ mḛḛ dingəm-tɨ kin low nṵ, adɨ dꞌilə sil ji-é-tɨ-je kɨ̀ nja-é-tɨ-je ya, ngà ḛ tuwə gangɨ kɔgɨ kɔgɨ. Ndil kɨ́ majɨ al lé, ɔsɨ-é ɔw siə diləlo-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jeju dəjɨ-é panè: Ri-i lə ná̰ wa? Ḛ panè: Ri-m lə «kosɨ-je.» Ḛ pa bè, kdɔtalə ndil-je kɨ́ majɨ al ꞌn̰a̰ mḛḛ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndil-je kɨ́ majɨ al kinlé, ꞌnɔ̰ ta Jeju-tɨ kdɔ kadɨ un ndu adɨ nꞌɔwi boleɓe-tɨ kɨ́ sɔ̰y-é goto kin al. ");
INSERT INTO mge_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lokɨ dꞌa̰-tɨ kinlé, kosɨ kɔsɔngɨ-je dꞌa̰ dꞌuso né dɔ mbal-tɨ ngɔsi nɔ̰ɔ̰. Beɓa ndil-je kɨ́ majɨ al lé ꞌra ndoo ta Jeju-tɨ kadɨ in̰ə-dé adɨ nꞌɔwi mḛḛ kɔsɔngɨ-je-tɨ, ə Jeju ndigɨ sə-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndil-je kɨ́ majɨ al lé, ꞌtḛḛ mḛḛ dingəm-tɨ lé, ꞌtur mḛḛ kɔsɔngɨ-je-tɨ, adɨ kɔsɔngɨ-je lé ꞌtətɨ-na̰ yipɨ kàdɨ̀ mbal-tɨ taá ꞌtusɨ babo-tɨ ꞌnduy man. ");
INSERT INTO mge_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lokɨ njéngəm kɔsɔngɨ-je dꞌoo né kɨ́ ra né kin bè lé, dꞌa̰y dꞌɔw dꞌɔr poy-é mḛḛ ɓebo-tɨ rəm, mḛḛ nganɓe-je-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Beɓa dow-je dꞌɔw kdɔ koo né kɨ́ ra né lé; lokɨ dꞌɔw ꞌtḛḛ rɔ Jeju-tɨ rəmə dꞌingə dingəm kɨ́ ndil-je kɨ́ majɨ al ꞌtḛḛ mḛḛ-é-tɨ kɔgɨ lé, isɨ nja Jeju-tɨ; ulə kubɨ rɔ-é-tɨ rəm, təl isɨ majɨ kare rəm, adɨ ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dow-je kɨ́ dꞌoo né-je kɨ́ ra né kin kɨ̀ kəm-dé lé, dꞌidə-dé kəm rəbɨ kɨ́ dingəm kɨ́ ndil-je kɨ́ majɨ al dꞌisɨ mḛḛ-é-tɨ ingə-né lapiya lé. ");
INSERT INTO mge_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Go-tɨ, dow-je kɨ́ dɔnangɨ Gerasa-tɨ lay ya ɓəl ində bandɨ-dé gangɨ, adɨ ꞌdəjɨ Jeju kadɨ in̰ə-dé ə ɔw rangɨ. Beɓa Jeju al mḛḛ tò-tɨ kdɔ kɔsɨ təl gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Rəmə, dingəm kɨ́ ndil-je kɨ́ majɨ al ꞌtḛḛ mḛḛ-é-tɨ kɔgɨ lé, nɔ̰ ta Jeju-tɨ kadɨ nꞌɔw siə. Ngà Jeju tubə-é panè: ");
INSERT INTO mge_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ꞌTəl ꞌɔw ɓee lə-i gogɨ, ꞌɔw ꞌɔr poy né-je lay kɨ́ Lubə ra sə-i kin. Beɓa dingəm lé ɔw ɔr poy né-je kɨ́ Jeju ra siə kin lay adɨ ta-é sane kɨ̀ mḛḛ ɓebo lay. ");
INSERT INTO mge_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lokɨ Jeju təl ree ngangɨ ba-tɨ kɨ́ Galile gogɨ lé, kosɨ dow-je dꞌuwə-é kɨ rɔ-dé-tɨ, kdɔtalə dḛ lay ya dꞌa̰ ɗingɨ-ɗingɨ dꞌa̰ ꞌngəbɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lo-é-tɨ kinlé, dingəm káre ri-é lə Jayrusɨ ree rɔ Jeju-tɨ. Jayrusɨ lé to ꞌboy kɨ́ dɔ kəykəwna̰-tɨ lə jipɨ-je. Ḛ ree usɨ nja Jeju-tɨ nɔ̰ ta-é-tɨ kadɨ ɔw siə mḛḛ kəy-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kdɔtalə ngon-é kɨ́ dené kɨ́ káre-rè kɨ́ à ra ɓal dɔgɨ gidɨ-é joo je bè tò oy kəy nɔ̰ɔ̰. Lokɨ Jeju isɨ ɔw siə kɨ ɓee lé, kosɨ dow-je dꞌul-na̰ go-é-tɨ mbuu, adɨ mbore-é yó-je kɨ nè-je. ");
INSERT INTO mge_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rəmə dené káre kɨ́ məsɨ ree rɔ-é-tɨ ɓal dɔgɨ gidɨ-é joo a̰ dan-dé-tɨ nɔ̰ɔ̰. Ḛ tujɨ nékingə-é lay kɔgɨ ɓe lə dɔktur-je kàrè, dow kɨ́ asɨ kadɨ-é lapiya goto. ");
INSERT INTO mge_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dené lé tḛḛ gidɨ Jeju-tɨ ree ɔdɨ rɔ takubɨ liə, rəmə tajinatɨ nè ya gin məsɨ liə gangɨ ɗəsɨ. ");
INSERT INTO mge_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jeju dəjɨ panè: Ná̰ ɔdɨ rɔ-m wa? Rəmə dow-je lay ya ꞌnajɨ, ɓá Piyər idə-é panè: Njèndó dow-je né, kosɨ dow-je kɨ́ dꞌilə-na̰ ꞌgəə dɔ-i ə́ dꞌul-na̰ dɔ-i-tɨ mbuu, ꞌmbor-i yó-je kɨ nè-je kin ya i ꞌdəjɨ dow kɨ́ ɔdɨ rɔ-i ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngà Jeju ilə-é-tɨ panè: Dow ɔdɨ rɔ-m nɔ̰ɔ̰. Kdɔtalə mꞌgə kɨ́ tɔ́gɨ kɨ́ rɔ-m-tɨ tḛḛ. ");
INSERT INTO mge_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lokɨ dené oo kɨ́ gin-nꞌḛ̀ tḛḛ lé, ḛ dadɨ par-par usɨ nja Jeju-tɨ pa ta rəsɨ takəm dow-je-tɨ ɔr-né gin né kɨ́ ɔdɨ-né rɔ Jeju lé rəm, idə-dé-né kəm rəbɨ kɨ́ ingə-né lapiya tajinatɨ nè lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Beɓa Jeju idə-é panè: Ngon-m kɨ́ dené, kadmḛḛ lə-i ajɨ-i; ꞌɔw kɨ̀ lapiya. ");
INSERT INTO mge_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lokɨ Jeju a̰ pa ta bè ya ɓəy rəmə, dow ḭ mḛḛ kəy-tɨ lə Jayrusɨ kɨ́ to njèkun dɔ kəykəwna̰ lə jipɨ-je lé, ree idə-é panè: Ngon-i kɨ́ dené lé uwə ta-é natɨ, ə́n ə́ ꞌndɔjɨ njèndó né dow-je lé al ngá! ");
INSERT INTO mge_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngà lokɨ Jeju oo ta kinlé, ḛ idə Jayrusɨ lé panè: «ꞌƁəl al, mḛḛ-i ya ꞌadɨ-m par ə ngon-i kɨ́ dené lé, à kingə lapiya.» ");
INSERT INTO mge_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lokɨ Jeju ɔw tḛḛ ɓe lə Jayrusɨ lé, ḛ adɨ dow kɨ́ rangɨ ɔw siə kəy al, ngà Piyər tɔ, Ja̰ tɔ, Jakɨ tɔ, bɔbɨ ngon-je kɨ̀ kɔ̰ ngon lé tɔ ɓá dꞌɔw siə kəy. ");
INSERT INTO mge_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dow-je lay kɨ́ dꞌisɨ dɔ ngon-tɨ lé, dꞌisɨ ta nɔ̰-tɨ, kɨ̀ ta ndingə rɔ-tɨ. Beɓa Jeju idə-dé panè: ꞌNɔ̰i al! Ngon kɨ́ dené lé oy al, ngà tò ɓi kɨ tò. ");
INSERT INTO mge_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rəmə dḛ ꞌsɔkɨ Jeju, kdɔtalə ꞌgə kɨ́ ngon kɨ́ dené lé oy. ");
INSERT INTO mge_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngà Jeju uwə ji ngon lé ɓá pa ta kɨ̀ ndi-é kɨ̀ boy panè: Ngon, ḭ taá! ");
INSERT INTO mge_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Beɓa ngon kɨ́ dené lé tɔsɨ ndəl ə ḭ taá tajinatɨ nè ya! Ə Jeju un ndu kadɨ dꞌadɨ-é né uso! ");
INSERT INTO mge_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Né kɨ́ ra né kinlé, ɔr ndil njékojɨ ngon kɨ́ dené kinlé. Ngà Jeju ndəjɨ-dé kdɔ kadɨ ꞌpa dꞌadɨ dow oo al. ");
INSERT INTO mge_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeju ɓa njékɔwkulə-je liə kɨ́ dɔgɨ gidɨ-é joo ə adɨ-dé tɔ́gɨ rəm, adɨ-dé tarəbɨ kadɨ ꞌtubə ndil-je kɨ́ majɨ al lay dɔ dow-je-tɨ rəm, ɓá kadɨ dꞌadɨ lapiya njémɔ̰y-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngà ɓá ulə-dé kadɨ dꞌilə mbḛ kɔ̰ɓe lə Lubə rəm, ɓá kadɨ dꞌadɨ lapiya njémɔ̰y-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ḛ idə-dé panè: Kɔw-si mba kinlé, uni né madɨ ji-si-tɨ al, uni salangɨ al rəm, uni mbu kɔw mba al rəm, uni mbə̀ al rəm, uni là al rəm, ɓá ɔyi kubɨ kɨ́ rɔ-si-tɨ joo-joo al rəm. ");
INSERT INTO mge_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mḛḛ kəy kɨ́ rá-rá kɨ́ ɔwi-tɨ lé, ḛ ya isi-tɨ sar kadɨ ḭi-né. ");
INSERT INTO mge_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngà lo lay kɨ́ dow-je ꞌmbatɨ kuwə-si kɨ rɔ-dé-tɨ rəmə, ꞌtḛḛi mḛḛ ɓebo-é-tɨ kinlé, ə ꞌgəki kodɨ kɨ́ nja-si-tɨ kɔgɨ kadɨ tɔjɨ kɨ́ ta tò dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Njékɔwkulə-je dꞌɔw kɨ́ dɔ ɓe-ɓe dꞌilə mbḛ Poyta kɨ́ Majɨ rəm, dꞌadɨ lapiya njémɔ̰y-je kɨ̀ lo-lo rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Né-je kɨ́ ra né lé, lokɨ njèkɔ̰ɓe Erodɨ oo ta-é rəmə, ndɔjɨ-é n̰a̰. Kdɔtalə dow-je madɨ ꞌpanè: «To Ja̰ ɓá tɔsɨ ndəl ində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dḛ kɨ́ ná̰-je ꞌpanè: «To Eli ɓá ree» ə dḛ kɨ́ rangɨ ꞌpanè: «To dow káre dan dow-je-tɨ kɨ́ low kɨ́ ꞌto njépata-je kɨ́ ta Lubə-tɨ ɓá tɔsɨ ndəl ində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngà Erodɨ rəmə panè: «Ja̰ lé, ndɔkɨ mꞌadɨ ꞌgangɨ dɔ-é, ngà to ná̰ ɓəy ɓá dow-je dꞌisɨ ꞌpa ta-je kɨ́ bè kin dɔ-é-tɨ ɓá mꞌoo mꞌoo ɓəy tin wa?» Ə ḛ sangɨ kadɨ nꞌoo dowbé lé. ");
INSERT INTO mge_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lokɨ njékɔwkulə-je ꞌtəl ꞌree rəmə, dꞌɔr poy né-je lay kɨ́ ꞌra lé dꞌadɨ Jeju. Ḛ ɔr-dé go-é-tɨ ɔr-né rɔ-é kɨ̀ kár-é kəl ɓebo Betsayda-tɨ bè. ");
INSERT INTO mge_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngà kosɨ dow-je ꞌgə, adɨ dꞌɔw go-é-tɨ. Jeju uwə-dé kɨ rɔ-é-tɨ ə pa ta kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə adɨ-dé rəm, dḛ kɨ́ dꞌɔw ndoo kingə lapiya rəmə, ḛ adɨ-dé lapiya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngà lokɨ kàdɨ̀ isɨ ur lé, njéndó né-je kɨ́ dɔgɨ gidɨ-é joo ꞌree rɔ Jeju-tɨ dꞌidə-é ꞌpanè: ꞌƆsɨ kosɨ dow-je kanlé adɨ dꞌɔw nganɓe-je-tɨ, kɨ̀ kəylo-je-tɨ kɨ́ tò ngɔsi-ngɔsi kadɨ dꞌingə nékuso-je, kɨ̀ lo tò-je, kdɔ lo kɨ́ jꞌa̰i-tɨ nè kinlé to diləlo. ");
INSERT INTO mge_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngà Jeju idə-dé panè: «Sə̰i ya adi-dé né dꞌuso.» Dḛ ꞌtəl dꞌilə-é-tɨ ꞌpanè: «Jḛ jꞌɔw kɨ̀ mbə̀ mḭ kɨ̀ kanjɨ joo-rè ya par. Dɔmajɨ, kadɨ jḛ ya jꞌɔw jꞌndogɨ nékuso jꞌadɨ dow-je kin lay je bè tá.» ");
INSERT INTO mge_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dḛ ꞌpa bè kdɔtalə dingəm-je ya kɔr-dé à ra ɓudɔgɨ lo mḭ je bè. Jeju idə njéndó né-je lé panè: «Uwəi dow-je adɨ dꞌisɨ nangɨ kɔrmḭ kɔrmḭ je bè.» ");
INSERT INTO mge_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dḛ ꞌra bè ya tɔ, adɨ dꞌadɨ dow-je dꞌisɨ nangɨ lay. ");
INSERT INTO mge_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeju taa mbə̀ kɨ́ mḭ kɨ̀ kanjɨ kɨ́ joo lé, itə kəm-é kɨ dɔra̰-tɨ ra oiyo Lubə dɔ-tɨ, ɓá gángɨ dana̰ adɨ njéndó né-je kadɨ ꞌləbɨ kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dḛ lay ya dꞌuso né ꞌndan ndə̰́-ndə̰́; adɨ dꞌɔy dɔdum-é-je kɨ́ nà̰y rusɨ kàrè dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ndɔ káre bè, Jeju ɔr rɔ-é kɨ̀ kár-é pa ta kɨ̀ Lubə ə njéndó né-je liə dꞌɔw siə natɨ ngá ɓá ḛ dəjɨ-dé ta panè: «Kosɨ dow-je lé ꞌpanè mꞌto ná̰ wa?» ");
INSERT INTO mge_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dḛ dꞌilə-é-tɨ ꞌpanè: «Dow-je kɨ́ dan-tɨ-je ꞌpanè: “I ꞌto Ja̰ kɨ́ njèra dow-je batḛm”, ə dḛ kɨ́ ná̰-je ꞌpanè: “I ꞌto Eli”, ə dḛ kɨ́ rangɨ ɓəy ꞌpanè: “I ꞌto dow káre dan dow-je-tɨ kɨ́ low kɨ́ ꞌto njépata-je kɨ́ ta Lubə-tɨ ɓá tɔsɨ ndəl ində lo tḛḛ.”» ");
INSERT INTO mge_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ngá Jeju təl dəjɨ-dé panè: «Ə kɨ́ go gə-é-tɨ lə-si sə̰i ya bè lé, ma̰ mꞌto ná̰ wa?» Piyər ilə-é-tɨ panè: «I ꞌto Kristɨ.» ");
INSERT INTO mge_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeju ndəjɨ-dé n̰a̰ kadɨ ꞌpa ta-é dꞌadɨ dow al. ");
INSERT INTO mge_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jeju təl ilə dɔ-tɨ panè: «Tò kadɨ Ngon lə dow à kingə kɔ̰̀ n̰a̰; ꞌngatɔ́gɨ-je lə jipɨ-je, kɨ̀ njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je dꞌa mbatɨ-é, dꞌa tɔl-é, ngà ndɔ kɨ́ njèkungɨ-tɨ mutə rəmə à tɔsɨ ndəl kində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɓəy ɓá ḛ idə-dé lay panè: «Kinə dow ndigɨ kun go-m rəmə, kadɨ ta rɔ-é ɔ̰̀-é al, kadɨ un kagdəsɨ liə utɨ kɨ̀ ndɔ-é ndɔ-é ə un go-m. ");
INSERT INTO mge_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kdɔ dow kɨ́ rá-rá kɨ́ ndigɨ kajɨ rɔ-é lé à tujɨ rɔ-é, ngà dow kɨ́ ilə rɔ-é kɔgɨ kdɔ ta lə-m ɓá à kajɨ rɔ-é. ");
INSERT INTO mge_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kadɨ dow ingə né-je kɨ́ dɔnangɨ-tɨ nè lay ə dajɨ rɔ-é tujɨ əse ḛ ya tujɨ rɔ-é lé, majɨ-é to ri wa? ");
INSERT INTO mge_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kdɔtalə dow kɨ́ ra rɔsɔl dɔ-m-tɨ, kɨ̀ dɔ ta-je-tɨ lə-m lé, lokɨ Ngon lə dow à ree dan riɓa-tɨ liə, kɨ̀ dan riɓa-tɨ lə Bɔbɨ-é, kɨ̀ ꞌlə malayka-je kɨ́ dꞌaa njay lé, ḛ à ra rɔsɔl dɔ-é-tɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ooi majɨ, mꞌa kidə-si rəsɨ; dow-je madɨ dan dḛ-tɨ kɨ́ dꞌa̰ nè kinlé, dꞌa koo kɔ̰ɓe lə Lubə lé, ɓəy ɓá dꞌa koy.» ");
INSERT INTO mge_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Asɨ ndɔ jinà̰y joo je bè go ta-je-tɨ kɨ́ Jeju pa kinlé, ḛ ɓa Piyər, kɨ̀ Ja̰, kɨ̀ Jakɨ adɨ dꞌɔw siə ə al dɔ mbal-tɨ kdɔ pa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lokɨ ḛ isɨ pa ta kɨ̀ Lubə lé, takəm-é mbəl tò gay ə kubɨ-je liə təl nda mbəy-mbəy ə ndɔ̰y ngilingɨ-ngilingɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Rəmə tajinatɨ nè ya dingəm-je joo dꞌa̰ dꞌɔjɨ ta kɨ̀ Jeju. To Moiyijɨ kɨ̀ Eli kɨ́ ꞌtḛḛ kɔy, ");
INSERT INTO mge_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","rɔ-dé ɔ̰̀ njoy-njoy adɨ lo ndógɨ doo ə dꞌa̰ dꞌɔjɨ ta kɨ̀ Jeju dɔ koy-tɨ kɨ́ ḛ à kɔw koy ɓebo Jorijalḛm-tɨ kdɔ tɔl-né ta kullə liə. ");
INSERT INTO mge_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyər kɨ̀ madɨ-é-je lé, ꞌtò ɓi dꞌadɨ dan-dé oy rəgɨ-rəgɨ; ngà lokɨ ꞌtḛḛ kəm-dé rəmə dꞌoo ndógɨ lə Jeju rəm, dꞌoo dingəm-je joo kɨ́ dꞌa̰ rɔ-é-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lokɨ dingəm-je kɨ́ joo kinlé dꞌisɨ dꞌin̰ə Jeju kdɔ kɔw rəmə, Piyər idə-é panè: Njèndó dow-je né, majɨ n̰a̰ kadɨ jꞌisi nè ya ngá. Adɨ jꞌrai kəykubɨ mutə, káre à to ꞌlə-i, káre à to ꞌlə Moiyijɨ ə káre à to ꞌlə Eli tɔ. Piyər gə mḛḛ ta kɨ́ ḛ a̰ pa lé al. ");
INSERT INTO mge_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Lokɨ a̰ pa ta lé bè ya rəmə, kilndi ree səbɨ dɔ-dé-tɨ rɨpɨ. Lokɨ kilndi səbɨ dɔ-tɨ lé, ɓəl ində bandɨ njéndó né-je gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rəmə dan kilndi-tɨ lé, ndi dow ɓa panè: Ḛ kinlé, to ngon-m, mꞌmbətɨ-é; ooi ta liə. ");
INSERT INTO mge_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ngà go ndi dow-tɨ kɨ́ ɓa lé rəmə, dꞌoo Jeju ya a̰ kɨ̀ kár-é. Njéndó né-je dꞌadɨ ta-dé tò kɨ̀ mundɨ-é ə mḛḛ ndɔ-é-je-tɨ kinlé, dḛ dꞌɔr poy né kɨ́ dꞌoo kin dꞌadɨ dow al. ");
INSERT INTO mge_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lo aa go-tɨ, lokɨ dꞌḭ dɔ mbal-tɨ dꞌisɨ risɨ nangɨ lé, kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌtilə kəm Jeju; ");
INSERT INTO mge_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","rəmə dan kosɨ dow-je-tɨ lé, dow káre pa ta boy-boy panè: Njèndó dow-je né, mꞌra-i kɔgri ya, ilə kəm-i dɔ ngon-m-tɨ adɨ-m, kdɔtalə ḛ to ngon-m kɨ́ káre-rè. ");
INSERT INTO mge_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Taá-taá ya ndil kɨ́ majɨ al uwə-é rəmə, tajinatɨ nè ya ra-é adɨ nɔ̰ boy-boy, sikɨ-é kɨ̀ tɔ́gɨ-é tɔ́gɨ-é adɨ əm ta-é ḭ pukɨ-pukɨ, adɨ-é kɔ̰̀ n̰a̰ ə in̰ə-é kalangɨ al, adɨ tokɨ dow kɨ́ oy bè ");
INSERT INTO mge_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mꞌra ndoo ta njéndó né-je-tɨ lə-i kadɨ ꞌtubə ndil lé dɔ-é-tɨ kɔgɨ ya, ngà dḛ dꞌasɨ al. ");
INSERT INTO mge_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Beɓa Jeju panè: Sə̰i ko dow-je kɨ́ njémḛḛnga̰-je kɨ̀ njémḛḛndul-je kan! Mꞌa kisɨ sə-si natɨ asɨ kaglo ban ɓəy wa? Mꞌa kisɨ dɔ-tɨ sə-si asɨ kaglo ban ɓəy wa? Go-tɨ, təl idə bɔbɨ ngon lé panè: ꞌRee kɨ̀ ngon-i lé nè bè. ");
INSERT INTO mge_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lokɨ ngon lé isɨ ree rəmə, ndil kɨ́ majɨ al lé, ɔsɨ-é ilə-é nangɨ ə sikɨ-é n̰a̰, ngà Jeju ndángɨ ndil kɨ́ majɨ al lé, ə adɨ ngon lé lapiya, ɓá təl ulə-é ji bɔbɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Dow-je lay ya tɔ́gɨ lə Lubə kɨ́ tò ɓəl kinlé ɔr ndil-dé. Lokɨ né-je lay kɨ́ Jeju ra lé, ɔr ndil dow-je lay adɨ tagɨr lə-dé tò kɨ́ dɔ-tɨ ya ɓəy lé, ḛ idə njéndó né-je liə panè: ");
INSERT INTO mge_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ta kɨ́ mꞌɔw kidə-si kinlé, uwəi dɔ-si-tɨ majɨ: «Ngon lə dow lé, dꞌa kilə-é ji dow-je-tɨ.» ");
INSERT INTO mge_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngà njéndó né-je ꞌgə mḛḛ ta kinlé al. Ta lé tokɨ ɓɔyɔ sə-dé dɔ-é kdɔ kadɨ ꞌgə mḛḛ-é al; ə dḛ ꞌɓəl lo dəjɨ-é ta dɔ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Njéndó né-je lə Jeju dꞌisɨ ꞌnajɨ-na̰ ta kadɨ dꞌoo sé ná̰ ɓá to kɨ́ boy n̰a̰ dan-dé-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jeju gə tagɨr kɨ́ mḛḛ-dé-tɨ adɨ un ngon kɨ́ ndḛ bè adɨ-é a̰ mbɔ́-é-tɨ; ");
INSERT INTO mge_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ngá ɓá idə-dé panè: Dow kɨ́ rá-rá kɨ́ uwə ngon kin kɨ rɔ-é-tɨ kdɔ ta lə-m lé, to ma̰ ya tɔ ɓá dowbé uwə-m kɨ rɔ-é-tɨ tin; ə dow kɨ́ uwə-m kɨ rɔ-é-tɨ kin rəmə, to njèkulə-m ya tɔ ɓá dowbé uwə-é kɨ rɔ-é-tɨ tin. Kdɔ dow kɨ́ oo rɔ-é kɨ ngon dow dan-si-tɨ lay kinlé, ḛ ɓá to dow kɨ́ boy n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ja̰ un ta panè: «Njèndó dow-je né, jḛ jꞌoo dow káre un ri-i ɓá isɨ tubə-né ndil-je kɨ́ majɨ al dɔ dow-je-tɨ ə́ jꞌsangɨ kadɨ jꞌɔgɨ-é dɔ-tɨ, kdɔ ḛ un go-i sə-ji al.» ");
INSERT INTO mge_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngà Jeju ilə-é-tɨ panè: Ɔgi-é dɔ-tɨ al, kdɔ dow kɨ́ ɔsɨ-si kɨ̀ ta al lé, to dow lə-si. ");
INSERT INTO mge_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lokɨ ndɔ-je lə Jeju nà̰y ngɔsi kadɨ Lubə à kun-é kɨ dɔra̰-tɨ lé, ḛ un ndi-é ə a̰ dɔ-tɨ njangɨ kadɨ nꞌɔw ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ḛ ulə dow-je kete nɔ̰̀-é-tɨ. Lokɨ dḛ dꞌungɨ-na̰ rebəə dꞌɔw rəmə, ꞌtḛḛ mḛḛ ngonɓe-tɨ káre kɨ́ dɔnangɨ Samari-tɨ, kdɔ ra né-je kete ngəbɨ-é-né. ");
INSERT INTO mge_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngà dow-je kɨ́ ngonɓe-é-tɨ ꞌndigɨ kuwə-é kɨ rɔ-dé-tɨ al, kdɔ ḛ un rəbɨ kɨ́ ɔw kɨ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lokɨ Jakɨ-je kɨ̀ Ja̰ kɨ́ ꞌto njéndó né-je lə Jeju dꞌoo né kin bè lé, dꞌidə-é ꞌpanè: ꞌƁaɓe, i ꞌndigɨ kadɨ jꞌdəjɨ pər kadɨ ḭ dɔra̰-tɨ ree ró-dé wa? ");
INSERT INTO mge_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jeju təl kəm-é kɨ rɔ-dé-tɨ ɓá kɔl sə-dé panè: To tagɨr ri ɓá tò mḛḛ-si-tɨ bè wa! ");
INSERT INTO mge_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ngon lə dow lé, ree kdɔ tɔl dow-je al, ngà ḛ ree kdɔ kajɨ-dé. Beɓa dḛ dꞌɔtɨ dꞌɔw ngonɓe-tɨ kɨ́ rangɨ. ");
INSERT INTO mge_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lokɨ dḛ dꞌɔw dɔ rəbɨ-tɨ lé, dow káre idə Jeju panè: «Mꞌa kun go-i lo lay kɨ́ ꞌa kɔw-tɨ.» ");
INSERT INTO mge_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jeju ilə-é-tɨ panè: «Tal-je dꞌɔw kɨ̀ ɓe tò-dé nɔ̰ɔ̰, ɓá yəl-je kɨ́ ꞌnar taá kin kàrè dꞌɔw kɨ̀ kəy tò-dé tɔ. Ngà Ngon lə dow lé, lo kɨ́ kadɨ ulə dɔ-é-tɨ ya kàrè goto.» ");
INSERT INTO mge_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jeju idə dow kɨ́ rangɨ panè: ꞌUn go-m. Ngà ḛ ilə-é-tɨ panè: «ꞌƁaɓe, ꞌadɨ-m tarəbɨ adɨ mꞌɔw mꞌdubɨ bɔbɨ-m mɔkɨ tá.» ");
INSERT INTO mge_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngà Jeju idə-é panè: «ꞌIn̰ə dḛ kɨ́ dꞌoy adɨ ꞌdubɨ dow-je lə-dé kɨ́ dꞌoy, ə i rəmə, ꞌɔw ilə mbḛ kɔ̰ɓe lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dow káre pa ɓəy panè: ꞌƁaɓe, mꞌndigɨ kun go-i, ngà kadɨ ɓá ꞌadɨ-m tarəbɨ kadɨ mꞌɔw mꞌra lapiya dow-je kɨ́ mḛḛ kəy-tɨ lə-m mɔkɨ tá. ");
INSERT INTO mge_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngá ɓá Jeju idə-é panè: Dow kɨ́ uwə kɔsɨ mangɨ-je ɔw ndɔr-né ɓá gɔ̰ɔ̰ lo go-é-tɨ gogɨ lé, kullə kɔ̰ɓe lə Lubə tuwə-é al. ");
INSERT INTO mge_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Go-tɨ, ꞌƁaɓe Jeju mbətɨ njéndó né-je kɨ́ rangɨ kɔrsiri gidɨ-é joo ə ulə-dé kadɨ dꞌɔw joo-joo kete nɔ̰̀-é-tɨ mḛḛ ɓebo-je-tɨ lay, kɨ̀ lo-je-tɨ lay kɨ́ tò kadɨ ḛ ya kàrè à kɔw-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ḛ idə-dé panè: Ko kɨ́ tò kijə n̰a̰, ngà njékijə-é-je ɓá ꞌn̰a̰ al. Ə́n ə́ ꞌpai ta kɨ̀ ꞌɓa njèko kɨ́ tò kijə lé, kadɨ ulə kɨ̀ njérakullə-je titɨ. ");
INSERT INTO mge_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ɔwi! Yən, mꞌulə-si titɨ-na̰ kɨ̀ ngan batɨ-je bè dan jagɨm-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Uni mbu là al rəm, uni mbu kɔw mba al rəm, ɔyi saba al rəm, ɓá a̰i nangɨ kɨ̀ rəbɨ-rəbɨ ꞌrai lapiya dow-je al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mḛḛ kəy kɨ́ rá-rá kɨ́ ɔwi-tɨ lé, ta kɨ́ a pai kete mɔkɨ ə́n: «Kadɨ lapiya nà̰y mḛḛ kəy-tɨ kin!» ");
INSERT INTO mge_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kinə dow nojɨ isɨ mḛḛ kəy-tɨ lé nɔ̰ɔ̰ rəmə, lapiya lə-si à nà̰y siə. Ngà kinə dow nojɨ goto tɔ rəmə, lapiya lə-si à təl ree rɔ-si gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Isi mḛḛ kəy-é-tɨ kinlé, ə né kɨ́ dꞌadɨ-si ya usoi rəm, a̰yi rəm. Kdɔtalə to tó-é kadɨ njérakullə ingə nékugə dɔji-é. Iləi kɨ̀ takəy-takəy al. ");
INSERT INTO mge_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mḛḛ ɓebo kɨ́ rá-rá kɨ́ ɔwi-tɨ, ɓá dꞌuwə-si kɨ rɔ-dé-tɨ, ə dꞌadɨ-si nékuso rəmə usoi ");
INSERT INTO mge_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","rəm, adi lapiya njémɔ̰y-je kɨ́ dꞌisɨ mḛḛ ɓebo-é-tɨ lé, ə idəi dow-je kɨ́ titɨ ꞌpainè: Kɔ̰ɓe lə Lubə ree ngɔsi rɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngà mḛḛ ɓebo kɨ́ rá-rá kɨ́ ɔwi-tɨ, ɓá dꞌuwə-si kɨ rɔ-dé-tɨ al lé, ɔwi pandangɨ lo-je-tɨ kɨ́ mḛḛ ɓe-é-tɨ lé, ə ꞌpainè: ");
INSERT INTO mge_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Kodɨ kɨ́ mḛḛ ɓebo-tɨ lə-si kɨ́ ḭ nja-ji-tɨ ya kàrè jꞌɔw mbing jꞌgəkɨ dɔ-si-tɨ gogɨ. Bè ya kàrè, kadɨ ꞌgəi kɨ́ kɔ̰ɓe lə Lubə lé, ree ngɔsi.» ");
INSERT INTO mge_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mꞌa kidə-si rəsɨ; mḛḛ ndɔ-é-tɨ kinlé ta kɨ́ gangɨ kɨ́ dɔ ɓebo-é-tɨ kinlé, à nga̰ n̰a̰ kitə ta kɨ́ gangɨ kɨ́ dɔ Sɔdɔm-tɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i dow-je kɨ́ Korajḛ! Tujɨ à kusɨ dɔ-si-tɨ, sə̰i dow-je kɨ́ Betsayda! Kdɔ nékɔjɨ-je kɨ́ tokɨ ra dan-si-tɨ nè kinlé, lé tokɨ ra dɔnangɨ Tir-tɨ kɨ̀ dɔnangɨ Sidɔ̰-tɨ je bè rəmə lé dow-je kɨ́ titɨ dꞌa kulə kubɨ sakɨ rɔ-dé-tɨ tò-né buu-tɨ, kdɔ kin̰ə-né panjiyə-dé-je kɨ́ majɨ al kɔgɨ low nṵ ngá! ");
INSERT INTO mge_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gin-é kin ɓá, ndɔ gangta-tɨ lé, ta kɨ́ gangɨ kɨ́ dɔ-si-tɨ à nga̰ n̰a̰ kitə ta kɨ́ gangɨ kɨ́ dɔ dɔnangɨ Tir-tɨ, kɨ̀ dɔnangɨ Sidɔ̰ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ngà sə̰i dow-je kɨ́ Kapɛrnayim, ooi ꞌpainè se riɓa lə-si kin à kɔw sə-si sar dɔra̰-tɨ wa? Bè al, à tokɨ təl sə-si kɨ nangɨ sar kɨ mḛḛ lo kɨ́ koó-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dow kɨ́ taa ta lə-si lé, taa ta lə-m tɔ. Ngà dow kɨ́ ɔsɨ-si ngərəngɨ rəmə, to ma̰ ya tɔ ə́ ɔsɨ-m ngərəngɨ tin. Ə dow kɨ́ ɔsɨ-m ngərəngɨ lé, to njèkulə-m tɔ ɓá dowbé ɔsɨ-é ngərəngɨ tin. ");
INSERT INTO mge_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dḛ kɨ́ kɔrsiri kɨ́ Jeju ulə-dé lé, ꞌtəl ꞌree kɨ́ rɔnəl ə ꞌpanè: ꞌƁaɓe, kɨ̀ ri-i lé, ndil-je kɨ́ majɨ al ya kàrè dꞌulə dɔ-dé gin tɔ́gɨ-tɨ lə-ji. ");
INSERT INTO mge_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Beɓa Jeju idə-dé panè: Mꞌoo Sata̰ ḭ dɔra̰-tɨ titɨ-na̰ kɨ̀ təl ndi bè usɨ nangɨ nè. ");
INSERT INTO mge_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ooi bè, mꞌadɨ-si tɔ́gɨ kadɨ ꞌnjiyəi-né dɔ li-je-tɨ, kɨ̀ dɔ jinə̰-je-tɨ, kɨ̀ dɔ tɔ́gɨ-je-tɨ lay kɨ́ njèba ɔw-né, ə né káre ya kàrè à ra-si al. ");
INSERT INTO mge_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bè ya kàrè, ꞌrai rɔnəl kdɔtalə ndil-je kɨ́ majɨ al kɨ́ dꞌulə dɔ-dé gin tɔ́gɨ-tɨ lə-si kin al. Ngà ꞌrai rɔnəl kdɔtalə ri-si kɨ́ tokɨ ndàngɨ mḛḛ dɔra̰-tɨ kin tá. ");
INSERT INTO mge_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dɔkaglo-é-tɨ kinlé ya Ndil kɨ́ aa njay ra Jeju adɨ rɔ-é nəl-é n̰a̰ adɨ panè: Bɔbɨ-m kɨ́ ꞌto ꞌƁa dɔra̰ kɨ̀ dɔnangɨ, mꞌtɔ́y-i, kdɔ ꞌɓɔyɔ dɔ né-je kin kɨ̀ njégosɨ-je kɨ̀ njénégə-je rəmə ngan dow-je kin ɓá ꞌtḛḛ kɨ̀ dɔ-é adɨ-dé. Oiyo, Bɔbɨ-m, mꞌtɔ́y-i kdɔ to ndigɨ lə-i kadɨ né kinlé tò bè. ");
INSERT INTO mge_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bɔbɨ-m təl kɨ̀ né-je lay adɨ-m. Dow kɨ́ gə-m ma̰ Ngon lə Lubə lé goto. Bɔbɨ-m ya par ə́ gə-m. Ə dow kɨ́ gə Bɔbɨ-m ya goto. Ma̰ ya par ə́ mꞌgə Bɔbɨ-m lé, ə dow kɨ́ ma̰ ngon-é lé ya mꞌtḛḛ kəm-é dɔ-é-tɨ ɓá à gə-é tɔ. ");
INSERT INTO mge_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Go-tɨ, Jeju təl kəm-é kɨ rɔ njéndó né-je-tɨ liə ə idə-dé dḛ ya kɨ̀ kár-dé gay panè: Dow-je kɨ́ kəm-dé oo né-je kɨ́ sə̰i ooi kinlé ꞌto njénékumə̰-je! ");
INSERT INTO mge_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Beɓa mꞌa kidə-si rəsɨ kɨ́ njépata-je kɨ́ ta Lubə-tɨ n̰a̰, kɨ̀ ngar-je n̰a̰ ya ꞌndigɨ koo né-je kɨ́ sə̰i ooi kin ya, ngà dꞌoo al; ꞌndigɨ koo ta-je kɨ́ sə̰i ooi kin ya, ngà dꞌoo al. ");
INSERT INTO mge_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dow káre kɨ́ njèndó dow-je ndukun sangɨ kdɔ koo ta kɨ́ mḛḛ Jeju-tɨ adɨ ḭ taá dəjɨ-é panè: «Njèndó dow-je né, ri ɓá mꞌa ra kdɔ kadɨ mꞌisɨ-né kəm sartagangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Beɓa Jeju ilə-é-tɨ panè: «ꞌNdàngɨ mḛḛ mbete ndukun-je-tɨ ꞌpanè ri wa? I ꞌndó lé, ꞌndàngɨ ꞌpanè ri wa?» ");
INSERT INTO mge_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ḛ ilə Jeju-tɨ panè: «ꞌA ndigɨ ꞌƁaɓe Lubə lə-i kɨ̀ mḛḛ-i káre-rè, kɨ̀ ndil-i lay, kɨ̀ tɔ́gɨ-i lay rəm, kɨ̀ tagɨr lə-i lay rəm, ɓá ꞌa ndigɨ dow madɨ-i tò kɨ rɔ-i bè rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Beɓa Jeju idə-é panè: «Ta lé, i ilə-tɨ majɨ n̰a̰! ꞌRa né kinlé ya rəmə ꞌa kisɨ kəm.» ");
INSERT INTO mge_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngà ḛ ndigɨ ra kadɨ ꞌlə-nꞌḛ̀ to najɨ adɨ dəjɨ Jeju panè: «Ná̰ ɓá to dow madɨ-m wa?» ");
INSERT INTO mge_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jeju təl un ta panè: «Dingəm káre bè ḭ ɓebo Jorijalḛm-tɨ isɨ ɔw ɓebo Jeriko-tɨ, rəmə bɔkaya-je ꞌgangɨ-é ꞌtaa né-je liə lay, ꞌtində-é mbukɨ-mbukɨ dꞌadɨ tò kəm yo ə ꞌtusɨ-é dꞌin̰ə-é dꞌɔw lo lə-dé. ");
INSERT INTO mge_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ə dow káre kɨ́ to njègugné lə Lubə ḭ Jorijalḛm isɨ ree kɨ̀ rəbɨ kɨ́ káre kinlé tɔ. Lokɨ ree da dɔ dingəm-tɨ lé rəmə, ḛ ijə rɔ-é kɨ̀ nganglo-nganglo dəə ɔw. ");
INSERT INTO mge_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Go-tɨ, dow káre kɨ́ gin kojɨ-tɨ lə Lebi ree tḛḛ lo-tɨ kinlé tɔ, ɓá oo dingəm lé rəmə, ijə rɔ-é kɨ̀ nganglo-nganglo dəə ɔw ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ngà dow káre kɨ́ dɔnangɨ Samari-tɨ kɨ́ isɨ ɔw mba ə́ ree tḛḛ lo-tɨ kinlé ɓá oo dingəm lé rəmə ta ɔ̰̀ mḛḛ-é n̰a̰ kdɔ ta liə. ");
INSERT INTO mge_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Beɓa ɔtɨ ree rɔ-é-tɨ ə ungɨ ubɨ, kɨ̀ man nduu ta dò-je-tɨ lé ndəm-né ɓəy ɓá un-é səbɨ-é dɔ koro-tɨ liə ɔw siə kəy mba-je-tɨ ə tɔsɨ kəm-é go-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lokɨ lo aa lé, ḛ ɔr là kɨ́ dow à ra kullə ndɔ joo ɓá à kingə, adɨ njèkoo go kəy mba-je lé, ə idə-é panè: “ꞌTɔsɨ kəm-i go-é-tɨ adɨ-m rəm, ɓá né-je lay kɨ́ ꞌa tujɨ dɔ-é-tɨ dɔ madɨ-é-tɨ kinlé, ndɔ kɨ́ mꞌtəl rəmə jè idə-m ə ma̰ ya mꞌa kugə-i.”» ");
INSERT INTO mge_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jeju təl dəjɨ njèndó dow-je ndukun lé panè: «Kɨ́ go koo-é-tɨ lə-i lé, dan dow-je-tɨ kɨ́ mutə kinlé, ḛ kɨ́ rá ɓá to dow madɨ dingəm kinlé wa?» ");
INSERT INTO mge_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Beɓa ḛ ilə Jeju-tɨ panè: «To ḛ kɨ́ njèkoo kəmtondoo liə kin.» Bè ngá ɓá Jeju idə-é panè: «ꞌƆw, ə i kàrè ꞌra bè ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lokɨ Jeju usɨ rebəə kɨ̀ njéndó né-je liə, ɓá ɔw mḛḛ ngonɓe-tɨ káre bè lé, dené káre kɨ́ ri-é lə Martɨ uwə-é kɨ rɔ-é-tɨ mḛḛ kəy-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ə Mari kɨ́ to ngonkɔ̰ Martɨ lé, isɨ nangɨ nja ꞌƁaɓe-tɨ isɨ oo ta-je liə. ");
INSERT INTO mge_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kullə-je kɨ́ gay-gay kɨ́ mḛḛ kəy-tɨ un Martɨ n̰a̰ adɨ ḛ ɔtɨ ratɨ ree panè: ꞌƁaɓe, kin̰ə kɨ́ ngonkɔ̰-m in̰ə-m kɨ̀ kar-m ya ta kullə-tɨ kinlé, ꞌusɨ-i-tɨ al ɓan al wa? ꞌIdə-é adɨ ree ra sə-m kullə. ");
INSERT INTO mge_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ꞌƁaɓe ilə-é-tɨ panè: Martɨ, Martɨ, mḛḛ-i a̰ kə́kə́kə́ rəm, rɔ-i ɓa ɗakɨ-ɗakɨ kdɔ né-je n̰a̰ ya, ");
INSERT INTO mge_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ngà né káre ya par ə to né kɨ́ majɨ n̰a̰. Mari ɓá mbətɨ ḛ kɨ́ majɨ n̰a̰ kɨ́ dow à taa ji-é-tɨ nda̰ al. ");
INSERT INTO mge_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ndɔ káre bè, Jeju isɨ lo-tɨ madɨ isɨ pa ta kɨ̀ Lubə. Lokɨ pa ta kɨ̀ Lubə gin-é gangɨ lé, dow káre dan njéndó né-je-tɨ liə dəjɨ-é panè: ꞌƁaɓe, ꞌndó-ji lo pa ta kɨ̀ Lubə titɨ kɨ́ Ja̰ ndó-né njéndó né-je liə bè tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jeju ilə-dé-tɨ panè: Lokɨ isi ꞌpai ta kɨ̀ Lubə rəmə, ꞌpainè: Bɔbɨ-ji, kadɨ dow-je ꞌgə kɨ́ ꞌaa njay; kadɨ kɔ̰ɓe lə-i ree. ");
INSERT INTO mge_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ꞌAdɨ-ji nékuso kɨ́ asɨ ta-ji kɨ̀ ndɔ-je lay. ");
INSERT INTO mge_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ꞌIn̰ə go majal-je lə-ji kɔgɨ, kdɔ jḛ kàrè jꞌisɨ jꞌin̰ə go majal-je kɨ́ dow-je dꞌisɨ ꞌra sə-ji lé kɔgɨ tɔ. Ə ꞌin̰ə-ji adɨ jꞌusɨ mḛḛ néna̰-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Go-tɨ, Jeju ilə dɔ-tɨ panè: Dow káre dan-si-tɨ je bè, ɓá nam-é isɨ nɔ̰ɔ̰, ɓá ḛ ɔw ndəl-é ndɔɔ dan lo-tɨ panè: Nam-m, adɨ-m mꞌtunə̰-i mbə̀ mutə. ");
INSERT INTO mge_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kdɔtalə nam-m káre ḭ mba-tɨ ree rɔ-m-tɨ ə́ mꞌoo né kɨ́ mꞌa kadɨ-é al. ");
INSERT INTO mge_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɓá kinə nam-é lé, to kəy je bè ya ilə-é-tɨ panè: I ꞌndɔjɨ-m al. Tarəbɨ tokɨ kutɨ ngá, ɓá jḛ kɨ̀ ngan-m jꞌto nangɨ rəm ngá, adɨ mꞌa kḭ taá kadɨ-i mbə̀ lé al. ");
INSERT INTO mge_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mꞌidə-si mꞌadɨ ooi, kinə lé, ḭ taá adɨ-é mbə̀ lé, kdɔtalə to kɨ́ ḛ to nam-é kin al kàrè, à kḭ taá kdɔtalə ndɔjɨ kɨ́ ndɔjɨ-é ɓəy-ɓəy kin ya, kdɔ kadɨ-é né-je lay kɨ́ ḛ ɔw ndoo-é lé. ");
INSERT INTO mge_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ə mꞌidə-si mꞌpanè: ꞌDəji ə dꞌa kadɨ-si; ꞌsangi ə a kingəi; indəi tarəbɨ ə dꞌa tḛḛ kadɨ-si. ");
INSERT INTO mge_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kdɔ dow kɨ́ dəjɨ ya ə dꞌadɨ-é; dow kɨ́ sangɨ ə ingə; dow kɨ́ ində tarəbɨ ə ꞌtḛḛ dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ná̰ dan-si-tɨ ɓá ngon-é dəjɨ-é mbə̀ rəmə à kadɨ-é ər wa? Əse dəjɨ-é kanjɨ rəmə à kadɨ-é li wa? ");
INSERT INTO mge_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Əse ngon-é dəjɨ-é kɔw rəmə à kadɨ-é jinə̰ wa? ");
INSERT INTO mge_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ə sə̰i kɨ́ ꞌtoi njémḛḛndul-je kàrè, ꞌgəi kadɨ né-je kɨ́ majɨ-majɨ ngan-si-je rəm, ngà Bɔbɨ-si kɨ́ dɔra̰-tɨ kɨ́ ban ɓá à kadɨ Ndil kɨ́ aa njay dow-je kɨ́ ꞌdəjɨ-é lé al wa? ");
INSERT INTO mge_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ndɔ káre bè, Jeju tubə ndil kɨ́ majɨ al kɨ́ isɨ mḛḛ dingəm-tɨ ra-é adɨ pa ta al. Lokɨ ndil kɨ́ majɨ al lé tḛḛ kɔgɨ ya rəmə, dingəm lé pa ta adɨ né-é ɔr ndil kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ngà dow-je kɨ́ dan-tɨ-je ꞌpanè: To tɔ́gɨ lə Beljebul, kɨ́ to ꞌboy lə ndil-je kɨ́ majɨ al ɓá Jeju isɨ tubə-né ndil-je kɨ́ majɨ al. ");
INSERT INTO mge_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ə dḛ kɨ́ ná̰-je ꞌndigɨ na̰-é kdɔ koo ta kɨ́ mḛḛ-é-tɨ adɨ ꞌdəjɨ-é kadɨ ra nékɔjɨ kɨ́ ḭ dɔra̰-tɨ kadɨ dꞌoo. ");
INSERT INTO mge_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngà Jeju gə tagɨr-je lə-dé ɓətɨ adɨ idə-dé panè: Kɔ̰ɓe kɨ́ rá-rá ya ɓá dow-je kɨ́ mḛḛ-é-tɨ ꞌgángɨ-na̰ dꞌɔsɨ-na̰ kɨ̀ ta lé, à təl ndubəɓe; kəy-je kɨ́ mḛḛ ɓe-é-tɨ kinlé kàrè, à tɔ nangɨ dɔ-na̰-tɨ rum-rum rəm. ");
INSERT INTO mge_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kinə Sata̰ ya gangɨ rɔ-é dana̰ ɔsɨ rɔ-é kɨ̀ ta lé, kɔ̰ɓe liə à ka̰ lo ka̰-é-tɨ gərərə ban wa? Mꞌpa bè kdɔ sə̰i ꞌpainè to tɔ́gɨ lə Beljebul ɓá mꞌisɨ mꞌtubə-né ndil-je kɨ́ majɨ al. ");
INSERT INTO mge_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ə kinə to tɔ́gɨ lə Beljebul ɓá mꞌisɨ mꞌtubə-né ndil-je kɨ́ majɨ al, ngà dow-je lə-si ə dꞌisɨ ꞌtubə-dé kɨ̀ tɔ́gɨ lə ná̰ ngá wa? Kullə ra dow-je lə-si ya ilə ta dɔ-si-tɨ! ");
INSERT INTO mge_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ngà kinə to tɔ́gɨ Lubə tɔ ɓá mꞌisɨ mꞌtubə-né ndil-je kɨ́ majɨ al rəmə, to kɔ̰ɓe lə Lubə ya ngá ə́ ree tḛḛ rɔ-si-tɨ tin. ");
INSERT INTO mge_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Lokɨ dow kɨ́ njètɔ́gɨ kɨ́ nékatɨ asɨ ji-é majɨ, ngəm takəy liə lé, nékingə-é tò gərərə. ");
INSERT INTO mge_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngà kinə dow kɨ́ rangɨ kɨ́ tɔ́gɨ-é itə-é ree rɔ-é tətɨ-é rɔ lé, à taa nékatɨ-je kɨ́ ḛ ubə kul-é kinlé ji-é-tɨ ɓəy ɓá à taa nékingə-é kdɔ ləbɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Dow kɨ́ ore kàdɨ̀-m al lé, to njèkɔsɨ-m kɨ̀ ta ə dow kɨ́ kəw sə-m né kɨ natɨ al kàrè, to njèsane né kɔgɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Lokɨ ndil kɨ́ majɨ al tḛḛ mḛḛ dow-tɨ, ɔw ilə kɨ̀ diləlo kɨ́ tutɨ sangɨ lo kɨ́ kadɨ nꞌisɨ-tɨ nꞌtaa koo ya ngà ḛ ingə al rəmə, ḛ təl panè: «Kəy lə-m kɨ́ mꞌisɨ-tɨ ɓá mꞌtḛḛ lé, mꞌa təl kɔw-tɨ gogɨ.» ");
INSERT INTO mge_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lokɨ təl ɔw gogɨ rəmə, oo kɨ́ mḛḛ kəy lé tokɨ kɔy ndətɨ-ndətɨ rəm, ɓá né-je kɨ́ mḛḛ-é-tɨ tokɨ kɔsɨ njɔl-njɔl rəm. ");
INSERT INTO mge_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Beɓa ḛ ɔsɨ təl ɔw sangɨ ndil-je kɨ́ rangɨ siri kɨ́ mḛḛ-dé ndul itə-é ɓəy ɓá ree sə-dé, adɨ dꞌandɨ mḛḛ kəy-tɨ lé ə dꞌadɨ to lokisɨ-dé. Gangɨ-é-tɨ kɨ́ gogɨ nè kinlé, kisɨ lə dowbé kin majɨ al n̰a̰ itə kɨ́ kete lé ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lokɨ Jeju a̰ pa ta lé bè ya rəmə, dené káre tḛḛ dan kosɨ dow-je-tɨ pa ta kɨ̀ ndi-é kɨ́ boy panè: Dené kɨ́ ojɨ-i ə ulə mba ta-i-tɨ kinlé, to njènékumə̰ kɨ́ ban ə́n ə! ");
INSERT INTO mge_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngà Jeju ilə-é-tɨ panè: Bè al, dow-je kɨ́ dꞌoo ta lə Lubə ə ꞌtəl rɔ-dé go-tɨ ɓá ꞌto njénékumə̰-je! ");
INSERT INTO mge_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lokɨ kosɨ dow-je kɨ́ ꞌtò nduy-nduy ꞌgəə dɔ Jeju sipɨ lé, ḛ idə-dé panè: Dow-je kɨ́ ngɔsnè kinlé, ꞌto njémḛḛndul-je; dḛ ꞌdəjɨ kadɨ dꞌoo nékɔjɨ, ngà dow à ra nékɔjɨ kɨ́ rangɨ kadɨ-dé al ngá; ḛ kɨ́ ndɔkɨ tḛḛ dɔ Jonasɨ-tɨ kin ya asɨ. ");
INSERT INTO mge_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kdɔ titɨ kɨ́ ndɔkɨ Jonasɨ to-né nékɔjɨ rɔ dow-je-tɨ kɨ́ Ninibɨ kinlé, bè ya tɔ ə́ Ngon lə dow à to-né nékɔjɨ rɔ dow-je-tɨ kɨ́ ngɔsnè kin tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ndɔ gangta-tɨ lé, ngar kɨ́ dené kɨ́ go lo-tɨ kɨ́ bəə à ka̰ takəm dow-je-tɨ kɨ́ ngɔsnè kin, kdɔ kilə ta dɔ-dé-tɨ. Kdɔ ndɔkɨ ḛ ḭ sɔ̰y dɔnangɨ-tɨ nṵ ya ree oo gosta-je lə Salomɔ̰. Ngà kɨ́ ngɔsnè-tɨ kinlé, dow kɨ́ itə Salomɔ̰ n̰a̰ ya a̰ nè! ");
INSERT INTO mge_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndɔ gangta-tɨ lé, dow-je kɨ́ Ninibɨ dꞌa ka̰ takəm dow-je-tɨ kɨ́ ngɔsnè kin kdɔ kilə ta dɔ-dé-tɨ. Kdɔ dow-je kɨ́ Ninibɨ lé, lokɨ dꞌoo mbḛ kilə lə Jonasɨ rəmə, ꞌtusɨ panjiyə-dé-je kɨ́ majɨ al dꞌin̰ə kɔgɨ. Ngá kɨ́ ngɔsnè-tɨ kinlé, dow kɨ́ itə Jonasɨ n̰a̰ ya a̰ nè! ");
INSERT INTO mge_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Dow à kində pər lampɨ-tɨ kdɔ ɓɔyɔ al rəm, ɓá à jəbɨ ngó dɔ-tɨ al rəm tɔ. Ngà à na̰a̰ kagna̰a̰ lampɨ-tɨ taá kdɔ kadɨ dow-je kɨ́ dꞌɔw mḛḛ kəy-tɨ dꞌoo-né lo. ");
INSERT INTO mge_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kəm-i lé, to lampɨ lə rɔ-i. Lokɨ kəm-i tò majɨ rəmə, rɔ-i lay ya tò lo kɨ́ ndógɨ-tɨ; ngà kinə kəm-i majɨ al lé, rɔ-i tò lo kɨ́ ndul-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ꞌOo majɨ, kadɨ londógɨ kɨ́ tò rɔ-i-tɨ təl londul al. ");
INSERT INTO mge_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kinə rɔ-i burə lay tò lo kɨ́ ndógɨ-tɨ adɨ kəl rɔ-i káre ya kàrè nà̰y londul-tɨ al lé, rɔ-i ɓikti ya lo à ndógɨ dɔ-tɨ titɨ kɨ́ lampɨ ndógɨ-né dɔ-i-tɨ kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lokɨ Jeju pa ta lay rəmə, Parisi káre ɓa-é ɓe liə kdɔ kadɨ ɔw uso siə né. Beɓa Jeju ɔw kəy isɨ ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lokɨ Parisi lé, oo kɨ́ Jeju togɨ ji-é al ya uso-né né lé, lo ta igɨ-é səl. ");
INSERT INTO mge_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Beɓa ꞌƁaɓe idə-é panè: Sə̰i Parisi-je lé, gidɨ kobɨ-je kɨ̀ gidɨ tasa-je ɓá sə̰i ꞌtogi sukɨ-sukɨ, ngà mḛḛ-si ɓá ɓogɨ-je kɨ̀ mḛḛndul-je rusɨ njḭ-njḭ. ");
INSERT INTO mge_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sə̰i mbə́ dow-je kan! Lubə kɨ́ njèra gidɨ né kɨ́ ndaa-tɨ nè kinlé, ḛ ya ra mḛḛ-é kɨ́ kəy tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mḛḛ-si kɨ́ kəy ɓá adi Lubə kadkare-tɨ ə né-je lay à kaa njay rɔ-si-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ngà tujɨ à kusɨ dɔ-si-tɨ, sə̰i Parisi-je! Kdɔ sə̰i lé, mbikam-je lə-si kɨ́ ətɨ majɨ-majɨ, kɨ̀ né ndɨr ná̰y-je, kɨ̀ ndəgɨ mbikamná̰y-je lay kin ya sə̰i ɔri káre dan kɨ́ dɔgɨ-tɨ adi Lubə. Rəmə né ra kɨ́ njururu, kɨ̀ ndigɨ Lubə kin ɓá sə̰i ooi kɨ́ né al. Né-je kin ɓá lé, à to kullə ra-si, ɓá ndəgɨ né-je kinlé kàrè sə̰i a tusi kin̰əi al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Tujɨ à kusɨ dɔ-si-tɨ sə̰i Parisi-je; kdɔtalə sə̰i lé, lokisɨ kɨ́ kete nɔ̰̀ dow-je-tɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je ɓá sə̰i ꞌndigi rəm, ɓá ꞌndigi kadɨ dow-je ꞌra-si lapiya kunta-na̰ lokosɨ-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tujɨ à kusɨ dɔ-si-tɨ, kdɔtalə sə̰i lé, ꞌtiti-na̰ kɨ̀ dɔɓadɨ-je kɨ́ né kɨ́ tɔjɨ kadɨ dow gə-né ya goto kin bè, adɨ dow-je ꞌnjiyə dɔ-tɨ kàrè ꞌgə al. ");
INSERT INTO mge_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dow káre dan njèndó dow-je ndukun-je-tɨ, pa kɨ̀ Jeju panè: Njèndó dow-je né, i ꞌpa bè kinlé, to jḛ tɔ ɓá ꞌtajɨ-ji tin al wa. ");
INSERT INTO mge_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jeju ilə-é-tɨ panè: Sə̰i njéndó dow-je ndukun-je lé, tujɨ à kusɨ dɔ-si-tɨ tɔ; kdɔtalə né-je kɨ́ ɔy kɨ́ lo kutɨ-é nga̰ ya sə̰i indəi dɔ dow-je-tɨ, ngà sə̰i rəmə, ngon ji-si ya kàrè, ꞌgəti-né sə-dé al. ");
INSERT INTO mge_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tujɨ à kusɨ dɔ-si-tɨ, kdɔtalə sə̰i ꞌrai dɔɓadɨ njépata-je kɨ́ ta Lubə-tɨ kɨ́ ndɔkɨ ka-si-je ꞌtɔl-dé. ");
INSERT INTO mge_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lokɨ sə̰i ꞌrai bè lé, ꞌtɔji to kɨ́ ꞌndigi kɨ̀ ka-si-je, kdɔtalə ka-si-je ꞌtɔl njépata-je kɨ́ ta Lubə-tɨ ə sə̰i ꞌrai dɔɓadɨ-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gin-é kin ɓá Lubə kɨ́ njègosɨ pa-né panè: Mꞌa kulə njépata-je kɨ́ ta-m-tɨ, kɨ̀ njékɔwkulə-je lə-m rɔ-dé-tɨ rəmə, dꞌa tɔl dḛ kɨ́ dan-tɨ-je ə dꞌa kulə kəm dḛ kɨ́ ná̰-je ndoo tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kdɔ kadɨ məsɨ njépata-je kɨ́ ta-m-tɨ kɨ́ un kutɨ-é lo kində gin dɔnangɨ-tɨ nṵ ya a̰y kɔgɨ puu-puu kinlé, ta-é tò dɔ dow-je-tɨ kɨ́ ngɔsnè kin. ");
INSERT INTO mge_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Un kutɨ-é dɔ məsɨ Abɛl-tɨ sar tḛḛ-né dɔ məsɨ Jakari-tɨ kɨ́ ꞌtɔl-é mbunə̰ logugɨ né-tɨ kɨ̀ kəy lə Lubə. Ooi majɨ, ta məsɨ-dé à kusɨ dɔ dow-je-tɨ kɨ́ ngɔsnè kin ya ndətɨ. ");
INSERT INTO mge_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Tujɨ à kusɨ dɔ-si-tɨ, sə̰i njéndó dow-je ndukun-je! Kdɔtalə sə̰i ɔri lakere kɔr tarəbɨ négə ji-si-tɨ ə sə̰i ɔwi kəy al rəm, ɓá dow-je kɨ́ ꞌndigɨ kɔw kàrè, sə̰i ɔgɨ-dé lo kɔw rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lokɨ Jeju tḛḛ mḛḛ kəy-tɨ lé, njéndó dow-je ndukun-je kɨ̀ Parisi-je dꞌḭ siə kɨ̀ wɔngɨ n̰a̰ adɨ ꞌdəjɨ-é ta gitɨ-gitɨ dɔ né-je-tɨ kɨ́ gay-gay. ");
INSERT INTO mge_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Dḛ ꞌdəjɨ-é ta-je kin bè dꞌiyə-né gum kdɔ kadɨ kinə dꞌingə ta madɨ ta-é-tɨ ə je dꞌilə-né ta dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dɔgangɨ-é-tɨ kinlé, kosɨ dow-je kɨ́ ɓudɔgɨ dɔgɨ lo n̰a̰ ya ꞌkəw-na̰ adɨ dꞌubə-na̰ lo-tɨ bangɨ-bangɨ ɓá Jeju pa ta adɨ njéndó né-je liə ya kete panè: Sə̰i kan! Ooi go rɔ-si majɨ kdɔ əm lə Parisi-je kɨ́ to kədkəm dow-je kin. ");
INSERT INTO mge_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Né kɨ́ dow ɓɔyɔ kɨ́ gin-é à tḛḛ al ya goto rəm, ɓá ta kɨ́ tò lo ɓɔyɔ-é-tɨ kɨ́ dow à gə al kàrè goto rəm. ");
INSERT INTO mge_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gin-é kin ɓá, né-je lay kɨ́ ꞌpai ta-é ndɔɔ lé, dꞌa koo ta-é dan kada; ə ta kɨ́ sə̰i ꞌpai mbi dow-tɨ n̰ɔ̰m-n̰ɔ̰m bè mḛḛ kəy-tɨ duni nṵ ya kàrè, dꞌa kilə-né mbḛ dɔ kəy-tɨ taá. ");
INSERT INTO mge_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sə̰i nam-m-je, mꞌa kidə-si rəsɨ. Dḛ kɨ́ dꞌa tɔl dajɨ rɔ-si ə dꞌa kasɨ ra sə-si né kɨ́ rangɨ go-tɨ al ngá kinlé, ꞌɓəli-dé al. ");
INSERT INTO mge_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mꞌa tɔjɨ-si ḛ kɨ́ sə̰i a ɓəli-é. Ḛ kɨ́ à tɔl dajɨ rɔ-si rəm, go-tɨ ɔw kɨ̀ tɔ́gɨ kadɨ ilə-é dan pər-tɨ kɨ́ tò sartagangɨ ɓəy kinlé ḛ ɓá ꞌɓəli-é; mꞌidə-si ta kɨ́ tɔgrɔ-tɨ, ḛ ɓá tò kadɨ ꞌɓəli-é. ");
INSERT INTO mge_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ꞌTḭḭ-je lé, ꞌndogɨ-dé mḭ kɨ̀ silə joo-joo ya al wa? Lé bè ya kàrè, ḛ kɨ́ káre dan-dé-tɨ kɨ́ mḛḛ Lubə oy dɔ-é-tɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bəl dɔ-si kin ya kàrè tokɨ gə kɔr-é lay. Ə́n ə́ ꞌɓəli al, kdɔ gatɨ-si itə gatɨ ꞌtḭḭ-je nja n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mꞌa kidə-si kɨ́ dow kɨ́ rá-rá kɨ́ pa ta rəsɨ takəm dow-je-tɨ panè nꞌto dow lə-m lé, ma̰ Ngon lə dow mꞌa pa ta liə rəsɨ nɔ̰̀ malayka-je-tɨ lə Lubə panè, to dow lə-m ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngà dow kɨ́ ɔr ta kutɨ-m-tɨ takəm dow-je-tɨ panè, nꞌgə-m al lé, ma̰ kàrè mꞌa kɔr ta kutɨ-é-tɨ nɔ̰̀ malayka-je-tɨ lə Lubə panè, mꞌgə-é al ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ə dow kɨ́ rá-rá kɨ́ pa ta kɨ́ majɨ al dɔ Ngon lə dow-tɨ lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é, ngà dow kɨ́ pa ta kɔbɨ kɨ̀ Ndil kɨ́ aa njay lé, à tokɨ kin̰ə go-é kɔgɨ kadɨ-é al ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ngà lokɨ dꞌa kɔw sə-si kdɔ gangta dɔ-si-tɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je, kɨ̀ nɔ̰̀ njégangta-je-tɨ, kɨ̀ nɔ̰̀ njékɔ̰ɓe-je-tɨ lé, adi mḛḛ-si a̰ kə́kə́kə́ adɨ ꞌpainè: Se ta ri ɓá jꞌa pa wa əse jꞌa pa kɨ̀ gosɨ kɨ́ ban ɓá kdɔ pa-né ta dɔ rɔ-ji-tɨ wa al. ");
INSERT INTO mge_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kdɔ dɔkàdɨ̀-é-tɨ kin ya Ndil kɨ́ aa njay à ndó-si ta kɨ́ tò kadɨ ꞌpai. ");
INSERT INTO mge_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dow madɨ dan kosɨ dow-je-tɨ idə Jeju panè: Njèndó dow-je né, idə ngonkɔ̰-m adɨ néndubə kɨ́ bɔbɨ-ji in̰ə adɨ-ji lé ḛ kay kɨ́ ꞌlə-m adɨ-m. ");
INSERT INTO mge_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Beɓa Jeju ilə-é-tɨ panè: Sé ná̰ ɓá ində-m njègangta lə-si əse njèkay-si néndubə wa? ");
INSERT INTO mge_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Go-tɨ, ḛ idə dow-je lay panè: Ooi go rɔ-si majɨ dɔ né-tɨ lay kɨ́ to kəmkəḭ; kdɔtalə, lé dow isɨ dan nékingə-tɨ kɨ́ tò mburukɨ-mburukɨ ya kàrè, kisɨ-é kɨ̀ dɔ-é taá, to ta lə nékingə-é al. ");
INSERT INTO mge_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Beɓa Jeju idə-dé gosta káre panè: Dingəm káre bè kɨ́ to njènékingə, ɔw kɨ̀ dɔnangɨ kɨ́ ḛ ingə né titɨ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rəmə ḛ gɨr mḛḛ-é-tɨ panè: Lokɨ mꞌa kungɨ ko lə-m titɨ ya goto. Kin əjè mꞌra ban ə́n wa? ");
INSERT INTO mge_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Beɓa ḛ panè: Yən, né kɨ́ mꞌa ra ə́n: Mꞌa sane dam-je lə-m ə mꞌa kojɨ dam-je kɨ́ rangɨ kɨ́ boy-boy ɓá mꞌa kəw ko lə-m kɨ̀ ndəgɨ nékingə-m lay titɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ɓa mꞌa kidə rɔ-m ta panè: Rɔ-m, nékingə-i tò mburukɨ-mburukɨ kdɔ ɓal-je n̰a̰ ə́n ə́ ꞌuwə rɔ-i nangɨ ꞌtaakoo, ꞌuso, ꞌa̰y ə ꞌra rɔnəl. ");
INSERT INTO mge_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngà Lubə idə-é panè: Mbə́ dow! Ndɔɔ nè kin ya ꞌa koy. Ə ná̰ ngá ɓá né-je kɨ́ i isɨ ꞌɔsɨ dɔ-é natɨ kdɔ rɔ-i kinlé, à to kɨ́ liə wa? ");
INSERT INTO mge_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Beɓa Jeju ilə dɔ-tɨ panè: Dow kɨ́ njèkəw né kində ngangəm kdɔ rɔ-é yó ɓɨ to njènékingə takəm Lubə-tɨ al lé, tò titɨ-na̰ bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Go-tɨ, Jeju idə njéndó né-je liə panè: Gin-é kin ɓá mꞌidə-si panè: Adi mḛḛ-si a̰ kə́kə́kə́ adɨ ꞌpainè: Ri ɓá jꞌa kuso kdɔ kisɨ-né əse jꞌa kingə kubɨ rá ɓá jꞌa kɔɔ wa al. ");
INSERT INTO mge_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kdɔ kisɨ kɨ̀ dɔ taá lə dow majɨ n̰a̰ itə nékuso ə dajɨ rɔ dow majɨ n̰a̰ itə kubɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ooi ꞌgaga̰-je: Dḛ ꞌdubɨ ko al rəm, dꞌijə ko al rəm, dꞌɔw kɨ̀ kəy ngəm né al rəm, ɓá dꞌɔw kɨ̀ dam al rəm, ya ngà Lubə isɨ ul-dé! Ə sə̰i lé, gatɨ-si itə gatɨ yəl-je kin sa̰y! ");
INSERT INTO mge_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ná̰ dan-si-tɨ ɓá à kasɨ kilə ndɔ-é dɔ madɨ-é-tɨ sḛ kɨ̀ takul mḛḛ ka̰ kə́kə́kə́ liə wa? ");
INSERT INTO mge_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kinə né kɨ́ sḛ bè kàrè, sə̰i a kasi rai al lé, kdɔ ri ɓá sə̰i adi mḛḛ-si a̰ kə́kə́kə́ kdɔ né-je kɨ́ rangɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uni kəm-si ooi-né wale-je kɨ́ mḛḛ ndɔr-tɨ ə ooi putɨ-dé: Dḛ ꞌra kullə madɨ al rəm, dꞌojɨ kubɨ al rəm, ya ngà adɨ mꞌidə-si rəsɨ kɨ́ Salomɔ̰ kɨ́ to njènékingə kɨ́ n̰a̰ kin ya kàrè, ɔɔ kubɨ-je kɨ́ ndóle asɨ kɨ̀ putɨ wale-je kin nja káre al. ");
INSERT INTO mge_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sə̰i dow-je kɨ́ kadmḛḛ lə-si to kɨ́ ndḛ bè kan! Wale-je kɨ́ dꞌa̰ mḛḛ ndɔr-je-tɨ ɓone ya ə bore pər à kɔ̰̀-dé kin kàrè, Lubə adɨ ꞌmɔ̰ne kɨ̀ putɨ-dé mbṵṵ rəm ngà, sə̰i kɨ́ ban ɓá ḛ à kadɨ-si kubɨ al wa? ");
INSERT INTO mge_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sə̰i lé, adi rɔ-si kɔ̰̀ ꞌsangi-né nékuso kɨ̀ man ka̰y ya par-par al. ");
INSERT INTO mge_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kdɔ né-je lay kinlé, gin dow-je lay kɨ́ dɔnangɨ-tɨ ɓá dꞌadɨ rɔ-dé kɔ̰̀ ꞌsangɨ par-par; ngà sə̰i rəmə, Bɔbɨ-si gə majɨ kɨ́ né-je kinlé ɔwi ndoo-é. ");
INSERT INTO mge_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kɔ̰ɓe liə ɓá ꞌsangi ə né-je kinlé, ḛ à kadɨ-si dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ꞌƁəli al, sə̰i kutɨ dow-je lə-m kɨ́ ndḛ bè kin! Kdɔ nəl Bɔbɨ-si kadɨ adɨ-si kɔ̰ɓe liə. ");
INSERT INTO mge_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ꞌNdógi nékingə-si ə ꞌləbi là-é njéndoo-je kadkare-tɨ. ꞌRai mbu là-je kɨ́ à tujɨ al ə né-je lə-si kɨ́ majɨ kɨ́ à tò sartagangɨ lé, ꞌkəwi indəi ngangəm mḛḛ dɔra̰-tɨ, kɨ́ to lo kɨ́ njéɓogɨ-je dꞌa ɓogɨ-tɨ al rəm, ɓá n̰ɔ̰ à kɔ̰̀-tɨ al rəm. ");
INSERT INTO mge_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kdɔ lo kɨ́ né lə-si kɨ́ indəi ngangəm tò-tɨ lé, lo-é ya mḛḛ-si à tò dɔ-tɨ gə́rə́rə́ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ꞌDɔɔi ɓədɨ-si kɨ̀ ndaá dɔɔ ɓədɨ ə adi pər tò lampɨ-je-tɨ lə-si. ");
INSERT INTO mge_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ə sə̰i lé, kadɨ ꞌtiti-na̰ kɨ̀ dow-je kɨ́ dꞌisɨ ngəbɨ ꞌɓa-dé kɨ́ à kḭ lo nékuso-tɨ kɨ́ lo taana̰-tɨ kisɨ təl, kadɨ lokɨ ree ində takəy rəmə, tajinatɨ nè ya ꞌtḛḛ dꞌadɨ-é kin bè. ");
INSERT INTO mge_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ngannjékullə-je kɨ́ dꞌisɨ kəm ya ꞌɓa-dé ree ingə-dé-né lé, ɓá to njénékumə̰-je. Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ ḛ à dɔɔ ɓədɨ-é kɨ̀ ndaá dɔɔ ɓədɨ ə à kadɨ-dé dꞌisɨ nangɨ ɓá à ree kadɨ-dé nékuso. ");
INSERT INTO mge_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lé ḛ ree dan lo-tɨ bapɨ əse taginlo-tɨ ya ɓá ingə-dé kɨ́ dꞌisɨ kəm rəmə, dḛ ꞌto njénékumə̰-je! ");
INSERT INTO mge_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kadɨ ꞌgəi né kin majɨ tɔ: Kinə ꞌɓa njèkəy gə dɔkàdɨ̀ kɨ́ njèɓogɨ à ree-né lé, ḛ à kin̰ə-é kadɨ ɔw mḛḛ kəy-tɨ liə al. ");
INSERT INTO mge_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sə̰i ya kàrè, isi dɔ nja-si-tɨ, kdɔ Ngon lə dow lé à ree dɔkàdɨ̀-tɨ kɨ́ sə̰i ꞌgɨri dɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Beɓa Piyər dəjɨ-é panè: ꞌƁaɓe, gosta kinlé ꞌpa adɨ-ji jḛ ya par əse ꞌpa adɨ dow-je lay wa? ");
INSERT INTO mge_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ꞌƁaɓe ilə-é-tɨ panè: Ná̰ ɓá to njèkoo go né-je kɨ́ to njèra né kɨ́ tɔgrɔ-tɨ kɨ́ to njèkəmtutɨ wa? To ḛ kɨ́ ꞌɓa-é ində-é dɔ madkullə-je-tɨ liə, kdɔ kadɨ oo go-dé kɨ̀ nékuso kɨ̀ dɔkàdɨ̀-é dɔkàdɨ̀-é. ");
INSERT INTO mge_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ngonnjèkullə kɨ́ ꞌɓa-é təl ree mḛḛ kəy-tɨ liə ɓá ingə-é ta kullə-tɨ titɨ-na̰ bè lé, to njènékumə̰. ");
INSERT INTO mge_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ooi majɨ, mꞌa kidə-si rəsɨ; ꞌɓa-é à kin̰ə nékingə-é-je lay mḛḛ ji-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngà kinə ngonnjèkullə kinlé, pa mḛḛ-é-tɨ panè: «ꞌƁa-m à təl ree kalangɨ al ɓəy», adɨ isɨ ta tində madkullə-je-tɨ liə kɨ́ dingəm kɨ̀ dḛ kɨ́ dené rəm, ḛ uso né ə a̰y yibɨ adɨ ra-é lé, ");
INSERT INTO mge_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ꞌɓa-é à təl ree kubə-é nangɨ busɨ ndɔ-tɨ kɨ́ ḛ ində mḛḛ-é dɔ-tɨ al rəm, ɓá dɔkàdɨ̀-tɨ kɨ́ ḛ gə al rəm tɔ. Ḛ à kində-é kində kɔjɨ kɨ́ nga̰ n̰a̰ ə à kadɨ-é ingə kɔ̰̀ lə njéra né kɨ́ tɔgrɔ-tɨ al-je. ");
INSERT INTO mge_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ngonnjèkullə kɨ́ gə né kɨ́ mḛḛ-é ꞌɓa-é ndigɨ ya ngà, ḛ ɔsɨ dɔ né-je natɨ al rəm, ra kɨ́ go mḛḛ ndigɨ-tɨ lə ꞌɓa-é al rəm lé, dꞌa kində-é ta ndəy n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngà ngonnjèkullə kɨ́ gə né kɨ́ mḛḛ-é ꞌɓa-é ndigɨ al, ɓá ra né kɨ́ asɨ kində rəmə, dꞌa kində-é ta ndəy sḛ bè. Dow kɨ́ dꞌadɨ-é né n̰a̰ lé, dꞌa dəjɨ né ji-é-tɨ n̰a̰ ya tɔ, ə dow kɨ́ dꞌin̰ə né mḛḛ ji-é-tɨ n̰a̰ lé, dꞌa dəjɨ né mḛḛ ji-é-tɨ n̰a̰ dɔ madɨ-é-tɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mꞌree mꞌulə pər dɔnangɨ-tɨ nè ə mꞌndigɨ kadɨ pər lé, ɔ̰̀ ya rəm ngá. ");
INSERT INTO mge_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Batḛm káre tò nɔ̰ɔ̰ kadɨ dꞌa ra-m ə mḛḛ-m ɓa ɓɔ́kɨ-ɓɔ́kɨ sar kadɨ ꞌra-m ɓane. ");
INSERT INTO mge_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sə̰i ꞌgɨri kɨ́ to lapiya ɓá mꞌree-né dɔnangɨ-tɨ wa? Bè al! Adɨ mꞌidə-si, ma̰ lé mꞌree kɨ̀ gángɨ-na̰. ");
INSERT INTO mge_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kḭ nè kɔw kɨ kete kinlé, dow-je ꞌra mḭ mḛḛ kəy-tɨ je bè rəmə dꞌa gángɨ-na̰. Dḛ kɨ́ mutə dꞌa kɔsɨ ta dḛ kɨ́ joo ə dḛ kɨ́ joo dꞌa kɔsɨ ta dḛ kɨ́ mutə tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bɔbɨ ngon à kɔsɨ ta ngon-é kɨ́ dingəm, ə ngon kɨ́ dingəm à kɔsɨ ta bɔbɨ-é tɔ. Kɔ̰ ngon à kɔsɨ ta ngon-é kɨ́ dené ə ngon kɨ́ dené à kɔsɨ ta kɔ̰-é tɔ. Kɔ̰ ngon kɨ́ dingəm à kɔsɨ məm-é kɨ̀ ta ə məm-é lé à kɔsɨ-é kɨ̀ ta tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jeju idə kosɨ dow-je ɓəy panè: Lokɨ sə̰i ooi kilndi lo kur kàdɨ̀-tɨ lé, sə̰i ꞌpai tajinatɨ nè ya ꞌpainè ndi à kədɨ ə ndi ədɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ə lokɨ sə̰i ooi yəl ḭ kɨ go lo-tɨ kɨ́ bəə isɨ ulə rəmə, sə̰i ꞌpainè: Lo à tungə ə lo tungə ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sə̰i njékədkəm dow-je kan! Asi kɔri mbunə̰ né-je kɨ́ ra né dɔnangɨ-tɨ nè, kɨ̀ ḛ kɨ́ dɔra̰-tɨ, ngà ban ɓá sə̰i ꞌgəi kɔri mbunə̰ né-je kɨ́ dɔkaglo-tɨ kɨ́ ngɔsnè kin al wa? ");
INSERT INTO mge_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngà kdɔ ri ɓá sə̰i ya kɨ́ dɔ rɔ-si asi kɔri mbunə̰ né kɨ́ njururu tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lokɨ ꞌisɨ ꞌɔw lo gangta-tɨ kɨ̀ njèta lə-i lé, ꞌulə nojɨ natɨ siə dɔ rəbɨ-tɨ ya, nè kinə ɔw tḛḛ sə-i nɔ̰̀ njègangta-tɨ lé, njègangta à kilə-i ji asgar-tɨ kadɨ-é ilə-i dangay-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mꞌa kidə-i rəsɨ; ꞌa kugə ngər-ngər, sisi ya kàrè à nà̰y al ɓá ꞌa tḛḛ dangay-tɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dɔkaglo-é-tɨ kinlé, dow-je madɨ ꞌree dꞌɔr poyta dꞌadɨ Jeju. To ta lə dow-je kɨ́ dɔnangɨ Galile-tɨ kɨ́ ndɔkɨ dꞌa̰ ꞌgugɨ né ɓá gubərnər Pilatɨ adɨ ꞌtɔl-dé, adɨ məsɨ-dé pote natɨ kɨ̀ məsɨ da̰-je kɨ́ dꞌilə dꞌadɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jeju ilə-dé-tɨ panè: Dow-je kɨ́ Galile kɨ́ ꞌtɔl-dé kinlé, sə̰i ꞌgɨri tokɨ dḛ ɓá ꞌto njéramajal tɔy ndəgɨ dow-je kɨ́ Galile lay ɓá kɔ̰̀ kɨ́ tana̰ bè kin tḛḛ-né dɔ-dé-tɨ tin wa? ");
INSERT INTO mge_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bè al! Adɨ mꞌidə-si, kinə sə̰i in̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ al lé, sə̰i lay ya a koyi tɔ. ");
INSERT INTO mge_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Əse dow-je kɨ́ dɔgɨ gidɨ-é jinà̰y joo kɨ́ ndɔkɨ ndogɨ bɔr kɨ́ Silowe kɨ́ ɓebo Jorijalḛm-tɨ usɨ dɔ-dé-tɨ adɨ dꞌoy kinlé, sə̰i ꞌgɨri to kɨ́ dḛ ɓá kullə ra-dé majɨ al tɔy ndəgɨ dow-je lay kɨ́ ɓebo Jorijalḛm-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bè al! Adɨ mꞌidə-si, kinə sə̰i in̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ al lé, sə̰i lay ya a koyi tɔ. ");
INSERT INTO mge_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jeju pa gosta kin dɔ-tɨ ɓəy panè: Dow káre bè ɔw kɨ̀ kote mḛḛ ndɔr nduu-tɨ liə. Ḛ ree sangɨ kandɨ-é dɔ-tɨ rəmə ingə al. ");
INSERT INTO mge_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Beɓa ḛ idə njèrakullə mḛḛ ndɔr nduu-tɨ lé panè: ꞌOo bè, kote kinlé mꞌree mꞌsangɨ kandɨ-é dɔ-tɨ bè-bè ya ɓal mutə kol nè, ngà mꞌingə al. Ə́n ə́ ꞌtugə-é ꞌgangɨ-é kɔgɨ! Ri ɓá a̰ utɨ lo kare bè kdɔ wa? ");
INSERT INTO mge_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Njèrakullə mḛḛ ndɔr nduu-tɨ lé ilə-é-tɨ panè: ꞌƁa-m, kol nè kinlé, in̰ə-é adɨ jꞌoo ɓəy. Mꞌa ndər gin-é gəə sipɨ ə mꞌa kungɨ sḭ né titɨ. ");
INSERT INTO mge_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dɔmajɨ ə gogɨ rangɨ à kandɨ ngá. Ngà kinə andɨ al ɓəy rəmə je ꞌtugɨ-é gangɨ-é kɔgɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ndɔ káre bè, Jeju isɨ ndó né dow-je mḛḛ kəykəwna̰-tɨ lə jipɨ-je ndɔ taakoo-tɨ lə-dé, ");
INSERT INTO mge_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ə dené káre kɨ́ ndil kɨ́ majɨ al ra-é adɨ-é to mətɨ ɓal dɔgɨ gidɨ-é jinà̰y joo isɨ nɔ̰ɔ̰. Dené lé, ma̰a̰ kɔngɨ-kɔngɨ adɨ asɨ ndajɨ rɔ-é taá al kɨ́ pɛtɨ-pɛtɨ-je-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lokɨ Jeju un kəm-é oo-é lé, ḛ idə-é panè: Dené, mətɨ lə-i tokɨ kɔr dɔ-i-tɨ kɔgɨ ngá! ");
INSERT INTO mge_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Go-tɨ, Jeju ində ji-é dɔ-é-tɨ, rəmə tajinatɨ nè ya dené ndajɨ rɔ-é taá ə ɔsɨ gajɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngà njèkun dɔ kəykəwna̰ lə jipɨ-je ɓá wɔngɨ ra-é, kdɔ lapiya kɨ́ Jeju adɨ dené ndɔ taakoo-tɨ lə jipɨ-je lé, adɨ idə kosɨ dow-je panè: Ndɔ ra kullə ra mɛkḛ ə́ mḛḛ ndɔ-é-je-tɨ kin ɓá ꞌreei adɨ dꞌadɨ-si lapiya, ɓɨ ꞌreei ndɔ taakoo-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ꞌƁaɓe ilə-é-tɨ panè: Sə̰i njékədkəm dow-je kan! Ná̰ ya dan-si-tɨ ɓá ndɔ taakoo-tɨ lə jipɨ-je lé, tutɨ mangɨ liə əse koro liə lo kuso né-tɨ ɔw siə adɨ-é a̰y man al wa? ");
INSERT INTO mge_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngà dené kan kɨ́ to ngonka Abrakam ɓá Sata̰ uwə-é gin tɔ́gɨ-é-tɨ ɓal dɔgɨ gidɨ-é jinà̰y joo lé ɓá kadɨ tokɨ taa-é kilə-é taá kɨ̀ ndɔ taakoo lə jipɨ-je al wa? ");
INSERT INTO mge_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Lokɨ Jeju pa ta kin bè lé, njékilə ta dɔ-é-tɨ-je lay ya dꞌoo ta kɨ́ dꞌa pa al. Ngà kosɨ dow-je rəmə, ꞌra rɔnəl dɔ né-je-tɨ lay kɨ́ tò ɓəl-ɓəl kɨ́ ḛ rá-rá lé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jeju pa ɓəy panè: Kɔ̰ɓe lə Lubə lé titɨ-na̰ kɨ̀ ri wa? Ə ri ɓá mꞌa kun kɔjɨ-né kɔ̰ɓe lə Lubə lé wa? ");
INSERT INTO mge_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kɔ̰ɓe lə Lubə lé, titɨ-na̰ kɨ̀ ka̰a̰ kɔl kɨ́ dow un ilə mḛḛ ndɔr-tɨ liə adɨ ubə ə tɔgɨ, rəmə yəl-je kɨ́ njénar taá ꞌree dꞌuwə lo kisɨ balkəm-é-je-tɨ kin bè. ");
INSERT INTO mge_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jeju pa ya ɓəy panè: Ri ɓá mꞌa kun kɔjɨ-né kɔ̰ɓe lə Lubə lé wa? ");
INSERT INTO mge_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kɔ̰ɓe lə Lubə lé titɨ-na̰ kɨ̀ əm kɨ́ dené káre bè un lɔ̰y-né ndujɨ kɨ́ ꞌmbɔjɨ mḛḛ kee mutə adɨ ndujɨ kɨ́ lɔ̰y lay ya ḭ kin bè. ");
INSERT INTO mge_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lokɨ Jeju isɨ ɔw dɔ-é kɨ ɓebo Jorijalḛm-tɨ lé, ḛ ndó né dow-je taá-taá ində-né dan ɓebo-je kɨ̀ nganɓe-je gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Beɓa dow madɨ dəjɨ-é panè: Dow-je kɨ́ dꞌa kingə kajɨ lé kɔr-dé n̰a̰ al wa? ");
INSERT INTO mge_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jeju ilə-é-tɨ panè: ꞌNduri dɔ rɔ-si-tɨ kadɨ ɔwi kɨ̀ tarəbɨ kɨ́ tò mbɔyɔyɔ bè. Mꞌidə-si, dow-je n̰a̰ ya dꞌa sangɨ kadɨ dꞌɔw kɔ̰ɓe-tɨ lé ya ngà dꞌa kasɨ al. ");
INSERT INTO mge_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lokɨ njèkəy à kḭ taá ə à kutɨ tarəbɨ ɓá sə̰i a ka̰i ndaa-tɨ kindəi tarəbɨ painè: «ꞌƁaɓe, ꞌƁaɓe ꞌtḛḛ tarəbɨ adɨ-ji» lé, ḛ à kilə-si-tɨ panè: «Sə̰i lé, ꞌtoi dow-je kɨ́ rá kàrè ma̰ mꞌgə al.» ");
INSERT INTO mge_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Rəmə, sə̰i a pai siə painè: «Jḛ ɓá jꞌisɨ takəm-i-tɨ ya jꞌuso né rəm, jꞌa̰y man rəm lé al wa? Jḛ ɓá i ꞌndó né dow-je ka rəbɨ-je-tɨ lə-ji lé al wa?» ");
INSERT INTO mge_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ə ḛ à kilə-dé-tɨ panè: «Sə̰i lé, ꞌtoi dow-je kɨ́ rá kàrè ma̰ mꞌgə al! Ɔti kɨ rangɨ ta-m-tɨ, sə̰i lay kɨ́ ꞌtoi njéra né-je kɨ́ njururu al.» ");
INSERT INTO mge_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lokɨ a kooi njépata-je kɨ́ ta Lubə-tɨ lay, kɨ̀ Abrakam-je, kɨ̀ Isakɨ-je, kɨ̀ Jakobɨ-je kɔ̰ɓe-tɨ lə Lubə, ngà sə̰i ɓá dꞌa kungɨ-si ndaa-tɨ lé, a nɔ̰i rəm, a tɔ̰i ngangɨ-si məgəgə-məgəgə lo-é-tɨ kin. ");
INSERT INTO mge_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Rəmə dow-je dꞌa kḭ kɨ lo kubə kàdɨ̀-tɨ, kɨ̀ lo kur kàdɨ̀-tɨ rəm, dꞌa kḭ kɨ go lo-tɨ kɨ́ bəə kɨ̀ dḛ kɨ́ dꞌa kḭ kɨ go lo-tɨ kɨ́ taá, dꞌa ree kisɨ ta nékuso-tɨ kɔ̰ɓe-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ooi bè, dow-je kɨ́ ná̰-je dan dḛ kɨ́ gogɨ-tɨ dꞌa təl to dow-je kɨ́ kete ə dow-je kɨ́ dan-tɨ-je dan dḛ kɨ́ kete-tɨ dꞌa təl to dow-je kɨ́ gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dɔkàdɨ̀-é-tɨ kinlé ya Parisi-je kɨ́ dan-tɨ-je ꞌree dꞌidə Jeju ꞌpanè: ꞌƆw! Ɔtɨ rangɨ lo kin-tɨ, kdɔ ngar Erodɨ ndigɨ tɔl-i. ");
INSERT INTO mge_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ḛ ilə-dé-tɨ panè: «Ɔwi idəi tal dow kɨ́ njèkədɨ dow-je kinlé ꞌpai-nè: “Ɓone kɨ̀ bore kinlé, mꞌa tubə ndil-je kɨ́ majɨ al dɔ dow-je-tɨ rəm, ɓá mꞌa kadɨ lapiya njémɔ̰y-je ə ndɔ kɨ́ njèkungɨ-tɨ mutə ɓá mꞌa tɔl ta-é. ");
INSERT INTO mge_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ngà ɓone, kɨ̀ bore kɨ̀ lo kaa kinlé, tò kadɨ mꞌun tarəbɨ lə-m kɨ Jorijalḛm, kdɔ njèpata kɨ́ ta Lubə-tɨ lé, oy ɓebo Jorijalḛm-tɨ ɓane ɓɨ oy rangɨ lé, to né kɨ́ tuwə al.”» ");
INSERT INTO mge_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jeju pa ɓəy panè: ꞌWa! Sə̰i dow-je kɨ́ Jorijalḛm! ꞌWa! Sə̰i dow-je kɨ́ Jorijalḛm! Sə̰i ꞌtoi njétɔl njépata-je kɨ́ ta Lubə-tɨ, njétilə dow-je kɨ́ Lubə ulə-dé rɔ-si-tɨ kɨ̀ ər tɔl-dé. Nja kandangɨ-kandangɨ ə́ mꞌndigɨ kəw-si kɨ rɔ-m-tɨ tana̰ kɨ́ kɔ̰ kunjə kəw-né ngan-é gin bagɨ-é-tɨ kin bè ə́ ꞌmbati! ");
INSERT INTO mge_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ooi majɨ, kəy lə-si à tokɨ tusɨ kin̰ə kɨ dɔ-si-tɨ nɔ̰ɔ̰! Ngà mꞌa kidə-si rəsɨ; a kooi-mi gogɨ al ya sar kaglo-tɨ kɨ́ a pai-né painè: Kadɨ Lubə tɔr ndi-é dɔ dow-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe! ");
INSERT INTO mge_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ndɔ káre bè kɨ́ to ndɔ taakoo lə jipɨ-je lé, Jeju ɔw mḛḛ kəy-tɨ lə ꞌboy lə Parisi-je káre kdɔ kuso né rəmə, Parisi-je dꞌində kəm-dé dꞌoo-é soo. ");
INSERT INTO mge_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dingəm káre kɨ́ mɔ̰y ra-é adɨ tii kori-kori a̰ nɔ̰̀-é-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeju un ta dəjɨ njéndó dow-je ndukun-je, kɨ̀ Parisi-je lé panè: To tó-é kadɨ dow adɨ lapiya njèmɔ̰y ndɔ taakoo-tɨ əse to tó-é al wa? ");
INSERT INTO mge_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dḛ dꞌilə-é-tɨ al. Beɓa Jeju ulə ji-é uwə-né njèmɔ̰y lé, ə adɨ-é lapiya ɓá adɨ-é ɔw ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Go-tɨ, Jeju idə-dé panè: Ná̰ dan-si-tɨ nè ɓá ngon-é əse mangɨ liə usɨ bole ndɔ taakoo-tɨ ɓá tajinatɨ nè ya à kɔr-é tḛḛ siə ndaa-tɨ al wa? ");
INSERT INTO mge_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kin kàrè dḛ ꞌgə ta kɨ́ dꞌa kilə-tɨ al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lokɨ Jeju oo kɨ́ dow-je kɨ́ ꞌɓa-dé lo nékuso-tɨ lé, ná̰-ná̰ ya kàrè sangɨ lokisɨ kɨ́ kete-kete rəmə, un gosta kin idə-dé-né ta panè: ");
INSERT INTO mge_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kinə dow ɓa-i lo nékuso taana̰-tɨ rəmə, ꞌɔw ꞌisɨ lokisɨ-tɨ kɨ́ kete al. Dɔmajɨ ə dan dow-je-tɨ kɨ́ ꞌɓa-dé kinlé, dow kɨ́ boy n̰a̰ tɔy-i à ka̰ nɔ̰ɔ̰, ");
INSERT INTO mge_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","rəmə dow kɨ́ njèɓa-si joo lay lé à kḭ panè: «ꞌIn̰ə lo adɨ dow kan.» Beɓa lokɨ i ꞌtəl kdɔ kɔw kisɨ lo-tɨ kɨ́ gogɨ lé, rɔ-i à sɔl-i. ");
INSERT INTO mge_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ngà lokɨ dow ɓa-i lé, ꞌɔw ꞌisɨ lo-tɨ kɨ́ gogɨ, kdɔ kadɨ lokɨ njèɓa-si lé ree rəmə, idə-i panè: «Nam-m, al kɨ́ kete nè.» Beɓa ꞌa kingə riɓa takəm dow-je-tɨ lay kɨ́ dꞌa kisɨ sə-i ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kdɔtalə dow kɨ́ ɔjɨ rɔ-é lé, dꞌa kulə dɔ-é nangɨ, ngà dow kɨ́ sɔl dɔ-é ɓá dꞌa kitə dɔ-é kɨ́ taá tɔ. ");
INSERT INTO mge_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jeju idə dow kɨ́ njèɓa-é lé tɔ panè: Lokɨ ꞌra nékuso kɨ́ kada əse nékuso kɨ́ ndɔɔ kàrè ꞌɓa nam-i-je al rəm, ngankɔ̰-i-je al rəm, nojɨ-i-je əse njétakəy-je lə-i kɨ́ ꞌto njénékingə-je al rəm tɔ; nè dḛ kàrè dꞌa kḭ ɓa-i kdɔ kadɨ-i tó-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ngà lokɨ ꞌra nékuso lo ra na̰y-tɨ rəmə, ꞌɓa njéndoo-je, kɨ̀ njérɔkoy-je, kɨ̀ njémətɨ-je, kɨ̀ njékəmtɔ-je. ");
INSERT INTO mge_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Rəmə i ꞌa to njènékumə̰, kdɔ dḛ dꞌa kasɨ kadɨ-i tó-tɨ al. Ndɔ kɨ́ dow-je kɨ́ njéra né kɨ́ njururu dꞌa tɔsɨ ndəl kində lo tḛḛ lé, Lubə à kadɨ-i tó-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lokɨ dow káre dan dow-je-tɨ kɨ́ dꞌisɨ ta nékuso-tɨ oo ta-je kin bè lé, idə Jeju panè: Dow kɨ́ à kisɨ ta nékuso-tɨ kɔ̰ɓe-tɨ lə Lubə ɓá to njènékumə̰. ");
INSERT INTO mge_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jeju ilə-é-tɨ panè: Ndɔ káre bè, dow káre ra nékuso n̰a̰ ya ɓa-né kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lokɨ dɔkàdɨ̀ kuso né asɨ lé, ḛ ulə ngonnjèkullə liə rɔ dow-je-tɨ kɨ́ ꞌɓa-dé lé panè: ꞌReei! Né-je tò nangɨ lay ngá. ");
INSERT INTO mge_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngà rəmə dḛ lay ya, ná̰-ná̰ dəjɨ-é kadɨ adɨ mḛḛ-é sɔl. Ḛ kɨ́ dɔsa̰y idə-é panè: Mꞌndogɨ londɔr nɔ̰ɔ̰, adɨ mꞌa kɔw koo ya ɓane ə́ mꞌdəjɨ-i kadɨ ꞌadɨ mḛḛ-i sɔl dɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ḛ kɨ́ rangɨ panè: Mꞌndogɨ mangndɔr-je dɔgɨ nɔ̰ɔ̰, adɨ mꞌa na̰-dé koo ə́ mꞌdəjɨ-i kadɨ ꞌadɨ mḛḛ-i sɔl dɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ḛ kɨ́ rangɨ pa ɓəy panè: Mꞌtaa dené ngɔsnè ɓəy, adɨ mꞌa kingə rəbɨ kɔw al. ");
INSERT INTO mge_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lokɨ ngonnjèkullə lé, təl ree rɔ ꞌɓa-é-tɨ rəmə, ɔr-é poy né-je kin lay. Beɓa wɔngɨ ra ꞌɓa njèkəy lé n̰a̰ adɨ idə ngonnjèkullə liə lé panè: Ḭ kalangɨ ɔw pandangɨ lo-je-tɨ, kɨ̀ rəbɨ-je kɨ́ mḛḛ ɓebo-tɨ ə ꞌree kɨ̀ njéndoo-je, kɨ̀ njèrɔkoy-je, kɨ̀ njékəmtɔ-je, kɨ̀ njémətɨ-je. ");
INSERT INTO mge_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sḛ go-tɨ rəmə, ngonnjèkullə lé ree panè: ꞌƁa-m, ndu-i kɨ́ ꞌun ꞌadɨ-m lé, mꞌra kullə-é lay ya ngà lo nà̰y ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Beɓa ꞌɓa njèkəy təl idə ngonnjèkullə lé panè: ꞌƆw ngan rəbɨ-je-tɨ kɨ́ wale, kɨ̀ go ngal bangá-je-tɨ ə́ dow-je kɨ́ ingə-dé ya rəmə, ꞌuwə-dé gə̀sə̀sə̀ ya adɨ ꞌree, kdɔ kadɨ ꞌrusɨ mḛḛ kəy lə-m. ");
INSERT INTO mge_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ə mꞌa kidə-si rəsɨ; dow-je kɨ́ mꞌɓa-dé kete kinlé, dow kɨ́ dan-dé-tɨ káre ya kàrè à kɔdɨ rɔ nékuso lə-m ta-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kosɨ dow-je n̰a̰ ꞌnjiyə go Jeju-tɨ ɓá ḛ təl kəm-é idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Kinə dow ree rɔ-m-tɨ ɓá mbatɨ bɔbɨ-é kɨ̀ kɔ̰-é, kɨ̀ ne-é kɨ̀ ngan-é-je, kɨ̀ ngankɔ̰-é-je, kɨ̀ kɔ̰nan-é-je ɓá mbatɨ dajɨ rɔ-é dɔ-tɨ kdɔ ta lə-m al lé, dowbé à kasɨ kadɨ to njèndó né lə-m al tɔ. ");
INSERT INTO mge_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Rəm, dow kɨ́ rá-rá ya un go-m ɓá un kagdəsɨ liə al lé, dowbé à kasɨ to njèndó né lə-m al. ");
INSERT INTO mge_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kdɔtalə dan-si-tɨ nè lé, kinə dow ndigɨ ra kəy kɨ́ boy rəmə, à kisɨ nangɨ kɔ́sɨ kdɔ kɔjɨ gangɨ là kɨ́ à ra-né kullə-é koo mɔkɨ, se là lé à kasɨ kadɨ nꞌra-né nꞌtɔl ta-é wa? ");
INSERT INTO mge_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kdɔtalə kinə dowbé ḭ par ya ində gin kəy nangɨ ɓá asɨ ra tɔl ta-é al lé, dow-je kɨ́ dꞌoo-é lo kində gin-é-tɨ lé, dꞌa kogɨ dɔ-é-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","panè: Dow kin ində gin kəy ə asɨ tɔl ta-é al. ");
INSERT INTO mge_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Əse ngar kɨ́ ban ɓá kinə isɨ ɔw rɔ dɔ madɨ-é-tɨ ɓá à kisɨ nangɨ kdɔ mbɔjɨ koo mɔkɨ, se asgar-je kɨ́ ɓudɔgɨ lo dɔgɨ kinlé, à kasɨ kadɨ nꞌrɔ-né kɨ̀ madɨ-nꞌḛ̀ kɨ́ isɨ ree kdɔ kilə rɔ dɔ-nꞌḛ̀-tɨ, kɨ̀ asgar-je ɓudɔgɨ lo kɔrjoo kin wa? ");
INSERT INTO mge_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kinə oo kɨ́ à kasɨ al rəmə, lokɨ ngar madɨ-é lé, nà̰y əbɨ ɓəy ya ḛ à kidə dow kɨ́ to takəm-é, kdɔ kadɨ ɔw dəjɨ-é kadɨ nꞌuləi nojɨ natɨ. ");
INSERT INTO mge_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bè ya tɔ, ná̰-ná̰ dan-si-tɨ ya kinə mbatɨ nékingə-é lay al lé, à kasɨ kadɨ to njèndó né lə-m al. ");
INSERT INTO mge_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Katɨ lé, to né kɨ́ majɨ ya, ngà kinə mbinə̰-é ɔr kɔgɨ lé, dow à ra-né ban ɓá à təl dɔ̰ gogɨ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","À majɨ kdɔ nangɨ al rəm, à majɨ kdɔ kungɨ gin né-je-tɨ al rəm ngá. Dꞌa kungɨ kɔgɨ gidɨ lo-tɨ. Dow kɨ́ mbi-é tò nɔ̰ɔ̰ kdɔ kadɨ oo-né ta rəmə, kadɨ oo ta kinlé! ");
INSERT INTO mge_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Njétaalambo-je, kɨ̀ njéramajal-je ꞌree rɔ Jeju-tɨ kdɔ koo ta liə. ");
INSERT INTO mge_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rəmə Parisi-je, kɨ̀ njéndó dow-je ndukun-je ꞌpa ta kɨ́ majɨ al dɔ-é-tɨ ꞌpanè: «Dingəm kanlé, uwə njéramajal-je kɨ rɔ-é-tɨ, ɓá uso sə-dé né rəm lé yaa!» ");
INSERT INTO mge_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Beɓa Jeju pa sə-dé ta kɨ̀ gosta panè: ");
INSERT INTO mge_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Dow kɨ́ rá ya dan-si-tɨ ɓá ɔw kɨ̀ batɨ-je ɓu ɓá ḛ kɨ́ káre nà̰y ə́ à kin̰ə dḛ kɨ́ kɔrjinà̰y káre gidɨ-é jinà̰y káre lo kuso né-tɨ diləlo-tɨ kdɔ kɔw sangɨ ḛ kɨ́ nà̰y lé sar kadɨ ingə-é al wa? ");
INSERT INTO mge_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ə lokɨ ingə-é lé, rɔ-é nəl-é n̰a̰ adɨ un-é səbɨ-é dam-é-tɨ kdɔ ree siə ɓee. ");
INSERT INTO mge_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Lokɨ ree tḛḛ ɓee lé, ḛ ɓa nam-é-je kɨ̀ njétakəy-je liə kɨ rɔ-é-tɨ ə idə-dé panè: ꞌRai sə-m rɔnəl, kdɔtalə batɨ lə-m kɨ́ nà̰y lé, mꞌingə-é. ");
INSERT INTO mge_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jeju ilə dɔ-tɨ panè: Bè ya tɔ, mꞌa kidə-si rəsɨ kɨ́ dow kɨ́ káre-rè kɨ́ to njèramajal ɓá in̰ə panjiyə-é kɨ́ majɨ al kɔgɨ lé, rɔnəl-é à tò n̰a̰ mḛḛ dɔra̰-tɨ, tɔy ꞌlə njéra né kɨ́ njururu kɨ́ kɔrjinà̰y káre gidɨ-é jinà̰y káre kɨ́ dꞌɔw ndoo kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ al kin. ");
INSERT INTO mge_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jeju pa gosta kɨ́ rangɨ ɓəy panè: Dené kɨ́ rá ɓá ɔw kɨ̀ sisi dɔgɨ ɓá káre usɨ kɔgɨ ə́ à kində pər lampɨ-tɨ, à kɔy mḛḛ kəy ə sangɨ lo majɨ-majɨ sar kadɨ ingə-né sisi lé al wa? ");
INSERT INTO mge_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Beɓa lokɨ ingə lé, ḛ ɓa nam-é-je kɨ̀ njétakəy-je liə kɨ rɔ-é-tɨ ə idə-dé panè: ꞌRai sə-m rɔnəl kdɔ sisi lə-m kɨ́ usɨ kɔgɨ lé, mꞌingə. ");
INSERT INTO mge_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jeju ilə dɔ gosta-tɨ kin panè: Bè ya tɔ ə́ mꞌa kidə-si rəsɨ; malayka-je lə Lubə ꞌra rɔnəl n̰a̰, kdɔtalə dow káre-rè kɨ́ to njèramajal ɓá in̰ə panjiyə-é-je kɨ́ majɨ al kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Beɓa Jeju təl pa ɓəy panè: Dingəm káre bè ɔw kɨ̀ ngan-je kɨ́ dingəm joo. ");
INSERT INTO mge_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ḛ kɨ́ ndḛ idə bɔbɨ-é panè: Bɔbɨ-m, néndubə kɨ́ ndɔ-é ə à to ꞌlə-m lé, adɨ-m. Beɓa bɔbɨ-dé kay-dé nékingə-é. ");
INSERT INTO mge_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ndɔ n̰a̰ al go-tɨ ya, ḛ kɨ́ ndḛ lé, ndogɨ né-je liə ngər-ngər ə ɔy là-é ɔw mba dɔnangɨ-tɨ kɨ́ sa̰y. Lo kin-tɨ ɓá ḛ tində né-je liə sane lay lo bɔkaya-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lokɨ ḛ tində sane lay rəmə, ɓobo usɨ dɔnangɨ-é-tɨ kinlé, ə né isɨ goto ji-é-tɨ ngá. ");
INSERT INTO mge_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Adɨ ḛ ɔw adɨ dingəm káre bè dɔnangɨ-é-tɨ kinlé un-é kullə-tɨ, adɨ-é isɨ ɔw ul kɔsɔngɨ-je liə. ");
INSERT INTO mge_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ḛ ndigɨ kuso gəbrə kɨ́ kɔsɔngɨ-je dꞌa̰ dꞌuso lé ya, ngà dow adɨ-é al. ");
INSERT INTO mge_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Beɓa ḛ gɨr ta dɔ rɔ-é-tɨ ə panè: Njérakullə-je lə bɔbɨ-m lay ya nékuso-dé tò mburukɨ-mburukɨ, rəmə ma̰ ɓá mꞌa kisɨ koy yo ɓo nè bè wa! ");
INSERT INTO mge_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mꞌa kḭ taá təl kɔw rɔ bɔbɨ-m-tɨ gogɨ ə mꞌa kidə-é panè: Bɔbɨ-m, mꞌra majal nɔ̰̀ Lubə-tɨ rəm, nɔ̰̀-i-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma̰ mꞌtuwə kadɨ i ꞌɓa-m ngon-i al, ngà kadɨ ꞌra-m tana̰ kɨ́ i ꞌra-né kɨ̀ njérakullə-je lə-i ya bè. ");
INSERT INTO mge_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Beɓa ḛ ubə nangɨ ḭ taá ə təl ɔw kɨ rɔ bɔbɨ-é-tɨ gogɨ. Lokɨ nà̰y sa̰y kɨ̀ kəy ɓəy ya bɔbɨ-é oo-é, ə ta ɔ̰̀ mḛḛ-é kdɔ ta liə adɨ a̰y ngɔdɨ tilə kəm-é, ungɨ ji-é mindɨ-é-tɨ uwə-né kɨ kàdɨ̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Rəmə ngon lé panè: Bɔbɨ-m, mꞌra majal nɔ̰̀ Lubə-tɨ rəm, nɔ̰̀-i-tɨ rəm, adɨ mꞌtuwə kadɨ i ꞌɓa-m ngon-i al. ");
INSERT INTO mge_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngà bɔbɨ-é idə ngannjékullə-je liə panè: Ɔti kalangɨ ꞌreei kɨ̀ kubɨ kɨ́ kurə́ itə madɨ-é-je ya, uləi rɔ-é-tɨ ə uləi ngama̰ ji-é-tɨ, ɓá ꞌtuləi saba nja-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɔwi ꞌreei kɨ̀ ngon bɔbɨ mangɨ kɨ́ rɔ-é to mbul-mbul kin ya ꞌtɔli adɨ jꞌusoi jꞌrai-né rɔnəl. ");
INSERT INTO mge_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kdɔtalə ngon-m kɨ́ a̰ kanlé, to dow kɨ́ oy ɓá təl isɨ kəm tin; ḛ ilə rɔ-é kɔgɨ ɓá təl ree tin. Beɓa ꞌtum gin ra rɔnəl. ");
INSERT INTO mge_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Dɔkàdɨ̀-é-tɨ kinlé, ngon dər dingəm lé nà̰y ndɔrɔ. Lokɨ isɨ təl ɓá tḛḛ ngɔsi kɨ̀ kəy rəmə, ḛ oo ká nékində-je kɨ̀ ká ndam-je. ");
INSERT INTO mge_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Beɓa ḛ ɓa ngonnjèkullə káre dəjɨ-é panè sé to ri ɓá ra né wa? ");
INSERT INTO mge_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ngonnjèkullə lé ilə-é-tɨ panè: Ngonkɔ̰-i lé təl ree ɓá bɔbɨ-i tɔl ngon bɔbɨ mangɨ kɨ́ rɔ-é tò mbul-mbul kinlé kdɔ ta liə, kdɔ ḛ ingə-é gogɨ kɨ̀ lapiya. ");
INSERT INTO mge_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Beɓa wɔngɨ ra ngon dər lé, adɨ ḛ ndigɨ kɔw kəy al, adɨ bɔbɨ-é tḛḛ ndaa-tɨ ree ra ndoo ta-é-tɨ kadɨ-é ɔw kəy. ");
INSERT INTO mge_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ḛ ilə bɔbɨ-é-tɨ panè: ꞌOo bè, ma̰ kɨ́ mꞌra kullə mꞌadɨ-i ɓal n̰a̰ rəm, mꞌal dɔ ndu-i nja káre al rəm kin ya kàrè ꞌtɔl ngon bin̰ə nja káre adɨ-m mꞌra-né rɔnəl kɨ̀ nam-je al. ");
INSERT INTO mge_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Rəmə, lokɨ ngon-i lə-i kan, kɨ́ tində nékingə-i sane dɔ kaya dené-je-tɨ lé təl ree, ə ḛ ɓá ꞌtɔl ngon bɔbɨ mangɨ lə-ji kɨ́ rɔ-é tò mbul-mbul lé adɨ-é! ");
INSERT INTO mge_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bɔbɨ-é idə-é panè: Ngon-m, i ꞌisɨ sə-m kɨ̀ ndɔ-é ndɔ-é, adɨ né-je lə-m lay to kɨ́ ꞌlə-i ya; ");
INSERT INTO mge_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ngà tò kadɨ jꞌra nékuso jꞌra-né rɔnəl, kdɔ ngonkɔ̰-i kɨ́ ꞌoo-é kanlé, to dow kɨ́ oy ɓá təl isɨ kəm tin; ḛ ilə rɔ-é kɔgɨ ɓá təl ree tin. ");
INSERT INTO mge_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeju idə njéndó né-je liə ɓəy panè: Dingəm kɨ́ njènékingə káre bè, ɔw kɨ̀ njèkoo go né-je liə nɔ̰ɔ̰. Dow-je dꞌidə-é ꞌpanè: «Njèkoo go né-je lə-i lé, isɨ tində né-je lə-i sane.» ");
INSERT INTO mge_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Beɓa ḛ ɓa-é pa siə panè: «Ta ri ɓá dow-je ꞌpa dɔ-i-tɨ ɓá mꞌoo mꞌoo tin wa? I lé, ꞌa to njèkoo go né-je lə-m al ngá, ə́ né-je kɨ́ mꞌin̰ə ji-i-tɨ kadɨ oo go-é lé ꞌɔr go-é adɨ mꞌoo.» ");
INSERT INTO mge_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Njèkoo go né-je lé, pa mḛḛ-é-tɨ panè: «ꞌƁa-m ɔr kullə koo go né-je liə ji-m-tɨ kinlé, ri ɓá mꞌa ra wa? Kadɨ mꞌra kullə ndɔr wa? Tɔ́gɨ-m à kasɨ al. Kadɨ mꞌkɔy né wa? Rɔ-m sɔl-m.» ");
INSERT INTO mge_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ḛ panè: «Mꞌgə né kɨ́ mꞌa ra kadɨ lokɨ ꞌɓa-m ɔr-m kullə koo go né-je-tɨ liə rəmə, dow-je dꞌuwə-m-né kɨ rɔ-dé-tɨ mḛḛ kəy-je-tɨ lə-dé.» ");
INSERT INTO mge_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Beɓa dow-je kɨ́ kurə lə ꞌɓa-é tò dɔ-dé-tɨ lé, ḛ ɓa-dé adɨ ree rɔ-é-tɨ káre-káre. Ə dəjɨ ḛ kɨ́ dɔsa̰y panè: «Kurə lə ꞌɓa-m tò dɔ-i-tɨ asɨ kandangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ə ḛ ilə-é-tɨ panè: «Kurə ubɨ liə tò dɔ-m-tɨ gùm ɓu.» Rəmə njèkoo go né-je lé, idə-é panè: «ꞌTaa mbete kurə lə-i, ꞌisɨ nangɨ kalangɨ ə ꞌndàngɨ ubɨ gùm kɔrmḭ.» ");
INSERT INTO mge_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Go-tɨ, ḛ dəjɨ ḛ kɨ́ rangɨ panè: «Kurə lə ꞌɓa-m to dɔ-i-tɨ asɨ kandangɨ wa?» Ḛ ilə-é-tɨ panè: «Kurə ko liə tò dɔ-m-tɨ suwal ɓu.» Rəmə njèkoo go né-je lé panè: «ꞌTaa mbete kurə lə-i ə ndàngɨ ko suwal kɔrjinà̰y joo.» ");
INSERT INTO mge_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Beɓa Jeju panè: «Njèkoo go né-je kɨ́ njèra né kɨ́ njururu al kinlé, ꞌɓa-é pitɨ-é kdɔ to kɨ́ ḛ to njèkəmtutɨ.» Jeju ilə dɔ-tɨ panè: «Dow-je kɨ́ njéra né kdɔ kaglo kɨ́ ngɔsnè kinlé, dꞌində kəmtutɨ n̰a̰ kɨ́ rɔ madɨ-dé-je-tɨ tɔ̀y dow-je kɨ́ dꞌisɨ lo kɨ́ ndógɨ-tɨ lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yən, adɨ mꞌidə-si rəsɨ: «Né-je kɨ́ ingəi kɨ̀ kəm rəbɨ-je kɨ́ njururu al kinlé, uwəi-né nam kdɔ kadɨ lokɨ né ree goto ji-si-tɨ kàrè rəmə, nam-si-je kinlé dꞌuwə-si kɨ rɔ-dé-tɨ lo kisɨ-je-tɨ kɨ́ tò sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dow kɨ́ ra né kɨ́ tɔgrɔ-tɨ mḛḛ né-je-tɨ kɨ́ ndḛ bè lé, ḛ ra né kɨ́ tɔgrɔ-tɨ mḛḛ né-tɨ kɨ́ boy tɔ. Dow kɨ́ ra né kɨ́ njururu al mḛḛ né-je-tɨ kɨ́ ndḛ bè lé, ḛ ra né kɨ́ njururu al mḛḛ né-tɨ kɨ́ boy tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Beɓa mḛḛ nékingə-je-tɨ kɨ́ ingəi kɨ̀ kəm rəbɨ-je kɨ́ njururu al kin ya kinə ꞌrai-né né kɨ́ tɔgrɔ-tɨ al lé, ná̰ ɓá à kin̰ə nékingə kɨ́ tɔgrɔ-tɨ mḛḛ ji-si-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ə kinə dow kɨ́ rangɨ in̰ə né liə ji-si-tɨ ɓá ꞌrai-né né kɨ̀ gangɨ-é al lé, né kɨ́ tokɨ ꞌlə-si ya kàrè ná̰ ɓá à kin̰ə mḛḛ ji-si-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ngonnjèkullə kɨ́ à kasɨ ra kullə kadɨ dow-je joo ya goto. Kdɔtalə à kɔsɨ ta ḛ kɨ́ káre ə à ndigɨ ḛ kɨ́ káre; al kàrè, à nam kɨ̀ ḛ kɨ́ káre ə à nədɨ ḛ kɨ́ káre. Adɨ a kasi kori Lubə kɨ̀ là natɨ joo kdɔ ra kullə kadɨ-dé al. ");
INSERT INTO mge_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lokɨ Parisi-je kɨ́ ꞌto mꞌoy yo là-je, dꞌoo ta-je kin lay bè rəmə, ꞌsɔkɨ Jeju. ");
INSERT INTO mge_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Beɓa Jeju idə-dé panè: «Sə̰i lé, takəm dow-je-tɨ rəmə, ꞌrai rɔ-si tokɨ dow-je kɨ́ njéra né kɨ́ njururu bè, ngà Lubə gə mḛḛ-si gɔw. Kdɔtalə né kɨ́ dow-je ɓá dꞌoo kɨ né kɨ́ asɨ gakɨ lé, takəm Lubə-tɨ rəmə, to nékɔbɨ.» ");
INSERT INTO mge_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ndukun-je lə Moiyijɨ, kɨ̀ mbete-je lə njépata-je kɨ́ ta Lubə-tɨ ya ra kullə sar ree tḛḛ dɔ Ja̰-tɨ kɨ́ njèra dow-je batḛm. Ə kḭ dɔ Ja̰-tɨ sar tḛḛ ɓone kin ya tokɨ kilə mbḛ kɔ̰ɓe lə Lubə ə ná̰-ná̰ ya ndur dɔ rɔ-é-tɨ kdɔ kadɨ nꞌɔw-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngà kadɨ dɔra̰, kɨ̀ dɔnangɨ goto lé, to né kɨ́ lo-é ɔ̰̀ al itə ndajɨ mbete kɨ́ káre bè kɨ́ kadɨ bujuru mḛḛ mbete ndukun-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ná̰-ná̰ kɨ́ tubə ne-é ə taa dené kɨ́ rangɨ lé, ra kaya, ɓá dow kɨ́ taa dené kɨ́ ngɔbɨ-é tubə-é kàrè ra kaya ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ndɔ káre bè, Jeju pa ta kɨ̀ gosta panè: Dingəm káre bè, isɨ nɔ̰ɔ̰ to njènékingə, ɔɔ kubɨ-je kɨ́ kər yə̀l-yə̀l kɨ́ là-é n̰a̰-n̰a̰ rəm, ndɔ̰y ngilingɨ-ngilingɨ ə ndɔ-é ndɔ-é ya ḛ uso né-je kɨ́ majɨ-majɨ ra-né rɔnəl. ");
INSERT INTO mge_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Beɓa njèndoo kɨ́ ri-é lə Lajar kɨ́ to dow kɨ́ rɔ-é lay ya to dò basrangɨ kɨ́ tò yəkɨ-yəkɨ, tò nangɨ takəy-tɨ lə njènékingə lé. ");
INSERT INTO mge_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ə ḛ ndigɨ kadɨ nꞌuso n̰ɔ̰-n̰ɔ̰ né-je kɨ́ tusɨ nangɨ gin tablə-tɨ lə njènékingə kinlé ya, rəmə bisɨ-je yó ɓá ꞌree tɔ̰n ta dò-je liə-liə. ");
INSERT INTO mge_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ndɔ káre bè, njèndoo kinlé oy ə malayka-je dꞌun-é dꞌɔw siə wur-wur mbɔ́ Abrakam-tɨ. Njènékingə lé ree oy tɔ, adɨ dow-je ꞌdubɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lokɨ ḛ a̰ lo kɨ́ koó-tɨ dan kɔ̰̀-tɨ ngá ɓá un kəm-é oo lo əbɨ nṵ rəmə, oo kɨ́ Lajar isɨ wur-wur mbɔ́ Abrakam-tɨ lé, ");
INSERT INTO mge_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ḛ ilə bɔbɨ ndi-é nangɨ panè: «Bɔbɨ-m Abrakam, ꞌoo kəmtondoo lə-m, ə ꞌulə Lajar adɨ ɔw ulə ta ngon ji-é kəm man-tɨ ə ree ilə ta-m-tɨ n̰ɔ̰m-né mindɨ-m, nè mꞌa̰ mꞌingə kɔ̰̀ dan pər-tɨ kɨ́ ɔ̰̀ bilɨm-bilɨm.» ");
INSERT INTO mge_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrakam ilə-é-tɨ panè: «Ngon-m, ꞌadɨ mḛḛ-i ole dɔ-tɨ, kɨ́ ndɔkɨ i oy-né al ɓəy lé, i isɨ dan majɨ-tɨ, ngà Lajar ɓá dangɨ-tɨ ra-é. Ə kɨ́ ngɔsnè-tɨ kinlé, ḛ ingə mḛḛ sɔl, ngà i ɓá ꞌa̰ dan kɔ̰̀-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rəm ɓá, mbunə̰-ji jḛ sə-si-je lé, boleɓe kɨ́ sɔ̰y-é goto ya tò-tɨ, kdɔ kadɨ dow-je kɨ́ lé, dꞌa ndigɨ kḭ rɔ-ji-tɨ nè kɔw rɔ-si-tɨ kàrè, jè lo-é dum-dé rəm, ɓá kadɨ dow ḭ rɔ-si-tɨ nṵ ree rɔ-ji-tɨ nè al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Njènékingə lé panè: «Bɔbɨ-m Abrakam, lé tò bè kàrè, mꞌdəjɨ-i kadɨ ꞌulə Lajar adɨ-é ɔw mḛḛ kəy-tɨ lə bɔbɨ-m. ");
INSERT INTO mge_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kdɔtalə ngankɔ̰-m-je mḭ dꞌisɨ nɔ̰ɔ̰ ə́ ꞌadɨ-é ɔw ndəjɨ-dé, kadɨ dḛ rəmə, ꞌree lo kɔ̰̀-tɨ kin al ngá.» ");
INSERT INTO mge_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrakam ilə-é-tɨ panè: «Ndukun-je lə Moiyijɨ, kɨ̀ ta-je lə njépata-je kɨ́ ta Lubə-tɨ tò nɔ̰ɔ̰, ə́ kadɨ dꞌində mbi-dé dꞌoo-né.» ");
INSERT INTO mge_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ḛ ilə-é-tɨ panè: «Bè al, Bɔbɨ-m Abrakam, kinə dow ḭ rɔ dow-je-tɨ kɨ́ dꞌoy ɓá ɔw idə-dé ta lé, dꞌa kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngà Abrakam idə-é panè: «Kinə dꞌində mbi-dé dꞌoo-né ndukun-je lə Moiyijɨ-je, kɨ̀ ta-je lə njépata-je kɨ́ ta Lubə-tɨ al lé, ta kɨ́ dow kɨ́ tɔsɨ ndəl ində lo tḛḛ ya idə-dé kàrè à kuwə-dé kɨ̀ ta al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeju idə njéndó né-je liə panè: Né-je kɨ́ à to gin kusɨ mḛḛ majal-tɨ lé, lé ri-ri kàrè à ree ya; ngà dow kɨ́ né-é-je kin ree kɨ̀ kəm rəbɨ kɨ́ rɔ-é-tɨ lé tujɨ à kusɨ dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dowbé kinlé, lé ꞌdɔɔ mbal kusɨ ko mindɨ-é-tɨ ɓá dꞌɔw dꞌilə-é-né dan babo-tɨ ya kàrè liə tò sotɨ, tɔy kadɨ-é ra ngon dow káre dan madɨ-é-je-tɨ kin adɨ-é ra majal. ");
INSERT INTO mge_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Indəi kəmkaa dɔ rɔ-si-tɨ! Kinə ngonkɔ̰-i ra majal lé, ꞌndángɨ-é dɔ-tɨ ə́ kinə in̰ə panjiyə-é kɨ́ majɨ al lé kɔgɨ rəmə, ꞌin̰ə go-é kɔgɨ ꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kinə mḛḛ ndɔ-tɨ kɨ́ káre ya ḛ ra sə-i né kɨ́ majɨ al nja siri, ɓá nja siri lay ya təl ree rɔ-i-tɨ panè: Mꞌin̰ə panjiyə-m kɨ́ majɨ al lé kɔgɨ rəmə, ꞌa kin̰ə go-é kɔgɨ kadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Njékɔwkulə-je dꞌidə ꞌƁaɓe ꞌpanè: ꞌIlə kadmḛḛ dɔ madɨ-é-tɨ ꞌadɨ-ji. ");
INSERT INTO mge_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Beɓa ꞌƁaɓe Jeju lé idə-dé panè: «Kinə kadmḛḛ lə-si asɨ-na̰ kɨ̀ ka̰a̰ kɔl bè ya kàrè ɓá idəi kote kin ꞌpainè: “ꞌƆr kɨ̀ njirə-i burə ə ꞌɔw a̰ dan babo-tɨ ya kàrè, ḛ à təl rɔ-é go ta-tɨ lə-si.”» ");
INSERT INTO mge_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Ná̰ dan-si-tɨ ɓá tokɨ ɔw kɨ̀ ngonnjèkullə káre nɔ̰ɔ̰ je bè, ə́ ḭ ndɔrɔ əse ḭ go nékul-je-tɨ isɨ ree ya ə́ à kidə-é panè ꞌnjiyə lɔw ꞌree uso né» wa? ");
INSERT INTO mge_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bè al! Ḛ à kidə-é panè: ꞌRa nékuso lə-m, ꞌulə kubɨ kullə lə-i rɔ-i-tɨ ə ꞌoo go-m sar kadɨ mꞌuso rəm, mꞌa̰y rəm, ngá ɓá i a təl kuso rəm, ka̰y rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ngonnjèkullə kinlé, lokɨ ḛ ra né kɨ́ ꞌɓa-é un ndu adɨ-é kadɨ ra lé, sé ꞌɓa-é à təl ra-é oiyo kdɔ kullə kɨ́ ḛ ra kinlé wa? ");
INSERT INTO mge_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bè al. Sə̰i kàrè bè ya tɔ. Lokɨ ꞌrai né-je lay kɨ́ dꞌun ndu dɔ-tɨ kadɨ ꞌrai lé, kadɨ ꞌpai-nè: Jḛ jꞌto ngannjékullə-je kɨ́ kare kɔgɨ, né kɨ́ tò kadɨ jꞌra lé ya ɓá jḛ jꞌra. ");
INSERT INTO mge_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lokɨ Jeju isɨ ɔw kɨ́ ɓebo Jorijalḛm-tɨ lé, dəə rəbɨ nim dɔnangɨ Samari-tɨ kɨ̀ dɔnangɨ Galile. ");
INSERT INTO mge_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Beɓa lokɨ isɨ ɔw mḛḛ ngonɓe-tɨ káre bè lé, ");
INSERT INTO mge_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","njébanjɨ-je dɔgɨ ꞌtḛḛ ꞌtilə kəm-é ə dꞌa̰ ngərəngɨ ɓá dꞌilə bɔbɨ ndi-dé nangɨ ꞌpanè: Jeju, njèndó dow-je né, ꞌoo kəmtondoo lə-ji! ");
INSERT INTO mge_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jeju oo-dé bè rəmə, idə-dé panè: Ɔwi ɔji rɔ-si njégugné-je lə Lubə. Lokɨ dꞌisɨ dꞌɔw kɨ kɔw ya ɓəy rəmə, banjɨ kɨ́ rɔ-dé-tɨ ur wukɨ adɨ dꞌaa njay. ");
INSERT INTO mge_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Lokɨ ḛ kɨ́ káre dan-dé-tɨ oo kadɨ nꞌingə lapiya bè lé, ɔsɨ waka təl ə ɔsɨ gajɨ Lubə kɨ̀ ndi-é kɨ́ boy-boy ");
INSERT INTO mge_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ree usɨ kɨ̀ takəm-é nangɨ nja Jeju-tɨ ɓá ra-é oiyo. Ḛ to dow kɨ́ dɔnangɨ Samari-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeju un ta panè: Dow-je dɔgɨ ɓá banjɨ ur rɔ-dé-tɨ adɨ dꞌaa njay ya al wa? Ngà dḛ kɨ́ jinà̰y káre lé, ꞌna̰y rá ");
INSERT INTO mge_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ɓá dow kɨ́ dan-dé-tɨ káre ya kàrè təl ree ulə riɓa dɔ Lubə-tɨ al, ɓá mba kin ya par wa? ");
INSERT INTO mge_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Go-tɨ, Jeju idə-é panè: Ḭ taá ə ɔw, kadmḛḛ lə-i ajɨ-i! ");
INSERT INTO mge_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ndɔ káre bè Parisi-je ꞌdəjɨ Jeju ꞌpanè: Kɔ̰ɓe lə Lubə à ree ndɔ kɨ́ rá-tɨ wa? Jeju ilə-dé-tɨ panè: Kɔ̰ɓe lə Lubə lé, à ree kadɨ dow-je dꞌoo kɨ̀ kəm-dé ndə̰-ndə̰ bè al. ");
INSERT INTO mge_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dow à panè: Kɔ̰ɓe lə Lubə ə́ tò nè tin əse ḛ ə́ tò yó tin al. Kdɔtalə, kɔ̰ɓe lə Lubə tò dan-si-tɨ nè ngá. ");
INSERT INTO mge_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Go-tɨ, Jeju idə njéndó né-je panè: Ndɔ-je ɔw ree nɔ̰ɔ̰ kɨ́ à ndingəi kadɨ ooi Ngon lə dow ndɔ káre-rè bè ya, ngà a kooi-é al. Dow-je dꞌa kidə-si panè: ");
INSERT INTO mge_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ḛ ə́ a̰ nè tin, ḛ ə́ a̰ yó tin, kàrè ɔwi lo-é-tɨ al rəm, ɓá a̰yi ngɔdɨ kɨ lo-é-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kdɔtalə lokɨ ndɔ ree lə Ngon lə dow asɨ lé, à ree tana̰ kɨ̀ təlndi kɨ́ ḭ ngangɨ dɔra̰-tɨ kɨ́ káre ya ndógɨ ɔw njal ngangɨ-é-tɨ kɨ́ káre kin ya bè. ");
INSERT INTO mge_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngà kete nɔ̰̀-tɨ lé, tò kadɨ-é ingə kɔ̰̀ n̰a̰ rəm, ɓá tò kadɨ dow-je kɨ́ ngɔsnè kin ꞌmbatɨ-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Né kɨ́ ndɔkɨ ra né kaglo-tɨ lə Nuwe lé, ga̰-é ya à ra-né ndɔ ree-tɨ lə Ngon lə dow lé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ndɔkɨ dow-je dꞌuso né-je, dꞌa̰y né-je, ꞌtaa-na̰-je, dꞌadɨ ngan-dé-je ꞌtaa-na̰-je sar ya ndɔ-tɨ kɨ́ Nuwe ɔw-né mḛḛ bato-tɨ. Rəmə man bəlɨm ree tɔl-né ndəgɨ dow-je lay. ");
INSERT INTO mge_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Né kɨ́ ndɔkɨ ra né kaglo-tɨ lə Lotɨ lé, ga̰-é ya à ra né ndɔ ree-tɨ lə Ngon lə dow lé tɔ. Ndɔkɨ dow-je dꞌuso né-je, dꞌa̰y né-je, ꞌndogɨ né-je, ꞌrabɨ né-je, ꞌma̰ kagɨ-je, ꞌra kəy-je. ");
INSERT INTO mge_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ngà lokɨ Lotɨ ində lo tḛḛ mḛḛ ɓebo Sɔdɔm-tɨ kɔgɨ lé, pər-je kɨ̀ ər kɨ́ tokɨ yalpər bè ya ḭ dɔra̰-tɨ ədɨ tokɨ ndi bè dɔ dow-je-tɨ tɔl-dé lay. ");
INSERT INTO mge_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bè ya tɔ, ndɔ kɨ́ Ngon lə dow à tḛḛ kɔy lé, lo à tujɨ puktu-puktu tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mḛḛ ndɔ-é-tɨ kinlé, dow kɨ́ isɨ dɔ kəy-tɨ kàrè, kadɨ risɨ nangɨ ɔw mḛḛ kəy-tɨ ɔy né-je liə al ngá, ɓá dow kɨ́ a̰ ndɔrɔ kàrè, kadɨ təl ree ɓee al ngá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Adi mḛḛ-si ole dɔ né-tɨ kɨ́ ndɔkɨ tḛḛ dɔ ne Lotɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dow kɨ́ sangɨ kdɔ kajɨ rɔ-é rəmə à tujɨ rɔ-é, ə dow kɨ́ ḛ ya ilə rɔ-é kɔgɨ ɓá à kingə gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ooi bè, ndɔ-é-tɨ kinlé, dow-je joo ꞌtò ɓi ndɔɔ mḛḛ tuwə-tɨ kɨ́ káre-rè kàrè rəmə, Lubə à kun kɨ́ káre ə à kin̰ə kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dené-je joo dꞌa̰ dꞌur né mḛḛ bɨr-tɨ kɨ́ káre-rè kàrè rəmə, Lubə à kun kɨ́ káre ə à kin̰ə kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dingəm-je joo dꞌa̰ mḛḛ ndɔr-tɨ kɨ́ káre-rè kàrè rəmə, Lubə à kun kɨ́ káre ə à kin̰ə kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Beɓa njéndó né-je ꞌdəjɨ Jeju ꞌpanè: ꞌƁaɓe, né kinlé à ra né lo kɨ́ rá-tɨ wa? Jeju idə-dé panè: Lo kɨ́ nin tò-tɨ lé, lo-é ya mal-je dꞌa kəw-na̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeju pa sə-dé ta kɨ̀ gosta tɔjɨ-dé-né kadɨ ꞌpa ta kɨ̀ Lubə taá-taá ɓɨ dꞌadɨ kɔ ra-dé go-tɨ al ya sar. ");
INSERT INTO mge_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ḛ panè: Njègangta káre bè isɨ mḛḛ ɓebo-tɨ madɨ nɔ̰ɔ̰, to dow kɨ́ ɓəl Lubə al rəm, ɓá ilə kujɨ dɔ dow-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mḛḛ ɓebo-é-tɨ kinlé, dené kɨ́ njèngɔwkoy káre isɨ-tɨ nɔ̰ɔ̰ tɔ; ə ḛ ree rɔ-é-tɨ nja natɨ-natɨ kadɨ gangta liə adɨ-é adɨ idə-é panè: I ꞌgangɨ ta kɨ́ tò dan-ji-tɨ kɨ̀ njèta lə-m kin ꞌadɨ-m. ");
INSERT INTO mge_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Njègangta lé ndigɨ al bè-bè asɨ dɔkaglo n̰a̰. Ngà go-tɨ, ḛ təl pa mḛḛ-é-tɨ panè: Ma̰ lé, mꞌɓəl Lubə al rəm, ɓá mꞌilə kujɨ dɔ dow-tɨ al rəm ya ");
INSERT INTO mge_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ngà njèngɔwkoy kin ndɔjɨ-m n̰a̰ adɨ mꞌa gangta liə kadɨ-é, kdɔ kadɨ ree ndɔjɨ-m kɨ̀ ndɔ-é ndɔ-é al. ");
INSERT INTO mge_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ꞌƁaɓe ilə dɔ-tɨ panè: Ta kɨ́ njègangta kɨ́ njururu al pa kinlé, ooi majɨ. ");
INSERT INTO mge_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ə Lubə rəmə dow-je kɨ́ ḛ mbətɨ-dé kɨ́ dꞌisɨ ꞌnɔ̰ ta-é-tɨ ndɔɔ-je kɨ̀ kada-je kinlé, ḛ à gangta lə-dé lɔw kadɨ-dé al wa? ");
INSERT INTO mge_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Adɨ mꞌidə-si, à gangta kalangɨ ya kadɨ-dé. Ngà lokɨ Ngon lə dow à ree lé, sé à kingə kadmḛḛ dɔnangɨ-tɨ nè ɓan wa? ");
INSERT INTO mge_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jeju pa ta kɨ̀ gosta idə-né ta dow-je kɨ́ na̰-je kɨ́ dḛ ya dꞌoo rɔ-dé kɨ̀ njéra né njururu nɔ̰̀ Lubə-tɨ, adɨ ꞌnədɨ ndəgɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ḛ panè: Dingəm-je joo dꞌɔw mḛḛ kəy-tɨ lə Lubə kdɔ pa ta kɨ̀ Lubə: Kɨ̀ káre to Parisi ə ḛ kɨ́ káre to njètaalambo tɔ. ");
INSERT INTO mge_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi lé, a̰ taá ɓá pa ta kɨ̀ Lubə mḛḛ-é-tɨ panè: I Lubə, mꞌra-i oiyo kdɔ ma̰ lé, mꞌtitɨ-na̰ kɨ̀ ndəgɨ dow-je kɨ́ to njéɓogɨ-je, njéra né kɨ́ njururu al-je, kɨ̀ njérakaya-je kin al, əse mꞌtitɨ-na̰ kɨ̀ njètaalambo kɨ́ a̰ kan al rəm. ");
INSERT INTO mge_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mḛḛ Dimasɨ káre lé, mꞌɔgɨ rɔ-m nékuso kɨ̀ man ka̰y nja joo-joo, ɓá mḛḛ nékingə-m-je-tɨ lay ya mꞌadɨ-i káre dan dɔgɨ-tɨ dɔgɨ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngà njètaalambo lé, ḛ ɔr rɔ-é a̰ ngərəngɨ, ə ndigɨ kitə kəm-é kɨ taá koo lo kɨ dɔra̰-tɨ al; ngá ḛ tində kàdɨ̀-é ə panè: Əy! Lubə lə-m, ꞌoo kəmtondoo lə-m, ma̰ lé mꞌto njèramajal. ");
INSERT INTO mge_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jeju təl panè: ooi majɨ; dingəm kinlé Lubə ɔr ta dɔ-é-tɨ ɓá ḛ təl kɨ mḛḛ kəy-tɨ liə, ngà Parisi lé ɓá ta nà̰y dɔ-é-tɨ. Kdɔ dow kɨ́ ɔjɨ rɔ-é lé, dꞌa kulə dɔ-é nangɨ ə ḛ kɨ́ sɔl dɔ-é ɓá dꞌa kitə dɔ-é taá tɔ. ");
INSERT INTO mge_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngan-je kɨ́ bər ya kàrè dow-je ꞌree sə-dé rɔ Jeju-tɨ kadɨ ində ji-é dɔ-dé-tɨ. Ngà lokɨ njéndó né-je liə dꞌoo né kin bè lé, ꞌkɔl sə-dé. ");
INSERT INTO mge_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Rəmə Jeju adɨ ꞌree kɨ̀ ngan-je lé rɔ-é-tɨ ə panè: «In̰əi ngan-je adɨ ꞌree rɔ-m-tɨ, ɓɨ ɔgi-dé al, kdɔtalə kɔ̰ɓe lə Lubə tò kdɔ dow-je kɨ́ ꞌtana̰ sə-dé bè. ");
INSERT INTO mge_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ooi majɨ, mꞌa kidə-si rəsɨ. Dow kɨ́ ndigɨ kɔ̰ɓe lə Lubə titɨ-na̰ kɨ́ ngon kɨ́ sḛ ndigɨ-né kin al lé à kɔw-tɨ nda̰ bè al.» ");
INSERT INTO mge_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ꞌBoy lə jipɨ-je káre dəjɨ Jeju panè: «Dow kɨ́ majɨ kɨ́ njèndó dow-je né, ri ɓá mꞌa ra ɓá mꞌa kisɨ-né kəm sartagangɨ wa?» ");
INSERT INTO mge_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Beɓa Jeju ilə-é-tɨ panè: «Kdɔ ri ɓá i ɓa-m dow kɨ́ majɨ wa? Dow kɨ́ majɨ goto, Lubə ya kɨ̀ kár-é ə́ majɨ. ");
INSERT INTO mge_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ꞌGə ndukun-je lə Lubə gɔw: “ꞌA ra kaya al, ꞌa tɔl dow al, ꞌa ɓogɨ al, ꞌa tətɨ ta kɨ́ ndángɨ al, ꞌa tətɨ kagɨ bɔbɨ-i kɨ̀ kɔ̰-i.”» ");
INSERT INTO mge_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dingəm lé ilə-é-tɨ panè: «Basa-m-tɨ nṵ ya mꞌtəl rɔ-m go né-je-tɨ kinlé lay.» ");
INSERT INTO mge_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Lokɨ Jeju oo ta-je liə bè lé, idə-é panè: «Né káre nal-i ɓəy: “ꞌNdogɨ nékingə-i lay ə ꞌləbɨ là-é njéndoo-je, rəmə ndɔ-é ꞌa kingə n̰a̰ dɔra̰-tɨ; ə ꞌree un go-m.”» ");
INSERT INTO mge_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ngà lokɨ ḛ oo ta-je kin bè lé rɔ-é atɨ-é kana̰na̰, kdɔ ḛ to njènékingə kɨ́ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lokɨ Jeju oo kɨ́ rɔ-é atɨ-é lé, ḛ idə dow-je panè: «Kadɨ njénékingə-je dꞌɔw kɔ̰ɓe-tɨ lə Lubə lé, to né kɨ́ nga̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kadɨ jambal dəə ɓe libri-tɨ lé to né kɨ́ nga̰ n̰a̰ ya, ngà kadɨ njènékingə ɔw kɔ̰ɓe-tɨ lə Lubə lé to né kɨ́ nga̰ itə-é ɓəy.» ");
INSERT INTO mge_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngà lokɨ dow-je dꞌoo ta kɨ́ ḛ pa kinlé bè rəmə ꞌpanè: «Tò bè ngà ná̰ ɓá à kajɨ wa?» ");
INSERT INTO mge_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jeju ilə-dé-tɨ panè: «Né kɨ́ dum dɔ dow-je kinlé, à dum Lubə al.» ");
INSERT INTO mge_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Rəmə Piyər un ta dəjɨ-é panè: «Yən, jḛ kinlé, jꞌtusɨ né-je lə-ji jꞌin̰ə ɓá jꞌun go-i tin.» ");
INSERT INTO mge_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Beɓa Jeju idə-é panè: «Ooi majɨ, mꞌa kidə-si rəsɨ. Ná̰-ná̰ kɨ́ in̰ə kəy liə, əse ne-é əse ngankɔ̰-é-je, əse njékojɨ-é-je əse ngan-é-je kdɔtalə kɔ̰ɓe lə Lubə lé, ");
INSERT INTO mge_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","à kingə né-é dɔ-tɨ n̰a̰ dɔkaglo-tɨ kɨ́ ngɔsnè kin rəm, ɓá à kiskəm sartagangɨ dɔkaglo-tɨ kɨ́ à ree lé rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeju ɓa njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo rɔ-é-tɨ ɓá idə-dé panè: «Yən, jꞌisɨ jꞌɔwi kɨ ɓebo Jorijalḛm-tɨ ə ta-je lay kɨ́ njépata-je kɨ́ ta Lubə-tɨ ꞌndàngɨ sɔbɨ dɔ Ngon lə dow lé, né-é à ra né. ");
INSERT INTO mge_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kdɔtalə dꞌa kilə-é ji dow-je-tɨ kɨ́ ꞌto jipɨ-je al, kadɨ dꞌa sɔkɨ-é, dꞌa tajɨ-é, dꞌa tubə yoro kəm-é-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","dꞌa tində-é kɨ̀ ndəy marɔw ɓəy ɓá dꞌa tɔl-é. Ə ndɔ kɨ́ njèkungɨ-tɨ mutə rəmə, à tɔsɨ ndəl kində lo tḛḛ.» ");
INSERT INTO mge_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngà né káre ya kàrè njéndó né-je ꞌgə mḛḛ ta-tɨ kinlé al; mḛḛ ta-je kinlé tokɨ ɓɔyɔ sə-dé dɔ-é bè ya, adɨ ꞌgə né kɨ́ Jeju pa ta dɔ-tɨ lé al. ");
INSERT INTO mge_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lokɨ Jeju ində dɔ ɓebo Jeriko ngɔsi lé, njèkəmtɔ káre isɨ ngangɨ rəbɨ-tɨ nɔ̰ɔ̰, isɨ kɔy-né. ");
INSERT INTO mge_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Rəmə lokɨ ḛ oo ndi kosɨ dow-je kɨ́ dꞌisɨ dəə taá lé, ḛ dəjɨ-dé né kɨ́ ra né. ");
INSERT INTO mge_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngà ɓá dḛ dꞌidə-é ꞌpanè to Jeju kɨ́ Najarɛtɨ-tɨ ɓá dəə. ");
INSERT INTO mge_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Beɓa ḛ ilə bɔbɨ ndi-é nangɨ nɔ̰ panè: «Jeju kɨ́ ngonka Dabidɨ, ꞌoo kəmtondoo lə-m.» ");
INSERT INTO mge_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dḛ kɨ́ dꞌɔw ꞌnjiyə nɔ̰̀ Jeju-tɨ kete lé, ꞌndángɨ-é ə dꞌidə-é kadɨ utɨ ta-é, ngà ḛ ilə bɔbɨ ndi-é nangɨ nɔ̰ kɨ̀ tɔ́gɨ-é itə kɨ́ kete lé ya ɓəy panè: «Ngonka Dabidɨ, ꞌoo kəmtondoo lə-m ɓoo.» ");
INSERT INTO mge_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Rəmə Jeju təl a̰ nangɨ ə un ndu kadɨ ꞌree siə rɔ-nꞌḛ̀-tɨ, ə lokɨ njèkəmtɔ ree rəmə, Jeju dəjɨ-é panè: ");
INSERT INTO mge_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ri ɓá i ꞌndigɨ kadɨ mꞌra mꞌadɨ-i wa? Ḛ ilə-é-tɨ panè: «ꞌƁaɓe, kəm ya ꞌadɨ təl oo lo.» ");
INSERT INTO mge_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Beɓa Jeju idə-é panè: «ꞌOo lo, kadmḛḛ lə-i ajɨ-i.» ");
INSERT INTO mge_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tajinatɨ nè ya ḛ oo lo adɨ ḛ un go Jeju ə ɔsɨ gajɨ Lubə taá-taá. Kosɨ dow-je lay kɨ́ dꞌoo né kinlé, ꞌtɔ́y Lubə tɔ. ");
INSERT INTO mge_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lokɨ Jeju ɔw mḛḛ ɓebo Jeriko-tɨ ə isɨ ində dan ɓe gangɨ, ");
INSERT INTO mge_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","rəmə, oo dingəm kɨ́ njènékingə kɨ́ ri-é lə Jase, to njèkun dɔ njétaalambo-je. ");
INSERT INTO mge_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ḛ sangɨ kadɨ nꞌoo se ná̰ ɓá to Jeju lé wa? Ngà kosɨ dow-je ra adɨ ḛ asɨ kadɨ oo-é al, kdɔtalə ḛ to dow kɨ́ gɔjɨ. ");
INSERT INTO mge_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Beɓa ḛ a̰y ngɔdɨ kete ɔw al dɔ kote-tɨ kdɔ kadɨ nꞌoo Jeju, kdɔtalə ḛ à dəə lo-é-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lokɨ Jeju ɔw tḛḛ lo-é-tɨ kinlé, un kəm-é kɨ taá idə-é panè: Jase, ꞌrisɨ nangɨ kalangɨ, kdɔtalə tò kadɨ mꞌto ɓe lə-i ɓone. ");
INSERT INTO mge_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Beɓa Jase ur nangɨ lɔw-lɔw ree uwə-é kɨ rɔ-é-tɨ kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lokɨ dow-je dꞌoo né kin bè lé, dḛ lay ya ꞌtún ta ꞌpanè: Ooi, Jeju lé, ɔw tò ɓe lə dow kɨ́ njèramajal. ");
INSERT INTO mge_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngà Jase ḭ a̰ taá nɔ̰̀ ꞌƁaɓe-tɨ idə-é panè: ꞌƁaɓe, ꞌoo bè, nékingə-m lé, mꞌa kay dana̰ lo joo ə mꞌa kadɨ kɨ́ gin káre njéndoo-je, ə kinə mꞌtaa né ji dow-tɨ kɨ̀ ndángɨ kare rəmə, mꞌa təl kadɨ-é né-é kinlé sɔ ngá. ");
INSERT INTO mge_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Beɓa Jeju idə-é panè: Kajɨ ree mḛḛ kəy-tɨ kin ɓone, kdɔtalə dow kinlé, to ngon kà Abrakam tɔ. ");
INSERT INTO mge_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kdɔtalə Ngon lə dow lé ree kadɨ nꞌsangɨ nja dow-je kɨ́ ꞌna̰y kdɔ kadɨ nꞌajɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lokɨ dow-je dꞌa̰ dꞌoo ta-je kin bè lé, Jeju ilə gosta káre dɔ-tɨ. Kdɔtalə ḛ a̰ ngɔsi kɨ̀ ɓebo Jorijalḛm, adɨ dow-je ꞌgɨr ꞌpanè kɔ̰ɓe lə Lubə lé, à ree tajinatɨ nè ya ngá. ");
INSERT INTO mge_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Adɨ Jeju panè: Dow káre bè, to dow kɨ́ gin ngar-tɨ, isɨ ɔw kɨ́ mba-tɨ dɔnangɨ-tɨ kɨ́ sa̰y nṵ, kdɔ kadɨ dꞌɔw dꞌulə jɔgɨ ngar dɔ-é-tɨ, ɓá à təl ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ḛ ɓa ngannjékullə-je liə dɔgɨ dan madɨ-dé-je-tɨ ə adɨ ná̰-ná̰ dan-dé-tɨ mbal là káre-káre ɓá idə-dé panè: Ɔwi, ꞌtəli-né ji-si sar kadɨ mꞌtəl mꞌree-né. ");
INSERT INTO mge_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngà dow-je kɨ́ mḛḛ ɓe-tɨ liə dꞌɔsɨ-é kɨ̀ ta adɨ dꞌulə dow-je kɨ́ ꞌto takəm-dé kadɨ dꞌɔw dꞌidə-dé ꞌpanè: Jḛ jꞌndigɨ kadɨ dow kin ɔ̰̀-ji al. ");
INSERT INTO mge_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bè ya kàrè dꞌulə jɔgɨ ngar dɔ-é-tɨ. Lokɨ ḛ təl ree lé, ḛ adɨ ꞌɓa ngannjékullə-je kɨ́ adɨ-dé là lé kadɨ ꞌree rɔ-é-tɨ, kdɔ kadɨ nꞌoo se dow káre ingə man-é dɔ-tɨ kandangɨ-kandangɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beɓa ngonnjèkullə kɨ́ dɔsa̰y ree panè: ꞌƁa-m, mbal là lə-i kɨ́ adɨ-m lé, mꞌtəl-né ji-m adɨ mꞌingə mbal là dɔgɨ. ");
INSERT INTO mge_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ꞌƁa-é panè: Oiyo! ꞌTo ngonnjèkullə kɨ́ majɨ! Mꞌadɨ-i ɓebo-je dɔgɨ kadɨ ɔw kɨ̀ tɔ́gɨ dɔ-tɨ, kdɔ ꞌto njèra né kɨ́ tɔgrɔ-tɨ mḛḛ né-tɨ kɨ́ ndḛ bè. ");
INSERT INTO mge_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ngonnjèkullə kɨ́ njèkungɨ-tɨ joo ree panè: «ꞌƁa-m, mbal là lə-i kɨ́ ꞌadɨ-m lé, mꞌtəl-né ji-m adɨ mꞌingə mbal là mḭ.» ");
INSERT INTO mge_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Beɓa ꞌɓa-é idə-é panè: «I kàrè, mꞌadɨ-i ɓebo-je mḭ kadɨ ɔw kɨ̀ tɔ́gɨ dɔ-tɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ngonnjèkullə kɨ́ rangɨ ree panè: «ꞌƁa-m, mbal là lə-i lé ya ə́ mꞌdɔɔ takubɨ-tɨ tin.» ");
INSERT INTO mge_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ma̰ mꞌɓəl-i, kdɔ i lé ꞌto dow kɨ́ ꞌnga̰ n̰a̰; adɨ né kɨ́ to i ɓá ungɨ al kàrè, i ɔy rəm, ko kɨ́ to i ɓá ꞌdubɨ al kàrè i ijə rəm. ");
INSERT INTO mge_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Beɓa ꞌɓa-é idə-é panè: «I ngonnjèkullə kɨ́ majɨ al kan! Ta kɨ́ ta-i-tɨ ya mꞌngangɨ-né ta dɔ-i-tɨ. I ꞌgə kɨ́ mꞌto dow kɨ́ mꞌnga̰ n̰a̰, adɨ né kɨ́ to ma̰ ɓá mꞌungɨ al kàrè, mꞌɔy rəm, ko kɨ́ to ma̰ ɓá mꞌdubɨ al kàrè, mꞌijə rəm, ");
INSERT INTO mge_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ngà kdɔ ri ɓá ꞌɔw ꞌilə mbal là lə-m kəy ngəm là-tɨ kdɔ kadɨ mꞌtəl mꞌree ə mꞌɔr kɨ̀ man-é dɔ-tɨ al wa?» ");
INSERT INTO mge_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Go-tɨ, idə dow-je kɨ́ dꞌa̰ lo-é-tɨ nɔ̰ɔ̰ panè: «Ɔti ꞌtaai mbal là kɨ́ ji-é-tɨ kin adi ḛ kɨ́ ɔw kɨ̀ mbal là dɔgɨ kinlé dɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dḛ dꞌilə-é-tɨ ꞌpanè: «ꞌƁaɓe, ḛ ɔw kɨ̀ mbal là dɔgɨ ngá.» ");
INSERT INTO mge_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Rəmə ḛ təl panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ né tò ji-é-tɨ ɓá dꞌa kadɨ-é kɨ́ rangɨ dɔ-tɨ, ngà dow kɨ́ né goto ji-é-tɨ lé, ḛ kɨ́ ji-é-tɨ lé ya kàrè dꞌa taa.» ");
INSERT INTO mge_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Go-tɨ, ḛ panè: «Njéba-je lə-m kɨ́ ꞌndigɨ kadɨ mꞌɔ̰-dé al lé ꞌreei sə-dé ə ꞌtijəi mindɨ-dé takəm-m-tɨ nè ya.» ");
INSERT INTO mge_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lokɨ Jeju pa ta-je kin bè lé, ɔtɨ usɨ kete nɔ̰̀ njéndó né-je-tɨ liə ə dꞌɔw kɨ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lokɨ dꞌɔw ꞌtḛḛ ngɔsi kɨ̀ ɓe kɨ́ Betpaje, kɨ̀ ɓe kɨ́ Betani kɨ́ tò kàdɨ̀ mbal-tɨ kɨ́ ꞌɓa-é mbal ka̰ kagɨ olibiye-je lé, Jeju ulə njéndó né-je liə joo ");
INSERT INTO mge_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","panè: «Ɔwi mḛḛ ngonɓe-tɨ kɨ́ nɔ̰̀-si-tɨ kin. Lokɨ ɔwi ꞌtḛḛi-tɨ lé, a kingəi ngon koro kɨ́ dow al-é al ɓəy kɨ́ ꞌtɔ́-é nangɨ, ə ꞌtuti-é ꞌreei siə adi-mi.» ");
INSERT INTO mge_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kinə dow dəjɨ-si panè se ꞌtuti-é kdɔ ri wa rəmə, idəi-é ꞌpai-nè: «ꞌƁaɓe ɓá ge ngon koro lé.» ");
INSERT INTO mge_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dḛ kɨ́ Jeju ulə-dé lé, dꞌɔtɨ dꞌɔw rəmə, dꞌoo né-je titɨ kɨ́ Jeju idə-dé-né lé ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lokɨ ꞌtutɨ ngon koro lé rəmə, ꞌɓa-é-je ꞌdəjɨ-dé ꞌpanè: «ꞌTuti ngon koro lé kdɔ ri wa?» ");
INSERT INTO mge_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dḛ dꞌilə-dé-tɨ ꞌpanè: «ꞌƁaɓe ɓá ɔw ndoo ngon koro lé.» ");
INSERT INTO mge_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Beɓa dḛ ꞌree siə dꞌadɨ Jeju, ə ꞌlabɨ kubɨ-je lə-dé gidɨ-é-tɨ ɓá dꞌadɨ Jeju al isɨ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lokɨ Jeju ɔtɨ isɨ ɔw lé, dow-je ꞌlabɨ kubɨ-je lə-dé dɔ rəbɨ-tɨ nɔ̰̀-é-tɨ taá-taá. ");
INSERT INTO mge_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lokɨ ḛ ree tḛḛ ngɔsi kɨ̀ ɓebo Jorijalḛm, rəbɨ-tɨ kɨ́ ḭ dɔ mbal ka̰ kagɨ Olibiye-je-tɨ ɔw kɨ mḛḛ ɓebo-tɨ kinlé, kosɨ njéndó né-je lay ya rɔ-dé nəl-dé adɨ dꞌɔsɨ gajɨ Lubə kɨ̀ ndi-dé kɨ́ boy-boy kdɔtalə nékɔjɨ-je lay kɨ́ dꞌoo lé. ");
INSERT INTO mge_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dḛ ꞌpanè: «Kadɨ Lubə tɔr ndi-é dɔ ngar-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe, lapiya tò mḛḛ dɔra̰-tɨ, riɓa tò mḛḛ lo-je-tɨ kɨ́ taá nṵ.» ");
INSERT INTO mge_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Rəmə, Parisi-je kɨ́ dan-tɨ-je kɨ́ dꞌa̰ dan kosɨ dow-je-tɨ nɔ̰ɔ̰ lé dꞌidə Jeju ꞌpanè: Njèndó dow-je né, i ꞌndángɨ njéndó né-je lə-i lé ɓane. ");
INSERT INTO mge_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngà Jeju ilə-dé-tɨ panè: Adɨ mꞌidə-si rəsɨ. Lé dḛ dꞌutɨ ta-dé kàrè, ər-je ya dꞌa tur kəə! ");
INSERT INTO mge_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lokɨ Jeju ɔw tḛḛ ngɔsi kɨ̀ ɓebo Jorijalḛm lé, un kəm-é oo-né ɓebo lé rəmə, nɔ̰ kdɔ ta liə panè: ");
INSERT INTO mge_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Əy! Ɓebo Jorijalḛm, tokɨ lé dow-je lə-i ꞌgə né kɨ́ dꞌa ra kadɨ lapiya tò rəmə lé! Ngà kɨ́ ngɔsnè-tɨ kinlé, to kɨ́ ɓɔyɔ sə-dé dɔ-é. ");
INSERT INTO mge_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ndɔ-je madɨ ɔw ree nɔ̰ɔ̰ lé, njéba-je lə-si dꞌa kɔr gali dɔ-si-tɨ, dꞌa kilə-na̰ gəə dɔ-si sipɨ kdɔ kutɨ-si lo-tɨ ndukɨ-ndukɨ, ");
INSERT INTO mge_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","dꞌa tujɨ-si puktu-puktu, kɨ̀ ɓebo lə-si burə, ər káre ya kàrè dꞌa kin̰ə kadɨ tò dɔ madɨ-é-tɨ mḛḛ ɓebo-tɨ lə-si al, kdɔtalə dɔkaglo kɨ́ Lubə ree-né rɔ-si-tɨ kdɔ ra-né sə-si lé, sə̰i ꞌgəi al. ");
INSERT INTO mge_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Go-tɨ, Jeju ɔw takəy-tɨ lə Lubə ə tubə njéragatɨ-je. ");
INSERT INTO mge_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ḛ idə-dé panè: ꞌNdàngɨ ꞌpanè: «Kəy lə-m lé, à to kəy pa ta kɨ̀ Lubə. Ngà sə̰i adi təl to kəy kisɨ njéɓogɨ-je.» ");
INSERT INTO mge_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndɔ-je lay ya Jeju ndó né dow-je takəy-tɨ lə Lubə. Rəmə njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je, kɨ̀ ꞌboy-je lə jipɨ-je ꞌsangɨ kəm rəbɨ kadɨ ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ngà dḛ ꞌgə kəm rəbɨ kɨ́ dꞌa tɔl-é-né lé al, kdɔtalə dow-je lay ya dꞌoo ta-je liə kɨ̀ rɔnəl n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ndɔ káre bè, lokɨ Jeju isɨ ndó né dow-je takəy-tɨ lə Lubə rəm, ilə mbḛ Poyta kɨ́ Majɨ adɨ-dé rəm lé, njékun dɔ njégugné-je, kɨ̀ njéndó dow-je ndukun-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌree ꞌtḛḛ kɔy rɔ-é-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ə ꞌdəjɨ-é ꞌpanè: «I ya ꞌidə-ji adɨ jꞌoo. To ná̰ ɓá adɨ-i tarəbɨ ɓá ꞌra-né né-je kinlé wa? Ná̰ ɓá adɨ-i tɔ́gɨ ɓá ꞌra-né wa?» ");
INSERT INTO mge_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Beɓa Jeju ilə-dé-tɨ panè: «Ma̰ kàrè mꞌa dəjɨ-si ta káre tɔ? ");
INSERT INTO mge_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Idəi-mi, to ná̰ ɓá ulə Ja̰ adɨ ra dow-je batḛm wa? To Lubə ɓá ulə-é əse to dow-je wa?» ");
INSERT INTO mge_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ngà dḛ ꞌtəl ꞌpa-na̰ ta dan-dé-tɨ n̰ɔ̰m-n̰ɔ̰m ꞌpanè: Kinə jꞌpainè to Lubə ɓá ulə-é lé, ḛ à təl dəjɨ-ji panè: «Ngà kdɔ ri ɓá adi-é mḛḛ-si al wa? ");
INSERT INTO mge_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ə kinə, jꞌidəi-é jꞌpainè to dow-je ɓá dꞌulə-é kàrè, kosɨ dow-je lay ya dꞌa tilə-ji kɨ̀ ər tɔl-ji, kdɔ dḛ dꞌoo Ja̰ kɨ njèpata kɨ́ ta Lubə-tɨ.» ");
INSERT INTO mge_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Beɓa dḛ ꞌtəl dꞌilə-é-tɨ ꞌpanè: «Jḛ jꞌgə njèkulə Ja̰ kadɨ ra dow-je batḛm lé al.» ");
INSERT INTO mge_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeju təl idə-dé panè: «Majɨ, ma̰ ya kàrè nda̰ bè ɓá mꞌa kidə-si dow kɨ́ adɨ-m tɔ́gɨ mꞌra-né né-je kinlé al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Go-tɨ, Jeju idə ta kosɨ dow-je kɨ̀ gosta panè: «Dow káre bè uwə nduu, ə adɨ njérakullə-é-je dꞌuwə siə dɔ-é, ɓá ɔtɨ ɔw mba kɨ́ tó-é uu. ");
INSERT INTO mge_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lokɨ na̰y kijə kandɨ nduu asɨ rəmə, ḛ ulə ngonnjèkullə liə káre rɔ njérakullə ndɔr nduu-je-tɨ lé kadɨ dꞌadɨ-é kɨ́ liə ree-né adɨ-é. Ngà dḛ ꞌtində ngonnjèkullə lé mbukɨ-mbukɨ ə ꞌtubə-é dꞌadɨ təl kɨ̀ ji-é kare. ");
INSERT INTO mge_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Njèndɔr nduu lé ulə ngonnjèkullə kɨ́ rangɨ ɓəy rəmə, njérakullə ndɔr nduu-je lé, ꞌtində-é mbukɨ-mbukɨ, ɓá ꞌtajɨ-é ə ꞌtubə-é dꞌadɨ təl kɨ̀ ji-é kare ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ḛ ulə ngonnjèkullə kɨ́ njèkungɨ-tɨ mutə ɓəy; ḛ rəmə dꞌadɨ-é dò, ɓá ꞌtubə-é dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Beɓa ꞌɓa njèndɔr nduu lé panè: “Ri ɓá mꞌa ra wa? Mꞌa kulə ngon-m kɨ́ mꞌində-é dan kəm-m-tɨ kin ya, dɔmajɨ ə dꞌa ɓəl-é ngá.” ");
INSERT INTO mge_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngà lokɨ njérakullə ndɔr nduu-je dꞌoo ngon-é lé isɨ ree rəmə, dꞌidə-na̰ ta dan-dé-tɨ ꞌpanè: “Ooi, ngon-é kɨ́ ndɔ-é à to njènéndubə lé ya ə́ ɔw ree ɔngɨ; adɨ jꞌtɔli-é kadɨ néndubə liə təl to kɨ́ lə-ji.” ");
INSERT INTO mge_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Beɓa dḛ dꞌuwə-é ꞌtḛḛ siə rangɨ mḛḛ ndɔr-tɨ lé, ə tɔl-é. Beɓa Jeju panè: Ri ɓá ꞌɓa njèndɔr nduu-lé à ra sə-dé wa? ");
INSERT INTO mge_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ḛ à ree ə à kadɨ ꞌtɔl njérakullə ndɔr nduu-je kinlé ə à təl kɨ̀ ndɔr nduu lé kadɨ dow-je kɨ́ rangɨ.» Lokɨ kosɨ dow-je dꞌoo ta-je kin bè lé, ꞌpanè: «To né kɨ́ à ra né bè nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ngà Jeju oo-dé gə́rə́rə́ ɓá panè: Ta kɨ́ ꞌndàngɨ ꞌpanè: Ər kɨ́ njékində kəy-je dꞌilə pɨrɨngɨ kɔgɨ, ɓá təl to ər kɨ́ majɨ kɨ́ sul kəy-tɨ kinlé kɔr mḛḛ-é to ri wa? ");
INSERT INTO mge_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Dow kɨ́ rá-rá kɨ́ tḛḛ usɨ dɔ ər-é-tɨ kinlé, rɔ-é à tə́tɨ ɗɛkɨ-ɗɛkɨ rəm, ɓá dow kɨ́ ər kinlé usɨ dɔ-é-tɨ kàrè à lər-é lər-lər rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je ꞌsangɨ kadɨ dꞌuwə Jeju dɔkàdɨ̀-é-tɨ kinlé ya, kdɔ dḛ ꞌgə kɨ́ ḛ pa gosta kinlé sɔbɨ-né dɔ-dé. Ngà dḛ ꞌɓəl kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Beɓa dḛ dꞌində kəm-dé go Jeju-tɨ ə dꞌulə njétən lo-je kɨ́ ꞌra rɔ-dé kɨ dow-je kɨ́ ta lə-dé goto bè, kadɨ dꞌingə ta madɨ ta Jeju-tɨ kadɨ dꞌɔw-né siə nɔ̰̀ njègangta-tɨ, njèkɔw kɨ̀ tɔ́gɨ dɔ ɓe-tɨ, adɨ to gubərnər. ");
INSERT INTO mge_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dḛ ꞌdəjɨ-é ta kin ꞌpanè: «Njèndó dow-je né, jꞌgə kɨ́ i lé ꞌto njèpata kɨ́ tɔgrɔ-tɨ rəm, ꞌisɨ ꞌndó dow-je né kɨ́ njururu rəm, ɓá i ꞌɔr kəm dow al rəm; ngà i ꞌisɨ ꞌɔjɨ dow-je rəbɨ lə Lubə kɔjɨ kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ə́n ə́ idə-ji ta kin adɨ jꞌoo: “Koo-é-tɨ lə-i i ya bè lé, to tó-é kadɨ jꞌugə lambo lə ngar Sejar əse to tó-é al wa?”» ");
INSERT INTO mge_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngà Jeju gə tagɨr kɨ́ majɨ al kɨ́ mḛḛ-dé-tɨ adɨ idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ɔji-mi ka̰a̰ là káre adi-mi mꞌoo: “To dɔ ná̰ kɨ̀ ri ná̰ ɓá tò-tɨ wa?”» Rəmə dḛ dꞌilə-é-tɨ ꞌpanè: «To dɔ Sejar kɨ̀ ri-é.» ");
INSERT INTO mge_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ngá ɓá ḛ təl idə-dé panè: «Né lə Sejar rəmə adi Sejar, ngà né lə Lubə rəmə adi Lubə tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ta-je kɨ́ ḛ pa adɨ dow-je lé, dḛ dꞌasɨ kingə ta madɨ dan-tɨ kdɔ kilə-né ta dɔ-é-tɨ al. Ta kɨ́ Jeju ilə-dé-tɨ lé, ɔr ndil-dé adɨ dꞌoo ta kɨ́ dꞌa pa al. ");
INSERT INTO mge_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi-je kɨ́ ꞌto dow-je kɨ́ ꞌnajɨ panè dow-je kɨ́ dꞌoy dꞌa tɔsɨ ndəl kində lo tḛḛ al lé, dḛ kɨ́ madɨ ꞌree rɔ Jeju-tɨ ꞌdəjɨ-é ta ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Njéndó dow-je né, ta kɨ́ Moiyijɨ idə-ji ə́n: Kinə dow ta dené ɓá ojɨ siə ngon al ɓəy ya ə oy rəmə, kadɨ ngonkɔ̰-é ta dené ndubə lé, ində-né ko njègoto-je lé. ");
INSERT INTO mge_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ngà kinə ngankɔ̰-na̰-je siri je bè, ɓá ḛ kɨ́ dɔsa̰y taa dené ə́ ojɨ siə ngon al ɓəy ya ə oy. ");
INSERT INTO mge_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ḛ kɨ́ njèkungɨ-tɨ joo kɨ́ taa dené ndubə lé kàrè bè ya rəm, ɓá njèkungɨ-tɨ mutə kàrè bè ya rəm, ");
INSERT INTO mge_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ə to bè-bè sar ngankɔ̰-na̰-je kɨ́ siri lé dꞌoy-né nal kojɨ ngon kɨ́ dené ndubə lé. ");
INSERT INTO mge_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bè ya dené-é kàrè oy-né go-dé-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndɔ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ lé, dené kinlé, à to ne ná̰ dan-dé-tɨ kɨ́ siri kinlé wa? Kdɔtalə dḛ ꞌtaa-é ya siri lay. ");
INSERT INTO mge_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Beɓa Jeju ilə-dé-tɨ panè: Dɔkaglo-tɨ kɨ́ ɓone kin ɓá dingəm-je kɨ̀ dené lé ꞌtaa-na̰. ");
INSERT INTO mge_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ngà dḛ kɨ́ Lubə oo-dé adɨ dꞌasɨ tɔsɨ ndəl kində lo tḛḛ, kdɔ kisɨ dɔkaglo-tɨ kɨ́ à ree kinlé, dꞌa taa-na̰ al. ");
INSERT INTO mge_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dḛ dꞌa koy al ya sartagangɨ, kdɔtalə dꞌa tana̰ kɨ̀ malayka-je bè, dḛ dꞌa to ngan lə Lubə, kdɔ tɔsɨ kɨ́ dꞌa tɔsɨ ndəl kində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kɨ́ sɔbɨ dɔ dow-je kɨ́ dꞌoy kɨ́ dꞌa tɔsɨ ndəl kində lo tḛḛ lé, lokɨ Lubə pa ta kɨ̀ Moiyijɨ dan pər-tɨ kɨ́ ɔ̰̀ dan kam-tɨ lé Moiyijɨ ɓa ꞌƁaɓe, Lubə lə Abrakam, Lubə lə Isakɨ kɨ̀ Lubə lə Jakobɨ. ");
INSERT INTO mge_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Adɨ Lubə lé, to Lubə lə dow-je kɨ́ dꞌoy al, ngà to Lubə lə dow-je kɨ́ dꞌisɨ kəm. Kdɔtalə Moiyijɨ lé, gə kɨ́ dḛ lay ya dꞌisɨ kəm. ");
INSERT INTO mge_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Beɓa dow-je kɨ́ ná̰-je dan njéndó dow-je ndukun-je-tɨ dꞌun ta ꞌpanè: «Njèndó dow-je né, i ꞌpa ta majɨ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Rəmə gangɨ-é-tɨ kinlé ɓo kadɨ ꞌdəjɨ-é ta-je kɨ́ rangɨ ya kàrè ra-dé al ngà. ");
INSERT INTO mge_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Beɓa Jeju idə-dé panè: Kdɔ ri ɓá ꞌpanè Kristɨ to ngonka Dabidɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kdɔ Dabidɨ ya kɨ̀ dɔ-é pa mḛḛ Pa-je-tɨ panè: ꞌƁaɓe idə ꞌƁaɓe lə-m panè: ꞌIsɨ dɔ jikɔl-m-tɨ nè ya, ");
INSERT INTO mge_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Sar kadɨ mꞌadɨ njéba-je ꞌtəl-né lo kungɨ nja-i. ");
INSERT INTO mge_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kinə Dabidɨ ɓa Kristɨ ꞌƁaɓe lé, Kristɨ à to ngonka Dabidɨ ban ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Lokɨ dow-je yəl mbi-dé dꞌa̰ dꞌoo-né ta-je liə lé, ḛ idə njéndó né-je liə panè: ");
INSERT INTO mge_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ooi go rɔ-si majɨ kɨ rɔ njéndó dow-je ndukun-je-tɨ. Kdɔ dḛ lé nəl-dé kɔr gama̰ kɨ̀ kubɨ-je kɨ́ ngal puu-puu rəm, ꞌndigɨ kadɨ dow-je ꞌra-dé lapiya kunta-na̰ lokosɨ-je-tɨ rəm, ꞌndigɨ lokisɨ-je kɨ́ kete mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je rəm, ɓá ꞌsangɨ lokisɨ-je kɨ́ nɔ̰̀ dow-je-tɨ lo nékuso ra na̰y-je-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dḛ ꞌkəə né-je kɨ́ mḛḛ kəy-je-tɨ lə njéngɔwkoy-je kər-kər ə ꞌpa ta kɨ̀ Lubə dꞌadɨ ngal n̰a̰-n̰a̰ kadɨ dow-je dꞌoo-dé-né. Ta kɨ́ gangɨ kɨ́ nga̰ n̰a̰ ya à ree dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Lokɨ Jeju un kəm-é oo lo rəmə, oo njénékingə-je kɨ́ dꞌɔw dꞌilə kadkare-je lə-dé mḛḛ ku kilə kadkare-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ə oo njèngɔwkoy káre kɨ́ to dangɨ-tɨ ɔw ungɨ silə joo mḛḛ ku-tɨ lé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Beɓa Jeju panè: «Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ njèngɔwkoy kɨ́ to njèndoo kanlé, adɨ né itə ndəgɨ dow-je lay kinlé. ");
INSERT INTO mge_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kdɔ dḛ kɨ́ lay kinlé, to man dɔ né-je lə-dé kɨ́ tò mburukɨ-mburukɨ ɓá ꞌree-né dꞌungɨ mḛḛ ku kilə kadkare-tɨ. Ngà dené kanlé, né liə goto, adɨ to sɔ̰y né kɨ́ à kuso kdɔ kisɨ-né ya ḛ un latɨ adɨ tin.» ");
INSERT INTO mge_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dow-je kɨ́ dan-tɨ-je ꞌpa ta lə kəy lə Lubə kɨ́ ꞌra kɨ̀ ər-je kɨ́ majɨ-majɨ adɨ ndole, kɨ̀ né-je kɨ́ dow-je dꞌadɨ kadkare-tɨ kin, ɓá Jeju panè: ");
INSERT INTO mge_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ndɔ-je madɨ ɔw ree nɔ̰ɔ̰, ə ndɔ-é-je-tɨ kinlé, né-je kɨ́ ooi kɨ̀ kəm-si kinlé, dꞌa tɔsɨ tilə lay; ər káre ya kàrè dꞌa kin̰ə dɔ madɨ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Beɓa dḛ ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, né kinlé à ra né ndɔ kɨ́ rá-tɨ ya wa? Ə ri ɓá à tɔjɨ kadɨ jꞌgə kɨ́ né-je kinlé à ra né wa? ");
INSERT INTO mge_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jeju idə-dé panè: «Indəi kəmkaa dɔ rɔ-si-tɨ, adi dow-je dꞌədɨ-si al. Kdɔ dow-je n̰a̰ ya dꞌa kun ri-m kində dɔ-dé-tɨ kdɔ pa panè: “Dḛ ya ꞌto Kristɨ”, rəmə dɔkaglo nà̰y ngɔsi ngá ə́n. Uni go-dé al. ");
INSERT INTO mge_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lokɨ a kooi poy rɔ-je, kɨ̀ kɔsɨ-na̰ ta-je rəmə, adi mḛḛ-si gangɨ man al, kdɔtalə né-je kin ya à ra né kete mɔkɨ. Ngà lokɨ né-je kin ra né ya kàrè, tajinatɨ nè bè ya à to dɔbəy ndɔ lé al ya ɓəy.» ");
INSERT INTO mge_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jeju təl pa go-tɨ panè: «Gin dow-je madɨ dꞌa kḭ rɔ kɨ̀ gin dow-je madɨ, kɔ̰ɓe káre à kḭ rɔ kɨ̀ kɔ̰ɓe kɨ́ káre. ");
INSERT INTO mge_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dɔnangɨ à yəkɨ yəkɨ kɨ́ tò ɓəl n̰a̰ rəm, ɓobo-je, kɨ̀ mɔ̰ykosɨ-je à kusɨ kɨ̀ lo-lo, ɓá né-je kɨ́ tò ɓəl-ɓəl ya à ra né rəm, ɓá nékɔjɨ-je kɨ́ tò ɓəl n̰a̰-n̰a̰ à tḛḛ dɔra̰-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ngà kete ɓəy ɓá kadɨ né-je kin ra né lé, dꞌa kuwə-si, dꞌa kulə kəm-si ndoo, dꞌa kɔw sə-si kəykəwna̰-je-tɨ lə jipɨ-je, dꞌa kungɨ-si dangay-tɨ, dꞌa kɔw sə-si nɔ̰̀ ngar-je-tɨ, kɨ̀ nɔ̰̀ gubərnər-je-tɨ kdɔ ta lə-m. ");
INSERT INTO mge_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Né kinlé à ra kadɨ ingəi kəm lo ꞌpai-né ta kɨ́ sɔbɨ dɔ-m adi dow-je. ");
INSERT INTO mge_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ooi majɨ, ta kɨ́ à pai kdɔ kɔri-né ta dɔ-si-tɨ lé, ꞌlaji dɔ-tɨ kete al. ");
INSERT INTO mge_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kdɔtalə ma̰ ya mꞌa kadɨ-si gosɨ, kɨ́ à dum dɔ njéba-je lə-si lay rəm, ɓá mꞌa kadɨ-si ta kɨ́ a pai ə dꞌa kasɨ najɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Njékojɨ-si-je, kɨ̀ ngankɔ̰-si-je, kɨ̀ nojɨ-si-je, kɨ̀ nam-si-je ya dꞌa kun dɔ-si, ə dꞌa kadɨ ꞌtɔl dow-je n̰a̰ dan-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dow-je lay ya dꞌa kɔsɨ-si kɨ̀ ta kdɔ ta lə-m ya, ");
INSERT INTO mge_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ngà bəl dɔ-si káre ya kàrè à kɔr kusɨ kɔgɨ al. ");
INSERT INTO mge_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kuwə rɔ nga̰ ɓá ndil-si à kajɨ-né. ");
INSERT INTO mge_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Lokɨ ooi kɨ́ asgar-je ꞌgəə dɔ ɓebo Jorijalḛm rəmə, kadɨ ꞌgəi majɨ; tujɨ liə nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Beɓa kadɨ dow-je kɨ́ dꞌisɨ dɔnangɨ Jude-tɨ, dꞌa̰y dꞌɔw dan mbal-je-tɨ; ə dḛ kɨ́ dꞌisɨ mḛḛ ɓebo Jorijalḛm-tɨ rəmə, kadɨ ꞌtḛḛ kɔgɨ, ɓá dow-je kɨ́ dꞌa̰ ndɔrɔ-je kàrè, kadɨ ꞌtəl ꞌree mḛḛ ɓebo Jorijalḛm-tɨ gogɨ al ngá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kdɔtalə ndɔ-je kinlé à to ndɔ dalba, bè kdɔ kadɨ ta-je lay kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ lə Lubə lé, né-é ra né. ");
INSERT INTO mge_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ə́ mḛḛ ndɔ-é-je-tɨ kin, tujɨ kɨ́ à kusɨ dɔ dené-je-tɨ kɨ́ njésəm kɨ̀ dḛ kɨ́ dꞌisɨ dꞌadɨ mba ngan-je à tò ban ə́n ə! Kdɔtalə kɔ̰̀ kɨ́ n̰a̰ ya à kusɨ dɔnangɨ-tɨ kin rəm, ɓá wɔngɨ à ra Lubə dɔ dow-je-tɨ kin rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dow-je kɨ́ mḛḛ ɓebo-tɨ kinlé dꞌa koy yo kiyərɔ rəm, dꞌa kuwə dḛ kɨ́ ná̰-je kdɔ kɔw ra-dé ɓə-tɨ dan gin dow-je-tɨ lay. Ə ɓebo Jorijalḛm rəmə, gin dow-je kɨ́ ꞌto jipɨ-je al dꞌa mbəjrə nja-dé-tɨ sar kadɨ dɔkaglo lə dow-je kɨ́ ꞌto jipɨ-je al kin asɨ-né.» ");
INSERT INTO mge_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Né-je kɨ́ tò ɓəl-ɓəl ya à ra né kəm kàdɨ̀-tɨ, kɨ̀ kəm na̰y-tɨ, kɨ̀ kəm kərwəḭ-je-tɨ; ká babo kɨ́ à ɓa wuu-wuu kɨ̀ man-é kɨ́ à tal bum-bum ya à ra kadɨ gin dow-je kɨ́ dɔnangɨ-tɨ nè lay ya, ɓəl à kində bandɨ-dé batɨ gangɨ. ");
INSERT INTO mge_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tɔ́gɨ-je kɨ́ dɔra̰-tɨ à yəkɨ, adɨ dow-je kɨ́ dꞌa kisɨ gɨr dɔ né-tɨ kɨ́ à ree dɔ dɔnangɨ-tɨ kinlé, ɓəl ya à tɔl-dé. ");
INSERT INTO mge_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ɓəy ɓá dꞌa koo Ngon lə dow à kisɨ ree dan kilndi-tɨ kɨ̀ tɔ́gɨ, kɨ̀ riɓa kɨ́ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lokɨ ooi né-je kin ulə gin kadɨ ra né rəmə, adi mḛḛ-si nda ka̰y, ə adi dɔ-si tò kɨ taá, kdɔtalə nà̰y ngɔsi kadɨ Lubə taa-si ilə-si taá.» ");
INSERT INTO mge_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Go-tɨ, Jeju pa sə-dé ta kɨ̀ gosta panè: «Ooi kagɨ kote ə ooi ndəgɨ kagɨ-je kɨ́ lay tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lokɨ ooi mbi kagɨ-je isɨ itɨ rəmə, sə̰i ꞌgəi kɨ́ na̰y ɓà nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bè ya tɔ, lokɨ ooi kɨ́ né-je kinlé isɨ ra né rəmə, kadɨ ꞌgəi kɨ́ kɔ̰ɓe lə Lubə nà̰y ngɔsi tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ooi majɨ, mꞌa kidə-si rəsɨ kɨ́ dow-je kɨ́ dꞌisɨ kəm nè kin dꞌa koy lay al ya né-je kinlé à ra né. ");
INSERT INTO mge_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dɔra̰-je kɨ̀ dɔnangɨ kin dꞌa goto, ngà ta-je lə-m lé à goto al ya sartagangɨ.» ");
INSERT INTO mge_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Indəi kəmkaa dɔ rɔ-si-tɨ, nè nékuso kɨ́ mbə́-tɨ-je, kɨ̀ ra gɔ̰yibɨ, kɨ̀ mḛḛ ka̰ kə́kə́kə́ kdɔ né-je kɨ́ dɔnangɨ-tɨ nè à kḭ ra-si kadɨ mḛḛ-si ḭ oy səl dɔ rɔ-si-tɨ, kadɨ ndɔ kin ḭ ubə-si nangɨ busɨ. ");
INSERT INTO mge_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ndɔ kinlé, dow-je kɨ́ dɔnangɨ-tɨ nè lay ya à kubə-dé nangɨ busɨ tokɨ gum kɨ́ kilə kin bè. ");
INSERT INTO mge_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ə́n ə́ isi kəm dɔ rɔ-si-tɨ ə ꞌpai ta kɨ̀ Lubə kɨ̀ ndɔ-je lay kdɔ kadɨ ingəi tɔ́gɨ ꞌtḛḛi-né kɔgɨ ta né-je-tɨ lay kɨ́ ɔw kɨ̀ ra né kinlé rəm, kadɨ a̰i-né takəm Ngon lə dow-tɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kada lé, Jeju ndó dow-je né takəy-tɨ lə Lubə ə ndɔɔ rəmə, lo tò-é tò dɔ mbal-tɨ kɨ́ ꞌɓa-é mbal ka̰ kagɨ Olibiye-je-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dow-je lay ya ꞌtḛḛ kɨ̀ ndɔge ra-tɨ dꞌɔw rɔ-é-tɨ takəy-tɨ lə Lubə kdɔ koo ta liə. ");
INSERT INTO mge_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lokɨ ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ kɨ́ ꞌɓa-é Pakɨ nà̰y ngɔsi lé, ");
INSERT INTO mge_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je ꞌsangɨ kəm rəbɨ tɔl Jeju. Ngà dḛ ꞌɓəl kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Beɓa Sata̰ ur mḛḛ Judasɨ-tɨ kɨ́ ꞌɓa-é Iskariyotɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ lə Jeju kɨ́ dɔgɨ gidɨ-é joo lé, ");
INSERT INTO mge_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","adɨ ɔw ingə njékun dɔ njégugné-je, kɨ̀ njékun dɔ njéngəm takəy lə Lubə, adɨ dꞌɔjɨ-na̰ ta dɔ kəm rəbɨ-tɨ kɨ́ kadɨ nꞌilə-né Jeju ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Beɓa rɔ-dé nəl-dé n̰a̰ adɨ dꞌun mindɨ-dé kadɨ dꞌadɨ-é là. ");
INSERT INTO mge_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasɨ lé ndigɨ ə ulə gin sangɨ kəm rəbɨ kɨ́ kadɨ nꞌilə-é-né ji-dé-tɨ kadɨ kosɨ dow-je ꞌgə lo-é al. ");
INSERT INTO mge_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ kɨ́ to ndɔ kɨ́ tò kadɨ dꞌilə-né məsɨ ngonbatɨ ra na̰y Pakɨ nangɨ asɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ə Jeju ulə Piyər-je kɨ̀ Ja̰ panè: «Ɔwi, ꞌrai nékuso Pakɨ kete kdɔ kadɨ jꞌɔwi jꞌusoi.» ");
INSERT INTO mge_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dḛ ꞌdəjɨ-é ꞌpanè: Lo kɨ́ rá ɓá i ꞌndigɨ kadɨ jꞌra nékuso Pakɨ lé titɨ jꞌadɨ-i wa? ");
INSERT INTO mge_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jeju ilə-dé-tɨ panè: «Ooi bè, lokɨ ɔwi mḛḛ ɓebo-tɨ lé, a kingəi dingəm kɨ́ utɨ gùm man, rəmə ꞌndoli go-é ɔwi mḛḛ kəy-tɨ kɨ́ ḛ à kɔw-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ə idəi njèkəy lé ꞌpainè: “Njèndó dow-je né panè jꞌdəjɨ-i sé mḛḛ kəy kɨ́ rá ɓá nꞌa kuso né Pakɨ-tɨ kɨ̀ njéndó né-je lə-nꞌḛ̀ wa?” ");
INSERT INTO mge_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ə ḛ à kɔjɨ-si kəy káre kɨ́ mḛḛ-é tatɨ pəl-pəl kɨ́ tò dɔ madɨ-é-tɨ taá, kɨ́ né-je lay tò-tɨ; lo kin ɓá a rai nékuso titɨ.» ");
INSERT INTO mge_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Beɓa dḛ dꞌɔtɨ dꞌɔw rəmə, dꞌingə né-je lay titɨ kɨ́ Jeju idə-dé-né lé ə dḛ ꞌra nékuso Pakɨ lé. ");
INSERT INTO mge_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lokɨ dɔkàdɨ̀ kuso né Pakɨ asɨ lé, Jeju isɨ ta nékuso-tɨ kɨ̀ njékɔwkulə-je liə. ");
INSERT INTO mge_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rəmə ḛ idə-dé panè: Mꞌndigɨ n̰a̰ kadɨ mꞌuso sə-si né Pakɨ kete tá-je mꞌingə kɔ̰̀! ");
INSERT INTO mge_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Beɓa mꞌa kidə-si rəsɨ kɨ́ mꞌa kuso sə-si gogɨ al ya sar kadɨ kɔr mḛḛ-é kɨ́ aa njay tò-né kɔ̰ɓe-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Beɓa ḛ un kobɨ kɨ́ man nduu tò-tɨ, ra oiyo Lubə ə panè: ꞌTaai, ə umi surum-surum. ");
INSERT INTO mge_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ə mꞌa kidə-si rəsɨ. Kḭ nè kɔw kɨ kete kinlé, mꞌa ka̰y man nduu kin gogɨ al ya sar kadɨ kɔ̰ɓe lə Lubə ree-né. ");
INSERT INTO mge_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Go-tɨ, ḛ un mbə̀, ə ra oiyo Lubə ɓá uwə gangɨ dana̰ adɨ-dé ə panè: Ḛ kinlé to dajɨ rɔ-m kɨ́ to kɨ́ kadɨ kdɔ ta lə-si, ꞌrai bè-bè kadɨ mḛḛ-si ole-né dɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bè ya tɔ, go né kuso-tɨ lé ḛ un kobɨ kɨ́ man nduu tò-tɨ ə panè: Ḛ kinlé to məsɨ-m, məsɨ kulənojɨ kɨ́ sigɨ kɨ́ Lubə adɨ ungɨ kɔgɨ kdɔ ta lə-si. ");
INSERT INTO mge_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngà ooi, njèkun dɔ-m lé isɨ sə-m ta nékuso-tɨ nè. ");
INSERT INTO mge_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Beɓa Ngon lə dow à koy titɨ kɨ́ Lubə ɔjɨ-né, ngà tujɨ ɓá à kusɨ dɔ dow-tɨ kɨ́ njèkun dɔ-é lé. ");
INSERT INTO mge_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Beɓa dḛ ꞌdəjɨ-na̰ ta dan-dé-tɨ yó kɨ nè ꞌpanè sé ná̰ ya dan-dé-tɨ ə à ra né kin wa? ");
INSERT INTO mge_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Go-tɨ, njéndó né-je lə Jeju ꞌgakɨ-na̰ dɔ ta-tɨ kɨ́ sɔbɨ dɔ dow kɨ́ à to kɨ́ boy n̰a̰ dan-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Adɨ Jeju idə-dé panè: Ngar-je kɨ́ njékɔ̰̀ gin dow-je kɨ́ gay-gay kɨ́ dɔnangɨ-tɨ nè lé, dꞌulə kəm dow-je ndoo n̰a̰ ə ꞌboy-je kɨ́ njékɔw kɨ̀ tɔ́gɨ dɔ dow-je-tɨ lé, dꞌadɨ dow-je ꞌɓa-dé «Njéramajɨ-je.» ");
INSERT INTO mge_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sə̰i rəmə à tò bè dan-si-tɨ al. Ngà kadɨ dow kɨ́ to ꞌboy n̰a̰ dan-si-tɨ lé, təl rɔ-é titɨ ngon kɨ́ ndḛ bè ə kadɨ njèkɔ̰ɓe dɔ madɨ-é-je-tɨ lé, təl njérakullə kadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Njèkisɨ ta nékuso-tɨ ɓá to kɨ́ ꞌboy əse njèkadɨ nékuso ɓá to kɨ́ ꞌboy wa? To njèkisɨ ta nékuso-tɨ ya al wa? Ngà ma̰ ɓá mꞌisɨ dan-si-tɨ titɨ njérakullə kadɨ-si bè. ");
INSERT INTO mge_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Sə̰i rəmə, sə̰i ꞌtoi njékuwə rɔ-si nga̰ kində rɔ-si kɔ-tɨ natɨ sə-m. ");
INSERT INTO mge_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gin-é kin ɓá titɨ kɨ́ Bɔbɨ-m uwə-né dɔ kɔ̰ɓe adɨ-m lé, ma̰ mꞌuwə dɔ kɔ̰ɓe mꞌadɨ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kdɔ kadɨ mḛḛ kɔ̰ɓe-tɨ lə-m lé, usoi sə-m rəm, a̰yi sə-m rəm, ɓá a kisi dɔ kalikɔ̰ɓe-je-tɨ kdɔ gangta dɔ gin Israyel-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ꞌƁaɓe panè: Simɔ̰, Simɔ̰! ꞌOo, Sata̰ dəjɨ n̰a̰ kadɨ nꞌsiyə-si titɨ kɨ́ dow siyə-né ko kin bè. ");
INSERT INTO mge_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngà ma̰ mꞌpa ta kɨ̀ Lubə kdɔ ta lə-i, kdɔ kadɨ kadmḛḛ lə-i təl yay al. Ə i rəmə, lokɨ ꞌa təl ree rɔ-m-tɨ gogɨ lé, ꞌmbusɨ nja ngankɔ̰-i. ");
INSERT INTO mge_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyər lé idə-é panè: ꞌƁaɓe, mꞌisɨ dɔ nja-m-tɨ kadɨ lé, to dangay kàrè mꞌɔw-tɨ sə-i rəm, to koy kàrè mꞌoy sə-i natɨ rəm. ");
INSERT INTO mge_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Beɓa Jeju ilə-é-tɨ panè: Piyər, ꞌoo majɨ, ɓone kin ya ꞌa najɨ panè ꞌgə-m al ꞌgə-m al ya nja mutə ɓá kunjə à nɔ̰ ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Beɓa Jeju idə-dé ɓəy panè: Ndɔkɨ mꞌulə-si ə́ ɔwi kɨ̀ mbu là al rəm, uni mbu kɔw mba al rəm, ɓá ɔwi kɨ̀ saba al rəm lé se né madɨ nal-si wa? Dḛ dꞌilə-é-tɨ ꞌpanè: Né ya kàrè nal-ji al. ");
INSERT INTO mge_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ḛ təl idə-dé panè: Ngà kɨ́ nè kinlé, dow kɨ́ ɔw kɨ̀ mbu là rəmə, kadɨ un, ɓá dow kɨ́ ɔw kɨ̀ mbu kɔw mba kàrè kadɨ un tɔ; ngà dow kɨ́ kiyərɔ liə goto rəmə, kadɨ un kubɨ kul liə ndogɨ ə ndogɨ-né kiyərɔ káre. ");
INSERT INTO mge_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mꞌidə-si rəsɨ, ta-je kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay lé, tò kadɨ né-é tḛḛ dɔ-m-tɨ ya. ꞌNdàngɨ ꞌpanè: «ꞌTidə-é dan bɔkaya-je-tɨ.» Adɨ ta-je kɨ́ ꞌndàngɨ sɔbɨ dɔ-m lé, né-é à ra né ya. ");
INSERT INTO mge_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Rəmə njéndó né-je ꞌpanè: ꞌƁaɓe, ꞌoo kiyərɔ ə ra joo tin. Ə ḛ ilə-dé-tɨ panè: Jꞌadi ta kin asɨ bè. ");
INSERT INTO mge_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Beɓa Jeju tḛḛ mḛḛ ɓebo-tɨ isɨ ɔw dɔ mbal ka̰ kagɨ Olibiye-je-tɨ titɨ kɨ́ ḛ ɔw-né kete-kete ə njéndó né-je liə dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lokɨ ꞌɔw tḛḛ lo-é-tɨ lé, ḛ idə-dé panè: «ꞌPai ta kɨ̀ Lubə kdɔ kadɨ néna̰ tḛḛ dɔ-si-tɨ rəmə usi al.» ");
INSERT INTO mge_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Rəmə ḛ ɔr rɔ-é ngərəngɨ asɨ kilə ər ji káre, ɓá ɔsɨ məkəjɨ-é nangɨ pa ta kɨ̀ Lubə, ");
INSERT INTO mge_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","panè: Bɔbɨ-m, kinə ꞌndigɨ rəmə ꞌitə kɔ̰̀ kɨ́ n̰a̰ kin kɨ rangɨ dɔ-m-tɨ. Lé bè ya kàrè, kadɨ né kɨ́ mḛḛ-m ma̰ ndigɨ ɓá ꞌra al, ngà kadɨ ꞌra né kɨ́ mḛḛ-i i ɓá ndigɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Beɓa malayka káre ḭ dɔra̰-tɨ tḛḛ siə busɨ kdɔ kadɨ-é tɔ́gɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mḛḛ Jeju gangɨ man adɨ pa ta kɨ̀ Lubə kɨ̀ tɔ́gɨ-é lay, adɨ tətɨ-é tusɨ nangɨ titɨ-na̰ kɨ̀ kɔɔ məsɨ kɨ́ tusɨ nangɨ kin ya bè. ");
INSERT INTO mge_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Go ta-tɨ kɨ́ Jeju pa kɨ̀ Lubə lé, ḛ ḭ taá təl ree ingə njéndó né-je rəmə, mḛḛkɔ̰̀ tɔl-dé kɨ̀ ɓi, ");
INSERT INTO mge_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","adɨ Jeju pa sə-dé panè: Kin to ri! ꞌToi ɓii! Ḭi taá, ꞌpai ta kɨ̀ Lubə, kdɔ kadɨ néna̰ tḛḛ dɔ-si-tɨ rəmə usi al. ");
INSERT INTO mge_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ngà lokɨ Jeju a̰ pa ta ɓəy ya rəmə, kosɨ dow-je ꞌtḛḛ busɨ, ə dow káre dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo kɨ́ ꞌɓa-é Judasɨ ɓá ɔr nɔ̰̀-dé; ḛ ɔw rɔ Jeju-tɨ kadɨ nꞌuwə-é kɨ kàdɨ̀-nꞌḛ̀-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngà Jeju idə-é panè: Judasɨ, ra lapiya dow kuwə-é-né kɨ kàdɨ̀-i-tɨ ɓá to né kilə Ngon lə dow ji dow-je-tɨ al ɓan wa! ");
INSERT INTO mge_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ngà lokɨ dḛ kɨ́ dꞌa̰ kɨ̀ Jeju dꞌoo né kɨ́ ɔw ra né lé bè rəmə ꞌdəjɨ-é ꞌpanè: ꞌƁaɓe, jꞌjəngɨ-dé kɨ̀ kiyərɔ-je lə-ji kin wa? ");
INSERT INTO mge_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ə ngonnjèkullə lə burə dɔ njégugné-je lə Lubə lé, dow káre dan njéndó né-je-tɨ, tugə mbi-é kɨ́ dɔ jikɔl ndoy ɔr. ");
INSERT INTO mge_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngà ɓá Jeju panè: In̰ə̰i-dé adɨ ꞌra. Ə ḛ ɔdɨ rɔ mbi dingəm lé rəmə, ra adɨ mbi-é təl tò majɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Go-tɨ, Jeju idə njékun dɔ njégugné-je lə Lubə, kɨ̀ njékun dɔ njéngəm takəy lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je kɨ́ ꞌree kdɔ kuwə-é lé panè: Sə̰i ooi-mi kɨ bɔkaya dow ɓá ꞌreei kɨ̀ kiyərɔ-je kɨ̀ salangɨ-je wa? ");
INSERT INTO mge_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɔ-je lay ya mꞌisɨ sə-si takəy-tɨ lə Lubə ya ə uwəi-mi al, ngà dɔkàdɨ̀ kɨ́ nè kinlé, to dɔkàdɨ̀ lə-si, to dɔkàdɨ̀ lə tɔ́gɨ kɨ́ lo ndul-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lokɨ dꞌuwə Jeju rəmə, dḛ dꞌɔr-é dꞌɔw siə ɓe lə burə dɔ njégugné-je lə Lubə ə Piyər njiyə go-dé-tɨ adɨ rəbɨ-é rà ɗəkɨ sə-dé. ");
INSERT INTO mge_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dow-je ꞌra pər panata dꞌisɨ ta-tɨ ə Piyər ɔw isɨ sə-dé ta-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngonnjèkullə kɨ́ dené káre oo Piyər isɨ ta pər-tɨ rəmə, oo-é gə́rə́rə́ ə panè: Dingəm kinlé to njènjiyə kɨ̀ Jeju tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngà Piyər najɨ panè: «Dené! Mꞌgə-é al.» ");
INSERT INTO mge_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Sḛ go-tɨ ya rəmə dow kɨ́ rangɨ oo-é ə panè: «I kàrè ꞌto kɨ́ dan-dé-tɨ tɔ.» Ngà dingəm lé Piyər ilə-é-tɨ panè: «Kuy! Mꞌto kɨ́ dan-dé-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Asɨ kàdɨ̀ káre je bè go-tɨ lé, dow kɨ́ rangɨ ree pa ta a̰ dɔ-tɨ njángɨ panè: «Tɔgrɔ-tɨ ya, dingəm kinlé to njènjiyə siə tɔ; kdɔ ḛ to dow kɨ́ dɔnangɨ Galile-tɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngà Piyər ilə-é-tɨ panè: «I lé, ta ri ɓá ꞌndigɨ pa kàrè ma̰ mꞌgə al.» Lokɨ ḛ a̰ pa ta kɨ pa ya ɓəy rəmə kunjə nɔ̰. ");
INSERT INTO mge_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Beɓa ꞌƁaɓe təl kəm-é oo Piyər gə́rə́rə́ rəmə mḛḛ Piyər ole dɔ ta-tɨ kɨ́ kete ꞌƁaɓe pa siə panè: «Ɓone kin ya ꞌa najɨ panè ꞌgə-m al ꞌgə-m al nja mutə ɓá kunjə à nɔ̰ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Beɓa Piyər tḛḛ ndaa-tɨ ə nɔ̰ kɨ̀ mḛḛkɔ̰̀ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dingəm-je kɨ́ dꞌa̰ ꞌngəm ta Jeju lé, sɔkɨ-é, ɓá ꞌtində-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dḛ ꞌdɔɔ kəm-é kɨ̀ takubɨ ɓá dəjɨ-é ꞌpanè: «ꞌAdɨ Lubə idə-i ə ꞌpa adɨ jꞌoo sé to ná̰ ɓá ində-i wa?» ");
INSERT INTO mge_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɓəy ɓá ꞌpa siə takɔbɨ-je kɨ́ rangɨ n̰a̰ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lokɨ lo aa rəmə, ꞌngatɔ́gɨ-je lə jipɨ-je, kɨ̀ njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je ꞌkəw-na̰ lay ɓá ꞌree kɨ̀ Jeju nɔ̰̀ ꞌboy-je-tɨ kɨ́ ꞌto njégangta-je lə-dé. ");
INSERT INTO mge_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Beɓa ꞌdəjɨ-é ꞌpanè: «Kinə ꞌto Kristɨ lé rəmə, ꞌidə-ji.» Ḛ ilə-dé-tɨ panè: «Lé mꞌidə-si ya kàrè a taai ta lə-m al rəm, ");
INSERT INTO mge_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ɓá kinə mꞌdəjɨ-si ta kàrè, a kiləi-mi-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngà kḭ nè kɔw kɨ kete kinlé, Ngon lə dow à kisɨ dɔ jikɔl Lubə-tɨ kɨ́ njètɔ́gɨ.» ");
INSERT INTO mge_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Beɓa dḛ lay ya ꞌpanè: «Adɨ ꞌto Ngon lə Lubə ə́n nà̰?» Ḛ təl ilə-dé-tɨ panè: «Titɨ kɨ́ sə̰i ꞌpai-né lé, mꞌto Ngon lə Lubə ya!» ");
INSERT INTO mge_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Beɓa dḛ ꞌpanè: «Jꞌɔwi ndoo koo ta ta dow kɨ́ rangɨ-tɨ ɓəy ɓan wa! Kdɔ jə̰i ya jꞌooi ta lé ta-é-tɨ kɨ̀ mbi-ji.» ");
INSERT INTO mge_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Beɓa dꞌḭ kɨ̀ kosɨ-dé lay ya dꞌɔw kɨ̀ Jeju nɔ̰̀ Gubərnər Pilatɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lo-é-tɨ nɔ̰ɔ̰ ɓá dḛ ꞌtilə ta-je dɔ-é-tɨ ꞌpanè: Dingəm kanlé, né kɨ́ a̰ ra ɓá jꞌuwə-é dɔ-tɨ ə́n: Ḛ a̰ sulə gin dow-je lə-ji kadɨ ꞌra dɔnga̰, kadɨ dꞌadɨ lambo Sejar ngar kɨ́ boy lé al rəm, ɓá a̰ dɔ-tɨ panè: Nꞌḛ̀ ya nꞌto Kristɨ, adɨ nꞌto ngar. ");
INSERT INTO mge_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatɨ dəjɨ-é ta panè: «ꞌTo ngar lə jipɨ-je wa?» Jeju ilə-é-tɨ panè: «Ta ya tḛḛ ta-i-tɨ tin.» ");
INSERT INTO mge_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Beɓa Pilatɨ idə njékun dɔ njégugné-je lə Lubə, kɨ̀ kosɨ dow-je lé panè: Né kɨ́ majɨ al káre kɨ́ dingəm kanlé ra kɨ́ kadɨ mꞌgangɨ-né ta dɔ-é-tɨ ya mꞌoo al. ");
INSERT INTO mge_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngà dḛ ꞌpa par-par ꞌpanè: Ḛ ulə gin-é dɔnangɨ Galile-tɨ nṵ ya sulə dow-je mḛḛ néndó-je-tɨ liə, ree un-né dɔnangɨ Jude latɨ-latɨ, ɓá ree-né njal rɔ-ji-tɨ nè tin. ");
INSERT INTO mge_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lokɨ ꞌɓa ri dɔnangɨ Galile rəmə, Pilatɨ dəjɨ-dé panè: Sé dingəm kanlé, to dow kɨ́ dɔnangɨ Galile-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lokɨ Pilatɨ oo kɨ́ Jeju to dow kɨ́ mḛḛ ɓekɔ̰-tɨ lə Erodɨ lé, ḛ ulə siə rɔ-é-tɨ, kdɔtalə mḛḛ ndɔ-é-je-tɨ kinlé Erodɨ kàrè, isɨ ɓebo Jorijalḛm-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lokɨ Erodɨ oo Jeju lé, rɔ-é nəl-é n̰a̰ kdɔtalə low nṵ ya ḛ ndingə kadɨ nꞌoo-é, kdɔ dow-je ꞌpa ta liə dꞌadɨ-é oo, adɨ ḛ ində mḛḛ dɔ-tɨ kadɨ nꞌoo Jeju lo ra nékɔjɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erodɨ dəjɨ Jeju ta-je n̰a̰ ya, ngà Jeju ilə-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Njékun dɔ njégugné-je lə Lubə, kɨ̀ njéndó dow-je ndukun-je dꞌa̰ lo-é-tɨ nɔ̰ɔ̰ ə ꞌtilə ta dɔ Jeju-tɨ kɨ̀ rɔtungə-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodɨ kɨ̀ asgar-je liə dꞌənjɨ Jeju dḛḛ. Dḛ ꞌsɔkɨ-é, dꞌulə kubɨ kɨ̀ majɨ n̰a̰ rɔ-é-tɨ ə ꞌsɔkɨ-é rəm, ngá ɓá dꞌulə siə rɔ Pilatɨ-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndɔ-é-tɨ kin ya Pilatɨ-je kɨ̀ Erodɨ kɨ́ ꞌto njéba-je lə-na̰ lé, ꞌtəl-né nam-na̰-je. ");
INSERT INTO mge_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatɨ kəw njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌboy-je lə jipɨ-je, kɨ̀ kosɨ dow-je ə idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Dingəm kanlé, sə̰i ꞌpainè to njèsulə dow-je kadɨ ꞌra dɔnga̰ ɓá sə̰i ꞌreei-né siə rɔ-m-tɨ. Ngà, ooi bè, mꞌdəjɨ-é ta-je takəm-si-tɨ nè ə né-je kɨ́ sə̰i ꞌtiləi ta-é dɔ-é-tɨ lé, né kɨ́ majɨ al káre ya kɨ́ ḛ ra kàrè mꞌoo al. ");
INSERT INTO mge_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodɨ kàrè oo né kɨ́ majɨ al kɨ́ dingəm kanlé ra al tɔ. Kdɔtalə ḛ ə́ təl ulə siə rɔ-ji-tɨ nè gogɨ tin. Yən, dingəm kanlé, né kɨ́ ḛ ra kɨ́ asɨ koy-é ya goto. ");
INSERT INTO mge_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Beɓa mꞌa kadɨ ꞌtində-é kɨ̀ ndəy marɔw ya ə mꞌa kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ndɔ ra na̰y Pakɨ-je lay ya, lé ri-ri kàrè Pilatɨ à kilə dangay káre taá kadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngà dow-je lay ya dꞌur kɔɔl natɨ boy ꞌpanè: «ꞌTɔl dow kan ə ilə Barabasɨ taá adɨ-ji.» ");
INSERT INTO mge_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasɨ lé, dꞌuwə-é kdɔtalə ndɔkɨ sulə dow-je adɨ ꞌra wɔngɨ mḛḛ ɓebo-tɨ rəm, ɓá dꞌuwə-é kuwə tɔl dow rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɨ ndigɨ kilə Jeju taá, adɨ ḛ təl pa sə-dé ta dɔ-tɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngà dḛ ꞌtur kɔɔl mbitɨ-mbitɨ ꞌpanè: «ꞌƁə-é kagdəsɨ-tɨ! ꞌƁə-é kagdəsɨ-tɨ!» ");
INSERT INTO mge_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatɨ lé, təl dəjɨ-dé kɨ́ njèkungɨ-tɨ mutə panè: «Ə to majal ri ya ɓá Jeju lé ra wa?» Né kɨ́ ḛ ra kɨ́ asɨ kadɨ dow tɔl-é-né ya ma̰ mꞌoo al. Adɨ mꞌa kadɨ ꞌtində-é kɨ̀ ndəy marɔw ya ə mꞌa kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngà dḛ ꞌtur kɔɔl boy-boy, ꞌdəjɨ-é-né par-par kadɨ ꞌɓə-é kagdəsɨ-tɨ kɨ ɓə ya, adɨ ndi-dé ɓa nduy-é pitɨm. ");
INSERT INTO mge_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Rəmə, Pilatɨ un ndu kadɨ tokɨ ꞌra né kɨ́ dḛ ꞌdəjɨ lé dꞌadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Beɓa dow kɨ́ dꞌuwə-é kdɔtalə wɔngɨ kɨ́ ndɔkɨ ḛ sulə dow-je adɨ ꞌra mḛḛ ɓebo-tɨ rəm, kdɔtalə to kɨ́ ḛ to njètɔl dow rəm lé ɓá Pilatɨ ilə-é taá, kdɔ ḛ ɓá dḛ ꞌdəjɨ kadɨ ilə-é taá. Rəmə Jeju ɓá ḛ ilə-é ji-dé-tɨ kadɨ ꞌra siə né kɨ́ mḛḛ-dé ndigɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lokɨ dꞌisɨ dꞌɔw kɨ̀ Jeju lé, dingəm káre bè kɨ́ ɓebo Sirḛn-tɨ, ri-é lə Simɔ̰ ḭ ndɔrɔ, ya rəmə dꞌuwə-é gə̀sə̀sə̀ ya dꞌində kagdəsɨ dɔ-é-tɨ dꞌadɨ-é utɨ go Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dꞌun go Jeju; ə dené-je kɨ́ dan-dé-tɨ ꞌtində kàdɨ̀-dé, ꞌndingə rɔ-dé kdɔ ta liə. ");
INSERT INTO mge_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Beɓa Jeju təl kəm-é kɨ rɔ dené-je-tɨ lé idə-dé panè: Mandɨ-je kɨ́ ɓebo Jorijalḛm-tɨ, ꞌnɔ̰i-mi al; sə̰i ya ꞌnɔ̰i rɔ-si ə ꞌnɔ̰i ngan-si-je tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kdɔtalə ndɔ-je ɔw ree nɔ̰ɔ̰ kɨ́ dow-je dꞌa panè: Kujdené-je ɓá ꞌto njénékumə̰-je! Dené-je kɨ́ dꞌojɨ ngan-je al, kɨ̀ dḛ kɨ́ ngon il mbà-dé al ɓá ꞌto njénékumə̰-je! ");
INSERT INTO mge_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ndɔ-é-tɨ kinlé, dow-je dꞌa kidə mbal-je panè: ꞌTusi dɔ-ji-tɨ! Ə dꞌa kidə mbal-je kɨ́ gɔjɨ panè: Uti dɔ-ji! ");
INSERT INTO mge_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kdɔtalə, kinə dow-je ꞌra né-je kɨ́ bè kin kɨ̀ kagɨ-je kɨ́ mbəl lé, kagɨ-je kɨ́ tutɨ ə jè à tana̰ ban ngá ə́n wa? ");
INSERT INTO mge_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ꞌRee kɨ̀ bɔkaya-je joo kɨ́ dꞌa tɔl-dé natɨ kɨ̀ Jeju tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lokɨ dꞌɔw ꞌtḛḛ lo-tɨ kɨ́ ꞌɓa-é «lo ka dɔ dow» lé, ꞌɓə Jeju kagdəsɨ-tɨ lo-é-tɨ nɔ̰ɔ̰ rəm, ɓá bɔkaya-je kɨ́ joo lé kàrè, ꞌɓə-dé kagdəsɨ-je-tɨ tɔ. ꞌƁə ḛ kɨ́ káre dɔ jikɔl-é-tɨ ə ḛ kɨ́ káre ɓá ꞌɓə-é dɔ jigəl-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jeju panè: Bɔbɨ-m, ꞌin̰ə go kɔgɨ adɨ-dé, kdɔtalə né-je kɨ́ dꞌa̰ ꞌra kinlé, gə ya ɓá ꞌgə al. Dḛ ꞌləbɨ-na̰ kubɨ-je liə kɨ̀ kəm rəbɨ mbare kɨ́ kɔsɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Dow-je dꞌa̰ ɗingɨ-ɗingɨ lo-é-tɨ kinlé, dꞌa̰ dꞌoo né-je kɨ́ isɨ ra né lé. Ngà ꞌboy-je lə jipɨ-je ꞌsɔkɨ Jeju ꞌpanè: Dow-je kɨ́ rangɨ ɓá ḛ ajɨ-dé; kinə ḛ to Kristɨ, dow kɨ́ Lubə mbətɨ-é lé ngà ajɨ rɔ-é tɔ ngá nà̰. ");
INSERT INTO mge_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asgar-je kàrè ꞌsɔkɨ Jeju tɔ. Dḛ ꞌree kɨ̀ man nduu kɨ́ masɨ dꞌadɨ-é, ");
INSERT INTO mge_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ə ꞌpanè: «Kinə ꞌto ngar lə jipɨ-je rəmə, i ya ꞌajɨ rɔ-i adɨ jꞌoo nà̰!» ");
INSERT INTO mge_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ꞌNdàngɨ ta bəgrə-tɨ ꞌɓə dɔ-é-tɨ taá ꞌpanè: Ḛ kanlé, to ngar lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bɔkaya-je kɨ́ ꞌɓə-dé kagdəsɨ-je-tɨ lé, ḛ kɨ́ káre pa ta sɔkɨ-né Jeju panè: I ya ɓá ꞌto Kristɨ lé al wa? I ya ꞌajɨ rɔ-i ə jè ꞌajɨ-ji tɔ ngá nà̰! ");
INSERT INTO mge_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngà ḛ kɨ́ káre lé ɓá ndángɨ-é panè: I lé, ꞌɓəl Lubə al wa? Ta kɨ́ ꞌgangɨ dɔ-i-tɨ kinlé, ḛ ya ꞌgangɨ dɔ-é-tɨ tɔ al wa? ");
INSERT INTO mge_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jḛ lé, ta kɨ́ ꞌgangɨ dɔ-ji-tɨ kinlé to tó-é ya, kdɔtalə to kullə ra-ji-je ya ɓá jꞌa̰ jꞌugə kurə-é tin. Ngà ḛ kanlé, né kɨ́ majɨ al káre ya kàrè ḛ ra al. ");
INSERT INTO mge_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Go-tɨ, ḛ təl idə Jeju panè: Ndɔ kɨ́ à ree kɨ̀ kɔ̰ɓe lə-i rəmə, ꞌadɨ mḛḛ-i ole dɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeju ilə-é-tɨ panè: ꞌOo majɨ, mꞌa kidə-i rəsɨ; ɓone kin ya ꞌa kisɨ sə-m natɨ ɓe kisɨ majɨ-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lokɨ kàdɨ̀ à ka̰ jam dɔ ɓe-tɨ je bè ya rəmə, lo ndul ndḭ-ndḭ dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè lay sar ya kàdɨ̀ kɨ́ mutə kɨ́ losɔlɔ asɨ-né. ");
INSERT INTO mge_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Né utɨ kəm kàdɨ̀ adɨ lo ndul ndḭ-ndḭ ə kubɨ gangɨ mḛḛ kəy lə Lubə til dana̰ lo joo. ");
INSERT INTO mge_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jeju ilə bɔbɨ ndi-é nangɨ panè: «Bɔbɨ-m, mꞌulə ndil-m mḛḛ ji-i-tɨ.» Lokɨ Jeju pa ta kin bè ya rəmə, uwə ta-é natɨ. ");
INSERT INTO mge_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lokɨ njèkun dɔ kutɨ asgar-je kɨ́ ɓu oo né kɨ́ ra né kin bè lé, ɔsɨ gajɨ Lubə panè: «Tɔgrɔ-tɨ ya, dingəm kinlé, to dow kɨ́ njururu.» ");
INSERT INTO mge_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lokɨ kosɨ dow-je kɨ́ ꞌtò nduy-nduy kɨ́ ꞌree dꞌa̰ lo né-je-tɨ kinlé, dꞌoo né-je kɨ́ ra né lé bè rəmə, ꞌtində kàdɨ̀-dé taá-taá ꞌtəl-né kɨ ɓee. ");
INSERT INTO mge_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dow-je lay kɨ́ ꞌgə Jeju rəm, dené-je kɨ́ dꞌḭ siə dɔnangɨ Galile-tɨ nṵ ya ꞌdan-é ꞌree siə lé, dꞌa̰ ngərəngɨ ɓá dꞌa̰ dꞌoo né-je kɨ́ isɨ ra né lé. ");
INSERT INTO mge_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Dingəm madɨ isɨ nɔ̰ɔ̰ to kɨ́ káre dan ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je, ri-é lə Jojepɨ, to dow kɨ́ majɨ, ɓá to dow kɨ́ njururu rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jojepɨ lé, ta-é asɨ-na̰ sə-dé dɔ ndu-tɨ kɨ́ dꞌun kinlé al rəm, ɓá ində rɔ-é natɨ sə-dé dɔ kullə ra-dé-je-tɨ kin al rəm tɔ. Ḛ to dow kɨ́ Arimate, ɓebo-tɨ lə jipɨ-je; ḛ isɨ ngəbɨ kɔ̰ɓe lə Lubə kɨ́ à ree. ");
INSERT INTO mge_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jojepɨ ɔw rɔ Pilatɨ-tɨ dəjɨ-é nin Jeju lé. ");
INSERT INTO mge_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Beɓa ḛ ɔr-é kagdəsɨ-tɨ, ɓɨr-é kɨ̀ takubɨ ngá ɓá ɔw ilə-é ɓe nin-tɨ kɨ́ to mbal ɓá ꞌsɔkɨ. To lo kɨ́ dꞌilə nin-tɨ al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndɔ-é-tɨ kinlé, to ndɔ koo go né-je kdɔ ndɔ taakoo, adɨ lo aa ya rəmə à to ndɔ taakoo. ");
INSERT INTO mge_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dené-je kɨ́ dꞌḭ kɨ̀ Jeju dɔnangɨ Galile-tɨ nṵ ꞌree siə lé, ꞌdan Jojepɨ, ə dꞌa̰ dꞌoo ɓadɨ lé rəm, ꞌtən dꞌoo se nin Jeju lé tokɨ kilə ɓe-tɨ ban wa? ");
INSERT INTO mge_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dḛ ꞌtəl dꞌɔw ɓee lə-dé kdɔ koo go nɔ̰kagɨ-je, kɨ̀ ubɨ-je kɨ́ ətɨ majɨ-majɨ kdɔ ree kungɨ dɔ nin-tɨ lé. Ndɔ taakoo-tɨ lé, dḛ ꞌtaakoo titɨ kɨ́ ndukun lə Lubə ɔjɨ-né lé ya tɔ. ");
INSERT INTO mge_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ndɔ Dimasɨ kɨ̀ ndɔge ratɨ ya dené-je ꞌtḛḛ kɨ̀ ubɨ-je kɨ́ ətɨ majɨ-majɨ kɨ́ ꞌra kete lé, ji-dé-tɨ dꞌɔw-né dɔɓadɨ-tɨ, ");
INSERT INTO mge_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","rəmə dꞌoo kɨ́ ər kɨ́ dꞌutɨ-né ta ɓadɨ lé tokɨ ꞌnduburu kilə rangɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Beɓa lokɨ dꞌandɨ ɓe nin-tɨ rəmə, dꞌoo nin ꞌƁaɓe Jeju lé al. ");
INSERT INTO mge_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lokɨ dꞌa̰ kɨ́ lo ta igɨ-dé sə́l ɓəy ya rəmə, dingəm-je joo kɨ́ dꞌulə kubɨ-je kɨ́ ndɔ̰y ngilingɨ-ngilingɨ rɔ-dé-tɨ ꞌtḛḛ sə-dé busɨ, ");
INSERT INTO mge_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","adɨ ɓəl ində bandɨ-dé batɨ gangɨ ə dꞌulə dɔ-dé nangɨ; ngà dingəm-je lé dꞌidə-dé ꞌpanè: Dow kɨ́ isɨ kəm lé, kdɔ ri ɓá ꞌsangi-é dan nin-je-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ḛ tɔsɨ ndəl ində lo tḛḛ, adɨ ḛ goto nè ngá. Adi mḛḛ-si ole dɔ ta-tɨ kɨ́ ndɔkɨ idə-si lokɨ ḛ isɨ-né dɔnangɨ Galile-tɨ ɓəy lé. ");
INSERT INTO mge_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ndɔkɨ ḛ panè: Tò kadɨ dꞌa kilə Ngon lə dow ji njéramajal-je-tɨ, kadɨ ꞌɓə-é kagdəsɨ-tɨ, ə ndɔ kɨ́ njèkungɨ-tɨ mutə lé, à tɔsɨ ndəl kində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Beɓa mḛḛ dené-je lé ole dɔ ta-je-tɨ lə Jeju. ");
INSERT INTO mge_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dḛ dꞌɔsɨ təl dɔɓadɨ-tɨ, dꞌɔw dꞌɔr poy né-je kinlé lay dꞌadɨ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é káre lé rəm, ɓá dꞌadɨ ndəgɨ dow-je kɨ́ rangɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Dené-é-je lé, to Mari kɨ́ Magdala, kɨ̀ Jan, kɨ̀ Mari kɨ́ kɔ̰ Jakɨ ɓá dené-je madɨ kɨ́ dꞌa̰ sə-dé natɨ lé, dꞌɔr poy-é dꞌadɨ njékɔwkulə-je lé tɔ. ");
INSERT INTO mge_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngà ta-je kɨ́ dené-je ꞌpa lé, njékɔwkulə-je dꞌoo kɨ̀ ta mbə́ bè, adɨ ꞌtaa ta lə-dé al. ");
INSERT INTO mge_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngà Piyər ubə nangɨ ḭ taá a̰y ngɔdɨ ɔw dɔɓadɨ-tɨ, ə lokɨ ɗugɨ nangɨ gɔ̰ lo ɓe nin-tɨ rəmə, takubɨ-je ya par ɓá ḛ oo. Né kɨ́ ra né kinlé, ra adɨ lo ta igɨ-é sə́l adɨ ḛ ɔsɨ yɔrɔrɔ ya təl ɔw ɓee. ");
INSERT INTO mge_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mḛḛ ndɔ-é-tɨ kɨ́ káre kinlé ya, dow-je joo dan njéndó né-je-tɨ lə Jeju dꞌisɨ dꞌɔw kɨ mḛḛ ɓe-tɨ kɨ́ ꞌɓa-é Emayusɨ kɨ́ to ɓe kɨ́ kḭ ɓebo Jorijalḛm kɔw-tɨ lé, à kasɨ kulə mɛtər dɔgɨ gidɨ-é joo je bè. ");
INSERT INTO mge_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Njéndó né-je kɨ́ joo kinlé, ꞌpa-na̰ ta dɔ né-je-tɨ lay kɨ́ ra né lé taá-taá dɔ rəbɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ə lokɨ dꞌɔw ꞌpa-na̰ ta-je lé taá-taá ꞌnajɨ-né-na̰ ta-tɨ bè-bè rəmə, Jeju ya ingə-dé ə uwə sə-dé rəbɨ natɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ngà kəm-dé ijə dɔ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jeju dəjɨ-dé panè: To ta ri ɓá ɔwi ꞌnaji-na̰-tɨ taá-taá bè wa? Ə dḛ ꞌtəl dꞌa̰ nangɨ kɨ̀ rɔkatɨ kana̰na̰. ");
INSERT INTO mge_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ngà ɓá ḛ kɨ́ káre kɨ́ ꞌɓa-é Kléopasɨ pa siə panè: ꞌDé! I ya kɨ̀ kár-i-rè ꞌto dow kɨ́ ꞌisɨ ɓebo Jorijalḛm-tɨ nè ya ə́ i ꞌpanè ꞌgə né kɨ́ ra né mḛḛ ndɔ-je-tɨ kɨ́ nè kinlé al! ");
INSERT INTO mge_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ḛ dəjɨ-dé panè: To ri ɓá ra né wa? Dḛ dꞌilə-é-tɨ ꞌpanè: To ta lə né kɨ́ tḛḛ dɔ Jeju-tɨ kɨ́ to dow kɨ́ Najarɛtɨ-tɨ kɨ́ to njèpata kɨ́ ta Lubə-tɨ, kɨ́ ḛ ɔjɨ tɔ́gɨ-é mḛḛ kullə ra-é-je-tɨ, kɨ̀ mḛḛ ta pa-é-je-tɨ takəm Lubə-tɨ rəm, takəm dow-je-tɨ lay rəm. ");
INSERT INTO mge_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ya rəmə dow-je lə-ji kɨ́ ꞌto njèkun dɔ njégugné-je lə Lubə, kɨ̀ ꞌboy-je lə-ji dꞌilə-é ji Pilatɨ-tɨ adɨ gangta koy dɔ-é-tɨ adɨ ꞌɓə-é kagdəsɨ-tɨ lé! ");
INSERT INTO mge_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jḛ jꞌində mḛḛ-ji dɔ-é-tɨ kɨ́ ḛ ɓá à taa Israyel-je kilə-dé taá; lay bin ya rəmə né-je kin ra né ɓone to ndɔ kɨ́ njèkungɨ-tɨ mutə ngá tin! ");
INSERT INTO mge_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bè ya kàrè, dené-je madɨ kɨ́ dan-ji-tɨ, ꞌree ꞌpa ta kɨ́ ɔr ndil-ji ɓəy tɔ. Dené-je lé, ꞌtḛḛ kɨ̀ ndɔge ratɨ ya dꞌɔw dɔɓadɨ-tɨ; ");
INSERT INTO mge_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngà dꞌingə nin-é al. Rəmə ꞌtəl ꞌree dꞌidə-ji ꞌpanè malayka-je ꞌtḛḛ sə-dé busɨ ə dꞌidə-dé ꞌpanè Jeju lé, isɨ kəm. ");
INSERT INTO mge_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lokɨ ꞌpa bè lé, dow-je kɨ́ ná̰-je dan-ji-tɨ dꞌḭ dꞌɔw dɔɓadɨ-tɨ ə dꞌoo né-je titɨ kɨ́ dené-je ꞌpa-né lé ya. Ngà ḛ rəmə, dḛ dꞌoo-é al. ");
INSERT INTO mge_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Beɓa Jeju idə-dé panè: Əiyəə, sə̰i dow-je kɨ́ négə lə-si goto kan! Sə̰i kɨ́ ꞌtadi ti-ti dɔ ta-je-tɨ lay kɨ́ njépata-je kɨ́ ta Lubə-tɨ ꞌpa kan! ");
INSERT INTO mge_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tò kadɨ Kristɨ lé, à kingə kɔ̰̀-je kin ɓá à kingə-né riɓa ya al wa? ");
INSERT INTO mge_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Go-tɨ, Jeju ḭ dɔ ndukun-je-tɨ lə Moiyijɨ sar tḛḛ-né dɔ mbete-je-tɨ lə njépata-je kɨ́ ta Lubə-tɨ ya ɔr-dé mḛḛ ta-je lay kɨ́ mbete kɨ́ aa njay pa sɔbɨ-né dɔ-é. ");
INSERT INTO mge_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ngà lokɨ ꞌree ꞌtḛḛ ngɔsi kɨ̀ ngonɓe kɨ́ njéndó né-je kɨ́ joo dꞌisɨ dꞌɔw-tɨ lé, Jeju ra né tokɨ dow kɨ́ ɔw kɨ̀ dəə taá bè. ");
INSERT INTO mge_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngà dḛ dꞌɔgɨ-é nangɨ ꞌpanè: «ꞌIsɨ sə-ji nè, kdɔtalə, kàdɨ̀ ɔw dɔ kur-tɨ, adɨ ndɔ kàrè ɔw kil rəm ngá. Beɓa ḛ ɔw kəy isɨ sə-dé.» ");
INSERT INTO mge_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lokɨ isɨ sə-dé ta nékuso-tɨ rəmə, un mbə̀ ra oiyo Lubə ɓá uwə gangɨ dana̰ ə adɨ-dé. ");
INSERT INTO mge_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Beɓa kəm-dé ijə yərərə adɨ ꞌgə-é ya rəmə, ḛ goto jeke dan-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ə dḛ ꞌdəjɨ-na̰ ta ꞌpanè: «Kete kɨ́ ɔw pa ta adɨ-ji dɔrəbɨ-tɨ ɔr-ji-né mḛḛ ta-je kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay lé, mḛḛ-ji ole wutɨ-wutɨ titɨ-na̰ né kɨ́ to pər ɓá ɔ̰̀-tɨ bè ya al wa?» ");
INSERT INTO mge_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Beɓa dꞌḭ tajinatɨ nè ya dꞌɔsɨ təl dꞌɔw ɓebo Jorijalḛm-tɨ gogɨ ə dꞌingə njéndó né-je kɨ́ dɔgɨ gidɨ-é káre natɨ kɨ̀ madɨ-dé-je kɨ́ ꞌkəw-na̰. ");
INSERT INTO mge_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Dḛ dꞌidə dḛ kɨ́ joo lé ꞌpanè: «Tɔgrɔ-tɨ ya, ꞌƁaɓe tɔsɨ ndəl ində lo tḛḛ ə tɔjɨ rɔ-é adɨ Simɔ̰ oo-é!» ");
INSERT INTO mge_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Beɓa njéndó né-je kɨ́ joo lé dꞌɔr poy né kɨ́ tḛḛ dɔ-dé-tɨ rebəə rəm, gə kɨ́ ꞌgə Jeju lokɨ ḛ gangɨ-né mbə̀ adɨ-dé lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lokɨ njéndó né-je kɨ́ joo lé, dꞌisɨ pa ta-je kin bè-bè ya rəmə dajɨ rɔ Jeju ya tḛḛ busɨ dan-dé-tɨ ə pa sə-dé panè: «Kadɨ lapiya nà̰y sə-si.» ");
INSERT INTO mge_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rəmə ɓəl ində bandɨ-dé batɨ gangɨ, kdɔ dḛ ꞌgɨr kɨ́ to ꞌmə̰́ dow ɓá dꞌoo-é. ");
INSERT INTO mge_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngà Jeju pa sə-dé panè: Kdɔ ri ɓá dɔ-si təl-né bè wa? Kdɔ ri ɓá mḛḛ-si ra joo bè wa? ");
INSERT INTO mge_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ooi ji-m-je kɨ̀ nja-m-je lé ə́n, to ma̰ ya; ɔdi rɔ-m ə ooi. ꞌMə̰́ dow lé, tal rɔ-é kɨ̀ singə rɔ-é goto. Ngà ma̰ lé, sə̰i ooi majɨ kɨ́ tal rɔ-m kɨ̀ singə rɔ-m tò nè. ");
INSERT INTO mge_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ḛ pa ta kin bè tɔjɨ-dé-né ji-é-je kɨ̀ nja-é-je. ");
INSERT INTO mge_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rəmə rɔ-dé nəl-dé mbing adɨ dꞌoo kɨ́ né kɨ́ tɔgrɔ-tɨ al ɓəy, ɓá ndil-dé tḛḛ sa̰y adɨ Jeju dəjɨ-dé panè: Ɔwi kɨ̀ nékuso nè nɔ̰ɔ̰ wa? ");
INSERT INTO mge_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Beɓa dꞌun dəbɨ kanjɨ kɨ́ nungə dꞌadɨ-é. ");
INSERT INTO mge_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ḛ taa ə uso takəm-dé-tɨ nè ya. ");
INSERT INTO mge_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Go-tɨ, idə-dé panè: Kɨ́ ndɔkɨ mꞌisɨ-né sə-si ɓəy lé, mꞌidə-si mꞌpanè: «Ta-je lay kɨ́ ꞌndàngɨ sɔbɨ dɔ-m mḛḛ mbete ndukun-je-tɨ lə Moiyijɨ, kɨ̀ mḛḛ mbete-je-tɨ lə njépata-je kɨ́ ta Lubə-tɨ, kɨ̀ mḛḛ mbete pa-je-tɨ lé, tò kadɨ né-é à ra né ya.» ");
INSERT INTO mge_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Beɓa ḛ tḛḛ kəm-dé adɨ ꞌgə-né mḛḛ ta-je kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay; ");
INSERT INTO mge_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ə idə-dé panè: Ooi, ta kɨ́ ꞌndàngɨ ə́n: Kristɨ à kingə kɔ̰̀, à tɔsɨ ndəl kində lo tḛḛ kɨ̀ ndɔ kɨ́ njèkungɨ-tɨ mutə; ");
INSERT INTO mge_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ə ta kɨ́ sɔbɨ dɔ kin̰ə panjiyə-je kɨ́ majɨ al kadɨ Lubə in̰ə-né go majal-je lə dow-je kɔgɨ lé, dꞌa kulə gin-é dɔ ɓebo Jorijalḛm-tɨ ya dꞌa kilə mbḛ-é kɨ̀ ri Jeju kadɨ gin dow-je lay kɨ́ dɔnangɨ-tɨ nè. ");
INSERT INTO mge_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sə̰i ya ꞌtoi njékoo né-é-je kɨ̀ kəm-si kdɔ kadɨ ꞌpai ta-é. ");
INSERT INTO mge_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ə kɨ́ sɔbɨ dɔ-m ma̰ lé, kadkare kɨ́ Bɔbɨ-m un mindɨ-é kadɨ nꞌadɨ-si lé, mꞌa kulə siə kadɨ-si. Ngà sə̰i rəmə, isi ɓebo Jorijalḛm-tɨ nè ya sar kadɨ ingəi tɔ́gɨ kɨ́ à kḭ dɔra̰-tɨ ree dɔ-si-tɨ kin ɓəy ɓane. ");
INSERT INTO mge_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Beɓa Jeju ɔr-dé ɔw sə-dé gidɨ ɓebo-tɨ ngɔsi kɨ̀ ɓe kɨ́ Betani, ɓá ɔy ji-é kɨ taá ə tɔr ndi-é dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lokɨ ḛ a̰ tɔrndi-é dɔ-dé-tɨ bè ya ɓəy rəmə, ḛ in̰ə-dé ə Lubə un-é ɔw siə dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ngà dḛ rəmə lokɨ dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀-é-tɨ lé, ꞌtəl dꞌɔw ɓebo Jorijalḛm-tɨ gogɨ kɨ̀ rɔnəl kɨ́ n̰a̰, ");
INSERT INTO mge_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ə dḛ dꞌisɨ takəy-tɨ lə Lubə kɨ̀ dɔkaglo-je lay ya ꞌtɔ́y Lubə.");
INSERT INTO mge_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lo kulə gin né-je-tɨ ya, Ta isɨ nɔ̰ɔ̰ ngá. Ta isɨ natɨ kɨ̀ Lubə ə Ta lé to Lubə. ");
INSERT INTO mge_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ta isɨ natɨ kɨ̀ Lubə lo kulə gin né-je-tɨ nṵ. ");
INSERT INTO mge_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lubə ra né-je lay kɨ̀ takul Ta ə né kɨ́ ḛ ra kɨ̀ takul Ta al ya goto. ");
INSERT INTO mge_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ə mḛḛ Ta-tɨ kinlé ɓá kiskəm tò-tɨ ə kiskəm to londógɨ lə dow-je. ");
INSERT INTO mge_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lo kɨ́ ndógɨ ndógɨ londul-tɨ, ngà londul ɓá uwə-é kɨ rɔ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Lubə ulə dow káre kɨ́ ri-é lə Ja̰. ");
INSERT INTO mge_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja̰ lé to njékoo né ə kidə dow-je ta kɨ́ dɔ-tɨ; adɨ ḛ ree kadɨ nꞌpa ta kɨ́ dɔ lo kɨ́ ndógɨ-tɨ, kdɔ kadɨ dow-je lay ya dꞌadɨ mḛḛ-dé kɨ̀ takul nꞌḛ̀. ");
INSERT INTO mge_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ḛ ɓá to lo kɨ́ ndógɨ lé al, ngà ḛ ree kdɔ pa ta kɨ́ dɔ-tɨ kadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Londógɨ kɨ́ tɔgrɔ-tɨ lé ree dɔnangɨ-tɨ ə ndógɨ adɨ dow-je lay dꞌoo-né lo. ");
INSERT INTO mge_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lubə ra dɔnangɨ kɨ̀ takul Ta ə Ta lé ree dɔnangɨ-tɨ nè; rəmə dow-je kɨ́ dɔnangɨ-tɨ ꞌgə-é al. ");
INSERT INTO mge_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ḛ ree rɔ dow-je-tɨ liə ya rəmə, ꞌmbatɨ kuwə-é kɨ rɔ-dé-tɨ; ");
INSERT INTO mge_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ngà dḛ lay kɨ́ dꞌuwə-é kɨ rɔ-dé-tɨ ə dꞌadɨ-é mḛḛ-dé lé, ḛ adɨ-dé tarəbɨ kadɨ ꞌtəl ngan lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Dḛ lé ꞌto ngan lə Lubə kɨ́ Lubə ya ojɨ-dé, ɓɨ kojɨ kinlé to kojɨ kɨ́ dow ɓá ojɨ-dé al, ɓá to ndigɨ lə dow al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta lé, təl rɔ-é dow-tɨ ə ra ɓe dan-ji-tɨ rəm, to njèra majɨ n̰a̰ rəm, to njèta kɨ́ tɔgrɔ-tɨ rəm tɔ. Jꞌoo né riɓa liə, kɨ́ to riɓa kɨ́ ḛ ingə kdɔ to kɨ́ to Ngon kàl kɨ́ ḭ rɔ Bɔbɨ-é-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja̰ pa ta kɨ́ dɔ-é-tɨ adɨ dow-je ə pa kɨ̀ ndi-é kɨ́ boy panè: «To ḛ kinlé ɓá mꞌpa ta kɨ́ dɔ-é-tɨ mꞌpanè: Ḛ kɨ́ njèree go-m-tɨ lé to dow kɨ́ ꞌboy itə-m, kdɔ ḛ to dow kɨ́ kete nɔ̰̀-m-tɨ.» ");
INSERT INTO mge_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ə jə̰i lay ya ramajɨ liə kɨ́ al dɔ lo kinlé nduy dɔ-ji pitɨm, ɓá jꞌubəi majɨ-é kɨ kete-kete rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kdɔtalə Lubə adɨ ndukun kɨ̀ kəm rəbɨ kɨ́ rɔ Moiyijɨ-tɨ ə ramajɨ, kɨ̀ ta kɨ́ tɔgrɔ-tɨ ɓá ree kɨ̀ kəm rəbɨ kɨ́ rɔ Jeju Kristɨ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lubə lé, dow oo-é nja káre al; ngà Ngon kàl kɨ́ to Lubə, njèkisɨ mbɔ́ Bɔbɨ-é-tɨ lé ya ɓá adɨ kəm dow-je ijə dɔ Bɔbɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ndɔ káre bè, jipɨ-je dꞌulə njégugné-je lə Lubə, kɨ̀ dow-je kɨ́ gin kojɨ-tɨ lə Lebi kɨ́ ꞌto njéra sə-dé dɔ kullə-tɨ, adɨ dꞌḭ ɓebo Jorijalḛm-tɨ ꞌree ꞌdəjɨ ta Ja̰ ꞌpanè: I lé, ꞌto ná̰ wa? Beɓa Ja̰ pa ta kɨ́ dɔ né-tɨ kɨ́ ḛ oo. ");
INSERT INTO mge_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Lokɨ ꞌdəjɨ-é ta kin bè lé, ḛ najɨ al ya idə-dé rəsɨ panè: Ma̰ mꞌto Kristɨ al. ");
INSERT INTO mge_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dḛ ꞌtəl ꞌdəjɨ-é ꞌpanè: Ngà i ꞌto ná̰ wa? Sé i ꞌto Eli wa? Ḛ ilə-dé-tɨ panè: Mꞌto Eli al. Dow kɨ́ jꞌisɨ jꞌngəbɨ-é kɨ́ to njèpata kɨ́ ta Lubə-tɨ lé, sé to i wa? Ḛ ilə-dé-tɨ panè: Ma̰ mꞌto dowbé kinlé al. ");
INSERT INTO mge_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Rəmə ꞌtəl ꞌdəjɨ-é ya ɓəy ꞌpanè: Ngà i lé ꞌto ná̰ ya wa? I ya ꞌidə-ji ta kɨ́ dɔ-i-tɨ kadɨ jꞌɔw jꞌidə njékulə-ji-je lé ɓane. ");
INSERT INTO mge_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ḛ panè: Titɨ kɨ́ Ejay njèpata kɨ́ ta Lubə-tɨ pa-né lé, ma̰ mꞌto dow kɨ́ ndi-é ɓa diləlo-tɨ panè: ꞌRai rəbɨ lə ꞌƁaɓe adi a̰ njururu-njururu. ");
INSERT INTO mge_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dow-je kɨ́ dꞌulə-dé rɔ Ja̰-tɨ lé ꞌto Parisi-je. ");
INSERT INTO mge_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ja̰ a̰ ra dow-je batḛm ɓá dḛ ꞌdəjɨ-é ꞌpanè: Kinə i ꞌto Kristɨ lé al rəm, ꞌto Eli al rəm, ɓá ꞌto njèpata kɨ́ ta Lubə-tɨ lé al rəm, ngà kdɔ ri ɓá ꞌra dow-je batḛm wa? ");
INSERT INTO mge_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ja̰ ilə-dé-tɨ panè: Ma̰ mꞌra dow-je batḛm mani; ngà dow káre isɨ dan-si-tɨ nɔ̰ɔ̰ ya ə́ sə̰i ꞌgəi-é al. ");
INSERT INTO mge_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dowbé lé à ree go-m-tɨ nɔ̰ɔ̰. Ə ma̰ kinlé kulə saba liə ya kàrè mꞌtuwə kadɨ mꞌtutɨ al. ");
INSERT INTO mge_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ta-je kinlé dḛ ꞌpa kɨ̀ na̰ mḛḛ ɓe-tɨ kɨ́ Betani, ta ba Jurdḛ-tɨ kəl-é-tɨ kɨ́ lokubə kàdɨ̀-tɨ kɨ́ Ja̰ ra dow-je batḛm-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lo aa go-tɨ, Ja̰ oo Jeju ɔw ree rɔ-é-tɨ ə panè: Ooi, Ngonbatɨ lə Lubə kɨ́ njèkɔr majal dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ lé ə́ ɔw ree ɔngɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","To ḛ kɨ́ ɔw ree kɔngɨ lé ɓá mꞌpa ta kɨ́ dɔ-é-tɨ mꞌpanè: Ḛ kɨ́ njèree go-m-tɨ lé to dow kɨ́ ꞌboy itə-m, kdɔ ḛ to dow kɨ́ kete nɔ̰̀-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ə ma̰ kàrè kete mꞌgə-é al, ngà mꞌree mꞌra dow-je batḛm mani bè kdɔ kadɨ Israyel-je ꞌgə-é-né tɔ. ");
INSERT INTO mge_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja̰ oo né ə pa ta dɔ-tɨ rəsɨ panè: Mꞌoo Ndil kɨ́ aa njay ḭ dɔra̰-tɨ ree titɨ-na̰ kɨ̀ dəngɔdnda bè ree isɨ dɔ Jeju-tɨ; ");
INSERT INTO mge_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ə ma̰ mꞌgə-é al, ngà njèkulə-m kadɨ mꞌra dow-je batḛm mani lé ɓá idə-m panè: Ḛ kɨ́ Ndil kɨ́ aa njay à kḭ dɔra̰-tɨ ree kisɨ dɔ-é-tɨ kadɨ ꞌoo-é kinlé, ḛ ɓá à ra dow-je batḛm kɨ̀ Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma̰ mꞌoo né-é kɨ̀ kəm-m, ɓá mꞌpanè: Ḛ kɨ́ ɔw kɔngɨ lé ɓá to Ngon lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lo aa go-tɨ kàrè, Ja̰ kɨ̀ dow-je joo dan njéndó né-je-tɨ liə dꞌisɨ lo-é-tɨ kinlé ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Beɓa lokɨ oo Jeju ɔw dəə lé ḛ panè: Ooi, Ngonbatɨ lə Lubə lé ə́ ɔw ɔngɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lokɨ njéndó né-je kɨ́ joo kin dꞌoo ta-je kinlé bè rəmə, dḛ dꞌḭ dꞌun go Jeju. ");
INSERT INTO mge_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jeju təl kəm-é ə oo-dé go-é-tɨ rəmə dəjɨ-dé panè: Ri ɓá ꞌsangi wa? Dḛ ꞌɓa-é: Rabi adɨ kɔr mḛḛ-é to njèndó dow-je né ə ꞌdəjɨ-é ꞌpanè: I ꞌisɨ rá wa? ");
INSERT INTO mge_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jeju ilə-dé-tɨ panè: ꞌReei ə a kooi. À to kàdɨ̀ kɨ́ sɔ kɨ́ losɔlɔ je bè. Beɓa dḛ dꞌɔw dꞌoo lo kisɨ-é ə dꞌisɨ rɔ-é-tɨ ndɔ-é-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Dingəm-je kɨ́ joo kɨ́ dꞌoo ta-je lə Ja̰ ə dꞌun go Jeju lé, ḛ káre to Andre kɨ́ ngonkɔ̰ Simɔ̰ Piyər. ");
INSERT INTO mge_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ḛ ɔw ingə ngonkɔ̰-é Simɔ̰ lé ya kete idə-é panè: Jꞌingə «Mesi» – kɔr mḛḛ-é to Kristɨ (dow kɨ́ Lubə mbətɨ-é). ");
INSERT INTO mge_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Go-tɨ, ɔw kɨ̀ Simɔ̰ lé rɔ Jeju-tɨ. Beɓa Jeju oo-é ya rəmə panè: I ꞌto Simɔ̰ kɨ́ ngon lə Jonasɨ. Dꞌa ɓa-i Sepasɨ (kɔr mḛḛ-é to ər). ");
INSERT INTO mge_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lo aa go-tɨ, lokɨ Jeju ɔjɨ kadɨ nꞌɔw dɔnangɨ Galile-tɨ lé ḛ ingə dow káre kɨ́ ri-é lə Pilipɨ ə idə-é panè: ꞌUn go-m. ");
INSERT INTO mge_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipɨ dḛ kɨ̀ Andre, kɨ̀ Piyər lé ꞌto dow-je kɨ́ ɓebo Betsayda-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Go-tɨ, Pilipɨ ingə dow káre kɨ́ ri-é lə Nataniyel ə idə-é panè: Dow kɨ́ ndukun lə Moiyijɨ, kɨ̀ mbete-je lə njépata-je kɨ́ ta Lubə-tɨ ꞌpa ta liə lé jꞌingə-é; to Jeju kɨ́ Najarɛtɨ-tɨ, ngon lə Jojepɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel idə Pilipɨ lé panè: Né kɨ́ majɨ à kḭ mḛḛ ɓe-tɨ kɨ́ Najarɛtɨ tɔ ɓan wa? ");
INSERT INTO mge_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Rəmə Pilipɨ təl idə-é panè: ꞌRee ꞌoo. Lokɨ Jeju oo kɨ́ Nataniyel isɨ ree rɔ-é-tɨ lé, ḛ pa ta kɨ́ dɔ-é-tɨ panè: Ooi, Israyel kɨ́ tɔgrɔ-tɨ kɨ́ kədkəm dow-je goto rɔ-é-tɨ ə́ ɔw ree ɔngɨ. ");
INSERT INTO mge_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ə Nataniyel dəjɨ-é panè: I ꞌgə-m rá wa? Jeju ilə-é-tɨ panè: Lokɨ ꞌa̰-né gin kote-tɨ kin ya mꞌoo-i pá ɓá Pilipɨ ɓa-i ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel təl ilə-é-tɨ panè: Njèndó dow-je né, i lé ꞌto Ngon lə Lubə rəm, ɓá ꞌto ngar lə Israyel-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Beɓa Jeju idə-é panè: Kidə kɨ́ mꞌidə-i mꞌpanè mꞌoo-i gin kote-tɨ kin ɓá i adɨ-m-né mḛḛ-i tin! Né-je kɨ́ tò ɓəl itə né-je kin ya ꞌa koo ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ooi majɨ, mꞌa kidə-si rəsɨ; a kooi ta dɔra̰ kɨ́ tḛḛ ə a kooi malayka-je lə Lubə kɨ́ dꞌa kḭ dɔ Ngon lə dow-tɨ kdɔ kɔw dɔra̰-tɨ rəm, ɓá dꞌa kḭ dɔra̰-tɨ təl ree dɔ-é-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ndɔ joo go-tɨ, taana̰ tò mḛḛ ɓe-tɨ kɨ́ Kana̰ dɔnangɨ Galile-tɨ. Kɔ̰ Jeju a̰ lo-é-tɨ nɔ̰ɔ̰ rəm, ");
INSERT INTO mge_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ɓá Jeju kɨ̀ njéndó né-je liə kàrè ꞌɓa-dé lo-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yibɨ nduu tingə, rəmə kɔ̰ Jeju idə-é panè: «Yibɨ nduu goto ngá.» ");
INSERT INTO mge_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jeju ilə-é-tɨ panè: «Dené, ta ri lə-ji jḛ sə̰i wa?» Dɔkàdɨ̀ lə-m asɨ al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kɔ̰-é idə njérakullə-je panè: «Né lay kɨ́ à kidə-si ya ꞌrai.» ");
INSERT INTO mge_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lo-é-tɨ nɔ̰ɔ̰ lé, jo ər kɨ́ boy-boy mɛkḛ tò-tɨ ə jo káre ya à kun man litɨr ɓu-je bè ə to jo-je kɨ́ man tò-tɨ kdɔ kadɨ jipɨ-je ꞌtogɨ-né rɔ-dé kadɨ dꞌaa njay takəm Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jeju idə-dé panè: «Ungi man rusɨ jo-je kinlé. Rəmə dꞌungɨ man-tɨ adɨ rusɨ tḛnḛnḛ-tḛnḛnḛ.» ");
INSERT INTO mge_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Təl idə-dé panè: «Ɔdi ɔwi-né adi njèkoo go nékuso» ə dḛ dꞌɔdɨ dꞌɔw-né dꞌadɨ-é ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lokɨ njèkoo go nékuso na̰ man kɨ́ ꞌtəl-é yibɨ nduu-tɨ lé rəmə, ḛ gə lo kɨ́ ḭ-tɨ al, ngà njérakullə-je kɨ́ dꞌɔdɨ man lé ɓá ꞌgə majɨ. ");
INSERT INTO mge_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Njèkoo go nékuso ɓa njètaa dené lé ə panè: Dow-je lay lé, yibɨ nduu kɨ́ majɨ ɓá ꞌləbɨ kete-kete ə ḛ kɨ́ majɨ n̰a̰ al ɓá dꞌin̰ə gogɨ adɨ yibɨ ra dow-je ɓá ꞌləbɨ ɓəy. Ngà i rəmə, yibɨ nduu kɨ́ majɨ ɓá i in̰ə gogɨ sar ngɔsnè ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nékɔjɨ-je kɨ́ Jeju ra lé, ḛ kin ɓá to kɨ́ dɔsa̰y. Ḛ ra mḛḛ ɓe-tɨ Kana̰, dɔnangɨ Galile-tɨ tɔjɨ-né tɔ́gɨ-é ndaa-tɨ rəsɨ ə njéndó né-je liə dꞌadɨ-é mḛḛ-dé. ");
INSERT INTO mge_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Go né-je-tɨ kinlé, Jeju ɔw mḛḛ ɓe-tɨ kɨ́ Kapɛrnayim natɨ kɨ̀ kɔ̰-é-je kɨ̀ ngankɔ̰-é-je, kɨ̀ njéndó né-je liə, ngà kisɨ ɓá dꞌisɨ-tɨ ndɔ n̰a̰ al. ");
INSERT INTO mge_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lokɨ ndɔ ra na̰y Pakɨ lə jipɨ-je nà̰y ngɔsi lé, Jeju ɔw mḛḛ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ə ɔw takəy-tɨ lə Lubə rəmə, ingə njéra gatɨ batɨ-je, kɨ̀ mangɨ-je, kɨ̀ də-je kɨ̀ njémbəl-na̰ là-je. ");
INSERT INTO mge_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Beɓa Jeju pətɨ kulə ndəy-tɨ tubə-né dow-je kin lay takəy-tɨ lə Lubə ə tubə-né batɨ-je, kɨ̀ mangɨ-je, ɓá sane ka̰ là lə njémbəl-na̰ là-je ə titə tablə-je lə-dé tilə. ");
INSERT INTO mge_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ə idə njéra gatɨ də-je panè: «ꞌSaai né-je kin rangɨ lo kin-tɨ. Kəy lə Bɔbɨ-m lé, ꞌrai-é kɨ kəy ra gatɨ al!» ");
INSERT INTO mge_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mḛḛ njéndó né-je ole dɔ ta-tɨ kɨ́ mbete kɨ́ aa njay pa panè: «Kəy lə-i lé ta-é ɔ̰̀ mḛḛ-m tokɨ pər bè.» ");
INSERT INTO mge_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Beɓa jipɨ-je ꞌpa siə ꞌpanè: «Nékɔjɨ ri ɓá ꞌa ra kadɨ jꞌoo ɓá jꞌa gə-né kɨ́ to tó-é kadɨ i ꞌra-né né kinlé bè wa?» ");
INSERT INTO mge_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jeju təl ilə-dé-tɨ panè: «ꞌTɔɔi kəy lə Lubə kin ə ndɔ mutə ya ma̰ kində gogɨ lay.» ");
INSERT INTO mge_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jipɨ-je lé dꞌidə-é ꞌpanè: «Kəy lə Lubə kin kɨ́ jꞌində ɓal kɔrsɔ gidɨ-é mɛkḛ lé ya i kan ɓá ꞌpanè ndɔ mutə-rè ya ꞌa kində gogɨ lay!» ");
INSERT INTO mge_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngà ḛ lé, ḛ pa ta lə kəy lə Lubə kɨ́ to dajɨ rɔ-é ḛ ya. ");
INSERT INTO mge_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ndɔ kɨ́ Jeju tɔsɨ ndəl ində lo tḛḛ ngá ɓá mḛḛ njéndó né-je liə ole dɔ ta-tɨ kinlé ə dḛ dꞌadɨ mḛḛ-dé mbete kɨ́ aa njay rəm, dꞌadɨ mḛḛ-dé ta kɨ́ Jeju pa lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mḛḛ ndɔ-je-tɨ kɨ́ Jeju a̰-né lo ra na̰y Pakɨ-tɨ mḛḛ ɓebo Jorijalḛm-tɨ kinlé, dow-je n̰a̰ ya dꞌadɨ-é mḛḛ-dé kdɔ koo kɨ́ dꞌoo nékɔjɨ-je kɨ́ ḛ ra ra. ");
INSERT INTO mge_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngà Jeju nda mḛḛ-é rɔ-dé-tɨ al, kdɔ ḛ gə mḛḛ dow-je lay. ");
INSERT INTO mge_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ḛ ɔw ndoo kadɨ dow madɨ pa ta kɨ́ dɔ dow-tɨ adɨ-é al ngá, kdɔ ḛ gə ta kɨ́ mḛḛ dow-je-tɨ lay. ");
INSERT INTO mge_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngà dow káre dan Parisi-je-tɨ kɨ́ to káre dan ꞌboy-je-tɨ lə jipɨ-je kɨ́ ri-é lə Nikodḛm ");
INSERT INTO mge_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ree rɔ Jeju-tɨ ndɔɔ idə-é panè: Njèndó dow-je né, jḛ jꞌgə kɨ́ i lé, ꞌto njèndó dow-je né kɨ́ Lubə ya ulə-i; kdɔtalə dow kɨ́ Lubə nà̰y siə al lé, à kasɨ ra nékɔjɨ-je kɨ́ i ꞌra ꞌra kin al. ");
INSERT INTO mge_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jeju ilə-é-tɨ panè: «ꞌOo majɨ, mꞌa kidə-i rəsɨ; dow kɨ́ dꞌojɨ-é sigɨ al lé, à kasɨ koo kɔ̰ɓe lə Lubə al.» ");
INSERT INTO mge_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Rəmə Nikodḛm dəjɨ-é panè: Dow ɓugə ngá lé, dꞌa təl kojɨ-é sigɨ ban ɓəy wa? Se à təl kur mḛḛ kɔ̰-é-tɨ gogɨ kadɨ dꞌojɨ-é nja joo ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jeju təl idə-é panè: «ꞌOo majɨ, mꞌa kidə-i rəsɨ; kinə dꞌojɨ dow kɨ̀ kəm rəbɨ lə man al rəm, kɨ̀ kəm rəbɨ lə Ndil kɨ́ aa njay rəm al lé, dowbé à kɔw kɔ̰ɓe-tɨ lə Lubə al. ");
INSERT INTO mge_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dow kɨ́ dow ɓá ojɨ-é lé, rɔ-é to dow ya tɔ; ngà dow kɨ́ Ndil ɓá ojɨ-é lé to ndil ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta kɨ́ mꞌidə-i mꞌpanè: “Dꞌa təl kojɨ-si sigɨ gogɨ ɓane kinlé, adɨ ɔr ndil-i al.” ");
INSERT INTO mge_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yə́l lé, lo kɨ́ ndigɨ kulə-tɨ ya ḛ ulə-tɨ ə i ꞌoo ká-é, ngà i ꞌgə lo kɨ́ ḭ-tɨ al rəm, ɓá ꞌgə lo kɨ́ isɨ ɔw-tɨ al rəm tɔ. Dow kɨ́ Ndil ojɨ-é lé, to bè ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Rəmə Nikodḛm təl dəjɨ-é ya ɓəy panè: «Né-é kinlé, à ra né ban-ban wa?» ");
INSERT INTO mge_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Beɓa Jeju təl ilə-é-tɨ panè: «I kɨ́ ꞌto njèndó dow-je né dɔnangɨ Israyel-tɨ lé ya ꞌgə né kin al ɓəy wa! ");
INSERT INTO mge_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ꞌOo majɨ, mꞌa kidə-i rəsɨ; né kɨ́ jꞌgə ɓá jꞌpa ta dɔ-tɨ, ə né kɨ́ jꞌoo kɨ̀ kəm-ji ɓá jꞌpa ta dɔ-tɨ, ngà sə̰i ooi ta lə-ji adi to ta kɨ́ tɔgrɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Né-je kɨ́ dɔnangɨ-tɨ nè ya mꞌpa-né sə-si ta ə sə̰i adi mḛḛ-si al bè lé, lokɨ mꞌa pa sə-si ta dɔ né-je-tɨ kɨ́ dɔra̰-tɨ lé, a kadi mḛḛ-si ban wa? ");
INSERT INTO mge_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Dow kɨ́ ɔw dɔra̰-tɨ goto, ngà Ngon lə dow kɨ́ ḭ dɔra̰-tɨ ree dɔnangɨ-tɨ kin ya káre. ");
INSERT INTO mge_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Titɨ kɨ́ ndɔkɨ Moiyijɨ lḛ-né ꞌningə́kasɨ adɨ to li ə un taá diləlo-tɨ lé, Ngon lə dow kàrè dꞌa kun-é taá bè ya tɔ ɓane, ");
INSERT INTO mge_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kdɔ kadɨ dow kɨ́ rá-rá kɨ́ adɨ-é mḛḛ-é rəmə, isɨ kəm ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kdɔ Lubə ndigɨ dow-je kɨ́ dɔnangɨ-tɨ nè n̰a̰, ɓá adɨ-dé-né ngon kàl liə, kdɔ kadɨ dow kɨ́ rá-rá kɨ́ adɨ-é mḛḛ-é rəmə oy al, ngà kadɨ isɨ kəm ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kdɔ Lubə ulə Ngon-é dɔnangɨ-tɨ kdɔ kadɨ-é gangta dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ al, ngà kadɨ dow-je kɨ́ dɔnangɨ-tɨ nè dꞌajɨ kɨ̀ takul-é. ");
INSERT INTO mge_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dow kɨ́ adɨ-é mḛḛ-é lé, ta kɨ́ gangɨ ɔr dɔ-é-tɨ; ngà dow kɨ́ adɨ-é mḛḛ-é al rəmə, ꞌgangɨ ta dɔ-é-tɨ ngá; kdɔtalə ḛ adɨ mḛḛ-é Ngon kàl lə Lubə al. ");
INSERT INTO mge_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gin ta kɨ́ gangɨ lé ə́n: Lo kɨ́ ndógɨ ree dɔnangɨ-tɨ rəmə, londul ɓá dow-je ꞌndigɨ ɓɨ ꞌndigɨ lo kɨ́ ndógɨ lé al; kdɔtalə kullə ra-dé-je majɨ al. ");
INSERT INTO mge_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kdɔ dow kɨ́ to njèra majal lé, à kɔsɨ ta lo kɨ́ ndógɨ rəm, à kɔw lo kɨ́ ndógɨ-tɨ al rəm; ḛ à ɓəl panè, lo à ndógɨ dɔ kullə ra-nꞌḛ̀-je-tɨ kɨ́ majɨ al kin kadɨ dow-je dꞌoo. ");
INSERT INTO mge_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngà dow kɨ́ njèra né kɨ́ tɔgrɔ-tɨ lé, ḛ à ka̰ lo kɨ́ ndógɨ-tɨ, kdɔ kadɨ lo ndógɨ dɔ kullə ra-é-je-tɨ kɨ́ majɨ lé kadɨ dow-je dꞌoo, kdɔ to kullə-je kɨ́ nəl Lubə.» ");
INSERT INTO mge_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Go-tɨ, Jeju dḛ kɨ̀ njéndó né-je liə dꞌɔw natɨ dɔnangɨ Jude-tɨ; ḛ isɨ sə-dé nɔ̰ɔ̰ rəm, ɓá ra dow-je batḛm rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja̰ kàrè ra dow-je batḛm Enɔ̰ kɨ́ tò ngɔsi kɨ̀ lo kɨ́ Salim-tɨ tɔ; kdɔtalə to lo kɨ́ man n̰a̰-tɨ; dow-je n̰a̰ dꞌɔw rɔ-é-tɨ adɨ ra-dé batḛm. ");
INSERT INTO mge_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kdɔ kaglo-é-tɨ kinlé, dꞌilə Ja̰ dangay-tɨ al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngà njéndó né-je lə Ja̰, dḛ kɨ̀ jipɨ káre ꞌnajɨ-na̰ ta kɨ́ sɔbɨ dɔ kəm rəbɨ togɨ rɔ kdɔ kaa rɔ dɔ majal-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Go-tɨ, njéndó né-je lə Ja̰ dꞌɔw rɔ Ja̰-tɨ dꞌidə-é ꞌpanè: Njèndó dow-je né, ꞌoo, dow kɨ́ ndɔkɨ a̰ rɔ-i-tɨ gidɨ ba jurdḛ-tɨ kɨ́ i ꞌpa ta kɨ́ dɔ-é-tɨ adɨ-ji lé, ḛ kàrè a̰ ra dow-je batḛm tɔ; adɨ dow-je lay ya dꞌɔw rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Beɓa Ja̰ idə-dé panè: Kinə Lubə adɨ né dow al lé, né kɨ́ dow à kingə kɨ̀ dɔ rɔ-é ya goto. ");
INSERT INTO mge_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","«Ma̰ ɓá mꞌto Kristɨ lé al, ngà Lubə ulə-m kete nɔ̰̀ dowbé-tɨ.» Ta kinlé, mꞌpa mꞌadɨ sə̰i ya ooi kɨ̀ mbi-si. ");
INSERT INTO mge_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Njètaa dené lé, ḛ ya to ngɔw dené; ngà nam ngɔw dené lé, ḛ a̰ mbɔ́-é-tɨ nè, a̰ oo ndi-é; lokɨ oo ndi nam-é lé, rɔ-é nəl-é n̰a̰; ma̰ kàrè rɔ-m nəl-m bè ya tɔ ə to rɔnəl kɨ́ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jeju lé ɓá tò kadɨ ɔw kɨ kete-kete ə ma̰ tá jè mꞌtəl kɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Njèkḭ dɔra̰-tɨ lé, ḛ ya ɔ̰̀ ɓe dɔ né-je-tɨ lay. Dow kɨ́ dɔnangɨ-tɨ nè lé, ḛ to ꞌlə dɔnangɨ adɨ ḛ pa ta titɨ kɨ́ ḛ to-né dow kɨ́ dɔnangɨ-tɨ nè tɔ. Njèkḭ dɔra̰-tɨ lé, ḛ ya ɔ̰̀ ɓe dɔ né-je-tɨ lay, ");
INSERT INTO mge_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ḛ pa ta dɔ né-je-tɨ kɨ́ oo kɨ̀ kəm-é rəm, ta-je-tɨ kɨ́ oo kɨ̀ mbi-é rəm, ngà dow kɨ́ oo ta liə adɨ to ta kɨ́ tɔgrɔ-tɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Beɓa dow kɨ́ oo ta liə kɨ́ ta kɨ́ tɔgrɔ-tɨ rəmə, dowbé gə kɨ́ Lubə to njèpata kɨ́ tɔgrɔ-tɨ; ");
INSERT INTO mge_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","kdɔtalə dow kɨ́ Lubə ulə-é lé, ḛ pa ta-je kɨ́ ta Lubə-tɨ, kdɔ Lubə adɨ Ndil-é rusɨ mḛḛ-é. ");
INSERT INTO mge_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lubə kɨ́ Bɔbɨ ndigɨ Ngon-é adɨ in̰ə né-je lay mḛḛ ji-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dow kɨ́ adɨ mḛḛ-é Ngon lə Lubə lé, isɨ kəm ya sartagangɨ. Dow kɨ́ təl rɔ-é go ta-tɨ lə Ngon al lé, à kisɨ kəm nda̰ al, ngà wɔngɨ à ra Lubə dɔ-é-tɨ bè-bè ya. ");
INSERT INTO mge_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jeju gə kɨ́ dow-je dꞌidə Parisi-je ꞌpanè nꞌɔw kɨ̀ njéndó né-je n̰a̰ nꞌitə Ja̰ rəm, ɓá nꞌra-dé batḛm n̰a̰ nꞌitə-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kɨ́ tɔgrɔ-tɨ lé, Jeju ya kɨ̀ dɔ-é ra dow-je batḛm al; ngà to njéndó né-je liə ɓá ꞌra dow-je batḛm. ");
INSERT INTO mge_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Lokɨ Jeju oo ta kin bè lé, ḛ in̰ə dɔnangɨ Jude təl isɨ ɔw dɔnangɨ Galile-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ə tò kadɨ à kində dɔnangɨ Samari gangɨ ɓá à kɔw. ");
INSERT INTO mge_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Beɓa ḛ ree tḛḛ mḛḛ ɓebo-tɨ káre kɨ́ ꞌɓa-é Sikar, dɔnangɨ Samari-tɨ; Sikar lé tò ngɔsi kɨ̀ londɔr kɨ́ ndɔkɨ Jakobɨ adɨ ngon-é Jojepɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Lo-é kin ɓá bole man lə Jakobɨ tò-tɨ. Kɔ rəbɨ ra Jeju adɨ isɨ nangɨ ta bole man-tɨ lé ə à to ta kɨ́ kàdɨ̀ à ka̰ jam dɔ ɓe-tɨ-je bè. ");
INSERT INTO mge_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Dené káre kɨ́ dɔnangɨ Samari-tɨ ree kdɔ kɔdɨ man ə Jeju dəjɨ-é panè: «ꞌAdɨ-m man mꞌa̰y sə-i.» ");
INSERT INTO mge_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ə njéndó né-je liə rəmə dꞌɔw mḛḛ ɓebo-tɨ kdɔ sangɨ nékuso. ");
INSERT INTO mge_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Dené kɨ́ Samari lé idə Jeju panè: «Ban ɓá i kɨ́ ꞌto jipɨ ya ꞌdəjɨ-m man ka̰y ma̰ kɨ́ mꞌto dené kɨ́ Samari bè wa?» Ḛ pa bè kdɔ jipɨ-je lé ꞌndigɨ kadɨ dḛ kɨ̀ dow-je kɨ̀ Samari dꞌuwə-na̰ nojɨ al. ");
INSERT INTO mge_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeju ilə-é-tɨ panè: «Kinə ꞌgə kadkare lə Lubə rəm, ꞌgə dow kɨ́ a̰ pa sə-i ta panè: ꞌAdɨ-m man mꞌa̰y kinlé rəm, rəmə lé i ɓá ꞌa dəjɨ-é man ka̰y ə ḛ à kadɨ-i man kiskəm.» ");
INSERT INTO mge_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Beɓa dené lé idə-é panè: «ꞌƁaɓe, bole lé uu n̰a̰ rəm, ɓá i ꞌɔw kɨ̀ kuləman al rəm, ngà ꞌa kḭ kɨ̀ man kiskəm lé rá wa? ");
INSERT INTO mge_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Se i ꞌoo rɔ-i kɨ dow kɨ́ boy itə ka-ji Jakobɨ wa? Ḛ ɓá adɨ-ji bole man kin ə ḛ ya kɨ̀ dɔ-é a̰y man-é rəm, ɓá ngan-é-je kɨ̀ nékul-je liə kàrè dꞌa̰y rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jeju ilə-é-tɨ panè: «Dow kɨ́ rá-rá kɨ́ a̰y man kinlé kundə à ra-é gogɨ ɓəy; ");
INSERT INTO mge_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ngà dow kɨ́ a̰y man kɨ́ mꞌa kadɨ-é lé, kundə à ra-é gogɨ nda̰ al ə man kɨ́ mꞌa kadɨ-é lé à təl man kḛnḛnḛ kɨ́ à ka̰y mḛḛ-é-tɨ bul-bul kdɔ kiskəm kɨ́ sartagangɨ.» ");
INSERT INTO mge_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Beɓa dené lé idə-é panè: «ꞌƁaɓe, ꞌadɨ-m man-é kinlé, kdɔ kadɨ kundə ra-m gogɨ al ya sar rəm, ɓá kadɨ mꞌtəl mꞌree lo kin-tɨ mꞌɔdɨ man gogɨ al ya sar rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jeju idə-é panè: «ꞌƆw ꞌɓa ngɔbɨ-i ə ꞌtəl ꞌree.» ");
INSERT INTO mge_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dené lé ilə-é-tɨ panè: Mꞌto njèngɔw al. Jeju idə-é panè: To tó-é kadɨ ꞌpanè: «Mꞌto njèngɔw al.» ");
INSERT INTO mge_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kdɔ ꞌtaa ngɔw gin mḭ ə ḛ kɨ́ isɨ siə ɓone bè kinlé to ngɔbɨ-i al. Adɨ ta kɨ́ ꞌpa lé to tó-é ya. ");
INSERT INTO mge_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dené lé idə-é panè: «ꞌƁaɓe, ma̰ mꞌgə kɨ́ i lé ꞌto njèpata kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka-ji-je dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀ Lubə-tɨ dɔ mbal-tɨ kin, rəmə sə̰i ꞌpainè dow-je dꞌa kɔsɨ dɔ-dé nangɨ nɔ̰̀ Lubə-tɨ mḛḛ ɓebo Jorijalḛm-tɨ.» ");
INSERT INTO mge_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jeju ilə-é-tɨ panè: «Dené, ta kɨ́ mꞌɔw kɨ̀ kidə-i kinlé, ꞌoo kɨ ta kɨ́ tɔgrɔ-tɨ. Ndɔ madɨ à ree nɔ̰ɔ̰ lé, à to dɔ mbal-tɨ kin ɓá a kɔsi dɔ-si nangɨ nɔ̰̀ Bɔbɨ-ji Lubə-tɨ al rəm, ɓá à to mḛḛ ɓebo Jorijalḛm-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Sə̰i ɔsi dɔ-si nangɨ nɔ̰̀ né-tɨ kɨ́ sə̰i ꞌgəi al, ngà jḛ lé, jḛ jꞌɔsɨ dɔ-ji nangɨ nɔ̰̀ né-tɨ kɨ́ jꞌgə, kdɔ kajɨ ḭ rɔ jipɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngà dɔkaglo-é à ree – ə ree rəm ngá – adɨ njékɔsɨ dɔ-dé nangɨ-je kɨ́ tɔgrɔ-tɨ dꞌa kɔsɨ dɔ-dé nangɨ nɔ̰̀ Bɔbɨ-ji-tɨ mḛḛ ndil-tɨ, kɨ̀ mḛḛ ta kɨ́ tɔgrɔ-tɨ, kdɔ njékɔsɨ dɔ-dé nangɨ-je kɨ́ bè kin ɓá Bɔbɨ-m ge-dé. ");
INSERT INTO mge_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Lubə to ndil, adɨ njékɔsɨ dɔ-dé nangɨ nɔ̰̀-é-tɨ-je dꞌa kɔsɨ dɔ-dé nangɨ mḛḛ ndil-tɨ, kɨ̀ mḛḛ ta kɨ́ tɔgrɔ-tɨ ɓane.» ");
INSERT INTO mge_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Beɓa dené lé idə Jeju panè: «Mꞌgə kɨ́ tò kadɨ Mesi à ree ə ḛ ɓá ꞌɓa-é Kristɨ lé. Lokɨ à ree lé, à kɔr-ji mḛḛ né-je lay.» ");
INSERT INTO mge_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jeju ilə-é-tɨ panè: «Mesi lé to ma̰ kɨ́ ma̰ mꞌpa sə-i ta kin ya.» ");
INSERT INTO mge_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dɔkaglo-é-tɨ kin ya njéndó né-je liə lé ꞌtəl ꞌree rəmə ndil-dé tḛḛ sa̰y kdɔ Jeju a̰ pa ta kɨ̀ dené. Bè ya kàrè, dow káre ya kàrè dəjɨ-é panè: «To ri ɓá i a̰ ꞌdəjɨ-é əse ta ri ɓá i a̰ ꞌpa siə wa al rəm.» ");
INSERT INTO mge_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Beɓa dené lé in̰ə gùm liə lo-é-tɨ ya ə ɔsɨ təl ɔw mḛḛ ɓebo-tɨ idə dow-je panè: ");
INSERT INTO mge_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ꞌReei ooi dingəm kɨ́ idə-m né-je lay kɨ́ mꞌra kin; dɔmajɨ à to Kristɨ lé je bè al wa?» ");
INSERT INTO mge_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Beɓa dow-je dꞌḭ mḛḛ ɓebo-tɨ dꞌɔw kɨ rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dɔgangɨ-é-tɨ kinlé, njéndó né-je liə ꞌra ndoo ta-é-tɨ panè: «Njèndó dow-je né, uso né ɓane.» ");
INSERT INTO mge_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngà ḛ idə-dé panè: «Nékuso kɨ́ sə̰i ꞌgəi al ya tò nè kadɨ mꞌuso.» ");
INSERT INTO mge_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Beɓa njéndó né-je ꞌpa ta dan-dé-tɨ ꞌpanè: «Dow madɨ à kadɨ-é né uso je bè.» ");
INSERT INTO mge_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jeju idə-dé panè: «Ra ndigɨ lə njèkulə-m rəm, tɔl ta kullə liə rəm kin ya ɓá to nékuso-m.» ");
INSERT INTO mge_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sə̰i kɨ̀ dɔ-si ꞌpainè: «Na̰y sɔ ɓəy ɓá ko à to kijə.» Ngà ma̰ mꞌidə-si mꞌpanè: «Uni kəm-si kɨ taá ə ooi ko-je kɨ́ mḛḛ ndɔr-tɨ kɨ́ ɔr adɨ tò kijə kin. ");
INSERT INTO mge_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Njèkijə ko ingə nékugə dɔji-é rəm, ɓá ḛ mbɔ̰ kandɨ né kdɔ kiskəm kɨ́ sartagangɨ rəm tɔ. Bè kdɔ kadɨ njèdubɨ ko dḛ kɨ̀ njèkijə ko ꞌra rɔnəl natɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gin-é kin ɓá gosta kɨ́ panè: “Njèdubɨ ko dubɨ ə dow kɨ́ rangɨ ɓá ijə lé to ta kɨ́ tɔgrɔ-tɨ.” ");
INSERT INTO mge_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lo kɨ́ sə̰i ꞌrai kullə-tɨ al ya, ma̰ mꞌulə-si mꞌadɨ ijəi ko-tɨ. Dow-je kɨ́ rangɨ ꞌra kullə rəmə, sə̰i ɓá ubəi majɨ-é.» ");
INSERT INTO mge_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mḛḛ ɓebo-é-tɨ kinlé, dow-je kɨ́ dɔnangɨ Samari-tɨ n̰a̰ ya dꞌadɨ mḛḛ-dé Jeju, kdɔ ta kɨ́ dené pa rəsɨ panè: «Ḛ idə-m né-je lay kɨ́ mꞌra.» ");
INSERT INTO mge_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lokɨ dow-je kɨ́ Samari lé ꞌree rɔ Jeju-tɨ rəmə, ꞌra ndoo ta-é-tɨ kadɨ isɨ sə-dé, adɨ ḛ isɨ nɔ̰ɔ̰ ndɔ joo. ");
INSERT INTO mge_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ə dow-je kɨ́ ꞌtò nduy-nduy ya dꞌadɨ-é mḛḛ-dé kdɔ ta-je liə, ");
INSERT INTO mge_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","rəmə dꞌidə dené lé ꞌpanè: «Jḛ jꞌadɨ mḛḛ-ji kdɔ ta-je lə-i al ngá; kdɔtalə jḛ ya jꞌoo ta-je liə kɨ̀ mbi-ji ə jꞌgə kɨ́ tɔgrɔ-tɨ ḛ to njèkajɨ dow-je kɨ́ dɔnangɨ-tɨ ya.» ");
INSERT INTO mge_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Go ndɔ-tɨ kɨ́ joo lé Jeju in̰ə lo kɨ́ tin kin ə ɔw dɔnangɨ Galile-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kdɔ ḛ ya pa rəsɨ panè: «Njèpata kɨ́ ta Lubə-tɨ lé, dow-je kɨ́ mḛḛ ɓekojɨ-é-tɨ dꞌa kun ta-é al.» ");
INSERT INTO mge_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lokɨ Jeju ree tḛḛ dɔnangɨ Galile-tɨ lé, dow-je kɨ́ dɔnangɨ Galile-tɨ dꞌuwə-é kɨ rɔ-dé-tɨ, kdɔtalə né-je lay kɨ́ ḛ ra ɓebo Jorijalḛm-tɨ dɔkaglo ra na̰y-tɨ lé dḛ dꞌoo kɨ̀ kəm-dé. Kdɔ dḛ kàrè dꞌa̰ lo ra na̰y-tɨ lé nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Beɓa ḛ təl ɔw mḛḛ ɓe-tɨ kɨ́ Kana̰, dɔnangɨ Galile-tɨ kɨ́ ndɔkɨ ḛ ra man adɨ təl yibɨ nduu titɨ lé. Dow kɨ́ boy káre kɨ́ njèrakullə kɨ̀ ngar isɨ mḛḛ ɓebo Kapɛrnayim-tɨ ə́ rɔ ngon-é kɨ́ dingəm to-é. ");
INSERT INTO mge_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lokɨ dingəm kinlé oo kɨ́ Jeju ḭ dɔnangɨ Jude-tɨ ree dɔnangɨ Galile-tɨ nɔ̰ɔ̰ rəmə, ḛ ɔw ingə-é ə ra ndoo ta-é-tɨ kadɨ-é ree adɨ lapiya ngon-é kɨ́ tò ta koy-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jeju idə-é panè: «Kinə lé ooi nékɔjɨ-je, kɨ̀ né-je kɨ́ tò ɓəl-ɓəl kin al lé a kadi mḛḛ-si nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Rəmə dow kɨ́ boy kɨ́ njèrakullə kɨ̀ ngar lé idə-é panè: «ꞌƁaɓe, ꞌree kalangɨ nè ngon-m lé à koy.» ");
INSERT INTO mge_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Beɓa Jeju idə-é panè: «Ngon-i lé ingə lapiya ngá ə́ ꞌtəl ꞌɔw ɓee gogɨ.» Ə dingəm lé ndigɨ dɔ ta-tɨ kɨ́ Jeju idə-é lé, adɨ ɔsɨ təl ɔw kɨ ɓee gogɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lokɨ ḛ nà̰y rebəə ɓəy ya rəmə, ngannjékullə-je liə ꞌtilə kəm-é dꞌidə-é ꞌpanè: «Ngon-i lé ingə lapiya ngá.» ");
INSERT INTO mge_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rəmə ḛ dəjɨ-dé sé rɔ ngon lé tò sotɨ kɨ̀ kàdɨ̀ kɨ́ ban wa? Beɓa dḛ dꞌilə-é-tɨ ꞌpanè: «ꞌNingə́ in̰ə ngon lé tagnè kɨ̀ kàdɨ̀ kɨ́ káre kɨ́ kada.» ");
INSERT INTO mge_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ə bɔbɨ ngon lé gə kɨ́ to dɔkàdɨ̀-é-tɨ kinlé ya tɔ ɓá Jeju pa-né sə-nꞌḛ̀ ta panè: «Ngon-i lé ingə lapiya ngá.» Beɓa dingəm-é kinlé adɨ mḛḛ-é rəm, ɓá dow-je kɨ́ mḛḛ kəy-tɨ liə kàrè dꞌadɨ mḛḛ-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jeju ḭ dɔnangɨ Jude-tɨ təl ree dɔnangɨ Galile-tɨ gogɨ ɓəy ɓá ra nékɔjɨ kɨ́ njèkungɨ-tɨ joo kinlé. ");
INSERT INTO mge_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Go né-je-tɨ kinlé, ndɔ ra na̰y madɨ lə jipɨ-je asɨ, adɨ Jeju ɔw ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ə mḛḛ ɓebo Jorijalḛm-tɨ, ngɔsi kɨ̀ tarəbɨ kɨ́ batɨ-je dꞌandɨ-né mḛḛ ɓebo-tɨ lé, dangɨ madɨ tò-tɨ nɔ̰ɔ̰, ꞌɓa-é kɨ̀ ta əbrə ꞌpanè Betesda. Lo-é kinlé pal ra-tɨ mḭ. ");
INSERT INTO mge_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gin pal-je-tɨ kinlé njémɔ̰y-je ꞌtò-tɨ nduy-nduy, adɨ to njékəmtɔ-je, njémətɨ-je, njérɔkoy-je njérɔkoy mburukɨ-je ꞌtò ꞌngəbɨ kadɨ man lé ləngɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kdɔ taá-taá ya malayka káre ree usɨ kəm man-tɨ lé ə ra adɨ ləngɨ-ləngɨ. Ə dow kɨ́ man ləngɨ ɓá ḭ usɨ kəm-tɨ kete lé, lé mɔ̰y liə to mɔ̰y kɨ́ ban-ban ya kàrè dowbé ingə lapiya. ");
INSERT INTO mge_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dingəm káre kɨ́ mɔ̰y ra-é ɓal kɔrmutə gidɨ-é jinà̰y joo tò ta man-tɨ lé nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jeju oo-é kɨ́ tò nangɨ ə gə kɨ́ ḛ tò lo kin-tɨ low nṵ. Beɓa dəjɨ-é panè: ꞌNdigɨ kingə lapiya wa? ");
INSERT INTO mge_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rəmə njèmɔ̰y lé ilə-é-tɨ panè: ꞌƁaɓe, lokɨ man ləngɨ lé, dow kɨ́ à kun-m kilə-m kəm-tɨ ya goto ə lokɨ ma̰ ya mꞌisɨ mꞌndɔr jan-jan kadɨ mꞌɔw mꞌusɨ-tɨ kàrè, dow kɨ́ rangɨ ḭ usɨ-tɨ kete nɔ̰̀-m-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Beɓa Jeju idə-é panè: ꞌḬ taá, ꞌun né tò-i ə ꞌnjiyə. ");
INSERT INTO mge_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ə tajinatɨ nè ya dingəm lé ingə lapiya adɨ un né tò-é ə njiyə. Ndɔ-é-tɨ kinlé to ndɔ taakoo lə jipɨ-je, ");
INSERT INTO mge_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","adɨ ꞌboy-je lə jipɨ-je ꞌpa kɨ̀ njèkingə lapiya lé ꞌpanè: To ndɔ taakoo adɨ kutɨ kɨ́ utɨ né tò-i kinlé to tó-é al! ");
INSERT INTO mge_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ḛ ilə-dé-tɨ panè: Njèkadɨ-m lapiya lé ya ɓá idə-m panè: ꞌUn né to-i ə njiyə. ");
INSERT INTO mge_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dḛ ꞌtəl dəjɨ-é ꞌpanè: Ná̰ ɓá idə-i kadɨ ꞌun né tò-i ə ꞌnjiyə wa? ");
INSERT INTO mge_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngà njèkingə lapiya lé, gə dowbé al. Kdɔtalə Jeju lé, ur dan kosɨ dow-je-tɨ kɨ́ dꞌa̰ lo-é-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Go-tɨ, Jeju ingə dingəm lé takəy-tɨ lə Lubə ə idə-é panè: Yən, i lé ꞌingə lapiya ngá ə́ ꞌra majal al nè né kɨ́ nga̰ itə ḛ kin a̰ kḭ tḛḛ dɔ-i-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dingəm lé ɔsɨ təl ɔw idə ꞌboy-je lə jipɨ-je lé panè: Dow kɨ́ adɨ-m lapiya lé to Jeju. ");
INSERT INTO mge_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gin-é kin ɓá jipɨ-je dꞌilə-né ta dɔ Jeju-tɨ, kdɔtalə ḛ adɨ lapiya dingəm lé ndɔ taakoo-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngà Jeju ilə-dé-tɨ panè: Bɔbɨ-m ra kullə sar ɓone. Ma̰ kàrè mꞌisɨ mꞌra kullə tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lokɨ ḛ pa ta kin bè ɓəy lé, jipɨ-je ꞌsangɨ kəm lo tɔl-é kɨ̀ rɔ tungə-dé itə kɨ́ kete-je ya ɓəy; kdɔtalə ndɔ taakoo kɨ́ ḛ ilə kujɨ dɔ-tɨ al kin par al, ngà kdɔ pa kɨ́ ḛ panè Lubə ɓá to Bɔbɨ-nꞌḛ̀ kɨ́ ojɨ-nꞌḛ̀, adɨ ḛ ya kɨ̀ dɔ-é oo rɔ-é kɨ́ njèkasɨ kɨ̀ Lubə tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Beɓa Jeju təl un ta idə-dé panè: Ooi majɨ, mꞌa kidə-si rəsɨ; Ngon lé né kɨ́ à kasɨ ra kɨ̀ dɔ rɔ-é ya goto. Ngà né kɨ́ Bɔbɨ-é ra adɨ-é oo ɓá ḛ ra. Ə né lay kɨ́ Bɔbɨ Ngon ra lé, Ngon kàrè à ra ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kdɔtalə Bɔbɨ Ngon lé ndigɨ ngon-é adɨ né-je lay kɨ́ ḛ isɨ ra ya ɔjɨ-é. Né-je kɨ́ tò ɓəl-ɓəl itə né-je kin kàrè Bɔbɨ Ngon à kɔjɨ-é, kdɔ kadɨ ɔr ndil-si. ");
INSERT INTO mge_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mꞌpa bè kdɔ, titɨ kɨ́ Bɔbɨ Ngon isɨ adɨ dow-je ꞌtɔsɨ-né ꞌndəl dꞌində lo ꞌtḛḛ dꞌisɨ kəm kinlé, gangɨ-é kin ya dow kɨ́ Ngon ndigɨ kadɨ-é isɨ kəm lé à kadɨ-é isɨ kəm ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Rəm ɓá Bɔbɨ Ngon gangta dɔ dow-tɨ al. Ngà ḛ təl kɨ̀ ta kɨ́ gangɨ lay ya adɨ Ngon-é, ");
INSERT INTO mge_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kdɔ kadɨ dow-je lay dꞌun ta Ngon-é titɨ kɨ́ dꞌun-né ta Bɔbɨ ngon kin bè tɔ. Adɨ dow kɨ́ un ta Ngon al rəmə to Bɔbɨ-é kɨ́ njèkulə-é kin ya dowbé un ta-é al tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ taa ta lə-m ə adɨ mḛḛ-é njèkulə-m lé isɨ kəm ya sartagangɨ, adɨ ta kɨ́ gangɨ goto dɔ-é-tɨ; dowbé lé, isɨ kəm ɓɨ oy al ngá. ");
INSERT INTO mge_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ooi majɨ, mꞌa kidə-si rəsɨ; kaglo madɨ à ree nɔ̰ɔ̰ – ə ree ngá rəm – adɨ to kaglo kɨ́ dḛ kɨ́ dꞌoy dꞌa koo ndi Ngon lə Lubə ə lokɨ dꞌoo ndi-é rəmə dꞌa kisɨ kəm. ");
INSERT INTO mge_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kdɔtalə titɨ kɨ́ Bɔbɨ Ngon to-né njèkadɨ dow-je dꞌisɨ kəm lé, gangɨ-é kin ya ḛ adɨ-né tɔ́gɨ Ngon-é kadɨ-é to njèkadɨ dow-je dꞌisɨ kəm rəm, ");
INSERT INTO mge_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ḛ adɨ-é tɔ́gɨ kadɨ-é gangta dɔ dow-je-tɨ, kdɔ ḛ to Ngon lə dow. ");
INSERT INTO mge_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Adi ta-je kin ɔr ndil-si al, kdɔ dɔkàdɨ̀ kɨ́ kadɨ dḛ kɨ́ ꞌto ɓe nin-tɨ dꞌa koo-né ndi-é asɨ ngá. ");
INSERT INTO mge_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Beɓa dḛ kɨ́ ꞌra né kɨ́ majɨ lé, dꞌa tɔsɨ ndəl kində lo tḛḛ kdɔ kisɨ kəm ə dḛ kɨ́ ꞌra né kɨ́ majɨ al lé, dꞌa tḛḛ kdɔ ta kɨ́ gangɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ma̰ lé, né kɨ́ mꞌa ra kɨ̀ dɔ rɔ-m ya goto. Adɨ mꞌgangɨ ta kɨ̀ gangɨ-é kɨ́ Bɔbɨ-m idə-m-né ya. Ə ta kɨ́ gangɨ lə-m tò njururu, kdɔ né kɨ́ mḛḛ njèkulə-m ndigɨ ɓá mꞌsangɨ ɓɨ mꞌsangɨ né kɨ́ mḛḛ-m ma̰ ɓá ndigɨ al. ");
INSERT INTO mge_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kinə to ma̰ ɓá mꞌidə dow-je ta kɨ́ dɔ-m-tɨ rəmə, à to ta kɨ́ dꞌa ndigɨ al kare. ");
INSERT INTO mge_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngà to dow kɨ́ rangɨ ɓá idə dow-je ta kɨ́ dɔ-m-tɨ ə mꞌgə kɨ́ ta kɨ́ dɔ-m-tɨ kɨ́ ḛ idə-dé lé, to ta kɨ́ tɔgrɔ-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Sə̰i ya uləi dow-je rɔ Ja̰-tɨ ə ḛ idə-si ta sɔbɨ dɔ ta kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kɨ́ sɔbɨ dɔ-m ma̰ lé, dow ɓá à kidə dow-je ta kɨ́ dɔ-m-tɨ al. Ngà ta kinlé, mꞌpa bè kdɔ kadɨ aji-né. ");
INSERT INTO mge_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja̰ lé tokɨ lampɨ kɨ́ dꞌində pər-tɨ adɨ ndógɨ ə sə̰i ꞌndigi ra-i rɔnəl-é asɨ dɔkaglo madɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma̰ lé, ta kɨ́ tokɨ pa dɔ-m-tɨ adɨ uwə dingəm n̰a̰ itə ꞌlə Ja̰ kin ya tò nè. Kdɔtalə kullə-je kɨ́ Bɔbɨ-m adɨ-m kadɨ mꞌra kinlé, kullə-é-je kin ya tɔjɨ ndaa-tɨ rəsɨ-rəsɨ adɨ dow-je ꞌgə kɨ́ Bɔbɨ-m ya ulə-m. ");
INSERT INTO mge_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ə Bɔbɨ-m kɨ́ ulə-m lé, ḛ ya idə dow-je ta kɨ́ dɔ-m-tɨ. Sə̰i ooi ndi-é nja káre al rəm, ɓá ooi-é nja káre al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ta liə kɨ́ ra ɓe mḛḛ-si-tɨ al kinlé ɓá sə̰i adi-mi-né mḛḛ-si ma̰ kɨ́ ḛ ulə-m lé al tin. ");
INSERT INTO mge_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sə̰i isi ꞌndəri gin ta-je kɨ́ mḛḛ mbete-je-tɨ kɨ́ aa njay, kdɔ sə̰i ꞌgɨri kɨ́ a kingəi ta kɨ́ sɔbɨ dɔ kiskəm kɨ́ sartagangɨ mḛḛ mbete-é-je-tɨ. Mbete-é-je kinlé ɓá isɨ pa ta kɨ́ dɔ-m-tɨ adɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Rəmə kadɨ ꞌreei rɔ-m-tɨ kdɔ kadɨ isi kəm lé, sə̰i ꞌndigi al! ");
INSERT INTO mge_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma̰ lé mꞌsangɨ kadɨ dow-je ɓá ꞌpitɨ-m al. ");
INSERT INTO mge_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngà mꞌgə-si kɨ́ sə̰i lé ꞌndigi Lubə al. ");
INSERT INTO mge_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ma̰ mꞌree kɨ̀ ri Bɔbɨ-m ə́ sə̰i uwəi-mi kɨ rɔ-si-tɨ al; kin ya dow kɨ́ rangɨ ree kɨ̀ ri-é ḛ ya rəmə, ḛ ɓá a kuwəi-é kɨ rɔ-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sə̰i kɨ́ sə̰i ya ꞌpiti-na̰ ɓɨ ꞌsangi kadɨ Lubə ya káre-rè ɓá pitɨ-si al kinlé, a rai ban ɓá a kadi mḛḛ-si wa? ");
INSERT INTO mge_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ooi nè a gɨri kɨ́ mꞌa kilə ta dɔ-si-tɨ nɔ̰̀ Bɔbɨ-m-tɨ. Dow kɨ́ à kilə ta dɔ-si-tɨ to Moiyijɨ kɨ́ sə̰i indəi mḛḛ-si dɔ-é-tɨ kin. ");
INSERT INTO mge_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kdɔtalə kinə ooi ta lə Moiyijɨ kɨ ta kɨ́ tɔgrɔ-tɨ lé, ma̰ kàrè a kooi ta lə-m kɨ ta kɨ́ tɔgrɔ-tɨ ya tɔ; kdɔ to ta-je kɨ́ sɔbɨ dɔ-m ɓá ndɔkɨ Moiyijɨ ndàngɨ. ");
INSERT INTO mge_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngà kinə ta-je kɨ́ Moiyijɨ ndàngɨ kin ya ooi kɨ ta kɨ́ tɔgrɔ-tɨ al lé, a rai ban ngá ɓá a kooi ta-je lə-m kɨ ta kɨ́ tɔgrɔ-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Go-tɨ, Jeju ɔw gidɨ babo Galile-tɨ kɨ́ ꞌɓa-é babo Tiberiadɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Rəmə kosɨ dow-je n̰a̰ ya dꞌun go-é, kdɔ kɔw koo né-je kɨ́ tò ɓəl-ɓəl kɨ́ ḛ ra adɨ-né lapiya njémɔ̰y-je. ");
INSERT INTO mge_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jeju ɔw isɨ dɔ mbal-tɨ natɨ kɨ̀ njéndó né-je liə. ");
INSERT INTO mge_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gangɨ-é-tɨ kinlé, ndɔ Pakɨ kɨ́ to ndɔ ra na̰y lə jipɨ-je nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lokɨ Jeju un kəm-é oo kosɨ dow-je kɨ́ ꞌtò nduy-nduy kɨ́ dꞌɔw ꞌree kɨ rɔ-é-tɨ kin bè rəmə, dəjɨ Pilipɨ panè: «Jꞌa ndogi mbə̀ rá ɓá jꞌa kadi dow-je kan dꞌuso wa?» ");
INSERT INTO mge_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jeju dəjɨ-é bè kdɔ na̰-né mḛḛ-é koo, kdɔtalə ḛ gə né kɨ́ nꞌa ra ɓətɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipɨ idə-é panè: «Lé dow un là kullə kɨ́ ndɔ ɓujoo ya ndogɨ-né mbə̀ kàrè, à kasɨ kadɨ ɔdɨ rɔ ta dow-je kin sḛ-sḛ lay al.» ");
INSERT INTO mge_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Beɓa káre dan njéndó né-je-tɨ liə kɨ́ ri-é lə Andre, kɨ́ to ngonkɔ̰ Simɔ̰ Piyər idə Jeju panè: ");
INSERT INTO mge_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ngon kɨ́ dingəm káre a̰ kɨ̀ mbə̀ “ɔrjɨ” mḭ, kɨ̀ kanjɨ joo nè; ngà ɓay ra-é kinlé à kasɨ dow-je kɨ́ n̰a̰ kin rá wa?» ");
INSERT INTO mge_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jeju idə njéndó né-je liə panè: «Adi dow-je lé dꞌisɨ nangɨ.» Lo-é kinlé, to lo kɨ́ wale kɨ́ mbəl n̰a̰-tɨ. Beɓa dow-je dꞌisɨ nangɨ. Ə dan dow-je-tɨ kɨ́ dꞌisɨ nangɨ lé, dingəm-je dꞌa ra ɓudɔgɨ lo mḭ je bè. ");
INSERT INTO mge_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Go-tɨ, Jeju ɔy mbə̀ lé, ra oiyo Lubə ə ləbɨ dow-je kɨ́ dꞌisɨ nangɨ lé; ḛ ra oiyo Lubə bè ya tɔ ɓá ləbɨ-dé kanjɨ lé adɨ dꞌuso kɨ́ mḛḛ-dé ndigɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lokɨ dow-je lay dꞌuso né ꞌndan lé, Jeju idə njéndó né-je liə panè: «Ɔyi dɔdum-é-je kɨ́ nà̰y, kdɔ kadɨ né káre ya kàrè nà̰y kɔgɨ al.» ");
INSERT INTO mge_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Beɓa mbə̀ kɨ́ mḭ lé, dow-je dꞌuso asɨ-dé adɨ njéndó né-je dꞌɔy dɔdum-é-je kɨ́ nà̰y kàrè dɔgɨ gidɨ-é joo. ");
INSERT INTO mge_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lokɨ dow-je dꞌoo nékɔjɨ kɨ́ Jeju ra lé, ꞌpanè: «Tɔgrɔ-tɨ ya, ḛ kanlé, to njèpata kɨ́ ta Lubə-tɨ kɨ́ tò kadɨ à ree dɔnangɨ-tɨ nè lé ya.» ");
INSERT INTO mge_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jeju gə kɨ́ dꞌa ree kuwə-é kɔw siə kdɔ kində-é ngar; beɓa ḛ təl ɔr rɔ-é kɨ̀ kár-é ɔw dɔ mbal-tɨ gogɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta ji losɔl-tɨ lé, njéndó né-je liə dꞌɔw njal ta babo-tɨ, ");
INSERT INTO mge_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ə dꞌɔw dꞌal mḛḛ tò-tɨ kdɔ kɔw ɓebo Kapɛrnayim-tɨ gidɨ babo-tɨ. Ndɔ il ya ngá kàrè Jeju ingə-dé al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rəmə, yə́lbo ulə dɔ babo-tɨ adɨ man tal bum-bum. ");
INSERT INTO mge_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lokɨ njéndó né-je ꞌnəl tò dꞌɔw à kasɨ kilomɛtrə mḭ əse mɛkḛ-je bè rəmə, dꞌun kəm-dé dꞌoo Jeju kɨ́ ɔw njiyə dɔ man babo-tɨ isɨ ree kɨ ta tò-tɨ adɨ ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngà Jeju idə-dé panè: «To ma̰ ɓəy ə́ ꞌɓəli al!» ");
INSERT INTO mge_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dḛ ꞌndigɨ kadɨ Jeju al mḛḛ tò-tɨ, rəmə tajinatɨ nè ya, tò ɔsɨ nangɨ lo kɨ́ dꞌisɨ dꞌɔw-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lo aa go-tɨ rəmə, kosɨ dow-je kɨ́ ꞌnà̰y gogɨ gidɨ babo-tɨ dꞌoo kɨ́ lo-é-tɨ kinlé tò ra káre-rè rəm, ɓá dꞌoo kɨ́ Jeju al mḛḛ tò-tɨ natɨ kɨ̀ njéndó né-je liə al rəm, adɨ njéndó né-je ya ɓá dꞌɔw kɨ̀ kar-dé. ");
INSERT INTO mge_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngà dow-je ꞌree kɨ̀ tò-je kɨ́ rangɨ kɨ́ dꞌḭ-né babo Tiberiadɨ-tɨ kɨ́ tò ngɔsi kɨ̀ lo kɨ́ ndɔkɨ ꞌƁaɓe ra oiyo dɔ mbə̀-tɨ ɓá adɨ dow-je dꞌuso lé. ");
INSERT INTO mge_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lokɨ kosɨ dow-je ꞌgə kɨ́ Jeju goto rəm, ɓá njéndó né-je liə kàrè ꞌgoto rəm lé, dḛ ya dꞌal mḛḛ tò-je-tɨ kinlé dꞌɔw ɓebo Kapɛrnayim-tɨ kdɔ ndole Jeju. ");
INSERT INTO mge_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lokɨ dꞌingə Jeju gidɨ babo-tɨ lé, ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, ꞌree ꞌtḛḛ nè kàdɨ̀ ban wa? ");
INSERT INTO mge_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jeju idə-dé panè: Ooi majɨ, mꞌa kidə-si rəsɨ; sə̰i lé, ꞌsangi-mi kdɔtalə né kɨ́ usoi ꞌndani ɓɨ ꞌsangi-mi kdɔtalə nékɔjɨ-je kɨ́ mꞌra mꞌadɨ ooi kin al. ");
INSERT INTO mge_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꞌRai kullə kdɔtalə nékuso kɨ́ à ndum kin al, ngà ꞌrai kullə kdɔ nékuso kɨ́ tò kɨ̀ dɔ ɓal-ɓal kdɔ kiskəm kɨ́ sartagangɨ kɨ́ to nékuso kɨ́ Ngon lə dow à kadɨ-si. Kdɔtalə Ngon lə dow lé, ḛ ɓá Bɔbɨ-é Lubə ɔsɨ-é kɨ̀ pɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kosɨ dow-je lé, ꞌdəjɨ Jeju ꞌpanè: Jꞌa ra ri ɓá jꞌa ra kullə-je kɨ́ mḛḛ Lubə ndigɨ wa? ");
INSERT INTO mge_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Beɓa Jeju idə-dé panè: Né kɨ́ Lubə sangɨ rɔ-si-tɨ lé, ḛ ndigɨ kadɨ adi-mi mḛḛ-si ma̰ Ngon-é kɨ́ ḛ ulə-m lé. ");
INSERT INTO mge_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dḛ ꞌtəl ꞌdəjɨ-é ꞌpanè: «Ngà i lé, ri ɓá to nékɔjɨ kɨ́ ꞌa ra kdɔ kadɨ jꞌoo ə jꞌadɨ-i-né mḛḛ-ji wa? Kullə lə-i to ri wa? ");
INSERT INTO mge_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ndɔkɨ kaji-je dꞌuso né kɨ́ ꞌɓa-é maan diləlo-tɨ titɨ kɨ́ ꞌndàngɨ-né mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: Adɨ-dé nékuso kɨ́ ḭ dɔra̰-tɨ dꞌuso.» ");
INSERT INTO mge_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jeju ilə-dé-tɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; nékuso kɨ́ ḭ dɔra̰-tɨ lé, ndɔkɨ to Moiyijɨ ɓá adɨ-si al, ngà Bɔbɨ-m ɓá adɨ-si nékuso kɨ́ tɔgrɔ-tɨ kɨ́ ḭ dɔra̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kdɔtalə nékuso lə Lubə lé, to njèkḭ dɔra̰-tɨ ree kɨ́ adɨ dow-je kɨ́ dɔnangɨ-tɨ nè dꞌisɨ kəm.» ");
INSERT INTO mge_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Beɓa dḛ dꞌidə Jeju ꞌpanè: «ꞌƁaɓe, ꞌadɨ-ji nékuso kinlé kɨ̀ ndɔ-é ndɔ-é ya.» ");
INSERT INTO mge_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jeju idə-dé panè: «Ma̰ ya mꞌto nékuso kɨ́ njèkadɨ dow-je dꞌisɨ kəm. Dow kɨ́ ree rɔ-m-tɨ lé ɓo à ra-é al ya sar rəm, ɓá dow kɨ́ adɨ-m mḛḛ-é kàrè kundə à ra-é al ya sar rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngà lé mꞌidə-si mꞌpanè: “Sə̰i ooi-mi ya, ngà sə̰i adi-mi mḛḛ-si al.” ");
INSERT INTO mge_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dow-je lay kɨ́ Bɔbɨ-m adɨ-m-dé lé, dꞌa ree rɔ-m-tɨ ə dow kɨ́ ree rɔ-m-tɨ lé, mꞌa tubə-é al; ");
INSERT INTO mge_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kdɔtalə ma̰ lé mꞌḭ dɔra̰-tɨ mꞌree kdɔ ra né kɨ́ mḛḛ-m ma̰ ɓá ndigɨ al, ngà Lubə kɨ́ ulə-m lé ɓá mꞌree kdɔ ra né kɨ́ mḛḛ-é ndigɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ə Lubə kɨ́ ulə-m lé, ndigɨ kadɨ dow-je lay kɨ́ nꞌadɨ-m-dé kinlé, mꞌadɨ dow káre dan-dé-tɨ nà̰y kɔgɨ al, ngà kadɨ mꞌadɨ-dé ꞌtɔsɨ ꞌndəl dꞌində lo ꞌtḛḛ dɔbəy ndɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","«Né kɨ́ Bɔbɨ-m ndigɨ ə́n: Kadɨ dow kɨ́ oo Ngon ə adɨ-é mḛḛ-é rəmə, isɨ kəm sartagangɨ ə mꞌa kadɨ-é tɔsɨ ndəl ində lo tḛḛ dɔbəy ndɔ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jipɨ-je ꞌyun ta dɔ-é-tɨ, kdɔ pa kɨ́ ḛ panè: «Ma̰ ya mꞌto nékuso kɨ́ ḭ dɔra̰-tɨ lé, ");
INSERT INTO mge_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","adɨ dḛ ꞌpanè: “Ḛ kanlé, ḛ ya to Jeju kɨ́ ngon lə Jojepɨ, kɨ́ jꞌgəi kɔ̰-é-je kɨ̀ bɔbɨ-é-je majɨ lé ya al wa? Ngà ra ban ɓá ḛ panè nꞌḭ dɔra̰-tɨ wa?”» ");
INSERT INTO mge_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jeju idə-dé panè: ꞌYuni ta dan-si-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dow kɨ́ Bɔbɨ-m kɨ́ njèkulə-m ndɔr-é ree siə rɔ-m-tɨ al lé, dowbé à kasɨ ree rɔ-m-tɨ kɨ̀ dɔ rɔ-é al; ə dow kɨ́ ree rɔ-m-tɨ lé, mꞌa kadɨ-é tɔsɨ ndəl ində lo tḛḛ dɔbəy ndɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mḛḛ mbete-tɨ lə njépata-je kɨ́ ta Lubə-tɨ lé, ꞌndàngɨ ꞌpanè: «Dow-je lay ya Lubə à ndó-dé né.» Dow kɨ́ rá-rá kɨ́ oo ta kɨ́ ta Bɔbɨ-m Lubə-tɨ ə təl rɔ-é go-tɨ lé, à ree rɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dow kɨ́ oo Bɔbɨ-m ya goto; njèkḭ rɔ Lubə-tɨ ya káre-rè ə oo Bɔbɨ-m. ");
INSERT INTO mge_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ adɨ-m mḛḛ-é lé, isɨ kəm ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma̰ lé, mꞌto nékuso kɨ́ njèkadɨ dow-je dꞌisɨ kəm. ");
INSERT INTO mge_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Né kɨ́ ꞌɓa-é maan lé, ka-si-je dꞌuso diləlo-tɨ ya, ngà dꞌoy. ");
INSERT INTO mge_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nékuso kɨ́ ḭ dɔra̰-tɨ kadɨ dow uso ə à koy al lé ə́n: ");
INSERT INTO mge_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma̰ ɓá mꞌto nékuso kiskəm kɨ́ ḭ dɔra̰-tɨ ree. Dow kɨ́ uso né-é kinlé rəmə, à kisɨ kəm ya sartagangɨ. Ə nékuso kɨ́ mꞌa kadɨ lé, to da̰-m ya ɓá mꞌa kadɨ, kdɔ kadɨ dow-je kɨ́ dɔnangɨ-tɨ nè dꞌisɨ-né kəm. ");
INSERT INTO mge_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ta kinlé ra adɨ jipɨ-je ꞌnajɨ-na̰ ta dan-dé-tɨ ꞌpanè: Dow kanlé à ra ban ɓá à kadɨ-ji da̰-é jꞌuso wa? ");
INSERT INTO mge_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Beɓa Jeju idə-dé panè: Ooi majɨ, mꞌa kidə-si rəsɨ; kinə usoi da̰ Ngon lə dow al rəm, ɓá kinə a̰yi məsɨ-é al rəm lé, à kisɨ kəm nda̰ al. ");
INSERT INTO mge_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dow kɨ́ uso da̰-m rəm ɓá a̰y məsɨ-m rəm lé, isɨ kəm sartagangɨ ə mꞌa kadɨ-é tɔsɨ ndəl ində lo tḛḛ dɔbəy ndɔ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kdɔtalə da̰-m to nékuso kɨ́ tɔgrɔ-tɨ rəm, ɓá məsɨ-m to néka̰y kɨ́ tɔgrɔ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dow kɨ́ uso da̰-m rəm, ɓá a̰y məsɨ-m rəm lé, dowbé isɨ mḛḛ-m-tɨ rəm, ɓá ma̰ kàrè mꞌisɨ mḛḛ-é-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","«Bɔbɨ-m kɨ́ ulə-m lé to njèkisɨ kəm, adɨ ma̰ mꞌisɨ kəm kɨ̀ takul-é; bè ya tɔ, dow kɨ́ uso da̰-m lé, à kisɨ kəm kɨ̀ takul-m tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ḛ ɓá to nékuso kɨ́ ḭ dɔra̰-tɨ lé. To gà̰ nékuso kɨ́ ndɔkɨ ka-si-je dꞌuso ya, ngà dꞌoy kin al. Nékuso-é kinlé, dow kɨ́ uso rəmə, à kisɨ kəm ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ḛ ɓá to ta-je kɨ́ Jeju pa ndó-né dow-je né mḛḛ kəykəwna̰-tɨ lə jipɨ-je ɓebo Kapɛrnayim-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Njéndó né-je liə n̰a̰ ya, lokɨ dꞌoo ta-je kin bè lé, ꞌpanè: «Ta kinlé nga̰ n̰a̰! Ná̰ ɓá à ndigɨ dɔ-tɨ siə wa?» ");
INSERT INTO mge_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jeju gə mḛḛ-é-tɨ kɨ́ njéndó né-je ꞌyun ta dɔ ta-tɨ liə lé, adɨ dəjɨ-dé panè: «Ta kɨ́ mꞌpa lé tugə-si jigɨ-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ə kinə lé ooi Ngon lə dow kɨ́ ḭ isɨ ɔw kɨ lo-tɨ kɨ́ ndɔkɨ isɨ-tɨ kete lé ə a painè ri ngá wa?» ");
INSERT INTO mge_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ndil kɨ́ aa njay ɓá to njèkadɨ dow isɨ kəm. To né kɨ́ dow à kasɨ ra nda̰ al. Ta-je kɨ́ mꞌidə-si kinlé ɓá à kadɨ dow Ndil kɨ́ aa njay rəm, à kadɨ dow isɨ kəm rəm. ");
INSERT INTO mge_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngà dow-je madɨ dꞌa̰ dan-si-tɨ nè ya dꞌadɨ mḛḛ-dé al. Jeju pa bè kdɔtalə dow-je kɨ́ dan-tɨ-je kɨ́ dꞌadɨ mḛḛ-dé al lé, ḛ gə-dé lo kulə gin-é-tɨ ya rəm, ɓá dow kɨ́ à kun dɔ-é kàrè, ḛ gə-é lo kulə gin-é-tɨ ya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jeju ilə dɔ-tɨ panè: «Gin-é kin ɓá mꞌidə-si-né mꞌpanè: Dow kɨ́ Bɔbɨ-m in̰ə tarəbɨ adɨ-é kadɨ ree rɔ-m-tɨ al lé, dowbé à kasɨ ree rɔ-m-tɨ kɨ̀ dɔ rɔ-é al.» ");
INSERT INTO mge_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dɔkaglo-é-tɨ kinlé, njéndó né-je liə n̰a̰ dꞌɔr rɔ-dé kɔgɨ rɔ-é-tɨ ꞌmbatɨ kun go-é. ");
INSERT INTO mge_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Beɓa Jeju dəjɨ njéndó né-je liə kɨ́ dɔgɨ gidɨ-é joo panè: «Ə sə̰i ə ꞌndigi kɔwi sə-dé al wa?» ");
INSERT INTO mge_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔ̰ Piyər ilə-é-tɨ panè: «ꞌƁaɓe, jḛ jꞌa kɔw go ná̰-tɨ ɓəy wa? I ya ɓá ta-je kɨ́ dow à kisɨ-né kəm sartagangɨ lé tò rɔ-i-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Beɓa jḛ jꞌadɨ mḛḛ-ji rəm, jḛ jꞌgə kɨ́ i ɓá ꞌto njèkaa njay kɨ́ Lubə mbətɨ-i rəm.» ");
INSERT INTO mge_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jeju ilə-dé-tɨ panè: «Sə̰i kɨ́ dɔgɨ gidɨ-é joo lé, to ma̰ ya mꞌmbətɨ-si lay ya al wa? Ngà dow káre dan-si-tɨ ɓá to dow lə Sú!» ");
INSERT INTO mge_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jeju pa ta kinlé sɔbɨ-né dɔ Judasɨ ngon lə Simɔ̰ Iskariyotɨ. Kdɔtalə Judasɨ kɨ́ to kɨ́ dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo kinlé ya ɓá à kun dɔ Jeju. ");
INSERT INTO mge_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Go-tɨ, Jeju njiyə gəkɨ lo kɨ́ dɔnangɨ Galile-tɨ gəkɨ-gəkɨ. Ḛ ndigɨ kɔw dɔnangɨ Jude-tɨ al, kdɔtalə ꞌboy-je lə jipɨ-je ꞌsangɨ tɔl-é. ");
INSERT INTO mge_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ndɔ kɨ́ kadɨ jipɨ-je ꞌra-né na̰y kəykam-je lə-dé nà̰y ngɔsi. ");
INSERT INTO mge_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Beɓa ngankɔ̰ Jeju dꞌidə-é ꞌpanè: ꞌIn̰ə lo kɨ́ nè kin ə ꞌɔw dɔnangɨ Jude-tɨ kdɔ kadɨ njéndó né-je lə-i dꞌoo né-je kɨ́ isɨ ꞌra ra lé tɔ ɓane. ");
INSERT INTO mge_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Dow kɨ́ ndigɨ tɔjɨ rɔ-é kadɨ dow-je ꞌgə-é lé, ɓɔyɔ rɔ-é ra né al. Titɨ kɨ́ ꞌisɨ ꞌra-né né-je kinlé, ꞌtɔjɨ rɔ-i adɨ dow-je lay ꞌgə-i. ");
INSERT INTO mge_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ngankɔ̰-é-je lé ꞌpa bè kdɔtalə dḛ ya kàrè dꞌadɨ-é mḛḛ-dé al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ḛ idə-dé panè: Ma̰ lé dɔkaglo-é lə-m nà̰y ɓəy; ngà sə̰i rəmə, dɔkaglo lə-si to kɨ̀ ndɔ-je lay. ");
INSERT INTO mge_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sə̰i lé, dow-je kɨ́ dɔnangɨ-tɨ nè dꞌa kɔsɨ-si kɨ̀ ta al; ngà ma̰ rəmə dꞌa kɔsɨ-m kɨ̀ ta. Kdɔtalə kullə ra-dé-je kɨ́ majɨ al majɨ al lé mꞌpa ta dɔ-tɨ mꞌadɨ dow-je dꞌoo. ");
INSERT INTO mge_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sə̰i ə ɔwi lo ra na̰y-tɨ lé. Ngà ma̰ ɓá mꞌa kɔw al, kdɔtalə kaglo kɔw-é lə-m asɨ al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Lokɨ idə-dé ta-je kin bè lé, ḛ təl isɨ-né dɔnangɨ Galile-tɨ nɔ̰ɔ̰ ya. ");
INSERT INTO mge_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lokɨ ngankɔ̰ Jeju-je dꞌɔtɨ dꞌɔw lo ra na̰y-tɨ lé rəmə, ḛ kàrè ɔtɨ njɔ̰y ya ɔw-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ndɔ-je-tɨ kɨ́ dꞌisɨ ꞌra-né na̰y kinlé, jipɨ-je ꞌsangɨ-é ə ꞌdəjɨ ꞌpanè: Ḛ lé a̰ rá wa? ");
INSERT INTO mge_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kosɨ dow-je ꞌyun ta dan-dé-tɨ n̰a̰ ꞌsɔbɨ-né dɔ-é. Dḛ kɨ́ ná̰-je ꞌpanè: Ḛ to dow kɨ́ majɨ ə dḛ kɨ́ dan-tɨ-je ꞌpanè: Kay! Ḛ to njèkur kosɨ dow-je wale. ");
INSERT INTO mge_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bè ya kàrè, ta kɨ́ sɔbɨ dɔ-é lé, dow kɨ́ pa rəsɨ ya goto, kdɔ ꞌɓəl ꞌboy-je lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ꞌRa na̰y lé dꞌa̰ dana̰ ngá ɓá Jeju ɔtɨ ɔw takəy-tɨ lə Lubə ə ndó dow-je né. ");
INSERT INTO mge_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Néndó liə ɔr ndil jipɨ-je adɨ ꞌpanè: Dow kanlé, ingə néndó al rəm, ngà ra ban ɓá ḛ gə mbete lə Lubə bè wa? ");
INSERT INTO mge_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jeju ilə-dé-tɨ panè: Né kɨ́ mꞌndó dow-je lé, to né kɨ́ ma̰ ɓá mꞌun kɨ̀ dɔ-m al. Ngà to Lubə kɨ́ njèkulə-m ɓá adɨ mꞌndó-dé. ");
INSERT INTO mge_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dow kɨ́ ge ra né kɨ́ mḛḛ Lubə ndigɨ lé, kinə to Lubə ɓá adɨ-m mꞌndó né kinlé dow-je kàrè dowbé à gə rəm əse to né kɨ́ ma̰ ya mꞌun kɨ̀ dɔ-m ɓá mꞌndó-dé kàrè dowbé à gə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dow kɨ́ un ta kɨ̀ dɔ-é ya pa pa lé, to dow kɨ́ isɨ sangɨ riɓa kɨ́ sɔbɨ dɔ-é ḛ ya. Ngà dow kɨ́ isɨ sangɨ riɓa lə njèkulə-é lé, ḛ ɓá to njèra né kɨ́ tɔgrɔ-tɨ ə né ra kɨ́ njururu al goto rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moiyijɨ adɨ-si ndukun ya al wa? Ngà dow káre-rè kɨ́ kadɨ təl rɔ-é go-tɨ ya goto. Rəmə kdɔ ri ɓá ꞌsangi kadɨ ꞌtɔli-mi wa? ");
INSERT INTO mge_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Beɓa kosɨ dow-je dꞌilə-é-tɨ ꞌpanè: I lé ꞌɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-i-tɨ nɔ̰ɔ̰. Ná̰ ɓá sangɨ kdɔ tɔl-i wa? ");
INSERT INTO mge_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jeju təl ilə-dé-tɨ panè: Mꞌra né káre-rè ɓəy ya ə́ sə̰i lay ya ndil-si tḛḛ sa̰y. ");
INSERT INTO mge_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moiyijɨ un ndu adɨ-si kadɨ ijəi ngan-si-je ganjangɨ ə to né kɨ́ dꞌulə gin-é dɔ Moiyijɨ-tɨ nè al, ngà to ka-ji-je kɨ́ low ɓá dꞌulə gin-é. Ə ndɔ taakoo ya sə̰i ijəi dow ganjangɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Sə̰i ijəi dow ganjangɨ ndɔ taakoo-tɨ bè, kdɔ kadɨ ali-né dɔ ndukun lə Moiyijɨ al. Ngà kdɔ ri ɓəy ɓá dajɨ rɔ dow ɓikti ya mꞌadɨ-é lapiya ndɔ taakoo-tɨ rəmə, sə̰i adi wɔngɨ ra-si dɔ-m-tɨ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ooi rɔ dow kɨ́ ndaa-tɨ nè ɓá ꞌgangi-né ta al; ngà ꞌgangi ta gangɨ kɨ́ njururu ɓane. ");
INSERT INTO mge_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dow-je kɨ́ dan-tɨ-je kɨ́ ɓebo Jorijalḛm-tɨ ꞌpanè: Dow kɨ́ ꞌboy-je lə jipɨ-je dꞌisɨ ꞌsangɨ-é kdɔ tɔl-é lé ya ɓan al wa? ");
INSERT INTO mge_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ooi, ḛ a̰ pa ta ndaa-tɨ rəsɨ takəm dow-je-tɨ ə ta káre ya kàrè dow pa siə dɔ-tɨ al rəm. Adɨ ꞌboy-je lə-ji ꞌndigɨ dɔ-tɨ kɨ́ ḛ kan ɓá to Kristɨ lé ya tɔgrɔ-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lokɨ Kristɨ à ree lé, dow kɨ́ à gə lo kɨ́ ḭ-tɨ ya goto. Ngà dow kanlé, jə̰i jꞌgəi lo kɨ́ ḭ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jeju a̰ ndó dow-je né takəy-tɨ lə Lubə ya rəmə ḛ pa ta kɨ̀ ndi-é kɨ́ boy panè: Adɨ ꞌpainè ꞌgəi-mi rəm, ꞌgəi lo kɨ́ mꞌḭ-tɨ rəm al ɓan! Ma̰ lé, mꞌree kɨ̀ dɔ rɔ-m al. Njèkulə-m lé to njèra né kɨ́ tɔgrɔ-tɨ, ngà gə ɓá sə̰i ꞌgəi-é al. ");
INSERT INTO mge_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma̰ mꞌgə-é kdɔ mꞌḭ rɔ-é-tɨ ɓá mꞌree ma̰ tin rəm, ɓá to ḛ ɓá ulə-m rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Beɓa dḛ ꞌsangɨ kadɨ dꞌuwə-é, ngà dow kɨ́ asɨ kadɨ uwə-é goto, kdɔtalə dɔ gangɨ lo kuwə-é nà̰y ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dow-je n̰a̰ dan kosɨ dow-je-tɨ dꞌadɨ mḛḛ-dé Jeju lé ə ꞌpanè: Lokɨ Kristɨ lé, à ree rəmə, ḛ à ra nékɔjɨ-je n̰a̰ kitə dow kanlé ɓəy ɓan wa? ");
INSERT INTO mge_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ta-je kɨ́ dow-je ꞌpa n̰ɔ̰m-nɔ̰m ꞌsɔbɨ-né dɔ Jeju lé, usɨ mbi Parisi-je-tɨ. Beɓa njékun dɔ njégugné-je, kɨ̀ Parisi-je dꞌulə njéngəm takəy lə Lubə kadɨ dꞌɔw dꞌuwə-é. ");
INSERT INTO mge_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Beɓa Jeju panè: «Mꞌa kisɨ sə-si ndḛ ɓəy ɓá mꞌa təl kɔw rɔ njèkulə-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lokɨ mꞌa kɔw lé, a sangi-mi ngà a kingəi-mi al rəm, ɓá lo kɨ́ mꞌa kɔw-tɨ lé kàrè a kasi kɔwi-tɨ al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Rəmə jipɨ-je ꞌpa-na̰ ta dan-dé-tɨ ꞌpanè: «Kɔw ə ḛ à kɔw rá ya ɓá jꞌa kingəi-é-né al lé wa? Ḛ à kɔw rɔ ngankɔ̰-ji-je-tɨ kɨ́ ꞌsane-na̰ dꞌisɨ ɓe lə grɛkɨ-je, kdɔ kadɨ nꞌndó né grɛkɨ-je wa? ");
INSERT INTO mge_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ḛ panè: “A sangi-mi, ngà a kingəi-mi al. Lo kɨ́ mꞌa kɔw-tɨ lé kàrè a kasi kɔwi-tɨ al. Ta kinlé kɔr mḛḛ-é tò ban wa?”» ");
INSERT INTO mge_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sɔ̰y ndɔ ra na̰y kəykam-je, adɨ to ndɔ kɨ́ boy n̰a̰ kin ɓá Jeju ḭ a̰ taá, pa ta kɨ̀ ndi-é kɨ́ boy panè: Dow kɨ́ kundə man ra-é rəmə, kadɨ-é ree rɔ-m-tɨ a̰y man. ");
INSERT INTO mge_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dow kɨ́ adɨ-m mḛḛ-é lé, man ba-je kɨ́ à kadɨ dow-je kiskəm ya à kḭ mḛḛ-é-tɨ lo bul-bul titɨ kɨ́ mbete kɨ́ aa njay pa-né bè. ");
INSERT INTO mge_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ta kinlé, Jeju pa sɔbɨ-né dɔ Ndil kɨ́ aa njay kɨ́ dḛ kɨ́ dꞌadɨ-nꞌḛ̀ mḛḛ-dé dꞌa kingə. Dɔkaglo-é-tɨ kinlé Lubə adɨ Ndil kɨ́ aa njay al ɓəy, kdɔ Lubə tɔjɨ riɓa lə Jeju ndaa-tɨ rəsɨ al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lokɨ dow-je kɨ́ dan-tɨ-je dan kosɨ dow-je-tɨ dꞌoo ta-je kinlé rəmə ꞌpanè: Dow kanlé to njèpata kɨ́ ta Lubə-tɨ ya tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dḛ kɨ́ ná̰-je ꞌpanè: Dow kanlé to Kristɨ. Rəmə dḛ kɨ́ rangɨ ꞌpanè: Kristɨ lé à kḭ dɔnangɨ Galile-tɨ ɓan wa? ");
INSERT INTO mge_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mbete kɨ́ aa njay panè: Kristɨ lé, à tḛḛ gin kojɨ-tɨ lə Dabidɨ mḛḛ ɓe-tɨ kɨ́ Bɛtlekɛm kɨ́ to ɓe lə Dabidɨ. ");
INSERT INTO mge_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Beɓa ta kɨ́ sɔbɨ dɔ Jeju lé, ta dow-je asɨ-na̰ dɔ-tɨ al adɨ ꞌgángɨ-né-na̰. ");
INSERT INTO mge_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dow-je kɨ́ dan-tɨ-je dan-dé-tɨ ꞌndigɨ kuwə Jeju ya, ngà dow kɨ́ asɨ kadɨ uwə-é goto. ");
INSERT INTO mge_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Njéngəm takəy lə Lubə lé, ꞌtəl dꞌɔw rɔ njékun dɔ njégugné-je-tɨ, kɨ̀ Parisi-je lé rəmə, ꞌdəjɨ-dé ꞌpanè: Kdɔ ri ɓá uwəi-é ꞌreei siə al wa? ");
INSERT INTO mge_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Njéngəm takəy lə Lubə lé, dꞌilə-dé-tɨ ꞌpanè: Ta-je kɨ́ dingəm kin pa lé to ta kɨ́ dow pa nja káre al ya ɓəy! ");
INSERT INTO mge_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Rəmə Parisi-je lé dꞌḭ sə-dé dɔ-tɨ ꞌpanè: Sə̰i lé ya kàrè adi-é ur-si wale ɓəy tɔ al ɓan! ");
INSERT INTO mge_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dow káre-rè kɨ́ dan ꞌboy-je-tɨ əse dan Parisi-je-tɨ adɨ-é mḛḛ-é adɨ ooi nɔ̰ɔ̰ ɓan wa? ");
INSERT INTO mge_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngà kosɨ dow-je kanlé, to gə ɓá ꞌgə ndukun lə Lubə al. Dḛ ꞌto dow-je kɨ́ ndɔl uwə dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodḛm kɨ́ to káre dan ꞌboy-je-tɨ kɨ́ ndɔkɨ ree ingə Jeju lé idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Kɨ́ go ndukun-tɨ lə-ji ya lé, ꞌa koo ta ta dow-tɨ al rəm, ꞌa gə né kɨ́ dowbé lé ra al rəm ya ꞌa gangta dɔ-é-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dḛ dꞌilə-é-tɨ ꞌpanè: I ꞌɔw kɨ̀ to dow kɨ́ dɔnangɨ Galile-tɨ tɔ ngá wa? ꞌNdó ndukun majɨ ꞌoo ə ꞌa gə kɨ́ njèpata kɨ́ ta Lubə-tɨ à kḭ dɔnangɨ Galile-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Go-tɨ, ná̰-ná̰ ya ɔtɨ ɔw ɓe liə-liə. ");
INSERT INTO mge_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeju ɔw dɔ mbal ka̰ kagɨ Olibiye-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngà kɨ̀ ndɔge ratɨ ya ḛ təl ree takəy-tɨ lə Lubə gogɨ ə dow-je lay ꞌree rɔ-é-tɨ. Beɓa ḛ isɨ nangɨ isɨ ndó-dé né. ");
INSERT INTO mge_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Rəmə njéndó dow-je ndukun-je, kɨ̀ Parisi-je dꞌuwə dené káre dɔ kaya-tɨ ꞌree siə rɔ Jeju-tɨ dꞌadɨ-é a̰ dan dow-je-tɨ dana̰. ");
INSERT INTO mge_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ngá ɓá dꞌidə Jeju ꞌpanè: «Njèndó dow-je né, dené kanlé jꞌuwə-é dɔ kaya-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ə mḛḛ ndukun-tɨ lé, Moiyijɨ un ndu adɨ-ji, kdɔ kadɨ ko dené-je kɨ́ bè kinlé jꞌtilə-dé kɨ̀ ər jꞌtɔl-dé kɔgɨ. Ngà i ə ꞌa pa ta dɔ-tɨ panè ri wa?» ");
INSERT INTO mge_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Dḛ ꞌdəjɨ-é ta kinlé bè kdɔ kingə-né ta madɨ ta-é-tɨ, kdɔ kadɨ dꞌilə-né ta dɔ-é-tɨ. Ngà Jeju ulə dɔ-é nangɨ ə isɨ tijə né nangɨ kɨ̀ ngon ji-é. ");
INSERT INTO mge_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lokɨ ꞌdəjɨ-é ta kəm-dé kete-kete lé, ḛ ɔr dɔ-é taá idə-dé panè: «Dow kɨ́ dan-si-tɨ kɨ́ ra majal nja káre al ɓəy ya ə un ər ilə-né dené lé dɔsa̰y.» ");
INSERT INTO mge_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ə Jeju təl ulə dɔ-é nangɨ gogɨ ə isɨ tijə né nangɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lokɨ dꞌoo ta-je kin bè lé mḛḛ-dé uwə-dé kɨ̀ ta adɨ dꞌḭ káre-káre, ḭ dɔ dḛ-tɨ kɨ́ ꞌtɔgɨ n̰a̰-tɨ ya sar dɔ sɔ̰y-dé-je-tɨ. Beɓa Jeju kɨ̀ dené lé ya par ꞌnà̰y dana̰ dan kosɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Rəmə Jeju ɔr dɔ-é taá ə dəjɨ dené lé panè: Dené, njékilə ta dɔ-i-tɨ-je lé dꞌɔw rá wa? Dow káre ya kàrè gangta dɔ-i-tɨ al wa? ");
INSERT INTO mge_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ə dené lé ilə-é-tɨ panè: ꞌƁaɓe, dow gangta dɔ-m-tɨ al. Beɓa Jeju idə-é panè: «Ma̰ kàrè mꞌgangɨ ta dɔ-i-tɨ al ya tɔ ə́ ɔw, ngà majal ɓá gogɨ rangɨ ꞌra al ngá.» ");
INSERT INTO mge_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jeju pa ta kɨ́ rangɨ ya ɓəy adɨ dow-je panè: Ma̰ lé, mꞌto londógɨ lə dɔnangɨ. Dow kɨ́ un go-m lé à njiyə lo kɨ́ ndul-tɨ al, ngà à kingə lo kɨ́ ndógɨ kɨ́ to kiskəm. ");
INSERT INTO mge_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Rəmə Parisi-je pa siə ꞌpanè: Ta kɨ́ sɔbɨ dɔ-i ɓá i ya ꞌa̰ ꞌpa adɨ dow-je kin ya rəmə tɔjɨ kɨ́ to ta kɨ́ tɔgrɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Beɓa Jeju ilə-dé-tɨ panè: Lé ma̰ ya mꞌpa ta kɨ́ sɔbɨ dɔ-m mꞌadɨ dow-je kàrè, ta kɨ́ mꞌpa lé to ta kɨ́ tɔgrɔ-tɨ ya. Kdɔ ma̰ mꞌgə lo kɨ́ mꞌḭ-tɨ rəm, mꞌgə lo kɨ́ mꞌisɨ mꞌɔw-tɨ rəm tɔ. Ngà sə̰i rəmə, ꞌgəi lo kɨ́ mꞌḭ-tɨ al rəm, ɓá ꞌgəi lo kɨ́ mꞌa kɔw-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sə̰i ꞌgangi ta kɨ́ go lo koo-tɨ lə dow. Ngà ma̰, mꞌgangɨ ta dɔ dow-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ə kinə ma̰ mꞌgangɨ ta kàrè, ta kɨ́ gangɨ lə-m ɔw natɨ kɨ̀ ta kɨ́ tɔgrɔ-tɨ. Kdɔ ma̰ mꞌa̰ kɨ̀ kár-m al. Bɔbɨ-m kɨ́ njèkulə-m lé a̰ sə-m natɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mḛḛ ndukun-tɨ lə-si lé, ꞌndàngɨ ꞌpanè né kɨ́ dow-je joo ꞌpa ta dɔ-tɨ kinlé, né-é to tó-é. ");
INSERT INTO mge_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma̰ mꞌpa ta kɨ́ sɔbɨ dɔ-m ma̰ ya mꞌadɨ dow-je rəm, ɓá Bɔbɨ-m kɨ́ ulə-m lé kàrè pa ta kɨ́ sɔbɨ dɔ-m adɨ dow-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Rəmə ꞌdəjɨ-é ꞌpanè: Bɔbɨ-i lé a̰ rá wa? Ə Jeju ilə-dé-tɨ panè: Sə̰i ꞌgəi-mi al rəm, ɓá ꞌgəi Bɔbɨ-m al rəm. Kinə ꞌgəi-mi rəmə a gəi Bɔbɨ-m tɔ. ");
INSERT INTO mge_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeju a̰ takəy-tɨ lə Lubə ngɔsi kɨ̀ lo kilə kadkare kadɨ Lubə a̰ ndó né dow-je ɓá pa-né ta-je kinlé. Dow ya kàrè uwə-é al, kdɔtalə dɔkàdɨ̀ liə asɨ al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jeju təl idə-dé ɓəy panè: Mꞌa kɔw, sə̰i a sangi-mi ə sə̰i a koyi dan majal-je-tɨ lə-si. Lo kɨ́ mꞌa kɔw-tɨ lé, sə̰i a kasi kɔwi-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jipɨ-je ꞌpanè ḛ ɔw kɨ̀ tɔl rɔ-é ɔbɨ. Kdɔ ḛ panè: Lo kɨ́ mꞌa kɔw-tɨ lé sə̰i a kasɨ kɔwi-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jeju ilə-dé-tɨ panè: Sə̰i ꞌtoi kɨ́ dɔnangɨ-tɨ nè, ngà ma̰ mꞌto kɨ́ taá dɔra̰-tɨ. Sə̰i ꞌtoi kɨ́ ꞌlə dɔnangɨ, ngà ma̰ mꞌto kɨ́ ꞌlə dɔnangɨ al. ");
INSERT INTO mge_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gin-é kin ɓá mꞌidə-si-né mꞌpanè a koyi dan majal-je-tɨ lə-si. Kdɔ kinə adi mḛḛ-si kɨ́ ma̰ mꞌto njèkisɨ lé al rəmə, a koyi dan majal-je-tɨ lə-si ya. ");
INSERT INTO mge_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ə dḛ ꞌdəjɨ-é ꞌpanè: I ꞌto ná̰? Rəmə Jeju ilə-dé-tɨ panè: Ta kinlé lo kulə gin-é-tɨ nṵ ya mꞌidə-si! ");
INSERT INTO mge_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mꞌɔw kɨ̀ ta-je n̰a̰ kɨ́ sɔbɨ dɔ-si kadɨ mꞌpa rəm, kadɨ mꞌgangta dɔ-tɨ rəm. Ngà njèkulə-m lé to njèpata kɨ́ tɔgrɔ-tɨ ə ta kɨ́ mꞌoo ta-é-tɨ ɓá mꞌpa mꞌadɨ dow-je kɨ́ dɔnangɨ-tɨ nè. ");
INSERT INTO mge_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta kɨ́ Jeju idə-dé lé dḛ ꞌgə kɨ́ to ta kɨ́ sɔbɨ dɔ Bɔbɨ-é Lubə al. ");
INSERT INTO mge_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Beɓa Jeju idə-dé panè: «Lokɨ a kuni Ngon lə dow kɨ́ taá ɓá a gəi kɨ́ ma̰ lé mꞌto njèkisɨ rəm, mꞌra né kɨ̀ dɔ rɔ-m al rəm. Ngà né kɨ́ Bɔbɨ-m ndó-m ɓá mꞌidə dow-je. ");
INSERT INTO mge_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Njèkulə-m lé a̰ sə-m natɨ. Ḛ in̰ə-m kɨ̀ kár-m al. Kdɔtalə ma̰ mꞌra né-je kɨ́ nəl-é kɨ̀ ndɔ-je lay.» ");
INSERT INTO mge_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lokɨ Jeju pa ta-je kin bè lé, dow-je n̰a̰ dꞌadɨ-é mḛḛ-dé. ");
INSERT INTO mge_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Beɓa ḛ idə jipɨ-je kɨ́ dꞌadɨ-é mḛḛ-dé lé panè: «Kinə a̰i dɔ ta-tɨ lə-m njángɨ rəmə, sə̰i ꞌtoi njéndó né-je lə-m kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sə̰i a gəi ta kɨ́ tɔgrɔ-tɨ ə ta kɨ́ tɔgrɔ-tɨ à taa-si kilə-si taá.» ");
INSERT INTO mge_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dḛ dꞌilə-é-tɨ panè: «Jḛ jꞌto nganka Abrakam ə jḛ jꞌto ɓə-je lə dow nja káre al, ngà ban ɓá i ꞌpanè ta kɨ́ tɔgrɔ-tɨ à taa-ji kilə-ji taá ɓəy wa?» ");
INSERT INTO mge_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jeju ilə-dé-tɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ rá-rá kɨ́ ra majal lé to ɓə lə majal. ");
INSERT INTO mge_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ə ɓə lé ḛ à kisɨ mḛḛ kəy-tɨ lə ꞌɓa-é sar al, ngà ngon lə njékəy ɓá à kisɨ-tɨ sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Beɓa kinə ma̰ Ngon lə Lubə ya mꞌtaa-si mꞌilə-si taá rəmə, a toi ɓə-je al ya tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mꞌgə kɨ́ sə̰i ꞌtoi nganka Abrakam ya ngà sə̰i ꞌsangi kdɔ tɔli-mi, kdɔtalə ꞌmbati ta lə-m. ");
INSERT INTO mge_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma̰ mꞌpa ta dɔ né-tɨ kɨ́ mꞌoo rɔ Bɔbɨ-m-tɨ ə sə̰i kàrè ta kɨ́ ooi ta bɔbɨ-si-tɨ ɓá ꞌrai-né né tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dḛ dꞌilə-é-tɨ ꞌpanè: «Jḛ jꞌto kɨ́ gin ka-tɨ lə Abrakam.» Ə Jeju idə-dé panè: Kinə ꞌtoi kɨ́ gin ka-tɨ lə Abrakam rəmə, ꞌrai kullə ra Abrakam tɔ ɓane. ");
INSERT INTO mge_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngà kɨ́ ngɔsnè kinlé sə̰i ꞌndigi ꞌtɔli-mi, ma̰ kɨ́ mꞌidə-si ta kɨ́ tɔgrɔ-tɨ kɨ́ mꞌoo ta Lubə-tɨ. Né-é kin to né kɨ́ Abrakam ra al. ");
INSERT INTO mge_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngà sə̰i lé ꞌrai kullə ra bɔbɨ-si. Dḛ dꞌidə-é panè: «Jḛ ꞌto ngan-je kɨ́ bɔbɨ-ji goto al. Bɔbɨ-ji ra káre-rè ə to Lubə.» ");
INSERT INTO mge_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jeju idə-dé panè: «Kinə Lubə ya to Bɔbɨ-si rəmə lé a ndigi-mi, kdɔ mꞌḭ rɔ Lubə-tɨ ɓá mꞌree; mꞌree kɨ̀ dɔ rɔ-m al, ngà to ḛ ɓá ulə-m. ");
INSERT INTO mge_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kdɔ ri ɓá sə̰i ꞌgəi mḛḛ ta lə-m al wa? Kdɔ sə̰i asi ndigi dɔ ta-tɨ lə-m al. ");
INSERT INTO mge_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sə̰i lé, bɔbɨ-si to Sú, adɨ sə̰i ꞌndigi rai né-je kɨ́ mḛḛ bɔbɨ-si ndigɨ. Ḛ to njétɔl dow-je lo kulə gin-é-tɨ nṵ ə ḛ a̰ dɔ ta kɨ́ tɔgrɔ-tɨ al, kdɔ ta kɨ́ tɔgrɔ-tɨ goto ta-é-tɨ. Lokɨ ḛ ədɨ ta lé, to ta-je liə kɨ́ mḛḛ-é-tɨ ya ɓá ḛ tḛḛ-né tin; kdɔ ḛ to njèkədta rəm, ɓá to bɔbɨ njékədta-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngà ma̰ lé, sə̰i adi-mi mḛḛ-si al kdɔ mꞌpa ta kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ná̰ dan-si-tɨ asɨ tɔjɨ kɨ́ mꞌra majal wa? Kinə mꞌpa ta kɨ́ tɔgrɔ-tɨ lé, kdɔ ri ɓá sə̰i adi-mi mḛḛ-si al wa? ");
INSERT INTO mge_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dow kɨ́ to kɨ́ lə Lubə lé oo ta lə Lubə. Sə̰i ooi ta lə Lubə al, kdɔ sə̰i ꞌtoi kɨ́ liə al.» ");
INSERT INTO mge_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jipɨ-je dꞌilə Jeju-tɨ ꞌpanè: «Pa kɨ́ jꞌpanè i ꞌto dow kɨ́ dɔnangɨ Samari-tɨ rəm, ꞌɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-i-tɨ rəm kinlé to tó-é ya al wa?» ");
INSERT INTO mge_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Beɓa Jeju ilə-dé-tɨ panè: «Mꞌɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-m-tɨ al. Ngà ma̰ mꞌto dow kɨ́ mꞌun ta Bɔbɨ-m, ngà sə̰i ɓá uni ta-m al. ");
INSERT INTO mge_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma̰ mꞌsangɨ riɓa lə-m al; dow káre kɨ́ njèsangɨ riɓa lə-m kɨ̀ njèkadɨ najɨ ya isɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ooi majɨ, mꞌa kidə-si rəsɨ; kinə dow təl rɔ-é go ta-tɨ lə-m lé, à koy nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Beɓa jipɨ-je dꞌidə-é ꞌpanè: «Kɨ́ nè kinlé, jꞌgə kɨ́ ɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-i-tɨ nɔ̰ɔ̰. Abrakam oy, njépata-je kɨ́ ta Lubə-tɨ kàrè dꞌoy tɔ ə i panè: “Kinə dow təl rɔ-é go ta-tɨ lə-m lé, à koy nda̰ al.” ");
INSERT INTO mge_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Sé i ꞌboy itə ka-ji Abrakam kɨ́ oy lé wa? Njépata-je kɨ́ ta Lubə-tɨ kàrè dꞌoy rəm, ngà i oo rɔ-i kɨ ná̰ ya wa?» ");
INSERT INTO mge_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jeju ilə-dé-tɨ panè: «Kinə ma̰ ya mꞌɔsɨ gajɨ rɔ-m rəmə, kɔsɨ gajɨ rɔ lə-m to né kɨ́ kɔgɨ kare. To Bɔbɨ-m ɓá ɔsɨ gajɨ-m ə ḛ ɓá sə̰i ꞌpainè to Lubə lə-si! ");
INSERT INTO mge_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ə sə̰i ꞌgəi-é al; ngà ma̰ mꞌgə-é. Kinə mꞌpanè mꞌgə-é al rəmə, mꞌa to njèkədta madɨ-si tɔ. Ngà mꞌgə-é rəm, ɓá mꞌtəl rɔ-m go ta-tɨ liə rəm. ");
INSERT INTO mge_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ka-si Abrakam ra rɔnəl n̰a̰, lokɨ ḛ gɨr kɨ́ nꞌa koo ndɔ ree lə-m. Ḛ oo ndɔ ree lə-m ə ra-né rɔnəl.» ");
INSERT INTO mge_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Rəmə jipɨ-je ꞌpa siə ꞌpanè: «I kan, ꞌra ɓal kɔrmḭ al ɓəy ya rəmə i ꞌɓa rɔ-i njèkoo Abrakam al ɓan wa!» ");
INSERT INTO mge_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jeju idə-dé panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; kete ɓá kadɨ Abrakam isɨ lé, ma̰ mꞌisɨ nɔ̰ɔ̰ ngá.» ");
INSERT INTO mge_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Rəmə dḛ ꞌkote ər-je kdɔ tilə-é-né, ngà Jeju ɔtɨ ɓɔyɔ rɔ-é ə ɔtɨ rangɨ takəy-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jeju isɨ dəə rəmə, oo dingəm kɨ́ kəm-é tɔɔ lo kojɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Beɓa njéndó né-je liə ꞌdəjɨ-é ꞌpanè: Njèndó dow-je né, dingəm kanlé, njékojɨ-é-je ɓá ꞌra majal əse to dajɨ rɔ-é ya ɓá ra majal ɓá kəm-é tɔɔ-né lo kojɨ-é-tɨ bè wa? ");
INSERT INTO mge_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jeju idə-dé panè: To ta lə majal liə əse majal lə njékojɨ-é-je ɓá kəm-é tɔɔ-né tin al; ngà tò bè kdɔ kadɨ Lubə ɔjɨ-né tɔ́gɨ-é ndaa-tɨ rəsɨ takəm dow-je-tɨ kɨ̀ takul-é. ");
INSERT INTO mge_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kada nè kin ya adi jꞌrai kullə-je lə njèkulə-m; kdɔ kinə ndɔ il rəmə, dow à kasɨ ra kullə al ngá. ");
INSERT INTO mge_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lokɨ mꞌisɨ dɔnangɨ-tɨ nè ɓəy lé, mꞌto londógɨ lə dɔnangɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jeju pa ta kin bè ngá ɓá tubə man ta-é nangɨ lɔ̰y-né nangɨ, ɔr kəm njèkəmtɔ-tɨ lé ");
INSERT INTO mge_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ə idə-é panè: ꞌƆw ꞌtogɨ kəm-i man dangɨ-tɨ kɨ́ ꞌɓa-é Silowe kɨ́ kɔr mḛḛ-é to: Ngonnjèkullə. Beɓa njèkəmtɔ lé ɔw dangɨ Silowe-tɨ lé ɔw togɨ kəm-é; ə lokɨ isɨ təl rəmə, oo lo. ");
INSERT INTO mge_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Beɓa njétakəy-je liə kɨ̀ dow-je kɨ́ kete dꞌoo-é kɨ́ to njèkisɨ kɔy né lé ꞌpanè: Ḛ kan ya ɓá to njèkisɨ kɔy né lé al wa? ");
INSERT INTO mge_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dḛ kɨ́ ná̰-je ꞌpanè: To ḛ ya. Dḛ kɨ́ dan-tɨ-je ꞌpanè: To dow kɨ́ tana̰ siə ɓɨ to ḛ al. Ə ḛ ya panè: To ma̰ ya. ");
INSERT INTO mge_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Beɓa dḛ ꞌdəjɨ-é ꞌpanè: Ra ban ɓá kəm-i lé oo lo wa? ");
INSERT INTO mge_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Njèkəmtɔ lé ilə-dé-tɨ panè: Dingəm kɨ́ ꞌɓa-é Jeju ɓá lɔ̰y nangɨ ɔr kəm-m-tɨ ə idə-m panè: ꞌƆw ꞌtogɨ kəm-i man dangɨ-tɨ kɨ́ ꞌɓa-é Silowe. Beɓa mꞌɔw mꞌtogɨ kəm-m ya rəmə kəm-m oo lo. ");
INSERT INTO mge_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Dḛ ꞌdəjɨ-é ꞌpanè: Dingəm lé a̰ rá wa? Ḛ kɨ́ kete to njèkəmtɔ lé panè: Mꞌoo lo kɨ́ ɔw-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Rəmə dḛ dꞌɔr ḛ kɨ́ kete to njèkəmtɔ lé dꞌɔw siə rɔ Parisi-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ə to ndɔ taakoo-tɨ lə jipɨ-je ɓá Jeju lɔ̰y-né nangɨ ɔr kəm-é-tɨ adɨ-é oo-né lo tin. ");
INSERT INTO mge_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Beɓa Parisi-je lé kàrè ꞌdəjɨ ḛ kɨ́ kete to njèkəmtɔ lé se ra ban ɓá kəm-é lé oo lo wa? Ḛ idə-dé panè: Ḛ lɔ̰y nangɨ ɔr kəm-m-tɨ ə mꞌɔw mꞌtogɨ rəmə mꞌoo lo. ");
INSERT INTO mge_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lokɨ ḛ pa ta kin bè rəmə, Parisi-je kɨ́ ná̰-je ꞌpanè: To dow kɨ́ ḭ rɔ Lubə-tɨ al, kdɔtalə ilə kujɨ dɔ ndɔ taakoo-tɨ al. Ngà dḛ kɨ́ dan-tɨ-je ꞌpanè: Dow kɨ́ to njèramajal lé, à ra ban ɓá à ra nékɔjɨ-je kɨ́ titɨ-na̰ bè kin wa? ");
INSERT INTO mge_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ra adɨ gángɨ-na̰ tò dan-dé-tɨ. Beɓa dḛ ꞌtəl ꞌdəjɨ-é ɓəy ꞌpanè: I ya bè lé, ta ri ɓá i pa dɔ dow-tɨ kɨ́ adɨ kəm-i oo lo lé wa? Njèkəmtɔ lé ilə-dé-tɨ panè: Ḛ to njèpata kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ꞌBoy-je lə jipɨ-je lé ꞌmbatɨ ndigɨ dɔ-tɨ kɨ́ dingəm kinlé kete to njèkəmtɔ ɓá ngɔsnè təl oo lo, adɨ dḛ ꞌɓa njékojɨ-é-je dꞌadɨ ꞌree. ");
INSERT INTO mge_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Beɓa ꞌdəjɨ-dé ꞌpanè: Ḛ kanlé to ngon-si kɨ́ sə̰i ꞌpainè kəm-é tɔɔ lo kojɨ-é-tɨ lé ya ɓan wa? Ngà ra ban ɓá kɨ́ nè kin oo lo wa? ");
INSERT INTO mge_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Njékojɨ-é-je lé ꞌpanè: Jḛ jꞌgə kɨ́ to ngon-ji ə kəm-é tɔɔ lo kojɨ-é-tɨ nṵ ya. ");
INSERT INTO mge_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngà kəm rəbɨ kɨ́ ḛ oo-né lo ngá kin kàrè jꞌgə al rəm, ɓá dow kɨ́ adɨ kəm-é oo lo kin kàrè, jꞌgə-é al rəm tɔ. Sə̰i ya ꞌdəji-é ooi. Tɔgɨ gangɨ asɨ pa ta dɔ rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Njékojɨ-é-je lé ꞌpa bè kdɔ dḛ ꞌɓəl ꞌboy-je lə jipɨ-je. Kdɔtalə ta-dé asɨ-na̰ kadɨ kinə dow kɨ́ rá-rá ya panè Jeju to Kristɨ rəmə, kadɨ ꞌtubə-é kɔgɨ kəykəwna̰-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gin-é kin ɓá njékojɨ-é-je ꞌpa-né ꞌpanè: To dow kɨ́ tɔgɨ gangɨ ə́n ə́ ꞌdəji-é ooi. ");
INSERT INTO mge_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Beɓa dingəm kɨ́ kete to njèkəmtɔ lé, Parisi-je ꞌtəl ꞌɓa-é ɓa kɨ́ nja joo ə dꞌidə-é ꞌpanè: ꞌPa ta kɨ́ tɔgrɔ-tɨ ꞌɔsɨ-né gajɨ Lubə. Jḛ jꞌgə kɨ́ dingəm kinlé to njèramajal. ");
INSERT INTO mge_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ḛ ilə-dé-tɨ panè: Lé ḛ to njèramajal ya kàrè, ma̰ mꞌgə al. Ngà né káre kɨ́ mꞌgə ə́n: Kete mꞌto njèkəmtɔ ə ngɔsnè mꞌoo lo. ");
INSERT INTO mge_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dḛ ꞌdəjɨ-é ꞌpanè: Ri ɓá ḛ ra sə-i wa? Ḛ ra ban ɓá adɨ kəm-i lé oo lo wa? ");
INSERT INTO mge_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ḛ idə-dé panè: Ta kinlé mꞌpa kete ya sə̰i ooi al; ngà kdɔ ri ɓá sə̰i ꞌndigi kadɨ mꞌtəl mꞌidə-si ya ɓəy wa? Sə̰i kàrè ꞌndigi təli njéndó né-je liə tɔ wa? ");
INSERT INTO mge_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dḛ ꞌtajɨ-é ə ꞌpanè: I ɓá ꞌto njèndó né liə; jḛ jꞌto njéndó né-je lə Moiyijɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moiyijɨ lé, jḛ jꞌgə kɨ́ Lubə pa siə ta; ngà dow kanlé, jḛ jꞌgə lo kɨ́ tḛḛ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ḛ ilə-dé-tɨ panè: Ooi, né kɨ́ tò ɓəl ə́n: Jeju lé, sə̰i ꞌgəi lo kɨ́ ḭ-tɨ al ə ḛ ɓá adɨ kəm-m oo lo tin. ");
INSERT INTO mge_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jə̰i jꞌgəi kɨ́ Lubə oo ta lə njéramajal-je al. Ngà dow kɨ́ rá-rá kɨ́ ilə kujɨ dɔ Lubə-tɨ ə ra né kɨ́ mḛḛ Lubə ndigɨ lé, dowbé kin ɓá Lubə oo ta liə. ");
INSERT INTO mge_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dow kɨ́ kəm-é tɔɔ lo kojɨ-é-tɨ ya dow adɨ kəm-é oo lo adɨ jꞌoo ta-é nja káre al ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dingəm kɨ́ adɨ kəm-m oo lo kinlé, kinə ḭ rɔ Lubə-tɨ al lé, né káre ya kàrè à kasɨ ra al. ");
INSERT INTO mge_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ꞌBoy-je lə jipɨ-je dꞌilə-é-tɨ ꞌpanè: I kɨ́ ꞌto njèramajal kɨ́ kojɨ kəy kin ya ɓá ꞌɓa rɔ-i njèndó-ji né al ɓan! Beɓa ꞌtubə-é lo kəwna̰-tɨ lə-dé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jeju oo ta tubə kɨ́ ꞌtubə-é lé ə lokɨ ingə-é rəmə dəjɨ-é panè: ꞌAdɨ mḛḛ-i Ngon lə dow wa? ");
INSERT INTO mge_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ḛ dəjɨ Jeju panè: ꞌƁaɓe, Ngon lə dow ə to ná̰ ɓá kadɨ mꞌadɨ-é mḛḛ-m wa? ");
INSERT INTO mge_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jeju idə-é panè: Ngon lə dow lé, i oo-é ngá, to ma̰ kɨ́ ma̰ mꞌpa sə-i ta nè kin ya. ");
INSERT INTO mge_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Beɓa ḛ panè: Mꞌadɨ-i mḛḛ-m, ꞌƁaɓe, ə ɔsɨ dɔ-é nangɨ nɔ̰̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Go-tɨ, Jeju panè: Mꞌree dɔnangɨ-tɨ nè kdɔ gangta. Kdɔ kadɨ njékəmtɔ-je dꞌoo lo ə njékoo lo-je ꞌtəl njékəmtɔ-je tɔ. ");
INSERT INTO mge_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lokɨ Parisi-je kɨ́ dan-tɨ-je kɨ́ dꞌa̰ siə natɨ dꞌoo ta-je kin bè lé, ꞌpa siə ꞌpanè: Jḛ kàrè jꞌto njékəmtɔ-je tɔ wa? ");
INSERT INTO mge_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jeju ilə-dé-tɨ panè: Kinə ꞌtoi njékəmtɔ-je rəmə, lé majal lə-si à goto. Ngà kɨ́ ngɔsnè-tɨ kin sə̰i ꞌpainè: Jḛ jꞌto njékoo lo-je. Beɓa majal lə-si tò lo tò-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«Ooi majɨ, mꞌa kidə-si rəsɨ; kinə dow andɨ go batɨ-je-tɨ kɨ̀ tarəbɨ gali al, ngà al kɨ̀ dɔ gali kəl-é-tɨ kɨ́ rangɨ lé dowbé to njèɓogɨ, to bɔkaya. ");
INSERT INTO mge_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngà dow kɨ́ andɨ kɨ̀ tarəbɨ gali lé to njèkul batɨ-je. ");
INSERT INTO mge_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Njèngəm takəy tḛḛ tarəbɨ adɨ-é ə batɨ-je dꞌoo ndi-é. Rəmə batɨ-je kɨ́ ꞌto ꞌliə lé, ḛ ɓa-dé kɨ̀ ri-dé ri-dé, ə ɔr nɔ̰̀-dé tḛḛ sə-dé ndaa-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lokɨ ḛ adɨ batɨ-je liə ꞌtḛḛ ndaa-tɨ lay rəmə, ḛ njiyə nɔ̰̀-dé-tɨ, ə batɨ-je lé ꞌndole go-é kdɔ dḛ ꞌgə ndi-é. ");
INSERT INTO mge_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dow kɨ́ to mba lé, batɨ-je dꞌa ka̰y-é ka̰ ngərəngɨ ɓɨ dꞌa ndole go-é al; kdɔ dḛ ꞌgə ndi mba-je al.» ");
INSERT INTO mge_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Dow-je ꞌgə mḛḛ gosta kɨ́ Jeju pa sə-dé kinlé al. ");
INSERT INTO mge_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Beɓa Jeju təl pa ɓəy panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; ma̰ mꞌto tarəbɨ kəy lə batɨ-je. ");
INSERT INTO mge_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dḛ lay kɨ́ ꞌree nɔ̰̀-m-tɨ kete lé, ꞌto njéɓogɨ-je kɨ̀ bɔkaya-je, adɨ batɨ-je dꞌoo ta lə-dé al. ");
INSERT INTO mge_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma̰ mꞌto tarəbɨ, adɨ kinə dow andɨ kɨ̀ tarəbɨ kɨ́ rɔ-m-tɨ rəmə, à kajɨ; ḛ à kandɨ rəm, à tḛḛ rəm, ɓá à kingə nékuso rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngà njèɓogɨ lé, ḛ ree kdɔ ɓogɨ né rəm, tɔl né rəm, ɓá tujɨ né rəm. Ngà ma̰ mꞌree kdɔ kadɨ dow-je dꞌisɨ kəm ə kadɨ kiskəm lə-dé kinlé majɨ-é al dɔ lo rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ma̰ mꞌto njèkul batɨ-je kɨ́ majɨ. Njèkul batɨ-je kɨ́ majɨ lé, ilə rɔ-é kɔgɨ kdɔ batɨ-je liə. ");
INSERT INTO mge_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngà njèrakullə là kɨ́ to njèkul batɨ-je kɨ́ tɔgrɔ-tɨ al, adɨ ꞌto batɨ-je liə al rəm lé, lokɨ ḛ oo jagɨm isɨ ree rəmə, tusɨ batɨ-je in̰ə-dé a̰y adɨ jagɨm ree tuwə-dé ə sane ndəgɨ-é-je katɨ-katɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dow kinlé ra bè kdɔ ḛ to njèrakullə là adɨ usɨ-é dɔ batɨ-je-tɨ al. Ma̰ mꞌto njèkul batɨ-je kɨ́ majɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mꞌgə batɨ-je lə-m rəm, batɨ-je lə-m kàrè ꞌgə-m rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Titɨ kɨ́ Bɔbɨ-m gə-m-né lé, ma̰ kàrè mꞌgə Bɔbɨ-m tɔ ə mꞌilə rɔ-m kɔgɨ kdɔ batɨ-je lə-m. ");
INSERT INTO mge_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mꞌɔw kɨ̀ batɨ-je kɨ́ rangɨ nɔ̰ɔ̰, ngà goto ɓá ꞌgoto mḛḛ gali-tɨ nè ɓəy. Dḛ kinlé tò kadɨ mꞌree sə-dé; dḛ dꞌa koo ndi-m ə dꞌa to nékul-je kɨ́ káre-rè rəm, njèkul-dé à ꞌra káre-rè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bɔbɨ-m ndigɨ-m kdɔ kilə kɨ́ mꞌilə rɔ-m kɔgɨ kdɔ kadɨ mꞌtəl mꞌisɨ kəm gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma̰ ya mꞌilə rɔ-m kɔgɨ kɨ̀ mḛḛ ndigɨ lə-m ɓɨ dow à tɔl-m kɨ̀ dɔ rɔ-é al. Mꞌɔw kɨ̀ tɔ́gɨ kadɨ mꞌilə rɔ-m kɔgɨ rəm, ɓá mꞌɔw kɨ̀ tɔ́gɨ kadɨ mꞌtəl mꞌisɨ kəm gogɨ rəm; ḛ ɓá to ndu kɨ́ mꞌingə rɔ Bɔbɨ-m-tɨ.» ");
INSERT INTO mge_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta-je kinlé ra adɨ gángɨ-na̰ tò dan jipɨ-je-tɨ rangɨ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Dow-je n̰a̰ dan-dé-tɨ ya ꞌpanè: «Ḛ ɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-é-tɨ rəm, to mbə́ rəm. Ngà kdɔ ri ɓá ooi ta liə wa?» ");
INSERT INTO mge_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dḛ kɨ́ madɨ-je ꞌpanè: «Ta-je liə to ta lə dow kɨ́ ɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-é-tɨ al. Sé dow kɨ́ ɔw kɨ̀ ndil kɨ́ majɨ al mḛḛ-é-tɨ lé à kasɨ kadɨ njèkəmtɔ oo lo tɔ wa?» ");
INSERT INTO mge_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ndɔ káre bè ꞌra na̰y kəy lə Lubə mḛḛ ɓebo Jorijalḛm-tɨ na̰y kul-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeju njiyə ndó rɔ-é takəy-tɨ lə Lubə gin pal-tɨ lə Salomɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Rəmə ꞌboy-je lə jipɨ-je dꞌilə-na̰ ꞌgəə dɔ-é ə dəjɨ-é ꞌpanè: «Kàdɨ̀ ban ɓá i a kadɨ mḛḛ-ji usɨ nangɨ wa? Kinə i ya ꞌto Kristɨ lé rəmə ꞌidə-ji rəsɨ.» ");
INSERT INTO mge_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jeju ilə-dé-tɨ ꞌpanè: «Ma̰ mꞌidə-si ya ngà sə̰i ooi kɨ ta kɨ́ tɔgrɔ-tɨ al. Kullə-je kɨ́ mꞌra kɨ̀ ri Bɔbɨ-m kin ya asɨ kadɨ ꞌgəi-mi-né. ");
INSERT INTO mge_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngà sə̰i adi mḛḛ-si al kdɔ sə̰i ꞌtoi kɨ́ dan batɨ-je-tɨ lə-m al. ");
INSERT INTO mge_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Batɨ-je lə-m dꞌoo ndi-m ꞌgə; ma̰ mꞌgə-dé ə dḛ ꞌndole go-m. ");
INSERT INTO mge_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma̰ mꞌadɨ-dé kiskəm kɨ́ sartagangɨ; dḛ dꞌa koy nda̰ al rəm, ɓá dow à kasɨ taa-dé ji-m-tɨ al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bɔbɨ-m kɨ́ adɨ-m-dé lé, tɔ́gɨ-é itə tɔ́gɨ-je lay ə dow kɨ́ asɨ taa-dé ji Bɔbɨ-m-tɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma̰ lé, jḛ kɨ̀ Bɔbɨ-m jꞌto dow-je kɨ́ káre-rè.» ");
INSERT INTO mge_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nja káre ya ɓəy, jipɨ-je dꞌɔy ər-je kdɔ tilə-é-né tɔl-é. ");
INSERT INTO mge_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Beɓa ḛ idə-dé panè: «Mꞌra kullə-je kɨ́ majɨ-majɨ n̰a̰ kɨ́ ḭ rɔ Bɔbɨ-m-tɨ mꞌadɨ ooi. Dan kullə-je-tɨ kɨ́ mꞌra kinlé ḛ kɨ́ rá ɓá ꞌndigi ꞌtiləi-mi kɨ̀ ər kdɔ wa?» ");
INSERT INTO mge_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ə ꞌboy-je lə jipɨ-je lé dꞌilə-é-tɨ ꞌpanè: «Jḛ jꞌndigɨ tɔl-i kdɔ kullə-je kɨ́ majɨ-majɨ kin al; ngà kdɔ i kɨ́ ꞌto dow ya rəmə ꞌɓa rɔ-i Lubə, adɨ ta kin to takɔbɨ!» ");
INSERT INTO mge_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jeju ilə-dé-tɨ panè: «Mḛḛ ndukun-je-tɨ lə-si lé ꞌndàngɨ panè: “Ma̰ Lubə mꞌpanè sə̰i ꞌtoi lubə-je.” ");
INSERT INTO mge_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dow-je kɨ́ Lubə pa sə-dé ta ya ɓá ndukun ɓa-dé lubə-je lé al wa! Ə ta kɨ́ mbete kɨ́ aa njay pa lé dow à kɔr kɔgɨ al rəm tɔ! ");
INSERT INTO mge_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma̰ lé, Bɔbɨ-m ɔr-m ində-m tagay ə ulə-m dɔnangɨ-tɨ nè, rəmə sə̰i ꞌpainè: “Mꞌpa ta kɔbɨ dɔ Lubə-tɨ.” Kdɔ pa kɨ́ mꞌpanè: “Mꞌto Ngon lə Lubə.” ");
INSERT INTO mge_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kinə mꞌra kullə-je lə Bɔbɨ-m al rəmə, adi-mi mḛḛ-si al! ");
INSERT INTO mge_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngà kinə kullə-je kɨ́ mꞌra lé to kullə-je lə Bɔbɨ-m ya, ə́ kinə ma̰ ɓá lé adi-mi mḛḛ-si al kàrè rəmə, adi mḛḛ-si kullə ra-m-je kinlé ɓəl ɓane. Beɓa a gəi majɨ yə́rə́rə́ kɨ́ Bɔbɨ-m to kɨ́ lə-m ə ma̰ mꞌto kɨ́ lə Bɔbɨ-m tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Dḛ ꞌtəl ꞌsangɨ kadɨ dꞌuwə-é, ngà ḛ tḛḛ ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Beɓa Jeju təl ɔw gidɨ ba Jurdḛ-tɨ gogɨ, lo-tɨ kɨ́ Ja̰ ulə gin ra dow-je batḛm-tɨ ə ḛ isɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dow-je n̰a̰ ya ꞌree rɔ-é-tɨ ə ꞌpanè: «Nékɔjɨ káre ya kàrè Ja̰ ra al, ngà ta-je lay kɨ́ Ja̰ pa dɔ dow-tɨ kinlé to ta kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lo-é-tɨ kinlé dow-je n̰a̰ ya dꞌadɨ mḛḛ-dé Jeju.» ");
INSERT INTO mge_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dingəm káre bè kɨ́ ri-é lə Lajar ɓá rɔ-é to-é. Ḛ to dow kɨ́ mḛḛ ɓe-tɨ kɨ́ Betani kɨ́ to ɓekojɨ Mari dḛ kɨ̀ ngonkɔ̰-é Martɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari kinlé ɓá ndɔkɨ ur ubɨ dɔ ꞌƁaɓe-tɨ ə uwə bəl dɔ-é bɔr-né nja-é lé. Ḛ to kɔ̰nan Lajar kɨ́ rɔ-é to-é lé. ");
INSERT INTO mge_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ngankɔ̰-na̰-je kɨ́ dené kɨ́ joo kinlé dꞌulə kullə dꞌidə Jeju ꞌpanè: «ꞌƁaɓe, ḛ kɨ́ i ꞌndigɨ-é lé, rɔ-é to-é.» ");
INSERT INTO mge_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lokɨ Jeju oo ta kinlé rəmə panè: Mɔ̰y kinlé à tḛḛ koy al. To mɔ̰y kɨ́ à ra kadɨ ri Lubə ɓa-né rəm, ɓá kɨ̀ takul mɔ̰y kinlé ya dow-je dꞌa kɔsɨ-né gajɨ Ngon lə Lubə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martɨ kɨ̀ ngonkɔ̰-é Mari, kɨ̀ kɔ̰nan-dé Lajar lé ꞌto dow-je kɨ́ Jeju ndigɨ-dé. ");
INSERT INTO mge_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lokɨ Jeju oo ta rɔto lə Lajar lé, ḛ isɨ lo kɨ́ isɨ-tɨ lé ya ra ndɔ joo go-tɨ ɓəy; ");
INSERT INTO mge_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ngà ɓá idə njéndó né-je liə panè: «Jꞌtəli jꞌɔwi dɔnangɨ Jude-tɨ gogɨ.» ");
INSERT INTO mge_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Rəmə njéndó né-je liə dꞌidə-é ꞌpanè: Njèndó dow-je né, i kɨ́ ngɔsnè ɓəy ə́ jipɨ-je ꞌsangɨ kdɔ tilə-i kɨ̀ ər tɔl-i lé ya ꞌge təl kɔw dɔnangɨ Jude-tɨ gogɨ ɓəy wa! ");
INSERT INTO mge_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jeju ilə-dé-tɨ panè: Lo kɨ́ kada lé, kàdɨ̀ ra-tɨ dɔgɨ gidɨ-é joo ya al wa? Kinə dow ɔw njiyə kada lé, à dar né al, kdɔ lo ndógɨ dɔnangɨ-tɨ adɨ dowbé oo lo. ");
INSERT INTO mge_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ngà kinə dow njiyə ndɔɔ rəmə, à dar né, kdɔ lo ndógɨ nɔ̰̀-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jeju pa ta-je kinlé bè ngà ɓá idə njéndó né-je liə panè: Nam-ji Lajar lé tò ɓi ə́ mꞌa kɔw ndəl-é ɓane. ");
INSERT INTO mge_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ə njéndó né-je ꞌpanè: ꞌƁaɓe, kinə tò ɓi lé à kingə lapiya. ");
INSERT INTO mge_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jeju lé pa ta koy lə Lajar, ngà njéndó né-je ꞌgɨr kɨ́ ḛ pa ta lə ɓi kɨ́ tò kare. ");
INSERT INTO mge_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Beɓa Jeju idə-dé rəsɨ panè: Lajar lé oy. ");
INSERT INTO mge_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ə kɨ́ sɔbɨ dɔ-si sə̰i rəmə rɔ-m nəl-m kdɔ goto kɨ́ mꞌgoto siə nṵ. Né kin à ra kadɨ adi-mi-né mḛḛ-si. Ngà adɨ jꞌɔwi kɨ rɔ-é-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Rəmə Tomasɨ kɨ́ ꞌɓa-é Ndungə lé, idə ndəgɨ njéndó né-je panè: Jə̰i kàrè jꞌɔwi, kdɔ kadɨ jꞌoyi kɨ̀ Jeju lé tɔ. ");
INSERT INTO mge_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lokɨ Jeju ɔw tḛḛ rəmə, ḛ oo kɨ́ ꞌdubɨ Lajar ra ndɔ sɔ ngá. ");
INSERT INTO mge_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ə kḭ Betani kɔw Jorijalḛm lé, à kasɨ kulə mɛtər mutə je bè. ");
INSERT INTO mge_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jipɨ-je n̰a̰ ya ꞌree rɔ Martɨ-tɨ kɨ̀ Mari ꞌree ꞌsɔl mḛḛ-dé kdɔ koy lə kɔ̰nan-dé lé. ");
INSERT INTO mge_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lokɨ Martɨ oo kɨ́ Jeju ɔw ree nɔ̰ɔ̰ rəmə, ḛ ḭ ɔw tilə kəm-é, ngà Mari ɓá isɨ nangɨ mḛḛ kəy-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martɨ idə Jeju panè: ꞌƁaɓe, kinə ndɔ-é-tɨ isɨ nè lé, kɔ̰nan-m à koy al. ");
INSERT INTO mge_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngà kɨ́ ngɔsnè-tɨ kin ya kàrè mꞌgə kɨ́ né lay kɨ́ i ꞌdəjɨ Lubə lé, Lubə à ra kadɨ-i. ");
INSERT INTO mge_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jeju idə-é panè: Kɔ̰nan-i lé, à tɔsɨ ndəl kində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ə Martɨ ilə-é-tɨ panè: Mꞌgə kɨ́ dɔbəy ndɔ-tɨ kɨ́ dow-je kɨ́ dꞌoy dꞌa tɔsɨ ndəl kində lo tḛḛ lé, ḛ à tɔsɨ ndəl kində lo tḛḛ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jeju ilə-é-tɨ panè: Ma̰ lé mꞌto njèkadɨ dow-je ꞌtɔsɨ ndəl dꞌində lo ꞌtḛḛ rəm, ɓá mꞌto njèkadɨ dow-je dꞌisɨ kəm rəm tɔ. Dow kɨ́ adɨ-m mḛḛ-é lé, lé oy ya kàrè dowbé à kisɨ kəm rəm, ");
INSERT INTO mge_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ná̰-ná̰ kɨ́ isɨ kɨ̀ dɔ-é taá ə adɨ-m mḛḛ-é lé, à koy nda̰ al. Ta kinlé ꞌoo kɨ́ ta kɨ́ tɔgrɔ-tɨ wa? Martɨ ilə-é-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Oiyo, ꞌƁaɓe, mꞌadɨ mḛḛ-m kɨ́ i ꞌto Ngon lə Lubə, ꞌto Kristɨ kɨ́ tò kadɨ à ree dɔnangɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lokɨ ḛ pa ta kinlé rəmə, ḛ ɔsɨ təl ɔw ɓa ngonkɔ̰-é Mari kɨ̀ kár-é ɓá idə-é ta n̰ɔ̰m-n̰ɔ̰m panè: Njèndó dow-je né ree a̰ nɔ̰ɔ̰ ə́ ɓa-i. ");
INSERT INTO mge_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lokɨ Mari oo ta kinlé taá ya rəmə, ḛ ɔsɨ nangɨ ratɨ ḭ taá ɔw kɨ rɔ Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ə Jeju lé ya kàrè ree tḛḛ mḛḛ ɓe-tɨ al ɓəy. Ngà ḛ a̰ lo-tɨ kɨ́ kete Martɨ tilə kəm-é ingə-é-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lokɨ jipɨ-je kɨ́ dꞌisɨ kɨ̀ Mari mḛḛ kəy-tɨ dꞌisɨ ꞌsɔl mḛḛ-é lé dꞌoo kɨ́ ḛ ubɨ nangɨ ratɨ ḭ taá tḛḛ ndaa-tɨ rəmə, ꞌgɨr kɨ́ isɨ ɔw dɔɓadɨ-tɨ kdɔ kɔw nɔ̰, adɨ dꞌḭ dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lokɨ Mari ree tḛḛ lo-tɨ kɨ́ Jeju a̰-tɨ ɓá oo-é rəmə usɨ nangɨ nja-é-tɨ ə panè: ꞌƁaɓe, kinə ndɔ-é-tɨ isɨ nè lé, kɔ̰nan-m à koy al. ");
INSERT INTO mge_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Lokɨ Jeju oo kɨ́ Mari a̰ nɔ̰ rəm, ɓá jipɨ-je kɨ́ ꞌree siə kàrè dꞌa̰ ꞌnɔ̰ rəm lé mḛḛ-é ḭ puu adɨ dɔ-é təl wəksə. ");
INSERT INTO mge_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Beɓa ḛ dəjɨ-dé panè: Iləi-é lo kɨ́ rá-tɨ wa? Ə dḛ dꞌilə-é-tɨ ꞌpanè: ꞌƁaɓe, ꞌree ə ꞌa koo. ");
INSERT INTO mge_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jeju nɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Rəmə jipɨ-je lé ꞌpanè: Ooi ndigɨ kɨ́ ḛ ndigɨ Lajar tana̰ kin! ");
INSERT INTO mge_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngà dḛ kɨ́ ná̰-je dan-dé-tɨ ꞌpanè: «Ḛ kɨ́ ndɔkɨ adɨ njèkəmtɔ oo lo lé, ra ban ɓá adɨ dingəm kin isɨ kəm tɔ al wa?» ");
INSERT INTO mge_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mḛḛ Jeju təl ḭ puu rangɨ ya ɓəy ə ḛ ɔtɨ ɔw dɔɓadɨ-tɨ. Ɓadɨ lé to bole mbal ɓá dꞌutɨ ta-é kɨ̀ ər. ");
INSERT INTO mge_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jeju panè: ꞌNdubri ər lé kɨ́ rangɨ. Rəmə Martɨ kɨ́ kɔ̰nan njègoto lé idə-é panè: ꞌƁaɓe, nin lé ra ndɔ sɔ adɨ ətɨ ngá. ");
INSERT INTO mge_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ə Jeju idə-é panè: Kete mꞌidə-i mꞌpanè kinə ꞌadɨ-m mḛḛ-i lé ꞌa koo tɔ́gɨ lə Lubə ya al wa? ");
INSERT INTO mge_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Beɓa dow-je ꞌndubru ər lé kɨ rangɨ ə Jeju itə kəm-é kɨ taá ɓá panè: Bɔbɨ-m, mꞌra-i oiyo, kdɔ ta kɨ́ mꞌpa sə-i lé oo ndi-m. ");
INSERT INTO mge_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma̰ rəmə, mꞌgə kɨ́ ndɔ-je lay ya i oo ta kɨ́ mꞌpa sə-i ya, ngà to ta lə kosɨ dow-je kɨ́ ꞌgəə dɔ-m kin ɓá mꞌpa ta kin bè, kdɔ kadɨ ꞌgə kɨ́ tɔgrɔ-tɨ, ma̰ lé, to i ya ɓá ulə-m. ");
INSERT INTO mge_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Lokɨ Jeju pa ta-je kin bè lé, ḛ ilə bɔbɨ ndi-é nangɨ panè: Lajar, ꞌtḛḛ ndaa-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Beɓa njègoto lé ində lo tḛḛ ə nja-é-je kɨ̀ ji-é-je tò kɨ̀ gangɨ-é kɨ́ ꞌɓindɨ-né rəm, ɓá ta kəm-é to kɨ̀ kubɨ kɨ́ ꞌndəm-né lé rəm tɔ. Jeju idə-dé panè: ꞌTuti né-je kɨ́ rɔ-é-tɨ ə in̰əi-é adi-é ɔw. ");
INSERT INTO mge_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jipɨ-je n̰a̰ kɨ́ ree rɔ Mari-tɨ ɓá dꞌoo né kɨ́ Jeju ra lé bè rəmə, dꞌadɨ-é mḛḛ-dé. ");
INSERT INTO mge_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngà dḛ kɨ́ ná̰-je kɨ́ dan-dé-tɨ ꞌtəl dꞌɔw dꞌingə Parisi-je ə ꞌpa ta lə né kɨ́ Jeju ra lé dꞌadɨ-dé. ");
INSERT INTO mge_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Beɓa njékun dɔ njégugné-je, kɨ̀ Parisi-je kɨ́ ꞌto ꞌboy-je kɨ́ njégangta-je lə jipɨ-je lé dꞌingə-na̰ ə ꞌpanè: Ri ɓá jꞌa rai wa? Dingəm kinlé ra nékɔjɨ-je n̰a̰. ");
INSERT INTO mge_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kinə jꞌin̰əi-é jꞌadi-é ra par-par rəmə, dow-je lay ya dꞌa kadɨ-é mḛḛ-dé ə dow-je kɨ́ Rɔm dꞌa ree tujɨ lo lə-ji kɨ́ aa njay kin rəm, ɓá dꞌa tujɨ gin dow-je lə-ji rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dow káre dan ꞌboy-je-tɨ kɨ́ ri-é lə Kayipɨ kɨ́ to burə dɔ njégugné-je ɓal-é-tɨ kinlé, idə-dé panè: Sə̰i lé, né káre ya kàrè ꞌgəi-tɨ al! ");
INSERT INTO mge_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dow káre-rè kɨ́ kadɨ oy ə jipɨ-je lay dꞌoy-né al rəm, ɓá ɓe lə-si kɨ̀ ta tatɨ-é lay tujɨ-né al rəm kinlé to né kɨ́ majɨ n̰a̰ kdɔ-si. Sə̰i ꞌgəi kɨ́ bè kin al wa? ");
INSERT INTO mge_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ta kinlé, to Kayipɨ ya kɨ̀ dɔ-é ɓá ɔjɨ mḛḛ-é-tɨ pa al. Ngà to kɨ́ ḛ to burə dɔ njégugné-je ɓal-é-tɨ kinlé ɓá Lubə ində-né ta kɨ́ sɔbɨ dɔ Jeju ta-é-tɨ adɨ-é pa-né ta lə koy kɨ́ Jeju à koy gangɨ-né dɔ jipɨ-je tin. ");
INSERT INTO mge_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ə ḛ à koy kdɔ jipɨ-je par al, ngà à koy kdɔ kəw-né ngan lə Lubə kɨ́ ꞌsane-na̰ kin kɨ natɨ, təl-dé-né dajɨ rɔ kɨ́ káre-rè. ");
INSERT INTO mge_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ndɔ-é-tɨ kɨ́ dꞌingə-né-na̰ kinlé, dꞌun ndu-dé kadɨ ꞌtɔl Jeju. ");
INSERT INTO mge_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ə gangɨ-é-tɨ kin ya Jeju njiyə-né ndaa-tɨ dan jipɨ-je-tɨ al, adɨ ḛ ɔw kɨ̀ njéndó né-je liə adɨ dꞌisɨ mḛḛ ɓebo-tɨ kɨ́ ꞌɓa-é Eprayim, dɔnangɨ-tɨ kɨ́ tò ngɔsi kɨ̀ diləlo. ");
INSERT INTO mge_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ndɔ ra na̰y Pakɨ lə jipɨ-je nà̰y ngɔsi, adɨ dow-je n̰a̰ dꞌḭ mḛḛ ɓe-je-tɨ lə-dé tin ꞌree ɓebo Jorijalḛm-tɨ kete nɔ̰̀ ndɔ Pakɨ-tɨ, kdɔ kaa rɔ-dé dɔ majal-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dḛ ꞌsangɨ Jeju, adɨ ꞌdəjɨ-na̰ ta takəy-tɨ lə Lubə ꞌpanè: Ḛ lé, sə̰i ꞌgɨri kɨ́ à ree lo ra na̰y-tɨ lé əse à ree al wa? ");
INSERT INTO mge_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ə njékun dɔ njégugné-je, kɨ̀ Parisi-je dꞌun ndu kadɨ kinə dow madɨ gə lo kɨ́ Jeju lé isɨ-tɨ rəmə, nane dɔ-é kadɨ dꞌuwə-é. ");
INSERT INTO mge_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Lokɨ nà̰y ndɔ mɛkḛ ɓəy ɓá ndɔ ra na̰y Pakɨ à kasɨ lé, Jeju ɔw mḛḛ ɓe-tɨ kɨ́ Betani kɨ́ to ɓe lə Lajar kɨ́ ndɔkɨ oy adɨ ꞌdubɨ-é ɓá Jeju adɨ-é tɔsɨ ndəl ində lo tḛḛ lé. ");
INSERT INTO mge_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lo-é-tɨ nɔ̰ɔ̰ lé, ꞌra nékuso dꞌadɨ-é ꞌra-é-né mba. Martɨ ɓá to njèkoo go-dé ə Lajar isɨ kɨ̀ mba-je natɨ ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Beɓa Mari un ubɨ wale kɨ́ ꞌɓa-é nár kɨ́ yə́rə́rə́ adɨ ətɨ majɨ rəm, là-é n̰a̰ rəm ya ree ur nja Jeju-tɨ ɓá bɔr kɨ̀ bəl dɔ-é; ə ba̰y ubɨ lé taa mḛḛ kəy pəl-pəl. ");
INSERT INTO mge_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngà Judasɨ Iskariyotɨ kɨ́ to kɨ́ káre dan njéndó né-je-tɨ lə Jeju kɨ́ ḛ ɓá à to njèkun dɔ-é lé panè: ");
INSERT INTO mge_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ubɨ kinlé kdɔ ri ɓá tokɨ taa-né là kɨ́ à kasɨ kəm kullə kɨ́ ndɔ ɓumutə ə ree ləbɨ njéndoo-je al wa? ");
INSERT INTO mge_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ḛ pa bè lé, to ta ɓá ɔ̰̀ mḛḛ-é kdɔ njéndoo-je al, ngà kdɔtalə ḛ lé to njèɓogɨ; adɨ mbu là kɨ́ tò ji-é-tɨ lé, taá-taá isɨ ɓogɨ là mḛḛ-é-tɨ uso. ");
INSERT INTO mge_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Beɓa Jeju panè: ꞌIn̰ə dené lé jeke; ḛ ra né kin bè ngəbɨ-né ndɔ dubɨ-m. ");
INSERT INTO mge_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Njéndoo-je lé dꞌa kisɨ sə-si kɨ̀ ndɔ-je lay, ngà ma̰ lé, mꞌa kisɨ sə-si kɨ̀ ndɔ-je lay al. ");
INSERT INTO mge_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lokɨ kosɨ jipɨ-je kɨ́ ꞌtò nduy-nduy dꞌoo poy Jeju kɨ́ isɨ mḛḛ ɓe-tɨ kɨ́ Betani nɔ̰ɔ̰ lé, dḛ ꞌree kdɔ kadɨ dꞌoo Jeju rəm, kdɔ kadɨ dꞌoo-né Lajar kɨ́ ndɔkɨ oy ɓá ḛ adɨ-é tɔsɨ ndəl ində lo tḛḛ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Beɓa njékun dɔ njégugné-je dꞌun ndu-dé kadɨ ꞌtɔl Lajar tɔ. ");
INSERT INTO mge_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kdɔ ta liə ɓá jipɨ-je n̰a̰ ya dꞌin̰ə-dé-né ə dꞌadɨ-né mḛḛ-dé Jeju. ");
INSERT INTO mge_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lo aa go-tɨ lé, kosɨ dow-je kɨ́ ꞌtò nduy-nduy kɨ́ ꞌree lo ra na̰y Pakɨ-tɨ, dꞌoo poy Jeju kɨ́ isɨ ɔw kɨ mḛḛ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Beɓa ꞌtə́tɨ balkəm tan-je ji-dé-tɨ ꞌtilə-né kəm-é ə ꞌpa ta kɨ̀ ndi-dé kɨ́ boy-boy ꞌpanè: «Kɔsgajɨ kɨ dɔ-i-tɨ! Kadɨ Lubə tɔr ndi-é dɔ dow-tɨ kɨ́ njèree kɨ̀ ri ꞌƁaɓe kɨ́ to ngar lə Israyel-je.» ");
INSERT INTO mge_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeju ingə ngon koro, ə al isɨ dɔ-é-tɨ titɨ kɨ́ ꞌndàngɨ-né mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ngonmandɨ kɨ́ ɓebo Siyɔ̰-tɨ, ꞌɓəl al. ꞌOo, ngar lə-i isɨ dɔ ngon koro-tɨ isɨ ree. ");
INSERT INTO mge_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dɔkaglo-é-tɨ kinlé, njéndó né-je liə ꞌgə mḛḛ né-je kɨ́ ra né kinlé al ɓəy; ngà lokɨ Lubə ulə riɓa dɔ-é-tɨ ɓəy ɓá mḛḛ-dé ole dɔ-tɨ titɨ kɨ́ né-je kinlé, ꞌndàngɨ ta-é mḛḛ mbete-tɨ ꞌsɔbɨ-né dɔ-é adɨ né-je kinlé, ꞌra kdɔ ta liə. ");
INSERT INTO mge_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kosɨ dow-je kɨ́ ndɔkɨ dꞌa̰ kɨ̀ Jeju natɨ ɓá ɓa-né Lajar ɓe nin-tɨ adɨ-é tɔsɨ ndəl ində lo tḛḛ lé, dꞌɔr poy-é dꞌadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gin-é kin ɓá kosɨ dow-je ꞌtilə-né kəm Jeju; kdɔtalə koo kɨ́ dꞌoo poy nékɔjɨ kɨ́ ndɔkɨ ḛ ra lé. ");
INSERT INTO mge_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Beɓa Parisi-je dꞌidə-na̰ ꞌpanè: Ooi, sə̰i a̰i kare ngá ɓan al! Dow-je lay ya dꞌun go-é. ");
INSERT INTO mge_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grɛkɨ-je madɨ dꞌɔw dan dow-je-tɨ kɨ́ dꞌɔw Jorijalḛm ndɔ ra na̰y Pakɨ-tɨ kdɔ kɔsɨ dɔ-dé nangɨ nɔ̰̀ Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Beɓa dꞌɔw rɔ Pilipɨ-tɨ kɨ́ to dow kɨ́ Betsayda, dɔnangɨ Galile-tɨ ꞌdəjɨ-é ꞌpanè: «ꞌƁa-ji, jꞌndigɨ koo Jeju.» ");
INSERT INTO mge_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Beɓa Pilipɨ ɔw idə Andre, adɨ dḛ joo lay dꞌɔw dꞌidə Jeju. ");
INSERT INTO mge_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeju idə-dé panè: Dɔkaglo asɨ kadɨ Lubə ulə riɓa dɔ Ngon lə dow-tɨ ngá. ");
INSERT INTO mge_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ooi majɨ, mꞌa kidə-si rəsɨ; kinə dow un ka̰a̰ ko dubɨ nangɨ adɨ oy al lé, à ra káre-rè; ngà kinə ꞌdubɨ nangɨ dꞌadɨ oy rəmə, à kubə kdɔ kandɨ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dow kɨ́ ta rɔ-é to-é n̰a̰ rəmə à tujɨ rɔ-é, ngà dow kɨ́ ta rɔ-é to-é al dɔnangɨ-tɨ nè lé, à kajɨ rɔ-é kajɨ kɨ́ sartagangɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kinə dow ndigɨ ra kullə kadɨ-m rəmə, kadɨ dowbé un go-m ə lokɨ ma̰ mꞌisɨ-tɨ lé, lo-é ya ngonnjèkullə lə-m à kisɨ-tɨ tɔ. Kinə dow ra kullə adɨ-m lé, Bɔbɨ-m à kulə riɓa dɔ-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kɨ́ nè kinlé, dɔ-m təl wəksə. Əjè mꞌpanè ri ngá wa? Kadɨ mꞌpanè Bɔbɨ-m, ꞌajɨ-m dɔkaglo-tɨ kin wa? Ngà kɔ̰̀ kin ya ɓá ma̰ mꞌree kdɔ ɓá mꞌtḛḛ-né sar dɔkaglo-tɨ kin tin. ");
INSERT INTO mge_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bɔbɨ-m, ꞌadɨ ri-i ɓa! Rəmə ndi dow ɓa mḛḛ dɔra̰-tɨ panè: Mꞌadɨ ri-m ɓa ə mꞌa təl kadɨ ri-m ɓa ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kosɨ dow-je kɨ́ dꞌa̰ lo-é-tɨ kɨ́ dꞌoo ndi dow lé, ꞌpanè to ndi ɓá ndàngɨ. Dḛ kɨ́ dan-tɨ-je ꞌpanè: To malayka ɓá pa siə ta. ");
INSERT INTO mge_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Beɓa Jeju təl un ta panè: Ndi dow kinlé ɓa kdɔ ta lə-m al ngà ɓa kdɔ ta lə-si. ");
INSERT INTO mge_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kɨ́ ngɔsnè-tɨ kinlé, to dɔkaglo gangta dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè ngá; kɨ́ nè kinlé to dɔkaglo tubə njèkɔ̰ɓe kɨ́ dɔnangɨ-tɨ nè kɔgɨ ngá. ");
INSERT INTO mge_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ngà ma̰ rəmə, lokɨ dꞌa kun-m dɔnangɨ-tɨ nè kɨ taá lé, mꞌa kɔr dow-je lay go-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jeju pa bè kdɔ tɔjɨ-né kəm rəbɨ koy kɨ́ ḛ à koy. ");
INSERT INTO mge_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Beɓa kosɨ dow-je ꞌpanè: Ndukun lə-ji ndó-ji kɨ́ Kristɨ lé à kisɨ kəm sartagangɨ; ngà ban ɓá i ꞌpanè: Tò kadɨ dꞌa kun Ngon lə dow kɨ taá ɓəy wa? Ná̰ ɓá to Ngon lə dow lé wa? ");
INSERT INTO mge_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jeju idə-dé panè: Lo kɨ́ ndógɨ tò dan-si-tɨ nè kɨ mbɔr sḛ ɓəy. Lo kɨ́ ndógɨ kɨ́ ingəi kinlé, ꞌnjiyəi-tɨ kdɔ kadɨ londul ubə-si nangɨ busɨ al. Kdɔtalə dow kɨ́ njiyə londul-tɨ lé, ḛ gə lo kɨ́ isɨ ɔw-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lokɨ lo kɨ́ ndógɨ tò dan-si-tɨ nè ɓəy lé, adi-é mḛḛ-si kdɔ kadɨ ꞌtəli-né ngan-je lə lo kɨ́ ndógɨ. Jeju pa ta kin bè rəmə ɔtɨ ɔw ɓɔyɔ rɔ-é ngərəngɨ sə-dé. ");
INSERT INTO mge_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jeju ra nékɔjɨ-je n̰a̰ takəm-dé-tɨ ya ngà, dḛ dꞌadɨ-é mḛḛ-dé al, ");
INSERT INTO mge_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","bè kdɔ kadɨ ta kɨ́ Ejay kɨ́ njèpata kɨ́ ta Lubə-tɨ pa lé, né-é ra né; ndɔkɨ Ejay panè: ꞌƁaɓe, ta-je kɨ́ jꞌidə-dé kinlé, ná̰ ɓá oo adɨ to ta kɨ́ tɔgrɔ-tɨ wa? Ə ná̰ ɓá ꞌƁaɓe tɔjɨ-é tɔ́gɨ liə adɨ-é oo wa? ");
INSERT INTO mge_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lo kadɨ dꞌadɨ mḛḛ-dé goto, titɨ kɨ́ ndɔkɨ Ejay pa-né ɓəy panè: ");
INSERT INTO mge_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Lubə utɨ kəm-dé kdɔ kadɨ dꞌoo lo al rəm, ɓá Lubə adɨ mḛḛ-dé nga̰ kdɔ kadɨ lé dꞌoo ta kàrè ꞌgə mḛḛ-é al rəm; nè dꞌa kḭ kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ kdɔ kadɨ nꞌḭ nꞌajɨ-dé. ");
INSERT INTO mge_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ejay lé oo né riɓa lə Jeju kete ɓá ḛ pa ta kin bè sɔbɨ-né dɔ-é. ");
INSERT INTO mge_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bè ya kàrè, dan ꞌboy-je-tɨ lə jipɨ-je lé, dow-je n̰a̰ ya dꞌadɨ mḛḛ-dé Jeju tɔ; ngà ɓəl ɓá ꞌɓəl kidə dow-je, kdɔtalə Parisi-je kɨ́ dꞌa tubə-dé kɔgɨ kəykəwna̰-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kdɔtalə Parisi-je lé, nəl-dé n̰a̰ kadɨ dow-je ꞌpitɨ-dé tɔy kadɨ Lubə ɓá pitɨ-dé. ");
INSERT INTO mge_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jeju ilə bɔbɨ ndi-é nangɨ panè: Dow kɨ́ adɨ-m mḛḛ-é lé, to ma̰ ɓá dowbé adɨ-m mḛḛ-é al, ngà to njèkulə-m ɓá ḛ adɨ-é mḛḛ-é tin. ");
INSERT INTO mge_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ə dow kɨ́ oo-m rəmə, oo njèkulə-m tɔ. ");
INSERT INTO mge_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma̰ lé, mꞌto lo kɨ́ ndógɨ kɨ́ mꞌree dɔnangɨ-tɨ nè, kdɔ kadɨ dow kɨ́ adɨ-m mḛḛ-é ə isɨ londul-tɨ al ngá. ");
INSERT INTO mge_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kinə dow kɨ́ oo ta lə-m ɓá təl rɔ-é go-tɨ al lé, ma̰ ɓá mꞌa gangta dɔ-é-tɨ al; kdɔtalə ma̰ mꞌree kdɔ gangta dɔ dow-je kɨ́ dɔnangɨ-tɨ al, ngà mꞌree kdɔ kajɨ-dé. ");
INSERT INTO mge_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dow kɨ́ mbatɨ-m rəm, təl rɔ-é go ta-tɨ lə-m al rəm lé, njègangta dɔ-é-tɨ ya isɨ nɔ̰ɔ̰. Ta-je kɨ́ mꞌpa kin ya à gangta dɔ-é-tɨ dɔbəy ndɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kdɔtalə ta-je kɨ́ mꞌpa lé, mꞌun kɨ̀ dɔ-m ɓá mꞌpa al, ngà to ta-je kɨ́ Bɔbɨ-m kɨ́ njèkulə-m ɓá un ndu adɨ-m mꞌidə dow-je rəm, mꞌpa rəm. ");
INSERT INTO mge_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma̰ mꞌgə kɨ́ ndukun lə Bɔbɨ-m lé, adɨ dow-je kiskəm kɨ́ sartagangɨ. Beɓa ta kɨ́ ma̰ mꞌpa lé, mꞌpa titɨ kɨ́ Bɔbɨ-m idə-m-né ya. ");
INSERT INTO mge_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ndɔ ra na̰y Pakɨ nà̰y ngɔsi ə Jeju gə kɨ́ dɔkàdɨ̀ asɨ kadɨ nꞌa kin̰ə dɔnangɨ kdɔ təl kɔw rɔ Bɔbɨ-nè-tɨ gogɨ. Jeju kɨ́ to njèndigɨ dow-je liə kɨ́ dɔnangɨ-tɨ nè lé, ndigɨ-dé ndigɨ kɨ́ ɔr njutɨ. ");
INSERT INTO mge_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kete ɓá kadɨ dꞌisɨ ta nékuso-tɨ ya rəmə Sú ulə ta mḛḛ Judasɨ-tɨ kɨ́ to ngon lə Simɔ̰ Iskariyotɨ kadɨ un dɔ Jeju. ");
INSERT INTO mge_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jeju gə kɨ́ Bɔbɨ-nꞌḛ̀ in̰ə né-je lay ji-nꞌḛ̀-tɨ ə nꞌḛ̀ nꞌḭ rɔ Bɔbɨ-nꞌḛ̀ Lubə-tɨ adɨ nꞌa təl kɔw rɔ-é-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jeju ḭ ta nékuso-tɨ, tɔr kubɨ-je kɨ́ rɔ-é-tɨ ə un takubɨ dɔ-né ɓədɨ-é. ");
INSERT INTO mge_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Go-tɨ, ungɨ man mḛḛ ba̰y-tɨ ə togɨ-né nja njéndó né-je liə, rəmə bɔr kɨ̀ takubɨ kɨ́ dɔ-né ɓədɨ-é lé. ");
INSERT INTO mge_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lokɨ ree tḛḛ dɔ Simɔ̰ Piyər-tɨ rəmə Simɔ̰ idə-é panè: «Dé! ꞌƁaɓe, kadɨ i ɓá ꞌtogɨ nja-m?» ");
INSERT INTO mge_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jeju ilə-é-tɨ panè: «Né kɨ́ mꞌisɨ mꞌra kinlé, i a gə gin-é kɨ́ ngɔsnè-tɨ kin al, ngà ꞌa ree gə ɓəy.» ");
INSERT INTO mge_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyər ilə-é-tɨ panè: «Bè al, ꞌa togɨ nja-m nda̰ al.» Jeju ilə-é-tɨ panè: «Kinə mꞌtogɨ nja-i al lé, i a to ꞌlə-m al.» ");
INSERT INTO mge_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔ̰ Piyər idə-é panè: «ꞌƁaɓe, kinə tò bè rəmə, ꞌtogɨ nja-m par al, ngà ꞌtogɨ ji-m rəm, ɓá dɔ-m rəm tɔ!» ");
INSERT INTO mge_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jeju ilə-é-tɨ panè: «Dow kɨ́ ndogɨ man lé, rɔ-é lay ya aa njay ngá, adɨ ɔw ndoo kadɨ togɨ nja-é ya par. Sə̰i kàrè rɔ-si aa njay tɔ; ngà to sə̰i lay al.» ");
INSERT INTO mge_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kdɔtalə Jeju gə dow kɨ́ à kun dɔ-é ɓətɨ. Gin-é kin ɓá ḛ pa-né panè: «To sə̰i lay ɓá aai njay al.» ");
INSERT INTO mge_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ngà lokɨ Jeju togɨ nja njéndó né-je liə lay ə təl tulə kubɨ-je liə rɔ-é-tɨ gogɨ lé, ḛ təl isɨ ta tablə-tɨ ə idə-dé panè: «Né kɨ́ mꞌra sə-si kinlé ꞌgəi mḛḛ-é ɓan wa? ");
INSERT INTO mge_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɓa kɨ́ sə̰i ꞌɓai-mi “Njèndó dow-je né” rəm, “ꞌƁaɓe” rəm lé, to tó-é ya kdɔ mꞌto njèndó dow-je né rəm, ɓá mꞌto ꞌƁaɓe rəm. ");
INSERT INTO mge_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Beɓa kinə ma̰ kɨ́ mꞌto ꞌƁaɓe rəm, mꞌto Njèndó dow-je né rəm ya mꞌtogɨ nja-si lé, sə̰i ya kàrè tò kadɨ a togi nja-na̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kdɔtalə mꞌra néndajɨ kin bè kdɔ kadɨ sə̰i kàrè ꞌrai titɨ kɨ́ mꞌra-né sə-i kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ooi majɨ, mꞌa kidə-si rəsɨ; ngonnjèkullə à to ꞌboy kitə ꞌɓa-é al rəm, ɓá njèkɔwkulə à kitə njèkulə-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kinə ꞌgəi mḛḛ né kin ə ꞌtəli rɔ-si go-tɨ rəmə, ꞌtoi njénékumə̰-je. ");
INSERT INTO mge_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mꞌpa ta kin kdɔ ta lə-si lay al; dḛ kɨ́ mꞌmbətɨ-dé lé, mꞌgə-dé. Ngà ta kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay lé, tò kadɨ né-é à ra né ya. Mbete kɨ́ aa njay panè: “Njèkuso sə-m né ya à təl gidɨ-é kadɨ-m.” ");
INSERT INTO mge_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ngà kɨ́ nè-tɨ kin ya mꞌidə-si kete ɓá kadɨ né-é ra né ɓəy. Beɓa lokɨ né-é à ra né rəmə, sə̰i a kadi-mi mḛḛ-si kɨ́ Mꞌto njèkisɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ uwə dow kɨ́ mꞌulə-é kɨ rɔ-é-tɨ lé, ḛ uwə-m kɨ rɔ-é-tɨ tɔ ə dow kɨ́ uwə-m kɨ rɔ-é-tɨ kin rəmə, to njèkulə-m ɓá dowbé uwə-é kɨ rɔ-é-tɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Go ta-je-tɨ kɨ́ Jeju pa kinlé, mḛḛ-é ḭ puu adɨ panè: «Ooi majɨ, mꞌa kidə-si rəsɨ; dow káre dan-si-tɨ à kun dɔ-m.» ");
INSERT INTO mge_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Rəmə njéndó né-je ꞌgɔ̰-na̰ ə ꞌdəjɨ-na̰ ta, se to ná̰ ɓá Jeju pa ta kin sɔbɨ-né dɔ-é wa? ");
INSERT INTO mge_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Káre dan njéndó né-je-tɨ kɨ́ Jeju ndigɨ-é, isɨ mbɔ́ Jeju-tɨ ngɔsi ta nékuso-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔ̰ Piyər pa siə kɨ̀ dɔ kəm-é panè: «ꞌDəjɨ Jeju adɨ jꞌoo sé ḛ pa ta kinlé sɔbɨ-né dɔ ná̰ wa?» ");
INSERT INTO mge_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Beɓa njèndó né kinlé tò kàdɨ̀ Jeju-tɨ ə dəjɨ-é panè: «ꞌƁaɓe, dowbé lé to ná̰ wa?» ");
INSERT INTO mge_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jeju ilə-é-tɨ panè: «Dow kɨ́ mꞌa gangɨ mbə̀ dana̰ kulə dan ná̰y-tɨ kadɨ-é kin ɓá à to njèkun dɔ-m.» Rəmə Jeju ulə mbə̀ kɨ́ gangɨ dana̰ lé dan ná̰y-tɨ ə adɨ Judasɨ kɨ́ to ngon lə Simɔ̰ Iskariyotɨ. ");
INSERT INTO mge_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Lokɨ Judasɨ taa mbə̀ lé rəmə, tajinatɨ nè ya Sata̰ ur mḛḛ-é-tɨ. Ngá ɓá Jeju idə Judasɨ lé panè: «Né kɨ́ ɔw kɨ̀ ra lé ꞌra kalangɨ.» ");
INSERT INTO mge_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ngà njéndó né-je kɨ́ dꞌisɨ ta nékuso-tɨ kɨ̀ Jeju lé ꞌgə né kɨ́ Jeju pa ta-é lé al. ");
INSERT INTO mge_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ə Judasɨ lé ɓá to njèngəm là, adɨ dḛ kɨ́ madɨ-je dan-dé-tɨ ꞌgɨr kɨ́ Jeju à kidə-é panè: «ꞌƆw ꞌndogɨ né kɨ́ jꞌa rai-né na̰y», al rəmə à kidə-é panè: «ꞌƆw adɨ né njéndoo-je.» ");
INSERT INTO mge_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasɨ taa mbə̀ kɨ́ gangɨ dana̰ lé rəmə, tajinatɨ nè ya ḛ tḛḛ ndaa-tɨ. Ə to ta kɨ́ ndɔɔ ngá. ");
INSERT INTO mge_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lokɨ Judasɨ tḛḛ ndaa-tɨ rəmə Jeju panè: «Kɨ́ ngɔsnè-tɨ kin ya Ngon lə dow ingə riɓa ə Lubə tɔjɨ riɓa liə kɨ̀ takul Ngon lə dow tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kinə ri Lubə ɓa kɨ̀ takul Ngon lə dow rəmə, Lubə à kadɨ ri Ngon lə dow ɓa kɨ̀ takul-é tɔ ə à kadɨ ɓa kɨ́ tajinatɨ nè ya. ");
INSERT INTO mge_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngan-m-je, mꞌa kisɨ sə-si dɔkaglo sḛ bè par ə go-tɨ rəmə a sangi-mi. Ngà titɨ kɨ́ ndɔkɨ mꞌidə-né jipɨ-je mꞌpanè: Lo kɨ́ mꞌisɨ mꞌɔw-tɨ lé dḛ dꞌa kasɨ kɔw-tɨ al kinlé, sə̰i kàrè, mꞌidə-si bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mꞌadɨ-si ndukun kɨ́ sigɨ: ꞌNdigi-na̰. Titɨ kɨ́ ma̰ mꞌndigɨ-si-né lé, ꞌndigi-na̰ bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kinə ꞌndigi-na̰ rəmə, dow-je lay ya dꞌa gə kɨ́ sə̰i ꞌtoi njéndó né-je lə-m ya.» ");
INSERT INTO mge_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔ̰ Piyər dəjɨ Jeju panè: «ꞌƁaɓe, i a kɔw rá wa?» Jeju ilə-é-tɨ panè: «Lokɨ mꞌa kɔw-tɨ lé, i a kasɨ kun go-m kɨ́ ngɔsnè-tɨ kin al, ngà ndɔ madɨ ɓá ꞌa kun go-m ɓəy.» ");
INSERT INTO mge_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Rəmə Piyər idə-é panè: «ꞌƁaɓe, mꞌa kun go-i kɨ́ ngɔsnè-tɨ kin al kdɔ ri wa? Mꞌa kilə rɔ-m kɔgɨ kdɔ ta lə-i!» ");
INSERT INTO mge_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Beɓa Jeju ilə-é-tɨ panè: «Adɨ ꞌa kilə rɔ-i kɔgɨ kdɔ ta lə-m wa! ꞌOo majɨ, mꞌa kidə-i rəsɨ; ꞌa najɨ panè ꞌgə-m al, ꞌgə-m al nja mutə ɓá kunjə à nɔ̰ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Adi mḛḛ-si gangɨ man al. Adi mḛḛ-si Lubə ə adi-mi mḛḛ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lokisɨ tò n̰a̰ mḛḛ kəy-tɨ lə Bɔbɨ-m. Kinə lé goto rəmə mꞌa kidə-si. Mꞌa kɔw ra lo kete kdɔ ta lə-si. ");
INSERT INTO mge_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Beɓa lokɨ mꞌɔw mꞌra lo lé, mꞌa təl ree kɔy-si kɔw sə-si, kdɔ kadɨ lo kɨ́ mꞌisɨ-tɨ ya sə̰i a kisi-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ə lo kɨ́ mꞌisɨ mꞌɔw-tɨ lé sə̰i ꞌgəi rəbɨ kɨ́ ɔw-tɨ gɔw. ");
INSERT INTO mge_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Rəmə Tomasɨ idə-é panè: ꞌƁaɓe, lo kɨ́ isɨ ɔw-tɨ lé kàrè jꞌgə al rəm, ngà jꞌa ra ban ɓá jꞌa gə rəbɨ-é wa? ");
INSERT INTO mge_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Beɓa Jeju ilə-é-tɨ panè: Ma̰ ya mꞌto rəbɨ, mꞌto ta kɨ́ tɔgrɔ-tɨ, mꞌto kiskəm. Rəbɨ kɨ́ rɔ-m-tɨ ya par ɓɨ rəbɨ kɨ́ rangɨ kɨ́ dow à kun kɔw-né rɔ Bɔbɨ-m-tɨ goto. ");
INSERT INTO mge_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kinə ꞌgəi-mi rəmə, a gəi Bɔbɨ-m tɔ. Ə kɨ́ ngɔsnè-tɨ kin ya ꞌgəi-é rəm, ooi-é rəm. ");
INSERT INTO mge_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Rəmə Pilipɨ idə-é panè: ꞌƁaɓe, Bɔbɨ-i lé ya ɔjɨ-ji ə ḛ kin ya asɨ-ji. ");
INSERT INTO mge_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Beɓa Jeju ilə-é-tɨ panè: Pilipɨ, adɨ kisɨ kɨ́ mꞌisɨ sə-si low nṵ kin ya, ꞌgə-m al ɓəy! Dow kɨ́ oo-m rəmə, oo Bɔbɨ-m tɔ ə́n. Ngà ra ban ɓəy ɓá i ꞌpanè mꞌɔjɨ-si Bɔbɨ-m wa? ");
INSERT INTO mge_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Adɨ kisɨ-m mḛḛ Bɔbɨ-m-tɨ ə kisɨ Bɔbɨ-m mḛḛ-m-tɨ kinlé i ꞌoo kɨ́ ta kɨ́ kare wa? Ta-je kɨ́ mꞌidə-si mꞌidə-si kinlé, to ta-je kɨ́ mꞌun kɨ̀ dɔ rɔ-m bè ɓá mꞌidə-si al. Ngà to Bɔbɨ-m kɨ́ njèkisɨ mḛḛ-m-tɨ lé ya ɓá isɨ ra kullə-je liə tin. ");
INSERT INTO mge_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Adi-mi mḛḛ-si kɨ́ ma̰ lé mꞌisɨ mḛḛ Bɔbɨ-m-tɨ ə Bɔbɨ-m isɨ mḛḛ-m-tɨ tɔ. Lé gangɨ-é-tɨ kin al kàrè, né-je kɨ́ mꞌra ra kin ya adi-mi-né mḛḛ-si ɓəl ɓane. ");
INSERT INTO mge_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ooi majɨ, mꞌa kidə-si rəsɨ; dow kɨ́ adɨ-m mḛḛ-é lé, ḛ kàrè à ra né-je kɨ́ mꞌra ra kinlé rəm, ɓá à ra ḛ kɨ́ tò ɓəl itə kin ɓəy, kdɔ mꞌisɨ mꞌɔw kɨ rɔ Bɔbɨ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ə né lay kɨ́ ꞌdəji kɨ̀ ri-m lé, mꞌa ra, kdɔ kadɨ ri Bɔbɨ-m ɓa-né kɨ̀ takul-m ma̰ Ngon-é. ");
INSERT INTO mge_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kinə ꞌdəji-mi né kɨ̀ ri-m lé, mꞌa ra né-é. ");
INSERT INTO mge_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kinə ꞌndigi-mi lé, a təli rɔ-si go ndukun-je-tɨ lə-m. ");
INSERT INTO mge_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ə mꞌa pa ta kɨ̀ Bɔbɨ-m rəmə, à kadɨ-si njèsɔlmḛḛ kɨ́ rangɨ kɨ́ à kisɨ sə-si ya sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Adɨ to Ndil kɨ́ aa njay kɨ́ to njèkadɨ dow-je ꞌgə ta kɨ́ tɔgrɔ-tɨ. Dow-je kɨ́ dɔnangɨ-tɨ nè dꞌa kasɨ ndigɨ kadɨ-é isɨ mḛḛ-dé-tɨ al, kdɔ dḛ dꞌoo-é al rəm, ɓá ꞌgə-é al rəm; ngà sə̰i lé, ꞌgəi-é kdɔ isɨ sə-si ngɔsi rəm, à kisɨ mḛḛ-si-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mꞌa kin̰ə-si titɨ ngan al-je bè al; mꞌa təl ree rɔ-si-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dɔkaglo sḛ ɓəy ə dow-je kɨ́ dɔnangɨ-tɨ nè dꞌa koo-m al ya sar ngá; ngà sə̰i ɓá a kooi-mi kdɔ ma̰ mꞌisɨ kəm ə sə̰i kàrè a kisi kəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mḛḛ ndɔ-é-tɨ kinlé ɓá a gəi kɨ́ ma̰ mꞌisɨ mḛḛ Bɔbɨ-m-tɨ rəm, sə̰i ꞌnami kàdɨ̀-m-tɨ rəm, ɓá ma̰ kàrè mꞌisɨ mḛḛ-si-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dow kɨ́ ɔw kɨ̀ ndukun-je lə-m ə təl rɔ-é go-tɨ lé, ḛ ɓá to dow kɨ́ ndigɨ-m. Ə dow kɨ́ ndigɨ-m lé, Bɔbɨ-m à ndigɨ-é rəm, ma̰ ya kàrè mꞌa ndigɨ-é rəm, ɓá mꞌa kadɨ-é gə-m majɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Rəmə Judɨ (ɓɨ Judasɨ Iskariyotɨ al) dəjɨ-é panè: «ꞌƁaɓe, kdɔ ri ɓá ꞌa kadɨ ndəgɨ dow-je ꞌgə-i al, rəmə jḛ ɓá ꞌa kadɨ jꞌgə-i wa?» ");
INSERT INTO mge_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ə Jeju ilə-é-tɨ panè: Kinə dow ndigɨ-m lé, à təl rɔ-é go ta-tɨ lə-m ə Bɔbɨ-m à ndigɨ-é. Jḛ jꞌa kɔw rɔ dowbé-tɨ rəm, jꞌa ra ɓe mḛḛ-é-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngà dow kɨ́ ndigɨ-m al lé, à təl rɔ-é go ta-je-tɨ lə-m al. Ta kɨ́ sə̰i ooi ta-m-tɨ kinlé to ta lə-m al, ngà to ta kɨ́ ḭ rɔ Bɔbɨ-m-tɨ kɨ́ njèkulə-m lé ya. ");
INSERT INTO mge_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Kɨ́ mꞌisɨ-né sə-si nè ɓəy kin ya mꞌidə-si ta-je kinlé bè. ");
INSERT INTO mge_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngà njèsɔlmḛḛ, kɨ́ to Ndil kɨ́ aa njay kɨ́ Bɔbɨ-m à kullə-é kɨ̀ ri-m lé, ḛ ɓá à ree ndó-si né-je lay rəm, ɓá à kole mḛḛ-si dɔ né-je-tɨ lay kɨ́ mꞌidə-si ta dɔ-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mꞌin̰ə lapiya mꞌadɨ-si rəm, mꞌadɨ-si lapiya lə-m rəm. Ma̰ mꞌadɨ-si lapiya titɨ kɨ́ dow-je kɨ́ dɔnangɨ-tɨ dꞌadɨ-né kin bè al. Adi mḛḛ-si gangɨ man al rəm, ꞌɓəli al rəm. ");
INSERT INTO mge_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kdɔ lé mꞌidə-si mꞌpanè: Mꞌa kɔw ə mꞌa təl ree rɔ-si-tɨ nɔ̰ɔ̰. Kinə ꞌndigi-mi rəmə, kɔw-m kɨ rɔ Bɔbɨ-m-tɨ kinlé à nəl-si. Kdɔ Bɔbɨ-m lé, to dow kɨ́ boy itə-m. ");
INSERT INTO mge_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ꞌNgɔsnè-tɨ kin ya mꞌidə-si ta dɔ né-je-tɨ kinlé kete bè, kdɔ kadɨ lokɨ né-é-je ra né rəmə adi-né mḛḛ-si. ");
INSERT INTO mge_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mꞌa pa sə-si ta al ya sar ngá, kdɔ njèkɔ̰ɓe kɨ́ dɔnangɨ-tɨ ɔw ree nɔ̰ɔ̰. Tɔ́gɨ kɨ́ ndḛ bè ya kàrè ɔw-né dɔ-m-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ngà kadɨ dow-je kɨ́ dɔnangɨ-tɨ nè ꞌgə kɨ́ ma̰ mꞌndigɨ Bɔbɨ-m, adɨ né kɨ́ ḛ un ndu kadɨ mꞌra lé, mꞌa ra. Ḭi taá adi jꞌɔti kɨ rangɨ lo kin-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ma̰ mꞌto kagɨ nduu kɨ́ tɔgrɔ-tɨ ə Bɔbɨ-m ɓá to ꞌɓa njènduu tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Balkəm nduu kɨ́ rá-rá kɨ́ ubə dɔ-m-tɨ ə andɨ al lé, Bɔbɨ-m à tugə-é kilə-é kɔgɨ ə balkəm-é kɨ́ andɨ ɓá ḛ à tɔr ngan balkəm-é-je kɔgɨ kdɔ kadɨ andɨ n̰a̰ ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta-je kɨ́ mꞌilə mbi-si-tɨ kin ya ra adɨ ngan balkəm-si-je tokɨ tɔr ngá. ");
INSERT INTO mge_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ꞌTin̰əi kàdɨ̀-m-tɨ titɨ kɨ́ mꞌtin̰ə-né kàdɨ̀-si-tɨ tɔ. Balkəm nduu lé, à kandɨ kɨ̀ dɔ rɔ-é al. À ka̰ dɔ kagɨ-é-tɨ ɓá à kandɨ. Bè ya tɔ, sə̰i kàrè kinə ꞌtin̰əi kàdɨ̀-m-tɨ al lé, a kandi al tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ma̰ mꞌto kagɨ nduu ə sə̰i ꞌtoi balkəm-é-je. Dow kɨ́ tin̰ə kàdɨ̀-m-tɨ ə mꞌtin̰ə kàdɨ̀-é-tɨ tɔ lé, à kandɨ n̰a̰. Kdɔ kɨ̀ takul-m al lé, a kasi rai né madɨ al. ");
INSERT INTO mge_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kinə dow tin̰ə kàdɨ̀-m-tɨ al lé, dꞌa kilə-é kɔgɨ titɨ balkəm nduu bè ə à tutɨ. Balkəm nduu-je kɨ́ tutɨ lé, dꞌa saa kungɨ pərəə kadɨ pər ɔ̰̀. ");
INSERT INTO mge_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngà kinə ꞌtin̰əi kàdɨ̀-m-tɨ ə ta lə-m tò mḛḛ-si-tɨ rəmə, ꞌdəji né lay kɨ́ mḛḛ-si ndigɨ ya ə a kingəi. ");
INSERT INTO mge_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Né kɨ́ ri Bɔbɨ-m à ɓa-né ə́n: Kadɨ andi n̰a̰, beɓa a ꞌtɔji kɨ́ ꞌtoi njéndó né-je lə-m. ");
INSERT INTO mge_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Titɨ kɨ́ Bɔbɨ-m ndigɨ-m-né lé, ma̰ ya kàrè mꞌndigɨ-si tɔ. A̰i mḛḛ ndigɨ-tɨ kɨ́ mꞌndigɨ-si kin ya. ");
INSERT INTO mge_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kinə ꞌtəli rɔ-si go ndukun-je-tɨ lə-m rəmə, a ka̰i mḛḛ ndigɨ-tɨ kɨ́ mꞌndigɨ-si, titɨ kɨ́ mꞌtəl-né rɔ-m go ndukun-je-tɨ lə Bɔbɨ-m ə́ mꞌa̰-né mḛḛ ndigɨ-tɨ kɨ́ ḛ ndigɨ-m kin tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mꞌpa ta-je kin bè kdɔ kadɨ ga̰ rɔnəl lə-m kin ya tò mḛḛ-si-tɨ ə kadɨ rɔnəl lə-si ɔr njutɨ. ");
INSERT INTO mge_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndukun lə-m ə́n: ꞌNdigi-na̰ titɨ kɨ́ ma̰ mꞌndigɨ-si-né kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dow ilə rɔ-é kɔgɨ kdɔ nam-é-je lé, ndigna̰ kɨ́ rangɨ kɨ́ à kitə-é ya goto ngá. ");
INSERT INTO mge_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kinə ꞌrai né-je kɨ́ mꞌun ndu kadɨ ꞌrai kinlé rəmə, sə̰i ꞌtoi nam-m-je. ");
INSERT INTO mge_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mꞌɓa-si ngannjékullə-je al, kdɔ ngonnjèkullə lé ꞌgə né kɨ́ ꞌɓa-é isɨ ra al. Mꞌɓa-si nam-m-je, kdɔ né-je kɨ́ mꞌndó rɔ Bɔbɨ-m-tɨ ya mꞌadɨ-si ꞌgəi. ");
INSERT INTO mge_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sə̰i ɓá ꞌmbəti-mi al, ngà to ma̰ ɓá mꞌmbətɨ-si ə mꞌində-si kdɔ kadɨ ɔwi ə kadɨ andi, rəmə kadɨ kandɨ-si tò sartagangɨ, kdɔ kadɨ né-je lay kɨ́ a dəji Bɔbɨ-m kɨ̀ ri-m ə adɨ-si. ");
INSERT INTO mge_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Né kɨ́ mꞌndəjɨ-si dɔ-tɨ ə́n: ꞌNdigi-na̰. ");
INSERT INTO mge_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kinə dow-je kɨ́ dɔnangɨ-tɨ dꞌɔsɨ-si kɨ̀ ta rəmə, kadɨ ꞌgəi majɨ kɨ́ ma̰ ya dꞌɔsɨ-m kɨ̀ ta kete nɔ̰̀-si-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kinə ꞌtoi kɨ́ lə dow-je kɨ́ dɔnangɨ-tɨ nè rəmə, lé dꞌa ndigɨ-si kdɔ dḛ lé dow-je lə-dé ɓá ndigɨ-dé. Ngà ma̰ mꞌmbətɨ-si dan dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè adɨ sə̰i ꞌtoi kɨ́ lə-dé al, gin-é kin ɓá dꞌɔsɨ-si-né kɨ̀ ta tin. ");
INSERT INTO mge_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Adi mḛḛ-si ole dɔ ta-tɨ kɨ́ ndɔkɨ mꞌidə-si ꞌpanè: «Ngonnjèkullə à to kɨ́ ꞌboy kitə ꞌɓa-é al.» Ma̰ ya dꞌulə kəm-m ndoo kinlé, dꞌa kulə kəm-si ndoo ya tɔ. Ma̰ ya ꞌtəl rɔ-dé go ta-tɨ lə-m rəmə, dꞌa təl rɔ-dé go ta-tɨ lə-si ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngà dꞌa ra sə-si né-je kin lay bè kdɔ ta lə-m, kdɔ dḛ ꞌgə dow kɨ́ njèkulə-m al. ");
INSERT INTO mge_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kinə lé mꞌree al əse mꞌpa ta mꞌadɨ-dé al rəmə lé dꞌa to njéramajal-je al. Ngà kɨ́ ngɔsnè-tɨ kinlé, ta lə majal ɔr dɔ-dé-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dow kɨ́ ɔsɨ-m kɨ̀ ta lé, ɔsɨ Bɔbɨ-m kɨ̀ ta ya tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Né-je kɨ́ dow kɨ́ rangɨ ra al ya mꞌra dan-dé-tɨ kinlé, lé mꞌra al rəmə majal lə-dé à goto. Ngà kɨ́ ngɔsnè-tɨ kinlé, dḛ dꞌoo né-é-je lé ya, ngà dꞌɔsɨ-m kɨ̀ ta rəm, dꞌɔsɨ Bɔbɨ-m kɨ̀ ta rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngà tò bè kdɔ kadɨ ta kɨ́ ꞌndàngɨ mḛḛ mbete ndukun-je-tɨ lə-dé lé né-é ra né. Kdɔ ꞌndàngɨ ꞌpanè: «Dḛ dꞌɔsɨ-m ta kɨ̀ ndángɨ kare.» ");
INSERT INTO mge_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Lokɨ mꞌa kullə Njèsɔlmḛḛ, Ndil kɨ́ njèkadɨ dow-je ꞌgə ta kɨ́ tɔgrɔ-tɨ kɨ́ à kḭ rɔ Bɔbɨ-m-tɨ ree lé, ḛ ɓá à pa ta kɨ́ dɔ-m-tɨ kadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ə sə̰i kàrè a pai ta kɨ́ dɔ-m-tɨ kadɨ dow-je tɔ. Kdɔ sə̰i a̰i sə-m natɨ lo kulə gin-é-tɨ nṵ.» ");
INSERT INTO mge_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Mꞌidə-si ta-je kin bè kdɔ kadɨ né madɨ tugə-si jigɨ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dꞌa tubə-si kɔgɨ mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je; ə ndɔ-je ɔw ree nɔ̰ɔ̰ kɨ́ dow-je dꞌa tɔl-si rəmə, dꞌa gɨr kɨ́ to pole ɓá dꞌisɨ ꞌpole Lubə tin. ");
INSERT INTO mge_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Dꞌa ra né-je kinlé bè, kdɔtalə dḛ ꞌgə Bɔbɨ-m al rəm, ɓá ꞌgə-m al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngà mꞌidə-si ta-je kin bè kdɔ kadɨ, lokɨ ndɔ-é ree rəmə jè mḛḛ-si ole-né dɔ-tɨ kɨ́ ndɔkɨ mꞌidə-si kete ngá. Ta kinlé, mꞌidə-si lo kulə gin-é-tɨ al, kdɔtalə mꞌisɨ sə-si natɨ nè ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kɨ́ ngɔsnè-tɨ kinlé, mꞌisɨ mꞌɔw kɨ rɔ Njèkulə-m-tɨ ə dow káre dan-si-tɨ kɨ́ kadɨ dəjɨ-m panè: ꞌIsɨ ꞌɔw kɨ rá wa ya kàrè goto. ");
INSERT INTO mge_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ngà sə̰i adi rɔ-si atɨ-si kana̰na̰ kdɔtalə ta-je kɨ́ mꞌidə-si kinlé. ");
INSERT INTO mge_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bè ya kàrè, to ta kɨ́ tɔgrɔ-tɨ ə́ mꞌɔw kɨ̀ kidə-si tin: Mꞌɔw ɓá à majɨ sə-si, kdɔtalə kinə mꞌɔw al lé, Njèsɔlmḛḛ à ree kdɔ ta lə-si al; ngà kinə mꞌɔw rəmə mꞌa kulə siə kadɨ-si. ");
INSERT INTO mge_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ə lokɨ ḛ à ree lé, à kuwə dow-je kɨ́ dɔnangɨ-tɨ nè kɨ̀ ta sɔbɨ dɔ majal rəm, sɔbɨ dɔ né ra kɨ́ njururu rəm, à tɔjɨ-dé kadɨ ꞌgə ta kɨ́ gangɨ lə Lubə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","À kuwə-dé kɨ̀ ta sɔbɨ dɔ majal, kdɔtalə dḛ dꞌadɨ-m mḛḛ-dé al rəm; ");
INSERT INTO mge_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","sɔbɨ dɔ né ra kɨ́ njururu, kdɔtalə mꞌa kɔw rɔ Bɔbɨ-m-tɨ adɨ sə̰i a kooi-mi gogɨ al rəm; ");
INSERT INTO mge_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","sɔbɨ dɔ ta kɨ́ gangɨ, kdɔtalə njèkɔ̰ɓe kɨ́ dɔnangɨ-tɨ nè lé, ꞌgangɨ ta dɔ-é-tɨ ngá. ");
INSERT INTO mge_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mꞌɔw kɨ̀ ta-je n̰a̰ kadɨ mꞌidə-si ya ngà, to ta-je kɨ́ asɨ dɔ tɔ́gɨ-si-tɨ kɨ́ nè-tɨ kin al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lokɨ Ndil kɨ́ njèkadɨ dow-je ꞌgə ta kɨ́ tɔgrɔ-tɨ à ree lé, à kɔr nɔ̰̀-si kadɨ ꞌgəi ta kɨ́ tɔgrɔ-tɨ lay; kdɔtalə ḛ à kun ta madɨ kɨ̀ dɔ-é kdɔ pa al, ngà ta-je kɨ́ ḛ à koo ya ɓá à pa ə né-je kɨ́ à ra né lé, ḛ à kidə-si kete tɔ. ");
INSERT INTO mge_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ḛ à tɔjɨ riɓa lə-m, kdɔtalə ta kɨ́ ḛ oo ta-m-tɨ ɓá à kidə-si. ");
INSERT INTO mge_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Né-je lə Bɔbɨ-m lay to kɨ́ lə-m tɔ. Gin-é kinlé ɓá mꞌpa-né mꞌpanè: Ta kɨ́ ḛ oo ta-m-tɨ ɓá à kidə-si. ");
INSERT INTO mge_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jeju panè: «Dɔkaglo sḛ ɓəy ə a kooi-mi al, rəmə dɔkaglo kɨ́ rangɨ sḛ ɓəy ə a təli kooi-mi gogɨ.» Kdɔtalə mꞌisɨ mꞌɔw rɔ Bɔbɨ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Beɓa njéndó né-je liə kɨ́ dan-tɨ-je ꞌdəjɨ-na̰ ta ꞌpanè: Ta ri ɓá ḛ ndigɨ kidə-ji wa? Ḛ panè: «Dɔkaglo sḛ ɓəy ə a kooi-mi al, rəmə dɔkaglo kɨ́ rangɨ sḛ ɓəy ə a təli kooi-mi gogɨ.» Rəm panè: Mꞌisɨ mꞌɔw rɔ Bɔbɨ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Dḛ ꞌpanè: Ta kɨ́ Jeju panè: «Dɔkaglo sḛ ɓəy» kinlé, kɔr mḛḛ-é to ri wa? Ta kɨ́ ḛ pa lé, jꞌgəi mḛḛ-é al. ");
INSERT INTO mge_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lokɨ Jeju gə kɨ́ njéndó né-je ꞌndigɨ dəjɨ-é ta lé, idə-dé panè: Ta kɨ́ mꞌpanè: «Dɔkaglo sḛ ɓəy ə a kooi-mi al, rəmə dɔkaglo kɨ́ rangɨ sḛ ɓəy ə a təli kooi-mi gogɨ» lé ɓá isi ꞌdəji-na̰ kɔr mḛḛ-é wa? ");
INSERT INTO mge_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ooi majɨ, mꞌa kidə-si rəsɨ; a nɔ̰i rəm, a ndingəi rɔ-si rəm, ngà dow-je kɨ́ dɔnangɨ-tɨ nè dꞌa ra rɔnəl; a kisi kɨ̀ rɔkatɨ kana̰na̰ ya, ngà rɔkatɨ lə-si ɓá à təl rɔnəl. ");
INSERT INTO mge_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lokɨ dené ɔw kɨ̀ kojɨ ngon lé, rɔ-é atɨ-é kana̰na̰, kdɔ to kaglo rɔkatɨ liə ya ɓá ree; ngà lokɨ ojɨ ngon rəmə, mḛḛ-é oy dɔ rɔkatɨ-tɨ; rɔ-é nəl-é n̰a̰, kdɔtalə ngon kɨ́ ojɨ-é dɔnangɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sə̰i kàrè, kɨ́ ngɔsnè-tɨ kinlé, rɔ-si atɨ-si kana̰na̰; ngà lokɨ mꞌa təl ree koo-si gogɨ lé, rɔ-si à nəl-si ə dow kɨ́ à kɔgɨ rɔnəl-é kin à goto. ");
INSERT INTO mge_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ə mḛḛ ndɔ-é-tɨ kinlé, né kɨ́ a dəji-mi ta dɔ-tɨ à goto ngá. Ooi majɨ, mꞌa kidə-si rəsɨ; né kɨ́ ꞌdəji Bɔbɨ-m kɨ̀ ri-m lé, à ra kadɨ-si. ");
INSERT INTO mge_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sar ɓone kàrè, sə̰i ꞌdəji né kɨ̀ ri-m al ya ɓəy. ꞌDəji ə a kingəi kdɔ kadɨ rɔnəl lə-si ɔr-né njutɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Beɓa ma̰ mꞌun gosta ɓá mꞌidə-si-né ta ta. Ndɔ-je ɔw ree nɔ̰ɔ̰ kɨ́ mꞌa pa sə-si ta kɨ̀ gosta al, ngà né kɨ́ sɔbɨ dɔ Bɔbɨ-m lé, mꞌa kidə-si rəsɨ-rəsɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mḛḛ ndɔ-é-tɨ kinlé, sə̰i a dəji né kɨ̀ ri-m ə mꞌa kidə-si panè ma̰ ɓá mꞌa pa ta kɨ̀ Bɔbɨ-m kdɔ ta lə-si al. ");
INSERT INTO mge_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kdɔ Bɔbɨ-m ya kɨ̀ dɔ-é ndigɨ-si, kdɔ sə̰i ꞌndigi-mi rəm, ɓá sə̰i adi mḛḛ-si kɨ́ ma̰ mꞌḭ rɔ Lubə-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ma̰ lé, mꞌḭ rɔ Bɔbɨ-m-tɨ ɓá mꞌree dɔnangɨ-tɨ nè; ngà kɨ́ ngɔsnè-tɨ kinlé, mꞌa kin̰ə lo kɨ́ dɔnangɨ-tɨ ə mꞌa kɔw rɔ Bɔbɨ-m-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Beɓa njéndó né-je lə Jeju lé ꞌpanè: ꞌOo, kɨ́ nè kinlé i idə-ji ta rəsɨ-rəsɨ ɓɨ i ꞌpa ta kɨ̀ gosta al ngá. ");
INSERT INTO mge_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kɨ́ ngɔsnè-tɨ kinlé, jḛ jꞌgə kɨ́ i ꞌgə né-je lay, adɨ i ꞌɔw ndoo kadɨ dow ɓá dəjɨ-i ta al. Gin-é kin ɓá jḛ jꞌadɨ-né mḛḛ-ji kɨ́ i lé ḭ rɔ Lubə-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Beɓa Jeju dəjɨ-dé panè: Adɨ sə̰i adi mḛḛ-si ngá ɓan…? ");
INSERT INTO mge_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ooi, ndɔ ɔw ree nɔ̰ɔ̰ ə ndɔ-é lé ree rəm ngá; ndɔ-é-tɨ kinlé, a ka̰yi-na̰ lay dɔ-m-tɨ, ná̰-ná̰ ya à kɔw lo liə ə a kin̰əi-mi kɨ̀ kár-m; ngà mꞌa ka̰ kɨ̀ kár-m al, kdɔtalə Bɔbɨ-m a̰ sə-m natɨ. ");
INSERT INTO mge_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mꞌidə-si ta-je kin bè, kdɔ kadɨ isi-né kɨ̀ lapiya kɨ̀ takul-m. A kingəi kɔ̰̀ dɔnangɨ-tɨ nè, ngà uwəi mḛḛ-si nga̰; ma̰ lé, mꞌtətɨ rɔ né-je kɨ́ dɔnangɨ-tɨ nè. ");
INSERT INTO mge_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Lokɨ Jeju pa bè lé, un kəm-é kɨ taá dɔra̰-tɨ ə panè: Bɔbɨ-m, dɔkàdɨ̀ lé ree ngá. ꞌAdɨ ri Ngon-i ɓa kdɔ kadɨ Ngon-i kàrè adɨ ri-i ɓa tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","I ꞌadɨ-é tɔ́gɨ dɔ dow-je-tɨ lay, kdɔ kadɨ dḛ lay kɨ́ i adɨ-é lé, ḛ adɨ-dé dꞌisɨ kəm sartagangɨ. ");
INSERT INTO mge_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ə kiskəm kɨ́ sartagangɨ lé, to ta kadɨ ꞌgə-i kɨ́ i ya kɨ̀ kár-i ꞌto Lubə kɨ́ tɔgrɔ-tɨ rəm, ɓá kadɨ ꞌgə Jeju Kristɨ kɨ́ i ulə-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mꞌadɨ ri-i ɓa dɔnangɨ-tɨ nè; kullə kɨ́ ꞌadɨ-m kadɨ mꞌra lé, mꞌra mꞌtɔl ta-é. ");
INSERT INTO mge_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bɔbɨ-m, kɨ́ ngɔsnè-tɨ kin ya ꞌadɨ ri-m ɓa rɔ-i-tɨ, gangɨ-é-tɨ kɨ́ ndɔkɨ ɓa-né rɔ-i-tɨ kete nɔ̰̀ kində gin dɔnangɨ-tɨ kin ya. ");
INSERT INTO mge_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Dow-je kɨ́ ꞌadɨ-m-dé dan dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè lé, mꞌadɨ ꞌgə-i. Dḛ ꞌto dow-je lə-i ɓá ꞌadɨ-m-dé ə dḛ ꞌtəl rɔ-dé go ta-tɨ lə-i. ");
INSERT INTO mge_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ɓone bè kinlé, dḛ ꞌgə kɨ́ né-je lay kɨ́ ꞌadɨ-m kinlé to né kɨ́ ḭ rɔ-i-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kdɔ ta-je kɨ́ i ꞌidə-m lé ya ɓá mꞌidə-dé ə dḛ ꞌndigɨ dɔ-tɨ ə ꞌgə majɨ kɨ́ mꞌḭ rɔ-i-tɨ rəm, ɓá dꞌadɨ-m mḛḛ-dé kɨ́ to i ya ɓá ulə-m rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Dḛ ɓá mꞌpa sə-i ta kdɔ-dé. Mꞌpa sə-i ta kdɔ dow-je kɨ́ dɔnangɨ-tɨ nè al, ngà mꞌpa sə-i ta kdɔ dḛ kɨ́ ꞌadɨ-m-dé, kdɔtalə ꞌto dow-je lə-i ");
INSERT INTO mge_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","– ə né lə-m lay to né lə-i; ɓá né lə-i kàrè to né lə-m tɔ – dḛ lé, ꞌto dow-je kɨ́ dꞌadɨ ri-m ɓa. ");
INSERT INTO mge_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma̰ mꞌto kɨ́ dɔnangɨ-tɨ nè al ngá; kdɔ mꞌisɨ mꞌɔw kɨ rɔ-i-tɨ nɔ̰ɔ̰; ngà dḛ ɓá dꞌisɨ dɔnangɨ-tɨ nè ɓəy. Bɔbɨ-m kɨ́ njèkaa njay, ri-i kɨ́ ꞌadɨ-m kin ya ꞌngəm-dé-né, kdɔ kadɨ ꞌto dow-je kɨ́ káre-rè tokɨ jḛ sə-i bè. ");
INSERT INTO mge_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lokɨ mꞌisɨ-né sə-dé ɓəy lé, ri-i kɨ́ ꞌadɨ-m kin ya ɓá mꞌngəm-dé-né; ə mꞌa̰y ngangɨ-dé kər-kər, adɨ dow káre ya kàrè tujɨ dan-dé-tɨ al. Ngà ḛ kɨ́ tò kadɨ tujɨ lé ya par ə tujɨ; bè kdɔ kadɨ ta kɨ́ mbete kɨ́ aa njay pa lé, né-é ra né. ");
INSERT INTO mge_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ɓone bè kinlé, mꞌisɨ mꞌɔw kɨ rɔ-i-tɨ ə ta-je kinlé mꞌpa dɔnangɨ-tɨ nè bè, kdɔ kadɨ rɔnəl lə-m kɨ́ to rɔnəl kɨ́ ɔr njutɨ kin tò-né mḛḛ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mꞌadɨ-dé ta lə-i ə dow-je kɨ́ dɔnangɨ-tɨ dꞌɔsɨ-dé kɨ̀ ta, kdɔtalə dḛ ꞌto ꞌlə dow-je kɨ́ dɔnangɨ-tɨ al titɨ kɨ́ ma̰ mꞌto-né ꞌlə dow-je kɨ́ dɔnangɨ-tɨ al kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mꞌdəjɨ-i kadɨ ꞌɔy-dé kɨ rangɨ dɔnangɨ-tɨ al, ngà ngəm ɓá kadɨ ꞌngəm-dé kadɨ Njèmḛḛndul tujɨ-dé al. ");
INSERT INTO mge_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Dḛ ꞌto kɨ́ dɔnangɨ-tɨ nè al, titɨ kɨ́ ma̰ kàrè mꞌto-né kɨ́ dɔnangɨ-tɨ nè al kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","I ya kadɨ ꞌində-dé tagay kɨ̀ takul ta kɨ́ tɔgrɔ-tɨ. Ə Ta lə-i to ta kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ma̰ kàrè mꞌulə-dé dɔnangɨ-tɨ titɨ kɨ́ i ꞌulə-m-né dɔnangɨ-tɨ kin bè tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma̰ ya mꞌɔr rɔ-m mꞌində tagay kdɔ ta lə-dé, kdɔ kadɨ dḛ kàrè tò tagay kɨ̀ takul ta kɨ́ tɔgrɔ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mꞌpa sə-i ta kdɔ ta lə-dé dḛ kan ya par al, ngà kdɔtalə dḛ kɨ́ dꞌa koo ta-je lə-dé ə dꞌa kadɨ-m-né mḛḛ-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mꞌdəjɨ-i bè kdɔ kadɨ dḛ lay ya ꞌto dow-je kɨ́ káre-rè. Bɔbɨ-m, titɨ kɨ́ i ꞌisɨ-né mḛḛ-m-tɨ rəm, ma̰ mꞌisɨ-né mḛḛ-i-tɨ rəm kinlé, kadɨ dḛ kàrè ꞌto dow-je kɨ́ káre-rè ə dꞌisɨ mḛḛ-ji-tɨ tɔ; kdɔ kadɨ dow-je kɨ́ dɔnangɨ-tɨ nè ꞌgə-né kɨ́ to i ɓá ꞌulə-m. ");
INSERT INTO mge_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ə riɓa kɨ́ ꞌadɨ-m kin ya, ma̰ mꞌadɨ-dé tɔ; kdɔ kadɨ ꞌto-né dow-je kɨ́ káre tokɨ jḛ sə-i bè. ");
INSERT INTO mge_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","– Ma̰ mꞌisɨ mḛḛ-dé-tɨ ə i ꞌisɨ mḛḛ-m-tɨ tɔ – kdɔ kadɨ ꞌto dow-je kɨ́ mḛḛ kasɨ-na̰ lə-dé ɔr njutɨ, bè kdɔ kadɨ dow-je kɨ́ dɔnangɨ-tɨ ꞌgə-né kɨ́ to i ɓá ꞌulə-m rəm, ɓá kadɨ ꞌgə-né kɨ́ i ꞌndigɨ-dé titɨ kɨ́ i ꞌndigɨ-m-né kin bè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bɔbɨ-m, dḛ kɨ́ ꞌadɨ-m-dé lé, lo kɨ́ mꞌa kisɨ-tɨ ya mꞌndigɨ kadɨ dꞌisɨ-tɨ sə-m tɔ; kdɔ kadɨ dꞌoo riɓa kɨ́ i ꞌulə dɔ-m-tɨ kinlé kɨ̀ kəm-dé. Kdɔ kete nɔ̰̀ kində gin dɔnangɨ-tɨ nṵ ya i ꞌndigɨ-m. ");
INSERT INTO mge_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bɔbɨ-m kɨ́ njèra né kɨ́ njururu, dow-je kɨ́ dɔnangɨ-tɨ nè ꞌgə-i al; ngà ma̰ mꞌgə-i rəm, ɓá dḛ kan kàrè ꞌgə kɨ́ to i ɓá ꞌulə-m rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma̰ mꞌadɨ ꞌgə ri-i rəm, mꞌa kadɨ ꞌgə ya ɓəy, kdɔ kadɨ ga̰ ndigɨ kɨ́ i ꞌndigɨ-m kinlé tò mḛḛ-dé-tɨ rəm, ɓá kadɨ mꞌisɨ mḛḛ-dé-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lokɨ Jeju pa ta-je kin bè ngá ɓá, dḛ kɨ̀ njéndó né-je liə ꞌtḛḛ dꞌɔw dꞌində wol man kɨ́ ꞌɓa-é Sedrɔ̰ ꞌgangɨ dꞌɔw kəl-é kɨ́ nṵ-tɨ. Lo-é kinlé, lo ndɔr tò-tɨ nɔ̰ɔ̰ ɓá dḛ kɨ̀ njéndó né-je liə dꞌɔw-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ə Judasɨ kɨ́ to njèkun dɔ Jeju lé, gə lo ndɔr kinlé tɔ. Kdɔtalə to lo kɨ́ Jeju dḛ kɨ̀ njéndó né-je liə dꞌɔw-tɨ low-low. ");
INSERT INTO mge_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Njékun dɔ njégugné-je lə Lubə, kɨ̀ Parisi-je dꞌɔr kosɨ asgar-je, kɨ̀ njéngəm takəy lə Lubə dꞌadɨ Judasɨ. Beɓa ḛ ɔr nɔ̰̀-dé ɔw sə-dé lo ndɔr-tɨ lé. Dḛ dꞌɔw kɨ̀ lampɨ-je, kɨ̀ pər ngəl-je, kɨ̀ nérɔ-je ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jeju gə né-je lay kɨ́ à tḛḛ dɔ-é-tɨ; beɓa ḛ ree rɔ-dé-tɨ dəjɨ-dé panè: ꞌSangi ná̰ wa? ");
INSERT INTO mge_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ə dḛ dꞌilə-é-tɨ ꞌpanè: Jꞌsangɨ Jeju kɨ́ Najarɛtɨ-tɨ. Jeju idə-dé panè: Ma̰ ya mꞌa̰ nè tin. Rəmə Judasɨ kɨ́ njèkun dɔ-é lé a̰ sə-dé natɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lokɨ Jeju idə-dé panè: Ma̰ ya ma̰ nè tin rəmə, asgar-je, kɨ̀ njéngəm takəy lə Lubə lé, ꞌtəl ꞌgɨr kɨ̀ go-dé ə ꞌtusɨ nangɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Beɓa Jeju təl dəjɨ-dé ya ɓəy panè: Ná̰ ɓá ꞌsangi-é wa? Dḛ ꞌpanè: Jꞌsangɨ Jeju kɨ́ Najarɛtɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jeju idə-dé panè: Mꞌidə-si mꞌpanè: Ma̰ ya mꞌa̰ nè tin. Kinə to ma̰ ɓá ꞌsangi-mi rəmə, in̰əi njéndó né-je lə-m kin adi dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jeju pa ta kin bè kdɔ kadɨ ta kɨ́ ndɔkɨ ḛ pa lé, né-é ra-né né; ndɔkɨ ḛ panè: «Bɔbɨ-m, dow-je kɨ́ ꞌadɨ-m-dé kinlé, kɨ́ káre ya kàrè mꞌin̰ə-é mꞌadɨ tujɨ kɔgɨ al.» ");
INSERT INTO mge_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔ̰ Piyər ulə kiyərɔ rɔ-é-tɨ nɔ̰ɔ̰ ə ɔr tugə-né mbi ngonnjèkullə lə burə dɔ njégugné-je lə Lubə. Rəmə tugə mbi-é kɨ́ dɔ jikɔl ndətɨ ya gangɨ. Ngonnjèkullə kinlé ri-é lə Malkusɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Rəmə Jeju idə Piyər lé panè: ꞌUlə kiyərɔ lə-i saba-é-tɨ gogɨ. Kɔ̰̀ kɨ́ Bɔbɨ-m ində dɔ-m-tɨ kadɨ mꞌingə lé, mꞌa kingə ya al wa? ");
INSERT INTO mge_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Beɓa njèkun dɔ asgar-je, kɨ̀ kosɨ asgar-je, kɨ̀ njégəm né-je lə jipɨ-je dꞌuwə Jeju ꞌtɔ́-é. ");
INSERT INTO mge_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Rəmə dḛ dꞌɔw siə ɓe lə An ya kete. An lé to məm Kayipɨ. Mḛḛ ɓal-é-tɨ kinlé, Kayipɨ ɓá to burə dɔ njégugné-je lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ə Kayipɨ kinlé ɓá ndɔkɨ ɔjɨ ta jipɨ-je panè: «Dow káre-rè kɨ́ kadɨ oy ə jipɨ-je lay dꞌoy-né al lé to né kɨ́ majɨ n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ngà Simɔ̰ Piyər dḛ kɨ̀ njèndó né lə Jeju káre dꞌun go Jeju. Njèndó né lə Jeju kinlé, burə dɔ njégugné-je lə Lubə gə-é kete ə ḛ ɓá ɔw kɨ̀ Jeju natɨ mḛḛ ndògɨ-tɨ lə burə dɔ njégugné-je lé. ");
INSERT INTO mge_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngà Piyər ɓá a̰ ndaa-tɨ tarəbɨ-tɨ ngɔsi. Rəmə njèndó né lə Jeju kɨ́ burə dɔ njégugné-je lə Lubə gə-é lé, tḛḛ pa ta kɨ̀ dené kɨ́ njèka̰ takəy-tɨ ə adɨ Piyər ree kəy. ");
INSERT INTO mge_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rəmə ngonnjèkullə kɨ́ dené kɨ́ njèka̰ takəy-tɨ lé, pa kɨ̀ Piyər panè: I ya kàrè ꞌto kɨ́ dan njéndó né-je-tɨ lə dingəm kanlé tɔ al wa? Ə Piyər panè: Kuy! Ma̰ mꞌto kɨ́ dan-dé-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ngannjékullə-je lə burə dɔ njégugné-je lə Lubə dḛ kɨ̀ njéngəm takəy lə Lubə ꞌra pər dꞌa̰ ta-tɨ dꞌa̰ ꞌndibɨ kdɔtalə kul ɔ̰̀; Piyər kàrè a̰ sə-dé ta pər-tɨ lé a̰ ndibɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Burə dɔ njégugné-je lə Lubə dəjɨ Jeju ta kɨ́ dɔ njéndó né-je-tɨ liə rəm, ɓá dəjɨ-é ta kɨ́ dɔ néndó-tɨ liə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Beɓa Jeju ilə-é-tɨ panè: Ma̰ mꞌpa ta rəsɨ-rəsɨ mꞌidə dow-je. Mꞌndó né dow-je mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je, kɨ̀ takəy-tɨ lə Lubə kɨ́ to lo-je kɨ́ jipɨ-je ꞌkəw-na̰-tɨ; ə ta kɨ́ mꞌpa kɨ̀ gidɨ ngə̰y ya goto. ");
INSERT INTO mge_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ma̰ ə i ꞌdəjɨ-m ta kdɔ ri wa? ꞌDəjɨ dḛ kɨ́ mꞌndó-dé né lé ya ꞌoo se ri ɓá mꞌndó-dé wa? Né-je kɨ́ mꞌndó-dé lé, dḛ ꞌgə majɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Lokɨ Jeju pa ta kinlé bè rəmə, kɨ́ káre dan njéngəm takəy lə Lubə ində mbɔ́-é ə panè: Burə dɔ njégugné-je lə Lubə lé ya ɓá i ꞌpa siə ta bè wa? ");
INSERT INTO mge_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jeju ilə-é-tɨ panè: Kinə ta kɨ́ mꞌpa lé majɨ al ə ꞌidə-m adɨ mꞌoo; ə kinə ta kɨ́ mꞌpa lé majɨ ə ꞌində-m kdɔ ri wa? ");
INSERT INTO mge_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Beɓa An ulə kɨ̀ Jeju kɨ̀ ji-é kɨ́ dɔɔ lé bè ya rɔ Kayipɨ-tɨ kɨ́ to burə dɔ njégugné-je lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ə Simɔ̰ Piyər lé rəmə a̰ ta pər-tɨ nɔ̰ɔ̰ a̰ ndibɨ. Beɓa ꞌpa siə ꞌpanè: I ya kàrè ꞌto kɨ́ dan njéndó né-je-tɨ liə tɔ al wa? Piyər najɨ panè: Kuy! Ma̰ mꞌto kɨ́ dan-dé-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rəmə dow káre dan ngannjékullə-je-tɨ lə burə dɔ njégugné-je lə Lubə kɨ́ to nojɨ dingəm kɨ́ Piyər tugə mbi-é gangɨ lé panè: «I kan, mꞌoo-i siə mḛḛ ndɔr-tɨ tɔ al wa?» ");
INSERT INTO mge_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyər təl najɨ ya ɓəy rəmə, tajinatɨ nè ya kunjə nɔ̰. ");
INSERT INTO mge_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Go-tɨ, ꞌboy-je lə jipɨ-je dꞌḭ kɨ̀ Jeju ɓee lə Kayipɨ kɨ̀ ndɔge ratɨ dꞌɔw siə mḛḛ ndògɨ-tɨ lə Gubərnər. Ngà dḛ ɓá dꞌandɨ mḛḛ ndògɨ-tɨ al, kdɔ kadɨ ꞌngəm rɔ-dé kadɨ dꞌaa njay kdɔ kɔw-né lo nékuso Pakɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Beɓa Pilatɨ ɔw ingə-dé ndaa-tɨ dəjɨ-dé panè: Ta ri ɓá sə̰i iləi dɔ dingəm-tɨ kan wa? ");
INSERT INTO mge_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dḛ dꞌilə-é-tɨ ꞌpanè: Kinə ḛ ra né kɨ́ majɨ al al lé, jꞌa ree siə rɔ-i-tɨ nè al. ");
INSERT INTO mge_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Beɓa Pilatɨ idə-dé panè: Sə̰i ya ꞌtaai-é ɔwi ꞌgangi ta dɔ-é-tɨ kɨ̀ ndukun lə-si. Dḛ jipɨ-je lé, dꞌidə-é ꞌpanè: Jḛ lé, jꞌɔw kɨ̀ tɔ́gɨ kɨ́ kadɨ jꞌtɔl-né dow al. ");
INSERT INTO mge_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bè kdɔ kadɨ ta kɨ́ Jeju pa sɔbɨ dɔ kəm rəbɨ koy-é lé, né-é ra-né né. ");
INSERT INTO mge_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatɨ təl ɔw mḛḛ ndògɨ-tɨ gogɨ ə ɓa Jeju dəjɨ-é panè: «Se i ya ɓá ꞌto ngar lə jipɨ-je lé wa?» ");
INSERT INTO mge_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jeju ilə-é-tɨ panè: «Ta kinlé, i ya ɔjɨ mḛḛ-i-tɨ ɓá ꞌpa, əse to dow-je kɨ́ rangɨ ɓá dꞌidə-i ta kɨ́ dɔ-m-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatɨ ilə-é-tɨ panè: «Ma̰ mꞌto jipɨ tɔ wa? Dow-je lə-i ya dḛ kɨ̀ njékun dɔ njégugné-je lə Lubə ɓá ꞌree sə-i rɔ-m-tɨ nè; ə to ri ɓá i ꞌra wa?» ");
INSERT INTO mge_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jeju ilə-é-tɨ panè: «Kɔ̰ɓe lə-m to kɨ́ dɔnangɨ-tɨ nè al. Kinə kɔ̰ɓe lə-m to kɨ́ dɔnangɨ-tɨ nè rəmə, lé ngannjékullə-je lə-m dꞌa rɔ kdɔ ta lə-m, kdɔ kadɨ dow ilə-m ji jipɨ-je-tɨ al; ngà kɨ́ nè kinlé kɔ̰ɓe lə-m goto dɔnangɨ-tɨ nè.» ");
INSERT INTO mge_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Beɓa Pilatɨ pa kɨ̀ Jeju panè: «ꞌAdɨ i ꞌto ngar ə́n nà̰?» Jeju ilə-é-tɨ panè: «Ta ya ꞌpa ta-i-tɨ tin, mꞌto ngar ya. Gin kojɨ kɨ́ dꞌojɨ-m, kɨ̀ ree kɨ́ mꞌree dɔnangɨ-tɨ nè lé, to ta lə kadɨ mꞌpa ta kɨ́ tɔgrɔ-tɨ mꞌadɨ dow-je. Dow kɨ́ rá-rá kɨ́ to dow lə ta kɨ́ tɔgrɔ-tɨ rəmə à koo ta lə-m.» ");
INSERT INTO mge_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatɨ dəjɨ-é panè: «Ri ɓá to ta kɨ́ tɔgrɔ-tɨ wa?» Go ta-tɨ kinlé, Pilatɨ təl ɔw rɔ jipɨ-je-tɨ ndaa-tɨ idə-dé panè: «Né kɨ́ mꞌa gangɨ-né ta dɔ-é-tɨ ya mꞌoo al.» ");
INSERT INTO mge_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngà to nékoɓe lə-si kadɨ ɓal-é ɓal-é ya kaglo ra na̰y Pakɨ rəmə, mꞌilə dangay káre taá mꞌadɨ-si lé, se ꞌndigi kadɨ mꞌilə ngar lə jipɨ-je taá mꞌadɨ-si wa? ");
INSERT INTO mge_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Beɓa dḛ ꞌtəl dꞌur kɔɔl boy-boy ꞌpanè: «Barabasɨ ɓá ilə-é taá, ɓɨ dow kan al!» Ə Barabasɨ lé, to bɔkaya dow. ");
INSERT INTO mge_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Beɓa Pilatɨ adɨ dꞌuwə Jeju dꞌində-é kɨ̀ ndəy marɔw. ");
INSERT INTO mge_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asgar-je dꞌojɨ kɔn dꞌadɨ to jɔgɨ ngar dꞌulə dɔ-é-tɨ, ɓá dꞌulə kubɨ kɨ́ kər yəl-yəl kɨ́ là-é n̰a̰ rɔ-é-tɨ; ");
INSERT INTO mge_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ə dꞌɔtɨ kɨ rɔ-é-tɨ ꞌpanè: Lapiya ɓoo, ngar lə jipɨ-je! Lapiya ɓoo, ngar lə jipɨ-je! Ə ꞌtində mbɔ́-é tɔ. ");
INSERT INTO mge_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Go-tɨ, Pilatɨ təl tḛḛ ndaa-tɨ idə jipɨ-je panè: Ooi, mꞌa təl ree siə ndaa-tɨ gogɨ kadɨ-si, kdɔ kadɨ ꞌgəi kɨ́ né kɨ́ mꞌa gangɨ-né ta dɔ-é-tɨ ya mꞌoo al. ");
INSERT INTO mge_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Beɓa Jeju tḛḛ ndaa-tɨ kɨ̀ jɔgɨ kun lé dɔ-é-tɨ rəm, ɓá kɨ̀ kubɨ kɨ́ kər yəl-yəl kɨ́ là-é n̰a̰ lé rɔ-é-tɨ rəm tɔ. Ə Pilatɨ idə-dé panè: Ooi dingəm lé ə́ a̰ tin! ");
INSERT INTO mge_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lokɨ njékun dɔ njégugné-je lə Lubə, kɨ̀ njéngəm takəy lə Lubə dꞌoo Jeju rəmə, ꞌtur kɔɔl boy-boy ꞌpanè: ꞌƁə-é kagdəsɨ-tɨ! ꞌƁə-é kagdəsɨ-tɨ! Beɓa Pilatɨ idə-dé panè: Sə̰i ya ꞌtaai-é ꞌɓəi-é kagdəsɨ-tɨ; kdɔtalə né kɨ́ mꞌa gangɨ-né ta dɔ-é-tɨ ya mꞌoo al. ");
INSERT INTO mge_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Rəmə jipɨ-je dꞌilə-é-tɨ ꞌpanè: Jḛ jꞌɔw kɨ̀ ndukun lə-ji káre nɔ̰ɔ̰ ə kɨ́ go ndukun-tɨ lə-ji kinlé, tò kadɨ Jeju oy, kdɔtalə ḛ ɓa rɔ-é Ngon lə Lubə. ");
INSERT INTO mge_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lokɨ Pilatɨ oo ta kin bè lé, ɓəl n̰a̰ ya ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Beɓa ḛ təl ɔw mḛḛ ndògɨ-tɨ gogɨ ə dəjɨ Jeju panè: I lé ꞌto dow kɨ́ rá wa? Ngà Jeju ilə-é-tɨ al. Beɓa Pilatɨ idə-é panè: ");
INSERT INTO mge_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma̰ ɓá ilə-m ta-tɨ al wa? I ꞌgə kɨ́ mꞌɔw kɨ̀ tɔ́gɨ kadɨ mꞌilə-i taá rəm, mꞌɔw kɨ̀ tɔ́gɨ kadɨ mꞌɓə-i kagdəsɨ-tɨ rəm al wa? ");
INSERT INTO mge_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jeju ilə-é-tɨ panè: Kinə Lubə adɨ-i tɔ́gɨ al rəmə, tɔ́gɨ káre ya kàrè ꞌa kɔw-né dɔ-m-tɨ al. Gin-é kin ɓá, dow kɨ́ njèkilə-m ji-i-tɨ kinlé, ra majal kɨ́ al dɔ lo. ");
INSERT INTO mge_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gangɨ-é-tɨ kinlé, Pilatɨ sangɨ rəbɨ kadɨ nꞌilə Jeju taá. Ngà jipɨ-je ꞌtur kɔɔl boy-boy ꞌpanè: Kinə ꞌilə-é taá rəmə, i ꞌto nam Sejar al. Kdɔtalə dow kɨ́ rá-rá kɨ́ ɓa rɔ-é ngar lé, to njèta lə Sejar. ");
INSERT INTO mge_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lokɨ Pilatɨ oo ta-je kin bè lé, adɨ dꞌɔw kɨ̀ Jeju ndaa-tɨ ə isɨ dɔ kali gangta-tɨ, lo-tɨ kɨ́ ꞌɓa-é gajɨ ər-je kɨ́ dꞌɔsɨ nangɨ kɨ́ ɓa-é kɨ̀ ta əbrə Gabata. ");
INSERT INTO mge_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ə to ndɔ ra go né-je kdɔ ra na̰y Pakɨ. To ta kɨ́ kàdɨ̀ à ka̰ jam dɔ ɓe-tɨ je bè ngá. Pilatɨ idə jipɨ-je panè: Ooi ngar lə-si! ");
INSERT INTO mge_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ngà dḛ ꞌtur kɔɔl boy-boy ꞌpanè: ꞌTɔl-é! ꞌTɔl-é! ꞌƁə-é kagdəsɨ-tɨ! Pilatɨ idə-dé panè: Kadɨ mꞌɓə ngar lə-si kagdəsɨ-tɨ wa? Rəmə njékun dɔ njégugné-je lə Lubə dꞌilə-é-tɨ ꞌpanè: «Jḛ lé, Sejar ya kár-é to ngar lə-ji.» ");
INSERT INTO mge_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Beɓa Pilatɨ in̰ə-é ji-dé-tɨ, kdɔ kadɨ ꞌɓə-é kagdəsɨ-tɨ. Beɓa dꞌuwə Jeju dꞌɔw siə. ");
INSERT INTO mge_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jeju utɨ kagdəsɨ liə tḛḛ-né gidɨ ɓe-tɨ ɔw-né lo-tɨ kɨ́ ꞌɓa-é: Ka dɔ dow ə ꞌɓa-é Golgota kɨ̀ ta Əbrə. ");
INSERT INTO mge_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ə ꞌɓə Jeju kagdəsɨ-tɨ lo-é-tɨ kinlé; ə ꞌɓə dow-je joo kagdəsɨ-tɨ natɨ siə tɔ; dow káre kagdəsɨ-tɨ kɨ́ dɔ jikɔl-é-tɨ ə dow káre dɔ jigəl-é-tɨ, adɨ Jeju a̰ dan-dé-tɨ dana̰. ");
INSERT INTO mge_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɨ adɨ ꞌndàngɨ ta bəgrə-tɨ ꞌɓə dɔ kagdəsɨ-tɨ lé ꞌpanè: Jeju kɨ́ Najarɛtɨ-tɨ, ngar lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jipɨ-je n̰a̰ ya ꞌndó ta kɨ́ ꞌndàngɨ bəgrə-tɨ lé, kdɔ lo kɨ́ ꞌɓə Jeju titɨ lé, tò ngɔsi kɨ̀ ɓebo ə ta kɨ́ ꞌndàngɨ mḛḛ bəgrə-tɨ lé, tò kɨ̀ ta əbrə rəm, kɨ̀ ta latḛ rəm, ɓá kɨ̀ ta grɛkɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Beɓa njékun dɔ njégugné-je lə Lubə ꞌpa kɨ̀ Pilatɨ ꞌpanè: I ꞌNdàngɨ Ngar lə jipɨ-je al; ngà kadɨ ꞌndàngɨ ꞌpanè: Ḛ panè nꞌto ngar lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ngà Pilatɨ ilə-dé-tɨ panè: Né kɨ́ mꞌndàngɨ ə mꞌndàngɨ ya ngá. ");
INSERT INTO mge_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lokɨ asgar-je ꞌɓə Jeju kagdəsɨ-tɨ lé, dḛ ꞌkay kubɨ-je liə lo sɔ ə ꞌləbɨ-na̰ káre-káre; ɓá dꞌun kubɨ kul liə kɨ́ to takubɨ kɨ́ káre-rè ya dꞌojɨ dꞌadɨ ḭ taá ree njal nangɨ kin tɔ; ɓá dꞌidə-na̰ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kubɨ kul kinlé, adi jꞌuwəi jꞌgangi al, ngà adi jꞌɔsi-na̰ mbare dɔ-tɨ jꞌooi se ná̰ ɓá à to kɨ́ liə wa? Né kinlé tò bè kdɔ kadɨ ta kɨ́ tò mḛḛ mbete-tɨ kɨ́ aa njay lé, né-é ra-né né. ꞌNdàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: «ꞌLəbɨ-na̰ kubɨ-je lə-m ə dꞌɔsɨ-na̰ mbare dɔ kubɨ kul-tɨ lə-m.» Né-é ɓá asgar-je ꞌra tin. ");
INSERT INTO mge_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kɔ̰ Jeju dḛ kɨ̀ ngonkɔ̰ kɔ̰-é rəm, Mari kɨ́ ne Klopasɨ rəm, ɓá Mari kɨ́ Magdala rəm, dꞌa̰ taá ngɔsi kɨ̀ kagdəsɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lokɨ Jeju oo kɔ̰-é a̰ mbɔ́ njèndó né-tɨ kɨ́ ḛ ndigɨ-é n̰a̰ lé rəmə, idə kɔ̰-é panè: «Dené, ꞌoo ngon-i ə a̰ tin.» ");
INSERT INTO mge_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Go-tɨ, idə njèndó né lé panè: «ꞌOo, kɔ̰-i ə a̰ tin.» Rəmə dɔkàdɨ̀-é-tɨ kin ya njèndó né lé ɔw kɨ̀ Mari ɓee rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Go né-je-tɨ kinlé, Jeju gə kɨ́ né-je lay asɨ ngá adɨ panè: «Kundə ra-m», bè kdɔ kadɨ ta kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay lé, né-é ra-né né. ");
INSERT INTO mge_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lo-é-tɨ kinlé man nduu kɨ́ masɨ tò mḛḛ ba̰y-tɨ rusɨ nɔ̰ɔ̰. Beɓa asgar-je dꞌun kagɨ kɨ́ ꞌɓa-é ijopɨ ə ꞌdɔɔ ndɔkrɔ ta-tɨ ɓá dꞌulə kəm man nduu-tɨ kɨ́ masɨ lé dꞌulə ta Jeju-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lokɨ Jeju njibɨ man nduu kɨ́ masɨ lé rəmə panè: «Né-je lay asɨ ngá.» Go-tɨ, Jeju ulə dɔ-é nangɨ rəmə in̰ə ndil-é adɨ tḛḛ. ");
INSERT INTO mge_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ndɔ-é-tɨ kinlé, to ndɔ ra go né-je kdɔ ndɔ taakoo lə jipɨ-je. Adɨ jipɨ-je ꞌɓəl kadɨ nin dow-je tò kagdəsɨ-tɨ ndɔ taakoo-tɨ lə-dé, kdɔtalə to ndɔ kɨ́ boy n̰a̰; gin-é kin ɓá dḛ ꞌdəjɨ Pilatɨ kadɨ adɨ ꞌtətɨ nja-dé ə dꞌɔr-dé nangɨ. ");
INSERT INTO mge_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Beɓa dow-je kɨ́ ꞌɓə-dé kagdəsɨ-tɨ kɨ̀ Jeju lé, asgar-je ꞌtə́tɨ nja ḛ kɨ́ dɔsa̰y rəm, ꞌtə́tɨ nja ḛ kɨ́ njèkungɨ-tɨ joo rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lokɨ ꞌree ꞌtḛḛ dɔ Jeju-tɨ rəmə, dꞌoo kɨ́ Jeju oy ngá, adɨ ꞌtə́tɨ nja-é al; ");
INSERT INTO mge_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ngà dow káre dan asgar-je-tɨ ɓá ɔsɨ kàdɨ̀-é kɨ̀ ningə mbutɨ adɨ tajinatɨ nè ya məsɨ-je kɨ̀ man a̰y-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Né-je kinlé, dow kɨ́ oo kɨ̀ kəm-é ɓá pa ta kɨ́ dɔ-tɨ tin; ə ta liə to ta kɨ́ tɔgrɔ-tɨ; ḛ gə kɨ́ nꞌpa ta kɨ́ tɔgrɔ-tɨ, kdɔ kadɨ sə̰i kàrè adi-né mḛḛ-si tɔ. ");
INSERT INTO mge_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Né kinlé ra né bè kdɔ kadɨ ta kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: «Singə-é káre ya kàrè dow à tətɨ al» kinlé né-é ra né. ");
INSERT INTO mge_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mbete kɨ́ aa njay pa lo kɨ́ rangɨ-tɨ ɓəy panè: Dꞌa koo ḛ kɨ́ dꞌɔsɨ kàdɨ̀-é kɨ̀ ningə ꞌmbutɨ lé kɨ̀ kəm-dé. ");
INSERT INTO mge_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Go né-je-tɨ kinlé, Jojepɨ kɨ́ ɓe liə to Arimate, kɨ́ to njèndó né lə Jeju ya, ngà tɔjɨ ɓá tɔjɨ rɔ-é ndaa-tɨ al kdɔ ɓəl kɨ́ ḛ ɓəl ꞌboy-je lə jipɨ-je lé, ɔw dəjɨ Pilatɨ kadɨ nꞌɔr nin Jeju lé. Beɓa Pilatɨ in̰ə tarəbɨ adɨ-é, ngá ɓá ḛ ɔr nin Jeju lé ɔw-né. ");
INSERT INTO mge_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodḛm kɨ́ ndɔkɨ ɔw rɔ Jeju-tɨ ndɔɔ lé, ree kɨ̀ ubɨ kɨ́ ꞌɓa-é mir kɨ́ ꞌpote natɨ kɨ̀ ubɨ kɨ́ ꞌɓa-é aloé kɨ́ à kasɨ litɨr ɓu je bè. ");
INSERT INTO mge_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ə dḛ joo lay dꞌun nin Jeju lé, ꞌndəm-é ubɨ kɨ́ ꞌra kɨ̀ putɨ kagɨ kɨ́ ətɨ majɨ ɓá ꞌɓɨr-é kɨ̀ kubɨ, titɨ kɨ́ jipɨ-je ꞌra-né low-low. ");
INSERT INTO mge_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Rəmə, lokɨ ꞌɓə Jeju kagdəsɨ-tɨ titɨ lé, lo ndɔr tò-tɨ nɔ̰ɔ̰; ə ɓe nin kɨ́ ꞌra sigɨ, kɨ́ ꞌdubɨ dow-tɨ al ɓəy ya tò lo ndɔr-tɨ lé nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɓe-é kinlé ɓá tò ngɔsi adɨ dꞌilə nin Jeju-tɨ, kdɔtalə to ndɔ kɨ́ jipɨ-je dꞌisɨ ꞌra-né go né-je kdɔ ndɔ taakoo. ");
INSERT INTO mge_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ndɔ Dimasɨ kɨ̀ ndɔge ratɨ kɨ́ lo aa lay al ya ɓəy, Mari kɨ́ Magdala ɔw dɔɓadɨ-tɨ. Ḛ oo kɨ́ ər kɨ́ boy kɨ́ dꞌutɨ-né ta ɓe nin lé tokɨ nduburu kilə rangɨ. ");
INSERT INTO mge_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Beɓa ḛ a̰y ngɔdɨ ɔw ingə Simɔ̰ Piyər-je kɨ̀ njèndó né káre kɨ́ Jeju ndigɨ-é n̰a̰, ə idə-dé panè: «Dꞌɔr ꞌƁaɓe ɓe nin-tɨ adɨ jꞌgə lo kɨ́ dꞌilə-é-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyər-je kɨ̀ njèndó né kɨ́ káre lé, ꞌtḛḛ dꞌɔw kɨ dɔɓadɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dḛ joo lay ya dꞌa̰y ngɔdɨ; ngà njèndó né kɨ́ káre lé a̰y itə Piyər, adɨ ḛ tḛḛ ta ɓe nin-tɨ lé kete. ");
INSERT INTO mge_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ḛ ɗugɨ nangɨ rəmə, takubɨ-je kɨ́ tò nangɨ ɓá ḛ oo; ngà kandɨ ɓá ḛ andɨ ɓe nin-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Rəmə Simɔ̰ Piyər kɨ́ ore go-é lé ɓá ree andɨ ɓe nin-tɨ ə oo takubɨ-je kɨ́ tò nangɨ lé. ");
INSERT INTO mge_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Takubɨ kɨ́ ꞌɓɨr-né dɔ Jeju lé tò natɨ kɨ̀ takubɨ-je kɨ́ ꞌɓɨr-é-né lé al, ngà tokɨ ɓɨr kilə gay. ");
INSERT INTO mge_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Go-tɨ, njèndó né kɨ́ káre kɨ́ tḛḛ ta ɓe nin-tɨ kete lé, andɨ ɓe nin-tɨ lé tɔ. Ḛ oo né-je kinlé ə adɨ mḛḛ-é. ");
INSERT INTO mge_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kdɔ ta kɨ́ mbete kɨ́ aa njay pa panè Jeju à tɔsɨ ndəl kində lo tḛḛ dan dow-je-tɨ kɨ́ dꞌoy lé, njéndó né-je ꞌgə mḛḛ-é al ɓəy. ");
INSERT INTO mge_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Go-tɨ, njéndó né-je ꞌtəl dꞌɔw ɓee lə-dé. ");
INSERT INTO mge_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dɔgangɨ-é-tɨ kinlé, Mari a̰ ta ɓe nin-tɨ ndaa-tɨ a̰ nɔ̰ ə ɗugɨ nangɨ kdɔ kadɨ nꞌoo ɓe nin rəmə, ");
INSERT INTO mge_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oo malayka-je joo dꞌulə kubɨ kɨ́ nda rɔ-dé-tɨ dꞌisɨ-né lo-tɨ kɨ́ dꞌilə nin Jeju-tɨ lé. Malayka kɨ́ káre isɨ lo-tɨ kɨ́ dɔ-é-tɨ, ə ḛ kɨ́ káre isɨ lo-tɨ kɨ́ nja-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dḛ ꞌdəjɨ Mari lé ꞌpanè: «Dené, i ꞌnɔ̰ kdɔ ri wa?» Ḛ ilə-dé-tɨ panè: «Dꞌɔr ꞌƁaɓe lə-m adɨ mꞌoo lo kɨ́ dꞌilə-é-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lokɨ ḛ a̰ pa ta kin bè ya rəmə təl kəm-é ə oo Jeju a̰ taá nè. Ngà gə ɓá ḛ gə kɨ́ to Jeju al. ");
INSERT INTO mge_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jeju lé dəjɨ-é panè: «Dené, i ꞌnɔ̰ kdɔ ri wa? Ná̰ ɓá i ꞌsangɨ-é wa?» Ḛ gɨr kɨ́ to njèndɔr lé, adɨ ḛ idə-é panè: «ꞌƁa-m, kinə to i ɓá ɔr-é rəmə, ꞌidə-m lo kɨ́ ilə-é-tɨ ə mꞌa kɔw kun-é.» ");
INSERT INTO mge_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jeju panè: «Mari!» Beɓa Mari təl kəm-é rəmə, pa siə ta kɨ̀ ta Əbrə panè: «Rabuni», adɨ kɔr mḛḛ-é to Njèndó dow-je né! ");
INSERT INTO mge_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jeju idə-é panè: «ꞌƆdɨ rɔ-m al, kdɔ mꞌɔw rɔ Bɔbɨ-m-tɨ al ɓəy. Ngà kɔw ɓá ꞌɔw rɔ ngankɔ̰-m-je-tɨ, ə ꞌidə-dé kɨ́ mꞌisɨ mꞌɔw kɨ rɔ Bɔbɨ-m-tɨ kɨ́ to Bɔbɨ-si tɔ, mꞌisɨ mꞌɔw kɨ rɔ Lubə-tɨ lə-m kɨ́ to Lubə lə-si tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari kɨ́ Magdala lé ɔw idə njéndó né-je kɨ́ nꞌoo ꞌƁaɓe ə idə-dé ta-je kɨ́ ḛ pa adɨ-é. ");
INSERT INTO mge_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ndɔ Dimasɨ-é-tɨ kin ya, lokɨ ndɔ isɨ il rəmə, njéndó né-je kɨ́ ꞌkəw-na̰ mḛḛ kəy-tɨ lé, dꞌutɨ takəy-je ta-dé-tɨ, kdɔ dḛ ꞌɓəl ꞌboy-je lə jipɨ-je. Ə Jeju ree a̰ taá dan-dé-tɨ ɓá idə-dé panè: «Kadɨ lapiya nà̰y sə-si!» ");
INSERT INTO mge_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Go ta-tɨ kɨ́ ḛ pa kinlé, ḛ tɔjɨ-dé ji-é-je kɨ̀ kàdɨ̀-é-je. Lokɨ njéndó né-je dꞌoo ꞌƁaɓe rəmə, rɔ-dé nəl-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jeju təl pa sə-dé ta nja káre ya ɓəy panè: «Kadɨ lapiya nà̰y sə-si. Titɨ kɨ́ Bɔbɨ-m ulə-m-né lé, ma̰ kàrè mꞌulə-si tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Go ta-je-tɨ kinlé, ḛ tó koo puu kɨ dɔ-dé-tɨ ə idə-dé panè: «ꞌTaai Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dow-je kɨ́ a kin̰əi go majal-je lə-dé kɔgɨ lé, majal-je lə-dé à tokɨ kin̰ə go-é kɔgɨ tɔ. Ə dow-je kɨ́ a kin̰əi go majal-je lə-dé kɔgɨ al lé, majal-je lə-dé à tokɨ kin̰ə go-é kɔgɨ al ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lokɨ Jeju tḛḛ dɔ njéndó né-je-tɨ liə lé, Tomasɨ kɨ́ ꞌɓa-é Ndungə kɨ́ ḛ to kɨ́ káre dan njéndó né-je-tɨ kɨ́ dɔgɨ gidɨ-é joo lé goto. ");
INSERT INTO mge_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Beɓa ndəgɨ njéndó né-je dꞌidə-é ꞌpanè: «Jꞌoo ꞌƁaɓe!» Ngà Tomasɨ idə-dé panè: «Kinə mꞌoo tó dò pɔ̰ḭtɨ-je kɨ́ ji-é-tɨ al rəm, mꞌulə ngon ji-m tó dò pɔ̰ḭtɨ-tɨ al rəm, ɓá kinə mꞌulə ji-m kàdɨ̀-é-tɨ al rəm lé, mꞌa kadɨ mḛḛ-m nda̰ bè al.» ");
INSERT INTO mge_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ndɔ jinà̰y joo go-tɨ lé, njéndó né-je lə Jeju ꞌtəl ꞌkəw-na̰ mḛḛ kəy-tɨ, ə Tomasɨ isɨ sə-dé natɨ. Dḛ dꞌutɨ takəy-je ya rəmə, Jeju tḛḛ a̰ taá dan-dé-tɨ ə idə-dé panè: «Kadɨ lapiya nà̰y sə-si!» ");
INSERT INTO mge_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Go-tɨ, ḛ idə Tomasɨ lé panè: «ꞌUlə ngon ji-i nè, ə ꞌoo ji-m. ꞌUlə ji-i kɨ kete, ə ꞌulə kàdɨ̀-m-tɨ lé. ꞌIn̰ə mḛḛnga̰ lə-i, ə ꞌadɨ mḛḛ-i!» ");
INSERT INTO mge_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Beɓa Tomasɨ ilə-é-tɨ panè: «ꞌƁaɓe lə-m, Lubə lə-m!» ");
INSERT INTO mge_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ə Jeju idə-é panè: «Kdɔ koo kɨ́ i ꞌoo-m ɓá i adɨ-né mḛḛ-i. Dow-je kɨ́ dꞌoo-m al ya dꞌadɨ mḛḛ-dé kin ɓá ꞌto njénékumə̰-je.» ");
INSERT INTO mge_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeju ra nékɔjɨ-je kɨ́ rangɨ n̰a̰ ya ɓəy takəm njéndó né-je-tɨ liə, ngà ta-é ɓá to kɨ́ ndàngɨ mḛḛ mbete-tɨ kinlé al. ");
INSERT INTO mge_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngà nékɔjɨ-je kɨ́ ꞌndàngɨ ta-é mḛḛ mbete-tɨ kinlé, tò bè kdɔ kadɨ adi-né mḛḛ-si kɨ́ Jeju to Kristɨ, to Ngon lə Lubə, adɨ kinə adi-é mḛḛ-si rəmə, a kisi kəm kɨ̀ ri-é. ");
INSERT INTO mge_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ndɔ-je kɨ́ rangɨ go-tɨ, Jeju təl tɔjɨ rɔ-é njéndó né-je liə ta babo Tiberiadɨ-tɨ. Ooi, kəm rəbɨ kɨ́ tɔjɨ-né rɔ-é ə́n: ");
INSERT INTO mge_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ̰ Piyər-je kɨ̀ Tomasɨ kɨ́ ꞌɓa-é ndungə rəm, Nataniyel kɨ́ to dow kɨ́ Kana̰ kɨ́ dɔnangɨ Galile-tɨ rəm, ngan lə Jebede rəm, ɓá njéndó né-je lə Jeju kɨ́ rangɨ joo ɓəy rəm, dꞌa̰ kəm-na̰-tɨ lay. ");
INSERT INTO mge_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔ̰ Piyər idə-dé panè: Mꞌa kɔw mbɔw-tɨ. Rəmə dḛ ꞌpanè: Jḛ kàrè jꞌa kɔw sə-i tɔ. Ə dḛ ꞌtḛḛ dꞌɔw dꞌal mḛḛ tò-tɨ, ngà ndɔɔ nɔ̰ɔ̰ lé dꞌuwə kanjɨ al. ");
INSERT INTO mge_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lokɨ lo aa yərərə rəmə, Jeju ree a̰ ngangɨ ba-tɨ; ngà njéndó né-je ꞌgə kɨ́ to Jeju al. ");
INSERT INTO mge_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Beɓa ḛ dəjɨ-dé panè: Ngan-je, uwəi kanjɨ nɔ̰ɔ̰ wa? Dḛ dꞌilə-é-tɨ ꞌpanè: Kanjɨ káre ya kàrè jꞌuwə al. ");
INSERT INTO mge_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Rəmə idə-dé ꞌpanè: Iləi burə kɨ̀ dɔ jikɔl tò-tɨ bè ə a kuwəi kanjɨ. Lokɨ dꞌilə burə lé rəmə, burə saa kanjɨ mbing ya adɨ dꞌasɨ kɔr tḛḛ-né ndaa-tɨ al. ");
INSERT INTO mge_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Beɓa njèndó né lə Jeju kɨ́ Jeju ndigɨ-é idə Piyər panè: Dow lé to ꞌƁaɓe! Lokɨ Piyər oo kɨ́ to ꞌƁaɓe rəmə, ḛ un kubɨ liə ulə; kdɔ kete a̰ kɨ̀ rɔ-é kare ə ur mani. ");
INSERT INTO mge_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngà ndəgɨ njéndó né-je ꞌndɔr burə kɨ́ kanjɨ rusɨ lé, ꞌnəl-né tò kdɔ ree-né ngangɨ ba-tɨ; kdɔ lo kɨ́ ngangɨ ba-tɨ tò ngɔsi sə-dé, à kasɨ mɛtər ɓu je bè. ");
INSERT INTO mge_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lokɨ dꞌur nangɨ ngangɨ ba-tɨ rəmə, dꞌoo yalpər kɨ́ kanjɨ tò dɔ-tɨ ɓá dꞌoo mbə̀ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Beɓa Jeju idə-dé panè: Kanjɨ kɨ́ uwəi lé, ɔyi kɨ́ dan-tɨ-je ꞌreei-né. ");
INSERT INTO mge_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Beɓa Simɔ̰ Piyər təl al mḛḛ tò-tɨ ɔr burə lé nangɨ ə kanjɨ-je kɨ́ boy-boy ya ꞌrusɨ burə lé ə dḛ ɓu kɨ̀ kɔrmḭ gidɨ-é mutə; bè ya kàrè burə gangɨ al. ");
INSERT INTO mge_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jeju idə-dé panè: ꞌReei usoi né; ya rəmə dow káre dan njéndó né-je-tɨ kɨ́ kadɨ dəjɨ-é panè i ꞌto ná̰ wa ya goto, kdɔtalə dḛ ꞌgə kɨ́ to ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Beɓa Jeju ree rɔ-dé-tɨ, un mbə̀ lé adɨ-dé ɓá adɨ-dé kanjɨ lé dɔ-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","To nja mutə ngá kɨ́ Jeju tɔjɨ-né rɔ-é njéndó né-je liə lokɨ tɔsɨ-né ndəl ində lo tḛḛ dan dow-je-tɨ kɨ́ dꞌoy. ");
INSERT INTO mge_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Go né kuso-tɨ, Jeju dəjɨ Simɔ̰ Piyər panè: Simɔ̰, ngon lə Jonasɨ ꞌndigɨ-m itə ndəgɨ-é-je kin wa? Simɔ̰ panè: Oiyo, ꞌƁaɓe ꞌgə kɨ́ mꞌndigɨ-i. Jeju panè: ꞌUl ngan batɨ-je lə-m! ");
INSERT INTO mge_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jeju təl dəjɨ-é dəjɨ kɨ́ nja joo panè: Simɔ̰, ngon lə Jonasɨ ꞌndigɨ-m wa? Piyər idə-é panè: Oiyo ꞌƁaɓe, ꞌgə kɨ́ mꞌndigɨ-i. Jeju idə-é panè: ꞌUl batɨ-je lə-m. ");
INSERT INTO mge_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jeju təl dəjɨ-é dəjɨ kɨ́ nja mutə panè: Simɔ̰, ngon lə Jonasɨ, ꞌndigɨ-m wa? Rəmə rɔ Piyər atɨ-é kana̰na̰ kdɔ dəjɨ kɨ́ Jeju dəjɨ-é nja mutə panè: ꞌNdigɨ-m wa? Ɓá ilə-é-tɨ panè: ꞌƁaɓe i ꞌgə né-je lay, ꞌgə kɨ́ mꞌndigɨ-i ya. Jeju idə-é panè: ꞌUl batɨ-je lə-m. ");
INSERT INTO mge_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ꞌOo majɨ, mꞌa kidə-i rəsɨ; lokɨ i ꞌto basa ɓəy lé, i ya ꞌdɔɔ ndaá dɔɔ ɓədɨ lə-i, ə lo kɨ́ mḛḛ-i ndigɨ ya ə i ꞌɔw-tɨ, ngà lokɨ i ꞌa ɓugə lé, i ꞌa kɔy ji-i kɨ taá kadɨ dow kɨ́ rangɨ ɓá à dɔɔ ndaá dɔɔ ɓədɨ lə-i, ə lo kɨ́ mḛḛ-i ndigɨ al ya ḛ à kɔw sə-i-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jeju pa ta kin bè kdɔ tɔjɨ-né kəm rəbɨ koy kɨ́ Piyər à koy kdɔ kɔsɨ-né gajɨ Lubə; go ta-tɨ kinlé, Jeju idə-é panè: ꞌUn go-m. ");
INSERT INTO mge_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lokɨ Piyər təl kəm-é kɨ gogɨ rəmə, oo njèndó né kɨ́ Jeju ndigɨ-é ɔw ree go-dé-tɨ; njèndó né kinlé ɓá ndɔkɨ tò kàdɨ̀ Jeju-tɨ ta nékuso-tɨ ɓá dəjɨ-é panè: «ꞌƁaɓe, ná̰ ɓá à kun dɔ-i wa?» lé. ");
INSERT INTO mge_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lokɨ Piyər oo-é lé, dəjɨ Jeju panè: «ꞌƁaɓe, ngà ḛ kan ri ɓá à tḛḛ dɔ-é-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeju idə-é panè: «Kinə mꞌndigɨ kadɨ-é isɨ bè-bè ya sar kadɨ mꞌtəl mꞌree-né lé, ꞌusɨ-i ri-tɨ wa? I, ꞌun go-m.» ");
INSERT INTO mge_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Beɓa njékadmḛḛ-je ꞌtilə ta kinlé mbi-na̰-tɨ kɨ kete-kete ꞌpanè: «Njèndó né kinlé à koy al.» Ngà kɨ́ tɔgrɔ-tɨ bè lé, Jeju idə-é panè: «À koy al al» ngà ḛ panè: «Kinə mꞌndigɨ kadɨ-é isɨ bè-bè ya sar kadɨ mꞌtəl mꞌree-né lé, ꞌusɨ-i ri-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Njèndó né kinlé ya ɓá pa ta kɨ́ dɔ né-je-tɨ kin adɨ dow-je rəm, ḛ ya ndàngɨ ta-je kin rəm. Ə jꞌgə kɨ́ ta liə to ta kɨ́ tɔgrɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jeju ra né-je kɨ́ rangɨ n̰a̰ ya ɓəy; ngà kinə kadɨ ꞌndàngɨ bɛtɨ-bɛtɨ lay lé, mꞌoo kɨ́ tatɨ dɔnangɨ kin lay ya kàrè, mbete-je kɨ́ dꞌa ndàngɨ lé à kubə.");
INSERT INTO mge_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","I nam-m Teopil, mḛḛ mbete-tɨ kɨ́ dɔsa̰y kɨ́ mꞌndàngɨ lé, mꞌɔr poy né-je lay kɨ́ Jeju ra, kɨ̀ né-je kɨ́ ḛ ndó dow-je lo kulə gin-é-tɨ nṵ ya sar tḛḛ-né ");
INSERT INTO mge_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ndɔ-tɨ kɨ́ Lubə un-é ɔw-né siə dɔra̰-tɨ. Kete ɓá kadɨ Lubə un-é ɔw siə dɔra̰-tɨ lé, ḛ mbətɨ njékɔwkulə-je liə ə un ndu adɨ-dé kɨ̀ tɔ́gɨ lə Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Beɓa go koy-é-tɨ, dḛ ya tɔ ɓá ḛ tḛḛ sə-dé kɔy ə adɨ-dé ꞌgə né-je kɨ́ gay-gay kɨ́ tɔjɨ kɨ́ to nꞌḛ̀ lé ya ɓá nꞌtəl nꞌisɨ kəm. Jeju tḛḛ sə-dé kɔy bè-bè ya asɨ ndɔ kɔrsɔ, ə pa sə-dé ta kɨ́ dɔ kɔ̰ɓe-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Beɓa ndɔ káre bè, ḛ isɨ uso sə-dé né, ɓá idə-dé panè: «ꞌTḛḛi ɓebo Jorijalḛm-tɨ ɔwi rangɨ al. Ngà ꞌngəbi né kɨ́ Bɔbɨ-m un mindɨ-é kadɨ nꞌadɨ-si, ɓá ndɔkɨ mꞌpa ta-é mꞌadɨ-si lé. ");
INSERT INTO mge_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ja̰ lé, ra dow-je batḛm mani. Ngà sə̰i rəmə, nà̰y ndɔ n̰a̰ al ya kadɨ ꞌrai batḛm lə Ndil kɨ́ aa njay.» ");
INSERT INTO mge_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Njékɔwkulə-je kɨ́ ꞌkəw-na̰ lé, ꞌdəjɨ Jeju ꞌpanè: «ꞌƁaɓe, dɔkaglo-é-tɨ kin ɓá i ꞌa təl-né kɨ̀ kɔ̰ɓe lə Israyel-je kadɨ-dé gogɨ lé wa?» ");
INSERT INTO mge_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Beɓa Jeju ilə-dé-tɨ panè: «Dɔkàdɨ̀-je əse ndɔ-je kɨ́ Bɔbɨ-m ya kɨ̀ kár-é ɔjɨ kɨ́ go tɔ́gɨ-tɨ liə kɨ́ sɔbɨ dɔ-é lé, to ta lə-si kadɨ ꞌgəi al. ");
INSERT INTO mge_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngà sə̰i lé, a kingəi tɔ́gɨ, lokɨ Ndil kɨ́ aa njay à ree dɔ-si-tɨ. Beɓa sə̰i a toi-né njékɔr poy né ra-m-je kɨ́ ooi kɨ̀ kəm-si, kɨ̀ ta pa-m-je kɨ́ ooi kɨ̀ mbi-si kadɨ dow-je kɨ́ ɓebo Jorijalḛm-tɨ rəm, dɔnangɨ Jude-tɨ rəm, ɓá dɔnangɨ Samari-tɨ lay sar ya ta sɔ̰y dɔnangɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Beɓa go ta-je-tɨ kinlé, kəm-dé tò kɨ dɔ Jeju-tɨ adɨ dꞌa̰ dꞌoo-é ya rəmə, Lubə un-é isɨ ɔw siə dɔra̰-tɨ, ə kilndi ree utɨ go-é adɨ dꞌoo-é al. ");
INSERT INTO mge_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lokɨ dꞌa̰ dꞌoo go Jeju lo kɔw-é dɔra̰-tɨ ya ɓəy rəmə, dingəm-je joo kɨ́ ꞌtulə kubɨ kɨ́ nda rɔ-dé-tɨ ꞌtḛḛ ");
INSERT INTO mge_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","dꞌidə-dé ꞌpanè: «Ooi bè, sə̰i dingəm-je kɨ́ dɔnangɨ Galile-tɨ! Kdɔ ri ɓá a̰i ká koo lo-tɨ kɨ dɔra̰-tɨ bè wa? Jeju kin, kɨ́ Lubə un-é dan-si-tɨ ɔw siə dɔra̰-tɨ kinlé, à təl ree ga̰-é kɨ́ ooi-é-né lo kɔw-é dɔra̰-tɨ kin ya bè tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Beɓa njékɔwkulə-je dꞌḭ dɔ mbal-tɨ kɨ́ ꞌɓa-é mbal ka̰ kagɨ Olibiye-je ꞌtəl dꞌɔw ɓebo Jorijalḛm-tɨ gogɨ. Mbal kinlé, tò mbɔ́ ɓebo Jorijalḛm-tɨ, adɨ dow à njiyə asɨ ngan kàdɨ̀ kɔrmutə-je bè ɓá à tḛḛ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lokɨ ꞌree ꞌtḛḛ ɓebo Jorijalḛm-tɨ lé, dḛ dꞌɔw mḛḛ kəy-tɨ kɨ́ dɔ madɨ-é-tɨ taá kɨ́ dꞌisɨ-tɨ kete-kete. Dḛ kɨ́ dꞌisɨ nɔ̰ɔ̰ lé to: Piyər-je, kɨ̀ Ja̰-je, kɨ̀ Jakɨ-je, kɨ̀ Andre-je, kɨ̀ Pilipɨ-je, kɨ̀ Tomasɨ-je, kɨ̀ Batlemi-je, kɨ̀ Matiye-je, kɨ̀ Jakɨ kɨ́ ngon lə Alpe-je, kɨ̀ Judɨ kɨ́ ngon lə Jakɨ, kɨ̀ Simɔ̰ kɨ́ to dow kɨ́ ta ɓe liə to-é. ");
INSERT INTO mge_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Dḛ lay ya ta-dé asɨ-na̰ adɨ ꞌkəw-na̰ taá-taá kdɔ pa ta kɨ̀ Lubə, natɨ kɨ̀ dené-je kɨ́ dan-tɨ-je, kɨ̀ Mari kɨ́ kɔ̰ Jeju, ɓá ngankɔ̰ Jeju-je tɔ. ");
INSERT INTO mge_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ndɔ káre, mḛḛ ndɔ-é-je-tɨ kinlé, njékadmḛḛ-je ꞌkəw-na̰ adɨ kɔr-dé à kasɨ ɓu kɨ́ kɔrjoo-je bè, rəmə Piyər ḭ taá dan-dé-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ngankɔ̰-m-je, Ndil kɨ́ aa njay adɨ Dabidɨ pa ta kete mḛḛ mbete-tɨ kɨ́ aa njay sɔbɨ-né dɔ Judasɨ kɨ́ to njèkɔr nɔ̰̀ njékuwə Jeju. Ta kinlé, kadɨ né-é ra né ɓane. ");
INSERT INTO mge_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasɨ lé, to kɨ́ káre dan-ji-tɨ, ɓá ɔw kɨ̀ kullə liə dan-ji-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Dingəm kinlé, ɔw ndogɨ lo ndɔr kɨ̀ là kɨ́ ꞌndogɨ-né siə dow ꞌtɔl-é lé. Ḛ usɨ ur dɔ-é nangɨ lo-é-tɨ lé. Beɓa mḛḛ-é ribə adɨ ngan tḭ-é kujə lay. ");
INSERT INTO mge_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dow-je kɨ́ ɓebo Jorijalḛm-tɨ lay ya dꞌoo ta-é adɨ dḛ ꞌɓa lo ndɔr kinlé kɨ̀ ta ɓe lə-dé ꞌpanè: “Akeldama”, kɔr mḛḛ-é to “lo ndɔr kɨ́ ꞌndogɨ kɨ̀ là məsɨ.” ");
INSERT INTO mge_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kdɔ ꞌndàngɨ mḛḛ Pa-je-tɨ ꞌpanè: “Kadɨ kəy liə tò kare pɛtɨ-pɛtɨ, ə kadɨ dow isɨ-tɨ al.”» «Ɓa ꞌtəl ꞌpa mḛḛ mbete-tɨ ɓəy ꞌpanè: “Kadɨ dow kɨ́ rangɨ un ta kullə liə.”» ");
INSERT INTO mge_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Beɓa kadɨ dingəm káre ree ore kadɨ-ji, kdɔ kadɨ pa ta kɨ́ dɔ tɔsɨ-tɨ kɨ́ Jeju tɔsɨ ndəl ində lo tḛḛ, kɨ́ ḛ oo kɨ̀ kəm-é lé sə-ji. Dowbé lé, à to dow káre dan dow-je-tɨ kɨ́ njédan-ji kɨ̀ kaglo-je lay kɨ́ jꞌnjiyəi-né kɨ̀ Jeju kɨ̀ lo-lo, adɨ à to kḭ dɔ ndɔ-tɨ kɨ́ Ja̰ ra-é-né batḛm sar tḛḛ-né ndɔ-tɨ kɨ́ Lubə un-é ɔw-né siə dɔra̰-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Beɓa dḛ dꞌɔr dow-je joo adɨ to: Matiyasɨ dḛ kɨ̀ Jojepɨ kɨ́ ꞌɓa-é Barsabasɨ ə ri gajɨ-é to Justusɨ. ");
INSERT INTO mge_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Go-tɨ, ꞌpa ta kɨ̀ Lubə ꞌpanè: «ꞌƁaɓe i kɨ́ ꞌgə mḛḛ dow-je lay, ꞌtɔjɨ-ji dow káre kɨ́ i mbətɨ-é dan dḛ-tɨ kɨ́ joo kin, ");
INSERT INTO mge_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kdɔ kadɨ to njèkɔwkulə lə Jeju, tó lo-tɨ kɨ́ Judasɨ in̰ə kɔgɨ ɔw lo-tɨ kɨ́ tuwə kullə ra-é kin.» ");
INSERT INTO mge_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dḛ ꞌɓa ri-dé dꞌɔsɨ-né kagɨ dɔ-dé-tɨ, rəmə kagɨ usɨ dɔ Matiyasɨ-tɨ, adɨ ḛ ore kàdɨ̀ njékɔwkulə-je kɨ́ dɔgɨ gidɨ-é káre lé. ");
INSERT INTO mge_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lokɨ ndɔ ra na̰y lə jipɨ-je kɨ́ ꞌɓa-é Pantekotɨ asɨ lé, njékadmḛḛ-je ꞌkəw-na̰ lay lo káre-rè. ");
INSERT INTO mge_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Titɨ kəm kɨ́ kində jipɨ bè ya rəmə, ká né ɓa dɔra̰-tɨ titɨ-na̰ kɨ̀ ká yə́lbo bè. Ká né lé taa mḛḛ kəy kɨ́ dꞌisɨ-tɨ lé pəl-pəl. ");
INSERT INTO mge_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Rəmə dꞌoo ndɔ̰ né titɨ-na̰ kɨ̀ ndɔ̰ pər bè, sane, risɨ dɔ-dé-tɨ káre-káre lay. ");
INSERT INTO mge_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dḛ lay ya Ndil kɨ́ aa njay taa mḛḛ-dé pəl-pəl adɨ ná̰-ná̰ ya kàrè ulə gin pa ndɔ̰ ta lə dow-je kɨ́ rangɨ, kɨ̀ go gangɨ-é kɨ́ Ndil kɨ́ aa njay adɨ-é kadɨ pa-né. ");
INSERT INTO mge_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ndɔ-é-tɨ kinlé, jipɨ-je kɨ́ njékilə kujɨ dɔ Lubə-tɨ kɨ́ dꞌḭ kɨ̀ ɓe-je kɨ́ dɔnangɨ-tɨ nè lay ya ꞌree mba, adɨ dꞌisɨ mḛḛ ɓebo Jorijalḛm-tɨ nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Lokɨ ká né ɓa n̰a̰ bè lé, kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya tətɨ-na̰ yipɨ dꞌa̰y kɨ lo-é-tɨ. Rəmə ndil-dé tḛḛ sa̰y, kdɔtalə ná̰-ná̰ ya kàrè, oo ta kɨ́ ta njékadmḛḛ-je-tɨ kɨ̀ ta kojɨ-é kojɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɔr ndil-dé, lo ta igɨ-dé sə́l, rəmə ꞌpanè: «Kay! Dow-je kɨ́ dꞌa̰ ꞌpa ta kinlé, se ꞌto dow-je kɨ́ Galile ya lay al wa? ");
INSERT INTO mge_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ngà ra ban ɓá ná̰-ná̰ dan-ji-tɨ nè ya oo ndi-dé kɨ̀ ta kojɨ-é kojɨ-é bè wa?» ");
INSERT INTO mge_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dow-je kɨ́ dꞌḭ kɨ dɔnangɨ Partɛsɨ-tɨ, kɨ̀ dɔnangɨ Medi-tɨ, kɨ̀ dɔnangɨ Elam-tɨ, kɨ̀ dɔnangɨ Mejopotami-tɨ, kɨ̀ dɔnangɨ Jude-tɨ, kɨ̀ dɔnangɨ Kapadosɨ-tɨ, kɨ̀ dɔnangɨ Pɔ̰-tɨ, kɨ̀ dɔnangɨ Aji-tɨ, ");
INSERT INTO mge_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kɨ̀ dɔnangɨ Priji-tɨ, kɨ̀ dɔnangɨ Pampili-tɨ, kɨ̀ dɔnangɨ Ejiptɨ, kɨ̀ dɔnangɨ kɨ́ tò mbɔ́ ɓebo Sirḛn kɨ́ Libi-tɨ, kɨ̀ dow-je kɨ́ dꞌḭ ɓebo Rɔm-tɨ, ");
INSERT INTO mge_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","kɨ̀ jipɨ-je, kɨ̀ jipɨ təl-je, kɨ̀ dow-je kɨ́ Krɛtɨ, kɨ̀ Arapɨ-je lay kin ya, njékadmḛḛ-je dꞌɔr gin né-je kɨ́ ɔr ndil dow-je kɨ́ Lubə ra, adɨ ná̰-ná̰ dan-ji-tɨ ya oo ndi-dé kɨ̀ ta kojɨ-é kojɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Beɓa dow-je lay ya, ndil-dé tḛḛ sa̰y, lo ta igɨ-dé sə́l adɨ ꞌdəjɨ-na̰ ta dan-dé-tɨ ꞌpanè: «Né kinlé kɔr mḛḛ-é to ri wa?» ");
INSERT INTO mge_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Rəmə dḛ kɨ́ ná̰-je ꞌsɔkɨ njékadmḛḛ-je ꞌpanè: «To yibɨ ya njay ə ra-dé ə́n ngà!» ");
INSERT INTO mge_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Njékɔwkulə-je kɨ́ dɔgɨ gidɨ-é káre lé, dꞌḭ dꞌa̰ taá natɨ kɨ̀ Piyər, ngá ɓá Piyər un ta dan-dé-tɨ pa adɨ kosɨ dow-je kɨ̀ ndi-é kɨ́ boy panè: «Sə̰i jipɨ-je, kɨ̀ sə̰i dow-je lay kɨ́ isi mḛḛ ɓebo Jorijalḛm-tɨ nè lé, ꞌyəli mbi-si majɨ ooi-né ta-je lə-m kdɔ kadɨ ꞌgəi gin né kɨ́ ra né kin majɨ. ");
INSERT INTO mge_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dow-je kɨ́ ooi-dé kinlé, to yibɨ ɓá ra-dé titɨ kɨ́ sə̰i ꞌpai-né kinlé al, kdɔtalə to kàdɨ̀ jinà̰y káre kɨ́ ndɔge ɓəy ə́n. ");
INSERT INTO mge_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngà to ta kɨ́ ndɔkɨ Juwel njèpata kɨ́ ta Lubə-tɨ pa lé ɓá ɓone né-é ra né ngá tin. Ndɔkɨ Juwel panè: ");
INSERT INTO mge_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Lubə panè: Ta sɔ̰y ndɔ-je-tɨ lé, mꞌa kungɨ Ndil-m dɔ dow-je-tɨ lay, ngan-si-je kɨ́ dingəm, kɨ̀ dḛ kɨ́ dené dꞌa pa ta-je kɨ́ ta-m ma̰ Lubə-tɨ kadɨ dow-je, Né à ra basa-je lə-si tokɨ nḭ bè, ə ɓugə-je lə-si kàrè dꞌa koo né-je mḛḛ nḭ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tɔgrɔ-tɨ ya, mḛḛ ndɔ-é-je-tɨ kinlé, mꞌa kungɨ ndil-m dɔ ngannjékullə-je-tɨ lə-m kɨ́ dingəm, kɨ̀ dḛ kɨ́ dené, rəmə dꞌa pa ta-je kɨ́ ta-m ma̰ Lubə-tɨ kadɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mꞌa ra né-je kɨ́ tò ɓəl-ɓəl mḛḛ dɔra̰-tɨ taá rəm, mꞌa ra nékɔjɨ-je dɔnangɨ-tɨ nè kadɨ à tɔjɨ tɔ́gɨ-m. Dow-je dꞌa koo sapər à suu lukɨ-lukɨ, dꞌa koo məsɨ kɨ̀ pər. ");
INSERT INTO mge_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kàdɨ̀ à təl ndul ndḭ-ndḭ, ɓá na̰y à təl kər titɨ məsɨ bè rəm. Ngá ɓá ndɔ lə ꞌƁaɓe à ree ɓəy. Ndɔ-é kinlé, à to ndɔ kɨ́ boy; à to ndɔ riɓa. ");
INSERT INTO mge_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Beɓa dow kɨ́ rá-rá ya nɔ̰ ɓa ꞌƁaɓe lé, à kajɨ.”» ");
INSERT INTO mge_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Sə̰i Israyel-je! Ooi ta-je kin majɨ: Nékɔjɨ-je, kɨ̀ né-je kɨ́ to ɓəl-ɓəl kɨ́ Lubə ra takəm-si-tɨ kɨ̀ rəbɨ kɨ́ rɔ Jeju-tɨ kɨ́ to dingəm kɨ́ Najarɛtɨ, adɨ sə̰i ya ꞌgəi majɨ kinlé, tɔjɨ kɨ́ Lubə umə̰-é ya. ");
INSERT INTO mge_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dingəm kinlé, dꞌilə-é ji-si-tɨ kdɔ ta lə to né-je kɨ́ Lubə ɔjɨ kete adɨ uwə dɔ gangɨ-é lay. Beɓa sə̰i ꞌɓəi-é kagdəsɨ-tɨ, ə adi dow-je kɨ́ njékilə kujɨ dɔ Lubə-tɨ al ꞌtɔl-é kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngà Lubə ɔr-é kɔgɨ gin tɔ́gɨ-tɨ lə koy, adɨ-é tɔsɨ ndəl ində lo tḛḛ; kdɔtalə koy asɨ kɔ̰ɓe dɔ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kdɔ Dabidɨ pa ta liə panè: “Mꞌoo ꞌƁaɓe Lubə takəm-m-tɨ kɨ̀ ndɔ-é-ndɔ-é. Kdɔtalə ḛ a̰ kàdɨ̀-m-tɨ nè, kdɔ kadɨ né káre kàrè yəkɨ-m al. ");
INSERT INTO mge_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gin-é kin ɓá rɔnəl rusɨ-né mḛḛ-m rəm, mꞌusɨ pa mꞌtilə-né kole rəm tin; rəm ɓá dajɨ rɔ-m kàrè à kuwə rɔ-é lo taakoo-tɨ, kɨ̀ mḛḛ kɨ́ tò səl dɔ nékində mḛḛ dɔ-tɨ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kdɔ i ꞌƁaɓe Lubə ꞌa kin̰ə-m kadɨ mꞌnà̰y kɔgɨ lo kɨ́ koó-tɨ al, ɓá i ꞌa kin̰ə-m ma̰ dow lə-i kɨ́ mꞌaa njay kadɨ mꞌndum al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","I ꞌadɨ-m mꞌgə rəbɨ kɨ́ ꞌa tḛḛ sə-m lo kiskəm-tɨ, I ꞌa kadɨ rɔnəl rusɨ mḛḛ-m lokɨ ꞌa̰ sə-m.”» ");
INSERT INTO mge_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyər pa sə-dé ɓəy panè: «Ngankɔ̰-m-je, adɨ mꞌidə-si ta kɨ́ ta kɔ̰̀-m-tɨ ya dɔ ka-ji Dabidɨ-tɨ mꞌadɨ ooi: Dabidɨ lé ndɔkɨ oy adɨ dubɨ-é; dɔ ɓadɨ-é kàrè tò dan-ji-tɨ nè sar ɓone ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Titɨ kɨ́ Dabidɨ to-né njèpata kɨ́ ta Lubə-tɨ lé, ḛ gə kɨ́ Lubə un mindɨ-é ubɨ rɔ-é dɔ-tɨ kadɨ nꞌa kində ngonka-é káre ngar-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","To ta lə Kristɨ kɨ́ à tɔsɨ ndəl kində lo tḛḛ lé ɓá Dabidɨ gə kete adɨ panè: “Lubə à kin̰ə-nꞌḛ̀ kɔgɨ lo kɨ́ koó-tɨ al, ɓá nin-nꞌḛ̀ kàrè à ndum al rəm tɔ.”» ");
INSERT INTO mge_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Jeju kinlé, Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ adɨ jḛ lay ya jꞌoo-é kɨ̀ kəm-ji. ");
INSERT INTO mge_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lubə un-é ində-é taá dɔ jikɔl-é-tɨ, Bɔbɨ-é adɨ-é Ndil kɨ́ aa njay kɨ́ ḛ un mindɨ-é kdɔ kadɨ-é lé; Ndil kɨ́ aa njay lé ɓá Lubə ree sane dɔ-ji-tɨ adɨ ooi kɨ̀ kəm-si, ɓá ooi ká-é kɨ̀ mbi-si rəm tin. ");
INSERT INTO mge_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kdɔ ta lə Dabidɨ lé, ḛ ɔw dɔra̰-tɨ al ya, ngà ḛ ya panè: “ꞌƁaɓe Lubə idə ꞌƁaɓe lə-m panè: ꞌIsɨ dɔ jikɔl-m-tɨ nè, ");
INSERT INTO mge_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ya sar kadɨ mꞌadɨ njéba-je lə-i ꞌtəl-né lo kungɨ nja-i.”» ");
INSERT INTO mge_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Beɓa kadɨ sə̰i Israyel-je lay ya ꞌgəi majɨ kɨ́ Jeju kin, kɨ́ sə̰i ꞌɓəi-é kagdəsɨ-tɨ lé, ḛ ɓá Lubə adɨ-é to ꞌƁaɓe rəm, adɨ-é to Kristɨ rəm.» ");
INSERT INTO mge_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lokɨ dow-je dꞌoo ta-je kin bè lé, ta lé usɨ rɔ-dé-tɨ ndəkɨ-ndəkɨ adɨ ꞌdəjɨ Piyər-je kɨ̀ ndəgɨ njékɔwkulə-je ꞌpanè: «Ngankɔ̰-ji-je, jḛ lé jꞌa ra ban ngá wa?» ");
INSERT INTO mge_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ə Piyər idə-dé panè: «In̰əi panjiyə-si-je kɨ́ majɨ al kɔgɨ ə kadɨ ná̰-ná̰ dan-si-tɨ ya ra batḛm kɨ̀ ri Jeju Kristɨ, kdɔ kadɨ Lubə in̰ə-né go majal liə kɔgɨ. Beɓa a kingəi kadkare kɨ́ to Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kdɔtalə kun mindɨ lə Lubə lé, to kdɔ ta lə-si sə̰i rəm, kdɔ ta lə ngan-si-je rəm, ɓá kdɔ ta lə dow-je lay kɨ́ njékisɨ sa̰y, kɨ́ ꞌto kosɨ dow-je kɨ́ kɔr-dé to nduy-nduy, kɨ́ Lubə lə-ji à ɓa-dé kɨ rɔ-é-tɨ kin rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyər pa sə-dé ta-je kɨ́ rangɨ n̰a̰-n̰a̰ uwə-dé-né kɨ̀ ta rəm, ulə-né dingəm mḛḛ-dé-tɨ panè: «Ɔri rɔ-si kɔgɨ dan dow-je-tɨ kɨ́ njétujɨ kɔgɨ kin, kdɔ kadɨ Lubə ajɨ-si.» ");
INSERT INTO mge_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Beɓa dow-je kɨ́ ꞌndigɨ dɔ ta-tɨ lə Piyər lé, ꞌra-dé batḛm. Ndɔ-é-tɨ kinlé, kɔr njékadmḛḛ-je usɨ dɔ madɨ-é-tɨ asɨ ɓudɔgɨ lo mutə je bè. ");
INSERT INTO mge_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Dḛ dꞌadɨ rɔ-dé lo néndó-tɨ lə njékɔwkulə-je rəm, dꞌuwə-na̰ lubɨ-lubɨ titɨ ngankɔ̰-na̰-je rəm, dꞌuso mbə̀ natɨ-natɨ rəm, ɓá dꞌadɨ rɔ-dé mḛḛ pa ta-tɨ kɨ̀ Lubə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lubə ra né-je kɨ́ tò ɓəl-ɓəl, kɨ̀ nékɔjɨ-je kɨ̀ takul njékɔwkulə-je adɨ dow-je lay ya ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Njékadmḛḛ-je lay ya dꞌində rɔ-dé natɨ majɨ rəm, né-je lə-dé lay ya dꞌore-na̰ dɔ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dꞌɔy lo-je lə-dé, kɨ̀ nékingə-dé-je ꞌndogɨ, ə ꞌləbɨ-na̰ là-é là-é, adɨ ná̰-ná̰ ingə kɨ́ asɨ ra ndigɨ-je liə. ");
INSERT INTO mge_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Njékadmḛḛ-je lé, ta-dé asɨ-na̰ adɨ ndɔ-je lay ya dꞌisɨ natɨ mḛḛ kəy-tɨ lə Lubə, ꞌgángɨ-na̰ mbə̀ nam lə ꞌƁaɓe mḛḛ kəy-je-tɨ lə-dé rəm, dꞌuso né natɨ-natɨ kɨ̀ rɔnəl, ɓá kɨ̀ mḛḛ kɨ́ usɨ nangɨ pɔ̰́-pɔ̰́ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ꞌPitɨ Lubə taá-taá rəm, ɓá dow-je lay ya ꞌndigɨ ta lə-dé rəm tɔ. Ndɔ-é ndɔ-é ya ꞌƁaɓe adɨ kɔr dḛ kɨ́ ḛ ajɨ-dé usɨ dɔ madɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ndɔ káre bè, ta ji losɔl-tɨ, Piyər kɨ̀ Ja̰ dꞌisɨ dꞌɔw mḛḛ kəy-tɨ lə Lubə kdɔ pa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lokɨ ꞌtḛḛ ngɔsi kɨ̀ ta rəbɨ kəy lə Lubə, kɨ́ ꞌɓa-é: «Ta rəbɨ kɨ́ kurə́ n̰a̰ lé», dow-je dꞌun dingəm káre kɨ́ nja-é oy mburukɨ lo kojɨ-é-tɨ nṵ dꞌisɨ dꞌɔw siə titɨ. Ndɔ-je lay ya dꞌində-é mḛḛ kəy-tɨ lə Lubə kadɨ kɔy né dow-je kɨ́ dꞌisɨ dꞌɔw takəy-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Beɓa lokɨ dingəm lé, oo Piyər-je kɨ̀ Ja̰ kɨ́ dꞌisɨ dꞌɔw mḛḛ kəy-tɨ lə Lubə rəmə, ḛ kɔy-dé né. ");
INSERT INTO mge_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rəmə Piyər dḛ kɨ̀ Ja̰ dꞌoo-é gə́rə́rə́, ə Piyər idə-é panè: «ꞌOo-ji nè bè!» ");
INSERT INTO mge_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Rəmə dingəm lé kàrè, oo-dé gə́rə́rə́ ya tɔ, kdɔtalə ḛ gɨr mḛḛ-é-tɨ kɨ́ nꞌa kingə né madɨ ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Beɓa Piyər idə-é panè: «Là əse lɔr goto ji-m-tɨ. Ngà né kɨ́ tò kadɨ madɨ-i ɓá tò tin: Kɨ̀ ri Jeju Kristɨ kɨ́ Najarɛtɨ-tɨ, ḭ taá ꞌnjiyə!» ");
INSERT INTO mge_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ngá ɓá Piyər lé, uwə jikɔl-é ra siə kadɨ-é ḭ-né taá, ya rəmə tajinatɨ nè ya nja-é-je kɨ̀ gul nja-é-je ndajɨ rəngɨ-rəngɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Adɨ ḛ ubə nangɨ ratɨ a̰ dɔ nja-é-tɨ, ə ɔtɨ njiyə. Ḛ njiyə rəm, tal jakra-jakra rəm, ɓá tɔ́y Lubə andɨ-né mḛḛ kəy-tɨ lə Lubə natɨ kɨ̀ njékɔwkulə-je lé. ");
INSERT INTO mge_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dow-je lay ya dꞌoo-é ɔw njiyə rəm, ɔw tɔ́y Lubə rəm. ");
INSERT INTO mge_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Lokɨ dow-je ꞌgə-é kɨ́ to dingəm kɨ́ njékisɨ ta rəbɨ kəy-tɨ lə Lubə kɨ́ ꞌɓa-é «ta rəbɨ kɨ́ kurə́ n̰a̰» kdɔ kɔy né lé, dḛ lay ya ndil-dé tḛḛ sa̰y, ɓá lo ta igɨ-dé sə́l rəm, kdɔtalə né kɨ́ tḛḛ dɔ dingəm-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dingəm lé in̰ə go Piyər-je kɨ̀ Ja̰ al. Beɓa dow-je lay ya dꞌa̰y-na̰ kɨ rɔ-dé-tɨ «gin pal-tɨ lə Salomɔ̰» kɨ́ tò takəy-tɨ lə Lubə, kdɔ ndil-dé tḛḛ sa̰y. ");
INSERT INTO mge_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lokɨ Piyər oo né kin bè rəmə, ḛ idə kosɨ dow-je lé panè: «Sə̰i dow-je kɨ́ dɔnangɨ Israyel-tɨ! Kdɔ ri ɓá lapiya kɨ́ dingəm kin ingə lé, ɔr ndil-si bè wa? Kdɔ ri ə́ sə̰i ooi-ji titɨ-na̰ né kɨ́ to tɔ́gɨ-ji əse to takul kujɨ kɨ́ jꞌilə dɔ Lubə-tɨ ɓá jꞌra-né dingəm kinlé jꞌadɨ-é njiyə bè wa? ");
INSERT INTO mge_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","To Lubə lə Abrakam, kɨ̀ Lubə lə Isakɨ, kɨ̀ Lubə lə Jakobɨ, kɨ́ to Lubə lə ka-ji-je ɓá ulə riɓa dɔ ngonnjèkullə-tɨ liə Jeju. Sə̰i ya iləi-é ji ꞌboy-je-tɨ lə jipɨ-je rəm, ɓá sə̰i mbati-é nɔ̰̀ Pilatɨ-tɨ, lokɨ ḛ ɔjɨ kilə-é taá. ");
INSERT INTO mge_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sə̰i lé, ꞌmbati dow kɨ́ aa njay, njèra né kɨ́ njururu, rəmə njètɔl dow-je ɓá ꞌdəji kadɨ kɔgri ya dꞌilə-é taá dꞌadɨ-si. ");
INSERT INTO mge_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sə̰i adi ꞌtɔl njèkadɨ kiskəm dow-je. Ngà Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ adɨ jꞌoo-é kɨ̀ kəm-ji. ");
INSERT INTO mge_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dingəm kan, kɨ́ sə̰i ooi-é rəm, ꞌgəi-é majɨ rəm kinlé, to takul mḛḛ-ji kɨ́ jꞌadɨ Jeju, ɓá Jeju ya adɨ rɔ-é təl nga̰-né gəw-gəw tin. Kadmḛḛ Jeju ɓá dingəm kanlé ingə-né lapiya kɨ́ ɔr njutɨ adɨ sə̰i lay ya ooi-é tin.» ");
INSERT INTO mge_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Beɓa ɓone bè kinlé, ngankɔ̰-m-je, mꞌgə kɨ́ né kɨ́ ndɔkɨ sə̰i kɨ̀ ꞌboy-je lə-si ꞌrai kɨ̀ Jeju lé, ꞌrai dɔ mbə́-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ngà Lubə adɨ né kinlé ra né bè, kdɔ kadɨ ta kɨ́ njépata-je kɨ́ ta-é-tɨ lay ya ꞌpa kete kinlé né-é ra-né né. Lubə panè: Kristɨ à kingə kɔ̰̀. ");
INSERT INTO mge_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Beɓa in̰əi panjiyə-si-je kɨ́ majɨ al, ə ꞌtəli kɨ rɔ Lubə-tɨ kadɨ-é bɔr majal-je lə-si kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Beɓa ꞌƁaɓe à kadɨ-si dɔkaglo mḛḛ kusɨ nangɨ rəm, ɓá à kulə Jeju, kɨ́ to Kristɨ, dow kɨ́ ḛ mbətɨ-é kete kdɔ ta lə-si lé kadɨ-si. Kristɨ, dow kɨ́ Lubə mbətɨ-é lé to Jeju. ");
INSERT INTO mge_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngà kɨ́ ngɔsnè-tɨ kinlé, tò kadɨ Jeju Kristɨ lé à kisɨ dɔra̰-tɨ sar dɔkaglo-tɨ kɨ́ Lubə à kadɨ né-je lay təl kɨ́ sigɨ, titɨ kɨ́ Lubə pa-né kete low nṵ adɨ njépata-je kɨ́ ta-é-tɨ, kɨ́ ꞌto dow-je kɨ́ dꞌaa njay. ");
INSERT INTO mge_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Beɓa ndɔkɨ Moiyijɨ panè: “ꞌƁaɓe Lubə lə-si à kadɨ-si njèpata kɨ́ ta-é-tɨ kɨ́ titɨ-na̰ sə-m ma̰ Moiyijɨ bè, ḛ à to ngonkɔ̰-si kɨ́ dan-si-tɨ ya; sə̰i a təli rɔ-si go ta-tɨ liə mḛḛ né-je-tɨ lay. ");
INSERT INTO mge_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dow kɨ́ rá-rá kɨ́ təl rɔ-é go ta-tɨ lə njèpata kɨ́ ta Lubə-tɨ kin al lé, dꞌa tubə-é kɔgɨ dan dow-je-tɨ lə Lubə rəm, dꞌa tɔl-é kɔgɨ rəm tɔ.” ");
INSERT INTO mge_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Njépata-je kɨ́ ta Lubə-tɨ lay kɨ́ un kutɨ-é dɔ Samiyel-tɨ nṵ sar dɔ dḛ kɨ́ dꞌore go-é lé, ꞌpa ta kete dɔ ndɔ-je-tɨ kɨ́ ji-si-tɨ kinlé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sə̰i lé, kunmindɨ lə Lubə kɨ́ njépata-je kɨ́ ta-é-tɨ ꞌpa ta-é lé, tò kdɔ ta lə-si rəm, ɓá nojɨ kɨ́ Lubə ulə natɨ kɨ̀ ka-ji-je lé kàrè, sə̰i ubəi majɨ-é rəm tɔ. Lubə ulə nojɨ natɨ kɨ̀ ka-ji-je lokɨ ḛ idə-né Abrakam panè: “Gin dow-je kɨ́ dɔnangɨ-tɨ nè lay ya dꞌa kingə tɔrndi kɨ̀ takul nganka-i.” ");
INSERT INTO mge_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Beɓa, Lubə adɨ ngonnjèkullə liə tḛḛ kdɔ ta lə-si sə̰i ya dɔsa̰y. Ḛ ulə-é kdɔ kadɨ ree tɔrndi-é dɔ-si-tɨ kɨ̀ go rəbɨ ra kɨ́ à ra kadɨ ná̰-ná̰ dan-si-tɨ təl gidɨ-é adɨ majal-je liə.» ");
INSERT INTO mge_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lokɨ Piyər-je kɨ̀ Ja̰ dꞌa̰ ꞌpa ta-je kin dꞌadɨ dow-je ya rəmə njégugné-je lə Lubə, kɨ̀ njèkun dɔ njéngəm kəy lə Lubə, kɨ̀ Sadusi-je ꞌree rɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dḛ ꞌree kɨ̀ rɔ katɨ kana̰na̰, kdɔ dḛ kɨ́ joo kinlé dꞌa̰ ꞌndó né dow-je rəm, dꞌa̰ dꞌilə mbḛ ꞌpanè: Dow-je kɨ́ dꞌoy dꞌa tɔsɨ ndəl kində lo tḛḛ, kdɔtalə Jeju lé tɔsɨ ndəl ində lo tḛḛ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rəmə dꞌuwə-dé dꞌɔw dꞌungɨ-dé dangay-tɨ sar lo aa dɔ-dé-tɨ, kdɔ to ta kɨ́ kàdɨ̀ ɔw dɔ kur-tɨ rəm ngá. ");
INSERT INTO mge_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bè ya kàrè, dḛ kɨ́ dꞌoo ta lə njékɔwkulə-je kinlé, dow-je n̰a̰ dan-dé-tɨ dꞌadɨ mḛḛ-dé Jeju. Adɨ dow-je kɨ́ ꞌto njékadmḛḛ-je dꞌa kasɨ ɓudɔgɨ lo mḭ je bè. ");
INSERT INTO mge_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lokɨ lo aa ngá rəmə, ꞌboy-je lə jipɨ-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, kɨ̀ njéndó dow-je ndukun-je, dꞌuwə dɔ-na̰ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","An kɨ́ to burə dɔ njégugné-je lə Lubə, ɓá Kayipɨ rəm, Ja̰ rəm, Alegjandrə rəm, ɓá dow-je lay kɨ́ gin kojɨ-tɨ lə njékun dɔ njégugné-je dꞌa̰ dan dow-je-tɨ kɨ́ dꞌuwə dɔ-na̰ lé nɔ̰ɔ̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Beɓa dḛ dꞌadɨ ꞌree kɨ̀ Piyər-je kɨ̀ Ja̰ lé nɔ̰̀-dé-tɨ, ngá ɓá ꞌdəjɨ-dé ta ꞌpanè: «Ná̰ ɓá adɨ-si tɔ́gɨ əse kɨ̀ ri ná̰ ɓá sə̰i adi-né lapiya dingəm kɨ́ njènjakoy mburukɨ kinlé wa?» ");
INSERT INTO mge_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Beɓa Ndil kɨ́ aa njay rusɨ mḛḛ Piyər adɨ idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Sə̰i ꞌboy-je lə jipɨ-je, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je: Jḛ jꞌra majɨ kɨ̀ dingəm kɨ́ njènjakoy mburukɨ kin rəmə, ɓone sə̰i ꞌtəli ꞌdəji kadɨ jꞌidə-si se kəm rəbɨ kɨ́ ban ɓá ḛ ingə-né lapiya tɔ ɓəy wa? ");
INSERT INTO mge_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Beɓa kadɨ sə̰i lay ya ꞌgəi majɨ rəm, ɓá dow-je lay kɨ́ ꞌto Israyel-je kàrè kadɨ ꞌgə majɨ tɔ: Kɨ̀ ri Jeju Kristɨ kɨ́ to dow kɨ́ Najarɛtɨ, ḛ kɨ́ ndɔkɨ ꞌɓəi-é kagdəsɨ-tɨ, ɓá Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ lé, to takul-é ɓá dingəm kan a̰-né taá nɔ̰̀-si-tɨ kɨ̀ rɔ kɨ́ nga̰ gəw-gəw tin. ");
INSERT INTO mge_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jeju lé: “To ər kɨ́ sə̰i njékində kəy-je ilə-é pɨrɨngɨ kɔgɨ lé, rəmə ḛ ɓá təl to ər kɨ́ majɨ kɨ́ sul kəy-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Kajɨ tò rɔ dow-tɨ kɨ́ rangɨ al; kdɔtalə dan dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè lay kin ya, dow kɨ́ rangɨ kɨ́ Lubə adɨ-é to dow kɨ́ jꞌa kingəi kajɨ kɨ̀ takul ri-é ya goto.» ");
INSERT INTO mge_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lokɨ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je dꞌoo kɨ́ Piyər-je kɨ̀ Ja̰ ꞌpa ta kɨ̀ mḛḛ-dé kɨ́ nda ka̰y bè lé rəmə, ndil-dé tḛḛ sa̰y, kdɔ ꞌgə kɨ́ Piyər-je kɨ̀ Ja̰ lé ꞌto dow-je kɨ́ kare, ɓɨ to dow-je kɨ́ dꞌingə néndó al. Dḛ ꞌgə-dé kɨ́ ndɔkɨ ꞌnjiyə kɨ́ Jeju tɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ngà lokɨ dḛ dꞌoo dingəm kɨ́ ingə lapiya lé a̰ taá mbɔ́-dé-tɨ nè tɔ rəmə, dḛ dꞌoo ta kɨ́ dꞌa kilə Piyər-tɨ kɨ̀ Ja̰ lé al. ");
INSERT INTO mge_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Beɓa dḛ dꞌun ndu-dé kadɨ Piyər-je lé ꞌtḛḛ mḛḛ kəy gangta-tɨ lé dꞌɔw ndaa-tɨ. Go-tɨ, ꞌboy-je lé dꞌɔjɨ-na̰ ta ꞌpanè: «Ri ɓá jꞌa rai kɨ̀ dingəm-je kinlé wa? ");
INSERT INTO mge_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kdɔ dow-je kɨ́ Jorijalḛm lay ya ꞌgə majɨ kɨ́ dingəm-je kinlé, ꞌra nékɔjɨ kɨ́ tò ndaa-tɨ rəsɨ rəm, ɓá jə̰i ya kàrè to né kɨ́ dum kadɨ jꞌnaji rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lé bè ya kàrè, kdɔ kadɨ poy né kɨ́ ra né kin ɔw kɨ kete-kete dan kosɨ dow-je-tɨ al lé, adɨ jꞌɔgi-dé kɔgɨ kɨ́ nga̰ n̰a̰, kadɨ ꞌpa ta kɨ̀ ri dingəm kinlé dꞌadɨ dow kɨ́ rangɨ al ya sar ngá.» ");
INSERT INTO mge_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Go-tɨ, ꞌɓa Piyər dḛ kɨ̀ Ja̰ dꞌadɨ ꞌtəl ꞌree gogɨ, ngá ɓá ꞌndɔr mbi-dé kete kɨ gogɨ kadɨ ꞌpa ta kɨ̀ ri dingəm kinlé al rəm, ɓá kadɨ ꞌndó dow-je né kɨ̀ ri-é al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piyər-je kɨ̀ Ja̰ dꞌilə-dé-tɨ ꞌpanè: «Sə̰i ya ꞌpai adɨ jꞌoo: Kadɨ to né kɨ njururu nɔ̰̀ Lubə-tɨ ya lé, dow à təl rɔ-é go ta-tɨ lə-si əse à təl rɔ-é go ta-tɨ lə Lubə wa? ");
INSERT INTO mge_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jḛ lé, né kɨ́ jḛ ya jꞌoo ta-é kɨ̀ mbi-ji, ɓá jꞌoo kɨ̀ kəm-ji rəm lé, jꞌa ndəm ta-ji dɔ-tɨ ban wa.» ");
INSERT INTO mge_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ꞌBoy-je kɨ́ njégangta-je lə jipɨ-je lé, ꞌtəl dꞌɔgɨ-dé kɔgɨ kɨ́ nga̰ n̰a̰ lé ya ɓəy, ɓá dꞌin̰ə-dé dꞌadɨ dꞌɔw. Dḛ dꞌingə kəm rəbɨ madɨ kɨ́ kadɨ ꞌgangɨ-né ta dɔ-dé-tɨ al, kdɔtalə kosɨ dow-je. Kdɔ né kɨ́ ra né kinlé, dow-je lay ya dꞌɔsɨ-né gajɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Dingəm kɨ́ ingə lapiya kɨ̀ kəm rəbɨ nékɔjɨ kinlé, ɓal-é dəə ɓal kɔrsɔ. ");
INSERT INTO mge_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lokɨ dꞌin̰ə Piyər-je kɨ̀ Ja̰ taá lé, dḛ dꞌɔw rɔ dow-je-tɨ lə-dé, ə dꞌɔr poy ta-je lay kɨ́ njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je, ꞌpa sə-dé lé dꞌadɨ dꞌoo. ");
INSERT INTO mge_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Go ta-je-tɨ kɨ́ dꞌoo kinlé, dꞌadɨ ta-dé asɨ-na̰ adɨ dꞌun ndi-dé kɨ́ taá ꞌpa ta kɨ̀ Lubə ꞌpanè: «ꞌƁaɓe, i ya ꞌra dɔra̰ kɨ̀ dɔnangɨ, i ya ꞌra babo kɨ̀ né-je lay kɨ́ tò-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","I ya ꞌpa ta kɨ̀ takul Ndil kɨ́ aa njay, kɨ̀ rəbɨ kɨ́ rɔ ka-ji Dabidɨ-tɨ kɨ́ to ngonnjèkullə lə-i ꞌpanè: “Kdɔ ri ɓá gin dow-je kɨ́ gay-gay dꞌɔw-né dɔ-na̰-tɨ wúr-wùr bè wa? Kdɔ ri ɓá dow-je dꞌɔw kɨ̀ kɔjra-je kɨ́ kɔgɨ kare bè kin mḛḛ-dé-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngar-je kɨ́ dɔnangɨ-tɨ ꞌra go rɔ-dé kdɔ rɔ rəm, ꞌboy-je dꞌində rɔ-dé natɨ kdɔ kilə rɔ ꞌƁaɓe Lubə rəm, kdɔ kilə rɔ Kristɨ, dow liə kɨ́ ḛ mbətɨ-é rəm tɔ.”» ");
INSERT INTO mge_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Tɔgrɔ-tɨ, Erodɨ-je, kɨ̀ Pɔ̰sɨ Pilatɨ-je, kɨ̀ gin dow-je kɨ́ ꞌto jipɨ-je al, kɨ̀ dow-je kɨ́ ꞌto Israyel-je, ꞌmbɔ̰-na̰ mḛḛ ɓebo-tɨ kin ya dꞌɔsɨ ta ngonnjèkullə lə-i Jeju kɨ́ to dow kɨ́ aa njay, kɨ́ i ɓá ꞌmbətɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Né-je kinlé, ꞌra bè dꞌadɨ né-je lay kɨ́ i ɔjɨ kete low nṵ kɨ́ go tɔ́gɨ-i-tɨ rəm, kɨ̀ go mḛḛ ndigɨ-tɨ lə-i rəm kinlé, né-é ra-né né. ");
INSERT INTO mge_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Beɓa ꞌƁaɓe, kɨ́ ngɔsnè-tɨ kinlé, oo kɔgɨ kɨ́ dꞌɔgɨ-ji pa ta lə-i kin ə ꞌra kɨ̀ ngannjékullə-je lə-i kadɨ dꞌilə mbḛ ta lə-i kɨ̀ mḛḛnda ka̰y-ka̰y. ");
INSERT INTO mge_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɔjɨ tɔ́gɨ-i adɨ njémɔ̰y-je dꞌingə lapiya rəm, adɨ nékɔjɨ-je, kɨ̀ né-je kɨ́ tò ɓəl-ɓəl ra né, kɨ̀ ri ngonnjèkullə lə-i Jeju, kɨ́ to dow kɨ́ aa njay.» ");
INSERT INTO mge_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lokɨ dḛ tɔl ta pa ta kɨ̀ Lubə rəmə, lo kɨ́ ꞌkəw-na̰-tɨ lé yəy yəkɨ-yəkɨ rəm, dḛ lay ya Ndil kɨ́ aa njay rusɨ mḛḛ-dé rəmə ꞌpa ta lə Lubə kɨ̀ mḛḛnda ka̰y. ");
INSERT INTO mge_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Njékadmḛḛ-je lay ya dꞌində rɔ-dé natɨ kɨ̀ mḛḛ-dé kɨ́ káre-rè rəm, kɨ̀ tagɨr kɨ́ káre-rè rəm. Dow káre kɨ́ dan-dé-tɨ kɨ́ panè, né lə-nꞌḛ̀ kin sɔbɨ dɔ-nꞌḛ̀ nꞌḛ̀ ya kɨ̀ kár-nꞌḛ̀ ya goto. Nékingə-dé-je lay ya dꞌore-na̰ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Njékɔwkulə-je ꞌpa ta kɨ̀ tɔ́gɨ kɨ́ n̰a̰ dɔ tɔsɨ-tɨ kɨ́ ꞌƁaɓe Jeju tɔsɨ ndəl ində lo tḛḛ. Beɓa dḛ lay ya ramajɨ lə Lubə nà̰y sə-dé. ");
INSERT INTO mge_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dow káre dan-dé-tɨ kɨ́ né nal-é ya goto, kdɔ dḛ lay kɨ́ dꞌɔw kɨ̀ lo ndɔr-je əse kəy-je lé, dꞌɔy ꞌndogɨ dꞌadɨ là-é ");
INSERT INTO mge_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","njékɔwkulə-je, ngá ɓá ꞌtəl ꞌləbɨ kɨ́ go ndigɨ-je-tɨ lə ná̰-ná̰ dan-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jojepɨ kɨ́ njékɔwkulə-je lə Jeju dꞌində ri gajɨ-é lə Barnabasɨ, adɨ kɔr mḛḛ-é to: «Ngon kɨ́ njèkulə dingəm mḛḛ-dé-tɨ» lé, to dow kɨ́ gin kojɨ-tɨ lə Lebi, dɔnangɨ Siprə-tɨ kɨ́ tò dan ba-tɨ, ɔw kɨ̀ lo ndɔr liə nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ḛ un lo liə lé ndogɨ rəmə ree kɨ̀ là-é adɨ njékɔwkulə-je. ");
INSERT INTO mge_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ngà dingəm káre kɨ́ ri-é lə Ananiasɨ ə ri ne-é lə Sapira, un lo ndɔr lə-dé ndogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ta Ananiasɨ-je kɨ̀ ne-é asɨ-na̰ adɨ Ananiasɨ ɔr kəl là lo ndɔr lə-dé lé, ngá ɓá ɔw kɨ̀ ndəgɨ-é adɨ njékɔwkulə-je ə panè lay lə là ndɔr lé ya ə́n. ");
INSERT INTO mge_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Rəmə Piyər idə-é panè: «Ananiasɨ, ra ban ɓá ꞌɔr kəl là lo ndɔr lə-i lé adɨ to kɨ́ lə-i rəmə ꞌpanè lay lə là lé ya ə́ tò tin wa? I adɨ Sata̰ taa mḛḛ-i pəl-pəl adɨ ꞌɔw mbing ya ꞌədɨ Ndil kɨ́ aa njay wa? ");
INSERT INTO mge_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lo ndɔr lə-i lé, lé i ꞌndogɨ al kàrè to ꞌlə-i ya rəm al wa? Rəm ɓá kɨ́ i un ꞌndogɨ ngá kin kàrè, là-é to ꞌlə-i ya tɔ al wa? Ngà ra ban ɓá i ɔjɨ mḛḛ-i-tɨ adɨ ꞌra-né né kɨ́ tana̰ bè kin wa? To dow-je ɓá i ədɨ-dé al, ngà to Lubə ɓá i ədɨ-é.» ");
INSERT INTO mge_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lokɨ Ananiasɨ oo ta-je kinlé, ḛ usɨ nangɨ rəmə oy. Adɨ dow-je lay kɨ́ ta-é usɨ mbi-dé-tɨ lé, ɓəl ində bandɨ-dé gangɨ. ");
INSERT INTO mge_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lokɨ ḛ oy lé, basa-je ꞌree ɓɨr-é kɨ̀ kubɨ dꞌɔw ꞌdubɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lokɨ à kasɨ kàdɨ̀ mutə-je bè go-tɨ rəmə, ne-é Sapira lé ɔw kəy go-dé-tɨ. Ə né kɨ́ tḛḛ dɔ ngɔbɨ-é-tɨ lé, ḛ gə al. ");
INSERT INTO mge_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Beɓa Piyər dəjɨ-é panè: «ꞌIdə-m adɨ mꞌoo. Lo ndɔr lə-si kɨ́ ꞌndogi lé, lay lə là-é ya ɓá tò tin wa?» Rəmə Sapira panè: «Oiyo, là-é lé ya ə́ tò tin.» ");
INSERT INTO mge_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ə Piyər idə-é panè: «Kdɔ ri ɓá sə̰i kɨ̀ ngɔbɨ-i adi ta-si asɨ-na̰ adɨ ꞌna̰i Ndil ꞌƁaɓe wa? Yən, dḛ kɨ́ dꞌun ngɔbɨ-i dꞌɔw ꞌdubɨ-é lé ɓá ká nja-dé ɓa takəy-tɨ ngá tin. Dꞌa kun-i kɔw sə-i tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Rəmə tajinatɨ nè ya, ḛ usɨ nangɨ nja Piyər-tɨ oy tɔ. Lokɨ basa-je lé dꞌɔw kəy rəmə, dꞌoo-é kɨ́ ḛ oy. Beɓa dḛ dꞌun-é dꞌɔw ꞌdubɨ-é mbɔ́ ngɔbɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ɓəl ində bandɨ njékəwna̰-je gangɨ rəm, ɓá dow-je lay ya kɨ́ dꞌoo poy né-je kinlé kàrè, ɓəl ində bandɨ-dé gangɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Njékɔwkulə-je ꞌra né-je kɨ́ tò ɓəl-ɓəl, kɨ̀ né-je kɨ́ tɔjɨ tɔ́gɨ Lubə n̰a̰-n̰a̰ takəm dow-je-tɨ. Njékadmḛḛ-je lay ya ꞌkəwna̰ gin pal-tɨ lə Salomɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dow kɨ́ rangɨ kɨ́ ɓo ree dan-dé-tɨ ra-é goto. Bè ya kàrè, dow-je ꞌpitɨ-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Beɓa dingəm-je kɨ̀ dené-je kɨ́ ꞌtò nduy-nduy ya dꞌadɨ mḛḛ-dé ꞌƁaɓe, adɨ kɔr-dé usɨ dɔ madɨ-é-tɨ par-par. ");
INSERT INTO mge_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Rəmə dow-je dꞌɔy njémɔ̰y-je dɔ tirə-tɨ-je, kɨ̀ mḛḛ tuwə-tɨ-je ꞌree dꞌungɨ-dé kɨ̀ ngangɨ rəbɨ-rəbɨ, kdɔ kadɨ kinə Piyər dəə rəmə, ndil-é je kin ya kàrè ungɨ dɔ njèmɔ̰y-tɨ káre je bè ɓəl dan-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dow-je n̰a̰ ya kɨ́ mḛḛ ɓebo-je-tɨ kɨ́ tò mbɔ́ Jorijalḛm-tɨ dꞌɔy njémɔ̰y-je, kɨ̀ dow-je kɨ́ ndil-je kɨ́ majɨ al ꞌra-dé, dꞌa̰y sə-dé kɨ rɔ-dé-tɨ, adɨ dḛ lay ya dꞌingə lapiya. ");
INSERT INTO mge_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ngá ɓá burə dɔ njégugné-je lə Lubə, kɨ̀ dow-je lay kɨ́ dꞌisɨ siə natɨ, adɨ to kutɨ dow-je kɨ́ ꞌɓa-dé Sadusi-je lé jangɨ ra-dé n̰a̰ dɔ njékɔwkulə-je-tɨ adɨ dꞌḭ gim ");
INSERT INTO mge_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","dꞌɔw dꞌuwə-dé ꞌree dꞌungɨ-dé dangay-tɨ kɨ́ to dangay lə dow-je lay. ");
INSERT INTO mge_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngà ndɔɔ rəmə, malayka lə ꞌƁaɓe ree tḛḛ ta rəbɨ-je kɨ́ kəy dangay-tɨ, adɨ njékɔwkulə-je ꞌtḛḛ ndaa-tɨ, ɓá idə-dé panè: ");
INSERT INTO mge_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ɔwi, a̰i mḛḛ kəy-tɨ lə Lubə, ə ta-je lay kɨ́ sɔbɨ dɔ ta kajɨ kinlé, iləi-né mbḛ adi dow-je.» ");
INSERT INTO mge_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lokɨ dꞌoo ta kin bè lé, dꞌɔw takəy-tɨ lə Lubə kɨ́ ndɔge ratɨ ya dꞌɔw ꞌndó dow-je né. Beɓa burə dɔ njégugné-je lə Lubə, kɨ̀ dow-je kɨ́ dꞌisɨ siə natɨ ya lay dꞌulə kulə ꞌɓa ꞌboy-je kɨ́ njégangta-je lə jipɨ-je rəm, ɓá ꞌɓa ꞌngatɔ́gɨ-je lə Israyel-je lay rəm. Ngá ɓá dꞌulə kulə dangay-tɨ kadɨ ꞌree kɨ̀ njékɔwkulə-je lé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ngà lokɨ ngannjékullə-je lé dꞌɔw rəmə, dꞌingə-dé kəy dangay-tɨ al. Beɓa ꞌtəl dꞌɔw gogɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Lokɨ jꞌɔw lé, tarəbɨ tò kɨ̀ kutɨ-é majɨ rəm, ɓá njéngəm tarəbɨ-je kɨ́ kəy dangay-tɨ kàrè dꞌa̰ lo ka̰-dé-tɨ nɔ̰ɔ̰ rəm; ya rəmə lokɨ jꞌtḛḛ tarəbɨ lé, dow ya kàrè jꞌingə-é mḛḛ kəy-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lokɨ njèkun dɔ njéngəm takəy lə Lubə, kɨ̀ njékun dɔ njégugné-je lə Lubə, dꞌoo ta kin bè lé, lo ta igɨ-dé sə́l kdɔ ta lə njékɔwkulə-je lé, adɨ ꞌdəjɨ-na̰ ta ꞌpanè: To ri dana̰ ɓá ra né bè wa? ");
INSERT INTO mge_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ngà dow káre ree idə-dé panè: «Yən! Dow-je kɨ́ ungi-dé dangay-tɨ lé, dꞌa̰ ꞌndó né dow-je takəy-tɨ lə Lubə nɔ̰ɔ̰.» ");
INSERT INTO mge_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ngà ɓá njèkun dɔ njéngəm takəy lə Lubə, dḛ kɨ̀ dow-je liə dꞌɔw ꞌree kɨ̀ njékɔwkulə-je lə Jeju lé. Ngà ree ɓá ꞌree sə-dé kɨ́ go lə njètɔ́gɨ-tɨ al, kdɔtalə dḛ ꞌɓəl kɨ́ kosɨ dow-je dꞌa tilə-dé kɨ̀ ər. ");
INSERT INTO mge_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lokɨ ꞌree sə-dé lé, dꞌadɨ dꞌa̰ nɔ̰̀ ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je, ngá ɓá, burə dɔ njégugné-je lə Lubə dəjɨ-dé ta panè: ");
INSERT INTO mge_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Jḛ jꞌɔgɨ-si kɨ́ ta kɔ̰̀-ji-tɨ kadɨ ꞌndói né dow-je kɨ̀ ri dingəm kinlé ya al wa? Ngà ooi bè, néndó lə-si ya taa mḛḛ ɓebo Jorijalḛm pəl-pəl rəm, ɓá ꞌndigi rai bè kadɨ ta məsɨ dingəm kinlé usɨ dɔ-ji jḛ-tɨ ɓəy al ɓan.» ");
INSERT INTO mge_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ngá ɓá Piyər-je, kɨ̀ ndəgɨ njékɔwkulə-je dꞌilə-dé-tɨ ꞌpanè: «Dow à təl rɔ-é go ta-tɨ lə Lubə, ɓɨ à təl rɔ-é go ta-tɨ lə dow-je al. ");
INSERT INTO mge_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jeju kɨ́ sə̰i ꞌɓəi-é kagdəsɨ-tɨ ꞌtɔli-é lé, Lubə lə ka-ji-je adɨ-é tɔsɨ ndəl ində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ḛ ɓá Lubə un-é ində-é dɔ jikɔl-é-tɨ taá, adɨ-é to ngar rəm, adɨ-é to njèkajɨ dow-je rəm. Kdɔ kadɨ ngan Israyel-je dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ kɨ̀ takul-é rəm, kadɨ Lubə in̰ə-né go majal-je lə-dé kɔgɨ rəm. ");
INSERT INTO mge_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Né-je kɨ́ ra né kinlé, jḛ jꞌoo kɨ̀ kəm-ji rəm, jꞌoo ta-é kɨ̀ mbi-ji rəm, ɓá Ndil kɨ́ aa njay kɨ́ Lubə adɨ isɨ mḛḛ dow-je-tɨ kɨ́ njétəl rɔ-dé go ta-tɨ liə lé kàrè oo né-je kinlé rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lokɨ dḛ dꞌoo ta-je lə njékɔwkulə-je lé bè rəmə, wɔngɨ ra-dé n̰a̰ adɨ dꞌɔjɨ kadɨ dꞌadɨ ꞌtɔl-dé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngà Parisi káre kɨ́ ri-é lə Gamaliyɛl kɨ́ to njèndó dow-je ndukun-je lə Lubə kɨ́ dow-je lay ya dꞌun ta-é, ḭ taá dan ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je lé kdɔ kidə-dé tagɨr liə. Ḛ un ndu kadɨ dꞌadɨ njékɔwkulə-je lé ꞌtḛḛ ndaa-tɨ mɔkɨ. ");
INSERT INTO mge_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ngá ɓá idə ꞌboy-je kɨ́ njégangta-je lé panè: «Sə̰i Israyel-je lé! Né kɨ́ sə̰i ɔji kadɨ ꞌrai kɨ̀ dow-je kanlé ooi majɨ ɓane! ");
INSERT INTO mge_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kdɔtalə ngɔsnè ya ɓəy Tedasɨ, oo rɔ-é kɨ dow kɨ́ ngay; beɓa dingəm-je dꞌa kasɨ ɓusɔ je bè dꞌun go-é. Ngà ꞌtɔl-é rəm, dow-je lay kɨ́ go-é-tɨ lé kàrè, ꞌsane-dé káre-káre, adɨ kində rɔ natɨ lə-dé lé goto. ");
INSERT INTO mge_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Go-é-tɨ, Judasɨ kɨ́ to dow kɨ́ Galile, ɔr kosɨ dow-je go-é-tɨ, dɔkaglo kində ri dow-je mḛḛ mbete tidə kɔr dow-je-tɨ. Ḛ kàrè ꞌtɔl-é rəm, ɓá dow-je kɨ́ go-é-tɨ kàrè ꞌsane-dé káre-káre rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Beɓa kɨ́ ngɔsnè-tɨ kinlé, mꞌidə-si kadɨ indəi kəm-si go dingəm-je-tɨ kinlé al. In̰əi-dé adɨ dꞌɔw. Kdɔtalə kinə, kɔjra lə-dé əse kullə lə-dé kin to né kɨ́ ḭ rɔ dow-je-tɨ lé, né-é à kində nangɨ kɨ̀ kár-é bè ya. ");
INSERT INTO mge_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngà kinə to kɔjra lə Lubə əse to kullə liə ya tɔgrɔ-tɨ tɔ rəmə, tɔ́gɨ-si à kasɨ ra kadɨ ində nangɨ al. Ooi majɨ, nè a kḭ rɔ-i kɨ̀ Lubə!» Beɓa ꞌboy-je kɨ́ njégangta-je lə jipɨ-je lé, ꞌndigɨ kɨ̀ Gamaliyɛl dɔ ta-tɨ liə lé. ");
INSERT INTO mge_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Go-tɨ, ꞌtəl ꞌɓa njékɔwkulə-je lé ꞌree sə-dé rəmə, dꞌadɨ dꞌində-dé rəm, ɓá dꞌɔgɨ-dé ꞌpanè: «A pai ta kɨ̀ ri Jeju gogɨ rangɨ al ngá.» Bè ngá ɓá dꞌin̰ə-dé dꞌadɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Njékɔwkulə-je dꞌin̰ə ꞌboy-je kɨ́ njégangta-je lé ꞌtḛḛ ndaa-tɨ kɨ̀ rɔnəl, kdɔtalə koo kɨ́ Lubə oo-dé adɨ nꞌtoi dow-je kɨ́ nꞌasi kadɨ rɔsɔl tḛḛ dɔ-dé-tɨ kdɔ ta lə ri Jeju. ");
INSERT INTO mge_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kɨ̀ ndɔ-é ndɔ-é ya njékɔwkulə-je dꞌilə mbḛ Poyta kɨ́ Majɨ lə Jeju kɨ́ to Kristɨ rəm, ꞌndó né dow-je mḛḛ kəy-tɨ lə Lubə rəm, ɓá mḛḛ kəy-je-tɨ lə-dé ə dꞌin̰ə ta-é al. ");
INSERT INTO mge_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dɔkaglo-é-tɨ kinlé, kɔr njéndó né-je usɨ dɔ madɨ-é-tɨ kɨ kete-kete rəmə, jipɨ-je kɨ́ njépata grɛkɨ ꞌyun ta dɔ jipɨ-je-tɨ kɨ́ ꞌpa ta Əbrə, kdɔtalə, ndɔ-é ndɔ-é ya kɨ́ dꞌisɨ ꞌləbɨ né lé, dow ilə ká njéngɔwkoy-je-tɨ kɨ́ njépata grɛkɨ lé al. ");
INSERT INTO mge_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Beɓa njékɔwkulə-je kɨ́ dɔgɨ gidɨ-é joo lé, ꞌɓa njéndó né-je lay ya rɔ-dé-tɨ ə dꞌidə-dé ꞌpanè: «Kadɨ jḛ ɓá jꞌin̰ə ta pa ta lə Lubə, kdɔ təl ka̰ ká ləbɨ nékuso-tɨ ɓəy lé, to né kɨ́ tuwə ra al. ");
INSERT INTO mge_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Beɓa ngankɔ̰-ji-je, kadɨ ꞌmbəti dingəm-je siri dan-si-tɨ, kdɔ kadɨ jꞌulə kullə kin mḛḛ ji-dé-tɨ kadɨ ꞌra. Ə à to dingəm-je kɨ́ dow-je ꞌpa ta lə-dé majɨ rəm, Ndil kɨ́ aa njay rusɨ mḛḛ-dé rəm, ɓá à to dingəm-je kɨ́ dꞌɔw kɨ̀ gosɨ rəm ɓane tɔ. ");
INSERT INTO mge_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ngà jḛ rəmə, jꞌa kuwə rɔ-ji nga̰ mḛḛ pa ta-tɨ kɨ̀ Lubə, ɓá mḛḛ ndó dow-je ta-tɨ liə rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta kinlé, njékəwna̰-je lay ya ꞌndigɨ dɔ-tɨ. Beɓa ꞌmbətɨ-né Etiyḛn, kɨ́ to dow kɨ́ kadmḛḛ liə asɨ gakɨ, ɓá Ndil kɨ́ aa njay rusɨ mḛḛ-é rəm tɔ, ɓá ꞌmbətɨ Pilipɨ, kɨ̀ Prokore, kɨ̀ Nikanɔr, kɨ̀ Timɔ̰, kɨ̀ Parmenasɨ, kɨ̀ Nikola kɨ́ to dow kɨ́ ɓebo Antiosɨ-tɨ kɨ́ to jipɨ təl. ");
INSERT INTO mge_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ə ꞌree sə-dé rɔ njékɔwkulə-je-tɨ. Dḛ ꞌpa ta kɨ̀ Lubə kdɔ ta lə-dé, ɓá dꞌində ji-dé dɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ta lə Lubə sane kɨ̀ lo-lo, ɓá kɔr njéndó né-je kɨ́ Jorijalḛm ɔw kɨ kete ya par-par rəm, ɓá njégugné-je lə Lubə n̰a̰ ya dꞌadɨ mḛḛ-dé Jeju rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lubə ra majɨ kɨ̀ Etiyḛn n̰a̰ rəm, adɨ-é tɔ́gɨ adɨ ra-né nékɔjɨ-je, kɨ̀ né-je kɨ́ tò ɓəl-ɓəl dan dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Beɓa ndɔ káre bè jipɨ-je kɨ́ ná̰-je kɨ́ dꞌḭ ɓebo Sirḛn-tɨ, kɨ̀ ɓebo Alegjandri-tɨ rəm, ɓá dḛ kɨ́ madɨ-je ꞌto jipɨ-je kɨ́ ɓebo Silisi-tɨ, kɨ̀ dḛ kɨ́ mḛḛ ɓe-je-tɨ kɨ́ dɔnangɨ Aji-tɨ ꞌree ꞌnajɨ ta kɨ̀ Etiyḛn. Dḛ kinlé, kəykəwna̰ lə jipɨ-je kɨ́ dꞌisɨ dꞌuwə dɔ-na̰-tɨ lé, ꞌɓa-é «kəykəwna̰ lə ɓə-je kɨ́ dꞌin̰ə-dé taá ngá.» ");
INSERT INTO mge_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ngà dḛ dꞌasɨ kuwə-é kɨ̀ ta al, kdɔtalə to Ndil kɨ́ aa njay ɓá adɨ-é gosɨ pa-né ta. ");
INSERT INTO mge_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Beɓa dḛ dꞌadɨ là dingəm-je madɨ, adɨ ree ꞌtə́tɨ-né ta ta-é-tɨ ꞌpanè: «Etiyḛn lé, pa takɔbɨ dɔ Moiyijɨ-tɨ rəm, ɓá dɔ Lubə-tɨ adɨ jḛ ya jꞌoo kɨ̀ mbi-ji.» ");
INSERT INTO mge_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Dḛ ꞌsulə kosɨ dow-je, kɨ̀ ꞌngatɔ́gɨ-je, kɨ̀ njéndó dow-je ndukun-je, adɨ tḛḛ kɨ̀ Etiyḛn busɨ dꞌuwə-é dꞌɔw siə nɔ̰̀ ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɓəy ɓá dꞌɔw ree kɨ̀ dow-je kɨ́ njétətɨ ta-je adɨ ꞌpanè: «Dingəm kinlé, ndɔ-é ndɔ-é ya ḛ pa ta kɨ́ majɨ al dɔ kəy-tɨ lə Lubə kɨ́ to lo kɨ́ aa njay kin rəm, ɓá ndɔ-é ndɔ-é ya ḛ pa ta kɨ́ majɨ al dɔ ndukun-tɨ lə Moiyijɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jꞌpa bè kdɔ jꞌoo ta-é-tɨ panè: Jeju kɨ́ Najarɛtɨ kinlé, à tɔɔ kəy lə Lubə kin kɔgɨ, ɓá à mbəl nékoɓe-je kɨ́ Moiyijɨ adɨ-ji kin rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dow-je lay kɨ́ dꞌisɨ lo gangta-tɨ kinlé, dꞌoo Etiyḛn gə́rə́rə́, rəmə dꞌoo kɨ́ takəm-é titɨ-na̰ kɨ̀ takəm malayka bè. ");
INSERT INTO mge_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Burə dɔ njégugné-je lə Lubə dəjɨ Etiyḛn panè: «Se to bè ya tɔgrɔ-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyḛn ilə-tɨ panè: «Ngankɔ̰-m-je kɨ̀ bɔbɨ-m-je, ꞌyəli mbi-si ooi ta lə-m. Ka-ji Abrakam lé, ndɔkɨ isɨ dɔnangɨ Mejopotami-tɨ. Lokɨ ḛ ɔw isɨ dɔnangɨ Kara̰-tɨ al ya ɓəy ɓá Lubə kɨ́ njèriɓa tḛḛ siə kɔy, ");
INSERT INTO mge_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","idə-é panè: “ꞌIn̰ə dɔnangɨ kojɨ-i, kɨ̀ nojɨ-i-je burə lay kdɔ kadɨ ɔw dɔnangɨ-tɨ kɨ́ mꞌa kɔjɨ-i kin.” ");
INSERT INTO mge_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Beɓa Abrakam in̰ə-né dɔnangɨ lə Kalde-je ɔw isɨ-né dɔnangɨ Kara̰-tɨ. Go koy bɔbɨ-é-tɨ, ngá ɓá Lubə adɨ-é ɔw isɨ dɔnangɨ-tɨ kɨ́ ɓone isi-tɨ kin. ");
INSERT INTO mge_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Né káre ya kàrè Lubə adɨ-é dɔnangɨ-tɨ kinlé al. Lo kɨ́ tatɨ-é asɨ kɨ̀ da nja dow bè ya kàrè Lubə adɨ-é titɨ al. Dɔkaglo-é-tɨ kinlé Abrakam ojɨ ngon al ɓəy ya rəmə, Lubə un mindɨ-é panè nꞌa kadɨ-é dɔnangɨ kinlé rəm, ɓá dɔnangɨ-é lé à təl to néndubə lə nganka-é-je go-é-tɨ gogɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ta kɨ́ Lubə pa adɨ Abrakam ə́n: “Nganka-i-je dꞌa kɔw dɔ ɓe mba-tɨ dɔnangɨ-tɨ kɨ́ rangɨ, dꞌa ra-dé ɓə-tɨ rəm, dꞌa kulə kəm-dé ndoo ɓal ɓusɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngá ɓá ma̰ Lubə ya mꞌa gangta dɔ gin dow-je-tɨ kɨ́ njéra-dé ɓə-tɨ lé. Go-tɨ, dꞌa tḛḛ kdɔ kadɨ dꞌɔw ꞌpol-m dɔnangɨ Kara̰-tɨ kinlé.” ");
INSERT INTO mge_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Beɓa Lubə adɨ Abrakam ganjangɨ kɨ́ kijə adɨ to né kɨ́ tɔjɨ kulənojɨ kɨ́ tò dan-dé-tɨ dḛ siə. Gin-é kin ɓá lokɨ Abrakam ojɨ Isakɨ adɨ ra ndɔ jinà̰y joo rəmə, ḛ ijə-é ganjangɨ; bè ya tɔ, Isakɨ ijə-né Jakobɨ ganjangɨ, ɓá Jakobɨ kàrè ijə-né ngan-é-je kɨ́ dɔgɨ gidɨ-é joo kɨ́ ꞌto ka-ji-je kɨ́ njékində gin Israyel-je lé ganjangɨ tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ndəgɨ ka-ji-je lé, jangɨ ra-dé dɔ Jojepɨ-tɨ adɨ ꞌndogɨ-é kɔgɨ, ə njéndogɨ-é-je dꞌɔw siə dɔnangɨ Ejiptɨ-tɨ. Ngà Lubə isɨ siə natɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jojepɨ lé, Lubə ɔr-é kɔgɨ dan kɔ̰̀-je-tɨ lay kɨ́ tḛḛ dɔ-é-tɨ, ɓá adɨ-é gosɨ rəm, adɨ-é majɨ takəm Paraɔ̰-tɨ kɨ́ to ngar kɨ́ dɔnangɨ Ejiptɨ-tɨ rəm. Beɓa Paraɔ̰ adɨ-é to gubərnər dɔnangɨ Ejiptɨ-tɨ rəm, adɨ-é ɔ̰̀ ɓe mḛḛ ndògɨ ngar-tɨ liə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ɓo ree usɨ dɔnangɨ Ejiptɨ-tɨ ya lay rəm, ɓá usɨ dɔnangɨ Kana̰-tɨ lay rəm tɔ. Adɨ dow-je dꞌingə kɔ̰̀ n̰a̰ rəm, ɓá ka-ji-je kàrè dꞌingə nékuso al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lokɨ Jakobɨ oo kɨ́ gemḛ tò dɔnangɨ Ejiptɨ-tɨ lé, ḛ ulə ka-ji-je Ejiptɨ-tɨ, kulə kɨ́ dɔsa̰y. ");
INSERT INTO mge_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kulə kɨ́ njèkungɨ-tɨ joo ngá ɓá Jojepɨ tɔjɨ rɔ-é adɨ ngankɔ̰-é-je ꞌgə-é rəm, go-tɨ, Jojepɨ ɔw tɔjɨ ngankɔ̰-é-je Paraɔ̰ adɨ Paraɔ̰ kàrè gə-né kɨ́ dḛ ꞌto ngankɔ̰ Jojepɨ-je ɓəy tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Bè ngá ɓá Jojepɨ ulə kulə ɓa bɔbɨ-é Jakobɨ, kɨ̀ ndəgɨ nojɨ-é-je lay adɨ ꞌree rɔ-é-tɨ. Dḛ lay ꞌto dow-je kɔrsiri gidɨ-é mḭ. ");
INSERT INTO mge_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Beɓa Jakobɨ ɔw isɨ dɔnangɨ Ejiptɨ-tɨ sar oy-né ə ka-ji-je kàrè dꞌoy-né dɔnangɨ Ejiptɨ-tɨ nɔ̰ɔ̰ ya lay tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ngá ɓá dꞌɔy nin-dé dꞌɔw ꞌdubɨ mḛḛ ɓe-tɨ kɨ́ Sisɛm, lo dɔɓadɨ-tɨ kɨ́ ndɔkɨ Abrakam ndogɨ kɨ̀ là ji ngan lə Amɔr-tɨ kɨ́ to bɔbɨ Sisɛm.» ");
INSERT INTO mge_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Kunmindɨ lə Lubə kɨ́ ndɔkɨ un adɨ Abrakam lé, lokɨ nà̰y ngɔsi kadɨ né-é ra-né rəmə, gin dow-je lə-ji dꞌojɨ-na̰ n̰a̰ mḛḛ ɓe-tɨ kɨ́ Ejiptɨ-tɨ, adɨ kɔr-dé usɨ dɔ madɨ-é-tɨ par-par. ");
INSERT INTO mge_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Rəmə ngar kɨ́ rangɨ kɨ́ gə Jojepɨ al ree ɔ̰̀ ɓe dɔnangɨ Ejiptɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ə ngar-é kinlé ədɨ dow-je lə-ji, ra kəm ka-ji-je ndoo, ra-dé kɨ́ lə njètɔ́gɨ-tɨ adɨ dꞌin̰ə ngan-dé-je kɨ́ bər kadɨ dꞌoy kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dɔkaglo-é-tɨ kin ɓá dꞌojɨ-né Moiyijɨ kɨ́ to ngon kɨ́ kurə́ takəm Lubə-tɨ. ꞌƁɔyɔ Moiyijɨ na̰y mutə mḛḛ kəy-tɨ lə bɔbɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lokɨ dꞌin̰ə-é kɔgɨ ngá ɓá ngon lə Paraɔ̰ kɨ́ dené un-é utɨ-é titɨ ngon mḛḛ-é bè. ");
INSERT INTO mge_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Beɓa Moiyijɨ ndó-né né-je lay, kɨ̀ négə-je kɨ́ dɔnangɨ Ejiptɨ-tɨ adɨ təl to dow kɨ́ ɔw kɨ̀ tɔ́gɨ mḛḛ ta pa-é-tɨ rəm, mḛḛ kullə ra-é-tɨ rəm.» ");
INSERT INTO mge_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ngà lokɨ Moiyijɨ ra ɓal kɔrsɔ lé, tagɨr kɔw koo ngankɔ̰-é israyel-je ree dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Beɓa ḛ ɔw rəmə, da dɔ dow-tɨ kɨ́ Ejiptɨ-tɨ kɨ́ a̰ mbɔ̰y ngon Israyel káre ə Moiyijɨ tɔl dow kɨ́ Ejiptɨ-tɨ lé dal-né ba dingəm kɨ́ madɨ-é ra-é majɨ al lé. ");
INSERT INTO mge_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moiyijɨ gɨr kɨ́ ngankɔ̰-é Israyel-je dꞌa gə kɨ́ Lubə à taa-dé kilə-dé taá kɨ̀ takul nꞌḛ̀, ya ngà dḛ ꞌgə kɨ́ bè kin al. ");
INSERT INTO mge_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lo aa go-tɨ lé, Moiyijɨ oo ngan Israyel-je joo dꞌa̰ ꞌrɔ-na̰, beɓa ḛ sangɨ kadɨ nꞌgɔr-dé kadɨ lapiya tò dan-dé-tɨ adɨ ḛ panè: “Nam-je kɨ́ majɨ, sə̰i ꞌtoi ngankɔ̰-na̰-je, ngà ꞌrai-na̰ majɨ al bè kdɔ ri?” ");
INSERT INTO mge_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ngà ḛ kɨ́ njèra madɨ-é majɨ al lé surə Moiyijɨ kɨ gogɨ ə panè: “Ná̰ ɓá ində-i ꞌboy lə-ji rəm, njègangta lə-ji rəm wa? ");
INSERT INTO mge_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","I ꞌndigɨ tɔl-m titɨ kɨ́ tagnè ꞌtɔl-né dow kɨ́ Ejiptɨ-tɨ lé bè tɔ wa?” ");
INSERT INTO mge_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lokɨ Moiyijɨ oo ta-je kin bè lé, ḛ a̰y ɔw isɨ dɔ ɓe mba-tɨ dɔnangɨ-tɨ lə Madia̰-je. Ḛ ojɨ ngan-je kɨ́ dingəm joo lo-é-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ɓal kɔrsɔ go-tɨ ngá ɓá malayka káre tḛḛ kɨ̀ Moiyijɨ diləlo-tɨ kɔy, dan ndɔ̰ pər-tɨ kɨ́ ɔ̰̀ dan kam-tɨ bilɨm-bilɨm kàdɨ̀ mbal Sina̰y-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lokɨ Moiyijɨ oo né kin bè lé, ndil-é tḛḛ sa̰y. Beɓa lokɨ ɔtɨ kɨ kete kdɔ koo né lé majɨ ɓəy rəmə, ḛ oo ndi ꞌƁaɓe idə-é panè: ");
INSERT INTO mge_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“To ma̰ Lubə lə ka-i-je, Lubə lə Abrakam, kɨ̀ Isakɨ, kɨ̀ Jakobɨ.” Rəmə Moiyijɨ ɓəl dadɨ par-par, adɨ ḛ ndigɨ koo né-é al ngá. ");
INSERT INTO mge_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ngá ɓá ꞌƁaɓe təl idə-é panè: “ꞌTɔr saba nja-i-tɨ, kdɔtalə lo kɨ́ i ꞌa̰-tɨ kinlé to dɔnangɨ kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mꞌoo kɔ̰̀ kɨ́ dow-je lə-m dꞌisɨ dꞌingə dɔnangɨ Ejiptɨ-tɨ rəm, mꞌoo ká tumə̰-je lə-dé, ɓá mꞌree kdɔ taa-dé kilə-dé taá. Kɨ́ ngɔsnè-tɨ kin ya, mꞌulə-i ə́ ꞌɔtɨ ꞌɔw dɔnangɨ Ejiptɨ-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moiyijɨ kɨ́ ndɔkɨ ngan Israyel-je mbatɨ-é ꞌpanè: “Ná̰ ɓá ində-i ꞌboy lə-ji kɨ̀ njègangta lə-ji” rəm wa lé, ḛ ya Lubə ulə-é rɔ-dé-tɨ kdɔ kadɨ to ꞌboy lə-dé rəm, njètaa-dé kilə-dé taá kɨ̀ tɔ́gɨ lə malayka, kɨ́ ndɔkɨ tḛḛ siə kɔy dan kam-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","To Moiyijɨ kinlé ɓá ɔr ngan Israyel-je dɔnangɨ Ejiptɨ-tɨ tḛḛ sə-dé. Ḛ ra né-je kɨ́ tò ɓəl-ɓəl kɨ̀ né-je kɨ́ tɔjɨ tɔ́gɨ Lubə dɔnangɨ Ejiptɨ-tɨ rəm, dan babo kasɨ-tɨ rəm, diləlo-tɨ rəm, bè-bè ya ɓal kɔrsɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","To Moiyijɨ kinlé ɓá idə ngan Israyel-je panè: “Lubə à kadɨ-si njèpata kɨ́ ta-é-tɨ kɨ́ titɨ-na̰ sə-m ma̰ Moiyijɨ bè, ḛ à to ngonkɔ̰-si kɨ́ dan-si-tɨ ya.” ");
INSERT INTO mge_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moiyijɨ kinlé ɓá ndɔkɨ a̰ kɨ̀ ngan Israyel-je natɨ lokɨ ꞌkəw-né-na̰ diləlo-tɨ. Ḛ isɨ natɨ kɨ̀ ka-ji-je rəm, ḛ a̰ kɨ̀ malayka natɨ lokɨ malayka ꞌpa-né siə ta dɔ mbal Sina̰y-tɨ ə ḛ taa ta kɨ́ jꞌa kisɨ-né kɨ̀ dɔ-ji taá ji Lubə-tɨ adɨ-ji. ");
INSERT INTO mge_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ngà ka-ji-je ꞌndigɨ təl rɔ-dé go ta-tɨ liə al, adɨ dḛ mbatɨ-é rəm, ɓá mḛḛ-dé to gə́rə́rə́ dɔ təl kɔw dɔnangɨ Ejiptɨ-tɨ gogɨ rəm. ");
INSERT INTO mge_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Beɓa dḛ dꞌidə Arɔ̰ ꞌpanè: “ꞌRa magɨ-je adɨ ꞌnjiyə nɔ̰̀-ji-tɨ, kdɔtalə Moiyijɨ kɨ́ njètḛḛ sə-ji kɔgɨ Ejiptɨ kinlé, jꞌgə né kɨ́ tḛḛ dɔ-é-tɨ al.” ");
INSERT INTO mge_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ngá ɓá mḛḛ ndɔ-je-tɨ kinlé, dḛ ꞌra ngon mangɨ, dꞌilə məsɨ nangɨ dꞌadɨ-é, ɓá ꞌra rɔnəl dɔ kullə ra ji-dé-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ngà Lubə təl gidɨ-é adɨ-dé, in̰ə-dé adɨ ꞌpole kàdɨ̀-je, kɨ̀ na̰y-je, kɨ̀ kərwəḭ-je, titɨ kɨ́ ꞌndàngɨ-né mḛḛ mbete-tɨ lə njépata-je kɨ́ ta Lubə-tɨ ꞌpanè: “Sə̰i Israyel-je, ɓal kɔrsɔ kɨ́ sə̰i ꞌrai diləlo-tɨ lé, Sə̰i iləi məsɨ da̰-je nangɨ adi-mi wa? Sə̰i ꞌreei kɨ̀ né-je adi-mi wa? ");
INSERT INTO mge_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kəykubɨ lə magɨ kɨ́ ꞌɓa-é Molokɨ rəm, né kɨ́ sə̰i adi to takəm magɨ kərwəḭ lə-si kɨ́ ri-é lə Repa̰ ɓá sə̰i uti dɔ-si-tɨ. Magɨ-je kinlé ɓá sə̰i ꞌrai-dé kdɔ kɔsɨ dɔ-si nangɨ nɔ̰̀-dé-tɨ. Beɓa mꞌa kɔw sə-si kadɨ ꞌrai ɓə gidɨ Babilɔ̰n-tɨ nṵ.” ");
INSERT INTO mge_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Diləlo-tɨ ndɔkɨ lé, ka-ji-je dꞌɔw kɨ̀ kəy kɨ́ ꞌra kɨ̀ kubɨ kɨ́ to lo kingə-na̰ kɨ̀ Lubə. Lubə pa ta kɨ̀ Moiyijɨ ə un ndu adɨ-é kadɨ ra kəykubɨ lé adɨ titɨ-na̰ kɨ́ ga̰-é kɨ́ oo lé ya bè tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ka-ji-je dꞌin̰ə kəy kubɨ kinlé dꞌadɨ ka-ji-je kɨ́ njéree go-dé-tɨ tɔ. Dḛ kàrè lokɨ Jojuwe ɔr nɔ̰̀-dé adɨ ꞌtaa dɔnangɨ lə gin dow-je kɨ́ Lubə tubə-dé nɔ̰̀-dé-tɨ lé, dḛ dꞌɔw kɨ̀ kəykubɨ lé kəm-dé-tɨ. Beɓa kəykubɨ lé tò dan-dé-tɨ sar kaglo-tɨ lə Dabidɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dabidɨ to dow kɨ́ Lubə ra siə majɨ, ḛ dəjɨ kadɨ nꞌra kəy kisɨ Lubə lə Jakobɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngà to Salomɔ̰ ɓá ra kəy-é lé adɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ngà Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ lé, ḛ isɨ mḛḛ kəy-tɨ kɨ́ dow-je ꞌra kɨ́ ji-dé al. Ta kɨ́ njèpata kɨ́ ta Lubə-tɨ pa ə́n: ");
INSERT INTO mge_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ꞌƁaɓe Lubə ya panè dɔra̰ to kalikɔ̰ɓe lə-m, ə dɔnangɨ to lo kungɨ nja-m, Ngà se kəy kɨ́ titɨ-na̰ ban ɓá sə̰i a rai kadi-mi wa? Əse lo kɨ́ rá ɓá to lo taakoo lə-m wa? ");
INSERT INTO mge_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Né-je kin ya lay lé, ma̰ ya mꞌto njèra-dé kɨ̀ ji-m ya al wa?” ");
INSERT INTO mge_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Sə̰i dow-je kɨ́ ꞌtoi njédɔnga̰-je, kɨ̀ njémḛḛndə-je, kɨ̀ njémbibəy-je kan! Sə̰i kɨ́ njékɔsɨ ta Ndil kɨ́ aa njay sar ɓone! Sə̰i ꞌtiti-na̰ kɨ̀ ka-si-je lé bè tɔ! ");
INSERT INTO mge_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ná̰ dan njépata-je kɨ́ ta Lubə-tɨ ɓá ka-si-je dꞌulə kəm-é ndoo al wa? Ta ree lə dow kɨ́ njururu lé, dḛ kɨ́ ꞌto njépa ta-é kadɨ dow-je dꞌoo kete-kete lé, ka-si-je ꞌtɔl-dé. Ngà ɓone bè kinlé, dow kɨ́ njururu lé, ḛ ya ɓá sə̰i uni dɔ-é rəm, ꞌtɔli-é rəm tin. ");
INSERT INTO mge_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sə̰i lé, ndukun kɨ́ Lubə adɨ-si kɨ̀ kəm rəbɨ kɨ́ rɔ malayka-je-tɨ lé, sə̰i ꞌtəli rɔ-si go-tɨ al rəm.» ");
INSERT INTO mge_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lokɨ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je dꞌoo ta-je kin bè lé, wɔngɨ ra-dé n̰a̰ adɨ ꞌtɔ̰́ gangɨ-dé məgəgə-məgəgə dɔ Etiyḛn-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngà Etiyḛn lé Ndil kɨ́ aa njay rusɨ mḛḛ-é, adɨ un kəm-é kɨ dɔra̰-tɨ taá oo lo gə́rə́rə́ rəmə, oo né riɓa lə Lubə rəm, oo Jeju a̰ taá dɔ jikɔl Lubə-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ngá ɓá ḛ panè: «Yən, mꞌoo dɔra̰ tò tagra rəm, mꞌoo Ngon lə dow a̰ taá dɔ jikɔl Lubə-tɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ngà lokɨ ḛ pa ta kin bè lé, kosɨ dow-je ꞌtur kɔɔl boy-boy rəm, dꞌutɨ mbi-dé jigɨ-jigɨ ə ꞌndàngɨ-na̰ giw kàdɨ̀ káre kɨ dɔ-é-tɨ, ");
INSERT INTO mge_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ꞌndɔr-é dꞌɔw siə gidɨ ɓebo-tɨ ə ꞌtilə-é kɨ̀ ər ꞌtɔl-é. Dow-je kɨ́ dꞌa̰ lo-é-tɨ lé, ꞌtɔr kubɨ-je lə-dé dꞌungɨ nangɨ nja basa-tɨ kɨ́ ri-é lə Sol, dꞌadɨ-é ngəm. ");
INSERT INTO mge_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lokɨ dꞌa̰ ꞌtilə Etiyḛn kɨ́ ər lé, ḛ pa ta kɨ̀ Lubə panè: «ꞌƁaɓe Jeju, ꞌtaa ndil-m kɨ rɔ-i-tɨ!» ");
INSERT INTO mge_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Go-tɨ ngá ɓá Etiyḛn tɔsɨ məkəjɨ-é nangɨ nɔ̰ boy panè: «ꞌƁaɓe, ꞌtidə majal kin dɔ-dé-tɨ al.» Lokɨ ḛ pa ta-je kin bè rəmə, ḛ uwə ta-é. ");
INSERT INTO mge_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol ndigɨ kɨ̀ dow-je dɔ tɔl-tɨ kɨ́ ꞌtɔl Etiyḛn. Dɔ ndɔ-é-tɨ kinlé, dow-je dꞌun kutɨ kulə kəm njékəwna̰-je ndoo n̰a̰ mḛḛ ɓe-tɨ kɨ́ Jorijalḛm, adɨ njékəwna̰-je lay ya ꞌsane-na̰ kɨ dɔnangɨ Jude-tɨ, kɨ̀ dɔnangɨ Samari-tɨ. Ngà njékɔwkulə-je ya par ɓá ꞌnà̰y Jorijalḛm. ");
INSERT INTO mge_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lokɨ Etiyḛn oy lé, dow-je kɨ́ njékilə kujɨ dɔ Lubə-tɨ, ꞌnɔ̰-é n̰a̰ ɓá dꞌun-é dꞌɔw ꞌdubɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol uwə rɔ-é nga̰ kadɨ nꞌtɔɔ ko njékəwna̰-je, ḛ ɔw kɨ̀ mḛḛ kəy mḛḛ kəy ya tuwə dingəm-je kɨ̀ dené-je ungɨ-dé dangay-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ə dḛ kɨ́ ꞌsane-na̰ lé, dꞌɔw dꞌilə mbḛ Poyta kɨ́ Majɨ kɨ̀ lo-lo. ");
INSERT INTO mge_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipɨ ɔw dɔnangɨ Samari-tɨ, mḛḛ ɓebo-tɨ káre bè, ilə mbḛ ta lə Kristɨ adɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nékɔjɨ-je kɨ́ Pilipɨ ra ra lé, kosɨ dow-je lay ya dꞌoo poy-é rəm, ɓá dꞌoo kɨ̀ kəm-dé rəm. Beɓa ta-dé asɨ-na̰ adɨ ꞌyəl mbi-dé majɨ dꞌoo-né ta-je lə Pilipɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kdɔ dow-je n̰a̰ ya ndil-je kɨ́ majɨ al ꞌtḛḛ mḛḛ-dé-tɨ kɔgɨ kɨ̀ nɔ̰ ta-dé-tɨ boy-boy, ɓá njérɔkoy mburukɨ-je, kɨ̀ njémətɨ-je n̰a̰ ya dꞌingə lapiya rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Beɓa rɔ dow-je nəl-dé n̰a̰ mḛḛ ɓebo-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dɔkaglo-é-tɨ kinlé, dingəm káre bè kɨ́ ꞌɓa-é Simɔ̰ isɨ mḛḛ ɓebo-tɨ lé nɔ̰ɔ̰, isɨ ra mbəli adɨ ində dow-je kɨ́ Samari ɓəl-tɨ. Ḛ oo rɔ-é kɨ dow kɨ́ ngay. ");
INSERT INTO mge_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Adɨ ngan-je kɨ́ sḛ rəm, dow-je kɨ́ tɔgɨ lay ya tagɨr lə-dé tò kɨ dɔ-é-tɨ ya sḛḛ. Ə ꞌpanè: Dingəm kinlé ɔw kɨ̀ tɔ́gɨ lə Lubə kɨ́ ꞌɓa-é tɔ́gɨ kɨ́ al dɔ lo. ");
INSERT INTO mge_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ḛ ya ɓá tagɨr lə-dé tò kɨ dɔ-é-tɨ ya sḛḛ, kdɔtalə ḭ low nṵ ya isɨ ra né mbəli-je liə kɨ̀ né-je kɨ́ ində-né dow-je ɓəl-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngà lokɨ Pilipɨ ilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə rəm, kɨ́ sɔbɨ dɔ ri Jeju Kristɨ rəm lé, dḛ ꞌndigɨ dɔ ta-tɨ liə. Dingəm-je kɨ̀ dené-je kɨ́ ꞌndigɨ dɔ ta-tɨ liə lé ꞌra-dé batḛm. ");
INSERT INTO mge_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔ̰ lé ya kɨ̀ dɔ-é kàrè adɨ mḛḛ-é ta lə Pilipɨ adɨ ꞌra-é batḛm tɔ. Ḛ in̰ə go Pilipɨ al. Lokɨ ḛ oo né-je kɨ́ tɔjɨ tɔ́gɨ Lubə kɨ̀ nékɔjɨ-je kɨ́ ra né lé, lo ta igɨ-é səl. ");
INSERT INTO mge_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Beɓa lokɨ njékɔwkulə-je lə Jeju kɨ́ dꞌisɨ Jorijalḛm dꞌoo poy dow-je kɨ́ dɔnangɨ Samari-tɨ kɨ́ dꞌadɨ mḛḛ-dé ta lə Lubə lé, dḛ dꞌulə Ja̰ kɨ̀ Piyər rɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lokɨ Piyər-je kɨ̀ Ja̰ dꞌɔw ꞌtḛḛ Samari-tɨ rəmə, dḛ ꞌpa ta kɨ̀ Lubə kdɔtalə njékadmḛḛ-je kdɔ kadɨ dꞌingə Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kdɔ dan-dé-tɨ lé dow káre ya kàrè, Ndil kɨ́ aa njay ree dɔ-é-tɨ al ɓəy, ngà batḛm ya par ɓá ꞌra-dé kɨ̀ ri ꞌƁaɓe Jeju. ");
INSERT INTO mge_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Beɓa Piyər kɨ̀ Ja̰ dꞌində ji-dé dɔ-dé-tɨ rəmə, dꞌingə Ndil kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lokɨ Simɔ̰ oo kɨ́ njékɔwkulə-je lə Jeju dꞌində ji-dé dɔ njékadmḛḛ-je-tɨ adɨ dꞌingə Ndil kɨ́ aa njay lé, ḛ adɨ-dé là, ");
INSERT INTO mge_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","dəjɨ-dé-né panè: «Adi-mi tɔ́gɨ kin tɔ, kdɔ kadɨ kinə mꞌində ji-m dɔ dow-je-tɨ rəmə, dꞌingə Ndil kɨ́ aa njay tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ngà Piyər ilə-é-tɨ panè: «Kadɨ là lə-i tujɨ sə-i natɨ. Kdɔtalə i gɨr kɨ́ kadkare lə Lubə lé, ꞌa ndogɨ kɨ̀ là! ");
INSERT INTO mge_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","I lé, né lə-i káre ya kàrè goto mḛḛ né-tɨ kinlé rəm, ɓá né kɨ́ usɨ-i-tɨ nè ya kàrè goto rəm tɔ, kdɔ mḛḛ-i majɨ takəm Lubə-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ꞌIn̰ə tagɨr lə-i kɨ́ majɨ al kin kɔgɨ, ə ꞌpa ta kɨ̀ ꞌƁaɓe ə́ kinə lo-é tò rəmə-je in̰ə go kɔjra lə-i kɔgɨ adɨ-i. ");
INSERT INTO mge_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kdɔtalə mꞌoo kɨ́ mḛḛ katɨ bangɨ rusɨ mḛḛ-i rəm, ɓá né ra kɨ́ njururu al ɓindɨ-i ɓindɨ-ɓindɨ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Beɓa Simɔ̰ lé idə Piyər-je kɨ̀ Ja̰ panè: «Sə̰i ya ꞌpai ta kɨ̀ ꞌƁaɓe kdɔ ta lə-m, kdɔ kadɨ né kɨ́ ꞌpai ta-é kinlé tḛḛ dɔ-m-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lokɨ Piyər-je kɨ̀ Ja̰ ꞌpa ta kɨ́ dɔ ꞌƁaɓe-tɨ rəm, dꞌilə mbḛ ta liə rəm lé, ꞌtəl dꞌɔw ɓebo Jorijalḛm-tɨ gogɨ. Ta kɔw-dé kɨ ɓebo Jorijalḛm-tɨ lé, dḛ dꞌilə mbḛ Poyta kɨ́ Majɨ lə Jeju taá-taá mḛḛ ɓe-je-tɨ n̰a̰ kɨ́ dɔnangɨ Samari-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malayka lə ꞌƁaɓe idə Pilipɨ panè: «Ḭ taá ꞌɔw kəl lo-tɨ kɨ́ bəə bè; dɔ rəbɨ-tɨ kɨ́ ḭ ɓebo Jorijalḛm-tɨ ɔw kɨ Gaja kɨ́ to rəbɨ kɨ́ diləlo-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pilipɨ ḭ tajinatɨ nè ya ɔw tɔ. Dɔ rəbɨ-tɨ lé, ḛ ingə dingəm káre kɨ́ to dow kɨ́ Etiyopi. To dingəm kɨ́ ꞌtɔɔ gəm-é, to dow kɨ́ boy n̰a̰, njèrakullə kɨ́ boy lo ngəm né-tɨ lə ngar kɨ́ dené kɨ́ Etiyopi kɨ́ ri-é lə Kandasɨ, ḛ ɔw Jorijalḛm ɔw ɔsɨ dɔ-é nangɨ nɔ̰̀ Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Lokɨ isɨ mḛḛ pusɨ-tɨ isɨ təl kɨ ɓee liə lé, ḛ isɨ ndó mbete lə Ejay kɨ́ njèpata kɨ́ ta Lubə-tɨ taá-taá. ");
INSERT INTO mge_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ndil Lubə idə Pilipɨ panè: «Ɔw mbɔ́ pusɨ-tɨ kin.» ");
INSERT INTO mge_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ə Pilipɨ a̰y ngɔdɨ ɔw rəmə, oo dɔ ta kɨ́ dingəm kɨ́ Etiyopi kin isɨ ndó mḛḛ mbete-tɨ lə Ejay njèpata kɨ́ ta Lubə-tɨ lé. Ə dəjɨ-é panè: «Se i gə mḛḛ ta kɨ́ isɨ ndó kinlé majɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Beɓa dingəm lé ilə-é-tɨ panè: «Dow ɔr-m mḛḛ-é al ngà, mꞌa ra ban ɓá mꞌa gə mḛḛ-é wa?» Ḛ dəjɨ Pilipɨ adɨ-é al isɨ mḛḛ pusɨ-tɨ mbɔ́-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ta kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay kɨ́ ḛ ndó lé ə́n: «Dꞌɔw siə titɨ-na̰ kɨ̀ batɨ kɨ́ dꞌisɨ dꞌɔw siə lo tɔl da̰-je-tɨ bè rəm, ḛ pa ta al titɨ-na̰ kɨ̀ ngonbatɨ kɨ́ a̰ ta-é mbə́ mbɔ́ dow-tɨ kɨ́ a̰ tijə bəl-é bè. ");
INSERT INTO mge_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dꞌulə rɔsɔl dɔ-é-tɨ kàrè dow ilə ká nàjɨ-tɨ liə al Dow à pa ta kɨ́ sɔbɨ dɔ nganka-é al, kdɔtalə dꞌində ngangɨ ndɔ liə dɔnangɨ-tɨ nè.» ");
INSERT INTO mge_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Njèrakullə kɨ́ boy kinlé, dəjɨ Pilipɨ panè: «Mꞌra-i kɔgri ya, kadɨ ꞌidə-m se to ná̰ ɓá njèpata kɨ́ ta Lubə-tɨ kinlé pa ta liə bè wa? Ḛ pa ta kɨ́ dɔ-é ḛ-tɨ ya əse pa ta kɨ́ dɔ dow kɨ́ rangɨ-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Beɓa Pilipɨ un ta ə ulə gin-é dɔ ta-tɨ kɨ́ mḛḛ mbete-tɨ kɨ́ ḛ isɨ ndó lé ɓá idə-é-né Poyta kɨ́ Majɨ lə Jeju. ");
INSERT INTO mge_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Dḛ dꞌun rəbɨ sar ꞌtḛḛ lo-tɨ madɨ kɨ́ man tò-tɨ. Beɓa njèrakullə kɨ́ boy lé panè: «ꞌOo bè, man ə́ tò tin, ngà se ri ɓá ɔgɨ kadɨ mꞌra batḛm wa?» ");
INSERT INTO mge_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipɨ idə-é panè: «Kinə i adɨ mḛḛ-i lay Jeju lé, ꞌa ra batḛm ya.» Beɓa dingəm lé təl panè: «Mꞌadɨ mḛḛ-m kɨ́ Jeju Kristɨ to Ngon lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Beɓa ḛ un ndu adɨ pusɨ a̰ nangɨ. Rəmə Pilipɨ ɔw siə dan man-tɨ ɔw ra-é batḛm. ");
INSERT INTO mge_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ngà lokɨ dḛ ꞌtḛḛ kəm man-tɨ rəmə, Ndil ꞌƁaɓe un Pilipɨ ɔw siə adɨ njèrakullə kɨ́ boy lé oo-é al, ngà ḛ un ta rəbɨ liə ɔw kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipɨ ubə rəmə ubə ɓebo Ajotɨ-tɨ nṵ, ngá ɓá ilə mbḛ Poyta kɨ́ Majɨ taá-taá mḛḛ ɓebo-je-tɨ lay ɔw njal tḛḛ-né ɓebo Sejare-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dɔkaglo-é-tɨ kinlé, mḛḛ Sol tò səl dɔ kɔ̰̀-tɨ kɨ́ kadɨ nꞌadɨ njéndó né-je lə ꞌƁaɓe rəm, dɔ tɔl-tɨ kɨ́ kadɨ nꞌtɔl-dé rəm, adɨ ɔw rɔ burə dɔ njégugné-je-tɨ lə Lubə ");
INSERT INTO mge_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dəjɨ-é mbete kdɔ kɔw-né mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je kɨ́ mḛḛ ɓe-tɨ kɨ́ Damasɨ kadɨ kinə nꞌingə dingəm-je əse dené-je kɨ́ dꞌun rəbɨ néndó kɨ́ sigɨ kin rəmə nꞌuwə-dé, nꞌtɔ́-dé njim-njim, nꞌree sə-dé ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lokɨ ḛ un rəbɨ ɔw tḛḛ ngɔsi kɨ̀ ɓebo Damasɨ rəmə, tajinatɨ nè ya, lo ḭ dɔra̰-tɨ ndógɨ ree gəə dɔ-é sipɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ḛ tḛḛ usɨ nangɨ ə oo ndi dow pa siə ta panè: «Sol, Sol, kdɔ ri ɓá ꞌulə kəm-m ndoo bè wa?» ");
INSERT INTO mge_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ḛ ilə-é-tɨ panè: «I to ná̰ wa, ꞌƁaɓe?» Ngá ɓá ꞌƁaɓe panè: «To ma̰ Jeju kɨ́ ꞌisɨ ꞌulə kəm-m ndoo lé ya. Nékatɨ kɨ́ ꞌtɔsɨ-né kutɨ-i lé, to kɨ́ ꞌnjirə kutɨ-i kɨ gogɨ-gogɨ ə à kusɨ rɔ-i-tɨ palangɨ ya tɔ. Sol dadɨ par-par ə lo ta igɨ-é səl adɨ panè: ꞌƁaɓe, ri ɓá i ꞌndigɨ kadɨ mꞌra mꞌadɨ-i wa? Beɓa ꞌƁaɓe idə-é panè: ");
INSERT INTO mge_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kɨ́ nè-tɨ kin ya, ḭ taá ꞌɔw mḛḛ ɓebo-tɨ kin rəmə, dꞌa kidə-i né kɨ́ tò kadɨ ꞌa ra.» ");
INSERT INTO mge_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dow-je kɨ́ ꞌdan Sol lé, lo ta igɨ-dé sə́l adɨ ꞌtəl dꞌa̰ dɔ-na̰-tɨ ndingɨ; dḛ dꞌoo ndi dow, ngà dajɨ rɔ-é ɓá dꞌoo al. ");
INSERT INTO mge_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ubə nangɨ ḭ taá lé, kəm-é tḛḛ majɨ ya, ngà koo ɓá oo-né lo al. Beɓa dꞌuwə ji-é ꞌndɔr-é dꞌɔw siə mḛḛ ɓebo Damasɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ḛ oo lo al rəm, uso né al rəm, ɓá a̰y man al rəm ndɔ mutə. ");
INSERT INTO mge_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Njèndó né káre bè ri-é lə Ananiasɨ, isɨ mḛḛ ɓebo Damasɨ-tɨ nɔ̰ɔ̰. Né ra-é tokɨ nḭ bè ɓá ꞌƁaɓe ɓa-é panè: «Ananiasɨ!» Ə ḛ ilə-é-tɨ panè: «ꞌƁaɓe, mꞌa̰ nè.» ");
INSERT INTO mge_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Beɓa ꞌƁaɓe idə-é panè: «Yən, ꞌḭ taá kalangɨ ꞌɔw dɔ rəbɨ-tɨ kɨ́ ꞌɓa-é rəbɨ kɨ́ a̰ njururu kin, rəmə ꞌɔw mḛḛ kəy-tɨ lə Judasɨ ə ꞌdəjɨ-é dow kɨ́ Tarsɨ kɨ́ ꞌɓa-é Sol; kdɔ Sol lé lokɨ isɨ pa ta kɨ̀ Lubə ");
INSERT INTO mge_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ə né ra-é to kɨ́ nḭ bè rəmə oo dingəm káre bè kɨ́ ri-é lə Ananiasɨ tḛḛ kəm-é-tɨ adɨ oo-é. Ḛ oo kɨ́ Ananiasɨ lé ɔw kəy ə ində ji-é dɔ-é-tɨ, kdɔ kadɨ kəm-é təl oo lo gogɨ.» ");
INSERT INTO mge_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngà Ananiasɨ idə ꞌƁaɓe panè: «ꞌƁaɓe, dow-je n̰a̰ ya dꞌɔr poy né-je kɨ́ majɨ al lay kɨ́ dingəm kin ra kɨ̀ njékaa njay lə-i kɨ́ dꞌisɨ mḛḛ ɓebo Jorijalḛm-tɨ dꞌadɨ mꞌoo. ");
INSERT INTO mge_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ə dingəm kinlé, njékun dɔ njégugné-je ya dꞌadɨ-é tɔ́gɨ kadɨ ree nè uwə dow-je lay kɨ́ ꞌto njéɓa ri-i-je.» ");
INSERT INTO mge_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngà ꞌƁaɓe idə-é panè: «ꞌƆtɨ ꞌɔw. Kdɔ dingəm kinlé to dow kɨ́ mꞌmbətɨ-é kdɔ kadɨ ɔw pa ta lə-m adɨ gin dow-je kɨ́ ꞌto jipɨ-je al rəm, adɨ ngar-je rəm, ɓá adɨ Israyel-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma̰ ya mꞌa tɔjɨ-é kɔ̰̀-je lay kɨ́ à kingə kdɔ ta lə-m.» ");
INSERT INTO mge_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bè ngá ɓá Ananiasɨ ɔtɨ ɔw. Ə lokɨ ɔw mḛḛ kəy-tɨ rəmə, ində ji-é dɔ Sol-tɨ ɓá panè: «Ngonkɔ̰-m Sol, ꞌƁaɓe Jeju kɨ́ tḛḛ sə-i busɨ dɔ rəbɨ-tɨ lokɨ isɨ ree lé, ɓá ulə-m, kdɔ kadɨ kəm-i oo lo rəm, ɓá kdɔ kadɨ Ndil kɨ́ aa njay rusɨ mḛḛ-i rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Rəmə tajinatɨ nè ya né kɨ́ titɨ-na̰ kɨ̀ ngɔy kanjɨ bè tḛḛ kəm Sol-tɨ tusɨ nangɨ, adɨ kəm-é oo lo majɨ gogɨ. Beɓa ḛ ḭ taá ə ꞌra-é batḛm ");
INSERT INTO mge_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ɓá go-tɨ uso né ə tɔ́gɨ-é təl ree rɔ-é-tɨ gogɨ. Sol ra ndɔ sḛ natɨ kɨ̀ njéndó né-je kɨ́ mḛḛ ɓe-tɨ kɨ́ Damasɨ, ");
INSERT INTO mge_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ya rəmə, ḛ un kutɨ pa ta lə Lubə mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je panè: «Jeju lé, to Ngon lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dow-je lay kɨ́ dꞌoo ta-je liə lé, lo ta igɨ-dé sə́l adɨ ꞌpanè: «Dingəm kan ya ɓá to njèkulə kəm dow-je kɨ́ ꞌɓa ri Jeju ndoo n̰a̰ mḛḛ ɓe-tɨ kɨ́ Jorijalḛm lé al wa? Ḛ ra gosɨ ree nè kdɔ kuwə-dé tɔ́-dé njim-njim kɔw sə-dé kadɨ njékun dɔ njégugné-je lə Lubə lé, al ya wa?» ");
INSERT INTO mge_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngà Sol uwə rɔ-é nga̰ mḛḛ kadmḛḛ-tɨ kɨ kete-kete, adɨ lo-é ndɔjɨ jipɨ-je kɨ́ njékisɨ Damasɨ, adɨ dḛ dꞌoo ta kɨ́ dꞌa pa siə al, kdɔtalə ḛ tɔjɨ-dé adɨ ꞌgə kɨ́ Jeju lé ya to Kristɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Asɨ ndɔ n̰a̰ go-tɨ lé, jipɨ-je dꞌɔjɨ-na̰ ta kdɔ kadɨ ꞌtɔl Sol, ");
INSERT INTO mge_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ngà ta-é usɨ mbi-é-tɨ. Dḛ dꞌɔw mbing ya ꞌngəm-é ndɔɔ-je kɨ̀ kada-je tarəbɨ-je-tɨ kɨ́ ɔw mḛḛ ɓebo-tɨ kdɔ kadɨ nꞌtɔli-é. ");
INSERT INTO mge_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ya ngà ndɔɔ ya njéndó né-je dꞌadɨ-é isɨ mḛḛ jangá-tɨ ɓá dꞌulə-é kɨ̀ dɔ bɔr dꞌadɨ-é ur nangɨ gidɨ ɓe-tɨ ndaa-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lokɨ Sol ɔw mḛḛ ɓebo Jorijalḛm-tɨ lé, ḛ sangɨ kdɔ kində rɔ-é natɨ kɨ̀ njéndó né-je lə Jeju, ngà dḛ lay ya ꞌɓəl-é, kdɔtalə dḛ ꞌgɨr ꞌpanè ḛ to njèndó né lə Jeju kɨ́ tɔgrɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ngà Barnabasɨ ɔw siə rɔ njékɔwkulə-je-tɨ lə Jeju, ə ɔr-dé poy koo kɨ́ Sol oo ꞌƁaɓe dɔ rəbɨ-tɨ, kɨ̀ poy ta-je kɨ́ ꞌƁaɓe idə-é, ɓá ɔr-dé poy mbḛ kɨ́ Sol ilə kɨ̀ ri Jeju kɨ̀ mḛḛ-é kɨ́ nda ka̰y mḛḛ ɓebo Damasɨ-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dɔkaglo-é-tɨ kinlé, Sol ində rɔ-é natɨ sə-dé ə lo lay kɨ́ dꞌɔw-tɨ mḛḛ ɓebo Jorijalḛm-tɨ lé, Pol ɔw sə-dé rəm, təl sə-dé rəm, ɓá ḛ pa ta kɨ̀ ri ꞌƁaɓe kɨ̀ mḛḛ kɨ́ nda ka̰y-ka̰y rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ḛ pa ta kɨ̀ jipɨ-je kɨ́ njépata grɛkɨ rəm, ḛ najɨ-dé ta-tɨ rəm, rəmə dḛ ꞌsangɨ kadɨ ꞌtɔl-é kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lokɨ njékadmḛḛ-je dꞌoo poy-é lé, dꞌɔr Sol dꞌɔw siə mḛḛ ɓebo Sejare-tɨ, ngá ɓá dꞌadɨ-é ɔw mḛḛ ɓebo Tarsɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Njékəwna̰-je lay kɨ́ dɔnangɨ Jude-tɨ, kɨ̀ dɔnangɨ Galile-tɨ, kɨ̀ dɔnangɨ Samari-tɨ, dꞌisɨ kɨ̀ lapiya rəm, ɓá ꞌnga̰ mḛḛ kadmḛḛ-tɨ lə-dé; dḛ dꞌɔw kɨ kete-kete mḛḛ ɓəl ꞌƁaɓe-tɨ rəm, ɓá Ndil kɨ́ aa njay ra sə-dé adɨ kɔr njékəwna̰-je ḭ dɔ madɨ-é-tɨ kɨ kete-kete rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyər ɔw kɨ̀ dɔɓe-dɔɓe, beɓa ndɔ káre bè ɔw rɔ dow-je-tɨ kɨ́ ꞌto njékaa njay-je kɨ́ dꞌisɨ mḛḛ ɓebo Lida-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lo-é-tɨ kinlé, dꞌingə dingəm káre kɨ́ ri-é lə Ene, to njèrɔkoy mburukɨ adɨ tò nangɨ ɓal jinà̰y joo. ");
INSERT INTO mge_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyər idə-é panè: «Ene, Jeju Kristɨ adɨ-i lapiya! ꞌḬ taá ə ꞌun né tò-i.» Rəmə tajinatɨ nè ya Ene ubə nangɨ ḭ taá. ");
INSERT INTO mge_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dow-je lay kɨ́ mḛḛ ɓebo Lida-tɨ, kɨ̀ diləmbo-tɨ kɨ́ Sarɔ̰ kɨ́ dꞌoo Ene lé, dꞌadɨ mḛḛ-dé ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Njèndó né kɨ́ dené káre bè isɨ ɓebo Jope-tɨ nɔ̰ɔ̰; ri-é lə Tabita (kɨ̀ ta grɛkɨ lé ꞌpanè Dɔrkasɨ) ə kɔr mḛḛ-é to «kal.» Ḛ to dené kɨ́ njèra majɨ n̰a̰ rəm, to njèra kɨ̀ njéndoo-je rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mḛḛ ndɔ-je-tɨ kinlé, mɔ̰y ra-é adɨ-é oy. Lokɨ ꞌndogɨ-é man rəmə, dꞌun-né dꞌɔw dꞌilə-é mḛḛ kəy-tɨ kɨ́ taá dɔ madɨ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓe kɨ́ Lida lé tò ngɔsi kɨ ɓe kɨ́ Jope, beɓa lokɨ njéndó né-je dꞌoo poy Piyər kɨ́ isɨ Lida rəmə, dꞌulə dow-je joo rɔ-é-tɨ ꞌpanè: «Kɔgri ya, ꞌree kalangɨ ꞌingə-ji.» ");
INSERT INTO mge_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Beɓa Piyər ḭ taá kalangɨ ya ɔw sə-dé. Lokɨ ḛ ree tḛḛ lé, dꞌɔr nɔ̰̀-é dꞌɔw siə mḛḛ kəy-tɨ kɨ́ tò dɔ madɨ-é-tɨ taá lé rəmə, njéngɔwkoy-je lay ya ꞌree rɔ-é-tɨ kɨ̀ nɔ̰ ta-dé-tɨ, ə ꞌtɔjɨ-é kubɨ kul-je kɨ̀ kubɨ-je kɨ́ rangɨ kɨ́ Dɔrkasɨ ojɨ adɨ-dé taá-taá, lokɨ ḛ isɨ-né kɨ̀ dɔ-é taá ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyər adɨ dow-je lay ꞌtḛḛ ndaa-tɨ ɓá ḛ ɔsɨ məkəjɨ-é nangɨ pa ta kɨ̀ Lubə, ɓəy ngá ɓá ḛ təl kəm-é kɨ rɔ nin-tɨ lé ə panè: «Tabita, ḭ taá!» Rəmə Tabita tḛḛ kəm-é yərərə, ə lokɨ oo Piyər lé, ḛ ḭ isɨ taá. ");
INSERT INTO mge_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Beɓa Piyər uwə ji-é adɨ-é ḭ a̰ taá. Ngá ɓá ḛ ɓa njékaa njay-je kɨ̀ njéngɔwkoy-je ə tɔjɨ-dé Tabita lé kəm. ");
INSERT INTO mge_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Dow-je lay kɨ́ ɓebo Jope-tɨ ya ta-é usɨ mbi-dé-tɨ, adɨ dow-je n̰a̰ dꞌadɨ mḛḛ-dé ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyər ra ndɔ n̰a̰ Jope, mḛḛ kəy-tɨ lə Simɔ̰ kɨ́ to njèkɔl ndaá. ");
INSERT INTO mge_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dingəm káre bè isɨ ɓebo Sejare-tɨ, ri-é lə Kɔrnəy, ḛ to njèkun dɔ kutɨ asgar-je ɓu kɨ́ ꞌɓa-dé «asgar-je kɨ́ Itali.» ");
INSERT INTO mge_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔrnəy lé, to dow kɨ́ njèkilə kujɨ dɔ Lubə-tɨ rəm, to njèɓəl Lubə rəm, ɓá dow-je lay kɨ́ mḛḛ kəy-tɨ liə kàrè bè ya tɔ. Njéndoo-je kɨ́ dan jipɨ-je-tɨ lé, taá-taá ya ḛ ra sə-dé majɨ n̰a̰ rəm, to njèpata kɨ̀ Lubə taá-taá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lokɨ kàdɨ̀ təl rɔ-é adɨ à to kàdɨ̀ mutə je bè lé, né ra-é tokɨ nḭ bè, adɨ ḛ oo malayka lə Lubə yə́rə́rə́ kəm-é-tɨ, ree rɔ-é-tɨ ə ɓa-é panè: «Kɔrnəy!» ");
INSERT INTO mge_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrnəy oo malayka lé gə́rə́rə́ rəmə, ḛ ɓəl n̰a̰ adɨ dəjɨ-é panè: «Ri ra né wa, ꞌƁaɓe?» Malayka lé, idə-é panè: «Ta-je kɨ́ ꞌisɨ ꞌpa kɨ̀ Lubə rəm, majɨ-je kɨ́ ꞌisɨ ꞌra kɨ̀ njéndoo-je lé, ɔw tḛḛ rɔ Lubə-tɨ ə mḛḛ-é ole dɔ-i-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Beɓa kɨ́ ngɔsnè-tɨ kin ya, ꞌulə dingəm-je mḛḛ ɓe-tɨ kɨ́ Jope, kdɔ kadɨ dꞌɔw ꞌɓa Simɔ̰ kɨ́ ri gajɨ-é lə Piyər dꞌadɨ-é ree. ");
INSERT INTO mge_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Piyər lé, tò ɓe lə Simɔ̰ kɨ́ to njèkɔl ndaá, kɨ́ kəy liə tò kàdɨ̀ babo-tɨ ngɔsi kin.» ");
INSERT INTO mge_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lokɨ malayka kɨ́ pa siə ta lé, ɔtɨ ɔw bè ya rəmə, Kɔrnəy ɓa ngannjékullə-je liə joo rəm, ɓa asgar káre kɨ́ to njèkilə kujɨ dɔ Lubə-tɨ n̰a̰ dan dḛ-tɨ kɨ́ dꞌisɨ gin tɔ́gɨ-tɨ liə, ");
INSERT INTO mge_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","adɨ ꞌree ə ɔr-dé poy né-je kɨ́ ra né lé lay, ngá ɓá ulə-dé ɓebo Jope-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lo aa go-tɨ, lokɨ ngannjékullə-je, dꞌusɨ rəbəə dꞌɔw sar ꞌtḛḛ ngɔsi kɨ̀ ɓebo Jope rəmə, Piyər al taá dɔ kəy dur dur-tɨ kdɔ pa ta kɨ̀ Lubə kɨ̀ kàdɨ̀ kɨ́ a̰ jam dɔ ɓe-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɓo ra-é adɨ ndigɨ kuso né. Ngà lokɨ dꞌisɨ ꞌra nékuso kdɔ kadɨ-é ya ɓəy rəmə, né ra-é tokɨ nḭ bè. ");
INSERT INTO mge_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ḛ oo lo kɨ́ dɔra̰-tɨ tò tagra, rəmə né kɨ́ titɨ-na̰ kɨ̀ takubɨ kɨ́ tatɨ pəl-pəl, ə ꞌtɔ́ kulə sul-é-je-tɨ sɔ lay, ḭ taá isɨ risɨ kɨ dɔnangɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Da̰-je lay kɨ́ nja-dé ra sɔ-sɔ, dḛ kɨ́ dꞌagɨ nangɨ, kɨ̀ yəl-je kɨ́ ꞌnar taá ꞌtò mḛḛ takubɨ-tɨ lé, kɨ̀ kutɨ-dé kutɨ-dé. ");
INSERT INTO mge_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Rəmə Piyər oo ndi dow pa siə ta panè: «Piyər, ꞌḭ taá ꞌtɔl-dé ꞌuso!» ");
INSERT INTO mge_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ngà Piyər panè: «Kuy! ꞌƁaɓe, né kɨ́ majɨ al əse né kɨ́ tò n̰ḛ bè kinlé ma̰ mꞌuso nja káre al.» ");
INSERT INTO mge_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Piyər oo ndi dow lé təl pa siə ɓəy panè: «Né kɨ́ Lubə təl-é adɨ aa njay ngá lé, i ꞌa koo kɨ né kɨ́ tò n̰ḛ al ngá.» ");
INSERT INTO mge_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Né-é kinlé ree bè-bè nja mutə rəmə, lo-é-tɨ nɔ̰ɔ̰ ya təl ɔw dɔra̰-tɨ gogɨ, ");
INSERT INTO mge_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","adɨ Piyər dəjɨ rɔ-é ta panè: «Né kɨ́ ra-m tokɨ nḭ bè kinlé, kɔr mḛḛ-é to ri wa?» Ngà lokɨ ḛ isɨ gɨr ta-é kɨ gɨr ya ɓəy rəmə, dingəm-je kɨ́ Kɔrnəy ulə-dé lé, dꞌa̰ ꞌdəjɨ ꞌpanè se kəy lə Simɔ̰ tò rá wa, ə ꞌree dꞌa̰ takəy-tɨ ngɔsi ngá. ");
INSERT INTO mge_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Dḛ ꞌɓa ɓa kɨ̀ ndi-dé kɨ́ boy ꞌdəjɨ ꞌpanè: «Lo kin ya ɓá Simɔ̰ kɨ́ ri gajɨ-é lə Piyər tò-tɨ lé al wa?» ");
INSERT INTO mge_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lokɨ Piyər isɨ gɨr ta kɨ́ dɔ kɔr mḛḛ né-tɨ kɨ́ ra-é tokɨ nḭ bè kinlé ya ɓəy rəmə, Ndil kɨ́ aa njay idə-é panè: «ꞌOo bè, dingəm-je mutə dꞌa̰ ꞌdəjɨ-i. ");
INSERT INTO mge_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌḬ taá, ꞌrisɨ nangɨ ə ꞌɔw sə-dé, ɓɨ ꞌtadɨ ti-ti al, kdɔ to ma̰ ya ɓá mꞌulə-dé.» ");
INSERT INTO mge_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ngá ɓá Piyər risɨ nangɨ ɔw rɔ-dé-tɨ idə-dé panè: «Yən, ma̰ kɨ́ ꞌsangi-mi lé, ya ə́ mꞌa̰ tin. Ngà se sə̰i ꞌreei ban wa?» ");
INSERT INTO mge_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dḛ dꞌilə-é-tɨ ꞌpanè: «To Kɔrnəy njèkun dɔ kutɨ asgar-je kɨ́ ɓu ɓá ulə-ji. Ḛ to dow kɨ́ njururu, to njèɓəl Lubə, jipɨ-je lay ya ꞌpa ta kɨ̀ dɔ-é-tɨ majɨ. Lubə adɨ malayka kɨ́ aa njay ree tḛḛ kɨ̀ dɔ ta adɨ-é kadɨ ulə kulə ɓa-i kdɔ kadɨ ɔw idə-é ta.» ");
INSERT INTO mge_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Beɓa Piyər adɨ-dé ꞌtò kəy rɔ-é-tɨ nɔ̰ɔ̰ ya. Lo aa kɨ̀ ndɔge ngá ɓá Piyər usɨ rəbəə ɔw sə-dé. Njékadmḛḛ-je kɨ́ ná̰-je mḛḛ ɓebo Jope-tɨ ꞌdan-é. ");
INSERT INTO mge_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lo aa go-tɨ, ꞌtḛḛ mḛḛ ɓebo Sejare-tɨ. Lokɨ Kɔrnəy isɨ ngəbɨ-dé lé, ḛ ulə kulə ɓa nojɨ-é-je, kɨ̀ nam-é-je kɨ́ ḛ ndigɨ-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lokɨ Piyər ɔw kdɔ kandɨ kəy go-dé-tɨ rəmə, Kɔrnəy tilə kəm-é, usɨ nangɨ nja-é-tɨ, ɔsɨ dɔ-é nangɨ nɔ̰̀-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngà Piyər uwə-é kɨ taá ə panè: «ꞌḬ taá! Ma̰ kàrè mꞌto dow madɨ-i tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piyər pa siə ta taá-taá andɨ-né mḛḛ kəy-tɨ rəmə, ingə dow-je kɨ́ ꞌkəw-na̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ə ḛ pa sə-dé panè: «Sə̰i ꞌgəi majɨ, ndukun lə-ji lé, ɔgɨ dow kɨ́ to jipɨ kadɨ ində rɔ-é natɨ kɨ̀ dow kɨ́ to jipɨ al əse kadɨ ɔw mḛḛ kəy-tɨ liə. Ngà ma̰ lé, Lubə idə-m panè: “Mꞌa koo dow kadɨ to dow kɨ́ majɨ al əse to dow kɨ́ tò n̰ḛ takəm-nꞌḛ̀-tɨ al.” ");
INSERT INTO mge_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gin-é kin ɓá lokɨ sə̰i ꞌɓai-mi lé, mꞌtadɨ ti-ti al ya mꞌɔtɨ par mꞌree-né tin. Mꞌdəjɨ-si se ri ɓá uləi-né kulə go-m-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ngá ɓá Kɔrnəy idə-é panè: «ꞌOo bè, ɓone, asɨ ndɔ sɔ ngá, mꞌisɨ mꞌpa ta kɨ̀ Lubə mḛḛ kəy-tɨ lə-m kɨ̀ kàdɨ̀ kɨ́ mutə kɨ́ losɔlɔ, rəmə tajinatɨ nè ya dingəm káre kɨ́ ulə kubɨ kɨ́ ndóle kə̰́y-kə̰̀y a̰ nɔ̰̀-m-tɨ, ");
INSERT INTO mge_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","idə-m panè: “Kɔrnəy, Lubə oo ndi-i, ɓá mḛḛ-é ole dɔ majɨ-je-tɨ kɨ́ isɨ ra kɨ̀ njéndoo-je kin rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ꞌUlə dow-je ɓe-tɨ kɨ́ Jope, kdɔ kadɨ dꞌɔw ꞌɓa Simɔ̰ kɨ́ ri gajɨ-é lə Piyər dꞌadɨ-é ree. Ḛ tò mḛḛ kəy-tɨ lə Simɔ̰ kɨ́ to njèkɔl ndaá kɨ́ isɨ kàdɨ̀ babo-tɨ ngɔsi kin.” ");
INSERT INTO mge_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Beɓa kalangɨ bè ya mꞌulə-né dow-je go-i-tɨ tin. Adɨ ree lə-i kinlé, majɨ n̰a̰. Kɨ́ ngɔsnè-tɨ kinlé, jḛ lay ya jꞌisɨ nɔ̰̀ Lubə-tɨ nè, kdɔ koo ta-je lay kɨ́ ꞌƁaɓe un ndu kadɨ ꞌpa adɨ-ji.» ");
INSERT INTO mge_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piyər un ta panè: «Ooi majɨ, mꞌgə kɨ́ Lubə ɔr kəm dow al. ");
INSERT INTO mge_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Gin dow-je kɨ́ rá-rá ya lé, dow kɨ́ ɓəl Lubə rəm, ra né kɨ́ njururu lé, à nəl Lubə ya. ");
INSERT INTO mge_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sə̰i ꞌgəi majɨ, Lubə adɨ ta liə kɨ́ to Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ lapiya ɔw rɔ Israyel-je-tɨ kɨ̀ takul Jeju Kristɨ. Ḛ ya to ꞌƁa dow-je lay. ");
INSERT INTO mge_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Né kɨ́ un kutɨ ra né dɔnangɨ Galile-tɨ, sar tḛḛ-né dɔnangɨ Jude-tɨ go mbḛ-tɨ kɨ́ Ja̰ ilə sɔbɨ dɔ batḛm lé, sə̰i ꞌgəi majɨ. ");
INSERT INTO mge_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kəm rəbɨ kɨ́ Lubə adɨ-né Ndil kɨ́ aa njay rəm, adɨ-né tɔ́gɨ Jeju kɨ́ Najarɛtɨ-tɨ lé, kàrè sə̰i ꞌgəi majɨ tɔ. Jeju kɨ́ ɔw kɨ̀ ɓe-ɓe ra majɨ kɨ̀ dow-je, ajɨ dḛ kɨ́ dꞌisɨ gin tɔ́gɨ-tɨ lə Sú lé, kàrè sə̰i ꞌgəi majɨ rəm tɔ, kdɔtalə Lubə nà̰y siə. ");
INSERT INTO mge_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Né-je lay kɨ́ Jeju ra mḛḛ ɓe-je-tɨ lə jipɨ-je, kɨ̀ né-je kɨ́ ḛ ra mḛḛ ɓebo Jorijalḛm-tɨ lé, jḛ joo kɨ̀ kəm-ji, ɓá jꞌoo ta-é kɨ̀ mbi-ji rəm tɔ. Ngà dḛ ꞌɓə-é kagdəsɨ-tɨ ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Rəmə Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ mḛḛ ndɔ kɨ́ njèkungɨ-tɨ mutə ə Lubə adɨ-é tɔjɨ rɔ-é. ");
INSERT INTO mge_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Rɔ dow-je-tɨ lay al, ngà rɔ-ji jḛ-tɨ kɨ́ Lubə mbətɨ-ji kete kdɔ kadɨ jꞌto njékɔr poy ta-je liə lé ɓá ḛ tɔjɨ rɔ-é rɔ-ji-tɨ. Lokɨ ḛ tɔsɨ ndəl ində lo tḛḛ kàrè, jḛ jꞌuso siə né natɨ rəm, ɓá jꞌa̰y siə natɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Beɓa ḛ un ndu adɨ-ji, kdɔ kadɨ jꞌilə mbḛ jꞌadɨ dow-je ꞌgə kɨ́ Lubə ində-nꞌḛ̀ kɨ́ njègangta dɔ dow-je-tɨ kɨ́ dꞌisɨ kəm rəm, dɔ dḛ-tɨ kɨ́ dꞌoy rəm. ");
INSERT INTO mge_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Njépata-je kɨ́ ta Lubə-tɨ lay ya ꞌpa ta kɨ́ dɔ-é-tɨ ꞌpanè: “Dow kɨ́ rá-rá kɨ́ adɨ-é mḛḛ-é lé, Lubə à kin̰ə go majal-je liə kɔgɨ kadɨ-é kɨ̀ takul ri-é.”» ");
INSERT INTO mge_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lokɨ Piyər isɨ pa ta bè-bè ya ɓəy rəmə, Ndil kɨ́ aa njay risɨ ree dɔ dow-je-tɨ lay kɨ́ dꞌisɨ dꞌoo ta liə lé. ");
INSERT INTO mge_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Beɓa njékadmḛḛ-je kɨ́ ꞌto jipɨ-je kɨ́ ꞌdan Piyər ree siə natɨ lé, ndil-dé tḛḛ sa̰y, kdɔtalə Lubə adɨ Ndil kɨ́ aa njay kadkare-tɨ, dow-je kɨ́ ꞌto jipɨ-je al tɔ. ");
INSERT INTO mge_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kdɔ dḛ dꞌoo ndi-dé kɨ́ dꞌisɨ ꞌpa ta kɨ̀ ndɔ̰ ta ɓe lə dow-je kɨ́ rangɨ, ɓá ꞌtɔ́y Lubə rəm, ngá ɓá Piyər panè: ");
INSERT INTO mge_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Dow-je kɨ́ dꞌingə Ndil kɨ́ aa njay titɨ-na̰ sə-ji bè tɔ lé se dow à kɔgɨ-dé ra batḛm kəm man-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ə Piyər lé, un ndu kadɨ ꞌra-dé batḛm kɨ̀ ri Jeju Kristɨ. Go-tɨ, dḛ dəjɨ-é kadɨ isɨ sə-dé kɨ mbɔr mɔkɨ tá. ");
INSERT INTO mge_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Njékɔwkulə-je, kɨ̀ njékadmḛḛ kɨ́ dꞌisɨ dɔnangɨ Jude-tɨ, dꞌoo poy-é kɨ́ dḛ kɨ́ ꞌto jipɨ-je al ya kàrè ꞌtaa ta lə Lubə tɔ. ");
INSERT INTO mge_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ngà lokɨ Piyər təl ree ɓebo Jorijalḛm-tɨ lé, njékadmḛḛ-je kɨ́ ꞌto jipɨ-je ꞌkɔl siə ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«I ꞌɔw mḛḛ kəy-tɨ lə dow-je kɨ́ dꞌijə-dé ganjangɨ al ə ꞌuso sə-dé né!» ");
INSERT INTO mge_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Beɓa Piyər ɔr-dé go né-je kɨ́ ra né lé berere-berere panè: ");
INSERT INTO mge_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ma̰ mꞌisɨ mḛḛ ɓebo Jope-tɨ, ə lokɨ mꞌisɨ mꞌpa ta kɨ̀ Lubə rəmə, mꞌtḛḛ mꞌusɨ ə né ra-m tokɨ nḭ bè, adɨ mꞌoo né kɨ́ titɨ-na̰ kɨ̀ takubɨ kɨ́ tatɨ pəl-pəl kɨ́ ꞌtɔ́ kulə sul-é-je-tɨ sɔ lay, ḭ dɔra̰-tɨ risɨ ree njal rɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mꞌoo takubɨ lé gə́rə́rə́ rəmə, mꞌoo da̰-je kɨ́ nja-dé ra sɔ-sɔ, da̰-je kɨ́ wale rəm, dḛ kɨ́ dꞌagɨ nangɨ rəm, ɓá yəl-je kɨ́ ꞌnar taá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Beɓa mꞌoo ndi dow idə-m panè: “Piyər ꞌḭ taá ꞌtɔl-dé ꞌuso!” ");
INSERT INTO mge_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngá ɓá ma̰ mꞌilə-tɨ mꞌpanè: “Kuy! ꞌƁaɓe, né kɨ́ majɨ al əse né kɨ́ tò n̰ḛ bè kin ɔdɨ ta-m nja káre al.” ");
INSERT INTO mge_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mꞌoo ndi dow ɓa dɔra̰-tɨ ya ɓəy panè: “Né kɨ́ Lubə təl-é adɨ aa njay ngá lé, i ꞌa koo kɨ né kɨ́ tò n̰ḛ al ngá.” ");
INSERT INTO mge_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Né kinlé tḛḛ bè-bè nja mutə, ɓá təl lay ɔw dɔra̰-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Rəmə lo-é-tɨ nè ya, dingəm-je kɨ́ mutə kɨ́ dꞌulə-dé ɓebo Sejare-tɨ kadɨ ꞌree rɔ-m-tɨ lé, ꞌree dꞌa̰ takəy-tɨ kɨ́ mꞌisɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ə Ndil kɨ́ aa njay idə-m kadɨ mꞌɔw sə-dé, ɓɨ kadɨ mꞌtadɨ ti-ti al. Beɓa ngankɔ̰-m-je kɨ́ mɛkḛ kan, ꞌdan-m dꞌadɨ jꞌɔw mḛḛ kəy-tɨ lə Kɔrnəy.» ");
INSERT INTO mge_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Beɓa njèkəy lé ɔr-ji poy né kɨ́ ra né lé panè: «Mꞌoo malayka ree mḛḛ kəy-tɨ lə-m, idə-m panè: “ꞌUlə kulə mḛḛ ɓe-tɨ kɨ́ Jope kadɨ dꞌidə Simɔ̰ kɨ́ ri gajɨ-é lə Piyər kadɨ ree. ");
INSERT INTO mge_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ḛ ɓá à kidə-i ta kɨ́ à kajɨ-né kɨ̀ dḛ kɨ́ mḛḛ kəy-tɨ lə-i lay.” ");
INSERT INTO mge_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lokɨ mꞌun gin pa ta lé, Ndil kɨ́ aa njay ree dɔ-dé-tɨ titɨ-na̰ kɨ́ ndɔkɨ ree-né dɔ-ji jə̰i-tɨ lo kulə gin-é-tɨ nṵ kinlé bè tɔ. ");
INSERT INTO mge_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Beɓa mḛḛ-m ole-né dɔ ta-tɨ kɨ́ ꞌƁaɓe pa panè: “Ja̰ ra dow-je batḛm mani, ngà sə̰i lé batḛm lə Ndil kɨ́ aa njay ɓá a rai.” ");
INSERT INTO mge_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kinə Lubə adɨ-dé Ndil kɨ́ aa njay kadkare-tɨ titɨ kɨ́ ḛ adɨ-ji-né jə̰i kɨ́ jꞌadi mḛḛ-ji ꞌƁaɓe Jeju Kristɨ bè tɔ lé, ma̰ mꞌto ná̰ ɓá kadɨ mꞌmbatɨ go Lubə-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lokɨ dꞌoo ta-je kin bè lé, dḛ lay ya dꞌilə mḛḛ-dé nangɨ pɔ̰ɔ̰, adɨ dꞌɔsɨ gajɨ Lubə ꞌpanè: «Tɔgrɔ-tɨ ya, dow-je kɨ́ ꞌto jipɨ-je al ya kàrè, Lubə adɨ-dé tarəbɨ adɨ dꞌin̰ə panjiyə-dé kɨ́ majɨ al kɔgɨ dꞌisɨ-né kəm sartagangɨ.» ");
INSERT INTO mge_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kulə kəm-na̰ ndoo kɨ́ ulə gin-é dɔ koy Etiyḛn-tɨ lé, ra adɨ njékadmḛḛ-je ꞌsane-na̰. Dḛ kɨ́ madɨ-je dꞌɔw njal ꞌtḛḛ ɓebo Penisi-tɨ, kɨ̀ dɔnangɨ Siprə kɨ́ tò dan ba-tɨ rəm, ɓá ɓebo Antiosɨ-tɨ tɔ; ə ꞌpa ta lə Lubə dꞌadɨ jipɨ-je ya par. ");
INSERT INTO mge_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Rəmə njékadmḛḛ-je kɨ́ ꞌná̰-je kɨ́ dan dḛ-tɨ kɨ́ ꞌto dow-je kɨ́ dɔnangɨ Siprə, kɨ̀ ɓebo Sirḛn-tɨ dꞌɔw ɓebo Antiosɨ-tɨ dꞌilə mbḛ Poyta kɨ́ Majɨ lə ꞌƁaɓe Jeju dꞌadɨ dow-je kɨ́ ꞌto grɛkɨ-je tɔ. ");
INSERT INTO mge_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Beɓa tɔ́gɨ ꞌƁaɓe nà̰y sə-dé adɨ dow-je n̰a̰ ya dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ə dꞌadɨ mḛḛ-dé ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ə ta-é usɨ mbi njékəwna̰-je-tɨ kɨ́ ɓebo Jorijalḛm-tɨ, adɨ dꞌulə Barnabasɨ dꞌadɨ-é ɔw njal ɓebo Antiosɨ-tɨ rɔ-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lokɨ Barnabasɨ ɔw tḛḛ, ɓá oo ramajɨ lə Lubə bè lé, rɔ-é nəl-é n̰a̰ adɨ ulə dingəm mḛḛ-dé-tɨ lay kadɨ ꞌnam kàdɨ̀ ꞌƁaɓe-tɨ kɨ̀ mḛḛ-dé kɨ́ káre-rè. ");
INSERT INTO mge_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasɨ lé to dow kɨ́ majɨ rəm, Ndil kɨ́ aa njay rusɨ mḛḛ-é rəm, ɓá to njèkadmḛḛ kɨ́ n̰a̰ rəm tɔ. Beɓa kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌree rɔ ꞌƁaɓe-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Go-tɨ lé Barnabasɨ ḭ ɔw ɓebo Tarsɨ-tɨ kdɔ sangɨ Sol. ");
INSERT INTO mge_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ngà lokɨ ingə-é lé, adɨ-é ree siə ɓebo Antiosɨ-tɨ. Ə dḛ joo lay ya ꞌra ɓal káre natɨ kɨ̀ njékəwna̰-je lo kingə-na̰-je-tɨ lə-dé ə kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya dḛ ꞌndó-dé né. Mḛḛ ɓebo Antiosɨ-tɨ lé ɓá to lokɨ dɔsa̰y sakɨ-sakɨ kɨ́ ꞌɓa njéndó né-je lə Jeju «njékun go Kristɨ.» ");
INSERT INTO mge_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dɔgangɨ ndɔ-é-je-tɨ kinlé, njépata-je kɨ́ ta Lubə-tɨ dꞌḭ ɓebo Jorijalḛm-tɨ dꞌɔw ɓebo Antiosɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ndil kɨ́ aa njay tḛḛ kɨ̀ dɔ ta adɨ dow káre dan-dé-tɨ kɨ́ ri-é lə Agabusɨ adɨ panè: Ɓobo à kusɨ dɔnangɨ-tɨ nè lay. Rəmə, ɓo lé usɨ ɓal kɔ̰ɓe-tɨ lə ngar Klodɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Beɓa njéndó né-je dꞌun ndu-dé kadɨ ná̰-ná̰ ya adɨ né kɨ́ go nékingə-é-tɨ kadɨ dꞌulə-né kɨ kadkare-tɨ kadɨ ra kɨ̀ njékadmḛḛ-je kɨ́ dꞌisɨ dɔnangɨ Jude-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Dḛ ꞌmbɔ̰ kadkare-je lé, dꞌulə-né Barnabasɨ-je kɨ̀ Sol rɔ ꞌngatɔ́gɨ-je-tɨ kɨ́ dɔnangɨ Jude-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dɔkaglo-é-tɨ kinlé, ngar Erodɨ un kutɨ kulə kəm dow-je madɨ dan njékəwna̰-je-tɨ ndoo. ");
INSERT INTO mge_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Beɓa ḛ adɨ ꞌtɔl Jakɨ kɨ́ ngonkɔ̰ Ja̰ kɨ̀ kiyərɔ. ");
INSERT INTO mge_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Lokɨ oo kadɨ né kɨ́ nꞌra kin nəl jipɨ-je n̰a̰ lé, ḛ adɨ dꞌuwə Piyər dꞌilə-é dangay-tɨ tɔ. Ndɔ-é-tɨ kinlé, to ndɔ ra na̰y kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lokɨ Erodɨ adɨ dꞌuwə Piyər dꞌilə-é dangay-tɨ lé, ḛ ɔy asgar-je sɔ-sɔ kutɨ sɔ adɨ ꞌngəm ta-é, kdɔtalə ḛ gɨr kadɨ nꞌgangɨ ta dɔ-é-tɨ ndaa-tɨ takəm kosɨ dow-je-tɨ go ra na̰y Pakɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Lokɨ Piyər a̰ kəy dangay-tɨ lé, njékəwna̰-je ꞌpa ta kɨ̀ Lubə kɨ̀ rɔ tungə-dé ya par-par kdɔ ta liə. ");
INSERT INTO mge_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ndɔɔ bè, kadɨ lo aa ə Erodɨ à tḛḛ siə dan dow-je-tɨ kdɔ gangta dɔ-é-tɨ lé, Piyər tò ɓi mbunə̰ asgar-je-tɨ joo. Dꞌilə Piyər sil rəm, ɓá njéngəm takəy dangay-je ꞌngəm rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Rəmə kəm kɨ́ kində jipɨ bè ya malayka lə ꞌƁaɓe tḛḛ kɔy ə lokɨ Piyər tò-tɨ lé ndógɨ doo, ngá ɓá Malayka lé ində kàdɨ̀ Piyər ɗə-ɗə ndəl-é-né panè: «Ḭ taá kalangɨ!» Rəmə sil kɨ́ ji-é-tɨ lé ga̰y wɔgrɔ-wɔgrɔ. ");
INSERT INTO mge_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ngá ɓá malayka lé idə-é panè: «ꞌUn ndaá dɔɔ ɓədɨ lə-i ꞌdɔ-né ɓədɨ-i ə ꞌulə saba lə-i nja-i-tɨ.» Piyər ra titɨ kɨ́ ḛ idə-é-né, ngá ɓá malayka lé təl idə-é panè: «ꞌUlə kubɨ kul lə-i ə ꞌun go-m.» ");
INSERT INTO mge_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyər tḛḛ kəy dangay-tɨ njiyə go malayka-tɨ. Né kɨ́ malayka ra kinlé, Piyər oo kɨ́ to né kɨ́ tɔgrɔ-tɨ al. Ḛ gɨr panè to nḭ. ");
INSERT INTO mge_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lokɨ dꞌində ta njéngəm takəy dangay-je kɨ́ dɔsa̰y ꞌgangɨ, ꞌree dꞌində kɨ́ njèkungɨ-tɨ joo ꞌgangɨ, ꞌree ꞌtḛḛ tarəbɨ-tɨ kɨ́ ꞌra kɨ̀ ngɔw là kɨ́ to tarəbɨ kɨ́ ɔw kɨ mḛḛ ɓebo-tɨ rəmə, tarəbɨ-é lé tḛḛ nɔ̰̀-dé-tɨ kɨ̀ dɔ rɔ-é ya, adɨ ꞌtḛḛ ndaa-tɨ dꞌun rəbɨ káre bè dꞌisɨ dꞌɔw rəmə, malayka lé, igɨ yɔm go Piyər-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ngá ɓá kəm Piyər ijə yərərə adɨ panè: «Kɨ́ nè kin ɓəy ɓá mꞌgə majɨ kɨ́ to ꞌƁaɓe ya ulə malayka liə adɨ ree ɔr-m ji ngar Erodɨ-tɨ rəm, ɔr-m mḛḛ né-je-tɨ kɨ́ majɨ al lay kɨ́ jipɨ-je ꞌndigɨ ra sə-m rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Lokɨ kəm Piyər ijə dɔ rɔ-é-tɨ majɨ lé, ḛ ɔw ɓe lə Mari kɨ́ kɔ̰ Ja̰. Ja̰ lé, ri gajɨ-é lə Markɨ. Kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌkəw-na̰ ɓe lə Mari lé, dꞌisɨ ꞌpa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Lokɨ Piyər ree tḛḛ takəy-tɨ a̰ ində takəy rəmə, ngonnjèkullə kɨ́ dené kɨ́ ꞌɓa-é Rodɨ ree kdɔ koo. ");
INSERT INTO mge_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ngà lokɨ ḛ ree ɓá oo ndi Piyər gə rəmə, rɔ-é nəl-é n̰a̰ adɨ ɔr takəy al, ngà təl kɨ̀ ngɔdɨ ɔw idə-dé panè Piyər a̰ ndaa-tɨ takəy-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Rəmə dꞌilə-é-tɨ ꞌpanè: «Dɔ-i ində-i wa!» Ngà ḛ təl idə-dé panè: «To Piyər ya lé.» Ngá ɓá dḛ ꞌpanè: «À to malayka liə je bè.» ");
INSERT INTO mge_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ngà Piyər ində takəy par-par. Beɓa lokɨ ꞌree ꞌtḛḛ takəy ɓá dꞌoo-é rəmə, lo ta igɨ-dé sə́l. ");
INSERT INTO mge_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piyər ra ji-é kəngɨ-dé-né kadɨ ꞌpa ta al, ngá ɓá ḛ ɔr-dé poy né kɨ́ ꞌƁaɓe ra ɓá ɔr-é-né kəy dangay-tɨ tḛḛ-né siə ndaa-tɨ lé. Ḛ təl idə-dé panè: «Idə-i ta-é Jakɨ-je kɨ̀ ndəgɨ njékadmḛḛ-je.» Ngá ɓá ḛ tḛḛ ɔw lo kɨ́ rangɨ-tɨ ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lokɨ lo aa lé, asgar-je dꞌɔw dɔ-na̰-tɨ wúr-wùr adɨ ꞌdəjɨ-na̰ ꞌpanè se ri ɓá tḛḛ dɔ Piyər-tɨ lé wa? ");
INSERT INTO mge_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Beɓa Erodɨ adɨ dꞌɔw ꞌndole-é, ngà dꞌingə-é al. Ḛ ɓa asgar-je kɨ́ njéngəm takəy-je lé dəjɨ-dé ta ə un ndu kadɨ ꞌtɔl-dé. Go-tɨ, Erodɨ ḭ dɔnangɨ Jude-tɨ ɔw isɨ ɓebo Sejare-tɨ asɨ dɔkaglo sḛ ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ta tò dan Erodɨ-tɨ dḛ kɨ̀ dow-je kɨ́ dɔnangɨ Tir-tɨ, kɨ̀ dow-je kɨ́ dɔnangɨ Sidɔ̰-tɨ. Beɓa dḛ dꞌadɨ ta-dé asɨ-na̰ kadɨ ꞌree dꞌingə Erodɨ. Lokɨ dḛ ꞌndogɨ mḛḛ Blastusɨ kɨ́ to gɔ̰rɔ kɨ́ njèkində kəm-é go né-je-tɨ lə ngar Erodɨ lé, dḛ dꞌɔw ꞌdəjɨ ngar kadɨ dꞌulə siə nojɨ natɨ, kdɔtalə ɓekɔ̰ liə ɓá to lo kingə nékuso lə-dé. ");
INSERT INTO mge_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erodɨ ɔr ndɔ ulə-né kubɨ ngar liə rɔ-é-tɨ, ə isɨ dɔ kalikɔ̰ɓe-tɨ liə, ɓá pa ta-je kɨ́ nga̰-nga̰ kɨ̀ kosɨ dow-je. ");
INSERT INTO mge_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Rəmə dow-je ꞌtɔ́y-é mbitɨ-mbitɨ ꞌpanè: «Kay! Kin to ndi magɨ ə́n ɓɨ, to ndi dow al!» ");
INSERT INTO mge_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ngá ɓá lo-é-tɨ nɔ̰ɔ̰ ya malayka lə ꞌƁaɓe ində Erodɨ ɔjɨ-é, kdɔtalə Erodɨ nàjɨ riɓa kɨ̀ Lubə, beɓa tajinatɨ nè ya kode-je dꞌində-é dꞌadɨ-é oy. ");
INSERT INTO mge_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ngà ta lə Lubə sane ɔw kɨ kete-kete. ");
INSERT INTO mge_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lokɨ Barnabasɨ-je kɨ̀ Sol ꞌtɔl ta kullə lə-dé kɨ́ mḛḛ ɓebo Jorijalḛm-tɨ lé, dḛ dꞌadɨ Ja̰ kɨ́ ri gajɨ-é lə Markɨ lé, təl sə-dé natɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Dan njékəwna̰-je-tɨ kɨ́ ɓebo Antiosɨ-tɨ lé, njépata-je kɨ́ ta Lubə-tɨ, kɨ̀ njéndó dow-je ndukun-je kɨ́ dꞌisɨ mbunə̰-dé-tɨ ə́n: Barnabasɨ rəm, Simiyɔ̰ kɨ́ ꞌɓa-é dow kɨ́ ndul rəm, Lusiyusɨ kɨ́ ɓebo Sirḛn-tɨ rəm, Manayḛn kɨ́ dꞌutɨ-é natɨ kɨ̀ Erodɨ kɨ́ njèkɔ̰ɓe rəm, ɓá Sol rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Beɓa ndɔ káre bè kɨ́ dꞌisɨ ꞌpole ꞌƁaɓe ɓá dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y dꞌisɨ ꞌpa ta kɨ̀ Lubə lé, Ndil kɨ́ aa njay idə-dé panè: «Ɔri Barnabasɨ-je kɨ̀ Sol indəi-dé tagay adi-mi, kdɔ kullə kɨ́ mꞌɓa-dé kdɔ lé.» ");
INSERT INTO mge_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lokɨ dꞌɔgɨ rɔ-dé nékuso kɨ̀ man ka̰y ꞌpa ta kɨ̀ Lubə lé, dḛ dꞌində ji-dé dɔ-dé-tɨ ɓá dꞌin̰ə-dé kadɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ndil kɨ́ aa njay ulə Barnabasɨ-je kɨ̀ Sol adɨ dꞌɔw Selesi-tɨ ngá ɓá dꞌal bato dꞌɔw dɔnangɨ Siprə-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ngà lokɨ ꞌtḛḛ ɓebo Salamin-tɨ lé, dḛ ꞌpa ta lə Lubə mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je. Ngonnjèkullə lə-dé Ja̰ Markɨ ɔw sə-dé natɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lokɨ dꞌində dɔnangɨ Siprə kɨ́ tò dan ba-tɨ ꞌgangɨ lé, dꞌɔw njal ɓebo Paposɨ-tɨ. Lo kin-tɨ lé, dꞌingə mbəli káre kɨ́ ꞌɓa-é Bar Jeju. Ḛ to jipɨ ə oo rɔ-é kɨ njèpata kɨ́ ta Lubə-tɨ rəm, ");
INSERT INTO mge_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ɓá to njèkisɨ dɔ ji Gubərnər-tɨ kɨ́ ri-é lə Sɛrjiyusɨ Polusɨ kɨ́ to dingəm kɨ́ njènégə rəm. Gubərnər lé, adɨ ꞌɓa Barnabasɨ-je kɨ̀ Sol kdɔ ḛ ndigɨ koo ta lə Lubə. ");
INSERT INTO mge_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ngà dow káre bè kɨ̀ to mbəli, ri-é lə Elimasɨ kɨ̀ ta grɛkɨ, ɓá ndigɨ al, adɨ ḛ sangɨ kadɨ nꞌtəl dɔ gubərnər dɔ kadmḛḛ-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Beɓa Sol kɨ́ ꞌɓa-é Pol kɨ́ Ndil kɨ́ aa njay rusɨ mḛḛ-é lé oo-é ngətɨ-ngətɨ, ");
INSERT INTO mge_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɓá idə-é panè: «I dingəm kɨ́ kədɨ ta kɨ̀ né ra kɨ́ go rəbɨ-é-tɨ al ya rusɨ mḛḛ-i, i ngon lə Sú, njèkɔsɨ ta né-je lay kɨ́ to né kɨ́ njururu. I lé, ndɔ kɨ́ rá-tɨ ɓá ꞌa taakoo ta tujɨ kɔjra-je-tɨ lə ꞌƁaɓe kɨ́ to kɔjra-je kɨ́ njururu kinlé wa? ");
INSERT INTO mge_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yən, kɨ́ ngɔsnè-tɨ kin ya, ꞌƁaɓe à kində-i kɔjɨ-i ə kəm-i à tɔɔ, adɨ ꞌa koo ndógɨ kàdɨ̀ al ya dɔkaglo asɨ tatɨ.» Beɓa tajinatɨ nè ya lo ndul kəm Elimasɨ-tɨ ndḭ-ndḭ, adɨ mam lo ba-ba sangɨ-né dow kadɨ ndɔr-é. ");
INSERT INTO mge_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lokɨ Gubərnər oo né kɨ́ ra-né kinlé rəmə, adɨ mḛḛ-é, kdɔtalə néndó kɨ́ sɔbɨ dɔ ꞌƁaɓe lé, ɔr ndil-é. ");
INSERT INTO mge_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol kɨ̀ madkullə-je liə dꞌal mḛḛ bato-tɨ kɨ́ ɓebo Paposɨ-tɨ, dꞌɔw ɓebo Pɛrje-tɨ kɨ́ tò dɔnangɨ-tɨ kɨ́ Pampili. Ja̰ tusɨ-dé in̰ə-dé lo-é-tɨ kin, ə təl ɔw ɓebo Jorijalḛm-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dḛ dꞌḭ ɓebo Pɛrje-tɨ, dꞌɔw ɓebo Antiosɨ-tɨ kɨ́ tò dɔnangɨ Pisidi-tɨ. Rəmə dꞌɔw kəykəwna̰-tɨ lə jipɨ-je ndɔ taakoo-tɨ lə jipɨ-je ə dꞌisɨ lo-é-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lokɨ ꞌndó mbete ndukun lə Moiyijɨ rəm, ɓá ꞌndó mbete lə njépata kɨ́ ta Lubə-tɨ rəm lé, njékun dɔ kəykəwna̰ lə jipɨ-je dꞌulə kulə dꞌidə Pol-je ꞌpanè: «Ngankɔ̰-ji-je, kinə ɔwi kɨ̀ ta madɨ kdɔ kadɨ uləi-né dingəm mḛḛ njékəwna̰-je-tɨ rəmə, tarəbɨ tò tagɨ kadɨ ꞌpai.» ");
INSERT INTO mge_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Beɓa Pol ḭ taá yəkɨ ji-é adɨ dꞌisɨ selele ɓá panè: «Sə̰i Israyel-je rəm, sə̰i kɨ́ ꞌɓəli Lubə rəm, ꞌyəli mbi-si ooi-né ta lə-m! ");
INSERT INTO mge_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lubə lə gin dow-je lə-ji kɨ́ ꞌto Israyel-je mbətɨ ka-ji-je. Ḛ adɨ kɔr-dé usɨ dɔ madɨ-é-tɨ, lokɨ dꞌisɨ-né ɓe mba-tɨ dɔnangɨ Ejiptɨ-tɨ, ɓá adɨ-dé ꞌtḛḛ kɔgɨ dɔnangɨ-tɨ kinlé kɨ̀ takul tɔ́gɨ-é kɨ́ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ḛ ul-dé asɨ ɓal kɔrsɔ diləlo-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ɓəy ɓá ḛ tɔɔ ko gin dow-je siri dɔnangɨ Kana̰-tɨ ə təl kɨ̀ dɔnangɨ lə-dé adɨ dow-je liə néndubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Né-je kin lay lé, ra né asɨ ɓal ɓusɔ kɨ̀ kɔrmḭ je bè.» «Go-tɨ gogɨ ɓá, ḛ ində njégangta-je adɨ ka-ji-je sar tḛḛ-né kaglo-tɨ lə Samiyel kɨ́ to njèpata kɨ́ ta-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ngá ɓá dḛ ꞌdəjɨ ngar, ɓá Lubə adɨ-dé Saul kɨ́ ngon lə Kisɨ kɨ́ to kɨ́ gin kojɨ-tɨ lə Benjamḛ adɨ ɔ̰̀ ɓe dɔ-dé-tɨ ɓal kɔrsɔ. ");
INSERT INTO mge_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ngà go-tɨ gogɨ, lokɨ Lubə mbatɨ Saul lé, ḛ adɨ Dabidɨ to ngar lə-dé. Ta kɨ́ Lubə pa dɔ Dabidɨ-tɨ ə́n: “Ma̰ mꞌingə Dabidɨ, ngon lə Jese, kɨ dow kɨ́ mḛḛ-m ndigɨ, ḛ à ra né-je lay kɨ́ mḛḛ-m ndigɨ.” ");
INSERT INTO mge_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gin ka-tɨ lə Dabidɨ lé, ɓá Lubə adɨ dꞌojɨ Jeju kɨ́ to njèkajɨ Israyel-je, titɨ kɨ́ ḛ un-né mindɨ-é kete lé. ");
INSERT INTO mge_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kete nɔ̰̀ ree Jeju-tɨ lé, Ja̰ ilə mbḛ adɨ gin Israyel-je lay kadɨ ꞌra batḛm kdɔ kadɨ tɔjɨ kin̰ə kɨ́ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ngà dɔkaglo-tɨ kɨ́ Ja̰ tɔl ta kullə liə lé, ḛ panè: “Mꞌto dow kɨ́ sə̰i ꞌngəbi-é kinlé al. Ooi bè, ḛ kɨ́ à ree go-m-tɨ lé, kulə saba kɨ́ nja-é-tɨ ya kàrè mꞌtuwə kadɨ mꞌtutɨ al.”» ");
INSERT INTO mge_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Ngankɔ̰-m-je, sə̰i kɨ́ ꞌtoi nganka Abrakam rəm, dḛ kɨ́ dan-si-tɨ nè kɨ́ ꞌɓəl Lubə rəm lé, jə̰i ya ɓá ta kajɨ kinlé sɔbɨ dɔ-ji. ");
INSERT INTO mge_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kdɔ dow-je kɨ́ ɓebo Jorijalḛm-tɨ kɨ̀ ꞌboy-je lə-dé lé, ꞌgə Jeju al rəm, ɓá ta-je lə njépata-je kɨ́ ta Lubə-tɨ kɨ́ dow-je ꞌndó kɨ̀ ndɔ taakoo-je lə jipɨ-je lay-lay kinlé kàrè ꞌgə mḛḛ-é al rəm tɔ. Ta kɨ́ dḛ ꞌgangɨ dɔ Jeju-tɨ kin, dḛ ꞌra dꞌadɨ ta-je lay kinlé né-é ra-né né tɔ. ");
INSERT INTO mge_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Dḛ dꞌingə ta kɨ́ asɨ koy-é al, ya ꞌdəjɨ Pilatɨ kadɨ adɨ ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ngà lokɨ dḛ ꞌra siə né-je lay kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay sɔbɨ-né dɔ-é lé, dḛ dꞌɔr-é kagdəsɨ-tɨ dꞌɔw ꞌdubɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ngà Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ. ");
INSERT INTO mge_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Dḛ kɨ́ dꞌḭ siə dɔnangɨ Galile-tɨ ꞌdan-é dꞌɔw siə ɓebo Jorijalḛm-tɨ lé, ḛ tḛḛ sə-dé busɨ-busɨ ya asɨ ndɔ n̰a̰. Dḛ lé ɓá ɓone bè ꞌtəl ꞌto njépata-je liə kadɨ dow-je kɨ́ to Israyel-je.» ");
INSERT INTO mge_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Jḛ kàrè, jꞌree jꞌilə mbḛ Poyta kɨ́ Majɨ kinlé jꞌadɨ-si jꞌpanè: Kunmindɨ kɨ́ Lubə un adɨ ka-ji-je lé, ");
INSERT INTO mge_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ḛ adɨ né-é ra né dɔ-ji-tɨ, jə̰i nganka-dé-je, kɨ̀ takul tɔsɨ kɨ́ ḛ adɨ Jeju tɔsɨ ndəl ində lo tḛḛ, titɨ kɨ́ ꞌndàngɨ-né ta-é mḛḛ mbete Pa-je-tɨ lo kɔr-é-tɨ kɨ́ joo ꞌpanè: “I ꞌto Ngon-m, ɓone Ma̰ ya mꞌto Bɔbɨ-i.”» ");
INSERT INTO mge_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Tɔsɨ kɨ́ Lubə adɨ Jeju tɔsɨ ndəl ində lo tḛḛ lé, ḛ adɨ-é tḛḛ kdɔ kadɨ ndum gogɨ al ngá lé ɓá pa-né panè: “Mꞌa kadɨ-si né-je kɨ́ aa njay kɨ́ mꞌun mindɨ-m dɔ-tɨ, mꞌadɨ Dabidɨ. To kun mindɨ kɨ́ mꞌa̰ dɔ-tɨ njángɨ.”» ");
INSERT INTO mge_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Gin-é kin ɓá Lubə pa-né mḛḛ mbete-tɨ kɨ́ rangɨ ɓəy panè: “I ꞌa kin̰ə-m ma̰ dow lə-i kɨ́ mꞌaa njay kadɨ mꞌndum al.” ");
INSERT INTO mge_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Dabidɨ lé, lokɨ ḛ ra kullə kaglo-tɨ liə tɔl-né ta kɔjra-je lə Lubə lé, oy adɨ ꞌdubɨ-é mbɔ́ ka-é-je-tɨ ə ḛ ndum. ");
INSERT INTO mge_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ngà ḛ kɨ́ Lubə adɨ-é tɔsɨ ndəl ində lo tḛḛ lé, ndum al. ");
INSERT INTO mge_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Beɓa ngankɔ̰-m-je, kadɨ ꞌgəi majɨ, to takul Jeju lé ɓá jꞌilə-né mbḛ kin̰ə go majal-je lə-si kɔgɨ ");
INSERT INTO mge_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","rəm, ɓá né-je lay kɨ́ ndukun lə Moiyijɨ asɨ kɔr ta-é dɔ-si-tɨ al lé, ná̰-ná̰ kɨ́ adɨ mḛḛ-é Jeju lé, ta-é ɔr dɔ-é-tɨ kɔgɨ lay rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Beɓa ooi go rɔ-si majɨ, kadɨ né-je kɨ́ njépata-je kɨ́ ta Lubə-tɨ ꞌpa dꞌadɨ-si kinlé tḛḛ dɔ-si-tɨ al. Dḛ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Ooi majɨ, sə̰i njénədɨ dow-je, adi ndil-si tḛḛ sa̰y ə igi yɔm. Kdɔtalə mꞌa ra né káre dɔkaglo-tɨ lə-si nè ya. Né kɨ́ mꞌa ra lé, lé dow ɔr-si poy-é ya kàrè a kooi kɨ ta kɨ́ tɔgrɔ-tɨ al!”» ");
INSERT INTO mge_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ngà lokɨ Pol-je kɨ̀ Barnabasɨ ꞌtḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, ꞌdəjɨ-dé kadɨ ꞌtəl ꞌree kɨ̀ ndɔ taakoo kɨ́ gogɨ rangɨ kadɨ ꞌpa ga̰ ta kinlé, dꞌadɨ-dé ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ngà go kəw-na̰-tɨ lé, jipɨ-je kɨ̀ jipɨ təl-je kɨ́ ꞌto njékilə kujɨ dɔ Lubə-tɨ n̰a̰ ya dꞌun go Pol-je kɨ̀ Barnabasɨ. Pol-je lé, dꞌɔjɨ sə-dé ta rəm, ɓá dꞌulə dingəm mḛḛ-dé-tɨ, kdɔ kadɨ ramajɨ lə Lubə lé, dꞌoy go-tɨ rigɨ-rigɨ ya. ");
INSERT INTO mge_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ndɔ taakoo-tɨ kɨ́ gogɨ rangɨ lé, dow-je kɨ́ mḛḛ ɓebo-tɨ ꞌkəw-na̰ n̰a̰ ya kdɔ koo ta lə Lubə, adɨ ndəgɨ dow-je nà̰y n̰a̰ al. ");
INSERT INTO mge_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ngà lokɨ jipɨ-je dꞌoo kosɨ dow-je kin bè lé, jangɨ ra-dé n̰a̰ adɨ ꞌpa takɔbɨ kɨ̀ Pol ꞌmbatɨ-né ta liə. ");
INSERT INTO mge_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Beɓa Pol-je kɨ̀ Barnabasɨ dꞌidə-dé ta kɨ̀ mḛḛnda ka̰y ꞌpanè: «Ooi bè, sə̰i ɓá lé, tò kdɔ kadɨ tokɨ pa ta lə Lubə kadɨ-si kete mɔkɨ. Ngà kɔsɨ kɨ́ sə̰i ɔsi ta lé ngərəngɨ ə sə̰i ya ooi rɔ-si kɨ dow-je kɨ́ ꞌtuwə kiskəm kɨ́ sartagangɨ kin al ngá lé, ɓá jḛ jꞌtəl-né kəm-ji rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al tin. ");
INSERT INTO mge_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Beɓa né kɨ́ ꞌƁaɓe un ndu dɔ-tɨ kadɨ jꞌra ə́n: “Ma̰ mꞌində-i kadɨ ꞌto londógɨ lə gin dow-je kɨ́ ꞌto jipɨ-je al. Kdɔ kadɨ ɔw kɨ̀ ta kajɨ njal ꞌtḛḛ-né ngangɨ dɔnangɨ-tɨ.”» ");
INSERT INTO mge_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ngà lokɨ dḛ kɨ́ ꞌto jipɨ-je al, dꞌoo ta kinlé, rɔ-dé nəl-dé adɨ ꞌpitɨ ta lə ꞌƁaɓe Lubə. Dḛ kɨ́ kiskəm kɨ́ sartagangɨ tò kdɔ ta lə-dé lé, ꞌtəl njékadmḛḛ-je. ");
INSERT INTO mge_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Beɓa ta lə ꞌƁaɓe sane kɨ̀ go dɔnangɨ lə-dé kin lay. ");
INSERT INTO mge_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ngà jipɨ-je ꞌsulə dené-je kɨ́ ꞌto jipɨ təl-je kɨ́ ꞌto dow-je kɨ́ boy-boy rəm, ꞌsulə dow-je kɨ́ boy-boy kɨ́ mḛḛ ɓebo-tɨ adɨ dꞌulə kəm Pol-je kɨ̀ Barnabasɨ ndoo, ɓá ꞌtubə-dé kɔgɨ dɔnangɨ-tɨ lə-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Beɓa Pol-je kɨ̀ Barnabasɨ ꞌtində kodɨ kɨ́ nja-dé-tɨ kɨ dɔ-dé-tɨ ə dꞌɔtɨ dꞌɔw ɓebo Ikoniyɔm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ngà njéndó né-je kɨ́ mḛḛ ɓebo Antiosɨ-tɨ lé, rɔ-dé nəl-dé n̰a̰ rəm, ɓá Ndil kɨ́ aa njay rusɨ mḛḛ-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol-je kɨ̀ Barnabasɨ dꞌɔw kəykəwna̰-tɨ lə jipɨ-je kɨ́ mḛḛ ɓebo Ikoniyɔm-tɨ tɔ. Dḛ ꞌndó dow-je né sar ya adɨ jipɨ-je kɨ̀ grɛkɨ-je kɨ́ ꞌtò nduy-nduy ya dꞌadɨ mḛḛ-dé Jeju. ");
INSERT INTO mge_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ngà dow-je kɨ́ ná̰-je dan jipɨ-je-tɨ kɨ́ ꞌto njémḛḛndə-je lé, ꞌsulə dow-je kɨ́ ꞌto jipɨ-je al kadɨ ꞌra njékadmḛḛ-je majɨ al. ");
INSERT INTO mge_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol-je kɨ̀ Barnabasɨ dꞌisɨ mḛḛ ɓebo Ikoniyɔ̰m-tɨ ndɔ asɨ ta-tɨ ɓəy. Dḛ dꞌində mḛḛ-dé dɔ ꞌƁaɓe-tɨ adɨ ꞌpa ta kɨ̀ mḛḛnda ka̰y. Beɓa ꞌƁaɓe adɨ-dé tɔ́gɨ adɨ ꞌra-né né-je kɨ́ tò ɓəl-ɓəl, kɨ̀ né-je kɨ́ tɔjɨ adɨ dow-je ꞌgə kɨ́ ramajɨ lə Lubə kɨ́ Pol-je kɨ̀ Barnabasɨ dꞌilə mbḛ-é lé, to ta kɨ́ tɔgrɔ-tɨ ya. ");
INSERT INTO mge_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Beɓa kosɨ dow-je kɨ́ mḛḛ ɓebo-tɨ ꞌgángɨ-na̰ lo joo: Dḛ kɨ́ ná̰-je dꞌa̰ go jipɨ-je-tɨ, ngà dḛ kɨ́ dan-tɨ-je dꞌa̰ go njékɔwkulə-je-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jipɨ-je kɨ̀ dow-je kɨ́ ꞌto jipɨ-je al, dꞌində ndi-dé natɨ kɨ̀ ꞌboy-je lə-dé, kdɔ kadɨ dꞌadɨ kɔ̰̀ Pol-je kɨ̀ Barnabasɨ rəm, kdɔ kadɨ ꞌtilə-dé kɨ̀ ər ꞌtɔl-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Rəmə ta-é usɨ mbi Pol-je-tɨ, adɨ dꞌa̰y dꞌɔw ꞌɓɔyɔ rɔ-dé ɓebo Listrə-tɨ, kɨ̀ ɓebo Dɛrbɨ-tɨ kɨ́ to ɓebo-je kɨ́ dɔnangɨ Likaoni-tɨ, kɨ̀ nganɓe-je kɨ́ gəə dɔ-dé. ");
INSERT INTO mge_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dꞌilə mbḛ Poyta kɨ́ Majɨ lo-je-tɨ kinlé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Dingəm káre kɨ́ njènjakoy isɨ mḛḛ ɓebo Listrə-tɨ nɔ̰ɔ̰. Ə to dingəm kɨ́ nja-é oy lo kojɨ-é-tɨ nṵ adɨ njiyə nja káre al. ");
INSERT INTO mge_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ḛ isɨ oo ta kɨ́ Pol isɨ pa. Lokɨ Pol oo-é gə́rə́rə́ lé, oo kɨ́ kadmḛḛ liə lé, asɨ kadɨ adɨ-é lapiya. ");
INSERT INTO mge_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ngá ɓá pa siə ta kɨ̀ ndi-é kɨ́ boy panè: «ꞌḬ taá, ꞌa̰ dɔ nja-i-tɨ njururu!» Rəmə dingəm lé ubə nangɨ ratɨ ya ḭ taá njiyə. ");
INSERT INTO mge_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lokɨ kosɨ dow-je dꞌoo né kɨ́ Pol ra kinlé rəmə, ꞌpa ta kɨ̀ ndi-dé kɨ́ boy kɨ̀ ta Likaoni ꞌpanè: «Magɨ-je ꞌtəl rɔ-dé dow-je-tɨ, dꞌur nangɨ dan-ji-tɨ!» ");
INSERT INTO mge_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dḛ ꞌɓa Barnabasɨ «Jəsɨ» ə ꞌɓa Pol «Ɛrmɛsɨ» kdɔ Pol ɓá to njèpata. ");
INSERT INTO mge_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Njègugné lə magɨ «Jəsɨ» kɨ́ to magɨ kɨ́ kəy liə tò tarəbɨ kɔw mḛḛ ɓebo-tɨ lé, ree kɨ̀ bɔbɨ mangɨ-je, kɨ̀ putɨ kagɨ-je takəy pole magɨ-tɨ lé. Beɓa dḛ kɨ̀ kosɨ dow-je ꞌndigɨ kilə məsɨ nangɨ kun-né ta Pol-je kɨ̀ Barnabasɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ngà lokɨ njékɔwkulə-je kɨ́ joo kin dꞌoo ta-é lé, ꞌgángɨ kubɨ-je kɨ́ rɔ-dé-tɨ ə dꞌa̰y dꞌur dan kosɨ dow-je-tɨ kɨ̀ kəə ta-dé-tɨ ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Kama̰-je! ꞌRai né kin bè kdɔ ri? Jḛ lé, jꞌto dow madɨ-si-je ya tɔ! Poyta kɨ́ Majɨ kɨ́ jꞌilə mbḛ-é jꞌadɨ-si lé, to ta lə kadɨ in̰əi magɨ-je kɨ́ kare bè kin kɔgɨ, ə ꞌreei kɨ rɔ Lubə-tɨ kɨ́ Njèkisɨ kəm, Njèra dɔra̰ kɨ̀ dɔnangɨ, kɨ̀ babo kɨ̀ né-je lay kɨ́ tò-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dɔgangɨ ɓal-je-tɨ kɨ́ dəə kete lé, ḛ in̰ə gin dow-je lay adɨ ná̰-ná̰ ya un rəbɨ liə-liə. ");
INSERT INTO mge_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bè ya kàrè, Lubə lé, in̰ə ta tɔjɨ-si rɔ-é mḛḛ ramajɨ-je-tɨ liə al: Ḛ adɨ ndi ḭ dɔra̰-tɨ ədɨ dɔnangɨ-tɨ nè, ə adɨ kandɨ né-je tḛḛ kɨ́ na̰y-é na̰y-é, ḛ adɨ-si nékuso rəm, ɓá adɨ rɔnəl rusɨ mḛḛ-si rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Lé njékɔwkulə-je ꞌpa-né ta-je kin bè ya kàrè, lo kadɨ dꞌɔgɨ dow-je lo kilə məsɨ nangɨ kun-né ta-dé lé, nga̰ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Go-tɨ gogɨ rəmə, jipɨ-je kɨ́ dꞌḭ ɓebo Ikoniyɔm-tɨ rəm, ɓá ɓebo Antiosɨ-tɨ kɨ́ dɔnangɨ Pisidi-tɨ ꞌree ꞌsulə dow-je, adɨ ꞌtilə Pol kɨ̀ ər, ə ꞌndɔr-é dꞌɔw dꞌilə-é gidɨ ɓebo-tɨ, adɨ dḛ ꞌgɨr tokɨ ḛ oy ngá. ");
INSERT INTO mge_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ngà lokɨ njéndó né-je ꞌkəw-na̰ kɨ́ dɔ-é-tɨ lé, ḛ ubə nangɨ ḭ taá təl ɔw mḛḛ ɓebo-tɨ gogɨ. Lo aa go-tɨ lé, dḛ kɨ̀ Barnabasɨ dꞌɔw ɓebo Dɛrbɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol-je kɨ̀ Barnabasɨ dꞌilə mbḛ Poyta kɨ́ Majɨ mḛḛ ɓebo Dɛrbɨ-tɨ, adɨ dow-je n̰a̰ ya ꞌtəl njéndó né-je. Beɓa dḛ ꞌtəl ꞌree ɓebo Antiosɨ kɨ́ dɔnangɨ Pisidi-tɨ, kɨ̀ ɓebo Listrə-tɨ, kɨ̀ ɓebo Ikoniyɔm-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Dḛ dꞌulə dingəm mḛḛ njéndó né-je-tɨ kadɨ dꞌuwə rɔ-dé nga̰ ə dꞌa̰ dɔ nja-dé-tɨ mḛḛ kadmḛḛ-tɨ lə-dé rəm ꞌpanè: «Jꞌa kindəi dan kɔ̰̀ kɨ́ n̰a̰ gangi ɓəy ɓá, jꞌa tḛḛi kɔ̰ɓe-tɨ lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dan njékəwna̰-je-tɨ kɨ́ rá-rá kɨ́ dꞌɔw-tɨ lé, dḛ mbətɨ ꞌngatɔ́gɨ-je dꞌadɨ-dé ə ꞌpa ta kɨ̀ Lubə kɨ̀ kɔgɨ rɔ nékuso kɨ̀ man ka̰y dꞌulə-dé-né mḛḛ ji ꞌƁaɓe-tɨ kɨ́ dꞌadɨ-é mḛḛ-dé lé. ");
INSERT INTO mge_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Beɓa dḛ dꞌində dɔnangɨ Pisidi ꞌgangɨ ꞌree dɔnangɨ Pampili-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Dḛ dꞌilə mbḛ Poyta kɨ́ Majɨ lə Lubə mḛḛ ɓebo Pɛrje-tɨ, ngá ɓá dꞌɔw mḛḛ ɓe-tɨ kɨ́ Atali. ");
INSERT INTO mge_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lo-é-tɨ kinlé, dḛ dꞌal mḛḛ bato-tɨ ꞌtəl dꞌɔw ɓebo Antiosɨ-tɨ gogɨ, lo-tɨ kɨ́ ndɔkɨ dꞌulə-dé mḛḛ ji Lubə-tɨ adɨ ramajɨ liə ra sə-dé adɨ ꞌtɔl-né ta kullə lə-dé lé. ");
INSERT INTO mge_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lokɨ ꞌree ꞌtḛḛ mḛḛ ɓebo Antiosɨ-tɨ lé, dḛ mbɔ̰ njékəwna̰-je ə dꞌɔr-dé poy né-je lay kɨ́ Lubə ra kɨ̀ takul-dé rəm, ɓá dꞌɔr-dé poy tarəbɨ kɨ́ Lubə tḛḛ adɨ dow-je kɨ́ ꞌto jipɨ-je al kàrè dꞌadɨ mḛḛ-dé lé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pol kɨ̀ Barnabasɨ dꞌisɨ nṵ dɔkaglo asɨ tatɨ kɨ̀ njéndó né-je. ");
INSERT INTO mge_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dingəm-je kɨ́ dan-tɨ-je dꞌḭ dɔnangɨ Jude-tɨ ꞌree mḛḛ ɓebo Antiosɨ-tɨ, ꞌndó né njékadmḛḛ-je ꞌpanè: «Kinə dꞌijə-si ganjangɨ kɨ́ go nékoɓe-tɨ lə Moiyijɨ al lé, a kaji nda̰ al.» ");
INSERT INTO mge_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ngà Pol-je kɨ̀ Barnabasɨ ndigɨ sə-dé al, adɨ najɨ-na̰ ta dɔ-tɨ n̰a̰ bè. Beɓa dꞌadɨ Pol-je kɨ̀ Barnabasɨ rəm, dow-je kɨ́ ná̰-je kɨ́ dan-dé-tɨ kɨ́ mḛḛ ɓe-tɨ kɨ́ Antiosɨ dꞌɔw ɓebo Jorijalḛm-tɨ kdɔ kində ta-é nɔ̰̀ njékɔwkulə-je-tɨ, kɨ̀ nɔ̰̀ ꞌngatɔ́gɨ-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Njékəwna̰-je kɨ́ ɓebo Antiosɨ-tɨ dꞌɔsɨ kutɨ-dé lo kɔw mba-tɨ lə-dé kinlé. Ta lə dow-je kɨ́ ꞌto jipɨ-je al, kɨ́ dꞌadɨ mḛḛ-dé lé, dḛ dꞌɔr poy-é taá-taá dꞌində-né dan ɓe-je kɨ́ dɔnangɨ Penisi-tɨ kɨ̀ dɔnangɨ Samari-tɨ ꞌgangɨ adɨ njékadmḛḛ-je lay kɨ́ dꞌoo ta-é lé, rɔ-dé nəl-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Lokɨ ꞌree tḛḛ ɓebo Jorijalḛm-tɨ lé, njékəwna̰-je, kɨ̀ njékɔwkulə-je, kɨ̀ ꞌngatɔ́gɨ-je dꞌuwə-dé kɨ rɔ-dé-tɨ adɨ dꞌɔr-dé poy né-je lay kɨ́ Lubə ra sə-dé lé. ");
INSERT INTO mge_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ngà rəmə dow-je kɨ́ dan-tɨ-je kɨ́ ꞌto njékun go né ndó lə Parisi-je kɨ́ dꞌadɨ mḛḛ-dé Jeju lé ꞌpanè: «Dow-je kɨ́ ꞌto jipɨ-je al, kɨ́ dꞌadɨ mḛḛ-dé lé, dꞌa kijə-dé ganjangɨ rəm, dꞌa kində dɔ-dé-tɨ kadɨ ꞌtəl rɔ-dé go ndukun-je-tɨ lə Moiyijɨ rəm ɓane.» ");
INSERT INTO mge_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Beɓa njékɔwkulə-je, kɨ̀ ꞌngatɔ́gɨ-je dꞌuwə dɔ-na̰ kdɔ koo ta-é. ");
INSERT INTO mge_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lokɨ dow-je ꞌnajɨ-na̰ ta dɔ-tɨ n̰a̰ lé, Piyər ḭ taá panè: «Ngankɔ̰-m-je, sə̰i ꞌgəi majɨ kɨ́ ma̰ lé Lubə mbətɨ-m dan-si-tɨ kete low kdɔ kadɨ mꞌilə mbḛ rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al, kdɔ kadɨ dꞌoo Poyta kɨ́ Majɨ ta-m-tɨ ə dꞌadɨ-né mḛḛ-dé Jeju tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Beɓa Lubə kɨ́ to njègə mḛḛ dow-je lé, ndigɨ sə-dé dɔ-tɨ adɨ ḛ adɨ-dé Ndil kɨ́ aa njay titɨ-na̰ kɨ́ ḛ adɨ-ji-né lé bè tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jə̰i sə-dé-je lé, Lubə ɔr kəm dow al; beɓa lokɨ dḛ dꞌadɨ mḛḛ-dé lé, ḛ togɨ mḛḛ-dé adɨ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kdɔ ri ə́ sə̰i ꞌna̰i Lubə wa? Nékutɨ kɨ́ ɔy kɨ́ ka-ji-je kàrè dꞌasɨ kutɨ al rəm, jə̰i kàrè jꞌasi kuti al rəm, ya ꞌndigi kindəi dɔ njéndó né-je-tɨ kdɔ ri wa? ");
INSERT INTO mge_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jə̰i lé, jꞌgəi majɨ kɨ́ tɔgrɔ-tɨ ya jꞌajɨ kɨ̀ takul ramajɨ lə ꞌƁaɓe Jeju. Dḛ kàrè, bè ya tɔ ə́ dꞌajɨ-né tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Lokɨ ḛ pa bè rəmə, dow-je lay ya dꞌisɨ dɔ-na̰-tɨ ndingɨ. ꞌYəl mbi-dé dꞌoo-né ta-je kɨ́ Pol-je kɨ̀ Barnabasɨ dꞌisɨ dꞌidə-dé sɔbɨ dɔ né-je kɨ́ tɔjɨ tɔ́gɨ Lubə, kɨ̀ né-je kɨ́ tò ɓəl-ɓəl kɨ́ Lubə ra kɨ̀ takul-dé dan dow-je-tɨ kɨ́ ꞌto jipɨ-je al lé. ");
INSERT INTO mge_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lokɨ Pol-je kɨ̀ Barnabasɨ ꞌpa ta lay rəmə, Jakɨ un ta ə panè: ");
INSERT INTO mge_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","«Ngankɔ̰-m-je, ꞌyəli mbi-si ooi-né ta lə-m! Kəm rəbɨ kɨ́ Lubə ra-né né lo kulə gin-é-tɨ rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al, ɓá ḛ mbətɨ-né dow-je dan-dé-tɨ kdɔ kadɨ ꞌto dow-je liə lé, Simɔ̰ un kutɨ-é ɔr berere-berere lay. ");
INSERT INTO mge_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta-je lə njépata-je kɨ́ ta Lubə-tɨ ɔw natɨ kɨ̀ ta kinlé, kdɔ ꞌndàngɨ mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: ");
INSERT INTO mge_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Go né-je-tɨ kinlé, ma̰ Lubə ya mꞌa təl ree ra kəykubɨ lə Dabidɨ kɨ́ jɔré nangɨ kin gogɨ, Lo-é-je kɨ́ tujɨ lé mꞌa təl ra gogɨ, Rəm mꞌa təl tɔsɨ taá gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kdɔ kadɨ ndəgɨ dow-je ꞌsangɨ nja ꞌƁaɓe rəm, ɓá gin dow-je lay kɨ́ ꞌto jipɨ-je al kɨ́ mꞌɓa-dé kadɨ ꞌto dow-je lə-m lé, dꞌa sangɨ nja-m tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ꞌƁaɓe Lubə kɨ́ njègə né-je liə low lə low-je nṵ ya sartagangɨ lé, ɓá pa bè.”» ");
INSERT INTO mge_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Gin-é kin ɓá, dow-je kɨ́ dan dow-je-tɨ kɨ́ to jipɨ-je al, kɨ́ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ə ꞌree rɔ Lubə-tɨ lé, ma̰ mꞌndigɨ kadɨ dow ində né kɨ́ ɔy kɨ́ rangɨ dɔ-dé-tɨ al ngá. ");
INSERT INTO mge_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ngà kadɨ tokɨ ndàngɨ mbete kidə-dé-né kadɨ dꞌuso da̰-je kɨ́ dow-je ꞌtɔl ꞌpole-né magɨ-je al rəm, da̰-je kɨ́ dꞌoy yo kuburu kàrè kadɨ dꞌuso al rəm, kadɨ dꞌuso məsɨ da̰ al rəm, ɓá kadɨ dꞌɔr rɔ-dé kɔgɨ mḛḛ kaya-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kdɔ Ndukun lə Moiyijɨ kinlé, low nṵ ya njéndó dow-je ndukun-je, dꞌisɨ mḛḛ ɓebo-tɨ kɨ́ rá-rá, adɨ ꞌndó dow-je kɨ̀ ndɔ taakoo-je lə jipɨ-je lay, mḛḛ kəykəwna̰-je-tɨ lə-dé.» ");
INSERT INTO mge_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Njékɔwkulə-je, kɨ̀ ꞌngatɔ́gɨ-je, kɨ̀ njékəwna̰-je lay ya dꞌun ndu-dé kdɔ kadɨ ꞌmbətɨ dow-je dan-dé-tɨ kadɨ dꞌulə-dé natɨ kɨ̀ Pol-je kɨ̀ Barnabasɨ mḛḛ ɓebo Antiosɨ-tɨ. Beɓa ꞌmbətɨ Judɨ kɨ́ ꞌɓa-é Barsabasɨ, kɨ̀ Silasɨ kɨ́ ꞌto dow-je kɨ́ njékadmḛḛ-je dꞌun ta-dé ya joo lay. ");
INSERT INTO mge_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ta kɨ́ ꞌndàngɨ mḛḛ mbete-tɨ dꞌadɨ-dé ji-dé-tɨ lé ə́n: «Jḛ njékɔwkulə-je, kɨ̀ ꞌngatɔ́gɨ-je, kɨ̀ njékadmḛḛ-je lay ya jꞌndàngɨ mbete kin jꞌadɨ-si sə̰i kɨ́ ꞌtoi jipɨ-je al kɨ́ ꞌtəli njékadmḛḛ-je kɨ́ isi mḛḛ ɓebo Antiosɨ-tɨ, kɨ́ dɔnangɨ Siri-tɨ, kɨ̀ dɔnangɨ Silisi-tɨ, jꞌra-si-né lapiya. ");
INSERT INTO mge_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jḛ jꞌoo poy dow-je kɨ́ dꞌḭ dan-ji-tɨ nè dꞌɔw ꞌpa ta ꞌtəl-né dɔ-si, ɓá dꞌulə-né ɓəl mḛḛ-si-tɨ rəm tɔ. Dowbé-je kinlé, to jḛ ɓá jꞌun ndu jꞌulə-dé-né al ya sar. ");
INSERT INTO mge_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Beɓa jḛ jꞌində ndi-ji natɨ lay, jꞌmbətɨ dingəm-je jꞌulə-dé-né rɔ-si-tɨ natɨ kɨ̀ Pol-je kɨ̀ Barnabasɨ kɨ́ ꞌto dow-je kɨ́ jꞌində-dé dan kəm-ji-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Dḛ lé ꞌto dow-je kɨ́ dꞌilə rɔ-dé kɔgɨ kdɔ ri ꞌƁaɓe lə-ji Jeju Kristɨ. ");
INSERT INTO mge_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jꞌadɨ Judɨ-je kɨ̀ Silasɨ dꞌɔw sə-dé natɨ, kdɔ kadɨ dḛ ya dꞌidə-si ta-je kɨ́ jꞌndàngɨ mḛḛ mbete-tɨ kinlé kɨ̀ ta-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kdɔtalə Ndil kɨ́ aa njay rəm, jḛ ya rəm lé, jꞌndigɨ kində né kɨ́ ɔy kɨ́ rangɨ dɔ-si-tɨ kore-né dɔ né-je kɨ́ tò kadɨ ꞌrai ya tá kin al ngá. Né-je kɨ́ tò kadɨ ꞌrai ya tá lé ə́n: ");
INSERT INTO mge_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sə̰i a kusoi da̰-je kɨ́ ꞌpole-né magɨ-je al rəm, a kusoi məsɨ da̰ al rəm, da̰ kɨ́ oy yo kubru kàrè a kusoi al rəm, ɓá sə̰i a rai kaya al rəm tɔ. Né-je kin ɓá, sə̰i a kɔri rɔ-si mḛḛ-é-tɨ kɔgɨ. Lapiya lə-si ə ndɔ kɨ́ rangɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dow-je kɨ́ ꞌmbətɨ-dé dꞌulə-dé lé, dꞌɔtɨ dꞌɔw. Lokɨ dꞌɔw ꞌtḛḛ mḛḛ ɓebo Antiosɨ-tɨ lé, ꞌɓa kosɨ njékadmḛḛ-je dꞌadɨ-dé mbete lé. ");
INSERT INTO mge_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lokɨ ꞌndó mbete-é dꞌadɨ kosɨ njékəwna̰-je lé, rɔ-dé nəl-dé n̰a̰ kdɔ ta dingəm kɨ́ dꞌulə mḛḛ-dé-tɨ mḛḛ mbete-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judɨ-je kɨ̀ Silasɨ kɨ́ ꞌto njépata-je kɨ́ ta Lubə-tɨ tɔ lé, ꞌpa ta-je n̰a̰-n̰a̰ dꞌulə-né dingəm mḛḛ njékadmḛḛ-je-tɨ rəm, ɓá ꞌmbusɨ-né nja-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Dḛ ꞌra ndɔ asɨ tatɨ lo-é-tɨ nɔ̰ɔ̰, ngá ɓá njékadmḛḛ-je dꞌin̰ə-dé kadɨ ꞌtəl kɨ̀ lapiya dꞌɔw rɔ njékulə-dé-je-tɨ lé gogɨ ");
INSERT INTO mge_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Bè ya kàrè, Silasɨ panè nꞌa kisɨ, adɨ təl isɨ nṵ. ");
INSERT INTO mge_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ngà Pol-je kɨ̀ Barnabasɨ dꞌisɨ mḛḛ ɓebo Antiosɨ-tɨ. Dꞌində rɔ-dé natɨ kɨ̀ dow-je kɨ́ rangɨ n̰a̰, ꞌndó dow-je ta lə ꞌƁaɓe rəm, ɓá dꞌilə mbḛ Poyta kɨ́ Majɨ liə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ndɔ-je kɨ́ rangɨ go-tɨ ngá ɓá Pol idə Barnabasɨ panè: «Adɨ jꞌtəl jꞌɔw gogɨ jꞌgɔ̰ njékadmḛḛ-je kɨ́ mḛḛ ɓebo-je-tɨ lay kɨ́ ndɔkɨ jꞌilə mbḛ ta lə ꞌƁaɓe-tɨ lé jꞌoo se dꞌisɨ ban ngá wa.» ");
INSERT INTO mge_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabasɨ ndigɨ kadɨ Ja̰ kɨ́ ri gajɨ-é lə Markɨ ɔw sə-dé natɨ, ");
INSERT INTO mge_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ngà Pol ndigɨ kadɨ ɔw sə-dé al, kdɔ ndɔkɨ kete ɔsɨ təl go-dé-tɨ dɔnangɨ Pampili-tɨ, adɨ dan-dé lo kullə-tɨ lə-dé al. ");
INSERT INTO mge_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Beɓa ndi-dé al-na̰ n̰a̰, adɨ ꞌgángɨ-na̰ lo joo. Barnabasɨ un Markɨ kəm-é-tɨ ə dꞌal mḛḛ bato-tɨ dꞌɔw kɨ dɔnangɨ Siprə-tɨ kɨ́ tò dan ba-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Rəmə Pol mbətɨ Silasɨ ə njékadmḛḛ-je ꞌdəjɨ kadɨ ramajɨ lə ꞌƁaɓe nà̰y sə-dé, ngá ɓá dꞌun rəbɨ dꞌɔw tɔ. ");
INSERT INTO mge_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Dḛ dꞌɔw dɔnangɨ Siri-tɨ, kɨ̀ dɔnangɨ Silisi-tɨ ꞌmbusɨ nja njékəwna̰-je dɔ kadmḛḛ-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ɔw tḛḛ mḛḛ ɓebo Dɛrbɨ-tɨ kɨ̀ ɓebo Listrə-tɨ. Mḛḛ ɓebo Listrə-tɨ lé, njèndó né káre kɨ́ ri-é lə Timote isɨ titɨ nɔ̰ɔ̰. Ḛ to ngon lə jipɨ madɨ kɨ́ dené kɨ́ təl njèkadmḛḛ, ngà bɔbɨ-é ɓá to grɛkɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Njékadmḛḛ-je kɨ́ dꞌisɨ ɓebo Listrə-tɨ kɨ̀ ɓebo Ikoniyɔm-tɨ ꞌpa ta liə majɨ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ndigɨ kadɨ Timote ɔw siə natɨ. Beɓa ḛ ijə-é ganjangɨ, kdɔtalə jipɨ-je dꞌisɨ dɔnangɨ-é-je-tɨ kinlé nɔ̰ɔ̰. Dḛ lay ya ꞌgə kɨ́ bɔbɨ Timote lé, to grɛkɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mḛḛ ɓebo-je kɨ́ Pol-je kɨ̀ Silasɨ dꞌɔw-tɨ lé, dḛ ꞌpa tó ndu njékɔwkulə-je kɨ̀ ꞌngatɔ́gɨ-je kɨ́ ɓebo Jorijalḛm-tɨ lé, dꞌadɨ dow-je dꞌoo, kdɔ kadɨ ꞌtəl rɔ-dé go-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Njékəwna̰-je dꞌuwə rɔ-dé nga̰ mḛḛ kadmḛḛ-tɨ lə-dé rəm, ɓá kɔr-dé usɨ dɔ madɨ-é-tɨ kɨ̀ ndɔ-é ndɔ-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lokɨ Ndil kɨ́ aa njay ɔgɨ-dé kadɨ ꞌpa ta lə Lubə dɔnangɨ Aji-tɨ lé, dḛ dꞌində dɔnangɨ Priji kɨ̀ dɔnangɨ Galati ꞌgangɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ngà lokɨ ꞌree ꞌtḛḛ ngɔsi kɨ̀ dɔnangɨ Misi lé, dḛ ꞌna̰ kadɨ dꞌɔw dɔnangɨ Bitini-tɨ, ngà Ndil Jeju adɨ-dé tarəbɨ al. ");
INSERT INTO mge_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Beɓa dḛ dꞌində dɔnangɨ Misi ꞌgangɨ dꞌɔw ɓebo Troasɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lo-é-tɨ kin ɓá, ndɔɔ rəmə, né ra Pol tokɨ nḭ bè, adɨ oo dow káre kɨ́ to dow kɨ́ dɔnangɨ Maseduwan-tɨ a̰ kɨ̀ nja-é taá ə nɔ̰ ta-é-tɨ panè: «ꞌRee dɔnangɨ Maseduwan-tɨ, ꞌree ra sə-ji!» ");
INSERT INTO mge_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Go né-tɨ kɨ́ ra Pol tokɨ nḭ bè lé, tajinatɨ nè ya, jḛ jꞌsangɨ kdɔ kɔw dɔnangɨ Maseduwan-tɨ, kdɔ jꞌgə majɨ kɨ́ Lubə ɓa-ji, kadɨ jꞌɔw jꞌilə mbḛ Poyta kɨ́ Majɨ jꞌadɨ dow-je kɨ́ dɔnangɨ-é-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jḛ jꞌal mḛḛ bato-tɨ mḛḛ ɓebo Troasɨ-tɨ, jꞌun njururu dɔ-ji kɨ Samotrasɨ kɨ́ to dɔnangɨ kɨ́ tò dan babo-tɨ, ə lo aa go-tɨ lé, jꞌɔw jꞌtḛḛ ɓebo Neapolisɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Jꞌḭ tin, jꞌɔw mḛḛ ɓebo Pilipɨ-tɨ kɨ́ to ɓebo kɨ́ dɔsa̰y kɨ́ dɔnangɨ Maseduwan-tɨ kɨ́ to ɓekɔ̰ lə dow-je kɨ́ Rɔm. Jḛ jꞌra ndɔ-je mḛḛ ɓebo-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Beɓa ndɔ taakoo-tɨ lə jipɨ-je lé, jꞌtḛḛ mḛḛ ɓebo-tɨ jꞌɔw ta ba-tɨ, kdɔ jꞌgɨr jꞌpanè lo-é-tɨ kinlé, jꞌa kingə lo kɨ́ jipɨ-je dꞌisɨ ꞌpa ta kɨ̀ Lubə titɨ-titɨ. Lokɨ jꞌɔw jꞌtḛḛ lé, jḛ jꞌisɨ nangɨ ə jꞌpa ta kɨ̀ dené-je kɨ́ ꞌkəw-na̰ lo-é-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kɨ́ káre dan dené-je-tɨ lé ri-é lə Lidi. Ə ḛ to njèɓəl Lubə. Ḛ to dené kɨ́ mḛḛ ɓebo Tiyatir-tɨ rəm, ɓá to njèra gatɨ kubɨ-je kɨ́ kər yəl-yəl kɨ́ là-é n̰a̰ rəm. Dené kinlé, isɨ oo ta kɨ́ Pol isɨ pa, ə ꞌƁaɓe adɨ kəm-é ijə dɔ-tɨ, adɨ ḛ yəl mbi-é majɨ oo-né ta kɨ́ Pol isɨ pa lé. ");
INSERT INTO mge_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Beɓa ꞌra-é batḛm kɨ̀ dḛ kɨ́ mḛḛ kəy-tɨ liə. Ngá ɓá ḛ ɓa-ji panè: «Kɨ́ ngɔsnè sə̰i ꞌgəi kɨ́ ma̰ mꞌadɨ mḛḛ-m ꞌƁaɓe ngá kinlé, ꞌreei isi mḛḛ kəy-tɨ lə-m.» Ḛ ra sar adɨ jꞌɔw siə. ");
INSERT INTO mge_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ndɔ káre bè, lokɨ jꞌisɨ jꞌɔw lo pa ta-tɨ kɨ̀ Lubə rəmə, ngonnjèkullə kɨ́ dené káre bè tilə kəm-ji. Ḛ lé ndil kɨ́ majɨ al isɨ mḛḛ-é-tɨ; ndil kɨ́ majɨ al lé, adɨ-é ndɔ̰ né, adɨ néndɔ̰ liə kinlé, ingə-né né n̰a̰ adɨ ꞌɓa-é-je. ");
INSERT INTO mge_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ḛ ndole go-ji, jḛ kɨ̀ Pol-je, ə tur kə go-ji-tɨ taá-taá panè: «Dingəm-je kinlé, ꞌto ngannjékullə-je lə Lubə kɨ́ njèkisɨ taá dɔra̰-tɨ nṵ! Dḛ dꞌilə mbḛ ta kɨ́ sɔbɨ dɔ rəbɨ kajɨ dꞌadɨ-si!» ");
INSERT INTO mge_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ngonnjèkullə kɨ́ dené lé, ra né kinlé bè-bè ya ndɔ n̰a̰. Beɓa ta tɔl ta-é-tɨ rəmə, wɔngɨ ra Pol adɨ təl ndángɨ ndil kɨ́ majɨ al lé panè: «Kɨ̀ ri Jeju Kristɨ, mꞌidə-i kadɨ ꞌtḛḛ mḛḛ-é-tɨ kɔgɨ!» Rəmə tajinatɨ nè ya, ndil kɨ́ majɨ al lé tḛḛ mḛḛ-é-tɨ kɔgɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ngà lokɨ dow-je kɨ́ ꞌto ꞌɓa ngonnjèkullə kɨ́ dené kinlé, dꞌoo kɨ́ nékingə né lə-dé goto ngá lé, dḛ dꞌuwə Pol-je kɨ̀ Silasɨ ꞌndɔr-dé dꞌɔw sə-dé pandangɨ lo-tɨ, nɔ̰̀ njékɔ̰ɓe-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dḛ dꞌɔw sə-dé nɔ̰̀ njégangta-je-tɨ ə dꞌidə-dé ꞌpanè: «Dingəm-je kinlé, ꞌjunglu mḛḛ ɓebo lə-ji n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Dḛ ꞌto jipɨ-je rəmə, ꞌndó-ji jḛ dow-je kɨ́ Rɔm, nékoɓe-je, kɨ́ tò kadɨ jḛ jꞌa ndigɨ dɔ-tɨ al, ɓá jꞌa təl rɔ-ji go-tɨ al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Beɓa kosɨ dow-je ꞌɓukɨ-na̰ dɔ-dé-tɨ dꞌuwə-dé, ə njégangta-je dꞌadɨ dow-je ꞌtɔr kubɨ kɨ́ rɔ Pol-je-tɨ kɨ̀ Silasɨ ngá ɓá, dꞌun ndu adɨ ꞌtində-dé. ");
INSERT INTO mge_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lokɨ ꞌtində-dé mbukɨ-mbukɨ lé, dꞌungɨ-dé dangay-tɨ ə dꞌidə njèngəm dangay-je kadɨ ngəm-dé majɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Beɓa lokɨ njèngəm dangay-je ingə ndu kin bè lé, ḛ ungɨ-dé mḛḛ kəy dangay-tɨ kɨ́ duni nṵ ə ilə-dé kagɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Beɓa dan lo bapɨ rəmə Pol-je kɨ̀ Silasɨ ꞌpa ta kɨ̀ Lubə rəm, dꞌusɨ pa ꞌtɔ́y-é-né adɨ dangay-je dꞌoo ndi-dé ndi-dé. ");
INSERT INTO mge_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tajinatɨ nè ya, dɔnangɨ yəy sar adɨ gin kəy dangay yəy ɓukɨ-ɓukɨ. Rəmə lo-é-tɨ nè ya takəy dangay-je tḛḛ lay, ɓá dangay-je lay ya sil-je kɨ́ ꞌtilə-dé lé, ga̰y wɔgrɔ-wɔgrɔ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lokɨ njèngəm ta dangay-je ḭ taá dɔ ɓi-tɨ rəmə, ḛ oo takəy-je tò tagra lé, ɔr kiyərɔ mḛḛ saba-é-tɨ kdɔ tɔl rɔ-é, kdɔ ḛ gɨr kɨ́ dangay-je dꞌa̰y-na̰. ");
INSERT INTO mge_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ngà Pol ilə bɔbɨ ndi-é nangɨ panè: «ꞌTujɨ rɔ-i al! Jḛ lay ya jꞌisɨ nè!» ");
INSERT INTO mge_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Beɓa njèngəm dangay-je lé, dəjɨ pər, a̰y ngɔdɨ ur kəy dangay-tɨ ə usɨ nangɨ nja Pol-je-tɨ kɨ̀ Silasɨ kɨ̀ rɔ dadɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Go-tɨ, adɨ-dé ꞌtḛḛ ndaa-tɨ ə dəjɨ-dé panè: «ꞌƁa-m-je, ri ɓá mꞌa ra kdɔ kingə-né kajɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Dḛ dꞌilə-é-tɨ ꞌpanè: «ꞌAdɨ mḛḛ-i ꞌƁaɓe Jeju ə a kajɨ, i kɨ̀ dḛ kɨ́ mḛḛ kəy-tɨ lə-i.» ");
INSERT INTO mge_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Beɓa dḛ ꞌpa ta lə ꞌƁaɓe dꞌadɨ-é rəm, dꞌadɨ dow-je kɨ́ mḛḛ kəy-tɨ liə lay tɔ. ");
INSERT INTO mge_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dɔkàdɨ̀-é-tɨ, ndɔɔ dan lo-tɨ nɔ̰ɔ̰ ya, njèngəm dangay-je lé, ɔr-dé ɔw togɨ ta dò-je lə-dé, ə tajinatɨ nè ya ꞌra-é batḛm natɨ kɨ̀ dow-je lay kɨ́ mḛḛ kəy-tɨ liə. ");
INSERT INTO mge_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Go-tɨ, ḛ ɔw kɨ̀ Pol-je kɨ̀ Silasɨ mḛḛ kəy-tɨ liə, ə adɨ-dé nékuso. Dingəm kinlé, dḛ kɨ̀ njénojɨ-je liə lay ya ꞌra rɔnəl n̰a̰, kdɔtalə kadɨ kɨ́ dꞌadɨ mḛḛ-dé Lubə. ");
INSERT INTO mge_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ngà lokɨ lo aa rəmə, njégangta-je lé, dꞌulə ngannjékullə-je lə-dé rɔ njèngəm dangay-je-tɨ ꞌpanè: «ꞌIn̰ə dingəm-je kinlé taá.» ");
INSERT INTO mge_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Njèngəm dangay-je lé, idə Pol panè: «Njégangta-je lé, dꞌidə-m kadɨ mꞌin̰ə-si taá ə́n ə́ ꞌtḛḛi, ə ɔwi kɨ̀ lapiya.» ");
INSERT INTO mge_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ngà Pol idə ngannjékullə-je lé panè: «Dḛ dꞌadɨ ꞌtində-ji mbukɨ-mbukɨ takəm kosɨ dow-je-tɨ rəm, ꞌgangɨ ta al ya dꞌungɨ-ji dangay-tɨ, jḛ kɨ́ jꞌto ngan njéɓe-je kɨ́ Rɔm, rəmə kɨ́ nè kin ꞌndigɨ kin̰ə-ji taá kɨ̀ go ngə̰y wa? A tò bè nda̰ al. Ɔwi idəi-dé, adɨ dḛ ya ꞌree dꞌin̰ə-ji taá.» ");
INSERT INTO mge_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Beɓa ngannjékullə-je lə njégangta-je lé, ꞌtəl dꞌɔw gogɨ dꞌidə-dé ta-je kinlé. Ngà lokɨ dḛ ꞌgə kɨ́ Pol-je kɨ̀ Silasɨ ꞌto ngan njéɓe-je kɨ́ Rɔm lé, ɓəl tɔl-dé. ");
INSERT INTO mge_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Beɓa dḛ ꞌtəl ꞌree nɔ̰̀-dé-tɨ, ꞌree ꞌdəjɨ-dé mḛḛ sɔl, ngá ɓá dꞌadɨ-dé ꞌtḛḛ dangay-tɨ, ə ꞌdəjɨ-dé kadɨ ꞌtḛḛ mḛḛ ɓebo-tɨ lé kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ngà lokɨ ꞌtḛḛ dangay-tɨ lé, dꞌɔw kəy lə Lidi, dꞌoo njékadmḛḛ-je, ə dꞌulə dingəm mḛḛ-dé-tɨ ngá ɓá dꞌḭ dꞌɔw lo lə-dé ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol-je kɨ̀ Silasɨ dꞌində dɔnangɨ Ampipolisɨ kɨ̀ dɔnangɨ Apoloni ꞌgangɨ ə ꞌtḛḛ mḛḛ ɓebo Tesalonikɨ-tɨ. Jipɨ-je dꞌɔw kɨ̀ kəykəwna̰ lə-dé lo-é-tɨ kinlé nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, titɨ kɨ́ ḛ ɔw-né kete-kete. Ndɔ taakoo-je kɨ́ ɔsɨ go-na̰ go-na̰ mutə lé, ḛ ɔw najɨ sə-dé ta dɔ ta-je-tɨ kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay. ");
INSERT INTO mge_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ḛ ɔr-dé mḛḛ ta kɨ́ tò mḛḛ mbete-tɨ kɨ́ aa njay tɔjɨ-dé-né kɨ́ Kristɨ lé, à kingə kɔ̰̀ sar koy-né, ə à tɔsɨ ndəl kində lo tḛḛ. Ḛ idə-dé panè: «Jeju kɨ́ mꞌpa ta liə mꞌadɨ-si lé, ḛ ya to Kristɨ lé.» ");
INSERT INTO mge_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jipɨ-je kɨ́ dan-tɨ-je kɨ́ mbunə̰-dé-tɨ ꞌree ꞌgə kɨ́ to ta kɨ́ tɔgrɔ-tɨ, adɨ dꞌində rɔ-dé natɨ kɨ̀ Pol-je kɨ̀ Silasɨ rəm, ɓá kosɨ grɛkɨ-je n̰a̰ kɨ́ ꞌto njèɓəl Lubə, ɓá dené-je kɨ́ ꞌto dow-je kɨ́ boy-boy kàrè dꞌində rɔ-dé natɨ sə-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Rəmə jangɨ ra jipɨ-je n̰a̰. Beɓa dḛ ꞌkəw dow-je kɨ́ dan-tɨ-je kɨ́ njékilə kɨ̀ kagɨ rəbɨ ꞌsulə-dé ꞌjunglu-né tagɨr lə dow mḛḛ ɓe-je. Dḛ dꞌɔw mḛḛ kəy-tɨ lə Jasɔ̰, ꞌsangɨ kadɨ dꞌuwə Pol-je kɨ̀ Silasɨ dꞌɔw sə-dé ndaa-tɨ nɔ̰̀ dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ngà lokɨ dḛ dꞌingə-dé al lé, ꞌndɔr Jasɔ̰ kɨ̀ njékadmḛḛ-je kɨ́ dan-tɨ-je dꞌɔw sə-dé nɔ̰̀ njégangta-je-tɨ kɨ̀ kəə ta-dé-tɨ taá-taá ꞌpanè: «Dingəm-je kin kɨ́ ꞌto njéjunglu kisɨ majɨ lə dow-je lo lay kɨ́ dɔnangɨ-tɨ nè lé, dḛ ꞌree tḛḛ nè ngá tin! ");
INSERT INTO mge_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Rəmə Jasɔ̰, uwə-dé kɨ rɔ-é-tɨ lé ya! Dow-je kin lay ya ꞌtəl rɔ-dé go ndukun-je-tɨ lə ngar Sejar al, kdɔtalə dḛ ꞌpanè ngar kɨ́ rangɨ isɨ nɔ̰ɔ̰, ri-é lə Jeju.» ");
INSERT INTO mge_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Lokɨ kosɨ dow-je, kɨ̀ njégangta-je dꞌoo ta-je kin bè lé, wɔngɨ ra-dé n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Beɓa dꞌadɨ Jasɔ̰ kɨ̀ njékadmḛḛ-je lé, dꞌugə, ngá ɓá dꞌin̰ə-dé dꞌadɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lokɨ kàdɨ̀ ur jipɨ ya rəmə, njékadmḛḛ-je dꞌadɨ Pol-je kɨ̀ Silasɨ dꞌɔw mḛḛ ɓebo Bere-tɨ. Lokɨ ꞌree ꞌtḛḛ ɓebo Bere-tɨ lé, dḛ dꞌɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beɓa dꞌingə dow-je kɨ́ tagɨr lə-dé majɨ, tɔy tagɨr lə jipɨ-je kɨ́ ɓebo Tesalonikɨ-tɨ. Dḛ ꞌyəl mbi-dé dꞌoo-né ta lə Lubə kɨ̀ rɔnəl n̰a̰ rəm, ndɔ-je lay-lay ya ꞌndər gin ta-je kɨ́ mḛḛ mbete-tɨ kɨ́ aa njay, kdɔ koo se ta-je kɨ́ dꞌidə-dé lé, to ta kɨ́ tɔgrɔ-tɨ ya wa? ");
INSERT INTO mge_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jipɨ-je n̰a̰ dan-dé-tɨ dꞌadɨ mḛḛ-dé Jeju; ɓá dené grɛkɨ-je kɨ́ ꞌto dow-je kɨ́ boy-boy, ɓá dingəm-je n̰a̰ ya dꞌadɨ mḛḛ-dé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ngà lokɨ jipɨ-je kɨ́ ɓebo Tesalonikɨ-tɨ, dꞌoo ta-é kɨ́ Pol isɨ ilə mbḛ ta lə Lubə mḛḛ ɓebo Bere-tɨ tɔ lé, dḛ dꞌɔw ꞌsulə kosɨ dow-je kɨ́ mḛḛ ɓebo-tɨ ꞌɓukɨ-dé dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ngà njékadmḛḛ-je dꞌadɨ Pol ḭ kalangɨ ɔw kɨ ta babo-tɨ. Ngà Silasɨ-je kɨ̀ Timote ɓá ꞌtəl dꞌisɨ mḛḛ ɓebo Bere-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dow-je kɨ́ dꞌadɨ-dé ꞌdan Pol lé, dꞌɔw siə njal ꞌtḛḛ siə mḛḛ ɓebo Atḛn-tɨ. Lokɨ dꞌɔw kɨ̀ təl kɨ gogɨ lé, Pol un ndu kadɨ dꞌadɨ Silasɨ-je-tɨ kɨ̀ Timote, ꞌree kalangɨ dꞌingə-nꞌḛ̀. ");
INSERT INTO mge_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lokɨ Pol isɨ ngəbɨ Silasɨ-je kɨ̀ Timote mḛḛ ɓebo Atḛn-tɨ ɓəy lé, mḛḛ-é ḭ puu kdɔtalə koo kɨ́ ḛ oo magɨ-je pələ́-pələ́ mḛḛ ɓebo-tɨ kinlé. ");
INSERT INTO mge_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ḛ ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je ɔjɨ ta kɨ̀ jipɨ-je rəm, kɨ̀ dow-je kɨ́ njéɓəl Lubə rəm, ɓá ndɔ-é ndɔ-é ya ḛ ɔw pandangɨ lo-tɨ ɔjɨ ta kɨ̀ dow-je lay kɨ́ dꞌisɨ dꞌingə-na̰ titɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Njénégə-je kɨ́ dan-tɨ-je kɨ́ ꞌto njékun go néndó lə Epikur, kɨ̀ njénégə-je kɨ́ ꞌɓa-dé Istoisi-je kàrè najɨ siə ta tɔ. Dḛ kɨ́ dan-tɨ-je ꞌpanè: «Njètidə ta kanlé, a̰ panè ri ɓan wa?» Dḛ kɨ́ madɨ-je ꞌpanè: «Ḛ ra rɔ-é kɨ njèkilə mbḛ kɨ́ sɔbɨ dɔ magɨ-je kɨ́ ꞌmba bè ɓan! Dḛ ꞌpa ta-je kin bè, kdɔ Pol a̰ ilə mbḛ Poyta kɨ́ Majɨ lə Jeju, ɓá a̰ ilə mbḛ tɔsɨ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Beɓa dꞌɔr Pol dꞌɔw siə lo-tɨ kɨ́ ɓa-é Areopajɨ kɨ́ to lo gangta kɨ́ boy rəmə ꞌpanè: «Néndó kɨ́ sigɨ kɨ́ ꞌa̰ ꞌndó dow-je kinlé, jꞌndigɨ gə se to ta kɨ́ dɔ ri-tɨ wa? ");
INSERT INTO mge_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kdɔtalə ta-je lə-i kɨ́ a̰ ꞌpa lé ɓa mbi-ji-tɨ gay. Beɓa jḛ jꞌndigɨ kadɨ ɔr-ji mḛḛ-é adɨ jꞌoo.» ");
INSERT INTO mge_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Dow-je kɨ́ ɓebo Atḛn-tɨ lay, kɨ̀ mba-je kɨ́ dꞌisɨ dan-dé-tɨ lé, dow ra né kɨ́ rangɨ al. Dḛ dꞌisɨ ká pa ta-tɨ, kɨ̀ ká koo ta-je-tɨ kɨ́ mba kɨ́ gogɨ nè kin ya ngá. ");
INSERT INTO mge_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol ḭ a̰ taá dan dow-je-tɨ lo-tɨ kɨ́ ꞌɓa-é Areopajɨ lé ə panè: «Sə̰i dow-je kɨ́ ɓebo Atḛn-tɨ, mꞌoo kɨ́ sə̰i lé, mḛḛ né-je-tɨ lay ya, pole magɨ-je uwə mḛḛ-si n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mꞌpa bè kdɔ lokɨ mꞌnjiyə mḛḛ ɓe-tɨ lə-si lé, mꞌoo né-je lay kɨ́ sə̰i ꞌpoli-dé rəm, ɓá mꞌɔw sar mꞌoo logugɨ né káre kɨ́ ꞌndàngɨ ta-tɨ ꞌpanè: “To ꞌlə magɨ kɨ́ dow gə-é al.” Magɨ kɨ́ sə̰i ꞌgəi-é al ya ꞌpoli-é kinlé, ḛ ɓá mꞌa̰ mꞌpa ta liə mꞌadɨ-si tin. ");
INSERT INTO mge_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Lubə kɨ́ njèra dɔnangɨ kɨ̀ né-je lay kɨ́ tò-tɨ, ḛ kɨ́ to ꞌƁa dɔra̰ kɨ̀ dɔnangɨ lé, isɨ mḛḛ kəy-tɨ kɨ́ dow ra kɨ̀ ji-é al. ");
INSERT INTO mge_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Lubə lé, ɔw ndoo kadɨ dow ra kullə adɨ-é al, kdɔtalə né kɨ́ nal-é goto. Ḛ ɓá to njèkadɨ kiskəm né-je lay rəm, to njèkadɨ-dé koo rəm, ɓá to njèkadɨ né-je lay rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ḛ adɨ gin dow-je lay kɨ́ dꞌisɨ dɔnangɨ-tɨ nè lay kinlé njirə-dé ḭ rɔ dow-tɨ kɨ́ káre-rè. Ḛ ɔjɨ dɔkaglo-je lə-dé, kɨ̀ rəbɨ nin lo kisɨ-je lə-dé kete low nṵ. ");
INSERT INTO mge_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Lubə ra né-je kinlé bè, kdɔ kadɨ dow-je ꞌsangɨ-né nja-é, ə kadɨ dɔmajɨ ə dꞌingə-é lo mam-tɨ kɨ́ dꞌisɨ ꞌmam-é. Kdɔ ná̰-ná̰ dan-ji-tɨ ya Lubə isɨ ngɔsi siə. ");
INSERT INTO mge_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kdɔ takul-é ɓá jḛ jꞌisɨ-né kɨ̀ dɔ-ji taá rəm, jꞌɔdɨ-né rɔ-ji rəm, jꞌto-né dow-je rəm tin.» «Ta kinlé njénɔ̰ pa-je kɨ́ ná̰-je kɨ́ dan-si-tɨ kàrè ꞌpa tɔ ꞌpanè: “Jḛ kàrè jꞌto ngan-é tɔ.”» ");
INSERT INTO mge_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Kdɔtalə to kɨ́ jə̰i jꞌtoi ngan lə Lubə lé, jḛ jꞌa gɨr kɨ́ Lubə lə-ji à titɨ-na̰ kɨ̀ magɨ lɔr əse magɨ là, əse magɨ ər kɨ́ kɔdɨ tɔ́l né-je ꞌra kɨ̀ tagɨr lə-dé əse kɨ̀ gosɨ ra né lə-dé kin al. ");
INSERT INTO mge_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ngà Lubə kɨ́ ndɔkɨ dow-je ꞌgə né al ə́ un kəm-é sa̰y kɔgɨ dɔ kullə ra-dé-je-tɨ kɨ́ majɨ al lé, ɓone ḛ isɨ ɓa dow-je lay, kɨ̀ lo-je lay kadɨ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kdɔ ḛ ɔr ndɔ káre kɨ́ à gangɨ-né ta kɨ́ njururu dɔ dow-je-tɨ kɨ́ dɔnangɨ-tɨ nè kɨ̀ takul dingəm kɨ́ ḛ mbətɨ-é. Tɔsɨ kɨ́ adɨ-é tɔsɨ ndəl ində lo tḛḛ lé, tɔjɨ adɨ dow-je lay ꞌgə majɨ kɨ́ Lubə à gangta kɨ̀ takul-é.» ");
INSERT INTO mge_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Lokɨ dḛ dꞌoo ta lə tɔsɨ ndəl kində lo tḛḛ lə dow-je kɨ́ Pol pa lé, dḛ kɨ́ dan-tɨ-je ꞌsɔkɨ-é, ə dḛ kɨ́ ná̰-je ꞌpanè: «Jḛ jꞌa koo ta kinlé, ta-i-tɨ ndɔ kɨ́ rangɨ-tɨ ɓəy.» ");
INSERT INTO mge_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Beɓa Pol in̰ə-dé ɔw. ");
INSERT INTO mge_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bè ya kàrè, dḛ kɨ́ ná̰-je dꞌində rɔ-dé natɨ kɨ̀ Pol, ə dḛ dꞌadɨ mḛḛ-dé Jeju rəm tɔ. Dan dḛ-tɨ kɨ́ dꞌadɨ mḛḛ-dé lé, kɨ́ káre to Denisɨ kɨ́ to dow káre dan njégangta-je-tɨ kɨ́ lo-tɨ kɨ́ ꞌɓa-é Areopajɨ lé rəm, ɓá dené káre kɨ́ ri-é lə Damarisɨ rəm, ɓá ndəgɨ dow-je kɨ́ rangɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Go-tɨ, Pol ḭ mḛḛ ɓebo Atḛn-tɨ ɔw mḛḛ ɓebo Kɔrḛntɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lo-é-tɨ kinlé, ḛ ingə dingəm káre kɨ́ to jipɨ kɨ́ ꞌɓa-é Akilasɨ. Ə to dow kɨ́ dɔnangɨ Pɔ̰-tɨ. Dḛ kɨ́ ne-é Prisil dꞌḭ dɔnangɨ Itali-tɨ ꞌree Kɔrḛntɨ ngɔsnè ya ɓəy, kdɔtalə dɔkaglo-é-tɨ kinlé ngar Klodɨ un ndu adɨ ꞌtubə jipɨ-je kɨ́ dꞌisɨ ɓebo Rɔm-tɨ kɔgɨ. Beɓa Pol ɔw ingə-dé ində rɔ-é natɨ sə-dé. ");
INSERT INTO mge_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Dḛ ꞌto kɔdɨ-je kɨ́ njéra kəykubɨ-je titɨ-na̰ kɨ̀ Pol bè tɔ. Beɓa Pol ɔw isɨ mḛḛ kəy-tɨ rɔ-dé-tɨ adɨ ꞌra kullə natɨ. ");
INSERT INTO mge_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ndɔ taakoo-je-tɨ lə jipɨ-je lay ya Pol ɔjɨ sə-dé ta mḛḛ kəykəwna̰-tɨ lə-dé. Ḛ sangɨ kadɨ nꞌuwə jipɨ-je, kɨ̀ grɛkɨ-je kɨ̀ ta. ");
INSERT INTO mge_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lokɨ Silasɨ-je kɨ̀ Timote dꞌḭ dɔnangɨ Maseduwan-tɨ ꞌree lé, Pol un rɔ-é ɓikti ində ta kullə ndó dow-je ta-tɨ lə Lubə, tɔjɨ-né jipɨ-je kadɨ ꞌgə kɨ́ Jeju lé, to Kristɨ lé ya. ");
INSERT INTO mge_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ngà lokɨ jipɨ-je ꞌpa siə takɔbɨ-je dꞌɔsɨ-é-né ngərəngɨ-ngərəngɨ lé, ḛ gəkɨ kodɨ kɨ́ kubɨ-je-tɨ kɨ́ rɔ-é-tɨ ə idə-dé panè: «Kinə ꞌtuji, rəmə ta məsɨ-si tò dɔ-si sə̰i-tɨ ya! Ma̰ mꞌɔr ta dɔ-m-tɨ ngá. Kḭ nè kɔw kɨ kete kinlé, mꞌa təl kəm-m kɨ rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al yó ngá.» ");
INSERT INTO mge_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Go-tɨ, Pol ḭ lo-é-tɨ tin, ɔw isɨ ɓe lə dingəm káre kɨ́ ri-é lə Titiyusɨ Justusɨ. Ḛ to dow kɨ́ njèɓəl Lubə ə kəy liə tò mbɔ́ kəykəwna̰-tɨ lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ə Krispusɨ kɨ́ to njèkun dɔ kəykəwna̰ lə jipɨ-je kɨ̀ dow-je kɨ́ mḛḛ kəy-tɨ liə lay, dꞌadɨ mḛḛ-dé ꞌƁaɓe. Dow-je kɨ́ ɓebo Kɔrḛntɨ-tɨ n̰a̰ kɨ́ dꞌoo ta lə Pol lé, dꞌadɨ mḛḛ-dé ꞌƁaɓe tɔ, adɨ ꞌra-dé batḛm. ");
INSERT INTO mge_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ndɔ káre bè, ndɔɔ ɓá né ra Pol tokɨ nḭ bè rəmə, ꞌƁaɓe pa siə ta panè: «ꞌƁəl al, ꞌpa ta par-par, ɓɨ ꞌoo rɔ-i al. ");
INSERT INTO mge_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kdɔtalə ma̰ ꞌƁaɓe ya mꞌa̰ sə-i natɨ. Dow kɨ́ à kasɨ kuwə-i kdɔ ra-i majɨ al ya goto. Kdɔ mꞌɔw kɨ̀ dow-je n̰a̰ mḛḛ ɓebo-tɨ kin.» ");
INSERT INTO mge_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pol isɨ mḛḛ ɓe-tɨ kɨ́ Kɔrḛntɨ, ndó dow-je ta lə Lubə ɓal káre kɨ̀ na̰y mɛkḛ. ");
INSERT INTO mge_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dɔkaglo-tɨ kɨ́ Galiɔ̰ to-né gubərnər dɔnangɨ Akay-tɨ lé, ta jipɨ-je asɨ-na̰ adɨ dꞌuwə Pol dꞌɔw siə logangta-tɨ ");
INSERT INTO mge_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ɓá ꞌpanè: «Dingəm kanlé sangɨ kadɨ dow-je ꞌtəl dꞌɔsɨ dɔ-dé nangɨ nɔ̰̀ Lubə-tɨ kɨ̀ go rəbɨ kɨ́ rangɨ kɨ́ ɔw go-na̰-tɨ kɨ̀ ndukun al.» ");
INSERT INTO mge_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ngà lokɨ Pol ɔw kdɔ kun ta pa lé, Galiɔ̰ idə jipɨ-je panè: «Kinə to ta tɔl dow əse ta lə né ra kɨ́ njururu al rəmə, mꞌa yəl mbi-m kdɔ koo-né ta lə-si sə̰i jipɨ-je lé berere-berere, titɨ kɨ́ tò kadɨ mꞌra-né ya. ");
INSERT INTO mge_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ngà kinə to tanajɨ kɨ́ dɔ ta-je-tɨ madɨ, kɨ̀ dɔ ri-je-tɨ, kɨ̀ dɔ ndukun-je-tɨ lə-si kɨ́ sɔbɨ dɔ-si rəmə, to ta lə-si sə̰i ya. Ma̰ mꞌndigɨ gangta dɔ-tɨ al.» ");
INSERT INTO mge_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Beɓa ḛ tubə-dé logangta-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Rəmə dḛ lay ꞌɓukɨ-na̰ dɔ Sostḛn-tɨ kɨ́ njèkun dɔ kəykəwna̰ lə jipɨ-je lé, dꞌuwə-é ꞌtində-é logangta-tɨ lé ya, ngà Galiɔ̰ lé adɨ usɨ-é-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Go né-je-tɨ kinlé, Pol isɨ ɓebo Kɔrḛntɨ-tɨ ndɔ-je asɨ tatɨ ya ɓəy, ɓá ḛ in̰ə njékadmḛḛ-je ə adɨ Prisil-je kɨ̀ Akilasɨ dꞌal siə mḛḛ bato-tɨ kdɔ kadɨ dꞌɔw dɔnangɨ Siri-tɨ. Lokɨ ꞌtḛḛ Sankré-tɨ rəmə, Pol ndisə dɔ-é, kdɔtalə ḛ un mindɨ-é adɨ Lubə dɔ né-tɨ madɨ. ");
INSERT INTO mge_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Lokɨ dꞌɔw ꞌtḛḛ ɓebo Epɛjɨ-tɨ lé, Pol in̰ə madkullə-je liə, ɔw kəykəwna̰-tɨ lə jipɨ-je ɔjɨ sə-dé ta. ");
INSERT INTO mge_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Dḛ dəjɨ-é kadɨ isɨ sə-dé ndɔ n̰a̰ ɓəy. Ngà ḛ ndigɨ al. ");
INSERT INTO mge_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lokɨ ɔw kɨ̀ kin̰ə-dé lé, idə-dé panè: «Ra na̰y kɨ́ gogɨ rangɨ-tɨ lé, lé ri-ri kàrè mꞌa ra ɓebo Jorijalḛm-tɨ. Kinə Lubə ndigɨ rəmə, mꞌa təl ree rɔ-si-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Beɓa ḛ ḭ mḛḛ ɓebo Epɛjɨ-tɨ ɔw Sejare kɨ̀ bato. Lokɨ Pol ur nangɨ mḛḛ ɓebo Sejare-tɨ lé, ḛ ɔw ra lapiya njékəwna̰-je, ngá ɓá ɔtɨ ɔw mḛḛ ɓebo Antiosɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol ra ndɔ asɨ tatɨ nṵ ɓəy ɓá ḛ təl ɔw gogɨ. Ḛ ɔw dɔnangɨ Galati-tɨ, kɨ̀ dɔnangɨ Priji-tɨ mbusɨ nja njéndó né-je lay. ");
INSERT INTO mge_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jipɨ káre bè ri-é lə Apolosɨ ə to dow kɨ́ mḛḛ ɓebo Alegjandri-tɨ ɓá ree mḛḛ ɓebo Epɛjɨ-tɨ. Ḛ to dow kɨ́ ɔw kɨ̀ gosɨ pa ta rəm, gə mbete kɨ́ aa njay majɨ n̰a̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ə to dow kɨ́ ꞌndó-é rəbɨ lə ꞌƁaɓe majɨ, ḛ ilə mbḛ Poyta kɨ́ Majɨ rəm, ḛ ndó dow-je ta lə Jeju kɨ̀ gangɨ-é berere-berere kɨ̀ rɔ tungə-é pilingɨ rəm, ya ngà batḛm lə Ja̰ ya par ɓá ḛ gə. ");
INSERT INTO mge_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ḛ ulə gin pa ta lə Lubə kɨ̀ mḛḛ kɨ́ ndaka̰y mḛḛ kəykəwna̰-tɨ lə jipɨ-je. Lokɨ Prisil-je kɨ̀ Akilasɨ dꞌoo ta liə kɨ̀ mbi-dé lé, dḛ ꞌɓa-é kɨ rɔ-dé-tɨ dꞌɔr-é gin ta lə Lubə majɨ berere-berere. ");
INSERT INTO mge_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Lokɨ ḛ ndigɨ kɔw dɔnangɨ Akay-tɨ lé, njékadmḛḛ-je dꞌulə dingəm mḛḛ-é-tɨ kadɨ-é ɔw, ɓá ꞌndàngɨ mbete dꞌulə-né dꞌadɨ njéndó né-je kɨ́ dɔnangɨ Akay-tɨ lé, kdɔ kadɨ dꞌuwə-é kɨ rɔ-dé-tɨ majɨ. Lokɨ ḛ ree tḛḛ lé, ḛ təl njéra kullə kɨ́ majɨ rɔ njékadmḛḛ-je-tɨ, kɨ̀ takul ramajɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Beɓa ḛ pa ta kɨ̀ jipɨ-je ndaa-tɨ rəsɨ kɨ̀ ta-je kɨ́ dum najɨ. Ḛ tɔjɨ-dé mḛḛ mbete-tɨ kɨ́ aa njay adɨ ꞌgə kɨ́ Jeju lé, to Kristɨ. ");
INSERT INTO mge_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lokɨ Apolosɨ nà̰y mḛḛ ɓebo Kɔrḛntɨ-tɨ lé, Pol ində dan ɓe-je kɨ́ dɔ mbal-tɨ kɨ́ dɔnangɨ Aji-tɨ gangɨ ree mḛḛ ɓebo Epɛjɨ-tɨ. Ḛ ree ɓá ingə njéndó né-je kɨ́ dan-tɨ-je nɔ̰ɔ̰ ");
INSERT INTO mge_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","rəmə, dəjɨ-dé panè: «Lokɨ sə̰i adi mḛḛ-si Jeju lé, se sə̰i ingəi Ndil kɨ́ aa njay ya wa?» Dḛ dꞌidə-é panè: «Ta lə Ndil kɨ́ aa njay ya kàrè dow pa adɨ jꞌoo nja káre al.» ");
INSERT INTO mge_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ngá ɓá Pol təl dəjɨ-dé panè: «Ngà se batḛm kɨ́ ban ɓá sə̰i ꞌrai wa?» Dḛ ꞌpanè: «Batḛm lə Ja̰ ɓá jḛ jꞌra.» ");
INSERT INTO mge_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Beɓa Pol idə-dé panè: «Batḛm kɨ́ Ja̰ ra dow-je lé, to batḛm kɨ́ tɔjɨ kin̰ə panjiyə-je kɨ́ majɨ al kɔgɨ. Ja̰ idə dow-je kadɨ dꞌadɨ mḛḛ-dé dow kɨ́ à ree go-nꞌḛ̀-tɨ, adɨ to Jeju.» ");
INSERT INTO mge_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lokɨ dꞌoo ta-je kɨ́ Pol pa kin bè rəmə, dꞌadɨ ꞌra-dé batḛm kɨ̀ ri ꞌƁaɓe Jeju. ");
INSERT INTO mge_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ngá ɓá Pol lé ində ji-é dɔ-dé-tɨ ə Ndil kɨ́ aa njay ree dɔ-dé-tɨ adɨ ꞌpa ta kɨ̀ ndɔ̰ ta lə dow-je kɨ́ rangɨ rəm, ꞌpa ta-je kɨ́ ta Lubə-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Dḛ lay dꞌa kasɨ dingəm-je dɔgɨ gidɨ-é joo je bè. ");
INSERT INTO mge_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Go-tɨ, Pol ɔw mḛḛ kəykəwna̰-tɨ lə jipɨ-je lé, ḛ pa ta kɨ̀ mḛḛnda ka̰y. Pol ɔjɨ sə-dé ta na̰y mutə, dɔ kɔ̰ɓe-tɨ lə Lubə. Ḛ sangɨ kɨ̀ rɔ tungə-é kdɔ kadɨ dow-je ꞌtaa ta liə. ");
INSERT INTO mge_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ngà dḛ kɨ́ dan-tɨ-je kɨ́ ꞌto njémḛḛnga̰-je, kɨ̀ njémḛḛndə-je lé, ꞌpa ta kɨ́ majɨ al dɔ ta-tɨ «lə ꞌƁaɓe» dan kosɨ dow-je-tɨ. Beɓa Pol in̰ə-dé, ə ɔr njéndó né-je ɔw sə-dé ngərəngɨ, ɔw ndó-dé né kɨ̀ ndɔ-é ndɔ-é mḛḛ kəy ndó né-tɨ lə Tiranusɨ. ");
INSERT INTO mge_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol ra ɓal joo lo-é-tɨ nɔ̰ɔ̰. Ḛ ndó dow-je né mbing, adɨ dow-je kɨ́ dꞌisɨ dɔnangɨ Aji-tɨ, kɨ́ ꞌto jipɨ-je kɨ̀ grɛkɨ-je lay ya dꞌoo ta lə ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Lubə un Pol ra-né nékɔjɨ-je kɨ́ tò ɓəl-ɓəl, ");
INSERT INTO mge_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ya adɨ takubɨ-je əse mindil-je kɨ́ ɔdɨ rɔ-é kàrè, dow-je dꞌɔw ꞌlabɨ dɔ njémɔ̰y-je-tɨ, rəmə njémɔ̰y-je dꞌingə lapiya rəm, ɓá ndil-je kɨ́ majɨ al ꞌtḛḛ mḛḛ-dé-tɨ kɔgɨ rəm. ");
INSERT INTO mge_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jipɨ-je madɨ dꞌɔw kɨ̀ ɓe-ɓe kdɔ tubə ndil-je kɨ́ majɨ al dɔ dow-je-tɨ. Dḛ ꞌna̰ kadɨ ꞌtubə ndil-je kɨ́ majɨ al dɔ dow-je-tɨ kɨ̀ ri ꞌƁaɓe Jeju tɔ. Dḛ ꞌpanè: «Kɨ̀ ri Jeju kɨ́ Pol ilə mbḛ ta liə kinlé, mꞌpanè ꞌtḛḛi kɔgɨ!» ");
INSERT INTO mge_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Dingəm-je kɨ́ njéra né kinlé dḛ siri ə ꞌto ngan lə Seba kɨ́ to jipɨ rəm, to kɨ́ káre dan njékun dɔ njégugné-je-tɨ lə Lubə rəm. ");
INSERT INTO mge_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ndɔ káre bè, ndil kɨ́ majɨ al idə-dé panè: «Ma̰ mꞌgə Jeju rəm, ɓá né kɨ́ Pol ꞌto kàrè mꞌgə rəm; ngà sə̰i, ꞌtoi ná̰-je wa?» ");
INSERT INTO mge_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ngá ɓá dingəm kɨ́ ndil kɨ́ majɨ al isɨ mḛḛ-é-tɨ lé, al ur dɔ-dé-tɨ taa tɔ́gɨ-dé lay ə ra-dé majɨ al mbing adɨ ꞌtḛḛ mḛḛ kəy-tɨ kɨ̀ dò-je rɔ-dé-tɨ pələ́-pələ́, dꞌa̰y-na̰ kɨ̀ kutɨ-dé dum. ");
INSERT INTO mge_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Né kɨ́ ra né kinlé, dow-je kɨ́ mḛḛ ɓebo Epɛjɨ-tɨ, jipɨ-je kɨ̀ grɛkɨ-je lay ya dꞌoo ta-é. Dḛ lay ya ɓəl ində bandɨ-dé gangɨ rəm, dow-je dꞌɔsɨ gajɨ ꞌƁaɓe Jeju rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Dow-je n̰a̰ kɨ́ dan-dé-tɨ kɨ́ dꞌadɨ mḛḛ-dé lé, ꞌree ꞌpa ta rəsɨ-rəsɨ dꞌɔr-né man dɔ kullə ra-dé-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Beɓa mbəli-je n̰a̰ ꞌree kɨ̀ mbete ra mbəli-je lə-dé dꞌulə dɔ-na̰-tɨ ə ꞌró pər kɔgɨ takəm dow-je-tɨ lay. Dow-je ꞌtidə kɔr là mbete-je lé, ə à kasɨ là kullə kɨ́ dow ra ɓal n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Beɓa tɔ́gɨ lə ꞌƁaɓe ra adɨ ta liə nga̰ njim ɔw-né kɨ kete-kete. ");
INSERT INTO mge_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Go né-je-tɨ kɨ́ ra né kinlé, Pol ɔjɨ kadɨ nꞌində dɔnangɨ Maseduwan kɨ̀ dɔnangɨ Akay nꞌgangɨ nꞌɔw mḛḛ ɓebo Jorijalḛm-tɨ. Ḛ panè: «Lokɨ mꞌɔw mꞌtḛḛ mḛḛ ɓebo Jorijalḛm-tɨ lé, mꞌa kɔw koo mḛḛ ɓebo Rɔm tɔ ɓane.» ");
INSERT INTO mge_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ḛ ulə njéra siə kullə-je joo adɨ to Timote-je kɨ̀ Erastɨ, adɨ dꞌɔw dɔnangɨ Maseduwan-tɨ, ngà ḛ ɓá təl isɨ dɔnangɨ Aji-tɨ mbɔr ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dɔkaglo-é-tɨ kinlé, ta kɨ́ boy n̰a̰ ya usɨ mḛḛ ɓebo Epɛjɨ-tɨ sɔbɨ dɔ ta lə ꞌƁaɓe. ");
INSERT INTO mge_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kdɔ dingəm káre isɨ nɔ̰ɔ̰ ri-é lə Demetriyusɨ. Ḛ to njèlḛ ꞌningə́-je kɨ̀ ngama̰-je. Ḛ lḛ ngan kəy-je adɨ titɨ-na̰ kɨ̀ kəy pole magɨ kɨ́ dené kɨ́ ri-é lə Artemisɨ, adɨ kɔdɨ-je liə dꞌingə-né né n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Beɓa Demetriyusɨ ɓa kɔdɨ-je liə rəm, ɓa kɔdɨ-je kɨ́ rangɨ kɨ́ njéra ga̰ kullə liə lé idə-dé panè: «Sə̰i lé, lay lə-si ya ꞌgəi majɨ kɨ́ jə̰i lé, kullə lə-ji kin ya ɓá jꞌisi jꞌingəi-né né ya al wa? ");
INSERT INTO mge_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ə né-je kɨ́ isɨ ra né lé, ooi ta-é kɨ̀ mbi-si rəm, ooi kɨ̀ kəm-si rəm. Pol kɨ́ dowbé kinlé, panè: Magɨ-je kɨ́ dow-je ꞌra kɨ̀ ji-dé lé, to magɨ-je kɨ́ tɔgrɔ-tɨ al. Ḛ pa ta təl-né dɔ dow-je, adɨ kosɨ dow-je kɨ́ ꞌtò nduy-nduy ya ꞌtaa ta liə. Né kinlé ḛ ra mḛḛ ɓebo Epɛjɨ-tɨ nè par al, ngà nà̰y ndḛ bè kadɨ un dɔnangɨ Aji ya lay. ");
INSERT INTO mge_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","To né kɨ́ à tujɨ kullə lə-ji jə̰i ya par al, ngà à ra kadɨ kəy magɨ Artemisɨ kɨ́ to magɨ kɨ́ dené kɨ́ boy kinlé à təl né kɨ́ kɔgɨ kare rəm, ɓá à tujɨ riɓa liə ḛ kɨ́ to magɨ kɨ́ dow-je lay kɨ́ dɔnangɨ Aji-tɨ, kɨ̀ dow-je lay kɨ́ dɔnangɨ-tɨ nè dꞌisɨ pole-é lé!» ");
INSERT INTO mge_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lokɨ dow-je dꞌoo ta-je kin bè lé, wɔngɨ ra-dé n̰a̰ adɨ ꞌtur kəə mbitɨ-mbitɨ ꞌpanè: «Artemisɨ, magɨ lə dow-je kɨ́ ɓebo Epɛjɨ-tɨ ya to magɨ kɨ́ boy!» ");
INSERT INTO mge_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mḛḛ ɓebo-tɨ lay ya dow-je dꞌɔw dɔ-na̰-tɨ wúr-wùr ə dꞌungɨ-na̰ dɔ Gayusɨ-je-tɨ kɨ̀ Aristarkɨ kɨ́ ꞌto dow-je kɨ́ dɔnangɨ Maseduwan-tɨ, ꞌndɔr-dé dꞌɔw sə-dé kɨ mḛḛ kəy ra ndam-je-tɨ. Gayusɨ-je kɨ̀ Aristarkɨ lé ꞌto madkullə-je lə Pol. ");
INSERT INTO mge_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol lé, ndigɨ kadɨ nꞌɔw dan kosɨ dow-je-tɨ ya tá, ngà njéndó né-je ɓá dꞌɔgɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nam Pol-je madɨ kɨ́ ꞌto dow-je kɨ́ boy-boy kàrè dꞌulə kulə dꞌidə-é, ꞌra-é kɔgri kadɨ ɔw kəy ra ndam-tɨ lé al. ");
INSERT INTO mge_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kosɨ dow-je lay ya dꞌilə dɔ-na̰-tɨ rututu. Dow-je kɨ́ dan-tɨ-je ꞌtur kɔɔl kdɔ né kɨ́ bè kin, ngà dḛ kɨ́ ná̰-je rəmə ꞌtur kɔɔl kdɔ né kɨ́ bè kin tɔ. Ə dow-je n̰a̰ dan-dé-tɨ tɔ rəmə, né kɨ́ ꞌkəw-né-na̰ lé ya kàrè dḛ ꞌgə al rəm. ");
INSERT INTO mge_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dow-je madɨ kɨ́ dan kosɨ dow-je-tɨ dꞌɔr gin ta lé dꞌadɨ Alegjandrə oo. Alegjandrə lé, jipɨ-je dꞌɔsɨ-é kɨ kete nɔ̰̀ dow-je-tɨ. Ḛ yəkɨ ji-é ta-dé-tɨ ə ndigɨ kadɨ nꞌpa ta nꞌɔr-né ta dɔ-nꞌḛ̀-tɨ nɔ̰̀ kosɨ dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ngà lokɨ dow-je ꞌgə kɨ́ Alegjandrə to jipɨ lé, dḛ lay ya ꞌtur kɔɔl boy-boy kɨ̀ ndi-dé kɨ́ káre ya à kasɨ né kɨ́ kàdɨ̀ joo je bè ꞌpanè: «Artemisɨ, magɨ lə dow-je kɨ́ Epɛjɨ ya to magɨ kɨ́ boy!» ");
INSERT INTO mge_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ngà njèndàngɨ mbete lə dow mḛḛ ɓe-je gɔr dow-je, adɨ lo tò ndingɨ ngá ɓá ḛ panè: «Sə̰i dow-je kɨ́ ɓebo Epɛjɨ-tɨ, dow-je lay ya ꞌgə kɨ́ ɓebo Epɛjɨ ɓá to lo ngəm kəy pole magɨ kɨ́ dené kɨ́ boy kɨ́ ꞌɓa-é Artemisɨ rəm, ḛ ya to lo ngəm né kɨ́ to takəm-é kɨ́ ḭ dɔra̰-tɨ ree nangɨ nè rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Dow kɨ́ à najɨ ya bè goto. Beɓa kadɨ ori mḛḛ-si, ɓɨ ꞌrai né kɨ nɔ̰ɔ̰ bè al. ");
INSERT INTO mge_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Dingəm-je kɨ́ sə̰i uwəi-dé ꞌreei sə-dé nè kinlé, né káre ya kàrè dḛ ꞌtujɨ mḛḛ kəy pole magɨ-tɨ al rəm, ɓá ꞌpa ta kɔbɨ dɔ magɨ-tɨ lə-ji kɨ́ dené lé al rəm. ");
INSERT INTO mge_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kinə Demetriyusɨ kɨ̀ kɔdɨ-je kɨ́ dꞌore kàdɨ̀-é lé, ꞌndigɨ ra ta kɨ̀ dow madɨ rəmə, ndɔ gangta to nɔ̰ɔ̰ rəm, ɓá njégangta-je kàrè dꞌisɨ nɔ̰ɔ̰ rəm; kadɨ ꞌra mbete səkɨ dꞌɔw ꞌsəkɨ-né dowbé! ");
INSERT INTO mge_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ngà kinə ta lə-si kɨ́ rangɨ ya tò nɔ̰ɔ̰ rəmə, dꞌa ra ta-é ndɔ gangɨ ta-tɨ nɔ̰̀ kosɨ dow-je-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bè al rəmə, né kɨ́ ra né ɓone kinlé, dow-je kɨ́ Rɔm dꞌa kḭ kilə-né ta dɔ-ji-tɨ kdɔ ɓa-ji njédɔnga̰-je, rəmə ta kɨ́ jꞌa pai dɔ kəwna̰-tɨ lə-ji kin, kdɔ kɔri-né ta dɔ-ji-tɨ ya goto.» Go ta-je-tɨ kinlé, ḛ tubə kosɨ dow-je adɨ dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lokɨ gin kɔw dɔ-na̰-tɨ wúr-wùr kin gangɨ lé, Pol kəw njéndó né-je ulə dingəm mḛḛ-dé-tɨ, ɓá ra-dé lapiya ə ɔtɨ ɔw dɔnangɨ Maseduwan-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ḛ ɔw kɨ̀ lo-lo dɔnangɨ Maseduwan-tɨ pa ta-je n̰a̰-n̰a̰ adɨ njékadmḛḛ-je ulə-né dingəm mḛḛ-dé-tɨ, ɓəy ɓá ḛ ɔw dɔnangɨ Grɛkɨ-tɨ ");
INSERT INTO mge_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","isɨ-tɨ na̰y mutə. Lokɨ isɨ ɔw kdɔ kal mḛḛ bato-tɨ kɔw dɔnangɨ Siri-tɨ rəmə, oo ta lə jipɨ-je kɨ́ dꞌɔjɨ-na̰ ta kɨ́ majɨ al dɔ-é-tɨ. Beɓa ḛ panè: Nꞌa təl kɔw dɔnangɨ Maseduwan-tɨ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dḛ kɨ́ ꞌdan-é ə́n: Sopatɛr kɨ́ ngon lə Pirusɨ kɨ́ to dow kɨ́ ɓebo Bere-tɨ, Aristarkɨ kɨ̀ Sekundusɨ kɨ́ ꞌto dow-je kɨ́ ɓebo Tesalonikɨ-tɨ, Gayusɨ kɨ́ to dow kɨ́ ɓebo Dɛrbɨ-tɨ, ɓá Timote-je, kɨ̀ Tisikɨ-je, kɨ̀ Tropim-je kɨ́ ꞌto dow-je kɨ́ dɔnangɨ Aji-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dḛ kinlé, dꞌɔw kete nɔ̰̀-ji-tɨ ə ꞌngəbɨ-ji mḛḛ ɓebo Troasɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngà jḛ rəmə, go ra na̰y-tɨ kɨ́ ꞌra kɨ̀ mbə̀ kɨ́ əm goto-tɨ lé, jḛ jꞌal mḛḛ bato-tɨ káre kɨ́ ɓebo Pilipɨ-tɨ, ə jꞌra ndɔ mḭ go-tɨ ɓəy ɓá jꞌingə-dé ɓebo Troasɨ-tɨ ə jꞌisɨ lo-é-tɨ ndɔ siri. ");
INSERT INTO mge_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ndɔ Dimasɨ lé, jḛ jꞌkəw-na̰ kdɔ kuso mbə̀ nam-na̰. Beɓa tò kadɨ bore ə Pol à kɔw ngá rəmə, ḛ ɔjɨ ta kɨ̀ dow-je kɨ́ ꞌkəw-na̰ lé, ə pa ta sar ya dan lo bapɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mḛḛ kəy kɨ́ dɔ madɨ-é-tɨ taá kɨ́ jꞌkəw-na̰-tɨ lé, pər lampɨ n̰a̰-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Basa káre bè kɨ́ ri-é lə Etikusɨ isɨ taá, kəm bole kəy-tɨ lé. Lokɨ Pol a̰ pa ta adɨ dow-je ya ɓəy rəmə, ḛ tò ɓi adɨ dan-é oy. Beɓa ɓi ləngɨ-é adɨ ḭ kəy-tɨ kɨ́ taá kɨ́ njèkungɨ-tɨ mutə lé ya usɨ nangɨ barakɨ. Ngà lokɨ dꞌun-é rəmə, ḛ oy. ");
INSERT INTO mge_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Beɓa Pol risɨ nangɨ ree ɗugɨ nangɨ dɔ-é-tɨ un-é kàdɨ̀-é-tɨ ɓá panè: «Adi mḛḛ-si usɨ nangɨ, kdɔ ndil-é tḛḛ al!» ");
INSERT INTO mge_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Beɓa lokɨ Pol təl ɔw mḛḛ kəy-tɨ taá gogɨ lé, ḛ gangɨ mbə̀ nam-na̰ uso rəm, ɓá uso né kɨ́ kare rəm tɔ. Go-tɨ gogɨ lé, ḛ təl pa ta adɨ tó-é uu n̰a̰ sar ya adɨ kàdɨ̀ ubə, ɓá ḛ ɔtɨ ɔw ɓəy. ");
INSERT INTO mge_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Rəmə ngon basa lé isɨ kəm ɓá ꞌtəl dꞌɔw siə ɓe gogɨ, adɨ mḛḛ dow-je təl usɨ nangɨ pɔ̰-pɔ̰ gogɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jḛ jꞌɔw kete, ə jꞌal mḛḛ bato-tɨ ə jꞌmbutɨ ɓebo Asosɨ-tɨ, lo kɨ́ tò kadɨ jꞌun Pol titɨ. To né kɨ́ ḛ ya ndigɨ bè, kdɔ tò kadɨ ḛ à kun rəbɨ kɔw kɨ̀ nja-é. ");
INSERT INTO mge_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Lokɨ ḛ ingə-ji Asosɨ lé, jḛ jꞌun-é mḛḛ bato-tɨ, jꞌɔw ɓebo Mitilḛn-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Jꞌḭ Mitilḛn-tɨ tin, jꞌɔw kəm-ji kɨ kete. Ə lo aa go-tɨ ɓá jꞌtḛḛ ta lo-tɨ kɨ́ Sio kɨ́ to dɔnangɨ kɨ́ tò dan ba-tɨ. Ndɔ kɨ́ gogɨ go-tɨ ɓá jꞌtḛḛ Samosɨ-tɨ, ngà lo kaa rəmə, jꞌtḛḛ ɓebo Mile-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Beɓa Pol ɔjɨ kadɨ nꞌdəə kàdɨ̀ ɓebo Epɛjɨ-tɨ taá, kdɔ kadɨ jꞌisɨ dɔnangɨ Ajitɨ n̰a̰ al. Ḛ nagɨ lɔw-lɔw kdɔ kadɨ, lé né rəmə, nꞌtḛḛ ɓebo Jorijalḛm-tɨ ndɔ ra na̰y-tɨ lə jipɨ-je kɨ́ ꞌɓa-é Pantekotɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pol isɨ mḛḛ ɓebo Mile-tɨ, ə ulə kulə ɓa ꞌngatɔ́gɨ-je lə njékəwna̰-je kɨ́ ɓebo Epɛjɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Lokɨ dḛ ꞌree tḛḛ rɔ-é-tɨ lé, ḛ idə-dé panè: «Panjiyə-m kɨ́ rɔ-si-tɨ dɔkaglo-je lay, un kutɨ-é ndɔ-tɨ kɨ́ dɔsa̰y lokɨ mꞌilə-né nja-m dɔnangɨ Aji-tɨ lé, sə̰i ꞌgəi majɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mꞌra kullə mꞌadɨ ꞌƁaɓe kɨ̀ dɔ kɨ́ sɔl lɔm-lɔm, kɨ̀ man nɔ̰ kəm-m-tɨ, kɨ̀ kɔ̰̀-je kɨ́ mꞌingə kɨ̀ go rəbɨ ta-je kɨ́ majɨ al majɨ al kɨ́ jipɨ-je dꞌɔjɨ-na̰ dɔ-m-tɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Né kɨ́ à majɨ sə-si lé, né káre ya kàrè mꞌɓɔyɔ dɔ-é sə-si al. Mꞌilə mbḛ mꞌadɨ-si rəm, mꞌndó-si né pandangɨ lo-je-tɨ rəm, ɓá mḛḛ kəy-je-tɨ lə-si rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Taá-taá ya mꞌɓa jipɨ-je kɨ̀ dow-je kɨ́ ꞌto grɛkɨ-je kadɨ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al dꞌɔsɨ batɨm ꞌtəl kɨ rɔ Lubə-tɨ ə dꞌadɨ mḛḛ-dé ꞌƁaɓe lə-ji Jeju. ");
INSERT INTO mge_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ngà, ooi bè, kɨ́ ngɔsnè kinlé, kɔw-m kɨ ɓebo Jorijalḛm-tɨ ə́ mꞌɔw mɔngɨ. Ndil ɔsɨ-m kadɨ mꞌɔw, ngà né kɨ́ à tḛḛ dɔ-m-tɨ ɓebo Jorijalḛm-tɨ lé, ma̰ mꞌasɨ gə al. ");
INSERT INTO mge_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Né kɨ́ mꞌgə lé, mḛḛ ɓebo-je lay kɨ́ mꞌtḛḛ-tɨ ya, Ndil kɨ́ aa njay adɨ-m mꞌgə majɨ kɨ́ dangay-je kɨ̀ kɔ̰̀-je tò ngəbɨ-m-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ngà kisɨ-m kɨ̀ dɔ-m taá lé, ma̰ mꞌoo kɨ né madɨ takəm-m-tɨ al ə né kɨ́ kəm-m tò go-tɨ lé, to ta lə kadɨ mꞌa̰y ngɔdɨ lə-m kin rə́tə́tə́ ngangɨ kagɨ-tɨ kɨ̀ rɔnəl rəm, to ta lə kadɨ mꞌtɔl ta kullə kɨ́ ꞌƁaɓe Jeju adɨ-m lé tɔ: Adɨ to ta lə kilə mbḛ Poyta kɨ́ Majɨ kɨ́ sɔbɨ dɔ ramajɨ lə Lubə.» ");
INSERT INTO mge_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ngà, ooi bè, kɨ́ ngɔsnè-tɨ kinlé, sə̰i lay kɨ́ mꞌdəə dan-si-tɨ mꞌndó-si ta kɨ́ dɔ kɔ̰ɓe-tɨ lə Lubə kinlé, a koo-i takəm-m gogɨ rangɨ al ngá. ");
INSERT INTO mge_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Gin-é kin ɓá ɓone mꞌidə-si-né ta rəsɨ mꞌpanè: Sə̰i lay kin ya ta məsɨ-si goto dɔ-m-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kdɔ ta lə kɔjra-je lə Lubə lé ma̰ mꞌidə-si lay tingə, ḛ kɨ́ mꞌɓɔyɔ sə-si dɔ-é ya goto. ");
INSERT INTO mge_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ꞌTɔsi kəm-si dɔ rɔ-si sə̰i-tɨ ya rəm, ɓá dɔ kosɨ batɨ-je-tɨ lay kɨ́ Ndil kɨ́ aa njay ində-si dan-dé-tɨ kadɨ indəi kəm-si go-dé-tɨ lé rəm tɔ. Kadɨ ꞌtoi njékul njékəwna̰-je lə Lubə kɨ́ ḛ ya ndogɨ-dé kɨ̀ takul məsɨ-é ḛ ya. ");
INSERT INTO mge_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mꞌgə majɨ kɨ́ lokɨ mꞌa kɔw lé, jagɨm-je kɨ́ majɨ al dꞌa kandɨ mbunə̰-si-tɨ, dꞌa koo kəmtondoo lə kosɨ batɨ-je kinlé al. ");
INSERT INTO mge_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Rəm ɓá dan-si sə̰i-tɨ ya kàrè, dow-je kɨ́ dan-tɨ-je dꞌa kḭ kdɔ pa ta-je kɨ́ majɨ al majɨ al kədɨ-né njéndó né-je kɔr-dé-né kungɨ-dé go-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Indəi kəmkaa dɔ rɔ-si-tɨ, adi mḛḛ-si ole dɔ-tɨ tokɨ asɨ ɓal mutə bè, ə́ kada al rəm ndɔɔ al rəm ya, mꞌndəjɨ ná̰-ná̰ dan-si-tɨ taá-taá kɨ̀ man nɔ̰ kəm-m-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ngà kɨ́ nè kinlé, mꞌungɨ-si mḛḛ ji Lubə-tɨ rəm, mꞌin̰ə-si mḛḛ ta-tɨ liə kɨ́ to ta ramajɨ, kɨ́ ɔw kɨ̀ tɔ́gɨ kadɨ ɔw sə-si kɨ kete-kete mḛḛ kadmee-tɨ lə-si, ɓá à kadɨ nédɔji dow-je kɨ́ dꞌaa njay rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ɓo là, əse lɔr əse ɓo kubɨ-je lə dow madɨ ra-m al. ");
INSERT INTO mge_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sə̰i ya kàrè, ꞌgəi kɨ́ to ji-m kɨ́ tò kin ɓá adɨ-m né-je kɨ́ mḛḛ-m ge rəm, adɨ mꞌadɨ madkullə-je lə-m né-je kɨ́ mḛḛ-dé ge rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ndɔ-é ndɔ-é ya mꞌidə-si mꞌpanè: Tò kadɨ a rai kullə bè tɔ ɓá a rai-né kɨ̀ njéndoo-je, ə kadɨ mḛḛ-si ole dɔ ta-je-tɨ lə ꞌƁaɓe Jeju, kɨ́ ḛ ya kɨ̀ dɔ-é pa panè: “Kadɨ né dow lé majkur-é itə kində ji taa-né né!”» ");
INSERT INTO mge_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Lokɨ Pol pa ta bè adɨ-dé lé, ḛ ɔsɨ məkəjɨ-é nangɨ ɓá pa ta kɨ̀ Lubə kdɔ ta lə-dé lay. ");
INSERT INTO mge_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Rəmə dḛ lay ꞌnɔ̰ ə dꞌungɨ-na̰ mindɨ Pol-tɨ dꞌuwə-é kɨ kàdɨ̀-dé-tɨ ꞌra-é lapiya. ");
INSERT INTO mge_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Né ya kɨ́ mḛḛkɔ̰̀ ra-dé-né n̰a̰ lé, to ta lə kidə kɨ́ Pol idə-dé panè dꞌa koo takəm-nꞌḛ̀ gogɨ rangɨ al ngá kin. Go-tɨ, dḛ ꞌdan-é dꞌɔw siə njal ta bato-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Lokɨ jꞌin̰ə-na̰ sə-dé ngá rəmə, jḛ jꞌal mḛḛ bato-tɨ, jꞌɔw njururu mḛḛ ɓebo Kosɨ-tɨ. Lo aa go-tɨ, jꞌɔw Rodɛsɨ kɨ́ to dɔnangɨ kɨ́ tò dan ba-tɨ, ngá ɓá jꞌḭ tin jꞌɔw mḛḛ ɓebo Patara-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Lokɨ jꞌingə bato madɨ kɨ́ isɨ ɔw mḛḛ ɓebo Penisi-tɨ lé, jḛ jꞌal mḛḛ-é-tɨ jꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Beɓa lokɨ jꞌɔw jꞌtḛḛ ngɔsi kɨ̀ dɔnangɨ Siprə-tɨ kɨ́ tò dan ba-tɨ rəmə, jꞌin̰ə ɓe lé dɔji gəl, ə jꞌɔw dɔ-ji kɨ dɔnangɨ Siri-tɨ bè. Ə jꞌɔw jꞌur nangɨ ɓebo Tir-tɨ, kɨ́ to lo kɨ́ tò kadɨ dꞌa kɔr né-je kɨ́ mḛḛ bato-tɨ nangɨ titɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Lokɨ jꞌingə njéndó né-je lo-é-tɨ kinlé, jḛ jꞌisɨ sə-dé ndɔ siri. Ndil kɨ́ aa njay ɔsɨ-dé, adɨ dꞌidə Pol kadɨ ɔw mḛḛ ɓebo Jorijalḛm-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bè ya kàrè lokɨ ndɔ kisɨ-ji rɔ-dé-tɨ tingə ngá lé, jḛ jꞌusɨ dɔrəbɨ-tɨ. Rəmə dḛ kɨ̀ ne-dé-je kɨ̀ ngan-dé-je lay ya ꞌdan-ji ꞌree sə-ji njal gidɨ ɓebo-tɨ. Jḛ jꞌɔsɨ məkəjɨ-ji nangɨ ngangɨ ba-tɨ, jꞌpa ta kɨ̀ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Go-tɨ, jꞌra-na̰ lapiya ɓəy ngá ɓá, jḛ jꞌal mḛḛ bato-tɨ lé, ə njédan-ji-je lé kàrè ꞌtəl kɨ ɓee-je lə-dé gogɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Lokɨ jꞌin̰ə rəbɨ kɨ́ mani lé, jꞌḭ ɓebo Tir-tɨ jꞌɔw ɓebo Tolemayisɨ-tɨ. Jꞌra lapiya njékadmḛḛ-je kɨ́ dꞌisɨ mḛḛ ɓebo-tɨ kinlé, ə jꞌisɨ sə-dé ndɔ káre. ");
INSERT INTO mge_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo aa go-tɨ lé, jꞌɔw ɓebo Sejare-tɨ. Lokɨ jꞌtḛḛ Sejare lé, jꞌɔw ɓe lə Pilipɨ kɨ́ to njèkilə mbḛ Poyta kɨ́ Majɨ, ə jꞌtò rɔ-é-tɨ. Pilipɨ lé, to kɨ́ káre dan dow-je-tɨ kɨ́ siri kɨ́ ndɔkɨ ꞌmbətɨ-dé mḛḛ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ḛ ɔw kɨ̀ ngan-je kɨ́ dené sɔ kɨ́ ꞌtaa ngɔw al ə ꞌto njépata-je kɨ́ ta Lubə-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Lokɨ jꞌisɨ tin asɨ ndɔ n̰a̰ lé, dow káre kɨ́ ri-é lə Agabusɨ kɨ́ to njèpata kɨ́ ta Lubə-tɨ, ḭ dɔnangɨ Jude-tɨ ree ingə-ji nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Rəmə ḛ un ndaá dɔɔ ɓədɨ lə Pol, dɔ-né ji-é kɨ̀ nja-é ḛ ya ə panè: «Yən, ta kɨ́ Ndil kɨ́ aa njay pa ə́n: Dingəm kɨ́ ndaá dɔɔ ɓədɨ kin to kɨ́ ꞌliə lé, jipɨ-je dꞌa kuwə-é, tɔ́-é njim-njim ɓebo Jorijalḛm-tɨ tana̰ bè tɔ, ngá ɓá dꞌa kilə-é ji dow-je-tɨ kɨ́ ꞌto jipɨ-je al.» ");
INSERT INTO mge_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Go ta-je-tɨ kinlé, jḛ kɨ̀ njékadmḛḛ-je kɨ́ Sejare jꞌnɔ̰ ta Pol-tɨ kadɨ ɔw mḛḛ ɓebo Jorijalḛm-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ngà Pol ilə-tɨ panè: «Kdɔ ri ə́ ꞌnɔ̰i ɔri-né tɔ́gɨ-m gogɨ bè wa? Ma̰ lé, mꞌisɨ dɔ nja-m-tɨ kdɔ kadɨ ꞌtɔ́-m njim-njim par al, ngà mꞌisɨ dɔ nja-m-tɨ kadɨ mꞌɔw mꞌoy ɓebo Jorijalḛm-tɨ kdɔ ta lə ꞌƁaɓe Jeju.» ");
INSERT INTO mge_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lokɨ ḛ adɨ ta-je lə-ji kin ra kullə rɔ-é-tɨ al lé, jḛ jꞌa̰ dɔ-tɨ njángɨ al ya tɔ. Ngà jꞌpanè: «Kadɨ ꞌƁaɓe ɔjɨ ndigɨ liə!» ");
INSERT INTO mge_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Go ndɔ-je-tɨ kinlé, lokɨ jꞌra go né-je lə-ji rəmə, jḛ jꞌɔw mḛḛ ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Njéndó né-je kɨ́ dan-tɨ-je kɨ́ ɓebo Sejare-tɨ kɨ́ dꞌisɨ dꞌɔw ɓebo Jorijalḛm-tɨ, dꞌɔw sə-ji tɔ. Dḛ dꞌɔw sə-ji adɨ jꞌtò rɔ Mɨnasɔ̰-tɨ kɨ́ to njéndó né kɨ́ kete low nṵ. Ḛ to dow kɨ́ dɔnangɨ Siprə-tɨ kɨ́ tò dan ba-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Lokɨ jꞌtḛḛ ɓebo Jorijalḛm-tɨ lé, njékadmḛḛ-je dꞌuwə-ji kɨ rɔ-dé-tɨ kɨ̀ rɔnəl. ");
INSERT INTO mge_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lo aa go-tɨ, Pol ɔw sə-ji natɨ rɔ Jakɨ-tɨ, lo kɨ́ ꞌngatɔ́gɨ-je lay ya ꞌkəw-na̰ titɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Lokɨ Pol ra-dé lapiya ngà rəmə, né-je kɨ́ Lubə ra dan dow-je-tɨ kɨ́ ꞌto jipɨ-je al kɨ̀ takul kullə liə lé, ḛ ɔr-dé poy-é kɨ̀ bar-é bar-é. ");
INSERT INTO mge_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Lokɨ dꞌoo ta-je liə kin bè lé, dḛ dꞌɔsɨ gajɨ Lubə, ɓá go-tɨ dꞌidə Pol ꞌpanè: «Ngonkɔ̰-ji kɨ́ majɨ, ꞌoo jipɨ-je ɓudɔgɨ dɔgɨ lo n̰a̰ ya dꞌadɨ mḛḛ-dé Jeju rəm, lay lə-dé ya dꞌa̰ dɔ ndukun-tɨ lə Moiyijɨ kɨ̀ rɔ-dé kɨ́ tungə pilingɨ rəm. ");
INSERT INTO mge_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ya rəmə, dow-je dꞌidə-dé ta kɨ́ dɔ-i-tɨ ꞌpanè: Néndó lə-i ɔsɨ jipɨ-je lay kɨ́ dꞌisɨ dan dow-je-tɨ kɨ́ ꞌto jipɨ-je al kadɨ ꞌtəl gidɨ-dé dꞌadɨ ndukun lə Moiyijɨ rəm, kadɨ dꞌijə ganjangɨ ngan-dé-je al rəm, ɓá kadɨ ꞌtəl rɔ-dé go nékoɓe-tɨ lə jipɨ-je lé al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ngà jꞌa rai ban wa? Kdɔ ta kɨ́ rá-tɨ ya kàrè lokɨ kosɨ dow-je dꞌa kəw-na̰ lé dꞌa koo kɨ́ i ꞌree nè ya ə́n. ");
INSERT INTO mge_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Beɓa ꞌra nè kɨ́ jꞌa kidə-i kin. Dingəm-je sɔ kɨ́ dꞌun mindɨ-dé dɔ né madɨ-tɨ dꞌadɨ Lubə dꞌisɨ dan-ji-tɨ nè. ");
INSERT INTO mge_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ɔr-dé go-i-tɨ, ə ꞌra nékoɓe kɨ́ sɔbɨ dɔ kaa rɔ njay lə-i rəm, kɨ́ sɔbɨ dɔ kaa rɔ njay lə-dé rəm, ɓá ugə dɔ-dé adɨ ꞌndisə dɔ-dé rəm tɔ. Bè kdɔ kadɨ dow-je lay ꞌgə kɨ́ ta-je kɨ́ dɔ-i-tɨ kɨ́ ɔw mbuu kinlé, to ta-je kɨ́ kare rəm, ɓá kadɨ ꞌgə kɨ́ i lé, ya kàrè ꞌtəl rɔ-i go ndukun-tɨ lə Moiyijɨ majɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ngà kɨ́ sɔbɨ dɔ jipɨ-je al kɨ́ dꞌadɨ mḛḛ-dé Jeju lé, jꞌndàngɨ mbete jꞌadɨ-dé jꞌidə-dé-né kadɨ da̰-je kɨ́ dow-je ꞌtɔl ꞌpole-né magɨ-je lé, dꞌa kuso al rəm, kadɨ dꞌa kuso məsɨ da̰ al rəm, dꞌa kuso da̰ kɨ́ oy yo kuburu al rəm, ɓá kadɨ dꞌɔgɨ rɔ-dé ra kaya rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Lo aa go-tɨ, Pol ɔr dingəm-je kɨ́ sɔ lé ɔw sə-dé, adɨ ḛ rəm, dḛ rəm ya dꞌaa rɔ-dé ngá ɓá, ḛ ɔw takəy-tɨ lə Lubə, kdɔ kidə njégugné-je, ndɔ kɨ́ gin kaa rɔ lə-dé à gangɨ-né, kadɨ ná̰-ná̰ dan-dé-tɨ ree kɨ̀ kadkare liə adɨ Lubə. ");
INSERT INTO mge_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lokɨ nà̰y n̰a̰ al kadɨ ndɔ kɨ́ siri lé goto rəmə, jipɨ-je kɨ́ dan-tɨ-je kɨ́ dꞌḭ dɔnangɨ Aji-tɨ dꞌoo Pol mḛḛ kəy-tɨ lə Lubə lé, dḛ ꞌsulə kosɨ dow-je adɨ dꞌuwə-é. ");
INSERT INTO mge_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ə ꞌtur kəə ꞌpanè: «Sə̰i Israyel-je, reei ori kàdɨ̀-ji ɓoo! Yən, dingəm kɨ́ njèndó né dow-je lay ya kɨ̀ lo-lo, pa-né ta kɨ́ majɨ al majɨ al dɔ Israyel-je-tɨ rəm, dɔ ndukun-tɨ lə Moiyijɨ rəm, ɓá dɔ kəy-tɨ lə Lubə kin rəm lé, ḛ ə a̰ an. Ḛ ɔw mbing ya ree kɨ̀ dow-je kɨ́ ꞌto grɛkɨ-je mḛḛ kəy-tɨ lə Lubə. Ḛ ra lo kɨ́ aa njay kin kɨ lo kɨ́ kɔgɨ kare.» ");
INSERT INTO mge_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Dḛ pa ta kin bè kdɔtalə Tropim kɨ́ to dow kɨ́ ɓebo Epɛjɨ-tɨ lé, dꞌoo-é kɨ̀ Pol mḛḛ ɓebo-tɨ. Beɓa ꞌgɨr kɨ́ Pol ɔw siə mḛḛ kəy-tɨ lə Lubə. ");
INSERT INTO mge_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dow-je kɨ́ ɓebo Jorijalḛm-tɨ lay ya dꞌɔw dɔ-na̰-tɨ wúr wùr ə dow-je dꞌḭ kɨ̀ lo-lo ya tətɨ-na̰ yipɨ dꞌa̰y kɨ lo-é-tɨ. Dḛ dꞌuwə Pol mḛḛ kəy-tɨ lə Lubə, ꞌndɔr-é dꞌɔw siə ndaa-tɨ rəmə, tajinatɨ nè ya dꞌutɨ tarəbɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Lokɨ ꞌsangɨ kadɨ ꞌtɔl Pol lé, dow-je kɨ́ mḛḛ ɓebo Jorijalḛm-tɨ lay ya dꞌɔw dɔ-na̰-tɨ wúr wùr adɨ ta-é usɨ mbi njèkun dɔ kutɨ asgar-je-tɨ kɨ́ ɓudɔgɨ. ");
INSERT INTO mge_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Rəmə lo-é-tɨ nè ya, ḛ rəm, asgar-je rəm, ɓá njékun dɔ kutɨ asgar-je kɨ́ ɓu ɓu, dꞌubə nangɨ dꞌḭ dꞌa̰y dꞌɔw kɨ rɔ dow-je-tɨ lé. Lokɨ dow-je kinlé, dꞌoo njèkun dɔ asgar-je kɨ́ ɓudɔgɨ kin rəm, dꞌoo asgar-je rəm lé, ꞌtaa koo ta tində-tɨ kɨ́ dꞌa̰ ꞌtində Pol lé ngá. ");
INSERT INTO mge_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Beɓa njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé, ɔtɨ kɨ rɔ Pol-tɨ uwə-é ə un ndu kadɨ dꞌilə-é sil gidɨ joo. Go-tɨ, ḛ dəjɨ ta panè: Dingəm kinlé to ná̰ wa? Ə ri ɓá ḛ ra wa? ");
INSERT INTO mge_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ngà dan kosɨ dow-je-tɨ lé, dow-je kɨ́ ná̰-je ꞌtur kɔɔl ꞌpanè: Ḛ ra né kɨ́ bè kin. Rəmə dḛ kɨ́ dan-tɨ-je ꞌpanè: Ḛ ra né kɨ́ bè kin tɔ. Ta-je kɨ́ ꞌpa yó-je kɨ nè-je kinlé, ra adɨ ta kɨ́ njururu bè ya njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé, ingə al. Beɓa ḛ un ndu kadɨ dꞌɔw kɨ̀ Pol mḛḛ ndògɨ bɔr-tɨ lə-dé. ");
INSERT INTO mge_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lokɨ Pol ree tḛḛ ɗigɨ lo njiyə-je-tɨ lé, asgar-je dꞌun-né nɔngɨ taá, kdɔtalə kosɨ dow-je dꞌɔw siə pɨr-pɨr pɨr-pɨr. ");
INSERT INTO mge_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kosɨ dow-je ya dꞌul-na̰ go-é-tɨ mbuu, kɨ̀ kəə ta-dé-tɨ taá-taá ꞌpanè: «Adɨ jꞌtɔli-é kɨ tɔl ya!» ");
INSERT INTO mge_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Lokɨ dꞌɔw kadɨ Pol andɨ lo-tɨ lə asgar-je lé rəmə, ḛ dəjɨ njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé panè: «Se i a kadɨ-m tarəbɨ kadɨ mꞌpa ta káre wa?» Beɓa ḛ dəjɨ-é panè: «I ꞌgə ta Grɛkɨ wa? ");
INSERT INTO mge_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","I lé ꞌto dow kɨ́ dɔnangɨ Ejiptɨ-tɨ, kɨ́ ngɔsnè ya ɓəy ə́ ɔy bɔkaya-je ɓudɔgɨ lo sɔ ɔw sə-dé diləlo-tɨ, sulə-dé kadɨ ꞌra dɔnga̰ lé al wa?» ");
INSERT INTO mge_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pol panè: «Ma̰ mꞌto jipɨ kɨ́ dꞌojɨ-m ɓebo Tarsɨ-tɨ, dɔnangɨ Silisi-tɨ, mꞌto ngon njèɓe kɨ́ ɓebo-tɨ kɨ́ ri-é ɓa n̰a̰. Kɔgri ya, adɨ-m tarəbɨ mꞌpa ta mꞌadɨ kosɨ dow-je.» ");
INSERT INTO mge_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Njèkun dɔ asgar-je kɨ́ ɓudɔgɨ lé, in̰ə tarəbɨ adɨ-é. Beɓa Pol al dɔ ɗigɨ lo njiyə-je-tɨ yəkɨ ji-é ta dow-je-tɨ, adɨ lo tò ndingɨ, ngá ɓá pa sə-dé ta kɨ̀ ta əbrə panè: ");
INSERT INTO mge_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ngankɔ̰-m-je kɨ̀ bɔbɨ-m-je, ꞌyəli mbi-si ooi-né ta kɨ́ ngɔsnè mꞌɔw kɨ̀ pa kdɔ pa-né ta dɔ rɔ-m-tɨ kin.» ");
INSERT INTO mge_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lokɨ dꞌoo kɨ́ Pol pa ta kɨ̀ ta Əbrə rəmə, lo təl pa doy ta madɨ-é-tɨ ya ɓəy, ngá ɓá Pol panè: ");
INSERT INTO mge_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ma̰ lé mꞌto jipɨ, dꞌojɨ-m ɓebo Tarsɨ, dɔnangɨ Silisi-tɨ, ngà dꞌotɨ-m ɓebo Jorijalḛm-tɨ nè ya rəm, Gamaliyɛl ndó-m né-je kɨ́ ɔw go-na̰-tɨ berere-berere kɨ̀ ndukun lə ka-ji-je rəm, ɓá kullə lə Lubə kàrè rɔ-m tungə-tɨ pilingɨ titɨ kɨ́ sə̰i lay a̰i-né ɓone kin bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Dow-je kɨ́ njékun go néndó lə Jeju lé, mꞌulə kəm-dé ndoo n̰a̰. Mꞌadɨ ꞌtɔ́ dingəm-je kɨ̀ dené-je njim-njim dꞌungɨ-dé dangay-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Burə dɔ njégugné-je lə Lubə kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je lay ya ꞌgə sə-m go-é majɨ. Kdɔ lokɨ mꞌisɨ mꞌɔw Damasɨ lé, dḛ ꞌndàngɨ mbete-je dꞌadɨ mꞌɔw-né madɨ ngankɔ̰-ji-je kɨ́ dꞌisɨ nṵ. Mꞌɔw kdɔ kadɨ mꞌtuwə njékadɨ mḛḛ-dé Jeju kɨ́ dꞌisɨ mḛḛ ɓebo Damasɨ-tɨ, mꞌtɔ́-dé njim-njim mꞌree sə-dé ɓebo Jorijalḛm-tɨ, kdɔ kadɨ dꞌadɨ-dé kɔ̰̀.» ");
INSERT INTO mge_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ta kɨ́ kàdɨ̀ a̰ jam dɔ ɓe-tɨ, lokɨ mꞌa̰ dɔ rəbɨ-tɨ, mꞌtḛḛ ngɔsi kɨ̀ ɓebo Damasɨ rəmə, tajinatɨ nè ya, londógɨ kɨ́ n̰a̰ ya ndógɨ ḭ dɔra̰-tɨ ree gəə dɔ-m sipɨ. ");
INSERT INTO mge_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Adɨ mꞌtḛḛ mꞌusɨ nangɨ rəmə, mꞌoo ndi dow pa sə-m ta panè: “Sol, Sol, kdɔ ri ɓá ꞌulə kəm-m ndoo bè wa?” ");
INSERT INTO mge_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ma̰ mꞌilə-é-tɨ mꞌpanè: “I to ná̰ wa, ꞌƁaɓe?” Mꞌoo ndi dow lé, təl ilə-m-tɨ panè: “To ma̰ Jeju, dow kɨ́ Najarɛtɨ-tɨ kɨ́ ꞌisɨ ꞌulə kəm-m ndoo lé ya.” ");
INSERT INTO mge_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Dow-je kɨ́ dꞌɔw sə-m, dꞌoo lo kɨ́ ndógɨ lé majɨ ya, ngà ndi dow kɨ́ ꞌpa sə-m ta lé ɓá dꞌoo al. ");
INSERT INTO mge_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ma̰ mꞌdəjɨ-é mꞌpanè: “ꞌƁaɓe, ri ɓá tò kadɨ mꞌra wa?” Beɓa ꞌƁaɓe ilə-m-tɨ panè: “Ḭ taá ꞌɔw ɓebo Damasɨ-tɨ ə tin ya dꞌa kidə-i né lay kɨ́ tò kadɨ ꞌra.” ");
INSERT INTO mge_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ngà lo kɨ́ ndógɨ lé ya, ra adɨ kəm-m oo lo al, adɨ dḛ kɨ́ dꞌa̰ sə-m lé, ngá ɓá dꞌuwə ji-m ꞌndɔr-m dꞌɔw sə-m ɓebo Damasɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Dingəm káre bè kɨ́ ri-é lə Ananiasɨ ə to dow kɨ́ njèkilə kujɨ dɔ ndukun-tɨ lə Lubə rəm, ɓá to dow kɨ́ jipɨ-je lay kɨ́ dꞌisɨ ɓebo Damasɨ-tɨ ꞌpa ta kɨ́ dɔ-é-tɨ majɨ n̰a̰ rəm, ");
INSERT INTO mge_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ɓá ree rɔ-m-tɨ ə idə-m panè: “Ngonkɔ̰-m Sol, ꞌtḛḛ kəm-i ꞌoo lo.” Rəmə tajinatɨ nè ya, kəm-m oo lo adɨ mꞌoo-é. ");
INSERT INTO mge_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ḛ təl pa ɓəy panè: “Lubə lə ka-ji-je uwə dɔ-i kete kdɔ kadɨ ꞌgə ndigɨ liə, kdɔ kadɨ ꞌoo njèra né kɨ́ njururu rəm, ɓá kdɔ kadɨ ꞌoo ta-je kɨ́ ta-é-tɨ kɨ̀ mbi-i rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Né-je kɨ́ ꞌoo kɨ̀ kəm-i rəm, ta-je kɨ́ ꞌoo ta-é-tɨ kɨ̀ mbi-i rəm kinlé, i ɓá ꞌa to njèkɔr go-é kadɨ dow-je lay dꞌoo. ");
INSERT INTO mge_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kɨ́ ngɔsnè-tɨ kinlé, ri ɓá ꞌa̰ ꞌngəbɨ ɓəy wa? Ḭ taá ꞌnɔ̰ ɓa ꞌƁaɓe, kadɨ-é togɨ majal-je lə-i kɔgɨ adɨ-i ə kadɨ ꞌra-i batḛm.”» ");
INSERT INTO mge_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Lokɨ mꞌtəl mꞌree ɓebo Jorijalḛm-tɨ gogɨ, ɓá mꞌisɨ mꞌpa ta kɨ̀ Lubə mḛḛ kəy-tɨ liə rəmə, né ra-m tokɨ nḭ bè, ");
INSERT INTO mge_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ə mꞌoo ꞌƁaɓe idə-m panè: «ꞌƆdɨ rɔ-i, ꞌtḛḛ lɔw kɔgɨ ɓebo Jorijalḛm-tɨ, kdɔtalə ta kɨ́ dɔ-m-tɨ kɨ́ ꞌa pa lé, dow-je kɨ́ mḛḛ ɓe-tɨ kin dꞌa taa al.» ");
INSERT INTO mge_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Beɓa mꞌtəl mꞌilə-é-tɨ mꞌpanè: «ꞌƁaɓe, dḛ ya kàrè ꞌgə majɨ kɨ́ ma̰ lé, ndɔkɨ mꞌɔw mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je, mꞌadɨ ꞌtuwə dow-je kɨ́ dꞌadɨ-i mḛḛ-dé dꞌungɨ-dé dangay-tɨ rəm, ɓá mꞌadɨ ꞌtində-dé kɨ̀ ndəy rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Rəm lokɨ ndɔkɨ dꞌa̰ ꞌtɔl Etiyḛn kɨ́ to njèpata lə-i lé, mꞌa̰ lo-é-tɨ nɔ̰ɔ̰ rəm, mꞌndigɨ sə-dé dɔ-tɨ rəm, ɓá mꞌngəm kubɨ-je lə njétɔl-é-je rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ngà ꞌƁaɓe idə-m panè: «ꞌƆw, mꞌa kulə-i sa̰y nṵ rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al!» ");
INSERT INTO mge_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lokɨ jipɨ-je dꞌoo ta lə Pol sar ꞌtḛḛ dɔ ta-tɨ kin rəmə, dꞌun ndi-dé kɨ taá ꞌpanè: «Kadɨ dow kɨ́ tana̰ bè kinlé, goto dɔnangɨ-tɨ nè! Tuwə kadɨ-é isɨ kɨ̀ dɔ-é taá al!» ");
INSERT INTO mge_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ꞌTur kɔɔl rəm, ꞌtɔr kubɨ-je kɨ́ rɔ-dé-tɨ dꞌungɨ kɔgɨ rəm, ɓá dꞌɔy nangɨ ꞌsane kɨ taá-taá rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ngá ɓá njèkun dɔ kutɨ asgar-je ɓudɔgɨ lé, un ndu kadɨ dꞌɔw siə lo-tɨ lə asgar-je, ə kadɨ dꞌində-é ꞌdəjɨ-é-né ta, kdɔ kadɨ ꞌgə-né gin ta kɨ́ ꞌtur-né kəə dɔ-é-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lokɨ dꞌa̰ ꞌtɔ́ Pol kdɔ kində-é lé, ḛ idə njèkun dɔ kutɨ asgar-je kɨ́ ɓu kɨ́ a̰ nɔ̰ɔ̰ panè: «Ngon njèɓe kɨ́ Rɔm kɨ́ ꞌgangɨ ta dɔ-é-tɨ al ɓəy lé, se to tó-é kadɨ indəi-é wa?» ");
INSERT INTO mge_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lokɨ njèkun dɔ kutɨ asgar-je kɨ́ ɓu oo ta kinlé, ḛ ɔw rɔ njèkun dɔ asgar-je-tɨ kɨ́ ɓudɔgɨ lé, idə-é panè: «ꞌA ra ban ngá wa? Dingəm kinlé, to ngon njèɓe kɨ́ Rɔm lé ꞌoo ya!» ");
INSERT INTO mge_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Beɓa njèkun dɔ asgar-je ɓudɔgɨ lé, ree rɔ Pol-tɨ dəjɨ-é panè: «Idə-m, i lé ꞌto ngon njèɓe kɨ́ Rɔm tɔ wa?» Pol ilə-é-tɨ panè: «Oiyo, mꞌto ngon njèɓe kɨ́ Rɔm.» ");
INSERT INTO mge_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Rəmə njèkun dɔ asgar-je kɨ́ ɓudɔgɨ lé, təl panè: «Ma̰ lé, mꞌun là n̰a̰ madɨ ɓá mꞌto-né ngon njèɓe kɨ́ Rɔm.» Ngà Pol panè: «Ma̰ lé, mꞌto ngon njèɓe kɨ́ Rɔm kɨ́ kojɨ-tɨ!» ");
INSERT INTO mge_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Beɓa tajinatɨ nè ya, dḛ kɨ́ dꞌɔw kɨ̀ kində Pol lé ꞌtɔr ɓədɨ-dé, ɓá njèkun dɔ asgar-je kɨ́ ɓudɔgɨ lé kàrè, lokɨ ḛ gə kɨ́ to ngon njèɓe kɨ́ Rɔm ya ɓá nꞌadɨ ꞌtɔ́-é lé, ḛ ɓəl n̰a̰ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Lo aa go-tɨ, njèkun dɔ asgar-je ɓudɔgɨ lé, ndigɨ kadɨ nꞌndər gin ta lə Pol majɨ nꞌoo se ri ɓá jipɨ-je dꞌilə-né ta dɔ-é-tɨ wa. Beɓa ḛ adɨ ꞌtutɨ Pol, ngá ɓá un ndu adɨ ꞌɓa njékun dɔ njégugné-je lə Lubə, kɨ̀ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je kadɨ dꞌingə-na̰. Go-tɨ, ḛ adɨ ꞌree kɨ̀ Pol dꞌində-é dan-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol adɨ kəm-é tò kɨ dɔ ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je gə́rə́rə́, ɓá idə-dé panè: «Ngankɔ̰-m-je, panjiyə-m kɨ rɔ Lubə-tɨ lé, mḛḛ-m kɨ̀ ndḛ bè ya kàrè uwə-m kɨ̀ ta dɔ-tɨ al ya sar ɓone.» ");
INSERT INTO mge_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Rəmə Ananiasɨ kɨ́ burə dɔ njégugné-je lə Lubə un ndu adɨ dow-je kɨ́ dꞌa̰ mbɔ́-é-tɨ ngɔsi kadɨ dꞌində ta-é. ");
INSERT INTO mge_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Beɓa Pol idə-é panè: «I kɨ́ ꞌtitɨ-na̰ kɨ̀ ndogɨ bɔr kɨ́ ꞌra kɨ̀ pɔ̰ dꞌadɨ nda kin bè kinlé, i ɓá Lubə à kində-i! I isɨ lo kin-tɨ kdɔ gangta dɔ-m-tɨ kɨ́ go ndukun-tɨ lə Lubə rəmə, i ꞌnədɨ ndukun ə ꞌun ndu kadɨ dꞌində-m!» ");
INSERT INTO mge_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ngà dḛ kɨ́ dꞌa̰ lo-é-tɨ lé, dꞌidə-é ꞌpanè: «I ꞌtajɨ burə dɔ njégugné-je lə Lubə!» ");
INSERT INTO mge_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Beɓa Pol ilə-dé-tɨ panè: «Ngankɔ̰-m-je, mꞌgə to kɨ́ ḛ to burə dɔ njégugné-je lə Lubə al. Kdɔ mbete kɨ́ aa njay panè: “ꞌA pa ta kɨ́ majɨ al dɔ ꞌboy-tɨ kɨ́ dɔ gin dow-je-tɨ lə-i al!”» ");
INSERT INTO mge_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol gə kɨ́ dan ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je lé, Sadusi-je dꞌisɨ nɔ̰ɔ̰ rəm, ɓá Parisi-je kàrè dꞌisɨ nɔ̰ɔ̰ rəm tɔ. Beɓa ḛ ur kəə nɔ̰̀-dé-tɨ panè: «Ngankɔ̰-m-je, ma̰ lé, mꞌto Parisi rəm, ɓá mꞌto ngon kojɨ Parisi-je rəm tɔ. To ta lə nékində mḛḛ dɔ-tɨ lə-ji kɨ́ sɔbɨ dɔ tɔsɨ kɨ́ dow-je dꞌa tɔsɨ ndəl kində lo tḛḛ, ɓá ꞌgangɨ-né ta dɔ-m-tɨ kin.» ");
INSERT INTO mge_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ḛ pa ta kinlé ilə nangɨ al ya ɓəy rəmə, Parisi-je kɨ̀ Sadusi-je ꞌgakɨ-na̰ adɨ ꞌgángɨ-na̰ lo joo. ");
INSERT INTO mge_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusi-je lé dḛ ꞌpanè tɔsɨ ndəl kində lo tḛḛ goto rəm, malayka-je ꞌgoto rəm, ɓá ndil kàrè goto rəm tɔ; ngà Parisi-je rəmə dꞌində mḛḛ-dé dɔ né-je-tɨ kin lay tɔ. ");
INSERT INTO mge_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Né kin ra adɨ ꞌsingə dɔ-na̰-tɨ sokro. Njéndó dow-je ndukun-je kɨ́ ná̰-je kɨ́ dan Parisi-je-tɨ dꞌḭ taá ꞌnajɨ ta kɨ̀ tɔ́gɨ-dé ə ꞌpanè: «Né madɨ kɨ́ majɨ al káre ya kàrè jḛ jꞌingə rɔ dingəm-tɨ kanlé al. Dɔmajɨ ə to ndil, al rəmə malayka ɓá idə-é ta wa ə́n!» ");
INSERT INTO mge_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tanajɨ lé, nga̰ n̰a̰ adɨ njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé, ɓəl panè dꞌa kḭ gángɨ Pol dana̰ bɛtɨ-bɛtɨ. Beɓa ḛ un ndu adɨ asgar-je kadɨ dꞌur dan kosɨ dow-je-tɨ dꞌɔr Pol ji-dé-tɨ dꞌɔw siə lo-tɨ lə-dé dḛ asgar-je lé. ");
INSERT INTO mge_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ndɔ-é-tɨ kinlé ndɔɔ rəmə, ꞌƁaɓe tḛḛ dɔ Pol-tɨ idə-é panè: «ꞌUwə rɔ-i nga̰! Gangɨ-é kɨ́ i ꞌpa-né ta lə-m Jorijalḛm-tɨ kinlé, ꞌɔw ɓebo Rɔm-tɨ kàrè ꞌpa bè ya tɔ ɓane.» ");
INSERT INTO mge_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lo aa kɨ́ ndɔge lé, jipɨ-je dꞌɔjɨ-na̰ ta kɨ́ majɨ al ndil Pol-tɨ ə dꞌubɨ rɔ-dé dɔ-tɨ ꞌpanè, nꞌa ka̰yi man al rəm, nꞌa kusoi né al rəm ya kadɨ nꞌtɔli Pol mɔkɨ tá. ");
INSERT INTO mge_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Dow-je kɨ́ dꞌɔjɨ-na̰ ta kɨ́ majɨ al dɔ Pol-tɨ lé, kɔr-dé tɔy kɔrsɔ. ");
INSERT INTO mge_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Dḛ dꞌɔw dꞌingə njékun dɔ njégugné-je lə Lubə kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je dꞌidə-dé ꞌpanè: «Jḛ lé, jꞌadɨ rɔ-ji, ə jꞌubɨ rɔ-ji dɔ-tɨ, kadɨ né à kɔdɨ ta-ji al ya sar kadɨ jꞌtɔl Pol mɔkɨ tá. ");
INSERT INTO mge_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Beɓa kɨ́ ngɔsnè-tɨ kinlé, ꞌadi ta-si asɨ-na̰ kɨ̀ ꞌboy-je kɨ́ njégangta-je lə jipɨ-je ə indəi nɔ̰ɔ̰ njèkun dɔ kutɨ asgar-je-tɨ kɨ́ ɓudɔgɨ kadɨ-é ree kɨ̀ Pol nɔ̰̀-si-tɨ, rəmə ꞌrai titɨ-na̰ né kɨ́ ꞌndigi ndəri gin ta lə Pol lé majɨ kdɔ koo bè. Ngà jḛ tɔ rəmə, jꞌisɨ pèrèrè kdɔ kadɨ, lokɨ Pol isɨ ree lé, jꞌgangɨ-é jꞌtɔl-é kɔgɨ.» ");
INSERT INTO mge_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ngà lokɨ, ngon lə kɔ̰nan Pol-je oo ta lə gangɨ kɨ́ dꞌɔjɨ kdɔ gangɨ-é lé rəmə, ɔtɨ ɔw lo-tɨ lə asgar-je, ilə ta lé mbi Pol-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Lokɨ Pol oo ta kin bè lé, ḛ ɓa kɨ́ káre dan njékun dɔ kutɨ asgar-je-tɨ ɓu idə-é panè: «Basa kin, ɔw kɨ̀ ta madɨ kdɔ kidə njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ, ə́n ə́ ɔw siə rɔ-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Beɓa njèkun dɔ kutɨ asgar-je kɨ́ ɓu adɨ basa lé, ɔtɨ ɔw siə rɔ njèkun dɔ kutɨ asgar-je-tɨ kɨ́ ɓudɔgɨ lé, ə idə-é panè: «Pol kɨ́ to dangay lé, ɓa-m ə dəjɨ-m kadɨ mꞌree kɨ̀ basa kin rɔ-i-tɨ, kdɔ ɔw kɨ̀ ta madɨ kadɨ ilə mbi-i-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Beɓa njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ, uwə ji basa lé, ɔr-é adɨ dꞌa̰ kɨ̀ kár-dé ɓá dəjɨ-é panè: «Ta ri ɓá ɔw-né kdɔ kilə mbi-m-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Basa lé idə-é panè: «Jipɨ-je dꞌadɨ ta-dé asɨ-na̰ kadɨ ꞌdəjɨ-i kadɨ bore ə adɨ ꞌree kɨ̀ Pol nɔ̰̀ ꞌboy-je-tɨ kɨ́ njégangta-je-tɨ lə-dé, tokɨ né kɨ́ dꞌɔw kɨ̀ sangɨ kdɔ koo ta kɨ́ njururu dɔ ta-tɨ liə lé bè. ");
INSERT INTO mge_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ngà i rəmə, kadɨ ꞌndigɨ sə-dé dɔ-tɨ al, kdɔ dow-je kɨ́ kɔr-dé à tɔy kɔrsɔ ya dꞌɔjɨ kdɔ gangɨ-é. Dowbé-je kinlé, dꞌadɨ rɔ-dé ə dꞌubɨ rɔ-dé dɔ-tɨ kadɨ nꞌusoi né al rəm, nꞌa̰yi man al ya sar kadɨ nꞌtɔli Pol mɔkɨ tá. Dḛ dꞌisɨ pèrèrè ngá, rəmə né kɨ́ ꞌngəbɨ lé, ꞌngəbɨ kadɨ ꞌilə mindɨ-i adɨ-dé ya par.» ");
INSERT INTO mge_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ, ndɔr mbi basa lé panè: Né-je kɨ́ i ꞌree ꞌɔr-m poy-é kinlé, ꞌpa adɨ dow kɨ́ rangɨ oo al. Go-tɨ, ḛ tubə basa lé, adɨ-é ɔw. ");
INSERT INTO mge_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Go-tɨ ɓəy ngá ɓá, njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé, ɓa dow-je joo kɨ́ ꞌto njékun dɔ asgar-je kɨ́ ɓu ɓu idə-dé panè: «Adi asgar-je ɓujoo rəm, asgar-je kɨ́ njésində-je kɔrsiri rəm, ɓá dḛ kɨ́ njémandangɨ-je ɓujoo dꞌisɨ pèrèrè, kdɔ kadɨ lokɨ kàdɨ̀ kɨ́ siri kɨ́ ndɔɔ asɨ rəmə dꞌɔw ɓebo Sejare-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kadɨ né kal lə Pol kàrè tò tɔ; kdɔ kadɨ ɔw siə kɨ̀ majɨ-é ya rɔ Gubərnər Pelisɨ-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Beɓa njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ lé, ndàngɨ mbete adɨ Gubərnər panè: ");
INSERT INTO mge_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Ma̰ Klodɨ Lisiyasɨ mꞌra-i lapiya i Pelisɨ kɨ́ ꞌto dow kɨ́ boy. ");
INSERT INTO mge_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jipɨ-je dꞌuwə dingəm kɨ́ mꞌulə siə madɨ-i kinlé, ə dꞌɔw kdɔ tɔl-é ɓá lokɨ mꞌoo ta-é kɨ́ ḛ to ngon njèɓe kɨ́ Rɔm lé, mꞌḭ ratɨ kɨ̀ asgar-je mꞌɔr-é-né ji-dé-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Lokɨ mꞌndigɨ gə gin né kɨ́ dꞌilə-né ta dɔ-é-tɨ lé, mꞌɔw siə nɔ̰̀ ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Rəmə mꞌoo kɨ́ dꞌilə ta dɔ-é-tɨ kdɔ tanajɨ-je kɨ́ sɔbɨ dɔ ndukun lə-dé, ɓɨ ḛ ra né madɨ kɨ́ tuwə koy əse tuwə dangay al. ");
INSERT INTO mge_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Lokɨ jipɨ-je dꞌisɨ dꞌində dɔ-é kadɨ ꞌtɔl-é ɓá mꞌoo ta-é rəmə, tajinatɨ nè ya mꞌulə siə madɨ-i, ə mꞌadɨ njékilə ta dɔ-é-tɨ-je lé ꞌgə tokɨ dow kɨ́ dꞌa səkɨ Pol ta-é-tɨ lé to i. Oiyo n̰a̰.» ");
INSERT INTO mge_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Asgar-je ꞌtəl rɔ-dé go ndukun-tɨ kɨ́ dꞌadɨ-dé lé, adɨ ndɔɔ-ndɔɔ nɔ̰ɔ̰ ya dꞌɔw kɨ̀ Pol njal lo-tɨ lə asgar-je kɨ́ ɓebo Antipatrisɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lokɨ lo aa lé, dḛ ꞌtəl kɨ lo kisɨ-dé-tɨ ɓebo Jorijalḛm-tɨ gogɨ, ə dꞌin̰ə asgar-je kɨ́ njésində-je kadɨ dꞌun ta gajɨ rəbɨ lé kɨ̀ Pol. ");
INSERT INTO mge_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Beɓa lokɨ ꞌree tḛḛ ɓebo Sejare-tɨ lé, asgar-je kɨ́ njésində-je dꞌadɨ mbete lé Gubərnər rəm, ɓá ꞌtɔjɨ-é Pol lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ḛ ndó mbete lé oo rəmə, dəjɨ panè se Pol lé to dow kɨ́ dɔnangɨ-tɨ kɨ́ rá wa? Lokɨ oo kɨ́ Pol to dow kɨ́ dꞌojɨ-é dɔnangɨ Silisi-tɨ rəmə panè: ");
INSERT INTO mge_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Njékilə ta dɔ-i-tɨ-je dꞌa ree ɓá mꞌa koo ta kɨ́ ta-i-tɨ ɓəy. Go-tɨ, un ndu kadɨ dꞌɔw kɨ̀ Pol panata lə Erodɨ, ə dꞌində kəm-dé go-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ndɔ mḭ go-tɨ ɓá, Ananiasɨ kɨ́ to burə dɔ njégugné-je lə Lubə, ḭ ɓebo Jorijalḛm-tɨ ree ɓebo Sejare-tɨ natɨ kɨ̀ dow-je kɨ́ ꞌná̰-je kɨ́ dan ꞌngatɔ́gɨ-je-tɨ lə jipɨ-je rəm, kɨ̀ njègə pa ta gangɨ-né dɔ dow-je káre bè, kɨ́ ri-é lə Tɛrtulusɨ. Dḛ ꞌsəkɨ Pol nɔ̰̀ gubərnər Pelisɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lokɨ ꞌɓa Pol dꞌadɨ-é ree lé, Tɛrtulusɨ un kutɨ kɔr ta kdɔ kilə-né ta dɔ Pol-tɨ panè: «Kɨ̀ takul-i i Pelisɨ rəm, kɨ̀ takul gosɨ lə-i kɨ́ ꞌtəl-né gin né-je kdɔ ta lə majɨ lə gin dow-je kinlé, ɓá jꞌisɨ-né kɨ̀ lapiya kɨ́ ɔr njutɨ-njutɨ tin. ");
INSERT INTO mge_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","I Pelisɨ, dow kɨ́ boy n̰a̰, majɨ-je lay kɨ́ i ra lé, lo-je lay ya jꞌndigɨ sə-i dɔ-tɨ rəm, jꞌra-i oiyo dɔ-tɨ n̰a̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kdɔ kadɨ jꞌuwə-i nangɨ n̰a̰ al lé, mꞌra-i kɔgri, kadɨ kɨ́ go mḛḛmajɨ-tɨ lə-i lé ya, ꞌyəl mbi-i ꞌoo-né ta-je kɨ́ jꞌa pa gɔjɨ ɗekse bè ya kadɨ-i kin. ");
INSERT INTO mge_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Jꞌgə kɨ́ dingəm kinlé, tokɨ mɔ̰y kosɨ kɨ́ usɨ mḛḛ ɓe-tɨ bè. Ḛ sulə jipɨ-je kɨ́ dɔnangɨ-tɨ nè lay adɨ ꞌgángɨ-na̰ rəm, ḛ to njèkun dɔ kutɨ dow-je kɨ́ to njékɔr rɔ-dé-je kɨ́ ꞌɓa-dé dow-je kɨ́ Najarɛtɨ-tɨ lé rəm, ");
INSERT INTO mge_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ɓəy ɓá ɔw mbing ya sangɨ kadɨ nꞌtəl kəy lə Lubə né kɨ́ kɔgɨ kare rəm tɔ. Né kin ɓá jḛ jꞌuwə-é-né tin. Jḛ jꞌndigɨ gangta dɔ-é-tɨ kɨ́ go ndukun-tɨ lə-ji ya, ");
INSERT INTO mge_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ngà Lisiyasɨ kɨ́ to njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ ɓá ree tḛḛ rəmə, ta-é ji-ji-tɨ kɨ́ lə njètɔ́gɨ-tɨ kɨ́ n̰a̰. ");
INSERT INTO mge_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Go-tɨ, ḛ un ndu adɨ njékilə ta dɔ Pol-tɨ kadɨ ꞌree siə nɔ̰̀-i-tɨ nè. Né-je lay kɨ́ jꞌtilə ta-é dɔ-é-tɨ kinlé, i ya kɨ̀ dɔ-i lokɨ ꞌa kulə kutɨ dəjɨ-é ta-je rəmə ꞌa gə majɨ.» ");
INSERT INTO mge_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jipɨ-je kàrè dꞌusɨ kutɨ Tɛrtulusɨ-tɨ ꞌpanè: Oiyo, gangɨ-é ya ə́n. ");
INSERT INTO mge_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Lokɨ gubərnər ra kəm-é idə-né Pol kadɨ pa ta lé, Pol un ta panè: «Mꞌgə majɨ kɨ́ i lé, ꞌto njègangta lə gin dow-je kinlé, asɨ ɓal-je n̰a̰ ngá, beɓa mꞌun-né ta kɨ̀ rɔ nga̰ kdɔ pa dɔ rɔ-m-tɨ tin. ");
INSERT INTO mge_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kɔw kɨ́ mꞌɔw ɓebo Jorijalḛm-tɨ mꞌɔsɨ dɔ-m nangɨ nɔ̰̀ Lubə-tɨ lé, tɔy ndɔ dɔgɨ gidɨ-dé joo al ɓəy. To né kɨ́ i ya kàrè, ꞌa dəjɨ koo rəm. ");
INSERT INTO mge_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Dow káre ya kàrè oo-m mḛḛ kəy-tɨ lə Lubə əse mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je əse mḛḛ ɓebo-tɨ mꞌa̰ mꞌnajɨ ta kɨ̀ dow madɨ əse mꞌa̰ mꞌsulə dow-je al rəm. ");
INSERT INTO mge_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Dow-je kinlé, né kɨ́ dꞌa ra kadɨ tɔjɨ kɨ́ ta-je kɨ́ ꞌtilə dɔ-m-tɨ kin, to ta kɨ́ tɔgrɔ-tɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Né kɨ́ mꞌgə kɨ́ ra né ə́n: Ma̰ lé mꞌpole Lubə lə ka-ji-je kɨ̀ rəbɨ Poyta kɨ́ Majɨ kɨ́ dḛ ꞌpanè to rəbɨ néndó kɨ́ ngɔm. Ma̰ mꞌadɨ mḛḛ-m né-je lay kɨ́ tò mḛḛ mbete ndukun-tɨ lə Lubə rəm, mḛḛ mbete-je-tɨ lə njépata-je kɨ́ ta Lubə-tɨ lé rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mꞌində mḛḛ-m dɔ Lubə-tɨ, tokɨ njéra né kɨ́ njururu, kɨ̀ njéra né kɨ́ njururu al dꞌa tɔsɨ ndəl kində lo tḛḛ titɨ kɨ́ njékilə ta dɔ-m-tɨ-je lé kàrè, dꞌində-né mḛḛ-dé dɔ-tɨ kin bè ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Gin-é kin ɓá ndɔ-je lay ya mꞌnagɨ-né rɔ-m kdɔ kadɨ mḛḛ-m uwə-m kɨ̀ ta nɔ̰̀ Lubə-tɨ al rəm, ɓá nɔ̰̀ dow-je-tɨ al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Mꞌra ɓal-je n̰a̰ rangɨ ɓá mꞌtəl mꞌree, kdɔ kadɨ mꞌadɨ né njéndoo-je kɨ́ dan gin dow-je-tɨ lə-m rəm, ɓá kdɔ kadɨ mꞌadɨ kadkare Lubə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Gangɨ-é-tɨ kin ɓá lokɨ mꞌtɔl ta nékoɓe, kdɔ kadɨ mꞌaa-né rɔ-m lé, ngá ɓá jipɨ-je dꞌoo-m-né mḛḛ kəy-tɨ lə Lubə, ɓɨ kosɨ dow-je dꞌilə-na̰ ꞌgəə dɔ-m, ɓá mꞌsulə-dé-né al. ");
INSERT INTO mge_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Jipɨ-je kɨ́ dan-tɨ-je kɨ́ dɔnangɨ Aji-tɨ kɨ́ dꞌoo-m lo ra né-tɨ kin, ɓá lé dꞌa ka̰ nɔ̰̀-i-tɨ kdɔ kilə ta dɔ-m-tɨ, tokɨ dꞌɔw sə-m kɨ ta madɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Lé bè ya kàrè, dḛ kɨ́ dꞌa̰ nè kin ya kadɨ ꞌpa se lokɨ mꞌa̰ nɔ̰̀ ꞌboy-je-tɨ kɨ́ njégangta-je lə jipɨ-je lé, se ri kɨ́ majɨ al ə ta-é usɨ dɔ-m-tɨ adɨ dꞌoo wa? ");
INSERT INTO mge_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Kadɨ ta lə kəə kɨ́ mꞌa̰ dan-dé-tɨ mꞌur kinlé ya je bè tá ɔbɨ. Mꞌur kəə lé mꞌpanè: “To ta lə tɔsɨ kɨ́ dow-je kɨ́ dꞌoy dꞌa tɔsɨ ndəl kində lo tḛḛ, ɓá ꞌgangɨ-né ta dɔ-m-tɨ nɔ̰̀-si-tɨ tin.”» ");
INSERT INTO mge_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ta kɨ́ sɔbɨ dɔ néndó lə Jeju kinlé, Pelisɨ gə majɨ yə́rə́rə́. Beɓa ḛ ɔr ndɔ ra ta lé, ɔw-né ndɔ kɨ́ rangɨ-tɨ ə panè: «Lokɨ Lisiyasɨ kɨ́ njèkun dɔ kutɨ asgar-je kɨ́ ɓudɔgɨ à ree, ɓá mꞌa ndər gin ta lə-si majɨ koo ɓəy» ");
INSERT INTO mge_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Go-tɨ, ḛ un ndu adɨ njèkun dɔ kutɨ asgar-je kɨ́ ɓu kadɨ ində kəm-é go Pol-tɨ rəm, kadɨ in̰ə-é adɨ ra ndigɨ-je liə kɨ́ ꞌná̰-je sḛ-sḛ rəm, ɓá kadɨ in̰ə dow-je liə kadɨ ꞌree ꞌra siə-siə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Asɨ ndɔ sḛ go-tɨ, Pelisɨ ree natɨ kɨ̀ ne-é Drusil kɨ́ to jipɨ, ə ulə kulə ɓa Pol. Beɓa lokɨ Pol ree lé, ḛ pa ta kɨ́ sɔbɨ dɔ kadmḛḛ Jeju Kristɨ adɨ Pelisɨ. ");
INSERT INTO mge_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ngà lokɨ Pol un ta pa ɔdɨ-né rɔ né ra kɨ́ njururu rəm, ɔdɨ-né rɔ kore mḛḛ rəm, ɓá ɔdɨ-né rɔ ta kɨ́ gangɨ kɨ́ à ree rəm lé, Pelisɨ ɓəl n̰a̰ adɨ panè: «Kɨ́ ngɔsnè-tɨ kinlé, ɔw lo lə-i ngá. Lokɨ mꞌingə dɔkaglo ɓá mꞌa ɓa-i ɓəy.» ");
INSERT INTO mge_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pelisɨ ində mḛḛ-é dɔ-tɨ kɨ́ Pol à kadɨ-nꞌḛ̀ là. Né kin ɓá taá-taá ya adɨ-é ree adɨ dꞌɔjɨ-né-na̰ ta ta tin. ");
INSERT INTO mge_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bè-bè ya ɓal joo tɔy rəmə Porkiyusɨ Pestusɨ ree ɔr-né tó Pelisɨ. Pelisɨ in̰ə Pol dangay-tɨ kdɔ nəl-né jipɨ-je. ");
INSERT INTO mge_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Lokɨ Pestusɨ ree ra ndɔ mutə dɔnangɨ-tɨ kɨ́ à kɔ̰̀ ɓe dɔ-tɨ lé, ḛ ḭ ɓebo Sejare-tɨ ɔw ɓebo Jorijalḛm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Rəmə njékun dɔ njégugné-je lə Lubə kɨ̀ ꞌboy-je lə jipɨ-je ꞌree ꞌsəkɨ Pol rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Dḛ ꞌdəjɨ-é kɨ̀ nɔ̰ kəm-dé-tɨ, kadɨ ra sə-dé majɨ ə adɨ ꞌtəl ꞌree kɨ̀ Pol ɓebo Jorijalḛm-tɨ gogɨ. Dowbé-je kinlé, ꞌra go rɔ-dé kadɨ ꞌgangɨ Pol rəbəə ꞌtɔl-é. ");
INSERT INTO mge_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Beɓa Pestusɨ ilə-dé-tɨ panè: Pol lé, isɨ dangay-tɨ ɓebo Sejare-tɨ rəm, ɓá ma̰ ya kɨ̀ dɔ-m kàrè nà̰y n̰a̰ al, kadɨ mꞌtəl mꞌɔw nɔ̰ɔ̰ tɔ ngá. ");
INSERT INTO mge_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ḛ ilə dɔ-tɨ ɓəy panè: «Kadɨ dow-je kɨ́ ꞌná̰-je kɨ́ dan-si-tɨ kɨ́ dꞌasɨ gakɨ dꞌɔw sə-m ɓebo Sejare-tɨ, ə́ kinə dingəm kinlé, ra né madɨ kɨ́ go rəbɨ-é-tɨ al nɔ̰ɔ̰ rəmə jè ꞌsəkɨ-é.» ");
INSERT INTO mge_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestusɨ isɨ ɓebo Jorijalḛm-tɨ nɔ̰ɔ̰ adɨ tɔy ndɔ jinà̰y joo əse ndɔ dɔgɨ al ya təl ɔw ɓebo Sejare-tɨ gogɨ. Lokɨ ḛ ree tḛḛ Sejare-tɨ lé, lo aa go-tɨ ya ɔw isɨ logangta-tɨ ə un ndu adɨ dꞌɔw ꞌree kɨ̀ Pol. ");
INSERT INTO mge_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lokɨ Pol ree ya rəmə, jipɨ-je kɨ́ dꞌḭ ɓebo Jorijalḛm-tɨ lé, dꞌilə-na̰ ꞌgəə dɔ-é sipɨ, ə ꞌtilə ta-je kɨ́ tò ɓəl-ɓəl n̰a̰ dɔ-é-tɨ, ya ngà né kɨ́ à tɔjɨ kɨ́ ta-je lə-dé kin, to ta kɨ́ tɔgrɔ-tɨ lé goto. ");
INSERT INTO mge_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Beɓa Pol un ta pa dɔ rɔ-é-tɨ panè: «Ma̰ mꞌra né kɨ́ majɨ al mꞌɔsɨ-né ndukun lə jipɨ-je kɨ̀ ta al rəm, mꞌra né kɨ́ majɨ al mꞌɔsɨ-né kəy lə Lubə kɨ̀ ta al rəm, mꞌra né kɨ́ majɨ al mꞌɔsɨ-né ngar Sejar kɨ̀ ta al rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pestusɨ ge kadɨ nꞌnəl jipɨ-je adɨ ilə Pol-tɨ panè: «Se i ꞌndigɨ kadɨ ꞌtəl ɔw ɓebo Jorijalḛm-tɨ gogɨ, kdɔ kadɨ ta kinlé, tokɨ gangɨ nṵ takəm-m-tɨ wa?» ");
INSERT INTO mge_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol ilə-é-tɨ panè: «A tò bè al! Ma̰ mꞌa̰ logangta-tɨ lə ngar Sejar nè, adɨ lo kin-tɨ ya dꞌa gangta lə-m titɨ. Ngà kɨ́ sɔbɨ dɔ jipɨ-je lé, i ya kɨ̀ dɔ-i kàrè ꞌgə majɨ kɨ́ né kɨ́ majɨ al kɨ́ mꞌra sə-dé bè ya goto. ");
INSERT INTO mge_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kinə, mꞌra né madɨ kɨ́ njururu al nɔ̰ɔ̰ əse mꞌra né kɨ́ asɨ koy lé, mꞌa mbatɨ koy al. Ngà kinə ta-je kɨ́ dow-je ꞌtilə dɔ-m-tɨ kinlé to ta-je kɨ́ kare rəmə, dow kɨ́ ɔw kɨ̀ tɔ́gɨ kadɨ ilə-m ji-dé-tɨ goto. Ma̰ lé, mꞌge kadɨ ngar Sejar ya gangta lə-m.» ");
INSERT INTO mge_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Beɓa Pestusɨ ɔjɨ ta kɨ̀ njéra siə kullə-je ə ree idə-é panè: «I ge kadɨ ngar Sejar ɓá gangta lə-i lé, ꞌa kɔw nɔ̰̀ ngar Sejar-tɨ nṵ ya tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Asɨ ndɔ sḛ go-tɨ, ngar Agripa-je kɨ̀ Berenisɨ ꞌree ɓebo Sejare-tɨ kdɔ ra lapiya Pestusɨ. ");
INSERT INTO mge_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Dꞌisɨ tin ꞌra ndɔ n̰a̰ ɓəy. Beɓa Pestusɨ ɔr go ta-je kɨ́ sɔbɨ dɔ Pol idə ngar panè: «Pelisɨ in̰ə dingəm káre dangay-tɨ nɔ̰ɔ̰. ");
INSERT INTO mge_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ə dingəm-é lé, lokɨ mꞌɔw ɓebo Jorijalḛm-tɨ rəmə, njékun dɔ njégugné-je lə Lubə kɨ̀ ꞌngatɔ́gɨ-je lə jipɨ-je ꞌsəkɨ-é, ə ꞌdəjɨ kadɨ tokɨ gangɨ ta dɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ngà ma̰ mꞌilə-dé-tɨ mꞌpanè: Kújɨ ra-é lə dow-je kɨ́ Rɔm lé, tò bè al. Dḛ lé, ꞌa kadɨ dow kɨ́ dꞌilə ta dɔ-é-tɨ dḛ kɨ̀ njékilə ta dɔ-é-tɨ-je dꞌisɨ takəm-na̰-tɨ, kdɔ kadɨ dow kɨ́ dꞌilə ta dɔ-é-tɨ lé, ingə kəm lo pa-né ta dɔ rɔ-é-tɨ mɔkɨ ɓane. ");
INSERT INTO mge_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Beɓa dḛ ꞌree sə-m nè natɨ, ə ma̰ mꞌɔr ndɔ al, ngà lo aa ya rəmə mꞌɔw mꞌisɨ logangta-tɨ ə mꞌun ndu mꞌadɨ ꞌree kɨ̀ dingəm lé. ");
INSERT INTO mge_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Lokɨ njékilə ta dɔ-é-tɨ-je ꞌree lé, ta kɨ́ ꞌtilə dɔ-é-tɨ lé, tò ɓəl n̰a̰ ngay titɨ kɨ́ mꞌisɨ mꞌgɨr né lé al. ");
INSERT INTO mge_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ngà tanajɨ-je kɨ́ sɔbɨ dɔ pole Lubə lə-dé dḛ ya rəm, ta-je kɨ́ sɔbɨ dɔ Jeju ɓòó ná̰ ɓoo kɨ́ oy ɓá Pol panè, ḛ isɨ kəm kin ya par. ");
INSERT INTO mge_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ma̰ mꞌgə né kɨ́ mꞌa ra njururu dan tanajɨ-je-tɨ kɨ́ tana̰ bè kinlé al. Beɓa mꞌdəjɨ Pol mꞌpanè se ḛ ndigɨ kɔw ɓebo Jorijalḛm-tɨ kadɨ ta liə tokɨ gangɨ nṵ wa? ");
INSERT INTO mge_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ngà Pol ndigɨ kadɨ ta lə-nꞌḛ̀ lé, tokɨ kɔw-né nɔ̰̀ ngar-tɨ kɨ́ boy. Beɓa mꞌa̰ mꞌun ndu kadɨ ꞌngəm-é sar kadɨ mꞌulə siə mꞌadɨ Sejar.» ");
INSERT INTO mge_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Go-tɨ, Agripa idə Pestusɨ panè: «Dingəm kinlé, ma̰ ya kɨ̀ dɔ-m kàrè mꞌge koo ta kɨ́ ta-é-tɨ kɨ̀ mbi-m tɔ.» Pestusɨ ilə Agripa-tɨ panè: «Bore nè ya ꞌa koo ta kɨ́ ta-é-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Beɓa lokɨ lo aa lé, Agripa dḛ kɨ̀ Berenisɨ ꞌmɔ̰ne mɔ̰ne kɨ́ tò ɓəl ya, dꞌandɨ-né mḛḛ kəy gangɨ ta-tɨ natɨ kɨ̀ njèkun dɔ kutɨ asgar-je ɓudɔgɨ, ɓá kɨ̀ ꞌboy-je kɨ́ mḛḛ ɓebo Sejare-tɨ rəm tɔ. Go-tɨ, Pestusɨ un ndu adɨ dꞌɔw ꞌree kɨ̀ Pol. ");
INSERT INTO mge_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ngá ɓá Pestusɨ un ta panè: «I ngar Agripa rəm, sə̰i lay kɨ́ isi sə-ji nè kinlé, ooi dingəm kan, kɨ́ kosɨ jipɨ-je ɓəktə lay dꞌɔw dꞌingə-m ɓebo Jorijalḛm-tɨ rəm, ɓá ꞌree dꞌingə-m lo-tɨ kin nè rəm, ya ꞌtur kɔɔl ꞌpanè kadɨ-é isɨ kɨ̀ dɔ-é taá al. ");
INSERT INTO mge_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ə kɨ́ sɔbɨ dɔ-m ma̰ lé, né káre kɨ́ ḛ ra kɨ́ asɨ koy-é ya, ma̰ mꞌoo al. Bè ya ngà, ḛ ya dəjɨ kadɨ ta lə-nꞌḛ̀ tokɨ kɔw-né nɔ̰̀ Ngar-tɨ kɨ́ boy. Beɓa ma̰ mꞌɔjɨ kadɨ mꞌulə siə madɨ-é. ");
INSERT INTO mge_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ngà né kɨ́ njururu kɨ́ sɔbɨ dɔ-é, kɨ́ kadɨ mꞌndàngɨ mbete-tɨ mꞌulə-né madɨ ngar kɨ́ boy ya mꞌingə al. Gin-é kin ɓá mꞌadɨ-é ree-né nɔ̰̀-si-tɨ rəm, nɔ̰̀-i i ngar Agripa-tɨ ya kɨ̀ tagay bè, kdɔ kadɨ go ta-je-tɨ kɨ́ ꞌa dəji-é rəmə jè mꞌingə ta madɨ mꞌndàngɨ. ");
INSERT INTO mge_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kdɔtalə kɔsɨ kagɨ dɔ né-je-tɨ kɨ́ ꞌtilə ta-é dɔ dangay-tɨ al ya rəmə kulə siə ɓebo Rɔm-tɨ lé, ma̰ mꞌoo kɨ né mbə́ bè.» ");
INSERT INTO mge_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa idə Pol panè: «Tarəbɨ tò tagɨ kadɨ ꞌpa ta dɔ rɔ-i-tɨ.» Beɓa Pol ɔy ji-é kɨ taá ə pa ta dɔ rɔ-é-tɨ panè: ");
INSERT INTO mge_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«I ngar Agripa, mꞌɔw kɨ̀ rɔnəl n̰a̰, kadɨ ɓone mꞌa̰ nɔ̰̀-i-tɨ mꞌpa ta dɔ rɔ-m-tɨ, dɔ né-je-tɨ kɨ́ jipɨ-je ꞌtilə ta-é dɔ-m-tɨ kin. ");
INSERT INTO mge_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Jipɨ-je lé, nékoɓe-je lə-dé lay rəm, né-je lay kɨ́ ꞌnajɨ-na̰ ta dɔ-tɨ dɔ-tɨ kàrè, i gə majɨ n̰a̰ rəm tɔ. Beɓa kɔgri ya, mꞌdəjɨ-i kadɨ ꞌyəl mbi-i oo-né ta lə-m, kɨ̀ mḛḛ kɨ́ kilə dɔ madɨ-é-tɨ pɔ̰́ ya. ");
INSERT INTO mge_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Basa-m-tɨ nṵ ya, panjiyə-m kɨ́ dan gin dow-je-tɨ lə-m lé, jipɨ-je lay ya ꞌgə majɨ; ɓa kisɨ-m mḛḛ ɓebo Jorijalḛm-tɨ, lo kulə gin-é-tɨ nṵ ya sar ɓone kin kàrè ꞌgə majɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","To kɨ́ mꞌto kɨ́ káre dan kutɨ dow-je-tɨ kɨ́ ꞌɓa-dé Parisi-je kɨ́ ꞌto njéra ta lə pole Lubə lə-ji kadɨ nga̰ n̰a̰ kinlé, jipɨ-je lay ya ꞌgə majɨ low nṵ rəm, dḛ ya kàrè tokɨ ꞌndigɨ lé, dꞌa pa kadɨ-si ooi rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kunmindɨ kɨ́ Lubə un adɨ ka-ji-je, ə́ mꞌində mḛḛ-m dɔ-tɨ mꞌpanè né-é à ra né lé, ḛ ɓá təl gin ka̰-m logangta-tɨ ngɔsnè tin. ");
INSERT INTO mge_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kunmindɨ kinlé, gin kojɨ lə-ji kɨ́ dɔgɨ gidɨ-é joo kɨ́ ꞌpole Lubə dꞌin̰ə ta-é al, ya ndɔɔ-je kɨ̀ kada-je kinlé, dꞌində mḛḛ-dé dɔ-tɨ tɔ. I ngar, to ta lə nékində mḛḛ dɔ-tɨ kinlé, ɓá jipɨ-je ꞌtilə-né ta-je dɔ-m-tɨ tin. ");
INSERT INTO mge_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kɔbɨ ɓo! Sə̰i lé, ta lə tɔsɨ kɨ́ Lubə à kadɨ dow-je kɨ́ dꞌoy ꞌtɔsɨ ndəl dꞌində lo tḛḛ lé, kdɔ ri ɓá adi to ta kɨ́ kare wa? ");
INSERT INTO mge_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Kɨ́ sɔbɨ dɔ-m lé, ma̰ ya kɨ̀ dɔ-m kàrè ndɔkɨ mꞌrɔ kɨ̀ Jeju kɨ́ Najarɛtɨ-tɨ lé kɨ̀ tɔ́gɨ-m lay ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ḛ ɓá to né kɨ́ mꞌra mḛḛ ɓebo Jorijalḛm-tɨ, adɨ dow-je n̰a̰ dan dḛ-tɨ kɨ́ ꞌto njékaa njay-je lé, ma̰ ya mꞌungɨ-dé dangay-tɨ. To njékun dɔ njégugné-je lə Lubə ya, ɓá dꞌadɨ-m tɔ́gɨ mꞌra-né né-je kinlé rəm, lokɨ tò kadɨ ꞌtɔl njékadmḛḛ-je kàrè, mꞌilə ta-m titɨ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Dḛ lé, taá-taá ya mꞌɔw mḛḛ kəykəwna̰-je-tɨ lə jipɨ-je mꞌadɨ-dé kɔ̰̀ rəm, mꞌində tɔ́gɨ dɔ-dé-tɨ kadɨ ꞌpa takɔbɨ dɔ ta-tɨ lə Jeju, ɓá mḛḛ wɔngɨ-tɨ lə-m kɨ́ ra-m dɔ-dé-tɨ al dɔ majɨ kinlé, mꞌɔw njal mḛḛ ɓebo-je-tɨ kɨ́ dɔ ɓe mba-tɨ ya mꞌulə kəm-dé ndoo ɓəy.» ");
INSERT INTO mge_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Kdɔ né-je kinlé ya njékun dɔ njégugné-je lə Lubə dꞌadɨ-m tarəbɨ, ə dꞌadɨ-m tɔ́gɨ rəm, adɨ mꞌɔw dɔ-m kɨ ɓebo Damasɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","I ngar Agripa, à to ta kɨ́ kàdɨ̀ à ka̰ jam dɔ ɓe-tɨ je bè ngá, lokɨ mꞌɔw dɔ rəbɨ-tɨ ya ɓəy rəmə, mꞌoo londógɨ kɨ́ ndógɨ tɔy kàdɨ̀ ya ḭ dɔra̰-tɨ ree gəə dɔ-ji sipɨ kɨ̀ dow-je kɨ́ dꞌɔw sə-m. ");
INSERT INTO mge_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jḛ lay ya jꞌtusɨ nangɨ ə mꞌoo ndi dow pa sə-m ta kɨ̀ ta Əbrə panè: «Sol, Sol, kdɔ ri ɓá ꞌulə kəm-m ndoo bè wa?» Nékatɨ kɨ́ ꞌtɔsɨ-né kutɨ-i lé, tokɨ i ꞌnjirə kutɨ-i kɨ gogɨ-gogɨ ə à kusɨ rɔ-i-tɨ palangɨ ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Beɓa mꞌilə-é-tɨ mꞌpanè: I ꞌto ná̰ wa, ꞌƁaɓe? ꞌƁaɓe ilə-m-tɨ panè: «To ma̰ Jeju kɨ́ ꞌisɨ ꞌulə kəm-m ndoo lé ya. ");
INSERT INTO mge_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ngà ꞌubə nangɨ ḭ ꞌa̰ dɔ nja-i-tɨ taá. Yən, mꞌtḛḛ sə-i kɔy kdɔ kində-i kadɨ ꞌto ngonnjèkullə lə-m. Né-je kɨ́ ꞌoo kɨ̀ kəm-i ngá kin rəm, ḛ kɨ́ mꞌa tḛḛ sə-i kɔy kdɔ kadɨ ꞌoo ɓəy kinlé, i ɓá ꞌa to njèkɔr go-é kadɨ dow-je dꞌoo. ");
INSERT INTO mge_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mꞌa taa-i kilə-i taá ji gin dow-je-tɨ kin rəm, ji gin dow-je-tɨ kɨ́ ꞌto jipɨ-je al kɨ́ mꞌa kulə-i rɔ-dé-tɨ kin, ");
INSERT INTO mge_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kdɔ kadɨ ꞌɔw ꞌtḛḛ kəm-dé kadɨ ꞌtḛḛ kɔgɨ londul-tɨ ə dꞌɔw lo-tɨ kɨ́ ndógɨ rəm, kadɨ ꞌtḛḛ kɔgɨ gin tɔ́gɨ-tɨ lə Sata̰ ə dꞌɔw gin tɔ́gɨ-tɨ lə Lubə rəm, kdɔ kadɨ lokɨ dꞌadɨ-m mḛḛ-dé rəmə, Lubə in̰ə go majal-je lə-dé kɔgɨ adɨ-dé rəm, ɓá kdɔ kadɨ dꞌingə-né nékugə dɔji natɨ kɨ̀ dow-je kɨ́ Lubə ɔr-dé ində-dé tagay kin rəm tɔ.» ");
INSERT INTO mge_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«I ngar Agripa, né kin ɓá, mꞌtəl-né rɔ-m go né-tɨ kɨ́ dɔra̰-tɨ kɨ́ ra-m tokɨ nḭ bè kin tin.» ");
INSERT INTO mge_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ngà ma̰ lé, mꞌilə mbḛ Poyta kɨ́ Majɨ mꞌadɨ dow-je kɨ́ ɓebo Damasɨ-tɨ ya kete, ɓá dḛ kɨ́ ɓebo Jorijalḛm-tɨ, kɨ̀ dḛ kɨ́ dɔnangɨ Jude-tɨ rəm, ɓá mꞌadɨ dḛ kɨ́ ꞌto jipɨ-je al mꞌpanè: Kadɨ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ə ꞌree rɔ Lubə-tɨ rəm, kadɨ kullə ra-dé tuwə kullə ra dow-je kɨ́ dꞌin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ ɓane. ");
INSERT INTO mge_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Né kin ɓá jipɨ-je ꞌtətɨ-m-né dꞌuwə-m mḛḛ kəy-tɨ lə Lubə ya ə ꞌsangɨ kadɨ ꞌtɔl-m-né lé tin. ");
INSERT INTO mge_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ngà Lubə ngəm-m sar mḛḛ ndɔ-tɨ kin, adɨ ma̰ mꞌpa ta liə madɨ ngan dow-je kɨ̀ dow-je kɨ́ boy tin. Mꞌpa ta mꞌadɨ tɔɔ ur rangɨ al, ngà to né-je kɨ́ Moiyijɨ-je kɨ̀ njépata-je kɨ́ ta Lubə-tɨ ꞌpa ꞌpanè à ra né lé, ya ɓá mꞌpa, ");
INSERT INTO mge_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","adɨ to ta lə Kristɨ kɨ́ à kingə kɔ̰̀ rəm, ɓá ḛ ya à to dow kɨ́ dɔsa̰y kɨ́ à tɔsɨ ndəl kində lo tḛḛ ə à kilə mbḛ londógɨ kɨ́ sɔbɨ dɔ kajɨ kadɨ jipɨ-je rəm, kadɨ gin dow-je kɨ́ ꞌto jipɨ-je al rəm lé. ");
INSERT INTO mge_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol a̰ ɔr go né-je kinlé bè, pa-né ta dɔ rɔ-é-tɨ ya rəmə Pestusɨ pa ta kɨ̀ ndi-é kɨ́ boy panè: «Pol, i lé dɔ-i majɨ al wa! Négə lə-i kɨ́ n̰a̰ lé, ra-i adɨ dɔ-i tò dana̰ al wa!» ");
INSERT INTO mge_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ngà Pol ilə-é-tɨ panè: «Kay! Pestusɨ dow kɨ́ boy! Dɔ-m majɨ al al! To ta-je kɨ́ tɔgrɔ-tɨ rəm, ta-je kɨ́ kəm kaa njay-njay ya ɓá mꞌpa tin. ");
INSERT INTO mge_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ngar Agripa dəjɨ ta dɔ né-je-tɨ kinlé, oo majɨ. Né kin ɓá mꞌpa-né mꞌadɨ-é kɨ̀ mḛḛ-m kɨ́ nda ka̰y tin. Mꞌgə majɨ, kɨ́ né-je kɨ́ ra né kinlé, ḛ káre kɨ́ lo-é à kiyə Agripa ya goto, kdɔtalə to né-je kɨ́ ra né lo ɓɔyɔrɔ-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ngar Agripa, i adɨ mḛḛ-i ta-je kɨ́ njépata-je kɨ́ ta Lubə-tɨ ꞌpa lé ya al wa? Mꞌgə tokɨ i adɨ mḛḛ-i ta-je lə-dé ya!» ");
INSERT INTO mge_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa idə Pol panè: «Nà̰y ndḛ bè kadɨ uwə-m kɨ̀ ta kadɨ mꞌtəl njèkun go Kristɨ lé ya!» ");
INSERT INTO mge_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Beɓa Pol ilə-é-tɨ panè: «Lé nà̰y ndḛ bè əse nà̰y n̰a̰ kàrè, ma̰ mꞌisɨ mꞌpa ta kɨ̀ Lubə kadɨ i par al, ngà kadɨ dow-je lay kɨ́ dꞌisɨ dꞌoo ta lə-m ɓone kin ya ꞌtəl titɨ-na̰ kɨ́ ma̰ mꞌisɨ-né kin bè. Ngà sil-je kin ya par ə kadɨ labɨ mbɔ́-si al!» ");
INSERT INTO mge_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ngar Agripa rəm, gubərnər Pestusɨ rəm, Berenisɨ rəm, ɓá dḛ kɨ́ dꞌisɨ sə-dé lé dꞌḭ taá. ");
INSERT INTO mge_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Beɓa lokɨ dꞌisɨ dꞌɔr rɔ-dé kɨ rangɨ lé, ꞌpa-na̰ ta ꞌpanè: «Dingəm kinlé, né káre ya kɨ́ ḛ ra kɨ́ asɨ koy əse asɨ dangay ya goto.» ");
INSERT INTO mge_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Go-tɨ, Agripa idə Pestusɨ panè: «Dingəm kinlé, to dəjɨ kɨ́ ḛ ya dəjɨ kadɨ ta lə-nꞌḛ̀ ɔw nɔ̰̀ Sejar-tɨ ngá kin al lé, lé à tokɨ kilə-é taá kɨ́ kilə ya bè.» ");
INSERT INTO mge_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lokɨ dꞌun ndu kadɨ jꞌal mḛḛ bato-tɨ jꞌɔw dɔnangɨ Itali-tɨ lé, dꞌulə Pol kɨ̀ dangay-je kɨ́ dan-tɨ-je ji dingəm-tɨ kɨ́ ꞌɓa-é Juliyusɨ kɨ́ to njèkun dɔ kutɨ asgar-je kɨ́ ɓu, kɨ́ ꞌto «asgar-je lə Ogustɨ.» ");
INSERT INTO mge_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bato káre kɨ́ mḛḛ ɓebo Adramitɨ kɨ́ tò kadɨ à kun kɨ̀ kàdɨ̀ kɔngɨ-kɔngɨ kɨ́ dɔnangɨ Aji-tɨ, ɓá jꞌal mḛḛ-é-tɨ jꞌɔw. Aristarkɨ kɨ́ to dow kɨ́ mḛḛ ɓebo Tesalonikɨ-tɨ, dɔnangɨ Maseduwan-tɨ ɔw sə-ji natɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lo aa go-tɨ, lokɨ jꞌuwə nangɨ ndḛ ɓebo Sidɔ̰-tɨ lé, Juliyusɨ kɨ́ to njèra majɨ kɨ́ Pol Pol lé, in̰ə tarəbɨ adɨ-é ɔw rɔ nam-é-je-tɨ kadɨ ꞌra siə. ");
INSERT INTO mge_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Lokɨ jꞌḭ lo-é-tɨ nɔ̰ɔ̰ lé, jꞌun kɨ̀ kàdɨ̀ kɔngɨ kɨ́ dɔnangɨ Siprə-tɨ kɨ́ tò dan ba-tɨ, kdɔ yə́l ulə tilə kəm-ji. ");
INSERT INTO mge_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lokɨ jꞌində babo kɨ́ tò ngɔsi kɨ̀ dɔnangɨ Silisi kɨ̀ dɔnangɨ Pampili jꞌgangɨ lé, jꞌree tḛḛ ɓebo Mira, dɔnangɨ Lisi-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lo-é-tɨ nɔ̰ɔ̰, njèkun dɔ kutɨ asgar-je kɨ́ ɓu lé, ingə bato káre kɨ́ ɓebo Alegjandri-tɨ kɨ́ isɨ ɔw dɔnangɨ Itali-tɨ rəmə, adɨ jꞌal mḛḛ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ndɔ n̰a̰ ya bato lé, a̰y ngɔdɨ lɔw al, adɨ jꞌingə kɔ̰̀ n̰a̰, ɓá jꞌtḛḛ ngɔsi kɨ̀ ɓebo Nidɨ. Ngà yə́l ɔgɨ-ji kɔw kəm-ji kɨ kete, beɓa jḛ jꞌal kɨ̀ kàdɨ̀ kɔngɨ dɔnangɨ Krɛtɨ-tɨ, jꞌɔw kɨ Salmone. ");
INSERT INTO mge_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nga̰ sə-ji n̰a̰, ɓá jꞌree kɨ̀ kàdɨ̀ kɔngɨ sar jꞌree jꞌtḛḛ lo-tɨ kɨ́ ꞌɓa-é «lo ka̰ bato-je kɨ́ to lo kɨ́ kurə́» kɨ́ tò ngɔsi kɨ̀ ɓebo Laje. ");
INSERT INTO mge_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Dɔkaglo dəə dɔ-ji-tɨ tin asɨ ta-tɨ rəm, ɓá ndɔ kɔgɨ rɔ nékuso kɨ̀ man ka̰y lə jipɨ-je, kdɔ kadɨ Lubə in̰ə-né go majal lə-dé kɔgɨ lé tɔy rəm, adɨ lo kadɨ bato a̰y dan ba-tɨ kàrè təl ndɔjɨ ta n̰a̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Né kin ɓá Pol ndəjɨ-dé-né kete panè: «Kama̰-je, ma̰ mꞌoo kɨ́ kɔw mba lə-ji kinlé, à to bato kin par ɓá à tujɨ al rəm, à to né-je kɨ́ mḛḛ-é-tɨ par al rəm, ngà jə̰i dow-je ya kàrè jꞌa kḭ kingəi tujɨ titɨ.» ");
INSERT INTO mge_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ngà njèkun dɔ asgar-je kɨ́ ɓu lé, ta lə njèkuwə ngɔw bato lé rəm, ta lə ꞌɓa njèbato ɓá uwə mḛḛ-é n̰a̰, tɔy ta-je lə Pol. ");
INSERT INTO mge_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Rəm ta lə majɨ kɨ́ lo ka̰ bato-je kin majɨ kisɨ-tɨ na̰y kul-tɨ al lé, dow-je kɨ́ n̰a̰ ꞌndigɨ kadɨ tokɨ kɔw kete, ə́ kinə lo-é tò rəmə, tokɨ kɔw tḛḛ Penisɨ, lo ka̰ bato-je-tɨ, dɔnangɨ Krɛtɨ-tɨ ngá tá-je tokɨ kuwə lo kisɨ-tɨ kadɨ na̰y kul dəə-né. Lo ka̰ bato-je kinlé, tò mbunə̰ lo-tɨ kɨ́ bəə kɨ̀ lo kur kàdɨ̀. ");
INSERT INTO mge_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lokɨ yə́l kɨ̀ tɔ́gɨ-é n̰a̰ al, ḭ kɨ bəə bè ulə dan pèèè rəmə, dḛ ꞌgɨr kɨ́ kɔjra lə-dé à kusɨ kɔdɨ. Beɓa dꞌun ngɔw là kuwə bato nangɨ dan man-tɨ, dꞌilə mḛḛ bato-tɨ, ə dꞌun kɨ̀ kàdɨ̀ kɔngɨ dɔnangɨ Krɛtɨ-tɨ ngɔsi-ngɔsi dꞌɔw. ");
INSERT INTO mge_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ngà sḛ go-tɨ ya rəmə, yə́lbo kɨ́ ꞌɓa-é Ərakilɔ̰, ḭ kɨ dɔnangɨ Krɛtɨ-tɨ kɨ́ tò dan ba-tɨ ulə mbḭ-mbḭ ree dɔ-ji-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yə́l kinlé, un bato dɔ-é-tɨ, adɨ lo kadɨ bato ta̰ dan-tɨ lé goto, rəmə jḛ jꞌin̰ə rɔ-ji yakɨ jꞌadɨ ɔw sə-ji kɨ nɔ̰ɔ̰ bin ya par ngá. ");
INSERT INTO mge_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Beɓa jꞌɔw jꞌtḛḛ kəl lo-tɨ kɨ́ bəə kàdɨ̀ ngon dɔnangɨ-tɨ kɨ́ ꞌɓa-é Koda kɨ́ to lo kɨ́ dan ba-tɨ. Lo kinlé, ɓá taá yə́l dɔ-ji-tɨ, ngà rəmə jꞌra lo ra-é-tɨ bè ɓá jꞌuwə ngon tò kɨ́ ꞌtɔ́-é kutɨ bato-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Lokɨ dꞌun ngon tò kɨ́ kutɨ bato-tɨ lé dꞌində mḛḛ-é-tɨ rəmə, dꞌɔy kulə-je ꞌɓindɨ-né bato lé ɓindɨ-ɓindɨ. Dḛ ꞌɓəl kadɨ bato ḭ ɔw ɔsɨ-ji dɔ nangra-tɨ, lo-tɨ kɨ́ ꞌɓa-é Sirtɨ, adɨ ꞌtutɨ takubɨ kɨ́ taá kɨ́ njèkadɨ bato a̰y ngɔdɨ n̰a̰ lé, dꞌilə mḛḛ bato-tɨ. Beɓa bato lé ɔw sə-ji kɨ nɔ̰ɔ̰ bè ya par ngá. ");
INSERT INTO mge_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yə́l lé, ulə dɔ-ji-tɨ kɨ̀ tɔ́gɨ-é bè-bè ya sar lo aa-né rəmə, dḛ dꞌɔy né-je kɨ́ ꞌná̰-je kɨ́ tò mḛḛ bato-tɨ lé, dꞌungɨ kɔgɨ dan babo-tɨ, ");
INSERT INTO mge_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","rəm ndɔ kɨ́ njèkungɨ-tɨ mutə lé, dḛ ya dꞌɔy né-je kɨ́ bato-tɨ kɨ̀ ji-dé ꞌtilə mani. ");
INSERT INTO mge_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndɔ n̰a̰ ya kəm-ji oo kàdɨ̀ al rəm, oo kərwəḭ-je al rəm. Yə́l lé, ulə kɨ̀ tɔ́gɨ-é n̰a̰ ya par-par, adɨ dow kɨ́ gɨr mḛḛ-é-tɨ panè jꞌa kajɨ ya goto. ");
INSERT INTO mge_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Dow-je kɨ́ mḛḛ bato-tɨ lé, dꞌuso né al ya ndɔ n̰a̰. Beɓa Pol ḭ a̰ taá dan-dé-tɨ idə-dé panè: «Kama̰-je, lé tokɨ ꞌtəli rɔ-si go takɔjɨ-tɨ lə-m, adɨ jꞌisi Krɛtɨ-tɨ, rəmə lé ko-ji à tɔ bè al rəm, ɓá a kungi né-je kɔgɨ bè al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ngà kɨ́ ngɔsnè-tɨ kinlé, mꞌulə dingəm mḛḛ-si-tɨ kadɨ uwəi rɔ-si nga̰. Kdɔtalə dow káre ya kàrè à koy dan-si-tɨ al. Ngà bato lé ya kɨ̀ kár-é ɓá à tujɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Lubə lə-m kɨ́ mꞌisɨ mꞌpole lé, malayka liə káre ree rɔ-m-tɨ ndɔɔ nè, ");
INSERT INTO mge_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","idə-m panè: “Pol, ꞌoo bè, né káre ya kàrè ꞌɓəl al, ꞌa kɔw tḛḛ lo gangta-tɨ nɔ̰̀ ngar Sejar-tɨ ya, rəm ɓá Lubə à ngəm dow-je lay kɨ́ dꞌisɨ sə-i mḛḛ bato-tɨ lé rəm tɔ.” ");
INSERT INTO mge_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Beɓa kama̰-je, uwəi rɔ-si nga̰. Ma̰ mꞌadɨ mḛḛ-m Lubə, Lubə à tḛḛ sə-ji titɨ kɨ́ malayka pa-né adɨ-m lé ya. ");
INSERT INTO mge_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ngà kɔsɨ ɓá jꞌa kɔwi kɔsi dɔ-ji dɔnangɨ-tɨ madɨ kɨ́ tò dan ba-tɨ.» ");
INSERT INTO mge_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","To ndɔ dɔgɨ gidɨ-é sɔ ɓone ngá ə́ yə́l ɔsɨ-ji yó-je kɨ nè-je par-par dan babo-tɨ kɨ́ ꞌɓa-é Adɨriyatikɨ, rəmə dan lo bapɨ lé, njérakullə-je kɨ́ mḛḛ bato-tɨ lé, ꞌgɨr kɨ́ jꞌa̰ ngɔsi kɨ̀ dɔnangɨ madɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lokɨ dꞌun né mbɔjɨ ku lə man dꞌilə mani kdɔ koo rəmə, ɔw nangɨ asɨ njiyə kɨ́ dow à njiyə nja-é kɔrmutə gidɨ-é siri. Dꞌɔw kete əbɨ ndḛ lé, ꞌtəl dꞌilə né lé ya ɓəy rəmə, ɔw nangɨ asɨ njiyə kɨ́ dow à njiyə nja-é kɔrjoo gidɨ-é jinà̰y joo. ");
INSERT INTO mge_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ꞌƁəl kadɨ bato ɔw dar rɔ-é ər-tɨ kɨ́ boy n̰a̰ kɨ́ dan ba-tɨ, beɓa ngɔwla kuwə bato nangɨ dan man-tɨ lé, dꞌungɨ sɔ kutɨ-é-tɨ gogɨ dan man-tɨ, ə ꞌndingə kadɨ lo aa kalangɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ngà njérakullə mḛḛ bato-tɨ lé, ꞌsangɨ rəbɨ ka̰y-na̰ kin̰ə bato lé, adɨ dꞌun ngon tò kɨ́ mḛḛ bato-tɨ lé, dꞌilə dan babo-tɨ, rəmə ꞌra rɔ-dé titɨ-na̰ né kɨ́ dꞌɔw kɨ̀ kɔy ngɔwla kuwə bato nangɨ kɨ́ tò kete nɔ̰̀-é-tɨ, kdɔ kungɨ mani bè. ");
INSERT INTO mge_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Beɓa Pol idə njèkun dɔ kutɨ asgar-je kɨ́ ɓu kɨ̀ ndəgɨ asgar-je panè: «Kinə dow-je kin dꞌisɨ sə-si mḛḛ bato-tɨ kin al lé, dow káre kɨ́ dan-si-tɨ kɨ́ à kajɨ ya goto.» ");
INSERT INTO mge_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Beɓa asgar-je ꞌtijə kulə ngon tò lé ꞌgangɨ ə dꞌin̰ə dꞌadɨ ɔw. ");
INSERT INTO mge_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kete ɓá kadɨ lo aa lé, Pol ulə dingəm mḛḛ dow-je-tɨ lay ya kadɨ dꞌuso né. Ḛ panè: «Ɓone to ndɔ dɔgɨ gidɨ-é sɔ ngá kɨ́ mḛḛ-si a̰ kə́kə́kə́ rəm, usoi né al rəm. ");
INSERT INTO mge_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Beɓa kɨ́ ngɔsnè-tɨ kinlé, mꞌdəjɨ-si kɨ́ ta kɔ̰̀-m-tɨ kadɨ usoi né. Nékuso lé, à ra kadɨ isi kɨ̀ dɔ-si taá. Dow kɨ́ dan-si-tɨ kɨ́ bəl dɔ-é káre à kɔr kusɨ kɔgɨ ya goto.» ");
INSERT INTO mge_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Lokɨ Pol pa ta-je kin bè lay rəmə, un mbə̀ ra oiyo Lubə dɔ-tɨ takəm-dé-tɨ lay, ə uwə gangɨ uso. ");
INSERT INTO mge_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bè ngá ɓá, dḛ lay ya dꞌuwə rɔ-dé nga̰ dꞌuso né tɔ. ");
INSERT INTO mge_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Jḛ lay kɨ́ jꞌisɨ mḛḛ bato-tɨ lé, jḛ ɓujoo kɨ̀ kɔrsiri gidɨ-é mɛkḛ. ");
INSERT INTO mge_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lokɨ dꞌuso né asɨ-dé lé, dꞌɔy gemḛ kɨ́ mḛḛ bato-tɨ lé, dꞌungɨ dan babo-tɨ adɨ bato lé, ɔle pèl. ");
INSERT INTO mge_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lokɨ lo aa rəmə, njérakullə mḛḛ bato-tɨ lé, ꞌgə lo al. Ngà tɔɔ man kɨ́ ɔw tḛḛ ngangɨ ba-tɨ par ə dꞌoo, ə ꞌndigɨ kadɨ kinə lo-é à tò rəmə, tokɨ kɔw kɨ̀ bato lé, jan-jan titɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Beɓa dḛ ꞌtutɨ ngɔwla-je kɨ́ dꞌuwə-né bato nangɨ lé dꞌin̰ə dan babo-tɨ ə ꞌtutɨ kulə tɔ́ ngɔw bato lé, ɓəy ngá ɓá dꞌun takubɨ kɨ́ njètaa yə́l dɔ bato-tɨ kɨ́ tò kutɨ-é-tɨ gogɨ lé ꞌtɔ́ taá ə dꞌɔw kɨ dɔ nangra-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ngà bato lé, ree dar nangra kɨ́ lo kingə-na̰-tɨ lə man-je joo adɨ nɔ̰̀ bato lé dubɨ-tɨ jigɨ-jigɨ, adɨ lo kɔtɨ kete goto. Rəmə tɔ́gɨ pungum man ya ində kutɨ bato lé adɨ tə́tɨ njukɨ-njukɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asgar-je dꞌadɨ ta-dé asɨ-na̰ kadɨ nꞌtɔli dangay-je lay nè dow káre dan-dé-tɨ à kḭ kusɨ mani kale ka̰y kɔw. ");
INSERT INTO mge_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ngà njèkun dɔ kutɨ asgar-je kɨ́ ɓu ndigɨ kajɨ Pol, adɨ ɔgɨ-dé ra né kɨ́ dꞌɔjɨ kinlé. Ḛ un ndu kadɨ dḛ lay kɨ́ ꞌgə kale man, dꞌungɨ-na̰ mani kete, ə dꞌale ꞌtḛḛ ndaa-tɨ dɔ nangɨ-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ə kadɨ ndəgɨ-dé-je ꞌtin̰ə kàdɨ̀ kagɨ-je-tɨ kɨ́ tatɨ-je, kɨ̀ kàdɨ̀ gajɨ bato-tɨ lé, kdɔ tḛḛ-né ndaa-tɨ tɔ. Gangɨ-é kin ya dow-je lay ꞌtḛḛ-né ndaa-tɨ ɓɨ né madɨ ra-dé al. ");
INSERT INTO mge_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Lokɨ jꞌtḛḛ ta yo-tɨ ngá rəmə, dow-je dꞌidə-ji kɨ́ dɔnangɨ kɨ́ tò dan man-tɨ lo kɨ́ jꞌa̰-tɨ kinlé ri-é lə Maltɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Dow-je kɨ́ dɔnangɨ-é-tɨ kinlé, ꞌra sə-ji majɨ ra kɨ́ ga̰-é goto. Dḛ ꞌra pər ɗikɨ-ɗikɨ ə ꞌɓa-ji ta-tɨ dꞌadɨ jꞌndibɨ, kdɔ ndi isɨ ədɨ rəm, ɓá kul kàrè ɔ̰̀ n̰a̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Lokɨ Pol saa ngəngrə ungɨ dan pər-tɨ rəmə, kunjɨ pər ra adɨ li pi tḛḛ-tɨ tin̰ə ji-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lokɨ dow mḛḛ ɓe-je kɨ́ dɔnangɨ-tɨ kin, dꞌoo kɨ́ li lé, tin̰ə ji Pol-tɨ rəmə, ꞌpa ta dan-dé-tɨ ꞌpanè: «Tɔgrɔ-tɨ, dingəm kinlé, to njètɔl dow-je. Né kin ə́ tḛḛ-né ta yo-tɨ dan babo-tɨ ya kàrè, Lubə kɨ́ njèra né kɨ́ njururu ndigɨ kadɨ-é isɨ-né kɨ̀ dɔ-é taá al tin.» ");
INSERT INTO mge_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ngà Pol tusɨ li lé ilə-é dan pər-tɨ, ə rɔ-é kàrè dɔ̰-é njam al rəm. ");
INSERT INTO mge_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Dow-je lé, dꞌa̰ ꞌngəbɨ kadɨ rɔ Pol tii əse kadɨ usɨ brɨkɨ ya oy tajinatɨ nè. Ngà lokɨ ꞌngəbɨ tó-dé uu n̰a̰ ya dꞌoo kɨ́ né madɨ tò gay rɔ Pol-tɨ al lé, ꞌtəl ꞌpa ta kɨ́ rangɨ ꞌpanè: Dingəm kan to magɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Dow kɨ́ boy kɨ́ dɔnangɨ-tɨ kɨ́ tò dan ba-tɨ kinlé, kəy liə tò mbɔ́ lo-tɨ kinlé nɔ̰ɔ̰ ə ri-é lə Publiyusɨ. Ḛ uwə-ji kɨ rɔ-é-tɨ majɨ n̰a̰ rəm, ɓá adɨ-ji kəy jꞌtò-né ndɔ mutə rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Bɔbɨ Publiyusɨ tò mɔ̰y nangɨ. ꞌNingə́ ində-é adɨ rɔ-é tungə pil-pil rəm, ɓá ndəngɨ məsɨ rəm tɔ. Pol ɔw kəy go-é-tɨ, pa ta kɨ̀ Lubə kdɔ ta liə, ində ji-é dɔ-é-tɨ adɨ ingə lapiya. ");
INSERT INTO mge_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Go-tɨ, njémɔ̰y-je kɨ́ rangɨ kɨ́ dꞌisɨ dɔnangɨ-tɨ kin kɨ́ tò dan ba-tɨ lé, kàrè ꞌree dꞌingə Pol, ə dꞌingə lapiya ya tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Dow-je dꞌun ta-ji n̰a̰ lo-é-tɨ nɔ̰ɔ̰ rəm, ɓá lokɨ ndɔ asɨ kadɨ jꞌɔw ngá kàrè, dḛ dꞌadɨ-ji né-je kɨ́ jꞌɔw ndoo-é rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Go na̰y-tɨ kɨ́ mutə lé, jḛ jꞌal mḛḛ bato-tɨ madɨ kɨ́ Alegjandri-tɨ kɨ́ ri-é lə «Magɨ ndungə-je» kɨ́ na̰y kul gangɨ dɔ-é-tɨ dɔnangɨ Maltɨ-tɨ kɨ́ tò dɔnangɨ kɨ́ tò dan ba-tɨ lé. ");
INSERT INTO mge_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Jḛ jꞌɔw jꞌtḛḛ mḛḛ ɓebo Sirakusɨ-tɨ ɓá jꞌuwə nangɨ titɨ asɨ ndɔ mutə bè. ");
INSERT INTO mge_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Jꞌun rəbɨ kɨ̀ kàdɨ̀ kɔngɨ-kɔngɨ jꞌree mḛḛ ɓebo Regio-tɨ. Lo aa go-tɨ, yə́lbo ulə asɨ ndɔ joo rəmə, jꞌtḛḛ mḛḛ ɓebo Pujol-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mḛḛ ɓebo-tɨ kinlé, jḛ jꞌingə njékadmḛḛ-je ə dꞌuwə-ji mba ə ꞌra kɔgri kadɨ jꞌisɨ rɔ-dé-tɨ ndɔ siri. Beɓa jḛ jꞌilə dɔ-ji jꞌɔw-né kɨ mḛḛ ɓebo Rɔm-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Lokɨ njékadmḛḛ-je kɨ́ ɓebo Rɔm-tɨ dꞌoo poy-ji lé, ꞌtilə kəm-ji sar ꞌtḛḛ lo sukɨ-tɨ kɨ́ ɓebo Apiyusɨ-tɨ rəm, ɓá kəy tò mba-je-tɨ kɨ́ tò ta-na̰-tɨ mutə kin rəm tɔ. Lokɨ Pol oo-dé lé, ḛ ra oiyo Lubə rəm, ɓá rɔ-é nga̰ rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Lokɨ jꞌree tḛḛ mḛḛ ɓebo Rɔm-tɨ lé, njèkun dɔ kutɨ asgar-je kɨ́ ɓu in̰ə dangay-je kɨ́ lay ji gɔ̰rɔ-tɨ káre, ngà Pol ɓá dꞌin̰ə-é dꞌadɨ tò kəy liə gay ə dꞌadɨ asgar káre ində kəm-é go-é-tɨ tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ndɔ mutə go-tɨ, Pol ɓa ꞌboy-je lə jipɨ-je rɔ-é-tɨ mḛḛ ɓebo Rɔm-tɨ. Lokɨ dḛ ꞌkəw-na̰ lé, Pol idə-dé panè: «Ngankɔ̰-m-je, mꞌoo né káre kɨ́ mꞌra mꞌɔsɨ-né ta gin dow-je lə-m al rəm, ɓá mꞌɔsɨ-né ta nékoɓe-je lə ka-ji-je al rəm, ya rəmə dꞌuwə-m dangay-tɨ mḛḛ ɓebo Jorijalḛm-tɨ, ə dꞌilə-m ji dow-je-tɨ kɨ́ Rɔm. ");
INSERT INTO mge_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Beɓa lokɨ ꞌndər gin ta lə-m lé, ꞌndigɨ kilə-m taá, kdɔtalə dꞌingə ta madɨ kɨ́ asɨ kadɨ ꞌgangɨ-né ta koy dɔ-m-tɨ al. ");
INSERT INTO mge_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ngà lokɨ jipɨ-je ꞌndigɨ al lé, ma̰ mꞌdəjɨ kadɨ Sejar ɓá gangta lə-m, ɓɨ mꞌgɨr mḛḛ-m-tɨ kdɔ kilə ta dɔ gin dow-je-tɨ lə-m al. ");
INSERT INTO mge_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Gin-é kin ɓá mꞌdəjɨ kadɨ mꞌoo-si-né rəm, ɓá kadɨ mꞌpa-né sə-si ta rəm tin. Ma̰ lé, to ta lə nékində mḛḛ dɔ-tɨ lə-ji jə̰i Israyel-je ɓá dꞌilə-m-né sil tin.» ");
INSERT INTO mge_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Dḛ dꞌilə-é-tɨ panè: «Jḛ jꞌingə mbete kɨ́ dɔ-i-tɨ káre kɨ́ ḭ dɔnangɨ Jude-tɨ al rəm, ɓá ngonkɔ̰-ji káre ya kàrè ree ɔr-ji poyta lə-i adɨ jꞌoo al rəm tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ngà jḛ jꞌndigɨ kadɨ i ya ꞌpa ta kɨ́ mḛḛ-i-tɨ adɨ jꞌoo. Kdɔtalə néndó kɨ́ i un go-é lé, lo-je lay ya dow-je dꞌɔsɨ ngərəngɨ.» ");
INSERT INTO mge_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Dḛ dꞌɔr ndɔ dꞌadɨ Pol, adɨ dow-je n̰a̰ ya ꞌree dꞌingə-é lo kisɨ-é-tɨ. Beɓa ḛ ɔr-dé gin ta-je kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə. Pol sangɨ kadɨ nꞌuwə-dé kɨ̀ ta sɔbɨ dɔ Jeju, adɨ ulə gin-é dɔ ndukun-je-tɨ lə Moiyijɨ rəm, dɔ mbete-je-tɨ lə njépata-je kɨ́ ta Lubə-tɨ ɓá pa-né sə-dé ta. Pol ɔr gin ta lé, kɨ́ ndɔge ya sar losɔlɔ pee. ");
INSERT INTO mge_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Dḛ kɨ́ ná̰-je dꞌadɨ mḛḛ-dé ta-je lə Pol, ngà dḛ kɨ́ dan-tɨ-je ꞌmbatɨ kadɨ mḛḛ-dé tɔ. ");
INSERT INTO mge_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Lokɨ ta-dé asɨ-na̰ al ɓá dꞌisɨ ꞌsane-na̰ lé, Pol idə-dé ta kin ya par panè: «Ta kɨ́ Ndil kɨ́ aa njay adɨ Ejay kɨ́ njèpata kɨ́ ta Lubə-tɨ pa adɨ ka-ji-je lé, to ta kɨ́ tɔgrɔtɨ ya. Ndil kɨ́ aa njay panè: ");
INSERT INTO mge_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ꞌƆw idə gin dow-je kin: Dꞌa koo ta majɨ ya ngà dꞌa ꞌgə mḛḛ-é al, Dꞌa koo lo majɨ ya ngà dꞌa koo né al, ");
INSERT INTO mge_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ooi, gin dow-je kanlé, ꞌto njémḛḛnga̰-je, ꞌTɔsɨ mbi-dé kə́-kə́ ꞌtɔɔ, nè mbi-dé à kḭ koo ta rəm, nè dꞌa kḭ gə né; ꞌNibɨ kəm-dé jibɨ-jibɨ, nè kəm-dé à kḭ koo lo rəm, Nè mbi-dé à kḭ koo ta rəm, nè dꞌa kḭ gə né, Rəmə dꞌa kḭ kin̰ə panjiyə-dé-je kɨ́ majɨ al kɔgɨ kadɨ mꞌḭ mꞌajɨ-dé.”» ");
INSERT INTO mge_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol təl panè, kadɨ ꞌgəi majɨ, Lubə ulə kɨ̀ ta kajɨ kinlé kɨ rɔ dow-je-tɨ kɨ́ ꞌto jipɨ-je al, ə dḛ ꞌtaa kalangɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Lokɨ Pol pa ta kin bè lé, jipɨ-je dꞌḭ ꞌnajɨ-na̰ ta n̰a̰ taá-taá dꞌɔw-né. ");
INSERT INTO mge_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol uwə kəy na̰y isɨ-tɨ ɓal joo. Dow-je lay kɨ́ ꞌree dꞌoo-é lé, ḛ uwə-dé kɨ rɔ-é-tɨ. ");
INSERT INTO mge_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pol ndó dow-je ta kɨ́ sɔbɨ dɔ kɔ̰ɓe lə Lubə rəm, ndó dow-je ta lə ꞌƁaɓe Jeju Kristɨ kɨ̀ mḛḛ nda ka̰y, ɓɨ né madɨ kɨ́ ɔgɨ-é lo-é goto.");
INSERT INTO mge_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ma̰ Pol, ngonnjèkullə lə Jeju Kristɨ kɨ́ Lubə ɓa-m adɨ-m mꞌto njèkɔwkulə, ɓá ində-m tagay kadɨ mꞌilə mbḛ Poyta kɨ́ Majɨ liə lé ɓá mꞌndàngɨ mbete kin mꞌadɨ-si; ");
INSERT INTO mge_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","– Poyta kɨ́ Majɨ kinlé, low nṵ ya ḛ un mindɨ-é kdɔ ə un kɨ̀ kəm rəbɨ kɨ́ rɔ njépata-je kɨ́ ta-é-tɨ, adɨ ta-é tò mḛḛ mbete-tɨ kɨ́ aa njay nɔ̰ɔ̰; ");
INSERT INTO mge_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","to ta kɨ́ sɔbɨ dɔ Ngon-é, kɨ́ to-é dow-tɨ rəmə, to kɨ́ ginka-tɨ lə Dabidɨ; ");
INSERT INTO mge_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ə kɨ́ sɔbɨ dɔ Ndil kɨ́ aa njay rəmə, tɔsɨ ndəl tḛḛ liə dan dow-je-tɨ kɨ́ dꞌoy ra adɨ tokɨ tɔjɨ-é ndaa-tɨ rəsɨ kɨ̀ tɔ́gɨ kɨ́ ḛ lé to Ngon lə Lubə. ");
INSERT INTO mge_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jeju Kristɨ lé to ꞌƁaɓe lə-ji. Kɨ̀ takul-é ɓá Lubə ra-né sə-ji majɨ rəm, adɨ jꞌto-né njékɔwkulə-je kdɔ kadɨ kɨ̀ ri-é rəmə, jꞌadɨ gin dow-je lay dꞌadɨ-é-né mḛḛ-dé ə ꞌtəl rɔ-dé go ta-tɨ liə, ");
INSERT INTO mge_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","adɨ sə̰i kàrè ꞌtoi dow-je kɨ́ Jeju Kristɨ ɓa-si tɔ. – ");
INSERT INTO mge_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mbete kinlé mꞌndàngɨ mꞌadɨ-si, sə̰i lay kɨ́ Lubə ində-si dan kəm-é-tɨ, ɓa-si adɨ ꞌtoi dow-je kɨ́ aai njay, kɨ́ isi ɓebo Rɔm-tɨ. Kadɨ ramajɨ, kɨ̀ lapiya lə Bɔbɨ-ji Lubə, kɨ̀ ꞌlə ꞌƁaɓe Jeju Kristɨ nà̰y sə-si. ");
INSERT INTO mge_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kete nɔ̰̀ né-je-tɨ lay lé, mꞌra oiyo Lubə lə-m kdɔ ta lə-si lay kɨ̀ takul Jeju Kristɨ, kdɔtalə poy kadmḛḛ lə-si ɔr lo kɨ́ dɔnangɨ-tɨ nè lay. ");
INSERT INTO mge_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Lubə kɨ́ mꞌisɨ mꞌra kullə liə kɨ̀ mḛḛ-m kɨ́ káre-rè kɨ̀ kəm rəbɨ kilə mbḛ Poyta kɨ́ Majɨ lə Ngon-é lé gə majɨ kɨ́ mḛḛ ta-je-tɨ kɨ́ mꞌisɨ mꞌpa siə lé mꞌnal kilə ri-si dan-tɨ al rəm, ");
INSERT INTO mge_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ɓá taá-taá ya mꞌdəjɨ-é, kadɨ kinə to ndigɨ liə rəmə, kɨ́ nè kin mꞌingə tarəbɨ mꞌɔw mꞌoo-si. ");
INSERT INTO mge_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kdɔ ɓo koo-si ra-m n̰a̰, kadɨ mꞌɔw mꞌadɨ ubəi majɨ kadkare-je madɨ lə Ndil kɨ́ aa njay kdɔ kadɨ adɨ-si tɔ́gɨ, ");
INSERT INTO mge_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","əse kdɔ kadɨ jꞌuləi dingəm mḛḛ-na̰-tɨ kɨ̀ takul kadmḛḛ kɨ́ sə̰i rəm, ma̰ rəm lay jꞌori-na̰ dɔ-tɨ. ");
INSERT INTO mge_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ngankɔ̰-m-je kɨ́ njékadmḛḛ, mꞌndigɨ kadɨ mꞌadɨ-si ꞌgəi kɨ́ taá-taá ya mꞌɔjɨ kɔw koo-si, kdɔ kadɨ mꞌoo-né kandɨ kullə lə-m dan-si-tɨ titɨ kɨ́ mꞌoo-né dan gin dow-je-tɨ kɨ́ rangɨ kin bè tɔ; ngà mꞌingə tarəbɨ al ya sar ɓone. ");
INSERT INTO mge_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","To kurə dɔ-m-tɨ kadɨ mꞌɔw rɔ njékəmtḛḛ-je-tɨ rəm, njékəmtḛḛ al-je-tɨ rəm, kadɨ mꞌɔw rɔ njénégə-je-tɨ rəm, njénégə al-je-tɨ rəm. ");
INSERT INTO mge_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Gin-é kin ya ɓá sə̰i kɨ́ isi ɓebo Rɔm-tɨ lé, ɓo kilə mbḛ Poyta kɨ́ Majɨ dan-si-tɨ ra-m-né tɔ. ");
INSERT INTO mge_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Kdɔtalə rɔ-m sɔl-m dɔ Poyta kɨ́ Majɨ-tɨ al. Poyta kɨ́ Majɨ lé, to tɔ́gɨ lə Lubə kɨ́ tò kdɔ kajɨ lə dow kɨ́ rá-rá kɨ́ adɨ mḛḛ-é, adɨ to jipɨ-je ya kete ɓəy ɓá dow-je kɨ́ ꞌto jipɨ-je al ɓəy. ");
INSERT INTO mge_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Poyta kɨ́ Majɨ lé ɓá tɔjɨ ndaa-tɨ rəsɨ kɨ́ Lubə ɔr ta dɔ dow-tɨ kɨ̀ takul kadmḛḛ rəm, kdɔ kadmḛḛ rəm, titɨ kɨ́ ꞌndàngɨ-né mḛḛ mbete-tɨ kɨ́ aa njay ꞌpanè: Dow kɨ́ njururu à kisɨ kəm kɨ̀ takul kadmḛḛ. ");
INSERT INTO mge_vpl VALUES ("RM1_18","075_1_18","RO