﻿USE sofia;
DROP TABLE IF EXISTS sofia.mgc_vpl;
CREATE TABLE mgc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mgc_vpl WRITE;
INSERT INTO mgc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nenye zutu 'ba Yësu Korisitɔ kozo 'ba Dawidi, kozo 'ba Abarayama. ");
INSERT INTO mgc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarayama ra o'jo Yisika, Yisika ra o'jo Yakoba, Yakoba ra o'jo Yuda, öndu nï ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ra o'jo Pereze Zera aba, ma zë ra Tamara, Pereze ra o'jo Ezerona, Ezerona ra o'jo Rama, ");
INSERT INTO mgc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rama ra o'jo Aminadaba, Aminadaba ra o'jo Nasona, Nasona ra o'jo Salamono, ");
INSERT INTO mgc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamono ra o'jo Bowoza, ma mo ra Raba. Bawoza ra o'jo Obede, ma mo ra Ruta. Obede ra o'jo Jese. ");
INSERT INTO mgc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese ra o'jo Dawidi vo damöku. Dawidi ra o'jo Solomono ma mo ra lu'bë pëtï Uriya. ");
INSERT INTO mgc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomono ra o'jo Rebama, Rebama ra o'jo Abiya, Abiya ra o'jo Asa. ");
INSERT INTO mgc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ra o'jo Yesopata, Yesopata ra o'jo Yorama, Yorama ra o'jo Uziya. ");
INSERT INTO mgc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya ra o'jo Yotama, Yotama ra o'jo Aza, Aza ra o'jo Ezikiya. ");
INSERT INTO mgc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezikiya ra o'jo Manase, Manase ra o'jo Amona, Amona ra o'jo Yosiya. ");
INSERT INTO mgc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya ra o'jo Yekoniya zë 'dö öndu nï ëtï kadra 'ba kïrï vïdï tï'bë Babalönï. ");
INSERT INTO mgc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tapëtï kïrï vïdï tï'bë Babalönï ne. Yekoniya ra o'jo Salatele, Salatele ra o'jo Zerobabele, ");
INSERT INTO mgc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerobabele ra o'jo Abiyuda, Abiyuda ra o'jo Elikima, Elikima ra o'jo Azora, ");
INSERT INTO mgc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora ra o'jo Zadoka, Zadoka ra o'jo Akimo, Akimo ra o'jo Eliyuda, ");
INSERT INTO mgc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda ra o'jo Elizara, Elizara ra o'jo Matana, Matana ra o'jo Yakoba, ");
INSERT INTO mgc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoba ra o'jo Yosepa kora 'ba Mariya ma 'ba Yësu ma ako'jo Korisitɔ ne. ");
INSERT INTO mgc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Here kozo ëdï kazi Abarayama zi Dawidi 'butë dɔmosowɔ, ëdï kazi Dawidi ma ï'bënnï mï Babalönï 'butë dɔmosowɔ le mï ko'jo 'ba Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nenye hala kö'du ko'jo 'ba Yësu Korisitɔ. Alivö ma mo zi koze zi Yosepa, mora gba adrɔ'bo rë nnï dë mo ayɔlɔ rë nnï mo ɔmɔ ku kyigɔ 'ba Lawo Kölö Laka aba. ");
INSERT INTO mgc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mora kora 'bɔmo Yosepa vo kö'du laka ko'dɔ mo omba dë zi gburu mo komo vïdï kayo. Mo asösu gbɔ zi kinga mo liwo. ");
INSERT INTO mgc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mora mati mo ëdï kö'du ne sösu mo here ne, malayika 'ba Yere ayada rë nï zi mo tëmï wïrï, iya henye, “Yosepa Kozo 'ba Dawidi, ere dë ta bi Mariya kïrï zi yï na mbara 'bëyï, ga kö'du wisi mï mo ne Lawo Kölö Laka ra ï'dï mo ɔmɔ. ");
INSERT INTO mgc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mo ako'jo na wisi kora akako'jo ru mo Yësu ga kö'du mo ra akakɔnyi vïdï 'bënï 'e tëmï kö'du kyënyë 'bëzë.” ");
INSERT INTO mgc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kö'du ne biya o'dɔ rë nï zi tëdï kaa Wïrï ï'dï me'do mo ku kyere zi nëbï, iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Wu'jë maako gba na wu'jë ngulu ako'jo wisi kora akako'jo ru mo Imanowele, mï me'do ne iya henye, “Wïrï ëdï ze aba.” ");
INSERT INTO mgc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mora Yosepa ongɔ here oze Mariya gbɔ kaa malayika 'ba Wïrï iya zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mati gba zë ïrï dë nnï dë Mariya aba mo o'jo wisi ënï ne na kora, mora mo ï'dï ru mo gbɔ Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","O'jo Yësu ku Beteleme mï dakaŋo 'ba Yudiya mï kadra 'ba Heroda vo damöku. Mora vo me'do yɔlɔ maako'e ayinnï ta humïrë ɔkɔnnï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Zë ako'jonnï henye, “Wisi ma o'jo kinye na yere 'ba Yuda'e ne, mo ëdï kila? Dongɔ kyëlu ɔmo ma ayi ta humïrë ne dayi ze zi mo yeto.” ");
INSERT INTO mgc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mati Heroda owo kö'du ne here, mï mo ënyï umbë gbɔ mora vïdï 'ba Yerusalema maako'e mï zë umbë kpa. ");
INSERT INTO mgc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mora mo ako'jo vo da karasa'e 'dö vo komoyandi 'ba kö'du kida'e gbɔ ti'de mayinnï zi nï, mora mo ako'jo hë zë, mo iya henye, “Kɔdɔ here, Korisitɔ ne ako'jo kila?” ");
INSERT INTO mgc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Zë aya'bannï da me'do iyannï henye, “Ako'jo Korisitɔ ne mï Beteleme mï dakaŋo 'ba Yudiya, ga kö'du nëbï maako ayöru kö'du ne ku kyere iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mï, Beteleme, mï dakaŋo 'ba Yudiya, anza dë tisiwa aba mï yere'e 'ba Yuda ne. Vïdï ma kyedre atasi ndö tëmï 'e mora mo akagaga vïdï 'bama 'ba Yiserele.’” ");
INSERT INTO mgc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mora Heroda ako'jo vo kö'du yɔlɔ ne'e gbɔ liwo tayinnï zi nï mo ako'jo kadra 'ba tasi 'ba kyëlu nani kazi zë. ");
INSERT INTO mgc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mora mo utu zë gbɔ Beteleme kö'du kira nenye'e aba, “Ï'bë oma'e bi liya na laka kö'du wisi ne, ëzë i'ja'e mo ku ayi iya'e kö'du mo zi ma, tï'bë kpa mo yeto.” ");
INSERT INTO mgc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mati zë owonnï me'do kiya 'ba Heroda ne ku zë ënyïnnï gbɔ tï'bë. Zë ongɔnnï te kyëlu ma zë ongɔnnï ta humïrë ne. Kyëlu ne alaga nduwë dagba zi zë le ï'bë ɔrɔ ga bi ma wisi Yësu ëdï dɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mati zë ongɔnnï ku here ne, zë gbɔ mï kyëyï kyedre aba. ");
INSERT INTO mgc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Zë ödunnï gbɔ ï'bë i'jannï wisi ne ëdï loko ani 'dö ma mo aba. Mora zë alimannï gbɔ akaŋo zi mo yeto. Zë upönnï ha aŋboro 'bënnï ï'dïnnï wakï'dï 'bënnï gbɔ zi Yësu. Wakï'dï mora dahabo, wa kyëzï ngutru, ɔwɔ teme maako ako'jonnï ru mo “murë.” ");
INSERT INTO mgc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wïrï ayada zi zë tëmï wïrï, ma'bannï dekpe hulëhu ta da Heroda. Mora zë a'ba ï'bënnï gbɔ dakaŋo 'bënnï ta gërï mënzë maako. ");
INSERT INTO mgc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mati zë ï'bënnï ku, malayika 'ba Yere alaya zi mo tëmï wïrï iya henye, “Heroda omba zi wisi ne kofo. Ënyï oba wisi ne 'dö ma mo aba aho ï'bë Ezipeto. Alima ani le ma kiya zi yï a'ba.” ");
INSERT INTO mgc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosepa ënyï gbɔ mï yɔndɔ nani, oba wisi ne ma mo aba aho gbɔ mï Ezipeto. ");
INSERT INTO mgc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zë ï'bë alimannï Ezipeto ani le mï kadra 'ba koli 'ba Heroda. Lima 'bëzë ani ne ëdï ku kaa kö'du 'ba Wïrï iya zi nëbï iya henye, “Ma ko'jo wisi ama ku ta Ezipeto.” ");
INSERT INTO mgc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mati Heroda ayɔlɔ ku vo kö'du yɔlɔ ne'e andëndënnï, nï ku, mï mo ënyï ata gbɔ. Mo utu vo kanya 'bënnïye gbɔ tï'bënnï mï dakaŋo ti'de 'ba Beteleme gisi kora kofo a'ba ti'de vo haliŋɔ aba. Zë ma ɔkɔnnï dë gba kɔɔ rïyö, ga kö'du kadra ma vo kö'du yɔlɔ ne'e ayadannï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kö'du ne o'dɔ rë nï tïnyö kaa nëbï Yeremaya iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kpɔrɔ kudu ëdï mï Rama, kpɔrɔ 'ba kudu 'e 'dö kuyë aba, Rayile ra ëdï kudu ga kö'du gisi ënïye. Zë olinnï ku ti'de mo omba dë zi vïdï maako yata nï ta bi kudu.” ");
INSERT INTO mgc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tapëtï koli 'ba Heroda, malayika 'ba Yere alaya tëmï wïrï zi Yosepa mï Ezipeto iya zi mo henye, ");
INSERT INTO mgc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ënyï, oba wisi ne ma mo aba, ï'bë hulëhu mï dakaŋo 'ba Yiserele, ga kö'du zë ma ï'dï rë nnï zi wisi ne kofo, olinnï ku.” ");
INSERT INTO mgc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Here Yosepa ënyï oba wisi ne ma mo aba ï'bë gbɔ hulëhu mï Yiserele. ");
INSERT INTO mgc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mora here, mati Yosepa owo Arakerosi ïrï pëtï 'bu nï Heroda ku na yere 'ba Yudiya, mo na tere zi tï'bë ani. Ayandi mo tëmï wïrï, here mo mï'bë gbɔ mï dakaŋo 'ba Galilaya. ");
INSERT INTO mgc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mora o'dɔ liŋɔ ënï gbɔ mï gawo 'ba Nazereta. Here kö'du ma nëbïye iyannï ne ayi ku tïnyö. “Akako'jo mo vïdï 'ba Nazereta.” ");
INSERT INTO mgc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mï kadra nani 'e Yowani Bapatisi ayi da lïpï 'ba Yudiya. Ayeto kö'du yëtï, ");
INSERT INTO mgc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","iya henye, “Otɔ'e de 'e tëmï kö'du kyënyë ko'dɔ 'be'e ga kö'du damöku 'ba Wïrï ëdï ku kara.” ");
INSERT INTO mgc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowani ra Yisaya nëbï 'ba Wïrï iya me'do ku kyere, ga kö'du mo iya henye, “Here vïdï maako ëdï mbere mï da lïpï iya henye, akɔ'jɔ 'e gërï zi Yere. Adɔrɔ'e gërï mbïyï zi mo.” ");
INSERT INTO mgc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Bɔngɔ 'ba Yowani o'dɔ tëmï yövu 'ba jemele. Mo ida kɔ'di wana ra götö nï na gasi. Wakonyo 'bɔmo ra wömï yazi 'ba wɔrɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Vïdï olɔ ï'bënnï zi mo mï Yerusalema, tëmï daliŋɔ 'ba Yudiya ti'de kpa tëmï liŋɔ ma kara kara ha ranga 'ba Yeredene ne. ");
INSERT INTO mgc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Zë odrɔ hë nnï ga kö'du kyënyë 'bënnï mo a bapatisi zë gbɔ mï ranga 'ba Yeredene. ");
INSERT INTO mgc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mati Yowani ongɔ vïdï ma ako'jo ru zë Farasiye ne, 'dö Sadeke ma kayo ne ëtï tayinnï zi nï zë bapatisi, mo iya zi zë henye, “'E gisi 'ba wiri ne'e, ëyï ra o'ba 'e zi taho kazi riti ma ëdï tayi de 'e ne? ");
INSERT INTO mgc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","O'dɔ'e wa ma akayada otɔ'e de 'e ku tëmï kö'du kyënyë 'be'e. ");
INSERT INTO mgc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Asösu 'e dë henye, ataho'e kazi riti ma Wïrï omba kutu ne kiya mo aba henye, Abarayama ne zutu 'be'e ra. Mayada zi ye Wïrï akïrï yïtö nenye'e a ko'dɔ na kozo zi Abarayama. ");
INSERT INTO mgc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Lɔgɔ ëdï ku nzɔ zi kaga ma ana lɔgɔ dë ne kiga mo akaŋo ku'du mo mï wa'do.” ");
INSERT INTO mgc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mëdï 'bama bapatisi ko'dɔ nje de 'e toto wini aba zi yada otɔ'e de 'e ku. Vïdï ma atayi ta pëtï ma ne, akabapatisi 'e Lawo Kölö Laka wa'do aba. Mo mbiri kyedre ta da ma mëdï le kamoka 'ba ndï mo mɔ'bɔ dë kïnjë. Mo akï'dï bapatisi de 'e Lawo Kölö Laka 'dö wa'do aba. ");
INSERT INTO mgc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mo ëdï sërï ënï aba zi kahi nyenyo. Mo akakyitɔ köru ma laka mora akï'dï nyenyo ënï gbɔ mï lɔ'bi, mo ako'bɔ turu mo yaga mï wa'do ma kazi tölu ne.” ");
INSERT INTO mgc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yësu ayi tëmï Galilaya ɔkɔ ha ranga 'ba Yeredene zi Yowani nï bapatisi. ");
INSERT INTO mgc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yowani omba yata mo iya henye, “Ayi zi ma kaa ma ra ma tï'bë zi yï ko'dɔ bapatisi da ma?” ");
INSERT INTO mgc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yësu aya'ba dɔ mo iya henye, “Ï'dï mëdï tikɔ here, ga kö'du zi rë nï ko'dɔ kaa komba 'ba Wïrï ma laka here.” Mora Yowani ëlëzë gbɔ gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mati ï'dï bapatisi ku da Yësu, mo ëdï ku tasi yaga tëmï wini, komorïyë ayëhu rë nï zi mo. Mo ongɔ Lawo Kölö Laka 'ba Wïrï ëdï tayi akaŋo dë nï ta komorïyë kaa atu'bu here. ");
INSERT INTO mgc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kpɔrɔ aa ta komorïyë iya henye, “Yï ra na Wisi 'bama mɔwɔ yï ku pe. Ma mï kyëyï kyedre aba ga kö'du 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mora Lawo Kölö Laka ika Yësu gbɔ möku da lïpï zi Satani mo yɔnzɔ. ");
INSERT INTO mgc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mati mo oro hë nï ku kadra 'butësowɔ 'dö yɔndɔ aba kazi wakonyo maako, mo ëdï ku na o'bo. ");
INSERT INTO mgc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mora Satani ayi gbɔ zi mo iya henye, “Ëzë ëdï na wisi 'ba Wïrï ame'do zi ṛï'dï ne'e mofɔ rë nnï zi yï na mangɔlɔ'bɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yësu aya'ba dɔ mo iya henye, “Ayöru ku mï buku 'ba Wïrï iya henye, vïdï alima dë nje ra, wakonyo toto kö'du ma ëdï tasi ta ha Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mora Satani ika Yësu le tï'bë mï Yerusalema gawo laka, ënyï ï'dï mo ku le da tɔlɔ yëkëlu 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mo iya zi mo henye, “Ëzë ëdï na Wisi 'ba Wïrï umë rë yï akaŋo ga kö'du ayöru ku mï buku 'ba Wïrï iya henye, mo akï'dï me'do zi malayika ënïye ga kö'du 'bëyï zi zë kako yï kazi otra ndï yï ra ṛï'dï.” ");
INSERT INTO mgc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yësu aya'ba dɔ mo iya henye, “Ayöru ku iya henye, ayɔnzɔ Yere Wïrï 'bëyï dë.” ");
INSERT INTO mgc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mora Satani ika mo löhu da döku ma konda rïyë mora ayada damöku 'dö teme mo aba ti'de zi mo, ");
INSERT INTO mgc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","iya henye, “Wa ne ti'de makï'dï zi yï ëzë alɔdrɔ ku akaŋo ma yeto.” ");
INSERT INTO mgc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yësu aya'ba dɔ mo zi mo iya henye, “Ehe yaga tara ma Satani. Ga kö'du ayöru iya henye, ‘Nje Yere Wïrï 'bëyï amötu.’” ");
INSERT INTO mgc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Satani ila mo gbɔ mora malayika ayinnï akɔnyinnï mo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mati Yësu owo ï'dï Yowani ku mï kamba, mo ënyï ï'bë gbɔ Galilaya. ");
INSERT INTO mgc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mo alima dë Nazereta ënyï ï'bë mï Kaparanamo, gawo ha föfö 'ba Galilaya mï dakaŋo 'ba Zebolona 'dö Napatali aba. ");
INSERT INTO mgc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","O'dɔ rë nï ku kaa Yisaya nëbï 'ba Wïrï iya ne here. Mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tu'dë maako'e mï dakaŋo 'ba Zebolona 'dö Napatali aba, 'dö vïdï ma ha gërï 'ba föfö kyedre kayo ha ranga 'ba Yeredene vïdï 'ba Galilaya dakaŋo 'ba vo leze'e, ");
INSERT INTO mgc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","zë vïdï ma ëdï alimannï mï mandölu 'ba koli ne.” ");
INSERT INTO mgc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mï kadra nani, Yësu ayeto kö'du kise 'bënï yëtï zi vïdï, iya henye, “Otɔ'e de 'e tëmï kö'du kyënyë 'be'e ga kö'du damöku 'ba Wïrï ëdï ku kara.” ");
INSERT INTO mgc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mati Yësu ëdï alasi ta da götï 'ba föfö 'ba Galilaya, mo i'ja öndu vo kyenze kïrïye rïyö Simona ma ako'jo Petero öndu nï Anderiya aba. Ëdïnnï kyenze kïrï tëmï föfö öndu aba. ");
INSERT INTO mgc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yësu iya zi zë henye, “Ayiye zi ma, ma kayandiye zi vïdï kika mo zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Here kandi ila öndu 'bënnï ne, ï'bënnï gbɔ mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mo ï'bë nduwë dagba i'ja öndu ma kyamo'e rïyö, Yemisi nï Yowani aba gisi 'ba Zebedeyo zë ëdïnnï mï töŋbö ënnï 'bu nnï Zebedeyo ëtï öndu ënnï ko'jo mo nzɔ. Yësu ako'jo zë. ");
INSERT INTO mgc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mora kandi zë ilannï töŋbö ne 'bu nnï aba, ënyï ï'bënnï gbɔ mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yësu ënyï alasi biya tëmï Galilaya, kö'du yandi aba mï bi 'ba mötu'e yöyö yöyö laka 'ba damöku 'ba Wïrï aba, zi vïdï ma ëdïnnï dakyïnë 'ba kɔɔ ma 'beri'beri rakɔɔ kɔ'jɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kö'du yöyö ga kö'du mo apere rë nï biya tëmï dakaŋo 'ba Siriya, mora here, vïdï ikannï zi mo zë ma na rakɔɔ riti aba tëmï kyïnë 'ba dakɔɔ ne'e biya, vïdï maako'e ndï keŋe aba Yësu akɔ'jɔ zë biya. ");
INSERT INTO mgc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Vïdï kayo alö'bönnï ga ndï mo tëmï Galilaya a'ba Gawo 'Butë, tëmï Yerusalema, Yudiya dakaŋo kapa 'ba Yeredene ma aga mo. ");
INSERT INTO mgc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mati Yësu ongɔ vïdï kayo ne'e, mo ënyï ï'bë ëkyï da döku mora alima gbɔ akaŋo. Vo lö'bö 'bɔmo'e atoto rë nnï kpo rɔ mo, ");
INSERT INTO mgc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mo ayeto gbɔ zë yandi iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Vo rakyenyiye ra vïdï wïrï lumë aba, ga kö'du damöku 'ba Wïrï 'bëzë ra. ");
INSERT INTO mgc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vo rakyenyiye ra vïdï ma kudu aba, ga kö'du akayëyï zë. ");
INSERT INTO mgc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vo rakyenyiye ra vïdï ma dakumbë aba, ga kö'du akïrïnnï drïvu 'ba dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vo rakyenyiye ra vïdï ma na o'bo a'ba kɔdrɔ aba tïnyö, ga kö'du zë atɔvɔnnï. ");
INSERT INTO mgc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vo rakyenyiye ra vïdï ma mïkyëyï aba, ga kö'du zë aki'jannï mïkyëyï. ");
INSERT INTO mgc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vo rakyenyiye ra vïdï ma di'di zë ŋbala, ga kö'du zë akongɔnnï Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vo rakyenyiye ra vïdï ma vo wayata, ga kö'du akako'jo zë na gisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vo rakyenyiye ra vïdï ma ayaza zë ga kö'du tïnyö 'bëzë, ga kö'du damöku 'ba Wïrï 'bëzë ra. ");
INSERT INTO mgc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Vo rakyenyiye ra vïdï ma alidiye, ayaza'e, o'dɔ'e na kyënyë dakyïnë kö'du 'ba Satani yada mo na ndɔndɔ ru'e aba ga kö'du 'e vo ga ndï ma. ");
INSERT INTO mgc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ëdïye rakyenyi aba ga kö'du biriti kyedre ëdï na sesi asesi zi biye komorïyë. Nenye ëdï hala nëbï ma alimannï dagba kazi komo'e ayaza zë. ");
INSERT INTO mgc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","'E kaa yɔ'dɔ zi vïdï köndu 'ba dakaŋo ne biya. Mora ëzë yɔ'dɔ ayaŋa yɔkɔ nï ku, ata'ba akayɔkɔ hala? Anza kpe na laka, here aku'du yaga möku mora vïdï akutunnï dɔ mo ta bi lasi. ");
INSERT INTO mgc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'E kaa bikanyi 'ba damöku ne biya. Gawo ma uvö da lutu oho rë nï dë. ");
INSERT INTO mgc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vïdï maako owi lamba dë mora kï'dï mo hu sikɔ, ta gɔ mo mo ï'dï da wa tɔrɔ 'ba lamba, ï'dï bikanyi gbɔ zi vïdï 'ba mï loko ne biya. ");
INSERT INTO mgc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tëmï gërï kölö ne, bikanyi 'be'e ma yanyi ga bi dagba komo vïdï, here ne zi zë kongɔ kö'du laka ma o'dɔ 'e zi yeto 'bu komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Asösu 'e dë henye ere, mayi ne zi kö'du kï'dï 'ba Mosa ne koba mo 'de, a'ba kö'du yandi 'ba nëbïye. Mayi dë zi zë koba mo 'de, mayi zi kö'du yandi 'bëzë ne kinde mo. ");
INSERT INTO mgc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Miya kö'du tïnyö ra ze'e, dakaŋo komorïyë aba alaya dekpe, mora gbï le nje ï'jö kö'du kï'dï ma tisi wa aba ölu dë. Kö'du kï'dï akinde rë nï. ");
INSERT INTO mgc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Here ëzë vïdï ma ɔwɔ gbï dë le nje kö'du ma tisi wa ne a'ba okannï 'e yandi mo zi ko'dɔ kpa here, atëdï nje tisiwa aba mï damöku 'ba Wïrï. Ta gërï ma kyamo, vïdï ma owo kö'du kï'dï a'ba ayandi oka 'e zi ko'dɔ mo kpa here, akatëdï na kyedre mï damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mayada zi ye, henye ere, akatɔ'bɔ 'e tödu damöku 'ba Wïrï nje ëzë ëdï 'e koma aba kyɔ ta da vo kö'du kï'dï 'ba vo komoyandiye nnï Farasi ëtï tëmï wa ma Wïrï omba zi ko'dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Owo 'e henye, ayada zi vïdï kyere naniye, “Ofo vïdï dë. Ëzë vïdï ma ofo vïdï ku, aki'ja riti.” ");
INSERT INTO mgc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mora yaanya aba mayada zi ye, vïdï ma na kamo öndu nï aba akika mo bi 'ba riti. Mo ma ako'jo öndu nï iya henye, “Yi wayawa ra,” akika mo komo vurë ma kyedre 'ba Yuda'e. Mo ma iya zi öndu nï, “Yï vo lökyï,” aku'du mo mï wa'do 'ba gehena ma ölu dë. ");
INSERT INTO mgc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Here ëzë omba ku zi wakï'dï 'bëyï kï'dï zi Wïrï da karasa asösu öndu yï ëdï kö'du aba rë yï, ");
INSERT INTO mgc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ila wakï'dï 'bëyï ne ani komo bi 'ba wakumu, ï'bë inde kö'du ne yaga tëmï kutë'e öndu yï aba, mora a'ba 'da wakï'dï 'bëyï ne kï'dï mo zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ëzë vïdï maako asusu yï mï gëri 'ba kö'du kï'dï, oba yï bi 'ba vurë, inde 'e kö'du ne mo aba ëzë ndï kadra gba kazi tɔkɔ bi 'ba vurë. Ëzë ëdï 'e ku ani, mo akï'dï yï zi vo vurë kikye mora mo akidra yï zi turu da köndu mora akï'dï yï gbɔ mï kamba. ");
INSERT INTO mgc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mayada zi yï akalima ani le ëzë opi ndundu kɔhi 'ba kö'du lïtë 'bëyï ne ku. ");
INSERT INTO mgc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Owo 'e ku iya henye, “O'dɔ ndoro dë.” ");
INSERT INTO mgc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mora yaanya aba ne mayada zi ye, bi 'ba wakumu zi Wïrï, vïdï ma ongɔ bi da mbara maako omba mo zi tëdï zi nï, o'dɔ ndoro ku mo aba mï di'di nï. ");
INSERT INTO mgc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mora here, ëzë komo yï ma tïrï o'dɔ yï zi kö'du kyënyë ko'dɔ, oba yaga u'du möku. Ëdï na laka zi, kya 'ba rë yï koba 'de yaga ta da yï ku'du biya ida rë yï aba mï gehena. ");
INSERT INTO mgc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ëzë kala yï ma tïrï o'dɔ yï zi kö'du kyënyë ko'dɔ ikye u'du möku. Ëdï na laka zi kya 'ba rë yï ma kölö koba mo 'de ta da ida rë yï biya zi tï'bë mï gehena ma ölu dë. ");
INSERT INTO mgc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iya kpa henye, “Vïdï mati ayëyï mbara 'bënï mï'dï zi mo waraga 'ba rakinga.” ");
INSERT INTO mgc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yaanya aba ne mayada zi ye henye, ëzë kora ma inga mbara 'bënï ga kö'du ma 'beri anza ndoro dë, ëzë mbara ne ï'bë oze kora maako, mo o'dɔ ndoro ku. Kora ma oze mo ne o'dɔ ndoro kpa ku. ");
INSERT INTO mgc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Owo 'e kpa henye ayada zi vïdï ma alagannï kyere ne'e henye, apere mï lömu 'bëyï dë, o'dɔ wa ma o'dɔ lömu mo ne zi Yere zi ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mora mayada zi ye o'dɔ 'e lömu maako dë komorïyë aba ga kö'du bi lima 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Alömu rë yï dë dakaŋo aba, ga kö'du bi ndï kutu 'bɔmo ra. Alömu rë yï dë Yerusalema aba ga kö'du gawo kyedre 'ba Wïrï ra. ");
INSERT INTO mgc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Alömu dë dë yï aba ga kö'du ɔ'bɔ dë zi yëvu ma kölö ko'dɔ na kanyi mandere na köndu. ");
INSERT INTO mgc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iya nje henye, “Ɔɔ mandere e'e. Wa ma iya 'e 'beri ne ayi kazi Satani.” ");
INSERT INTO mgc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Owo'e ku iya henye, komo, komo aba, yingɔ ha, yingɔ ha aba. ");
INSERT INTO mgc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yaanya aba miya zi ye henye, “Aya'ba da kö'du kyënyë dë zi vïdï ma o'dɔ kö'du kyënyë zi yï. ");
INSERT INTO mgc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ëzë vïdï maako isa lɔ'bɔ yï ma datïrï, mo misa lɔ'bɔ yï ma da gali kpa.” ");
INSERT INTO mgc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ëzë vïdï maako ïrï yï na wehe zi wa 'bënï kumbë, wiṛi kölö, ïnjë wiṛi rïyö. ");
INSERT INTO mgc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ëzë vïdï maako ako'jo wa kazi yï, ï'dï zi mo. Ëzë vïdï maako omba wa koba kazi yï dero, ï'dï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Owo 'e iya henye, “O'dɔ lɔvɔ oka yï 'e biya. Mora oyi vo wehe 'bëyï 'e.” ");
INSERT INTO mgc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yaanya aba mayada zi ye, o'dɔ lɔvɔ vo wehe 'bëyïye amötu ga kö'du zë ma o'dɔnnï yï na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Zi yada 'e tëdï na gisi 'ba 'bu ma komorïyë, ga kö'du mo ï'dï kadra ënï zi bi yanyi da vïdï kyënyë'e 'dö ma laka ëtï, ï'dï mïrë zi zë ma o'dɔnnï kö'du laka kpa zi zë ma o'dɔnni kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hala Wïrï akï'dï biriti zi yï ëzë o'dɔ nje lɔvɔ vïdï ma o'dɔ nnï lɔvɔ yï? Vïdï 'ba 'be'bele kö'du 'e o'dɔnni kpa here. ");
INSERT INTO mgc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ëzë ame'do nje zi aboka yïye, here ne o'dɔ ku ndra ta da vïdï ma ayɔlɔ Wïrï dë ne. ");
INSERT INTO mgc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ëdï na laka ta ga kadra biya kaa 'bu yï 'ba komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Andiye re 'e laka o'dɔ'e kö'du laka 'be'e dë komo vïdï zi kongɔ mo, ëzë o'dɔ'e ku here, i'ja'e wa ma kölö maako dë kazi 'bu'e ma komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ëzë yï maako ëdï kï'dï wa zi vo leri, iya kö'du mo dë zi vïdï maako kaa vo komo kandiye ëdïnnï ko'dɔ mo mï bi 'ba mötu'e, a'ba da gërï zi vïdï koronnï. Na laka miya zi ye biriti 'bëzë ku nje here. ");
INSERT INTO mgc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ëzë ëdï wakï'dï zi vo leri, ï'dï vïdï ma kara rë yï ne ma yɔlɔ dë. ");
INSERT INTO mgc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ï'dï toto liwo. Ëzë 'bu Wïrï i'ja wa ma o'dɔ ku liwo ne mo akï'dï biriti mo zi yï. ");
INSERT INTO mgc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ëzë ëdïye amötu anza'e dë kaa vo komo kandiye, kö'du zë o'dɔnnï lɔvɔ tɔrɔ mötu ko'dɔ aba mï bi 'ba mötu'e ta da gërï zi vïdï nnï kongɔ. Mayada zi ye, tïnyö biriti 'bëzë gɔ mo ra ku nje ne. ");
INSERT INTO mgc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ëzë omba mötu ödu kutu yï aba loko 'bëyï isi haloko gë yï a mötu zi 'Bu yï, zi Wïrï mati ongɔ rɔ mo dë ne. Wa mati o'dɔ'e ku liwo ne, 'Bu'e akï'dï biriti mo zi ye. ");
INSERT INTO mgc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ëzë ëdïye ku amötu adele'e mï me'do dë kaa vïdï ma ayɔlɔ Wïrï dë, ga kö'du zë asösu 'bënnï henye akowonnï ga kö'du mötu konda 'bënnï ne. ");
INSERT INTO mgc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Anza'e dë kaa zë, ga kö'du 'bu'e ayɔlɔ wa ma, omba'e ne ku kyere gba kazi ako'jo 'e dë. ");
INSERT INTO mgc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nenye ëdï hala aka mötu'e. 'Bu ze ma komorïyë nani, ru yï mëdï na koro. ");
INSERT INTO mgc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ï'dï damöku 'bëyï mayi, kö'du 'bëyï 'ba dakaŋo kinye mo'dɔ rë nï kpa kaa 'ba komorïyë ne here. ");
INSERT INTO mgc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ï'dï wakonyo 'ba kadra ma ndenye ne zi ze. ");
INSERT INTO mgc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ila ze ga kö'du yaŋa 'beze kaa dëdï kila oka ze 'e ga kö'du yaŋa zë o'dɔnnï zi ze ne here. ");
INSERT INTO mgc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ika ze dë mï wayɔnzɔ, asesi ze laka kazi Satani. ");
INSERT INTO mgc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ëzë ila'e vïdï ga kö'du ma zë ayaŋannï zi ye ne, 'bu'e ma komorïyë ne akila 'e kpa ga kö'du yaŋa 'be'e. ");
INSERT INTO mgc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ëzë ila'e vïdï dë ga kö'du kyënyë, 'bu'e ma komorïyë ne ila 'e kpa dë ga kö'du kyënyë 'be'e. ");
INSERT INTO mgc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ëzë ëdïye he 'e koro, ayaŋa'e da komo'e dë kaa vo komo kandiye ëdïnnï ako'dɔ. Zë afufu rë nnï vonyö vonyö zi yɔlɔ mo nëdïnnï hë nnï koro. Tïnyö miya zi ye biriti ï'dï ku nzɔ ndɔ zi zë. ");
INSERT INTO mgc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ëzë ëdï he 'e koro, akaka'e komo'e osa'e yënï re 'e, ");
INSERT INTO mgc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kazi vïdï maako'e ayɔlɔnnï ëdïye he 'e koro, nje 'bu'e ma ongɔ rɔ mo dë ne, mo ra nje ma yɔlɔ wa ma o'dɔ'e na liwo ne mo akï'dï biriti mo zi ye. ");
INSERT INTO mgc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ulu ha wa dë zi ye dakaŋo kinye, bi ma malödö ëdï yaŋa wa ti'de zi mo ne, wa ma ëdï lëndrë ne, mora vo logo ëdïnnï logo wa ta dɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wa ma laka ulu ku zi ye komorïyë, ga bi ma malödö ayaŋa wa dë ta dɔ mo, wa lëndrë, vo logo alogo wa dë ta dɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ga kö'du, bi ma ulu ha wa ku dɔ mo ne di'di yï atëdï ŋburu dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Komo yï ra, na lamba 'ba rë yï. Ëzë komo yï ëdï na laka ida rë yï ti'de akatëdï ndɔ mï bikanyi kyedre. ");
INSERT INTO mgc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ëzë komo yï na kyënyë rë yï ti'de atëdï ga bi köndu. Ëzë bikanyi anza dë mï yï di'di yï ndɔ na bi köndu. ");
INSERT INTO mgc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Vïdï maako ɔ'bɔ dë zi lïtu zi yere rïyö, mo atɔwɔ nje ma kölö, mo akoyi ma kölö. Ɔ'bɔ dë zi lïtu zi Wïrï kpa zi damöku? ");
INSERT INTO mgc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Mï kadra ko'do kölö ne mëdï kiya zi ye alima'e dë kö'du sösu aba ga kö'du 'ba wakonyo, wa kuwë, bɔngɔ ga kö'du lawo ɔɔ ndra ta da wakonyo. Mora kö'du ida ra ɔɔ ndra ta da bɔngɔ. ");
INSERT INTO mgc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ongɔ'e aliye te, zë isi nnï wa dë, zë umunnï wa dë kï'dï mo mï lɔ'bi. 'Bu 'ba komorïyë ne ëdï zë kulu. Here anza'e dë kyedre ta da aliye? Asösu 'be'e 'e ra dë kyedre ta da aliye? ");
INSERT INTO mgc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Vïdï maako tëmï 'e atɔ'bɔ lima tisi konda, kö'du sösu aba kö'du mo? ");
INSERT INTO mgc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kö'du a'di ëdïye alima kö'du sösu aba ga kö'du bɔngɔ? Ongɔ'e döru 'ba möku te zë urunnï bɔngɔ dë, o'dɔnnï lɔɔ dë zi nnï. ");
INSERT INTO mgc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tïnyö miya zi ye, Solomono ëdï le wa dakayo aba usu bɔngɔ ma teme alaga döru 'ba möku dë. ");
INSERT INTO mgc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ëzë Wïrï ëdï kusu bɔngɔ ra döru ma ëdï alɔ'bɔ atɔ'bɔ'e dë bɔngɔ kusu re 'e, vïdï ma kö'du koma aba ne. ");
INSERT INTO mgc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Miya zi ye alima'e dë kö'du sösu aba kiya mo henye, “Ma konyo wa ndenye ta kila? Ma kuwë wa ndenye ta kila? Ma ki'ja bɔngɔ ta kila?” ");
INSERT INTO mgc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vïdï ma ayɔlɔ Wïrï dë ne ëdï nje taho ga wa 'ba dakaŋo ne. 'Bu 'e ma komorïyë nani mo ayɔlɔ, wa ma omba'e ne, mo akï'dï zi ye. ");
INSERT INTO mgc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oma mï damöku 'ba Wïrï dagba 'dö tïnyö 'bɔmo aba, wa ma omba ne mo akï'dï zi yï. ");
INSERT INTO mgc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Asösu kö'du wa 'ba mïndö aba dë, ga kö'du mïndö ëdï kö'du sösu 'bënï aba kutu, kadra 'ba mïndö ëdï kpa kö'du 'bënï aba kutu. ");
INSERT INTO mgc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","O'dɔ vurë 'ba vïdï maako dë na mbërë. Ëzë o'dɔ ku, ako'dɔ vurë 'bëyï kpa here. ");
INSERT INTO mgc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gërï ma ëdï ko'dɔ vurë 'ba vïdï mo aba ne, ako'dɔ vurë 'bëyï kpa mo aba. Ndï me'do ma ëdï yeri mo ra vïdï ne akayeri 'bëyï kpa here. ");
INSERT INTO mgc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kö'du a'di ongɔ bi da wa mati komo öndu yï, kazi bi kongɔ da kulugbu kyedre ma komo yï ne. ");
INSERT INTO mgc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hala akiya zi öndu yï, “Ï'dï ma yago ngayo nenye yaga ta komo yï,” mora ëdï 'bëyï gbï kulugbu aba komo yï? ");
INSERT INTO mgc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yï vo komo kandi nenye, ayago kulugbu ne dero dagba yaga ta komo yï, zi bi kongɔ na laka zi yago ngayo yaga ta komo öndu yï. ");
INSERT INTO mgc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ï'dï wa 'ba Wïrï dë zi wïhïye. U'du wa ma teme 'bëyï dë da komo wa'do 'e akalasinnï ta dɔ mo, akizannï mï yï sisisi yaga. ");
INSERT INTO mgc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ako'jo akï'dï zi yï, oma aki'ja, akökö, akayëhu haloko zi yï. ");
INSERT INTO mgc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Zë ma ti'de ako'jonnï akï'dï zi zë. Zë ma ti'de omannï, aki'jannï. Zë ma akökönnï akayëhu. ");
INSERT INTO mgc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ëyï ra ëzë wisi 'bɔmo ako'jo mangɔlɔ'bɔ, mo ënyï ïrï yïtö ï'dï zi mo? ");
INSERT INTO mgc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ëzë wisi maako ako'jo kyenze ma mo akïrï wiri kï'dï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vo kö'du kyënyë ko'dɔ'e, ëzë ï'dï 'e wakï'dï 'be'e zi gisi 'be'e. 'Bu 'ba komorïyë akï'dï wa ma laka ndra kyɔ zi ye. ");
INSERT INTO mgc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wa ma omba oka yï 'e ko'dɔ mo zi yï ne o'dɔ kpa zi zë, nenye kö'du kise 'ba kö'du kï'dï 'dö nëbï kö'du ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ödu 'e ta ha resi ma tisi ne, ha resi ma kyedre ne ï'bë bi 'ba koli. Gërï ma kyedre ne, vïdï ma ëdï tï'bënnï ta gɔ mo ne zë na kayo. ");
INSERT INTO mgc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ha loko ma ëdï tï'bë bi 'ba dïdï ma ŋburu ŋburu ne nje tisiwa. Vïdï ma i'jannï ne, toto tisiwa. ");
INSERT INTO mgc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ï'dï 'e komo'e mandi laka, kazi nëbï kö'du 'ba Wïrï mambërë ne'e, ga kö'du usunnï bɔngɔ ma o'dɔ tëmï yëvu 'ba tïmëlë ne ta rë nnï yaga, mora mï di'di zë na tuku wölïwölï ma kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Akayɔlɔ'e zë tëmï wa ma zë ëdïnnï ko'dɔ mo. Kaga kono ana oha dë, ana kyëlu dë. ");
INSERT INTO mgc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mora kpa here, kaga laka ana gbï lɔgɔ laka. Mora kaga ma kyënyë ana gbï lɔgɔ kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kaga laka ana lɔgɔ kyënyë dë. Kaga kyënyë ana lɔgɔ laka dë. ");
INSERT INTO mgc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaga ma ti'de ana lɔgɔ ma laka dë ne akiga akaŋo aku'du mï wa'do. ");
INSERT INTO mgc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Akayɔlɔ zë nje tara lɔgɔ 'bëzë ma ana ne. ");
INSERT INTO mgc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Anza vïdï biya ma ëdïnnï ko'jo ma, “Yere Yere,” ne akatödunnï mï damöku 'ba Wïrï, nje zë ma o'dɔnnï wa ma 'Bu ma komorïyë omba zë zi ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mï kadra 'ba vurë nani, vïdï ma kayo akiyannï zi ma henye, Yere, Yere, ze ra dëdï kumë kö'du dakyikyi kore aba yaga tara vïdï mï ru yï? ");
INSERT INTO mgc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma kaya'ba, ma kiya zi zë henye, “Ma yɔlɔ 'e dë. Ï'bë'e yaga tara ma, 'e vo kö'du kyënyë ko'du ne'e.” ");
INSERT INTO mgc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ëzë vïdï ma owo kö'du yandi 'bama ku koro mo aba, atëdï kaa vo kö'du yɔlɔ ma o'ba loko ënï da ṛï'dï. ");
INSERT INTO mgc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ëzë mïrë a'di wini oso le, ëzë buluku aluku le akyëtï rë nï le ra loko nani alöru dë, ga kö'du o'ba hu mo ku da ṛï'dï. ");
INSERT INTO mgc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ëzë vïdï ma owo kö'du yandi 'bama ne dë koro mo aba, atëdï kaa vo lumë ma o'ba loko ënï da yayi. ");
INSERT INTO mgc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mïrë a'di wini oso, buluku aluku ra loko nani alöru ku na löru kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mati Yësu inde kö'du yëtï ku zi vïdï kayo nani 'e zë ku na rakaga ga kö'du wa yandi 'bɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ga kö'du mo ëdï kala konda aba. Anza dë kaa vo komoyandi 'ba vo kö'du kida'e. ");
INSERT INTO mgc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mati Yësu asi akaŋo ta da döku ne, vïdï kayo alö'bönnï gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Vo mönyu maako ayi alɔdrɔ, akaŋo komo Yësu, iya henye, “Yere, ëzë omba ku akɔ'jɔ ma ŋbala.” ");
INSERT INTO mgc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yësu iza kala nï gbɔ ise ra vere nani, iya henye, “Momba dɔ mo ku.” Mo iya henye, “Ëdï na ŋbala.” Akɔ'jɔ yï ku, mora rakɔɔ ila vere nani gbɔ kandi. ");
INSERT INTO mgc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yësu ise gɔ mo zi mo, iya henye, “Ï'bë iya me'do nenye dë zi vïdï maako, ï'bë zi vo karasa 'e ma nyelinnï rë yï, ï'dï wakumu 'ba wa kɔ'jɔ ma Mosa ï'dï kö'du mo ne, zi yada yï zi vïdïye ti'de akɔ'jɔ yï ku.” ");
INSERT INTO mgc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yësu ödu mï Kaparanamo kyedre 'ba vo da kanya maako 'ba Roma vo da wehe lamikölö ayi ako'jo ha Yësu ga kö'du wa kɔnyi. ");
INSERT INTO mgc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iya henye, “Yere, vo kalima 'bama ëdï rakɔɔ aba liŋɔ na keŋe na riti.” ");
INSERT INTO mgc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yësu iya henye, “Ma tï'bë liŋɔ 'bëyï zi mo kɔ'jɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kyedre 'ba vo da kanya nani iya henye, “Yere, ɔ'bɔ dë zi yï tayi liŋɔ 'bama. Iya nje hë yï akakɔ'jɔ vo kalima 'bama ne, ");
INSERT INTO mgc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ga kö'du mayɔlɔ kala konda 'bëyï ëdï gbï kaa 'bama, mëdï kala konda 'dö vo kanya ëtï hu ma. Ëzë ma me'do zi ma kölö, miya henye, ‘Ï'bë,’ mo ï'bë gbï. Ëzë ma me'do zi maako, miya henye, ‘Ayi,’ mo ayi gbï. Ëzë ma me'do zi vo kalima 'bama, o'dɔ wa nenye mo o'dɔ gbï.” ");
INSERT INTO mgc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mati Yësu owo me'do 'ba vere ne ku, aga gbɔ rɔ mo. Mo iya zi vo gënïye iya henye, “Tïnyö miya zi ye, mi'ja vïdï maako dë 'de tëmï vïdï 'ba Yiserele, ma ëdï kö'du koma aba kaa vere ne. ");
INSERT INTO mgc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ëdï na laka mëdï kiya zi ye, ma kayo mo atayinnï tëmï dakaŋo kapa 'ba humïrë 'dö da lërë aba zi drɔkɔ rë nnï ra Abarayama, Yisika, Yakoba ëtï mï damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gisi 'ba Yiserele ma kayo, ma akɔ'jɔ damöku ga kö'du zë aku'du zë mï bi köndu 'ba kudu ha konyo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yësu aya'ba dɔ mo iya zi vo da kanya nani, iya henye ï'bë liŋɔ ako'dɔ rë nï kaa wa ma oma ne. Mora vo kalima 'ba da vo kanya ne akɔ'jɔ gbɔ mï kadra nani. ");
INSERT INTO mgc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yësu ï'bë ödu loko 'ba Petero i'ja wese 'ba Petero zöyï aba o'ba rë nï ku da sora. ");
INSERT INTO mgc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mo ise kala mo, zöyï ila mo gbɔ. Here mo ënyï gbɔ lïtu zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mï da hutaga nani aba, ikannï vïdï kayo maakowe ëdïnnï nökyï aba zi mo. Mo ore dakyikyi yaga ta rë zë me'do aba. Mo akɔ'jɔ vïdï ma rakɔɔ aba ne'e ti'de. ");
INSERT INTO mgc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mo o'dɔ here zi tëdï kaa ma Yesaya nëbï vo me'do 'ba Wïrï iya ne. Mo iya henye, “Ma gogo makïnjë rakɔɔ yaga.” ");
INSERT INTO mgc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yësu ongɔ vïdï kayo ëdïnnï ku kpo ta rë nï mo ame'do zi vo lö'bö gënïye zi zë kumu kafo föfö ma agamo. Mo ame'do gbɔ zi vo lö'bö gënï 'e zi zë kumu tï'bë kafo ranga ma agamo. ");
INSERT INTO mgc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Vo komoyandi maako ayi zi mo iya henye, vo komoyandi. Bi ma ï'bë zi mo. Ma kusu gëyï. ");
INSERT INTO mgc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yësu aya'ba dɔ mo, iya henye, “Uhwavödö 'e ëdïnnï ogo ënnï aba, ali 'e ëdïnnï loko ënnï aba. Wïsi 'ba Vïdï anza dë liŋɔ aba na bi 'ba ralawo.” ");
INSERT INTO mgc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Vere maako na vo lö'bö gɔ mo iya henye, “Kyedre 'bama, ï'dï ma 'ba dero 'bu ma kusu.” ");
INSERT INTO mgc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yësu iya zi mo henye, “Usu ga ma, ila yöku 'e musunnï yöku ënnï.” ");
INSERT INTO mgc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yësu ëkyï gbɔ mï töŋbö 'dö vo lö'bö gënï ëtï ");
INSERT INTO mgc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","tisi yaa buluku ënyï gbɔ aluku da föfö nani. Buluku alima ku töŋbö kɔhɔ zi likɔ kaŋo. Yësu ëdï ako'do. ");
INSERT INTO mgc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zë ï'bënnï alironnï mo, iyannï henye, “Yere, akɔnyi ze, dëdï ku kara zi koli.” ");
INSERT INTO mgc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mo iya zi zë henye, “Ëdïye atere ga a'dï? Ëdïye koma tisi aba.” Mo ënyï amo da buluku wini kagba aba, mati ɔrɔnnï ne, bi gbɔ liwo. ");
INSERT INTO mgc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Zë ti'de na rakaga iyannï henye, “Vere ne, ëyï ra? Buluku 'e wini kagba aba owonnï dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mati Yësu umu da föfö ï'bë mï dakaŋo 'ba Gadora ne, vïdï rïyö maako'e zë dakyikyi aba andɔsi dë nnï mo aba. Vïdï ne'e ënyïnnï na nganga. Vïdï maako ɔ'bɔ dë zi laga ta ga bi nani, dakyikyi ne'e ayaza rë nnï zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zë apinnï na kyembe, iyannï henye, “Yï Wisi 'ba Wïrï nenye, a'di ra omba kazi ze ayi ku de ze kinde gba kazi kadra mo tɔkɔ?” ");
INSERT INTO mgc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wa'do kayo 'ba liŋɔ ëdïnnï wakonyo kara ra liŋɔ da lutu. ");
INSERT INTO mgc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dakyikyiye ayaza rë nnï zi Yësu, iyannï henye, “Ëzë omba ku kore ze, utu ze zi wa'do nani 'e.” ");
INSERT INTO mgc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mo iya zi zë, henye, “Ï'bëë.” Zë ï'bënnï ödunnï mï wa'do kayo naniye, mora wa'do naniye ënyïnnï gbɔ ti'de ataho bi lunyï 'ba föfö mora aluyïnnï gbɔ ti'de mï wini. ");
INSERT INTO mgc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vo yako wa'do nani 'e aho iyannï mï gawo. Ayadannï kö'du ma o'dɔ rë nï nani ti'de, kö'du mati o'dɔ rë nï zi kora dakyikyi ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Vïdï 'ba mï gawo nani 'e olɔnnï gbɔ ti'de tayi Yësu kongɔ. Zë i'jannï mo ako'jonnï hɔ mo zi mo tënyï tï'bë yaga tëmï dakaŋo ënnï. ");
INSERT INTO mgc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Here Yësu ëkyï mï töŋbö ï'bë hulëhu kyëtï 'ba föfö mï gawo 'bënï. ");
INSERT INTO mgc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ani kya 'ba vïdï maako'e ikannï zi mo kora vo keŋe akaŋo ne ëdï ako'do da sora. Mati Yësu ongɔ hala kö'du koma 'bëzë ëdï, mo iya zi kora keŋe ne henye, “Akyigɔ rë yï, wisi ama, kö'du kyënyë 'bëyï ila ku.” ");
INSERT INTO mgc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mora here, kya 'ba vo komoyandi 'ba vo kö'du kida'e ame'donnï na bi dë nnï, iyannï henye, “Kora nenye, ëdï me'do 'dasi ra kiya.” ");
INSERT INTO mgc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mora here, Yësu ayɔlɔ kö'du sösu 'bëzë, ne a'ba iya henye, “Kö'du a'di ëdï 'e kö'du kyënyë mahere ne sösu mo? ");
INSERT INTO mgc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mavala ra zi kiya, ila yï ku ga kö'du kɔdɔ kyënyë 'bëyï, kɔdɔ zi kiya henye, ‘Ënyï rïyë alasi?’ ");
INSERT INTO mgc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mako'dɔ tïnyö zi ye yɔlɔ, Wisi a Vïdï ëdï kyigɔ aba dakaŋo zi kö'du kyënyë kila.” Mora here, mo iya zi kora keŋe ne henye, “Ënyï rïyë, ïnjë sora 'bëyï ne, ï'bë liŋɔ!” ");
INSERT INTO mgc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kora ne ënyï rïyë ï'bë gbɔ liŋɔ. ");
INSERT INTO mgc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mati vïdï kayo ongɔnnï ne, zë na tere Wïrï yeto aba ga kö'du kyigɔ kaa mahere ne kï'dï mo zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Here Yësu ila bi nani, ma mo ï'bë dagba, mo ongɔ kora vo 'be'bele kö'du ru mo Matayo, ëdï alima bi 'ba 'be'bele kö'du, mo iya zi mo henye, “Alö'bö ga ma.” Matayo ënyï alö'bö gbɔ gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mati Yësu ëdï wakonyo mï liŋɔ a Matayo, vo 'be'bele kö'du kyɔ, a'ba kya 'ba vo kö'du kyënyë ko'dɔ'e ayi onyonnï wa Yësu aba a'ba, vo lö'bö 'bɔmo'e ëtï da tarabiza kölö. ");
INSERT INTO mgc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kya 'ba Farasiye ongɔnnï kö'du ne here, ako'jonnï ha vo lö'bö 'bɔmo'e, “Kö'du a'di vo komoyandi 'be'e ëdïnnï wakonyo vïdï mahere ne ëtï? ");
INSERT INTO mgc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yësu owo kö'du 'bëzë ne, aya'ba dɔ mo iya henye, vïdï ma rë zë na laka kazi kɔɔ, ï'bënnï dë zi vo ɔwɔ, nje zë ma na rakɔɔ. ");
INSERT INTO mgc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ï'bë oma'e mï kö'du ya'ba ma kö'du yöru iya ne.” Ëdï kö'du laka ma momba, ra anza ngötu kumu. Mayi dë kö'du vïdï laka'e, mayi ga kö'du vïdï 'ba kö'du kyënyë'e. ");
INSERT INTO mgc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Here vo lö'bö 'ba Yowani Bapatisi ayinnï zi Yësu, ako'jonnï kö'du iyannï henye, “Kö'du a'di ze Farasi ëtï, dëdï he ze koro mora vo lö'bö 'bëyïye, oro hë nnï dë gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yësu aya'ba dɔ mo iya henye, omba 'be'e yingɔ ma ëdïnnï mï kyërë 'ba oze, zi tëdï na rasösu ëzë 'bïyësï ëdï zë ëtï? Anza here dë. Here kadra mo akatɔkɔ, ëzë omba ku 'bïyësï koba 'de kazi zë mora atehennï 'da hë nnï koro. ");
INSERT INTO mgc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Vïdï maako uru bɔngɔ ma kyïyï dë zi kɔ'jɔ bɔngɔ ma kɔɔ, ga kö'du bɔngɔ ma kyïyï ako'dɔ wogo kyedre mï bɔngɔ ne. ");
INSERT INTO mgc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vïdï maako ope a'ji ma kyïyï dë mï lɔsɔ wana makɔɔ, ga kö'du lɔsɔ wana akiha a'ji akalödï yaga, mora lɔsɔ wana ne akayaŋa rë nï. Here a'ji makyïyï mope gbï mï lɔsɔ wana makyïyï a'ba 'dö rïyö atëdïnnï na laka.” ");
INSERT INTO mgc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mati Yësu ëdï kö'du nenye kiya, vïdï mï turu 'ba Yuda'e ayi zi mo alɔmvɔ akaŋo komo mo iya henye, “Wu'jë 'bama oli ku yaanya ayi ï'dï kala yï dɔ mo zi mo tëdï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yësu ënyï rïyë alö'bö gbɔ gɔ mo mora vo lö'bö 'bɔmo'e ï'bënnï gbɔ mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mbara maako ëdï na riti, kö'du yama ëdï taho ta rɔ mo kɔɔ 'butë dɔmorïyö, ayi ta kafo Yësu ise da ha bɔngɔ 'bɔmo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mo iya na bi dënï henye, “Ëzë mise gbï le nje ra 'bɔngɔ ɔmo, akakɔ'jɔ ma.” ");
INSERT INTO mgc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yësu opi rë nï ongɔ mo, iya henye, “Ëdï na kyigɔ wu'jë ama! Koma 'bëyï akɔ'jɔ yï ku.” Tëmï kadra ne mbara ne akɔ'jɔ rë nï gbɔ na laka. ");
INSERT INTO mgc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mati Yësu ödu mï loko 'ba turu kyedre ne, mo i'ja vïdï kayo ëdïnnï kyëzu 'ba da koli kome. ");
INSERT INTO mgc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Mo iya zi zë henye, “Vïdï biya asiye yaga. Wu'jë tisi ne oli dë mo ëdï nje ako'do!” Here zë biya ogonnï mo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kandi ma ti ore vïdï ne'e ku yaga, Yësu ï'bë mï loko ma yöku wu'jë dɔ mo ne, ïrï kala mo mo ënyï gbɔ rïyë. ");
INSERT INTO mgc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kö'du yöyö ne apere rë nï biya tëmï dakaŋo nani. ");
INSERT INTO mgc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yësu ila bi nani ëdï ku atï'bë, vo komoköndu rïyö ayetonnï lö'bö ga ndï mo. Zë agbögbönnï hë nnï, iyannï henye, ï'dï mïyï mëyï re ze, “Asösu kö'du ze, Wisi 'ba Dawidi!” ");
INSERT INTO mgc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mati Yësu ödu loko, vo komoköndu rïyö ne ayinnï zi mo, mo ako'jo hë zë iya henye, “Oma'e ku zi matɔ'bɔ 'e kɔ'jɔ?” Zë aya'bannï da me'do, iyannï henye, “Ɔɔ Yere.” ");
INSERT INTO mgc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yësu ise komo zë, iya henye, “Mo'dɔ rë nï kaa ma oma'e” ");
INSERT INTO mgc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","komo zë ayëhu rë nï gbɔ. Yësu ise gɔ mo zi zë iya henye, “Ayada'e kö'du nenye dë zi vïdï maako!” ");
INSERT INTO mgc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mora zë ï'bë a yëlënnï kö'du ne ta ga bi nani ti'de. ");
INSERT INTO mgc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mati vïdï kora ne'e ëdïnnï atï'bë, kya, vïdï maako'e ikannï kora maako zi Yësu, mo ɔ'bɔ dë zi me'do ga kö'du mo ëdï dakyikyi aba. ");
INSERT INTO mgc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mora kandi ma ti ore dakyikyi ku yaga, kora ne ayeto me'do mora vïdï biya na rakaga. Zë iyannï henye “Gba dongɔ kö'du ma hee ne dë mï Yiserele.” ");
INSERT INTO mgc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mora Farasiye iyannï henye, “Ne yere 'ba dakyikyiye ra ï'dï kyigɔ ne zi Yësu zi dakyikyiye kore yaga.” ");
INSERT INTO mgc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yësu ënyï ï'bë biya lasi aba tëmï gawo daliŋɔ aba. Mo ayandi kö'du mï bi 'ba mötu'e, kö'du yöyö laka 'ba damöku 'ba Wïrï yëtï aba, mora akɔ'jɔ vïdï kayo dakyïnë 'ba kɔɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mati mo ongɔ vïdï kayo, di'di mo oso kyɔ kö'du sösu aba ga kö'du zë na kö'du sösu, wakɔnyi kpa anza dë kaa tïmëlë kazi vo yako. ");
INSERT INTO mgc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Here mo iya zi vo lö'bö 'bënnïye henye, “Wa mï yaka ëdï kyɔ, mora vo lɔɔ ko'dɔ'e ayonnï dë. ");
INSERT INTO mgc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Amötu zi vo kyeti yaka nenye, mo mutu yaga vo lɔɔ'e zi wa 'bɔmo toto mo ta yaka.” ");
INSERT INTO mgc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yësu akɔ'jɔ vo lö'bö 'butë dɔmorïyö 'bënïye bi kölö ï'dï kyigɔ zi zë kore dakyikyi yaga, zi kɔ'jɔ kɔɔ rakɔɔ aba biya. ");
INSERT INTO mgc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nenye'e ru 'ba vo lïtu, butë dɔmorïyö ne'e ma dagba Simona (ma ako'jo Petero) öndu mo: Anderiya, Yemisi öndu nï Yowani aba, gisi 'ba Zebedeyo. ");
INSERT INTO mgc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, Baratolomoya, Toma, Matayo, vo 'be'bele kö'du, Yemisi wisi 'ba Alipayo Tadöyösu, ");
INSERT INTO mgc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona vo dakaŋo 'ba Kanana zë Yudasi Sikereto ma asösu Yësu aba. ");
INSERT INTO mgc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Vïdï kora 'butë dɔmorïyö ne'e, Yësu utu zë kö'du kira nenye aba. “Ï'bë'e dë mï dakaŋo 'ba vo leze'e mandere mï gawo 'ba Samarona'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Omba zi ye tï'bë zi tïmëlë 'ba Yiserele ma ölu. ");
INSERT INTO mgc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ï'bë'e ayëtïye, ‘Damöku 'ba Wïrï ëdï ku kara.’ ");
INSERT INTO mgc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Akɔ'jɔ'e vo kɔɔ, ayɔmɔ'e yöku löhu na dïdï, akɔ'jɔ'e zë ma na riti kɔɔ mönyu aba, ore'e dakyikyi yaga. I'ja'e kazi ma na mbiya, here ï'dïye kpa zi zë na mbiya. ");
INSERT INTO mgc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ïnjë'e dahabo ako dë, kɔhi mandere meŋe kɔhi mï bɔngɔ re 'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ïnjë'e aŋboro 'ba wa lenze dë ta bi tï'bë 'be'e, oba'e nje bɔngɔ kamoka ma ëdïye akusu ne. Oba'e mɔvɔ 'ba lasi dë, vo lɔɔ'e akï'dï zi zë wa ma zë ombannï.” ");
INSERT INTO mgc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ëzë ayiye mï gawo, ï'bë'e bi koma kö'du vïdï ma akïrïye kala kyedre aba, alima'e mo aba le zi ye bi nani kila. ");
INSERT INTO mgc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ëzë ï'bë'e mï liŋɔ iya'e henye, ‘Rakyëyï mëdï ëtï.’ ");
INSERT INTO mgc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ëzë vïdï mï liŋɔ nani ïrïye kala kyedre aba, ï'dïye wa mëtë 'be'e 'ba rakyëyï malima, ëzë zë ïrïnnï 'e dë kïrï kala kyedre aba, oba'e wa mëtë'e hulëhu. ");
INSERT INTO mgc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ëzë kya 'ba liŋɔ mandere gawo omba dë bi 'e kïrï kala kyedre aba mandere kö'du 'be'e kowo, ila'e bi nani akyitɔ'e turufu 'de ta ndïye zi mo na lömu rë zë. ");
INSERT INTO mgc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mayada zi ye tïnyö, mï kadra 'ba vurë aba atëdï na kyënyë ndra kö'du gawo nani ta da gawo 'ba Sɔdɔmo, Gɔmora aba.” ");
INSERT INTO mgc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Owo'e te, mëdï 'e kutu yaga kaa tïmëlë mï kutë wölïwölï. Here ëdïye ŋbala kaa wiriye. Mora ëdïye kpa kaa atu'bu o'dɔnnï kö'du kyënyë dë. ");
INSERT INTO mgc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ongɔ'e re 'e laka, ga kö'du vïdï maako atëdïnnï ani zë akïrï nï 'e akika bi 'ba vurë mora zë aku'bönnï 'e mï bi 'ba mötu'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kö'du ma, akika 'e bi 'ba vurë komo vo dakaŋo yere ëtï, zi kö'du yöyö laka ne yada zi zë zi vo leze'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ëzë ikannï 'e bi 'ba vurë, asösu'e dë a'di ra atï'bë'e zi kiya, mandere hala akonyo'e. Mï kadra nani mo ɔkɔ ku, akï'dï zi ye a'di akiya'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ga kö'du me'do ma akame'do 'e atanza dë 'be'e, zë atayinnï kazi Lawo Kölö Laka 'ba 'bu'e akame'do kpuru kazi 'e.” ");
INSERT INTO mgc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ɔndu'e atënyïnnï akpa da öndu'e zë kï'dï zi kofo. 'Bu'e atënyïnnï akpa da gisisi 'bënnïye zë kï'dï zi kofo. Gisisiye ako'dɔnnï wehe akpa vo ko'jo zë aba akutu zë zi kofo. ");
INSERT INTO mgc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vïdï biya akiyïye ga kö'du ma. Mora vïdï ma nduwë na kyigɔ le mï ndundu mo, akayɔmɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ëzë o'dɔ'e na kyënyë mï gawo maako, aho'e mï gawo ma agamo. Ma yada zi ye tïnyö, inde'e lɔɔ ne'e mï gawo biya 'ba Yiserele ne dë, gba kazi Wisi a Vïdï tɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Vo kö'du ko'jo anza kyedre ta da vo komoyandi 'bënï. Vo yasa anza kyedre ta da vo kyedre 'bënï. ");
INSERT INTO mgc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Here vo kö'du ko'jo mo'bɔ zi tëdï kaa vo komoyandi 'bënï, vo lö'bö kaa vo kyedre 'bënï. Ëzë vo da dakota ako'jo Belezobulu, vo dakota 'ba liŋɔ'e ako'jo ru kyënyë aba.” ");
INSERT INTO mgc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Here ere'e vïdï dë. Yaanya aba, wa ma ayöfu dɔ mo, akayëhu, kö'du koho biya ako'dɔ na yɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wa mati mëdï ayada zi ye mï mandölu, akayada'e mï bikanyi kyedre, wayawaya 'be'e akame'do ta da tɔlɔ 'ba loko. ");
INSERT INTO mgc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ere'e dë kazi vïdï ma ëdïnnï ida ra kofo, ofonnï lawo dë. Ere'e Wïrï ma akatɔ'bɔ yaŋa 'dö ida ra lawo aba mï wa'do gehena. ");
INSERT INTO mgc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nje tarifa kölö akatɔ'bɔ silɔ kogo rïyö. Here silɔ ma kölö alëpï dë akaŋo kazi da kö'du komba 'ba 'bu'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ga kö'du yëvu biya ma de 'e ne, ëdï akiti. ");
INSERT INTO mgc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Here ere'e dë ëdïye na laka ndra ta da silɔ kayo.” ");
INSERT INTO mgc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Here kö'du zë ma iyannï mï vïdï kayo zë 'bama, mako'dɔ kpa here komo 'bu ma komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mora here, ëzë vïdï maako omba ma dë ta komo vïdï kayo, ma komba mo kpa dë ta komo 'bu ma komorïyë.” ");
INSERT INTO mgc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Asösu'e dë henye ere, mayi zi rakyëyï ra kika mï damöku. 'E'e, mayi dë zi rakyëyï ra kika, kulu ra. ");
INSERT INTO mgc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mayi zi gisi kora'e tënyïnnï wehe aba da 'bu nnï, gisi mïnzö'e tënyïnnï wehe aba da ma nnï, mbara koze atënyïnnï wehe aba da wese nnï. ");
INSERT INTO mgc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Vo wehe kyënyë 'be'e, atëdï akpa vïdï 'ba dakota 'be'e. ");
INSERT INTO mgc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Zë ma o'dɔnnï lɔvɔ 'bu nnï, mandere ma nnï ndra ta da ma, ɔ'bɔnnï dë zi tëdï na vo lö'bö 'bama. Zë ma o'dɔnnï lɔvɔ gisi kora 'bënnï, mandere wisi wu'jë ɔ'bɔnnï dë zi tëdï na vo lö'bö 'bama. ");
INSERT INTO mgc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Zë ma ïnjënnï taka 'bënnï dë rïyë zi lö'bö ga ndï ma, ɔ'bɔnnï dë zi tëdï na vo lö'bö 'bama. ");
INSERT INTO mgc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Zë ma o'dɔnnï lɔvɔ dïdïnnï ndra ta da lɔvɔ ma, akayölunnï. Zë ma ayölunnï dïdïnnï ga kö'du ma, aki'jannï dïdï löhu.” ");
INSERT INTO mgc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Vïdï ma ïrïye kala kyedre aba ïrï ne ma ra, mora vïdï ma ïrï ma kala kyedre aba, ïrï ne vïdï ma utu ma ne. ");
INSERT INTO mgc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Vïdï ma ïrï nëbï kala kyedre aba ga kö'du mo nëbï, aki'ja mï wakinye 'ba biriti 'ba nëbï. Vïdï ma ïrï vïdï ma laka kala kyedre aba ga kö'du mo na laka, aki'ja mï wa yanya 'ba biriti 'ba vïdï laka. ");
INSERT INTO mgc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ëzë vïdï ma ï'dï gbï le nje sikɔ 'ba wini kyëyï, zi vïdï ma kölö 'ba ga ndï ma, vïdï nani aki'ja biriti rë nï.” ");
INSERT INTO mgc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mati Yësu inde kö'du nenye'e yada mo zi vo lö'bö 'bënï 'butë dɔmorïyö ne'e, mo ila bi nani ï'bë kö'du yandi yëtï aba mï gawo 'ba Galilaya'e. ");
INSERT INTO mgc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mati Yowani Bapatisi owo mï kamba, kö'du Korisitɔ ëdï ako'dɔ ne, mo utu kya 'ba vo lö'bö 'bënïye zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Zë ako'jonnï ha Yësu iyannï henye, “Ayada zi ze, yï ra kora ma omba tayi kɔdɔ dida ze bi vïdï maako?” ");
INSERT INTO mgc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yësu aya'ba da me'do iya henye, “Ï'bë'e a'ba'e hulëhu ayada'e zi Yowani kö'du ma ëdï akowo'e kongɔ mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Vo komoköndu atɔ'bɔ bi kongɔ, vo keŋe atɔ'bɔ lasi, zë ma ëdïnnï na riti kazi kɔɔ mönyu o'dɔ zë ŋbala, vo mbilikïsï owo kö'du, yöku vïdï ënyïnnï löhu na dïdï, kö'du yöyö laka ëdï yëti mo zi vo leriye. ");
INSERT INTO mgc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rakyenyi ëdï zi zë ma anza nnï dë dajijï aba ga kö'du ma.” ");
INSERT INTO mgc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mati vo lö'bö a Yowani ëdï atï'bënnï, Yësu ame'do kö'du mo zi vïdï kayo: “Mati ï'bë'e yaga zi Yowani mï da lïpï, a'di ra omba'e zi kongɔ? Rakïdë 'ba mbili loma mï buluku? ");
INSERT INTO mgc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A'di ra ï'bë'e yaga zi kongɔ? Vïdï kora usu rë nï mï bɔngɔ laka? Vïdï ma usu rë nnï kaa mahere ne alimannï mï loko kyedre a yere. ");
INSERT INTO mgc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ayada'e zi ma a'di ra ï'bë'e yaga zi kongɔ? Nëbï ra? Ɔɔ ongɔ'e ndra ta da nëbï. ");
INSERT INTO mgc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Here kö'du yöru ra iya kö'du ga kö'du mo, ‘Ma kutu vo lö'bö ama dagba komo yï zi gërï yëhu zi bi yï.’ ");
INSERT INTO mgc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ma yada zi ye tïnyö, Yowani Bapatisi ëdï kyedre ta da vïdï maako, mo maako ma tisiwa mï damöku 'ba Wïrï kyedre ta da Yowani. ");
INSERT INTO mgc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mï kadra ma Yowani Bapatisi ayëtï kö'du 'bënï le mï ko'do nenye damöku 'ba Wïrï ëdï tövu kyedre kyigɔ aba. Kora vo wehe ko'dɔ'e ï'dï rë nnï zi kuru mo na gbörökötö. ");
INSERT INTO mgc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Here le mï kadra 'ba Yowani nëbïye biya kö'du kï'dï 'ba Mosa ame'do kö'du 'ba damöku. ");
INSERT INTO mgc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ëzë omba'e zi koma mï kö'du kise 'bëzë, Yowani mo Eliya, ma kö'du tayi 'bɔmo ayëtï. ");
INSERT INTO mgc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Owo'e kö'du ne ëzë ëdïye mbili aba!” ");
INSERT INTO mgc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Yaanya aba, kaa a'di ma kiya ga kö'du vïdï ma ëdïnnï mï ko'do ma ndenye ne? Zë kaa gisisi ma ëdïnnï alima mï bi 'ba wakogo. Gbɔngɔ ma kölö akagbögbö hë nnï zi maako'e akiya. ");
INSERT INTO mgc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Henye, dɔlɔ kudï 'ba rakoze zi ye, mora ɔlɔ'e dë. Daya'bi ze ngala 'ba dakoli, mora udu'e dë.’ ");
INSERT INTO mgc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mati Yowani ayi, mo oro hë nï uwë a'ji dë vïdï biya iyannï henye, ‘Mo ëdï dakyikyi aba.’ ");
INSERT INTO mgc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mati Wisi a Vïdï ayi, mo onyo wa, uwë a'ji. Mora vïdï iyannï henye, ongɔ'e bi te da kora ne. Mo onyo wa takanyi. Uwë a'ji kpa takanyi mo aboka 'ba vo 'be'bele kö'du'e vo kö'du kyënyë ko'dɔ'e ëtï. Mora kö'du yɔlɔ a Wïrï ëdï na yada zi tëdï tïnyö tëmï wa ma o'dɔ rë nï.” ");
INSERT INTO mgc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vïdï ma mï gawo ma Yësu o'dɔ kö'du ko'do kyedre ënï mï zë ne, 'de otɔ dë nnï dë tëmï kö'du kyënyë 'bënnï, here mo iya zë na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Atëdï zi ye kyënyë Korɔzini! Atëdï zi ye kyënyë Beteseyida! Ëzë kö'du ko'do ma o'dɔ mï ye ne o'dɔ mï Tiyere, Sidoni aba kani vïdï nani usunnï bɔngɔ 'ba lubë ku rë nnï zi yada henye ere zë otɔnnï dë nnï ku tëmï kö'du kyënyë 'bënnï. ");
INSERT INTO mgc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma yada zi ye henye, mï ko'do 'ba vurë aba, Wïrï akila vïdï 'ba Tiyere, Sidoni aba tada'e. ");
INSERT INTO mgc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yï Kaparanamo! Omba'e zi re 'e kïnjë komorïyë? Aku'du'e akaŋo mï wa'do 'ba gehena. Ëzë kö'du ko'do ma o'dɔ mï ye ne mo'dɔ mï Sɔdɔmo, atëdï zɔ kadra ndenye aba. ");
INSERT INTO mgc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akatɔ'bɔ yɔlɔ'e henye, mï ko'do 'ba vurë aba Wïrï rasösu ndra kö'du Sɔdɔmo tada'e!” ");
INSERT INTO mgc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mï kadra nani Yësu iya henye, “'Bu Yere 'ba komorïyë dakaŋo aba! Mo'dɔ öwö'dï zi yï ga kö'du zi vo kazi kö'du yɔlɔ'e, wa ma oho kazi vo kö'du yɔlɔ'e vo yandi ëtï ayada ku zi gisisiye. ");
INSERT INTO mgc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɔɔ, 'bu, nenye hala wa ma omba kani zi rë nï ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Bu ma ï'dï wa ku biya zi ma. Vïdï maako ayɔlɔ Wisi dë nje 'Bu. Vïdï maako ayɔlɔ 'bu dë nje Wisi, zë ma Wisi inzi zi nnï yada.” ");
INSERT INTO mgc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ayiye zi ma 'e biya ma na riti kazi wayeto kïnjë makï'dïye alawo. ");
INSERT INTO mgc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","O'dɔ 'e lɔɔ 'bama, ayandi 'e kazi ma, ga kö'du ma vo watɔwɔ raya'ba aba. Here aki'ja'e ralawo. ");
INSERT INTO mgc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Lɔɔ 'bama ayeto dë. Kïnjë mo na pëlë.” ");
INSERT INTO mgc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anza na kɔwɔ ta gɔ mo, Yësu ëdï gbɔ tï'bë kpuru tëmï yaka 'ba nyenyo mï ko'do 'ba ralawo aba. Vo lö'bö 'bɔmo'e gbɔ na o'bo, here ayetonnï da mbili nyenyo kowe ï'jö mo konyo. ");
INSERT INTO mgc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mati Farasi ongɔnnï kö'du ne here, zë iyannï zi Yësu henye, “Ongɔ te, anza na laka mï kö'du kï'dï 'beze zi vo lö'bö 'bëyïye kö'du mahere ne, ko'dɔ mï ko'do 'ba ralawo!” ");
INSERT INTO mgc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yësu aya'ba da me'do iya henye, “Ako'jo'e kö'du ma Dawidi o'dɔ mï kadra nani ma mo vïdï 'bënï ëtï na o'bo ne dë? ");
INSERT INTO mgc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mo ï'bë ödu mï loko 'ba Wïrï, mo nnï vïdï 'bënï ëtï onyonnï mangɔlɔ'bɔ koro ma ï'dï zi Wïrï, ëdï le mï kö'du kï'dï anza dë zi zë konyo mo, nje vo karasa ra akila zi konyo mo. ");
INSERT INTO mgc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kɔdɔ ako'jo'e dë mï kö'du kï'dï 'ba Mosa iya henye, tëmï ko'do 'ba ralawo biya vo kö'du yëtï mï yëkëlu 'ba Wïrï zë oronnï ko'do 'ba ralawo dë, here zë anza nnï dë na lïtë? ");
INSERT INTO mgc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma yada zi ye henye, wa maako ëdï kinye kyedre ta da yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ködu yöru iya henye, momba ngötu kumu dë, momba 'e zi tëdï na mïkuku. Ëzë ayɔlɔ'e mï kö'du nenye ku, ɔ'bɔ'e dë zi vurë kikye ra vïdï ma o'dɔnnï kö'du kyënyë ako dë. ");
INSERT INTO mgc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wisi a Vïdï Yere 'ba ko'do 'ba ralawo ra.” ");
INSERT INTO mgc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yësu ila bi nani ënyï ï'bë bi 'ba mötu. ");
INSERT INTO mgc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kora maako ëdï ani na vo kala keŋe. Kya 'ba vïdï maako'e ëdïnnï ani ombannï zi Yësu susu ga kö'du kyënyë ko'dɔ ako'jonnï hɔ mo iyannï henye, “Ëdï na kyënyë mï kö'du ki'di 'beze zi vïdï kɔ'jɔ mï ko'do 'ba ralawo?” ");
INSERT INTO mgc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yësu aya'ba da me'do iya henye, “A'di, ëzë vïdï ma kölö tëmï 'e ëdï tïmëlë aba alëpï mï wogo yöndu mï ko'do 'ba ralawo, akasösu kö'du mo dë zi kotɔ mo yaga? ");
INSERT INTO mgc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Vïdï köndu ra laka ndra ta da tïmëlë! Here ne, kö'du kï'dï 'beze ila ze zi vïdï maako kɔnyi mï ko'do 'ba ralawo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Here mo iya zi kora 'ba kala keŋe ne henye, “Iza ga kala yï yaga.” Mo iza gɔ mo yaga, gbɔ na laka löhu kaa agamo ne. ");
INSERT INTO mgc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Here Farasiye ï'bënnï o'dɔnnï mala zi Yësu kofo. ");
INSERT INTO mgc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mati Yësu owo kö'du mala rë nï ne, mo ï'bë 'de ta bi nani, mora vïdï kayo alö'bönnï gbɔ ga ndï mo aba. Mo akɔ'jɔ vïdï ma zë na rakɔɔ ne'e biya, ");
INSERT INTO mgc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mo ise gɔ mo zi zë iya henye, mayadannï kö'du nï dë zi vïdï maako'e. ");
INSERT INTO mgc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mo o'dɔ here zi rë nï ko'dɔ kaa kö'du ma nëbï Yisaya ayi ku tïnyö. ");
INSERT INTO mgc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kinye ëdï vo lö'bö ama ma minzi. Mo ma mo'dɔ lɔvɔ mo. Kö'du mo, ma na rakyenyi. Ma kutu Lawo Kölö Laka ama dɔ mo, mo akayöyö kö'du vurë ama zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mo awasa mandere ha gbögbö dë mandere me'do na gu ŋberere da gëri. ");
INSERT INTO mgc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mo owe loma ma ïdë rë nï ku ne dë, mandere yölu lamba ma omba ku kara tɔrɔ kazi lëru. Mo atëdï nduwë, le mo ako'dɔ vurë ma laka 'ba kpilïrï. ");
INSERT INTO mgc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tu'dë biya akï'dï kö'du sösu 'bënnï mï mo.” ");
INSERT INTO mgc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Here kya 'ba vïdï maako'e ikannï kora vo komoköndu maako zi Yësu, ɔ'bɔ dë zi me'do ga kö'du mo ëdï dakyikyi aba. Yësu akɔ'jɔ kora ne, here mo ɔ'bɔ zi me'do bi kongɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Vïdï biya na rakaga tëmï kö'du ma Yësu o'dɔ ne. Zë ako'jonnï kö'du iyannï henye, “Mo atëdï Wisi 'ba Dawidi ra?” ");
INSERT INTO mgc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mati Farasiye owonnï kö'du ne, aya'bannï dɔ mo iyannï henye, “Mo ore dakyikyi ne'e yaga, ga kö'du vo dë zë Belezobulu ra, ï'dï kyigɔ ne zi mo zi ko'dɔ here.” ");
INSERT INTO mgc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yësu ayɔlɔ kö'du ma zë ëdïnnï asösu, mo iya zi zë henye, “Dakaŋo ma inye rë nï na gbɔngo gbɔngo wehe ko'dɔ oka ani aba, alima na konda dë. Gawo maako, mandere dakota ma inye rë nï na gbɔngo gbɔngo wehe ko'dɔ oka maako aba akalëpï. ");
INSERT INTO mgc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Here ëzë gbɔngo ma kölö ëdï wehe ko'dɔ oka nï vere aba mï damöku a Satani, nenye kö'du ya'ba aba henye, inye rë nï ku nzɔ na gbɔngo gbɔngo kandi apere rë nï. ");
INSERT INTO mgc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iya'e henye, mo ore dakyikyi yaga kyigɔ 'ba Belezobulu aba, mora ëyï ra ï'dï zi vo ga ndï yïye kyigɔ ne zi zë kore yaga? Zë atëdï na vo vurë 'bë 'e. ");
INSERT INTO mgc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ëzë mora dakyikyi kyigɔ 'ba Lawo 'ba Wïrï, here damöku a Wïrï ayi ku de 'e.” ");
INSERT INTO mgc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Vïdï maako ɔ'bɔ dë tödu mï loko 'ba kora ma na kyigɔ zi wasisi ɔmo koba, nje ëzë mo ida kora kyigɔ ne dagba atehe 'da loko ɔmo kolɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Vïdï ma anza dë 'bama, mo ëdï tïnyö kö'du aba ra ma. Vïdï ma akɔnyi ma dë zi toto, ëdï tïnyö pere mo. ");
INSERT INTO mgc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ma yada zi ye henye, atɔ'bɔ vïdï kila ga kö'du kyënyë mati o'dɔnnï, kö'du kyënyë kiya aba, mora vïdï mati iya kö'du kyënyë ra Lawo Kölö Laka, ila mo dë. ");
INSERT INTO mgc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Vïdï mati iya kö'du kyënyë ra Wisi a Vïdï akila mo, vïdï mati iya kö'du kyënyë ra Lawo Kölö Laka ila mo dë yaanya aba ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Zi tëdï lɔgɔ laka aba ëdï kaga ma laka aba. Ëzë ëdï kaga ma kyënyë aba atëdï lɔgɔ ma kyënyë aba. Kaga akayɔlɔ tara dakyïnë 'ba lɔgɔ ma ana. ");
INSERT INTO mgc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'E wiri ne'e, hala akiya'e kö'du ma laka, mora 'e Satani? Ha akiya wa ma ëdï. Ndɔ mï didi mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vïdï ma laka akɔdɔ gbï wa ma laka ga kö'du laka ënï, vïdï ma kyënyë akɔdɔ gbï kö'du kyënyë ga kö'du kyënyë ënï. ");
INSERT INTO mgc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ayɔlɔ'e henye kadra 'ba vurë aba, vïdï biya na kölö kölö akayëtï kö'du kyënyë ma mo iya. ");
INSERT INTO mgc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Me'do hë yï ra, akpa ako'dɔ vurë mo aba rë yï, zi yɔlɔ yï vo kö'du laka kɔdɔ vo kö'du kyënyë.” ");
INSERT INTO mgc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Here kya 'ba vo komoyandi 'ba kö'du kï'dï maako'e, kya 'ba Farasi maako'e ëtï, ame'donnï rïyë iyannï henye, “Vo komoyandi, domba zi yï kongɔ ta bi kö'du ko'do ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mo aya'ba dɔ mo zi zë iya henye, “Hala vïdï kyënyë 'ba kazi wiri ëdïnnï kadra ndenye aba. Ako'jo'e ha ma ga kö'du ko'do? 'E'e! Kö'du ko'do ma akayada zi ye atëdï nje kö'du ko'do 'ba nëbï Yona. ");
INSERT INTO mgc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tëmï gërï kölö ne Yona o'do kadra wota yɔndɔ aba mï kyenze, here Wisi a Vïdï ako'do kadra wota yɔndɔ aba mï hu kaŋo yöndu ne. ");
INSERT INTO mgc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mï ko'do 'ba vurë aba, vïdï 'ba Nïnëwë atënyïnnï rïyë akasusunnï 'e ga kö'du zë otɔnnï dë nnï ku tëmï kö'du kyënyë 'bënnï, ma owonnï kö'du yëtï 'ba Yona ne. Ma yada zi ye, wa kyedre maako ëdï kinye ta da Yona. ");
INSERT INTO mgc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mï ko'do 'ba vurë aba yere mbara 'ba daliŋɔ 'ba Seba atënyï rïyë 'e susu ga kö'du mo ï'bë tëmï gërï ne biya tëmï kaŋo 'bënï kö'du me'do yɔlɔ yandi 'ba yere Solomono kowo. Miya zi ye henye, wa ëdï kinye kyedre ta da Solomono!” ");
INSERT INTO mgc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ëzë dakyikyi asi ku yaga tara vïdï, ï'bë lasi aba dakaŋo maako bi lawo koma. Ëzë i'ja dë, ");
INSERT INTO mgc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","akiya na bi dënï henye, ‘Ma ta'ba hulëhu liŋɔ ama ma mila ne.’ Here ï'bë hulëhu i'ja loko na mbiya, ŋbala na laka. ");
INSERT INTO mgc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Here ënyï ï'bë yaga ika aboka nïye madɔmorïyö dakyikyi maako'e na kyënyë ta da nï, zë ayinnï alimannï gbɔ ani. Ëzë inde rë nï ku, vïdï nani ëdï mï riti kyënyë ta da ma dagba. Nenye ëdï kö'du ma ako'dɔ rë nï zi vïdï ma kyënyë'e mï ko'do nenye.” ");
INSERT INTO mgc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mati Yësu ëdï gba ame'do zi vïdï kayo, ma mo öndu mo ëtï ɔkɔnnï gbɔ. Zë ɔrɔnnï yaga kö'du ko'jo zi me'donnï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Here vïdï maako tëmï vïdï naniye iya zi mo henye, “Ongɔ te ma yi, öndu yï ëtï ëdïnnï atɔrɔ yaga, ombannï zi me'do zi yï.” ");
INSERT INTO mgc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yësu aya'ba da me'do iya henye, “Ëyï 'bënï ma ma? Ëyïye ra öndu ma'e?” ");
INSERT INTO mgc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mo ënyï ayada bi da vo lö'bö 'bënïye, iya henye, “Ongɔ te! Kinye ma ma öndu ma ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vïdï ma o'dɔ wa ma 'bu ma komorïyë omba mo zi ko'dɔ mo ne, mo ra na öndu ma, ëmï ma ma ma.” ");
INSERT INTO mgc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mï ko'do kölö, Yësu ila liŋɔ ënyï ï'bë da götï 'ba föfö alima gbɔ akaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Vïdï kayo ma atoto rë nnï kpo ta rɔ mo gbɔ kyɔ, mo ëkyï mï töŋbö alima gbɔ mï mo, vïdï kayo ɔrɔ 'bënnï yaga da götï. ");
INSERT INTO mgc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mo alima kö'du yëtï zi zë kyɔ tëmï mala. Yësu iya henye, “Kadra maako aba kora maako ï'bë kofo kïlï. ");
INSERT INTO mgc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mati mo ïlï kofo mï yaka, kya mo alëpï da gërï, ali ayi onyonnï 'de. ");
INSERT INTO mgc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kya mo alëpï mï kaŋo ma ṛï'dï, kaŋo ma laka nje tisiwa aba, kandi kofo ne ötu ga kö'du kaŋo ne alo dë. ");
INSERT INTO mgc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mati kadra ese o'bɔ wevo ma luru ne'e, ga kö'du ngara'da ödu dë gbo na laka, kandi wevo ne'e akyïtu gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kya 'ba kofo alëpï mï kutë kono, övu mora ofo wevo mo. ");
INSERT INTO mgc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kya 'ba kofo alëpï mï kaŋo ma laka wevo mo ana ï'jö, kya mo lamikölö, aga mo'e 'butëmodaka, mora aga mo'e 'butëwota.” ");
INSERT INTO mgc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yësu inde kö'du 'bënï iya henye, “Owo'e kö'du ne, ëzë ëdï 'e mbiliye aba!” ");
INSERT INTO mgc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vo lö'bö'e ayinnï zi Yësu ako'jonnï hɔ mo iya henye, “Kö'du a'di ëdï 'bëyï ame'do zi vïdï tëmï mala?” ");
INSERT INTO mgc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yësu ënyï aya'ba dɔ mo iya henye, “Kö'du koho 'ba damöku 'ba Wïrï ï'dï ku zi ye, anza dë zi zë. ");
INSERT INTO mgc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mora here, vïdï ma wa aba akï'dï zi mo ndra, here mo atëdï mo aba kyɔ ta da ma ëdï. Mora vïdï mati anza wa aba dë, akoba 'de kazi mo gbï le ma tisi ma mo ëdï mo aba ne. ");
INSERT INTO mgc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mï kö'du ma mëdï ame'do zi zë tëmï mala ëdï henye, ‘Zë ongɔnnï bi mora ï'jannï dë, zë o'je mbili nnï. Mora owonnï mandere ayɔlɔnnï dë.’ ");
INSERT INTO mgc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kö'du kumë 'ba Yisaya ga kö'du 'bëzë ne henye, ‘Vïdï nenye'e akowonnï nje na kowo mora ödu dë, dë zë. Zë akongɔnnï bi akongɔ mora 'de ï'jannï dë. ");
INSERT INTO mgc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Dïdï vïdï nenye'e na kyigo. Mbili vïdï nenye'e yaanya aba na kïsï. Zë ombannï dë zi kö'du tïnyö kongɔ. Ëzë mbili zë anza dë na kisi, zë akongɔnnï komo nnï aba, akayɔlɔnnï dë nnï aba mora akotɔ dë nnï zi ma hulëhu, mora akakɔ'jɔ zë.’” ");
INSERT INTO mgc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mora kö'du'e ne laka ga kö'du komo'e i'ja ku, mora mbiliye owo kpa ku. ");
INSERT INTO mgc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ëdï na laka miya zi ye nëbï kayo mora vïdï kayo a Wïrï ombannï zi ki'ja wa ma i'ja 'e ne, mora 'de ï'jannï dë, mora zë ombannï zi kowo wa ma owo'e ne, mora 'de owonnï dë. ");
INSERT INTO mgc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Owo'e ayandiye mï kö'du 'ba vo kofo kïlï ne. ");
INSERT INTO mgc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Zë mati owonnï kö'du kise 'ba damöku ne, mora ayɔlɔnnï dë ëdïnnï kaa kofo mati alëpï da ga gërï. Satani ayi ïrï me'do ne yaga tëmï di'di zë. ");
INSERT INTO mgc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kofo mati alëpï dakaŋo ma ṛï'dï aba, ëdï zë ma owonnï kö'du ne rakyenyi aba, kandi ma owonnï. ");
INSERT INTO mgc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'De ödu dë gbo mï di'di zë, mora ëhïnnï dë na konda. Here mati kö'du kyënyë maako ayi ga kö'du kise ne, akilannï 'de kandi. ");
INSERT INTO mgc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kofo ma alëpï mï kono ne, ga kö'du zë ma owonnï kö'du kise ne, kö'du sösu ga kö'du wa 'ba dakaŋo, lɔvɔ wa kyɔ ila kö'du kise ne dë tödu mï di'di zë, du anannï lɔgɔ dë. ");
INSERT INTO mgc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kofo ma ïlï mï kaŋo ma laka, ëdï kö'du zë ma owonnï kö'du kise ne, ïrïnnï gö zë ra anannï lɔgɔ, kya mo lamikölö, agamo'e 'butëmodaka mora agamo'e 'butëwota.” ");
INSERT INTO mgc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yësu ayada mala ma kya mo zi zë. “Damöku 'ba Wïrï ëdï kaa henye. Kora maako ïlï kofo ma laka mï yaka ënï. ");
INSERT INTO mgc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yɔndɔ kölö maako aba, mati vïdï o'donnï ku biya vo wehe ayi ïlï kofo nyangölu mï kutë wana, mora ï'bë wënï 'de. ");
INSERT INTO mgc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mati wevo mo övu, mbili mo omba ku zi rë nï kï'dï. Nyangölu alaya gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vo kalima a kora ne ayi zi mo iya henye, ‘Kyedre, kofo laka ra ïlï mï yaka 'bëyï ne. Nyangölu ne ayi 'bënï ta kila?’ ");
INSERT INTO mgc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mo aya'ba da me'do zi mo, iya henye, ‘Ne vo wehe maako ra o'dɔ kö'du ne.’ Zë ako'jonnï hɔ mo iyannï henye, ‘Omba zi ze tï'bë nyangölu ne kotɔ mo 'de yaga?’ ");
INSERT INTO mgc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mo aya'ba da me'do, iya henye, ‘'E'e, ga kö'du ëzë atoto'e nyangölu ne akotɔ'e kya wana 'dö zë ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ila'e wana 'dö nyangölu aba mövunnï bi kölö le kadra 'ba wakumu ta yaka aba. Ma kayada zi vo lɔɔ'e, zi nyangölu kotɔ dagba, hɔ mo kida na kulu zë ko'bɔ, mora da wana toto zi kï'dï mo mï lɔ'bi.’” ");
INSERT INTO mgc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yësu ayada mala ma aga mo zi zë, “Damöku 'ba Wïrï ëdï henye: Kora maako oba kofo masatada ïyï mï yaka ënï. ");
INSERT INTO mgc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kofo matisiwa aba ta da kofo biya, mati övu rïyë, gbɔ na kyedre ta da wevo biya, övu na kaga, ali ayinnï uvö loko ënnï mï ngora mo.” ");
INSERT INTO mgc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yësu nduwë mala maako yada mo zi zë iya henye, “Damöku 'ba Wïrï ëdï henye: Mbara maako oba langa asusë mï tele 'butësowɔ 'ba lunzu ï'dï gbɔ tö'bu.” ");
INSERT INTO mgc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yësu ayada kö'du nenyee zi vïdï kayo tëmï mala. Mo iya kö'du ako dë zi zë kazi mala. ");
INSERT INTO mgc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mo o'dɔ kö'du ne here zi kö'du kiya 'ba nëbï tayi tïnyö: “Ma ko'dɔ mala ëzë ma me'do zi zë. Ma kayada zi zë wa mati ayɔlɔnnï dë kyere ma damöku ï'dï rë nï ne.” ");
INSERT INTO mgc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mati Yësu ila vïdï kayo ödu loko, vo lö'bö 'bɔmowe ayinnï zi mo, iyannï henye, “Ayada dero zi ze mï mala 'ba nyangölu mï yaka ne a'di?” ");
INSERT INTO mgc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yësu aya'ba dɔ mo, iya henye, “Kora ma ïlï kofo ma laka ne Wisi a Vïdï. ");
INSERT INTO mgc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yaka damöku, kofo ma laka ne, mora vïdï ma 'bënnï 'ba damöku ne. Nyangölu ra vïdï ma 'bënnï 'ba Satani. ");
INSERT INTO mgc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vo wehe ma ïlï kofo ne mo ra Satani. Wa kumu ta yaka mora ndundu 'ba daliŋɔ, mora vo kumumo'e zë ra malayika'e.” ");
INSERT INTO mgc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Here kaa ma nyangölu atoto dɔ mo o'bɔ mï wa'do, kö'du ne ako'dɔ rë nï here mï ndundu 'ba daliŋɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ëdï here, Wisi a Vïdï akutu yaga malayika ënïye, zi toto tëmï damöku ënï yaga, vïdï ma biya ëdïnnï vïdï kï'dï zi kö'du kyënyë ko'dɔ, biya agamo'e ma ëdïnnï kö'du kyënyë ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Zë aku'dunnï zë mï wa'do, zë akudunnï hë nnï konyo aba. ");
INSERT INTO mgc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Vïdï a Wïrï atanyinnï kaa kadra mï damöku a 'bu nnï, owo'e kö'du ne, ëzë ëdï 'e mbili aba.” ");
INSERT INTO mgc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Damöku 'ba Wïrï ëdï henye, kora maako i'ja wa na koho mï yaka. Mo ayöfu dɔ mo gbɔ löhu. Mo na rakyenyi, ï'bë wogo wasisi mati mo ëdï mo aba yaga, ï'bë hulëhu wogo yaka nani gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Damöku 'ba Wïrï ëdï kpa kaa henye. Kora maako ëdï bi koma kö'du dahabo ma laka. ");
INSERT INTO mgc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mati mo i'ja, mo ï'bë wogo wasisi mati mo ëdï mo aba biya yaga, wogo dahabo nani gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Damöku 'ba Wïrï ëdï kpa kaa henye, kya 'ba kora vo kyenze kïrï u'du wa 'ba kyenze kïrï ënnï yaga mï föfö, mora ïrï dakyïnë 'ba kyenze biya. ");
INSERT INTO mgc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mati wa 'ba kyenze kïrï ëdï ku ndɔ, zë otɔnnï yaga da götï alimannï gbɔ akaŋo zi mï kyenze ne yanya, ma laka ne ï'dïnnï mï baga ënnï, mati anza na laka u'dunnï zë 'de möku. ");
INSERT INTO mgc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Atëdï mï ndundu 'ba daliŋɔ aba kaa nenye. Malayika atï'bënnï yaga akako'dɔnnï vïdï ma kyënyë'e tëmï ma laka ");
INSERT INTO mgc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aku'du zë mï wa'do 'ba koli ani zë akudunnï hë nnï konyo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yësu ako'jo hë zë, iya henye, “Ayɔlɔ'e kö'du nenye'e ku?” Zë aya'bannï dɔ mo iyannï, “Ɔɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Here mo aya'ba dɔ mo zi zë iya henye “Vo komoyandi 'ba kö'du kï'dï ma ayandi zë kö'du 'ba Damöku 'ba Wïrï, kaa vo kyeti 'ba loko mati oba wa ma kyï ma kɔɔ aba, yaga tëmï lɔ'bi ënï.” ");
INSERT INTO mgc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mati Yësu inde yada mala nenye'e ku, mo ila bi nani ");
INSERT INTO mgc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ënyï ï'bë hulëhu mï gawo 'bënï Nazereta. Mo ayëtï kö'du mï bi 'ba mötu, mora zë ma owonnï kö'du yëtï 'bɔmo ne, zë rakaga aba. Zë ako'jonnï kö'du, iyannï henye, “Here mo i'ja kö'du yɔlɔ mahere ne ta kila? Mora kö'du ko'do 'bɔmo ne'e? ");
INSERT INTO mgc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mo ra dë wisi 'ba vo wakïsë? Mariya ra dë ma mo, Yemisi, Yosepa, Simona, mora Yudasi, zë ra dë na öndu mo'e? ");
INSERT INTO mgc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ëmï mo'e ra dë ëdïnnï alima kinye ne? Mo i'ja kö'du nenye biya ta kila?” ");
INSERT INTO mgc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mora here, zë ombannï mo dë. Yësu iya zi zë henye, “Nëbï oro ta ga bi ne biya nje mï gawo 'bɔmo vo dakota 'bɔmo ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mo o'dɔ kö'du ko'do dë ani, ga kö'du zë anza nnï dë kö'du koma aba.” ");
INSERT INTO mgc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mï kadra nani Heroda vo dakaŋo owo kö'du Yësu mo ayada zi vo mï ");
INSERT INTO mgc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","turu ënïye henye, “Tïnyö Yowani Bapatisi ra ënyï ku na dïdï.” “Kö'du nere ra mo ëdï kyigɔ nenye aba, zi kö'du ko'do ne'e ko'dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kö'du Heroda ra kyere ï'dï kö'du zi Yowani kïrï kida mo nyɔri aba ku'du mï kamba. Mo o'dɔ kö'du ne ga kö'du Herodiya mbara 'ba öndu mo Pilipo. ");
INSERT INTO mgc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mï kadra maako aba, Yowani Bapatisi ayada zi Heroda, iya henye, “Anza na laka zi yï Herodiya koze.” ");
INSERT INTO mgc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Here Heroda omba zi mo kofo, mora ere kazi vïdï 'ba Yuda'e ga kö'du zë asösu 'bënnï Yowani ne nëbï ra. ");
INSERT INTO mgc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Here mï kadra ko'jo 'ba Heroda aba wu'jë 'ba Herodiya ɔlɔ komo vïdï kayo. Heroda gbɔ rakyenyi aba ");
INSERT INTO mgc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","alömu zi mo, iya henye, “Malömu ku zi kï'dï zi yï wa ma ako'jo kö'du ga kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Here tëmï kö'du sösu 'bama mo, mo ako'jo hɔ mo, iya henye, “ï'dï zi ma kinye yaanya aba da Yowani Bapatisi da gbenje ne.” ");
INSERT INTO mgc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yere gbɔ kazi rakyenyi ga kö'du lömu ma mo o'dɔ ta da komo yingɔ 'bënï ne'e biya ne, mo ï'dï kö'du zi wu'jë ne, da kö'du wa ko'jo 'bɔmo omba ku. ");
INSERT INTO mgc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Here mo ï'dï kö'du ikye da Yowani gbɔ mï kamba, ");
INSERT INTO mgc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","dɔ mo ne ika mï gbenje mora ï'dï gbɔ zi wu'jë ne, mo oba ika gbɔ zi ma nï. ");
INSERT INTO mgc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Vo lö'bö a Yowani ayi ïnjënnï yöku mo usu, mora zë ï'bë ayadannï kö'du mo gbɔ zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mati Yësu owo kö'du Yowani, mo ɔsɔ ani mï töŋbö, ënyï ï'bë ga bi mbiya na bi dënï. Here vïdï owonnï kö'du mo ënyï ilannï gawo 'bënnï, ï'bënnï ga ndï mo aba ta akaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yësu ënyï asi yaga tëmï töŋbö, mati mo ongɔ vïdï kayo ne'e, di'di mo oso gbɔ ndɔ na kö'du sösu ga kö'du zë, mo akɔ'jɔ zë ma na rakɔɔ ne'e gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hutaga nani aba, vo lö'bö 'bɔmo ayinnï zi mo iyannï henye, “Bi ku ra hutaga bi nenye bi mbiya ra, utu vïdï ne'e liŋɔ mï'bënnï wakonyo kogo zi nnï.” ");
INSERT INTO mgc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yësu aya'ba da me'do zi zë iya henye, “Zë mï'bënnï dë. 'E na bi de 'e, ï'dïye wakonyo zi zë konyo.” ");
INSERT INTO mgc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Zë aya'bannï da me'do, iyannï henye, “Wa biya ma dëdï mo aba kinye mangɔlɔ'bɔ muyï kyenze rïyö.” ");
INSERT INTO mgc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yësu iya zi zë henye, “Ika'e zë zi ma kinye.” ");
INSERT INTO mgc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mo ï'dï kö'du gbɔ zi vïdï ne'e limannï akaŋo da loma, mo oba mangɔlɔ'bɔ muyï kyenze rïyö ne aba, ongɔ bi rïyë o'dɔ öwö'dï zi Wïrï. Mo owe mï mangɔlɔ'bɔ ne'e ï'dï zë gbɔ zi vo lö'bö'e, vo lö'bö ï'dï zë gbɔ zi vïdïye. ");
INSERT INTO mgc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vïdï biya onyo ɔvɔnnï mora vo lö'bö obannï baga 'butë dɔmorïyö ndɔ na kɔsɔ wa ma ɔsɔ. ");
INSERT INTO mgc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Watiti 'ba vïdï kora ma onyonnï wa ne, ëdï kpulukumuyï vïdï, mbara gisisi ëtï iti dë. ");
INSERT INTO mgc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Here Yësu ï'dï vo lö'bö'e tëkyïnnï mï töŋbö tï'bënnï dagba kapa föfö mɔtɔ, mora mo iya vïdï ne'e mï'bënnï 'de. ");
INSERT INTO mgc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ta pëtï utu vïdï ne'e ku, mo ï'bë da lutu rïyë kutï nï aba amötu. Mati hutaga ɔkɔ, Yësu ëdï gbɔ ani kutï nï aba. ");
INSERT INTO mgc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mï kadra ne töŋbö ëdï ku na kɔwɔ mï kutë wini 'ba föfö rë nï kɔhɔ kazi wini kagba, ga kö'du buluku ëdï aluku zɔ kï'dï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tëmï kutë kadra wota, modaka aba mï da mïndö, Yësu ayi zi vo lö'bö'e lasi aba ta da wini. ");
INSERT INTO mgc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mati zë ongɔnnï mo ëdï alasi ta da wini, zë na tere. Zë iyannï kudu aba na tere henye, “Ne gïlïlö 'ba yöku ra.” ");
INSERT INTO mgc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yësu ame'do kandi zi zë iya henye, “Uku mï ye, ne ma ra, ere'e dë.” ");
INSERT INTO mgc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Here Petero ame'do rïyë iya henye, “Yere ëzë ëdï tïnyö yï ra ï'dï kö'du zi ma tï'bë ta da wini zi yï ani.” ");
INSERT INTO mgc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yësu aya'ba da me'do iya henye, “Ayi.” Petero asi yaga tëmï töŋbö ayeto gbɔ tï'bë ta da wini zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mati mo ongɔ buluku kyigɔ ne, mo na tere ayeto zi lëndï akaŋo mï wini. Mo udu “Ayɔmɔ ma Yere.” ");
INSERT INTO mgc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kandi Yësu akako Petero kala nï aba, iya zi mo henye, “Ëdï kö'du koma aba tisiwa. Kö'du a'di dë yï jijiji gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Here zë 'dö rïyö ëkyïnnï mï töŋbö, buluku ɔrɔ gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Here zë ma mï töŋbö ne'e ayetonnï Yësu, iyannï henye, “Tïnyö yï Wisi 'ba Wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zë umunnï kyëtï 'ba föfö ayinnï gawo 'ba Genesereta, ");
INSERT INTO mgc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ani vïdï ayɔlɔnnï Yësu gbɔ, zë utunnï kö'du zi vïdï 'ba rakɔɔ'e biya kpo tara gawo nani, ikannï zë gbɔ zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Zë alenzennï mo zi kila zë mati kɔɔ aba ne, gbï nje zi ha bɔngɔ ɔmo kisa, zë biya ma isennï ne, akɔ'jɔ zë gbɔ ŋbala. ");
INSERT INTO mgc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kya 'ba Farasiye nnï vo komoyandi 'ba kö'du kï'dï ëtï, ayinnï ta Yerusalema zi Yësu, ako'jonnï hɔ mo, iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kö'du a'di vo lö'bö 'bëyïye ɔwɔnnï kö'du kï'dï ma kyedre 'beze ilannï zi ze ne dë? Akaka kala nnï dë tëmï gërï ma laka gba kazi wakonyo.” ");
INSERT INTO mgc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yësu aya'ba dɔ mo iya henye, “Mora kö'du a'di ɔwɔ'e kö'du a Wïrï dë, ïrïye ga ndï kö'du yandi 'be'e? ");
INSERT INTO mgc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kö'du Wïrï iya henye, ‘Ɔwɔ 'bu yï ma yï aba. Vïdï ma asënë 'bu nï mandere ma nï akï'dï mo zi kofo.’ ");
INSERT INTO mgc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mora ayandi 'e henye, ëzë vïdï maako ëdï wa aba, mo mo'dɔ zi 'bu nï kɔnyi mandere ma nï. Mora iya henye, nenye 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mo omba dë zi 'bu nï tɔwɔ. Tëmï gërï ne ɔwɔ'e kö'du kï'dï a Wïrï dë, ga kö'du zi ga ndï kö'du yandi 'be ra kïrï. ");
INSERT INTO mgc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","'E vo komokandi ne'e, kö'du 'ba Yisaya ëdï tïnyö, kaa ma mo iya kö'du ga kö'du ko'dɔ 'be'e.” ");
INSERT INTO mgc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Wïrï iya henye, “Vïdï nenye'e ɔwɔnnï ma me'do hë nnï aba, di'di zë tïnyö na kɔwɔ tara ma. ");
INSERT INTO mgc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Here anza na laka zi zë ma yeto, ga kö'du ëdïnnï kö'du kï'dï 'ba vïdï köndu ra yandi mo kaa kö'du kï'dï ama.” ");
INSERT INTO mgc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yësu ako'jo vïdï kayo zi nï iya zi zë henye, “Owo'e, ayɔlɔ'e. ");
INSERT INTO mgc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Anza dë wa ma ï'bë ta ha vïdï mï mo ra o'dɔ mo na ti'da, wa ma asi yaga ta hɔ mo ra o'dɔ mo na ti'da” ");
INSERT INTO mgc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Here vo lö'bö ɔmo ayinnï zi mo iyannï henye, “Ayɔlɔ'e ku henye ere, Farasi anzannï dë na rakyenyi mï kö'du kiya 'bëyï ne?” ");
INSERT INTO mgc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yësu aya'ba da me'do iya henye, “Wevo mati 'bu komorïyë ra dë yï akotɔ 'de.” ");
INSERT INTO mgc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Asösu'e kö'du zë dë. Zë vo dagba 'ba vo komoköndu. Ëzë kora vo komoköndu maako akɔkɔ vo komoköndu agamo, zë 'dö rïyö akalëpïnnï mï wogo.” ");
INSERT INTO mgc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petero ënyï ame'do rïyë iya henye, “Ayada mï ï'jö me'do ne te zi ze.” ");
INSERT INTO mgc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yësu iya zi zë henye, “Anza'e dë gba ndrë na komokandi ta da oka'e. ");
INSERT INTO mgc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ayɔlɔ'e dë? Wa ma ï'bë ta ha vïdï ï'bë mï mo mora gbɔ yaga tëmï ida rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mora wa ma asi yaga ta ha, ayi tëmï di'di, ne wa ma o'dɔ vïdï na ti'da ");
INSERT INTO mgc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tëmï di'di mo ayi kö'du sösu ma kyënyë, ma akï'dï mo zi wa kofo, ndoro ko'dɔ, kö'du kyënyë maako'e ko'dɔ mo aba, zi wakɔlɔ, ndɔndɔ, kö'du kyënyë kiya ra oka'e. ");
INSERT INTO mgc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nenye'e wa ma ëdïnnï vïdï ko'dɔ na ti'da, zi wakonyo kazi kala'e kaka, kaa ma zë iyannï ne, o'dɔ vïdï dë na ti'da.” ");
INSERT INTO mgc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yësu ila bi nani ënyï ï'bë dakaŋo ma kara ra gawo kyedre 'ba Tiyere nnï Sidoni aba. ");
INSERT INTO mgc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mbara 'ba Kanana maako ma alima bi nani ayi zi mo. Ënyï udu rïyë, iya henye, “Wisi 'ba Dawidi, akɔnyi ma kyedre. Wu'jë ama ëdï dakyikyi aba, mï riti kyedre.” ");
INSERT INTO mgc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yësu iya me'do ako dë zi mo. Vo lö'bö 'bɔmo ayinnï zi mo alenzennï mo iyannï henye, “Ore mo 'de, mo ëdï ga ndi ze kïrï kpɔrɔ nenye ko'dɔ aba.” ");
INSERT INTO mgc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yësu aya'ba dɔ mo iya henye, “Utu ma nje zi vïdï 'ba Yiserele'e ma ölunnï.” ");
INSERT INTO mgc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mati here ne, mbara ne ayi alëpï ndï mo. Mo iya henye, “Akɔnyi ma Yere.” ");
INSERT INTO mgc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yësu aya'ba dɔ mo iya henye, “Anza dë na laka zi wakonyo a gisisiye ku'du mo zi wïhïye.” ");
INSERT INTO mgc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mo aya'ba dɔ mo iya henye, “Ne tïnyö Yere, wïhï ëdïnnï kpa wakonyo ma ɔsɔ alëpï ta da tarabiza 'ba kyedre 'bëzë 'e ne konyo.” ");
INSERT INTO mgc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yësu aya'ba dɔ mo zi mo iya henye, “Yï mbara 'ba kö'du koma kyedre aba. Mï kadra tisi nani wu'jë ɔmo akɔ'jɔ rë nï gbɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yësu ila bi nani ënyï ï'bë na konda ta da kapa föfö 'ba Galilaya. Mo ëkyï da lutu alima akaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Vïdï kayo ayinnï zi mo, ikannï aba, vo keŋe, vo komoköndu, vo ka'bo, vo ha ngulu vïdï rakɔɔ maako'e kyɔ ma ï'dïnnï zë ndï Yësu, mo akɔ'jɔ zë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Vïdï ne'e na rakaga ma ongɔnnï vo ha ngulu ëdï ku ame'do, vo ka'bo ku na laka, ma keŋe ëdï ku alasi, vo komoköndu ëdï ku bi kongɔ, ayetonnï Wïrï 'ba Yiserele gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yësu ako'jo vo lö'bö 'bënïye zi nï iya zi zë henye, “Ma rasösu aba ga kö'du vïdï nenye'e, ga kö'du zë ëdïnnï ku ma aba, ko'do wota aba yaanya aba anzannï dë waako aba zi konyo. Momba dë zë kutu kazi wakonyo, ga kö'du atëdïnnï na riti ta da gërï 'bëzë liŋɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Here vo lö'bö 'bɔmo ako'jonnï hɔ mo iyannï henye, “Da ki'ja ze wakonyo kyɔ mï da lëpï nenye zi kï'dï zi vïdï kayo nenye'e ta kila?” ");
INSERT INTO mgc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yësu ako'jo hë zë iya henye, “Ëdïye mangɔlɔ'bɔ aba ndö?” Aya'bannï dɔ mo iyannï henye, “Mangɔlɔ'bɔ madɔmorïyö nzoyi, kyenze ëdï tisiwa.” ");
INSERT INTO mgc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yësu iya kö'du gbɔ zi vïdï kayo ne zi limannï akaŋo dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mo oba mangɔlɔ'bɔ madɔmorïyö kyenze ne aba o'dɔ öwö'dï zi Wïrï, owe mï zë ï'dï zë zi vo lö'bö'e, vo lö'bö'e ï'dï zë zi vïdï ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Zë onyonnï mora ɔvɔnnï. Here vo lö'bö obannï koṛi madɔmorïyö ndɔndɔ na nzoyi ma ɔsɔ. ");
INSERT INTO mgc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Watiti 'ba vïdï kora ma onyonnï ëdï 4,000 vïdï mbara gisisi ëtï iti dë. ");
INSERT INTO mgc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mati Yësu utu vïdï ne'e ku 'de, ëkyï mï töŋbö ï'bë mï dakaŋo 'ba Magadoni. ");
INSERT INTO mgc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kya 'ba Farasiye nnï Sadeke ëtï ayinnï zi Yësu ombannï zi mo yɔnzɔ ako'jonnï hɔ mo kö'du ko'do ko'dɔ mo zi zë, zi yada Wïrï ra omba da kö'du zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mora Yësu aya'ba dɔ mo iya henye, “Ëzë kadra ëdï ku loso, iya 'e henye, ‘Dëdï ku tï'bë zi komo bi laka ki'ja, ga komo bi ëdï na kahi.’ ");
INSERT INTO mgc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ŋbɔ da mïndö aba, iya 'e henye, ‘Omba ku zi ta'di, ga kö'du komo bi na kahi a'ba na köndu.’ Aka me'do'e kö'du 'ba komo bi ne bi kongɔ aba komorïyë, mora ɔ'bɔ'e me'do dë kö'du kyïnë 'ba kadra ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hala kö'du kyënyë vïdï ma ndenye ne kazi Wïrï. Ako'jo 'e ha ma ga kö'du ko'do? 'E'e, kö'du ko'do ma aki'di zi ye nje kö'du ko'do 'ba Yona.” Here Yësu ila zë ënyï ï'bë wënï 'de. ");
INSERT INTO mgc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mati vo lö'bö'e umu nï kyëtï föfö maaga mo, kö'du mangɔlɔ'bɔ ölu ta dë zë zi kobannï aba. ");
INSERT INTO mgc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yësu iya zi zë henye, “Andire'e ëdï 'e bi kida aba kö'du langa 'ba Farasiye nnï Sadeke ëtï.” ");
INSERT INTO mgc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zë ayetonnï gbɔ me'do na ga rë nnï iyannï henye, “Mo iya kö'du ne ga kö'du doba 'e mangɔlɔ'bɔ maako dë.” ");
INSERT INTO mgc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yësu ayɔlɔ kö'du ma zë ëdïnnï kiya ne, here mo ako'jo hë zë iya henye, “Kö'du a'di ëdïye ame'do na ga re 'e kö'du mangɔlɔ'bɔ ma anza dë? Hala ëdïye koma tisi aba. ");
INSERT INTO mgc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gba ayɔlɔ'e dë? Mangɔlɔ'bɔ muyï ma minye mï mo kö'du vïdï kora kpulukumuyï ne dë? Koṛi ndö ma oso'e? ");
INSERT INTO mgc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mora ëdï hala kö'du mangɔlɔ'bɔ madɔmorïyö kö'du vïdï kora kpulukusowɔ ne? Koṛi ëdï ndö ma oso'e? ");
INSERT INTO mgc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hala ayɔlɔ'e dë manza dë ame'do zi ye kö'du 'ba mangɔlɔ'bɔ? Ongɔ'e ga re 'e kazi langa 'ba Farasiye nnï Sadeke ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Here vo lö'bö ayɔlɔnnï mo anza dë kö'du ne kiya zi ga rë nnï kongɔ kazi mangɔlɔ'bɔ ma o'dɔ langa aba, wënï ga kö'du yandi 'ba Farasiye nnï Sadeke ëtï.” ");
INSERT INTO mgc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yësu ënyï ï'bë daliŋɔ ma kara ra gawo 'ba Kasariya Filipo, bi ma mo ako'jo ha vo lö'bö 'bënïye iya henye, “Ëyï ra vïdï ëdïnnï akiya mo Wisi a Vïdï?” ");
INSERT INTO mgc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Zë aya'bannï dɔ mo iyannï henye, “kya vïdï maako'e iyannï henye, Yowani Bapatisi ra.” “Agamo'e iyannï Eliya ra, mora agamo'e iya 'bënnï Yeremaya ra mandere kya 'ba nëbï maako.” ");
INSERT INTO mgc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mo ako'jo hë zë iya henye, “Mora 'e 'be'e? Iya 'be'e ma ëyï?” ");
INSERT INTO mgc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petero ënyï aya'ba dɔ mo iya henye, “Yï Korisitɔ ra, Wisi 'ba Wïrï wïdï.” ");
INSERT INTO mgc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yësu ënyï aya'ba dɔ mo iya henye, “Laka, Simona wisi 'ba Yona ga kö'du, tïnyö nenye ayi dë zi yï kazi vïdï köndu maako. Ï'dï mbïyï zi yï kazi 'bu ma komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Here mayada zi yï Petero, mako'ba kanisa a ma mora gbï le koli ɔ'bɔ dë zi dɔ mo kohe. ");
INSERT INTO mgc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Makï'dï gbalaka 'ba Damöku 'ba Wïrï zi yï, kö'du ma ida dakaŋo kinye, akida kpa komorïyë, kö'du ma inga dakaŋo kinye, akinga kpa komorïyë.” ");
INSERT INTO mgc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Here Yësu ise gɔ mo zi vo lö'bö 'bënï ne'e mayadannï dë zi vïdï kölö maako nï Korisitɔ ra. ");
INSERT INTO mgc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mï kadra nani zɔ dagba Yësu ayeto kiya kö'du riti 'bënï koli aba zi vo lö'bö 'benïye kazi koho, iya henye, “Makatï'bë mï Yerusalema mora matëdï riti aba kazi kyedre'e, vo da karasa'e vo komoyandi 'ba vo kö'du kï'dï ëtï. Akï'dïnnï ma zi kofo, mora ta pëtï ko'do da wota aba, matënyï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Here Petero oba mo tisi dakapa ayeto gbɔ mo wasa iya henye, “Anza here Yere, kö'du ne mo'dɔ rë nï dë zi yï.” ");
INSERT INTO mgc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yësu opi komo nï da Petero iya nenye, “Ënyï 'de ta ra ma, Satani. Yï ra na wayata mï gërï ama, ga kö'du sösu 'bëyï ne ayi dë kazi Wïrï, mora kazi kö'du ko'dɔ 'ba vïdï köndu.” ");
INSERT INTO mgc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mora here, Yësu iya zi vo lö'bö 'bënnïye henye, “Ëzë vïdï maako omba tayi zi ma, kö'du mo mölu ta dɔ mo, mïnjë taka 'bënï malö'bö ga ma. ");
INSERT INTO mgc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vïdï ma omba zi dïdï 'bënï yɔmɔ akayölu mora vïdï ma ayölu dïdï nï kö'du ma aki'ja. ");
INSERT INTO mgc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Vïdï atëdïnnï wa aba ëzë zë ïrïnnï damöku ne biya mora ayölu dïdï nnï? Anza here dë. Waako anza ani dë zi kï'dïnnï zi dïdï nnï ya'ba mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kö'du Wisi 'ba Vïdï omba ku zi tayi mï bikanyi kyedre 'ba 'bu nï malayika ënï ëtï, mora mo akï'dï biriti zi vïdï maako mï kö'du ko'dɔ 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Miya zi ye henye, kya vïdï maako'e ëdïnnï kinye akolinnï dë, zë akongɔnnï bi tayi 'ba Wisi 'ba Vïdï mï damöku 'bënï.” ");
INSERT INTO mgc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tapëtï ko'do modaka aba, Yësu oba Petero, Yemisi öndu nï Yowani aba, ënyï ï'bënnï rïyë da döku konda na bi dë nnï. ");
INSERT INTO mgc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mati zë ëdïnnï bi kongɔ rakofɔ ayi zi Yësu, komo mo ëdï alaka kaa kadra, bɔngɔ 'bɔmo ofɔ rë nï na kanyi. ");
INSERT INTO mgc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Vo lö'bö wota ne'e, ongɔnnï Mosa nnï Eliya aba, ëdï ame'donnï Yësu ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero ame'do rïyë zi Yësu, iya henye “Yere, ëdï na laka ze kinye. Ëzë omba, ma kuvö gövö wota kinye. Kölö zi yï, kölö zi Mosa, mora kölö zi Eliya.” ");
INSERT INTO mgc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mati mo ëdï gba ame'do, fɔli laaka ayi ɔrɔ rïyë dë zë, gu aa tëmï fɔli iya henye, “Nenye gogo wisi ama ra, ma na rakyenyi mo aba. Owo'e dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mati vo lö'bö owonnï me'do ne, zë na tere umë rë nnï na mï yöfu dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yësu ënyï ayi ise rë zë, iya henye, “Ënyïye rïyë, ere 'e dë.” ");
INSERT INTO mgc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Here zë ongɔnnï bi rïyë i'jannï vïdï maako dë, du Yësu kutï nï aba. ");
INSERT INTO mgc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mati zë ëdï tasinnï akaŋo ta da döku, Yësu iya zi zë henye, “Ayada'e dë zi vïdï maako kö'du mati ongɔ'e ne, le ëzë Wisi a Vïdï ënyï ku tëmï koli.” ");
INSERT INTO mgc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Vo lö'bö ako'jonnï ha Yësu iyannï henye, “Kö'du a'di vo komoyandi 'ba kö'du kï'dïye, iyannï henye ere, Eliya ra atayi dagba?” ");
INSERT INTO mgc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yësu aya'ba da me'do zi zë iya henye, “Eliya ra ëdï tayi dagba, mo akakɔ'jɔ wasisi nzɔ. ");
INSERT INTO mgc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mayada zi ye henye, Eliya ɔkɔ ku nzɔ, vïdïye ra ayɔlɔnnï mo dë o'dɔnnï mo kaa zë omba nnï. Tëmï gërï kölö ne zë ako'dɔnnï Wisi 'ba Vïdï kpa here.” ");
INSERT INTO mgc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Vo lö'bö ënyï ayɔlɔnnï mo ëdï ame'do zi nnï ne, kö'du 'ba Yowani Bapatisi. ");
INSERT INTO mgc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mati zë a'bannï zi vïdï kayo ne'e, kora maako ayi zi Yësu alɔdrɔ da womo nï aba akaŋo komo Yësu, ");
INSERT INTO mgc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","iya henye, “Yere, ï'dï mïyï mëyï ra wisi ama ne. Mo ëdï kɔɔ nökï aba na kyënyë, ëdï mo kumë kadra maako aba mï wa'do, mandere mï wini. ");
INSERT INTO mgc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mika mo zi vo lö'bö 'bëyïye, ɔ'bɔnnï dë mo kɔ'jɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yësu aya'ba dɔ mo, iya henye, “'E vïdï kazi koma kö'du kyënyë aba ne'e, omba 'e zi ma tëdï ëtï le ndala aba? Omba'e zi ma lima ëtï le ndala aba? Ika 'e wisi ne zi ma.” ");
INSERT INTO mgc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yësu ï'dï kö'du zi dakyikyi ne, ënyï asi gbɔ yaga tara wisi ne, mï kadra nani akɔ'jɔ mo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Vo lö'bö ayinnï zi Yësu liya ako'jonnï hɔ mo, iyannï henye, “Kö'du a'di dore ze dakyikyi dë gɔ mo yaga?” ");
INSERT INTO mgc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yësu aya'ba da me'do zi zë iya henye, “Miya zi ye henye, ëzë ëdïye koma aba kaa kofo masatada ma tisi, akiya'e zi lutu nenye henye, ‘Ï'bë ta kinye nani!’ atï'bë. Ako'dɔ'e wa biya.” ");
INSERT INTO mgc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mati vo lö'bö 'ba Yësu ayi atoto rë nnï ku biya mï Galilaya, Yësu iya zi zë henye, “Wisi 'ba Vïdï omba ku kï'dï mo zi vïdï ");
INSERT INTO mgc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","akofonnï mo, ko'do da wota aba mo atënyï na dïdï tëmï koli.” Vo lö'bö'e na rasösu ga kö'du mati Yësu iya akofo nï ne. ");
INSERT INTO mgc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mati Yësu vo lö'bö 'bënï ëtï ayinnï mï Kaparanamo, vo 'be'bele kö'du 'ba yëkëlu ayi zi Petero ako'jo hɔ mo iya henye, “Vo komoyandi 'be'e ëdï 'be'bele loko 'ba Wïrï kopi?” ");
INSERT INTO mgc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero aya'ba dɔ mo, iya henye “Ëdï here.” Mati Petero ï'bë liŋɔ, Yësu ame'do dagba, “Simona, kö'du sösu 'bëyï a'di? Ëyï ra ëdïnnï 'be'bele kopi zi yeree 'ba dakaŋo nenye? Vo gisi 'ba dakaŋo'e ra kɔdɔ tu'dë maako'e?” ");
INSERT INTO mgc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero aya'ba dɔ mo iya henye, “Vo leze'e ra.” Yësu aya'ba dɔ mo iya laka, “Gisi 'ba dakaŋo'e opinnï dë. ");
INSERT INTO mgc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Domba dë zi vo 'be'bele kö'du ne'e ko'dɔ mo zi tënyïnnï na kamo. Ï'bë mï föfö kyenze kïrï. Otɔ yaga dagba kyenze mati ïrï ku ne, ayëhu hɔ mo aki'ja kɔhi ŋbiriṛi kyɔ kö'du 'be'bele 'bama 'ba loko 'ba Wïrï 'bëyï aba. Oba zë opi na 'be'bele 'bama 'be'e aba.” ");
INSERT INTO mgc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mï kadra nani vo lö'bö ayinnï zi Yësu ako'jonnï hɔ mo, iyannï henye, “Ëyï ra 'bënï na kyedre mï damöku 'ba Wïrï?” ");
INSERT INTO mgc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yësu ako'jo wisi ï'dï mo atɔrɔ komo zë, ");
INSERT INTO mgc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Mora iya henye, “Miya zi ye tïnyö, ëzë ofɔ re 'e dë kaa gisisi mï di'diye, ödu'e dë mï damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Vïdï ma kyedre mï damöku 'ba Wïrï ra mati aya'ba rë nï tisi kaa wisi nenye. ");
INSERT INTO mgc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ëzë vïdï mati ïrï wisi kaa nenye kala kyedre aba mï ru ma, ïrï ma ku.” ");
INSERT INTO mgc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ëzë vïdï maako o'dɔ wisi kölö tëmï gisisi nenye'e mo oma mï kö'du kyënyë ko'dɔ, ëdï na laka kö'du vïdï nani zi yïtö kyedre 'ba wakuhu kida gu mo, zi kuyï mo mï wulu ma yöndu ne. ");
INSERT INTO mgc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Atëdï na riti zi vïdï 'ba damöku nenye, kö'du wa maako mati ëdï zi ko'dɔ zë zi kö'du kyënyë ko'dɔ. Wa ne ako'dɔ rë nnï 'duwï, atëdï na riti zi vïdï mati ï'dï zë zi rë nnï ko'dɔ ne. ");
INSERT INTO mgc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ëzë kala yï mandere ndï yï o'dɔ yï zi kö'du kyënyë ko'dɔ, ikye u'du 'de yaga. Ëdï na laka zi yï tödu mï dïdï kazi kala, mandere ndï ta da sesi kala 'dö rïyö, ndï kpa 'dö rïyö zi ku'du mï wa'do kazi tölu. ");
INSERT INTO mgc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ëzë komo yï o'dɔ yï zi kö'du kyënyë ko'dɔ, otɔ u'du 'de yaga. Ëdï na laka zi yï tödu mï dïdï komo aba nje kölö ta da sesi komo 'dö rïyö zi ku'du mï wa'do 'ba gehena.” ");
INSERT INTO mgc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Komo'e mëdï re 'e, awasa'e dë gisisi. Miya zi ye henye, malayika 'bëzë ëdï 'duwï ŋburu komo 'Bu ma komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A'di ra asösu 'bëyï ëzë vïdï kora ëdï tïmëlë aba lamikölö, ma kölö ölu tëmï zë ako'dɔ? Mo akila ma lamikölö 'butëmodɔmosowɔ dɔmomodɔmosowɔ bi wakonyo dakapa lutu, atï'bë koma tïmëlë mati ölu ne dë ya? ");
INSERT INTO mgc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ëzë mo i'ja ku, mayada zi ye henye, mo atëdï rakyenyi aba ndra kö'du tïmëlë kölö ne ta da ma lamikölö 'butëmodɔmosowɔ dɔmomodɔmosowɔ ma ölunnï dë ne. ");
INSERT INTO mgc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tëmï gërï kölö ne, 'Bu'e komorïyë omba dë zi ma kölö tëmï zë zi tölu. ");
INSERT INTO mgc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ëzë öndu yï o'dɔ kö'du kyënyë zi yï, ï'bë ayada kö'du kyënyë 'bɔmo ne zi mo, o'dɔ na liwo, nje tëmï kutë'e. Ëzë mo owo kö'du 'bëyï ne ku, ayɔmɔ mo ku tëmï kö'du kyënyë ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ëzë mo owo kö'du 'bëyï ne dë, oba kölö mandere rïyö vïdï kya mo'e yï aba, kö'du wa sösu ne zi vo hu kö'du dɔrɔ tëdïnnï rïyö, mandere wota kaa mati ko'du yöru iya. ");
INSERT INTO mgc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ëzë mo owo dë zë dë, ayada kö'du ne biya zi vïdï 'ba kanisa. Ndundu mo aba ëzë mo owo da vïdï 'ba kanisa dë, o'dɔ mo kaa vo leze mandere kaa vo 'be'bele kö'du. ");
INSERT INTO mgc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tïnyö mayada zi ye henye, kö'du mati ida ku mï dakaŋo kinye, akida kpa komorïyë, kö'du mati inga ku dakaŋo kinye, akinga kpa komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mayada kyɔ zi ye, ëzë vïdï rïyö tëmï 'e dakaŋo nenye omba da kö'du wa mati amötu'e kö'du mo, 'bu ma komorïyë ako'dɔ zi ye. ");
INSERT INTO mgc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ëzë vïdï rïyö mandere wota atoto rë nnï bi kölö mï ru ma, ma mëdï zë ëtï.” ");
INSERT INTO mgc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petero ayi zi Yësu ako'jo hɔ mo iya henye, “Yere, ëzë öndu ma ëdï nduwë kö'du kyënyë ko'dɔ ra ma makila mo da ndö? Modɔmorïyö?” ");
INSERT INTO mgc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“'Ë'e,” Yësu aya'ba dɔ mo iya henye, “Anza madɔmorïyö, 'butëmodɔmorïyö dɔmomodɔmorïyö, ");
INSERT INTO mgc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ga kö'du damöku 'ba Wïrï ëdï here. Kadra maako aba, yere maako omba zi kö'du kɔhi 'ba vo kalima 'bënïye mati obannï kazi nï kongɔ. ");
INSERT INTO mgc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mati mo ayeto ku zi ko'dɔ mo here, ma kölö tëmï zë ika 'bënï zi mo atiti gɔ mo miliyönï pawono. ");
INSERT INTO mgc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Vo kalima ne anza wa aba kyɔ dë, zi kɔhi ɔmo ne kopi. Yere ï'dï kö'du zi mo kogo 'de kaa vo kalima, mbara 'bɔmo, gisisi, biya wa mati mo ëdï mo aba kö'du zi yöngu ne kopi mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Vo kalima ne alɔdrɔ domo nï aba komo yere, ala'ba rë nï iya henye, ‘Mïyï mëyï ra ma, ma kopi wa 'bëyï ne biya zi yï.’ ");
INSERT INTO mgc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yere gbɔ rasösu aba kö'du mo, ila mo tëmï yöngu ne, ila mo ï'bë gbɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kora ne ënyï ï'bë andɔsi dë nnï, vo kalima oka nï mati oba kɔhi tisiwa aba kazi mo ne, ïrï mo ta gu mo ŋbïrï, iya zi mo henye, ‘Opi yöngu ama gë yï ne.’ ");
INSERT INTO mgc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Vo kalima oka mo ne alɔdrɔ akaŋo ala'ba rë nï zi mo iya henye, ‘Mïyï mëyï ra ma, ma kopi zi yï.’ ");
INSERT INTO mgc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mo omba dë ënyï u'du mo mï kamba le mo akopi yongu ne. ");
INSERT INTO mgc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mati kya 'ba vo kalima maako'e ongɔnnï kö'du mati o'dɔ rë nï ne, zë rasösu aba, ënyï ï'bë ayadannï kö'du ne gbɔ biya zi yere. ");
INSERT INTO mgc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yere ako'jo vo kalima ne loko iya zi mo henye, ‘Yï vo kalima kyënyë ra, mila yï kö'du wasisi mati oba kazi ma ne'e biya, nje ga kö'du ala'ba rë yï zi ma. ");
INSERT INTO mgc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Here kaa atëdï mïkyëyï aba ra oka yï ne kaa mati mo'dɔ mïkyëyï zi yï ne.’ ");
INSERT INTO mgc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Here yere gbɔ na kamo usu vo kalima ne mï kamba zi riti kï'dï zi mo le ëzë mo opi yongu ne ku biya.” ");
INSERT INTO mgc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yësu ï'dï dɔ mo gbɔ zi zë iya henye “Ne ëdï kö'du mati 'bu ma komorïyë ako'dɔ zi ye, ëzë ila'e ako'e dë tëmï di'diye.” ");
INSERT INTO mgc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mati Yësu inde me'do ne'e kiya ku, mo ila Galilaya ënyï ï'bë mï dakaŋo 'ba Yudiya kapa ranga 'ba Yeredene. ");
INSERT INTO mgc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Vïdï kayo alö'bönnï ga ndï mo, mo akɔ'jɔ zë gbɔ ani. ");
INSERT INTO mgc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kya 'ba Farasi maako'e ayinnï zi mo, ayɔnzɔnnï zi mo kuyï kö'du ko'jo aba, iyannï henye, “Kö'du kï'dï 'beze akila vïdï kora zi mbara 'bënï yëyï na yawa kaa mo omba?” ");
INSERT INTO mgc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yësu aya'ba dɔ mo iya henye, “Akɔ'jɔ'e kö'du yöru ne dë, mati iya henye, bi yeto aba Wïrï ï'dï vïdï kora mbara aba? ");
INSERT INTO mgc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wïrï iya henye, ‘Ga kö'du ne, vïdï kora akila 'bu nï, ma nï akadrɔko rë nnï mbara 'bënï aba, zë rïyö ne atëdïnnï na wa kölö.’ ");
INSERT INTO mgc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Here anzannï dë kpe rïyö, atëdïnnï kölö. Vïdï maako inye mï wa mati Wïrï adrɔkɔ ku bi kölö ne dë.” ");
INSERT INTO mgc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farasiye ako'jonnï hɔ mo iya henye, “Kö'du a'di Mosa ï'dï kö'du zi vïdï kora waraga 'ba rayëyï yöru, kï'dï zi mbara 'bënï mo kore 'de?” ");
INSERT INTO mgc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yësu aya'ba dɔ mo iya henye, “Mosa ï'dï kö'du zi ye mbara 'be'e yëyï, ga kö'du de 'e na kyigɔ zi yandi. Anza dë here, tëmï kadra mati bi o'dɔ rë nï. ");
INSERT INTO mgc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mayada zi ye henye, ëzë kora maako ayëyï mbara 'bënï 'beri ta da ndoro ko'dɔ, mo o'dɔ ndoro ku, ëzë mo ïrï mbara maako.” ");
INSERT INTO mgc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vo lö'bö 'bɔmo'e iyannï zi mo henye, “Ëzë ëdï ne kö'du mati mï kutë kora mbara 'bënï aba, here, vïdï moze mbara dekpe.” ");
INSERT INTO mgc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yësu aya'ba da me'do zi zë iya henye, “Kö'du yandi nenye anza dë zi vïdï biya, nje zi zë mati Wïrï ï'dï here. ");
INSERT INTO mgc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vïdï kora na lïmu kö'du o'jo zë here. Maako'e vïdï ra o'dɔ zë here, maako'e ombannï dë mbara koze ga kö'du 'ba damöku 'ba Wïrï. Mo mati atɔ'bɔ da kö'du yandi nenye komba, mo'dɔ here.” ");
INSERT INTO mgc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kya vïdï maako'e ikannï gisisi zi Yësu kala nï kï'dï dë zë zi mötu kö'du zë, vo lö'bö 'bɔmo ayatannï vïdï ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yësu iya zi zë henye, “Ila'e gisisi mayinnï zi ma, ayata'e zë dë, ga kö'du damöku 'ba Wïrï ra kaa nenye'e.” ");
INSERT INTO mgc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mo ï'dï kala nï dë zë ila zë ï'bë wënï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kadra maako aba, kora maako ayi zi Yësu ako'jo hɔ mo iya henye, “Vo komoyandi, kö'du laka a'di ra ma ko'dɔ zi ma dïdï ŋburu ki'ja?” ");
INSERT INTO mgc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yësu aya'ba dɔ mo iya henye, “Kö'du a'di ako'jo ha ma kö'du wa ma laka? Mo ma laka ëdï nje kölö. Ïrï ga ndï kö'du kï'dï ne, ëzë omba zi tödu mï dïdï ma ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mo ako'jo kö'du iya henye, “Kö'du kï'dï a'di?” Yësu ënyï aya'ba dɔ mo zi mo iya henye, “Ofo vïdï dë, o'dɔ ndoro dë, alogo dë, asusu vïdï maako dë na ndɔndɔ, ");
INSERT INTO mgc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɔwɔ 'bu yï ma yï aba, o'dɔ lɔvɔ vo haliŋɔ oka kaa mati o'dɔ lɔvɔ yï.” ");
INSERT INTO mgc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kora ne aya'ba da me'do iya henye, “Mɔwɔ kö'du kï'dï ne'e ku biya. A'di ra omba gba zi ma ko'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yësu iya zi mo henye, “Ëzë omba zi yï zi tëdï ŋbala, ï'bë ogo wa mati ëdï mo aba ne biya yaga, ï'dï kɔhi mo zi vo leriye, atëdï wa aba kyɔ komorïyë, ta pëtï mo ayi alö'bö ga ma.” ");
INSERT INTO mgc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mati kora ne owo kö'du ne here, ënyï ï'bë na rasösu ga kö'du mo wa aba kyɔ. ");
INSERT INTO mgc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yësu iya zi vo lö'bö 'bënïye henye, “Mayada zi ye, atëdï na kyigɔ zi vïdï ma wa aba kyɔ zi tödu mï damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Miya löhu zi ye henye; ëdï na kyigɔ ndra zi vïdï ma wa aba kyɔ zi tödu mï damöku 'ba Wïrï, ta da jemele tödu kpuru tëmï ogo 'ba ibira.” ");
INSERT INTO mgc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mati vo lö'bö owonnï kö'du ne, zë biya na rakaga. Zë ako'jonnï kö'du iyannï henye, “Mora here ne, ëyï ra akayɔmɔ?” ");
INSERT INTO mgc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yësu ongɔ bi mbïyï dë zë aya'ba dɔ mo iya henye, “Wa mahere ne, vïdï ɔ'bɔ dë ko'dɔ. Wïrï ra atɔ'bɔ ko'dɔ mo biya.” ");
INSERT INTO mgc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero ënyï ame'do rïyë, mo iya henye, “Ongɔ te, dila wasisi ku biya kö'du lö'bö gë yï. A'di ra datëdï ze mo aba?” ");
INSERT INTO mgc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yësu iya zi zë henye, “Mayada tïnyö zi ye Wisi a Vïdï alima ku da kyïtï 'bënï bikanyi laka 'bɔmo mï daliŋɔ kyï. Vo ga ndï ma 'butë dɔmorïyö 'bama ne, akalima 'e kpa da kyïtï 'ba tu'dë gisi 'ba Yiserele 'butë dɔmorïyö ne. ");
INSERT INTO mgc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Vïdï mati ila loko, öndu'e, ëmïye, 'bu, ma, gisisi, yaka ga kö'du ma aki'ja lami da kyɔ akï'dï dïdï ma ŋburu ŋburu zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yaanya aba zë mati kyɔ dagba ne atëdïnnï hulëhu, yaanya aba zë ma kyɔ hulëhu ne, atëdïnnï dagba.” ");
INSERT INTO mgc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Damöku 'ba komorïyë ëdï henye. Kora maako ëdï, mo ënyï gbɔ da mïndö aba tï'bë vïdï vo lɔɔ ko'dɔ'e koma, zi lɔɔ ko'dɔ mï yaka ënï. ");
INSERT INTO mgc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mo omba da kö'du zi kɔhi ŋbiriṛi kopi mo zi zë mï ko'do kölö, utu zë gbɔ lɔɔ ko'dɔ mï yaka ënï.” ");
INSERT INTO mgc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Mo ënyï ï'bë löhu bi 'ba wakogo, kadra mamodɔmosowɔ aba i'ja kya vïdï kora maako ëdïnnï tɔrɔ ani öŋbö kazi lɔɔ. ");
INSERT INTO mgc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mo ayada zi zë iya henye, ‘Ï'bë'e kpa lɔɔ ko'dɔ mï yaka ma kopi kɔhi zi ye na laka.’ ");
INSERT INTO mgc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ï'bënnï gbɔ. Kadra 'butë dɔmorïyö kadra wota aba, mo o'dɔ kpa kö'du kölö ne. ");
INSERT INTO mgc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ëdï kara zi kadra muyï mo ënyï ï'bë bi 'ba wakogo i'ja kya 'ba vïdï maako'e ëdïnnï gba tɔrɔ ani öŋbö. Mo iya zi zë henye, ‘Ëdï 'be'e atɔrɔ kadra loso de 'e kinye öŋbö kazi lɔɔ ga a'di?’ ");
INSERT INTO mgc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Zë aya'bannï dɔ mo iyannï henye, ‘Vïdï maako ï'dï lɔɔ dë zi ze.’ Mo iya henye, ‘Laka ï'bë'e lɔɔ ko'dɔ mï yaka ama.’” ");
INSERT INTO mgc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mati kadra ɔkɔ ku na hutaga, vo kyeti yaka ayada zi vo da lɔɔ ko'dɔ'e iya zi mo henye, ‘Akɔ'jɔ vo lɔɔ ko'dɔ ne'e opi kɔhi ëzë, ayeto zë mati ta da hulëhu ne, ndundu mo zë mati ma dagba.’ ");
INSERT INTO mgc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vïdï kora mati ayetonnï lɔɔ kadra muyï aba ne, opi kɔhi ŋbiriṛi zi ma kölö, kölö. ");
INSERT INTO mgc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kora mati o'dɔnnï lɔɔ dagba ayinnï zi kɔhi 'bënnï kïrï, asösunnï na kïrïnnï ndra, ma kölö opi kpa kɔhi ŋbiriṛi kölö. ");
INSERT INTO mgc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Zë ïrïnnï kɔhi 'bënnï ënyïnnï agbɔrɔ vo kyeti yaka aba. ");
INSERT INTO mgc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Zë iyannï henye, ‘Vïdï kora nenye'e mati o'dɔnnï lɔɔ ta da hulëhu nje kadra kölö, ze do'dɔ lɔɔ kadra ŋbo da kadra kyëtu ne, here ne opi kpa zi zë kaa mati opi ze ne?’” ");
INSERT INTO mgc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Vo kyeti yaka aya'ba dɔ mo zi ma kölö tëmï zë iya henye, ‘Owo te aboka ma mo'ba'e dë. 'E biya omba'e da kö'du zi lɔɔ ko'dɔ, kadra kölö ŋbo da kɔhi ŋbiriṛi kölö. ");
INSERT INTO mgc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yaanya aba oba kɔhi 'be'e ne, ï'bë'e liŋɔ. Momba zi kï'dï zi kora mati o'dɔ lɔɔ ta da hulëhu, kpa kyɔ kaa mati mï'dï zi ye ne. ");
INSERT INTO mgc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Here ne, manza dë dangölö aba zi ko'dɔ wa mati momba ko'dɔ mo kɔhi 'bama aba? Kɔdɔ 'e na mï kumbë ga kö'du ma na laka?’” ");
INSERT INTO mgc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yësu inde me'do 'bënï kiya mo aba henye, “Here zë mati hulëhu atëdïnnï dagba, mora zë mati dagba atëdïnnï hulëhu.” ");
INSERT INTO mgc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mati Yësu ëdï atï'bënnï mï Yerusalema, mo oba vo lö'bö 'bënï 'butë dɔmorïyö dakapa nï, ame'do zi zë na liwo. Mati zë ëdï atï'bënnï, mo ayada zi zë iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Owo'e te, dëdï ze tï'bë le mï Yerusalema, ani Wisi a Vïdï akï'dï zi kyedre 'ba vo karasa'e nnï vo komoyandi 'ba vo kö'du kï'dï ëtï. Zë akikyennï vurë rɔ mo zi kofo. ");
INSERT INTO mgc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zë akï'dïnnï mo zi vo leze'e ako'dɔnnï sawiya rɔ mo, aku'bönnï mo, akatötönnï mo da taka. Mora ko'do da wota aba, mo atënyï löhu na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Here mbara 'ba Zebedeyo ayi gisi kora 'bënï aba rïyö zi Yësu, alɔdrɔ komo mo ako'jo hɔ mo ga kö'du ko'dɔ laka. ");
INSERT INTO mgc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yësu ako'jo hɔ mo iya henye, “A'di ra omba?” Mo aya'ba da me'do iya henye, “Korisitɔ zi ma gisi kora rïyö 'bama nenye'e akalimannï da kala yï ma tïrï ma gali aba mï damöku 'be.” ");
INSERT INTO mgc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yësu aya'ba da me'do zi gisi kora ne'e, iya henye, “Ayɔlɔ'e wa mati ëdïye kö'du ko'jo gɔ mo ne dë. Atɔ'bɔ'e kïnjë riti mati momba zi kïnjë ne?” Zë aya'bannï da me'do iyannï henye, “Datɔ'bɔ ze.” ");
INSERT INTO mgc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yësu ayada zi zë iya henye, “Tïnyö akïnjë'e riti 'bama ama, mora mɔ'bɔ dë kyigɔ aba zi kinzi vïdï mati akalima da kala ma ma tïrï ma gali aba. Bi nenye'e kö'du vïdï mati 'bu ma akɔ'jɔ zi zë.” ");
INSERT INTO mgc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mati kya 'ba vo lö'bö 'butë owonnï kö'du ne, zë na kamo gisi öndu rïyö ne ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yësu ako'jo zë biya bi kölö iya henye, “Ayɔlɔ'e ku henye, vo daliŋɔ 'ba vo leze ne'e ëdïnnï kalakonda aba dë zë, vo dagba'e ëdïnnï ndra kalakonda aba. ");
INSERT INTO mgc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Here gërï mahere ne, manza dë mï kutë'e. Ëzë vïdï maako tëmï 'e omba zi tëdï kyedre, mo mëdï na vo lö'bö zi oka'e. ");
INSERT INTO mgc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ëzë vïdï maako tëmï 'e omba zi tëdï na vo dagba mo mëdï na vo kalima 'bëyï. ");
INSERT INTO mgc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kaa Wisi 'ba Vïdï ayi dë zi vïdï maako'e lɔɔ ko'dɔ zi mo, ayi zi ko'dɔ zi vïdï maako'e, dïdï nï kï'dï zi vïdï kayo yɔmɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mati Yësu vo lö'bö 'bënï ëtï ënyïnnï ku tï'bë 'de ta Yerïkö, vïdï kayo ënyïnnï ga ndï mo aba. ");
INSERT INTO mgc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Here kora vo komoköndu rïyö mati ëdï alimannï dakapa gërï, owonnï Yësu ëdï alaga ta da kapa, ayetonnï hë nnï gbögbö, “Wisi 'ba Dawidi ï'dï mïyï mëyï re ze.” ");
INSERT INTO mgc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Here vïdï kayo ne'e o'dɔnnï sawiya zi zë ayadannï zi zë iyannï henye, alima'e ti. Mora here, zë agbögbö hë nnï ndra na kamo, iyannï henye, “Yere Wisi 'ba Dawidi, ï'dï mïyï mëyï re ze.” ");
INSERT INTO mgc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yësu ɔrɔ ako'jo zë, ako'jo hë zë iya henye, “A'di ra omba'e zi ma zi ko'dɔ zi ye?” ");
INSERT INTO mgc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Zë aya'bannï da me'do iyannï henye, “Yere, domba ze zi bi kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yësu na rasösu kö'du zë, ise komo zë kandi ongɔnnï bi, mora alö'bönnï gbɔ ga ndï mo. ");
INSERT INTO mgc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mati Yësu vo lö'bö 'bënï ëtï ɔkɔnnï ku kara ra Yerusalema, zë ayinnï Betehege da Döku 'ba Olivo ani Yësu utu vo lö'bö 'bënï rïyö dagba. ");
INSERT INTO mgc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kö'du kise nenye aba iya henye, “Ï'bë'e zi daliŋɔ mati dagba komo'e nani, kandi aki'ja'e mokakya na kida wisi ënï aba dakapa nï, inga'e zë ika'e zë zi ma. ");
INSERT INTO mgc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ëzë vïdï maako iya kö'du maako, ayada'e zi mo ‘Yere ra omba zë mo akila zë tï'bë kandi.’” ");
INSERT INTO mgc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kö'du ne o'dɔ rë nï, zi kö'du mati nëbï iya ne tayi tïnyö. ");
INSERT INTO mgc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ayada zi gawo kyedre 'ba Ziyɔnɔ, ongɔ'e vo damöku 'be'e ëdï tayi zi ye. Mo umbë dënï dë, ëdï taho da mokakya, wisi mokakya ëdï zë aba.” ");
INSERT INTO mgc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Here vo lö'bö ne ï'bë o'dɔnnï kö'du ne te kaa mati Yësu ayada zi zë zi ko'dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Zë, ikannï mokakya ne wisi mo aba, o'bannï bɔngɔ 'bënnï dë zë Yësu ëkyï gbɔ dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Vïdï kayo o'ba bɔngɔ 'bënnï da gërï, agamo'e ikyennï da ngora 'ba kaga o'bannï zë da gërï. ");
INSERT INTO mgc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Vïdï kayo ne alagannï dagba komo Yësu, zë mati ëdï tayi 'bënnï ta gɔ mo, ayetonnï hë nnï gbögbö, iyannï henye, “Wayeto zi wisi a Dawidi. Wïrï ï'dï ya'da zi mo mati ayi mï ru 'ba Yere, wayeto zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mati Yësu ödu mï Yerusalema, da vïdï kayo mï gawo kyedre ne biya na wïrï wïrï. Here vïdï ako'jonnï kö'du iyannï henye, “Mo 'bënï ëyï ra?” ");
INSERT INTO mgc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vïdï kayo aya'bannï da me'do iyannï henye, “Nenye nëbï Yësu ra, tëmï Nazereta mï Galilaya.” ");
INSERT INTO mgc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yësu ï'bë ödu mï yëkëlu, ore vïdï mati ëdïnnï wakogo ne biya yaga. Mo adu'du da tarabiza 'ba vïdï 'ba kɔhi kutrë, gba'da 'ba vïdï mati ëdïnnï atu'bu kogo ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Mora iya zi zë henye, “Ëdï na yöru mï kö'du yöru, Wïrï iya ku henye, ‘Loko 'ba Wïrï ama ne ako'jo na loko 'ba mötu, ofɔ'e ku na wöru 'ba rakoho 'ba vo logo'e.’” ");
INSERT INTO mgc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vo komoköndu vo ka'bo ëtï ayinnï zi mo mï yëkëlu 'ba Wïrï mo akɔ'jɔ zë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kyedre 'ba vo karasa vo komoyandi 'ba vo kö'du kï'dï ëtï, ënyïnnï na kamo mati zë ongɔnnï kö'du ko'do mati Yësu ëdï ako'dɔ ne, gisisi ëdï hë nnï gbögbö mï yëkëlu, iyannï henye, “Wayeto zi Wisi a Dawidi.” ");
INSERT INTO mgc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Zë ako'jo nï ha Yësu iyannï henye, “Owo kö'du mati ëdïnnï akiya ne ku?” Yësu aya'ba da me'do iya henye, “Ɔɔ, mowo ku. Gba ako'jo'e kö'du yöru nenye dë? ‘Ayandiye gisisi, gisisi ëtï zi wayeto ma laka kï'dï.’” ");
INSERT INTO mgc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yësu ila zë ënyï ï'bë yaga tëmï gawo kyedre ne ko'do mï Beteniya. ");
INSERT INTO mgc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tabi ta'ba 'bɔmo hulëhu mï gawo kyedre ŋbɔ da mïndö vere aba, Yësu na o'bo. ");
INSERT INTO mgc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mo ongɔ kaga kyëlu dakapa gërï, ï'bë rɔ mo i'ja waako dë dɔ mo du yëyu mo. Mo iya zi kaga ne henye, “Ana lɔgɔ dekpe löhu.” Kandi kaga kyëlu ne akyïtru gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vo lö'bö 'bɔmo ongɔnnï kö'du ne iyannï henye, “Kaga kyëlu ne akyitru kandi ga a'di?” ");
INSERT INTO mgc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yësu ënyï aya'ba dɔ mo zi zë iya henye, “Mayada zi ye tïnyö, ëzë oma'e awïrï de 'e dë, atɔ'bɔ'e ko'dɔ wa mati mo'dɔ zi kaga kyëlu ne. Anza nje ma ne dë, atɔ'bɔ'e kpa zi kiya zi lutu nenye, ‘Ënyï rïyë u'du rë yï mï ranga, ako'dɔ rë nï.’ ");
INSERT INTO mgc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ëzë oma'e, aki'ja'e wa mati akɔ'jɔ'e kö'du mo tëmï mötu.” ");
INSERT INTO mgc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yësu ayi hulëhu mï yëkëlu, mo ayandi kö'du, kyedre 'ba vo karasa'e nnï vïdï kyedre ëtï ayinnï zi mo, ako'jonnï hɔ mo iyannï henye, “Ayada dero zi ze ëdï wa ne'e ko'dɔ kalakonda vala aba? Ëyï ra ï'dï kalakonda ne zi yï?” ");
INSERT INTO mgc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yësu aya'ba da me'do zi zë iya henye, “Ma kako'jo kö'du kölö ta he 'e, ëzë aya'ba'e dɔ mo ku zi ma makayada zi ye mëdï kö'du ne ko'dɔ kalakonda 'bëyï aba? ");
INSERT INTO mgc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kalakonda 'ba Yowani mati ëdï bapatisi kï'dï mo aba ne, ayi ta kila, kazi Wïrï kɔdɔ kazi vïdï?” Zë ayetonnï hë nnï wasa na ga rë nnï, iyannï henye, “Dakiya ze a'di?” Ëzë daya'ba'e dɔ mo diya'e kazi Wïrï, mo akiya zi ze henye, “Mora kö'du a'di oma'e dë mï Yowani?” ");
INSERT INTO mgc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ëzë diya'e henye, “Kazi vïdï, ze na tere, ga kö'du ze biya dasösu Yowani ra nëbï.” ");
INSERT INTO mgc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Here zë aya'bannï dɔ mo zi Yësu, iya henye, “Dayɔlɔ ze dë.” Mo aya'ba dɔ mo zi zë iya henye, “Mayada dë zi ye kalakonda 'ba a'di ra mëdï kö'du nenye'e ko'dɔ mo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Yaanya aba asösu'e kö'du a'di? Kadra maako aba kora ëdï gisi kora aba rïyö. Mo ënyï ï'bë zi ma kyedre ne iya zi mo henye, ‘Wisi ama ï'bë lɔɔ ko'dɔ mï yaka ndenye.’ Wisi aya'ba da me'do iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Momba dë tï'bë,’ yaa, mo asösu dë nï ënyï ï'bë gbɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“'Bu ënyï ï'bë zi wisi agamo onyɔ kpa kö'du kölö ne. Wisi ënyï aya'ba da me'do iya henye, ‘Ɔɔ, kyedre ma tï'bë,’ lɔɔ ne ko'dɔ mo, 'de ï'bë dë. ");
INSERT INTO mgc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wisi ma vala tëmï gisi rïyö ne'e, o'dɔ wa mati 'bu mo omba?” Zë aya'bannï da me'do iyannï henye, “Wisi ma kyedre.” Yësu iya zi zë henye, “Mayada zi ye, vo 'be'bele kö'du nnï, vo rönyï ëtï, ëdï tï'bënnï damöku 'ba Wïrï dagba komo'e. ");
INSERT INTO mgc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yowani Bapatisi ayi zi yada zi ye gërï ma laka zi ye kïrï, oma e dë mï mo. Vo 'be'bele kö'du vo rönyï ëtï ra omannï mï mo. Mati ongɔ'e mo gbï le, kpa otɔ de 'e dë zi koma mï mo.” ");
INSERT INTO mgc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yësu iya henye, “Owo'e mala vere ne, vo kyeti kaŋo maako ïyï lu'ju mï yaka, o'dɔ resi kpo ta rɔ mo, ole wogo 'ba a'ji koto, uvö loko tɔrɔ 'ba bi kongɔ. Mo ila yaka ne zi vo lɔɔ'e, ï'bë gbɔ bi yingɔ. ");
INSERT INTO mgc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mati kadra 'ba wa toto ta yaka ɔkɔ ku, mo utu vo kalima 'bënïye zi vo lɔɔ'e ga kö'du zi mï 'bënï mati inye ne koba.” ");
INSERT INTO mgc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Vo lɔɔ ne'e ïrï vo kalima ne'e, u'bönnï ma kölö, ofonnï agamo, u'dunnï vere ṛï'dï aba. ");
INSERT INTO mgc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kora vo kyeti yaka ne utu vo kalima löhu kyɔ ta da ma dagba, vo lɔɔ ko'dɔ ne'e o'dɔnnï zë kpa kaa ma dagba. ");
INSERT INTO mgc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ndundu mo aba mo utu wisi 'bënï zi zë. Mo iya henye, ‘Tïnyö zë akoronnï wisi 'bama.’” ");
INSERT INTO mgc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mati vo lɔɔ ne'e ongɔnnï wisi ne, iyannï henye, ‘Nenye wisi 'ba vo kyeti yaka ra. Ayi dofo'e mo, doba'e wa 'bɔmo.’ ");
INSERT INTO mgc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Zë ïrïnnï mo u'dunnï mo yaga tëmï yaka, ofonnï mo.” ");
INSERT INTO mgc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yësu ako'jo hë zë iya henye, “Yaanya aba ëzë vo kyeti yaka ne ayi, ako'dɔ a'di zi vo lɔɔ ne'e?” ");
INSERT INTO mgc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Zë aya'bannï da me'do iyannï henye, “Mo akofo kora 'ba kö'du kyënyë ko'dɔ ne'e, akï'dï yaka ne zi vo lɔɔ ko'dɔ maako'e, mati akï'dïnnï zi mo wa mï yaka mï kadra ma laka.” ");
INSERT INTO mgc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yësu iya zi zë henye, “Ako'jo'e kö'du mati kö'du yöru iya ne dë? ‘Yïtö mati vo wa ko'ba ombannï dë, ofɔ ku na yïtö ma laka ndra. Nenye Yere ra o'dɔ. Kongɔ mo atëdï na laka.’” ");
INSERT INTO mgc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yësu idra dɔ mo iya henye, “Mayada zi ye, damöku 'ba Wïrï akoba 'de kazi 'e, akï'dï zi vïdï mati akatanannï lɔgɔ ma laka. ");
INSERT INTO mgc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vïdï mati alëpï da yïtö nenye, akolowe. Ëzë yïtö ne alëpï da vïdï akanzekpe vïdï nani.” ");
INSERT INTO mgc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Here kyedre 'ba vo karasa nnï Farasi ëtï owonnï mala a Yësu ne, ayɔlɔnnï mo ëdï ame'do kö'du nnï, ");
INSERT INTO mgc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","zë ayɔnzɔnnï zi mo kïrï. Mora zë erennï vïdï kayo mati omannï mï Yësu mo nëbï ra. ");
INSERT INTO mgc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yësu ame'do löhu zi vïdï tëmï mala iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Damöku 'ba Wïrï ëdï henye. Yere maako akɔ'jɔ karama 'ba oze 'ba wisi ënï. ");
INSERT INTO mgc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mo utu vo lö'bö 'bënïye zi yada zi yingɔ mati omba zë ne zi tayinnï mï karama ne, zë ombannï dë zi tayi.” ");
INSERT INTO mgc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Mo utu kya vo lö'bö ne'e kö'du kise aba zi yingɔ ne'e, iya henye. ‘Karama ama ku nzɔ yaanya aba. Mofo isa ama ma kyedre, matɔnɔ aba ku nzɔ zi konyo mo. Ayiye mï karama 'ba oze.’ ");
INSERT INTO mgc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yingɔ mati ako'jo zë ne ombannï dë, ï'bënnï rï mï lɔɔ ënnï maako'e. Ma kölö maako ï'bënnï yaka ënï, ma vere ï'bënnï mï loko wakogo ënï. ");
INSERT INTO mgc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Agamo'e ïrïnnï vo lö'bö ne'e u'bönnï zë ofonnï zë. ");
INSERT INTO mgc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Vo damöku ënyï na kamo utu vo kanya 'bënïye ofonnï vo wa kofo ne'e, o'bɔ gawo kyedre 'bëzë ne ti'de.” ");
INSERT INTO mgc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Mo ako'jo vo lö'bö 'bënïye iya zi zë henye, ‘Karama oze ama ku nzɔ. Vïdï mati mako'jo zë ne anzannï dë na laka tayi. ");
INSERT INTO mgc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yaanya aba ï'bë'e da gëri ma kyedre akɔ'jɔ'e vïdï kayo mati i'ja'e zë mayinnï mï karama.’ ");
INSERT INTO mgc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vo kalima ënyï ï'bënnï yaga da gëri atotonnï vïdï mati zë i'jannï biya, ma laka makyënyë mo aba, loko 'ba oze oso kyɔ vïdï aba.” ");
INSERT INTO mgc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Yere ënyï ï'bë loko yingɔ ënïye kongɔ, mo i'ja kora maako usu bɔngɔ 'ba oze dë. Yere ako'jo hɔ mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Aboka ma ödu hala kinye kazi bɔngɔ 'ba oze?’ Kora ne 'de onyɔ kö'du ako dë. ");
INSERT INTO mgc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yere ayada zi vo lö'bö 'bënïye, iya henye, ‘Ida'e kala mo ndï mo aba u'du'e mo yaga mï bi köndu. Ani mo akudu hë nï konyo aba.’” ");
INSERT INTO mgc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yësu ï'dï dɔ mo iya henye, “Vïdï kayo ma ako'jo ne, ma jeli mo ayo dë.” ");
INSERT INTO mgc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farasi ënyï ï'bë o'dɔnnï yeṛe zi Yësu kuyï kö'du ko'jo aba. ");
INSERT INTO mgc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Zë ënyï utunnï kya 'ba vo lö'bö 'bënnï, kya 'ba vïdï 'ba Heroda ëtï. Zë iyannï zi mo henye, “Vo komoyandi dayɔlɔ ku ëdï kö'du tïnyö ra yada. Ëdï wa yandi tïnyö a Wïrï ra yandi zi vïdï. Kazi tere kö'du kiya 'ba vïdï kyedre maako'e dë. ");
INSERT INTO mgc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ayada zi ze, a'di ra asösu? Ëdï na laka zi ze 'be'bele kopi zi yere 'ba Roma, kɔdɔ anza here dë?” ");
INSERT INTO mgc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yësu ayɔlɔ yeṛe kyënyë 'bëzë ne, mo iya zi zë henye, “'E vo komokandi ne'e, kö'du a'di ëdïye ma kuyï kö'du yɔnzɔ aba? ");
INSERT INTO mgc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ayada'e zi ma kɔhi 'ba 'be'bele mati ëdï kopi.” Zë ikannï kɔhi ne zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mo ako'jo hë zë iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Komo ëyï ra ru mo aba nenye?” Aya'bannï da me'do iyannï henye, nenye komo Siza ra ru mo aba. Yësu iya zi zë henye, “Laka opi zi Siza wa 'ba Siza, opi zi Wïrï wa 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mati zë owonnï kö'du ne, zë na rakaga zë ilannï mo ënyï ï'bënnï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadeke'e ma omannï vïdï ënyï dekpe tëmï koli, zë ayannï zi Yësu iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Vo komoyandi, Mosa iya henye ere, kora mati oze mbara oli 'de kazi gisisi ko'jo, öndu mo moba mbara lu'bë ne, zi zë gisisi ko'jo mï ru 'ba kora mati oli ne. ");
INSERT INTO mgc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yaanya aba ne gisi öndu ëdïnnï madɔmorïyö kinye, wisi ma kyedre oze mbara oli 'de kazi gisisi ko'jo, mo ila mbara lu'bë ne zi öndu nï. ");
INSERT INTO mgc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kö'du ne o'dɔ rë nï kpa here zi öndu ma rïyö ma wota ndundu mo zi zë madɔmorïyö ne biya. ");
INSERT INTO mgc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndundu mo aba, mbara ne oli gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yaanya aba ne, mï ko'do mati yöku atënyïnnï na dïdï, mo atëdï mbara 'bëyï? Zë biya ozennï mo.” ");
INSERT INTO mgc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yësu aya'ba dɔ mo zi zë iya henye, “Alïtë'e ku, ga kö'du ayɔlɔ'e wayöru dë mandere kyigɔ a Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ëzë yöku ënyïnnï ku na dïdï, atëdïnnï kaa malayika'e komorïyë ozennï mbara dë. ");
INSERT INTO mgc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yaanya aba kaa kö'du tënyï 'ba yöku tëmï koli, ako'jo'e kö'du mati Wïrï ayada zi ye ne dë? Mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ma Wïrï 'ba Abarayama, Wïrï 'ba Yisika, Yakoba aba. Mo Wïrï 'ba dïdï anza 'ba yöku.” ");
INSERT INTO mgc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mati vïdï kayo ne'e owonnï kö'du ne, zë na rakaga tëmï gërï kö'du yandi 'bɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mati Farasiye owonnï Yësu ayata Sadeke'e, zë ayi atoto rë nnï bi kölö. ");
INSERT INTO mgc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma kölö tëmï zë vo komoyandi 'ba vo kö'du kï'dï, ako'jo ha Yësu tëmï kö'du yɔnzɔ iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vo komoyandi, kö'du kï'dï ma vala ra kyedre mï kö'du kï'dï?” ");
INSERT INTO mgc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yësu aya'ba dɔ mo iya henye, “'O'dɔ lɔvɔ Yere Wïrï 'bëyï di'di yï aba biya, lawo yï aba biya, kö'du yɔlɔ 'bëyï aba biya. ");
INSERT INTO mgc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nenye kö'du kï'dï ma dagba ma kyedre ndra 'ba kö'du kï'dï ra. ");
INSERT INTO mgc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kö'du kï'dï ma rïyö ma kyedre mo ëdï kaa mo. O'dɔ lɔvɔ vo haliŋɔ oka kaa mati o'dɔ lɔvɔ yï. ");
INSERT INTO mgc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kö'du kï'dï 'ba Mosa biya kö'du yandi 'ba nëbï ëtï ɔrɔ da kö'du kï'dï rïyö ne'e.” ");
INSERT INTO mgc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mati kya 'ba Farasi maako'e atoto rë nnï ga bi kölö, Yësu ako'jo hë zë iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“A'di ra asösu'e kö'du 'ba Korisitɔ? Mo tëmï kozo 'bëyï?” Zë aya'bannï dɔ mo iyannï henye, “Mo tëmï kozo a Dawidi.” ");
INSERT INTO mgc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yësu ako'jo hë zë iya henye, “Kö'du a'di ra Lawo Kölö Laka ï'dï Dawidi zi ko'jo mo na Yere? Mati Dawidi ëdï ame'do mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yere iya zi Yere 'bama, 'Alima kinye da tïrï ma le mï'dï vo wehe 'bëyïye ku mïdïrï ndï yï.'’ ");
INSERT INTO mgc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ëzë Dawidi ako'jo mo ‘Yere,’ hala Korisitɔ atëdï tëmï kozo 'ba Dawidi?” ");
INSERT INTO mgc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Vïdï maako aya'ba da kö'du ko'jo ne dë zi Yësu. Ta pëtï ko'do nani, vïdï maako ako'jo ha Yësu dekpe. ");
INSERT INTO mgc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yësu ame'do zi vïdï kayo ne'e, vo lö'bö 'bënï ëtï iya henye, ");
INSERT INTO mgc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vo komoyandi 'ba vo kö'du kï'dï nnï Farasi ëtï, ëdïnnï kyigɔ aba zi yëtï zi ye kö'du kï'dï 'ba Mosa. ");
INSERT INTO mgc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Owo'e kö'du mati zë iyannï zi ye zi ko'dɔ, kö'du ko'dɔ 'bëzë anza dë na laka zi ye gɔ mo kïrï. Zë ayadannï kö'du wa zi ye ko'dɔ mo, zë o'dɔnnï dë. ");
INSERT INTO mgc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Zë ï'dïnnï wa yeto ma kyedre mati vïdï ɔ'bɔ dë zi kïnjë mo ne da vïdïye. Zë ombannï dë zi kɔnyi zë zi kïnjë le nje da gisi kala nnï aba.” ");
INSERT INTO mgc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Zë o'dɔnnï wa mati vïdï zi kongɔ. Zë idannï kɔ'di piri konda ga bɔngɔ 'bënnï zi yada zë na laka. Zë ï'dïnnï bɔngɔ kanyi kölökpö gë nnï zi yada zë na vo mötu. ");
INSERT INTO mgc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Zë o'dɔnnï lɔvɔ bi ma laka ne, bi 'ba karama, bi lima mati na laka aba mï bi 'ba mötu. ");
INSERT INTO mgc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Zë o'dɔnnï lɔvɔ zi mëtënnï watɔwɔ aba mï bi 'ba wakogo. Zë o'dɔnnï lɔvɔ zi ko'jo vo komoyandi.” ");
INSERT INTO mgc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Akɔ'jɔ yï dë, ‘Vo komoyandi,’ ga kö'du 'e biya ta dakota kölö, vo komoyandi nje kölö. ");
INSERT INTO mgc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Akɔ'jɔ vïdï maako dë dakaŋo kinye na ‘'bu,’ ga kö'du ëdïye nje 'bu kölö aba komorïyë. ");
INSERT INTO mgc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ako'jo yï dë na ‘vo komoyandi,’ ga kö'du vo komoyandi kölö 'bëyï ra Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma kyedre kölö mï kutë'e mëdï na vo kalima. ");
INSERT INTO mgc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mo mati o'dɔ rë nï na kyedre, maya'ba rë nï hulëhu, mo mati o'dɔ rë nï hulëhu, ako'dɔ mo kyedre.” ");
INSERT INTO mgc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Hala atëdï na kyënyë zi ye, vo komoyandi 'ba vo kö'du kï'dï Farasi ëtï. 'E vïdï komokandi ne'e, isiye ha loko 'ba damöku 'ba Wïrï kazi vïdï ödunnï, kpa ödu'e dë. Ayata'e vïdï mati ëdï rë nnï kï'dï zi tödu ne kpa.” ");
INSERT INTO mgc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","15","“Atëdï na kyënyë zi ye vo komoyandi 'ba kö'du kï'dï Farasi ëtï. 'E vo komokandi ra. Umu'e kyëtï ranga kayo kpuru tëmï dakaŋo kutu kutu biya lasi aba, zi vïdï maako ki'ja zi gërï 'be'e ne kïrï. Ëzë i'ja'e vïdï ne ku, o'dɔ'e mo ndra na kyënyë tada'e, zi tï'bë mï gehena kaa 'e.” ");
INSERT INTO mgc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Riti atëdï na kyënyë zi ye, alaga'e dagba zi vïdï, mora 'e na vo komoköndu. Ayandiye iya 'e henye, ëzë vïdï maako alömu ru yëkëlu aba, mo anza dë na kida lömu 'bënï ne aba. Ëzë mo alömu ru dahabo mati mï yëkëlu ne aba, mo ku na kida. ");
INSERT INTO mgc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'E vo komoköndu lumë'e, vala ra na kyedre, dahabo kɔdɔ yëkëlu ra o'dɔ, dahabo na laka? ");
INSERT INTO mgc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ayandiye kpa iya'e henye, ‘Ëzë vïdï maako alömu ru karasa aba, mo anza dë na kida lömu 'bënï ne aba. Ëzë mo alömu rë nï ku wa ma ï'dï da karasa ne aba, mo ku na kida.’ ");
INSERT INTO mgc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'E vo komoköndu ne'e, ma vala ra na kyedre wakï'dï kɔdɔ karasa ra, o'dɔ wakï'dï na koho? ");
INSERT INTO mgc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ëzë vïdï maako alömu ru karasa aba, mo ëdï lömu kpa wa mati biya ï'dï dɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ëzë mo alömu ru yëkëlu aba, mo ëdï lömu mo aba, ehe Wïrï mati ëdï alima mï mo. ");
INSERT INTO mgc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ëzë vïdï maako alömu komorïyë aba, mo ëdï lömu kyïtï 'ba Wïrï mati mo alima dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Atëdï na riti zi ye vo komoyandi 'ba vo kö'du kï'dï nnï Farasi ëtï. 'E vo komokandi ne'e, ï'dïye zi Wïrï 'butë, wokonyo tisiwa kaa kököwu. Mora o'dɔ'e wa ma laka ndra 'ba ködu kï'dï dë, kaa tïnyö, mïkyëyï, koma aba. ");
INSERT INTO mgc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","O'dɔ re 'e na vo dagba zi vïdï, mora 'e na vo komoköndu, oba'e kɔŋɔ tisi yaga tëmï wa kuwë 'be'e, ondrɔ'e jemele.” ");
INSERT INTO mgc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Atëdï na riti zi ye vo komoyandi 'ba vo kö'du kï'dï Farasi ëtï. 'E vo komokandi ne'e, akaka'e ra sikɔ 'be'e gbenje aba ta rɔ mo yaga, mï zë ndɔ na wakoyi mï kumbë aba. ");
INSERT INTO mgc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farasi vo komoköndu, akyitɔ wa mati ëdï mï sikɔ dagba, ma ta yaga akakyitɔ kpa 'da.” ");
INSERT INTO mgc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Atëdï na riti zi ye vo komoyandi 'ba vo kö'du kï'dï Farasi ëtï. 'E vo komokandi ne'e, 'e kaa da wogo mati akɔ'jɔ rë zë na kanyi, lunzu ṛï'dï kanyi aba, ongɔ na laka tarë zë yaga, mï zë ndɔ na yingɔ keŋe yöku aba. ");
INSERT INTO mgc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tëmï gërï kölö ne, ta ra'e yaga na laka zi vïdï biya, mï ye ndɔ na komokandi kö'du lïtë aba.” ");
INSERT INTO mgc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Atëdï na riti zi ye vo komoyandi 'ba vo kö'du kï'dï Farasi ëtï. 'E vo komokandi ne'e, o'ba'e ogo na laka zi nëbïye, ayada'e tɔwɔ zi wogo zi vïdï mati alimannï kyere na lima ma laka. ");
INSERT INTO mgc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iya'e henye, ëzë ëdïye kyere mï kadra 'ba 'bu'e vu'e nani, o'dɔ'e kö'du mati zë o'dɔnnï nëbï ne'e, kofo mo gɔ mo ne dë. ");
INSERT INTO mgc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Omba'e dɔ mo tïnyö, 'e ra na kozo 'ba vïdï ma ofonnï nëbï ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ï'bë'e zɔ dagba wa mati 'bu'e vu'e ayetonnï ne kinde mo.” ");
INSERT INTO mgc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“'E wiri ne'e, 'e gisi 'ba wiri ne'e, hala asösu'e zi taho. Kazi vurë re 'e, atï'bë'e biya mï gehena. ");
INSERT INTO mgc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mayada zi ye makutu nëbï ne'e, kora vo kö'du yɔlɔ, vo komoyandi ëtï, akofo'e kyamo'e, akatötö'e agamo'e akakpökyïye agamo'e mï bi 'ba mötu'e, akore'e zë tëmï gawo ta da gawo. ");
INSERT INTO mgc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Riti biya kö'du vïdï mbiya mati ofo'e ne akalëpï de 'e tëmï kozo 'ba Abele zi kozo 'ba Zakariya wisi 'ba Berahiya mati ofo'e mï kutë yëkëlu karasa aba. ");
INSERT INTO mgc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mayada zi ye tïnyö, riti biya 'ba wakofo ne akalëpï da vïdï 'ba ko'do nenye.” ");
INSERT INTO mgc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalema, Yerusalema ofo'e nëbïye, u'du'e vo lö'bö mati Wïrï utu zi ye ne ṛï'dï aba. Da ndö momba zi kala ma kï'dï mo kpo ra vïdï 'be'e biya, kaa ma yëru mati atoto gisisi ënï hu förö nï, ila'e ma dë. ");
INSERT INTO mgc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Loko 'be'e ne akila na mï mbiya. ");
INSERT INTO mgc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tëmï ndenye dagba ani, mayada zi ye henye, ongɔ'e ma dekpe löhu le akiya'e henye, ‘Wïrï ï'dï ya'da zi mo mati ayi mï ru 'ba Yere.’” ");
INSERT INTO mgc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yësu ënyï ila bi nani ëdï gbɔ atï'bë 'de tëmï yëkëlu, vo lö'bö 'bɔmo ayinnï zi yada zi mo kuvö 'ba loko 'ba Wïrï ne. Mo ënyï alëzë. ");
INSERT INTO mgc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Ɔɔ. Ongɔ'e bi biya na laka da wa nenye'e. Mayada zi ye henye, yïtö ma kölö kinye alima dë ga bi 'bënï zë biya aku'du akaŋo.” ");
INSERT INTO mgc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mati Yësu alima da Döku 'ba Olivo, vo lö'bö ayinnï na liwo zi mo, ako'jonnï hɔ mo iyannï henye, “Ayada zi ze kö'du biya nenye atëdï ndala aba, a'di ra ako'dɔ rë nï zi yada mo henye, ‘Ku tayi 'bëyï ndundu 'ba daliŋɔ aba.’” ");
INSERT INTO mgc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yësu aya'ba dɔ mo iya henye, “Ëdïye komo kï'dï aba, ila'e vïdï maako mo'ba 'e dë. ");
INSERT INTO mgc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Vïdï kayo atayinnï me'do ru ma aba ako'bannï vïdï kayo akiyannï henye, ‘Ma, Korisitɔ ra.’ ");
INSERT INTO mgc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Akowo'e kpɔrɔ wehe kara dakapa, kö'du yöyö 'ba wehe aba na kɔwɔ, ere'e dë. Wa ne ako'dɔ rë nï, anza dë zi kiya henye, ndundu mo ɔkɔ ku. ");
INSERT INTO mgc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dakaŋo ako'dɔ wehe oka maako aba, damöku akalëpï wehe aba da ma kölö maako. Zöyï atëdï, kinzikinzi atëdï ta ga bi ne biya. ");
INSERT INTO mgc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wa ne atëdïnnï biya kaa dagba tɔɔ 'ba wisi ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Akïrïye, akï'dïye zi ko'dɔ mo na kyënyë zi kofo. Vïdï biya akoyi 'e ga kö'du ma. ");
INSERT INTO mgc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mï kadra nani, vo kö'du komba'e akalëpïnnï tëmï kö'du koma 'bënnï, zë akasusunnï oka maako, akoyinnï oka maako. ");
INSERT INTO mgc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nëbï vo ndɔndɔ kayo'e akalayannï vïdï kayo ko'ba aba. ");
INSERT INTO mgc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne atëdï rapere 'ba kö'du kyënyë ko'dɔ, zi vïdï kayo lɔvɔ 'bëzë ofɔ. ");
INSERT INTO mgc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vïdï mati ɔrɔ nduwë na kyigɔ mï ndundu mo, akayɔmɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kö'du yöyö laka nenye ga kö'du 'ba damöku akayëtï zi vïdï 'ba dakaŋo ne biya kaa vo hu kö'du dɔrɔ, ndundu mo atɔkɔ 'da.” ");
INSERT INTO mgc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mati ongɔ 'e wa kyënyë ma ndra mï loko 'ba Wïrï ma ayaŋa, ma nëbï Daniyele ame'do kö'du mo. Atɔrɔ bi ma laka. Kö'du nenye zi vo ko'jo mo: ayɔlɔ laka mï kö'du nenye a'di. ");
INSERT INTO mgc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Vïdï mati ëdïnnï mï Yudiya atahonnï da lutu. ");
INSERT INTO mgc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Vïdï maako mati ëdï da loko ënï, i'ja kadra dekpe zi tasi akaŋo zi wasisi 'bënï koba ta loko. ");
INSERT INTO mgc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Vïdï maako mati ëdï mï yaka a'ba dekpe hulëhu zi bɔngɔ ënï koba. ");
INSERT INTO mgc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Atëdï na kyënyë mï ko'do naniye zi mbara mati ɔmɔnnï 'e mbara mati ëdïnnï gisiluru aba: ");
INSERT INTO mgc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Amötu'e zi Wïrï kazi aho'e tëmï tona mandere mï ko'do kadra 'ba ralawo. ");
INSERT INTO mgc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ga kö'du riti mï kadra nani atëdï na kɔwɔ ndra ta da riti, mati ëdï tëmï biyeto 'ba damöku tëmï ko'do ma ndenye ne. Ani, wa maako atanza dekpe kaa mo löhu. ");
INSERT INTO mgc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wïrï aya'ba ra watiti 'ba ko'do naniye, mo mo'dɔ dë here, vïdï maako ɔmɔ dë. Ga kö'du vïdï jeli 'bënïye Wïrï akaya'ba mï kadra ko'do nani 'e 'da.” ");
INSERT INTO mgc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ëzë vïdï maako iya zi yï henye, ‘Ongɔ te, Korisitɔ ëdï kinye, mandere mo ëdï nani,’ oma dë mï kö'du ne. ");
INSERT INTO mgc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ga kö'du Korisitɔ vo ndɔndɔ 'e nnï nëbï vo ndɔndɔ ëtï akalayannï, zë ako'dɔnnï kö'du ko'do kyedre rakaga aba zi vïdï jeli a Wïrï ko'ba ëzë zë atɔ'bɔnnï. ");
INSERT INTO mgc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Owo'e te, mayada kö'du nenye zi ye gba kazi kadra mo tɔkɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ëzë vïdï maako ayada zi ye iya henye, ongɔ'e te, mo ëdï yaga mï da lïpï, ï'bë'e dë ani, mandere ëzë zë iyannï henye, ongɔ'e te, mo ëdï rë nï koho kinye oma'e dë mï kö'du ne. ");
INSERT INTO mgc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ga kö'du Wisi a Vïdï atayi kaa bikanyi mati alaka komorïyë ta humïrë le da mïrë. ");
INSERT INTO mgc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ëzë yöku ëdï, langa akatoto rë nnï.” ");
INSERT INTO mgc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kandi ta pëtï riti 'ba ko'do naniye, kadra akuyï rë nï na mandölu, yehwe anyi dekpe, kyëlu akalëpïnnï ta komorïyë, wa ma komorïyë akakɔhɔ rë nnï. ");
INSERT INTO mgc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kyïnë wa mati akayada kö'du 'ba Wisi a Vïdï akalaya komorïyë, vïdï biya 'ba dakaŋo akudunnï ëzë ongɔnnï Wisi a Vïdï ëdï atayi tëmï fɔli 'ba komorïyë kyigɔ bikanyi kyedre 'bënï aba. ");
INSERT INTO mgc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kyedre torombeta akata'a, mo akutu malayika 'bënïye yaga mï bi gɔlɔ'bɔ sowɔ 'ba dakaŋo. Zë akatotonnï vïdï jeli ɔmo'e tëmï ndundu 'ba dakaŋo ne biya.” ");
INSERT INTO mgc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kaga kyëlu ma yandi kö'du yɔlɔ zi ye. Ëzë ngora mo ïnzï ku, akofɔ rë nï na luwë, mbili yëyu makyïyï akayeto gbɔ tövu, akayɔlɔ'e umu ku kara. ");
INSERT INTO mgc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tëmï gërï kölö ne, ëzë ongɔ'e wa ne ku biya, akayɔlɔ'e kadra mo ku kara nzɔ zi rë nï yeto. ");
INSERT INTO mgc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mayada tïnyö zi ye, wa ne biya ako'dɔ rë nï dagba, kazi vïdï ma ëdïnnï lima yaanya aba ne, oli dë gba biya. ");
INSERT INTO mgc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Komorïyë dakaŋo aba akalagannï, me'do 'bama alaga dë.” ");
INSERT INTO mgc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Vïdï maako ayɔlɔ ko'do mo kadra aba dë. Kpa le malayika komorïyë mandere Wisi ayɔlɔnnï dë, nje 'bu ra akayɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tayi 'ba Wisi a Vïdï ako'dɔ rë nï kaa mï kadra 'ba Nowa. ");
INSERT INTO mgc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mï ko'do gba ta komo wini koso, vïdï ëdïnnï wakonyo, wa kuwë, vïdï kora rë nnï koze mbara ëtï, le mï ko'do mati Nowa ï'bë ödu mï töŋbö, ");
INSERT INTO mgc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ayɔlɔnnï kö'du mati ëdï rë nï ko'dɔ ne dë, le wini koso ayi akyitɔ zë biya. Ëzë Wisi a Vïdï ayi akatëdï here. ");
INSERT INTO mgc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mï kadra nani vïdï kora rïyö atëdïnnï lɔɔ ko'dɔ mï yaka. Ma kölö akoba, agamo akila hulëhu. ");
INSERT INTO mgc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vïdï mbara rïyö atëdïnnï bi 'ba wakuhu, ma kölö akoba, agamo akila hulëhu.” ");
INSERT INTO mgc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ëdïye komo kï'dï aba ga kö'du ayɔlɔ'e dë, mï ko'do vala ra Yere 'be'e atayi. ");
INSERT INTO mgc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ëzë vo kyeti liŋɔ ayɔlɔ kadra mati vo logo atayi, tïnyö akayɔlɔ'e henye, mo akalima na ngö ila vo logo dë zi tödu mï loko ënï. ");
INSERT INTO mgc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Here ëdï 'e kpa 'duwï nzɔ, ga kö'du Wisi a Vïdï atayi mï kadra mati anza'e dë komo kï'dï aba gɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ëyï ra vo lö'bö laka, kö'du yɔlɔ aba? Mo ra mati kyedre 'bɔmo ï'dï mo na ga vo lö'bö oka nïye kongɔ wakonyo 'bëzë kï'dï mï kadra ma laka. ");
INSERT INTO mgc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rakyenyi atëdï zi vo lö'bö ne hala, ëzë kyedre 'bɔmo i'ja mo lɔɔ ne ko'dɔ, ëzë mo a'ba liŋɔ. ");
INSERT INTO mgc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mayada tïnyö zi ye, kyedre ne akï'dï vo lö'bö na vo da wasisi ënï biya. ");
INSERT INTO mgc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ëzë mo na vo lö'bö ma kyënyë, mo akayada na bi dënï henye, ‘Kyedre 'bënï ne ayi dekpe hulëhu kandi,’ ");
INSERT INTO mgc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mo akayeto vo lö'bö okanïye ku'bö zi wakonyo wa kuwë aba na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kyedre 'ba vo lö'bö ne atayi ko'do maako aba, mati vo lö'bö ne anza dë komo kï'dï aba gɔ mo, mï kadra mati mo ayɔlɔ dë. ");
INSERT INTO mgc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kyedre akasese mo kozokozo 'ba vo komokandi ne zë ëtï, ani mo akudu hë nï konyo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Mï kadra nani, damöku 'ba Wïrï atëdï henye. Mïnzö ngulu 'butë oba lamba ënnï ënyï ï'bënnï yaga da 'bïyësï kutrë. ");
INSERT INTO mgc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Muyï tëmï zë na vo lumë, agamo'e muyï na vo kö'du yɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma vo lumë ne oba lamba 'bënnï obannï kya 'ba yënï wa'do dë nnï aba. ");
INSERT INTO mgc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma vo kö'du yɔlɔ ne'e, obannï maṛanjiye ndɔ yënï aba mï mo. ");
INSERT INTO mgc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Bïyësï alïkö dënï tisi ta bi tayi, mïnzö ne'e, ayetonnï nano o'donnï gbɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ëdï mï kutë yɔndɔ kudu aa yaga iya henye, ‘'Bïyësï ëdï kinye, ayiye dɔ mo kutrë.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mïnzö 'butë ne ënyï alironnï, akɔ'jɔ lamba ënnï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mïnzö ma lumë ne iyannï zi ma vo kö'du yɔlɔ ne'e henye, ‘Ï'dïye kya 'ba yënï 'be'e, tisi zi ze, ga kö'du 'beze inde rë nï ku.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vo kö'du yɔlɔ ne aya'bannï dɔ mo iyannï henye, ‘'E'e, anza dë kyɔ ga kö'du 'e ehe ze, ï'bë'e bi 'ba wakogo kyamo kogo ga kö'du'e.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mïnzö ma lumë ne ënyï ï'bënnï gbɔ kya 'ba yënï kogo. Mati ëdïnnï tï'bë, 'bïyësï ɔkɔ gbɔ ta gë zë. Zë mati nzɔ muyï ne ënyï ï'bënnï mo aba mï karama 'ba oze isinnï ha loko gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yaa, mïnzö agamo ne ɔkɔnnï, ënyïnnï kudu iyannï henye, ‘Kyedre, kyedre, ayëhu ha loko zi ze tödu.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Bïyësï aya'ba dɔ mo iya henye, ‘'E'e, mayɔlɔ 'e dë.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yësu ï'dï dɔ mo iya henye, “Ëdïye komo kï'dï aba ga kö'du ayɔlɔ'e ko'do mo kadra mo aba dë.” ");
INSERT INTO mgc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mï kadra nani aba, damöku 'ba Wïrï atëdï henye. Kora maako ëdï omba ku zi tï'bë bi yingɔ, mo ako'jo vo kalima 'bënï ne'e ise ga wasisi 'bënï zi zë zi tëdïnnï na vo gɔ mo kongɔ. ");
INSERT INTO mgc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mo ï'dï zi ma kölö wa mati mo akatɔ'bɔ ko'dɔ mo. Zi ma kölö, mo ï'dï kɔhi dahabo ŋbiriṛi kpulukumuyï. Zi agamo, mo ï'dï kpulukurïyö, zi ma wota mo kpulukukölö, ënyï ï'bë gbɔ bi yingɔ. ");
INSERT INTO mgc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Vo kalima mati oba 'bënï kɔhi ŋbiriṛi kpulukumuyï ne kandi ï'bë o'dɔ lɔɔ mo aba, i'ja dɔ mo kpa kpulukumuyï. ");
INSERT INTO mgc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tëmï gërï kölö ne vo kalima mati oba kpulukurïyö ne, i'ja dɔ mo kpa kpulukurïyö. ");
INSERT INTO mgc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Vo kalima mati ïrï 'bënï kpulukukölö ne, ï'bë ole wogo mï kaŋo oho kɔhi 'ba kyedre 'bënï ne gbɔ mï mo.” ");
INSERT INTO mgc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Gɔ mo ëhï na konda, kyedre 'ba vo kalima ne'e ayi hulëhu alimannï ga kɔhi ne kiti mo zë ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Vo kalima mati ïrï kɔhi 'bënï kpulukumuyï ne, ödu ï'dï kpulukumuyï agamo. Mo iya henye, ‘Ï'dï zi ma kɔhi ŋbiriṛi kpulukumuyï, kyedre, ongɔ te, nenye aga kpulukumuyï vere mati mi'ja.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kyedre 'bɔmo iya zi mo henye, ‘O'dɔ ku laka, yï vo kalima 'ba kö'du koma laka ra. Ëdï mï koma aba zi kɔhi tisi ne ki'ja mo here, ma kï'dï yï na vo da kɔhi ma kyedre. Ayi loko ta, dayanyi mï rakyenyi ne yï aba.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Vo kalima mati ï'dï 'bɔmo kpulukurïyö ne ayi loko iya henye, ‘Ï'dï zi ma kɔhi kpulukurïyö, kyedre ongɔ te, kinye kya 'ba kpulukurïyö agamo mati mi'ja.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kyedre 'bɔmo iya zi mo henye, ‘O'dɔ ku laka yï vo kalima 'ba kö'du koma laka ra. Ëdï mï koma aba zi kɔhi tisi ne ki'ja mo here, makï'dï yï na vo da kɔhi ma kyedre. Ayi loko ta, dayanyi mï rakyenyi ne yï aba.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Vo kalima mati ïrï 'bënï kpulukukölö ne, ayi ödu loko iya henye, ‘Kyedre, mayɔlɔ yï kora vo kala kyigɔ ra, ëdï wakumu kpa ïyï dë, ëdï wa 'ba yaka toto kpa kazi kofo kïlï. ");
INSERT INTO mgc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ma na tere, mï'bë moho kɔhi 'bëyï ne mï kaŋo ongɔ te, kinye wë yï ëdï.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kyedre 'bɔmo iya zi mo henye, ‘Yï vo kalima vo wëdï kyënyë. Ayɔlɔ dë mëdï wakumu kpa mïyï dë, wa toto ta yaka kazi kofo kïlï? ");
INSERT INTO mgc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Laka, ï'dï kɔhi ama ne kyere mï loko 'ba kɔhi sesi, ma koba biya hulëhu dɔ mo mati i'ja ne aba ëzë ma'ba ku liŋɔ.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Yaanya aba oba'e kɔhi ne 'de kazi mo ï'dïye zi ma kpuluku'butë aba ne. ");
INSERT INTO mgc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ga kö'du vïdï biya mati ëdï wa aba, le kyɔ akï'dï, mo atëdï mo aba kyɔ. Ta da mati mo ëdï mo aba. Vïdï mati anza wa aba dë, gbï le nje ma tisi mati mo ëdï mo aba, akoba 'de kazi mo. ");
INSERT INTO mgc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Vo kalima lumë ne, u'du'e mo yaga mï bi köndu ani mo akudu hë nï konyo aba.” ");
INSERT INTO mgc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mati Wisi a Vïdï ayi mï bikanyi kyedre malayika ëtï, mo akalima da kyïtï, ");
INSERT INTO mgc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","vïdï 'ba damöku ne akatoto biya komo mo. Mo akinye mï zë mï gboko rïyö, kaa vo tïmëlë yako inye tïmëlë tara wanya here. ");
INSERT INTO mgc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mo akï'dï vïdï ma laka 'e da kala nï ma tïrï, ma kyënyë'e da kala nï ma gali.” ");
INSERT INTO mgc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Yere akiya zi vïdï ma da kala nï ma tïrï ne henye, ‘'Ayiye, 'e mati 'bu ma ï'dï ya'da ku zi ye ne. Ayiye mï damöku mati akɔ'jɔ ku kyere zi ye, ko'dɔ 'ba dakaŋo aba. ");
INSERT INTO mgc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ma na o'bo, ï'dïye wakonyo zi ma. Ma na kɔdrɔ, ï'dïye wini zi ma kuwë. Ma na vo leze, oba'e ma liŋɔ 'be'e. ");
INSERT INTO mgc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma na ga mbiṛö usu'e bɔngɔ ra ma. Ma na rakɔɔ, ongɔ'e ga ma. Ma mï kamba, ëdïye tï'bë ma kongɔ.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Vïdï ma laka ne akaya'bannï dɔ mo zi mo, akiyannï henye, ‘Ndala aba ya Yere, dongɔ yï na o'bo, dïdï wakonyo zi yï, mandere kɔdrɔ aba, dïdï wini zi yï kuwë? ");
INSERT INTO mgc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndala aba di'ja yï na tu'dë maako dïrï ze yï liŋɔ 'beze, mandere na ga mbiṛö dusu bɔngɔ rë yï? ");
INSERT INTO mgc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndala aba dongɔ yï na rakɔɔ mandere mï kamba dëdï tï'bë yï kongɔ?’ ");
INSERT INTO mgc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yere akaya'ba zi zë akiya henye, ‘Mayada zi ye, ëzë o'dɔ'e kö'du ne gbï le nje zi vïdï ma tisi kaa ma nenye'e ne, o'dɔ'e ku zi ma.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mo akiya zi zë ma da galinï ne, ‘Ï'bë'e 'de tara ma karani 'e mati mï wa sënë a Wïrï. Ï'bë'e 'de mï wa'do ma kazi ndundu, mati akɔ'jɔ ku zi Satani malayika 'bënï ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ma na o'bo ï'dïye wakonyo dë zi ma. Ma na kɔdrɔ ï'dïye wini dë zi ma kuwë. ");
INSERT INTO mgc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma na vo leze, ïrïye ma dë kala aba mï liŋɔ 'be'e. Ma na ga mbiṛö usu'e bɔngɔ dë ra ma. Ma na rakɔɔ mï kamba ongɔ'e ga ma dë.’” ");
INSERT INTO mgc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Akaya'bannï dɔ mo zi mo, akiyannï henye, ‘Ndala aba ya Yere, dongɔ yï na o'bo, na kɔdrɔ, na vo leze, na ga mbiṛö, na rakɔɔ, mï kamba, dakɔnyi yï dë?’ ");
INSERT INTO mgc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yere akaya'ba dɔ mo akiya henye, ‘Mayada zi ye, ëzë omba'e dë zi kɔnyi gbï le nje vïdï ma tisi nenye'e ne, omba'e dë ne ma ra kɔnyi.’ ");
INSERT INTO mgc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Vïdï kyënyë ne'e atï'bënnï mï wa'do ma ŋburu ŋburu riti aba, vïdï ma laka akatï'bë 'bënnï mï dïdï ma ŋburu ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mati Yësu inde kö'du ne'e yandi mo ku biya, mo iya zi vo lö'bö 'bënïye henye, ");
INSERT INTO mgc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mï ko'do rïyö aba kaa ayɔlɔ'e atëdï karama 'ba laga 'ba koli, Wisi a Vïdï akï'dï zi tötö mo.” ");
INSERT INTO mgc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kyedre 'ba vo karasa nnï vïdï kyedre'e ëtï atoto rë nnï mï loko kyedre 'ba Kayafa vo da vo da karasa'e. ");
INSERT INTO mgc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","O'dɔnnï yeṛe zi Yësu kïrï zi kofo mo na liwo. ");
INSERT INTO mgc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Zë iyannï henye, “Do'dɔ'e dë mï kadra karama. Kazi vïdï ënyïnnï na wehe.” ");
INSERT INTO mgc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mati Yësu ëdï mï Beteniya liŋɔ 'ba Simona, kora mati na riti kɔɔ mönyu aba ne. ");
INSERT INTO mgc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mati Yësu ëdï wakonyo, vïdï mbara ayi zi mo yënï ogo kɔhi kyedre aba, mo ope gbɔ dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mati vo lö'bö 'bɔmo ongɔnnï kö'du ne here, ënyïnnï na kamo. Zë ako'jonnï kö'du iyannï henye, “Kö'du a'di ayaŋa wa ne biya here gɔ mo? ");
INSERT INTO mgc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yënï këzï ngutru nenye akogo yaga kɔhi kyedre aba, kï'dï zi vo leriye.” ");
INSERT INTO mgc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yësu ayɔlɔ kö'du mati zë ëdïnnï kiya ne, iya zi zë henye, “Kö'du a'di ëdïye sawiya ko'dɔ zi mbara ne? Kö'du teme laka ra mo o'dɔ zi ma. ");
INSERT INTO mgc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Atëdïye 'duwï vo lere ëtï mï kutë'e, anza'e dë 'duwï ma aba. ");
INSERT INTO mgc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kö'du mati mo o'dɔ zi yënï këzï ngutru nenye kope ra ma, zi kɔ'jɔ ma nzɔ zi kusu. ");
INSERT INTO mgc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yaanya aba mayada zi ye, bi ma yöyo laka nenye ayëtï zi mo mï dakaŋo ne biya, wa mati mo o'dɔ ne atëdï na kö'du sösu ga kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma kölö tëmï vo lö'bö 'butë dɔmorïyö ne ru mo Yudasi Sikereto ï'bë zi vo da karasa'e ");
INSERT INTO mgc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ako'jo hɔ mo iya henye, “Akï'dïye a'di zi ma, ëzë masusu Yësu zi ye?” Zë itinnï kɔhi ŋbiriṛi 'butëwota ï'dïnnï gbɔ zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta gɔ mo Yudasi ëdï gërï ma laka koma zi Yësu kï'dï zi zë. ");
INSERT INTO mgc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mï dagba ko'do 'ba karama 'ba laga 'ba koli, vo lö'bö ayinnï zi Yësu ako'jonnï hɔ mo iyannï henye, “Kila omba ze zi wakonyo 'ba karama 'ba laga 'ba koli ne, kɔ'jɔ mo nzɔ zi bi yï?” ");
INSERT INTO mgc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mo iya zi zë henye, “Ï'bë'e zi kora maako ayada'e zi mo henye, ‘Vo komoyandi iya henye, kadra ama ɔkɔ ku, ma vo lö'bö 'bama ëtï dako'dɔ karama 'ba laga 'ba koli liŋɔ 'bëyï.’” ");
INSERT INTO mgc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vo lö'bö o'dɔnnï kaa mati Yësu ayada zi zë, akɔ'jɔnnï wakonyo 'ba laga 'ba koli gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kɔsi kadra aba, Yësu vo lö'bö 'butë dɔmorïyö ne ëtï, alimannï gbɔ akaŋo wakonyo. ");
INSERT INTO mgc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mati ëdïnnï wakonyo, Yësu iya zi zë “Mayada zi ye, vïdï ma kölö tëmï 'e akasusu ma.” ");
INSERT INTO mgc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vo lïtu'e na rasösu ayetonnï hɔ mo ko'jo ma kölö ta ga oka nï, “Tïnyö, Yere, iya dë ma ra?” ");
INSERT INTO mgc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yësu ënyï aya'ba dɔ mo zi zë iya henye, “Ma kölö mati usu kala nï ma aba mï gbenje ne akasusu ma. ");
INSERT INTO mgc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wisi a Vïdï akoli kaa mati kö'du yöru iya mo akoli, atëdï na riti zi vïdï mati asusu Wisi a Vïdï zi kofo ne. Atëdï na laka zi vïdï ne lima kazi ko'jo mo.” ");
INSERT INTO mgc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi vo susu ënyï ame'do rïyë iya henye, “Tïnyö vo komoyandi ayɔlɔ anza dë ma ra?” Yësu aya'ba dɔ mo iya henye, “Kaa mati iya ne.” ");
INSERT INTO mgc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mati zë ëdïnnï wakonyo, Yësu oba nzoyi mangɔlɔ'bɔ o'dɔ mötu 'ba öwö'dï, owe mï mo ï'dï zi vo lö'bö 'bënïye. Mo iya zi zë henye, “Oba onyo'e, nenye ida ra ma ra.” ");
INSERT INTO mgc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mo oba köfö o'dɔ öwö'dï zi Wïrï, ï'dï zi zë, iya henye, “Uwë'e, 'e biya ta ge'e. ");
INSERT INTO mgc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nenye yama ma mati na da kö'du kï'dï a Wïrï, yama mati alikɔ yaga ko'du vïdï kayo kila tëmï kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mayada zi ye makuwë a'ji nenye dekpe löhu le mï damöku a 'Bu ma.” ");
INSERT INTO mgc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aya'binnï ngala ënyï ï'bënnï gbɔ da Döku 'ba Olivo. ");
INSERT INTO mgc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yësu iya zi zë henye, “Yɔndɔ nenye aba ataho'e biya akila'e ma kaa mati kö'du yöru iya henye, ‘Wïrï akofo vo tïmëlë yako, tïmëlë ne akapere rë nnï.’ ");
INSERT INTO mgc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ta pëtï tënyï 'bama tëmï koli, makatï'bë dagba komo'e mï Galilaya.” ");
INSERT INTO mgc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero ënyï ame'do rïyë iya zi Yësu henye, “Mila yï dë, ëzë ma kayo ne'e, ilannï yï le.” ");
INSERT INTO mgc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yësu iya zi Petero henye, “Mayada zi yï gba kazi zanga ayapa mï yɔndɔ ne akiga hë yï, akiya da wota henye ere, ayɔlɔ ma dë.” ");
INSERT INTO mgc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petero ënyï aya'ba dɔ mo iya henye, “Ëzë le zi ma koli kö'du yï, mila yï dë.” Vo lö'bö agamo'e iyannï kpa kö'du kölö ne. ");
INSERT INTO mgc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yësu ënyï ï'bënnï vo lö'bö 'bënï ëtï mï bi mati ako'jo Getesemina, mo iya zi zë henye, “Alima'e kinye mëdï dero tï'bë dagba amötu.” ");
INSERT INTO mgc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mo oba nï aba Petero, gisi 'ba Zebedeyo rïyö. Yësu kö'du sösu riti aba, ");
INSERT INTO mgc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","mo iya zi zë henye, “Kö'du sösu mï di'di ma ne ku na kyedre, omba ku kara zi ma kofo. Alima'e kinye bi kida ma aba.” ");
INSERT INTO mgc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mo ënyï ï'bë tisi dagba kɔwɔ, umë rë nï na komokomo akaŋo amötu iya henye, “'Bu ma, ëzë atɔ'bɔ oba riti ne 'de ta da ma. Anza kö'du komba 'bama, kö'du komba 'beyï ra.” ");
INSERT INTO mgc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mo ënyï a'ba zi vo lö'bö wota ne'e, i'ja zë ako'do, mo iya zi Petero henye, “Hala 'e wota ne ɔ'bɔ'e dë zi bi kida ma aba gbï le nje kadra kölö?” ");
INSERT INTO mgc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Alima'e nzɔ bi kida mötu aba, kazi alëpïye mï kö'du yɔnzɔ. Di'di ra omba, ida ra kazi kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yësu ënyï ï'bë kpa löhu mï da rïyö a mötu, iya henye, “'Bu ma, ëzë köfö 'ba riti nenye oba dë, ma ki'ja riti mï da kö'du komba 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mo a'ba i'ja vo lö'bö ne'e, kpa löhu ako'do, zë ɔ'bɔnnï dë zi lima na ngö. ");
INSERT INTO mgc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yësu ënyï ila zë löhu ï'bë 'de amötu ma da wota mo iya kpa kö'du kölö ne. ");
INSERT INTO mgc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mo a'ba zi vo lö'bö'e iya henye, “Ëdïye gba a ko'do re 'e alawo? Ongɔ'e te, kadra 'ba zi Wisi a Vïdï kï'dï, zi vïdï kyënyë'e ɔkɔ ku. ");
INSERT INTO mgc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ënyï dï'bë'e. Ongɔ'e te, kora mati asusu ma ne ëdï nenye.” ");
INSERT INTO mgc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mati Yësu ëdï gba ame'do, Yudasi mo kölö tëmï vo lö'bö 'butë dɔmorïyö ne'e, ɔkɔ gbɔ. Mo aba vïdï kayo ëdïnnï kulu, mɔvɔ aba kala nnï, kyedre 'ba vo karasa vïdï kyedre ëtï ra utunnï zë. ");
INSERT INTO mgc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudasi o'dɔ dakyïnë kö'du maako zi vïdï kayo ne'e zi yɔlɔ, iya henye, “Kora mati munzu hɔ mo ne, mo ra omba'e, ïrïye mo.” ");
INSERT INTO mgc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudasi ï'bë mbïyï zi Yësu, iya henye, “Rakyëyï mëdï yï aba vo komoyandi,” unzu hɔ mo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yësu aya'ba dɔ mo iya henye, “Aboka ma, o'dɔ kö'du mati ayi gɔ mo kandi.” Zë ayinnï, ïrïnnï Yësu anda'bannï mo gbɔ gö. ");
INSERT INTO mgc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma kölö tëmï vo lö'bö mati Yësu aba ne, otɔ kulu 'bënï tëmï sirikpa iga mbili vo lö'bö 'ba vo karasa, ikye yaga. ");
INSERT INTO mgc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yësu iya zi mo henye, “Aya'ba kulu 'bëyï ne hulëhu ga bi mo. Zë biya mati ïrïnnï kulu ne, akofo zë kulu aba. ");
INSERT INTO mgc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ayɔlɔ'e dë makako'jo 'Bu ma kö'du wa kɔnyi, kandi mo akutu kyɔ ta da malayika kpuluku'butë dɔmorïyö 'ba vo wehe? ");
INSERT INTO mgc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kö'du ne ako'dɔ rë nï zi tëdï kaa mati kö'du yöru iya mo'dɔ rë nï.” ");
INSERT INTO mgc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yësu ënyï ame'do zi vïdï kayo ne'e, iya henye, “Ayiye kulu mɔvɔ aba kala'e, zi ma kïrï mo kaa ma vo kö'du kï'dï pere? 'Duwï ma lima akaŋo kö'du yandi mï yëkëlu, ïrïye ma dë. ");
INSERT INTO mgc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kö'du nenye biya o'dɔ rë nï zi wa mati nëbïye ayörunnï, mï kö'du yöru zi tayi tïnyö.” Vo lö'bö biya ilannï mo ahowënnï. ");
INSERT INTO mgc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zë mati ïrïnnï Yësu ne, obannï mo tï'bë mo aba liŋɔ 'ba Kayafa kyedre 'ba vo karasa, bi mati vo komoyandi 'ba vo kö'du kï'dïye nnï vïdï kyedre ëtï atoto rë nnï ga bi kölö. ");
INSERT INTO mgc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petero usu gɔ mo ta bi kɔwɔ le bi 'ba vurë, liŋɔ 'ba kyedre 'ba vo karasa. Mo ï'bë ödu bi 'ba vurë alima gbɔ akaŋo vo kanya ëtï, kongɔ wa a'di ako'dɔ zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Vo da vo karasa 'e vïdï 'ba vurë'e kikye ëtï ayɔnzɔnnï zi mbërë kiga ra Yësu zi mo kofo, ");
INSERT INTO mgc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","zë i'jannï kö'du kyënyë maako dë, vïdï kayo ayinnï le ndɔndɔ kiga gumu. Ndundu mo aba vïdï kora rïyö ayinnï, ");
INSERT INTO mgc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iyannï henye, kora nenye iya henye, “Ma kiha akaŋo yëkëlu 'ba Wïrï ne, yaa ko'do da wota aba ko'ba mo löhu.” ");
INSERT INTO mgc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kyedre 'ba vo karasa ënyï rïyë iya zi Yësu henye, “Anza da kö'du ya'ba aba dë, ga kö'du wasusu rë yï ne?” ");
INSERT INTO mgc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yësu alima ti. Löhu kyedre 'ba vo karasa ame'do zi mo, iya henye, “Mï ru 'ba Wïrï dïdï yaanya aba mï'dï yï ku mï lömu, ayada zi ze ëzë yï Korisitɔ, Wisi 'ba Wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yësu aya'ba dɔ mo zi mo iya henye, “Mo ra kaa iya ne. Miya zi ye henye, tëmï kadra ma dagba ani, akongɔ'e Wisi a Vïdï ta bi lima da kala tïrï 'ba Wïrï kyigɔ tayi tëmï fɔli 'ba komorïyë.” ");
INSERT INTO mgc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mati kyedre 'ba vo karasa owo kö'du ne here, ënyï na kamo iza bɔngɔ 'bɔmo iya henye, “Ne kö'du sawiya ra. Domba kya kö'du 'ba vo hu kö'du dɔ rɔ dekpe. Owo'e kö'du sawiya ne ku. ");
INSERT INTO mgc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Asösu'e a'di ra?” Zë aya'bannï dɔ mo iyannï henye, “Mo o'dɔ kö'du kyënyë ku, mofo mo.” ");
INSERT INTO mgc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zë o'binnï oro komo mo, u'bönnï mo, zë maako'e isannï mo, ");
INSERT INTO mgc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iyannï henye, “Ayada zi ze Korisitɔ, ëzë yï nëbï ra, ayada ëyï ra isa yï.” ");
INSERT INTO mgc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mati Petero ëdï lima yaga mï liŋɔ 'ba Kalafa, vo lö'bö kölö tëmï mbara 'ba kyedre 'ba vo karasa ayi zi mo iya henye, “Yï kpa Yësu aba tëmï Galilaya.” ");
INSERT INTO mgc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mo iga hë nï ta da komo vïdï kayo ne'e biya. Mo aya'ba dɔ mo iya henye, “Ma yɔlɔ kö'du ma ëdï ame'do gɔ mo ne dë, ");
INSERT INTO mgc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ënyï asi wënï yaga ha loko bi 'ba vurë. Mbara vo lö'bö agamo ongɔ mo iya zi vïdïye henye, mo Yësu 'ba Nazereta aba.” ");
INSERT INTO mgc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Löhu Petero iga hë nï aya'ba dɔ mo iya henye, “Malömu tïnyö mayɔlɔ kora ne dë.” ");
INSERT INTO mgc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tisi yaa ta gɔ mo vïdï kora mati ëdïnnï tɔrɔ ani ne, ayinnï zi Petero iyannï henye, “Yï ma kölö tëmï zë, dayɔlɔ ze tëmï gërï me'do 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petero iya henye, “Ma lömu kö'du tïnyö ra mëdï ayada, ëzë anza dë here, Wïrï mï'dï riti zi ma. Ma yɔlɔ kora ne dë.” Zanga ënyï ayapa, ");
INSERT INTO mgc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petero asösu kö'du ma Yësu ayada zi nï iya henye, “Gba kazi yapa 'ba zanga, akiya da wota henye ere, ayɔlɔ ma dë.” Mo ënyï asi gbɔ yaga akudu na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kyere 'do da mïndö aba ŋbɔ, kyedre 'ba vo karasa'e nnï vïdï kyedre ëtï ï'dï kö'du 'bënnï ombannï ku zi Yësu kofo. ");
INSERT INTO mgc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Zë idannï mo nyɔri aba ikannï mo, ï'dïnnï mo zi Pilato, vo daliŋɔ mï turu 'ba Roma. ");
INSERT INTO mgc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mati Yudasi vo wasusu ayɔlɔ ombannï ku zi Yësu kofo, mo ayasi kö'du lïtë 'bënï ne, ënyï oba kɔhi ŋbiriṛi 'butëwota ne kika mo hulëhu zi kyedre 'ba vo karasa vïdï kyedre ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudasi iya zi zë henye, “Mo'dɔ kö'du kyënyë ku zi ma kora vo kazi kö'du kyënyë ko'dɔ ne kï'dï zi ye zi kofo.” Zë aya'bannï dɔ mo zi mo iyannï henye, “Anza kö'du 'beze ra dë, kö'du 'bëyï ra.” ");
INSERT INTO mgc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mati Yudasi owo kö'du ne here, odrɔ kɔhi ne komo zë ani mï yëkëlu, mo ënyï asi ï'bë ove gu nï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kyedre 'ba vo karasa aködu kɔhi ne iya henye, “Nenye kɔhi yama ra, mï kö'du kï'dï 'beze anza dekpe zi kï'dï mï kutë 'ba wa sesi mï loko 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mati ombannï dɔ mo ku, ogonnï yaka gbɔ kɔhi ne aba na bi 'ba zi yöku tu'dë maako'e kusu. ");
INSERT INTO mgc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kö'du nere ra, yaka ne ako'jo na yaka 'ba yama le ndenye. ");
INSERT INTO mgc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kö'du mati nëbï Yeremaya iya ne, ayi ku tïnyö. “Zë obannï kɔhi ŋbiriṛi 'butëwota, mati vïdï 'ba Yiserele ombannï dɔ mo zi kopi ga kö'du mo, ");
INSERT INTO mgc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kɔhi mo ne zi yaka kogo mo aba kaa mati Yere ï'dï kö'du mo zi ma.” ");
INSERT INTO mgc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yësu ɔrɔ komo vo daliŋɔ 'ba Roma, ako'jo hɔ mo iya henye, “Yï ra Yere vo damöku 'ba Yuda'e?” Yësu aya'ba dɔ mo iya henye, “Mo ra kaa iya ne.” ");
INSERT INTO mgc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mo ame'do dë na da kö'du ya'ba 'ba vo wa sösu'e, mati kyedre 'ba vo karasa'e nnï vïdï kyedre nani ëtï. ");
INSERT INTO mgc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato iya zi mo henye, “Owo kö'du mati asusunnï yï gɔ mo nenye dë?” ");
INSERT INTO mgc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mati Yësu omba dë zi da kö'du ma kölö ya'ba ne, o'dɔ Pilato gbɔ na rakaga. ");
INSERT INTO mgc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mï kadra 'ba karama 'ba laga 'ba koli aba, vo daliŋɔ 'ba Roma ëdï kö'du aba zi kinga yaga vïdï mati vïdïye ako'jonnï kö'du mo tëmï kamba. ");
INSERT INTO mgc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mï kadra nani, kora maako ëdï mï kamba ru mo Barabasi, mo na yɔlɔ ga kö'du ko'dɔ kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mati vïdï kayo ne atoto rë nnï, Pilato ako'jo hë zë iya henye, “Ma vala ra omba'e zi ma kinga zi ye? Barabasi, kɔdɔ Yësu mati ako'jo Korisitɔ?” ");
INSERT INTO mgc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mo ayɔlɔ na laka, vo kalakonda 'ba Yuda'e ï'dïnnï Yësu zi nï ga kö'du zë na mï kumbë. ");
INSERT INTO mgc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mati Pilato ëdï gba alima mï loko 'ba vurë, mbara 'bɔmo utu kö'du kise zi mo iya henye. “O'dɔ kö'du ako dë zi kora vo kazi kö'du yaŋa ne, wïrï ayaza ma mï yɔndɔ ne aba ga kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kyedre 'ba vo karasa nnï vïdï kyedre ëtï alëlunnï da vïdï kayo ne'e zi ha Pilato ko'jo zi Barabasi kinga, Yësu zi kofo. ");
INSERT INTO mgc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato ako'jo ha vïdï kayo ne'e, iya henye, “Ma vala ra tëmï vïdï rïyö nenye'e, omba'e ma zi kinga zi ye?” Zë aya'bannï dɔ mo iyannï henye “Barabasi.” ");
INSERT INTO mgc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ako'jo hë zë iya henye, “Mo'dɔ a'di zi Yësu mati ako'jo Korisitɔ ne?” Zë biya aya'bannï dɔ mo iyannï henye, “Matötö mo.” ");
INSERT INTO mgc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ako'jo hë zë iya henye, “Kö'du kyënyë a'di mo o'dɔ?” Ayetonnï hë nnï gbögbö gu kyembe aba, “Matötö mo.” ");
INSERT INTO mgc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mati Pilato ongɔ kö'du ma zi nï ko'dɔ anza kpe, kazi vïdï ne ënyïnnï na kamo, mo oba wini akaka kala nï ta da komo vïdï kayo ne'e, iya henye, “Manza dë mï koli 'ba kora nenye. Ne kö'du ko'dɔ 'be'e ra.” ");
INSERT INTO mgc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vïdï kayo ne'e biya aya'bannï dɔ mo, iyannï henye, “Yama koli 'bɔmo malëpï gbɔ de ze gisi 'beze ëtï.” ");
INSERT INTO mgc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato inga Barabasi zi zë, ta pëtï mo, u'bö hu Yësu, ï'dï mo gbɔ zi tötö. ");
INSERT INTO mgc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Here vo kanya a Pilato obannï Yësu tï'bënnï mo mï loko 'ba vo kanya'e. Vo kanya kayo atoto rë nnï kpo ta da kapa mo. ");
INSERT INTO mgc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Zë otɔnnï bɔngɔ 'bɔmo usunnï bɔngɔ konda 'ba yere rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Here zë o'dɔnnï safo tëmï kono ayöfunnï dɔ mo. Ï'dïnnï mɔvɔ 'ba yere kala mo ma tïrï alɔdrɔnnï da womo nnï aba komo mo sawiya ko'dɔ rɔ mo, zë iyannï henye, “Lima konda zi yï vo damöku 'ba Yuda'e.” ");
INSERT INTO mgc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Zë o'binnï oro komo mo, obannï mɔvɔ u'bönnï dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mati zë indennï sawiya ko'dɔ ku rɔ mo, zë otɔnnï bɔngɔ konda ne 'de ta rɔ mo, usunnï bɔngɔ ɔmo gbï löhu rɔ mo. Here zë obannï mo gbɔ kika mo yaga zi tötö mo. ");
INSERT INTO mgc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mati zë ëdï tï'bënnï yaga, zë andɔsi dë nnï kora maako aba tëmï Sirënë ru mo Simona, vo kanya'e o'dɔnnï mo na kamo zi taka a Yësu kïnjë. ");
INSERT INTO mgc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Zë ayinnï bi mati ako'jo Gologota ne, mï kö'du ya'ba aba “Bi 'ba Kiṛiyingɔ da.” ");
INSERT INTO mgc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ani zë ï'dïnnï a'ji zi Yësu na susë wa kata aba kuwë, mati anene ta pëtï mo, mo omba dekpe kuwë. ");
INSERT INTO mgc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mati zë atötönnï mo ku, zë ayanyannï bɔngɔ 'bɔmo tëmï kutë nnï födö ku'du aba zi yɔlɔ akalëpï zi ëyï. ");
INSERT INTO mgc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tapëtï mo, alimannï ani mo kongɔ. ");
INSERT INTO mgc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dɔ mo rïyë ï'dïnnï wayöru 'ba wasusu iya henye, “Nenye Yësu, yere 'ba Yuda'e” ");
INSERT INTO mgc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Zë atötönnï vo logo rïyö dakapa Yësu, ma kölö da kala mo ma tïrï ma agamo da kala mo ma gali. ");
INSERT INTO mgc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vïdï mati ëdï lagannï ta da kapa ne, dë nnï njili Yësu lidi aba, iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Here omba tï'bë yëkëlu ne kiha mo akaŋo, kuvö mo löhu mï ko'do da wota aba. Ayɔmɔ rë yï ëzë yï Wisi 'ba Wïrï. Asi akaŋo ta da taka.” ");
INSERT INTO mgc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tëmï gërï kölö ne, kyedre 'ba vo karasa vo komoyandi 'ba vo kö'du kï'dï nnï vïdï kyedre ëtï alimannï sawiya ko'dɔ ra Yësu iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mo ayɔmɔ oka'e, ayɔmɔ rë nï dë. Anza mo ra dë yere 'ba Yiserele? Ëzë mo ayi ku akaŋo ta da taka yaanya aba dakoma 'da mï mo. ");
INSERT INTO mgc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mo oma mï Wïrï, iya henye, ‘Nï Wisi 'ba Wïrï ra.’ Laka dongɔ'e te, ëzë Wïrï omba zi mo yɔmɔ yaanya aba.” ");
INSERT INTO mgc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vo logo mati atötö zë da kapa Yësu ne, alidi mo kpa here. ");
INSERT INTO mgc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mï kutë kadra aba mandölu ayöfu dakaŋo ne biya, inde rë nï le ta pëtï kadra wota aba. ");
INSERT INTO mgc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gba kaa kadra wota aba, Yësu ënyï udu gu kyembe aba iya henye, “Elöyï Elöyï lema sabakatani?” Mï kö'du ya'ba aba iya henye, “Wïrï ama, Wïrï ama, ila ma ga a'di ya?” ");
INSERT INTO mgc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kya vïdï ma ëdï tɔrɔnnï ani ne, iyannï henye, “Mo ëdï Eliya ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Vïdï ma kölö tëmï zë aho kandi oba lifa usu mï a'ji ï'dï da njili mɔvɔ, mo yɔnzɔ zi kuwë. ");
INSERT INTO mgc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kyamo'e iyannï henye, “Ɔrɔ dongɔ'e te, ëzë Eliya ëdï tayi zi mo yɔmɔ.” ");
INSERT INTO mgc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yësu api rïyë löhu na kyembe ila lawo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bɔngɔ mati ove mï yëkëlu 'ba Wïrï ne mï mo aliza rïyö kɔ ta rïyë le akaŋo. Dakaŋo akɔhɔ rë nï, lutu alihannï, ");
INSERT INTO mgc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","da wogo ayëhu rë nnï biya, vïdï kayo a Wïrï mati olinnï ne, ënyïnnï gbɔ na dïdï tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Zë ilannï da wogo, ta pëtï tënyï 'ba Yësu tëmï koli, ënyï ï'bënnï mï gawo laka ani vïdï kayo ongɔnnï zë. ");
INSERT INTO mgc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mati vo kyëlu 'ba vo kanya'e mati nnï mo aba, ëdïnnï ga Yësu kongɔ ne, ongɔnnï kinzikinzi biya wasisi mati o'dɔ rë nï ne, zë na tere iyannï henye, “Mo tïnyö Wisi 'ba Wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mbara kayo mati ëdïnnï Yësu kɔnyi, usunnï gɔ mo ta Galilaya ne, ëdïnnï atɔrɔ ani bi kongɔ ta bi kɔwɔ. ");
INSERT INTO mgc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mï kutë zë Mariya Magadala, Mariya ma 'ba Yemisi nnï Yosepa aba, mbara 'ba Zebedeyo. ");
INSERT INTO mgc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mati ëdï ku na hutaga, kora vo wa dakayo maako tëmï Arimataya, ru mo Yosepa ɔkɔ gbɔ, mo kpa vo lö'bö 'ba Yësu ra. ");
INSERT INTO mgc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mo ënyï ï'bë ako'jo ha Pilato kö'du yöku Yësu. Pilato ï'dï kö'du gbɔ kala konda aba zi yöku ne kï'dï zi Yosepa. ");
INSERT INTO mgc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosepa olo mï bɔngɔ ma kyïyï, ");
INSERT INTO mgc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","usu mï wogo ënï mati mo ole mï ṛï'dï, kyigɔ ne. Mo alulu yïtö kyedre ha wogo ne, isi ï'bë wënï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magadala nnï Mariya ma agamo ne aba, ëdï limannï ani bi kongɔ zɔ da wogo. ");
INSERT INTO mgc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mï ko'do 'ba ralawo aba, kyedre 'ba vo karasannï Farasi ëtï andɔsi dë nnï Pilato aba ");
INSERT INTO mgc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","iyannï henye, “Kyedre dasösu ze, mati vo ndɔndɔ kyedre ne ëdï gba na wïdï, mo iya henye, ‘Matënyï tëmï koli ko'do da wota aba.’ ");
INSERT INTO mgc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ï'dï kö'du zi ga wogo 'bɔmo ne kongɔ na laka le mï ko'do 'ba da wota ne, kazi vo lö'bö 'bɔmo ï'bë alogonnï yöku mo, akayadannï zi vïdï henye, ere, mo ënyï ku tëmï koli. Ndundu ndɔndɔ ma nenye atëdï ndra na kyënyë ta da ma dagba.” ");
INSERT INTO mgc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ayada zi zë iya henye, “Oba'e vo kanya'e zi tï'bënnï ga wogo ne kongɔ tëmï gërï ma laka.” ");
INSERT INTO mgc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Zë ï'bënnï da wogo a'ba'bannï ga yïtö ha wogo ne zi yada vïdï maako ayëhu dë. Ilannï vo kanya ani zi gɔ mo kongɔ. ");
INSERT INTO mgc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ta pëtï ko'do 'ba ralawo aba, mï kano bi kezi da mïndö ko'do 'ba ralawo aba, Mariya Magadala nnï Mariya vere aba ënyï ï'bënnï bi kongɔ da wogo. ");
INSERT INTO mgc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kandi mï kadra nani kinzikinzi kyigɔ akɔhɔ bi. Malayika 'ba Yere ayi akaŋo ta komorïyë, alulu yïtö ne 'de ta ha wogo alima gbɔ dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kyïnë mo na laka kaa bikanyi, bɔngɔ rɔ mo na kanyi kaa ṛï'dï 'ba mïrë. ");
INSERT INTO mgc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vo kanya ma ëdïnnï ga wogo ne kongɔ ne, zë na tere tese aba, mora a'bannï kaa vïdï mati olinnï ku. ");
INSERT INTO mgc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malayika ame'do zi mbara ne'e, mo iya henye, “Ere'e dë, mayɔlɔ ku ëdïye bi koma kö'du Yësu ma atötö ne. ");
INSERT INTO mgc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mo anza dë kinye, mo ënyï ku, kaa mati mo iya. Ayiye kinye, ongɔ'e bi mati o'bannï mo zi mo. ");
INSERT INTO mgc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ï'bë'e kandi yaanya aba, ayada'e zi vo lö'bö 'bɔmo'e ‘Mo ënyï ku tëmï koli. Yaanya aba mo ëdï ku tï'bë mï Galilaya dagba komo'e, ani aki'ja'e mo. Yaanya aba mayada ku zi ye.’” ");
INSERT INTO mgc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kandi ilannï da wogo tere aba, kpa na rakyenyi, ahonnï yada mo zi vo lö'bö 'bɔmo'e. ");
INSERT INTO mgc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kandi Yësu i'ja zë iya zi zë henye, “Rakyëyï mëdï ëtï.” Zë ayinnï zi mo ïrïnnï mo ta ndï mo amötunnï mo gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yësu iya zi zë henye, “Ere'e dë, ï'bë ayada'e zi öndu ma'e zi tï'bënnï mï Galilaya aki'jannï ma ani.” ");
INSERT INTO mgc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mati mbara ne ï'bënnï zi kö'du ne yada mo zi vo lö'bö 'bɔmo'e, kya 'ba vo kanya mati ëdïnnï ga wogo ne kongɔ ne, ënyï ï'bënnï hulëhu mï gawo ayadannï kö'du mati o'dɔ rë nï ne, biya zi kyedre 'ba karasa'e. ");
INSERT INTO mgc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kyedre 'ba vo karasa'e adrɔko rë nnï vïdï kyedre ëtï, zë o'dɔnnï yeṛe 'bënnï ï'dïnnï kɔhi kyedre zi vo kanya ne'e. ");
INSERT INTO mgc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mora iyannï henye, “Iya'e henye, ‘Vo lö'bö 'bɔmo ayinnï yɔndɔ aba alogonnï yöku mo mati ëdïye ako'do.’ ");
INSERT INTO mgc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ëzë vo daliŋɔ owo kö'du ne, dakalëlu ze dɔ mo dakiya henye, mo mï'dï riti dë zi ye.” ");
INSERT INTO mgc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vo kanya ne'e obannï kɔhi ne, o'dɔnnï te kaa kö'du mati ayada zi zë zi ko'dɔ mo ne. Mora here, kö'du ne apere rë nï biya mï kutë Yuda'e ko'do ndenye aba ne. ");
INSERT INTO mgc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vo lö'bö 'butë dɔmokölö ne ënyï ï'bënnï da lutu mï Galilaya bi mati Yësu ayada zi zë, zi tï'bënnï dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mati zë ongɔnnï mo, zë ayetonnï mo. Mora here, kya 'ba vo lö'bö maako'e omannï dë. ");
INSERT INTO mgc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yësu ehe kara, mora iya zi zë henye, “Kalakonda biya 'ba komorïyë dakaŋo aba, ï'dï ku zi ma. ");
INSERT INTO mgc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ï'bë'e zi vïdï biya ta bi ne o'dɔ'e zë na vo lö'bö ama. Abapatisiye zë mï ru 'ba 'Bu, Wisi, Lawo Kölö Laka aba, ");
INSERT INTO mgc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ayandiye zë zi koronnï kö'du kï'dï mati mï'dï zi ye ne biya. Matëdï 'e ëtï 'duwï le mï ndundu 'ba daliŋɔ aba.”");
INSERT INTO mgc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nenye kö'du yöyö laka ga kö'du Yësu Korisitɔ, Wisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ayeto rë nï kaa mati Nëbï Yisaya ayöru, “Ma kutu vo lïtu ama dagba komo yï zi gërï ëyï kɔ'jɔ. ");
INSERT INTO mgc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Vïdï maako ëdï mbere mï da lïpï, Akɔ'jɔ'e gërï nzɔ zi bi Yere. O'dɔ'e gërï mbïyï zi mo zi lasi.” ");
INSERT INTO mgc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Here Yowani alaya mï da lïpï bapatisi kï'dï ehe kö'du yëtï. Mo ayada zi zë motɔ dë nnï tëmï kö'du kyënyë zi zë bapatisi, ehe Wïrï akila kö'du kyënyë 'bëzë ne. ");
INSERT INTO mgc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vïdï kayo tëmï dakaŋo 'ba Yuda ehe gawo kyedre 'ba Yerusalema ï'bënnï kö'du 'ba Yowani ne kowo. Zë odrɔ hë nnï tëmï kö'du kyënyë 'bënnï ne ehe mo abapatisi zë mï ranga 'ba Yeredene. ");
INSERT INTO mgc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowani usu bɔngɔ 'bënï o'dɔ tëmï yëvu 'ba jemele, ida kɔ'di wana gbö gë nï, ehe wakonyo 'bɔmo wömï ehe yazi möku. ");
INSERT INTO mgc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mo ayöyö zi vïdïye henye, “Kora mati mo atayi ta ga ma ne, atëdï kyedre ta da ma. Manza dë na laka zi ra ma kïdë akaŋo zi kamoka 'bɔmo kinga. ");
INSERT INTO mgc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma bapatisi ye wini aba, mora mo akabapatisi ye Lawo Kölö Laka aba.” ");
INSERT INTO mgc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tëmï kadra nani, Yësu ayi tëmï Nazereta mï dakaŋo 'ba Galilaya zi Yowani, zi nï bapatisi mï ranga 'ba Yeredene. ");
INSERT INTO mgc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kandi mati Yësu asi yaga tëmï wini, mo ongɔ komorïyë ayëhu rë nï, ehe Lawo Kölö Laka ayi aloso dɔ mo kaa atu'bu. ");
INSERT INTO mgc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Here gu ayi ta komorïyë iya henye, “Yï gogo wisi ama ra. Ma na rakyenyi yï aba.” ");
INSERT INTO mgc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kandi Lawo Kölö Laka o'dɔ mo tï'bë mï da lïpï, ");
INSERT INTO mgc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ani ko'do 'butësowɔ mï wayɔnzɔ 'ba Satani. Ngötu 'ba möku ëdïnnï kpa ani, mora malayika'e ayinnï ehe akɔnyinnï mo. ");
INSERT INTO mgc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tapëtï ï'dï Yowani ku mï kamba, Yësu ï'bë mï Galilaya ehe ayeto kö'du yöyö laka kazi Wïrï ne yëtï. ");
INSERT INTO mgc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mo iya henye, “Kadra ma laka ɔkɔ ku ehe damöku 'ba Wïrï ku kara. Otɔ de 'e tëmï kö'du kyënyë 'be'e ne ehe oma'e mï kö'du yöyö laka ne.” ");
INSERT INTO mgc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mati Yësu ï'bë ta da götï 'ba föfö 'ba Galilaya, mo i'ja kora vo kyenze kïrïye rïyö, Simona öndu nï Anderiya aba, ëdïnnï kyenze kïrï öndu aba. ");
INSERT INTO mgc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yësu iya zi zë henye, “Ayiye zi ma, makayandi ye zi vïdï kika zi ma.” ");
INSERT INTO mgc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kandi ilannï öndu 'bënnï ne, ehe ï'bënnï mo aba. ");
INSERT INTO mgc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mo ï'bë tisi dagba ani, ehe i'ja öndu maako'e rïyö Yemisi, Yowani aba, zë gisi 'ba Zebedeyo. Zë ëdïnnï mï töŋbö öndu ënnï kɔ'jɔ nzɔ. ");
INSERT INTO mgc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Here mati Yësu ongɔ zë, mo ako'jo zë ehe zë ila 'bu nnï Zebedeyo mï töŋbö kora vo lɔɔ ëtï, ehe ï'bënnï Yësu aba. ");
INSERT INTO mgc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yësu vo lö'bö 'bënï ëtï ayinnï mï gawo 'ba Kaparanamo, mï ko'do 'ba ralawo aba, Yësu ï'bë mï bi 'ba mötu, ehe ayeto kö'du yëtï. ");
INSERT INTO mgc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vïdï mati owonnï ne, zë na rakaga tëmï gërï 'ba kö'du yëtï 'bɔmo ne, kö'du mo anza dë kaa vo komoyandi 'ba vo kö'du kï'dïye, ga kö'du mo ayëtï kö'du kalakonda aba. ");
INSERT INTO mgc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Here kora dakyikyi aba mï nï ëdï mï bi 'ba mötu, ehe udu rïyë, ");
INSERT INTO mgc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Omba a'di kazi ze, Yësu 'ba Nazereta? Yï kinye ne zi yaŋa ze? Ma yɔlɔ ku yï ëyï ra, yï vo lïtu laka a Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yësu ame'do na kamo zi dakyikyi ne, “Alima tiyi, ehe asi yaga ta ra kora ne.” ");
INSERT INTO mgc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dakyikyi ne akɔhɔ kora ne na kyigɔ, udu na kamo, ehe asi yaga ta rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vïdï biya na rakaga ehe ayetonnï me'do na ga rë nnï zi oka maako. “A'di ra here? Ne kya 'ba kö'du yandi kyïyï maako? Kora nenye ëdï kalakonda aba zi kö'du kï'dï zi dakyikyiye, ehe zë owonnï hɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Here kö'du 'ba Yësu apere rë nï kandi ta ga bi ne biya mï dakaŋo 'ba Galilaya. ");
INSERT INTO mgc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yësu, Yemisi, Yowani aba, ilannï bi 'ba mötu, ehe ï'bënnï mbïyï liŋɔ 'ba Simona ehe Anderiya. ");
INSERT INTO mgc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wese 'ba Simona ëdï na rakɔɔ mï sora rakyïtu aba, ehe kandi mati Yësu ɔkɔ, iyannï kö'du mo zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mo ï'bë zi mo, ïrï kala mo ehe akɔnyi mo rïyë. Rakyïtu ne ila mo, ehe mo ayeto gbɔ lïtu zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tapëtï kadra aloso ku ehe hutaga ɔkɔ kpa ku, vïdï ikannï zi Yësu vo rakɔɔ'e biya ehe zë mati dakyikyi aba. ");
INSERT INTO mgc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vïdï biya 'ba mï gawo ne atɔtɔ rë nnï ha loko. ");
INSERT INTO mgc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yësu akɔ'jɔ zë mati kyɔ na rakɔɔ dakyïnë aba biya, ehe ore dakyikyi lakyi yaga. Mo ila vo dakyikyiye dë zi kö'du maako kiya, ga ko'du zë ayɔlɔnnï ku mo ëyï ra. ");
INSERT INTO mgc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mï da mïndö maako gba kazi bikanyi 'ba kadra Yësu ënyï ila liŋɔ ehe ï'bë yaga tëmï gawo ga bi mbiya amötu. ");
INSERT INTO mgc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simona abokanï ëtï ï'bënnï mo koma. ");
INSERT INTO mgc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mati zë i'jannï mo, iyannï zi mo henye, “Vïdï biya ëdïnnï yï koma.” ");
INSERT INTO mgc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mora Yësu aya'ba da me'do zi zë henye, “Dï'bë'e zɔ dagba zi liŋɔ maako'e mati gbö kinye ne. Momba kpa zi kö'du yëtï mï zë, kö'du nere ra mayi gɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Here mo ï'bë mï Galilaya kö'du yëtï aba biya mï bi 'ba mötu ehe dakyikyi kore aba yaga. ");
INSERT INTO mgc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kora maako ëdï na riti kazi kɔɔ mönyu ayi zi Yësu, alɔmvɔ akaŋo ehe alenze mo kö'du wakɔnyi iya henye, “Ëzë omba ku, atɔ'bɔ ma ko'dɔ ŋbala.” ");
INSERT INTO mgc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yësu kö'du sösu aba, ehe iza kala nï yaga ehe ise rɔ mo. Mo aya'ba da me'do henye, “Momba ku. Ëdï na ŋbala.” ");
INSERT INTO mgc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kandi mönyu ila kora ne ehe rɔ mo gbɔ ŋbala. ");
INSERT INTO mgc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Here Yësu ise gɔ mo, ehe utu mo 'de kandi, ");
INSERT INTO mgc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","iya henye, “Owo te, ayada kö'du ne dë zi vïdï ma kölö maako. Mora ï'bë zɔ mbïyï zi vo karasa mayɔnzɔ yï, zi yada zi vïdïye mönyu 'bëyï inde rë nï ku. Ï'dï wakumu kaa kö'du kï'dï 'ba Mosa.” ");
INSERT INTO mgc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mora kora ne ï'bë ehe kö'du ne yada ta ga bi ne biya. Mo ame'do takanyi mï kö'du ne, here Yësu ɔ'bɔ dekpe zi tï'bë mï gawo na dangölö. Mora mo alima akpa yaga mï ga bi mbiya ne'e ehe vïdï ayinnï zi mo tëmï ga bi ne biya. ");
INSERT INTO mgc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tapëtï ko'do yaa, Yësu ënyï ï'bë hulëhu mï Kaparanamo ehe kö'du yöyö apere rë nï iya mo ëdï liŋɔ. ");
INSERT INTO mgc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Vïdï kayo ayinnï ga bi kölö, ani bi ako ɔsɔ dë mï loko, gbï le yaga ha loko bi kpa anza dë. Yësu ëdï kö'du yöyö ne yëtï zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Vïdï kora sowɔ ɔkɔnnï, ëdïnnï kora mati eŋe kyere akaŋo ne kïnjë kika mo zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ga kö'du vïdï kayo, zë ɔ'bɔnnï dë zi kora ne kika mo zi mo. Here zë ïtïnnï bïngö ta komo lembe mbïyï bi mati Yësu ëdï. Mati ayëhunnï bi ne ku, zë izannï kora ne akaŋo, ëdï ako'do da laŋba. ");
INSERT INTO mgc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mati Yësu ongɔ hala ëdïnnï kö'du koma aba, iya zi kora keŋe ne henye, “Wisi ama, kö'du kyënyë 'bëyï ila ku.” ");
INSERT INTO mgc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Vo komoyandi 'ba kö'du kï'dï maako'e mati ëdï alimannï ani ne, asösunnï kö'du, ");
INSERT INTO mgc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hala mo ame'do kaa nenye here?” Ne kö'du sawiya ra. Wïrï ra nje kölö atɔ'bɔ kila kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kandi Yësu ayɔlɔ kö'du mati zë ëdïnnï asösu ne, here mo iya zi zë, “Ëdïye kö'du mahere ne sösu ga a'di? ");
INSERT INTO mgc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma vala ra anza na kyigɔ zi kiya zi vo keŋe ne, ‘Ila yï ku tëmï kö'du kyënyë 'bëyï,’ kɔdɔ zi kiya henye, ‘Ënyï, ïnjë laŋba 'bëyï ne, ï'bë’? ");
INSERT INTO mgc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Here zi ye yɔlɔ laka Wisi a Vïdï ëdï kalakonda 'ba dakaŋo nenye aba zi vïdï kila tëmï kö'du kyënyë, miya zi vo keŋe ne, ");
INSERT INTO mgc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Mëdï kiya zi yï, ënyï, ïnjë laŋba 'bëyï ne, ï'bë liŋɔ.’” ");
INSERT INTO mgc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Here mo ënyï ta da komo zë, ehe ïnjë laŋba ënï, ï'bë gbɔ. Zë biya na rakaga, zë ayetonnï Wïrï, iyannï henye, “Wa mahere ne, dongɔ dë gba kyere.” ");
INSERT INTO mgc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yësu ï'bë hulëhu löhu da götï föfö 'ba Galilaya, vïdï kayo atɔtɔ rë nnï zi mo ani, mo ayeto zë yandi. ");
INSERT INTO mgc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mati mo ëdï tï'bë lasi aba, mo i'ja vo 'be'bele kö'du ru mo Lëvï wisi 'ba Alipayo, ëdï alima mï bi 'ba 'be'bele kö'du. Yësu iya zi mo henye, “Alö'bö ga ma.” Lëvï ënyï, ehe alö'bö gbɔ gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mati Yësu ëdï wakonyo liŋɔ a Lëvï, vo 'be'bele kö'du kayo ehe vo kö'du kyënyë kayo ko'dɔ'e mati alö'bönnï ga Yësu ne, ma kayo tëmï zë adrɔ'bo rë nnï mo aba, ehe vo lö'bö 'bɔmo ëtï wakonyo ga bi kölö. ");
INSERT INTO mgc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Vo komoyandi 'ba vo kö'du kï'dïye ru zë Farasi ne, i'jannï Yësu ëdïnnï wakonyo ga bi kölö vo kö'du kyënyë ëtï ehe vo 'be'bele kö'du'e. Here zë ako'jonnï ha vo lö'bö 'bɔmo'e, “Kö'du a'di mo onyo wa vïdï mahere ne ëtï?” ");
INSERT INTO mgc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yësu owo kö'du 'bëzë ne, aya'ba dɔ mo zi zë, iya henye, “Vïdï mati rë zë na laka kazi kɔɔ, ombannï dakatörö dë, nje zë ma na rakɔɔ. Mayi dë ga kö'du vïdï laka'e, mayi ga kö'du vïdï kyënyë'e.” ");
INSERT INTO mgc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vo lö'bö 'ba Yowani Bapatisi ehe Farasiye ëdïnnï hë nnï koro. Vïdï maako'e ayinnï zi Yësu, ako'jonnï hɔ mo, “Kö'du a'di vo lö'bö 'ba Yowani Bapatisi ehe Farasiye ëdïnnï hë nnï koro, mora vo lö'bö 'bëyïye oronnï hë nnï dë gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yësu aya'ba da me'do zi zë iya henye, “Omba 'be'e yingɔ mati ëdïnnï bi 'ba oze ne, zi tï'bënnï kazi wakonyo? Anza here dë. Ëzë kora vo mbara ëdï gba zë aba, zë ɔ'bɔnnï dë zi ko'dɔ here. ");
INSERT INTO mgc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kadra mo atɔkɔ ëzë oba kora vo mbara ku 'de kazi zë akoro hë nnï 'da.” ");
INSERT INTO mgc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Vïdï maako uru bɔngɔ ma kyïyï dë zi kɔ'jɔ bɔngɔ ma kɔɔ. Ëzë o'dɔ here, ma kyïyï ne aya'ba tisiwa aba, ehe akire bɔngɔ ma kɔɔ ne, ehe ako'dɔ ogo kyedre. ");
INSERT INTO mgc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Vïdï maako odrɔ a'ji ma kyïyï dë gbï mï lɔsɔ wana ma kɔɔ. Ëzë o'dɔ here, a'ji ne akiha lɔsɔ wana, ehe a'ji 'dö lɔsɔ wana aba akayaŋa rë nnï. Mora laka zi kope a'ji ma kyïyï gbï mï lɔsɔ wana ma kyïyï.” ");
INSERT INTO mgc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mï ko'do 'ba ralawo aba, Yësu ëdï atï'bë kpuru tëmï yaka 'ba nyenyo. Mati vo lö'bö 'bɔmo'e ëdï atï'bënnï mo aba ne, ayetonnï da nyenyo ne kowe zi konyo. ");
INSERT INTO mgc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasiye iyannï zi Yësu henye, “Ongɔ te, kö'du a'di vo lö'bö 'bëyïye ëdïnnï kö'du mati ï'bë dë ga kö'du kï'dï 'ba ko'do 'ba ralawo ne ko'dɔ gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yësu ënyï, aya'ba dɔ mo zi zë iya henye, “Ako'jo'e kö'du mati Dawidi o'dɔ mï kadra nani dë, mati mo omba wa zi konyo mï kadra mati mo vïdï 'bënï ëtï na o'bo ne? ");
INSERT INTO mgc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Here mo ï'bë mï loko a Wïrï ehe onyo mangɔlɔ'bɔ mati ï'dï zi Wïrï ne. Kö'du ne o'dɔ rë nï mï kadra mati Abiyata ra na vo karasa ma kyedre. Ëdï mï kö'du kï'dï 'beze nje vo karasa'e ra akonyonnï mangɔlɔ'bɔ ne, mora Dawidi onyo, ehe ï'dï kpa zi vïdï 'bënïye.” ");
INSERT INTO mgc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yësu aya'ba gɔ mo zi zë iya henye, “O'dɔ ko'do 'ba ralawo ne kö'du vïdï, o'dɔ vïdï dë kö'du ko'do 'ba ralawo. ");
INSERT INTO mgc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Here Wisi a Vïdï ëdï gbï na Yere 'ba ko'do ralawo.” ");
INSERT INTO mgc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kadra maako aba Yësu ï'bë bi 'ba mötu. Kora maako ëdï ani kala mo eŋe ku. ");
INSERT INTO mgc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Vïdï maako'e ëdïnnï ani, zë ombannï zi Yësu susu ga kö'du lïtë ko'dɔ. Here zë alimannï mo kongɔ kara kɔdɔ mo akakɔ'jɔ kora ne ndö mï ko'do 'ba ralawo. ");
INSERT INTO mgc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yësu ame'do zi kora vo kala keŋe ne, “Ayi tɔrɔ komo ze kinye.” ");
INSERT INTO mgc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Here mo ako'jo ha vïdï ne'e iya henye, “A'di ra kö'du kï'dï 'beze ila ze zi ko'dɔ mï ko'do 'ba ralawo? Zi kɔnyi, kɔdɔ zi ko'dɔ na kyënyë? Zi dïdï vïdï yɔmɔ, kɔdɔ zi yaŋa mo?” Mora 'de iyannï kö'du ako dë. ");
INSERT INTO mgc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yësu na kamo mati mo ongɔ bi dë zë, ga kö'du kazi kö'du kowo. Here mo iya zi kora ne, “Iza ga kala yï ne yaga.” Mo iza yaga, a'ba na laka löhu. ");
INSERT INTO mgc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Here Farasiye ilannï bi 'ba mötu ne, ehe atɔtɔ rë nnï kandi vïdï 'ba Heroda ëtï, o'dɔnnï yeṛe zi Yësu kofo. ");
INSERT INTO mgc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yësu vo lö'bö ënï ëtï ëdï tï'bënnï ha föfö 'ba Galilaya, vïdï kayo alö'bönnï gɔ mo. Vïdï ne maako'e ayinnï tëmï Galilaya, Yudiya, ");
INSERT INTO mgc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusalema, Edome, ta dakaŋo kafo ranga 'ba Yeredene, Tiyere, Sidoni aba. Vïdï ne ayinnï biya zi Yësu ga kö'du wa mati zë owonnï mo ëdï ako'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ga kö'du vïdï ayo takanyi, Yësu iya zi vo lö'bö 'bënïye makɔ'jɔnnï töŋbö nzɔ zi nï tëkyï mï mo, kazi vïdï utunnï nï. ");
INSERT INTO mgc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mo akɔ'jɔ vo rakɔɔ kyɔ, ehe zë mati gba na rakɔɔ ne nduwë rë nnï sikyi dagba ga kö'du zi rɔ mo kise. ");
INSERT INTO mgc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ëzë vïdï mati ëdïnnï dakyikyi aba mï nnï ongɔnnï mo, akalëpïnnï akaŋo, akiyannï henye, “Yï wisi 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Here Yësu iya zi dakyikyi ne'e, mayadannï dë zi vïdï ëyï 'bënï nï. ");
INSERT INTO mgc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Here Yësu ï'bë rïyë da lutu, ako'jo vïdï mati mo omba ne tayinnï zi nï. Zë ayinnï zi mo, ");
INSERT INTO mgc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mo inzi 'butë dɔmorïyö tëmï zë, ï'dï ru zë ku vo lïtu'e, mo ayada zi zë henye, minzi ye ku zi tëdïye ma aba, zi kutu'e kpa yaga tï'bë kö'du yëtï, ");
INSERT INTO mgc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","zi tëdïye kpa kalakonda aba zi dakyikyi kore mo yaga. ");
INSERT INTO mgc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nenye ma 'butë dɔmorïyö mati mo inzi, Simona, Yësu ï'dï ru mo Petero, ");
INSERT INTO mgc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yemisi öndu nï Yowani aba, zë gisi 'ba Zebedeyo, Yësu ï'dï ru dë zë Bonerega kö'du ya'ba aba piwo, ");
INSERT INTO mgc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderiya, Pilipo, Baratolomoya, Matayo, Toma, Yemisi wisi 'ba Alipayo, Tadöyösu, Simona mati o'dɔ lɔvɔ 'ba dakaŋo 'bënï, ");
INSERT INTO mgc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yudasi Sikereto mati asusu Yësu zi kofo mo ne. ");
INSERT INTO mgc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yësu ï'bë ödu loko, vïdï kayo atɔtɔ rë nnï, here Yësu vo lö'bö 'bënï ëtï i'jannï kadra 'ba zi wakonyo dë. ");
INSERT INTO mgc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mati vo dakota 'bɔmo owonnï kö'du ne here, ï'bënnï zi gɔ mo kongɔ, ga kö'du vïdï ëdïnnï akiya, “Mo aṛifo ku.” ");
INSERT INTO mgc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vo komoyandi 'ba vo kö'du kï'dï maako'e, mati ayinnï ta Yerusalema ne, iyannï henye, “Mo ëdï Belezobulu aba mï nï.” Ne yere 'ba dakyikyiye ra ï'dï kyigɔ ne zi mo zi kore zë yaga. ");
INSERT INTO mgc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Here Yësu ako'jo zë zi nï, ame'do zi zë tëmï mala. “Hala Satani akore Satani yaga? ");
INSERT INTO mgc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ëzë damöku inye rë nï na gbɔngo gbɔngo, damöku ne akalëpï. ");
INSERT INTO mgc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Here ëzë dakota inye rë nï na gbɔngo gbɔngo, dakota ne akalëpï. ");
INSERT INTO mgc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Here ëzë damöku 'ba Satani inye rë nï na gbɔngo gbɔngo, ɔ'bɔ tëhï dë, akalëpï, akinde rë nï. ");
INSERT INTO mgc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Vïdï kölö maako ɔ'bɔ dë zi tödu mï loko 'ba kora vo tembe zi wasisi ɔmo kolɔ, nje ëzë mo ida kora vo tembe ne ku dagba, atehe 'da wa ɔmo kolɔ. ");
INSERT INTO mgc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Miya zi ye tïnyö henye, akatɔ'bɔ vïdï kila tëmï kö'du kyënyë 'bëzë ne biya, ehe me'do lasa 'bëzë biya. ");
INSERT INTO mgc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Here vïdï mati akame'do kö'du kyënyë ra Lawo Kölö Laka ne ila mo dë, ga kö'du mo o'dɔ kö'du kyënyë ma ŋburu ŋburu ne ku.” ");
INSERT INTO mgc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yësu iya kö'du ne here, ga kö'du vïdï maako'e ëdïnnï akiya “Dakyikyi ra ëdï mo ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Here ma 'ba Yësu öndu mo ëtï ɔkɔnnï. Zë ɔrɔnnï 'de yaga ta ra loko, utunnï kö'du kise kö'du ko'jo ga kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Vïdï mati ëdïnnï alima kpo ta ra Yësu, iyannï zi mo henye, “Ongɔ te, ma yï, öndu yïye ëtï ëdïnnï yaga, zë ombannï yï.” ");
INSERT INTO mgc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yësu aya'ba da me'do zi zë, iya henye, “Ëyï 'bënï ma ma? Ëyïye 'bënnï öndu ma'e?” ");
INSERT INTO mgc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mo ongɔ bi da vïdï mati ëdï alimannï kpo ta ra nï, iya henye, “Ongɔ'e te, kinye ne ma ma öndu ma'e ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vïdï mati o'dɔ wa mati Wïrï omba zi mo ko'dɔ ne, mo öndu ma, ëmï ma, ehe ma ma.” ");
INSERT INTO mgc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kadra maako aba löhu, Yësu ayeto kö'du yandi da kapa föfö 'ba Galilaya. Vïdï mati atɔtɔ rë nnï kpo ta rɔ mo ne, ëdïnnï kyɔ, here mo ëkyï mï töŋbö, alima mï mo. Töŋbö ne ëdï mï föfö, vïdï kayo ne'e ɔrɔ 'bënnï 'de yaga da götï 'ba föfö. ");
INSERT INTO mgc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mo alima kö'du kayo ne yandi mo zi zë tëmï mala. Mï kö'du yandi 'bɔmo ne mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Owo'e te. Kora maako ï'bë yaga kofo kïlï mï yaka. ");
INSERT INTO mgc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mati mo ïlï kofo ne mï yaka, maako'e alëpï da ga gërï, ali ayinnï, onyonnï 'de. ");
INSERT INTO mgc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maako'e alëpï dakaŋo ma ṛï'dï aba, mati kaŋo nje tisiwa aba ne. Kandi kofo ne ötu, ga kö'du kaŋo ne ayöndu dë. ");
INSERT INTO mgc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Here kadra ayi rïyë, o'bɔ wevo ma luru ne, ga kö'du ngara'da mo ödu dë na laka mï kaŋo. ");
INSERT INTO mgc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kofo maako'e alëpï mï kutë kono, övu ayasi wevo nï, mora 'de ana dë. ");
INSERT INTO mgc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kofo maako'e alëpï mï kaŋo ma laka ne, wevo mo asi, övu, ana ï'jö. Maako'e ëdïnnï ï'jö aba 'butëwota, maako'e 'butëmodaka, maako'e lamikölö.” ");
INSERT INTO mgc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yësu aya'ba gɔ mo zi zë iya henye, “Mo mati ëdï mbili aba, mowo kö'du ne.” ");
INSERT INTO mgc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mati Yësu ëdï kutï nï aba, vïdï maako'e mati owonnï kö'du mo ne, ayinnï zi mo vo lïtu 'butë dɔmorïyö ëtï, ako'jonnï hɔ mo zi mï mala ne'e yada. ");
INSERT INTO mgc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yësu aya'ba dɔ mo zi zë, iya henye, “Kö'du koho 'ba damöku 'ba Wïrï ï'dï ku zi ye. Mora zi vïdï maako'e kö'du koho akayandi tëmï mala. ");
INSERT INTO mgc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Here zë akongɔnnï akongɔ, mora 'de kaa ongɔnnï dë. Ëzë o'dɔnnï here akotɔ dë nnï zi Wïrï, akila zë.” ");
INSERT INTO mgc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yësu ako'jo hë zë iya henye, “Ayɔlɔ'e mï mala ne dë? Akayɔlɔ'e mala maako'e hala? ");
INSERT INTO mgc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vo kofo kïlï ne ïlï kö'du me'do 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vïdï maako'e kaa kofo mati alëpï da ga gërï. Kandi ëzë owonnï kö'du me'do ne, Satani ayi oba 'de. ");
INSERT INTO mgc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vïdï maako'e kaa kofo mati alëpï da ṛï'dï. Kandi ëzë owonnï kö'du me'do ne, ïrïnnï na rakyenyi. ");
INSERT INTO mgc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mora ödu dë gbo mï zë, here ne ɔ'bɔ limannï 'diri dë. Ëzë riti maako mandere wakofo ayi ga kö'du me'do ne, zë akilannï 'de. ");
INSERT INTO mgc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vïdï maako'e ëdïnnï kaa kofo mati ïlï mï kutë kono. Ne ëdï zë mati owonnï me'do ne, ");
INSERT INTO mgc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kö'du sösu, lɔvɔ 'ba kɔhi, lɔvɔ kö'du wakyɔ, akakɔhɔ me'do ne, mora anannï ï'jö dë. ");
INSERT INTO mgc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Vïdï maako'e ëdïnnï kaa kofo mati ïlï mï kaŋo laka. Zë owonnï me'do ne, ombannï dɔ mo, anannï ï'jö maako'e 'butëwota, maako'e 'butëmodaka, maako'e lamikölö.” ");
INSERT INTO mgc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yësu alima nduwë kiya zi zë henye, “Vïdï maako here ne, oba lamba ndö kika mo hu sikɔ mandere hu sora? Anza here dë, ï'dï lamba da tarabiza. ");
INSERT INTO mgc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wa mati ëdï 'de kɔwɔ na koho akika yaga bikanyi. Wa mati ayöfu dɔ mo ne, akayëhu dɔ mo yaga. ");
INSERT INTO mgc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Owo'e kö'du ne, ëzë ëdïye mbili aba.” ");
INSERT INTO mgc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mo iya kpa zi zë henye, “Kö'du mati mëdï akiya zi ye ne, oze mbiliye na laka zi kowo mo. Wa yeri mati ëdï ako'dɔ'e zi oka'e, ako'dɔ kpa zi ye. ");
INSERT INTO mgc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vïdï mati ëdï mo aba, akï'dï zi mo kyɔ. Vïdï mati anza mo aba, akoba 'de kazi mo.” ");
INSERT INTO mgc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yësu nduwë kiya mo aba zi zë, iya henye, “Damöku 'ba Wïrï ëdï henye. Kora maako ïlï kofo mï yaka ënï. ");
INSERT INTO mgc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mati mo o'do yɔndɔ aba, ënyï kadra aba, kofo ne biya ëdïnnï ku mbili kï'dï, ëdïnnï kpa ku tövu. Mo ayɔlɔ dë hala o'dɔ rë nï here. ");
INSERT INTO mgc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kaŋo ra o'dɔ wevo ne na bi dënï zi tövu, zi ta na lɔgɔ. Dagba bïrïtï mo ma luru ne akalaya, mbili mo, ehe ndundu mo mbili ma ndɔ ï'jö aba. ");
INSERT INTO mgc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mati ï'jö ne alɔtri ku, kora ne ayeto kumu mo kulu aba, ga kö'du mo ayɔlɔ kadra mo ɔkɔ ku.” ");
INSERT INTO mgc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yësu ako'jo kö'du henye, “Dakiya ze damöku 'ba Wïrï ëdï kaa a'di? Mala a'di dako'dɔ ze zi yada mo? ");
INSERT INTO mgc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ëdï kaa kofo 'ba masatada, kofo mati tisi ṛiri mï dakaŋo ne. ");
INSERT INTO mgc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ta gɔ mo yaa, övu rïyë, ayi kyedre ta da wevo ne'e biya. Ï'dï ngora nï ma kyedre mo'e yaga, ali ayinnï, uvö loko ënnï mï galïlï mo.” ");
INSERT INTO mgc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yësu ayëtï kö'du kise 'bënï tëmï mala maako'e. Mo ayada zi zë kyɔ, kö'du zi zë tɔ'bɔ yɔlɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mo ɔ'bɔ dë me'do zi zë kazi mala. Ëzë mo ëdï vo lö'bö 'bënï ëtï, mo akayada kö'du ne'e biya zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mï da hutaga mï ko'do nani, Yësu iya zi vo lö'bö 'bënïye, “Ënyï dï'bë'e kyëtï 'ba föfö.” ");
INSERT INTO mgc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Here zë ilannï vïdï kayo ne'e, ehe vo lö'bö'e ëkyïnnï mï töŋbö, mati Yësu ëdï alima nzɔ mï mo, obannï mo nnï aba. Töŋbö maako'e alö'bönnï kpa ga ndï mo. ");
INSERT INTO mgc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Truku'du buluku kyigɔ aluku rïyë kagba 'ba wini, ayeto ku likɔ rïyë mï töŋbö, here omba ku kara zi koso wini aba. ");
INSERT INTO mgc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yësu ëdï 'de hulëhu mï töŋbö ako'do dë nï taka gara aba. Vo lö'bö 'bɔmo'e alironnï mo iyannï henye, “Vo komoyandi, asösu 'bëyï kö'du dë, ze hiya kara zi koli?” ");
INSERT INTO mgc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yësu ënyï rïyë, ame'do na kamo zi buluku, iya zi wini kagba ne henye, “Ɔrɔ, ti!” Buluku nnï wini kagba aba ɔrɔnnï, bi gbɔ liwo. ");
INSERT INTO mgc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yësu iya zi vo lö'bö 'bënïye henye, “Kö'du a'di ëdïye atere gɔ mo? Anza'e dë koma aba?” ");
INSERT INTO mgc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Zë tere kyedre aba, ako'jo ha oka maako, “Kora nenye ëyï? Buluku wini kagba aba, ɔwɔnnï mo?” ");
INSERT INTO mgc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yësu vo lïtu 'bënï ëtï ënyï ï'bë ɔkɔnnï kyëtï kapa föfö 'ba Galilaya mï dakaŋo 'ba Gerasa. ");
INSERT INTO mgc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kandi mati Yësu asi yaga tëmï töŋbö, andɔsi dë nnï kora maako aba, asi tëmï wogo 'ba da wogo ani ne. Kora ne ëdï dakyikyi aba mï nï. ");
INSERT INTO mgc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mo ëdï alima mï kutë da wogo. Vïdï ako ɔ'bɔ dekpe zi sesi mo na kida nyɔri aba. ");
INSERT INTO mgc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Da kyɔ ndï mo kala mo aba ëdï na kida, mora ta ga kadra ne biya mo akisi nyɔri ne, ehe akikye mï kɔhi ne ta ndï nï na nzoyi. Mo embe 'beri, vïdï maako ɔ'bɔ dë zi mo kïrï. ");
INSERT INTO mgc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kadra yɔndɔ aba mo ëdï lima alasi tëmï da wogo kpuru ta da lutu, kudu aba rë nï kumu yïtö aba. ");
INSERT INTO mgc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mo na kɔwɔ mati ongɔ Yësu, here aho alɔdrɔ domo nï aba akaŋo komo Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Here mo alörö na kyembe, iya henye, “Yësu wisi 'ba Wïrï omba a'di kazi ma? Lömu mï ru Wïrï, ma lenze yï, ï'dï riti dë zi ma.” ");
INSERT INTO mgc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mo iya kö'du ne ga kö'du Yësu ëdï akiya henye, “Dakyikyi asi 'de yaga ta ra kora ne.” ");
INSERT INTO mgc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Here Yësu ako'jo hɔ mo iya henye, “Ru yï ëyï?” Kora ne aya'ba da me'do iya henye, “Ru ma ‘Gboko,’ ga kö'du dëdï ze kyɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mo zɔ nduwë Yësu lenze kazi ore dakyikyi ne'e yaga ta dakaŋo nani. ");
INSERT INTO mgc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ani wa'do kayo ëdïnnï kara dakapa lutu wakonyo. ");
INSERT INTO mgc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Here dakyikyi ne'e zɔ rë nnï la'ba zi Yësu, iyannï henye, “Utu ze zi wa'do ne'e, zi ze tï'bë tödu mï zë.” ");
INSERT INTO mgc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mo ila dakyikyi ne'e tï'bë, ödunnï gbɔ mï wa'do ne'e. Wa'do ne'e ëdïnnï biya kaa kpulukurïyö, ahonnï akaŋo mï föfö, ehe aluyïnnï. ");
INSERT INTO mgc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kora mati ëdïnnï ga wa'do ne'e kongɔ, ahonnï 'de, ayöyönnï kö'du ne mï gawo mï haliŋɔ kö'du mati o'dɔ rë nï ne, yada zi vïdï. Vïdï ënyï ï'bënnï biya kö'du mati o'dɔ rë nï ne kongɔ. ");
INSERT INTO mgc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mati ayinnï zi Yësu, zë ongɔnnï kora mati ëdï kani gboko 'ba dakyikyi ëtï mï nï ne, mo ëdï alima ani bɔngɔ aba rë nï, dɔ mo ku na laka, zë biya na tere. ");
INSERT INTO mgc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Zë mati ongɔnnï komonnï aba, ayadannï zi vïdïye kö'du mati o'dɔ rë nï zi kora mati dakyikyi aba ne, ehe kö'du 'ba wa'do ne'e. ");
INSERT INTO mgc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Here zë ako'jonnï ha Yësu zi tënyï atï'bë 'de tëmï dakaŋo ënnï. ");
INSERT INTO mgc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Here mati Yësu omba ku zi tï'bë zi tëkyï mï töŋbö, kora mati ëdï kani dakyikyi aba mï nï ne, alenze mo iya henye, “Dï'bë ze yï aba.” ");
INSERT INTO mgc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yësu ila mo dë zi tï'bë ta gɔ mo, iya zi mo henye, “Ï'bë liŋɔ zi vo dakota 'bëyïye, ayada zi zë hala kö'du mati Yere o'dɔ zi yï, laka 'bɔmo zi yï ëdï hala.” ");
INSERT INTO mgc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Here kora ne ënyï ï'bë biya kpuru tëmï Gawo 'Butë ne'e, kö'du mati Yësu o'dɔ zi nï ne yada mo aba. Vïdï mati owonnï kö'du ne biya na rakaga. ");
INSERT INTO mgc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yësu ënyï ï'bë hulëhu kyëtï kapa 'ba föfö vere. Ani da kapa föfö, vïdï kayo atɔtɔ rë nnï kpo ta da kapa mo. ");
INSERT INTO mgc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Here vere maako ru mo ëdï Yayiro, mo ra na vo dagba 'ba bi 'ba mötu ani, mati mo ɔkɔ, ongɔ Yësu, mo umë rë nï akaŋo ndï mo, ");
INSERT INTO mgc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","alenze mo kö'du komba aba, iya henye, “Wu'jë tisi 'bama na rakɔɔ. Akɔ ayi, ï'dï kala yï dɔ mo, here zi mo tëdï na laka, na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yësu ënyï ï'bënnï mo aba. Here vïdï kayo mati ëdïnnï atï'bë Yësu ëtï ne, ëdïnnï mo diri ta da kapa biya. ");
INSERT INTO mgc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Here mbara maako ëdï ani, na riti ga kö'du yama ëdï taho ta rɔ mo kazi tɔrɔ kɔɔ 'butë dɔmorïyö. ");
INSERT INTO mgc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dakatörö kayo ëdïnnï le ɔwɔ kï'dï zi mo. Mo ayaŋa kɔhi 'bënï biya, mora here ne zi ta'ba na laka anza dë, ëdï wënï zɔ rë nï kidra dagba ta ga kadra biya. ");
INSERT INTO mgc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mo owo kö'du Yësu, ënyï ayi kafo mo mï kutë vïdï kayo ne. ");
INSERT INTO mgc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mo iya na bi dënï henye, “Ëzë mise gbï le nje bɔngɔ rɔ mo ne, matëdï na laka.” ");
INSERT INTO mgc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mo ongɔ here ise bɔngɔ rɔ mo ne, kandi yama ɔrɔ, mo ayɔlɔ ku mï ida rë nï henye, na kɔ'jɔ rë nï ku tëmï riti kyedre 'bënï ne. ");
INSERT INTO mgc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yësu kandi ayɔlɔ henye, kyigɔ asi ku ta rë nï yaga. Mo opi rë nï kpo tëmï kutë vïdï kayo ne, ako'jo kö'du henye, “Ëyï ra ise ra bɔngɔ ama?” ");
INSERT INTO mgc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vo lö'bö 'bɔmo aya'bannï da me'do zi mo henye, “Ongɔ te vïdï kayo mati ëdïnnï yï kuru ne, kö'du a'di ako'jo 'bëyï kö'du gɔ mo henye ere, ‘Ëyï ra ise ra ma?’” ");
INSERT INTO mgc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yësu zɔ nduwë lima bi kongɔ kpo ta rë nï zi yɔlɔ ëyï ra o'dɔ kö'du ne. ");
INSERT INTO mgc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Here mbara ne ayɔlɔ kö'du mati o'dɔ rë nï zi nï ne, mo ayi tese aba na tere, alɔdrɔ ndï mo, ayada kö'du tïnyö mati o'dɔ rë nï ne biya zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yësu aya'ba da me'do zi mo henye, “Wu'jë ama, koma 'bëyï o'dɔ yï ku ŋbala. Ï'bë na rakyëyï, makɔ'jɔ yï tëmï riti ne.” ");
INSERT INTO mgc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mati Yësu ëdï kö'du ne kiya, Vïdï maako'e ayinnï ta liŋɔ 'ba Yayiro, ayadannï zi mo henye, “Wu'jë 'bëyï oli ku. Kö'du a'di kpe zi riti kï'dï ra vo komoyandi ne gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yësu oze mbili nï dë da kö'du mati iyannï ne, mo aya'ba zi Yayiro henye, “Ere dë, nje kölö koma.” ");
INSERT INTO mgc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Here mo ila vïdï ma kölö maako dë zi tï'bë nï aba dagba, nje Petero, Yemisi, öndu nï Yowani aba. ");
INSERT INTO mgc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mati zë ɔkɔnnï liŋɔ 'ba Yayiro, Yësu ongɔ bi apere rë nï ku na yawa, owo kuyë rïyë kudu rala'ba aba. ");
INSERT INTO mgc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mo ënyï ï'bë ödu loko, iya henye zi zë “Kö'du a'di bi apere rë nï gɔ mo na yawa here? Kö'du a'di ëdïye kudu gɔ mo? Wu'jë tisi ne oli dë, ëdï öŋbö ako'do.” ");
INSERT INTO mgc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Here zë ogonnï mo. Mora here mo ore zë biya yaga, oba 'bu 'ba wu'jë tisi ne, ma mo, vo lö'bö 'bënïye wota. Mo ënyï ï'bë ödu mï loko mati yöku wu'jë tisi ne o'ba 'dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mo ïrï kala mo, iya zi mo henye, “Talita Kumu.” Kö'du ya'ba aba henye, “Wu'jë tisi, miya zi yï, ënyï rïyë.” ");
INSERT INTO mgc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Here mo ënyï, alasi kpo. Kɔɔ 'bɔmo ëdï 'butë dɔmorïyö. Mati kö'du ne o'dɔ rë nï, zë biya na rakaga. ");
INSERT INTO mgc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yësu ï'dï kö'du kise anza dë zi zë yada zi vïdï kölö maako, ehe mo iya henye, “Ï'dïye wa zi mo zi konyo.” ");
INSERT INTO mgc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yësu ënyï ila bi nani, ehe ï'bë hulëhu mï gawo 'ba dakaŋo 'bënï. Vo lö'bö 'bɔmo'e ï'bënnï mo aba. ");
INSERT INTO mgc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mï ko'do 'ba ralawo aba, mo ayeto kö'du yandi mï bi 'ba mötu. Vïdï kayo ëdïnnï ani, mati zë owonnï kö'du mo, zë biya na rakaga. Zë ako'jonnï kö'du iyannï henye, “Here mo i'ja kö'du ne biya ta kila? Kö'du yɔlɔ 'ba a'di ra here mati ï'dï zi mo ne? Hala mo ëdï kö'du koro ne'e ko'dɔ mo? ");
INSERT INTO mgc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mo anza vo kaga kïsë, wisi 'ba Mariya, öndu 'ba Yemisi, Yosepa, Yudasi, Simona aba? Anza dë ëmï mo'e ra ëdïnnï alima kinye ne?” Here zë ombannï mo dë. ");
INSERT INTO mgc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yësu ënyï iya zi zë henye, “Nëbï ɔwɔ ta bi ne biya, nje vïdï mï gawo liŋɔ 'bɔmo, karo mo'e, vo dakota 'bɔmo ëtï ra ombannï mo dë.” ");
INSERT INTO mgc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mo omba dë zi kö'du koro ako'e ko'dɔ ani, mo ï'dï kala nï nje da vïdï 'ba rakɔɔ gbɔngo maako'e, ehe akɔ'jɔ zë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mo rakaga kyedre aba ga kö'du vïdï anzannï dë kö'du koma aba. Yësu ënyï ï'bë kpo ta ra dakaŋo nani komo vïdï yandi aba. ");
INSERT INTO mgc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mo ako'jo vo lïtu 'butë dɔmorïyö ne'e bi kölö, utu zë yaga na rïyö rïyö. Mo ï'dï kalakonda ndra ta da dakyikyi ne'e. ");
INSERT INTO mgc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mo ise gɔ mo zi zë, “Oba'e waako dë 'e aba ta bi tï'bë 'be'e ne, mangɔlɔ'bɔ manza dë, aŋboro 'ba wa lenze manza dë, kɔhi manza kpa dë mï bɔngɔ re 'e, nje mɔvɔ. ");
INSERT INTO mgc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Usu'e kamoka, ehe ïnjë'e kya 'ba bɔngɔ dë ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ëzë ödu'e mï liŋɔ, alima'e mï liŋɔ nani le ila'e gawo nani. ");
INSERT INTO mgc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ëzë gawo mati ayiye mï mo vïdï ombannï dë 'e kïrï kala kyedre aba, mandere ombannï dë zi kö'du 'be'e kowo, ila'e bi nani, akyitɔ'e turufu ne 'de ta ndïye. Ne atëdï zi zë na wasënë.” ");
INSERT INTO mgc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Here zë ënyï ï'bënnï yaga kö'du yëtï aba zi vïdï dë nnï kotɔ tëmï kö'du kyënyë 'bënnï ne'e. ");
INSERT INTO mgc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Zë orennï dakyikyi yaga, apisinnï yënï ra vo kɔɔ'e, akɔ'jɔ zë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yaanya aba Yere Heroda owo kö'du ne, ga kö'du wa komba 'ba Yësu inde bi biya. Vïdï maako'e iyannï henye, “Yowani Bapatisi ra ënyï ku na dïdï tëmï koli, kö'du nere ra mo ëdï kyigɔ nenye aba zi tëdï kö'du koro ne'e ko'dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vïdï maako'e iyannï henye, “Mo Eliya ra.” Agamo'e iyannï henye, “Mo nëbï ra, kaa tëmï ma kölö mati ëdïnnï kani kyere nani.” ");
INSERT INTO mgc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mati Heroda owo kö'du ne, iya henye, “Mo, Yowani Bapatisi, mati mikye dɔ mo 'de nere ra ënyï tëmï koli.” ");
INSERT INTO mgc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Heroda ra na bi dënï ï'dï kö'du zi Yowani kïrï, kida mo, ku'du mo mï kamba. Heroda o'dɔ kö'du ne here ga kö'du mo oze Herodiya, mo le na mbara 'ba öndu mo Pilipo ne. ");
INSERT INTO mgc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yowani Bapatisi zɔ nduwë kö'du ne yada mo zi Heroda. “Anza dë na laka zi yï mbara 'ba öndu yï koze.” ");
INSERT INTO mgc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Here Herodiya ïrï kö'du ra Yowani, omba zi mo kofo. Mora mo ɔ'bɔ dë, ");
INSERT INTO mgc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ga kö'du Heroda ere Yowani, ga kö'du mo ayɔlɔ Yowani ne, mo vïdï laka ra, ehe agaga gɔ mo. Heroda ëdï le kö'du yëtï 'ba Yowani sösu, mora mo omba zɔ nduwë zi kowo mo. ");
INSERT INTO mgc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ndundu mo aba Herodiya i'ja gërï laka 'bënï. Ëdï mï ko'do ko'jo kadra 'ba Heroda, mo o'dɔ kyere, ise vïdï kyedre 'ba turu'e biya, vo wehe'e, vïdï kyedre 'ba Galilaya ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mati wu'jë 'ba Herodiya ne ayi, ɔlɔ komo vïdïye, kö'du ne eme ra Heroda nnï yingɔ 'bɔmo ëtï. Here Yere Heroda iya zi wu'jë ne henye, “A'di ra omba zi tëdï zi yï? Makï'dï zi yï wa mati omba.” ");
INSERT INTO mgc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ha kï'dï lömu aba mo iya zi wu'jë ne henye, “Miya henye, makï'dï wa mati ako'jo kö'du mo ne zi yï, ëzë ëdï le kyedre kaa kutë damöku 'bama.” ");
INSERT INTO mgc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Here wu'jë ne asi ï'bë zi ma nï yaga. Ako'jo hɔ mo, “A'di ra makako'jo kö'du mo?” Ma mo aya'ba da me'do iya henye, “Ako'jo kö'du ga da Yowani Bapatisi.” ");
INSERT INTO mgc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Here wu'jë ne aho kandi hulëhu zi tï'bë kö'du ne kiya zi Yere Heroda, iya henye, “Momba zi yï kï'dï zi ma kinye yaanya aba ne da Yowani Bapatisi mï kakpa ne.” ");
INSERT INTO mgc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mati Yere Heroda owo kö'du ne here, o'dɔ mo na rasösu. Mo ɔ'bɔ dekpe zi komba dë zi wu'jë ne, ga kö'du mo o'dɔ ku na lömu ta da komo yingɔ 'bënï ne'e biya. ");
INSERT INTO mgc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Here mo utu vo kanya 'bënï kö'du kï'dï aba zi tï'bë da Yowani kika mo. Vo kanya ënyï ï'bë mï kamba, ikye da Yowani 'de. ");
INSERT INTO mgc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mo ika mï kakpa, ï'dï zi wu'jë ne, ehe mo ï'dï gbɔ zi ma nï. ");
INSERT INTO mgc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mati vo lö'bö 'ba Yowaniye owonnï kö'du ne, zë ayinnï, obannï yöku mo, ï'bë usunnï. ");
INSERT INTO mgc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mati vo lïtu i'ja rë nnï Yësu ëtï, a'bannï wa mati zë o'dɔnnï, yandinnï ne yada mo zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Here vïdï kayo ëdï tayinnï ehe ëdï tï'bënnï, here Yësu vo lïtu 'bënï ëtï, i'jannï kadra 'ba zi wakonyo dë. Here mo iya zi zë henye, “Ënyï dï'bë'e 'de bi maako na bi de ze kutu ze aba, zi ye re 'e lawo tisi.” ");
INSERT INTO mgc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Here zë ënyïnnï, ayetonnï tëkyï mï töŋbö tï'bë yaga na bi dë nnï bi mbiya maako. ");
INSERT INTO mgc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mati vïdï kayo ne'e ongɔnnï zë ëdïnnï atï'bë, kandi ayɔlɔnnï zë, here ënyï ï'bënnï biya tëmï gawo ne'e, ahonnï dagba ta dakaŋo, ɔkɔnnï dagba bi nani ta komo Yësu vo lïtu 'bënï ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mati Yësu asi yaga tëmï töŋbö, mo ongɔ vïdï kayo ne'e, di'di mo oso ndɔ na kö'du sösu ga kö'du zë, ga kö'du zë kaa tïmëlë ma kazi vo yako. Here mo ayeto zë yandi kö'du kyɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mati kadra omba ku zi loso, vo lö'bö 'bɔmo'e ayinnï zi mo iyannï henye, “Ongɔ te, kadra anza kpe bi nenye na möku. ");
INSERT INTO mgc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Utu vïdï nenye'e zi zë tï'bënnï mï liŋɔ mati ëdïnnï kpoko kinye zi zë wakonyo kogo zi konyo.” ");
INSERT INTO mgc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yësu aya'ba da me'do zi zë iya henye, “'E na bi de 'e, ï'dïye wakonyo zi zë zi konyo.” Zë ako'jonnï ha Yësu, “Kɔhi ne vïdï ako'dɔ lɔɔ yehwe modɔmowota zi ki'ja. Omba zi ze tï'bë yaŋa kɔhi lamirïyö ne da mangɔlɔ'bɔ zi tɔ'bɔ zë?” ");
INSERT INTO mgc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yësu ako'jo hë zë iya henye, “Ëdïye mangɔlɔ'bɔ aba ndö? Ï'bë'e te kongɔ.” Mati i'jannï, iyannï kö'du mo zi mo henye, “Mangɔlɔ'bɔ ëdï muyï, kyenze rïyö.” ");
INSERT INTO mgc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yësu iya zi vo lïtu 'bënïye zi kiya zi vïdï ne'e biya zi rë nnï kinye na gbɔngo gbɔngo, ma limannï akaŋo da loma kyekpe ne. ");
INSERT INTO mgc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Here vïdï ne'e biya alimannï na ratɔtɔ gbɔngo gbɔngo lamikölö maako'e 'butëmuyï. ");
INSERT INTO mgc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yësu oba mangɔlɔ'bɔ muyï ehe kyenze rïyö ne, ongɔ bi komorïyë, o'dɔ öwö'dï zi Wïrï. Mo owe mï mangɔlɔ'bɔ ne, ï'dï zi vo lö'bö 'bënïye zi yanya mo zi vïdïye. Mo inye mï kyenze rïyö ne kpa ta gë zë biya. ");
INSERT INTO mgc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vïdï biya onyonnï, ehe ɔvɔnnï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vo lö'bö'e atɔtɔnnï kɔsɔ mangɔlɔ'bɔ kyenze aba mati ɔsɔ ne mï baga 'butë dɔmorïyö. ");
INSERT INTO mgc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Watiti 'ba vïdï mati onyonnï wa ne kpulukumuyï. ");
INSERT INTO mgc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kandi Yësu ï'dï vo lö'bö'e tëkyïnnï mï töŋbö tï'bënnï dagba komo nï mï Beteseyida ta kafo föfö, mora here mo iya kö'du zi vïdï kayo ne'e mï'bënnï liŋɔ. ");
INSERT INTO mgc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ta ga kö'du kiya 'bɔmo zi vïdï kayo ne'e, ï'bë'e gbɔ, mo ënyï ï'bë da lutu amötu. ");
INSERT INTO mgc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mati hutaga ɔkɔ, töŋbö ëdï ku 'de mï kutë 'ba föfö, mora Yësu nje kutu nï aba da götï. ");
INSERT INTO mgc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mo ongɔ vo lö'bö 'bënïye ëdïnnï ku rë nnï kï'dï zi ko'dɔ mo ngari aba, ga kö'du ëdïnnï akopi ta ga bi tayi 'ba buluku. Kutë yɔndɔ aba mo ï'bë zi zë, lasi aba ta da wini. Mo omba zi laga ta da kapa zë, ");
INSERT INTO mgc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mora mati ongɔnnï mo ëdï alasi ta da wini ne, asösu 'bënnï iyannï wakoro ra, ehe a'bannï hë nnï gbögbö lörö aba. ");
INSERT INTO mgc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mati ongɔnnï mo ne, zë biya na tere. Mora Yësu ame'do zi zë kandi, iya henye, “Uku mï ye, ne ma ra. Ere'e dë.” ");
INSERT INTO mgc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Here mo ënyï ëkyï rë zë mï töŋbö ehe, buluku ɔrɔ. Vo lö'bö'e biya na rakaga, ");
INSERT INTO mgc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ga kö'du koro 'ba mangɔlɔ'bɔ mati mo o'dɔ zi vïdï kpulukumuyï konyo mo ne, ödu dë gba dë zë. ");
INSERT INTO mgc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zë ënyï umunnï kyëtï föfö da götï 'ba Genesereta, ehe idannï töŋbö ani. ");
INSERT INTO mgc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mati ilannï töŋbö ne, vïdï ayɔlɔnnï Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Here zë ënyï ahonnï ta bi ne biya. Ëzë owonnï bi mati mo ëdï 'dɔmo, ïnjënnï vïdï 'ba rakɔɔ'e da laŋba kika mo zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bi mati biya Yësu ï'bë ta 'dɔmo ne, mï gawo, mï daliŋɔ maako'e, vïdï ako'bannï zë mati na rakɔɔ ne, ga bi 'ba wakogo. Akalenzennï mo gbï nje zi zë ha bɔngɔ 'bɔmo kise, zë mati biya isennï ne, akɔ'jɔ zë na laka. ");
INSERT INTO mgc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Here Farasi maako'e nnï vo komoyandi 'ba kö'du kï'dï mati ayinnï ta Yerusalema ne, atɔtɔ rë nnï kpo da kapa Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Zë ongɔnnï kya 'ba vo lö'bö 'bɔmo maako'e ëdïnnï wakonyo kala aba na ti'da kazi kaka. ");
INSERT INTO mgc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasiye Yiserele'e ëtï onyonnï wa dë here, nje ëzë akaka kala nnï ku tëmï gërï 'ba 'bu nnïye. ");
INSERT INTO mgc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Zë onyonnï wa maako mati ayi ta bi 'ba wakogo, nje ëzë akakannï rɔ mo ku dagba. Ehe ïrïnnï ga ndï gërï kyɔ 'ba 'bu nnïye, kaa sikɔ kaka, kyere kaka, tele kaka aba. ");
INSERT INTO mgc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Here Farasiye vo kö'du kï'dï 'ba komoyandiye ëtï ako'jonnï ha Yësu, “Kö'du a'di vo lö'bö 'bëyïye ïrïnnï ga ndï kö'du yandi mati ï'dï zi ze akaŋo kazi 'bu ze dë, mora ëdïnnï wakonyo kala aba na ti'da.” ");
INSERT INTO mgc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yësu aya'ba da me'do zi zë, iya henye, “'E vïdï 'ba komokandi nenye, Yisaya ra ayɔlɔ kö'du kiya ga kö'du 'be'e, ayöru, iya henye, ‘Vïdï nenye'e oronnï ma, Yere Wïrï, nje hë nnï aba, mora di'di zë na kɔwɔ ta ra ma. ");
INSERT INTO mgc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mötu 'bëzë na yawa zi ma, kö'du yandi 'bëzë ayi nje kazi vïdïye.’ ");
INSERT INTO mgc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ï'dïye kö'du kï'dï 'ba Wïrï da kapa, ehe ɔwɔ'e kö'du yandi 'ba vïdï.” ");
INSERT INTO mgc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yësu zɔ nduwë, “Ëdïye gërï 'ba kö'du kï'dï 'ba Wïrï komba dë aba, ga kö'du zi ye kïrï kö'du yandi 'be'e ra. ");
INSERT INTO mgc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosa iya henye, ‘Oro 'bu yï ma yï aba, ëzë vïdï maako awili 'bu nï mandere ma nï, akï'dï mo zi kofo.’ ");
INSERT INTO mgc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mora ayandiye henye, Vïdï mati ëdï wa aba, zi kï'dï zi 'bu nï kɔnyi mandere ma nï, mora mo atɔ'bɔ kiya, ‘Nenye Korobani,’ kö'du ya'ba aba henye, ‘'ba Wïrï ra.’ ");
INSERT INTO mgc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ila'e mo dekpe zi kɔnyi 'bu nï mandere ma nï. ");
INSERT INTO mgc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mï ga gërï ne, kö'du yandi 'be'e zi vïdï maako'e ne, ayaŋa me'do 'ba Wïrï yaga. Wa maako'e ëdïnnï kpa kyɔ kaa ma nenye, mati ëdï ako'dɔ'e ne.” ");
INSERT INTO mgc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Here Yësu ako'jo vïdï kayo ne'e kpa löhu tayinnï zi nï, ehe iya zi zë henye, “'E biya, owo'e kö'du 'bama ne, ayɔlɔ'e. ");
INSERT INTO mgc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Waako anza dë zi tï'bë mï vïdï ta yaga ako'dɔ mo na ti'da. Wa mati asi yaga tëmï vïdï ra, ako'dɔ mo na ti'da.” ");
INSERT INTO mgc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mati mo ila vïdï kayo ne'e, ï'bë ödu loko ne, vo lö'bö 'bɔmo'e ako'jonnï hɔ mo zi mï me'do ne yada. ");
INSERT INTO mgc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yësu iya zi zë, henye, “Anza'e dë na ngaṛa ta da oka'e. Ayɔlɔ'e dë? Waako anza dë mati atï'bë mï vïdï ta yaga ako'dɔ mo na ti'da, ");
INSERT INTO mgc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ga kö'du anza dë tï'bë mï di'di mo, mora mï mo, ehe atï'bë zɔ dagba yaga tëmï ida ra.” Mï me'do ne, Yësu adɔrɔ gɔ mo zi zë wakonyo biya ŋbala zi konyo. ");
INSERT INTO mgc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mo zɔ nduwë kiya mo henye, “Ëdï wa mati asi yaga tëmï vïdï ra, ako'dɔ mo na ti'da. ");
INSERT INTO mgc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tëmï di'di 'ba vïdï atayi kö'du sösu kyënyë, rönyï, wa logo, wa kofo, ndoro, ");
INSERT INTO mgc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mï kumbë, wa kyënyë, wa ko'ba, rakïsï, gu kï'dï, ru vïdï yaŋa, da kumbë, rakonza. ");
INSERT INTO mgc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wa biya na kyënyë nenye'e ayinnï ta dïdï vïdï, ehe o'dɔ mo na ti'da.” ");
INSERT INTO mgc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Here Yësu ënyï ï'bë bi, mati kara ra gawo kyedre 'ba Tiyere. Mo ënyï ï'bë ödu loko ehe omba dë zi vïdï kölö maako zi yɔlɔ zi kiya nëdï ani. Mora mo ɔ'bɔ dë zi lima na rakoho. ");
INSERT INTO mgc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mbara mati wu'jë 'bɔmo ëdï dakyikyi aba ne, owo kö'du Yësu, ayi zi mo kandi, alëpï akaŋo ndï mo. ");
INSERT INTO mgc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mbara ne ame'do ha Gïrïgï, o'jo mo mï Siriya-Ponisiya. Mo alenze Yësu zi dakyikyi kore mo yaga ta ra wu'jë ënï. ");
INSERT INTO mgc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mora Yësu aya'ba da me'do iya henye, “Dï'dïye wakonyo dero dagba zi gisisiye. Anza na laka zi wakonyo 'ba gisisiye koba ku'du mo zi wïhïye.” ");
INSERT INTO mgc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mo aya'ba da me'do zi mo iya henye, “Kyedre, wïhï mati alimannï hu tarabiza ne, ëdïnnï kpa kɔsɔ wakonyo 'ba gisisiye mati ɔsɔ ne konyo.” ");
INSERT INTO mgc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Here Yësu iya zi mo henye, “Ga kö'du ya'ba nani, ï'bë hulëhu liŋɔ, akongɔ dakyikyi ne ï'bë ku yaga ta ra wu'jë 'bëyï ne.” ");
INSERT INTO mgc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mati mo ï'bë liŋɔ, i'ja wu'jë ënï ëdï ako'do da sora, dakyikyi ï'bë ku yaga ta rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yësu ënyï tëmï dakaŋo 'ba Tiyere ani, ï'bë nduwë kpuru tëmï Sidoni, kpa zi föfö 'ba Galilaya. Mo ï'bë ödu mï dakaŋo mati ëdï ako'jo Gawo 'Butë ne. ");
INSERT INTO mgc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kya vïdï maako'e ikannï kora vo mbili kïsï, mati ɔ'bɔ dë zi me'do, zë alenzennï Yësu zi kala nï kï'dï dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yësu oba mo kölö na kɔwɔ ta ra vïdï kayo ne'e, ï'dï da wisi kala nï mï mbili kora ne, o'bi oro, ise ndende kora ne gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yësu ongɔ bi komorïyë alawo na kyembe, iya zi kora ne henye, “Epata!” Kö'du ya'ba aba henye, “Ayëhu rïyë.” ");
INSERT INTO mgc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kandi kora ne ɔ'bɔ zi kö'du kowo. Mo ame'do kpa kazi riti. ");
INSERT INTO mgc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yësu ï'dï kö'du zi vïdï ne'e anza dë zi kö'du ne kiya zi vïdï ma kölö maako, mora zë nduwë kiya mo. ");
INSERT INTO mgc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vïdï biya mati owonnï kö'du ne, ëdïnnï na rakaga. Zë iyannï henye, “Hala mo o'dɔ wa biya na laka. Mo ï'dï vo mbili kïsï zi kö'du kowo, vïdï mati ɔ'bɔ dë zi me'do kpa ame'do.” ");
INSERT INTO mgc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kadra ma agamo aba, vïdï kayo maako'e ënyï atɔtɔ rë nnï, ayinnï ga bi kölö. Mati vïdï anzannï wa mati ɔsɔ aba zi konyo, Yësu ako'jo vo lö'bö 'bënïye zi nï, iya zi zë henye, ");
INSERT INTO mgc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Manza dë rakyenyi aba ga kö'du vïdï ne'e, ga kö'du zë ëdïnnï ma aba ko'do wota aba, mora yaanya aba wa anza dë zi konyo. ");
INSERT INTO mgc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ëzë mutu zë liŋɔ kazi wakonyo kï'dï zi zë, akatëdïnnï kazi kyigɔ ta bi tï'bë, ga kö'du kya maako'e ayinnï ta bi kɔwɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vo lö'bö 'bɔmo'e ako'jonnï hɔ mo iyannï henye, “Ta kila mï da lïpï nenye, zi vïdï maako zi tɔ'bɔ wakonyo ki'ja kyɔ zi kï'dï zi vïdï nenye'e?” ");
INSERT INTO mgc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yësu ako'jo hë zë iya henye, “Ëdïye mangɔlɔ'bɔ aba ndö?” Zë aya'bannï da me'do iyannï henye, “Mangɔlɔ'bɔ ëdï madɔmorïyö.” ");
INSERT INTO mgc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mo ï'dï kö'du zi vïdï ne'e zi limannï dakaŋo. Mo oba mangɔlɔ'bɔ madɔmorïyö ne'e, o'dɔ öwö'dï zi Wïrï, owe mï zë, ï'dï zi vo lö'bö 'bënïye zi yanya zi vïdï kayo ne'e. Vo lö'bö 'bɔmo'e o'dɔnnï gbɔ here. ");
INSERT INTO mgc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Zë ëdïnnï kpa kyenze sisiye aba. Yësu o'dɔ öwö'dï ga kö'du ma nenye'e, ayada zi vo lö'bö'e zi kyenze ne'e yanya mo kpa. ");
INSERT INTO mgc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vïdï biya mati onyonnï, ɔvɔnnï. Here vo lö'bö obannï kɔsɔ mo mati ɔsɔ ne, baga madɔmorïyö ndɔndɔ. ");
INSERT INTO mgc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vïdï ne ëdïnnï ani kaa kpulukusowɔ here. Here Yësu utu vïdï ne'e liŋɔ, ");
INSERT INTO mgc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ehe kandi ëkyïnnï mï töŋbö vo lö'bö 'bënï ëtï, ï'bënnï gbɔ mï dakaŋo 'ba Dalamonota. ");
INSERT INTO mgc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Here kya 'ba Farasiye ayinnï zi Yësu, ayetonnï hë nnï wasa mo aba. Zë ombannï zi Yësu yɔnzɔ, here ako'jonnï hɔ mo zi kö'du koro ko'dɔ zi yada mo ayi kazi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yësu otɔ lawo na konda, iya henye, “Kö'du a'di vïdï mï ko'do ma ndenye ne, ako'jonnï kö'du ga kö'du koro? E'e, mayada zi ye tïnyö, anza zi kö'du mahere ne, zi kï'dï zi vïdï nenye'e.” ");
INSERT INTO mgc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mo ila zë, ehe ëkyï mï töŋbö, umu gbɔ kyëtï 'ba föfö. ");
INSERT INTO mgc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Here vo lö'bö'e kö'du ölu tëmï zë zi koba mangɔlɔ'bɔ kyɔ, ëdï nje mangɔlɔ'bɔ kölö zë ëtï mï töŋbö. ");
INSERT INTO mgc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yësu iya zi zë henye, “Ongɔ'e re 'e laka kazi langa 'ba Farasi ne'e ehe langa 'ba Heroda.” ");
INSERT INTO mgc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Zë ayetonnï ame'do na ga rë nnï, “Mo iya kö'du ne ga kö'du danza dë mangɔlɔ'bɔ ako aba.” ");
INSERT INTO mgc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yësu ayɔlɔ kö'du a'di ëdïnnï ame'do gɔ mo, ako'jo hë zë, “Kö'du a'di ëdïye ame'do ga kö'du mangɔlɔ'bɔ anza dë? Ayɔlɔ'e dë gba? Di'diye na kyëndï? ");
INSERT INTO mgc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ëdïye komo'e aba ɔ'bɔ'e dë zi bi kongɔ? Ëdïye mbili aba ɔ'bɔ'e dë zi kö'du kowo? Ɔ'bɔ'e kö'du sösu dë? ");
INSERT INTO mgc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mati mowe mangɔlɔ'bɔ muyï kö'du zi vïdï kpulukumuyï ne'e, baga ëdï ndö na koso mati akö'du'e?” Zë aya'bannï da me'do, iyannï henye, “'Butë dɔmorïyö.” ");
INSERT INTO mgc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mora Yësu iya henye, “Mati mowe mangɔlɔ'bɔ madɔmorïyö zi vïdï kpulukusowɔ ne'e, baga ëdï ndö na koso mati akö'du'e?” Zë aya'bannï da me'do, iyannï henye, “Modɔmorïyö.” ");
INSERT INTO mgc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mo ako'jo hë zë iya henye, “Mora gba kö'du ne ayi dë de 'e?” ");
INSERT INTO mgc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mati zë ɔkɔnnï mï Beteseyida, vïdï maako'e ikannï kora vo komoköndu maako zi Yësu, alenzennï mo zi rɔ mo kise. ");
INSERT INTO mgc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yësu ïrï kala kora vo komoköndu ne, akɔkɔ mo, yaga tëmï liŋɔ. Tapëtï mati o'bi oro komo mo ne, Yësu ï'dï kala nï dɔ mo, ako'jo hɔ mo, “Atɔ'bɔ waako kongɔ?” ");
INSERT INTO mgc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Here kora ne ongɔ bi rïyë, iya henye, “Ɔɔ, mɔ'bɔ vïdï kongɔ, mora zë alayannï kaa kaga ra ëdïnnï alasi.” ");
INSERT INTO mgc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yësu ï'dï kala nï kpa löhu da komo kora ne. Here kora ne obe komo nï kyedre. Komo mo akɔ'jɔ rë nï, mo ɔ'bɔ gbɔ zi wasisi kongɔ biya na laka. ");
INSERT INTO mgc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yësu iya zi mo, “Ï'bë liŋɔ, ï'bë dë mï gawo.” ");
INSERT INTO mgc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yësu ënyï vo lö'bö 'bënï ëtï, ï'bënnï mï gawo 'ba Kasariya Filipo. Mati ëdï atï'bënnï ta da gërï ne, Yësu ako'jo hë zë iya henye, “Ayada'e zi ma, vïdï ëdïnnï akiya ma ëyï?” ");
INSERT INTO mgc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Here zë aya'bannï da me'do iyannï henye, “Maako'e iyannï yï Yowani Bapatisi ra, maako'e iyannï yï Eliya ra, agamo'e iyannï yï kölö tëmï kutë 'ba Nëbï ne'e.” ");
INSERT INTO mgc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mo ako'jo hë zë, “Mora 'e 'be'e? Iya 'be'e ma ëyï?” Petero ënyï aya'ba dɔ mo iya henye, “Yï Korisitɔ ra.” ");
INSERT INTO mgc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Here Yësu ï'dï kö'du zi zë, iya henye, “Ayada'e kö'du ma dë zi vïdï kölö maako.” ");
INSERT INTO mgc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Here Yësu ayeto vo lö'bö 'bënïye yandi, Wisi a vïdï atëdï riti kyedre aba, ehe vïdï kyedre, kyedre 'ba vo karasa'e, vo komoyandi 'ba kö'du kï'dïye akombannï mo dë. Akï'dïnnï mo zi kofo, mora ko'do da wota aba, mo atënyï na dïdï. ");
INSERT INTO mgc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yësu ayada kö'du mati ako'dɔ rë nï ne biya zi zë. Here Petero oba mo tisi da kapa, ehe mo iya zi mo kö'du 'bɔmo ne eme dë. ");
INSERT INTO mgc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mora here Yësu opi rë nï kpo, ongɔ bi da vo lö'bö 'bënïye ehe mo iya zi Petero henye, “Ënyï 'de ta ra ma karani Satani. Kö'du sösu 'bëyï ne ayi dë kazi Wïrï, 'ba vïdï ra.” ");
INSERT INTO mgc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mora Yësu ako'jo vïdï kayo ne'e vo lö'bö 'bënïye ëtï zi nï, ayada zi zë henye, “Ëzë vïdï maako omba zi tayi ma aba, kö'du mo mölu ta dɔ mo, mïnjë taka 'bënï, ma lö'bö ga ma. ");
INSERT INTO mgc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vïdï mati omba zi dïdï nï yɔmɔ, akayölu. Mora vïdï mati ayölu dïdï nï ku ga kö'du ma, ehe ga kö'du laka 'ba Wïrï, akayɔmɔ. ");
INSERT INTO mgc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ëzë vïdï maako i'ja wasisi biya mï damöku ne, mora mo ayölu lawo nï, anza dë na laka zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Waako atanza dë zi mo zi tɔ'bɔ zi kutrë lawo nï aba. ");
INSERT INTO mgc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ëzë vïdï maako ëdï na komokaya ta ra ma, ehe kö'du yandi 'bama mï damöku kyënyë ne, Wisi a Vïdï atëdï na komokaya ta rɔ mo, ëzë mo ayi mï bikanyi 'ba 'Bu nï malayika laka ëtï.” ");
INSERT INTO mgc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yësu iya zi zë henye, “Mayada zi ye tïnyö damöku 'ba Wïrï atayi, aki'ja'e maako'e gba oli ye dë.” ");
INSERT INTO mgc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tapëtï ko'do modaka aba, Yësu oba Petero, Yemisi, ehe Yowani, ï'bënnï da döku konda rïyë. Ani zë na bi dë nnï. Mati ëdïnnï nduwë bi kongɔ, rakopi ayi zi Yësu, ");
INSERT INTO mgc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ehe bɔngɔ 'bɔmo ëdï atanyi na kanyi, na kanyi ndra ta da vïdï ako mï dakaŋo nenye atɔ'bɔ kaka mo here. ");
INSERT INTO mgc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Here vo lö'bö wota ne'e ongɔnnï Eliya ehe Mosa ëdïnnï ame'do Yësu ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero ame'do zi Yësu, “Vo komoyandi, hala ëdï na laka zi ze tëdï kinye. Da kuvö ze loko wota, kölö zi yï, kölö zi Mosa ehe kölö zi Eliya.” ");
INSERT INTO mgc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mo oka nnï ëtï na tere, mo ayɔlɔ dë na kiya a'di. ");
INSERT INTO mgc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Here fɔli alaya ayöfu zë galïlï nï aba, gu ayi tëmï fɔli, “Nenye wisi ama ra.” ");
INSERT INTO mgc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zë ongɔnnï bi kandi gbö, mora 'de ongɔnnï vïdï ma kölö ako dë, nje Yësu zë ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mati zë asinnï ku akaŋo ta da döku, Yësu ise gɔ mo zi zë, “Wa mati ongɔ'e ne, ayada'e dë zi vïdï ma kölö maako, le ëzë Wisi a Vïdï ënyï ku tëmï koli.” ");
INSERT INTO mgc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Zë ɔwɔnnï kö'du kise 'bɔmo ne, mora tëmï kutë zë ayetonnï ame'do na ga rë nï ga kö'du ne, “A'di ra 'bënï tënyï tëmï koli?” ");
INSERT INTO mgc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zë ako'jonnï ha Yësu iyannï henye, “Kö'du a'di vo komoyandi 'ba vo kö'du kï'dïye iyannï Eliya ra atayi dagba?” ");
INSERT INTO mgc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kö'du ya'ba 'bɔmo ëdï henye, “Eliya ra tïnyö ëdï atayi dagba zi wasisi kɔ'jɔ nzɔ. Mora kö'du a'di Buku 'ba Wïrï iya nenye, Wisi 'ba Vïdï aki'ja riti ndra, ehe akomba mo dë? ");
INSERT INTO mgc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mayada zi ye hala Eliya ayi ku nzɔ, ehe vïdï o'dɔnnï mo kaa zë ombannï, kaa mati Buku iya kö'du ga kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mati zë adrɔko rë nnï kɔsɔ vo lö'bö ëtï, ongɔnnï vïdï kayo kpo ta rë nï ehe vo komoyandi 'ba vo kö'du kï'dïye, ëdïnnï me'do zë ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mati vïdï ne'e ongɔnnï Yësu, zë rakaga kyedre aba, ahonnï zi mo ehe amëtënnï mo. ");
INSERT INTO mgc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yësu ako'jo ha vo lïtu 'bënïye iya henye, “A'di ra ëdï me'do'e zë ëtï ga kö'du mo?” ");
INSERT INTO mgc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kora maako mï kutë vïdï kayo ne'e aya'ba da me'do henye, “Vo komoyandi, mika wisi ama zi yï, ga kö'du mo ëdï dakyikyi aba mï nï, ɔ'bɔ dë zi me'do. ");
INSERT INTO mgc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ëzë dakyikyi ne ënyï ku mo ko'dɔ, umë mo akaŋo, amo aba hë nï, hë nï konyo aba, atëdï seserese. Mako'jo ha vo lö'bö 'bëyïye zi dakyikyi ne kore mo yaga, mora zë ɔ'bɔnnï dë.” ");
INSERT INTO mgc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yësu iya zi zë henye, “'E vïdï oma'e dë. Hala ma kalima 'diri ëtï? Hala matëdï 'diri nduwë na mïkuku? Ika wisi ne zi ma.” ");
INSERT INTO mgc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ikannï mo zi Yësu. Kandi mati dakyikyi ne ongɔ Yësu, umë wisi ne tese aba, here mo alö'bö akaŋo, alulu gbö amo aba hë nï. ");
INSERT INTO mgc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yësu ako'jo ha 'bu mo iya henye, “Mo ëdï here ne, ndala aba?” Mo aya'ba iya henye, “Kyere mo gba na wisi tisi. ");
INSERT INTO mgc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Da kyɔ dakyikyi ne ëdï yɔnzɔ zi mo kofo, mo kumë aba mï wa'do ehe mï wini. Asösu kö'du ga kö'du ze, akɔnyi ze, ëzë akatɔ'bɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yësu alëzë iya henye, “Iya ‘Ëzë mɔ'bɔ'e,’ Wa biya akyigɔ dë zi vïdï mati ëdï koma aba.” ");
INSERT INTO mgc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Here kandi 'bu mo ënyï udu rïyë, “Mëdï koma aba, mora anza dë kyɔ. Akɔnyi ma zi tëdï mo aba kyɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Here Yësu ayɔlɔ vïdï kayo ne'e ëdïnnï ku tayi kara rë nï, here mo ï'dï kö'du zi dakyikyi ne. Mo iya henye, “Dakyikyi mati mbili kïsï ehe ha ngulu aba, mï'dï kö'du zi yï tasi yaga ta ra wisi ne, ehe ödu dekpe mï mo löhu.” ");
INSERT INTO mgc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Here dakyikyi ne udu, umë wisi ne tese aba na kyigɔ, asi gbɔ yaga. Wisi ne ongɔ bi kaa yöku vïdï, vïdï biya na kölö kölö iyannï henye, “Mo oli ku.” ");
INSERT INTO mgc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yësu oba wisi ne kala nï aba, akɔnyi mo zi tënyï, mo ɔrɔ gbɔ rïyë. ");
INSERT INTO mgc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tapëtï Yësu mati ödu loko, vo lö'bö 'bɔmo'e ako'jonnï hɔ mo mati zë na ga rë nnï, “Kö'du a'di dɔ'bɔ dë dakyikyi kore gɔ mo yaga?” ");
INSERT INTO mgc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yësu aya'ba da me'do iya henye, “Nje mötu ra atɔ'bɔ kyïnë nenye kore mo yaga, waako ɔ'bɔ dë.” ");
INSERT INTO mgc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Here Yësu vo lö'bö 'bënï ëtï ilannï bi nani ï'bënnï nduwë kpuru tëmï Galilaya. Yësu omba dë zi vïdï kölö maako zi yɔlɔ nëdï kila, ");
INSERT INTO mgc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ga kö'du mo ëdï vo lö'bö 'bënï ye yandi mo. Mo iya henye, “Wisi a Vïdï akï'dï zi vïdï maako'e, zë akofonnï mo. Ko'do da wota aba yaa, mo akaliro na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mora zë ayɔlɔnnï mï kö'du yandi ne dë, zë na tere ta bi hɔ mo ko'jo. ");
INSERT INTO mgc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Here zë ayinnï Kaparanamo. Tapëtï tï'bë 'bëzë loko, Yësu ako'jo ha vo lïtu 'bënïye, “Ëdïye ame'do da ga gërï ne ga kö'du a'di?” ");
INSERT INTO mgc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mora zë aya'bannï da me'do dë zi mo, ga kö'du da ga gërï ne zë ëdïnnï ame'do na ga rë nnï, ëyï ra 'bënï kyedre. ");
INSERT INTO mgc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yësu alima akaŋo, ako'jo vo lïtu 'butë dɔmorïyö ne'e, iya zi zë henye, “Mo mati omba zi tëdï dagba, maya'ba rë nï hulëhu ta da vïdï biya, mo mëdï na vo lïtu zi vïdï biya.” ");
INSERT INTO mgc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Here mo ïrï wisi kora ï'dï mo atɔrɔ da komo zë. Mo ï'dï kala nï kpo ta rɔ mo, iya zi zë henye, ");
INSERT INTO mgc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Vïdï mati ïrï wisi ma kölö tëmï gisisi nenye'e kalakyedre aba mï ru ma, mo ïrï ma kalakyedre aba. Vïdï mati ïrï ma kalakyedre aba, ïrï dë nje ma kalakyedre aba, mora mo mati utu ma ne kpa.” ");
INSERT INTO mgc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Here Yowani iya zi mo henye, “Vo komoyandi, dongɔ kora maako ëdï dakyikyi kore mo ru yï aba, dayada ze zi mo zi kila, ga kö'du mo anza dë mï gboko 'beze.” ");
INSERT INTO mgc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yësu ayada zi zë henye, “Ayɔnzɔ'e mo dɔrɔ dë, ga kö'du vïdï kölö maako mati ëdï kö'du koro ko'dɔ mï ru ma, akatɔ'bɔ dë kandi tapëtï mo kö'du kyënyë kiya ru ma aba. ");
INSERT INTO mgc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ga kö'du vïdï mati kö'du ko'dɔ 'bɔmo anza dë na kyënyë zi ze, mo 'beze. ");
INSERT INTO mgc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Miya zi ye tïnyö henye, vïdï maako mati ï'dï wini zi ye kuwë ga kö'du'e 'bama, aki'ja biriti rë nï.” ");
INSERT INTO mgc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ëzë vïdï ma o'dɔ kö'du zi wisi tisi ma kölö nenye'e zi kö'du kyënyë ko'dɔ mati oma mï ma, atëdï na laka zi vïdï nani zi tëdï yïtö kyedre kida aba kpo ta gu nï ehe ku'du mo mï ranga. ");
INSERT INTO mgc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Here ëzë kala yï o'dɔ yï zi kö'du kyënyë ko'dɔ, ikye yaga. Ëdï na laka zi yï lima kazi kala, ta da kala sesi mo 'dö rïyö tï'bë mo aba mï gehena mati inde rë nï dë. ");
INSERT INTO mgc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ëzë ndï yï o'dɔ yï zi kö'du kyënyë ko'dɔ, ikye yaga. Ëdï na laka zi yï lima kazi ndï, ta da ndï sesi mo 'dö rïyö tï'bë mo aba mï gehena mati inde rë nï dë. ");
INSERT INTO mgc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ëzë komo yï o'dɔ yï zi kö'du kyënyë ko'dɔ, oba yaga. Ëdï na laka zi yï tödu Damöku 'ba Wïrï komo kölö aba, ta da komo sesi mo 'dö rïyö tï'bë mo aba mï gehena, ");
INSERT INTO mgc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","mati ‘kuru oli dë, ehe wa'do inde rë nï dë.’” ");
INSERT INTO mgc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Vïdï na kölö kölö akakɔ'jɔ wa'do aba kaa wakumu ëdï akɔ'jɔ yɔ'dɔ aba. ");
INSERT INTO mgc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yɔ'dɔ ëdï laka, mora ëzë ayaŋa yɔkɔ nï ku, hala atɔ'bɔ ko'dɔ zi yɔkɔ löhu? Ëdïye yɔ'dɔ 'ba aboka aba mï kutë'e, ehe alima'e mï rakyëyï oka ma kölö maako aba.” ");
INSERT INTO mgc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Here Yësu ila bi nani, ënyï ï'bë mï dakaŋo 'ba Yudiya, ehe umu da ranga 'ba Yeredene. Vïdï ayinnï na kayo zi mo löhu, mo ayandi zë kaa mati mo ëdï 'duwï ako'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Here kya 'ba Farasiye ayinnï zi mo, ayɔnzɔnnï zi mo kuyï. Zë ako'jonnï hɔ mo iyannï henye, “Ayada te zi ze, kö'du kï'dï 'beze akila vïdï zi mbara 'bënï yëyï?” ");
INSERT INTO mgc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yësu aya'ba dɔ mo tëmï kö'du ko'jo iya henye, “Kö'du kï'dï a'di ra Mosa ï'dï zi ye?” ");
INSERT INTO mgc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Da kö'du ya'ba 'bëzë ëdï henye, “Mosa ï'dï dangölö zi vïdï waraga 'ba rayëyï yöru, ehe kore mbara 'bënï 'de.” ");
INSERT INTO mgc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yësu iya zi zë henye, “Mosa ayöru kö'du kï'dï ne here zi ye, ga kö'du de 'e na kyigɔ zi yandi. ");
INSERT INTO mgc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mora biyeto aba, mï kadra nani mati bi o'dɔ rë nï, Wïrï ï'dï kora mbara aba. ");
INSERT INTO mgc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mora ga kö'du nenye, kora akila 'bu nï ma nï, aba akadrɔko rë nnï mbara 'bënï aba, ");
INSERT INTO mgc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ehe zë rïyö ne, ata'bannï na wa kölö. ");
INSERT INTO mgc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Inye'e dë wa mati Wïrï adrɔko ku bi kölö ne.” ");
INSERT INTO mgc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mati zë a'bannï löhu hulëhu loko, vo lö'bö'e ako'jonnï ha Yësu ga kö'du ne. ");
INSERT INTO mgc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Here mo iya zi zë henye, “Kora mati ayëyï mbara 'bënï ehe oze mbara vere, mo o'dɔ ndoro ta da mbara 'bënï. ");
INSERT INTO mgc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mï ga gërï kölö ne, mbara mati ayëyï kora 'bënï, ehe oze kora vere, ne o'dɔ ndoro.” ");
INSERT INTO mgc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Here kya vïdï maako'e ikannï gisisiye zi Yësu, ga kö'du zi mo kala nï kï'dï dë zë, mora vo lö'bö'e amonnï vïdï ne ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mati Yësu ayɔlɔ kö'du nenye, mo na kamo ehe iya zi vo lö'bö 'bënïye henye, “Ila'e gisisiye 'bayinnï zi ma, ayata'e zë dë, ga kö'du damöku 'ba Wïrï ne ëdï kö'du zë kaa ma nenye'e. ");
INSERT INTO mgc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Miya zi ye henye, mo mati ïrï damöku 'ba Wïrï dë kaa wisi tisi, ödu dë mï mo.” ");
INSERT INTO mgc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Here mo ïrï gisisiye hu förö nï, ï'dï kala nï dë zë, ehe ï'dï ya'da zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mora kaa Yësu ayeto ku da gërï 'bënï löhu, kora maako aho alɔdrɔ da komo mo, ako'jo hɔ mo iya henye, “Vo komoyandi laka, mako'dɔ a'di zi ma dïdï ma ŋburu ki'ja?” ");
INSERT INTO mgc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yësu ako'jo hɔ mo iya henye, “Kö'du a'di ako'jo ma na laka? Vïdï maako anza na laka, nje kölö Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ayɔlɔ kö'du kï'dï ne'e ku. Ofo vïdï dë, o'dɔ ndoro dë, alogo dë, asusu vïdï maako dë na ndɔndɔ, o'ba vïdï dë, ɔwɔ 'bu yï ma yï aba.” ");
INSERT INTO mgc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kora ne iya henye, “Vo komoyandi, kyere ma gba na ɔbi, mɔwɔ kö'du kï'dï ne biya.” ");
INSERT INTO mgc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Here Yësu ongɔ bi mbïyï dɔ mo lɔvɔ aba, iya henye, “O'dɔ wa kölö dë gba. Ï'bë, ogo wa mati ëdï mo aba ne biya, ï'dï kɔhi mo zi vo leriye, atëdï wa aba kyɔ komorïyë, ayi alö'bö ga ndï ma.” ");
INSERT INTO mgc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mati kora ne owo kö'du ne, biköndu apere rë nï ta komo mo, ehe ï'bë 'de na rasösu, ga kö'du mo na vo wakayɔ. ");
INSERT INTO mgc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yësu ongɔ bi kpo da vo lö'bö 'bënïye, iya zi zë henye, “Atëdï na kyigɔ zi vïdï 'ba wakayɔ aba zi tödu mï damöku 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mora here, vo lö'bö'e na rakaga mï me'do ne. Mora Yësu ï'bë nduwë kiya mo aba henye, “Gisi ama'e, ëdï na kyigɔ zi tödu damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Atëdï na kyigɔ ndra zi vïdï 'ba wakayɔ aba zi tödu mï damöku 'ba Wïrï, ta da jemele zi tï'bë kpuru ta komo wogo 'ba ibira.” ");
INSERT INTO mgc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mora here ne, vo lö'bö'e rakaga aba ndra, ako'jonnï oka maako, “Mora here ne, ëyï ra atɔ'bɔ yɔmɔ?” ");
INSERT INTO mgc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yësu ongɔ bi mbïyï dë zë, aya'ba dɔ mo henye, “Nenye wa mati vïdï ɔ'bɔ dë ko'dɔ mo, mora anza dë na kyigɔ zi Wïrï. Wïrï atɔ'bɔ wasisi ko'dɔ mo biya.” ");
INSERT INTO mgc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Here Petero ame'do rïyë, “Ongɔ te, dila wasisi ku biya, da'ba dalö'bö ku gë yï.” ");
INSERT INTO mgc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yësu alëzë ɔɔ, iya zi zë henye, “Mayada zi ye henye, vïdï maako mo ila liŋɔ, mandere öndu'e, mandere ëmïye, mandere ma'e, mandere 'bu'e, mandere gisisiye mandere yaka'e, ga kö'du ma, ehe ga kö'du yöyö laka, ");
INSERT INTO mgc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mo aki'ja ndra mï ko'do ma ndenye ne. Mo aki'ja loko lami da kyɔ, öndu'e, ëmïye, ma'e, gisisiye, yaka'e, ehe riti kpa. Mï ko'do mati atayi ne, mo aki'ja dïdï ŋburu. ");
INSERT INTO mgc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mora vïdï kyɔ mati dagba ne, atëdïnnï hulëhu, ehe vïdï kyɔ mati hulëhu ne, atëdïnnï dagba.” ");
INSERT INTO mgc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yësu vo lö'bö 'bënï ëtï, yaanya aba ëdïnnï ku da ga gërï mati ï'bë le mï Yerusalema. Yësu ëdï atï'bë dagba komo vo lö'bö'e. Zë ndɔ na rakaga. Vïdï mati alö'bö 'bënnï hulëhu ne, na tere. Da kölö löhu Yësu oba vo lïtu 'butë dɔmorïyö ne'e dakapa, ame'do kö'du wa mati ako'dɔ rë nï zi nï. Mo iya zi zë henye, ");
INSERT INTO mgc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Owo'e te, dëdï tï'bë'e le mï Yerusalema, ani Wisi a Vïdï akï'dï zi kyedre 'ba vo karasa'e ehe vo komoyandi 'ba kö'du kï'dïye. Zë akombannï da kö'du zi mo kofo, akï'dï mo zi vo leze'e, ");
INSERT INTO mgc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","mati ako'dɔnnï wari rɔ mo, ko'binnï oro rɔ mo, aku'bönnï hu mo, ehe akofonnï mo. Mora ko'do da wota aba, mo atënyï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Here Yemisi nnï Yowani aba zë gisi 'ba Zebedeyo, ayinnï zi Yësu, iyannï henye, “Vo komoyandi, waako ëdï ani domba zi yï ko'dɔ mo zi ze.” ");
INSERT INTO mgc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yësu ako'jo hë zë iyannï henye, “A'di ra here?” ");
INSERT INTO mgc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Zë aya'bannï da me'do iya henye, “Ëzë alima ku da kyïtï 'ba bikanyi kyedre 'ba damöku 'bëyï, domba yï zi kila ze lima yï aba, ma kölö da kala yï ma tïrï, ehe ma kölö da kala yï ma gali.” ");
INSERT INTO mgc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yësu iya zi zë henye, “Ayɔlɔ'e dë, a'di ra ëdïye kö'du ko'jo gɔ mo. Akatɔ'bɔ'e köfö 'ba riti mati makuwë ne? Akatɔ'bɔ'e bapatisi tëmï gërï mati abapatisi ma?” ");
INSERT INTO mgc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aya'bannï da me'do henye, “Dakatɔ'bɔ.” Yësu iya zi zë henye, “Akuwë'e köfö mati makuwë, ehe akabapatisiye tëmï gërï mati abapatisi ma. ");
INSERT INTO mgc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mora mo'bɔ dë zi vïdï maako kinzi, ëyï ra akalima da kala ma ma tïrï, ehe da kala ma ma gali. Wïrï ra akï'dï bi nenye'e zi zë mati mo akɔ'jɔ ga kö'du zë.” ");
INSERT INTO mgc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mati kya 'ba vo lïtu'e 'butë owonnï kö'du ne, zë na kamo kazi Yemisi Yowani aba. ");
INSERT INTO mgc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Here Yësu ako'jo zë biya zi nï ga bi kölö, iya zi zë henye, “Ayɔlɔ'e ku here, yere 'ba vo leze'e ëdïnnï yere kyigɔ'e kalakonda aba. ");
INSERT INTO mgc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nenye anza dë gërï mati ëdï mï kutë'e. Ëzë vïdï ma kölö tëmïye omba zi nï tëdï na kyedre, mo mëdï na vo kalima zi oka'e, ");
INSERT INTO mgc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ehe vïdï ma kölö tëmïye omba zi nï tëdï dagba, mo mëdï na vo kalima zi oka'e biya. ");
INSERT INTO mgc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Here Wisi 'ba Vïdï ayi dë zi vïdïye lɔɔ ko'dɔ zi mo, mo ra ayi zi ko'dɔ, ehe zi dïdï nï kï'dï zi vïdï kayo yɔmɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Here zë ayinnï mï Yerïkö. Mati Yësu ila gawo vo lö'bö 'bënïye ëtï ehe vïdï kayo ëtï, vo komoköndu ru mo Baratamoya, Wisi 'ba Tomasi, ëdï alima da kapa gërï. ");
INSERT INTO mgc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mati mo owo henye Yësu 'ba Nazereta ra, mo ayeto hë nï gbögbö, “Yësu Wisi 'ba Dawidi akɔnyi ma.” ");
INSERT INTO mgc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vïdï kayo ne'e ënyïnnï mo aba na kamo, iyannï zi mo zi lima ti. Mora mo agbögbö hë nï gbɔ ndra rïyë, “Wisi 'ba Dawidi akɔnyi ma.” ");
INSERT INTO mgc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Here Yësu ɔrɔ, iya henye, “Ako'jo mo.” Here zë ako'jonnï kora vo komoköndu ne gbɔ. Zë iyannï henye, “Ëdï rakyenyi aba, ënyï rïyë, mo ëdï yï ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mo umë bɔngɔ 'bënï 'de, öfu rïyë, ayi zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yësu ako'jo hɔ mo, “A'di ra omba zi ma zi ko'dɔ zi yï?” Kora vo komoköndu ne, aya'ba da me'do henye, “Vo komoyandi, momba zi bi kongɔ löhu.” ");
INSERT INTO mgc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yësu iya zi mo, “Ï'bë, kö'du koma 'bëyï akɔ'jɔ yï ku.” Kandi mo ɔ'bɔ zi bi kongɔ, alö'bö gbɔ ga Yësu da gërï. ");
INSERT INTO mgc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mati zë ëdïnnï ku tɔkɔ Yerusalema, kara ra gawo 'ba Betehege ehe Beteniya, zë ayinnï da Döku 'ba Olivo. Yësu utu vo lö'bö 'bënïye rïyö dagba kö'du zi wa maako ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Yësu iya zi vo lö'bö'e henye, “Ï'bë'e zi daliŋɔ mati ëdï dagba komo'e. Ëzë kandi ɔkɔ'e ku ani, aki'ja'e wisi makakya na kida aho dë gba dɔ mo, inga'e, ika'e kinye. ");
INSERT INTO mgc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ëzë vïdï maako ako'jo he'e kö'du a'di ëdïye mokakya ne koba gɔ mo, ayada'e zi mo Yere ra omba, mo akaya'ba hulëhu kandi.” ");
INSERT INTO mgc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Here zë ï'bënnï, i'jannï wisi makakya yaga da ga gërï, na kida kara ha loko. Mati zë ëdïnnï akinga, ");
INSERT INTO mgc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kya 'ba vïdï mati ëdïnnï atɔrɔ dakapa ne, ako'jonnï hë zë henye, “Ëdïye a'di ko'dɔ here? Kö'du a'di ëdïye makakya ne kinga gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Here zë aya'bannï da me'do kaa mati Yësu ayada zi zë, here vïdï ne'e ilannï zë gbɔ atï'bë. ");
INSERT INTO mgc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Zë ikannï makakya ne zi Yësu, umënnï bɔngɔ 'bënnï da ngötu ne, Yësu ëkyï gbɔ dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vïdï kayo o'bannï bɔngɔ 'bënnï da ga gërï, mora agamo'e ikye 'bënnï mbila kaga mati mï yaka ne, o'bannï da ga gërï. ");
INSERT INTO mgc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Here vïdï mati ëdïnnï dagba ne, ehe vïdï mati alö'bö 'bënnï hulëhu ne, ayeto hë nnï gbögbö, “Wayeto zi Wïrï, Wïrï mï'dï ya'da zi mo mati ayi mï ru 'ba Yere. ");
INSERT INTO mgc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wïrï mï'dï ya'da zi damöku 'ba Yere Dawidi 'bu ze, mati ëdï atayi ne. Wayeto zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mati Yësu ödu mï Yerusalema, ï'bë mï yëkëlu, ongɔ bi kpo ta da wasisi ne, mo ï'bë vo lïtu ma 'butë dɔmorïyö ne ëtï mï Beteniya kö'du kadra anza dekpe. ");
INSERT INTO mgc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mï ko'do ma ta gɔ mo zë ëdïnnï ata'ba hulëhu tëmï Beteniya, Yësu na o'bo. ");
INSERT INTO mgc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mo ongɔ kaga kyëlu ta bi kɔwɔ ayöfu dɔ mo mbili yëyü aba. Here mo ï'bë akongɔ kɔdɔ na katɔ'bɔ ki'ja kɔlɔ dɔ mo. Mora mati mo ayi zi mo ani, mo i'ja nje mbili yëyu, ga kö'du anza kadra ma laka 'ba kyëlu zi tövu. ");
INSERT INTO mgc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yësu iya zi kaga kyëlu ne henye, “Vïdï kölö maako onyo kɔlɔ dekpe kazi yï löhu.” ");
INSERT INTO mgc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mati ɔkɔnnï mï Yerusalema, Yësu ï'bë ödu mï yëkëlu, ayeto vïdï mati ëdïnnï wakogo ne kore mo biya yaga. Mo adu'du tarabiza 'ba vïdï mati ëdïnnï kɔhi kutrë, ehe gba'da 'ba vïdï mati ëdïnnï atu'bu kogo ne kaŋo. ");
INSERT INTO mgc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mo omba dë zi vïdï kölö maako kumbë wa maako kpuru tasi mo aba yaga tëmï yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Here mo ayandi vïdïye iya henye, “Ëdï na yöru Wïrï iya henye, ‘Yëkëlu 'bama ne akako'jo loko 'ba mötu zi tu'dë'e biya,’ mora ofɔ'e ku na bi 'ba rakoho 'ba vo logo'e.” ");
INSERT INTO mgc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kyedre 'ba vo karasa, ehe vo komoyandi 'ba kö'du kï'dïye owonnï kö'du ne here, ayetonnï gërï maako koma zi Yësu kofo. Zë na tere kazi mo, ga kö'du vïdï kayo ne'e biya na rakaga tëmï kö'du yandi 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mati hutaga ɔkɔ, Yësu vo lïtu 'bënï ëtï, ï'bënnï 'de tëmï gawo nani. ");
INSERT INTO mgc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mï da mïndö vere 'do ŋbɔ, zë ëdïnnï atï'bë ta da gërï, ongɔnnï kaga kyëlu ne, oli ku ta rïyë le ngara'da nï aba akaŋo. ");
INSERT INTO mgc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero asösu kö'du mati o'dɔ rë nï ne, ehe iya zi Yësu henye, “Ongɔ te, vo komoyandi, kaga kyëlu mati asënë ne, oli ku.” ");
INSERT INTO mgc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yësu aya'ba dɔ mo zi zë iya henye, “Ëdïye kö'du koma aba mï Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Miya tïnyö zi ye henye, mo mati ayada kö'du zi lutu nenye tënyï rïyë ehe rë nï kumë mï ranga, dɔ mo anza dë jiri jiri, mora oma mï kö'du mati mo iya ne, ako'dɔ rë nï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ga kö'du ne mayada zi ye, ëzë amötu'e, ehe ako'jo'e kö'du wa, oma aki'ja, akï'dï wa mati ako'jo kö'du gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ëzë ɔrɔ rïyë amötu, ila kö'du sisi mati ïrï ra vïdï maako, here 'Bu yï komorïyë akila kö'du kyënyë mati o'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zë ɔkɔnnï kpa löhu mï Yerusalema. Mati Yësu ëdï alasi mï yëkëlu, kyedre 'ba vo karasa'e, vo komoyandi 'ba vo kö'du kï'dïye, ehe vïdï kyedre'e ayinnï zi mo ");
INSERT INTO mgc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ako'jonnï hɔ mo iyannï henye, “Ayada zi ze, kalakonda 'ba a'di ra ëdï kö'du nenye'e ko'dɔ mo aba? Ëyï ra ï'dï kalakonda ne zi yï?” ");
INSERT INTO mgc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yësu aya'ba dɔ mo zi zë iya henye, “Ma kako'jo he'e nje kö'du ko'jo kölö aba. Ëzë aya'ba'e da kö'du ko'jo ne ku, makayada zi ye kalakonda 'bëyï ra mëdï kö'du nenye'e ko'dɔ mo aba. ");
INSERT INTO mgc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ayada'e zi ma, kalakonda 'ba Yowani mati ëdï vïdï bapatisi mo aba ne ayi ta kila, kazi Wïrï kɔdɔ kazi vïdï?” ");
INSERT INTO mgc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Zë ayetonnï hë nnï wasa na ga rë nnï iyannï henye, “Dakiya ze a'di? Ëzë daya'ba'e dɔ mo, diya'e ‘Ayi kazi Wïrï,’ mo akiya henye, ‘Kö'du a'di oma'e dë mï Yowani?’ ");
INSERT INTO mgc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mora ëzë diya ‘Ayi kazi vïdï....’” Zë erennï vïdïye ga kö'du vïdï biya na kölö kölö omannï mï Yowani, iyannï mo Nëbï ra. ");
INSERT INTO mgc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Here da me'do ya'ba 'bëzë zi Yësu ëdï henye, “Dayɔlɔ dë.” Yësu iya zi zë henye, “Makayada dë zi ye, kalakonda 'ba a'di ra mëdï kö'du nenye'e ko'dɔ mo aba.” ");
INSERT INTO mgc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Here Yësu ame'do zi zë tëmï mala. “Kora maako ëdï ani, isi yaka o'dɔ resi kpo ta rɔ mo, akɔ'jɔ bi zi nyenyo ku'bö dɔ mo, o'ba loko tɔrɔ 'ba zi bi kongɔ. Mo ila yaka ne zi vo lɔɔ ko'dɔ'e, ï'bë gbɔ bi yingɔ. ");
INSERT INTO mgc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mati kadra 'ba nyenyo kumu ɔkɔ ku, mo utu vo kalima 'bënï zi vo lɔɔ ko'dɔ ne'e, zi kïrï kazi zë mï 'bënï tëmï yaka. ");
INSERT INTO mgc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Here vo lɔɔ ne'e ïrïnnï vo lïtu ne u'bönnï mo, utunnï mo hulëhu kazi wa maako. ");
INSERT INTO mgc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Here vo kyeti yaka utu vo kalima ma agamo, vo lɔɔ ko'dɔ'e u'bönnï mo dɔ mo, ï'dïnnï komokaya dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Vo kyeti yaka utu vo kalima ma agamo, ofonnï mo. Mo utu zë kyɔ, ehe zë u'bönnï maako'e, ofonnï maako'e.” ");
INSERT INTO mgc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kɔsɔ mo kölö mati ɔsɔ zi kutu, nje gogo wisi 'ba kora ne. Ndundu mo aba biya, mo utu wisi 'bënï zi vo lɔɔ'e. Mo iya henye, ‘Mayɔlɔ ku zë atɔwɔnnï wisi ama.’ ");
INSERT INTO mgc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mora vo lɔɔ nenye'e iyannï zi oka maako, ‘Nenye wisi 'ba vo yaka ra. Ayiye, dofo'e mo, wasisi 'bɔmo ne'e, atëdï 'beze.’ ");
INSERT INTO mgc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Here zë ïrïnnï wisi ne, ofonnï mo, u'dunnï yöku mo yaga tëmï yaka.” ");
INSERT INTO mgc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yësu ako'jo kö'du iya henye, “A'di ra vo kyeti yaka ne ako'dɔ? Mo atayi akofo vo lɔɔ ne'e, akï'dï yaka ne zi vo lɔɔ maako'e. ");
INSERT INTO mgc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ako'jo'e kö'du yöru nenye ku. ‘Yïtö mati vo wa ko'ba'e ombannï dë, opi rë nï ku na ṛï'dï ma laka. ");
INSERT INTO mgc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nenye Yere ra o'dɔ, ëdï na rakaga zi ze.’” ");
INSERT INTO mgc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Here vo dagba 'ba Yuda'e ayɔnzɔnnï zi Yësu kïrï, ga kö'du ze ayɔlɔnnï mo ëdï mala ne yada kö'du 'bënnï. Mora zë na tere kazi vïdï kayo ne'e, here zë ilannï mo ï'bë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yaa, zë utunnï kya 'ba Farasi maako'e, kya 'ba Heroda'e zi Yësu kïrï kö'du me'do hɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Zë ayinnï zi mo iyannï henye, “Vo komoyandi, dayɔlɔ ku yï kora mati ëdï kö'du tïnyö ra yada. Vïdï maako o'ba yï dë, ga kö'du omba da me'do 'beze dë. Mora ëdï kö'du gërï 'ba Wïrï ra yandi tïnyö. Ëdï laka zi 'be'bele kopi zi Yere Siza kɔdɔ anza here dë?” ");
INSERT INTO mgc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mora here Yësu ongɔ bi kpuru tëmï kö'du yɔnzɔ 'bëzë ne, aya'ba dɔ mo iya henye, “Kö'du a'di ëdïye re 'e kï'dï zi ma kuyï? Ika'e kɔhi ŋbiriṛi ne mongɔ te.” ");
INSERT INTO mgc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Zë ikannï zi mo kölö, mo ako'jo hë zë iya henye, “Komo ëyï ra ru mo aba nenye?” Zë aya'bannï, iyannï henye, 'ba Yere Siza ra. ");
INSERT INTO mgc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Here Yësu iya henye, “Laka ï'dïye zi Yere Siza wa mati 'ba Yere Siza, ehe ï'dïye zi Wïrï wa mati 'ba Wïrï.” Zë na rakaga kazi Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Here kya Sadeke maako'e mati ëdïnnï akiya vïdï ënyï dë tëmï koli ne, ayinnï zi Yësu iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Vo komoyandi, Mosa ayöru kö'du kï'dï ne zi ze, iya henye, ‘Ëzë kora mati mbara aba oli ila mbara ne kazi wisi, öndu 'ba kora ne moze mbara lu'bë ne ga kö'du zi zë gisisi ko'jo mï ru 'ba öndu mati oli ne.’” ");
INSERT INTO mgc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Here gisi öndu'e ëdïnnï madɔmorïyö. Ma kyedre oze mbara ehe oli 'de kazi wisi ko'jo. ");
INSERT INTO mgc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mora öndu ma rïyö mo oze mbara ne, ehe mo oli kpa 'de kazi wisi ko'jo. Kö'du ne o'dɔ rë nï kpa zi öndu ma wota mo. ");
INSERT INTO mgc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mora zɔ zi kɔsɔ mo ne'e. Gisi öndu madɔmorïyö ne'e biya ozennï mbara ne, ehe olinnï kazi gisi ko'jo. Ndundu mo aba mbara ne oli gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yaanya aba, ëzë vïdï mati olinnï, ënyïnnï ku na dïdï mï ko'do 'ba tënyï tëmï koli aba, mo atëdï 'bënï na mbara 'bëyï? Zë madɔmorïyö ne biya ozennï mo.” ");
INSERT INTO mgc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yësu aya'ba da me'do zi zë iya henye, “Kö'du a'di o'dɔ'e kö'du lïtë ne gɔ mo? Ëdï ga kö'du ayɔlɔ'e dë, a'di ra kö'du yöru iya? Kɔdɔ ayɔlɔ we'e kyigɔ 'ba Wïrï dë? ");
INSERT INTO mgc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ga kö'du ëzë vïdï mati olinnï ne ënyïnnï ku na dïdï, atëdïnnï kaa malayika'e komorïyë rakoze anza kpe. ");
INSERT INTO mgc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yaanya aba ne ga kö'du 'ba yöku zi tënyï ne, ako'jo'e dë tëmï Buku mati Mosa ayöru kö'du möku lɔ'bɔ? Ëdï na yöru ani, Wïrï iya zi Mosa henye, ‘Ma Wïrï 'ba Abarayama, Wïrï 'ba Yisika ehe Wïrï 'ba Yakoba.’ ");
INSERT INTO mgc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mo Wïrï 'ba dïdï anza dë 'ba koli. Alïtë'e kö'du ku!” ");
INSERT INTO mgc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Here vo komoyandi 'ba kö'du kï'dï ëdï ani, mo owo me'do ne gbɔ. Mo ongɔ Yësu ï'dï da me'do ya'ba laka zi Sadeke'e, here mo ayi zi mo, kö'du ko'jo aba. “Kö'du kï'dï ma vala ra ëdï na laka ndra, ta dë zë biya?” ");
INSERT INTO mgc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yësu aya'ba dɔ mo iya henye, “Ma kölö ma laka ndra ëdï henye, ‘Owo'e kö'du Yiserele, Yere Wïrï 'beze nje Yere kölö. ");
INSERT INTO mgc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ï'dï lɔvɔ Yere Wïrï 'bëyï di'di yï aba biya, lawo yï aba biya, dë yï aba biya, ehe biya kyigɔ 'bëyï aba.’ ");
INSERT INTO mgc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kö'du kï'dï ma rïyö ma laka ndra ëdï henye, ‘O'dɔ lɔvɔ vo haliŋɔ oka kaa mati o'dɔ lɔvɔ yï.’ Kö'du kï'dï ako ndra ta da ma rïyö nenye'e anza dë.” ");
INSERT INTO mgc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Vo komoyandi 'ba kö'du kï'dï aya'ba dɔ mo zi Yësu iya henye, “Eme ndö, vo komoyandi. Ëdï tïnyö, kaa mati iya henye Wïrï nje kölö, Wïrï maako anza du mo. ");
INSERT INTO mgc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Vïdï mo'dɔ lɔvɔ Wïrï biya di'di nï aba, dë nï aba biya, ehe biya kyigɔ 'bënï aba, mo mo'dɔ lɔvɔ vo haliŋɔ oka kaa, mati mo o'dɔ lɔvɔ nï. Ëdï na laka zi kö'du kï'dï rïyö nenye'e tɔwɔ mo ta da ngötu kï'dï wakumu maako ëtï zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mati Yësu ayɔlɔ hala da kö'du ya'ba 'bënï ëdï na laka, mo iya zi mo, “Anza dë na kɔwɔ ta ra damöku 'ba Wïrï.” Ta ga ma ne, vïdï maako ï'dï rë nï dekpe zi ha Yësu ko'jo. ");
INSERT INTO mgc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mati Yësu ëdï kö'du yandi mï yëkëlu, mo ako'jo kö'du iya henye, “Hala vo komoyandi 'ba vo kö'du kï'dïye ɔ'bɔnnï akiya henye Korisitɔ atëdï tëmï kozo 'ba Dawidi? ");
INSERT INTO mgc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lawo Kölö Laka ï'dï me'do zi Dawidi kiya henye, ‘Yere iya zi Yere ama henye, Alima kinye da tïrï ma, le zi ma vo wehe 'bëyïye kï'dï burutu yï.’ ");
INSERT INTO mgc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidi na bi dënï ako'jo mo ‘Yere.’ Hala Korisitɔ akatɔ'bɔ tëdï na kozo a Dawidi?” ");
INSERT INTO mgc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yësu nduwë kö'du yandi, ehe vïdï kayo ëdï mbilinnï koze na rakyenyi. Mati mo ayandi zë, mo iya henye, “Andiye re 'e kazi vo komoyandi 'ba vo kö'du kïdï ne'e, o'dɔnnï lɔvɔ zi lasi kpo mï bɔngɔ konda 'bënnï ne, zë mëtë watɔwɔ aba mï bi wakogo. ");
INSERT INTO mgc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Akinzi 'bënnï kyïtï ma kyedre mati akɔ'jɔ mï bi 'ba mötu ne, ehe bi ma laka mï bi 'ba ratɔtɔ. ");
INSERT INTO mgc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ï'dïnnï kö'du ko'dɔ 'bënnï ga kö'du mbara lu'bë ne'e, ehe wënnï wa 'bëzë logo mo ta liŋɔ. Here, zë o'dɔ rë nnï zi kongɔ na laka mötu konda ko'dɔ aba.” ");
INSERT INTO mgc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mati Yësu alima kara ra söndu kɔhi 'ba yëkëlu, mo ëdï vïdï mati ëdïnnï kɔhi 'bënnï kï'dï ne kongɔ mo. Vïdï vo wa aba kyɔ, ï'dïnnï kɔhi kyɔ. ");
INSERT INTO mgc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mora mbara lu'bë vo leri ayi ï'dï tarifa rïyö. ");
INSERT INTO mgc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mo ako'jo vo lö'bö 'bënïye bi kölö, ehe iya zi zë henye, “Mayada zi ye mbara lu'bë vo leri nenye, ï'dï wakï'dï mï söndu ne ndra ta da oka'e biya. ");
INSERT INTO mgc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vïdï mati zë wa aba kyɔ, ï'dïnnï nje wa mati zë ombannï dë. Mora mo le na vo leri kaa mati mo ëdï ne, ï'dï 'bënï biya wa mati mo ëdï zi lima rɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mati Yësu ëdï alasi tëmï yëkëlu, vo lö'bö 'bɔmo iyannï zi mo henye, “Ongɔ te vo komoyandi, yïtö koro a'di ra here, loko ne aba? ");
INSERT INTO mgc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yësu aya'ba da me'do iya henye, Ongɔ loko kyedre ne'e ku? Yïtö ma kölö maako kinye akatɔsɔ dë ga bi nï, gë zë biya na kölö kölö aku'du akaŋo.” ");
INSERT INTO mgc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yaa mati Yësu ëdï alima da Döku 'ba Olivo, kyëtï 'ba yëkëlu, mora Petero, Yemisi, Yowani ehe Anderiya ayinnï zi mo na bi dë nnï. ");
INSERT INTO mgc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Zë iyannï zi mo henye, “Ayada zi ze ndala aba nenye ako'dɔ rë nï, ehe ayada zi ze a'di ra ako'dɔ rë nï zi yada henye kadra mo ɔkɔ ku ga kö'du zi wasisi ne'e biya zi rë nnï ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yësu iya zi zë henye, “Ëdïye komo kï'dï aba, ehe ila'e vïdï kölö maako dë zi ye ko'ba. ");
INSERT INTO mgc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vïdï kayo akï'dï rë nnï me'do ga kö'du ma, akatayi akiyannï henye, ma mo, ehe zë ako'bannï vïdï kayo. ");
INSERT INTO mgc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mora here, anza'e dë na riti ëzë owo'e kpɔrɔ wehe kara da kapa ehe kö'du yöyö 'ba wehe na kɔwɔ. Kö'du nere'e ako'dɔ rë nnï, mora anza dë zi kiya henye, ndundu 'ba dakaŋo ra ɔkɔ ku. ");
INSERT INTO mgc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dakaŋo ako'dɔ wehe oka ma kölö aba, damöku akalëpï da oka maako. Kinzikinzi atëdï ta bi ne biya ehe madöyï atëdï. Wa ne'e atëdïnnï kaa dagba tɔɔ 'ba wisi ko'jo. ");
INSERT INTO mgc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'E na bi de 'e, ëdïye komo kï'dï aba. Akïrïye, ehe aku'bö'e bi 'ba vurë. Aku'bö'e mï bi 'ba mötu, atɔrɔ'e komo vo daliŋɔ'e, ehe yere'e ga kö'du ma, zi yada kö'du yöyö laka ne zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mora dagba kazi ndundu mo tɔkɔ, kö'du yöyö laka ma yëtï zi vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ëzë ïrïye, ika bi 'ba vurë, asösu'e dë ga kö'du mati akiya'e. Ëzë kadra mo ɔkɔ ku, iya'e mati ï'dï zi ye. Ga kö'du me'do mati akame'do'e ne, atanza 'be, atayinnï kazi Lawo Kölö Laka. ");
INSERT INTO mgc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Öndu'e atënyïnnï akpa da öndu nnïye, ehe akï'dïnnï zë zi kofo. 'Bu'e atënyïnnï akpa da gisisi 'bënïye, ehe akï'dïnnï zë zi kofo. Gisisi ako'dɔnnï wehe akpa 'bu nnï aba, ehe akomannï gërï zi 'bu nnï, ma nnï ëtï kofo. ");
INSERT INTO mgc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vïdï biya na kölö kölö akoyinnïye ga kö'du ma. Mora vïdï mati ëdï mï kuku aba, le mï ndundu mo akayɔmɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Akongɔ'e tuku kyedre atɔrɔ bi mati mo anza dë zi tëdï zi mo (kö'du zi vo ko'jo mo, ayɔlɔ na laka mï kö'du nenye a'di). Mora zë mati mï Yudiya, atahonnï 'de da lutu'e. ");
INSERT INTO mgc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Vïdï mati ëdï da loko 'bënï asi dekpe akaŋo zi wa maako koba mo nï aba. ");
INSERT INTO mgc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Vïdï mati ëdï yaka ï'bë dekpe hulëhu, liŋɔ kö'du bɔngɔ 'bënï. ");
INSERT INTO mgc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Atëdï na kyënyë mï kadra naniye, zi mbara mati ɔmɔnnï, ehe zi ma'e mati ëdïnnï gisi luru aba. ");
INSERT INTO mgc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amötu zi Wïrï kazi kö'du nani o'dɔ rë nï mï tona. ");
INSERT INTO mgc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ga kö'du kyënyë 'ba mï ko'do naniye, atëdï kɔwɔ na kyënyë ta da mo biya gba damöku ayɔlɔ dë biyeto aba, mati Wïrï ï'dï damöku le mï kadra ma yaanya aba. Mora ani kö'du ako atanza dekpe kaa ma ne hulëhu. ");
INSERT INTO mgc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mora Yere aya'ba ra watiti mï ko'do naniye, ëzë mo o'dɔ dë here, ṛo vïdï ako ɔmɔ dë. Ga kö'du vïdï kinzi 'bɔmo'e, here mo aya'ba ra watiti 'ba ko'do naniye. ");
INSERT INTO mgc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mora here ëzë vïdï kölö maako iya zi yï, Ongɔ te kinye Korisitɔ ëdï ne, mandere ongɔ te nani mo ëdï, oma dë mï mo. ");
INSERT INTO mgc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ga kö'du Korisitɔ vo ndɔndɔ, ehe nëbï vo ndɔndɔ'e akalagannï, zë ako'dɔnnï kö'du koro, ehe kö'du rakaga zi vïdï ko'ba. Zë ako'dɔnnï kö'du ne zi vïdï 'ba Wïrï mati mo inzi. ");
INSERT INTO mgc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ëdïye na komokandi. Mayada ga kö'du ne ku biya zi ye gba kazi kadra mo tɔkɔ.” ");
INSERT INTO mgc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mi ko'do tapëtï kadra 'ba riti nani, kadra akuyï rë nï na köndu, yehwe ayanyi bi dekpe, ");
INSERT INTO mgc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kyëlu akalëpïnnï ta komorïyë, ehe kyigɔ mï ga bi ne'e akore zë ta bi 'bëzë. ");
INSERT INTO mgc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mora here, wisi a vïdï akalaya ta bi tayi tëmï fɔli kyigɔ bikanyi kyedre aba. ");
INSERT INTO mgc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mo akutu malayika'e yaga zi bi sowɔ 'ba bi golo'bɔ 'ba dakaŋo ne zi vïdï kinzi 'ba Wïrï tɔtɔ mo ta ndundu 'ba damöku le kapa ma kyamo. ");
INSERT INTO mgc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kaga 'ba kyëlu ma yandi kö'du yɔlɔ zi ze. Ëzë ngora 'ba kaga kyëlu ne ayi ku na luwë, ehe na 'bɔlɔ, ehe yëyu na kyïyï ne ayeto tövu, akayɔlɔ henye omo ku kara. ");
INSERT INTO mgc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tëmï gërï kölö ne, ëzë ongɔ'e kö'du ne'e ëdï rë nnï ko'dɔ, akayɔlɔ'e henye, kadra mo ku kara nzɔ zi rë nï yeto. ");
INSERT INTO mgc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Asösu'e henye, kö'du nenye'e biya ako'dɔ rë nnï dagba kazi vïdï mati ëdïnnï na dïdï yaanya aba ne koli biya. ");
INSERT INTO mgc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Komorïyë dakaŋo aba akalagannï 'de, mora me'do 'bama alaga dë.” ");
INSERT INTO mgc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Here vïdï kölö maako ayɔlɔ dë ndala aba ko'do mo mandere kadra mo akatɔkɔ, le malayika 'ba komorïyë'e mandere wisi, nje 'bu ra akayɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ëdïye komo kï'dï tandi aba ga kö'du ayɔlɔ'e dë, ndala aba kadra ne atɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Akatëdï kaa vïdï maako ënyï atï'bë bi yingɔ, kɔwɔ ta ra liŋɔ 'bënï, ehe ila vo lɔɔ 'bënïye ra na vo ga liŋɔ kongɔ. Tapëtï mo ï'dï zi zë lɔɔ 'ba vïdï ma kölö zi ko'dɔ mo, mora tapëtï mo ayada kö'du zi vo ha loko kongɔ, zi tëdï nduwë kongɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ëdïye komokandi aba ga kö'du ayɔlɔ'e dë ndala aba vo kyeti liŋɔ ne atɔkɔ. Mandere atëdï hutaga aba, mandere mï kutë yɔndɔ gba kono bi aba mandere bi loso 'ba kadra aba. ");
INSERT INTO mgc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ëzë mo ayi truku'du, mi'ja'e dë ako'do. ");
INSERT INTO mgc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kö'du mati miya zi yï ne, miya zi ye biya, ëdïye komo kï'dï aba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Here kadra 'ba kyërë karama 'ba laga 'ba koli ndenye ila ko'do mo ku nje da rïyö. Kyërë 'ba mangɔlɔ'bɔ konyo kazi langa gɔ mo. Here kyedre 'ba vo karasa, ehe vo komoyandi 'ba vo kö'du kï'dïye, ëdïnnï gërï koma zi Yësu kïrï na liwo zi kofo mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Zë iyannï henye, “Do'dɔ'e dë mï ko'do 'ba kyërë kazi vïdï ënyïnnï na koma wehe aba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mati Yësu ëdï mï Beteniya liŋɔ 'ba Simona, vo mönyu ne, wakonyo, mbara maako ayi ödu loko maṛanji 'ba yënï këzï ngutru aba kyɔ mï mo, kogo mo kɔhi kyedre aba. Mo ihiya maṛanji 'ba yënï këzï ngutru ne, ehe ope da Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kya 'ba vïdï mati ëdïnnï ani ne, na kamo, ehe iyannï zi oka ma kölö maako henye, “Kö'du a'di 'bënï zi tëdï yënï këzï ngutru ne yaŋa gɔ mo? ");
INSERT INTO mgc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Atɔ'bɔ kogo mo ndra ta da lamiwota tarifa, ehe kɔhi mo zi kï'dï zi vo leriye.” Here alimannï gbɔ di'di mbara ne kile mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mora Yësu iya zi zë henye, “Ila'e mo kutu nï aba. Kö'du a'di ëdïye mï mo kile? Mo o'dɔ kö'du laka teme ne, ga kö'du ma. ");
INSERT INTO mgc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atëdïye 'duwï vïdï vo leri ëtï, ehe ta ga kadra biya omba zi ye zë kɔnyi. Mora 'duwï atanza'e dë ma aba. ");
INSERT INTO mgc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mo o'dɔ wa mati mo akatɔ'bɔ. Mo ope yënï këzï ngutru ne ra ma zi kɔ'jɔ ma dagba ta komo kadra kö'du zi kusu mo.” ");
INSERT INTO mgc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yaanya aba ne miya zi ye tïnyö, bi mati biya ayëtï Bayibolo zi mo mï damöku ne, wa mati mo o'dɔ ne, akayada mï kö'du sösu kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Here Yudasi Sikereto mo kölö tëmï vo lïtu 'butë dɔmorïyö ne, ï'bë zi kyedre 'ba vo karasa'e, ga kö'du zi Yësu susu mo zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zë na rakyenyi ga kö'du mati mo omba zi kiya kowo, ehe ï'dïnnï da kö'du zi kɔhi kï'dï mo zi mo. Here Yudasi Isikirito ayeto gërï ma laka koma mo zi Yësu kï'dï mo zi zë. ");
INSERT INTO mgc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mï ko'do dagba 'ba kyërë 'ba mangɔlɔ'bɔ konyo kazi langa, ko'do mati tïmëlë 'ba zi konyo ofo ku, Yësu vo lö'bö'e ako'jonnï hɔ mo, omba zi ze tï'bë ze zi wakonyo 'ba kyërë ne kɔ'jɔ nzɔ zi bi yï. ");
INSERT INTO mgc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Here Yësu utu rïyö tëmï zë kö'du kise nenye aba, “Ï'bë'e mï gawo akandɔsi de 'e kora maako ëdï tele wini aba dë nï. Alö'bö'e gɔ mo ");
INSERT INTO mgc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mï liŋɔ mati mo ödu ne, mora iya'e zi vo kyeti liŋɔ ne, henye, vo komoyandi iya henye, ‘Loko ma vala ra vo lö'bö 'bama'e, mora ma zi ze wakonyo 'ba kyërë 'ba karama 'ba laga 'ba koli ne, konyo mo 'dɔmo?’ ");
INSERT INTO mgc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mora mo akayada zi ye loko tɔrɔ kyedre, loko ne ëdï ku nzɔ zi bi ye akɔ'jɔ'e wakonyo zi 'beze ani.” ");
INSERT INTO mgc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Vo lö'bö ënyï ï'bënnï mï gawo, ehe i'jannï kö'du ne te kaa mati Yësu iya zi zë ne, ehe akɔ'jɔnnï wakonyo 'ba kyërë 'ba karama 'ba laga 'ba koli gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hutaga aba, Yësu ayinnï vo lïtu 'bënï ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mati ëdïnnï wakonyo da tarabiza, Yësu iya zi zë henye, “Mayada zi ye, vïdï ma kölö tëmïye akasusu ma, mati ëdï wakonyo ma aba ne.” ");
INSERT INTO mgc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vo lïtu'e na rasösu ehe ayetonnï hɔ mo ko'jo na kölö kölö, “Ma tïnyö manza kö'du aba rë yï.” ");
INSERT INTO mgc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yësu aya'ba da me'do zi zë iya henye, “Atëdï vïdï kölö tëmï ye 'butë dɔmorïyö mati usu mangɔlɔ'bɔ 'bënï ma aba mï gbenje ne. ");
INSERT INTO mgc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wisi a vïdï akoli kaa mati Biyibolo iya, ako'dɔ rëni here. Mora atëdï na kyënyë zi vïdï mati asusu mo ne. Atëdï na laka zi vïdï ne ëzë gba o'jo mo dë.” ");
INSERT INTO mgc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mati zë ëdïnnï wakonyo, Yësu oba nzoyi mangɔlɔ'bɔ ehe o'dɔ mötu 'ba öwö'dï, owe mï mo, ï'dï zi vo lö'bö 'bënïye. Mo iya zi zë henye, “Oba nenye ida ra ma ra.” ");
INSERT INTO mgc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Here mo oba köfö, o'dɔ mötu 'ba öwö'dï zi Wïrï, ï'dï zi zë, zë uwënnï biya tëmï mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yësu iya zi zë henye, “Nenye yama ma mati alikɔ yaga ga kö'du vïdï kayo, yama ma mati lömu 'ba Wïrï ɔrɔ ku dɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mayada zi ye muwë a'ji nenye dekpe löhu le mï ko'do mati makuwë a'ji ma kyïyï mï damöku 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mora zë aya'binnï ngala ehe ï'bënnï yaga da Döku 'ba Olivo. ");
INSERT INTO mgc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yësu iya zi zë henye, “'E biya ataho'e, akila'e ma kaa mati Biyibolo iya, Wïrï akofo vo tïmëlë yako, mora tïmëlë akapere rë nnï biya. ");
INSERT INTO mgc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mora tapëtï mo ëzë mënyï ku na dïdï, ma katï'bë mï Galilaya dagba komo'e.” ");
INSERT INTO mgc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero ënyï aya'ba da me'do henye, “Mila yï dë, ëzë kɔsɔ mo ne'e biya ilannï yï le.” ");
INSERT INTO mgc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yësu iya zi Petero henye, “Mayada zi yï henye, gba kazi zanga ayapa da rïyö yɔndɔ aba, akiya da wota henye, ayɔlɔ ma dë.” ");
INSERT INTO mgc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petero aya'ba da me'do na kyigɔ, “Makiya dë here, ëzë ëdï le zi ma zi koli yï aba.” Kɔsɔ vo lïtu ne'e iyannï biya here. ");
INSERT INTO mgc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Zë ayi ɔkɔnnï bi mati ako'jo Getesemina, ehe Yësu iya zi vo lö'bö 'bënïye, “Alima'e kinye ëzë mëdï amötu.” ");
INSERT INTO mgc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mo oba Petero, Yemisi ehe Yowani tï'bë nï aba. Kö'du sösu ayi zi mo ");
INSERT INTO mgc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ehe mo iya zi zë henye, “Kö'du sösu mï di'di ma ne, na kyedre omba kara zi lihiya. Alima'e kinye ongɔ'e bi kida aba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Mo ënyï ï'bë tisi dagba, umë rë nï akaŋo amötu henye, ëzë ëdï zi rë nï ko'dɔ, mɔ'bɔ dë zi tï'bë kpuru tëmï kadra 'ba riti nani. ");
INSERT INTO mgc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Amötu iya henye, “'Bu, 'bu ma wasisi biya ako'dɔ rë nï mï kö'du komba 'bëyï. Oba köfö 'ba riti nenye 'de ta ra ma. Mora ne anza dë gba wa mati momba, mora wa mati yï ra omba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mati mo a'ba i'ja vo lö'bö wota ne'e ëdïnnï ako'do. Mo iya zi Petero, “Simona, ëdïye ako'do? Ɔ'bɔ'e dë zi lima na ngö gbï le nje kadra kölö?” ");
INSERT INTO mgc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mo iya zi zë henye, “Ëdïye bi kida aba, amötu'e henye, kazi alëpïye mï kö'du yɔnzɔ. Lawo Kölö Laka ra akatɔ'bɔ ida ra akyigɔ dë.” ");
INSERT INTO mgc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mo ï'bë kpa löhu da kölö amötu, amötu iya gbï me'do kölö kölö ne. ");
INSERT INTO mgc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mo a'ba hulëhu zi vo lïtu'e i'ja zë ako'do, zë ɔ'bɔnnï dë zi komonnï kila na hwërë. Zë ayɔlɔnnï dë a'di ra na kiyannï zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mati mo ayi hulëhu mï kadra ma da wota mo aba, mo iya zi zë henye, Ëdïye gba ako'do alawo? Ɔ'bɔ ku! Kadra mo ɔkɔ ku! Ongɔ'e te, wisi a vïdï yaanya aba ï'dï ku zi vïdï 'ba kö'du kyënyë'e. ");
INSERT INTO mgc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","“Ënyïye rïyë dï'bë'e, ongɔ'e kinye, nenye kora mati asusu ma.” ");
INSERT INTO mgc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mati Yësu ëdï gba ame'do, Yudasi mo kölö tëmï vo lïtu 'butë dɔmorïyö ne ɔkɔ gbɔ. Mo aba vïdï kayo kulu, mɔvɔ aba. Kyedre 'ba vo karasa, vo komoyandi 'ba kö'du kï'dïye 'e kyedre 'ba Yuda'e ra utunnï zë. ");
INSERT INTO mgc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Vo wasusu ayada zi vïdï kayo ne'e, dakyïnë wa na ko'dɔ, iya henye, vïdï mati munzu hɔ mo ne, mo ra omba'e. “Ïrïye mo, oba'e mo 'de tasi mo aba yaga.” ");
INSERT INTO mgc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kandi mati Yudasi ɔkɔ, mo ï'bë zɔ zi Yësu, ehe iya henye, “Vo komoyandi” ehe unzu hɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Here zë ïrïnnï Yësu anda'bannï mo gö. ");
INSERT INTO mgc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mora vïdï kölö tëmï zë mati ëdïnnï atɔrɔ ani ne, otɔ kulu 'bënï, iga mbili vo lö'bö 'ba karasa ma kyedre ne yaga. ");
INSERT INTO mgc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yësu ame'do rïyë iya zi zë henye, “Ayiye kulu aba, mɔvɔ aba zi ma kïrï mo, kaa ma vo kö'du kï'dï pere? ");
INSERT INTO mgc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko'do ta ga ko'do mëdï ëtï wayandi mï yëkëlu, ehe ïrïye ma dë, mora here, kö'du ne ako'dɔ rë nnï biya kaa mati Biyibolo iya.” ");
INSERT INTO mgc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Here, vo lïtu 'bɔmo'e biya ilannï mo, aho wënnï. ");
INSERT INTO mgc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Vere maako gba na ɔbi bɔngɔ kolo aba rë nï, nje kölö usu ga Yësu ani. ");
INSERT INTO mgc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Zë ayɔnzɔnnï zi mo kïrï, mo aho wënï na ga mbiya ila bɔngɔ ne 'de zi zë ani. ");
INSERT INTO mgc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Here, obannï Yësu tï'bë mo aba liŋɔ 'ba kyedre 'ba vo karasa, ani Yere 'ba vo karasa'e, kyedre'e 'ba vo komoyandi 'ba kö'du kï'dïye atɔtɔ rë nnï biya ani. ");
INSERT INTO mgc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mora here, Petero usu gɔ mo ta bi kɔwɔ ï'bë ödu mï liŋɔ 'ba kyedre 'ba vo karasa. Ani mo alima akaŋo vo bi kida ëtï wa'do koye. ");
INSERT INTO mgc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kyedre 'ba vo karasa'e, Yuda'e biya ï'dï rë nnï zi kö'du kyënyë mati Yësu o'dɔ ne ki'ja, atehe mo kofo, mora 'de i'jannï dë. ");
INSERT INTO mgc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vïdï kayo alimannï ndɔndɔ kiga ra Yësu, mora kö'du yada 'bëzë ne andele dë. ");
INSERT INTO mgc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kya 'ba vïdï maako'e ënyïnnï rïyë, igannï ndɔndɔ gu mo, iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dowo ze mo ëdï akiya henye, ‘Ma kihiya yëkëlu mati vïdï o'ba ne 'de, ehe tapëtï ko'do da wota aba, mako'ba mati vïdï ra dë ako'dɔ.’” ");
INSERT INTO mgc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ëzë zë o'dɔnnï le kö'du kiya 'bëzë ne ire dë. ");
INSERT INTO mgc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kyedre 'ba vo karasa'e ënyï da komo zë rïyë ako'jo ha Yësu iya henye, “Da kö'du ya'ba 'bëyï anza dë ga kö'du ndɔndɔ mati igannï gu yï ne?” ");
INSERT INTO mgc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mora Yësu alima wënï ti, omba dë zi me'do. Kyedre 'ba vo karasa ako'jo hɔ mo löhu iya henye, “Yï Korisitɔ, Wisi 'ba Wïrï mati ï'dï ya'da zi mo ne?” ");
INSERT INTO mgc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yësu aya'ba da me'do iya henye, “Ma ra. 'E biya akongɔ'e wisi a vïdï alima da kala tïrï a Wïrï, ehe atayi fɔli 'ba komorïyë aba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Here, kyedre 'ba vo karasa iza bɔngɔ 'bɔmo ehe iya henye, “Domba kya 'ba vo kö'du kiya dekpe. ");
INSERT INTO mgc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Owo'e kö'du sawiya 'bɔmo ne ku. Kö'du sösu 'be'e a'di?” Zë biya u'dunnï födö rɔ mo, mo o'dɔ kö'du kyënyë ku mofo mo 'de. ");
INSERT INTO mgc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kya maako'e ayetonnï oro ko'bi ra Yësu, idannï komo mo u'bönnï mo, iyannï henye, “Asösu ëyï ra u'bö yï?” Ehe vo wehe ïrïnnï mo a'bannï kyila mo kisa mo. ");
INSERT INTO mgc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mati Petero ëdï gba lima akaŋo liŋɔ 'ba kyedre 'ba vo karasa'e, wu'jë ma kölö maako ayi ta da kapa. ");
INSERT INTO mgc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mati ongɔ Petero ëdï wa'do koye, mo ongɔ bi mbïyï dɔ mo iya henye, “Yï kpa Yësu 'ba Nazereta aba.” ");
INSERT INTO mgc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mora mo andi wënï iya henye, Mayɔlɔ dë kö'du a'di ëdï ame'do gɔ mo? Ehe ënyï asi wënï zɔ yaga. Mora ta gɔ mo zanga ayapa gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mati wu'jë ne ongɔ mo atɔrɔ ani, ayeto kpa kö'du ne yada mo löhu zi vïdï mati ëdïnnï atɔrɔ ne'e. “Ma kölö tëmï zë.” ");
INSERT INTO mgc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mora Petero andi kpa löhu. Yaa ta gɔ mo, zë mati ëdïnnï atɔrɔ da kapa ani ne, asösunnï Petero kpa löhu, iyannï henye, ɔ'bɔ dë zi tandi, yï ma kölö tëmï zë ra ga kö'du yï kpa tëmï Galilaya. ");
INSERT INTO mgc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Here Petero ënyï asënë rë nï iya henye, “Wïrï kire, kora mati ëdïye ame'do ga kö'du mo ne, mayɔlɔ dë.” ");
INSERT INTO mgc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mora here, tapëtï kö'du kiya 'ba Petero ne, zanga ënyï ayapa ma da rïyö mo, ehe Petero asösu kö'du mati Yësu ayada zi nï, iya henye, “Gba kazi zanga yapa da rïyö, akiya da wota henye, ayɔlɔ ma dë.” Ehe Petero na kö'du sösu ayeto gbɔ kudu. ");
INSERT INTO mgc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Do ŋbɔ da mïndö aba, kyedre 'ba vo karasa'e, kyedre 'ba Yuda'e, vo komoyandi 'ba vo kö'du kï'dïye, ehe Yuda'e biya atɔtɔ rë nnï bi kölö ame'do a'di ra ako'dɔ zi Yësu. Here zë idannï Yësu nyɔri aba ï'dïnnï mo zi Pilato, ");
INSERT INTO mgc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato ënyï ako'jo hɔ mo iya henye, “Yï ra Yere 'ba Yuda'e?” Yësu ënyï aya'ba da me'do iya henye, “Mora kaa mati iya ne.” ");
INSERT INTO mgc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kyedre 'ba vo karasa'e asösunnï Yësu ga kö'du sisi kyɔ. ");
INSERT INTO mgc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Here Pilato ako'jo hɔ mo löhu iya henye, “Anza dë zi yï da kö'du ne ya'ba mo? Owo wasusu 'bëzë ne ku biya.” ");
INSERT INTO mgc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yësu omba dë zi me'do ma kölö kiya, mora o'dɔ Pilato na rakaga. ");
INSERT INTO mgc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tëmï kadra 'ba Kyërë 'ba Laga 'ba Koli, Pilato ëdï kö'du aba zi vïdï kinga kölö tëmï kamba, mati vïdï ombannï. ");
INSERT INTO mgc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mï kadra nani kora maako ru mo Barabasi ï'dï mo mï kamba ani, ga kö'du ofo vïdï. ");
INSERT INTO mgc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mati vïdï kayo ne'e atɔtɔ rë nnï, ayetonnï ha Pilato ko'jo kaa ma kyere. ");
INSERT INTO mgc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mo ako'jo hë zë iya henye, “Omba'e Yere 'ba Yuda'e ra zi ma kinga zi ye?” ");
INSERT INTO mgc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ayɔlɔ na laka kyedre 'ba vo karasa'e mati ï'dïnnï Yësu zi nï ne, ga kö'du zë na mï kumbë. ");
INSERT INTO mgc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mora here, kyedre 'ba vo karasa'e alëlu da vïdï kayo ne'e zi ha Pilato ko'jo zi Barabasi kinga mo zi nnï. ");
INSERT INTO mgc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ame'do löhu zi vïdï kayo ne'e, “A'di ra omba'e zi ma ko'dɔ zi mo mati ako'jo Yere 'ba Yuda'e ne?” ");
INSERT INTO mgc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Zë ënyïnnï biya hë nnï gbögbö aba, “Atötö mo.” ");
INSERT INTO mgc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ako'jo hë zë iya henye, “Kö'du kyënyë a'di ra mo o'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Here Pilato omba vïdï kayo ne'e zi tëdïnnï na rakyenyi, mo inga Barabasi zi zë, mo u'bö hu Yësu ï'dï mo gbɔ zi tötö. ");
INSERT INTO mgc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vo wehe obannï Yësu tï'bë mo aba mï liŋɔ 'ba turu 'ba daliŋɔ, ani ako'jonnï kɔsɔ vo wehe ne'e biya bi kölö. ");
INSERT INTO mgc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Here ayöfunnï bɔngɔ 'buluyë da Yësu, o'dɔnnï safo tëmï ngora kono ayöfunnï dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mora here, zë ayetonnï mo sawiya mo, iyannï henye, “Lima konda zi yï Yere 'ba Yuda'e.” ");
INSERT INTO mgc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Zë u'bönnï dɔ mo mɔvɔ aba o'binnï oro rɔ mo, alɔmvɔnnï domo nnï aba akaŋo amötunnï. ");
INSERT INTO mgc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mati zë indennï mo sawiya ku, obannï bɔngɔ 'buluyë ne 'de aya'bannï bɔngɔ ɔmo gbï rɔ mo löhu. Mora here, ikannï mo gbɔ yaga zi tötö. ");
INSERT INTO mgc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ta bi tï'bë 'bëzë ta da gërï, andɔsi dë nnï kora maako aba ru mo Simona tëmï Sirënë, ëdï atayi mï gawo, mora vo wehe o'dɔnnï mo na kamo zi taka 'ba Yësu kumbë. Mo 'bu 'ba Alekazende nnï Rafusa aba. ");
INSERT INTO mgc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Zë obannï Yësu tï'bë mo aba bi mati ako'jo Gologota, kö'du ya'ba aba, “Bi 'ba yingɔ da.” ");
INSERT INTO mgc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mora ani, zë ayɔnzɔnnï zi a'ji asusë ɔwɔ aba ru mo mahiri, zi kï'dï zi mo mora Yësu omba dë zi kuwë mo. ");
INSERT INTO mgc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mora here, atötönnï mo ayanyannï bɔngɔ 'bɔmo na ga rë nnï födö ku'du aba ëyï akoba 'bënï bɔngɔ ma vala. ");
INSERT INTO mgc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mati atötönnï mo ne, ndï kadra 'ba damïndö ɔkɔ ku modɔmosowɔ. ");
INSERT INTO mgc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wayöru 'ba mo susu ne, iya henye, “Yere 'ba Yuda'e.” ");
INSERT INTO mgc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Zë atötönnï vo logo kpa rïyö Yësu aba, ma kölö datïrï mo, ehe ma vere da gali mo. ");
INSERT INTO mgc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vïdï mati ëdïnnï alaga ta dakapa, ëdïnnï dë nnï njili na kamo Yësu lidi aba. “Aha! Omba zi tï'bë yëkëlu ne kihiya mo akaŋo zi ko'ba mo löhu ko'do da wota aba. ");
INSERT INTO mgc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yaanya aba ne asi akaŋo ta da taka ehe ayɔmɔ rëyï.” ");
INSERT INTO mgc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Here tëmï gërï kölö ne kyedre 'ba vo karasa ehe vo komoyandi 'ba vo kö'du kï'dïye ogonnï Yësu iyannï henye, “Mo ayɔmɔ oka'e, mora ɔ'bɔ dë zi rë nï yɔmɔ. ");
INSERT INTO mgc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Dongɔ'e Korisitɔ ne te, Yere 'ba Yiserele, asi akaŋo ta da taka ne yaanya aba ehe dakoma mï mo.” Vo logo rïyö mati atötö Yësu aba ne, alidi mo kpa. ");
INSERT INTO mgc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mï kutë kadra aba, mandölu ayöfu bi kpo ta dakaŋo ehe inde rë nï tapëtï kadra wota. ");
INSERT INTO mgc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mati ndï kadra ɔkɔ ku komo kadra wota, Yësu ënyï udu rïyë gu kyembe aba, “Elöyï, Elöyï, lema sabakatani?” Kö'du ya'ba aba henye, “Wïrï ama, Wïrï ama, kö'du a'di ila ma gɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kya vïdï mati ëdïnnï ani owonnï mo ne, iyannï henye, “Owo'e te, mo ëdï Eliya ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mora here, ma kölö tëmï zë aho lifa aba usu mï a'ji ï'dï da njili mɔvɔ, ehe mo ïnjë dami'di ha Yësu iya henye, “Disiye bi mo, dongɔ'e ëzë Eliya ëdï atayi mo yasi akaŋo ta da taka.” ");
INSERT INTO mgc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mora Yësu udu rïyë gu kyembe aba, ehe oli gbɔ. ");
INSERT INTO mgc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Here, mï bɔngɔ mati ove mï yëkëlu ne, aliza rïyö, kɔ ta rïyë le akaŋo. ");
INSERT INTO mgc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Vo kyëlu 'ba vo wehe mati ëdï atɔrɔ komo taka ani ne, ongɔ hala Yësu oli. Mo iya henye, “Kora nenye tïnyö wisi 'ba Wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kya 'ba mbara maako'e ëdïnnï ani bi kongɔ ta bi kɔwɔ. Mï kutë zë ëdï Mariya Magadala, Salome, Mariya ma 'ba Yemisi nnï Yosepa aba. ");
INSERT INTO mgc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ne mbara mati usunnï ga Yësu mï Galilaya ehe ëdïnnï mo kɔnyi. Aga mbara maako'e kpa kyɔ ani. Mbara ne'e ayinnï Yësu ëtï mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ko'do nenye ako'jo ko'do 'ba rakɔ'jɔ zi bi ko'do 'ba ralawo. Bi ëdï ku tayi ra hutaga, kora maako ru mo Yosepa, ta Arimataya ɔkɔ gbɔ. Mo mï gboko 'ba turu, ehe ɔwɔnnï mo, ehe mo kölö tëmï vïdï mati ëdïnnï bi tayi 'ba damöku 'ba Wïrï kida, ënyï ï'bë zi Pilato kazi tere, kö'du ko'jo ga kö'du yöku Yësu, zi kusu mo. ");
INSERT INTO mgc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato rakaga aba mati owo henye, Yësu oli ku. Mo ako'jo vo kyëlu 'ba vo wehe ako'jo hɔ mo kɔdɔ Yësu oli ku kyere ya. ");
INSERT INTO mgc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tapëtï mo owo kö'du yada 'ba vo kyëlu ne, Pilato iya zi Yosepa moba yöku ne. ");
INSERT INTO mgc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosepa ënyï ï'bë wogo mbili bɔngɔ, ayasi yöku ne akaŋo olo mï mbili bɔngɔ ne, ïnjë ï'bë usu mï wogo mati ole mï döku ma kyigɔ ne. Here, mo alulu yïtö kyedre ŋbïrï ha bi tödu 'ba wogo ne. ");
INSERT INTO mgc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magadala nnï Mariya ma 'ba Yosepa aba, ëdïnnï akongɔ ta bi kɔwɔ, bi mati usu yöku Yësu 'dɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tapëtï ko'do 'ba ralawo mati inde rë nï, Mariya Magadala, Mariya ma 'ba Yemisi wogonnï yënï këzï ngutru tï'bë mo aba zi pisi ra yöku Yësu. ");
INSERT INTO mgc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Do ŋbɔ mï ko'do 'ba ralawo kadra nzere aba, zë ënyï ï'bënnï da wogo. ");
INSERT INTO mgc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta bi tï'bë 'bëzë ta da gërï, alimannï me'do na ga rë nnï, iyannï henye, “Ëyï ra akalulu yïtö ne ta bi tödu 'ba ha wogo ne zi ze?” ");
INSERT INTO mgc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mora mati ongɔnnï bi rïyë, i'jannï yïtö ne alulu ku nzɔ hulëhu. ");
INSERT INTO mgc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Here ënyï ödunnï mï wogo ani, ongɔnnï wisi ɔbi maako ëdï alima datïrï usu bɔngɔ kanyi konda rë nï o'dɔ zë na rakaga. ");
INSERT INTO mgc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mo iya henye, “Ere'e dë. Mayɔlɔ ku ëdïye bi koma kö'du Yësu 'ba Nazereta mati atötö. Mo anza kpe kinye, mo ënyï ku tëmï koli, ongɔ'e te, ne bi mati ï'dïnnï mo 'dɔmo. ");
INSERT INTO mgc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mora here, yaanya aba ï'bë iya'e kö'du kise nenye zi vo lö'bö 'bɔmo'e Petero mëdï zë ëtï. Here mo ëdï tï'bë dagba komo'e mï Galilaya, ani akongɔ'e mo te kaa mati mo ayada zi ye.” ");
INSERT INTO mgc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Here mbara ne asinnï yaga ahonnï ta da wogo kazi tere, onyonnï kö'du mo kpa dë zi vïdï kölö maako ga kö'du zë na tere. ");
INSERT INTO mgc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mora here, tapëtï tënyï 'ba Yësu tëmï koli 'do ŋbɔ ko'do 'ba ralawo aba, mo ayada rë nï dagba zi Mariya Magadala, mati mo ore dakyikyi madɔmorïyö yaga ta rɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mo ï'bë ayada zi aboka nïye. Zë na lu'bë ëdïnnï akudu. ");
INSERT INTO mgc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mati zë owonnï henye, mo iya Yësu ëdï na dïdï nongɔ mo komo nï aba, zë omannï dë mï me'do 'bɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yaa ta gɔ mo, Yësu ayada dakyïnë nï 'beri zi vïdï rïyö maako'e ëdïnnï atï'bë wënnï ta da gërï mï dakaŋo maako. ");
INSERT INTO mgc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Zë ayadannï kö'du ne, zi oka nnïye mora zë 'de omannï dë mï kö'du ne. ");
INSERT INTO mgc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mora mï ndundu mo ta gɔ mo biya, Yësu ayada rë nï zi vo lïtu 'butë dɔmo kölö ëdïnnï wakonyo. Mo asawiya zë ga kö'du zë anzannï dë koma aba, ehe zë kpa na vo kazi kö'du kowo zi koma mï vïdï mati iyannï mo na dïdï. ");
INSERT INTO mgc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mo iya zi zë henye, “Ï'bë'e ta damöku ne biya, ayëtïye kö'du yöyö laka ne zi dakyïnë vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mo mati oma ïrï bapatisi, akayɔmɔ. Mo mati omba dë akï'dï riti zi mo. ");
INSERT INTO mgc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Vo koma'e, akï'dï kyigɔ 'ba kö'du koro ko'dɔ zi zë. Zë akorennï dakyikyi yaga mï ru ma. Zë akame'donnï ha mënzë maako ëtï. ");
INSERT INTO mgc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mo mati ïrï wiri umbë le rïyë, mandere uwë waroso le, o'dɔ zë dë na kyënyë. Zë akï'dïnnï kala nnï da vo kɔɔ'e, akakɔ'jɔ zë.” ");
INSERT INTO mgc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ta ëtï me'do 'ba Yere Yësu zi zë ne, oba mo komorïyë ehe alima ku da kala tïrï 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Here, vo lö'bö ënyï ï'bënnï kö'du yëtï aba ta bi ne biya. Yere o'dɔ lɔɔ ne zë ëtï, ayada kö'du yëtï 'bëzë ne tïnyö ga kö'du koro mati ëdïnnï ako'dɔ ne.");
INSERT INTO mgc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mï biyeto aba Me'do ëdï. Me'do ne ëdï Wïrï aba ehe tïnyö Wïrï ra. ");
INSERT INTO mgc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tëmï biyeto, Me'do ne ëdï Wïrï aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ehe Me'do nenye aba, Wïrï o'dɔ wa biya. Wa maako o'dɔ dë kazi Me'do ne. ");
INSERT INTO mgc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dïdï ayi kazi mo, ehe dïdï 'bɔmo ï'dï bikanyi zi vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Bikanyi ne asesi tanyi mï biköndu, ehe biköndu ayölu dë. ");
INSERT INTO mgc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wïrï utu kora maako ru mo Yowani. ");
INSERT INTO mgc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mo ayi zi yada kö'du 'ba bikanyi ehe zi gaga vïdï biya zi tëdï koma aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yowani ra dë bikanyi nenye. Mo ayi nje zi yada kö'du 'ba bikanyi ne. ");
INSERT INTO mgc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bikanyi tïnyö mati ayanyi bi da vïdï biya, ëdï tayi mï damöku ne. ");
INSERT INTO mgc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Me'do ne ëdï mï damöku ne, mora vïdï maako ayɔlɔ mo dë, Wïrï o'dɔ damöku ne le me'do 'bɔmo aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mo ayi gogo mï damöku 'bënï, mora vïdï 'bɔmowe ïrïnnï mo dë kalakyedre aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vïdï maakowe ombannï mo ehe ï'dï koma 'bënnï mï mo. Here mo ï'dï dangölö zi zë, zi tëdïnnï na gisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Zë anzannï dë gisi 'ba Wïrï, ta da rë zë, mandere ga kö'du komba 'ba vïdï köndu, mandere kö'du komba 'ba o'di. Wïrï ra na bi dë nï o'dɔ zë na gisi 'bënï. ");
INSERT INTO mgc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Me'do ne ayi na vïdï köndu, ehe alima kinye ze aba. Dongɔ ze bikanyi kyedre tïnyö 'bɔmo, bikanyi kyedre 'ba Wisi nje kölö 'ba 'Bu. Mo ndɔ rakyëyï ehe tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowani ame'do kö'du mo ehe agbögbö, “Nenye mo mati ma yada zi ye atayi! Mo kyedre ta da ma, ga kö'du mo ëdï na wïdï gba kazi ma ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kazi rakyëyï 'bɔmo dïrï ze ya'da kayo ");
INSERT INTO mgc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosa ra ï'dï kö'du kï'dï, mora Yësu Korisitɔ ika zi ze kö'du laka tïnyö aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Vïdï maako gba ongɔ Wïrï dë. Nje Wisi kölö ne mo ra tïnyö Wïrï ehe ëdï kara ra 'Bu, ayada zi ze Wïrï ëdï kaa a'di. ");
INSERT INTO mgc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Vo kalakonda vo yënï 'ba Yude mï Yerusalema utunnï vo karasa maakowe ehe Lëvïyë zi ha Yowani ko'jo mo 'bënï ëyï. ");
INSERT INTO mgc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mo omba dɔ mo ayada zi zë huwë tïnyö henye, “Manza dë Korisitɔ ne.” ");
INSERT INTO mgc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Neene zë ako'jonnï hɔ mo, iyannï henye, “Yï Eliya ra?” Yowani aya'ba henye, “Manza dë.” Zë ako'jonnï hɔ mo iyannï henye, “Yï ra Nëbï ne?” Mo aya'ba henye, “E e!” ");
INSERT INTO mgc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndundu mo aba, zë iyannï henye, “Ayada zi ze, yï 'bëyï ëyï?” Zë iyannï henye, “Zi ze koba hulëhu da kö'du ya'ba 'bëyï ne zi vïdï mati utunnï ze.” ");
INSERT INTO mgc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yowani aya'ba da me'do tëmï me'do kiya 'ba nëbï Yisaya. “Ma nje vïdï ma ëdï mbere mï da lïpï, ‘O'de gërï nzɔ zi Yere!’” ");
INSERT INTO mgc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kya 'ba Farasi maakowe utunnï zë kpa zi Yowani. ");
INSERT INTO mgc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Zë ako'jonnï hɔ mo, iyannï henye, “Kö'du a'di ëdï vïdï bapatisi, ëzë anza dë Korisitɔ mandere Eliya mandere Nëbïe?” ");
INSERT INTO mgc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yowani ayada zi zë iya henye, “Mo'dɔ bapatisi wini aba, mora ëdï yë aba kinye, vïdï maako ayɔle dë. ");
INSERT INTO mgc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mayi le dagba, manza dë na laka zi kamoka 'bɔmowe kinga.” ");
INSERT INTO mgc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yowani iya nenye mati mo ëdï bapatisi kï'dï humïrë 'ba Ranga Yeredene mï Beteniya. ");
INSERT INTO mgc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mï ko'do ma ta gɔ mo, Yowani ongɔ Yësu ëdï tayi zi nï, ehe iya henye, “Kinye ëdï Tïmëlë 'ba Wïrï mati oba kö'du yaŋa 'ba damöku ne 'de. ");
INSERT INTO mgc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mo ra mati ma yada kö'du mo zi ye henye, ‘Vïdï maako atayi kpa, mo kyedre ta da ma, ga kö'du mo ëdï na wïdï gba kazi ma ko'jo.’ ");
INSERT INTO mgc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma yɔlɔ dë, mo 'bënï ëyï. Mora mayi zi ye bapatisi wini aba, here vïdï biya mï Yiserele akongɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma mëdï ani ehe mongɔ Lawo Laka ayi akaŋo dɔ mo kaa atu'bu ta komorïyë, ehe Lawo Laka ne alima dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gba kazi nenye ma yɔlɔ dë ëyï 'bënï mo. Mora mo mati utu ma zi bapatisi kï'dï wini aba ne ayada zi ma henye, ‘Akongɔ Lawo Laka tayi akaŋo ehe lima da vïdï maako. Neene akayɔlɔ henye, mo ra vïdï mati akï'dï bapatisi Lawo Laka aba.’ ");
INSERT INTO mgc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mongɔ nenye o'dɔ rë nï, ehe ma yada zi ye henye, mo Wisi 'ba Wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ko'do vere aba, Yowani ëdï ani löhu ehe vo lö'bö 'bɔmowe rïyö ëdïnnï mo aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mati mo ongɔ Yësu lasi ta dakapa, mo iya henye, “Kinye ëdï Tïmëlë 'ba Wïrï!” ");
INSERT INTO mgc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vo lö'bö 'ba Yowani rïyö owonnï me'do 'bɔmo ne, ehe zë ï'bënnï Yësu aba. ");
INSERT INTO mgc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mati Yësu opi rë nï ehe ongɔ zë, mo ako'jo kö'du henye, “A'di ra ombe?” Zë aya'bannï dɔ mo iyannï henye, “Raboni, alima kila?” Mï ha 'ba Hïbïru, “Raboni ne,” “Vo komoyandi” ra. ");
INSERT INTO mgc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yësu aya'ba dɔ mo iya henye, “Ayi onge te.” Ëdï ku nzɔ kaa kadra sowɔ mï kadra kutë mati zë ï'bënnï mo aba ehe ongɔnnï bi ma mo alima 'dɔmo. Here zë alimannï nduwë mï ndundu 'ba kadra ne. ");
INSERT INTO mgc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kölö tëmï kora rïyö ma owo ha Yowani ehe ï'bë Yësu aba ra Anderiya, öndu 'ba Simona Petero. ");
INSERT INTO mgc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dagba kö'du mati Anderiya o'dɔ, ëdï zi koma öndu nï ehe yada zi mo henye, “Di'ja Masiya ne ku!” Mï ha 'ba Hïbïru, “Masiya ne” kpa te kaa mï ha 'ba Gïrïgï “Korisitɔ ne.” ");
INSERT INTO mgc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anderiya ika öndu nï zi Yësu. Mati Yësu ongɔ mo, mo iya henye, Simona wisi 'ba Yowani, akako'jo yï Kapahasi. Ru nenye atɔ'bɔ kidra na “Petero.” ");
INSERT INTO mgc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Mï ko'do vere aba Yësu omba zi tï'bë Galilaya. Ani mo i'ja Pilipo, mo ta Beteseyida, gawo liŋɔ 'ba Anderiya, Petero aba. Yësu iya zi Pilipo, “Usu ga ma.” ");
INSERT INTO mgc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo i'ja Natanëlë ehe iya henye, “Di'ja ze vere mati Mosa ehe Nëbïyë ayörunnï kö'du mo ne ku. Mo Yësu, wisi 'ba Yosepa ta Nazereta.” ");
INSERT INTO mgc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanëlë ako'jo kö'du iya henye, “Wa laka maako atɔ'bɔ tayi ta Nazereta?” Pilipo aya'ba dɔ mo iya henye, “Ayi ongɔ te.” ");
INSERT INTO mgc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mati Yësu ongɔ Natanëlë ëdï atayi zi nï, mo iya henye, “Kinye ëdï tïnyö kozo zutu 'bezee 'ba Yiserele, ehe mo anza dë na vo wakoba.” ");
INSERT INTO mgc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanëlë ako'jo hɔ mo iya henye, “Hala ayɔlɔ ma?” Yësu aya'ba dɔ mo iya henye, “Gba kazi Pilipo yï ko'jo, mongɔ yï hu kaga kyëlu.” ");
INSERT INTO mgc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanëlë iya henye, “Raboni, yï Wisi 'ba Wïrï ehe Yere 'ba Yiserele!” ");
INSERT INTO mgc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yësu aya'ba dɔ mo iya henye, “Oma mï ma nje ga kö'du mati miya henye, mongɔ yï hu kaga kyëlu? Akongɔ wa maako kyedre ndra ta da ma nenye. ");
INSERT INTO mgc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma yada zi yï, akonge komorïyë akayëhu rë nï ehe malayike 'ba Wïrï tï'bë rïyë ehe tayi akaŋo da Wisi 'ba Vïdï.” ");
INSERT INTO mgc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ko'do wota aba yaa Mariya, ma 'ba Yësu ëdï mï karama 'ba rakoze mï gawo 'ba Kana mï Galilaya. ");
INSERT INTO mgc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yësu vo lö'bö 'bënïyë ëtï, ise zë kpa bi 'ba rakoze ne. ");
INSERT INTO mgc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mati a'ji inde rë nï ku biya, ma 'ba Yësu iya zi mo henye, “Zë anzannï kpe a'ji aba.” ");
INSERT INTO mgc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yësu aya'ba dɔ mo iya henye, “Ma ma, ayada dë zi ma a'di ra zi ko'dɔ. Kadra 'bama gba ɔkɔ dë.” ");
INSERT INTO mgc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma 'ba Yësu ayada zi vo lïtuwë 'ba liŋɔ henye, “O'de wa mati mo ayada zi ye ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yude ëdïnnï kö'du kira 'ba wa kaka ŋbala aba ehe ga kö'du nenye, tele yïtö 'ba wini ëdï ani modaka ma kölö ëdï kyedre zi kïrï kaa lita lamikölö. ");
INSERT INTO mgc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yësu iya zi vo lïtuwë 'ba liŋɔ henye, “Osowe tele nenyee wini aba.” Zë osonnï zë kpika ");
INSERT INTO mgc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ehe mo ayada zi zë henye, “Yaanya aba oba kya 'ba wini ne yaga ehe ï'dï zi kora vo kyeti karama ne.” Zë obannï wini ne zi mo ");
INSERT INTO mgc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","mati yaanya aba ofɔ rë nï ku na a'ji ehe mo anene. Mo ayɔlɔ dë a'ji nenye ayi ta kila, mora vo lïtuwë mati obannï a'ji nenye ayɔlɔnnï, here mo ako'jo 'bïyësï ");
INSERT INTO mgc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne ehe iya zi mo henye, “Vïdï biya uwënnï a'ji ma laka ra dagba, ehe tapëtï mo, mati yingɔ ëdïnnï ku kyɔ mo aba zi kuwë, mo ï'dï a'ji ma kɔɔ ne. Mora asesi wëyï a'ji ma laka ne le yaanya aba!” ");
INSERT INTO mgc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yësu o'dɔ dagba kyïnë 'ba kö'du koro nenye mï gawo 'ba Kana mï Galilaya. Ani mo ayada bikanyi kyedre 'bënï, ehe vo lö'bö 'bɔmowe omannï mï mo. ");
INSERT INTO mgc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tapëtï ma nenye, Yësu ehe ma mo, öndu mowe, ehe vo lö'bö 'bɔmowe ï'bënnï zi Kaparanamo, ehe alimannï ani ko'do tisi aba. ");
INSERT INTO mgc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ëdï ku kadra kara zi karama 'ba Yude 'ba laga 'ba koli, Yësu ï'bë zi Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ani mï yëkëlu mo i'ja vïdï ëdïnnï isa, tïmëlë, ehe atu'buwë kogo, ehe vo kɔhi kutrëë kpa limannï da tarabiza 'bënnï. ");
INSERT INTO mgc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Here mo o'dɔ so'da tëmï kɔ'di ehe ore ngötu biya yaga tëmï yëkëlu, 'dö tïmëlë, ehe isa, mo opi da tarabiza 'ba vïdï 'ba kɔhi kutrëë, apere kɔhi ŋbiriṛi 'bëzë ne, ");
INSERT INTO mgc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ehe mo ï'dï kö'du zi vïdï ma ëdïnnï atu'bu kogo ne henye, “Obe atu'buwë yaga ta kinye! O'de loko 'ba 'Bu ma dë na bi 'ba wakogo!” ");
INSERT INTO mgc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vo lö'bö 'bɔmowe asösunnï henye, wayöru iya henye, “Watɔwɔ 'bama kö'du loko 'bëyï, o'bɔ mï ma kaa wa'do.” ");
INSERT INTO mgc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Vo kalakonda 'ba Yude aya'bannï dɔ mo kö'du ko'jo aba henye, “Kyïnë 'ba kö'du koro a'di ra atɔ'bɔ ko'dɔ zi yada zi ze ëdï dangölö aba tïnyö zi nenye ko'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yësu aya'ba dɔ mo iya henye, “Iha akaŋo yëkëlu nenye ehe mï ko'do wota aba ma ko'ba löhu!” ");
INSERT INTO mgc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Vo dagbe aya'bannï henye, “Ïrï kɔɔ 'butësowɔ dɔmomodaka zi ko'ba yëkëlu nenye. A'di ra o'dɔ yï zi sösu atɔ'bɔ ko'ba ko'do wota aba löhu?” ");
INSERT INTO mgc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mora Yësu ëdï ame'do kö'du ida rë nï ra na yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mati ïnjë mo ku tëmï koli, vo lö'bö 'bɔmowe asösunnï kö'du mati ayada zi zë. Neene zë omannï mï wayöruwë ehe mï me'do 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mï Yerusalema mï kadra karama 'ba laga 'ba koli, vïdï kayo omannï mï Yësu, ga kö'du zë ongɔnnï mo ta bi kyïnë 'ba kö'du korowe ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mora Yësu ayɔlɔ kö'du mati mï di'di zë, ehe mo ila zë dë zi tëdï kyigɔ aba ndra ta dë nï. ");
INSERT INTO mgc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Vïdï maako anza zi yada zi mo a'di ra vïdïyë kaa mo. Mo ayɔlɔ ku nzɔ. ");
INSERT INTO mgc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ani vo dagba 'ba Yude ëdï ru mo Nikodïmö mo Farasi ra. ");
INSERT INTO mgc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yɔndɔ kölö maako aba mo ï'bë zi Yësu iya zi mo henye, “Raboni, da yɔlɔ ku Wïrï utu yï zi komo ze yandi. Ɔ'bɔ dë kyïn 'ba kö'du koro nenyee ko'dɔ, nje ëzë Wïrï ëdï yï aba.” ");
INSERT INTO mgc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yësu aya'ba dɔ mo iya henye, “Mëdï kö'du tïnyö ra yada zi yï vïdï maako ɔ'bɔ dë damöku 'ba Wïrï kongɔ kazi mo ko'jo löhu!” ");
INSERT INTO mgc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodïmö ako'jo iya henye, “Hala kora ma övu ku kyedre ne ako'jo löhu? Mo ɔ'bɔ dekpe tödu mï ma nï löhu zi ko'jo mï kadra ma rïyö mo!” ");
INSERT INTO mgc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yësu aya'ba dɔ mo henye, “Mëdï ayada tïnyö zi yï” Vïdï maako ɔ'bɔ dë tödu mï damöku 'ba Wïrï, kazi ko'jo mo wini aba ehe Lawo Laka. ");
INSERT INTO mgc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Vïdï köndu o'jonnï gisi 'bënnï. Nje Lawo Laka 'ba Wïrï o'jo gisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anza dë na rakaga ga kö'du mati miya henye, ako'jo yï löhu. ");
INSERT INTO mgc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lawo 'ba Wïrï ëdï kaa buluku mati aluku bi mati omba tï'bë zi mo. Atɔ'bɔ kowo kpɔrɔ buluku, mora ayɔlɔ dë ayi ta kila mandere ëdï tï'bë kila. Ëdï here biya zi vïdï ma o'jo Lawo aba. ");
INSERT INTO mgc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodïmö ako'jo kö'du iya henye, “Hala nenye atëdï?” ");
INSERT INTO mgc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yësu aya'ba dɔ mo iya henye, “Hala atɔ'bɔ zi tëdï na vo komoyandi 'ba Yiserele ehe ayɔlɔ wa nenyee dë? ");
INSERT INTO mgc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ma yada zi yï tïnyö, dëdï ame'do kö'du wa ma da yɔlɔ, ga kö'du dongɔ ku na bi de ze. Mora vïdï maako tëmï yë akïrï kö'du kiya 'beze ne dë. ");
INSERT INTO mgc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ëzë oma dë mati ma me'do zi yï kö'du wa 'ba dakaŋo, hala akoma ëzë ma me'do zi yï kö'du wa 'ba komorïyë? ");
INSERT INTO mgc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Vïdï maako gba ï'bë dë komorïyë, nje Wisi 'ba Vïdï, mati ayi akaŋo ta ani.” ");
INSERT INTO mgc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ehe here Wisi 'ba Vïdï akïnjë rïyë, kaa mɔvɔ wiri kɔhi mati Mosa ïnjë rïyë mï da lïpï. ");
INSERT INTO mgc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Neene vïdï biya mati ëdï koma aba mï Wisi 'ba Vïdï atëdï dïdï ŋburu aba. ");
INSERT INTO mgc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wïrï ɔwɔ damöku nenye ndra, here mo ï'dï Wisi kölö 'bënï ne, here vïdï mati oma mï mo ëdï dïdï ŋburu aba, ehe tïnyö oli dë. ");
INSERT INTO mgc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wïrï utu Wisi 'bënï ne dë ga kö'du mo omba zi ko'dɔ vurë 'ba damöku, mora ga kö'du mo omba zi yɔmɔ damöku ne kpuru wisi 'bënï aba.” ");
INSERT INTO mgc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Zë mati omannï mï Wisi ne, o'dɔ vurë kyënyë dë rë zë, mora zë mati omannï dë o'dɔ vurë 'bëzë ku nzɔ, ga kö'du omannï dë mï Wisi nje kölö 'ba Wïrï ne. ");
INSERT INTO mgc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bikanyi ayi mï damöku, mora vïdï ombannï zi lese mï biköndu ga kö'du zë ëdïnnï kö'du kyënyë ko'dɔ. Nenye ra ëdï hala o'dɔ vurë rë zë. ");
INSERT INTO mgc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Vïdï ma ëdïnnï kö'du kyënyë ko'dɔ, iyinnï bikanyi ehe ayinnï dë zi bikanyi, ga kö'du ayada wa mati zë ëdïnnï ako'dɔ ëdï na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mora vïdï biya ma alima tïnyö aba, atayi zi bikanyi ga kö'du zë ombannï agamowe zi yɔlɔ henye, Wïrï ëdï ko'dɔ kpuru zë aba.” ");
INSERT INTO mgc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tapëtï ma nenye, Yësu ehe vo lö'bö 'bënïyë ëtï ï'bënnï zi dakaŋo 'ba Yudiya, bi mati mo alima tisi zë ëtï ehe bapatisi kï'dï aba. ");
INSERT INTO mgc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yowani ëdï kpa bapatisi kï'dï mï Anono anza dë na kɔwɔ ta ra Salima, ga kö'du wini ëdï bi nani. Vïdï ëdï tï'bënnï zi mo ehe mo ëdï zë bapatisi. ");
INSERT INTO mgc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nenye gba kazi Yowani kï'dï mï kamba. ");
INSERT INTO mgc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kya vo lö'bö 'ba Yowani maakowe ayeto hë nnï wasa kora Yuda maako aba, kö'du 'ba wa kaka ŋbala ga kö'du kö'du kï'dï 'ba yënï. ");
INSERT INTO mgc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Here zë ï'bënnï zi Yowani ehe iyannï henye, “Raboni, asösu kö'du kora mati ëdï yï aba dakapa humïrë 'ba Ranga Yeredene, mo mati ëdï kö'du mo kiya? Here mo ëdï bapatisi kï'dï yaanya aba, ehe vïdï biya ëdï tï'bënnï zi mo.” ");
INSERT INTO mgc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yowani aya'ba dɔ mo iya henye, “Vïdï maako ɔ'bɔ dë zi tëdï wa maako aba nje ëzë Wïrï ra ï'dï zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","E ra na vo kiya 'bama mati miya henye, ‘Manza dë Korisitɔ ra, mora utu ma dagba komo mo.’ ");
INSERT INTO mgc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","'Bïyësï ra mati mbara ne na 'bɔmo, mora aboka 'ba vo 'bïyësï mati ɔrɔ dakapa mbili nï koze, ëdï na rakyenyi mati mo owo gu 'bïyësï. Nenye ëdï hala rakyenyi 'bama o'dɔ ku ti'de. ");
INSERT INTO mgc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mo atayi ndra kyedre, mora ma tayi tisiwa aba.” ");
INSERT INTO mgc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mo ma ayi ta komorïyë ëdï kyedre ta da wa biya. Mo mati 'ba dakaŋo, mo zi dakaŋo ehe ame'do kö'du wa 'ba dakaŋo. Mora mo ma ayi ta komorïyë ëdï kyedre ta da wa biya. ");
INSERT INTO mgc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mo ayada wa ma mo ongɔ ehe owo, du vïdï maako oma dë mï kö'du kise 'bɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mora vïdï mati oma mï kö'du kise 'bɔmo nenye ayada henye Wïrï ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mo ma Wïrï utu ame'do me'do 'ba Wïrï ga kö'du Wïrï ï'dï zi mo Lawo ndɔ 'bënï ku. ");
INSERT INTO mgc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","'Bu ɔwɔ Wisi 'bënï ehe ï'dï kyigɔ 'ba wa biya zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Vïdï ma oma mï Wisi ne, ëdï dïdï ŋburu aba, vïdï ma oro Wisi ne dë atanza dë dïdï ŋburu aba, mora akalima hu wayaza 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farasiye owonnï henye, Yësu ëdï ku laga dagba ehe bapatisi kï'dï zi vo lö'böwë ndra ta da Yowani. ");
INSERT INTO mgc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tïnyö Yësu abapatisi vïdï kölö maako dë, nje vo lö'bö 'bɔmowe ra o'dɔnnï. ");
INSERT INTO mgc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mati Yësu owo kö'du mati ëdï akiya ne, mo ila Yudiya ehe ï'bë hulëhu zi Galilaya. ");
INSERT INTO mgc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta da gërï 'bɔmo ani, mo omba zi tï'bë kpuru ta Samariya. ");
INSERT INTO mgc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mï Samariya mo ayi zi gawo maako ru mo Seka, anza dë na kɔwɔ ta ra yaka mati Yakoba ï'dï zi wisi 'bënï Yosepa. ");
INSERT INTO mgc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ku'ju 'ba Yakoba ëdï ani, ehe Yësu na riti ta bi lasi, alima akaŋo dakapa ku'ju ne. Ëdï kaa kadra kutë here. ");
INSERT INTO mgc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mbara vïdï 'ba Samariya maako ayi zi wini kuwu, ehe Yësu iya zi mo henye, “Ï'dï wini kuwë zi ma.” ");
INSERT INTO mgc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Vo lö'bö 'bɔmowe ï'bënnï ku mï gawo zi wakonyo kogo. ");
INSERT INTO mgc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mbara ne aya'ba dɔ mo henye, “Yï Yuda ra ehe ma vïdï 'ba Samariya ra, hala atɔ'bɔ ko'jo ha ma kö'du wini kuwë?” Yude uwënnï wini dë tëmï sikɔ kölö vïdï 'ba Samariya ëtï. ");
INSERT INTO mgc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yësu aya'ba dɔ mo henye, “Ëzë ayɔlɔ nje wa ma Wïrï ï'dï, ehe ëyï ra ëdï hë yï ko'jo kö'du wini kuwë, ako'jo hɔ mo, ehe mo akï'dï zi yï wini mati ï'dï dïdï.” ");
INSERT INTO mgc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mbara ne iya henye, “Kyedre, anza kpa dë kyere wini aba, ehe ku'ju ne ëdï na yöndu. Ta kila aki'ja wini mati ï'dï dïdï? ");
INSERT INTO mgc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Zutu 'beze Yakoba ra ole ku'ju nenye zi ze, mo gisi 'bënïyë ëtï ehe ngötu 'bɔmowe uwënnï biya tëmï mo. Yï kyedre ta da Yakoba?” ");
INSERT INTO mgc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yësu aya'ba dɔ mo iya henye, “Vïdï biya ma uwë wini nenye atëdï na kɔdrɔ löhu, ");
INSERT INTO mgc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mora vïdï ma uwë wini mati ma kï'dï zi mo atanza dë na kɔdrɔ löhu. Wini mati ma kï'dï zi mo atayi mï mo na ku'ju mati akï'dï zi mo dïdï ma ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mbara ne aya'ba dɔ mo iya henye, “Kyedre, ï'dï zi ma wini nani! Here ma tanza dë na kɔdrɔ löhu, mandere kazi ma tayi kinye zi wini kuwu.” ");
INSERT INTO mgc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yësu ayada zi mo iya henye, “Ï'bë ako'jo kora 'bëyï ehe ayi löhu.” ");
INSERT INTO mgc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mo aya'ba dɔ mo iya henye, “Manza dë kora aba.” Yësu aya'ba henye, “Kö'du 'bëyï ne tïnyö mati iya henye anza dë kora aba ne. ");
INSERT INTO mgc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Oze yï ku zi kora muyï, ehe kora ma ëdï lima mo aba yaanya aba ne anza tïnyö kora 'bëyï ra dë. Ayada zi ma kö'du tïnyö ra.” ");
INSERT INTO mgc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mbara ne iya henye, “Kyedre, mongɔ yï nëbï ra. ");
INSERT INTO mgc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Zutu 'ba Samariya amötunnï Wïrï da döku nenye, mora e Yude iye henye, Yerusalema ra bi ma da kamötu zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yësu iya zi mo henye, “Oma mï ma, mbara, kadra mo ëdï atayi mati vïdï amötunnï 'Bu dekpe da döku nenye mandere mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","E Samariye ayɔle dë tïnyö ëyï ra ëdï yë amötu, mora ze Yude, da yɔlɔ ku ëyï ra dëdï mötu, ga kö'du ëdï kazi Yude ra vo wayɔmɔ ayi. ");
INSERT INTO mgc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mora kadra mo ëdï tayi, ehe ëdï ku nzɔ kinye, mati kyigɔ Lawo 'ba Wïrï aba vïdï akamötunnï 'Bu kaa mo tïnyö ëdï, kï'dï zi mo mötu ma tïnyö mati mo omba. ");
INSERT INTO mgc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wïrï ëdï Lawo ra, ehe nje kyigɔ 'ba Lawo 'bɔmo aba vïdï atɔ'bɔ mötu mo kaa mo tïnyö ëdï.” ");
INSERT INTO mgc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mbara ne iya zi mo henye, “Ma yɔlɔ ku Masiya ne atayi, ehe ëzë mo ayi, mo akayada zi ze wa biya.” ");
INSERT INTO mgc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yësu aya'ba henye, “Ma ra mo, ma ra mo mati ëdï ame'do yï aba yaanya.” ");
INSERT INTO mgc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mï kadra nani vo lö'bö 'ba Yësu a'bannï, ehe zë na rakaga zi ki'ja mo ëdïnnï ame'do mbara aba. Mora vïdï maako tëmï zë ako'jo ha mbara ne dë, “A'di ra omba?” Zë ako'jonnï ha Yësu dë, “Kö'du a'di ëdïyë ame'do mbara ne aba?” ");
INSERT INTO mgc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mbara ne ila tele wini 'bënï ne ï'bë hulëhu mï gawo, ehe iya zi vïdïyë ani henye, ");
INSERT INTO mgc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ayi onge kora ne, mo ayada zi ma biya wa mati mo'dɔ! Mo atëdï Korisitɔ ra?” ");
INSERT INTO mgc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Zë ilannï gawo ehe ï'bënnï zi kongɔ Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mï kadra ne vo lö'böwë alenzennï Yësu iyannï zi mo henye, “Raboni, oba wa maako zi konyo!” ");
INSERT INTO mgc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mora mo aya'ba henye, “Mëdï wakonyo maako aba ayɔle kö'du mo dë.” ");
INSERT INTO mgc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Here vo lö'böwë ayetonnï, kö'du ko'jo tëmï kutë nnï na bi dë nnï, “Vïdï maako ika wakonyo ku zi mo?” ");
INSERT INTO mgc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yësu iya zi zë henye, “Wakonyo 'bama ëdï zi koro kö'du 'ba Wïrï mati utu ma ehe zi kinde lɔɔ mati mo ï'dï zi ma zi ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Akiye henye, ‘ëdï gba yehe sowɔ zi wakumu ta yaka.’ Mora ma yada zi ye henye, ongɔ bi te na laka da yake, wa mï yaka yaanya aba ahi ku, ehe ku nzɔ zi kumu. ");
INSERT INTO mgc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Vïdï mati umu ehe atɔtɔ dɔ mo ika ku zi dïdï ma ŋburu ŋburu, ehe agamo mati ïlï ehe mo mati umu aba, atëdïnnï na rakyenyi bi kölö. ");
INSERT INTO mgc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kö'du kiya ne ëdï tïnyö, ‘Maako ïyï, agamo umu.’ ");
INSERT INTO mgc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mutu wë zi nyenyo kumu mï yaka mati o'dɔ lɔɔ mo dë. Vïdï maakowe o'dɔnnï lɔɔ ani, ehe i'je wa kyɔ tëmï lɔɔ 'bëzë ne.” ");
INSERT INTO mgc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vïdï kayo 'ba Samariya mï gawo nani omannï mï Yësu ga kö'du mbara ne iya henye, “Mo ayada zi ma biya wa ma mo'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Here mati vïdï 'ba Samariye ayinnï zi mo, zë alenzennï mo zi lima nnï aba, ehe Yësu alima ani ko'do rïyö aba. ");
INSERT INTO mgc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vïdï kayo 'ba Samariya maakowe omannï ga kö'du 'ba kö'du kise. ");
INSERT INTO mgc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Zë iyannï zi mbara ne henye, “Doma ku yaanya aba, anza dë ga kö'du mati iya, mora ga kö'du ze na bi de ze dowo mo ku, ehe da yɔlɔ henye, mo ra tïnyö ëdï vo yɔmɔ 'ba damöku.” ");
INSERT INTO mgc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tapëtï ko'do rïyö aba ani, Yësu ila bi nani ehe ï'bë zi Galilaya. ");
INSERT INTO mgc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kö'du mo na bi dë nï iya henye, nëbï ɔwɔ dë mï dakaŋo 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mati mo ɔkɔ mï Galilaya, vïdï karani ïrïnnï mo kalakyedre aba, ga kö'du zë ï'bënnï mï karama 'ba laga 'ba koli mï Yerusalema ehe ongɔnnï biya wa mati mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mati Yësu a'ba zi Kana mï Galilaya, bi mati mo opi wini na a'ji. Vo mï turu maako ëdï ani wisi 'bɔmo na kɔɔ mï Kaparanamo. ");
INSERT INTO mgc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mati mo owo henye, Yësu ayi ku ta Yudiya zi Galilaya mo ï'bë zi mo ako'jo hɔ mo zi tï'bë Kaparanamo ehe zi kɔ'jɔ wisi 'bënï, mati mo ku kara zi koli. ");
INSERT INTO mgc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yësu iya zi mo henye, “Vïdï maako tëmï yë oma dë nje ëzë onge kyïnë 'ba kö'du korowe ehe rakage.” ");
INSERT INTO mgc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kora vo mï turu ne aya'ba dɔ mo henye, “Yere, ayi gba kazi wisi ama koli.” ");
INSERT INTO mgc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yësu iya zi mo henye, “Ï'bë wisi 'bëyï akadïdï.” Kora ne oma mï me'do 'ba Yësu, ehe ï'bë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Da gërï 'bɔmo liŋɔ vo lïtu 'bɔmowe andɔsi dë nnï mo aba kö'du kise aba zi mo. “Wisi 'bëyï ëdï ku zi tï'bë zi dïdï!” ");
INSERT INTO mgc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mo ako'jo hë zë iya henye, “Kadra vala ra mati wisi 'bënï ne na laka?” Zë aya'bannï henye, “Ëdï ndï kadra kölö mataganya tapëtï kadra kutë mati rakyïtu ne ila mo.” ");
INSERT INTO mgc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Here 'bu mo asösu ëdï mï kadra kölö nani mati Yësu ayada zi nï, “Wisi 'bëyï akadïdï.” Here mo ehe biya vo dakota 'bënï ëtï omannï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nenye kyïnë 'ba kö'du koro ma rïyö mati Yësu o'dɔ tapëtï tayi 'bɔmo ta Yudiya zi Galilaya. ");
INSERT INTO mgc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tapëtï ma nenye, Yësu ï'bë mï Yerusalema, kö'du karama yënï 'ba Yude. ");
INSERT INTO mgc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kara Haresi kyedre 'ba tïmëlë mï Yerusalema, kara maako ëdï ani sënjë aba muyï, mï ha 'ba Hïbïru ako'jo Betesata. ");
INSERT INTO mgc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Vïdï kayo 'ba rakɔɔ ëdïnnï ko'do ha kara ne, vo komoköndu, vo ka'bo, ehe vïdï vo keŋe. ");
INSERT INTO mgc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dakapa kara ne kora maako ëdï na rakɔɔ, kɔɔ 'butëwota dɔmomodɔmowota aba. ");
INSERT INTO mgc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mati Yësu ongɔ kora ne ehe ayɔlɔ henye mo ëdï ku na keŋe kyere kadra konda aba, mo ako'jo hɔ mo henye, “Omba zi yï kɔ'jɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kora ne aya'ba dɔ mo iya henye, “Kyedre, manza dë vïdï maako aba zi kï'dï ma mï kara ne, ëzë wini ne ëdï rë nï kɔhɔ rïyë. Ma yɔnzɔ zi tödu mï mo, mora vïdï maako kpa 'duwï atödu ani dagba.” ");
INSERT INTO mgc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yësu ayada zi mo henye, “Ënyï rïyë, oba agburuku 'bëyï ehe alasi!” ");
INSERT INTO mgc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kandi akɔ'jɔ kora ne gbɔ. Mo oba agburuku 'bënï rïyë ehe ayeto lasi toko. Ko'do mati kö'du ne o'dɔ rë nï mï mo ne kadra 'ba ko'do madɔmorïyö. ");
INSERT INTO mgc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mati vo dagbe 'ba Yude ongɔnnï kora ne ëdï agburuku 'bënï kïnjë, zë iyannï zi mo henye, “Nenye ko'do 'ba ralawo ra! Omba dë zi vïdï maako zi kïnjë agburuku mï ko'do 'ba ralawo.” ");
INSERT INTO mgc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mora mo aya'ba dɔ mo iya henye, “Kora mati akɔ'jɔ ma ne ayada zi ma kïnjë rïyë agburuku 'bama ehe lasi.” ");
INSERT INTO mgc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Zë ako'jonnï hɔ mo iyannï henye, “Ëyï ra kora nenye mati ayada zi yï, zi kïnjë rïyë agburuku 'bëyï ehe lasi?” ");
INSERT INTO mgc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mora mo ayɔlɔ dë, ga kö'du Yësu ï'bë wënï 'de liwo ga kö'du vïdï kayo. ");
INSERT INTO mgc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yaa Yësu i'ja kora ne mï yëkëlu ehe ayada zi mo, “Ongɔ te, yaanya aba rë yï ëdï ku na laka, mora o'dɔ kö'du kyënyë dekpe mandere kö'du kyënyë maako ndra ako'dɔ rë nï zi yï.” ");
INSERT INTO mgc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kora ne ï'bë ayada zi vo dagbe 'ba Yude henye, Yësu ra akɔ'jɔ nï. ");
INSERT INTO mgc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zë ayetonnï kö'du kyënyë maako ko'dɔ zi Yësu ga kö'du mo o'dɔ wa kaa ma here ne mï ko'do 'ba ralawo. ");
INSERT INTO mgc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mora Yësu iya henye, “'Bu ma ɔrɔ dë ta bi lɔɔ ko'dɔ, ehe nenye ra hala mëdï nduwë ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yaanya aba vo dagbe 'ba Yude ombannï zi Yësu kofo ga kö'du rïyö. Ma dagba, mo owe kö'du kï'dï 'ba mï ko'do 'ba ralawo. Mora ma kyënyë ndra, mo iya henye Wïrï 'Bu nï ra, mati o'dɔ nï kpiliri Wïrï aba. ");
INSERT INTO mgc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yësu ayada zi vïdïyë iya henye, “Ma yada tïnyö zi ye, Wisi o'dɔ wa maako dë na bi dë nï. Mo atɔ'bɔ nje ko'dɔ wa ma mo ongɔ 'Bu ëdï ko'dɔ ga kö'du mo o'dɔ kpa te wa ma mo ongɔ 'Bu o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Bu ɔwɔ Wisi ehe ayada zi mo biya wa ma mo o'dɔ. 'Bu akayada zi mo wa kyedre maako ndra ta da ma nenye, ehe atëdïyë na rakaga. ");
INSERT INTO mgc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaa 'Bu ïnjë yöku ehe ï'dï dïdï, here Wisi ï'dï dïdï zi vïdï mati mo omba. ");
INSERT INTO mgc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","'Bu o'dɔ vurë 'ba vïdï maako dë, mora mo o'dɔ Wisi 'bënï ra na vo vurë 'ba vïdï ko'dɔ biya. ");
INSERT INTO mgc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'Bu o'dɔ nenye ga kö'du vïdï biya zi Wisi koro kpa kaa zë oronnï nï. Ëzë vïdï maako omba dë zi Wisi koro, nenye kpa te kaa mo omba dë zi koro 'Bu mati utu mo.” ");
INSERT INTO mgc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ma yada tïnyö zi ye henye, vïdï ma owo kö'du kise 'bama ehe ëdï koma aba mï mo mati utu ma ëdï lawo dïdï ma ŋburu ŋburu aba, ehe o'dɔ vurë kyënyë dë rɔ mo. Zë ï'bënnï ku nzɔ tëmï koli zi dïdï. ");
INSERT INTO mgc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ma yada tïnyö zi ye henye, kadra ne atayi ehe ëdï ku nzɔ kinye mati yöku biya akowo gu 'ba Wisi 'ba Wïrï, ehe zë mati owonnï hɔ mo, akalimannï. ");
INSERT INTO mgc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Bu ëdï kyigɔ aba zi dïdï kï'dï, ehe mo ï'dï kyigɔ kölö nani zi Wisi. ");
INSERT INTO mgc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ehe mo ï'dï zi Wisi 'bënï dangölö zi vurë 'ba vïdï ko'dɔ biya, ga kö'du mo Wisi 'ba Vïdï. ");
INSERT INTO mgc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Re maga dë! Kadra mo atɔkɔ mati biya yöku akowo gu 'ba Wisi 'ba vïdï, ");
INSERT INTO mgc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ehe zë atayinnï yaga tëmï dawogo 'bënnï. Vïdï biya ma o'dɔnnï kö'du laka atënyïnnï na dïdï, mora vïdï biya ma o'dɔnnï kö'du kyënyë atënyïnnï na dïdï ehe ako'dɔ vurë kyënyë 'bëzë.” ");
INSERT INTO mgc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mɔ'bɔ dë wa maako ko'dɔ na bi da ma. 'Bu ra utu ma, ehe mo ra ayada zi ma hala zi vurë ko'dɔ. Mo'dɔ vurë 'bama na laka, ga kö'du moro mo, ehe mo'dɔ dë wa mati momba zi ma ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ëzë ma me'do ga kö'du ma, gërï maako anza dë ani zi yada mëdï kö'du tïnyö ra yada. ");
INSERT INTO mgc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mora vïdï maako ëdï kpa ame'do kö'du ma, ehe ma yɔlɔ wa mati mo iya ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Utuwë vo lïtuwë zi Yowani, ehe mo ayada zi zë kö'du tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma lima dë ra kö'du mati vïdï iyannï kö'du ma, mora ma yada wa nenyee zi ye here, zi ye yɔmɔ. ");
INSERT INTO mgc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowani, lamba mati ï'dï bikanyi kyɔ, ehe, e na rakyenyi zi lima mï bikanyi 'bɔmo ne tisiwa. ");
INSERT INTO mgc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mora vïdï maako ndra ta da Yowani ame'do kö'du ma. Mo'dɔ ne wa mati 'Bu ma ï'dï zi ma ko'dɔ. Wa biya mati mo'dɔ ayada henye 'Bu ra utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Bu mati utu ma, ame'do kpa kö'du ma, mora owowe gu mo dë mandere kongɔ mo da komo da komo. ");
INSERT INTO mgc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ome kö'du kise ɔmo dë, ga kö'du ombe dë zi tëdï koma aba mï mati mo utu. ");
INSERT INTO mgc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ome wayöruwë, ga kö'du asösuwë henye, aki'je dïdï ŋburu ŋburu mï zë. Wayöruwë ayada kö'du ma, ");
INSERT INTO mgc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mora ombe dë zi tayi zi ma kö'du dïdï ma ŋburu ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Momba kö'du wayeto 'ba vïdï köndu dë, ");
INSERT INTO mgc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mora ma yɔlɔ e, vïdï ma kölö tëmï yë, zi Wïrï tɔwɔ anza dë kalakyedre aba. ");
INSERT INTO mgc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mayi ku kalakonda 'ba 'Bu ma aba, ehe ïrïyë ma dë. Mora akïrïyë vïdï ma ayinnï na bi dë nnï. ");
INSERT INTO mgc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hala akome? Ombe zi wayeto kïrï kazi oka ma kölö maako, mora ayɔnze dë zi tëdï wayeto aba kazi Wïrï mati ëdï kölö ne, hala atɔ'be koma mï ma? ");
INSERT INTO mgc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Asösuwë dë henye, ma ra vïdï ma akasusu wë zi 'Bu. Ï'dïyë kö'du sösu 'be ra Mosa, le mo ra vïdï ma akasusu wë. ");
INSERT INTO mgc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosa ayöru wa kö'du ma, ehe ëzë ome mï Mosa, akome mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mora ëzë ome dë mï wa mati Mosa ayöru, hala atɔ'be koma mï wa mati miya?” ");
INSERT INTO mgc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tapëtï ma nenye Yësu umu kyëtï Föfö 'ba Galilaya, mati ayɔlɔ kpa na Föfö 'ba Tiberiyasi. ");
INSERT INTO mgc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Vïdï kayo usunnï gɔ mo ga kö'du ongɔnnï mo ëdï kyïnë 'ba kö'du korowe ko'dɔ zi kɔ'jɔ vo kɔe. ");
INSERT INTO mgc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Kara zi kadra karama 'ba laga 'ba koli 'ba Yude, Yësu ï'bë rïyë da döku vo lö'bö 'bënïyë ëtï ehe alima akaŋo. ");
INSERT INTO mgc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mati Yësu ongɔ vïdï kayo tayinnï zi nï, mo ako'jo ha Pilipo iya henye, “Ta kila da ki'ja ze wakonyo kyɔ zi tɔ'bɔ vïdï nenyee biya?” ");
INSERT INTO mgc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mo iya nenye zi Pilipo yɔnzɔ. Mo ayɔlɔ ku nzɔ a'di ra mo ëdï tï'bë zi ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo aya'ba dɔ mo iya henye, “Ayɔlɔ dë henye, akïrï kara kɔhi 'ba yehe modɔmowota nje zi kogo mangɔlɔ'bɔ tisi zi vïdï ma kölö nenyee?” ");
INSERT INTO mgc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Anderiya, öndu 'ba Simona Petero, kölö tëmï vo lö'böwë, mo ame'do rïyë iya henye, ");
INSERT INTO mgc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wisi maako ëdï kinye, mo ëdï mangɔlɔ'bɔ sisi aba muyï ehe kyenze rïyö. Mora a'di ra na laka ëdï zi vïdï biya nenyee?” ");
INSERT INTO mgc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dakaŋo ayöfu loma aba, ehe Yësu ayada zi vo lö'bö 'bënïyë zi yada zi vïdï biya lima akaŋo. Vïdï kora ëdï kaa kpulukumuyï mï vïdï kayo nenyee. ");
INSERT INTO mgc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yësu oba mangɔlɔ'bɔ ne mï kala nï ï'dï öwö'dï zi Wïrï. Here, mo idra mangɔlɔ'bɔ ne zi vïdïyë, mo o'dɔ kpa here kyenze ne aba, le vïdï ëdïnnï mo aba kyɔ zi konyo. ");
INSERT INTO mgc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vïdï onyonnï biya ma ombannï, ehe Yësu ayada zi vo lö'bö 'bënïyë zi tɔtɔ kɔsɔ mo ma ɔsɔ, here ma yaŋa dë. ");
INSERT INTO mgc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Vo lö'böwë atɔtɔnnï dë zë bi kölö ehe oso koṛi 'butë dɔmorïyö wa mati ɔsɔ tëmï mangɔlɔ'bɔ muyï ne. ");
INSERT INTO mgc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tapëtï vïdï ongɔnnï kyïnë 'ba kö'du korowe ko'dɔ 'ba Yësu nenye, ayeto kiyannï henye, “Nenye atëdï tïnyö Nëbï mati ëdï zi tayi kinye mï damöku ne.” ");
INSERT INTO mgc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yësu ayɔlɔ henye zë ombannï yɔnzɔ zi mo ko'dɔ na wehe zi tëdï na yere 'bëzë. Here mo ï'bë rïyë da döku, ani zi mo tëdï kutu nï aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hutaga nani aba vo lö'bö 'ba Yësu ï'bënnï akaŋo zi föfö. ");
INSERT INTO mgc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Zë ëkyïnnï mï töŋbö, ayetonnï kumu kyëtï zi Kaparanamo. Mati bi öndu Yësu gba ayi dë zi zë, ");
INSERT INTO mgc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","buluku kyigɔ ëdï ku kɔhɔ wini na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mati vo lö'böwë opinnï ku kaa wiṛi wota mandere sowɔ, zë ongɔnnï Yësu lasi ta da wini. Mo asesi nduwë tayi kara ra töŋbö, zë gbɔ na tere. ");
INSERT INTO mgc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mora mo iya henye, “Ma Yësu ra! Ere dë!” ");
INSERT INTO mgc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Vo lö'böwë ombannï zi mo koba mï töŋbö, kandi ɔkɔ gbɔ da götï bi mati ëdïnnï atï'bë zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ko'do vere aba vïdï mati ëdïnnï gba ani humïrë kapa 'ba föfö, ayɔlɔnnï töŋbö ëdï nje kölö ani. Zë ayɔlɔnnï kpa henye, Yësu ï'bë dë mï mo vo lö'bö 'bënïyë ëtï. Zë ï'bënnï kutu nnï aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Töŋbö maakowe ta Tiberiyasi ï'bënnï kara ta bi mati vïdï kayo onyonnï mangɔlɔ'bɔ mati Yere ï'dï öwö'dï. ");
INSERT INTO mgc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Zë ongɔnnï henye Yësu ehe vo lö'bö 'bënï ëtï ï'bënnï ku. Here zë ëkyïnnï mï töŋböwë ehe ï'bënnï gbɔ Kaparanamo Yësu koma. ");
INSERT INTO mgc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Zë i'jannï mo kapa damïrë 'ba föfö ehe ako'jonnï hɔ mo iyannï henye, “Raboni, ɔkɔ ndala aba kinye?” ");
INSERT INTO mgc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yësu aya'ba dɔ mo iya henye, “Ma yada tïnyö zi ye, anze dë ma koma ga kö'du onge kyïnë 'ba kö'du korowe, mora ga kö'du onyowe biya wakonyo ma ombe. ");
INSERT INTO mgc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","O'de lɔɔ dë kö'du wakonyo mati ëdï rë nï yaŋa ne. O'de lɔɔ kö'du wakonyo mati ï'dï dïdï ma ŋburu ŋburu ne. Wisi 'ba Vïdï akï'dï wakonyo nenye zi ye, ga kö'du Wïrï 'Bu ï'dï kalakonda zi mo ko'dɔ here.” ");
INSERT INTO mgc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vïdï ako'jonnï hɔ mo iyannï henye, “A'di ra tïnyö Wïrï omba ze zi ko'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yësu aya'ba dɔ mo iya henye, “Wïrï omba zi ye tëdï koma aba mï vïdï mati mo utu.” ");
INSERT INTO mgc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Zë aya'bannï dɔ mo iyannï henye, “Kyïnë 'ba kö'du koro a'diye ra ako'dɔ, here zi ze tɔ'bɔ koma mï yï? A'di ra ako'dɔ? ");
INSERT INTO mgc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gɔ mo yada aba, mati zutu 'bezee ëdïnnï mï da lïpï, Wïrï ï'dï mana zi zë konyo. O'dɔ rë nï kaa mati wayöruwë iyannï henye, ‘Wïrï ï'dï mangɔlɔ'bɔ zi zë ta komorïyë zi konyo.’” ");
INSERT INTO mgc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yësu ayada zi zë henye, “Ma yada tïnyö zi ye henye, Mosa ra dë vïdï mati ï'dï mangɔlɔ'bɔ zi ye ta komorïyë. 'Bu ma ra ï'dï mangɔlɔ'bɔ tïnyö ne zi ye ta komorïyë. ");
INSERT INTO mgc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ehe mangɔlɔ'bɔ mati Wïrï ï'dï ne ëdï vïdï mati ayi akaŋo ta komorïyë zi dïdï kï'dï zi damöku.” ");
INSERT INTO mgc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Vïdï iyannï henye, “Kyedre, ï'dï zi ze mangɔlɔ'bɔ mati ɔrɔ dë nenye.” ");
INSERT INTO mgc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yësu aya'ba dɔ mo zi zë iya henye, “Ma ra mangɔlɔ'bɔ ma ï'dï dïdï. Vïdï ma ayi zi ma, atanza dë na o'bo. Vïdï ma ëdï koma aba mï ma atanza dë na kɔdrɔ. ");
INSERT INTO mgc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma yada ku nzɔ zi ye henye, onge ma mora gba anze dë koma aba mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vïdï biya mati 'Bu ï'dï zi ma atayi zi ma. More ma kölö maako tëmï zë dë. ");
INSERT INTO mgc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mayi dë ta komorïyë zi ko'dɔ wa mati momba. Mayi zi ko'dɔ wa mati 'Bu omba ma zi ko'dɔ. Mo utu ma, ");
INSERT INTO mgc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ehe mo omba zi ko'dɔ tïnyö ma kölö tëmï zë mati mo ï'dï zi ma ne ölu dë. Mo omba ma zi kïnjë zë zi dïdï mï ndundu 'ba ko'do aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Bu ma omba vïdï biya mati ongɔnnï Wisi, zi tëdï koma aba mï mo, ehe zi tëdï dïdï ma ŋburu aba. Here ma kïnjë zë zi dïdï mï ndundu ko'do aba.” ");
INSERT INTO mgc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vïdï ayetonnï hë nnï wasa ga kö'du Yësu iya henye, nï ra mangɔlɔ'bɔ mati ayi akaŋo ta komorïyë. ");
INSERT INTO mgc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Zë ako'jonnï ha oka ma kölö maako iyannï henye, “Mo anza Yësu ra dë, wisi 'ba Yosepa? Da yɔlɔ ze 'bu mo dë ma mo aba? Hala mo atɔ'bɔ kiya henye, nayi akaŋo ta komorïyë?” ");
INSERT INTO mgc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yësu ayada zi zë iya henye, “Ɔre ta bi me'do 'be ne! ");
INSERT INTO mgc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Vïdï maako ɔ'bɔ dë tayi zi ma, nje 'Bu mati utu ma ne o'dɔ zë komba zi tayi. Mora ëzë zë ayinnï, ma kïnjë zë na dïdï mï ndundu 'ba ko'do aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kölö tëmï Nëbïyë ayöru henye, ‘Wïrï akayandi zë biya.’ Here vïdï biya ma owonnï da 'Bu ehe ayandi kazi mo atayi zi ma. ");
INSERT INTO mgc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nje vïdï kölö mati ongɔ 'Bu ne mo ra ayi kazi Wïrï. Vïdï maako gba ongɔ 'Bu dë. ");
INSERT INTO mgc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ma yada zi ye tïnyö vïdï biya mati ëdïnnï koma aba mï mo, ëdïnnï dïdï ŋburu aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma mangɔlɔ'bɔ ma ï'dï dïdï! ");
INSERT INTO mgc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Zutu 'be onyonnï mana mï da lïpï ehe yaa, zë olinnï. ");
INSERT INTO mgc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mora kinye mangɔlɔ'bɔ 'ba komorïyë ne ayi ku akaŋo, here vïdï mati mo onyo ku oli dë. ");
INSERT INTO mgc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma ra mangɔlɔ'bɔ dïdï mati ayi akaŋo ta komorïyë. Ëzë vïdï mati onyo mangɔlɔ'bɔ nenye, mo akalima ŋburu. Mangɔlɔ'bɔ mati ma kï'dï zi mo ida ra ma ra, mëdï kï'dï zi vïdï 'ba damöku nenye zi tëdïnnï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zë ayetonnï hë nnï wasa oka ma kölö maako aba, ehe ako'jonnï kö'du iyannï henye, “Hala mo atɔ'bɔ kï'dï ida rë nï zi ze konyo?” ");
INSERT INTO mgc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yësu aya'ba dɔ mo iya henye, “Ma yada zi ye tïnyö, alime dë, nje ëzë onyowe ida ehe uwëë yama 'ba Wisi 'ba Vïdï. ");
INSERT INTO mgc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mora ëzë onyowe ida ma ehe uwëë yama ma, atëdïyë dïdï ma ŋburu aba, ehe ma kïnjëë na dïdï mï ndundu 'ba ko'do aba. ");
INSERT INTO mgc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ida ma wakonyo ma tïnyö ra, ehe yama ma wakuwë ma tïnyö ra. ");
INSERT INTO mgc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ëzë onyowe ida ma ehe uwëë yama ma, e kölö ma aba ehe ma kölö ëtï. ");
INSERT INTO mgc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kaa 'Bu wïdï ra utu ma, ehe mëdï dïdï aba ga kö'du 'bɔmo, vïdï biya mati onyonnï ida ma akalimannï ga kö'du 'bama. ");
INSERT INTO mgc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mangɔlɔ'bɔ mati ayi akaŋo ta komorïyë anza dë kaa wa mati zutu 'be onyonnï. Zë olinnï, mora vïdï mati onyo mangɔlɔ'bɔ nenye akalima ŋburu.” ");
INSERT INTO mgc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yësu ëdï kö'du yëtï mï bi 'ba mötu mï Kaparanamo mati mo iya kö'du nenyee. ");
INSERT INTO mgc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Vo lö'bö kayo 'ba Yësu owonnï mo ehe iyannï henye, “Kö'du yandi nenye ëdï ndra na kyigɔ zi vïdï maako yɔlɔ. Ëyï ra atɔ'bɔ yɔlɔ mo?” ");
INSERT INTO mgc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yësu ayɔlɔ henye, vo lö'bö 'bënïyë ëdïnnï ame'do na wayawaya. Here mo ako'jo iya henye, “Nenye o'de na riti? ");
INSERT INTO mgc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A'di ra ëzë onge Wisi 'ba Vïdï ëdï tï'bë rïyë komorïyë bi mati mo ayi ta 'dɔmo? ");
INSERT INTO mgc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lawo mo ra ï'dï dïdï. Kyigɔ 'ba vïdï köndu o'dɔ waako dë. Me'do mati ma me'do zi ye ne, ëdï tëmï Lawo 'ba Wïrï ma ï'dï dïdï. ");
INSERT INTO mgc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mora kya e maakowe ombannï dë zi tëdï koma aba mï ma.” Yësu iya nenye, ga kö'du tëmï biyeto aba mo ayɔlɔ ëyï ra atëdï koma aba mï nï. Mo ayɔlɔ kpa ëyï ra akasusu nï. ");
INSERT INTO mgc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yësu iya henye, “Kö'du nenye ra ma yada zi ye ɔ'be dë tayi zi ma, nje ëzë 'Bu ra o'de komba zi tayi.” ");
INSERT INTO mgc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ga kö'du wa mati Yësu iya, vo lö'bö kayo 'bɔmowe opi gë nnï zi mo ehe ɔrɔnnï ta bi lö'bö ga ndï mo. ");
INSERT INTO mgc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yësu ako'jo ha vo lö'bö 'bënï 'butë dɔmorïyö, “E kpa ombe zi kila ma?” ");
INSERT INTO mgc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Petero aya'ba dɔ mo iya henye, “Yere, vïdï maako anza dë ani zi ze tɔ'bɔ tï'bë zi mo. Me'do 'bëyï ï'dï dïdï ŋburu. ");
INSERT INTO mgc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yaanya aba dëdï koma aba mï yï, ehe da yɔlɔ ku yï ra Wisi Kölö Ŋbala 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yësu ayada zi vo lö'bö 'bënïyë henye, “Ma jeli ye 'butë dɔmorïyö, mora ma kölö tëmï yë dakyikyi.” ");
INSERT INTO mgc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yësu ëdï me'do kö'du 'ba Yudasi wisi 'ba Simona Sikereto. Mo yaa akasusu Yësu mo le kölö tëmï vo lö'bö 'butë dɔmorïyö. ");
INSERT INTO mgc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tapëtï ma nenye, Yësu ënyï tï'bë lasi aba mï Galilaya, mo omba dë tï'bë mï Yudiya, ga kö'du Yude ani ombannï zi kofo mo. ");
INSERT INTO mgc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ku kara zi kadra 'ba karama 'ba mbörögö, ");
INSERT INTO mgc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ehe önduwë 'ba Yësu iyannï zi mo henye, “Kö'du a'di ï'bë dë zi Yudiya? Here vo lö'bö 'bëyïyë atɔ'bɔnnï kongɔ wa mati ëdï ako'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vïdï maako o'dɔ waako dë na liwo, ëzë zë ombannï zi maakowe zi yɔlɔ kö'du zë. Here ï'dï damöku ma yɔlɔ wa ma ëdï ako'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gbï le önduwë 'ba Yësu gba ayinnï dë na vo lö'bö 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yësu aya'ba iya henye, “Kadra 'bama gba ayi dë, mora kadra 'be ëdï 'duwï kinye. ");
INSERT INTO mgc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vïdï 'ba damöku nenye ɔ'bɔnnï dë e kiyi. Zë iyinnï ma, ga kö'du ma yada nduwë zi zë henye, zë o'dɔnnï kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ï'bëë dagba mï karama. Kadra 'bama gba ɔkɔ dë, ehe mï'bë dë.” ");
INSERT INTO mgc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yësu iya nenye ehe alima zɔ mï Galilaya. ");
INSERT INTO mgc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tapëtï öndu 'ba Yësu ï'bënnï ku mï karama, mo ï'bë liwo kazi yada zi vïdï maako. ");
INSERT INTO mgc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mï kadra 'ba karama aba, vo dagbe 'ba Yude omannï Yësu ehe ako'jonnï kö'du henye, “Mo ëdï kila?” ");
INSERT INTO mgc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Vïdï kayo alëpïnnï mï ha wasa kö'du mo. Maakowe iyannï henye, “Yësu kora laka ra,” agamowe iyannï henye, “Mo ëdï ndɔndɔ kiga zi vïdï biya.” ");
INSERT INTO mgc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mora vïdïyë na tere kazi vo dagba 'bëzë, ehe vïdï maako ame'do dë ta da komo vïdï kayo kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mati karama ku kutë zi rë nï kinde, Yësu ï'bë mï yëkëlu ayeto wayandi. ");
INSERT INTO mgc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Vo dagbe na rakaga ehe iyannï henye, “Hala kora nenye ayɔlɔ kö'du takanyi here? Ayandi mo kpa dë.” ");
INSERT INTO mgc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yësu aya'ba dɔ mo iya henye, “Manza dë yandi wa mati ma sösu kö'du mo. Wa mati mëdï ayandi ayi kazi vïdï ma utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ëzë tïnyö ombe zi koro Wïrï, akayɔle wa mati ma yandi ayi kazi Wïrï mandere kazi ma. ");
INSERT INTO mgc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ëzë momba zi kika wakoro zi ma, ma kame'do kö'du ma. Mora momba zi koro vïdï ma utu ma. Nenye ra ma yada kö'du tïnyö anza dë ndɔndɔ. ");
INSERT INTO mgc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosa ra dë ï'dï kö'du kï'dï zi ye? Vïdï maako tëmï yë oro dë. Here kö'du a'di ombe zi ma kofo?” ");
INSERT INTO mgc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Vïdï kayo aya'bannï dɔ mo iyannï henye, “Yï vo dakyikyi! A'di ra o'dɔ yï zi kö'du sösu henye, vïdï maako omba zi kofo yï?” ");
INSERT INTO mgc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yësu aya'ba dɔ mo iya henye, “Mo'dɔ kö'du koro kölö ehe o'de na rakaga. ");
INSERT INTO mgc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosa ï'dï kö'du zi ye zi gisi kora 'be ŋbete. Mora tïnyö anza Mosa ra dë ï'dï kö'du kï'dï nenye zi ye. Zutu 'be ra. Mï ko'do 'ba ralawo aba aŋbetee gisi kora 'be ");
INSERT INTO mgc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","zi kö'du kï'dï 'ba Mosa koro. Ëzë wisi maako atɔ'bɔ ŋbete mï ko'do 'ba ralawo, kö'du a'di ra e na kamo ma aba ga kö'du vïdï maako ko'dɔ na laka mï ko'do 'ba ralawo? ");
INSERT INTO mgc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","O'de vurë dë dakyïnë 'ba ra laya aba. O'de wa mati tïnyö ra aba.” ");
INSERT INTO mgc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kya vïdï maakowe ta Yerusalema ëdï kiyannï henye, “Anza dë kora nenye ra zë ombannï zi kofo? ");
INSERT INTO mgc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Here mo ëdï gba zɔ kinye, me'do zi vïdï biya kowonnï. Ehe vïdï maako awasa hë nnï dë mo aba. Here ne kö'du sösu 'be aba vo dagbe ayɔlɔnnï ku tïnyö mo ra Korisitɔ? ");
INSERT INTO mgc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mora nani akatɔ'bɔ tëdï hala? Vïdï maako ayɔlɔ dë bi mati Korisitɔ ne atayi ta 'dɔmo, mora da yɔlɔ ze bi mati kora nenye ayi ta 'dɔmo.” ");
INSERT INTO mgc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mati Yësu ëdï kö'du yandi mï yëkëlu, mo agbögbö hë nï iya henye, “Tïnyö asösuwë ayɔle ma ku, ehe ta kila mayi ta 'dɔmo? Mayi dë na bi da ma! Vïdï mati utu ma ëdï tïnyö, ehe ayɔle mo dë. ");
INSERT INTO mgc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mora ma yɔlɔ vïdï mati utu ma, ga kö'du mayi kazi mo.” ");
INSERT INTO mgc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kya vïdï maakowe ombannï zi Yësu kïrï, mora du vïdï maako ï'dï kala nï dë dɔ mo, ga kö'du kadra 'bɔmo gba ɔkɔ dë. ");
INSERT INTO mgc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mora vïdï kayo mï kutë vïdï nee ï'dïnnï koma 'bënnï mï mo ehe iyannï henye, “Ëzë Korisitɔ ne ayi, mo ako'dɔ kyïnë 'ba kö'du korowe ndra ta da kora nenye?” ");
INSERT INTO mgc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mati Farasiye owonnï vïdï kayo ëdïnnï hë nnï wasa ga kö'du 'ba Yësu, zë ehe kyedree 'ba vo karase utunnï vo kanye 'ba yëkëlu zi mo kïrï. ");
INSERT INTO mgc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mora Yësu ayada zi zë iya henye, “Ma tëdï ëtï tisi na konda, ehe ma ta'ba zi vïdï mati utu ma ne. ");
INSERT INTO mgc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Akome ma, mora du aki'je ma dë. Ɔ'be dë tï'bë bi mati mëdï tï'bë 'dɔmo.” ");
INSERT INTO mgc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Vïdï ako'jonnï ha oka ma kölö maako henye, “Kila mo atɔ'bɔ tï'bë zi sesi ze ta bi nï ki'ja? Mo ëdï tï'bë mï dakaŋo mënzë maakowe mati vïdï 'bezee ëdïnnï alima? Mo ëdï tï'bë ani zi vïdïyë 'ba Gïrïgï yandi? ");
INSERT INTO mgc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A'di ra mï me'do 'bɔmo mati mo iya henye, da koma ze nï mora di'ja nï dë? Kö'du a'di da tɔ'bɔ dë tï'bë bi mati mo ëdï tï'bë?” ");
INSERT INTO mgc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mï ndundu mo ehe mï ko'do kyedre 'ba karama, Yësu ɔrɔ rïyë ehe agbögbö hë nï iya henye, “Ëzë ëdïyë kɔdrɔ aba, ayiye zi ma ehe uwëë! ");
INSERT INTO mgc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ëdïyë koma aba mï ma, atëdïyë wini ma ï'dï dïdï, taho tëmï yöndu 'ba mï yë, kaa wayöruwë iyannï henye.” ");
INSERT INTO mgc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yësu ëdï ame'do kö'du 'ba Lawo Laka, mati akï'dï zi vïdï biya mati ëdïnnï koma aba mï mo. Lawo ne gba ï'dï dë zi vïdï kölö maako, kyere Yësu gba ï'dï bikanyi kyedre 'bënï dë ndɔ. ");
INSERT INTO mgc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mati vïdï kayo owonnï Yësu iyannï nenye, kya maakowe iyannï henye, “Mo atëdï Nëbï ra.” ");
INSERT INTO mgc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Agamowe iyannï henye, “Mo Korisitɔ ra.” Agamowe iyannï kpa henye, “Korisitɔ ne atɔ'bɔ tayi ta Galilaya? ");
INSERT INTO mgc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wayöruwë iyannï henye, Korisitɔ atayi tëmï dakota 'ba Yere Dawidi. Here kö'du nenye gɔ mo ya'ba aba, ako'jo mo mï Beteleme, mï gawo mati Dawidi alima 'dɔmo?” ");
INSERT INTO mgc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Vïdï ayetonnï me'do ra oka ma kölö maako ga kö'du 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kya zë maakowe ombannï zi mo kïrï, mora du vïdï maako ï'dï kala nï dë dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mati vo kanye 'ba yëkëlu a'bannï zi kyedree 'ba vo karase ehe Farasiye, ako'jo hë zë henye, “Kö'du a'di ike Yësu dë kinye?” ");
INSERT INTO mgc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Zë aya'bannï henye, “Vïdï maako gba ame'do dë kaa kora nenye.” ");
INSERT INTO mgc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farasiye iyannï zi zë henye, “Mo o'dɔ lumë kpa ku re? ");
INSERT INTO mgc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ma kölö tëmï kyedree 'ba vo karase mandere Farasiye ëdï koma aba mï mo? ");
INSERT INTO mgc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ehe vïdï nenyee mati ayɔlɔnnï kö'du kï'dï dë, zë hu wasënë 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodïmö mati ï'bë zi Yësu dagba, ehe mo kölö tëmï vo dagbe 'ba Yude, iya henye, ehe mo ra kpa kyere ayi zi Yësu kongɔ. Mo iya henye, ");
INSERT INTO mgc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kö'du kï'dï 'beze ila ze dë zi riti kï'dï zi vïdï gba kazi ze kowo wa ma zë ombannï kiya. Dɔ'bɔ dë vurë 'bëzë ko'dɔ gba kazi ze yɔlɔ a'di ra zë o'dɔnnï.” ");
INSERT INTO mgc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Zë iyannï henye, “Nikodïmö, yï tëmï Galilaya? Ako'jo wayöru nee, ehe aki'ja henye, nëbï ako anza dë zi tayi ta Galilaya.” ");
INSERT INTO mgc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Vïdï biya ï'bënnï gbɔ liŋɔ 'bënnï na kutu kutu. ");
INSERT INTO mgc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mora Yësu ï'bë yaga zi Döku 'ba Olivo. ");
INSERT INTO mgc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Damïndö vere aba ŋbɔ mo ï'bë zi yëkëlu. Vïdï ayinnï zi mo, mo alima akaŋo ehe ayeto zë yandi. ");
INSERT INTO mgc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Vo komoyandiye 'ba kö'du kï'dï ehe Farasiye ikannï loko mbara maako ïrï ta bi ndoro ko'dɔ, ehe zë o'dɔnnï mo atɔrɔ komo nnï biya. ");
INSERT INTO mgc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Here zë iyannï henye, “Raboni, mbara nenye ïrï ëdï ko'do kora maako aba anza o'di 'bɔmo ra dë. ");
INSERT INTO mgc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kö'du kï'dï 'ba Mosa ayandi henye, mbara kaa ma nenye zi ku'du brua yïtö aba. A'di ra iya?” ");
INSERT INTO mgc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Zë ako'jonnï ha Yësu, kö'du ko'jo nenye aba, ga kö'du zë ombannï mo susu ehe zi kö'du kyënyë maako kika rɔ mo. Mora Yësu ïdë rë nï ayeto wayöru dakaŋo dawisi kala nï aba. ");
INSERT INTO mgc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Zë asesinnï zɔ nduwë hɔ mo ko'jo kö'du 'ba mbara ne. Ndundu mo aba mo ɔrɔ rïyë iya henye, “Ëzë vïdï maako tëmï yë o'dɔ kö'du kyënyë dë mu'du dagba yïtö dɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mo ïdë rë nï kpa löhu ayeto wayöru dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Vïdï nee ï'bënnï biya na kölö kölö, ayeto ma tendro mo aba. Ndundu mo aba Yësu mbara ne aba ɔsɔnnï kutu nnï aba. ");
INSERT INTO mgc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yësu ɔrɔ rïyë ako'jo hɔ mo iya henye, “Vïdï nee biya kila? Vïdï maako anza kpe zi yï susu?” ");
INSERT INTO mgc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mbara ne aya'ba dɔ mo iya henye, “Ee Kyedre, vïdï maako anza dë.” Yësu ayada zi mo iya henye, “Manza dë kpa tï'bë zi yï susu. Ï'bë yaanya aba, o'dɔ kö'du kyënyë dekpe.” ");
INSERT INTO mgc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kpa löhu Yësu ame'do zi vïdïyë. Kadra nenye aba mo iya henye, “Ma ra bikanyi kö'du damöku. Usu ga ma, ehe alasi dë mï biköndu. Akatëdï bikanyi ma akï'dï dïdï aba.” ");
INSERT INTO mgc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farasiye iyannï zi mo henye, “Yï ra nje vïdï ma ëdï ame'do kö'du yï, ehe anza dë tïnyö na laka zi yï ra tëdï akpa na vo kiya 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yësu aya'ba dɔ mo iya henye, “Here ëzë ma me'do le kö'du ma, wa ma miya ëdï tïnyö. Ma yɔlɔ ku mayi ta kila ehe mëdï tï'bë kila. Mora ayɔle dë ma ta kila mandere mëdï tï'bë kila. ");
INSERT INTO mgc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","O'de vurë tëmï gërï kölö mati vïdï biya o'dɔnnï, mora mo'dɔ vurë 'ba vïdï maako dë. ");
INSERT INTO mgc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ëzë mo'dɔ vurë, ma ko'dɔ na laka, ga kö'du ma ko'dɔ dë kutu ma aba. 'Bu mati utu ma ne ëdï kinye ma aba. ");
INSERT INTO mgc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kö'du kï'dï 'be omba vo kiya rïyö zi yada kö'du ne ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma kölö tëmï vo kiya 'bame, ehe 'Bu mati utu ma ëdï agamo maako.” ");
INSERT INTO mgc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Zë ako'jonnï hɔ mo iyannï henye, “'Bu yï ëdï kila?” Yësu aya'ba dɔ mo iya henye, “Ayɔle ma dë mandere 'Bu ma. Ëzë ayɔle ma, akayɔle 'Bu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yësu iya nenye mati mo ëdï gba kö'du yandi mï bi ma söndu 'ba wakï'dï 'ba yëkëlu asesi 'dɔmo. Mora vïdï maako ïrï mo dë ga kö'du kadra 'bɔmo gba ayi dë. ");
INSERT INTO mgc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yësu ayada kpa zi vo dagbe 'ba yënï henye, “Mëdï tï'bë 'de akome ma, mora ɔ'be dë tï'bë bi mati mëdï atï'bë, akoliye kö'du kyënyë 'be kazi wakila.” ");
INSERT INTO mgc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Vïdï ako'jonnï kö'du iyannï henye, “Mo omba zi rë nï kofo? Ëdï nani wa ma mo iya henye, dɔ'bɔ dë tï'bë bi mati mo ëdï tï'bë?” ");
INSERT INTO mgc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yësu aya'ba dɔ mo iya henye, “Ëdïyë ta lebi, mora ma ta rïyë. E 'ba damöku nenye, mora manza dë 'ba damöku nenye. ");
INSERT INTO mgc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kö'du nenye ra miya akoliye kö'du kyënyë 'be aba. Ëzë anze dë koma aba mï ma, kö'du ëyï mëdï, akoliye mï kö'du kyënyë 'be ila dë.” ");
INSERT INTO mgc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Zë ako'jonnï ha Yësu iyannï henye, “Yï 'bëyï ëyï?” Yësu aya'ba dɔ mo iya henye, “Ma ra te mati ma yada zi ye biyeto aba. ");
INSERT INTO mgc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ani kö'du ëdï kyɔ ma tɔ'bɔ kiya zi yada henye o'de kö'du kyënyë, mora vïdï mati utu ma ëdï tïnyö, ehe ma yada zi vïdï 'ba damöku nenye nje wa mati mowo kazi mo.” ");
INSERT INTO mgc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Vïdï maako ayɔlɔ dë Yësu ëdï ame'do zi zë kö'du 'Bu nï. ");
INSERT INTO mgc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yësu ï'bë nduwë kiya mo aba henye, “Ëzë umbëë Wisi 'ba Vïdï ku rïyë, akayɔle ëyï ra ma. Akayɔle kpa henye manza dë wa maako ko'dɔ na bi da ma. Miya nje wa mati 'Bu ma ayandi zi ma. ");
INSERT INTO mgc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mo mati utu ma ëdï ma aba. 'Duwï mo'dɔ wa mati o'dɔ mo na rakyenyi ehe mo ila ma dë.” ");
INSERT INTO mgc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tapëtï Yësu iya nenye, vïdï kayo omannï mï mo. ");
INSERT INTO mgc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yësu ayada zi vïdï mati ëdïnnï koma aba mï nï henye, “Ëzë asesiye nduwë koro wa mati miya, e tïnyö vo lö'bö 'bama ra. ");
INSERT INTO mgc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Akayɔle kö'du tïnyö, ehe kö'du tïnyö akinge na dangölö.” ");
INSERT INTO mgc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Zë aya'bannï dɔ mo iyannï henye, “Ze gisi 'ba Abarayama! Danza dë gba na vo kalima 'ba vïdï maako. Hala atɔ'bɔ kiya akinga ze na dangölö?” ");
INSERT INTO mgc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yësu aya'ba dɔ mo iya henye, “Ma yada tïnyö zi ye, vïdï ma o'dɔ kö'du kyënyë ëdï vo kalima 'ba kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Vo kalime, alimannï dë ŋburu mï dakota, ëzë wisi alese le 'duwï mï dakota. ");
INSERT INTO mgc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ëzë Wisi ï'dï zi ye dangölö, tïnyö aba e na dangölö. ");
INSERT INTO mgc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma yɔlɔ ku, e tëmï dakota 'ba Abarayama, mora ombe zi ma kofo, ga kö'du, kö'du kise 'bama anza dë tïnyö mï di'di ye. ");
INSERT INTO mgc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mëdï ame'do kö'du wa mati 'Bu ma ayada zi ma, te kaa mati ëdïyë ako'dɔ wa mati 'bu wë ayandi zi ye.” ");
INSERT INTO mgc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Vïdï iyannï zi Yësu henye, “Abarayama ra 'bu ze!” Yësu aya'ba dɔ mo iya henye, “Ëzë e gisi 'ba Abarayama, o'de wa mati Abarayama o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tapëtï mo ombe zi ma kofo ta bi kö'du tïnyö yada zi ye mati Wïrï ï'dï zi ma. Abarayama o'dɔ waako dë kaa ma nani. ");
INSERT INTO mgc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mora ëdï ko'de te wa mati 'bu wë o'dɔ.” Zë iyannï henye, “Asusu ze dë zi kiya dëdï kpa 'bu maako aba. Dëdï nje 'bu aba kölö, mo ra Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yësu iya zi zë henye, “Ëzë Wïrï ra 'Bu wë, ɔwe ma, ga kö'du mayi kazi Wïrï yaanya aba mëdï kinye. Mo ra utu ma. Mayi dë na bi da ma. ");
INSERT INTO mgc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kö'du a'di ra ayɔle kö'du mati mëdï ame'do kö'du mo dë? Ɔ'be dë tɔrɔ zi kowo kö'du mati mëdï akiya? ");
INSERT INTO mgc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Bu wë ra Satani, ehe o'de te wa mati mo omba. Mo 'duwï vo wakofo ehe vo ndɔndɔ. Kö'du tïnyö ako anza dë kö'du mo. Mo ame'do kö'du nï, ehe kö'du biya mati mo iya ndɔndɔ ra. Anza dë nje mo ra na vo ndɔndɔ, mora mo kpa 'bu 'ba vo ndɔnde biya. ");
INSERT INTO mgc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ga kö'du ma yada zi ye kö'du tïnyö, e ombe dë zi tëdï koma aba mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Vïdï maako tëmï yë atɔ'bɔ ma susu ga kö'du kyënyë ko'dɔ? Ëzë ma yada kö'du tïnyö, kö'du a'di ra ome dë mï ma? ");
INSERT INTO mgc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Vïdï mati 'ba Wïrï akoze mbili nï da kö'du kise 'bɔmo, mora ombe dë zi kowo, ga kö'du anze dë 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yude aya'bannï zi Yësu henye, “Dëdï ze tïnyö aba zi kiya henye, yï vïdï 'ba Samariya ra, ehe ëdï dakyikyi aba mï yï?” ");
INSERT INTO mgc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yësu aya'ba dɔ mo iya henye, “Manza dë dakyikyi aba mï ma. Moro 'Bu ma, ehe ombe dë zi koro ma. ");
INSERT INTO mgc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Momba wakoro dë ga kö'du ma, mora vïdï maako ëdï ani omba zi ma tëdï na wakoro, ehe mo ra kpa 'ba vurë ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ma yada tïnyö zi ye henye, ëzë orowe me'do 'bama du akoliye dë.” ");
INSERT INTO mgc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vïdï iyannï henye, “Yaanya aba tïnyö da yɔlɔ ku ëdï dakyikyi aba. Abarayama oli ehe nëbïyë kpa. Hala ɔ'bɔ kiya henye, vïdï mati oro me'do 'bëyï oli dë? ");
INSERT INTO mgc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yï kyedre ta da 'bu ze Abarayama? Mo oli ehe nëbïyë kpa. Ëyï ra asösu 'bëyï yï?” ");
INSERT INTO mgc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yësu aya'ba dɔ mo iya henye, “Ëzë moro ra ma, o'dɔ waako dë. 'Bu ma ra vïdï ma oro ma. Iye henye mo Wïrï 'be ra. ");
INSERT INTO mgc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gbï le tïnyö ayɔle mo dë, mora ma yɔlɔ mo. Ëzë miya ma yɔlɔ mo dë, ma tëdï na vo ndɔndɔ kpa kaa e biya. Mora ma yɔlɔ mo, ehe mo'dɔ wa mati mo iya. ");
INSERT INTO mgc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Bu wë Abarayama ëdï rakyenyi aba zi kongɔ kadra tayi 'bama, mo ongɔ ma ehe ëdï na rakyenyi.” ");
INSERT INTO mgc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Zë iyannï henye, “Anza kpa dë kɔɔ 'butëmuyï aba. Hala ɔ'bɔ kongɔ Abarayama?” ");
INSERT INTO mgc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yësu aya'ba dɔ mo iya henye, “Ma yada tïnyö zi ye, gba Abarayama anza dë, mëdï.” ");
INSERT INTO mgc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Vïdï obannï yïtö rïyë zi Yësu kofo, mora mo oho rë nï ehe ila yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mati Yësu alasi na konda, mo ongɔ kora maako na komoköndu kyere mati o'jo. ");
INSERT INTO mgc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vo lö'böwë 'ba Yësu ako'jonnï henye, “Raboni, kö'du a'di ra kora nenye o'jo na komoköndu? Ëdï ga kö'du mo, mandere vo ko'jo mowe o'dɔnnï kö'du kyënyë?” ");
INSERT INTO mgc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yësu aya'ba dɔ mo iya henye, “E e, anza here dë. Mora ga kö'du komoköndu 'bɔmo, akonge Wïrï ako'dɔ kö'du koro zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ëzë ëdï kadra, do'de wa mati vïdï ma utu ma omba ma zi ko'dɔ. Ëzë yɔndɔ ɔkɔ ku, vïdï maako ɔ'bɔ dë zi lɔɔ ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mati mëdï mï damöku, ma bikanyi ra zi damöku.” ");
INSERT INTO mgc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tapëtï Yësu iya nenye, mo o'bi oro dakaŋo. Mo o'dɔ kɔrɔ ehe ora komo kora ne. ");
INSERT INTO mgc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Here mo iya henye, “Ï'bë akaka kɔrɔ ne mï Kara Siliyɔma.” Kora ne ï'bë ehe akaka mï Siliyɔma. Kö'du ya'ba aba, “Vïdï ma utu, akutu.” Mati mo akaka kɔrɔ ne ku yaga mo ɔ'bɔ bi kongɔ. ");
INSERT INTO mgc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Vo haliŋɔ oka 'bɔmowe, ehe vïdï mati ongɔnnï mo ta bi lenze kyere ne, ako'jonnï kö'du henye, “Nenye anza dë kora mati ëdï alima akaŋo ehe 'duwï alenze?” ");
INSERT INTO mgc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kya zë maakowe iyannï henye, mo ra gbï te kora vo lenze ne, agamowe iyannï henye, mo andele nje kaa mo. Mora mo ayada zi zë, “Ma kora nani ra.” ");
INSERT INTO mgc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Zë ako'jonnï hɔ mo henye, “Hala ɔ'bɔ bi kongɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mo aya'ba dɔ mo iya henye, “Vïdï maako ru mo Yësu o'dɔ kɔrɔ ehe ora komo ma. Mo ayada zi ma tï'bë kaka mï Kara Siliyɔma. Mati mo'dɔ, mɔ'bɔ bi kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Zë ako'jonnï kö'du henye, “Mo ëdï kila yaanya aba?” Mo aya'ba dɔ mo iya henye, “Ma yɔlɔ dë.” ");
INSERT INTO mgc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ko'do mati Yësu o'dɔ kɔrɔ ne ehe akɔ'jɔ kora ne, mï ko'do 'ba ralawo. Here vïdï obannï kora ne zi Farasiye. ");
INSERT INTO mgc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Zë ako'jonnï hɔ mo hala mo ɔ'bɔ zi bi kongɔ, ehe mo aya'ba henye, “Yësu o'dɔ kɔrɔ ehe ora komo ma. Tapëtï ma kaka, mɔ'bɔ bi kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kya 'ba Farasi maakowe iyannï henye, “Kora nenye Yësu ayi dë kazi Wïrï. Ëzë mo o'dɔ here, mo ɔ'bɔ dë kowe kö'du kï'dï 'ba ko'do madɔmorïyö.” Agamowe ako'jonnï henye, “Hala vïdï 'ba kö'du kyënyë atɔ'bɔ ko'dɔ kyïnë 'ba kö'du korowe?” Here Farasiye ɔ'bɔnnï dë kö'du kida tëmï kutë nnï, ");
INSERT INTO mgc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","zë ako'jonnï ha kora ne iyannï henye, “A'di ra iya, kö'du vïdï mati akɔ'jɔ komo yï ne?” Kora ne ayada zi zë iya henye, “Mo nëbï ra.” ");
INSERT INTO mgc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mora vo dagbe 'ba Farasiye omannï dë henye, kyere kora ne ëdï na vo komoköndu. Zë utunnï lïtu zi vo ko'jo mowe, ");
INSERT INTO mgc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ehe ako'jonnï hë zë henye, “Nenye wisi mati iye henye, o'jo na komoköndu? Hala mo ɔ'bɔ bi kongɔ yaanya aba?” ");
INSERT INTO mgc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Vo ko'jo 'ba kora ne aya'bannï dɔ mo henye, “Da yɔlɔ ku tïnyö mo wisi 'beze ra, ehe da yɔlɔ ku o'jo mo na komoköndu. ");
INSERT INTO mgc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mora da yɔlɔ dë hala mo i'ja komo nï mandere ëyï ra ï'dï komo zi mo. Ako'jowe hɔ mo! Mo övu ku kyedre zi me'do ga kö'du nï.” ");
INSERT INTO mgc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Vo ko'jo 'ba kora nenye iyannï here, ga kö'du zë erennï Yude. Vo dagbe 'ba Yude idannï kö'du ku nzɔ henye, vïdï maako manza dë wa maako aba zi ko'dɔ zi vïdï maako mati mo iya Yësu ra Korisitɔ ne. ");
INSERT INTO mgc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vo dagbe ako'jonnï kora ne hulëhu iyannï henye, “Ï'dï wayeto zi Wïrï! Da yɔlɔ ku Yësu vo kö'du kyënyë ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kora ne aya'ba henye, “Ma yɔlɔ dë, ëzë mo vo kö'du kyënyë mandere anza dë. Biya ma yɔlɔ henye, ma kyere vo komoköndu, mora yaanya aba mɔ'bɔ bi kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Zë ako'jonnï hɔ mo henye, “A'di ra mo o'dɔ zi yï? Hala mo akɔ'jɔ komo yï?” ");
INSERT INTO mgc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kora ne aya'ba dɔ mo iya henye, “Ma yada ku zi ye da kölö, ehe ombe dë zi kowo. Kö'du a'di ra ombe zi ma yada zi ye löhu? Ombe kpa zi tayi na vo lö'bö 'bɔmowe?” ");
INSERT INTO mgc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Vo dagbe alidinnï kora ne, ehe iyannï henye, “Yï vo lö'bö 'bɔmo! Ze vo lö'bö 'ba Mosa. ");
INSERT INTO mgc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tïnyö da yɔlɔ Wïrï ame'do zi Mosa, mora du da yɔlɔ dë Yësu ayi ta kila.” ");
INSERT INTO mgc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kora ne aya'ba da me'do iya henye, “Kö'du koro a'di ra here! Mo akɔ'jɔ komo ma, ehe gba ayɔle dë mo ayi ta kila. ");
INSERT INTO mgc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Da yɔlɔ ku henye, Wïrï owo nje me'do 'ba vïdï mati ɔwɔnnï ehe oronnï mo. Wïrï owo me'do 'ba vo kö'du kyënyë ko'de dë. ");
INSERT INTO mgc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ehe nenye ëdï dagba kadra mï vurë, vïdï maako ï'dï komo zi vïdï maako o'jo na komoköndu. ");
INSERT INTO mgc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yësu ɔ'bɔ dë zi wa maako ko'dɔ, nje ëzë mo ayi kazi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vo dagbe ayadannï zi kora ne henye, “Yï na vo kö'du kyënyë ko'dɔ kyere mï kadra mati o'jo yï. Asösu 'bëyï atɔ'bɔ yandi ze wa maako aba?” Here zë iyannï henye, “Ɔ'bɔ dekpe tayi hulëhu mï bi 'ba mötu 'beze kölö maako!” ");
INSERT INTO mgc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mati Yësu owo kö'du mati o'dɔ rë nï ne, mo ï'bë i'ja kora ne. Yësu ako'jo hɔ mo iya henye, “Ëdï koma aba mï Wisi 'ba Vïdï?” ");
INSERT INTO mgc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mo aya'ba dɔ mo iya henye, “Kyedre, ëzë ayada zi ma mo ëyï ra, ma kï'dï koma 'bama mï mo.” ");
INSERT INTO mgc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yësu aya'ba henye, “Ongɔ mo ku nzɔ, ehe yaanya aba mo ëdï me'do yï aba.” ");
INSERT INTO mgc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kora ne iya henye, “Yere, mï'dï koma 'bama mï yï.” Here mo amötu Yësu gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yësu ayada zi mo, “Mayi mï damöku nenye, zi vurë 'ba vïdïyë ko'dɔ. Ma kinye zi kï'dï komo zi vo komokönduwë ehe zi ko'dɔ vïdï vo komoköndu biya mati atɔ'bɔ bi kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mati Farasiye owonnï Yësu iya nenye, zë ako'jonnï henye, “Ze vo komoköndu?” ");
INSERT INTO mgc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yësu aya'ba dɔ mo iya henye, “Ëzë ëdïyë na vo komoköndu, atanze dë mï kö'du kyënyë. Mora yaanya ëzë aba iye zi bi kongɔ, akasesiye kö'du kyënyë nduwë.” ");
INSERT INTO mgc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yësu iya henye, “Ma yada tïnyö zi ye, nje vo logo ehe vo wakolɔ ëkyï ta da resi. Zë ödunnï dë kpuru ta haresi zi jɔlɔ 'ba tïmëlë. ");
INSERT INTO mgc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Vïdï mati ödu kpuru ta haresi, mo ra vo yako 'ba tïmëlë. ");
INSERT INTO mgc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mora vo ga haresi kongɔ ayëhu haresi zi vo yako tïmëlë, ehe tïmëlë ayɔlɔnnï gu vo yako 'bënnï. Mo ako'jo tïmëlë 'bënï ru zë aba, ehe alaga dagba zi zë yaga. ");
INSERT INTO mgc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mati mo ayasi tïmëlë 'bënï nee ku biya yaga, mo ï'bë dagba da komo zë, ehe zë usunnï gɔ mo, ga kö'du zë ayɔlɔnnï gu mo. ");
INSERT INTO mgc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tïmëlë usu ga vo leze maakowe dë. Zë ayɔlɔnnï gu vo leze dë, ehe zë ahonnï 'de.” ");
INSERT INTO mgc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yësu ayada komo nenye zi vïdïyë, mora zë ayɔlɔnnï dë a'di ra mo ëdï ame'do kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Here Yësu iya löhu, “Ma yada tïnyö zi ye henye, ma haresi zi tïmëlë. ");
INSERT INTO mgc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vïdï mati ayi dagba ta komo ma, vo logo ra mandere vo wakolɔ, ehe tïmëlë owo da ma kölö tëmï zë ne dë. ");
INSERT INTO mgc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma haresi ra. Zë biya mati ayinnï kpuru ta da ma, akayɔmɔ. Zë atayinnï, atï'bënnï, ehe aki'jannï loma. ");
INSERT INTO mgc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vo logo ayi nje zi kolɔ, kofo, ehe yaŋa. Mayi zi vïdï biya tëdïnnï dïdï aba, ehe zi tëdïnnï mo aba ndɔ. ");
INSERT INTO mgc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ma vo tïmëlë yako laka ra. Vo tïmëlë yako laka ï'dï dïdï nï kö'du tïmëlë 'bënï. ");
INSERT INTO mgc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Vo lɔɔ ko'dɔ anzannï dë kaa vo tïmëlë yako mati tïmëlë na 'bɔmo. Ëzë ongɔnnï wölïwölï atayi, zë aho wënnï ilannï tïmëlë. Here wölïwölï ïrï ehe apere tïmëlë nee. ");
INSERT INTO mgc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Vo lɔɔ ko'dɔ aho wënnï 'de ga kö'du zë asösunnï kö'du 'ba tïmëlë nee dë. ");
INSERT INTO mgc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ma vo tïmëlë yako laka ra. Ma yɔlɔ tïmëlë ame, ehe zë ayɔlɔnnï ma, ");
INSERT INTO mgc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kpa kaa 'Bu ayɔlɔ ma, ma yɔlɔ 'Bu, ehe mï'dï dïdï ma kö'du tïmëlë ama. ");
INSERT INTO mgc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mëdï tïmëlë maako ëtï anzannï dë tëmï jɔlɔ 'ba tïmëlë nenye. Ma kika zë kpa ga bi kölö, ehe zë akowonnï gu ma. Here atëdïnnï gɔli kölö 'ba tïmëlë ehe vo yako kölö. ");
INSERT INTO mgc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“'Bu ɔwɔ ma ga kö'du mï'dï dïdï ma, here ma kïrï hulëhu löhu. ");
INSERT INTO mgc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Vïdï maako oba dïdï ma dë kazi ma. Ma ra mï'dï mï kö'du komba 'bama. Mëdï kyigɔ aba zi kï'dï, ehe kyigɔ aba zi kïrï hulëhu löhu, kaa mati 'Bu ma ï'dï kö'du mo zi ma zi ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mati zë owonnï me'do 'ba Yësu ne, Yude inye mï nnï. ");
INSERT INTO mgc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Maakowe kyɔ tëmï zë iyannï henye, “Mo ëdï dakyikyi aba mï nï. Mo vo lökyï ra. Kö'du a'di zi mbili koze zi mo?” ");
INSERT INTO mgc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mora agamowe iyannï henye, “Hala vïdï mati dakyikyi aba mï nï atɔ'bɔ kiya kö'du nenyee? Vïdï maako anza dë kaa nenye zi tɔ'bɔ vo komokönduwë kï'dï zi bi kongɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mï tona nani, Yësu ëdï mï Yerusalema kö'du karama 'ba yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kadra maako aba, mo ëdï alasi mï kapa 'ba yëkëlu sënjë 'ba Solomono ");
INSERT INTO mgc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ehe Yude atɔtɔ rë nnï toko rɔ mo. Zë iyannï henye, “Hala na konda omba tï'bë ze sesi kö'du sösu aba? Ëzë yï Korisitɔ ra, ayada zi ze huwë.” ");
INSERT INTO mgc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yësu aya'ba dɔ mo iya henye, “Ma yada zi ye, ehe ombe dë zi koma kö'du 'bama. Wa mati mo'dɔ kalakonda 'ba 'Bu ma aba, ayada ëyï ra ma. ");
INSERT INTO mgc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mora kyere anze dë tïmëlë ama, ome kö'du 'bama dë. ");
INSERT INTO mgc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tïmëlë ama owonnï gu ma, ehe ma yɔlɔ zë. Zë usunnï ga ma. ");
INSERT INTO mgc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mï'dï dïdï ma ŋburu zi zë, here kazi zë ölunnï. Vïdï maako akoba zë dë yaga ta kala ma. ");
INSERT INTO mgc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'Bu ma ï'dï zë zi ma, ehe mo kyedre ta da agamowe biya. Vïdï maako ɔ'bɔ dë zë koba ta kala mo ");
INSERT INTO mgc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma kölö 'Bu aba.” ");
INSERT INTO mgc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kpa löhu vo dagbe 'ba Yude obannï yïtö kö'du zi Yësu kofo. ");
INSERT INTO mgc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mora mo iya henye, “Ma yada wa laka kyɔ zi ye mati 'Bu ma utu ma zi ko'dɔ. Ma vala ra ombe ma ku'du gɔ mo yïtö aba?” ");
INSERT INTO mgc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zë aya'bannï dɔ mo iyannï henye, “Danza dë yï ku'du yïtö aba ga kö'du wa laka mati o'dɔ. Dëdï yï ku'du yïtö aba ga kö'du alidi Wïrï. Yï öŋbö vïdï ra, ehe kinye ëdï akiya zi tëdï na Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yësu aya'ba dɔ mo iya henye, “Mï wayöru 'be, Wïrï iya dë henye, ‘E wïrï mbiya ra?’ ");
INSERT INTO mgc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɔ'be dë he wasa wayöru aba, mati mï mo Wïrï ame'do zi vïdï naniye ehe ako'jo zë wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Here kö'du a'di asusuwë ma lidi Wïrï ga kö'du miya henye ma Wisi 'ba Wïrï? Tapëtï mo biya, ëdï 'Bu ra akɔ'jɔ ma kö'du lɔɔ nenye. Mo ra kpa vïdï mati utu ma mï damöku. ");
INSERT INTO mgc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ëzë manza dë ako'dɔ wa mati 'Bu ma omba ma zi ko'dɔ, neene ome dë mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mora ëzë mo'dɔ wa mati 'Bu ma o'dɔ, akome ga kö'du nani, gbï le ëzë anze dë koma aba mï ma. Neene akayɔle tïnyö henye, 'Bu ëdï kölö ma aba, ehe ma kölö 'Bu aba.” ");
INSERT INTO mgc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Löhu zë ombannï zi Yësu kïrï. Yësu anza dë hu kyigɔ 'bëzë. Ï'bë yaga ta kala zë. ");
INSERT INTO mgc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mo umu kyëtï Ranga Yeredene bi mati Yowani ëdï kyere bapatisi kï'dï. Mati Yësu ëdï ani, ");
INSERT INTO mgc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","vïdï kayo ayinnï zi mo. Zë ëdïnnï akiya henye, “Yowani o'dɔ kyïnë 'ba kö'du koro maakowe dë, mora kö'du biya mati mo iya kö'du 'ba Yësu ëdï tïnyö.” ");
INSERT INTO mgc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Vïdï kayo naniye ï'dï koma 'bënnï kpa mï Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kora maako ru mo Lazara alëpï na kɔɔ mï gawo 'ba Beteniya. Mo ëdï ëmï aba rïyö, Mariya ehe Marita. ");
INSERT INTO mgc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nenye kpa te Mariya mati yaa ope yënïngutru da Yere ehe akyitɔ burutu mo yëvu 'bënï aba. ");
INSERT INTO mgc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ëmïyë utunnï kö'du kise zi Yësu ehe ayadannï zi mo aboka laka 'bɔmo Lazara ëdï na rakɔɔ. ");
INSERT INTO mgc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mati Yësu owo kö'du nenye iya henye, “Kɔɔ 'bɔmo ne ndundu mo anza dë koli, mora ëdï zi kika wayeto zi Wïrï ehe Wisi ɔmo.” ");
INSERT INTO mgc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yësu ɔwɔ Marita, ëmï mo ehe Lazara. ");
INSERT INTO mgc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Here mati mo owo mo ëdï na kɔɔ alima bi mati mo ëdï 'dɔmo ko'do rïyö aba löhu. ");
INSERT INTO mgc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Neene mo iya zi vo lö'bö 'bënïyë henye, “Yaanya aba dï'bëë hulëhu Yudiya.” ");
INSERT INTO mgc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Zë iyannï henye, “Raboni, vïdï naniye ombannï zi ku'du yï yïtö aba brua! Kö'du a'di omba zi tï'bë hulëhu?” ");
INSERT INTO mgc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yësu aya'ba henye, “Kadra anza dë 'butë dɔmorïyö mï ko'do kölö? Ëzë alasi mï kadra, bikanyi 'bëyï atëdï kazi kadra ehe otra ndï yï dë. ");
INSERT INTO mgc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mora ëzë alasi yɔndɔ aba, akotra ndï yë ga kö'du anza dë bikanyi maako aba.” ");
INSERT INTO mgc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Neene mo ayada zi zë henye, “Aboka ze Lazara ëdï ako'do, ehe mëdï tï'bë ani zi mo liro.” ");
INSERT INTO mgc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Zë aya'bannï henye, “Yere ëzë mo ëdï ako'do, mo atënyï na laka.” ");
INSERT INTO mgc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yësu ëdï ame'do tïnyö kö'du koli 'ba Lazara, mora vo lö'böwë asösu 'bënnï mo ëdï nje ame'do kö'du 'ba ko'do. ");
INSERT INTO mgc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Here Yësu ayada zi zë huwë, “Lazara oli ku. ");
INSERT INTO mgc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma rakyenyi aba manza dë ani, ga kö'du yaanya aba atëdïyë dɔnɔ aba zi kï'dï koma 'be mï ma. Dï'bëë zi mo.” ");
INSERT INTO mgc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma mati ru rëzë 'bɔmo ëdï “Loŋa” iya zi vo lö'bö agamowe henye, “Ayiye dï'bëë, here da tɔ'bɔ koli mo aba.” ");
INSERT INTO mgc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mati Yësu ɔkɔ Beteniya, mo i'ja Lazara ëdï ku nzɔ mï dawogo ko'do sowɔ aba. ");
INSERT INTO mgc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beteniya ëdï tisiwa aba ta da wiṛi wota ta Yerusalema, ");
INSERT INTO mgc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ehe Yuda kayo ayinnï ta gawo kyedre zi da Marita ehe Mariya lëlu ga kö'du öndu zë oli ku. ");
INSERT INTO mgc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mati Marita owo henye Yësu ɔkɔ ku, mo ï'bë yaga zi dɔ mo kutrë, mora Mariya alima 'bënï loko. ");
INSERT INTO mgc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marita iya zi Yësu henye, “Yere, ëzë yï ëdï kinye, öndu ma oli dë. ");
INSERT INTO mgc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gbï le yaanya aba ne ma yɔlɔ ku henye Wïrï ako'dɔ wa mati ako'jo.” ");
INSERT INTO mgc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yësu ayada zi mo iya henye, “Öndu yï akadïdï löhu.” ");
INSERT INTO mgc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita aya'ba dɔ mo iya henye, “Ma yɔlɔ ku mo atënyï na dïdï mï ndundu ko'do aba, ëzë biya yöku ënyï ku.” ");
INSERT INTO mgc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yësu iya zi Marita henye, “Ma ra vïdï mati ëdï yöku kïnjë zi dïdï. Vïdï biya mati omannï mï ma akadïdïnnï, ëzë olinnï le. ");
INSERT INTO mgc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ehe vïdï biya mati alimannï ga kö'du 'ba koma mï ma tïnyö akolinnï dë. Oma nenye ku?” ");
INSERT INTO mgc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mo alëzë iya henye, “Ɔɔ Yere, moma yï Korisitɔ ra, Wisi 'ba Wïrï. Yï ra vïdï mati da sösu kö'du mo atayi mï damöku ne.” ");
INSERT INTO mgc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tapëtï Marita iya nenye, mo ï'bë liwo iya zi ëmï nï Mariya, “Raboni ëdï kinye, ehe mo omba zi yï kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kandi mati Mariya owo nenye, mo ënyï rïyë ï'bë yaga zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mo gba yaga ta ra gawo bi mati Marita ï'bë dɔ mo kutrë. ");
INSERT INTO mgc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vïdï kayo ayinnï zi da Mariya lëlu, ehe mati kandi zë ongɔnnï mo ila loko, asösunnï mo ëdï tï'bë dawogo zi kudu. Here zë alö'bönnï gbɔ ga ndï mo. ");
INSERT INTO mgc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya ï'bë bi mati Yësu 'dɔmo. Kandi mati mo ongɔ mo, alɔmvɔ burutu mo iya henye, “Yere, ëdï kyere kinye, öndu ma oli dë.” ");
INSERT INTO mgc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mati Yësu ongɔ Mariya ehe vïdï mati mo aba ëdïnnï akudu, mo kö'du sösu aba ");
INSERT INTO mgc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ako'jo henye, “Kila ï'dï yë ida rɔ mo?” Zë aya'bannï henye, “Yere, ayi ongɔ te.” ");
INSERT INTO mgc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yësu ayeto kudu. ");
INSERT INTO mgc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Vïdï iyannï henye, “Ongɔ te hala mo ɔwɔ Lazara.” ");
INSERT INTO mgc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kya zë maakowe iyannï henye, “Mo ayëhu komo 'ba vo komoköndu. Kö'du a'di mo atɔ'bɔ dë sesi Lazara kazi koli?” ");
INSERT INTO mgc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yësu zɔ kö'du sösu kyedre aba. Here mo ï'bë dawogo mati na wöru yïtö alulu ŋbïrï hɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Neene mo ayada zi vïdïyë yïtö ne lulu 'de yaga ta hɔ mo. Mora Marita iya henye, “Yere, ayɔlɔ henye, Lazara oli gɔ mo o'do ku sowɔ, ehe këzï mo atëdï ku na kyënyë.” ");
INSERT INTO mgc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yësu aya'ba dɔ mo henye, “Gba ma yada dë zi yï henye, ëzë ëdï koma aba, akongɔ bikanyi kyedre 'ba Wïrï?” ");
INSERT INTO mgc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tapëtï alulu yïtö ne ku dakapa, Yësu ongɔ bi rïyë zi komorïyë ehe amötu henye, “'Bu, mo'dɔ öwö'dï zi yï ga kö'du aya'ba da mötu 'bama. ");
INSERT INTO mgc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma yɔlɔ ku 'duwï ëdï da mötu 'bama ya'ba. Mora miya nenye, here zi vïdï kinye nee koma yï ra utu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mati Yësu inde mötu ku, mo ako'jo wa gu kyembe aba henye, “Lazara, ayi yaga!” ");
INSERT INTO mgc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kora mati oli ne ayi gbɔ yaga. Kala mowe ehe ndï mowe olo mï bɔngɔ 'ba wakusu, ehe bɔngɔ ayöfu komo mo. Yësu ayada zi vïdïyë henye, “Inge mo, ile mo mï'bë.” ");
INSERT INTO mgc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Vïdï kayo mati ayinnï zi Mariya, ongɔnnï wa mati Yësu o'dɔ, zë ï'dïnnï koma 'bënnï mï mo. ");
INSERT INTO mgc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Maakowe ï'bënnï zi Farasiye ehe ayadannï wa mati Yësu o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Here kyedree 'ba vo karase ehe Farasiye atɔtɔ rë nnï bi kölö iyannï henye, “A'di ra da ko'de? Kora nenye ëdï kyïnë 'ba kö'du koro ko'dɔ kyɔ. ");
INSERT INTO mgc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ëzë da dɔre mo dë yaanya aba, vïdï biya akï'dïnnï koma 'bënnï mï mo. Neene vïdï 'ba Roma atayinnï ehe akayaŋannï yëkëlu dakaŋo 'beze aba.” ");
INSERT INTO mgc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma kölö maako tëmï zë ru mo Kayafa, mo ra kyedre 'ba vo karase mï kɔɔ nani. Mo ame'do rïyë iya henye, “E vïdï nee, anze dë kö'du yɔlɔ aba. ");
INSERT INTO mgc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ayɔle dë henye, ëdï na laka zi vïdï kölö koli kö'du vïdïyë, kazi dakaŋo ra yaŋa biya?” ");
INSERT INTO mgc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa iya nenye dë na bi dë nï. Kaa kyedre 'ba vo karase mï kɔɔ nani, mo ëdï kumë henye, Yësu ra akoli kö'du 'ba dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yësu oli dë nje kö'du dakaŋo 'ba Yude. Mo akoli zi kika vïdï biya 'ba Wïrï mati apere rë nnï ne zi drɔko bi kölö. ");
INSERT INTO mgc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Here mï ko'do nani dagba ani, vïdï ayetonnï mala ko'dɔ zi Yësu kï'dï zi koli. ");
INSERT INTO mgc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ga kö'du mala rɔ mo nenye, Yësu adɔrɔ lasi toko mï vïdï kayo na dangölö. Mo ï'bë mï gawo 'ba Efaremo, mati kara dakapa lïpï, ehe mo alima ani vo lö'bö 'bënïyë ëtï. ");
INSERT INTO mgc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ëdï ku kara zi karama kadra 'ba laga 'ba koli. Vïdï kayo 'ba Yude mati alimannï yaga tëmï dakaŋo, ayinnï mï Yerusalema zi rë nnï kɔ'jɔ ŋbala ga kö'du 'ba karama. ");
INSERT INTO mgc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Zë omannï bi toko kö'du Yësu. Neene mati zë ëdïnnï mï yëkëlu, zë ako'jonnï oka ma kölö maako henye, “Asösu 'bëyï mo atayi dë kinye mï karama 'ba laga 'ba koli?” ");
INSERT INTO mgc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kyedre 'ba vo karase ehe Farasiye ayadannï zi vïdïyë zi zë yɔlɔ, ëzë vïdï maako tëmï zë ongɔ Yësu ku. Nenye ëdï hala zë asösunnï zi mo kïrï. ");
INSERT INTO mgc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ko'do modaka ta komo karama 'ba laga 'ba koli Yësu ï'bë hulëhu zi Beteniya, bi mati Lazara alima 'dɔmo, mati mo ïnjë mo tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Zë o'dɔnnï wakonyo zi mo ani. Marita ra akɔ'jɔ. Lazara kölö tëmï vïdï mati ëdïnnï alima ani da tarabiza Yësu aba. ");
INSERT INTO mgc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariya oba maṛanji yënïngutru ogo kɔhi kyedre aba ehe ope burutu Yësu. Mo akyitɔ zë zi teli yëvu 'bënï aba, ehe tato ndili 'ba yënïngutru ne, oso mï loko ne. ");
INSERT INTO mgc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Vo lö'bö maako ru mo Yudasi Sikereto ëdï ani, mati mo ra omba tï'bë zi Yësu susu. Mo ako'jo henye, ");
INSERT INTO mgc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kö'du a'di yënïngutru nenye ogo dë yaga kɔhi ŋbiriṛi lamiwota aba ehe kɔhi mo kï'dï zi vo leriye?” ");
INSERT INTO mgc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasi tïnyö asösu kö'du vo leriye dë. Mo ako'jo kö'du ne ga kö'du mo ïnjë aŋboro 'ba kɔhi ehe mï kadra maako aba akalogo zi nï. ");
INSERT INTO mgc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yësu aya'ba dɔ mo iya henye, “Ile mo kutu nï aba. Mo ma sesi wa mati mo ëdï mo aba kö'du kadra 'ba ma kusu. ");
INSERT INTO mgc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Atëdïyë 'duwï vo leriye ëtï, mora atanze dë 'duwï ma aba.” ");
INSERT INTO mgc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Vïdï kayo ayinnï mati zë owonnï henye Yësu ëdï ani. Zë ombannï kpa zi Lazara kongɔ ga kö'du Yësu ïnjë mo tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Here kyedree 'ba vo karase o'dɔnnï yeṛe kpa zi Lazara kofo. ");
INSERT INTO mgc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mo ra ï'dï vïdï kayo zi dë nnï kotɔ kazi zë ehe kï'dï koma 'bënnï mï Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ko'do ma vere aba vïdï kayo ëdïnnï mï Yerusalema kö'du 'ba karama. Mati zë owonnï henye Yësu ëdï tayi kö'du 'ba karama, ");
INSERT INTO mgc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","zë obannï mbili 'ba mbïrö ehe ï'bënnï yaga zi mo mëtë. Zë agbögbö hë nnï henye, “Wayeto zi Wïrï! Wïrï mï'dï ya'da zi vïdï mati ayi mï ru 'ba Yere! Wïrï mï'dï ya'da zi Yere 'ba Yiserele!” ");
INSERT INTO mgc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yësu i'ja makakya aho dɔ mo kaa wayöru iya, ");
INSERT INTO mgc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Vïdï 'ba Ziyɔnɔ, ere dë! Yere 'be ëdï tayi yaanya aba mo ëdï ataho da makakya.” ");
INSERT INTO mgc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mï dagba mo vo lö'bö 'ba Yësu ayɔlɔnnï dë. Mora tapëtï mo ïrï wayeto kazi Wïrï ku, zë asösunnï henye, wayöru iya nenye kö'du mo ehe zë o'dɔnnï nenye ko'dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Vïdï kayo ayinnï zi Yësu ga kö'du zë ongɔnnï mo Lazara ko'jo yaga tëmï dawogo. Zë asesinnï nduwë me'do kö'du mo ehe kö'du koro nenye. Zë ayinnï zi Yësu ga kö'du zë ongɔnnï kö'du kyïnë wakoro mati mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mora Farasiye iyannï zi oka ma kölö henye, “Waako anza dë da tɔ'bɔ ko'dɔ! Vïdï biya mï damöku ne ëdïnnï kusu ga Yësu.” ");
INSERT INTO mgc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Vïdï 'ba Gïrïgï maakowe ï'bënnï Yerusalema zi mötu mï kadra 'ba karama aba. ");
INSERT INTO mgc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pilipo ta Beteseyida mï Galilaya ëdï kpa ani. Here zë ï'bënnï zi mo iyannï henye, “Kyedre, domba ze zi Yësu kongɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipo ayada zi Anderiya. Zë rïyö ne ï'bënnï zi Yësu ayadannï zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yësu iya henye, “Kadra yaanya aba ɔkɔ ku kö'du Wisi 'ba Vïdï zi kïrï kyedre wayeto. ");
INSERT INTO mgc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ma yada tïnyö zi ye, ï'jö 'ba nyenyo mati alëpï dakaŋo atanza dë kyɔ ta da ï'jö ma kölö nje ëzë oli. Mora ëzë oli, ako'jo nyenyo kyɔ. ");
INSERT INTO mgc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ëzë ɔwɔ dïdï yï, akayölu. Ëzë ila kö'du 'ba damöku nenye, akï'dï dïdï ma ŋburu zi yï. ");
INSERT INTO mgc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ëzë alïtu zi ma, atï'bë ma aba. Vo lïtu 'bame atëdïnnï ma aba bi mati ma 'dɔmo. Ëzë alïtu zi ma, 'Bu ma akoro yï.” ");
INSERT INTO mgc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Yaanya aba ma mï riti kyedre, ma yɔlɔ dë a'di ra ma kiya. Mora ma ko'jo 'Bu dë zi sesi ma tëmï kadra 'ba riti nenye. Tïnyö mayi mï damöku kö'du kadra 'ba riti nenye. ");
INSERT INTO mgc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Here 'Bu, ika wayeto zi ru yï.” Gu ayi ta komorïyë iya henye, “Mika wayeto ku nzɔ zi ma, ehe ma ko'dɔ löhu.” ");
INSERT INTO mgc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mati vïdï kayo nee owonnï gu ne, kya zë maakowe asösu 'bënnï piwo ra. Agamowe asösu 'bënnï malayika ra ame'do zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Here Yësu ayada zi vïdï kayo nee, “Gu nani ame'do zi kɔnyiye, anza dë ma. ");
INSERT INTO mgc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vïdï 'ba damöku nenye yaanya aba o'dɔ vurë 'bëzë ku, ehe yere 'ba damöku nenye u'du ku nzɔ yaga. ");
INSERT INTO mgc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ëzë umbë ma ku rïyë ta dakaŋo, ma ko'dɔ vïdï biya komba zi tayi zi ma.” ");
INSERT INTO mgc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yësu ëdï ame'do kö'du gërï ma akï'dï nï zi kofo. ");
INSERT INTO mgc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Vïdï kayo nee iyannï zi Yësu henye, “Wayöruwë 'ba kö'du kï'dï ayandi henye, Korisitɔ ne akalima ŋburu. Hala ɔ'bɔ kiya henye Wisi 'ba Vïdï akïnjë rïyë zi koli? Ëyï ra nenye Wisi 'ba Vïdï?” ");
INSERT INTO mgc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yësu aya'ba dɔ mo iya henye, “Bikanyi atëdïyë aba nje tisiwa. Alasiye mï bikanyi ëzë atɔ'be here kazi biköndu akakowe. Kora mati mo alasi mï biköndu, mo ayɔlɔ dë nëdï tï'bë kila. ");
INSERT INTO mgc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ome mï bikanyi mati ëdïyë aba, here atayiye na gisi 'ba bikanyi.” Tapëtï Yësu iya kö'du nenyee, mo ila bi nani ï'bë mï bi 'ba rakoho. ");
INSERT INTO mgc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mo o'dɔ kyïnë 'ba kö'du koro kyɔ mï kutë vïdï kayo, mora zë gba zɔ ombannï dë zi tëdï koma aba mï mo. ");
INSERT INTO mgc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nenye o'dɔ rë nï zi wa mati nëbï Yisaya iya atayi tïnyö, “Yere, ëyï ra oma mï kö'du kise 'beze? Ehe ëyï ra ongɔ kyigɔ kyedre 'bëyï?” ");
INSERT INTO mgc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Vïdï ɔ'bɔnnï dë zi tëdï koma aba mï Yësu, ga kö'du Yisaya iya kpa henye, ");
INSERT INTO mgc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wïrï isi komo zë here kazi ɔ'bɔnnï bi kongɔ, ehe o'dɔ di'di zë na kyigɔ here zë ɔ'bɔnnï dë yɔlɔ. Mo o'dɔ nenye here kazi zë a'bannï zi mo ehe kɔ'jɔ zë.” ");
INSERT INTO mgc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yisaya iya nenye, ga kö'du mo ongɔ bikanyi kyedre 'ba Yësu ame'do kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Here vo dagba kayo 'ba Yude kayo ï'dïnnï koma 'bënnï mï Yësu, mora zë ayadannï dë zi vïdï maako, ga kö'du Farasiye ï'dïnnï kö'du ku nzɔ zi vïdïyë anza dë zi wa maako ko'dɔ zi vïdï maako mati ëdï koma aba mï Yësu. ");
INSERT INTO mgc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vo dagbe ombannï wayeto kazi agamowe ndra ta da mati zë ombannï wayeto kazi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mï gu kyembe aba Yësu iya henye, “Vïdï mati ëdï koma aba mï ma, ëdï kpa koma aba mï vïdï mati utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ehe vïdï mati ongɔ ma, ongɔ vïdï mati utu ma ne ku. ");
INSERT INTO mgc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma bikanyi mati ayi mï damöku. Vïdï mati ëdï koma aba mï ma, alima dë mï biköndu. ");
INSERT INTO mgc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma ra dë vïdï mati ako'dɔ vurë kyënyë 'ba vïdï naniye mati ombannï dë zi koro kö'du yandi 'bama. Mayi zi yɔmɔ vïdï 'ba damöku nenye, anza dë vo ko'dɔ vurë kyënyë 'bëzë. ");
INSERT INTO mgc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mora vïdï mati omba ma dë ehe wayandi 'bama, ako'dɔ vurë kyënyë rɔ mo mï ndundu 'ba ko'do aba, mï wa mati miya. ");
INSERT INTO mgc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Manza dë me'do ga kö'du 'bama. Miya nje wa mati 'Bu mati utu ma ayada zi ma kiya. ");
INSERT INTO mgc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma yɔlɔ ku kö'du kï'dï ɔmo akika dïdï ma ŋburu. Nenye ëdï hala ma yada zi ye te wa mati 'Bu ayada zi ma.” ");
INSERT INTO mgc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gba ta komo karama 'ba laga 'ba koli, Yësu ayɔlɔ henye kadra ne ɔkɔ ku kö'du nï zi kila damöku nenye ehe zi ta'ba zi 'Bu. 'Duwï mo ɔwɔ vo lö'bö 'bënïyë mï damöku nenye, ehe mo ɔwɔ zë le mï ndundu. ");
INSERT INTO mgc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gba kazi biyeto 'ba wakonyo 'ba hutaga, Satani o'dɔ Yudasi, wisi 'ba Simona Sikereto, omba zi Yësu susu. ");
INSERT INTO mgc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yësu ayɔlɔ nayi kazi Wïrï ehe na tï'bë hulëhu zi Wïrï. Mo ayɔlɔ kpa henye, 'Bu ï'dï kyigɔ ku biya zi nï. ");
INSERT INTO mgc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Here kadra 'ba wakonyo aba Yësu ënyï rïyë, mo otɔ bɔngɔ 'ba rë nï ma ta yaga, ehe olo bɔngɔrateli toko bi kɔ'di kida 'ba gë nï. ");
INSERT INTO mgc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mo ï'dï wini mï sikɔ kyedre. Here mo ayeto burutu vo lö'bö 'bënïyë kaka ehe kyïtru zë bɔngɔrateli mati mo usu ne aba. ");
INSERT INTO mgc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mora mati mo ayi zi Simona Petero, ako'jo henye, “Yere, ëdï tï'bë zi burutu ma kaka?” ");
INSERT INTO mgc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yësu aya'ba iya henye, “Tïnyö ayɔlɔ wa mati mëdï ko'dɔ ne dë, mora yaa akayɔlɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petero aya'ba henye, “Akaka burutu ma dë!” Yësu ayada zi mo henye, “Ëzë ma kaka yï dë, tïnyö anza dë 'bama.” ");
INSERT INTO mgc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Petero aya'ba dɔ mo iya henye, “Yere, akaka dë nje burutu ma, akaka kala ma da ma aba!” ");
INSERT INTO mgc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yësu aya'ba henye, “Vïdï mati akaka rë nnï ku ehe ëdïnnï ku biya ŋbala omba nje zi burutu zë ra kaka. Ehe e vo lö'bö 'bame, ëdïyë ŋbala nje vïdï kölö tëmï yë.” ");
INSERT INTO mgc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yësu ayɔlɔ ëyï ra akasusu nï. Kö'du nere ra mo iya henye, nje zi ma kölö tëmï yë. ");
INSERT INTO mgc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tapëtï Yësu akaka burutu vo lö'bö 'bënïyë ehe usu bɔngɔ 'bënï ma ta yaga ne hulëhu, mo alima akaŋo löhu. Here mo iya henye, “Ayɔle wa mati mo'dɔ zi ye ne ku? ");
INSERT INTO mgc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ako'jowe ma Raboni 'be ehe Yere, ehe akiye here, ga kö'du nani ëyï ra ma. ");
INSERT INTO mgc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ëzë Yere 'be ehe vo komoyandi akaka burutu wë, o'de kpa te here zi oka ma kölö maako. ");
INSERT INTO mgc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ma yada gɔ mo ku, ehe o'de zi oka ma kölö maako te wa mati mo'dɔ zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ma yada tïnyö zi ye henye, vo lïtuwë anzannï dë kyedre ta da vo dë nnï, ehe vo lïtu kike anzannï dë kyedre ta da vïdï mati utu zë ne. ");
INSERT INTO mgc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ayɔle wa nenyee ku. Wïrï akï'dï ya'da zi ye, ëzë o'de zë.” ");
INSERT INTO mgc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Manza dë ame'do kö'du wë biya. Ma yɔlɔ zë mati ma jeli ne ku. Mora wa mati wayöru iya, atayi tïnyö. Mo iya henye, ‘Kora mati onyo wa ma aba ne, opi rë nï ku na vo wehe ra ma.’ ");
INSERT INTO mgc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mëdï yada nenye zi ye biya gba kazi rë nï ko'dɔ, here ëzë o'dɔ rë nï ku, akome ëyï ra ma. ");
INSERT INTO mgc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ma yada tïnyö zi ye, vïdï mati ïrï vo lïtu 'bame kalakyedre aba, ïrï ma kpa kalakyedre aba, ehe vïdï mati ïrï ma kalakyedre aba, ïrï ne vïdï mati utu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tapëtï Yësu iya kö'du nenyee, mo riti kyedre aba ehe ayada zi vo lö'bö 'bënïyë henye, “Ma yada tïnyö zi ye henye, vïdï ma kölö tëmï yë akasusu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dë zë wïrïwïrï kö'du wa mati mo iya ne. Zë nje bi kongɔ aba da oka ma kölö. ");
INSERT INTO mgc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yësu ɔwɔ vo lö'bö mati ëdï alima kara zi nï bi 'ba wakonyo, ");
INSERT INTO mgc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ehe Simona Petero o'dɔ kala nï zi vo lö'bö nenye zi ki'ja ma vala ra Yësu ame'do kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Here vo lö'bö ne ïdë rë nï zi Yësu ehe ako'jo henye, “Yere, ma vala ra tëmï ze ëdï ame'do kö'du mo?” ");
INSERT INTO mgc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yësu aya'ba iya henye, “Ma kusu nzoyi mangɔlɔ'bɔ nenye mï gbenje ehe kï'dï zi vïdï mati mëdï ame'do kö'du mo.” Here Yësu usu mangɔlɔ'bɔ gbo ehe ï'dï zi Yudasi, wisi 'ba Simona Sikereto. ");
INSERT INTO mgc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kandi Satani ayaŋa da Yudasi. Yësu iya henye, “Yudasi, ï'bë kandi o'dɔ wa mati zi yï ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Vïdï maako bi 'ba wakonyo ne ayɔlɔ kö'du mati Yësu iya ne dë. ");
INSERT INTO mgc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mora ga kö'du Yudasi ra na vo kɔhi sesi, kya zë maakowe asösunnï henye Yësu ayada zi mo zi kogo wa mati zë ombannï kö'du karama. Agamowe asösunnï henye Yësu ayada zi mo zi kɔhi kï'dï zi vo leri. ");
INSERT INTO mgc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi oba nzoyi mangɔlɔ'bɔ, ï'bë yaga. Ëdï ku nzɔ yɔndɔ. ");
INSERT INTO mgc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tapëtï Yudasi ï'bë ku Yësu iya henye, “Yaanya aba Wisi 'ba Vïdï akï'dï wayeto, ehe mo akika wayeto zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Here tapëtï Wïrï akïrï wayeto ku ga kö'du mo, Wïrï akï'dï wayeto zi mo, ehe Wïrï ako'dɔ kandi. ");
INSERT INTO mgc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gisi ame, ma tëdïyë aba nje tisiwa aba na konda. Here akome ma, mora aki'je ma dë. Ma yada zi ye kpa kaa ma yada zi Yude. ‘Ɔ'be dë tï'bë bi mati mëdï atï'bë.’ ");
INSERT INTO mgc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mora mëdï kö'du kï'dï kyïyï kï'dï zi ye: ɔwe oka ma kölö maako, kpa te kaa mati mɔwɔ e. ");
INSERT INTO mgc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ëzë ɔwe oka maakowe mï gërï nenye, vïdï biya akayɔlɔnnï e vo lö'bö 'bama ra.” ");
INSERT INTO mgc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petero ako'jo henye, “Yere, ëdï tï'bë kila?” Yësu aya'ba henye, “Ɔ'bɔ dë tï'bë ma aba yaanya aba, mora yaa dagba ani atï'bë.” ");
INSERT INTO mgc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petero ako'jo henye, “Yere, kö'du a'di mɔ'bɔ dë tï'bë yï aba yaanya aba? Ma koli kö'du yï!” ");
INSERT INTO mgc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yësu ako'jo henye, “Tïnyö akoli kö'du ma? Ma yada zi yï tïnyö, gba kazi zanga yëru yapa, akiya da wota henye ayɔlɔ ma dë.” ");
INSERT INTO mgc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yësu iya zi vo lö'bö 'bënïyë henye, “Asösuwë kö'du dë. Ëdïyë koma aba mï Wïrï. Ome kpa mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Loko kayo ëdï mï liŋɔ 'ba 'Bu ma. Ma yada nenye dë zi ye, ëzë anza dë tïnyö. Mëdï tï'bë ani zi bi kɔ'jɔ biya zi ye na kölö kölö. ");
INSERT INTO mgc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tapëtï mo'dɔ nenye ku, ma ta'ba hulëhu kobe ma aba. Here da tëdï ze ga bi kölö. ");
INSERT INTO mgc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ayɔle gërï mati mëdï atï'bë zi mo ne ku.” ");
INSERT INTO mgc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma iya henye, “Yere, da yɔlɔ dë ëdï atï'bë kila! Hala da tɔ'bɔ yɔlɔ gërï ne?” ");
INSERT INTO mgc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yësu aya'ba henye, “Ma gërï, tïnyö, ehe dïdï! Kazi ma, vïdï maako ɔ'bɔ dë tï'bë zi 'Bu. ");
INSERT INTO mgc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ëzë tïnyö ayɔle ma, akayɔle 'Bu. Mora tëmï ndenye dagba ani, ayɔle mo ku, ehe onge mo ku.” ");
INSERT INTO mgc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo iya henye, “Yere, ayada zi ze 'Bu ne, nani biya wa mati domba.” ");
INSERT INTO mgc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yësu aya'ba henye, “Pilipo, mëdï yï aba kadra konda aba ayɔlɔ dë ma ëyï? Ëzë ongɔ ma, ongɔ 'Bu ku. Hala atɔ'bɔ ha ma ko'jo zi yada 'Bu zi ye? ");
INSERT INTO mgc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Oma dë henye, ma kölö 'Bu aba ehe 'Bu kölö ma aba? Wa mati miya, miya dë kö'du ma. 'Bu mati alima mï ma, ra o'dɔ wa nenyee. ");
INSERT INTO mgc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ome mï ma ëzë miya henye, 'Bu kölö ma aba ehe ma kölö 'Bu aba. Mandere ome mï ma kpa nje ga wa mati mëdï ako'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ma yada tïnyö zi ye henye ëzë ëdïyë koma aba mï ma, ako'de kpa te wa mati mëdï ako'dɔ. Ako'de wa kyedre maakowe ndra, ga kö'du mëdï ku tï'bë hulëhu zi 'Bu. ");
INSERT INTO mgc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ako'jowe ha ma, ehe ma ko'dɔ wa mati ako'jowe kö'du mo. Gërï nenye aba, Wisi akika wayeto zi 'Bu. ");
INSERT INTO mgc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ma ko'dɔ wa mati ako'jowe ha ma zi ko'dɔ mï ru ma.” ");
INSERT INTO mgc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yësu iya zi vo lö'bö 'bënïyë henye, “Ëzë ɔwe ma, ako'de kaa mï'dï kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Here ma kako'jo ha 'Bu zi kutu zi ye Lawo Laka mo akakɔnyiye ehe 'duwï atëdïyë aba. ");
INSERT INTO mgc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Lawo Laka akayada zi ye wa mati tïnyö. Vïdï 'ba damöku nenye ɔ'bɔnnï dë kïrï Lawo, ga kö'du zë ongɔnnï dë mandere yɔlɔ mo. Mora ayɔle Lawo ku, ga kö'du mo ëdïyë aba ehe akasesi lima nduwë mï yë. ");
INSERT INTO mgc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma kile dë kaa wala. Ma tayi hulëhu zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tisiwa aba vïdï mï damöku nenye ɔ'bɔnnï dekpe zi ma kongɔ, mora akonge ma. Ehe ga kö'du ma lima, akalime. ");
INSERT INTO mgc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Here akayɔle ma kölö 'Bu aba. Akayɔle, e kölö ma aba, ehe ma kölö ëtï. ");
INSERT INTO mgc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ëzë ɔwe ma, ako'de wa mati miya, ehe 'Bu atɔwɔ e. Ma katɔwɔ e kpa ehe yada zi ye ma kaa a'di.” ");
INSERT INTO mgc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudasi ma agamo anza dë Yudasi Sikereto, ame'do rïyë ako'jo kö'du henye, “Yere, mï me'do 'bëyï ne a'di akayada zi ze yï kaa a'di, mora ayada dë zi vïdï 'ba damöku nenye?” ");
INSERT INTO mgc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yësu aya'ba henye, “Ëzë vïdï maako ɔwɔ ma, zë akoronnï ma. Here 'Bu ma akatɔwɔ zë, da katayi zi zë ehe lima mï zë. ");
INSERT INTO mgc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mora vïdï mati ɔwɔ ma dë, oro ma dë. Wa mati owowe miya tïnyö ayi dë kazi ma, mora kazi 'Bu mati utu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ma yada kö'du nenyee zi ye, mati ma gba ëtï. ");
INSERT INTO mgc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mora Lawo Laka atayi akakɔnyiye. Lawo Laka mati 'Bu ma akutu mï ru ma, akayandi wa biya zi ye ehe ako'de zi sösu wa biya mati ma yada zi ye.” ");
INSERT INTO mgc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mï'dï rakyëyï zi ye, kyïnë 'ba rakyëyï mati nje ma tɔ'bɔ kï'dï. Anza dë kaa rakyëyï mati damöku nenye akï'dï. Here asösuwë dë mandere tere. ");
INSERT INTO mgc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Owowe ma ku nzɔ kiya henye, mëdï atï'bë ehe ma tayi kpa hulëhu zi ye. Ëzë tïnyö ɔwe ma, ëdïyë rakyenyi aba mëdï ku tï'bë hulëhu zi 'Bu, ga kö'du mo ëdï kyedre ta da ma. ");
INSERT INTO mgc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mëdï yada zi ye nenye gba kazi ma tï'bë, here ëzë o'dɔ rë nï, atëdïyë koma aba mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɔ'bɔ dekpe me'do ëtï na konda, ga kö'du yere 'ba damöku nenye ëdï tayi. Mora mo anza dë kyigɔ aba da ma. ");
INSERT INTO mgc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Moro wa mati 'Bu ma ayada zi ma ko'dɔ, here zi vïdï biya mï damöku ne akayɔlɔnnï mɔwɔ mo. Ëdï ku kadra 'ba zi ze tï'bë yaanya aba.” ");
INSERT INTO mgc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yësu iya zi vo lö'bö 'bënïyë henye, “Ma tïnyö kaga tana, 'Bu ma ra vo kyeti yaka. ");
INSERT INTO mgc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mo iga ngora 'bama biya mati anannï kɔlɔ dë yaga. Mora mo ikye ŋbala biya da ngora mati ëdï tana kɔlɔ, here zi tana kɔlɔ kyɔ. ");
INSERT INTO mgc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","E ku nzɔ ŋbala ga kö'du wa mati miya zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Alime na rakida zi ma, ehe ma kalima na rakida zi ye. Te kaa ngora ɔ'bɔ dë tana kɔlɔ nje ëzë alima na rakida zi kaga, here ɔ'be dë tana kɔlɔ nje ëzë alime na rakida zi ma.” ");
INSERT INTO mgc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ma kaga ra, e ngora ra. Ëzë alime na rakida zi ma, ehe ma kalima na rakida zi ye tane kɔlɔ kyɔ. Mora ɔ'be dë wa maako ko'dɔ kazi ma. ");
INSERT INTO mgc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ëzë alime dë na rakida zi ma, aku'duwë yaga. Atëdïyë kaa ngora kyïtru mati atɔtɔ bi kölö ehe o'bɔ mï wa'do. ");
INSERT INTO mgc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ëzë alime na rakida zi ma ehe kö'du yandi 'bama mayi na kapa 'be, here atɔ'bɔ mötuwë ga wa mati ombe, ehe mötu 'be akaya'ba dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ëzë ayiye ku na kɔlɔ laka 'ba vo lö'bö 'bame, akoro 'Bu ma. Ne akayada henye, e vo lö'bö 'bame. ");
INSERT INTO mgc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mɔwɔ e kaa 'Bu ma ɔwɔ ma. Here alime mï watɔwɔ 'bama. ");
INSERT INTO mgc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ëzë orowe ma, ma kasesi tɔwɔ e kaa 'Bu ma asesi tɔwɔ ma, ga kö'du moro mo.” ");
INSERT INTO mgc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ma yada nenye zi ye, zi ye tëdïyë mï rakyenyi 'bama ma ŋburu. ");
INSERT INTO mgc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yaanya aba ma yada zi ye zi tɔwɔ oka ma kölö maako kaa mɔwɔ e. ");
INSERT INTO mgc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gërï ma laka ndra zi yada watɔwɔ kö'du aboke, ëdï zi koli kö'du zë. ");
INSERT INTO mgc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E aboka ma ra, ëzë orowe ma. ");
INSERT INTO mgc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma ko'jowe dë vo lïtu 'bame, ga kö'du vo lïtu ayɔlɔnnï dë a'di ra kyedre 'bëzë ëdï ako'dɔ. Ma me'do zi ye kaa aboka me, ga kö'du ma yada ku biya zi ye wa mati 'Bu ma ayada zi ma. ");
INSERT INTO mgc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","E ra dë ajeliye ma, ma ra ma jeliye kutu yaga zi tana kɔlɔ, kyïnë 'ba kɔlɔ ma akalima ŋburu. Here 'Bu ma akï'dï zi ye wa mati ako'jowe kazi mo mï ru ma. ");
INSERT INTO mgc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Here mï'dï kö'du zi ye zi tɔwɔ oka ma kölö.” ");
INSERT INTO mgc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ëzë vïdï 'ba damöku nenye ayiye, asösuwë henye zë iyinnï ma dagba. ");
INSERT INTO mgc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ëzë e zi damöku, vïdï 'bɔmo atɔwe. Mora anze dë zi damöku. Ma jeliye zi damöku nenye kila hulëhu. Kö'du nenye ra vïdï 'bɔmowe ëdïnnï ye kiyi. ");
INSERT INTO mgc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Asösuwë hala ma yada zi ye henye vo lïtu anzannï dë kyedre ta da kyedre 'bënnï. Here ëzë vïdï o'dɔnnï ma na kyënyë, zë ako'dɔnnï yë na kyënyë. Ëzë zë oronnï kö'du yandi 'bama, zë akoronnï 'be. ");
INSERT INTO mgc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vïdï ako'dɔnnï kpa te zi ye wa mati zë o'dɔnnï zi ma. Zë ako'dɔnnï ga kö'du e zi ma, ehe zë ayɔlɔnnï vïdï mati utu ma ne dë. ");
INSERT INTO mgc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ëzë mayi dë ame'do zi zë, o'dɔnnï vurë kyënyë dë rë zë. Yaanya aba zë ɔ'bɔnnï dë kiya anzannï ra dë. ");
INSERT INTO mgc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Vïdï mati iyi ma iyi 'Bu ma kpa. ");
INSERT INTO mgc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mo'dɔ wa maakowe vïdï maako gba o'dɔ dë. Ëzë zë ongɔnnï ma dë wa nenyee ko'dɔ, o'dɔnnï vurë kyënyë dë rë zë. Mora zë ongɔnnï ma wa nenyee ko'dɔ, ehe zë zɔ ma kiyi ehe 'Bu ma kpa. ");
INSERT INTO mgc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nenye ra hala wayöru ëdïnnï tïnyö mati zë iyannï henye, vïdï iyinnï ma öŋbö kazi kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ma kutu zi ye Lawo mati ayi kazi 'Bu ehe ayada wa mati tïnyö. Lawo Laka akakɔnyiye ehe akayada kö'du ma zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Here akayade kö'du ma kpa zi oka maakowe, ga kö'du ëdïyë ma aba tëmï biyeto.” ");
INSERT INTO mgc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mëdï yada zi ye wa nenyee, here kazi otɔ de 'de. ");
INSERT INTO mgc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Akore yaga tëmï bi 'ba mötu, ehe kadra atayi mati vïdï akofonnïyë, ehe zë asösunnï, nëdïnnï kö'du laka ra ko'dɔ zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zë ako'dɔnnï wa nenyee ga kö'du zë ayɔlɔnnï 'Bu mandere ma dë. ");
INSERT INTO mgc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mëdï akiya nenye zi ye yaanya aba, here ëzë kadra ne ayi ku akasösuwë wa mati miya.” “Ma mëdï ëtï tëmï dagba, ehe here ma yada wa nenyee dë zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mora yaanya aba mëdï ku tï'bë hulëhu zi 'Bu mati utu ma, ehe vïdï maako tëmï yë ako'jo ha ma dë mëdï tï'bë kila. ");
INSERT INTO mgc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","E kazi rakyenyi biya ta bi kö'du nenye kowo. ");
INSERT INTO mgc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mora ma yada zi ye, mëdï tï'bë zi ko'dɔ wa mati ëdï na laka kö'du wë. Kö'du nenye ra mëdï tï'bë 'de. Lawo Laka ɔ'bɔ dë tayi zi ye kɔnyi le ëzë mile ku. Mora tapëtï mï'bë ku, ma kutu mo zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lawo atayi akayada zi vïdï 'ba damöku nenye kö'du tïnyö kö'du yaŋa ehe kö'du laka 'ba Wïrï ehe vurë. ");
INSERT INTO mgc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Lawo akayada zi zë henye, zë 'ba kö'du kyënyë ko'dɔ, ga kö'du zë anzannï dë koma aba mï ma. ");
INSERT INTO mgc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Zë na lïtë kö'du wa 'ba Wïrï mati ëdï tïnyö na laka, ga kö'du mëdï tï'bë zi 'Bu, onge ma dekpe löhu. ");
INSERT INTO mgc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ehe zë na lïtë kö'du 'ba vurë, ga kö'du Wïrï ikye vurë 'ba yere 'ba damöku nenye ku nzɔ. ");
INSERT INTO mgc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mëdï kö'du aba kyɔ zi kiya zi ye, mora yaanya aba atëdï ndra ta da mati atɔ'be yɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lawo ayada wa mati tïnyö ehe atayi gage mï tïnyö ma ndɔ. Lawo ame'do dë ga kö'du nï. Mo akayada zi ye nje wa mati mo owo kazi ma, ehe mo ako'dɔ zi ye yɔlɔ a'di ra ëdï tï'bë zi rë nï ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lawo akï'dï wayeto zi ma kö'du kise 'bama koba ehe yada mo zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wa biya mati 'Bu ëdï mo aba 'bama ra. Kö'du nenye ra miya henye Lawo oba kö'du kise 'bama ehe yada mo zi ye.” ");
INSERT INTO mgc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yësu ayada zi vo lö'bö 'bënïyë, “Tisiwa aba, onge ma dekpe, mora tapëtï mo tisiwa akonge ma.” ");
INSERT INTO mgc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zë iyannï zi oka ma kölö maako henye, “A'di ra Yësu iya henye, tisiwa aba donge mo dë, mora tapëtï mo tisiwa aba, da kongɔ ze mo? Kö'du a'di ra mo iya henye, nëdï tï'bë zi 'Bu? ");
INSERT INTO mgc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A'di ra 'bënï nenye tisiwa aba, mati mo ëdï ame'do kö'du mo? Da yɔlɔ dë a'di ra mo ame'do kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yësu ayɔlɔ zë ëdïnnï kö'du ko'jo maakowe aba, here mo iya henye, “E na rasösu a'di ra ma me'do kö'du mo mati miya henye tisiwa aba onge ma dë, mora tapëtï mo tisiwa aba akonge ma. ");
INSERT INTO mgc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ma yada zi ye tïnyö henye, akuduwë ehe atëdïyë kazi rakyenyi, mora damöku atëdï rakyenyi aba. Atëdïyë kazi rakyenyi, mora yaa atëdïyë na rakyenyi. ");
INSERT INTO mgc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ëzë mbara omba ku zi ko'jo, mo ëdï mï watɔɔ kyedre. Mora tapëtï ko'jo, watɔɔ ne ölu ta dɔ mo ehe na rakyenyi, ga kö'du mo ika wisi ku mï damöku ne. ");
INSERT INTO mgc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E yaanya aba kazi rakyenyi, mora yaa ma konge, ehe atëdïyë na rakyenyi. Vïdï maako ɔ'bɔ dë zi kobe ta gërï mati asösuwë. ");
INSERT INTO mgc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ëzë kadra nani ayi ku, ako'jowe ha ma dë kö'du wa maako. Ma yada tïnyö zi ye henye, 'Bu akï'dï zi ye wa mati ako'jowe kö'du mo mï ru ma. ");
INSERT INTO mgc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ako'jowe kö'du wa maako dë gba mï gërï nenye. Mora yaanya aba ako'jowe mï ru ma ehe akïrïyë.” ");
INSERT INTO mgc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ma me'do ha kahi aba zi yada wa nenyee zi ye. Mora kadra mo atayi mati ma kame'do dekpe ha kahi aba, mora ma kame'do zi ye huwë kö'du 'ba 'Bu. ");
INSERT INTO mgc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Akako'jowe ha 'Bu mï ru ma. Ma kako'jo hɔ mo dë zi ye. ");
INSERT INTO mgc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Wïrï 'Bu ɔwe ga kö'du ɔwe ma, ehe ome mayi kazi mo. ");
INSERT INTO mgc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mayi ta ra 'Bu mï damöku ne, mora mëdï ku damöku ne kila ta'ba zi 'Bu.” ");
INSERT INTO mgc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vo lö'böwë iyannï henye, “Yaanya aba ëdï ku ame'do huwë zi ze! Anza dë ame'do ha kahi aba. ");
INSERT INTO mgc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndundu mo aba da yɔlɔ ku henye, ayɔlɔ wa biya, ehe omba dë zi vïdï hë yï ko'jo. Yaanya aba doma tïnyö ayi ta ra Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yësu aya'ba henye, “Tïnyö yaanya ome ma ku? ");
INSERT INTO mgc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kadra atayi ehe ëdï ku nzɔ kinye, mati akapere biya. Vïdï biya na kölö kölö tëmï yë atï'bë hulëhu liŋɔ ehe akila ma na bi da ma. Mora 'Bu atëdï ma aba, ma tanza dë kutu ma aba. ");
INSERT INTO mgc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma yada nenye zi ye, zi ye tëdïyë rakyëyï aba mï di'di ye ga kö'du ma. Ëzë ëdïyë mï damöku ne, atëdïyë riti aba. Mora ëdïyë kazi tere, ma'da damöku ne ku.” ");
INSERT INTO mgc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tapëtï Yësu inde me'do ku zi vo lö'bö 'bënïyë, mo ongɔ bi rïyë komorïyë ehe amötu, “'Bu, kadra ɔkɔ ku zi yï kï'dï wayeto zi Wisi 'bëyï, here zi mo kï'dï wayeto zi yï, ");
INSERT INTO mgc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ga kö'du ï'dï kyigɔ ku zi mo ta da vïdï biya, here mo akï'dï dïdï ma ŋburu zi vïdï biya mati ï'dï zi mo. ");
INSERT INTO mgc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dïdï ma ŋburu ëdï zi yɔlɔ yï, Wïrï ma nje tïnyö, ehe zi yɔlɔ Yësu Korisitɔ, mo mati utu. ");
INSERT INTO mgc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mï'dï wayeto zi yï kinye dakaŋo zi ko'dɔ wa biya ï'dï zi ma ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yaanya aba 'Bu, ï'dï hulëhu zi ma wayeto mati mëdï mo aba yï aba gba damöku ne o'dɔ dë. ");
INSERT INTO mgc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ï'dï vo lö'bö maakowe ku zi ma tëmï damöku nenye ehe ma yada zi zë, yï kaa a'di. Zë 'bëyï ra, mora ï'dï zë zi ma, ehe zë oronnï yï. ");
INSERT INTO mgc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Zë ayɔlɔnnï henye, ï'dï zi ma biya wa mati mëdï mo aba. ");
INSERT INTO mgc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma yada zi vo lö'bö 'bame wa mati ayada zi ma, ehe zë ombannï dɔ mo. Zë ayɔlɔnnï mayi kazi yï, ehe zë omannï yï ra utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mëdï amötu kö'du zë, mora anza dë kö'du zë 'ba damöku nenye. Vo lö'bö 'bame 'bëyï ra, ehe mëdï amötu kö'du zë. ");
INSERT INTO mgc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Biya mati mëdï mo aba 'bëyï ra, ehe biya mati ëdï mo aba 'bama ra, ehe zë ï'dïnnï wayeto zi ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Bu laka, manza dekpe na konda mï damöku ne, mëdï tayi zi yï, mora vo lö'bö 'bame gba mï damöku ne. Agaga gë zë kyigɔ 'ba ru yï aba, mati ï'dï zi ma ne aba, here zë atëdïnnï kölö oka ma kölö maako aba, kpa kaa yï ehe ma kölö. ");
INSERT INTO mgc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mati mëdï zë ëtï, ma sesi zë na laka kyigɔ mati ï'dï zi ma ne aba. Mongɔ gë zë ehe ma kölö tëmï zë ölu dë, nje ma kölö mati mo ra omba zi tölu. Nenye o'dɔ rë nï here zi wa mati wayöru iya zi tayi tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ma ku da gërï ama zi yï, mora miya kö'du nenyee mati ma gba mï damöku, here vo lö'bö 'bame atëdïnnï kpa te rakyenyi biya mati mo'dɔ aba. ");
INSERT INTO mgc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma yada kö'du kise 'bëyï ku zi zë, mora vïdï 'ba damöku nenye iyi zë, ga kö'du zë anzannï dë zi damöku nenye, kpa te kaa manza dë. ");
INSERT INTO mgc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Bu, ma ko'jo hë yï dë zi koba vo lö'bö 'bame yaga tëmï damöku ne, mora agaga gë zë kazi Satani. ");
INSERT INTO mgc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Zë anzannï dë zi damöku nenye, ehe ma kpa. ");
INSERT INTO mgc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Me'do 'bëyï ra ëdï tïnyö. Here ï'dï tïnyö nenye, mo'dɔ zë biya na 'bëyï. ");
INSERT INTO mgc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mëdï zë kutu mï damöku, kaa utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mï'dï ra ma ku biya zi yï ga kö'du 'bëzë, here zë mëdïnnï biya zi yï mï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Manza dë nje amötu kö'du vo lö'bö nenyee. Mëdï kpa amötu kö'du vïdï biya mati zi tëdïnnï koma aba ga kö'du wa mati vo lö'bö 'bame akiyannï kö'du ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","'Bu, momba zë biya zi tëdï kölö oka ma kölö maako aba, kpa kaa ma kölö yï aba, ehe yï kpa kölö ma aba. Ma kpa momba zë zi tëdï kölö ze aba, here vïdï 'ba damöku nenye akomannï henye, yï ra utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Moro vo lö'bö 'bame mï gërï kölö oro ma, zë mëdïnnï kölö oka ma kölö maako aba kaa ze kölö. ");
INSERT INTO mgc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ma kölö zë aba, ehe yï kölö ma aba, here zi zë tayinnï biya kölö. Here vïdï 'ba damöku nenye akayɔlɔnnï henye, yï ra utu ma. Zë akayɔlɔnnï henye, ɔwɔ vo lö'bö 'bame kpa kaa ɔwɔ ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“'Bu, momba vïdï biya mati ï'dï zi ma zi tëdï ma aba, bi mati mëdï 'dɔmo. Neene zë akongɔnnï bikanyi kyedre mati ï'dï zi ma, ga kö'du ɔwɔ ma gba o'dɔ damöku dë. ");
INSERT INTO mgc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Bu laka, vïdï 'ba damöku nenye ayɔlɔnnï yï dë, mora ma yɔlɔ yï, ehe vo lö'bö 'bame ayɔlɔnnï henye yï ra utu ma. ");
INSERT INTO mgc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma yada zi zë, yï kaa a'di, ehe ma kayada zi zë nduwë, here watɔwɔ mati ëdï mo aba kö'du ma akatayi kapa 'bëzë, ehe ma tëdï kölö zë ëtï.” ");
INSERT INTO mgc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mati Yësu inde mötu ku, mo vo lö'bö 'bënï ëtï umunnï kyëtï gulu 'ba Kidrono ehe ï'bë mï yaka maako. ");
INSERT INTO mgc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yësu ëdï 'duwï rë nnï ki'ja vo lö'bö 'bënï ëtï ani, ehe Yudasi ayɔlɔ bi ne. ");
INSERT INTO mgc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Here Yudasi ï'bë zi yaka ne kya 'ba vo kanye 'ba Roma ëtï ehe vo kanye 'ba yëkëlu, kyedre 'ba vo karase ehe Farasiye ra utunnï zë. Zë ïnjënnï wa'do zi bi yanyi ehe wa 'ba wehe. ");
INSERT INTO mgc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yësu ayɔlɔ kö'du mati omba zi tï'bë rë nï ko'dɔ ne ku nzɔ, mora mo ako'jo henye, “Ëyï ra ëdïyë koma?” ");
INSERT INTO mgc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Zë aya'bannï henye, “Dëdï koma Yësu 'ba Nazereta!” Yësu ayada zi zë henye, “Ma Yësu ra!” Yudasi vo susu ëdï tɔrɔ ani dakapa zë. ");
INSERT INTO mgc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kandi zë biya a'bannï kɔwɔ hulëhu ehe alëpïnnï dakaŋo. ");
INSERT INTO mgc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yësu ako'jo kö'du löhu henye, “Ëdïyë ëyï ra koma?” Zë aya'bannï dɔ mo iyannï henye, “Dëdï ze koma Yësu 'ba Nazereta.” ");
INSERT INTO mgc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kadra nenye aba Yësu aya'ba henye, “Ma yada ku nzɔ zi ye ma Yësu ra. Ëzë ma ra ëdïyë akoma, ile vïdï maakowe mï'bënnï.” ");
INSERT INTO mgc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Here wa biya ako'dɔ rë nï, kaa mo iya, “Ma yölu vïdï ma kölö mati ï'dï zi ma ne dë.” ");
INSERT INTO mgc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Petero ika kulu nï aba. Mo otɔ yaga tëmï silikpa ehe otra Malahisi, vo lïtu 'ba kyedre 'ba vo karase, ehe iga mbili mo ma da tïrï ŋbïṛïku yaga. ");
INSERT INTO mgc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yësu iya zi Petero henye, “Ï'dï kulu 'bëyï ne karani. Ma kuwë tëmï sikɔ mati 'Bu ï'dï zi ma.” ");
INSERT INTO mgc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Vo kanye 'ba Roma ehe vo kyëlu 'bënnï ëtï, ehe vo kanye 'ba yëkëlu ëtï, ïrïnnï Yësu ehe idannï mo gö. ");
INSERT INTO mgc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Zë obannï mo dagba zi Anasi, mo yawo 'ba Kayafa, kyedre 'ba vo karase mï kɔɔ nani. ");
INSERT INTO mgc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa kölö nenye ra ayada zi kyedree 'ba Yude henye, “Ëdï na laka ëzë vïdï kölö maako oli kö'du vïdï biya.” ");
INSERT INTO mgc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petero ehe vo lö'bö maako aba usu ga Yësu. Vo lö'bö nani ayɔlɔ kyedre 'ba vo karase, ehe usu ga Yësu le mï liŋɔ 'ba kyedre 'ba vo da karasa. ");
INSERT INTO mgc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petero alima yaga kara haresi. Mora vo lö'bö maako ayi hulëhu yaga ehe ame'do zi wu'jë 'ba haresi ne henye, “Mo mila Petero tï'bë loko.” ");
INSERT INTO mgc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mora ako'jo hɔ mo henye, “Anza dë kölö tëmï vo lö'bö 'ba kora nani?” Petero aya'ba dɔ mo iya henye “E e manza dë.” ");
INSERT INTO mgc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gabi na kyëyï ehe vo lïtuwë ehe vo kanye 'ba yëkëlu adrɔkonnï wa'do kalïlï. Zë ëdïnnï rë nnï koye toko ta rɔ mo, mati Petero ï'bë ehe ɔrɔ kara dakapa wa'do zi rë nï koye. ");
INSERT INTO mgc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kyedre 'ba vo karase ako'jo ha Yësu kö'du vo lö'bö 'bɔmowe ehe kö'du yandi 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mora Yësu ayada zi mo henye, “Ma me'do na dangölö ta da komo vïdï biya, ehe 'duwï mëdï kö'du yandi mï bi 'ba mötu 'beze ehe mï yëkëlu, bi ma Yude ayinnï biya bi kölö. Miya kö'du maako dë na koho. ");
INSERT INTO mgc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kö'du a'di ra ëdï ha ma ko'jo? Kö'du a'di ako'jo ha vïdï mati owonnï ma ne dë? Zë ayɔlɔnnï wa mati miya.” ");
INSERT INTO mgc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kandi mati Yësu iya nenye, ma kölö tëmï vo kanye 'ba yëkëlu otra mo ehe iya henye, “Nani anza dë gërï mati zi me'do zi kyedre 'ba vo karase.” ");
INSERT INTO mgc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yësu aya'ba dɔ mo iya henye, “Ëzë miya wa maako ku na kyënyë, iya. Mora ëzë anza dë, kö'du a'di otra ma?” ");
INSERT INTO mgc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yësu gba na kida, ehe Anasi utu mo zi Kayafa kyedre 'ba vo karase. ");
INSERT INTO mgc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mati Simona Petero ëdï tɔrɔ ani rë nï kubï, vïdï maako ako'jo hɔ mo henye, “Anza kölö tëmï vo lö'böwë 'ba Yësu?” Löhu Petero andi ehe iya henye, “E e, manza dë.” ");
INSERT INTO mgc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kölö tëmï vo lïtu 'ba kyedre 'ba vo karase ëdï ani. Mo na karo zi vo lïtu mati Petero ikye mbili mo yaga ne, ehe mo ako'jo henye, “Mongɔ yï dë mï yaka kora nani aba?” ");
INSERT INTO mgc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Löhu Petero andi, ehe zanga ayapa gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'Do ŋbɔ damïndö aba oba mati Yësu kazi Kayafa zi loko mati vo daliŋɔ mï turu 'ba Roma alima. Mora Yude biya ëdïnnï bi kida aba yaga, ga kö'du ëzë vïdï tëmï zë ï'bë mï loko ne, atayi na ti'da ehe ila mo dë zi wakonyo 'ba karama 'ba laga 'ba koli konyo. ");
INSERT INTO mgc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato ayi yaga ehe ako'jo henye, “A'di ra na kyënyë ike kora nenye?” ");
INSERT INTO mgc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Zë ya'bannï henye, “Mo vo kö'du kyënyë ko'dɔ! Kö'du nenye ra dika ze mo zi yï.” ");
INSERT INTO mgc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ayada zi zë henye, “Obe mo ehe o'de vurë 'bɔmo mï kö'du kï'dï 'be.” Yude aya'bannï henye, “Danza dangölö aba zi kï'dï vïdï maako zi kofo.” ");
INSERT INTO mgc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ehe here, wa mati Yësu iya kö'du kyïnë koli 'bënï, atayi tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ï'bë hulëhu loko. Mo ako'jo Yësu zi nï ehe ako'jo henye, “Yï ra Yere 'ba Yude?” ");
INSERT INTO mgc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yësu aya'ba henye, “Ëdï kö'du nenye ko'jo na bi dë yï, mandere vïdï maako ra ayada kö'du ma zi yï?” ");
INSERT INTO mgc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato iya henye, “Ayɔlɔ ku manza dë Yuda! Vïdï 'bëyïyë ehe kyedree 'ba vo karase ra ikannï yï zi ma. A'di ra o'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yësu aya'ba henye, “Kalakonda 'bama anza dë zi damöku nenye. Ëzë ëdï here, vo lö'bö 'bame ako'dɔnnï wehe zi sesi ma ta bi kï'dï zi vo dagba 'bezee. E e, kalakonda 'bama anza dë zi damöku nenye.” ");
INSERT INTO mgc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato aya'ba henye, “Here, yï yere ra.” Yësu ayada zi mo henye, “Yï ëdï akiya henye, ma yere. O'jo ma mï damöku nenye, zi yada kö'du tïnyö ra, ehe vïdï mati zi kö'du ma tïnyö ayɔlɔ gu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ako'jo ha Yësu henye, “A'di ra tïnyö?” Pilato ï'bë hulëhu yaga ehe iya henye, “Mi'ja kora nenye dë kö'du kyënyë maako aba. ");
INSERT INTO mgc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kyere ma 'duwï maboso kinga zi ye kadra karama 'ba laga 'ba koli aba, ombe zi ma kinga zi ye na dangölö Yere 'ba Yude?” ");
INSERT INTO mgc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Zë agbögbö hë nnï, “E e, anza mo! Domba ze Barabasi.” Barabasi ëdï na vo wehe 'ba turu. ");
INSERT INTO mgc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato ï'dï kö'du gbɔ zi Yësu ku'bö so'da aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vo kanye o'dɔnnï safo 'ba yere yaga tëmï ngora kono ï'dïnnï da Yësu. Here zë usunnï bɔngɔ 'buluyë rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Zë ayinnï zi mo da kyɔ ehe iyannï henye, “He, yï Yere 'ba Yude!” Zë isannï mo kpa kala nnï aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kpa löhu Pilato ï'bë yaga. Kadra nenye aba mo iya henye, “Ma kika Yësu zi ye yaga löhu, here atɔ'be kongɔ na bi de henye, mi'ja mo dë kö'du kyënyë maako aba.” ");
INSERT INTO mgc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yësu asi yaga usu safo 'ba yere kono bɔngɔ 'buluyë aba. Pilato iya henye, “Kinye kora ne ëdï.” ");
INSERT INTO mgc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mati kyedree 'ba vo karase ehe kanye 'ba yëkëlu ongɔnnï mo, zë agbögbö hë nnï iyannï henye, “Ma tötö mo da taka! Ma tötö mo da taka!” Pilato ayada zi zë, henye, “Obe mo, ehe atötöwë mo da taka. Mi'ja kö'du kyënyë ko'dɔ 'bɔmo maako dë.” ");
INSERT INTO mgc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yude nee aya'bannï henye, “Mo iya zi nï tëdï na Wisi 'ba Wïrï! Kö'du kï'dï 'beze iya henye, mï'dï mo zi koli.” ");
INSERT INTO mgc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Mati Pilato owo nenye, mo ndra na tere. ");
INSERT INTO mgc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mo ï'bë hulëhu loko ehe ako'jo ha Yësu henye, “Yï ta kila?” Mora Yësu aya'ba dë. ");
INSERT INTO mgc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ako'jo henye, “Kö'du a'di aya'ba da kö'du ko'jo 'bama ne dë? Ayɔlɔ dë mëdï kyigɔ aba zi yï kinga na dangölö mandere yï tötö da taka?” ");
INSERT INTO mgc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yësu aya'ba henye, “Ëzë Wïrï ï'dï kyigɔ ne dë zi yï, ɔ'bɔ dë wa maako ko'dɔ zi ma. Mora mo mati ï'dï ma zi yï, o'dɔ ndra na kyënyë.” ");
INSERT INTO mgc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Here Pilato omba zi Yësu kinga na dangölö. Mora Yude agbögbö hë nnï löhu, “Ëzë inga kora nenye ku na dangölö, anza dë aboka 'ba Yere 'ba Roma. Vïdï maako mati iya zi nï tëdï na yere, vo wehe 'ba Yere 'ba Roma.” ");
INSERT INTO mgc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Mati Pilato owo nenye, mo ika Yësu yaga. Here mo alima akaŋo da kyïtï 'ba vurë bi mati ako'jo, “Yïtö Dakaŋo.” Mï ha 'ba Hïbïru ëdï “Gabata.” ");
INSERT INTO mgc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ëdï kaa kadra kutë mï ko'do, gba kazi karama 'ba laga 'ba koli, ehe Pilato iya zi vïdï kayo nee henye, “Ongɔ bi da yere 'be!” ");
INSERT INTO mgc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Zë agbögbö hë nnï henye, “Ofo mo! Ofo mo!Atötö mo da taka!” Pilato ako'jo henye, “Here ombe ma zi tötö yere 'be da taka?” Kyedree 'ba vo karase aya'bannï henye, “Yere 'ba Roma ra yere 'beze.” ");
INSERT INTO mgc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Here Pilato ï'dï Yësu gbɔ zi tötö da taka. Oba Yësu 'de, ");
INSERT INTO mgc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ehe mo ïnjë taka 'bënï bi ma ëdï na yɔlɔ henye, “Yingɔ da.” Ha 'ba Hïbïru bi nenye, ako'jo “Gologota.” ");
INSERT INTO mgc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ani atötö Yësu gbɔ da taka, ehe dakapa mo da taka, atötö kora kpa rïyö, ma kölö kapa mo ma kölö, Yësu mï kutë zë. ");
INSERT INTO mgc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ï'dï kö'du zi kö'du kyënyë ko'dɔ 'ba Yësu zi yöru da wa ehe kï'dï rïyë da taka. Ako'jo henye, “Yësu 'ba Nazereta, Yere 'ba Yude.” ");
INSERT INTO mgc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Me'do ne ayöru mï ha 'ba Hïbïru, ha 'ba Lateni ehe ha 'ba Gïrïgï. Bi mati oba Yësu zi mo ne, anza na kɔwɔ ta ra gawo kyedre, ehe Yuda kayowe ako'jonnï kö'du yöru rɔ mo ne. ");
INSERT INTO mgc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Here kyedree 'ba vo karase ï'bënnï zi Pilato iya henye, “Kö'du a'di ayöru henye, mo Yere 'ba Yude? Akayöru kyere henye, ‘Mo iya zi nï tëdï na Yere 'ba Yude.’” ");
INSERT INTO mgc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mora Pilato ayada zi zë henye, “Wa mati ma yöru ku, ma lima here!” ");
INSERT INTO mgc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tapëtï vo kanye atötönnï Yësu ku da taka, zë inyennï mï bɔngɔ 'bɔmo sowɔ, ma kölö zi ma kölö tëmï zë. Mora bɔngɔ 'bɔmo ma ta yaga o'dɔ tëmï nzoyi bɔngɔ kölö, anza dë kapa maako aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Vo kanye iyannï zi oka ma kölö maako henye, “Dize dë, du'duwë födö aba zi kongɔ ëyï ra akïrï.” Nenye o'dɔ rë nï here zi wayöru tayi tïnyö, mati iya henye, “Zë inyennï mï bɔngɔ ame ehe u'dunnï födö kö'du bɔngɔ ame.” Vo kanye o'dɔnnï wa mati zë ombannï. ");
INSERT INTO mgc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma 'ba Yësu ɔrɔ dakapa taka 'bɔmo ëmï nï aba ehe Mariya mbara 'ba Kalapasi. Mariya Magadala ëdï kpa atɔrɔ ani. ");
INSERT INTO mgc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mati Yësu ongɔ ma nï, ehe vo lö'bö mati mo ɔwɔ mo ëtï, mo iya zi ma nï henye, “Kora nenye yaanya aba wisi 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Here mo iya zi vo lö'bö ne henye, “Mo yaanya aba ma yï ra.” Tëmï ndenye dagba ani, vo lö'bö nani oba mo gbɔ liŋɔ 'bënï. ");
INSERT INTO mgc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yësu ayɔlɔ henye, yaanya aba ninde lɔɔ 'bënï ku. Ehe zi ko'dɔ wayöru tayi tïnyö, mo iya henye, “Ma na kɔdrɔ.” ");
INSERT INTO mgc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sikɔ ëdï ani ndɔ a'ji aba. Vïdï maako usu lifa mï a'ji ne ehe ïnjë rïyë ï'dï ha Yësu kaga 'ba isipɔ aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tapëtï Yësu uwë a'ji ne, mo iya henye, “Wa biya o'dɔ rë nï ku!” Mo umbï dë nï ehe oli. ");
INSERT INTO mgc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yaanya aba ëdï ko'do 'ba rakɔ'jɔ, 'dö ko'do 'ba ralawo ehe karama 'ba laga 'ba koli. Ëdï ko'do lele zi Yude, ehe zë ombannï dë zi ida ra nee zi lima rïyë da taka mï ko'do nenye. Here zë ako'jonnï ha Pilato zi ndï kora nee kowe ehe koba ida rë zë akaŋo. ");
INSERT INTO mgc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Vo kanye dagba owennï ndï 'ba kora agamowe rïyö mati atötö zë ani ne. ");
INSERT INTO mgc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mora mati zë ayinnï zi Yësu, zë ongɔnnï mo oli ku nzɔ, ehe zë owennï ndï mo dë. ");
INSERT INTO mgc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma kölö tëmï vo kanye isi mbese Yësu wehe aba, yama ehe wini asi yaga. ");
INSERT INTO mgc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Da yɔlɔ nenye ëdï tïnyö, ga kö'du vïdï maako ra ayada wa mati mo ongɔ o'dɔ rë nï. Yaanya aba atɔ'bɔ tëdï kpa koma aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Biya nenye o'dɔ rë nï here, zi wayöru tayi tïnyö, mati iya henye, “Yingɔ 'ba ida rɔ mo ma kölö akowe dë,” ");
INSERT INTO mgc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ehe “Zë ongɔnnï ma kölö mï dakapa mbese mo isi wehe aba.” ");
INSERT INTO mgc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yosepa tëmï Arimataya ëdï kölö tëmï vo lö'bö 'ba Yësu. Mo asesi na koho, le ga kö'du mo na tere kazi vo dagbe 'ba Yude. Mora yaanya aba mo ako'jo ha Pilato zi mo ida ra Yësu koba. Pilato ï'dï dangölö zi mo, ehe Yosepa oba mo akaŋo ta da taka. ");
INSERT INTO mgc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodïmö ayi nï mo aba, ehe ika kpa kaa 'butëwota kilɔgaramo 'ba wakëzï ngutru aba o'dɔ tëmï murë ehe alɔyisi 'ba yöku kusu. Nenye kpa te Nikodïmö kölö mati ï'bë zi Yësu yɔndɔ kölö maako aba. ");
INSERT INTO mgc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vïdï kora rïyö nee, olonnï ida ra ne mï bɔngɔ 'ba yöku, bi kölö wakëzï ngutru aba, mati ëdï hala Yude ombennï yöku 'bënnï. ");
INSERT INTO mgc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mï bi mati atötö Yësu da taka, ani yaka ëdï wogo aba mati gba ombe vïdï maako dë mï mo. ");
INSERT INTO mgc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dawogo ne ëdï kara, ehe kyere ne kadra 'ba zi ra kɔ'jɔ kö'du ko'do 'ba ralawo, zë na kɔrɔkɔrɔ zi ida ra Yësu kï'dï ani. ");
INSERT INTO mgc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ko'do 'ba Gima aba ŋbɔ mati bi gba na köndu, Mariya Magadala ï'bë dawogo ehe ongɔ henye, yïtö alulu ku 'de, ta ha bi tödu 'ba dawogo. ");
INSERT INTO mgc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mo aho zi Simona Petero ehe zi vo lö'bö mati Yësu ɔwɔ ehe iya henye, “Zë obannï Yere ku tëmï dawogo! Da yɔlɔ dë ï'dïnnï mo ku kila.” ");
INSERT INTO mgc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petero ehe vo lö'bö maako aba ayetonnï tï'bë dawogo. ");
INSERT INTO mgc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Zë ahonnï ta bi kölö, le vo lö'bö maako ne aho ndra ta da Petero ehe ɔkɔ ani dagba. ");
INSERT INTO mgc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mo ïdë rë nï ehe ongɔ bɔngɔ konda na lala loko mï dawogo, mora mo ï'bë dë loko. ");
INSERT INTO mgc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mati Simona Petero ɔkɔ ani, mo ï'bë mï dawogo ehe ongɔ bɔngɔ konda ne. ");
INSERT INTO mgc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mo ongɔ nzoyi bɔngɔ mati o'dɔ zi komo Yësu yöfu mo aba ne. Aköku ku ehe mï bi mati na bi dë nï. ");
INSERT INTO mgc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vo lö'bö mati ɔkɔ dagba ani ne ï'bë mï dawogo, ehe mati mo ongɔ, mo oma. ");
INSERT INTO mgc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mï kadra nani Petero ehe vo lö'bö maako ne, ayɔlɔnnï dë henye, wayöru iya henye Yësu atënyï na dïdï. ");
INSERT INTO mgc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Here zë rïyö ne ï'bënnï hulëhu zi vo lö'bö maakowe. ");
INSERT INTO mgc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya Magadala ɔrɔ kudu yaga dakapa dawogo. Mo ëdï gba kudu, mati mo ïdë rë nï akaŋo ");
INSERT INTO mgc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ehe ongɔ malayike rïyö loko. Zë usunnï bɔngɔ kanyi ehe ëdï alimannï bi mati ï'dï ida ra Yësu 'dɔmo. Ma kölö bi dɔ mo ehe ma agamo bi ndï mo. ");
INSERT INTO mgc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malayika nee ako'jonnï ha Mariya henye, “Kö'du a'di ëdï akudu?” Mo aya'ba dɔ mo henye, “Zë obannï ida ra Yere ama ku 'de, ma yɔlɔ dë ï'dïnnï mo kila.” ");
INSERT INTO mgc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kandi mati Mariya iya nenye, mo ofɔ rë nï kpo ehe ongɔ Yësu ëdï atɔrɔ ani. Mora mo ayɔlɔ dë, mo 'bënï ëyï. ");
INSERT INTO mgc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yësu ako'jo hɔ mo iya henye, “Ëdï akudu ga a'di? Ëdï ëyï ra koma?” Mo asösu 'bënï mo vo kyeti yaka ra ehe iya henye, “Kyedre, ëzë obe ida rɔ mo ku 'de, akɔ ayada zi ma, here ma tɔ'bɔ tï'bë mo koba.” ");
INSERT INTO mgc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Here Yësu iya zi mo henye, “Mariya!” Mo ofɔ rë nï ehe iya zi mo henye, “Raboni.” Ha 'ba Hïbïru aba “Raboni” vo “Komoyandi.” ");
INSERT INTO mgc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yësu ayada zi mo henye, “Ise ra ma dë! Mï'bë dë gba zi 'Bu. Mora ayada zi vo lö'bö 'bame mëdï atï'bë zi mo mati na 'Bu ma ehe Wïrï 'bama, kpa 'Bu wë ehe Wïrï 'be.” ");
INSERT INTO mgc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariya Magadala ï'bë ayada zi vo lö'böwë nongɔ Yere ku. Mo ayada kpa zi zë wa mati mo iya zi nï. ");
INSERT INTO mgc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Vo lö'böwë na tere kazi vo dagbe 'ba Yude, ehe mï hutaga 'ba Gima kölö nani, zë isi gë nnï loko. Truku'du, Yësu alaya mï kutë 'ba gboko. Mo amëtë zë iya henye, “Rakyëyï mëdï yë aba.” ");
INSERT INTO mgc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ehe ayada kala nïyë zi zë ehe mbese nï. Mati vo lö'böwë ongɔnnï Yere, zë biya na rakyenyi. ");
INSERT INTO mgc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tapëtï Yësu amëtë zë löhu, “Rakyëyï mëdï yë aba,” mo iya henye, “Mëdï yë kutu kaa 'Bu utu ma.” ");
INSERT INTO mgc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Here mo alawo dë zë ehe iya henye, “Ïrïyë Lawo Laka. ");
INSERT INTO mgc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ëzë ile vïdï maako ku ga kö'du kyënyë, akila zë. Mora ëzë ile kö'du kyënyë 'bëzë dë, ila zë dë.” ");
INSERT INTO mgc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma ma ako'jo “vo loŋa” ëdï le kölö tëmï vo lö'bö 'butë dɔmorïyö, mo anza dë agamo ëtï mati Yësu alaya zi zë. ");
INSERT INTO mgc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Here zë ayadannï zi mo henye, “Dongɔ ze Yere ku.” Mora Toma iya henye, “Dagba, momba kongɔ tëpï ɔŋɔ 'ba nosomari mï kala mo ehe kise zë dawisi kala ma aba. Ma kï'dï kala ma bi mati wehe ï'bë da mbese mo. Moma dë, nje ëzë mo'dɔ nenye ku!” ");
INSERT INTO mgc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tapëtï ko'do 'ba Gima kölö yaa, vo lö'bö atɔtɔ rë nnï löhu bi kölö. Kadra nenye aba, Toma ëdï zë aba. Yësu ayi loko mati ha loko gba na kisi ehe ɔrɔ mï kutë 'ba gboko ne. Mo amëtë vo lö'bö 'bënïyë, “Rakyëyï mëdï yë aba.” ");
INSERT INTO mgc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mo iya zi Toma henye, “Ï'dï dawisi kala yï kinye, ehe ongɔ bi da kala me. Ï'dï kala yï da mbese ma. Ɔrɔ tëmï da jiji 'bëyï ne, ehe oma!” ");
INSERT INTO mgc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma aya'ba dɔ mo iya henye, “Yï Yere ama, ehe Wïrï ama!” ");
INSERT INTO mgc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yësu iya henye, “Toma, oma ga kö'du ongɔ ma ku? Vïdï mati ëdïnnï koma aba mï ma kazi ma kongɔ, ëdï zë mati tïnyö ya'da aba!” ");
INSERT INTO mgc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yësu o'dɔ kyïnë 'ba kö'du koro ko'do maakowe kyɔ mati vo lö'bö 'bɔmowe ongɔnnï, ehe anza zë biya ayöru ku mï buku nenye. ");
INSERT INTO mgc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mora ma nenyee ayöru here zi ye kï'dï koma 'be mï Yësu na Korisitɔ ne, Wisi 'ba Wïrï. Ëzë ëdïyë koma aba mï mo, atëdïyë dïdï aba mï ru 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yësu yaa alaya zi vo lö'bö 'bënïyë da götï Föfö 'ba Tiberiyasi. O'dɔ rë nï mï gërï nenye. ");
INSERT INTO mgc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petero, Toma ma ako'jo “vo loŋa,” Natanëlë ta Kana mï Galilaya, gisi 'ba Zebedeyo ëdïnnï ani, bi kölö aga vo lö'bö maako ëtï rïyö. ");
INSERT INTO mgc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Petero iya henye, “Mëdï tï'bë kyenze kïrï!” Maakowe iyannï henye, “Da tï'bë ze yï aba.” Zë ï'bënnï yaga mï töŋbö 'bënnï. Mora du ïrïnnï wa maako dë yɔndɔ nani aba. ");
INSERT INTO mgc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ŋbɔ mï damïndö vere, Yësu ɔrɔ da götï, mora vo lö'böwë ayɔlɔnnï dë mo ëyï ra. ");
INSERT INTO mgc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yësu agbögbö hë nï, “Aboke, ïrïyë wa maako ndö?” Zë aya'bannï henye, “E e.” ");
INSERT INTO mgc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Here mo ayada zi zë henye, “Umëë öndu 'be ne akaŋo da kala tïrï 'ba töŋbö 'be, ehe akïrïyë kya 'ba kyenze maakowe.” Zë o'dɔnnï here, ehe öndu gbɔ kyɔ na kyenze, here zë ɔ'bɔnnï dë zi kotɔ rïyë mï töŋbö. ");
INSERT INTO mgc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Vo lö'bö mati Yësu ɔwɔ ne, iya zi Petero henye, “Nenye Yere ra.” Mati Petero owo ne Yere ra, mo usu bɔngɔ mati mo otɔ, mati mo ëdï lɔɔ ko'dɔ ne. Here, mo öfu mï wini. ");
INSERT INTO mgc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Töŋbö ëdï nje kaa lamikölö mitiri ta da götï. Here vo lö'bö maakowe alimannï mï töŋbö, ehe otɔnnï öndu mï mo kyɔ kyenze aba. ");
INSERT INTO mgc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mati vo lö'böwë asinnï yaga tëmï töŋbö, zë ongɔnnï mangɔlɔ'bɔ ehe wa'do 'ba kalïlï kyenze aba dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yësu ayada zi vo lö'bö 'bënïyë henye, “Ike kya 'ba kyenze maakowe mati ïrïyë ne.” ");
INSERT INTO mgc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Petero ï'bë hulëhu mï töŋbö ehe otɔ öndu da götï. Mï mo kyenze ma kyedre ëdïnnï lamikölö 'butëmuyï dɔmowota, mora öndu gba kazi liza. ");
INSERT INTO mgc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yësu iya henye, “Ayiye ehe onyowe.” Mora vo lö'bö ma kölö maako ako'jo dë, mo ëyï ra. Zë ayɔlɔnnï mo Yere ra. ");
INSERT INTO mgc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yësu oba mangɔlɔ'bɔ mï kala nï ehe ï'dï kya maakowe zi vo lö'bö 'bënïyë. Mo o'dɔ kyenze ne kpa te here. ");
INSERT INTO mgc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nenye mï kadra mawota mo ra Yësu alaya zi vo lö'bö 'bënïyë tapëtï mo ënyï tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mati Yësu vo lö'bö 'bënï ëtï indennï wakonyo ku, mo ako'jo henye, “Simona wisi 'ba Yowani, ɔwɔ ma ndra ta da oka maakowe?” Simona Petero aya'ba henye, “Ɔɔ, Yere, ayɔlɔ ku mɔwɔ yï!” Yësu iya henye, “Here, ulu tïmëlë ame.” ");
INSERT INTO mgc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yësu ako'jo madarïyö mo, “Simona wisi 'ba Yowani, ɔwɔ ma?” Petero aya'ba henye, “Ɔɔ, Yere, ayɔlɔ mɔwɔ yï!” Yësu ayada zi mo henye, “Here, ongɔ ga tïmëlë ame.” ");
INSERT INTO mgc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yësu ako'jo mï da mawota mo henye, “Simona wisi 'ba Yowani, ɔwɔ ma?” Petero na rasösu ga kö'du Yësu ako'jo hɔ mo mawota ëzë mo ɔwɔ nï. Here mo ayada zi Yësu henye, “Yere, ayɔlɔ kö'du biya. Ayɔlɔ mɔwɔ yï.” Yësu aya'ba henye, “Ulu tïmëlë ame. ");
INSERT INTO mgc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ma yada tïnyö zi yï henye, mati yï gba na wisi kora ɔbi, usu rë yï ehe ï'bë bi mati omba zi tï'bë. Mora mati endro ku, akiza yaga kala yï. Here, maakowe akidannï kɔ'di gë yï toko rë yï ehe akalëpï zi yï dagba bi mati omba dë zi tï'bë.” ");
INSERT INTO mgc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yësu iya nenye zi yada hala Petero akoli ehe akika wayeto zi Wïrï. Here mo iya zi Petero, “Usu ga ma.” ");
INSERT INTO mgc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petero opi rë nï ehe ongɔ vo lö'bö mati Yësu ɔwɔ ne, usu ku gë nï. Mo ra kpa te mati alima kara zi Yësu bi 'ba wakonyo, ehe ako'jo henye, “Yere, ëyï ra ëdï tï'bë zi yï susu?” ");
INSERT INTO mgc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Mati Petero ongɔ vo lö'bö nenye, mo ako'jo ha Yësu iya henye, “Yere, a'di kö'du mo?” ");
INSERT INTO mgc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yësu aya'ba henye, “Kö'du sösu 'bëyï ëdï a'di, ëzë momba mo zi lima le ma'ba? Usu ga ma.” ");
INSERT INTO mgc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Here, ndɔndɔ apere rë nï mï kutë vo lö'bö maakowe henye, vo lö'bö nenye oli dë. Mora Yësu iya dë mo oli dë. Mo iya nje henye, “Kö'du sösu 'bëyï ëdï a'di?” ");
INSERT INTO mgc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Vo lö'bö nenye ra mo ayada kö'du nenye biya. Mo ayöru, ehe da yɔlɔ mo ëdï kö'du tïnyö ra yada. ");
INSERT INTO mgc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yësu o'dɔ wa maakowe kyɔ. Ëzë ayöru zë biya mï bukuwë, ma sösu henye, bi atanza dë mï damöku ne kö'du buku nee biya.");
INSERT INTO mgc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mï dagba buku 'bama, ma yöru zi yï Tïyöpïyölö biya wa mati Yësu o'dɔ yandi mo aba, tëmï kadra mati mo ayeto lɔɔ 'bënï, ");
INSERT INTO mgc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","le mï ko'do mati oba mo komorïyë, tapëtï mo ï'dï kö'du ku kpuru Lawo Laka aba zi vo lïtuwë mati mo inzi. ");
INSERT INTO mgc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tapëtï koli 'bɔmo, mo ayada rë nï zi zë mo ëdï na dïdï. Zë ongɔnnï mo ko'do 'butësowɔ aba, mo ame'donnï zë ëtï kö'du Damöku 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mati mo gba zë ëtï mo iya zi zë henye, “Ile Yerusalema dë, isiye kinye bi Lawo Laka zi 'Bu kï'dï kaa mati ma yada zi ye mo alömu zi ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yowani ï'dï bapatisi wini aba, ko'do tisi aba akï'dïyë bapatisi Lawo Laka aba.” ");
INSERT INTO mgc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mati vo lïtuwë gba Yësu aba, ako'jonnï hɔ mo iyannï henye, “Yere, yaanya aba omba kï'dï damöku zi Yiserele hulëhu löhu?” ");
INSERT INTO mgc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yësu iya zi zë henye, “Omba dë zi ye yɔlɔ kadra 'ba kö'du mati o'dɔ rë nï nani, nje 'Bu ra ayɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mora Lawo Laka atayi de ehe akï'dï kyigɔ zi ye. Here, akayade kö'du ma zi vïdï mï Yerusalema, mï Yudiya biya, mï Samariya, ehe mï damöku ne biya.” ");
INSERT INTO mgc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tapëtï kö'du kiya 'ba Yësu nenye, ehe mati zë ëdïnnï bi kongɔ, oba mo rïyë mï fɔli. Zë ɔ'bɔnnï dekpe mo kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mora mati mo ëdï tï'bë ku rïyë, zë nduwë bi kongɔ komorïyë. Kandi kora rïyö usunnï bɔngɔ kanyi ëdï tɔrɔnnï dakapa zë. ");
INSERT INTO mgc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Zë iyannï henye, “Kö'du a'di kora 'ba Galilaya ëdï tɔre kinye bi kongɔ komorïyë? Oba Yësu ku komorïyë. Mora mo ata'ba hulëhu tëmï gërï kölö mati onge mo tï'bë.” ");
INSERT INTO mgc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Vo lïtu a'bannï ta Döku 'ba Olivo zi Yerusalema. Döku 'ba Olivo ëdï lasi 'ba wiṛi kölö ta ra Yerusalema. Vo lïtu mati ï'bënnï ani ne, ");
INSERT INTO mgc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","zë ra Petero, Yowani, Yemisi, Anderiya, Pilipo, Toma, Baratolomoya, Matayo, Yemisi wisi 'ba Alipayo, Simona mati o'dɔ lɔvɔ dakaŋo 'bënï, ehe Yudasi wisi 'ba Yemisi. Mati vo lïtuwë a'bannï ku gawo, zë ï'bënnï rïyë mï loko tɔrɔ ma ëdïnnï 'dɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vo lïtuwë 'duwï rë nnï tɔtɔ amötu na radrɔko, vïdï mbare, ehe Mariya ma 'ba Yësu, öndu mo ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kadra naniye aba, vo lö'bö 'ba Yere ëdïnnï biya lamikölö 'butërïyö mï ratɔtɔ bi kölö, ehe Petero ënyï rïyë ame'do zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Mo iya henye, “Aboka me, kyigɔ 'ba Lawo Laka aba, Dawidi iya kö'du 'ba Yudasi, mora kö'du mati mo iya ne o'dɔ rë nï ku. ");
INSERT INTO mgc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudasi mo kölö tëmï ze o'dɔ lɔɔ ze aba, mora mo ika vïdïyë zi Yësu kïrï. ");
INSERT INTO mgc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Here, Yudasi ogo kaŋo kɔhi ma ï'dï zi mo ga kö'du kyënyë ko'dɔ 'bɔmo ne. Mati mo alëpï ta rïyë akaŋo mï yaka, ida rɔ mo api. ");
INSERT INTO mgc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mati vïdï 'ba Yerusalema ayɔlɔnnï kö'du nenye, zë ako'jonnï yaka nani Akeledama, kö'du ya'ba aba mï ha 'bëzë, ‘Yaka 'ba Yama.’ ");
INSERT INTO mgc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mï buku Wayeto 'ba Dawidi iya henye, ‘Mila loko 'bɔmo na mbiya, ehe mila vïdï maako dë lima ani.’ Iya kpa henye, ‘Vïdï maako mïrï lɔɔ 'bɔmo ne.’ ");
INSERT INTO mgc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Here, domba vïdï maako kpa zi kɔnyi ze yada zi vïdï maakowe henye, Yësu ënyï ku tëmï koli. Mo mëdï tëmï vïdï kora kölö ma ëdï ze aba tëmï biyeto. Mo mëdï ze aba tëmï kadra mati Yowani abapatisi Yere Yësu, le ko'do ma oba mo komorïyë.” ");
INSERT INTO mgc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Zë inzinnï vïdï kora rïyö. Ma kölö tëmï zë Yosepa, ako'jo Barasaba, ako'jo kpa Jusitusu, ehe agamo Matiyasi. ");
INSERT INTO mgc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Here, zë biya amötunnï, iyannï henye, “Yere, ayɔlɔ kö'du sösu mï di'di 'ba vïdï biya. Ayada zi ze ma kölö ma inzi ku ");
INSERT INTO mgc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","zi tëdï na vo lïtu ehe zi lɔɔ pëtï Yudasi ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Zë u'dunnï födö, ehe inzi Matiyasi zi drɔko mï gboko 'ba vo lïtuwë 'butë dɔmokölö ne. ");
INSERT INTO mgc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mï ko'do tayi 'ba Lawo Laka aba, vo lö'böwë ga Yere biya ga bi kölö. ");
INSERT INTO mgc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kandi kpɔrɔ aa ta komorïyë kaa taa 'ba buluku mora oso ndɔ mï loko mati zë atɔtɔ rë nnï 'dɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Here zë ongɔnnï wa alaya kaa ndende wa'do ta bi lasi apere rë nï yaga alima da vïdï biya na kölö kölö. ");
INSERT INTO mgc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Zë biya osonnï ndɔ Lawo Laka aba, ayetonnï me'do tëmï ha maakowe, kaa mati Lawo Laka ï'dï zë zi me'do. ");
INSERT INTO mgc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Yude vïdï 'ba Wïrï kayo mati ëdï alimannï tëmï dakaŋo biya mï damöku ne, ëdïnnï lima mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mati zë owonnï kpɔrɔ wa ne, vïdï kayo atɔtɔ rë nnï ga bi kölö. Zë biya na rakaga ga kö'du vïdï kölö tëmï zë owo vo kö'du kombe ëdï ame'do ha 'bënï aba. ");
INSERT INTO mgc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tëmï rakaga 'bëzë ne zë iyannï henye, “Vïdï nenyee biya mati ëdï ame'donnï here ne, anzannï dë vïdï 'ba Galilaye? ");
INSERT INTO mgc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kö'du a'di dowo zë ëdïnnï ame'do ha 'beze aba? ");
INSERT INTO mgc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kya ze maakowe tëmï Patiya, Mediya, Elamo, Mesopotamiya, Yudiya, Kapadɔsiya, Poniyitusu, Asiya, ");
INSERT INTO mgc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Paragiya, Pambaliya, Ezipeto, kapa 'ba Libiya kara ra Sirënë, Roma, ");
INSERT INTO mgc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Keriti, ehe Arabiya. Kya ze maakowe o'jo Yude, ehe maakowe inzi rë nnï zi tëdïnnï na Yude. Ze biya dowo zë ëdïnnï ame'do ta ha 'ba vïdï biya, zi yada kö'du kyige mati Wïrï o'dɔ ne.” ");
INSERT INTO mgc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Da vïdï biya na wïrï wïrï. Maakowe alimannï ha oka ma kölö ko'jo henye, “Kö'du nenye biya a'di?” ");
INSERT INTO mgc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Maakowe o'dɔnnï lasa ra vo lö'böwë 'ba Yere, iyannï henye, “Zë uwënnï a'ji.” ");
INSERT INTO mgc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petero ënyï rïyë vo lïtu 'butë dɔmokölö ne ëtï, ehe ame'do gu kyembe laka aba zi vïdï kayo, iya henye. “E Yude mora e biya mati alime mï Yerusalema, owowe me'do mati momba zi kiya. ");
INSERT INTO mgc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Vïdï nenyee anzannï dë na a'ji kaa mati asösuwë. Kadra 'ba damïndö ëdï madɔmosowɔ. ");
INSERT INTO mgc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nenye ëdï kö'du mati Wïrï ayada zi nëbï Yowele kiya, ");
INSERT INTO mgc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ëzë ndundu 'ba ko'do ɔkɔ ku, ma kï'dï Lawo Laka ama zi vïdï biya. Gisi 'be ma kora mïnzö ëtï akayëtïnnï kö'du kise 'bama. Gisi kora ɔbiye akongɔnnï wa kazi Wïrï. Korokyedre 'be wïrï akisi zë. ");
INSERT INTO mgc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mï ko'do naniye ma kï'dï Lawo ama zi vo kalima ame, 'dö vïdï kora mbara ëtï, akayëtïnnï kö'du kise 'bama. ");
INSERT INTO mgc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma ko'dɔ kö'du koro komorïyë ehe kyïnë 'ba kö'du maakowe lebi dakaŋo. Ani yama atëdï, wa'do ehe kyëtu. ");
INSERT INTO mgc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kadra akopi rë nï na köndu, ehe yehe atëdï na yama gba kazi ko'do bikanyi kyedre 'ba Yere alaya. ");
INSERT INTO mgc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Here Yere akayɔmɔ vïdï biya mati ako'jo kö'du ga wakɔnyi.” ");
INSERT INTO mgc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Vïdï 'ba Yiserele, owowe me'do nenyee. Momba kiya kö'du ga kö'du 'ba Yësu 'ba Nazereta. Wïrï utu Yësu zi ye zi kö'du koro rakaga aba ko'dɔ ehe da kyïnë. E biya ayɔle nenye ku. ");
INSERT INTO mgc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wïrï omba dɔ mo ku nzɔ akï'dï Yësu zi ye. Here obe mo ehe ï'dïyë mo zi kora vo kö'du kyënyë ko'de tëmï tu'dë maakowe zi tötö mo da taka. ");
INSERT INTO mgc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mora Wïrï ila mo na dangölö tëmï koli ehe aliro na dïdï, ga ködu koli ɔ'bɔ dë ta'da mo.” ");
INSERT INTO mgc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Dawidi iya kö'du 'ba Yësu henye, ‘Mongɔ Yere 'duwï kara ra ma, ehe mere dë, mo ëdï ma aba, da kala ma, ma tïrï. ");
INSERT INTO mgc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ga kö'du nenye, di'di ma atëdï na rakyenyi, me'do 'bama atëdï 'ba rakyenyi, lima 'bama atëdï kö'du sösu laka aba. ");
INSERT INTO mgc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yere omba dë zi ma kila bi lima 'ba lawo 'ba vïdï koli, ehe mo omba dë zi kila ida ra vïdï laka 'bɔmo teŋe mï ogo. ");
INSERT INTO mgc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mo ayada zi ma gërï 'ba dïdï, ehe mo o'dɔ ma na rakyenyi tëdï 'bɔmo kara ra ma.’” ");
INSERT INTO mgc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Aboka me, ëdï tïnyö zi ma zi me'do ga kö'du zutu 'beze Dawidi. Mo oli ehe usu, ehe dawogo mo ëdï ze aba kinye ndenye. ");
INSERT INTO mgc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mora Dawidi ne nëbï ra, ehe mo ayɔlɔ henye, Wïrï o'dɔ lömu vïdï maako ta dakota 'bɔmo kadra maako aba atëdï na yere. ");
INSERT INTO mgc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawidi ayɔlɔ nenye ako'dɔ rë nï, ehe mo ayada zi ze akaliro Korisitɔ na dïdï. Mo iya henye, ‘Wïrï ila mo dë mï ogo, mandere ida rɔ mo zi teŋe.’” ");
INSERT INTO mgc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ze biya da katɔ'bɔ yada zi ye henye Wïrï aliro Yësu ku na dïdï. ");
INSERT INTO mgc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Oba Yësu ku komorïyë zi lima da kala tïrï 'ba Wïrï, ehe Wïrï ï'dï Lawo Laka ku zi mo, kaa mati 'Bu alömu. Yësu ra kpa ï'dï Lawo Laka zi ze, ehe nenye ëdï wa mati yaanya aba ëdïyë kongɔ kowo mo aba. ");
INSERT INTO mgc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Dawidi ï'bë dë komorïyë, mora mo iya henye, ‘Yere iya zi Yere 'bama zi lima da kala nï ma tïrï, ");
INSERT INTO mgc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","le ëzë mo o'dɔ vo wehe 'bɔmo ku kaa gba'da 'ba burutu zi mo.’” ");
INSERT INTO mgc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Vïdï 'ba Yiserele biya ayɔlɔ henye, Wïrï o'dɔ Yësu 'dö na Yere ehe na Korisitɔ, ï'dïyë mo le koli rïyë da taka.” ");
INSERT INTO mgc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mati vïdï owonnï kö'du nenye, zë kazi rakyenyi. Zë ako'jonnï ha Petero, vo lïtu maakowe ëtï iyannï henye, “Aboka me, a'di ra da ko'dɔ?” ");
INSERT INTO mgc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero iya zi zë henye, “Otɔ de zi Wïrï tëmï kö'du kyënyë ko'dɔ biya, ïrïyë bapatisi mï ru Yësu Korisitɔ, zi ye kila ga kö'du kyënyë 'be, ehe akïrïyë wakï'dï 'ba Lawo Laka. ");
INSERT INTO mgc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Lömu nenye zi ye gisisi 'bee ëtï, kpa zi vïdï biya mati Yere 'beze Wïrï akinzi, kpa vïdï mati zë na kɔwɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero ayada kö'du kayo maakowe kpa zi zë zi rë nnï kyigɔ, mo iya henye, “Ma lenzee zi re yɔmɔ kazi wa mati ako'dɔ rë nï biya zi vïdï 'ba kö'du kyënyë ko'dɔ nenye.” ");
INSERT INTO mgc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mï kadra nani vïdï kpulukuwota omannï mï kö'du kise, ïrïnnï bapatisi, adrɔko da watiti 'ba vo kö'du kombe. ");
INSERT INTO mgc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Zë ayaŋa kadra 'bënnï mï kö'du yandi kazi vo lïtuwë, rakida, wakonyo 'ba Yere, mötu aba. ");
INSERT INTO mgc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vïdï biya na rakaga ehe na tere ga kö'du wakoro kayo ehe kyïnë wa mati vo lïtuwë o'dɔnnï. ");
INSERT INTO mgc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vo kome nduwë rë nnï tɔtɔ ga bi kölö ehe zë ayanyannï mï wa mati zë ëdïnnï mo aba. ");
INSERT INTO mgc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Zë ogonnï wasisi 'bënnï yaga, ehe ï'dïnnï kɔhi mo zi vïdï ma omba. ");
INSERT INTO mgc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko'do ta ga ko'do, zë atɔtɔ rë nnï mï yëkëlu. Zë onyonnï wa bi kölö mï liŋɔ kutu kutu ehe ayanyannï mï wakonyo 'bënnï na rakyenyi kazi dakumbë, ");
INSERT INTO mgc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ëzë ëdïnnï Wïrï yeto. Vïdï biya omba zë. Ta ga ko'do 'duwï Yere ayövu zë mati ayɔmɔ ku. ");
INSERT INTO mgc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kadra 'ba mötu ëdï kaa kadra wota 'ba hutaga, Petero ehe Yowani aba ëdï tï'bënnï mï yëkëlu. ");
INSERT INTO mgc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kora mati o'jo na keŋe ne ïnjë ha loko 'ba yëkëlu. Ta ga ko'do biya ï'dï mo dakapa ha loko nenye, ako'jo Ha Resi Teme. Mo alima ani ehe wa lenze kazi vïdï mati ëdï tï'bënnï loko. ");
INSERT INTO mgc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kora ne ongɔ Petero ehe Yowani ëdï tödunnï mï yëkëlu, ehe mo ako'jo hë zë kö'du kɔhi. ");
INSERT INTO mgc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Mora zë ongɔnnï bi mbïyï dɔ mo ehe iyannï henye, “Ongɔ bi rïyë de ze.” ");
INSERT INTO mgc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kora ne ongɔ bi dë zë asösu 'bënï na ki'ja wa maako kazi zë. ");
INSERT INTO mgc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mora Petero iya zi mo henye, “Manza dë kɔhi aba, mandere dahabo, mora ma kï'dï zi yï wa mati mëdï mo aba. Mï ru 'ba Yësu Korisitɔ 'ba Nazereta, miya zi yï ënyï rïyë ayeto lasi.” ");
INSERT INTO mgc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petero ïrï mo kala ma tïrï aba akɔnyi mo rïyë. Kandi ndï kora ne gbɔnzɔ mo aba, ayi na kyigɔ, ");
INSERT INTO mgc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ehe mo öfu rïyë, ayeto lasi. Mo ï'bë ga ndï Petero Yowani aba mï yëkëlu, lasi, töfu ehe Wïrï yeto aba. ");
INSERT INTO mgc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vïdï biya ongɔnnï mo lasi toko ehe Wïrï yeto aba. ");
INSERT INTO mgc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Zë ayɔlɔnnï mo kora vo lenze mati ëdï alima ha Resi Teme 'ba yëkëlu ne, zë na rakaga. Zë ɔ'bɔnnï dë yɔlɔ kö'du a'di ra o'dɔ rë nï zi kora ne. ");
INSERT INTO mgc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mati kora ne zɔ ga ndï Petero Yowani aba, vïdï biya ahonnï zi zë bi mati ako'jo loko sënjë 'ba Solomono. ");
INSERT INTO mgc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petero ongɔ vïdï kayo ma atɔtɔ rë nnï ne ehe mo iya henye, “Vïdï 'ba Yiserelee, kö'du a'di e na rakaga ga kö'du mati o'dɔ rë nï ne? Asösuwë dëdï ze kyigɔ maako aba? Asösuwë da tɔ'bɔ ze kora nenye ko'dɔ zi lasi ga kö'du ze na laka? ");
INSERT INTO mgc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wïrï 'ba Abarayama, Yisika, Yakoba, ehe zutu 'bezee, ï'dï ru kyedre zi vo Lïtu 'bënï Yësu. Mora ombe mo dë, ï'dïyë mo zi Pilato zi kofo, mati Pilato omba zi mo kinga na dangölö. ");
INSERT INTO mgc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ombe Yësu dë mo le na laka ehe tïnyö ne. Ako'jowe kö'du kora ma ofo vïdï zi kinga na dangölö, ");
INSERT INTO mgc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ehe ofowe mo ma ï'dï dïdï zi vïdï. Mora Wïrï ïnjë mo tëmï koli, ehe ze biya da tɔ'bɔ yada zi ye wa mati mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Onge kora nenye, ehe ayɔle mo. Koma mï ru 'ba Yësu ra o'dɔ mo kyigɔ. Koma mï Yësu ra o'dɔ kora nenye ti'de na laka. ");
INSERT INTO mgc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Aboka me, ma yɔle ehe vo dagba 'be ayɔlɔnnï dë wa mati zë o'dɔnnï. ");
INSERT INTO mgc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wïrï iya kpuru kazi nëbï ënïyë henye, Korisitɔ ënï aki'ja riti, ehe yaanya aba ne mo asesi lömu ënï ku. ");
INSERT INTO mgc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Here, ote de zi Wïrï, here akila kö'du kyënyë 'be, ");
INSERT INTO mgc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","here kadra akatayi mati Yere akï'dï kyigɔ zi ye, here mo akutu Yësu Korisitɔ, mati mo inzi zi ye. ");
INSERT INTO mgc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mora Yësu akalima komorïyë le ëzë Wïrï o'dɔ wasisi ku biya na kyïyï, kaa mati mo iya kyere kpuru nëbï laka 'bɔmowe aba. ");
INSERT INTO mgc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosa iya henye, ‘Yere Wïrï 'be akinzi vïdï tëmï yë kölö zi tëdï nëbï kpa kaa mo inzi ma. Owowe kö'du mati mo ayada zi ye. ");
INSERT INTO mgc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Vïdï maako mati oro nëbï nenye dë, atanza dë na vïdï 'ba Wïrï löhu.’ ");
INSERT INTO mgc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Nëbï Samowele ehe biya nëbï maakowe mati ayinnï ta gɔ mo, zë ame'donnï ga kö'du wa ma ëdï rë nï ko'dɔ yaanya aba ne. ");
INSERT INTO mgc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","E gisi 'ba nëbïyë ehe ïrïyë lömu 'ba Wïrï ku, mati Wïrï o'dɔ zutu 'be ëtï. Kaa mo iya zi Abarayama henye, ‘Tëmï kozo 'bëyïyë, ma kï'dï ya'da zi vïdï biya 'ba dakaŋo ne.’ ");
INSERT INTO mgc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Wïrï inzi vo lïtu ënï, ehe utu mo dagba zi ye, zi kï'dï ya'da zi ye, here otɔ de tëmï kö'du kyënyë 'be ne.” ");
INSERT INTO mgc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mati Petero Yowani aba ëdïnnï gba ame'do zi vïdïyë, vo kyëlu 'ba vo ga yëkëlu kongɔ, ehe Sadekee ɔkɔnnï. ");
INSERT INTO mgc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kora nenyee na kamo ga kö'du vo lïtuwë ëdïnnï vïdïyë yandi henye, yöku atënyï tëmï koli, kaa Yësu ënyï tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tapëtï kadra kutë, zë ïrïnnï Petero, Yowani aba ï'dïnnï zë mï kamba yɔndɔ aba. ");
INSERT INTO mgc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mora vïdï kayo mati owonnï kö'du kise ne, omannï. Yaanya aba watiti 'ba vo lö'bö ga Yere ëdï kpulukumuyï. ");
INSERT INTO mgc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mï damïndö vere vo dagbe, kyedree, ehe vo komoyandi 'ba kö'du kï'dï 'ba Mosa atɔtɔ rë nnï mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kyedre 'ba vo karase Anasi ëdï ani, Kayafa, Yowani, Alekazende, ehe maakowe ta dakota 'ba vo da karasa. ");
INSERT INTO mgc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Zë ikannï Petero Yowani aba loko, o'dɔnnï zë atɔrɔ kutë, ako'jonnï hë zë, iyannï henye, “Kyigɔ 'ba a'di aba, ehe mï ru 'bëyï o'de kö'du nenye?” ");
INSERT INTO mgc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petero oso ndɔ Lawo Laka aba, iya henye, “Vo dagba 'ba vo dakaŋowe ehe kyedree, ");
INSERT INTO mgc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ëzë ako'jowe he ze ndenye ga kö'du laka mati o'dɔ rë nï, ga kö'du vïdï ma akɔ'jɔ, ");
INSERT INTO mgc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mëdï na yɔlɔ zi ye ehe zi vïdï biya 'ba Yiserele, kora nenye ëdï tɔrɔ kinye na laka ga kö'du kyigɔ 'ba Yësu Korisitɔ 'ba Nazereta, mati ï'dïyë koli da taka, mati Wïrï ïnjë tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yësu ra yïtö mati vo wa kuvöwë ombannï dë, mora yaanya aba mo ra yïtö ma dagba na laka ndra. ");
INSERT INTO mgc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yësu ra nje ëdï kyigɔ aba zi wayɔmɔ. Ru mo ra nje kölö mï damöku ne akatɔ'bɔ yɔmɔ vïdï biya.” ");
INSERT INTO mgc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vïdï kyedree na rakaga mati ongɔnnï Petero Yowani aba erennï dë, ehe zë ayɔlɔnnï vo lïtu rïyö nenyee zë öŋbö kora mbiya ayandi zë dë. Vïdï kyedree ayɔlɔnnï, zë ëdïnnï kyere Yësu aba. ");
INSERT INTO mgc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mora ɔ'bɔnnï dë tandi ga kö'du kora mati akɔ'jɔ ne ëdï tɔrɔ ani. ");
INSERT INTO mgc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kyedree utunnï zë yaga tëmï magalesi. Here zë iyannï zi oka ma kölö maako, ");
INSERT INTO mgc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“A'di ra da ko'dɔ zi kora nenyee? Vïdï biya mï Yerusalema ayɔlɔnnï kö'du koro nenye mati vo lïtuwë o'dɔnnï, ehe dɔ'bɔ dë kiya o'dɔ rë nï dë. ");
INSERT INTO mgc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Zi kö'du nenye sesi mo kazi apere rë nï, diya zi zë, ma me'donnï dë zi vïdï maako löhu mï ru 'ba Yësu.” ");
INSERT INTO mgc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Here zë ako'jonnï vo lïtu rïyö ne hulëhu loko, ehe ayadannï zi zë, ma yandinnï wa maako dë mï ru 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petero Yowani aba aya'bannï dɔ mo zi zë iyannï henye, “Asösuwë Wïrï omba ze, zi ye ra koro, mandere zi mo ra koro? ");
INSERT INTO mgc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dɔ'bɔ dë lima ti, ga kö'du wa ma dongɔ ehe dowo.” ");
INSERT INTO mgc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kyedree i'jannï kö'du maako dë na kyënyë zi riti kï'dï zi Petero ehe Yowani, here zë ilannï zë na dangölö. Vïdï biya Wïrï yeto aba ga kö'du ma o'dɔ rë nï. ");
INSERT INTO mgc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kora mati akɔ'jɔ kö'du koro nenye aba, kɔɔ 'bɔmo ndra ta da 'butësowɔ. ");
INSERT INTO mgc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kandi mati ila Petero ehe Yowani aba na dangölö, zë a'bannï hulëhu ehe ayadannï zi okannïyë kö'du mati kyedree 'ba vo karase ehe vo dagbe iyannï zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mati kɔsɔ vo lö'böwë 'ba Yere owonnï kö'du nenye, zë amötunnï zi Wïrï na radrɔko ehe iyannï henye, “Yere, o'dɔ komorïyë, dakaŋo, ranga, wasisi biya mï zë, ");
INSERT INTO mgc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","mï kyigɔ 'ba Lawo Laka, ame'do zi zutu 'beze Dawidi, vo lïtu 'ba Wïrï, iya henye, ‘Kö'du a'di tu'dëë biya na kamo? Kö'du a'di vïdï ëdïnnï kö'du sösu ma lumë ne ko'dɔ? ");
INSERT INTO mgc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yere 'ba dakaŋo akɔ'jɔ rë nnï kö'du wehe, ehe vo daliŋe adrɔko rë nnï da Yere ehe Masiya 'bɔmo.’” ");
INSERT INTO mgc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Kinye mï Yerusalema, Heroda ehe Ponitisi Pilato atɔtɔ rë nnï tu'dëë ëtï ehe vïdï 'ba Yiserele. Here zë ofɔ rë nnï ra vo lïtu laka 'bëyï Yësu, Masiya kinzi 'bëyï. ");
INSERT INTO mgc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Zë o'dɔnnï wa mati omba zi ko'dɔ na kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yere, owo me'do tere 'bëzë. Akɔnyi vo lïtu 'bëyïyë, here o'dɔ ze na kyigɔ zi me'do kö'du kise 'bëyï. ");
INSERT INTO mgc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ayada kyigɔ kyedre 'bëyï, kaa ëdï vïdï kɔ'jɔ ehe kö'du koro ko'dɔ, rakaga aba mï ru laka 'ba vo lïtu 'bëyï Yësu.” ");
INSERT INTO mgc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tapëtï amötunnï ku, bi 'ba ratɔtɔ akɔhɔ rë nï. Zë osonnï ndɔ Lawo Laka aba, ayetonnï me'do mï kö'du kise a Wïrï ne kazi tere. ");
INSERT INTO mgc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Gboko 'ba vo lö'böwë kö'du sösu 'bëzë biya kölö. Vïdï maako iya dë wa biya mati ëdïnnï mo aba ne 'bënï ra, mora zë ayanyannï mï wa oka ma kölö maako aba. ");
INSERT INTO mgc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kyigɔ aba vo lïtuwë ayadannï zi vïdï biya henye, Yësu ëdï yaanya aba na dïdï. Wïrï ï'dï ya'da zi vo lö'bö 'bënïyë. ");
INSERT INTO mgc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Vïdï maako ï'bë dë kö'du sösu aba ga kö'du wa, ga kö'du vïdï ma ëdï kaŋo aba mandere lokowe, akogo zë yaga ehe ika kɔhi mo ne zi ");
INSERT INTO mgc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","vo lïtuwë. Here zë ï'dïnnï kɔhi mo ne zi vïdï ma omba. ");
INSERT INTO mgc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yosepa mo kozo 'ba Lëvï, ta Seyipurusu, mati vo lïtuwë ako'jonnï mo Baranaba, kö'du ya'ba aba vïdï 'ba kö'du laka kiya zi oka, ");
INSERT INTO mgc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","mo ogo yaka 'bënï yaga, ehe ika kɔhi mo zi vo lïtuwë. ");
INSERT INTO mgc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kora maako ru mo Ananiya, mbara 'bënï Safira aba, ogonnï kaŋo 'bënnï yaga. ");
INSERT INTO mgc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mora idannï da kö'du zi sesi kya 'ba kɔhi ne, na 'bënnï. Here mati Ananiya oba kɔsɔ kɔhi ne zi vo lïtuwë, ");
INSERT INTO mgc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petero iya zi mo henye, “Ananiya, kö'du a'di ï'dï Satani yï ko'ba, zi sesi kya 'ba kɔhi mati i'ja ta da kaŋo ma ogo ne? Kö'du a'di iga ndɔndɔ zi Lawo Laka? ");
INSERT INTO mgc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wa ne 'bëyï ra mati gba ogo dë, ehe kpa tapëtï kogo mo, kɔhi mo gba zɔ na 'bëyï. A'di ra o'dɔ yï zi kö'du ma here ne ko'dɔ? Iga ndɔndɔ ne dë zi vïdï, iga ndɔndɔ ne zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kandi mati Ananiya owo kö'du ne, mo alëpï akaŋo brua na yöku. Vïdï biya mati owonnï ne, biya na tere. ");
INSERT INTO mgc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gisi kora ɔbi ayinnï loko, ehe olonnï ida rɔ mo. Here zë ïnjënnï yaga, usunnï. ");
INSERT INTO mgc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kadra wota aba yaa, mbara 'bɔmo Safira ayi loko, mora ayɔlɔ kö'du mati o'dɔ rë nï zi kora 'bënï ne dë. ");
INSERT INTO mgc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero ako'jo hɔ mo iya henye, “Ayada zi ma, ogowe kaŋo ne da kɔhi nenye?” Mo alëzë iya henye, “Ɔɔ, kɔhi ne mo ra biya ne.” ");
INSERT INTO mgc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petero iya zi mo henye, “Kö'du a'di yï kora 'bëyï aba rïyö, ide me'do zi yɔnzɔ Lawo Laka? Kora mati usunnï Ananiya, ëdïnnï ha loko, ehe akumbënnï yï yaga.” ");
INSERT INTO mgc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kandi mo alëpï burutu Petero oli. Mati gisi kora ɔbi nee, ayinnï hulëhu loko, i'jannï Safira ako'do ani na yöku. Here zë ïnjënnï mo yaga ehe usunnï mo dakapa kora 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kanisa na tere, ehe vïdï biya mati owonnï kö'du ma o'dɔ rë nï ne. ");
INSERT INTO mgc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vo lïtuwë o'dɔnnï kö'du koro rakaga aba kyɔ mï kutë vïdï. Vo kusu ga Yere biya 'duwï rë nnï tɔtɔ mï kapa 'ba yëkëlu ako'jo loko sënjë 'ba Solomono. ");
INSERT INTO mgc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Vïdï maakowe yaga tëmï gboko 'bëzë omba dë zi rë nï drɔko zë aba, mora vïdï biya ombannï zë le ndra. ");
INSERT INTO mgc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Vïdï kora kyɔ ehe mbara ayetonnï koma mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Here vïdï rakɔe ika zë yaga da gërï o'ba da agburuku. Asösunnï ëzë Petero alasi ta dakapa, ehe galïlï mo akalëpï dë zë, akakɔ'jɔ zë. ");
INSERT INTO mgc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vïdï kayo ma ëdïnnï alima mï gawowe kara Yerusalema, ikannï zë mati rakɔɔ aba mandere zë mati dakyikyi aba mï nnï, akɔ'jɔ zë biya. ");
INSERT INTO mgc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kyedre 'ba vo karase ehe Sadeke biya osonnï ndɔ na mïkumbë. ");
INSERT INTO mgc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Zë ïrïnnï vo lïtuwë, ï'dïnnï zë mï kamba ta da komo vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mora mï yɔndɔ nani malayika kazi Yere ayëhu ha loko 'ba kamba, ayasi vo lïtuwë yaga. Malayika iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ï'bëë mï yëkëlu, ehe ayade zi vïdï me'do 'ba dïdï nenye biya.” ");
INSERT INTO mgc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Here zë ï'bënnï kadra asi ku nzere, ehe ayetonnï kö'du yandi mï yëkëlu. Kyedre 'ba vo karase vïdï 'bënï ëtï ako'jonnï ga bi kölö magalesi mati zë kyedree 'ba Yiserele. Ï'dïnnï kö'du zi vo lïtuwë kika zi nnï tëmï kamba. ");
INSERT INTO mgc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Vo kanya 'ba yëkëlu mati utu zë mï kamba, i'jannï vo lïtuwë dë. Zë a'bannï, iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Di'ja ze kamba na kisi ŋbïrï, ehe vo kanye ëdï tɔrɔnnï ha loko. Mora mati da yëhu ha loko, ehe dödu mï mo, di'ja vïdï maako dë ani.” ");
INSERT INTO mgc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kyedre vo kanye 'ba yëkëlu ehe kyedree 'ba vo karase owonnï kö'du kiya 'bëzë ne, mora ayɔlɔnnï dë a'di ra sösunnï atëdï. ");
INSERT INTO mgc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Vïdï maako ayi ödu loko iya henye, “Yaanya aba kora naniye, mati ï'dïyë mï kamba ëdïnnï mï yëkëlu vïdï yandi.” ");
INSERT INTO mgc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kyedre vo kanya 'ba yëkëlu ï'bënnï vo kanye ëtï ehe ikannï vo lïtuwë hulëhu, mora o'dɔnnï zë dë na kamo, ga kö'du zë na tere kazi vïdï ayetonnï zë ku'du yïtö aba. ");
INSERT INTO mgc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mati ika vo lïtuwë ku komo magalesi, kyedre 'ba vo karase iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Da yada ku huwë zi ye, ayandiye kö'du dë mï ru 'ba Yësu. Mora onge wa mati o'de ne te. Ëdï yandiye vïdï biya mï Yerusalema, ehe ëdï ayɔnze zi kö'du koli 'bɔmo ya'ba gu ze.” ");
INSERT INTO mgc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero vo lïtu maakowe ëtï aya'bannï dɔ mo iyannï henye, “Doro ze Wïrï ndra ta da vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ofowe Yësu mo tötö aba da taka, mora Wïrï 'ba zutu 'beze ïnjë mo na dïdï. ");
INSERT INTO mgc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wïrï o'dɔ mo na vo dagba 'beze ehe na vo wayɔmɔ. Wïrï ï'dï bi zi mo da kala nï ma tïrï, ehe vïdï 'ba Yiserelee ata'bannï hulëhu zi mo ehe akila kö'du kyënyë 'bëzë. ");
INSERT INTO mgc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ze kinye zi yada kö'du nenye biya zi ye, ehe Lawo Laka zi yada kpa zi ye, mo wakï'dï 'ba Wïrï zi vïdï biya ma oro Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mati vïdï 'ba vurëë owonnï kö'du nenye, zë ayinnï na kamo, ombannï zi kofo vo lïtuwë. ");
INSERT INTO mgc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mora ma kölö maako tëmï zë, Farasi ru mo Gamalili, mo vo komoyandi 'ba kö'du kï'dï ma oro mo ndra. Mo ï'dï kö'du zi vo lïtuwë koba dero tisi yaa yaga. ");
INSERT INTO mgc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Here mo iya zi vïdïyë 'ba mï vurëë henye, “Kora 'ba Yiserele, komowe mandi re kö'du wa mati ëdï ko'de zi kora nenyee. ");
INSERT INTO mgc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tadura alaya kadra ma alaga nani aba, o'dɔ rë nï na vïdï kyedre maako, ehe vïdï kora kaa lamisowɔ adrɔko rë nnï mo aba. Mora mati ofo mo, vo ga ndï mo apere rë nnï biya, kö'du 'bɔmo ne inde rë nï. ");
INSERT INTO mgc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yaa mati iti ga vïdï 'ba dakaŋo 'beze, Yudasi tëmï Galilaya alaya kpa. Vïdï kayo alö'bönnï ga ndï mo, mora ofo mo, ehe vo lö'bö ga ndï mo apere rë nnï biya. ");
INSERT INTO mgc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Here miya zi ye tëdïyë na kɔwɔ ta ra kora nenyee. Ile zë na bi dë nnï. Ëzë kö'du ko'dɔ 'bëzë ne 'ba vïdï köndu, akinde rë nï. ");
INSERT INTO mgc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mora ëzë ayi kazi Wïrï, ɔ'be dë yata, nje ëzë ombe zi wehe ko'dɔ Wïrï aba.” Vo vurëë ombannï da me'do 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Zë ako'jonnï vo lïtuwë hulëhu loko, u'bönnï zë, ehe ï'dï kö'du zi zë, ma me'donnï dekpe löhu mï ru 'ba Yësu. Ilannï zë tï'bë. ");
INSERT INTO mgc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Vo lïtuwë ilannï magalesi rakyenyi aba, ga kö'du Wïrï o'dɔ zë zi riti ki'ja ga kö'du 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Duwï ayaŋa kadra 'bënnï mï yëkëlu, ehe mï liŋɔ kölö maako ta ga agamo ɔrɔnnï dë ta bi kö'du yandi, ehe yada kö'du yöyö laka Yësu ra Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mï kadra naniye, vïdï kayo ayinnï adrɔko rë nnï vo lö'böwë. Kya maakowe mati ëdïnnï ame'do ha 'ba Gïrïgï aba ne, ayetonnï rë nnï lamo zë mati ëdïnnï ame'do ha 'ba Hïbïru aba. Zë iyannï henye, mbara lu'bë ma ëdïnnï ame'do ha 'ba Gïrïgï aba ne, ï'dï mï wayanya 'ba wakonyo 'bëzë dë ta ga ko'do biya. ");
INSERT INTO mgc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Vo lïtu 'butë dɔmorïyö ako'jonnï gboko 'ba vo lö'böwë bi kölö, iyannï henye, “Dɔrɔ ze dë ta bi yëtï kö'du kise 'ba Wïrï zi lɔɔ 'ba wakonyo ra yanya. ");
INSERT INTO mgc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aboka me, inziye vïdï kora madɔmorïyö mati vïdï ɔwɔ zë, ehe ayɔlɔnnï kö'du, ehe osonnï ndɔ Lawo Laka 'ba Wïrï aba. Da kï'dï zë na vo ga lɔɔ nenye kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Da katɔ'bɔ yanya kadra 'beze mötu aba ehe me'do 'ba Wïrï yëtï.” ");
INSERT INTO mgc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kö'du sösu nenye o'dɔ vïdï biya na rakyenyi ehe inzinnï Setifano. Mo ëdï koma kyedre aba ehe oso ndɔ Lawo Laka aba. Zë inzinnï Pilipo kpa, Porusi, Nikonara, Timotiyɔ, Paramenasi, Nikɔla tëmï Atiyɔkɔ, mati inzi rë nï zi tëdïnnï na Yude. ");
INSERT INTO mgc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kora nenyee ika zë zi vo lïtuwë. Here vo lïtuwë amötunnï, ï'dï kala nnï da kora nee, zi kinzi zë zi lɔɔ nenye ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kö'du kise 'ba Wïrï apere rë nï, ehe vïdï kayo mï Yerusalema ayinnï zi tëdï na vo lö'böwë. Vo karasa kayo oronnï koma. ");
INSERT INTO mgc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wïrï ï'dï kyigɔ zi Setifano zi kö'du koro kyedre ko'dɔ ehe rakaga mï kutë vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mora vïdï kora maakowe tëmï Sirënë ehe Alikazenderiya, zë tëmï gboko ma ako'jo rë nnï “Kora 'ba dangölö.” Zë ayeto hë nnï wasa Setifano aba. Maakowe tëmï gawo 'ba Silisiya ehe Asiya awasa hë nnï kpa mo aba. ");
INSERT INTO mgc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mora zë ɔ'bɔnnï dë Setifano aba, ga kö'du mo vo kö'du yɔlɔ kyedre ehe Lawo Laka ï'dï kyigɔ zi mo me'do. ");
INSERT INTO mgc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Zë ogonnï vïdï kora kyënyëë zi zë kiya henye, “Dowo ze mo ëdï ame'do na kyënyë ra Mosa ehe Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Zë o'dɔnnï vïdïyë, kyedre 'bënnï ehe vo komoyandiye 'ba kö'du kï'dï 'ba Mosa zi kö'du kyënyë sösu ra Setifano. Zë biya ïrïnnï mo ehe ikannï mo komo magalesi. ");
INSERT INTO mgc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kya 'ba vïdï kora maakowe idannï kö'du zi ndɔndɔ kiga gu Setifano, ehe zë iyannï henye, “Kora nenye 'duwï ëdï ame'do na kyënyë ra yëkëlu laka nenye ehe kö'du kï'dï 'ba Mosa. ");
INSERT INTO mgc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dowo ze mo ëdï akiya henye, ‘Yësu 'ba Nazereta nenye, akiha akaŋo yëkëlu ne ehe akuwï dalëtï mati Mosa ï'dï zi ze ne.’” ");
INSERT INTO mgc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Zë biya mati mï gboko 'ba magalesi ongɔnnï bi da Setifano. Zë ongɔnnï komo mo uwï rë nï kaa komo 'ba malayika. ");
INSERT INTO mgc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kyedre 'ba vo karase ako'jo ha Setifano, “Ëdïnnï kö'du tïnyö ra yada rë yï?” ");
INSERT INTO mgc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Setifano aya'ba da me'do iya henye, “Önduwë ehe 'buwë, owowe me'do 'bama. Wïrï 'ba bikanyi kyedre alaya zi zutu 'beze Abarayama, mati mo ëdï gba mï Mesopotamiya, gba kazi rë nï kidra zi Harani. ");
INSERT INTO mgc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wïrï ayada zi mo, iya henye, ‘Ila dakaŋo 'bëyï, karo 'bëyï, ehe ï'bë dakaŋo mati ma kayada zi yï.’ ");
INSERT INTO mgc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Here Abarayama ila dakaŋo 'ba Sadiyana ï'bë alima mï Harani. Tapëtï koli 'ba 'bu mo, Wïrï utu Abarayama zi lima mï dakaŋo nenye yaanya aba ëdï alime 'dɔmo ne. ");
INSERT INTO mgc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wïrï ï'dï kapa maako dë zi mo, gbï le ma tisi mo. Mora Wïrï alömu zi kï'dï zi mo dakota 'bënï ëtï ŋburu, ëzë Abarayama anza dë le gisisi aba. ");
INSERT INTO mgc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wïrï iya henye, ‘Kozo 'ba Abarayama akalimannï tisiwa aba mï dakaŋo 'ba vo leze. Ani zë atëdïnnï na vo kalima, oka ako'dɔ zë na kyënyë kɔɔ lamisowɔ. ");
INSERT INTO mgc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mora ma kï'dï riti zi vïdï ma o'dɔnnï zë na vo kalima oka. Here yaa zë atayinnï ma mötu ga bi nenye.’” ");
INSERT INTO mgc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Wïrï ida kö'du Abarayama aba, mo o'dɔ kyïnë 'ba kö'du kida ne ŋbete aba. Here mati o'jo Yisika zi Abarayama, tapëtï ko'do mamodɔmowota, Abarayama aŋbete mo. Yaa Yisika ayi na 'bu zi Yakoba, here Yakoba ayi na 'bu zi gisi 'bënïyë 'butë dɔmorïyö, mati zë ra vïdï dagbe 'ba daliŋɔ 'butë dɔmorïyö 'ba Yiserele. ");
INSERT INTO mgc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Vïdï kora nenyee zutu 'beze ra, zë na mï kumbë ra öndu nnï Yosepa. Zë ogonnï mo na vo kalima mï Ezipeto, mora Wïrï ëdï mo aba. ");
INSERT INTO mgc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Wïrï ayɔmɔ mo biya tëmï riti 'bɔmo ne, o'dɔ mo kora vo kö'du yɔlɔ zi Yere 'ba Ezipeto. Mo o'dɔ Yosepa na Yere 'ba Ezipeto ehe ï'dï mo na vo da wa biya mati mo ëdï mo aba.” ");
INSERT INTO mgc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mï kadra nani mï Ezipeto ehe Kanana nyenyo ana dë. Madöyï kyënyë riti ehe zutu 'bezee ɔ'bɔnnï dë zi wakonyo ki'ja kyɔ zi konyo. ");
INSERT INTO mgc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mati Yakoba owo henye nyenyo ëdï mï Ezipeto, mo utu gisi 'bënï zutu 'bezee mï ma dagba ani. ");
INSERT INTO mgc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mï kadara tï'bë 'bëzë ma da rïyö mo, Yosepa ayada rë nï zi öndu nïyë, ëyï ra nï, ehe yere 'ba Ezipeto ayɔlɔ vo dakota 'ba Yosepa. ");
INSERT INTO mgc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosepa utu lïtu zi 'bu nï ehe karo nïyë zi tayi. Watiti 'bëzë ëdï 'butëmadɔmorïyö dɔmomuyï. ");
INSERT INTO mgc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","'Bu mo Yakoba ï'bë mï Ezipeto ehe oli kpa, kaa zutu 'bezee. ");
INSERT INTO mgc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yaa yöku zë ïnjë hulëhu mï Sikimo, ehe usu zë mï wogo, mati Abarayama ogo kazi gisi 'ba Hamora.” ");
INSERT INTO mgc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ndundu mo aba kadra ɔkɔ zi Wïrï zi ko'dɔ wa ma mo alömu zi Abarayama. Watiti 'ba vïdï 'beze mï Ezipeto övu ku kyedre. ");
INSERT INTO mgc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Here yere maako ayi da kyïtï mï Ezipeto, mo ayɔlɔ Yosepa dë. ");
INSERT INTO mgc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mo o'dɔ zutu 'beze na kyënyë, ehe na kamo zë ëtï. Mo o'dɔ zë zi gisi 'bënnïyë kila yaga zi koli. ");
INSERT INTO mgc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mï kadra nenye o'jo Mosa. Mo wisi na teme komo Wïrï, ehe vo dakota 'bɔmo ongɔnnï gɔ mo mï liŋɔ 'ba 'bu mo yehe wota aba. ");
INSERT INTO mgc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mati o'dɔ zë na wehe zi mo kila yaga, wu'jë 'ba yere i'ja mo ehe ïrï mo, kaa wisi ënï. ");
INSERT INTO mgc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mosa i'ja wayandi laka mï Ezipeto. Mo kora kyigɔ ehe me'do 'bɔmo na laka.” ");
INSERT INTO mgc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mati kɔɔ 'ba Mosa ëdï 'butësowɔ, mo ï'bë vïdï 'bënï Yiserele kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ko'do kölö maako aba, mo i'ja vïdï 'ba Ezipeto ëdï vïdï ma kölö tëmï vïdï 'bënïyë ko'dɔ na kyënyë. Mo akɔnyi vïdï 'bënï ne, ofo vïdï 'ba Ezipeto ne. ");
INSERT INTO mgc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosa asösu vïdï 'bënïyë ayɔlɔnnï ku, Wïrï ako'dɔ nï zi zë kinga na dangölö, mora zë ayɔlɔnnï dë. ");
INSERT INTO mgc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mï ko'do vere aba, Mosa i'ja vïdï 'bënï Yiserele rïyö ëdïnnï rë nnï ku'bö, ehe mo ayɔnzɔ zi zë yata. Mo iya henye, ‘E kora nee na öndu, kö'du a'di ëdïyë re ku'bö gɔ mo?’ ");
INSERT INTO mgc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mora kora mati ayeto oka nï ku'bö, adu'du Mosa dakapa, ehe ako'jo kö'du iya henye, ‘Ëyï ra o'dɔ yï na vo de ze, vurë 'beze kikye aba? ");
INSERT INTO mgc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Omba zi kofo ma, kaa ofo vïdï 'ba Ezipeto mataganya ne?’ ");
INSERT INTO mgc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mati Mosa owo kö'du ne, mo aho tëmï Ezipeto ï'bë alima mï dakaŋo 'ba Mediyana. Gisi rïyö 'bɔmo nee o'jo ani.” ");
INSERT INTO mgc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tapëtï kɔɔ 'butësowɔ, malayika alaya zi Mosa mï wa'do möku mï da lïpï kara ra Döku 'ba Sinayi. ");
INSERT INTO mgc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosa na rakaga kö'du wa mati mo ongɔ ne. Mo ï'bë kara zi kongɔ mo na laka, ehe gu Yere iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ma Wïrï 'ba zutu 'be, mati Abarayama, Yisika, ehe Yakoba ëdïnnï amötu.’ Mosa ayeto tese tere aba, ehe omba dë zi bi kongɔ da möku ne. ");
INSERT INTO mgc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yere iya zi mo henye, ‘Otɔ kamoka 'bëyï nee 'de, ga kö'du bi ma ëdï tɔrɔ 'dɔmo ne kaŋo laka ra. ");
INSERT INTO mgc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Komo ma aba, mongɔ riti 'ba vïdï 'bama mï Ezipeto ne ku. Mowo rala'ba 'bëzë ne ku, ehe mayi ku akaŋo zi yɔmɔ zë. Yaanya aba ne, momba yï kutu hulëhu mï Ezipeto.’ ");
INSERT INTO mgc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosa kölö nere ra vïdï 'ba Yiserele ombannï dë, iyannï zi mo henye, ‘Ëyï ra o'dɔ yï na vo de ze ehe vo vurë kikye?’ Malayika 'ba Wïrï ame'do zi Mosa mï möku, ehe Wïrï utu Mosa zi yɔmɔ Yiserelee ehe zi tëdï na vo dagba 'bëzë. ");
INSERT INTO mgc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosa agaga zë tëmï Ezipeto, ehe da Ranga Kahi, ehe mï da lïpï kö'du koro ko'dɔ rakaga aba kɔɔ 'butësowɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosa ra iya zi vïdï 'ba Yiserele henye, ‘Wïrï akinzi kölö tëmï kutë vïdï 'be zi tëdï na nëbï kaa mo inzi ma.’ ");
INSERT INTO mgc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosa ika vïdï 'beze mï da lïpï, ehe malayika ame'do zi mo da Döku 'ba Sinayi. Ani mo ïrï me'do 'ba dïdï zi kï'dï zi ze.” ");
INSERT INTO mgc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mora zutu 'bezee ombannï dë zi Mosa koro, zë ombannï ta'ba hulëhu mï Ezipeto. ");
INSERT INTO mgc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Vïdï iyannï zi Arona henye, ‘O'dɔ wïrï maakowe zi laga dagba zi ze. Mosa ika ze yaga ta Ezipeto, mora da yɔlɔ dë a'di ra o'dɔ rë nï zi mo.’ ");
INSERT INTO mgc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Zë o'dɔnnï wïrï mbiya na da kyïnë isa kora, zë ï'dïnnï wakumu zi mo, ehe na rakyenyi kö'du wa mati o'dɔnnï ne. ");
INSERT INTO mgc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wïrï opi gë nï zi vïdï 'bënï, ehe ila zë zi mötu kyëlu mï komorïyë, kaa ma iya mï wayöruwë 'ba Nëbïyë, ‘Vïdï 'ba Yiserele, ï'dïyë wakumu dë zi ma ehe wakï'dï zi ma mï kɔɔ 'butësowɔ aba mï da lëpï ne? ");
INSERT INTO mgc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tapëtï mo ïnjë loko tisi 'ba wïrï Molesi zi mötu, ehe obe kyëlu 'ba wïrï Repena kpa. O'de wïrï mbiya nenyee zi mötu, mora yaanya aba ma kïnjëë 'de kafo dakaŋo 'ba Babalönï.’ ");
INSERT INTO mgc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Mï da lïpï zutu 'bezee o'dɔnnï bi lima 'ba Wïrï, kaa Wïrï ayada zi Mosa ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yaa ï'dï zi zutu 'bezee, ehe zë obannï mo mati ëdï tï'bënnï Yasowa aba zi kïrï dakaŋo ne kazi vïdï naniye mati Wïrï ore yaga. Mo alima ani le mï kadra 'ba Dawidi. ");
INSERT INTO mgc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawidi o'dɔ Wïrï na rakyenyi, ehe ako'jo hɔ mo ëzë na tɔ'bɔ zi kuvö loko 'ba Wïrï zi gisi 'ba Yakoba. ");
INSERT INTO mgc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ndundu mo aba Solomono ra o'ba loko ne zi Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mora Wïrï Kyedre alima dë mï loko mati vïdï köndu ra uvö. Ëdï kaa nëbï iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Wïrï iya henye, Komorïyë kyïtï 'bama, dakaŋo gara 'ba ndï ma. Kyïnë 'ba loko a'di ra akuvë zi ma? Mï bi vala ra ma kalawo? ");
INSERT INTO mgc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mo'dɔ wasisi ku biya?’” ");
INSERT INTO mgc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“E vo kazi kö'du kowo, ehe vïdï 'ba da kyigɔ! Ëdïyë kaa vïdï mati ombannï ŋbete dë. E 'duwï wehe ko'dɔ Lawo Laka aba, kaa zutuwë o'dɔnnï! ");
INSERT INTO mgc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nëbï maakowe ëdïnnï mati zutu 'be o'dɔ zë dë na kyënyë? Zë ofonnï nëbïyë mati ayadannï kö'du tayi 'ba Wïrï ma Tïnyö. Yaanya aba asusuwë mo, ehe ofowe mo. ");
INSERT INTO mgc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Malayika ï'dïnnï kö'du kï'dï 'ba Wïrï zi ye, mora gba orowe dë.” ");
INSERT INTO mgc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mati vo vurë owonnï me'do 'ba Setifano, zë ayinnï na kamo kyïrïnnï konyo aba, ");
INSERT INTO mgc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","mora Setifano oso ndɔ Lawo Laka aba. Mo ongɔ bi komorïyë, ongɔ bikanyi kyedre 'ba Wïrï, ehe Yësu ëdï tɔrɔ da kala tïrï 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Mo iya henye, “Mongɔ komorïyë ayëhu rë nï, Wisi 'ba Vïdï ëdï tɔrɔ da kala tïrï 'ba Wïrï.” ");
INSERT INTO mgc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Vo vurë nee agbögbö hë nnï na gu kyembe ehe isi mbili nnï. Kandi zë biya alɔdrɔnnï da Setifano, ");
INSERT INTO mgc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ehe u'dunnï mo yaga tëmï gawo kyedre ne. Ayetonnï mo ku'du yïtö aba. Vo kiye o'bannï bɔngɔ 'bënnï ndï kora maaako ru mo Sawolo. ");
INSERT INTO mgc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mati ëdïnnï Setifano ku'du yïyö aba zi koli, mo ako'jo yaga, iya henye, “Yere Yësu, ïrï lawo ma kalakyedre aba!” ");
INSERT INTO mgc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mo odrɔ domo nï akaŋo, ehe udu gu kyembe aba iya henye, “Yere, aya'ba kö'du kyënyë ko'dɔ 'bëzë ne dë, dë zë.” Here mo oli. ");
INSERT INTO mgc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawolo ra omba da ku'du 'ba Setifano yïtö aba. Mï kadra nani kanisa mï Yerusalema mï rayaza kyedre. Biya vo lö'böwë ga Yere, nje vo lïtuwë, apere rë nnï mï Yudiya ehe Samariya. ");
INSERT INTO mgc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kya vo koma maakowe usunnï Setifano ehe ï'dïnnï lu'bë kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawolo ayeto kö'du kyënyë ko'dɔ zi kanisa. Mo ï'bë ta haliŋɔ ta haliŋɔ kïrï vïdï kora ehe vïdï mbara zë kï'dï mï kamba. ");
INSERT INTO mgc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Vo lö'böwë ga Yere ma apere rë nnï ne, ï'bënnï ta ga bi biya kö'du yöyö laka ne yada mo aba. ");
INSERT INTO mgc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipo ï'bë mï gawo kyedre 'ba Samariya ehe ayöyö kö'du 'ba Korisitɔ ne zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Zë oze mbili nnï zi Pilipo, kaa mati zë owonnï ehe kongɔnnï kö'du koro mati mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vïdï kayo dakyikyi aba akɔ'jɔ zë, ehe dakyikyi ï'bënnï yaga ta rë zë ha gbögbö aba. Vo keŋe kayo ehe vo ka'bo akɔ'jɔ zë. ");
INSERT INTO mgc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Vïdï biya mï gawo nani na rakyenyi, ga kö'du ma ëdï rë nï ko'dɔ ne. ");
INSERT INTO mgc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kadra maako aba kora maako ru mo Simona alima ani vïdï 'ba Samariya ko'dɔ na rakaga. Mo ëdï mörï ko'dɔ ehe o'dɔ rë nï na vïdï kyedre maako. ");
INSERT INTO mgc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vïdï biya ma wadakayo aba ehe vo leri atɔtɔ rë nnï toko rɔ mo, zë iyannï henye, “Kora nenye vo kyigɔ 'ba Wïrï, ma ako'jo Kyigɔ ma Kyedre.” ");
INSERT INTO mgc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kadra konda aba, Simona ëdï mörï ko'dɔ zi vïdï ko'dɔ na rakaga, ehe zë asesi rë nnï tɔtɔ toko rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mora mati zë omannï ku mï kö'du kiya 'ba Pilipo, ga kö'du 'ba Damöku 'ba Wïrï ehe ru 'ba Yësu Korisitɔ, abapatisi zë biya kora mbara aba. ");
INSERT INTO mgc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona oma kpa, ehe abapatisi mo. Mo alima kara zi Pilipo, ga kö'du mo ongɔ bi biya da kö'du koro ne rakaga aba. ");
INSERT INTO mgc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Vo lïtuwë mï Yerusalema owonnï henye, kya vïdï maakowe mï Samariya ïrïnnï me'do 'ba Wïrï ku. Here zë utunnï Petero ehe Yowani zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mati vo lïtu rïyö nenye ɔkɔnnï, zë amötunnï henye zi zë kïrï Lawo Laka. ");
INSERT INTO mgc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gba kazi nenye, Lawo Laka ï'dï dë gba zi ma kölö maako tëmï zë, abapatisi zë ïnjë mï ru 'ba Yere Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petero, Yowani aba ï'dï kala nnï da vïdï 'ba Samariye, ehe zë ïrïnnï Lawo Laka. ");
INSERT INTO mgc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simona ongɔ Lawo Laka ï'dï zi vo kome mati vo lïtuwë ï'dï kala nnï dë zë. Here mo ï'dï kɔhi ");
INSERT INTO mgc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","zi Petero, Yowani aba ehe iya henye, “Ï'dï kyigɔ nenye kpa zi ma, ëzë vïdï maako mï'dï kala ma ku dɔ mo, akïrï Lawo Laka.” ");
INSERT INTO mgc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mora Petero iya zi mo henye, “Yï 'dö kɔhi 'bëyï ne aba akinde re mï wa'do, ga kö'du asösu zi wakï'dï 'ba Wïrï kogo kɔhi aba. ");
INSERT INTO mgc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nenye anza dë lɔɔ 'bëyï, ehe Wïrï ongɔ ku di'di yï anza dë na laka. ");
INSERT INTO mgc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Otɔ dë yï tëmï kö'du sösu kyënyë 'bëyï ne, ehe ako'jo ha Wïrï zi kila yï. ");
INSERT INTO mgc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mongɔ yï ndɔ na mïkumbë, ehe ida yï ku gö mï gërï kö'du kyënyë ko'dɔ 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simona iya henye, “Amötu zi Yere, here kö'du ma iya ne mo'dɔ rë nï dë zi ma.” ");
INSERT INTO mgc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tapëtï Petero ehe Yowani aba ayëtïnnï kö'du 'ba Yere ku, a'bannï zi Yerusalema. Ta da gërï 'bëzë, zë ayëtïnnï kö'du yöyö laka ne mï daliŋɔ kayo 'ba Samariya. ");
INSERT INTO mgc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malayika 'ba yere iya zi Pilipo henye, “Ï'bë dambaro da gërï konda 'ba lïpï mati ï'bë ta Yerusalema zi Gaza.” ");
INSERT INTO mgc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Here Pilipo ï'bë. Kora lïmu mï turu 'ba Atepïyö ëdï kpa tï'bë ta da gërï nani mï gbugbuṛu. Mo kyedre 'ba vo kɔhi sesi zi Kadasi, mati ëdï mbara yere 'ba Atepïyö. Mo ï'bë mï Yerusalema zi mötu, ehe yaanya aba ëdï ku da ga gërï ënï liŋɔ. Mo ëdï alima mï gbugbuṛu ënï kö'du ko'jo tëmï wayöruwë 'ba nëbï Yisaya. ");
INSERT INTO mgc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lawo Laka iya zi Pilipo henye, “Ï'bë zi gbugbuṛu nani, alima kara rɔ mo.” ");
INSERT INTO mgc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipo aho kara ehe owo kora ne ëdï kö'du ko'jo tëmï wayöruwë 'ba nëbï Yisaya. Pilipo ako'jo hɔ mo iya henye, “Ayɔlɔ mï kö'du mati ëdï ako'jo ne ku?” ");
INSERT INTO mgc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mo aya'ba dɔ mo iya henye, “Hala ma tɔ'bɔ yɔlɔ, nje ëzë vïdï maako ra akɔnyi ma?” Mo ako'jo Pilipo zi tayi rïyë ehe lima dakapa nï. ");
INSERT INTO mgc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kora ne ëdï wayöru ko'jo iya henye, “Akɔkɔ mo kaa tïmëlë mati da gërï ënï zi kofo. Mo udu dë, kaa tïmëlë ma yëvu rɔ mo umu le du udu dë. ");
INSERT INTO mgc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","O'dɔnnï mo na komokaya, mo ïrï vurë ma tïnyö dë. Hala mo atɔ'bɔ tëdï gisisi aba, ëzë dïdï mo oba ku 'de?” ");
INSERT INTO mgc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Vo lïmu ne iya zi Pilipo henye, “Ayada zi ma, nëbï ne ëdï ame'do kö'du nï, mandere kö'du vïdï maako?” ");
INSERT INTO mgc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Here Pilipo ta bi nenye ayeto tëmï kö'du wayöru nenye ehe ayada zi mo kö'du yöyö laka ga kö'du 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mati zë ëdï tï'bënnï ta da gërï, zë ayinnï bi ma wini aba. Kora lïmu ne iya henye, “Ongɔ te, kinye wini ëdï. Kö'du a'di ɔ'bɔ dë bapatisi ma?” ");
INSERT INTO mgc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","Mo ï'dï kö'du zi karo ne tɔrɔ. Zë 'dö rïyö ï'bënnï akaŋo mï wini, Pilipo abapatisi mo. ");
INSERT INTO mgc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tapëtï tasi 'bëzë yaga tëmï wini, Lawo 'ba Yere oba Pilipo 'de. Vo lïmu ne ongɔ mo dekpe löhu, mora mo ëdï tï'bë da gërï ënï rakyenyi aba. ");
INSERT INTO mgc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipo yaa alaya mï Azotusu. Mo ï'bë tëmï gawo zi gawo, biya ta da gërï zi Kasariya, yëtï kö'du laka zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mï kadra nani Sawolo nduwë yaza, kofo vo lö'böwë ga Yere. Mo ï'bë zi kyedre 'ba vo karase, ");
INSERT INTO mgc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ako'jo hɔ mo kö'du waraga zi vo dagba bi 'ba mötuwë mati ëdïnnï mï Damasika. Mo o'dɔ nenye ga kö'du mo omba zi kïrï ehe koba mï Yerusalema vïdï kora mandere mbara ma omannï mï gërï 'ba Yere. ");
INSERT INTO mgc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Mati Sawolo ëdï ku kara zi tɔkɔ Damasika, bikanyi laka ta komorïyë truku'du ayanyi bi toko ta rɔ mo. ");
INSERT INTO mgc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mo alëpï dakaŋo, owo gu iya zi mo henye, “Sawolo, Sawolo, kö'du a'di ëdï ma yaza?” ");
INSERT INTO mgc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawolo ako'jo kö'du iya henye, “Yere yï 'bëyï ëyï?” Yere aya'ba dɔ mo iya henye, “Ma Yësu ra. Ma ra vïdï ma ëdï ayaza. ");
INSERT INTO mgc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yaanya aba ënyï rïyë ehe ï'bë mï gawo kyedre ne, ani akayada zi yï a'di zi ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Vïdï kora mati ëdïnnï Sawolo aba, ɔrɔnnï ani kazi me'do. Zë owonnï gu, mora ongɔnnï vïdï maako dë. ");
INSERT INTO mgc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawolo ënyï rïyë ta akaŋo, ehe mati ayëhu komo nï, mo ɔ'bɔ dë zi wa maako kongɔ. Vïdï maako ra ïrï mo kala aba kɔkɔ mï Damasika, ");
INSERT INTO mgc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ehe ko'do wota aba mo ɔ'bɔ dë zi bi kongɔ ehe onyo wa kpa dë, mandere wa kuwë. ");
INSERT INTO mgc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Vo lö'bö maako ru mo Ananiya alima mï Damasika. Yere ame'do zi mo tëmï rayada. Ananiya aya'ba dɔ mo iya nenye, “Yere, kinye mëdï.” ");
INSERT INTO mgc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yere iya zi mo henye, “Ënyï rïyë ehe ï'bë liŋɔ 'ba Yudasi da gërï mbïyï ne. Ëzë ɔkɔ ku ani, aki'ja kora maako ru Sawolo tëmï gawo 'ba Tasisi. Sawolo ëdï amötu, ");
INSERT INTO mgc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ehe mo ongɔ rayada kora maako ru mo Ananiya ëdï atayi zi mo ehe ï'dï kala nï dɔ mo, here zi mo bi kongɔ löhu.” ");
INSERT INTO mgc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya aya'ba dɔ mo iya henye, “Yere, vïdï kayo ayadannï zi ma, kö'du kyënyë mati kora nenye o'dɔ zi vïdï laka 'bëyï mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kinye mo ayi kalakonda aba kazi kyedree 'ba vo karase zi kïrï vïdï biya mati ëdïnnï ru yï ko'jo.” ");
INSERT INTO mgc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yere iya zi Ananiya henye, “Ï'bë, minzi mo ku zi ko'dɔ mo zi yada ru ma zi tu'dëë, yeree, ehe vïdï 'ba Yiserele. ");
INSERT INTO mgc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma na bi da ma ma kayada zi mo hala mo aki'ja riti ga kö'du ru ma.” ");
INSERT INTO mgc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya ï'bë ehe ödu mï loko mati Sawolo ëdï lima 'dɔmo. Ananiya ï'dï kala nï dɔ mo ehe iya henye, “Öndu Sawolo, Yere Yësu ra utu ma. Mo ra kpa alaya zi yï da gërï tayi 'bëyï kinye ne. Mo omba yï zi bi kongɔ löhu, ehe zi koso ndɔ Lawo Laka aba.” ");
INSERT INTO mgc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Truku'du wa maako kaa ɔkɔ kyenze alëpï ta komo Sawolo, ehe mo ɔ'bɔ bi kongɔ löhu. Mo ënyï rïyë abapatisi mo. ");
INSERT INTO mgc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Here mo onyo wa, rɔ mo akyigɔ. Sawolo alima ko'do maakowe aba vo lö'böwë 'ba Yere ëtï mï Damasika. ");
INSERT INTO mgc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kandi mo ï'bë mï bi 'ba mötuwë ayeto yëtï zi vïdï henye, Yësu ra Wisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vïdï biya ma owonnï Sawolo, na rakaga ehe iyannï henye, “Anza dë kora nenye ra ëdï riti kï'dï zi vïdï ma alimannï mï Yerusalema, mati ëdïnnï amötu mï ru 'ba Yësu? Mo ayi dë kinye zi kïrï zë ehe koba zë zi kyedree 'ba vo karase?” ");
INSERT INTO mgc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawolo ayëtï kö'du kyigɔ aba. Yude ma alimannï mï Damasika, mo o'dɔ zë na rakaga mati mo ayɔnzɔ zi yada zi zë Yësu ra Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Yaa kya zë maakowe o'dɔnnï mala zi Sawolo kofo, ");
INSERT INTO mgc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mora mo i'ja. Mo ayɔlɔ zë ëdïnnï ga ha resi 'ba gawo ne kongɔ kadra ehe yɔndɔ aba zi mo kofo. ");
INSERT INTO mgc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yɔndɔ maako aba, vo lö'böwë Sawolo izannï mo akaŋo mï baga kyedre ta da tëṛï. ");
INSERT INTO mgc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mati Sawolo ɔkɔ mï Yerusalema, ayɔnzɔ zi rë nï drɔko vo lö'böwë ëtï. Mora zë biya na tere, ga kö'du zë omannï dë mo vo lö'bö ma tïnyö ra. ");
INSERT INTO mgc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Here Baranaba akɔnyi mo, oba mo zi vo lïtuwë. Mo ayada hala Sawolo ongɔ Yere, ehe hala Yere ame'do zi mo. Baranaba iya kpa henye, mati Sawolo ëdï mï Damasika, mo ame'do kazi tere mï ru 'ba Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sawolo alasi na dangölö vo lö'böwë ëtï mï Yerusalema, ehe ayada kö'du 'ba Yere zi vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mo 'duwï hë nnï wasa Yude ma ëdïnnï me'do mï ha 'ba Gïrïgï, ehe zë ombannï zi mo kofo. ");
INSERT INTO mgc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mora vo lö'böwë i'jannï kö'du nenye, ehe obannï Sawolo zi Kasariya. Ani zë utunnï mo zi Tasisi. ");
INSERT INTO mgc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Here kanisa mï Yudiya, Galilaya, ehe Samariya yaanya aba ku mï kadra 'ba rakyëyï, ehe ayinnï na kyigɔ, ehe Lawo Laka akɔnyi zë zi tövu ehe zi tere Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mati Petero ëdï alasi ta ga bi ne biya, mo ï'bë zi vo lö'bö lake ma alimannï mï gawo 'ba Liyida. ");
INSERT INTO mgc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ani mo i'ja kora maako ru mo Anisi, mo na rakɔɔ, kɔɔ madɔmowota mï sora ɔ'bɔ dë zi lasi. ");
INSERT INTO mgc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petero iya zi Anisi henye, “Yësu Korisitɔ akɔ'jɔ yï ku! Ënyï rïyë, ehe aköku agburuku 'bëyï ne.” Kandi mo ɔrɔ rïyë. ");
INSERT INTO mgc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vïdï biya mï Liyida ehe Sarɔnɔ ongɔnnï Anisi, ayinnï na vo lö'böwë ga Yere. ");
INSERT INTO mgc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mï Jɔpa mbara vo lö'bö maako, ëdï ru mo Tabita. Ru mo ha Gïrïgï aba Doroka. Mo ëdï 'duwï kö'du laka ko'dɔ zi vïdï ehe zi vo leriye. ");
INSERT INTO mgc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mora mo alëpï na kɔɔ ehe oli. Zë akakannï rɔ mo, ï'dïnnï mo mï lokotɔrɔ. ");
INSERT INTO mgc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jɔpa anza dë na kɔwɔ ta ra Liyida, ehe vo lö'böwë owonnï Petero ëdï ani. Zë utunnï vïdï kora rïyö zi kiya zi mo, “Akɔ, ayi ze aba kandi ëzë atɔ'bɔ!” ");
INSERT INTO mgc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kandi Petero ï'bënnï zë ëtï. Vïdï kora nee obannï Petero rïyë mï lokotɔrɔ. Mbara lu'bë kayo ëdïnnï ani akudu. Zë ayadannï zi mo bɔnge mati Doroka ëdï ako'dɔ mo gba na dïdï. ");
INSERT INTO mgc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tapëtï Petero utu vïdï ku biya yaga ta loko, odrɔ da omo nï akaŋo, amötu. Here ofɔ rë nï zi yöku 'ba Doroka ehe iya henye, “Tabita, ënyï rïyë!” Mbara ne ayëhu komo nï. Mati ongɔ Petero, mo alima rïyë. ");
INSERT INTO mgc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero ïrï mo kala nï aba akɔnyi mo da ndï mo. Petero ako'jo mbara lu'bë nee ehe kya 'ba vo lö'bö laka maakowe, ayada zi zë Doroka ënyï ku na dïdï tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Vïdï biya mï Jɔpa mati owonnï kö'du ma o'dɔ rë nï ne, ma kayo tëmï zë omannï mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero alima mï Jɔpa ko'do kayo aba mï liŋɔ 'ba kora maako ru mo Simona, vo wana kɔ'jɔ ra. ");
INSERT INTO mgc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mï Kasariya kora maako ëdï ani ru mo Koronɔlïyö, mo vo da kanya lamikölö 'ba Roma ako'jo “Gboko tëmï Italiya.” ");
INSERT INTO mgc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Koronɔlïyö kora 'ba yënï ra, mati ere Wïrï ehe vïdï biya 'bënï ëtï. Mo ï'dï kɔhi kyɔ zi vo leriye, ehe 'duwï amötu zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kadra wota tapëtï kadra kutë, Koronɔlïyö ongɔ rayada kazi Wïrï. Mo ongɔ malayika kazi Wïrï ëdï tayi zi mo, ehe ko'jo mo ru aba, “Koronɔlïyö.” ");
INSERT INTO mgc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koronɔlïyö na rakaga, mati mo ongɔ bi da malayika. Here, mo ako'jo kö'du iya henye, “Yere, a'di ra kö'du nenye biya gɔ mo?” Malayika aya'ba dɔ mo iya henye, “Wïrï owo mötu 'bëyï ku, ehe ayɔlɔ wakï'dï 'bëyï zi vo leriye ne ku. ");
INSERT INTO mgc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yaanya aba utu vïdï kora maakowe Jɔpa, zi kora maako ru mo Simona Petero. ");
INSERT INTO mgc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mo ëdï alima kora maako aba vo likɔ ko'dɔ ru mo Simona, mo alima mï liŋɔ ma kara ha ranga.” ");
INSERT INTO mgc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tapëtï kö'du nenye kiya, malayika ï'bë wënï. Koronɔlïyö ako'jo rïyö vo kalima 'bënïyë ehe vo kanya kölö 'bënï ma ëdï Wïrï mötu. ");
INSERT INTO mgc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Mo iya ga kö'du ne biya zi zë, ehe utu zë Jɔpa. ");
INSERT INTO mgc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kadra kutë mï ko'do ma ta gɔ mo, mati kora nenyee ëdïnnï ku tayi kara Jɔpa, Petero ï'bë ku rïyë komo lembe amötu. ");
INSERT INTO mgc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mati zë ëdïnnï wakonyo kɔ'jɔ, mo na o'bo, omba zi wakonyo, mora mo ongɔ rayada kazi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mo ongɔ komorïyë ayëhu rë nï, ehe wa maako ayi akaŋo kaa mbili bɔngɔ kyedre bi golo'bɔ sowɔ ënï aba. ");
INSERT INTO mgc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mï mo dakyïnë ngötu biya, ngötuwë 'ba liŋɔ, watelee, ehe aliye. ");
INSERT INTO mgc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Gu iya zi mo henye, “Petero, ënyï rïyë! Ofo nenyee, ehe onyo zë.” ");
INSERT INTO mgc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mora Petero iya henye, “Yere, mɔ'bɔ dë ko'dɔ mo, gba monyo wa maako na ti'da, ehe anza dë na laka zi konyo.” ");
INSERT INTO mgc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gu ame'do zi mo löhu, “Ëzë Wïrï o'dɔ wa maako ku ŋbala, iya dë henye, anza dë na laka zi konyo.” ");
INSERT INTO mgc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nenye o'dɔ rë nï da wota, gba kazi mbili bɔngɔ ne truku'du koba hulëhu komorïyë. ");
INSERT INTO mgc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mati Petero gba sösu mï me'do nenye a'di, kora ma Koronɔlïyö utu zë ne, ayi ɔrɔnnï ha loko 'ba resi. I'jannï gërï liŋɔ 'ba Simona ku, ");
INSERT INTO mgc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ehe ako'jonnï kɔdɔ here ne Simona Petero ëdï alima ani. ");
INSERT INTO mgc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mati Petero ëdï gba kö'du ma o'dɔ rë nï ne sösu, Lawo iya zi mo henye, “Kora wota ëdïnnï kinye bi koma kö'du yï. ");
INSERT INTO mgc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kandi ï'bë akaŋo, ehe ï'bë zë ëtï. Asösu dë, ma ra mutu zë.” ");
INSERT INTO mgc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero ï'bë akaŋo iya zi kora nee henye, “Ma ra ëdïyë akoma. Ayiye ga a'di?” ");
INSERT INTO mgc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Zë aya'bannï da me'do iyannï henye, “Vo da kanye Koronɔlïyö ra utu ze. Mo kora laka ra, mo amötu Wïrï, ehe vïdï biya 'ba Yuda ombannï mo. Malayika laka 'ba Wïrï ra ayada zi Koronɔlïyö zi kutu lïtu zi yï, here mo atɔ'bɔ kowo a'di ra zi yï kiya.” ");
INSERT INTO mgc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petero ako'jo zë zi ko'do ani. Mï ko'do vere, Petero ehe kya 'ba vo lö'böwë mï Jɔpa ï'bënnï kora mati ayinnï kazi Koronɔlïyö ne ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mï ko'do vere aba zë ɔkɔnnï mï Kasariya bi ma Koronɔlïyö ëdï bi zë kisi. Mo ako'jo karo 'bënïyë ehe aboka ma kare. ");
INSERT INTO mgc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mati Petero ɔkɔ, Koronɔlïyö amëtë mo, here mo alɔdrɔ burutu Petero, ehe ayeto mo yeto. ");
INSERT INTO mgc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mora Petero ïnjë mo, ehe iya henye, “Ɔrɔ rïyë! Ma anza dë ndra ta da vïdï köndu.” ");
INSERT INTO mgc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mati Petero ödu loko, mo ëdï gba me'do Koronɔlïyö aba, vïdï kayo ëdïnnï ani. ");
INSERT INTO mgc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petero iya zi zë henye, “Ayɔle ku laka, ze Yude kö'du kï'dï 'beze ila ze dë zi wa maako ko'dɔ vïdï maako ëtï, mora Wïrï ayada zi ma, mo asösu dë vïdï maako ëdï na ti'da mandere anza na laka. ");
INSERT INTO mgc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mati utuwë zi ma zi tayi kinye, mayi ku. Yaanya aba momba zi yɔlɔ kö'du a'di utu lïtu ga ma?” ");
INSERT INTO mgc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koronɔlïyö aya'ba dɔ mo iya henye, “Ko'do sowɔ alaga ëdï kaa kadra wota 'ba hutaga, mëdï amötu liŋɔ. Truku'du kora maako usu bɔngɔ kanyi ɔrɔ da komo ma. ");
INSERT INTO mgc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mo iya henye, ‘Koronɔlïyö, Wïrï owo mötu 'bëyï ku ehe mo ayɔlɔ wakï'dï 'bëyï zi vo leri ku. ");
INSERT INTO mgc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yaanya aba utu lïtu mï Jɔpa zi Simona Petero. Mo ëdï na yingɔ mï liŋɔ 'ba Simona vo likɔ ko'dɔ, alima kara ha ranga.’ ");
INSERT INTO mgc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mutu lïtu kandi gë yï, ehe ëdï da kö'du komba laka aba zi yï tayi ne. Ze biya dëdï kinye da komo Wïrï zi kowo a'di akiya.” ");
INSERT INTO mgc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petero ame'do henye, “Yaanya aba ma yɔlɔ ku Wïrï o'dɔ lɔvɔ vïdï biya kölö. ");
INSERT INTO mgc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wïrï na rakyenyi vïdï ma ere nï, ehe o'dɔ wa ma lake. ");
INSERT INTO mgc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ayɔle kö'du kise mati Wïrï ï'dï zi vïdï 'ba Yiserele, mati mo utu Yësu Korisitɔ, Yere 'ba vïdï biya, zi rakyëyï kï'dï zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ayɔle ku wa mati o'dɔ rë nï, ta bi ne biya mï Yudiya. Ayeto biya mï Galilaya, tapëtï Yowani ayada biya zi vïdï bapatisi. ");
INSERT INTO mgc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wïrï ï'dï Lawo Laka ehe kyigɔ zi Yësu tëmï Nazereta. Mo ëdï Yësu aba, mati mo alasi toko kö'du laka ko'dɔ, ehe vïdï kɔ'jɔ aba, zë ma hu kyigɔ 'ba Satani. ");
INSERT INTO mgc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ze biya dongɔ wa ma o'dɔ 'dö mï Yuda ehe mï Yerusalema. Ï'dï Yësu zi koli da taka, ");
INSERT INTO mgc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","mora ko'do wota aba yaa, Wïrï ïnjë mo na dïdï, ehe o'dɔ mo zi kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Anza vïdï biya ra ongɔ mo, ze ra nje dongɔ mo, wakonyo ehe wakuwë mo aba tapëtï tënyï 'bɔmo tëmï koli. Ze ra Wïrï inzi zi yada kö'du mo zi vïdï maakowe. ");
INSERT INTO mgc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wïrï ayada zi ze zi yöyö zi vïdï henye, Yësu ra inzi mo ku zi vurë 'ba dïdï yöku ëtï kiya. ");
INSERT INTO mgc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nëbï biya iyannï henye, vïdï biya ma ëdïnnï koma aba mï Yësu, akila kö'du kyënyë 'bëzë ne mï ru mo.” ");
INSERT INTO mgc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mati Petero ëdï gba ame'do, Lawo Laka ayi da vïdï ma ëdï mbili nnï koze ne. ");
INSERT INTO mgc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kya 'ba vo kome ma ŋbete, mati ayinnï Petero ëtï, zë na rakaga ga kö'du Lawo Laka ï'dï ku zi tu'dëë, ");
INSERT INTO mgc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ga kö'du zë owonnï tu'dë ëdïnnï ku me'do mï ha mënzë maakowe Wïrï yeto aba. Here Petero iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tu'dë nenyee ï'dï Lawo Laka ku zi zë, kpa kaa dëdï mo aba. Ma yɔlɔ ku vïdï maako ɔ'bɔ dë ze yata ta bi zë bapatisi.” ");
INSERT INTO mgc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Petero ï'dï kö'du zi zë bapatisi mï ru 'ba Yësu Korisitɔ. Here zë ako'jonnï hɔ mo zi lima rë nnï ko'do tisi aba. ");
INSERT INTO mgc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Vo lïtuwë ehe vo lö'böwë mï Yudiya owonnï henye tu'dëë ombannï da kö'du kise 'ba Wïrï ku. ");
INSERT INTO mgc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Here mati Petero ayi Yerusalema, kya vo kome ŋbete ayeto hë nnï wasa mo aba, ");
INSERT INTO mgc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","zë iyannï henye, “Yï alima na yingɔ mï liŋɔ 'ba tu'dëë, ehe onyo wa kpa zë ëtï!” ");
INSERT INTO mgc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Here Petero ayada kö'du ma o'dɔ rë nï, iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mëdï mï gawo 'ba Jɔpa ehe mëdï amötu, mati mongɔ rayada kazi Wïrï. Mongɔ komorïyë ayëhu rë nï, ehe wa maako kaa mbili bɔngɔ kyedre ïrï ta bi golo'bɔ 'bɔmo sowɔ tayi akaŋo zi ma. ");
INSERT INTO mgc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mati mongɔ bi mï mo, ngötuwë 'ba liŋɔ, ngötu mökuwë, watelee, ehe aliye. ");
INSERT INTO mgc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mowo gu iya zi ma henye, ‘Petero, ënyï rïyë! Ofo nenyee, ehe onyo zë.’ ");
INSERT INTO mgc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mora miya henye, ‘Yere, mɔ'bɔ dë ko'dɔ here, gba monyo wa maako mati ëdï na ti'da ehe mandere anza na laka zi konyo ne dë.’ ");
INSERT INTO mgc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Gu ta komorïyë ame'do zi ma löhu, iya henye, ‘Ëzë Wïrï o'dɔ wa maako ku ŋbala, iya dë henye, anza dë na laka zi konyo.’ ");
INSERT INTO mgc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nenye o'dɔ rë nï da wota, gba kazi koba mo biya löhu komorïyë. ");
INSERT INTO mgc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Truku'du kora wota tëmï Kasariya ɔrɔnnï komo loko mati mëdï alima 'dɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lawo Laka ayada zi ma tï'bë zë ëtï ehe kazi kö'du sösu. Here öndu mï Yësu modaka ï'bënnï ma aba, ehe dödu mï loko 'ba kora nenye. ");
INSERT INTO mgc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mo ayada zi ze malayika alaya zi nï, iya henye, ‘Utu vïdï maako Jɔpa zi kora maako ru mo Simona Petero, ");
INSERT INTO mgc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","mo akayada zi ye hala yï ehe vïdï biya mï liŋɔ 'bëyï akayɔmɔ.’” ");
INSERT INTO mgc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Tapëtï ma yeto me'do, ï'dï Lawo Laka zi zë, kaa mati Lawo Laka ï'dï zi ze biyeto aba. ");
INSERT INTO mgc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma sösu me'do 'ba Yere, iya henye, ‘Yowani abapatisi wini aba, mora akabapatisiye Lawo Laka aba.’ ");
INSERT INTO mgc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wïrï ï'dï zi tu'dë naniye kpa wakï'dï mati mo ï'dï zi ze, mati dï'dï koma 'beze mï Yere Yësu Korisitɔ. Hala ma kayata Wïrï?” ");
INSERT INTO mgc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mati zë owonnï Petero iya nenye, ɔrɔnnï ta bi hë nnï wasa, ehe ayetonnï Wïrï yeto, iyannï henye, “Wïrï yaanya aba o'dɔ tu'dëë ku dë nnï kotɔ zi nï, ehe ï'dï dïdï ku kpa zi zë.” ");
INSERT INTO mgc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kya 'ba vo lö'bö 'ba Yere maakowe apere rë nnï ga kö'du 'ba wayaza ma ayeto kofo 'ba Setifano aba. Zë ï'bënnï kɔwɔ kaa Ponisiya, Seyipurusu, ehe Atiyɔkɔ. Zë ayadannï kö'du kise ne nje zi Yude. ");
INSERT INTO mgc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kya 'ba vo lö'bö maakowe tëmï Seyipurusu ehe Sirënë ï'bënnï Atiyɔkɔ ehe ayetonnï yada zi vïdï 'ba Gïrïgï kö'du yöyö laka ne ga kö'du 'ba Yere Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kyigɔ 'ba Yere ëdï zë aba, ehe vïdï kayo otɔ dë nnï zi Yere, ehe omannï mï mo. ");
INSERT INTO mgc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kö'du yöyö ma o'dɔ rë nï ne, ɔkɔ zi kanisa mï Yerusalema, ehe zë utunnï Baranaba Atiyɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mati Baranaba ɔkɔ ani, ehe ongɔ hala Wïrï ï'dï kö'du lake ku zi zë. Mo na rakyenyi, ehe mo alenze zë zi limannï koma aba mï Yere biya di'di nnï aba. ");
INSERT INTO mgc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baranaba mo kora laka 'ba koma kyedre aba, ehe oso mo ndɔ Lawo Laka aba. Vïdï kayo otɔ dë nnï zi Yere. ");
INSERT INTO mgc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Here Baranaba ï'bë Tasisi Sawolo koma. ");
INSERT INTO mgc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Mati mo i'ja Sawolo, ika mo Atiyɔkɔ. Ani zë adrɔkonnï rë nnï kanisa ëtï kɔɔ kölö, ehe ayandi vïdï kayo. Ani mï Atiyɔkɔ vo lö'böwë 'ba Yere dagba ako'jo Korisitɔ 'ba. ");
INSERT INTO mgc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mï kadra nenye aba, kya 'ba nëbï maakowe ta Yerusalema ayinnï Atiyɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma kölö tëmï zë ru mo Agabusu. Wakɔnyi 'ba Lawo Laka aba, mo ayada kö'du iya henye, “Madöyï kyënyë atëdï tëmï damöku ne biya.” O'dɔ rë nï mï kadra ma Kulidasi ra na yere. ");
INSERT INTO mgc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Vo lö'bö ma ëdïnnï mï Atiyɔkɔ ombannï zi kutu wakɔnyi maako zë atɔ'bɔnnï zi önduwë mï Korisitɔ ma ëdïnnï mï Yudiya. ");
INSERT INTO mgc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Here zë inzinnï Baranaba ehe Sawolo zi koba wakï'dï 'bënnï zi vo dagbe 'ba vo lö'böwë mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mï kadra nani, Yere Heroda ayaza kya vïdï 'ba kanisa. ");
INSERT INTO mgc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mo ï'dï kö'du zi vo kanye zi da Yemisi öndu 'ba Yowani kikye kulu aba. ");
INSERT INTO mgc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mati Heroda ongɔ nenye o'dɔ vïdï 'ba Yude na rakyenyi, mo ïrï Petero mï kadra karama 'ba mangɔlɔ'bɔ kazi langa. ");
INSERT INTO mgc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mo ï'dï Petero mï kamba, ehe ï'dï kö'du zi vo kanya gboko sowɔ zi gɔ mo kongɔ. Heroda o'dɔ mala zi mo kï'dï bi 'ba vurë, komo vïdï kayo tapëtï karama 'ba laga 'ba koli. ");
INSERT INTO mgc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mati Petero ëdï na sesi mï kamba, vïdï 'ba kanisa ɔrɔnnï dë ta bi 'ba mötu zi Wïrï ga kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Gba ta komo yɔndɔ zi Petero kï'dï bi 'ba vurë, mo ëdï ako'do, ehe ida mo nyɔri rïyö aba mï kutë vo kanya rïyö. Vo kanya rïyö maakowe ëdïnnï ha loko ma ödu mï kamba ne kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Truku'du malayika kazi Yere alaya, ehe bikanyi ayanyi bi toko mï kamba. Malayika ne isa Petero ta dakapa mo, ehe aliro mo rïyë. Here mo iya henye, “Kandi! Ënyï rïyë!” Nyɔri alëpïnnï ta kala mo, ");
INSERT INTO mgc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ehe malayika ne iya zi mo henye, “Ënyï, usu bɔngɔ rë yï, ehe usu kamoka 'bëyï.” Petero o'dɔ kö'du ma ayada zi nï. Here malayika iya henye, “Yaanya aba usu bɔngɔ alikölu 'bëyï, ehe usu ga ma.” ");
INSERT INTO mgc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero ï'bënnï malayika aba, mora mo asösu kö'du ne wïrï ra isi nï. ");
INSERT INTO mgc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Zë ï'bë alagannï gboko rïyö 'ba vo kanye, ehe mati ayinnï ha resi 'ba kɔhi zi gawo kyedre, ayëhu rë nï na bi dë nï. Zë ï'bënnï yaga, ehe mati ëdï tï'bënnï ta da gërï, kandi malayika alaya dë. ");
INSERT INTO mgc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mati Petero ayɔlɔ kö'du ma o'dɔ rë nï ne, mo iya henye, “Yaanya aba ma yɔlɔ ku Yere ra utu malayika ënï zi yɔmɔ ma kazi Heroda, ehe kazi wa biya vo dagbe 'ba Yude asösunnï zi ko'dɔ zi ma.” ");
INSERT INTO mgc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Here Petero ï'bë zi liŋɔ 'ba Mariya, ma 'ba Yowani Marako. Vo lö'böwë 'ba Yere ayinnï ga bi kölö ani, ehe ëdïnnï amötu. ");
INSERT INTO mgc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petero akökö ha resi, ehe vo kalima mbara maako ru mo Roda, ayi ha loko zi dɔ mo ya'ba. ");
INSERT INTO mgc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mati mo owo gu Petero, mo rakyenyi aba ndra, mo ayëhu ha resi dë. Mo aho hulëhu loko, ehe iya zi vïdïyë henye Petero ëdï atɔrɔ ani. ");
INSERT INTO mgc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mora vïdï biya ayadannï zi mo, iyannï henye, “Yï vo nökyï.” Mora mo zɔ kiya henye, ne Petero ra. Here zë iyannï henye, “Ne malayika ɔmo ra.” ");
INSERT INTO mgc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petero zɔ kökö, le mï ndundu mo zë ayëhunnï ha resi. Zë ongɔnnï mo ehe zë na rakaga. ");
INSERT INTO mgc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petero ame'do kala nï aba zi zë zi tɔrɔnnï ti. Mo ayada hala Yere ika nï yaga tëmï kamba. Mo iya kpa henye, “Ayade zi Yemisi ehe zi öndu maakowe kö'du ma o'dɔ rë nï ne.” Tapëtï mo, mo ila bi nani ehe ï'bë bi maako. ");
INSERT INTO mgc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mï damïndö vere, vo kanya ma ëdïnnï bi kongɔ rasösu kyedre aba, ehe rakaga aba kö'du a'di ɔkɔ zi Petero. ");
INSERT INTO mgc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroda ï'dï kö'du zi vo kanya 'bënïyë zi mo koma, mora du i'jannï mo dë. Here mo ako'jo ha vo kanye, ehe ï'dï zë zi kofo. Tapëtï nenye, Heroda ila Yudiya ï'bë zi lima mï Kasariya yaa. ");
INSERT INTO mgc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroda ehe vïdï 'ba Tiyere ehe Sidoni na kamo oka ma kölö maako aba. Here gboko tëmï zë ï'bënnï Balatusu kongɔ, ma kölö tëmï vïdï kyedre mï turu 'ba Heroda. Zë alëlunnï da Balatusu henye nombannï zi rakyëyï ko'dɔ mï kutë gawo 'bëzë ehe Heroda, ga kö'du dakaŋo 'bëzë i'ja wakonyo 'bënï ta bi ma Heroda na vo dɔ mo. ");
INSERT INTO mgc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mï kadra ma zë ombannï dɔ mo, Heroda ayi usu rë nï mï bɔngɔ 'ba yere. Mo alima da kyïtï 'ba vurë ënï. ");
INSERT INTO mgc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Vïdï agbögbö hë nnï iyannï henye, “Ame'do ndra kaa Wïrï ta da vïdï kora!” ");
INSERT INTO mgc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kandi malayika kazi Yere otra mo akaŋo, ga kö'du mo oba wakoro 'ba Wïrï. Kuruwë onyonnï Heroda ehe oli. ");
INSERT INTO mgc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kö'du kise 'ba Wïrï zɔ rë nï pere. ");
INSERT INTO mgc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tapëtï Baranaba ehe Sawolo o'dɔnnï lɔɔ ma utu zë zi ko'dɔ mo ne ku, a'bannï Yerusalema, ehe obannï Yowani Marako kpa nnï aba. ");
INSERT INTO mgc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mï kutë vïdï 'ba kanisa 'ba Atiyɔkɔ nëbï maakowe ehe vo komoyandiye ëdïnnï. Zë ra Baranaba, Simiyɔno ako'jo kpa Nigara, Lusiyɔsi tëmï Sirënë, Manani mo aboka 'ba yere Heroda ma kara, ehe Sawolo. ");
INSERT INTO mgc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mati zë ëdïnnï Yere yeto ehe ha koro, Lawo Laka iya henye, “Inziye Baranaba ehe Sawolo zi lɔɔ mati minzi zë zi ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Here tapëtï ha koro ehe mötu, zë ï'dïnnï kala nnï dë zë, ehe utunnï zë da gërï 'bënnï. ");
INSERT INTO mgc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Lawo Laka utu Baranaba ehe Sawolo zi Selesiya, ehe ta ani zë ï'bënnï da rutu 'ba Seyipurusu. ");
INSERT INTO mgc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Zë ɔkɔnnï Salamisi, ayetonnï kö'du kise 'ba Wïrï yëtï mï bi 'ba mötuwë 'ba Yude. Yowani Marako ëdï zë aba kaa vo wakɔnyi. ");
INSERT INTO mgc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Baranaba ehe Sawolo umunnï da rutu zi Papahɔsi. Ani zë i'jannï kora maako tëmï Yude, ru mo wisi 'ba Yësu. Mo vo mörï ehe nëbï vo ndɔndɔ. ");
INSERT INTO mgc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mo o'dɔ lɔɔ kpa zi Serigisu Pawolosi, yere 'ba rutu ne. Serigisu Pawolosi, vo kö'du yɔlɔ, omba zi kowo kö'du kise 'ba Wïrï, ehe mo utu lïtu kö'du Baranaba ehe Sawolo. ");
INSERT INTO mgc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mora Barayësu vo mörï, ru mo maako Elimasi, awasa kö'du 'bëzë ne. Mo ayɔnzɔ zi yere sesi kazi koma mï Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Here Sawolo, ru mo maako kpa Pawolo, oso ndɔ Lawo Laka aba, mo ongɔ bi mbïyï da Elimasi ");
INSERT INTO mgc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ehe iya henye, “Yï wisi 'ba Satani! Yï vo ndɔndɔ ehe vo wehe 'ba kö'du laka. Ndala aba, atɔrɔ ta bi me'do kyënyë kiya ra gërï tïnyö 'ba Yere? ");
INSERT INTO mgc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yere omba tï'bë riti kï'dï zi yï, yï ko'dɔ yaa na vo komoköndu. Ɔ'bɔ dekpe zi bikanyi 'ba kadra kongɔ.” Kandi komo kora ne ayöfu matutu köndu aba, ehe mo ï'bë toko vïdï maako koma zi nï gaga kala aba. ");
INSERT INTO mgc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mati yere ongɔ kö'du mati o'dɔ rë nï ne, mo rakaga aba mï kö'du yandi ga kö'du 'ba Yere ne. Here mo oma mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pawolo ehe oka maakowe ëtï ilannï Papahɔsi ehe ï'bënnï zi Paga mï Pambaliya, mora Yowani Marako ila zë ï'bë hulëhu mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kɔsɔ zë ne ï'bënnï dagba kazi Paga zi Atiyɔkɔ mï Pisidiya. Here mï ko'do 'ba ralawo aba zë ï'bënnï mï bi 'ba mötu ehe alimannï akaŋo. ");
INSERT INTO mgc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tapëtï kö'du ko'jo tëmï kö'du kï'dï ehe wayöruwë 'ba nëbïyë, vo dagbe utunnï vïdï maako zi yada zi Pawolo ehe Baranaba henye, “Aboka me, ëzë ëdïyë kö'du maako aba zi kiya mati akakɔnyi vïdï, iye.” ");
INSERT INTO mgc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pawolo ënyï rïyë. Mo o'dɔ kala nï, ehe ame'do, iya henye, “Vïdï 'ba Yiserele, ehe vïdï maako 'ba tu'dëë kpa mati ëdïnnï mötu Wïrï, oze mbili ye. ");
INSERT INTO mgc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wïrï 'ba Yiserele inzi zutu 'bezee, ehe mo ila vïdï 'beze kaa vo leze mati ëdï alimannï Ezipeto. Ani mo o'dɔ zë na kyigɔ. Here kyigɔ gärä 'bënï aba, mo ayasi zë yaga. ");
INSERT INTO mgc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kɔɔ 'butësowɔ mo ongɔ gë zë mï da lïpï. ");
INSERT INTO mgc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tapëtï mo ayaŋa tu'dë madɔmorïyö mï Kanana, mo ï'dï dakaŋo 'bëzë zi vïdï 'bënïyë kaa drïvu. ");
INSERT INTO mgc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nenye o'dɔ rë nï ïrï kɔɔ lamisowɔ 'butëmuyï.” “Tapëtï kadra nani, Wïrï ï'dï vïdï 'bezee na vo vurëë le mï kadra 'ba nëbï Samowele. ");
INSERT INTO mgc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Here vïdï ombannï yere. Wïrï ï'dï zi zë Yere Sawolo, wisi 'ba Kisi ta daliŋɔ 'ba Benyïmona. Mo ïrï kɔɔ 'butësowɔ. ");
INSERT INTO mgc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tapëtï Wïrï ïrï Sawolo, ï'dï Dawidi na yere pëtï mo. Wïrï iya ga kö'du mo henye, ‘Dawidi wisi 'ba Jese ëdï kyïnë 'ba vïdï ma o'dɔ ma ndra na rakyenyi. Mo o'dɔ wa biya, mati momba mo zi ko'dɔ.’ ");
INSERT INTO mgc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tëmï kozo 'ba kora nenye, Wïrï ika vo wayɔmɔ Yësu zi Yiserele, kaa alömu.” ");
INSERT INTO mgc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Mora gba kazi Yësu ayi dë, Yowani ëdï ayada zi vïdï biya mï Yiserele zi dë nnï kotɔ hulëhu zi Wïrï ehe bapatisi kïrï. ");
INSERT INTO mgc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mati lɔɔ 'ba Yowani ëdï ku kara zi rë nï kinde, mo iya henye, ‘Asösu 'be ma ëyï ra? Manza dë vïdï mati ëdïyë bi mo kisi. Owowe mo ëdï tayi. Mo atayi 'da, ehe manza dë laka zi kamoka ɔmo kinga.’” ");
INSERT INTO mgc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Öndu me, kozowe 'ba Abarayama, tu'dëë biya mati ëdïnnï kinye Wïrï mötu, kö'du kise 'ba wayɔmɔ nenye utu zi ze. ");
INSERT INTO mgc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Vïdï 'ba Yerusalema ehe vo dagba 'bëzëë ayɔlɔnnï dë ëyï ra Yësu. Mandere zë ayɔlɔnnï kpa dë mï me'do 'ba nëbïyë mati ëdï ako'jonnï mï ko'do 'ba ralawo biya. Zë o'dɔnnï me'do 'ba nëbïyë ayi ku tïnyö vurë kikye aba ra Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Gbï le ëzë i'ja kö'du maako dë le zi Yësu kï'dï zi kofo, zë nduwë ha Pilato ko'jo zi mo kofo. ");
INSERT INTO mgc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tapëtï o'dɔnnï wa mati nëbïyë ayörunnï kö'du Yësu, oba mo akaŋo ta da taka ehe ï'dï mï ogo.” ");
INSERT INTO mgc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Mora Wïrï ïnjë mo tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ko'do lakyi aba Yësu alaya zi vïdï mati ï'bënnï mo aba tëmï Galilaya zi Yerusalema. Yaanya aba ëdïnnï kö'du mo yada zi vïdï 'bezee. ");
INSERT INTO mgc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ze kinye zi yada zi ye kö'du yöyö. Wa mati Wïrï alömu zi zutu 'bezee, ");
INSERT INTO mgc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","na ko'dɔ, yaanya aba mo o'dɔ ku zi ze Yësu kïnjë aba zi dïdï. Ëdï kaa Wayeto 'ba Dawidi ma rïyö iya henye, ‘Yï wisi ama ra, ndenye mayi ku na 'Bu yï.’” ");
INSERT INTO mgc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Wïrï ïnjë Yësu tëmï koli ehe ila ida rɔ mo dë zi teŋe. Ëdï kaa Wïrï iya, ‘Ma kï'dï zi yï wa laka mati ma lömu zi Dawidi.’ ");
INSERT INTO mgc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ehe mï Wayeto 'ba Dawidi maako iya henye, ‘Ila vïdï laka 'bëyï ne dë zi teŋe mï ogo.’ ");
INSERT INTO mgc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mati Dawidi ëdï gba na dïdï, mo oro Wïrï. Here tapëtï mo oli, usu mo mï ogo 'ba zutu 'bɔmowe, ehe ida rɔ mo eŋe. ");
INSERT INTO mgc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mora vïdï mati Wïrï ïnjë tëmï koli, ida rɔ mo eŋe dë.” ");
INSERT INTO mgc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Aboka me, kö'du kise ne ëdï henye, Yësu akila kö'du kyënyë 'be! ");
INSERT INTO mgc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kö'du kï'dï 'ba Mosa ɔ'bɔ dë e ko'dɔ tïnyö tëmï kö'du kyënyë 'be biya. Mora vïdï ma ëdï koma aba mï Yësu, Wïrï ako'dɔ mo tïnyö. ");
INSERT INTO mgc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ëdïyë komokandi aba kazi, kö'du ma nëbï iyannï ne mo'dɔ rë nï dë zi ye. Zë iyannï henye, ");
INSERT INTO mgc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘E vïdï ma o'de lasa ra Wïrï, ëdï rakaga aba ehe akoli. Ma ko'dɔ wa maako mï kadra 'be, ɔ'be dë zi koma, ëzë vïdï maako ayada le zi ye.’” ");
INSERT INTO mgc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mati Pawolo ehe Baranaba ëdïnnï ku bi 'ba mötu 'ba Yude kila, vïdï alenzennï zë zi kiya kyɔ kö'du kölö nenyee ko'do 'ba ralawo vere aba. ");
INSERT INTO mgc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tapëtï mötu, Yuda kayo ehe tu'dë kayo ma ëdïnnï Wïrï mötu ne, ï'bënnï zë ëtï. Pawolo ehe Baranaba alenze zë biya zi lima mï rakyëyï 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mï ko'do 'ba ralawo vere, vïdï biya 'ba mï gawo ayinnï zi kö'du kise 'ba Yere kowo. ");
INSERT INTO mgc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mati Yude ongɔnnï vïdï kayo nee, zë na mïkumbë. Zë alidinnï Pawolo ehe ame'donnï na kyënyë ra kö'du biya mati mo iya ne. ");
INSERT INTO mgc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mora Pawolo ehe Baranaba kazi tere iyannï henye, “Domba zi yada kö'du kise 'ba Wïrï zi ye, gba kazi yada zi vïdï maakowe. Mora ombe kö'du kise ne dë! Nenye ayada henye, ombe dïdï ma ŋburu ŋburu ne dë. Yaanya aba dëdï tï'bë zi tu'dëë. ");
INSERT INTO mgc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yere ï'dï kö'du zi ze henye, ‘Mï'dï yï kinye kaa bikanyi zi tu'dëë, zi koba wayɔmɔ 'ba Wïrï zi vïdï mï dakaŋo biya.’” ");
INSERT INTO mgc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kö'du kise nenye o'dɔ tu'dëë na rakyenyi, ehe zë ayetonnï me'do 'ba Yere. Vïdï biya ma inzi ku kö'du dïdï ma ŋburu ŋburu, here omannï mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kö'du kise ga kö'du 'ba Yere apere rë nï biya mï dakaŋo nenye. ");
INSERT INTO mgc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mora Yude ï'bënnï zi mbara kyigɔ ma erennï Wïrï, ehe kora vo dagbe 'ba gawo. Zë ofɔnnï zë na kyënyë ra Pawolo ehe Baranaba, ehe ayetonnï zë yaza. Zë orennï zë yaga tëmï kapa 'ba dakaŋo nenye. ");
INSERT INTO mgc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pawolo ehe Baranaba akyitɔ durufu 'ba ga bi nani ta ndï nnï, ehe ï'bënnï dagba zi Yikɔnïyömu. ");
INSERT INTO mgc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mora vo lö'böwë 'ba ga ndï Yësu biya na rakyenyi, ehe osonnï ndɔ Lawo Laka aba. ");
INSERT INTO mgc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pawolo ehe Baranaba ame'donnï mï bi 'ba mötu mï Yikɔnïyömu, ehe Yuda kayo ehe tu'dë kayo omannï mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mora Yuda ma ombannï dë koma mï mo, o'dɔnnï tu'dë maakowe na kamo ehe ofɔ rë nnï na vo wehe ra önduwë mï Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pawolo ehe Baranaba alimannï ani kadra konda aba, me'do kö'du 'ba Yere kazi tere, ehe Yere ï'dï kyigɔ zi zë, zi kö'du koro ko'dɔ ehe rakaga, mati akayada kö'du kise 'ba rakyëyï ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vïdï mï gawo 'ba Yikɔnïyömu ayɔlɔnnï dë a'di zi sösu. Kya maakowe omannï mï gboko 'ba Yude ehe maakowe omannï mï vo lïtuwë. ");
INSERT INTO mgc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ndundu mo aba, tu'dë maakowe ehe Yude, bi kölö vo dagba 'bënnï ëtï, ombannï mala ko'dɔ zi ko'dɔ zë na kyënyë ehe zë ku'du yïtö aba brua. ");
INSERT INTO mgc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mati Pawolo ehe Baranaba ayɔlɔnnï wa ma ëdï rë nï ko'dɔ, zë ahonnï mï dakaŋo 'ba Lëyïkɔniya, ani mï gawo 'ba Liyisitra ehe Dëbë ehe bi ma kara dakapa dakaŋo ne. ");
INSERT INTO mgc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ani zë nduwë kö'du yöyö laka ne yëtï. ");
INSERT INTO mgc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mï Liyisitra, kora maako ëdï ani o'jo mo na ndï keŋe ehe ɔ'bɔ dë zi lasi. ");
INSERT INTO mgc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kora ne ëdï mbili nï koze da me'do 'ba Pawolo. Mati Pawolo ongɔ mo ëdï koma aba mï Yësu zi kɔ'jɔ, ");
INSERT INTO mgc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","mo agbögbö hë nï iya henye, “Ënyï rïyë!” Kora ne öfu rïyë ehe ayeto lasi toko. ");
INSERT INTO mgc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mati vïdï kayo ne ongɔnnï wa ma Pawolo o'dɔ ne, agbögbö hë nnï yaga mï ha 'ba Lëyïkɔniya, iyannï henye, “Wïrïyë ofɔnnï rë nnï ku na vïdï köndu ehe ayinnï ku akaŋo zi ze!” ");
INSERT INTO mgc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Vïdï ï'dïnnï ru da Baranaba, Zeyusi, ehe ï'dïnnï ru da Pawolo Hemoso, ga kö'du mo ra ame'do. ");
INSERT INTO mgc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yëkëlu 'ba Zeyusi ëdï kara ha bi tödu zi gawo kyedre. Vo karasa 'ba Zeyusi ika ise ehe döruwë ha resi 'ba gawo kyedre, ga kö'du mo ehe vïdïyë ombannï zi kï'dï wakumu zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mati Pawolo ehe Baranaba ayɔlɔnnï kö'du nenye, zë izannï bɔngɔ 'bënnï ahonnï mï kutë vïdï kayo ne hë nnï gbögbö aba henye, ");
INSERT INTO mgc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ëdïyë kö'du nenye ko'dɔ ga a'di? Ze vïdï könduwë ra kaa e. Dika ze kö'du yöyö laka ra zi ye here zi ye kila wïrï mbiya ma kazi kö'du, ehe otɔ de zi Wïrï ma dïdï, ma o'dɔ komorïyë, dakaŋo, wini kyedre, ehe wa biya mï zë. ");
INSERT INTO mgc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mï kadra ma alaga, Wïrï ila vïdï tï'bënnï mï gërï 'bënnï, ");
INSERT INTO mgc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","mora mo ayada mo ëdï ani tëmï wa laka mati mo o'dɔ. Wïrï utu mïrë ta komorïyë ehe o'dɔ wa 'be mï yaka övu. Mo ï'dï wakonyo zi ye ehe o'dɔ di'di ye na rakyenyi.” ");
INSERT INTO mgc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Gbï le tapëtï Pawolo ehe Baranaba iyannï nenye biya, na kyigɔ zi zë yata vïdï ta bi wakumu kï'dï mo zi nnï. ");
INSERT INTO mgc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kya 'ba Yude tëmï Atiyɔkɔ ehe Yikɔnïyömu ayinnï, ofɔnnï vïdï kayo ne na wehe ra Pawolo. Zë otrannï mo yïtö aba ehe otɔnnï mo yaga tëmï gawo kyedre. Asösunnï mo oli ku, ");
INSERT INTO mgc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","mora mati vo lö'böwë atɔtɔ rë nnï toko ra Pawolo, mo ɔrɔ rïyë ehe ï'bë hulëhu mï gawo kyedre ne. Mï ko'do vere aba, mo ehe Baranaba ï'bënnï zi Dëbë. ");
INSERT INTO mgc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pawolo ehe Baranaba ayëtïnnï kö'du yöyö laka ne mï Dëbë ehe vïdï kayo ayinnï na vo lö'böwë. Here zë ï'bënnï hulëhu Liyisitra, Yikɔnïyömu, ehe Atiyɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Zë akyigɔnnï vo lö'böwë ehe alenzennï zë zi limannï mï koma. Zë ayadannï zi zë henye, “Da tödu ze Damöku 'ba Wïrï tëmï rayaza kyedre.” ");
INSERT INTO mgc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pawolo ehe Baranaba inzinnï kyedree zi nnï mï kanisa biya na kölö kölö. Here zë oro hë nnï, amötunnï, ehe ï'dïnnï rënnï zi Yere zi gë zë gaga, ma ëdïnnï koma aba mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tapëtï tï'bë kpuru Pisidiya, ze ayinnï Pambaliya, ");
INSERT INTO mgc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ehe tapëtï zë ayëtïnnï kö'du mï Paga, here zë ï'bënnï akaŋo zi Italiya. ");
INSERT INTO mgc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta Italiya ï'bënnï zi Atiyɔkɔ mï Siriya. Ani vo lö'böwë kyere dagba ï'dïnnï zë zi Wïrï gë zë kongɔ, mati ëdïnnï lɔɔ ko'dɔ, yaanya aba lɔɔ inde rë nï ku. ");
INSERT INTO mgc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tapëtï tɔkɔ mï Atiyɔkɔ, zë ako'jonnï kanisa bi kölö. Zë ayadannï zi vïdï wa ma Wïrï akɔnyi zë zi ko'dɔ, ehe hala mo o'dɔ zi tu'dëë zi koma. ");
INSERT INTO mgc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Here zë alimannï ani vo lö'bö ëtï mï kadra konda. ");
INSERT INTO mgc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Vïdï kora maakowe ayinnï ta Yudiya zi Atiyɔkɔ ehe ayetonnï yandi önduwë 'ba Korisitɔ, iyannï henye, “Ayɔmɔ zë dë nje ëzë aŋbete zë ku kaa Mosa ayandi.” ");
INSERT INTO mgc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pawolo ehe Baranaba awasa hë nnï zë ëtï. Here kanisa omba zi kutu Pawolo ehe Baranaba ehe vïdï maakowe zi tï'bë Yerusalema zi me'do mï kö'du nenye zi vo lïtuwë ehe kyedree mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Here kanisa utu zë. Mati zë ëdïnnï atï'bë, zë ï'bënnï kpuru Ponisiya ehe Samariya, ehe ayadannï hala tu'dëë otɔ dë nnï ku zi Wïrï. Kö'du yöyö nenye o'dɔ önduwë biya na rakyenyi. ");
INSERT INTO mgc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mati kora ne ɔkɔnnï mï Yerusalema, kanisa ïrï zë kalakyedre aba, ehe vo lïtuwë kyedree ëtï. Pawolo, Baranaba ehe vïdï ma ayinnï zë ëtï, ayadannï biya zi zë wa ma Wïrï o'dɔ kpuru kazi zë. ");
INSERT INTO mgc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Here kya 'ba vo koma maakowe mati zë kpa Farasiye, zë ɔrɔnnï rïyë iyannï henye, “Tu'dëë ma ŋbete zë, ehe moronnï kö'du kï'dï 'ba Mosa.” ");
INSERT INTO mgc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Vo lïtuwë ehe kyedree atɔtɔ rë nnï me'do mï kö'du nenye. ");
INSERT INTO mgc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ame'donnï kadra konda aba. Here Petero ënyï rïyë ehe iya henye, “Önduwë, ayɔle ku henye, kyere mï kadra ma alaga, Wïrï inzi ma tëmï kutëë henye tu'dë akowonnï ta dami'di ha ma kö'du yöyö laka ehe koma. ");
INSERT INTO mgc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wïrï mati ayɔlɔ a'di ra ëdï mï di'di vïdï biya, mo ayada mo omba zë ku, Lawo Laka kï'dï aba zi zë, kaa mo ï'dï zi ze. ");
INSERT INTO mgc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wïrï o'dɔ zë dë kutu ta re ze. Mo o'dɔ di'di zë ŋbala koma aba. ");
INSERT INTO mgc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yaanya aba, kö'du a'di ëdïyë yɔnzɔ Wïrï, wa yeto kï'dï gu vo lö'bö nenyee? Wakïnjë nenye ayeto ndra le ze ehe zutu 'bezee ɔ'bɔ dë kïnjë. ");
INSERT INTO mgc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mora doma henye, akayɔmɔ ze wakï'dï 'ba rakyëyï aba kazi Yere Yësu, kpa kaa tu'dëë.” ");
INSERT INTO mgc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Vïdï biya alimannï liwo mati owonnï Baranaba ehe Pawolo ayadannï hala Wïrï o'dɔ kö'du koro, kyïnë kyigɔ 'bënï, ehe rakaga zi tu'dëë kpuru kazi zë. ");
INSERT INTO mgc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tapëtï zë indennï me'do ku, Yemisi iya henye, “Önduwë, oze mbili ye zi ma! ");
INSERT INTO mgc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simona ayada henye hala Wïrï ayi mï kadra ma dagba zi tu'dëë, ehe o'dɔ kya maakowe na vïdï ënï. ");
INSERT INTO mgc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Me'do 'ba nëbïyë ida rë nï ku kö'du kiya 'bama aba. Ëdï na yöru, ");
INSERT INTO mgc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ma kata'ba ehe kuvö löhu loko 'ba Dawidi ma alëpï. Ma kuvö tëmï rayaŋa 'bɔmo ehe kɔ'jɔ mo rïyë löhu, ");
INSERT INTO mgc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","here vïdï ma ɔsɔnnï ehe tu'dëë, mati ma ko'jo zi tëdïnnï vïdï 'bama, akomannï Yere. Ma Yere ra, miya wa nenyee. ");
INSERT INTO mgc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ma ayada zë mï kadra ma alagannï kyere.’” ");
INSERT INTO mgc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Here ma sösu dë da kï'dï wakïnjë yeto da tu'dëë, ma ëdïnnï ku dë nnï kopi zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Da yöru ehe nje yada zi zë, anza dë zi konyo wa maako ma ï'dï ku zi wïrï mbiye, anza dë zi ndoro ko'dɔ, anza dë zi konyo ida 'ba ngötu maakowe mati urï gu mo, ehe anza dë zi konyo yama. ");
INSERT INTO mgc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ga kö'du kï'dï 'ba Mosa ayëtï ku mï gawo biya mï kɔɔ lakyi, ehe ta ga ko'do 'ba ralawo biya ëdï ako'jo mï bi 'ba mötu 'beze. ");
INSERT INTO mgc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Vo lïtuwë ehe kyedree, ehe biya vïdï 'ba kanisa ombannï zi kutu kya kora 'bënnï maakowe zi Atiyɔkɔ zi tï'bënnï Pawolo ehe Baranaba ëtï. Zë inzinnï Sila ehe Yudasi, mati ako'jo kpa Barasaba, zë ra na vo dagbe 'ba önduwë. ");
INSERT INTO mgc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Zë ayörunnï waraga iya henye, “Ze vo lïtuwë, ehe kyedree, ze önduwë dutu wamëtë zi ye biya tu'dë mati vo lö'böwë 'ba Yere mï Atiyɔkɔ, Siriya ehe Silisiya.” ");
INSERT INTO mgc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Dowo ze henye, vïdï maakowe ta kinye, o'dɔnnï yë rasösu aba, ga kö'du ma zë iyannï, mora dutu zë dë. ");
INSERT INTO mgc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Here da tɔtɔ re ze ehe domba ku zi kinzi kya kora maakowe kutu zë zi ye, nï aboka laka 'beze Baranaba ehe Pawolo ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kora nenyee ï'dï dïdï nnï ku kö'du 'ba Yere Yësu Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dëdï kpa kutu zi ye Yudasi ehe Sila, zë ra akayadannï zi ye hë nnï aba, kpa kaa da yöru. ");
INSERT INTO mgc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Lawo Laka ayada zi ze henye, dï'dï ze kya wakïnjë maako dë ndra zi ye ta da ma nenyee: ");
INSERT INTO mgc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","anza dë zi konyo wa maako ma ï'dï ku zi wïrï mbiye, anza dë zi konyo yama, anza dë zi konyo ida 'ba ngötu maakowe mati urï gu mo, ehe anza dë zi ndoro ko'dɔ. Ëzë o'de kö'du nenyee, ako'de na laka. Dutu wamëtë 'beze zi ye.” ");
INSERT INTO mgc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kora sowɔ ne ilannï Yerusalema ehe ï'bënnï Atiyɔkɔ. Here zë ako'jonnï vïdï 'ba kanisa bi kölö ehe ï'dï waraga ne zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mati waraga ne ako'jo, ï'dï rakyigɔ ehe rakyenyi kyedre zi zë. ");
INSERT INTO mgc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasi ehe Sila zë ku nëbïyë, zë iyannï kö'du kayo mati ï'dï kyigɔ zi önduwë. ");
INSERT INTO mgc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kora mati zë ta Yerusalema, tapëtï alimannï kadra maako aba mï Atiyɔkɔ, zë ënyïnnï ta'ba zi vïdï mati utunnï zë. Önduwë iyannï zi zë henye, “Ï'bëë na rakyëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mora Pawolo ehe Baranaba alimannï nduwë mï Atiyɔkɔ. Ani zë ayandinnï kö'du ehe ayëtïnnï me'do 'ba Yere, vïdï kayo maakowe ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kadra maako aba yaa, Pawolo iya zi Baranaba henye, “Dï'bë ze hulëhu ehe tï'bë kongɔ önduwë mï Korisitɔ mï gawo biya mati da yëtï me'do 'ba Yere mï zë. Here da kayɔlɔ ze hala zë ëdïnnï ako'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Baranaba omba zi Yowani koba, ru mo vere Marako. ");
INSERT INTO mgc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Mora Pawolo omba dë, ga kö'du mo ila zë mï Pambaliya ehe mo ɔrɔ ku ta bi lɔɔ ko'dɔ zë ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pawolo ehe Baranaba awasa hë nnï, ehe vïdï kölö tëmï zë ï'bë gërï 'bënï kutu. Baranaba oba Marako ehe ï'bënnï Seyipurusu, ");
INSERT INTO mgc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","mora Pawolo inzi Sila ehe ï'bënnï gërï ma kutu. Önduwë mï Korisitɔ ï'dïnnï zë ku da kala Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pawolo ï'bë kpuru Siriya ehe Silisiya vïdï 'ba kanisa ko'dɔ zi kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pawolo ehe Sila a'bannï zi Dëbë ehe Liyisitra. Ani vo lö'bö maako alima ani, ru mo Timotiyɔ. Ma mo Yuda ra ehe vo koma, mora 'bu mo tëmï Gïrïgï. ");
INSERT INTO mgc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Önduwë mï Korisitɔ mï Liyisitra ehe Yikɔnïyömu iyannï kö'du laka ra Timotiyɔ, ");
INSERT INTO mgc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ehe Pawolo omba mo zi tï'bënnï ëtï. Mora Pawolo aŋbete mo dagba, ga kö'du vïdï 'ba Yude biya toko ani, ayɔlɔnnï henye 'bu 'ba Timotiyɔ tëmï Gïrïgï. ");
INSERT INTO mgc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mati zë ï'bënnï tëmï gawo zi gawo agamo, zë ayadannï zi vïdïyë a'di ra vo lïtuwë ehe kyedree mï Yerusalema ombannï, ehe zi zë koro kö'du kira nenyee. ");
INSERT INTO mgc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kanise ayinnï na kyigɔ mï koma 'bënnï, ehe 'duwï vïdï kayo ï'dï koma 'bënnï mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pawolo aboka 'bënï ëtï 'bënnï kpuru tëmï Paragiya ehe Galatiya, ga kö'du Lawo Laka ila zë dë zi kö'du yëtï mï Asiya. ");
INSERT INTO mgc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tapëtï zë ɔkɔnnï mï Mayisiya, zë ayɔnzɔnnï zi tï'bë mï Bataniya, mora Lawo Laka 'ba Yësu ila zë dë. ");
INSERT INTO mgc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Here zë ï'bënnï dagba kpuru Mayisiya le ɔkɔnnï zi Trowasi. ");
INSERT INTO mgc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yɔndɔ aba, Pawolo ongɔ rayada, vïdï maako tëmï Mesedɔniya ëdï tɔrɔ ani ehe lenze nï, iya henye, “Ayi Mesedɔniya zi kɔnyi ze!” ");
INSERT INTO mgc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tapëtï Pawolo ongɔ rayada ne ku, da yeto gërï koma zi tï'bë Mesedɔniya. Da yɔlɔ ku Wïrï ra ako'jo ze zi kö'du yöyö laka ne yëtï ani. ");
INSERT INTO mgc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Dï'bë ze mbïyï tëmï Trowasi zi Samotresi baburu aba, ehe mï ko'do vere aba dɔkɔ ze mï Napolisi. ");
INSERT INTO mgc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ta karani, dï'bë ze mï Filipi, gawo mati dagba Roma ïrï mï Mesedɔniya. Do'do ze da kyɔ mï Filipi. ");
INSERT INTO mgc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mï ko'do 'ba ralawo, dï'bë ze yaga ha resi 'ba gawo kyedre ne dakapa ranga, da sösu 'beze da ki'ja bi 'ba mötu ani. Da lima ze akaŋo ehe da me'do zi mbara mati ayinnï. ");
INSERT INTO mgc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ma kölö tëmï zë ra Ludiya, mo tëmï gawo kyedre 'ba Tayatira ehe mo vo bɔngɔ 'buluyë kogo dagba ra. Mo vo mötu 'ba Yere Wïrï ra, ehe Yere ayëhu di'di mo zi komba da kö'du mati Pawolo ëdï kiya. ");
INSERT INTO mgc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Here tapëtï mo vo dakota 'bënï ëtï abapatisi zë, mo asesi zɔ ze lenze, “Ëzë asösu ma tïnyö mëdï koma aba mï Yere, ayi alima liŋɔ 'bama.” Ndundu mo aba, mo alëlu de ze gbɔ. ");
INSERT INTO mgc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mï ko'do kölö maako aba, ze da gërï 'beze zi tï'bë bi 'ba mötu, dandɔsi de ze wu'jë vo kalima aba. Mo ëdï dakyikyi aba mï nï here ï'dï kyigɔ zi mo zi yada kö'du ma gba ani. Tapëtï kö'du nenye ko'dɔ, mo o'dɔ kɔhi kyɔ zi kyedre 'bënïyë. ");
INSERT INTO mgc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wu'jë ne usu ga Pawolo, ehe kɔsi ze, ehe mo zɔ nduwë hë nï gbögbö, henye, “Kora nenyee vo kalima 'ba Wïrï ma kyedre. Zë ëdïnnï ayada zi ye hala zi yɔme.” ");
INSERT INTO mgc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nenye ï'bë ko'do kayo aba. Ndundu mo aba, Pawolo ofɔ rë nï ehe iya zi dakyikyi na kamo, iya henye, “Mï ru 'ba Yësu Korisitɔ, mï'dï kö'du zi yï kila wu'jë tisi nenye!” Kandi dakyikyi ne ila mo. ");
INSERT INTO mgc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mati vo kyeti 'ba wu'jë vo kalima ne ayɔlɔnnï henye ga gërï 'ba kɔhi ko'dɔ 'bëzë ï'bë ku, zë ïrïnnï Pawolo ehe Sila ehe ikannï zë zi vo kalakonde mï bi 'ba wakogo. ");
INSERT INTO mgc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Zë ayadannï zi vo mï turu henye, “Yuda nenyee ëdïnnï ku gawo kyedre 'beze ne yaŋa! ");
INSERT INTO mgc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Zë ëdïnnï ayada zi ze ko'dɔ wa mati ze vïdï 'ba Rome ila ze dë zi ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Vïdï kayo alɔdrɔnnï na radrɔko wehe aba da Pawolo ehe Sila. Here vïdï 'ba mï turu iyannï zi vïdïyë henye ote bɔngɔ 'bëzë, ehe ï'dïnnï kö'du zi vïdïyë zë ku'bö mɔvɔ aba. ");
INSERT INTO mgc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tapëtï waku'bö kyënyë, ï'dï zë mï kamba, ehe ayada zi vo ga kamba kongɔ ne zi gë zë kongɔ laka kazi ahonnï. ");
INSERT INTO mgc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Vo ga kamba kongɔ ne o'dɔ kaa mati ayada zi mo. Mo ï'dï zë mï kutë kamba ehe ida ndï zë nyɔri aba ra kulugbu yeto. ");
INSERT INTO mgc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mï kutë yɔndɔ, Pawolo ehe Sila ëdïnnï amötu ehe ngala 'ba wayeto ya'bi aba zi Wïrï, maboso maakowe ëdï 'bënnï mbili nnï koze. ");
INSERT INTO mgc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Truku'du kinzikinzi kyigɔ ayi akɔhɔ kamba le hu mo aba. Ha loko ayëhu rë nnï, ehe nyɔri alëpï biya ta ndï mabosowe. ");
INSERT INTO mgc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mati vo ga kamba kongɔ aliro ehe ongɔ ha loko ayëhu rë nï ku huwë, mo oba kulu 'bënï ehe omba ku kara zi rë nï kofo, ga kö'du mo asösu 'bënï maboso ahonnï ku. ");
INSERT INTO mgc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Mora Pawolo agbögbö hë nï, “Ofo rë yï dë! Vïdï maako aho dë.” ");
INSERT INTO mgc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Vo ga kamba kongɔ ako'jo kö'du wa'do ehe ï'bë mï kamba. Mo alëpï tese aba akaŋo burutu Pawolo ehe Sila. ");
INSERT INTO mgc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tapëtï mo ayasi zë yaga tëmï kamba, mo ako'jo hë zë iya henye, “A'di ra ma ko'dɔ zi tɔmɔ?” ");
INSERT INTO mgc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Zë aya'bannï dɔ mo iyannï henye, “Oma mï Yere Yësu, ehe akayɔmɔ yï. Nenye ëdï kpa tïnyö zi vïdï biya ma alima liŋɔ 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Here Pawolo ehe Sila ayadannï zi mo kö'du 'ba Yere, ehe kpa zi vïdï biya liŋɔ 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mati gba na yɔndɔ, vo ga kamba kongɔ oba zë bi mati mo atɔ'bɔ kaka ɔŋɔ zë. Here mo biya vo dakota 'bënï ëtï abapatisi zë. ");
INSERT INTO mgc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Vo ga kamba kongɔ oba Pawolo ehe Sila liŋɔ 'bënï, ï'dï wa zi zë konyo. Mo na rakyenyi, ga kö'du mo ï'dï koma 'bënï ku mï Wïrï ehe vo dakota 'bɔmowe kpa. ");
INSERT INTO mgc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mï damïndö vere aba, vo 'ba mï turuwë, utunnï kya turu daköndu maakowe kö'du kï'dï aba zi vo ga kamba kongɔ iya henye, “Ile Pawolo ehe Sila mï'bënnï.” ");
INSERT INTO mgc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vo ga kamba kongɔ ayada zi Pawolo iya henye, “Vo mï turu ï'dïnnï kö'du zi ye kinga yï Sila aba na dangölö. Yaanya aba ï'bëë na rakyëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mora Pawolo iya zi turu daköndu nee henye, “Ze vïdï 'ba Roma ehe turuwë 'ba Roma ëdï ze ku'bö ta da komo vïdï kayo, kazi vurë 'beze kiya. Zë u'dunnï ze mï kamba. Yaanya aba zë asösu 'bënnï, zë atɔ'bɔnnï ze kutu na liwo? E e, zë o'dɔnnï dë! Zë ra mayinnï kinye ehe ze yasi yaga.” ");
INSERT INTO mgc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mati turu daköndu ne ayada zi vo mï turu henye, Pawolo ehe Sila zë vïdï 'ba Roma, zë na tere. ");
INSERT INTO mgc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Zë ï'bënnï ako'jonnï hë zë kö'du 'ba wakila. Zë ayasinnï zë yaga tëmï kamba ehe ako'jonnï hë zë, zi tï'bënnï 'de tëmï gawo ne. ");
INSERT INTO mgc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Here Pawolo ehe Sila ï'bënnï mbïyï liŋɔ 'ba Ludiya, ani zë ongɔnnï önduwë, iyannï me'do 'ba rakyigɔ zi zë, ehe ï'bënnï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Tapëtï zë ï'bënnï kpuru Ambahipolisi ehe Apoloniya, zë ï'bënnï dagba zi Tasalanika. Bi 'ba mötu 'ba Yude ëdï mï gawo kyedre nani. ");
INSERT INTO mgc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Here ëdï kaa 'duwï, Pawolo ï'bë ani zi bi 'ba mötu, ehe mï ko'do 'ba ralawo wota mo ame'do zi vïdïyë. Mo ame'do tëmï wayöruwë ");
INSERT INTO mgc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","zi yada zi zë henye, ëdï laka zi Korisitɔ ki'ja riti, ehe ëdï laka mo ënyï tëmï koli. Pawolo ayada kpa zi zë henye, “Yësu mati mëdï kö'du mo kiya, Korisitɔ ra.” ");
INSERT INTO mgc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kya maakowe tëmï zë omannï mï kö'du ma Pawolo iya, ehe ayinnï na vo lö'bö kaa Pawolo ehe Sila. Tu'dë maakowe ehe mbara kayo mati vïdï ayɔlɔnnï zë ndra omannï kpa mï kö'du kise ne. ");
INSERT INTO mgc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yuda maakowe, na mïkumbë ehe zë omannï vïdï 'ba kö'du kyënyë ko'dɔ maakowe mati alimannï toko ra bi 'ba wakogo zi yeto wehe ko'dɔ mï gawo kyedre ne. Zë ombannï zi Pawolo kïrï ehe Sila kika yaga zi vïdï kayo ne, ehe zë ï'bënnï zɔ mbïyï liŋɔ 'ba Jasɔno. ");
INSERT INTO mgc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mora mati zë i'jannï zë dë ani, zë ïrïnnï Jasɔno ehe öndu maakowe ëtï. Zë obannï zë zi vo kalakonda 'ba gawo kyedre ehe hë nnï gbögbö aba henye, “Pawolo ehe Sila o'dɔnnï kö'du kyënyë ku ta bi ne biya. Yaanya aba, ayinnï ku kinye ");
INSERT INTO mgc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ehe Jasɔno ïrï zë kalakyedre aba liŋɔ 'bënï. Zë biya owennï kö'du kï'dï 'ba Yere 'ba Roma ku, iyannï henye, vere maako ru mo Yësu, Yere ra.” ");
INSERT INTO mgc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vo mï turu nenyee na rasösu, mati owonnï nenye. ");
INSERT INTO mgc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Here zë o'dɔnnï Jasɔno ehe maakowe ëtï zi kɔhi kopi dagba atehe 'da zë kila atï'bë. ");
INSERT INTO mgc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mï yɔndɔ kölö ne, önduwë utunnï Pawolo ehe Sila zi Beriya, ehe tapëtï zë ɔkɔnnï, ï'bënnï mï bi 'ba mötu 'ba Yude. ");
INSERT INTO mgc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Vïdï 'ba Beriya ndra na laka ta da vïdï 'ba Tasalanika, ga kö'du zë rakyenyi aba zi kö'du kise ne kïrï, ehe ko'do ta ga ko'do, zë ayandinnï wayöruwë, zi kongɔ ëzë kö'du nenyee tïnyö. ");
INSERT INTO mgc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kayo tëmï zë ï'dï koma 'bënnï mï Yere, vïdï mbara Gïrïgï mati vïdï ayɔlɔnnï zë ndra ehe vïdï kora kayo, ");
INSERT INTO mgc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","mora mati Yude mï Tasalanika owonnï Pawolo ëdï kö'du kise 'ba Wïrï ne yëtï mï Beriya, zë ï'bënnï ani ehe o'dɔnnï vïdï kayo ne zi tëdïnnï na vo wehe 'ba Pawolo. ");
INSERT INTO mgc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kandi önduwë utunnï Pawolo akaŋo ha ranga, mora Sila ehe Timotiyɔ alima 'bënnï mï Beriya. ");
INSERT INTO mgc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Vïdï kora maakowe ï'bënnï na kɔwɔ Pawolo aba le kaa Atenisi, ehe a'bannï kö'du aba zi Sila ehe Timotiyɔ zi tayinnï kandi zi nï. ");
INSERT INTO mgc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mati Pawolo ëdï bi Sila ehe Timotiyɔ kisi mï Atenisi, mo rasösu kyedre aba zi kongɔ wïrï mbiya mï gawo kyedre ne. ");
INSERT INTO mgc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mo ï'bë mï bi 'ba mötu 'ba Yude zi me'do zi Yude ehe zi vïdï 'ba Gïrïgïyë ma erennï Wïrï. Ko'do ta ga ko'do mo ame'do kpa zi vïdï mati mo i'ja bi 'ba wakogo. ");
INSERT INTO mgc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kya vo komoyandi Epikuriyɔno maakowe ehe vo komoyandi Isitɔwïkï maakowe awasa hë nnï kpa mo aba. Vïdï ako'jonnï kö'du henye, “A'di ra vo lumë nenye ayɔnzɔ zi kiya?” Maakowe iyannï henye, “Pawolo ëdï kö'du wïrï 'ba vo leze ra yëtï!” Zë iyannï here ga kö'du mo ëdï ame'do kö'du 'ba Yësu ehe tënyï 'ba vïdï tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Zë ikannï Pawolo bi 'ba ratɔtɔ ako'jo Aropagusi, ehe iya henye, “Ayada zi ze, a'di ra kö'du yandi kyïyï 'bëyï ne biya ëdï? ");
INSERT INTO mgc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Dowo ze ika kö'du rakaga maakowe da yɔlɔ zë dë mï me'do 'bëyï ne a'di ra?” ");
INSERT INTO mgc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kpa ndra ta da wa maako, vïdï 'ba Atenisi ehe vo leze mati ëdï alimannï ani, ɔwɔ zi kowo ehe zi me'do kö'du wakyïyï maako. ");
INSERT INTO mgc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Here Pawolo ɔrɔ mï kutë bi 'ba Aropagusi iya henye, “Vïdï 'ba Atenisi, monge vïdï 'ba yënï ndra. ");
INSERT INTO mgc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mati mëdï tï'bë kpuru bi kongɔ aba da wa mötuwë, mi'ja me'do da karasa: Zi wïrï ma kazi yɔlɔ. Amötuwë wïrï nenye, mora tïnyö ayɔle mo dë. Here momba zi yada kö'du mo zi ye.” ");
INSERT INTO mgc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wïrï nenye ra o'dɔ damöku ehe wa biya mï mo. Mo Yere 'ba komorïyë ehe dakaŋo ehe mo alima dë mï yëkëlu mati uvö kala vïdï köndu aba. ");
INSERT INTO mgc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mo omba wakɔnyi dë kazi vïdï maako. Mo ï'dï dïdï, lawo, ehe wa kpa biya zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tëmï vïdï kölö, Wïrï o'dɔ vïdï mati alimannï dakaŋo, ehe mo o'dɔ kadra ehe bi zi vïdï limannï 'dɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wïrï o'dɔ nenye biya, here zi ze nï koma, ehe tɔkɔ yaga, ehe nï ki'ja. Mora mo anza dë na kɔwɔ ta re ze, ");
INSERT INTO mgc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ehe mo ï'dï kyigɔ zi ze, zi lima, zi tehe, ehe zi tëdï ëyï 'bënï ze. “Ze gisi ɔmo,” kaa vo ngala ya'bi 'be maakowe iyannï. ");
INSERT INTO mgc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kyere ze gisi 'ba Wïrï, da sösuwë dë henye, mo ëdï kaa wïrï mbiya o'dɔ yaga tëmï dahabo mandere manzede mandere yïtö. Mo anza dë kaa wa mati vïdï köndu akasösu ehe ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kɔɔ mati alaga kyere naniye, Wïrï ila nenye biya ga kö'du vïdï ayɔlɔnnï dë a'di ra nëdïnnï ko'dɔ. Mora yaanya aba mo iya henye, vïdï biya ta bi ne motɔ dë nnï zi mo. ");
INSERT INTO mgc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mo akɔ'jɔ ko'do mo ku mati ako'dɔ vurë vïdï 'ba damöku na laka. Ehe mo inzi kora ne, Yësu zi ko'dɔ vurë. Wïrï ï'dï yɔlɔ mo nenye zi ze biya Yësu kïnjë aba tëmï koli. ");
INSERT INTO mgc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kandi mati vïdï owonnï Pawolo iya, kora ïnjë tëmï koli, kya zë maakowe ayetonnï kogo. Maakowe iyannï henye, “Da kowo ze yï ame'do ga kö'du nenye kadra maako aba löhu.” ");
INSERT INTO mgc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mati Pawolo ila bi 'ba ratɔtɔ ne ku, ");
INSERT INTO mgc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","kya kora maakowe ï'dïnnï koma 'bënnï mï Yere ehe ï'bënnï Pawolo aba. Ma kölö tëmï vïdï 'ba ratɔte ru mo Danasiyösi, ehe mbara maako ru mo Damari ehe maakowe kpa kayo ï'dï koma 'bënnï mï Yere. ");
INSERT INTO mgc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pawolo ila Atenisi ï'bë Koriti, ");
INSERT INTO mgc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ani mo i'ja Akuwila, kora maako Yuda ra tëmï Poniyitusu. Anza na konda ta ga ma nenye, Akuwila ayi ta Italiya mbara 'bënï Pirisila aba, ga kö'du Yere Kulidasi ï'dï kö'du Yude biya zi Roma kila. Pawolo ï'bë zi kongɔ Akuwila ehe Pirisila ");
INSERT INTO mgc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ehe i'ja zë vo loko da'börö kuvöwë ra. Pawolo kpa vo loko da'börö kuvö ra, here mo alima zë ëtï ehe o'dɔnnï lɔɔ ga bi kölö. ");
INSERT INTO mgc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mï ko'do 'ba ralawo biya, Pawolo ï'bë bi 'ba mötu 'ba Yude. Mo ame'do zi Yude ehe tu'dë maakowe ehe ayɔnzɔ zi zë kopi. ");
INSERT INTO mgc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mora tapëtï Sila ehe Timotiyɔ ɔkɔnnï ta Mesedɔniya, mo ayaŋa kadra 'bënï biya zi yëtï kö'du zi Yude Yësu mo Korisitɔ ra. ");
INSERT INTO mgc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ndundu mo, zë ofɔ rë nnï dɔ mo alidinnï mo. Here mo akɔhɔ durufu ta ra bɔngɔ 'bënï ehe iya zi zë henye, “Wa mati o'dɔ rë nï zi ye, atëdï kö'du lïtë 'be ra! Ayaŋe ru ma dë. Yaanya aba ehe dagba ani mëdï tï'bë yëtï zi tu'dë maakowe.” ");
INSERT INTO mgc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pawolo idra rë nï liŋɔ 'ba kora maako ru Tito Jusitusu mo vo mötu zi Wïrï, ehe liŋɔ 'bɔmo kara dakapa bi 'ba mötu. ");
INSERT INTO mgc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kurusipo ra vo dagba 'ba bi 'ba mötu ne. Mo ehe vïdï biya mï dakota 'bɔmo ï'dï koma 'bënnï mï Yere. Ma kayo maakowe mï Koriti owonnï kö'du kise ne kpa, ehe vïdï biya mati koma aba mï Yere abapatisi zë. ");
INSERT INTO mgc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Yɔndɔ kölö maako aba, Yere ame'do zi Pawolo tëmï rayada iya henye, “Ere dë, zi sesi kö'du yëtï nduwë dagba. Ɔrɔ dë! ");
INSERT INTO mgc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ma yï aba, ehe vïdï o'dɔnnï wa maakowe dë zi yï. Vïdï kayo mï gawo kyedre nenye, 'bama ra.” ");
INSERT INTO mgc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pawolo alima mï Koriti kɔɔ kölö ehe yehe modaka, vïdï yandi me'do 'ba Wïrï aba. ");
INSERT INTO mgc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Mati Galikö Yere 'ba Akasiya, kya Yuda maakowe ayinnï bi kölö ehe ïrïnnï Pawolo. Zë ikannï mo bi 'ba vurë ");
INSERT INTO mgc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ehe iyannï henye, “Kora nenye ëdï yɔnzɔ zi vïdï 'beze ko'dɔ zi mötu Wïrï mï gërï mati kö'du kï'dï 'beze omba dë.” ");
INSERT INTO mgc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Gba kazi Pawolo me'do, Galikö iya henye, “Ëzë ëdï vurë kiya ra kora nenye, na vo kö'du kyënyë ko'dɔ mandere wa maako eme dë, ma kowo me'do 'bëyï ne. ");
INSERT INTO mgc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mora kyere nje me'do 'ba ha, ru ehe kö'du kï'dï 'be, onge gɔ mo na bi de. Momba dë zi vurë ma here ne, kiya.” ");
INSERT INTO mgc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Here mo utu zë yaga ta bi 'ba vurë. ");
INSERT INTO mgc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Vïdï ne ïrïnnï Sositenisi, vo dagba bi 'ba mötu 'ba Yude, u'bönnï mo komo bi 'ba vurë. Mora du kö'du ne ɔgɔ dë da Galikö. ");
INSERT INTO mgc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Tapëtï lima 'ba Pawolo yaa vo lö'bö 'ba Yere ëtï mï Koriti, mo iya zi zë alime gbɔ ehe ï'bë Siriya, Akuwila aba ehe Pirisila. Mora gba mo ï'bë dë, mo atëtë dë nï bi 'ba Senesiriya ga kö'du mo o'dɔ lömu zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mati zë ɔkɔnnï Efeso, Pawolo ila Pirisila ehe Akuwila. Mo ï'bë bi 'ba mötu zi me'do zi Yude ani. ");
INSERT INTO mgc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Zë ako'jonnï hɔ mo zi lima ani na konda, mora mo omba dë. ");
INSERT INTO mgc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mo ayada zi zë alime gbɔ, ehe iya henye, “Ëzë Wïrï ila ma, ma tayi hulëhu.” Here mo ila Efeso. ");
INSERT INTO mgc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pawolo ï'bë zi Kasariya, bi mati mo amëtë kanisa. Here mo ï'bë dagba Atiyɔkɔ. ");
INSERT INTO mgc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tapëtï lima 'bɔmo tisi ani, mo ila ehe ï'bë zi bi kayo mï Galatiya ehe Paragiya. Mo akɔnyi vo lö'böwë ani zi tayinnï na kyigɔ mï koma 'bënnï. ");
INSERT INTO mgc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yuda maako ru mo Apolo ayi zi Efeso. Apolo o'jo mo mï gawo kyedre 'ba Alikazenderiya. Mo vo kö'du yɔlɔ 'ba wayöruwë 'ba Wïrï kayo. ");
INSERT INTO mgc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mo ayɔlɔ kö'du 'ba gërï 'ba Yere kpa kayo, ehe mo ëdï ame'do mï mo, da kö'du komba kyedre aba. Wa mati mo ayandi kö'du Yësu ëdï tïnyö, mora mo ayɔlɔ nje bapatisi 'ba Yowani. ");
INSERT INTO mgc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo ayeto me'do kazi tere bi 'ba mötu. Mati Pirisila ehe Akuwila owonnï mo, zë obannï mo liŋɔ 'bënnï ehe akɔnyinnï mo zi yɔlɔ kö'du 'ba Wïrï na laka. ");
INSERT INTO mgc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo omba zi tï'bë zi Akasiya. Here önduwë ayörunnï waraga ayada zi vo lö'böwë mati ëdïnnï ani ne, zi mo kïrï kalakyedre aba. Tapëtï Apolo ɔkɔ mï Akasiya, mo na wakɔnyi kyedre zi vïdï biya mati ï'dï koma 'bënnï mï Yere Yësu ga kö'du wakï'dï 'ba rakyëyï 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mo alëpï mï ha wasa Yude ëtï, ehe ta da komo vïdï kayo. Mo oba tëmï wayöruwë zi yada henye, Yësu mo Korisitɔ ra. ");
INSERT INTO mgc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mati Apolo ëdï mï Koriti, Pawolo ï'bë kyëtï dakaŋo, ehe oko mï Efeso. Ani mo i'ja kya vo lö'bö 'ba Yere maakowe. ");
INSERT INTO mgc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mo ako'jo hë zë iya henye, “Mati ï'dïyë koma 'be mï Yësu, ï'dï Lawo Laka ku zi ye?” Zë aya'bannï dɔ mo iyannï henye, “E e, gba dowo ze kö'du 'ba Lawo Laka dë.” ");
INSERT INTO mgc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pawolo ako'jo hë zë iya henye, “Here, bapatisi 'ba a'di ra ïrïyë?” Zë aya'bannï dɔ mo iyannï henye, “Bapatisi 'ba Yowani.” ");
INSERT INTO mgc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pawolo aya'ba dɔ mo iya henye, “Yowani abapatisi vïdï, here zi dë nnï kotɔ zi Wïrï. Mora mo ayada kpa zi zë, vïdï maako ëdï tayi, ehe zë akï'dï koma 'bënnï mï mo. Yësu ra vïdï mati Yowani ëdï ame'do kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tapëtï vïdï owonnï Pawolo iya nenye, abapatisi zë mï ru 'ba Yere Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Here, Pawolo ï'dï kala nï dë zë. Ï'dï Lawo Laka ku zi zë ehe zë ame'donnï ha kazi yɔlɔ maako aba, ehe kumë me'do. ");
INSERT INTO mgc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ani ëdï kaa kora 'butë dɔmorïyö mï gboko nenye. ");
INSERT INTO mgc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Yehe wota aba, Pawolo ï'bë mï bi 'ba mötu 'ba Yude, ehe ame'do vïdï ëtï kazi tere kö'du damöku 'ba Wïrï. Mo ayɔnzɔ zi dë zë lëlu, ");
INSERT INTO mgc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","mora maakowe tëmï zë na vo kazi kö'du kowo, ehe ombannï dë zi koma. Ta da komo vïdï kayo, zë iyannï kö'du kyënyë ra gërï 'ba Wïrï. Pawolo ila zë, ehe oba vo lö'böwë nï aba zi loko yandi 'ba Tiyerenisi. ");
INSERT INTO mgc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mo ame'do ani 'duwï kɔɔ rïyö, le Yuda biya ehe tu'dë maakowe mï Asiya owonnï kö'du kise 'ba Yere. ");
INSERT INTO mgc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wïrï ï'dï kyigɔ zi Pawolo kö'du koro ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Vïdï obannï mandïlï ehe bɔngɔ mati ise ida ra Pawolo, ehe zë ïnjënnï zë, zi vïdï biya mati na rakɔɔ. Biya vïdï mati na rakɔɔ akɔ'jɔ, ehe dakyikyi ï'bënnï yaga. ");
INSERT INTO mgc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kya kora Yuda maakowe, ï'bënnï toko yɔnzɔ zi kore dakyikyi yaga mï ru 'ba Yere Yësu. Zë iyannï zi dakyikyi henye, “Ayi yaga mï ru kölö 'ba Yësu, mati Pawolo ëdï ayëtï!” ");
INSERT INTO mgc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gisi kora madɔmorïyö 'ba kyedre 'ba vo karase 'ba Yude, ru mo Seva gisi 'bɔmo ëdïnnï ko'dɔ nenye. ");
INSERT INTO mgc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ko'do maako aba dakyikyi iya zi zë henye, “Ma yɔlɔ Yësu, ehe mowo kö'du Pawolo, mora yï 'bëyï ëyï?” ");
INSERT INTO mgc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mora kora mati dakyikyi aba mï nï ne, öfu dë zë ehe u'bö zë. Zë ahonnï yaga ta loko, na ga mbiya ehe ɔŋɔ aba. ");
INSERT INTO mgc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mati Yude ehe tu'dë maakowe mï Efeso owonnï kö'du nenye, zë tere aba, here zë ayetonnï ru 'ba Yere Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yaanya aba vo lö'bö kayo odrɔ hë nnï ga kö'du kyënyë mati nëdïnnï ako'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kya maakowe mati na vo mörï ne, ikannï buku 'bënnï ehe o'bɔ zë komo vïdï kayo. Buku nenyee ogo kpuluku'butëmuyï kɔhi ŋbiriṛi. ");
INSERT INTO mgc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Here kö'du kise 'ba Yere apere rë nï, ehe ayi ndra na kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tapëtï kö'du nenye biya o'dɔ rë nï ku, Pawolo omba zi tï'bë Mesedɔniya ehe Akasiya da gërï 'bënï Yerusalema. Pawolo iya henye, “Ta nani ma katï'bë gba zi Roma.” ");
INSERT INTO mgc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Here mo utu vo kɔnyi 'bënï rïyö, Timotiyɔ ehe Eresitɔ zi Mesedɔniya. Mora mo alima nduwë tisi mï Asiya. ");
INSERT INTO mgc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mï kadra nani kö'du kyënyë o'dɔ rë nï mï Efeso ga kö'du Gërï 'ba Yere. ");
INSERT INTO mgc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vo toka 'ba manzede kuku maako ru mo Demetrisi ëdï lɔɔ 'bënï aba, ko'dɔ wïrï mbiya 'ba Aratemisi tëmï manzede. Zë mati o'dɔnnï lɔɔ zi mo, i'jannï kɔhi kyɔ. ");
INSERT INTO mgc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrisi ika bi kölö vïdï mati mï lɔɔ kölö ne, ehe iya henye, “Aboka me, ayɔle dëdï lima na laka ga kö'du nenye. ");
INSERT INTO mgc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mora tïnyö onge ku, ehe kowo hala kora nenye Pawolo ëdï vïdï kayo kofɔ, anza dë nje mï Efeso, mora ta ga bi ne biya mï Asiya. Mo iya henye, wïrï mati ze vïdï köndu dëdï ko'dɔ mo ne, anza wïrï ma tïnyö ra dë. ");
INSERT INTO mgc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Vïdï biya akayeto kö'du kyënyë kiya ra lɔɔ 'beze. Vïdï atɔrɔnnï ta bi koro wïrï kyedre 'ba Aratemisi, mati ëdï mötu mï Asiya ehe biya mï damöku ne.” ");
INSERT INTO mgc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mati vïdï 'ba lɔɔ owonnï nenye, ënyïnnï na kamo ehe ayetonnï hë nnï gbögbö, “Kyedre ra Aratemisi, wïrï 'ba Efeso.” ");
INSERT INTO mgc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kandi gawo kyedre ne ku ha gbögbö aba, ehe vïdï kora maakowe ïrïnnï Gayisu ehe Arisitarisi, mati ayinnï ta Mesedɔniya Pawolo aba. Here vïdï biya ahonnï bi 'ba ratɔtɔ 'ba gawo. ");
INSERT INTO mgc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawolo na bi dë nï omba tï'bë komo vïdï kayo, vo kome ilannï mo dë. ");
INSERT INTO mgc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kya 'ba vo kalakonda maakowe mati na aboka 'bɔmowe utunnï kö'du kise kpa zi mo, mo lenze kazi tï'bë. ");
INSERT INTO mgc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Vïdï kayo bi 'ba ratɔtɔ ne, hë nnï gbögbö kö'du wa maako, ehe agamowe kpa hë nnï gbögbö ga kö'du maakowe. Da vïdï biya na wïrï wïrï, ehe na kayo tëmï zë ayɔlɔnnï dë kö'du a'di nayinnï gɔ mo bi kölö. ");
INSERT INTO mgc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Vo dagba 'ba Yude adu'dunnï kora maako ru mo Alekazende komo vïdï kayo, ehe ayetonnï yada zi mo a'di ra zi kiya. Mo ame'do kala nï aba zi zë tɔrɔ ti, ehe ayɔnzɔ zi mï kö'du ne ya'ba, a'di ra ëdï tï'bë dagba. ");
INSERT INTO mgc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mora mati vïdï kayo ongɔnnï mo Yuda ra, zë biya agbögbö hë nnï kadra rïyö aba, “Kyedre ra Aratemisi, wïrï 'ba Efeso.” ");
INSERT INTO mgc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ndundu mo aba vo mï turu 'ba gawo ne, o'dɔ vïdï kayo zi tëdï ti. Here mo iya henye, “Vïdï 'ba Efeso, vïdï biya mï damöku ne ayɔlɔnnï henye yëkëlu ëdï mï kutë gawo kyedre 'beze, ga kö'du zi mötu kyedre wïrï Aratemisi. Ëyï ra ayɔlɔ dë henye, kyïnë mo, mati alëpï ta komorïyë, ëdï kinye? ");
INSERT INTO mgc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Vïdï maako ɔ'bɔ dë tandi ga kö'du nenye. Here, alime ti, o'de kö'du kyënyë maako dë. ");
INSERT INTO mgc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ike kora nenyee kinye, anza dë le, zë ra olɔnnï yëkëlu mandere lidi wïrï 'beze. ");
INSERT INTO mgc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ëzë Demetrisi vo lɔɔ 'bënï ëtï asusunnï vïdï maako, dëdï ze kalakonda aba, 'duwï bi 'ba vurë ëdï na yëhu. Vurë akikye rë nï 'da ani. ");
INSERT INTO mgc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ëzë waako ëdï ndra ta da mati ombe, akakɔ'jɔ mï bi 'ba vurë. ");
INSERT INTO mgc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tapëtï kö'du mati o'dɔ rë nï ndenye, kyënyë mo ëdï, akasusu ze ra, na vo kö'du kï'dï pere. Wakila anza dë ga kö'du biya 'ba kö'du kï'dï pere ne, da tɔ'be dë zi hu kö'du ma laka ne kiya.” ");
INSERT INTO mgc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tapëtï kö'du nenye kiya, mo apere ratɔtɔ ne, mo ayada zi vïdï tï'bënnï. ");
INSERT INTO mgc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tapëtï ha gbögbö inde rë nï ku, Pawolo ise kö'du zi vo lö'böwë ehe ame'do me'do 'ba rakyigɔ zi zë. Mo ila zë, ehe ï'bë zi Mesedɔniya. ");
INSERT INTO mgc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kaa mati mo ï'bë ta bi maako zi agamo, mo ame'do me'do 'ba rakyigɔ zi vo lö'böwë kö'du kise kayo aba. Ndundu mo, mo ï'bë Gïrïgï ");
INSERT INTO mgc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ehe alima ani yehe wota. Pawolo omba ku zi tï'bë Siriya. Mora Yude o'dɔnnï yeṛe rɔ mo, here mo omba zi tï'bë hulëhu ta gërï 'ba Mesedɔniya. ");
INSERT INTO mgc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mo oba Sapatere wisi 'ba Piyasi ta Beriya, Arisitarisi, Sekandusu ta Tasalanika, Gayisu ta Dëbë, Timotiyɔ, ehe vïdï rïyö 'ba Asiya ru zë Tayihikasi ehe Trɔhimusu nï aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Zë ï'bënnï dagba zi Trowasi, ehe isinnï bi ze ani. ");
INSERT INTO mgc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tapëtï karama 'ba mangɔlɔ'bɔ konyo kazi langa, dayi ze ta Filipi. Yaa ko'do da muyï aba, di'ja zë mï Trowasi, ehe da lima ani ko'do 'ba gima kölö. ");
INSERT INTO mgc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mï dagba ko'do 'ba gima, da tɔtɔ re ze wakonyo bi kölö. Pawolo ame'do zi vïdï le mï kutë yɔndɔ, ga kö'du mo omba tï'bë mïndö aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Rïyë mï lokotɔrɔ bi ma dëdï re ze tɔtɔ, ani lamba kayo ëdï. ");
INSERT INTO mgc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kora ɔbi maako ru mo Yuteyusi ëdï alima mï bïngö 'ba loko. Mati Pawolo ame'do, ame'do na konda, Yuteyusi anano. Ndundu mo aba, mo ï'bë ko'do ehe alëpï tëmï lokotɔrɔ ma wota 'ba rïyë le dakaŋo. Mati ïnjënnï mo rïyë, mo oli wënï ku. ");
INSERT INTO mgc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pawolo ï'bë akaŋo ehe ïdë rë nï da Yuteyusi. Mo ïrï mo mï kanza nï ehe iya henye, “Asösuwë dë! Mo ëdï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tapëtï Pawolo ï'bë hulëhu rïyë mï lokotɔrɔ, mo owe mangɔlɔ'bɔ ehe onyo. Mo ame'do le ra bi kezi ehe ï'bë. ");
INSERT INTO mgc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Here zë obannï kora ɔbi ne liŋɔ na dïdï, ehe zë rakyenyi aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Dï'bë ze dagba zi baburu ehe dï'bë baburu aba zi Asoso, ehe domba tï'bë zi Pawolo koba mï baburu. Mo akɔ'jɔ nenye ga kö'du mo ëdï tï'bë ani ndï aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Mati mo i'ja ze mï Asoso, mo ayi mï baburu ehe dï'bë zɔ dagba zi Mitiyilina. ");
INSERT INTO mgc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mï ko'do vere, dayi zi bi maako kara ra Kiyɔsi ehe mï ko'do vere dɔkɔ Samoso. Tapëtï ko'do ma nani, dï'bë ze Meletusu. ");
INSERT INTO mgc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pawolo omba zi tï'bë dagba Efeso kopi, ga kö'du mo omba dë zi kadra yaŋa mï Asiya. Mo na kɔrɔkɔrɔ ehe omba zi tëdï mï Yerusalema mï ko'do karama 'ba wakumu ta yaka. ");
INSERT INTO mgc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ta Meletusu Pawolo utu kö'du kise zi kyedree 'ba kanisa 'ba Efeso zi tayinnï zi nï. ");
INSERT INTO mgc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mati zë ɔkɔnnï ani, mo iya henye, “Ayɔle wa mati mo'dɔ ku biya mï kadra mëdï ëtï, mati mayi dagba zi Asiya. ");
INSERT INTO mgc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yuda maakowe o'dɔnnï mala ra ma ehe o'dɔ ma na rasösu ehe riti. Mora mëdï lɔɔ 'ba Yere ko'dɔ komo tɔlɔ aba ehe kazi rakïsï. ");
INSERT INTO mgc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mati ma yëtï kö'du mï vïdï kayo, mandere yandi kö'du mï liŋɔ 'be, mïrï wa maako dë hulëhu ta bi yada wa mati akakɔnyiye. ");
INSERT INTO mgc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ma yada zi Yude ehe tu'dë maakowe zi dë nnï kotɔ zi Wïrï tëmï kö'du kyënyë ko'dɔ 'bënnï ehe zi koma mï Yere 'beze Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ma yɔlɔ dë, a'di ra ako'dɔ rë nï zi ma mï Yerusalema, mora ma koro Lawo Laka 'ba Wïrï ehe tï'bë ani. ");
INSERT INTO mgc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mï gawo kyedre biya mï'bë, Lawo Laka ayada zi ma henye, akï'dï ma mï kamba ehe ma tëdï mï riti. ");
INSERT INTO mgc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mora ma sösu wa ma ako'dɔ rë nï zi ma dë, momba nje zi taho zi kinde lɔɔ mati Yere Yësu ï'dï zi ma ko'dɔ. Lɔɔ nenye zi yada kö'du yöyö laka 'ba Wïrï, wakï'dï 'ba rakyëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mï'bë tëmï bi maako, zi bi maako, yëtï zi ye kö'du 'ba damöku 'ba Wïrï, mora yaanya aba ma yɔlɔ ku, vïdï maako tëmï yë ongɔ ma dekpe löhu. ");
INSERT INTO mgc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ma yada zi ye ndenye, mo'dɔ wa kyënyë maako dë zi ye. ");
INSERT INTO mgc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ma yada wa mati Wïrï omba zi ye yɔlɔ ne, ku biya. ");
INSERT INTO mgc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ongɔ ga re, ehe vïdï biya Lawo Laka ï'dï ku kale ze zi gë zë kongɔ. Ëdïyë na vo yako 'ba kanisa 'ba Wïrï, kanisa mati Wïrï ogo yama 'ba wisi 'bënï aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ma yɔlɔ ku, tapëtï tï'bë 'bama, maakowe atayinnï kaa wölïwölï kyënyë lëpï de kamo aba. ");
INSERT INTO mgc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Kya 'ba vïdï 'be maakowe, akigannï mbërë zi vo lö'bö 'ba Yere ta'da. ");
INSERT INTO mgc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ëdïyë bi kida aba! Asösuwë hala kadra ehe yɔndɔ aba kɔɔ wota ma sesi yandi ye tɔlɔ aba komo ma. ");
INSERT INTO mgc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yaanya aba, mï'dï yë ku da kala Wïrï. Asösuwë kö'du kise 'ba wakï'dï 'bɔmo 'ba rakyëyï. Kö'du kise nenye, atɔ'bɔ kɔnyi ye, ehe akï'dï zi ye drïvu mï kutë zë biya mati o'dɔ zë ŋbala. ");
INSERT INTO mgc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Momba kɔhi 'ba vïdï maako dë, mandere bɔngɔ. ");
INSERT INTO mgc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ayɔle ku hala mo'dɔ lɔɔ kala 'bama aba zi ko'dɔ ma na dïdï ehe aboka me. ");
INSERT INTO mgc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mora wa biya mati mo'dɔ, yada hala ako'de zi kɔnyi vo leriye. Asösuwë, Yere 'beze Yësu iya henye, ‘Ya'da ayi kayo ta bi wakï'dï ndra ta da wakïrï.’” ");
INSERT INTO mgc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tapëtï Pawolo inde me'do kiya ku, mo alɔmvɔ akaŋo zë ëtï biya ehe amotunnï. ");
INSERT INTO mgc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Vïdï biya udunnï ehe onzonnï mo ehe unzunnï hɔ mo. ");
INSERT INTO mgc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Zë na rasösu ga kö'du Pawolo ayada zi zë henye, “Onge ma dekpe löhu.” Here zë ï'bënnï mo aba zi baburu. ");
INSERT INTO mgc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tapëtï kiya alime gbɔ, dï'bë mbïyï zi Kosi baburu aba. Mï damïndö mo aba dɔkɔ Rudasiya ehe ta karani, dï'bë zɔ Patara. ");
INSERT INTO mgc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Di'ja baburu ëdï tï'bë Ponisiya, dödu ze mï mo dï'bë gbɔ. ");
INSERT INTO mgc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dayi ze bi mati dongɔ ze Seyipurusu ehe dï'bë zɔ daaba 'bɔmo, bitɔrɔ 'ba baburu 'ba Tiyere mï Siriya, ani baburu omba ku zi wakïnjë yasi tëmï nï. ");
INSERT INTO mgc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Di'ja ze vo lö'böwë 'ba Yere ehe da lima zë ëtï gima kölö. Here Lawo Laka ayada zi zë, zi yada zi Pawolo mï'bë dë Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mora mati Gima inde rë nï ku, da yeto tï'bë dagba da gërï 'beze löhu. Vïdï kora biya mbara 'bënnï ëtï ehe gisisi alasinnï ze aba tëmï gawo zi ha ranga kyedre. Dodrɔ domo ze akaŋo dagötï, damötu. ");
INSERT INTO mgc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tapëtï kiya alime gbɔ zi oka kölö maako, dëkyï mï baburu ehe zë ï'bënnï hulëhu liŋɔ. ");
INSERT INTO mgc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Dï'bë ze ta Tiyere zi Potemasi, ani da mëtë ze önduwë ehe da lima zë ëtï ko'do kölö aba. ");
INSERT INTO mgc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mï ko'do ma vere dï'bë zi Kasariya ehe da lima ze liŋɔ 'ba Pilipo vo kö'du yëtï. Mo kölö tëmï vïdï kora madɔmorïyö mati akɔnyinnï vo lö'böwë. ");
INSERT INTO mgc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mo ëdï gisi mïnzö kazi koze aba sowɔ. Zë na vo kumë kö'du. ");
INSERT INTO mgc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Dëdï ze mï Kasariya ko'do kayo aba, mati nëbï ru mo Agabusu ayi zi ze ta Yudiya. ");
INSERT INTO mgc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Mo ïrï kɔ'di ga Pawolo, ehe mo ida kala nï ehe ndï nï mo aba. Here mo ayada zi ze, iya nenye, “Lawo Laka iya henye, Yude mï Yerusalema akidannï kora vo kyeti 'ba kɔ'di nenye. Zë akï'dïnnï mo kpa zi tu'dë maakowe.” ");
INSERT INTO mgc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tapëtï Agabusu iya nenye, ze ehe vïdï ma ëdïnnï lima ani, alenzennï Pawolo zi tï'bë dë zi Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mora Pawolo aya'ba da me'do iya henye, “Kö'du a'di, ëdïyë kudu ehe di'di ma kowe? Manza dë nje nzɔ zi kida, mora mëdï kpa nzɔ zi koli ga kö'du 'ba Yere Yësu mï Yerusalema.” ");
INSERT INTO mgc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kyere dɔ'bɔ dë zi Pawolo ko'dɔ zi dë nï kopi, dila mo ehe damötu, “Akɔ Yere, o'dɔ zi ze wa mati omba zi rë nï ko'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Here ze nzɔ zi tï'bë Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kya 'ba vo lö'bö maakowe tëmï Kasariya, ï'bënnï ze aba ehe obannï ze zi lima liŋɔ 'ba Manasɔno. Mo ta Seyipurusu ehe vo lö'bö ra biyeto aba. ");
INSERT INTO mgc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mati dɔkɔ mï Yerusalema, önduwë na rakyenyi ïrïnnï ze kalakyedre aba. ");
INSERT INTO mgc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pawolo ï'bë ze aba zi Yemisi kongɔ ko'do vere aba, ehe kyedree 'ba kanisa ëdïnnï biya ga bi mo. ");
INSERT INTO mgc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pawolo amëtë zë ehe ayada hala Wïrï o'dɔ nï zi kɔnyi tu'dë maakowe. ");
INSERT INTO mgc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Vïdï biya mati owonnï nenye ayetonnï Wïrï, ehe iyannï zi Pawolo henye, “Öndu ze, atɔ'bɔ kongɔ hala kpuluku 'ba vïdï 'beze Yude ayinnï ku na vo lö'böwë! Ehe zë biya nzɔ zi koro kö'du kï'dï 'ba Mosa. ");
INSERT INTO mgc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Mora ayada zi zë henye, ëdï ayandi Yude mati ëdïnnï alima mï kutë tu'dë maakowe, kazi koro kö'du kï'dï 'ba Mosa. Zë iyannï henye, ayada zi nnï ŋbete gisi kora 'bënnï dë mandere lö'bö ga dalëtï 'beze. ");
INSERT INTO mgc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","A'di ra da ko'dɔ yaanya aba, vïdï owonnï ku ëdï kinye? ");
INSERT INTO mgc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Akɔ, o'dɔ wa ma da ko'jo kö'du mo. Vïdï kora sowɔ 'beze maakowe o'dɔnnï lömu ku zi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Oba kora nenyee o'dɔ rë yï ŋbala zë ëtï na kö'du kï'dï 'ba Mosa, ehe opi wakï'dï 'bëzë here zë mohi dë nnï. Here zi vïdï biya yɔlɔ henye, kö'du ako anza dë mï kö'du yada 'bëzë ne. Zë akayɔlɔnnï orowe kö'du kï'dï 'ba Mosa. ");
INSERT INTO mgc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kadra ma alaga nani aba, da yada zi vo lö'böwë 'ba tu'dë maakowe, mati da sösu zi zë ko'dɔ. Diya zi zë, monyonnï wa mati ï'dï zi wïrï ma mbiya ne dë. Ayada zi zë, monyonnï yama dë, mandere ida 'ba ngötu mati urï gu mo. Ayada kpa zi zë, mo'dɔnnï kö'du kyënyë 'ba ndoro dë.” ");
INSERT INTO mgc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mï ko'do vere aba, Pawolo oba kora sowɔ nï aba ehe akɔ'jɔ rë nnï nzɔ mï kadra kölö. Here mo ï'bë mï yëkëlu ehe ayada ndala aba kadra 'ba ra ko'dɔ ŋbala ne akinde rë nï ehe ndala aba akï'dï wakumu zi ma kölö tëmï zë. ");
INSERT INTO mgc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mati kadra 'ba ra ko'dɔ ŋbala ku kara zi rë nï kinde, kya 'ba Yuda maakowe tëmï Asiya ongɔnnï Pawolo mï yëkëlu. Zë o'dɔnnï vïdï kayo na kamo Pawolo aba, ehe zë ïrïnnï mo. ");
INSERT INTO mgc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vïdï kayo hë nnï gbögbö aba, iyannï henye, “Kora 'ba Yuda akɔnyi ye ze! Kora nenye ï'bë ta bi ne toko, kö'du kyënyë kiya aba ra vïdï 'ba Yiserele, ehe kö'du kï'dï 'ba Mosa, ehe yëkëlu nenye. Mo ika komokaya kpa zi yëkëlu laka nenye, tu'dë maakowe kika mï mo.” ");
INSERT INTO mgc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kya zë maakowe asösunnï henye Pawolo ika Trɔhimusu ta Efeso mï yëkëlu, ga kö'du zë ongɔnnï zë 'dö rïyö mï gawo kyedre ne. ");
INSERT INTO mgc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mï gawo kyedre ne biya kpɔrɔ aba, ehe vïdï ayinnï taho aba. Zë ïrïnnï Pawolo ehe otɔnnï mo yaga tëmï yëkëlu. Here ha loko biya isi rë nï. ");
INSERT INTO mgc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Vïdï ombannï ku kara zi Pawolo kofo, mati kyedre 'ba turu anjiya mï turu 'ba Roma owo henye biya Yerusalema ayeto ku zi kamo ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kandi mo oba kya vo kanya maakowe ehe vo da kanye, ehe ahonnï bi mati vïdï kayo atɔtɔ rë nnï zi mo. Kandi mati vïdï kayo ne ongɔnnï vo kyëlu ne, ehe vo hu kanye, zë ɔrɔnnï ta bi Pawolo ku'bö. ");
INSERT INTO mgc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kyedre 'ba vo kyëlu ne ï'bë ehe ïrï mo, ehe ida mo nyɔri rïyö aba. Here mo ayɔnzɔ zi yɔlɔ, ëyï ra Pawolo ehe a'di ra mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kya 'ba vïdï kayo maakowe agbögbö hë nnï kö'du wa maako, ehe maakowe agbögbö hë nnï kö'du wa maako 'beri. Mora ëdïnnï ku ko'dɔ kpɔrɔ kyɔ kyedre 'ba vo kyëlu ɔ'bɔ dë zi wa maako ki'ja. Here mo ï'dï kö'du zi Pawolo koba bi 'ba vo kanye. ");
INSERT INTO mgc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Mati zë ɔkɔnnï ani, vïdï kayo ayinnï na kamo, here vo kanya ïrïnnï Pawolo rïyë ehe ïnjënnï mo. ");
INSERT INTO mgc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Vïdï kayo alö'bönnï ga ndï zë ehe nduwë hë nnï gbögbö aba henye, “Ofo mo! Ofo mo!” ");
INSERT INTO mgc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mati ombannï ku zi Pawolo koba mï bi 'ba vo kanye, mo ako'jo ha kyedre 'ba vo kyëlu ne, iya henye, “Ma tɔ'bɔ dë kiya kö'du maako zi yï?” Kyedre 'ba vo kyëlu ne ako'jo hɔ mo iya henye, “Hala ayɔlɔ ha 'ba Gïrïgï? ");
INSERT INTO mgc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Anza dë vïdï 'ba Ezipeto mati ayeto kamo anza na kɔwɔ ehe alëpï dagba zi vo wehe ko'dɔ kpulukusowɔ yaga mï da lïpï?” ");
INSERT INTO mgc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pawolo aya'ba dɔ mo iya henye, “E e. Ma Yuda ra, ta Tasisi gawo kyedre laka mï Silisiya. Akɔ ila ma, ma me'do zi vïdï kayo nee.” ");
INSERT INTO mgc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kyedre 'ba vo kyëlu ayada zi mo, mo atɔ'bɔ me'do. Here Pawolo ɔrɔ rïyë ame'do kala nï aba zi vïdï. Mati dë zë ku liwo, mo ame'do zi zë ha 'ba Hïbïru aba. ");
INSERT INTO mgc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Önduwë ehe 'buwë, owowe kaa miya wa mati o'dɔ rë nï.” ");
INSERT INTO mgc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mati vïdï kayo ne owonnï Pawolo ame'do zi nnï mï ha 'ba Hïbïru, zë ayinnï ndra liwo. Here Pawolo iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ma Yuda ra, o'jo ma mï gawo kyedre 'ba Tasisi mï Silisiya. Mora mövu kinye mï Yerusalema na vo kö'du ko'jo 'ba Gamalili, ehe ayandi ma zi kusu ga ndï kö'du kï'dï 'ba zutu 'beze biya. Tïnyö, ma kpa momba zi Wïrï koro, kaa e biya mati ndenye.” ");
INSERT INTO mgc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“Ma yaza vïdï mati usu Gërï 'ba Yere, ehe mofo kya maakowe. Mïrï maakowe ehe mï'dï mï kamba. Ma sösu dë, ëzë zë kora mandere mbara. ");
INSERT INTO mgc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kyedre 'ba vo karase, ehe biya vïdï mï magalesi akatɔ'bɔ yadannï zi yï nenye ëdï tïnyö. Mïrï waraga kazi zë, zi öndu ze mï Damasika, here zi ma kïrï vïdï ehe zi kika zë mï Yerusalema zi yaza.” ");
INSERT INTO mgc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ko'do kölö maako aba, kaa kadra kutë, mëdï ku zi tɔkɔ kara Damasika, bikanyi ta komorïyë, kandi ayanyi bi toko ra ma. ");
INSERT INTO mgc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ma lëpï dakaŋo ehe mowo gu ëdï ko'jo wa, ‘Sawolo, Sawolo, kö'du a'di ëdï yaza ma?’” ");
INSERT INTO mgc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ma ya'ba dɔ mo henye, ‘Yï 'bënï ëyï, Yere?’ Yere aya'ba dɔ mo iya henye, ‘Ma Yësu 'ba Nazereta! Ma ra, ëdï ayaza ne.’ ");
INSERT INTO mgc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vïdï ma ëdïnnï tï'bë ma aba, ongɔnnï bikanyi ne, mora owonnï gu dë.” ");
INSERT INTO mgc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ma ko'jo kö'du henye, ‘Yere, omba a'di zi ma ko'dɔ?’ Here mo ayada zi ma iya henye, ‘Ënyï rïyë ehe ï'bë mï Damasika. Ëzë ɔkɔ ani, a'di akayada zi yï ko'dɔ.’ ");
INSERT INTO mgc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bikanyi kyedre ne ku ndra here mɔ'bɔ dë zi bi kongɔ. Oke ra ïrïnnï ma kala aba kika mï Damasika.” ");
INSERT INTO mgc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mï gawo kyedre nani, kora maako ëdï ru mo Ananiya, mo koma aba mï kö'du kï'dï 'ba Mosa, ehe Yude biya mati alimannï ani, ombannï mo laka. ");
INSERT INTO mgc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mo ayi zi ma, ehe iya henye, ‘Sawolo, öndu ma, yaanya aba akongɔ bi löhu!’ Kandi mɔ'bɔ bi kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Here Ananiyasi ayada zi ma iya henye, ‘Wïrï mati zutu 'beze amötunnï, inzi yï ku zi yɔlɔ wa mati mo omba o'dɔ rë nï ku. Mo inzi yï zi kongɔ Mo Mati Tïnyö, ehe zi gu mo kowo, ");
INSERT INTO mgc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ga kö'du zi tëdï na vo kiya 'ba wa mati ongɔ ehe owo. ");
INSERT INTO mgc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","A'di ra ëdï bi mo kisi? Ënyï rïyë! Ïrï bapatisi zi kö'du kyënyë 'bëyï kaka, mötu aba zi Yere.’” ");
INSERT INTO mgc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Tapëtï ma nenye ma'ba Yerusalema ehe mï'bë mï yëkëlu zi mötu. Ani mongɔ rayada ");
INSERT INTO mgc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","'ba Yere. Mo iya zi ma henye, ‘Kandi, ila Yerusalema! Vïdï ombannï dë kowo, wa mati ëdï akiya ga kö'du ma.’ ");
INSERT INTO mgc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ma ya'ba dɔ mo henye, ‘Yere, zë ayɔlɔnnï henye mï bi 'ba mötu kayo 'beze mïrï, ehe mu'bö vïdï mati ëdïnnï koma aba mï yï. ");
INSERT INTO mgc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ofo Setifano ga kö'du mo ame'do kö'du yï. Mɔrɔ ani, ehe hu kö'du kï'dï nduwë. Here mongɔ ga bɔngɔ 'ba kora mati ofonnï mo.’ ");
INSERT INTO mgc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mora Yere ayada zi ma tï'bë, ehe mo alömu zi kutu ma kɔwɔ zi tu'dë maakowe.” ");
INSERT INTO mgc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Vïdï kayo ne owonnï le Pawolo iya nenye. Here zë ayetonnï hë nnï gbögbö. “Ofowe kora nenye! Mo ɔ'bɔ dë zi lima.” ");
INSERT INTO mgc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Zë nduwë hë nnï gbögbö. Zë akɔhɔnnï bɔngɔ 'bënnï toko ehe u'dunnï durufu mï buluku. ");
INSERT INTO mgc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kyedre 'ba vo kyëlu mï turu 'ba Roma, ï'dï kö'du zi Pawolo koba bi 'ba vo kanye, ehe ku'bö so'da aba. Mo o'dɔ nenye zi yɔlɔ kö'du a'di vïdï ëdï hë nnï gbögbö da Pawolo. ");
INSERT INTO mgc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mati vo kanya ëdïnnï ku Pawolo kida zi ku'bö, mo ako'jo ha vo da kanye ma ëdï tɔrɔ ani, “Ëdï na dangölö zi ku'bö vïdï 'ba Roma dagba ayɔnzɔ mo dë komo vurë?” ");
INSERT INTO mgc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mati vo da kanye owo nenye, mo ï'bë zi kyedre vo dë nï iya henye, “Ëdï a'di ko'dɔ? Kora nenye vïdï 'ba Roma ra!” ");
INSERT INTO mgc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Here, kyedre 'ba vo kyëlu ne ï'bë zi Pawolo ehe ako'jo hɔ mo, iya henye, “Ayada zi ma, yï vïdï 'ba Roma ra?” Pawolo aya'ba dɔ mo lëzë aba iya henye, “Ɔɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kyedre 'ba vo da kyëlu iya henye, “Mopi kɔhi kyɔ zi tayi vïdï 'ba Roma.” Mora Pawolo aya'ba dɔ mo iya henye, “O'jo ma vïdï 'ba Roma.” ");
INSERT INTO mgc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Zë mati ombannï zi hɔ mo ko'jo, ina rë nnï kɔwɔ kandi ta rɔ mo. Kyedre 'ba vo da kyëlu na bi dë nï na rakaga mati mo ayɔlɔ henye nï'dï Pawolo, nida vïdï 'ba Roma ku nyɔri aba. ");
INSERT INTO mgc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ko'do vere aba, kyedre 'ba da vo kyëlu omba ku zi yɔlɔ kö'du ma tïnyö, kö'du a'di Yude asusunnï Pawolo gɔ mo. Here mo inga nyɔri 'ba Pawolo 'de, ehe mo ï'dï kö'du zi kyedree 'ba vo karase ehe vo dagbe 'ba Yude biya zi rë nnï tɔtɔ. Here mo ika Pawolo loko ehe o'dɔ mo tɔrɔ komo zë. ");
INSERT INTO mgc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pawolo ongɔ bi mbïyï da gboko 'ba magalesi ehe iya henye, “Öndu me, zi ko'do ndenye, ma lïtu zi Wïrï di'di ŋbala aba.” ");
INSERT INTO mgc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Here Ananiya kyedre 'ba vo karase ï'dï kö'du zi kora mati ëdïnnï atɔrɔ kara, dakapa Pawolo zi hɔ mo kisa. ");
INSERT INTO mgc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pawolo opi komo nï zi kyedre vo karasa ehe iya henye, “Yï ta rë yï yaga ŋbala kaa yïku kanyi, mora mïyï ku na köndu kaa kalïlï. Wïrï aku'bö yï. Alima nani zi vurë ko'dɔ ra ma kö'du kï'dï 'ba Mosa aba. Mora mï kadra kölö ne, ï'dï kö'du zi kora nee, zi kowe kö'du kï'dï ma ku'bö.” ");
INSERT INTO mgc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kora mati ɔrɔnnï kara dakapa Pawolo ako'jonnï kö'du iyannï henye, “Ayɔlɔ dë, ëdï kyedre 'ba vo karase 'ba Wïrï ra lidi?” ");
INSERT INTO mgc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pawolo aya'ba dɔ mo iya henye, “Akɔ öndu me! Ma yɔlɔ dë mo kyedre 'ba vo karase ra. Wayöruwë ayada zi ze, anza dë zi me'do kyënyë kiya ra vïdï vo dagba 'be.” ");
INSERT INTO mgc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Mati Pawolo ongɔ kya 'ba kyedre maakowe Sadeke, ehe maakowe Farasiye, mo agbögbö hë nï iya henye, “Öndu me, ma Farasi, ehe wisi 'ba Farasi ra. Ma kinye bi 'ba vurë ne, ga kö'du moma yöku atënyï na dïdï.” ");
INSERT INTO mgc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kandi mati Pawolo iya nenye, Farasiye ehe Sadekee ayetonnï mï ha wasa kyedre, ehe vo dagbe 'ba Yude ayetonnï kapa maako. ");
INSERT INTO mgc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadekee omannï dë mï malayike, lawowe, mandere yöku atënyï na dïdï. Mora Farasiye omannï biya mï wa nenyee, ");
INSERT INTO mgc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ehe here ani ha gbögbö kayo ëdï. Kya 'ba vo komoyandi 'ba kö'du kï'dï 'ba Mosa mati ëdïnnï Farasiye, zë ayinnï na kamo ehe iyannï henye, “Di'ja waako dë na kyënyë ra kora nenye. A'di ra ëzë lawo mandere malayika tïnyö ame'do ku zi mo.” ");
INSERT INTO mgc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ha wasa ne ayi ku na kyigɔ, kyedre 'ba vo da kanye ëdï na tere henye, vïdï akizannï Pawolo na nzoyi. Here mo ï'dï kö'du zi vo kanye zi tï'bë loko ehe Pawolo yɔmɔ. Here, zë obannï mo hulëhu bi lima 'ba vo kanye. ");
INSERT INTO mgc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yɔndɔ nani aba, Yere ɔrɔ dakapa Pawolo iya henye, “Akyigɔ rë yï! Te kaa mati ayada kö'du ma zi maakowe mï Yerusalema, akayada kö'du ma kpa mï Roma.” ");
INSERT INTO mgc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mï damïndö vere, Yuda maakowe atɔtɔ rë nnï ga bi kölö ehe alömunnï, iyannï henye, nonyonnï wa mandere uwënnï wa maako dë, le ëzë nofonnï Pawolo ku. ");
INSERT INTO mgc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Zë mati o'dɔnnï yeṛe ne ndra ta da 'butësowɔ. ");
INSERT INTO mgc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Here kya zë maakowe ï'bënnï zi kyedree 'ba vo karase ehe vo dagbe 'ba Yude ehe iyannï henye, “Da lömu Wïrï henye, donyo wa maako dë, le ëzë dofo Pawolo ku. ");
INSERT INTO mgc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","E ehe biya magalesi ï'bëë zi kyedre 'ba vo da kanye ehe rako'ba henye ombe yɔlɔ ndra vurë ma iya ra Pawolo. Ako'jowe kö'du mo zi kika komo vurë 'be. Here, da tëdï bi mo kisi, zi mo kofo gba kazi mo tɔkɔ ani.” ");
INSERT INTO mgc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mati wisi 'ba ëmï 'ba Pawolo owo kö'du 'ba yeṛe ne, mo ï'bë bi lima 'ba vo kanye ehe ayada zi Pawolo. ");
INSERT INTO mgc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Here Pawolo iya zi kyedre 'ba vo da kanya lamikölö maako henye, “Oba kora ɔbi nenye zi kyedre 'ba vo da kanye. Mo ëdï kö'du aba zi yada zi mo.” ");
INSERT INTO mgc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kyedre 'ba vo da kanya lami ne oba mo zi kyedre 'ba vo da kanye iya henye, “Maboso ru mo Pawolo ako'jo ma zi kika kora ɔbi nenye zi yï, ga kö'du mo ëdï kö'du aba zi yada zi yï.” ");
INSERT INTO mgc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kyedre 'ba vo kyëlu oba kora ɔbi ne dakapa ehe ako'jo hɔ mo na liwo, “A'di ra omba yada zi ma?” ");
INSERT INTO mgc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mo aya'ba dɔ mo iya henye, “Vïdï kora maakowe ëdïnnï kö'du sösu aba zi hë yï ko'jo zi kika Pawolo akaŋo zi magalesi 'ba Yude mïndö aba. Zë akiyannï, nombannï zi kö'du yɔlɔ ndra kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mora akɔ, o'dɔ wa ma zë iyannï ne dë. Ndra ta da kora 'butësowɔ ombannï lɔdrɔ da Pawolo. Zë o'dɔnnï lömu anza dë zi konyo mandere kuwë wa maako le ëzë nofonnï Pawolo ku. Yaanya aba ëdïnnï bi mo kisi zi kowo a'di ra akiya.” ");
INSERT INTO mgc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kyedre 'ba vo kyëlu utu kora ɔbi ne 'de tapëtï mo iya zi mo henye, “Ila vïdï kölö maako dë yɔlɔ kö'du mati ayada zi ma nenye.” ");
INSERT INTO mgc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kyedre 'ba vo da kanye ako'jo kyedre 'ba vo kanya lamirïyö ehe ayada zi zë, “Kadra madɔmosowɔ yɔndɔ aba, lamirïyö vo kanya ma ndï mëdïnnï nzɔ zi tï'bë zi Kasariya. Oba 'butëmadɔmorïyö kora da akakya ehe lamirïyö vo kanya wehe aba. ");
INSERT INTO mgc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Akɔ'je akakya nzɔ kö'du Pawolo ehe ayɔle laka mo mɔkɔ kazi kö'du maako kpuru zi vo dakaŋo Felekisi.” ");
INSERT INTO mgc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kyedre 'ba vo da kyëlu ne ayöru waraga iya henye, ");
INSERT INTO mgc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Wamëtë kazi Kulidasi Layisisi, zi kyedre vo dakaŋo Felekisi. ");
INSERT INTO mgc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yuda maakowe ïrïnnï kora nenye ehe kara zi mo kofo. Mora mati ma yɔlɔ mo vïdï 'ba Roma, moba vo kanya maakowe ehe ayɔmɔnnï mo. ");
INSERT INTO mgc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Momba zi yɔlɔ kö'du a'di ra ombannï mo dë. Here mika mo komo magalesi ");
INSERT INTO mgc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ehe ma yɔlɔ henye nje kö'du kï'dï 'ba yënï 'bëzë. Kora nenye o'dɔ kö'du kyënyë maako dë zi mo koli mandere kï'dï mo mï kamba. ");
INSERT INTO mgc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kandi mati ma yɔlɔ ëdï yeṛe ko'dɔ rɔ mo, mutu mo zi yï ehe ma yada vo mo susuwë zi kika kö'du ko'dɔ kyënyë 'bɔmo ne mï bi vurë 'bëyï.” ");
INSERT INTO mgc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Vo kanya oronnï kö'du kï'dï 'ba kyedre 'ba vo da kanye ehe mï yɔndɔ kölö nani, zë obannï Pawolo zi gawo kyedre 'ba Anitipatrisi. ");
INSERT INTO mgc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mï ko'do vere, vo kanye ndï aba, a'bannï bi lima 'ba vo kanye, ehe ilannï vo kanye mati da akakya nduwë tï'bë mo aba dagba. ");
INSERT INTO mgc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Mati zë ayinnï zi Kasariya, zë ï'dïnnï waraga ne zi vo dakaŋo ehe ï'dïnnï Pawolo zi mo. ");
INSERT INTO mgc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Vo dakaŋo ako'jo waraga ne. Here mo ako'jo ha Pawolo, dakaŋo vala ra mo ta 'dɔmo. Mati mo ayɔlɔ mo ta Silisiya, ");
INSERT INTO mgc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","vo dakaŋo iya henye, “Ma kowo kö'du 'bëyï ne, ëzë vïdï ne ayinnï, ikannï kö'du kyënyë mati ombannï yï dë gɔ mo ne ku.” Tapëtï mo iya kö'du nenye, mo ï'dï kö'du zi Pawolo sesi na maboso mï liŋɔ 'ba Yere Heroda. ");
INSERT INTO mgc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Yaa ko'do muyï aba, Ananiya kyedre 'ba vo karase, vo dagba 'bënnï ëtï ehe vo me'do mï bi 'ba vurë kö'du vïdï maakowe ru mo Teretalusi, ï'bënnï zi Felekisi zi yada kö'du kyënyë ma Pawolo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Here, ako'jo Pawolo loko ehe Teretalusi ayeto me'do, “Kyedre Felekisi, ika vïdï 'bezee mï rakyëyï konda, ehe ga kö'du ko'dɔ 'bëyï, ga kö'du dakaŋo 'beze, ëdï ndra na laka. ");
INSERT INTO mgc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ze biya 'duwï dëdï na rakyenyi ga kö'du wa mati o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Momba dë zi yï yaza, mora akɔ, ëdï na mïkuku ze aba, ehe owo ha ma nje kadra tisi aba. ");
INSERT INTO mgc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Di'ja kora nenye na vo mïkile, mo ayeto kö'du kyënyë ko'dɔ mï kutë Yude ehe biya tëmï damöku ne. Mo ëdï kpa na vo dagbe 'ba gboko maako ako'jo Nazarenesi. ");
INSERT INTO mgc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Mati mo ayɔnzɔ zi komokaya kika ra yëkëlu ne, dïrï ze mo. ");
INSERT INTO mgc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ëzë ako'jo hɔ mo, aki'ja na bi dë yï henye, me'do 'beze ne tïnyö, akayɔlɔ biya kazi mo wa mati da susu mo kö'du mo.” ");
INSERT INTO mgc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yuda kayo ame'donnï rïyë ehe ombannï da kö'du mati Teretalusi iya. ");
INSERT INTO mgc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Vo dakaŋo Felekisi o'dɔ kala zi Pawolo zi me'do, ehe mo ayeto, kiya henye, “Ma yɔlɔ ku, o'dɔ vurë 'ba vïdï dakaŋo nenye ku kɔɔ lakyi aba, ehe ma rakyenyi aba, zi ga ma gaga komo vurë 'bëyï. ");
INSERT INTO mgc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Anza dë ndra ta da ko'do 'butë dɔmorïyö mati alaga, mï'bë zi mötu mï Yerusalema. Ako'jo ha vïdï maako ëzë anza dë tïnyö. ");
INSERT INTO mgc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Gba Yude i'jannï ma dë he ze wasa vïdï maako aba mï yëkëlu, mo'dɔ kö'du kyënyë maako dë mï bi 'ba mötuwë mandere mï gawo kyedre. ");
INSERT INTO mgc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gërï maako anza dë ani, zë atɔ'bɔnnï yada kö'du kyënyë nenyee, zë yaanya aba ëdïnnï kika ra ma. ");
INSERT INTO mgc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Momba dɔ mo nenye zi ye, mëdï mötu Wïrï 'ba zutu 'bezee. Gërï nani kïrï aba mati zë iyannï henye anza dë tïnyö. Mora moma kpa mï wa biya mati ayöru mï kö'du kï'dï 'ba Mosa ehe mï wayöruwë 'ba Nëbïyë. ");
INSERT INTO mgc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mëdï kpa kö'du sösu aba mï Wïrï kaa vïdï nenyee, henye Wïrï akïnjë vïdï biya tëmï koli, ma laka mandere ma kyënyë. ");
INSERT INTO mgc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Here ga kö'du tïnyö ma yɔlɔ ku, mï'dï ra ma zi tëdï kö'du sösu ma di'di ŋbala aba, mï wa mati mo'dɔ zi Wïrï mandere zi vïdï. ");
INSERT INTO mgc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Tapëtï tëdï 'bama na kɔwɔ ta ra Yerusalema kɔɔ lakyi aba, mï'bë ani zi kya 'ba kɔhi kïrï zi vïdï 'bame ehe zi wakumuwë kï'dï. ");
INSERT INTO mgc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nenye ëdï wa mati mëdï ko'dɔ, mati zë i'jannï ma mï yëkëlu, ma na ŋbala mï kö'du kï'dï 'ba Mosa. Manza dë vïdï kayo aba, ehe kö'du ko'dɔ kyënyë maako anza dë. ");
INSERT INTO mgc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yuda maakowe tëmï Asiya ëdïnnï mï kadra nani, ehe ëzë, zë ëdïnnï kö'du maako aba zi kiya ra ma, na kyënyë, zë atëdïnnï kinye yaanya aba. ");
INSERT INTO mgc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mandere ako'jo hë zë, zë mati ëdïnnï kinye ne. Zë akatɔ'bɔ yadannï zi yï henye, zë i'jannï ma dë kö'du kyënyë maako aba, mati magalesi o'dɔnnï vurë le ra ma. ");
INSERT INTO mgc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nje kö'du kyënyë kölö mati akikannï ra ma ëdï, ma gbögbö ha ma yaga bi 'ba vurë, mati miya henye, ‘Ma ndenye bi 'ba vurë, ga kö'du moma henye, yöku atënyï na dïdï!’” ");
INSERT INTO mgc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felekisi ayɔlɔ Gërï 'ba Yere ndra. Mï ndundu mo, mo isi ha vurë, ehe iya henye, “Ma ko'dɔ ndundu vurë 'bama tapëtï tɔkɔ 'ba Layisisi, kyedre 'ba vo kyëluwë.” ");
INSERT INTO mgc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mo ï'dï kö'du zi vo da kanye zi Pawolo sesi na maboso, mora mo misi gɔ mo dë, mandere zi yata aboka mowe ta bi mo kɔnyi. ");
INSERT INTO mgc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ko'do maakowe aba yaa, Felekisi ayinnï mbara 'bënï Dorosila aba. Dorosila Yuda ra. Felekisi utu lïtu kö'du Pawolo, ehe mo oze mbili nï mati Pawolo ëdï ame'do zi mo, zi tëdï koma aba mï Yësu Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mora Felekisi na tere, mati Pawolo ayeto me'do zi mo, zi kö'du laka ko'dɔ, asesi rë yï kazi kö'du kyënyë, ehe vurë ma ëdï atayi. Here mo iya zi Pawolo henye, “Ɔ'bɔ ku, yaanya aba. Ï'bë. Mora ëzë mëdï kadra aba, ma kutu lïtu kö'du yï.” ");
INSERT INTO mgc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tapëtï ma nenye, Felekisi 'duwï lïtu kutu kö'du Pawolo ehe me'do mo aba, ga kö'du mo asösu 'bënï Pawolo akogo komo nï. ");
INSERT INTO mgc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kɔɔ rïyö aba, Porosiyasi Fesitɔsi ayi na vo dakaŋo tapëtï Felekisi. Mora Felekisi omba zi ko'dɔ vo dagbe 'ba Yude na rakyenyi, mo asesi Pawolo mï kamba. ");
INSERT INTO mgc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ko'do wota aba tapëtï Fesitɔsi ayi mï dakaŋo, mo ï'bë ta Kasariya zi Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ani kyedree 'ba vo karase ehe vo dagba 'ba Yude maakowe ayadannï zi mo kö'du kyënyë mati zë ongɔnnï Pawolo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Zë ako'jonnï ha Fesitɔsi ëzë mo akomba zi Pawolo kika Yerusalema. Zë alenzennï mo zi ko'dɔ nenye ga kö'du zë ëdïnnï yeṛe ko'dɔ zi lɔdrɔ da Pawolo ehe mo kofo ta da gërï. ");
INSERT INTO mgc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mora Fesitɔsi ayada zi zë, “Akasesi Pawolo mï Kasariya, ehe kandi mëdï atï'bë ani na bi da ma. ");
INSERT INTO mgc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ëzë mo o'dɔ kö'du kyënyë maako, vo dagba 'be mï'bënnï ma aba ehe mikannï kö'du kyënyë mati mo o'dɔ ne ani.” ");
INSERT INTO mgc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitɔsi alima mï Yerusalema ko'do madɔmowota mandere ko'do 'butë ndra gba kazi tï'bë Kasariya. Here ko'do vere aba, mo alima bi 'ba vurë, ehe ika Pawolo bi 'ba vurë. ");
INSERT INTO mgc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kandi mati Pawolo ayi loko, vo dagbe ta Yerusalema ɔrɔnnï toko rɔ mo ehe iyannï henye, i'ja mo kö'du kyënyë kayo maako aba. Mora zë ɔ'bɔnnï dë zi yada kö'du ne ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Here Pawolo ame'do gë nï gaga aba, “Mo'dɔ kö'du kyënyë maako dë ra kö'du kï'dï 'ba Yude ehe mo'dɔ kö'du kyënyë ako kpa dë ra yëkëlu mandere ra Yere 'ba Roma.” ");
INSERT INTO mgc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fesitɔsi omba zi vo dagbe ko'dɔ na rakyenyi. Here mo ako'jo ha Pawolo iya henye, “Omba ku zi tï'bë Yerusalema, ehe zi ma vurë 'bëyï kiya ga kö'du nenyee?” ");
INSERT INTO mgc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pawolo aya'ba iya henye, “Ma mëdï mï bi 'ba vurë 'ba Yere 'ba Roma, ehe nani bi ma akikye vurë ra ma. Ayɔlɔ na laka mo'dɔ kö'du kyënyë ako dë zi Yude. ");
INSERT INTO mgc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ëzë mo'dɔ kö'du maako na kyënyë zi ma koli hɔ mo, mɔ'bɔ dë kiya henye, momba dë zi koli. Mora mo'dɔ kö'du kyënyë maako dë, ehe vïdï maako anza dangölö aba zi ma kï'dï zi vïdï nenyee. Yaanya aba ma ko'jo kö'du zi Yere 'ba Roma ra zi vurë 'bama kiya.” ");
INSERT INTO mgc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Tapëtï Fesitɔsi ame'do vo magalesi 'bënï ëtï, mo ayada zi Pawolo iya henye, “Ako'jo kö'du zi Yere 'ba Roma ra vurë 'bëyï kiya, ehe zi Yere 'ba Roma akatï'bë!” ");
INSERT INTO mgc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ko'do maako aba yaa, Yere Agiriba ehe Berenisi ayinnï Kasariya na yingɔ 'ba Fesitɔsi. ");
INSERT INTO mgc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Alimannï ani ko'do lakyi aba, mati Fesitɔsi ayada zi yere kö'du 'ba Pawolo, mo iya henye, “Felekisi ila kora maako kinye mï kamba, ");
INSERT INTO mgc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ehe mati mï'bë Yerusalema, kyedre 'ba vo karase ehe vo dagbe 'ba Yude ayinnï ehe ayadannï zi ma kö'du kyënyë ko'dɔ 'bɔmo, ehe ako'jonnï ha ma zi vurë 'bɔmo kikye. ");
INSERT INTO mgc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ma yada zi zë, anza dë mï dalëtï 'ba Roma zi vïdï kora kï'dï zi vïdï mati ikannï kö'du kyënyë rɔ mo, gba kazi mo i'ja gërï maako dë zi gë nï gaga. ");
INSERT INTO mgc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Here mati zë ayinnï kinye ma aba, ma yaŋa kadra dë. Mï ko'do vere ne, mïrï bi lima 'bama da kyïtï 'ba vurë, ehe mï'dï kö'du zi mo kika. ");
INSERT INTO mgc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mora mati kora nee ɔrɔnnï rïyë, zi kö'du kyënyë 'bɔmo kiya, zë asusunnï mo ga kö'du kyënyë ma anza dë mï kö'du sösu 'bama. ");
INSERT INTO mgc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Zë awasa hë nnï mo aba kö'du koma yënï 'bënnï ehe kora mati oli ru mo Yësu, Pawolo iya mo ëdï na dïdï. ");
INSERT INTO mgc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ma yɔlɔ dë hala zi vurë 'bɔmo kiya tïnyö ga kö'du nenye biya, ma ko'jo ha Pawolo ëzë mo omba ku zi tï'bë Yerusalema, ehe zi vurë ko'dɔ rɔ mo ani. ");
INSERT INTO mgc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mora Pawolo ako'jo kö'du zi sesinï mï kamba le Yere 'ba Roma ra ako'dɔ kö'du ma nomba. Here, mï'dï kö'du zi mo sesi kinye le ma kutu mo zi Yere 'ba Roma.” ");
INSERT INTO mgc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agiriba iya zi Fesitɔsi henye, “Momba kpa zi kowo a'di kora nenye akiya.” Fesitɔsi aya'ba dɔ mo iya henye, “Akowo hɔ mo mïndö aba.” ");
INSERT INTO mgc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ko'do ma vere aba, Agiriba ehe Berenisi aba o'dɔnnï wayada kyedre mati zë ayinnï mï loko 'ba ratɔtɔ. Vo kyëluwë 'ba anjiya ehe vïdï ma dagbe 'ba gawo ëdïnnï kpa ani. Fesitɔsi ï'dï kö'du zi Pawolo kika loko ");
INSERT INTO mgc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ehe iya henye, “Yere Agiriba ehe yinge, onge bi da kora nenye. Yude biya ta Yerusalema ehe Kasariya ayinnï zi ma, iyannï henye, nombannï zi kofo mo. ");
INSERT INTO mgc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mi'ja kö'du kyënyë maako zi mo kofo dë. Mora ga kö'du mo ako'jo ku zi Yere 'ba Roma ra zi vurë 'bënï ko'dɔ, momba ku zi mo kutu Roma. ");
INSERT INTO mgc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ma kayöru kö'du tïnyö maakowe ga kö'du kora nenye zi Yere 'ba Roma. Here, mika mo komo we biya, mora gogo komo yï, Yere Agiriba. Tapëtï me'do 'beze ga kö'du 'bɔmo, ehe mëdï wa maako aba zi yöru. ");
INSERT INTO mgc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Anza dë na laka zi maboso kutu zi Yere 'ba Roma gba kazi yɔlɔ kö'du kyënyë mati mo o'dɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiriba iya zi Pawolo henye, “Yï yaanya aba ame'do ga kö'du yï.” Pawolo iza ga kala nï yaga ehe iya nenye, ");
INSERT INTO mgc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Yere Agiriba, ma na rakyenyi ga kö'du nenye, zi me'do 'bama kiya komo yï ndenye tëmï kö'du biya, mati Yude asusunnï ma gɔ mo. ");
INSERT INTO mgc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ayɔlɔ na kayo kö'du dalëtï 'ba yënï 'beze ehe koma mati inye mï ze. Here ma ko'jo hë yï zi kowo mïkuku aba zi ma. ");
INSERT INTO mgc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Yude biya ayɔlɔnnï ma ku kyere ma gba na wisi ɔbi. Zë ayɔlɔnnï kyïnë 'ba lima a'di mëdï mo aba, mï dakaŋo 'bama ehe mï Yerusalema. ");
INSERT INTO mgc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ehe ëzë zë ombannï, zë atɔ'bɔnnï yada zi yï ma Farasi ra, mï gboko mati oro kö'du kï'dï ndra ta da maako. ");
INSERT INTO mgc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yaanya aba, mëdï ku komo vurë ga kö'du moma mï lömu mati Wïrï o'dɔ kyere zi vïdï 'bezee. ");
INSERT INTO mgc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kadra ehe yɔndɔ 'butë dɔmorïyö tu'dë 'beze alïtunnï zi Wïrï, kisi bi lömu ya'da ɔmo. Yere Agiriba, ga kö'du sösu nenye, kya 'ba vo dagba 'beze maakowe ikannï wasusu maako ra ma. ");
INSERT INTO mgc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kö'du a'di e biya da jiji aba, Wïrï ïnjë yöku zi dïdï?” ");
INSERT INTO mgc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ma kadra maako aba, ma sösu henye, ma ko'dɔ wa maako biya ma tɔ'bɔ, zi wehe ko'dɔ ra Yësu 'ba Nazereta. ");
INSERT INTO mgc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mo'dɔ nenye dagba mï Yerusalema, ehe kalakonda 'ba kyedree 'ba vo karase mï'dï vïdï 'ba Wïrï kayo mï kamba. Momba da kö'du zi zë kofo. ");
INSERT INTO mgc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mëdï zë yaza 'duwï mï bi 'ba mötu 'beze, ehe ma yɔnzɔ ko'dɔ zë, zi kö'du kyënyë kiya ra Wïrï. Tïnyö, ma na kamo zë ëtï, henye, mï'bë zë koma mï gawo kyedre 'ba vo leze maakowe.” ");
INSERT INTO mgc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Yere Agiriba, kadra maako aba, mëdï da gërï 'bama zi Damasika kalakonda ehe dangölö aba kazi kyedree 'ba vo karase. ");
INSERT INTO mgc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaa kadra kutë, mongɔ bikanyi, anyi ndra ta da kadra. Ayanyi bi da ma ta komorïyë ehe da vïdï biya mati ëdïnnï tï'bë ma aba. ");
INSERT INTO mgc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ze biya da lëpï dakaŋo. Here mowo gu iya zi ma ha 'ba Hïbïru aba henye, ‘Sawolo, Sawolo, kö'du a'di ëdï yaza ma? Ëdï na lumë zi wehe ko'dɔ ma aba!’” ");
INSERT INTO mgc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ma ko'jo kö'du henye, ‘Yere, yï 'bëyï ëyï ra?’” “Yere aya'ba dɔ mo iya henye, ‘Ma Yësu ra! Ma ra ëdï ayaza. ");
INSERT INTO mgc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yaanya aba ɔrɔ rïyë da ndï yï. Ma yada ra ma zi yï, ga kö'du minzi yï ku zi tëdï na vo lïtu ama. Ayada zi maakowe wa ma ayɔlɔ kö'du ma ehe a'di ma kayada zi yï yaa.’ ");
INSERT INTO mgc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yere iya kpa henye, ‘Ma kagaga gë yï kazi vïdï 'ba Yude ehe kazi tu'dë maakowe mati mëdï yï kutu zi zë, ");
INSERT INTO mgc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","zi komo zë yëhu here zi dë nnï kotɔ tëmï biköndu zi bikanyi ehe tëmï kyigɔ 'ba Satani zi Wïrï. Here akila kö'du kyënyë 'bëzë ehe koma mï ma, zë ra vïdï laka ma Wïrï inzi.’” ");
INSERT INTO mgc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Yere Agiriba, moro rayada mati ta komorïyë zi ma nenye. ");
INSERT INTO mgc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Dagba mo ma yëtï kö'du zi vïdï mï Damasika, ehe here mï'bë zi Yerusalema, ehe biya mï Yudiya. Ndundu mo, mï'bë zi tu'dë maakowe ehe miya henye, ‘Ɔre ta bi kö'du kyënyë ko'dɔ, ehe otɔ de zi Wïrï! Here ayada wa ma o'de tëmï gërï lima 'be.’ ");
INSERT INTO mgc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ga kö'du nenye ra kora maakowe ïrïnnï ma mï yëkëlu ehe ayɔnzɔnnï zi ma kofo. ");
INSERT INTO mgc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mora mï kadra nenye biya Wïrï akɔnyi ma, ehe ma yëtï kö'du 'dö zi vo wadakayowe ehe zi vo leriye. Ma yada zi zë nje wa ma nëbïyë ehe Mosa iyannï ako'dɔ rë nï. ");
INSERT INTO mgc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ma yada zi zë hala Korisitɔ ne akayaza ehe atëdï vo dagba zi tënyï tëmï koli, here mo akika bikanyi zi vïdï 'bënïyë ehe zi tu'dë maakowe.” ");
INSERT INTO mgc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Gba kazi Pawolo inde gaga gë nï, Fesitɔsi ambere, “Pawolo! Yï vo lökyï ra. Kö'du yɔlɔ kyedre 'bëyï ne ëdï ku yï ko'dɔ na lökyï.” ");
INSERT INTO mgc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mora Pawolo aya'ba dɔ mo iya henye, “Kyedre, Fesitɔsi, manza dë vo lökyï. Wa ma, mëdï akiya, ëdï tïnyö, ehe me'do laka ra. ");
INSERT INTO mgc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Yere Agiriba, ma tɔ'bɔ me'do zi yï biya kazi tere ga kö'du ayɔlɔ kö'du nenyee ku. Ma yɔlɔ ku tïnyö, Yere Agiriba, ayɔlɔ zë ku biya na kölö kölö ga kö'du wa nenye o'dɔ rë nï dë na koho na kɔwɔ mï ga bi golo'bɔ maako.” ");
INSERT INTO mgc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Pawolo iya zi Yere Agiriba henye, “Oma ku mï nëbïyë? Ma yɔlɔ oma ku.” ");
INSERT INTO mgc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiriba iya zi Pawolo henye, “Mï kadra kodo nenye, asösu 'bëyï ako'dɔ ma Korisitɔ 'ba?” ");
INSERT INTO mgc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pawolo aya'ba dɔ mo iya henye, “Ëzë ïrï kadra kodo mandere kadra konda, ma sösu yï ehe vïdï biya mati owonnï ma ndenye atëdïnnï kaa ma kazi nyɔri nenyee.” ");
INSERT INTO mgc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Here, Yere Agiriba, vo dakaŋo Fesitɔsi, Berenisi ehe vïdï biya maakowe zë ëtï, ënyïnnï rïyë. ");
INSERT INTO mgc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mora gba zë ï'bënnï dë, zë iyannï henye, “Kora nenye, i'ja mo dë kö'du kyënyë maako aba. Anza dë laka zi mo koli mandere mo kï'dï mï kamba.” ");
INSERT INTO mgc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiriba ayada zi Fesitɔsi henye, “Kora nenye ɔ'bɔ zi kila na dangölö, ëzë mo ako'jo kö'du dë zi Yere 'ba Roma ra zi vurë 'bënï kiya.” ");
INSERT INTO mgc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Mati ɔkɔ ku kadra 'beze zi ze tï'bë Italiya, vo da kanye mï turu 'ba Roma, Juliyasi, mo vo da kanya lamikölö 'ba Yere 'ba Roma. Ï'dï mo zi ga Pawolo kongɔ ehe maboso maakowe ëtï. ");
INSERT INTO mgc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Dï'bë ze yaga baburu 'ba Dramatiyumu, mati ku nzɔ zi tï'bë bi tɔrɔ 'ba baburu maakowe, na ga konda ta ha föfö 'ba Asiya. Arisitarisi tëmï Tasalanika mï Mesedɔniya, ï'bë ze aba mï baburu. ");
INSERT INTO mgc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mï ko'do vere aba, dɔkɔ dagötï 'ba Sidoni. Juliyasi kö'du ko'dɔ 'bɔmo na laka zi Pawolo. Mo ila mo kpa tï'bë oka nïyë kongɔ, here zë ɔ'bɔnnï kï'dï zi mo wa ma mo omba. ");
INSERT INTO mgc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mati dila Sidoni ku, buluku ëdï zɔ luku kï'dï zi ze, ehe dï'bë ze kara zi rutu 'ba Seyipurusu zi tɔmɔ kazi buluku. ");
INSERT INTO mgc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Here dï'bë ze dambaro 'ba Silisiya ehe Pambaliya le dayi ze, zi bi tɔrɔ 'ba baburu 'ba Mayira mï Lasiya. ");
INSERT INTO mgc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ani vo kyëlu ne i'ja baburu ta Alikazenderiya mati ëdï atï'bë Italiya. Mo ï'dï kö'du zi ze tï'bë mï baburu nani. ");
INSERT INTO mgc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Dï'bë ze na konda liyaa ko'do kayo aba ehe riti kyedre aba, tɔkɔ Sinodusi. Buluku ila ze dë zi tï'bë kɔwɔ mï bi nani, here dï'bë dopi Salamona, bi ma rutu 'ba Keriti akagaga ge ze kazi buluku ");
INSERT INTO mgc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Dï'bë ze liyaa na konda ta ha föfö kyedre ehe ndundu mo aba dɔkɔ bi ma ako'jo Bitɔrɔ 'ba Wayɔmɔ, anza na kɔwɔ ta ra gawo 'ba Lasiya. ");
INSERT INTO mgc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yaanya aba da yaŋa kadra ku na kayo, ehe da lima na konda, le Ko'do Kyedre 'ba Wakila alaga. Here anza dë na laka zi ze tï'bë. Here Pawolo ame'do zi vïdï 'ba mï baburu, ");
INSERT INTO mgc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Kora nenyee, oze mbili ye zi ma. Ëzë dï'bë ze yaanya aba, baburu 'beze ehe söndu 'bɔmo akayaŋa rë nï na kyënyë, ehe vïdï kayo akoli.” ");
INSERT INTO mgc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mora Juliyasi oze mbili nï da me'do 'ba vo baburu kopi ehe vo kyeti mo, anza kö'du Pawolo. ");
INSERT INTO mgc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bitɔrɔ 'ba baburu anza dë na laka zi lima 'dɔmo tona aba. Ga kö'du nenye, vïdï kayo idannï kö'du henye, da yɔnzɔ ze, zi tï'bë na konda ta ha föfö kyedre zi Fenekisi. Fenekisi ëdï bitɔrɔ 'ba baburu ra mï Keriti mati ayëhu zi dambaro-damïrë ehe daaba-damïrë, ehe da tɔ'bɔ lima tona aba ani. ");
INSERT INTO mgc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Mati buluku liyaa ta dambaro ayeto luku, kora nee asösunnï zi mala 'bënnï ko'dɔ. Here zë otɔnnï mongɔ 'ba baburu, ehe dï'bë na konda kara ta dagötï 'ba Keriti. ");
INSERT INTO mgc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mora kandi buluku kyigɔ mati ako'jo “Daaba-humïrë” aluku zɔ kï'dï zi ze tëmï rutu. ");
INSERT INTO mgc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Buluku otra baburu, ehe dɔ'bɔ dë zi tï'bë zi mo. Here dila buluku baburu kïnjë. ");
INSERT INTO mgc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dï'bë ze na konda zi rutu tisi 'ba Kawuda kapa mati buluku anza. Ze riti kyedre aba zi ga töŋbö 'ba baburu kïrï. Mora ndundu mo aba di'ja ze bi 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Here vïdï otɔnnï töŋbö mï baburu ehe olonnï kɔ'di ŋbïrï toko ra baburu zi nda'ba ga bi kölö. Ga kö'du zë na tere, henye akotra yayi dagötï 'ba Seyiritisi, zë obannï bɔngɔ 'ba baburu akaŋo, ehe buluku ïnjë baburu na konda. ");
INSERT INTO mgc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Buluku ku na kyënyë, ko'do vere aba, zë u'dunnï kya söndu 'ba baburu maakowe yaga. ");
INSERT INTO mgc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mï ko'do ma wota kala nnï aba, zë u'dunnï kya 'ba wa 'ba baburu maakowe yaga. ");
INSERT INTO mgc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ko'do kayo aba, dɔ'bɔ dë kadra kongɔ mandere kyëluwë. Buluku kyigɔ zɔ nduwë luku, ehe ndundu mo aba, dila biya kö'du sösu 'ba zi tɔmɔ. ");
INSERT INTO mgc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kyere vïdï maako tëmï ze onyo wa maako dë ndï kadra konda aba, Pawolo ɔrɔ rïyë ehe ayada zi kora nenyee, “Ëzë owowe ha ma, da lime mï Keriti, wa 'be nenye ayaŋa rë nï dë ehe ölu kpa dë. ");
INSERT INTO mgc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mora yaanya aba, ma lenzee, ere dë ëdïyë rakyenyi aba ga kö'du akayɔme. Nje baburu ra atölu. ");
INSERT INTO mgc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ma 'bama zi Wïrï, ehe ma mötu mo. Yɔndɔ ma alaga ne, mo utu malayika ");
INSERT INTO mgc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","zi yada zi ma, iya henye, ‘Pawolo ere dë! Akatɔrɔ mï vurë komo Yere 'ba Roma. Ehe ga kö'du yï, Wïrï laka akayɔmɔ dïdï 'ba vïdï mï baburu biya.’ ");
INSERT INTO mgc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ëdïyë na rakyenyi. Ma yɔlɔ ku tïnyö henye, Wïrï ako'dɔ te wa ma mo alömu. ");
INSERT INTO mgc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mora buluku akadrɔnyi ze zi rutu maako, ehe baburu akayaŋa rë nï.” ");
INSERT INTO mgc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ko'do 'butë dɔmosowɔ ehe yɔndɔ, buluku 'ba wini kagba adrɔnyi ze toko ta ra Föfö Mediterina. Mora ëdï kaa mï kutë yɔndɔ, vïdï mati mï baburu ayɔlɔnnï ze ku kara dakaŋo aba. ");
INSERT INTO mgc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Zë ayerinnï, ehe i'jannï henye, wini ne ëdï mitiri 'butësowɔ na yöndu. Yaa zë ayerinnï löhu ehe i'jannï ëdï nje mitiri 'butëwota. ");
INSERT INTO mgc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Vïdï mï baburu na tere da kotra kya ṛï'dï maakowe, here zë izannï akaŋo mongɔ sowɔ ta kafo 'ba baburu. Here zë amötunnï kö'du bikanyi 'ba kadra. ");
INSERT INTO mgc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vïdï mati mï baburu ombannï zi taho. Here izannï töŋbö mï wini, o'ba rë nnï nëdïnnï kya 'ba mongɔ maakowe ra kiza akaŋo ta komo dagba 'ba baburu. ");
INSERT INTO mgc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mora Pawolo iya zi vo kyëlu Juliyasi ehe vo kanye henye, “Ëzë vïdï nenyee alimannï dë da baburu, anze dë gërï maako aba zi dïdï yë yɔmɔ.” ");
INSERT INTO mgc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Here, vo kanye ikyennï kɔ'di mati ïrï töŋbö 'ba tɔmɔ ne, ehe ila lëpï mï föfö. ");
INSERT INTO mgc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Gba kazi bikanyi 'ba kadra, Pawolo alenze vïdïyë zi wakonyo. Mo ayada zi zë iya henye, “Ko'do 'butë dɔmosowɔ aba ëdïyë kö'du sösu aba henye onyowe waako dë. ");
INSERT INTO mgc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ma lenzee zi wa maako konyo. Dïdï 'be ɔrɔ dɔ mo. O'de nenye ehe vïdï ma kölö maako tëmï yë aki'ja riti.” ");
INSERT INTO mgc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Tapëtï Pawolo iya nenye, mo oba nzoyi mangɔlɔ'bɔ ehe ï'dï öwö'dï zi Wïrï. Here ta da komo vïdï biya, mo owe mangɔlɔ'bɔ ne ehe onyo kya mo. ");
INSERT INTO mgc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Zë biya rakyenyi aba, ehe vïdï biya tëmï zë onyo wa maako. ");
INSERT INTO mgc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Vïdï ma ëdïnnï mï baburu ne, lamirïyö 'butëmadɔmorïyö dɔmomodaka, ");
INSERT INTO mgc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ehe tapëtï vïdï biya onyonnï wa ku, zë u'dunnï söndu 'ba wakonyo mï föfö zi baburu ko'dɔ na pëlë. ");
INSERT INTO mgc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Damïndö ayi, ehe vïdï ma mï baburu ne ongɔnnï föyï maako zë ayɔlɔnnï dë. Mora zë ongɔnnï yayi 'ba ha föfö. Here zë ombannï zi yɔnzɔ zi taho baburu aba dakaŋo da ha föfö. ");
INSERT INTO mgc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Zë ikyennï mongɔ nee ehe ila zë alëndï mï föfö. Mï kadra kölö ne zë ingannï kɔ'di mati ëdï gërï yada zi baburu ne. Tapëtï mo, zë ïnjënnï bɔngɔ ma dagba komo baburu ehe ila buluku ra zi baburu drɔnyi dagötï. ");
INSERT INTO mgc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mora aho dakaŋo otra rë nï ra lumu 'ba yayi 'ba ha föfö. Kapa baburu ma dagba ne alaka mï yayi, ehe kapa mo, ma hulëhu alowe na nzoyi kazi kyigɔ 'ba wini kagba. ");
INSERT INTO mgc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Vo kanye ombannï ku zi mabosowe kofo zi sesi zë ta bi tele ehe kazi ahonnï. ");
INSERT INTO mgc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mora kyedre vo kyëlu omba zi dïdï 'ba Pawolo yɔmɔ, ehe mo ila vo kanye dë zi mala ma zë ombannï zi ko'dɔ. Tapëtï mo, mo ï'dï kö'du vïdï biya mati atɔ'bɔ tele zi töfu mï wini ehe dagba zi dagötï. ");
INSERT INTO mgc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Here mo ayada zi maakowe mïrïnnï nzoyi kaga 'ba baburu. Ndundu mo aba, vïdï biya ɔkɔ dagötï kazi kö'du maako. ");
INSERT INTO mgc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Mati dayi ze dagötï, da yɔlɔ ze rutu ne ako'jo Malata. ");
INSERT INTO mgc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Vïdï bi naniye na aboka, ehe zë ïrïnnï ze kalakyedre aba wa'do drɔko, ga kö'du mïrë ëdï ata'di ehe bi na bikyëyï. ");
INSERT INTO mgc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Tapëtï Pawolo atɔtɔ dawanya yërï, ehe ï'dï da wa'do, bikyïtu o'dɔ wiri zi tele yaga ehe onyo kala mo. ");
INSERT INTO mgc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mati vïdï bi naniye ongɔnnï wiri ove rë nï ra kala Pawolo, iyannï zi oka ma kölö maako henye, “Kora nenye vo wakofo ra! Mo aluyï dë mï föfö, mora kö'du laka ko'dɔ akila mo dë zi lima.” ");
INSERT INTO mgc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pawolo akɔhɔ wiri ne mï wa'do ehe o'dɔ wa kyënyë maako dë. ");
INSERT INTO mgc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vïdï asesinnï sösu henye kala Pawolo ne atö'bu rïyë mandere kandi akalëpï brua. Alimannï mo kongɔ kadra konda aba, ehe mati kö'du ako o'dɔ rë nï dë zi mo, zë ofɔ kö'du sösu 'bënnï ehe iyannï henye, “Kora nenye, wïrï ra.” ");
INSERT INTO mgc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Vo dagba 'ba rutu ne ako'jo Pobïlïyö, ehe mo ëdï kaŋo maako aba ani na 'bënï. Mo ïrï ze kalakyedre aba liŋɔ 'bënï ko'do wota aba. ");
INSERT INTO mgc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","'Bu mo mï sora, na kɔɔ rakyïtu aba, ehe mïkɔɔ kïndrï aba. Pawolo ï'bë zi mo, ehe ï'dï kala nï dɔ mo, ehe akɔ'jɔ kora ne mötu aba. ");
INSERT INTO mgc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tapëtï kö'du nenye o'dɔ rë nï, vïdï biya da rutu ne ika vïdï 'bënnï 'ba rakɔɔ zi Pawolo, ehe akɔ'jɔ zë biya. ");
INSERT INTO mgc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Vïdï nee oronnï ze, ehe mati dï'bë, zë ï'dïnnï zi ze wa biya ma domba. ");
INSERT INTO mgc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Yehe wota aba yaa, dï'bë ze mï baburu mati alima mï Malata tona aba. Baburu ne ta Alikazenderiya mï Ezipeto, ehe ëdï na yɔlɔ henye, “Wïrï loŋa.” ");
INSERT INTO mgc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Dɔkɔ ze mï Seyirakusi da lima ze ani ko'do wota aba. ");
INSERT INTO mgc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ta karani, dï'bë ze zi Rahagïmu. Ko'do vere aba, buluku 'ba dambaro ayeto luku, ehe ko'do rïyö aba yaa, dɔkɔ ze Putali. ");
INSERT INTO mgc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ani di'ja ze öndu maakowe. Zë alenzennï ze zi lima rë nnï. Ko'do kölö 'ba gima aba yaa, dï'bë gawo kyedre 'ba Roma. ");
INSERT INTO mgc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kya öndu maakowe mï Roma owonnï kö'du ze, ehe ayinnï de ze kutrë Bi Wakogo 'ba Apiyusi ehe, Loko 'ba Yingɔ Wota. Mati Pawolo ongɔ zë, mo o'dɔ öwö'dï zi Wïrï rakyenyi kyedre aba. ");
INSERT INTO mgc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Dɔkɔ ze mï Roma, ehe ila Pawolo zi lima mï loko na bi dë nï, vo kanya aba kölö zi gɔ mo kongɔ. ");
INSERT INTO mgc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Tapëtï ko'do wota aba mati dɔkɔ ani, Pawolo ako'jo bi kölö kya 'ba vo dagbe 'ba Yude, ehe iya henye, “E öndu me, mo'dɔ waako dë na kyënyë zi vïdï 'bezee, ehe mo'dɔ waako kpa dë na kyënyë ra dalëtï 'ba zutu 'bezee. Mora mï Yerusalema ï'dï ma na maboso mï Roma. ");
INSERT INTO mgc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Zë ongɔnnï mï kö'du kyënyë ma asusu ma gɔ mo, ehe omba zi ma kinga na dangölö. Zë i'jannï mo'dɔ kö'du ako dë na kyënyë zi koli. ");
INSERT INTO mgc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Vo dagba 'ba Yude ombannï da kö'du ne dë, here ma ko'jo kö'du zi Yere 'ba Roma zi vurë 'bama kiya. Mora manza dë kö'du kyënyë maako aba zi kiya ra dakaŋo 'bama. ");
INSERT INTO mgc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ida ma nyɔri nenyee aba ga kö'du wa ma ze vïdï 'ba Yiserele domba zi rë nï ko'dɔ. Kö'du nenye ra ma ko'jowe kinye zi me'do ga kö'du wa ma domba ze nenye.” ");
INSERT INTO mgc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Vo dagbe aya'bannï dɔ mo iyannï henye, “Vïdï kölö maako tëmï Yudiya ayöru waraga dë zi ze ga kö'du yï. Ehe ma kölö tëmï zë ayi dë zi kö'du ko'dɔ 'bëyï yada mandere zi kö'du kyënyë maako kiya rë yï. ");
INSERT INTO mgc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mora domba ze zi kowo wa ma akiya. Da yɔlɔ ze ku henye, vïdï biya ta bi ne ombannï gboko kyïyï nenye dë.” ");
INSERT INTO mgc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Here, zë ï'dïnnï kadra 'ba ko'do zi Pawolo, watiti kyedre 'bëzë ayinnï mï kadra nani, bi mati Pawolo ëdï lima 'dɔmo. Ta damïndö le yɔndɔ aba, mo ayada zi zë kö'du kise 'ba Damöku 'ba Wïrï. Mo ïrï tëmï kö'du kï'dï 'ba Mosa ehe wayöruwë 'ba Nëbïyë zi yɔnzɔ zi kika zë zi Yësu. ");
INSERT INTO mgc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Kya vo dagba maakowe ombannï da kö'du ma Pawolo iya ne, mora maakowe ombannï dë. ");
INSERT INTO mgc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kyere zë ombannï da kö'du tëmï kutë nnï dë, ayetonnï tï'bë wënnï. Mora Pawolo iya henye, “Lawo Laka iya kö'du tïnyö mati mo utu nëbï Yisaya ");
INSERT INTO mgc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","zi yada zi zutu 'bezee, ‘Ï'bë zi vïdï nenyee ehe ayada zi zë, “Akowowe ehe akowowe, mora ayɔle dë. Akonge ehe akonge mora ayɔle dë.” ");
INSERT INTO mgc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ge biya ëdïyë di'di kyënyë aba. Mbili ye owo kö'du dë ehe komowe ayöfu ku. Zë ɔ'bɔnnï dë zi bi kongɔ, mandere kö'du kowo, mandere kö'du yɔlɔ. Ëzë atɔ'be, otɔ de zi ma, ehe ma kakɔ'je.’” ");
INSERT INTO mgc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Pawolo iya henye, “Momba zi ye yɔlɔ henye, Wïrï omba zi yɔmɔ tu'dëë, ehe zë akowonnï.” ");
INSERT INTO mgc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kɔɔ rïyö aba Pawolo alima mï loko kopi ehe ïrï vïdï biya ma ëdï tayi mo kongɔ ne kalakyedre aba. ");
INSERT INTO mgc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Mo ayëtï kö'du 'ba Damöku 'ba Wïrï kazi tere ehe yandi kö'du 'ba Yere Yësu Korisitɔ, ehe vïdï maako ayɔnzɔ dë zi mo yata.");
INSERT INTO mgc_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Kazi Yemisi, vo lïtu 'ba Wïrï ehe 'ba Yere Yësu Korisitɔ. Wamëtë biya zi vïdï a Wïrï mati opere rë nnï mï damöku ne biya. ");
INSERT INTO mgc_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Öndu ma'e ëmï ma ëtï, ëdï 'e na rakyenyi ëzë kyïnë 'ba kö'du yɔnzɔ biya ayi le gërï 'be'e, ");
INSERT INTO mgc_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ga kö'du ayɔlɔ 'e koma 'be'e yɔnzɔ, atëdï nduwë zi ye. ");
INSERT INTO mgc_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Ayɔlɔ 'e nduwë 'be'e, ako'dɔ 'e ndɔ na kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Mora ëzë vïdï maako tëmï 'e omba kö'du yɔlɔ, mo ma mötu zi Wïrï, mati akï'dï zi mo kyɔ ndra, kazi kö'du kyënyë ki'ja mï mo. ");
INSERT INTO mgc_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Mora ëzë mo amötu, mo moma kazi da jijiji. Vïdï mati dɔ mo jijiji ëdï kaa kagba 'ba wini mï ranga mati ëdï kope ehe buluk ïnjë. ");
INSERT INTO mgc_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Vïdï ma here ne'e ma asösunnï dë na kïrïnnï wa kazi Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Zë ɔrɔnnï dë da gërï kölö. ");
INSERT INTO mgc_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Öndu mati na vo leri, mo mëdï rakyenyi aba ga kö'du mo ëdï vo da wa kayo. ");
INSERT INTO mgc_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Mora vo da wa kayo, mo mëdï rakyenyi aba ga kö'du mo vo leri. Wa kayo 'bɔmo akalaga kaa döru 'ba wevo 'ba möku. ");
INSERT INTO mgc_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Kadra asi nzere, bi kyïtu o'bɔ weno ne, döru mo alëpï, ehe teme 'bɔmo ne ayaŋa gbɔ. Mï gërï kölö ne, vo wa kayo akayaŋa mï lɔ'ɔ 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Vo rakyenyiye ra mati alimannï koma aba hu wa yɔnzɔ. Ëzë zë ɔrɔnnï na kyigɔ mï wa yɔnzɔ, akïrïnnï biriti 'ba dïdï mati Wïrï alömu ku zi zë mati o'dɔnnï lɔvɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Ëzë ayɔnzɔ vïdï, mo miya dë henye, “Wa yɔnzɔ nenye ayi kazi Wïrï.” Ga kö'du Satani ɔ'bɔ yɔnzɔ Wïrï dë, ehe Wïrï ɔ'bɔ yɔnzɔ vïdï maako dë. ");
INSERT INTO mgc_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Mora ayɔnzɔ vïdïye, mati kö'du komba kyënyë 'bëzë otɔ zë ku 'de, ehe kuyï zë akpa kö'du ko'dɔ 'bëzë aba. ");
INSERT INTO mgc_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Here kö'du sösu kyënyë 'bëzë ne ɔmɔ, ehe o'jo kö'du kyënyë, ehe kö'du kyënyë, mati ovu ku kyedre, o'jo koli. ");
INSERT INTO mgc_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Öndu ma'e ëmï ma ëtï, mo'ba 'e dë. ");
INSERT INTO mgc_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Wa kï'dï biya laka ne, ehe wakï'dï biya ŋbala ne ayi ta komorïyë, ayi akaŋo kazi Wïrï 'Bu 'ba bi kanyi 'ba komorïyë. Mo ofɔ dë kaa galili. ");
INSERT INTO mgc_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Mï kö'du ko'dɔ ɔmo, mo ika ze zi tëdï nenye kpuru tëmï me'do 'ba tïnyö, here zi ze tëdï na vo dagba mï kutë wa ko'dɔ ɔmo'e biya. ");
INSERT INTO mgc_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Öndu ma'e ëmï ma ëtï, asösu 'e kö'du nenye. Vïdï biya më'dï kandi zi me'do kowo, mora liya zi me'do ehe liya zi tayi na kamo. ");
INSERT INTO mgc_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Kamo 'ba vïdï köndu o'dɔ kö'du laka dë, mati Wïrï omba. ");
INSERT INTO mgc_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Here ayaŋa 'e kö'du ko'dɔ ma kyënyë, ehe biya rasesi tëmï kö'du mati eme dë, mati kyɔ mï kutë 'e. Ra kï'dï zi Wïrï, ehe një me'do mati mo ïyï mï di'di 'e, mati atɔ'bɔ yɔmɔ 'e. ");
INSERT INTO mgc_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","O'ba'e re 'e dë nje mbiliye koze aba da me'do ɔmo. Ta gɔ mo, ï'dï 'e mï gɔ mo yɔnzɔ. ");
INSERT INTO mgc_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Vïdï mati oze mbili nï da me'do, mora ï'dï dë mï gɔ mo yɔnzɔ, ëdï kaa kora mati ongɔ bi mï ngana, ehe ongɔ rë nï kaa mati nëdï, ");
INSERT INTO mgc_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","ehe ï'bë gbɔ 'de, kandi atölu tëmï mo wa mati mo ongɔ ne alaya kaa a'da. ");
INSERT INTO mgc_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Mora kora mati ongɔ bi kara mï kö'du kï'dï ma tïnyö, mati inga vïdï na da ngölö, ehe mo nduwë mbili nï koze gɔ mo, anza dë nje kowo mo mora kpa ko'dɔ mo, Wïrï akï'dï ya'da zi mo mï wa mati mo o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ëzë vïdï mati ongɔ rë nï 'ba yënï, ehe asesi ndende nï dë, mo ëdï rë nï ko'ba, ehe yënï 'bɔmo ne o'dɔ waako dë. ");
INSERT INTO mgc_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Yënï mati Wïrï 'Bu ze omba ëdï ŋbala kazi ndɔndɔ ëdï henye: Zi ga gisiwala ehe ga mbara lu'bë kongɔ tëmï riti 'bëzë, ehe rasesi kazi wa kyënyë 'ba damöku ne. ");
INSERT INTO mgc_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Öndu ma'e ëmï ma ëtï, kaa vo koma'e mï Yere 'beze Yësu Korisitɔ, Yere 'ba bikanyi, o'dɔ 'e vïdï 'e dë mï gërï maako 'beri tara da laya 'bëzë ta yaga. ");
INSERT INTO mgc_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Kaa kora vo wa aba kyɔ usu ïnzï 'ba dahabo ehe bɔngɔ ma laka ayi mï ratɔtɔ 'be'e ehe kora vo leri mï bɔngɔ liza ayi kpa. ");
INSERT INTO mgc_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Ëzë, ayada wa tɔwɔ ndra zi kora mati usu rë nï na laka ehe iya, henye zi mo, “Alima da bi lima makaka nenye kinye. Mora iya zi kora vo leri henye, ɔrɔ nani, mandere alima kinye dakaŋo da ndï yï.” ");
INSERT INTO mgc_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","Here, o'dɔ 'e kö'du kyënyë 'ba rakinye ku mï kutë 'e. Ëdï 'e na vo vurë 'ba kö'du sösu 'ba Satani aba. ");
INSERT INTO mgc_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Owo'e te, öndu ma'e ëmï ëtï. Wïrï ïnzï vïdï leri 'ba damöku nenye, zi tëdï ndɔ koma aba ehe zi tëdï damöku mati mo alömu ku zi zë, mati o'dɔnnï lɔvɔ mo. ");
INSERT INTO mgc_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Mora alidi 'e vo leri. Anza dë vo wa aba kyɔ'e ra ëdïnnï 'e ko'dɔ na kyënyë kika mo komo vo vurë'e? ");
INSERT INTO mgc_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Zë ra dë mati ame'donnï mï kö'du kyënyë mï ru laka nani mati ï'dï zi ye ne? ");
INSERT INTO mgc_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Ako'dɔ 'e kö'du ma laka, ëzë oro 'e kö'du kï'dï 'ba damöku mati i'ja mï kö'du yöru, “O'dɔ lɔvɔ vo haliŋɔ oka, kaa o'dɔ lɔvɔ yï.” ");
INSERT INTO mgc_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Mora ëzë o'dɔ kö'du zi vïdï 'e tada ra laya 'bëzë, o'dɔ kö'du kyënyë ku, ehe kö'du kï'dï akï'dï yï mï kamba kaa vo kö'du kï'dï kowe. ");
INSERT INTO mgc_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Vïdï mati owe kö'du kï'dï kölö o'dɔ kö'du kyënyë ku zë kowe aba biya. ");
INSERT INTO mgc_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Iya henye, “O'dɔ ndoro dë.” Iya kpa henye, “Ofo vïdï dë.” Ëzë o'dɔ ndoro dë, mora ofo vïdï ku, ayi ku na vo kö'du kï'dï kowe. ");
INSERT INTO mgc_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Ame'do ehe o'dɔ kaa vïdï mati akiya vo vurë rɔ mo kö'du kï'dï aba, mati akila 'e na dangölö. ");
INSERT INTO mgc_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Wïrï ayada mïkyëyï 'bënï dë, zi vïdï mati ikye vurë kazi mïkyëyï. Mïkyëyï ï'bë ndra tada vurë kiya! ");
INSERT INTO mgc_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Öndu ma'e ëmï ma ëtï, ëzë vïdï maako iya noma, mora mo o'dɔ kö'du laka, a'di ra ëdï na laka zi mo? Koma nani atɔ'bɔ mo yɔmɔ? ");
INSERT INTO mgc_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Ëzë öndu maako'e ëmï maako'e ëtï anzannï bɔngɔ aba ehe wakonyo, ");
INSERT INTO mgc_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","a'di ra ëdï na laka mï kö'du kiya 'bëyï zi zë, “Wïrï mï'dï ya'da zi ye, asesi 'e na kyëtu, onyo 'e na laka,” ëzë ï'dï wa ma laka dë zi zë? ");
INSERT INTO mgc_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Here ëzë koma ëdï kölö ehe o'dɔ waako dë, anza koma laka ra dë. ");
INSERT INTO mgc_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Mora vïdï maako akiya henye, “Vïdï kölö maako ëdï koma aba, agamo ëdï 'ba ko'dɔ mo.” Kö'du ya'ba 'bama ëdï henye, “Ayada zi ma, hala vïdï maako atɔ'bɔ tëdï koma aba kazi ko'dɔ mo, makayada koma 'bama zi mo kö'du ko'dɔ aba.” ");
INSERT INTO mgc_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Oma ku henye Wïrï ëdï nje kölö? Laka. Dakyikyi esennï kpa tere aba komo Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Yï kora vo lumë. Omba yɔlɔ koma kazi ko'dɔ mo, eme dë? ");
INSERT INTO mgc_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Anza dë zutu 'beze Abarayama ra komo Wïrï na laka tëmï kö'du ko'dɔ 'bɔmo, mati mo ï'dï wisi ënï Yisika da bi 'ba wakumu? ");
INSERT INTO mgc_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Ɔ'bɔ 'e dë kongɔ? Koma ɔmo kö'du ko'dɔ ɔmo aba o'dɔnnï lɔ'ɔ bi kolo. Koma ɔmo ëdï ndɔ tëmï lɔ'ɔ ko'dɔ ɔmo. ");
INSERT INTO mgc_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Kö'du yöru ayi ku tïnyö, mati iya henye, “Abarayama oma mï Wïrï, Wïrï ïrï mo na vo kö'du laka ko'dɔ tëmï koma ɔmo.” Here ako'jo Abarayama na aboka a Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Ongɔ te henye, ëdï lɔ'ɔ ko'dɔ 'ba vïdï 'e ra ï'dï zë na laka Wïrï aba, anza dë nje koma 'bëzë aba. ");
INSERT INTO mgc_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Ëdï kpa te kaa vo rönyï Rahaba aba here. Ï'dï mo na laka komo Wïrï tëmï kö'du ko'dɔ ɔmo vo buluku'e 'ba Yiserele kïrï kala kyedre aba, kɔnyi tahonnï ta gërï 'beri maako. ");
INSERT INTO mgc_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Here ida ra ma kazi lawo ne yöku ra. Kpa here koma ma kazi lɔ'ɔ ko'dɔ ne yöku. ");
INSERT INTO mgc_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Öndu ma 'e ëmï ma ëtï, anza dë kyɔ tënü 'e zi tayinnï na vo komo yandi 'e. Kaa ayɔlɔ 'e henye, ze vo komoyandi 'e akiya vurë kyedre kyigɔ re ze ndra tada oka'e. ");
INSERT INTO mgc_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Ge ze biya 'duwï dëdï kö'du lïtë ko'dɔ. Ëzë vïdï o'dɔ kö'du lïtë dë mï ko'dɔ kiya 'bënï, mo ëdï tïnyö laka, atɔ'bɔ kpa zi gë nï kongɔ laka. ");
INSERT INTO mgc_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Dï'dï ze kɔ'di ha akakya zi ko'dɔ zi he ze kowo zi ko'dɔ mo tï'bë bi mati domba ze. ");
INSERT INTO mgc_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Mandere akoba töŋbö kyedre kaa ga kö'du yada, mati buluku kyigɔ adu'du, datɔ'bɔ kopi wa tisi 'ba dahu töŋbö aba, mati domba tï'bë zi mo. ");
INSERT INTO mgc_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Here ëdï ndende aba. Tisi wa aba kaa ëdï, atɔ'bɔ me'do kö'du wa kyedre'e. Asösu 'e te hala möku kyedre atɔ'bɔ kusu mo wa'do tisi aba. ");
INSERT INTO mgc_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Ndende ëdï kaa wa'do. Ëdï damöku 'ba kö'du kyënyë, i'ja bi 'bënï mida re ze ehe apere kö'du kyënyë kpuru tëmï lima 'beze. Usu wa'do mï bi tïnyö lima 'beze, wa'do mati ayi zi mo kazi gehena. ");
INSERT INTO mgc_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Vïdï köndu atɔ'bɔ kopi wa wïdï maako'e biya, ngötu möku'e, aliye, watele'e, kyenze ëtï. ");
INSERT INTO mgc_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Vïdï maako gba ɔ'bɔ dë zi ndende kopi. Ëdï kö'du kyënyë ko'dɔ, ëdï kyɔ waroso 'ba koli aba. ");
INSERT INTO mgc_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Dï'dï ze öwö'dï zi Yere ehe 'Bu ndende ze aba, ehe kpa zi vïdï maako'e sënë mo aba, mati o'dɔ zë kpa na kyïnë 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Me'do 'ba öwö'dï kï'dï ehe wa sënë ope yaga tëmï ha kölö ne. Öndu ma 'e ëmï ma ëtï, nenye o'dɔ rë nï dë here. ");
INSERT INTO mgc_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Ku'ju 'ba wini ope yaga wini ma ndili ehe ope wini ma kata dë tëmï bi hwërë kölö ne. ");
INSERT INTO mgc_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Öndu ma 'e ëmï ma ëtï, kaga liŋɔ ɔ'bɔ dë tana manga, manga ɔ'bɔ dë tana liŋɔ. Ku'ju alöwu 'dö wini ma yɔ'dɔ ehe wini ma ndili dë. ");
INSERT INTO mgc_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ëyï ra na vo kö'du yɔlɔ mï kutë 'e? Mo ma yada mï lima laka 'bënï, kö'du ko'dɔ mati ayi kazi vo kö'du yɔlɔ. ");
INSERT INTO mgc_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Mora ëzë yï na mïkumbë 'ba mïkata mï di'di yï, o'dɔ dakumbë dë ehe iga ndɔndɔ dë ra kö'du tïnyö. ");
INSERT INTO mgc_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Kyïnë 'ba kö'du yɔlɔ nani ayi dë akaŋo ta komorïyë, ayi kazi dakyikyiye. ");
INSERT INTO mgc_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Bi ma mïkumbë mïkata aba 'dɔ mo, kpa kyïnë 'ba kö'du ko'dɔ kyïnyë 'ba Satani aba biya. ");
INSERT INTO mgc_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Kö'du yɔlɔ 'ba rïyë ëdï biya na ŋbala, na rakyëyï, liya, akɔnyi aboka, mïkyëyï ndɔ, kö'du ko'dɔ laka aba. Ëdï vo tïnyö, anza vo komokandi. ");
INSERT INTO mgc_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Vïdï 'ba mïkyëyï o'dɔnnï kö'du laka. ");
INSERT INTO mgc_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Kamo ralamo aba mï kutë 'e ne ayi ta kila? Ayinnï tëmï da kö'du komba 'ba mï di'di 'e, mati lifonnï mï re 'e. ");
INSERT INTO mgc_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Omba 'e wa, mora i'ja 'e zë dë. 'E gbɔ nzɔ zi wakofo, ehe omba'e wa'e, mora i'ja 'e zë dë. Alamo re 'e ehe u'bö re 'e. Anza dë wa mati omba 'e, ga kö'du ako'jo 'e ha Wïrï dë kö'du mo. ");
INSERT INTO mgc_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Ëzë ako'jo'e, ïrï 'e dë, ga kö'du ako'jo 'e kö'du wa zi ko'dɔ mo mï da kö'du komba 'be'e. ");
INSERT INTO mgc_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Vïdï kazi koma'e ra. Ayɔlɔ 'e dë henye ere, zi tëdï na obaka 'ba damökü, ne ku vo wehe 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Asösu'e dë henye ere, kö'du tïnyö anza dë mï kö'du yöru mati iya henye, “Lawo mati Wïrï ï'dï mï ze, oso ndɔ na kö'du komba.” ");
INSERT INTO mgc_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Mora rakyëyï mati Wïrï ï'dï ëdï ndrë. Kaa wayöru iya henye, “Wïrï omba vo rakïsïye dë, mora ï'dï rakyëyï zi vo raya'ba'e.” ");
INSERT INTO mgc_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Here, ï'dï re 'e zi Wïrï. Agaga ge 'e kazi Satani, ehe mo ataho 'de kazi 'e. ");
INSERT INTO mgc_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Ayiye kara zi Wïrï, ehe mo atayi kara re 'e. Akaka kala 'e, 'e vo kö'du kyënyë ne'e. O'dɔ di'di 'e ŋbala, 'e vo komokandi ne'e. ");
INSERT INTO mgc_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Ëdï 'e rasösu, kudu lu'bë aba. Opi 'e kogo 'be'e mï kudu. Opi 'e rakyenyi mï da komo yaŋa. ");
INSERT INTO mgc_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Ala'ba re 'e di'di Yere, mo akïnjë 'e rïyë. ");
INSERT INTO mgc_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Öndu ma'e, ëmï ma ëtï, ame'do 'e dë na kyënyë ra aboka maako. Ëzë ame'do 'e na kyënyë ra aboka maako, ame'do 'e na kyënyë ra kö'du kï'dï. Ëzë ame'do 'e na kyënyë ra kö'du kï'dï, oro 'e kö'du kï'dï dë, mora ëdï 'e vurë ra ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Vo kö'du kï'dï kölö, vo vurë kölö, mati atɔ'bɔ yɔmɔ ehe yaŋa. Yï ëyï ra zi vurë 'ba aboka yï ko'dɔ? ");
INSERT INTO mgc_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Yaanya aba owɔ'e ha ma, 'e mati iya 'e henye, “Ndenye mandere mïndö aba datï'bë zi gawo kyedre maako, bi ma dakalima kɔɔ, tï'bë mï lɔ'ɔ maako, kɔhi ko'dɔ kyɔ.” ");
INSERT INTO mgc_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Ayɔl ɔ'e dë, a'di ra ako'dɔ rë nï mïndö aba. 'E kaa kyëtu 'ba wa'do, mati alaya mï kadra tisi, ehe inde rë nï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Wa mati akiya 'e ëdï henye, “Ëzë Yere omba, dakalima ze da ko'dɔ nenye mandere nani.” ");
INSERT INTO mgc_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Mora yaanya aba 'e na rakïsï, ame'do 'e na rakïsï. Rakïsï ne biya anza laka. ");
INSERT INTO mgc_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Here zë maako'e mati ayɔlɔnnï kö'du laka zi ko'dɔ, mora zë o'dɔnnï dë, zë o'dɔnnï kö'du kyënyë ku. ");
INSERT INTO mgc_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Yaanya aba, 'e vïdï 'ba wa aba kyɔ, oze mbiliye zi ma. Udu 'e tɔlɔ aba, ga kö'du riti kyënyë mati ëdï tayi de 'e ne. ");
INSERT INTO mgc_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Wa da kayo 'be'e ne eŋe ku 'de, bɔngɔ 'be'e kuru onyo ku. ");
INSERT INTO mgc_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Dahabo 'be'e maŋzede aba ayöfu dɔ mo ku wa lëndrë aba. Wa lëndrë nenye atëdï na vo kiya ma ra 'e, akonyo ida re 'e kaa wa'do. Ulu 'e ha wa ku kyɔ mï ko'do ma alaga nenye'e. ");
INSERT INTO mgc_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Ï'dï 'e biriti kpa dë zi zë mati o'dɔnnï lɔ'ɔ mï yaka 'be'e. Yere kyedre owo kudu 'bëzë ku. ");
INSERT INTO mgc_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Lima 'be'e ma dakaŋo kinye ne, kyɔ na rakyenyi. O'dɔ re 'e ku nzɔ zi riti kï'dï zi ye. ");
INSERT INTO mgc_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Asusu 'e vïdï mbiya kofo mo, agagannï gë nï kpa dë kazi 'e. ");
INSERT INTO mgc_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Öndu ma 'e ëmï ma ëtï, ëdï 'e mïkuku aba le Yere 'bɔkɔ. Ongɔ 'e te hala vo yaka uku mï nï, bi kaŋo ënï kisi zi tana wa kyɔ. Mo isi bi mo mïkuku aba zi mïrë tayi. ");
INSERT INTO mgc_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Ëdï 'e kpa na mïkuku. Asesi 'e kö'du sösu 'be'e rï yë, ga kö'du tayi 'ba Yere ëdï ku kara. ");
INSERT INTO mgc_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Öndu ma'e ëmï ma ëtï, ame'do 'e dë ra oka maako, kazi Wïrï ikye vurë re 'e. Vo vurë kikye ëdï ku kara, nzɔ zi laya. ");
INSERT INTO mgc_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Öndu ma 'e ëmï ma ëtï, asösu 'e kö'du nëbï mati ame'do nnï mï ru 'ba Yere. Oba zë kaa ga kö'du yada 'ba mïkuku mï riti. ");
INSERT INTO mgc_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Dako'jo zë na vo rakyenyi, ga kö'du zë nduwë kö'du laka ko'dɔ. Owo 'e hala Yakoba nduwë kö'du laka ko'dɔ, ayɔlɔ 'e ku hala Wïrï ï'dï zi mo mï ndundu mo. Kö'du Yere ndɔ na mïkyëyï ehe lɔvɔ. ");
INSERT INTO mgc_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Ta da mo biya, öndu ma 'e ëmï ma ëtï, alömu 'e dë komorïyë aba, mandere dakaŋo aba, mandere kpa wa maako aba. Iya 'e nje henye “ɔɔ,” ëzë omba kiya ɔɔ, ehe “e'e” ëzë omba kiya 'e'e. Here ayi 'e dë mï vurë a Wïrï. ");
INSERT INTO mgc_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Vïdï maako tëmï 'e mï riti? Mo ma mötu. Vïdï maako na rakyenyi? Mo ma ya'bi ngala 'ba wayeto. ");
INSERT INTO mgc_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Vïdï maako tëmï 'e na kɔ'ɔ? Mo ma ko'jo vïdï kyedre 'ba kanisa'e zi mötu dë nï yënï kulö rɔ mo mï ru 'ba Yere. ");
INSERT INTO mgc_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Mötu mati koma aba ne, ako'dɔ vïdï kɔ'ɔ ne na laka, Yere akïnjë mo rïyë. Ëzë mo o'dɔ kö'du kyënyë, akila mo. ");
INSERT INTO mgc_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Here ayasi kö'du kyënyë 'bëyï zi oka ma kölö maako, ehe amötu kö'du oka ma kölö maako, here zi kɔ'jɔ na laka. Mötu 'ba vïdï laka ëdï na kyigɔ. ");
INSERT INTO mgc_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Eliya mo kora kaa ze. Mo amötu henye mïrë a'di dë, ehe mïrë a'di dë dakaŋo kɔɔ wota dënï aba. ");
INSERT INTO mgc_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Löhu mo amötu, ehe komorïyë ï'dï mïrë, dakaŋɔ o'jo wa tana 'bënï gbɔ. ");
INSERT INTO mgc_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Öndu ma 'e, ëzë vïdï kölö maako tëmï 'e awïrï dë nï tëmï kö'du tïnyö, ehe vïdï maako mika mo hulëhu, ");
INSERT INTO mgc_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","asösu 'e kö'du nenye: Vïdï mati opi da vo kö'du kyënyë ko'dɔ ku tëmï gërï lïtë 'bɔmo, akayɔmɔ mo tëmï koli, akayöfu da kö'du kënyë kayo ne'e biya.");
INSERT INTO mgc_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Dayöru zi ye kö'du me'do 'ba dïdï, mati ëdï kyere biyeto aba. Dowo ze ku, dongɔ ze ku komo ze aba. Ɔɔ, dongɔ ze ku, kala ze ise rɔ mo ku. ");
INSERT INTO mgc_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Mati dïdï nenye alaya ku, dongɔ ze, here da me'do kö'du mo ehe yada zi ye kö'du 'ba dïdï ŋburu ŋburu mati 'Bu o'dɔ na yɔlɔ zi ze. ");
INSERT INTO mgc_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","Wa mati dongɔ kowo mo aba, dayöyö ze kpa zi ye, here zi ye re 'e drɔkɔ ze aba mï mötu 'ba ga bi kölö mati dëdï mo aba, Wïrï ehe Wisi ɔmo Yësu Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Dayöru ze henye zi rakyenyi 'beze kinde. ");
INSERT INTO mgc_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Yaanya aba kö'du kise mati dowo ze kazi Wisi ɔmo, ehe yöyö mo ëdï henye, Wïrï bikanyi ra, biköndu ako anza dë mï mo. ");
INSERT INTO mgc_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ëzë diya ze henye, ze na radrɔko mo aba, mora mï kadra kölö ne zɔ lima mï biköndu, ze ne 'dö ndɔndɔ kiga mï me'do 'beze kpa kö'du ko'dɔ 'beze aba. ");
INSERT INTO mgc_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Mora ëzë dalima ze mï bikanyi, kaa mo ëdï mï bikanyi, here datëdï ze mï lima kölö oka maako aba, ehe yama 'ba Yësu, Wisi ɔmo o'dɔ ze ku ŋbala tëmï kö'du kyënyë. ");
INSERT INTO mgc_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Ëzë diya ze danza kö'du kyënyë aba, do'ba re ze ku, ani kö'du tïnyö ako anza dë mï ze. ");
INSERT INTO mgc_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Mora ëzë dayasi kö'du kyënyë 'beze zi Wïrï, mo akasesi kö'du kï'dï ënï ako'dɔ wa mati ëdï laka, mo akila ze tëmï kö'du kyënyë 'beze, maŋbala biya tëmï kö'du ko'dɔ kyënyë 'beze. ");
INSERT INTO mgc_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Ëzë diya ze henye, do'dɔ kö'du kyënyë dë, do'dɔ ze Wïrï yada zi tëdï na vo ndɔndɔ, me'do 'bɔmo anza dë mï ze. ");
INSERT INTO mgc_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Mëdï nenye yöru zi ye, gisi ama'e, kazi o'dɔ'e kö'du kyënyë, mora ëzë vïdï maako o'dɔ kö'du kyënyë ku, dëdï maako aba mo akayata ge ze zi 'Bu, Yësu Korisitɔ ra tïnyö laka. ");
INSERT INTO mgc_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Korisitɔ ra na bi dë nï umu rë nï zi kö'du kyënyë 'beze kila, anza dë nje kö'du kyënyë 'beze, mora kpa kö'du kyënyë 'ba vïdï biya. ");
INSERT INTO mgc_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Ëzë dowo 'e kö'du kï'dï a Wïrï, ani tïnyö dayɔlɔ mo ku. ");
INSERT INTO mgc_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Zë mati iyannï henye na yɔlɔnnï mo ku, mora owonnï ko'du kï'dï 'bɔmo dë, vo ndɔndɔ 'e ra, kö'du tïnyö anza dë mï zë. ");
INSERT INTO mgc_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Zë biya mati owonnï me'do 'bɔmo, lɔvɔ 'ba Wïrï ëdï ndɔ mï mo. Nenye ëdï hala datɔ'bɔ yɔlɔ henye, dëdï mï ra drɔkɔ Wïrï aba. ");
INSERT INTO mgc_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Zë mati iyannï henye, nëdïnnï ku na radrɔko Wïrï aba, ma limannï te kaa Yësu Korisitɔ o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Aboka ma'e, kö'du kï'dï nenye mëdï ayöru zi ye anza na kyïyï, ëdï kö'du kï'dï kɔ'ɔ ra, mati owo'e tëmï biyeto aba. Kö'du kï'dï kɔ'ɔ ne ëdï kö'du kise mati owo'e ku nzɔ ne. ");
INSERT INTO mgc_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Here, kö'du kï'dï mati yaanya aba mëdï ayöru zi ye ne, kö'du kï'dï kyïyï ra. Nenye kö'du tïnyö ongɔ mï Yësu kpa mï ye, ga kö'du biköndu ëdï laga 'de, bikanyi ma tïnyö ëdï ku nzɔ biyanyi. ");
INSERT INTO mgc_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Zë mati iyannï henye, nëdïnnï lima mï bikanyi, mora zë nduwë koyi öndu nnï 'e ëmï ëtï, ëdïnnï mï biköndu mï kadra nenye. ");
INSERT INTO mgc_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Zë mati o'dɔnnï lɔvɔ öndu nnïye, ëdïnnï mï bikanyi, here waako anza dë mï zë zi vïdï maako zi kö'du kyënyë ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Mora zë mati oyi öndu nnï 'e ëmï ëtï, zë ëdïnnï mï biköndu, zë ëdïnnï alasi mï mo, ayɔlɔnnï dë kila nëdïnnï atï'bë, ga kö'du biköndu ne o'dɔ zë ku na komo köndu. ");
INSERT INTO mgc_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Mëdï ayöru zi ye gisi a ma 'e, ga kö'du kyënyë 'be 'e ila ku ga kö'du 'ba Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Mëdï ayöru zi ye, 'bu 'e, ga kö'du ayɔlɔ 'e mo ëdï kyere biyeto aba. Mëdï ayöru zi ye, vïdï mati zë gba na ɔbi, ga kö'du a'da 'e Satani ku. Mëdï ayöru zi ye gisi ama 'e, ga kö'du ayɔlɔ 'e 'bu ne ku. ");
INSERT INTO mgc_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Mëdï ayöru zi ye 'bu'e, ga kö'du ayɔlɔ 'e mo ëdï kyere biyeto aba. Mëdï ayöru zi ye vïdï mati zë gba na ɔbi, ga kö'du 'e na kyigɔ, me'do 'ba Wïrï alima mï ye, a'da'e Satani ku. ");
INSERT INTO mgc_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","O'dɔ 'e lɔvɔ damöku dë mandere wa mati ëdï na 'ba damöku ne. Ëzë o'dɔ'e lɔvɔ damöku, o'dɔ'e lɔvɔ 'bu ne dë. ");
INSERT INTO mgc_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Wa mati biya 'ba damöku ne, wa mati ra 'ba kö'du kyënyë omba ne, wa mati vïdï ongɔ komba aba, wa biya mï damöku nenye mati vïdï ëdï rë nnï kisi kö'du mo, ma kölö tëmï zë ayi dë kazi 'bu, ayi biya tëmï damöku ne. ");
INSERT INTO mgc_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Damöku wa biya mï mo aba mati vïdï omba ëdï alaga 'de, mora zë mati o'dɔnnï da kö'du komba 'ba Wïrï, akalimannï ŋburu. ");
INSERT INTO mgc_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Gisi ama 'e, ndundu mo ëdï ku kara. Ayada zi ye henye, vo wehe 'ba Korisitɔ atayi, yaanya aba vo wehe kayo 'ba Korisitɔ alayannï ku nzɔ, here dayɔlɔ ze ndundu mo ëdï ku kara. ");
INSERT INTO mgc_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Vïdï nenye'e anza nnï dë tïnyö mï gboko 'beze, kö'du nere ra zë ilannï ze. Ëzë ëdïnnï mï gboko 'beze, zë akalimannï ze aba. Mora zë ï'bë wënnï, here ëdï na yɔlɔ henye ma kölö maako anza dë tëmï gboko 'beze. ");
INSERT INTO mgc_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Mora Lawo Kölö Laka alokɔ yaga de 'e, here 'e biya ayɔlɔ'e tïnyö ku. ");
INSERT INTO mgc_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Mëdï ayöru zi ye, anza dë ga kö'du ayɔlɔ tïnyö dë, ëdï ga kö'du ayɔlɔ 'e ku, ehe ayɔlɔ 'e kpa henye, ndɔndɔ ayi dë tëmï kö'du tïnyö. ");
INSERT INTO mgc_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Ëyï ra ëdï na vo ndɔndɔ ne? Ëdï zë mati iyannï henye, Yësu anza dë Korisitɔ. Vïdï ma here ne'e zë vo wehe 'ba Korisitɔ, zë ombannï 'bu dë 'dö Wisi aba. ");
INSERT INTO mgc_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Kö'du zë mati biya ombannï Wisi dë, kpa ombannï 'bu dë. Zë mati ombannï Wisi, ombannï 'bu kpa. ");
INSERT INTO mgc_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Ayɔlɔ'e laka zi sesi kö'du kise ne mï di'di 'e tëmï biyeto aba. Ëzë asesiye kö'du kise nani, ëdïye 'duwï na radrɔko mï Wisi 'bu aba. ");
INSERT INTO mgc_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Nenye ëdï wa mati Korisitɔ na bi dënï alömu zi dïdï ŋburu kï'dï zi ze. ");
INSERT INTO mgc_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Mëdï nenye yöru zi ye kö'du zë mati ëdïnnï yɔnzɔ zi ye ko'ba. ");
INSERT INTO mgc_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Mora kö'du 'e, Korisitɔ ope yaga Lawo Kölö Laka ënï de 'e. Lawo Kölö Laka ɔmo ayandi kö'du wa ku biya zi ye, wa mati mo ayandi ëdï tïnyö anza ndɔndɔ ra dë. Oro'e wa yandi 'ba Lawo Kölö Laka, alima'e na radrɔko mï Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Ɔɔ, gisi ama'e, alima 'e na radrɔko mo aba, here ëzë mo alaya, datëdï ze kyigɔ aba, doho re ze dë kazi komokaya mï kadra mati mo ayi. ");
INSERT INTO mgc_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Ëzë ayɔlɔ'e ku mo ëdï laka, akayɔlɔ'e henye, vïdï biya mati o'dɔ wa mati na laka, mo Wisi ɔmo ra. ");
INSERT INTO mgc_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Ongɔ 'e te, hala 'bu o'dɔ lɔvɔ ze ndra. Lɔvɔ 'bɔmo ëdï kyedre ne re ra ako'jo ze gisisi 'ba Wïrï, here tïnyö, dëdï ze. Kö'du ne re ra damöku ayɔlɔ ze dë, ayɔlɔ Wïrï dë. ");
INSERT INTO mgc_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Aboka ma'e, yaanya aba ze gisisi a Wïrï, mora anza dë gba na yɔlɔ datayi ze na a'di. Mora dayɔlɔ ze ku henye ëzë Korisitɔ alaya, datëdï ze kaa mo, ga kö'du dakongɔ ze mo tïnyö kaa mati mo ëdï. ");
INSERT INTO mgc_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Vïdï mati ëdï kö'du sösu nenye aba mï Korisitɔ, ma sesi rë nï ŋbala, kpa te kaa Korisitɔ ëdï ŋbala. ");
INSERT INTO mgc_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Vïdï mati o'dɔ kö'du kyënyë, o'dɔ kö'du kyënyë ku kö'du kï'dï 'ba Wïrï kowe. ");
INSERT INTO mgc_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Ayɔlɔ'e ku henye, Korisitɔ alaya zi kö'du kyënyë koba 'de, ani kö'du kyënyë anza dë mï mo. ");
INSERT INTO mgc_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Here, vïdï mati alima na radrɔko Korisitɔ aba, anza dë nduwë zi kö'du kyënyë ko'dɔ, mora mo mati zɔ nduwë zi kö'du kyënyë ko'dɔ, ongɔ mo dë mandere ayɔlɔ mo dë. ");
INSERT INTO mgc_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Vïdï maako mo'ba 'e dë, gisi a ma. Vïdï mati o'dɔ wa ma laka, ëdï ŋbala, kpa te kaa Korisitɔ ëdï ŋbala. ");
INSERT INTO mgc_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Vïdï mati nduwë zi kö'du kyënyë ko'dɔ, 'ba Satani ra, ga kö'du Satani o'dɔ kö'du kyënyë akpa biyeto aba. Wisi 'ba Wïrï alaya ga kö'du nenye zi yaŋa wa mati Satani o'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Vïdï mati zë na gisi 'ba da kö'du ko'dɔ komba 'ba Wïrï ëdï mï di'di zë, ga kö'du Wïrï 'bu zë, ɔ'bɔnnï dë nduwë zi kö'du kyënyë ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Nenye kö'du 'beri mï kutë gisi a Wïrï gisi 'ba Satani aba. Zë mati biya o'dɔ nnï wa ma laka dë mandere o'dɔnnï lɔvɔ oka'e dë anza nnï dë gisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Kö'du kise mati owo'e biyeto aba ëdï henye do'dɔ 'e lɔvɔ oka. ");
INSERT INTO mgc_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Danza 'e dë kaa Kayina, mo 'ba Satani, ofo öndu nï Abele. Kö'du a'di Kayina ofo mo? Ga kö'du wa mati mo o'dɔ biya na kyënyë, mora wa mati öndu mo o'dɔ biya na laka. ");
INSERT INTO mgc_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Here, re 'e maga dë, öndu ma'e ëmï ëtï. Ëzë vïdï 'ba damöku nenye oyinnï 'e. ");
INSERT INTO mgc_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Dayɔlɔ ze dila koli ku, dayi ku mï dïdï, dayɔlɔ ze here, ga kö'du do'dɔ ze lɔvɔ öndu ze 'e ëmï ze ëtï. Vïdï mati o'dɔ lɔvɔ dë gba hu kyigɔ 'ba koli. ");
INSERT INTO mgc_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Zë biya mati na vo wa koyi 'e ne, zë vo wa kofo 'e ra, ayɔlɔ 'e ku henye, vo wa kofo 'e anzannï dë dïdï ŋburu ŋburu aba mï nnï. ");
INSERT INTO mgc_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Nenye dayɔlɔ hala lɔvɔ ëdï, Korisitɔ ï'dï dïdï nï kö'du ze. Ze kpa zi dïdï ze kï'dï kö'du öndu ze 'e ëmï ze ëtï. ");
INSERT INTO mgc_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Vïdï mati zë wa aba kyɔ, ongɔ öndu mandere ëmï mati omba wa maako, isi di'di nnï kazi zë, ɔ'bɔ dë zi kiyannï henye, no'dɔnnï lɔvɔ Wïrï. ");
INSERT INTO mgc_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Gisi ama'e, lɔvɔ 'beze anza dë nje me'do kiya, mëdï lɔvɔ ma tïnyö, mati ayada rë nï mï lɔ'ɔ ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Nenye ëdï hala dakayɔlɔ henye ere, ze 'ba tïnyö. Nenye ëdï hala ");
INSERT INTO mgc_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","ëzë dïdï ze o'dɔ ze na komo kaya daiya ze ralawo tïnyö a Wïrï. Dayɔlɔ ku henye Wïrï ëdï kyedre ndra tada kö'du 'ba mï di'di ze, ehe mo ayɔlɔ wa biya. ");
INSERT INTO mgc_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Aboka ma'e, ëzë kö'du sösu mï di'di ze o'dɔ ze dë na komokaya, dëdï ze kyigɔ aba mï komo Wïrï. ");
INSERT INTO mgc_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Dïrï ze kazi mo wa mati da ko'jo, ga kö'du doro ze kö'du kï'dï ɔmo ehe ko'du wa mati o'dɔ mo na rakyenyi. ");
INSERT INTO mgc_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Wa mati mo ï'dï mï kö'du kï'dï ëdï henye, doma ze mï Wisi ënï Yësu Korisitɔ ehe do'dɔ ze lɔvɔ oka maako te kaa mati Korisitɔ ï'dï kö'du mo zi ze. ");
INSERT INTO mgc_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Zë mati oronnï kö'du kï'dï a Wïrï alimannï na radrɔko Wïrï aba, ehe Wïrï alima mï radrɔko ze aba. Nenye hala dayɔlɔ mo alima mï ze, dayɔlɔ ga kö'du mo ï'dï Lawo Kölö Laka zi ze. ");
INSERT INTO mgc_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Aboka ma'e, oma 'e dë mï lawo biya, mora ayɔnzɔ'e lawo ne'e ëzë ëdïnnï kazi Wïrï. Nëbï vo ndɔndɔ 'e kyɔ ï'bënnï yaga taga bi ne biya. ");
INSERT INTO mgc_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Nenye ëdï hala akatɔ'bɔ yɔlɔ'e Lawo Laka a Wïrï: Vïdï maako mati iya tïnyö henye, Yësu Korisitɔ ayi kaa vïdï köndu, ëdï Lawo Laka mati ayi kazi Wïrï aba. ");
INSERT INTO mgc_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Mora lawo maako mati andi kö'du 'ba Yësu, anza dë kazi Wïrï. Lawo mati mo ëdï mo aba, ëdï vo wehe 'ba Korisitɔ, owo'e henye, atayi ehe yaanya aba ëdï ku kinye mï damöku ne nzɔ. ");
INSERT INTO mgc_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Mora 'e 'ba Wïrï ra, gisi ama 'e, a'da 'e da nëbï vo ndɔndɔ 'e ku ga kö'du Lawo Laka mati ëdï mï ye ne, ëdï ndra na kyigɔ tada lawo mï zë mati 'ba damöku. ");
INSERT INTO mgc_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Nëbï vo ndɔndɔ naniye ame'donnï kö'du wa 'ba damöku, ehe damöku oze mbili dë zë ga kö'du zë 'ba damöku ne. ");
INSERT INTO mgc_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Mora ze 'ba Wïrï ra. Vïdï mati ayɔlɔ Wïrï owo de ze, vïdï mati anza dë 'ba Wïrï, owo de ze dë. Nenye ëdï hala daka tɔ'bɔ yada wa mati 'beri mï kutë 'ba Lawo ma tïnyö lawo ma anza dë tïnyö aba. ");
INSERT INTO mgc_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Aboka'e, do'dɔ 'e lɔvɔ oka maako, ga kö'du lɔvɔ ayi kazi Wïrï. Vïdï mati o'dɔ lɔvɔ, mo Wisi 'ba Wïrï ra, ayɔlɔ Wïrï. ");
INSERT INTO mgc_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Vïdï mati o'dɔ lɔvɔ dë, ayɔlɔ Wïrï dë, ga kö'du Wïrï lɔvɔ ra. ");
INSERT INTO mgc_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Wïrï ayada lɔvɔ ënï zi ze Wisi kölö ënï kutu mï damöku ne, ga kö'du zi ze tëdï dïdï aba kpuru kazi mo. ");
INSERT INTO mgc_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Nenye ëdï hala lɔvɔ ëdï. Anza dë henye do'dɔ ze lɔvɔ Wïrï, mora mo o'dɔ lɔvɔ ze, ehe utu Wisi ënï zi kumu rë nï zi kö'du kyënyë 'beze kila. ");
INSERT INTO mgc_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Aboka'e, ëzë ëdï nenye hala Wïrï o'dɔ lɔvɔ ze, do'dɔ lɔvɔ oka maako. ");
INSERT INTO mgc_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Vïdï maako gba ongɔ Wïrï dë, mora ëzë do'dɔ lɔvɔ oka maako, Wïrï alima mï radrɔko ze aba, lɔvɔ ɔmo ëdï ndɔ mï ze. ");
INSERT INTO mgc_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Dayɔlɔ ku henye, dalima mï radrɔko Wïrï aba, here mo alima mï radrɔko ze aba, ga kö'du mo ï'dï Lawo Laka ënï ku zi ze. ");
INSERT INTO mgc_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Dongɔ ze dayada zi zë maako'e henye, 'Bu utu Wisi ënï zi tëdï vo wa yɔmɔ 'ba damöku. ");
INSERT INTO mgc_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Ëzë vïdï mati iya henye Yësu Wisi 'ba Wïrï ra, mo alima mï radrɔko Wïrï aba, ehe Wïrï alima mï radrɔko mo aba. ");
INSERT INTO mgc_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Ze na bi de ze dayɔlɔ, doma ku lɔvɔ mati Wïrï ëdï mo aba kö'du ze. Wïrï lɔvɔ ra, zë mati alimannï mï lɔvɔ, alimannï mï radrɔko Wïrï aba, ehe Wïrï alima mï radrɔko zë aba. ");
INSERT INTO mgc_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Lɔvɔ o'dɔ ndɔ mï ze, zi ze tëdï ze na kyigɔ da kadra 'ba vurë, ehe datëdï ze mo aba, ga ko'du dïdï 'beze mï damöku nenye ëdï kpa te kaa 'ba Korisitɔ. ");
INSERT INTO mgc_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Ani tere anza dë mï lɔvɔ, lɔvɔ ma laka ore tere biya yaga. Here, lɔvɔ o'dɔ dë ndɔ mï vïdï mati ëdï na tere, ga kö'du tere ëdï zi riti ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Do'dɔ lɔvɔ ga kö'du Wïrï o'dɔ lɔvɔ ze dagba. ");
INSERT INTO mgc_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Ëzë diya do'dɔ lɔvɔ Wïrï, mora doyi öndu'e ëmï ëtï, ze vo ndɔndɔ. Kö'du vïdï ma o'dɔ lɔvɔ öndu nï 'e dë, mati mo ongɔ, mo o'bɔ dë lɔvɔ Wïrï, mati mo ongɔ dë ne ko'dɔ. ");
INSERT INTO mgc_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Kö'du kï'dï mati Korisitɔ ï'dï zi ze ëdï nenye, zë biya mati o'dɔnnï lɔvɔ Wïrï, mo'dɔnnï lɔvɔ öndu nnï mandere ëmï 'e kpa. ");
INSERT INTO mgc_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Mo mati oma henye ere, Yësu ne Korisitɔ ra, ëdï wisi 'ba Wïrï ra, ehe mo mati o'dɔ lɔvɔ 'Bu, o'dɔ lɔvɔ Wisi kpa. ");
INSERT INTO mgc_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Nenye ëdï hala dayɔlɔ ze henye ere, do'dɔ lɔvɔ gisi a Wïrï, ëzë do'dɔ lɔvɔ Wïrï, ehe doro kö'du kï'dï ɔmo kpa. ");
INSERT INTO mgc_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Kö'du lɔvɔ Wïrï ko'dɔ 'beze ëdï henye, doro kö'du kï'dï ɔmo. Kö'du kï'dï ɔmo anza dë na kyigɔ kö'du ze, ");
INSERT INTO mgc_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","ga kö'du gisi 'ba Wïrï biya atɔ'bɔ ta'da damöku ne. Da'da ze damöku nenye tëmï gërï 'ba koma. ");
INSERT INTO mgc_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Ëyï ra atɔ'bɔ ta'da damöku? Nje vïdï mati oma henye, Yësu Korisitɔ Wisi 'ba Wïrï ra. ");
INSERT INTO mgc_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Yësu Korisitɔ ra ayi wini 'ba bapatisi 'bënï aba, ehe yama 'ba koli 'bɔmo. Mo ayi dë nje wini aba, mora 'dö wini yama aba. Lawo Kölö Laka ayada, ga kö'du mo ëdï tïnyö. ");
INSERT INTO mgc_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Vo kiya ëdïnnï wota: ");
INSERT INTO mgc_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Lawo Kölö Laka, wini, yama. Zë wota ne ayadannï biya kpa te kö'du kölö ne. ");
INSERT INTO mgc_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Doma ze kö'du kiya 'ba vïdï köndu, mora kö'du kiya a Wïrï ëdï ndra na kyigɔ, mati mo iya kö'du Wisi ënï. ");
INSERT INTO mgc_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Here zë biya mati omannï mï Wisi 'ba Wïrï, ëdïnnï kö'du yada nenye aba mï di'di nnï, mora zë mati omannï dë mï Wïrï, o'dɔnnï Wïrï zi tëdï na vo ndɔndɔ. ");
INSERT INTO mgc_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Kö'du yada ne ëdï: Wïrï ï'dï zi ze dïdï ma ŋburu ŋburu, ehe dïdï nenye ëdï Wisi ɔmo aba. ");
INSERT INTO mgc_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Mo mati ëdï Wisi ne aba, ëdï dïdï nenye aba. Mo mati anza dë Wisi 'ba Wïrï aba, anza dë dïdï aba. ");
INSERT INTO mgc_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Mëdï nenye yöru zi ye, zi ye yɔlɔ 'e ëdï 'e dïdï ŋburu ŋburu aba, ëzë oma 'e mï Wisi 'ba Wïrï. ");
INSERT INTO mgc_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Dakyigɔ re ze komo Wïrï, ga kö'du dayɔlɔ ze henye, mo owo de ze ëzë dako'jo ze hɔ mo kö'du wa maako'e kaa da komba 'bɔmo. ");
INSERT INTO mgc_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Mo owo de ze ëzë da ko'jo ze hɔ mo, kyere dayɔlɔ ze nenye ëdï tïnyö. Dayɔlɔ kpa henye mo ï'dï zi ze wa mati dako'jo kö'du mo ku nzɔ. ");
INSERT INTO mgc_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Ëzë öndu yï mandere ëmï o'dɔ kö'du kyënyë, mati ika zë dë zi koli, amötu zi Wïrï mati akï'dï dïdï zi zë. Nenye zi zë mati kö'du kyënyë ika zë dë zi koli. Kö'du kyënyë maako ika koli. Damötu dë zi Wïrï ga kö'du nani. ");
INSERT INTO mgc_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Biya wa ko'dɔ mati eme dë, ne na kö'du kyënyë, mora ani kö'du kyënyë maako ëdï ika koli dë. ");
INSERT INTO mgc_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Dayɔlɔ ku henye, gisi a Wïrï maako anza dë sesi nduwë kö'du kyënyë ko'dɔ, ga kö'du Wisi 'ba Wïrï asesi zë ne laka, ehe Satani ɔ'bɔ dë zi zë ko'dɔ na kyënyë. ");
INSERT INTO mgc_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Dayɔlɔ ku henye, ze gisi 'ba Wïrï ra, ehe damöku ne ëdï mï kyigɔ 'ba Satani. ");
INSERT INTO mgc_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Dayɔlɔ ku Wisi 'ba Wïrï ayi ï'dï kö'du yɔlɔ ku zi ze, here zi ze yɔlɔ Wïrï ma tïnyö ne. Dalima mï radrɔko Wïrï ma tïnyö aba, kpa mï radrɔko Wisi ɔmo Yësu Korisitɔ aba. Nenye Wïrï tïnyö ra, ehe nenye ëdï dïdï ma ŋburu ŋburu ra. ");
INSERT INTO mgc_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Gisi ama'e, asesi re 'e laka kazi wiri ndɔndɔ 'e.");
ALTER TABLE mgc_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
