﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfy_vpl;
CREATE TABLE mfy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfy_vpl WRITE;
INSERT INTO mfy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ïri libropo jïojteri Jesucristota bétana áchayhuariapo bat kat‑riam, Davidta ä usiatukaï bétana entok Abrahamta bétana. ");
INSERT INTO mfy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaacta üusek, Isaac éntok Jacobta, Jacob éntok Judáta entok jume ä sailahuam. ");
INSERT INTO mfy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá juka Faresta entok juka Zarata üusek, Ímëi éntok Tamarta áyekay. Fares juka Esromta üusek, Esrom éntok Aramta üusek. ");
INSERT INTO mfy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadabta üusek, Aminadab éntok Naasónta, Naasón éntok Salmónta. ");
INSERT INTO mfy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Boozta üusek; ïri éntok Rahabta áyekay. Booz Obedta üusek, ïri éntok Rutta áyekay. Obed éntok Isaíta üusek. ");
INSERT INTO mfy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí réy Davidta üusek, réy David éntok Salomónta ïri éntok Uriasta jubekäu áyekay. ");
INSERT INTO mfy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboamta üusek, Roboam éntok Abíasta, Abías éntok Asa ti téhuaakamta. ");
INSERT INTO mfy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafatta üusek, Josafat éntok Joramta, Joram éntok Uzíasta. ");
INSERT INTO mfy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotamta üusek, Jotam éntok Acazta, Acaz éntok Ezequíasta. ");
INSERT INTO mfy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasésta üusek, Manasés éntok Amónta, Amón éntok Josíasta. ");
INSERT INTO mfy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconíasta üusek, entok ä sailahuam. Huámëi taahuarimmet éntok, jume Israeliitam úttiapo Babilooniau bíchaa nuksákahuak. ");
INSERT INTO mfy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Huanäi Jeconías Salatielta üusek, Salatiel éntok Zorobabelta. ");
INSERT INTO mfy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiudta üusek, Abiud éntok Eliaquimta, Eliaquim éntok Azorta. ");
INSERT INTO mfy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadocta üusek, Sadoc éntok Aquimta, Aquim éntok Eliudta. ");
INSERT INTO mfy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazarta üusek, Eleazar éntok Matánta, Matán éntok Jacobta. ");
INSERT INTO mfy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob Joséta üusek, Maríata kuuna. Íachi éntok Jesús yeu yoremtuk, jü Cristo. ");
INSERT INTO mfy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Júnakoy Abrahamta jiápsay naateka Davidta jiapsäu tájti guoj mamni áma naikimme, jume nat sáu tómti kateme. Davidta jiápsay naateka israeliitam Babilooniau bíchaa úttiapo nuksákahuakäu tájti guoj mamni áma naikimme; entok israeliitam Babilooniau bíchaa úttiapo nuksákahuakäpo naateka Cristota yeu yoremtukäu tájti kéchim guoj mamni áma naiki. ");
INSERT INTO mfy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristota yeu tómtekäu ínel yeu siika: Ä áyehua María Joséta kunaseka áutukay; të kee jee náu am jiápsayo abe asoaka yeu siika, Espíritu Santota bétana. ");
INSERT INTO mfy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Të José, Maríata kunasëihui Diosta bíchäpo lútüla jiápsa, huatem bíchäpo kaa tiusi ä tahuanakë béchïbo éhuil ä tö simbáarey. ");
INSERT INTO mfy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Të áapörik ínëli ä éaysu Diosta ángel tenkuriapo áu yeu machiak huanäi ínel au jiaahuak: —José, Davidta üusi, katë májhueka Maríata jubiapo mabeta; bueïtuk jü Maríata tómpo asoa bárëu, Espíritu Santota bétana huéiye. ");
INSERT INTO mfy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Huanäi ili usi outa asoanake, entok Jesús të ä téhuaanake, bueïtuk Áapo ä pueblohua jínëuriata am máknake bem Dios bejrim bétana. ");
INSERT INTO mfy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sïme ïri yeu siika Señorta nokakäu chúpnakë béchïbo profeetata huämi ínel ä jíako: ");
INSERT INTO mfy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Én éntok jü jámut beme abe asoaka tahuanake huanäi ili outa asoanakë; entokim Emanuel ti ä téhuaanake; itom nokpo: “Dios itomaki”, tiau báare. ");
INSERT INTO mfy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Huanäi José búsaka, ángelta nésahui yáuhuak, ä jámut mabetaka. ");
INSERT INTO mfy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Të kaa ä jubeka bénasi amak jiápsak, bueïtuk kësam huëpo ili usi outa Maríata ä asoau tájti; huanäi Jesús ti ä téhuaatuak. ");
INSERT INTO mfy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Júnakoy Jesús yeu yoremtuk Belén pueblopo jum Judea buiärapo, ímechi taahuarimmet Herodes áma réytukay. Huanäi jume jita täyame magom täata yeu huë bétana kateka Jerusaléniu yájjak, ");
INSERT INTO mfy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ínel jíaka: —¿Jáksu aane, jü judíommeu réy yeu yoremtulame? Bueïtukte itom buiärapo aneka ä chókihua bitchak, én éntokte äbo yáij‑la ä yöri báreka. ");
INSERT INTO mfy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Íkäi jíkkajaka, jü réy Herodes kaa yánti ée táytek, entok sïme Jerusalénpo jóakame két áamaki. ");
INSERT INTO mfy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Huanäi am núnutebok jume tiöpopo chë nésahueme, jume pueblopo jïojteleerom entok jume Moiséjta ley am mamajtíame. Huanäi am nátemajek jákun yeu ä yoremtunakëhui, juka Cristota. ");
INSERT INTO mfy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bempo éntok ínel ä yómmiak: —Belén pueblopo Judea buiärapo; bueïtuk ínel ä jïojtek, jü profeeta: ");
INSERT INTO mfy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Empo éntok, Belén pueblo, Judá buiärapo joome, katë chë ilitchi, jume Judea buiära pueblom násuku; bueïtuk emót yeu huéenake, jü gentetapat huéenakeme, juka ín pueblo Israelta suayanakeme. ");
INSERT INTO mfy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Huanäi Herodes jume magom éhuil núnnuk, sïmeta bétana huitti am temaij báreka, jauhuey juka chókita yeu machiakähui. ");
INSERT INTO mfy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Huanäi Belén pueblou lúl‑la am katchahueka, ínel ámeu jiaahua: —Ámanem sájaka sïmeta nátemaje, ïri ili usi outa bétana. Huanärem ä téakätek nee téjhuaanake, bueïtuk áman sikane két ä yörinake. ");
INSERT INTO mfy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Huanärim bempo réyta jíkkaijsuka sájjak. Jü chóki éntok täata yeu huë bétana bem bíchakäu ámepat huéesimey. Áman am yáijboy ili usita anë béppa taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Juka chókita bíchakam tüisi al‑lëiyak. ");
INSERT INTO mfy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Huanärim káriu kimuka ä bitchak. Juka ili usita ä áye Maríatamaki. Ímïrim tónommia jápteka ä yörek, entokim tómita béjrek étapoka ä miikak, oro tómita, inciensota entok mirrata. ");
INSERT INTO mfy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chúkula jüneehuame tenkupo ámeu yeu machiak, kaa Herodestau bem nóttinakëhui. Huanärim bem buiärau bíchaa nóttek täbui böochi. ");
INSERT INTO mfy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Chúkula bempörim sákasuko, jü Señorta ángel tenkupo Josétau yeu machiak. Huanäi ínel áu jiaahuak: —Yejtekë juka ili usita nüye, ä áyemaki. Huanäre Egiptou bíchaa siime. Ámanïrë taahua, enchi ín téjhuäu tájti; bueïtuk rey Herodes juka ili usita më báanake. ");
INSERT INTO mfy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Huanäi José búsaka, juka usita entok ä áyehua nüka, huäri tukaarit Egiptou bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Huanärim áman taahuak, Herodesta mukëu tájti, juka Señorta nokakäu chúpnakë béchïbo, profeetata ínel jíakähui: “Egipto bétana nä núnnuk, juka ín Üusi.” ");
INSERT INTO mfy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Huanäi rey Herodes jume magom bétana áu junneriahuak tíaka tüisi öomtek. Huanäi sïme ili usi ohuim súatebok, guoy huásuktiriam kóm bíchaa huériame, pueblo Belémpo joomem entok áa chíkola, juka tiempota magom nokakäu ámet ä jüneakä pámani. ");
INSERT INTO mfy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Huanäi áu chúppak, juka profeeta Jeremíasta nokakähui, ínel ä jíakähui: ");
INSERT INTO mfy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá pueblopo jíkkaijtuk, jü jiokot jíahui entok buanhuame: Raquel ä asoam béchïbo buaanay, entok kara jíapsi yejtey, bueïtukim béja kókkolamtukay. ");
INSERT INTO mfy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Të chúkula juka Herodesta muksuko, Señorta ángel tenkupo Josétau yeu machiak Egíptopo, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Yejtekë ili usita nüye, entok ä áyehua. Huanäre Israel buiärau bíchaa huéiye, bueïtukim kókkosuk, jume ili usita më báreïhui. ");
INSERT INTO mfy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sep yejteka, ili usita nüka, entok ä áyehua. Huanäi Israel buiärau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arquelao Judea buiärapo réytukay, ä áchay Herodesta réytukaïpo. Íkäi jíkkajaka májhueka taahuak, áman huée béchïbo. Të tenkupo jüneehuamta jípurek; huanäi Galiléa buiärau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ímï yepsaka áma jóatek, jum Nazaret pueblopo, bueïtuk ínëli áhuä chúpanakë béchïbo, jume profeetam nokakähui, nazareeno tä téhuaanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huámechi taahuarimmet Juan Bautista áma yepsak mékka ánia see päria Judeapo, Diosta noki noksimeka ");
INSERT INTO mfy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ínel jíaka: —Emóem jíapsi kúaktia, bueïtuk téhuekapo Dios réy nésauri äbo jëla ansime. ");
INSERT INTO mfy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ïri ájäria jü profeeta Isaíasta áa bétana nokakähui, ínel jíaka: Mékka ánia see päriapo chay noki jikkaijtuk: “Señorta böomem nanahuitte, éntokem jume ili böom rútuktia.” ");
INSERT INTO mfy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan camello bóata sánkokay, entok huakäbiata huikosakay; ä buäyeu éntok buere guöchim entok mumu sitörimtukay. ");
INSERT INTO mfy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Huanäi jume Jerusalénpo, Judeapo, entok Jordán bathue mayoat jóakame sïmetakam áu yeu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bem Dios bejrim am yeu buíseko, áapo am batöay jum Jordán bathuepo. ");
INSERT INTO mfy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juebena pariserom entok saduseom áu yájjay, emo batö ïaaka. Juan am bíchaka ínel ámeu jiaahuak: —¡Bakot asoarim bénnam! ¿Jábesu júkäi enchim téjhuak, juka ára enchim ä tö tennëhui, juka Diosta ómtiraa äbo huémta bétana? ");
INSERT INTO mfy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","¡Jü enchim jíapsi kúaktiläu, júyata türim takä bénasi enchimmet jünakiachitunake! ");
INSERT INTO mfy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Katem enchim jiápsipo emo jábele: “Abrahamtatte yeu kat‑ria” ti éaka, bueïtuk ínenne enchimmeu jiaahua: Dios ímï tétampo ára áma yam kattua, jume Abrahamta üusim. ");
INSERT INTO mfy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Entok kétchi, jume tépuam béjam jípuhua, júya nahuam chúktiä béchïbo; bueïtuk sïme júya kaa türik takame chúktiahuaka tájiu jímmaana. ");
INSERT INTO mfy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lútüriapo, ínapone bäampo enchim batöa, jíapsi kúaktihuamta enchim jípunakë béchïbo; të hua íno sáu huéeme, katchanne júne ä bocham huériapo yúmala, Diosta bétana Áapo ino béppa chë úttiärata jípureka nésahue. Áapo, Espíritu Santoy enchim batönake, entok tájiyi. ");
INSERT INTO mfy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jü tirijkom áy huijhuijtiahuame ä mámpo óorek; erata éntok tútenake, tirijkom éntok náu tójaka, báchiam ëeriahuäpo am ërianake; juka tirijko ótata éntok táanake, jum táijta kaa tutukëpo. ");
INSERT INTO mfy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Huanäi Jesús Galiléa buiära bétana huéeka Juantau yepsak, jum Jordán bathuepo, áapörik ä batö ïaaka. ");
INSERT INTO mfy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Të Juan kaa báarey, ínel jíaka: —Émpë nee batöpo yúmala. ¿Én éntoke émpoisu inou huéiye? ");
INSERT INTO mfy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Të Jesús ä yómmiak, ínel jíaka: —Júnëlë ä tójja, bueïtuk türi sïmeta Diostau bíchaa lútula huémta itom chúpanakëhui. Huanäi Juan ínel ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús entok batösuhuaka, bäapo yeu simlataka jikau ä huey téhueka áu étapok. Huanäi juka Diosta Espíritu bitchak, áa béppa guókouta bénasi kóm huémta. ");
INSERT INTO mfy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jíahui nooki téhueka bétana jíkkaijtuk, ínel jíaka: —Ïri ín Üusi tüisi ín nákëhui; áa bétanane tüisi al‑leiya. ");
INSERT INTO mfy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chúkula jü Espíritu Santo Jesústa núk siika, mékka ánia see päriau bíchaa. Ímïri jü diablo kaa türikuy ä jíöbila báarey. ");
INSERT INTO mfy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta taahuarim entok tukaarimmak náuhui kaa jïbuäk; huanäi tébäurek. ");
INSERT INTO mfy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Huanäi jü yore jioptua báreme áu yepsaka ínel áu jiaahua: —Empo Diosta Üusitukätek, ímëi tétammechë nésahue, am páanimtunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Huanäi Áapo ä yómmiak, ínel jíaka: —Diosta nooki jïojteri ínel jiaahua: “Kaa buähuamtay jíba jiápsa, jü yoreme, ál‑la sïme nokta Diosta bétana huémtayi.” ");
INSERT INTO mfy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chúkula jü diablo buere joära Jerusaléniu bíchaa ä núk siika. Huanäi tiöpot chë mejikat ä jämutuak. ");
INSERT INTO mfy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Huanäi ínel áu jiaahua: —Empo Diosta Üusitukätek, kömë emo tójja. Bueïtuk jïojteri: Ángelesim emou bíttuanake; bem mámammea enchi tóboktianake, em guókim kaa tétat tëitinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús ínel áu jiaahua: —Két ínel jïojteri: “Katë juka em Dios Átchay jíöbila báare.” ");
INSERT INTO mfy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Huanäi jü diablo júchi ä núk siika, jum káhuit mejikachikun bíchaa. Huanäi sïme huaka ániapo réyim jípureu ä bíttuak, entok juka musäla ujyória áusülik. ");
INSERT INTO mfy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huanäi ínel áu jiaahuak: —Íkäine sïmeta enchi máknake, inou tónommia kíkteka enchi nee yöreko. ");
INSERT INTO mfy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Të Jesús ínel áu jiaahua: —¡Simëe, Satanás! Bueïtuk Diosta jïojteri ínel jiaahua: “Em Dios Áchaytë yörinake, éntoke ä nésahui jíba jonake.” ");
INSERT INTO mfy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Huanäi jü diablo ä tö siika. Sep éntok jume ángelesim áu yájaka ä aniay. ");
INSERT INTO mfy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús, Juanta pereesotukäu jíkkajaka, Galiléau buiaräu nóttek. ");
INSERT INTO mfy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret pueblopo yeu sika, Capernáum pueblou yepsak. Huanäi ímï jóatek, bahue mayoachi, Zabulón entok Neftalí buiärapo. ");
INSERT INTO mfy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bueïtuk áhuä chúpanakë béchïbo, juka profeeta Isaíasta nokakähui, ínel ä jiäpo: ");
INSERT INTO mfy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón entok Neftalíta buíya, bahuéu bíchaa böo, Jordán bathue huáytana, Galiléa buiärapo kaa judíom jóakaïpo. ");
INSERT INTO mfy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jü pueblo kaa machikuu aneïhui, buere machiriata bitchak; entok jume mukia jékka kaa machikuu rejteka kókkolatukaïhui, machiria ámeu yuumak. ");
INSERT INTO mfy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Júnaköi naateka Jesús ámeu nok táytek, ínel jíaka: —Emóem jíapsi kúaktia, bueïtuk Diosta réytaka nésahueu béja äbo jëla ansime. ");
INSERT INTO mfy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Huanäi Jesús Galiléa bahue mayoat hueramaka, guoyim bitchak emo sailakame: Simmom, Peero ti téhuakäme, entok Andrés ä sailahua. Bahuepom jítërim jímmay, bueïtukim kuchuleromtukay. ");
INSERT INTO mfy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Huanäi ínel ámeu jiaahuak: —Ino sáukem kaate; ínapone kuchuleromsi enchim yáanake, yorememmehui. ");
INSERT INTO mfy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Huanäi bempo sep bem jítërim tójaka, áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chë huam jëla huéeka, júchi guoyim bitchak, emo saylakame: Jacobo Zebedeota üusi, entok Juanta ä saylahua. Barcopom bem áchay Zebedeotamak aaney, jítërim chäbuaka. Huanäi am núnnuk. ");
INSERT INTO mfy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bempo éntok barcota entok bem áchayhua tójaka, sep áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Huanäi Jesús sïme Galiléapo naa siika, bem sinagogampo am majtiaka, juka tü nokta Diosta réytaka nésahue bétana huémta, entok sïme kökoata entok kökosi éehuamta am úhuay, jum pueblompo. ");
INSERT INTO mfy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Türi nooki áa bétana nokhuame sïmekut jüneriahuak, Siria buiärapo. Huanärim áu nüpahuak sïme jume ják huanteme, kaa al‑leaka sirokame bem kökoa bétana, kaa pappeame, lemooniom jípureme, táij múkëram, entok káraktilame. Ímëi sïmem bem kökohua am úhuak. ");
INSERT INTO mfy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huanärim yuun áa sáu sájjak, Galiléa buiärapo joomem, entok Decápolis buiära bétana, Jerusalén pueblo bétana, Judea buiära bétana, entok bathue Jordán huáytana bétana. ");
INSERT INTO mfy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús juebena genteta bíchaka, káhuit jikau siika huämi yejtek. Huanäi ä discíipulom áu yájjak. ");
INSERT INTO mfy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Huanäi am majtia táytek, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Yúmalasim al-leenake, huame espíritupo poloobem, bueïtukim téhuekapo Diosta réytaka nésahuepo jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Yúmalasim al-leenake, jume buaname, bueïtuk Diosta bétanam jíapsi jóaana. ");
INSERT INTO mfy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Yúmalasim al-leenake, jume yánti emo nüyeka kaa emo jábeleme, bueïtukim Diosta bétana ania buíata attiapo mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Yúmalasim al-leenake, jume tebäureme entok ä bäimukeme, juka lútula huémta, bueïtuk bempom yúmalasi ä mákna, juka ámeu bëyemta. ");
INSERT INTO mfy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Yúmalasim al-leenake, jume yore nák jiokoleme, bueïtuk bempo két ä mabetnake, juka yore nák jiokolihuamta Diosta bétana. ");
INSERT INTO mfy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Yúmalasim al-leenake, jume Diosta bíchäpo emo jíapsi báksialame, bueïtuk bempom Diosta bínnake. ");
INSERT INTO mfy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Yúmalasim al-leenake, jume yánti jíapsihuamta huatem béchïbo huáatiaka jíapsame, bueïtuk bempom Diosta üusimpo näikiatunake. ");
INSERT INTO mfy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Yúmalasim al-leenake, jume lútüriapo lútula huémta béchïbo guók jájjahuame, bueïtuk bempom ä áttiaka tahuanake, juka téhuekapo Diosta réytaka nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yumálasem al-leenake eme, jiokot ino béchïbo kaa bíbitpehuame, ino béchïbo guók jájjahuäteko entok sïme hua kaa türi enchim bétana kaa lútüriataka nokhuäteko. ");
INSERT INTO mfy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Al‑leäem chíkti enchim jíapsimaki, bueïtuk jü téhuekapo enchim mabetnakëu, sïmek béppa béj‑re, bueïtuk jume profeetam enchimpat kat‑riam, guók jájasuakam jiokot bít-huak. ");
INSERT INTO mfy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Emem ímï buíapo oona. Të ïri ona juka chökorata tärukäteko, ¿jáchisu júchi ára chökorata jípunake jäni? Kaa türika tatahua, ál‑la päkun yeu guötiahuaka, yoremem át naa kannake. ");
INSERT INTO mfy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Eme, ániachem machiria. Jü buere jóära káhuit jikat kátekame kara ésotu. ");
INSERT INTO mfy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bueïtuk kaabe machiriata nüka kajonta bétuk ä mámana, ál‑la jikat ä órenake, ínëli jume sïmem jóapo aneme ä machirianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Machiriatem ínëli jípure, yoremem bíchäpo, bueïtuk bempom juka türik enchim joäu bíchaka, enchim Áchay téhuekapo kátekamtam úttileka ä yörinake. ");
INSERT INTO mfy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Eme jamak ley nésauta entok profeetam jïojteri kaitapo tahuaria báreka nee äbo yebij‑la ti éiyay. Kanne kaitapo ä tahuaria báreka yebij‑la, ál‑la ä huë páman ä chúpa báreka. ");
INSERT INTO mfy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bueïtukne lútüriapo ínel jiaahua, téhuekata entok buíata ketune bíttuyo, huépul letra entok huépul punto júne kaa yeu tahuanake, juka leyta huë páman sïmeta áhuä chúpäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ínëli jábetaka junne, juka leypo nésauta chë ilitchik kaa yáakätek, entok ínëli huatem majtiakätek, ilitchisi jípuna, jum téhuekapo réy nésauta ayukäpo. Të jábetaka junne, juka ley nésauta yáakätek, entok ínëli huatem majtiakätek, huatem béppa chë ériana, jum téhuekapo réy nésauta ayukäpo. ");
INSERT INTO mfy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bueïtukne ínel enchimmeu jiaahua, jü lútula huëpo enchim joäu kaa jume escriibam entok pariserom joäu béppa chë türiakäteko, kaibem áman kimunake, jum téhuekapo réy nésauta ayukäpo. ");
INSERT INTO mfy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Akem ä jíkkaij‑la, juka bannaataka kat‑riammeu nokhuakamta: “Kaabetë mënake. Të jábe junne jábeta mëakätek, yäurata mámpo bétte noki át chúpatunake.” ");
INSERT INTO mfy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tëne ínel enchimmeu jiaahua, jábe junne ä sailabeu öomtekäteko, yäurata mámpo bétte noki át chúpatunake; entok jábetaka junne ä sailahua jájana, aahuame yäura conciliota mámpo yéchatunake. Entok kétchi, jü kaa suamsi bétte nokta jábetat nokakame infiernou táijta béetëu ä huéenakeu át chúpatunake. ");
INSERT INTO mfy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Bueïtuk empo juka Diostau bíchaa em näikiari, tiöpo altariu ä tóijseka áman yebisiseka huëtek, huanäi huämi áu huáhuaatekäteko, jabetamak júne émomak kaa tüisi tahualatukähui, ");
INSERT INTO mfy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","huämïrë ä tójja, juka Diostau bíchaa em näikiari jum tiöpo altarpo; huanäre nótteka áu emo jiokoreka áamak emo tüte. Huanäre nótteka, juka Diostau bíchaa em näikiari áu óóre. ");
INSERT INTO mfy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Jábeta emou omtemta ä yäura bít báareyo, ketune böot náu kateka läutë áamak emo tüte, kee yäurata mámpo enchä yéchayo; bueïtuk jü emou omteme juezta mámpo enchi yéchanake; íri éntok porista mámpo, enchi páttianä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lútüriapone ínel emou jiaahua, ímïre kaibu yeu huéenake, bueïtuk sïmeta juka em huikiriäu em béjtuäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Akem ä jíkkaij‑la, juka bannaataka nokhuakamta: “Jubekame entok kunakame katem täbuimak jíapsinake.” ");
INSERT INTO mfy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Të ínapone ínel enchimmeu jiaahua jábetaka junne täbui jámutta bíchaka ä ukulekame, ä jiápsipo ä jubeka tatahua. ");
INSERT INTO mfy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Íäri béchïbo em bátatana puusim kaa türikum bíchaa enchi am náyote máchirëteko, yehuë am huíkeka mékka am jímma; bueïtuk chë türinake éläposë huépul pusim täru të katë sïme takaamak infiernou táijta kaa tutukëu jímmaatunake. ");
INSERT INTO mfy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Entok jume em bátatana mámmam kaa türikum bíchaa enchi am náyote máchirëteko, akë am chúktiaka mékka am jímma; éläposë huépul mámam täru, të katë sïme takaamak infiernou táijta kaa tutukëu jímmaatunake. ");
INSERT INTO mfy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Akem ä jíkkaij‑la, bannaataka nokhuakamta: “Jábetaka junne ä jubi jímmaakame juezta bíchäpo jiösia divorciota ä máknake.” ");
INSERT INTO mfy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Të ínapone enchimmeu ínel jiaahua ä jubi jiösia divorciota ára ä mákka, täbui yoremtamak áhuä náyotelatuko. Kaa ä junëlituko, ä jubi jiösia divorciota ä mákame, täbuimak emo náyotehuäpo kúlpaka ä tatahuatua; entok jábe juka jímmaata jubekame két jíba júkäi kúlpata huériunake. ");
INSERT INTO mfy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Entok kétchi, akem ä jíkkaij‑la, bannaataka kat‑riammeu nokhuakamta: “Juka em nokakäu Diosta bíchäpo katë kía kaitapä tahuaria báare; ál‑lë juka em nokakäu chúpa báreka úttiata yáuhua.” ");
INSERT INTO mfy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Të ínapone ínel enchimmeu jiaahua lútüriata nok béchïbo, katë yörisi machik bát kéecha. Téhuekatë kaa bát kéecha, bueïtuk Dios nésahueka áma káttek. ");
INSERT INTO mfy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Entok buíata junne, bueïtuk Dios áa béppa guókeka káttek; Jerusalénta júne kaa bát kéecha, bueïtuk íkäi buére jóäraata jü Réy sïmem béppa nésahueme, ä áttiak. ");
INSERT INTO mfy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Em kóba júne kara bát kéecha, lútüriata nok béchïbo, bueïtuk empo huépul chonta junne, karë tósalisi ö chukulisi ä yáuhua. ");
INSERT INTO mfy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Bueïtuk jü enchim nokäu huépülaytunake jíbba: “Jehui, jehui”, ö “Ëe, ëe”; bueïtuk jü huate íäri béppa büruk nokhuame, kaa türik bétana huéeka tatahua. ");
INSERT INTO mfy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Akem ä jíkkaij‑la, juka nokhuakamta: “Senu jábeta pusim tärutuakame két pusimmey ä béjtuanake; entok senu jábeta támim ä tärutuakame két támimmey ä béjtuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Të ínapone ínel enchimmeu jiaahua: Juka kaa türik emou joamta, katë ä béj báare; ál‑la bátatana jópemmet enchi ä chóchonak, senu jópeme áu óóre. ");
INSERT INTO mfy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Entok két jábeta yäurapo enchi yeu tójaka súpem enchi ä úhua báarey, em béppa súpeme két ä mákka. ");
INSERT INTO mfy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Entok jábeta senu kilometropo püaktiriata úttiapo enchi huéria ïaay, guoy kilometropë áamak huéiye. ");
INSERT INTO mfy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Entok juka jita emou nétanemta, Akë ä miika; entok juka jita emou rerehuemta, Akë ä mákka. ");
INSERT INTO mfy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Akem ä jíkkaijsula, juka nokhuakamta: “Emo náapo anemtë náknake, të juka enchi béj‑reka éamta, Akë ä omtianake.” ");
INSERT INTO mfy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Të ínapone ínel enchimmeu jiaahua: Jume enchim béj‑reka éame, akem am nákke; jume béttek enchimmet nokame, Diosta tü éähuem am nétanria, jume enchim omtíame tühuatem am jorianake; entok jume jiokot enchim joame, Diostahuem am nok‑ria. ");
INSERT INTO mfy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Huanärem itom Áchay téhuekapo kátekamta üusimtunake, bueïtuk Áapo tü yóremem entok kaa tü yóremem béchïbo, täata yeu sisimtua; entok lútula jiápsame entok kaa lútula jiápsame béchïbo júne yúyuktua. ");
INSERT INTO mfy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Të eme jume enchim nákeme jíba nákëtek, ¿jitasem áma kobanake? Bueïtuk jume yäura tómita náu tóij‑leerom két júkäi johua. ");
INSERT INTO mfy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Entok eme jume enchimmak huerim jíba tebotuätek, ¿jachu buére éehuäpo huétche, jü enchim joähui? Bueïtuk jume kaa Diosta súaleme, kéchim júkäi johua. ");
INSERT INTO mfy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaita yeu bëakem yúmalasi emo jípure, juka enchim Áchay téhuekapo kátekamta yúmalasi áhuä jípurë bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Juka lútula huémta johuäpem emo suaya yoremem bíchäpo kía bempörim enchim bít ïaaka. Ä ínëlituk juka enchim yöokahuem kaa mabetnake, enchim Áchay téhuekapo kátekamta bétana. ");
INSERT INTO mfy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Empo limojnätek, katë pito jíahuita bénasi ä chaaye, bueïtuk ínëlim ä jojoa, jume kaa tü yoremtaka emo tü yóreme tíame, bem sinagogapo entok böommechi emo bít ïaaka, yoremem bétana emo úttilnä béchïbo. Lútüriapone ínel jiaahua, bempom béja ä mabet‑la, juka bem kobalähui. ");
INSERT INTO mfy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Të empo limojnätek, jü míköri kaa jüneenake, juka bátatana em joähui. ");
INSERT INTO mfy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bueïtuk em limojnäu kaabe ä jüneríanake; ál‑la Dios, Áapo kaabeta bíchäu bíchame, juka em kobakäu enchi máknake, sïmem bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Empo éntok oraciompo Diostau nokätek, katë huame huitti Dios huáateme mamatomta bénasi am báare; bueïtuk bempom juka oraciompo nokhuamta tüisi musäule, sinagogampo jäbueka entok böo ejkinampo, jume yoremem am bít ïaaka. Lútüriapone ínel jiaahua, béjam ä jípure juka yölataka bem kobalähui. ");
INSERT INTO mfy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Të empo, oraciompo Diostau nokätek, káripë kibakeka, puertata páttia. Huanärë oraciompo Diostau nooka. Éläposu áma aneka kaa bíttu, bueïtuk ínëli jü em Dios Áchay kaabeta bíchäpo bíchame, sïmem bíchäpo em kobari enchi máknake. ");
INSERT INTO mfy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Empo éntok nokaka oraciónta joätek, katë kía juebénasi nát béppa nooka, huame kaa Diosta súaleme bénasi; ímëri juebenak nokaka Diostam am jíkkajä bénasi éiya. ");
INSERT INTO mfy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Eme éntok katem áme bénasi aane, bueïtuk enchim Dios Átchay jüneiya jita enchimmeu bëyëhui, kee jee enchim áhuä aahuayo. ");
INSERT INTO mfy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bueïtuk eme éntok, ínëlem oraciónta jonake: Itom Átchay téhuekapo kátekame, em téhuam santotaka täyahua. ");
INSERT INTO mfy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jü em réy nésauri ito násuk itomaktunake; jü em jo ïäu ímï buíapo yáatunake, téhuekapo bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Jume páanim chíkti táapo itom buäyëhui, én itom buänakëhue itom mákka. ");
INSERT INTO mfy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Itom Dios bejrimmeche itom jiokore, jáchin jume kaa türik itou yáalame, itom jiokorë bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Katë jum juënakuu itom jijiöbila, ál‑lë kaa türiku itom yeu huíkke. Bueïtuk émpë ä áttiak, juka réy nésauta entok juka úttiäraata, entok juka looriata, sïme huásuktiriampo. Júnentunake. ");
INSERT INTO mfy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Të eme jume huate yoremem, juka kaa türik enchimmeu yáakäu, am jiokorekäteko, jü enchim Áchay Dios téhuekapo kátekame két enchim jiokorinake. ");
INSERT INTO mfy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Të jume huate yoremem kaa enchim jiokoreko, jü enchim Áchay Dios jü Dios bej‑ribet, két kaa enchim jiokorinake. ");
INSERT INTO mfy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Eme ayuunäteko, katem Dios huáateme mamato bénasi báare, sirokamta pújbaka, bem ayuunä bétana huatem am jüneria ïaaka. Lútüriapone ínel jiaahua, bempom béja juka bem kobaläu yöla. ");
INSERT INTO mfy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Të empo ayuunaka Diosta yörëteko, emoë pújba báksiaka kóbat jita emót teeka, ");
INSERT INTO mfy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","jume yoremem kaa emochä bínnakë béchïbo juka em ayuunähui; ál‑la jü em Áchay áma aneka kaa bít-huame. Ïri em Áchay kaabeta bíchäu bíchame, sïmem bíchäpo em kobari enchi máknake. ");
INSERT INTO mfy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Katem ímï buíapo tómita nat yécha báare, téepärim anëpo entok jita momoyëpo, entok jume lak‑roonim áman kimuka jita ëekbuäpo. ");
INSERT INTO mfy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ál‑lem téhuekapo náchä yétcha juka tómita béppa béj‑rek; ímïri jume téepärim entok jita junne kaitam momoiya, entok jume lak‑roonim kara áman kiimu jita ékbuä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bueïtuk juka béj‑remta enchim jípurëpo, huämi jíba annake jü enchim jíapsi. ");
INSERT INTO mfy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Jume pusim, takaa am machiriak; júntuksan jume em pusim türiako, sïme em takahua machiriay tápuninake. ");
INSERT INTO mfy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Të em pusim kaa türiako, sïme jü em takaa kaa machikuu annake. Të ínëli jü machiria em takat ayukame kaa machitukäteko, ¿jáchisu tepa chukuri jäni jü kaa machiria emót ayukame? ");
INSERT INTO mfy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Kaabe ára guoyim teeko, nana beu nésauta am joriaka, bueïtuk huépülakuu öomtinake jü senumak éntok al-leenake. Juka senuk yörinake; senuk éntok kaa jatterianake. Nana beu kara ä johua Diosta nésahui entok rikotuhuamta. ");
INSERT INTO mfy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Íäri béchïbo, ínenne enchimmeu jiaahua: Katem jáchin emo éetua jü jáchin enchim jíapsinakë béchïbo, jita enchim buänakë béchïbo, jita enchim jïnakë béchïbo, entok takaahuat jita enchim sánkonakë béchïbo. ¿Jachu jü jíapsihuame kaa buähuamta béppa chë ériahua, entok jü takahua sánkota béppa chë bát huéiye? ");
INSERT INTO mfy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Téhuekahuem remteka huikichim bitcha: Katim ëecha entokim kaa etta tóboktia. Júnentaka junne enchim Áchay Dios téhuekapo kátekame am jíjïbuätua. Të eme, ¿Jachem kaa chë béj‑re, ímëi huikichim béppa? ");
INSERT INTO mfy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Entok, ¿Jábesu enchim násuk úttiata joaka senu téchompo ára áu yötutua jäni? ");
INSERT INTO mfy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Entok jatchiakem sánkota bétana kaa yuuma? Jume liirio sehuamem bitcha: Buíapom síhuilataka yoyötu, kaa jijjoaka entok kaa tekipanuaka. ");
INSERT INTO mfy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tëne ínel enchimmeu jiaahua, jü réy Salomón yún ujyóriata áttiaka junne kaa áme bénasi ujyorisi áu sánkotuak. ");
INSERT INTO mfy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Të ïri júya ániat yötulataka senu táapo áma óreka yokoríapo tájiu guötiana; të Dios ä súpetua. ¡Eme yoremem kaita súalëram! ¿Jachu kaa enchimmeu chë júne ára tühuata yáa jäni? ");
INSERT INTO mfy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Én éntok katem jáchin emo éetua, ínel jíaka: “¿Jítasute buänake jäni?” entok, “¿Jítasute jïnake jäni?” entok, “¿Jítasute sánkonake jäni?” ");
INSERT INTO mfy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bueïtuk jume Diosta kaa súaleme, íkäi ániat ayukamtam jíba jária; të enchim Áchay Dios téhuekapo kátekame jüneiya, íkäi sïmeta enchimmeu bëyëhui. ");
INSERT INTO mfy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Të tua bátchu, akem ä jariunake, juka Dios réytaka ä nésahuëhui, entok lútula huémta; huanäi jü huate enchimmeu bëyeme, kía áapola enchimmeu ayu táytinake. ");
INSERT INTO mfy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Huä taahuari äbo huémtachem kaa jáchin éiya; jü yoko äbo huéeme két ä nüpanake, juka áapola kaa át yúmahuamta. Bueïtuk ínëli jü chíkti taahuari juka obisi éehuamta huéria. ");
INSERT INTO mfy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Katem kía jábetat nooka, kaa enchimmet nok ïäteko. ");
INSERT INTO mfy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bueïtuk ïri huatemmet enchim nokäu enchimmet két nónokna, entok jü huatem enchim áy jujünaktëu emem két áy jünaktena. ");
INSERT INTO mfy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jatchiakasë juka ili chukta täbui pújpo órekäu bitcha, juka júya chë buëuruk em pújpo órekäu éntoke kaa bitcha? ");
INSERT INTO mfy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jáchisu júntukë täbuikuu jiaunake: “Bátchu chúkta pújpo em jípurëune enchi yeu huik‑ria báare”, empo éntok em pújpo juka júya chë buëuruk jípureka? ");
INSERT INTO mfy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Empo juka Dios huáatihuamta mamatome! Báchë juka júya buëuruk em pújpo jípurëu yeu huíkke. Huanäre tüisi bíchaka tahuanake juka ili chúkta täbui pújpo jípurëu yeu huik‑riä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Katem juka santosi täyahuamta chüummeu guötia báare, entok katem jume perlam béj‑reme kohuimmeu guötia báare, bueïtuk ímëri ámechim chépteka am jámtianake, entokim enchimmeu kúakteka enchim kíkkisunake. ");
INSERT INTO mfy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Entok jibem jita aahua, huanärem ä mákna; entok jibem jita jaria, huanärem ä téunake; jiben puertata poona, huanärem ä étaporiana. ");
INSERT INTO mfy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bueïtuk jábe junne jíba jita aahuame, ä mabetnake; entok jíba jita jariame ä téunake, entok jü jíba puertata poname ä étaporiana. ");
INSERT INTO mfy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Jábe yoremesu juka ä üusihua páanim áhuä aahuayo tétata ä máknake? ");
INSERT INTO mfy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Kúchuta áhuä aahuay éntok bakotta ä máknake jäni? ");
INSERT INTO mfy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eme, kaa tü yórememtaka junne, enchim üusimem türik mámaka, të chë junne jü itom Áchay Dios téhuekapo kátekame tühuata am máknake jume áu jita aahuame. ");
INSERT INTO mfy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ínëli, juka sïmeta yoremem enchimmeu yáa ïäu ánëlem ámehua yáuhua; bueïtuk jü Moiséjta ley entok jume profeetam ínëlim nookak. ");
INSERT INTO mfy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Puerta näulay pámanem kiimu. Bueïtuk jü puerta bueeka entok jü böo emo täruhuäu bíchaa yore huériame, ïri böochi juebénakam át kaate; ");
INSERT INTO mfy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","bueïtuk jü puerta näulay entok jü böo junne jíapsihuäu bíchaa yore huériame; íkäi böotam kaa jaikikam ä téulataka át kaate. ");
INSERT INTO mfy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Profeeta ára nókïchiram bétanem emo suaya. Bueïtukim kabaram bénasi sánkoka enchimmeu yáijnake, tem bem sánko bétuk robom bénasi yoyolim. ");
INSERT INTO mfy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jíta bem joähuem bíchaka ámet jüneenake, júya huíchärat kaibu páras takam át téuna, entok chuna takam junne. ");
INSERT INTO mfy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Júya türi, türim tataka, të jü júya kaa türi kaa türim tataka. ");
INSERT INTO mfy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jü júya türi kara kaa türim taaka, entok jü júya kaa türi két kara türim taaka. ");
INSERT INTO mfy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sïme júya kaa türik takame chúktiahuaka táijta béetëu jímmaana. ");
INSERT INTO mfy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Júnëlem bem takammey am täyanake. ");
INSERT INTO mfy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Katim sïme huame “Señor, Señor”, ti inou jíame áman kimunake, jum téhuekapo Diosta réytaka nésahuepo, ál‑la hua ín Áchay Dios téhuekapo kátekamta nésahui joame. ");
INSERT INTO mfy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Júnakoy taahuata yúmako juebénakam ínel inou jiaunake: “Señor, Señor, ¿jachute kaa em téhuampo em noki profeciá nokpo ámeu nookak? Entokte em téhuampo jume lemooniom yeu béebak, entokte em téhuampo juka kaa jaibu jojohuamta yáuhuak, milagro téamta.” ");
INSERT INTO mfy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Huanäine ínel ámeu jiaunake: “Jauhuey júnene kaa enchim täyak. ¡Mékkem kaate, eme kaa türik jíba joo tékilekame!” ");
INSERT INTO mfy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Jábetaka junne ín noki jíkkajaka entok ín nésahui joame, yoreme tü éehuamta jípuremtamakne ä näikianake, ä kári yáaka tétata ä nahuatuakamtamaki. ");
INSERT INTO mfy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Huanäi yúk táyteka, bathuem tápunak entok jekamak huéeka ä béb táytek, íkäi kárita; të kaa huétchek, bueïtuk tétatat kutti ä nahuakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Të jábetaka junne ín noki jíkkajaka, të kaa ín nésahui yáakame, jü yoreme kaa tü éehuamta jípuremtamakne ä näikianake, hua sëeta béppa káatekamtamaki. ");
INSERT INTO mfy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Huanäi yúk táyteka, bathuem tápunak entok jekamak huéeka ä béb táyteka ä tátabek, íkäi kárita; ínëli huécheka tüisi jiokot machisi taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chúkula Jesústa ámeu noksuko, jume áma aneme, juka jábeta yörihuäpo ä bäsulekam taahuak, bem majtiahuakä bétana, ");
INSERT INTO mfy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","bueïtuk Áapo yäura úttiata jípuremta bénasi am majtiay, të kaa jume escriibam bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesústa júya káu bétana kömä siiko juebena gente áa sáu kaatey. ");
INSERT INTO mfy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huanäi senu yoreme tüisi takahuat sähuaka leprä tíamta jípureka áu yepsaka tónommia áu kíkteka, ínel áu jiaahuak: —Señor, empo júnel éäteko, arë nee tüte. ");
INSERT INTO mfy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús mám rútukteka át mámtek, ínel jíaka: —Jeehui, júnelne éiya; türiäe. Huanäi jü leprata jípureme sejchúkti kaita jípureka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Huanäi Jesús ínel áu jiaahua: —¡Juyú! Katë jábeta téttejhua, ál‑lë áman huéiye, jü tiöpopo nésahuemtahui. Juka Diosta baysahueka tiöpou totoijhuamtë áman huéria, Moiséjta nésahuekä pámani, bempörim jüneenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Capernaum pueblou Jesústa yebisiseyo, senu centurión sontarommeu yäut áu rukteka jiokot áu jiaahuak, ");
INSERT INTO mfy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ínel jíaka: —Señor, jü ín sáhuëhui ín jóapo böka káraktilataka, kökosi kaa huéeläpo áu ínnëaka. ");
INSERT INTO mfy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Huanäi Jesús ínel áu jiaahuak: —Ínapone áman sika kökoata ä úhuaanake. ");
INSERT INTO mfy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Të sontarommeu yäut ä yómmiaka ínel áu jiaahuak: —Señor, kanne ín jóata bétuk enchi mabetpo yúmala; ál‑lë kía nokta téhua; huanäi jü ín sáhuëu türinake. ");
INSERT INTO mfy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bueïtuk ínapone yóremtaka huatem ino béppa nésahueme jípure, entokne sontarom ín nésahue bétuk jípure. Huanäi senuk jákun nee ä jaasek áman sisime; juka senuk éntok: “Binë huéiye”, ti nee áu jiay inou sisime; juka ín sáhuëu jita nee ä yáa sáhuey, ä jojoa. ");
INSERT INTO mfy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Huanäi Jesús ínel ä jiay ä jíkkajaka, áa bétana buére ëeak. Huanäi ínel ámeu jiaahuak, jume áa sáu katemmehui: —Lútüriapone ínel enchimmeu jiaahua, pueblo Israelpo júnene kaa ä téula, juka Diostat úttesi éehuamta. ");
INSERT INTO mfy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Inenne két enchimmeu jiaahua, juebénakam yáijnake, täata yeu huë bétana entok täata áman huéchë bétana; huanärim Abrahamtamak, Isaactamak entok Jacobtamak jotenake, jum téhuekapo Diosta réytaka nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Të huame Diosta üusimpo näikiatukaïhuim, päkunim kaa machikun yeu bébna; ímïrim kökosi éaka buannake, emo tám kumeka. ");
INSERT INTO mfy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Huanäi Jesús sontaro yäuttau ínel jiaahuak: —Ámanë huéiye, bueïtuk em ä súalekä páman yáatunake. Huanäi huämi orapo jü jóapo sáyhuame sep türilataka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Perota jóau yepsak. Huanäi Perota asu bitchak, táij huécheka bökamta. ");
INSERT INTO mfy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Huanäi mámpo áachä mámtek, jü táij huéchiria ä tójjak; huanäi yejteka jita am joria táytek. ");
INSERT INTO mfy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Të chúkula tukariu yúmako, juebénakam lemooniom jípureme áu nüpahuak; huanäi jü nokiy jume lemooniom yeu béebak, entok jume kökoreme sïmem tütek, ");
INSERT INTO mfy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","jukä profeeta Isaíasta nokakäu chúpnakë béchïbo, ínëli ä jiäpo: “Áapo juka itom kökoa nüka entok itom kökosi éäu núk siika.” ");
INSERT INTO mfy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús juka genteta áa chíkola anemta bíchaka, nésahuek bahue huáytana bíchaa kat béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Senu escriiba áu yepsaka ínel áu jiaahuak: —Maestro, jákun em huëu bíchane émomak huéenake. ");
INSERT INTO mfy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús ínel áu jiaahuak: —Jume ayesim buía guojökum jóuhuak; jume huikichim éntok toosak; të ínapo jü Yoremta Üusi jita mútekaka ín bönakeu júnene kaa jípure. ");
INSERT INTO mfy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Täbui, ä disciipulohua ínel áu jiaahuak: —Señor, nechë licensia áman sika bát ín áchay ín mäanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús ínel ä yómmiak: —Ino sáukë huéiye, Akë am tójja eläpo jume kókkolam bem kókkolam mäanake. ");
INSERT INTO mfy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Áapörik barcopo jämuko, ä discíipulom áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Huanäi buere jéka bahuepo áu tóboktiak; jume bäa máresim éntok röakteka barcotam patpattiay; të Áapo kótchey. ");
INSERT INTO mfy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ä discíipulom áu yájaka ä bússak, ínel jíaka: —Señor, ¡itomë jínëu, bueïtukte abe kókko! ");
INSERT INTO mfy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Áapo ínel ámeu jiaahua: —¿Jatchiakasem májhue, eme yoremem kaita súalëram? Huanäi yejteka, jü jekatau entok bahuetau kutti nónokak; huanäi sïme yánti taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Huanäi jume yoremem áa bétana buére éiyay, ínel jíaka: —¿Jábesa ïri yoreme, juka jekata entok bahueta sáhueme? ¡Ímëi éntok ä nokäu johua! ");
INSERT INTO mfy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ínëli bahue mayoa huáytana ä yepsako, gadarenom buiapo, guoyikam ä nánkek, lemooniom jípureka, ánimam mamahuäpo yeu sákalataka; jujuëna jéjjeyhuiaka chuu yoyolim bénaaka. Íäri béchïbo ïri böot kaabe ára áma huam huéiyey. ");
INSERT INTO mfy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Huanärim chay nónokak, ínel jíaka: —¿Jítasë itomak jípure, Jesús, Diosta Üusi? ¿Jachë itom kaa pappeetua báreka äbo yepsa, ketune kee tiempota yúmaisu? ");
INSERT INTO mfy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ímï éntok ili ámeu mékka juebena kohuim áma jïbuä sásakay. ");
INSERT INTO mfy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Huanäi jume lemooniom jiokot áu nookak, ínel jíaka: —Itom yeu béebakäteko, huame kohuimmechë itom kimutua. ");
INSERT INTO mfy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Huanäi Áapo ínel ámeu jiaahuak: —Ámanem kaate. Huanäi bempo yeu sájaka kohuimmet kiímuk; ínëli sïme huame kohuim siba bénëku ámanim bahuéu kón huátteka áma kókkok. ");
INSERT INTO mfy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Huamë kohuim suayaïhui éntok tennek. Huanärim buere jóärau yájaka sïmeta ettejhuak, jáchin jume lemooniom jípureïhui jita ámeu yeu sikähui. ");
INSERT INTO mfy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Huanäi sïme jume buere jóäraapo jóakame, Jesústam nankirika yeu sájjak. Huanärim ä bíchaka jiokochim áu jiaahuak, bem buíäraapo yehuä huée sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Huanäi Jesús barcopo jämuka, baubäa huáytana bíchaa siika. Huanäi ä pueblou yepsak. ");
INSERT INTO mfy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ímïri am aneyo, senu yoreme káraktilataka áu nüpahuak, ä jípetekpo bösimeka. Huanäi Jesús Diostat éehuamta ámet bíchaka, jü káraktilatau ínel jiaahuak: —Katë kóm éiya, ín üusi; em Dios bejrim bétanë jiokorihuak. ");
INSERT INTO mfy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huanäi jume escriibam bem jiápsipom ínel jiaahuay: “Ïri Diosta béj‑reka nooka.” ");
INSERT INTO mfy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Të Jesús am jüneriaka jita éehuamta am jípureïhui huanäi ínel ámeu jiaahuak: —¿Jatchiakasem kaa tüisi éiya enchim jiápsipo? ");
INSERT INTO mfy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bueïtuk, ¿jita nokisu chë kaa obiachi: “Em Dios bejrimmeche jiokorihua”, ö “Yejtekë náa huéiye”? ");
INSERT INTO mfy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bueïtuk enchim jüneenakë béchïbo, juka Yoremta Üusi ímï buíapo úttiata ä jípurëhui, jume Dios bejrim ä jiokorinakë béchïbo. Huanäi jü káraktilatau ínel jiaahua: —Yejtekë juka em jípetekta nüka, em jóau bíchaa huéiye. ");
INSERT INTO mfy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Huanäi áapo yejteka, ä jóau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jü gente éntok ä bíchaka, áa bétanam buere éiyay. Huanärim Diosta úttiley, yoremem úttiata am mákakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús áma huan huéeka ä bitchak juka yoremta Mateo ti téhuaakamta, yäura tómita náu totoijhuäpo bankopo kátekamta. Huanäi ä núnnuk, ínel áu jíaka: —Ino sáukë huéiye. Huanäi kíkteka áa sáu siika. ");
INSERT INTO mfy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ínel yeu siika, huämi jóapo, Áapo mesau kátekay, jume yäura tómita náu totojame kéchim áma yájjak, entok huate yoremem kaa türik joaka jiápsame. Huanärim Jesústamak mesau jotek, entok ä discíipulommaki. ");
INSERT INTO mfy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jume pariserom íkäi bíchaka, ä discíipulommehuim ínel jiaahuak: —¿Jatchiaka jü enchim Maestro ámemak jïbuä, jume yäura tómita náu totojammaki entok jume kaa türik joaka jiápsammaki? ");
INSERT INTO mfy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús íkäi jíkkajaka ínel ámeu jiaahuak: —Jume kaa kökoreme katim mérikota huáatia; të jume kökoreme ál‑la. ");
INSERT INTO mfy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sájakem át suaka ä bitcha, jáchin ä jiau bárëhui: “Emo nák jiokolihuamtane huáatia; kaa animaalim súahuamta.” Bueïtuk kanne huame Diosta bíchäpo lútula jíapsame jínëu báreka yebij‑la, ál‑la Dios bejrita joame, emo am jíapsi kúaktianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Huanäi jume Juanta discíipulom áu yájjak, ínel jíaka: —¿Jatchiaka ítapo entok jume pariserom juebénasi äayuna, em discíipulom éntok ëe? ");
INSERT INTO mfy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús ínel ámeu jiaahuak: —¿Jachu jum emo jubiahua pajkopo núnurim sirokaka áma annake jäni, juka jubemta ketune ámemak aneyo? Ëe, të taahuari yúmanake, jüka jubemta bem uhuanähui, huanäi ál‑lam ayuunanake. ");
INSERT INTO mfy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Kaabe súpe mueram sánko bemelamey am chäbuänake; bueïtuk jü sánko beméla báksiahuakätek náu simnake, huanäi chë buekasi síutinake. ");
INSERT INTO mfy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Entok kétchi jü vino bemela kaa huakäbia bóosa örapo tottöhua, ínëli yáahuakätek jü huakäbia bóosa öram síusiute; jü vino entok guötinake, entok jü huakäbia bóosa kaa türika tatahua, të jü vino bemela, huakäbia bóosa bemelaku tottöhua. Huanäi ínëli náu bibinhuatu. ");
INSERT INTO mfy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Të bát íkäi áapörik ámeu nokaysu, senu judío sinagogapo tekiakame áma yepsaka áu tónnommea kíktek, ínel jíaka: —In maala jübuëla muukuk; të áman sika áa béppa enchi mámtek jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Huanäi Jesús kikteka, áa sáu siika, ä discíipulommaki. ");
INSERT INTO mfy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ínëli ä huéesimey, senu jámut dooce huásuktiapo ójbo át yeu huéeka kökoreme áma bétana áu rúktek. Huanäi ä sánkobet mámtek. ");
INSERT INTO mfy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bueïtuk áapo ä jiápsipo ínel éiyay: “Kíane ä sánkobet mámtek junne, türilatakane tahuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huanäi Jesús kúakteka ä bíchaka ínel áu jiaahuak: —Empo jámmut, katë kóm éiya. Jü Diostat em éäu enchi tütek. Huanäi naateka jü jámut türilataka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús éntok sinagogapo tekiakamtau jóau kibakeka am bitchak, jume baka kusiammey jiponame entok juka genteta naa múksi kaa huéeläpo anemta. ");
INSERT INTO mfy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Huanäi ínel ámeu jiaahuak: —Yehuem kaate, bueïtuk ï usi jámut kaa mukila, ál‑la kótche. Huanärim ä junneriay. ");
INSERT INTO mfy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Të juka genteta yeu sákatuasuk, áman kibakeka, mámpo ä buíssek. Huanäi yejtek, jü ili jámmut. ");
INSERT INTO mfy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jü ímï yeu sikame sïme buíärat buéresi jüneriahuak. ");
INSERT INTO mfy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesústa áma huam huéeyo, guoy liliptim áa sáu sájjak, chay nokpo ínel jíaka: —¡Itomë nák jíokole, empo Davidta Üusi! ");
INSERT INTO mfy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Të ínëli jóau ä yepsako, jume liliptim áu yájjak. Huanäi Jesús ínel ámeu jiaahuak: —¿Jachem ára íkäi nee yáa máchile? Huanäi bempo inëlim áu jiaahuak: —Jehui, Señor. ");
INSERT INTO mfy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Huanäi pújpo ámet mámtek, ínel jíaka: —Enchim ä súalekä páman enchimmeu yáatunake. ");
INSERT INTO mfy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Huanäi bem pusim étapotaka taahuak. Jesús éntok tüisam téjhuak, ínel jíaka: —Huitti nokhuäpo íkäi kaabe ä jüneríanake. ");
INSERT INTO mfy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Të bempo huämi buiärapo yeu sájaka, sïmetam nok táytek, buéresi jita ä joähui. ");
INSERT INTO mfy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chúkula bempörim yeu kateyo, huépul muro áu nüpahuak, lemooniota jípureka. ");
INSERT INTO mfy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Juka lemooniota yeu béebiak, jü muro nookak. Jü gente éntok áa bétana buére éaka ínel jiaahuay: —Ímï Israel buiärapo, ¡jauhuey júne kaa bíttuk jü én itom bíchähui! ");
INSERT INTO mfy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Të jume pariserom ínel jiaahuay: —Jume lemooniommeu yäutta téhuampo jume lemooniom yeu bébba. ");
INSERT INTO mfy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ámet naa huéiyey buére pueblommet entok ili pueblommechi, bem sinagogampo am majtiaka juka réy nésaupo evangeliota; takaa huantiriata entok kökoata pueblopo bem jípurëu am úhuak. ");
INSERT INTO mfy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ínëli juka genteta juebenak bíchaka, am jijiokolek, bueïtukim kía tóijtaka chíbejtilatukay, kabaram kaa kabyerokä bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Huanäi ä discíipulommeu ínel jiaahuak: —Lútüriapo jü et chúpila juebenna, të jume áma tekipanuame éntok kaa jaiki. ");
INSERT INTO mfy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Áhuem nooka, Señor etta áttiakamtahui, bueïtuk tekipanuanakeme etta ayukäu am bíttuanake. ");
INSERT INTO mfy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Huanäi jume ä dooce discíipulom núnuka, úttia yäuraata am mákkak jume lemoonio espíritu chïcha machim yeu am bébnakë béchïbo, entok jume huantiriam jípureka kökoreme am tütenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ímërimme jume dooce apóstolim téhuam: Bát huéeme jü Simmom tíame, Peero ti téhuaakame, entok Andrés ä sailahua, Jacobo Zebedeota üusi, entok Juan ä sailahua, ");
INSERT INTO mfy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Toomas, Mateo jü publicano, Jacobo Alfeota üusi, Lebeo jü Tadeo ti két téhuaakaïhui, ");
INSERT INTO mfy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Símmom jü cananista entok Judas Iscariote, ä nénkinakëihui. ");
INSERT INTO mfy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ímëi doocem áman bíttuak. Huitti am téjhuak, ínel jíaka: —Jume kaa judíom böommechem kaa kannake, entok samaritano jóärahuem kaa kimunake. ");
INSERT INTO mfy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ál‑lem israelita jóammet bát kannake, jume kabaram bénasi emo tärulammehui. ");
INSERT INTO mfy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ámanem kateka ä nooka, ínel jíaka: “Jü téhuekapo réy nésauri äbo jëla huéiye.” ");
INSERT INTO mfy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kökoremem tüte, lepra sähuakame kétchi; kókkolamem jíabitetua, lemooniomem yeu béeba. Kíalem mikpo ä mabet‑la; ínëlem huatem ä miika. ");
INSERT INTO mfy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Enchim huikoj bóosapem juka tómi sahualita, tómi tósalita, cobre tómita, katem áma ä huériunake. ");
INSERT INTO mfy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Éntokem kaa bóosapo nüuka boojonake, éntokem kaa guoy sánkota huériunake, entok kaa guoy páares boocham, entok bóroniata junne; bueïtuk jü tekipanuame buähuamta kía ä mabetnakë béchïbo, lútüriata jípure. ");
INSERT INTO mfy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Të ják junne buére jóärapo, ö ili jóärapo enchim kimunakepo, nátemajëem jábesu áma Diosta bétana enchim mabetpo yúmala. Huanärem áma taahua, enchim áma yeu sákäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Entok jum jóapo enchim yájäpem am tebotua. ");
INSERT INTO mfy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Huanäi jume ímï jóakame enchim am mabetpo yúmalatuk, jü yánti éaka enchim Dios huáatëu ámemaktunake; të kaa enchim am mabetpo yúmalatuk, jü yánti éehuaka enchim Dios huáatëu enchimmeu nóttinake. ");
INSERT INTO mfy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Të jábe ä jóapo kaa enchim mabetakätek, entok juka enchim nokäu kaa jíkkajakätek, yehuem kaate huämi jóapo ö buére jóärapo, huanärem enchim guókpo juka tóröchiata tátake, Diosta noki kaa am mabetaka béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Lútüriapone ínel enchimmeu jiaahua, júnak táapo juka bette nokta chúpeyo, chë júne jiokot machinake, jume ímï jóärapo jóakame béchïbo, bueïtuk Sodoomapo entok Gomoorrapo jóakame béppa. ");
INSERT INTO mfy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ínapone enchim kabaramtukä bénasi robom násukun enchim bíttua. Eme éntok jáchin juka bakotta ára áhuä suaya bénasem emo suaya, entok jáchin juka guókouta kaitau suaka yánti ä jiapsä bénasem emo nüye. ");
INSERT INTO mfy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yoremem bétanem emo suaya, bueïtukim yäura conciliou enchim yeu tóijnake, entokim bem sinagogampo enchim bemmuchatebonake. ");
INSERT INTO mfy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gobernadorim entok réyesim bíchäpem yeu tóijna, enchim nee súalë béchïbo. Inëlem juka ino bétana huémta ámeu noknake, bempörimmehui entok kaa judíommehui. ");
INSERT INTO mfy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Të yäuraata mámpo joahuak, katem jáchin éiya, jita enchim noknakëhui; bueïtuk huämi horapo akem ä mákna, jita enchim noknakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bueïtuk eme katem enchim éäpo noknake, ál‑la jü enchim Áchay Espíritu enchim tempo yeu ä huéetuanake, juka nokta. ");
INSERT INTO mfy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Sailakame ä sailahua yäura mámpo tóijnake ä mënä béchïbo; jü áchayri éntok ä üusihua; usiarihuam éntok bem áchayrim béj‑reka jáptenake, am súanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sïmetakam enchim omtianake ín téhuam béchïbo; të jábe ä jiapsäu tájti kaa áu náyoteme, ïri jínëutuna. ");
INSERT INTO mfy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ímï buére jóärapo Diosta enchim súalë béchïbo omtiahuätek, täbui jóärau bichem kaate, bueïtukne lútüriapo ínel enchimmeu jiaahua: kee jee jume buére jóärau israelitammet enchim naa katchuy, jü Yoremta Üusi yebijnake. ");
INSERT INTO mfy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Jü majtiahuame kaibu ä majtiakamta béppa chë yörisi machinake; jü tekokame júne kaibu ä teko béppa bát huéenake. ");
INSERT INTO mfy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jü majtiahuame ä majtiakamta bénasi áu jípu báanake; jü tekokame két ä teko bénatu báanake. Jü familiapo áchaytam Beelzebú tíiya; jume jóapo usiarim éntok chë júnem buére áuna. ");
INSERT INTO mfy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Juari béchïbo, katem am májhue; jü ésotaka ayukame jíba jüneriana, entok kaa bíthuäpo órekame júne két jüneriana. ");
INSERT INTO mfy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Juka kaa machikuu enchimmeu ín nokäu, emëem machikuu ä nooka; entok juka lauti kaa kusisi nákampo enchim jíkkajäu, kárichem jikat jämuka huatemmeu kusisi ä nooka. ");
INSERT INTO mfy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Entok katem am májhue jume takaata ára mëame, tem juka jíapsita kara mëa; Diosta ál‑lem majhuë, huaka jíapsita ára mëamta, entok juka takaata infierno béetëpo ára jímmamta. ");
INSERT INTO mfy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Éntokem át suuhua: ¿Jachu kaa ili guoy huikichim huépul ili tómipo nénenkihua jäni? Júnentaka junne, huépülaka júne kaibu buíau kón huénnake, itom Dios Áchayta kaa ínel éayo. ");
INSERT INTO mfy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Júnentaka junne, sïme enchim kóba chonim näikiarimme. ");
INSERT INTO mfy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Íäri béchïbo, katem májhue; eme chë júne béj‑re, yún ili huikichim béppa. ");
INSERT INTO mfy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Entok jábetaka junne yoremem bíchäpo nee täyatebome, ínapone két ä täyatebonake, ín Áchay téhuekapo kátekamta bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Të jábetaka junne yoremem bíchäpo kaa nee áu täya tíame, ínapone két kaa ino ä täya tíanake, ín Áchay téhuekapo kátekamta bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Të katem ínel emo éetua buíau kóm yebij‑la yánti jíapsihuamta huériaka; bueïtukne kaa yánti jíapsihuamta nüpa báreka yebij‑la, ál‑la ejparammea náu nássuahuamta. ");
INSERT INTO mfy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bueïtukne yebij‑la, juka yoremta ä áchaymak nok nássuatua báreka, entok juka jámut asoahuarita ä áyemaki, entok jüka jaborayihua ä asekamaki. ");
INSERT INTO mfy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jume ä jóapo yoremtamak aanim, akim ä béj‑reka áamak annake. ");
INSERT INTO mfy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ä áchayhua entok ä áyehua ino béppa nákeme, kaa ä jípupo yúmala, ínomak áhuä näikianakëhui; ánëli kétchi ä üusihua entok ä malahua íno béppa nákeme, két kaa ä jípupo yúmala, ínomak áhuä näikianakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Entok hua kaa ä kúruj püaktiaka íno sáu huéeme, két kaa ínomak áu näikiapo yúmala. ");
INSERT INTO mfy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ä jíapsihua jariaka ä tíakame ä tärunake; hua ä jíapsihua ino béchïbo tärukame éntok ä téunake. ");
INSERT INTO mfy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Jü enchim mabetame, nee mabeta; entok hua nee mabetame, Diosta nee äbo bíttuakamta mabeta. ");
INSERT INTO mfy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jü profeetata mabetame ä profeetatukä béchïbo, profeetata béjtuanä béekik mabetnake; entok hua lútula jiápsamta mabetame lútula ä jiapsä béchïbo, juka lútula jiápsaka béjtuanä béekik mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jábetaka junne senu vaaso sébe bäam jíba am mikakätek, ímëi ili usim ín discíipulomtukä béchïbo, lútüriapone ínel enchimmeu jiaahua, kaibu ä tärunake, juka ä béjtuanähui. ");
INSERT INTO mfy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Chúkula Jesús ä dooce discíipulom téjhuasuka jita am jonákë bétana, am majtiaseka yeu siika, ámeu nokaka bem jóäram beekatana. ");
INSERT INTO mfy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista cárcelpo káteka ä jíkkajak, Cristota joähui. Huanäi guoy ä discíipulom áu bíttuak, ");
INSERT INTO mfy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ä temay béchïbo: —¿Jachë empo ájäria jü yebijnakeme, ö täbuikte boobinnake? ");
INSERT INTO mfy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús ä yómmiaka ínel ámeu jiaahuak: —Ámanem sájaka Juanta téjhua, juka enchim jíkkajähui entok enchim bíchähui. ");
INSERT INTO mfy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jume liliptim bitcha, jume lolöim naa kaate, jume lepra sähuata jípureme türia, jume nanakapim jíkkaja, jume kókkolam jíabite, jume poloobemmeu éntok evangelio ámeu nokhua. ");
INSERT INTO mfy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yúmalasi al‑leehuamta jípunake, hua kaa inot tëitekame. ");
INSERT INTO mfy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chúkula bempörim sákayo, Jesús genteta ettejoria táytek, Juanta bétana: —¿Jábetasem bít báreka ánia see päriau yeu sájjak? ¿Bakata jekay yoohuamta? ");
INSERT INTO mfy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ö, ¿jitasem bít báreka yeu sájjak? ¿Yoremta musäla ujyorisi tápsiolai áu sánkotualata? Bueïtuk jume musäla ujyorosi emo sánkotualame, réyesim jóapom aane. ");
INSERT INTO mfy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Të, ¿jitasem bít báreka yeu sájjak? ¿Senu profeetata? Jehuiteriapone enchim téjhua, áapo chë profeetata béppa. ");
INSERT INTO mfy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bueïtuk íäri bétana jïojteri: Ínëline ínapo áman ä bíttua, juka ín nésahui émopat huériamta; Áapo juka böota tútenake, em huéenake pámani. ");
INSERT INTO mfy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Lútüriapone ínel enchimmeu jiaahua, jume jámuttat yeu yoremtulame násuku, kaabe Juan Bautistata béppa chë ériahuaka áu tóboktiala. Júnentaka junne, téhuekapo réy nésauta ayukäpo chë kaa ériahuame áa béppa chë yöhue. ");
INSERT INTO mfy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Juan Bautistata taahuarimet naateka én tájti, jü téhuekapo réy nésauri úttiata johua; jume ä nü báareme éntok úttiatam joaka ä nüye. ");
INSERT INTO mfy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bueïtuk sïme jume profeetam entok jü ley, Juanta yepsäu tájti, Diosta bétanam nookak. ");
INSERT INTO mfy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Én éntok, eme ä mabet bárëtek, áapo ínel jü Elías äbo yebijnakëïhui. ");
INSERT INTO mfy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jü jíkkaij béchïbo nákakame ä jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Am jábeta bénä tánake jäni, íkäi yóremraata? Jume usim jübua yoyötume bénamme; jume plaazapo joka bem jálaimmeu chayeme, ");
INSERT INTO mfy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ínel jíaka: “Baka kúsiayte enchim jiponriak, të katem yëka; entokte siroksi enchim buik‑riak, éntokem kaa buaanak.” ");
INSERT INTO mfy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Entok Juan két äbo yepsak, kaa jïbuäka entok kaita jëyeka; huanärem lemooniom ä jípurë tíiya. ");
INSERT INTO mfy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Huanäi ínapo jü Yoremta Üusi yepsak, sïmeta buäyeka entok sïmeta jëyeka; huanärem ínel jiaahua: “Jo ímï aane, jü yoreme jíbuära entok vino jëyëra; Diosta bejrim joame entok yäura tómita náu totójame amiigoka.” Të jü kóba súahua Diosta bétana lútula huéeme tüisi huéeka bíttunake. ");
INSERT INTO mfy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Huanäi kuttílasi ámeu nok táytek, jume buére jóärapo joomemmehui, bueïtuk juka buéresi yún jita ámeu ä yák junne, kaa emo am jíapsi kúaktiakä béchïbo. Huanäi ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Empo Corazín, jiokot machisi emou huéenake! Entok, ¡emohui Betsaida! Bueïtuk jum Tiropo entok jum Sidónpo jü buéresi johuame ámet yáahuakätek, enchimmeu ä yáahuakä bénasi, bínhua naatekam chukurik sánkoteka emo jíapsi kúaktiasu éiyey, entokim emo nápojtuaka bem sirokäu jüneriatebo éiyey. ");
INSERT INTO mfy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huäri béchïbone ínel enchimmeu jiaahua, Diosta bíchäpo yäura bít-huamta taahuari yúmayo, eme chë júnem jiokot emo bínnake, jume pueblom Tiropo entok Sidónpo jiápsame béppa. ");
INSERT INTO mfy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Empo pueblo Capernaum, téhuekau tájti emo tóboktia máchileka éame, bétukum infierno táijta béetëhuë kóm jímmaana. Bueïtuk jü buéresi emo násuk yáahuakäme, Sodoomapo yáahuakätek, én tájti buére jóäraatu éiyey. ");
INSERT INTO mfy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Íäri béchïbone ínel enchimmeu jiaahua, Diosta bíchäpo yäura bít-huamta taahuari yúmako, eme chë júne jiokot emo bínnake, Sodooma buiärapo jiápsakame béppa. ");
INSERT INTO mfy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Íkäi noksuka Jesús ínel jiaahuak: —Enchine úttile, ín Átchay, téhuekapo entok buíapo sïmem béppa yötaka nésahueme; bueïtuk jume kóba súakame entok jita täyame, íkäre am ésoriak. Huanäre jume ili usimmeu yä machiriak. ");
INSERT INTO mfy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jeehui, ín Átchay, bueïtuk émpë junëli ä türek. ");
INSERT INTO mfy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Sïmetaka im mámpo tóij‑ri, ín Áchay bétana; entok Diosta Üusiapo kaabe nee täya, ín Áchay jíbba, entok ä Áchayhua két kaabe ä täya; ál‑la ä Üusihua jíbba të Áapo huame ínel ä éäpo ä täya ïäu, ámeu yä machiria. ");
INSERT INTO mfy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Inohuem kaate, sïmetaka tekipanualataka lottilame entok püaktilame; ínapone enchim jimyoretuanake. ");
INSERT INTO mfy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Juka tékilta enchim ín mákähuem nüye, éntokem inot ä täya, juka lútüriata. Kanne béttek jiápsek, entokne yánti ino nüye; júnëlem enchim jiápsipo jimyorehuamta téunake. ");
INSERT INTO mfy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bueïtuk jü enchim ín boojoria ïau kaa obiachi; entok jü püaktiria kaa tua bétte. ");
INSERT INTO mfy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Huámëchi taahuarimmet Jesús tirijkom etpo áman huéiyey jimyore táapo. Ä discíipulom éntok tébäurey; huanärim tirijko bújam chúktiaka am buä táytek. ");
INSERT INTO mfy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jume pariserom am bíchaka, ínëlim áu jiaahuak: —¡Akem am bitcha, jó! Jume em discíipulom jimyore táapo kaa jojohuamtam johua. ");
INSERT INTO mfy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Të Áapo ínel am yómmiak: —¿Jachem kaa ä nok‑la, jum jïojteripo, jáchín juka Davidta ayukähui, áapo éntok jume áamak aneïhui tebäureka? ");
INSERT INTO mfy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bueïtuk, ¿jáchin jum tiöpopo kibakeka, páanim Diostau bíchaa näikiarim buäka, áapo entok jume áamak rejteïhui? Katim am buäpo yúmalatukay, ál‑la jume sacerdote tékilta tiöpopo joame jíbba. ");
INSERT INTO mfy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Jachem kaa ä nok‑la, juka leypo jïojteta, jáchin jum jimyore táapo, jume sacerdotem tiöpopom bem tékil jojoa, entokim kaa Diosta bejre? ");
INSERT INTO mfy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Júntuksanne ínel enchimmeu jiaahua: Senu ímï aane, tiöpota béppa chë yörisi machika. ");
INSERT INTO mfy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bueïtuk eme jüniäteko jáchin ä jiau bárëhui: “Juka yore nák jíokolihuamtane huáatia, kaa jume animaalim altarpo Diostau totoijhuamta”, huanäi ál‑lem kaa bétte nokta ámet nok éiyey, jume kaita kúlpakammechi. ");
INSERT INTO mfy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bueïtuk ínapo jü Yoremta Üusi jimyore táhuarita béppane yaurata úttia nesauta jípure. ");
INSERT INTO mfy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Huämi áman yeu sika bem sinagoogau yepsak. ");
INSERT INTO mfy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ímïri senu aaney, huakiam mámaka. Huanärim Jesústa nátemajek, ä nätua báreka: —¿Jachu lútula huëpo türi, jimyore táapo jábeta tüte béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Áapo ínel ámeu jiaahuak: —¿Jábesu enchim násuk senu yoreme huépülak kabaraka, jimyore táapo guójöku kóm ä huéchek, jachu kaa áu mámteka yeu ä huíknake jäni? ");
INSERT INTO mfy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ä ínëlitunakey, ¿jachu kaa chë júne béj‑re jü yoreme, kabarata béppa? Íäri béchïbo, türi jimyore táapo tühuata yáa béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Huanäi jü yoremtau ínel jiaahuak: —Em mámamë rútuktia. Huanäi áapo am rútuktiak; huanärim türilataka taahuak, jume senu mámam bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Chúkula jume pariserom yeu sájaka, náu ettejhuak, Jesústa më béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús íkäi jüneriaka, sékäna bíchaa siika. Huanäi juebena gente áa sáu sájjak, entok kökoreme sïmem tütey, ");
INSERT INTO mfy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","entok kuttílasi ámeu nookak, kaa yeu áu buíjnä bétana. ");
INSERT INTO mfy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bueïtuk junëli áhuä chúpanakë béchïbo, juka profeeta Isaíasta nokakähui, ínel ä jíako: ");
INSERT INTO mfy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jü nésauta nee joriame ímï aane; íkäine yeu púala, ín nákëhui; ín jíapsi áa bétana al‑leiya; ín Espíritune áa béppa órenake. Huanäi kaa judíommeu Dios yäura bít-huamta noknake. ");
INSERT INTO mfy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kaabetamak nok náassuanake, entok kaa chay noknake, entok kaabe ä nokäu jikkaijnake, jum böommechi. ");
INSERT INTO mfy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Juka sána ríutilata kaa bóula kóttianake, entok kántela pabiilo buiichiamta kaa tuchanake, áapörik lútüriata jípureka ä nésahuepo ä yosüu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jume kaa judíom éntok, ä téhuampom át éaka ä boobinnake. ");
INSERT INTO mfy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Huanäi senu lemooniota jípureme áu nüpahuak, líptitaka entok múurotaka; të Jesús ä tütek. Ínëli jü lípti entok múuro bitchak, entok nookak. ");
INSERT INTO mfy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Huanäi sïme gente át guómtilataka ínel jiaahuay: —¿Jachu ïri ájäria jäni jü Davidta Üusi? ");
INSERT INTO mfy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Të jume pariserom ä jíkkajakam ínel jiaahua: —Ïri lemooniom yeu bébba, jü Beelzebú lemooniommeu yäutta úttiärayi. ");
INSERT INTO mfy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús jünéaka jita bénak bem éaïhui, ínel ámeu jiaahua: —Sïme réy nación kaa nanabeu éaka emo näikimtelame lülüte, entok buére jóära ö kía jóuhua kaa nanabeu éätek, kaibum bínhua ára náu jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Entok jü Satanás, Satanásta yeu bébätek, áapo áu näikimtelataka tatahua. ¿Jáchisu júntuk bínhuatunake jäni, jü réytaka ä nésahuëhui? ");
INSERT INTO mfy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Bueïtuk ínapo Beelzebúta úttiäray lemooniom yeu bébätek, enchim üusim, ¿jábeta úttiäraysum yeu am bébba? Huäri béchïbo, jü enchim jiop‑läpo, bempom yäura juezta bénasi enchim yuktianake. ");
INSERT INTO mfy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Të ínapo Diosta Espíritu úttiäray lemooniom yeu bébäteko, tua lútüriapo enchimmeu yebij‑la, jü Diosta réytaka nésahuëhui. ");
INSERT INTO mfy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Bueïtuk, ¿jáchisu senu ára áman kibake, jü yorem úttiakamta jóahui, jita ä úhuä béchïbo, bueïtuk kaa bát ä súmakäteko? Huanäi ál‑la juka jóapo ayukamta ára ä úuhua. ");
INSERT INTO mfy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Jü kaa ínomak éame, nee béj‑reka jiápsa; hua kaa ínomak jita náu tójame, ä chíbejtia. ");
INSERT INTO mfy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Huäri béchïbone ínel enchimmeu jiaahua, sïme kaa tühua entok Diosta béj‑reka béttek nokhuame yoremem yáari, jiokorina; të jume Espíritu Santota béj‑reka béttek át nokhuame kaibu jiokorina. ");
INSERT INTO mfy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Entok jábetaka junne Yoremta Üusi béj‑reka nokakätek jiokorina; të jü Espíritu Santota béj‑reka béttek át nokame, kaibu jiokorinake, ímï buíapo entok áman téhuekapo junne. ");
INSERT INTO mfy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Jü júya türi, türik takanake. Të jü júya kaa türi, kaa türik takanake; bueïtuk jü júya ä takäpo täyana. ");
INSERT INTO mfy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Eme kaa tü yóremem bakot usiarïem! ¿Jáchisem türik noknake, kaa tü yórememtaka? Bueïtuk jiápsipo tápuni jü tempo yeu huéeme. ");
INSERT INTO mfy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jü tü yóreme ä jiápsipo türik ayukä béchïbo türik johua; jü kaa tü yóreme éntok, ä jiápsipo kaa türik ayukä béchïbo kaa türik johua. ");
INSERT INTO mfy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Të ínapone enchimmeu ínel jiaahua, sïme nokta jájana kaa türik yoremem nokakäu, Diosta bíchäpo yäura bít-huamta taahuari yúmakim jüneenake, kaa türik bem nokakähui. ");
INSERT INTO mfy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bueïtuk em nokakä bétana lútula huémta yáariana, entok em nokakä bétana bétte noki emót chúpana. ");
INSERT INTO mfy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Huanäi huate escriibam entok pariserom akim ä yómmiaka ínel jiaahua: —Maestro, juka kaa jaibu bít-huamta em joäute bít péiya. ");
INSERT INTO mfy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Huanäi Áapo am yómmiak, ínel jíaka: —Jü yóremraa kaa türik jiápseka ä jubimak kaa huépülsi áu nüyeme, Diosta ára jita joäu señalta aahua; tem täbui señalta kaa mákna, ál‑la huaka Jonás profeetatau yeu sikamta jíbba. ");
INSERT INTO mfy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bueïtuk jáchin jü Jonás báij táapo entok báij tukaapo buére kúchuta tópapo anekä bénasi, junëli kétchi ínapo jü Yoremta Üusi báij táapo entok báij tukaapo buíata bétuk annake. ");
INSERT INTO mfy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jume yoremem Nínivepo joomem, Diosta bétana yäura bít-huamta taahuarit yúmak, ïri yóremraa én kat‑riammakim emo tóboktianake, bétte nokta ámet chúpä béchïbo; bueïtuk bempom emo jíapsi kúaktiak, Diosta noki Jonásta ámeu nokako. Të én éntok senu ímï aane, Jonásta béppa chë yörihuame. ");
INSERT INTO mfy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Entok senu reina suriu jometaka, jü én kat‑ria yóremraatamak áu tóboktianake, Diosta bétana yäura bít-huamta taahuari yúmak, huanäi bétte nokta ámet chúpanake; bueïtuk áapo mékka buiära bétana yepsak, juka rey Salomónta tüisi jita täyäu ä jíkkaij báreka; të én éntok senu ímï aane, rey Salomónta béppa chë yörihuame. ");
INSERT INTO mfy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Jü lemoonio espíritu jaiti machi yoremtat yeu sikätek, huakia buíapo ansisimnake, áma ä jimyorenakeu jariaka; të kaa ä tíakäteko, ");
INSERT INTO mfy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ínel jiaunake: “In jóaune nótti báare, ín yeu sikähui.” Huanäi áman yepsakätek, kaabeta áma téunake, ál‑la chíchikta entok musäla yáata. ");
INSERT INTO mfy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Huanäi sika, guoy búsan lemooniom áa béppa chë mamachim nünake. Huanärim át kimuka áma jóatenake. Chúkula ïri yoreme chë júne machika tahuanake, bannaataka béppa. Ínëli kétchi ámeu yeu huéenake, jü yóremraa én kat‑riammehui. ");
INSERT INTO mfy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ínëli ketune gentetau ä nokayo, ä áyehua entok ä sailahuam päkunim aaney, áu nok báreka. ");
INSERT INTO mfy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Huanäi senu ínel áu jiaahua: —Em áiye entok em sailam päkunim aane, émomak nok báreka. ");
INSERT INTO mfy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Áapo ä yómmiak, juka ínëli áu jíamta. Huanäi ínel jiaahua: —¿Jábesu jü ín áiye? Entok, ¿jábesamme, jume ín sailam? ");
INSERT INTO mfy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huanäi ä discíipulommeu lúl‑la jikau mámteka, ínel jiaahua: —Ímïrim aane, jü ín áiye entok jume ín sailam. ");
INSERT INTO mfy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bueïtuk jábetaka junne ín Áchay téhuekapo kátekamta nésahui joame, jüri ín saila, ín huaayi, entok ín áiye. ");
INSERT INTO mfy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Huäri taahuarit Jesús jóapo yeu siika. Huanäi bahue mayoat yejtek. ");
INSERT INTO mfy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huanäi juebena gente áu náu yájjak. Áapo éntok barcopo kibakeka, áma yejtek. Jü gente éntok sïmetaka bahue mayoa see päriapo aaney. ");
INSERT INTO mfy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Huanäi juebenak am majtiak, ejemplommeyi ínel jíaka: —Jü et‑leero echíseka yeu siika. ");
INSERT INTO mfy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huanäi ä echay, huate báchia böo mayoat huáttek. Të huikichim áma yájaka ä buäka. ");
INSERT INTO mfy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Huate éntok tétam násuk huáttek, kaa yún buíata ayukaïpo. Huanäi läuti síuhuek, kaa yún ä buíakaï béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Të täata yeu sik tájjak, entok kaa ä nahuakaï béchïbo huaakek. ");
INSERT INTO mfy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Huate éntok huícham násuk huáttek. Huanäi jü júya huíchära yötuka, ä jíabi mëak. ");
INSERT INTO mfy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Të huate buía türikuu huáttek. Huanäi taakak; huépul báchia síhueka cien báchiam ámuek; jü senu éntok sesentam; senu éntok treintam. ");
INSERT INTO mfy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Jü jíkkaij béchïbo nákakame jikkaijnake! ");
INSERT INTO mfy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Huanäi jume discíipulom áu rúkteka, ínel áu jiaahuak: —¿Jatchiakasë ejemplommey ámeu nooka? ");
INSERT INTO mfy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Huanäi Áapo am yómmiaka ínel ámeu jiaahua: —Bueïtuk eme akem ä mák‑ri, juka enchim át jüneenakëhui, juka téhuekapo réy nésauta obiachisi maachik. Të bempörim éntok, ëe. ");
INSERT INTO mfy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bueïtuk jábe junne jita jípureme, chë júne huatek mákna; huanäi chë yún ä jípunake. Të jü kaita jípureme, juka ä jípurëu junne ä úuhuaana. ");
INSERT INTO mfy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Huäri béchïbone ejemplommey ámeu nooka; bueïtukim bíchaka kaa bitcha, entokim jíkkajaka kaa jíkkaja, entokim kaa át jüneiya. ");
INSERT INTO mfy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Júnëli ámet áu chúppa, jü profeeta Isaíasta nokakähui, ínel jíaka: Nákakem jíkkaijnake, të katem át jüneenake; éntokem bíchaka bínnake, të katem huitti át jüneenake. ");
INSERT INTO mfy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bueïtuk ï pueblota jíapsi námakaka tahuala; entokim náka páttilataka kaa jíkkaja; entokim bem pusim páttiala, pusimmey kaa bít béchïbo, entok nákammey kaa jíkkaij béchïbo, entok bem jíapsiy kaa am jüneenakë béchïbo. Të ínëline kaibu ára am anianake. ");
INSERT INTO mfy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Të yúmalasi al‑leeri enchimmet ayka; bueïtukem puseka bitcha, éntokem nákaka jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bueïtuk tua lútüriapone ínel enchimmeu jiaahua, juebena profeetam entok juebena lútula Dios huáateme, akim ä bít péaka taahuak, juka én enchim bíchähui; të katim ä bitchak. Entokim ä jíkkaij péiyay, juka én enchim jíkkajähui, të katim ä jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Akem ä jíkkaja eme, juka ejemplo et‑leerota bétana. ");
INSERT INTO mfy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bueïtuk jábe junne, juka réy nok nésauta jíkkajame, të kaa at jüniätek, íri báchiat böo mayoat ethuakamta bénna; bueïtuk jü diablo áu yepsaka, úttiapo ä úuhuanake, juka ä jiápsipo ethuakamta. ");
INSERT INTO mfy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Entok kétchi jü tétam násuk ethuakame, ïri júnen juka nokta jíkkajaka, sep läuti al‑leaka ä mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Të kaa tüisi naahuak; íäri béchïbo kaa bíbinhuatu; bueïtuk Diosta noki béchïbo obiachisi áu huée táytek entok kaa tüisi bít táytihuak, tëitinake. ");
INSERT INTO mfy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jü huícham násuk ethuakame, ïri júnen juka Diosta noki jíkkajakame; të jü ániat kaa yúmasi huéeme, entok jü yún bem tómi péäu, Diosta noki bem mabetakäu nánayote. Huanäi kaa tataka. ");
INSERT INTO mfy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Të jü türi buíapo ethuakame, ïri júnen nokta jíkkajaka át jünéakame. Huanäi takanake. Huépul báchia síhueka cien báchiam ámuenake; jü senu éntok sesentam; senu éntok treintam. ");
INSERT INTO mfy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Júchi täbui ejemplota ámeu nookak, ínel jíaka: —Jü téhuekapo réy nésahui, juka yoremta ä huajpo tü báchiata ä echakä bénna. ");
INSERT INTO mfy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Të seenu, tirijkom áttiakamta ée béj‑reme, tukaapo jume yoremem kócheyo, júya kaa türi báchiata tirijkom násuk echaka siika. ");
INSERT INTO mfy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Huanäi juka etta yötuka ä taka táytek, jü júya kaa türi két áma síhueka yötuk. ");
INSERT INTO mfy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Huanäi jume huajta áttiakamtau tekipanuame ínëlim áu jiaahuak: “Señor, ¿jache kaa báchiata türik áma eechak, em huajpo? ¿Játchiaka júntuk ket júya kaa türika áma síuhuek?” ");
INSERT INTO mfy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Huanäi áapo ínel ámeu jiaahuak: “Jábe nee béj éame íkäi yáuhuak.” Huanäi jume áu tekipanuame ínel áu jiaahua: “¿Jachë áman sájaka itom ä popón ïaa?” ");
INSERT INTO mfy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Áapo ínel ámeu jiaahuak: “Ëe, bueïtuk jáchin aykem juka júya kaa türik pónätek, két jume tirijkom áamak popónnake. ");
INSERT INTO mfy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Akem ä tójja; éläposu nánabeu yötunake, juka etta jójonaka ä tóboktiahuäu tájti. Huanäi jume tirijkom chúktia naatehuayo, ínapone am téjhuaanake, jume tirijkom chúktíame, báchem juka júyata kaa türik náu tójaka, lólopola ä súmma, ä táanä béchïbo; të jume tirijkomem náu tójaka am ëeria, jum íäri béchïbo kárita ín yáaläpo.” ");
INSERT INTO mfy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Júchi täbuik ejemplota ámeu nookak, ínel jíaka: —Jü téhuekapo réy nésahui, mojtaasa báchiata senu yoremta ä huajpo ä echakä bénna. ");
INSERT INTO mfy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Të ïri báchia lútüriapo sïme báchiam béppa chë ilitchi; të yötukätek sïme júya jíurim béppa chë yoyötu. Huanäi júya buëuruka tatahua. Ínëli jume huikichim téhueka bétana áu yájaka áma totosate. ");
INSERT INTO mfy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Júchi täbuik ejemplota ámeu nokaka, ínel jiaahuak: —Téhuekapo réy nésahui, levaduura jámutta nükäu bénna, báisi jünakteri ariinampo ä töak. Huanäi sïme náu küteka huécheka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús íkäi sïmeta ejemplommey ámeu nookak, jü gentetahui. Am majtiätek, ejemplommey jíba ä jojoay, ");
INSERT INTO mfy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","bueïtuk íkäi profeetata nokakäu áhuä chúpanakë béchïbo, ínel ä jíakähui: Ejemplommeyne ín teni étaponake, huaka ániata kësampo naateka ésotane étapoka ä jüneriatebonake. ");
INSERT INTO mfy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jume gentem sákatuasuka, Jesús jóapo kibakek. Huanäi jume discíipulom áu rúkteka, ínel áu jiaahua: —Itomë téjhua jáchin ä jiau bárëhui, juka júya kaa türi huajpo ayukamta ejemplo. ");
INSERT INTO mfy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Am yómmiaka Áapo ínel ámeu jiaahua: —Ínapo jü Yoremta Üusi jü tü báchiata echame. ");
INSERT INTO mfy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Huaj päria ínel jü ánia; jü báchia türi éntok, jume réy nésaupo usiarim; jü júya kaa türi éntok jü kaa tü yóreme diablo usiari. ");
INSERT INTO mfy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jü kaa türik echákame ínel jü diablo yore béj‑reka huéeme; jü tirijko chúpila tóboktiahuame éntok ánia lüteme; jume etta tóboktéame éntok ángelesimme. ");
INSERT INTO mfy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jáchin juka júya kaa türik popónhuaka ä táahuakahui, ilë bénanake, jü ánia lüteme. ");
INSERT INTO mfy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jü Yoremta Üusi ä ángelesim áman bíttuanake, jum réytaka ä nésahuëhui, jume kaa tühuata huatem jotuame entok jume kaa türik joame náu am tóijnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Huanärim ornota béetëu am guötianake. Ímïrim emo tam kumeka buannake. ");
INSERT INTO mfy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Huanäi jume yúmalasi Diosta nésahui joame, bem Áchay réytaka nésahuepom täa machiriata bénasim bélojkosi bíttunake. ¡Jü jíkkaij béchïbo nákakame jíkkaijnake! ");
INSERT INTO mfy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Entok kétchi jü téhuekapo Diosta réy nésauri tómi béjhuata júya päriapo ésota bénna. Huanäi senu yoreme ä tíaka, júchi ä éssok. Íäri béchïbo tüisi al‑leaka sïmeta ä jípurëu nénkaka, huanäi huákäi buíata jínnuk. ");
INSERT INTO mfy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Entok kétchi jü téhuekapo Diosta réy nésauri juka jábeta jita jinnü bénna. Ïri türi perlam jariaka am jíjinnu. ");
INSERT INTO mfy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huanäi juka perlata ujyolisi musäla machik téaka, sika sïmeta ä jípurëu nénkaka, ä jínnuk. ");
INSERT INTO mfy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ínëli kétchi jü téhuekapo Diosta réy nésauri jítërim bénna. Ímëri bahuéu jímmahuakätek, kúchum kaa nánälaim nunüye, tuttürim entok kaa tuttürim. ");
INSERT INTO mfy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Huanäi senu huëpo tápunakätek, mayoau bícham yeu huíhuikhua. Huämïrim joteka jume türim yeu püaka, huaripom am öore; jume kaa türim éntokim päkun yeu guöguötia. ");
INSERT INTO mfy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ilë bénanake jü ánia lüteme: jume ángelesim yeu kannake; huanärim jume kaa tühuata joame näikimtenake, jume yúmalasi Diosta nésahui joame násuku. ");
INSERT INTO mfy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huanärim horno béetëu guötiana; ímïrim emo tam kumeka buannake. ");
INSERT INTO mfy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús ínel ámeu jiaahua: —¿Jachem sïmekut jüniaka taahua? Huanäi bempo ä yómmiak, ínel jíaka: —Jeehui, Señor. ");
INSERT INTO mfy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Áapo ínel ámeu jiaahua: —Huäri béchïbo jü escriiba jü téhuekapo Diosta réy nésauri bétana tüisi áu majtialame, senu áchayhuariapo famiiliata bénna. Tómi béj‑remta áttiaka, bebëmelak entok kaa bebëmelak áma yeu huíike. ");
INSERT INTO mfy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ínëli huëpo chúkula, Jesús ejemplom am majtiasuka, áma yeu siika. ");
INSERT INTO mfy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Huanäi ä pueblo Nazareu notteka, am majtiay bem sinagogampo. Huanärim áa bétana buére éiyay, ínel jíaka: —¿Jáksu ïri ä nüka ä jípure, juka jita täyahuamta? Entok, ¿juka obiachik kara johuamta ä joähui? ");
INSERT INTO mfy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Jachu kaa ïri ájäria, jü carpinterota üusi? ¿Jachu kaa María ti téhuak, ä áyehua; entok ä sailam, Jacobo, José, Simmom entok Judas? ");
INSERT INTO mfy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Jachu kaa jume sïme ä huayim ímï itomak aane? ¿Jákübosu júntuk ïri íkäi sïmeta jípure? ");
INSERT INTO mfy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ä nokähuim kaa béj jóaka éiyay. Íäri béchïbo Jesús ínel ámeu jiaahua: —Sïme profeeta yörihua; të ä buiärapo entok ä jóapo, ëe. ");
INSERT INTO mfy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huämïri kaa yún ä yáuhuak, juka obiachisi kara johuamta ä joaïhui, bempörim kaa ä súale béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Júnaköri jü rey Heroodes tetrarca, Jesústa bétana buéresi nokhuamta jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Huanäi jume ä sáhuemmeu ínel jiaahua: —Ïri Juan Bautista kókkolam násuk jíabitelame; huäri béchïbo úttiäraata jípureka ára jita johua. ");
INSERT INTO mfy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Bueïtuk Heroodes, Juanta buíseka cadenammea ä súmaka carcelpo ä yéchalatukay, jámut Herodíasta béchïbo. Íkäi ä sailahua Felipe ä jubekay. ");
INSERT INTO mfy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan éntok ínel áu jiaahuay: —Katë ä jípupo yúmala, juka em saila juubi. ");
INSERT INTO mfy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodes éntok ä mëbáarey, të genteta májhuey; bueïtuk bempom Juanta täyay, ä profeetatukä bétana. ");
INSERT INTO mfy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Të Heroodesta huásuktiriam taahuareka pajkoyo, jü Herodíasta jámut asoa, sïmem bíchäpo yëka. Huanäi Heroodes ä türeka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Íäri béchïbo, ä chúpa rókaka nookak, jita ä ahuaü ä mák rókaka, ä obiachitu násuk junne. ");
INSERT INTO mfy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Áapo ä áye bétana bát téjhuaataka ínel jiaahuak: —Ímï puraatopë nee ä mákka, juka Juan Bautistata kóbba. ");
INSERT INTO mfy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Huanäi jü réy sirokaka taahuak; të juka nokta ä nokakäu úttiatukäu ä chúpnakë béchïbo, entok jume yörisi machim mesau áamak jokame bíchaka, nésahuek ä máknä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Huanäi nésahuek, carcelpo Juanta kóba chúktianä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huanäi jü kóbba, puraatopo nüpahuakä, jü ili jámut ä mákhuak; áapo éntok ä áyebeu ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Huanäi ä discíipulom áma yájaka, ä takaahua nüka ä maäk. Huanärim sájaka Jesústa ettejhuariak. ");
INSERT INTO mfy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús íkäi jíkkajaka, huépul barcota nüka áma yeu siika, sékäna mékka päriau bíchaa. Jü gente ä jíkkajaka guókimmeyim áa sáu sájjak, buére jóärampo naateka. ");
INSERT INTO mfy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huanäi Jesús yeu sika, juebena genteta bíchaka, am jijiokolek. Huanäi jume áme násuk kökoreme tütek. ");
INSERT INTO mfy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Béja tukariu yúma táytey, ä discíipulom áu rúktek, ínel jíaka: —Ímï kía päria, entok béja kúpte; Akë am sáka sáuhue, juka juebena genteta, bueïtukim pueblommet sájaka buähuamta jínnunake. ");
INSERT INTO mfy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús ínel ámeu jiaahua: —Kaa úttia bem sákanakëhui; emem am jïbuätua. ");
INSERT INTO mfy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bempo éntok ínel jiaahua: —Ímïte kaita jípure, mamni páanin jíbba entok guoy kútchum. ");
INSERT INTO mfy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Áapo ínel ámeu jiaahuak: —Äbem ínohuam huéria. ");
INSERT INTO mfy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Huanäi juka genteta júya bájta béppa jote sáuhuek. Jume mamni páanim nüka, entok jume guoy kútchum. Huanäi téhuekau jikau remteka, Diosta baysauhuek. Am rébektiaka discíipulommeu am buíssek; ímëi éntok gentetahui. ");
INSERT INTO mfy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sïmetakam jïbuäk, entokim jóbuak. Huanäi jume rerebem yeu bëkame, dooce canastam tátapunimim náu tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jume jïbuäkame éntok mamni mil ohuimtukay, jáamuchim entok ili usim kaa áma näikiaka. ");
INSERT INTO mfy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesús sep ä discíipulom barcopo jämutuaka áapat am sákatuak, bäa huáytana bíchaa. Áapo éntok jü gentetamak taahuak, am sákasuü tájti. ");
INSERT INTO mfy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Juka juebena genteta sákatuasuka, sékäna bíchaa júya káhuit jikau sika oraciónta johuay. Huanäi tukariu yúmak, áapola huämi aaney. ");
INSERT INTO mfy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jü barco éntok béja bahue násuk huéiyey, jume bäa maaresim éntok emo tóboktiaka át huehuechey. Bueïtuk jü jeka ä nankirika huéiyey. ");
INSERT INTO mfy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Të abe matchuyo, Jesús ámeu yepsak, bahue bäata béppa huéesimeka. ");
INSERT INTO mfy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Huanäi jume discíipulom, bahueta béppa huémta bíchakam guómteka, ínel jiaahua: —¡Jo jü jóusi! Huanärim májhueka chay nookay. ");
INSERT INTO mfy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Të huanäi Jesús ámeu nónokak, ínel jíaka: —¡Katem kom éiya! Ínapone ím aane. ¡Katem majhuë! ");
INSERT INTO mfy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Huanäi Peero ä yómmiak, ínel jíaka: —Señor, émpotuko, nechë emou bíchaa huéetua, bäam béppa. ");
INSERT INTO mfy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Huanäi Áapo ínel áu jiaahuak: —Binë huéiye. Huanäi Peero barcopo kom chépteka, bäam béppa huée táytek, Jesústau bíchaa huée báreka. ");
INSERT INTO mfy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Të juka jeka úttiakamta bíchaka ä mámajhuek, entok kom kikkibak táyteka, chay táytek, ínel jíaka: —¡Señor, nechë jínëu! ");
INSERT INTO mfy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús sep áu mámteka, ä buíssek, entok ínel áu jiaahuak: —¡Yoreme kaa yúmalasi Diostat éame! ¿Jatchiakasë Diostat éehuäpo kom éiya? ");
INSERT INTO mfy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Huanäi bempörim barcopo jämuko, jü jeka yánti taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huanäi jume barcopo aneïhui áhuim rúkteka ä yörey, ínel jíaka: —¡Tua lútüriapo empo Diosta üusïe! ");
INSERT INTO mfy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Huanärim bahue huáytana yájaka, Genesaret pueblou kiímuk. ");
INSERT INTO mfy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jume yoremem áma jóakame ä tátäyaka, noktam áman bíttuak, sïme pueblom beekatana. Huanärim sïme kökoreme áu nüpak, ");
INSERT INTO mfy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","entokim jiokot áu jiaahuay, ä súpem mantom mayoat jíba mámte rókaka. Huanäi sïme jume át mámtekame, türilatakam taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Huanärim Jesústau rúktek, huate escriibam entok pariserom, Jerusaléniu joome, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Jatchiaka jume em discíipulom juka yoiyöturim boojoriau kaa johua? Bueïtuk katim bábaijma, páanim buä bárëteko. ");
INSERT INTO mfy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Áapo am yómmiaka ínel ámeu jiaahua: —¿Jatchiaka eme kétchi, juka Diosta nésahuekähuem kaa johua, yoiyöturim boojoriau enchim jo bárë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bueïtuk Dios nésahueka ínel jiaahuak: “Em átchay entok em áiye, Akë am yöre, të jábe ä áchaybet entok ä áyebet, bétte nokta am béj‑reka ámet nokakätek, kaita át temajeka mëtuna.” ");
INSERT INTO mfy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Të eme ínëlem jiaahua: “Jábetaka junne ä áchaybeu entok ä áyebeu ínel jíäteko, jü áy ára enchi ín aniä eyhui, Diostau bíchaa nä näikiala”, ");
INSERT INTO mfy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","huanäi ínëli jíaka, béja kara am aniaka tatahua, jume áchayhuariam. Ínëli jü Diosta nésahui kaita béj‑reka tatahua, juka yoiyöturi boojoriau enchim jo bárë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Eme Dios huáatihuamta bénasi emo antua! Tüisi enchim bétana nookak jü Isaías, ínel jíakari: ");
INSERT INTO mfy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ïri pueblo ä teniay jíba nee yöre, të bem jíapsi mékka inou aane. ");
INSERT INTO mfy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bueïtuk kía béjja, jü bem nee yörëhui, doctriinata bénasim yore ä majtia, juka yoremem nésauta. ");
INSERT INTO mfy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Huanäi juka juebena genteta núnuka ínel ámeu jiaahua: —Akem ä jíkkajaka éntokem át jüneiya. ");
INSERT INTO mfy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaa yoremta nasonte, jü tempo kimume; ál‑la jü tempo yeu huéeme, ïri ál‑la yoremta nanasonte. ");
INSERT INTO mfy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Huanäi ä discíipulom áu rúkteka, ínel áu jiaahua: —¿Jachë kaa júneïya? Bueïtuk jume pariserom íkäi nokta jíkkajaka, kaa tüisi ámeu huétchek. ");
INSERT INTO mfy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Të Áapo am yómmiaka ínel ámeu jiaahuak: —Sïme júya óuhuo, téhueka bétana ín Áchay kaa echakäu, nahuamak békti popónna. ");
INSERT INTO mfy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","¡Akem am tójja! Liliptimtakam huate liliptim huíksasaka. Bueïtuk jü líptitaka täbui líptita huíksimëteko, náhuichikam guójökun kóm huáttinake. ");
INSERT INTO mfy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peero ä yómmiaka ínel áu jiaahuak: —Itomë ä téjhua, jáchin ä jiau bárëhui, íkäi ejemplota. ");
INSERT INTO mfy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús ínel jiaahua: —¿Jachu eme két juka kaa jüneehuamta jípure? ");
INSERT INTO mfy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Jachem kaa át jüneiya? Sïme tempo kimume tönáu bíchaa huéiye; chúkula éntok yeu jujuyäutehua. ");
INSERT INTO mfy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Të jü tempo yeu huéeme, huáijhua jiápsipo yeu huéiye; ïri ál‑la juka yoremta nanasonte. ");
INSERT INTO mfy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bueïtuk jiápsipom yeu huéiye, jume kaa tü éerim, jü yore suahuame, jü jubeka entok júchi täbuik jipureme, jü kaa emo jubeka kía náu jíapsihuame, jü jita ékbuahuame, jü kaa lútüriapo jábetat nokhuame, entok jü Diosta béj‑reka béttek nokhuame. ");
INSERT INTO mfy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ïri sïme, juka yoremta nasonte; të jü kaa áu mám báksiaka jïbuähuame, kaa yoremta nanasonte. ");
INSERT INTO mfy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús jumü yeu sika, Tiro entok Sidón buiärau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Senu jámut Canaa buiärapo yeu simlataka, chay nokaka ínel jiaahuay: —¡Señor, Davidta Üusi, nechë nák jiokole! In jámut asoa lemoonio át aneka jiokot áhuä bíttua. ");
INSERT INTO mfy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Të Jesús huépul nokta júne kaa ä yómmiak. Huanäi ä discíipulom jiokot éaka áu rúktek, ínel jíaka: —Akë ä simtua, bueïtuk itot chäka huéeka chaysime. ");
INSERT INTO mfy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Áapo am yómmiaka ínel jiaahuak: —Israel kabaram emo tärulammeune jíba bíttuari. ");
INSERT INTO mfy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Huanäi áapo áu rúktek, entok tónommia kíkteka ínel áu jiaahua: —¡Señor, nechë jinëu! ");
INSERT INTO mfy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Áapo ä yómmiaka ínel jiaahua: —Kaibu türinake, jume itom usim páanim buä éähui, am úuhuaka ili chüum am mik béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Të áapo ínel áu jiaahua: —Jeehui, Señor; të jume ili chüum bem teko mesapo juka lelebelaik kom huáttemta júnem buabuäye. ");
INSERT INTO mfy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Huanäi Jesús ä yómmiak, ínel jíaka: —Empo jámmut, ¡yún emót aika, jü Dios éehuame! Emou yáatunake, tua em ä huáatiä pámani. Huanäi ä jámut ásoa türilataka taahuak, huämi orapo naateka. ");
INSERT INTO mfy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús huämi yeu sika, Galiléa bahue mayoau yepsak. Huanäi júya káhuit jikau sika áma yejtek. ");
INSERT INTO mfy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Huanäi juebena gente áu rúktek, lolöim, liliptim, múurom, kaa emo mám yekame, entok huate yún kökoreme huériaka. Huanärim Jesústau am rúktiak, ä guókpo. Áapo entok am tütek. ");
INSERT INTO mfy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ínëli jü juebena gente buére éiyay, múurom nokame bíchaka, jume kaa emo mám yekame türilame, jume lolöim naa kateme, entok jume liliptim bíchame. Huanärim Israelpo Diosta tüisi úttiley. ");
INSERT INTO mfy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ä discíipulom núnuka ínel jiaahua: —Juka gentetane jiokolë, bueïtukim béja báij taahuare ínomak aneka, entokim buähuamta kaa jípure, jïbuä béchïbo. Kaa jïbuälame sákatua béchïbo éntokne kaa báare. Jáchinai júnem böot katëtek, tébäi tamunake. ");
INSERT INTO mfy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Huanäi ä discíipulom ínel áu jiaahua: —¿Jáksute ítapo yún páanim jípure ímï mékka jóa ániapo, sïmem jóbosi jïbuänakre béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Huanäi Jesús ínel ámeu jiaahua: —¿Jaiki páanimsem jípure? Bempo ínel jiaahua: —Guoy búsanim, entok ili jaiki kútchum. ");
INSERT INTO mfy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Huanäi nésahuek, juka genteta buíapo jote sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Huanäi jume guoybusam páanim nüka entok jume kútchum, ínëli Diosta baysausuka, am rébektiaka ä discíipulom am mákkak; jume discíipulom éntok genteta. ");
INSERT INTO mfy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sïmetakam jïbuäk, entokim jóbuak. Huanäi jume lelebelaim yeu bëkame náu tójjak, guoybusan canajtam tátapunim. ");
INSERT INTO mfy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jume jïbuäkame éntok, naiki mil ohuimtukaimme, jáamuchim entok ili usim kaa áma näikiaka. ");
INSERT INTO mfy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Huanäi jume gentem sákatuasuka, barcopo jämuka buiära Magdala téäu yepsak. ");
INSERT INTO mfy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Huanäi jume pariserom entok jume saduceom áhuim rúktek, ä jioptua báreka, señalta téhueka bétana áu aahuaka. ");
INSERT INTO mfy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Të Áapo am yómmiaka ínel ámeu jiaahua: —Tukariu yúmamta bichätek: “Türi báare jü tiempo”, tem jijia: “Bueïtuk jü ánia téeka síkilisi chätu.” ");
INSERT INTO mfy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Én kethueytana éntok: “Buére jeknake, bueïtuk jü ánia téeka síkilisi namu chätu.” ¡Eme lútula Dios huáatemta mamatome! Akem ä täya, juka téeka ániata jáchin ä huëhui; të juka señal taahuata én huémta, ¡katem át jüneiya! ");
INSERT INTO mfy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jü kaa tü yóremra kaa huépülsi au nüyeme, señalta áu yáaria ïaaka nooka; të kayta señalta éntok jípunake, profeeta Jonásta señal jíbba. Huanäi am tójaka siika. ");
INSERT INTO mfy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jume discíipulom huáytana yájaka, jume páanimim kaa nüpak, ámebia kópteka. ");
INSERT INTO mfy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Huanäi Jesús ínel ámeu jiaahua: —¡Akem ä bitcha, jó! Jume pariserom entok saduceom levaduura bétanem emo suaya. ");
INSERT INTO mfy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bempo éntok ínel éiyay, ínel jíaka: —Kaa páanim itom nüpakä béchïbo júnel jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ä jüneriaka, ínel ámeu jiaahua: —¿Jatchiakasem ínel éiya? ¡Yoremem kaita súalëram: “Katte páanim jipure”, ti éaka! ");
INSERT INTO mfy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jachem kaa ámeu huáate, jume mamni páanimmehui, mamni mil yoremem béchïbo, entok jaiki canajtam enchim náu tójakähui? ");
INSERT INTO mfy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Entok jume guoybusan páanimmehui, naiki mil yoremem béchïbo, entok jaiki canajtam enchim náu tójakähui, ¿jachem kaa ámeu huáate? ");
INSERT INTO mfy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jatchiakasem kaa át jüneiya? Kanne jume páanim béchïbo ínel enchimmeu jiaahua, ál‑la jume pariserom entok jume saduceom levaduura bétana; íäri bétanem emo suaya. ");
INSERT INTO mfy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Huanärim jünëiak, kaa jü levaduura páanim bétana emo suaya sáihuähui, ál‑la jume pariserom entok saduceom juka doctrinata yore majtiahuamta bétana. ");
INSERT INTO mfy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jum Cesarea Filipo buiärau yepsaka, Jesús ä discíipulom nátemajek, ínel jíaka: —¿Akim ä jábesä tíiya, jume yoremem, juka Yoremta Üusi? ");
INSERT INTO mfy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bempo ínel jiaahua: —Huate enchi Juan Bautistä tíiya; huate éntok Elías; huate éntok enchi Jeremías tíiya, ö jamak huate profeetam. ");
INSERT INTO mfy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Áapo ínel ámeu jiaahua: —Emesu, ¿nechem jábesä tíiya? ");
INSERT INTO mfy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Símon Peero ä yómmiak, ínel jíaka: —Émpë jü Cristo, Dios jiápsamta Üusi. ");
INSERT INTO mfy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Huanäi Jesús ä yómmiak: —Yúmalasë al‑leehuamta jípure, Simmom, Jonásta üusi, bueïtuk kaa kía jábe yoreme emou yä machiriak, ál‑la ín Áchay téhuekapo kátekame. ");
INSERT INTO mfy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ínapone két ínel emou jiaahua, enchine Peero tíiya. Jü téta buëuruta béppa éntokne ín igleesia yöturianake; jü infierno puertam éntok kaibum áa béppa úttiata jípunake. ");
INSERT INTO mfy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Enchine am máknake, jume réy nésauri téhuekapo yáabem. Sïmeta ímï buíapo em súmäu, téhuekapo két súmatunake; entok sïme buíapo em búttiakähui, téhuekapo két búttiatunake. ");
INSERT INTO mfy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kaabeta am téjhua sáuhuek, jume ä discíipulom, áu Cristotukä bétana. ");
INSERT INTO mfy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Huanäi naateka Jesús ä discíipulom huitti téjhua táytek, buere jóära Jerusaléniu ä huéenakeu úttiatukähui, entok jiokot áu yáanähui, jume tiöpopo yoiyöturim bétana, entok jume sacerdote chë nésahueme entok jume escriibam bétana, entok mëhuaka báij taahuata huéy áu jíabitenakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Huanäi Peero áapolaik sékäna bíchaa ä nuk sika áamak ettejhua táytek, ínel jíaka: —¡Señor, emoë jiokolë; bueïtuk jü emou yáanäu kaa emou huéepo yúmala! ");
INSERT INTO mfy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Të Áapo Perotau kúakteka ínel jiaahua: —¡In bíchäpe mékka huéiye, Satanás! Kialë nee teïtituabáare, bueïtuk Diosta nokähuë kaa bitcha, ál‑la jume yoremem türëu bíchaa jíbba. ");
INSERT INTO mfy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Huanäi Jesús ä discíipulommeu ínel jiaahua: —Jábetaka junne ino sáu huée bárëtek, kaa áu beutireka áu tóijnake; huanäi ä kúruj püaktiaka ino sáu huéenake. ");
INSERT INTO mfy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Entok jábetaka junne ä jíapsihua jínëu báareme, ä tärunake; entok jábetaka junne jü inot ä éä béchïbo jíapsihua tärukame, ä téunake. ");
INSERT INTO mfy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bueïtuk, ¿jítasu áma téunake jü yoreme, jum ániat ayukamta yöokateko, juka ä jíapsihua éntok ä tärukäteko? Entok, ¿jaikiksu ára béjtua jü yoreme, ä jíapsihua béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bueïtuk ínapo jü Yoremta Üusi yebijnake, jum sïmek béppa ujyorik ín Áchay áttiäpo, entok ä ángelesimmaki. Huanäi hueuhuëpulam am béjtuanake, jita bem yáakau bétana. ");
INSERT INTO mfy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tua lútüriapone ínel enchimmeu jiaahua, huate ímï aneme, katim kókkonake, ál‑la taahuata yúmak Yoremta Üusi réytaka yepsamta bíchakätek. ");
INSERT INTO mfy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Búsan taahuarim simsuko, Jesús am nüka, Perota, Jacobota, entok Juan ä sailahua. Huanäi am nuk siika, júya káhuit jikahui bempolaim. ");
INSERT INTO mfy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huanäi bem bíchäpo täbuiasi áu yáuhuak. Ä pújbahua täata bénasi bélojkosi bíttuy; ä sánkohua éntok tósalisi aayuk, machiriata bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ímïri Moisés entok Elías ámeu yeu machiak, áamak ettejhuaka. ");
INSERT INTO mfy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Huanäi Peero Jesústau ínel jiaahua: —Señor, ¡türi ito béchïbo jü ímï anhuame! Enchi ínel éayo, báij jötamte ímï yáanake: huépülak emo béchïbo, senuk entok Moiséjta béchïbo, entok senuk Elíasta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ketune áapörik ä nokayo, namu machiriaka am róptiak. Huanäi jíahui namupo jíkkaijtuk, ínel jíaka: —Ïri ájäria jü ín Üusi ín nákëhui. Áamakne al‑leiya; áapörikem jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jume discíipulom íkäi jíkkajakam tónommey jáptek. Huanärim buíau tájti kom kóbatek, tüisi májhueka. ");
INSERT INTO mfy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Huanäi Jesús ámeu rúkteka ámet mámtek, ínel jíaka: —Jáptëem; entok katem májhue. ");
INSERT INTO mfy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Huanäi bempo jikau remteka, kaabetam bitchak, Jesústa áapolaik jíbba. ");
INSERT INTO mfy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Të chúkula júya káhuit kömam sájako, Jesús ám sáhueka ínel ámeu jiaahua: —Juka enchim bíchakäu, kaabetem ä téttejhua, ál‑la chúkula béja kókkolam násuk juka Yoremta Üusi jíabiteko. ");
INSERT INTO mfy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Huanäi ä discíipulom ä nátemajek, ínel jíaka: —¿Jatchiaka júntuk jume escriibam ä úttiä tíiya, jüka Elíasta bát yebijnakëhui? ");
INSERT INTO mfy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús am yómmiak, ínel jíaka: —Lútüriapo, Elías bát yebijnake; huanäi sïmeta bemelasi yánake. ");
INSERT INTO mfy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tëne ínel enchimmeu jiaahua, Elías béja yebissuk, të katim ä täyak, ál‑lam sïmeta bem yáa bárëu áu yáuhuak. Ínëli kétchi jü Yoremta Üusi áme bétana jiokot yáana. ");
INSERT INTO mfy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Huanäi jume discíipulom huitti jünëiak, Juan Bautistata bétana ä nokaïhui. ");
INSERT INTO mfy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Juka genteta yún anëu am yájako, senu yoreme áu yepsaka tónommey áu kíkteka ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Señor, ín üusi táij múmukemtë nák jiokolë, tüisi jiokot áu bíbicha; bueïtuk juebénasi táijpo huehueche, entok juebénasi bäapo. ");
INSERT INTO mfy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Huanäine jume em discíipulommeu ä nüpak, të ímëri én tájtim kara ä tüte. ");
INSERT INTO mfy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús ä yómmiaka ínel jiaahua: —¡Eme nat tómti kat‑riam kaita súalëram, entok sïmekut kaa türik joame! ¿Jauhuey tájtisune ikäi enchimmet ayukamta enchimmet bit yáatinake jäni? Inohuem ä huéria. ");
INSERT INTO mfy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús kuttílasi át nésahuek, jü lemooniotachi. Huanäi ïri át yeu siika, jü usitachi. Huanäi naateka türilataka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Huanäi ä discíipulom bempola sékäna Jesústau yájaka, ínel áu jiaahua: —¿Jatchiaka ítapo kara yeu ä béebak? ");
INSERT INTO mfy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús ínel ámeu jiaahua: —Diostat éehuame ilikkik enchim jípure béchïbo. Lútüriapone ínel enchimmeu jiaahua, eme mojtaasa báchiata béechisi Diostat éätek, ïri júya káhuittau ínel jíätek: “Sékänë emo yetcha”, huanäi sékäna áu yécha éiyey. Ínëli enchim béchïbo kaita kara yáataka tahua éiyey. ");
INSERT INTO mfy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Të jü ilë béna kökoa lemoonio, ayuunopo entok oraciónimmaki jíba yeu sisime. ");
INSERT INTO mfy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galiléa buiärapo bempörim aneyo, Jesús ínel ámeu jiaahua: —Ínapo jü Yoremta Üusi yóremem mámpo tóijna. ");
INSERT INTO mfy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Huanärim ä mënake; të báij taahuarim huéy jíabitenake. Huanäi bempo tüisi sirokoka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaum pueblou am yájako, Perotahuim yájjak, jume impuesto tómita náu totojame, ínel jíaka: —¿Jü enchim Maestro kaa am bébejtua, jume guoy dracmam? ");
INSERT INTO mfy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Áapo am yómmiak: —Jeehui. Huanäi jóapo ä kibakek, Jesús bát au nookak, ínel jíaka: —¿Jáchisë ä bitcha, Simmom? Jume ímï buíapo réyesim, ¿jábetasum ä úuhua, juka impuesto tómita: jume bem jóapo uusim, ö jume kaa áma joomem? ");
INSERT INTO mfy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peero ä yómmiak, ínel jíaka: —Jume kaa jóapo joomem. Huanäi Jesús ínel áu jiaahua: —Júnëli jume usim jóapo joome béja kaita béjtua. ");
INSERT INTO mfy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Júnentaka junne, kaa am omtinakë béchïbo, bahuehuë sika anzuelota áman jímma. Huanäi juka kúchuta bát em yeu huíkekäu, Akë ä nüye huanäi ä tem étapokätek. Huanäre áma ä téunake, tómi estaterota. Íkäre nüka am mákka, íno béchïbo entok émo béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Júnaköri jume discíipulom Jesústau yájaka, ínëlim áu jiaahua: —¿Jábesu chë júne áma yörisi machi, jum téhuekapo Diosta réy nésahuepo? ");
INSERT INTO mfy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Huanäi Jesús ili usita núnuka, áme násuk ä kétchak. ");
INSERT INTO mfy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Huanäi ínel jiaahua: —Lútüriapone ínel enchimmeu jiaahua, kaa júchi ili usim bénasi emo nükateko kaibem aman kimunake jum Diosta téhuekapo réy nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Júnensan jábetaka junne kaa áu buérialeka ï ili usi ténasi áu nüyeme, ïri júnen chë yöhue jum Diosta téhuekapo réy nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Entok jábetaka junne, juka ili usita ilë bénnak ín téhuampo mabetakame, nee mabeta. ");
INSERT INTO mfy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Jábe junne usi il‑lïchim nee súaleme, kaa türik am yáatuakame, chë türi éiyey, buru molino tétata kutänaapo át súmaka bahuéu kóm jímmaahuako. ");
INSERT INTO mfy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Jiokot maachi, jume ániat kaa türikuu yore jioptuame béchïbo! Bueïtuk úttia júkäi ayunakëhui, të ¡Jiokot áu huéenake, hua yoreme yore jioptuamtahui! ");
INSERT INTO mfy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ä junëlitunakey, jume em mámam entok em guókim kaa türikum bíchaa enchi am huéria báareyo, Akë am chúktiaka mékka am guötia. Bueïtuk chë türinake, kaa mámaka entok kaa guókeka yü jíapsihuäu em huéenakëhui, të kaa yúmalam mámaka entok yúmalam guókeka táijta kaa tutukëu em jímmaanähui. ");
INSERT INTO mfy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bueïtuk empo, em pusim kaa türik enchi yáatua báareyo, yeuhuë am huíkeka mékka am jímma. Bueïtuk chë türinake, huépülam puseka yü jíapsihuäu em huéenakëhui, të kaa guoyim puseka táijta kaa tutukëu em jímmaanähui. ");
INSERT INTO mfy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’¡Tüisem át suuhua! Kaabe kía kaitapo am bínnake, huépülak junne, ímëi ili uusim. Bueïtuk jume bem ángelesim téhuekapo ín Áchay pújbapo jíbam aane. ");
INSERT INTO mfy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bueïtuk ínapo jü Yoremta Üusi jume emo tärulamene jínëu báreka äbo yebij‑la. ");
INSERT INTO mfy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Jáchisem ä bitcha? Senu yoreme cienim kabaraka, të huépülak täruko, ¿jachu kaa jume noventa y nuevem tösika júyat náa huée táytinake, huaka áu tärukamta jariaka? ");
INSERT INTO mfy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Të ínëli huémta násuk ä tíakätek, lútüriapone ínel enchimmeu jiau báare, chë júne al-leenake, hua kabara áu täruka tëihuakamta bétana, huame noventa y nuevem kaa emo tärukame béppa. ");
INSERT INTO mfy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ínëli kétchi, jü enchim áchay téhuekapo anemta nésau éeri, jume il‑lïchim ímï aneme, kaabeta áu täru ïaa, huépülak junne. ");
INSERT INTO mfy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Bueïtuk Cristota súalhuäpo émomak aanik, kaa türik émou ä yáako, empo éntok áapo emepolem aneka, kuttilasë áu nooka. Enchi ä jíkkajako, Cristota súalhuäpo émomak anikë yölataka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Të kaa enchi ä jíkkajako, huépülak ö guoyimë émomak huéria; bueïtuk guoyim ö bájim jíkkajäpo sïme noki lútüriataka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Të bempörim kaa ä jíkkajako, igleesiapo náu aneme téjhua. Huanäi igleesiapo náu anim kaa ä jíkkajako, jume kaa judíom entok publicanom bénasë ä jípunake. ");
INSERT INTO mfy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Lútüriapone ínel enchimmeu jiaahua, sïmeta ímï buíapo enchim súmakähui, áman téhuekapo két súmatunake, entok sïmeta ímï buíapo enchim búttiähui, áman téhuekapo két búttiatunake. ");
INSERT INTO mfy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Júchine ínel enchimmeu jiaahua, eme guoyika, nanabeu éaka, ímï buíapo jita júne aahuätek, akem ä yáariana, ín Áchay téhuekapo anemta bétana. ");
INSERT INTO mfy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bueïtuk ják junne, guoyika ö bájika ín téhuampo náu anemmaki, huämine ínapo áme násuk aane. ");
INSERT INTO mfy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Huanäi Peero áu rúkteka ínel áu jiaahua: —Señor, ¿jaikisisune ä jiokorinake jäni, juka ín hermaano kaa türik inou ä yáako? ¿Guoy búsanisi? ");
INSERT INTO mfy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús ínel áu jiaahua: —Ëe; kaa guoy búsanisi jíbba, ál‑la setenta guoy búsanisi. ");
INSERT INTO mfy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ïäri béchïbo jü téhuekapo réy nésauri senu réyta bénna. Ïri jume áu tékipanoame núnnuk, bempörim juka bem huikiriäu am jünerianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huanäi cuentam ä jo táyteko, huépülaka áu yeu tóijhuak, guoj mamni mil talentom ä huikiriame. ");
INSERT INTO mfy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ïri kara áu béjtuaka taahuak. Huanäi ä tekohua át nésahuek ä nénkinä béchïbo, ä jubiahua, ä üusihuam, entok sïmeta ä áttiahua, junëli ä huikiriäu béjtuanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Huanäi jü tekipanuario ä tekobeu tónommia kíkteka, tüisi jiokot áu nookak, ínel jíaka: “In teeko, yánti jiápsekë nee boobíchaïhui. Ínapone sïmeta enchi béjtuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Huanäi jü tekipanuariota teeko, jíapsi sóokteka ä búttiatebok, entok ä huikiriäbet ä jiokorek. ");
INSERT INTO mfy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Huanaï yeu sika, senuk tékilpo ä jáläihua téuhuak, cien denariom ä huikiriamta. Huanäi kutänapo át chätuka ä jíabi mëay, ínel áu jíaka: “¡Juka em nee huikiriähuë nee bejtua!” ");
INSERT INTO mfy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Huanäi jü tekohuäpo ä jáläihua, guókpo áu tónommia kíkteka, tüisi jiokot áu nookak, ínel jíaka: “Yánti jiápsekë nee boobíchaïhui. Ínapone sïmeta enchi béjtuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Të áapo kaa báarek, ál‑la carcelpo ä yéchatebok, juka ä huikiriäu ä béjtuäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jume áamak tekipanuariom juka áma huémta bíchaka, tüisim sirokaka taahuak. Huanärim bem yöturibeu sájaka ä ettejhuariak, juka sïmeta áma yeu sikamta. ");
INSERT INTO mfy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Huanäi ä tekohua ä núnuka, ínel áu jiaahua: “¡Tekipanoalero kaa tü yóreme! Sïmeta huaka em nee huikiriäune enchi át jiokorek, inou enchi jiokot jíakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Jachë kaa két ínëli ä nák jiokoli máchiakay, juka em jálaï, enchi ín nák jiokolekä bénasi?” ");
INSERT INTO mfy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huanäi ä tekohua omteka, jume yore bébebame mámpo ä tójjak, sïmeta ä huikiriäu ä béjtuäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús ínëli jiaahuak: —Ánëli kétchi, jü téhuekapo ín Átchay két ínëli enchim yáanake, juka enchim béj‑reka ayukamta kaa chíkti jíapsimak enchim ä jioköreko juka em hermanota. ");
INSERT INTO mfy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chúkula Jesús íkäi nokta noksuka, Galiléa buiärapo yeu sika, Judea buiärau bíchaa siika, Jordán bathue huáytana. ");
INSERT INTO mfy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Juebenara gente áa sáu sájjak. Huämïri jume kökoreme tütek. ");
INSERT INTO mfy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huanärim áu yájjak, jume pariserom, ä jioptua báreka, ínel jíaka: —¿Jachu yoremta béchïbo türi jäni ä jubi ä jímmaanakëhui, kía jita béchïbo junne? ");
INSERT INTO mfy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Áapo am yómmiaka ínel jiaahua: —¿Jachem kaa ä nok‑la, juka jïojteta? Bueïtuk júnakoy ániata naateyo, “outa entok jámutta yáuhuak”. ");
INSERT INTO mfy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Entok két ínel jiaahua: “Íäri béchïbo jü yoreme ä áchayhua entok ä áyehua tösika, ä jubibeu rúkteka áamak jíapsinake. Huanärim ínëli huépülak náu takahuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Júnëlim béja katim náapat guooyi, ál‑lam náu huépülak takaanake. Juka Diosta náu rúktiakähui éntok, jü yoreme kaibu am näikimtenake. ");
INSERT INTO mfy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Inëlim áu jiaahua: —¿Jatchiaka júntuk Moisés ä jímmaaka divorcio jiösiata ä mák nésahuek? ");
INSERT INTO mfy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Áapo ínel ámeu jiaahua: —Enchim námakak jiápsekä béchïbo jü Moisés junëli ä yáatebok, jume enchim jáamuchim enchim guötianake bétana. Të tua kësampo naateka kaa junëli huéiyey. ");
INSERT INTO mfy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ínapone ínel enchimmeu jiaahua, jábe ä jubi täbui yoremtamak áhuä náyotek ára ä jímma. Kaa ä junëlituko, ä jubi jiösia divorciota ä mákaka täbuik jubekätek, adulterio kúlpata jípureka tatahua; entok jábe juka jímmata jubekame két jíba júkäi kúlpata huériunake. ");
INSERT INTO mfy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Huanäi ä discíipulom ínel áu jiaahua: —Ä ínëlitunakey, kaa áma huétche, jü emo jubiahuame. ");
INSERT INTO mfy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Huanäi Áapo ínel ámeu jiaahua: —Katim sïmetaka áma yuuma, ä mabet béchïbo, ál‑la huame Diosta bétana jüneehuamta mabetame. ");
INSERT INTO mfy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bueïtuk huate yoremem jauhuey júne kaa jujube; bempo júnel yeu tómtila. Huate entok tua káponim, yoremem ínel am yáalä béchïbo; huate entok bempo ínel emo yáala, kaitat obisi éaka, juka Diosta tékil joo béchïbo. Juka íkäi mabetakame áma áu yumäu jüneriaka ä yáanake; jíba türi éläposu jauhuey júne kaa jubnake. ");
INSERT INTO mfy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Huanäi ili usim áu tóijhuak, áme béppa mámteka Diostau am buanianakë béchïbo; të jume discíipulom kutti ámet nónokak, Jesústa kaa múksi bít ïaaka. ");
INSERT INTO mfy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Të Jesús ínel ámeu jiaahua: —Akem am tójja Jume ili usim éläposum ínou kannake. Katem júkäi am úuhua, bueïtuk Diosta téhuekapo réy nésauta, bempom ä áttiak. ");
INSERT INTO mfy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huanäi áme béppa mámteka yeu siika, jum ä aneïpo. ");
INSERT INTO mfy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huanäi senu áu yepsaka ínel áu jiaahua: —Türi Maestro, ¿jita tühuatasune yáanake jäni, juka yü jíapsihuamta jípu béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Áapo ínel áu jiaahua: —¿Jatchiake nee türï tíiya? Kaabe éntok türi, Dios jíbba. Të empo jíapsita ayukäu kibak bárëtek, Diosta nésahuim, Akë am ëeria. ");
INSERT INTO mfy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Júnel áu jiaahua: —¿Jíta nésaurim? Huanäi Jesús ínel áu jiaahua: —Katë yore súuhua. Jubekë kaa täbuimak jiápsa. Katë ékbua. Katë kía jábetat nooka. ");
INSERT INTO mfy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Juka em átchay entok em áiye, Akë am yöre; éntoke juka emo bénasi yoremta emo bénasë ä ériaka ä bínnake. ");
INSERT INTO mfy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jü jübua yötume ínel áu jiaahua: —Íkäi sïmetane ëeriala ín usitukäpo naateka. ¿Jita éntok júchi ínou bëye? ");
INSERT INTO mfy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús ínel áu jiaahua: —Empo tua lútula jíapsi bárëteko, sikë juka sïmeta em jípurëu nénkaka, poloobem ä miika. Huanäre äbo sika ino sáu huéiye. Inëlë sïmeta joaka, áman téhuekapo ä jípunake, juka juebenak béj‑remta. ");
INSERT INTO mfy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Íkäi jíkkajaka jü jübua yötume, kaa al‑leaka siika; bueïtuk yún jita jipurey, rikotukay. ");
INSERT INTO mfy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Huanäi Jesús ínel ámeu jiaahua, ä discíipulommehui: —Tuane lútüriapo ínel enchimmeu jiaahua, tepa obiachi jü riko jum téhuekapo réy nésahueu kibak béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Júchine ínel enchimmeu jiaunake, chë júne kaa obiachi jü kameyo jiikia pusimpo áman ä huéenakë béchïbo, juka rikota téhuekapo Diosta réytaka nésahueu huéenake béppa. ");
INSERT INTO mfy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jume discíipulom íkäi jíkkajaka, tepam guómtilataka taahuak, ínel jíakari: —¿Jábesu éntok béja ára jínëutaka tahuanake jäni? ");
INSERT INTO mfy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Huanäi ám bíchaka Jesús ínel ámeu jiaahua: —Jume yoremem béchïbo ïri tepa obiachi; të Diosta béchïbo kaita obiachisi maachi. ");
INSERT INTO mfy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Huanäi jü Peero ä yómmiaka, ínel áu jiaahua: —Señor ítapo ëni, sïmeta itom jípurëu tóij‑la; huanäite emo sáu kaate. ¿Jítasute, én, jípunake? ");
INSERT INTO mfy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Huanäi Jesús ínel ámeu jiaahua: —Tua lútüriapone ínel enchimmeu jiaahua, júnakoy béja sïmeta bemelasi tahuako, ínapo Diosta Üusi tua réytaka bankot yejteko jum sïmek béppa ujyorikuu, eme ino sáu rejtilame, ámanïrem két jume dooce rey bankommet jotenake. Jume Israelta dooce tribum béchïbem jueezimtunake. ");
INSERT INTO mfy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jábe junne juka ä jóuhua, ö áamak huéeri, ö ä áchayhua, ö ä áyehua, ö ä jubiahua, ö ä usihua entok buíata, ín téhuam béchïbo ä tójakame, cientota béekisi áa béppa ä mabetnake, Diosta bétana, éntok két juka yü jíapsihuamta. ");
INSERT INTO mfy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Të juebénaka bát kateme chúkulam kannake; jume chúkula kateme éntok bát kannake. ");
INSERT INTO mfy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Jü téhuekapo réy nésauri éntok áchayhuari yoremta famiiliaka bénna. Ïri kethueytana yeu siika, tekipanuariom tákia báreka, ä huajpo páras takam chúktianakeme. ");
INSERT INTO mfy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Huanäi am tákiaka ámemak áu nok tütek, senu táapo huépul denariota am béjtua rókaka. Huanäi ä huajpo párasim ayukäu am bíttuak. ");
INSERT INTO mfy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chúkula kethueytana bátanim ják jiay júchi yeu siika. Huanäi huatem bitchak, kaita joaka, plaazapo jokame. ");
INSERT INTO mfy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Huanäi ínel ámeu jiaahua: “Emem ket áman kaate, jum huajpo párasim ín él‑lähui. Ínapone juka tua enchim kobanakeu enchim béjtuanake.” Huanäi bempo áman sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Abe lúl‑la yejtey júchi yeu siika, entok kúpteyo abe bájim jiayo; huanäi két alë bénasi aayuk. ");
INSERT INTO mfy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Entok abe mamnim jiay júchi yeu siika. Huanäi huatem kaita joame téaka, ínel ámeu jiaahua: “¿Jatchiakasem kaita joaka sïme táapo ímï aane?” ");
INSERT INTO mfy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bempo éntok ínel áu jiaahua: “Bueïtuk kaabe itom tákiala.” Huanäi áapo ínel ámeu jiaahua: “Emem két áman kaate, jum huajpo párasim ayukähui; huanäine juka tua enchim kobanakeu enchim béjtuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Huanäi tukariu yúmako, jü yöturi huajpo párasim áttiakame, ä móoromabeu ínel jiaahua: “Jume tekipanuame núnuka am béjtua, huépul taahuata, jume chúkula naatekame bátchu, jume bát naatekammeu tájti.” ");
INSERT INTO mfy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Huanäi jume abe mamnim jiay áman yájakaïhui, hueepulakam huépul denariota mabetak. ");
INSERT INTO mfy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jume bát tékiliu kimukame áman yájaka chem yún emo béjtua máchiley; të bempom két hueepulakam huépul denariota mabetak. ");
INSERT INTO mfy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huanärim ä mabetaka éhuil náu nookay, juka famiiliatau yöturita béj‑reka, ");
INSERT INTO mfy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ínel jíaka: “Ímëi chúkula kimukame senu orata jíbam tekipanuala, éntoke jíba ito bénasi am béjtuala, ¡táttareka entok bétte tékilta sïme táapo itom yáalatuk junne!” ");
INSERT INTO mfy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Huanäi áapo am yómmiaka huepülakuu ínel jiaahuak: “Amigo, kaitane enchi úuhua. ¿Jachune kaa nokta émomak yáuhuak, huépul denariota enchi béjtua rókaka? ");
INSERT INTO mfy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Juka em áttia nükë siime; të íkäi chúkula kibakekamtane em mabetakäu béekiknä béjtua báare. ");
INSERT INTO mfy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Jachune kaa lútüriata jípure, juka ín áttia ín yáa bárë páman ín yáanakëhui? Ö, ¿empo envidiata jípure jäni, ín tü yóremtukä béchïbo?” ");
INSERT INTO mfy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ínëli jume bát kateme chúkulam kannake; të jume chúkula kateme, ímëi bát kannake. Bueïtukim juebenna, jume núnurim; tërim ilikki, jume yeu púarim. ");
INSERT INTO mfy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús buere joära Jerusaléniu jikau sika, ä dooce discíipulom naatepola am núnnuk. Huanäi böot huéeka ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ímïte Jerusaléniu jikau kaate. Ínapo jü Yoremta Üusi éntok jume tiöpopo chë nésahueme entok escriibam mámpo tóijna. Huanärim nokta át chúpanake, ä mënä béchïbo, ");
INSERT INTO mfy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","entokim kaa judíom mámpo ä tóijnake. Jiokochim ä joaka ä bemmuchanake. Huanärim kúrusit ä poponnake; të báij taahuarim huéy jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Huanäi jü Zebedeota üusim áiye ä asoammaki Jesústau rúkteka, áu tónommia kíktek. Huanäi senu huémta áu aahuak. ");
INSERT INTO mfy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Áapo ínel áu jiaahua: —¿Jítasë huáatia? Jü jámut ä yómmiak: —Ímëi ín guoy asoam, ámechë nésahue, bueïtuk réytaka em nésahuepom émomak jotenake, huépülaka bátatana, senuk éntok míkötana. ");
INSERT INTO mfy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huanäi Jesús ä yómmiaka ínel áu jiaahua: —Katem jüneiya jita enchim aahuähui. ¿Jachem juka báasopo ín jïnakeu ára ínomak jëye? ¿Jachu emëe juka jiokot anhuamta ín innënakeu ára ínomak ä innëa? Huanäi bempo ä yómmiak: —Jeehui, ámate yuuma. ");
INSERT INTO mfy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Áapo ínel ámeu jiaahua: —Lútüria báasopo ín jïnakeu ára enchim jïnakëhui, entok juka jiokot anhuau ín innënakeu arem ínomak ä innëa. Të senuk bátatana entok míkötana, ino náapo jábem jotenakëhui, kanne ínapo ä jípure, juka jábem ín ä máknakëhui; ál‑la jü ín Átchay áma am näikiala, jume íäri béchïbo yeu púarim. ");
INSERT INTO mfy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jume guojmamni discíipulom íkäi jíkkajaka ámehuim öomtek, jume guoyika emo sailakammehui. ");
INSERT INTO mfy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Huanäi Jesús am núnuka ínel ámeu jiaahua: —Jüneäem, jume yäura tékiata naciónimmeu jípureme, bem nésahuepom úttiapo kaa türihuamta ámeu johua, entok jume buéresi emo jípureme úttiapom áme béppa nésahue. ");
INSERT INTO mfy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Të enchim násuk kaa ínëlitunake, ál‑la hua enchim násuk áu yö joame, ïri jume huatem nésauta jorianake. ");
INSERT INTO mfy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Bueïtuk jábe enchim násuk bát huériata jípu báareme, ïri huatem bétuk áu jípunake, nésauta am joriaka. ");
INSERT INTO mfy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ínapo jü Yoremta Üusi äbo yepsak, kaa nésauta jabeta nee jooria ïaaka, ál‑la sïmem nésauta joria báreka; entok sïmem béchïbo muk báreka ä jíapsi tójjak, juebenam jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jum pueblo Jericópo bempörim yeu sájako, juebena gente áme sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jesústa áma huam huéy, guoy liliptim böo mayoat jokay. Huanäi ä jíkkajakam kusisi cháchayek, ínel jíaka: —¡Señor, Davidta Üusi, itomë nák jiokolë! ");
INSERT INTO mfy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jü gente éntok ámet kutti nónokak, kaa múksi am jiau sáhueka; të bempo chë júne úttiaka chaayey, ínel jíaka: —¡Señor, Davidta Üusi, itomë nák jiokolë! ");
INSERT INTO mfy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Huanäi Jesús kíkteka am núnuka, ínel ámeu jiaahua: —¿Jítasem enchimmeu nee yáa ïa? ");
INSERT INTO mfy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bempo ínel áu jiaahua: —Señor, itom pusimte étapo ïaa. ");
INSERT INTO mfy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Huanäi Jesús am jiokoleka, pújpo ámet mámtek. Huanärim sep bíchaka taahuak, entokim áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Buére jóära Jerusaléniu jëla am kateyo, jum pueblo Betfagéhuim yájjak, káhui Oliivou kaa mékka. Huanäi guoy discíipulom áman bíttuak, ");
INSERT INTO mfy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ínel ámeu jíaka: —Ili jóära itobeu kátekähuem kaate. Huanärem buruta áma chäkamta téunake, ili buruta jípuremta. Akem am búttiaka äbam huéria. ");
INSERT INTO mfy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Të jábeta jáchin enchimmeu jiay, ínëlem áu jiaunake: Jü Señor am huáatia; läutite äbam nóttianake. ");
INSERT INTO mfy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sïme ïri yeu siika, áhuä chúpanakë béchïbo, juka profeetata nokakähui, ínel ä jíako: ");
INSERT INTO mfy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Inëlem áu jiaunake, jü buere jóära Siónpo jóakammehui: “Ímï emou huéiye, jü em réy, kaa áu chëhualeka, buru jámuttat yetsimeka, ili buuru animal asoari ára púaktemtachi.” ");
INSERT INTO mfy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huanäi jume discíipulom áman sájaka, Jesústa nésahuekä páman ä yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Huanärim juka buru jámutta nüpak, entok juka ili buruta; ímïrim jume bem mántom áme béppa óorek. Huanäi Áapo áme béppa yejtek. ");
INSERT INTO mfy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jü gente éntok tüisi juebénakay. Huanärim bem mántom böot tösakay; huate éntok júya sáhuatam chúktiaka böot ä huáttiasakay. ");
INSERT INTO mfy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jü gente bát kateme entok áa sáu kateme chayekam ínel jiaahuay: —¡Buéresi al‑leehuame Davidta Üusi béchïbo! ¡Jü Señorta téhuampo äbo huéeme, tüisi buére al‑leehuame áa béchïbo! ¡Jikat bétana huéiye, jü buére al‑leehuame! ");
INSERT INTO mfy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusaléniu ä kibakeko, sïme áma jóakame tüisim al‑leaka áu yeu sájjak, ínel jíaka: —¿Jábesa ïri? ");
INSERT INTO mfy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Huanäi jü gente ínel jiaahuay: —Ïri Jesús, jü profeeta pueblo Nazaret Galiléa buiärapo joome. ");
INSERT INTO mfy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús jum Diosta tiöpopo kibakeka, sïmem jita áma nénenkame entok jita áma jínnume yeu am béebak, entok jume tómita áma nakuliame mesam am móbektiriak, entok guókohuim nénenkame sila‑bankom mékka am huötiriak. ");
INSERT INTO mfy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Huanäi ínel ámeu jiaahua: —Ínel jïojteri: “Jü ín káari, oración áma jojohua kári ti téhuaana”; të eme, tómi lak‑ron káu guójoriata bénasem ä jípure. ");
INSERT INTO mfy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Huanärim jum tiöpopo áu yájjak, jume liliptim entok lolöim; huanäi am tütek. ");
INSERT INTO mfy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Të jume sacerdotem chë nésahueme entok escriibam, juka buéresi jita ä joäu ä bíchaka, entok jume usim tiöpopo chay nokaka ínel jíame: “¡Buére al‑leehuame Davidta Üusi béchïbo!”, huanärim öomtek. ");
INSERT INTO mfy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Huanärim ínel áu jiaahua: —¿Jachë am jíkkaja, juka ímëi nokähui? Huanäi Jesús ínel ámeu jiaahua: —Jeehui. ¿Jachem jauhuey júne kaa ä nok‑la, juka jïojteta? Bueïtuk ínëli jiaahua: Jume ili usim entok jume chëyeme tempo, ímëri chë yúmalasi enchi am yörinakë béchïbo tüise am buiktuala. ");
INSERT INTO mfy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Huanäi buére jóäraapo am tójaka yeu siika, pueblo Betaniau bíchaa; huanäi huämi taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kethueytana buére jóärau nótteka tébäurek. ");
INSERT INTO mfy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chuna óguota böo mayoat huéekamta bíchaka, áu rúktek; të kaita át téuhuak, kía sáhuam jíbba. Huanäi ínel áu jiaahua: —¡Jauhuey júne kaa júchi takanake! Huanäi sep huaakek, jü chuna óuguo. ");
INSERT INTO mfy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jume discíipulom íkäi bíchaka, buére éakam át guómtilataka ínel jiaahuay: —¿Jáchisu ïri chuna óuguo sejchúkti huaakek? ");
INSERT INTO mfy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús am yómmiaka ínel ámeu jiaahua: —Lútüriapone ínel enchimmeu jiaahua, eme Diostat éaka kaa kóm éätek, katem kía íkäi chunammeu ín yáakäu jíba ára jo éiyey; ál‑lem ínel áu jíakätek, ï júya káhuiu: “Sóoktekë bahuéu emo jímma”, huanäi junëli áu yáa éiyey. ");
INSERT INTO mfy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sïmeta oraciompo súaleka enchim aahuäu, akem ä mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tiöpou ä yepsako, jume chë áma nésahueme entok jume pueblopo yoiyöturi nésahueme Jesústahuim rúktek, huatem ä majtiayo. Huanärim ínel áu jiaahua: —¿Jíta yäuratasë jípureka íkäi johua? Entok, ¿jábesu enchi ä mákkak, íkäi yäurata? ");
INSERT INTO mfy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús am yómmiaka ínel ámeu jiaahua: —Ínapone két enchim temaijnake. Enchim nee yómmiako, ínapone két enchim téjhuaanake, jita yäurata jípureka íkäi ín joähui. ");
INSERT INTO mfy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jü Juanta yore batöahui, ¿jákübosu huéiye? ¿Téhueka bétana, ö yoremem bétana? Huanäi bempo náu nookay, ínel jíaka: —Bueïtuk téhueka bétana ti itom jiayo, Áapo ínel ítou jiaunake: “¿Jatchiaka júntukem kaa ä súalek?” ");
INSERT INTO mfy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yoremem bétana ti itom jiay éntok, pueblotate májhue; bueïtuk sïmetakam Juanta profeetapo jípure. ");
INSERT INTO mfy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huanärim Jesústa yómmiaka ínel áu jiaahua: —Katte jüneiya. Huanäi Áapo két ínel ámeu jiaahua: —Ínapone két kaa enchim téjhuaanake, jita yäurata jípureka íkäi ín joähui. ");
INSERT INTO mfy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ínel ámeu jiaahuak: —Të, ¿jáchisem ä bitcha? Senu yoreme guoyim üusekay. Jü huépülakuu rúkteka ínel áu jiaahua: “In üusi, ï taahuarichë áman párasim ayukäpo tekipanua.” ");
INSERT INTO mfy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Áapo ä yómmiaka ínel jiaahua: “¡Kanne báare!” Të chúkula áu temajeka ä éäpo nótteka áman siika. ");
INSERT INTO mfy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jü senukuu rúkteka két ínel áu jiaahua. Huanäi áapo ä yómmiak, ínel jíaka: “Jeehui, Señor, ámanne huéenake.” Të kaa áman siika. ");
INSERT INTO mfy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jume guoyika sáihuakame, ¿jábesu ä áchay nésahui yáuhuak? Bempo ínel jiaahua: —Jü bát sáihuakame. Huanäi Jesús ínel ámeu jiaahua: —Lútüriapone enchim téjhua, jume publicanom entok jume jáamuchim júyapo yorememmak rejteme enchimpachim áman kaate, jum Diosta réytaka nésahuëhui. ");
INSERT INTO mfy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bueïtuk Juan enchimmeu yepsak, böot lútula huémta huériaka; të katem ä susualek. Të jume publicanom entok jume jáamuchim júyapo yorememmak rejteme, ímëi ál‑la ä susualek. Eme éntok íkäi bíchaka junne, katem emo jíapsi kúaktiak, ä súal béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Akem ä jíkkaja, juka täbui ejemplota: Yoreme famiiliakamta bétana. Ä huajpo páras óuguom jäbuaka am kóräituak. Párasim áma bähua nunühuamta yáaka, tétam náu cháiyak, mejikat tájti sïmeta bít béchïbo. ’Huanäi huatemmeu ä perentaka, mékka bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Huanäi páras takam chúktianäu yúmako, jume ä sáhuëhuim áman bíttuak, ä huajpo párasim suayammehui, juka huajpo yeu huémta am mabet ïaaka. ");
INSERT INTO mfy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Të jume tekipanualerom jume áman bíttuarim buíseka, huépülakim tüisi kökosi yáuhuak; senuk éntokim mëak; senuk éntokim tétammey mámaasuk. ");
INSERT INTO mfy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Júchi bénasi ä sáhuëhuim chë bürum áman bíttuak; të jume tekipanualerom jume bát áman bíttuahuakame bénasim am yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Íkäi sïmeta yeu simsü násuku, ä üusihua áman bíttuak: “In üusi ál‑lam yörinake”, ti jíaka. ");
INSERT INTO mfy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Të jume tekipanualerom, juka huajta áttiakamta üusi bíchaka, náhuim ettejhuaka ínel jiaahua: “Ïri jü sïmek áttiaka tahuaseme. Binem kaate; atä mënake. Huanäite ítapo sïmemak tahuanake.” ");
INSERT INTO mfy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Huanärim páras etpo yä huíkeka ä mëak. ");
INSERT INTO mfy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jü yöturi páras etta áttiakame yepsakätek: —¿Jáchisu am yáanake jäni, jume tekipanualerom? ");
INSERT INTO mfy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Inëlim áu jiaahua: —Jume kaa türik jiápsekame, kaa am jiokoleka am súanake. Huanäi juka páras etta tattäbuim mámpo ä tóijnake, bueïtuk tiempota yúmak ä mabet éäu, ä béjtuanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús ínel ámeu jiaahua: —¿Jachem jauhuey júne kaa ä nok‑la, juka Diosta noki jïojteta? Ínel jiamta: Jume káateme, juka tétatam türik yeu tahuariak. Ïri téta éntok ejkinapo nahuataka yeu simla. Jü Señor íkäi yáala. Ïri itom bíchäpo buériasi maachi. ");
INSERT INTO mfy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Huäri béchïbone ínel enchimmeu jiaahua, jü Diosta réy nésauritem úuhuana. Huanäi täbui gente ä mákna, Diosta éä páman türik taka báareme. ");
INSERT INTO mfy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jábetaka junne, ïri tétata béppa huéchekame jámtiatunake; të jü téta senuk béppa kóm huéchekätek jótasi ä tutujnake. ");
INSERT INTO mfy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ä ejemplom jíkkajaka jume sacerdotem tiöpopo chë nésahueme entok jume pariserom jünéakam taahuak, bempörim bétana ä nokaïhui. ");
INSERT INTO mfy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Të jáchin bem ä buíjnakeu áachim ä jariay; tem pueblota májhuey, bueïtuk bempom ä profeetatukä bétana ä täyay. ");
INSERT INTO mfy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús am yómmiaka júchi ámeu nookak, ejemplommeyi, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jü Diosta téhuekapo réy nésauri, senu réyta bóoda pajkota yáakä bénna, ä üusi béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Huanäi ä sáhuëhuim náasam bíttuak, bóodau néjunrim núnu béchïbo; të ímëi katim áman kat bábarek. ");
INSERT INTO mfy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Huanäi júchi huatem ä sáhuëhuim áman bíttuak, ínel jíaka: inëlem ámeu jiaahua, jume néjunrimmehui: “In toorom entok animaalim äahuikam súasuri; buähuamtane béja yáatebosula. Sïme béja huéchiapo óorek. Bóodahuem äbo kaate.” ");
INSERT INTO mfy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Të bempo kaa áman kat báreka sájjak, senu ä huasau bíchaa, senu éntok ä tékil bít báreka siika. ");
INSERT INTO mfy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Huate éntok, jume áman sáyhuakame buíseka, kökosi am yáaka am súuhuak. ");
INSERT INTO mfy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jü réy íkäi jíkkajaka öomtek. Huanäi ä yún sontarom áman bíttuaka am súatebok, jume huatem mëakame entok bem jóära am táariak. ");
INSERT INTO mfy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Huanäi ä sáhuemmeu ínel jiaahua: “Jü pajko bóoda béja yúmalasi huéchiapo óorek; të jume néjuntaka áman kannakeu katim áma näikiapo yúmalatukay. ");
INSERT INTO mfy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ámanem kaate, jume böom päkun bíchaa yeu katemmechi. Huanärem sïmem enchim tíäu bóodau núnnu.” ");
INSERT INTO mfy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Huanäi jume sáyhuame böommet yeu sájjak. Sïmem jume bem tíakähuim náu tójjak, tü yóremem entok kaa tü yóremem. Huanärim áma tápunak, jume bóodau néjunrim. ");
INSERT INTO mfy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Huanäi jü réy áman kibakek, jume néjunrim bíchaka senu yoremta áma téuhuak, kaa bóoda súpem súpekamta. ");
INSERT INTO mfy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Huanäi ínel áu jiaahua: “Amigo, ¿jáchise äbo kibakek, kaa bóoda súpem súpeka?” Huanäi áapo kaa jíaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Huanäi jü réy ínel ámeu jiaahua, jume sáyhuammehui: “¡Akem ä súmma, guókpo entok mámpo! Huanärem päkun bíchaa ä jímma, kut huathuattëhui. Huämïri buannake, támim kumeka.” ");
INSERT INTO mfy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bueïtuk juebenamme jume núnurim; tem ilikki jume yeu púari. ");
INSERT INTO mfy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jume pariserom sájaka náu ettejhuak, kaa ínel ä éäpo jita ä nokay ä jaatia báreka. ");
INSERT INTO mfy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bem discíipulomim áu jaasek, herodianommaki, ínel jíaka: —Maestro, jüneate lútüriata em türëhui, éntoke lútula lútüriay Diostau bíchaa huémta am majtia; éntoke kaabeta bétana emo suaya, bueïtuk juka yoremta, ä júlëbénapo, katë ä bíchaka át suuhua. ");
INSERT INTO mfy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Enë itom téjhua: ¿Jáchisë ä bitcha? ¿Jachu türi jäni rey Césarta impuestom béjtua béchïbo? Ö, ¿ëe? ");
INSERT INTO mfy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Të Jesús jünéaka kaa tü éehuamta bem jípurëhui, ínel ámeu jiaahua: —Emëe kaa tü yórememtaka emo tü joame. ¿Jatchiakem nee jioptua báare? ");
INSERT INTO mfy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nechem ä bíttua, juka impuesto tómita. Huanäi bempo huépul denariota áu buíssek. ");
INSERT INTO mfy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Huanäi ínel ámeu jiaahua: —¿Jábesa pújbak, entok jábesam téhuak, jume tómit jïojterim? ");
INSERT INTO mfy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bempom ä yómmiak: —Césarta pújba. Huanäi Áapo ínel ámeu jiaahua: —Juka Césarta áttia, Césartem ä mákka; juka Diosta áttia éntok, Diosta. ");
INSERT INTO mfy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Íkäi jíkkajakam buére ëeak. Huanärim ä tójaka sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Huäri taahuarichi jume saduceom áu yájjak. Ímëri katim ä súaley, juka kókkohuaka júchi jíabitehuamta. Huanärim Jesústa nátemajek, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, Moisés ínel jiaahua, jábetaka junne kaa üuseka mukukätek, ä sailahua juka jámut jókoptulata ä nüpo yúmala. Huanäi át usiakätek, ímëri ä saila mukilatachim näikiataka tatahua. ");
INSERT INTO mfy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yoremem guoy‑búsanika, emo sailaka ito násuk aaney. Huépülaka bát juubek, të kaa üuseka muukuk. Huanäi ä jubi ä sailabeu tö muukuk. ");
INSERT INTO mfy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ínëli kétchi jü chúkula huéeme entok jü bájikun huéeme, guoy‑búsanim yumäu tájtim kókkok. ");
INSERT INTO mfy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chúkula sïmem kókkosuk, jü jámut két muukuk. ");
INSERT INTO mfy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jume kókkolam jíabiteko, jume guoy‑búsanika ä jubekaïhui, ¿jábesu júntuk íkäi jámutta jubeka tahuanake jäni? ");
INSERT INTO mfy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Huanäi Jesús am yómmiaka ínel ámeu jiaahua: —Jiop‑läem, juka Diosta noki jïojteta entok ä úttiära kaa täyaka. ");
INSERT INTO mfy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bueïtuk kókkolam jíabitëpo, kaabe jubnake entok kaabe jubtuana; bueïtuk téhuekapom Diosta ángelesim bénasi jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Të jume kókkolam jíabitenake bétana, ¿jachem Diosta nokakäu jïojterita kaa nok‑la, ínel ä jiäpo?: ");
INSERT INTO mfy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ínapone Abrahamta Dios, entokne Isaacta Dios, entokne Jacobta Dios.” Dios kaa kókkolammeu Dios, ál‑la jiápsammehui. ");
INSERT INTO mfy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jü gente ä nokihua yore majtiahuamta jíkkajakam akim ä úttiley. ");
INSERT INTO mfy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Huanäi jume pariserom ä jíkkajak, Jesústa jume saduceom kaita am noktuakähui. Huanärim huépülay bénasim emo náu tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Senu ámemak joome, Moiséjta ley am mamajtiaïhui, ä nátemajek ä jioptua báreka, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ¿jita nésaurisu chë yörisi maachi, jum Moiséjta leypo? ");
INSERT INTO mfy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús ínel áu jiaahua: —“Dios em yöturië náknake, sïme em jíapsiyi, entok sïme em espírituyi, entok sïme em éerimmeyi.” ");
INSERT INTO mfy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ïri ínel jü tua bát huéeme entok jü nésauri chë yörisi maachi. ");
INSERT INTO mfy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jü chúkula huéeme éntok két alë bénna: “Juka emo bénasi yoremtë náknake, em emo nákë bénasi.” ");
INSERT INTO mfy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ímëi guoy nésaurimmet huíjjüte, jü Moiséjta ley entok jume profeetam jïojteri. ");
INSERT INTO mfy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jume pariserom ketune náu aneyo, ");
INSERT INTO mfy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús am nátemajek ínel jíaka: —Cristota bétana, ¿jáchisem éiya? ¿Jábesä üusek? Inëlim áu jiaahuak: —David ä üusek. ");
INSERT INTO mfy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Huanäi Áapo ínel ámeu jiaahua: —¿Jatchiakasu júntuk David, Espíritu Santota úttiäray nokaka, “Señor”? Ti ä téhuak, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ínel jiaahuak jü Señor ín Señortahui: “In bátatanë yejte, jume enchi béj‑reka kateme em guókim bétuk nee am órëu tájti.” ");
INSERT INTO mfy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David “ín Señor” ti ä téhuak. ¿Jáchisu júntuk ä üussitunake? ");
INSERT INTO mfy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaabe ára ä nok yómmiaka taahuak; entok huäri taahuarit naateka kaabe júchi ä nátemajek. ");
INSERT INTO mfy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Huanäi Jesús gentetau nookak, entok ä discíipulommehui, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jume escriibam entok pariserom, Moiséjta bénasim yäurata jípureka emo bíttebo, juka Moiséjta leypo huatem majtiahuäpo. ");
INSERT INTO mfy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ínëli sïmeta huaka enchimmeu nokaka enchim ëria ïau, akem ä ëria, éntokem ä yáuhua. Të juka kaa tüisi aneka bem jiapsäu, katem ä joo báare; bueïtuk bempom senu huémta yore majtia, tem täbuiasi jiápsa. ");
INSERT INTO mfy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bueïtuk änaatam súsuma béttesi maachik entok kara huériutumta, yoremem jénommetchim am öore; të bempom huépul sútuy júnem kaa át jálo‑jálojte. ");
INSERT INTO mfy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ál‑lam sïmeta bem joäu johua, yoremem bétana emo bít ïaaka; bueïtuk Diosta nooki jïojteta kóba mejëku entok mám tébiapom ä jípureka, sëbem bem mánto súpem béppa chátcha. ");
INSERT INTO mfy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Entokim pajkopo násuk joka jïbuähuamta türe, jum sinagogampo entok bankom bát jokammet bem jotenakëhui, ");
INSERT INTO mfy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","entok pláazapo bem tebotuanähui, entok huate yoremem bétana, “¡Maestro, Maestro!”, ti ámeu jiayhuamta. ");
INSERT INTO mfy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Të emëe, katem “kóba yöhue” ti emo téhua ïaa; bueïtuk huépülaka enchimmeu kóba yöhue, jü Cristo; eme éntok sïmetaka emo saylak. ");
INSERT INTO mfy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Katem jábeta “ín Átchay” ti téttehua báare ímï buíapo; bueïtuk huépülak jíbate Áchayek, juka téhuekapo kátekamta. ");
INSERT INTO mfy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Katem “Maestro” ti emo téhua ïaa; bueïtuk huépülaka enchimmeu Maestro, jü Cristo. ");
INSERT INTO mfy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jü enchim násuk chë yörisi maachi, ïri enchim nésauta jorianake. ");
INSERT INTO mfy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bueïtuk jü jikau áu tóboktéame, kóm tahuariana; të jü bétuk áu jípureme éntok, jikau tóboktiana. ");
INSERT INTO mfy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Të, ¡jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Juka téhuekapo réy nésautem yoremem béchïbo páttiaka, eme júne kaa áman kíkkimu, entok jume áman kimu báareme júnem kaa áman kimutua. ");
INSERT INTO mfy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Jume jámut jókoptula káarim emo áttia mámaka, íachïrem jíahuiteka oraciónim tettëbem johua. Íäri béchïbo chë bétte noki enchimmet chúpatunake. ");
INSERT INTO mfy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Buíachi entok bahuechi mékka tájti náa sájaka, juka religiompo kaa enchimmak anemta enchimmakem ä tahuatua. Huanärem ínëli ä yáasuka, chë júne enchim béppa béetëu bíchaa ä huéenakeu, ä boo totoja. ");
INSERT INTO mfy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Jiokot maachi enchim béchïbo, liliptim huatem böota téjhuame! Inëlem jiaahua: “Bueïtuk jábetaka junne tiöpota bát kéchaka ä nokäu lútüriateme, kaitapo tatahua; të jábetaka junne juka orota tiöpopo ayukamta bát kéchaka ä nokäu lútüriateme, ä béjtuanakë béchïbo úttiataka tatahua.” ");
INSERT INTO mfy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Kaa susuakem liliptim! Bueïtuk, ¿jítasasu chë yörisi maachi? ¿Jü oro o jü tiöpo orota Diostau bíchaa näikiame? ");
INSERT INTO mfy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inëlem két jiaahua: “Jábetaka junne juka tiöpo altarta bát kéchaka ä nokäu lútüriateme, kaitapo tatahua; të jábetaka junne juka ofrendata Diostau bíchaa näikiata altarta béppa órekamta bát kéchaka ä nokäu lútüriateme, ä béjtuanakë béchïbo úttiataka tatahua.” ");
INSERT INTO mfy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Enchim éäpem aane, éntokem liliptim! ¿Jítasu chë yörisi maachi? ¿Jü ofrenda Diostau bíchaa näikiari, ö jü altar, juka Diostau bíchaa näikiata áa béppa órekamta santosi joame? ");
INSERT INTO mfy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bueïtuk jü altarta bát kéchaka ä nokäu lútüriateme, kaa íäri béchïbo jíba ä nokäu lútüriate, ál‑la jü sïme áa béppa órekamta béchïbo kétchi. ");
INSERT INTO mfy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jü tiöpota bát kéchaka ä nokäu lútüriateme, kaa íäri béchïbo jíba ä nokäu lútüriate, ál‑la Dios áma anemta béchïbo kétchi. ");
INSERT INTO mfy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Juka téhuekata entok Diosta áma yeyesäu bát kéchaka ä nokäu lútüriateme, huaka áma kátekamta béchïbo két ä nokäu lútüriate. ");
INSERT INTO mfy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Të, ¡jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Bueïtuk eme juka júya méntata, anísta, entok cominota, diezmota áma yeu huíkeka Diostau bíchaa näikia; tem juka chë yörisi machik Moiséjta leypo huémta yeu tahuaria. Juka lútula huémta, yore nák jiokolihuamta, entok Dios éehuamta, íkärem kaa yeu tahuariaka ä yáa éiyey kétchi, të juka huatek kaa kóptiaka. ");
INSERT INTO mfy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Liliptimtakem huatem böota téjhua! ¡Juka huetëpäritem yeu baayu, të juka kameyota éntokem huïuktia! ");
INSERT INTO mfy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Të, ¡jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Bueïtukem juka báasota entok puraátota, béppatana tülisem ä bábaksia; të huáijhuatana enchimmet tápuni, jü ékbuahuame entok jü jáchin júne yún jítasu áttia péehuame. ");
INSERT INTO mfy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Parisero lipti! Báchë juka báasota entok puraátota huáijhua tüte; bueïtuk junëli béja päkutana két tütetaka ä tahuanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Të, ¡jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Eme kókkolam sepultura tósalisi béppa bíttu bénäem; yeutanem musäla machisi bíttu, të huáijhua éntokem mukira ótammey tápuni, entok sïme chïcha máchirayi. ");
INSERT INTO mfy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ínëli kétchi emëe, lútüriapem päkutana yoremem bíchäpo, türik johuamta bénasi emo nüye; të huáijhua kaa tü yórememtakem emo tü johua; kaa tühua éntok enchimmet tápuni. ");
INSERT INTO mfy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Të, ¡jiokot maachi enchim béchïbo, escriibam entok pariserom, kaa tü yóremtaka emo tü joame! Bueïtuk jume profeetam sepulturamem johua, entok jume lútüriata boojoriaka kókkolame béppa monumentom sesehuatua. ");
INSERT INTO mfy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Huanärem ínel jiaahua: “Bueïtuk ítapo itom áchayim taahuarimmet jiápsakätek, kaibute ámemak chätuka jume profeetam ójbo guötia éiyey.” ");
INSERT INTO mfy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Inëlem emesu emo yeu buísse, jume profeetam súakame enchim áchayekä bétana. ");
INSERT INTO mfy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Eme kétchi, jume bannataka kat‑riam naatekähui, ¡akem ä chúpasu! ");
INSERT INTO mfy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Bakochim! ¡Bakot usiataka nát tómti kateme! ¿Jáchisem emo ä guójania máchile, juka bétte nokta infierno táijta béetëu enchim huérianakëhui? ");
INSERT INTO mfy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Huäri béchïbone enchimmeu am bíttua, jume profeetam, entok buére jita täyame, entok jïojtelerom. Ímërem huatem súanake, kúrusit am poponaka; éntokem huatem bemmuchanake, enchim singoogampo; éntokem huatem jájjanake buére jóäram bëkatana. ");
INSERT INTO mfy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jü lútula jiápsame ójbo, buíata béppa guötekame sïme enchim béppatunake, jü Abelta ójbo lútula jiápsaka mukukäpo naateka, entok Zacarías, Berequíasta üusi ójbou tájti, íkäi jum tiöpota entok altarta násuk enchim mëakähui. ");
INSERT INTO mfy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lútüriapone ínel enchimmeu jiaahua: Ïri sïme ámeu huéenake, jume én nát tómti kateka jiápsammehui. ");
INSERT INTO mfy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Emëe Jerusalénpo joome, emëe Jerusalénpo joome! ¡Émem am memësuk, jume profeetam, éntoke tétammey am mamaasuk, jume emou bíttuarim! ¡Jaikisisune jume em üusim náu tóij bábarek, jáchin juka tótorita ili tótorim másam bétuk náhuä totoja bénasi! ¡Të katem báarek! ");
INSERT INTO mfy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Én éntok jü enchim jóuhua sipa sóola kaabe áma aneka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bueïtukne enchimmeu júnel jiaahua: Én naatekem kaa nee bínnake, ál‑la júnakoy ínel enchim jíayo: “¡Buére al‑leehuamta jípureka itou yebisise, jü Señorta téhuampo huéeme!” ");
INSERT INTO mfy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesústa tiöpopo yeu simlataka ä huéeyo, ä discíipulom áu rúktek, jume tïopopo káarim ä bíttua báreka. ");
INSERT INTO mfy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Áapo am yómmiaka ínel ámeu jiaahua: —¿Íkärem sïmeta bitcha? Lútüriapone ínel enchimmeu jiaahua, kaita ímï téta nát béppa kateka tahuanake, bueïtuk sïme tátaptaka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesústa káu Oliivompo ä kátek, ä discíipulom bempolaika áu rúktek, ínel jíaka: —Itomë téjhua, ¿jahueysu naatenake jäni jü huéenakeme? Entok, ¿jita señalsu ayunake enchi yebijnakeyo, entok ániata lütinakeyo? ");
INSERT INTO mfy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús am yómmiaka ínel ámeu jiaahua: —¡Tüisem jítat suuhua! Kaabe enchim bäitäunake, ");
INSERT INTO mfy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bueïtukim juebénaka yáijnake, ín téhuampo emo katë tíaka: “Ínapone jü Cristo”, ti jíaka; entokim juebenam bäitäunake. ");
INSERT INTO mfy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Éntokem náu nássuahuamta jikkaijnake, entok náu nássua báahuaka náu ettejhuamta. Katem jáchim emo éetua, bueïtuk úttia sïmeta íkäi huéenakëhui; të ketune kee jee yuuma, jü taahuari ániata lütinakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bueïtuk huépü nación täbui nacióntamak nássua báreka áu tóboktianake, entok huépü réy nación tattäbui réy naciónta béj‑reka áu tóboktianake. Tébaa entok kökoa ayunake, entok juebena bëkatana buía áu yoonake. ");
INSERT INTO mfy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Íkäi sïmeta huë násuk, én jübua naatenake, jü kökosi éehuame. ");
INSERT INTO mfy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Huanäi huate jiokot enchim jonakeme, yaura mampo enchim toijnake, éntokem súana, ínomak enchim katë béchïbo, sïme gentem enchim omtianake. ");
INSERT INTO mfy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Juebénakam Diosta bem súalëu tóijnake. Emom béj‑reka emo yeu buíjnake, entokim kaa emo huáatiaka emo omtianake. ");
INSERT INTO mfy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Juebénakam emo tóboktianakee profeetamtaka Diosta béchïbo emo nokä tíaka, entokim juebenam bäitäunake. ");
INSERT INTO mfy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Juka kaa tühuata áu büruriakä béchïbo jü emo nákhuame sipnake. ");
INSERT INTO mfy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","pTë jábe ä mukëu tájti ínot éaka jiápsakame, Diostamak jíbapo béchïbo jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ïri evangelio Dios réy, sïme ániat jiápsammeu nokna; bueïtuk jume naciónim ä jikkáijanakë béchïbo. Huanäi béja yúmanake ániata lütinakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Eme ä bichätek, juka Diosta béj‑reka kaa türik áma johuamta, jum tiöpo altar chë yörisi machiku, profeta Danielta jïojtekähui —jü jïojterita nokame, át suaka át jüneenake—, ");
INSERT INTO mfy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","huanäi jume Judeapo jóakame júya káhuiu bícham tenninake. ");
INSERT INTO mfy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jü kárit jikat aneme, kaa kóm sika káapo huáijhua jita nü báanake. ");
INSERT INTO mfy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jü huaj päriapo aneme, kaa amáu nótteka béppa súpem nü báanake. ");
INSERT INTO mfy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Jiokot machinake, jume jáamuchim abe asoame béchïbo, entok jume il‑lïchim asoaka am chïtuame! ");
INSERT INTO mfy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diostahuem buaana, bueïtuk juka yeu tennihuäu kaa séberiapo entok kaa jimyore táapo ä huénakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Júnakoy jiokot emo bít-huame ayunake. Ïri ániata jünaktehuak naateka, kaabe ä bil-la, entok chúkula junne, kaabe ä bínnake. ");
INSERT INTO mfy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Huámëi taahuarim kaa chúktiahuakäteko, kaabe jínëutu éiyey; të jume yeu púarim ä nákë béchïbo, huámëi taahuarim chúktiatunake. ");
INSERT INTO mfy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Huanäi senuk ínel enchimmeu jíayo: “¡Akem ä bitcha! Ímï aane jü Cristo”, ö “Áman aane”, katem ä súale. ");
INSERT INTO mfy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bueïtukim emo tóboktianake emo Cristo tíaka, jume yore bäitähuame, entok emo profeetam tíaka buéresim señaalim entok milagrom jonake. Ínëli áma yumäteko jume yeu púarim júnem bäitäu báanake. ");
INSERT INTO mfy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Béjane bannaataka enchim téjhuaasula. ");
INSERT INTO mfy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Íäri béchïbo, ínel am jíayo: “¡Akem ä bitcha, jó! Áma aane, áman buéeka päriapo”, katem áman sásaka. Ö, “¡Akem ä bitcha! Buére káapo aane, kárit jikachi”, katem ä súale. ");
INSERT INTO mfy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bueïtuk jáchin juka yúku béroktiriata täata yeu huë bétana kóm sika entok täata áman huéchëu tájti ä machiriä bénasi, junëline bíttunake, ínapo jü Yoremta Üusi yepsateko. ");
INSERT INTO mfy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bueïtuk ják junne takaa mukirata bökäpo, tekuem áma náu yáijnake. ");
INSERT INTO mfy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Jiokot emo bíthuä násuk chúkula huámechi taahuarimmet sejchúkti, jü täa kaa machisi tahuanake; jü mecha júne kaa machirianake; jume chókim entok téhueka bétana kóm huáttinake. Jü téhuekapo úttiära éntok áu yoyoonake. ");
INSERT INTO mfy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Huanäine téhuekapo bíttunake, ínapo jü Yoremta Üusi señalpo. Huanäi sïme jü yóremra ánia buíapo náu huéerim buanakam siroknake; entokimne bínnake, ínapo Yoremta Üusi namupo téhueka bétana äbo kóm huëteko, úttiata jípureka entok buéresi sïmek béppa ujyoriku. ");
INSERT INTO mfy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Trompeta jíahuita kuseka ä ángelesim náa bíttuanake, jume yeu púarim náu am tóijnakë béchïbo, jum naiki kätana jekata huëpo, jákun buíata yumäu tájti, téekata naatëpo entok jákun ä chúpëpo tájti. ");
INSERT INTO mfy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Jume chunam bétanem ä jüneria, juka ejemplota, jume mesëkiriam básiu táytek, entok jume sáhuam sisiali táytek, jü tasaria béja abe äbo yuuma. ");
INSERT INTO mfy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ínëli kétchi emëe, íkäi sïmeta bichäteko, jüneäem béja puertapo äbo ä yúmasëhui. ");
INSERT INTO mfy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lútüripone ínel enchimmeu jiaahua, jume én nat tómti kateme kee jee kókkoy, ïri sïme bíttunake. ");
INSERT INTO mfy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jü téhueka entok jü buíya lütinake; të jü ín nooki jíbapo béchïbotunake. ");
INSERT INTO mfy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Të juka taahuata entok orata kaabe ä jüneria, jume téhuekapo ángelesim junne, ál‑la ín Átchay jíbba. ");
INSERT INTO mfy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Të juka Noéta taahuarimpo jáchin yeu ä sikä bénasi, junëline bíttunake, ínapo jü Yoremta Üusi yepsäteko. ");
INSERT INTO mfy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bueïtuk júnakoy diluviota kee jee naateyo, jïbuäkam vino jëyey, emom juubey, huate entok juptuahuay; júnensu taahuari yuumak, Noéta barcopo kibaknakëhui. ");
INSERT INTO mfy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Katim jünëiak, júnensu yepsak jü diluvio huanäi sïmem nuksika, inëlitunake kétchi, ínapo jü Yoremta Üusi yepsäteko. ");
INSERT INTO mfy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Huanärim guoyika huajpo annake; huépülaka núk sákana, senu éntok áma tö sákana. ");
INSERT INTO mfy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Guoy jáamuchim molinopom tujnake; huépülaka núk sakana, senu éntok tö sákana. ");
INSERT INTO mfy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Katem koptel‑la, bueïtukem kaa jüneiya, ják ániata huëpo ín yebijnakëhui, ínapo jü enchim Señor. ");
INSERT INTO mfy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Entok íkärem két jüneriapo yúmala: jü jóapo nésahueme jüniäteko ják orapo juka lak‑ronta yebijnakëhui, kaa kócheka ä kaari suaya éiyey, lak‑ronta kaa áman kibaknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ínëli kétchi, eme yúmalasem emo jípureka aane; bueïtuk ínapo jü Yoremta Üusi kaa enchim ä boobíchäpone yebijnake. ");
INSERT INTO mfy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Jábesu jü sáyhuame suaka ä teko éä páman áu nüyeme? Ïri jü sáyhuamta mámpo ä famiiliahua tö simnake, tiempopo ä jïbuätuanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Huanäi buére al‑leehuame áa béchïbotunake, jü tekipanualerotachi, ä teko yepsayo tekipanuamta tíakäteko. ");
INSERT INTO mfy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tua lútüriapone ínel enchimmeu jiaahua, sïmeta ä áttiahua ä mámpo yéchanake. ");
INSERT INTO mfy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Të ïri tekipanualero ä jiápsipo kaa tüisi ínel ée táyteko: “In teko kara läuti yepsa”, ");
INSERT INTO mfy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","áamak tekipanualerom béb táyteko entok vino jëyemmak jïbuäka vino jï táyteko, ");
INSERT INTO mfy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ïri yoremta teko yebijnake, hua taahuari kaa ä boobíchäpo, entok ják ániata huéy kaa ä jüneäpo. ");
INSERT INTO mfy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Huanäi bétte nokta át chúpanake. Kaa tü yóremtaka tü yóremta bénasi emo antuammak yéchatunake; huämïrim támim kuchichïti jiautuaka buannake. ");
INSERT INTO mfy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Jü Diosta téhuekapo réy nésauri guojmamni jámut bebemem bénanake. Ímëri juka jubemta mabet báreka bem lámparam nüka yeu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mamnikam suamsi emo nüyey; jume huate mamni éntok kaa suamsi. ");
INSERT INTO mfy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jume kaa suamsi emo nüyeme bem lámparam nüka, tem aceiteta kaa nüka. ");
INSERT INTO mfy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Të jume suamsi emo nüyeme, aceiteta boteampo nüka, bem lámparammaki. ");
INSERT INTO mfy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Juka jubemta kaa läuti yepsako, sïmetakam kótchok, yetem ámeu yúmako. ");
INSERT INTO mfy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Huanäi éntok tukaa násuk huéy kusisi chayhuame jíkkaijtuk: “¡Äbo huéiye, jü jubiseme! ¡Yehuem sájaka ä mabeta!” ");
INSERT INTO mfy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Huanäi sïme jume jámut bebemem, jotekam bem lámparam tütek. ");
INSERT INTO mfy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Huanäi jume kaa suamsi emo nüyeme, jume suamsi emo nüyemmeu ínel jiaahua: “Aceitetem itom mákka; bueïtuk jume itom lámparam tutuke.” ");
INSERT INTO mfy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te jume suamsi emo nüyeme am yómmiak, ínel jíaka: “Kaa itou ä bïnakë béchïbo, entok enchimmeu junne, ámanem kaate, jume aceiteta nenenkammehui. Huanärem ä jínnu, enchim béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Të bempörim bát aceiteta áman jínnuyo, jü jubeme yepsak. Huanäi jume yúmalasi emo jípureme, áamaki jum pajko bóodau kiímuk. Huanäi jü puerta páttiahuak. ");
INSERT INTO mfy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Të chúkula kéchim áma yájjak, jume huate jámut bebemem, ínel jíaka: “¡Señor, señor! ¡Puertatë itom étaporia!” ");
INSERT INTO mfy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Të áapo am yómmiaka ínel jiaahua: “Lútüriapone ínel enchimmeu jiaahua, kanne enchim täya.” ");
INSERT INTO mfy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huanäi Jesús ínel ámeu jiaahuak: —Katem koptel‑la, bueïtuk katem jüneïya jita táapo entok ják ániata huëpo, ínapo jü Yoremta Üusi yebijnake. ");
INSERT INTO mfy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Bueïtuk jü Diosta téhuekapo réy nésauri, yoremta mékka bíchaa sikamta bénna. Të kee simeka ä tekipanualerom núnuka, ä tómihua bem mámpo tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Huanäi huépülak mamni talentom mákkak, senuk éntok guoy talentom, senuk éntok huépul talentota, ínëli hueepulam bem áma yumäpo ámani. Huanäi mékka bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Huanäi jü mamni talentom mákhuakame, ámey tekipanuaka júchi mamni talentom koobak. ");
INSERT INTO mfy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ínëli kétchi jü guoy talentom mabetakame, júchi guoy talentom ámey koobak. ");
INSERT INTO mfy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Të jü huépul talentota mabetakame, sika jïbuejeka ä teko tómi éssok, ä mäakari. ");
INSERT INTO mfy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chúkula yún tiempota simsuko, jü tekipanualerom teko yepsak. Huanäi am núnuka am nátemajek, juka tómita bem mabetakäu bétana. ");
INSERT INTO mfy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Huanäi jü mamni talentom mabetakame áma yepsak, júchi mamni talentom huériaka, ínel jíaka: “In Señor, mamni talentomë nee mákkak; ímïrim óorek; júchine mamni talentom áme béppa koobak.” ");
INSERT INTO mfy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Huanäi ä Señorhua ínel áu jiaahua: “Türi, empo tü tekipanualero ára emót eetu kaa jaikik mabetaka junne tüise tekipanuak. Én éntokne chë juebenak béppa enchi yéchanake. Señorta al‑lerihuäpë kibake.” ");
INSERT INTO mfy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Huanäi jü guoy talentom mabetakame két áma yepsak, ínel jíaka: “In Señor, guoy talentomë nee mákkak; ímïrim óorek; júchine guoy talentom áme béppa koobak.” ");
INSERT INTO mfy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Huanäi ä Señorhua ínel áu jiaahua: “Türi, empo tü tekipanualero ára emót eetu; kaa jaikik mabetaka junne tüise tekipanuak. Én éntokne chë juebenak béppa enchi yéchanake. Em Señorta al‑lerihuäpë kibake.” ");
INSERT INTO mfy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Të hua huépul talentota mabetakame két áma yepsak, ínel jíaka: “In Señor, enchine täya, nésauta béttek em jípurëhui, entok kaa em echakäpo júne enchi jíjichupähui, entok kaita báchiata em guötiakäpo em jita náu totojähui. ");
INSERT INTO mfy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Huäri béchïbone májhueka, sika buíapo ä éssok, juka em tómmi. Ímïre ä jípure, juka em áttia.” ");
INSERT INTO mfy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ä Señorhua ä yómmiaka ínel áu jiaahua: “¡Empo tekipanualero kaa türi entok obëra! Tüise jüneiyay kaa ín echakäpo ín jíjichupähui, entok kaita báchiata ín guötiakäpo ín jita náu totojähui. ");
INSERT INTO mfy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Júntuksan empo juka ín tómmi, jume bankerommeu ä réutebo éiyey. Huanäi ínapo yepsakätek, juka ín tómi mabet éiyey, entok ä kobarimaki.” ");
INSERT INTO mfy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Huanäi ínel jiaahua: “Juka talentotem ä úuhua. Huanärem juka guojmamni talentom jípuremta ä mákka. ");
INSERT INTO mfy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bueïtuk jü jita jípureme, huatek mákna, chë yún ä jípunakë béchïbo; të jü kaita jípureme, jü ilikkik ä jípurëu junne ä úuhuatunake. ");
INSERT INTO mfy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ïri tekipanualero kaita béchïbo türik, pákunem kaa machikun yehuä jímma. Huämïrim támim kuchichïti jiautuaka buannake.” ");
INSERT INTO mfy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Júnakoy ínapo jü Yoremta Üusi sïmek béppa ujyoriku huéekane yepsayo, entok sïme jume santo ángelesim ínomaki, huanäi jum áma jojohuäpo sïmek béppa ujyorikune yejtenake. ");
INSERT INTO mfy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Huämïri jume sïme naciónim áu náu tóijna. Huanäi hueepulam huatem násuk näikimtenake, juka kabyerota kabaram chivam násuk am näikimte bénasi. ");
INSERT INTO mfy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Huanäi jume kabaram ä bátatana jäbuanake; jume chivam éntok ä míkötana. ");
INSERT INTO mfy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Huanäi jü réy ínel ámeu jiaunake, jume ä bátatana jäbuekammehui: “¡Binem kaate, emëe ín Átchay bétana al‑leehuäpo yeu púarim! Akem ä mabeta, juka réytamak enchim béchïbo näikiata nesaunakëhui, juka ániata jünaktehuak naateka. ");
INSERT INTO mfy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bueïtuk nee tébäurey, nechem jïbuä miikak; nee bäa jï péay, nechem bäam miikak; ín jóau mékka nee hueramay, enchim jóapem nee mabetak; ");
INSERT INTO mfy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kaa nee sánkoko, nechem sánkotuak; nee kökorey, ínohuem nóiteka nee bitchak; cárcelpo nee kátek, ínohuem nóitek.” ");
INSERT INTO mfy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Huanäi jume lútula jiápsakame ä yómmiakam ínel jiaunake: “Señor, ¿jauhueysute tébäuremta bíchaka enchi jïbuätuak, entok enchi bäa jï péayte enchi bäam miikak? ");
INSERT INTO mfy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Entok, ¿jauhueysute em jóau mékka enchi hueramay, itom jóapo enchi mabetak, entok kaa enchi sánkokte enchi sánkotuak? ");
INSERT INTO mfy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Entok, ¿enchi kökorey entok cárcelpo enchi kátekte emou nóitek?” ");
INSERT INTO mfy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huanäi jü réy am yómmiaka, ínel ámeu jiaunake: “Lútüriapone ínel enchimmeu jiaahua, ímëi ínomak rejteme chë bétuk emo nüyeme enchim ámeu yáakähuem, ínohuem ä yáuhuak.” ");
INSERT INTO mfy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Huanäi jume míkötana anemmeu ínel jiaunake: “Sékäna bichem kaate, eme kaa türikun bíchaa näikiarim, táijta kaa tutukëu bíchaa; ïri jü diablota béchïbo chúpari, entok ä ángelesim béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bueïtuk nee tébäurey, katem nee jïbuätuak; nee bäi mukey, katem nee bäam miikak; ");
INSERT INTO mfy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kaa ín jóa bëmu nee hueramay, enchim jóapem kaa nee mabetak; kaa nee súpek, katem nee sánkotuak; nee kökorey, entok cárcelpo nee kátek, katem ínou nóitek.” ");
INSERT INTO mfy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Huanäi bempo két ä yómmiaka ínel áu jiaunake: “Señor, ¿jauhueysute tébäuremta enchi bitchak, bäa jï péamta, entok kaa em jóa bëmu enchi hueramay, kaa enchi sánkoko, enchi kökoreyo, entok cárcelpo enchi kátek, katte enchi aniak?” ");
INSERT INTO mfy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Huanäi am yómmiaka ínel ámeu jiaunake: “Lútüriapone ínel enchimmeu jiaahua, ímëri kaitapo bít-huammeu kaa enchim ámeu yáakäu, ínou júnem kaa ä yáuhuak.” ");
INSERT INTO mfy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ímëri jíbapo béchïbo bétte nokta ámet chúpëhuim kannake; jume Diosta béchïbo lútula jiápsakame éntok, jíbapo béchïbo jíapsihuähuim yáijnake. ");
INSERT INTO mfy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús sïmeta íkäi noksuka, ä discíipulommeu ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Jüniäem guoy taahuarim jíba bëyëhui, pajko pajkuata yáanä béchïbo. Huanäi ínapo jü Yoremta Üusi huatem mámpo tóijna, kúrusit ín poponnä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Huanäi jume tiöpopo chë nésahueme, entok jume escriibam, entok jume pueblopo chë yö yáarim, Caifásta tebat jóapom emo náu tójjak, ïri jume sacerdotemmeu kobanarotukay. ");
INSERT INTO mfy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Náhuim yájaka nokta náu tütek, Jesústa bäitäupo buíseka, ä më béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tem ínel jiaahuay: —Kaa pajko táapo, bueïtuk juka genteta kaa buére éaka emo am tóboktianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pueblo Betaniapo Jesústa aneyo, Simmom Leproso ti téttehuahuamta jóapo, ");
INSERT INTO mfy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","jámut yepsak, botea alabastropo perfumeta tüisi béj‑remta áma huériaka. Huanäi Jesústa mesau ä káteko kóbat áachä töak. ");
INSERT INTO mfy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ä discíipulom íkäi bíchakam öomtek, ínel jíaka: —¿Jatchiakasu ïri kía guötiahua? ");
INSERT INTO mfy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bueïtuk ïri ára nénkituy, yún tómipo; huanäi jume póobem áy ania éehuay. ");
INSERT INTO mfy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ä jüneriaka, ínel ámeu jiaahua: —¿Jatchiakasem íkäi jámutta muksi bitcha? Bueïtuk jü ínou ä yáakäu, tuhuata johuäpo türi. ");
INSERT INTO mfy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bueïtuk jume póobem jíbem enchimmak jípunake; nee éntok ëe. ");
INSERT INTO mfy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bueïtuk íkäi musäla jubak ín takaa béppa töak, huéchiapo ä tahuatuaka nee mäanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lútüriapone ínel enchimmeu jiaahua, jákun tájti íkäi evangeliota nokhuäpo, sïme ániachi két nokna, íkäi jámutta yáakähui, áapörikúu huáatinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Huanäi huépülaka doocemmak näikiari, Judas Iscariote ti téhuaaka, jume tiöpopo chë yö yáarimmeu siika. ");
INSERT INTO mfy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Huanäi ínel ámeu jiaahua: —¿Jítasem nee máknake, Jesústa enchim mámpo nee ä tójako? Huanäi bempo treinta tómi tósalita ä mák rókkak. ");
INSERT INTO mfy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huanäi naateka ä jariay, jáchin bem mámpo ä tóijnakëïhui. ");
INSERT INTO mfy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Senu taahuata huéy, jume páanim kaa levaduuraka buähuaka pajkohuay, ä discíipulom áu yájaka ínel áu jiaahua: —Juka pajkua jïbuähuamta yáa béchïbo, ¿jákusë itom ä yáa ïa? ");
INSERT INTO mfy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Huanäi Áapo ínel ámeu jiaahua: —Ámanem kaate buere jóarä Jerusalénihui, ímïrem yoremta áma téunake. Huanärem ínel áu jiaunake: “Jü Maestro ínel jiaahua: Jü tiempo ino bétana béja yúmase; em jóapo nee pajkuata kúptey jïbuähuamta ín discíipulommak buä báare.” ");
INSERT INTO mfy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Huanäi jume discíipulom Jesústa nésahuekä páman ä yáuhuak. Inëlim pajkuata buä béchïbo sïmeta huéchiapo tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tukariu yúmak, mesau yejtek, jume doocemmaki. ");
INSERT INTO mfy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Am jïbuä násuk ínel ámeu jiaahua: —Lútüriapone ínel enchimmeu jiaahua, huépülaka enchim násuk nee yeu buíseka, huatem mámpo nee tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Huanärim tüisi sirokaka, hueuhuëpulaka ínel áu jiau táytek: —Señor, ¿jachune ínapo ájäria jäni? ");
INSERT INTO mfy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huanäi Jesús am yómmiaka ínel jiaahua: —Huä puraatopo mámam sütéame ínomaki, ïri nee yeu buíseka huatem mámpo nee tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Të lútüriapo ínapo jü Yoremta Üusi ino bétana ä jïojteri páman huéeka inot chúppe. Të ínapo jü Yoremta Üusi nee yeu buísekamta béchïbo, ¡Tüisi jiokot maachi! Ïri outa béchïbo chë türi éiyey, kaa yeu yóremtukäteko. ");
INSERT INTO mfy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Huanäi Judas yä buíseka huatem mámpo ä tóijnakeme ä yómmiaka, ínel jiaahua: —Maestro, ¿jachune ínapo ájäria? Huanäi Jesús ä yómmiaka ínel áu jiaahua: —Em nokäpë empo emo ájariä tíiya. ");
INSERT INTO mfy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ínëli am jïbuäysu, Jesús páanim nüka, Diosta baysahueka am rébektiak. Huanäi ä discíipulom am mákkak, ínel jíaka: —Akem am nüka am buäye; ïri ín takaahua. ");
INSERT INTO mfy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Juka copata nüka, Diostau baysausuka bempörim ä mákkak, ínel jíaka: —Akem ä jëye sïmetaka. ");
INSERT INTO mfy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bueïtuk ïri ín ójbok, nokta yéchaka Diostamak bemelasi emo tütehuäpo. Ïri ójbo juebenam béchïbo guötek, bem kaa tü yáarim jiokorinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Inenne két enchimmeu jiaahua, én naatekane kaa éntok ä jïnake, íkäi páras taka bähuata; ál‑la júnak táapone júchi bemelasi enchimmak ä jïnake, ín Átchay réytaka ä nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Huanärim himnom buiksuka yeu sájjak, káhui Oliivou bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Huanäi Jesús ínel ámeu jiaahua: —Emëe sïmetakem ï tukaarit ínot ëhuamtem tärunake; bueïtuk ínëli jïojteri: “Kabyero kökosi yáana; huanäi jume kabaram chíbejtinake.” ");
INSERT INTO mfy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Të chúkula kókkolam násuk jíabitek, enchimpatne huéenake, Galiléa buiaräu bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peero ä yómmiaka ínel áu jiaahua: —Eläposum sïmetaka juka bem emót éäu tójja, të ínapone kaibu enchi tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús ínel áu jiaahua: —Lútüriapone ínel emou jiaahua, ï tukaarichi, totorörata kee kusey, baisë kaa nee emo täya tíanake. ");
INSERT INTO mfy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peero ínel áu jiaahua: —Eläposune émomak muuke, tëne kaibu enchi tóijnake. Huanäi jume huate discíipulom két ánëli jiaahuak. ");
INSERT INTO mfy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Huanäi Jesús bempörimmak Getsemaní tí tehuakäu yepsak. Huanäi ä discíipulommeu ínel jiaahua: —Ímïrem chúbala joye, áman oraciónta ín yäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Perota entok jume guoy Zebedeota üusim nüka, jiápsipo kökosi éaka sirok táytek. ");
INSERT INTO mfy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huanäi Jesús ínel ámeu jiaahua: —In jíapsi tüisi siroka ín mukëu tájti. Ímïrem taahua, éntokem ínomak éaka kaa kótche. ");
INSERT INTO mfy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Chë huam jëla sika tónommia kíkteka buíau tájti müla kóm chätuka, Diostau buanaka ínel jiaahuay: —In Átchay, juka béttesi jiokot machik inou huéenakemta ára nee úuhuätek, nechë ä úuhua; të kaa ín éäpo ámantunake, ál‑la em éä pámani. ");
INSERT INTO mfy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sep läuti ä discíipulommeu yepsaka, kócheme téuhuak. Huanäi Perotau ínel jiaahua: —¿Jachem senu horapo júne kara ínomak taahuak, kaa kócheka? ");
INSERT INTO mfy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Katem kótche, éntokem oraciónta johua; bueïtuk kaa türikum bíchaa kaa enchim jiopnakë béchïbo. Jü espíritu jíba óusi éehuamta jípure, të jü takahua kaa áma yuuma. ");
INSERT INTO mfy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Júchi áman sika, guosa huëpo Diostau buanaka, ínel jiaahua: —In Átchay, íkäi jiokot éehuamta inou huéenakemta úttiatunakey, éläpo em éäpo ámantunake. ");
INSERT INTO mfy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Júchi ámeu yepsaka kócheme téuhuak, bueïtuk bem pusím yetem kaa yüey. ");
INSERT INTO mfy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Am tójaka júchi siika. Huanäi bájikun huëpo Diostau buaanak, jíba ä nokäu nokaka. ");
INSERT INTO mfy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Huanäi ä discíipulommeu yepsaka ínel ámeu jiaahua: —Kóchëem, éntokem jimyoore. Jü hora béja yuumak; ínapo jü Yoremta Üusi kaa tü yóremem mámpo tóijna. ");
INSERT INTO mfy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Jáptëem! ¡Jántebu! Akem ä bitcha: itou jëla huéiye, jü nee buíjtebonakeme. ");
INSERT INTO mfy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ketune Jesústa nokay, Judas áma yepsak, jü doocemmak näikiatukaïhui. Entok huate juebénaka áamak kaatey, kúkutaka entok ejpaparaka, tiöpopo chë nésahueme entok jume pueblopo yö yáarim bétana. ");
INSERT INTO mfy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jü bem mámpo ä tóijseka huéeme sényata am máklatukay, ínel jíaka: —Huä ín besiitonakëhui, jüri ájäria; akem ä jaatia. ");
INSERT INTO mfy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huanäi sep Jesústau rúktek, ínel jíaka: —¡Kétchë al‑leiya, Maestro! Huanäi ä besiitok. ");
INSERT INTO mfy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Huanäi Jesús ínel áu jiaahua: —In amigo, ¿jítasë äbo nüsek? Huanärim Jesústa jaatiaka, ä pereesotek. ");
INSERT INTO mfy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Të senu Jesústamak aneïhui, mámam rútuktiaka, ejparam yeu huíkkek. Huanäi juka tiöpopo tékiakamta tekipanualerota náka chúkti béebak. ");
INSERT INTO mfy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Huanäi Jesús ínel áu jiaahua: —Em ejparamë ëeria; bueïtuk sïmetaka ejparammey nássuame, ejparameyim mëna. ");
INSERT INTO mfy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Jachë én oraciónta kara nee yáa téiyey, ín Áchaybeu nokaka, huanäi áapo ángelesim dooce batallónim béppa inou bíttua eïyey? ");
INSERT INTO mfy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Huanäi, ¿jáchisu áu chúpa éiyey, jü noki jïojteri? Ínëli ínohuä huéenakeu úttia, tä jiäpo. ");
INSERT INTO mfy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Huämi horapo Jesús ínel ámeu jiaahua, jume gentemmehui: —¿Ekbualerota jariamta bénasem yeu sákala nee jaatia báreka, kúkutaka entok ejpaparaka? Enchimne majtiaka chíkti táapo tïopopo enchimmak yeyesay, të katem nee jaatiak. ");
INSERT INTO mfy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sïme ïri ínëli yeu siika, jume profeetam jïojtekäu áhuä chúpanakë béchïbo. Huanäi ä discíipulom sïmetaka ä tö sájaka tennek. ");
INSERT INTO mfy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jume Jesústa buísekame sacerdotemmeu kobanaro Caifástahuim ä núk sájjak. Sïmetakam ámani aaney, jume escriibam entok jume pueblopo yö yáarim. ");
INSERT INTO mfy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peero mékkariat Jesústa sáu huéiyey, jü sacerdotemmeu kobanaro káriu kimuhuäu tájti. Huämi áman kibakeka, jume tiöpota suayame násuk yejtek, juka jáchín ä chúpnakeu bít báreka. ");
INSERT INTO mfy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Huanäi jume tiöpopo chë nésahueme entok jume yö yáarim, jume tiöpo buére yäurammaki, ímëri jábeta kaa lútüriata jípureka Jesústa nätuanakemtam jariay, ínëli át nésahueka ä mënä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tem kaita át téuhuak. Ä junëlituk junne juebénakam Jesústa béj‑reka kaa lútüriata nookay. Të chúkula guoyikam áma yájjak, Jesústa béj‑reka kaa lútüriata nokaka, ");
INSERT INTO mfy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ínel jíaka: —Ïri ínel jiaahuak: “Arane íkäi Diosta tiöpo tátabe, entokne báij táapo ára ä tóboktia.” ");
INSERT INTO mfy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Huanäi jü sacerdotemmeu kobanaro kíkteka ínel áu jiaahua: —¿Jachë jáchin júne kaa am yómmia? ¿Jítasum ímëi emót nooka? ");
INSERT INTO mfy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús éntok kaa jíaley. Huanäi jü sacerdotemmeu kobanaro ínel áu jiaahua: —Dios jiápsamta téhuampo, itomë téjhua: ¿Jachë empo jü Cristo, jü Diosta Üusi? ");
INSERT INTO mfy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús ínel áu jiaahua: —Émpë ínel jiaahua, entokne két ínel enchimmeu jiaahua, én naatekem nee bínnake ín Yoremta Üusitukähui, juka Diosta úttiärapo ä bátam bétana kátekamta, entok téhueka bétana namupo yepsamta. ");
INSERT INTO mfy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Huanäi jü sacerdotemmeu kobanaro, ä sánko súpem síuti huíkkek, ínel jíaka: —Diosta béj‑reka béttek nookak. ¿Jachu testiigom ketune áma bëye? Ímïrem eme ä jíkkaja, Diosta béj‑reka béttek ä nokähui. ");
INSERT INTO mfy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jáchisem ä bitcha emëe? Huanäi bempo ä yómmiaka ínel jiaahua: —¡Mukiapo yúmala! ");
INSERT INTO mfy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Huanärim pújbat át chit huáttek, entokim ä chónnay; huate éntok jópemmet ä bébbay, ");
INSERT INTO mfy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ínel jíaka: —¡Bueïtuk empo Cristotukätek itome tejhua! ¿Jábesu enchi bébak? ");
INSERT INTO mfy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peero päkutana kátekay tebatpo. Huanäi senu jámut áma nésauta joame áu rúktek, ínel jíaka: —Empo két áamak aaney, Jesús Galiléapo joometamaki. ");
INSERT INTO mfy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Të áapo sïmem bíchäpo kaa áu ä täya tíiya, ínel jíaka: —Kanne jüneiya jita em nokähui. ");
INSERT INTO mfy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Áapörik puertau bíchaa yeu ä sik, täbuika ä bitchak. Huanäi am téjhuak, jume áma aneme: —Ïri két áamak aaney, Jesús Nazarenotamaki. ");
INSERT INTO mfy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Të áapo júchi kaa áu ä täya tíiya, yörisi machik bát kéechahuamta nokaka, ínel jíaka: —Kannä täya, júkäi yoremta. ");
INSERT INTO mfy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Júchi chúkula, jume áma ják aneïhui, áman rúktekam ínel jiaahua, jü Perotahui: —Tua lútüriapo empo két ámemak aani, bueïtuk jü em nokäu enchi yeu buísse. ");
INSERT INTO mfy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Huanäi áapo jájaana nok táytek, entok yörisi machik bát kéechahuamta nookak: —Kannä täya, íkäi yoremta. Huanäi jü totoröra kúkusek. ");
INSERT INTO mfy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Huanäi jü Peero áu huáhuatek, jü Jesústa noki ínel jíamtahui: “Totororata kee kúseyo, baisë kaa nee emo täya tánake.” Huanäi päkun yeu sika, ä jiápsipo chibusi éaka kökosi buaanak. ");
INSERT INTO mfy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kethueytana, sïme jume tïopopo chë nésahueme entok jume pueblopo yö yáarim, náhuim emo tójaka nokta náu tütek, Jesústa mëtebo báreka. ");
INSERT INTO mfy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huanärim Jesústa súmaka ä núk sájjak; ínëlim Poncio Pilato gobernadortau ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Huanäi Judas, yä buíseka bem mámpo ä yéchakame, juka bétte nokta át chúpëu bíchaka, áu temajek. Huanäi jume treinta tómi tósalim ámeu nóttiriak, jume tïopopo chë nésahuemmehui, entok jume yö yáarimmehui, ");
INSERT INTO mfy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ínel jíaka: —Diosta bíchäpone kaa tüisi ayula. Juka kaita juënak yáalata yeu buíseka enchim mámponä tójjak, ä mënä béchïbo. Të bempo ínel áu jiaahua: —Ítapote kaita áma jüneria; të, ¡empo ál‑la! ");
INSERT INTO mfy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Huanäi tiöpopo juka tómi tósalita guötiaka, yeu sika áu cháyyak. ");
INSERT INTO mfy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Huanäi jume tiöpopo chë nésahueme, akim ä nüka, juka tómi tösalita, ínel jíaka: —Kaibu türinake, tiöpopo tómimak ä kuutia béchïbo, bueïtuk ójbo tómmi. ");
INSERT INTO mfy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chúkula náu ettejosuka, babuta tekipanuamta huaj buía áy jínnuhuak, jume kaa áma joomem áma mäa béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Íäri béchïbo én tájti ïri huaj buíya, “Ójbo Buíya”, ti téhuak. ");
INSERT INTO mfy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ínëli áu chúppa, jü profeeta Jeremíajta nokakähui, ínel ä jíako: “Huanärim am nüka, jume treinta tómi tósalim (juka nákhuamta béj‑ri, israeliitam ä béjhua aahuaka pámani). ");
INSERT INTO mfy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Babuta tekipanua huaj buía áy jínnu béchïbo taahuak, Señorta nésauta nee mákakä pámani.” ");
INSERT INTO mfy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús áma huéekay, gobernadortau lúl‑la. Huanäi ä nátemajek, ínel jíaka: —¿Jachu empo jü judíommeu réy? Huanäi Jesús ä yómmiak: —Émpë ínel jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jume sacerdotem kobanarom entok jume yöyoturi pueblopo chë nesahueme bétana nätuahuaka junne, entok Jesús kaa jíalek. ");
INSERT INTO mfy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Huanäi Pilato ínel au jiaahua: —¿Jachë kaa am jíkkaja, juebenak bétana enchi nätuame? ");
INSERT INTO mfy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Të Jesús huépul nokta júne kaa ä yómmiak. Íäri béchïbo jü gobernador tüisi buére éiyay. ");
INSERT INTO mfy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ínëli huémta násuku, pajko táapo costumbreta jípuhuä pámani, jü gobernador pueblota bíchäpo huépul pereesota butbúttiay, jábeta bem huáatiaïhui. ");
INSERT INTO mfy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Júnakoy éntokim pereesota áma jípurey, Barrabás ti téhuaakamta; ïri buéresi jita yáalataka täyahuay. ");
INSERT INTO mfy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ínëli bempörim náu emo tóij‑latuk, Pilato ínel ámeu jiaahua: —¿Jábetasem nee búttia ïaa: Barrabásta, ö Jesústa, Cristo ti téhuaakamta? ");
INSERT INTO mfy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bueïtuk jüneiyay, kía át kopteka áma yeu ä tóijtukaïhui. ");
INSERT INTO mfy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Juka Pilatota, jume yäura tribunalim jojoyëpo ä kátek, ä jubiahua nokta áu bíttuak: “Katë áu suuhua, hua sïmeku lútula huémta joamtahui, bueïtuk ëni tüisine jantiachisi tenkula, áapörik béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Të jume sacerdotem kobanarom entok jume pueblopo yöyoturim, juka gente juebenaratam téjhuak, chë türinake tíaka, Barrabásta búttianäu, Jesústa éntok mëtebonähui. ");
INSERT INTO mfy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jü gobernador am yómmiaka ínel ámeu jiaahua: —¿Jábetasu júntukne búttianake, jume guoyim násuku? Bempo éntok ínel jiaahua: —Barrabásta. ");
INSERT INTO mfy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ínel ámeu jiaahua: —¿Jítasem júntuk nee áu yáa ïa, jü Jesús Cristo téamtahui? Sïmetakam ínel jiaahuak: —¡Kúrusichë ä popontebo! ");
INSERT INTO mfy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Huanäi jü gobernador ínel ámeu jiaahua: —¿Jíta juënaksu júntuk yáala? Të bempo chë júne chaayey, ínel jíaka: —¡Kúrusichë ä popontebo! ");
INSERT INTO mfy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jü Pilato juka yáa báahuamta bát bíchaa huémta bíchaka, entok juka kaa nanabeu éehuamta chë jikau chätuyo, huanäi bäam aahuaka áu mám báksiak sïmem bíchäpo, ínel jíaka: —Kaitane áma kúlpak, íkäi yoremta ójbopo lútula huéeka ä jiápsäpo, bueïtuk kaitane juënak át téuhua, ä mënä béchïbo. Enchim mámpo taahua. ");
INSERT INTO mfy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huanäi sïme pueblo áma aneme ä yómmiaka, ínel jiaahuak: —Éläpo ä ójbohua ito béppatunake, entok itom üusim béppa. ");
INSERT INTO mfy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Huanäi Barrabásta búttiak. Jesústa éntok bemmuchateboka, bem mámpo ä tójjak, kúrusit ä poponnä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Huanäi jume gobernadorta sontarom, Jesústam núk sájjak, Pretoriou bíchaa. Huämïrim áa chíkola sïme jume sontarom emo náu tójjak. ");
INSERT INTO mfy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Huanarïm ä sánkohua ä úuhuaka, síkilik ä sánkotuak. ");
INSERT INTO mfy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Huanärim huíchata huikö päaka ä coroona yáaka kóbat áachä yétchak, ä mám bátatana éntok baka kútata. Huanärim áu lúl‑la tónommia jápteka, ä junneriay, ínel jíaka: —¡Yántë jiápsa, judíommeu réy! ");
INSERT INTO mfy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Entokim át chit huathuattey, juka baka kútata mámpo ä jípurëu nükam, kóbat ä bébbay. ");
INSERT INTO mfy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chúkula ínëli ä junneriasuka, entok kökosi ä yáasuka, jume súpe mántom ä úuhuaka, ä sánkohua ä sánkotuak. Huanärim ä núk sájjak, kúrusit ä poponboka. ");
INSERT INTO mfy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huanäi yeu am kateyo, yoremtam nánkek, Cirene jóärau joometa, Simmom ti téhuaakamta. Íkärim úttiapo kúrujta püaktituak, ä huériunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Júnëlim kateka áman yájjak, jum Gólgota ti téhuaakähui. Ïri “Mukila Kóba Káuhui”, tiau báare. ");
INSERT INTO mfy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vinotam Jesústa jïtua báarek, sïkaramak kütiata; të ä jihueka kaa ä jëkak. ");
INSERT INTO mfy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kúrusit ä poponsukam ä sánkobechi nat jäteka náchä näikimtek. Ïri ínel yeu siika, juka profeetata nokakäu áhuä chúpanakë béchïbo: “In súpemim nat näikimtek, entokim ín sánkom nat jätek.” ");
INSERT INTO mfy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Júnëlim huämi ják jotek, ä suayaka. ");
INSERT INTO mfy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huanärim ä kóba béppa jïojteta yétchak, jita béchïbo ä mëhuakahui, ínel jíamta: “Ïri Jesús jü judíommeu réy.” ");
INSERT INTO mfy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Huanäi guoy lak‑ronim áamak kúrusit poponhuak, huépülaka bátatana, senu éntok míkötana. ");
INSERT INTO mfy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jume áma huam kateme, akim ä junneriaka juënasi jíaka kóba huíutey, ");
INSERT INTO mfy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ínel jíaka: —Empo juka tiöpota ára tátabeme entok báij táapo júchi ára ä yéchame, ¡émpë emo jínëu! Bueïtuk empo Diosta Üusitukätek, ¡kúrusitche kóm huéiye! ");
INSERT INTO mfy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ínëli kétchi jume sacerdotemmeu kobanarom, jume escriibam entok jume pueblopo yöyoturim, akim ä junneriaka ínel jiaahuay: ");
INSERT INTO mfy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Huatem jínëuk; ¡áapo éntok kara áu jínëu! Bueïtuk áapo Israeltau réytukätek, ¡én kúrusit kón huéenake! Huanäite ä súalnake. ");
INSERT INTO mfy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Áapo Diostat áu éä tíiya; éläpo áapo ä jínëunake, ä huáatiäteko; bueïtuk áapo ínel jiaula, “Diosta Üusine”. ");
INSERT INTO mfy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kétchi jume lak‑ronim, áamak kúrusit popontukaïhui, akim ä junneriaka juënasi ä aahuay. ");
INSERT INTO mfy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lúl‑la kátek naateka, kúptey bájim jiau tájti kaa machisi taahuak, sïme ániachi. ");
INSERT INTO mfy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kuptilamak abe bájim jiay, Jesús kusisi cháchayek, ínel jíaka: —Elí, Elí, ¿lama sabactani? —itom nokpo ínel jiau báare: In Dios, ín Dios, ¿jatchiakasë nee ínapola tóij‑la? ");
INSERT INTO mfy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jume huate áma aneka ä jíkkajame, ínëlim jiaahuay: —Ï Elíasta núnnu. ");
INSERT INTO mfy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huanäi huépülaka áma aneme läuti ejponjata nüka, vinak‑repo ä kómoniak. Huanäi baka tebet ä óreka, jikau áhuä nóitiriak ä jïnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Të jume huate ínel jiaahuay: —Akem ä tójja. Boobichäem; jamak Elías äbo ä jínëunake jäni. ");
INSERT INTO mfy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Të Jesús júchi huëpo kusisi cháchayeka, ä espírituhua tójaka muukuk. ");
INSERT INTO mfy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huanäi éntok jume velom jum tiöpopo chäkame síutekam guoyisi emo yáuhuak; jikat naateka bétukun tájtim síutek. Jü buía éntok áu yoyoak; jume buere tétam éntok riutek. ");
INSERT INTO mfy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jume sepulturam éntok emo étapok, entok Cristota sualhuäpo nau anim takahua kókkolame násukim jotek. ");
INSERT INTO mfy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Chúkula Jesústa jíabitesuk, ímëri sepulturapom yeu sájjak. Huanärim buére jóära Jerusaléniu juebenammeu yeu machiak. ");
INSERT INTO mfy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jü centurión entok jume huate áamak áma Jesústa suayaïhui, juka buíata junëli áu yoyoakamta bíchaka, entok sïmeta jita áma yeu sikamta, tüisim guómtek. Huanärim ínel jiaahua: —¡Ïri tua yö lútüriapo Diosta Üusitukay! ");
INSERT INTO mfy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Juebena jáamuchim áma aaney, mékka jäbueka ä bíchaka. Ímëri Jesústamakim rejtilatukay, Galiléapo naateka ä aniaka. ");
INSERT INTO mfy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Áme násuk aaney jü María Magdalena, María Jacobota áiye entok Joseta, entok jü Zebedeota üusim áiye. ");
INSERT INTO mfy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tukariu yúmako, senu yoreme rikotaka áma yepsak, Arimatea jóärapo jometaka. Ïri José ti téhuaakay, entok két Jesús ä discíipulokay. ");
INSERT INTO mfy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ïri Pilatotau sika, Jesústa takaahua áu aahuak. Huanäi Pilato nésahuek, Jesústa takaahua ä máknä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Huanäi José juka Jesústa takaahua nüka, sábanam báksiarimpo ä bïtiak. ");
INSERT INTO mfy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Huanäi káu guójöku sepultura bemelapo ä teekak. Íkäi sepulturata José áapo áa béchïbo ä yáalatukay. Huanäi tétata buëuruk röaktiaka áman kíkkimuhuäpo ä óorek. Huanäi siika. ");
INSERT INTO mfy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Entokim két áma aaney, María Magdalena entok hua senu María; sepulturata pújbapom jokay. ");
INSERT INTO mfy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Júchi yokoríapo jimyore táapo, jume tiöpopo chë nésahueme entok jume pariserom emom náu tójjak, Pilatota bíchäpo, ");
INSERT INTO mfy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ínel jíaka: —Yöturi, áute huáate, hua yore baïtáttäusukame ketune jiápsaka ínel jiaahuak: “Báij taahuarim simsukne jíabitenake.” ");
INSERT INTO mfy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Íäri béchïbo amanë am bíttua, jume sepulturata suayanakeme báij taahuarim simsuu tájti. Jáchinay junne jume áamak rejteïhui tukaapom áman sájaka ä ékbuanake. Huanärim jü gentetau ínel jiaunake: “Kókkolam násuk jíabitek.” Ä ínëlituk, jü chúkula bem öbiakäu chë obiachinake, jü bát bem öbiari béppa. ");
INSERT INTO mfy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Huanäi Pilato ínel ámeu jiaahua: —Júmürem am jípure, jume sontarom. Ámanem sájaka enchim jüneä páman ä suayatebo. ");
INSERT INTO mfy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Huanärim áman sájaka tüisi ä páttiak, juka sepulturata, yäura seyoy ä seyotuaka, juka téta puertata; entokim sontarom áma tö sájjak. ");
INSERT INTO mfy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jimyore taahuata simsuko, entok jume guoy búsan taahuarim naatëpo, matchümakim áman sájjak, jum Jesústa maahuakäipo ä bít báreka, María Magdalena entok jü senu María. ");
INSERT INTO mfy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huanäi jü buía tüisi áu yoyoak, bueïtuk jü Señor Diosta ángel, téhueka bétana kóm yepsaka, juka tétata sékäna ä bíaktiaka, áa béppa yejtek. ");
INSERT INTO mfy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ä bíthuäpo yúku béroktiriata bénasi bélojkosi machiakay. Jü ä sánkohua éntok sápa tósalim bénaakay. ");
INSERT INTO mfy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jume sontarom ä bíchaka májhueka emo yoohuay, entokim kókkolam bénasi taahuak. ");
INSERT INTO mfy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Të jü ángel am yómmiaka ínel ámeu jiaahua, jume jáamuchimmehui: —Katem májhue emëe, bueïtuk ínapone jüneiya, Jesústa enchim jariähui, juka kúrusit poponhuakamta. ");
INSERT INTO mfy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kaa ím aane; kókkolam násuk jíabitek, ä jíakä bénasi. Binen kateka ä bitcha, juka Señorta mäahuakäipo. ");
INSERT INTO mfy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Läutem áman sájaka ä discíipulom téjhua: “Kókkolam násuk jíabitek, entok Áapo enchimpat huéenake Galiléau buiaräu bíchaa. Huämïrem ä bínnake.” Íkäine enchim téjhua. ");
INSERT INTO mfy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Huanärim bempo yeu sájjak, jum ä mäahuakäipo, májhueka entok tüisi al‑leaka. Tennekam bemela nokta Jesústa discíipulom téjhua báarey, entok ínëli íkäi nokta huériaka am kateisu ä discíipulom téjhua báreka, ");
INSERT INTO mfy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesús am nankiseka ámeu yeu siika, ínel jíaka: —¡Yántem jiápsa! Huanäi bempo áu rúkteka guókpo ä íbaktiaka, ä yörek. ");
INSERT INTO mfy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Huanäi Jesús ínel ámeu jiaahua: —¡Katem májhue! Ámanem sájaka jume ínomak huéerim nok bemelata am mákka, bueïtuk Galiléau am kannakë béchïbo. Ámanïrim nee bínnake. ");
INSERT INTO mfy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ímëi jáamuchim ketune boojoaïsu, jume sontarom buére jóärau bíchaa sájaka, am téjhuak, jume sacerdotemmeu kobanaro, jáchin sïmeta yeu sikähui. ");
INSERT INTO mfy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huanärim emo náu tójjak, jume pueblopo yöiyoturim. Ímëri nokta náu tüteka, jume sontarom yún tómita mákkak, ");
INSERT INTO mfy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ínel jíaka: —Inëlem jiaunake emëe: “Ä discíipulom tukaapo itom kóchey äbom yájaka ä ékbuak.” ");
INSERT INTO mfy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Të juka gobernadorta íkäi jíkkajako, ítapote áamak ettejonake, tüisi ä éenakë béchïbo; entok kaita enchimmeu huéenakë béchïbo, ítapote enchim anianake. ");
INSERT INTO mfy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Huanäi bempo juka tómita nüka ä yáuhuak, bem téjhuahuakä pámani. Ïri noki täyahuak judíom násuku, júnakoy naateka én tájti. ");
INSERT INTO mfy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Të jume once discíipulom, Galiléa buiaräu bícham sájjak. Ímï júya káupo Jesús ámanam núnulatukay. ");
INSERT INTO mfy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ä bíchakam ä yorek; të huate katim ä ajäria teiyey. ");
INSERT INTO mfy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ámeu ruktek, huanäi nokaka ínel ámeu jiaahua: —Sïme úttiatane mák‑ri, áman téhuekapo entok ímï buíapo. ");
INSERT INTO mfy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Íäri béchïbo, sïme ániachem kaate, naciónimmehui, jume gentem ín discíipulomtu ïaaka. Huanärem am majtiasuka am batöa, Dios Áchayta téhuampo, entok Diosta Üusi téhuampo, entok Dios Espíritu Santota téhuampo. ");
INSERT INTO mfy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Emem am majtianake, juka enchimmet ín nésahuekähui, bempörim ä boojorianakë béchïbo. Ínapo éntok nee enchimmak aane, chíkti táapo, ániata lütëu tájti. Júnentunake.");
INSERT INTO mfy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jü tü nooki Jesucristo Diosta Üusi bétana nokhuakame ínëli naatek. ");
INSERT INTO mfy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jü profeta Isaíasta jïojterita ínel jiäpo: Ínapone émopat áman ä bíttua, juka ín noki huériamta, huaka böota em huéenake páman ä tütenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ánia see päriapo chayemta jíahui ínel jiaahua: “Señorta böotem tüte; éntokem jume ili böom rútuktia.” ");
INSERT INTO mfy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bueïtuk, Juan, yepsaka ánia buéeka päriapo batöay, entok jíapsi kúakteka emo batöhuamta bétana ámeu nookay, bem Dios bejrimmet bem jiokorinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Huanäi sïme Judea buiärapo bétana entok buere joära Jerusalémpo jóakame áu yeu sájaka batöhuak jum Jordán bathuepo, bem Dios bejrim yeu buíseka. ");
INSERT INTO mfy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jü Juan éntok, camello bóata sánkoka huéiyey, entok huaka beata huikosaka. Jü ä buäyeu éntok mumu sítörim entok jume buere guöchim. ");
INSERT INTO mfy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Huanäi huame géntemmeu nookay, ínel jíaka: —Chúkula senu chë ino béppa útteakame yebisisë. Katchane júne áu rúkteka, kóm chätuka júne, ä bocha huíkyam búttiapo yúmala. ");
INSERT INTO mfy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Lútulay ínapo bäammea enchim batöla; të Áapo Diosta Espíritu Santoy enchim batönake. ");
INSERT INTO mfy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Huámechï taahuarimmet Jesús Nazaret Galiléa bétana áma yepsak. Huanäi Juan ä batöak jum Jordán bathuepo. ");
INSERT INTO mfy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sep éntok jum bäapo yeu huéeka, juka téhuekata au étapomta bitchak, entok juka Espíritu Santota guókouta bénnak at kóm huémta. ");
INSERT INTO mfy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Huanäi jíahui téhueka bétana kóm yuumak, ínel jíaka: —Empë ín Üusi huä tua ín nákëhui; émot ayka jü ín al‑leähui. ");
INSERT INTO mfy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sep éntok Diosta Espíritu Santo ä núk siika huam ánia see päriau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Huämi aanek cuarenta taahuarimpo. Jü Satanás éntok huämi au yepsak ä jioptua báreka. Entok huämi animaalim kara búktume násuk aaney. Diosta ángelesim éntok ä aniay. ");
INSERT INTO mfy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanta pereesotuk, Jesús Galiléau yepsaka juka evangelio Diosta bétana huemta ámeu nookak, ");
INSERT INTO mfy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ínel ámeu jíaka: —Béja taahuari yúmala; Dios reyta nésahueu äbo yúmase. Emóem jíapsi kúaktiaka evangeliota súale. ");
INSERT INTO mfy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Huanäi Galiléa bahue mayoat huéesimeka, Símonta téuhuak entok Andrésta ä sailahua jítë jímmame; bueïtukim kuchuleromtukay. ");
INSERT INTO mfy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Huanäi Jesús ínel ámeu jiaahua: —Ino sáukem kaate. Ínapone enchim kuchulero majtianake, yoremem evangeliou enchim núnunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Huanärim sep bem jítërim tójaka, áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Huanäi huam jëla sika juka Jacobota bitchak, entok Juanta ä sailahua, Zebedeota üusim. Bempo ket bem canoapo aneka jítërim chäbuay. ");
INSERT INTO mfy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Huanäi am núnnuk. Bempo éntok bem átchay Zebedeota canoapo tekipanualerommeu tö sájaka, Jessústa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Huanärim pueblo Capernaumpo yájjak. Huanäi Jesús jum sinagogapo jimyore táapo kibakeka, am majtiay. ");
INSERT INTO mfy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jü gente éntok ä yörihuäpo buere éaka taahuak, jü bem majtiahuäubechi, bueïtuk jábe tua útteakamta bénasi am majtiay, kaa huame judíom ley am mamajtíame bénasi. ");
INSERT INTO mfy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Senu yoreme sinagogapo aaney, chïcha machi espírituta jípureka chay nokaka. Huanäi ínel jiaahua kusisi chayeka: ");
INSERT INTO mfy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús Nazareno, ¿jítasë itomak jüneria? ¿Kíalë kaitäpo itom yáa báreka yebij‑la? Jüneane em jábétukähui. Empo tua jü Diosta yeu púari. ");
INSERT INTO mfy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Huanäi Jesús kutti át nónookak, ínel jíaka: —Katë jíaleka át yeu huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Huanäi jü lemoonio náasä tápsuka entok tüisi chayeka yeu siika. ");
INSERT INTO mfy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Huanärim sïme guómteka, át emo nátemajey: —¿Jítasa ïri? ¿Jítasa ï bemela yore majtiahuame? ¡Tua útteak! Maasu jume lemooniom sáuhue, bempo éntok ä nok jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Huanäi sïme Galiléa buiära chíkola jíkkaijtuk jü Jesústa yáari. ");
INSERT INTO mfy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Huanäi Jesús Jacobo entok Juántamaki, sinagogapom yeu sájaka, Simmom entok Andrésta jóahuim yájjak. ");
INSERT INTO mfy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huämi jóapo éntok jü Símonta asu taijhuécheka bökay. Huanärim ä kökore bétana Jesústa ettejhuariak. ");
INSERT INTO mfy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús éntok áman au rúkteka, mámpä buíseka ä yétchak. Huanäi sep jü taijhuéchiria ä tójjak; huanäi jita am joria táytek. ");
INSERT INTO mfy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Huanäi huäri taahuarit täata áman huétchuko, sïme huame kökoreme áu nau tóijhuak, entok huame lemooniom bem jiápsipo jípureme. ");
INSERT INTO mfy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Júnëli sïme puéblopo jóakame áman nau rúktek jum puertahui. ");
INSERT INTO mfy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús éntok juebenam tütek, kökoata jípureme. Juebena lemooniom yeu béebak, entok kaa am noktuak, bueïtukim béja jüneiyay ä jábétukähui. ");
INSERT INTO mfy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yokoríapo kethuey, ketune unna kútkoako, Jesús yejteka yeu siika ánia see päriau bíchaa. Huämi oraciónta yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Huanäi jü Simmom, entok huame áamak áma aneïhuim, akim ä jariak. ");
INSERT INTO mfy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ä téakam ínel áu jiaahua: —Sïme enchi jaria. ");
INSERT INTO mfy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Áapo éntok ínel ámeu jiaahua: —Jántebu sékäna pueblommeu bíchaa, bueïtukne ámani ket ámeu noknake; huäri béchïbone yebij‑la. ");
INSERT INTO mfy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Huanäi sïme Galiléat naa siika ámeu nokaka bem sinagogapom, entok lemooniom yeu béebaka. ");
INSERT INTO mfy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Senu yoreme Jesústau yepsak sähua leprata jípureka. Huanäi tónommia kíkteka jiokot ínel áu jiaahua: —Júnel éätekë ín kökoa ára nee úhua. ");
INSERT INTO mfy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús éntok ä nák jiokoleka, ä mámam áu rútuktiak. Huanäi át mámteka ínel au jiaahua: —Jeehui, júnelne éiya; türiäe. ");
INSERT INTO mfy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Júnel ä noksuk jíbba, jü sähua lepra kökoa kaitatuk; huanäi türiak. ");
INSERT INTO mfy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Të tüisi ä téjhuasuka ä simtuak, ínel áu jíaka: ");
INSERT INTO mfy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Katë jábetau jíale. Ámanë huéiye jü tiöpopo nésauhuemtahui. Emoë bíttebo, éntoke jita júne áman tójja, Moiséjta nésahuekäpo bénasi, em türiakä bétana, entok bempörim jüneenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Të jü yoreme yeu sika jíba ä nok táytek, huaka áu yáahuakamta. Huanäi sïmekut jüneriatuk hua áu yáahuakame. Jesús béja kara júne machisi áma aaney, jum pueblopo. Mékka ániapo jíba an sísimey. Huáamïrim áu yayajay sïmekut bétana. ");
INSERT INTO mfy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chúkula jaiki taahuarim huéy, Jesús júchi pueblo Capernáumpo yepsak. Huanäi jíkkaijhuak, jóapo anë téaka. ");
INSERT INTO mfy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huanäi juebena gente áu nau yájjak. Jóata pújbapo júnem kaa békiakay. Áapo éntok Diosta noki ámeu nookay. ");
INSERT INTO mfy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Huanäi naikika káraktilata nau huériakam Jesústau yájjak. ");
INSERT INTO mfy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tem genteta juebena béchïbo kara Jesústau kiimuy. Huanärim jü kárit jämuka ä anëbeu béppa ä guójoktiak. Huanärim huämi áman áu kömä teekak, huaka káraktilata, áachä böyëumak chíkti. ");
INSERT INTO mfy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús bem Diosta súalëu bíchaka, ínel au jiaahua jü káraktilatahui: —In üusi, bejë jiokorihuak em Dios bejrimmechi. ");
INSERT INTO mfy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jume maestrom leyta yore majtíame éntok áma jokay, bem jiápsipo ínel éaka: ");
INSERT INTO mfy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Jatchiakasu ïri junëli nooka, Diosta béj‑reka? ¿Jábesu Dios bejrim ára jiokore? Dios jíbba.” ");
INSERT INTO mfy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús éntok ä espíritupo bem jiápsipo éäu jüneriaka ínel ámeu jiaahua: —¿Jatchiakem enchim jiápsipo junëli eiya? ");
INSERT INTO mfy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jáchisu chë kaa obiachi jü káraktilatau jiau béchïbo: “Em kaa tü yáarimmechë jiokorihuak”; o, “Yejtekë em at böyëu tóboktiaka naa huéiye”? ");
INSERT INTO mfy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Të enchim jüneenakë béchïbo, juka Yoremta Üusi ímï buíapo úttiata ä jípurëhui, jume Dios bejrim yore ä jiokorinä béchïbo. Huanäi jü káraktilatau ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Emoune ínel jiaahua: Yejtekë em at böyëu tóboktiaka huéiye em jóau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Huanäi áapo yejteka; entok, juka áachä böyëu nüka, sïmem bíchäpo yeu siika. Huanäi éntok sïme at guómteka Diosta úttilek, ínel jíaka: —Jauhuey júnete ílë bénak kaa bil-la. ");
INSERT INTO mfy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús júchi bahue mayuau bíchaa siika. Juebena gente éntok áu náu yájjak. Huanäi am majtiay. ");
INSERT INTO mfy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ama huam huéeka, Levíi, Alfeota üusi, bankopo kátekamta bitchak, jum yäura tómita nau totoijhuäpo. Huanäi ínel au jiaahua: —Ino sáukë huéiye. Huanäi Levíi kíkteka áa sáu siika. ");
INSERT INTO mfy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ínëli yeu siika: Jesústa Levíita jóapo jïbuäka mesau ä káteko, juebénaka jume impuestom náu totojame entok huate Dios bejrita boojoriame mesahuim Jesústamak jotek, entok ä discíipulommaki. Bueïtukim juebénaka Jesústamak réjtey. ");
INSERT INTO mfy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Huanäi huame maestrom leyta yore majtíame entok jume pariseerom ä bitchak, jume yäura tómita nau toij‑lerommak entok Diosta bejri boojoriammak ä jïbuäyo. Júnëlim ámeu jiaahua, ä discíipulommehui: —¿Jatchiaka jüri ámemak jïbuä, jume Dios bejrita boojoriammaki, entok yäura tómita nau toij‑lerommaki? ");
INSERT INTO mfy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús éntok am jíkkajaka, ínel ámeu jiaahua: —Huame kaa kökoreme kaa mérikota huáatia, ál‑la huame kökoreme. Kanne huame lútula jiápsame núnuseka äbo yebij‑la, ál‑la huame Dios bejrita boojoriame. ");
INSERT INTO mfy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jume Juanta discíipulom éntok jume pariserom ayuunay. Huate gente Jesústau yájaka ínel áu jiaahua: —¿Jatchiaka jume pariserom discíipulom éntok Juanta discíipulom ayuunota johua, jume em discíipulom éntok, ëe? ");
INSERT INTO mfy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Huanäi Jesús ínel ámeu jiaahua: —¿Jachu jume emo jubiahuau núnuri ayuunanake jäni, juka jubemta ámemak aneyo? Ëe; karam ayuuna, juka jubemta ámemak aneyo. ");
INSERT INTO mfy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Të taahuarim yúmanake, juka jubekamta am tö simnakëhui; huanäi ál‑lam ayuunanake. ");
INSERT INTO mfy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Kaabe bemela sánkota sanko muerapo cháchäbua, bueïtuk jü bemela sanko muerapo chäbuahuak, chëhuasu síutinake. ");
INSERT INTO mfy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Entok kaabe vino bemelata huaka bea bóosa örampo tóttöa, bueïtuk jü vino bemela jume bóosa öram síutianake. Huanäi éntok guötinake; jume bóosam éntok nasóntunake. Kíalïku jü vino bemela huaka bea bemelampo tóttöhua. ");
INSERT INTO mfy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Júnaksu jimyore táapo Jesústa et páman huey, jume ä discíipulom áamak kateka jume tirijko bújamim jïusakay. ");
INSERT INTO mfy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Huanäi jume pariserom ínel au jiaahua: —¿Jatchiaka em discíipulom jimyore táapo íkäi johua, kaa jo mátchik? ");
INSERT INTO mfy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Áapo éntok ínel ámeu jiaahua: —¿Jáchem jauhuey júne kaa ä bit‑la, juka jïojteta Davita yáakäu bétana, jiokot éaka, tébäureka, áapo éntok jume áamak aneïhuim? ");
INSERT INTO mfy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatarta sacerdoote tékilpo chë ä nésahueyo, David huam Diosta jóapo kibakek. Huanäi huame páanim Diostau bíchaa näikiarim buäka, huame áamak kateme kétchi. Huámëi páanim jume sacerdoote tékilta joame jíbam ára am buäyey, kaa kia jábe junne. ");
INSERT INTO mfy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús két ínel ámeu jiaahua: —Jü jimyore taahuari yoremta béchïbo yáari; të kaa jü yoreme jimyore taahuata béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Íäri béchïbo ínapo, jü Yoremta Üusi jimyore taahuata béppane yötaka nésahue. ");
INSERT INTO mfy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Júchi éntok Jesús sinagogapo jume judíom nau yayajäpo kibakek. Huämi éntok yoreme aaney, huépülam huakiam mámaka. ");
INSERT INTO mfy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Huate éntok Jesústachim suaka ä bitchay, ä nätua báreka, jimyore táapo huaka kökoremta ä tüte máchileka. ");
INSERT INTO mfy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Huanäi jü yoreme huakiam mámakamtau Jesús ínel áu jiaahua: —Yejtekë ímï násuk kikte. ");
INSERT INTO mfy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huanäi jume géntem temajek, ínel jíaka: —¿Türi jäni jimyore táapo tühuata yáa béchïbo, o kaa tühuata yáa béchïbo? ¿Türi jäni senu jíapsita jínëu béchïbo, o jábeta ä úhuä béchïbo? Të bempo kaa jíaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús éntok omteka entok sirokaka áme bëkatana reemtek, námakak bem jiápsekä béchïbo. Huanäi hua yoremtau ínel jiaahua: —Jume em mámamë rútuktia. Ä rútuktiak éntokim türika taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Huanäi jume pariserom yeu sájaka, noktam nau tütek Herodianommaki, Jesústa mëbáreka. ");
INSERT INTO mfy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Huanäi Jesús bahuéu bíchaa siika, ä discíipulommaki. Gente éntok Galiléa buiära bétana tüisi juebénaka áman au yájjak; álë bénasi Judea buiära bétana, ");
INSERT INTO mfy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén, Idumea buiära, Jordán huáytana bétana, Tiro entok Sidónpo pueblompo chíkola jóakame. Júnëli tüisi juebénaka au nau yájjak, nokta jíkkajaka buéresi jita ä joäu bétana. ");
INSERT INTO mfy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huanäi Jesús jume ä discíipulom téjhuak, juka canoata huéchiapo am jípu sáhueka, áma yejte báreka, juka genteta kaa ä pittianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bueïtuk Áapo juebenam kökoreme tütelatukay. Júkärim jüneriaka, huame kökoata jípureme áa béppa emo tábbey, at mámte báreka. ");
INSERT INTO mfy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jume espíritu chïcha mamachim ä bíchakam tónommey áu japjaptey. Huanärim chayeka ínel jiaahuay: —¡Émpë jü Diosta Üusi! ");
INSERT INTO mfy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Áapo éntok kutti ámeu nookak, kaa au yeu machiria nésahueka. ");
INSERT INTO mfy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Huanäi káhuit jämuka, huame ä huáatiähuim núnnuk; bempo éntok au yájjak. ");
INSERT INTO mfy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Huanäi ímëi dóocem au yájakame tékiata am mákkak, áamak am annakë béchïbo, entok náasam bíttua báreka, huame gentemmeu am béchïbo, ");
INSERT INTO mfy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","entok áapörik bétana yäura útteata am makkak, huaka kökoata am tütenakë béchïbo, entok lemooniom yeu am bébnakë béchïbo: ");
INSERT INTO mfy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ímërim jume yeu púarim: jü Simmom, Peero ti ä téhuaatuakähui, ");
INSERT INTO mfy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","entok jü Jacobo entok Juan ä sailahua, Zebedeota üusim, Boanergem ä téhuaatuakähui, yúku jímmaata jíahui uusim tiau báare, ");
INSERT INTO mfy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","entok Andrés, entok Felipe, entok Bartolomé, Mateo, Toomas, Jacobo Alfeota üusi, Tadeo, Simmom jü cananista, ");
INSERT INTO mfy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","entok Judas Iscariote, hua ä nénkakame. Chúkula, Jesústa ä discíipulommak jóau ä yepsak, ");
INSERT INTO mfy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","jü gente júchi au nau yájjak; junëlim kara júne ay jïbuäy. ");
INSERT INTO mfy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huanäi jume áamak huéerim ä jíkkajaka au yájjak, yeu ä huéria báreka, bueïtukim ä kóba rókotulä tíiyay. ");
INSERT INTO mfy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jume escriibam Jerusalén bétana áma yáij‑lame: —Beelzebútam ä jiápsipo jípurë tíiyay, entokim Beelzebú lemooniommeu yäutta téhuampo jume lemooniom yeu ä bébä tíiyay. ");
INSERT INTO mfy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús éntok am núnuka, ejemplota ámeu yétchak, ínel ámeu jíaka: —¿Jáchisen Satanás juka Satanásta yeu bébnake? ");
INSERT INTO mfy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jíta rey yäura júne au näikimtelataka anëtek, ïri rey yäura kaibu jíba béchïbo yäuratunake. ");
INSERT INTO mfy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Entok jume jóapo emo béj‑reka emo näikimtelatuk, ïri jóuhua kaibu bínhuatunake. ");
INSERT INTO mfy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jü Satanás au béj‑reka au tóboktiak, au näikimtenake, entok kaibu bínhuatunake, bueïtuk jíba luutinake. ");
INSERT INTO mfy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Kaabe júne jábe yorem útteakamta jóau kibakeka ára jita ä úhua, kaa bát ä súmako; të ä súmakätek ál‑la ára jita ä úhua. ");
INSERT INTO mfy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Tua lútüriapone ínel enchimmeu jiaahua, sïme jume yoremem Dios bejri yáarimmechim jiokoritunake, entok hua nooki Diosta béj‑reka nokhuame; ");
INSERT INTO mfy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","të kia jábe junne Espíritu Santota béj‑reka nokame kaibu jiokoritunake, të hua bétte noki at chúpatunake jíbapo béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ínel jiaahua bueïtuk bempom espírituta chïcha machik ä jípurë tíiyay. ");
INSERT INTO mfy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chúkula, jume ä sailahuam entok ä áyehua ámam yájjak. Huanärim päkun tahuaka ä núnutebok, juka Jesústa. ");
INSERT INTO mfy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Huanäi hua gente juebénaka áa chíkola jokame ínel au jiaahua: —Ímïrim päku aane, jü em áiye entok jume em sailam enchi jariaka. ");
INSERT INTO mfy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Áapo éntok, ínel ámeu jiaahua: —¿Jábesu jü ín áiye, entok jume ín sailam? ");
INSERT INTO mfy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jume áa chíkola jokame bíchaka éntok ínel jiaahua: —Ímëi ámëria jü ín áiye, entok jume ín sailam. ");
INSERT INTO mfy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bueïtuk jábe junne Diosta eäu joame, ïri ájäria jü ín saila, entok ín huaayi, entok ín áiye. ");
INSERT INTO mfy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús júchi bemelasi am majtia táytek jum bahue mayoachi. Huanäi juebena gente au nau yájjak. Jesús éntok canoapo yejteka bahuéu kibakek. Huämi aaney canoapo, sïme gente éntok bäa mayoachi. ");
INSERT INTO mfy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Huanäi juebenak am majtiay, ejemplom ámeu jójjoaka, huanäi nokaka ínel am majtiay: ");
INSERT INTO mfy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Íkärem jíkkaja: Jü et‑leero echíseka yeu siika. ");
INSERT INTO mfy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Júnaksu éntok ä echay, jü huate báchia böo mayoat huáttek. Huanäi jume huikichim au yájaka ä buäka. ");
INSERT INTO mfy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jü huate éntok téta buíapo huáttek, huam kaa yún buíata ayukäpo. Huanäi läuti síuhuek, kaa yün ä buíakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Täata yeu sik tájjak, entok kaa mékka kömä nahuaka béchïbo huaakek. ");
INSERT INTO mfy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Huate éntok júya huíchärata sísihuëpo huáttek. Huanäi hua júya báchia síhueka, áapat yötuka ä jíabi mëak, huaka báchia ethuakamta. Huanäi éntok kaa taakak. ");
INSERT INTO mfy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Të jü huate buía türiku huáttekame síuhuek, entok yötuka taakak. Huanäi jü senu báchia treinta báchiam nénkak, senu éntok sesentam, senu éntok cientom. ");
INSERT INTO mfy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Entok ket ínel ámeu jiaahua: —Huä jünee báareme at suaka ä jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Huanäi, huaka juebena genteta sákasuk Jesústa áapola ä tahuak, jume dóoce entok jume huate áma anëhuim Jesústa temajek, hua et‑lerota bétana ä nookakähui, jáchin ä jiau bárëhui. ");
INSERT INTO mfy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Huanäi ínel ámeu jiaahua: —Eme ä täyatuahua, juka éhuil Diosta reytaka nésahuëhui. Të huame päkun aneme éntok, ejemplommeyi sïmeta. ");
INSERT INTO mfy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Entokim bíchaka júne kaa bínnake, kaa at jünee béchïbo, entokim ä jíkkajaka júne kaa at jüneenake, entokim kaa jíapsi kúaktinake, jum bem Dios bejrimmechi kaa bem jiokorinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Huanäi ínel ket ámeu jiaahua: —¿Katem át jüneiya ï ejemplochi, et‑lerota bétana huémtachi, jáchin ä jiau bárëhui? ¿Jáchisu júntukem ámet jüneenake, sïme ejemplom ínëli huémmechi? ");
INSERT INTO mfy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jü echame jüri nokta eecha. ");
INSERT INTO mfy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ïri ínel hua báchia böo mayoat huéchekame: huame tü nokta ámeu nokhuakäu, jíkkaijsuka chúkula Satanás ámeu yepsaka, huakä nokta bem jiápsipo ethuakämta am kóptituanake. ");
INSERT INTO mfy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ket áma huámsu hua téta buíapo eechi: huame nokta jíkkajame, láutim al‑leaka ä mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Të kaa ámet naahuak, kia chúbala jíbam bem jiápsipo ä jípunake. Huanäi huakä jiokot anhuamta ámeu ayu táytek, entok nokta béchïbo guojájja táytek, sepim kaa al‑lee táytinake, entokim ä tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ímëi éntok huame júya huíchärata násuk eechi: huame nokta jíkkajame, ");
INSERT INTO mfy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","të ím ániapo ayukamtat bem jiápsekä béchïbo, entok hua buéresi ríkora yore bäitáttähuamtat bem jiápsekähui, entok kaa huéeläpo bem áttea péäu ámeu ayu táytek, hua noki bem jiápsipo ethuakame kaa útteaka tatahua, entok kaa chúchupe. ");
INSERT INTO mfy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ímëi éntok jume buía türiku ethuakame: huame nokta jíkkajaka tua ä mabetakame, jü báchia ténasi bem jiápsipo chúpanake. Jü báchia chúpuk senu treintata nénkinake, senu éntok sesentata, senu éntok cientota. ");
INSERT INTO mfy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Entok ket ínel ámeu jiaahua: —Jü machiria nühuakätek, ¿jachu kajónta bétuk entok totöhua bétuk mánana jäni? Ëe, ¿jachu kaa jum jita ä machiria máchiku jikat mánatunake? ");
INSERT INTO mfy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bueïtuk kaita hua ésori kaa yeu mamachiame, entok kaita éhuil ayuka kaa jüneriatunakeme. ");
INSERT INTO mfy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Huä jünee báareme at suaka ä jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ket ínel ámeu jiaahua: —Áachem suuhua, hua enchim jíkkajäubechi. Huä enchim jita jábeta ay jünakteriäubey, Dios ket enchim ay jünaktenake. Bueïtukem huatek áa béppa mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bueïtuk hua jita jípureme júchi huatek mabetnake; hua kaita jípureme éntok, júkäi ili ä jípurëu júne úhuaana. ");
INSERT INTO mfy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Huanäi Jesús júchi ínel jiaahua: —Ílë bénna, jü Diosta reytaka nésahuëhui, jáchin jü yoreme báchiata buíapo echame. ");
INSERT INTO mfy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Huanäi áapo tukariu yúmak kótnake, yokoríapo éntok yejtenake. Huä báchia éntok kaa ä jüneäpo síunake éntok yötunake. ");
INSERT INTO mfy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bueïtuk hua báchia buíata úttiäray yötuka chúchupe. Kësam huëpo óguotunake, júchi éntok móanake, chúkula éntok takanake. ");
INSERT INTO mfy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Huanäi huaka báchiata chúpilatuk, huame osam au kibachana, bueïtuk béja yúmala, jü taahuari etta tóboktianähui. ");
INSERT INTO mfy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús ínel ket jiaahua: —¿Ä jítasute bénä tiánake jäni, juka Diosta reytaka nésahuëhui? entok, ¿jita ejemplotate ä bénä tiánake? ");
INSERT INTO mfy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza báchia ténasi maachi. Huäri báchia chë júne ilitchi, huame huate báchiam ím buíapo ayukame béppa. ");
INSERT INTO mfy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Të ethuakätek yötunake, chë bueürusi yötunake, huate júya síarita béppa. Bueerem mesëkirianake. Júnëli huame huikichim ä jékkaa bétuk júne ára kópana, entokim ára at tosate. ");
INSERT INTO mfy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Júnëli Jesús juebena ejemplom joaka ámeu ä nookay, juka nokta, bem ára ä jíkkajäpo núkisi. ");
INSERT INTO mfy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kaa ejemplommeyi kaa am mamajtiay; të jume ä discíipulom bempola aney, sïmeta machisi am téttejhuay. ");
INSERT INTO mfy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Huäri taahuarit, kúpteyo, ä discíipulommeu ínel jiaahua: —Jante, huáytana bíchaate kannake. ");
INSERT INTO mfy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Huanärim huaka gente büruraata sákatuaka, hua canoa ä kátekaïpom ä núk sájjak. Entok huate canoam ket amam jípuhuay. ");
INSERT INTO mfy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Huanäi buere jéka yúkumak au tóboktiaka, jume máarem canoam beb táytek Júnëli béja bäammey tápunak. ");
INSERT INTO mfy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Áapo éntok jum canoapo áma bétana böka kótchimey, kojinim béppa kobaka. Huanärim ä búsaka ínel áu jiaahua: —¡Maestro! ¿Jachë kaachin éiya itom kókkoy junne? ");
INSERT INTO mfy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huanäi yejteka, jekatau kutti nónookak ä kíkte sáhueka: —¡Empo baahue katë jiale yántë taahua! Huanäi kíktek jü jeeka, entok sïme yanti taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Huanäi Jesús jume ä discíipulommeu ínel jiaahua: —¿Jatchiakasem tüisi májhue, éntokem kaita súale? ");
INSERT INTO mfy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Huanärim buéresi májhueka ínel nau jiaahua: —¿Jábesu ïritaka? Jü jeeka ä nok jíkkaja, entok jü bahue junne. ");
INSERT INTO mfy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Huanärim bahuéu huáytana bétana áma yájjak, jum Gadarenom buíarähui. ");
INSERT INTO mfy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jübuachä Jesústa jum canoapo kömä chéptilatuko, jü yoreme ä jiápsipo lemooniom jípureme ä nankirika siika, jum kau guójöku kókkolam totoijhuäpo yeu simlataka; ");
INSERT INTO mfy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","bueïtuk áma jóakay. Të kara jábe yánti ä jípurey, kia cadenammey ä súmaka junne. ");
INSERT INTO mfy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bueïtuk juebénasi sisïguokimmey entok cadenammey súsumahuay, të am chukchuktiay, éntok huame sisïguookim júne kotkóttiay. Ínëli kaabe ä yüey. ");
INSERT INTO mfy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bueïtuk jíba taahuarit entok tukaarit naa búrujti jum kau guójöku kókkolam totoijhuäpo entok jum káhuimmet chay sisimey, tétammet kökosi áu joaka. ");
INSERT INTO mfy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Të Jesústa mékka bíchaka, áu tájti búiteka áu tónommia kíktek. ");
INSERT INTO mfy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Huanäi tüisi chayeka ínel jiaahua: —¿Jítasë ínomak jüneria, empo Jesús, Dios jíkat téhuekapo kátekamta Üusi? Diosta béchïbo, katë nee jiokot johua. ");
INSERT INTO mfy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tí jiaahuak bueïtuk Jesús ínel áu jiaahuay: —Empo lemoonio, jü yoremtachë yeu huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Huanäi Jesús ä temajek: —¿Jáchisë téhuaak? Áapo éntok ínel ä yommiak: —Legión tine téhuak, bueïtukte juebenna. ");
INSERT INTO mfy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huanäi jü yoreme tüisi jiokot áu jiaahua kaa huämi buiärapo yeu am bep ïaaka. ");
INSERT INTO mfy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Huämi kau mayoachi juebena kohuim áma rejteka jïbuäy. ");
INSERT INTO mfy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Huanäi jume lemooniom áu jiokot jiaahua, ínel jíaka: —Huame kohuimmehuë itom jaase; éläpote ámet kimunake. ");
INSERT INTO mfy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús éntok am jehuiteriak. Huanärim yoremtat yeu sájaka, kohuimmechim kiímuk. Jume kohuim éntok, jíbatua guoy míltukay. Huámëi siba bahuéu kóm huáttek; huanärim áma kókkok. ");
INSERT INTO mfy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jume kohuim suayähuim éntok tenneka, jume pueblopo jóakammeu jüneehuamta ámeu tójjak, entok jume huasammet jóakammehui. Huámëi éntok áma yeu sikamta bit báreka áman yeu sájjak. ");
INSERT INTO mfy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesústahuim yájaka juka yoremta bitchak lemooniota jiápsipo jípureka kökoreka, Legiónim jípurëuta, sánkotelataka áma kátekamta, entok yúmalasi suaka; huanärim guómtek. ");
INSERT INTO mfy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Huanäi huame ä bíchakame am ettéjhuariak jáchin hua lemooniota jípurëitau yeu sikamta, entok huame kohuimmehui. ");
INSERT INTO mfy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jume áma joome éntok Jesústau jiokot jiaahuay huämi bem buíärapo yeu ä huée sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Huanäi Jesústa béja sim báreka jum canoapo ä jämuyo, jü lemooniom jiápsipo jípureïhui áu jiokot jiaahuay áamak an rókaka. ");
INSERT INTO mfy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Të Jesús kaa báarek, ál‑la ínel áu jiaahuak: —Em jóahuë huéiye, em huahuajimmehui. Akë am ettéjhuaria juka Señorta buéresi emou yáakähui, entok jáchin enchi ä nák jiokolekähui. ");
INSERT INTO mfy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Huanäi sika juka nokta chíbejtia táytek. Decapolis buíärata yúmau tájti, jáchin Jesústa buéresi jita áu yáakähui. Huanäi sïme át guómtilamtaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús júchi canoapo huéeka bahue huáytana yeu ä yepsak. Gente éntok juebénaka áu nau yájjak, huämi bahue mayoat ä anëpo. ");
INSERT INTO mfy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Senu éntok sinagogapo chë nésahueme, Jáirö ti téhuakä, áma yepsak. Jesústa bíchaka ä guókpo tónommia kíktek. ");
INSERT INTO mfy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Huanäi tüisi jiokot ínel áu jiaahuak: —In maala béja mukiapo aane; ámanë sika át mámte, ä türinakë béchïbo, huanäi jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Huanäi Jesús áamak siika; gente éntok juebénaka áamak sájjak. Júnëli ä huë páman nau ä pittiasakay. ");
INSERT INTO mfy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Senu jámmut éntok béja dooce huásuktiapo ä kökoa kaa chúkteka át huéiyey, kaa tutüriaka áma aaney. ");
INSERT INTO mfy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tüisi jiokot au siika, juebena jittoleerom mámpo; sïmeta juka ä átteahua luutialatukay. Të jíba kaita hua jittoa áu türiakay, ál‑la chëhuasu kökorey. ");
INSERT INTO mfy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Të Jesústa bétana nokta jíkkajaka, amá bétana áamak kateme násuk áu rúkteka ä sánkobet jálojtek, ");
INSERT INTO mfy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","bueïtuk ínel éiyay: “Kiane ä sánkobet jálojtek júne türinake.” ");
INSERT INTO mfy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Huanäi áachä jálojtek jíba jü ójbo kíktek. Entok ä türiakäu ínnëak, jü jíbebeata bétana. ");
INSERT INTO mfy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Huanäi Jesús ä takaahuapo úttiärata át yeu sikamta ïinnëaka, huame áamak katemmeu kúakteka ínel jiaahua: —¿Jábesu ín sánkommet jálojtek? ");
INSERT INTO mfy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Huanäi ä discíipulom ínel áu jiaahua: —Juka juebenaraata enchi pítpittiamtë bitcha, éntoke nátemaje, “¿Jábeta émot jálojtekähui?” ");
INSERT INTO mfy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Të Jesús nate chíkola náasam bitchak huaka at jálojtekamta bit báreka. ");
INSERT INTO mfy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Huanäi jü jámmut máujrimmey, áu yoaka, entok jünéaka jita áu yáahuakähui. Huanäi áu tónommia kíktek, entok sïmeta juka ä kökoa bétana ä téjhuak, jáchin áu ä sikähui. ");
INSERT INTO mfy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Huanäi Jesús ínel au jiaahua: —In maala, jü em nee súalë béchïbë türiak. Én éntoke yanti jiápseka huéiye, em kökoa bétanë türikä tahuala. ");
INSERT INTO mfy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Júnëlä nokaisu, huate huam bem nau yayájäpo nésauhuemta joa bétana áma yájjak ínel au jiaka: —Em mala béja muúkuk. ¿Jatchíakasë ketune juka Maestrota muksi éetua? ");
INSERT INTO mfy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús éntok íkäi jíkkajakä ínel au jiaahua hua nésauhuemtahui: —Katë jachin eiya; kial jíbe nee súale. ");
INSERT INTO mfy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Huanäi kaabeta éntok áamak kat ïai Perota, éntok Jacobota, éntok Juanta Jacobota saíla jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesús éntok hua nésauhuemta joau yepsaka, huaka naa muksi huemta bitchak, éntok buanhuamta jíkkajak, éntok jiokot jiáihuamta. ");
INSERT INTO mfy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Huanäi áman kibákeka ínel ámeu jiaahua: —¿Jatchíakasu naa muksi huéiye, éntokem buaana? Jü usi jámmut kia kotche, kaa mukila. ");
INSERT INTO mfy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Huanärim ä junnériataitek. Të Áapo sïmem yeu béebaka, hua ili jámutta jápchimak, éntok ä áyemak, éntok huame áamak katëummak áman kibákek huam múkilata bökaïhui. ");
INSERT INTO mfy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Huanäi juka ili jámutta mampo buíseka ínel au jiaahua: —Talita kumi —itom nokpo ínel jiaubáare: Ili jámmut, émoune ínel jiaahua, yejtë. ");
INSERT INTO mfy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jü ili jámmut éntok sep yejteka naa hueetáitek, bueïtuk béja dóoce huásuktiriam huériai. Huanärim tüsi at guómtek. ");
INSERT INTO mfy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús éntok tüisi am téjhuak kaabeta ä ettéjhuaria nésauhueka, éntok ä jïbuätua nésauhuek. ");
INSERT INTO mfy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús huämi yeu sika ä buíarau yépsak, jume ä discíipulommaki. ");
INSERT INTO mfy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jimyore taahuata yúmak éntok jum sinagogapo am majtíataitek. Huanäi juebenakä ä jíkkajakä at guómtek ínel jíaka: —¿Jákübo bétanasu ïri íkäi täya jäni? ¿Jita suáhuasa jäni ïri ä jípurëhui, éntok hua milagrom ä joähui, jítasasu nok báare jäni? ");
INSERT INTO mfy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Jachu kaa ïri ínel jü carpínteero, Maríata asóa, Jacobota, éntok Joseta, Judasta, éntok Símonta saayi? ¿Jáchum kaa ket im itomak aane jume ä huáyihuam? Huanärim áa bétana jájana jiautáitek. ");
INSERT INTO mfy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús éntok ínel ámeu jiaahua: —Kíal jábe profeta júne yörihua, të huam ä buíaräpo, éntok ä jóapo ä huahuajim násuk ëe. ");
INSERT INTO mfy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Huanäi jume milagrom júne kara áma yáuhuai, Kia huame kökoremmet kaa jáikimmet jíba mámteka am tütek. ");
INSERT INTO mfy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Huanäi kaa at al‑léakä taahuak hua kaíta bem súalëubechi. Huanäi Jesús jume huate puéblommet naa siikä am majtíaka. ");
INSERT INTO mfy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jume dóoce yeu púarim nau núnuka, guoguóyim naa bíttuak, útteata am mákakä diáblom yoremem jiápsipo yeu bébnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Éntok kaíta am huéria sauhue böot béchïbo, morralta, éntok páanim junne, tómita junne; boróoniata jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Éntok am béräbochate sauhue, éntok kaa guoyik sánkotam huéria sauhue. ");
INSERT INTO mfy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ket ínel ámeu jiaahua: —Kia jak jóapo enchim mabethuakäpem aane, jum puéblopo enchim yeu kátëpo tajti. ");
INSERT INTO mfy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sïmekut huam kaa enchim mabethuakäpo, éntok huam kaa enchim nok jikkaibahuäpo, yeu katëtekem huaka tóröchiata enchim guókimmet chätulata ámeu tátaknake, bem jüneenakë béchïbo kaa tüisi bem ayúkähui. Tua lútüriapone enchimeu ínel jiaahua, huame Sodóma teäpo éntok Gomórrapo joomem chë jiokoritunake hua taahuari bette nokta chúpeyo, huame puéblopo kaa enchim mabethuakäpo joomem béppa. ");
INSERT INTO mfy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Huanäi jume dóoce yeu púari yeu sájakä géntemmeu ä noktáitek, huaka yoremem emo temajeka am jíapsi kúaktinakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Éntokim juebena diáblom yoremem jiápsipo anëu yeu bebbai, éntok juebena kökoremem tütek aceiteta ámet óreka. ");
INSERT INTO mfy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jü rey Herodes éntok Jesústa bétana buériata jíkkajak, bueïtuk ä téhuam sïmekut yeu machíak. Huanäi Herodes ínel jiaahua: —Juan jü batöaïhui jíabitela, jume kókkolam násuku. Kíalïku úttiärata jípure milagrom ä jonákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Huate ä Elías tíyay. Huate éntok huame huate profeetam násuk ä profeeta tíyay. ");
INSERT INTO mfy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Íkäi jíkkajakä jü Herodes, ínel jiaahua: —Ïri jü Juan ín kóba chúktiatebokähui. Áapo kókkolam násuk jíabitela. ");
INSERT INTO mfy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bueïtuk áapo juka Juanta buíjtebokä ä carcelpo ä páttiatebokay, Herodíasta béchïbo, Felípeta juubi ä sailahua; bueïtuk áapo, jü Herodes, Herodíasta jípurey. ");
INSERT INTO mfy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bueïtuk Juan Herodestau ínel jiakay: —Kaa türi juka em saila jubi em jípurëhui. ");
INSERT INTO mfy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías, éntok át kopteka ä mëpéiyay, të kaa áma yuumay, ");
INSERT INTO mfy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bueïtuk Herodes Juanta bétana májhuey, bueïtuk jüneiyay Juanta lútula entok Diostau bíchaa näikiataka ä jiápsaïhui, entok ä suayay. Ä jíkkajaka kaachin an máchika tatahuay, të tü éaka ä jíjikkajay. ");
INSERT INTO mfy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Taahuari yuumak, Herodesta huásuktiriam yúmariaka pajkoy. Kúptey am äbosek, huame áamak nésahueme, sontaro yäuram, entok Galiléapo chë nésahueme. ");
INSERT INTO mfy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Huanäi Herodíasta jámut ásoa yïsimeka áman kibakek. Herodes éntok tüsä musäuleka taahuak, entok huame mesau áamak jokaïhuim. Huanäi jü rey hua ili jámuttau ínel jiaahua: —Em huáatiähuë inou aahua; ínapone enchä máknake. ");
INSERT INTO mfy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Entok ä nokäu bát kéchaka ä lútüriatebok, ínel jíaka: —Sïmeta em inou aahuäune enchi máknake, reytaka ín nésahuëpo násuk áman junne. ");
INSERT INTO mfy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Huanäi hua ili jámmut yeu sika ä áyebeu nátemajek: —¿Jítasune áunake jäni? Ä áyehua éntok ínel au jiaahua: —Juka Juan Bautistata kóbba. ");
INSERT INTO mfy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Áapo éntok sep áman kibakeka, jü reytau ínel jiaahua: —Én läutine puraato bueürupo ä huáatia, juka Juan Bautistata kóbba. ");
INSERT INTO mfy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Huanäi jü rey tüisi kaa al‑lëeak. Të juka ä nookakäu ä lútüriatebokä béchïbo, entok huame áamak mesau jokame tihueka, kara ëe ti au jíaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Huanäi sep sontarota Juanta kóba chúktiaka áu ä huéria sáuhuek. ");
INSERT INTO mfy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jü sontaro éntok áman sika jum ä páttiatukäpo ä kóba chúktiak. Huanäi juka kóbata jum puraatopo yéchaka, jü ili jámuttau ä tójjak; jü ili jámut éntok ä áyebehui. ");
INSERT INTO mfy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Huanäi jume Juanta discíipulom ä jíkkajaka, áman sájaka ä takaahua nükä ä núk sájjak. Huanärim kókkolam mamähuäpo ä maäak. ");
INSERT INTO mfy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jume apóstolim éntok júchi Jesústau nau yájjak. Huanärim ä ettejhuariak, sïmeta bem yáakähui entok bem am majtiakähui. ");
INSERT INTO mfy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Áapo éntok ínel ámeu jiaahua: —Emepolem ímin ínomak kaate ánia see päriahui; ámanïrem chúbala jimyorenake. Bueïtuk juebénakam sákkay, entok juebénakam yájjay; junëlim kara júne ámey jïbuäy. ");
INSERT INTO mfy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Huanärim jum canoapo sájjak ánia see päriahui, kaabeta anëhui. ");
INSERT INTO mfy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Huä gente éntok am bitchak yeu am sájako, entokim am tátäyak. Huanäi juebénaka huate pueblom bétana guókimmea áman yájjak, ámepachi. Huanärim áu nau yájjak. ");
INSERT INTO mfy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús éntok canoapo kom chépteka huaka juebenarata bíchaka tüisam jiokoley, bueïtukim kabaram kaa kabyerokä bénasi áma aaney. Huämi juebenak am majtia táytek. ");
INSERT INTO mfy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Béja tüisi kúptey éntok, jume ä discíipulom áu rúkteka ínel áu jiaahua: —Ímï ánia see päria, entok béja kúpte. ");
INSERT INTO mfy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Akë am sáka sáuhue; éläpom pueblommet entok ranchommet sájaka páanim emo jínnurianake, bueïtukim ímï kaita buä mátchi. ");
INSERT INTO mfy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Huanäi Jesús ínel ámeu jiaahua: —Akem am jïbuätua emëe. Bempo éntok ínel au jiaahua: —¿Jachute áman sájaka guoy cien denariom béjhuay páanim jínnuka am jïbuätuanake jäni? ");
INSERT INTO mfy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Huanäi Jesús ínel ámeu jiaahua: —¿Jaiki páanimsem jípure? Ámanem sájaka am bitcha. Bempo éntok am bíchaka ä téjhuak: —Mamni páanim entok guoy kútchum. ");
INSERT INTO mfy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Huanäi sïmem básso síaripo am jote sáuhuek, nátepola, ");
INSERT INTO mfy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","cicientom náuhui entok cincucuentam náuhui. ");
INSERT INTO mfy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Huanäi jume mamni páanim entok jume guoy kútchum nüka, téhuekau reemteka, Diosta tü éäu ámet chúpaka jume páanim rébektiak. Huanäi jume ä discíipulom am mákkak, am mik sáhueka. Jume guoy kúchum éntok sïmemmet näikimtebok. ");
INSERT INTO mfy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Huanäi sïme jïbuäka jóboak. ");
INSERT INTO mfy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jume pan rérebeim entok jume kúchum buä bëterim dooce canajtam tátapunika áma tóboktiahuak. ");
INSERT INTO mfy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Huame áma jïbuäkame éntok mamni mil oohuimtukay. ");
INSERT INTO mfy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chúkula Jesús jume ä discíipulom canoau am jämutuak, áapat huáytana pueblo Betsaidau am yaij ïaaka, áapörik huaka juebenarata am sákatuäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chúkula genteta sákatuaka, jum káhuiu bíchaa siika, Diostau oraciompo nok báreka. ");
INSERT INTO mfy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Huanäi tukariu yúmay jü canoa bäa násukun aaney. Jesús éntok buíapo áapola aaney. ");
INSERT INTO mfy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Béja bájim jiäpo matchü bíchaa, canoata buaatiaka lotteme bitchak, bueïtuk jü jeka am nankirika búitey. Huanäi ámeu siika, bäata béppa huéeka, áme huam sika ámepat yebij báreka. ");
INSERT INTO mfy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bempo éntok bäata béppa huémta bíchaka, akim ä jóusï téyey. Huanärim cháchayek, ");
INSERT INTO mfy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","entokim sïmetaka ä bíchaka sum éiyay. Të áapo sep ámeu nónookak, ínel jíaka: —¡Óusem eiya, katem májhue, ínapone ájäria! ");
INSERT INTO mfy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huanäi canoapo ámeu ä jämuk, jü jeka yánti taahuak; bempo éntok naa muksi éakam át guómtilatukay. ");
INSERT INTO mfy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bueïtukim ketune kaa jüneiyay, jáchin jume páanim bürusi yáahuakähui, bem námakak jiápsekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Huáytana bíchaa sákasukam Genesaret buiärau yájaka, mayoahuim yeu yájjak. ");
INSERT INTO mfy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huanäi bempörim canoapo yeu sájak, jü gente Jesústa tátäyak. ");
INSERT INTO mfy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huanärim huämi buiärapo sïmekut naa tenneka, jume kökoreme au nau toij táytek, bem ámet töyemmak chíkti, huam jak Jesústa aneï tíäpo. ");
INSERT INTO mfy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bueïtuk jak júne ä kibakeïpo, jum pueblompo entok ranchompo, jume kökoreme böo mayoat yeu totoijhuay jiokot jíaka, kia ä sánko mayoammet jálojti péaka. Huanäi sïme huame át jálojtekame türiak. ");
INSERT INTO mfy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Huanäi jume pariseerom Jesústau yájjak, entok huate escriibam, Jerusalén bétana áma yáij‑latukaïhui. ");
INSERT INTO mfy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Huanärim huate ä discíipulommet suuhuay, bueïtuk kaa leyta jíä páman báijmaka páanim bem buäye béchïbo mamam chichä machimmea. Huanärim béttesi áme bétana noktaitek. ");
INSERT INTO mfy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bueïtuk jume pariseerom entok sïme jume judíom, huame yoiyöturim boojoria páman, juebénasi kaa mam báijmakatekim kaa jíjïbuäy. ");
INSERT INTO mfy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Entokim plaza bétana yájak, kaa emo mam báksiako, katim jíjïbuäy. Entok huate juebénaka jita aykay bem yöreïhui: jume vasom ámey jïhuame, jume saarom, jume sisïguok vaasom, entok jume bem ámet töyëhui.) ");
INSERT INTO mfy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Huanäi jume pariseerom entok jume escribam Jesústa temajek, ínel jíaka: —¿Jatchiakasu jume em discíipulom kaa huame yoiyöturim boojoria páman kaate? Bueïtukim kaa ito bénasi báijmaka páanim buäye. ");
INSERT INTO mfy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Huanäi Jesús ínel ámeu jiaahua: —¡Eme Dios huáatemta bénasi emo antuame! Ál‑läku Dios profeeta Isaíasta tempo enchim bétana nookak, entok áapo ínel ä jïojtek: Ímëi gentem bem teniy jíba nee yöre, të bem jíapsihua mékka inou aane. ");
INSERT INTO mfy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kaita béj‑re jü bem nee emo yörë tíähui, bueïtukim yorem nésauta Diosta nésautukä bénasi emo ä majtia. ");
INSERT INTO mfy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Diosta nésahui tójakem, jume yoiyöturim boojoriauem johua: jume sarom báksiahuamta, entok vasom ámey jijïhuame; entok juebenak ílë bénakem johua. ");
INSERT INTO mfy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Entok ket ínel ámeu jiaahua: —¿Jachem tüisi emo anë téiyey? ¡Bueïtukem juka Diosta nésahui kaitäpo johua, juka yoiyöturim boojoriau enchim yöri bárë béchïbo! ");
INSERT INTO mfy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bueïtuk Moisés ínel jiaahua: “Em áchayë yöre, entok em áiye. Jü ä áchaybet entok ä áyebet bettek nokätek, kaita át temaijhuaka mëna.” ");
INSERT INTO mfy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eme éntok ínel jiaahua: “Tüisi jiaunake jü yoreme ä áchaybeu o ä áyebeu ínel jíäteko: Sïmeta huaka ín áttea ay enchi ín ania éähui, Diosta béchïbo näikiari.” (Corbánta jiau bárë bénasi.) ");
INSERT INTO mfy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Júnëlem huaka yoremta ä atchai éntok ä áiye kaitäpem ä aniatua; ");
INSERT INTO mfy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","éntokem huaka Diosta nookakäu kaa béj jóuhua, huame yoiyöturim boojoriau huatem majtiaka, éntokem juebenak ílë bénak johua. ");
INSERT INTO mfy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Huanäi sïme juebena genteta núnuka ínel ámeu jiaahua: —Nechem jíkkaja sïmetaka, át jünee béchïbo: ");
INSERT INTO mfy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaita ayka yeutana jü yoremtat kimuka ä jíapsi násontenakeme, ál‑la hua ä jiápsipo yeu huéeme. ");
INSERT INTO mfy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Huä jünee báareme át suaka ä jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huanäi juebena genteta tö sika senu jóapo kibakek. Huanäi jume ä discíipulom ä temajek, juka ejemplota ámeu ä yéchakä bétana. ");
INSERT INTO mfy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Huanäi ínel ámeu jiaahua: —¿Jachem eme két kaitat jüneiya? ¿Jáchem kaa jüneiya, huaka yeutana yoremtat kimumta kaabeta jíapsi násontenakëhui? ");
INSERT INTO mfy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bueïtuk jü buähuame kaa jiápsipo kiimu, ál‑la sihuampo, entok chúkula yeu huéenake. Íkäi nokaka sïme buähuamta türï tíiyay. ");
INSERT INTO mfy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ket ínel jiaahua: —Huä yoremta jiápsipo yeu huéeme, huäri ä jíapsi nasonte. ");
INSERT INTO mfy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bueïtuk jum yoremta jiápsipom yeu kaate, jume juëna éerim, omot jubiahuame, éhuil jáamuchim jípuhuame, yore súahuame, ");
INSERT INTO mfy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ékbuahuame, kaa huéeläpo jita jípu péehuame, entok juënasi anhuame, jü yore bäitäihuame, jü kaa tíura, senukut jita ínnëhuame, juënasi yoret nokhuame, hua emo buérialihuame, entok jume kaa suasi emo nühuame. ");
INSERT INTO mfy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sïme ímëi kaa tü yáarim yoremta jiápsipom yeu huéiye, entokim ä nasonte. ");
INSERT INTO mfy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Huanäi Jesús huämi yeu sika Tiró éntok Sidón buiärau bíchaa siika. Huanäi huämi jak jóapo kibakek kaabeta ä bít ïaaka. Të kara au éssoy. ");
INSERT INTO mfy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bueïtuk senu jámmut áma aaney, ili jámut espíritu chïcha machik jiápsipo jípuremta asoaka. Huäri jámmut áatana nokta jíkkajaka, áu sika ä guókpo áu tónommia kíktek. ");
INSERT INTO mfy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Áapo griegotukay, entok Sirofeniciapo jometukay. Huanäi jiokot áu jiaahuay, juka espíritu chïcha machik ä jámut asoabet yeu ä bep sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Të Jesús ínel au jiaahua: —Éläpo bat jume usiarim jóbonake, bueïtuk kaa türi jume usiarim páanim úuhuaaka ili chüummeu am guötia béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Áapo éntok ínel áu jiaahua: —Ammäle jiaahua, Señor, të jume ili chüum jume pan rérebeim mesata bétuk usiarim kóm huáttilame buabuäye. ");
INSERT INTO mfy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Huanäi Jesús ínel áu jiaahua: —Ínëli em jíakä béchïbo noitë huéiye. Jü lemoonio béja yeu simla, jü em jámut asoabechi. ");
INSERT INTO mfy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Huanäi ä jóau yepsaka, juka ä asoahua ä böyëpo bökamta téuhuak, béja juka lemoonio át yeu simlata. ");
INSERT INTO mfy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús júchi nóttek jum Tiro buiära bétana. Huanäi jum Sidonpo naa búrujti siika, Galiléa bahuéu bíchaa, jum Decápolis buiärapo ámani. ");
INSERT INTO mfy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Huanäi jü gente nákapi nëota áu nüpaka jiokot au jiaahuay, áa béppa ä mámte sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Huanäi áapolaik yeu núk sika, Jesús nákapo ä sútuteriak, entok ä sútu chíttuaka nínit ä kómoniak. ");
INSERT INTO mfy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Huanäi téhuekau reemteka bueürum jíabitek, entok ínel áu jiaahua: —¡Efata! —ínel jiau báare: ¡Étapotunakee! ");
INSERT INTO mfy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Huanäi sep jume náka guójöriam emo étapok, entok ä nín jísumaria búttek. Huanäi jünakiachisi nookak. ");
INSERT INTO mfy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Huanäi Jesús juka genteta téjhuak, kaabeta am ettejoria nésahueka, juka bem bíchakähui. Të chë tüisi junëli ä nésahuey junne, chëhuasum ä ettejhuay. ");
INSERT INTO mfy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Entokim tüisi át buere eeyak, ínel jíaka: —¡Sïmeta tüisi johua! ¡Jume nákapim jíkkaijtua, entok múurom júne noktua! ");
INSERT INTO mfy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Huámëchi taahuarimmet tüisi juebena genteta áma aneyo, entok kaita am buä máchiako, Jesús jume ä discíipulom núnuka ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Juka genteta juebenak ínomak anemtane jiokolë, bueïtukim béja baij taahuare ínomak aneka, entokim kaita buä mátchi. ");
INSERT INTO mfy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bueïtuk kaa jïbuälame bem jóau sákatuak, böochim tébäi huáttinake, bueïtuk huate mékka bétana äbo yáij‑la. ");
INSERT INTO mfy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Huanäi jume ä discíipulom ínel ä yommiak: —¿Të jákübosu jábe páanim ámeu nüpaka am jóborianake jäni? Bueïtuk ímï ánia päriapo kaita aayuk. ");
INSERT INTO mfy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Áapo éntok am temajek: —¿Jaiki páanimsem jípure? Bempo éntok inel jiaahuak: —Guoy búsanim. ");
INSERT INTO mfy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Huanäi huaka genteta buíapo jote sáuhuek. Entok jume guoy búsan páanim nüka, Diosta baysausuka am rébektiak. Huanäi jume ä discíipulom am mákkak, genteta am mik sáhueka. Bempo éntok am nüka, juebenara gentetau am tójjak. ");
INSERT INTO mfy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ili kúchumim ilikkim ket áma jípurey. Huanäi Diosta tü éäu ámet chúpaka, ámeu am tóij nésahuek. ");
INSERT INTO mfy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Huanärim jïbuäka jóboak. Entok jume rérebeim yeu bëkame guoy búsan canastam tátapunika tóboktiahuak. ");
INSERT INTO mfy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jume jïbuäkame éntok naiki miltu máchiakay. Huanäi am sákatuak. ");
INSERT INTO mfy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Áapo éntok jume ä discíipulommak canoapo yejteka siika. Huanäi Dalmanuta buiärau yepsak. ");
INSERT INTO mfy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Huanäi jume pariserom áu yájaka, áamak nok nássua táytek. Entokim séñalta áu aahuak, téhueka bétana huemta, ä jioptua báreka. ");
INSERT INTO mfy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Huanäi ä jiápsipo bueürum jíabiteka ínel jiaahua: —¿Jatchiaka ï gente én huéeme séñalta kaibu jojohuamta aahua? Tua lútüriapone enchimmeu ínel jiaahua, ï gente kaita séñalta mákna. ");
INSERT INTO mfy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huanäi júchi jum canoau jämuka, huáytana bíchaa am tö siika. ");
INSERT INTO mfy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jume ä discíipulom páanim kóptiaka, barcopom huépul páanim jíba huériay. ");
INSERT INTO mfy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Huanäi am téjhuak, ínel jíaka: —Jítachem suuhua, éntokem emo suaya jü pariserom levaduura bétana, entok Heródesta levaduura bétana. ");
INSERT INTO mfy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Huanäi jume discípulom nahuim nookay, ínel jíaka: —Páanim kaa itom nüpakä béchïbo ínel jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús am jüneriaka jita am nokähui, ínel ámeu jiaahua: —¿Jatchiakem páanim kaa enchim nüpakä béchïbo ínel nee jíä tíiya? ¿Jachem kaa át suuhua, éntokem kaa át jüneiya? ¿Ketunem námakak jiápsek? ");
INSERT INTO mfy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Pusekem kaa bitcha, entok náka guójöriakem kaa jíkkaja? ¿Jachem kaa áu huáate, ");
INSERT INTO mfy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","huame mamni páanim ín näikimtekäubehui, huame mamni mílimmechi? ¿Jaiki canastamsu rérebeimmea tátapunika tóboktiahuak? —Dóocem kanastam —tim áu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Entok júnak huame guoy búsan páanim naiki mílimmet näikimtehuakame, ¿jaiki canastamsu rérebeimmea tátapunika tóboktiahuak? —Guoy búsanika —tim áu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Huanäi ínel ámeu jiaahua: —¿Jáchem ketune kaa át jüneiya? ");
INSERT INTO mfy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sep pueblo Betsaidau yepsak. Huanärim Jesústau líptita nüpak, jiokot au jíaka áa béppa ä mámte sáhueka. ");
INSERT INTO mfy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Áapo éntok juka líptita mámpo buíseka, huämi pueblopo yeu ä núk siika päkun bíchaa. Ámani béja ä pusimpo chít huáttek, entok áa béppa mámteka ä temajek: —¿Jachë ára jita bitcha? ");
INSERT INTO mfy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Áapo éntok pujteka ínel jiaahua: —Yorememne júyam bénasi bitcha, të naa kateme. ");
INSERT INTO mfy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Júchi ä pusim béppa mámtek. Huanäi bitchak, jü yoreme, sïmeta machisi. ");
INSERT INTO mfy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Huanäi ä jóau bíchaa ä sim sáuhuek, ínel áu jíaka: —Katë pueblou kíkkibake, éntoke kaa jábetau ä ettejhua, huämïri. ");
INSERT INTO mfy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Huanäi Jesús jume ä discíipulommak pueblommet siika, Cesarea Filiipo buíärahui. Huanäi ä discíipulom böot am temajek: —¿Nechim jábë tíiya, jume yoremem? —ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bempo éntok ínel jiaahua: —Enchim Juan Bautistä tíiya; huate éntok enchi Elías tíiya; jume huate éntok enchi hua jábe profeeta tíiya. ");
INSERT INTO mfy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Huanäi Jesús am temajek: —¿Emesu? ¿Nee jábë tíiya? Peero éntok ínel jiaahua: —Émpë jü Cristo. ");
INSERT INTO mfy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Të Jesús am téjhuak, íkäi áa bétana kaabeta am ettejhuaria nésahueka. ");
INSERT INTO mfy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Huanäi am majtia táytek, juka Yoremta Üusi tüisi jiokot ä yáanähui, entok jume yoiyöturim, jume tiöpopo chë nésahueme, entok jume escriibam ä omoutenakëhui, entok mëhuaka báij taahuarim huéy ä jíabitenakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Íäri bétana machisi nookay. Huanäi Peero áapolaik yeu núnuka kuttílasi áu nookak, kaa ä türï tíaka juka ä nokähui. ");
INSERT INTO mfy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Të Áapo kúakteka ä discíipulom bíchaka, Perotau kutti áu nonokak, ínel jíaka: —¡Mékkë huéiye, Satanás! Bueïtukë kaa Diosta bétana huémtat suuhua, ál‑la yoremem bétana huémtat jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huanäi juka genteta núnuka, entok ä discíipulom, ínel ámeu jiaahua: —Jü jábe júne inot chäka huée báareme kaa áu beutireka kúrujta púaktíaka ino sáu huéenake. ");
INSERT INTO mfy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bueïtuk hua ímï buíapo ä jíapsi jínëu báareme ä tärunake; hua ino béchïbo entok evangeliota béchïbo ímï buíapo ä jíapsi tärukame, huäri ä jínëunake. ");
INSERT INTO mfy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bueïtuk, ¿jita tühuatasu bínnake jäni jü yoreme, sïme ániapo ayukamta kobakätek junne, ä jíapsi éntok tärukäteko? ");
INSERT INTO mfy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Entok, ¿jítasasu béjtuanake jäni jü yoreme, ä jíapsi béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bueïtuk hua inoy tihuekame entok jü ín nokibeyi, ïri gente én huéeme kaa türik joame omot jubiahuamta türeme; entok Diosta bej-reka jiápsame násuku. Ínapo jü Yoremta Üusi ket ái tiunake, júnaköri ín Átchay loriapo yepsäteko jumé santo ángelesimmaki. ");
INSERT INTO mfy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús ket ínel ámeu jiaahua: —Tua lútüriapone enchimmeu ínel jiaahua, huate ímï aneme katim kókkonake, huaka Diosta yäura chíkti ä úttiärammak äbo yepsäu tájti. ");
INSERT INTO mfy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chúkula búsan taahuarim huéy, Jesús juka Perota, Jacobota, entok Juanta nüka, bempolaim yeu núk siika, jum káhui mejikau bíchaa. Huanäi täbuiasi machisi taahuak bem bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jume ä sánkohuam bélojkosi taahuak, entok tüisi tósalisi, sápam bénasi, kia jábe jípaksialeero júne ím buíapo joome kaibu junëli am basuanake. ");
INSERT INTO mfy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huanäi bempo Elíasta éntok Moiséjta ámeu yeu machiamta bitchak, entokim Jesústamak ettejhuay. ");
INSERT INTO mfy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Huanäi Peero nónokaka, Jesústau ínel jiaahua: —Maestro, ¡tüisite ímï aane! Báij jötamte yáanake: huépülak emo béchïbo, entok Moiséjta béchïbo seenuk, entok Elíasta béchïbo ket seenuk. ");
INSERT INTO mfy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Junëlim áu jiaahuak jume discípulom bueïtukim guómtilamtukay, Peero éntok kaachin jiau máchika. ");
INSERT INTO mfy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Huanäi jü namu ámeu yúmaka ámet jëkkaatek. Jíahui éntok jum namu bétana yeu sika ínel jiaahua: —Ïri ájäria jü ín Üusi ín nákëhui; áapörikem nok jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huanärim sejchúkti naa remteka, kaabeta éntokim bitchak ámemaki, Jesústa jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Huanäi jü káuhuit kóm kateka, am téjhuak kaabetau ä ettejhua nésauhueka juka bem bíchakähui, juka Yoremta Üusi kókkolam násuk ä jíabitek jübua. ");
INSERT INTO mfy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Huanärim bem jiápsipo jíba ä jípurek júkäi nokta, jáchisu jiaubáare jäni tï éaka kókkolam násuk ä jíabitenakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Huanärim Jesústam temajek: —¿Jáchisu júntuk huéeka jume judíom ley am mamájtéame útteä tíiya juka Elíasta bat äbo yebíjnakëhui? ");
INSERT INTO mfy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Áapo éntok am yommiaka ínel jiaahua: —Huä Elías ál‑la lútüriapo bat äbo yebíjnake, éntok äbo yepsakätek sïmeta huéchiapo ä órekay bénasi ä tóijnake. Të, ¿jáchisu júntuk ket jiaahua jü jïojteri Yoremta Üusi bétana? Jiokot ahuä bitna bétana, éntok kaitäpo ä bítna bétana. ");
INSERT INTO mfy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tëne ínel enchimeu jiaahua, jü Elías béja yebíssuk, éntokim sïmeta bem au yáabárëu au yáuhuak, áa bétana jïojteripo bénasi. ");
INSERT INTO mfy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Huanäi jume huate ä discíipulommeu yepsaka, juebena genteta bitchak áme chíkola aneme, éntok jume judíom ley am mamájtíame ámemak noknássuame. ");
INSERT INTO mfy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Huanäi, sïme jü gente Jesústam, bíchakä guómtek, éntokim au tenneka ä tebótuak. ");
INSERT INTO mfy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Huanäi Áapo am temájek: —¿Jítasem ámemak noknássua? —ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Senu éntok áme násuk ä yómmiakä ínel jiaahua: —Maestro, ín üúsine emou huéria, múuro espírituta jípuremta. ");
INSERT INTO mfy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Huäri jak ä jaatíakäpo, ä tatabeka éntok támmim kumeka sómöchiata yeu pujpujtía. Júnëli béja nama sutalayka tatahua. Em discíipulommeu éntokne nookak juka espírituta chichä machik yeä béebria sáhueka, tem kára yeä béebriakä taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Huanäi Áapo ínel ámeu jiaahua: —¡Eme gente kaíta súalëram! ¿Jahuéi tájtisune enchimmak annake jäni? ¿Jahuéi tájtisune enchim kaíta súalëu ínnënake jäni? Ínohuem ä huéria. ");
INSERT INTO mfy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Huanärim au ä núk sájjak. Jü diablo éntok Jesústa bíchaka, juka jübua yotumta náasä jímmaataitek, éntok buíapä röaktitaitek, sómöchiata éntok yeu pujtíataitek. ");
INSERT INTO mfy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Huanäi Jesús ä atchaihua temájek: —¿Jahuéi naatekasu ïri au aika? Ä áchaihua entok ínel jiaahuak: —Ä ilítchiak naateka; ");
INSERT INTO mfy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","éntok juebénasi jü espíritu chichä machi bäapo éntok taijpo júne ä tabbei ä mëbáreka. Të empo áma yumätek, itómë anía ito bétana jiokot éaka. ");
INSERT INTO mfy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Huanäi Jesús ínel au jiaahua: —Enchä súalnakeyo, bueïtuk hua ä súalemta béchïbo sïme kaa obíachi. ");
INSERT INTO mfy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Huanäi jü usita atchai úttiaka ínel jiaahua: —Jeehui, anä súale; nechë anía chë ín ä súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús éntok juka juebena genteta au rúktemta bíchaka, jü espíritu chichä machitau kutti nonokak, ínel jíaka: —Empo espíritu chichä machi múuro éntok nákapi, ínapone enchi at yeu huee sáuhue jü usítachi, éntoke yeu sikätek kaa júchi au nonnotte. ");
INSERT INTO mfy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Huanäi jü espíritu cháchayek, huanäi júchi tüisi náasä tápsuka, yeu siika. Huanäi jü usi mukúkamta bénasi taahuak, júntuk bürukä ä mukila tíiyai. ");
INSERT INTO mfy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Të Jesús mámpo ä buíseka, ä tóboktiak; huanäi jü usi kíktek. ");
INSERT INTO mfy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Huanäi jum jóapo Jesústa kibákek, jume ä discíipulom áapolaik áma aneyo ä temajek: —¿Jatchíakasu ítapo kara yeä béebai jäni? ");
INSERT INTO mfy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Áapo éntok ínel ámeu jiaahua: —Ilëbena diablo kaítai éntoko ára yeu beptu oraciónta juaka entok ayunahuamtay jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Huanäi huämi yeu sákalamtaka, Galiléa buiära páman kaatei; të Jesús kaabeta ä jüneriä ïai. ");
INSERT INTO mfy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bueïtuk jume ä discíipulom majtiaka ínel ámeu jiaahua: —Ínapo jü Yoremta Üusi yoremem mampo tóijhuaka mëna. Të ínapo mukuk, baij taahuarim hueine jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Të bempo kaa at jüneiyai ïri nokit jachin ä jiau bárëhui, éntokim at temae báare júne majhuëi. ");
INSERT INTO mfy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Huanäi huam pueblo Capernáumpo yájaka, huam jóapo aneka, Jesús am temajek: —¿Jítasem nau nok nássuasakai jum böochi? ");
INSERT INTO mfy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bempo éntok kaa jíalek, bueïtukim jum böochi jábeta chë yöpo tahuánakëhuim nau noksakai. ");
INSERT INTO mfy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Huanäi Jesús yejteka, jume dóocem núnuka, ínel ámeu jiaahua: —Jü jábe chë yöpo tahua báareme, huäri chúkula huéenake sïmem béppa, éntok sïmem nésauta joríanake. ");
INSERT INTO mfy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Huanäi ili úsita nüka, áme násuk ä kétchak. Ä íbaktiaka ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Huä ín téhuampo huaka ili úsita ílëbenak mabetakame, nee mabetnake; éntok hua nee mabetakame, kaa nee jíba mabetnake, huaka nee äbo bíttuakamta ket mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Huanäi jü Juan ínel jiaahua: —Maestro, senukte bitchak em téhuampo jume espíritu chichä machim yeu bébamta, tëte júkäi ä táktiriak, bueïtuk kaa itomak huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Huanäi Jesús ínel jiaahua: —Katem júkäi ä taktiria, bueïtuk kaabe aane ín téhuampo milagrom joákä chúkula éntok juënasi ínot noknákeme. ");
INSERT INTO mfy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bueïtuk hua kaa itom béj‑reme itomak huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Éntok jábe júne ín téhuampo senu vaso bäam enchim mikakame, Crístota enchim átteakä béchïbo, lútüriapo jíba ä mabetnake juka béjhuata. ");
INSERT INTO mfy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Kia jábe júne ili usi nee súalemta Dios bejrita yatuakame, áa béchïbo chë türi éiyey kee júkäi yáaka, téta át tútujhuamta kutänaapo át súmahuaka bahuéu kóm jímmaahuako. ");
INSERT INTO mfy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Júnëli jume em mámmam Dios bejrita enchi jóotuanakey, Akë am chúktia. Bueïtuk chë türinake emo béchïbo huépülam mámaka yúu jíapsihuäu em huéenakëhui, guoyim mámaka infiernou táijta kaa tutukëpo em huéenakeu béppa, ");
INSERT INTO mfy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","huam buíchiam kaa lülütëpo, éntok huaka táijta kaa jaibu tutukëpo. ");
INSERT INTO mfy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Éntok jume em guókkim Dios bejrikuu enchi huérianakey, Akë am chúktia. Bueïtuk chë türinake emo béchïbo huépülam guókeka yü jíapsihuäu em huéenakëhui, guoyim guókeka infiernou táijta kaa tutukëpo em jímmaanäu béppa, ");
INSERT INTO mfy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","huame bem buíchiata kaa mumukëpo, entok huaka táijta kaa jaibu tutukëpo. ");
INSERT INTO mfy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Éntok jume em pusim Dios bejrita enchi bíttuay, yehuë am huíkke. Bueïtuk chë türinake emo béchïbo huépülam puseka Diosta lóoriau em huéenakëhui, guoyim puseka infiernou táijta kaa tutukëpo em jímmaanäu béppa, ");
INSERT INTO mfy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","huam buíchiam kaa lülütëpo, entok huaka táijta kaa jaibu tutukëpo. ");
INSERT INTO mfy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Bueïtuk sïme tájiay jiokot machisi ontuatuna, entok sïme hua Diosta bíchäpo órehuame ontuatunake. ");
INSERT INTO mfy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Türi jü oona, të juka onta kaa chökoak, ¿jítasuysem ä tü tátabnake? Omtem jípureka jiápsa, éntokem al‑leehuamta nau jípure. ");
INSERT INTO mfy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Huanäi Jesús Capernaumpo yeu sika, Judea buiärau yepsak, entok bathue Jordán huáytana. Gente éntok júchi au nau yájjak, huämi júchi am majtia táytek, bannaataka bénasi. ");
INSERT INTO mfy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Huanäi jume pariserom áu yájaka ä temajek, ä jioptua báreka, jachu türi jäni, juka jubekamta ä jubi jímmaanakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Huanäi ínel am yommiak: —¿Jáchisu júntuk enchim sáuhuek jü Moisés? ");
INSERT INTO mfy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bempo éntok ínel jiaahua: —Moisés licensiata nénkak, jiösia divorciota yáanä bétana. Huanäituk senu ä jubi ára jímma. ");
INSERT INTO mfy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús éntok ínel ámeu jiaahua: —Enchim námakak jiápsekä béchïbo íkäi nésauta enchimmeu jïojtek. ");
INSERT INTO mfy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Të Dios ániata yáaka outa yáuhuak, entok jámutta. ");
INSERT INTO mfy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Íäri béchïbo jü yoreme juka ä áchayhua entok ä áyehua tösika, ä jubimak jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Huanäi jume guoyiakaïhuim huépul takahuatunake.” Júnëlim béja kaa guoyinake, ál‑lam huépul takahuatunake jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Huäri béchïbo hua Diosta nau rúktiakähui, jü yoreme kaa ä näikimtepo yúmala. ");
INSERT INTO mfy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jóapo ä aneyo, jume ä discíipulom júchi ä temajek huäri bétana. ");
INSERT INTO mfy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús éntok ínel ámeu jiaahua: —Jábe júne ä jubi jímmaaka täbuik jubekätek, bát ä jubiari béj‑reka adulteriopo näikiatunake. ");
INSERT INTO mfy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jü jámut júne ket ä kuna jímmaaka täbuik kunakätek, bát ä kunahua béj‑reka adulteriopo näikiana. ");
INSERT INTO mfy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Huanärim Jesústau ili usim au rúktiay, áme béppa ä mamtë ïaaka. Ä discíipulom éntok ámeu omtey, jume usim áu huériammehui. ");
INSERT INTO mfy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Huanäi Jesús júkäi bíchaka, kujti éaka ínel ámeu jiaahua: —Akem am tójja, jume ili uusim, éläpom inou kannake. Júkärem kaa am üuhua, bueïtuk bempörim bénasi éame ä átteak, juka Diosta rey nésauri. ");
INSERT INTO mfy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tua lútüriapone ínel enchimmeu jiaahua, kia jábe júne kaa ili úsita bénasi éaka juka Diosta rey nésauri mabetakame, kaibu áman kibaknake. ");
INSERT INTO mfy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huanäi am nüka am íbaktiak, entok áme béppa mámteka tü nokta ámet chúppak. ");
INSERT INTO mfy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Huanäi Jesústa yeu sika hueyo. Senu búiteka au yépsak, huanäi ä bíchäpo tónommia kíkteka, ínel au jiaahua: —Türi Maestro, ¿jítasune yáakätek, yü jíapsihuamta jipunake jäni? ");
INSERT INTO mfy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Huanäi Jesús ínel au jiaahua: —¿Jatchiake nee türï tíiya? Kaabe éntok aane türika, huépülaika jíbba, jü Dios. ");
INSERT INTO mfy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jume Diosta nésahuimë täya: “Katë omot jubiata jípunake. Katë yore súuhua. Katë ekbua. Katë jábetat kia nooka. Katë jábeta bäitáttähua. Em áchayë yöre, entok em áiye.” ");
INSERT INTO mfy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jü yoreme ä yommiak: —Maestro, ímëi nésahuimne yáala, ín kaa yötukäpo naateka. ");
INSERT INTO mfy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Huanäi Jesús ä bíchaka tüisi ä nákeka taahuak, éntok ínel au jiaahua: —Senu huéeme emou bëye: sikë sïmeta em jípurëu nénkaka póobem ä miika. Huanärë áman téhuekapo yún béj‑remta jípunake. Jiokot anhuäpe em kúruj püaktiaka ino sáu huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Të áapo ïri nokta béchïbo kaa al‑leaka siika, bueïtuk yún jita buéresi áttiakay. ");
INSERT INTO mfy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Huanäi Jesús nate chíkola reemteka, ä discíipulommeu ínel jiaahua: —¡Tepam obiachisi huam Diosta reytaka nésahuepo kimunake, jume yún jita buéresi áttiakame! ");
INSERT INTO mfy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jume ä discíipulom éntok guómtek, júnël ä jíakä béchïbo. Të Jesús júchi ínel ámeu jiaahua: —In üusim, ¡tua obiachisim Diosta reytaka nésahuepo kimunake, jume yún jita buéresi áttiaka at éame! ");
INSERT INTO mfy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chë júne kaa obiachi camellota jum jiikia pusim páman yeu ä huéenakëhui, yún jita buéresi áttiakamta Diosta reytaka nésahuepo ä kibaknake béppa. ");
INSERT INTO mfy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Huanärim chë júne májhueka nau ínel jiaahua: —¿Jábesu júntuk ára au jínëunake jäni? ");
INSERT INTO mfy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Të Jesús am bíchaka ínel jiaahua: —Yoremem béchïbo obiachi, të Diosta béchïbo ëe; bueïtuk sïme ayukame áa béchïbo kaa obiachi. ");
INSERT INTO mfy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Huanäi jü Peero ínel au jiaahua: —Én ítapo sïmetate itom jípurëu tö sákalamtaka émomak rejte. ");
INSERT INTO mfy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús éntok ínel ámeu jiaahua: —Tua lútüriapone enchimmeu ínel jiaahua, jábe junne juka ä jóa tö simlame, o ä saayim, ä sailam, ä ákorom, ä huaayim, ä átchay, ä áiye, ä juubi, ä üusim, ä buía junne, ino béchïbo entok evangeliota béchïbo, ");
INSERT INTO mfy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ímï tiempopo cientopo cienim mabetnake, jume jóuhuam, sailam, ákorom, áiyem, üusim, entok buíyyam, guok jájjahuaka junne; jume taahuarim äbo huéemet éntok, juka yü jíapsihuamta. ");
INSERT INTO mfy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Të juebénaka huame bát kateme chúkula kannake; chúkula kateme éntok bát kannake. ");
INSERT INTO mfy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Huanärim buere joära Jerusaléniu, jikau kaatey; Jesús éntok ámepat huéiyey. Bempo éntok guomtilatakam ä guojaasey, entokim májhueka áamak kaatey. Huanäi júchi jume dóocem sékäna bíchaa yeu núk sika, am téjhuak huaka jita au huéenakemta. ");
INSERT INTO mfy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Huanäi ínel ámeu jiaahuak: —Ímïte Jerusaléniu jikau kaate. Ínapo jü Yoremta Üusi éntok tiöpopo chë nésahueme entok escribam mámpo tóijtunake. Huanärim bette nokta át chúpanake, ä mëtebo béchïbo, entokim kaa judíom mámpä tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bempo éntok ä junneriasuka ä bemmuchanake. Áachim chit huáttinake, entokim ä mënake; të baij taahuata huey jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Huanäi Jacobo entok Juan, Zebedeota üusim, au rúktek ínel au jíaka: —Maestro, itom aahuäute enchi itom yáaria ïaa. ");
INSERT INTO mfy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Áapo éntok ínel ámeu jiaahua: —¿Jítasem nee enchim yáaria ïaa? ");
INSERT INTO mfy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bempo éntok ínel áu jiaahua: —Em lóoria nésahuepo itom jotetua, seenu em báta bétana, senu éntok em míköri bétana. ");
INSERT INTO mfy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Huanäi Jesús ínel ámeu jiaahua: —Katem jüneiya jita enchim aahuähui. Juka vaasopo jiokot máchiraata ín jïnakeu, ¿eme ket ára ä jëye? Entok ín batöna bénasi, ¿eme ket ára emo batöa? ");
INSERT INTO mfy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bempo éntok ínel ä yommiak: —Amate yúma. Huanäi Jesús ínel ámeu jiaahua: —Tua lútüriapo, eme ä jïnake, huaka vaasopo jiokot máchiraata ín jïnakëhui, entok ín batöhuakäpo bénasi eme ket batöna; ");
INSERT INTO mfy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","të hua enchim ín báta bétana jotenakeu entok ín míköri bétana, kárane jábeta ä mákka, huame jábem béchïbo näikiari huámëi ál‑la ä mabetnake. ");
INSERT INTO mfy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Huanäi jume guojmamnika ä jíkkajaka, jü Jacobotau omti táytek, entok Juantahui. ");
INSERT INTO mfy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Huanäi Jesús am núnuka, ínel ámeu jiaahua: —Eme jüneiya jume naciónim násuk huaka chë nésahuemta au buérialëhui, entok jume buéresi emo ériame emo nésaulëhui. ");
INSERT INTO mfy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Të enchim násuk kaa junëli huéenake, ál‑la jábe júne enchim násuk yösi au éria báareme, huäri nésauta enchim jorianake. ");
INSERT INTO mfy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jábe enchim násuk bát huée báareme, huäri sïmem nésauta jorianake. ");
INSERT INTO mfy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jáchin ínapo jü Yoremta Üusi äbo yepsak, kaa nésauta nee joria ïaaka, ál‑la jábem jita yáariaseka, entok ä jíapsi nénka, bürum jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Huanärim pueblo Jericóu yájjak. Huämi ä discíipulommak yeu siika, entok yun juebena gentetamaki. Jü Bartimeo, hua lipti, Timeota üusi, böo mayoat káteka nétaney. ");
INSERT INTO mfy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Huanäi ä jíkkajaka Jesús Nazarenota áma hueïhui, chayeka ínel jiau táytek: —¡Jesús, Davidta Üusi, nechë nák jiokolë! ");
INSERT INTO mfy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Huanäi juebénakam au omtey, kaa ä jíal sáhueka. Të áapo chë úttia chayeka ínel jiaahuay: —¡Davita Üusi, nechë nák jiokolë! ");
INSERT INTO mfy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Huanäi Jesús kíkteka, ä núnutebok. Huanärim líptita tejhuak, ínel áu jíaka: —Katë jáchin éiya. Kíktëe; enchi núnnu jü Maestro. ");
INSERT INTO mfy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Huanäi áapo ä jíniam jímmaaka, kíkteka Jesústau siika. ");
INSERT INTO mfy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Huanäi Jesús ä temajek: —¿Jítasë nee enchi yáaria ïaa? Jü lípti éntok ínel jiaahua: —Maestro, nechë bíttua. ");
INSERT INTO mfy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Huanäi Jesús inel au jiaahuak: —Simeë; em nee súalë béchïbë bitcha. Huanäi jü lipti sep bíchaka taahua, huanäi Jesústa sáu siika jum böochi. ");
INSERT INTO mfy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Huam Jerusaléniu kaa mékka aneka, Betfagé, entok Betánia pueblom náapo aneka, Oliivo káhui pújbapo, Jesús guoy ä discíipulom áman bíttuak. ");
INSERT INTO mfy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Júnel ámeu jiaahua: —Katëem, huam pueblou enchim pújbapo kátekamtahui. Ámanem yájakätek ili buru bemelata áma chäkamtem téunake; huächi jábe yoreme júne kee jee át yejte. Akem ä búttiaka äbo ä huérianake. ");
INSERT INTO mfy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Huanäi jábeta enchimmeu ínel jiay: “¿Jatchiakem júkäi johua?” Huanärem juka Señorta ä huáatiä tíanake, entok chúkula ä nóttiria rókka. ");
INSERT INTO mfy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Huanärim áman sájaka, juka ili buruta téuhuak áma chäkamta puértapo yeutana, böota tottëpo. Huanärim ä búttiak. ");
INSERT INTO mfy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Huate áma aneme ínel ámeu jiaahua: —¿Jitasem johua? ¿Jatchiíakem juka ili buruta butbúttia? ");
INSERT INTO mfy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Huanäi bempo Jesústa nésahuekä páman am yommiak. Huanärim am tójjak. ");
INSERT INTO mfy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Huanärim juka ili buruta Jesústau nüpaka, bem sánkom at töak. Huanäi Áapo at yejtek. ");
INSERT INTO mfy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gente éntok juebénaka bem sánkom böot áapat tösakay; huate éntok júya sáhuam chúktiaka, ket böot áapat am tösakay. ");
INSERT INTO mfy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jume bat kateme chay sákay entok jume amapo kateme ínel jíaka: —¡Looria! ¡Diosta tü eäu at chúpari jü Diosta yaura úttiäray téhuampo yebisiseme! ");
INSERT INTO mfy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Diosta tü eäu áa béchïbo, jü David itom áchay nésahuepo äbo huémta béchïbo! ¡Buéresi al‑leehuame téhuekau tájti! ");
INSERT INTO mfy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Huanäi Jesús buere joära Jerusaléniu yepsaka, jum tiöpou kibakek. Huanäi nate chíkola reemteka, sïmeta áma ayukamta bitchak. Bueïtuk beja kúptey huanäi pueblo Betániau bíchaa yeu siika, jume dóoce discípulommaki. ");
INSERT INTO mfy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huanäi yokoríapo Betaniapo yeu am sájako, Jesús tébäurek. ");
INSERT INTO mfy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Huanäi mékka chuna óguota bitchak yún sáhuakamta. Áu rúktek takam áu téu máchileka, të kaita at téuhuak, sáhuam jíbba, bueïtuk kee jee yuumay bem takanakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Huanäi Jesús ínel au jiaahua hua chuna óguotahui: —Kaibu jábe éntok em taka buänake, jíba béchïbo. Ä discíipulom éntok ä jíkkajak ínel ä jíayo. ");
INSERT INTO mfy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jum Jerusaléniu yájaka, Jesús jum tiöpou kibakeka, jume jita áma nénkame entok jita jínnume päkun yeu bep táytek. Entok jume tómita nakuliame mesam naa guötiriak, entok jume guókohuim áma nénkame bankom kétchi. ");
INSERT INTO mfy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kaabeta jum tiöpopo áman kia jume vasom júne yeu huéria ïay. ");
INSERT INTO mfy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huanäi am majtiaka, ínel ámeu jiaahua: —¿Jachu kaa ínel jïojteri? “In káari áma Diostau oraciompo nok béchïbo káari ti téhuaanake entok sïme géntem béchïbo.” Eme éntok lak‑ron kári guójoriäpo ä tahuariala. ");
INSERT INTO mfy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jume escribam éntok jume tiöpopo nésahueme ä jíkkajaka, at tekipánoa táytek, jáchin bem ä mëtebonakëhui, bueïtukim ä májhuei, sïme jume géntem ä yosireka at guómtilatukä béchïbo hua áapörik am majtíäubechi. ");
INSERT INTO mfy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tukáriu yúmak éntok Jesús áma yeu siikä jum puéblopo. ");
INSERT INTO mfy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Huanärim yokóriapo kethueitana böot kateka, juka chuna óuguota bitchak huakíata nahuapo naateka jikau tajti. ");
INSERT INTO mfy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Huanäi Peero au huahuáateka ínel au jiaahua: —Maestro, Akë ä bitcha hua chuuna nokta béttesi em at nokakau huakía. ");
INSERT INTO mfy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Huanäi Jesús ínel ámeu jiaahua: —Dióstachem eiya. ");
INSERT INTO mfy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bueïtuk tua lútaüriapone enchimeu ínel jiaahua, jábe júne ï kautau ínel jíakame: “Sóoktekë, bahuéu emo jimma”, éntok ä jiápsipo kaa täbuiasi éaka tua ä súalëtek ä nokákähui, huanäi ä nokákä páman yáatunake. ");
INSERT INTO mfy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kíalïkune enchimeu ínel jiaahua, sïme hua Diostau oraciompo enchim aahuähui, akem ä súale enchim ä mabetnakëhui, huanäi jíba enchimeu ayúnake. ");
INSERT INTO mfy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Diostau oraciompo nokätekem emo jiokore, jabetamak emo béj‑reka ayulaatukätek, huaka enchim Átchay téhuekau kátekamta ket enchim jiokorinakë béchïbo, huame enchim Dios bejrimmechi. ");
INSERT INTO mfy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bueïtuk enchim kaabeta jiokoreyo, enchim Átchay téhuekau katekame ket kaibu enchim jiokorinake enchim Dios bejrimmechi. ");
INSERT INTO mfy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Huanärim júchi Jerusaléniu bíchaa nóttek, éntok áapörik jum tiöpopo huaijhua hueramai, jume tiöpopo nésauhueme éntok jume escribam Jesústahuim yájjak, éntok jume koba yoiyoöhuem. ");
INSERT INTO mfy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Huanärim ínel au jiaahua: —¿Jita lútüria úttiatasë jípureka íkäi johua? Éntok, ¿Jábesu enchä mak‑la juka lútüria úttiata íkäi em yáanakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Huanäi Jesús ínel ámeu jiaahua: —Senu huémtane enchimmeu nátemaijnake ínapo kétchi. Enchim nee téjhuakne ket enchim téjhuanake jita lútüriai íkäi ín joähui. ");
INSERT INTO mfy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jü Juanta yore batöau, ¿jachu téhueka bétana nésautukai jäni, ö im buíapo yoremem bétana? Nechem téjhua. ");
INSERT INTO mfy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Huanäi bempo júnen nau jiaahuay: —Téhueka bétana tï itom jiai junne, ínel itou jiaunake: “¿Jatchíaka júntukem kaa ä súalek?” ");
INSERT INTO mfy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yoremem bétana ti itom jíäi éntok kaa türinake. Ínëlim jiaahuay bueïtukim juka genteta majhuëi, bueïtuk sïmetakam Juanta tua lútüriapo ä proféta tíiyai. ");
INSERT INTO mfy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Huanärim Jesústau ínel jiaahua: —Katte jüneiya. Huanäi Áapo ínel am yommiak: —Ínapo ket kaa enchim téjhuanake jita lútüria úttiärai íkäi ín joähui. ");
INSERT INTO mfy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Huanäi Jesús ámeu noktáitek ejemplom ámeu jójjoaka, inel ámeu jiaahuak: —Senu yoreme párasim eechak, éntok ä kóräituak, éntok áma párasim áma chiríjtia béchïbo erata yauhuak. Torejta éntok áma yáuhuak, jikat káteka etta suáyä béchïbo. ’Huanäi tattäbuimmeu ä reu nénkaka mékka bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Huanäi párasim takai, huépülak ä sáuhuëu áman jaasek etta tekipánoammehui, huaka áma chúpukamta ä nüsáuhueka. ");
INSERT INTO mfy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Të bempo ä buíseka, kökosä yáakä éntok kayta ä makaka ä simtúak. ");
INSERT INTO mfy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Huanäi juchéntok senuk ä sáuhuëu ámeu jaasek. Huákärim éntok mamáasukä kóbat kökosä yáuhuak, éntokim tiusi ä yáakä ä simtúak. ");
INSERT INTO mfy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Juchéntok senuk áman bíttuak, huákärim éntok mëak; éntok huate juebenam áman bíttuak, huatémim kökosi yáuhuak, huatémim éntok súhuak. ");
INSERT INTO mfy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Të chúkula, ketune senu au bëyei, ä üúsihua ä nákëhui. Ket ámeu ä bíttuak ínel jíaka: “Jamak júnem ín üusi yörinake.” ");
INSERT INTO mfy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Të huame etta tekipánoame júnen nau jiaahua: “Ïri ájäria jü ä átteanakeme, átä mënake, huanäi itou tahuánake jü ä attea éaïhui.” ");
INSERT INTO mfy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Huanärim ä buíseka, ä mëaka, etpo yeutana ä jímmak. ");
INSERT INTO mfy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Huanäi Jesús am temajek: —¿Jáchisu ayúnake jäni hua nésahueme, párasim átteakame? Äbo sika, ímëi tekipanualeerom súanake, éntok jume ä páras échim tattäbuim mampo tóijnake. ");
INSERT INTO mfy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Jáchem íkäi jïojteta júne kaa bit-la? Ínel jíamta: Huä tetta huame káateleerom kaa huáatiakähui, huäri ínel jum kari eskinapo tahuala ëni. ");
INSERT INTO mfy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jü Señor ä yáala íkäri, éntok itom bíchäpo sïmek béppa musäla maachi. ");
INSERT INTO mfy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Huanärim at tekipanuatáitek jachin bem ä buíjtebonakëhui, bueïtukim at jüneïak áme bétana ínel íkäi ejemplota ä nokákähui. Tem juka juebena genteta majhuëi, huanärim ä tójakä sájjak. ");
INSERT INTO mfy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Huanäi huate pariseerom éntok Herodíanom au bíttuak jita nokpo júne bem ä jaatíanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Huanärim au yájaka, ínel au jiaahua: —Maestro, jünéate lútüriata em boojóoriahui, éntok kaabeta bétana emo suáyähui, bueïtuk yoremta jachin ä machíakäubechë kaa suuhua, ál‑lë tua lútüriai am téjhua juka Diosta böo. ¿Jachu lútüria jäni rey Césarta tómita itom maknakëhui? ¿Ata maknake ote kaa ä máknake? ");
INSERT INTO mfy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Të Jesús éntok ámet jüneakä jítat júne bem ä jaatíabarëhui, huanäi ínel ámeu jiaahua: —¿Jatchíakasem nee jióptua báare? Bueïtukem juka tómita inou huéria ä bit béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bempo éntok au ä tójjak. Huanäi ínel ámeu jiaahua: —¿Jábesu ïri jü tómit yáari, éntok ï jïojteri jábeta tehuampo yáari? Huanäi bempo ínel au jiaahua: —Rey César ä átteak. ");
INSERT INTO mfy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Huanäi Jesús ínel am yommiak: —Juka Césarta áttea Césartem ä mákka. Juka Diosta attea éntok Diostem ä mákka. Huanärim at guómtek hua ámeu ä nokákäubechi. ");
INSERT INTO mfy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Huanäi huate saducéom au yájjak, jume kókkolam kaa júchi jíjiabitë tíame. Huanärim ä temajek: ");
INSERT INTO mfy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, Moisés ínel jïojtek, bueïtuk jábe ä sai mukuk, juka ä jubíahua kaa asóakamta tahuak, ä sailahua ä jubeka at usianake ä saila tehuampo. ");
INSERT INTO mfy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guoibúsanikam emo sayekai. Jü bathuéeme jubek huanäi muúkuk, të kaa usim jípurek. ");
INSERT INTO mfy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Huanäi jü áa sáu huéeme ä juúbek, të ket muúkuk; huäri júne kaa usim at jípurek. Éntok jü bájikun huéeme ket jíba bénasi. ");
INSERT INTO mfy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jume guoibúsanika ä juúbek, tem kaa usim at jípurek. Chúkula éntok jü jámmut muúkuk. ");
INSERT INTO mfy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jum kókkolam jíabitëpo, bempörim jíabetek, ¿jábesu ä jubnake jäni, bueïtuk jume guoibúsanika ä jubekai? ");
INSERT INTO mfy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Huanäi Jesús ínel ámeu jiaahua: —Aachem tuïsi jijjïobe bueïtuk juka Diosta nooki jïojterita kaa enchim taaya béchïbo éntok juka ä úttiära. ");
INSERT INTO mfy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bueïtuk kókkolam násuk jíabitehuäpo kaabe emo jubnake, entok kíalim jume Diosta ángelesim téhuekapo aneme bénasi jíba emo jípunake. ");
INSERT INTO mfy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Én éntok jume kókkolam jíabitelatunakëhui, ¿jachem kaa ä bit‑la Moiséjta jïojteri, Diosta jachin au nokákähui huam ili júya, zarzapo? Júnel ä jiapo: “Ínapone Abrahamta Dios, Isaacta Dios, éntok Jacobta Dios.” ");
INSERT INTO mfy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios kaa kókkolámeu Dios, jíapsámeu ál‑la. Júnëlem tüisi jiób‑la. ");
INSERT INTO mfy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Huanäi senu escriba áma yépsak nau am noknássuai am jíkkaijlataka, éntok Jesústa tüisi am yómmiakau jünériaka, huanäi ä temajek: —¿Jítasu jü Diosta nésauri bat huéeme sïmem béppa? ");
INSERT INTO mfy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Huanäi Jesús ínel ä yommiak: —Jü nésauri sïmem béppa bathuéeme ïri ájäria: “Íkäre jíkkaja Israel, jü Señor itom Dios, jü Señor huépülai jíbba. ");
INSERT INTO mfy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Éntoke em Dios Átchay náknake chikti em jíapsimaki, éntok sïme em ái jünéribeyi, éntok sïme em úttearammea.” Ïri ínel jü nésauri bathuéeme. ");
INSERT INTO mfy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jü áa sáu huéeme éntok ket álë benna: “Emo bénasi yorémtë náknake em emo ériä bénasi.” Kaíta éntok nésauri chë bej‑re ímëi béppa. ");
INSERT INTO mfy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Huanäi jü judíom ley am mamájtíame ínel au jiaahua: —Türi, Maestro, lútüriate nooka Diosta huépülaitíaka, bueïtuk kaabe éntok aane áapörik béppa. ");
INSERT INTO mfy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Éntok jü ito bénasi ä náknä bétana chikti itom jíapsimaki, éntok sïme itom ái jita jünériäubeyi, éntok sïme itom úttearammea, éntok ito bénasi yoremta náknähui itom ito ériä bénasi, chë júne bej‑re sïme hua Diosta bíchäpo naïkiari éntok animáalim taijpo tattahuame béppa. ");
INSERT INTO mfy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Huanäi Jesús tüisi ä yómmiakäu jíkkajaka, ínel au jiaahua: —Katë mékka áu aane Diosta reytaka nésahuebeyhui. Huanäi naateka kábe jita au nátemaij báreka taahuak. ");
INSERT INTO mfy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Huanäi Jesús tiöpopo am majtiaka ínel ámeu jiaahua: —¿Jáchisu júntuk jume escribam juka Crístota Davidta üusi tíiya? ");
INSERT INTO mfy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bueïtuk jü Espíritu Santo Davidta teniai ínel jiaahua: Jü Señor ínel ín Señorbeu ínel jiaahua: “In bata bétanë yejte, huame enchi béj‑reme em guókkim bétuk ín tahuáriäpo tajti.” ");
INSERT INTO mfy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jü David, áapo ä Señor rókka, ¿jáchisu júntuk ä üúsek téehua? Huä gente juebenara éntok tua al‑léakä ä jíkkajai. ");
INSERT INTO mfy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Huanäi ínel ámeu jiaahua am majtíaka: —Émoem suáya jume escribam bétana, téttëbem súpeka rejteka emo türeme, éntok jum plázapo bem tetébotuahuäu musäuleme. ");
INSERT INTO mfy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Éntok jume baankom bat jokame türeme bempörim béchïbo jum nau yayáijhuäpo, éntok jïbuähuäpo junne; ");
INSERT INTO mfy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","entok huame jámut jókoptulam bem attea üuhuame, entok emo bit‑ïaka téebesim oraciónim jojohua. Ímechi chë júnee noki jiokot machisi ámet chúpatunake. ");
INSERT INTO mfy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Huanäi Jesús huam tiöpopo tómita nau totoijhuapo pújbapo káteka am bitchay, jachin huaka genteta tómita áma órehui jum kajompo, éntok juebena rikom yún tomita áma óreme. ");
INSERT INTO mfy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jü jámmut éntok póobetakä éntok jókoptulatakä áma yépsak. Huanäi guoi tómi kaa jaikik bejremta áma jóiyak. ");
INSERT INTO mfy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Huanäi Jesús ä discíipulom núnuka, ínel ámeu jiaahua: —Tua lútüriapone enchimmeu ínel jiaahua, ï jámmut póobe jókoptula chë yún áma ä jóiyak sïmem béppa jum kajompo; ");
INSERT INTO mfy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","bueïtuk sïme huaka bem ámeu yeu bïlata áma óorek; ïri éntok ä póobétukä násuk juka sïmeta ä jípurëu áma jóiyak, juka áy ä jïbuä éäu junne. ");
INSERT INTO mfy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Huanäi tiöpopo Jesústa yeu sik, huépul ä discípulo ínel au jiaahua: —¡Maestro, ímëi téttame bitcha éntok jume káarim! ");
INSERT INTO mfy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús éntok ínel au jiaahua: —¿Jachë am bitcha ímëi bueere káarim? Kaíta téttam nat béppa joka tahuanake sïme kom tataptunake. ");
INSERT INTO mfy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tiöpota beu Oliivo káuhuit ä kátek, akim ä temajek bempóla aneka Peero, Jacobo, Juan, éntok Andrés, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Itómë téjhua, ¿jahueisu ïri ayúnake, éntok jita séñasu ayúnake béja sïmeta íkäi hueenakeyo? ");
INSERT INTO mfy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Huanäi Jesús ínel ámeu jiaahua: —Jítachem suuhua kaabe enchim bäitäunake. ");
INSERT INTO mfy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bueïtukim juebenakä yáijnake ín téhuampo. Huate ínel jíaunake: “Ínapone jü Cristo”; éntok juebenam bäitäunake. ");
INSERT INTO mfy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nássuahuä téamtem jíkkajätek, o nássuabaahuä tï jíaihuamta, katem emo maujtua, bueïtuk junëli huéenake; teé ke taahuari yumánake ániata luutínakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bueïtuk jume naciónim, emo béj‑reka emo tóboktianake, éntok yäuram emo béjreka. Buía éntok au yoyóonake sïmekut jak junne; éntok tüisi tébaatunake, éntok kia naa muksi huéenake. Ïri huéeme kia jita innëtáitihuäpo bénasi maachi. ");
INSERT INTO mfy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Émoem suáyä bueïtukem jume nésauhueme mampo tóijtuna, éntok sinagogapom bemmúchatunake. Réyim éntok gobernadórim bíchapem yeu núnuna ino béchiíbo, huämi enchim ino bétana noknákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Uttea íkäi evangelio sïme naciónimmeu bat noktúnakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Éntokem áman yeu tóijhuaka bem mampo jóahuako, katem at jachin eiya hua jita enchim noknakebechi. Huaka nokta huämi orapo Diosta enchim mikähui, huákärem noknake; bueïtuk kaa emé ínel noknake, jü Espíritu Santo ál‑la noknake enchim teniyi. ");
INSERT INTO mfy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Huámechi taahuarimmet senu ä sailahua mëtebonake, éntok áchaihuarim bem üusim súatebona; usíarim éntok bem atchaim béj‑reka emo tóboktianake, éntokim am súanake. ");
INSERT INTO mfy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Éntok kaabe enchim huáatianake ín téhuam béchïbo; të ä jiápsäpo tajti tüisi áma yeu sikame, huäri jíapsi jínëutunake. ");
INSERT INTO mfy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Akem ä bínnake juka juëna yóremta tühuata kaitäpo tahuariamta. Profeta Danielta jíakä bénasi kaa ä öorëpo órenakeme —jü jïojteta nokame at jünenake—, huanäi jume Judéa buíaräpo joome juya kauhuiu bícham tenninake. ");
INSERT INTO mfy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jü kari jikat aneme éntok kaa kóm sika kariu kibákeka jita áma nünake; ");
INSERT INTO mfy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","éntok jü huajpo tékipanoame kaa ä joau nótteka ä kaapam nünake. ");
INSERT INTO mfy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jiokot machínake huame abe asoame béchïbo, éntok huame ili ússim chïtuame béchïbo huámëi taahuarimmechi. ");
INSERT INTO mfy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dióstahuem buaana kaa séberiapo íkäi yumánakëhui huaka enchim yeu tennínakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bueïtuk huámëi taahuarim kökosi machínake, hua jakhuéi júne kaa ayúakaïhui Diosta ániata yáakäpo naateka én tajti, éntok kaa jaibu júchi ayúnake. ");
INSERT INTO mfy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Juka Señorta kaa huámëi taahuarim ilíikisi yáako, jábe júne kaa jiápseka tahua eiyei. Të huame áapörik yeu púakäu béchïbo kaa jáikisi am yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Jábeta enchimeu ínel jíai: “Akema bitcha, ímï aane jü Cristo”, o “Huämi aane ta jíayo, katem ä súale.” ");
INSERT INTO mfy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bueïtuk Cristom ára nókïchim yáijnake, éntok ket profeta aranókïchim, éntok señáalim jonake éntok jita júne ániat yeu machíriana jábeta bäitäu báreka, áma yumätek jume yeu púarim junne. ");
INSERT INTO mfy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Të eme, jitachem suuhua; sïmetane enchim téjhuala bat huëpo naateka. ");
INSERT INTO mfy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Huámëi taahuarimmet hua jiokot éehuamta simsuko, jü täa kaa machisi tahuánake éntok jü meecha kaa machíriata jípunake; ");
INSERT INTO mfy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","jume chókkim éntok téeka bétana kóm huáttinake; hua útteara téekat ayúkame éntok au yoyóonake. ");
INSERT INTO mfy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Huanärim ä bínnake huaka Yoremta Üusi namupo äbo kóm huemta, tüisi útteakamta éntok ujyorisi machíriakamta. ");
INSERT INTO mfy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Huanäi jume Diosta ángelesim naa sáunake jume yeu púarim nau am tóijnakë béchïbo norte bétana, sur bétana, täata yeu huë bétana, éntok täata áman huechë bétana, buíata yumäu núkisi éntok téekata yumäpo tajti. ");
INSERT INTO mfy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Jü chuná óuguochem suuhua jünee béchïbo jachin ä machíakähui: hua chuná otta basíhueka sáhuatunake, huanärem jünéenake béja kaa mékka ä bëyehui juka tebujriata sïme juyam takanakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Júnëli ket íkäi bichätekem jünéenake béja kaa jaiki taahuarim ín yebíjnakeu bëyehui. ");
INSERT INTO mfy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tua lútüriapone enchimeu ínel jiaahua, jü gente én kat‑ria kaa luutínake sïmeta íkäi ayuäu tajti. ");
INSERT INTO mfy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jü téeka éntok jü buíya luutínake, të jü ín nooki ëe. ");
INSERT INTO mfy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Huaka taahuata éntok orata áachä yebíjnakeu kaabe ä jüneria; kial huame Diosta ángelesim áman téhuekapo aneme junne, éntok ínapo jü Usíari junne. Áapo jíbba, jü áchaihuari. ");
INSERT INTO mfy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Áachem suuhua, katem koptel‑la, éntokem Diostau buaana, bueïtukem kaa jüneiya jahuéi íkäi hueenakëhui. ");
INSERT INTO mfy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yoremta ä jóa tö sika mékka bíchaa sikamta bénasi maachi; jachin jü yoreme ä sáhuëu lútüriata máknake ä jóapo am nésaunakë béchïbo, éntok nátepola tékilta bem jonákëu am máknake; puértata suáyamta junne kaa kotcháunake, bueïtuk au boobit ïaaka. ");
INSERT INTO mfy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Huámëi bénasi emé kaa koptélnake, bueïtukem kaa jüneiya jahuéi juka jóakamta yebíjnakëhui, jamak kúpteyo, o tukáa násuk huéeyo, o totorörata kuseyo, o kethueï bíchaa; ");
INSERT INTO mfy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Huanäi Áapo yepsákätek bueïtuk kaa enchim kócheme téunake. ");
INSERT INTO mfy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enchimmeu ín nokákähui sïmemmeunä nooka: katem koptel-la. ");
INSERT INTO mfy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Guoi taahuarim bëyei pájko paskuata huenakeyo, éntok jume páanim kaa lévaduuraka áma buäbuame. Jume tiöpopo nésauhueme éntok jume escribam áachim tekipánoai jachin Jesústa báitähuaka bem ä buíjnakëhui ä më béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Huanärim ínel jiaahua: —Kaa pajko táapo türi buijbéchïbo, bueïtuk jü gente jachinaik júnne au tóboktianake. ");
INSERT INTO mfy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Huanäi Jesús jum pueblo Betániapo Simmom jü sähua leprata jípurëuta jóapo aneka jïbuäi. Senu jámmut éntok áma yépsak nardo bähuata musäla jubak ili teta sótöpo huériaka, tüisi béj‑remta. Huanäi juka ili sótöta teníapo jámtiaka, kóbat aachä töak. ");
INSERT INTO mfy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Huanäi jume huate áma aneme omteka ínel nau jiaahuay: —¿Jatchíakasu ï ili bäa ínëli kia guötiahuak? ");
INSERT INTO mfy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bueïtuk ï bai cien taahuari tékilta bejhua béekipo nénkitu éehuai, póobem ania béchïbo. Huanärim jámutta bétana kaa türik nookai. ");
INSERT INTO mfy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Të Jesús ínel jiaahua: —Akem ä tojja. ¿Jatchíakasem muksi ä éetua? Tühuata inou yáala ïri jámmut. ");
INSERT INTO mfy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jume póobem jibem enchimmak jípunake, éntok ínel éätekem ára tühuata ámeu yauhua; të nechem kaa jíba im jípunake. ");
INSERT INTO mfy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ïri jámmut ára ä joäu inou yáuhuak, bueïtuk au bamijtuaka juka ili bäata takahuat ínot töak ín mäánä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tua lútüriapone enchimeu ínel jiaahua, kial jak júne íkäi evangeliota nokhuäpo, sïme ániachi, íkäi jámutta yáakäu ket noktúnake au huáatinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Huanäi Judas Iscariote, jume dóocemmak näikiatukähui, jume sacerdotem chë áma nésauhuemmeu siika, Jesústa bem mampo toij báreka. ");
INSERT INTO mfy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Huanäi bempo ä jíkkajakä tüisi al‑lëiak, éntokim tómita ä makrókakä taahuak. Huanäi Judas jachin Jesústa bem mampo ä tóijnakeu jaríai. ");
INSERT INTO mfy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Huanäi jume páanim kaa lévadurakame buähuä taahuarim naatëpo, kabáram súahuakä pajkota béchïbo, jume ä discíipulom ínel au jiaahua: —¿Jákusë itom ä tütëïa pajkóata em buänakepo? ");
INSERT INTO mfy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Huanäi guoyim ä discíipulom áman jaasek ínel ámeu jíaka: —Ämanem kaate huam puéblohui. Enchim nankínake jü yoreme bäam bächiapo huériaka. Akem ä guojáanake. ");
INSERT INTO mfy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ä kibákekäpo jóakamtauem ínel jiáunake: “Jü Maestro ínel jiaahua: ¿Jákusu káttek jü kari áma yore mamábethuame, pajkóata áma ín buanakëhui ín discíipulommaki?” ");
INSERT INTO mfy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Huanäi Áapo enchim ä téjhuanake juka buëuru kárit jikachi béja tüteta. Huämïrem ito béchïbo juka buähuamta yáanake. ");
INSERT INTO mfy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Huanäi ä discíipulom buere joaräu yájaka. Bem ä téjhuahuaka páman sïmeta téuhuak. Huanärim paskuata béchïbo ä tütek. ");
INSERT INTO mfy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huäri kúpteyo, tukáriu yumái áman siikä jume dócemmaki. ");
INSERT INTO mfy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Huanäi mesáu jokä am jïbuäi, Jesús ínel jiaahua: —Tua lútüriapone enchimeu ínel jiaahua, huépülakä enchim násuk ínomak jïbuäme kaa nee huatíame mampone toijnake. ");
INSERT INTO mfy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Huanäi bempo siróktaitek, éntokim sïmetaka huepülaka júnelim nau jiaahua: —¿Ínapo ájäria jäni? Éntok jü täbuika kétchi: —¿Ínapo ájäria jäni? ");
INSERT INTO mfy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Huanäi Jesús ínel jiaahua: —Jüri ájäria jü huépülaka enchim dóocem násuku puraatopo ínomak páanim kómoniame. ");
INSERT INTO mfy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tua lútüriapo, ä böot huéiye jü Yoremta Üusi, ä bétana jïojteripo bénasi, të ¡jiokot hua yoreme ä bejreme mampo ä tojame juka Yoremta Üusi! Türi eiyei huäri yoremta béchïbo jahuéi júne kaa yeu tómteko. ");
INSERT INTO mfy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Huanäi bempörim jïbuäi, Jesús jume páanim nüka, Diosta tü eäu ámet chúpaka am rébektiak, éntok am miíkak ínel jíaka: —Akem am buäye; ïri jü ín takahua. ");
INSERT INTO mfy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Juka vásota nükä éntok Diostau buanaka, ket am miíkak, huanäi sïmetakam áma ä jëka. ");
INSERT INTO mfy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Huanäi ínel ámeu jiaahua: —Ïri jü ín ojbo, juka bemela nokta itom nau lútüria yáari útteata máknakeme, éntok bürum béchïbo guötinakeme. ");
INSERT INTO mfy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tua lútüriapone ínel enchimeu jiaahua, kanne júchi íkäi páras bähuata jïnake júnak jübua bemélasi áman hua taahuarit Diosta rey nésahuepo anëteko. ");
INSERT INTO mfy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Huanärim huepul buikim buiksuka, Oliivo káuhuiu bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Huanäi Jesús ínel ámeu jiaahua: —Sïmetakem inoi májhueka nee töteénninake én tukáapo, bueïtuk ínel jïojteri: “Kabyerótane kökosi yáanake, huanäi jume kabáram chíbejtinake.” ");
INSERT INTO mfy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Të chúkula béja jíabitekne enchímpat huéenake buiära Galiléau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Huanäi jü Peero ínel au jiaahua: —Éläposu sïmetaka emoi majhuë, të ínapo ëe. ");
INSERT INTO mfy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Huanäi Jesús ínel au jiaahua: —Tua lútüriapone ínel emou jiaahua, émpë, én tukáapo, totorörata kee guosa kuséi, baisë kaa nee emo täya tíanake. ");
INSERT INTO mfy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Të áapo chë júne jiaahuay ínel jíaka: —Émomak júnene ket muknake, tëne kaíbu kaa enchi ino täya tíanake. Sïme ket ánëli jíba jiaahuay. ");
INSERT INTO mfy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Huanärim huerto Getsemaníu ti tehuakähui yájaka, Jesús ä discíipulommeu ínel jiaahua: —Ímirem joye huäm Diostau ín oraciompo nokäu tajti. ");
INSERT INTO mfy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Huanäi juka Perota, éntok Jacobota, éntok Juanta núnuka, yam núk siika, huanäi tüisi sirókaka ä jiápsipo kökosi eetaitek, ");
INSERT INTO mfy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","éntok ínel ámeu jiaahua: —Tepa tüisi sirokä jü ín jíapsi. Béjane mukém cheiya. Ímirem nee boobíchaïhui. Katem kókoche. ");
INSERT INTO mfy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Huanäi huam jëla sika, buíau tajti mülaa chatuka Diostau oraciompo nookak: Ínel éätek huákäi orata kaa au ä yumátua sáhueka, ");
INSERT INTO mfy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ä oraciompo ínel jíaka: —Abba, ín Átchay, sïme jita júne kaa obíachi emo béchïbo. Katë nee ä jitua juka jiokot emo bit huapo vásota; të kaa ínel ín éä béchïbo, ál‑la em ä türë pámanë ä yauhua. ");
INSERT INTO mfy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Huanäi discíipulommeu yepsaka, kócheme téuhuak. Perotau entok ínel jiaahua: —Simmom, ¿jáchë kotche? ¿Jáchë senu oram júne kara kotcheka aane? ");
INSERT INTO mfy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Katem kókoche, éntokem oraciompo Diostau nooka juëna éerita kaa enchímet ayúnakë béchïbo. Jü jíapsi lútüriapo óusi éä jiöbe, të jü takahua kaa útteak. ");
INSERT INTO mfy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huanäi júchi áman nótteka, Diostau oraciompo nookak, huakäi jíba nokaka. ");
INSERT INTO mfy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Huanäi nótteka, júchi kócheme téuhuak, bueïtuk yetem útteakä ámet huéchilatukai. Huanärim kaachin ä yommia máchiakai. ");
INSERT INTO mfy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Huanäi bájikun júchi nótteka, ínel ámeu jiaahua: —Kóchëem én ál‑la, éntokem jimyore. Béja, jü ora yúmala. Ímï, jü Yoremta Üusi jume Diosta bejreme mampo toijna. ");
INSERT INTO mfy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jáptëem, jántebu: hua nee nénkakame äbo jëla huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ketune ä nokaisu Judas áma yépsak, jume dóocemmak näikiatukaïhui. Juebena gente éntok áamak kaatei esparaka éntok kúkutaka. Ímëi jume juebena gente éntok áamak kaatei esparaka entok kúkutaka. Ímëi tiöpopo nésauhueme bétana kaatei, éntok escribam bétana, éntok jume yoiyöturim bétana. ");
INSERT INTO mfy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Huä ä nénkinakeme éntok séñata am máklatukai ínel jíaka: —Huä ín besíitonakëhui, huäri ájäria; akem buíseka, kuttílasi ä huéria. ");
INSERT INTO mfy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Huanäi Judas áma yepsaka, au rúkteka ínel au jiaahua: —Maestro, Maestro. Huanäi ä besíitok. ");
INSERT INTO mfy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Huanäi bempo at jaateka ä peréesotek. ");
INSERT INTO mfy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Senu éntok áma aneme ejparam yeu huíkeka juka tiöpopo chë nésauhuemta sauleero nakä chukti mámäkok. ");
INSERT INTO mfy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Huanäi Jesús gentetau ínel ámeu jiaahua: —¿Ékbualata buij báaremta bénasem esparakä éntok kúkutaka yeu sákala nee buij báreka? ");
INSERT INTO mfy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chikti táapone enchimmak aaney jum tiöpopo enchim majtíaka, tem kaa nee peréesotek. Të ïri ínëlituk juka Diosta noki jïojteri chúpnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Huanäi sïme jume discíipulom Jesústam töténnek. ");
INSERT INTO mfy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Të senu jübua yötume ä guojáasek kia sábanampo au bïtialataka, huate áma aneme éntok ä buíssek; ");
INSERT INTO mfy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","të áapo au yeu huíkeka sábanam ámeu töbúitek. Huanäi kaa sánkokä búitek. ");
INSERT INTO mfy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Huanärim Jesústa hua sacerdote tékilta buéresi nésahuemta mampo ä tojjak. Huanäi jume sacerdosio tékilpo chë nesahueme, jume yoiyöturim, éntok jume escribam emom nau tojjak. ");
INSERT INTO mfy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peero éntok mékkäriat ä guojáasei huam sacerdote tékilpo buéresi chë nésahuemta tebat huaijhua tajti. Huanäi tájimmeu kátekai súkkähueka jume porisimmaki. ");
INSERT INTO mfy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jume sacerdote tékilpo buéresi chë nésauhueme éntok sïme jü concilio yäura; nokta Jesústa ä bej‑reka huemta ä kobnákemtam jariai, ä mëtebo béchïbo; tem kara ä teuhuai. ");
INSERT INTO mfy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bueïtuk juebenakä ä béjreka aranókïchiata nookai, të hua bem nokihua kaa nánancha hueiyei. ");
INSERT INTO mfy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Huanäi huate jápteka, aranókïchiata áatana nookak ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ítapote ä jkíkkaijla ínel jiamta: “Íkäine tiöpota mámammea yáata tátabnake, éntok baij taahuata hueine täbuik yáanake kaa mámammeyi yáata.” ");
INSERT INTO mfy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Të kia junëli júne jíba kaa nánancha chätui jü nooki. ");
INSERT INTO mfy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Huanäi jü sacerdosio tékilpo chë nésauhueme áme násuk kíkteka, Jesústa temajek: —¿Jachin júne kaa am yommia? ¿Jítasu ímëi émo bétana nooka? ");
INSERT INTO mfy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Të Áapo jíba kaa jíaleka. Kaa am yommiak. Huanäi jü sacerdosio tékilpo chë nésauhueme júchi ä temajek: —¿Jache empo jü Diosta yeu púari Cristo titéhuaakame, jü chë Yörihuamta Üusi? ");
INSERT INTO mfy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Huanäi Jesús ínel au jiaahua: —Ínapone ájäria. Akem ä bínnake huaka Yoremta Üusi Dios tua útteakamta bata bétana kátekamta, éntok namupo äbo huemta téhueka bétana. ");
INSERT INTO mfy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Huanäi jü sacerdosio tékilpo chë nésauhueme ä supem siutiaka ínel jiaahua: —¿Jítasu éntokte at boobinnake ä bejreme nokame jariaka? ");
INSERT INTO mfy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Akem ä jikkaijsuk juka juena nokta Diosta bej-reka ä nokakähui, ¿jachisem ä bitcha? Huanäi sïmetakam bettek at nonokak, ä türinake tiaka ä mëna béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Huanäi huate at chit huatti taitek entokim ä puj summaka ä chonnay, ínel au jiaka: —¡Diosta bétane nooka jabeta enchi chonähui! Jume alguacilim entok jopemmet ä chonnai. ");
INSERT INTO mfy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Perota tebatpo bétuk ä aaneyo, jü jamut sumo sacerdoteta, tékil nésauta joriame áma yepsak. ");
INSERT INTO mfy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Huanäi Perota sukkahuemta bíchaka ínel jiaahua: —Empo ket Jesús Nazarenotamak aaney. ");
INSERT INTO mfy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Të Peero kaa ä lútüria tíiya ínel jiaka: —Kanne ä täya, éntokne kaa jüneiya jita em nokähui. Huanäi pakun bíchaa yeu sika, totoröra entok kukusuk. ");
INSERT INTO mfy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jü áma saihuame entok júchi ä bíchaka, jume áma aanemmeu ínel jiautáitek: —Ïri ámemak joome. ");
INSERT INTO mfy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Të áapo júchi kaa ä lútüria tíiya, të chúkula jume áma anëihui júchim Perotau ínel jiaahuay: —Tua lútüriapo empo am jáläek, bueïtuk empo Galileo; em nokaü entok bem nokaü benna. ");
INSERT INTO mfy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Huanäi juënasi jiautáitek, ä nokihua bat kechaka kaa ä lútüria tiaka: —Kannä täya íkäi yoremta enchim áa bétana nokähui. ");
INSERT INTO mfy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Huanäi jü totoröra júchi kúkusuk. Huanäi Peero juka Jesústa au nokákäubeu huahuáatek ínel au ä jíakäubehui: “Kee jee juka totorörata guosa kúseyo, baisë kaa nee emo täya tíanake.” Huanäi jünéaka, kaa at al‑lëakä tüisi buaanak. ");
INSERT INTO mfy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yeu mátchuk jíbba, jume tiöpopo chë nésauhueme, yoiyöturimmaki, escibammaki, éntok jü concilio, sïme nau rúktek nokta nau tüte báreka. Huanärim Jesústa súmaka, Pilátota mámpo ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Huanäi Pilato ä temajek: —¿Empo ínel jü judíomeu rey? Áapo éntok ínel ä yommiak: —Jéehui, em jiä bénasi. ");
INSERT INTO mfy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jume tiöpopo chë nésauhueme éntok juebenak bétanam ä nätuai. ");
INSERT INTO mfy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jü Pilato entok júchi ä temajek: —¿Jachin júnë kaa am yommia? Jita chikti bétanam enchi nätua. ");
INSERT INTO mfy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Të Jesús jíba kaa ä yommiak. Jü Pilato éntok at guómtek kaa ä jíalekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jü Pilato pajko táapo jíba huépul perésota butbúttiai, kia jábeta junne bem aahuähui. ");
INSERT INTO mfy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Senu áma aaney Barrabás ti tehuaka, perésotakä ä jáläimmaki; yäurata béj‑reka emo tóboktiahuakäpo yore súalataka. ");
INSERT INTO mfy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huanäi jü gente juebénaka Pilátotau kimuka, au nookak jíba bénasi huaka ámeu ä jojóäu ä yáasáuhueka. ");
INSERT INTO mfy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Huanäi jü Pilato ínel ámeu jiaahua: —¿Huaka judíomeu réytem búttia ïa? ");
INSERT INTO mfy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bueïtuk jüneiyai jume tiöpopo chë nésauhueme kia huaka buéresi jita ä jóäu at ínnëaka au ä tóijtukäihui. ");
INSERT INTO mfy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Të jume tiöpopo chë nésauhueme juka juebena genteta nok téjhuak chë ä türinake tíakä huaka Barrabásta ä búttiana béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Huanäi jü Pilato júchi am temajek: —¿Jítasem júntuk nee au yáa ïa hua judíomeu réïpo enchim täyäbehui? ");
INSERT INTO mfy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Huanäi bempo juchéntok chaitáitek ínel jíaka: —¡Kúrusichë ä popóntebo! ");
INSERT INTO mfy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Të jü Pilato ínel ámeu jiaahua: —¿Jita juënaksu júntuk yáala? Bempo éntok chë júne chaayey ínel jíaka: —¡Kúrusichë ä popóntebo! ");
INSERT INTO mfy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Huanäi jü Pilato huakä genteta al‑leetua báreka, Barrabásta yeu béebak; Jesústa éntok bemmúchateboka, bem mámpo ä tójjak kúrusit ä popónnä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Huanäi jume sontaarom áman huaijhua paláciopo ä tójjak, pretoriopo; huanärim sïme huate sontarom nau núnnuk. ");
INSERT INTO mfy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Huämïrim lilata ä sánkotuak, éntokim huíchata huíköpäaka ä corona yáaka, kóbat áachä yétchak. ");
INSERT INTO mfy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Huanärim éntok ä tetébotuataitek ínel jíaka: —¡Jíbë jíapsinake judíomeu rey! ");
INSERT INTO mfy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Éntokim bakai kóbachä bebbai. Achim chithuathuattei, éntokim tónommia jápteka au mujtei. ");
INSERT INTO mfy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Huanärim tüisi ä junnériasuka éntok lila sánkota ä úhuaaka, ä sánkohua ä sánkotuak. Huanärim yeu ä núk sájjak kúrusit ä popómboka. ");
INSERT INTO mfy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Huanärim senú yoremta huasá bétana huemta, Simmom Cireneu joometa, Alejándro éntok Rúfota atchai, jukarim kúrusta püaktituak ä huériunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Huanärim Jesústa Gólgota tï tehuakäu bíchaa núk sájjak, itom nokpo Mukila koba kauhui ti jiaubáare. ");
INSERT INTO mfy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huanärim vinota mirrámak nau kuutíata ä jïtua báarei, të Áapo kaa ä jëka. ");
INSERT INTO mfy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Huanärim huämi kúrusit ä popónsuka, ä sánkohuam näikimtek nat ä sortiároaka, jábesu ä átteanake jäni tï jiaka. ");
INSERT INTO mfy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Huanäi kúrusit ä ponhuái béja bátanim jiaahuay kethuéitana. ");
INSERT INTO mfy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Huä nooki kúrusit jïojtetukähui jita béchïbo ínel ä yáahuakähui, ínel jiaahuay: “Ïri jü judíomeu Rey.” ");
INSERT INTO mfy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Guóyika éntok ékbualatakä ket áa beu kúrusit popónhuak, seenu ä batatana, senu éntok ä míkkötana bétana. ");
INSERT INTO mfy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Huämi chúppuk hua jïojteri ínel jíame: “Éntok jume juëna yórememmak naïkiatuk.” ");
INSERT INTO mfy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Huanäi jume áma huam kateme ä junneriai koba huíuteka entok ínel jíaka: —Jajáa, empo Diosta tiöpo tátabeka éntok baij táapo júchi ä yéchanakeme, ");
INSERT INTO mfy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","émoë jínëuka. Kúrusit kóm huéiye. ");
INSERT INTO mfy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Alë bénasi jume tiöpopo chë nésauhueme ket ä junnériaka ínel nau jiaahuay jume escribammaki: —Huatem jínëuk, Áapo éntok kara au jínëu. ");
INSERT INTO mfy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jü Cristo, Israéltau au Rey tíame, éläpo ëni kúrusit kóm huéenake, huanäi të ä bichätek ä súalnake. Jume áamak kúrusit popóntukähuim éntok, kéchim ä junneriai. ");
INSERT INTO mfy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Huanäi dóocem jiai, kaa machisi taahuak sïme ániachi bájim jiäu tajti. ");
INSERT INTO mfy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Huämi bájim jiai, Jesús tüisi kusisi cháchayek ínel jíaka: —Eloí, Eloí, ¿lama sabaktani? —itom nokpo ínel jiaubáare: In Dios, In Dios, ¿jatchíakasë nee ínapola toijla? ");
INSERT INTO mfy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Huate áma aneme éntok ä jikkajaka, ínëlim jiaahuay: —Jó, Elíastau chaaye. ");
INSERT INTO mfy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Huanäi senu áman búiteka, juka espónjata vinágrepo kómoniak, éntok bakat ä óreka ä jïtuak ínel jíaka: —Boobíchäem, átä bínnake juka Elíasta jachu au yepsakä kömä yéchanake jäni. ");
INSERT INTO mfy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Të Jesús tüisi kusisi chachayeka muúkuk. ");
INSERT INTO mfy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huanäi jü cortina tiöpopo órekau násuk áman síutek, jikat naateka kóm tajti. ");
INSERT INTO mfy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Huanäi jü capitán romapo joome Jesústa pújbapo huekäihui, kusisi chachayeka ä mukuk bíchaka, ínel jiaahuak: —Lútüriapo ï yoreme ájäriatukai jü Diosta Üusi. ");
INSERT INTO mfy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jaamuchim éntok ket mékkäriat aneka ä bitchai. Ímëi násuk aaney jü María Magdalena, entok María Jacobo jü chë ilitchi, Salomé, éntok Joseta áiye. ");
INSERT INTO mfy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ímëi jáamuchim Jesústa jum Galiléa buiärapo ketune anéi áamakim rejtei, éntokim nésauta ä joríai. Éntok huate jáamuchim ket juebenakä áamak buere joära Jerusaléniu jikau sájakäu áma aaney. ");
INSERT INTO mfy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Huäri taahuarit tukariu yúmako, sïmeta tüisi toijbárekam obisi aaney, bueïtuk jimyore taahuari yokoriapo yúmasey. ");
INSERT INTO mfy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kíalïku José, pueblo Arimateapo joome, yäuraapo tékiakame tüisi täyahuakä éntok yörihuame. Ket huaka Diosta reytaka nésahueu boobíchaïhui, áma yepsaka, kaa májhueka Pilátotau kibákek; huanäi Jesústa takahua aahuak. ");
INSERT INTO mfy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato at guómtek Jesústa lauti mukuk tïaka. Të juka capitanta núnuka, ä temajek ä múksuka bétana. ");
INSERT INTO mfy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Capitanta ä téjhuak jíbba, huanäi Joseta mámpo ä tójjak juka Jesústa takahua. ");
INSERT INTO mfy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Huanäi José sábanam jínnuka, kömä yéchaka, áma ä bïtiak. Huanäi sépultuura, téta buéjtukaïpo, ä teekak. Tétata éntok sépultuura puertau bíaktiakä ä páttiak. ");
INSERT INTO mfy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, éntok María Joseta áiye, akim ä bitchai jak ä tekhuakähui. ");
INSERT INTO mfy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juka jimyore taahuata simsuk, María Magdalena, Salomé, éntok María Jacobota áiye, juka musäla jubakim jínnuk Jesústa takahuat ä óre báreka. ");
INSERT INTO mfy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Huanäi kethuéitana, lominko táapom jum sépulturau yájjak, béja täata yeu simsúlatuko. ");
INSERT INTO mfy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Huanärim nau ínel jiaahuay: —¿Jábesu juka téta sépultuurata puértapo kátekamta itom mékka bíaktirianake jäni? ");
INSERT INTO mfy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Huanärim áman remteka juka tétata mékka bíaktiata bitchak; jü teta éntok tüisi buëuruakai. ");
INSERT INTO mfy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Huanärim sépulturapo kimuka, senu yoremta jübua yötumta batatana bétana áma kátekamta bitchak, tósalik tebek sánkokamta; huanärim guómtek. ");
INSERT INTO mfy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Të áapo ínel ámeu juahua: —Katem majhuë. Jesús Nasarénotem jaría, huaka kúrusit popónhuakamta. Béja jíabitela; kaa imï aane. Akem ä bitcha im ä tekhuákaïpo. ");
INSERT INTO mfy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ámanem sájakä juka Perota téjhua, éntok jume huate ä discíipulom. Ínelem ámeu jiaahua: “Áapo enchímpat huéiye áman pueblo Galiléau bíchaa; huämïrem ä bínnake, enchimeu ä jíakäpo bénasi.” ");
INSERT INTO mfy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Huanäi bempo jum sépultuurapo yeu sájakä teénnek, mauj‑rimmei emo yoáka. Tem kaabetau jíalek, guómtilataka. ");
INSERT INTO mfy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús éntok jü lominko táapo kethuéitana jíabitelataka, María Magdalénatau bat yeu machiak, iachï éntok guoibusan lemoniom yeu béblatukai. ");
INSERT INTO mfy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Áapo éntok sika huame áamak anlatukammeu jünéehuamta am makkak; huámëi éntok sirókakä éntok buanaka áma aaney. ");
INSERT INTO mfy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Të bempo ä jíabitelatukäu jíkkajakä, éntok áapörik au ä bil‑la tíau júnem kaa ä súalei. ");
INSERT INTO mfy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chúkula, täbuiasi guoyímmeu au yeu machíriak, huaj páman am kateyo, sékäna pueblou bíchaa. ");
INSERT INTO mfy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Huanäi huámëi ket áman sájaka jume huaatem tejhuak; të bempörim júne kaa súsualek. ");
INSERT INTO mfy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chúkula béja óncemmeu, au yeu machíriak mesáu jokammehui. Huanäi kuttílasi ámeu nokak bem kaíta súalë béchïbo, éntok námakak bem jiápsekä béchïbo. Bueïtukim kaa am súaley huame ä jíabitelatukäu ä bíchakame. ");
INSERT INTO mfy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huanäi ínel ámeu jiaahua: —Sïme ániachem kaate, éntok íkäi evangeliotem ámeu noknake sïme géntemmehui. ");
INSERT INTO mfy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Huä ä súalekame éntok au batötebokame jínëutunake. Huä kaa ä súalekame éntok jiokot machisi noki at chúpatunake. ");
INSERT INTO mfy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Éntok ímëi séñalim huérianake huame ä súaleme: In téhua úttearammeay lemoniom yeu bébnake; éntokim bemela nokta noknake; ");
INSERT INTO mfy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bakóchimim mámammea buijnake; éntokim óijta jëk júnem kachin ayunake; jume kökoreme béppa mámtekim am tütenake. ");
INSERT INTO mfy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Huanäi jü Señor junëli ámeu noksuka, áman téhuekapo jikat mabethuak, éntok Diosta bata bétana yéjtek. ");
INSERT INTO mfy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huanäi bempo yeu sájaka, juka tü nokta nookak sïmekuchi. Jü Señor éntok am aníai juka nokta lútüria jóakä huame señáalim bem joaïbeyi. Júnentunake.");
INSERT INTO mfy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Juebénaka éaka áu kikkimusula tua lútula ä jïojte báreka juka ímï ito násuk tua yö lútüriapo yeu sikamta, ");
INSERT INTO mfy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","jume kësampo naateka bem pusimmea ä bíchakame jume itom ä majtiakame, éntokim ä tekipanuay íkä Diosta nooki. ");
INSERT INTO mfy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ínapo éntok chúkula béja át nátemaijsuka jáchin ä naatekähui éntok sïmekut tüisi suasuka, kétne émou ä jïojte báreka taahuak ä huëpo bénasi, empo Teófilo huatem násuk yörihuame, ");
INSERT INTO mfy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","em ä täyanakë béchïbo huaka em majtiahuakähui ä lútüriatukähui. ");
INSERT INTO mfy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Juka Heroodesta Judeapo reytuko, senu sacerdote Zacarías ti téhuaaka tiöpopo tékiakay, Abíasta géntepo jometukay. Ä jubi éntok Arónta familiapo jometukay, éntok Elisabet ti téhuaakay. ");
INSERT INTO mfy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Náhuichikam lútula jiápsay Diosta bíchäpo, éntok kaita juënasi jita áme bétana nokhuay, bueïtukim Señorta nésauri johuay. ");
INSERT INTO mfy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Të katim üusekay, bueïtuk Elisabet kaa äasoay, éntokim, béja yoiyötukay. ");
INSERT INTO mfy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sejtul táapo, sacerdoote tékil huë páman Zacaríasta tiöpopo Diosta bíchäpo jita ä joaysu, ä tékiakä pámani, ä yoiyöturim ä huériapo bénasi, ");
INSERT INTO mfy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","jume tiöpopo tékiakame ä huéria pámani, Zacarías áma yuktiahuak, juka inciensota ä táanakë béchïbo, Señorta altariu huáijhua kibakeka. ");
INSERT INTO mfy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Huanäi sïme jü pueblo päku aneka Diostau oraciompo nokay, inciensota táahuayo. ");
INSERT INTO mfy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Huanäi Diosta ángel Zacariastau yeu machiak, incienso altarta bátam bétana hueka. ");
INSERT INTO mfy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Huanäi, Zacarías ä bíchaka guómtek, éntok kaachin an máchika majhuëy. ");
INSERT INTO mfy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Të jü ángel ínel áu jiaahua: —Zacarías, katë májhue, jü em nétanëu Dios enchi jíkkajak. Jü em jubi Elisabet ili outa asoanake. Juan të ä téhuaatuanake. ");
INSERT INTO mfy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Huanäi tüisi al‑leehuame émou ayunake, éntok juebénaka al‑leaka tahuanake yehuä tómtekä béchïbo, ");
INSERT INTO mfy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bueïtuk jü em üusi yörisi jíputunake Diosta bíchäpo. Vinota o jita ái nanaa kóhuamta kaa ä jïnake, éntok kee yeu yoreka Espíritu Santoy tápunitunake. ");
INSERT INTO mfy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Juebena Israelitam Dios Señortau bíchaa am jíapsi kúaktianake. ");
INSERT INTO mfy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Huäri Espíritu úttiära Elías profeetatat aneï bénasi áamak annake, huäri úttiäray Señortapat huéenake, jume áchayhuarim bem üusimmeu bíchaa kaa béttek jíapsitam jípunakë béchïbo, éntok huame kaabeta yöreme jábetam yörinakë béchïbo. Júnëli béja jume Señortau rúktinakeme tüisi majtianake tülisi Señorta am mabetnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías ínel áu jiaahua jü ángeltahui: —¿Jáchisune íkäi jüneríanake? Bueïtukne öla, éntok ín jubi júne jámyöla. ");
INSERT INTO mfy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ä yómmiaka ínel áu jiaahua jü ángel: —Ínapone Gabriel, Diosta bíchäpo aneme. Äbone bíttuari íkäi bemela nokta enchi téjhua sáyhuaka. ");
INSERT INTO mfy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Enë kara noknake, éntoke múurotaka tahuanake, íkäi ínel yeu simëu núkisi, kía juka ín émou noki kaa em súalekä béchïbo. Ïri sïme lútüriataka yeu huéenake, taahuata yúmako. ");
INSERT INTO mfy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Huä génte éntok Zacaríasta boobíchaïhuiy, éntok emom temajey huaijhua tiopopo ä bínhuatü béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Të Zacarías päkun yeu sika béja kara ámeu nokaka taahuak. Huanärim béja jünëiak jita áu yeu machiakähui jum santuariopo, áapo éntok séñampo ámeu nookay, junëli béja múurotaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Huanäi juka ä tékia áma yáasuka, jume taahuarim yúmariasuka, béja ä jóau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chúkula huame taahuarim simsuko, béja ä jubiahua Elisabet abe asoaka yeu siika. Huanäi ä jóapo kaa yeu siika, mamni metpo, ínël jíakari: ");
INSERT INTO mfy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Íkäi inou yáuhuak, jü Señor ímëi taahuarim huëpo, béja nee ä úhuak, juka tiusi máchiraata sïmem bíchä násuku.” ");
INSERT INTO mfy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Búsan mecham huéeyo, jü ángel Gabriel áman bíttuahuak Diosta bétana, Galiléa buere joärahui Nazaret ti téhuakähui, ");
INSERT INTO mfy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","jámut bemetahui. Huäri éntok áuritukay, ili yoreme jübua yötume ä jubisey, José ti téhuaakame. Davidta familiampo jometukay. Jü jámut beeme éntok María ti téhuaakay. ");
INSERT INTO mfy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Huanäi ä anëpo kibakeka, ínel áu jiaahua jü ángel: —¡Dios enchi ania al‑leäe! Señor émomaki. Áapo tühuata emo bétana näikiala sïme jáamuchim násuku. ");
INSERT INTO mfy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Të áapo ángelta bíchaka, kaachin an máchika taahuak, juka ä nokakä béchïbo. Huanäi ínel éiyay: —¿Jíta teboterisa jäni ïri? ");
INSERT INTO mfy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Huanäi jü ángel ínel áu jiaahua: —María, katë májhue. Diosta tü eähue jájamla. ");
INSERT INTO mfy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Én éntok abe asoake tahuanake. Usi outë asoanake, éntok JESÚS të ä téhuaatuanake. ");
INSERT INTO mfy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ïri buéresi ériana. Jikat bétana usiari ti téhuaana, jü Dios Señor éntok juka ä átchay David Rey nésauri ä máknake. ");
INSERT INTO mfy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Huanäi Jacobtamak huéerimmak reytaka nésaunake jíba béchïbo. Huä ä reytaka ä nésahueu éntok kaa lütinake. ");
INSERT INTO mfy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Huanäi María ínel áu jiaahua jü ángeltahui: —¿Jáchisu éntok ïri huéenake, bueïtuk ínapo kennee kuuna? ");
INSERT INTO mfy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Huanäi jü ángel ä yómmiaka ínel áu jiaahua: —Jü Espíritu Santo emo béppatunake. Huanäi jü jikat anemta úttiära ä jékkay enchi jékkatuanake. Huäri béchïbo jü santo ili usi yeu yoremtunakeme, Diosta Üusi ti téhuaana. ");
INSERT INTO mfy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Éntok két jü em huahuaji Elisabet, áapo két abe asoaka tahuala, ä jámyölatukä násuku, én béja búsan meecha, abe asoakari, jü kara asoame ti täyahuame, ");
INSERT INTO mfy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","bueïtuk Diosta béchïbo kaita obiachisi maachi. ");
INSERT INTO mfy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Huanäi béja María ínel jiaahua: —Ímïne aane, Señorta nésau yáa báreka. Éläpo inot chúpatunake jü enchi inou nokakähui. Huanäi béja jü ángel ä tö siika. ");
INSERT INTO mfy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Huámechi taahuarimmet María bamsipo yeu siika, buere joära Judeau bíchaa; ïri pueblo júya káhui násuk taahuay. ");
INSERT INTO mfy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Huanäi Zacaríasta jóau kibakeka, Elisabetta tebotuak. ");
INSERT INTO mfy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Huanäi jü Elisabet Maríata teboteri jíjikkajaka, jü ili usi tómpo chéptek. Huanäi éntok Elisabet Espíritu Santoy tápunak, ");
INSERT INTO mfy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","éntok tüisi kusisi ínel jiaahua: —Diosta tü eäu emo bétana näikiari sïme jáamuchim násuku, éntok ä tü eäu tápuni jü em tómpo yoremtulame. ");
INSERT INTO mfy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Jatchiakasu ínapo áma yeu púari, juka ín Señorta áye nee äbo bínnakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bueïtukne em teboteri jíahuia im nakammeu yúmako, ili usi al-lerimmea ín tómpo chéptek. ");
INSERT INTO mfy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Úttesi al‑leehuamta jípunake jü ä súsualekame, bueïtuk lútüriataka yeu huéenake juka Señorta bétana émou nokakähui. ");
INSERT INTO mfy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Huanäi María ínel jiaahuak: In jíapsi buéresi Señorta úttile. ");
INSERT INTO mfy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","In espíritu éntok al‑leiya, Dios ín jínëulerotachi. ");
INSERT INTO mfy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bueïtuk kaita nee béj-riay junne, nee yeu púuhuak, áapörik nésau jíba joamta, éntok, én naatekam Diosta tü eäu nee jájamlä tíanake sïme nat tomti kateme. ");
INSERT INTO mfy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bueïtuk jü Dios jita jo árahueme buere tühuata inou yáuhuak. Santomme, jume ä téhuam. ");
INSERT INTO mfy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diosta yore nak jiokolëu jíba sïme nat tomti kateme béchïbo. Jume ä majhuëka ä yöreme. ");
INSERT INTO mfy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ä mámammea yún jita bueere yáala, am chíbejtiak jume bem jiápsipo kaa tü eerim emo buérialeka aneme. ");
INSERT INTO mfy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jume úúttiakame reyta yeyesäpo yeu am jaasek; éntok jume bétuk emo nüyeme éntok jikau tóboktiak. ");
INSERT INTO mfy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Huame tébäureme buéresi tühuata miikak; huame rikom éntok kaita am makaka am sákatuak. ");
INSERT INTO mfy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Juka nación Israelta ä nésahui joamta aniak, yore ä nak jiokolibeu kaa koptiaka ä jiokorek. ");
INSERT INTO mfy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Júkäi ámeu nookak, itom yoiyöhuammehui, Abrahamtamaki, éntok jume ä üusimmaki, jíbapo béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Huanäi María báij metpo jäni Elisabetamak taahuak. Chúkula béja ä jóau nóttek. ");
INSERT INTO mfy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jü Elisabet jume taahuarim yúmariasuka, outa asoak. ");
INSERT INTO mfy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Diosta jüneli ä nak jiokoleka béchïbo. Huanäi jume áa chíkola jóakame éntok jume ä huahuayriam ámanim ä bitchak. Huanärim úttesi al‑leakam taahuak, Diosta junëli ä jiokorekäu béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Guoj naiki taahuarim yúmak, ä circuncidaroatebok, juka ili usita. Huanärim ä átchay téhuam, Zacaríasim, ä téhuaatua báarey. ");
INSERT INTO mfy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Të jü ä áyehua ínel ámeu jiaahua: —Ëe; Juan ti téhuaanake. ");
INSERT INTO mfy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Huanärim ínel áu jiaahuak: —¿Jatchiaka? Kaabe junëli téhuak enchim huahuayrim násuku. ");
INSERT INTO mfy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Huanärim séñampo juka ä áchaytau nátemajek, jáchin juka ili usita ä téhuaatua bárëhui. ");
INSERT INTO mfy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Huanäi ili tablata aahuaka, ínel át jïojtek: “Juan ti téhuak.” Huanäi sïmetaka át guómtilataka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Senu huéchiapo áu étapok jü teeni. Júchi ára nokaka taahuak, éntok Diosta úttil táytek. ");
INSERT INTO mfy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Huanäi sïme jume áme chíkola jóakame át guómteka taahuak. Sïme jume Judea buiärapo káu jómem, íäri bétanam jíba nookay. ");
INSERT INTO mfy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sïme ä jíkkajakame bem jiápsipo ä ëriasakay, ínel jíakari: —¿Jábesa jäni ïri uusi? Señorta mámam éntok jíba áamak aaney. ");
INSERT INTO mfy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huanäi Zacarías, ä áchayhua, Espíritu Santoy tápunika, Diosta bétana nookak, ínel jíakari: ");
INSERT INTO mfy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Úttesi türi jü Senor, jü pueblo Israelta Dios. Ä pueblou yebij‑la, ä jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Itom jínëunakemta tua úttiakamta itom násuk toboktiak, jukä nésauta ä yáarialamta Davidta familiapo. ");
INSERT INTO mfy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jume santo profeetam tenimmeyi nokakä bénasi, jume kësamriapo kateme: ");
INSERT INTO mfy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","itom omtíame násuk itom yeu jäbuak; jume kaa itom bíbit péäu mámpo itom yeu huíkkek. ");
INSERT INTO mfy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Juka itom yoiyöhuam jiokolinake bétana ä noki kaa koptiak, éntok huaka nokta ä yechakähui, tühuata itou ä yáa rókähui. ");
INSERT INTO mfy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Abraham itom áchaymak nokta chúpala, juka itom ä mák rókähui, ");
INSERT INTO mfy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","itom omtíame násuk yeu huíktaka, kaabeta májhueka, áapörik itom jo ïau itom jonákë béchïbo, ");
INSERT INTO mfy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","santosi ito núyeka, éntok lútüla jíapsihuamta jípureka, áapörik béchïbo, itom kókkou núkisi. ");
INSERT INTO mfy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Émpë éntok, ili uusi, hua jikat anemta bétanë profeetapë täyana, bueïtukë Señortapat huéenake ä böom rútuktiasimeka. ");
INSERT INTO mfy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Éntoke ä téjhuaanake juka pueblota, jáchin ayuka ä jinëutunakë bëchïbo, Diosta bejrimmet am jiokorina béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios tüisi ä jiápsipo huáijhua naateka itom nákke, jikat bétana bemela taahuari machiriata itom miikak, ");
INSERT INTO mfy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","huame kaa machiku aneme éntok mukia jékkaapo aneme, machiria báreka, türi böou itom yeu jäbua báreka, kaa huanti jíapsihuäpo böochi. ");
INSERT INTO mfy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huä ili usi éntok yötusimey, éntok ä espírituhua úttiata nüsimey, éntok mékka ániapo jóakay Israelta pueblou áu yehuä machiriäpo tájti. ");
INSERT INTO mfy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Huamechï taahuarimmet ínel yeu siika sïme ániat rey Augusto César nésahuek sïmem áu censaruak sáuhuek. ");
INSERT INTO mfy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ïri censo bat yáahuak Cireniota Síriapo gobernadortuko. ");
INSERT INTO mfy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Huanäi sïme bem pueblom bëkatana sájjak emo censarua báreka. ");
INSERT INTO mfy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ïaribéchïbo, José Nazaret pueblo bétana Galiléa buiärapo jikau siika, Judea buiaräu bíchaa, Davidta pueblou Belén ti téhuaakähui, Davidta familiampo ä jomë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ámanim sájjak, emo censaruateboseka. Maríata juubiapo ä máktaka ä huériay, të kee ä juubey, áapo éntok abe asoay. ");
INSERT INTO mfy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bempörim áma aneysu jume taahuarim yúmariak, ä asoanakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Huanäi béja ä jípurek, juka kësam asoata, sánkompo ä bïtiak. Éntok pesebrepo animaalim jíjïbuäpo ä teekak. Bueïtuk sïme hotelim tátapuniakay. ");
INSERT INTO mfy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Huämi buiärapo két pastorim aaney, tukaapo kabaram suayaka, kaa kocheka. ");
INSERT INTO mfy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Huanäi éntok Señorta ángel ámeu yeu machiak. Jü Diosta lóoria éntok natechíkola, am machiriak. Huanärim tüisi guómtek. ");
INSERT INTO mfy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Të jü ángel ínel ámeu jiaahua: —Katem májhue, bemela tü noktane enchim téjhuaasek, úttesi al‑leehuasi maachi, sïmem béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Davidta pueblopo, enchim béchïbo yeu tómtek, ëni, jü yore jínëunakeme, jü CRISTO jü Señor. ");
INSERT INTO mfy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ímïrem át suanake, ä jüneria béchïbo: Ili usitem sánkompo bïtiata téunake, pesebrepo animaalim jíjïbuäpo bökamta. ");
INSERT INTO mfy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Huanäi ángeltamak senu huéchiapo juebena huate ángelesim, Diostamak téhuekapo aneme, áma yeu machiak, yörisi Diosta úttileka éntok ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Looria Diosta béchïbo téhuekapo! ¡Buíapo yánti jíapsihuame, entok tü eeri yoremem béchïbo! ");
INSERT INTO mfy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Huanäi jume ángelesim téhuekau bíchaa am sájjako. Jume pastorim ínel náu jiaahua: —Jánte pueblo Belénihui, ámante ä bínnake juka áma yeu sikamta, juka Señorta itou yeu machiriakähui. ");
INSERT INTO mfy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tüisim bamsipo yeu sájjak. Huanärim Maríata éntok Joséta téuhuak, éntok juka ili usita pesebrepo bökamta. ");
INSERT INTO mfy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ä bíchaka, akim ä jüneriatebok, juka ili usita bétana ámeu nokhuakähui. ");
INSERT INTO mfy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sïmetaka ä jíkkajakame áachim guómtilataka taahuak, jume pastorim ámeu nokähui. ");
INSERT INTO mfy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Të María sïmeta ä jiápsipo ëriasimey, áu huáateka. ");
INSERT INTO mfy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Huanäi jume pastorim tüisi Diosta looria úttileka entok al‑leaka nóttek sïmeta buere jita bem bíchakähui, éntok bem jíkkajakäu béchïbo, bueïtuk sïme bem téjhuaripo áman chúppuk. ");
INSERT INTO mfy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Guoj naiki taahuarim yúmako, usitam circuncidaroa báreka. Huanäi Jesús tim ä téhuaatebok. Ímëi téhuam jü ángel ä mákakay, ketune kee jee Maríata tómpo ä yoremtuyo. ");
INSERT INTO mfy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jume taahuarim yúmako, Moiséjta ä nésahuekä páman chichä machiku yeu sika türika tahuak, buere joära Jerusalénihuim ä nüpak, Señorta mámpo ä tóij báreka. ");
INSERT INTO mfy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Señorta leypo ä jïojteri bénasi: “Sïme ili ou kësampo yorekame, Santopo näikiatunake Señortau bíchaa.” ");
INSERT INTO mfy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Señortau am toij béchïbo, leyta jíä bénasi, guoy möelim o guoy guókohuim, sacrificiota béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Senu yoreme, Simeón ti téhuaaka, Jerusalémpo aaney. Ïri yoreme lútüla jiápsay, éntok Dios huáatey. Israelta jíapsi yechanäu Diosta ä jínëunakëhui boobíchaïhuiy. Espíritu Santo éntok áa béppa aaney. ");
INSERT INTO mfy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo au yeu ä machirialatukay, kee jee mukeka juka Señorta bétana yeu púata, ä pusimmea ä bínnakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jü Espíritu Santo ä innëtuak, huanäi tiöpou bíchaa sika. Ä áchayhuam ili usi Jesústa tiöpou ä nüpako, aú ä yá béchïbo juka leyta jiapámani. ");
INSERT INTO mfy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jü Simeón, juka ili usita mámpo ä nüka, Diosta baysahueka, ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Én ál‑la, ín Señor, ín simepë. Yanti nee jíapsitua, em noki jíäpámani, ");
INSERT INTO mfy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","bueïtuk ín pusim ä bitchak, juka em jínëuria. ");
INSERT INTO mfy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sïme pueblom bíchäpo, itomë ä téjhuaasuk: ");
INSERT INTO mfy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Áapo jü machiria, jume kaa Israeltamak huéerim, am machirianakë béchïbo, jü gente Israelita yorihuame. ");
INSERT INTO mfy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ä áyehua éntok José, guómtilatakam ä jíkkajay, sïmeta júkäi áa bétana nokhuayo. ");
INSERT INTO mfy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jü Simeón Diosta tu eäu am makkaka. Jü Maríata, Jesústa áyebeu, ínel jiaahuak: —Én éntok ï usi juebenam kóm tátab béchïbo, huatem éntok tóboktiä béchïbo, jume pueblo Israelpo joomem. Éntok ímï jünakiachitunake: juebénakam ä omoutenake. ");
INSERT INTO mfy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ínëli yeu huéenake: ejparam em jiápsipo naa búrujti emót kíktenake. Juebenak jita éhuil jiápsipo éehuamta yeu buíjtunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ama aaney, kétchi, senu jámmut, juka bát bíchaa ayunakemta jüneriame. Aana ti téhuaaka, Fanuelta maala, Aserta familiapo jometukay. Áapo béja tüisi jámyölatukay. Bemetaka kunak huanay guoy búsan huásuktiapo jíba amak jouhuak. ");
INSERT INTO mfy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Të béja jókoptulataka ochenta áma naiki huásuktey. Buere tiöpopo kaa yeu huéiyey, taahuarit tukaarit naa búrujti, Señorta tekipanuariaka, ayuunaka éntok oracionim joaka. ");
INSERT INTO mfy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana huämi horapo, Diosta baysahueka, jü ili usi Jesústa bétana ámeu nok táytek, sïme huame Jerusalénta jínëunakemta boobíchaïhuimmehui. ");
INSERT INTO mfy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chúkula juka Señorta leypo huémta áma yáasuka, Galiléahuim nóttek, buere joära Nazareu bíchaa. ");
INSERT INTO mfy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jü ili usi yötuy, éntok úttiata nüyey, éntok yún jita täyasimey. Diosta tü eäu éntok áamaktukay. ");
INSERT INTO mfy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jume ä áchayhuam chíkti huásuktiapom jum Jerusaléniu yayajay pajko pájcuapo an báreka. ");
INSERT INTO mfy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pájcua pajkota yúmak, bem ä boojoria bénasi, Jerusaléniu bícham sájjak. Jesús béja dooce huásuktiriam yúmariay. ");
INSERT INTO mfy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pajkota chúpuko, nottilataka am kateyo, jü usi Jesús Jerusalémpo taahuak. José éntok ä áyehua katim jüneiyay. ");
INSERT INTO mfy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Béja senu taahuapom boojouhuay, genteta násukim ä huë téiyey. Kaa ä téaka éntok, akim ä jariu táytek, bem huahuayrim éntok bem täyame násuku, ");
INSERT INTO mfy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tem kaa ä téaka, Jerusaléniu bíchaa nóttek, ä jariuboka. ");
INSERT INTO mfy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Chúkula báij taahuarim huéy, akim ä téuhuak jum tiöpopo, jume maestrom leyta yore majtíame násuk káteka, am nok jíkkajaka éntok ámeu nátemajeka. ");
INSERT INTO mfy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Huanärim sïme át guómtilataka ä jíkkajay tüisi jita ä täya tíakari, éntok tepa áma huéchiasi jíba am nok yómmiä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Huanärim ä bíchaka, át guómtek. Huanäi jü ä áyehua ínel áu jiaahuak: —In asoa, ¿jatchiakasë ínel itom yáuhuak? Ínapo, éntok em áchay, tüisite jiápsipo kökosi éaka enchi jariay. ");
INSERT INTO mfy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Huanäi áapo ínel ámeu jiaahuak: —¿Jatchiakasem nee jaria? ¿Jachem kaa jüneiya ín Átchay tékilpo ín annakëhui? ");
INSERT INTO mfy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Të bempo kaa jüneiyay jita ámeu ä nokakähui. ");
INSERT INTO mfy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Huanäi ámemak nóttek, Nazareu bíchaa. Huanäi jíba áme bétuk áu nüyeka yötuy. Ä áyehua éntok, sïmeta íkäri ëriasimey ä jiápsipo. ");
INSERT INTO mfy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús éntok chëhuasu entok ä takahuapo yötusimey, entok Diosta tü eäpo entok yoremem bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quince huásuktiriampo juka rey Tiberio Césarta yäura Romapo nésahueyo, jum Judea buiärapo éntok Poncio Pilato gobernadortukay, Heroodes éntok Galiléa buiärapo yäuratukay, ä saila Felipe Itureapo éntok Traconite buiärapo, Lisanias éntok Abiliniapo yäuratukay. ");
INSERT INTO mfy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasta éntok Caifásta sumo sacerdotetuko, Diosta bétana noki áu yepsak, Juan, Zacaríasta üusibehui, mékka ánia see päriapo ä aneyo. ");
INSERT INTO mfy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Huanäi áapo sïme Jordán bathue mayoamak géntemmeu noksimeka huéiyey, batöhuamta éntok Diostau bíchaa jíapsi kúaktiahuamta jume bem Dios bejrim jiokorinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías profeetata jïojteri bénasi ínel ä jiäpo: Jiahui mékka ánia see päriapo chaaye: “Señorta böomem tüte, ili böom éntokem rútuktia. ");
INSERT INTO mfy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sïme huame buía jójoroim nanahuittena, jume chopöriam, éntok káuhuim, jume böo chachakuim éntok rútuktiana; éntok jume böo rúrumuyim tütena. ");
INSERT INTO mfy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Huanäi sïme génte ä bínnake Diosta jínëuria.” ");
INSERT INTO mfy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juebena yóremra au yeu sájjak emo batö iäka, huanäi ínel ámeu jiaahuak: —¡Eme géntem bakot usiarim! ¿Jábesu enchim majtiala emo ä tö tenni sáhueka huaka Dios omtirata yebijnakemta? ");
INSERT INTO mfy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Türi takame jípu báreka eiya, emo jíapsi kúaktiaka. Éntok katem enchim jiápsipo ée taite: “Béjate Abrahamta itom áchaypo jípure”; senu huémtane enchimmeu nooka, Dios kía ímï tétampo júne ára am toboktia, jume Abrahamta üusim. ");
INSERT INTO mfy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bueïtuk két jume tépuam béja júyam nahuapo kéchari, sïme jü júya kaa türik takame chúktiahuaka tájiu jímmaana. ");
INSERT INTO mfy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Huanäi jü génte béja ä temajek, ínel áu jíakari: —¿Jítasute, júntuk yáanake? ");
INSERT INTO mfy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Huanäi Juan am yómmiaka ínel ámeu jiaahua: —Jü guoyik sánkokame, juka kaita jípuremta huépülam máknake; jü buähuamta jípureme, juka kaita jípuremta miknake. ");
INSERT INTO mfy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jume yäura tómita náu tótojaihui két áu yájjak emo batö iäka. Huanärim ínel áu jiaahua: —Maestro, ¿jítasasute yáanake? ");
INSERT INTO mfy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Áapo ínel ámeu jiaahua: —Katem úttiapo jita aahua enchim sáyhuakäpo áman jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Huate sontarom két ä nátemajek ínel jíakari: —Ítaposu, ¿jítasasute yáanake? Huanäi ínel am yómmiak: —Katem jabetau kaa huéeläpo jita aahua, ál‑la enchimmet nésayhuakäpo áman jíbba. Katem yäurapo emo tekipanoä tíaka, jábeta guómtiaka jítasu ä úhua. Enchim béjtuahuä beyem al‑leiya. ");
INSERT INTO mfy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jü gente éntok át suaka ä bitchay sïmeta juka huémta, bem jiápsipo éntokim emo nátemay, ínel jíakari: “Jamak Juan ájäria jäni jü Cristo.” ");
INSERT INTO mfy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Huanäi Juan sïmemmeu ínel jiaahua: —Lútulay ínapo bäampo enchim batöa; të äbo huéiye senu ino béppa chë yörisi maachi, éntok chë nésahue. Huakäi béja ínapo katchanne júne áu kóm chätuka bocha huíkyam ä búttiriapo yúmala. Huäri béja enchim batönake Espíritu Santoyi éntok tájiyi. ");
INSERT INTO mfy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ái huijhuijtiahuame ä mámpo óorek, juka erata tülisi ä tüte báreka. Chúkula éntok jume tirijkom ërianake jum kaa am nasontenakepo, juka pajata éntok náu yéchaka jum táijta kaa tutukëpo ä táanake. ");
INSERT INTO mfy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Íkäiri éntok huate jita ámeu nokaka, am téjhuay, juka genteta tühua bemela nokta bétana. ");
INSERT INTO mfy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Huanäi jü Juan kuttílasi áu nookay jü rey Heroodestahui ä saila Felipeta jámut ä jípurë tíaka (Ï jámut Herodias ti téhuaakay), éntok huate jita büruk kaa türik ä yáalä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Júnëli jita kaa huéchiasi yáalataka jü Heroodes, júchi áa béppa, Juanta páttiatebok jum cárcelpo. ");
INSERT INTO mfy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Júnaköri sïme pueblota emo am batöayo, Jesús két batöhuak. Huanäi Diostau oraciompo ä nokayo, jü téhueka áu étapok. ");
INSERT INTO mfy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Santo át kóm siika, guókouta bénasi takahuaka. Téhuekau bétana éntok áu nokhuak, ínel jíakari: —Émpë ín Üusi ín yeu púari, éntok ín nákëhui. ");
INSERT INTO mfy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Áapo jü Jesús ä tékilhua naatekari, jíba tua jamak treinta huásuktiriam huériay. Huä Joséta üusi ti ériahuame. José éntok Elíta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí éntok Matatta áchayekay. Matat éntok Levíiita áchayekay. Levíi éntok Melquita áchayekay. Melqui éntok Janata áchayekay. Jana éntok Joséta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José éntok Matatíasta áchayekay. Matatías éntok Amósta áchayekay. Amós éntok Nahumta áchayekay. Nahum éntok Eslita áchayekay. Esli éntok Nagaita áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai éntok Maatta áchayekay. Maat éntok Matatíasta áchayekay. Matatías éntok Semeita áchayekay. Semei éntok Joséta áchayekay. José éntok Judáta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá éntok Joanata áchayekay. Joana éntok Resata áchayekay. Resa éntok Zorobabelta áchayekay. Zorobabel éntok Salatielta áchayekay. Ï Salatiel éntok Nerita áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri éntok Melquita áchayekay. Melqui éntok Adita áchayekay. Adi éntok Cosamta áchayekay. Cosam éntok Elmodamta áchayekay. Ï Elmodam éntok Erta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er éntok Josuéta áchayekay. Ï Josué éntok Eliezerta áchayekay. Eliezer éntok Jorimta áchayekay. Jorim éntok Matatta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat éntok Levíiita áchayekay. Levíi éntok Simeónta áchayekay. Simeón éntok Judáta áchayekay. Judá éntok Joséta áchayekay. José éntok Jonánta áchayekay. Jonán éntok Eliaquimta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim éntok Meleata áchayekay. Melea éntok Mainánta áchayekay. Mainán éntok Matatata áchayekay. Matata éntok Natánta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán éntok Davidta áchayekay. David éntok Isaíta áchayekay. Isaí éntok Obedta áchayekay. Obed éntok Boozta áchayekay. Booz éntok Salmónta áchayekay. Salmón éntok Naasónta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón éntok Aminadabta áchayekay. Aminadab éntok Aramta áchayekay. Aram éntok Esromta áchayekay. Esrom éntok Faresta áchayekay. Fares éntok Judáta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá éntok Jacobta áchayekay. Jacob éntok Isaacta áchayekay. Isaac éntok Abrahamta áchayekay. Abraham éntok Taréta áchayekay. Taré éntok Nacorta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor éntok Serugta áchayekay. Serug éntok Ragauta áchayekay. Ragau éntok Pelegta áchayekay. Peleg éntok Heberta áchayekay. Heber éntok Salata áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala éntok Cainánta áchayekay. Cainán éntok Arfaxadta áchayekay. Arfaxad éntok Semta áchayekay. Sem éntok Noéta áchayekay. Noé éntok Lamecta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec éntok Matusalénta áchayekay. Matusalén éntok Enocta áchayekay. Enoc éntok Jaredta áchayekay. Jared éntok Mahalaleelta áchayekay. Mahalaleel éntok Cainánta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán éntok Enósta áchayekay. Enós éntok Setta áchayekay. Set éntok Adánta áchayekay. Adán éntok Diosta áchayekay. ");
INSERT INTO mfy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, Espíritu Santoy tápunika, Jordán bathue bétana yepsak. Huanäi mékka ániau see päriau bíchaa ä núk siika, jü Espíritu, ");
INSERT INTO mfy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","cuarenta taahuarimpo. Huanäi jü diablo tepa áamak aaney, ä jioptua báreka, kaa tühuata ä yáa ïaka. Sïme huameri taahuarimmechi kaa jïbuäk, huamei taahuarim simsuko tébäurek. ");
INSERT INTO mfy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Huanäi jü diablo ínel áu jiaahuak: —Bueïtuk empo Diosta Üusituko, íkäi tétatë emo pan yáa sáuhue. ");
INSERT INTO mfy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús ä yómmiaka ínel áu jiaahuak: —Júnel jïojteri: “Kaa kía páanimmea jíba jíapsinake jü yoreme, ál‑la sïme Diosta nokiyi.” ");
INSERT INTO mfy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Huanäi jü diablo káhuit chë jikat ä núk siika, huanäi chúbalaposu rey nesaupo attiata ä bíttuak, pueblo tüisi ujyorim éntok bueerem, ä bíttuak. ");
INSERT INTO mfy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huanäi ínel áu jiaahuak jü diablo: —Enchine ä máknake sïme úttiärata, enchi ä sáunakë béchïbo. Entok juka bem looria. Bueïtuk ínapo ä mak‑ri; entok jabeta ín ä makbareu ä maknake. ");
INSERT INTO mfy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Të ál‑lë inou tónommia kíkteka nee yörinake. Huanärë sïmeta íkäirë áttianake. ");
INSERT INTO mfy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Huanäi Jesús ä yómmiaka ínel áu jiaahuak: —Mékkë siime, Satanás, bueïtuk ínel jïojteri: “Juka Señorta em Diostë yörinake, éntoke áapörik jíba nésauta jorianake.” ");
INSERT INTO mfy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Huanäi buere joära Jerusaléniu bíchaa ä núk siika. Huämi béja buere tiöpot chë jikat ä kéchaka ínel áu jiaahuak: —Empo Diosta Üusituko, buíahuë emo kóm tójja, ");
INSERT INTO mfy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","bueïtuk ínel jïojteri: Dios jume ä ángelesim émou bíttuanake, enchi am anianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Éntokim mámammea enchi tóboktianake, em guókim kaa tétat tëitinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús ä yómmiaka ínel áu jiaahuak: —Ínel két nok‑ri: “Katë Diosta em Señorta jíoptuanake.” ");
INSERT INTO mfy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Huanäi jü diablo, kaachin béja ä bäitäu máchika, chubala ä tö siika. ");
INSERT INTO mfy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Huanäi Jesús, Espíritu Santota úttia huériaka, Galiléa buiärau nóttek. Buéresi tayahuay, sïme buíachi ä chíkola. ");
INSERT INTO mfy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Huanäi éntok bem sinagogampo am majtiay. Sïmetakam ä úttiley ä looriapo. ");
INSERT INTO mfy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bueïtuk Nazaretpo yepsak, ä yötuläpo. Jíba ä boojoriapo bénasi, jimyore táapo sinagogapo kibakek, huanäi jïojterita nok báreka kíktek. ");
INSERT INTO mfy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Huanäi éntok profeeta Isaíasta librom áu tóijhuak, librom étapoka, ínel jïojteta áma bitchak: ");
INSERT INTO mfy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Señorta Espíritu ino béppa aane, áapo nee áma yeu púala tühuata bemelasi huémta jume poloobemmeu nee ejtejhuä ïaaka. Jume jiokot sirokamta jiápsekame nee tüte ïaaka nee äbo bíttuak, pereesommet éntok chay ïaaka jáchin bem búttiatunakëhui, éntok liliptim puj etaponakë béchïbo, éntok jume jiokot nühuame am búttiaseka, ");
INSERT INTO mfy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","jume türi huásuktiriam Señorta bétana ámeu yebijnakëhui, ámeu nee nok ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Huanäi jume librom páttiaka, jü áma tékiakamtau am buíssek. Huanäi yejtek. Sïme jume sinagogapo aneme áachim puseka taahuak, ");
INSERT INTO mfy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","huanäi ínel ámeu nok táytek: —Én ímï enchim bíchäpo lútüriataka chúppe, ïri jïojteri. ");
INSERT INTO mfy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Éntok sïmetaka ujyorisi jíba áa bétana nookay, éntokim át guómtilataka ä jíkkajay, juka nokta tua huéchiasi huémta jíba ä tempo ä yeu huë tíaka. Huanärim ínel jiaahua: —¿Jachu ïri kaa Joséta üusi? ");
INSERT INTO mfy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Huanäi Jesús ínel ámeu jiaahuak: —Jamakem juka nokta ínel huémta inou nok báare: “Mérico, émpë emo jítto. Yúnte jita jíkkaij‑la pueblo Capernaumpo em yáakähui. Ímïre em buiärapo két ä yáuhua.” ");
INSERT INTO mfy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Huanäi éntok két ínel jiaahuak: —Kaabe profeeta tüisi mabethua ä buiärapo. ");
INSERT INTO mfy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tua huitti nokhuäpone ínel jiaunake, jum nación Israelpo juebena jáamuchim jókoptulame aaney, profeta Elíasta taahuarimmechi. Júnaköri báij huásukti áma búsan metpo kaita yúkutuko, buéresi tébaa siika, sïme ániachi. ");
INSERT INTO mfy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Të kaabetau éntok bíttuahuak jü Elías, huäri huépul jámut jókoptula, Sarepta Sidón buiära tíäpo jometau jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Éntok juebena lepra sähuata jípureka Israelpo aaney, Eliseo profeetata taahuarimmechi. Kaabe éntok áma türiak, huäri Naamán Síriapo joome jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Íkäi jíkkajaka sïme jum sinagogapo aneme, tüisim öomtek. ");
INSERT INTO mfy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Huanärim emo tóboktiaka, pueblopo yeu ä jaasek. Huanärim káhuit jikau ä núk sájjak, ámani káhuit jikat kóm ä jímmaa báreka. Bempo juka bem pueblota huäri káhuichim ä yáalatukay. ");
INSERT INTO mfy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Të áapo áme násuk yeu sika, siikak. ");
INSERT INTO mfy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús pueblo Capernaumpo yeu yepsak, Galiléa buiärapo. Huanäi sábala jimyore taahuarit am majtiay. ");
INSERT INTO mfy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tepam ä yosireka ä bitchay, jáchin yore ä majtiä bétana, bueïtuk jü ä nokihua, yäura nokta úttiära jípurey. ");
INSERT INTO mfy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Huépül yoreme sinagogapo aaney, lemoonio espíritu chïcha machik jípureka. Huäri béja tüisi kusisi tëka: ");
INSERT INTO mfy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Itomë tójja; ¿jítasë empo itomak huáatia, Jesús Nazareno? ¿Jachë itom lütiaseka äbo huéiye? Ínapo enchi täya, enchi jábétukähui Diosta Santöe. ");
INSERT INTO mfy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Huanäi Jesús kutti áu nónokaka, ínel áu jiaahuak: —¡Múksë kaa jiaahua, éntoke át yeu huéiye! Huanäi jü lemoonio, áme násuk buíapo ä tátabeka, át yeu siika, éntok kaa kökosi ä yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Huanärim sïme át guómtilataka taahuak, éntokim náu nookay, ínel jíakari: —¿Jíta nokisa ïri? ¡Yäurata úttiäray am sáuhue, jume lemoonio espíritu chïcha maachim, éntokim yeu sásaka! ");
INSERT INTO mfy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Huanäi jü buéresi ä bétana hueme jíkkaij táytihuak, sïme jume pueblo natechíkola tahuammechi. ");
INSERT INTO mfy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Huanäi Jesús kíkteka sinagogapo yeu siika. Huanäi Símonta jóapo kibakek. Jü Símonta asu éntok tüisi táijhuétchey, huanärim Jesústau ä nok‑riak. ");
INSERT INTO mfy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Huanäi Jesús, át müla kóm chätuka, táijhuéchiriatat kusisi át nónokak, huanäi ä tójjak, jü táijhuéchiria. Läutiposu yejteka, jita am joriay. ");
INSERT INTO mfy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Täata áman huécheyo, génte yún buere jita kökoata jípureka áu nüpahuak. Áapo béja huehuëpulammet mámteka am tütek. ");
INSERT INTO mfy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Juebenammet éntok két lemooniom yeu kaatey, tepa chayeka, ínel jíakari: —¡Émpë Diosta Üusi! Të áapo lemoniommet kutti nookay, éntok kaa yún am noktuay, bueïtuk bempo tüisi jüneiyay, áapo jü Cristo äbo yebisnakëihui. ");
INSERT INTO mfy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Béja taahuapo, Jesús kethueysu, mékka päriau bíchaa siika. Jume géntem éntok ä jariay, áu yájaka éntok. Katim ä sim ïaaka, tepa áamak jiaahuay. ");
INSERT INTO mfy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús éntok ínel ámeu jiaahuak: —Të úttia huate buere jóärammeu ín huéenakeu két íkäi tühua bemelasi nokta, Diosta reytaka nésahue bétana ámeu nokpo yúmala. Bueïtukne huäri béchïbo äbo bíttuari. ");
INSERT INTO mfy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Huanäi Galiléa sinagogampo, juka Diosta nooki ámeu nookay. ");
INSERT INTO mfy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Júnëli yeu siika: Genesaretta baubäa mayoat Jesústa aneyo, juebena génte áu náu yájaka buéresi ä pítpittiay, Diosta noki jíkkaij báreka. ");
INSERT INTO mfy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Huanäi guoy canoam bitchak, baubäa mayoachi, éntok jume kúchureom bäapo jäbuekame, bem jítërim báksiaka. ");
INSERT INTO mfy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Huanäi Jesús, Símonta canoapo jämuk. Huanäi mayoat huáijhua jëla bäau ä rúktia sáuhuek. Huanäi Jesús canoapo káteka am majtiay jume géntem. ");
INSERT INTO mfy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Noksuka béja, Símontau ínel jiaahua: —Canoatem bäa násukun bíchaa huéria. Huanärem enchim jítërim áman jímma kúchum buíj béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Símon éntok ä yómmiaka, ínel áu jiaahua: —Maestro, sïme tukaatate tekipanuak éntokte kaita buíssek; tëne én em nokpo áman am jímmanake jume jítërim. ");
INSERT INTO mfy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Áman am jímmaaka, juebena kúchum áma jaatiak jume jítërim éntok béja abe síutey. ");
INSERT INTO mfy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Huanärim senu canoapo rejtemmeu buáktek, emo ania ïaaka. Huanäi jume huate ámeu yájaka, am aniak. Huanärim guoy canoam tápuniak ímëi tapunika abe róptey. ");
INSERT INTO mfy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Símon Peero, íkäi bíchaka, Jesústau tónommia áu kíkteka, ínel jiaahuak: —¡Katë inou rukrukte, Señor! Bueïtukne yóremtaka Dios bejrita jípure. ");
INSERT INTO mfy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bueïtuk jume kúchum yún bem buísekä béchïbo, jü máuj‑ra ä jaatiak, éntok sïmetaka áamak aneme két guómtek. ");
INSERT INTO mfy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jacobo éntok Juan, Zebedeota üusim, júmëi két tepa guómtek. Bempo Símontamakim tekipanuay. Të Jesús Símontau ínel jiaahua: —Katë májhue; én naatekë kúchu jaasem tenasë yoremem nununake Diosta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Huanäi jume canoam päkun yeu tójaka, sïmetam tö sájaka, Jesústam guojaasek. ");
INSERT INTO mfy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesústa senu buere joärapo aney, yoreme sïme takahuat leprapaka áu yepsak. Huanäi Jesústa bíchaka, áu tónommia kíktek, éntok ä pújba buíau kóm yúmarialataka jiokot ínel áu jiaahuak: —Señor, ínel éätek, empo ára ín kökoa nee úhua. ");
INSERT INTO mfy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Huanäi Jesús áu mám rútukteka át mámtek, ínel jíaka: —Enchine türi ïaa. Türiäe. Ínel ä jíak, jíba jü kökoa ä tö siika. ");
INSERT INTO mfy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Huanäi éntok ínel ä sáuhuek katë jábeta téttejhua. Ínel jiaka: —Ál‑lë tiöpou huéiye áma nésahuemtahui, éntoke huaka Moiséjta nésahuekäu yáanake em türiakäu béchïbo, juka genteta jüneenakë béchïbo em türialatukä bétana. ");
INSERT INTO mfy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Të jü sïme jita ä joäu jüneria táytihuak, sïmekut chíbejtek mékka jákun tájti. Juebena génte náu yayajay ä jíkkaij báreka, éntok kökoata emo úhua ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Të áapo mékka bíchaa sisimey, kaita genteta anëu bíchaa, orciompo Diostau nok báreka. ");
INSERT INTO mfy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Séjtul táapo ínel yeu siika Jesústa am majtiayo, jume pariseerom éntok jume leyta am mamajtíame áma jokay júmëi béja ili pueblom bëkatana jometaka áma yáij‑latukay, Galiléa buiära bétana éntok Judea éntok Jerusalén bétana; Diosta úttiära éntok áamak aaney kökoreme tüte báreka. ");
INSERT INTO mfy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Júnensu huate yoremem áma yájjak, jípetampo senu yorem káraktilatam huériay, huáijhuam ä núk kimuka, Jesústa guókpom ä óre báreka éiyay. ");
INSERT INTO mfy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Të karam áma kimuka taahuak, juka genteta tüisi büru béchïbo. Huanärim kári jikat jämuka, tejampo guójöriata yáaka, áma huämim kóm ä yétchak, chíkti ä jípetekimaki, áme násuk, Jesústa pújbapo. ");
INSERT INTO mfy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús, Diostat ehuamta ámet bíchaka, kokoremtau ínel jiaahuak: —Empo yoreme, jume em Dios bejrimmeche jiokoritu. ");
INSERT INTO mfy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Huanäi jume leyta am mamajtíame éntok jume pariseerom kaa tüisi áatana éaka taahuak, ínel éakari: “¿Jábesa ïri Diosta béj‑reka nokame? Kaabe ára Dios bejrita jiokore, ál‑la Dios jíbba.” ");
INSERT INTO mfy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Të Jesús bem éerita jüneriaka, ínel ámeu jiaahuak: —¿Jatchiakasem enchim jiápsipo kaa yánti éiya? ");
INSERT INTO mfy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jítasu chë júne kaa obiachi, ínel jiau béchïbo: “Em Dios bejrimeche jiokorituk”, o ínel jiau béchïbo: “Kíktekë, huerama”? ");
INSERT INTO mfy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Enchim júkäi jünerianakë béchïbo, ínapo jü Yoremta Üusi ímï buíapo yäurata ín jípurë bétana jume Dios bejrim jábeta ä jiokorinakë béchïbo. Huanäi jü káraktilatau ínel jiaahua: —Emoune ínel jiaahua, yejtekë em jípetekta nüka em jóau bíchaa huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Senu huéchiapo, jü káraktila, sïmem bíchäpo kíkteka, juka ä jípetekta tóboktiaka, ä jóau bíchaa siika Diosta úttilsimeka. ");
INSERT INTO mfy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Huanäi sïmetaka át guómtilataka taahuak, éntokim yörisi Diosta looriata makkay, tüisim májhueka, ínel jiaahuay: —Énte bejja ä bitchak juka kaa jaibu bíbithuamta. ");
INSERT INTO mfy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chúkula íkäi simsuko Jesús yeu siika, senu yäura tómita náu tóij‑lerota bitchak, Levíi tï téhuakamta, jum tómita tótoijhuäpo kátekamta. Huanäi ínel áu jiaahuak: —Ino sauke huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Huanäi kíkteka, sïmeta tójaka, áa sáu siika. ");
INSERT INTO mfy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chúkula éntok, Levíii ä jóapo buéresi pajkok, Jesústa béchïbo, huanäi juebénaka jume yäura tómita náu tóij‑leerom mesahuim jokay, éntok huate yoremem ámemaki. ");
INSERT INTO mfy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Huanäi jume leyta am mamajtíame éntok jume pariseerom jume discíipulom junneria jíaka, ínel ámeu jiaahuay: —¿Jatchiakem jume yäura tómita náu tóij‑lerommak éntok jume juëna yorememmak jïbuä, éntok jita jëye? ");
INSERT INTO mfy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús am yómmiaka, ínel ámeu jiaahua: —Jume kaita ják ínnëame katim mérikota huáatia, të jume kökoreme ál‑la. ");
INSERT INTO mfy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ínapo kaa huame lútüla jiápsame núnuseka äbo siika, ál‑la Dios bejrita joame, am jíapsi kúaktinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Huanäi bempo ínel Jesústau jiaahuak: —¿Jume Juanta discíipulom éntok jume pariseerom discíipulom kaa jíjïbuä ayuunaka éntokim élaka Diostau oraciompo nooka, jume em discíipulom éntok ëe? ¿Jatchiakasu? ");
INSERT INTO mfy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Huanäi áapo ínel ámeu jiaahua: —¿Jachem jum bóodau núnurim buähuamta emo táktiria máchile, juka jubemta ámemak áma aneyo? ");
INSERT INTO mfy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Të taahuarim yúmanake, juka jubemta núk sákahuako. Huanäi ál‑la huamei taahuarimmechim kaa jïbuänake. ");
INSERT INTO mfy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Íkäi ejemplota két ámeu yétchak: —Kaabe súpe bemelampo ili sánkota áma chúkchuktia, súpe öram chäbuä béchïbo. Të ínel ä yák éntok, jume súpe bemelam nasontenake, éntok kaa jüri jíbba, kaa áamak útti jü sánko bemela öramaki. ");
INSERT INTO mfy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kaabe jü vino bemelata huaka bea bóosa örapo ä tóttöa. Áma ä kimakätek éntok, jü vino bemela ä síutianake juka huaka bea bóosata. Huanäi éntok, jü vino guötinake, éntok jume huaka bea bóosa júne kaa türika tahuanake. ");
INSERT INTO mfy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Júnen béchïbo, jü vino bemela huaka bea bóosa bemelapo tottöhua. Júnëli náhuichikam kaachin ayunake. ");
INSERT INTO mfy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jábe júne juka vino jauhuey huémta jëyëteko, kaibu júchi juka bemelasi yáata jï báanake. Bueïtuk ínel jiaunake: “Jü vino jauhuey naateka ëriari chë türi.” ");
INSERT INTO mfy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Séjtul sábala táapo, Jesústa jum etpo aman huéy, jume ä discíipulom tirijko bújam chúktiaka; mámammea am biitiaka am buäyey. ");
INSERT INTO mfy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Huanäi huate pariseerom ínel ámeu jiaahua: —¿Jatchiakasem jum jimyore táapo juka kaa jojohuamta johua? ");
INSERT INTO mfy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús am yómmiak: —¿Jachem íkäi júne kaa jum jïojtepo ä nok‑la juka Davidta yáakähui júnakoy jauhuey áapo tüisi tébäureka éntok jume áamak aneme? ");
INSERT INTO mfy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jáchin jum Diosta jóapo kibakeka jume páanim Diosta bíchäpo órekame, buäka, éntok jume áamak aneme két am miikak, huame páanim kaa kía jábe júne am buabuäye jume tiöpopo nésahueme jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ínel két ámeu jiaahua: —Ínapo jü Yoremta Üusi chë nésahue sábala taahuarita béppa. ");
INSERT INTO mfy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chúkula sábala táapo két ínel yeu siika, Jesús jum sinagogapo kibakeka am majtiay. Huanäi yoreme áma aaney jum bátam bétana huakiam mámaka; ");
INSERT INTO mfy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","huanäi jume judíom ley am mamajtíame éntok jume pariseerom Jesústat suaka ä bitchay, ä bít báreka jachu jum sábalapo ä tútenake jäni ti éaka, huáachï jíahuiteka ä nätua báreka. ");
INSERT INTO mfy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Të áapo tüisi bem éerim täyay, huanäi jü yoreme huakiam mámakamtau ínel jiaahua: —Kíktëe, násukë emo kétcha. Huanäi áapo kíkteka, áme násuk huéeka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Huanäi Jesús ínel ámeu jiaahua: —Senu huémtane enchimmeu nátemaij báare: ¿Jachu türi jäni sábalapo tühuata yáa béchïbo, o kaa tühuata yáa béchïbo? ¿Jíapsita jínëu béchïbo, o jíapsita úhua béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Huanäi jume áa chíkola aneme bíchaka, jü yoremtau ínel jiaahua: —Em mámamë rútuktia. Huanäi áapo ínel am yáuhuak. Huanärim türika taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Huanäi jume pariseerom éntok jume judíom ley am mamajtíame tepam kujtiaka taahuak. Huanärim náu ejtejhuay, jáchin ayuka juka Jesústa kaa tüisi ä tahuaria báreka. ");
INSERT INTO mfy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Huamëi taahuarimmechi Jesús béja júya káhuiu siika, áman Diostau oraciompo nok báreka. Sïme tukaapo Diostau nookak. ");
INSERT INTO mfy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yeu mátchuk béja, jume ä discíipulom núnnuk. Huanäi senu loseenam áma sïmem násuk yeu púuhuak. Huanäi béja jume apóstolim ti am téhuaatuak: ");
INSERT INTO mfy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jü Símon, Peero ti ä téhuaatuak, éntok jü Andrés ä sailahua, Jacobo éntok Juan, Felipe éntok Bartolomé, ");
INSERT INTO mfy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Toomas, Jacobo Alfeota üusi, Símon Zeloote ti téhuaakame, ");
INSERT INTO mfy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jacobota saila, éntok Judas Iscariote, áamak anekasu ä nénkakame. ");
INSERT INTO mfy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Huanäi ámemak kóm yepsak. Huämï béja bueka päriapo taahuak, ä discíipulommaki éntok huate géntemmak jume Judeapo jomeme, Jerusalémpo éntok bahue mayoat Tiropo éntok Sidónpo jomemtaka. Jesústam jíkkaij báreka áma yáij‑latukay, éntok bem kökoa emo úhua ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jume kaa yánti jiápsekame, lemoonio espíritu chïcha machik bem jípurë béchïbo tütehuay. ");
INSERT INTO mfy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Huanäi sïme jü génte át jálojti báreka tepa éiyay, bueïtuk jü úttiära át yeu huéiyey. Júnëli béja sïme kökoreme türiay. ");
INSERT INTO mfy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Huanäi Jesús jikau remteka ä discíipulom bíchaka, ínel jiaahuak: —Al‑leäem eme jume poloobem, bueïtuk eme ä áttiak juka Diosta reytaka nésahuëhui. ");
INSERT INTO mfy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Al‑leäem jume én tébäureme, bueïtukem jóboriana. ’Al‑leäem eme én buaname, bueïtukem chúkula atnake. ");
INSERT INTO mfy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Al‑leenakëem eme jume yoremem enchim omtiayo, éntok enchim am omouteyo, éntok enchim am bueere aahuayo, éntok enchim téhuam júne kaa jíkkaij péehuayo, Yoremta Üusi, enchim súalë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tüisem emo al‑leetua hua taahuarichi, bueïtukem buéresi tühuata mabetnake jum téhuekapo. Bueïtuk bem yoiyöturim két ínel ámemak aayuk, jume profeetammaki. ");
INSERT INTO mfy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Të jiokot machi enchim béchïbo, riikom, bueïtukem ímï buíapo béja ä jípusuk, juka enchim al‑leähui. ");
INSERT INTO mfy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Të jiokot machi enchim béchïbo, eme én jojóborime, bueïtukem chúkula tébäurinake. ’Të jiokot machi enchim béchïbo, eme én acheme, bueïtukem chúkula sirokaka buannake. ");
INSERT INTO mfy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Të jiokot machi enchim béchïbo, eme sïme genteta tühuata jíba enchim bétana nokayo, bueïtukim junëli ámemak aaney, jume bem áchayhuarim jume profeetam ára nókïchimmaki. ");
INSERT INTO mfy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Të eme íkäi jíkkajame, enchimmeune ínel jiaahua: Enchim kaa bíbit péame, akem am nákke. Jume enchim omtíame éntok, tühuatem ámeu johua. ");
INSERT INTO mfy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Juka Diosta tuhua am makka, jume béttesi enchimmet nokame. Jume emo bétana kaa tüisi nokame, oraciompo Diostahuem am nok‑ria. ");
INSERT INTO mfy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jábeta jópemmet enchi chóchonako, jume senu jópeme au óóre. Jábeta sakom enchi úhuak, éläposu két em súpem huériunake. ");
INSERT INTO mfy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jábeta émou nétaneyo, Akë ä miika. Em áttia enchi ä úhuak junne, katë áu ä äahua. ");
INSERT INTO mfy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jíta enchimmeu yáaria ïähui, júkärem ámeu yáuhua, jume huatemmehui. ");
INSERT INTO mfy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Eme jume enchim nákeme jíba nákëteko, ¿jita tühuatasem chë áa béppa johua? Bueïtuk jume juëna yóremem két íkäi johua. ");
INSERT INTO mfy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Éntokem huaka genteta tühuata enchimmeu joamta, huame jíba tühuata joätek, ¿jita tühuatasem áma jájamnake? Bueïtuk jume juëna yóremem két íkäi johua. ");
INSERT INTO mfy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Éntokem huaka enchim ä nóttirianakemta jíba jita réreuhuäteko, ¿jita tühuatasem áma jájamna? Bueïtuk jume juëna yóremem jita emo réreuhua, ánëli beekik mabet báreka. ");
INSERT INTO mfy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bueïtukem am nákke, jume kaa enchim bíbit péame, tühuata ámeu joaka. Jítem réutebo, kaita ámet jita boobíchaka. Júnëli hua buéresi tühuatem jájamnake. Éntokem jü Dios chë sïmem béppa nésahuemta üussitunake. Bueïtuk áapo tua türi, huame kaita baysahuemmeu bíchaa, éntok huame juëna yorememmeu bíchaa. ");
INSERT INTO mfy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jábetem jiokolë, itom Dios Áchayta jábeta jiokolë bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Katem jabetat bettesi nooka, huanärem kaa Dios yäurata bínnake. Katem jábetat bettek nooka. Huanärem Diosta bétana kaa bette nokta mabetnake. Jábetem jiokore. Huanäi Dios két enchim jiokorinake. ");
INSERT INTO mfy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jábemem jita mímika. Huanärim két enchim miknake. Kojtalimpo, tüisi yoyoata éntok pittiata kía abe guötemta enchim mámampo ä máknake. Bueïtuk Dios jü ili kútay enchim jujünakteyi, huayïrem jünaktena. ");
INSERT INTO mfy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús íkäi ejemplota ámeu yétchak: —¿Jachu jü lípti senu líptita ára huériunake jäni? ¿Jachum kaa náhuichika guójöku kóm huáttinake? ");
INSERT INTO mfy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jü disciipulo kaibu ä maestrota béppatunake. Të hua ä maestrota ä majtiakäu ä chúpako, ä maestrota bénanake. ");
INSERT INTO mfy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Jatchiakasë juka ili chúkita jabetat pújpo órekamta bitcha, huaka kúta buëuruta em pújpo bökamta éntok, ëe? ");
INSERT INTO mfy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Të huaka kúta buëuruta em pújpo órekamta kaa bitchatek. ¿Jáchisintuke ínëli áu jiaunake em sailabehui: “In saila, juka ili chúkta em pújpo em jípurëu, enchine yáa huík‑ria báare”? ¡Dios huatihuamta mamatome! Báchë juka kútata em pújpo órekamta yeu huikke. Huanäi ál‑lë tüisi bíchaka juka ili chúkta em saila pújpo ára yeu ä huikrianake. ");
INSERT INTO mfy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Jü júya türi kaibu kaa türim takanake. Jü júya kaa türi éntok, kaibu türim takanake. ");
INSERT INTO mfy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bueïtuk sïme jü júya juka takata béchïbo táyana: Jume chunam kaa júya huíchakame am tataka; jume párasim júne táchïno kaibu am takanake. ");
INSERT INTO mfy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jü tü yóreme tühuata johua, bueïtuk jü ä tü éerihua ä jiápsipo ayka. Huä juëna yoreme éntok, kaa tühuata johua, bueïtuk jü juëna éeri ä jiápsipo ayka. Bueïtuk hua ä noki ä tempo yeu huéeme hua jiápsipo ä jípurë bétana huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Jatchiakasem, “Señor, Señor”, ti inou jiaahua, ín nésau kaa joaka junne? ");
INSERT INTO mfy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Enchimne téjhua báare, huaka inou yepsaka nee nok jíkkajamta éntok ín nésau joamta, jábeta bénasi ä machiakähui: ");
INSERT INTO mfy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","hua senu yoremta káatë bénasi maachi. Huäri béja mékka kóm jïbuejeka, juka kárita tétachä nahuatuak. Huanäi baniata yepsako, bathue jikau siika. Huanäi jü bäa tepa úttia át yeu siika, jü kárichi, të kaa ä tátabek, bueïtuk jü kári tétat nahuakäy. ");
INSERT INTO mfy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Të hua ín nooki jíkkajame éntok kaa ín nésau joame, hua yoreme buía buálkopo kári kaa nahuakamta ä yáakamta bénasi maachi. Huanäi baniata yepsako, bathue jikau siika. Huanäi jü bäa tepa úttia át yeu siika, jü kárichi. Huanäi mójti huétchek, éntok kaita béj‑reka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chúkula Jesús jü gentetau noksuka, pueblo Capernaumpo kibakek. ");
INSERT INTO mfy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Senu sontarommeu yäut áma jóakay ïri éntok nésaulerota áma jípurey íkäi éntok áapo tüisi ä nákkey, të mukiapo kökorey. ");
INSERT INTO mfy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jü centurión, Jesústa bétana nokhuamta jíkkajaka, yorem yoiyöturim gente Israelpo joomem áu bíttuak áman ä núnuka ä nésaulerota ä jítto ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Huanärim bempo Jesústau yájaka, jiokot áu jiaahua, ínel jíakari: —Ïri capitan íkäi át ä buanähuë áu yáapo yúmala, ");
INSERT INTO mfy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","bueïtuk áapo juka itom génte nákke; huépü sinagogata itom yáariala. ");
INSERT INTO mfy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Huanäi Jesús ámemak siika. Të abe ä jóau ä yebisisey, jü centurión huate ä amiigohuam áu bíttuak, ínel jíakari: —Señor, kate jáchin éiya, kanne áma näikiapo yúmala jum ín jóa jöta bétuk inou em nóitinakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Huäri béchïbo ínapo kanne áman émou siika kaa tüisi ino ériaka. Ímïre ín jóa päku nésauta nooka, huanäi béja jü ín jóapo ín sáulero türinake. ");
INSERT INTO mfy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ínapo két yäurata bétuk káttek, éntokne yäurata jípure. Huanäine huépü sontarotau ínel jiaunake huëe, huanäi huéenake; senukuhui éntok binë huéiye, huanäi inou huéenake; éntok ín sáulerota jita nee ä yáa sáhuëu, ä yáanake. ");
INSERT INTO mfy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Huanäi Jesús, íkäi jíkkajaka át guómtek, huanäi jume géntem ä guojaasemmeu kúakteka ínel jiaahua: —Ínapone én ínel jiaahua, Israelpo júnene kaa ínëli úttesi Diostat ehuamta téula ï yoremtat bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Huanäi jume áman sáyhuakäme jóau nótteka, huaka kökoremta türilata téuhuak. ");
INSERT INTO mfy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chúkula Jesús jü pueblo Naín tí téhuakäu bíchaa huéiyey, jume ä discíipulommaki éntok juebena gentetamaki. ");
INSERT INTO mfy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pueblopo áman kíkkimuhuäpo ä yepsako, mukilata hueriyhuamta bitchak, ä mäabokam kaatey, ï mukila jámut jókoptula ä asoakay kaabeta éntok jípurey. Juebénaka huate áamak kaatey pueblopo jóakame. ");
INSERT INTO mfy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Huanäi Señor ä bíchaka, ä jiokoleka, ínel áu jiaahua: —Katë buaana. ");
INSERT INTO mfy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Huanäi jü ánimatau rúkteka kajat mámtek; huanäi jume ä huériame jáptek. Huanäi Jesús mukilatau ínel jiaahua: —Jübua yötume, émoune ínel jiaahua: ¡Yejtëe! ");
INSERT INTO mfy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Huä mukilatukäu yejteka nok táytek, huanäi Jesús ä áyehuata ä mákkak. ");
INSERT INTO mfy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Íkäi bíchaka, sïmetaka guómtilataka taahuak, éntokim Diosta úttil táytek, ínel jíaka: —Senu profeeta kaa náksi yörisi machika ito násuk áu tóboktiala. Ínëlim ket jiaahua: —Dios ä pueblo ania báreka äbo kóm yebij‑la. ");
INSERT INTO mfy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Huanäi sïme Judea buiärapo éntok áa chíkola jíkkaijhuak juka Jesústa yáakähui. ");
INSERT INTO mfy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautistata íkäi jita sïmeta bemelasi huémta ä jüneriak, bueïtuk jume ä discíipulom ä ejtejhuariak. Huanäi guoy ä discíipulom núnnuk, ");
INSERT INTO mfy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","huanäi Jesústau am jaasek ä temaij ïaaka: ¿Jachu áapörik ájäriatukähui jü Cristo yebijnakeme, o täbuik bem boobinnakëhui? ");
INSERT INTO mfy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jume Juanta áman jaasekäu, Jesústahuim rúkteka, ínel áu jiaahua: —Juan Bautista itom émou bíttuak enchi itom temaij ïaaka: ¿Jachë émpotuk ájäria jäni jü Cristo yebijnakeme, öte täbuik boobinnake? ");
INSERT INTO mfy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sep huämï horapo, Jesús juebena kökoreme éntok juëna kökoata jípureme tütek, éntok kaa türi espíritum jípureme yeu am béb‑riak, éntok két juebena liliptim bíttuak. ");
INSERT INTO mfy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Huanäi Jesús ínel am yómmiak: —Sájakem juka enchim bíchakäu ä ejtejhuaria juka Juanta éntok enchim jíkkajakähui. Jume liliptim bitcha; jume lolöim naa kaate; éntok huame sähua lepra téamta jípureme türia, nanakapim jíkkaja, kókkolam jíabite, éntok huaka nokta yore jínëuhuamta bétana huémta poloobemmeu nokhua. ");
INSERT INTO mfy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tühuata jájamla jü nee súaleka kaa áu náyoteme. ");
INSERT INTO mfy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jume Juanta áman jaasekäu am sákasuk, Jesús jume géntemmeu nok táytek jü Juanta bétana, ínel jíaka: —¿Jítasem bít báreka éiyay jum see päriapo? ¿Júya bakuliata jekay yoohuamta jäni? ");
INSERT INTO mfy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Éntok jútchi, ¿jitasem bít báreka áman yeu sájjak? ¿Senu yoremta tülisi sánkokamta jäni? Të jume ujyorisi tülisi sánkokame, éntok jume tülisi kaitat obisi éaka, éntok sïmeta jípureka ímï buíapo jiápsame, reyim jóapom aane. ");
INSERT INTO mfy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Të, ¿jitasem bít báreka áman yeu sájjak? ¿Senu profeeta Diosta bétana nokamta jäni? Jeehui, tua lútüriapo senu profeetata béppa chë yörisi maachik. ");
INSERT INTO mfy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ïri Juanta bétana huéeme jiöjteri: In noki huériamtane emopat jaase, juka böota em huéenake páman tütenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Enchimmeune nooka sïme géntem násuk kaabe chë yörisi maachi jü Juan Bautistata béppa; të júnentaka junne, huam Diosta reytaka nésahuepo jü chë ilitchisi ériahuame huäri chë yörisi maachi áa béppa. ");
INSERT INTO mfy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Huanäi íkäi jíkkajaka, sïme gente éntok jume impuestom tómi náu totojame, Juanta batöhuamta mabet‑latukäihui, Diostam súsualek éntokim ä lútüria tíaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Të jume pariseerom éntok huame leyta am mamajtíame, katim Juantau emo batötebokähui, inëlim béja kaitapo ä yáuhuak juka Diosta áme bétana näikiari. ");
INSERT INTO mfy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Huanäi Señor ínel jiaahua: —¿Jábeta bénasine am bínnake jäni, jume yoremem én kat‑riame? ¿Éntok, jita bénamsamme? ");
INSERT INTO mfy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jume usim pláazapo jokame bénasim ántuari entok náu nokaka éntok ínel jíame: ‘‘Baka kusiaite enchim jiponriak të eme kaa yëkak. Buikimte siroksi machisi jíame enchimmeu buiikak jiöbe të eme kaa buaanak.” ");
INSERT INTO mfy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bueïtuk Juan Bautistata yepsak, kaa páanim buäyey éntok kaa vino jëyey, huanärem Juanta lemooniota ä jiápsipo jípurë tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Huanäi jü Yoremta Üusi ím yepsak, jïbuäka éntok vino jëyeka; huanärem ínel jiaahua, ï yoreme tepa jíjjïbuä éntok vino jejëye. Jume yäura tómita náu tóij‑lerommaki éntok jume kaa Diosta yöremmaki tüisi áu huéria. ");
INSERT INTO mfy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Jü kóba súahua Diosta bétana huéeme ä üusimmet bíttu. ");
INSERT INTO mfy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Senu parisero juka Jesústa jïbuä núnnuk, huanäi ä jóau kibakeka mesau yejtek. ");
INSERT INTO mfy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Huanäi senu jámut áma pueblopo jóakame kaa tühuata boojoriaka, jünéaka Jesústa Símonta jóapo mesau kátekäu, ili téta sótöpo perfumeta musäla jubak, áma nüpak. ");
INSERT INTO mfy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Áma bétana áu sika ä guókpo áu yejtek, buanaka ópuammea ä kómoniria táytek jume guókkim. Ëntok ä chonimmea am huaachaka, am bebesiitoy éntok bäa musäla jubak ámet töak. ");
INSERT INTO mfy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jü parisero Jesústa jïbuä núnulame íkäi bíchaka, ä jiápsipo ínel éiyay: “Ï yoreme tua profeetatuko, ä jüneria éiyey ä jábe jámuttukähui, ï jámut chïcha machik jiápsek, éntok kaa tü böota boojoria, éntok áachä mámmatua.” ");
INSERT INTO mfy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Huanäi Jesús ínel áu jiaahua: —Símon, senu huémtane émou nok báare. Huanäi ínel áu jiaahua: —Nokäe, Maestro. ");
INSERT INTO mfy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Huanäi Jesús ínel áu jiaahua: —Senu yoreme guoy yoremem tómita am réuhuakäy. Huépülaka mamni cien denariom ä huikiriiyay, senu éntok cincuentam. ");
INSERT INTO mfy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Huanärim kaitay ä béjtua máchika taahuak. Të áapo náhuichim jiokorek junëlim béja kaita ä huikiriaka taahuak. Nokäe, ¿bueïtuk jábesu júntuk chë júne ä nákeka taahuak? ");
INSERT INTO mfy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Símon ä yómmiaka ínel áu jiaahua: —Jíba tua jü chë juebena tómit jiokorihuakame. Jesús ínel áu jiaahua: —Tepë tüisi ammäli jiaahua. ");
INSERT INTO mfy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Huanäi Jesús, jámuttau kúakteka, Símontau ínel jiaahua: —¿Íkäi jámuttë bitcha? Em jóaune kibakek, të bäam júne kaa nee miikak ín guókim béchïbo; të ï jámut ín guókim ä ópuammea kómoniala, éntok ä chonimmea am huaachak. ");
INSERT INTO mfy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Katë nee besiitok, të ï jámut éntok, nee ím yepsak naateka, kaa chúkteka ín guókim bebesiito. ");
INSERT INTO mfy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Katë aceiteta júne kóbat inot huáttiak; të ï jámut bäa musäla jubak ín guókimmet huáttiak. ");
INSERT INTO mfy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Huäri béchïbone ínel émou jiaahua, jume ä yún Dios bejrimmet jiokorituri; bueïtuk tüisi kaa béttek ä jiápsekä béchïbo. Bueïtuk hua jábe kaa jaiki béchïbo jiokorihuakame, kaa tua jábeta nákke. ");
INSERT INTO mfy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Huanäi Jesús jü jámuttau ínel jiaahua: —Béjë jiokorihuak em Dios bejrim bétana. ");
INSERT INTO mfy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Huanäi jume mesau áamak jokame, náhuim ínel jiau táytek: —¿Jábesa ïri, jume Dios bejrim júne jábeta jiokoreme? ");
INSERT INTO mfy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Të áapo jámuttau ínel jiaahua: —Jü chíkti em jíapsimak Diosta em súalekäu enchi jínëuk. Kaitachë jáchin éaka huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chúkula ínel yeu siika. Jesús sïme buere pueblommechi éntok il‑lïchimmechi ámeu noksisimey éntok am téjhuaasimey juka bemela nokta Diosta reytaka nésahue bétana huémta. Jume dooce discíipulom éntok áamaki. ");
INSERT INTO mfy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Éntok huate jáamuchim kaa türi espíritummea éntok kökoammey türialame áamakim kaatey, áme násuk entok María jü Magdalena ti téhuaakame, íachïri guoy búsan lemooniom át yeu sákalatukay; ");
INSERT INTO mfy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, jü Chuuzata juubi, Heroodesta móoroma, éntok Susana, éntok huate jáamuchim bem jita jípurëmakim ä aniay. ");
INSERT INTO mfy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Juebena génte áma joome, éntok sékäna joome, áma áu náu yájjak, Jesústahui ä bít báreka, huanäi íkäi ejemplota ámeu nookak, ínel jíakari: ");
INSERT INTO mfy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jü et‑leero yeu siika juka ä báchiahua echíseka. Ä echay éntok, huate böo mayoat huáttek huanäi át chéptihuak, éntok huikichim jikat bétana yájaka ä buäka. ");
INSERT INTO mfy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Huate báchia tétapo huáttek. Huanäi síuhuek, të huaakek, bueïtuk buía kaa bäaritukay. ");
INSERT INTO mfy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Huate báchia éntok júya huíchata sisihuëpo huáttek. Huanäi jü júya huícha áamak síhueka ä jíabi mëak. ");
INSERT INTO mfy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Huate éntok türi buíapo huáttek. Huanäi yötuka tüisi chúppuk, huépü báchia cien báchiam nénkak. Íkäi noksuka, Jesús tüisi kusisi ínel ámeu jiaahuak: —¡Jükä ín nooki jíkkaij báareme ä jikkaijnake! ");
INSERT INTO mfy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Huanäi jume ä disciipulohuam ä temajek: —¿Jáchisu ä jiau báarehui ikäy ejemplota? ");
INSERT INTO mfy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Huanäi áapo ínel ámeu jiaahua: —Eme yeu púari ä jüneria ïaahuaka juka kara át jüneehuamtachi Diosta reytaka ä nésahuepo ayukamta. Të jume huatemmeu éntok, jita ámeu nok bárëteko, ejemplommey jíbba. Bueïtuk bíchakam júne kaa bínnake, éntok jíkkajakam júne kaa át jüneenake. ");
INSERT INTO mfy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ínel jiau báare, jü ejemplo: Jü báchia jü Diosta nooki; ");
INSERT INTO mfy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","jü báchia böo mayoat huáttekame jume ä jíkkajame, huanäi sep jü diablo ámeu yepsaka, juka noki bem jiápsipo ayukamta am úhuaanake kaa ä súaleka bem jínëutunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jü báchia tétapo huáttekame, jume ínel ä jíkkajame. Al‑leakam ä mabeta, të katim naahuak; ímëi chúbala ä sússuale, huanärim ili obiachisi ä huée táytek amáu bícham nóttinake. ");
INSERT INTO mfy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jü báchia huíchapo huáttekame ímëi ínel jume ä jíkkajame të katekasum jü yún jitat obisi éehuame, jü yún jita kaa naksi jípu péehuame éntok jü ujyória tüisi ímï át jíapsihuame ä jíabi mënake, huanäi béjam kaa takanake. ");
INSERT INTO mfy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Të jü báchia türi buíapo huáttekame ímëi ínel jume türi jíapsimak éntok yö lúl‑la nokita bem jíkkaij‑läu ëeriame, ímëi ínel yü tutti takata nénkame. ");
INSERT INTO mfy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Kaabe machiriata bébeetia sótöriy ä páttia báreka, éntok kaibu tariimata bétuk júne ä órenake; ál‑la metjikat chöla ják ä órenake, áman kimume ä machirianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bueïtuk kaita jita ják éhuil óorek sïme jauhuey júne yeu machinake; éntok kaita ják éhuil ésori, kaa jüneriatunake ti kaa maachi, bueïtuk sïme yeu machinake. ");
INSERT INTO mfy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Áachem suaka, ä jíkkaja; bueïtuk sïme jume jita jípureme, júchi huatek mákna, të jü kaita jípureme, éntok juka ä jípu máchirëu júne úhuaana. ");
INSERT INTO mfy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Huanäi jü ä áyehua éntok jume ä sailahuam áu yájjak, tem karam áu rúktey juka genteta büru béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Huanäi senu ä téjhuak, ínel áu jíaka: —Em áiye éntok em sailam päkum aane enchi bít báreka. ");
INSERT INTO mfy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Të áapo ínel ámeu jiaahua: —Jume Diosta noki jíkkajame éntok ä joame, ímëi ámëria jü ín áiye éntok ín sailam. ");
INSERT INTO mfy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Séjtul táapo Jesús canoapo ámemak huéeka ä discíipulommaki, ínel ámeu jiaahuak: —Baubäa huáytanate kannake. Huanärim áman bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Të áman bíchaa am katey, Jesús kótchok. Huanäi senu huéchiapo jeka úttiaka naatek, bäa násuku. Jü canoa éntok bäam jajjayu táytek, éntok rópti machisi jínhua aaney. ");
INSERT INTO mfy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Huanärim Jesústa bússak, ínel áu jíaka: —¡Maestro! ¡Maestro! ¡Béjate abe rópte! Huanäi áapo yejteka, úttiaka áu nónokak jü jekatahui éntok jume máaremmehui; huanäi sïme kiktek entok sïme yánti taahua. ");
INSERT INTO mfy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Huanäi béja ä discíipulommeu ínel jiaahua: —¿Jáksu ayka jü enchim Diostat éhuame? Të bempo, at guómtilataka, kaa jáchin an máchika taahuak huanärim náu ínel jiaahuay: —¿Jábesa ï yoreme, bäata éntok jekata júne sáuhue, éntokim ä nok jíkkaja? ");
INSERT INTO mfy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gadarenom buiärapom yeu yájjak, baubäa huáytana, Galiléau lul‑la. ");
INSERT INTO mfy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesústa canoapo kóm chéptek, senu yoreme áma pueblopo jometaka ä nankirika siika. Ïri bínhua naateka lemooniota jípurey. Kaa sánkokay, éntok kaa ä jóapo jiápsay; ál‑la kókkolam mamähuäpo násuk jíba aaney. ");
INSERT INTO mfy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Huanäi Jesústa bíchaka, guókpo tónommia áu kíkteka, kusisi chayeka: —¿Jítasë ínomak jípure, Jesús, Dios jikat kátekamta Üusi? Emoune íkäi aahua, katë nee jiokot johua. ");
INSERT INTO mfy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesús éntok béja kutti át nónokak jü kaa türi espíritutachi yoremtat yeu ä huée sáhueka. Béja bínhua át jóakay jü kaa türi espíritu; jü gente cadeenammea ä susumay guókpo éntok mámpo; të áapo am chúkchuktiay huanäi jü lemoonio ä núk sisimey mékka ánia see päriahui. ");
INSERT INTO mfy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Huanäi Jesús ä nátemajek: —¿Jáchisë téhuak? Áapo éntok ínel ä yómmiak: —Legión tine téhuak. Bueïtuk juebena lemooniom át kimulataka át jóatelatukay. ");
INSERT INTO mfy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huanärim Jesústau jiokot jiaahuak, kaa jum kaa machikun guójöria mékka kömi emo bíttua ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ámanim káupo büru koohuim rejtey ámam jïbuäsasakay, huamechïrim kimu rókaka áu nookak; Jesús éntok am jehuiteriak ámecham kimunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Huanäi jume lemooniom yoremtat yeu sájaka kohuimmechim kimuk ímëi éntok sïmetaka jum sibapo emo kóm guötiaka bäapo kóm huáttekam, áma ropteka kókkok. ");
INSERT INTO mfy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Huanäi jume kohuim suayame, íkäi bíchaka, guómtilamtaka tennek huanärim am téjhuak jum pueblopo éntok ranchommechi. ");
INSERT INTO mfy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Huanäi jü génte yeu sájaka ä bitchak juka jita áma yeu sikamta. Huanärim Jesústau yájaka, juka yoremta áma téuhuak juka lemooniom át yeu sákalatukäuta, Jesústa guókpo kátekamta, sánkokamta éntok yúmalasi suakamta. Huanärim májhueka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jume ä bíchakame, am ejtejhuariak jáchin ä tütehuakähui juka lemooniom jípurëuta. ");
INSERT INTO mfy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Íäribéchïbo, sïme jü génte juebénaka áma aneme jü Gadara buiärapo éntok huíkola ják jóakame, Jesústam sim sáhueka áamak jiaahuay, bueïtukim tüisi májhuey. Huanäi jü Jesús, canoapo kibakeka, siika. ");
INSERT INTO mfy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jü yoreme lemooniom yeu béb‑riari áamak jiaahuay, áamak huée rókaka. Të Jesús ä simtuak, ínel áu jíakari: ");
INSERT INTO mfy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Em jóahuë nótte; Akë am ejtejhuaria jáchin machisi buere jita Diosta émomak yáakähui. Huanäi áapo siika, ä noksimeka sïme pueblopo jita buéresi Jesústa áamak yáakähui. ");
INSERT INTO mfy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Juka Jesústa nótteko, büru génte al‑leaka ä mabetak, bueïtuk sïmetaka ä boobíchaïhuiy. ");
INSERT INTO mfy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Senu yoreme Jairo ti téhuaaka áu yepsak, tiöpopo kóba yöturi. Jesústa guókpo tónommia kíkteka, jiokot áu jiaahuay ä jóau ä kibak ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bueïtuk huépülak jíba malakay, dooce huásuktiriam jamak ják huériay; únna kökoreka béja abe muukey. Huanäi juka Jesústa áman bíchaa ä huéesimeyo, büru gentetamaki huanärim tüisi ä pítpittiay. ");
INSERT INTO mfy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Të senu jámut éntok béja dooce huásuktey mecha kökoata bénasi ójbo kaa chúkteka át huéiyey sïme juka ä tómita ä jípurëu am mák‑latukay jume mérikom, të kaabe ára ä úhuay juka kökoata. ");
INSERT INTO mfy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amatana Jesústau sika jume ä mantommet át jálojtek, huanäi senu huéchiapo áma horapo kíktek jü ójbo át yeu huéeme. ");
INSERT INTO mfy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Huanäi jü Jesús ínel jiaahua: —¿Jábesu inot jálojtek? Kaabeta béja áu yeu buísek, jü Peero éntok jume huate áamak aneme ínëlim jiaahua: —Maestro, jü génte büruka enchi pítpittia éntok enchi yuyüa jákübo junne, éntoke nátemaje: “¿Jábeta emót jálojtekähui?” ");
INSERT INTO mfy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Të Jesús ínel jiaahua: —Jábe inot jálojtek, bueïtuk ínapo ä ínnëak, úttiärata inot yeu sikähui. ");
INSERT INTO mfy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Huanäi jü jámut, ä bíchaka áu jüneriahuakähui, áu yoosimeka áu rúktek huanäi Jesústa guókpo tónommia kíktek. Sïme genteta jíkkajäpo áu yeu buíssek jita béchïbo áachä jálojtekähui, éntok jáchin bénasi läutipo áu türiakähui. ");
INSERT INTO mfy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Huanäi Jesús ínel áu jiaahua: —In maala, jü em Dios eäu enchi tütela. Yánti jiápsekë huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ketune Jesústa nokaysu, senu áma yepsak, tiöpopo kóba yöta jóa bétana, Jairotau ínel jíakari: —Em mala béja muukuk; katë juka Maestrota múksi bitcha. ");
INSERT INTO mfy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús ä jíkkajaka ínel áu jiaahuak: —Katë májhue; chíkti em jíapsimake nee súale, huanäi türianake. ");
INSERT INTO mfy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jum jóau yepsaka, kaabeta täbuik éntok áamak áman kibaktuak, Perota jíbba, Jacobota, Juanta, ä paahua, éntok juka ili usi jámutta áiye. ");
INSERT INTO mfy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sïmetakam buaanay, éntokim tüisi ä sirok‑riay. Të Jesús ínel ámeu jiaahua: —Katem buaana. Kaa mukila jü ili usi jámmut, kía kótche. ");
INSERT INTO mfy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tem kía ä akbuay, bueïtuk bempo tüisi jüneiyay ä mukilatukähui. ");
INSERT INTO mfy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Të áapo, mámpo ä buíseka úttiaka áu nónokak ínel jíakari: —Empo ili usi jámmut, yejtëe. ");
INSERT INTO mfy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Huanäi jü jíapsi áu nóttek, éntok sep yejtek; huanäi Jesús ä jïbuätua nésahuek. ");
INSERT INTO mfy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jume ä áchayhuam éntok tepam át puj jáptek; të Jesús tüisi am téjhuak kaa jábetau am jíal sáhueka juka áma yeu sikamta bétana. ");
INSERT INTO mfy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús jume ä dooce discíipulom náu tójaka, yäura úttiata am mákkak, jume lemooniom yeu am bébnakë béchïbo, éntok kökoreme tütenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Huanäi yeu am bíttuak, huaka Diosta reytaka nésahue bétana géntemmeu am nok ïaaka, éntok kökoreme am tüte ïaaka. ");
INSERT INTO mfy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Huanäi ínel ámeu jiaahua: —Katem jita huéhueria böot béchïbo, borooniata junne, bóosata, páanim, tómita junne. Huépülam jíbem súpeka kaate, kaa guooyim. ");
INSERT INTO mfy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ják jóapo enchim yájakäpem aane, enchim sájäu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ják pueblopo kaa enchim mabethuakäpem yeu kaate, enchim guókim ámeu tóröchiata tátakeka, bem jüneenakë béchïbo kaa tüisi bem ayukähui. ");
INSERT INTO mfy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bempo éntok yeu sájaka, sïme pueblom bëkatana naa kaatey, juka tü nokta Diosta bétana huémta ámeu nokaka éntok sïmekut jume kökoreme tüteka. ");
INSERT INTO mfy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jü rey Heroodes kobanaro nésahueme Jesústa bétana nokhuamta jíkkajak, jita benak ä jo sisimëhui. Huanäi át guómtilatukay. Bueïtuk huate ínel jiaahuay: “Juan kókkolam násuk jíabitela.” ");
INSERT INTO mfy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Huate, juka profeeta Elíasta yeu machiak tíiyay. Huate éntok, jábe profeetam jume bannaataka kat‑riam jíabitek tíiyay. ");
INSERT INTO mfy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Huanäi Heroodes ínel jiaahua: —Tësune ínapo juka Juanta kóba chúktiatebok. ¿Jábesa júntuk ïri jü juebena jita ín áa bétana jíkkajähui? Júnëli jü Heroodes ä bít báreka éiyay. ");
INSERT INTO mfy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jume apóstolim júchi yeu yájaka ä ejtejhuariak juka Jesústa sïmeta juka bem yáakä bétana. Huanäi am nüka, am núk siika, mékka ánia päria pueblo Betsaida ti téhuaakähui. ");
INSERT INTO mfy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Të jü génte ä jüneriaka, áa sáukim sájjak. Huanäi am mabetaka juka tü nokta Diosta reytaka nésahue bétana huémta ámeu nookak, éntok huame tua jiokot éame kökoata am úhuak. ");
INSERT INTO mfy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Të huanäi éntok kúpti táytek. Huanäi jume doocem Jesústau rúkteka, ínel áu jiaahuak: —Juka géntetë sákatua. Éläpom sájaka pueblom o ranchom jariunake, buähuamta éntok ják bem jimyorenakëhui. Bueïtuk mékkate aane, ánia päriapo, kaabeta jóakäpo. ");
INSERT INTO mfy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Huanäi Jesús ínel ámeu jiaahua: —Emem am jïbuätua. Huanärim ínel jiaahua: —Mamni páanim éntok guoy kúchum jíbate jípure. Jëitu, jamak ítapo áman sájaka buähuamta am jínnurianake, ïri büru genteta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jíba tuam jamak mamni mil yorememtukay. Huanäi Jesús ínel ámeu jiaahua jume ä discíipulommehui: —Móchalem náu am jóiya, sincuecuentam. ");
INSERT INTO mfy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Júnëlim sïmem náu jóiyak. ");
INSERT INTO mfy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Huanäi jume mamni páanim éntok jume guoy kúchum nükari, téhuekau jikau remteka, tü nokta ámet chúppak. Huanäi am näikimteka, jume ä discíipulom am mákkak, jü gentetacham näikimte nésahueka. ");
INSERT INTO mfy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Huanäi sïme jïbuäk, éntokim jóbuak. Huanärim dooce canastam tápuniak, yeu bëkamtayi. ");
INSERT INTO mfy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Júnakoy júnen yeu siika. Jesústa áapola Diostau buanayo, jume ä discíipulom áamak aaney. Huanäi am temajek, ínel jíakari: —¿Nechim jábë tíiya? ");
INSERT INTO mfy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bempo ä yómmiak: —Huate enchi Juan Bautistä tíiya. Huate, Elías. Huate éntok, jábe profeeta jauhuey huéria mukilataka jíabitelame. ");
INSERT INTO mfy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Huanäi ínel ámeu jiaahua: —Emesu, ¿jáchisem ino bétana jiaahua? ¿Nechem jábë tíiya? Huanäi Peero ä yómmiaka, ínel jiaahua: —Émpë jü Diosta Cristo äbo yebisnakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Të Jesús kúttilasi am téjhuak, kaabetau íkäi am nok sáhueka jáchin huéy junne, ");
INSERT INTO mfy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","éntok két ínel jiakari: —Ínapo jü Yoremta Üusi yún jita kökosi kaa béj máchika inou huéenake. Jume yoiyöturim bétana, éntok jume tiöpopo chë áma nésahueme, éntok jume escribam nee omoutenake. Huanärim nee mënake, të báij taahuarim huéyne jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Huanäi sïmemmeu ínel jiaahua: —Jábe júne ino sáu huée bárëteko, tókti áu nénkaka, chíkti táapo ä kúrus püaktiaka, ino sáu huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bueïtuk sïme juka ä jíapsi jínëu báareme, ä tärunake, éntok sïme jábe ino béchïbo ä jíapsi tärukame, ïri ä jínëunake. ");
INSERT INTO mfy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Bueïtuk jítasu áma téunake jü yoreme sïme ániata yöoko, áu lütiätek, o áu tärukäteko? ");
INSERT INTO mfy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bueïtuk jü inot tihueme éntok ín nokiyi, ínapo jü Yoremta Üusi kétne ái tiunake, júnakoy lóoriapo yepsateko, éntok ín Átchay lóoriapo, éntok jume santo ángelesim lóoriapo. ");
INSERT INTO mfy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tëne én tua lútüriapo ínel jiaahua, jume huate imï aneme, katim bát kókkohuamta bínnake, Diosta reytaka nésahueu bíchäkatek júbua. ");
INSERT INTO mfy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesústa íkäi noksuko, guoj naiki taahuarim simsuko, ínel yeu siika. Perota, Juanta éntok Jacobota núk siika, káhuit jikau bíchaa, áman Diostau buan báreka. ");
INSERT INTO mfy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Diostau ä buanayo, jü ä pujba täbuiasi bíttuk. Ä sánkohua éntok tósalisi éntok bélojkosi aayuk. ");
INSERT INTO mfy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Huanäi éntok guoy yoremem áma yeu machiak, áamak ejtejhuaka. Moisés éntok Elíastukay. ");
INSERT INTO mfy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huanäi áme chíkola Diosta lóoria am machirialatukay. Jachin Jesústa simnake bétanam nookay, Jésús buere joära Jerusalémpo ahuä chupátuanakëihui. ");
INSERT INTO mfy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peero éntok jume áamak aneme, tüisim yetem jípurey. Tem búsalataka, Jesústa lóoria ujyória bitchay, éntok jume guoy yoremem áamak aneme. ");
INSERT INTO mfy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Huanäi bempörim Jesústa tö sájako, jü Peero ínel áu jiaahua: —Maestro, ¡türi ímï ito béchïbo! Báij jötamte ímï cháanake, huépülaik emo béchïbo, senuk Moiséjta béchïbo, senuk éntok Elíasta béchïbo. Të Peero kaa jüneiyay jita ä nokähui. ");
INSERT INTO mfy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Íkäi ä nokaysu, namu áme béppa yéjtekam páttiak. Huanärim guómtek, namupo kimuka. ");
INSERT INTO mfy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Huanärim jiahuita jíkkajak jum namupo, ínel jíamta: —Ïri ín Üusi ín nákëhui; áapörikem nok jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chúkula juka nokta jíkkaijsukam juka Jesústa áapolaik áma anemta bitchak. Bempo kaabeta ejtejhuaariak. Huanäi huámechi taahuarimmechim kaabetau jíalek juka bem bíchakä bétana. ");
INSERT INTO mfy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yokoríapo, káhuit kóm sájaka, génte juebénaka am nankirika sajjak. ");
INSERT INTO mfy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Huanäi jume géntem násuk senu yoreme tüisi kusisi ínel jiaahuak: —Maestro, émounä nétane ín usië nee bít‑ria. Júkäi huépülaik jíbane üusek. ");
INSERT INTO mfy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Íkäi jípure, huépul lemoonio espíritu ä jaajaatia. Senu huéchiapo chay tátayte. Huanäi huécheka sútatäti an tátayte. Tempo áman sósomöchia. Huanäi jü lemoonio espíritu kökosi ä tátabeka kaa ä tóij bábbare. Júnëli jiokot ä antuasuka béja ä tóttoja. ");
INSERT INTO mfy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Em discíipulommeune jiokot jiausuk lemoniota yeu ä jaaria sáhueka, të katim áma yuumak. ");
INSERT INTO mfy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús ä yómmiaka, ínel jiaahua: —¡Eme géntem kaita súalëram éntok jujuëna! ¿Jauhuey tájtine enchimmak annake jäni, éntok enchimmet kaa yúmaka? Inohuë ä huéria juka em üusi. ");
INSERT INTO mfy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huanäi juka usita áu yebisiseyo, jü lemoonio buíapo ä tátabeka, úttia sútatäti ä antuak. Të jü Jesús juka lemoonio espíritu jaiti machik béj‑reka nónokak. Huanäi ä tütek juka usita. Huanäi ä áchaytau ä nóttiriak. ");
INSERT INTO mfy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sïme ä yosireka taahuak, juka buéresi Diosta joähui. Sïme át guómtilataka ä bitchay, juka Jesústa joähui. Huanäi éntok ä discíipulommeu ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Íkärem tüisi jíkkaja, éntokem kaa ä koptia. Ínel yeu huéenake: ínapo, jü Yoremta Üusi ti téhuaakame, yoremem mámpo yéchana. ");
INSERT INTO mfy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Të bempo kaa át jüneiyay, ïri nokichi. Dios ketune kee am pujtetuay, íkäi nokta bem jünerianakë béchïbo; át nátemay báreka júnem májhuey ïri nokichi. ");
INSERT INTO mfy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huanäi jume discíipulom náu nok nássua táytek, jünee báreka jábesu áme násuk chë júne nésaunake jäni tíaka. ");
INSERT INTO mfy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Huanäi Jesús am jüneriaka jita benak am éähui bem jiápsipo, ili usita nüka, áa náapo ä kétchak. ");
INSERT INTO mfy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Huanäi ínel ámeu jiaahua: —Jábe júne íkäi ili usita ín téhuampo mabetako, nee mabeta; jábe júne nee mabetakame, juka nee äbo bíttualata mabeta. Bueïtuk jü enchim násuk hua kaa áu jitaleme, huäri chë yörisi maachi. ");
INSERT INTO mfy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Huanäi jü Juan ä yómmiaka, ínel jiaahua: —Maestro, senukte két bitchak, lemooniom yeu jaasemta em téhuampo. Të kaa itomak huéiye; kíalïkute ä táktiriak. ");
INSERT INTO mfy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús ínel áu jiaahua: —Katem ä taktaktiria; bueïtuk jü kaa itom béj‑reka huéeme, ito bétana huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús, téhuekau jikau ä mabennäu tiempota yúmasey, jíapsita tutti yéchaka, kíkteka böota nüka Jerusaléniu bíchaa huémta. ");
INSERT INTO mfy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jume nokta huériame áapat bíttuak, sájakam Samaritanom pueblou kiímuk, áa bia sïmeta tüte béchïbo jum ä yebijnakepo. ");
INSERT INTO mfy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Të katim mabethuak, bueïtuk böo Jerusaléniu bíchaa huémtat bem katë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ä discíipulom íkäi bíchaka, Jacobo éntok jü Juan, junëlim jiaahua: —Señor, ¿jache táijta jikat bétana itom ámet kóm bíttua ïaa, júnak táapo Elíasta am yáakä bénasi? ");
INSERT INTO mfy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Huanäi áapo ámeu kúakteka, tepa béttesi ámeu nónokak, ínel jíakari: —Eme kaa jüneiya jita espírituta enchim jípurëhui. ");
INSERT INTO mfy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jü Yoremta Üusi kaa jume yorem jíapsim mëseka äbo siika, ál‑la am jínëuseka. Huanärim sékäna pueblou bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Böot am boojoay, Jesústau senu ínel áu jiaahuak: —Señor, jákun em huëu bíchaa júnene emót chäka huéenake. ");
INSERT INTO mfy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Huanäi Jesús ínel áu jiaahua: —Jume ayesim guojöriam jípure, jume huikichim jikat rejteme, toosam; të jü Yoremta Üusi jitat ä mutekaka ä bönakeu júne kaa jípure. ");
INSERT INTO mfy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Senukuu éntok ínel jiaahuak: —Ino sáukë huéiye. Áapo éntok ínel ä yómmia: —Señor, nechë licensia bátne ín átchay mäa báare. ");
INSERT INTO mfy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús ínel áu jiaahua: —Akë am tójja; éläpo jume espíritupo kókkolam bem kókkolam maanake. Émpë yeu sika juka tü nokta Diosta reytaka nésahue bétana nooka. ");
INSERT INTO mfy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Huanäi täbuika két ínel áu jiaahuak: —Señor, enchine guojaa báare, Señor, të báchë nee tójja amanne ín jóapo aneme tebotuaka sim báare. ");
INSERT INTO mfy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Huanäi Jesús ínel áu jiaahuak: —Jábe júne arau manseeram buísek, amáu remtekäteko, kaibu tüisi áma huéenake jum Diosta reytaka nésahuepo böochi. ");
INSERT INTO mfy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chúkula sïmeta íkäi simsukäpo, jü Señor setentam áma yeu púuhuak. Huanäi béja guoguoyim náu áman bíttuak áapachi, sïme pueblompo o jákun ä yebijnakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ínel ámeu jiaahua: —Lútüriapo jü echi chúpeme juebenna, jume tekipanualerom éntok kaa jaiki. Huäri béchïbo jü etta áttiakamtahuem nooka, huate tekipanualerom áman ä bíttuanakë béchïbo, jukam etta tóboktianake. ");
INSERT INTO mfy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ámanem kaate. Ínapone enchim áman bíttua, kabara asölam robom násukun bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Katem nüuta áma huéhueriahuamta, tómita éntok bocham junne, kaa huéhueria. Katem jápteka böot jábeta tetebotua. ");
INSERT INTO mfy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ják jóapo enchim kimukäpo, ínëlem bát jiaunake: ‘‘Yánti jíapsihuame ïri jóata béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huanäi jábe yánti jiápsekamta áma aneyo, jü enchim yánti jiápsekähui áa béppatunake. Kaa júnentukäteko, enchim yánti tü jíapsi, júchi enchimmeu nóttinake. ");
INSERT INTO mfy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Éntokem huäri jóapo jíba tahuanake, jita enchim mikhuamtem buäye, éntokem jëye. Bueïtuk jü tekipanuame jíba jita kobapo yúmala. Katem huate jóahuammet an sásaka. ");
INSERT INTO mfy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ják pueblopo junne, enchim kimukäpo, éntok enchim mabethuakäpo, enchim äbojhuakämtem buäye. ");
INSERT INTO mfy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Éntok jume kökoreme áma anemem tüte, éntokem ínel ámeu jiaahua: ‘‘Huä Diosta reytaka ä nésahuepo kaa mékka enchimmeu aane.” ");
INSERT INTO mfy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Të ják pueblopo enchim kimukäpo, éntok kaa enchim mabethuakäpo, böommehuem yeu sájaka, ínel jiaunake: ");
INSERT INTO mfy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘‘Jü tóröchia ímï pueblopo ayukame junne, itom guókpo chätulame, enchim béj‑rekate ä tataknake. Ál‑lem íkäi jüneríanake, jü Diosta reytaka ä nésahuepo kaa mékka enchimmeu aane.” ");
INSERT INTO mfy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tëne enchim téjhua hua taahuari nokta chúpey, chë júne noki béttesi chúpatunake, huäri pueblotachi, hua pueblo Sodoomä téamta béppa. ");
INSERT INTO mfy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Jiokot maachi, emo béchïbo, empo pueblo Corazín! ¡Jiokot maachi, emo béchïbo, empo pueblo Betsaida! Bueïtuk huam Tiropo éntok Sidón pueblopo huaka kaa jaibu jojohuamta áma yáahuak, enchim násuk yáahuakamta, jauhuey bétanam emo jíapsi kúaktiasu éiyey, éntokim chukurim súpete éiyey, éntok kóbat emo nápojtua éiyey. ");
INSERT INTO mfy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Të hua taahuari nokta chúpey, eme chë júne jiokot máchiraata bínnake, hua génte pueblo Tiropo éntok Sidón pueblopo joomem béppa. ");
INSERT INTO mfy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Éntok empo pueblo Capernaum, ¿jache téhuekau tájti emo tóboktia máchile? ¡Të áman táijta kaa tutukëpo tájtë kóm jímmaana! ");
INSERT INTO mfy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Jü enchim nok jíkkajame, nee nok jíkkaja; jü enchim omouteme, nee omoute; jü nee omouteme éntok, juka nee äbo bíttualata omoute. ");
INSERT INTO mfy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Huame setentam tüisim al‑leaka yeu yájjak, éntokim ínel áu jiaahuak: —Señor, jume lemooniom júne itom nok jíkkaja, em téhuampo. ");
INSERT INTO mfy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús éntok ínel ámeu jiaahuak: —Jehui, ínapo juka Satanásta bitchak téhueka bétana kómhuéchemta yúku jímmaa bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ínapone én úttiata enchim mákka bakochim éntok machilim béppa enchim rejtinakë béchïbo, éntok sïme kaa Dios huáatemem kobanake, éntok kaita enchim kökosi yáanake. ");
INSERT INTO mfy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Katem jume lemooniom emo yeu jajjasë béchïbo al‑leaka chépte; al‑leakem jikau chépte, jume enchim téhuam áman téhuekau jïojteri béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Huämi horapo Jesús Espíritu Santopo tüisi al‑lëiak. Huanäi ínel jiaahuak: —Ínapone enchi úttile, ín Átchay, téhuekata éntok buíata áttiakame, jume tüisi jita täyame éntok jítat suame empo íkäi am ésoriala jume ili usimmeu yeu ä machiria báreka. Jeehui, ín Átchay, empo júnël ä huáatiak. ");
INSERT INTO mfy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’In Átchay sïmeta ín mámpo tóij‑la. Kaabe ä täya juka Dios Usiarita, ä Áchayhua jíbba; éntok jábeta Dios Áchaytukähui, ä Üusihua jíbba; éntok ä téjhua bárëu ä téjhuaanake, ä Üusihua. ");
INSERT INTO mfy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ä discíipulommeu bempolammeu kúakteka, ínel ámeu jiaahuak: —Al‑leehuamtam jájamla jume ä bíchame juka enchim bíchähui; ");
INSERT INTO mfy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","bueïtukne én ínel jiaunake, juebena profeetam éntok reyim tüisim ä bít péiyay, juka én enchim bíchähui, të katim ä bitchak; enchim jíkkajähuim jíkkaij péiyay, të katim ä jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Séjtul senu tüisi leyta täyame kíkteka ínel áu jiaahuak, Jesústa tiusi tahuaria báreka: —Maestro, ¿jítasune yáakätek juka yü jíapsihuamta jípunake? ");
INSERT INTO mfy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Huanäi Jesús ínel áu jiaahuak: —¿Jáchisu áma jïojteri jum leypo? ¿O jáchise ä bitcha juka áma jïojteta? ");
INSERT INTO mfy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Huanäi áapo, ä yómmiaka, ínel áu jiaahuak: —“Em Señor Dioste tüisi náknake, chíkti em jíapsimaki, éntok chíkti em kóba súäramaki, éntok chíkti em úttiärammaki, éntok chíkti em jüneerimaki. Juka yoremta emo beu anemtë em emo ériä bénasi ä náknake.” ");
INSERT INTO mfy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Huanäi jü Jesús ínel áu jiaahuak: —Tüise ä yómmiak. Íkäre yáuhua; huanäre jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Të áapo tüisi áu tahuaria báreka, Jesústau ínel jiaahua: —¿Jábesu jü yoreme ino beu aneme? ");
INSERT INTO mfy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús, ä yómmiaka, ínel áu jiaahuak: —Senu yoreme buere joära Jerusalén bétana pueblo Jericóu kóm huéiyey, huanäi jume lak‑ronim mámpo huétchek júmëi béja sïmeta ili ä huériäu ä úhuak; kökosim ä yáaka sájjak, huanärim tamurata áma tö sájjak. ");
INSERT INTO mfy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Huanäi éntok sacerdoote tiöpopo tékiakame Jerusalén bétana két huäri böot kóm huéiyey. Huanäi ä bíchaka ä naj‑riak. ");
INSERT INTO mfy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Huanäi két senu leviita tiöpopo tekipanuame áman áu jëla huéekasu, éntok ä bíchaka, sékäna áman siika. ");
INSERT INTO mfy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Të senu Samaria buiärapo jometaka, két boojoakari, áu jëla yepsak, éntok ä bíchaka, ä jiápsipo tüisi ä jiokoleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Áu rúkteka kökosä ayuläpo, aceitey éntok vinoy ä jíttok. Huanäi ä kábäit jikachä yéchaka, ä núk siika. Mesooniu ä tójjak, éntok ä suayak. ");
INSERT INTO mfy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yokoríapo béja sim báreka, tómita ä bóosapo yeu huíkkek, guoy taahuari tékilta huéeläpo. Huanäi juka mesompo tékiakamta ä mákkak, éntok ínel áu jiaahuak: ‘‘Nechë ä suayaria. Bueïtuk huate tómita át kimako, ínapone nóttek enchi ä béjtuanake.” ");
INSERT INTO mfy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bueïtuk, ¿jábesu ímëi bájimpo chë emo beu aane jume lak‑ronim mámpo huéchekamtau huám sájakame? ");
INSERT INTO mfy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Áapo ínel jiaahuak: —Jü ä jiokoleka tühuata áu yáakame. Huanäi béja jü Jesús ínel áu jiaahua: —Sikë két ánëli áayu. ");
INSERT INTO mfy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Júnel két yeu siika: Jesústa böot huéekasu, senu pueblou yepsak. Senu jámut Marta ti téhuaaka ä jóapo ä mabetak. ");
INSERT INTO mfy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ïri María tíamta huayekay. Huäri béja Jesústa guókpo yejteka, ä nokäu jíkkajay. ");
INSERT INTO mfy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Të jü Marta éntok kaa yúmaka jita johuay, yún jita tékilta jípureka. Huanäi áu rúkteka, ínel jiaahua: —Señor, ¿jache kaa át suuhua, jü ín huayibechi? ¡Kaa nee aniaka jita johua! Nechë ä ania sáuhue. ");
INSERT INTO mfy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús ä yómmiaka, ínel áu jiaahua: —Marta, Marta, yünë jita kaa náksi joaka, kaa át yuuma, ");
INSERT INTO mfy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","të senu huéeme jíba chë bát huéiye. Jü María juka chë türik áma yeu púala. Júkäi béja kaabe kaibu ä úhuaana. ");
INSERT INTO mfy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Séjtul Jesús Diostau nookay. Huanäi béja áu noksuka, senu ä disciipulo ínel áu jiaahua: —Señor, itomë Diostau nok majtia, Juanta ä discíipulom ä majtiakä bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Huanäi ínel ámeu jiaahua: —Eme Diostau nokäteko, ínëlem jiaunake: Itom Átchay téhuekau kátekame, em téhuam yöreka am noknake. Éläpo em reytaka nésahuepo äbo ito násuk yebijnake. Em nésau yáatunake, téhuekau bénasi, ímï buíapo két jíba ánëli, áman bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jume páanim chíkti táapo itom buäyëhui, entok én itom buänakëhui itome am mákka. ");
INSERT INTO mfy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Itom Dios bejrimmeche itom jiokore, bueïtuk ítapo két am jiokore jume itom huikiriame. Katë kaa türikum bíchaa itom táktia, ál‑lë itom áma yeu huíkke. ");
INSERT INTO mfy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús ket ínel jiaahuak: —Jábesu eme senu amiigota jípureka, tukaa násuk ä jóau ä yepsako ínel áu jiaunake: ‘‘In amigo, báij páanime nee réuhua. ");
INSERT INTO mfy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Bueïtuk senu ín amigo ín jóapo yebij‑la, mékka bétana huéeka, éntokne kaita ä äboj mátchi.” ");
INSERT INTO mfy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Huanäi huäri, béja huáijhua jákun ä yómmianake, ínel áu jíaka: ‘‘Katë múksi nee bitcha. Jü puerta béja páttiari, éntok jume ín usimne núk böka. Karane yejteka enchi ä mákka, juka em huáatiähui.” ");
INSERT INTO mfy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ínapo én ínel jiaahua: Éläposu kaa yejteka kaa ä mákka, ä amiigoka junne. Të jamak múksi ä bíchä béchïbo, yejteka ä máknake, sïmeta juka ä huáatiähui. ");
INSERT INTO mfy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bueïtuk ínapo én enchimmeu ínel jiaahua: Jítem aahua huanärem mikna; jítem jaria, huanärem ä téunake; puertatem popona, huanärem ä étaporiana. ");
INSERT INTO mfy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bueïtuk sïme jita aahuame, ä mabetnake; jü ä jariame ä téunake; jü puertata poname, ä étaporiana. ");
INSERT INTO mfy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Jachu jábe júne áchayhuari enchim násuk, ä üusi páanim aahuayo, tétata ä miknake jäni? O, ¿chë kúchuta ä aahuayo, kúchuta ä mik ïaakasu, bakotta ä miknake jäni? ");
INSERT INTO mfy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, ¿tótori kábata ä aahuayo, machilta ä miknake jäni? ");
INSERT INTO mfy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Eme jujjuënaka junne, ára türik enchim usim miika. ¡Hua itom Átchay téhuekau kátekame chë ä miknake, juka Espíritu Santota jume áu ä aahuame! ");
INSERT INTO mfy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús yorem múurotat lemooniota yeu jaasey. Huanäi juka lemooniota át yeu simsuko, jü múuro ára nokaka taahuak. Jume áma aneme éntok tüisi át guómtilataka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Të huate bempörim násuk ínel jiaahuak: —Ïri yoreme, Beelzebúu lemooniommeu yäurata úttiäray yeu am bébba, jume lemooniom. ");
INSERT INTO mfy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Huate éntok kaa tüisi ä tahuaria báreka, téhuekau bétana señalta áu aahuay. ");
INSERT INTO mfy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Të áapo am jüneriaka jita éerita am jípurëu, ínel ámeu jiaahuak: —Jábe reyta nésahuepo kaa tülisi náu éaka tekipanoäteko mójaktinake. Két senu familia élaka náu nássuame, emo näikimtena. ");
INSERT INTO mfy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Júnëli két jü Satanás áu näikimtekätek, ¿jáchisu ä reytaka ä nésahuepo jíba béchïbotunake? Bueïtuk ínëlem jiaahua emëe: Beelzebúuta úttiäray nee jume lemooniom yeu bébä tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Enchim jiäpo ámani, ínapo Beelzebúuta téhuampo yeu am bébäteko, jume lemooniom, ¿jume enchim üusim jábeta nokposum yeu am bébba? Huäri béchïbo, bempo enchimmeu yäuchimtunake; juka enchim kaa tüisi yáari enchim yuktirianake. ");
INSERT INTO mfy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Të ínapo Diosta úttiäray jume lemooniom yeu bébäteko, kaa báreka júnem tüisi át suuhua, jü Diosta reytaka ä nésahueu enchimmeu yebij‑la. ");
INSERT INTO mfy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Jü yoreme úttiakame, tüisi huíköreka, ä kári suaya. Sïme jita áma ayukamtau, kaita áu huéenake. ");
INSERT INTO mfy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Të senu áa béppa chë úttiakame áu yepsakätek, ä kobanake. Huanäi huaka sontaro áttiata éntok huiköta ámechä éäu ä úhuaanake. Huanäi huatemmet ä näikimtenake, juka nássuaka ä yöokähui. ");
INSERT INTO mfy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Jü kaa ínomak huéeme, nee béj‑reka huéiye. Jü kaa ínomak jita náu yéchame, ä chíbejtia. ");
INSERT INTO mfy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Jü lemoonio chïcha machi yoremtat yeu sikätek, jum huaki ániapo naa huéenake, ják ä jimyorenakeu jariaka. Kaita téak éntok, ínel jiaunake: “Júchine ín jóau huée báare, ín yeu sikähui.” ");
INSERT INTO mfy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Huanäi áman yepsakäteko, chíchikta éntok huechiasi tülisi yáata téunake. ");
INSERT INTO mfy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Huanäi sika júchi guoy búsan lemooniom chïcha machim áa béppa chë juejuënam nüpanake. Huanäi sïme huame yoremtat kimuka, ä jiápsipo jóatenake. Huanäi huäri yoremtau chë júne kaa tüisi huéenake, bannaataka béppa. ");
INSERT INTO mfy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Juka Jesústa ínëli nokaysu, senu jámut jum genteta násuk cháchayek: —¡Tua úttilsi maachi, enchi yeu tómtiriakame, éntok enchi chïtuakame! ");
INSERT INTO mfy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Të áapo ínel áu jiaahuak: —¡Úttilsi maachi, chë junne, jume Diosta noki jíkkajame, éntok ä joame! ");
INSERT INTO mfy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jü génte jíba bénasi Jesústau náu yájjay. Áapo éntok ínel ámeu jiaahuay: —Ï génte én huéeme tüisi juëna, kíalïku señalta kaa jaibu johuamta bít rókka; të kaachin täbui señalta bíttuana huaka profeeta Jonásta señal jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jáchin hua Jonás jume géntem buere joära Nínivepo joomem béchïbo señaltukaïhui, alë bénasi két ínapo, ínapo jü Yoremta Üusi ket jü génte én kat‑riata béchïbo señaltunake. ");
INSERT INTO mfy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jü reina suuriu joome áu tóboktianake, ímëi yoremem én kat‑riam béj‑reka, juka lútüriata am yuktiria báreka, éntok nokta béttek ámet chúpanake. Bueïtuk áapo ániata nahuau bétana áman yepsak, juka rey Salomónta ujyorisi jita täyäu jíkkaijseka. Ímï éntok aane, huépülaika Salomónta béppa chë yörisi machika. ");
INSERT INTO mfy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jume yoremem Nínivepo jomeme emo tóboktianake, ímëi géntem én kat‑riam béj‑reka, juka lútüriata am yuktiria báreka, éntokim két nokta ámet chúpanake: Bueïtuk hua génte Nínivepo joome jíapsi kúaktek, Jonásta huaka nokta Diosta bétana huémta ámeu ä nokako. Të én ímï chë Jonásta béppa yörisi machika aane. ");
INSERT INTO mfy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Kaabe juka machiriata táalataka ä ëeso, éntok cajónta bétuk junne, kaa ä öore. Ál‑la jum jikat chöla ä órenake; jume áman kimume juka machiriata bínnake. ");
INSERT INTO mfy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Em pusim senu lámparata bénasi maachi, em takahua béchïbo. Jume em pusim türiako, em takahua két sïmekut tülisi machiriata jípunake. Të jume em pusim kaa türiako, jü em takahua két kaa machiku annake. ");
INSERT INTO mfy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Áachë suuhua, jü machiria emót ayukame em emo jípurë tíäu jamak kía kaa machiria. ");
INSERT INTO mfy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Júnëli béja, juka sïme em takahua machikuy tápuniatuko, kaita senu lébelay júne kaa machiriata jípurëteko, sïme tülisi kálajkosi machitunake, lámparata tüisi úttiaka enchi boojoria bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Juka Jesústa ámeu noksuk, senu pariseero ä jóau ä jïbuä núnnuk. Jesús éntok áman yepsaka, jum jóau kibakeka, mesau yejtek. ");
INSERT INTO mfy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jü pariseero át guómtilataka taahuak, kaa áu báijmatuaka, ä jïbuä táytekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Të jü Señor ínel áu jiaahuak: —Eme jume pariseerom juka vaasota yeutana jíba ä bábaksia, éntok juka puraátota. Të jum huáijhuatanam ái tápuni jü kaa tíurayi, éntok jita juëna éeriyi. ");
INSERT INTO mfy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tóktem kaa susuak! ¿Jachem kaa jüneiya, huaka yeutana huémta yáakamta két huaka huáijhua huémta yáala? ");
INSERT INTO mfy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Të eme enchim tü jiápsipo ayukamtayi, jábetem jita miika. Júnëli sïme tü huénnake. ");
INSERT INTO mfy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Obiachisi enchimmeu chäka, eme pariseerom! Bueïtukem huaka sehua óguota menta, jum cientopo guoj mamnik Diostau bíchaa nanäikia. Alë bénasi juka rúuda tíamta, éntok sïme ili júya buabuähuamta. Tem huaka lútüriata omoutela, éntok huaka Diosta nákhuamta. Íkäri éntok juka senuk júne katem ä koptia éiyey, sïmetem nanahuit boojoria éiyey. ");
INSERT INTO mfy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Obiachisi enchimmeu chäka, eme pariseerom! Bueïtukem jum tiöpopo náu yayaijhuäpo jume bankom bát órekame nákke, éntokem huam böommet yörisi machisi emo tebotua ïaa. ");
INSERT INTO mfy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Obiachisi enchimmeu chäka, eme jume leyta am majtíame éntok pariseerom, ára nókïchiaram! Bueïtukem huame cajón ánimakame mäari bénasi maachi. Jume yoremem éntok áme béppa naa rejte, kaa jünéaka. ");
INSERT INTO mfy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Huanäi senu leyta mamajtíame ínel ä yómmiak: —Maestro, empo íkäi nokaka itomë két tiusi bëa. ");
INSERT INTO mfy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús ínel jiaahuak: —¡Obiachisi enchimmeu chäka, eme leyta majtíame! Bueïtuk huame yoremem béttesi püaktitua. Júkäi püaktita jábe yoreme júne kaa ä yuuma. Eme éntok, kía huépul sútuy júnem kaa át jálo jálojte. ");
INSERT INTO mfy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Obiachisi enchimmeu chäka! Bueïtukem jume profeetam béchïbo bóoberam jojoa, huame enchim yoiyöhuam súakähui. ");
INSERT INTO mfy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bueïtuk eme ä bitchak, enchim yoiyöhuam yáarimmak emo al‑leä tía báare. Bueïtuk bempo am súhuak, eme éntok bóoberam am joria. ");
INSERT INTO mfy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Kíalïku jü Dios ä jüneeräpo ínel jiaahua: ‘‘Profeetam éntok apóstolimne ámeu bíttuanake. Tem huatem súanake. Huatem éntokim guojajjanake.” ");
INSERT INTO mfy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Júnëli béja ï génte én kat‑riammet béppa yéchatunake, jume sïme profeetam ójbo guötialame jauhuey ániata naatekäpo naateka, ");
INSERT INTO mfy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelta ójbopo naateka Zacaríasta ójbou tájti, altarta éntok buere tiöpota náu násuk mukukame. Jeehui, énne ínel jiaahua, jü génte én kat‑riat át huénnake; huamei ä yómmianake. ");
INSERT INTO mfy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Obiachisi enchimmeu chäka, eme jume leyta mamajtíame! Bueïtukem jita täyahuamta llavem ésola. Të eme júne kaa áman kiimu, éntok kía huatem júne kaa áman kimutua. ");
INSERT INTO mfy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Juka Jesústa íkäi ámeu nokay jume leyta am majtíame éntok jume pariseerom tüisim áu öomteka taahuak. Huanärim juebenak jita áu nátemajey, éntokim tüisi yún ä noktuay. ");
INSERT INTO mfy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Akim ä aamuy jita ä nokähui, ili ä rábiktek ä nokäpo, júmüri béja ä nätua báreka. ");
INSERT INTO mfy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tepa may kaa náksi büru génte náu áu tójjak. Kíalim nat tétteney. Huanäi Jesús ínel jiau táytek, të jume ä discíipulommeu bátchu: —Jume pariseerom levaduura bétanem emo suaya; jüri ínel kía áu tü yórem tíaka täbuiasi áu nüye. ");
INSERT INTO mfy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bueïtuk kaita éhuil ésotaka ják ayka, kaa yeu machinakeme. Éntok kaita éhuiltaka ayka, kaa jüneriatunakeme. ");
INSERT INTO mfy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Huanäri, sïmeta kaa machiku enchim nok‑läu, machiku jíkkaijtunake. Éntok sïme nákapo éhuil nok‑ri, mékka kárit jikat jáptehuaka chayna. ");
INSERT INTO mfy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Éntokne két ínel jiaahua, ín amiigom: Katem juka takahuata mëamta májhue. Huäri béppam béja kaita éntok ára yáaka taahua. ");
INSERT INTO mfy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tëne enchim majtianake, jábeta enchim máujnakëhui. Huakärem májhue, huaka jíapsita enchim úhuaasuka, ä úttiarimmea jum tájiu ára enchim kóm jímma. Jeehui, ínapone enchimmeu ínel jiaahua, íkärem májhue. ");
INSERT INTO mfy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Jachu kaa mamni huikichim guoy tómipo nénenkihua? Të jü Dios kía huépülai júne kaa koptia. ");
INSERT INTO mfy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bueïtuk jume em chonim júne sïme näikiari. Katem májhue, bueïtuk eme chë júne béj‑re, juebena huikichim béppa. ");
INSERT INTO mfy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Énne ínel jiaunake, hua jábe junne yoremem anëpo nee áu täya tíame, ínapo jü Yoremta Üusi inone ä täya tíanake, Diosta ángelesim bíchäpo, ");
INSERT INTO mfy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","të jü kaa nee áu täya tíame yoremem anëpo, ámani Diosta ángelesim bíchäpo két kaa täyana. ");
INSERT INTO mfy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Kía jábe junne Yoremta Üusi béj‑reka nokame, jiokoritunake. Të hua Espíritu Santota béj‑reka nokame, jauhuey júne kaibu jiokoritunake. ");
INSERT INTO mfy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Huam tiöpopo náu yayaijhuäpem yeu tóijhuak, yäurata bíchäpo, katem jáchin éiya, jáchin enchim am yómmianakëhui, éntok jáchin enchim jiaunakëhui, ");
INSERT INTO mfy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","bueïtuk horata yúmak jü Espíritu Santo enchim majtianake, jita enchim noknakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Senu juebenam násuku, Jesústau ínel jiaahuak: —Maestro, ín sayibehuë nooka. Juka itom átchay itou tö mukukähui, ínomake ä näikimte sáuhue. ");
INSERT INTO mfy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Të áapo ínel ä yómmiak: —Ómme, ¿të jábesu jita näikimte béchïbo enchimmeu nee yäut yéchala? ");
INSERT INTO mfy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Huanäi ínel ámeu jiaahua: —Tüisem át suuhua. Katem úttesi jita yún jípuhuamtat kopti báare. Jü yoremta jiapsähui kaa yún jita jípuhuamtat aayuk. ");
INSERT INTO mfy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Huanäi íkäi ejemplota ámeu yétchak: —Senu yoreme rikotaka ím aaney; ä buíampo tüisi jíchupaka. ");
INSERT INTO mfy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Huanäi hua riko juebenak ée táytek: ‘‘¿Jáchisune ayunake jäni? ¡Kaitäpone ä kima mátchi, juka ín chúpakähui!” ");
INSERT INTO mfy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘‘Én ál‑lane jüneiya jita ín yáanakëhui”, ti éiyak. ‘‘Jume kárim ín jípurëu áma jita ín kíkkimähui, anam tátabeka chë júne bueerem yáanake. Huanäine sïmeta huaka ín chúpakäu ërianake, éntok sïmeta huaka ín én jípurëhui. ");
INSERT INTO mfy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Huanäine ín jíapsibeu ínel jiaunake: In jíapsi, juebenak jíte ëriala, juebena huásuktiriam béchïbo. Jimyorëe, jïbuäe, jëyëe, emoë al‑leetua.” ");
INSERT INTO mfy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Të Dios ínel áu jiaahuak: ‘‘¡Kaa suära! Én ï tukaarichi em jíapsi äbo émou aübaahua. Jü jita em náu tóij‑ri, ¿jábesä áttiaka tahuanake jäni?” ");
INSERT INTO mfy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Júnëli áu huéenake hua yoremtau buéresi jita áa béchïbo náu tójamtahui. Diostau bíchaa éntok, jita júne kaa jípure. ");
INSERT INTO mfy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Huanäi sep ä discíipulommeu ínel jiaahuak: —Huäri béchïbone ínel enchimmeu jiaahua: Katem úttesi kaa yúmasi emo éetua: ‘‘Ímï jíapsihuamta bétana, ¿jítasute buänake? ¿Takahuata béchïbo junne, jítasute sánkonake?” ");
INSERT INTO mfy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huä jíapsihuame chë béj‑re, buähuamta béppa; éntok hua takahua chë béj‑re, sánkota béppa. ");
INSERT INTO mfy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jume kaaktërammechëm suuhua. Kaa ëechaka junne, éntokim kaa etta tobotoboktia. Éntokim kaitapo ä nü machik jípure. Toroosam ják bem ä huáttia machikim kaa jípure, éntok Dios am jïbuätua. ¿Jachem kaa chë béj‑re huikichim béppa? ");
INSERT INTO mfy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jábesu hua enchim násuk aneme tüisi áu bamijtuaka méedio metropo ára áu yöturia? ");
INSERT INTO mfy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bueïtuk kía huaka ilikkik júnem kara joätek, ¿jatchiakem huatekut emo bamijtua? ");
INSERT INTO mfy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Áachem suuhua, jáchisu jume sehuam líiriom yötu. Huame kaa tekipanua, éntokim kaa jíjjoa. Tëne ínel enchimmeu jiaunake, hua rey Salomón kía sïme ä ujyóriay júne kaa huame bénasi áu sánkotuak. ");
INSERT INTO mfy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Të ínëli Dios ä sásankotua juka júyata huajpo ayukamta. Yokoríapo éntok ornopo táana. ¿Jachu eme kaa chë júne tülik sánkotuana, yoremem kaita súalëram? ");
INSERT INTO mfy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eme, bueïtuk, katem jáchin át éiya, jita enchim buänakëhui, éntok jita enchim jïnakëhui. Katem kaa yúmasi emo éetua. ");
INSERT INTO mfy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bueïtuk sïme jü génte ím ániapo jiápsame, íkäi sïmeta guojaase. Të eme huépülak Áchayek, jüneamta jita enchimmeu bëyëhui. ");
INSERT INTO mfy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Juka Diosta reyta nésauritem bát jaria. Huanäi sïme jü huate béja kía áapo élaka enchimmeu yebijnake. ");
INSERT INTO mfy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Katem májhue, eme ín kabaram. Eme ilikki, të jü enchim Átchay reytaka ä nésahuepo enchim ä mák péaka enchim ä mákka. ");
INSERT INTO mfy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Huaka enchim jípurëu nénkakem poloobem miika. Júnëlem bóosam kaa momoyeme emo yáarianake, éntok chë béj‑rek téhuekapo ayukame kaa lülütemta, áman lak‑ronta kara kibakepo, éntok téepärim kaa ä momoiyäpo. ");
INSERT INTO mfy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bueïtuk jita enchim áttiata jípurëpo, huämi annake, jü enchim jíapsi. ");
INSERT INTO mfy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Katem koptel‑la. Tülisem sánkotelataka, enchim lámparam táalataka aane. ");
INSERT INTO mfy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Huame sáyhuame bénasem emo jípure, bem teko jubiahua bétana nóttëu boobíchaïhuimta bénasi. Ä yepsak puertata ä poponak sep ä étaporianake. ");
INSERT INTO mfy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Al‑leenakemme, huame sáyhuame, jü bem tekohua yepsaka kaa kócheme téako. Lútüriapone enchimmeu ínel jiaahua: Huä bem tekohua, áapöisu jita áu huikojtuaka, mesau am jóaka am äbojnake. ");
INSERT INTO mfy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kía tukaa násuk huéy yepsak junne, éntok kía marikaroapo yepsak junne, kaa kócheme tíakätek, huame sáyhuamet al‑leehuari áme béchïbotunake. ");
INSERT INTO mfy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Senu huémtachem suuhua: Jü yoreme jóapo nésahueme jüneätek ják horapo juka lak‑ronta áma yebijnakeu, kaibu kónnake, éntok kaibu juka kári puertata étapona, áma ékbuanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eme kéchem kaa kótche. Bueïtuk kaa ínel enchim éäposu, ínapo jü Yoremta Üusi yebijnake. ");
INSERT INTO mfy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Huanäi jü Peero ínel ä temajek: —Señor, ¿jache íkäi ejemplota ito béchïbo nooka, o sïmem béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jü Señor ínel ä yómmiak: —Bueïtuk, ¿jábesu júntuk hua móoroma nésauta joame éntok jitat jüneame, ä tekohua jume ä jóapo aneme béppa yechanähui, huam tua horapo am jïbuätuanakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Huä sáyhuame tua tüisi al-leenake, ä teko yepsako, huaka nésauta joaka téihuakame. ");
INSERT INTO mfy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Të lútüriapone ínel jiaahua, sïmeta ä áttia béppa ä mámpo ä yéchanake. ");
INSERT INTO mfy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Të huäri sáyhuame ä tekohua kaa läuti yebij máchileka, jume tekipanualerom éntok jume jáamuchim jóapo sáyhuame béttesi ámemak huée táytekätek, éntok kía buähuamta huíutia táytek, éntok vino jëyeka naamuk táyteko, ");
INSERT INTO mfy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","huanäi jü ä tekohua yebijnake, hua taahuari kaa áachä boobit‑huäubechi, éntok ják horapo jäni kaa ä jüneriahuäpo. Huanäi béttesi nokta át chúpanake, éntok jum kaa tühuata joammak ä näikianake. ");
INSERT INTO mfy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Huä sáyhuame jüneame jita ä tekohua huáatiäu, éntok kaa ä sáyhuä páman anëtek, tüisi bépsunake. ");
INSERT INTO mfy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Të jü kaita täyaka kaa huéchiasi ayukame, két bépsunake, të kaa tua tüisi. Bueïtuk hua jábesu yún jita mákhuakame, yún jita áu huáatiana, éntok hua yún jita suayatuahuame, chë yún jita áu auna. ");
INSERT INTO mfy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ínapo táijta yáaseka ím ániau äbo kóm siika. ¿Jítasune huáatia? ¡Bueïtuk jamak béja béete! ");
INSERT INTO mfy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Senu batörihuat kaa báreka júnene batönake. ¡Tepane kaa al‑leiya inochä chúpëu tájti! ");
INSERT INTO mfy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Jachem yánti anhuamta ím ániapo nee nüpakä bénasi éiya? Ëe, tine enchimmeu jiaahua. Ál‑la jume géntem chíbela emo näikimtehuamtane nüpa. ");
INSERT INTO mfy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Én ímï naateka, huépü jóapo mamnika annake, kaa náu anisi éaka. Bájika jume guoyimmak kara jíapsinake, jume guoyika éntok, jume bájimmak két alë bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jü áchayhuari ä üusimmak kara emo bínnake; hua usiari éntok, ä átchay két alë bénasi. Huä áyehuari ä jámut asoamak kara emo bínnake; hua jámut asoari éntok, ä áyemak kétchi. Jü asuhuari ä jakaray két kara bínna; hua jakarayria éntok, ä asu két alë bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús jü gentetau éntok két ínel jiaahuak: —Jum täata áman huéchë bétana, namuta yeu huéy, sepem ínel jiaunake: ‘‘Bäa äbo huéiye.” Éntok ínel yeu sisime. ");
INSERT INTO mfy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sur bétana jekay éntokem ínel jiaunake: ‘‘Tátta báare.” Huanäi ínel yeu sisime. ");
INSERT INTO mfy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Eme ára nókïchiram! Jüneäem jita huéenakeu jum téhuekapo, éntok jum buíapo. ¿Maasem íkäi tiempota én ito át anëhui kaa ä jüneria? ");
INSERT INTO mfy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Jatchiaka eme kaa náu nokaka lútüriata emo yáaria? ");
INSERT INTO mfy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jábetë yäurau enchi nätuak böochë bát áamak ejtejhua, ä tüte béchïbo, juka kaa enchim át yumähui, huam yäurata bíchäpo kaa enchi yeu ä tóijnakë béchïbo. Bueïtuk júneltuk hua yäura policíata mámpo enchi yéchanake. Huäri policía éntok cárcelpo enchi páttianake. ");
INSERT INTO mfy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Enchine téjhua, huämirë kaa yeu huéenake, kaa huaka sïme tómita em áma huikiriähui em béjtuäu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Huámechi taahuarimmet huate Jesústau yájaka, áhuim ejtejhuak jáchin juka Pilatota jume huate yoremem Galiléa buiärapo joomem ä súakähui, éntok jáchin juka bem ójbohuata animaalim ójbomak ä kuutiakähui, jum bem animaalim sússuaahuäpo. ");
INSERT INTO mfy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Huanäi Jesús ínel am yómmiak: —¿Jachem ínel éiya, ímëi galileommeu kaa tühua ámeu siika, bem kaa tü yóremem béchïbo, sïme galileom béppa? ");
INSERT INTO mfy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ëe tine enchimmeu jiaahua. Eme júne kaa jíapsi kúaktek, kéchem sïmetaka áme bénasi kókkonake. ");
INSERT INTO mfy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O, ¿huame dieciochotaka kókkokame, Siloéepo kári buëuru nat béppa jokame, ámet huéchekähui, eme huamei chë júne cúlpak téiyey, jume huate yoremem Jerusalémpo jóakame béppa? ");
INSERT INTO mfy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ëe tine enchimmeu jiaahua. Eme júne kaa jíapsi kúaktek, kéchem sïmetaka áme bénasi kókkonake. ");
INSERT INTO mfy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús huanäi íkäi ejemplota ámeu yétchak: —Senu yoreme chuna óuguota ä buíapo kéchalatukay. Huanäi áman sika takata át jariaka, kaita át téuhuak. ");
INSERT INTO mfy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Huanäi hua yoremtau buíata suayamtau ínel jiaahuak: “¡Juyu! Báij huásuktiapone nat chätuka äbo yeyepsa, ï óuguou, jume takam jariaka. Tëne jauhuey júne kaita át téuhuak. Akë ä chúktia. ¿Jáchisen kía béja buíata jínëulatunake?” ");
INSERT INTO mfy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Të hua buíata suayame ínel ä yómmiak: ‘‘Señor, Akë ä tójja, íäri huásuktiriat junne. Buíatane ä buálkoteria báare, éntokne ä tü tátabnakemta áu óre báare. ");
INSERT INTO mfy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Takak júne türinake, kaa ä takak éntoke ä chúktianake.” ");
INSERT INTO mfy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sábalapo jimyore táapo am majtiay jü Jesús jum tiöpopo. ");
INSERT INTO mfy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Senu jámut áma aaney, lemoonio kökoata jípureka dieciocho huásuktiapo; ókola chäka jíba hueramay. Kaachin ayuka áu rútuktia máchiakay. ");
INSERT INTO mfy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jü Jesús éntok ä bíchaka, áu ä rúkti sáuhuek. Huanäi ínel áu jiaahua: —Empo jámmut, em kökoa bétanë búttiaritaka taahua. ");
INSERT INTO mfy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Huanäi áa béppa mámtek. Huämi horapo hua jámut rútuktek. Huanäi Diosta úttil táytek. ");
INSERT INTO mfy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Të jü tiöpopo tua nésahueme, Jesústa sábalapo ä tütek tíaka, jume sïmemmeu ínel jiaahua: —Búsan taahuarim aayuk, ámet tekipanoä béchïbo. Huamechï taahuarimmechem äbo kaate. Huanäem emo jíttotebo, të kaa jimyore táapo. ");
INSERT INTO mfy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Huanäi jü Señor ínel ä yómmiak: —¡Empo ára nókïchira! ¿Eme jábe júne jachem kaa enchim bues o buruta butbúttia jimyore táapo, bäam ä jïtua béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Íkäi jámutta, két Abrahamtat yeu simlamta Satanásta súmalatukaïhui jum dieciocho huásuktiapo, ¿jachu kara búttiatui jäni ï kökoata bétana, jum jimyore táapo? ");
INSERT INTO mfy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Juka Jesústa ínëli jíak, sïme huame áu omteme titihuek. Të hua sïme génte al‑leiyay, huaka Jesústa buéresi ä joäu bíchaka. ");
INSERT INTO mfy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Huanäi Jesús ínel jiaahua: —¿Jíta bénasa, jü Diosta reytaka ä nésahuepo? ¿Éntok jita bénasite ä bínnake? ");
INSERT INTO mfy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jü mostaaza báchiata senu yoremta ä buíapo echakä bénasi maachi. Yötuka béja júya bueürusi ayka, jume huikichim jikat rejteme ä mésëkiriammechi tosatek. ");
INSERT INTO mfy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ínel két ámeu jiaahua jü Jesús: —¿Jíta bénasite ä bínnake jäni, juka Diosta reytaka ä nésahuepo? ");
INSERT INTO mfy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Juka levaduurata senu jámut senu quintal hariinammak náu kuutiakä bénasi maachi, juka sïme hariinata buaatiata huénnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús pueblommechi éntok ranchommet huéiyey, am majtiasimeka, buere joära Jerusaléniu bíchaa, éntok laulauti ansimey. ");
INSERT INTO mfy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Senu éntok ínel ä temajek: —Señor, ¿katim jaiki jume jínëurim? Áapo éntok ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Úttiatem yáuhua jum puerta ilikkani páman kimu béchïbo, bueïtuk ínel enchimmeune jiaahua, juebénakam áman kimu báanake, tem kaa áma yúmanake. ");
INSERT INTO mfy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Chúkula juka jóakamta yejteka juka puertata ä páttiak, eme päku tahualame juka puertata ponaka ínel jiaunake: ‘‘Señor, Señor, Akë ä étapo.” Të áapo ínel enchim yómmianake: ‘‘Kanne jüneiya jákunem joome jäni, éntokne kaa enchim täya.” ");
INSERT INTO mfy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Huanärem ínel jiau táytinake: ‘‘Émomakte jïbuäla, éntokte émomak jïla, éntok empo itom majtiala huam itom pláazapo.” ");
INSERT INTO mfy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Të áapo ínel enchim yómmianake: ‘‘Béjane enchim téjhuak, kanne jüneiya jákun enchim jometukähui, éntokne kaa enchim täya. ¡Mékkem kaate, eme kaa türik jíba joame!” ");
INSERT INTO mfy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ámanï béja huéenake jü buanhuame éntok támim kumhuame, juka Abrahamta bíchaka, Isaacta, Jacobta, éntok sïme huame profeetam Diosta bétana nokame jum Diosta reytaka ä nésahuepo aneme. Eme éntok päku yeu tahuanake. ");
INSERT INTO mfy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bueïtuk génte yáijnake täata yeu huë bétana, täata áman huéchë bétana, norte bétana, éntok sur bétana jum mesau jote báreka jum Diosta reytaka ä nésahuepo. ");
INSERT INTO mfy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Huanäi huate jume amáu kateme bát kannake. Huate bát kateme éntok amáu kannake. ");
INSERT INTO mfy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Huäri taahuarit huate pariseerom yájaka ínel áu jiaahua: —Ímë yeu huéiye, bueïtuk jü rey Heroodes enchi mëbáare. ");
INSERT INTO mfy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Të áapo ínel am yómmiak: —Ámanem sájaka ínel áu jiaahua jü kaa tihueratahui: “Ëni éntok yokone jume lemooniom yorem jiápsipo yeu bébnake, éntokne jume kökoreme tútenake. Huanäine báij taahuarim huéy ín tékil chúpanake.” ");
INSERT INTO mfy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Júnentaka junne, ëni éntok yoko, éntok machuko jíbane huéepo yúmala ín böo huériaka, bueïtuk kaa áma huétche, juka profeetata Jerusalémpo päku ä muknakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén pueblo, Jerusalén pueblo, émpë jume profeetam Diosta bétana nokame sússuame, éntoke tétammea am mamaasula jume émou bíttuarim! Jaikisisune kaa émou jiop‑la em usim náu tóij báreka jáchin juka tótorita ä masam bétuk ä asölam náu ä totojä bénasi, enchimne náu tóij bábarek, të katem báarek. ");
INSERT INTO mfy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Áachem suuhua, eme, bueïtuk enchim jóa silasoola tahuanake, éntokne enchim téjhua, katem júchi nee bínnake, júnak taahuata yúmak jübua, ínel enchim ino bétana jiaunakëhui: ‘‘¡Tüisi mabettunake jü Señorta téhuampo äbo huéeme!” ");
INSERT INTO mfy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Senu huéeme yeu siika, jum jimyore táapo. Jesús senu pariseero nésahuemta jóau ä jïbuäsek. Huate pariseerom ä jojottuay. ");
INSERT INTO mfy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huämi két senu yoreme aaney, ä bíchäpo kökoreka, ä takahuapo bäa bóosam jípureka. ");
INSERT INTO mfy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Huanäi jü Jesús jume leyta am mamajtiammeu éntok jume pariserommeu nookak, ínel jíakari: —¿Jachu áma huéche jäni jimyore táapo senuk tüte béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huanäi bempo kaa jíalek. Huanäi áapo, juka kökoremta nüka, ä tütek. Huanäi ä simtuak. ");
INSERT INTO mfy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jume pariserommeu ínel jiaahuak: —¿Jábetaka junne, enchim násuku, juka ä buruhua o buesta posopo kóm huétchek, kaa läuti yeu ä huíknake jäni? Éläposu jimyore taahuari. ");
INSERT INTO mfy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Huanärim kaachin ä yómmia máchika taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jü Jesús jume néjunrim bíchaka jáchin huame bankom chë nésahueme béchïbo näikiarim yeu púay, íkäi ejemplota ámeu yétchak, ínel jíakari: ");
INSERT INTO mfy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Empo bóodau núnutuko, katë banko bát jokammet yeyejte, bueïtuk jamak senu yoreme emo béppa chë yörihuame áma yebijnake. ");
INSERT INTO mfy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Huanäi áma ä yepsako jü enchim náhuichim néjúnekame ínel émou jiaunake: “Íkäe júkäi bankota mákka.” Huanäre titihueka mékka amáu yejtenake. ");
INSERT INTO mfy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ál‑lë néjunhuak, áman amáu yejte, huaka enchi néjúnekamta yepsak ínel émou jiaunakë béchïbo: “Empo ín amigo, äbe huéeka jume banko yeu púarim näikiarimmet yeesa.” Huanärë ä mabetnake, hua chë em yörihuähui, huame mesau émomak jokame bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bueïtuk hua chë áu buérialeme kóm tahuanake, hua bétuk áu jípureme éntok tóboktiatunake. ");
INSERT INTO mfy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Inen két áu jiaahua hua ä jïbuä núnukamtahui: —Senukë jïbuä núnukätek, katë em amiigom, em saayim, em huahuayim, em veciino rikom náu núnnu, bueïtuk bempo két enchi jïbuä núnunake. Huanärë ä béjtuatunake. ");
INSERT INTO mfy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ál‑lë äboj bárëteko buähuamta yáaka, póobeme náu núnnu, éntok jume mám lolöim, guók lolöim, éntok jume liliptim. ");
INSERT INTO mfy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huanärë tüisi tahuanake, bueïtuk bempo kara enchi béjtua. Tërë huame kókkolam tühuata jájamlame jíabite taahuarit ä mabetnake, juka béjtuahuamta. ");
INSERT INTO mfy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Senu mesau áamak kátekame íkäi jíkkajaka, ínel áu jiaahuak: —Tühuata jájamnake jü Diosta reytaka ä nésahuepo páanim buäkame. ");
INSERT INTO mfy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Huanäi jü Jesús ínel áu jiaahuak: —Senu yoreme kúptey buähuamta yún yáuhuak. Huanäi juebenam áman núnnuk. ");
INSERT INTO mfy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Huanäi kúptey jïbuä éehuay horata yúmak, hua ä sáulerommak ínel nokta ámeu bíttuak, huame néjunrimmehui: ‘‘Binen kaate, bueïtuk sïme béja chúpila.” ");
INSERT INTO mfy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Të sïmetaka kaa áma emo yumä tía táytek. Huä bát téjhuaahuakame ínel jiaahuak: ‘‘Jübua jíbane haciendata jínnuk. Én éntokne áman ä bít báare. Nechë át jiokore, kaa ín áman yumä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Senu éntok ínel jiaahua: ‘‘Jübua jíbane mamni yúnta buéesim jínnuk. Én éntokne áman am jüneria báare jáchin machisim ára jíhuike jäni. Nechë át jiokore, kaa ín áma yumä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Senu éntok ínel jiaahua: “Jübua jíbane juubek; kíalïkune kaa áma yuuma.” ");
INSERT INTO mfy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jü sáyhuame nótteka, íkäi sïmeta ä téjhuak, juka ä tekohua. Huanäi öomtek, jü jóapo áchayhuari; jü ä saulerotau ínel jiaahuak: ‘‘Läutë huéiye jume pláazammechi éntok jume pueblo böommechi. Jume poloobemem äbo nüpa, jume lolöim éntok jume liliptim.” ");
INSERT INTO mfy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Huanäi jü sáyhuame ínel jiaahua: ‘‘Señor, em nésahuekäpo ámannä yáuhuak, éntok ketune áma aayuk, ják bem jotenakëhui.” ");
INSERT INTO mfy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jü ä tekohua béja ínel áu jiaahua jü sáyhuamtahui: ‘‘Böommechi éntok ranchommechë huéiye. Úttiapë áman am kiima, éläpo tápunnake jü ín káari. ");
INSERT INTO mfy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bueïtukne enchimmeu ínel jiaahua, kía jábe júne ín bát núnukäu kaa ä buänake, juka buähuamta ín yáatebokähui.” ");
INSERT INTO mfy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tüisi yún juebena génte Jesústamak kaatey. Huanäi kúakteka ínel ámeu jiaahuak: ");
INSERT INTO mfy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Kía jábe júne ino sáu huée bárëtek, ä átchay kaa tójaka, ä áyehua, ä jubiahua, ä üusim, ä saayim, ä huáyihuam, kíal ä jíapsihua junne, kaibu ín éä páman huéeka ín disciipulotunake. ");
INSERT INTO mfy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Éntok jü ino béchïbo jiokot aú huemakemta kaa huatiatek püaktiaka ino sáu sikame, kara ín disciipulopo näikiatu. ");
INSERT INTO mfy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jachu eme jábe júne juka kári tüisi buëuruta yáa bárëtek kaa huam yejteka báchä jüneria báanake, ¿jaiki tómita áma kimunakëhui, éntok jaikik ä jípurëu ái ä chúpanakëhui? ");
INSERT INTO mfy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jáchinaik junne, chúkula kári nahuata chúpasuko, juka huatek kara ä chúpanake. Huanäi sïme jume ä bíchame ä junneria táytinake, ");
INSERT INTO mfy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ínel jíakari: ‘‘Ï yoreme káate táytek; én éntok kara ä chúpaka taahuak.” ");
INSERT INTO mfy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O jábe reysu, täbui reytamak nássuaseka yeu sikätek, ¿kaa huam yejteka báchä jüneria báanake? ¿Jachu guojmamni mil sontarommak ä kobanake jäni, huaka veinte mil sontarom jípuremta? ");
INSERT INTO mfy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kaa áma yumäteko, juka senuk ketune mékka ä aneyo, nokta áu bíttuanake kaa áamak nássua rókaka. ");
INSERT INTO mfy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bueïtuk jábe junne eme kaa juka sïmeta ä jípurëu kaa tójäteko, kara ín disciipulopo näikiatu. ");
INSERT INTO mfy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Jü ona türi; të juka chökorata ä täruk, ¿jítaisu júchi chökosi ayunake? ");
INSERT INTO mfy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Buíata béchïbo júne kaa türi, éntok kía huate jítamak náu kuutiahuak junne, kía guötiana ál‑la. Jü jíkkaij béchïbo nákakame jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sïme huame yäura tómita náu tóij‑leerom éntok jume juëna yóremem Jesústau rúktey, ä nok jíkkaij báreka. ");
INSERT INTO mfy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jume pariseerom éntok leyta am mamajtíame áa bétana nokaka ä kítëbuay, ínel jíaka: —Ï yoreme jume juëna yórememmak au türe, éntok ámemak jïbuä. ");
INSERT INTO mfy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús íkäi ejemplota ámeu yétchak, ínel jíaka: ");
INSERT INTO mfy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Jábe yoremesu enchim násuk, cienim kabaraka, huépülaik áma täruka, kaa jume noventa áma bátanim mékka see päriapo tö sika juka ä täruri jariuseka simnake ä tíäu tájti? ");
INSERT INTO mfy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Huanäi ä tíaka, tüisi al‑leaka jöot ä püaktianake. ");
INSERT INTO mfy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Huanäi ä jóau yepsaka, ä amiigohuam éntok áa chíkola jóakame núnuka, ínel ámeu jiaunake: ‘‘Ínomakem al‑leiya, juka kabara ín täruri ín téakä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Enchimmeune én ínel jiaunake, junëli két chë júne al‑leehuame ayunake jum téhuekahui, huépul juëna yóremta jíapsi kúaktek, huate noventa áma bátani tü yóremem kaa jíapsi kúaktihuamta ámeu bëyeme béppa. ");
INSERT INTO mfy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O kétchi, ¿jábe jámutsu guojmamni taahuari tékil tómita jípureka, huépu tékil taahuarita tärukätek, kaa juka machiriata táaka, jíchikeka át jiápseka ä jariunake ä téäu tájti? ");
INSERT INTO mfy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ä téakätek, ä amiigohuam éntok áa chíkola jóakame núnuka, ínel ámeu jiaunake: “Ínomakem al‑leiya, juka tómita ín täruri ín téakä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Júnëli kétchi tine enchimmeu jiaahua, al‑leehuame ayunake jume Diosta ángelesim násuku, huépul juëna yóremta jíapsi kúakteko. ");
INSERT INTO mfy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Két ínel jiaahuak: —Senu yoreme guoyim üusekay, ");
INSERT INTO mfy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","huanäi jü chë kaa yöhue ä áchaybeu ínel jiaahuak: “In átchay, sïme juka herenciata ín áttia, nechë ä mákka.” Huanäi sïmeta bem áttiahuamta ámet näikimtek. ");
INSERT INTO mfy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chúkula kaa jaiki taahuarim huéy, jü ä üusihua chë kaa yöhue sïmeta huaka ä jípurëu náu tójaka siika, mékka buiärau bíchaa. Ámani béja juka tómita kía guötiak, kaa tühuata joaka. ");
INSERT INTO mfy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Të béja sïmeta ä tejalsuk, buere tébaa siika, huämi buiärapo. Huanäi tébäuri táytek. ");
INSERT INTO mfy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huanäi senu yoremtau huämi buiärapo jometau rúktek. Huäri ä buíammeu ä jaasek, kohuim ä suaya sáhueka. ");
INSERT INTO mfy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huanäi béja jume kohuim buä bëteri kóm huáttemta júne buä péaka am bitchay, të kaabe ä mimikay. ");
INSERT INTO mfy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Huanäi béja áu temai táytek, éntok ínel ée táytek: “¡Juebena tekipanualerom ín átchay jóapo yún buähuamta jípure! ¡Ínapo éntok ímï tébäi muuke! ");
INSERT INTO mfy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kíktekane ín áchaybeu huée báare. Huanäine ínel áu jiaunake: In átchay, kanne tüisi tahuala Diosta bíchäpo éntok em bíchäpo junne; ");
INSERT INTO mfy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","béjane kaa em üusi ti júne ino téhuaapo yúmala; kía huate em tekipanualerom bénasë nee bitcha.” ");
INSERT INTO mfy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Huanäi kíkteka, ä áchaybeu bíchaa siika. ’Huanäi jü ä átchay, ketune mékka ä huéysu, ä téuhuak. Huanäi tüisi ä jiokoleka ä bitchak. Huanäi búiteka ä nankirika siika. Ä íbaktiak, éntok ä besiitok. ");
INSERT INTO mfy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Huanäi hua ä üusihua ínel áu jiaahuak: “In átchay, Diosta bíchäpone kaa tühuata yáala, éntok em bíchäpo. Béjane kaa em üusi ti júne ino téhuaapo yúmala.” ");
INSERT INTO mfy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Të jü ä áchayhua jume ä sáyhuammeu ínel jiaahuak: ‘‘Sánkotem chë áma türik yeu huíkeka ä sánkotua, éntokem mámpo aniota át yétcha, éntokem ä bochatua. ");
INSERT INTO mfy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huaka beceerota chë áhuikem yeu tójaka ä mëa. Jïbuänakete, ¡éntokte al‑leerimmea buere pajkonake! ");
INSERT INTO mfy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bueïtuk ïri ín üusi mukilata bénasi näikiahuay; én éntok jíabitela. Tärutukay; të béja téuri.” Huanärim al‑leerimmak äboj táytek. ");
INSERT INTO mfy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jü ä kësam üusi áman jákun huasau aaney. Huanäi ä yepsayo, ä jóau kaa mékka ä huéyo, juka jiponhuamta éntok juka yïhuamta jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Huanäi senuk áma sáyhuamta temajek jita áma huëhui. ");
INSERT INTO mfy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Áapo ínel áu jiaahuak: ‘‘Jü em saila yepsak. Huanäi jü em átchay beceero áhuik mëak, al‑leaka türik yúmalata yepsakä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Të hua usiari chë yöhue öomtek. Huanäi éntok kaa áman kibak báarey. Ä áchayhua yeu sika jiokot áu jiaahuak, áman ä kibak sáhueka. ");
INSERT INTO mfy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Áapo éntok ä áchaybeu ínel jiaahuak: ‘‘Empo jüneiya jaiki huásuktiapone enchi aniala, em nésau joaka, të jauhuey júne kaa chiva asölaata júne nee mik‑la ín amiigom ín äbojnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Të íkä em üusi jume jáamuchim kaa titihueme büru yorememmak rejteme, huaka em tómita ámet tejalek. Én éntok ä yepsako, juka beceero áhuiriahuamta júne mëtebok, áa béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Huanäi jü ä áchayhua ínel áu jiaahuak: ‘‘In üusi, empo jíba ínomak aane, éntok sïmeta huaka ín áttia, empo ä áttiak. ");
INSERT INTO mfy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Të ëni tua türi al‑leerimmea pajko béchïbo, bueïtuk jü em saila mukpotä näikialatukay, të júchi jíabitek. Täruritukay, të béja téuri.” ");
INSERT INTO mfy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ä discíipulommeu két ínel jiaahua: —Senu yoreme rikotaka móoromata jípurey. Huanäi ejtejhuariahuak íkäi móoromata huaka ä áttiahua kía ä guötiä bétana. ");
INSERT INTO mfy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Huanäi hua ä tekohua ä núnuka ínel áu jiaahua: “¿Jítasu ïri emo bétana ín jíkkajähui? Jume jíösiam cuentam áma em jípurëu inou tójja, bueïtukë béja kaa móoromatunake.” ");
INSERT INTO mfy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Huanäi hua móoroma büruk ée táytek: “¿Jáchisune annake jäni ëni ín teko béja tékilta nee úhuak? Kanne úttiak jïbuejeka buíata ín tekipanuanakë béchïbo, éntokne tiihue júne ín nétannakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Béjane jüneiya jita ín yáanakëhui, huatem bem jóapo nee bem mabetnakë béchïbo, béja kaa nee móoromatuko.” ");
INSERT INTO mfy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Huanäi jume ä tekohua huikiriame hueuhuëpulaim núnnuk. Jü bát huémtau ínel jiaahua: “¿Jaikiksë ä huikiriiya juka ín teeko?” ");
INSERT INTO mfy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Áapo éntok ínel áu jiaahua: “Cien barril aceiteta.” Huanäi ínel áu jiaahua: “Ímï jíösiapo jïojteri jü em ä huikiriähui. Läutë yejteka, cincuenta barrilim jíba áma jïojte.” ");
INSERT INTO mfy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chúkula júchi senuk temajek: “Émposu, ¿jaikiksë ä huikiriiya?” Áapo éntok: “Cien sako tirijkom ti au jiaahua.” Huanäi ínel áu jiaahua: “Ímï jíösiapo jïojteri jü em ä huikiriähui. Läutë yejteka, ochenta sakom jíba áma jïojte.” ");
INSERT INTO mfy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Huanäi hua ä tekohua juka móoroma kaa tüisi huémta úttileka taahuak, ä kóba súakä béchïbo. Jume géntem én kat‑riame tüisim kóba súhuak, jume Diosta üusim machiriata jípureme béppa. ");
INSERT INTO mfy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Éntokne két ínel jiaahua: Ím ániapem kaa tü tómita huämem am kooba, jume amiigom. Huanäi béja íkäi sïmeta lütek, ámanem mabetna, enchim yü jíapsinakepo. ");
INSERT INTO mfy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Huä kaa jaikik jita jípureka júne tüisi áu huériame, kía juebenak jita jípureka júne tüisi áu huérianake; éntok hua kaa jaikik jita jípureka júne kaa tüisi áu huériame, két juebenak jita jípureka júne kaa tüisi áu huérianake. ");
INSERT INTO mfy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bueïtuk kaa tü rikoapo kaa tüisi enchim ayuk, ¿jábesu juka tua tü rikorata enchim mámpo yéchanake jäni? ");
INSERT INTO mfy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Huaka kaa enchim áttia kaa enchim suayako, ¿jábesu huaka tua enchim áttia enchim mák báanakejäni? ");
INSERT INTO mfy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jü senu sáyhuame kara guoy tekommeu tekipanua; bueïtuk huépülaik omtianake; juka senuk éntok náknake. Juka huépülaik chë érianake; juka senuk éntok, kaitäpo ä bínnake. Karem Diosta nésau johua, éntok tómit jíba éaka jiápsa. ");
INSERT INTO mfy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sïmeta íkäim jíkkajay jume pariseerom, bueïtukim tüisi tómit jiápsekay. Huanärim ä junneriay. ");
INSERT INTO mfy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Huanäi Jesús ínel ámeu jiaahua: —Eme ínel jume emo tü yóremem tíame jum genteta bíchäpo, të Dios enchim jíapsi jüneria; bueïtuk jume yoremem chë ériäu, Diosta bíchäpo jaiti maachi. ");
INSERT INTO mfy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Moiséjta ley éntok jume profeetam Juan Bautistatau tájti jíba siika. Huanäi naateka jü tü noki Diosta reytaka ä nésahue bétana huéeme nokhua. Büruka éntok úttiata johua, áman kimu báreka. ");
INSERT INTO mfy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Chë kaa obiachi téhuekata éntok juka buíata lütinakëhui, huaka huépul léetrata leypo huémta kaa chúpanakeu béppa. ");
INSERT INTO mfy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Sïme jábe ä jubiahua jímmaakame, éntok júchi täbuik jubekäteko, Diosta bíchäpo kaa tüisi tahuala. Entok jü jámut jímmaarita nükame junne, két Diosta bíchäpo kaa tüisi tahuala. ");
INSERT INTO mfy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Senu yoreme riko aaney, tüisi finok sásankoka éntok béj‑remta, éntok chíkti táapo buéresi ujyorisi äbojteboka. ");
INSERT INTO mfy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Senu két aaney netaneka jiápsay, Láazaro ti téhuaaka, huakaï puertapo au huiksisimey sïmet takahuat sähuaka. ");
INSERT INTO mfy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rikota mesapo kóm huáttemta júne buä péiyay jobobáreka. Chüum júne béja áu sájaka, jume sähuam ä tetëbuariay. ");
INSERT INTO mfy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jauhueka muukuk, jü netanëra. Huanäi jume ángelesim ä núk sájjak, áman Abrahamta anëhui. Jü riko éntok két muukuk; huanäi mäahuak. ");
INSERT INTO mfy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Áman táijpo jiokot éaka, jikau remtek. Huanäi béja mékka jákun juka Abrahamta bitchak, Láazarota éntok áamak kátekamta. ");
INSERT INTO mfy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Huanäi chaayeka ínel jiaahua: “¡In átchay Abraham, nechë jiokolë! Jukë Láazarota ä sútu púnta bäapo kómoniaka nee äbo nínta síparia sáuhue. Bueïtukne tüisi jiokot éiya ímï béetëpo aneka.” ");
INSERT INTO mfy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Të jü Abraham ínel áu jiaahua: “Üusi, áahuë huáate, empo sïme tühuata jípurey áman buíapo jiápsaka, jü Láazaro éntok jiokot máchiraata bitchak. Én éntok, áapo juka tühuata mabet‑la, empo éntok juka jiokot máchiraata. ");
INSERT INTO mfy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Éntok két senu huéeme áma aayuk: Siba tüisi mékka kömitaka áma óorek enchim éntok ito násuku. Júnëli béja jume ímï áman bíchaa enchimmeu kat báareme, kara áman kaate. Huannäbotana bina bíchaa júnem kara äbo kaate.” ");
INSERT INTO mfy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Huanäi ínel áu jiaahua: ‘‘Emoune nok buaana, ín átchay Abraham, jukë Láazarota ín átchay jóau jaase, ");
INSERT INTO mfy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bueïtukne mamnim sailak. Áman íkäi ámeu noknake, kaa ímin jiokot machikun am téunakë béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Huanäi Abraham ínel áu jiaahua: “Moiséjta éntok jume profeetamim jípure; ¡huamerim jikkaijnake!” ");
INSERT INTO mfy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Huanäi áapo ínel jiaahua: “Ëe, ín átchay Abraham, të senuk jume kókkolam bétana ámeu yepsakim jíapsi kúaktinake.” ");
INSERT INTO mfy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Të Abraham ínel áu jiaahua: ‘‘Juka Moiséjta éntok jume profeetam kaa am nok jíkkaij bárëtek, kéchim huaka kókkolam násuk jíabitekamta bíchak júnem kaibum emo jíapsi kúaktianake.” ");
INSERT INTO mfy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús jume ä discíipulommeu ínel jiaahua: —Jíba ayunake huaka genteta jioptuaka kaa türiu bíchaa ä núnume. ¡Të jiokochia hua yoremta béchïbo jábeta jioptuame! ");
INSERT INTO mfy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chë tüisi áu huée éiyey, juka téta át tutujhuamta kutänaapo át súmahuaka bahuéu kóm jímmaahuako, të kaa am jioptua éiyey ímëi ili uusim. ");
INSERT INTO mfy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Emem emo suaya! ’Juka em saila kaa tüisi émomak tahuak kuttilasë áu nooka; áu ä jíapsi kúaktek éntok, Akë ä jiokore. ");
INSERT INTO mfy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Senu táapo guoy búsanisi kaa tüisi émomak ä tahuako, guoy búsanisi émou ä nótteko: “Kanne júchä yáanake tä jíay”, Akë ä jiokore. ");
INSERT INTO mfy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jume apóstolim Señortau ínel jiaahua: —Diosta súalhuamtë itot büruria. ");
INSERT INTO mfy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Huanäi jü Señor ínel jiaahua: —Tua lútüriapem Dios ehuamta súalëtek, kía mostaaza báchiata beletchisi junne, arem ínel jiäu éiyey jü júya sicómoro téamtahui: “Emoë póponaka bahuepo emo kétcha”, huanäi jü júya enchim nésahuepo áman ayu éiyey. ");
INSERT INTO mfy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Jábesu eme, senu enchim sáhuemta möitemta o chë animaalim suayamta, huasa bétana ä yepsayo, ¿sep ínel áu jiaunake: “Binë huéiye, mesahuë yejte”? ");
INSERT INTO mfy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ëe, ál‑la ínel áu jiaunake: “Buähuamtë yáuhua, täbui sánkompë kóbate. Huanärë nee miika. Nee jïbuäsuko éntok nee jita jïsuko, béjë jïbuä, éntoke jita jëye.” ");
INSERT INTO mfy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Jachu ä Dios buánianake, huaka ä sáhuëhui ä nésahui ä yák tíaka? Jíba tua ëe. ");
INSERT INTO mfy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Júnëli két eme sïme juka Diosta nésahui enchim át sáyhuä chúpak, ínëlem jiaunake: “Ítapo nésauta joame kaita béchïbo türi; itom át sáyhuäu jíbate yáuhuak.” ");
INSERT INTO mfy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jü Jesús jum buere joära Jerusaléniu bíchaa huéeka, jü Samaria éntok Galiléa buíärata náu násuk áman siika. ");
INSERT INTO mfy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Senu pueblou yebisiseka ä huéiyo, guojmamni yoremem sähua leprä téamta kökoaka ä nankirika yeu sájjak. Huanärim ili mékka jápteka, ");
INSERT INTO mfy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kusisi chayekam ínel jiaahua: —¡Jesús, Maestro, itomë jiokore! ");
INSERT INTO mfy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Áapo éntok am bíchaka ínel ámeu jiaahua: —Ámanem tiöpopo tékiakammeu kaate. Huanärim katekasu türiak. ");
INSERT INTO mfy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Huanäi huépülaka áu bíchaka éntok áu türi jüneriaka, tüisi kusisi chayeka éntok Diosta úttileka áu nóttek. ");
INSERT INTO mfy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesústau tónommia kíkteka, ä pújba buíau kóm yúmariak, ä Dios buaníaka. Ï yoreme éntok huam Samariapo jometukay. ");
INSERT INTO mfy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Huanäi Jesús ínel jiaahua: —¿Jachum kaa guojmamniakay jume türiakame? ¿Jáksum aane, jume huate bátan yoremem türiakame? ");
INSERT INTO mfy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jachu ïri huépülaika kaa itom pueblopo jomesu nóttek, Diosta baysahueka? ");
INSERT INTO mfy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Huanäi ínel áu jiaahua: —Diosta em súalëu enchi jínëuk. Yejtekë siime. Türiläe. ");
INSERT INTO mfy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jume pariseerom juka Jesústa temajek, jauhuey juka Diosta reytaka ä nésahueu yebijnake bétana. Huanäi áapo ínel ámeu jiaahua: —Juka Diosta reytaka ä nésahueu yepsay kaachinte itom pusimmea ä bínnake. ");
INSERT INTO mfy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaabe ínel jiauna: “Ímï aane”, o “Júmü aane”; bueïtuk jü Diosta reytaka ä nésahuepo én ímï enchim násuk aane. ");
INSERT INTO mfy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Huanäi jume ä discíipulommeu ínel jiaahua: —Të tiempo yúmanake ínapo Yoremta Üusi kía huépül taahuata júne enchim bít peenakëhui, të katem ä bínnake. ");
INSERT INTO mfy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Huanäi ínëlim enchimmeu jiaunake: “Ím aane”, o “Áman aane.” Të katem áman sásaka, éntok katem áme sáu rejte. ");
INSERT INTO mfy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bueïtuk juka yúku béroktita téhueka bétana sejchúkti ániata nahuau tájti ä machiriakäpo bénasi, junëline bíttunake ínapo jü Yoremta Üusi taahuarita yepsayo. ");
INSERT INTO mfy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Të úttia ketune juebena jiokot máchiraata ín bínnakëhui, éntok huaka génte én huémta nee omoutenakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noéta taahuarimpo bénasi, ánëli két huéenake, jü Yoremta Üusi yepsayo. ");
INSERT INTO mfy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Jïbuähuay, éntok vino jïhuay, emo jubiahuay éntok emo kunahuay, Noéta arcau kibakeu tájti. Huanäi béja yepsak, jü buere bánia diluuvio. Huanäi sïmetaka kókkok. ");
INSERT INTO mfy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ánëli két siika, jume Lotta taahuarimmet: jïbuähuay, jita jïhuay, jita jínnuhuay, jita nénkihuay, éntok ethuay, éntok káatehuay; ");
INSERT INTO mfy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","të juka Lotta jum Sodoomapo yeu ä sik jíbba, táji yúkkuk, éntok azufre téhueka bétana. Huanäi sïmetaka kókkok. ");
INSERT INTO mfy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Júnëli huéenake júnakoy táapo Yoremta Üusi yepsayo. ");
INSERT INTO mfy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Huäri taahuarit hua jábe kárit jikat aneme, entok juka áttiahuata káapo jípurëtek, katem kóm sika áman kibakeka ä nü báanake; senu éntok áman huajpo anëtek, kaa ä jóau nótti báanake. ");
INSERT INTO mfy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Huä Lotta jubiabeu yeu sikamtahuem huáate. ");
INSERT INTO mfy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sïme jume ä jíapsi jínëu báareme ä tärunake. Éntok sïme jume ä tärukame ä jínëunake. ");
INSERT INTO mfy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Énne enchimmeu ínel jiaahua, huäri tukaariachi guoyikam jípetampo náu tönake. Huépülaka núk sákana; senu éntok áma tö sákana. ");
INSERT INTO mfy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Guoy jáamuchim nanahuit jäbueka tujnake. Huépülaka núk sákana; senu éntok áma tö sákana. ");
INSERT INTO mfy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Guoy yoremem huajpo annake; huépülaka núk sákana; senu éntok áma tö sákana. ");
INSERT INTO mfy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Huanärim ä yómmiaka, ínel áu jiaahua: —¿Jákusu huéenake jäni ïri, Señor? Huanäi áapo am yómmiak: —Jum mukirata bökäpo, huämïrim náu yáijnake, jume tekuem. ");
INSERT INTO mfy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús senu ejemplota ámeu yétchak, jíba Diostau buanhuamta itou bëyë bétana, kaa kóm éaka, ");
INSERT INTO mfy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ínel jíakari: —Senu pueblopo yäut aaney, Diosta kaa májhueka éntok yoremem kaa yöreka. ");
INSERT INTO mfy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Huämi pueblopo két aaney, senu jámut jókoptulataka, élaka hua jueztau yeyepsaka, lútüriata áu yáaria ïaaka jü áamak nok peleytamtamaki. ");
INSERT INTO mfy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jü juez éntok kaa báarey; juebena taahuarim béja huéiyey. Të chúkula béja ä jiápsipo ínel jiaahua: “Éläposune kaa Dios huáate, éntokne kaa jábe yoremta yöre, ");
INSERT INTO mfy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","të ï jámut jókoptula múksi jíba nee bitcha. Júnel béchïbone ä anianake, jamak koloptune nee öomtituanake.” ");
INSERT INTO mfy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Huanäi ínel jiaahua jü Señor: —Akem ä nok jíkkaja, juka juezta námakak jiápsekamta. ");
INSERT INTO mfy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Jachu jü Dios kara lútüriata am yáaria jäni jume ä ëriähuim, jume taahuapo éntok tukaarit naa búrujti áu buaname? ¿Jachu tebe tiempota simsuko, béja am nok mabetnake jäni? ");
INSERT INTO mfy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Enchimmeune inel jiaahua läuti lútüriata am yáarianake. Të juka Yoremta Üusi yepsak, ¿jachu ketune ayunake jäni jü Dios eehuame ímï buíapo? ");
INSERT INTO mfy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús täbui ejemplota ámeu yétchak, jume huate emo tü yóremem tíaka, huatem éntok kaa tüisi bíchammehui. Ínel ámeu jiaka: ");
INSERT INTO mfy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Guoy yoremem tiöpou kiímuk, Diostau buanboka. Senu pariserotukay, senu éntok yäura tómita náu tóij‑lerotukay. ");
INSERT INTO mfy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jü pariseero huéeka ínel ä jiápsipo Diostau buaanay: “Dios, enchine baysauhue bueïtukne kaa jume huate yoremem bénna; ékbualerom, éntok kaa lútüriata boojoriame. Kanne kía ják jáamuchim jípure, éntok ï yäura tómita náu tóij‑lerota bénasi júnene kaa ántuari. ");
INSERT INTO mfy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Semanapone guosa ayuuna, entok sïme ín kobäune diezmo.” ");
INSERT INTO mfy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Të jü yäura tómita náu tóij‑leero éntok, mékka tónommia huéeka, jikau júne kaa remti báarey. Táhuit jíba áu chónaka, ínel jiaahuay: “Dios, nechë jiokore, nee kaa tü yóremtukä béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ínapo ínel jiaahua ïri ä jóau kóm siika béja jiokoritaka, të jü pariseero ëe. Bueïtuk hua áu buérialeme kóm tahuariana; hua áu kóm tahuariame éntok tóboktiana. ");
INSERT INTO mfy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jume ili usim áu nüpahuak, ámecham mámte ïaaka. Jume discíipulom, júkäi bíchaka, ámehuim öomtek, jume áu am nüpakammehui. ");
INSERT INTO mfy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Të Jesús am núnuka ínel ámeu jiaahua, ä discíipulommehui: —Akem am tójja, éläpo jume ili usim inou kannake, éntokem katem jukaram taktiria; bueïtuk juka Diosta reytaka ä nésahuepo júmëi bénasi emo nüyeme ä áttiak. ");
INSERT INTO mfy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lútüriapone ínel enchimmeu jiaahua, hua kaa ili usita bénasi éaka Diosta reytaka ä nésahueu mabetakame, kaibu Diosta reytaka nésahuepo annake. ");
INSERT INTO mfy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Senu yoreme yäurapo kátekame ä temajek, ínel jíakari: —Tü Maestro, ¿jítasune yáanake, juka yü jíapsihuamta jípu béchïbo? ");
INSERT INTO mfy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús ínel ä yómmiak: —¿Jatchiakasë nee tü yóreme tíiya? Kaabe éntok chë türi ímï buíapo, jü Dios jíbba. ");
INSERT INTO mfy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jume mandamientomë täya: “Katë kía ják jáamuchim jípunake; katë jábeta mëa; katë ékbua; katë jábeta bétana ára nókïchiata nooka; em áchayë yöre, éntok em áiye.” ");
INSERT INTO mfy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Huanäi áapo ínel jiaahua: —Sïmetane íkäi huéria ín usitukäpo naateka. ");
INSERT INTO mfy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús íkäi jíkkajaka ínel áu jiaahua: —Ketune senu huéeme émou bëye: sïmete juka em jípurëu nénkaka, poloobem ä miika; huanäre téhuekapo rikoata jípunake; éntoke inou rúkteka nee guojaase. ");
INSERT INTO mfy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Huanäi áapo íkäi jíkkajaka kaa al‑leaka taahuak, bueïtuk tüisi yún tómekay. ");
INSERT INTO mfy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús ä bíchaka, siirokaka taahuak. Huanäi ínel jiaahua: —¡Tepa tüisi obiachi Diosta reytaka ä nésahuepo am kimunakë béchïbo, jume riikom! ");
INSERT INTO mfy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Chë júne kaa obiachi jiikia pusimpo camellota áma huam yeu huéenakë béchïbo, jü yún tómekamta Diosta reytaka ä nésahuepo ä kibaknakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Huanäi huate íkäi jíkkajaka, ínel áu jiaahua: —Huanäisu, ¿jábesu júntuk jínëutunake? ");
INSERT INTO mfy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Huanäi Jesús ínel ámeu jiaahua: —Jum yoremem kara árahuëpo, Diosta béchïbo kaa obiachi. ");
INSERT INTO mfy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peero éntok ínel áu jiaahua: —Señor, ítapo sïmeta itom jípurëu tö sájjak, enchi guojaa báreka. ");
INSERT INTO mfy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Huanäi áapo ínel ámeu jiaahua: —Lútüriapone ínel enchimmeu jiaahua, kía jábe júne ä jóa tö sikame, ä áchayhuam, ä sailahuam, ä jubiahuata, éntok ä üusim, Dios reytaka ä anëpo an báreka, ");
INSERT INTO mfy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","chë júne áa béppa ä jípunake ímï ániapo; huame taahuarim äbo huémmet éntok, yü jíapsihuamta jípunake. ");
INSERT INTO mfy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús jume doocem bempolaim móchala núnuka, ínel ámeu jiaahua: —Énte buere joära Jerusaléniu bíchaa jikau kannake, sïmetaka jume profeetam Diosta Üusi bétana jïojtekäu chúpnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bueïtuk jume kaa judíom mámpo tóijna. Huanäi ámanim béja tüisi ä junnerianake, éntokim ä buere áunake, éntokim át chít huáttinake. ");
INSERT INTO mfy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Huanärim tüisi ä bemmuchaka, akim ä mënake; të báij taahuarim huéy jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Të bempo tóktim kaa át jünéaka taahuak, jita ä nokähui. Ï noki áme béchïbo kaa jünakiachitukay; katim át jüneiyay jita ámeu ä nok bárëhui. ");
INSERT INTO mfy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ínel yeu siika: Jesústa pueblo Jericóu yebisiseyo, senu lípti böo mayoat káteka nétaney. ");
INSERT INTO mfy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Juka genteta juebenak katemta jíkkajaka, jü lípti nátemajek jita huëhui. ");
INSERT INTO mfy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Huanärim ä téjhuak, juka Jesús Nazarenota áma huam huë bétana. ");
INSERT INTO mfy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Huanäi kusisi chay táytek, ínel jíakari: —¡Jesús, Davidta Üusi, nechë jiokore! ");
INSERT INTO mfy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jume bát kateme éntok ä nok pappattiay, kaa múksi ä jiau sáhueka. Të áapo chëhuasu úttia chaayey: —¡Davidta Üusi, nechë jiokore! ");
INSERT INTO mfy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Huanäi Jesús kíkteka ä núnutebok, ä anëu bíchaa. Huanäi áu ä yepsako, ä temajek: ");
INSERT INTO mfy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Jítasë nee émou yáa ïa? Huanäi jü lipti ínel jiaahua: —Señor, bít-huamtane huáatia. ");
INSERT INTO mfy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús ínel áu jiaahua: —¡Akë ä mabeta! Em nee súalë béchïbë bíchaka taahua. ");
INSERT INTO mfy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Huämi horapo jü lípti bíchaka taahuak. Huanäi éntok juka Jesústa guojaasek, Diosta baysahueka. Jü sïme génte íkäi bíchaka két Diosta úttileka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericóu kibakeka jü Jesús, jum pueblopo násuk áman huéiyey. ");
INSERT INTO mfy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Huanäi ínel yeu siika: Senu yoreme Zaqueo ti téhuaakame, jume tómita náu tóij‑lerommeu yäuttukay, éntok rikotukay. ");
INSERT INTO mfy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesústa bít báreka éiyay, jünee báreka ä jábétukähui. Të kaa áma yuumay, juka genteta büru béchïbo, bueïtuk tüisi kómëlatukay. ");
INSERT INTO mfy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huanäi ä bít báreka, áapat búiteka júya buëurukut jämuk, sicómoro téamtachi, Jesústa huéenakepo ámani. ");
INSERT INTO mfy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús béja áman yepsaka, jikau remteka ä bitchak. Huanäi ínel áu jiaahua: —Zaqueo, emoë bamijtuaka kóm huéiye, bueïtukne em jóau yebijnake ëni. ");
INSERT INTO mfy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Huanäi jü Zaqueo läuti kóm sika tüisi al‑leaka ä mabetak. ");
INSERT INTO mfy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Íkäi bíchaka, sïmetaka kaa türik Jesústa bétana nok táytek, senu kaa tü yóremta jóapo ä tahuak tíaka. ");
INSERT INTO mfy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Huanäi Zaqueo kíkteka, Señortau ínel jiaahua: —Juyu, Señor, jume poloobem násuk áman juka ín jípurëune am mik báare; senuk báitähuaka ä ékbuariak junne, naikisi áa béppane ä nóttirianake. ");
INSERT INTO mfy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Huanäi Jesús ínel jiaahua: —Én íäri taahuarit ímï jóapo yepsak, jü yore jínëiuhuame, áapörik két Abrahamta üusitukä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bueïtuk ínapo jü Yoremta Üusi äbo siika, juka áu tärulata jariuseka ä jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Íkäi am jíkkaijsuk, jü Jesús ejemplota ámeu yétchak, Jerusaléniu kaa mékka ä aneï béchïbo. Bempo éntok ínel éiyay: Jü Diosta reytaka nésahueu én ímï horapo abe yepsa. ");
INSERT INTO mfy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huanäi ínel ámeu jiaahua: —Senu yoreme yäura usiarimmak huéeritaka ím aaney. Huanäi mékka senu buiärau bíchaa siika, ámani reytu báreka, chúkula éntok äbo nótti báreka. ");
INSERT INTO mfy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Huanäi béja sim báreka, guoj mamni ä tekipanualerom núnnuk. Yún tómita nátepola am mákkak, ínel ámeu jíaka: “Íkärem tómita tekipanuatua ín yepsäu tájti.” ");
INSERT INTO mfy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Të jume áma pueblopo joome katim ä huáatiay. Huanärim genteta náu tójaka áa sáu am jaasek nokta huériame, ínel áu jíakari: “Katte íkäi ito béppa yäuttu ïaa.” ");
INSERT INTO mfy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Huanäi béja áapo nótteka, juka yäurata mabetchulataka, am núnutebok huame ä tekipanualerom jume tómita nülame, am jüneria báreka jáchin machisi am tekipanuakähui. ");
INSERT INTO mfy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Senu bát áu yepsak, ínel jíakari: “Señor, jü em tómi, guojmamnik áa béppa koobak.” ");
INSERT INTO mfy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Huanäi áapo ínel áu jiaahua: “Türi, tüise ára sáutu; jum ilikkiku tüisi em tekipanuakä béchïbo, guojmamni pueblommehuë yäuratunake.” ");
INSERT INTO mfy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Senu júchi áu yepsak, ínel jíakari: “Señor, jü em tómi mamnik áa béppa koobak.” ");
INSERT INTO mfy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Huanäi íau két ínel jiaahua: “Empo kétchi mamni pueblom béppë yäuttunake.” ");
INSERT INTO mfy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Senu júchi áu yepsak, ínel jíakari: “Señor, ímï óorek jü em tómmi; payumpone kutti ä súmmak, ");
INSERT INTO mfy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","bueïtukne enchi májhuey, em yórem juënatukähui, kaa em ják óreri nunüyë tíaka, kaa em echakäu júne tobotoboktiä tíaka.” ");
INSERT INTO mfy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Huanäi jü rey ínel áu jiaahua: “¡Empo kara sáutu! Juka nokta em tempo yeu sikamta, júkäine emót kúaktianake. Tüise jüneiya nee yorem juënatukähui, kaa ín ják ëriari ín nunüyëhui éntok kaa ín echakäpo nee jita tobotoboktiähui. ");
INSERT INTO mfy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jatchiakasu ¿júntukë kaa juka ín tómi bancopo óorek, én juka bancotane yore bebejtuäu mabet éiyey?” ");
INSERT INTO mfy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Huanäi jume áma anemmeu ínel jiaahua: “Juka tómitem ä mák‑ri ä úhua; juka guojmamni tómita áa béppa kobalatem ä mákka.” ");
INSERT INTO mfy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bempo éntok ínel áu jiaahua: “Señor, béja juka guojmamni tómita jípure.” ");
INSERT INTO mfy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Áapo éntok ínel am yómmiak: “Inelne enchimmeu jiaahua, hua jita jípureme júchi huatek máktunake; hua kaita jípureme éntok, hua ilikkik ä jípurëu júne ä úhuaatunake. ");
INSERT INTO mfy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Éntok két huame nee béj‑reka kateme, jume kaa áme béppa nee yäuttu ïaame, júmëi éntok inohuem am huéria. Huanärem ín bíchäpo am kóba chúktia.” ");
INSERT INTO mfy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Íkäi noksuka, bát kíktek buere joära Jerusaléniu jikau böochi. ");
INSERT INTO mfy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Béja abe huame pueblommeu yepsaka, Betfagéu éntok Betaniahui, jü káhui Oliivo téamta náapo aneka, guoyim ä discíipulom áman jaasek, ");
INSERT INTO mfy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ínel ámeu jíaka: —Huä pueblou ito beu kaa mékka kátekamtahuem nóite. Áman yájakem buruta áma chäkamta téunake; kaabe jee át jote. Akem ä búttiaka, äbo ä huéria. ");
INSERT INTO mfy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jábeta enchim temajek jita béchïbo enchim ä búttiähui, ínëlem áu jiauna: “Jü Señor ä huáatia.” ");
INSERT INTO mfy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jume ä discíipulom sájaka, ä téuhuak, Jesústa am téjhuaakäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Huanäi juka buruta am búttiay jume ä áttiakame am temajek, ínel ámeu jíaka: —¿Jatchiakem juka buruta butbúttia? ");
INSERT INTO mfy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bempo éntok ínel jiaahua: —Bueïtuk jü Señor ä huáatia. ");
INSERT INTO mfy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Huanärim Jesústau ä nüpak. Jume bem sánkomim burutat óreka, Jesústa át jikat yétchak. ");
INSERT INTO mfy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Huanäi ä huë pámani jume sánkomim áapat guötiasakay. ");
INSERT INTO mfy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Béja áman jëla kóm kateka kahui Oliivo ti téhuaakapo, sïme jume ä disciipulohuam áa sáu kateme chay táytek, al‑leaka éntok Diosta úttileka, jume jauhuey kaa bíbithuame bem bíchakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Inëlim jiaahua: —¡Yörisi maachi, jü Rey Diosta téhuampo itou yepsame! ¡Yánti jíapsihuame áman téhuekahui, éntok lóoria jikachi! ");
INSERT INTO mfy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Huanäi huate pariseerom jume genteta násuk aneka áu ínel jiaahua: —Maestro, em discíipulome chay yáatiria. ");
INSERT INTO mfy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Áapo am yómmiak, ínel jíakari: —Enchimmeune ínel jiaahua, ímëi kaa jíaleyo, jume tétam chay táytinake. ");
INSERT INTO mfy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Béja kaa mékka áman huéeka, juka buere joära Jerusalénta bíchaka, áa béchïbo buaanak, ");
INSERT INTO mfy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ínel jíaka: —¡Empo jüneätek kía íäri em taahuarit junne, jítasu hua yánti jíapsihuamta yore mákka! Të én huäri ésori, éntoke kara ä bitcha. ");
INSERT INTO mfy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Enchimmehuim huéiye jume taahuarim, jume enchi omtíame enchi kóräituanake. Huanärim enchi kóntiaka nate chíkola émou kimunake. ");
INSERT INTO mfy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Huanärim buíau enchi tátabnake; jume em üusim éntok sïmeta juka em áttiak, kaitapo ä tahuarianake. Kaita téta nat béppa joka tahuanake, kía juka émou bíttuata, enchi jínëunakemta kaa em ä mabetakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Huanäi tiöpopo kibakeka, jume áma jita nénkame éntok jita áma jínnume päkun yeu am bep táytek, ");
INSERT INTO mfy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ínel jíakari: —Júnel jïojteri: ‘‘In kári Diostau áma nok béchïbo”; të eme lak‑roonim áma éusu béchïbem ä jípure. ");
INSERT INTO mfy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Huanäi chíkti táapo tiöpopo am majtiay; të jume tiöpopo nésahueme, leyta am mamajtíame, éntok jume yoremem jum pueblopo chë yörihuame, ä mëbáreka jíba éiyay. ");
INSERT INTO mfy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Të kaitachim jiahuite máchiakay, bueïtuk sïme jü génte tüisim át suaka ä jíkkajay. ");
INSERT INTO mfy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Séjtul táapo Jesús jum tiöpopo juka genteta am majtiayo entok tü nokta yore jínëuhuamta bétana huémta ámeu am nookay, ámam náu yájjak jume tiöpopo tékiakame, jume judíom leyta mamajtíame, éntok jume ou yoiyöturim. ");
INSERT INTO mfy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Huanärim ínel áu jiaahua: —Itomë téjhua, ¿jábeta téhuamposë íkäi johua? O, ¿jábe yäurasu íkäi licensiata enchi mák‑la? ");
INSERT INTO mfy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús éntok ínel am yómmiak: —Ínapone két senu huémta enchimmeu nátemaijnake. Nechem ä yómmianake: ");
INSERT INTO mfy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿jábesu juka Juanta äbo bíttuak ä batönakë béchïbo? ¿Dios, o jume yoremem? ");
INSERT INTO mfy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Huanärim bempo náu nok táytek, ínel jíakari: —¿Jáchinsutä yómmianake? Ítapo Diosta bétana huéiye ti ä yómmiako, ínel itou jiaunake: “¿Jatchiaka júntukem kaa ä súsualek?” ");
INSERT INTO mfy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yóremraata bétana huéiye, jü pueblo itom mamaasunake; bueïtuk sïme juka Juanta profeetapo ä täyay. ");
INSERT INTO mfy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Huanärim kaa emo jüneä tíaka taahuak, jábeta juka Juanta yäurata ä mák‑latukähui. ");
INSERT INTO mfy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Huanäi Jesús ínel ámeu jiaahua: —Ínapo júne kaibu enchim téjhuaanake jita yäurata nee ä licensiakähui. ");
INSERT INTO mfy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sep íkäi ejemplota ámeu nok táytek jume géntemmehui: —Senu yoreme párasim eechak, yorem tekipanualerom ä réuhuak. Huanäi mékka jákun buiärau bíchaa siika éntok bínhua áman aanek. ");
INSERT INTO mfy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Huanäi béja juka etta chúpey, senuk ä sáhuëu áman jaasek huame tekipanualerommehui, juka áma chúpemta ä jájamëu ámeu ä au sáhueka. Të bempo tüisi ä bépsuka, kaita ä mákaka ä simtuak. ");
INSERT INTO mfy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Huanäi jü etta áttiakame júchi senuk ä sáhuëu áman jaasek. Íkärim éntok, buere áusuka kéchim ä bépsuka, kaita ä mákaka ä simtuak. ");
INSERT INTO mfy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Júchi béja bájim huëpo senu ä sáhuëu áman bíttuak; íkärim júchi kökosi ä yáaka päkun yeu ä béebak. ");
INSERT INTO mfy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Huanäi jü huaj etta áttiakame ínel jiaahua: ‘‘¿Jítasune júntuk én yáanake? Juka ín üusi chë ín nákëune én áman bíttuanake; jamak júnem íkäi bichäteko ä yörinake.” ");
INSERT INTO mfy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Të jume etta suayame ä bíchaka, náhuim nookak, ínel jíakari: ‘‘Ïri jü sïme ettamak tahuaseka huéeme. Atä mënake. Huanäi jü echi itom mámpo tahuanake.” ");
INSERT INTO mfy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Huanärim huajpo päkun yeu ä tójaka, ä mëak. Huanäi Jesús am natemajek: —¿Jáchisu júntuk am yáanake jäni, jü páras etta áttiakame? ");
INSERT INTO mfy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Äbo sika sïme huame tekipanuareom súaka, huanäi ä buía täbuik ä máknake. Huanärim bempo íkäi jíkkajaka, ínel jiaahua: —¡Dios áapo itom áma yeu huíknake! ");
INSERT INTO mfy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Të áapo am bíchaka, ínel jiaahua: —Huanäi ¿jáchisu júntuk jiau báare jäni jü jïojteri? Ínel jiaka: Jume kárita joame jü téta bem omoutekähui, huäri téta tua jum ejkinapo káata naatenäpo huéiye. ");
INSERT INTO mfy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kía jábe júne huäri tétat huéchekame, chíbela kóttinake; jüri téta éntok jábetat kóm huécheko, tókti ä jótanake. ");
INSERT INTO mfy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jume tiöpopo tékiakame sáhueme, éntok jume judíom ley am mamajtíame Jesústa buíj bábarekay huämi horapo, bueïtukim át jünëiak bempörim bétana ä nokakäu juka ejemplota ä yéchakähui. Tem juka genteta májhuey. ");
INSERT INTO mfy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Huanärim éhuil huatem áu jaasek, tü yóremem bénasi emo am nü sáhueka, áamak ejtejhuaka jita nokpo júne yäurata béj‑reka huëpo ä jaatia báreka, yäuratau ä nätua báreka. ");
INSERT INTO mfy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Huanärim ä nátemajek, ínel jíakari: —Maestro, jüneate tua juka lútüriata enchi nokähui, éntok huéchiasi enchi am majtiähui, kaabeta áma yeu púaka juka Diosta böo lútüria em majtiähui. ");
INSERT INTO mfy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Itome tejhua: ¿jachu ítapo juka rey Césarta jume impuestom mákpo yúmala, jehui o ëe? ");
INSERT INTO mfy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Të áapo, ámet jünéaka jáchin am jiau báreka júkäi am nokähui, ínel ámeu jiaahua: —¿Jatchiaka eme junëli nee huite cháaria áma nee tátab báreka? ");
INSERT INTO mfy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Huépul tómitem nee bíttua. ¿Jábesu íkäi pújbak, éntok jábesu am téhuak jume áma jïojterim? Huanärim ínel ä yómmiak: —Bueïtuk jü César. ");
INSERT INTO mfy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Huanäi ínel ámeu jiaahua: —Juka Césarta áttia Césartem ä mákka; juka Diosta áttia éntokem Diosta ä mákka. ");
INSERT INTO mfy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Huanärim kaitachä jaatia máchika taahuak, jita nokpo júnem kara ä jaatiay, jü genteta jíkkajäpo. Áachim guómtilataka taahuak, ä jíkkajaka jáchin am nok yómmiakähui. Huanärim kaa jíaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Huanärim áma yájjak huate saduceom, jume kókkolam júchi jíabitenakeu kaa súaleme. Huanärim ä temajek: ");
INSERT INTO mfy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, jü Moisés ä jïojteri tö sikäpo ínel jiaahua: Senu yoremta ä jubiahua tö mukuk áa bétana kaa usim jípurek, ä sailahuatuk ára ä nüye huaka jámut jókoptulata, usim áachä jípunakë béchïbo ä saihua mukukamta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bueïtukim ímï aaney, guoy búsanika emo sailaka. Huä bát huéeme juubek; të muukuk, kaa üuseka. ");
INSERT INTO mfy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jü ä saila áa sáu huéeme juka jámutta tö kókkota nüka. Huanäi két muukuk, kaa üuseka. ");
INSERT INTO mfy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huä bájim huëpo jüri kéchä nüka. Júnëli sïme jume guoy búsanikam ä juubek, éntokim kókkok, kaa usim át jípureka. ");
INSERT INTO mfy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chúkula éntok két jü jámut muukuk. ");
INSERT INTO mfy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Huanäisu júnakoy jum kókkolam jíabitëpo, ¿jábesu júntuk hua tua ä jubnakeme? Bueïtuk sïme jume guoy búsanika ä jubekay. ");
INSERT INTO mfy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Huanäi jü Jesús ínel ámeu jiaahua: —Ímï ániapo jume óhuim jujube; jume jáamuchim éntok kukuna. ");
INSERT INTO mfy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Të huame tüisi tahualame, áman téhuekau yúmakame éntok kókkolam jíabitehuamta jájamekame, ámani kaabe emo jujube, nim kaabe kukuna, ");
INSERT INTO mfy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","bueïtukim kara júchi kókkoka tahuanake; ángelesim bénanakemme. Kókkolam násuk bem jíabitekä béchïbo, Diosta üusimtunakemme. ");
INSERT INTO mfy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Áapo, jü Moisés junne, jum ä jïojteripo jü zarza béetemta bétana ä nokäpo, itom ä téjhua kókkolam júchi jiabitenakëhui. Huämi ínel jiaahua: Jü Señor Áapo Abrahamta Dios, entok Isaacta Dios, éntok Jacobta Dios. ");
INSERT INTO mfy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bueïtuk Dios kaa kókkolammeu Dios, ál‑la jiápsammehui; bueïtuk áapörik béchïbo sïmetaka jiápsa. ");
INSERT INTO mfy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Huanäi huate judíom ley am mamajtíame ínel jiaahua: —Maestro, huéchiasë ä nookak. ");
INSERT INTO mfy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kaitam éntok áu nátemaij péaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ínel ámeu jiaahua: —¿Jáchisuntukim juka Cristota Davidta üusï tíiya? ");
INSERT INTO mfy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bueïtuk David Salmompo ínel jiaahua: Jü Señor ín Señorbeu ínel jiaahua: “In bátam bétanë yejte, ");
INSERT INTO mfy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jume enchi béj‑reka kateme em guókim bétuk ín tójäu tájti.” ");
INSERT INTO mfy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Jáchisu júntuk jü Cristo Davidta üussitunake, áapörik Davidta áu ä Señor tíäteko? ");
INSERT INTO mfy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sïme Pueblo ä jíkkajay, huanäi Jesús ä discíipulommeu ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Jume judíom ley am mamajtíame bétana, tüisem emo suaya. Tüisim ä musäule juka tettebek bem sánkonakëhui, áman pláazapo yörisi bem tetebotuahuähui, jum tiöpopo bát bankommet bem jonakëhui, éntok jum jíjïbuähuäpo jume bankom bát jokammet bem jotenakëhui; tüisim ä bäsule. ");
INSERT INTO mfy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jume jámut jókoptulame sïmeta ili bem jípurëhuim am üuhuaka, bempola jíba ä nüye, éntok bem kaa tühua yáarim éso báreka bínhua Diostau buabuana. Ímëi ínel jume chë jiokot máchiraata mabetnakeme. ");
INSERT INTO mfy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jum tiöpopo Jesús jume yún tótomekame bitchak, jum kajapo tómitam joayo, limojna tómita öorehuäpo. ");
INSERT INTO mfy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Huanäi senu jámut jókoptulata tüisi poloobeta bitchak, guoy ili cobre tómita áma ä joayo. ");
INSERT INTO mfy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Huanäi ínel jiaahua: —Lútüriapone ínel enchimmeu jiaahua, ï jámut jókoptula póobe sïmem béppa chë yún ä nénkak; ");
INSERT INTO mfy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","bueïtuk sïme jume huate áma ä óorek, Diosta ofrenda béchïbo, juka nakulia ámeu yeu bïlata. Të áapo ä poloobétukä násuk junne, sïmeta ä jípurëu ái ä jíapsinakeu áma óorek. ");
INSERT INTO mfy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Huate jü tiöpota bétana náu ejtejhuay, ujyorisi ä bíttu bétana téta ujyoyorimmea ä yáari béchïbo, éntok huate jítasu jäni áma Diostau näikiaritayi. Huanäi Jesús ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Taahuari yúmanake íkäi sïmeta enchim bíchäu tátabnähui. Kía huépul téta júne kaa nat béppa joka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Huanärim ínel ä temajek: —Maestro, ¿jahueysu ayunake ïri? ¿Jíta señalsu ayunake íkäi huée báareyo? ");
INSERT INTO mfy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús éntok ínel jiaahua: —Jítachem suuhua, kaabe enchim bäitäunake. Bueïtuk büruka yáijnake ín téhuampo, ínel jíaka: “Ínapone jü Cristo”, éntok ínel jíaka: “Ïri ájäria jü taahuari.” Të eme katem am guojaanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Éntokem juka nássuahuamta bétana nokhuay jikkaijnake. Éntok genteta emo béj‑reka emo tóboktiay, katem guómte; bueïtuk jíba ïri bát huéenake; të kee jee yuuma, juka ániata luutinakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Huanäi ínel ámeu jiaahua: —Jume naciónim huate naciónim béj‑reka emo tóboktianake; jume reyim éntok huate reyim béj‑reka náassuanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jü buía buere áu yoyoonake; tüisi tébaatunake; génte éntok máujnake. Kökoa ayunake kía ják junne; jum téhuekapo éntok buere señalim ayunake. ");
INSERT INTO mfy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Të sïmeta íkäi kee huéy, enchimim buíjnake, éntokim enchim guojajjanake. Huanärem sinagogammeu yeu tóijna, éntokem páttiana cárcelimpo. Reyimmehuem yeu tóijna, éntok gobernadorimmehui, ín nésahui enchim jo bárë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ïri enchimmeu huéenake enchim ino bétana tühuata ámeu noknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Katem át obisi éiya enchim jiápsipo, jáchin o jita enchim noknakeu emo jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bueïtuk ínapo huaka nokta enchim téjhuaanake, éntok jüneehuamta enchim miknake. Huämakïrim béja am kóba jáptetuanake; karam enchim nok béj‑reka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Të kía enchim áchayim junne, enchim sailam, enchim huahuajim, éntok enchim amiigom yäura mámpo enchim jóanake. Huatemim enchimmak kateme súanake; ");
INSERT INTO mfy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","sïmetaka enchim kujti érianake, ín nésahui enchim jo bárë béchïbo; ");
INSERT INTO mfy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","të hua huépul chonita júnem kaa tärunake. ");
INSERT INTO mfy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yánti enchim jiapsä béchïbem yönake, yü jíapsi béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Eme béja juka buere joära Jerusalénta sontarommea kóntiata bichäteko, jüneäem läuti ä tátabnähui. ");
INSERT INTO mfy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Huanäi jume Judea buiärapo aneme éläpom káhuiu huáttinake. Huame Jerusalémpo aneme éläpom áma yeu kannake; huame bem et buíapo aneme kaa áman nóttinake. ");
INSERT INTO mfy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bueïtuk ímëi jume taahuarim jiokot máchiraata ámet huéenakëhui, sïmeta ä jïojteri jiäpo áman yeu chúpanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Poloobesitomme, huame abe äasoame, éntok huame ili usim ujüume huamechï taahuarimmechi! Bueïtuk tüisi jiokot máchira huéenake ímï ániapo; Diosta omtira ïri pueblota béppatunake. ");
INSERT INTO mfy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ejparammeyim mëna. Huate pereesomtaka núk sákana, sékäna buiärau bíchaa. Huanäi béja jü Jerusaléntat jume kaa judíom át chéptisunake, jume kaa judíom tiempota yumäu núkisi. ");
INSERT INTO mfy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Huanäi jum täapo señal ayunake, éntok mechapo, éntok chókimpo; jum buíapo éntok jume naciónim jiokot éenake, éntokim guómtilataka annake, hua máusi machisi bahueta omtëu jíkkajaka, éntok jume máarem. ");
INSERT INTO mfy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huä génte máuj kókkonake, hua ím ániapo huéenakemta bíchaka; bueïtuk hua téhuekapo úttiära ayukame júne áu yoyoonake. ");
INSERT INTO mfy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Huanärim ä bínnake, juka Yoremta Üusi, namupo yepsamta ä lóoriamaki, éntok ä úttiäramaki. ");
INSERT INTO mfy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Íkäi huée táytekem emo óusi éetua, éntokem jikau kóbate, bueïtuk enchimmeu jëla ansime jü tü taahuari Diosta bétana enchim jínëuria. ");
INSERT INTO mfy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Két íkäi ejemplota ámeu yétchak: —Jukem chuna óuguotat suuhua, éntok kía täbui júyatat junne. ");
INSERT INTO mfy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Béja jume ili sáhuam yeu basihuey, emem jüneenake, juka tebuj‑riata yebijnakeu kaa mékka bëyëhui. ");
INSERT INTO mfy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Júnëli két eme, íkäi jita huémta bichäteko, jüneenakeem itou jëla ä ansimëhui, juka Diosta reytaka ímï nésaunakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Tua lútüriapone ínel enchimmeu jiaahua, sïme ïri huéenake, kee juka genteta én huémta luuteyo. ");
INSERT INTO mfy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jü téhueka éntok jü buíya luutinake, të ín noki jíba bénasi huéenake. ");
INSERT INTO mfy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Emóem suaya; katem juka enchim jíapsi námakasi johua, kaa huéeläpo jïbuähuamtay éntok vino jïhuamtay, éntok buere kaa yúmahuamtayi, kaa huakäi taahuata enchim jaatianakë béchïbo kaa ínel enchim éäpo. ");
INSERT INTO mfy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bueïtuk huiteriy am choïlakamta bénasi áme béppa huénnake, jume sïme ímï buíapo anemmechi. ");
INSERT INTO mfy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Katem kótche. Jíba yü tutti Diostahuem nokaka jiápsa, ïri huéenakemta bétana enchim áma yeu yorenakë béchïbo. Júnëlem kaitat jáchin éaka, Yoremta Üusi bíchäpo emo yeu jäbuanake. ");
INSERT INTO mfy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús jum tiöpopo taahuapo am majtiay; tukaapo éntok káhui Oliivo ti téhuaakamtau bíchaa sisimey. ");
INSERT INTO mfy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kethueytana éntok sïme génte áu náu yayajay, tiöpopo ä nok jíkkaij báreka. ");
INSERT INTO mfy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Béja kaa jaikika bëyey juka buere pajkota yúmanakëhui, jume páanim kaa levaduuraka buabuähuähui, pájcua ti téhuaakame. ");
INSERT INTO mfy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jume tiöpopo tékiakammeu chë nésahueme, éntok huame leyta am mamajtíame át tekipanuay jáchin juka Jesústa bem mëtebonakëhui, bueïtukim juka genteta májhuey. ");
INSERT INTO mfy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Huanäi jü Satanás Judastat kibakek, hua Iscariote ti téhuaakamtachi, hua dooce apóstolimmak näikiatukaïhui. ");
INSERT INTO mfy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ïri huame tiöpopo tékiakammeu chë nésahuemmeu nookak, éntok huame yäuchimmeu tiöpota suayammehui, jáchin juka Jesústa bem mámpo ä tóijnake bétana. ");
INSERT INTO mfy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bempo al‑leaka taahuak, éntokim tómita ä mák rókaka nookak. ");
INSERT INTO mfy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Áapo béja júkäi yáa rókaka taahuak. Huanäi át tekipanua táytek, jáchin ayuka kaa büru genteta bíchäpo bem mámpo ä tóijnakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jü taahuari páanim kaa levaduuraka buabuähuäu yuumak, huaka ili kabarata át mënähui, pájcua ti téttehuaahuame. ");
INSERT INTO mfy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Huanäi Jesús juka Perotau éntok Juantau ínel jiaahua: —Ámanem sájaka juka abe jëla itom buänakeu yáabo, pájcuata. ");
INSERT INTO mfy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bempo éntok ä temajek: —¿Jákusë itom ä yáa ïa? ");
INSERT INTO mfy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús éntok ínel ámeu jiaahua: —Huam pueblou kimütekem senu yoremta bínnake, sótöpo bäam huériamta. Áa sáukem kaate, ä jóau ä kibakeu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Huanärem jü jóakamtau ínel jiaunake: “Jü Maestro ínel nokta émou bíttuak: ¿Jáksu júntuk káttek, jü káari juka pájcuata áma buä béchïbo ín discíipulommaki?” ");
INSERT INTO mfy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Huanäi áapo enchim ä téjhuaanake, juka cuartota buëuruk jikat kátekamta béja tüteta. Huämïrem ä yáanake huaka itom buänakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bempo éntok áman sájaka ä téuhuak, juka sïmeta Jesústa am téjhuakä bénasi, éntokim ä yáuhuak, pájcuata bem buanakëhui. ");
INSERT INTO mfy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Juka horata yúmak, jü Jesús jume apóstolimmak mesau yejtek. ");
INSERT INTO mfy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Huanäi ínel ámeu jiaahua: —¡Tepane íkäi pájcuata enchimmak bua péiyay, ketune kee jiokot nee yáahuayo! ");
INSERT INTO mfy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bueïtukne ínel enchimmeu jiaahua, kanne júchi pájcuapo jïbuänake, júnakoy jübua áman Diosta chë yötaka ä kátekäpo áu ä chúpayo. ");
INSERT INTO mfy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Huanäi juka vaasota nüka Diostau baisáusuka ínel jiaahua: —Ikärem nüka nachä näikimte; ");
INSERT INTO mfy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bueïtukne enchimmeu ínel jiaahua, kanne júchä jïnake, íkäi páraj taka bähuata, júnakoy jübua áman Diosta chë yötaka ä kátekäpo äbo kóm ä yepsayo. ");
INSERT INTO mfy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chúkula jume páanim nüka, Diostau baisáusuka, ámecham näikimtek, ínel jíaka: —Ïri jü ín takahua enchim béchïbo nénkitunakeme. Íkärem johua, inou enchim huáatinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Két jíba ánëli, chúkula jïbuäsuka, juka vaasota nüka, ínel jíakari: —Ïri vaaso ínel jü bemelasi Diostamak nokta náu yáarime; ín ójbo guötekamtay béjhuata jípunake, enchim béchïbo guötekame. ");
INSERT INTO mfy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Të én ín mesapo ínomak aane, jü nee nénkinakemta mámmam. ");
INSERT INTO mfy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tua lútulay jü Diosta Üusi jíba huéesime juka áa bétana näikiarita jiäpo ámani; ¡të tepa jiokochia huäri yoreme jü bem mámpo ä tóijnakeme! ");
INSERT INTO mfy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Huanäi bempo emom temaij táytek, ä jábétukähui jäni hua ä nénkinakeme. ");
INSERT INTO mfy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Huanärim náu nok nássua táytek, jábeta chë yöpo tahuarianähui. ");
INSERT INTO mfy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Të áapo ínel ámeu jiaahua: —Jume naciónimmeu reyim tüisim buéresi emo nésaule sïmem béppa, éntok sïme jume géntemmeu yäuchim áme béppa nésahueme, huamerim ínel tü yóremem tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Të eme kaa junëli emo nünake. Ál‑la hua chë yöpo áu jípureme, usi jübua yötu sáyhuamta bénasi áu érianake; hua nésahueme éntok, két sáyhuamta bénasi áu érianake. ");
INSERT INTO mfy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bueïtuk, ¿jábesu jü chë yörihuame, hua mesau yejteka jïbuäme, o buähuamta áu totojame? ¿Jachu kaa lútüriapo ájäria hua mesau kátekame? Të ínapo enchim násuk aane, hua sáyhuamta bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Eme ámëria huame jíba ínomak aneme, huam jiokot máchiraata inou sikäpo. ");
INSERT INTO mfy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ínapone ínëli enchim ä mákka, juka rey nésauta enchim jípunakëhui, ín Átchay nee ä mákakä bénasi, ");
INSERT INTO mfy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","enchim huam ín mesapo ínomak jïbuanakë béchïbo éntok ínomak jïnakë béchïbo ín reytaka nésahuepo, éntok huam yörisi machiku joteka jume dooce Israelta üusimmet yeu kat‑riammet nokta enchim chúpanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ínel két jiaahuak jü Señor: —¡Símon, Símon, áachë suuhua! Jü Satanás enchim áula, tirijkom yoohuä bénasi naa múksi enchim emo bít ïaaka; ");
INSERT INTO mfy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","të ínapo enchi nok‑riak Diosta em súalëu kaa émou bïnakë béchïbo. Empo éntok nóttekätek, jume émomak huéerimmeu nooka, óusi am éenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peero éntok ínel áu jiaahua: —Señor, huittine eiya cárceliu ín huéenakë béchïbo, éntok émomak ín muknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús éntok ínel áu jiaahua: —Peero, émoune ínen jiaahua, ëni kee juka tótorörata kusey, baisë kaa nee emo täya tíanake. ");
INSERT INTO mfy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Huanäi jü Jesús am temajek: —Júnak nee enchim yeu jaaseko kaa morraaleka, kaa tómeka, éntok kaa bochaka, ¿jachu jita enchimmeu bëka? Bempo ínel au jiaahuak: —Kaita. ");
INSERT INTO mfy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Huanäi ínel ámeu jiaahua: —Të én ál‑lem hua morraalim jípureme am huérianake, éntok juka tómi bóosata; hua kaa ejparam jípureme ä kapam nénkaka am jínnunake. ");
INSERT INTO mfy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bueïtukne ínel enchimmeu jiaahua, inot chúpatunake hua jïojteri ínen jíame: “Jume juëna yórememmak näikiahuak.” Bueïtuk sïme hua ino bétana jïojteri chúpanake. ");
INSERT INTO mfy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Huanäi bempo ínel jiaahuak: —Señor, ímï guoy ejparam óorek. Huanäi áapo ínel ámeu jiaahua: —Júmemak türi. ");
INSERT INTO mfy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Huanäi Jesús Oliivo káuta kátekäu bíchaa siika, jíba ä aánë bénasi. Jume ä discíipulom éntok ä guojaasek. ");
INSERT INTO mfy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Áman yepsaka ínel ámeu jiaahua: —Diostahuem oraciompo nooka, kaa jum jiobilahuápo huet béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Huanäi Jesús ili mékka bíchaa siika, tétata jímmä bëmu. Huanäi tónommia kíkteka, Diostau oraciompo nookak, ");
INSERT INTO mfy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ínel jíakari: —In Átchay, empo ínel íäteko, ímëi bäam kökosi ín ínnënakeu, nechë ä táktiria kaa ín am jïnakë béchïbo. Të kaa ín ä huáatiäpo ámantunake, ál‑la em ä huáatiäpo ámani. ");
INSERT INTO mfy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Huanäi ángel áu yeu machiak téhueka bétana, úttiata ä mák báreka. ");
INSERT INTO mfy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huanäi tüisi jiokot aneka, chëhuasu úttiaka Diostau oraciompo nookay. Huanäi jü ä bäarútti kía ójbo ténasi chákteka buíau tájti kóm huáttey. ");
INSERT INTO mfy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Huanäi Diostau oraciompo noksuka kíkteka, ä discíipulommeu bíchaa siika. Huanäi kócheme téuhuak, bueïtuk kaa al‑leerimmea yetem ámet huéchilatukay. ");
INSERT INTO mfy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Huanäi ínel ámeu jiaahua: —¿Jatchiakasem kótche? Jotekem, Diostau oraciompo nooka huaka enchim jioptua báaremta kaa enchim ä yúmanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ketune nookay, juka genteta juebenak áma yájako. Huä Judas ti téhuakame, jume dooce ä discíipulommak näikiatukaïhui, ámepat huéiyey. Huanäi Jesústau rúkteka ä besiito bábarek. ");
INSERT INTO mfy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Huanäi Jesús ínel áu jiaahua: —Empo Judas, ¿jache besiitoy ä nénka, juka Yoremta Üusi? ");
INSERT INTO mfy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jume áamak aneme juka huée báaremta bíchaka, áu ínel jiaahua: —Señor, ¿jachute ejparammea kökosi am yáanake? ");
INSERT INTO mfy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Huanäi huépülaka juka tiöpopo chë nésahuemta sáhuëu mámäkoka nákam báta bétana huéeme ä chúktiriak. ");
INSERT INTO mfy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Huanäi Jesús am yómmiaka ínel ámeu jiaahua: —Akem am tójja, béjja. Huanäi Jesús hua náka chúktiahuakamtat mámteka ä tütek. ");
INSERT INTO mfy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Huanäi Jesús jume tiöpopo nésahuemmeu éntok tiöpota suayammeu yäuchimmeu, éntok ou yoiyöturim pueblou yeu púarimmeu, áman ä nübokammeu ínel jiaahua: —¿Nee lak‑rontukä bénasi eme ejparaka éntok kúkutaka inou yeu sájjak? ");
INSERT INTO mfy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Huam tiöpopo chíkti táapone enchimmak aaney. Kía júnem inou kaa mám rútukteka nee jaatiak. Të íkäi horata, eme ä áttiak; jü kaa máchiraa nésahue. ");
INSERT INTO mfy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Huanärim Jesústa pereesoteka, ä núk sájjak, jü tiöpopo chë nésahuemta jóau bíchaa. Peero éntok mékkäriat ä guojaasey. ");
INSERT INTO mfy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Huanäi jume sontarom tebat násuk náaka, nate chíkola áma jotek. Peero éntok két áme násuk yejtek. ");
INSERT INTO mfy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Të senu jámut jóapo sáyhuame, Perota tájimmeu kátekamta bíchaka, ínel jiaahua: —Ï yoreme két áamak aaney. ");
INSERT INTO mfy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Të áapo “ëe” ti áu jiaahua: —Empo jámmut, kannä täya. ");
INSERT INTO mfy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chúkula júchi senu ä bíchaka ínel jiaahua: —Émpë két ámemak joome. Të Peero ínel jiaahua: —Ómme, ínapo kaa ájäria. ");
INSERT INTO mfy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jíba tua senu horata simsuko, täbuika két áu ä täya tíaka nookak, ínel jíaka: —Tua lútüriapo ïri két áamak aaney, bueïtuk Galiléapo joome. ");
INSERT INTO mfy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Huanäi Peero ínel jiaahua: —Ómme, kanne jüneiya jita em nokähui. Huärit chäka, ketune áapörik nokaysu, jü tótoröra kukusek. ");
INSERT INTO mfy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Huanäi jü Señor kúakteka juka Perotat suuhuak. Huanäi jü Peero jü Señorta áu nokakäubeu huahuaatek, ínel áu ä jíakähui: “Kee juka tótorörata kusey, baisë kaa nee emo täya tíanake.” ");
INSERT INTO mfy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Huanäi jü Peero päkun yeu sika tüisi siroksi buaanak. ");
INSERT INTO mfy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jume yoremem Jesústa suayame tüisim ä junneriay, éntokim ä bébbay. ");
INSERT INTO mfy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Éntokim ä puj súmaka, pújbachä bébbay. Huanärim ä nátemajey, ínel áu jíakari: —Akë ä seetaroa, ¿jábesu enchi bébba? ");
INSERT INTO mfy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Éntok huatek bürukim juënasi ä pújbapo áa bétana nookak. ");
INSERT INTO mfy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yeu matchukim emo náu núnnuk, jume ou yoiyöturim judíom pueblopo yeu púari, jume tiöpopo nésahueme, éntok jume leyta am mamajtíame. Huanärim juka Jesústa bem bíchäpo yeu tójjak. Huanärim ä temajek: ");
INSERT INTO mfy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Itomë téjhua, ¿empo ájäria jü Cristo? Áapo éntok ínel am yómmiak: —Jeehui ti nee jíay junne, kaibem nee súalnake. ");
INSERT INTO mfy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Enchimmeu nee nátemay junne, kaibem nee yómmianake, éntokem kaibu nee búttianake. ");
INSERT INTO mfy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Të én naateka jü Yoremta Üusi juka Diosta sïmem béppa úttiakame bátam bétana yejtenake. ");
INSERT INTO mfy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Huanäi sep sïme ä nátemajek: —¿Huanäi empo jü tua Diosta Üusi? Huanäi Jesús ínel ámeu jiaahua: —Eme lútüriapo nee ájariä tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Huanäi bempo ínel jiaahua: —¿Jíta béchïbosute testiigom huáatia? Ítapote ä tempo ä jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Huanäi jü génte juebénaka áu tóboktiaka, Jesústam Pilatotau núk sájjak. ");
INSERT INTO mfy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Huanärim ä nätua táytek, ínel jíaka: —Íkäite téula, juka naciónta täbuiasi majtiamta. Rey Césarta kaa impuestom mák nésahue. Áapo Cristopo áu nanäikia; junëli éntok áu rey tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Huanäi jü Pilato ä temajek, ínel jíaka: —¿Jachë empo jume Israelpo judíommeu Rey? Huanäi Jesús ä yómmiak: —Empo lútüriapo ínel jiaahua. ");
INSERT INTO mfy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Huanäi Pilato ínel ámeu jiaahua jume tiöpopo nésahuemmehui, éntok jume géntemmehui: —Kaitane juënak át téuhua, ï yoremtachi. ");
INSERT INTO mfy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Të bempo chë úttiata johuay, ínel jíaka: —Juka genteta sïme Judea buiärapo jometa áu tóboktitua jü ä majtiäubeyi. Jum Galiléa buiärapo naateka, éntok jíba ä josimey, äbo tájti. ");
INSERT INTO mfy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Huanäi jü Pilato, Galiléa buiärapo ti jíayhuamta jíkkajaka, nátemajek: —¿Jachu ï yoreme Galileo? ");
INSERT INTO mfy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Huanäi jeehui ti áu jiaihuak, Heroodesta nésahuepo joome. Huanäi Heroodestau ä bíttuak. Huámechi taahuarimmet éntok jü Heroodes buere joära Jerusalémpo aaney. ");
INSERT INTO mfy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodes juka Jesústa bíchaka, tüisi al‑leaka taahuak. Bínhua naateka ä bít péiyay. Yún jita áa bétana jíkkaij‑latukay, éntok kaa jaibu johuamta ä bíchäpo ä yáanakeu ä bít péiyay. ");
INSERT INTO mfy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Juebénasi ä temajek, të Jesús kaa ä nok yómmiak. ");
INSERT INTO mfy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ámam aaney, két jume tiöpopo tékiakammeu nésahueme éntok judíom ley am mamajtíame. Katim chúktemta nokaka ä nätuay. ");
INSERT INTO mfy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Huanäi jü Heroodes éntok jume ä sontarohuam kía kaitäpo ä bít táytek. Huanärim ä junneria báreka reyta bénasi ä sánkotuak, béj‑remta éntok ujyorik. Huanäi jü Heroodes júchi jü Pilatotau ä bíttuak. ");
INSERT INTO mfy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Huanärim náu türi táytek Pilato éntok Heroodes huäri taahuarit naateka; bueïtuk bannaatakam kaa náu türiakay, náhuim öomtilatukay. ");
INSERT INTO mfy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Huanäi jü Pilato jume tiöpopo tékiakammeu yäuchim náu núnuka, éntok huate yäuraata, éntok juka genteta, ");
INSERT INTO mfy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ínel ámeu jiaahua: —Eme íkä yoremta inou nüpak, genteta áu ä tóboktituä tíaka; të ínapo bürusine ä temajek enchim jíkkajäpo; béjem jüneiya kaitane juënak át téuhuak, enchim áa bétana ä nätuähui. ");
INSERT INTO mfy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Éntok Heroodes junne, kíalïku itou ä bíttuak. Béjem ä bitcha; kaita béttesi yáala, juka nokta mukiapo át chúpanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anä bemmuchateboka ä búttia báare. ");
INSERT INTO mfy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jü Pilato jum pajko táapo huépul pereesota butbúttiay, jíba bem ä boojoriapo bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Të sïme jü génte senu huéchiapo huépülay bénasi jijiak, ínel jíakari: —¡Päkunem yeu ä huéria júkäri, áman ä më béchïbo! ¡Barrabásta éntoke itou ä búttiatebo! ");
INSERT INTO mfy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ïri cárcelpo jípuhuay. Yäurata béj‑reka huatemmak áu tóboktialatukay jum pueblopo; senuk éntok két mëlatukay. Huäri béchïbo páttiatukay. ");
INSERT INTO mfy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jü Pilato juka Jesústa búttiatebo báreka, júchi ámeu nookak, ");
INSERT INTO mfy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","të bempo júchi chë kusisi chay táytek, ínel jíakari: —¡Kúrusichem ä popontebo! ¡Kúrusichem ä popontebo! ");
INSERT INTO mfy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bájikum huëpo, jü Pilato júchi ínel ámeu jiaahua: —¿Jatchiaka jita juënaksu yáala? Ínapo kaita át téula mukiapo nokta át chúpnakë béchïbo. Anä bemmuchateboka ä búttianake. ");
INSERT INTO mfy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Të bempo jíba júchi chë kusisi chay táytek, kúrusit ä popon nésahueka. Huanäi jü bem jiahuia éntok jume tiöpopo chë nésahueme jiahuia, akim ä yúyüuk. ");
INSERT INTO mfy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Huanäi béja jü Pilato nokta át chúppak, ä mëna béchïbo bempörim ä aahuäpo ámani. ");
INSERT INTO mfy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Huanäi béja ä búttiak, juka yäurata béj‑reka huatemmak áu tóboktiakäuta, éntok senuk mëlataka cárcelpo yéchatukäuta. Jesústa éntok bem mámpo yétchak, bem ä yáa bárëpo áman ä yáa ïaka. ");
INSERT INTO mfy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jukam Jesústa huériaka kúrusichä poponboka, senu yoremtam buíssek, Cireene buiärapo jometa Símon téamta, huasa bétana huémta. Huanärim juka kúrujta ä püaktituaka, Jesústa sáu ä huériutuay. ");
INSERT INTO mfy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huanäi génte tüisi büruka pueblopo jometaka áa sáu kaatey, éntok jáamuchim ä buanria sákame, éntokim ä sirok‑riay. ");
INSERT INTO mfy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Të Jesús ámeu kúakteka ínel ámeu jiaahua: —Jerusalémpo malariam, katem ino béchïbo buaana, ál‑lem enchim béchïbo buaana, éntok enchim üusim béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bueïtuk taahuari yúmanake, ínel jiaunähui: “Al‑leenakemme, jume kaa asoame éntok jume jauhuey júne kaa asoalame, jume kaabeta chïtuakame.” ");
INSERT INTO mfy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Huanärim káhuimmeu ínel jiau táytinake: “¡Ito béppem huátte!” Jume ili júya káhuimmeu éntok: “¡Itomem ésso!” ");
INSERT INTO mfy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bueïtuk jü kúta síarita ínëli joatek, ¿jítasum áu yáanake jäni jü kúta huakiahui? ");
INSERT INTO mfy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Guoy juëna yórememim huériay kétchi, Jesústa béucham mëboka. ");
INSERT INTO mfy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Áman mukila kóba káhuï téäu yájakam juka Jesústa kúrusit poponak, éntok huame guoy juëna yóremem áa béuchi, huépülak ä bátam bétana, senuk éntok ä míköri bétana. ");
INSERT INTO mfy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Huanäi Jesús ínel jiaahua: —In Átchay, Akë am jiokore, bueïtukim kaa jüneiya jita bem joähui. Jume sontarom éntok, juka Jesústa sánko näikimtek. Huanäi náhuim ä jätek. ");
INSERT INTO mfy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jü génte éntok ä bitchay, éntok jume kobanarom júne két ä junneriay, ínel jíakari: —Jume huatem jínëuk. Én éntok éläpo áu jínëunake, áapo tua jü Cristotuko, jü Diosta yeu púari. ");
INSERT INTO mfy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jume sontarom júne ä junneriaka áu rúkteka, bäa chibuta ä jïtuay, ");
INSERT INTO mfy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ínel áu jíaka: —Empo judíommeu reytuk, emoë jínëu. ");
INSERT INTO mfy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jü jïojteri éntok ä kóba béppa yáatukay. Griego nokpo jïojteritukay, latínpo éntok hebreopo, ínel jíaka: “Ïri ájäria jü judíommeu Rey.” ");
INSERT INTO mfy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Senu juëna yoreme áabeu chäkame ä junneria jiaahuay, ínel jíaka: —Empo jü Cristotukätekë emo jínëu, éntok itom kétchi. ");
INSERT INTO mfy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Të jü senu áu omteka ínel áu jiaahua jü senukuhui: —¿Jachë kaa Diosta májhue, empo két jíba alë bénasi jiokot machisi nokta emót chúpilatuk junne? ");
INSERT INTO mfy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Lutüriapote ítapo ä ínnëa, juka tüisi itou johuamta. Kaa tühuatate mabeta juka itom yáakä béchïbo; të ï yoreme kaita juënak yáala. ");
INSERT INTO mfy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Huanäi Jesústau ínel jiaahua: —Inohuë huáate, béja reytaka äbo yepsäteko. ");
INSERT INTO mfy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús éntok ínel ä yómmiak: —Lútüriapone ínel émou jiaahua, enë sep ínomak annake, áman paraísöpo. ");
INSERT INTO mfy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jíba tua béja lúl‑la kátekay. Huanäi sïme ániat kaa machika taahuak, bájim jiäu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Huanäi jü täa kaa machisi taahuak. Jum tiöpopo éntok, jü cortina násuk áman síutek. ");
INSERT INTO mfy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Huanäi Jesús tüisi kusisi cháchayek, ínel jíaka: —In Átchay, em mámpone juka ín espíritu yétcha. Ínëli jiausuka muukuk. ");
INSERT INTO mfy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Huanäi hua romapo sontaro yäut íkäi bíchaka, Diosta úttileka taahuak, ínel jíaka: —Lútüriapo ï yoreme lútüla jíapsihuamta jípurey. ");
INSERT INTO mfy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sïme jü génte juebena áma aneïhui, íkäi ínëli huémta bíchakame, táhuit emo chónaka sájjak. ");
INSERT INTO mfy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Të sïme jume Jesústa täyähuim, éntok jume jáamuchim Galiléau naateka áamak kateïhuim, mékkäriat tahuaka ä bitchak, juka huémta. ");
INSERT INTO mfy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Senu yoreme áma aaney, tü yóremtaka entok lútüla jiápsaka, José tï téhuaka, jum pueblo Arimateapo jometaka, Judea buiärapo. Áapo jum judíom buere yäurapo tékiakay. ");
INSERT INTO mfy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ïri két juka Diosta reytaka ä nésaunakeu boobíchaïhuiy. Kaa ámebeu ä türey, juka jita benak Jesústau am yáakähui. ");
INSERT INTO mfy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatotau sika Jesústa takahua áu aahuak. ");
INSERT INTO mfy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kúrusit kóm ä yéchaka, sábanampo ä bïtiak. Huanäi téta guójöria bemelapo étapopo ä óorek; kaabe áma jee órehuay. ");
INSERT INTO mfy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huäri taahuarit sïme huéchiapo óorehuay, bueïtuk jü jimyóre taahuari abe naatey. ");
INSERT INTO mfy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jume jáamuchim Jesústamak áma yáij‑latukaïhuim Galiléa bétana, ámanim sájaka ä bitchak, jum téta guójöriapo ä maahuakäpo; éntokim át suuhuak, ják ä tekhuakähui juka ä takahua. ");
INSERT INTO mfy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Huanärim bem joau nótteka, yünim jita musäla jubak yáuhuak, éntok unhuentom. Huanärim jimyore taahuapo jimyoorek, Diosta leyta ä jiäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lominko taahuata yúmak, kethueysu, jume jáamuchim ä maahuakäpo yájjak, juka bäata musälam jubak huériaka bem yáakähui. Huate jáamuchim éntok, ámemak kaatey. ");
INSERT INTO mfy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Huanärim juka téta guójöriata étaporita téuhuak. Jü téta ái páttiari sékäna órekamtam bitchak. ");
INSERT INTO mfy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Huanärim áman kimuka, juka Señor Jesústa takahua kaa áma téuhuak. ");
INSERT INTO mfy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Guómtilamtakam kaachin an máchiakay. Huanärim guoy yoremem bitchak, áme náapo jäbuekame bélojkok sánkokame. ");
INSERT INTO mfy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bempo májhueka, buíau tájti kóm müla chätuk. Huanärim ínel ámeu jiaahuak, jume yoremem: —¿Jatchiakasem kókkolam násuk juka jiápsamta jaria? ");
INSERT INTO mfy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kaa ím aane; béja jíabitek. Áhuem huáate jita enchimmeu ä nokakähui, ketune Galiléa buiärapo aneka, ");
INSERT INTO mfy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ínel jíakari: “Tepa jíba jume yoremem jujuënam mámpo tóijna jü Yoremta Üusi, éntok kúrusit mëtunake. Huanäi éntok báij taahuarim huéy mukilataka jíabitenake.” ");
INSERT INTO mfy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Huanäi bempo áu huahuaatek, jü Jesústa nokibehui. ");
INSERT INTO mfy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Huanäi bempo campo santo bétana nótteka, jume once apóstolimmeu sïmeta íkäi nookak, éntok jume huatemmehui. ");
INSERT INTO mfy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jume íkäi nokta apóstolimmeu tójakame: jü María Magdalena, Juana, María Jacobota áiye, éntok huate jáamuchim. ");
INSERT INTO mfy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Të jume apóstolim íkäi nokta kaa ä súäratukä bénasi ä ériay; kíalïkum kaa am súaley. ");
INSERT INTO mfy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Të jü Peero yejteka, ä mäariu bíchaa búitek. Huanäi béja huáijhua kibakeka, jume sánkom bempolaim bitchak. Huanäi juka áman yeu sikamtat bíchaka, guómtilataka ä jóau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Bueïtuk huäri taahuarichi, guoyika Jesústamak rejteïhuim náhuim kaatey, pueblo Emáus ti téhuaakäu bíchaa; once kiloometropo Jerusaléniu taahuay. ");
INSERT INTO mfy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Juka sïmeta áma yeu sikamta, náhuim ä ejtejhuaasakay. ");
INSERT INTO mfy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Júnëli náu am nok sákaysu éntok náu am nok nássuay, Jesús ámeu rúktek. Huanäi ámemak boojo táytek. ");
INSERT INTO mfy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Të ä bíchaka, júnem kaa jüneiyay ä jábétukähui, bueïtuk lútüriata bem jüneríanakeu kee jee ámeu yeu machiay. ");
INSERT INTO mfy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Huanäi ínel ámeu jiaahua: —¿Jítasem náu ejtejhuaasime, éntok jatchiakasem siroka? ");
INSERT INTO mfy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jü senu ä yómmiak, Cleofas ti téhuaakame. Huanäi ínel áu jiaahua: —¿Jachu empo jíba kaa ímï jometaka juka én ímï taahuarimmet Jerusalémpo jita yeu sikamta kaa jüneria? ");
INSERT INTO mfy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Huanäi áapo ínel ámeu jiaahua: —¿Jítasu áma yeu siika? Huanärim ínel áu jiaahua: —Jü Jesús Nazarenota bétana, bueïtuk áapo senu profeetatukay, tua úttiata jípureme jume jita ä joäpo éntok ä nokäpo, Diosta bíchäpo éntok sïme pueblota bíchäpo; ");
INSERT INTO mfy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","éntok jáchin huame tiöpopo tékiakammeu chë nésahueme éntok itom yäuram nokta át chúppak, ä mënä bétana kúrusichä poponteboka. ");
INSERT INTO mfy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ítapo ä boobíchaïhuiy, áapörik juka Israelta jínëunakëhui. Ëni íäri béppa, béja báij taahuarim huéiye, ïri simlataka. ");
INSERT INTO mfy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Të két jume huate jáamuchim ito násuk aneme két itom guómtiak, bueïtuk marikaroapom ä maahuakäu nóitek. ");
INSERT INTO mfy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Huanärim éntok juka ä takahua kaa áma téaka, itou yájaka itom ejtejhuariak, Diosta ángelesim bénam emo bíchak tíaka. Ímëi éntok Jesústa jiapsä tíiya. ");
INSERT INTO mfy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jume huate itomak joome áman nóitek, jum campo santohui, ä maahuakäpo. Huanärim jume jáamuchim jíakäpo áman emo ä bíchak tíiya, tërim áapörik kaa bitchak. ");
INSERT INTO mfy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Huanäi áapo ínel ámeu jiaahua: —¡Tepem kaitat suuhua, éntokem kara jita súale enchim jiápsipo, sïmeta jume profeetam nokakähui! ");
INSERT INTO mfy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Jachu kaa junëli kökosi áu ä huéenakeu úttiatukay jäni jü Cristotahui, kee jee lóoriau ä kibakeyo? ");
INSERT INTO mfy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Huanäi béja juka jïojteta áa bétana nokamta ámeu nok táytek, Moiséjta librompo naateka jume profeetam librommeu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jum pueblou bem sájakäu yájaka, Jesús jíba ä böo huéria báarem ténasi ayka. ");
INSERT INTO mfy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Huanäi bempo kía úttiapo bénasi ä tahuariak, ínel jíakari: —Itomake taahua, emo bia kúpte, jü täa béja áman huétche. Huanäi Jesús áman kibakek, ámemak tahua báreka. ");
INSERT INTO mfy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Huanäi béja ámemak huam mesau káteka, jume páanim nüka Diosta tü eáu ámet chúppak. Huanäi am näikimteka, bempörim miikak. ");
INSERT INTO mfy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ímïri jume bem pusim étapotuk. Huanärim ä tatäyak, të áapo sep áma kaabétuk. ");
INSERT INTO mfy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Huanärim ínel náu jiaahuay: —¿Lútula huëpo, jachute kaa itom jiápsipo táijta bénasi ä ínnëay, itou ä nokayo jum böochi, éntok juka jïojteta itom ä téjhuayo? ");
INSERT INTO mfy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Huanäi huämi horapo jáptekam, Jerusalénihuim nóttek. Huanärim jume once discíipulommeu éntok jume ámemak anemmeu yájjak. ");
INSERT INTO mfy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ímëi ínel jiaahuay: —Jü Señor tua yö éaka jíabitek; Símontau yeu machiak. ");
INSERT INTO mfy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jume guoyika éntok két am ejtejhuariak jita jum böot ámeu sikähui, éntok jáchin emo ä tatäyakähui, jume páanim ä näikimteko. ");
INSERT INTO mfy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ketune bempörim íäri bétana náu nokay, Jesús áme násuk áu yeu machiriak, ínel ámeu jíaka: —Yánti jíapsihuame enchimmaktunake. ");
INSERT INTO mfy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Huanärim guómteka éntok májhueka, espíritutam emo bíchä bénasi éiyay. ");
INSERT INTO mfy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Të Jesús ínel ámeu jiaahua: —¿Jatchiakem guómtila? ¿Jítasa jäni ti emo éetua? ");
INSERT INTO mfy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","In mámamem bitcha, éntok ín guókkim. Ínapone ájäria. Inochem mámte, éntokem nee bitcha; bueïtuk jü espíritu kaa tekhuak, éntok kaa óttak, enchim nee bíchäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Huanäi ínel ámeu jíaka, jume mámam éntok jume guókim am bíttuak. ");
INSERT INTO mfy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Të bempörim ketune kaa ä súalë béchïbo huame al‑leerimmea éntok bem át guómtilamtukä béchïbo, ínel ámeu jiaahua: —¿Jítem buä máchik ím jípure? ");
INSERT INTO mfy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Huanärim kúchu jísobata rébbeik ä mákkak, éntok mumu sítörim. ");
INSERT INTO mfy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Huanäi am nüka, am buäka bempörim bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Huanäi ínel ámeu jiaahua: —Íkäi noktane enchimmeu nookak, ketune enchimmak aneka: Sïmeta huaka Moiséjta leypo jïojteta ino bétana chúpnakëhui, éntok huame profeetam libropo jïojteta éntok libro salmompo. ");
INSERT INTO mfy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huanäi juka jüneehuamta am étaporiak, jume jïojteritat am jüneenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huanäi ínel ámeu jiaahua: —Ínëli jïojteri: juka Cristota jiokot yáanahui, éntok ä muknakëhui, ");
INSERT INTO mfy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","éntok áapörik téhuampo sïme géntemmeu ä noknä bétana, Jerusalémpo naateka, ámeu nokaka bem jíapsi kúaktinake bétana, éntok bem Dios bejrim jíokörina béchïbo. ");
INSERT INTO mfy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Emem íkäi bit‑lataka én testiigom. ");
INSERT INTO mfy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Áachem suuhua, ínapone enchimmeu ä bíttuanake, juka ín Átchay nokaka enchimmeu ä bíttua‑rokakähui. Të ímem taahua, Jerusalémpo, huaka úttiata jikat bétana huémta enchim mabetäu tájti. ");
INSERT INTO mfy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Huanäi Jesús päkun yeu am núk siika, pueblo Betaniau bíchaa. Huanäi jikau mámteka, Diosta tü eáu ámet chúppak. ");
INSERT INTO mfy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Huanäi Diosta tü eáu ámet chúpasuka, am tö siika. Téhuekau jikau bíchaa núk sákahuak. ");
INSERT INTO mfy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bempo chúkula ä yörisuka, Jerusaléniu nóttek, tüisi al‑leaka. ");
INSERT INTO mfy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huanärim tiöpopo jíba aaney, Diosta úttileka entok jikau ä chatchaka. Júnentunake.");
INSERT INTO mfy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kësam huëpo jü Noki béja aaney. Ïri Noki Diostamak aaney, éntok ínëli jíba Diostukay. ");
INSERT INTO mfy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ïri jü kësam huëpo jíba Diostamak aneïhui. ");
INSERT INTO mfy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sïme ayukamta áapo ä yáala. Kaa áapörik béchïbotuk kaitatu éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Áapörikut aykay, jü jíapsihuame. Jü jíapsihuame éntok, jü yoremem jíapsita machiriame. ");
INSERT INTO mfy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ïri machiria tachiriata bénasi kaa machiku béete; jü kaa machiria éntok kara ä tuucha. ");
INSERT INTO mfy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Senu yoreme Diosta bétana äbo bíttuataka ímï aaney, Juan ti téhuaaka. ");
INSERT INTO mfy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ïri machiriata bétana nok ïaahuaka äbo bíttuahuak, sïmem ä súalnakë béchïbo, áapörik huämi. ");
INSERT INTO mfy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan kaa jü machiriatukay; ál‑la hua machiriata bétana ä noknakë béchïbo äbo bíttuatukay. ");
INSERT INTO mfy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huä tua lútüriapo machiria, sïme yoremem machiriame, ím ániau kóm yebisisey. ");
INSERT INTO mfy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ímï ániapo aaney; Dios éntok íkäi ániata áapörik huam ä yáuhuak. Të huame ímï ániapo joome, katim ä tatäyak. ");
INSERT INTO mfy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ä géntemmeu yepsak; ímëi éntok, katim ä mabetak. ");
INSERT INTO mfy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sïme huame ä téhuam súaleme, éntok ä mabetakame, áa bétanam Diosta usiarimtaka taahua. ");
INSERT INTO mfy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ímëri katim yorem áchayhuariapo usiarim bénna, éntokim kaa ímï buíapo yoremem yeu totomtëpo bénna, éntokim kaa yorem éerim ínel éä béchïbo. Ál‑lam tua Diosta bétana yeu yoremtula. ");
INSERT INTO mfy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Entok iri Noki áu yorem yáuhuak, éntok ito násuk jiápsak. Éntok ä loriatate bitchak, Áchayta looria huépülay Usiaritachi. Sïme tua lútüria éntok tühuara át ayka. ");
INSERT INTO mfy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jü Juan áa bétana nookak. Chayeka ínel jiaahua: —Ïri ájäria hua ínel áa bétana ín jíähui: Huä chúkula ino sáu yebijnakeme, chë nésahue ino béppa, bueïtuk áapo béja ínopat jiápsay. ");
INSERT INTO mfy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Éntok jü yún ä jípurëu bétana, nat béppate ä mabeta. ");
INSERT INTO mfy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bueïtuk Moiséjta huámte juka leyta mákhuak, të jü tua tühua éntok jü lútüria Jesucristota huämi, itou yepsak. ");
INSERT INTO mfy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jauhuey júne kaabe Diosta bil-la; ál‑la hua huépul Usiari jíbba, tüisi nákhuame, áapo itom ä täyatuala. ");
INSERT INTO mfy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ïri ájäria jü Juanta nokakähui, júnak jume judíom buere joära Jerusalén bétana jume sacerdotem, éntok leviitam áu bíttuahuako, ä temaij‑ïaahuaka ä jábétukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Áapo éntok huitti nokaka, áu yeu buíssek: —Ínapone kaa ájäria jü Cristo. ");
INSERT INTO mfy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Huanärim ä temajek: —Empo, ¿jábesäe júntuko? ¿Jachë Elías? Huanäi Juan am yómmiak: —Ëe, kanne Elías. Huanärim ä temajek: —¿Huanäisu empo hua profeeta yebijnakeme jäni? Am yómmiaka: —Ëe, ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Huanärim ä temajek: —¿Jábesäe júntuko? Itomë téjhua itom äbo sáhuekame jüneetua béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Huanäi ínel jiaahua: —Ínapone jü júya ánia bueka päriapo yeu kíkteka chayemta jíahui bénasi jiaahua: “Böotem lútulaik étapo Señorta huéenake pámani” —profeeta Isaíasta jíakä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jume áu bíttuahuakame éntok, pariseromtukay. ");
INSERT INTO mfy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Huanärim ä temajek, ínel jíaka: —¿Jatchiakasë júntuk batöa, empo kaa Cristotaka, éntok kaa Elíastaka, éntok kaa profeetataka? ");
INSERT INTO mfy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan éntok ínel am yómmiak: —Ínapo bäammea batöa; të enchim násuk aane, senu kaa enchim täyähui. ");
INSERT INTO mfy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ïri ínel jü chúkula ino sáu yebijnakeme. Áapo ino béppa nésahue; katchanne júne áu kóm chätuka, ä bocha huíkyam búttiapo yúmala. ");
INSERT INTO mfy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ïri áma yeu siika Betábarapo, Jordán bathue mayoa huáitanachi, Juanta batöaïpo. ");
INSERT INTO mfy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yokoríapo jü Juan juka Jesústa áu bíchaa huémta bitchak. Huanäi ínel jiaahuak: —Ïri, ájäria jü Diosta ili Kabara, jü én ím ániapo huaka kaa tühua yáarita yore úhuaame. ");
INSERT INTO mfy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ïri ájäria hua ín áa bétana ínel jíakaïhui: “Chúkula senu yoreme yebijnake, ino béppa chë úttiata jípureme; bueïtuk áapo ínopat béja jiápsay.” ");
INSERT INTO mfy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ínapone kaa ä täyay; tëne huäri béchïbo yepsak, bäammea yore batöaka Israelitammeu yeu ä machinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ínel két jiaahuak, jü Juan: —Ínapone ä bitchak, juka Espíritu Santota guókouta bénak téhueka bétana át kóm sika áa béppa tahuakamta. ");
INSERT INTO mfy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ínapo kaa ä täyay; të hua nee äbo bíttuakame bäammea ín batönakë béchïbo, huäri ínel inou jiaahuak: “Huä jábetachë Espírituta át kóm huémta bíchakätek, éntok át ä tahuako, ïri ájäria jü Espíritu Santoy yore batöame.” ");
INSERT INTO mfy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ínapone ä bitchak, éntokne áa bétana nooka, tua Diosta ä Üusitukä bétana. ");
INSERT INTO mfy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yokoríapo jü Juan júchi áma aaney, éntok guoy ä disciipulohuam. ");
INSERT INTO mfy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Huanäi Juan, Jesústa huämi ják hueramay ä bíchaka, ínel jiaahua: —¡Juyú! ¡Ïri ájäria jü Diosta ili Kabara! ");
INSERT INTO mfy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jume guoyika Juanta majtiähui, Jesústam jíkkajaka, áa sáu sájjak. ");
INSERT INTO mfy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Huanäi Jesús amáu remteka áa sáu kateme bíchaka, ínel jiaahuak: —¿Jítasem jaria? Bempo éntok ínel áu jiaahua: —Maestro, ¿jáksë jóuhuak? ");
INSERT INTO mfy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Huanäi ínel ámeu jiaahua: —Bínem kateka ä bitcha. Huanärim áamak sájaka ä bitchak, ják ä jóakaïpo. Huanärim áamak áma taahuak, huäri taahuarichi; bueïtuk kúpteka náikim ják jiaahuay. ");
INSERT INTO mfy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jü Andrés, Símon Perota saila, ïri jume guoyim násuk juka Juanta nok jíkkajaka Jesústa sáu sikame. ");
INSERT INTO mfy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ïri béja juka Símonta ä sailahua bát téuhuak. Huanäi ínel áu jiaahuak: —Juka Mesíastate téuhuak —Cristo ti téhuaakamta. ");
INSERT INTO mfy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Huanäi Andrés Símonta Jesústau tójjak. Jesús éntok ä bíchaka ínel áu jiaahua: —Empo jü Simmom, Jonásta üusi; émpë Cefas ti téhuaanake. (Ímëi téhuam éntok Peero tim jiau báare.) ");
INSERT INTO mfy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yokoríapo Jesús Galiléa buiarähui bíchaa sim báreka, Felipeta téaka ínel áu jiaahua: —Ino sáukë huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ïri Feliipe Betsaida pueblopo jometukay. Ímï két jometukay jü Andrés éntok Peero. ");
INSERT INTO mfy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Feliipe juka Natanaelta téaka ínel áu jiaahuak: —Béjate ä téula huaka Moiséjta áa bétana huam leypo jïojtekähui, éntok két huam profeetam jïojtekäpo, huaka Jesústa, Joséta üusi, Nazaretpo jometa. ");
INSERT INTO mfy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael éntok ínel áu jiaahua: —¿Jachu Nazaret joärapo jita tühua yeu huée mátchi? Huanäi ínel áu jiaahua jü Feliipe: —Äbe sika ä bitcha. ");
INSERT INTO mfy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús éntok Natanaelta áu jëla huémta bíchaka, ínel áa bétana jiaahuak: —Ímï aane, jü tua israelita; ï óutachi jü ára nókïchiria kaita át ayka. ");
INSERT INTO mfy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael éntok ínel áu jiaahua: —¿Jáchisë nee tatäyak? Huanäi jü Jesús ínel ä yómmiak: —Felipeta kee enchi núnuyo, chunam bétuk enchi kátekne enchi bitchak. ");
INSERT INTO mfy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Huanäi Natanael ínel ä yómmiak: —Maestro, ¡émpë jü tua Diosta Üusi! ¡Émpë jü israelitammeu Rey! ");
INSERT INTO mfy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús éntok ínel ä yómmiak: —¿Jachë kíal chunam bétuk enchi kátekne enchi bitchak ti nee emou jíakä béchïbo nee súale? Én éntoke huatek chë íäri béppa machik junne bínnake. ");
INSERT INTO mfy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús két ínel au jiaahuak: —Lútüriapone enchimmeu ínel jiaahua: Én naateka téhuekatem áu étapomta bínnake, Diosta ángelesim Yoremta Üusi béppa kóm kateme, éntok áa béppa jikau kateme. ");
INSERT INTO mfy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Báij taahuarim huéy, pueblo Caná Galiléa buiärapo boodatukay. Jü Jesústa áiye két áma aaney. ");
INSERT INTO mfy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús éntok ä discíipulom, kéchim áman núnuritukay, jum boodahui. ");
INSERT INTO mfy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Juka vinota lütek, Jesústa áiye ínel áu jiaahuak: —Kaitam vinota jípure. ");
INSERT INTO mfy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús ínel ä yómmiak: —¿Jítasë ínomak jípure jámmut? Ketune kee jee yuuma, jü ín hora. ");
INSERT INTO mfy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ä áyehua éntok ínel ámeu jiaahua, huame áma sáyhuammehui: —Sïmetem áapörik enchim yáa sáhuëu yáuhua. ");
INSERT INTO mfy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Huämi éntok búsan téta sótörim bäam béchïbo áma mánekay, bem ä boojoriapo bénasi, bäam áma jípureka, jume judíom bem sáyhuakä pámani emo bábaksiahuäpo. Huämi huépul sótöpo ochenta o cien litrom bäam áma bekiakay. ");
INSERT INTO mfy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús ínel ámeu jiaahua: —Ímëi sótörimem bäammea tápunia. Huanärim jikau tájti am tápuniak. ");
INSERT INTO mfy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Huanäi ínel ámeu jiaahua: —Ilikkikem nüka, jü áma nésahuemtau am huéria. Huanärim áu am tójjak. ");
INSERT INTO mfy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Huä áma nésahueme éntok, jume bäam vinosi ayulame jihueka ä tútürek, kaa jünéaka jákun ä nütukaïhui. Të jume áma sáyhuame ál‑la jüneiyay, jume bäam jákun bem nükaihui. Huanäi juka jubemta núnuteboka, ");
INSERT INTO mfy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ínel áu jiaahua: —Sïme yoremem juka vino türik bácham jíjïtua; chúkula béja yünam jïlatuk, huaka kaa tua türik am jíjïtua. Të empo huaka vino chë türik ërialatukay, én tájti. ");
INSERT INTO mfy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús ímëi señaalim bát huéeme yáuhuak, jum Caná Galiléapo, éntok yeu ä machiriak juka chë yörisi machik át ayukähui. Huanäi huame ä discíipulom ä súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chúkulam Capernaum pueblou kóm sájjak, Jesús éntok ä áyehua, ä sailahuam, éntok ä disciipulohuam. Huämïrim kaa jaiki táapo áma aanek. ");
INSERT INTO mfy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jü taahuari abe yuumay, pájcua téamta béchïbo, judíom boojoriähui. Huanäi Jesús buere joära Jerusaléniu jikau siika. ");
INSERT INTO mfy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Huanäi jum buere tiöpou kibakeka, jume buéyesim áma nénenkame téuhuak, éntok kabaram, éntok guókohuim, éntok jume tómita nanakuliaka áma jokame. ");
INSERT INTO mfy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Huanäi huiteri jíbebiata yáaka, tiöpopo sïmem yeu béebak, bem kabarammaki, éntok bem buéyesimmaki. Jume tómita áma nakuliame chíbela am guötiriak; mesam éntok chíbela tátabek. ");
INSERT INTO mfy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Huanäi jume guókohuim nénkammeu ínel jiaahua: —¡Íkärem mékka huéria, éntokem ín Áchay kári kaa mercado káapo jípure! ");
INSERT INTO mfy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Huanäi ä discíipulom jïojtetau huáhuaatek, ínel ä jiäpo: “Em káari ín yörë béchïbo ín jiápsipo nee sasäbuania.” ");
INSERT INTO mfy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Huanäi jume judíom ä yómmiak ínel áu jiaka: —¿Jíta señaltasë itom bíttua, íkäi em joä béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús éntok ínel am yómmiak: —Íkäi tiöpotem mójaktia; huanäine báij taahuata huéy júchi ä tóboktianake. ");
INSERT INTO mfy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Huanäi jume judíom yauchim ínel áu jiaahua: —Cuarenta áma búsan huásuktiriapo yáari ïri tiöpo; ¿empo éntok báij táapo emo ä tóboktianake tíiya? ");
INSERT INTO mfy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Të áapo ä takaahua tiöpo bétana nokaka ínel jiaahuay. ");
INSERT INTO mfy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Huäri béchïbo jume kókkolam násuk ä jíabitek, jume ä discíipulom áu huáhuaatek, íkära nokakaïhui. Huanärim juka jïojteta súaleka taahuak, éntok Jesústa nokakaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús Jerusalémpo aneka, judíom kabara jísobahuakä papajköpo. Huanärim juebénaka ä téhuam súsualeka taahuak, huame señaalim ä joay ä bíchaka. ");
INSERT INTO mfy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Të Jesús kaa tua am súaleka taahuak, bueïtuk sïmem jiápsipo jüneriay, ");
INSERT INTO mfy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","éntok kaabeta ä téjhuaanakeu boobíchaïhuiy, jume yoremem bétana; bueïtuk áapo jüneiyay yoremta jiápsipo jita ayukähui. ");
INSERT INTO mfy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Senu yoreme pariserom násuk aaney, Nicodemo ti téhuaaka. Ïri chë yörihuay, jume judíom násuku. ");
INSERT INTO mfy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ïri tukaapo Jesústau yepsak. Huanäi ínel áu jiaahua: —Maestro, jüneate Diosta bétana em äbo yebij‑latukähui; bueïtuk kaabe ímëi señaalim em joäu ára johua, kaa Diosta áamaktuko. ");
INSERT INTO mfy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús éntok ä yómmiaka ínel áu jiaahua: —Tua lútüriapone ínel emou jiaahua, huä kaa bemélasi yeu yoremtukame, téhuekapo rey nésaurita kaa bínnake. ");
INSERT INTO mfy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo éntok ínel áu jiaahua: —¿Jáchisen jü yoreme yötaka júchi ára yeu tómte? ¿Jachu júchi ä áye tómpo ára kibake jäni? ¿Júchi yeu ä yoremtunakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús ínel ä yómmiak: —Tua lútüriapone ínel emou jiaahua, kía jábe junne bäapo éntok Espíritu Santota bétana kaa yeu yóremtukätek, téhuekapo rey nésauripo kaibu áman kibaknake. ");
INSERT INTO mfy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yoremta bétana yeu yoremtulame yoreme; të Espíritu Santota bétana yeu yoremtukame éntok espíritu. ");
INSERT INTO mfy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Katë át emo guómtia ínel nee emou jíakä béchïbo: “Úttea júchi bemélasi enchi yeu yóremtunakëhui.” ");
INSERT INTO mfy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jü jeka ä huée bárëu bíchaa huéiye. Ä jíahuitë jíkkaja. Të jákübo ä huëu, éntok jákun bíchaa ä huëu kaibute jüneenake. Ilë bénamme, sïme huame Diosta bétana Espíritupo yeu yoremtulame. ");
INSERT INTO mfy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo éntok ínel ä yómmiak: —¿Jáchisu ïri ára yáatu? ");
INSERT INTO mfy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús éntok ínel áu jiaahua: —¿Jachë empo, israelitam mamajtiaka, íkäi kaa täya? ");
INSERT INTO mfy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tua lútüriapone ínel emou jiaahua: Juka itom täyäute ettejhua, éntok huaka itom bíchakäu bétanate enchimmeu nooka; të íkäi itom enchimmeu nokäu, katem ä súale. ");
INSERT INTO mfy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eme juka ímï buíapo ayukamta bétana nee enchimmeu nokayo, katem nee súale. ¿Jáchisu júntukem ä súalnake jäni, huaka téhueka bétana huémta nee enchimmeu nokayo? ");
INSERT INTO mfy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Kaabe téhuekau jikau simla, hua téhueka bétana äbo kóm yebij‑lame jíbba, hua Yoremta Üusi äbo bittuari, áman téhuekapo kátekame. ");
INSERT INTO mfy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jáchin juka Moiséjta mékka ánia see päriapo sisïguok bakotta ä tóboktiakä bénasi, junëli úttea, juka Yoremta Üusi tóboktiatunähui, ");
INSERT INTO mfy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bueïtuk sïmetaka ä súalekame, katim emo tärunake; ál‑lam yü jíapsihuamta jípunake. ");
INSERT INTO mfy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios, jume ímï ániapo jiápsame úttesi am nákeka, huépülak jíba Üuseka sïme genteta mámpo ä tójjak, bueïtuk jábetaka junne ä súsualekame kaa muknake, ál‑la jíbapo béchïbo jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ä Üusihua ániau kóm bíttuak, huame ániat jiápsammet kaa béttesi nokta ámet ä chúpanakë béchïbo, jume bem Dios berjim am jiokörinakë béchïbo áapörik huämi. ");
INSERT INTO mfy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Huä áapörik súaleme kaa noki béttesi át chúpila; të hua kaa ä súaleme, béja noki béttesi át chúpila, bueïtuk Diosta huépul Üusi téhuam kaa ä súalekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Íäri béchïbo jü noki béttesi yorememmet chúpari, bueïtuk jü machiria ím ániau kóm yepsak; të huame yoremem huaka kaa máchiraata chë türeka taahuak, bueïtuk huaka bem joäu kaa türi béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bueïtuk sïme huame kaa tühuata joame juka machiriatam kaa türe, éntokim machiriau kaa ruk‑rukte, juka bem joäbet kaabeta béttesi ámet ä nok ïaaka. ");
INSERT INTO mfy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Të hua lútüriata joame machiriatau rúkte, bueïtuk huaka ä joäu ä jüneriatunakë béchïbo, Diosta bétana ä huëhui. ");
INSERT INTO mfy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Íkäi noksuka, Jesús jume ä discíipulommak Judea buiärau yepsak. Huanäi ámemak aneka batöay. ");
INSERT INTO mfy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan két jum Enón ti téhuaakapo batöay, Salim ti téhuaakä náapo, bueïtuk huämi bäam büruakay. Huanäi jü génte áu yájaka batöhuay. ");
INSERT INTO mfy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bueïtuk jü Juan ketune kee pereesotehuay. ");
INSERT INTO mfy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Huanärim náu nok nássuak, Juanta discíipulom éntok jume judíom, emo bábaksiahua bojóriahua bétana. ");
INSERT INTO mfy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Huanärim Juantau yájaka ínel áu jiaahua: —Maestro, hua Jordán bathue huáytana émomak aneïhui, hua áa bétana em itou nokakähui, batöa éntok sïme áu yájja. ");
INSERT INTO mfy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Huanäi Juan ínel am yómmiak: —Jü yoreme kaita ára mabeta, kaa Diosta bétana ä máktuko. ");
INSERT INTO mfy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Emem nee jíkkajak ínel nee jíako: Ínapone kaa ájäria jü Cristo yebijnakeme, ál‑lane áapat hue ïaahuaka äbo bíttuari. ");
INSERT INTO mfy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huä jubekame ä jubi jíba jípunake, të hua jubekamta amigo ä chákäku huéeka ä nok jíkkajame tüisi al‑leaka tahuanake, ä noki jíkkajako; ánëli két jü ín al‑leäu béja chúpila. ");
INSERT INTO mfy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Áapo jikau bíchaa huéenake, ä yörihuäpo; ínapo éntokne kóm bíchaa huéenake. ");
INSERT INTO mfy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Huä jikat bétana äbo yebij‑lame sïmem béppa nésahue. Huä buíapo joome éntok buíyya, éntok jíba ím buíapo ayukamta bétana nooka. Huä téeka bétana huéeme sïmem béppa nésahue. ");
INSERT INTO mfy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Huaka ä bíchakäu éntok ä jíkkajakäu bétana nooka, të kaabe ä nokakäu súale. ");
INSERT INTO mfy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Huä ä nokihua súaleme, ïri juka Diosta noki lútüria tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bueïtuk hua Diosta äbo bíttuakäu Diosta noki nooka; Dios éntok juka Espírituta kaabeta ámpolsi ä mákka. ");
INSERT INTO mfy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jü ín Átchay juka ä Üusi nákke, éntok sïme ayukamta ä mámpo tóij‑la. ");
INSERT INTO mfy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jü ä Üusi súaleme jíbapo béchïbo jíapsihuamta jípure; të jü Diosta Üusi kaa súal báareme kaibu huaka jíapsihuamta jájamnake, ál‑la hua Diosta ómtira jíba áa béppatunake. ");
INSERT INTO mfy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jü Señor jünëiak jume pariserom ínel jíayhuamta jíkkajakaïhui: Jesús chë yún am majtia éntok am batöa, Juanta béppa. ");
INSERT INTO mfy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Të huitti nokhuäpo, Jesús kaa am batöay jiöbe, ä discíipulom ál‑la.) ");
INSERT INTO mfy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Huanäi Judea buiärapo yeu siika, naa búrujti Galiléa buiärau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Éntok Samaria buiära páman ä huéenakeu útteatukay. ");
INSERT INTO mfy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Huanäi senu pueblo Samaria buiärapo kátekame Sicar ti téhuaakäu yepsak. Ïri pueblo kaa mékka taahuay, Joséta herencia Jacobta ä mik‑latukaï náapo. ");
INSERT INTO mfy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Huämïrim mánekay Jacobta poozom. Huanäi Jesús, boojo lottilataka, jum pozom náapo yejtek. Abe lúl‑la yejtey jëla. ");
INSERT INTO mfy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Senu jámut Samariapo jometaka áma yepsak, bächiseka. Huanäi Jesús ínel áu jiaahua: —Bäamë nee miika. ");
INSERT INTO mfy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ä disciipulohuam éntok pueblou bíchaa sákalatukay, buähuamta jínnuboka. ");
INSERT INTO mfy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jü jámut samaritana éntok ínel áu jiaahua: —¿Jáchisen empo judíotaka bäam inou nétane, nee jámut samaritanotuk junne? (Bueïtuk jume judíom éntok jume samaritanom katim emo huáatia.) ");
INSERT INTO mfy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús éntok ínel ä yómmiak: —Empo jüneäteko Diosta jita yore mák bárëu éntok jábeta bäam emou nétanëhui, émpë inou am au éiyey. Huanäine bäa jiápsame enchi mik éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jü jámut éntok ínel áu jiaahua: —Señor, jume pozom mékka kömi, éntoke kaitay yeu am huík mátchi. ¿Jáksë júntuk am jípure, jume bäam yore jíapsituame? ");
INSERT INTO mfy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Jachë empo chë yöturi jäni, itom áchay bát kat‑riam Jacobta béppa? Ímëi pozom itom miikak, áapörik áma bäa jëkähui, ä üusihuam éntok ä huakasihuam. ");
INSERT INTO mfy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús éntok ínel ä yómmiak: —Kía jábe júne ímëi bäam jëkame, júchi bénasi bäi muknake; ");
INSERT INTO mfy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","të hua bäam ín ä miknakeu jëkame, kaibu júchi bäi muknake, ál‑la huame bäam ín ä miknakeu, ä jiápsipom tápunika búitinake, ä yü jíapsinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Huanäi jü jámut ínel áu jiaahua: —Señor, júmëi bäamë nee miika, kaa bäi muk béchïbo éntok kaa äbo sika yeu am huík béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Huanäi Jesús ínel ä yómmiak: —Ámanë em kuna núnuka, äbo huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jü jámut éntok ínel ä yómmiak: —Kanne kuunak. Jesús éntok ínel áu jiaahua: —Lútüriatë nooka, kanne kuunak ti jíaka; ");
INSERT INTO mfy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","bueïtukë mamnim béja kunala; juka én em jípurëu éntoke kaa kuunak. Lútüriatë nooka, ínëli jíaka. ");
INSERT INTO mfy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Huanäi jü jámut ínel áu jiaahua: —Señor, jíbatua empo Diosta profeeta. ");
INSERT INTO mfy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Itom áchayim bát kat‑riame ímï káupom Diosta yörek; eme éntok ä yöri béchïbo, Jerusalémpo ä ájariä tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús éntok ínel áu jiaahua: —Jámmut, nechë súale, taahuari yúmanake, juka Dios Áchayta enchim yörinakëhui, kaa ímï káupo, éntok kaa buere joära Jerusalémpo jíbba. ");
INSERT INTO mfy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eme huaka kaa enchim täyähuem yöre; ítapo éntokte huaka itom täyäu yöre, bueïtuk jü jínëuria judíom bétana huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Të taahuari yúmanake, éntok én ájäria: jume lútula huëpo Dios Áchayta yöreme, espíritupom lútüriapo ä yörinake; bueïtuk jü Dios Átchay junëli áu yöri ïaa. ");
INSERT INTO mfy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Áapo Espíritu. Jume ä yöreme, espíritupom lútüriapo ä yörinake. ");
INSERT INTO mfy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Huanäi jü jámmut ínel áu jiaahua: —Jüneane juka Mesíasta yebijnakëhui, Cristo ti téhuaakamta. Áapo yepsak, sïmeta itom téjhuaanake. ");
INSERT INTO mfy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús éntok ínel áu jiaahua: —Jü Mesías ti téhuaakame, ínapone ájäria, jü émomak nokame. ");
INSERT INTO mfy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Júnëlam nokaysu, jume ä discíipulom áma yájjak. Huanärim át guómtek, jámuttamak ä ettejoä tíaka. Të kaabe ä temajek: “¿Jítasë áu nátemaje?” o, “¿Jítasë áamak ettejhua?” ");
INSERT INTO mfy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Huanäi jü jámmut, ä bächia áma tö sika, pueblou bíchaa siika. Huanäi áman yepsaka, jume yorememmeu ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Äbem kateka ä bitcha, juka senu yoremta. ¡Bueïtuk sïmeta ín josukäu huitti nee ettejhuariak! ¿Jachu jü Cristo yebijnakeme jäni? ");
INSERT INTO mfy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Huanärim jum pueblopo yeu sájaka áu yájjak. ");
INSERT INTO mfy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jume ä discíipulom éntok chë júne áu nookay, ínel jíaka: —Maestro, jïbuäe. ");
INSERT INTO mfy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Áapo éntok ínel ámeu jiaahua: —Ínapo senu buähuamta ín buänakeu jípure, enchim kaa täyähui. ");
INSERT INTO mfy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jume ä discíipulom éntok ínel náu jiaahuay: —¿Jachu jábe áu jïbuä tójak jäni? ");
INSERT INTO mfy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús éntok ínel ámeu jiaahuak: —Ïri ájäria jü ín buähuame: jü nee äbo bíttuakamta nésahui ín yáanakëhui, éntok ä tékil ín chúpanakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Inëlem jijia emëe: “Ketune naiki mecham bëye, juka huajpo etta chúpnakëhui.” Të ínapo ínel enchimmeu jiaahua, jikau remtekem huasam bitcha, bueïtuk jü echi béja saa bíakteka jójoni. ");
INSERT INTO mfy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jü jíchupata tóboktéame béjtuana, éntok jíbapo béchïbo jíapsihuamta ä jípunakë béchïbo náu ä tóijnake, hua echákamtamak nánancha bem al‑leenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bueïtuk ímï lútüria hua noki ínel jíame: “Jü echame seenu, jü ä tóboktéame éntok, täbui.” ");
INSERT INTO mfy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bueïtuk ínapo naa bëkatana enchim bíttuala, huaka kaa enchim echakäu enchim tóboktianakë béchïbo. Huate bát echaka áma tekipanuak, eme éntok bem tekipanuakäpo tühuata mabeta. ");
INSERT INTO mfy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huämi pueblopo juebena samaritanom Jesústa súaleka taahuak, jámutta ínel jíakä béchïbo: “Sïmeta ín yáari nee téjhuak.” ");
INSERT INTO mfy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Huanäi jume samaritanom áma yájaka jiokot áu jiaahua, áma ámemak ä tahua sáhueka. Huanäi guoy táapo áma taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Huanärim júchi chë júne juebénaka ä súsualek, áapörik ámeu nokakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Huanärim jámuttau ínel jiaahua: —Béjate kaa kía ínel em jíä béchïbo ä súale, bueïtukte ítapo itom nákammea ä jíkkaja, éntokte jüneiya tua lútüriapo íkäi ájäriatukähui, jü yore jínëunakeme, jü Cristo. ");
INSERT INTO mfy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chúkula guoy taahuarim simsuko, huämi yeu siika, Galiléa buiärau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bueïtuk Jesús áapo ínel jiaahua, juka profeetata tua ä buiärapo, kaa ä yörihuä tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jume áma jomeme ä mabetak, Galiléau ä yepsako, sïmetaka Jerusalémpo ä yáakäu bíchaka jum pájcua taahuaripo, bueïtuk bempo két áman nóitilatukay, jum pajkohui. ");
INSERT INTO mfy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús júchi Caná Galiléa buiärau yepsak, huam bäam ä vino yáakäpo. Senu yoreme yäurapo reytau kóba yöhue, ä üusihua tüisi kökoremta jípurey, jum pueblo Capernaumpo. ");
INSERT INTO mfy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ïri juka Jesústa jum Judea bétana Galiléau ä yepsak ä jíkkajaka, ä üusi mukiapo anemta ä jítto ïaaka áman siika, jiokot áu jíaka. ");
INSERT INTO mfy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Huanäi Jesús ínel áu jiaahua: —Katem jume señaalim éntok kaa jaibu johuamta bichätek, kaibem nee súal éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Huanäi jü reytau kóba yöhue ínel áu jiaahua: —Señor, ámanë kóm huéiye, kee ín üusi mukeyo. ");
INSERT INTO mfy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús éntok ínel áu jiaahua: —Bamsekë huéiye, jü em üusi béja türiak. Huanäi jü yoreme Jesústa nokakäu súsualeka siika. ");
INSERT INTO mfy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jume ä sáhuëhuim áman kömä huéy, yehuim sájaka ä nánkek. Huanärim ä téjhuak, ínel áu jíaka: —¡Béja türiak, jü em üusi! ");
INSERT INTO mfy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Huanäi am temajek, ják horapo ä türi táytekähui. —Tuuka, senu horam jíay jü táij huéchiria ä tójjak —tim áu jiaahuak. ");
INSERT INTO mfy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Huanäi jü ä áchayhua jünëiak huämi horapo juka Jesústa ínel áu jíakähui: “Em üusi béja türiak.” Huanäi ä súsualeka taahuak, áapo, éntok sïme ä jóapo joomem. ");
INSERT INTO mfy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesús íkäi señalta yáuhuak, guosa huëpo Judea bétana Galiléau yepsaka. ");
INSERT INTO mfy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chúkula íkäi jita simsuko jume judíom bem papajkou áma johuay. Huanäi Jesús jum buere joära Jerusaléniu jikau siika. ");
INSERT INTO mfy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Huämi Jerusalémpo, jum kabaram puerta ti téttehuakäu kaa mekka, ili baubäa áma mánnek, hebreo nokpo Betesda ti téhuaaka. Huäri éntok mamni portaalim jípurey. ");
INSERT INTO mfy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ímï juebena kökoreme tökay, liliptim, lolöim, káraktilam, jume bäam náu kuutemta boobíchaka. ");
INSERT INTO mfy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bueïtuk senu Diosta ángel jamak huéytuk jum baubäau kóm sisimey; huanäituk jume bäam náu kuukuutiay. Ínëli jume bäam náu kuutiahuak, jü bát áman kóm sikame türikatuk tatahuay, kía jita kökoata ä jípurë bétana junne. ");
INSERT INTO mfy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Huämi éntok senu yoreme aaney, béja treinta áma guoj naiki huásukteka kökoreka. ");
INSERT INTO mfy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Huanäi Jesús bökamta bíchaka, éntok jünéaka junëli béja juebena tiempota ä huériähui, ínel áu jiaahua: —¿Jachë türi péiya? ");
INSERT INTO mfy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Señor —ti ä yómmiak jü kökoreme—, kaabe jum bäau nee kóm huéria mátchi, náu am kuutiahuako. Bueïtuk nee áman huéyo, täbuika jáibusu ínopat áman kóm sisime. ");
INSERT INTO mfy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús éntok ínel áu jiaahua: —Yejtekë, em át bökäu nüka huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Huanäi laütiposu jü yoreme türika taahuak, éntok áachä bökäu nüka naa huée táytek. Huäri taahuarit éntok jimyore taahuaritukay. ");
INSERT INTO mfy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Huanäi jume judíom ínel áu jiaahua hua kökoreka türilatukähui: —Jimyore taahuari ëni; katë ä püanampo yúmala, juka em át boböyëhui. ");
INSERT INTO mfy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Áapo éntok ínel am yómmiak: —Huä nee tütekame, áapo ínel inou jiaahuak: “Em át böyëhuë nüka huéiye.” ");
INSERT INTO mfy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Huanärim ä temajek: —¿Jábesa jüri: “Em át böyëhuë nüka huéiye”, ti emou jíakame? ");
INSERT INTO mfy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jü türialame éntok kaa jüneiyay ä jábétukaïhui, bueïtuk Jesús jume géntem áma aneme tö sika sékäna bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chúkula Jesús jum buere tiöpopo ä téaka, ínel áu jiaahua: —Béjë türila; Dios bejritë kaa éntok johua, kaa chë béttesi machik jita emou nóttinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Huanäi hua yoreme sika jume judío yauchim téjhuak, ä tütekamta Jesús tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Íäri béchïbo jume judío yäuchim juka Jesústam guójjajasey ä mëbáreka, bueïtuk íkäi ä joä béchïbo, jimyore táapo. ");
INSERT INTO mfy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús éntok ínel am yómmiak: —In Átchay én tájti tekipanua, éntok ínapo két tekipanua. ");
INSERT INTO mfy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Íäri béchïbo jume judío yäuchim chë júne át koptey ä mëbáreka, bueïtuk juka jimyore taahuata béj‑reka jíba ä huë tíaka, të két juka Diosta tua áu ä Áchayek tíä béchïbo, éntok Diosta bénasi áu ä joä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Huanäi Jesús ínel am yómmiak: —Tua lútüriapone enchimmeu ínel jiaahua: Jü Usiari kara ä éä páman jita yáuhua, ál‑la huaka Áchayta joäu bíchau jíbba. Éntok sïmeta juka Áchayta joähui, jü ä Üusihua két alë bénasi ä johua. ");
INSERT INTO mfy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bueïtuk jü Áchayhuari ä Üusi nákke, éntok sïmeta ä yáa bárëu áu yeu ä machiria. Éntok chë buéresi machik áu yeu machirianake, enchim át guómtisi maachik. ");
INSERT INTO mfy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bueïtuk hua Áchayhuarita kókkolam ä tobotoboktiä bénasi, éntok jíapsihuamta am mámakä bénasi, junëli kétchi jü usiari huame ä mák bárëhuim jíapsihuamta am mámaka. ");
INSERT INTO mfy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bueïtuk jü Áchayhuari áapo kaabetat nokta chúppa, ál‑la ä Üusihua sïmeta jábetat nokta ä chúpanakë béchïbo, yäurata ä mák‑la, ");
INSERT INTO mfy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sïmem Diosta Üusi bem yörinakë béchïbo, Áchayhuarita bem yörë bénasi. Huä Üusi kaa yöreme két huaka Áchayhuarita kaa yöre, äbo ä bíttuakamta. ");
INSERT INTO mfy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Tua lútüriapone ínel enchimmeu jiaahua: Huä ín noki jíkkajame, éntok nee äbo bíttuakamta súaleme, jíbapo béchïbo jíapsihuamta jípure, éntok kaa noki béttesi át chúpatunake, ál‑la mukilataka jíapsihuamta jájamla. ");
INSERT INTO mfy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tua lútüriapone ínel enchimmeu jiaahua: Taahuari yúmanake, éntok én ájäria: huame kókkolam Diosta Üusi noki jíkkaijnake, huámëri jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bueïtuk jáchín jü Dios Áchayhuaritat ayka jü jíapsihuame, junëli két ä Üusi ä mák‑la, jíapsihuamta át ayunakëhui, ");
INSERT INTO mfy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","éntok két yäura úttiata ä mák‑la, jábetat bette nokta ä chúpanakë béchïbo, bueïtuk áapörik Yoremta Üusiaritukä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Katem íari nokit emo guómtitua; bueïtuk taahuari yúmanake: sïme jume kókkola mäarim ä noki jíahuita jíkkaijnake. ");
INSERT INTO mfy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Huanäi huame türik yáalame yeu sájaka jíbapo béchïbo jíapsinake; huame kaa türik yáalame éntok yeu kannake, të nokta béttesi ámet chúpatunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Kía ín éäpo kaitane ára yáuhua; ín ä sáyhuaka pámanne jíba nokta chuppa. Huä noki ín chupaü yäura éntok lútüria, bueïtukne kaa ín éäu jo báreka éiya, ál‑la hua nee äbo bíttuakamta éähui, jü ín Áchayhuari. ");
INSERT INTO mfy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ínapo ino bétana jíba nokäteko, hua ín nokäu kaa lútüria. ");
INSERT INTO mfy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Täbuika ino bétana nooka, éntokne jüneiya huaka ino bétana ä nokäu lútüriatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Eme huatem Juantau bíttuak, ä nátemaij ïaaka; áapo éntok lútüriata bétana nookak. ");
INSERT INTO mfy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Të kaa inou bëye, juka jábe yoremta ino bétana noknakëhui. Ál‑la íkäine nooka, ínëli enchim jínëutunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan jü lámpara béetemta bénaka, tájeka machiriay. Eme éntok huam ä machiriapo chúbala emo al‑leetuak. ");
INSERT INTO mfy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Të ínapo chë türik nokta jípure, Juanta noki béppa. Bueïtuk huaka tékilta ín Áchay nee mákakähui ín ä yáanakë béchïbo, huäri tékil ín joäu, nee täyatebo, juka Dios Áchayhuarita nee äbo bíttualatuka bétana. ");
INSERT INTO mfy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Két hua Dios Áchayhuari nee äbo bíttuakame ino bétana nooka. Jauhuey júnem kaa ä jíahui jíkkaij‑la, éntokem kaa ä bil-la, ä jáchïnatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ä nokihua éntok kaa enchim jiápsipo jiápsa; bueïtuk áapörik äbo bíttuakäu, katem ä súale. ");
INSERT INTO mfy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Elakem Diosta nooki jïojterita bitcha; bueïtukem júmü emo ä téu máchile, juka jíbapo béchïbo jíapsihuamta. Të ál‑la jü Diosta noki jïojteri ino bétana jíba nooka. ");
INSERT INTO mfy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Të katem inou rúkti báare, jíbapo béchïbo enchim jíapsinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Juka looria yoremta bétana huemta kannä mabeta. ");
INSERT INTO mfy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bueïtuk, ínapo enchim täya entokne jüneiya Diosta kaa enchim nákëhui. ");
INSERT INTO mfy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ínapone ín Átchay bétana äbo yebij‑la, éntokem kaa nee mabeta. Të täbuika kia ä eäpo äbo yepsakäteko, júkäi ál‑lem mabetnake. ");
INSERT INTO mfy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Jáchisu júntuk eme nee súalnake, enchim emo buérialëu nat mamabetaka? Éntok huaka úttilhuamta Diosta bétana jíba huémta, ¡katem ä jaria! ");
INSERT INTO mfy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Katem jü Dios Áchayhuaritau enchim ín nätuanake bénasi éiya. Ál‑la hua Moisés ájäria, jü enchim nätuanakeme, hua enchim áa bétana tühuata boobichähui. ");
INSERT INTO mfy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bueïtuk eme Moiséjta súalëtek, nee súal éiyey, áapörik ino bétana jïojtekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tem áapörik jïojtekäu kaa súalëtek, ¿jáchisu júntukem ín noki súalnake? ");
INSERT INTO mfy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chúkula Jesús Galiléa bahue huáytana bíchaa siika, Tiberiäu bíchaa. ");
INSERT INTO mfy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Huanäi tüisi juebénakam áa sáu kaatey, bueïtuk jume señaalim ä joäu bíchaka, jume kökoremmechi. ");
INSERT INTO mfy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Huanäi Jesús júya káhuit jikau siika, ä discíipulommaki. Huanärim áma jotek. ");
INSERT INTO mfy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Abe áu yuumay, pájcuahui, jume judíom pajkohui. ");
INSERT INTO mfy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huanäi Jesús jikau remteka juebena genteta áa sáu katemta bíchaka, Feliipetau ínel jiaahua: —¿Jákusute páanim jínnunake jäni? ¿Ímëi jïbuätua béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Të ínel jiaahuak, kía ä jiöbila báreka; Jesús béja jüneiyay jita áu yáanakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Feliipe éntok ínel ä yómmiak: —Guoy cien denario tómiy páanim jínnuk, hueuhuëpulammet kía ili rérebeim júne kaibu ámet yúmanake. ");
INSERT INTO mfy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Senu ä disciipulohua, Andrés, Símon Perota saila ínel áu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Senu usi ím aane, mamni cebada páanim jípureka éntok guoy ili kútchum; të ¿jaiki jäku ímëi juebenam béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Huanäi Jesús ínel jiaahua: —Jume géntemem jote sáuhue. Huämi éntok ili júya síari büruakay. Huanärim áma jotek, bueïtuk jamakim mamni mil oohuimtukay. ");
INSERT INTO mfy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Huanäi Jesús jume páanim nüka Diosta baysausuka, huanäi béja am näikimtek jume ä discíipulommechi, huámëi éntok jume jokammechi; ánëli kétchi huame kútchum, bem jóboäpo tájti. ");
INSERT INTO mfy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Béja am jóboasuk, Jesús ä discíipulommeu ínel jiaahua: —Jume rérebeim yeu bëkamem náu tójja, kaita täru béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Huanärim jume rérebeim náu tójaka, dooce canastam ámey tápuniak, huame mamni cebada páanim kaa buäsuhuakame. ");
INSERT INTO mfy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Huanäi jume yoremem, juka señalta Jesústa yáakäu bíchaka, ínel jiaahua: —Tua lútüriapo ïri ájäria hua profeeta ímï ániau yebijnakëihui. ");
INSERT INTO mfy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Të Jesús jünëiak útteapo buíjhuaka reypo áu yecha báahuaïhui; huanäi áapola káhuiu bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tukariu yúmay, jume ä discíipulom bahuehuim kóm sájjak. ");
INSERT INTO mfy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Canoapom jämuka, bahuet naa búrujtim kaatey, Capernaum pueblou bíchaa. Béja kaa machiakay; Jesús éntok jíba kee ámeu yepsay. ");
INSERT INTO mfy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jü bahue éntok áu jikau tóboktiay, jü jeka úttea huémtayi. ");
INSERT INTO mfy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Béjam jamak mamni o búsan kiloometropom kaatey canoata hueriaka, huanärim Jesústa bitchak. Bahue bäata béppa huéesimeka canoau jëla ansimey. Huanärim májhuey. ");
INSERT INTO mfy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Të áapo ínel ámeu jiaahua: —¡Ínapone, katem májhue! ");
INSERT INTO mfy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Huanäi bempo al‑leaka ä mabetak jum canoapo. Huanäi sep lautëlam áman yájjak, jum bem sájakähui. ");
INSERT INTO mfy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yokoríapo jü génte bahue huáytana aneme íkäi jüneriak: huépul canoata jíba áma bókaïhui. Jesús éntok ä discíipulommak kaa áma jämuk, ál‑la ímëi bempola sájjak. ");
INSERT INTO mfy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Të huate canoam áma yájjak, pueblo Tiberia bétana. Huanärim áman yájjak, jum Diosta baysausuka páanim bem buakä náapo. ");
INSERT INTO mfy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Huä génte jünéaka juka Jesústa kaa áma aneïhui éntok jume ä discíipulom junne, canoapom jämuka sájjak, Capernauniu bíchaa, Jesústa járiuboka. ");
INSERT INTO mfy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Huanärim bahue huáytana ä téaka ínel áu jiaahua: —Maestro, ¿jahueysë äbo yepsak? ");
INSERT INTO mfy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús éntok ínel am yómmiak: —Tua lútüriapone enchimmeu ínel jiaahua: Eme nee jaria, kaa jume señaalim enchim bíchakä béchïbo, ál‑la páanimmea enchim jóboakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tekipanoäem, kaa hua buähuame lülütemta béchïbo, ál-la hua buähuame jíbapo béchïbo ayunakeme. Jü Yoremta Üusi enchim ä máknake; bueïtuk íkäi yeu púuhuak, jü Dios Átchay. ");
INSERT INTO mfy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Huanärim ínel áu jiaahua: —¿Jítasute yáanake jäni, juka Diosta tékil yáa béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús éntok ínel am yómmiak: —Ïri jü Diosta tékkil, hua áapörik äbo bíttuakäu enchim súalnakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Huanärim ínel áu jiaahua: —¿Jíta señaltasë itom bíttua, ä bíchaka enchi itom súalnakë béchïbo? ¿Jíta tékiltasë johua? ");
INSERT INTO mfy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Itom áchayim juka manáta buäka mékka ánia see päriapo, Diosta noki jïojteri jíä bénasi: “Páanim téhuekapo joomem am buätuak.” ");
INSERT INTO mfy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús éntok ínel ámeu jiaahua: —Tua lútüriapone ínel enchimmeu jiaahua: jü Moisés kaa enchim am miikak, jume páanim; ál‑la jü ín Átchay tua lútüriapo páanim téhuekapo joomem enchim miika. ");
INSERT INTO mfy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bueïtuk jume páanim Diosta yore mímikäu, júmëi tua ájäria: jü téhueka bétana kóm sikame, éntok ím ániapo joomem jíapsihuamta mikame. ");
INSERT INTO mfy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Huanärim ínel áu jiaahua: —Señor, ímëi páanim jíbe itom mímika. ");
INSERT INTO mfy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús éntok ínel ámeu jiaahua: —Ínapone ájäria jume páanim ámey jíapsihuame. Huä inou rúktekame jauhuey júne kaa tébäurinake, éntok hua nee súaleme kaibu éntok júchi bäi muknake. ");
INSERT INTO mfy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tëne béja enchimmeu ínel jiaula: Nechem bil-lataka júne katem nee súale. ");
INSERT INTO mfy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sïme huame ín Áchay nee mákäu inohuim rúktinake; éntok kaibune yeu am bébnake, huaka inou rúktekamta. ");
INSERT INTO mfy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bueïtukne téhueka bétana äbo kóm yebij‑la, kaa ín éäu jo báreka, ál‑la huaka nee äbo bíttuakamta éäu chúpa báreka. ");
INSERT INTO mfy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ïri éntok jü Dios Áchayta éähui, hua nee äbo bíttuakame: huame sïmem nee ä mákakäu, kaabetane tärunake, ál-la huaka taahuata äbo huémta yúmakne am jíabitetuanake. ");
INSERT INTO mfy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ïri éntok hua nee äbo bíttuakamta éähui sïme huame Diosta Üusi bíchame éntok ä súaleme, jíbapo béchïbo jíapsinake; ínapo éntokne am jíabitetuanake huaka taahuata äbo huémta yúmako. ");
INSERT INTO mfy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Huanäi jume judíom kaa tüisim ä bétana nookay, Jesústa ínel ä jíakä béchïbo: “Ínapone jume páanim téhueka bétana äbo kóm yebij‑lame.” ");
INSERT INTO mfy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Huanärim ínel jiaahuay: —¿Jachu kaa ïri jü Jesús, Joséta üusi, ä áchayhua éntok ä áyehua itom täyähui? ¿Jáchisu júntuk ïri téhueka bétana áu kóm yebij‑la tíiya? ");
INSERT INTO mfy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús éntok ínel am yómmiak: —Katem enchim násuk ino bétana kaa túisi náu nooka. ");
INSERT INTO mfy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kara jábe inou rúkte, kaa juka Dios Áchayta nee äbo bíttuakamta inou ä rúktituayo; ínapo éntokne ä jíabitetuanake, huaka taahuata äbo huémta yúmako. ");
INSERT INTO mfy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jum profeetam librompo ínel jïojteri: “Dios sïmem majtianake.” Júntuksan sïme huame Diosta noki jíkkajame, éntok áa bétana jita täyame, inou rúkte. ");
INSERT INTO mfy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Kaabe Dios Áchayta bil-la jiöbe, ál‑la hua Diosta bétana äbo yepsakame. Ïri ä bil-la, juka Dios Áchayta. ");
INSERT INTO mfy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tua lútüriapone enchimmeu ínel jiaahua: Huä nee súaleme jíbapo béchïbo jíapsihuamta jípure. ");
INSERT INTO mfy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ínapone jume páanim ámey jíapsihuame. ");
INSERT INTO mfy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Enchim áchayim mékka ánia see päriapo manáta buäka junne, tem jíba kókkok. ");
INSERT INTO mfy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ïri ájäria jume páanim téhueka bétana kóm yepsakame, bueïtuk jábe am buäkame kaa muknake. ");
INSERT INTO mfy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ínapone jume pan jiápsame téhueka bétana kóm yebij-lame; jábe júne ímëi páanim buäkame jíbapo béchïbo jíapsinake. Jume páanim ín am máknakëhui, ín takaahua. Íkäine am miknake, jume sïme ániapo jomeme bem jíapsinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Huanäi jume judíom náu nok nássuay, ínel jíaka: —¿Jáchisen ïri ä takaahua itom buätuanake? ");
INSERT INTO mfy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús éntok ínel ámeu jiaahua: —Tua lútüriapone ínel enchimmeu jiaahua: Eme juka Yoremta Üusi takaahua kaa buäkätek éntok kaa juka ä ójbo jëkätek, katem jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Huä ín takaahua buäkame éntok ín ójbo jëkame jíbapo béchïbo jíapsihuamta jípure; ínapo éntok ä jíabitetuanake, jü taahuata äbo huémta yúmako. ");
INSERT INTO mfy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bueïtuk jü ín takaahua tua jü buähuame; jü ín ójbo éntok tua huame bäam jijïhuame. ");
INSERT INTO mfy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Huä ín takaahua buäkame éntok ín ójbo jëkame ínot jiápsa, ínapo éntok áachi. ");
INSERT INTO mfy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Huä Dios Áchay jiápsame nee äbo bíttuak, ínapo éntok Dios Áchayta béchïbo jiápsa; kíalïku juka ín takaahua buäkame két ínoy jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ímëi jume páanim téhueka bétana äbo kóm yepsakame. Kaa huame enchim áchayhuarim buäkäu bénna, bueïtukim jíba kókkok. Të hua ímëi páanim buäkame jíbapo béchïbo jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pueblo Capernaumpo íkäi nookak, am majtiaka jum sinagogapo. ");
INSERT INTO mfy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jume juebena discíipulom ä jíkkajaka ínel jiaahua: —¡Béttesi maachi, ï nooki! ¿Jábesu én ä jíkkaij báanake? ");
INSERT INTO mfy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús éntok ä discíipulom jüneriaka, kaa tüisi náu am nokayo, ínel ámeu jiaahua: —¿Jachu ïri enchim kaa al‑leetua? ");
INSERT INTO mfy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jáchisem éenake jäni, juka Yoremta Üusi bannaataka ä anëu nótteka jikau ä huéy ä bíchäkateko? ");
INSERT INTO mfy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jü Espíritu Santo ínel juka jíapsihuamta yore miika; jü takaahua éntok kaita yánti jíapsihuamta yore mákka. Huä nooki ín enchimmeu nokakäu, jüri Espíritu éntok jíapsihuame. ");
INSERT INTO mfy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Të huate enchim násuk aane, kaa ä súaleme. Bueïtuk Jesús béja jüneiyay kësampo naateka am jábétukähui jume kaa ä súaleme, éntok jábeta ä nénkinakëihui. ");
INSERT INTO mfy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Huanäi ínel jiaahua: —Íäri béchïbone ínel enchimmeu jiaula: Kía jábe júne kara inou rúkte, kaa juka Dios Áchayta ínel éayo. ");
INSERT INTO mfy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Júnakoy naateka juebena ä discíipulom amáu nóttek; béjam kaa áamak rejtey. ");
INSERT INTO mfy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Huanäi jü Jesús jume doocemmeu ínel jiaahuak: —¿Jachem eme két sáka báreka éiya? ");
INSERT INTO mfy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Huanäi jü Símon Peero ínel ä yómmiak: —Señor, ¿jábetausute kannake? Empo jíba ä jípure, juka jíbapo béchïbo jíapsihuamta. ");
INSERT INTO mfy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ítapo éntok ä sual-la, éntokte jüneiya enchi jü Cristotukähui, jü Dios jíbapo béchïbo jiápsamta Üusi. ");
INSERT INTO mfy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús ínel am yómmiak: —¿Jachu kaa ínapo jume doocem yeu púala? ¡Të huépülaka enchim násuk diablo! ");
INSERT INTO mfy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscarioteta bétana nookay, Símonta üusi, jume doocemmak näikiatukaïhui; ïri jü ä nénkakame. ");
INSERT INTO mfy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chúkula íkäi simsuko, Jesús Galiléa buiärapo naa huéiyey; kaa Judea buiärapo naa huée báarey, bueïtuk jume judío yauchim ä mëbáreka éiyay. ");
INSERT INTO mfy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kaa jaikika bëyey jume judíom pajkou yúmanakë béchïbo, pajko tabernáculohui. ");
INSERT INTO mfy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Huanäi jume ä sailahuam ínel áu jiaahua: —Ímïre yeu sika Judeau bíchaa siime, jume em discíipulom áman aneme juka em tékil am bínnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bueïtuk jábe júne áu täyatebo báareme kaa éhuil jita jojoa. Empo íkäi joätek, sïme genteta ániat jomemtau emo yeu buíj éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bueïtuk jume ä sailahuam júne kaa ä súaley. ");
INSERT INTO mfy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Huanäi Jesús ínel ámeu jiaahua: —Jü taahuari ino béchïbo kee jee yuuma, të jü enchim taahuari jauhuey júne jíba türi. ");
INSERT INTO mfy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jü génte kaibu enchim kaa bibitpenake, të nee ál‑lam kaa bibitpeiya, bueïtuk ínapo áme bétana nooka, bem boojoriau kaa türiakähui. ");
INSERT INTO mfy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Emem áman jikau kaate jum pajkohui; ínapone chúkula áman huée báare, bueïtuk ín taahuari kee jee yuuma. ");
INSERT INTO mfy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Íkäi ámeu noksuka, jum Galiléapo taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Të chúkula jume ä sailahuam áman jikau sákasuk, áapo két áman jikau siika jum pajkohui, të éhuili kaa sïmem bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jume judíom éntok jum pajkopo ä jariay, ínel jíaka: —¿Jákusu aane jäni huäri? ");
INSERT INTO mfy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Huanäi buéresi áa bétana náu nokhuame huéiyey juebenara genteta násuku. Bueïtuk huate ínel jiaahuay: “Áapo tü yóreme”; të huate entok ket ínel jiaahuay: “Ëe, kía genteta bäitáttähua.” ");
INSERT INTO mfy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Të kaabe huatem jíkkajäpo áa bétana nookay, judíom májhueka. ");
INSERT INTO mfy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Të huam pajkota násuk huëpo, Jesús buere tiöpou jikau siika huämi am majtia táytek. ");
INSERT INTO mfy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Huanäi jume judíom yauchim át guómteka taahuak, ínel jíaka: —¿Jáchisu ïri am täya jume letram, kaa majtiataka? ");
INSERT INTO mfy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús éntok ínel am yómmiak: —Jü ín am majtiäu kaa ino bétana huéiye, hua nee äbo bíttuakamta bétana ál‑la. ");
INSERT INTO mfy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jü Diosta éä páman huée báareme, jüneenake juka ín am majtiähui Diosta bétana huëhui ö kía ino bétana. ");
INSERT INTO mfy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jü áa bétana nokame ä úttilhuaata jaria; të jü äbo ä bíttuakamta úttilhuamta jariame, ïri tua lútüriata nooka, éntok jü kaa lútula jíapsihuame kayta át ayka. ");
INSERT INTO mfy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Jachu kaa jü Moisés juka leyta enchim mák‑la? Të eme kia jábe júne, huákäi leyta nokä páman kaa ä boojoria. ¿Jatchiakasem nee më báare? ");
INSERT INTO mfy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Huanäi jü génte juebenara ínel ä yómmiak: —Lemooniotë jiápsipo jípure. ¿Jábesu enchi më báare? ");
INSERT INTO mfy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús éntok ínel am yómmiak: —Senu tékiltane yáuhuak jimyore táapo, eme éntok át guómtek. ");
INSERT INTO mfy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Lútüriapo jü Moisés juka circuncisiónta enchim mákkak. Jü circuncición entok (jü ili usi ou bicho bia punta chuktiriahuame), të kaa Moisés ä átteak, ál-la jume itom áchayhuariam bát kat-riam, të eme jum jimyore táapo junne ili usita circuncisiónta joria. ");
INSERT INTO mfy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Të ëni, eme juka circuncisiónta ä jojoria jimyore táapo juka ili usita, Moiséjta ley kaa béj‑re báreka. ¿Jatchiaka júntukem inou omte, jimyore táapo juka yoremta yúmalasi ín tütekä béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Katem kía jábetat bíchaka nooka kaa huiti jünéaka, ál‑lem juka tua lútüriata jíba yáa báreka éiya. ");
INSERT INTO mfy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Huate éntok buere joära Jerusalémpo joome ínel jiaahua: —¿Jachu kaa ïri, hua më báahuaka jariuhuame? ");
INSERT INTO mfy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Áachem suuhua, kaa éhuil nooka, éntok kaabe áu jíale. ¿Jachum lútüriapo ä tatäyak jäni jume nesahueme íkäi Cristotukähui? ");
INSERT INTO mfy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ítapote jüneiya íkäi jákun jometukähui; të juka Cristota yepsak, kaabe jüneenake jákun ä jometukähui. ");
INSERT INTO mfy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Huanäi ikäi jikkajaka, Jesús, jum tiöpopo am majtiaka kusisi ínel jiaahua: —Jamakem nee täya jäni, éntokem jüneiya jákun ín jometukähui; tëne kaa ín éäpo äbo yebij‑la; ál‑la jü tua lútüriata jípureme nee äbo bíttuak, hua kaa enchim täyähui. ");
INSERT INTO mfy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Të ínapo ä täya bueïtukne áapörikut yeu simla, éntok áapo nee äbo bíttuak. ");
INSERT INTO mfy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Huanärim ä pereesote báreka éiyay, të kaabe ä buíssek, bueïtuk kee jee ä taahuari yuumay. ");
INSERT INTO mfy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Huä génte juebenara násuk bürukam ä sússualeka taahuak, éntokim ínel jiaahuay: —Jü Cristo äbo yepsakätek, ¿jachu huate señaalim yáanake jäni íkäi yáakäu béppa? ");
INSERT INTO mfy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jume pariseerom juka genteta jíkkajak Jesústa bétana éhuil am nokayo; Huanäi jume tiöpopo tékiakame éntok jume pariseerom sontarom áman áu bíttuak ä buíj ïaaka. ");
INSERT INTO mfy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Huanäi Jesús ínel jiaahua: —Ketunene ili jaiki táapo enchimmak annake; huanäine hua nee äbo bíttuakamtau júchi huéenake. ");
INSERT INTO mfy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nechem jariunake jiöbe të katem nee téunake. Bueïtuk eme kara áman yáijnake huam ín annakepo. ");
INSERT INTO mfy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Huanäi jume judío yäuchim náu ínel jiaahua: —¿Jákunsu huée báare jäni ïi, jachute kara ä téunake jäni? ¿Jamak jume judíom griegom násuk chíbejtilammeu huéenake? Éntok, ¿jume griegom majtianake jäni? ");
INSERT INTO mfy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jáchisu jiau báare jäni ínel ä jíakähui? “Nechem jariunake, të katem nee téunake, ti jiaahuak; éntok, ¡eme kara áman yáijnake, huam ín annakepo!” ");
INSERT INTO mfy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pajkota chúpëpo ï buere taahuarichi, Jesús kíkteka kusisi nónokak, ínel jíaka: —Kía jábe junne bäi mukeme, inou rúkteka bäa jïnake. ");
INSERT INTO mfy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Huä nee súaleme, Diosta noki jïojteta jíä bénasi, bathue bäa jiápsame bénasi ä jiápsipo búitinake. ");
INSERT INTO mfy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iayïri Jesús ínel jiau báarey juka Espíritu Santota am mabetnake bétana jume ä súaleme; bueïtuk kee jee äbo yepsay jü Espíritu Santo, bueïtuk Jesús kee jee lóoriapo mabethuay. ");
INSERT INTO mfy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Huanäi juebena genteta násuk, huate íkäi jíkkajaka, ínel jiaahuak: —Lútula huëpo ïri ájäria jü profeeta yebijnakeme. ");
INSERT INTO mfy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Huate éntok ínel jiaahuay: —Ïri ínel jü Cristo yebijnakeme. Huate entok két ínel jiaahuay: —¿Jachu jü Cristo Galiléa buiära bétana yebijnake jäni? ");
INSERT INTO mfy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jü Diosta noki ínel jiaahua Davidtamak huéerim, éntok pueblo Belén Davidta jomëpo ä yebijnake tíiya, juka Cristota. ");
INSERT INTO mfy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Huanäi jü génte katim nanabeu ée táytek, Jesústa bétana. Huanärim emo näikimtek. ");
INSERT INTO mfy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huate éntok ä buíjtebo báreka éiyay; të kaabe át mámtek. ");
INSERT INTO mfy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jume sontarom tiöpota suayame jume áma nésahuemmeu nóttek, éntok pariserommehui, huanärim ínel ámeu jiaahua, jume porisimmehui: —¿Jatchiakem kaa ä nüpak? ");
INSERT INTO mfy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jume sontarom entok ínel am yómmiak: —¡Jauhuey júne kaa jábe yoreme ínëli nok‑la íkäi yoremta nokä bénasi! ");
INSERT INTO mfy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Huanäi jume pariseerom ínel am yómmiak: —¿Eme két bäitäihuak? ");
INSERT INTO mfy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Jachu jábe yäurapo nésahueme o jábe pariserom ä súsualek jäni? ");
INSERT INTO mfy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Të ï génte Diosta ley kaa täyame, bétte noki ámet chúpari. ");
INSERT INTO mfy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, hua tukaapo áu nóitekaïhui, ket pariserotukai; éntok ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jü itom ley jia pámani katte yoremta yäura bíchäpo nätuanake kee bát ä nok jíkkajaka éntok kee jünéaka jita ä yáalatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Huanärim ínel ä yómmiak: —¿Jachu empo két Galiléapo joome? Diosta jïojteritë bitcha éntoke át suuhua, jauhuey júne jum Galiléapo profeeta kaa áu tóboktiala. ");
INSERT INTO mfy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Huanaäi hueuhuëpulakam bem jóau bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Huanäi Jesús júya káhui Oliivou bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kethueytana éntok tiöpou yepsak. Huanäi büru génte áu yájjak. Áapo huämi káteka am majtiay. ");
INSERT INTO mfy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Huanäi jume leyta am mamajtíame éntok jume pariseerom jámuttam täbui yoremta éhuil áu kunatualata téaka áu ä nüpak. Huanärim násuk ä kéchaka, ");
INSERT INTO mfy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesústau ínel jiaahua: —Maestro, ï jámut ä kuna kaa ä bíchäpo täbui yoremtamak böka téihuak. ");
INSERT INTO mfy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jü Moiséjta ley éntok ínel jiaahua: Jume jáamuchim junëli emo nüyeme am mamaasuka am súa nésahue. Émposu, ¿jáchise jiaahua? ");
INSERT INTO mfy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bueïtukim ínëli jíaka, ä jioptuaka ä nätua báarey. Të Jesús, buíau kóm chätuka, súttuy buíapo jïojte táytek. ");
INSERT INTO mfy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tem naa múksi kaa nok yáateka, élaka ä temajey. Huanäi kíkteka ínel ámeu jiaahua: —Huä enchim násuk kaa juënak yáalame, huäri tétata bát nüka áu jímma. ");
INSERT INTO mfy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Júchi éntok kóm chätuka jum buíapo jïojte táytek. ");
INSERT INTO mfy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Të bempo, íkäi jíkkajaka, bem jiápsipo nätuahuakame bénasim emo ínnëay, bem Dios bejri bétana. Huanärim hueepulaka yeu kat táytek, ou yoiyöturimpo naateka chë kaa yoiyöhuemmeu tájti. Huanäi Jesús áapola áma taahuak, jü jámut éntok áa náapo. ");
INSERT INTO mfy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Huanäi Jesús kíkteka, kaabeta áma bitchak, huaka jámutta jíbba. Huanäi ínel áu jiaahua: —Empo jámmut, ¿jáksum aane jume enchi nätuame? ¿Jachu kaabe nokta béttesi emót chúppak? ");
INSERT INTO mfy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Huanäi ínel ä yómmiak: —Ëe, kaabe, Señor —ti áu jiaahua. Huanäi Jesús ínel áu jiaahua: —Ínapo júnene kaa bétte nokta emót chúppa. Simëe, të katë júchi Dios bejrita johua. ");
INSERT INTO mfy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús éntok júchi gentetau nookak, ínel ámeu jíaka: —Ínapone jü ániata machiriame; hua ino sáu huéeme kaibu kaa machiku hueramnake, ál‑la huaka machiriata áy jíapsihuamta jípunake. ");
INSERT INTO mfy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Huanäi jume pariseerom ínel áu jiaahua: —Empo emo bétana jíba nooka. Huä em emo bétana nokäu kaa lútüria. ");
INSERT INTO mfy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús éntok ínel am yómmiak: —Eläposu ínapo ino bétana nooka, të ín nokäu lútüria; bueïtukne jüneiya jákübo ín äbo yebij‑latukähui, éntok jákun bíchaa ín huéenakëhui. Të eme katem jüneiya jákübo ín äbo yebij‑latukähui, éntok jákun bíchaa ín huéenakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eme kía yoremem ä türë páman nokta jábemmet chúchupa. Ínapo éntok kaabetat nokta chúchupa. ");
INSERT INTO mfy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Të ínapo jábetat nokta chúpätek, jü ín nokäu lútüria; bueïtukne kaa ínapola jíba jábetat nokta chúppa. Ál‑la hua nee äbo bíttuakame, jü Dios Átchay, jábetat ínomak nokta chúppa. ");
INSERT INTO mfy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enchim leypo ínel jïojteri: Guoy oóhuim nánälaisi nokäu jíba lútüria. ");
INSERT INTO mfy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ínapone jü ino bétana nokame; hua ín Átchay nee äbo bíttuakame két ino bétana nooka. ");
INSERT INTO mfy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bempo éntok ínel áu jiaahua: —¿Jáksu aane, jü em Átchay? Jesús éntok ínel am yómmiak: —Eme katem nee täya, éntok ín Áchayta junne. Nechem täyätek, ín Áchaytem két täya éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús íkäi nokta nookak, tiöpopo am majtiaka jum tómita náu totoijhuäpo. Të kaabe ä buíssek, bueïtuk ä taahuari kee jee yuumay. ");
INSERT INTO mfy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús júchi ínel ámeu jiaahua: —Ínapone siime, éntokem nee jariunake; tem huam enchim kaa tühua yáarimpem kókkonake. Áman ín huëu bíchaa, eme karem áman yájja. ");
INSERT INTO mfy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huanäi jume judío yäuchim ínel jiaahuay: —¿Jamak áapo áu më báare? Huäri béchïbo ínel jiaahua: “Áman ín huëu bíchaa, eme karem áman yájja.” ");
INSERT INTO mfy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Huanäi Jesús ínel ámeu jiaahua: —Eme ím buíapo joome; ínapo éntok jikat téhuekapo joome. Eme ím ániapo joome; ínapo éntok kaa ímï ániapo joome. ");
INSERT INTO mfy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kíalïkune ínel enchimmeu jiaahuak: Enchim kaa tühua yáarimpem kókkonake. Bueïtukem kaa nee súalëtek ín ájäriatukäu, enchim kaa tühua yáarimpem kókkonake. ");
INSERT INTO mfy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Huanärim ínel áu jiaahua: —Émposu, ¿jábesäe? Huanäi Jesús ínel am yómmiak: —Béjane kësampo enchim téjhuaasuk. ");
INSERT INTO mfy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Juebenakne jita enchimmeu nok machik jípure, éntokne enchimmet nokta chúpanake. Të hua nee äbo bíttuakame tua lútüriata jípure. Ínapo éntok huaka ín áa bétana jíkkaij‑läu ím ániapo anemmeu nooka. ");
INSERT INTO mfy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tem kaa jünéaka taahuak, Dios Áchayta bétana ámeu ä nokaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesús éntok ínel ámeu jiaahua: —Júnak jübua huaka Yoremta Üusi jikau tóboktiahuakem jüneenake ín ájäriatukähui, éntok kaa kía ín éäpo ín jita joähui; ál‑lane hua Dios Áchayta nee majtiakäu jíba nooka. ");
INSERT INTO mfy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bueïtuk hua nee äbo bíttuakame ínomak aane; kaa nee ínapola tóij‑la, jü Dios Átchay, bueïtukne áapörik türëu jíba johua. ");
INSERT INTO mfy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Íäri bétana ä nokayo, juebénakam ä súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Huanäi Jesús jume judíom ä súalekammeu ínel jiaahua: —Emëe huam ín noki huë páman jíba anëtek, tua lútüriapem ín discíipulomtunake; ");
INSERT INTO mfy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Éntokem lútüriata täyanake. Huä lútüria éntok súmaripo enchim búttianake. ");
INSERT INTO mfy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bempo éntok ínel ä yómmiak: —Ítapo Abrahamtatte yeu sákala, éntok jauhuey júne kaabeta bétukte ito jípula. ¿Jáchisu júntuk empo ínel jiaahua: “Búttiatunakëem”? ");
INSERT INTO mfy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús éntok ínel am yómmiak: —Tua lútüriapone ínel enchimmeu jiaahua, sïme huame kaa tühuata joame, kaa tühuata bétukim jiápsa. ");
INSERT INTO mfy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huä tekoka sáyhuame kaibu jíba béchïbo jóapo tahuanake; të hua usiari ál‑la jíba béchïbo áma tahuanake. ");
INSERT INTO mfy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Júnëli juka Diosta Üusi jísumapo enchim búttiako, lútüriapem jísumapo búttiataka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jüneane Abrahamtat enchim yeu sákalatukähui; tërem nee mëbáreka éiya, bueïtuk ín noki kaa enchim jiápsipo huétche. ");
INSERT INTO mfy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ínapo huaka Dios Áchaytamak aneka ín bíchakäu enchimmeu nooka; eme éntok huaka enchim áchay bétana huémta enchim jíkkajäu johua. Eme diablota áchayek. ");
INSERT INTO mfy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Huanärim ínel ä yómmiak: —Abrahamtate áchayek. Të Jesús ínel ámeu jiaahua: —Eme Abrahamta üusimtuk, Abrahamta boojoriähuem jo éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tem én nee mëbáreka éiya, lútüriata enchimmeu ín nokakä béchïbo, hua Diosta bétana ín jíkkajakähui. ¡Abraham íkäi kaa yáuhuak! ");
INSERT INTO mfy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eme huaka enchim áchay joäu johua. Huanärim ínel áu jiaahua: —Ítapo kaa kía ják éhuil usiari; huépülak jíbate áchayek, juka Diosta. ");
INSERT INTO mfy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Huanäi Jesús ínel ámeu jiaahua: —Eme juka Diosta Áchayeko, lútula huëpem nee nák éiyey, bueïtuk ínapo Diostat yeu simlataka äbo yebij‑la. Kanne ín éäpo äbo yebij‑la; áapo nee äbo bíttuala. ");
INSERT INTO mfy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jatchiakem kaa ín nokibet jüneiya? Bueïtuk kaa ín noki enchim jíkkaij bárë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eme diablota átteam, jü enchim átchay; éntok áapörik éähuem johua. Bueïtuk áapo yore súhua, kësam huëpo naateka, éntok jauhuey júne kaa lútüriata yáala, bueïtuk kaita lútüria át ayka. Bueïtuk ára nókïchiriata nokätek, ä áttea bétana nooka; bueïtuk áapo ára nókïchi, éntok ára nókïchi áchayhuaria. ");
INSERT INTO mfy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nee éntok lútüriata nokay junne, katem nee súale. ");
INSERT INTO mfy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jábesu enchim násuk ára nee nätua, kaa türik nee yáalä tíaka? Bueïtuk lútüriata nee nokay, ¿jatchiaka eme kaa nee súale? ");
INSERT INTO mfy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Huä Diosta áttea Diosta noki jíkkaja; íäri béchïbem kaa ä jíkkaja, bueïtukem kaa Dios áttearim. ");
INSERT INTO mfy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Huanäi jume judío yäuchim ínel ä yómmiak: —¿Jachute kaa tüisi jiaahua ítapo, enchi samaritano tíaka, éntok lemooniota enchi jípurëhui? ");
INSERT INTO mfy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús éntok ínel am yómmiak: —Ínapo kaa lemooniota jípure. Ál‑lane ín Átchay jikau chátcha; eme éntok kía kaitapo nee bitcha. ");
INSERT INTO mfy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Juka sïmek béppa musäla machik, kanne ino béchïbo ä jaria. Të aane, hua ino béchïbo ä jariame. Áapo hua nokta yoret chúpame. ");
INSERT INTO mfy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tua lútüriapone ínel enchimmeu jiaahua: Huä ín noki huë páman áu jípureme, kaibu muknake. ");
INSERT INTO mfy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Huanäi jume judío yäuchim ínel áu jiaahua: —Én ál‑late tua jüneiya lemooniota em jípurëhui. Abraham muukuk, éntok jume profeetam júne kókkok. Empo éntok ínel jiaahua: “Jü em noki huë páman áu jípureme, kaibë ä múknake tíiya.” ");
INSERT INTO mfy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Jachë empo chë yöhue itom áchay Abrahamta béppa, jü mukukame? Éntok profeetam júne kókkok. ¿Jábeta bénasisë emo éria? ");
INSERT INTO mfy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Huanäi Jesús ínel am yómmiak: —Inapoïsune ino úttilëtek, ín ino úttilëu kaita béj‑re. Huä ín Átchay, Áapo nee úttile, hua enchim emo Diosek tíähui. ");
INSERT INTO mfy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Të eme kaa ä täya. Ínapo ál‑la ä täya. Kanne ino ä täya tíätek, kíane ára nókïchitu éiyey, enchim bénasi. Tëne ä täya, éntokne ä nokihua yöre. ");
INSERT INTO mfy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham enchim átchay áu al‑leetuak, huaka ín taahuari áu bínnake tíaka. Huanäi éntok ä bíchaka, al‑leaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Huanäi jume judío yäuchim ínel áu jiaahua: —Empo kee cincuenta huásuktiriam huéria, ¿éntoke Abrahamta emo bit‑la tíiya? ");
INSERT INTO mfy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús éntok ínel ámeu jiaahua: —Tua lútüriapone ínel enchimmeu jiaahua: Kee jee Abrahamta yeu tómtey, ínapone huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Huanärim téttam nüka ä mamaasu báarey. Të Jesús am éusuriaka, tiöpopo yeu siika, áme násuk ámani. ");
INSERT INTO mfy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Áma huam huéeka Jesús senu yorem líptita yeu yoremtulata bitchak. ");
INSERT INTO mfy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Huanäi ä discíipulom ínel ä temajek: —Maestro, ¿jábesu Dios bejrita yáuhuak, íkäi ínëli líptitaka yeu ä yoremtukä béchïbo? ¿Áapo, o ä áchayhuam? ");
INSERT INTO mfy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús éntok ínel am yómmiak: —Kaa áapo éntok ä áchayhuam junne, katim Dios bejrim yáuhuak, líptitaka yeu ä yoremtunakë béchïbo; ál‑la Diosta tékilta át bittunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Úttea hua nee äbo bíttuakamta tékil ín yáanakëhui, huaka taahuata kee simeyo. Tukaari yebijnake; huanäi jábe júne kara tekipanuanake. ");
INSERT INTO mfy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ím ániapo ín anëpo tájti, íkäi ániatane machiria. ");
INSERT INTO mfy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Íkäi noksuka, buíapo chít huátteka, techoata yáuhuak. Huanäi súttuy ä nüka, líptita pusimmet ä teekak. ");
INSERT INTO mfy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Huanäi ínel áu jiaahua: —Ámanë sika emo báksia bäam mánekäpo Siloë teäpo. (Siloë “áman bíttuari” tiau báare.) Áapo áman sika áu báksiak; huanäi entok bíchaka nóttek. ");
INSERT INTO mfy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Huanäi jume áa náapo jóakaïhui, éntok jume bannaataka ä täyäu ä líptitukau, ínëlim náu jiaahuay: —¿Jachu ïri kaa áman káteka nénetaneïhui? ");
INSERT INTO mfy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Huate ínel jiaahuay: —Áapo ájäria. Huate éntok: —Ëe, kaa ájäria. Alë bénna. Áapo éntok ínel jiaahuay: —Ínapone ájäria. ");
INSERT INTO mfy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Huanärim ínel áu jiaahua: —¿Jáchisë ayuka én ára bitcha? ");
INSERT INTO mfy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Huanäi ínel am yómmiak: —Huä yoreme Jesús tíame techoata yáaka pusimpo ínot teekak, ínel inou jíaka: “Ámanë bäam mánekäu Siloéu sika emo báksia.” Huanäine áman sika ino báksiaka bíchaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Huanärim ínel áu jiaahua: —¿Jáksu aane, jü yoreme? Áapo éntok: —Ínel jiaahua —kanne jüneiya. ");
INSERT INTO mfy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jume pariserommeu yeu tóijhuak, jü líptitukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jimyore taahuaritukay, juka Jesústa techoata yáaka, juka líptita pujtetuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Huäri béchïbo, júchi bénasim ä temajek, jume pariseerom, jáchín ä pujtekä bétana. Huanäi ínel ámeu jiaahua: —Techoata pusimpo ínot teekak. Huanäine ino báksiaka bitchak. ");
INSERT INTO mfy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Huanäi huate pariseerom ínel jiaahuay: —Jü yoreme kaa Diosta bétana huéiye, bueïtuk jimyore taahuata kaa yöre. Huate éntok ínel jiaahuay: —¿Jáchisen juëna yóremtaka ímëi señaalim jonake? Júnëlim kaa nanabeu éaka náu nok nássuay. ");
INSERT INTO mfy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Huanärim júchi ínel áu jiaahua, jü líptitukäutahui: —¿Jáchisë jiaahua empo, hua enchi pujtetuakamta bétana? Áapo éntok am yómmiak: —Ínapo, ä profeeta tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Të jume judíom katim ä súaleka taahuak, kaa bíchaka ä pujtekä bétana. Huanärim juka líptitukäuta áchayim núnutebok. ");
INSERT INTO mfy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Huanärim am temajek: —¿Jachu ïri jü enchim üusi, hua kaa bíchaka enchim yóremtula tíähui? ¿Jáchisu júntuk én bitcha? ");
INSERT INTO mfy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jume ä áchayim entok ínel am yómmiak: —Jüneate íkäi itom üusekähui, éntok líptitaka yeu ä yóremtukähui; ");
INSERT INTO mfy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","të én jáchin ä bíchäu, éntok jábeta ä pujtetuakäu, katte jüneiya. Áapo béja yöhue; akem ä temaje. Áapo noknake. ");
INSERT INTO mfy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ä áchayhuam ínëli jiaahuak, judíom májhueka. Bueïtuk ímëi nokta náu yáalatukay, ínel jíaka: “Kía jábeta junne Jesústa Mesías tíayo, jum tiöpopo yeu béeptunake.” ");
INSERT INTO mfy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Huäri béchïbom ínel jiaahuay, jume ä áchayim: “Béja yöhue; áapörikem nátemaje.” ");
INSERT INTO mfy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Huanärim júchi juka yoremta líptitukäuta núnuteboka, ínel áu jiaahua: —Diosta bíchäpe lútüriata itom téjhua. Ítapote jüneiya íkäi yoremta juëna yóremtukähui. ");
INSERT INTO mfy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Áapo éntok ínel am yómmiak: —Ä juëna yóremtukäu, ínapo kaa jüneiya. Të senu huémtane ál‑la jüneria: ínapo kaa bitchay, tëne én ál‑la bitcha. ");
INSERT INTO mfy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Júchim éntok ínel áu jiaahuak: —¿Jítasu emou yáuhuak? Éntok, ¿jáchisu enchi pujtetuak? ");
INSERT INTO mfy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Áapo éntok ínel am yómmiak: —Béjane enchim téjhuaala, të katem nee nok jíkkaja. ¿Jatchiakasem júchi ä jíkkaij báare? ¿Jachu két eme ä discíipulomtu báare? ");
INSERT INTO mfy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Huanärim áu omteka ínel áu jiaahua: —Empo jü yoremta disciipulo; të ítapo Moiséjta discíipulomte. ");
INSERT INTO mfy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ítapo jüneiya Diosta Moiséjtau nokakähui; të íäri bétana, katte jüneiya jákun ä jometukähui. ");
INSERT INTO mfy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jü yoreme éntok ínel am yómmiak: —Ïri tua át guómtisi maachi, áapörik nee pusim étaporiakähui, éntok enchim kaa ä jüneriähui jákun ä jometukähui. ");
INSERT INTO mfy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jüneate jume Diosta bejri joame Diosta kaa am nok jíkkajähui; të jábe junne Diosta yöreka, entok ä éä páman áneme, huákäi nok jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jauhuey júne kaabeta bétana jíkkaij‑ri líptitaka yeu yóremtulataka ä bíchakä bétana. ");
INSERT INTO mfy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ï kaa Diosta bétana huëtek, kaita ára yáa éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Huanärim ínel ä yómmiak: —Empo Dios bejripo yeu yóremtulataka junne, ¿itomë majtia báare? Huanärim áma yeu ä jaasek. ");
INSERT INTO mfy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús ä jíkkajak, áma yeu ä simtuahuaka bétana. Huanäi ä téaka, ínel áu jiaahua: —¿Jachë empo Diosta Üusi súale? ");
INSERT INTO mfy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Áapo éntok ínel ä yómmiak: —Señor, nechë téjhua ä jábétukähui, ín ä súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús éntok ínel áu jiaahua: —Akë ä bil-la; ínapone ájäria, jü émomak nokame. ");
INSERT INTO mfy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Huanäi tónommia kíkteka ä yörek, ínel jíaka: —Señor, enchine súale. ");
INSERT INTO mfy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús éntok ínel jiaahua: —Bette nokta chúpa bárekane ím ániau yepsak, huame kaa bíchame bínnakë béchïbo, huame bíchame éntok kaa bíchamta bénasi am tahuanaké béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Huanäi huate pariseerom áamak anëu, íkäi jíkkajaka, ínel áu jiaahua: —¿Jachu ítapo két liliptim? ");
INSERT INTO mfy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús éntok ínel am yómmiak: —Liliptimtukem, jü Dios bejri kaa enchimmet ayu éiyey. Të én enchim emo bíchä tíä béchïbo, jü Dios bejri enchimmet taahua. ");
INSERT INTO mfy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Tua lútüriapone ínel enchimmeu jiaahua: jü kaa kabara kóräi puerta páman kibakekame, të sékäna áman túbuktekame, lak‑ron, éntok útteapo jábeta jita üuhua. ");
INSERT INTO mfy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Të hua puerta páman kibakekame, áapo jü kab‑yeero. ");
INSERT INTO mfy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jü puertata suayame, íkäi ä étaporia. Jume kabaram éntok juka kab‑yeerota nok täya. Áapo éntok jume ä kabarammeu bem téhuampo ámeu nokaka, yeu am béeba. ");
INSERT INTO mfy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huame sïme ä átteahuam yeu am bebaka ámepat huéenake. Jume kabaram éntok ä guojaanake, bueïtukim ä nok täya. ");
INSERT INTO mfy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Të kaa bem täyähuim kaibu guojaanake, ál‑lam ä tö tenninake, bueïtukim täbuik nok jíahuita kaa täya. ");
INSERT INTO mfy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Íkäi ejemplota ámeu yétchak, jü Jesús; të bempo kaa jünéaka taahuak, jita bétana ámeu ä nokaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús éntok júchi ámeu nookak, ínel jíaka: —Tua lútüriapone ínel enchimmeu jiaahua: Ínapone ájäria jü kabara kóräi puerta. ");
INSERT INTO mfy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sïme huame ínopat äbo yájakame, útteapom jábem jita üuhua, éntokim ëekbua; të jume kabaram katim am nok jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ínapone jü puerta; hua ínot éaka kabara kóräiu kibakeme, jínëutuna. Kóräipo kíkkibaknake, éntok yeu hueramnake, éntok básota téunake. ");
INSERT INTO mfy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Jü lak‑ron kía ékbua báreka yebijnake, éntok jábeta mëbáreka éntok jita chíbejtiaka ä tejal báreka. Të ínapo äbo yebij‑la jíapsihuamta enchim jípunakë béchïbo, éntok büruk béppa yún enchim ä jípunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ínapone jü tü kab‑yeero. Huä tü kab‑yeero ä jíapsi nénkinake ä kabaram béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Huä tómipo kabaram suayame, kaa tua tü kab‑yeero, éntok kabaram kaa átteak. Robota áu huémta bichätek, kabaram tö búitinake. Huanäi jü robo ámeu yepsaka am kíkkisuka chíbelam am jaanake. ");
INSERT INTO mfy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Júnëli hua tákiataka kabaram suayame búitinake, bueïtuk kía tómipo am suaya. Kabaram täruk junne, kaita áma täru. ");
INSERT INTO mfy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ínapone ájäria jü tü kab‑yeero. Jume ín kabaramne täya; huame ín kabaram éntok, nechim täya. ");
INSERT INTO mfy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Alë bénasi jü ín Áchay nee täya, éntok ínapo két ín Áchayne täya. Éntokne ín jíapsi nénka jume kabaram béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Huate kabaramne jípure, të huámëi kabaram kaa ímï kóräipo joome. Huámëine két äbo huérianake, éntokim két nee nok jíkkaijnake. Huépul bénasim náu anna; éntok huépü kab‑yerotunake. ");
INSERT INTO mfy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jü ín Áchay huäri béchïbo nee nákkë, bueïtukne sïmem béchïbo ín jíapsi nénka; chúkula éntokne júchi ára ä nüye. ");
INSERT INTO mfy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kaabe nee ä úhua; ál‑lane ínel ín éä béchïbo muuke. Útteatane jípure ín múknakë béchïbo, éntokne útteata jípure júchi jíapsita ín nünakë béchïbo. Íkäi nésautane mabetak, ín Áchay bétana. ");
INSERT INTO mfy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kaa nanabeu éaka, júchim náu nok nássua táytek, jume judío yäuchim, ïri nokta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Juebénakam ínel jiaahuay: —Lemooniota jípure. Rokotula. ¿Jatchiakem ä nok jíkkaja? ");
INSERT INTO mfy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Huate éntok ínel jiaahua: —Jábe lemooniota jípureme kaibu ilë bénasi noknake. ¿Jachu jü lemoonio ára pusim am étaporia, jume liliptim? ");
INSERT INTO mfy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Buere tiöpota chúpukäu huáatihuau pajkotukay, jum buere joära Jerusalémpo. Huamëi taahuarimmechi éntok sébe tiempotukay. ");
INSERT INTO mfy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús éntok áma naa huéiyey, tiöpopo, Salomónta portaalimpo. ");
INSERT INTO mfy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Huanäi jume judíom ä kóntiaka ínel áu jiaahua: —¿Jauhuey tájtisë itom jíapsi kaa al‑leetuanake? Empo jü Cristotukätek huittë itom téjhua. ");
INSERT INTO mfy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús éntok ínel am yómmiak: —Enchimne ä téjhuaasula, të katem nee súale. Huä tékil ín yáari ín Áchay téhuampo, huäri ino bétana nooka; ");
INSERT INTO mfy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","të eme kaa ä súale, bueïtukem kaa ín kabaram, ín enchimmeu jíakä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Jume ín kabaram nee nok täya; ínapo éntok am täya, éntokim nee guojaase. ");
INSERT INTO mfy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ínapo éntok jíbapo béchïbo jíapsihuamta am miika. Bempo kaibu emo tärunake jauhuey junne, éntok kaabe ín mámpo yeu am huíknake. ");
INSERT INTO mfy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Huä ín Átchay nee am mikakame, chë sïmem béppa nésahue, éntok kía jábe júne kara ín Áchay mámpo yeu am huíkke. ");
INSERT INTO mfy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ínapo, éntok ín Átchay, náute huépülay. ");
INSERT INTO mfy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Huanäi jume judíom júchi tétam nüka, ä mamaasu báreka. ");
INSERT INTO mfy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús éntok ínel am yómmiak: —Juebenakne türi tékilta enchim bíttuala, ín Áchay bétana huémta. ¿Jíta tékilta béchïbosem nee mamaasu báare? ");
INSERT INTO mfy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jume judíom éntok ínel ä yómmiak: —Huä tü tékilta béchïbote kaa enchi mamaasu báare, ál‑la Diosta béj‑reka em nokakä béchïbo; bueïtuk empo yóremtaka junne, Diosta bénasi emo johua. ");
INSERT INTO mfy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús éntok ínel am yómmiak: —¿Jachu kaa ínel jïojteri enchim leypo: “Ínapo ínel jiaahua, emem diosim”? ");
INSERT INTO mfy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Huame Diosta noki mabetakame diosim tíiya. Huaka jïojterita kaabe ára täbuiasi ä yáuhua. ");
INSERT INTO mfy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Bueïtuk Dios Átchay nee yeu púuhuak; ím ániau nee kóm bíttuak. ¿Jatchia júntukem Diosta béj‑reka nee nokä tíiya, ínapo Diosta Üusi ti nee jíakä béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Juka ín Áchay tékil kaa nee joay, katem nee súalpo yúmala. ");
INSERT INTO mfy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Të nee ä joay ál‑la, éläposem nee kaa súale, të huaka tékilta ín joähuem súale, enchim jüneenakë béchïbo, éntok enchim ä súalnakë béchïbo, juka Dios Áchayta ínot anëhui, éntok ín át anëhui. ");
INSERT INTO mfy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Júchim éntok mámpo ä tatab báreka tekipanuay, të áapo bem mámpo áu yeu huíkkek. ");
INSERT INTO mfy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Huanäi Jesús júchi siika, Jordán bathue huáytana bícha, áman kësam huëpo Juanta batöaïpo. Huanäi huämi taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Huanärim juebénaka áu yájjak, ínel jíaka: —Juan lútüriapo kía jita señalta júne kaa yáuhuak; të sïme Juanta íäri bétana nokakäu lútüriatukay. ");
INSERT INTO mfy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Huanäi huämïri juebénaka ä súsualeka taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Senu yoreme Láazaro ti téhuaka júnaköri kökorey, Betaniapo jometaka, María éntok Marta ä ákorohua pueblopo. ");
INSERT INTO mfy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María, Láazaro kökoremta huaayi, ïri ínel jü Señortat juka perfuumeta át töak, éntok ä chonimmey guókpo ä huaachak. ");
INSERT INTO mfy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Láazarota huaayim Jesústau nokta bíttuak, ínel jiamta: —Señor, jü em nákëu kökore. ");
INSERT INTO mfy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús éntok ä jíkkajaka ínel jiaahua: —Ï kökoa kaa áy kókko béchïbo, ál‑la juka Diosta looria át bíttunakë béchïbo, éntok két ä Üusibet ä bíttunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús éntok Martata nákkey, éntok ä huayihua, éntok Láazarota. ");
INSERT INTO mfy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Të íkäi jíkkajaka, ä kökorë bétana, júchi guoy táapo áma taahuak, ä aneïpo. ");
INSERT INTO mfy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Huanäi chúkula jume ä discíipulommeu ínel jiaahua: —Jánte jum Judea buiärau bíchaa. ");
INSERT INTO mfy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Huanäi jume ä discíipulom ínel áu jiaahua: —Maestro, én jume judíom enchi jariay, tetammey enchi mamaasu báreka. Entok, ¿júchë áman huée báare? ");
INSERT INTO mfy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús ínel am yómmiak: —¿Jachu jü taahuari kaa dooce horam jípure? Huä taahuapo hueramame kaibu tëitinake, bueïtuk ímï ániapo machiriay bitcha; ");
INSERT INTO mfy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","të hua tukaapo hueramame tëitinake, bueïtuk jü machiria kaa át aika. ");
INSERT INTO mfy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Íkäi noksuka, chúkula ínel ámeu jiaahua: —Huä itom amigo Láazaro kótche; tëne áman huéiye ä búsa báreka. ");
INSERT INTO mfy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Huanäi jume ä discíipulom ínel jiaahua: —Señor, kóchëtek, yún éenake. ");
INSERT INTO mfy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús ínel jiaahua, Láazarota mukila bétana. Të bempo kócheka jimyorehuamta bétana ä nokä téiyey. ");
INSERT INTO mfy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Huanäi Jesús huitti ínel ámeu jiaahua: —Láazaro béja muukuk. ");
INSERT INTO mfy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Enchim béchïbone al‑leiya, kaa áman itom anekä béchïbo, enchim nee súalnakë béchïbo. Të ámante áu kannake. ");
INSERT INTO mfy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Huanäi hua Toomas, Guoguörï téame, ínel jiaahua huame áamak discíipulommehui: —Ítapo kétte áamak kannake, áamak kókko béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús áman yepsaka tejhuahuak: Láazaro béja naiki taahuarey, mäataka. ");
INSERT INTO mfy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pueblo éntok kaa mékka Jerusaléniu taahuay, jíba tua batte báij kiloometropo. ");
INSERT INTO mfy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juebena judíom ámeu yáij‑latukay Martatau éntok Maríatahui, am yánti jíapsi joa báreka, bem ábachi mukukä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Huanäi Marta Jesústa áman huë tíay ä jíkkajaka, ä nankiseka yeu siika; María éntok jóapo taahuak. ");
INSERT INTO mfy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Huanäi Marta Jesústau ínel jiaahua: —Señor, enchi ím aney ín ábachi kaa muk éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Të énne két jüneiya, sïmeta Diostau em aahuäu, Dios enchi ä máknake. ");
INSERT INTO mfy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús éntok ínel ä yómmiak: —Em ábachi jíabitenake. ");
INSERT INTO mfy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta éntok ínel áu jiaahua: —Ínapo jüneiya ä jíabitenakëu júnak sïmem jíabiteyo, huaka taahuata yúmako. ");
INSERT INTO mfy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús éntok ínel áu jiaahua: —Ínapone jü yore jíabitetuame éntok jü jíapsihuamta yore mákame. Huä nee súaleme mukilataka júne júchi jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Éntok sïme hua jiápsaka nee súaleme jíbapo béchïbo kaibu muknake. ¿Jachë íkäi súale? ");
INSERT INTO mfy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Jeehui, Señor —ti áu jiaahua—. Ínapo ä súale, enchi Cristotukähui, jü Diosta Üusi ím ániau kóm yebij‑lame. ");
INSERT INTO mfy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta éntok íkäi noksuka áman sika, juka Maríata ä huayhua núnnuk, éhuil ínel áu jíaka: —Jü Maestro ím aane; entok enchi núnnu. ");
INSERT INTO mfy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Áapo íkäi jíkkajaka, bamsipo kíkteka áman áu siika. ");
INSERT INTO mfy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ketune kee huam ili pueblou kibakey, Martata ä nankekäpo ketune aaney. ");
INSERT INTO mfy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Huanäi jume judíom jóapo áamak aneka ä sirok aniaïhui, Maríata bamsipo yeu ä sik, akim ä guojaasek, ínel jíaka: “Áman siika, ä mäariu buanseka.” ");
INSERT INTO mfy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María jum Jesústa anëu yepsaka, ä bíchaka, guókpo áu tónommea kíktek, ínel jíaka: —Señor, enchi ím aney, ín ábachi kaa muk éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús ä buanay ä bíchaka, éntok két huame judíom áamak kateïhuim buaname bíchaka, jíapsi sóokteka espíritupo áu yoyoak, tüisi siroksi. ");
INSERT INTO mfy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Huanäi ínel jiaahua: —¿Jáksem ä maäak? Bempo éntok ínel áu jiaahua: —Señor, äbe sika ä bitcha. ");
INSERT INTO mfy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Huanäi Jesús buaanak. ");
INSERT INTO mfy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Huanäi jume judíom ínel jiaahua: —¡Akem ä bitcha, tepa ä nákkey! ");
INSERT INTO mfy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huate éntok áme násuk aneme ínel jiaahuay: —¿Jachu ïri kara jita yáuhuai, Láazarota kaa múknakë béchïbo, jáchin juka líptita ä pujtetuakä bénasi? ");
INSERT INTO mfy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús, ä jiápsipo júchi tüisi siroksi éaka, ä mäariu bíchaa siika. Téta guójöriatukay; ï guójöria éntok téta buëurukuy páttiaritukay. ");
INSERT INTO mfy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús ínel jiaahua: —Juka tétatem mékka oóre. Marta, jü mukukamta huaayi, ínel áu jiaahua: —Señor, béja chïcha juuba, béja naiki taahuare mukilataka. ");
INSERT INTO mfy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús ínel áu jiaahua: —¿Jachune kaa enchi téjhuaala, ä súalëtek, Diosta looria enchi bínnake tíaka? ");
INSERT INTO mfy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Huanärim tétata mékka oórek, juka mukilata áy páttiatukaïhui. Huanäi Jesús, téhuekau jikau remteka, ínel jiaahua: —In Átchay, enchine baysauhue enchi nee jíkkajä tíaka. ");
INSERT INTO mfy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ínapone jüneiya, jíba enchi nee jijikkajähui; tëne ínëli jiaahuak huaka génte juebenaraata ino chíkola aneme béchïbo, enchi nee äbo bíttuakäu bétana am súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Íkäi noksuka, kusisi cháchayek: —Láazaro, ¡pakunë yeu huéiye! ");
INSERT INTO mfy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Huanäi jü mukilatukäihui yeu siika, mámpo éntok guókpo sánkommea súmataka. Ä pújbahua éntok sánkommea bïtiatukay. Jesús éntok ámeu ínel jiaahua: —Akem ä búttia, ä huéenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Huanäi juebena judíom Maríatamak ambáreka áma yáij‑latukay. Huanärim Jesústa yáakäu bíchaka ä súsualek. ");
INSERT INTO mfy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Të huate éntok jume pariserommeu sájaka, Jesústa yáakäu am téjhuak. ");
INSERT INTO mfy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Huanäi jume sacerdotem tiöpopo chë nésahueme éntok jume pariseerom juka conciliotam náu núnuka, ínel jiaahua: —¿Jáchisute annake? Bueïtuk ï yoreme juebena señaalim johua. ");
INSERT INTO mfy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kía ínëli itom ä tójak, sïme ä súsualnake. Huanäi jume romaanom äbo yájaka juka itom tiöpo tátabnakë, éntokim huaka itom nación luutianake. ");
INSERT INTO mfy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Huanäi jü Caifás ámemak joome, huäri huásuktiriat sumo sacerdotetukai, huanäi ínel ámeu jiaahua: —Emem kaita jüneria, ");
INSERT INTO mfy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","éntokem kaa jüneiya, ito béchïbo jita chë türiakähui, huépü yoremta itom pueblota béchïbo muknakëhui, të kaa sïme naciónta kókkonakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaa ä éäpo íkäi nookak, Jesústa bétana, ál‑la huäri huásuktiriat áapo sumo sacerdotetukä béchïbo, profetisaruak hua naciónta béchïbo Jesústa muknakëïhui, ");
INSERT INTO mfy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","éntok kaa kía naciónta béchïbo jíbba, két huame Diosta üusim chíbejtilam lópola náu am rúktia béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Júnëli huäri taahuarit naateka náhuim nokta yáuhuak, ä mëtebo báreka. ");
INSERT INTO mfy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Huäri béchïbo Jesús béja kara machisi jume judíom násuk naa huéiyey, ál‑la mékka bíchaa siika, senu buiärau see päria, náapo, hua pueblo Efraín téähui. Huämi taahuak, jume ä discíipulommaki. ");
INSERT INTO mfy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Éntok béja kaa jaikika bëyey, judíom pascua pajkota yúmanakëhui. Huanärim juebénaka buere joära Jerusaléniu jikau sájjak, kee pascua pajkota yúmayo emo báksia báreka. ");
INSERT INTO mfy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Huanärim juka Jesústa jariay. Jum tiöpopo aneka, ínëlim emo nátemajey: —¿Jáchisem éiya? ¿Jachu kaa äbo pajkou yebijnake jäni? ");
INSERT INTO mfy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Huanäi huame tiöpopo chë nésahueme éntok huame pariseerom át nésahuek, hua jábe júne ä jüneriame, ják ä anëhui, yeu ä buís sáyhuak, ä pereesote béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Búsan taahuarim bëyey, kabara jísobahuaka pájcuata yáanaïhui. Jesús pueblo Betaniau yepsak, Láazarota jóapo. Ïri mukilatukay, të Jesús kókkolam násuk ä jíabitetuak. ");
INSERT INTO mfy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Béja kúptey Jesústam tepa buere äbosey. Marta éntok jita am joriay. Láazaro éntok Jesústamak mesau kátekay. ");
INSERT INTO mfy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Huanäi María batte medio litro perfuumeta Jesústat guókimmet töak, éntok ä chonimmea ä huaachak. Jü kári éntok musäla júbay tápunak. Ï perfuume tüisi béj‑retukay. ");
INSERT INTO mfy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Huanäi senu ä disciipulo ínel jiaahua, hua Judas Iscariote tíame, Símonta üusi, hua ä nénkinakëihui: ");
INSERT INTO mfy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Jatchiakasu kaa ï perfuume báij cien taahuari tékil béjhuapo nénkihuaka, póolobem ä miikhuak? ");
INSERT INTO mfy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ínëli jiaahuak, kaa póobem ä jiokolë béchïbo; ál‑la ékbua ára jita nüyey; bueïtuk juka tómi bóosata jípureka, juka áma öorehuamta nunüyey. ");
INSERT INTO mfy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Huanäi Jesús ínel áu jiaahua: —Akë ä tójja. Áapo ín mäanä taahuari béchïbo ä bëlatukay. ");
INSERT INTO mfy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bueïtuk jume póolobem jíbem enchimmak am jípunake; ínapo éntokne kaa jíba enchimmak tahuanake. ");
INSERT INTO mfy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juebena judíom Jesústa áma aney jüneriaka, ámanim yájjak, kaa áapörik jíba bít báreka, të Láazarota kétchi, juka kókkolam násuk ä jíabitetuakaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Të huame tua chë nésahueme nokta náu lútüria yáuhuak, juka Láazarota két mënä béchïbo, ");
INSERT INTO mfy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bueïtuk áapörik béchïbo juebena judíom emo näikimtey, Jesústa súaleka. ");
INSERT INTO mfy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Yokoríapo génte buéresi juebénaka jum pajkou yáij‑latukaïhui, Jesústam jum Jerusaléniu yebisisë téamta jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Huanärim jume tako sáhuam nüka, ä nankiboka yeu sájjak, éntokim ínel chaayey: —¡Tüisi mabettunake! ¡Ï santo, jü Señorta téhuampo yebisiseme, jü Israeltau Rey! ");
INSERT INTO mfy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Huanäi Jesús juka buru asölaata téaka át jikat yejtek, jïojteta jíä bénasi: ");
INSERT INTO mfy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Katë májhue, buere pueblo Siónta maala; ímï huéiye jü em Rey, buru asölaatat yejsimeka. ");
INSERT INTO mfy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Íachïrim kaa jünéaka tahuakay, jume ä discíipulom kësam huëpo; të juka Jesústa jíabitek buéresi úttilhuaka ä mabethuak. Huanäi jübuam áu huáhuaatek, áa bétana íkäi jïojtetukäihui, éntok áachä chúpahuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jü génte áamak aneïhui, áa bétanam nookay, jáchin Láazarotau chachayeka jum ä mäaripo kókkolam násuk ä jíabitetuak. ");
INSERT INTO mfy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Huäri béchïbo két jü génte ä mabet báreka áma yájakay, bueïtukim ä jíkkajak, áapörik íkäi señalta yáakä bétana. ");
INSERT INTO mfy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Të jume pariseerom, bempo náu ínel jiaahuay: —Béjem ä bitcha, kaitate ára yáuhua. Áachem suuhua, ¡sïme génte áamak kaate! ");
INSERT INTO mfy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Griegom ket kaa jaikika áme násuk aaney, huame áman pajkou Diosta yöri báreka jikau sákalam násuku. ");
INSERT INTO mfy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ímëi Feliipetau rúktek, pueblo Betsaida Galiléa buiärapo jometahui. Huanärim jiokot áu jiaahuay, ínel jíaka: —Jesústate bít péiya. ");
INSERT INTO mfy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Feliipe éntok Andrésta ettejhuariak. Huanäi jü Andrés éntok Feliipe Jesústam téjhuak. ");
INSERT INTO mfy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús éntok ínel am yómmiak: —Tiempo béja yúmase, juka Yoremta Üusi ti téhuaakamta úttilnähui. ");
INSERT INTO mfy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tua lútüriapone enchimmeu ínel jiaahua: Jü tirijko báchia kaa buíapo kóm huécheka mukuka síhuekätek, áapola tahuanake; të mukuka síhuekätek, yún takanake. ");
INSERT INTO mfy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Huä ä jíapsi beutireme ä tärunake; të ím ániapo ä jíapsi kaa beutireme, ä yü jíapsinakë béchïbo ä ëria. ");
INSERT INTO mfy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jü nésauta nee joria báareme nee guojaanake. Huanäi huam ín anëpo két annake, hua nésauta nee joriame. Jü nésauta nee joriame, ín Átchay ä úttilnake. ");
INSERT INTO mfy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Huanäi Jesús ínel jiaahuak: —¡Tepa kaa al‑leeri ín jíapsit aayuk! ¿Jáchisune jiaunake jäni? Karane ínel jiaahua: “In Átchay, ¡inou huéenakemta bétanë nee jínëu!” ¡Bueïtuk íkäi ín chúpanakë béchïbone äbo yepsak! ");
INSERT INTO mfy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","In Átchay, em téhuame looriasi bíttebo. Huanäi jíahui téhueka bétana kóm yuumak, ínel jíaka: —Béjane looriasi am bíttebok, éntokne júchi looriasi am bíttebonake. ");
INSERT INTO mfy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Huanäi hua génte juebenara áamak anëu juka jíahuita jíkkajaka, yúkuta ínel omtë tíiyay. Huate éntok ínel jiaahuay: —Diosta ángel áu nookak. ");
INSERT INTO mfy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Huanäi Jesús ínel ámeu jiaahuak: —Ï jíahui kaa ino béchïbo äbo kóm yuumak, ál‑la enchim béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ëni ájäria ï ániapo anemmet nokta chúpatunakëhui. Én hua diablo ím ániapo buéresi ä nésahue násuk júne yeu béptunake. ");
INSERT INTO mfy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ínapo éntok buíapo jikau tóboktiahuak, sïmemne inou rúktianake. ");
INSERT INTO mfy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ínëli jiaahuay, jáchin ä muknakeu am jüneria ïaaka. ");
INSERT INTO mfy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Huä génte ínel ä yómmiak: —Ítapo jum Diosta leypo ä jüneriak, Cristota jíbapo béchïbotunakëhui. ¿Jáchisu júntukë ä tóboktianä tíiya, juka Yoremta Üusi ti téhuaakamta? ¿Jábesa júntuk, ïri Yoremta Üusi? ");
INSERT INTO mfy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Huanäi jü Jesús ínel ámeu jiaahua: —Ketune chúbala enchim násuk annake, jü machiria. Náasem kaate, ketune machiriata enchimmeu ayuako, kaa máchiraata kaa enchim jaatianakë béchïbo; bueïtuk hua kaa machiku hueramame kaa jüneiya jákun bíchaa ä huëhui. ");
INSERT INTO mfy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ketune machiriata jípurekem ä súale, juka machiriata, machiriapo enchim usiarimtunakë béchïbo. Íkäi nookak jü Jesús; huanäi sika am éusuriak. ");
INSERT INTO mfy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Të juebena señaalim bem bíchäpo ä yáak junne, katim ä súaley, ");
INSERT INTO mfy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","profeeta Isaíasta nokakäu chúpnakë béchïbo, ínel jíamta: Señor, ¿jábetasu ámeu itom nokakäu súale jäni? Éntok, ¿jábetausum emo yeu machiriake jäni, huame Señorta mámmam? ");
INSERT INTO mfy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Íäri béchïbom kaa ä súaley, bueïtuk két ínel jiaahua jü Isaíasta jïojteri: ");
INSERT INTO mfy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bempörim puj páttiak, éntok bem jíapsi námakasi yáuhuak, pusimmea kaita bem bínnakë béchïbo, éntok jíapsiy kaita bem jünerianakë béchïbo, junëli kaa jíapsi kúakteka, kaa nee am jínëunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ínel jiaahuak, Jesústa looria bíchaka, bueïtuk áa bétana nookak. ");
INSERT INTO mfy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kía júnentaka junne, yäuram juebénaka ä súaleka taahuak. Të pariserom béchïbo katim emo yeu buíssey, kaa huam bem náu yayájäpo emo yeu bep ïaaka. ");
INSERT INTO mfy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bueïtukim chë ä türey, juka yoremta úttilhuä bétana bem máknäu, Diosta úttilhuäu béppa. ");
INSERT INTO mfy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús kusisi nokaka ínel jiaahua: —Huä nee súaleme kaa nee jíba súale, ál‑la huaka nee äbo bíttuakamta kétchi. ");
INSERT INTO mfy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Huä nee bíchame, huaka nee äbo bíttuakamta két bitcha. ");
INSERT INTO mfy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ínapo, jü machiria, äbo ániau kóm yebij‑la, sïme huame nee súaleme kaa machiku aneka áma kaa am kókkonakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jábe júne ín noki jíkkajaka, të ín éäu kaa joame, ínapone kaa bette nokta át chuppa; bueïtukne huame ím ániapo aneme kaa bette nokta ámet chupabáreka äbo kóm yebij‑la, ál‑la am jínëu báreka. ");
INSERT INTO mfy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Huä kaa nee mabetakame, éntok ín noki kaa jíkkaij báareme, jábeta bette nokta át chupanakemta jípure. Jü noki ín nokakähui, taahuata yúmak, bette nooki át chupanake. ");
INSERT INTO mfy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bueïtuk ínapo kaa kía ín éäpo ä nok‑la; hua Áchayhuari nee äbo kóm bíttuakame, áapo nee át sáuhuek jita ín noknakëhui, éntok jita enchim ín majtianakëhui. ");
INSERT INTO mfy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Éntokne jüneiya ä nésaurihua yü jíapsihuamtukähui. Júnëline huaka ín nokäu nooka, huaka ín Áchay nee ä téjhuaka pámani. ");
INSERT INTO mfy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Senu taahuari bëyey, kabara jísobahuaka pájcuata yúmaseïhui. Jesús jüneiyay, tiempota áa béchïbo yúmalatukaïhui ím ániapo yeu ä huéenakëihui, ä Áchaybeu bíchaa. Ä átteahuam ím ániapo aneme jíba am nákkek, ä mukëpo tájti. ");
INSERT INTO mfy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Huanäi tukaapo am jïbuäy, jü diablo Judasta jiápsipo kibak‑latukay, Jesústa ä nénkinakë béchïbo. Ïri Judas Iscariote, Símonta üusitukay. ");
INSERT INTO mfy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús jüneiyay ä Áchayhua sïmeta ä mámpo ä tóij‑latukaïhui, éntok Diosta bétana áu hueïhui, éntok Diostau bíchaa áu huéenakëihui. ");
INSERT INTO mfy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Júnëli kíkteka, jume súppem béppa huéeme áu úhuak. Toallam éntok nüka, am huikojtek. ");
INSERT INTO mfy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Huanäi buere puraatopo bäam yeu töaka ä discíipulom guók báksia táytek, éntok jume toallam ä huikosakäbey am huaachak. ");
INSERT INTO mfy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Huanäi Jesús jü Símon Perotau rúktek; Peero éntok ínel áu jiaahua: —Señor, ¿jache empo nee guók báksia báare? ");
INSERT INTO mfy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús éntok ínel ä yómmiak: —Jü ín jóäbet empo kaa át jüneiya én läuti; të chúkula ál‑lë át jüneenake. ");
INSERT INTO mfy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peero éntok ínel áu jiaahua: —Katë nee guók báksianake, jauhuey junne. Jesús éntok ínel ä yómmiak: —Kaa nee enchi guók báksiak, kaitë ínomak jípunake. ");
INSERT INTO mfy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Huanäi jü Símon Peero ínel áu jiaahua: —Señor, ä junëlitunakey, kaa ín guókim jíbba, ín mámmam éntok ín kóba júne báksia. ");
INSERT INTO mfy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Të Jesús ínel áu jiaahua: —Jü bemélasi baksiari kaa júchi báksiana, jume guókim jíbba, bueïtuk béja baksiari. Eme éntok béja báksiari, të kaa sïme. ");
INSERT INTO mfy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bueïtuk jüneiyay jábeta ä nénkinakëihui; huäri béchïbo: “Kaa sïme báksiari”, ti áu jiaahuak. ");
INSERT INTO mfy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Júnëli, chúkula am guók báksiasuka, júchi ä súppem nüka, mesau rúktek. Huanäi ínel ámeu jiaahua: —¿Jachu eme jüneiya jita ín enchimmeu yáakähui? ");
INSERT INTO mfy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eme nee Maeströ tíiya, éntokem nee Señor tíiya. Tüisem ínel jiaahua, bueïtuk enchim jiauläpo, ínapone ájäria. ");
INSERT INTO mfy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Të ínapo Señortaka éntok Maestrotaka júne enchim guók báksiak, eme kétchi náu emo guók báksiapo yúmala. ");
INSERT INTO mfy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bueïtuk ejemplotane enchim mákkak, ín enchimmeu ayuka bénasi enchim két náu ä jonákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tua lútüriapone ínel enchimmeu jiaahua: Huä sáyhuame kaa ä teko béppa chë yörihua; éntok hua jákun bíttuahuakame júne kaa chë yörihua áman ä bíttuakamta béppa. ");
INSERT INTO mfy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Íkärem jüneriätek, al‑leakem jíapsinake ä joäteko. ");
INSERT INTO mfy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Kanne sïmem bétana nooka. Bueïtuk ínapone jüneiya jábem ín yeu púalatukähui. Të úttea huaka jïojteta ínel jíamta chúpnakë béchïbo: “Huä páanim ínomak buäyeme nee béj‑reka áu tóboktiak.” ");
INSERT INTO mfy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Én naatekane enchim ä téjhua, kee jee huéenakemta chúpeyo, béja ä chúpey enchim ä súalnakë béchïbo ín ájäriatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tua lútüriapone ínel enchimmeu jiaahua: Huä ín jákun bíttuari mabetakame, nee mabeta; hua nee mabetakame éntok, huaka nee äbo bíttuakamta két mabeta. ");
INSERT INTO mfy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús íkäi noksuka, ä jiápsipo tüisi sirokay. Huanäi huitti ínel jiaahua: —Tua lútüriapone ínel enchimmeu jiaahua, senu enchim násuk aneme nee nénkinake. ");
INSERT INTO mfy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Huanäi huame ä discíipulom emo naa bíchaka taahuak, kaa jünéaka jábeta bétana ínel ä jíähui. ");
INSERT INTO mfy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Senu disciipulo, Jesústa chë nákeïhui, áa náapo káteka chákala bökay. ");
INSERT INTO mfy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Íähui señam yáuhuak, jü Simmom Peero, ä temaij ïaaka ä jábétukaïhui huaka áa bétana ä nokaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Huanäi áapo, Jesústau jëla rúkteka, ínel áu jiaahua: —Señor, ¿jábesa jüri em áa bétana nokähui? ");
INSERT INTO mfy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús éntok ínel ä yómmiak: —Huä jábeta páanim kómoniaka ín ä miknakeu, huäri ájäria. Huanäi jume páanim kómoniaka, Judas Iscarioteta, Símonta üusi, am miikak. ");
INSERT INTO mfy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Huanäi sep Satanás ä jiápsipo kibakek. Jesús éntok ínel áu jiaahua: —Juka em yáa bárëu, bamsekë ä yáuhua. ");
INSERT INTO mfy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Të huame mesau jokame katim jünéaka taahuak, jita béchïbo Judastau ínel ä jíakähui. ");
INSERT INTO mfy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bueïtuk huate ínel éiyay: Judasta tómi bóosata jípurë béchïbo, Jesús ínel áu jiaahua: “Pajkopo itom huáatianakeuë jínnu mátchi”, éntok: “Poloobeme mikpo yúmala”, tim éiyay. ");
INSERT INTO mfy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Áapo jume páanim buäsuka siika. Huanäi éntok béja tukaaritukay. ");
INSERT INTO mfy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Huanäi Judasta yeu simsuk, Jesús ínel jiaahua: —Én buéresi úttilna, jü Yoremta Üusi ti téhuaakame, éntok Dios Átchay áa béchïbo úttilna. ");
INSERT INTO mfy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jü Dios áapörik béchïbo úttilhuätek, áapo Dios kéchä úttilnake, ä éäpo; éntok läuti ä úttilnake. ");
INSERT INTO mfy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","In usiälam, ketunene kaa bínhua enchimmak annake. Nechem jariunake, të jume judíommeu ín jíä bénasi, enchimmeune két ínel jiaahua: Huam ín huëu bíchaa, eme karem áman kaate. ");
INSERT INTO mfy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bemela nésautane enchim mákka: Emóem nákke. Nee enchim nákëpo bénasi, emem két nánancha emo náknake. ");
INSERT INTO mfy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ímïrim sïmetaka enchimmet jüneenake, ín enchim majtialatukä bétana, nanabeu éaka enchim emo nákeyo. ");
INSERT INTO mfy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Huanäi jü Símon Peero ínel áu jiaahua: —Señor, ¿jákusë huée báare? Jesús éntok ínel ä yómmiak: —Áman ín huëu bíchaa, empo kara ínomak huéiye ëni; të chúkula arë ino sáu huéenake. ");
INSERT INTO mfy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peero éntok ínel áu jiaahua: —Señor, ¿jatchiakasune kara emo sáu huéiye ëni? ¡In jíapsi muknakey júnene ára ä tójja, emo béchïbo! ");
INSERT INTO mfy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús éntok ínel ä yómmiak: —¿Jachë em jíapsi ä muknakey júne ára ä tójja, ino béchïbo? Tua lútüriapone ínel emou jiaahua, juka totorörata kee jee kuseyo, baisë kaa nee emo täya tíanake. ");
INSERT INTO mfy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Katem enchim jíapsi jáchin éetua. Diosta enchim súalë bénasi, nechem két súale. ");
INSERT INTO mfy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In Átchay jóapo juebena káarim ayka; të kaa junëlitukätek ínapone enchim téjhua éiyey. Ámanne huée báare, huam enchim annakëpo tülisi ä tüte béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Huanäine téhuekau yepsak, huam enchim annakëpo ä tútenake. Huanäine júchi yebijnake. Huanäine júchi enchim äbo nünake, bueïtuk huam ín anëpo, ínomak enchim annakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bueïtukem jüneiya jákun bíchaa ín huéenakeu, éntok juka böota júnem täya. ");
INSERT INTO mfy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Huanäi jü Toomas ínel áu jiaahua: —Señor, katte jüneiya jákun bíchaa em huëhui; ¿jáchisute juka böota täyanake? ");
INSERT INTO mfy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Huanäi Jesús ínel áu jiaahua: —Ínapone jü böo, jü lútüria, éntok jü jíapsihuame; kaabe ín Áchaybeu huéenake, kaa ino béchïbotuko. ");
INSERT INTO mfy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nee täyätekem két ín Átchay täya; éntokem én naateka ä täya, éntokem ä bil-la. ");
INSERT INTO mfy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Feliipe éntok ínel áu jiaahua: —Señor, itomë ä bíttua, huaka Dios Áchayta. Júnëlite kaitat jáchin éaka tahuanake. ");
INSERT INTO mfy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Huanäi Jesús ínel áu jiaahua: —Béjane bínhua enchimmak aane, ¿éntoke jíba kaa nee täya, Feliipe? Huä nee bil-lame, juka Dios Áchayta bil-la. Ä junëlituk junne, ¿jatchiakasë júntuk Dios Áchayta nee enchim bíttua sáuhue? ");
INSERT INTO mfy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Jachë kaa ä súale, Dios Áchaytamak nee huépülatukähui?, éntok, ¿juka Dios Áchayta júne ínomak huépülatukähui? Huä noki ín nokäu, kanne kía ín éäpo ä nooka; hua Dios Átchay ínot aneme, áapo juka tékilta johua. ");
INSERT INTO mfy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nechem súale, Dios Áchaytat ín anëhui, éntok két Dios Áchay ínochi; o hua tékil ín joäu, huäri béchïbem nee súale. ");
INSERT INTO mfy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tua lútüriapone ínel enchimmeu jiaahua: Huä nee súaleme, huaka tékilta ín joäu áapo két ára ä jonake, éntok ín joäu béppa chë yörisi machik júne jonake, bueïtuk Dios Áchayta anëu nee huë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Éntok sïmeta juka ín téhuampo Dios Áchaytau enchim aahuäu, anä yáanake, juka Dios Áchayta Üusi úttilnä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","In téhuampo jita júne enchim aahuay, ínaponä yáanake. ");
INSERT INTO mfy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Nee nákëtekem juka ín nésauri johua. ");
INSERT INTO mfy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Huanäine ínapo Dios Áchaytamak noknake, täbui jíapsi jotehuamta enchim máknakemta, yü tütti enchimmak ä annakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ïri Espíritu tua lútüria. Të jume ímï ániapo joome, karam ä mabeta, bueïtukim kaa ä bitcha, éntokim kaa ä täya; të eme ä täya, bueïtuk enchimmak aane, éntok enchim jiápsipo annake. ");
INSERT INTO mfy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Kanne kía usi lepemtukä bénasi enchim tö simnake. Júchine enchimmeu yebijnake. ");
INSERT INTO mfy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ketune ili bëye; huanäi jume ím ániapo aneme kaa nee bínnake; të eme ál‑la júchem nee bínnake; bueïtuk ín jiapsä béchïbo, eme két jíapsinake. ");
INSERT INTO mfy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Huäri taahuarit eme jüneenake Dios Áchaytat ín anëhui; eme éntok ínochi, ínapo éntok enchimmechi. ");
INSERT INTO mfy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Huä ín nésaurim jípureme éntok am joame, ïri ájäria jü nee nákeme; hua nee nákeme, ín Áchay kéchä náknake. Éntok ínapo két ä náknake, éntokne áu ino yeu machirianake. ");
INSERT INTO mfy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Huanäi jü Judas ínel áu jiaahua, kaa hua Iscariote: —Señor, ¿jatchiakasë itou jíba emo yeu machirianake, të kaa huame ímï ániapo anemmehui? ");
INSERT INTO mfy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Huanäi Jesús ínel ä yómmiak: —Huä nee nákeme ín noki yörinake; éntok hua ín Áchay ä náknake. Huanäite áu yájaka áamak jóatenake. ");
INSERT INTO mfy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Huä kaa nee nákeme ín noki kaa yörinake; hua noki enchim jíkkajakäu, ínapone kaa ä átteak. Huä Dios Átchay nee äbo bíttuakame, Áapo ä átteak. ");
INSERT INTO mfy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Íkäine enchimmeu nookak ketune enchimmak aneka. ");
INSERT INTO mfy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Të hua jíapsi jotehuamta yore mákame, jü Espíritu Santo, hua Dios Áchayta äbo bíttuanakëhui ín téhuampo, huäri sïmeta enchim majtianake, éntok enchim áu huáatituanake, sïmeta huaka ín enchimmeu nokakähui. ");
INSERT INTO mfy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yánti jíapsihuamtane enchimmeu tö siime. In yánti jiápsekäune enchim miika, të kaa hua ím ániapo jometa bénasi. Katem enchim jíapsi kaa al‑leetua, éntokem kaa emo máujtua. ");
INSERT INTO mfy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Béjane enchim téjhuaala, ínel jíaka: Simnakene, tëne júchi enchimmeu yebijnake. Nee nákëtekem emo al‑leetuä éiyey, Dios Áchaytau nee ino simë tíayo; bueïtuk jü Dios Áchay chë yörisi maachi, ino béppa. ");
INSERT INTO mfy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Enchimne téjhuak, kee jee ä yúmayo, bueïtuk nokta chúpey enchim ä súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Kanne júchi yún enchimmak ettejhuanake, bueïtuk jü ím ániapo buéresi genteta béppa chë úttiakame äbo huéiye; të áapo kaita ínomak jípure. ");
INSERT INTO mfy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Të junëlitunake, ím ániapo aneme jüneenakë béchïbo Dios Áchayta ín nákëhui éntok Dios Áchayta ín ä sáhuë páman ín ä joähui. Jáptëem; ímïte yeu sákanake. ");
INSERT INTO mfy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Ínapone jü tua lutüriapo páras óuguo, ín Átchay éntok jü et‑leero. ");
INSERT INTO mfy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sïmeta huaka mesëkiriata ínot yeu simlata kaa takakamta chúktianake; éntok sïmeta huaka takakamta tútenake, chë yún ä takanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eme béja chïcha machik úhuari jü noki enchimmeu ín nokakäubeyi. ");
INSERT INTO mfy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Inot jíbem aane; ínapo éntok enchimmechi. Jáchin hua mesëkiria áapola kaa tataka, kaa hua óguotat huéekäteko, enchimmak két junëlitunake, kaa enchim ínot jíba aneyo. ");
INSERT INTO mfy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ínapone jü páras óuguo, eme éntok jume mesëkiriam. Huä ínot aneme, ínapo éntok áamaki. Ïri yún takam huériunake; bueïtuk eme kaa ínomak anëtek, kaitem ára yáuhua. ");
INSERT INTO mfy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Huä kaa ínot aneme, mesëkiriata bénasi päkun yeu jímmaahuaka huaknake. Huanäi náu tóijhuaka tájiu guötiana, ä béetinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Eme ínot anëtek, éntok juka ín noki enchimmet aneyo, sïmeta enchim huáatiähuem aahua; huanärem ä mákna. ");
INSERT INTO mfy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Íäri béchïbo loriapo úttilna, jü ín Átchay, yún enchim takakä béchïbo. Huanärem junëli ín discíipulomtunake. ");
INSERT INTO mfy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","In Áchayta nee nákë bénasi, ínapone két enchim nákke. Ínëlem enchim ín nákëpo jíba aane. ");
INSERT INTO mfy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eme ín nésauri joätek, enchim ín nákëpem jíba aane; ínëline ín Áchay nésauri johua, éntokne áapörik nee nákëpo aane. ");
INSERT INTO mfy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Íkäine enchimmeu nooka, ín al‑leäu enchimmet ayunakë béchïbo, éntok hua enchim al‑leäu yúmalasi enchim ä jípunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ïri ájäria jü ín nésauri: Jü enchim nánancha emo náknakeu, ín enchim nákëpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kaabe chë júne yore nákke, ál‑la hua ä amigom béchïbo ä jíapsi nénkame. ");
INSERT INTO mfy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eme ámëria jume ín amigom, huaka ín enchim át sáhuëu joäteko. ");
INSERT INTO mfy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kanne éntok ín tekipanualero ti enchim téttehuaanake, bueïtuk hua nésauta joaka tekipanuame kaa jüneiya, juka ä teko yáa bárëhui. Të ínapo enchim amigok, bueïtuk sïmeta huaka ín Áchay bétana ín jíkkajakäune enchim téjhuaala. ");
INSERT INTO mfy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Eme katem nee yeu púala, ál‑la ínapo enchim yeu púuhuak, éntokne enchim yuktiak áman sájaka yún takaka enchim jíapsinakë béchïbo. Huä enchim taka éntok kaa lütinake. Huanäi huaka sïmeta ín téhuampo Dios Áchaytau enchim aahuäu, áapo enchim ä máknake. ");
INSERT INTO mfy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nésautane enchim mákka, enchim emo náknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Huame ím ániapo aneme enchim omtiay, áahuem huáate nee bácham omtiakä bétana. ");
INSERT INTO mfy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eme ím ániapo jométuk, huame ím ániapo joome enchim nák éiyey. Të eme katem ím ániapo joome; ínapone ím ániapo enchim yeu púuhuak. Huäri béchïbo bempo, ím ániapo joome, katim enchim huáatia. ");
INSERT INTO mfy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Áahuem huáate, hua noki ín enchimmeu nokakähui: “Huä tekipanualero kaa chë yörihua ä teko béppa.” Nechim guojajjaasëtek, enchimim két guojajjanake; ín noki jíkkajätekim, enchim noki két jikkaijnake. ");
INSERT INTO mfy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Të sïmeta íkärim enchimmeu yáanake ín téhuam bem omtiä béchïbo, bueïtukim huaka nee äbo bíttuakamta kaa täya. ");
INSERT INTO mfy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Kaa nee äbo yepsak, éntok kaa nee ámeu nokak, jü bem Dios bejri kaa ámet ayu éiyey; të ënim kaachin jiau mátchi, jü bem Dios Bejri ámet ayuka bétana. ");
INSERT INTO mfy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Huä nee omtíame, ín Áchay két omtia. ");
INSERT INTO mfy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Áme násuk huaka tékilta kaa jábem júne joäu nee yáak, jü Dios bejri kaa ámet ayu éiyey; të ëni juka ín joäu bil-lataka junne, nechim omtia, éntok juka ín Áchay júnem omtia. ");
INSERT INTO mfy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Të ïri ínëli huéiye, juka Moiséjta leypo jïojteta chúpnakë béchïbo, ínel jíame: “Kaita béchïbom nee omtiaka taahuak.” ");
INSERT INTO mfy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Të huaka jíapsi yéjtehuamta yore mákamta yepsak, ín Áchay bétana ín enchimmeu bíttuanakeu, jü Espíritu lútüriata yore majtíame, Dios Áchayta bétana huéeme, huäri ino bétana noknake. ");
INSERT INTO mfy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eme éntok két ino bétana noknake, bueïtukem jíba ínomak aanek, kësam huëpo naateka. ");
INSERT INTO mfy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Íkäine jíba enchimmeu nok‑la, bueïtuk Diostat éehuäu kaa enchim tóijnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bueïtuk bem sinagogampom enchim yeu bébnake. Taahuari yúmanake, jábe júne enchim súakame Diosta nésauri áu joä bénasi éenake. ");
INSERT INTO mfy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Íkärim jonake bueïtukim Áchayhuarita kaa täya éntok nee junne. ");
INSERT INTO mfy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tëne íkäi enchimmeu nooka, huaka taahuata yúmak enchim áu huáatinakë béchïbo béja ín enchimmeu ä nok‑latukähui. ’Íkäine kaa kësam huëpo enchimmeu nookak, bueïtukne enchimmak aaney. ");
INSERT INTO mfy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Të énne áman siime, hua nee äbo bíttuakamtahui; të jábe júne kaa nee temaje: “¿Jákusë siime?” ");
INSERT INTO mfy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ál‑la íkäi enchimmeu ín nokakä béchïbo enchim jíapsi tüisi siroka. ");
INSERT INTO mfy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Të ínapo lútüriata enchimmeu nooka: Chë türi enchim béchïbo ín simnakëhui; bueïtuk kaa nee sik hua jíapsi yéjtehuamta yore mákame kaa enchimmeu yebijnake; tëne sikätek enchimmeu ä bíttuanake. ");
INSERT INTO mfy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Huanäi áapo yepsakätek, huame ániat jiápsame Dios bejrimmet am jüneetuanake, lútula jíapsihuamtachi, éntok bétte nokta chúpebechi. ");
INSERT INTO mfy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dios bejrichi, kaa bem nee súalë béchïbo; ");
INSERT INTO mfy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","lútula jíapsihua bétana, Áchayhuaritau ín huée béchïbo, éntokem kaa entok nee bínnake; ");
INSERT INTO mfy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","éntok bétte nokta bétana, bueïtuk jü buéresi ániat nésahueme bétte noki át chúpari. ");
INSERT INTO mfy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ketunene juebenak jípure, jita ín enchimmeu noknakëhui, të ënem kara ä huéria. ");
INSERT INTO mfy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Të jü lútüriapo Espíritu yepsakätek, áapo sïme lútüriau bíchaa enchim hueriunake; bueïtuk kaa áapo ä éäpo noknake, ál‑la huaka sïmeta ä jíkkajäu noknake; éntok enchim jünetuana huaka chúkula yebijnakemta bétana. ");
INSERT INTO mfy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Áapo loriapo nee úttilnake; bueïtuk ín átteapo ä nüka, enchim ä jüneriatuanake. ");
INSERT INTO mfy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sïmeta hua ín Áchay jípurëu, ínapone két ä átteak; kíalïkune ínel jiaahua, ín átteapo ä nüka enchim ä jüneriatuanake. ");
INSERT INTO mfy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Enchim kaa nee bínnakeu, kaa jaikika bëye; të júchi kaa jaikika bïnake, enchim nee bínnakëhui; bueïtuk ínapone Áchaytau bíchaa huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Huanäi huate ä discíipulom ínel náu jiaahuay: —¿Jítasa ïri itou ä nokähui? Kaa jaikika bëye kaa itom ä bínnakëhui, të júchi kaa jaikika bëye, chúkula itom ä bínnakëhui; ¡bueïtuk Áchaytau bíchaa áu simë tíiya! ");
INSERT INTO mfy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Inëlim jiaahuay: ¿Jáchisu jiau báare jäni, “kaa jaikika bëye”, tíaka? Katte át jüneiya, ä nokibechi. ");
INSERT INTO mfy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús jüneiyay bempörim ä temaij bárëhui; huanäi ínel ámeu jiaahua: —Béjane enchim téjhuak: kaa jaikika bëye, kaa enchim nee bínnakëhui, éntok júchi kaa jaikika bïnake, enchim júchi nee bínnakëhui. ¿Jachem íachi náu nátemaje? ");
INSERT INTO mfy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tua lútüriapone ínel enchimmeu jiaahua: buannakeem, éntokem jiokot jiaunake; jume ániat jiápsame éntok al-leenake. Të ínëli jü enchim sirokäu násuk junne, jü enchim sirokäu al‑leeriu bíchaa áu kúaktianake. ");
INSERT INTO mfy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jü jámut asoa bárëtek huantiriam ínnënake, horata áu yúmako; të chúkula ili outa asoak huantiriam koptianake, al‑leaka ím ániapo outa yeu yoremtukä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ánëlem két én siroka; tëne júchi enchim bínnake. Huanäi jü enchim jíapsi al‑leaka tahuanake, éntok kaabe ára enchim ä úhuaanake, juka enchim al‑leähui. ");
INSERT INTO mfy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Huámeï taahuarimmechem kaita inou nátemaijnake. Tua lútüriapone ínel enchimmeu jiaahua, sïme jita júne Dios Áchaytau enchim aahuäu ín téhuampo, Áapo enchim ä máknake. ");
INSERT INTO mfy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ketunem kaita áula ín téhuampo, én tájti. Jítem aahua, enchim ä mabetnakë béchïbo, éntok huaka enchim al‑leäu yúmalatunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Íkäine enchimmeu nok‑la, ejemployi; të taahuari yúmanake, kaa ejemplommey ín enchimmeu noknakëhui; ál‑lane jünakiachisi enchimmeu noknake, jü Áchayhuarita bétana. ");
INSERT INTO mfy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Huäri taahuarichem ín téhuampo jita áunake; ínapo éntok kanne jita enchim áurianake, jü Áchayhuaritahui enchim béchïbo, ");
INSERT INTO mfy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bueïtuk jü Dios Átchay enchim nákke, bueïtuk eme nee nákkek, éntokem Diostat ín yeu simlatukä bétana nee súalek. ");
INSERT INTO mfy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Dios Áchayta anëpone yeu sika, ï ániau kóm yepsak. Júchine íka ániata tö sika, jü Dios Áchaytau huéenake. ");
INSERT INTO mfy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Huanäi ä discíipulom ínel áu jiaahua: —Enë jünakiachisi nooka, kaita ejemplota itou nokaka. ");
INSERT INTO mfy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Én ál‑late jüneiya, sïmeta em jüneriähui; kíalïkute kaita emou temaij mátchi. Huäri béchïbote ä súale, Dios Áchayta bétana em yeu simlatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús éntok ínel am yómmiak: —¿Jachem én ä súale? ");
INSERT INTO mfy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Taahuari yúmanake, éntok béja yúmala, sákatuahuaka enchim chíbejtinakëhui, huépülaka ä böochi; éntokem nee ínapola tö sákanake. Tëne kaa ínapola taahua, bueïtuk jü Dios Áchay ínomak aane. ");
INSERT INTO mfy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Íkäine enchimmeu nok‑la, ino bétana yánti jíapsihuamta enchim jípunakë béchïbo. Ímï ániapem jiokot emo bínnake; të katem kóm éiya: ínapone íkäi ániata kobala. ");
INSERT INTO mfy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús íkäi noksuka, téhuekau jikau remtek, ínel jíaka: —In Átchay, béja taahuari yúmala. Loriapë ä úttile, juka em Üusi, áapörik két loriapo enchi ä úttilnakë béchïbo; ");
INSERT INTO mfy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","bueïtukë sïmem jiápsame béppa yäurata ä mák‑la, huame sïme em ä mákkim jíbapo béchïbo jíapsihuamta am máknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ïri éntok ájäria, jü jíbapo béchïbo jíapsihuame: Enchi bem täyanakëhui, huaka huépülaik entok tua lútüriapo Diosta, éntok juka Jesucristota, em äbo bíttuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ínapo ímï buíapo aneka loriapo enchi úttilek. Béjane ä chúppak, juka tékilta em nee yáa sáhuëhui. ");
INSERT INTO mfy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Én éntok, ín Átchay, loriapë nee úttile em anëpo, huaka loriata émomak ín jípurekäihui, ániata kee yáahuay naateka. ");
INSERT INTO mfy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Em téhuamne am täyatuala, jume yoremem ím ániapo em nee mákkim. Émpë am átteaka nee am mákkak, éntokim em noki ëriak. ");
INSERT INTO mfy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ënim jünéaka tahuala, sïmeta juka em nee mákki emo bétana huëhui; ");
INSERT INTO mfy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","bueïtuk huaka nokta em nee mákakäu nam téjhuak. Bempo éntok ä mabetak, éntokim lútüriapom jünëiak emo bétana ín huëhui, éntokim enchi nee äbo bíttuakäu súale. ");
INSERT INTO mfy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ínapone áme béchïbo emou nooka. Kanne huame huate ím ániapo aneme béchïbo nooka, ál‑la huame em nee mákakäu béchïbo; bueïtuk émpë am átteak, ");
INSERT INTO mfy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","éntok sïmeta huaka ín átteakäu, émpë ä átteak, éntok juka em átteakäu, ínapone két ä átteak; éntokne áme béchïbo úttilhuak. ");
INSERT INTO mfy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Ínapone kaa ím ániapo tahuanake; të ímëi ál‑la ím ániapo taahua; ínapo éntokne emou huéiye. In Átchay, empo tühuay tápuni. Jume nee enchi mák‑rim, em úttearaë am ëeria, bempörim náu huépülaitunakë béchïbo, itom náu huépülaitukä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ínapone em téhuam úttiarimmey am suayak, ímï ániapo ámemak aneka. Huame em nee mákakäune suayak, éntok kaabe áu täruk, hua áu ä tärunakë béchïbo usiari jíbba, juka jïojterita át chúpnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Tëne én emou huéenake; éntokne junëli nooka, ím ániapo aneka, juka ín al‑leeri bempörimmet yúmalasi ayunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ínapo huaka em noki ámeu nok‑la; éntok jume ím ániapo aneme am omtia, bempörim kaa ím ániapo jometukä béchïbo, bueïtuk ínapo két kaa ím ániapo joome. ");
INSERT INTO mfy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kanne ímï ániapo enchi yeu am huéria ïaaka nooka, ál‑la juënaraata bétana enchi am suaya ïaaka. ");
INSERT INTO mfy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Katim ím ániapo joome, ín kaa ím ániapo jometukä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Santosë am jíapsitua, em noki; tua lútüria. ");
INSERT INTO mfy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ím ániau em nee bíttuakä bénasi, ínapone két áman am bíttua, jume ániat jiápsammehui. ");
INSERT INTO mfy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ínapone bempörim béchïbo santosi jiápsa, bempörim lútüriapo santosi am jíapsinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Kanne ímëi béchïbo jíba nooka, ál‑la bempörim nokay, nee súalnakeme béchïbo kétchi, ");
INSERT INTO mfy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","sïmem náu huépülatunakë béchïbo, itom náu huépülatukä bénasi. Empo, ín Átchay, ínochi, ínapo éntok émochi; junëlim két itomak huépülatunake, jume ím ániapo aneme ä súalnakë béchïbo, enchi nee äbo bíttuakä bétana. ");
INSERT INTO mfy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Huaka loriata em nee mákakäu, ínapone két am mákkak, bempörim náu huépülatunakë béchïbo, itom náu huépülatukä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ínapo ámechi, empo éntok ínochi, bempörim yúmalasi huépülatunakë béchïbo, jume ím ániapo aneme jüneenakë béchïbo, enchi nee äbo bíttuakä bétana, éntok enchi am nákekähui, em nee nákekä bénasi. ");
INSERT INTO mfy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’In Átchay, jume em nee mákakäune ín anëpo két ínomak am an-ïa, huaka loriata em nee mákakäu am bínnakë béchïbo; bueïtukë nee nákkek, béja ketune juka ániata kee jee yáahuay naateka. ");
INSERT INTO mfy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Lútula huëpo Achayhuari, huame ím ániapo joome katim enchi täyala, të ínapo enchi täyala. Ímëi éntok jüneiya em nee äbo bíttuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Éntokne em téhuam am täyatuala enchi jabétukähui, éntokne jíba am täyatebonake, bueïtuk jü em nee nákekau ámet am ayunakë béchïbo, ínapo éntok ámechi. ");
INSERT INTO mfy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús íkäi noksuka yeu siika, ä discíipulommaki, áman jakia Cedrón ti téhuaakau huáytana bíchaa, huam huertata órekaïpo; huämi kibakek ä discíipulommaki. ");
INSERT INTO mfy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Éntok Judas kétchi, huatem mampo ä toijnakëïhui, áma täyay, bueïtuk Jesús juebénasi ä discíipulommak ámam náu yayajay. ");
INSERT INTO mfy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Huanäi Judas áman yepsak, juebena sontarom huériaka, éntok tiöpopo alguacil tékilta joame. Jume pariseerom éntok tiöpopo chë nésahueme áman am bíttualatukay. Machiriaka, kúkutaka, éntok esparakam áman yájjak. ");
INSERT INTO mfy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Të Jesús, sïmeta juka áu huéenakemta jüneriaka, bát ámeu yeu kíkteka, ínel ámeu jiaahua: —¿Jábetasem jaria? ");
INSERT INTO mfy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Huanärim ínel ä yómmiak: —Juka Jesús Nazarenota. Jesús éntok ínel ámeu jiaahua: —Ínapone ájäria. Judas éntok ámemak huéiyey, hua bem mámpo ä tóijnakeme. ");
INSERT INTO mfy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ínapone ájäria” tä jiay, amayim sájaka buíapo huáttek. ");
INSERT INTO mfy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús júchi éntok am natemajek: —¿Jábetasem jaria? Bempo éntok ínel ä yómmiak: —Juka Jesús Nazarenota. ");
INSERT INTO mfy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Huanäi Jesús ínel am yómmiak: —Enchimne téjhuaasula ín ájäriatukähui. Nechem jariätek, ímërem tójja; éläpom sákanake. ");
INSERT INTO mfy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Íkäi nookak, huaka ä noki ä nokakäu chúpnakë béchïbo: “Huame em nee mákakäu, huépülak júnene kaa täruk.” ");
INSERT INTO mfy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Huanäi jü Símon Peero, ejparam yeu huíkeka, huaka tiöpopo chë nésahuemta sáhuëu bátatana náka chúkti mámäkok. Ïri éntok Malco ti téhuaakay. ");
INSERT INTO mfy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Huanäi Jesús Perotau ínel jiaahua: —Em ejparamë huaka bea bóosapo kibacha. Juka vaasota ín Áchay nee mákakäu, ¿jachune kaa ä jïnake jäni? ");
INSERT INTO mfy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Huanäi huame sontarom, jü tribuno yäura, éntok jume alguacilim sáhuëhui, Jesústam buíseka ä súmmak. ");
INSERT INTO mfy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Huanärim bát huëpo Anástau yeu ä tójjak; bueïtuk ikäri Caifás ä asëbuakay. Huäri huásuktiapo Caifás sumo sacerdotetukay. ");
INSERT INTO mfy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jü Caifás ínel jume judío yäuchimmeu nok‑latukay, huépul yoremta muknakeu türinake tíaka, jü pueblota béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Huanärim Jesústa sáu kaatey, jü Símon Peero éntok senu ä disciipulo. Íkäi disciipulota éntok sumo sacerdote ä täyay. Huanäi Jesústamak ä teebat jóapo kibakek; ");
INSERT INTO mfy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","të Peero éntok päkun puertata bía aaney. Huanäi jü disciipulo sumo sacerdoteta täyäu yeu siika. Huanäi huaka jámut puertata suayamtau nokaka, juka Perota áman kibaktuak. ");
INSERT INTO mfy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Huanäi jü puertata suayame Perotau ínel jiaahua: —¿Émpë két jü yoremta disciipulo? Huanäi áapo ä yómmiak: —Ëe, kanne ájäria. ");
INSERT INTO mfy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ámam jäbuekay, huame áma sáyhuame éntok huame alguacilim. Náalatakam súkkähuey, bueïtuk sébiakay. Peero éntok két ámemak áma huéeka súkkähuey. ");
INSERT INTO mfy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Huanäi jü sumo sacerdote Jesústa temajek, ä discíipulom bétana éntok jita am majtiähui. ");
INSERT INTO mfy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús éntok ínel ä yómmiak: —Ínapo sïmem jíkkajäpo huame géntemmeu nok‑la. Jíbane jum sinagogapo éntok tiöpopo am majtiala, jum sïme judíom náu yayájäpo. Kaitane éhuil nok‑la. ");
INSERT INTO mfy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Jatchiake nee temaje? Huame nokta jíkkaij‑lamë temaje jítasune ámeu nok‑la. Bempo jüneiya jita ín ámeu nok‑latukähui. ");
INSERT INTO mfy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Juka Jesústa ínëli nónokak, senu alguacil áma anëhui ä chóchonak, ínel jíaka: —¿Jachë ínel ä yómmia, juka sumo sacerdoteta? ");
INSERT INTO mfy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús éntok ínel ä yómmiak: —Kaa türik nee nónokak, nokäe, ¿jáksu kaa türi jü ín nokakähui? Të tühuata nee nokay, ¿jatchiake nee chónna? ");
INSERT INTO mfy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Huanäi Anás súmata, Caifás sumo sacerdotetau ä bíttuak. ");
INSERT INTO mfy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jü Peero tájimmeu huéeka súkkähuey, huanäi nátemaijhuak: —¿Jachë empo két ä discíipulommak huéiye? Huanäi áapo am yómmiak: —Ëe, kanne ájäria —tiahua. ");
INSERT INTO mfy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Senu éntok sumo sacerdoteta sáhuëu Perota náka chúktiakäu huahuaji ínel áu jiaahua: —¡Enchine bíchakam ténna, áman huertapo áamak enchi aneyo! ");
INSERT INTO mfy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peero éntok júchi kaa áu ä täya tíaka nookak. Huanäi sep jü totoröra kúkusek. ");
INSERT INTO mfy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesústam Caifásta jóapo yeu núk sájjak, palacio romaanou bíchaa. Ketune kethueytukay. Huanäi palaciohuim kaa kiímuk, bem jiöri bárë béchïbo, pájcua buähuamta buä báreka. ");
INSERT INTO mfy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Huanäi jü Pilaato ámeu yeu sika ínel ámeu jiaahua: —¿Jíta bétanasem ä nätua, íkä yoremta? ");
INSERT INTO mfy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Huanärim ínel ä yómmiak: —Íkä yoremta kaa juënak yáalatukte kaa em mámpo ä tóij éiyey. ");
INSERT INTO mfy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Huanäi jü Pilaato ínel ámeu jiaahua: —Emem ä huériaka, enchim ley nésahue páman ä yáuhua. Judíom éntok ínel ä yómmiak: —Ítapo kaita lútüriata mákki, jábeta itom mënakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Inëlim jiaahuak, Jesústa nokakäu chúpnakë béchïbo, am jünee ïaaka jáchin ä muknakëïhui. ");
INSERT INTO mfy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Huanäi jü Pilaato júchi palaciou kibakeka, Jesústa núnuka ínel áu jiaahua: —¿Jachë empo jume judíommeu Rey? ");
INSERT INTO mfy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús éntok ínel ä yómmiak: —¿Jachë empo em éäpo ínel jiaahua, o tattäbuika ino bétana ínel emou jiaula? ");
INSERT INTO mfy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaato éntok ínel ä yómmiak: —¿Jachu ínapo judío? Huame em pueblopo joome éntok huame sacerdotem chë nésahueme ín mámpo enchi tóij‑la. ¿Jítasë yáala? ");
INSERT INTO mfy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús ä yómmiak: —Jü reytaka ín nésahueu kaa ímï ániapo joome. Të reytaka ín nésahueu ímï ániapo jométuk, jume ín sáhuëu nássua éiyey, kaa judíom mámpo ín tóijna béchïbo. Të hua reytaka ín nésahueu kaa ímï joome. ");
INSERT INTO mfy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Huanäi jü Pilaato ínel áu jiaahua: —¿Huanäisu empo reytaka nésahue? Jesús éntok ínel ä yómmiak: —Empo reytaka nee nésahue tíiya. Ínapo íäri béchïbo yeu yoremtula, éntokne íäri béchïbo ím ániapo yebij‑la, lútüriata bétana ín noknakë béchïbo. Sïme huame lútüriat kateme ín nokim jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Huanäi Pilaato ínel áu jiaahua: —¿Jítasa jüri lútüria? Ínëli jiausuka júchi yeu siika, judíommehui. Huanäi ínel ámeu jiaahua: —Kaita kúlpata nee át téula. ");
INSERT INTO mfy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Të eme ínel ä boojoria, pájcuapo senuk ín búttianakëhui. ¿Jachem juka judíommeu Reyta nee búttia ïaa? ");
INSERT INTO mfy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Huanäi júchi bemélasi sïmetaka nónokak, ínel jíaka: —Júkäi ëe, Barrabásta ál‑la. Jü Barrabás éntok lak‑rontukay. ");
INSERT INTO mfy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Huanäi Pilaato, Jesústa nüka ä bépsutebok. ");
INSERT INTO mfy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jume sontarom éntok huíchata huiköpäaka, ä coroona yáaka, kóbat áachä yétchak. Huanärim lilata ä sánkotuak; ");
INSERT INTO mfy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","éntokim ä chónaka, ínel áu jiaahuay: —¡Jál-la maachi, judíommeu Rey! ");
INSERT INTO mfy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Huanäi Pilaato júchi yeu sika ínel ámeu jiaahua: —Áachem suuhua, enchimmeune yeu ä tójja, enchim jüneenakë béchïbo kaita juënak ín át teähui. ");
INSERT INTO mfy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Huanäi yeu siika jü Jesús, huíchata coroonaka éntok lilata sánkoka. Huanäi jü Pilaato ínel ámeu jiaahua: —¡Ímï huéiyek, ï oöou! ");
INSERT INTO mfy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Huanäi huame Sacerdotem chë nésahueme éntok áma alguacilim ä bíchaka, söti tëka, ínel jiaahua: —¡Kúrusichë ä popona! ¡Kúrusichë ä popona! Pilaato éntok ínel ámeu jiaahua: —Emem ä huériaka kúrusit ä popona, bueïtuk ínapo kaita kúlpata át téuhua. ");
INSERT INTO mfy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Huanäi jume judíom ínel ä yómmiak: —Ítapo senu leyta jípure, éntok jüri leyta jiäpo ámani, úttea ä muknakëhui, bueïtuk áapo áu Diosta Üusï tíiya. ");
INSERT INTO mfy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jü Pilaato íkäi jíkkajaka, chë júne máuj táytek. ");
INSERT INTO mfy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Huanäi júchi palaciou kibakeka, Jesústau ínel jiaahua: —¿Jákusë joome? Të Jesús kaa ä yómmiak. ");
INSERT INTO mfy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Huanäi jü Pilaato ínel áu jiaahua: —¿Jachë nee kaa yommiak? ¿Jachë kaa jüneiya yäurata ín jípurëhui, kúrusit ín enchi poponakë béchïbo, éntok enchi búttia béchïbo? ");
INSERT INTO mfy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús éntok ínel ä yómmiak: —Kaitë yäurata jípu éiyey nee béj‑reka, kaa jikat bétana ä máktuko. Júntuk hua em mámpo nee yéchakame chë júne Dios bejrim jípure. ");
INSERT INTO mfy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Huanäi naateka jü Pilaato ä búttia báreka éiyay. Të jume judíom jíba söti nokaka, ínel jiaahuay: —Íkäre búttiakätek, ¡kaa Césarta amigok! Huä jábe áu rey joame, Césarta béj‑rekam kaate. ");
INSERT INTO mfy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Huanäi jü Pilaato íkäi jíkkajaka, juka Jesústa päkun yeu núk sika, yäurata yeyesäpo yejtek, huam Enlosado ti téhuaakapo; yorem nokpo éntok téta chíbelay tíau báare. ");
INSERT INTO mfy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kabara jísobahuakä pajko buähuäu, senu taahuari áu bëyey. Huäri taahuarit lúl‑la kátekay. Huanäi judíommeu ínel jiaahua: —¡Ímï aane, jü enchimmeu rey! ");
INSERT INTO mfy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Të bempo chayeka ínel jiaahuay: —¡Yehuë ä huéria! ¡Yehuë ä huéria! ¡Kúrusichë ä popontebo! Pilaato éntok ínel am yómmiak: —¿Jachem juka enchim rey kúrusit nee popon ïaa? Huanäi jume sacerdotem nésahueme ínel ä yómmiak: —Kaabetate éntok reyek, ¡Césarta jíbba! ");
INSERT INTO mfy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Huanäi bem mámpo ä tójjak, kúrusichä poponnä béchïbo. Huanärim Jesústa núk sájjak. ");
INSERT INTO mfy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús éntok ä kúruj püakteaka yeu siika, Calaverau bíchaa, hebreo nokpo éntok Gólgota. (Yorem nokpo éntok mukila kóba káuhui tíau báare.) ");
INSERT INTO mfy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Huämïrim kúrusit ä poponak, éntok guoyim áamaki; huépülaka míkötana, senu éntok bátatana, Jesús éntok áme násuku. ");
INSERT INTO mfy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Huanäi Pilaato titulo jïojteta yáaka, kúrusit ä yétchak; huäri jïojteri ínel jiaahuay: “Jesús Nazareno, judíommeu Rey.” ");
INSERT INTO mfy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Huanäi juebena judíom íkäi jïojteta nokak, bueïtuk jum Jesústa kúrusit poponhuakapo buere jóära kaa mékka taahuay. Huäri jïojteri éntok, hebreo nokpo éntok griego nokpo éntok latín nokpo jïojtetukay. ");
INSERT INTO mfy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Huanäi jume sacerdote judíom chë nésahueme Pilaatotau ínel jiaahua: —Judíommeu Rey të kaa ä jïojte; ál‑lë ínel ä jïojte: “Áapo judíommeu áu Rey tíiya.” ");
INSERT INTO mfy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaato éntok ínel am yómmiak: —Huä ín jïojtekähui, béja jïojteri. ");
INSERT INTO mfy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Huanäi jume sontarom juka Jesústa kúrusit poponsuka ä sánkohuam nüka, naikisim ä chúktiaka, náchä näikimtek. Juka béppa sánkota éntokim nüka. Huäri éntok kaa náu jïiktukay; senu huëpo sïme náu jíjjoatukay, jikat naateka kóm tájti. ");
INSERT INTO mfy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Huanärim ínel náu jiaahua: —Katta näikimtenake, ál‑late náu ä jätenake; jábe tua áamak tahuanake. Ïri ínëli siika, juka Diosta noki jïojteri chúpnakë béchïbo, ínel jíamta: “Juka ín huáijhua súpem nat näikimtek, éntok ín béppa súpem éntokim náu jätek.” Júnëlim ä yáuhuak, jume sontarom. ");
INSERT INTO mfy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesústa kúruj náapo ä áyehua áma huéekay, éntok ä áyehua ákoro, éntok jü María Cleofasta juubi, éntok María Magdalena. ");
INSERT INTO mfy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Huanäi jü Jesús, ä áiye bíchaka éntok ä disciipulo chë ä nákëu két áma anemta, ä áyebeu ínel jiaahua: —Empo, jámmut, júmü aane jü em ásoa. ");
INSERT INTO mfy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chúkula ä disciipulobeu éntok ínel jiaahua: —Júmü aane jü em áiye. Huäri taahuarit naateka jü disciipulo ä jóapo ä mabetak. ");
INSERT INTO mfy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chúkula íkäi simsukäpo, jü Jesús, jünéaka sïmeta chúpilatukähui, ínel jiaahuak, juka Diosta noki jïojteri chúpnakë béchïbo: —Bäi mukene. ");
INSERT INTO mfy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vaaso vinagrey tápunika áma mánekay. Huanäi bempo vinagrepo esponjata kómoniaka, kútachä súmaka tempä óreriak. ");
INSERT INTO mfy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús, juka vinagreta jïsuka, ínel jiaahua: —Béja chúppuk. Huanäi kóm kóbateka muukuk. ");
INSERT INTO mfy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pájcuata béchïbo jita nau toijhuayo senu taahuarita bëye béchïbo, huanäi jume judíom jimyore táapo jume kókkolam takahuam kaa kúrusimet am tahua ïaaka, bueïtuk ïri taahuari tüisi yörisi machiakay. Huäri béchïbom Pilaatotau kimuka áu nookak, guók óttam am kóttiria ïaaka, kóm am jóanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Huanäi jume sontarom áman yájaka, huépülak bát guók kóttiak, alë bénasi huaka senuk két áamak kúrusit poponta. ");
INSERT INTO mfy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Huanärim Jesústau yájaka béja ä mukilatukäu ä bíchaka, katim ä guók kóttiak. ");
INSERT INTO mfy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Të senu sontaro ä lansammea sánä chákäku naa búrujti ä sóiyak. Huanäi sep ójbo át yeu búitek, éntok bäam. ");
INSERT INTO mfy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ä bíchakame íkäi nooka; ä nokäu éntok lútüria. Áapo éntok jüneiya lútüriata áu nokähui, enchim két ä súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bueïtuk ínëli yeu siika, juka Diosta noki jïojteri chúpnakë béchïbo, ínel jíamta: “Kaita ä ótahuam kóttiatunake.” ");
INSERT INTO mfy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Éntok két täbui jïojteri ínel jiaahua: “Akim ä bínnake, huaka naa búrujti lansammea sóata.” ");
INSERT INTO mfy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chúkula sïmeta íkäi simsuko, José Arimatea pueblopo joome, éhuil Jesústa disciipulotukay jume judíom májhueka, Pilaatotau nookak licensiata áu aahuakä, juka Jesústa takaahua núk sim báreka. Pilaato éntok ä licensiak. Huanäi ä núk siika, juka Jesústa takaahua. ");
INSERT INTO mfy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jü Nicodemo, hua bannaataka Jesústau tukaapo nóitekaïhui, két áma yepsak, juka mirra éntok áloe náu kütilata huériaka, batte cuarenta kilotukay. ");
INSERT INTO mfy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Huanärim Jesústa takaahua nüka, sábanampo áa bïtiak perfumeta át huáttiaka, jume judíom kókkolam mamähua, bem ä boojoria pámani. ");
INSERT INTO mfy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Huerta áma órekay, jum kúrusit ä poponhuakapo. Ímï éntok ánimata mäa béchïbo guójöria bemelataka áma buéijtukay; huämïri kaabe jee mäahuay. ");
INSERT INTO mfy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Imïri judíom pájcua yabahuakä jita nau toijhua béchïbo, éntok juka ánimam mamähuäpo kaa mékka óreka béchïbo, Jesústam huämi mäak. ");
INSERT INTO mfy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Júnakoy lominko táapo, jü María Magdalena kethueysu ánimam mamähuäu bíchaa siika, ketune ili kútkuako; huanäi juka tétata áy ä páttiari mékka bíaktiata bitchak. ");
INSERT INTO mfy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Huanäi búiteka ámeu yepsak Símon Perotahui, éntok huä disciipulo Jesústa nakëibehui. Huanäi ínel ámeu jiaahua: —Juka Señortam jum ánimam mamähuäpo yeu núk sákala, éntokte kaa jüneiya jákun ä tóijhuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Huanärim ánimam mamähuäu bíchaa sájjak, jü Peero éntok jü senu disciipulo. ");
INSERT INTO mfy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Náhuim teenney, të jü senu disciipulo chë úttia búitek Perota béppa; huanäi áapo bát áman yepsak. ");
INSERT INTO mfy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Huanäi áman kóm sika, jume sábanam áma órekame bitchak, të kaa tua huáijhua kibakek. ");
INSERT INTO mfy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Huanäi Símon Peero áa sáu áman yepsak. Huanäi ánimam mamähuäpo guójöriau kibakeka, jume sábanam áma órekame bitchak; ");
INSERT INTO mfy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","éntok jume sánkom Jesústa kóbat ámey bítiatukaïhui. Ímëi kaa sábanammak órekay, ál‑lam náu tóttiataka sékäna órekay. ");
INSERT INTO mfy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Huanäi hua senu disciipulo két áman kibakek, huam ánimam mamähuäu bát yepsakame. Ïri Jesústa jiabitekau bíchaka, huanäi ä súsuaalek. ");
INSERT INTO mfy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Të jïojteritachim kee jee jüneiyay, kókkolam násuk ä jíabitenakeu úttiatukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Huanäi jume discíipulom nóttek, huame ámemak anemmehui. ");
INSERT INTO mfy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Të María, kókkolam mamähuäpo päku aneka, buaanay. Huanäi buanakasu kóm reemtek, ánimam mamähuäu guójöriau bít báreka. ");
INSERT INTO mfy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Huanäi guoy ángelesim totösalik sánkoka áma jokame bitchak, seenuk ä kóbaka bökai bétana, seenu éntok ä guókeka bökai bétana, huam Jesústa takaahua tektukaïpo. ");
INSERT INTO mfy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Huanärim ínel áu jiaahua: —Empo jámmut, ¿jatchiakasë buaana? Áapo éntok ínel am yómmiak: —In Señortam núk sájjak; én éntokne kaa jüneiya jákun ä tóijhuakähui. ");
INSERT INTO mfy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ínëli jiausuka, kúakteka Jesústa áma anemta bitchak; të kaa jüneiyay ä Jesústukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús ínel áu jiaahua: —Empo jámmut, ¿jatchiakasë buaana? ¿Jábetasë jaria? Áapo éntok, jü huertata suayame jäni tí eäka, ínel áu jiaahua: —Señor, empo ä núk simlatuk, nechë téjhua jákun em ä tóij‑latukähui. Ínapone áman ä nüka ä núk sim báare. ");
INSERT INTO mfy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús éntok ínel áu jiaahua: —¡María! Áapo éntok kúakteka ínel áu jiaahua: —¡Raboni! —Maestro tiau báare. ");
INSERT INTO mfy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús éntok ínel áu jiaahua: —Katë ínot mámma, bueïtuk ketunene kee ín Áchaybeu jikau siime. Të jume ín sailammehuë sika am téjhua: “In Áchaybeu éntok enchim Áchaybeune jikau huée báare, ín Diostahui éntok enchim Diostahui.” ");
INSERT INTO mfy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Huanäi María Magdalena áman siika, jume discíipulommehui, juka nokta ámeu huériaka Señorta ä bil-latukä bétana, éntok áapörik, Señorta, ínel áu jíakähui. ");
INSERT INTO mfy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Huanäi huäri lominko taahuarit tukariu yúmay, jume discíipulom judíom májhueka náu rúktilatakam puertam páttialatukay. Huanäi Jesús ámeu yeu machiak. Huanäi áme násuk kíkteka, ínel ámeu jiaahuak: —Yánti ehuame enchimmaktunake. ");
INSERT INTO mfy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ámeu tebotesuka, mámam am bíttuak, éntok sánärim lansammey ä sóahuakäpo. Huanäi jume ä discíipulom tüisi al‑lëiak, juka Señorta bíchaka. ");
INSERT INTO mfy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Huanäi Jesús júchi ínel ámeu jiaahua: —Yánti ehuame enchimmaktunake. Juka ín Áchay nee äbo bíttuakä bénasi, ínapone két enchim áman bíttua. ");
INSERT INTO mfy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Íkäi noksuka am pujtiaka, ínel ámeu jiaahua: —Espíritu Santotem mabeta. ");
INSERT INTO mfy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Huame jábem Dios bejri béchïbo enchim jiokorekäu jiokoritunakemme; huame jábem Dios bejrim béchïbo enchim kaa jiokorekäu, katim jiokoritunake. ");
INSERT INTO mfy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Të jü Toomas, doocemmak näikiatukaïhui, Guoguörï tíame, kaa ámemak aaney, Jesústa ámeu yeu machiako. ");
INSERT INTO mfy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Huanäi huame huate discíipulom ínel áu jiaahua: —Juka Señortate bitchak. Áapo éntok ínel ámeu jiaahua: —Kanne jum mámpo laavosim át jäbuekaïpo señam bichätek, éntok kaa huam laavosim át jäbuekaïpo át sútutek, éntok huam sánärim chákäku lansammey ä sóapo kaa át mámtekateko kaibune ä súalnake. ");
INSERT INTO mfy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chúkula guoj naiki taahuarim huéy áma huáijhuam aaney, Toomas éntok ámemaki. Huanäi Jesús áma yepsak, jume puertam éntok páttiatukay. Huanäi áme násuk kíkteka ínel ámeu jiaahua: —Yánti ehuame enchimmaktunake. ");
INSERT INTO mfy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Huanäi Tomastau ínel jiaahua: —Ímïre ínot sútute, éntoke ín mámam bitcha; éntoke ínot mámte ín sánärim lansammey sóapo. Katë kaita súalëra. ¡Nechë súale! ");
INSERT INTO mfy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Huanäi Toomas ínel ä yómmiak: —¡In Señor, éntok ín Dios! ");
INSERT INTO mfy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús éntok ínel áu jiaahua: —Toomas, em nee bíchakä béchïbë nee súale. ¡Diosta tü erimmeyim tápuni, huame kaa nee bíchaka nee súaleme! ");
INSERT INTO mfy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús juebena señaalim yáuhuak, chë ímëi béppa, jume ä discíipulom bíchäpo; huámëi éntok katim ímï libropo jïojteri. ");
INSERT INTO mfy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Të ímëi jïojtehuak enchim ä súalnakë béchïbo, juka Jesústa Cristotukähui, hua Diosta Üusi, bueïtuk ä súaleka enchim jíapsinakë béchïbo, áapörik téhuampo. ");
INSERT INTO mfy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chúkula Jesús júchi ä discíipulommeu áu yeu machiriak, Tiberia bahue mayoachi. Ínëli yeu siika: ");
INSERT INTO mfy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Náhuim aaney, jü Símon Peero, Toomas jü Guoguörï tíame, Natanael pueblo Caná Galiléa buiärapo joome, jume Zebedeota üusim, éntok huate guoyika ä disciipulohuam. ");
INSERT INTO mfy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Símon Peero ínel ámeu jiaahua: —Kúchumne buíj báare. Bempo éntok ínel ä yómmiak: —Ítapo két émomak kat báare. Huanärim canoapo jämuka sájjak. Të huäri tukaarit kaitam buíssek. ");
INSERT INTO mfy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Béja matchuu bíchaa, Jesús ámeu yepsak, jum bahue mayoachi. Ä disciipulohuam éntok kaa ä täyay, ä Jesústukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Huanäi ínel ámeu jiaahua: —Uusim, ¿jachem jita jípure buä mátchik? —Ëe —tim áu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Huanäi ínel ámeu jiaahua: —Canoata báta bétanem jítërim jímma; huanärem kúchum buíjnake. Huanärim áman am jímmaaka, kara yeu am huíkkey, yún kúchum bem játiakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Huanäi hua disciipulo Jesústa nákeïhui, Perotau ínel jiaahua: —¡Jü Señor! Símon Peero, Señorta jíay ä jíkkajaka, ä sánkohua huikojtek, bueïtuk áu ä úhuaalatukay. Huanäi bäau áu jímmak. ");
INSERT INTO mfy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Huanäi jume huate discíipulom canoamak yeu yájjak, jítërim kúchummea tápunik huík sákaka; bueïtuk kaa mékkatukay jum bahue mayoahui, jíba tua cien meetrotukay. ");
INSERT INTO mfy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Buíahuim kóm chépteka óbam téuhuak, éntok huépü kúchuta áma béppa tekta, éntok páanim áma órekame. ");
INSERT INTO mfy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Huanäi Jesús ínel ámeu jiaahua: —Jume kúchum enchim buísekähuem äbo huéria. ");
INSERT INTO mfy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Huanäi jü Símon Peero áma jämuka jume jítërim buíau yeu huíkkek, ciento cincuenta áma báij buere kúchummaki; të am juebenamtuk junne, jume jítërim kaa síutek. ");
INSERT INTO mfy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Huanäi Jesús ínel ámeu jiaahua: —Äbem sájaka jïbuä. Jume discíipulom bem át guómtia béchïbo, kaabe ä temajek ä jábétukaïhui, jünéaka ä Señortukaïhui. ");
INSERT INTO mfy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Huanäi Jesús áman sika jume páanim nüka am miikak. Alë bénasi kúchuta kétchi. ");
INSERT INTO mfy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ïri béja jü bájikuntuka huéiyey, juka Jesústa ä discíipulommeu áu yeu ä machiriähui, kókkolam násuk jíabitesulataka. ");
INSERT INTO mfy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Huanäi jïbuäsukam jü Jesús Símon Perotau ínel jiaahua: —Símon, Jonásta üusi, ¿jache empo chë nee nákke, ímëi béppa? Huanäi ínel ä yómmiak: —Jeehui, Señor; émpë jüneiya enchi ín nákëhui. Jesús éntok ínel áu jiaahua: —In kabaramë suaya. ");
INSERT INTO mfy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Júchi éntok guosa huëpo ínel áu jiaahua: —Símon, Jonásta üusi, ¿jache nee nákke? Peero éntok ínel ä yómmiak: —Jeehui, Señor, empo jüneiya nee enchi nákëhui. Huanäi ínel áu jiaahua: —In kabaramë suaya. ");
INSERT INTO mfy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bájikun huëpo ínel áu jiaahua: —Símon, Jonásta üusi, ¿jache nee nákke? Huanäi jü Peero kaa al‑lëiak, báisi junëli áu ä jíakä béchïbo. Huanäi ínel ä yómmiak: —Señor, émpë sïmeta jüneria; émpë jüneiya enchi ín nákëhui. Jesús éntok ínel áu jiaahua: —In kabaramë suaya. ");
INSERT INTO mfy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tua lútüriapone ínel emou jiaahua: Jübua yötuke empo emo sásankotuay, éntoke em huée bárëu bíchaa sisimey; të béja ölatuka, em mámamë rutuktianake, éntok täbuika enchi sánkotuanake, éntok kaa em huée bárëu bíchaa enchi huériunake. ");
INSERT INTO mfy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ínëli nokaka ä jüneetebok, jáchin mukuka Diosta ä úttilnakëïhui. Íkäi noksuka ínel jiaahua: —¡Ino sáukë huéiye! ");
INSERT INTO mfy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jü Peero, amáu remteka, juka disciipulota Jesústa chë nákëu bitchak, áme sáu huémta, hua áman tukaapo jïbuähuay át huijjüteka kátekäihui, ínel áu jíakäihui: “Señor, ¿jábesu hua enchi nénkinakeme?” ");
INSERT INTO mfy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peero ä bíchaka Jesústau ínel jiaahua: —Señor, ¿ïsu? ¿Jítasu áu huéenake jäni? ");
INSERT INTO mfy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús éntok ínel ä yómmiak: —Ínapo ínel éätek, áapörik tahuanakeu júchi ín yepsäu tájti, ¿jitasë áma täru? Émpë ino sáu huéiye. ");
INSERT INTO mfy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Huanäi ïri noki chíbejtek jume hermaanom násuku, huákäi disciipulota kaa muknakëïhui. Të Jesús kaa junëli jiau báarey jiöbe, ál‑la ínel jiaahuak: “Ínapo ínel éätek áapörik tahuanakeu júchi ín yepsäu tájti, ¿jítasë áma täru?” ");
INSERT INTO mfy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ïri ájäria jü disciipulo íäri bétana nokakame, éntok íäri bétana jïojtekame; éntokte jüneiya, ä nokihua lútüriatukähui. ");
INSERT INTO mfy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús huatek juebenak yáuhuak. Huámëi hueuhuëpulaka nátepua jïojtetukätek, ínenne éiya, jamak ím ániapo júnem kaa beeki éiyey, huame librom jïojterim. Júnentunake.");
INSERT INTO mfy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Empo Teófilo, huam bat ín emou jïojtekäpone sïmeta jïojtek, ínapo jü Lucas, juka Jesústa yáakähui éntok yore ä majtiakähui, ä tékil ä naatekäpo naateka, ");
INSERT INTO mfy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","téhuekau ä sikäpo tajti. Kee jee téhuekau huéeka jü Espíritu Santota úttiäray jume apóstolim yéu ä púakäu tüisi téjhuak jita bem yáanakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mukuka, chúkula jiápsaka ámeu au yeu machiriak. Jum cuarenta taahuarimpo núkisi machisi ámeu au yeu machiriak, am jünee ïaaka ä jiapsä bétana, éntok Diosta nésauhuë bétana ámeu nokaka. ");
INSERT INTO mfy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ketune jume apóstolimmak aneka, Jesús bempörim, jume apóstolim, téjhuak kaa jum buere joära Jerusalémpo yéu am katchahueka. Ínel ámeu jiaahua: —Jukem ín Átchay enchim téjhuari boobíchaïhui, huaka áa bétana ín enchimmeu nokakähui. ");
INSERT INTO mfy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Lútula huëpo Juan bäammea yore batöak, të chúkula kaa jaiki taahuarim huei Dios täbuiasi enchim batönake, jü Espíritu Santoyi. ");
INSERT INTO mfy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesústahuim nau yájaka ínel au jiaahua: —Señor, ¿jatchë én juka Israelta yäura bannaataka bénasi tahuárianake jäni? ");
INSERT INTO mfy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Huanäi Jesús ínel am yómmiak: —Kaa enchimmeu chäka enchim ä jünérianakëhui juka jauhuey Dios Áchayta jita yáanakëhui, huaka áapörik jíba jüneriähui. ");
INSERT INTO mfy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Të juka Espíritu Santota enchimmeu kom yumáko útteatem jípunake, huanärem yeu sájaka huaka ín yáari enchim bíchakäu jume géntemmeu noknake jum buere joära Jerusalémpo, éntok sïme Judea buíaräpo éntok Samária buíaräpo, éntok jakum buíata yumäu tajti junne. ");
INSERT INTO mfy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ínëli jiáusuka, bempörim ä bíchaisu, Jesús téhuekau jikáu siika. Huanäi jü namú au yúmaka ä páttiak. Huanärim kaa júchi ä bitchak. ");
INSERT INTO mfy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bempörim téhuekau puseka Jesústa am bíchaisu, guoi yorémem totösalik sánkoka áme náapo yeu machíak. ");
INSERT INTO mfy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Huanärim jume apóstolimmeu ínel jiaahua: —Eme oóhuim Galiléapo joome, ¿jatchiakem huépüsi téhuekau bitcha? Ïri Jesús enchim násuk téhuekau jikau sikame júchi äbo kom yebijnake jikau ä huey enchim ä bíchakäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Huanärim jü kauhui Oliivo téamtat kóm sájaka buere joära Jerusaléniu bíchaa nóttek. Kaa tua mekka, senu kilometrotu máchiakay, jimyore táapo rerejtihua bëmutukay jíbba. ");
INSERT INTO mfy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Huanärim jum pueblou yájaka, jü kari nat béppa jokäpo jikat kiímuk, huam jíba bem anéïpo. Jume áma nau anéïhuim: Jü Peero, éntok Jacobo, Juan, Andrés, Felipe, Toomas, Bartolomé, Mateo, Jacobo Alféota üusi, Simmom jü cananístammak huéeme, éntok Judas Jakóbotamak huéeri. ");
INSERT INTO mfy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sïme ímëi éntok Jesústa saílam, éntok ä áyehua María, éntok huate jaámuchim, áma nau yayajai oraciompo Diostau nok báreka. ");
INSERT INTO mfy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Huámechi taahuarimmet jum Jesucristota súalhuäpo nau huéerim jíbatuam ciento veintetukay, jume áma náu aneïhui; jü Peero áme násuk kíkteka ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Eme ín hermaanom, tua útteatukay huaka bannaataka Espíritu Santota noki jïojteta chúpnakëhui, huaka Davidta ä noktuakähui Judasta bétana, hua Jesústa pereesotekame am aniakame. ");
INSERT INTO mfy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Bueïtuk ï Judas itomak näikiatukai, éntok tékiata itomak jípurei jiöbe, ");
INSERT INTO mfy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","të áapo yeu siika. Huanäi hua tomi juënak yáaka ái ä béjtuahuakäubei buía jínnuhuak. Huanäi chúkula au cháiyak. Áu cháaka éntok, sihua pejti kón huétchek. ");
INSERT INTO mfy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Huame Jerusalémpo joome íkäi jüneriaka, juka buíata jínnuhuakamta bem nokpo Acéldama ti téhuaatuak, jü buía ójbota béjhuai jínnuri tiau báare. ");
INSERT INTO mfy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kíalïku jü Espíritu Santo juka Davidta ínel jïojtetuak jum libro Salmompo: Éläpo jü ä jóuhua jímmaatunake; kaabe éntok áma jóanake. Éntok ket ínel jiaahua: Éläpo täbuika juka ä tékia mabetnake. ");
INSERT INTO mfy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Úttea senuk itom yeu púanakëhui itomak ä tékianakë béchïbo, Jesústa jíabitekä bétana ä noknakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jü tahuari Juanta ä batöakäpo naateka téhuekau ä sikäpo tajti huepülaka itomaktunake, Jesústa kókkolam násuk ä jiabitekäu bíchakame. ");
INSERT INTO mfy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Huanärim áme násuk guoyim yeu púuhuak: Juka Matíasta, éntok José Barsabasta, Justo titéhuaakamta. ");
INSERT INTO mfy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Huanärim oraciompo Diostau nookak: —Señor, empo sïme yorémem jíapsi jünériame, itómë tejhua ímëi guoyim násuku jábetasë yeu púala, ");
INSERT INTO mfy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","huaka apóstolta tekia ä jonákë béchïbo Judasta tärukähui, bueïtuk áapo Diosta áa yáaka béchïbo ä näikiariu bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Huanärim am sortiaroahuak, Matiastat huétchek, jü tékia. Huanäi naateka huame once apóstolimmak näikiahuak. ");
INSERT INTO mfy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juka Pentecostés pajkota yumáko, sïme jume Jesuristota súaleme náu lópola aaney; nánancha éaka. ");
INSERT INTO mfy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Huanäi jíahui tehueka bétana jíkkaijtuk, jekata úttea huë bénasi jíaka. Huanäi jü káari bem anéïpo jíahuiy tápunak. ");
INSERT INTO mfy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Huanäi jume nínnim bénaka éntok taij rupáktiriata bénaka ámeu yeu machíak, huepülaka sïmem bëkatana emo näikimtelataka. ");
INSERT INTO mfy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Huanäi sïme Espíritu Santoy tapunak, éntokim täbui nokpo noktáitek jum Espíritu Santota am noktúä pámani. ");
INSERT INTO mfy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Huámechi taáhuarimmet jum buere joära Jerusalémpo judíom aaney, Diosta nésahui joame, sïme ániat bétana áma yáij‑lataka. ");
INSERT INTO mfy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Huaka jíahuita kusisi jíamta jíkkajaka jü génte nau rúktek. Huanärim büruk eiyai, bueïtukim huëpulaim bem noki am nokái am jíkkajai ");
INSERT INTO mfy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","áachim guómtilataka tahuaka ínel nau jiaka: —Jachum kaa Galiléapo joome sïme imï nokame, ");
INSERT INTO mfy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿jáchisu júntukim huepülaka itom yoiyöhuam nokpo nooka? ");
INSERT INTO mfy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ímim ito násuk aane jume géntem Pártiapo joome, Médiapo, Elampo, Mesopotámiapo, Judea bétana, Capadocia bétana, Ponto bétana, éntok Asia buiära bétana, ");
INSERT INTO mfy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia bétana, Panfilia bétana, Egipto bétana, éntok África buíaräpo Cirene pueblo chíkola joómem. Romáanom júne im aane im jóakame. Huate tua judíomtaka im aane, huate éntok, kia bem boojóriäpo ámemak kimúlamtaka. ");
INSERT INTO mfy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Huate ket Creta bétana im aane, éntok buiära Arabia bétana. Të sïmete tua itom nokpo juka kaa jaibu johuamta Diosta yáari bétana nokame jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sïme at guómtilataka kaachin anmáchiakai. Huanärim nau emo nátemaje: —¿Jítatu báaresa jäni ïri? ");
INSERT INTO mfy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Huate éntok, am junnériaka ínel jiaahua: —Bempo kíalim naakolam. ");
INSERT INTO mfy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Huanäi jü Peero kíktek, jume once apóstolimmaki. Huanäi kusisi jume géntemmeu ínel jiaahua: —Eme oóhuim Judéapo joome éntok sïme buere joära Jerusalémpo jóakame, íkärem jüneria, éntokem tüisi ä jíkkaja íka ín enchimmeu nokbárëhui. ");
INSERT INTO mfy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ímëi oóhuim katim naakolam enchim am ériä bénasi, bueïtuk kethuéeyo, én jübua jamak bátanim jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ï enchim jíkkajäu júnen hua profeta Joelta nokákähui ínel jíame: ");
INSERT INTO mfy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jume taahuarim lüteyo, tiahua jü Dios, juka ín Espíritune sïme yorémemmet chibejtianake. Huanäi jume enchim üusim éntok enchim mälam juka ín Espíritu am noktúähuim noknake, jume jübua yoyötume éntok, tenkumta bénasi éaka Diosta bétana huemta bínnake. Jume öolamm entok tenkunake. ");
INSERT INTO mfy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tua lútüriapo huámechi taáhuarimmetne ín sáuhuëhuimmet ohuim entok jamuchimmet ín Espíritu amet chibejtianake, huanärim juka ín Espírituta am noktúäu noknake. ");
INSERT INTO mfy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Áman téhuekapone at guómtisi machik yeu machírianake, imï buíapo éntokne ímëi señaalim ayutuanake: ójbo, tajji éntok buichía jaahua. ");
INSERT INTO mfy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jü täa kaa machisi tahuanake, jü mecha éntok, ójbota bénasi síkilisi, kee juka täahuata yúmayo juka Señorta, buéresi ujyorisi yepsayo. ");
INSERT INTO mfy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Huanäi sïme huame Señorta téhuam yöreka am tehuame jínëutunake. ");
INSERT INTO mfy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Júntukem ikäy nokta jíkkaja eme oóhuim Israelíitam, Dios juka Jesús Nazarenotat enchim tayatuak, buéresi at guómtisi machik señayáalim yakari áapörik huämi. Bueïtuk ä kókkohuame kara jíbba ä úttiäray bétuk ä jípurey. ");
INSERT INTO mfy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Júnentaka junne huam Diosta bannaataka áachä jünaktekäpo áman enchim mampo ä tóijhuak, eme ä pereesoteka jujjuëna yóremem mampo ä yétchak, kúrusit ä poponaka bem ä mënakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Të Dios júchi ä jíabitetuak, hua kókkohuamta útteara bétana áma ä yorétuaka, bueïtuk hua kókkohuame kara jíba ä útteara bétuk ä jípurei. ");
INSERT INTO mfy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Bueïtuk David Jesústa bétana nokaka ínel jiaahua: Ínapone jíba juka Señorta bitchay ínomak anemta. Bueïtuk áapo ínomak ín báta bétana ínomak aane, kayta ára nee tatabnake. ");
INSERT INTO mfy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kíalïkune tüisi jiápsipo al‑leaka tahuak ín ninï junne ál‑leaka nooka. Éntokne kaítat jachin eiya ín takahua muknakey junne át boobíchaka, ");
INSERT INTO mfy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","bueïtuk empo ín jíapsi kaibu huam kókkolam násuk tahuárianake, éntoke hua em nákëu santosi au nükamta takahua kaybu nasóntunake. ");
INSERT INTO mfy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Empo nee téjhuak jachin ayuka ín yu jíapsinakëhui, éntoke buéresi nee al-leetuanake ínomak aneka. ");
INSERT INTO mfy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Eme ínomak huéerim, tua machisi jüneriahua juka itom yoyöhua Davidta mukilatukähui bóoveda ketune ímï buíapo óorek. ");
INSERT INTO mfy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Të jü David profeetatukay; kíalïku jüneiyai juka Diosta au ä nätuakähui éntok ä lútüria yáakähui senuk áapörikut yeu simriata Cristotunakëhui, ä nésauhuëpo ä nésaunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kíalïku jü David profetataka chë bannaataka ä bil-lataka juka Crístota jíabitenake bétana nookak, entok huaka ä jíapsihua kaa kókkolam násuk tahuánake bétana, entok ä takahua júne kaa nasontunake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Júnëli jü Dios íkäi Jesústa jíabitetuak, éntok íäri bétana sïme ítapo testiigom. ");
INSERT INTO mfy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios ä báta bétana ä yétchak yörisi machiku. Huanäi juka Espíritu Santota mabétaka, huaka Dios Áchaita nätuari, áapo itou ä bíttuak. Júntuk ï enchim bíchähui éntok enchim jíkkajähui áa bétana huéiye. ");
INSERT INTO mfy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bueïtuk kaa áapo jü David téhuekau jikáu siika; bueïtuk áapo, jü David, ínel jiaahua: Jü Dios ín Señorbeu ínel jiaahua: “In báta bétanë yeesa yörisi machiku, ");
INSERT INTO mfy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","jume em béj‑rim em útteara bétuk ín tahuáriäu tajti.” ");
INSERT INTO mfy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Júntuk eme sïme jü pueblo Israel, akem ä jüneria lútula huëpo íkäi Jesústa enchim kúrusit popóntebokäuta jü Dios Señorpo ä tahuáriak éntok Crístopo, bueïtuk áapo yéä púuhuak ä nésaunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Íkärim jíkkajaka, bem jiápsipo ä jímmaaka, tüisi kaa al‑léaka taahuak. Huanärim Perotau ínel jiaahua éntok jume huate apóstolimmehui: —Eme itomak huéerim, ¿ensu, jáchisute ayúnake? ");
INSERT INTO mfy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Huanäi Peero ínel am yómmiak: —Emóem temajeka jíapsi kúakte Diostau bíchaa, éntokem sïme emo batötebo Jesucrístota téhuampo, enchim kaa tühua yáarimmet enchim jiókorinä béchïbo. Huanäi jü Dios juka Espíritu Santota enchimmet kom jünaktenake. ");
INSERT INTO mfy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bueïtuk hua Diosta nätuari enchim béchïbo näikiari, éntok enchim üusim béchïbo, éntok kia sïme huame mekka aneme béchïbo junne; kia jábeta béchïbo juka itom Señor Diosta nunubárëhui. ");
INSERT INTO mfy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jü Peero íkäi noksuka, éntok huátek ámeu nokaka, ínel am téjhuak: —Ime génte én kat‑riame jujuëna násukem yeu kaate, bueïtuk jü noki béttesi machika ámet hüechila. ");
INSERT INTO mfy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Júnëli huame íkäi tü nokta súalekame batöhuak. Huanäi huáachï taáhuarit baij miltumáchika jume Jesucrístota súalemmeu rúktek. ");
INSERT INTO mfy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Huanäi sïme jíba huame apóstolim am majtíä páman kaatei, nánancha éaka éntok Diostau buanaka. Éntokim nau rúkteka jume páanim nat nánäikimtei Señorta am sáhuekä bénasi au bem huáatinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sïme jü génte at guómtilataka taahuak. Jume apóstolim éntok, juebena señáalim kaa jaibu johuame johuai. ");
INSERT INTO mfy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sïme jume Jesucrístota súaleme huépülai bénasi nau aaney, éntokim bem áttea nau átteakai. ");
INSERT INTO mfy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bem áttea, jita júne bem jípurëhuim nénenkai, huanäi huame jábesu jítasä ámeu bëyë huéeläpom juka tómita ámet nánäikimtei. ");
INSERT INTO mfy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Chikti táapom jíba bénasi éaka jum tiöpopo nau aaney, éntokim jum bem jóapo nau yájaka al‑léaka nau jïbuäi, kaachin emo ériaka. ");
INSERT INTO mfy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diosta bétanam tühuata nookai ä baisáuhueka, éntok sïme jü génte am nakkei. Jü Señor entok, chikti táapo jume ä jínëusimëu huame huate ä súalemmeu rúktiasimey. ");
INSERT INTO mfy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Séjtul bájim jiäpo kupteu bíchaa jü Peero éntok Juan nau kateka jum tiöpou jikáu sájjak Diostau buabuánhuäu orapo, judíom ä boojoria bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chikti táapo senu yoreme guok löitaka yeu tómtilataka huämi tiöpo puértaapo totóijhuai, Hermoosä teäpo, limojnata áu ïaahuaka, jume áman kimummehui. ");
INSERT INTO mfy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Huanäi jü löi juka Perota éntok Juanta tiöpou kimúi am bíchaka, limójnata ámeu aahuay. ");
INSERT INTO mfy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Huanäi jü Peero entok Juan jáptekam tua ä bitchak. Huanäi jü Peero ínel au jiaahua: —Ítochë suuhua. ");
INSERT INTO mfy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Huanäi jü yorem löi ámet puseka taahuak jita júne áu mik máchileka. ");
INSERT INTO mfy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Të jü Peero ínel au jiaahua: —Kanne tómek jiöbe, tëne ín jípurëumak enchi aníanake: Jesucristo Nazaretpo jometa úttearammeyë kíkteka naa huéiye. ");
INSERT INTO mfy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huanäi jü Peero mampo bata bétana ä buíseka ä kétchak. Sep lauti éntok, jum térökiampo útteaka taahuak éntok sïme jum guókkimpo. ");
INSERT INTO mfy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Huanaí jü löi jikáu chépteka kíktek éntok naa huee táitek. Huanäi ámemak jum tiöpou kibákek. Huéeka éntok jikáu chéptisimeka, Diosta úttiley. ");
INSERT INTO mfy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sïme hua génte áma anéïhui ä bitchak ä huéeyo, éntokim ä jíkkajak Diosta ä úttileyo. ");
INSERT INTO mfy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Huanärim at guómtilataka taahuak hua au sikamta béchïbo, bueïtukim jüneiyai huákäi yoremta ájäriatukähui huam tiöpo puerta Hermósä teäpo yeyésaïhui limójnata aáhuakä. ");
INSERT INTO mfy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Huä yoreme löitukaïhui béja türiaka jü Peerótat éntok Juántat chätuka kaa am tóttojai. Sïme jü génte áma anëu éntok, at guómtilataka ámeu bíchaa teénnek jum tiöpopo Salomonta portal titéhuaakäu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jü Peero íkäi bíchaka, jü gentetau ínel jiaahua: —Eme oóhuim Israeliitam, ¿jatchiakem át guómte jü enchim bíchakäubechi, éntokem ítotchu suuhua? Eme jamak itom útterai éntok itom tü yórememtukä béchïbo íka yoremta itom naa hüeetua bénasi eiya. ");
INSERT INTO mfy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ëe kaa huäri béchïbo. Huame itom yoiyöhuam Abraham, Isaac, éntok Jacobta Dios juka ä Üusi Jesústa tóboktiaka buéresi útteata ä mákkak. Të eme huákäi yäurata mámpo tójjak, éntokem juka Pilátota ä búttiabarei júne kaa báreka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Huaka tü yóremta éntok lútüriata joamta búttia nésau éäkasem huaka juëna yóremta yore súalata búttiatebok. ");
INSERT INTO mfy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Júnëlem huaka jíapsihuamta yore mikamta mëtebok. Të jü Dios huam kókkolam násuk ä jíabitetuak. Íahuïte ítapo testíigom. ");
INSERT INTO mfy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesústa tehuam itom súalë béchïbo Dios ika yoremta enchim bíchäu éntok enchim täyäu útteata mákkak kíkteka náasä huéenakë béchïbo. Jüri Jesústa súalhuame ínel yúmalasi ä tütek íkäi yoremta, enchim sïmem ä bíchäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Eme ínomak huéerim, ínapo jüneiya eénchim éntok huame enchim yäuram juka Jesústa mëtebokähui kaa jünéaka Diosta yeu ä púakähui. ");
INSERT INTO mfy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Të jü Dios ímïri ä chúppak juka bannaataka jume ä profétam ä noktúakähui: juka yeu ä púari, Cristota, jiokot máchirata bínnake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Júnentukem emo temajeka jíapsi kúakte Diostau bíchaa, huame enchim Dios bejrim ä tuchánakë béchïbo. Huanäi jü Señor al‑leehuamta enchimmeu ayutuanake, ");
INSERT INTO mfy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","entok juka Jesústa, Cristota, enchimmeu bíttuanake, huaka bannaataka enchim béchïbo yeu ä púakähui ä nésaunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Të én ketune jü Jesucristo téhuekapo annake juka Diosta sïmeta bemélasi tü yäu tajti, huame profétam yéä púakäu bannaataka yájakame ä noktúakäpámani. ");
INSERT INTO mfy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bueïtuk jü Moisés ínel jiaahua itom yoiyöhuammehui: “Dios jü Señor enchimmeu senu profetata bíttuanake enchimmak huérita, ín enchimmeu bíttuahuakä bénasi. Huákärem nok jikkaijnake enchim at sáihuäu joaka, ");
INSERT INTO mfy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","bueïtuk sïme hua génte kaa júkäi profetata nésauhui yáakame kókkonake, éntok hua pueblo Israelta násuk yeu béptunake”, ti ámeu jiaahua jü Moisés. ");
INSERT INTO mfy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Sïme huame profétam Samuelta anéi naateka pujbau bíchaa ímëi taáhuarimmet ayúnakemta bétana nooka. ");
INSERT INTO mfy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Júntuk eme ámëriam jume pofétam nokákäu mabénnakeme, éntok enchim tühuata jájamnakë béchïbo jü Dios huame itom yoiyöhuammak nokta lútüria yáuhuak, jü Abrahamtau ínel jíaka: “Sïme jü génte ániat aneme tühuata jájamnake hua émot yeu simríata béchïbo”, tau jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kíalïku jü Dios juka ä Üusi jíabitetuaka enchimmeu báchä bíttuak, tühuata enchimmeu yáa báreka, huépülai bénasi enchim huaka juënaraata tóij ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peero éntok Juan ketune gentetau nookai jume tiöpopo nésauhueme ámeu yájayo, jü tiöpota suáyammeu yäuttamaki, éntok jume saduceommaki. ");
INSERT INTO mfy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bempo oómtei juka Perota éntok Juanta juka genteta majtíä béchïbo jume kókkolam jíabitenake bétana Jesústa jíabitekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Huanärim am peréesoteka cárcelpo am jóiyak yokóriapo nokta ámet chupa báreka, bueïtuk béja kuptei. ");
INSERT INTO mfy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Të büruka juka tü nokta Jesucrístota bétana huemta jíkkajakame ä súaleka taahuak. Huanäi sïme nau jume Jesucrístota súaleme, oóhuim jíba näikiaka, jíba tua batte mamni miltukay. ");
INSERT INTO mfy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yokóriapo jume judíom puéblopo nésauhueme, jume yoiyötori yäut jóarim, éntok jume judíom ley am mamájtíame, buere joära Jerusalémpo nau yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ama aaney kétchi jü Anás, jü tiöpopo chë nésauhueme, Caifás, Juan, Alejandro, éntok sïme huame tiöpopo chë nésauhueme famíliapo joome. ");
INSERT INTO mfy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Huanärim juka Perota éntok Juanta áman bem jokäu nütebok. Huanärim áme násuk yéu am jäbuaka ínel ámeu jiaahua: —¿Jábeta nésaupo, éntok jábeta úttearammeasem íkäi yoremta tütek? ");
INSERT INTO mfy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Huanäi jü Peero, Espíritu Santota útteara at ayúkä béchïbo, ínel am yómmiak: —Eme puéblopo yäuram, éntok eme pueblo Israelpo yoiyöturim: ");
INSERT INTO mfy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","béjasem itom temajeka senu yoreme kökoremtau tühuata yáahuakä bétana jachin ä türiakähui, ");
INSERT INTO mfy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","enchimte ä téjhuanake sïme genteta Israelpo jometa ä jünérianakë béchïbo. Ï yoreme yúmalasi türilataka enchim bíchäpo aane hua Jesucristo Nazaretpo joome kúrusit enchim popóntebokäuta úttearammea, hua Diosta kókkolam násuk jíabitetuakähui. ");
INSERT INTO mfy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Eme huame káarim jojoame juka tétata chë türik omoutekä bénasi maachi, bueïtukem juka Jesústa kaa türeka ä omoutek. Én éntok jü Dios júkäi Jesústa sïmem béppa nésautuak, jachin hua tetta yeu púari kari naahua eskinapo yéchari, álë bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kaabe éntok ára itom jinëu, Jesucristo jíbba; bueïtuk Dios kaábeta éntok im ániau kom bíttuak itom ä jínëunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Huame yäuchim juka Perota éntok Juanta kaa májhueka am nokayo tüisim at guómtek, jünéaka kaa tüisi jiösiam am täyähui, éntok am polóobemtukähui. Huanärim ámet jünëak Jesústamak am rejtílatukähui. ");
INSERT INTO mfy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tem juka yoremta türilata áme násuk huéekamta bíchaka, kaachin am nok bejmáchiakai. ");
INSERT INTO mfy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Huanärim jum bem anëpo yéu am sákatuak, bempo nau ettéjhua báreka. ");
INSERT INTO mfy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Huanärim ínel jiaahua: —¿Jáchisute am yáanake jäni ímëi yorémem? Bueïtuk sïme jume Jerusalémpo jóakame jüneiya íkäi kaa jaibu johuamta am yáalatukähui, éntokte kara ä esso. ");
INSERT INTO mfy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Të íkäi bem joäu kaa sïmat jünérianä béchïbo, atam taktirianake én naateka kaa júchi Jesústa bétana jábetau am noknáke béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Huanärim am núnuka kuttílasi ámeu noókak kia jachin éntok huei júne kaa Jesústa bétana jábemmeu am nok sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Të jü Peero éntok Juan ínel am yómmiak: —Áachem emo temaje eme, ¿jachu türi jäni Diosta bíchäpo enchim nesauhui yáa béchïbo, juka Diosta nésauhui tójaka? ");
INSERT INTO mfy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bueïtuk ítapo kara ä esso, huaka itom bíchakähui éntok itom jíkkajakähui. ");
INSERT INTO mfy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Huanäi jume yäuchim am mauj téjhuak, tem jíba am sákatuak. Kaítam béttesi machik ámeu yáa máchika taahuak, bueïtuk sïme hua génte Diosta bétana tühuata nookai, éntokim ä úttilei hua yáarita béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Huä yoreme türika tahuakame kaa jaibu johuamta at chúpahuakähui cuarenta huásuktiriam béppa am huériay. ");
INSERT INTO mfy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jü Peero éntok Juan búttiahuakam sájjak huame ámemak kateme anëu bícha. Huanärim ámeu yájaka am ettéjhuariak jachin huame tiöpopo chë nésauhueme ámeu jíakähui, éntok huame yoiyöturim. ");
INSERT INTO mfy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Huanärim am jíkkajaka, sïme nau ínel Diostau buänak: —Itom Señor, empo tua jita árahueme, empo ájäria jü Dios téekata yáakame, buíata, bahueta, éntok sïme huaka ayúkamta. ");
INSERT INTO mfy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Empo jü em Espíritu Santoy Davidta ínel noktúak: ¿Jatchíakasu jume naciónim emo tóboktia, huame géntem éntok, bem kara joäu yáa báreka eiya? ");
INSERT INTO mfy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jume réeyim im buíapo nésauhueme emo tóboktiak, jume puéblommeu yäuchim nau emo tójjak, Diosta béj‑reka éntok ä Cristohuata. ");
INSERT INTO mfy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Bueïtuk lútüriapo jü rey Herodes éntok Poncio Pilato náuhuim emo tójjak imi puéblopo jume gentiilimmak éntok israeliitammaki, em Üusi Jesús tü yóremta béj‑reka, ä nésaunakë béchïbo em yeu púakähui. ");
INSERT INTO mfy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bempo sïmeta huaka bannaataka naateka em mampo entok em nokakähui em at jünaktekäu chúppak. ");
INSERT INTO mfy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Én éntoko, Señor, huaka bem itom máujtuahuäubechë suuhua, éntoke óusi éehuamta itom jume em sáuhuëhuim miika, kaa májhueka em noki itom noknákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Em úttearë yeu machíria huame kökoreme türinakë béchïbo, éntok señáalim kaa jaibu johuame jotúnakë béchïbo em Üusi Jesús tü yóremta úttiärayi. ");
INSERT INTO mfy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Júnëli Diostau am buansuk, huam bem nau anëpo jü kari au yoyóak. Huanäi sïme juka Espíritu Santota úttiära mabétaka juka Diosta noki kaa májhueka nookai. ");
INSERT INTO mfy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sïme huame Jesucrístota súalekame senulhua jíba eiyai, éntok nánancha emo ériai. Kaabe juka ä átteahuata áapola au átteak tíiyai, ál‑la sïme nau ä átteakai. ");
INSERT INTO mfy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jume apóstolim éntok, tüisi útteäta jípureka jíba juka Señor Jesústa kókkolam násuk jíabitekä bétana nookai. Dios éntok, sïmemmeu buéresi tühuata johuai. ");
INSERT INTO mfy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kaabe áme násuk jiókot eiyai, bueïtuk sïme huame buíam jípureme, éntok kárim jípureme, am nénkaka juka tómita ");
INSERT INTO mfy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","jume apóstolimmeu ä totojai. Huanärim huëpulammechä nánäikimtei bem ámeu bëyëu huéeläpo. ");
INSERT INTO mfy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Júnëli aayuk, senu yoreme levíiita usíarimpo jométaka, Josë téaka, isla Chíprëpo yeu tómtilataka, jume apóstolim Bernabem téhuaatuakähui. Yore sirok yáatituame tiau báare. ");
INSERT INTO mfy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ïri yoreme buíata ä jípurëu nénkaka juka tómita jume apóstolimmeu tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Të senu yoreme Ananías téaka, ä jubí Safírä téamtamak éaka, buíata nénkak. ");
INSERT INTO mfy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ïri yoreme ä jubímak éaka huate tómimak taahuak, juka huatek éntok, jume apóstolimmeu tójjak, ïri sïme hua buíata bejhua ti ámeu jíaka. ");
INSERT INTO mfy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Huanäi jü Peero ínel au jiaahua: —Ananías, ¿jatchíake juka Satanásta nésauhui yáuhuak juka Espíritu Santota emo bäitäu máchileka éaka? Bueïtukë huate tómimak tahuaka huátek jíba äbo tójjak, ïri sïme hua buíata bejhua tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Jatchu kaa empo ä átteakai juka buíata ke ä nénkaka? Ä nénkisuka éntok, ¿jatchë kaa jíba empo ä átteaka tatahua juka tómita, em yáa bárëu ái em yáanakë béchïbo? ¿Jatchíake íkäi kaa tühuata yáa báreka ëak? Dióstahuë aranókïchiata nooka, kaa yorémemmehui. ");
INSERT INTO mfy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Huanäi jü Ananías ínel ä jiai ä jíkkajaka jíba, huécheka muúkuk. Huanäi sïme jume íkäi jíkkajakame tüisi májhueka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Huanäi huate yorëmem jübua yoyötume jápteka, sánkompo ä bïtiaka yéä nuksájaka ä maäk. ");
INSERT INTO mfy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chúkula baij orata huei jäni jü Ananíasta jubí áma yépsak, kaa jünéaka jita bénak áma yeu sikähui. ");
INSERT INTO mfy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Huanäi Peero ínel au jiaahua: —Nechë tejhua, ¿jachem ia béekipo juka buíata nénkak enchim jíakä bénasi? Áapo éntok inel au jiaahuak: —Jeehui, júäri béekipote ä nénkak. ");
INSERT INTO mfy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Huanäi jü Peero júchi ínel au jiaahua: —¿Jatchíakem nánancha éaka juka Señorta Espíritu baítáu bábarek? Júmum äbo kaate jume em kuná mäákame. Én éntokim enchi ket yeu huérianake mukílata. ");
INSERT INTO mfy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Huanäi seep Perota guokpo huécheka muúkuk. Huanäi huame yorémem jübua yoyötume áman kimuka, juka Safírata mukílata téuhuak. Huákäi éntokim ket yeu núk sájaka ä kunamak lópola ä maäak. ");
INSERT INTO mfy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Huanäi sïme jume Jesucrístota súaleme tüisi májhueka taahuak, éntok sïme huame íkäi jünériakame. ");
INSERT INTO mfy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jume apóstolim jü genteta bíchäpo juebenna señáalim kaa jaibu johuame johuai. Jume Jesucrístota súaleme éntok, sïme, jum tiöpopo Salomonta portal titéhuaakapo nau yayajjai. ");
INSERT INTO mfy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Të jume kaa Jesucrístota súaleme májhueka kaa ámemak emo kuúkuútiai, tem jíba buéresi tühuata áme bétana nookai. ");
INSERT INTO mfy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Júnentaka junne juebena génte juka Señorta súaleka taahuak, oóhuim éntok jaámuchim junne. ");
INSERT INTO mfy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ïri Señorta bem súalëu buériau yuumak. Jume kökoreme júnem bem ámet töyëumak chikti böóu yeu totojjai, juka Perota áma huam huei kia júne juka ä jékkaahuata ámeu yúma ïaaka am türinakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Huame pueblom chíkola jokame bétana juebena génte jum Jerusaléniu yájjak, kökoreme huériaka, éntok yoremem espíritu jaiti machim jípureme. Huanäi sïme türiak. ");
INSERT INTO mfy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Huanäi hua tiöpopo chë nésauhueme, éntok huame saducéom titéhuaakammak kateme, áa bétana éame, ä ínnëaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Huanärim jume apóstolim buíjteboka am peréesotetebok, éntokim cárcelpo am jóiyak. ");
INSERT INTO mfy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Të jü Señorta ángel tukaapo ámeu yepsaka, juka cárcelta puerta étapoka, yeu am sákatuak, éntok ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Sájakem áman tiöpou kimuka jü gentetau nooka ï bemela jíapsihuamta bétana. ");
INSERT INTO mfy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Íkäi jíkkajakam yokóriapo kethuéitana tiöpopo kimuka am majtíataitek. Huanäi hua tiöpopo chë nésauhueme, éntok huame áamak éame, ímin juka buere yäurata nau núnnuk, sïme huame Israelpo yoiyöturim. Huanärim jume apóstolim jum cárceliu nuú nésauhuek. ");
INSERT INTO mfy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Të jume tiöpota suáyame áman jaahuákame cárceliu yájaka kaábeta áma téuhuak. Huanärim sájaka áman am téjhuak, ");
INSERT INTO mfy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ínel jíaka: —Lútüriapote juka cárcelta tüisi páttiatau yájjak, éntok jume sontarom ä suáyame puértam bëkatana jäbuekammehui. Tëte ä étapoka éntok, kaábeta áma huáijhua téuhuak. ");
INSERT INTO mfy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Íkäi jíkkajaka jü tiöpopo chë nésauhueme, éntok jume huate áma tékiakame sáuhueme, kaachin anmáchika taahuak, álë bénasi jü tiöpota suáyammeu yäut, éntokim emo nau nátemaje ínel jíaka: —¿Jákusa tua ïri chúpnake jäni? ");
INSERT INTO mfy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Júnëlam nokaisu senú yoreme áma yépsak ínel ámeu jíaka: —Huame yorémem enchim pereesotekäu áman tiöpopo aneka jume géntem majtíay. ");
INSERT INTO mfy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Huanäi hua tiöpota suáyammeu yäut ä sáuhuëummak sika áman am nüka, të kaa béttesi ámemak aneka, bueïtuk juka genteta májhuey emo mamaasu máchileka. ");
INSERT INTO mfy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Huanärim am nüpaka huam buere yäurata bíchäpo yéu am jäbuak. Huanäi jü tiöpopo chë nésauhueme jume apóstolimmeu ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ítapo chë, kuttílasi enchim téjhuaakai kaa júchi Jesústa bétana huemta jábeta enchim majtía sáhueka. Tem kaa itom nésauhui yáuhuak. Chë tüisisem sïmát jum Jerusalémpo am majtiasasaka, éntokem juka juëna nokta itot jimma báare juka yoremta itom mëtebok tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Huanäi jü Peero éntok jume huate apóstolim ínel am yómmiak: —Ítapo ä lútüriak juka Diosta bat itom nok chúpanakëhui yorémem itom nok chúpanakepo béppa. ");
INSERT INTO mfy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Eme juka Jesústa kúrusit popónteboka ä mëtebok, të jü itom yoiyöhuam Dios ä jíabitetuak kókkolam násuku. ");
INSERT INTO mfy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Jü Dios éntok, ä tóboktiaka ä bata bétana yörisi machiku ä yétchak, sïme yäurata béppa ä nésaunakë béchïbo, éntok yore ä jínëunakë béchïbo, jum pueblo Israelpo jömem ä jíapsi kúakti ïaaka, bem kaa tühua yáarimmecham jiókorinä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Júahuïte ítapo testíigom, éntok jü Espíritu Santo, hua Diosta huame ä nok jíkkajame mikähui. ");
INSERT INTO mfy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Íkärim jíkkajaka, öómteka am sua báarei. ");
INSERT INTO mfy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Të jum yäurata násuk senú pariseero aaney Gamaliél téaka, judíom ley am mamájtíame. Huäri kíkteka noókak jume apóstolim chúbala päkun yeu huéria nésauhueka. ");
INSERT INTO mfy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Huanäi yéu am nuksákahuak, jü yäuratau ínel jiaahua: —Eme oóhuim Israelpo joomem, tüisem at suuhua jita ímëi oohuimmeu enchim yáanakëubechi. ");
INSERT INTO mfy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bueïtukem jíba tua au huáate eme, jaiki huásuktiria jan huéiye senu yoreme Téudas téaka au tóboktiak buéresi jita au tékiak tíaka. Jume yoremem éntok, naiki cientotu máchika áamak chätuk. Të mëhuak huäri yoreme, huame áamak chätukäu éntok, sïme chíbejtek. Huanäi huämi luútek jü ä huéetuähui. ");
INSERT INTO mfy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Chúkula jume géntem jiösiapo kimahuata taahuarimmet senu Júdas téaka, Galiléapo jométaka, ket au tóboktiak. Huanäi juebena génte ket áamak chätuk. Të ket mëhuak, huame áamak chätukáu éntok, chíbela näikim sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kíalïkune enchimmeu nooka ímëi oóhuim kíal enchim toij sáhueka. Bueïtuk íkäi ínëli huemta yorémem bétana ä huei, jíba luutínake; ");
INSERT INTO mfy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","të Diosta bétana ä huéeyem kaachin ä yáanake. Jítachem suuhua; jachin aika júnem Diosta béj‑reka ayúnake. ");
INSERT INTO mfy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Huanäi sïme áa beu éaka taahuak. Tem chúkula jume apóstolim núnuka tüisi am bépsuk, éntokim kaa éntok Jesústa bétana jábemmeu am nók sáhueka am téjhuak. Huanärim am búttiak. ");
INSERT INTO mfy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Huanäi jume apóstolim yäurata mampo yeu sájaka, tüisi al‑léaka taahuak juka Diosta junëli Jesústa béchïbo jiókot máchirata am bíttuak tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Të bempo jíba chikti táapo jum tiöpopo am majtíaka taahuak, éntok jóahuat junne, juka tü nokta Jesucrístota bétana huemta ámeu nokaka. ");
INSERT INTO mfy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Huámechi taáhuarimmet jume Jesucrístota súaleme chë bürutáitek, jume griego nokta nókame jume hebreo nokta nokame béj‑reka noktáitek bem jámut jókoptulam kaa tüisi bíthuä tíaka jum chikti táapo buähuamta näikimtehuäpo. ");
INSERT INTO mfy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Huanäi jume dóoce apóstolim sïme jume Jesucrístota súaleme nau núnuka ínel ámeu jiaahua: —Kaibu türinake ítapo juka Diosta noki itom am majtíäu tójako, buähuamta itom näikimtebare béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Júnentuk, eme itom hermáanom, guoibusan oóhuimem yeu púuhua enchim násuku, huame enchim sïmem yörëhui éntok jítat jünéame, éntok Espíritu Santota útteara ámet ayúkähui. Huanärem íkäi tékilta am máknake bem ä jonákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ítapo éntokte jíba oraciompo Diostau noknake, éntokte Diosta tü noki jíba am majtíanake. ");
INSERT INTO mfy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Huanäi sïme áamak al‑léaka tahuaka Estebanta yeu púuhuak, chikti ä jíapsimak Diosta noki súalemta éntok Espíritu Santota útteara jípuremta, éntok Felípeta, Prócorota, Nicanorta, Timonta, Parménasta, éntok Nicolasta Antioquíapo jometa bannaataka judíom bétana éäuta. ");
INSERT INTO mfy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Huanärim jum apóstolim anëu am tójjak, huamei béja choapo áme béppa mámteka Diostau mampom am tojjak. ");
INSERT INTO mfy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jü Señorta noki chëhuasu chíbejtei, jume Jesucrístota súaleme éntok chëhuasu büruakai jum Jerusalémpo. Juebénaka jume tiöpopo tékiakame júne Jesucrístota súaleka tahuak. ");
INSERT INTO mfy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Diosta tühua at ayúkä béchïbo, éntok ä útteara ä jípurë béchïbo, señáalim kaa jaibu johuame júne johuai genteta bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Huanäi huate yorémem, jum sinagogampo ínel téhuaakapo jométaka: Sáihuame bem teko mámpo yeu huik‑ri, huate Cireenepo jomemmaki, éntok Alejandríapo, Ciliiciapo, éntok Ásiapo jomemmak náu Estebantamak nok nássua táitek. ");
INSERT INTO mfy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tem kaa ä nok kóbbak, bueïtuk áapo tüisi jünéaka nookay, éntok jü Espíritu Santota útteara at ayúakai. ");
INSERT INTO mfy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Huanärim huate yorémem béjtuak Moiséjta béj‑reka ä nokái emo ä jíkkajak ti jiau ïaaka, éntok Diosta béj‑reka. ");
INSERT INTO mfy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Júnëlim ayuka juka genteta emo tóboktituak, éntok jume yoiyötori yäut jóarim, éntok jume judíom ley am mamájtíame. Huanärim Estebantau hüanteka, ä buíseka, bem buere yäurau yéu ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Huanärim jume testígom aranókïchi bem tákiarim jaríak. Huámëi béja ínel jiaahua: —Ïri yoreme kaa yáateka juënak nooka ï tiöpo yörihuamta bétana, éntok Moiséjta ley béj‑reka. ");
INSERT INTO mfy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ítapo ä jíkkajak juka Jesús Nazaretpo jometa ika tiöpota au tátabnake tíamta, éntok juka Moiséjta itom boojória sáuhuëu itom au úhuanake tíamta. ");
INSERT INTO mfy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Huanäi hua yäura entok sïme jume áma jokáïhui, jü Estebántat suaka Diosta ángel bénak pújbakamta bitchak. ");
INSERT INTO mfy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Huanäi jü tiöpopo chë nésauhueme jü Estebantau ínel jiaahua: —¿Jatchu lútulai jü emo bétana nokhuame? ");
INSERT INTO mfy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Áapo éntok, ínel ä yómmiak: —Eme ínomak huéerim, éntok eme ín áchayim, nechem nok jíkkaja. Jü itom Dios, jü tua yörisi maachi, jü itom yoyöhua Abrahamtau au yeu machíriakai Mesopotamia buíaräpo áa aneyo, ketune kee jum Haraniu ä jóateyo. ");
INSERT INTO mfy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Huanäi ínel au jiaahua: “Em buíarapë yeu huéiye, éntok em huáhuaijrame tösime, buíarata ín enchi téjhuanakeu bíchë huéiye.” ");
INSERT INTO mfy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Huanäi Abraham Caldea buíaräpo yeu sika Haraniu jóatek. Chúkula béja ä áchaihua múkuk. Dios éntok, juka Abrahamta äbo nüpak ï buíarahui én enchim jóakäpo. ");
INSERT INTO mfy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Të huanäi kaita buíata ä miíkak ímï ä átteanakëhui, kía áma ä chéptiläpo belékkanik junne Të ál‑la ä mik rókaka nookak, éntok áapörik muksukäpo jume ä üusihuam ä átteanake tíaka. Të huámechi taahuarimmet Abraham ketune kaabeta üusekai. ");
INSERT INTO mfy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Éntok Dios kéchä téjhuak jume at yeu sákariam kaa bem buíaräpo am jóanake tíaka, tattäbuim bétuk am jíapsinakëhui, éntok jiókot am jonähui naiki cien huásuktiapo. ");
INSERT INTO mfy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Të Dios ínel ket au jiaahua: “Ínapone chúkula hua nación jiokocham josúkamtat nokta béttesi machik chúpanake Huanäi bempo huämi yeu sájaka ímï buíaräpo jóateka ín nésauhui jonake.” ");
INSERT INTO mfy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios Abrahamtamak nokta yetchak, juka circuncisión téamta señalpo ä mákaka, jünákiachinakë béchïbo íkäi nokta nau tütehuakamta bétana. Kíalïku juka ä üusi Isaacta yeu tómtek, Abraham guojnaiki taáhuarim huei ä circuncidaroak. Álë bénasi ket jü Isaac juka ä üusi Jacobta circuncidaroak. Jacob éntok, ket jíba jume ä dóoce üusim ínel jume dóoce pueblo Israelta yoiyöhuam. ");
INSERT INTO mfy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ímëi Jacobta üusim, bannaataka itom yoiyöhuamtukaïhuim, ímëri bem saiy José béppam jita jípupeiyay íäri béchïbom ä nénkak. Jume ä jínukame éntok, Egiptou bíchaa ä nuksájjak. Të Dios Joseta aníak, ");
INSERT INTO mfy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","éntok sïme hua jiókot ä josúakä bétana ä jínëuk. Súahuata ä miíkak, éntok juka Faraonta, Egíptopo reyta, au bíchaa türik jíapsita ä jípunakë béchïbo ä aníak. Huäri éntok ä yäut yétchak jum Egíptopo ä nésaunakë béchïbo, éntok ä jóapo junne. ");
INSERT INTO mfy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Huámechi taáhuarimmet buere tébaa siika éntok jiókot máchira jum sïme Egipto buíaräpo éntok Canaán buiärapo. Jume itom yoiyöhuam kaa bem buänakeu téu máchiakay. ");
INSERT INTO mfy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Të Jacob jünéaka jum Egiptopo tirijkom ayukähui, jume ä üusim bannaataka itom yoiyöhuakäïhuim áman sáuhuek bát huëpo. ");
INSERT INTO mfy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Júchi huëpo áman am jaahuak, José béja ámeu au täyatebok jume ä sayímmehui. Júnëli jü Faraón jüneïak jábeta yoremiampo juka Joseta jometukähui. ");
INSERT INTO mfy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Huanäi José ä áchay Jacobta áman núnutebok éntok sïme jume nau huérim at yeu sákariam, sïme náu setenta y cincotukay. ");
INSERT INTO mfy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ínëli yeu sikäpo jü Jacob jum Egiptou bíchaa siika áman jóaseka. Ámani muúkuk éntok ä üúsihuam bannaataka itom yoiyöhuakäïhuim. ");
INSERT INTO mfy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Huanäi chúkula jume bem ótahuam jum Siquem téäu tóijhuak. Ámanïrim mäáhuak jum sépultura Abrahamta jínnukäpo jume Hamor téamta üusimmehui. ");
INSERT INTO mfy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Béja Diosta Abrahamtamak ä nokakau yechari chúpisei, jü pueblo Israel jum Egíptopo chëhuasu au büruriai. ");
INSERT INTO mfy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Huámechi taáhuarimmet éntok, jum Egíptopo täbui rey nésautáitek Joséeta bétana kaita jünériaka, éntok ä yáarihuata bétana junne. ");
INSERT INTO mfy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ïri rey jume itomak huérim bäitautáitek, éntok huame itom yoiyöhuam jiókot jotáitek, útteapo bem üusim jübua tómteme am guötituaka am kókko ïaaka, kaa emo am bürurianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Huámechi taáhuarimmet Moisés yeu tómtek. Íkäi ili úsita Dios ámak al‑léaka taahuak. Jume ä áchaihuam baij metpo núkisi bem mampo ä jípurek. ");
INSERT INTO mfy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Të bempörim sékäna ä ésok jü Faraonta malá ä téaka ä nüka, ä yöturiak ä asóakamta bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kíalïku jü Moisés sïmeta majtíahuak jume Egíptopo jomem täyähui. Tüisi jítat jünéaka nonokai, éntok jita tékilta júne tüisi boojóriai. ");
INSERT INTO mfy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Béja cuarenta huásuktiriam yúmariaka jü Moisés jume áamak huérim bitbábarek, jume Israelta üusim. ");
INSERT INTO mfy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Huämi aneka juka senuk Egíptopo jometa Israelta üusimmak huéeri jiókot joamta bitchak. Të ä jínëu báreka, éntok ä jujut‑ria báreka, jü Moisés juka Egíptopo jometa mëak. ");
INSERT INTO mfy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Bueïtuk áapo jume áamak huérim Israelpo joomem jünéemáchilei juka Diosta jum mampo bem jípuhuä bétana am jínëunakëhui áapörik béchïbo. Të bempo kaa at jünéaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yokóriapo jü Moisés guoi yorémem Israelpo joomem ket nau nássuame téuhuak. Huanäi emo am tójaka, nau am al‑leë ïaaka, ínel ámeu jiaahua: “Eme nau huéeri; ¿jatchíakem nau nassua?”, ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Huanäi hua seenu ä sai bébame Moiséjta yüaaka ínel au jiaahua: “¿Jábesu enchi itou yäut yéchala? ");
INSERT INTO mfy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Játchë nee ket më báare, tuuka huaka Egiptopo jometa em mëakä bénasi?”, tau jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Íkäi jíkkajaka jü Moisés búitek Madián buíarau bícha. Huämi aanek kaa áma jométaka, éntok huämi guoyim üúsek. ");
INSERT INTO mfy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chúkula júchi cuarenta huásuktiriam huéy, jum kaa jóata bëmu Sinaí káuhui téamta náapo ä aney, jü Diosta ángel áu yeu machiriak juya zarzä téamta béetëpo. ");
INSERT INTO mfy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jü Moisés at guómtek hua ä bíchakäubechi. Huanäi au rúkteka tüisi ä bít báarey, jü Señor ínel au jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ínapone jü em yoiyöhuam Dios, Abrahamta, Isaacta, éntok Jacobta Dios”, tau jiaahua. Huanäi jü Moisés májhueka au yöo táitek, éntok kaa ä bít báarey. ");
INSERT INTO mfy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jü Señor éntok, júchi ínel au jiaahua: “Emoë bocha yétcha, bueïtuk jü buíya em at huéekäu yörisi maachi. ");
INSERT INTO mfy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ínapo jum Egiptopo juka jiokot máchiraata ín génte bíchäu jüneria, éntok jiókot jíamtane jíkkajaka, äbo kóm siika am jínëu báreka. Júntukë inou rukte. Énchine áman jaa báare jum Egíptohui”, táu jiaahua. Bempo Moisejta omoutek inel au jiaka jabesu enchi itou yaurapo yechala. ");
INSERT INTO mfy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Junaköri bempo juka Moiséjta omóutek, inel au jiaka: “¿Jabesu enchi itou yauräpo yechala?”, kaa ámeu ä yäuttu ïaaka junne, jü Dios jíba ä yäut yáaka ámeu ä bíttuak am jínëunakë béchïbo, hua ä ángelhua juya zárzata béetëpo au ä nokákäpámani. ");
INSERT INTO mfy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ïri Moisés ínel jume itom yoiyöhuam jum Egíptopo yeu núk siika, señaalim kaa jaibu johuame joaka huämi buíapo, éntok Mar Rojopo, éntok huám júya ániapo, cuarenta huásuktiapo ä núnübuakäpo. ");
INSERT INTO mfy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ïri Moisés ínel jume Israelta üusimmeu ínel jiáhuak: “Jü Dios senu profeetata enchimmeu bíttuanake enchim sailammet yeu simriata, ín enchimmeu bíttuahuakä bénasi. Huákärem nok jíkkaja”, ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ïri Moisés ínel ket hua áman júya ániapo itom yoiyöhuammak anekame, éntok jü Diosta ángeltamak ettejhuakäme jum Sinaí káhuichi, nokta áy jíapsihuamta áa bétana mabetaka itou ä tö simnakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Të huame itom yoiyöhuam juka Moiséjta kaa nok chupa báreka ä béj‑reka sájjak, éntokim notti báreka eiyai Egiptou bícha. ");
INSERT INTO mfy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Huanärim Aróntau noókak ínel au jíaka: “Diosimte enchi itom yáaria ïaa böota itom téjhuanakeme, bueïtukte kaa jüneiya jita bénak jü Moiséjtau sikähui, hua Egipto buíaräpo itom yeu nuksikámtahui.” ");
INSERT INTO mfy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Huanärim beceerota yáaka ä dios yáuhuak, éntokim animaalim súaka áu am buíssek, ofrendapo. Huanärim tüisi al‑leaka taahuak huaka bem mámammea yáata yöreka. ");
INSERT INTO mfy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Huanäi jü Dios bempólaim tójjak. Jume chókkim téhuekapo ayúkame am yörinakë béchïbo júne kíal am tójjak, jum profétam librompo ínel ä jiä bénasi: ¿Jatchu eme, génte Israelpo joome, animáalim súaka inou am buíjnake jäku áman juya ániapo cuarenta huásuktiapo rejteka? ");
INSERT INTO mfy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Katem inou am buísse, ál‑lem juka enchim dios yáaritau am buíjnake, éntokem juka enchim yáari Molók téamta áma kátekäu núnübuak, éntok juka dios Renfán téamta chokki, huámëi enchim yáarim yöri báreka. Júkäi enchim yáakä béchïbone enchim buíaräpo enchim yeu béebaka jum Babiloniä teäpo huám bíchaa enchim bíttuanake. ");
INSERT INTO mfy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Huämi mekka aniapo jume itom yoiyöhuam juka karpa káata jípurei jume tetta cháchaij‑rim leyta áma jïojteri bem áma ëriähui. Íiri yáahuak Diosta juka Moiséjta sáhuekä pámani bueïtuk jü Dios hua áapörik, Moiséjta, bíchakäu bénak ä yáa sáuhey. ");
INSERT INTO mfy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Íkä kárita jume itom yoiyöhuam mabétak, éntokim Josuétamak kateka júne jíba ä huériai huate naciónim buíarau kimuboka, Diosta yeu béebakähuim bempörim juka buíata mak báreka. Júnëlim jíba ä jípurek juka rey Davidta nésauhuëu tajti. ");
INSERT INTO mfy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jü rey David éntok, Diosta bétana tühuata jájamek. Huanäi tiöpota yáa bábarek juka Jacobta Dios áma jóanakëhui. Të Dios kaa ä yaä ïak. ");
INSERT INTO mfy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Huanäi jü Salomón ä yáuhuak juka Diosta káari. ");
INSERT INTO mfy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Juka Dios sïme béppa yörisi machik kaa kari yorem yáaripo ä jójjoaï junne, profétata áa bétana ínel jiä bénasi: ");
INSERT INTO mfy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jü téhueka kia hua ín áma yeyésäu bénasine ä eria, juka buíata éntok, ín at guóguokëu bénasi. ¿Jáichinakësa júntuk jü káari enchim nee yáarianakëhui?, ti jiaahua jü Señor, éntok, ¿jáichinakësa jü ín at jimyórenakëhui? ");
INSERT INTO mfy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Jatchu kaa ínapo sïmeta juka ayúkamta yáala jäku? ");
INSERT INTO mfy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Të emëe —ti ámeu jiaahua jü Esteban— jíbem ínel kaa Diosta noki jíkkaij báare, huame Diosta kaa täyame bénasi, éntokem áme bénasi jiápsa. Jíbem enchim yoiyöhuam bénasi mamachi. ");
INSERT INTO mfy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Jábe profétatasum kaa jiókot yáuhuak huame enchim yóyöhuam? Bempo huaka tua lútüriata joamta yebíjnake bétana bannaataka nokakame súuhuak. Én éntok, huákäi yepsak, eme yäurata mámpo ä yéchaka ä mëtebok. ");
INSERT INTO mfy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Eme jume Diosta ángelesim mampo leyta mabétaka júnem kaa ä nésau páman kaate. ");
INSERT INTO mfy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Íkärim jíkkajaka, jü Estebantau öómteka támim kumeka tahuak. ");
INSERT INTO mfy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Të jü Esteban, Espíritu Santota at anë béchïbo, téhuekau reémtéka juka Diosta ujyóoria bitchak, éntok juka Jesústa Diosta bátam bétana huéekamta. ");
INSERT INTO mfy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Huanäi ínel jiaahua: —¡Juyú! Áman téhuekapone juka Yoremta Üusi titéhuaakamta Diosta bata bétana huéekamta bitcha. ");
INSERT INTO mfy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Të bempo emo naka páttiaka, kusisi cháchayeka áu huántek. ");
INSERT INTO mfy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Huaärim ä buíseka, jum puéblopo yeä nuksájaka, áman päkun ä mamáataitek ä mëbáreka. Jume ä nätuakame éntok, juka bem sanko béppa huemta jóiyak, senu yorem jübua yötumta, Saulo téamta, guokpo ä jóiyak ä suaya ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Huanäi jü Esteban mamáahuaka ínel Diostau buaanak: —Señor Jesús, ín jíapsine em mampo yétcha, aké ä mabeta. ");
INSERT INTO mfy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Huanäi tónommia kíkteka, kusisi chayeka ínel jiaahua: —Señor, íkäi kaa tühuata am yáakä násuk junne, Akë am jiokore. Ínëli jíaka muukuk. ");
INSERT INTO mfy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo éntok, ámemak ä türek Estebanta mënä bétana. Huäri taahuarit jume Jesucrístota súaleme buéresi guokjájja táitek jum buere joära Jerusalémpo. Huanäi sïme áachim chíbejtek jum Judéapo éntok Samaria buiärapo, të jume apóstolim jíba kaakum sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Huate yorémem tü jiápsekame juka Estebanta maäk, éntokim tüisi ä buan‑riak. ");
INSERT INTO mfy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo éntok, jíba bénasi jume Jesucrístota súaleme guok jájjasei jóahuat kikkibákeka; oóhuim éntok jaámuchim júne áma yeu huiikei am huíksimeka cárceliu am toij báreka. ");
INSERT INTO mfy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Të jume Jerusalémpo yeu tennékame juka Diosta tü nooki kia jak bem katë páman ä noksakai. ");
INSERT INTO mfy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe, ket ámemak aneïhui, jum senu pueblo Samariau bíchaa siika ámani Crístota bétana ámeu noktáitek. ");
INSERT INTO mfy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Huanäi jü génte au nau yayájaka, sïme jü Felípeta nokáubet suaka ä jíkkajai, juka kaa jaibu johuamta ä joäu bíchaka. ");
INSERT INTO mfy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bueïtuk juebena géntem diáblom ámet kimúlatukäu tútüriai. Huámëi diablom éntok, kusisi chayeka ámet yeu sásakai. Entok juebena genteta káraktilamtaka, éntok lolöimtaka junne tútüriai. ");
INSERT INTO mfy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Júnëli béja huämi puéblopo sïme tüisim al‑léaka jiápsai. ");
INSERT INTO mfy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Senu yoreme áma aaney Simmom téaka, bannaataka juka móriata tekipánoaka huämi puéblopo, éntok juka genteta Samáriapo jometa baítáttähuakä, buere jita au täya tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sïmetaka at suaka ä jíkkajai, ríikom éntok polóobem junne, ínel jíaka: —Ï yoreme tua juka Diosta útteara jípure. ");
INSERT INTO mfy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tüisim ä nok jíkkajai, bueïtuk móriay bínhua táapo am bäitáttähuai. ");
INSERT INTO mfy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tëm ä susualek juka tü nokta Felípeta ámeu nokako, Diosta bem jiápsipo nésaunake bétana, éntok Jesucrístota téhuam bétana, oóhuim éntok jaámuchim júne emo batötebok. ");
INSERT INTO mfy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Huanäi jü Simmom kéchä súsualeka au batötebok. Huanäi jü Felípetamak naa hueetáitek, huame señáalim kaa jaibu johuámmet guómtilataka ä mabéttuanake. ");
INSERT INTO mfy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jume apóstolim buere joära Jerusalémpo aneme jünéaka jume Samáriapo joomem ket juka tü nokta Jesucrístota bétana huemta am mabétakähui, Perota éntok Juántam áman jaásek. ");
INSERT INTO mfy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ámanim yájaka Diostau buaanak jume Samariapo joomem tü nokta súsualekammet juka Espíritu Santota ayunakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bempo juka Señor Jesústa súaleka emo batötebolatukai, të jü Espíritu Santo ketune kaabetau jee kom yuumai. ");
INSERT INTO mfy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Huanäi juka Perota éntok juka Juanta choápo áme béppa mámtek, jü Espiírtu Santo ámeu kom yuumak. ");
INSERT INTO mfy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Huanäi jü Simmom jume apóstolim bíchaka jü gentetat choápo béppa mámteka juka Espíritu Santota am mabéttuayo, tómita am makróktaitek ");
INSERT INTO mfy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ínel ámeu jíaka: —Nechem kéchä makka júkäi uttearata, éläpone ínapo ket jábetat choápo béppa mámtek juka Espíritu Santota ä mabéttuanake. ");
INSERT INTO mfy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Huanäi Peero ínel au jiaahua: —Jü em tommi emo beu kaitäpo tahuánake, bueïtukë juka Diosta yore mikäu tómiay jíjinuhuä bénasë eiya. ");
INSERT INTO mfy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ï tékil kaa emo béchïbo näikiari, bueïtuk jü em jíapsi kaa türi Diosta bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Émoë jíapsi kúaktia kaa tühuata em éä béchïbo. Dióstahuë buaana, jamak júne enchi jiókorinake em juëna éerim béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bueïtukne jüneiya sïkara chibúraapo bénaku em anëhui, kaa türiku, éntok juka juënaraata peréesota súmatuka bénasi enchi jípurëhui. ");
INSERT INTO mfy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Huanäi Simmom ínel ä yómmiak: —Ino béchïbem Señortau oraciompo buan‑ria juka enchim inou nokákäu kaa inou huéenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Chúkula jume apóstolim juka Jesucrístota yákäu bem bíchakäu bétana noksuka, éntok Diosta noki bétana, yeu sájaka jum Samaria buíaräpo juebena puéblom bëkatana juka tü nokta Jesucrístota bétana huemta noókak. Huanärim júchi nóttek Jerusaléniu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chúkula, jü Señorta ángel Felípetau yepsaka ínel au jiaahua: —Jum suriu bíchë huéiye, jü böo Jerusalémpo kom bökamtachi, pueblo Gazä téäu bíchaa huémtachi. Ïri ájäria jü böo jum juya ániapo áman huéeme. ");
INSERT INTO mfy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Huanäi Felipe áman bíchaa siika. Jum ä huë páman éntok, senú yoremta Etiopíapo jometa bitchak. Ïri yoreme eunuko ti téttehuaahuai. Áapo buéresi tékiakai, jum Etiopíapo jámut yäut, Candace téamta, tomi suayai, të Jerusaléniu aaney áman oraciompo Diostau nok báreka. ");
INSERT INTO mfy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ïri yoreme nóttilataka hueiyei ä buíaräu bícha. Ä carropo yejsímeka jü libro profeta Isaíasta jïojtekäu noksimei. ");
INSERT INTO mfy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Huanäi jü Espíritu Santo Felípetau ínel jiaahua: —Jü karohuë rukte. ");
INSERT INTO mfy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Huanäi jü Felipe au rúkteka juka nokta jíkkajak jum Isaíasta libropo ä nokähui. Huanäi ä temajek: —¿Játchë at jüneiya jü em nokäubechi? ");
INSERT INTO mfy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Huä yoreme éntok, ínel ä yómiak: —Ëe, ¿jachisune at júnenake, bueïtuk kaabe nee ä téjhua mátchi? Huanäi Felípetau noókak áma ä jämuka áa náapo áa yejte sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Huä jïojteri ä noksímëu éntok, ínel jiaahua: Kabarata bénasi mëboka huériuhuay. Juka kabárata síkahuakä kaa áa buanä bénasi, kaa jíalek. ");
INSERT INTO mfy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ä tü yóremtukänásuk júne jiokot jo súuhuak, éntok kaa lútüriata yáariahuak. ¿Jábesu huame at yeu sákariam bétana noknake jäni? Bueïtuk ímï buíapo ä jíapsi úhuaahuak, tiahua hua jïojteri. ");
INSERT INTO mfy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Huanäi jü eunuko titéttehuaahuame Felípetau ínel jiaahua: —Nechë tejhua, ¿jábeta bétanasu íkäi nooka jü profeta, áa bétana o jábe táabuik bétana? ");
INSERT INTO mfy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Huanäi Felipe jïojterita ä nokäumak au ä naatek juka tü nokta Jesústa bétana huemta. ");
INSERT INTO mfy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Huanäi huam bäam ayúkä páman kateka jü eunuko titéttehuaahuame ínel jiaahua: —Imi bäam aika, ¿játchune kara imi batöhua? ");
INSERT INTO mfy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe ínel au jiaahuak: —Anáka chikti em jíapsimak enchi ä súaleyo. Huanäi hua yoreme ínel ä yommiak: —Jéehui, ínapo ä súale juka Jesucrístota Diosta tua ä Üusitukähui. ");
INSERT INTO mfy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Huanäi juka carrota kéchateboka, kom chéptekam náuhuichika bäau kiímuk. Huanäi Felipe ä batöak. ");
INSERT INTO mfy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Huam bäpo yéu am sájak, jü Señorta Espíritu juka Felípeta sékäna bíchaa nuksiika. Jü eunuko éntok, kaa júchi ä bitchak, të al‑leaka júchi ä böo nüka. ");
INSERT INTO mfy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jü Felipe éntok, jum Azótöpo aneka jünëak. Huanäi jum puéblom bëkatana huerámaka juka tü nokta Jesucrístota bétana huemta nookai. Júnensu pueblo Cesareau yépsak. ");
INSERT INTO mfy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo éntok, jíba bénasi huame Señorta súaleme suabáreka eiyai. Kíalïku hua tiöpopo chë nésauhuemtau siika, ");
INSERT INTO mfy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","jiösiata áu mak iäka útteata ä máknakemta Damascopo judíom nau yayajäpo kibákbáreka jume tü nokta Jesucrístota bétana huemta súaleme áma járiubáreka, am pereesoteka buere joära Jerusaléniu am huéria béchïbo, oóhuim, éntok jáamuchim junne. ");
INSERT INTO mfy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Të béja böot huéeka, huam pueblo Damascou jëla ä huéi, sej chukti téhueka bétana jü machiria útteaka kom sika, nate chíkola ä machíriak. ");
INSERT INTO mfy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Huanäi Saulo buíapo huétchek, éntok senuk au nokamta jíkkajak ínel jíamta: —Empo Saulo, ¿jatchíake nee guokjájase? ");
INSERT INTO mfy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Huanäi Saulo nátemajek: —¿Jábesaë empo, Señor? Huäri éntok, ínel au jiaahua: —Ínapone Jesús, hua em guokjájasëhui. Kíalë émpöisu kökosi emo johua, juka buesta sísïguok buahuita témmü bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo éntok, mauj‑rimmea au yoaka ínel jiaahua: —Énsu Señor, ¿jítasune yáanake? Jü Señor éntok, ínel au jiaahua: —Yejtékë áman pueblou huéiye. Huämïrë téjhuaana jita em yáanakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jume yorémem Sáulotamak katëu éntok, tüisi guómtek juka nokamta jíkkajaka të kaábeta bíchaka. ");
INSERT INTO mfy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Huanäi Saulo yejteka au puj étapok jiöbe, të kaa bíchaka taahuak. Huanäi jume áamak katéïhuim mampo ä buíseka ä nuksájjak jum Damascou bícha. ");
INSERT INTO mfy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Huämi aaneka baij táapo kaa bíchaka, kaa jïbuäka, éntok kaa jëyeka. ");
INSERT INTO mfy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascopo éntok, senu yoreme Jesucrístota súaleka jóakai Ananías ti téhuakä, huáahuï Señor au yeu machíriak tenkupo bénaku, éntok ínel au jiaahua: —¡Empo Ananías! Áapo entok ínel ä yommiak: —Imne aane, Señor. ");
INSERT INTO mfy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Huanäi jü Señor júchi ínel au jiaahua: —Huä böo Derecha ti téhuaakamtau bíchë huéiye. Huanärë Judasta jóapo senu yoremta nátemaje Társopo jometa, Sáulo ti téhuakämta. Áapo oraciompo Diostau nooka éëni, ");
INSERT INTO mfy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","éntok senu yoremta Ananías ti téhuakämta, tenkupo bitchak au kibákeka choápo béppa at mámtekamta júchi ä bínnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Íkäi jíkkajaka Ananías ínel jiaahua: —Señor, juebénakam nee ettéjhuariala ïri yoremta bétana, jáchin machisi huaka kaa tühuata jume enchi súalemmeu ä yáakä bétana jum Jerusalémpo. ");
INSERT INTO mfy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Én éntok imï äbo yebísise útteata máktaka jume tiöpopo tékiakammeu nésauhueme bétana sïme huame enchi yöreme peréesoteka am huéria báreka. ");
INSERT INTO mfy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Të jü Señor ínel au jiaahua: —Ámanë huéiye, bueïtukne júkäi yoremta yeu púala ino bétana ä noknakë béchïbo, jume judíommehui, éntok kaa judíommeu junne, éntok bem réyimmehui. ");
INSERT INTO mfy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ínapone au ä yéu machírianake sïmeta ä jünérianakë béchïbo jáchin machisi yuun jiókot máchiraata ä bínnakëhui nee ä súalekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Huanäi Ananías áman siika jum Sáulota anëhui. Au yepsaka, choápo béppa at mámteka, ínel au jiaahua: —Empo Saulo ín hermáano, jü Señor Jesús, hua böot em huë páman emou au yeu machíriakame, nee äbo emou jaásek júchi bénasi enchi bínnakë béchïbo, éntok juka Espíritu Santota émot ayúnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Huanäi seep puj beata bénaka sóokteka kom huáttek, ínëli júchi bíchaka taahuak. Huanäi Saulo kíkteka batöhuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chúkula béja jïbuäka júchi úttëutuk. Huanäi jaiki táapo jäni jume Jesucrístota súaleme Damascopo jóakammak taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Huanäi béja Saulo jum judíom nau yayajäpo jume géntemmeu noktáitek juka Jesústa tua Diosta Üusi tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sïme jume ä jíkkajakame at guómteka tahuak, éntokim ínel jiaahua: —¿Jatchu kaa ïri yoreme ínel jum Jerusalémpo jume Jesústa súaleme guokjájaseïhui? ¿Jatchu kaa ïri hua äbo yepsaka am peréesoteka am huéria báareïhui jume tiöpopo tékiakammeu nésauhueme mampo am joa báreka? ");
INSERT INTO mfy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Të Saulo chëhuasu kaa májhueka ámeu nooka, am jünéetuaka juka Jesústa Crístotukähui Diosta yeu púari. Júnëli jume judíom Damascopo jóakame béja kaachin anmáchiakai. ");
INSERT INTO mfy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Juebena taáhuarim simsuk, jume judíom nau ettéjhuakä juka Sáulota mëbábarek, ");
INSERT INTO mfy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","të áapo ä jüneriak. Taáhuarit tukáarit naabúrujtim jum puértampo pueblou kíkimuhuäpo ä jójottuai ä mëbáreka. ");
INSERT INTO mfy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Të jume Jesucrístota súaleme jum buëuru huäripo ä yéchaka, tukáapo jü taapia yari puéblota chíkola bökamta huáitana kömä yétchak. Júnëlim áma yeu ä huikkek. ");
INSERT INTO mfy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusaléniu yepsaka jume Jesucrístota súalemmeu rúkteka ámemak anbáarei jiöbe, të sïme ä majhuëi kaa jünéaka áapörik béja juka Jesucrístota súalëhui. ");
INSERT INTO mfy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Të júnentaka júne Bernabé áman ä nuk sika jume apóstolimmeu ä täyatebok, am ettéjhuariak jachin Saulota Señorta bíchakähui jum böochi, éntok jachin Señorta áapöriku, Sáulotau, ä nokákähui, éntok jachin áapörik, Sáulota, kaa májhueka Jesústa bétana géntemmeu ä nokákähui jum Damascopo. ");
INSERT INTO mfy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Huanäi jübua Saulo Jerusalémpo taahuak, éntok ámemak naa hueetáitek. ");
INSERT INTO mfy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kaa májhueka Señorta bétana nookai jume griego nókammak ettéjhuakä, éntok ámemak nok nássuaka. Të ímëi jachin ayuka bem ä mënakeu jaríai. ");
INSERT INTO mfy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Huame hermáanom éntok, íkäi jüneriakam Sáulota buere joära Cesareau tójjak, huämi éntokim buere joära Tarsou bíchaa ä bíttuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Huanäi huámechi taáhuarimmet jume Jesucrístota súaleme jum Judea buíaräpo, Galiléa buíaräpo, éntok Samaria buíaräpo aneme yantelakam al‑leaka jiápsay, éntokim chëhuasu óusi eiyay. Diosta yörekam jiápsay, éntokim Espíritu Santota úttiäray chëhuasu emo büruriay. ");
INSERT INTO mfy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peero jume Jesucrístota súaleme bëkatana huerámaka jume pueblo Lídapo jóakammeu ket nóitek. ");
INSERT INTO mfy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Huämi senu yoremta bitchak Enéas ti téhuakamta, guojnaiki huásuktiapo kökoreka bökai, bueïtuk káraktilatukai. ");
INSERT INTO mfy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Huanäi Peero ínel au jiaahua: —Empo Eneas, Jesucristo em kökoa bétana enchi tüte. Yejtekë em at böyëu tóboktia. Huanäi Eneas sep yéjtek. ");
INSERT INTO mfy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ínëli sïme pueblo Lídapo jóakame ä bitchak, éntok jume pueblo Saronpo jóakame, éntokim juka bannaataka bem súalëu tójaka juka Señorta súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Huámechi taáhuarimmet jum pueblo Jópë teäpo senu jámmut aaney Jesucrístota súaleka Tabítä ti téhuaka, griego nokpo Dórcas tíau báare. Ïri jámmut jíba tühuata joaka jiápsai jume jiókot éame aníaka. ");
INSERT INTO mfy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Júnaksu éntok huámechi taáhuarimmet Dorcas kökori huécheka muúkuk. Chúkula jü ä takahua úbahuaka jum kari senuk béppa kátekäpo tékhuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jü pueblo Jópë tíame Lidau kaa mekka taahuai jum Perota anéïpo. Huanäi jume Jesucrístota súaleme jünéaka áapörik áma anëihui, guoi yorémemim au jaásek ínel au jiáu nésauhueka: —Láutë äbo huéiye ímï pueblo Jópehui. ");
INSERT INTO mfy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Huanäi Peero ámemak siika. Áman ä yepsákim jum kariu takáhuata bökäu ä nuk kiímuk. Huanäi sïme huame jámut jókoptulam áa chíkola tápunaka sóoti buaanai, éntokim huaka sánkota Dorcasta ketune jiápsaka ä supe yáarim ä bíttuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Huanäi Peero sïme huame áma aneme yeu sákatuaka, tónommia kíkteka Diostau oraciompo nookak. Huanäi huaka mukilata bíchaka ínel jiaahua: —Empo Tabita, yejtëe. Áapo éntok pujteka, Perota bíchaka, yéjtek. ");
INSERT INTO mfy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Huanäi mampo ä buíseka ä kétchak. Huanäi jume hermáanom éntok jámut jókoptulam núnuka bem bíchäpo ámeu ä kétchak jiápsamta. ");
INSERT INTO mfy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ïri sïme jü pueblo Jópepo jüneriatuk. Huanäi juebénakam Señorta súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Büru taahuarimpo huämi pueblopo taahuak, Peero, senu yoreme huaka beata búabualkotemta jóapo, Simmom ti téhuakame. ");
INSERT INTO mfy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jum Cesarea puéblopo senu yoreme Cornéliö ti téhuaka jóakai, sontaróapo senu batallón Italiana ti téhuaakapo capitántaka. ");
INSERT INTO mfy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Huäri yoreme tüisi tü yóremtukai, Diosta yörei, éntok sïme ä familiahua junne. Jume judíommeu yún tómita lilimojnay, éntok chikti táapo oraciompo Diostau nonokay. ");
INSERT INTO mfy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Séjtul kuptei, bájim jiai jäni, tenkumta bénasi éaka machisi juka Diosta ángel bitchak jum ä anëu au kibákeka, ínel au jíamta: —¡Empo Cornelio! ");
INSERT INTO mfy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Júnëli au ä jiai Cornelio éntok, tua at puseka taahuak tüisi guómtilataka. Chúkula béja ínel au jiaahua: —¿Jáchisë jiaahua, Señor? Jü Diosta ángel éntok, júchi ínel au jiaahua: —Huä oraciompo Diostau em nókähui, éntok limojna em yáari póobem béchïbo, Diosta bíchäpo türi. ");
INSERT INTO mfy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Láutë áman pueblo Jópe téäu yorémem jaáseka Símonta am núnutua, jú Peero ti ket téhuakamta. ");
INSERT INTO mfy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Áapo senu Simmom huaka beata búabualkotemta jóapo aane, bahue mayoat jóakame. Huäri enchi téjhuaanake jita em yáanakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Juka Diosta ángel simsuk, Cornelio guoi yorémem ä sáuhuëhuim núnnuk, éntok huépul sontarota tüisi Dios huáatemta éntok át ä jiapsekähui. ");
INSERT INTO mfy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Huámëi sïmeta huaka ä bíchakäu éntok ä jíkkajakäu am ettéjhuariasuka áman pueblo Jópë téäu am jaásek, Simmom Perota anéïhui. ");
INSERT INTO mfy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Yokóriapo ímëi yorémem béja hua pueblo Jópë téäu kaa mekka katéi, tua lúl‑la káteko Peero kárit bem áma kókocheú jikáu jämuk oraciompo Diostau nók báreka. ");
INSERT INTO mfy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Huanäi tüisi tébäureka jïbuä báarei, të juka buähuamta kee buasei, tenkumta bénasi éaka jita bitchak. ");
INSERT INTO mfy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kia sábanam bénam naiki eskinapo huitérekame téhueka bétana kom huéeme bitchak. ");
INSERT INTO mfy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Huämi sábanam bénaku huikíchim, éntok bakóchim, éntok sïme animáalim náikim guókekame kaatei. ");
INSERT INTO mfy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Huanäi senuk au nokamta jíkkajak ínel jíamta: —Peero, júmëi animáalimë súaka am buäye. ");
INSERT INTO mfy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Të Peero ínel ä yómmiak: —¿Jatchíaka, Señor? Ínapo jauhuey júne Diosta bíchäpo jaiti machik kaa buäla. ");
INSERT INTO mfy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Huanäi júchi ínel au jíamta jíkkajak: —Juka Diosta tütekahui katë jaiti máchï tíiya. ");
INSERT INTO mfy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ïri báisi nat chätuka au kom yúmak. Huanäi huame sábanam bénaka júchi téhuekau jikáu nóttek. ");
INSERT INTO mfy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Huanäi juka Perota jü ä bíchakäubet kaa ä al‑leai jítasu bénak huákäi nokbárëihui, jume yorémem Corneliota bétana au jaahuakame juka Símonta jóa nátemajeka kateme jü kári puertau yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Huanärim áman yájaka kusisi nokaka nátemajek senuk Simmom ti téhuakamta áma anë bétana, ket Peero ti téhuakame. ");
INSERT INTO mfy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Të juka Perota hua ä bíchakäubet ketune kaa ä al‑leai, jü Espíritu Santo ínel au jiaahua: —Baij yoremem im enchi jaría. ");
INSERT INTO mfy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kömë siká ámemak huéiye kaítat jachin éaka, bueïtuk ínapone emou am jaásek. ");
INSERT INTO mfy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Huanäi Peero ámeu kom siika huame yorémem Cornéliota au jaásekäumehui. Huanäi ínel ámeu jiaahua: —Ínapone ájäria jü enchim jaríähui. ¿Jítasem nübok? ");
INSERT INTO mfy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bempo ä yómmiak: —Jü capitán Cornélio äbo itom jaásek, ïri yoreme tü yóreme éntok Diosta yöre íkäi sïme jume judíom ä tü éttejhua, éntokim ä nakke. Senu Diosta ángel ä téjhuak enchi ä núnutebo sáhueka ä joau enchi hueë ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Huanäi Peero kariu am kimaka, áma am tahuáriak áamaki huäri tukarichi. Yokóriapo béja ámemak siika, éntok huate hermáanom Jópepo joome. ");
INSERT INTO mfy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Júchi yokoriapom béja Cesareau yájjak. Huämi Cornelio am boobíchaïhuii ä huahuájim éntok amiigom ä nákëhuim áman nau núnulataka. ");
INSERT INTO mfy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Juka Perota ä joau yepsak, Cornelio au yeu siká ä mabétak, éntok tónommia kíkteka ä yörek. ");
INSERT INTO mfy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Të Peero ä kétchak ínel au jíaka: —Kíktë. Katë inou mújmujte. Ínapo ket emo bénasi yoreme. ");
INSERT INTO mfy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Huanäi au noksímeka, kariu kibákeka juebena géntem áma nau yáij‑lame téuhuak. ");
INSERT INTO mfy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Huanäi ínel ámeu jiaahua: —Eme jüneiya itom jume judíom, hua itom boojóriäu béchïbo, kaa ä türiakähui jume kaa judíommak itom ito türinakëhui, éntok bem joau itom kíkkimunakëhui. Teé én jü Dios nee téjhuak íkäi ínëli huemta au tü yáak tíaka, itom kaachin ito érianakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kíalïkune téjhuaahuaka sep äbo siika kaachin éaka. Én éntokne jünee péiya jita béchïbo ín äbo núnuhuakahui. ");
INSERT INTO mfy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Huanäi Cornelio ínel au jiaahua: —Naiki taáhuarim huéiye ínapo imi ín jóapo aneka ayúunai, éntok kupteu bícha, ínneak jäni, nee Diostau oraciompo nokayo, itom ä boojóriä bénasi, senu yoreme béloj tópapäti anemta sánkoka inou au yeu machíriak. ");
INSERT INTO mfy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Huanäi ínel inou jiaahua: “Empo Cornelio, hua Diostau oraciompo em nokähui, éntok hua em limojna yáari póobem béchïbo Diosta bíchäpo türi. ");
INSERT INTO mfy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Láutë áman pueblo Jopë téäu yorémem jaaseka Símonta am núnutua, huaka ket Peero ti téhuakamta. Áapo senu Simmom huaka beata búabualkotemta jóapo aane, bahué mayóat jóakame. Huäri äbo yepsak enchi téjhuanake jita em yáanakëhui.” ");
INSERT INTO mfy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Júnëline sep áman enchi jaríutebok. Én éntoke itou yépsak. Tüisite enchi ä baisauhue. Ente sïme imi aane Diosta bíchäpo enchi nok jíkkaij báreka sïmeta juka Diosta enchi itou nok iähui. ");
INSERT INTO mfy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Huanäi Peero ínel ámeu jiaahua: —Én ál‑lane jüneiya lútula huëpo juka Diosta sïme yorémem nánancha ériähui, ");
INSERT INTO mfy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","éntok jita naciónpo ä jométuk junne juka ä yöremta éntok tühuata joamta ä nákëhui. ");
INSERT INTO mfy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios juka Jesucrístota jume Israelítammeu kom bíttuak, huaka sïmem béppa nésauhuemta, ámeu ä nok ïaaka yanti jíapsihuamta bétana. ");
INSERT INTO mfy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eme béja tüisi ä jüneria huaka judíom buíaräpo sïme át yeu sikamta jum Galiléa buíaräpo naateka juka Juanta jume géntemmeu noksuko éntok am batösuko. ");
INSERT INTO mfy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Éntokem jüneiya kétchi jachin Diosta Jesús Nazaretpo jometa Espíritu Santota útteara ä mikákähui, éntok jachin áapörik huaka tühuata josúkähui jum náasä sikäpo, éntok huame diáblota mampo aneka kökoreme ä tütekähui. Íkäi johuai bueïtuk Dios áamak aaney. ");
INSERT INTO mfy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ítapote sïmeta juka Jesústa yáakäu bitchak, kia huam Judea buíapo éntok Jerusalén puéblopo junne. Chúkula éntokim kúrusichä popónaka ä mëak. ");
INSERT INTO mfy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Të Dios júchi ä jíabitetuak baij taáhuata huéeyo, éntok itou yéä machíriatuak. ");
INSERT INTO mfy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kaa sïme géntemmeu au yeu machíriak, itou jíbba, huame bannaataka Diosta yeu púari én áa bétana nok ïaahuame. Ítapote kókoolam násuk ä jíabitesuk áamak jïbuäk, éntokte áamak baa jëka. ");
INSERT INTO mfy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Éntok itom téjhuak géntemmeu itom nok sáhueka, juka Diosta Jesústa ä yäut yéchakä bétana jume jiápsammet nokta ä chupa ïaka, éntok jume kókkolammechi. ");
INSERT INTO mfy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Éntok chë bannaataka ket sïme jume profétam ïri Jesústa bétana noókak sïme jume ä súaleme bem Dios bejrimmet bem jiókorinä tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ketune juka Perota ámeu nokaisu, jü Espíritu Santo sïme huame ä nok jíkkajammeu kom yuumak. ");
INSERT INTO mfy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Huame Israelitam Jesucrístota súaleme Perotamak áma yáij‑latukäu éntok, at guómtilamtaka taahuak juka Espíritu Santota ket huame kaa judíommeu júne kom yumák tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Júnëlim ámet jüneiyai juka Espíritu Santota ámeu kom yumákä bétana, täbui nokpo am nokái am jíkkajaka, éntok buéresi Diosta am úttileyo. ");
INSERT INTO mfy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Huanäi Peero ínel jiaahua: —¿Jatchu jábe ára ëe támeu jiaahua ímëi yorémem emo batönakë béchïbo? Bueïtuk jü Espíritu Santo ámeu kom yuumak itou kömä yúmakä bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Huanäi Jesucrístota bem súalekä béchïbo am batö nésauhuek. Chúkulam Perotau nookak elapo jaiki tápo júne ámeu ä tahuá sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jume apóstolim, éntok jume huate hermáanom Judea buíaräpo anéïhuim, juka noktam jíkkajak kaa judíomtaka junne ket juka tü nokta Jesucrístota bétana huemta súalekähui. ");
INSERT INTO mfy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Huanäi juka Perota júchi Jerusaléniu yepsak, jume judíom Jesucrístota súaleme ä béj‑reka nookai. ");
INSERT INTO mfy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Akim ä temajek: —¿Jatchíake huame kaa ito bénasi judíommak aaney, éntoke ámemak jïbuäk? ");
INSERT INTO mfy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Huanäi jü Peero ä naatekäpo naateka sïmeta huaka áma yeu sikamta am ettéjhuariaka, ínel jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ínapo jum pueblo Jópë teäpo aaney, huanäine Diostau buanaka tenkumta bénasi éaka jita bitchak. Huämïne kia jita buëuru sábanam bénam bitchak téhueka bétana kom huéme, naiki eskinampo huitérekame, inou kom nóinoiteme. ");
INSERT INTO mfy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Huanäine am bíchaka jítasu áma ayuk jäni ti éaka ámet suúhuak. Júmëisune animáalim náikim guókekame júyapo joomem áma bitchak, éntok bakóchim, éntok huikíchim. ");
INSERT INTO mfy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Huanäine senuk ínel inou jíamta jíkkajaka: “Peero, ímeí animáalimë súaka am buäye.” ");
INSERT INTO mfy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tëne ínel au jiaahuak: “Ëe Señor, ínapo jauhuey júne juka Diosta bíchäpo jaiti machik kaa buäla.” ");
INSERT INTO mfy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Huanäine júchi ínel inou jíamta jíkkajak: “Juka Diosta tü yákähuë kaa jaiti máchï tíiya.” ");
INSERT INTO mfy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ïri báisi nat chätuka inou ayúak, huanäi sep huame sábanam bénaka júchi téhuekau jikáu siika. ");
INSERT INTO mfy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Huanäi huämi orapo baij yorémem jum jóapo ín anëpo yájjak, pueblo Cesarea bétana áman jaataka nee jaríu sáihuaka. ");
INSERT INTO mfy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Huanäi jü Espíritu Santo ámemak nee huee sáuhuek kaítat jachin éaka. Imey busan hermáanom éntok, ínomak sájjak. Sïmetakate senu yoremta jóapo yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Huäri itom ettéjhuariak jachin juka Diosta ángel ä jóapo huéekamta ä bíchakähui ínel au jíamta: “Yorémeme áman pueblo Jópë téäu jaase. Simmom Peero ti téhuakamtam núnunake. ");
INSERT INTO mfy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Áapo enchi téjhuanake jachin em emo jínëunahuëhui, enchi éntok sïme em familia.” ");
INSERT INTO mfy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ínëli nee ä ettéjhuariasuk, ínapo ámeu noktáitek. Huanäi sep jü Espíritu Santo ámeu kom yuumak itou kömä yúmakä bénasi júnak jübua ä naateyo. ");
INSERT INTO mfy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Huanäine hua Señorta nokibeu huáhuaatek ínel jíamtahui: “Jü Juan bäammey yore batöak, të Dios täbuiasi enchim batönake juka Espíritu Santota enchimmeu kom yumátuaka.” ");
INSERT INTO mfy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Juka Diosta junëli nánancha itom ériaka bempörim juka Espíritu Santota makkak, ket itom ä mikakä bénasi Jesucrístota itom súaleko, ¿jábesa ínapo Diosta béj‑reka ín huéenakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Huanäi jume hermáanom buere joära Jerusalémpo aneme íkäi jíkkajaka nok yáatek, éntokim Diosta úttileka taahuak ä yáari béchïbo ínel jiaka: —¡Júnëli ket Dios huame kaa judíommeu júne juka bem jíapsi kúaktinakeu ámeu yumátuak yu jíapsihuamta am jájamnakë béchïbo! ");
INSERT INTO mfy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Juka Estebanta mësuak jume huate Jesucrístota súaleme guok jájataitiak. Huanäi huate maujhueka ténnek Fenícia buiärau bícha, isla Chipreu bícha, éntok Antioquíau bícha. Ámanïrim juka tü nokta Jesucrístota bétana huemta nookai, teé judíommeu jíbba. ");
INSERT INTO mfy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Të huate Jesucrístota súaleme Chíprepo jométaka, éntok Cirénepo jométaka, jum Antioquía pueblou yájaka béja kaa judíommeu júne ä noókak juka tü nokta Jesucrístota bétana huemta. ");
INSERT INTO mfy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jü Señorta uútteara ámet ayukai, kíalïku juebénaka juka bannaataka bem súalëu tójaka juka Señorta súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jume Jesucrístota súaleme Jerusalémpo anéïhuim íkäi jíkkajaka juka Bernabeta jum Antioquíau jaasek. ");
INSERT INTO mfy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé áman yepsaka ä bitchak juka jachin machisi juka Diosta tühuata ámeu yáalatukähui. Huanäi tüisi al-léaka taahuak, éntok sïmemmeu noókak bem jíapsi tutti yécharika Señorta éä páman am katchahueka. ");
INSERT INTO mfy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bueïtuk áapo, jü Bernabé, tü yóremtukai, éntok jü Espíritu Santoy tapuniakai, éntok chikti ä jíapsimak Señortat éiyay. Júnëli juebena géntem jíapsi kúaktituak Señortau bícha. ");
INSERT INTO mfy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chúkula Bernabé pueblo Tarsou bíchaa siika Sáulota áman jaríuseka. Huanäi ä téaka Antioquíau bíchaa ä nuk siika. ");
INSERT INTO mfy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ámanïrim jume Jesucrístota súalemmak aanek huásuktiapo, juebena genteta majtíaka. Huämi Antioquíapom kësam huëpo cristiánom ti téhuatuahuak jume Jesucrístota súaleme. ");
INSERT INTO mfy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Huámechi taáhuarimmet huate profétam Jerusalém bétana Antioquíapo yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Senu yoreme Agabo ti téhuaka, jume hermáanom násuk kíkteka, Espíritu Santota éäpo noókak buere tébaata sïme buíarat ayúnake tíaka. Huäri buere teba lútula huëpo siika rey Claudiota nésauhuë taáhuarimmechi. ");
INSERT INTO mfy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Huanäi jume Jesucrístota súaleme Antioquíapo anéïhuim, hueepulaka bem yumäpo, huame Jesucrístota súaleme Judéa buiärapo aneme anía rókaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Júnëlim ayuka, juka ofrendata nau tójaka huame yoiyöturi Judéa buiärapo anemmeu jäbuekammeu ä bíttuak Bernabétamaki éntok Saulotamaki. ");
INSERT INTO mfy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Huámechi taáhuarimmet jü rey Herodes huate Jesucrístota súaleme guokjájataitek. ");
INSERT INTO mfy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jacobota juka Juanta saayi ejparammea mëtebok. ");
INSERT INTO mfy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Huanäi jume judíom al‑léaka tahuák tíaka, juka Perota ket peréesotebok. Ïri yeu siika tua pajko táapo, jume páanim kaa levadúrakame buabuähuä táapo. ");
INSERT INTO mfy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Të jü rey Herodes juka Perota cárcelpo yéchatebok dieciséis sontarom ä suáyatuaka, ínel éaka, chúkula pajkota chúpuk puéblota bíchäpo yéä tóij báreka. ");
INSERT INTO mfy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Júnëli jü Peero páttiatukai éntok tüisi suáyahuai, teé jume Jesucrístota súaleme jíba Diostau oraciompo ä nok‑riay chikti bem jíapsimaki. ");
INSERT INTO mfy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yokoríapo juka Heródesta jum puéblota bíchäpo yéä tóijnakei, huäri tukáarit Peero kotchei guoi sontarom násuk bökari, guoi cadenammea súmataka. Huate sontarom éntok, puértapo jäbueka cárcelta suayai. ");
INSERT INTO mfy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Huanäi sej chukti jü Diosta ángel áma yepsaka, juka cárcelta machíriaka, jü Perotat sánäpo mámteka ä bússaka, ínel au jiaahuak: —Lautë yejte. Huanäi jume cadenam mampo ámey ä súmatukau bútteka kom huáttek, ");
INSERT INTO mfy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jü ángel éntok ínel au jiaahua: —Emoë huikojtua, éntoke em berä bochampo guókte. Juka Perota au bochátuasuk jü ángel ínel au jiaahua: —Jínteke ino sáu huéiye. ");
INSERT INTO mfy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Huanäi Peero ángelta sáu yeu siika, kaa jünéaka tua ä lútüriatukähui juka ángelta joähui. Kíal ä tenkutukä bénasi ä ériai juka ä bíchähui. ");
INSERT INTO mfy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Te jume sontarom bat jäbuekame huam sájaka, éntok júchi huam jëla jäbuekame huam sájaka, sísïguok puertauhuim yájjak böóu yeu kathuäpo. Huanäi hua puerta au étapok. Huanärim yeu sájjak. Chúkula senu cálleta sákasuka jü Diosta ángel áapolaik tösiika. ");
INSERT INTO mfy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Huanäi Peero jünéaka ínel ëeak: —Én ál‑lane jüneiya ä lútüriatukähui Señorta ä ángel inou bíttuakähui Heródesta mampo nee ä jínëunakë béchïbo, éntok hua sïme bétana judíom inou yáa bárëhui. ");
INSERT INTO mfy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ínëli éaka jü Peero Maríata joau bíchaa siika, jü Juan Márcos téamta áiye, ámani juebena géntem nau rúktilataka Diostau oraciompo nookay. ");
INSERT INTO mfy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Áman yepsaka, juka puértata ä ponái, senu jámmut beme, Ródeé ti téhuaka, áman yeu siika ä bit báreka ä jábétukähui. ");
INSERT INTO mfy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Të juka Perota nok tátäyaka, juka puértata kaa étapoka, chikti ä al‑léerimmak búitek áman huaijhua bíchaa am téjhua báreka juka Perota jum puértapo huéktíaka. ");
INSERT INTO mfy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Huanärim ínel au jiaahua jü ili jámuttahui: —¡Rokótuläe! Të áapo ä lútüria tíiya ä ájäriatukähui. Të bempo júchi ínel au jiaahua: —Kaa ájäria, ál‑la jü ä ángelhua. ");
INSERT INTO mfy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Të jü Peero áma huéeka jíba puértata poonai. Huanärim juka puértata étapoka ä bíchaka guómtek. ");
INSERT INTO mfy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Të áapo mámammea séñata ámeu yáuhuak kaa am jíal sáhueka. Huanäi am ettejhuariak jachin juka Señorta cárcelpo yéä nuksikähui: —Juka Jacobotem ettéjhuaria íno bétana éntok jume huate hermáanom. Huanäi yeu siika sékäna bícha. ");
INSERT INTO mfy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yokóriapo yeu mátchuk, buéresi jiáihuai jume sontarom násuku, bueïtukim kaa jüneiyai jachin juka Perota jum cárcelpo yeu sikähui. ");
INSERT INTO mfy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Huanäi jü rey Herodes ä jaríutebok. Kaa ä téihuak éntok, jume sontarom ä suáyaïhuim núnuteboka am temájek jatchíaka bem yéu ä simtúakähui. Kaa emo am jüneä tiai éntok, am súatebok. Chúkula jü Herodes Judéapo yeu siká, jum Cesaréau bíchaa áman joa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jü Herodes huame géntem puerto Tiropo jomemmeu tüisi oómtei, éntok puerto Sidonpo jomémmehui. Huanäi bempo juka buähuamta reyta buíapo bem mabétä béchïbo au sájjak áamak ettejhua báreka. Huanärim Blástotamak emo nok tütek, hua rey Heródestau nésauhuemtahui, éntokim al‑léaka jíapsirókaka au noókak. ");
INSERT INTO mfy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Huanäi Herodes taáhuata am yéchariak nau am nunurókaka. Juka taáhuata yúmak, béja yörisi machisi sánkoteka huam ä nésauhuëpo yejteka ámeu noókak. ");
INSERT INTO mfy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Huanäi jü génte ä úttileka ínel chaáyek: —¡Ï nokame kaa kia jábe yoreme, áapo jü dios! ");
INSERT INTO mfy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Huämi orapo jü Señorta ángel juka Heródesta kökori tátabek, bueïtuk Diosta bénasi au ä ériai tíaka, éntok Diosta kaa yörek. Huanäi buíchiatuka muúkuk. ");
INSERT INTO mfy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Të jü Señorta noki jíba sïmekut nokhuai, éntok jume ä súalekame chëhuasu bürusakai. ");
INSERT INTO mfy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé éntok Saulo, jukam nésauta chúpaka, buere joära Jerusalém bétana pueblo Antioquíau nóttek, Juanta huériaka Márcos ti ket tehuakamta. ");
INSERT INTO mfy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jum pueblo Antioquíapo jume Jesucrístota súalemmakim aaney jume profétam éntok huate am majtíame. Jume áma anéïhuim Bernabé, éntok Símon, Négrö tíame, éntok Lucio, pueblo Cirénepo joome, éntok Manaén jü Herodes Galiléa buiärapo nésauhuemtamak yötukame, éntok Saulo. ");
INSERT INTO mfy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Séjtul ímëi ayúunaka entok oraciompo Diostau am nokayo, jü Espíritu Santo ínel ámeu jiaahua: —Bernabetem nee yeu púaria, éntok Sáulota, hua tekia ín áme béchïbo näikiata bem yáanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Huanärim ayúunasuka éntok oraciompo Diostau noksuka, choápo áme béppa mámteka Diosta mampo am joaka áman am bíttuak. ");
INSERT INTO mfy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Huanäi Espíritu Santota éäpo Bernabé éntok Saulo Seleuciau bícham sájjak. Huämïrim barcopo bäau huáttek isla Chípreu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jum puerto Salamínau yájaka juka Diosta noki jume géntemmeu noókak jum judíom sinagogapo. Juan éntok, am aníasimeka ket ámemak huéiyey. ");
INSERT INTO mfy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Huämi íslapom naa burujti sájaka Páfou yájjak. Huämïrim senu judío Barjesús ti téhuakamtau yájjak. Ïri móriäkai, éntok profeta aranókïchitukai. ");
INSERT INTO mfy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ïri móriära hua áma nésauhuemtamak aaney, Sergio Páulö téamtamaki. Ï Sergio Paulö éntok, tüisi koba súakai. Áapo, jü nésauhueme, juka Bernabeta núnutebok, éntok juka Sáulota, juka Diosta noki jíkkaij báreka. ");
INSERT INTO mfy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Të jü móriära Barjesús, Elímas ti téhuakame, am béj‑reka kíktek, juka nésauhuemta kaa Diosta noki sual ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Huanäi jü Saulo, ket Páblo ti téhuakame, Espíritu Santoy tapunika, tua pújpo ä bíchaka, ");
INSERT INTO mfy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ínel au jiaahua: —¡Empo aranókïchi, juëna yóreme, diáblota yoremia, sïme tühuata béj‑reka huéeme! ¿Jatchíake jíba kaa ä tojja juka Señorta noki lútula huemta em kaa lútüriä tíähui? ");
INSERT INTO mfy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Én éntok, jü Señor jiókot enchi yáanake. Kaa bíchake tahuánake. Jaiki táapë täata kaa bínnake. Huanäi sep läuti kaa máchira au yuumak. Huanäi jábeta júne jaríai mampo ä buíseka ä huérianakemta, bueïtuk kaa bitchai. ");
INSERT INTO mfy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Huanäi jü gobernador íkäi bíchaka, ä súaleka taahuak, bueïtuk hua yore majtíahuame Señorta bétana huémtat guómtek. ");
INSERT INTO mfy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo éntok jume áamak réjtëhuim isla Páfou barcopo bäau huátteka jum pueblo Pérgehuim yeu yájjak Panfília buíaräpo. Të Juan am tösiká buere joära Jerusaléniu bíchaa nóttek. ");
INSERT INTO mfy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Chúkula bempo jum pueblo Pérgepo yeu sájaka pueblo Antioquíau bícham sájjak, Pisidia buíarähui. Huämïrim jimyore táapo judíom nau yayajäpo kimuka áma joótek. ");
INSERT INTO mfy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Huanäi juka Moiséjta ley noksúak, éntok jume librom profétam jïojtekäu noksúak, jume áma tékiakame ínel nokta ámeu bíttuak: —Eme itomak huéerim, nokta türik jume géntemmeu enchim nokmátchik huériätekem ámeu ä nooka ëni. ");
INSERT INTO mfy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Huanäi Pablo kíkteka, mámammea séñata yáuhuak kaa am jíal sáhueka. Huanäi ínel jiaahuak: —Íkem nokta jíkkaja, eme Israelíitam éntok sïme jume Diosta yöreme: ");
INSERT INTO mfy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jü pueblo Israelíitata Dios jume itom yóyöhuam bannaataka kateme yeu púuhuak, éntok buëuru pueblosi am yáuhuak ketune Egiptopo am aneyo, huam kaa bem buíaräpo. Huämi buíaräpo yéu am nuksiika ä úttiärayi. ");
INSERT INTO mfy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios cuarenta huásuktiapo see päria ániapo am núnübuaka tüisi am ujük, ");
INSERT INTO mfy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","éntok guoi busan naciónim tejálek Canaán buíaräpo anéïhuim, juka buíata itom yóyöhuam mak báreka. ");
INSERT INTO mfy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Juka buíata am máksuka, naiki ciento cincuenta huásuktiapo yäuram am jóariaka am sáuhuek, juka profeta Samuelta yeu machíakäpo tajti. ");
INSERT INTO mfy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Huanäi bempo reyta áahuak am sáunakemta. Dios éntok, juka Sáulta reypo am yéchariak cuarenta huásuktiapo, huaka Cis ti téhuakamta üusi, Benjaminta huáhuairapo jometa. ");
INSERT INTO mfy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Chúkula Dios jum tékiapo juka Saulta yeu jímmaaka, Davidta reypo am yéchariak, huaka ínel áa bétana ä nokákähui: “Davidtane jüneria sïme ín nésauhui ä jonákëhui. Ïri yoreme hua tua ín türëu benna.” ");
INSERT INTO mfy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ïri Jesús ínel Davidta huáhuairapo jométukai, jü Diosta tóboktiakähui jume Israelíitam ä jínëunakë béchïbo, bannaataka ä nokakä bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kee jee juka Jesústa yepsái, jü Juan sïme jü pueblo Israéltau noókak útteatukähui jíapsi kúakteka bem batöna bétana. ");
INSERT INTO mfy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jü Juan béja ä muknákëu bítchimei ínel jiáhuak: “Eme jamak nee jü Crísto tíiya, jü Diosta yeu púari, të ínapo kaa ájäria. Chúkula yebíjnake huäri, hua kaa júnen machik jotúahuamta bénasi maachi ä bíchäpo. Kíane ä bocha huíkyam júne kaa búttiapo yúmala.” ");
INSERT INTO mfy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Eme ínomak huéerim, Abrahamta huáhuairapo joome, éntok sïme huame Diosta yöreme: itou sïmemmeu bíttuari ï tü nooki ái itom ito jínëunakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jume Jerusalémpo jóakame éntok bem yäura júne kaa jüneiyai juka Jesústa jábétukähui, éntokim hua nókit júne kaa jüneiyai profétam jïojtekäbechi chikti jimyore táapo jum bem sinagogampo ámeu nonókhuamtachi. Të Jesústam mëtebok, huämi chúppuk hua nooki bem jíjikkajaïhui. ");
INSERT INTO mfy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kia kaita béttesi machik ä mëtebonakemta at téaka júnem Pilátotau noókak ä mëtebo sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Huanärim béja sïmeta huaka jïojtepo áa bétana nokamta chúpukim kúrusit ä poponaka ä maäak. ");
INSERT INTO mfy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Të Dios kókkolam násuk ä jíabitetuak. ");
INSERT INTO mfy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Huanäi juebena táapo Jesús huame yorémemmeu au yeu machíriak, huame Galiléa buiärapo naateka buere joära Jerusaléniu tajti áamak rejtísukammehui. Huámëi ínel jume én géntemmeu nokame áa bétana. ");
INSERT INTO mfy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Júnëlituk, ítapo enchim ä jünériatua juka tühuata Diosta itom yóyöhuammeu nätuakähui. ");
INSERT INTO mfy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Bueïtuk ítohui, jume ámet yeu sákariammeu ä chúppak juka ä nokákähui juka Jesústa jíabitetuaka, libro Salmo teäpo guoyiku ínel jiäpo bénasi: “Empo ájäria jü ín üusi. Én táapone sïmemmeu enchi yeu buíssek enchi ín üúsitukä bétana.” Júnëli jïojteri. ");
INSERT INTO mfy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jü Dios jünéehuamta nénkilatukai áapörik jum kókkolam násuk ä jíabitetuanake bétana ä takahua kaa nasóntunakë béchïbo, jum jïojteripo ínel jíaka: “Enchímmeune ä chúpanake juka tühuata Davidtau ín nätuakähui.” ");
INSERT INTO mfy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Éntok täbui libro Sálmopo ket ínel jiaahua: “Júkë em yeu púari takahua suáyanake kaa ä nasóntunakë béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jünéate lútula huëpo juka Davidta huame áa beu jiápsakaïhuimmet ä tekipánoakähui Diosta ä sáuhuekä pámani, éntok mukuka ä mäáhuakähui ä yóyöhuam bénasi, éntok ä takahua nasóntukähui. ");
INSERT INTO mfy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Të hua Diosta jíabitetuakäu takahua kaa nasóntuk. ");
INSERT INTO mfy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Júnentukem jüneiya, eme ínomak huéerim, áapörik, Jesústa, béchïbo huame enchim Dios bejrimmet enchim jiókorinä bétana enchimmeu nokhuähui. ");
INSERT INTO mfy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bueïtuk jü Jesústa béchïbo ínel sïme huame ä súaleme jiókorihua bem Dios bejrimmechi, Moiséjta ley bétuk aneka kaa bem at jiókorihuakähui. ");
INSERT INTO mfy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Áachem suuhua kaa enchimmeu chúpanake hua profétam jïojtekäu ínel jíame: ");
INSERT INTO mfy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jítachem suuhua, eme jábeta junnériäram. Áachem guómteka kókko. Bueïtuk ínapo, jü Dios, jume taáhuarim enchim ámet jíapsáubet buériata yáanake kaa súalmatchik, emë éntok, kaibu ä súalnake juka ín yáanakëhui, jábeta enchimmeu ä ettejhuay junne. ");
INSERT INTO mfy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Juka Pablota éntok jume áamak rejteme jum judíom nau yayajäpo yeu sájak, huame kaa judíom ámeu noókak júchi áma jimyore táapo íäri bétana jíba ámeu am nok sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Huame bem nau yáij‑läpo huemta chúpuk, juebénaka jume judíom éntok huame Dios huáateme judíommak éaïhuim Pablota sau sajjak, éntok Bernabeta. Bempo éntok, ámeu nökak jíba Diosta tühua ámeu yáaribet chäka am jíapsi sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Júchi jimyore taáhuata yúmak, jume puéblopo jóakame sïme jëla áma nau rúktek Diosta noki jíkkaij báreka. ");
INSERT INTO mfy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Të jume judíom juka juebena genteta nau rúktekamta bíchaka ä ínnëaka taahuak, éntokim juka Pablota béj‑reka noktáitek, éntokim jájana ä aahuai. ");
INSERT INTO mfy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Huanäi jü Pablo éntok Bernabé kaa májhueka ínel ámeu jiaahua: —Útteatukai jiöbe juka tü nokta Jesucrístota bétana huemta enchimmeu, eme jume judíommeu, bat itom ä noknákëhui. Të béjasem kaa ä jíkkaij báare, éntokem juka yu jíapsihuamta kaa huáatia, huame kaa judíommeu bíchate kannake. Huámehuïte ä noknake. ");
INSERT INTO mfy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bueïtuk jü Señor junëli itom sáuhuek, ä noki jïojteripo ínel jíaka: Machiriata bénasine enchi tahuáriala jume kaa judíom béchïbo, huaka tü nokta ái bem emo jínëunakeu enchi huérianakë béchïbo jakun buíata yumäu tajti, tiahua. ");
INSERT INTO mfy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Íkäi jíkkajaka, jume kaa judíomtukähuim al‑léaka taahuak, éntokim juka tü nokta Señorta bétana huemta türitíiyai. Huanäi sïme huame yu jíapsinake téaka näikiari juka nokta súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Júnëli jü Señorta tü nooki sïme huaa buíarat nókhuak. ");
INSERT INTO mfy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Të jume judíom huate jaámuchim Dios huáateme éntok chë áma täyahuame nok téjhuak am béj‑reka japte sáhueka, álë bénasi ket jume yorémem puéblopo chë yörihuame. Huanärim juka Pablota guokjájaseka, éntok Bernabeta, bem buíaräpo yéu am béebak. ");
INSERT INTO mfy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Huanäi jü Pablo éntok jü Bernabé juka tóröchiata guokpo ámet chätulata ámeu tátakek señalpo bénasi bem kaa áma türihuä béchïbo. Huanärim sájjak Iconiö téäu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Të jume Jesucrístota súaleme áma aneme jíba al‑leiyai éntok jü Espíritu Santo ámet ayukay. ");
INSERT INTO mfy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jum Iconiopo, Pablo éntok Bernabé jume judíom sinagogapo nau kiímuk, huanärim tüisi jiápsipo huéchemta jume géntemmeu noókak, junëli juebena judíom éntok kaa judíom júne ä súaleka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Të huame judíom juka nokta kaa súalekame huame kaa judíommeu nokaka jume hermánommeu bíchaa juënak am ëetuak. ");
INSERT INTO mfy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Të bempo jíba áma taahuak büru táapo, éntokim jíba kaa májhueka ámeu noókak Señórtat éaka. Jü Señor éntok, juka tü nokta Diosta bétana huemta bem nokäu lútüria johuai útteata am mákaka kaa jaibu johuamta at guómtisi machik am jotúaka. ");
INSERT INTO mfy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Të hua génte áma puéblopo joome au näikimtek. Huate jume judíom beu eiyai, huate éntok, jume apóstilim béuchi. ");
INSERT INTO mfy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Huanäi huame judíom éntok huame kaa judíom junne, yäurammak nau nokaka, nánancha ëeak buere am áusuka am mamáasu báreka. ");
INSERT INTO mfy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Të jü Pablo éntok Bernabé jünéaka áma yeu sájjak pueblo Lístrau bícha, éntok Derbeu bícha, Licaónia buíaräpo jokámmehui, éntok huate buiära áa chíkola tahuámtau bícha. ");
INSERT INTO mfy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ámanïrim ket juka tü nokta ái yore jínëihuamta bétana noókak. ");
INSERT INTO mfy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jum Lístrapo senu yoreme aaney kara huerámaka. Ïri yoreme kia kátekai bueïtuk löitaka yeu tómtilatukay. ");
INSERT INTO mfy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ïri juka Pablota nokäu jíkkajak. Jü Pablo éntok, at pujteka at suuhuai, éntok Diosta ä súaleka au ä türinakeu bétana ä jünériaka, ");
INSERT INTO mfy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kusisi ínel au jiaahua: —Tüsë ámet kikte jume em guókimmechi. Huanäi jü yoreme jikáu chépteka huéeka taahuak éntok naa hueetáitek. ");
INSERT INTO mfy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Huanäi hua génte juka Pablota yáakäu bíchaka, chaitáitek Licaónia nokpo ínel jíaka: —¡Diósim yorémem bébénaka itou kom yájjak! ");
INSERT INTO mfy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jukam Bernabeta jü dios Júpiter tíiyai, Pablota éntokim dios Merkúriö tíiyai báchä nonokä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jum pueblou kimúhuäpo jü Júpiterta tiöpo katekay. Huä áma tiöpopo nésauhueme éntok, jume torom áma yeu tóijtebok éntok sehuata koróona yáata. Áapo, éntok hua génte, buéresi am yörï báreka, toromim súa báarei ámeu am limójnaka am pajkória báreka. ");
INSERT INTO mfy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Të jume apóstolim, Bernabé éntok Pablo, íkäi jüneriaka, kaa ä tútüreka bem sánkom síusíuti huíkeka chayeka genteta násuk kiimuk: ");
INSERT INTO mfy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡Ëe, oóhuim! ¿Jatchiakem íkäi johua? Ítapo ket yorémem enchim bénasi. Ítapo äbo sájjak enchim téjhuaboka íkäi enchim boojóriäu kaita béj‑remta tójaka huaka Dios jiápsamta enchim yörinakë béchïbo, huaka téhuekata yáakamta, buíata, bahueta, éntok sïme huaka áma ayúkamta. ");
INSERT INTO mfy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bannaataka Dios sïme huame kaa judíom kia tójjak, huanäi naatekam jita júne yöritáitek. ");
INSERT INTO mfy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Të jíba tühuata ámeu joaka am téttejhuai am jüneenakë béchïbo áapörik jábétukähui. Áapo juka yúkuta itou bibittua, éntok áapörik béchïbo hua echi chúchupe. Huaka itom buänakeu itom mímika, éntok sïmeta ái itom al‑lénakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ínëli jume géntemmeu jíaka júnem batte kaa am tóijtuak juka torom áme béchïbo bem súanakëhui, éntok bem buéresi am pajkórianakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Huanäi huate judíom Antioquía bétana éntok Iconio bétana áma yájaka, juka genteta kúaktiak am béj‑reka am kannákë béchïbo. Huanärim juka Pablota sussutti máiyak. Béjam emo ä mëak tíaka, huam puéblopo päkun yeu ä tójjak ä huík sákaka. ");
INSERT INTO mfy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Të jume Jesucristota súaleme emo nau tójaka áman áa chíkola nau am rúktek, yejteka júchi ámemak jum pueblou kibákek. Yokóriapo béja jü Bernabétamak siika Dérbë téäu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jum Dérbepo juka tü nokta ái emo jínëihuamta bétana noksuka, éntok juebena jíapsim kúaktiaka, pueblo Listrau bíchaa nóttek, pueblo Iconiou bíchaa éntok pueblo Antioquíau bícha. ");
INSERT INTO mfy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Huämi puéblompo jume Jesucrístota súaleme óusi éetuak, éntokim ámeu noókak jíba bénasi juka Jesucrístota am súal sáhueka. Éntokim am téjhuak jum Diosta nésauhuëpo anbárëtek, imi buíapo juebena jiókot máchiraata bem bínnakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jume Jesucrístota súaleme anëbëkatanam éntok, jume yoiyöturim yäut jóiyak. Huanärim ayúunasuka, Diostau nokaka jü Señor bem súalëuta mampo am jóiyak. ");
INSERT INTO mfy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chúkulam jum Pisidia buiära páman sájaka Panfília buíarau yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jum Pérge pueblopo juka tü nokta Jesucrístota bétana huemta nokaka puerto Atáliau bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Huämïrim barcopo bäau huátteka pueblo Antioqüiau bíchaa sájjak, áman íkäi tékiata én bem chúpakäu yaä ïaahuaka, Diosta mampo bem jóahuakähui. ");
INSERT INTO mfy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jum Antioquíau yájakam jume Jesucrístota súaleme nau núnnuk. Huanärim sïmeta huaka Diosta am aníakä béchïbo bem yáakäu am ettéjhuariak, éntok jachin machisi juebena kaa judíom júne juka Señorta súalekähui. ");
INSERT INTO mfy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Huanäi Pablo éntok Bernabé huämi tahuak juebena táapo jume Jesucrístota súalemmaki. ");
INSERT INTO mfy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Huámechi taáhuarimmet huate yorémem Judéa bétana Antioquíau yájaka jume hermáanom áma jóakame ínel majtia táytek: “Jínëutu bárëtekem emo circuncidaroatebo, Moiséjta nésauhuekä pámani.” ");
INSERT INTO mfy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Huanäi Pablo éntok Bernabé buéresi huámëi yorémemmak nok nássuak íkäi bem am majtíä béchïbo. Júnensu bempo, Pablo éntok Bernabé, éntok huate yorémem, yeu púahuak jum Jerusaléniu kat ïaahuaka íkäi yore majtíahuamta bétana huame apóstolimmak éntok jume Jesucrístota súalemmeu yäut yóyarimmak nau áa ettéjhua sáihuaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Huanäi huame Jesucrístota súaleme Antioquíapo jóakame am boo tójjak. Bempo éntok, sájaka Fenicia buiära páman kateka, éntok Samaria buíara pámani, am ettéjhuariak jachin huame kaa judíom júne huaka bannaataka bem súalëu tójaka Diosta bem súalëhui. Huanäi sïme huame hermáanom tüisi al‑léaka taahuak íkäi nokta türik jíkkajaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Huanäi Pablo éntok Bernabé Jerusaléniu yájaka tüisi mabéthuak jume Jesucrístota súaleme bétana jume apóstolim bétana éntok huame yoiyöturi yäut jóarim bétana. Huanärim sïmeta am ettéjhuariak huaka bem yáakäu Diosta am aníakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Të huate pariseerom éntok, Jesucrísota súaleme, jápteka ínel jiaahua: —Úttea jume kaa judíom Jesucristota súaleme emo circuncidaroatebonakëhui, éntok juka Moiséjta nésauhuëu itom am boojoria sáunakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Huanäi jume apóstolim éntok jume yoiyötori yäut jóarim nau emo tójjak íkäi nau lútüria yáa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Huanäi juebénasi nau noksúak, jü Peero kíkteka ínel ámeu jiaahua: —Eme jüneiya, ín hermáanom, juka Diosta jakhuéy nee yeu púakähui enchim násuku, huame kaa judíommeu íkäi tü nokta ái bem emo jínëunakeu nee nok ïaaka, bempörim ä súalnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios jume jíapsim jünériame jünéehuamta nénkak áapörik am nákëhui, juka Espíritu Santota am mikaka ket itom ä mikákäpo bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios kaábeta yeu púaka sïmem nánancha itom eria. Bempörim jíapsi ket tü yáuhuak Jesucrístota bem súalekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ensu, ¿jatchíakem juka Diosta béj‑reka kateka imey Jesucrístota súaleme íkäi béttesi machik jotúa báare, juka ito béchïbo béttesi maáchik, éntok itom yoiyöhuam béchïbo júne bettiakäuta? ");
INSERT INTO mfy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Bueïtuk ítapo juka Señor Jesústa ito béchïbo áa jíapsi ä nénkaka itom jínëutukäu súale, éntok bempörim júne junëli jínëutukähui, kaa juka Moiséjta nésauhuëu joaka junne. ");
INSERT INTO mfy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Huanäi sïme nok yáateka juka Bernabeta éntok Pablótam nok jíkkajak huaka at guómtisi machik kaa jaibu johuamta bétana am nokayo, Diosta úttiäray bem yáakähui huame kaa judíom násuku. ");
INSERT INTO mfy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Am nok yáatek, Jacobo ínel jiaahua: —Eme ín hermáanom, nechem jíkkaja: ");
INSERT INTO mfy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simmom Peero béja itom ä ettéjhuariasuk jachin juka Diosta bat huëpo huame kaa judíommeu tühuata yáakähui, éntok jachin bempörim násuk juka puéblota yéä püakähui ä yörinakemta. ");
INSERT INTO mfy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ïri ínëli huéeme huame profeetam jïojtekä páman huéiye, ínel jíame: ");
INSERT INTO mfy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Íäri sáune júchi yebijnake; huanäine juka Davidta yäura huéchilata tóboktiaka júchi ä nésautuanake. Huaka tahuakamtane tóboktiaka bemelasi ä yéchanake, ");
INSERT INTO mfy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","simë jume huate yoremem jü Señortau am rúktinakë béchïbo, éntok sïme jume kaa judíom ín yeu püakähui. ");
INSERT INTO mfy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ínëli jiaahua jü Señor: “Íkäi jünériatebome, jáksä táapo naateka jäni.” ");
INSERT INTO mfy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Júnëli jïojteri: Kíalïku ínapo ä türi máchileka, huame kaa judíom kaa muksi éetua nésahue, huaka bannaataka bem súalëu tójaka, Diostau bíchaa jíapsi kúakteme. ");
INSERT INTO mfy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kíal ámeu jïojtehuak, júnene türi máchile, am téjhuaaka kaa éntok huaka ídolom béchïbo näikiata bem buänake bétana, éntok kaa emo jubekätek kaa emo am huáatianake bétana, éntok animal bámsuata huakas kaa bem buänake bétana, éntok kia ójbota junne. ");
INSERT INTO mfy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bueïtuk sïme huam pueblom jokäpo, jáksä táapo naateka aaney, huame Moiséjta ley am mamajtíame, íäri bétana nokamta, hua chíkti jimyore táapo judíom sinagogapo nonokhuame. ");
INSERT INTO mfy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Huanäi jume apóstolim éntok jume yoiyötori yäut jóarim, jume huate Jesucrístota súaleme nau yáij‑lammak nau nokaka, huátem áme násuk yeu puarókaka taahuak, jü Pablótamak éntok Bernabétamak Antioquíau am kannákë béchïbo. Huanärim juka Judas Barsabasta yeu púuhuak, éntok juka Silasta, jume hermáanom násuk tüisi yörihuame. ");
INSERT INTO mfy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Huanärim juka jiösiata ámemak áman bíttuak ínel jíamta: “Ítapo jume apóstolim, éntok jume yoiyöturi yäut jóarim, éntok huate hermáanom, jume itom hermáanom kaa judíommeute tebote, jum Antioquíapo jomémmehui éntok jum Siria buíaräpo jomémmehui éntok Cilicia buíaräpo. ");
INSERT INTO mfy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jünéate huate yorémem ímï bétana áman enchimmeu sákalatukähui kaa itom nésaupo éntok bem nokíai enchim muksi am éetuähui, éntok echim áma jióptua báreka úttiä tíaka enchim emo circuncidaroatebonakëhui, éntok Moiséjta ley nokäu enchim boojorianakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kíalïkute nánancha éaka ä türeka taahuak huate yorémem ito násuk yeu púaka enchimmeu itom am bíttuanakëhui, jü Bernabétamaki éntok Pablótamiki, jume hermáanom tüisi itom nákëhuimmaki, ");
INSERT INTO mfy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","jume bem jíapsi nénkilame itom Señor Jesucrístota tékil bem boojóriabarë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Júnëlite juka Judasta éntok Silasta enchimmeu jaase bempörim ket jíba íäri bétana enchimmeu noknákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bueïtuk jü Espíritu Santo ínëli itom ä téjhuak, ítapo éntok, ä türeka taahuak, kaa huátek béttesi machik enchímmet yéchatunakëhui huaka enchimmeu türik machik jíbba: ");
INSERT INTO mfy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kaa juka animal huakajta ídolom im buíapo diósimeu limójnata enchim buänakëhui, kia ójbota junne, éntok animal bámsuata huaakas; éntok kaa emo jubékätek kaa enchim emo huáatianakëhui. Íkäi ínëli huemta kaa jóätekem tüisi annake. Áapo, Dios, enchim aníanake.” ");
INSERT INTO mfy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Huanäi jume íkäi jiösiata huériame sájaka Antioquíau yájjak. Huämïrim sïme hermáanom nau núnuka juka jiösiata am mákkak. ");
INSERT INTO mfy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Huanäi jume hermáanom huákäi jiösiata nokaka tüisi al‑lëak türik nokta áma huë tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jü Judas éntok Silas profétamtukaimme, kíalïkum jume hermáanom al‑léetuak, éntokim óusi am éetuak juebénak türik ámeu nokaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chúkula jaiki táapo áma am anéi, jume hermáanom al‑léaka Diostau am buaníaka júchi bíchaa am sákatuak huame áman am jaásekammeu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Të jü Silas áma taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jü Pablo éntok Bernabé kéchim áma taahuak jum Antioquíapo, yore majtíaka huate juebénammaki, éntok juka tü nokta Jesucrístota bétana huemta ámeu nokaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Chúkula jaiki taáhuarim huéi, jü Pablo Bernabetau ínel jiaahua: —Júchi éntokte jum puéblompo Diosta noki itom noksúkäu nóitinake jume hermáanom jüneria béchïbo jachin bem emo bíchähui. ");
INSERT INTO mfy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jü Bernabé juka Juan Márcosta ámemak hueë ïai, ");
INSERT INTO mfy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","të jü Pablo kaa ä türimáchilei, bueïtuk áapo jum buiära Panfíliapo am tösiká kaa juka tékilta bem huériäu ámemak chúppak. ");
INSERT INTO mfy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bürukim nau noókak kaa nánancha éaka, júnensum emo näikimtek. Jü Bernabé juka Juan Márcosta nuksiká Chíprë bíchaa barcopo bäau huétchek. ");
INSERT INTO mfy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo éntok, juka Silasta yeu púaka, yeu siika hermáanom bétana Señorta mampo yéchahuaka. ");
INSERT INTO mfy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Huanäi Siria buiära páman siika éntok Cilicia buíarapámani, jume Jesucrístota súaleme óusi éetuaka. ");
INSERT INTO mfy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jü Pablo éntok Silas jum pueblo Dérbeu yájjak éntok pueblo Lístrahui. Huämïrim senu yoreme Jesucrístota súalemtau yájjak Timotéo téamtahui, jámmut judía Jesucrístota súalemta asóabehui, të jü ä áchaihua griégotukai. ");
INSERT INTO mfy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jume hermáanom Listrapo joome éntok Iconiopo joomem türik áa bétana nookay. ");
INSERT INTO mfy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Huanäi jü Pablo juka Timoteota ámemak huë ïaaka ä circuncidaroatebok, jume judíom áma aneme kaa omtï ïaaka, bueïtuk bempo jüneiyay, juka ä áchaihuata griegotukähui. ");
INSERT INTO mfy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Huanäi sïme puéblompo bem katë pámanim jume hermáanom téjhuak juka apóstolim yáa nésahuëhui éntok jume yoiyötori yäut jóarim buere joära Jerusalémpo aneme yáa nésahuëhui. ");
INSERT INTO mfy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Júnëli huame Jesucrístota súaleme chë júne ä súaleka tahuaka chëhuasu útteata nüyei, éntokim chikti táapo chëhuasu emo büruriai. ");
INSERT INTO mfy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jü Espíritu Santo jum Asia buíaräpo juka tü nokta Jesucrístota bétana huemta kaa am nok ïay. Júnëli jü Pablo éntok jume áamak kateme Frigia buiära páman sájjak éntok Galacia buiärapámani. ");
INSERT INTO mfy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Huanärim Misia buiärata yumäu yájaka Bitíniä buiärau bíchaa katbábarek, të Jesústa Espíritu kaa áman am kat-ïay. ");
INSERT INTO mfy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Huanärim Míisiapo bóula sájaka, Troas puertou kom yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Huämi jü Pablo tukáapo tenkumta bénasi éaka juka yoremta bitchak Macedónia buíaräpo jometa au huéeka jiókot ínel au jíamta: “Macedooniahuë siká itom anía.” ");
INSERT INTO mfy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Juka Pablota júkäi bíchak, itote lijtaroa táytek, Macedooniau bíchaa kat báreka, lútüriapo juka Diosta itom áman núnü tíaka juka tü nokta Jesucrístota bétana huemta áman itom nok ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ínëlite jum pueblo Tróaspo barcopo bäau huátteka jum isla Samotracia lúl‑la sájjak. Yokoriapote béja pueblo Neápolisiu yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Huämite jum pueblo Filíposiu bíchaa sájjak. Ïri éntok colonia romáanotukai, jum Macedonia buíaräpo jü pueblo chë buëuru. Huämite jaiki táapo jäni aanek. ");
INSERT INTO mfy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Séjtul jimyore táapote jum pueblopo yeu sájjak bathué mayoau bícha, huam chikti jakhuéi genteta Diostau oraciompo nonokhuähui. Huämite joteka jume jaámuchim áma nau yájakammeu juka tü nokta Jesucrístota bétana huemta noókak. ");
INSERT INTO mfy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Huépülaka Lídia téhuaka pueblo Tiatírapo jométaka. Áapo juka sanko finota lilata nénenkai. Ïri jámmut Diosta yöreme tüisi jü nókit suaka ä jíkkajai. Jü Señor éntok, juka Pablota nokäu ä jiápsipo yumáriak tüisi ä suálnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Huanäi áapo batöhuak sïme ä famíliammak nauhui. Chúkula béja ínel itou jiaahua: —Eme tua chikti ín jíapsimak nee Señorta sualmáchilëtekem ín joau sájaka jaiki táapo júne áma aane. Huanäi útteapo jëla áma itom tahuáriak. ");
INSERT INTO mfy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Séjtul, Diostau oraciónta jojohuäu bíchaa itom katéi, senu ili jámmut itom nankírika siika diáblota at anë béchïbo yore jünériaka. Áapo ä teko jóapo sáihuai éntok jábeta jünériaka yuun tómita kokobai ä tékom béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ïri ili jámmut jü Pablota sáu naa hueetáitek éntok ito sauku, chayeka ínel jíaka: —Ímëi yorémem ínel juka Diosta yörisi máchik nésahui joléerom, éntokim jachin ayuka enchim jínëutunake bétana enchim tejhua. ");
INSERT INTO mfy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Büru táapo ínëli aaney, júnensu Pablo kaa tua al‑léaka, au nótteka hua diáblota at anemtau ínel jiaahua: —Jesucrístota nésaupone jü ili jámutat enchi yeu huee sauhue. Huanäi jü diablo huämi orapo áa tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Të huame ili jámutta tékom kaa éntok tómita ái bem kóbanakeu jünériaka, juka Pablota éntok Silasta buíseka yäurau yéu am tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Huämïrim yäurapo yéu am tóij‑lataka ínel jiaahua: —Ímëi oóhuim judíomtaka itom pueblo au tóboktitua, ");
INSERT INTO mfy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","éntokim huaka kaa itou chäkamta itom majtía itom ä boojoria ïaaka, bueïtuk ítapo romaanom. ");
INSERT INTO mfy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Huanäi jü génte am béj‑reka jáptek. Jü yäura éntok, am sanko joateboka jibebiammey tüisi am bemmuchatebok. ");
INSERT INTO mfy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Am bemmuchasukam cárcelpo am jóiyak, juka cárcelta suáyamta tüisi am suaya sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ïri éntok íkäi nésauta mabétaka chë huáijhua am kiímak éntok tabla guójöku am guóktetuak, kaa bem sákanakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Të tukáa násuk huei jü Pablo éntok Silas Dióstahuim oraciompo nookai, éntokim hímnom buiikai Diosta úttileka, huate pereesom éntok, am jikkajai. ");
INSERT INTO mfy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Huanäi sej chukti jü buía tüisi áu yoyoak, éntok jü cárcel junne. Huanäi jume cárcel puertam sïme emo étapok éntok jume cadeenam sïme pereesom ámey súmatukau júne búttek. ");
INSERT INTO mfy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jü am suáyame éntok, búsaka jume puértam emo étapolame téaka, ejparam yeu huíkkek au mëbáreka, jume peréesom yeu ténnek jäni tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Të jü Pablo at cháchayeka ínel au jiaahua: —Kátë jachin emo johua. Sïmete ím aane. ");
INSERT INTO mfy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Huanäi jü am suáyame machíriata aáhuaka, búiteka ámeu kibákek, éntok máuj‑rimmea au yoaka Pablota éntok Silasta guokpo ámeu au jímmak. ");
INSERT INTO mfy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Huanäi yéu am nuksiká ínel ámeu jiaahua: —Eme oóhuim, nechem tejhua, ¿jáchisune ayúnake jäni ín jínëutunakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bempo éntok ínel ä yómmiak: —Juka Diosta itom Señor Jesucrístota bétana nokähuë súale, huanäre jínëutunake, empo éntok jü em familia. ");
INSERT INTO mfy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Huanärim juka tü nokta Jesucrístota bétana huemta au noókak éntok sïme jume ä jóapo anémmehui. ");
INSERT INTO mfy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Huämi orapo tukáapo jü am suáyame jum bem kökosi yáapo am báksiak. Huanäi áapo éntok sïme ä famíliahua batöhuak. ");
INSERT INTO mfy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Chúkula ä joau am nuksiká am jïbuätuatebok. Huanäi áapo éntok jü ä famíliahua tüisi al‑léaka taahuak Diosta noki bem súalekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yeu matchuk jü yäura jume porisim áman jaásek jü am, suáyamtahui am búttia nésahueka. ");
INSERT INTO mfy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jü am suáyame éntok, Pablotau ínel jiaahua: —Yäurata bétana noki inou bíttuahuak enchim búttia sáihuaka. Júnentukem ára yeu kaate kaítat jachin éaka. ");
INSERT INTO mfy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Të jü Pablo jume porisimmeu ínel jiaahua: —Itom románomtuk júnem sïme puéblota bíchäpo itom bemmúchatebok, éntokem cárcelpo itom jóatebok kaa bat juka nokta itot chúpaka. ¿Én éntokem éhuil itom búttia báare? Kaa junëli huéiye. Éläpo bempo äbo sájaka itom yeu bébnake. ");
INSERT INTO mfy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jume porícim jume yäuram íkäi téjhuak, bempo májhueka taahuak am románomtukä bétana jünëaka. ");
INSERT INTO mfy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Huanärim jü Pablotau noókak éntok Silástahui emo jiókori nésahueka. Huanärim yéu am sákatuak, éntokim jiókot ámeu jiaahua jum puéblopo yéu am katcháhueka. ");
INSERT INTO mfy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Cárcelpom yeu sájaka Lídiata joau bíchaa sájjak. Huanärim jume hermáanom bítchuka éntok kaa köm am ée sáhueka ámeu noksuka sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Jü Pablo éntok Silas jum Anfípolis buiärapo áman sájjak éntok Apolóniä buiärapámani, jü pueblo Tesalónicäu bícha. Huämi kari kátekai jume judíom nau yayajäpo. ");
INSERT INTO mfy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jü Pablo jíba ä boojóriä bénasi áman siika jum judíom nau yayájähui. Huämi baij semáanapo ámeu noókak chikti jimyore táapo, áa béucham ée ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Diosta noki jïojteripo nokamta ámeu nookai juka Crístota, Diosta yeu púari, jiókot ayúnake bétana éntok mukuka ä jíabitenake bétana: —Júntuk ïri Jesús ín áa bétana enchimmeu nokäu ájäria Cristo, Diosta yeu púari. ");
INSERT INTO mfy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Huanäi huate judíom ä súaleka tahuaka jü Pablótamak chätuk éntok Silástamaki. Éntok juebena griégom Dios huáateme ket ä súaleka taahuak, éntok juebena jaámuchim jum puéblopo chë yörihuame. ");
INSERT INTO mfy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Të huame judíom kaa ä súalekame ámechä ínnëaka taahuak. Huanärim jume juëna yóremem kaita tékilekame nau núnuka, emo am tóboktituak. Huanäi jum puéblopo buéresi naa muksi huéeme siika. Jü yoreme Jasón téamta jóapom útteapo kiímuk juka Pablota jaríaka éntok Silasta, áma yéu am huíkeka jü genteta mampo am joa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tem kaa am téaka juka Jasonta buíseka ä huíksakaka ä nuksájjak, éntok huate hermáanom, yäurau yéu am tóijboka. Huanärim chayeka ínel jiaahuay: —Ímëi yorémem sïme ániat juka genteta kaa al‑léetuame äbo ket yáij‑la. ");
INSERT INTO mfy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jü Jasón entok, ket ä jóapo al‑léaka am mabétak. Sïme bempo juka Césarta romapo reyta ley béj‑reka kaate, bueïtukim täbui reyta nésauhuë tíiya, juka jábe Jesús téamta. ");
INSERT INTO mfy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Íkäi jíkkajaka jume géntem éntok jume yäuram júne emo tóboktiak. ");
INSERT INTO mfy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Të jü Jasón éntok jume huate hermáanom juka Pablota éntok Silástam sákatuarókaka noókak. Huanärim tómita nénkak jum yäurapo ä tóij báreka bem am sákatuäu tajti áma ä órenakë béchïbo. Huanärim búttiahuak. ");
INSERT INTO mfy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Huanäi jume hermáanom seep huäri tukáarit juka Pablota éntok Silasta áma yeu sákatuak pueblo Beréäu bícha. Bempo éntok, áman yájaka jíba jum sinagogau bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ímëi judíom áma joome éntok, chë tü jiápsekai huame Tesalónicapo joomem béppa. Kíalïkum juka tü nokta al‑léaka mabétak. Huanärim chikti táapo juka Diosta noki jïojterit suuhuai huaka nokta ámeu nokhuamta áma jünéria báreka lútüria jäni ti éaka. ");
INSERT INTO mfy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Júnëli juebena judíom ä súaleka taahuak, éntok griégo jaámuchim jum puéblopo chë yörihuame éntok juebena oóhuim. ");
INSERT INTO mfy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Të jume judíom Tesalónica pueblopo joome jünéaka juka Pablota jum Beréapo tü nokta Jesucrístota bétana huemta nokähui, ámanim sájaka buéresi naa muksi huemta áma yáuhuak. ");
INSERT INTO mfy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Të jume hermáanom bamsipo juka Pablota bahué mayoau bíchaa simtúak. Jü Silas éntok, áma taahuak jum Beréapo, éntok jü Timoteo. ");
INSERT INTO mfy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jume Pablótamak sájakaïhuim jum buëuru pueblo Aténas teäpo ä tójjak. Huanärim nóttek nokta huériaka juka Silasta éntok Timotéota lauti jëla áman Pablotau am yáijnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jü Pablo jum Atenaspo aneka juka Silasta boobíchaka éntok Timotéota, tüisi kaa al‑leiyai jum puéblopo juebena dios yorem yáarim ayúk tíaka, éntok juka genteta áma jometa am yörë tíaka. ");
INSERT INTO mfy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kíalïku jume judíommeu nookai jum sinagogapo éntok huate ámemak chäkammehui, Diosta emo yörë tíammehui, áa béucham ée ïaaka. Éntok jíba chikti táapo huame plázapo nau yayájammeu ket nonokai. ");
INSERT INTO mfy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Huate yorémem juka epicúreota yore majtíäu huériame. Éntok jume estóicosta yore majtíähui, áamak noktáitek. Huate ínel jiaahua: —¿Jáchisu itou jia jäni ï yoreme nónnokame? Huate éntok, ínel jiaahua: —Kia tattäbui diósim bétana nokamta benna. Júnëlim jiaahuay bueïtuk juka tü nokta Jesústa bétana huemta ámeu nookai éntok jume kókkolam jíabitenake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Huanärim áman Areópagö ä nuksájjak, huam bem nau yayájaka nokta bem lútüria jojoähui. Huanärim ínel au jiaahua: —Itómë tejhua ä jítatukähui íkäi bemela yore majtíahuamta em huériähui. ");
INSERT INTO mfy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Bueïtukë kaa itom jíjikkajäu itou nooka, ítapo éntok, ä jünéria báare jachin em itou jiaubárëhui. ");
INSERT INTO mfy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Júnëlim au jiáhuak bueïtuk sïme jume Atenaspo joome, éntok jume kaa áma jométaka áma jóakaïhuim, kaítat éntokim chë jiápsekai hua bemela huemta bem jikkaijnakeu jíbba éntok bem ä ettejhuanakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Huanäi jü Pablo huame Areópagopo aneme násuk kíkteka ínel jiaahua: —Eme öhuim Atenaspo joome, enchímmetne suuhua tüisi enchim dios huáatëhui. ");
INSERT INTO mfy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Bueïtukne jum diósim enchim yóyörë bëkatana huerámaka senu altárit jïojteta ínel jíamta bitchak: “Jü Dios kaa täyahuamta béchïbo yáari ïri altar.” Ïri Dios kaa enchim ä täyaka júne enchim ä yörë bétanane enchimmeu nooka. ");
INSERT INTO mfy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Ïri Dios íkäi ániata yáuhuak éntok sïme at ayúkamta. Áapo juka téhuekata átteak éntok juka buíata, éntok kaa tiöpo yorem yáaripo jóuhuak. ");
INSERT INTO mfy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kaa huame yorémem jita áa béchïbo yáanakeu huáatia, jita au bëye bénasi. Bueïtuk áapo ájäria jü jíapsihuamta yore mikame, jekata éntok sïmeta juka itom huáatiähui. ");
INSERT INTO mfy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Áapo huépul yoremta im buíapo jünakteka sïme genteta at yeu sákatuak, sïme ániat am jóanakë béchïbo, jaiki taáhuarim bemámet jíapsinakeu am téjhuaaka, éntok nátepoa jak tua bem jóanakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Im buíapo am jünaktek áapörik, juka Diosta, jaríaka bem ä téunakë béchïbo. Lútüriapo áapo itou huëpulammeu kaa mekka ane jiöbe. ");
INSERT INTO mfy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bueïtuk áapörik úttiärayte jiápsa, naate kaate, éntokte ketune im buíapo aane. Ket huate koba súakame chë bannaataka imi enchim buíaräpo anéïhuim ínel jíakä bénasi: “Diosta famíliapote joome”, tíakame. ");
INSERT INTO mfy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Júntuksan ítapo Diosta famíliapo jométuk, katte juka Diosta famíliapo jométuk, katte juka Diosta oropo yáatukä bénasi éepo yúmala, éntok tomi tósalipo, éntok tétapo junne, juka yoremta ä éakäpámani. ");
INSERT INTO mfy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Jü Dios banaataka kat‑riapo jume yorémem jiókorek kaa áapörik bem täyäubechi, të ëni sïme yorémem ániat anemmeu nooka am jíapsi kúakti sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bueïtuk áapo taáhuata yéchala sïme ániat anémmet juka nokta chuparókaka lútüriata huëpámani, juka yoremta yéu ä púari yäut yéchaka. Íkäi nokta lútüria yáuhuak sïmem ä jünérianakë béchïbo kókkolam násuk ä jíabitetuaka. ");
INSERT INTO mfy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Juka kókkolam násuk jíabitehuamta bétana nokamta jíkkajaka, huate ä junnériai, huate éntok, ínel jiaahua: —Jauhueeka jübuë íäri bétana itou noknake. ");
INSERT INTO mfy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Huanäi jü Pablo am tösiika. ");
INSERT INTO mfy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Të huate yorémem ä súalekame áamak sájjak. Huámëi násuk aaney jü yoreme Dionísiö ti téhuaka jum Areópagopo tékiaka, éntok senu jámmut Dámaris ti téhuaka, éntok huaate. ");
INSERT INTO mfy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Chúkula, jü Pablo jum buere joära Atenaspo yeu siká jum pueblo Corintou bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Huämi senu judío Aquilä ti téhuakamta téuhuak, Ponto buíaräpo jometa. Kaa bínhuatuka jü Aquila éntok ä jubíahua Priscilä ti téhuaka Italia bétana áma yáij‑latukai. Ámanim yeu sájjak bueïtuk jü áma nésauhueme, rey Claudio ti téhuakame, sïme jume judíom jum romapo yeu sákatuak. Jü Pablo áman bem joau siika am bit báreka. ");
INSERT INTO mfy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Huanäi éntok ámemak áma taahuak ámemak tekipanua rókaka, bueïtuk áapo ket juka bempörim tekia tékiakai, jume lona kárim jojoai. ");
INSERT INTO mfy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Chikti jimyore táapo jü Pablo jum sinagogapo. Huämi ámeu nonokai áa béucham ëe íaaka, jume judíom éntok kaa judíom junne. ");
INSERT INTO mfy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Huanäi juka Silasta éntok Timotéota Macedonia bétana áma yájak, jü Pablo kaita éntok joaka juka tü nokta Jesucrístota bétana huemta jume géntemmeu nookai, machisi jume judíom tettéjhuaka juka Jesústa jü Crístotukähui bempörim boobíchähui. ");
INSERT INTO mfy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Të bempo ä béj‑reka japtetáitek, éntokim áa bétana jájana jiautáitek. Huanäi jü Pablo ä sanko tátakek; huäri séñatukai ä simbárë bétana. Huanäi ínel ámeu jiaahua: —Emeisu enchímmet ä tátabnake huaka nokta bétesi machik enchímmet chúpanähui. Ínapo béja juka Diosta nee enchimmeu nok ïäu enchimmeu nóksuk. Én éntokne huame kaa judíommeu bíchaa huéenake; huámëhuïne juka tü nokta noknake. ");
INSERT INTO mfy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Huanäi jum sinagogapo yeu siká senu yoreme Jústo ti téhuakamta joau bíchaa siika. Áapo ket Diosta yöyorei éntok jum sinagoga naapo jóakai. ");
INSERT INTO mfy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Huanäi jü Crispö ti téhuakame, sinagogapo nésauhueme, juka Diosta noki jíkkajaka juka Señorta súaleka taahuak éntok sïme jü ä famíliahua. Éntok ket juebénaka jum pueblo Coríntopo joomem juka tü nokta jíkkajaka ä súalek, éntokim emo batötebok. ");
INSERT INTO mfy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Huanäi jü Pablo tukáapo tenkumta bénasi éaka juka Señorta au nokamta jíkkajak ínel jíamta: —Kátë majhuë. Jíbë ámeu nooka, ");
INSERT INTO mfy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","bueïtuk juebénaka ímï puéblopo aane ín noki súalnakeme. Kátë jachin eiya. Ínapone émomak aane enchi suáyaka. Kaabe ára émot mámtenake juënak emou yáa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jü Pablo íkäi jíkkajaka áma taahuak jum Coríntopo senu huásuktia áma busan metpo, juka tü nokta Jesucrístota bétana huemta am majtíaka. ");
INSERT INTO mfy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Juka Galión ti téhuakamta jum Acaya buíaräpo yäuttuk, jume judíom huámechi taáhuarimmet jum Coríntopo nau éaka emo tóboktiak Pablota béj‑reka. Jum yäuraapom yéu ä tójaka ");
INSERT INTO mfy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","jü nésauhuemtau, Galióntau, ínel jiaahua: —Ï yoreme juka genteta áa béu éetua täbuiasi juka Diosta am yöri sáhueka, juka itom ley bej-reka. ");
INSERT INTO mfy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Juka Pablota nok báareisu, jü Galión jume judíommeu ínel jiaahua: —Íkäi béttesi machíako, o yore súahuamta bétana ä huei, ínapo enchim nok jíkkaij éiyey, jume romáanom ley huë bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Të ïri kia nokta bétana huéiye éntok jábeta téhuam bétana éntok enchim ley bétana. Eme ára ä tü yáuhua íkäri, bueïtuk ínapo kara enchim ä tü yáaria. ");
INSERT INTO mfy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Huanäi jum yäurapo yéu am bébtebok. ");
INSERT INTO mfy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Huanäi sïme jume griégom áma anéïhuim juka Sostenesta, judíom sinagogapo nésauhuemta jaatíaka ä bépsuk huämi yäurata bíchäpo. Të jü Galión kaita júne áa náapo huë bénasi eiya. ");
INSERT INTO mfy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Jü Pablo jíba áma taahuak huämi puéblopo juebena táapo. Chúkula béja jume hermáanom tebótuaka Síriau bíchaa barcopo bäau huétchek Priscila éntok Aquílätamaki. Jum pueblo Cencréapo aneka, kee barcopo bäau huécheka, lóbala au síkatebok ä nokákäu chupa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jum pueblo Efésö teähuim yájaka, jü Pablo juka Priscílata éntok Aquilata tösiká jum sinagogau bíchaa siika. Huanäi jume judíom huämi nau yayájammeu noókak. ");
INSERT INTO mfy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bempo éntok, au noókak júchi jaiki táapo áma ä tahuá sáhueka, të áapo kaa báarei. ");
INSERT INTO mfy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Huanäi am tösiika ínel ámeu jíaka: —Úttea juka pajkota jum buere joära Jerusalémpo huéenakemta ín bínnakëhui, tëne júchi enchimmeu nóttinake Diosta báareyo. Huanäi jum Eféso pueblopo barcopo bäau huécheka siika. ");
INSERT INTO mfy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Jum Cesaréa pueblopo yepsaka jü Pablo buere joära Jerusaléniu bíchaa siika áman jume Jesucrístota súaleme tebótua báreka. Huanäi pueblo Antioquíau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Chúkula jaiki táapo áma aneka, júchi yeu siká jum Galacia buíaräpo éntok Frigia buiärapo sïmem bekatana naa siika jume Jesucristota súaleme óusi éetuaka. ");
INSERT INTO mfy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Huámechi taáhuarimmet senu judío jum pueblo Efesopo yépsak Aapolos, jum pueblo Alejandríapo jométaka. Áapo ujyorisi ára nookai, éntok juka Diosta noki jïojteri tüisi täyai. ");
INSERT INTO mfy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Señorta nésahue páman tüisi majtíatukai, éntok tüisi at jiápseka jume géntemmeu nonokai, machisi juka Jesústa bétana huemta am majtíaka. Të áapo juka Juan Bautístata yore batöaka ä nonókäu jíba täyai. ");
INSERT INTO mfy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Júnëli jü Apolos kaa májhueka ámeu noktáitek jum sinagogapo. Të jü Priscila éntok Aquila, akím ä nok jíkkajaka, omot yéu ä nuk sájaka machisi ä téjhuak jachin chë tüisi ä huëhui juka Diosta lútüria. ");
INSERT INTO mfy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Huanäi juka Apoolojta jum Acaya buiärau bíchaa huee báarei, jume hermáanom óusi ä éetuak, éntokim jume Jesucrístota súaleme áman anemmeu jïojtek tüisi ä mabet nésauhueka. Huanäi jum Acayau yepsaka juebénam aníak jume Diosta éäpo juka tü nokta súalekame. ");
INSERT INTO mfy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sïmem jíkkajäpo machisi jume judíom tejhuai bem jióblataka katëhui hua nooki lútula huémtaayi bempörim kara éssöhui, Diosta noki jïojteri ámeu nokaka juka Jesústa jü Crísto tíaka hua bem boobíchähui. ");
INSERT INTO mfy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Juka Apolosta jum pueblo Coríntopo ä aaney, jü Pablo éntok jume buiäram jikat tahuammet naa siika, huanäi pueblo Efesou yépsak. Huämi huate Jesucrístota súaleme téuhuak tem Juan Bautístata yore majtíakäu jíba täyai. ");
INSERT INTO mfy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Huanäi ínel ámeu jiaahua: —¿Jachu jü Espíritu Santo enchimmeu kom yuumak juka tü nokta Jesucrístota bétana huemta enchim súaleko? Huanärim ínel ä yommiak: —Katchante júne ä jíkkaij‑latukai juka Espíritu Santota ayúkähui. ");
INSERT INTO mfy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Huanäi jü Pablo ínel am temájek: —¿Jáchisem batöhuak? Bempo ínel ä yommiak: —Juanta yore batöa pámani. ");
INSERT INTO mfy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Huanäi Pablo ínel júchi ámeu jiaahua: —Juan juka genteta batöai señalpo bénasi bem jíapsi kúaktekä béchïbo. Të kécham tetejhuai huaka chúkula yebíjnakëmta am súal sáhueka, huaka Jesústa, juka Crístota Diosta yeu púari. ");
INSERT INTO mfy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Íkäi nóktam jíkkajaka, juka Jesústa Diosta üúsitukäu súaleka batöhuak. ");
INSERT INTO mfy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Huanäi juka Pablota choápo áme béppa mámtek, jü Espíritu Santo ámet kom siika. Huanärim täbui nokpo noktáitek, éntokim juka nokta Diosta bétana huemta nookai. ");
INSERT INTO mfy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jume yorémem batöhuakame jíba tua sïme nau dócetukai. ");
INSERT INTO mfy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo jum baij metpo jum sinagogapo yéyepsai. Huämi ámeu nonokai kaa májhueka, jume géntem áabeu ée ïaaka Diosta nésahuëpo bétana ámeu nokaka. ");
INSERT INTO mfy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Të huate bem jíapsi námakasi joaka kaa ä súal báarei, al‑lam jájana jiaahuai juka Señorta lútüriatachi genteta jíkkajäpo. Huanäi Pablo am tösika, jume Jesucrístota súaleme nuk siika jum escuela Tiránnou bícha. Huámi chikti táapo am majtíai. ");
INSERT INTO mfy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Guoi huásuktiapo áma taahuak am majtíaka. Junëli sïme jume Asia buíaräpo joomem juka tü nokta Señor Jesústa bétana nokhuamta jíkkajak, judíom éntok kaa judíom junne. ");
INSERT INTO mfy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios éntok, juka Pablota buéresi kaa jaibu johuamta jotúai. ");
INSERT INTO mfy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Júnëli jume páayum éntok sanko júne jü Pablota takáhuat jálojtekame jume kökoremmeu tóijhuay, am tutütey, bem kökoa bétana, jume diáblom yorememmet aneme júne yeu sásakay. ");
INSERT INTO mfy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Të huate judíom kia naa kateme, jume diáblom géntemmet aneme yeu bébame, Señor Jesústa nésaupo yéu am beb báarei ínel jíaka: —Jesústa nésaupote enchim yeu katchauhue, hua Pablota áa bétana nonókáu nésaupo. ");
INSERT INTO mfy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Íkärim johuai jume Escevä téamta üusim guoy búsanika, hua tiöpopo tékiakammeu nésauhuemta üusim. ");
INSERT INTO mfy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Të íkäi am yáak, jü diablo ínel ámeu jiaahua: —Jukane Jesústa täya, éntokne jüneiya Pablota jábétukäihui, tëne enchim kaa täya enchim jábemtukähui. ");
INSERT INTO mfy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ínel jíaka, jü yoreme diáblota at anëu ámeu huánteka sanko síusiuti am huíkkek, éntok sussutti am chóchonaka am nahuítek. Huanärim jum jóapo yeu ténnek kaa sánkoka éntok tüisi kökoleka takáhuachi. ");
INSERT INTO mfy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Sïme jume Efesopo jóakame, judíom éntok kaa judíom junne, íkäi jüneriaka tüisi majhuëi, éntokim Señor Jesústa buéresi úttileka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Juebénaka jume Jesucrístota susualekame jum Pablota anëpo yajjai, bannaataka kaa tühua bem boojóriäu yeu buíseka. ");
INSERT INTO mfy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Juebénaka móriata tekipánoaïhuim bem librom áma yeu nüpak, huanärim sïmem bíchäpo táahuak. Jukam sïme libro béjhuata jünéria báreka ä näikiak. Huanärim ä jünériak cinkuenta mil tomi tósalita am béj‑rëhui. ");
INSERT INTO mfy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Júnëli chë juebena génte juka Señorta noki súaleka taahuak éntokim jüneiyai útteata ä jípurëhui. ");
INSERT INTO mfy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chúkula Pablo jume hermáanom Macedonia buíaräpo éntok Acaya buíaräpo aneme bitbábarek, huämi boula siká éntok, buere joära Jerusaléniu bíchaa hueerokkai. Jum buere joära Jerusaléniu nóitisuka éntok, ket Romáu bíchaa hueerokkai. ");
INSERT INTO mfy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Huanäi guoyim jume ä aniame Macedóniau jaásek, juka Timotéota éntok juka Erástota. Áapo éntok, júchi jaiki táapo jum Áasiapo taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Huámechi taáhuarimmet buere naa muksi huéeme jum pueblo Efesopo yeu siika tü nokta Jesucrístota bétana huemta béj‑reka, ");
INSERT INTO mfy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","yoreme Demétriota nokim béchïbo, platapo jita júne jojoame. Ïri yoreme jü diosa Diana téamta tiöpo bénak jum plátapo jojoai. Huanäi jume ä tékilpo ä aniayme yuun tómita kokobatuay. ");
INSERT INTO mfy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Huanäi áapo ímëi yoremem nau rúktiaka, éntok huame álë bénasi tekipanuame kétchi, ínel ámeu jiaahua: —Eme tüisi jüneiya ïri tékiliai tüisi itom ito aniähui. ");
INSERT INTO mfy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Të kéchem jüneiya, éntokem ä jíkkaja ika Páblota jume diósim yorémem joäu kaa diósim tíähui. Junëli juka juebena genteta áa beu éetua, kaa imi Efesopo jíbba, kia sïme Asia buíaräpo junne. ");
INSERT INTO mfy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ïri ínëli huéeme tua kaa türi, bueïtuk ï itom tékil kaitäpo tahuánakë, éntok kia hua diosa Diana yörisi machik tiöpota úttilhuame júne kaítatunakë. Júnëli kaitäpo bittáitina jü diósata buéria, jü sïme Ásiapo joomem yörëhui, éntok sïme ániat öbisi aneme yörëhui. ");
INSERT INTO mfy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Íkäi jíkkajakam tüisi öómteka chaytáitek ínel jíaka: —¡Buéresi yörihua itom áiye Diana Efesopo káttekame! —tim chaayey. ");
INSERT INTO mfy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Júnëli buéresi naa muksi siika jum pueblopo. Juka Gáyo ti téhuakamta buíssek éntok Aristárkota, guoi oóhuim Macedóniapo joomem Pablótamak rejtéïhuim. Huanärim am huíksakaka am nuksájjak áman kari bem nau yayájäu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Huanäi jü Pablo jume géntemmeu nok báreka áman kibák báarei, të jume Jesucrístota súaleme kaa ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Huate yäuram junne jum Ásiapo nésauhueme, jume ä amígokame, nokta au bíttuak jiókot au jíaka kaa áman genteta násukun ä kibák sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jumu éntok, juebénaraata násuk sooti chayhua jachin júne jíaka, bueïtuk hua chë bürura kaa jüneiyai jita béchïbo áma emo nau am tóij‑latukähui. ");
INSERT INTO mfy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Të huate yorémem áma aneme jünéame juka Alejándrota, juka judíom bat kéchakäu, téjhuak jita áma huëhui. Jü Alejandro éntok, mámammea séñata ámeu yáuhuak, am chay yánti ïaaka, bempörim, jume judíom, nok‑ria báreka genteta jíkkajäpo. ");
INSERT INTO mfy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tem jünéaka ä judíotukähui, sïme ínel chaayey, guoi orapo jäni: —¡Buéresi yörihua itom áiye Diana Efesopo káttekame! —tim chaayey. ");
INSERT INTO mfy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Huanäi hua yäurapo secretario juka genteta nok yáatituaka ínel ámeu jiaahua: —Eme Efesopo joome, nechem jíkkaja. Sïme ániat öbisi aneme jüneiya íkäi pueblo Efésota juka diosa Diana buéresi yörihuamta tiöpo ä suáyähui, éntok juka tétata ä takahua bénnak téhueka bétana kom huéchilata. ");
INSERT INTO mfy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kia jábe júne kara íkäi esso. Júntukem kaa bat jíale, éntokem kaa jita júne johua kaa bat tüisi ä jünériaka. ");
INSERT INTO mfy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bueïtuk ime oóhuim enchim im nüpakähuim kaita juënak jum enchim tiöpopo johua, éntokim enchim diosa Diánata bétana kaita juënak nooka. ");
INSERT INTO mfy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jü Demetrio éntok jume áamak tekipánoame am béj‑reka jita nokmáchiak, éläpom, bempo, am nätuanakë; júnen béchïbo yäuram aane. Huámëi bíchäpom nánancha ára emo nok‑ria. ");
INSERT INTO mfy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Táabuik jítasu enchim aahuai éntokte huam leyta huë páman nau rúkteka nau ä ettéjhuanakë. ");
INSERT INTO mfy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Bueïtukte kaa tüisi aane. Itom júnem nätuanake yäurata béj‑reka itom ito toboktiabárë tíaka, íkäi én im yeu sikä béchïbo. Bueïtukte jachin júne kara lútüriata nenka jü im naa muksi yeu sikamta bétana. ");
INSERT INTO mfy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Íkäi noksuka, béja jume áma nau yáij‑lame sákatuak. ");
INSERT INTO mfy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Huaka naa muksi huemta luútek, jü Pablo huame Jesucrístota súaleme nau núnuka ámeu noókak jíba bénasi óusi am ée sáhueka. Huanäi am íbaktiaka am mam buíseka, Macedonia buiärau bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Huanäi sïme huáachï ániat naa siika hermáanommeu noksísimeka, jíba bénasi óusi am ée sáhueka. Chúkula béja jum Grécia buiäu yépsak. ");
INSERT INTO mfy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Huämi baij metpo aneka, béja jum barcopo síriau bíchaa yeu huee báreka, jünëak jume judíom ä béj‑reka tekipánoähui. Kíalïku notibábarek jü buíachi, júchi Macedonia buíara pamam huee báreka. ");
INSERT INTO mfy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sïme ímëi áamak sájjak: jü pueblo Sópater Beréapo joome, éntok jume pueblo Tesalónicapo joome Aristarko éntok jü Segúndo ti téhuakame, jü Gáayo ti téhuakame pueblo Dérbepo joome, jü Timoteo, éntok jume ásia buiärapo joome kétchi Tíquico éntok Trófimo. ");
INSERT INTO mfy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ímëi hermáanom bat sájaka jum pueblo Tróaspo itom boobítchak, juka Pablota éntok néechi Lucasta. ");
INSERT INTO mfy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Páanim kaa levadúrakame buabuähuäu pájkota chúpukte jum pueblo Filípospote yeu sájjak barcopo. Mamni taáhuarim hueite jum Tróaspo ámeu yájjak. Huämite guoibusan táapo aanek. ");
INSERT INTO mfy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Semáanata naatëpo, lominko táapo, jume Jesucrístota súaleme nau yájjak jume páanim näikimte báreka juka Señorta nésauhuekä bénasi au am huáatinakë béchïbo. Jü Pablo éntok, am majtíai. Yokóriapo au simbárë tíaka tukáa násuk huëu tajti ámeu noókak. ");
INSERT INTO mfy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Baij kárim nat béppa jokäpo jikáchim nau yáij‑latukai, juebena lámparam béetëpo. ");
INSERT INTO mfy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Senu yoreme jübua yötuka, Euticö téaka, jum ventanapo káteka nokta jíkkajai. Huanäi juka Pablota binhua nokái, yetem au yuumak. Júnensu kóchoka yeutana bíchaa buíau kom huétchek. Huanäi mukílataka tóboktiahuak. ");
INSERT INTO mfy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Jü Pablo éntok, kom siká, hua mukílata béppa au jímmaaka ä íbaktiak. Huanäi jume hermáanommeu ínel jiaahua: —Katem guomguomte, bueïtuk béja júchi jíabitek. ");
INSERT INTO mfy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Huanäi jü Pablo júchi jikáu siká jume páanim näikimtek. Jume hermáanom am buäsuka éntok, júchi ámeu noktáitek matchüu tajti. Huanäi siika. ");
INSERT INTO mfy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Huä ili yoreme jübua yötume mukúkäu éntok, jiápsaka ä joau bíchaa nuksákahuak. Huanäi sïme tüisi al‑léaka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ítapo jum barcopo bat sájjak Asón puertou tajti, juka Pablota huämi nü báreka itom nau nokákäpo bénasi, bueïtuk áapo buíat hueerokkai. ");
INSERT INTO mfy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Jum Asonpo itom au yájak, barcopo itomak siika, huanäite Mitiléne puertou bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Huämite yeu sájaka yokóriapo isla Quiöu béa yájjak. Júchi yokóriapote béja puerto Sámospo yájjak. Jum Trogílio pueblou jimyóreka yokóriapote béja puerto Miletou yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Júnëlite aika bueïtuk jü Pablo jum Eféso pueblou kaa huee báarei, kaa jum Asia buíaräpo binhuatu báreka, bueïtuk läuti buere joära Jerusaléniu an báarei Pentecostés táapo, jume judíom pajko táapo, kaita jachin au macháiko. ");
INSERT INTO mfy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Béja jum Milétopo aneka jü Pablo jume yoiyöturi Jesucrístota súalemmeu yäut jóarim Efesopo joómem nau núnutebok. ");
INSERT INTO mfy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Am yájak, ínel ámeu jiaahua: —Eme jüneiya jachin ín ino nükähui bannaataka ímï Ásiapo aneka im ín yepsákäpo naateka. ");
INSERT INTO mfy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Sïme tiémpotane enchimmak aanek Señorta béchïbo tekipánoaka kaa buere ino ériaka, ín ópuam buéresi huötiaka, éntok juebena jiókot máchirata bíchaka jume judíom nee béj‑reka tekipánoakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Tëne juka enchimmeu türi máchik kaa tójaka jíba enchimmeu ä noókak, sïmem bíchäpo enchim majtíaka éntok enchim jóapo junne. ");
INSERT INTO mfy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kia judíommeu entok kaa judíommeu júnene noókak Diostau am jíapsi kúakti sáhueka, éntok juka Diosta itom Señor Jesucrístota bétana nokäu am súal sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Én éntokne Jerusaléniu bíchaa siime Espíritu Santota útteata nee joríä béchïbo, kaa jünéaka huämi jita bénak inou huéenakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Jü ín jünériäu ïri jíbba, juka Espíritu Santota nee tettéjhuähui jum sïme puéblompo ín yepsäpo, juka ín peréesotenähui éntok jiókot máchirata inou huéenakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tëne sïmeta íkäi kaachin eriä. In jíapsi júnene kaa beutire. Kia jíbane ín tékil chúpak jíba türinake, éntok al‑léaka huaka tékiata Señor Jesústa ín mampo tójakäu chúpako, juka tü nokta Diosta tühua bétana huemta ín ámeu noknákëhui. ");
INSERT INTO mfy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Én éntokne jüneiya énchim jábe júne jume Diosta nésauhuëu bétana ín ámeu nokákäu kaa júchi nee bínnakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kíalïkune én huitti enchim téjhua báare, kaítane entok enchim béchïbo yómmia báare, ");
INSERT INTO mfy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bueïtukne sïmeta enchimmeu nok‑la juka Diosta éähui, kaita enchim éssoriaka. ");
INSERT INTO mfy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Júntukem emo suaya, éntokem sïme jume Jesucrístota súaleme suaya, bueïtuk jü Espíritu Santo enchim yeu púala tékiata béchïbo, Jesucrístota súaleme enchim suáyanakë béchïbo, huame ä ojbo huötiaka ä kobákähui. ");
INSERT INTO mfy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ínapo jüneiya nee siik, huátem yáijnakëhui jume Jesucrístota súaleme täbuiasi jatía báreka, kaitäpo am tahuária báreka jume robo tebai kókkoram kabáram tetéjalë bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Éntok enchim násuk aneme júne huate emo tóboktianake juka lútüriata tójaka aranókïchiata yore majtía báreka, jume Jesucrístota súaleme áme beu ée ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Júntukem kaa koptel‑la. Áahuem huáate jachim ínapo jum baij huásuktiapo, taáhuarit tukáarit naabúrujti, kaa yáateka enchimmeu nookai ín ópuam guötiaka. ");
INSERT INTO mfy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Én éntok, ín hermaanom, Diosta mámpone enchim jóiyak, Diosta noki, ä tühua, bueïtuk huäri tua enchim óusi éetuanake, éntokem ä nokä páman katëtek huame Diosta bíchäpo. ");
INSERT INTO mfy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tómita éntok kia sánkota junne, kanne enchimmet beutire. ");
INSERT INTO mfy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ál‑lane tekipanuak ín huáatiäu jípu báreka, éntok huame ínomak anékame béchïbo junne. Eme júne tüisi jüneiya. ");
INSERT INTO mfy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Jíbane júkäi enchim majtíak junëli enchim tekipanuanakëhui jume jiókot éame enchim aníanakë béchïbo, hua Señor Jesústa noki ínel jíamtau huáateka: “Chë al‑léaka tahuánake jü yore jita mikame hua jita mabétamta béppa.” ");
INSERT INTO mfy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Chúkula béja jü Pablo junëli jiáusuka, tónommia kíkteka Diostau buaanak sïmemmaki. ");
INSERT INTO mfy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Huanäi sïme buanaka juka Pablota íbaktiak, éntokim ä besíitok bem ä boojóriaï bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bueïtukim tüisi sirokai hua ámeu ä nokákäu béchïbo, kaa júchi bem ä bínnahuëhui. Huanärim áamak sájjak barkóu ä jämú tajti. ");
INSERT INTO mfy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jume hermaanom tö sájakate barcopo jämuka sájjak. Huanäite lútula sájjak isla Cos teäu bícha, yokóriapo éntok, isla Ródasiu bícha, huämi éntok, puerto Pátarau bícha. ");
INSERT INTO mfy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Jum Pátarapote senu barcota Feniicia buiärau bíchaa huátaktemtaute yájjak. Huämite jämuka sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Bahuepo katékate juka isla Chípreta mékkäriat bitchak, huanäite míköri bétana ä tösájaka Siria buiärau bíchaa sájjak. Jü barco itom áma katëu éntok, juka ä huériäu jum puerto Tíropo tösim báarei, kíalïkute huämi kom chéptek. ");
INSERT INTO mfy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Huämite jume Jesucrístota súaleme téaka ámeu áma taahuak guoibusan táapo. Bempo éntok, jü Espíritu Santota bétana téjhuaataka jü Pablotau jita huéenakehu, áahuim nookai kaa jum Jerusaléniu ä huee sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Të guoibusan taáhuarim yúmak, jíbate sájjak. Sïme jume Jesucrístota súaleme bem jubímmak éntok bem usímmak itom boo tójjak jum pueblo mayoau tajti. Huämite see päku tónommia jápteka Diostau buaanak. ");
INSERT INTO mfy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Huanäite ito íbaktiaka ito mam buíseka barcou jämuk. Bempo éntok, nóttek bem joau bícha. ");
INSERT INTO mfy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiró puertopote yeu sájaka Tolemáida puertopote kom chéptek. Huämite ä chúppak juka bahuepo itom boojoaïhui. Éntokte huämi jume hermáanom tebótuaka senu táapo ámeu áma taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Yokóriapote áma yeu sájaka jum pueblo Cesaréa téäu yájjak. Huämite jü Felípeta joau yájjak, hua tü nokta Jesucrístota bétana huemta géntemmeu nonókamta jóahui hua guoibúsanimmak näikiatukaïhui, jume apóstolim ä aniaihuimmaki. Huanäite áma au taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jü Felipe náikim malakai kee kuname. Huámëi jaámuchim juka bat bíchaa ayúnakemta jünériaka nonokai. ");
INSERT INTO mfy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Béjate jaiki táapo jäni áma aaney juka profeta Agabo ti téhuakamta Judea buiära bétana áma yepsako, ");
INSERT INTO mfy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","itom bíchiseka. Huäri juka Pablota huihuíkosäu nüka, guokpo éntok mampo ái au súmaka, ínel jiaahua: —Jü Espíritu Santo ínel jiaahua: “Juka yoremta íkäi huikósata átteakamta jume judíom ínëli ä súmaka jume kaa judíom mampo ä yéchanä tíiya jum Jerusalémpo.” ");
INSERT INTO mfy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Íkäi jíkkajaka, ítapo éntok jume Cesaréapo joómem jü Pablotau jiókot jiaahua kaa Jerusaléniu ä huee sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Të jü Pablo ínëli itou jiaahua: —¿Jatchíakem buaana, éntokem ín jíapsi kaa al‑léetua? Ínapo kaachin ä eria jum Jerusalémpo ín sumanähui, éntok kia ín mënäu junne Señor Jesústa béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Katte ä yúyüuka, ä tójaka ínel jiaahua: —Éläpo jü Señorta éäu yáatunake. ");
INSERT INTO mfy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Chúkula béjate ito lijtaroaka, Jerusaléniu bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jume huate Jersucrístota súaleme Cesaréapo joome éntok, itomak sájjak. Áme násuk éntok, senu yoreme hueiyei Chíprepo joome Nason ti téhuaka, íäri jóapo yaij éaka áma tahuá báreka. Áapo béja bínhua Jesucristota súaley. ");
INSERT INTO mfy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jum Jerusaléniu itom yájak, jume hermáanom al‑léaka itom mabétak. ");
INSERT INTO mfy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yokóriapote jü Pablótamak sájaka juka Jakóbota áman bitchak ä anëpo. Huämïrim aaney jume yoiyötori Jesucrístota súalemmeu yäut jóarim. ");
INSERT INTO mfy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Jü Pablo am tebótuasuka jíba am ettéjhuariatáitek huaka tühuata Diosta yáakähui jume kaa judíommehui áapörik ámeu nokako ");
INSERT INTO mfy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","íkärim jíkkajaka Diosta úttileka taahuak. Huanärim Pablotau ínel jiaahua: —Jéehui, itom hermáano, empo jüneiya jaiki mil judíom anëhui Jesucrístota súaleme. Sïme huámëi útteä tíiya juka Moiséjta nésauhui jonähui. ");
INSERT INTO mfy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bempo éntok, ettéjoriahuak empo jänituk ínel am majtíä téehua sïme jume judíom sékäna buíaräpo jóakame juka Moiséjta nésauhui kaa am jo sáuheka, éntoktukë bem usim júne kaa am circuncidaroa sáuhuë téehua, éntok kia huaka bannaataka itom, jume judíom, boojóriäu júne kaa am jo sáuhuë téaka. ");
INSERT INTO mfy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ensu, ¿jáchisute ayúnake jäni? Bueïtuk jü génte em yepsákä bétana jünëak nau yáijnake. ");
INSERT INTO mfy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Senu huémtë yáak türinake. Imi ito násuk naiki oóhuim aane Diostau bem nätuari chupa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Akë am huériaka áman áme beu emo ubba Moiséjta nésauhuëpo bénasi, éntoke juka sïme limójnata ámeu aïhuamta am béjturia. Chúkula bempo emo chon chúktiatebonake bem ä nätualä bénasi. Júnëli sïme jünéenake huaka emo bétana nokhuamta kaa lútüriatukähui. Ál‑lam huaka Moiséjta nésauhuë páman enchi huëtíanake. ");
INSERT INTO mfy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Huame kaa judíom Jesucrístota súaleme bétana éntok, katäkute béja ámeu jïojtesula am téjhuaaka kaa útteatukähui jukaram jonákë bétana. Kia jíbate juka huakajta huame dios yorem yáarimmeu limójnata kaa am buä sáuhue, kia ojbota junne, éntok bámsuaka mukílata huaakas. Éntokte kaa emo am jubek kaa emo am huáatia sáuhue. ");
INSERT INTO mfy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Huanäi jü Pablo jume naiki oóhuim nuksiika. Yokóriapo béja áme beu au úbbak Moiséjta nésauhuëpo bénasi ayuka. Huanäi jum tiöpou kibákek jume áma tékiakame téjhua báreka jita táapo ä yumánakeïhui huaka Moiséjta nesau huë páman bem emo buaníakäu bem chúpanakëhui, éntok jakhüéi juka límojnata bem áma tóijnakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Të béja jume guoibusan taáhuarim yúmasei, huate judíom Ásiapo joome juka Pablota tiöpopo bíchaka, sïme genteta emo tóboktituak. Huanärim ä buíseka, ");
INSERT INTO mfy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","chayeka ínel jiaahua: —¡Eme oóhuim Israelítam, itómem anía! Ïri ájäria jü yoreme sïmat naa huéeka jume géntemmeu nokame itom nación béj‑reka, Moiséjta nésauhuëu béj‑reka, éntok íkäi tiöpota béj‑reka. Íäri béppa éntok, huate griégom jum tiöpopo kimala. Júnëli aneka íkäi tiöpota itom tua yöreu kaa tüisi tahuária. ");
INSERT INTO mfy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Júnëlim jiaahuay bueïtukim bannaataka jum puéblopo jü Trófimotamak ä bil-latukay, hua Efesopo joometamaki. Huákärim jum tiöpopo ä kibáchalatukä bénasi éiyay. ");
INSERT INTO mfy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Huanäi jü génte au tóboktiaka, tenneka áman ámeu yájjak. Huanäi bempo ket jü Pablótat chätuka jum tiöpopo yeä nuksájjak buíapo ä huíksakaka. Huanärim sep jume puértam páttiak. ");
INSERT INTO mfy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Béjam ä më báarei juka nokta comandantetau yepsayo sïme juka pueblo Jerusalémta au tóboktiakä bétana. ");
INSERT INTO mfy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Huanäi jü comandante jume sontarom éntok jume capitáanim bamsipo nau núnuka áman bíchaa am nuksiika. Huanärim tüisi teénneka áman genteta anëu yájjak. Bempo ä bébakasum ä tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Huanäi jü comandante jü Pablotau rúkteka guoi cadenammea ä súmatebok. Chúkula béja nátemajek ä jábétukähui éntok jita ä yáakähui. ");
INSERT INTO mfy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Të jü génte juebénarata násuk huate chaayey kaa nanancha jíaka. Júnëli jü comandante kaa ámet jünéaka taahuak sooti am jíä béchïbo. Huanäi juka Pablota cuarteliu bíttuak, sontarom anëhui. ");
INSERT INTO mfy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Béja cuarteliu jikáu kathuäu yájaka jume sontarom juka Pablota püaktiaka jikau ä núk sájjak, juka genteta káachin ä yáa ïaka. ");
INSERT INTO mfy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bueïtuk sïme amapo kateka inen chaisakai: —¡Akem ä mëa! ");
INSERT INTO mfy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jü Pablo béja jum cuarteliu kibácha báahuaka, comandantetau ínel jiaahua: —¿Játchune ára ino nok‑ria jäni? Jü comandante éntok ínel aú jiaahuak: —¿Játchë griego nokka? ");
INSERT INTO mfy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Jatchu kaa empo hua Egíptopo joome jakhuey yäurate béj‑reka emo tóboktiakähui, hua naiki mil yorémem yore sualéeraommak juyau huéchekaïhui? ");
INSERT INTO mfy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Huanäi jü Pablo ínel ä yómmiak: —Ëe, ínapo täbui. Ínapo judío, Társopo joome, hua pueblo buëuru Cilicia buíaräpo kátekame. Huämine tua lútüriata jípure. Nechë lisensia gentetau ín noknákë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jü comandante éntok, ä lisensiak. Huanäi jü Pablo jum jikau kathuäpo kíkteka, jü gentetau mámammea séñata yáaka am chay yáatituak. Béja kaábeta jíalei, hebreo nokpo ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Eme ínomak huéerim éntok ín áchayim ín ino nok‑riaka ín nokäubechem suaka ä jíkaja —ti ámeu jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jum tua bem nokpo ä nok jíkkajakam chë kaa jíaleka taahuak. Huanäi Pablo ínel ámeu jiaahua: ");
INSERT INTO mfy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Ínapo judío. Társopone yeu tómtila jum Cilicia buíaräpo kátekäpo, tëne ímï Jerusalémpo yötuk, éntokne hua Gamaliél téamtau, hua tü täyahuäutau, tüisi majtíari, jíba jume itom yóyöhuam nesau huëpámani. Jíbane jü Diosta béchïbo tekipánoak chikti ín jíapsimaki, én enchim áa béchïbo tekipánoä bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ínapo bannaataka huame tü nokta Jesucrístota bétana huemta súaleme guokjájasuk. Anam sússuateboi junne. Oohuim éntok jaámuchim júnene peréesoteboka am nuksisímei cárcelpo am jóa báreka. ");
INSERT INTO mfy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jü tiöpopo chë nésauhueme, éntok sïme huame yoiyötori yäut jóari, áram ket íkäi lútüriä tíiya ín nokähui, bueïtuk bempo jiösiam nee mámakai huame judíom itomak huérim pueblo Damascopo aneme jünéetuaka jita béchïbo ín áman huëhui. Júnëline áman siika jume Jesucrístota súaleme jaríaka äbo ímï buere joära Jerusalémpo yéu am toij báreka, nokta ámet chúpanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Të áman bíchaa nee huei, béja Damascou nee yebísisei, jíba tua lul‑la káteko, sej chukti jü machiria útteaka téhueka bétana inou kom yuumak. Huanäi nate chíkola nee machíriak. ");
INSERT INTO mfy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Huanäine buíapo huécheka senuk inou nokamta jíkkajak ínel jíamta: “Empo Saulo, ¿jatchíake nee guokjájase?”, tíamta. ");
INSERT INTO mfy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Huanäine nátemajek: “¿Jábesä empo Señor?”, tine jiaahua. Huanäi ínel inou jiaahua: “Ínapone jü Jesús Nazaretpo joome, hua em guokjájasëhui”, tinou jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Huame ínomak katëu éntok, juka machíriata bíchaka tüisi guómtek, tem huaka inou nokamta kaa jíkkajak. ");
INSERT INTO mfy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Huanäi ínapo ínel au jiaahua: “Ensu Señor, ¿jítasune yanake?” Jü Señor éntok, ínel inou jiaahua: “Yejtékë huéiye jum Damascou bícha, huämïrë ä téjhuaana jita em yáanakehui”, tinou jiaahua. Huanáine kíktek. ");
INSERT INTO mfy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tëne jü machiria úttiäray kaa bíchaka taahuak. Huanäi jume ínomak katéïhuim mampo nee buíj‑lataka nee huíksakai Damascou tajti. ");
INSERT INTO mfy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Huämi puéblopo senu yoreme aaney Ananías téaka. Áapo tüisi Moiséjta nésauhuë páman huéiyey, éntok sïme jume judíom Damascopo joome ä tü éttejhuay. ");
INSERT INTO mfy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Huämi jü Ananías inou yépsak nee bíchiseka. Inou yepsaka ínel inou jiaahua: “Empo Saulo, ín hermáano, júchi bénasi em bínnakeu emou ayúnake”, tï inou jiáhuak. Huanäine seep bíchaka tahuaka at pújtek. ");
INSERT INTO mfy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Áapo éntok, ínel inou jiaahua: “Huä itom yóiyöhuam Dios enchi yeu púuhuak bannaata kat-riampo naateka áapörik éäu em jünérianakë béchïbo, éntok Jesucrístota, juka tua lútüriata jípuremta, em bínnakë béchïbo éntok tua áapörik em nok jíkkaijnakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bueïtukë áapörik bétana tühuata noknake sïme yorémem jíkkajäpo, éntok huaka em bíchakäu éntok em jíkkajakäu am téjhuanake. ");
INSERT INTO mfy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Én éntok, katë éntok jita boobíchaka, banseka emo batötebo Señortat éaka huame em kaa tühua yáarim enchi ä tuchárianakë béchïbo”, tinou jiáhuak jü Ananías. ");
INSERT INTO mfy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Jerusaléniune nótteka jum tiöpou siika Diostau buan báreka. Huämi Diostau buanakane tenkumta bénasi éaka juka Señorta bitchak. ");
INSERT INTO mfy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Anä nok jíkkajak, ínel inou jíamta: “Bamsekë im Jerusalémpo yeu huéiye, bueïtuk jume im joome ino bétana em nokäu kaa jíkkaij báanake”, tï jiaahua jü Señor. ");
INSERT INTO mfy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ínapo éntok, ínel au jiaahua: “Señor, bempo jüneiya sïme at bem nau yayajäpo ín huerámaka jume enchi súaleme cárceliu ín totójaïhui, éntok ín am bébebaïhui. ");
INSERT INTO mfy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Éntokim jüneiya juka Estebanta, huaka emo bétana jume géntemmeu nokamta, mëhuai, áma ín anéïhui áme beu éaka ä mëna bétana, éntok huame ä mëakame sanko júne ín suáyakaïhui”, tinau jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Të jü Señor ínel inou jiaahua: “Böochë kíkte, bueïtukne mekka bíchaa enchi bíttua báare áman huame kaa judíommehui, enchi ámeu noknákë béchïbo.” ");
INSERT INTO mfy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Júmunï tájti ä nok jíkkajaka, ínel jíaka cháy táitek: —¡Akem ä mëa júkä yoremta! ¡Kaa türinake jiápsaka tóijhuako! ");
INSERT INTO mfy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jíba junëli am chayéi, éntok ómteka bem sanko éntok buíata jikáu am guötiayo, ");
INSERT INTO mfy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","jü comandante juka Pablota cuarteliu kibáchatebok. Béja jum kuartelpo ä kátek, tüisi ä bemmucha nésauhue ä nok ïaaka, jünée báreka jita béchïbo juka genteta junëli ä béj‑reka chayëhui. ");
INSERT INTO mfy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Të jü Pablo bemmúcha báahuaka súmataka, jü capitán áma anemtau ínel jiaahua: —Kaa lútüriatu jiöbe románota enchim bemmúchatebonakëhui kaa bat nokta béttesi machik at chúpalatuko. Bueïtuk ínapo ket romáano. ");
INSERT INTO mfy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Íkäi jíkkajaka jü capitán, áman siká jü comandántetau jünéehuamta nénkak ínel au jíaka: —Kaa türi jü yoremtau em yáa bárëhui, bueïtuk áapo romaano. ");
INSERT INTO mfy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Huanäi jü comandante jü Pablotau siká ínel au jiaahua: —¿Jatchu lútüria em romaanotukähui? —Jéehui —tau jiaahua jü Pablo. ");
INSERT INTO mfy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jü comandante éntok, júchi ínel au jiaahua: —Ínapo jum Romapo lútüriata jipu báreka yún tómita nénkak. —Ínapo éntok —tau jiaahua jü Pablo—, íkäi lútüriata jípure jum Romapo ín átchay bétana. ");
INSERT INTO mfy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Júnëli ä jíak, jume Pablota bemmúchabárëu seep ä tójjak. Jü comandante júne ä romáanotukäu jünéaka, at májhueka taahuak ä sumatébokä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yokóriapo jü comandante juka lútüriata jünéria báreka, jita béchïbo jume judíom juka Pablota nätuakähui, jume cadenam ä úhuaaka jume tiöpopo tékiakammeu nésauhueme nau núnutebok éntok sïme huaka judíommeu buere yäuraata. Huanäi juka Pablota yeu béebaka bem bíchäpo yéä tójjak. ");
INSERT INTO mfy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Jü Pablo juka yäurata bíchaka ínel ámeu jiaahua: —Eme ínomak huéerim, ínapo kaítat jachin éaka jiápsa Diosta bíchäpo én tajti. ");
INSERT INTO mfy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Huanäi jü Ananías, jü tiöpopo chë né sauhueme, jume Pablota náapo jäbuekame teníchä chóchon sauhue. ");
INSERT INTO mfy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Huanäi jü Pablo ínel au jiaahua: —¡Áapo jü Dios ket enchi bébnake, empo kaita lútüriata joame! Empo leyta huë páman nokta ínot chupä ïaahuaka áma yéchataka, leyta béj‑reka nee kökosi jotebo. ");
INSERT INTO mfy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Huame áma anëu éntok, Pablotau ínel jiaahua: —¿Jatchu empo junëli béttesi au nooka jü tiöpopo buéresi nésauhuemtahui, jü Diosta béchïbo tekipánoamtahui? ");
INSERT INTO mfy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo éntok, júchi ínel ámeu jiaahua: —Eme ínomak huéerim, ínapo kaa jüneiyai tiöpo buéresi ä nésauhuëhui. Ínapo júneätek kaa ínel au jiaü eiyei, bueïtuk jum Diosta noki jïojteripo ínel jiaahua: “Kátë hua yäura em puéblopo nésauhuemta bétana béttek nooka.” ");
INSERT INTO mfy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Huanäi jü Pablo jünëak jume áma nau yáij‑lame huatem saducéomtukähui, huatem éntok, pariséromtukähui. Ímëi kaa nánancha jita súalei. Huanäi kusisi ínel ámeu jiaahua: —Eme ínomak huéerim, ínapo pariseero, ín átchay junne, éntok jume ínomak huéerim junne. Én éntok, jume kókkolam jíabitenakeu ín súalë béchïbo noki ínot chúpari. ");
INSERT INTO mfy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Júnëli ä jíak, jume pariseerom éntok jume saducéom, bempo nau nok nássuatáitek. Huanärim kaa nánancha éaka emo näikimtek. ");
INSERT INTO mfy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bueïtuk jume saducéom jume kókkolam jíabitenakeu kaa súalei, éntokim ángelesim káitä tíiyai, kia espíritum junne. Të jume parisërom éntok, sïmeta íkäi ayúkä bétana ä súale. ");
INSERT INTO mfy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Huanäi buéresi chaihuame hueiyei. Huate judíom ley am mamájtíame parisérom beu éame jápteka ínel jiaahua: —Ï yoreme kaita juënak yáala. Espírituta au nok‑látuk, o Diosta ángel áu nok‑latuk, türi. Katte Diosta béj‑reka jájaptenake. ");
INSERT INTO mfy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Huä nau nok nássuahuame buéresi hueiyei, kíalïku jü comandante juka Pablota máuj‑riai juka genteta näikim ä huikmáchileka. Junen béchïbo sontarom áman nütebok áme násuk yéu ä huíkeka cuarteliu ä toij ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yokoríapo tukaapo, jü Señor jü Pablotau yepsaka ínel au jiaahua: —Óusë éiya, Pablo, bueïtukë ímï Jerusalémpo em ino bétana nokakä bénasi áman Romapë két noknake. ");
INSERT INTO mfy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Yokoríapo huate judíom éhuil nokta nau yáuhuak juka Pablota mëbáreka, ínel jíaka: —Éläpo jü Dios nokta béttesi ítot chúpanake. Juka Pablota kee mëaka itom jïbuäko éntok itom jita júne jëko. ");
INSERT INTO mfy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jume íkäi nokta yáakame cuarenta óhuim béppatukai. ");
INSERT INTO mfy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Huámëi jume tiöpopo tékiakammeu nésahuemmehui éntok huame judíom yoiyötori yäut jóarimmeu sájaka ínel ámeu jiaahua: —Ítapo nokta nau lútüria yáala juka Diosta nokta béttesi ítot chúpanake tíaka juka Pablota kee mëaka jïbuäko. ");
INSERT INTO mfy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Én éntok, eme éntok jume huate yäurapo tékiakame, jukem comandanteta téjhua, yoko äbo enchimmeu ä huérianake, juka ä huéetuä bétana chë tüisi at nátemaje béchïbo tiaupo. Ítapote jum böt ä jójottuaka ä mënake ke äbo ä yepsayo. ");
INSERT INTO mfy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Të jü Pablota asohuaara ä jüneriak juka huemta. Huanäi áman cuarteliu ä téjhuak. ");
INSERT INTO mfy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Huanäi jü Pablo senu capitanta núnuteboka ínel au jiaahua: —Íkäre jübua yötumta áman comandantetau huéria, bueïtuk áapo jita au ä nokmáchik au huéria. ");
INSERT INTO mfy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Huanäi jü capitán áman comandantetau ä nuksiiká ínel au jiaahua: —Jü Pablo áman peréesopo jípuhuame nee núnuteboka íkäi jübua yötumta nee äbo emou huéria sáuhue; áapo jita emou ä nokmáchik huériä téehua tau jiaahua. ");
INSERT INTO mfy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Huanäi jü comandante juka jübua yötumta mampo buíseka omot yéä nuksiká ä temajék: —¿Jítasë inou nok báare? ");
INSERT INTO mfy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Huanäi hua jübua yötume ínel au jiaahua: —Jume judíom nau nokta lútüria yáala emou nok báreka yoko juka Pablota jum yäurata bíchäpo enchi yéu ä toij sáu báreka, juka áa huéetuä bétana chë tüisi at nátemaje béchïbo tiaupo. ");
INSERT INTO mfy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Të kátë am súale, bueïtuk cuarenta oóhuim béppataka böt éusulataka ä boobíchaïhui, éntokim nokta yáala juka Diosta béttesi nokta ámet chúpanake tíaka, juka Pablota kee mëaka jïbuäko éntok jita júne jëko. Én éntokim emou nokaka em am yómmianakeu jíba boobíchaïhui. ");
INSERT INTO mfy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Huanäi jü comandante juka jübua yötumta simtúak kaábeta ä tejhua sáhueka íkäi au ä nokákä bétana. ");
INSERT INTO mfy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Huanäi jü comandante guoi capitánim núnuka am téjhuak guoi cien sontarom guok‑léerom am nü sáhueka, éntok setenta sontaró kákabäekame, éntok guoi ciéntom lánzakame, jum pueblo Cesaréau am kannákë béchïbo bátanim jiai tukápo. ");
INSERT INTO mfy_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Éntok ket huate kábäim yeu pua nésauhue Pablota ámet yejsimnakëhui, éntok am téjhuak tüisi ä suáyaka al‑léamta áman gobernador Félixtau am nüpa sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Bempörimmak juka jiösiata áman au bíttuak ínel jíamta: ");
INSERT INTO mfy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Empo gobernador Félix tua yörihuame, émoune tebote, ínapo jü Claudio Lisias. ");
INSERT INTO mfy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Éntokne enchi jünéetua jume judíom íkäi yoremta pereesotelatukaïhui, éntok bem ä më báareïhui. Të ínapo jünéaka ä romáanotukähui, sontarómmakne ä jínëuk. ");
INSERT INTO mfy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jum bem yäuraune yéä tójjak jünée báreka jita béchïbo ä nätuatukähui. ");
INSERT INTO mfy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Huanäine jünëak bempörim ley bétana huemta béchïbo ä nätuatukähui, të romáanom ley béj‑reka kaita béttesi machik ä yáalatukähui ä mëtebonakemta, éntok kíal ä peréesotebonakemta junne. ");
INSERT INTO mfy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Tëne jünéaka judíom ä mëbáreka am tekipánoähui, sepne emou ä bíttuak, éntokne ket jume ä nätuame téjhuaala huaka bem at ínnëäu em jíkkajäpo am nok sáhueka. Ïri jíbba”, tiahua jü jiösia. ");
INSERT INTO mfy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Huanäi jume sontarom bem sáihuaka páman ayuka juka Pablota nuksájjak tukáapo pueblo Antípatris téäu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yokóriapo jume sontaró guok‑léero bem cuarteliu nóttek. Jume kákabäekame éntok, bóula sájjak Pablota huériaka. ");
INSERT INTO mfy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesaréau yájakam juka jiösiata gobernadorta mákkak. Juka Pablota éntokim ä mampo yétchak. ");
INSERT INTO mfy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Huanäi jü gobernador juka jiósiata noksuka Pablota temájek jakun ä jométukähui. Jum Cilicia buíaräpo ä jométukäu jünéaka, ");
INSERT INTO mfy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ínel au jiaahua: —Huame enchi nätuame äbo yájak jübuë emo nok‑rianake, huanäine enchi nok jikkaijnake. Huanäi huam rey Heródesta jóakaïpo ä páttiateboka ä suaya nésauhuek. ");
INSERT INTO mfy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Chúkula mamni taáhuarim huei, jü Ananías, jum tiöpopo chë nésauhueme, jum Cesaréapo yépsak huate judíom yoiyötori yäut jóarimmaki éntok senu am nonók-riamtamaki, Tértulö ti téhuakame. Ímëi jü gobernadortau yájjak juka Pablota nätua báreka. ");
INSERT INTO mfy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Juka Pablota yeu tóijhuak, jü Tértulo noktáitek, jü Félixtau ínel jíaka: —Empo Félix yörihuame, tüisite enchi at báisauhue yanti itom jíapsä béchïbo kaítat jachin éaka, bueïtuk sïme tüisi huéiye em koba súakä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sïmetate íkäi tühuata mabeta sïmekuchi, tüisi enchi baisáuhueka. ");
INSERT INTO mfy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Të kaa enchi rójiktitua béchïbo binhua emou nokaka, chúbala jíbe itom nok jíkkaja. ");
INSERT INTO mfy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ï yoreme imi yeu tóijhuakame jita juëna kökoata bénasi maachi, kaa tü yóreme. Sïme ániat jume judíom násuk nau omtíhuamta huéetua, éntok jume nazarénom téammeu yäut. ");
INSERT INTO mfy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kia itom tiöpopo júne kaa tühuata hueetua báarei. Ítapo éntok, ä buíseka itom ley nésahue páman nokta at chupa báarei. ");
INSERT INTO mfy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Të jü comandante Lisias áma au kibáchaka útteapo itom ä úhuak, ");
INSERT INTO mfy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","éntok itom téjhuak jume ä nätuame äbo emou kannákë tíaka. Én éntok, empo áapörik, Pablota, temájekätek jünéenake huaka itom áa bétana nokäu lútüriatukähui. ");
INSERT INTO mfy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jume judíom áma anéïhuim ket jíba sïmeta íkäi lútüriä tíiyai. ");
INSERT INTO mfy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Huanäi jü gobernador séñata jü Pablotau yáuhuak ä nok ïaaka. Huanäi jü Pablo ínel jiaahua: —Chikti ín al‑léerimmakne ino nok‑rianake em jíkkajäpo, bueïtukne jüneiya juebena huásuktiriampo ín nacionbeu em yäuttukähui. ");
INSERT INTO mfy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Empo ára at nátemaje, dóoce taáhuarim jübua hueiy ínapo jum buere joära Jerusalémpo yebíj‑lataka áma Diosta yöreka au mujti báreka. ");
INSERT INTO mfy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kaábetamakne nok nássuaka jíkkaijhuak, éntokne kaabe genteta emo tóboktituaka bít-huak jum tiöpopo, éntok kia jak júne bem emo nau totójäpo, éntok kia jak sékäna junne huämi puéblopo. ");
INSERT INTO mfy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ímëi yoremem kia jita bem áa béchïbo nee nätuäu júnem karë lútüria yáuhua. ");
INSERT INTO mfy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Tëne juka ín boojoriau yeu buíjnake. Ínapo huaka ín yóiyöhuam Dios béchïbo tekipanua, sïmeta juka Diosta nésauhui libropo jïojteta súaleka éntok jume profétam jïojteri nokäu junne, jü bemela böta huëpámani, bempörim kaa tühuätíähui. ");
INSERT INTO mfy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Éntokne jíba Dióstat boobíchaïhui bempörim at boobíchähui, jume kókkolam jíabitenakëhui, jume tü yóremem éntok kaa tü yóremem junne. ");
INSERT INTO mfy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Juäri béchïbone jíba tühuata jóaka jiápsa, kaítat jachin éaka Diosta bíchäpo éntok yorémem bíchäpo junne. ");
INSERT INTO mfy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Jaiki huásuktiapone sékäna bíchaa naa simsuka ín buíarau nóttek limójnata huériaka póobem béchïbo éntok tiöpota béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Íkäine johuai jume judíom Ásiapo joomem jum tiöpopo nee bíchako, béja nee ino úbasuko bem ley nésauhuëpo bénasi, të kaa bürummaki éntok kaa naa muksi jita huéetuaka. ");
INSERT INTO mfy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Huámëi huämi nee bíchakame äbo sájak türinake, ímin yeu jápteka bem nee nätuanakë béchïbo jita ino bétana nok máchiako. ");
INSERT INTO mfy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ímëi im aneme ket ára nooka áman judíom buere yäura bíchäpo jita béttesi machik ín yáalatukäu ínot téihuaka bétana. ");
INSERT INTO mfy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Jamak áme násuk aneka kusisi ínel ín jíakä béchïbo nee nätuala: “Ënem nokta ínot jímmaala jume kókkolam jíabitenakeu ín súalë béchïbo”, ti ín jíakä béchïbo —tiahua jü Pablo. ");
INSERT INTO mfy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Íkäi jíkkajaka jü Félix, tüisi jünéaka Jesucrístota súalnä béchïbo tekipánoahuähui, íkäi huemta bat tójjak ínel ámeu jíaka: —Juka comandante Lísiasta äbo yepsak jübuane yúmalasi ä jikkaijnake huaka at enchim nokähui. ");
INSERT INTO mfy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Huanäi jü Félix juka capitanta téjhuak júchi juka Pablota pattia nésauhueka, të licénciata ä nenki sáhueka jume ä täyame ä bínnakë béchïbo, éntok ä aníanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Chúkula jaiki taáhuarim huei, júchi áma yépsak jü Félix ä jubímaki, Drusílä téamtamaki. Áapo judíotukay. Huanäi juka Pablota núnutebok Jesucrístota súalhuä bétana áu ä nok ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Të juka Pablota jum lútüriata huë páman emo nühuamta bétana au nokako, éntok jü emo yüihuamta bétana éntok taahuata yúmak, Diosta nokta yóret chúpanake bétana áu ä nookak, jü Félix guómteka ínel au jiaahua: —Simëe, ínapone kaa obisi anëtek, júchi enchi núnutebonake. ");
INSERT INTO mfy_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Të jü Félix jü Pablótat boobíchaïhuii tómita ä makmáchileka yéä beb báreka; kíalïku élaka jíba ä núnutebonake áamak ettéjhua báreka. ");
INSERT INTO mfy_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Guoi huásuktiriam siika junëli huéeka. Júnensu jü Félix gobernadorpo yeu siika, huanäi jü Porcio Fésto ti téhuakame áma tékiatek. Të jü Félix jume judíommak tüisi tahuá báreka jíba juka Pablota pereesopo tö siika. ");
INSERT INTO mfy_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Huanäi jü Fésto áma yépsak gobernadorpo tékiata mabét báreka. Baij taáhuarim huei jum Cesaréapo Jerusaléniu bíchaa siika. ");
INSERT INTO mfy_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Huämi jume tiöpopo tekipánoammeu nésauhueme, éntok jume judíom chë áma nok jíkkaijhuame, Féstotau yájjak Pablota nätuaka. ");
INSERT INTO mfy_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Huanärim bem huáatiäu emo yáaria nésauhueka au noókak, juka Pablota Jerusaléniu ä bittua sáhueka. Të jü bem éäu täbuiakai, böochim ä mëtebo báreka eiyai. ");
INSERT INTO mfy_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Të jü Fésto juka Pablota jum Cesaréapo peréesö tíiyai, éntok läuti jëla áman au huée máchilë tíiyay. ");
INSERT INTO mfy_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","—Júntuk —ti ámeu jiaahua— jume enchim násuk tékiakame ínomak sájak türinake jum Cesaréahui. Huákäi yoremta béttesi machik juënak yáalatuko árem ámanirem ä nätua. ");
INSERT INTO mfy_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jü Fésto jum Jerusalémpo guojnaiki o guojmamni táapo jäni aneka Cesaréau nótek. Yokóriapo béja jum yäuchim jojóyëpo yejteka juka Pablota áman nütebok. ");
INSERT INTO mfy_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Juka Pablota áman kibákek, jume judíom Jerusalén bétana áma yájakaïhuim au rúkteka nate chíkola au jáptek. Huanärim juebénak béttesi machik bétana ä nätuai, tem kaachin ä lútüria yáa máchiakai. ");
INSERT INTO mfy_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Jü Pablo éntok, au nok‑riaka ínel jiaahua: —Ínapo kaita béttesi machik yáala, kia judíom ley béj‑reka éntok kia tiöpota béj‑reka junne, éntok Césarta, Romapo yäutta, béj‑reka junne. ");
INSERT INTO mfy_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Të jü Fésto jume judíommak tüisi tahuá báreka, Pablotau ínel jiaahua: —¿Játchë kaa Jerusaléniu huee báare ámani juka nokta emo bétana huemta ín tü yáanakë béchïbo? ");
INSERT INTO mfy_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","—Ímïne Romapo yäurata bíchäpo aane —tau jiaahua jü Pablo—, éntok ímï ájäria lútula huëpo nokta ínot chúpanähui. Empo tüisi jüneiya judíom béj‑reka kaita juënak ín yáalatukähui. ");
INSERT INTO mfy_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Jita juënak nee mëtebonakemta yáalatuk kaáchinne ä eria ín muknákëhui. Të kaita juka bem íno bétana nokäu lútüriatuk, kia jábe júne kaa lútüriata jípure judíom mampo nee ä tóijnakëhui. Kíalïkune juka Césarta, Romapo yäutta, áapörik nokta ínot chupäïa. ");
INSERT INTO mfy_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Huanäi jü Fésto jume huate yäurammak ettéjhuasuka ínel au jiaahua: —Béjasë juka Césarta, Romapo yäutta, nokta émot chupäïa, huáahuïne enchi bíttuanake. ");
INSERT INTO mfy_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Chúkula jaiki taáhuarim huei, jü rey Agripa téame éntok Berenice ä jubíahua jum Cesaréau yájjak juka Féstota tebótua báreka. ");
INSERT INTO mfy_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Huämi binhua am anéi, jü Fésto juka reyta ettéjhuariak juka Pablota áma peréesotukä bétana ínel au jíaka: —Senu yoreme imï jípuhua jü Félixta peréesopo tösikähui. ");
INSERT INTO mfy_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jum Jerusalémpo nee anéi, jume tiöpopo tékiakammeu nésauhueme éntok jume yoiyötori judíommeu yäut jóarim apä béj‑reka inou noókak béttesi nokta nee at chupa sáhueka. ");
INSERT INTO mfy_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ínapo éntok, ínel ámeu jiaahua, juka Romapo yäuraata kaa junëli ä boojóriä tíiya, jábeta ä mëtebonakëhui kaa bat jume ä nätuammak emo am pújba bíttuaka emo am nok‑rianakë béchïbo, jita béchïbo bem nätuahuähui. ");
INSERT INTO mfy_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kíalïkune bempörim äbo yájak, kaa binhua boobíchaka yokóriapo jum yäuchim jojóyëpo yejteka juka yoremta áman nütebok. ");
INSERT INTO mfy_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Të huame ä nätua báreka yeu jáptekame kaítam huaka ín at érahuëu yeu buíssek. ");
INSERT INTO mfy_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ál‑la hua bem áa bétana nokäu kia hua bem Diosta tekipánäu béj‑reka ä huë tíiyai, éntok senu yoreme Jesús téame mukúkamta bétana, éntok juka Pablota huákäi yoremta jiapsä tíä bétana. ");
INSERT INTO mfy_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ínapo éntok, ílë bénasi huëpo kaachin anmáchika juka Pablota temájek jum Jerusaléniu áapörik hueebare jänï tíaka, ámani juka nokta at chúpanä béchïbo jü at nokhuamta béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Të áapörik juka Romapo yäutta, Augusto rey Césarta, nokta at chupä ïä béchïbo, jíbane peréesopo ä jipu nésauhue áman Romáu ín ä bíttuäu tajti. ");
INSERT INTO mfy_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Huanäi jü rey Agripa Féstotau ínel jiaahua: —Ínapo kéchä nok jíkkaij peiya íkäi yoremta. —Türi, yoko jübuë ä nok jíkkaijnake —tau jiaahua jü Fésto. ");
INSERT INTO mfy_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Yokoríapo béja jü Agripa éntok Berenice áman yájaka, yörisi machisi emo yáalamtaka yäuchim jojóyëu kiímuk jume sontaróu yäuchimmak éntok jume oóhuim puéblopo chë yörihuammaki. Huanäi jü Fésto Pablota áman nütebok. ");
INSERT INTO mfy_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ama ä nüpahuak, jü Fésto ínel jiaahua: —Empo rey Agripa, éntok eme oóhuim im itomak aneme, imi aane ï yoreme. Juebena judíom ä béj‑reka inou nooka jum Jerusalémpo éntok ímï Cesaréapo junne, sootí jíaka kaa ä jíapsiria nésauhueka. ");
INSERT INTO mfy_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Të ínapo kaita huaka béttesi machik ä mëtebonakemta at téuhuak, éntok áapörik juka rey Augusto Césarta, Romapo yäutta, nokta áachä chupä ïä béchïbone áman au ä bíttua báreka tahuala. ");
INSERT INTO mfy_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tëne kaita juka tua lútüriata áa bétana hua nésauhuemtau ín jïojtemachik jípure. Kíalïkune enchim bíchäpo yéä tójja, të emou tühua, empo rey Agripa, enchi ä temaijnakë béchïbo jita ä yáalatukä bétana. Béttesi machik ä yáalatukäu enchi at téakne ín au jïojte machik jípunake, hua nésahuemtahui. ");
INSERT INTO mfy_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bueïtukne kaa ä lútüriale pereesota áman bíttuaka éntok, kaa jüneehuamta nénkako jita bétana ä nätuatukähui. ");
INSERT INTO mfy_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Huanäi jü Agripa Pablotau ínel jiaahua: —Licénsiatë jípure em emo nok‑rianakë béchïbo. Huanäi Pablo jikau mámteka ínel áu nok‑ria táytek: ");
INSERT INTO mfy_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Tüisine al‑leiya em bíchäpo aneka, empo rey Agripa, ín ino nok‑rianakë béchïbo, sïmeta huame judíom nee béj‑reka nokäu bétana. ");
INSERT INTO mfy_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Chë júnene al‑leiya, huaka sïmeta jume judíom boojoriau em jüneria béchïbo, éntok jita bénakut itom nau nok nássuähui. Kíalïkune em jíapsi yánti yécharika enchi nee nok jíkkaij ïaaka emou nooka. ");
INSERT INTO mfy_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Sïme judíom jüneiya ilitchika naateka jachin ín ino nükähui, áme násuk aneka áman ín buíaräpo éntok buere joära Jerusalémpo junne. ");
INSERT INTO mfy_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bempo ket jüneiya, éntokim ára yéu ä buisse ínel eäteko, jübua yötuka naateka jume parisérom béu ín éaïhui, hua grupo itom religionpo chë júne Moiséjta nésahue páman au boojóriame. ");
INSERT INTO mfy_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Én éntokne imi yäurata bíchäpo yeu toij iäi ín boobíchä béchïbo, juka Diosta jume kókkolam jíabitetuanakëhui, jume itom yoiyöhuammeu ä nokákä bénasi. ");
INSERT INTO mfy_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Sïme jume Israelta dóoce üusimmet yeu kat‑ríam huaka nokta yáata chúpëu boobíchaïhui, kíalïkum juka Diosta yöre, éntokim at tekipánoa taáhuarit tukáarit naabúrujti. Én éntok, empo rey Agripa, ket jíba júkäi ín boobíchä béchïbo, jume judíom nee nätuala. ");
INSERT INTO mfy_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Jatchu eme kaa ä súale jäku juka Diosta jume kókkolam jíjiabitetuähui? ");
INSERT INTO mfy_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Ínapo bannaataka lútula huëpo tüisi ino ayúnake bénasi eiyai jume Jesús Nazaretpo jometa súaleme jiókot joaka. ");
INSERT INTO mfy_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Éntokne junëli am johuai jum Jerusalémpo. Jume tiöpopo tékiakammeu nésauhueme bétana útteata jípureka, ínapo juebénam Jesucrístota súaleme cárceliu tójjak, éntok am súahuai júnene huame am súakame beu eiyai. ");
INSERT INTO mfy_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Juebénasine jiókocham johuai bem súalëu am toij ïaaka. Íkäine johuai sïmat jume judíom nau yayajäpo. Tüisine kaa huéeläpo ámeu omtei, kia jum puéblompo sékäna buíaräpo jokäpo júnene am guokjájasei. ");
INSERT INTO mfy_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Júnëline éaka jum pueblo Damascou bíchaa hueiyei, útteata jípureka éntok tékiata máktaka jume tiöpopo sacerdote tékiakammeu nésauhueme bétana. ");
INSERT INTO mfy_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Të jum böchi, empo rey, tua lútula kátekne machíriata téhueka bétana kom sikamta bitchak täata machiria béppa chë útteakamta, ino chíkola nee machíriakamta, éntok jume ínomak kateme chíkola. ");
INSERT INTO mfy_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Huanäite sïme buíapo huáttek. Ínapo éntok, senuk téhueka bétana inou nokamta jíkkajak tua ín nokpo, hebreo nokpo, ínel jíamta: “Empo Saulo, ¿jatchíake nee guokjájase? Empöisë kökosi emo johua, juka buesta sísïguok buahuita témmü bénasi.” ");
INSERT INTO mfy_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Huanäine ínel jiaahua: “¿Jábesaë empo, Señor?” Jü Señor éntok, ínel júchi inou jiaahua: “Ínapone jü Jesús, jü em guokjájjasëhui. ");
INSERT INTO mfy_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Të kátë jachin éaka kikte, bueïtukne ín nésauhui em jonákë béchïbo emou ino yeu machíriak, éntok juka én em bíchakäu bétana em noknákë béchïbo, éntok chúkula em nee bínnake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Énne huame kaa judíommeu enchi bittuanake. Huámëi mampo, éntok judíom mámpone enchi áma yorétuanake. ");
INSERT INTO mfy_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ámeune enchi bíttuanak juka ín lútüria enchi am majtíanakë béchïbo, kaa jíba kaa ä täyaka bem jíapsinakë béchïbo. Huanärim kaa éntok Satanásta útteara bétuk emo jípunake, ál‑lam Diosta éä páman kannake. Júnëlim nee súaleka hua bem juëna yáarikut jiókoritunake éntok jume Diosta bíchäpo tüisi tahualame násuk annake.” ");
INSERT INTO mfy_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Kíalïkune juka Jesústa téhueka bétana inou nokákäu chúppak, empo rey Agripa. ");
INSERT INTO mfy_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Jume Damascopo anémmeune báchä noókak juka tü nokta Jesucrístota bétana huemta, Diostau bíchaa emo an jíapsi kúakti sáhueka tühuata joaka jünakiachinakë béchïbo bem jíapsi kúaktilatukä bétana. Chúkulane éntok, jume Jerusalémpo anemmeu ä noókak éntok sïme Judea buíaräpo anémmehui, álë bénasi huame kaa judíommeu junne. ");
INSERT INTO mfy_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Juäri béchïbo jume judíom jum tiöpopo nee buíssek nee mëbáreka. ");
INSERT INTO mfy_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Të Diosta nee aniä béchïbo jíbane at tekipánoa óusi éaka én tajti, juka tü nokta sïmemmeu nokaka, rikommeu éntok kia polóobemmeu junne. Kaítane entok ámeu nooka huaka jume profétam éntok Moiséjta nokákäu jíbba, jü ayúnakemta bétana. ");
INSERT INTO mfy_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bueïtuk bempo juka Crístota jiókot máchirata bínnake tíiyai, éntok mukuka jume kókkolam násuk báchä jíabitenake tíiyai, éntok juka Diosta lútüria judíommeu ä noknákë tíiyay, éntok kaa judíommeu junne. ");
INSERT INTO mfy_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Júnëli juka Pablota au nok‑riai, jü Fésto cháchayeka ínel jiaahua: —¡Rokotuläe, Pablo! Huä buere jita em emo majtíä béchïbë rokótulaë. ");
INSERT INTO mfy_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","—Kanne rokótula, empo Fésto tua yörihuame —tau jiaahua jü Pablo—, ál‑la jü ín nokäu tua lútüria. ");
INSERT INTO mfy_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Imi aane jü rey Agripa sïme juka huemta tüisi jüneriame, kíalïkune kaachin éaka áa jíkkajäpo nooka. Lútüriapone áapörik sïmeta íkäi jünériä tíiya, bueïtuk jü ín áa bétana nokäu kaa jak éhuil yáari. ");
INSERT INTO mfy_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Játchë juka profétam nokákäu súale, empo rey Agripa? Ínapo jüneiya em ä súalëhui. ");
INSERT INTO mfy_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Huanäi jü rey Agripa ínel au jiaahua: —Jamake kaa jaiki nokiai juka Jesucrístota nee sualmáchile. ");
INSERT INTO mfy_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo éntok, ínel au jiaahua: —Tua Dios ínel éenake, ilikki nokiai éntok kia bürukuai junne, empo éntok jume huate én nee jíkkajame júne ino bénasi tahuánake, të kaa cadenammea súmataka, ál‑la Jesucrístota súaleka. ");
INSERT INTO mfy_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Juka Pablota junëli jíak, jü rey kíktek, éntok jü gobernador, éntok Berenice, éntok sïme huame áma jokáïhuim. ");
INSERT INTO mfy_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Huanärim sékäna bíchaa sájaka, nau ettéjhuaka ínel jiaahua: —Ï yoreme kaita béttesi machik ä mëtebonakemta yáala, kia ä peréesotebonakemta junne. ");
INSERT INTO mfy_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Huanäi jü Agripa Féstotau júchi ínel jiaahua: —Átä búttiä eiyei íkäi yoremta kaa áapörik juka Romapo chë nésauhuemta nokta at chupa ïaayo. ");
INSERT INTO mfy_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Jum Italia buíarau bíttua báahuaka jü Pablo éntok huate peréesom jü capitán Júliö téamta mampo jóahuak, hua Augústota batallonpo jometa mampo. Ínapo Lucas, Pablótamakne siika. ");
INSERT INTO mfy_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Huanäite jum barco Adramítena teäu jomepo nuk sákahuak, Asia buiärau bíchaa huátaktëpo. Aristarko éntok, ket itomak hueiyei, jü Tesalónicapo joome, hua pueblo Macedonia buíaräpo káttekäpo. ");
INSERT INTO mfy_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Yokóriapote jum puerto Sidonpo yájjak. Huämi Julio tüisi ä al‑lériaka ä bitchak juka Pablota, kia huame ä täyäu bëkatana júne náasä huéenakë béchïbo ä licénciak ä aníanä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jum Sidonpo yeu sájakate juka isla Chíprë míkötana tösájjak, bueïtuk jü jeka itom béj‑reka hueiyei. ");
INSERT INTO mfy_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Jum Cilicia buiärahui, éntok Panfilia buiära beute jü bahue naabúrujti yeu sájaka jum pueblo Mírä teäu yeu yájjak, Licia buíaräpo. ");
INSERT INTO mfy_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Huämi jü capitán senu barcota téuhuak Alejandríapo jometa Italia buíarau bíchaa huátaktemta ama itom jämu sauhue buoula itom huéria báreka. ");
INSERT INTO mfy_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Juebena táapote läuti jíba kateka, jiókot anpo jum puerto Gnídö beu yájjak. Ketune juka jekata itom béj‑reka huë béchïbote puerto Salmón beu áman sájjak isla Cretä téamta kontíaka. ");
INSERT INTO mfy_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Júnëli juka jekata itom béj‑reka huei júnete jíba boojohuai bahué mayóamak lópola. Júnensute Buenos Puertos téhuakäu yájjak, jü pueblo Laséäu kaa mekka káttekähui. ");
INSERT INTO mfy_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Júnëlite bínhuatuk, éntok béja kaa türiakai bahuepo boojo béchïbo, jume buere jékam béchïbo éntok béja sebe kíbakei. Huäri béchïbo jü Pablo ");
INSERT INTO mfy_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ínel ámeu jiaahua: —Eme oóhuim, ika boojóohuamtane kaa tüisi bitcha. Júkate barcota tärunake éntok huaka áma huériahuamta junne, éntok ítapo júnete jamak itom jíapsi tärunake. ");
INSERT INTO mfy_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Të jü capitán juka barcota huériamta chë nok súalei éntok juka ä átteakamta, jü Pablota béppa. ");
INSERT INTO mfy_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Huákäi puertota kaa türiakäu jünériaka jum séberiapo áma anbéchïbo, sïme jëla áma yeu sákahuak junne türianake tíiyai, jamak júne Feniceu yáijnake ti éaka, hua puerto Cretapo kátekäpo, huämi juka séberiata pasároa báreka. Huäri noresteu bíchaa pújbaka káttek éntok suresteu bícha. ");
INSERT INTO mfy_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Huanärim sur bétana juka jekata kaa útteaka huë béchïbo al‑léaka emo boojóomáchilek. Yeute sájaka jü Creta bahué mayóat kattáitek. ");
INSERT INTO mfy_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kia lauti jëla buere jeka Noréstë téame juka barcota útteaka béebaka, ");
INSERT INTO mfy_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ä huéria táytek. Atä béj‑reka kaakun kat máchika kíal ä tójjak; huanäi itom nuk siika. ");
INSERT INTO mfy_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Jü ili isla Claudä téamta huamte sájjak, jekata kaa útteaka huëpámani. Huanäite jiókot anpo juka ili canoata itom huíksakäu itou huíkeka barcopo jikáchä teekak. ");
INSERT INTO mfy_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Béja jikáchä téksukam huite buerémmia juka barcota nate chíkola nau súmmak kaa näikim ä huénnakë béchïbo. Huanärim jum sëéu Sírtë téäu emo kimumáchileka májhueka, jume velam búttiaka jekámak sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yokóriapo jíba bénasi juka jekata útteaka huei, juka barcopo bem huériäu bahuéu kom huötiatáitek. ");
INSERT INTO mfy_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Baij taáhuata huei éntok, ítapo am aníaka juka barco átteata áma huériihuamta bäau kom huötiak. ");
INSERT INTO mfy_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Yuun jaiki táapote täata kaa bitchak, kia chokim junne, éntok juka buere jekata itom bébä béchïbote béja kaa yorem eiyai itom áma yorénake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Béja jaiki táapo kaa itom jïbuä tíaka jü Pablo áme násuk kíkteka ínel jiaahua: —Eme oóhuim, chë türi eiyei eme nee nok jíkkajako. Katte jum Cretapo yeu sájakätek íkäi jiókot máchiraata kaa bít eiyey, éntok huaka enchim huériäu júnem kaa tärü eiyei. ");
INSERT INTO mfy_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Të katem kom eiya, bueïtuk ito násuk kaibu jábe muknake, tem juka barcota ál‑la jíba tärunake. ");
INSERT INTO mfy_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tukábiak jü Diosta ángel inou yépsak, áapörik bétana inou jaatáka, hua Dios nee sáuhuemta bétana éntok hua ín áa béchïbo tekipánoähui. ");
INSERT INTO mfy_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Huäri Diosta ángel ínel inou jiaahua: “Kátë jachin eiya, Pablo, bueïtukë Romapo chë nésauhuemta bíchäpo yeu toijna, éntok emo béchïbotuk jü Dios sïme jume barcopo émomak kateme bem kókko éäpo áma am yoretuanake.” ");
INSERT INTO mfy_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Júnentuk, eme oóhuim, óusem eiya, bueïtuk ínapo jü Dióstat eiya, éntokne jüneiya juka Diosta ángel nokakä páman ä lútüriatunakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Të ál‑late senu islau yeu biáktinake —ti ámeu jiaahua jü Pablo. ");
INSERT INTO mfy_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Séjtul tukáapote, béja guoi semáanapo boojóolataka, jum bahué Adriatico ti téhuaakapo jü jeká naa itom núnübuai, huanäi tukáa násuk huei jume barcopo tekipánoame jünëak bahué mayoau itom yeu yáijböhui. ");
INSERT INTO mfy_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Huanärim juka bäta jäimu mekka kömiakäu jünéria báreka ä jünaktek. Huanäi treinta y seis métrotukai. Júchi huam jëla katékam júchi ä jünaktek. Huämi éntok, veintisiete metrota jípurey. ");
INSERT INTO mfy_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Huanärim májhueka jü barcota jita tetau tajti máchileka, naiki anclam barco chobe bétana huéeme kom huötiaka jáptek. Huanärim májhueka noita júne machútua peiyai. ");
INSERT INTO mfy_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Jume áma tekipánoame éntok, jum barcopo yeu kat báreka eiyai. Kíalïkum juka ili canoata bäau kom jímma báarei, jume anclam barco kóbapo kateme kom huötia báaremcha aneka. ");
INSERT INTO mfy_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Të jü Pablo juka capitanta téjhuak éntok jume ä sontaróahuam, ínel ámeu jiaka: —Ímëi yorémem kaa jum barcopo tahuak, eme kaibu áma yorénake. ");
INSERT INTO mfy_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Huanäi jume sontarom jume huitérim ili canoata ámei huítetuatukäu chúktiaka bäau kömä tátabek. ");
INSERT INTO mfy_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Marikaróapo béja jü Pablo sïmem téjhuak am jïbuä sáhueka. Ínel jíaka: —Béja guoi semáana huéiye eme kaa al‑léaka kócheka, éntok kaa enchim jíapsiläpo jïbuäka. ");
INSERT INTO mfy_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nóitem jïbuä. Útteatem nüye kaa kókko bárëteko. Óusem éiya. Jüneäem kaibu jábe ímï bäapo muknake. ");
INSERT INTO mfy_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Júnëli jiausuka jü Pablo huépul páanim nüka Diostau nokak ä baisáuhueka sïmem bíchäpo, éntok am rébektiaka am buätáitek. ");
INSERT INTO mfy_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Huanäi sïme óusi ëaka ket jïbuätáitek. ");
INSERT INTO mfy_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Sïme ítapo jume barcopo nau katéïhui guoi ciento setenta y séistukai. ");
INSERT INTO mfy_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Chúkula bem jóboäpo núkisi jïbuäka, jume tiríjkomim bahuéu kom huötiak barcota kaa béttesi huéenakë béchïbo. ");
INSERT INTO mfy_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Yeu matchuk jume barcopo tekipánoame juka buíata bitchak, kaa ä täyaka jachin ä téhuaakähui. Tem juka bahué komíata see päriata jípuremta bitchak. Huanärim áman bíchaa kat báreka taahuak, barcota ára áman emo rúktia máchileka. ");
INSERT INTO mfy_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Jume huiterimim chúktiak jume ánclam ámey chäkaïhuim, huanärim jume anclam bäapo tö sájjak. Jume barco timónimim yarajtiak ámey ä kúakúaktiahuähui, éntok jume velam bat huéeme jikau huíkkek. Huanäi jü barco bahue komiata mayoau bíchaa huée táytek. ");
INSERT INTO mfy_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Të jum bäata au nánkëu bíchaa siká, huämi jü barco kobba sëepo tútteka béja kara huéeka taáahuakk. Jume máarem éntok, juka barco chóbeta chíbela jámtiak. ");
INSERT INTO mfy_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Huanäi jume sontarom jume peréesom suabábarek kaa yéu am bajúm ïaaka, am tennimáchileka. ");
INSERT INTO mfy_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Të jü capitán juka Pablota ä jínëubárë béchïbo kaa licénciata nénkak, ál‑la am téjhuak jume ára bajúmeme noita bäau emo huötiaka mayoau emo am jínëutuanake tíaka, ");
INSERT INTO mfy_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","jume huátem éntok, tablámmet yeu bajúm sauhue éntok barco kuta kóttilammechi. Júnëlite sïme yeu bajúmeka áma yoórek. ");
INSERT INTO mfy_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Béja sïme áma yorésuka, jünëeak juka íslata Malta ti téhuaakähui. ");
INSERT INTO mfy_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Huame áma joomem al‑léaka itom mabétak. Sejchúktim bueürum itom náariak sébë tíaka éntok yúkë tíaka. Huanärim sïmem itom tájimmeu rukti sauhue itom sukäu ïaaka. ");
INSERT INTO mfy_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Huanäi juka Pablota kuta huakíam nüka taijpo ä tóttöai, jü bakot tüisi jóguokame tatájaka áma yeu huánteka mampo ä këka at chäka taahuak. ");
INSERT INTO mfy_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Jume áma joome éntok, juka bakotta Pablótat mampo chäkamta bíchaka ínel nau jiaahua: —Ï yoreme jíba tua yore súaleero. Bahuepo kaa muukuk, të jü Dios ä yáari béchïbo kaa ä jíapsï ïaa. ");
INSERT INTO mfy_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Të jü Pablo táijpo au tátakeka juka bakotta áma kom tátabek éntok kaachin aika. ");
INSERT INTO mfy_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sïme at suuhuai ä mam baijmáchileka. Tem binhua at suaka, kaachin ä ayúi, täbuiasi eetáitek. Jukam Pablota dios tíiyai. ");
INSERT INTO mfy_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Huämi kaa mekka senu yoremta buíam tökai, Públiö téamta buíyam. Áapo huämi islapo nésauhuei. Huäri tua al‑léaka itom mabétak, éntok tüisi itom aníak baij táapo. ");
INSERT INTO mfy_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Júnaksu éntok, jü Públiota átchay taijhuécheka bökai éntok kökoa disentériä téamtai kökoreka. Huanäi jü Pablo áman ä bíchiseka siika. Ä bíchaka, Diostau buanaka choápo áa béppa ä mámtek türiak. ");
INSERT INTO mfy_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Íkäi jüneriaka jume huate génte kökoreme islapo jóakame au yaij táitek; huanärim türiak. ");
INSERT INTO mfy_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Huanärim tüisi itom yöreka itom bitchai. Chúkula júchi itom saka báareyim sïmeta huaka böot béchïbo itom huáatianakeu itom miikak. ");
INSERT INTO mfy_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Béja baij metpo jum islapo anékate bäau huáttek senu barco áma séberiata pasároakäpo. Áapo Alejandríapo jométukai, jume diósim Cástor éntok Póluxta titéhuaakame señáalim huériai. ");
INSERT INTO mfy_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Jum puerto Siracúsä ti téhuakapote yeu yájjak. Huämite baij táapo aanek. ");
INSERT INTO mfy_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Huämi éntokte boula sájjak jíba jü bahué mayóamak lópola jum pueblo Reegiö ti téhuakäu tajti. Yokóriapote béja sur bétana jekríahuak, júchi machukte béja jü pueblo Puteólï ti téhuakapo yeu yájjak. ");
INSERT INTO mfy_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Huämite huate hermáanom téuhuak. Huámëi itom áma tahuá sauhuei senu semáanapo. Chúkula béjate Romáu bíchaa sájjak. ");
INSERT INTO mfy_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Jume hermaanom Romapo aneme béja nokta mabet‑latukay, itom áman katë bétana. Kíalïkum itom nankírika sájaka jum pueblo Foro Aapiö teäpo ito bea aaney, huate éntok, jum Baij Tabérnam teäpo. Jü Pablo am téaka tüisi Diosta baisáuhueka taahuak éntok óusi ëak. ");
INSERT INTO mfy_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Jum Romáu yáijhuak jü capitán jume peréesom jü sontaró yäutta mampo jóiyak. Të juka Pablota sékäna tójjak áapolaik áma annákë béchïbo, huépul sontarota ä suáyatuaka. ");
INSERT INTO mfy_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Baij taáhuareka áma yebíj‑lataka jü Pablo jume judíom Romapo chë yörihuame nau núnutebok. Nau am yájak, ínel ámeu jiaahua: —Eme ínomak huéerim, ínapo kaita jume judíom béj‑reka yáalataka, éntok kia bannaataka itom yóiyöhuam boojóriäu béj‑reka junne, jíbane jum Jerusalémpo peréesotehuaka romáanom mampo yéchahuak. ");
INSERT INTO mfy_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Huanäi jume romáanom ínot nátemajeka nee búttia báarei, bueïtukim kaita lútüriata ínot téuhuak nokta béttesi ínot bem chúpaka ín mëtunakëhui. ");
INSERT INTO mfy_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Të jume Israelitam katim báreka taahuak. Kíalïkune juka Romapo chë nésauhuemta nokta ínot chupa ïaka nookak, kia kaita béchïbo ín nación nätuamáchik junne. ");
INSERT INTO mfy_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Júnel béchïbone enchim núnutebok enchim bit báreka éntok enchimmeu nok báreka; bueïtuk ítapo jume Israelítam boobíchäu béchïbone imi cadenammea súmataka jípuhua. ");
INSERT INTO mfy_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Huanärim ínel au jiaahua: —Ítapo kaita jiösiata Judea bétana huemta mabet‑la emo bétana nokamta, éntok kaabe jume judíom itomak huéerim huannäbo äbo yáij‑lame kaita juënak emo bétana nooka. ");
INSERT INTO mfy_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Enchite nok jíkkaij peiya jachin em éäu jünéria báreka, bueïtukte jüneiya sïmekut ï bemela yore majtíahuamta béj‑reka nokhuähui. ");
INSERT INTO mfy_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ä nok jíkkaij bárekam taáhuata ä yéchariak. Taáhuata yúmak, juebena génte áma nau yájjak jum Pablota anéïpo. Huanäi kethuéi naateka kúptëu tajti ámeu noókak jachin juka Diosta im buíapo nésaunakëhui. Moiséjta ley bétana ámeu noókak, éntok jume profétam jïojtekäu bétana, Jesústa jü Crístotukähui, jü Diosta yeu púari, am súal ïaaka, éntok im buíapo ä nésaunake bétana. ");
INSERT INTO mfy_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Huate juka Pablota nokákäumak al‑léaka taahuak, huate éntok, kaa ä súalei. ");
INSERT INTO mfy_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Júnëlim kaa nánancha bem éä béchïbo sáka táitek. Huanäi jü Pablo ínel ámeu jiaahua: —Ammäli jiaahua jü Espíritu Santo juka profeta Isaíasta ínel jiáutuaka jume itom yóiyöhuammehui: ");
INSERT INTO mfy_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ámanë sika ï gentetau ínel jiaahua: Jíbem ä jikkaijnake jiöbe eme, të kaa at jünéaka; akém ä bínnake jiöbe, tem kaa ä súalnake. ");
INSERT INTO mfy_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Bueïtuk bempo kaa at jünee báreka eiya. Emom naka páttiak kaita jíkkaij báreka, éntokim kúpek kaita bit báreka, kaa am jíapsi kúakteka ín am jínëunakë béchïbo, tiahua jü Espíritu Santo. ");
INSERT INTO mfy_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Júntukem jünéaka taáhua eme, én naateka pujbau bíchaa juka yore jínëihuamta Diosta bétana huemta jume kaa judíom béchïbotunakëhui. Huámëi ál‑la al‑léaka ä mabénnake. ");
INSERT INTO mfy_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Juka Pablota ínel jíak, jume judíom sájjak juebénak nau noksákaka íäri bétana. ");
INSERT INTO mfy_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Jü Pablo jum kári ä reu jínulapo guoy huásuktiapo aanek. Huämi sïme jume ä bít báreka áu yayájame al‑leaka mabetay. ");
INSERT INTO mfy_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Sïme licenciata jípurey, juka Diosta ím buíapo nésaunake bétana kaabe ä táktiriay.");
INSERT INTO mfy_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ínapo Pablo, Jesucristota nésahui joame, apóstoltu ïaahuaka núnuri. Jü tü nooki Diosta evangelio ín noknakë béchïbone yeu púari. ");
INSERT INTO mfy_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Dios ínel ä yáa rókaka nok‑latukay, jauhuey naateka jume ä profeetam huämi, juka huépülsi huëpo Diosta bétana ä jïojtekä pámani, ");
INSERT INTO mfy_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ä Üusihua bétana, itom Señor Jesucristo, rey Davidtat yeu simlame. ");
INSERT INTO mfy_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Huanäi Dios ä täyatebok; junëli tua Diosta ä Üusitukähui, úttiärata jípureka, Espíritupo huépülsi huëpo áu ä nükä béchïbo, entok kókkolam násuk ä jíabitekä béchïbo. ");
INSERT INTO mfy_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesucristota huámtä mabet‑la juka kaa náksi tühuata apóstolimtu sáyhuakä. Huanäite béja íkäi sïme ániapo anemmeu noknake, ä nésahui súaleka am yáanakë béchïbo, ä téhuam jíba yöreka. ");
INSERT INTO mfy_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Huámë násuku eme két áma näikiari, Jesucristota áttiamtu ïaahuaka. ");
INSERT INTO mfy_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Sïme eme jume buere joära Romapo aneme, Diosta nákëhuim, Diosta nésahui huépulta bénasi jíba joaka núnurim, jíapsi béchïbo yeu púarim: Diosta kaa náksi tühua entok yánti jíapsihuame enchim béchïbotunake, Dios itom Áchay bétana huéeme entok jü Señor Jesucristota bétana. ");
INSERT INTO mfy_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Kaita bát jee enchimmeu nokaka juka ín Diostane baisau báare, Jesucristota huám ámani enchim bétana nokhuamta. Béja sïmekut jíkkaij‑ri, juka jáchin tüisi Diosta enchim súalëhui. ");
INSERT INT