﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfxl_vpl;
CREATE TABLE mfxl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfxl_vpl WRITE;
INSERT INTO mfxl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dawute na7a Afraame na7a maaqqeez Yesuus Kiristtoosa yeletith. ");
INSERT INTO mfxl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Afraame Isaaqa yeleeza; Isaaqa Yayqqooba yeleeza; Yayqqooba Yihudarannee e ishita yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihuda Ti7imaaripp Paaresannee Zaara yeleeza; Paaresa Asroome yeleeza; Asrooma Raame yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raame Aminadaba yeleeza; Aminadaba Na7asoona yeleeza; Na7asoona Salmoone yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoona Ra7aabppe Boo7eeza yeleeza; Boo7eeza Uritppe Iyobeede yeleeza; Iyobeede Issaye yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Issaye kaata Dawite yeleeza; Kaat Dawite Ooriyo machchattippe Solomone yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomone Robi7aama yeleeza; Robi7aame Abiya yeleeza; Abiye Asaafe yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaafe Iyosaafexe yeleeza; Iyosaafixe Iyoraame yeleeza; Iyoraame Oozanee yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oozanee Iyo7ataame yeleeza; Iyo7ataame Akkaza yeleeza; Akkaza Hiziqasa yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiziqasa Minaase yeleeza; Minaase Amooxa yeleeza; Amooxa Iyosaasa yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iyosaasa Ikonaanarannee e ishita yeleez ya laythate Isreele asay di7inttii Baabiloone biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baabiloone biitta Isreele asay di7inttii yhanigeezaypp guye Ikonaana Salatiyaale yeleeza. Salatiyaale Zerubaabela yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabela Abdiyu yeleeza; Abdiyu Eliyaaqeme yeleeza; Eliyaaqeme Azoora yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoora Sadooqe yeleeza; Sadooqe Akime yeleeza; Akime Eliyuuda yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuuda Alaazara yeleeza; Alaazare Maatane yeleeza; Maatane Yayqqooba yeleeza; ");
INSERT INTO mfxl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayqqooba Yooseefa yeleeza; Yooseefa Kiristtoosa giz Yesuusana yeleez Mayramii azina. ");
INSERT INTO mfxl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yikkee, yeletithii Afraamepp Dawute hellodayis taphpho oydde. Dawutepp yhanigii Baabiloone di7a hellodayis taphpho oydde. Baabiloone di7aypp yhanigii Kiristtoosa hellodayis taphpho oyddii yeletithi maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesuus Kiristtoosa yelintto taarikay yhaypp kaalliza. E indat Mayrama Yooseefas oyccinttii yezar Yooseefar wolla aqekkazar geeshsha Ayyanapp woddexeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yooseefa geesh as maaqqeez gisho izo asii ododay garkk koyekkazay gishos geemar ashshodayis qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E ye qofayil yezin Xoossa kiitanchchay abukkar ees benttii, «Dawute na7a, Yooseefa, Mayrama woddexeezay geesha Ayyanapp maaqqeez gisho izo ekkodayis yashittippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iza dhiirath na7a yeloda, E woyita u nagaraypp ashshizay gisho e suntha ne Yesuusa gi xeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Goday nabay doonar, ");
INSERT INTO mfxl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Yeezako wudirtta wodexxoda; dhiirath na7a yeloda; e sunthay Amanu7eela ginttinttoda» geezay polinttoday garkk yha ubbay haneeza. Amanu7eela guusayis birshshithay «Xoossay nuuri yeza» guussii. ");
INSERT INTO mfxl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yooseefa genttapp barkkii Goday kiitanchchay kiitteezay garkk Mayramo fa kara kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Zin fa bayra na7a yelod gatho izo bochchekaya; yelintteez na7akka Yesuusa gi xeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kaat Herodoosa wode Yesuusa Yihuda biitta Beeteleme katama yelintteezaypp guye xoolintto filagizitay awa kess baggapp Yerusalaame yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«Yelintteez Ayihuditay kaatay aba yenee? Nu awa kess baggar kezeez xoolintto bi7ii ezisi goynnodayis ye7eeza» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kaat Herodoosa yeya si7ii dagameeza. Yerusalaame yez as ubbaykka dagameeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodoosa qeese halaqitannee higge asitamaarita faako xeegii «Kiristtoosa aba yelinttodeshsha?» yeegii unttan oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Unttikka, «Yihuda Beeteleme nabay, ");
INSERT INTO mfxl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« ‹Yihuda yez Beeteleme, Yihuda yez gade aqisizitaypp, ne abarakka kawuzhooya. Ta woya Isreele haarizay, neepp kezoda eekka ta woya Isreele heenggiza maaqqada› gi xaafeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yeypp guye, Herodoosa awa kess baggapp ye7eez asita geemar xeegii, xoolintto u be7eez layitha unttapp lo7ithii oyicii ereeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E unttan Beeteleme dakkittar, «Yhanigii yelintteez na7a miinthii kozhoytta; eza yi denggiko taakka yhanigii ezisi goynnodgarkk maaqqittar taasi odoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Unttikka kaatay Herodoosa odeezana si7ii qiteeza. U awa kess baggar be7eez xoolinttay unttan kaalithittar na7ay yeza aqayid eqqod hellodayis kanggii heltheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","U ye xoolintta bi7ii aqopp aath ufayss ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kara gelii na7ay fa indat Mayramir yezana be7eeza. Ees xuggunii goynneeza. Fa saaxina dooyii worqqera, ixaanerannee karbera eesi inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","U Heroodosako guye maaqqaamay garkk Xoossay abukkar unttis odin, hara oger fa biitta maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Awa kess baggapp ye7eez asay qiteezaypp guye, Goday kiitanchchay Yooseefas abukkar benttii, «Herodoosa na7ana wodhodayis koyizigishos denddoba; ellisii na7ayira na7ay indatira ekkii Gibxxe biitta yhanigoba. Ne maaqqad gallasa nees odod gatho ezayid gam7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yey gishos, Yooseefa qammar denddii, na7ayira na7ay indatira ekkii Gibxxe yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nabe doonar Xoossay, «Taanii, ta na7a, Gibxxe biittapp xeegeeza» ginttintteez qaalay polinttod garkk Herodoosa yhayqqod hellodayis E ezayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yeypp guye, awa kess baggapp ye7eez asay eza dooshsheezana erii iita yiloteeza. E tiin unttapp si7eezay garkk Beetelemennee ye heera yez nam77ii laythi kumezitannee nam77ii laythapp sulle yez dhiirath na7ita ubba fa wotaaddarita dakkii wodhiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nabe Ermaasa doonar, «Yeefonnee zelalisii, Raama sintteeza. Iraheela fa na7itayis yeekkiza; u yhayqqeez gishos Minggodayis danda7ekkaya» gi odeezay polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodoosa yhayqqeezaypp guye Goda kiittanchchay Yooseefas Gibxxe abbukkar benttii, ");
INSERT INTO mfxl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Na7a wodhodayis koyizitay yhayqqeez gishos denddii na7ayira na7ay indatira ekkii Isreele biitta maaqqoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yooseefa denddii na7ayira na7ay indatira ekkii Isreele biitta maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Zin Arkkiloosa Yihudal fa aday Herodoosa aqo kawuteezana si7ii ye aqa yhammadayis yashitteeza. Xoossay abukkar eza beezin Galila biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nabitay doonar, «Naazirete as ginttinttoda» gi odintteezay polinttod garkk Naazirete katama yhanigii ezayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Ye wode xammaqiza Waannisa, «Xooss kaatetithii ukkeez gishos yi nagaraypp maaqqoytta» yeegii sabbakittar Yihuda liizho gadhar ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nabe Isayaasa odeezay Waannisa bagga, «Liizho gadha, pettii athay fa qaala dhoqqi udii, ‹Goday goossa lo7ithoytta. E oga pitithakka luulisoytta› geeza» yeegintteezay eesii yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Waannisa gimaale ikisepp dadintteez afila ma77iza. Fa xeessayidakka dafe dancciza. E miiz kathaykka boolerannee degera eessara. ");
INSERT INTO mfxl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asay ye wode Yerusalaame katamappe, Yihuda biitta ubbaypperannee Yorddanoose borkka heerape eeko yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Fa nagara buuxittar Yorddanoose borkka e kushe xammaqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ezkka, gaame Ferisaawitayppennee Saduqaawitaypp gaamitay xammaqinttodayis faako yi7izita bi7ii, unttiko, «Yha shoosh na7untho, ye7od Xooss kachchaypp qosinttodaygarkk yinttan oonoo zoreezay? ");
INSERT INTO mfxl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yikkee, yinttii, yi nagaraypp maaqqeezana beeziza aafe aafoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yi, yi wozinara, ‹Afraame, nu ade gi yi qoppizaygarkk› yinttis maaqqippe. Lo7ithii si7oytta! Xoossay yha shuchchitayp Afraames na7a kessodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gande minxxay xaphayid giigii betteeza; lo77o aafe aafowa mith ubbay gachchinttii tama gancce wodhdhoda. ");
INSERT INTO mfxl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Yi, yi nagaraypp maaqqeezana erisodayis ta yinttan haathar xammaqiza. Zin taapp guyer yi7izay yinttan geesha Ayyanarannee tamar xammaqoda. E taapp lo7ithii miinggiza; ta hara attozin E caamma tookkodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Katha geeshshiz pithe E kushayid yeza. Katha lo7ithii geeshshiza; gistta fa shaalayid oloda, zin bunna to7oowa tamayid xuuggoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ye wode Yesuusa Waannisa kushayid xammaqinttodayis Galilappe Yorddanoose borkka yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zin Waannisa eza kayodayis koyii, «Ta ne kushayid xammaqinttodayis beezodar ne taako yi7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesuusa mahii, «Xoossii nuuppe kozhiz baz ubba nu polodayis beezizay gishos yhatti taasi ero goba» yeegeeza. Waannisa ezis ero gi eeza xammaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuusa xammaqintteezan garkk borkkapp kezeeza. Izirakka salo dooyinttin Xoossa Ayyanay holle garkk yi7ii ezal wodhdhodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ye wode «Ta qadhdhiza na7ay, ta ufayttiza na7ay yhaya» yeegiz qaala salopp ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yeypp guye, daabuloosa Yesuusa faaccod garkk Geeshsha Ayaanay Yesuusana liizho gadha kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ezayid oyttam qammannee oyttam gallas xoomeezaypp guye nayintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Paaccizay Yesuusako yi7ii «Ne Xooss na7azako, an yha shuchchunthan boora maaqqoday garkk azazoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuusa mahii eeko, « ‹Asii Xooss doonapp keziz qaala ubbayir yezizapp attin boora aaddar yezooya› yeeginttii Xoossa qaalayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ezaypp maaqqikka, daabuloosa Yesuusana geesha katama kanggii, Xooss keeth kusttel afa kessii, ");
INSERT INTO mfxl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Ne Xooss na7a maaqqiko, an sull guppii wodhdhoba.» Abis giiko, « ‹Ne tokay shuchchar dhubinttaamay garkk, fa kusher nena denthoday garkk, Xoossay fa kiitanchchita ne gishos kiittoda› yeeginttii Xooss qaalayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuusa eeko, «Maakka, ‹Xooss qaalayid ne Goda, ne Xoossa paaccippe› yeeginttii xaafintteeza» gi maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wurssithal daabuloosa Yesuusana pettii damma amba xeeral kessii alame kaatetitha u bonchchayir wolla beezii, ");
INSERT INTO mfxl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Ne taasi xuugunii goyiniko ta neesi yhaya ubba immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesuusa mahii eeko, «Yha xalahayyo, taapp haakkoba! ‹Ne Goda, ne Xoossayis goynnoba, eza aadda goyinnoba› yeeginttii Xooss qaalayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yeypp guye, eza Xalahay ashshii qiteeza; kiitanchchitay yi7ii eza maaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesuusa, Waannisa accintteezana si7ii Galila biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naazirete katama ashshii Zaabiloonannee Niftaaleme heera, abba lanqqe yez qifirnahoome katama yhanigii ezayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yey haneezay nabe Isayaasa doonar, ");
INSERT INTO mfxl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zaabiloone biitta, Nifttaaleme biitta, Yorddanoos borkkapp seko pino, abbako kanggiz oge gaxa yezi, Ayihude baa asay gancce yez Galila biitta, ");
INSERT INTO mfxl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dhuma yez woya, woliqqama poo7o be7eeza. Yhayiqo kuya betteezitayiskka, poo7o kezeeza» yeegii odintteez qaalay polinttod garkke. ");
INSERT INTO mfxl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ye wodepp aykkii Yesuusa, «Xooss kaatetithay ukkeez gishos yi nagarapp maaqqoytta» yeegii qaala sabbako aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuusa Galila Abba lanqqer aadhittar nam77ii ishita, Phixiroosa ginttinttiz Simoonarannee e isha Indiraase be7eeza. Unttii molo aykkizita maaqqeez gishos fa gitana abba gancce olizana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuusa unttan, «Yhana ye7oytta; tana kaaloytta! Molo aykkizay garkk, ta yinttan as aythi tamarssoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Unttikka, ellis fa gitana olii ashii Yesuusana kaalo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuusa yeypp xiqqa gede tiinal yhanigii hara nam77ii ishita, Zabddosa na7ita, Yayqqoobara Waannisara be7eeza. Fa ada Zabddoosara wolla wogolo gancce fa gite loythizin bi7ii xeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Unttikka, ellisii fa wogolo gancce fa ada ashshii Yesuusana kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuusa Ayihuditay Woosa keetha tamaarssittar, salo kaatetith Wongile oditara duma duma harggepp asa pathittar Galila biitta ubba yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yeypp denideezayid e waaray Soora biitta ubba si7intteeza. Duma duma harger wobbeezitannee metinttizita, tuna ayyana aykintteezita, shoccii oliz harger yezitannee, sileezita eziko kanggeeza; ezikka unttan patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Asay Galilap, Taphphii Katamitaypp, Yerusalaamepp, Yihudappera Yorddanoosapp seko pino yez biittapp ye7eez gaame asay eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gaame woya shiiqeezana Yesuusa bi7ii amball afa kezii betteeza. E tamaaritay eziko shiiqin, ");
INSERT INTO mfxl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yhay garkk yeegii taamarsseeza: ");
INSERT INTO mfxl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ayyanar manqqitay anjjintteezita, salo kaatetithay unttisii. ");
INSERT INTO mfxl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yeekkizitay anjjintteezita, u minthatho demmada. ");
INSERT INTO mfxl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Haayitay anjjintteezita, u sa7a laattoda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Geeshshetith nayinttizitaynnee saaminttizitay anjjintteezita, u mizhoda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maarizitay anjjintteezita, u maarotithi demmada. ");
INSERT INTO mfxl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wozina geeshshitay anjjintteezita, u Xoossa be7ada. ");
INSERT INTO mfxl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iginthizitay anjjintteezita, u Xooss na7ita ginttinttii xeeginttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Geesh bazis gi, bayi7inttizitay anjjintteezita, salo kaatetithay unttissii. ");
INSERT INTO mfxl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Asay yinttan ta gishos gi cazhii bayi7ii yinttal afa iita baz ubba worddor odiko yi anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yi salo yhanigii ekkod woyitay damma maaqqeez gishos ufayttoytta, habba goytta. Yinttapp tiina yez nabita yhay garkk bayi7eeza.» ");
INSERT INTO mfxl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Yi biittas maxine; maxine fa maxinettitha ashshiko, fa mal7ottitha wayizii mahii demmadee? Bale olin asar yedhinttodaypp attin abiskka maaddooya. ");
INSERT INTO mfxl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Yi biittas poo7o; derell afa yez katamtta geemodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomppe ayithii kara yez as ubbayis poo7oday garkk dhoqqa aqo gaddizapp attin ota gancce gaddizay baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yey garkk asay yi lo77o oosa bi7ii, salo yez yi ada bonchchoday garkk yi poo7ay as tiina poo7o. ");
INSERT INTO mfxl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Taanii Muse higgannee nabitay qaala shaarodayis ye7eeza yinttis aazppe. Ta, polodayis ye7eezapp attin shaarodayis ye7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta yinttis turo odiza; salonnee sa7a aadhod hellodayis higge ubbay polinttodaypp attin higgaypp pettii qaala woy pidaale xuuqakka aadhaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yey gishos, yha kiititaypp xiqqiza pettii kiita menthiza oonkka ma yhankkita yey garkk oothod garkk tamaarssizay oonkka salo kaatetititha ubbapp laafa maaqqoda. Zin yha kiita polizitaynnee yhankkitakka polod garkk tamaarssizay salo kaatetitha aath maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta yinttis odiza; yi xillotithay Ferisaawitay xillotithayppennee higge asitamaaritay xillotithaypp aadhekka attiko, salo kaatetith yi yesha gelaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yi mayzitayis, ‹Wodhippatte; shemppo wodhiz oonkka pirddinttoda› ginttintteezana yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Zin ta yinttis odiza; fa ishayir kacinttiz ubbay pirddinttoda. Fa isha curqay giz oonkka daynna tiina pirddas shiiqoda. Fa ishayiko, ‹Tullay› giz oonkka gaanname tama pirddinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Yey gishos, neenii ne yarisha yarshshodar ne isha shifisheez baz neesi qoofinttiko, ");
INSERT INTO mfxl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne yarisha ya aqayid ashshii qitoba; tiinatii yhanigii ne ishayir giigoba; yeezii maaqqii, ne yarisha Xoossis yarshshoba. ");
INSERT INTO mfxl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Nena mootizayira pirdde keeth yhanigttar ogell afa ezar dabbotoba. Yey atto giiko E nena daynna tiina kanggoda. Daynnay nena accizayis aathii immada; E nena woyine oloda. ");
INSERT INTO mfxl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta turo odiza; miishaypp pettii santife attekazin ciggii haasod hellodayis achch keethapp ne kezaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","« ‹Laammippate› ginttintteezana yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Zin ta yinttis odiza, maachchi bi7ii, amotteez ubbay fa wozina gancce izir laammeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne ushachchi aafay nena nagara beeziza maaqqiko, kessii oloba. Ne ashay kunthizin gaanname tama gancce wodhdhodaypp ne asetithayppe pettay dhabiko neess lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne ushachch kushay nena nagara oothisiza maaqqiko, izo gachchii oloba. Ne gallay kunthizin gaanname tama gancce wodhdhodaypp ne asetithayppe pettay dhabiko, neess lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Fa machchato dakkiz oonkka anjjo warqqatte inggo» ginttintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Zin ta yinttis odiza; fa machchato lagitekkazin bili7iz oonkka iza laammod garkk oothiza. Yey garkkekka, anjjintteez asito ekkiza ubbay laammiza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Yi mayzitayko, ‹Worddor caaqqippate; yi Xooss tiina caaqqezana poloytta› ginttintteeza yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Zin ta yinttis odiza; ubbarakka caaqqippate. Xoossay bettiza zufaane maaqqeez gishos salor caaqqippate. ");
INSERT INTO mfxl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","E tokay yedhdhiz aqo maaqqeez gishos sa7arakka caaqqippate. Gita kaat katama maaqqeez gishos Yerusalaamerakka caaqqippate. ");
INSERT INTO mfxl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yi binanaypp pettakka boothi woy karthi udodayis danda7oowa gishos yinttii yi ubbarakka caaqqipppate. ");
INSERT INTO mfxl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yey gishos, yi qaalay, ‹Ee› woy ‹Wa77a› maaqqo. Yeypp atteezay iitapp yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹Aafe gishos aafe; achch gishos achch› ginttintteeza yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Zin ta yinttis odiza; yinttal afa iita baz oothiz athakka ixxippate. Oonkka ne ushachch shanggala baqqiko ne haddiris shanggalakka beezoba. ");
INSERT INTO mfxl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pettii asii ne shaamizhito ekkodayis nena dayinal mootiko, ne kootato gujjii inggoba. ");
INSERT INTO mfxl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oonkka asii nena wolqqar fabaz toossii pettii kilo mitire bagga oge faari yhanigod garkk nena ciphphichiko, ezar nam77ii dakko oge yhanigoba. ");
INSERT INTO mfxl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Woossiza ooskka inggoba; neeppe garxxodayis koyiz oonakka kayppe.» ");
INSERT INTO mfxl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« ‹Nena qadhdhizana qadhdhoba; nena ixxizana ixxoba› ginttintteezana yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Zin ta yinttis odiza; yi morkkita qadhdhoytta; yinttan qohizitayis woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yey garkk yi oothiko, salo yez yi adayis yi na7ita maaqqoda. E iititayisinnee lo77itayis awa kessiza; xillitayisinnee nagaranchchitayis fa ira bukisiza. ");
INSERT INTO mfxl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yinttan qadhdhiza as aadda yi qadhiko, yinttis aba woytto yenee? Hara attozin, qaraxe gachchisizitaykka yinno oothoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yinttii, yi ishitay aadda sarothiko, yhankkitaypp abi hara aadhizibaz ootheenee? Hara attozin, Xooss ammanoowa asaykka yeya oothoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yikkee, salo yez yi aday folo maaqqeeza ygarkk yinttikka folo maaqqoytta.» ");
INSERT INTO mfxl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Gujjikka Yesuusa yhay garkk yeegeeza; Asii bo7o gi yi lo77o oosa as tiina oothaamay garkk naaginttoytta. Yeypp attiko salo yez yi Adaypp woyito denggaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Yinttii manqqitayis inggittar as tiina bonchchinttodayis gi cubbitay oge doonayidannee Ayihuditay Woosa keethitayid oothizay garkk asii bo7o gi tulitula puggisppate. Ta yinttis turo odiza; unttii fa waaga ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Zin yi manqqitayis inggodar yi ushachch kushay oothizana yi haddirss kushay erippe; ");
INSERT INTO mfxl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yikkee imay geema maaqqo. Geema oothizana bi7iza yi aday yinttis woyito pidhdhe immada. ");
INSERT INTO mfxl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Woosa woossittar cubbo asay garkk hanppatte. U, fana asii bo7o gi Ayihuditay Woosa Keeth ganccennee oge doonal eqqii woossizana dosiza. Ta yinttis turo odiza; unttii fa kunth gate ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Zin ne woossittar ne qol7a gelii, gazara gorddii geema yez ne Adayiko woossoba; geema oosintteez baz bi7iza ne aday neesi ne gata immada. ");
INSERT INTO mfxl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yi woossittar Ammanoowa as garkk cere qaala mahii mahii adussis woossippatte. U adussisi woossiko Xoossii si7iza gi qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yey gishos, unttiisay garkk hanppatte. Abis giiko, yi aday yinttis abii koshshizako yi woossodaypp tiinattii eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yikkee, yi yeegii woossoytta: « ‹Salo yez nu adayyo, Ne sunthay anjjintto. ");
INSERT INTO mfxl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne kaatetithay ye7o, ne shenay salo haneezay garkk sa7allakka hano. ");
INSERT INTO mfxl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gallasa katha yhayino nuus inggoba. ");
INSERT INTO mfxl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nuunii nuna qoheezitayis, atto gizay garkk, nuuskka nu qoheez baz atto goba. ");
INSERT INTO mfxl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nuna iitapp ashshobapp attin paace gncce gelisippe. Kaatetithii, wolqqannee bonchcho medhinas neesi. Amin7e.› ");
INSERT INTO mfxl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yi yinttan qoheezitayis atto giiko, salo yez yi Aday yi qoheez bazkka atto goda. ");
INSERT INTO mfxl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Zin yi hara as nagara atto gaam ixxiko yi Aday yi nagara atto gamii.» ");
INSERT INTO mfxl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Yi xoomttar cubbitay garkk shullippatte. Abis giiko, unttii xoomizana asii erod garkk fa sina kayisiza. Ta turo odiza; unttii fa gata ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","«Zin ne xoomittar ne aafa meeccoba, ne omma tizhinttoba. ");
INSERT INTO mfxl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yey garkk ne oothiko ne xoomiza xoomay asapp geemiza, zin geema yez ne Aday eriza xooma maaqqada. Geema oosintteez baz bi7iza ne Aday neess woyito immada. ");
INSERT INTO mfxl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Bilannee woosho dhabisiza aqo, kayzo bookkii ekkiza aqo, yha sa7all, yinttis shalo shiishippate. ");
INSERT INTO mfxl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Zin bilannee, woosho, dhabisoowa, kayzo bookkii ekkowa aqo salo yinttis shalo shiishoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne shalay yeza aqo ne wozinaykka ezayid yezoda. ");
INSERT INTO mfxl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Aafe asetith ubbas xomppe. Yey gishos, ne aafay path maaqqiko ne gallay ubbay poo7o maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne aafay harginttiza maaqqiko ne kunth asetithay dhuma maaqqiza. Yikkee, neell yez poo7ay dhuma maaqqiko, dhumay ab garkk aadho dhumodeshsha! ");
INSERT INTO mfxl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Pettii asii nam77ii goditayis moodinttodayis danda7ooya. Petta qadhdhiko yhankka ixxiza; woy petta bonchchiko yhankka leqqiza. Xoossisinnee miishes moodinttodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Yikkee, si7oytta! Yi shemppayis, ‹Ab maadee? Ab uzhode? Ab ma77ode?› gi qoppippatte; shemppo kathapp, galla ma7opp aadhoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Salo kafita bo7oytta; unttii zerooya, buucoya, shaale olooya, zin yi salo aday unttan muziza. Yeezin yi unttapp lo7ithii aadhoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yi ganccepp un77inttii fa laythal afa pettii gallas gujjodayis danda7izay yenee? ");
INSERT INTO mfxl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Ma yinttii ma77izabazis abis un7inttinee? Wora yez fudhita bo7oytta, u oosor daaburooya woy suqqooya. ");
INSERT INTO mfxl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hara attozin, kaat Solomone fa bonchcho ubbayir yha fudhitaypp pettay garkk ma77ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yinttanno, ammano pacceezitayyo, Xoossay yhayino benttii wontta tama gancce wodhodayis yez maata yeezii ma7isiza maaqqiko, yinttan unttapp aathii wayizii ma7isoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yey gishos, ‹ab maadee? ab uzhode? ab ma77ode?› gi un77inttippete. ");
INSERT INTO mfxl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yhaya ubba Xooss ammanoowa asay gaanthii denggodayis un77inttiza. Yi salo aday ye ubbay yinttis koshshizana eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zin ubbapp tiin Xooss kaatetithinnee e xillotitha kozhoytta; ye ubbay yinttis guzhinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yey gishos, wonttas qoppittar un77inttippate. Wontta paass metintto; pettii pettii gallasayis e iitatithay gidoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Yinttal afa pirddinttaamay garkk hara asal afa pirddippate. ");
INSERT INTO mfxl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Abis giiko, hara asal afa yi pirddizay garkk yinttal afa pirddoda; yi hara asis makkeez bazar yinttis mahii makinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne aafe yez tuussa be7ekkazar ne ishay aafe yez buuxa abis be7ee? ");
INSERT INTO mfxl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne aafe tuussi yezin ne ishay aafe yez buuxa kesso goddayis wayizii danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Neno cubbayyo, tiinatii ne aafayid yezi tuussa kessoba. Ezaypp guye, ne ishay aafayid yez buuxa kessodayis ne milxi udii be7ada. ");
INSERT INTO mfxl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Guye maaqqii yinttan dhaqamay garkk geesh baz kanitayis olippatte. Fa tokayir yedhdhii iissamay garkk yi al7o inqqu gududayllitay tiina olippatte. ");
INSERT INTO mfxl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Woossoytta yinttis ingginttoda, kozhoytta yi demmada, bale yi7ii xeegoytta yinttis dooyinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Woossiza ooskka ingginttoda, koyiz ooskka benttoda, bale yi7ii xeegiz ooskka dooyinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Yinttapp na7a daabbo woossiko shuchchi inggizay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Woy molo woossiko shooshi inggizay yenee? ");
INSERT INTO mfxl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yeezin yi iititay yi na7itayis lo77o baz imo eriko, salo yez yi aday fana woossizittays lo77o baz wayizii gaanthii inggaamo? ");
INSERT INTO mfxl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yhankkitay yinttis oothod garkk yi kozhiz baz ubba yinttikka hara asis oothoytta. Abis giiko, Muse higgaynnee nabittay tamaarssizay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Un7a penger geloytta; dhabo kanggiz ogay damma, pengaykka dalgge. Ezayir geliza asaykka gaame. ");
INSERT INTO mfxl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Zin de7oko kanggiz ogaynnee pengay un7a; ezayir geliza asaykka xiqqa. ");
INSERT INTO mfxl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Afa baggar dure aazii ganccer fuge maaqqii bonqqodayis yi gancce geliza wordo nabitaypp naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yi unttan, u aafayir eroda; angguthapp woynnee, gijjepp balase maxinttoya. ");
INSERT INTO mfxl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yey garkk lo77o mithii ubbay lo77o aafe aafiza; iita mithii iita aafe aafiza. ");
INSERT INTO mfxl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo77o mithii iita aafe aafooya, ma iita mithii lo77o aafe aafodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo77o aafe aafowa mithii ubbitay gachchinttii tama gancce olinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yey gishos, yi unttan, u aafatir eroda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Salo yez ta aday azazo oothiza athay salo kaatetithii gelodaypp attin cer tana ‹Godayyo, Godayyo› giz ubbay salo kaatetith gelooya. ");
INSERT INTO mfxl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ye wode gaamitay, ‹Godayyo, Godayyo, ne sunthar tinbbite nu odekkasa? Ne sunthar tuna ayyantta nu kessekasa? Ne sunthar gaame malata nu oothekkasa?› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ye wode, ‹Ta yinttan yesha erooya, yinttii wucitay taapp haakkoytta› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yikee, yha ta qaala si7ii oothiza oonkka fa keetha zaallal afa keexxeez wozinaama as garkke. ");
INSERT INTO mfxl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ira bukkeeza, di7o di77eeza, carkkokka carkkii ye keethana urqqeeza. Zin keethay zaallal afa keexxintteez gishos woddekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yha ta qaala si7ii oothowa oonkka fa keetha shafel afa keexxeez boozo athay garkke. ");
INSERT INTO mfxl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ira bukkii, di7o di77ii, carkkokka carkkii, ye keetha urqqin, ye keethay woddeeza; E woddithaykka woliqqama» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuusa fa oda wurisseezaypp e timirttay higge asitamaarttay garkk maaqqekka mawuter yez asayisay garkk maaqqiz gishos asay e timirtta yhay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuusa derellapp wodhdheez wode gaame woya eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yeezako pettii borqqonttor hargginttizay eziko shiiqii, e tiinayid xuggunii, «Godayyo, ne shene maaqqiko tana geeshshii pathodayis ne danda7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuusa fa kushayid dakkii eza bochchii, «Ee, ta shene, geezhoba» yeegeeza. Athay borqqonttaypp izir geezhii atteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuusa eziko, «Ne paxa oossikka odippe. Zin yhanigii ne geezhi paxeezana qeese beezoba. Ne paxeezayis markka maaqqoday garkk yhanigii Muse kiitteez yarshsha yarshshoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuusa qifirnahoome giz katama helleez wode pettii mato halaqay eziko shiiqii, ");
INSERT INTO mfxl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Godayyo, ta ayllay gallay silin iita hargginttii, kara woy7ii yeza» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuusa mahii eziko, «Taanii yhanigii eza pathoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Zin mato halaqay mahii, «Godayyo, ne ta kara gelodayisi ta beeziza as baaya, zin ne yhannee bettii qaala aadda odoba, ta ayllay paxoda. ");
INSERT INTO mfxl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Taapp afar tana kiitiza asay yeza, ma taapp oommora taasi kiitinttizittay yeza. Unttapp petta, ‹Qitoba› giiko qitiza; ma yhankka ‹yhana ye7oba!› giiko yi7iza. Ta aylla, ‹Yhanno oothoba› giiko oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuusa yeya si7ii malabaz gi, fana kaalliza asayiko, «Ta yinttis turo odiza; taanii yhay garkk xaala ammano Isreele asay ganccekka be7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta yinttis odiza; gaamitay awa kessinnee awa gelo baggapp yi7ii, salo kaatetitha Afraamer, Isaaqarannee Yayqqoobara wolla imatol bettoda. ");
INSERT INTO mfxl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Zin salo kaatetith laattodayis beezodar atteezitay bale dhuma olinttoda. Ezayid unttisi yeefonnee achch coonch maaqqada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuusa mato halaqayiko, «Ne kara qitoba, ne ammanatii garkk neesi hano» yeegeeza. E ayllay ya saatate paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuusa Phixiroosa kara gelodar Phixiroosa machchat indat oxe misha harger hargginttii woy7ii yezanno be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesuusa i kushayid bochcheezan garkk oxaynnee mishay eqqeeza. Paxxii denddii eza mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ye wode omathi tuna ayyanar aykintteez gaame asita, asay Yesuusako ke7eeza. Ezkka tuna ayyantta fa qaalar kesseeza, harggintteezitta ubbita patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yeyidakka nabe Isayaasa, «E nu daaburssa faasi ekkeeza, e nu hargga tookkeeza» geez qaalay polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuusa gaame asay e kale eqqeezita bi7ii, abbapp seko pino piinggod garkk fa taamarita azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Higge asitamaaritaypp pettay, «Asitamaarayyo, ne yhanigiza aqo ubba ta kaalloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuusa eziko «Shannitayis olla yeza, salo kafitayis keethii yeza. Zin As Na7ayis fa omma shemppisiza aqo baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesuusa kaalliza asitaypp pettay, «Godayyo, taanii tiinattii yhanigii ta ada moogii ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zin Yesuusa, «Yhayqqeezitay fa yhayqqita moogo; neenii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuusa yhammadayis wogolo gancce gelodar e tamaaritaykka ezar yhammadayis kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Unttii qoppekka yezin, wolqqama gotte abbayil afa denddin wogolay mitinttodays helleeza. Zin Yesuusa gentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","E tamaaritay eziko shiiqii eza barkkithii, «Godayyo, nu dhabooho nuna ashshooyee» yeegii dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuusa unttiko, «Yinttanno, ammano pacceezitayyo, abis yashitte?» yeegeeza. Denddii, carkkannee gota seerin ellisii ubba baz cicirkk geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","E tamaarttay malabaz gi, «yhayi, hara attozin, gotenne abba kiitinttizay waafa aso?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuusa abbapp seko pino yez Gerggesoone giz biitta hellodar tuna ayyana aykkeez nam77ii asitay duufopp kezii eza helleeza. U iita yashshiz asita maaqqeez gishos asii ye aqayir aadhodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Unttikka, «Xooss Na7ayyo, nuurannee neera abi woli helithee? Nu qammay hellekkazin nuna pirddodays ne ye7eenee?» gi uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Unttapp gaame haakkekazar gudaylle wude heengginttizitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tuna ayyanitay Yesuusa, «Ne nuna kessiza baz maaqqiko, seko gudaylle wuday gancce dakkooye» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuusa, «yhanigoytta» yeegeeza. Tuna ayyanitay kezii gudayllitayll geleeza. Gudayllitay ubbay gaga doonar dirggii yhanigii abba gancce mitinttii yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gudaylle wude heenggizitay qosinttii katama yhanigii, haneezbazinnee tuna ayyanay aykkeez asayil afa oosintteez baz ubbita odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yeezin, katama gancce yez as ubbitay Yesuusa be7adayis kezeeza. Unttii Yesuusa be7eez wode fa biittapp kezii qitod garkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yeypp guye, Yesuusa wogolo gancce gelii, abba piinggii fa katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Asay pettii sila atha arssar tookkii Yesuusako ke7eeza. Yesuusa u ammana bi7ii, sila atha, «Ta na7ayyo, yashittippe! Ne nagaray atto ginttintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ye saatayid, Ayihuditay higge asitamaaritaypp pettay pettay, «Yhayi Xooss cazhiza» yeegii u fa wozinar qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuusa u qofa erii, «Iita baz yi wozinar abis qoppee? yeegeeza ");
INSERT INTO mfxl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Zin, ‹Ne nagaray atto ginttintteeza› gizayppenne ‹Denddii qitoba› gizaypp aay aadhee? ");
INSERT INTO mfxl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Zin biittal afa nagara atto godays as na7ayis mawute yezana ta yinttan erisoda» yeegii, sila athayiko, «Denddii ne arssa tookkii, ne kara yhanigoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sila athay denddii fa kara qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Woyay yeya bi7ii malabaz geeza. Yey garkk mawute asis inggeez Xoossa galatteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuusa yeypp denddii yhanigttar Maatoosa giz athay qaraxe gachchisiz aqo betteezin bi7ii, «Tana kaalloba» yeegeeza. Ezikka denddii kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuusa Maatoosa kara munttall afa betteezin, qaraxe gachchiz gaame asitaynnee nagara oothiz asay yi7ii ezarannee e tamaaritayir wolla maadayis betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pettii pettii Ferisaawe asay yeya bi7ii, Yesuusa taamarita, «Yi asitamaaray qaraxe gachishizttayirannee nagara oothizitayir abis mee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuusa yeya si7ii, «Akime koshshizay hariggintteezitayispp attin pathitayis baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Zin yi yhanigii, ‹Taanii yi yarshsha baazin maarotith koyiza› guussay waaguusizako eroytta. Abis giiko, ta nagara oothizita xeegodayis ye7eezapp attin xillita xeegodayis ye7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ye wode Waannisa tamaarittay Yesuusako shiiqii, «Nuurannee Farasaawe asay xoomiza, zin ne tamaaritay abis xoomoosa?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuusa mahii unttiko, «Machcho ekkizay unttar yezin laazanthitay azannodayis danda7inee? Machcho ekkizay u achchapp ekinttod wode ye7oda, u ye wode xoomoda. ");
INSERT INTO mfxl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Orothi ma7opp peedhii cima ma7ol afa sikkiza oonkka baaya. Yey garkk oothiko orothay cimana peri7iza. Peri7ithaykka gujjii dalggiza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Orothi woyne cima ogoro gancce dakkii gaddiza oonkka baaya. Yey garkk oothiko orothi woynay cima ogora dhuusiza woynaykka lallinttiza; ogoraykka nam7intho adoowa baz maaqqiza. Zin orothi woyine orothi ogoro gancce olinttodayis beeziza. Yey garkk oosinttiko nam7itaykka iitekkazar naaginttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuusa yeya odol afa yezin, Ayihude halaqqitaypp pettay eziko yi7ii, e tiinayid xuggunii, «Ta na7ata yhatti yhayqqeeza, zin iza paxodgarkk ne yi7ii ne kushayid Izil afa gaddooye» gi woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuusa denddii ezar yhanigeeza; e tamaaritaykka kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","E yhammadar taphpho nam7i laythi kunthi suuthii goggi waayithiza pettii asita guyer shiiqii Yesuusa afila macara bochcheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Iza fa wozinar, «Ta e afila macartto aadda bochchizako paxoda» yeegii qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuusa guye maaqqii izo bi7ii, «Ta na7ate, yashitippe! Nena ne ammanay patheeza» yeegeeza. Ye asita izir paxxii atteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuusa Ayihude halaqay kara hellodar dinkke puggizttannee yeekkizitta bi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ani hali7oytta; xiqqa na7ata gentteezapp attin yhayqqekkaya» yeegeeza. Zin asay ezal afa miiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Asa bale kesseezaypp guye kara gelii, na7atti kushayid aykkin, na7ata denddii eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ye waaray ye biitta ubba helleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuusa ezayir gede tiina yhanigodar nam7i to7itay fa qaala dhoqi udii, «Dawute na7ayyo, nuna maarooye» gi ukkittar eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesuusa kara gelodar to7itay eza kaali ye7eeza. Yesuusa unttiko, «Taanii yeya oothodayis danda7izana yi ammaninee?» yeegeeza. Unttikka, «Ee, Godayyo» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yeypp guye, Yesuusa u aafana bochchii unttiko, «Yinttis, yi ammanay garkk hano» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","U aafaykka dooyintteeza. Yesuusa unttiko, «Yhaya ooskka odippate» yeegii miinthii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Zin asitay yhanigii Yesuusa oosa ye biitta ubbayil odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Unttii yeypp kezodar asay tuna ayyanay aykkeez pettii muume as Yesuusako ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tuna ayyanay kezeezaypp guye muume athay odintteeza, woyitaykka malabaz gi, «Yhay garkk orothibaz Isreele biittal yesha hanekka bazi» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Zin Ferisaawitay, «Tuna ayyanitay halaqayir tuna ayyanita kessiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuusa Ayihuditay Woosa keetha taamaristtar, salo kaatetith Wonggile sabbakittar, asa hargge ubbaypp pathitar katamitayirannee heera ubbayir yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gaame woya, heenggiz as baa dur garkk unttan bi7iza as dhabin un77intteezitannee laalinttii yezita bi7ii unttis qadhintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Fa tamaaritayiko, «Shiiqod torchche kathay gaame, zin torchche katha shiishiza asay xiqqa. ");
INSERT INTO mfxl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yey gishos, Goday torchche katha shiishodayis ooso asita dakkod garkk torchche goda woossoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuusa taphpho nam77ii taamarita faako xeegii, tuna ayyanita kessod garkkennee hargge ubba pathoday garkk unttisi mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Taphpho nam77ii hawaaritay suntha: unttikka Phixiroosa giz Simoonarannee e isha Indiraase, Zabddosa na7a Yayqqoobara e isha Waannisa, ");
INSERT INTO mfxl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filphoosa Barttolomoosa, Toomaasa qaraxe gachchisiz Maatoosa, Ilfoosa na7a Yayqqooba, Taadoosa, ");
INSERT INTO mfxl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Qenena Simoonarannee Yesuusa aathii inggeez Asiqoroto Yihuda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ye taphpho nam7ita Yesuusa kiittii dakkittar, «Ayihude baazitayiko yhanigipatte, ma Samaaritay katama gelippate. ");
INSERT INTO mfxl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Zin Isreele karapp maaqqeez sekk dhabeez duritayiko yhanigoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yhanigii, ‹Salo kaatetithay ukkeeza› gi odoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hargintteezita pathoytta, yhayqqeezita yhayiqoppe denthoytta, boriqontto hargger yezita geeshshii pathoytta, tuna ayyanita kessoytta. Yi cer ekkeezana cer inggoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yi kiise worqqe, woy bira santte aykkippate. ");
INSERT INTO mfxl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yi oges qurbo, nam77ii afila, woy caamma woy gufe aykkippate; ooso oothizitayis katha koshshiza. ");
INSERT INTO mfxl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Yi katama woy heera gelodar yinttan mokki ekkodayis ufayttiza atha kozhii e kara shemppoytta; yi kezii yhammad gallasa hellodayis ezayid gam7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma o karakka gelittar sarothoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ye keethay yinttan mokkiko yi sarotheez saray unttan hello, zin u mokaam ixxiko yi sarotheez saray yinttis guye maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oonkka yinttan mokkowa baz maaqqikonnee yi odeezibaz si7aam ixxiko ye karttipp woy ye katamttipp kezttar yi tokel yez buli7a pittii kezoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta yinttis turo odiza; Xooss pirdda gallas ye katamatippe Soodomesirannee Gamoora katamitayis pirdday kawuzhoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ta yinttan duritay garkk fugitay gancce dakkoda. Yey gishos, shoosh garkk ecita, holle garkk haayita maaqqoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Asay yinttan pirdda daynnitayis aathii immada, ma Ayihuditay Woosa Keethayid yinttan alangoda. Yey gishos, unttapp naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta gishos gi yinttan gade aqisizitay tiinannee kaatitay tiina kanggoda. U tiinayidannee Ayihude baa woya tiina eqqii yi tabaz markkattoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Zin yinttan pirddas aathii inggodar waago ab maho gi un77inttippate; ye saate yi godbaz Xoossii yinttis immada. ");
INSERT INTO mfxl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Abis giiko, yinttar maaqqii odizay yi Aday geeshsha Ayyanapp attin yinttan baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ishay fa isha, aday fa na7a, yhayiqos aathii immada, na7itay fana yeleezitayil afa denddii wodhoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta sunthay gishos gi asii ubbay yinttan ixxoda, zin wurssith hellodayis garzheezay attoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pettii katamapp yinttan u bayi7iko hara katama qosinttoytta. Taanii yinttis turo odiza; As Na7ay ye7od hellodayis, yi Isreele katama ubba polaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Tamaaray fa asitamaaraypp, ayllay fa godaypp aadhooya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamaaray fa asitaamara, ayllay fa goda aaziko ezis gidoda. Kara ada Bi7elzebula giiko e kara asa wayizii iissii xeegodee? ");
INSERT INTO mfxl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yikkee, asis yashittippate, kamintteez baz qonccoda, qosintteez baz pidhdhe kezekkazar attaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta yinttis dhuma odizana yi poo7o odoytta; ta yinttis haye kale kalkkasheez baz derell afa woyas awajjoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ashop attin shemppo wodhodayis danda7oozittayis yashittippatte. Zin shempponnee asho gaanname dhabisodays danda7iza Xoossayis aathii yashittooytta. ");
INSERT INTO mfxl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nam77ii suunnitay pettii bakkanna bayizinttoosannee? Zin, unttapp pettakka yi Aday geekkazin sa7a wodhdhii attooya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hara attozin, yi omma binanaykka payidinttii yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yikkee, gaame suunnitaypp yi aadhiz gishos yashittippate. ");
INSERT INTO mfxl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«As tiina taas markkattiz ubbayis taankka salo yez ta aday tiina markkattoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Zin as tiina tana kaddizana taankka salo yez ta aday tiina eza kaddoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ta sa7all saro ko7odayis ye7eeza yinttis aazppe. Ta Olapp attin sarotithi ko7odayis ye7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta ye7eezay, «‹Na7a adaypp na7ato indattipp; na7ay machchato azinay indattipp shaakkodayisii. ");
INSERT INTO mfxl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Asis morkkee e kara asita maaqqada.› ");
INSERT INTO mfxl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Taapp aathii fa ada woy fa indato dosizay, taas maaqqodayis beezooya. Fa dhiirath na7a woy fa maachchch na7ato taapp aathii dosizay, tabaz maaqqodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Fa mazqale tookkii tana kaallowa oonkka tabaz maaqqodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Fa shemppo ashshodayis koyizay dhabisoda, zin fa shemppo ta gishos aathii inggizay ashshoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Yinttan mokkizay tana mokkiza, tana mokkizay ma tana kiitteez ta ada mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nabana nabe sunthar mokkizay, nabay garkk woyttinttoda; ma xillana geesh sunthar mokkizay, xillitay garkk woyttinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta yinttis turo odiza; yha ta tamaaritaypp xiqqiza pettayis tana kaalliza gishos hara attozin hale haath irxxa inggiko e woyitay dhabenna» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuusa taphpho nam77ii tamaaritayis azaza inggeezaypp guye ezaypp denddii tamaarssodayissinnee sabbakodayis Galila katamitayiko qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Waannisa achch kara yezar Kiristtoosa ootheez bazita si7ii, fa tamaaritaypp nam7ita eziko kiittii, ");
INSERT INTO mfxl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Ye7oda giinttintteezay nenanee? nu hara naago?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuusa unttiko mahii, «yhanigii yi si7izibazinnee yi be7eez baz Waannisas odoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","To7itay be7ada, shoollizitay yedhdhoda, boriqonttor hargintteez asitay geezhoda, tullitay si7oda, yhayqqeezittay yhayiqoppi dendoda; manqqitayis Wongilay sabbakinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Taal dhubinttekazay anjjintteezaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waannisa tamaaritay guye maaqqii qittin, Yesuusa woyayis Waannisa baz odittar, «Yha liizho gadhayid ab be7adayis kezeene? Carkko eni7isiza maqa be7adayis ye7eenennee? ");
INSERT INTO mfxl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yeezin, ab be7adayis kezeenee? Lo77o afila ma77eez as be7adayisonee? Lo77o afila ma77ezitay kaatitay keetha yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yeezin, ab be7adayis kezeenee? Nabe be7adayisonee? Yeezako, yi nabeppekka aadhizana bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","«Ne oga ne tiinayir giigisiza kiitintteezana neepp tiina kiittoda» yeeginttii xaafintteezay eesii. ");
INSERT INTO mfxl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta yinttis turo odiza; maachchapp yelintteezitay ganccepp Xammaqiza Waannisapp aadhizay oonkka baaya; salo kaatetititha ubbaypp xiqqizay, ezipp aadhoda, ");
INSERT INTO mfxl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","xammaqiza Waannisa wodepp aykkii yhayino hellodayis salo kaatetithay gaame urqqinttiza, miinggii butintteezitay ye aqa geloda. ");
INSERT INTO mfxl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nabitay ubbitayinnee Muse higgay Waannisa wode hellodayis hanod baz tinbbite odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yikkee, yi u kiita ammanod maaqqiko, ye7od ginttintteez Eelaasa, yeyi E Waannisa. ");
INSERT INTO mfxl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yikkee, si7iz hayer yezay si7o. ");
INSERT INTO mfxl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Yikkee, yha wode yeletitha abara aaziso? Gabe gancce bettii woli xeegii, ");
INSERT INTO mfxl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« ‹Nu yinttis impilitte puggin; yi yexxooya. Nu sabbii zelalin; yi yeekooya› yeegiz na7ita aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xammaqiza Waannisa meekazarannee uzhekkazar yi7in, ‹Tuna ayyanar yeza› yi yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","As Na7ay miittarannee uzhittar yi7in, ‹Zhimbarannee ushshii zhaare, qaraxe gachchisizitayinnee nagaranchchitay dabbo› yeegeeza. Yikkee, ecetithi tumatithay e oosayir benttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yeypp guye, Yesuusa gaame malatita ootheez katamitayid yez asay fa nagarapp maaqqii maaroteth gelaam ixxeez gishos unttan, ");
INSERT INTO mfxl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ayye Koraazinee katamas, ayye Beetesayda katamas, abis giiko, yi gancce oothintteez malatay Xiroosannee Sidoona oothintteez maaqqeezako, u binii budo tizhinttii, kayo afila ma77ii fa nagaraypp maaqqii attoda. ");
INSERT INTO mfxl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Zin ta yinttis odiza; pirdda gallas yinttapp aathii Xiroosasinnee Sidoonas pirdday kawuzhoda. ");
INSERT INTO mfxl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma yhannee qifirnahooma, ne pude salo kezodayis koyinee? Hanaamii! Neenii Si7oole wodhdhoda. Abis giiko, ne gancce oothintteez malatitay Soodoma oosintteezako Soodome yhayino hellodayis yessadazin. ");
INSERT INTO mfxl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Zin ta neesi odiza; pirdda gallas neeppi aathii Soodomas pirdday kawuzhoda» yeegii kacceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ye wode Yesuusa, «adayyo, salonnee sa7a Godayyo, neenii yhaya eranchchitayippennee ecitaypp qosii duude na7itayis qoncciseez gishos nena ta galatiza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, ta adayyo, yhayi ne lo77o shenay garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Ubbay taasi ta Adaypp ingintteeza. Adaypp hara Na7a erizay baaya, Na7ayppennee E unttisi qonccisodayis koyizttaypp hara Ada erodayis danda7izay baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Yinttano, daabureezitayyo, toofo deexeez ubbitayyo taako yhana ye7oytta; ta yinttan shemppisoda. ");
INSERT INTO mfxl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Taanii ta wozinar keehannee haayo maaqqeez gishos ta qambarayid geloytta, taapp tamaaroytta; yinttii, yi shemppos shemppo demmada. ");
INSERT INTO mfxl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta qambbaray liiqama, ma ta toofaykka shawuko» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yeypp guye, maala gallas, Yesuusa gade ganccer aadhiza. Yesuusa tamaaritay nayintteez gishos bangga tizha mirkkii muuss aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Zin Ferisaawitay yeya bi7ii Yesuusako, «Yha bo7oba, ne tamaaritay maala gallas oothodayis beezoowa baz oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuusa unttiko mahii, «Dawitte nayintteez wode Ezar yezitayira ab ootheezakko yi nabbabekasa? ");
INSERT INTO mfxl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawitte Xooss keetha gelii qeesitay aaddapp attin ezinnee ezar yezitayis beezoowa yarshshintteez daabbo meeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Woy kahinitay maala woga shaarii Xoossa Keetha maala gallas ooso oothiko unttis nagara maaqqoozana Muse higgaypp yi nabbabekasa? ");
INSERT INTO mfxl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Zin si7oytta! Xooss Keethapp aadhizay yhaydda yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹Taanii yi yarshsha baazin yi hara as maarod garkk koyiza› giz qaalay waaguusizako yi ereezako geeshsh asal afa pirdaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","As Na7ay maalas Goda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuusa yeypp yhanigii Ayihuditay Woosa keethi geleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ezayid kushe sileez pettii athay yeza. Yesuusana mootodayis sankke koyiz asay, «maala gallas as pathodayis beezinennee beezoosa?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","E unttiko, «Yi ganccepp pettayis durii maala gallas olla wodhdhiko, goochchii kessoozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yeezin asii durapp wayizii lo7ithi aadhoosa? Yeyi gishos, maala gallas lo77o baz oothodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yeypp guye, Yesuusa athayiko, «Ne kushayid piddi udoba» yeegin, athaykka piddi udeeza. E kushay paxxii yhankko kushay garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Zin Ferisaawitay yeypp bale kezii, Yesuusa wayizii wodhodazako wolla tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuusa u qofa erii ye aqa ashshii hara aqo qiteeza. Gaame asii eza kaallii yhanigeeza, harggintteezita ubba e patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesuusa, «Ta bagga oossikka odippatte» yeegii miinthii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yeykka nabe Isayaasa, ");
INSERT INTO mfxl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Yikkee ta maraxeez ayllay, ta dosizay, tana ufayssizay, taanii ta ayyana, ezal afa shemppisoda; E, Ayihude baa woyas luule pirddebaz awajjoda. ");
INSERT INTO mfxl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E palamooya woy kaccooya; fa qaalakka denbal cer sissooya. ");
INSERT INTO mfxl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Luule pirddar gamod hellodayis, loomeez maqa menthooya, cuyiz muqaadda to7isooya. ");
INSERT INTO mfxl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayihude baa woya ubbitay eel ufayttoda» yeegii odintteezay polinttoday garkke. ");
INSERT INTO mfxl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yeypp guye, tuna ayyana aykkeez to7annee muume as yezana eziko ke7eeza. Yesuusa atha pathin, athay be7eezannee odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Woya ubbay malabaz gi, «Yhayi Dawutte Na7a maaqqadeshshaa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Zin Ferisaawitay yeya si7ii, «Yha athay tuna ayyanita kessizay tuna ayyanitay halaqa Bi7elzebula wolqqara» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuusa u qofa erii, «pettii kaatetithii shaakinttii wolalli eqinttiza maaqqiko ye kaatetithay wodhdhoda; ma woli gancce shaakotith medhdhiz katama woy keethi miinggii eqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xalahe xalehe kessiza baz maaqqiko fa gancce shagintteez guussii. Yey garkke haniza baz maaqqiko e kaatetithay wayizii miinggii eqqodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taanii tuna ayyana kessizay Bi7elzebula wolqqar maaqqiko yinttan kaalliza asay o wolqqar kessodee? Yey gishos, yinttan kaalliza asay yinttan pirddoda. ");
INSERT INTO mfxl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Zin taanii tuna ayyanita kessizay Xooss Ayyanar maaqqiko, Xooss kaatetithay yinttiko ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Woy pettii as wolqqama as kara gelii e shalana bonqqodayis koyko tiinattii ye atha accekka attiko wayizii bonqqodayis danda7ee? Acceezayipp guye e shalana bonqqodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Taar baazay oonkka tana ixxiza; ma taar wolla shiishoowa ubbay laaliza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yey gishos, si7oytta; asay oothiza aba nagarakka cashshii ubbay atto ginttinttoda, zin geeshsha Ayaana cazheez oossikka e nagaray atto giinttinttaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Oonkka As Na7al afa iitta baz odinttiko eesi atto ginttinttoda, zin geeshsha Ayyanal afa iitta baz odinttiza oossikka yha sa7all maaqqin ye7od alamayilakka e nagaray atto giinttinttaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Lo77o mithii lo77o aafe aafiza; ma iita mithii iita aafiza. Yikkee, mithii erinttizay fa aafayira. ");
INSERT INTO mfxl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yinttanno, shoosh na7untho, yi iita maaqqittar wayizii lo77o baz odinttodayis danda7inee? Asii fa wozina gancce kumii puceez bazapp doonar odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lo77o asii fa wozina gancce gaddeez lo77o bazapp, lo77o baz kessiza; iita asii fa wozina gancce gaddeez iita bazapp, iitta baz kessiza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Zin si7oytta, asii odinttiza cere oda ubbayiskka pirdda gallas malsse immada. ");
INSERT INTO mfxl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Abis giiko, ne odinttiza neqaalayir xilloda; ne odinttiza ne qaalay neell afa pirddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yeypp guye, pettii pettii farasaawitayinnee higge asitamaaritay Yesuusako, «Asitamaarayyo, neenii malata oothii nuna beezooyee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Zin Yesuusa mahii, «Ammanozitaynnee iita yeletithitay malata koyiza. Zin nabe Yoonasa malatapp hara malata eesi ingginttooya. ");
INSERT INTO mfxl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonasa gita molo ulo gancce hayidzii gallasinnee hayidzii qamma gam7eezay garkk As Na7ay hayidzii gallasinnee hayidzii qamma biitta gancce gam7oda. ");
INSERT INTO mfxl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nenewe asay pirdde gallas denddii yha yeletithayil afa pirddoda; abis giiko, u Yoonasa sibikkata si7ii fa nagaraypp maaqqeeza. Yikkee, Yoonasapp aadhizay yhaydda yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pirdda gallas sulle bagga kaatata denddii yha yeletithayir wolla pirddoda; abis giiko, iza Solomone eccetitha si7odayis biitta gaxapp ye7eeza. Yeezako, Solomonepp aadhizay yhaydda yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Tuna ayyanay asapp kezeezaypp guye faasi shemppiza aqo koyii haathii baa mela aqo daaburiza, zin fa koyiz shemppo denggenna. ");
INSERT INTO mfxl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yeyi gishos, ‹Ta ashshii kezeez kara maaqqii yhammada› yeegiza. E maaqqii ye7odar keethay kayisa maaqqizannee pitinttii giigii betteezana denggiza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yikkee, maaqqii yhanigii, paapp iita hara laappun iita ayyanita ekkii yi7iza; unttikka athay gancce gelii yeziza. Ye athayis tiinaasaypp guyeesay usa iitiza. Yha iita yeletithayil yey garkk baz hanoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuusa woyayis odal afa yezin e indatinee e ishitay eer nashodayis koyii bale eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pettii asii eziko, «Ne indatinee ne ishitay neer nashodayis koyii bale eqqeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesuusa mahii, «Ta indat oonoo? Ta ishitaykka oonanttara?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Fa kushayir taamarita mallitar, «Bo7oytta, ta indatanne ta ishitay yhayitita. ");
INSERT INTO mfxl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Salo yez ta Aday shene oothiza ubbitay ta ishe, ta mishshonnee ta indo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ye gallas Yesuusa karapp kezii abba kantta betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gaame woya e lanqqe shiiqin asa abba gaxa ashshii wogolo gancce gelii betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asayis gaame baz aazisor yeegii odeeza: «Pettii biitta oothiz athay zerithi zerodayis kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E zerodar pettii pettii zerithay oge gaxa wodhdheeza; unttanakka kafitay yi7ii maxxii meeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pettii pettii zerthitay oommo sisilqqo yez biittal afa wodhdheeza. Gaame biitta baa gishos ellis doleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Zin awa kezin shulleeza; xapho baazay gishos meleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pettii pettii zerithay angguthi gancce wodhdheeza; angguthay diccii ye dola cuulleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yhankkitay ma irkko biittal afa wodhdheeza; dolii aafe aafeeza. Pettay xeeti, pettay usuppuntam, pettay ma hasttam aafeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Si7iz hayer yez athay si7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuusa tamaaritay eziko shiiqii, «Abis neenii woyayis aazisor odee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E mahii, «Yinttis salo kaattetithi xuura ingintteeza, zin unttisi ingginttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yeza ubbayis guzhinttoda, ezisi gaanggoda, zin baazaypp hara attozin ezis yezanakka ekinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yey gishos, taanii unttii, bi7ittar dengaamay garkk, si7ittar si7aam garkk woy akaakam garkk unttisi aazisor odiza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","«Isayaasa fa maxaafay giddo odeezay unttal afa polintteeza. E odittar, « ‹Yi sis si7iza, zin akaakooya; yi bi7ith bi7iza, zin dengooya. ");
INSERT INTO mfxl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Abis giiko, yha asay wozinay oriddeeza; fa haya erittar tulliseeza, fa aafa goozeeza. Yey baazako u fa aafatir bi7ii, fa hayer si7ii, fa wozinar akaakii, taako maaqqoda, taakka unttan pathodazin› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Zin yi aafay bi7iza gisho yi hayay si7iz gishos yi anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta yinttis turo odiza; gaame nabitayinnee geeshsh asitay yi be7eezana be7adayisinne yi si7izana si7odayis amotteeza, zin unttis hanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Yikkee, yha zerithi zeriz athay aazisa si7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oge gaxa wodhdheez zerithi aazisay yhaya: salo kaattetith qaala si7ii akaakowa athay wozinaypp Xalahe yi7ii e wozina gancce yez zertha maxii haaseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sissilqqo biittal afa zerntteezay beezizay qaala si7ii ellis ufayssar ekkizita. ");
INSERT INTO mfxl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Zin yhattesapp attin xapho dakkekkaya. Qaala gisho meto woy bayi7ithii yi7iza wode ellis dhubinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Angguthi gancce zerintteezay yhaya qaala si7eeza, zin yha alame yessis hirggaynnee duretithis qofay qaala cuulliza gishos aafe aafekkazar attiza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Zin aradda biittal zerinteez zerithay yhaya akaakar qaala si7eez atha. E aafe aafiza; pettay xeeti, pettay usuppuntam pettay ma hasttam inggiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuusa unttis hara aaziso odeeza, «Xooss kaatetithay fa woota gancce lo77o zerithi zereez atha aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Zin as ubbay genttin e morkkay yi7ii gistte gancce leeshsho zerii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gisttay diccii ka77iz wode leeshshokka e gancce bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Gade goday ayllitay godayko yhanigii, ‹Godayyo, ne wootayid ne lo77o zerithi zerekkasa? Yeezin, leeshsho anapp ye7eenee?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«E unttiko, ‹Yeya morkke ootheeza› yeegeeza. «Ayllitay godayiko, ‹Nu yhanigii leeshsha shoddod garkk ne koyinee?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Zin E, ‹Atto bochchippate; yi leeshsha shoddiz godar gisttekka shodinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bochchippate; maxo wode hellodayis wolla dicco. Ye wode maxiza asitay leeshsha tiinattii maxii tama gancce xuugodayis mirqqer mirqqer mirqqoytta. Zin gistta shiishii ta shaalayid oloytta› yeegoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma hara aaziso yeegii odeeza; «Salo kaatetithay pettii asii fa woota gancce bakkeez sanaficce aafe aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ye mithat aafay hara mithii aafitaypp xiqqa, zin dolii diccii hara mith ubbaypp aadhii dammii dicciza. I shaqitayil afa kafitay keexxii bettod hellodayis damma mith maaqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Maaqqikka, Yesuusa hara aaziso odeeza; «Salo kaatetithay pettii maachchi hayidzii gongge dhiilla ekkii munuqii, munuqay dendoday garkk ezayid dakkeez irshsho aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuusa woyayis ye aaziso ubba odeeza. Aaziso baazin pettibazikka odekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nabay fa maxaafay gancce, «Taanii ta doona, aazisor dooyoda; salonnee sa7a medhintteezayppe, geemmezana ta odiza» yeegii odeezay yeyid polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuusa woyita ashshii kara geleeza. E tamaaritay eziko shiiqii, «wootayid yez leeshshay bilitha nuus odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E mahii, «Lo77o zerithi zereezay As Na7a, ");
INSERT INTO mfxl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wootay yha alama. Lo77o zerithay salo kaatetithii na7ita. Leeshshay xalahe na7ita. ");
INSERT INTO mfxl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Leeshsho zereezay morkke xalahe, maxo woday wode wurssitha, maxizitay kiitanchchita. ");
INSERT INTO mfxl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Leeshshay maxinttii tama gancce xuuginttizay garkk wode wurssithala yhaygarkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","As Na7ay fa kiitanchchita kiittoda. U nagaras sankke maaqqeezittannee iita oothizi ubbita maxii e kaatetithaypp kessoda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Maxii shiishii yeefonnee achch coonchii yez to7oowa tama gancce oloda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ye wode xillitay fa Aday kaatetithayid awa garkk poo7oda. Si7iz haye yezay si7o! ");
INSERT INTO mfxl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Xooss kaatetithay woota gancce moogintteez miishe aaziza. Pettii asii ye miisha denggii mahii moogeeza. Gaame ufayttii yhanigii paas yeza baz ubba bayizii ye gadat wonggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Yey garkk, ma salo kaatetithay inqqo giz al7o shuchchita koyiz zal7e as aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gaame al7o inqqo denggii yhanigii paas yeza baz ubba bayizii e wonggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ma Xooss kaatetithay abba gancce olintteez duma duma molo kochch aykkizi gite aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Molo aykkiz asay molo gitayid kumin abbappi gaxa kesseeza. Ezayid bettii lo77a lo77a qurii daachcho gancce oleeza, zin iita molita alla oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wode wurssithal yey garkk hanoda. Kiitanchchitay yi7ii nagara oothizita xillitaypp quroda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yeefonnee achch coonchii yeza to7oowa tama gancce oloda. ");
INSERT INTO mfxl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Yha ubbitay yinttis geleenee?» yeegii unttan oyceeza. U mahii, «Ee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesuusa, «Yikkee, salo kaatetithii xuura ekkii higge taamarssiza ubbitay, fa minjjeez shalaypp orothinnee cima kessiza shalo goda aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuusa yha aazisa odii wursseezaypp guye ezaypp denddii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Fa yelintteez biitta yhanigii Ayihuditay Woosa Kara taamarsso ayikkeeza. U mala bazi gi, «Yha athay yha ecetithannee yha malata oothiza wolqqa anap ekkeenee? ");
INSERT INTO mfxl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yhayi anaaxay na7a baasannee? E indatii sunthay Mayiramo baasanee? E ishitay Yayqqooba, Yooseefa, Simoonarannee Yihuda baasannee? ");
INSERT INTO mfxl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E mishunthikka nuur yezunthuna baasanee? Yeezin, yha athay yha ubba anapp ekkeenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yey gishos, E giz baza ekkaam ixxeeza. Zin Yesuusa, «Nabe fa yelintteez biittayidannee fa kara asay kale bonchchinttooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","U ammanaami ixxeez gishos gaame malata ye aqayid oothekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ye wode Galila aqisiz Heroodissa Yesuusa waara si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fa ayllitayiko, «Yhay xammaqiza Waannisa; E yhayiqopp dendeeza. Yey gishos yha ubba malatita E oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","E yeya geezay Heroodissa fa isha Filphoosa machat Heroodiyada gishos Waannisa achch keetha gelsseez gishosi. ");
INSERT INTO mfxl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Waannisa Heroodissa, «Ne izo ekkodayis woga baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodissa Waannisa wodhodayis koyeeza, zin woyay Waannisa nabe udii bi7iz gishos yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heroodissa fa yelintteez gallasa bonchchiza wode Heroodiyada na7at as tiina yethar doonggii eza ufaysseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yeezin, E, «Iza koyiz baz ubba iis immada gi» caaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na7ata fa indat zore si7ii Heroodisako, «xamaaqiza Waannisa qoodhaypp gachchii omma fil7o gancce gaddii taasi inggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Iza yeegin kaatay qiiradheeza, zin fa caaqay gishonnee paar yez imathitay gishos gi I oyichay polinttod garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaatay as kiittii Waannisa achch keetha yezin e qoodha gachiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E omma fil7o gancce aathii ki7ii na7atis inggeeza; na7atakka ekkii fa indatis kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Waannisa tamaaritay yi7ii e aha kanggii moogeeza. Ezayppe guye haneezibaz ubba yhanigii Yesuusas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuusa haneezibazana si7ii wogolo gancce gelii ye besayppe pettii geemmiza aqo fa aaddas yhanigeeza. Asay yeya si7ii katamitaypp dendii toker eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuusa wogolopp wodhdhii gaame asa bi7ii unttisi qadhintteeza. U gancce yez hargintteez asita patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa7ay omathittar yhanigin Yesuusa tamaaritay eziko shiiqii, «Yha aqay liizho, sa7aykka qammeeza. Yey gishos, heera yhanigii paasi wonggii maad garkk woya dakkoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zin Yesuusa unttiko, «Woyay meekkazar yhammadayis koshshooya; u maadbaz yi inggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","U mahii, «Nuus yhannee ichchin soollorannee nam77ii molopp hara baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ezikka, «An izo yhana ko7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma maaqqikka, woyay maatal bettoday garkk odeeza. Ichchin soollora nam77ii molita ekkii, salo bi7ii galatii maaqqii, soolla duuthii fa tamaaritayis inggeeza; unttii ma woyayis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ubbay mi mizheeza. Yesuusa tamaaritay maadar atteezana taphpho nam77ii leemate dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Katha meez asay maachchinnee na7a attin ichchin mukule maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuusa fa tamaaritay wogolo gancce gelii paapp tiinattii abbaypp seko finthi piinggoday garkk kiittii faasi woya moyizodayis guye atteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Woya moyizii maaqqii fa aaddas woossodayis pettii derell afa kezeeza. Sa7a qamminkka E fa aaddas ezayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ye wode wogolay abbal afar yhammadar tiina baggar carkko dendin gotay wogolana ciphphicheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wontimaathela Yesuusa abbal afa yedhdhittar fa tamaaritayiko ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E tamaaritay, E abbal afa yedhdhittar unttiko yi7izana bi7ii yashitteeza. Unttikka, «yhayi meeshshe» gi yashittii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Zin Yesuusa ellissii, «Akko baaya! Yashittippatte! yhay tana» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phixiroosa eziko, «Godayyo, nena maaqqiko, ta haathayis afar yedhdhii neeko yhanigod garkk tana azazoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuusa Phixiroosako, «Yhana ye7oba» yeegeeza. Phixiroosa wogolopp wodhdhii haathal afa yedhdhittar Yesuusako yhamo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Zin woliqama carkko bi7ii yashitteeza. Haathay eza mitto aykkin «Godayyo, tana ashshooyee» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuusa ellis fa kushayid dakkii eza aykkii, «Naat, ammano pacceezayyo abis sidhe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesuusarannee Phixiroosara wogolo gancce gelin carkkay cicirkkii geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wogolo gancce yez e tamaaritay, «Neenii tumakka Xooss Na7a» gi goynneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","U abba piinggii Gensareexe biitta helleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ya biittayil yez asay Yesuusana erii fa shooro heera yez ubbayis kiita dakkeeza. Asay hargintteez asita ubba eziko ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hargintteez asitay e afila manchcha aadda bochchodayis eza woosseeza. Bochcheez ubbitaykka paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yeypp guye, pettii pettii Farasaawitayinnee higge asitamaaritay Yerusallemepp Yesuusako yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ne tamaaritay abis nu aditay woga menthe? U katha maadaypp tiina fa kusha meecinttooya» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuusa mahii, «Yinttii, yi woga gishos Xoossa kiita polizana abis ixxeenee? ");
INSERT INTO mfxl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Abis giiko, Xoossay, ‹Ne adennee ne indo bonchchoba. Fa ada woy fa indo cazhizay yhayqqo geekkasa?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Zin yi, pettii as fa ada woy fa indat maaddod baz yezin, ‹Yhaya ta Xoossis yarshsheeza giiko, ");
INSERT INTO mfxl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","fa ada woy fa indat bonchchodayis beezooya› yi yeegiza. Yeezii yinttii, yi woga polodayis Xoossa qaala menthiza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yinttanno, cubbitayyo, Isayaasa yi baz turo odeeza, ");
INSERT INTO mfxl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹Yha asay tana fa doonar bonchchiza, zin u wozinay taapp haakko yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Asay tana cer goynniza; u asii medhdheez woga, Xoossa higge aazisii taamarssiza› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuusa gaame asita faako xeegii, «Si7oytta! Akaakoytta! ");
INSERT INTO mfxl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","As tunisiza bazay doonar geliz baz baazin doonappe keziz bazi» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yeypp guye, Yesuusa tamaaritay eziko yi7ii, «Farasaawitay neenii odeeza si7ii dhubintteezana ne ereenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zin Yesuusa unttiko mahii, «Salo yez ta aday tukkekka mith ubbay shodinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","U bagga hirigipatte; u to7a kaalithizaykka to7ita. To7ay to7a kaalithiko, nam7itaykka gaga qitiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phixiroosa mahii, «Yha aazisays bilitha nuus odooyye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuusa unttiko, «yinttiskka yhanno hellodayis gelekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Doonar geliz baz ubbay ulo gelii bale kezizana yi eroosa? ");
INSERT INTO mfxl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Zin doonar keziz baz wozinapp keziza. As tunisiza bazitay yhayitita. ");
INSERT INTO mfxl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Unttikka as wozina ganccepp keziz iita qofa, wodho, lagite, laame, kayzo, worddo markkatithii, as sunth dhabiso, cashshe. ");
INSERT INTO mfxl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yeya azizbazitay as tunisizapp attin meeccinttekka kusher miizay tunisooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeypp guye, Yesuusa ezaypp kezii Xiroosannee Sidoona katamitay yez biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pettii Kanaanee biitta astta Yesuusako yi7ii, fa qaala dhoqqi udii, «Godayyo, Dawute na7ayyo, taasi qadhinttooye; ta na7ato tuna ayyana aykkii iita waaythiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Zin Yesuusa pettii qaalakka mahekkazar si77 atteeza. Yesuusa tamaaritay eziko yi7ii, «Yha astta nu lassa kaallittar, uukiza gishos, ne izo moyzooyee» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuusa mahii, «Taanii wudepp dhabeez durigarkk Isreele karapp dhabeez asitay aaddas kiitintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Zin iza, e tiina xuggunii, «Godayyo, tana maaddooye?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E mahii, «Na7itay katha ekkii kanitayis olodayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Izakka, «Godayyo, yey tuma, zin hara attozin kanitay fa goditay maadar, gaytapp wodhdhiz gufa miiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesuusa mahii, «Astt yhannee, ne ammanay gita; ne koyeezayigarkk nees hano» yeegeeza. I na7ata izir paxxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuusa yeypp denddii Galila Abba lanqqe qiteeza. Pettii amibal afa kezii, ezayid betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Gaame asay far, wobbita, to7ita, sileezita, doona muumeezitannee, hara gaame harggintteez asita ekkii, Eziko ki7ii e tiinayid gaddeeza. Yesuusa unttan patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yey gishos, muumitay nashshodar, sileezitay paxodar, wobbitay yedhdhodar, to7itay be7adar asay bi7ii malabaz gi, Isreele Xoossa galatteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuusa fa taamarita faako xeegii, «Yha gaame asay taar hayidzii gallas gam7eez gishonnee unttis yhatti miizibaz baazay gishos ta unttisi qadhinttiza. U ogel daaburii fookkam garkk akko muzekka unttan cer dakkodayis ta koyooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E tamaaritay mahii, «Nuunii yha liizhayid yhay garkk asayis gidiza katha anapp demmadee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuusa unttiko, «Yinttis aappun soollo yenee?» yeegii oyceeza. U mahii, «Laappun soollonnee yishshe molitaypp xiqqa yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesuusa woyita sa7a bettoytta yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yeypp guye, ye laappun soollayira mola ekkii Xooss galateeza. Dusirithii fa tamaaritayis inggeeza. E tamaaritay asayis gisheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asay ubbay mi mizheeza. E tamaaritay, maadar atteez gufa laappun gita leemate kunth dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Meez asay maachchinnee na7a payidekkazin dhiirathi aadda oyddii mukulo. ");
INSERT INTO mfxl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuusa woyita dakkezaypp guye wogolo gancce gelii Magadoona giz biitta qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasaawitayinnee Saduqaawitay Yesuusako yi7ii. Eza paaccodayis koyii, fana salopp malata beezo gi oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zin E unttiko, «Sa7a omathodar ‹Salo zoqqi benttiko wontta sa7a booqaloda› yi giza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wonttitar ‹Salo zoqqi shaara aykkiko yhayino ira bukkoda› yi giza. Yeezin yi salo bi7ii mallii erizin wode bi7ii mallii erodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iititaynnee ammanoowa yeletithii malata koyiza. Zin eesi Yoonasa malataypp hara malata ingginttooya» yeegeeza. Yeypp guye, unttan ezayid ashshii hara aqo qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","U abbapp seko pino piinggeez wode soollo ekkii ye7odana dogeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuusa unttiko, «Ferisaawitayppenne Saduqaawitay irshshopp naaginttoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Unttikka fa gancce, «E yeya geezay nu soollo ekkii ye7ekka gishshos maaqqada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuusa u qofa erii, «Yinttano, ammano pacceezitayyo! Soollo ekkekka ye7eez gishos yi woli giddo abis odinttee? ");
INSERT INTO mfxl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yhattekka yi akaakoosa? Ichchin mukule asayis ichchin soollo gisheezannee u mi mizhin yi aappun leemate kunthi dentheezaka yi dogeenee? ");
INSERT INTO mfxl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yey garkkekka, laappun soollo oyddii mukule asayis gisheezannee u mi mizhin, yi aappun leemate kunthi dentheezaka yi akaakoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yikkee, taanii Ferisaawitaynnee Saduqaawitay irshshopp naaginttoytta gi odizay soollobagga baazana yi akaakoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yeezin, e tamaaritay Yesuusa odizay munuqo denthodayis wodhdhiz irshshobagga baazin Ferisaawitaynnee Saduqaawitay timirttaypp naagintto bagga maaqqeezana akaakeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuusa Qisaare Filphoosa biitta helleez wode fa tamaaritayiko, «Asay, As Na7a oona gee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Unttikka, «Pettay pettay xamaaqiza Waannisa, yhankkitay Eelaasa, ma yhankkittayikka Irmaasa woy nabitaypp petta giza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuusa mahii, «Yeezin, yi tana oona gee?» gi unttan oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoona Phixiroosa mahii, «Neenii Kiristtoosa, de7o Xooss na7a» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuusa Phixiroosako, «Yoona na7a Simoona, ne anjjintteezaya! Yhaya neesi beezeezay salo yez ta adaypp attin as baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta neesi odiza Phixiroosa, neenii zaalla! Taanii yha zaallayil afa ta woosa keetha keexxoda. Yhayiqo wolqqaykka izo gamenna. ");
INSERT INTO mfxl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Salo kaattetithi qulppitta ta neesi immada. Sa7a ne acceez baz ubba salo Xooss kale accintteez baz maaqqada. Sa7a neenii bili7eez baz ubbay salo Xooss kale bilintteez baz maaqqada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yeypp guye, E, Kiristtoosa maaqqeezana ooskka odaamay garkk fa taamarita miinthii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ye wodepp aykkii Yesuusa fa tamaaritayis, «Taanii Yerusalaame yhammadays beeziza. Ezayid gade cimitaypp, qeese halaqitayppennee higge asitamaaritayipp ta meto ekkodayis beeziza. U tana wodhoda, zin taanii hayidzantho gallas yhayiqopp dendoda» yeegii geeshshii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phixiroosa Yesuusana gaxa kessii, «Godayyo, yey hanena! Yey garkk baz nena yesha hellippe!» yeegii gayileeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuusa Phixiroosako guye maaqqii, «Yha Xalahayyo, taapp haakkoba! Neenii as qofa qoppizapp attin Xooss qofa qoppoowa gishos taassi dhube maaqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yeypp guye, Yesuusa fa tamaaritayiko, «Oonkka tana kaallodayis koyiz baz maaqqiko fana kado, fa mazqqala tookkii tana kaallo. ");
INSERT INTO mfxl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Fa shemppo ashshodayis koyiz ubbitay dhabisiza. Zin fa shemppo ta gishos gi aathii inggizay ashshiza. ");
INSERT INTO mfxl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asii alame kuntha fabaz uddii, fa shemppo dhabisiko eza ab maaddee? Woy asii fa shemppo wozodayis ab inggodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","As na7ay fa aday bonchchayir fa kiitanchchitayir ye7oda. Ye wode pettii pettii athayis e oosatgarkk immada. ");
INSERT INTO mfxl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta turo odiza; as Na7ay kaatetithayir maaqqii ye7odar be7ad hellodayis yhaydda eqqeez asaypp yhayqqaamizitay yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Usuppun gallasapp guye Yesuusa Phixiroosa, Yayqqobannee e isha Waannisa paar ekkii u aadda damma ambal afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ezayid u tiina Yesuusa malay laamintteeza; e sinaykka awa garkk poo7eeza. E afilaykka booth poo7o garkk poceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yikkee, Musennee Eelaasa ezar nashshodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phixiroosa Yesuusako, «Nuunii ne koyiko petto neesi, petto Musesii, petto Eelaasas yhaydda hayidzii shaqara accoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Phixiroosa yeya haga ododar boothi shaara unttan kammeeza. Shaaray gancce, «Tana ufayssiza, ta qadhdhiza na7ay yhaya, eza si7oytta!» yeegiz giirthii ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesuusa tamaaritay yeya si7ii dagamii fa sinayir sa7a guphinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zin Yesuusa unttiko shiiqii unttan bochchii, «Dendoytta, yashittippatte!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","U dhoqqi gi be7adar Yesuusapp hara oonakka be7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","U ambalapp wodhdhodar Yesuusa unttiko, «As Na7ay yhayiqopp dendod hellodayis yhaya yi be7eez baazana ooskka odippate» gi azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesuusa tamaaritay, «Yeezin, higge asitamaaritay Eelaasa Kiristtoosapp tiinatii ye7od geezay abiso?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesuusa mahii, «Ee! Eelaasa tiinadhdhii yi7ii ubba baz lo7ithoda. ");
INSERT INTO mfxl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Zin ta yinttis turo odiza; Eelaasa tiinatii ye7eeza. Unttikka ezal afa koyeez baz ootheezaypp attin eza shaakkii erekkaya. Yey garkk As Na7ay u kushe metto ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ye wode Yesuusa geezay xamaaqiza Waannisa bagga maaqqeezana u akaakeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","U ambalapp asayiko maaqqeezan garkk pettii athay Yesuusa tiina bunqittii, ");
INSERT INTO mfxl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Godayyo, magane ta na7ayis qadhinttooye; eza aginar aginar denddii tama ganccennee hathigancce shoccii oliz iita hargge yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne tamaaritayiko ta ki7in, u pathodayis danda7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuusa mahii, «Yinttanno, ammanoowa zhucca yeletithitayyo ayide hellodayis ta yinttar yezodee? Ayide hellodayis ta yinttan danda7odee? An na7a yhana ekkii ye7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuusa tuna ayyana qoddin, tuna ayyanay na7aypp kezeeza; ye saatate na7ay paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yeypp guye, Yesuusa tamaaritay fa aaddas eziko shiiqii, «Nuunii tuna ayyana kessodayis danda7ekkazay abiso?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E unttiko, «Yinttis ammano xiqqeez gishshosii. Ta yinttis turo odiza; sanafice aafe garkk ammano yinttis yezako ‹Yha amba yhaypp denddii gede aadhoba› giiko yinttis kiitinttoda. Yinttis danda7inttoowa baz baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Zin yey garkkezay woosappennee xoomapp attin harar kezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuusa tamaaritay Galila biitta shiiqii yeezin Yesuusa unttiko, «As Na7ay asi kushe aadhii ingginttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Unttii eza wodhoda, zin E hayidzintho gallas yhayiqopp dendoda» yeegeeza. E tamaaritaykka iita azzaneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuusara e tamaaritayira qifirnahoome katama helleez wode Xoossa Keeth giira ekkizitay Phixiroosako yi7ii, «Yi asitamaaray Woosa Keeth giira giirinennee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phixiroosa mahii, «Giiriza» yeegeeza. Phixiroosa kara gelodar Yesuusa tiinatii, «Phixiroosa, neess ab aazee? Yha sa7a kaatetithay qaraxennee giira oopp ekkinnee? Gade asayppennee as gade asapp?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phixiroosa «As gade asappee» gi maheeza. Yesuusa mahii, «Gade as giira giiroowa guusso? ");
INSERT INTO mfxl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Zin u dhubinttaamay garkk abba yhanigii molo aykkiz manxxaqo oloba. Tiina ne aykkiz molay doona dooyii giiras gidiza miishe ekkii ne gishonnee ta gishos kanggii giiroba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ye wode Yesuusa tamaaritay yi7ii, «Salo katettitha ubbapp aadhizay oonoo?» yeegii oyicceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuusa pettii duude na7a xeegii u gancce essii yhay garkke yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Ta yinttis turo odiza; yi laaminttaamixikonnee duude na7a garkk hanaam ixxiko salo kaatetitha gelodayssi yesha danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yikkee, yha duude na7ay garkk fana kawushshiza oonkka salo katettitha ubbapp aadhiza maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yhay garkk duude na7a ta sunthar mokkiza oonkka tana mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Zin tana ammaniza yha xiqqitaypp petta nagara oothod garkk dhube maaqqiz oonkka damma woxa fa qoodhel accii ciimmo abba gancce mitinttiko eesi lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Alamel asii nagara oothod garkk oothizabaz yeza gishos alame ayye. Yey garkk baz ye7ekka attaamii, zin dhube e baggar yi7iz atha ayye. ");
INSERT INTO mfxl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Ne kushe woy ne toke nena balithiko neepp gachchii oloba. Neenii nam77ii kusher woy nam77ii toker medhina tama gancce wodhdhadaypp kushe woy toke duuxa maaqqii medhina de7o denigizay nees lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma ne aafay nena balithiko izo woocii kessii oloba. Neenii nam77ii aafer gaanname tama gancce wodhdhadaypp pettii aafer medhina de7o gelizako nees lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ta yinttis odiza; salo yez unttan naagiz kiitanchchitay ubba wode salo yez ta Aday tiina yez gishos yi yha xiqqitaypp pettakka leeqqaam garkk naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","As Na7ay dhabeezita ashshodayis ye7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ma Yesuusa, «Yinttis ab aazee? Pettii athayis xeet duritay yezitayppe pettay dhabiko uddufun tammanne uddufunita ambal afa olii ashshii ye dhabeezana koyodayis yhanigoosa? ");
INSERT INTO mfxl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta turo odiza; E denggeez wode uddufun tamannee uddufunitaypp aathii dhabii bentteez pettii durayil ufayttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yey garkkekka, salo yez yi aday yha xiqqitaypp pettay dhabod garkk koyooya. ");
INSERT INTO mfxl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ne ishay nena qohiko ne aaddas eziko yhanigii e buutta ezis odoba. E nena si7iko ne isha neesi shalo udoba. ");
INSERT INTO mfxl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Zin E nena si7aam ixxiko, nam77ii woy hayidzii as markkar mootii wodhiza gishos pettii woy nam77ii as ekkii eziko yhanigoba. ");
INSERT INTO mfxl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E unttan si7aam ixxiko, woosa keethis odoba. Woosa keethi giz baz si7aam ixxiko ammanoowa as garkk woy qaraxe gachchisiz as garkk eza tayiboba. ");
INSERT INTO mfxl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ta yinttis turo odiza; sa7a yi acciz baz ubbitay salo Xooss kale accintteez baz maaqqada. Sa7a yi billeez baz ubbitay salo Xooss kale billintteez baz maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Maakka ta yinttis odiza; sa7a yinttipp nam7itay pettii wozinar maaqqii Xooss woossiza baz maaqqiko salo yez ta Aday yinttis oothoda. ");
INSERT INTO mfxl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tana kaallizitaypp nam77ii woy hayidzii maaqqii shiiqiza bessa ta u gancce benttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ye wode Phixiroosa Yesuusako yi7ii, «Godayyo, ta ishay tana qohiko aappun toke ta atto godayis beezinee? Laappun toke hellodayissonee?» gi oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuusa mahii, «Yeya baaya, laappun tam toke laappunpp attin laappun toke baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Yey gishos, Xooss kaattetithay fa ooso asitayir fa mishay paccezakonnee fucceezako be7adayis qoppeez kaata aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ye kaatay miishay paccezakonnee fuceezako bi7iza wode gaame mukule aco yez pettii atha eziko ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Zin ye ayllay aca ciggodayis gaminttin eza, e machchatira, e na7itayirannee ezis yeza baz ubbay bayizinttii aco ciginttod garkk eza goday azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yeezin ayllay fa goday tokayil afa wodhdhii, ‹Ta godayyo, hayyana xiqqas gam7ooyee, ta ubba ciggoda› yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaatay ezis qadhinttii, dakkii ashsheeza; e acakka maareeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Zin ye ayllay kezii yhanigii fa laggee ooso asitaypp pettay ezapp xiqqa miishe tali7eezana, ‹Neell afa yez ta miisha taass ciggoba› gi athayss qoodhat cuuleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Ye e lagge ayllay e tokayil wodhdhii, ‹Hayyana xiqqal ogam7ooyee ta nees ubba ciggoda› yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Zin ixxii ekkii kanggii fa laggay aca ciggod hellodayis achch keetha geliseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yey gishos, hara laggee ooso asitay yeya bi7ii iita yilottii, yhanigii fa godayis E ootheez bazita ubba odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Yeezin goday ye aylla xeegisii, ‹Yha iita ayllayyo, neenii tana woosseez gishos ta ne aca ubba nena maareeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yeezin, taanii ne aca maareezay garkk neenii ne laggee maaqqeez ayllay aca maarodayis nees beezoosa?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yey gishos, goday iita yilottii, E fa aca ubba ciggod hellodayis pathi kaa7inttoday garkk achch keethis aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Yey garkke, yi pettay pettay yi isha wozinapp maaram ixxiko salo yez ta Aday yinttan yhay garkk oothoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuusa yeya odii haaseezaypp guye Galilapp denddii Yorddanoosa borikapp seko pino yez Yihuda biitta qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gaame asay eza kaallii yhanigin u ganccepp hargintteez asita patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ferisaawe asitay eza faaccodayis koyii eziko yi7ii, «pettii asii ababaz gishossikka fa machchato dakkodayis beeznnee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuusa mahii, «Xoossii tiina dhiirathinnee maachchi udii medhdheezana yi nabbabekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹Yey gishos, Pettii asii fa adenne fa indo ashshii fa machchatir petto maaqqiza, nam7itaykka pettii asho maaqqiza› ");
INSERT INTO mfxl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yey gishos, unttii pettii asho maaqqodaypp attin nam7e maaqqooya. Yikkee, Xoossii acceezana asii billippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ferisaawe asitay, «Yeezin, Muse pettii as anjjo warqqate inggii fa machchato dakkodaygarkk abis azazeenee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuusa mahii, «Yinttii, yi machchita dakkodgarkk Muse yinttan azazeezay, yi wozina minotithay gishopp attin tiinapp yey garkk baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta yinttis odiza; fa machchat lagttekkazin dakkii hara ekkiz oonkka laammiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E tamaaritay eziko, «Azininnee machchii bagga yey garkk maaqqiko ekonnee gelo attiko lo77o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuusa mahii, «Yey garkk timirttay Xoossii danda7a inggeezitayisapp attin as ubbitayis baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yikkee, yelinttitar siilla maaqqii yelintteezitay yeza, ma asii qaaratteezitay yeza, ma salo kaatetith gishos yeegii fana siilliiseezitay yeza. Yey gishos, yhaya ekkodayis danda7iza oonkka eko» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesuusa fa kushayid duude na7itayil afa gaddii unttis woossod garkk pettii pettii asay na7ita eziko ke7eeza. Zin e tamaaritay asayil kacintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zin Yesuusa, «Xooss kaatetithay yhayititay garkkezitayis maaqqeez gishos duude na7itay taako yi7izana kayippate; ye7o goytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fa kushayid unttal afa gaddeezaypp guye ye aqaypp ashshii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pettii gallas pettii athay Yesuusako yi7ii, «Asitamaarayyo, taanii medhina de7o denggodays abi lo77o baz ootho?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuusa eziko, «Lo77o baz bagga ne tana abis oyce? Pettii Xoossapp attin hara lo77o baaya. Zin ne medhina de7o ekkodayis koyko azazita naagoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Athay mahii, «azazitay Aayita?» yeegii oyceeza. Yesuusa mahii, «Wodhippe, laammippe, kasitippe, worddo markattippe, ");
INSERT INTO mfxl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ne adannee ne indato bonchchoba, ne lagga ne ubay garkk qadhdhoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ye paanthay, «Taanii yhayitita ubba na7atithapp aykkii polittar yeza. Yeezin, hara taasi paccizabaz abba?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuusa mahii, «Ne folo maaqqodayis koyko yhanigii nees yeza baz bayizii manqqitayis inggoba; neenii salo duritoda. Yeezii maaqqii yi7ii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zin ye athay dure maaqqeez gishos yeya si7ii azanttar ashshii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yeypp guye, Yesuusa fa tamaaritayir, «Taanii yinttis turo odiza; dure salo kaatetith gelodayi gaame meto. ");
INSERT INTO mfxl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dure asii Xooss kaatetithii gelodaypp gimaale narppe lukor aadhoday kawuzhiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesuusa tamaaritay yeya si7ii malabaz gi, «Yeezin, oonii attodayis danda7ee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuusa unttan dakkii bi7ii, «Yhayi asis danda7initooya, zin Xoossis ubbay danda7inttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phixiroosa mahii, «Nuunii ubba baz ashshii nena kaalleeza. Yeezin, nuunii ab demmadee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuusa unttiko yhay garkke yeegeeza: «Taanii yinttis turo odiza; As Na7ay ye7od alamayid fa bonchcho zufaanel bettiza wode yi taphpho nam77iitay, tana kaalleez, taphpho nam77ii zufaanell bettii taphpho nam77ii Isreele zerithitayil afa pirddoda. ");
INSERT INTO mfxl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta sunthay gishos keethita woy ishita woy mishita, woy ade woy indo woy na7ita woy fa ooso gade ashsheezay oonkka xeet kushe ekkoda. Ma medhina de7okka ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zin gaamitay tiinitay guyita, ma guyitay tiinita» maaqqada yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Xooss kaatetithay fa woyne gancce ooso asita oosisodays wontta guura kezeez gade goda aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E ye ooso asitayis pettii gallasis pettii diinaare gachchodayis unttar giigii, unttan fa woyne gancce dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Ma wonttapp hayidzii saate maaqqodar kezii ooso dhabin gaabel afa eqqeez hara asitakka denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","E unttiko, ‹Yinttikka ta woyne gancce yhanigii oothoytta, ta yinttis beeziza damooze gachchoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Unttikka yhanigeeza. Maakka E usuppun saaterannee uddufun saater kezii yhay garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Taphpho pettii saate maaqqin E kezodar yhankkita eqqeezita denggii, ‹Yi ooso oothekka gallas muda yhaydda abis eqqii peezheenee?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«U mahii, ‹Nuna oosisiza asii dhabeez gishshosi› yeegeeza. «Ezii, ‹Yinttikka ta woyne gancce yhanigii oothoytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Sa7a omathin, woyne goday ooso asitay halaqayiko, ‹Ooso asita xeegii guyepp ooso gelezitaypp aykkii tiina geleezita hellodays unttis damooze gachchoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Taphpho pettii saater ooso aykkeezitay yi7ii, ommar ommar pettii pettii dinnare ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tiina ooso aykkeezitay yi7ii, paas gaame inginttoda gi qoppeeza. Zin unttikka ommar ommar pettii pettii dinnare ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Fa miisha ekkii maaqqii gade godayil afa oolleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Yhayititay guyepp yi7ii pettii saate aadda ootheeza. Zin gallas muda awa mishar daaburii peezheez nuur unttii wayizii petto maaqqode› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Woynnee tukkeez goday ooso asitaypp pettayiko, ‹Ta ishayyo, taanii nena qohekkaya; ne taar giigintteezay pettii diinnares baasa? ");
INSERT INTO mfxl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne gishito ekkii ne kara qitoba. Ta omathi ye7eezayssikka neesay garkk immadayis koyiza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taanii ta miishayir koyeez baz oothodayis taasi mawute baasa? Woy taanii keeha maaqqeez gishos nena qinaatisinee?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Yey garkk yhatte guyitay, tiinatoda ma tiinitay guyitoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuusa Yerusalaame yhanigttar, taphpho nam7i taamarita duma gaxa kess unttiko yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Yeezako, nuunii yhatt Yerusalaame yhamol afa yeza. Ezayid as na7ay qeese halaqitayisnnee higge asitamaaritayis aadhii ingginttoda. Unttikka ezal afa yhayiqo pirdde pirddoda. ");
INSERT INTO mfxl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eza Ayihude baa woyas aathii immada. Unttii eza kawushshoda, alangoda, eza mazqalel afakka sottoda. Zin E hayidzintho gallas yhayiqopp dendoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ye wode Zabddosa machchat fa nam7i dhiirathi na7itayir Yesuusako yi7ii, e tiinayid bunqqittii pettibaz eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuusa iziko, «Ne ab koyee?» yeegeeza. Iza mahii, «Ne kaatetithayid yha ta nam7i na7itaypp pettay neesi ushachcha pettay ne haddirssa betto gooye!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Zin Yesuusa mahii, «Yi ab woossizako erooya; taanii uzhodayis yez meto xuu7a uzhodayis danda7inee?» yeegeeza. Unttikka, «Ee nu danda7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesuusa, «Tuma ta uzhodayis yez xuu7ayppe yinttii uzhoda. Zin ta ushachchannee haddirssa bettoditana dooreezay tana baaya. Ye aqay ingginttizay, ta aday immadayis giigiseez asitayisii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Atteez taphphii e tamaaritay yeya si7ii nam77ii ishitayil afa kacintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zin Yesuusa unttan ubbita xeegii yhay garkk yeegeeza. «Ayihude baa asa aqisizitay fa asal afa godatizanne unttan kaalithizitay wolqqar aqisizana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Zin yi gancce yhay garkk maaqqippe. Yinttipp bayratithi koyiz oonkka yinttis aylle maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yi gancce ubbaypp aadho maaqqodayis koyiz oonkka yinttis aylle maaqqodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yey garkkekka, As na7ay as maaddodayisnnee gaame as wozodayis fa shemppo immadayis ye7eezapp attin asar maadinttodayis ye7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeypp guye, Yesuusa fa tamaaritayir Iyarkkopp kezii yhammadar, gaame asay unttan kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oge gaxa betteez nam77ii to7itay Yesuusa ezayir aadhizana si7ii, «Godayyo, Dawute Na7ayyo, nuuss qadhinttooye» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gaame asay unttan, «Hayizoytta» yeegii qoddeeza. Zin unttii, «Godayyo, Dawute na7ayyo, hayana nuna maarooye» gi gujjii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuusa eqqii, unttan xeegii, «Ta yinttis ab udod garkk koyinee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Unttikka, «Godayyo, nu aafay be7aday garkk nu koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuusa unttis qadhinttii, u aafa bochcheeza. Ellisii u aafay bi7in; u eza kaallii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuusara E tamaaritayira Yerusalaame ukkii, Debire Zayite amibal afa yez Beetefaage giz heera hellittar, Yesuusa fa tamaaritaypp nam7ita paapp tiina azazeeza: ");
INSERT INTO mfxl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Yi tiina yez heera yhanigoytta. Ezayid pettii hare achcha yezanno I na7ayira yi ellisii demmada. Unttan billii yhana ekkii ye7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oonkka yinttan oyiciko, ‹Goday unttan koyiza› yeegoytta. E unttan ellis dakkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nabay, ");
INSERT INTO mfxl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Xiyone katama, ‹Yikkee, ne kaatay ashikke maaqqii, harel afannee hare na7al afa bettii, neeko yi7iza› yeegoytta» yeegii xaafeezay polinttodgarkk yey haneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E tamaaritay yhanigii Yesuusa unttan azazeezay garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Harttonnee hare na7a ki7ii afar ma77eez fa afila u zokkayil oleeza. Yesuusa afilayil afa betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Woyay fa afila ogel hiixeeza. Yhankkitay harata shaqqii ogel oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yesuusapp tiinar yedhizitaynnee ezapp guyer kaalliza woyitay, «Hosaana! Dawute na7ay galatintto! Goday sunthar yi7izay anjjintteezaya! Bonchcho Ubbapp Dhoqqa Salo Xoossayis maaqqo!» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuusa Yerusalaame katama geleez wode ye katama yez asi ubbitay, «Yhayi oonoo?» yeegii shariksharkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Asay, «Yhay Galila biitta yez Naazirete katamapp ye7eez nabe Yesuusabe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuusa Xooss keetha gelii, ezayid bayizizitannee wonggizita ubba bayi7ii bale kesseeza. Miishe laammizitay xarpheezitannee hollita bayizizitta oyddita shirii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ezikka unttiko, «Xooss qaalayid, ‹Ta keethay Xooss woossiza keethi ginttinttoda› yeeginttii xaafintteeza. Zin yi paanitay qosinttiz kom7o udeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesuusa Xooss Kara gancce yezin too7itaynnee gunddeezitay eziko yi7in unttan patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zin qeese halaqitaynnee higge asitamaaritay Yesuusa ootheez malatita bi7izitaynnee xiqqqa na7itay Xooss keeth gancce, «Dawute na7ay, galatintto» yeegii uukkizana si7ii kacintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","U Yesuusako, «Yhayititay giza ne si7inee?» yeegeeza. Yesuusa, «Ee si7iza, Xooss qaalayid, ‹Duude na7itay doonannee dhanggiz na7itay doona galata kuntheeza› yeeginttii xaafintteezana yi nabbabekasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Unttan ize ashshii Bitaana katama yhanigii aqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesuusa wontta guura katama maaqqii yi7ittar nayintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oge gaxa pettii balase mith bi7ii iziko yhanigeeza. Zin hayepp attin hara abikka denggekkaya. Yey gishos, izo, «Yhannipp medhinas neepp aafe benttippe!» yeegeeza. Ye balase mithata izir meleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","E tamaaritay yeya bi7ii, «Yha balasat wayizii ellis melare?» yeegii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuusa mahii, «Taanii yinttis tuma odiza; yinttis ammano yeezako, ma yi sidhaamixxiko balasel afa taanii ootheezan garkk aadda oothaamii, zin ‹Yha amba shodinttii abba gancce wodhdhoba› yeegiko yinttis hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ammanii yi woossiza baz ababaz maaqqikokka yi ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuusa Xoossa Keeth gelii tamaarssodar, qeese halaqitaynnee Ayihude cimitay eziko yi7ii, «Neenii yhaya ubba aba mawuter oothee? Nees yha mawuta inggeezay oonoo?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuusa unttiko, «Taankka yinttan pettibaz oyciza; yi taas izo mahiko, taanii aba mawuter oothizako yinttis ododa. ");
INSERT INTO mfxl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Waannisa xammaqod garkk mawutay anapp inggintteennee? Xoossappennee asappee?» yeegeeza. Unttii woli gancce tobbii, «Nuunii, ‹Xoossapp› giiko, E nuna, ‹Yeezin abis ammanekasa?› goda. ");
INSERT INTO mfxl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nuunii, ‹Asappee› giiko, asii ubbay Waannisana nabe udii bi7iza gishos woyay nuna yashshiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yey gishos, «Nuunii erooya» yeegii maheeza. Ezikka, «Yikkee, taankka yhaya aba mawuter oothizako yinttis odaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Yesuusa maaqqikka yhay garkk yeegeeza: Pettii athayis Nam77ii dhiirath na7itay yeza. Ye athay bayra na7ayiko yhanigii, ‹Ta na7ayyo, yhayino woyne gancce yhanigii yhanttoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na7ay mahii, ‹I7inno yhanggaamii› yeegeeza. Zin guyeppe fa wozinar qoppii ekkii yhanttodayis qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aday fa guye na7ayiko yhanigii, fa bayra na7ayiko geezay garkk azazeeza. Ezikka, ‹Ero, ta adayyo› yeegeeza. Zin yhanigekaya. ");
INSERT INTO mfxl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yha nam77ii na7itaypp fa adayis azazintteezay aaya?» yeegeeza. Unttikka, «Bayra» yeegeeza. Yesuusa unttiko, «Ta yinttis tuma odiza; qaraxe gachishizitaynnee laammizitay yinttipp tiinatii Xooss kaatetith geloda. ");
INSERT INTO mfxl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xammaqqiza Waannisa luulo oge tamaarssittar yi7in E gizana yi ammanekkaya. Zin qaraxe gachisizitaynnee laammizitay ammaneeza. Yi hara attozin, unttan bi7ikka yi nagaraypp maaqqii ammanekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Maakka Yesuusa yhay garkk yeegeeza; «Hara aaziso si7oytta, woyne tukkeez pettii athay yeza. Ye woyne gaxana gaseeza. Woyne buulliz ollakka bookkeeza. Woyna naagodayis shakkokka kocheeza. Yeypp guye, gada mattaye inggii hara gade qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Woyne aafa maxiza wode hellin fana helliza bagga ekkii ye7od garkk fa ayllita unttiko dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mattaye ekkeezitay e ayllita aykkii petta yhadhdheeza, yhankka wodheeza ma atteezana shuchchar shoceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Woyne atakilitte goday kaseesitaypp gaame hara ayllita azazeeza. Mattaye ekkeezitay unttal gujjikka yhankkitayil afa ootheezay garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wurssithal E, ‹Ta na7a u bonchchoda!› yeegii fa na7a unttiko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Zin mattaye ekkeezitay na7a bi7ii woli gancce ‹Gada laattoday yhaya, eza wodhii gada nuunii ekkoda!› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na7a aykkii woyne gancceppe gaxa kessii wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Yikkee, woyne atakilitte goday yi7ii ye mattaye ekkeezita wayssadee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","U mahii, «E ye iita asa iita wodho wodhii, woynay kaa7iz wode eza helliz bagga woder woder inggiza hara asis immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuusa mahii unttiko, Xoossa qaalay, «‹Gimbbizitay borii ixxeez shuchchay, keeth muumer tookkiza kirkiro garkk, ubbapp aadhiz shuchch maaqqeeza. Yhayi Goday ootheez bazi; nu aafayisikka mala bazi› yeeginttii xaafintteezana yi nabbabekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Yeyi gishos, ta yinttis odiza; Xoossa kaatetithay yinttipp ekinttii lo77o aafe aafiz asitayis ingginttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yha shuchchayil afa wodhdhiz ubbitay meqitoda. Ma ye shuchchay ezal afa wodhdhiz athaykka gaacinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Qeese halaqitaynnee Ferisaawitay Yesuusa odeez aaziso fana odeezana ereeza. ");
INSERT INTO mfxl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","U Yesuusa aykkodayis koyeeza, zin asay Yesuusa nabe udii bi7iza gishos asayis yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuusa yhattekka asayis yhay garkk yeegii aaziso odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Salo kaatetithay fa na7ayis bossi makkeez kaata aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ye kaatay boss ye7oay garkk odeez asa xeegodayis fa ayllita azazeeza. Zin asay ye7odayis koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ma hara ayllita xeegii, xeegintteez asitayiko yhanigii, ‹Taanii ta sanggitannee modhdheez mehita shukkeeza; ubba baz giigeeza. Ta bossayiko ye7oytta yeegoytta› yeegii kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Zin xeegintteezitay xeessa ixxii, fa yhanttas yhanttas qiteeza. Pettay fa wootas, yhankkay fa zal7es qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yhankkitay ma kaatay ayllita aykkii, kawushshishi yhadhdhii wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Kaatay iita shenitii, fa wotaaddarita dakkii shemppo wodhizita wodhiseeza, u katamitokka xuuggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yeypp guye, fa ayllitayiko, ‹bossay giigeeza, zin xeegintteezitay bossayis beeziza as baaya. ");
INSERT INTO mfxl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yey gishos, dammo goosa aykkii yhanigii, denggeez as ubbita bossa ye7od garkk xeegoytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ayllitay ogel kezii fa denggeez as ubba lo77itannee iitita ki7ii bossa shaqara gelisii kuntheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Zin kaatay muntta maadayis betteez asa be7adayis gelodar bossi afila ma77ekka pettii as denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eziko, ‹Naat ne bossi afila ma77ekkazar wayizii yhaydda geleenee?› yeegeeza. Zin athay si77e atteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Kaatay fa ayllitayiko, ‹Yha athayis kushannee toka accii, bale dhuma kessii olloytta. Ezayid ezisi yeefonnee achch coonchii maaqqada› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«Yey garkk, Xooss kaatetithayis xeegintteezitay gaame zin dorintteezitay xiqqa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yeypp guye, Ferisaawitay yhanigii, Yesuusa wayizii odar aykkodazako tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Fa tamaaritannee Herodoosa baggitaypp petta petta azazeeza. Unttikka, «Asitamaarayyo, ne turo odizana nu eriza. Neenii asapp as shaakkii erooya, asii waagodee gi abikka oothii erooya, Xooss oge turora taamarissiza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","An nuus odoba, nuunii Oroome Kaatayis giira giirodayis beezinennee beezoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Zin Yesuusa u iita qofa erii, «Yha cubbitayyo, tana abis paaccee? ");
INSERT INTO mfxl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giira giiriza miishito tana beezoytta» yeegeeza. Unttikka ezis Dinnare ki7ii beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","E, «Yha sunthaynnee mallay o bazo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Unttii, «Roome Kaatayis» yeegeeza. Yesuusa unttiko, «Yeezin, Kaatayis beezizana kaatayis, Xoossis beezizana Xoossis inggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","U yeya si7ii mala bazi gi ashshii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ye gallas yhayiqopp denddo baaya yeegiz Saduqaawitay Yesuusako yi7ii, yeegii eza oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Asitamaarayyo, ‹Muse, pettii asii machcho ekkii na7a yelekkazar yhayqqiko, ye yhayqqeezayis ishay e machchato ekkii, fa ishayis na7a yelo› yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu eriza laappun ishitay yeza. Bayray machcho ekkii na7a yelekkazar yhayqqeeza. E machchato e kaalo ishay ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yey garkkekka, ye astto ekkeez nam7anthaykka, hayidzinthaykka, yhanigii laappunitay wurod gatho ubbitay yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ubbapp wurssithal ye asitakka yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yeezin, laappunitay ubbitay izo ekkeez gishos yhayiqopp denddiza gallas, ye astta laappunitaypp aayayis machcho maaqqadee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuusa mahii, «Yi Xooss qaalay taamarsseez baz woy e wolqqa eroowa gishos balinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asay yhayiqoppe denddiza wode salo yez kiitanchchitay garkk maaqqodaypp attin ekkooyannee gelooya. ");
INSERT INTO mfxl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ma yhayqqeez asay yhayiqopp dendod baz Xooss yinttis odeezana yi nabbabekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Xoossay, ‹Taanii Afraame Xooss, Isaaqa Xooss, Yayqqooba Xooss› yeegeeza. Yey gishos, Xoossay pathi yezitay Xoossapp attin yhayqqeezitay Xooss baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gaame asay yeya si7ii, e timirtta malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuusa Saduqaawitayis godbaz dhabiseezana Ferisaawitay si7ii wolla shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","U ganccepp pettii higge asitamaaray Yesuusa paace oychchi oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Asitamaarayyo, higge ubbaypp aadhizay aaya?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuusa mahii, «‹Ne Goda, ne Xoossa, ne kunthi wozinaypp, ne kunthi shemppopp, ne kunthi qofapp qadhdhoba. ");
INSERT INTO mfxl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ubbapp aadhizaynne bayra kiitay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nam77iintho ubbaypp aadhiz kiitay, as ubba ne nena dosizay garkk dosoba› yeegizaya. ");
INSERT INTO mfxl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Muse higgaynnee nabitay timirttay ubbay yha kiititayil afa katiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferisaawitay pettipp shiiqii yeezin, Yesuusa unttan, ");
INSERT INTO mfxl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kiristtoosa bagga yi waagee? E o na7a?» yeegii oyceeza. U, «E Kaata Dawute na7a» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuusa unttiko, «Yeezin, Dawute geeshsha Ayyanar maaqqii wayizii Kiristtoosa, ‹Goda› gi xeegee? Dawute giittar, ");
INSERT INTO mfxl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹Xoossay, ta Godayiko, ne morkkita ne tokayis yedhdhiz aqo oothod gatho, yhaydda taapp ushachchi baggar bettoba› geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yikkee, Dawute Kiristtoosa Goda gi xeegiko, wayizii Kiristtoosa Dawute na7a maaqqee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesuusas pettii qaala mahodayis danda7eez as oonkka baaya. Ma ye gallasapp aykkii hara oyichi oyccodayis oonkka danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yeypp guye, Yesuusa woyasinnee fa tamaaritayis yhay garkke yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Higge asitamaaritaynnee Ferisaawe asay Muse higge tamarisodayis Muse oyidela betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yey gishos, u yinttan azaziza baz ubbita oothoyttannee naagoytta. Zin u oothizay garkke oothippate. Abis giiko, u odizay garkk oothooya. ");
INSERT INTO mfxl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Unttii tookkin dendoowa deexo toofo accii as toossiza. Zin paasi hara attozin, ye toofo asay tookkodar biradhdhe xeerar bochchodayis koyooya. ");
INSERT INTO mfxl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Zin u fa ooso ubba asii be7aday garkk oothiza. Fa sinollannee qeseel acciz maxxaafe xiqise yez kiitappe dalggisiza, fa afila macarakka adussiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mokkinttiza aqo bonchcho aqonne Ayihuditay Woosa keetha gaame lo77iza oyde dosiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asay gabe gancce unttan bonchchor sarothodanannee ‹Asitamaarayyo› gi xeegod garkk koyiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Zin yi asitamaaray pettay aadda maaqqeez gishonnee yi ubbitay e ishita maaqqeez gishos ‹Asitamaarayyo› ginttinttii xeeginttippate. ");
INSERT INTO mfxl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yinttis salo pettii aday aadda yez gishos yha sa7a oonakka ‹adayyo› gi xeegppatte. ");
INSERT INTO mfxl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yinttis pettii Goday Kiristtoosa aadda yeza gishos ‹Goda› ginttinttii xeeginttippate. ");
INSERT INTO mfxl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yinttapp aadhizay yinttis aylle maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Fana dhoqqi udiz oonkka kawuzhoda; fana kawuzhisiza oonkka dhoqqi goda. ");
INSERT INTO mfxl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Yinttanno, cubbittayyo, higge asitamaaritaynnee Ferisaawttayyo, as tiina salo kaatetitha gorddizitayyo yinttan ayye. Yinttii, yi ubbas gelaamii ma yhankkitakka gelsaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Yinttanno cubbitayyo, higge asitamaaritaynnee, Ferisaawttayyo, am7itay keetha yi bonqqittar, asii be7o gi woosa adussiza. Yey gishos, yinttan ayye. Ubbapp aadhiz pirdday yinttan naagiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Yinttanno, cubbittayyo, higge asitamaaritaynnee Ferisaawttayyo, yinttii pettii atha ammanthodayis abarannee sa7ar yuuyiza. Zin yi eza ammantheez wode ye atha yinttipp aathii Gaannames giigsiza ooso oothiza gishos yinttan ayye. ");
INSERT INTO mfxl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Oonkka Xooss Keetha caaqqiko akkokka baaya. Zin Xooss Keetha yez worqqa caaqqiko, ye caaqay ezis gomoda giz to7itayyo, yi ubbas to7ii hara as kaalithizitayyo, yinttan ayye. ");
INSERT INTO mfxl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yinttanno, boozitayyo, to7itayyo, worqqay aadhinenee? Worqqa Xoossayis dummasiza Xooss Keethay aadhee? ");
INSERT INTO mfxl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma ‹Oonkka yarshsho yarshshiza aqo caaqqiko, akkokka baaya. Zin oonkka ezal afa yeza yarshsha caaqqiko, ye caaqay ees gomoda› yeegii taamarssiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yinttanno, tullitayyo to7itayyo, yarshsho aadhinenee? Yarshsho Xoossayis dummasiza aqay aadhee? ");
INSERT INTO mfxl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yey gishos, yarshsho aqayir caaqqiza athay, ye yarshsho bessaaydanne ezal afa yeza ubbabazal caaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xooss Keetha caaqqiza athay, ye Xooss Keeth giddonnee ezayid yeza Xoossa caaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Salo caaqqiza athay Xooss zufaanannee ye zufaanayil afa bettiz Xoossa caaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Yinttanno, cubbitayyo, higge asitamaaritayyonnee Ferisaawttayyo, yinttan ayye. Yi karthi gaallapp, shaashincheppennee booth gaallapp asiraata kessiza. Zin higgayid yez aadhii koshshizita ashshiza: yeykka luule pirdde, qadhdheene ubbabazal ammanintto. Harabazitakka ashshekkazar yhayttita yi oothodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yinttis to7ii hara as kaalithizitayyo, yi ushshapp wununo kessii gimaale mittiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Yinttanno, cubbitayyo, higge asitamaaritayyonnee Ferisaawe assayyo, yinttan ayye. Yi shaatessinnee keres afa bagga geeshshiza. Zin gancce baggay bonqqannee uuzatithii kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Neno to7a Ferisaawayyo, shaatesinnee keres gancce tiina geeshshoba. Yeypp guye, afa baggaykka geeshshii maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Yinttanno, cubbitayyo, higge asitamaaritayyonnee Ferisaawttayyo, yinttan ayye. Afa baggar borshonttor lo77ii, gancce meqqethinnee wooqqeezibaz kumeez duufo aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yey garkkekka, afa baggar asis lo77o aaziza. Zin yi gancce cubbotithinnee iitatithii kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Yinttanno, cubbitayyo, higge asitamaaritayyonnee Ferisaawitayyo, yinttan ayye. Yi nabitayis duufo ginbbiza, ma xillitay duufakka lo7ithiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma yinttii, ‹Nuunii binii nu aditay wode yeza baz maaqqeezako, unttar wolla nabitay suuthi laalamizin› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yey gishos, yi nabita wodhdheez as na7ita maaqqeezana yinttii yi ubbas markkattiza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yeezako, yi aditay aykkeezana yi poloytta. ");
INSERT INTO mfxl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Yha shooshuntho, goppe na7untho, yi Gaanname pirddapp wayizii attodee? ");
INSERT INTO mfxl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yey gishos, ta odizana si7oytta; taanii nabita, eca asitannee asitamaarita yinttiko kiittoda. Unttapp petta petta yi wodhoda mazqqalel afa sottoda. Baggita Ayihuditay Woosa keetha gelissii alangoda katamapp katama bayi7oda. ");
INSERT INTO mfxl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yey gishos, xilla Aabeela wodhdheez wodepp aykkii, Xooss Keethissinnee yarshsho aqopp giddo yi wodhdheez Barakiyu na7a Zakkireesa suuthii hellodar yhayqqeez geesh as ubbay gishos yi seerinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Taanii yinttis turo odiza; yinttinnee yi aditay ootheez buutayis yha pirdda ubbay yha yeletithayil afa helloda. ");
INSERT INTO mfxl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusalaame, Yerusalaame, nabita wodhizannee! Xoossay neeko kiitteezita shuchchar shocizannee! Shugula fa na7ita fa qefer haphphizay garkk taanii ne na7ita ta shiishodayis aappun toke koyennee! Zin tana ne kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yikkee, yi keethay kaysa maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taanii yinttis odiza; ‹Goday sunthar yi7izay anjjintteezaya› yi god gatho yhaypp guye tana yi be7aamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuusa Xooss keethapp kezii yhammadar, e tamaaritay eziko yi7ii, Xooss Keeth gimba beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesuusa unttiko mahii, «Ee! Yhaya ubbita yi bi7inee? Taanii yinttis turo odiza; shuchchi shuchchal afa ginbbintteezay laalinttekkazar attaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuusa Debrezayte amball afa betteezin, e tamaaritay fa aaddas eziko yi7ii, «Yey ayide hanodazako nuus odoba. Ma ne yi7ithayssinnee wode wurssithayis mallay abba?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuusa mahii, «Yinttan oonkka balthaam garkk naaginttoytta! ");
INSERT INTO mfxl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abis giiko, gaame asay ta sunthar, ‹Taanii Kiristtoosa› giittar ta sunthar yi7ii gaame as balithoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Olannee ola baz nashshodar yi si7odayis yeza. Yey hanodayis beeziza gishos hirigipatte. Zin wurssithay haga. ");
INSERT INTO mfxl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Woyay woyara, pettii kaatetithay hara kaatetithar olinttoda. Nayennee biitta eni7o gaame aqo hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yey ubbay yelo iqithi zooke ayithgarkke. ");
INSERT INTO mfxl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ye wode asay yinttan metos aathii immada, wodhoda. Ta sunthay gishos asii ubbay yinttan ixxoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ye wode gaamitay ammano ashshoda. Fa gancce pettay petta aathii immada, pettay petta ixxoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma gaame worddo nabitay denddii gaamita ballithoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wucetithi ganggizay gishos gaame asayis siiqo irxxoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Zin wurssith hellodayis garzhiza athay attoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","As ubbas markka maaqqad garkk Xooss kaatetith Wonggilay biitta ubbayil sabbakinttoda. Yeypp guye, wurssithay ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Yey gishos, nabe Daalene odeez dhabisiza tuna ooso geesh aqo eqqeezana yi be7ada. Nabbabizay akaako! ");
INSERT INTO mfxl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ye wode Yihuda biittal yezitay ambal qosintto. ");
INSERT INTO mfxl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keeth kusittel yez athay fa kara yez baz ekkodayis wodhdhippe. ");
INSERT INTO mfxl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gade oosol yezay fa afila ekkodayis guye maaqqippe. ");
INSERT INTO mfxl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ye aginayid wodeth maachitayisnnee ammisiza maachchitayis iita metto maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yi qosinttay Barigor woy Maala gallas maaqqaam garkk Xoossa woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Abis giiko, sa7a medhintteezaypp yhayino hellodays hanekka baz, ma tiinassikka yesha hanaam meto ye wode hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ye gallasitay payida haatisekkazako asho ma7eez oonkka attaamii. Zin E fa dooreez asay gishos ye gallasitay payida haatithoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Ye wode oonkka yinttan, ‹Yhayishshee, Kiristtoosa yhaydda› woy ‹Sendaydda yeza› yeegiko ammanppatte. ");
INSERT INTO mfxl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Abis giiko, worddo Kiristtoositayirannee worddo nabitayira dendoda. Unttis danda7inttiko, hara attozin Xoossii dooreezitakka balithod hellodayis mallannee malabaz beezoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akaakoytta, taanii yinttis yhaya tiinatii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Yey gishos, asay yinttiko, ‹Kiristtoosa liizho yeza› giiko, ize yhanigppatte, woy yinttiko, ‹Qol7a yeza› giiko, ammanippatte. ");
INSERT INTO mfxl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Abis giiko, zeelinthii salo zeellinggii, awa kessapp awa gelo hellodayis benttizaygarkk, Asii Na7a yi7ithay yhayigarkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«Gawuxa yeza aqo ankko shiiqoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ye wode ye meto gallasitaypp guye, elle awa dhumoda, agina fa poo7o kayoda. Xoolinttitay salopp wodhdhoda, ma salo yez wolqqitaykka buqinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ye wode As Na7a mallay salol afa benttoda. Sa7a yez as ubbay yeekkoda. Ma As Na7ay, wolqqarannee gita bonchchor salo shaara ganccer ye7odar unttii be7ada. ");
INSERT INTO mfxl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","E fa kiitanchchita puggiza damma tulitular kiittoda. U sa7a oyddii zooze yhanigii, gaxapp gaxa hellodayis yez eesi doorintteezita shiishoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Belese mithapp tamaaroytta. I xeeray ciizhiko hayitay aaco aykkiko bone ukkeezana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yey garkkekka, yi yha ubba be7adar As na7ay yi7iza woday peenggel yezana eroytta. ");
INSERT INTO mfxl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taanii yinttis turo odiza; yha ubba bazay polinttod hellodayis, yha yeletithay aadhamii. ");
INSERT INTO mfxl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Salonnee sa7ay aadhoda, zin ta qaalay aadham. ");
INSERT INTO mfxl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ye gallasatinnee ye saatatii bagga salo yez ta adaypp attin hara salo kiitanchchita maaqqin woy Na7a maaqqin oonkka erooya. ");
INSERT INTO mfxl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","As Na7a yi7ithay, Nohe wode haneezay garkk maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ye agintte dhabo haathay ye7odaypp tiina Nohe markkabe gancce gelod hellodayis, asay miitarannee uzhittar, ekkittarannee gelttar gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dhabo haathay yi7ii, unttan ubba dhabisod hellodayis akaakekaya. As Na7a yi7ithaykka yhay garkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Ye wode nam77ii asay gade gancce oothoda. Unttapp pettay ekkinttoda, yhankkay attoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nam77ii maachchitay wolla gaaccoda. Unttapp pettat ekkinttoda yhankkat attoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Yikkee, yi Goday aba gallas ye7odazako eroowa gishos miinggii naagoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Zin kayzo qammapp aappun saatel ye7odazako kara aday erizako, fa kara bookinttamay garkk barkk naagodazin. ");
INSERT INTO mfxl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yey garkk, As Na7ay yi qoppekka saate ye7od gishos yinttikka giiginttii yezoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Yeezin, fa kara asayis katha beeziza woder immad garkk e goday dooreez ammanthizaynnee wozinaama ayllay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","E fa goday azazeezana oothodar e goday yi7ii denggiza ayllay anjjintteezaya. ");
INSERT INTO mfxl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taanii yinttis turo odiza; goday ye aylla fabaz ubbayil afa shuumoda. ");
INSERT INTO mfxl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iita ayllay, ‹Ta goday gam7ii ye7oda› yeegii fa wozinar qoppii, ");
INSERT INTO mfxl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","fa ooso laggita yhadho aykkiko, mathizitayira miikonnee uzhiko, ");
INSERT INTO mfxl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ye ayllay goday E qoppekka gallasnnee E erekka saater, ");
INSERT INTO mfxl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","yi7ii eza nam77ii kessii phalqqoda. E anjakka cubbittayir udoda. Ezayid eesi yeefonnee achch coonch maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ye wode salo kaatetithay fa kuraaze aykkii, machcho ko7odayis yhanigeez atha mokkodayis kezeez taphphii wudirita aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Unttapp ichchinitay boozita, ichchinitay ecita. ");
INSERT INTO mfxl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Boozitay kuraaze aykkeeza, zin hara lamba aykkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Zin ecitay fa kuraazannee hara gujjo lamba aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Machcho ekkiza athay gam7in, ye wudiritay unttan gentta aykkin gentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Giddii bilahe maaqqodar ‹Machchato ekkizay ye7eeza, eza mokkodayis kezoytta› yeegiz gita cabbotith sintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Ye wode ye wudiritay ubbitay barkkii, fa kuraaza giigiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Boozitay ecitayko, ‹Nu xomppay to7od haniza gishos yi lambaypp nuusi inggoytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«Zin ecitay unttiko mahii, ‹Yey hanaamii, nuusinnee yinttis gidiza lamba baaya. Yey gishos, yinttis yhanigii wonggii ekkoytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Boozo wudiritay lamba woonggodayis qiteezin, machchat ekkiza athay putti geeza. Giiginttii betteez ichchin wudiritay ezar wolla bossa sibirel geleeza; pengaykka gorddintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Guyepp yhankko wudiritay yi7ii, ‹Godayyo, Godayyo, nuusi dooyooyee› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Zin E unttiko mahii, ‹Taanii yinttis turo odiza; ta yinttan erooya!› ");
INSERT INTO mfxl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Yikkee, As Na7ay ye7od gallasa woy saata yi eroowa gishos barkkii naagoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Xooss kaatetithay fa ayllita xeegii faasi yeza baz unttis hadarii oge yhammadayis kezeez atha aaziza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Unttis ommar ommar u wolqqay garkk pettayis ichchin mekilite, pettayis nam77ii mekilite ma pettayis pettii mekilite inggii hara gade qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ichchin mekilite ekkeez ayllay elle yhanigii zal7i, hara ichchin mekilite tirppiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yey garkkekka, ma nam77ii mekilite ekkeez ayllay hara nam77ii mekilite tirppiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Zin pettii mekilite ekkeezay yhanigii, olla bookkii, fa goday miisha moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Gaame wodepp guye ye ayllitay goday yi7ii, fa miisha unttan oyicceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ichchin mekilite ekkeez ayllay yi7ii, hara ichchin mekilite ki7ii, ‹Ta godayyo, ne taassi ichchin mekilite inggeeza. Zin ta hara ichchin mekilite tirppiseeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","E goday, ‹Zambay! Neenii lo77o ammanthiza aylle; neenii xiqqa bazal ammantteeza. Taanii nena gaame bazal shuumoda; yhana ne goday ufayssayid geloba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Ma nam77ii mekilite ekkeezay yi7ii, ‹Ta godayyo, neenii taas nam77ii mekilite inggeeza. Zin taanii hara nam77ii mekilite tirppiseeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","E goday, ‹Zambay! Neenii lo77o ammanthiza aylle; neenii xiqqa bazal ammantteeza. Taanii nena gaame bazal shuumoda; yhana ne goday ufayssayid geloba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Ma pettii mekilite ekkeezay yi7ii, ‹Ta godayyo, neenii zerekka aqopp buuciz laalekka aqopp maxiz iita as maaqqeezana taanii eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ta Yashittii ne mekilita biitta gancce moogeeza. Ne mekilita yhayshe› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«E goday mahii, ‹Yha iita azaalla ayllayyo, taanii zerekka aqopp buucizannee laalekka aqopp maxiza as maaqqeeza ne erinee. ");
INSERT INTO mfxl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yikkee, neenii ta miishito bankke gaddeezako wodher ekkodanno ne kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yey gishos, miisha eep ekkii, taphphii mekilite yezayis inggoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Abis giiko, yeza ubbayis gujinttoda gaanggoda. Zin baazaypp hara attozin, ye ezis yeza xiqqatakka ekkinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yha maaddoowa aylla bale dhuma kessii oloytta. Ezayid ezis yeefonnee achch coonchii maaqqada› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«As Na7ay, kiitanchcho ubbitayira, fa bonchchor ye7i E fa bonchcho kaatetith zufaanayil afa bettoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","As kochch ubbitay e tiina shiiqoda. Heenggiz na7ay durta deeshitaypp qurizay garkk E ye asa nam77ii aqo shagoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Durta ushachchi baggar deeshita haddirs baggar essoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Ye wode, kaatay ushachchi baggar yezitayko yhay garkk yeegoda: ‹Ta Aday anjjeezitayyo, yhana yi7ii sa7a medhintteezaypp aykkii yinttis giigeez kaatetitha laattoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Abis giiko, taanii nayinttin yi ta muzeeza, saaminttin ushsheeza, imath maaqqii yhanigin mokkeeza, ");
INSERT INTO mfxl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kallottin ma7iseeza, hargginttin oyiceeza, acinttin tana yi be7eeza› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Yeypp guye, xillitay mahii, ‹Godayyo, neenii nayinttin ayde bi7ii nena nu muzeenee? Woy neenii saaminttin ayde bi7ii nena nu ushsheennee? ");
INSERT INTO mfxl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Neenii imath maaqqii yi7in ayde bi7ii nena nu mokkennee? Woy neenii kallottin ayde nena nu ma7iseenee? ");
INSERT INTO mfxl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Neenii hargginttin woy acinttin neeko yhanigii ayde nena nu oyceennee?› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaatay mahii, ‹Taanii yinttis turo odiza; yinttii tana kaalliza yha ubbaypp xiqqiza ishitaypp pettayis ootheezana taas ootheeza› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ye wode haddiris baggar yezitayiko, ‹Yha baaddintteezitayyo, ta lanqqaypp haakkoytta. Xalahesinnee e kiitanchchitayis giigeez medhina tama gancce yhanigoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Abis giiko, nayinttin tana yi muzekkaya; saaminttin tana yi ushshekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Taanii imath maaqqii yhanigin tana yi mokkekkaya, kallottin ma7isekkaya, harggin acinttin tana oycekkaya› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Ye wode unttii, ‹Godayyo, neenii nayinttin woy saaminttin woy imath maaqqii yhanigin woy kalladhin woy hargginttin woy acinttin bi7ii nena ayide maaddam ixxeenee?› yeegii mahoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ye wode kaatay mahii unttiko, ‹Taanii yinttis turo odiza; yinttii tana kaalliza yha ubbapp xiqqizitaypp petta maaddam ixxeezay, tana maaddam ixxeeza› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yey gishos, ye asay medhina pirddes ma xillitay medhina de7os yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuusa yha timirtta ubba wursseezaypp fa tamaaritayko, ");
INSERT INTO mfxl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Nam77ii gallasapp guye, Paaziqa Baale bonchchiza gallas maaqqizana yi eriza. Ye gallas As Na7ay mazqalel afa sotinttodayis as kushe aadhii inginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ye wode qeese halaqitaynnee gade cimitay, Qayyaafa giz qeese halaqay kara shiiqii, ");
INSERT INTO mfxl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","asii erekkazin Yesuusa aykkii, wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Zin unttii, «Asay cabotaamay garkk gi, Paaziqa bonchchiza gallas yeya oothaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuusa Bitaana katama gancce borqqontto hargger yez Simoona kara yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesuusa muntttal yezin pettii astta albasxirosa bilggaaxe kunthi gaame al7o shitto ekkii yi7ii Yesuusa ommayil qoleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zin Yesuusa tamaaritay yeya bi7ii kacinttii, «Yha shitta cere iissizay abiso? ");
INSERT INTO mfxl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yha shittay al7o waagar bayizinttii, miishay manqqitayis ingginttodayis danda7inttizazin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuusa unttii geezana erii, unttiko, «Yha astto abis waaythe? Iza taasi lo77o baz ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Manqqitay ubba wode yinttar yezoda. Zin taanii yinttar ubba wode yezaamii. ");
INSERT INTO mfxl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iza yha shitta taal afa qoleezay tana moogos giigiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taanii yinttis turo odiza; biitta ubbayil yha Wonggilay sabbakinttiza aqo abamaaqqikokka, asay izis qoppiso maaqqaday garkk odinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ye wode taphpho nam77ii Yesuusa tamaaritaypp pettay, Asiqorontto Yihuda ginttinttizay qeese halaqitayiko, ");
INSERT INTO mfxl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yhanigii, «Taanii yinttis Yesuusa aathii inggiko, yi taasi ab immadee?» yeegii unttan oyceeza. Unttii tobbii hasttam bira inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yeypp guye, Yihuda Yesuusa aathii immadayis giiga gallas koyiza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Boora Baale bonchchiza tiina gallas, Yesuusa tamaaritay eziko yi7ii, «Paaziqa bonchchiza gallas neenii maad katha nuunii aba makko?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesuusa unttiko, «Katama yi gelodar helleez athayiko yhanigii, ‹Asitamaaray, taas wode helleez gisho ta tamaaritayir Paaziqa bonchchiza gallasa ne kara aathoda yeegeeza› goytta» geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E tamaaritay Yesuusa kiiteezay garkk udii, Paaziqa Baale gallas maad katha giigiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa7ay omathodar Yesuusa taphpho nam77ii hawaaritayir katha maadayis betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","U maadar, Yesuusa unttiko, «Taanii yinttis turo odiza; yinttapp pettay tana aathii immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","U iita dagamii, ommar ommar, «Godayyo, turo tanashsha?» gi eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuusa mahii, «Fa kusha taar wolla fil7o gancce dakkizay E tana aathii immada. ");
INSERT INTO mfxl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","As Na7ay, Xooss qaalayid ezis xaafintteezay garkk yhayqqoda. Zin As Na7a aathii inggiza atha ayye; ye athay yelinttekka atteezako ezisi lo77ozin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eza aathii immadayis yez Yihuda mahii, «Asitamaarayyo, ne gizay tanannee?» yeegeeza. Yesuusa mahii, «Ne geezaygarkk» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Unttii maadar, Yesuusa boora ekkii Xoossa galateeza. Ye boora baxxii fa tamaaritayis inggii, «Yhashittee, moytta, yhayi ta asho» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xuu7a ekkii, Xoossa galateeza. Unttis inggii, «Ubbay yhaypp uzhoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yhayi gaame asay nagaray atto inttinttoday garkk gogiz oroth ta caaqo suuthii. ");
INSERT INTO mfxl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Zin taanii yinttis odiza; taanii ta Aday kaatetititha oroth woyne ushsh yinttar uzhod gallasa hellodayis yhannipp gede yha woyne ushsha uzhaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Galata mazmuure yexxeezaypp guye Debre zayite ambal qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ye wode Yesuusa unttiko, «‹Xoossay heenggizana shocoda duritaykka laalinttoda› ginttinttii Xooss qaalayid xaafintteezay garkk yhayino qamma yi ubbitay taal dhubinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Zin taanii yhayiqopp denddeezaypp guye yinttipp tiinatii Galila yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phixiroosa mahii, «Unttii ubbay nena ashshii dhabikokka, taanii nena ashshaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuusa Phixiroosako, «Taanii nees turo odiza; yhayino qamma shugula uukkodaypp tiina neenii tana hayidzii toke kaddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phixiroosa mahii, «Taanii neer wolla yhayiqopp attin nena yesha kaddamii» yeegeeza. Yhankko e tamaarttay ubbitaykka yhay garkk geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ezaypp guye, Yesuusa fa tamaaritayir Geetesemaane giz aqo yhanigii, unttiko, «Taanii sendayid yhanigii Xooss woossoda, yi yhaydda bettoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Phixiroosannee Zabidoosa na7a nam7ita paar ekkii yhanigii azanonnee yilo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Maakka unttiko, «Taanii yhayqqod hellodayis azzaneeza. Yhaydda gam7oyttannee barkkii naagoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Xiqqa tiinal yhanigii biittal fa sinayir xuggunii, «Ta adayyo, danda7inttiza baz maaqqiko yha meto xuu7ay taapp aadho. Zin ne shene hanopp attin ta shenay hanppe» yeegii Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesuusa fa tamaaritayiko maaqqii yi7ii unttii gentteezin denggii, Phixiroosako, «yinttii pettii saatezakkonnee genttekkazar taar minggodayis danda7ekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Paace gancce yi gelaamay garkk barkkii naagoyttannee Xoossa woossoytta. Ayyanay ingginttii yezin asho daabureeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuusa ma nam7intho yhanigii woossii, «Ta adayyo, taanii yha meto xuu7aypp uzhekazin aadhodayis danda7inttoowa baz maaqqiko ne shenay hano» yeegii Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Maakka maaqqii ye7odar e tamaaritay gentta gamin, woyi7eezin denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Maakka unttan ashshii yhanigii, tiina geez qaalato izo mahii hayidzintho woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yeypp guye, fa tamaaritayiko yi7ii, «yhanno hellodayis genttallannee shemppol yenee? yikkee genttoytta. Yikkee, As Na7ay, nagara oothizittay kushe aadhii ingginttiza saatay helleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Denddii yedhdhoytta, tana aathii inggizay yhayishshee helleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuusa haga yeya odinttodar, taphpho nam7i tamaaritaypp pettay, Yihuda ye7eeza. Qeese halaqitaynnee gade cimitay kiitteez gaame asay mashshannee gufe aykkeezittay ezar wolla ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuusa aathii inggiz Yihuda ye gaame asayiko, «Taanii yeerizay yi koyizay eza, eza aykkoytta» yeegii malla inggii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ellisii Yesuusako shiiqii, «Asitamaarayyo, saro nees maaqqo» yeegii eza yeereeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuusa eziko, «Ta dabbayyo, neenii abis ye7eenee» yeegeeza. Yeypp guye, shiiqii, fa kusha Yesuusal gaddii aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuusar yezitaypp pettay fa mashsha shoddii qeese halaqay aylla shocii, e haya gachchii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zin Yesuusa, «Ne mashsha guye shookayid mahoba. Abis giiko, mashsha shoddiz ubbitay mashshar yhayqqoda. ");
INSERT INTO mfxl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ta, ta Adana woossizako gaame mukulo payidinttiz kiitanchchita dakkodayis danda7oowa baz neess aazinnee? ");
INSERT INTO mfxl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yeya maaqqiko, Xoossa qaalayid yhay garkk hanodayis beeziza ginttinttizay wayizii polinttode?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ye saatte, Yesuusa ye shiiqeez gaame woyayiko, «Tana paanno mahii aykkodayis mashshannee gufe aykkii ye7eenee? Taanii Xooss Keetha gallas gallas taamaristtar yinttar yez wode yi tana aykkibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Zin yhay ubbay haneezay nabitay Xooss qaalayid xaafeezay polinttoday garkke» yeegeeza. Ye wode e tamaaritay ubbitay eza ashshii qosintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesuusa aykkeezitay qeese halaqa Qayyaafa eza kanggeeza. Ezayid higge asitamaaritaynnee biitta cimitay shiiqii yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Zin Phixiroosa qeese halaqay zabba hellodayis haakor eza kaalleeza. E wurssitha be7adayis zabba gelii naagiztayir betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Qeese halaqitaynnee shiiqeez as ubbitay Yesuusa wodhodayis ezal afa worddo markka koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gaamitay yi7ii ezal afa worddo markka markkatteeza, zin abikka denggekkaya. Guyepp nam77ii asay yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Yha athay, ‹Taanii Xoossa Keeth laalii hayidzii gallasar mahii keexxodayis danda7iza› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Qeesitay halaqay denddii eqqii Yesuusako, «yhayititay nena mootiza mootayis neenii mahizbaz baasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Zin Yesuusa si77i atteeza. Maakka qeese halaqay, «Taanii nena de7o Xoossa sunthar aykkiza; neenii Xoossa Na7a Kiristtoosa maaqqiko nuus odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuusa mahii, «Yeya ne geeza. Zin taanii yinttis odiza; yhaypp guye, As Na7ay wolqqama Xoossa ushachch baggar betteezin, salo shaarar ye7odar yi be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ye wode qeese halaqay fa afila peedhii, «Yhaya bo7oytta Xooss cazheeza! Nuna hara markka ab koshshee? E yhatti cazheezana yi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yi qofay abba?» yeegeeza. Unttikka, «Ezis yhayiqo beeziza» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ye wode, u e sinayid cuttii zhultteeza, yhankkitay eza baqqii, ");
INSERT INTO mfxl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Kiristtoosa! Nena shoceezay oonoo? An nuus tinbbite odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phixiroosa zabbayid betteezin, pettii gadhindata eziko yi7ii, «Neekka Galila Yesuusar wolla yeza baasa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Zin E u ubbitay tiina ye gadhindatiko, «Ne giz bazay abizako ta erooya» yeegii kaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma yhanigii gase pengeko hellodar yhankkat eza bi7ii, ize yeza asayiko, «Yha athay Naazirete Yesuusar yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Phixiroosakka nam7intho caaqqii, «Taanii ye aththa erooya!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Xiqqa gam7odar, ize eqqeez asay Phixiroosako yi7ii, «Neekka turo unttar wolla yeza bay; neenii ne nashshayir erinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yeypp guye, Phixiroosa, «Taanii ye atha erooya!» yeegii, fana baadithinnee caaqo aykkeeza. Ye wode izir shugula uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesuusa eziko, «Neenii shugula uukodaypp tiina tana hayidzii toke kaddoda» geezana Phixiroosas elqqi gin, bale kezii dukka suuthth yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wontta guura qeese halaqitaynnee gade cimitay ubbitay Yesuusana wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Unttii Yesuusa accii kanggii gade aqisiz Philaaxoosas aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ye wode Yesuusana aytheez Yihuda, Philaaxoosa Yesuusal afa pirddeezana bi7ii, qiirattii, ye hasttam bira qeese halaqitayisnnee gade cimitayis guye maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Taanii geeshsh as yhayiqosi aathii inggii nagara ootheeza» yeegeeza. Zin unttii, «Yey nu meto baaya ne meto» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yihuda mishitto Xooss Keetha olii ashshii u lanqqaypp yhanigii, sotinttii yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Qeese halaqitay miisha ekkii, «Yha miishay suuth miishe maaqqeez gishos nuunii Xooss Kara miisher walakkodayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yeypp guye, wolla tobbii, bete as moogodayis zhiice biitta wonggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yey gishos, ye gaday yhayino hellodayis suuth biitta ginttinttii xeeginttiza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ye wode Nabe Erimaasa geezay garkk «Isreele na7itay wachcheez e gata hasttam bira ekkeeza ");
INSERT INTO mfxl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Goday tana azazeezay garkk zhiice biitta woongodayis inggeeza» geezay ye wode polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuusa gade aqisiza Philaaxoosa tiina shiiqin, Philaaxoosa eziko, «Neenii Ayihude kaato» yeegii oyceeza. Yesuusa mahii, «Ne geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Qeese halaqitaynnee gade cimitay eza mootodar unttis aba maalssekka mahekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ye wode Philaaxoosa Yesuusako, «Yhayititay nena mootiza moota ubba ne si7oosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesuusa hara attozin, pettii qaalakka mahaam ixxin, gade aqisizay yhay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gade aqisizay laytha laytha Paaziqa Baale bonchchiza gallas, woyay koyiz pettii as achchapp bili7iz woga yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ye wode pettii Bairbaana giz daafar erintteez iita athay achch keetha yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yey gishos, gaame as shiiqii yeezin Philaaxoosa, «Taanii yinttis Bairbaana, billone Yesuusa giz Kiristtoosana bili7o?» yeegii woya oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","E yeya geezay u qinaattii Yesuusa aathii inggeezana eriza gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Philaaxoosa pirdde kara betteezin, e machchat, «Taanii yhayino qamma abukkar E bagga undenna waayttar aqeez gishos ye geeshsh athayil afa ababazkka oothippe» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Zin qeese halaqitaynnee gade cimitay Philaaxoosa Bairbaana bili7ii, Yesuusa wodhod garkk, woyay eza woossod garkk, woya doosheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Philaaxoosa mahii unttiko, «Taanii u nam7aypp yinttis oona billod garkk koyinee?» yeegii oyceeza. U, «Baribaana billod garkk nu koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philaaxoosa, «Yeezin, Yesuusa giz Kiristtoosa ab udo?» yeegii unttan oyceeza. Ubbay mahii, «Sottintto» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philaaxoosa woyayiko, «Abiso? E ab iitta baz ootheenee?» yeegii oyceeza. Zin asay tiinaasaypp aathii, «Mazqqalel afa eza sottoba» gi uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Philaaxoosa cabbo denthithopp hara ababazkka oothodayis danda7inttaamiza bi7ii, wursii haath ekkii, «Yha athay yhayiqayid taanii baaya. Yeya oothizay yinttan» yeegii woya tiina fa kushe meecceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","As ubbitay mahii, «E suuthay nuulannee nu na7itayil afa maaqqo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yeezin, Philaaxoosa Bairbaana unttis bili7ii, Yesuusa garaffii, mazqqalel afa sottinttii yhayqqod garkk aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yeypp guye, Philaaxxosa wotaaddaritay Yesuusana gade aqisizay zabba kanggin, wotaaddaritay e kalayid shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","E afila qaarii ekkii zoqo afila ma7iseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma angguth zawude kochchii, e ommayil gaddeeza. E ushachch kushayid shomboqo gufe ayithii, e tiinayid bunqqittii, «Ayihude kaatayyo saro nees maaqqo!» yeegii, ezal afa qaldeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ezal afa cutteeza. Ye shomboqo gufa ekkii, e ommayid shoceeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Unttii ezal afa qalideezaypp guye zoqo afila eepp qaarii ekkii, e afila eza ma7isi Sottodayis ekkii kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Unttii bale kezii, pettii Simoona giz Qerena biitta atha denggii, Yesuusa mazqala wolqqar toosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golggotta giz aqo helleeza. «Golggotta» guussay «Omma Ota aqo» guussii. ");
INSERT INTO mfxl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yeyid u cizher walakintteez woyne ushshii uzho gi ees inggeeza. Zin E yeya ganxxii bi7ii, uzhaam ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Unttii mazqalel afa eza sotteezaypp guye e afila shaakkii, ixa olii ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yeypp guye, ezayid bettii eza naageeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma, «Yhayi Ayihude Kaati Yesuusa» yeegiz e daafa beeziz mooto xuufe e omma achcha gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesuusar ye wode nam77ii paanitaypp petta eep ushachchi baggar, yhankka eep haddirs baggar, mazqalel afa sotteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Oger aadhiz asay fa omma eni7isittar Yesuusa cazhitar, ");
INSERT INTO mfxl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Xooss Kara laalii hayidzii gallas gancce keexxizayyo, nena ashshoba. Neenii Xooss Na7a maaqqiko, ane mazqqalaypp wodhdhoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yey garkkekka, qeese halaqitay, higge asitamaaritaynnee biitta cimitay wolla Yesuusal afa qaldeeza. Yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Hara asa ashsheeza, zin fana ashshodayis danda7ekkaya. E Isreele kaat maaqqiko, ane mazqqalaypp yhatti wodho, nuukka eza ammanoda. ");
INSERT INTO mfxl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xoossal E ammaninttiza, Xoossay eza ashshodayis koyko ane ashsho. Abis giiko, E fana, ‹Taanii Xooss Na7a› giza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma hara attozin, ezar mazqqalel afa sottintteez paanitaypp pettay yhay garkk gi ezal afa qaldeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Usuppun saatepp yhanigii, uddufun saate hellodayis biitta ubbay dhumeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Uddufun saate maaqqeezan garkk Yesuusa, «Elohee, Elohee, laama sabaqitanii?» gi gita uufo uukkeeza. «Elohee, Elohee, laama sabaqitanii?» guusayis birshshithay «Ta Xoossayyo, ta Xoossayyo, tana abis ashsharee?» guussii. ");
INSERT INTO mfxl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ezayid eqqeez asaypp pettay pettay yeya si7ii, «Yha athay Eelaasa xeegiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Izir unttapp pettay woxxii yhanigii, zanzar caala woyne ushsh ekkii. Yeya shomboqo gufe xeeral gaddii ushshodayis e doonayiko ukkitheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Zin yhankkitay, «Ashshoytta, Eelaasa eza ashshodayis ye7odazako ane wolla be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuusa nam7intho gita uufo uukkii, yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ye saatayid Xooss Kara soxintteez magarazhay woko xeerapp yeko xeera hellodayis nam7i kezii, per7inttii wodhdheeza. Biitta eni7eeza, zaallitaykka phalqqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Duufitay dooyinttin Geesh asitaypp gaamitay yhayiqopp dendeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesuusa yhayiqopp dendeezaypp guye Unttii duufopp kezii, Geesh katama qiteeza; ezayid undenna asayis bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mato halaqaynnee ezar Yesuusa naagiza wotaaddaritay biittay eni7eezannee aqayid haneezibaza be7eez wode gaame yashittii «Tuma yhay Xooss Na7a» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yeyid gaame maachchitay, Galilapp aykkii Yesuusa maaddittar kaalleezittay haakor eqqii bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","U gancce Magdeela Mayirama, Yayqqobaranee Yooseefa indat Maaraamannee Zabdoosa na7itay indat yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa7a lem7ilem7odar Yooseefa giz pettii dure athay, Armataasa katamapp ye7eeza. E fa ubbaskka Yesuusa kaaliza asii. ");
INSERT INTO mfxl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yooseefa Philaaxoosako yhanigii, Yesuusa aha ekkodayis woosseeza. Philaaxoosa ahay Yooseefas ingginttod garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yesuusa aha ekkii, geesh afilar sawaxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Shuchchapp wooceez oroth duufo gancce aha gaddeeza. Ma ye duufay doonayid damma shuchch goli7isii gaddii qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdeela Maaramira yhankko Maarama ye duufayiko maaqqii betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wonttitha maala gallas, qeese halaqitaynnee Ferisaawitay Philaaxoosako yi7ii, yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Godayyo, yha balithizay pathi yezar, ‹Taanii hayidzii gallasapp guye yhayiqopp dendoda› yeegeezay nuus elqqi geeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yey gishos, E moogintteez duufa hayidzii gallas hellodayis, miinthii naagod garkk azazooba. Yey hanaam ixxiko, e tamaaritay yhanigii e aha kastti dhabisii, ‹yhayiqopp dendeeza› yeegii woyayis odiko nam7intho balithay tiinaasaypp ubba yhana iitoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philaaxoosa unttiko, «Yinttis naagizitay yeza; yhanigii yinttis danda7intteezay garkk naagisoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yey gishos, unttii yhanigii duufay bochinttamay garkk shuchchayil afa maatame attaamii wotadarttayir wolla gorddii naagiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Maala gallasay aadheez Wogga wode guura, Magdeela Mayiramira yhankko Mayrama Yesuusa moogintteez duufa be7adayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Qoppekka wolqqama biitta eni7o haneeza. Goday kiitanchchay salopp wodhdhii duufay doonayil yez shuchcha goli7isii ezal afa betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","E ciray zeellinthi aaziza. E afilaykka shachchigarkk boothi. ");
INSERT INTO mfxl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naagizitay kiitanchcha bi7ii, yashshar kukkurii, yhayqqeez asgarkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kiitanchchay maachitayiko, «Yashittippate yi mazqalel afa sotintteez Yesuusa koyizana ta eriza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E tiin odeezay garkk yhayiqopp dendeeza; yhaydda baaya. Yhana yi7ii eza woytheez aqa bo7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yi yhatti ellisii yhanigii, e tamaaritayis, ‹Yesuusa yhayiqopp dendeeza. Ma E yinttipp tiinattii Galila yhammada; yi eza ezayid be7ada› yeegii odoytta. Taanii yinttis yhaya ododayis ye7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Unttii yashittittarannee gaame ufayttittar, duufay lanqqaypp ellisii yhanigii, e tamaaritayis ododayis woxxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Qoppekkazin Yesuusa unttar woli hellii unttiko, «Saro yinttis maaqqo» yeegeeza. Unttii eziko shiiqii, e toka aykkii ezis goynneeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ye wode Yesuusa unttiko, «Yashittippate; yhanigii ta tamaaritay Galila yhammadgarkk unttis odoytta. U ezayid tana be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ye maachchitay yhammadar, duufa naagiza wotaaddartaypp baggitay katama yhanigii, haneezibaza ubbita qeese halaqitayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Qeese halaqitaynnee cimitay shiiqii tobbii, wotaaddartayis gaame miishe inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«‹Nuunii gentteezin e tamaaritay qamma yi7ii, e aha kasiteeza› yeegoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yha oda gade aqisizay si7iko, yey yi buuta baza nuunii eza odii ammanthoda. Yinttan abikka hirigisppe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wotaaddartay miishe ekkii, kiitintteezaygarkk udeeza. Yha oday Ayihuditay kale yhayino hellodayis odinttitar yeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taphpho pettii e tamaarttay Yesuusa unttan yhanigoytta geez Galila Derell afa yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ezayid unttii eza be7eez wode ezisi goynneeza, zin unttapp pettay pettay sidheeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuusa unttiko shiiqii, «Salonnee sa7a mawute ubbay taas inggintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yikkee, yinttii ubba aqo yhanigii, wongila sabbakkii tana kaallizita mahoytta, Ada, Na7a, geeshsha Ayyana sunthar woya ubba xammaqoytta. ");
INSERT INTO mfxl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taanii yinttan azazeeza ubba u naagod garkk taamarssoytta. Taanii wode wursith hellodayis ubba wode ta yinttar yeza» yeegeeza.");
INSERT INTO mfxl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yhay Xooss Na7a Yesuus Kiristtoosa Wongile aythi ");
INSERT INTO mfxl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nabe Isayaasa xaafeez maxaafay gancce Xoossay, «Yeezako, taanii ta kiita na7a neep tiina dakkoda. E ne oga pixxoda. ");
INSERT INTO mfxl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pettay liizho gadhar uukkii odittar, ‹Godayis oge pixxoytta; E yedhdhodayis goosse ezis luulisoytta geeza» giinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xammaqiza Waannisa asa xammaqqittar, «Yi nagaraypp maaqqii xammaqinttoytta; Xoossay yi nagara yinttis atto goda» yeegii qaala odittar liizho gadhapp ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yihuda biitta yez as ubbitayinnee Yerusalaame katama as ubbitay Waannisako yi7iza. Fa nagara buuxin, Waannisa unttan Yorddanoose borkka xammaqiza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Waannisa gimaale ikisepp dadintteez afila ma77iza. Fa xeessayid dafe dancciza; ma boolerannee degera eessara miiza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Waannisa qaala odittar, «Taapp guyer loythii miinggizay yi7iza. Hara attozin, ta E caamma wodora zuggii billodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ta yinttan haathar xammaqiza, zin E yinttan geeshsha Ayyanar xammaqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yesuusa ye wode Galila biitta yez Naazirete katamapp yi7in, Waannisa Yorddanoose borkka eza xammaqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesuusa haathapp kezeezan garkk salo dooyinttin, geeshsha Ayyanay ezal afa holle garkk wodhdhodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Maakka, «Ta qadhdhiza ta na7ay nena; ta neell ufayttiza» yeegiz girithii salopp ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Izir geeshsha Ayyanay Yesuusa liizho gadha kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesuusa liizho gadha xalaher paacinttittar oyttam gallas gam7eeza. Do7itayir yezeeza, zin kiitanchchitay yi7ii eza maaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waannisa acintteezaypp guye Yesuusa Xooss kaatetith Wonggile odittar Galila biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Layithay helleeza; Xooss kaatetithay ukkeeza. Yi nagaraypp maaqqii, Wongila ammanoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuusa Galila Abba lanqqer aadhittar, molo aykkiz, Simoonarannee E isha Indiraasera, fa gite abbal afa olizita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Unttiko, «Tana kaalloytta; ta yinttan ase aykkith tamarssoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Unttikka izir fa gitita olii ashshii Yesuusana kaalo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Izipp xiqqal tiin yhanigii, nam77ii ishita Zabdoosa na7ita, Yayqqoobarannee Waannisara wogolo gancce fa gite lo7ithizita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesuusa ellisii unttan xeegeeza. Unttikka fa ada Zabdoosa, e ooso asitayir wogolo gancce olii ashshii eza kaallii yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Unttii qifirnahoome katama geleeza. Maala gallas helleezan garkk Yesuusa ellisii Ayihude Woosa keethi gelii taamarsso aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mawuter yez as garkk tamarssizap attin higge asitamaaritay garkk tamarssoowa gishos asay E timirtta yhay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ye wode tuna ayyana aykkeez pettii athay Ayihuditay Woosa keeth gelii uukkii, ");
INSERT INTO mfxl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Naazirete Yesuusa, neerannee nuur aba allalle yenee? Nuna dhabisodayis ye7eenee? Ne oonozako ta eriza; ne Xoossa Geeshsh» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuusa ya tuna ayyana, «Hayizoba, yha athaypp kezoba» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuna ayyanay atha zardizard udii, xilasii uukkii ezapp kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asay ubbay malabaz gi, «Yhay abba? yha athay fa mawuter hara attozin tuna ayyanitakka azaziza. Unttikka ees azazinttiza; yhay aba oroth timirtte?» yeegii, fa ganccer pettay pettay woli oychch aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesuusa Waaray ellisii Galila awurajja yez heera ubba kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuusa ye wode Ayihuditay Woosa keethapp kezii, Yayqqoobara Waannisara Simoona karannee Indiraase kara geleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoona machchatii indat oxe misha harger woy7ii yezin Yesuusa ize hellin ezisi odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","E izko shiiqii, I kusha aykkii, izo denthii esseeza. Oxe misha hargay ellisii izo dakkin iza unttan mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hargintteez asa ubbitannee tuna ayyanitay aykkeez asa ubba omathi awa gelii lemi7ilem7odar eziko ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katama yez as ubbay yi7ii keethayis bale shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuusa duma duma harger aykintteez gaame asita pathii, gaame tuna ayyanita kesseeza. E oonozako tuna ayyanitay ereeza. Zin Yesuusa unttan nashshoda kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuusa Zhabaro dendii, asii baa aqo woossodayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoonarannee ezar yezitay eza koyttar yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Unttii eza denggii, «Asay ubbitay nena koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuusa ma unttan, «Hara aqo ukke heerita yedhdhoytta. Ta ye7eezay Wonggile ododayis maaqqeez gishos ezayddakka qaala ododayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayihuditay Woosa keethitayid qaala odittar, tuna ayyanita kessittar, Galila biitta ubba wuteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Borqqontto harge aykkeez pettii athay Yesuusako yi7ii, E tiinayid xuggunii, «Ne qadhdhiko tana geeshshodayis danda7iza» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuusa ezis qadhinttii, fa kusha dakkii eza bochchii, «Ta koyiza, geezhoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Izir borqqonttay atha dakkin athay ellisii geezheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuusa athayiko miinthii naaginttoba gi moyzeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yesuusa eza, «Nena eroba, yhanno ooskka odippe. Zin yhanigii ne galla qeese beezoba. Ne yhatti geeshsh maaqqeezana asa ersodayis, Muse kiitteez yarshsho yarshshoba» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Zin athay yhanigii, heera ubbayid asis odeeza. Yey gishos, Yesuusa qonccer, katama gelodayis danda7ekkaya. Zin asii baa aqo gaxa yezeeza; ma asii ubba aqopp eziko yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xiqqa gallasapp guye Yesuusa qifirnahoome maaqqii, kara yeza giz wore sintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Shiiqeez asa keethay ekkaam ixxin hara attozin balaykka un77od gatho gaame as shiiqin, Yesuusa qaala taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyddii asitay pettii sila atha tookkii eziko ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asay gaanggeez gishos atha Yesuusako shiishodayis unttis danda7inttaam ixxin, Yesuusa yeza baggayir keetha qaarii, siitingga qawuxii atha e woyi7eez arssatira sulle dakkii Yesuusa tiinayid wotheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuusa u ammana bi7ii, ya sila atha, «Ta na7ayyo, ne nagaray atto gintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Higge asitamaaritaypp ye aqayid bentteez pettii pettii asitay fa wozinayir, ");
INSERT INTO mfxl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Yha athay yhay garkk iita baz Xoossal afa abis odinttee? Xooss aaddapp attin hara o nagara atto godayis danda7ee?» yeegii qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","U fa wozinayid yey garkk qoppeezana Yesuusa ellisii fa ayyanar erii, unttiko, «Yinttii yi wozinayir abis yhay garkk qoppee? ");
INSERT INTO mfxl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sila atha, ‹Ne nagaray atto gintteeza› gizay shawukkinenee? Woy, ‹Dendii eqqii ne arssa tookkii qitoba› gizayi shawukke? ");
INSERT INTO mfxl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Zin taas, As Na7ayis, sa7all afa yessay nagara atto godayis wolqqa yezana yi erod garkk» yeegii ye sila athayiko, ");
INSERT INTO mfxl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ta neeko yhatt odiza, dendii ne arssa tookkii ne kara qitoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Athay ellithii dendii, fa arssa tookkii as ubbay tiina kezeeza. Asay ubbay malabaz gi, «Nuunii yhay garkk baz yesha bi7ii erooya» yeegii Xoossa galateeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuusa maakka Galila Abba lanqqe yhanigii, eziko ye7eez as ubbita taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ezayir aadhodar, Ilfoosa na7a Lewe ginttinttizay qaraxe gachisiza aqo betteezin bi7ii, «Tana kaalloba» yeegeeza. Leway dendii eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuusa katha maadayis Leway kara betteeza. Eza kaalliza asay gaame maaqqeez gishos qaraxe gachisiza gaame asaynnee nagara oothiza asay ezarannee E tamaaritayir wolla betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Higge asitamaare maaqqeez pettii pettii Farasaawe asay Yesuusa nagara oothiz asayrannee qaraxe gachisizitayir katha maadar bi7ii, «E abis nagara oothiz asayirannee qaraxe gachisizitayir katha mee?» yeegii, E tamaaritayir woli oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuusa u gizana si7ii, «Akime harginttiztayisapp attin pathi asis koshshooya. Taanii nagara oothizita xeegodayis ye7eezapp attin xillita xeegodayis ye7ekkaya» yeegii unttisi maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xammaqiza Waannisa tamaaritaynnee Farasaawitay xoomizazin, Pettii pettii asay Yesuusako yi7ii, «Waannisa tamaaritaynnee Farasaawitay tamaaritay xoomiza, Zin ne tamaaritay abis xoomoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuusa unttiko, «Machcho ekkizay unttar yezin Laazanthitay, xoomodayis danda7inee? Machcho ekkiz athay unttar yezin, xoomodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Zin machcho ekkiza athay u kalepp ekinttiza qamma ye7oda, u ya gallas xoomoda. ");
INSERT INTO mfxl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Cima afilall afa oroth iraafe gaddii sikkiza asii baaya. Gaddii sikkiko, orothay cima afilana per7iza; per7ithaykka tiinaasaypp daligiza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma mal7antto woyine cima ogoro gancce buulliz asii baaya. Buulliz maaqqiko, ye woyinay ogorana dhuusiza, fa ubbaskka laalinttiza, ogoraykka iitiza. Zin mal7antto woyine oroth ogoro gancce buulinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesuusa pettii maala gallas bangga gade ganccer aadhodar, E tamaaritay ezar wolla yhanigttar bangga tizha mirkkii muus aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasaawe asay Yesuusako, «Yeezin, ne tamaaritay maala gallas woga baabaz abis oothee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuusa unttiko, «Dawute nayinttii, miiz baz kozheez wode paar yezitayir ootheezana yi nabbabekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyatara qeese halaqa maaqqii yeza wode Dawute Xoossa keeth gelii, qeeshitay aadda maadaypp attin oonkka maadayis woga baabaz Goday tiina gaddeez yarshsho soollo meeza, paar yezitayiskka inggeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Maakka Yesuusa unttiko, «Maalay asis medhintteezapp attin asii maalas medhinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yey gishos, As Na7ay, hara attozin Maalaskka Goda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuusa Ayihuditay Woosa keethi maaqqii geleeza. Ezayida kushe sileez pettii athay yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pettii pettii asay Yesuusa mootodayis koyii, kushe sileez atha maala gallas E pathodazakonnee ashshodazako be7adayis koyii miinggii naagiza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuusa kushe sileez atha, «Dendii yhana yi7ii nu gancce eqqoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yeypp guye, asitayiko, «Maala gallas lo77o baz oothizay woganee iita baz oothizay woga? As shemppo ashonnee wodho?» yeegii oyceeza. Zin asay si77e geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuusa shenitii unttan fa kalayir yezita dakkii bi7ii, u wozina docceezita maaqqeez gishos unttan kacceeza. Ya athayiko, «Ne kusha piddi udoba» yeegeeza. Athay piddi udin e kushitay paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ellisii Farasaaway Ayihuditay Woosa keethapp bale kezii, Yesuusana wayizii wodhodazako tobbodayis Herodoosa baggitayir pettii kara shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuusa fa tamaaritayir Galila Abba lanqqe yhanigeeza. Galilapera Yihudap ye7eez gaame asay eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Maakka Yerusalaamepp, Edomaasapp, Yorddanoose haath pinthappe, Xiroosa katamapper Sidoona giz katamapp Yesuusa ootheez bazita si7ii, gaame asay eziko ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Shiiqeez asay gaametithaypp dendeezayid eza waayithaam garkk E tamaaritay wogolo ezis lo7itoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gaame asita E patheez gishos harginttiza asay ubbitay eza bochchodayis urqqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tuna ayyana aykkeez asitay eza be7eezan garkk e tiina xuggunii, fa qaala dhoqqi udii, «Ne Xooss Na7aya baasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuusa unttan fa suntha ooskka odaamay garkk miinthii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuusa derell afa kezii, fa kozheez asita faako xeegeeza; unttikka eziko yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Unttikka paar yezoday garkkennee qaala tamaarssoday garkk taphpho nam7ita doorii, unttan, «Hawaarita» gi xeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tuna ayyaanttakka kessod garkk unttisi mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E dooreez taphpho nam7itay yhayitita: Phixiroosa yeeginttii xeeginttiz Simoona, ");
INSERT INTO mfxl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bo7anerggese (Dada na7ita) yeegii sunth gaddeezita, Zabdoosa na7ita Yayqqoobarannee Yayqqooba isha Waannisa, ");
INSERT INTO mfxl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Indiraase, Filphoosa, Barttolomoosa, Maattoosa, Toomaasa, Ilfoosa na7a Yayqqooba, Taadoosa, Kananepp maaqqeez Simoonarannee, ");
INSERT INTO mfxl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesuusa aathii inggeez Asiqoroto Yihuda. ");
INSERT INTO mfxl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yeypp guye, Yesuusa kara geleeza. Ma gaame asay shiiqin, ezara e tamaaritay hara attozin katha maadayiskka danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Asay eza, «Eeyiza» giz gishos E dabbitay yeya si7ii eza aykkodayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Higge asitamaaritaypp pettay pettay Yerusalaamepp yi7ii, «Ezal afa Bi7elzebula yeza», E, «Xalahe wolqqar xalahe ayyanita kessiza» yeegii wolla odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesuusa asita faako xeegii aaziso odeeza. «Xalahe Xalahe wayizii kessodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pettii kaatetithay fa gancce shaako kessiko ya kaatetithay eqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yey garkk, pettii kara asaykka woli gancce shaako medhdhiko dhabodaypp attin yezodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yikkee, Xalahe wolir morkkinttii duuxiko dhabodaypp attin yezodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Zin tiinattii wolqqama atha accekkazar e kara gelii, e shala bonqqodayis danda7iza asii baaya. Accii maaqqeezaypp e kara bonqqodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Ta yinttis turo odiza; Xoossii as na7itayis nagara ubbannee u cazheez cashsh ubba atto goda. ");
INSERT INTO mfxl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Zin geeshsha Ayyanal afa iita baz odinttiza ooskka medhinas nagara maaqqodaypp attin Xoossii ubbarakka eza maaraamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuusa yeya geezay, asay, «Ezal afa tuna ayyana yeza» yeegeez gishosii. ");
INSERT INTO mfxl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E indatinnee E ishitay yi7ii bale eqqii, eza xeegiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E lanqqe betteez gaame asitay, «Ne indatirannee ne ishitayir bale eqqii nena koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesuusa mahii, «Ta indat oonoo? Ma ta ishitay aayita?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Fa kale betteez asa yuuyii bi7ii, «Ta indatinnee ta ishitay yhayttita. ");
INSERT INTO mfxl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xooss azazo oothiz ubbitay ta ishe, ta misho ta aayo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuusa maakka Galila Abba kale taamarsso aykkeeza. Aqopp aadheez gaame asitay E lanqqayir shiiqin, abbayil yez wogolay gancce gelii betteeza, asay ubbitay Abba lanqqe yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","E unttan gaame baz aazisor taamarsseeza. Tamaarssittar yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Si7oytta! Pettii athay zerth zerodayis kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E zerodar, pettii pettii zerthay oge achcha wodhdheeza; kafitay yi7ii meeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pettii pettii zerthay sisinqqo aadda yez biittal afa wodhdheeza. Afar biitta baazay gishos ye zerithay ellisii doleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zin awa kezeez wode shulleeza. Lo7ithii xapho dakkekka gishos ellisii meleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pettii pettii zerithitay angguth gancce wodhdheeza. Doleezanno angguthii diccii cuulleez gishos aafe aafaam ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pettii pettii zerithitay aradda biittal wodhdhii doleeza. Diccii pettay hasttam, pettay usuppuntam pettay xeet aafeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«Si7iz hayer yez oonkka si7oo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesuusa kaler yez asitaynnee taphpho nam77ii tamaaritay Yesuusa fa aadda yezin, eziko shiiqii ya aazisayis bili7itha oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesuusa unttiko yhay garkk yeegeeza: «Yinttis Xooss kaatetithii xuura erettithii ingintteeza. Zin yhankkitayis kaatetithapp bale yezitayis ubba baz aazisor odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yeykka, « ‹U bbi7iza, zin denggooya. Si7iza, zin akaakooya. U denggizakonnee akaakizako, Xoossiko maaqqoda ezkka unttan maarodazinii› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuusa unttiko, «Yha aazisay yinttiskka geloosa? Yeezin, yhankko aazisita ubba yi wayizii akaakodee? ");
INSERT INTO mfxl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zerizay Xooss qaala zeriza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Qaalay zerinttodar oge kantta wodhdheezitay qaala si7eezita. Zin Xalahe izir yi7ii, u wozinayid zerintteez qaala maxii ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yey garkk, sisinqqo yez biittayil zerintteezay qaala si7ii, ellisii ufayttii ekkizita. ");
INSERT INTO mfxl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Zin unttisi xapho baazay gishos cere yhattesapp attin gam7ooya. Xiqqa wodepp guye qaala gisho meto woy bayi7ithii helliko ellisii dhubinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Angguth gancce zerintteezay qaala si7izita. ");
INSERT INTO mfxl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Zin yha sa7a yessis hirga, duretith qadhennee hara baz amotithii e wozinayid gelii qaala cuulliza gishos aafe aafekkazar attiza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Zin aradda biittal zerintteezitay qaala si7ii ekkizita. Unttikka pettay hasttam, pettay usuppuntam pettay xeet aafiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuusa gujjii, «Xomppe ayithii, ota gancce woy arssa oommo gaddiz asii yenee? Dhoqqa aqo gaddoosanee? ");
INSERT INTO mfxl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yikkee, qosintteez baz ubbitay kezekkazar; zurintteez baz ubbay pidhdhe benttekkazar attaamii. ");
INSERT INTO mfxl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si7iz haye yez oonkka si7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma unttiko, «yinttii si7iz baz akaakii si7oytta! Xooss qaala yi si7izanigarkk e yinttis akaaka ingoda. Yi makkiz bazar yinttis makkoda. Ezayppekka yinttis gaanthii ingoda. ");
INSERT INTO mfxl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pettii baz yeza athayis gujjinttii inginttoda, baazaypp hara attozin, yezan izakka eepp ekkinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuusa mahii, «Xoossa kaatetithay fa gade zerith zeriz as garkke. ");
INSERT INTO mfxl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ye athay qamma genttiza; guura gooddii dendiza. E wayizako erekkazin ya zerithay dolii dicciza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Biittata fa aaddas katha ingiza. Tiina caare, yeypp aafodayis gambbuxiza, wurssithala kunth aafe aafiza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zin kathay maxos helliko athay ellisii maxo aykkiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuusa, «Nuunii Xooss kaatetithii ab aaziza gode? Woy abar aazisode? ");
INSERT INTO mfxl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xooss kaatetithay sannaficce aafe aaziza. Ye mithatii aafa zerodar sa7a yez mithii aafe ubbaypp xiqqizara ");
INSERT INTO mfxl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Zeriko dolii diccii mith ubbaypp aadhiz; gita shaqo kessiza. Salo kafitay i shaqayil afa keexxii bettod gatho daazhiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuusa yhay garkk unddenna aaziso asitay akaakodayis danda7izay garkk qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asayis aaziso baazin odooya. Zin Yesuusa fa tamaaritayir aadda yeza wode unttisi bili7ii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ye gallasi sa7ay omathin, Yesuusa fa tamaaritayiko, «Abbapp seko pino wolla piinggoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","E tamaaritay woyita olii ashshii, Yesuusa tiina gelii betteez wogolitte gelii Yesuusana paar kanggeeza. Hara wogolitay ezayid yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wolqqama gotekka dendii, wogolay gancce haathii kumod gatho zulay shoceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ye wode Yesuusa wogolayis guye baggar borkothii gentteeza. E tamaaritay eza denthii, «Asitamaarayyo, nuunii dhabodar ne si77e gi bi7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","E barkkii gotana, «Si77e goba» yeegii, abbanakka, «Hayizoba» geeza. Gotaykka si77e gin ubba baz cicirkk geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuusa fa tamaaritayiko, «Yhay garkk yinttan yashshoday abba? Yinttis ammano abis dhabeenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Unttii iita yashsha yashittii woli gancce, «Yhay hara attozin, gotenne abba azazinttizay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuusarannee E tamaaritay abba piinggii, Gerggesonoona giz gade heleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuusa wogolaypp wodhdheezan garkk tuna ayyana aykkeez pettii athay duufopp kezii eza heleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ye athay duufo gancce aqittar peezhittar yeza. Eza oonkka santhalaater accodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","E gaame wode dukkulinttii santhalaater accinttii yeza. Zin santhalata duusirithiza, duththakka menthirithiza. Eza kayodayis danda7iza oonkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E qammannee gallas ya duufayddannee derell afa uukkiza, fa gallakka shuchchar kariza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesuusana haakor bi7ii woxxii yhanigii E tiinayid xuggunii goynneeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ye athay fa qaala dhoqqi udii, «Ubbaypp aadho Xoossa Na7a Yesuusa, nenannee tana abba helithizay? Tana dhabisamaygarkk ta nena Xoossa sunthar woossiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","E yeya geezay Yesuusa eza, «Naat yha tuna ayyanayyo, yha athaypp kezoba» yeegii azazeez gishosii. ");
INSERT INTO mfxl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuusa eziko, «Ne sunthay oonoo?» yeegii oyceeza. E, «Nuunii gaame maaqqeez gishos ta sunthay Leegona» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuna ayyanitay fana ya gadaypp kessii dakkaamaygarkk Yesuusana miinthii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye derayil afa gaame gudaylle wude heengginttiza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuna ayyanitay Yesuusako, «Nuna seko gudaylle wudayiko dakkooye, u gancce yhanigii nu geloda» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuusa unttiko, «qitoytta» yeegeeza. Yeegin tuna ayyanitay athaypp kezii gudayllitayll geleeza. Nam7i mukule maaqqod gudaylle wuday gaga doonar dirggii yhanigii abba gancce gelii mitintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gudaylle wude heenggizitay yashittii yhanigii haneezibazana katamasinnee gaxares odeeza. Yeyppe asay haneezibazana be7adayis kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Asay Yesuusako yi7ittar tuna ayyanay eepp kezeez atha be7eeza. E wozinay maaqqini, afila ma77ii, ezayid betteezana bi7ii ubbitay yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yeya be7eez asitay tuna ayyanitay aykkeeza athayil afannee gudayllitayll afa haneezibazana ubba asis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yey gishos, asay fa biittaypp Yesuusa kezii qitodaygarkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuusa wogolayil afa kezodar tiin tuna ayyana aykkii dakeez athay, Yesuusar yhammadayis eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Zin Yesuusa ixxii eziko, «Ne kara maaqqii, Goday neesi ab garkk maarotith ootheezakko neesi waafa keheezako ne kara asayis odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Athay yhanigii Taphphii Katama ginttiz aqo yuuyii, Yesuusa ezis ab garkk maarotith ootheezako odeeza. E odeezana si7eez as ubbitay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuusa maaqqii, wogolo gancce gelii, abba piinggeezaypp guye gaame asay abba gaxa E kale shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iyaroosa giz Ayihuditay Woosa Keethi halaqitaypp pettay, Yesuusana be7eez wode eziko yi7ii e tokayil afa wodhdhii, ");
INSERT INTO mfxl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«Ta na7ata harginttii yhayqqod haniza. Iza paxodgarkk yi7ii ne kusha Izil afa gaddooye» yeegii Yesuusana miinthii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesuusa Iyaroosar yhanigeeza. E yhammadar gaame as eza kaallittar urqqitheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Taphpho nam77ii laythi Izilapp suuthii goggeez pettii astta yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gaame akimitay izo akimeezin, iza pathi eqa kaa7inttiza. Iza fa miisha ubba wurssinkka iis yhana iiteezaypp attin abikka izo maaddekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ye astta Yesuusa waara si7eez, gishos asaypp aadhii Yesuusas guyiguthar yi7ii e afila bochcheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iza, «Ta hara attozin E afila manchchato bochcheezako paxoda» gi qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Izipp goggiz suuthay izir eqqii atteeza. Iza fa waayaypp paxeezana fa galayill ereeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuusa ellisii paapp wolqqa kezeezana fa ubbas erii, gaame asay gancce guye maaqqii, «Ta afila bochcheezay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E tamaaritay, «Asay nena urqqiza bi7ittar, ‹Oonoo tana bochcheezay yeegii wayizii oyce?› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuusa yeya o ootheezako erodayis yuuyii be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Zin asita paas haneezibazana erii, yashshar kukkurttar yi7ii Yesuusa tiinayid guphinggii; fa xillat ubba eesi odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeeyin, Yesuusa iziko, «Tana7ate, nena ne ammanay patheeza, saro yhanigoba, ne waayayppekka paxoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuusa haga yhaya ododar, Ayihude Woosa Keethi halaqay karapp kiitintteez asitay yi7ii, «Ne na7ata yhayqqeeza, yhatt asitamaara abis daabursse?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zin Yesuusa u gizana si7ii, Ayihuditay Woosa Keethi halaqayiko, «Ammano aadda ammanobapp attin yashittippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuusa Phixiroosapp, Yayqqobappennee Yayqqooba isha Waannisapp hara oonkka fana kalaamay garkk kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Unttii Ayihude Woosa Keethi halaqay kara hellodar Yesuusa asay yeekkodar, zelalodarannee uukkodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gelii asitayiko, «Yha ubba yeefaynnee uufay abiso? Na7ata gentteezapp attin yhayqqekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Asay eza leqqii miicceeza. Zin as ubbita bale kessii, na7atii ada, indatonnee hayidzii taamarita paar ekkii na7ata yezabessa geleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuusa na7atii kusha aykkii, «Xaalita, kumii» geeza. Bilthaykka (Xiqqa na7ate, nena giza dendoba) guussii. ");
INSERT INTO mfxl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Iza taphpho nam77ii laythi na7azar izir dendii eqqii yedhdhith aykkeeza. Yeykka haneeza bi7ii asay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuusa yeya u ooskka odaamay garkk unttan miinthii azazii. Na7atis miiz baz immad garkk odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuusa yeypp kezii, fa taamarita kaalithii, fa katama Naazirete qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Maala gallas Ayihude Woosa Keetha taamarsso aykkeeza. E taamarssizana si7eez gaame asay yhay malabaz gi, «Yhay yha ubba anapp denggeennee? Yhay ees ingintteez ecetithay waafa? Yha malatita oothiza mawutay ees wayizii ingintteene? ");
INSERT INTO mfxl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yhay anaaxa baasa? Mayiramii na7a, Yayqqooba, Yoosa, Yihudarannee Simoona isha baasa? E mishunthikka nuur yhannee yezunthun baasanee?» yeegii, E odizana ekkaam ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuusa ye asitayiko, «Nabe fa gadella, fa dabbitayddannee fa kara as gancce bonchchnttooyapp attin yhankkitay kale bonchchinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E ye aqayid fa kusha harginttiza xiqqa asitayil afa gaddii patheezaypp attin hara malata baz oothodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Asay ammanaam ixxeez gishos pala baz geeza. Yeypp guye, Yesuusa ye heerapp hara heera taamarseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuusa taphpho nam77ii taamarita faako xeegii, nam77e nam77e woli helthii azazeeza. Unttis tuna ayyanitayil afa mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Unttan, «Oges gufe aaddapp attin katha, qurbo, yi kiise miishe ababazkka aykkippattee. ");
INSERT INTO mfxl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yi toke caamma aathoytta, zin laame afilakka aykkippate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maakka, «Yinttan asii mokkeez kara abakka maaqqin ye aqato ashshii qitod gatho ye karttee gam7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yinttan asii mokkowa kara woy yi odiza baz si7oowa kara abakka maaqqiko, ye biittate yez asayis yey markka maaqqod garkk ye aqaypp kezittar, yi tokaypp buli7a tiqisoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Taphpho nam77ii tamaaritay yhanigii, asay fa nagaraypp maaqqod garkk qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Unttii asaypp gaame tuna Ayyanita kesseeza. Gaame hargintteezita zayite tizhii patheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuusa sunthay ubba aqo kezeezay gishos Kaatay Herodoosa e bagga si7eeza. Pettii pettii asay, «Xammaqiza Waannisa yhayiqopp dendeeza, yey baggar yha malatita oothizay eza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baggitay, «Yhay Eelaasa» yeegeeza. Yhankkitay ma, «Yhay binii wode nabitaypp pettay garkk maaqqith attaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Zin Herodoosa yeya si7ii «Yhay ta qoodhe gachiseez xammaqiza Waannisa e yhayiqopp dendeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodoosa fa ishay Filphoosa machchato Heroodada ekkeez gishos Waannisa ayithii acciseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Waannisa Herodoosa, «Ne ne ishay machchato ekkodayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heroodada Waannisa fa ulor morkkii eza wodhisodayis koyeeza, zin danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Waannisa xillonnee geesh as maaqqeezana Herodoosa ereez baggar ezis yashittii miinthii naageeza. Herodoosa Waannisa nashsha si7ii ufayttizarakka mor7iza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodoosa fa yelintteez gallasa bonchchodayis gade aqisizitayis, shaalaqitayisnnee Galila yez damma asayis imato giigiseeza. Yeyi Heroodadas lo77o gallas maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodada na7ata imathi mokinttiza aqayid gelii doonggii, Herodoosannee e imathita ufaysseeza. Kaatay na7atis, «Ne koyiz baz ab maaqqikokka tana oycoba, ta neesi immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma izis caaqqii, «Ne oyciz baz ab maaqqikokka, ta neesi immada. Hara attozin, ta kaatetithay bagga maaqqikokka ta neesi immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na7ata bale kezii fa indatiko, «Ab ingoba gi oyco?» gi oyceeza. I indat, «xammaqiza Waannisa omma ingo goba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na7ata ellisii kaatayiko yhanigii, «xammaqiza Waannisa qoodhatip gachchii pili7o gancce gaddii yhatti taas immaday garkk ta koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yeegin Kaatay unddenna qiiradhdheeza zin fa immathitay gisho izis caaqqeez fa caaqa menthodayis koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yeyi gishos, ellisii naagiza atha Waannisa omma ko7oday garkk azazeeza. Naagiza athay achch keethi yhanigii Waannisa qoodha gachcheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ye gachchintteez omma pili7o gancce gaddii ki7ii na7atis inggeeza. Na7atakka ma fa indatis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waannisa tamaaritay yeya si7eez wode yhanigii e aha ekkii kanggii moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hawaaritay maaqqii yi7ii Yesuusako shiiqii u ootheezbazinnee taamarsseeza baz ubba Yesuusas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Unttiko yi7iza asaynnee qitiza asay gaanggeez gishos Yesuusarannee e tamaaritayi, hara attozin katha maadayiskka unttis wode dhabeeza. Yeeyin, Yesuusa unttiko, «Nuusikka xiqqal shempp ekkodayis asii baa aqo yedhdhoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yey gishos, unttii fa aaddas wogolo gancce gelii asii baa aqo yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","U yhammadar gaame asitay unttan bi7ii ereeza. Yeezin, katama ubbapp asii toker woxxii yhanigii u yhanigiza aqayid unttapp tiinattii helleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuusa wogolopp wodhdhii gaame woya be7eeza. Asay heenggiz asii baa dur garkk maaqqeezana bi7ii unttis qadhinttii unttan gaame baz taamarisseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa7ay awa aadhodar Yesuusa tamaaritay eziko yi7ii, «Yha aqay liizho; yhatt sa7ay omatheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Asay herarannee katamar yhanigii paas miiz baz woonggod garkk asa dakkoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Zin Yesuusa mahii unttiko, «Asayis miiz baz yi ingoytta» yeegeeza. U, yeezin «Nuunii yhanigii nam77ii xeet diinnaarer soollo wonggii immadenee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesuusa unttiko, «Yinttis aappun soollo yenee? An yhanigii bo7oytta» yeegeeza. U bi7ii, «Ichchin soollorannee nam77ii molor yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesuusa fa taamarita asa ubba cugar cugar shaakkii maatal bettiththoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asay baggay xeet, baggitay ishatam maaqqii cugar cugar shaakinttii betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuusa ichchin soollorannee nam77ii molita ekkii, salo bi7ii Xoossa galateeza. Soolla duuthii asayis gishoday garkk fa tamaaritayis inggeeza. Ma nam77ii molita u ubbitayis shaakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","As ubbitay mi mizheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Atteez soollo gufannee molo gufa, e tamaaritay taphpho nam77ii leemate kunth dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Soollo meez dhiirath asitay aadda ichchin mukule maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ellisii Yesuusa fa tamaaritay wogolo gancce gelii, Abbapp sekofino yez Biitta Beetesayida yhanigodaypp tiinatii qitoday garkk kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Asa moyzeezaypp guye Xooss woossodayis derell afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sa7a qammodar wogolay abba gancce yezin, Yesuusa abba gaxa fa aadda yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Carkko e tamaaritayiko carkkiz gishos abba pidhithay waayithizana Yesuusa be7eeza. Wonttimaathe shugula uukkodar e abbal afar yedhdhittar unttiko yi7ii, unttan olii aadhodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Zin e abbal afa yedhdhodar, u bi7ii, unttisi meeshe aazin uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","U ubbitay eza bi7ii, yashittii dagameeza. Zin Yesuusa ellisii unttiko, «Tana, akko baaya; yashittippatte» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesuusa wogolayid gelii unttar wolla bettin carkkay si77i atteeza. Unttii gita mala bazi geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","U wozinay docceez gishos soollayil ootheez malata unttii akaakekkayapp attin yhay unttis malabaz baabonazin. ");
INSERT INTO mfxl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Unttii abba piinggii, Gensareexee biitta hellii, wogola gaxal shiishii acceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","U wogolaypp wodhodar asay ellisii Yesuusana ereeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","U heera yez biitta ubba woxitii hargintteez asita halar tookkii, «Yesuusa yeza» yeza geez aqayid ki7ith aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Asay e yhanigeez kara ubba, gaxare maaqqin, katama, yez hargintteez asita bucal kanggiza. Hargintteez asitay e afila manchcha maaqqikokka bochchod garkk asay eza woosseeza. Bochcheez ubbitay paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yerusalaamepp ye7eez farasaawitayira pettii pettii higge asitamaaritay Yesuusa kale shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesuusa tamaaritaypp pettay pettay geezhekka kusher, yeykka kushe meecinttekkazar katha miizita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasaawitaynnee Ayihuditay asii ubbay fa aditay wogay garkk fa kushe lo7ithii meecinttekkazar mooya. ");
INSERT INTO mfxl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yey garkk, unttii gabepp maaqqii meeccekkazar mooya. Ma unttii fa aditaypp ekkeez hara gaame woga yeza: yeykka wancca, ota, biraata miishera arssa meecciz woga naagiza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farasaawitayirannee higge asitamaaritay Yesuusa, «Ne tamaaritay abiso aditay woga menthii fa kushe meecinttekkazar katha miizay?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuusa unttiko, «Nabe Isayaasa yinttis cubbitayis, « ‹Yha asay tana fa iranthi aaddari bonchchiza, zin u wozinay taapp haakko yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asii kochcheez woga Xooss higge aazisii taamarssiza gisho u tana cer goynniza› » yeegii xaafeezay turo. ");
INSERT INTO mfxl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Yinttii Xooss kiita ashshii as woga naagiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maakka Yesuusa, «Yinttii yi woga naagodayis gi Xooss kiita olii ashsheeza ");
INSERT INTO mfxl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse, ‹Ne adenne ne indo bonchchoba›, ma ‹Fa adannee woy fa indo cazhizay yhayqqodayis beeziza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Zin yi yeegiza pettii athay fa ada woy fa indato maaddoda ashshii, ‹Yhay Xoossa yarshsho› giiko, ");
INSERT INTO mfxl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E fa ada woy fa indato maaddaam garkk yi udiza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yey garkk, yi yhankkita taamarisseez yi wogayid Xoossa qaala leqqeeza. Yey garkk hara gaame baz oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuusa gaame asa maakka faako xeegii, «Ubbay ta odiza si7oyttannee akaakoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","As wozinapp keziz baz as tunisizapp attin balepp as ulo gelii as tunisiza baz abkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Si7iz hayer yez oonkka si7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuusa gaame asa olii ashshii keetha gelin e tamaaritay ye aazisay bagga eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E unttiko, «Yinttiskka ma gelekkasa? Balepp as gancce geliza baz abkka as tunisodayis danda7oozana akaakoosanee? ");
INSERT INTO mfxl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Abis giiko, katha as doonar ulo gancce gelii ezayir bale kezizaypp attin as wozina gancce gelooya» yeegeeza. Ezayid Yesuusa katha ubbay geeshshii maaqqeezana eriseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gujjikka, Yesuusa, «as tunisiza baz as wozina ganccepp keziz bazii. ");
INSERT INTO mfxl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","As wozina ganccepp keziz baz wobbo qofa, lagita, kastto, as wodho, ");
INSERT INTO mfxl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","laame, iita amotithii, iitatithii, gene, qayxe, doosha, qinaate, cashshe, utirannee boozatithii. ");
INSERT INTO mfxl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yha iita baz ubbaykka as wozina ganccepp kezii as tunisiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuusa yeypp kezii, Xiroosa katama kale yez gade yhanigeeza. E pettii kara gelii ezayid yezana oonkka erod garkk koyekkaya. Zin qosinttii gam7odayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Zin i xiqqa na7ato tuna ayyana aykkeez pettii astta Yesuusa oosa si7ii ellisii eziko yi7ii e tokayil afa wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iza Girike asii; yelintteezay Siroofinqqe giz biitta. Iza, fa na7atipp tuna ayyana kessod garkk Yesuusa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zin Yesuusa mahii, «Na7itay tiinatii katha mizho; na7itay katha ekkii kanitayis olo koshshooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Asita maaqqii, «Ta Godayyo yeyi tuma, zin leemate kale yez kanitay na7itaypp wodhdhiz gufa miinebay» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesuusa ma iziko, «Yha ne qaalay gishos ne kara qitoba; tuna ayyana ne na7atipp kezeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Izakka fa kara yhanigodar tuna ayyana i na7atipp kezin arssal woyi7eezanno denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuusa ma Xiroosa katamapp kezii, Sidoonaranne Taphphii Katamita giz biittar aadhii Galila Abbako yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asay tullennee deddatiza as Yesuusako ki7ii, fa kushe ezal afa gaddod garkk eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuusa aadda ye atha gaame asaypp gaxa kessii, fa biradhdhe e hayayid dakkeeza. Ma yeypp cuchchii cuttii e irantha bochcheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Salo fude dhoqqi gi bi7ii, woossii, «Eftah» geeza. Bili7ithaykka «Dooyinttoba» guusii. ");
INSERT INTO mfxl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Athay hayay ellisii dooyintteeza, accintteez iranthaykka bili7intteeza, athay bili7inttii odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuusa asayiko, «Yhaya ooskka odippate» yeegeeza. Zin E lo7ithii miinthii odippate gin, asay oda gede dalgiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yeya si7eez as ubbay lo7ithii malabaz gi, «Ubba baz e lo7ithii oothiza. Hara attozin, tulle sissiza, muume odisiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Xiqqa wodepp guye, gaame asay Yesuusako shiiqeeza. Asayis miizibaz dhabin Yesuusa fa taamarita faako xeegii, ");
INSERT INTO mfxl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Yha asay taar hayidzii gallas hellodayis gam7ii, abkka miiz baz denggekkazay gishos tana asay qadhithiiza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ta asa nayer kara dakkaamii, asay yhanigttar ogella daaburii pokkoda, bagga asay haakopp ye7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesuusa tamaaritay mahii, «Yha liizhayid yha asa ubba muzodayis gidiza katha denggodays danda7izay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuusa unttiko, «Yinttar aappun soollo yenee?» yeegii oyceeza. U mahii, «Laappun soollo yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesuusa asay sa7a bettoday garkk kiiteeza. Yeezeezaypp, laappun soollo ekkii Xooss galatii maaqqii ye soolla duuthirthii, asayis gishod garkk fa tamaaritayis inggeeza. E tamaaritay asayis gisheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Unttisi ma xiqqa yishshe molitay yeza. Yesuusa ye molitay gishos Xooss galatii, asayis gishod garkk fa taamarita azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Asay ubbitay mi mizheeza. E tamaaritay atteez gufa laappun leemate kunth dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Katha meez asay tayibay oyddii mukule maaqqoda. Yeypp guye, Yesuusa asa dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E ma fa tamaaritayir ellithii wogolo gancce gelii Dalmmanuuta ginttiz biitta qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasaawe asitay yi7ii Yesuusa paaccodayis koyii, salopp u fana mala beezodaygarkk Yesuusar palama aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuusa sheemitii, «Yha wode asay abis malla koyee? Ta yinttis tuma odiza; yha wode asis aba mallakka ingintteena» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E unttan ize olii ashshii maaqqii wogolo gancce gelii abbaypp seko pino piinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","E tamaaritay katha ekkii yhamo dogeeza; unttisi wogolay gancce pettii soollopp hara katha baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuusa unttiko, «Yinttan eroytta. Farasaawitay irshshoppennee Herodoosa irshshopp naaginttoytta» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Unttii woli gancce, «E yhaya gizay nuus soollo baazay gishos» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuusa u gizana erii unttiko, «Yinttis soollo baazay gishos abis odinttee? Yhattekka yi eroosa? Woy yi akaakoosa? Yi wozinay docceennee? ");
INSERT INTO mfxl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yinttis aafe yezin bo7oosa? Haye yezin si7oosa? Yinttis wayizii akaakinttoosa? ");
INSERT INTO mfxl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ta ichchin soollo ichchin mukule asis peedheez wode aappun leemate kunth gufa dentheennee?» yeegeeza. Unttikka, «Taphpho nam7i leemate kunth» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Yey garkk, ta laappun soollo oyddii mukule asis peedhin aappun leemate kunith gufa dentheennee?» yeegeeza. Unttii, «Laappun leemate kunth dentheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeezin, «Yhattekka yinttis qofinttoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Unttii Beetesayda katama yhanigeeza. Xiqqa asitay to7a atha Yesuusako ki7ii ye atha bochchod garkk eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuusa to7a athay kushayid aykkii katamapp gaxa keseeza. E aafate cuttii fa kushayid ezal afa gaddii, «Nees akko benttinnee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Athay dhoqqi gi bi7ii, «Taas asay benttiza, zin asay yedhdhittar mithii aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeypp guye, Yesuusa mahii, athay aafayil fa kushe gaddeeza. Athay lo7ithii be7eeza, e aafay paxeeza, ubba baz milxxi udii be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuusa athayiko, «Ne kara qitoba, katama yhanigippe» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuusa fa tamaaritayir Qisaare Filphoosa kale yez heera yhanigeeza. U yhammadar Ogel afa Yesuusa, «Tana asay oona gineshsha?» yeegii fa taamarita oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","E tamaaritay, «Pettii pettii asay nena, ‹Xammaqiza Waannisa› giza; yhankkitay, ‹Eelaasa giza› ma yhankkitay, ‹Nabitaypp petta› giza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuusa unttiko, «Yeezin yi tana oona gee?» yeegii oyceeza. Phixiroosa, «Ne Kiristtoosa» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuusa, «Tabaz ooskka odaamay garkk naaginttoytta» yeegii unttan azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuusa fa tamaaritayiko, «As Na7ay, gaame meto ekkodayis beeziza; cimitay, qeese halaqitaynnee higge asitamaaritay eza ixxodayis beeziza. Unttii eza wodhodayisinnee hayidzii gallasapp guye, e yhayiqopp dendodayis beeziza» yeegii unttan taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E yeya unttis geeshshii odeeza. Phixiroosa aadda pettii bagga aathii kacceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zin Yesuusa guye maaqqii, fa taamarita bi7ii, Phixiroosar kacinttii, «Yha Xalahayyo, taapp haakkoba. Ne asii dosizibaz qoppizapp attin Xooss dosizibaz qoppooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Maakka Yesuusa gaame asitayira fa taamarita faako xeegii, «Tana kaallodayis koyiz oonkka fana kado; fa mazqalana tookkii tana kaallo. ");
INSERT INTO mfxl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Fa shemppo ashshodayis koyiz athay dhabisiza. Zin ta gishonnee Wonggile gishos fa shemppo dhabisiza athay ashshiza. ");
INSERT INTO mfxl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asii sa7all yez shalo ubba denggii fa shemppo dhabisiko eza ab adode? ");
INSERT INTO mfxl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Asii fa shemppo wozodayis ab ingodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xooss ammanoowa yha iita yeletithayid, asii taallannee ta qaalayid yeellatiko, As Na7ay, fa Adayi bonchchayir geesh kiitanchchitayir yi7itar e baggar yeellattoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuusa unttiko, «Ta yinttis turo odiza; Xooss kaatetithay wolqqar yi7izana be7ekkazar yhayqqaam pettii pettii asay yhaydda yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesuusa usuppun gallasapp guye, paar Phixiroosara, Yayqqoobara Waannisara aadda ekkii damma ambal afa kessii u tiinayid laamintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E afilaykka fociza; sa7a afila meecciza oonkka geeshshodayis danda7oozay garkk mulxxi gi booxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ye wode Eelaasara Musera Yesuusar wolla nashshodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phixiroosa Yesuusako, «Asitamaarayyo, nuunii yhaydda yezeezako nuus lo77o; nu hayidzii shaqara petta neesi, petta Muses, ma petta Eelaasas accoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yhankkitay iita yashitteez gisho Phixiroosa ab gizakokka erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yeypp guye, shaara yi7ii unttan goollin shaaray ganccepp, «Yhay ta qadhdhiza, ta Na7aya, e giz baz si7oytta» giz qaala ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ellisii u yuuyii be7adar Yesuusapp attin hara oonakka fa kale u be7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Unttii ambalapp wodhdhodar, Yesuusa unttiko, «As Na7ay, yhayiqopp dendod gatho, yi be7eez baz ooskka odippate» yeegii azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E azazeezana u, «Ero» yeegii, «Yha yhayiqopp dendo guussay abi guuso» yeegii, fa ganccer wolla odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","U maaqqii, «Higge asitamaaritay, ‹Eelaasa tiinatii ye7odayis beeziza› abis gee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesuusa mahii «Eelaasa tiinatii yi7ii, ubba baz lo7ithiza; yeezin, abis geeshsha Maxaafay, ‹As Na7ay deexo meto ekkodanee leqinttoda› yeegii xaafeezay waafa? ");
INSERT INTO mfxl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Zin ta yinttis odiza; Eelaasa kase ye7eeza; ma e baz geeshsha Maxaafayid xaafintteezay garkk, asay ezal afa fa koyeezi baz ubba ootheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuusarannee hayidzii e tamaaritay atteezitayko maaqqii ye7odar gaame as u lanqqayid betteezitannee higge asitamaaritay unttar palamizana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ye gaame asay Yesuusa be7eez wode dagamar malabaz gi, ellisii eziko laasii yi7ii, eza sarotheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuusa higge asitamaaritayiko, «unttar palamizay abiso?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ye woyitay ganccepp pettii athay maaqqii, «Asitamaarayyo, ta na7ayil afa pogoda kayiz tuna ayyana yeza gishos eza ta neeko ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ya ayyanay dendeez wode, eza shocii olii; doonayir gappuntto ki7ii; achch coonchii; galla zabisii gamin Kessodaygarkk ne tamaaritayis odin, u kessodayis danda7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuusa mahii unttiko, «Ammanoowa yha layitha asito! Taanii yinttar ayide hellodayis yezodee? Ma yinttan ayide hellodayis danda7odee? Na7a taako yhana ekkii ye7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Unttii na7a eziko ke7eeza; ye tuna ayyanay Yesuusa be7eezangarkk na7a kukkurssii; pokisii, doonar gappuntto ki7ith aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuusa ye na7ay adayiko, «Yha ne na7a aykkeezaypp aapun layth maaqqode?» yeegii oyceeza. Na7ay aday, «E duudezin aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eza wodhodayis gaame wode tama ganccennee haathii gancce oliza, zin ne danda7iko, nuus qadhdhooye, nuna maaddooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuusa, « ‹Ne danda7iko ginee?› Ammaniza ooskka ubba baz danda7inttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ellisii na7ay aday fa qaala dhoqqi udii, «Ta ammaniza, zin gujjii ammanodaygarkk tana maaddooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuusa asay gaanggii gaanggii yhanigizana bi7ii, tuna ayyana, «yha tullennee muume ayyanayyo, yha na7aypp kezoba nena ta azaziza; ma nam7intho maaqqii ezal gelppe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ye tuna ayyanay uukkii, na7a iita kukkurssii, ezapp kezeeza. Na7ay yhayqqeeza aazin, gaame asay, «Na7ay yhayqqeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Zin Yesuusa na7ay kushayid aykkii denthin, na7ay dendii eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuusa kara geleezaypp guye e tamaaritay, «Nuunii ye tuna ayyana kessodayis abis danda7ekkasa?» yeegii Yesuusa aadda oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesuusa mahii, «Yey garkkezay woosarannee xoomarapp attin harabazar kezodayis danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Unttii ye bessaypp dendii, Galilar aadhii yhanigeeza; Yesuusa fa yezabessa oonkka erod garkk koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","E fa tamaaritayiko, «As Na7a, asii asitay kushe aathii immadannee wodhoda; E hayidzii gallasapp guye, yhayiqopp dendoda» yeegii taamarisseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Zin unttisi e geezay gelekkaya; ma eza oycodayiskka yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Unttii qifirnahoome katama yhanigii kara geleezaypp guye Yesuusa unttiko, «Ogel yi abis palaminttee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Zin u, «Nu gancce ubbapp aadhoday oonoo?» yeegii palameez gishos si77e geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuusa bettii, taphpho nam77ii taamarita xeegii, «Oonkka tiina aadhodayis koyko, ubbapp guye aadhii, ubbayis aylle maaqqodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pettii xiqqa na7a ekkii, u gancce esseeza; ye xiqqa na7a idinggii unttiko, ");
INSERT INTO mfxl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Yhay garkk xiqqa na7itaypp petta ta sunthayir mokkiza oonkka tana mokkiza; ma tana mokkiza oonkka tana azazeezanakka mokkizapp attin ta aadda mokkooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Waannisa, «Asitamaarayyo, pettii asii ne sunthar tuna Ayyanita kessodar nu bi7ii, nu bagga maaqqekka gishos eza kayeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Zin Yesuusa, «Oonkka ta sunthar Xoossii oothiz malata baz oothii, ellisii taal afa iita baz odinttodayis danda7izay baa gishos kayppate. ");
INSERT INTO mfxl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nubaz ixxowa ubbitay nu bagga. ");
INSERT INTO mfxl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ta yinttis turo odiza; yi taasita maaqqeez gishos oonkka yinttis ta sunthar hale haathii uzhodayis ingikokka, fa gate dhabaamii. ");
INSERT INTO mfxl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Tana ammaniza yha xiqqitaypp petta balithodaypp oonkka, damma woxa fa qoodheeli accii, abba gancce wodhdhizako eesi lo77oda. ");
INSERT INTO mfxl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ne kushay nena balithiko, gachchii oloba. Neenii nam77ii kusher to7oowa gaanname tama gancce wodhdhizaypp, duuxa kusher medhina de7o gelo neesi lo77oda. ");
INSERT INTO mfxl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gaanname guxinekka yhayqqoowa, tamaykka to7oowa aqo. ");
INSERT INTO mfxl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne tokay nena balithiko, gachchii oloba. Ne nam77ii toker gaanname tama gancce wodhdhizaypp, wobbo maaqqii de7o gelizako neesi lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gaanname guxine yhayqqoowa, tamaykka to7oowa aqo. ");
INSERT INTO mfxl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne aafay nena balithiko, woocii kessii oloba. Ne nam77ii aafer gaanname tama gancce wodhdhizaypp, pettii aafer Xooss kaatetithii gelizako neesi lo77o. ");
INSERT INTO mfxl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Gaanname guxinay yhayqqoowa, tamaykka to7oowa aqo. ");
INSERT INTO mfxl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Yarshsho maxiner oothinttizay garkk asii ubbay tamar harqinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maxine lo77o, zin mal7aam ixxiko, maaqqii wayizii mal7ithode? Yinttar maxine yezo. Yeezii pettay pettayir saro yezoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuusa yeypp dendii, Yihuda biitta yhanigii Yorddanoose borkka piinggeeza. Gaame asay maaqqii eziko shiiqin, kaseesay garkk ya asa taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farasaawe asapp faaccodayis koyii Yesuusa, «Pettii as fa machchato anjjodgarkk Muse higgay kiitinee?» yeegii eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E mahii, «Muse yinttan kase waagii kiitteenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Unttii, «Muse, ‹Pettii asii fa machchatis anjjo warqqate ingii dakko› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuusa mahii, unttan «Yi wozinay miinthii maaqqeez gishos Muse yha azaza yinttis xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Zin Xoossay tiina medhdhitar dhiirathara maachchar udii, medhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yey gishos, pettii asii fa adennee fa indo ashshii, fa machchatir wolla maadinttiza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","U nam7itay pettii asho maaqqiza; yhaypp, u pettii asho maaqqodaypp attin nam7e maaqqooya. ");
INSERT INTO mfxl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yeyi gishos, Xoossay wolalli waaxeezana asii shaakkippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","U kara maaqqeez wode e tamaaritay yha oday bagga Yesuusa nam7intho oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuusa unttiko, «Fa machchato anjii hara ekkiz oonkka laammiza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma machchatakka fa azinaypp kezii hara azin geliko laammiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesuusa duude na7ita bochchod garkk, pettii pettii asay na7ita eziko ki7iza, zin e tamaaritay ye asita kacceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuusa yeya bi7ii, fa taamarita gayileeza; unttiko, «Duude na7itay taako yi7izana kayppate; Xooss kaatetithay yhaytitay garkkezitayisii. ");
INSERT INTO mfxl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta yinttis turo odiza; Xooss kaatetitha duude na7a garkk ekkowa as oonkka ye kaatetitha ubbarakka gelaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yeypp guye duude na7ita idinggii, fa kushe unttal afa gaddii anjeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuusa yhanigodayis kezodara pettii athay laasii yi7ii, e tiinayid bunqqitidinne, «keeha Asitamaarayyo, medhinas de7o laattodayis ta ab ootho?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesuusa, «Abis tana keehayyo gi xeegee? Xooss aaddapp attin hara keeha oonkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xoossa kiitay, wodhippe; laammippe; kasttippe; worddo markattippe; dooshippe; ne adenne ne indo bonchchoba yeegizana ne eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Athay, «Asitamaarayyo, ta yhayitita ubba na7atithapp aykkii yhanno hellodayis naagiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuusa atha dakkii bi7ii qadhdheeza; «Nees pettibazii pacciza; yhanigii neesi yeza baz ubba bayizii, ye miisha manqqitayis ingoba; ne salo duritoda. Yeezii maaqqii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Zin athay yeya si7ii, e tuqqeez dure maaqqeez gishos fa sina tukkeeza, ufayttekkazar ashshii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuusa fa taamarita yuuyii bi7ii, «Dure as Xoossa kaatetithii gelodayi wayizii metodeshsha!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E tamaaritay e timirtta si7ii malabaz geeza. Zin Yesuusa maakka unttiko, «Na7ito, Xoossa kaatetithii gelodayi wayizii metodeshsha! ");
INSERT INTO mfxl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dure as Xooss kaatetithii gelodaypp, gimaale narppe lukor aadhoday shawukkiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","E tamaaritay yhay malabaz gi, «Yeezin, oonii attodee?» yeegii, pettay petta oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuusa unttan dakkii bi7ii, «Yhay Xoossis danda7inttizapp attin asis danda7inttooya; Xoossis ubba baz danda7inttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phixiroosa Yesuusako, «Yeezako; nuunii nubaz ubba ashshii, nena kaalleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuusa «Ta yinttis turo odiza; ta gishonnee Wonggile gishos fa kara woy ishita woy mishita woy ade woy indo woy machcho woy na7ita woy gade ashsheezay oonkka, ");
INSERT INTO mfxl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Yhatti yha wodayid bayi7ithar fa kara, ishita, mishita, indita, na7ita, gade, xeet kushe ekkoda. Tiinas ye7od alame medhina de7o ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Zin gaamitay tiinatteezitay guyitoda, maakka gaamitay guyiteezitay tiinatoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuusarannee e tamaaritayir Yerusalaame yhammadar, Yesuusa fa tamaaritaypp tiin tiin yedhdhiza. U yeya malabaz geeza. Eza kaallizitaykka yashitteeza. Nam7intho, taphpho nam77ii taamarita gaxa kessii, fana hellod baza duma unttisi yhay garkk yeegii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Yeezako, nuunii Yerusalaame yhatti wolla kessal yeza. Yeydda as Na7a, qeese halaqitayisnnee higge asitamaaritayis aathii inginttoda. U ezal afa yhayiqo pirdda pirddoda; ma Ayihude baa woyas eza aathii immada. ");
INSERT INTO mfxl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ye Ayihude baa woyay eza toochchoda, ezal afa cuttoda, lissor garafodannee wodhoda. E hayidzii gallasapp guye, yhayiqopp dendoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zabdoosa na7itay Yayqqoobarannee Waannisar Yesuusako yi7ii, «Asitamaarayyo, nuunii nena woossiza ubba baz nuus oothoday garkk koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","E unttiko, «Taanii yinttis ab ootho?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Unttii, «Neenii ne bonchcho kaatetitha bettiza gallas nuupp petta ushachch baggar ma petta haddirss baggar bettithooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zin Yesuusa unttiko, «Yi ab woossizako erooya, ta uzhodayis yez xuu7a uzhodayis danda7inee? Ma ta xammaqqinttodayis yez xinqqata xammaqinttodayis danda7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","U mahii, «E nu danda7iza» yeegeeza. Yesuusa maakka, «Tuma ta uzhodayis yez xuu7a yi uzhoda, ta xammaqinttodayis yez xinqqata yi xammaqinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Zin taapp ushachch baggarannee haddirss baggar bettodita dooro ta wolqqa baaya, zin ye aqay Xoossay immadayis giigisii gaddeezitayisii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yhankko taphphii tamaaritay yeya si7ii Yayqqoballannee Waannisall gayilntteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuusa unttan ubba faako xeegii, «Ayihude baa asitayis halaqitay gade aqisizita ginttinttii xeeginttizitay moodizitayis fa asitayil afa mawute yezana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Zin yi gancce yey garkk baaya; yinttii yi gancce bayiradhodayis koyiz oonkka yinttis aylle maaqqodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma yi gancce ubbapp dhoqqa maaqqodayis koyiz oonkka yi ubbayis aylle maaqqodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hara attozin, As Na7aykka, asis oothodayisinnee gaamita wozodayis fa shemppo aathii immadayis ye7eezapp attin asii ezisi oothod garkk ye7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Unttii Iyarkko katama yhanigeeza. Yesuusa fa tamaaritayirannee gaame asitayir Iyarkkopp kezodar, Ximoosa na7ay, to7ay, Barximoosa ginttinttizay, oge gaxa bettii woossiza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barximoosa, e ye ogayr aadhizay Naazirete Yesuusa maaqqeezana si7ii fa qaala dhoqqi udii, «Dawute na7a Yesuusa, tana maarooye!» yeegttar uufo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gaame asay eza, «Hayizoba!» yeegii qoddeeza. Zin, e fa qaala tiinaasaypp aathii, «Dawute na7ayyo, tana hayyana maarooye!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuusa eqqii, «Eza yhana xeegoytta» yeegeeza. Unttii to7ayiko, «Akko baaya, dendii eqqoba, nena xeegiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To7ay fa afila dhogii olii, guppii dendii eqqii, Yesuusako yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuusakka, «Ta neesi ab udod garkk ne koyee?» yeegeeza. To7ay, «Asitamaarayyo, ta be7adayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuusa eza, «Qitoba, ne ammanay nena patheeza» yeegeeza. Izir e aafay bi7in, oger Yesuusa lassa kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","U Yerusalaame ukkittar, Debre Zayite Dere lanqqe yez Beetefaagennee Bitaana katama helleeza. Yesuusa fa tamaaritaypp nam7ita tiina kiittii, ");
INSERT INTO mfxl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Yinttapp tiina yez heera yhanigoytta; ize heleezan garkk oonkka toggii be7ekka achcha yez hare na7a yi demmada, eza billii, yhana ekkii ye7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Oonkka yinttan, ‹Yhaya abiso wayize?› yeegii oyciko, ‹Goday eza koyiza, yeegoytta e ellisii yhana dakkoda› yeegoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","U yhanigii, hare na7aykka bale oge kale acinttii yezana denggii billeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ye aqayid eqqeez pettii pettii asay unttiko, «Hare na7a wayssadayis billee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E tamaaritay e unttan azazeezana odin, asay dakkii ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","U hare na7a Yesuusako ki7ii, fa afilita e zokkayil hiixxin Yesuusa ya hare na7a toggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gaame asay fa afila ogel hiixeeza; ma atteez asay mith haye shaqqii, ogel afa hiixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesuusapp tiinar yezitannee eza guyer kaalliz asitay fa qaala dhoqqi udii, «Hosaana! Goday sunthar yi7izay anjintteezaya. ");
INSERT INTO mfxl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yi7izana, nu ada Dawute kaatetithat iza anjintteezanno. Hosaana! Ubbapp aadho Salo» yeegttar uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuusa Yerusalaame yhanigii, Xoossa Keetha geleeza. Ma ubba baz yuuyii be7eezaypp guye, sa7ay qammeezayis taphpho nam77ii tamaaritayir Bitaana katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wonttitha gallas unttii Bitaanapp kezii yhammadar, Yesuusa nayintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Haakor pettii balase mithato haye tookkii yezanno bi7ii, Izil afa aafe benttodeshsha gi, be7adayis iziko yhanigeeza, zin iziko e yhanigodar haye aaddapp attin pettii aafekka denggekkaya; abis giiko, balase ka77iz wode hellekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesuusa ye balasato, «Yikkee, neepp medhinas asii aafe miippe» yeegeeza. E tamaaritay e giza si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","U Yerusalaame yhanigeeza; Yesuusa Xoossa Keethi gelii, ezayid bayizizitannee wonggizita bale bayi7ithii aykkeeza; ma miishe laammizitay xarpheezanannee holle bayizizitay oyda shirii oleeza, ");
INSERT INTO mfxl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Asii ababazkka tookkii, Xoossa Keethi ganccer aadhaamay garkk kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesuusa asita yhay garkk yeegii taamarsseeza: «Geeshsha Maxaafayid, ‹Ta karay as ubbay Xoossa woossiza kara maaqqada› yeeginttii xaafinttekkasa? Zin yi eza paannitay qosinttiza komi7o maheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Qeese halaqitaynnee higge asitamaaritay yeya si7ii, eza wodhodayis oge koshshi aykkeeza. Zin woya ubbay E timirtta malabaz gizi gishos ezisi yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa7a lem7ilem7odar Yesuusarannee e tamaaritay katamapp gaxa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Unttii wonttitha gallas ye ogayir aadhttar, ye balasata xaphor meleezano be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phixiroosas elqqi gin, «Asitamaarayyo, yinashe, ne baaddeez balasat meleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuusa mahii, «Xoossa ammanoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta yinttis turo odiza; oonkka fa wozinayid sidhdhekkazar geezbazii hanodana fa wozinar ammanii, yha amiba, ‹shodinttii abba gancce wodhoba› yeegiko ezisi hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yey gishos, ta yinttis odiza; Xoossa yi woossizabazinnee oyciz baz ab maaqqiko ekkeezay garkk ammanoytta, yi ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xooss woossodayis yi eqqodar salo yez yi Aday yi nagara atto goday garkk, oonkka yinttan naaqqeez baz pettakka yeziko, ezisi atto goytta.  ");
INSERT INTO mfxl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Zin as nagara yi atto gaam ixxiko, salo yez yi Adaykka yi nagara yinttis atto gamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","U maaqqikka Yerusalaame qiteeza. Yesuusa Xoossa Keetha yedhdhodar, qeese halaqitay, higge asitamaaritaynnee cimitay eziko yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Ne yhayttita oothodayis neesi aba mawute yenee? woy neesi yha mawuta inggeezay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuusakka mahii unttiko, «Ta yinttan pettibaz oycoda, taas odoytta. Ta ma yhaya aba mawuter oothizako, yinttis ododa. ");
INSERT INTO mfxl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Waannisa xinqqatay Xoossappennee asappee? Taas odoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","U woli gancce palama aykkii, «Nu, ‹Xoossapp› giiko, E nuuko, ‹Yeezin, Waannisa odeezana abis ammanekkasa?› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹Asappee giiko› ubba as Waannisa nabe maaqqeeza eriza.» Yey gishos woyayis yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yey gishos, u Yesuusako, «Nu erooya» yeegii maheeza; Yesuusakka, «Taankka yhaya aba mawuter oothizako, yinttis odaammii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuusa unttis aazisor yeegii oda aykkeeza; «pettii athay woyine mithii tukkii, yuushsha gaseeza. Ma woyine buulliz ollakka bookkeeza. Naagodayis aduss shaakko shakkiseeza. Yeypp guye, mattaye yhanttiz asayis ingii, hara biitta qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Woyine aafe maxiza wode hellin, fana hellizana ekkii ye7odgarkk, pettii fa aylla mattaye ekkeezitayiko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mattaye ekkeezitay e aylla aykkii yhadhdhii, kallo kushe dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nam7antho hara aylle unttiko kiittin, unttii ye aylla shuchchar qawuxii yeellathii dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Woyine atakiltte goday maakka hara aylle azazeeza. Ya aylla wodheeza, ma hara gaamita dakkin yey garkk, petta petta yhadhdhii, baggita wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Woyine atakiltte godayis kiittodayis ubbapp wurssithal e lo7ithii qadhdhiza na7ay aadda atteeza. E, ‹U ta na7a bonchchekka ashshaamii› yeegii, fa na7a unttiko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Zin mattaye ekkeezitay fa ganccer, ‹Laattoday yhaya; yedhdhoytta eza wolla wodhoda; e gaday nuus maaqqoda!› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na7a aykkii wodhii, e aha woyine atakiltte ganccepp gaxa kessii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Yikkee, woyine atakiltte goday wayssadee? Yi7ii ye mattaye ekkeezita wodhii, woyina oothiza hara asayis immada. ");
INSERT INTO mfxl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","« ‹Gimbbizitay borii ixxeez shuchchay keeth muumer tookkiza kirkiro garkk; ubbapp aadhiz shuchch maaqqeeza. Yhay Goday ootheez bazi; ma nu aafayiskka mala bazi› Yeegizana geeshsha Maxaafepp nabbabekasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Qeese halaqitay, higge asitamaaritaynnee cimitay Yesuusa ye aazisa u faal afa aaziseezana ereez gishos eza aykkodayis koyeeza, zin asayis yashittii, ashshii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Farasaawitayppennee Herodoosa baggitaypp xiqqa asitay e odaypp buuta denggii, eza aykkodayis koyii, eziko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","U eziko yi7ii, «Asitamaarayyo, ne turo odinttizannee asapp ase shagoozana nu eriza. Ne ase shagooya; ma Xooss oge tumar taamarssiza. Nu Oroome biitta Kaat Qeesaares giira gachchizay woganee woga baasa? Giira gachchonnee ashsho?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Zin u cubbotitha Yesuusa erii, «Tana abis faaccodayis koyee? An pettii santte yhana ki7ii tana beezoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Unttii ezisi ke7eeza, «Yha mallaynnee sunthay ooso?» yeegii unttan oyceeza. Unttii, «Qeesaares» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuusa mahii, «Yeezako, Qeesaareesana Qeesaares, Xoossiisa Xoossis inggoytta» yeegin u e oda yhay mala bazi geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yhayqqeez asii dendooya giz Saduqaawitaypp pettii pettii asay Yesuusako yi7ii, yhay garkk yeegii, eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Asitamaarayyo, Muse nuus higge xaafittar, ‹Machcho ekkeez athay na7a yelekka yhayqqiko, ye yhayqqeezayis ishay e machchato ekkii, fa ishayis na7a yelodayis beeziza› yeegizana xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Binii wode laappun ishitay yezitaypp bayray machcho ekkii, na7a yelekkazar yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nam7inthay izo ekkeeza, ezkka na7a yelekkazar yhayqqeeza. Hayidzinthaykka yey garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Laappunitaykka yeyigarkk izo ekkii, na7a yelekkazar yhayqqeeza. Ubbapp guye, ma ye asitakka yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yeezin, laappunitay izo ekkeez gishos yhayqqeez asay yhayiqopp dendiza gallas, iza unttapp aayayis machcho maaqqode?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuusa mahii, «Yi balinttizay, geeshsha Maxaafita woy Xooss wolqqa erekka gishos baasa? ");
INSERT INTO mfxl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yhayqqeez asay yhayiqopp dendiza gallas, salo yez kiitanchchitay garkk maaqqodaypp attin dhiirathi asay ekkooya; maachii asitay gelooya. ");
INSERT INTO mfxl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Zin yhayqqeezitay dendo bagga maaqqiko, Xoossii Museko tusha gancce eexiz tamapp waageezako Muse maxaafaypp nabbabekkasa? Yeykka ‹Taanii, Afraame Xoossii, Isaaqa Xoossii, Yayqqooba Xoossii› yeegeezaya ");
INSERT INTO mfxl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yey gishos, e, path yezitay Xoossapp attin yhayqqeezitay Xooss baaya. Yi aqopp aadhii balinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Higge asitamaaritaypp pettay u palamizana shiiqii si7eeza. Ma Yesuusa unttis lo7ithii maheezana si7ii, «Kiita ubbapp aadhiz kiitay aaya?» yeegii Yesuusana oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuusa mahii, eziko yhay garkk yeegeeza: «Kiita ubbapp aadhiz kiita si7oytta; ‹Isreele asayis, Goday nu Xoossay pettii Goda. ");
INSERT INTO mfxl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ne Goda ne Xoossa ne kunth wozinapp, ne kunth shemppopp, ne kunth qofapp, ne kunth wolqqapp qadhdhoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma kiita ubbapp aadhiz nam7intho kiitay yhaya; ‹Ne lagga ne ubbay garkk qadhdhoba› yeegiza; yhayttitaypp aadhiz hara kiita baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higge asitamaaray Yesuusako, «Asitamaarayyo; ‹Xoossay petto. Ezapp attin hara baaya› ne geezay turo. ");
INSERT INTO mfxl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xoossa kunth wozinapp, kunth qofappennee kunth wolqqapp qadhdhizaynnee ma as ubba fa ubbay garkk qadhdhizay xuuggiz yarshshoppennee hara yarshsho ubbaypp aadhiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuusa higge asitamaaray mahithay aadho era as malisse maaqqeezana bi7ii, «Ne Xooss kaatetithapp haakkekkaya» yeegeeza; yeypp guye, Yesuusana hara baz oycodayis oonkka minggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuusa Xooss Keetha tamaarssittar, yhay garkk yeegeeza: «Higge asitamaaritay Kiristtoosa waagii fana Dawute na7a gee? ");
INSERT INTO mfxl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawute geesha Ayyana denthithin, « ‹Goday, ta Godayiko, «Taanii ne morkkita ne toke yedhdhiz aqo udod gatho, yhaydda ta ushachcha bettoba» geeza yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawute fa ubbas Kiristtoosana, «Goda gi xeegiko, yeezin, Kiristtoosa wayizii, Dawute na7a maaqqee» yeegeeza. Woyay Yesuusa gizana ufayttii si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuusa tamaarssittar, yhay garkk yeegeeza: «Higge asitamaaritaypp naaginttoytta; u aduss afila ma77ii yuuyizitannee gabellakka asay unttan bonchchii sarothizana dosiza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Unttii Ayihuditay Woosa keetha gaame lo77o oyde dosiza; maakka asii fana mokkiza aqokka bonchcho aqo dosiza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","U asii be7o gi woosa adussisttar, am7itay keetha bonqqiza; u ubbapp aadhiz pirdda ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuusa Xooss Keeth gancce muxaata oliza saaxine kale bettii, asay fa miisha ye saaxinayid olizana be7eeza; gaame dure asay gaame miishe ye saaxinate oliza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pettii manqqo am7at yi7ii, nam77ii sikkinna ye saaxintte oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuusa fa taamarita xeegii, «Ta yinttis turo odiza; muxaata saaxine gancce oleez as ubbapp yha manqqo am7at aathii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Abis giiko, yhankkitay ubbitay paas puceez miishaypp oleeza. Zin iza fa pacatipp, paas yezanno ubbar oleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuusa Xooss keethapp kezodar, e tamaaritaypp pettay, «Asitamaarayyo, yhay waafa lo77o shuchchinnee waafa lo77o shuchch keethizako ne bo7oba!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuusa mahii, «Yha damma shuchch keetha ne bi7inee? Yha keethay shuchchii shuchchal afa gimbbintteezay garkk laalinttekkazar attaamii; pettii shuchchikka attekkazar ubbitay laalinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuusa Xooss keethapp tiina baggar Debre Zayite ambal afa betteezin, Phixiroosa, Yayqqooba, Waannisannee Indiraasera wolla eziko yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Yhay ayide hanodazako, nuus odoba; yha ubbitay polinttod woda erisiza mallay abba?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuusa maakka unttis yhay garkk yeegii odeeza: «Yinttan oonkka balithaamay garkk naaginitoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gaame asay ta sunthar, ‹Taanii Kiristtoosa› yeegttar yi7ii, gaame asita balithoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Olannee ola wore yi si7eez gallas dagamippatte. Yey garkk baz hanoday attaamii, zin wurssithay haga. ");
INSERT INTO mfxl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pettii woya hara woyar olinttoda; ma pettii kaatetithay hara kaatetithar olinttoda; biitta eni7o ubba aqo hanoda; naye denidoda, zin yey ubbay yelosi maachchii iqinttiz zookegarkke. ");
INSERT INTO mfxl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Zin yi, yi ubbas naaginttoytta. Abis giiko, asii yinttan aykkii, pirdde keethis aathii immada; ma Ayihuditay Woosa Keethitayidakka yinttan alanggar alanggoda; gade aqisizitay tiinannee kaatitay tiina ta gishos yi markkattodayis eqqoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wurssithii hellodaypp tiina Wonggile as ubbayis odinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","U yinttan pirdde keeth ki7iza wodennee aathii inggiza wode waagii odode yeegii hirigipatte; ye saatate Xoossay yinttis inggiza baz odoytta. Geeshsha Ayyanay odinttizapp attin yinttan baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Ishay fa isha, adayi fa na7a aathii immada. Na7itay fana yeleezitayil afa dendii, unttan wodhoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asii ubbay yinttan ta sunthay gishos ixxoda, zin wurssithii hellodayis garzheezay attoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Zin dhabisiza tuna ooso eqqodayis beezoowa aqo eqqeezin yi be7ada.» Yey waaguusizako nabbabizay akaako! «Yihuda biitta yezitay ye wode amiba guye qosintto. ");
INSERT INTO mfxl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keethal yez athaykka pettibaz ekkodayis, fa kara gelppe. ");
INSERT INTO mfxl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gade oothol yezay fa afila ekkodayis guye maaqqippe. ");
INSERT INTO mfxl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ye wode wodeth maachitayisinnee dhanthiza maachita unttan ayye. ");
INSERT INTO mfxl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Zin yhay ubbitay hanodar woday barigo maaqqaamay garkk, Xooss woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Abis giiko, Xoossii alame medhdheez wodepp aykkii, yhanno hellodayis hanibe7ekka meto tiinappekka hanaam meto asal afa ye wode hanoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goday ye gallasitay tayiba haatithoozako, as giz oonkka attaamii. Zin e fa dooreez asay gishos ye gallasitay tayiba qanthiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ye wode oonkka yinttan, ‹Yhaya bo7oytta, Kiristtoosa yhaydda yeza woy Kiristtoosa sendayida yeza› yeegiko, yeya ammanippatte. ");
INSERT INTO mfxl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Worddo Kiristtoositayrannee worddo nabitay dendii unttis danda7inttiko, hara attozin Xoossay maraxeezitakka balithodayis mallannee malabaz beezoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Zin yi naaginttoytta; ta yinttis ubba baz tiinatii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Zin ye wode ye waayaypp guye, « ‹Awa dhumoda; agina fa foo7a kayoda; ");
INSERT INTO mfxl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Xoolinttitay salopp gufoda; ma salo yez wolqqitaykka eni7oda.› ");
INSERT INTO mfxl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ye wode as Na7ay, aadho wolqqarannee bonchchora shaara ganccer ye7odar ubbay be7ada. ");
INSERT INTO mfxl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ye wode Ee kiitanchchita kiittoda; unttikka oyddii gontte yhanigii sa7a gaxapp salo gaxa hellodayis, Xoossii dooreez asita shiishoda. ");
INSERT INTO mfxl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Aaziso balase mithapp akaakoytta; balasata furccodarannee I hayay bili7ith aykkiko bone ukkeezana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yey garkkekka, yi ye ubba baz hanizana bi7iko woday ukkii penge helleezana eroytta. ");
INSERT INTO mfxl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta yinttis turo odiza; yha ubbabazay hanod gatho yha yeletith ubbitay aadhaamii. ");
INSERT INTO mfxl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Salonnee sa7a aadhoda, zin ta qaalay ubbarakka aadhaamii. ");
INSERT INTO mfxl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Zin ye gallasannee ye saata Aday aaddapp attin hara attozin salo yez kiitanchchita maaqqin woy Na7a maaqqin oonkka erizay baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ye gallasay ayide maaqqodazako yi eroowa gishos naaginttoytta, minggoyttannee woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta yi7ithay fa kara ashshii, oge yhanigiza athay garkke. Athay fa ayllita ommar ommar ootho ayithii unttis fa oosayis mawute inggeeza; ma naagizanakka miinthii naagod garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Yey gishos, miinggoytta. Abis giiko, kara aday omathi maaqqo woy giddii bilahe maaqqo woy shugula uufo maaqqo woy wonttimaathe maaqqo ayide ye7odazako, yi erooya. ");
INSERT INTO mfxl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yi akaakekkazin e yi7ii yinttan yi genttii yezin dengaamay garkk miinggoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta yinttis odizan garkk as ubbas; miinggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paaziqa Baale bonchchiza gallasnnee boora Baale bonchchiza gallas hellodayis nam77ii gallasii atteeza. Qeese halaqitaynnee higge asitamaaritay cubbotithar Yesuusana aykkii wodhiza oge koyiza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«Asay kachchi kesamay garkk Paaziqa bonchchiz gallas oothaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuusa Bitaana katama borqqontto harger yez Simoona kara sibirel afa betteezin, pettii asita albasxirosa ginttiz bilgaaxe kunth narddoose ginttiz gaame al7o shitto ekkii ye7eeza. Ye bilgaaxato menthii shitta Yesuusa ommayil hul7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ye aqayid yez asaypp pettay pettay kacinttii, «Yha shittay cer iitizay abiso? ");
INSERT INTO mfxl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yha shittana hayidzii xeet dinnare gate kessodaya bayizii, miisha manqqitayis immadayis danda7inttizazin» yeegii fa ganccer wolla odintteeza. Yeezii, ye astto boreeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zin Yesuusa «Yha astto ashshoytta; izo abis waaythe? Iza taas lo77o baz ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Manqqitay ubba wode yinttar yeza. Yi kozheez gallas ayidekka unttan maaddodayis danda7iza, zin ta ubba wode yinttar yezaamii. ");
INSERT INTO mfxl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iza paas danda7intteeay garkk ootheeza; ma tana moogos giigisodayis tiinatii shitto tizheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta yinttis turo odiza; sa7a ubbayil Wonggile odinttiza abamaaqqikokka, asay izo hasayoday garkk yha iza ootheezay odinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taphpho nam77ii tamaaritaypp pettay Asiqoroto Yihuda ginttinttizay Yesuusana qeese halaqitayis aathii immadayis unttiko yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","U yeya si7ii ufayttii, «Nu neesi miishe immada» yeegeez gishos; Yihuda Yesuusana aathii ingodayis giiga gallas koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Boora Baale bonchchinttizaypp tiina gallas, Paaziqa katha maadayis dur shukkiza gallas Yesuusa tamaaritay eziko, «Paaziqa bonchchiza gallas ne maad katha nu aayid yhanigii makko?» gi oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuusa fa tamaaritaypp nam7ita yhay garkk yeegii kiiteeza: «Katama yhanigoytta; yi yhammadar, otar haath tookkeez pettii athay yinttan helloda; eza kaalloytta. ");
INSERT INTO mfxl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E yhanigii geliza keethattii godayiko, ‹Asitamaaray neeko, Taanii ta tamaaritayir Paaziqa maadayis imathi keethii aba yenee? yeegeeza› yeegoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kara goday yinttan pooqeel afa hiixinttii giigii yez dalge kifile beezoda; ye aqayid makkoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ye tamaaritay kezii, katama yhanigeeza; Yesuusa unttis odeezay garkk denggii, Paaziqa katha makkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa7a omathodar Yesuusa taphpho nam77ii tamaaritayir ye aqa yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","U bettii katha maadar, Yesuusa unttiko, «Ta yinttis turo odiza; yinttapp pettay taar miizay, tana aathii immada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","E tamaaritay dagamii, fa ommas ommas, «Tuma tanashsha?» yeegii eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuusa mahii, «Ye athay yi taphpho nam7itaypp petta; E taar wolla fil7o gancce kushe dakkizaya. ");
INSERT INTO mfxl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","As Na7ay, geeshsha Maxaafayid yhayqqoda geezay garkk yhayqqoda, zin As Na7a, aathii ingiza atha eza ayye. Ye athay yelinttekka atteezako eesi lo77ozin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","U maadar, Yesuusa boora ekkii, Xooss galateeza; ye boora baxxii, fa tamaaritayis ingittar, «Yashitte, yhay ta asho» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xuu7a denthii, Xooss galatii, unttis ingin ubbitaykka ye xuu7aypp uzheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesuusa, «Yhay gaame asayis goggiz oroth caaqo ta suuthii. ");
INSERT INTO mfxl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta yinttis turo odiza; taanii Xooss kaatetititha oroth woyine uzhod gallasay hellodi gatho maaqqii yha woyinaypp uzhaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mazmuure yexxeezaypp guye Debre Zayite ambal afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuusa unttiko, «Yi ubbitay tana olii ashshii laasii dhaboda; « ‹Xoossii heenggizana shocoda, duritay ubbay laalinttoda› yeeginttii xaafintteezay garkke. Yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Zin ta yhayiqopp dendeezaypp guye yinttapp tiinatii Galila aadhoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phixiroosa mahii, «U ubbitay nena olii ashshikokka, ta nena ashshaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuusa Phixiroosako, «Ta neesi turo odiza; yhayino qamma shugula nam7i tok uukkodaypp tiina ne tana hayidzii toke kaddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Zin Phixiroosa tiinaasaypp miinthii, «Ta hara attozin, neer wolla yhayqqizakokka, nena kaddamii» yeegeeza. Yhankkitay ubbitaykka yey garkk geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesuusa fa tamaaritayir Geetesemaane ginttiz aqo yhanigii; fa tamaaritayiko, «Ta Xoossa woossii maaqqod gatho yi yhaydda bettoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesuusa Phixiroosa, Yayqqoobarannee Waannisa paar ekkii qiteeza; waayintteezannee un77intteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma unttiko, «Ta shemppata yhayqqod gatho azaneeza, yhaydda gam7oyttannee; miinggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Xiqqa tiina shiiqii, sa7a xuggunii, danda7inttiza baz maaqqiko, ye waaya saatay paapp aadhoday garkk, Xooss woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma, «Aabbo, abbabbo, ubba baz neesi danda7inttiza, yha waaye xuu7a taapp haasoba. Zin ne shene hanopp attin ta shene hanippee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesuusa maaqqii yi7ii, u gentteezin denggii, Phixiroosako, «Simoona, gentteenee? Hara atto ne pettii saatekka barkkii naagodayis danda7ekkasa? ");
INSERT INTO mfxl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Paace gancce yi gelaamay garkk barkkii naagoyttannee Xoossa miinggii woossoytta. Ayyanay, giigintteezin ashay daabura» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Maakka yhanigii tiinaasay garkk Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yhattekka e guye maaqqii unttiko ye7odar gentteezin denggeeza. U aafa gentta goozii gaddeez gishos eziko ab mahodazakokka erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hayidzintho unttiko yi7ii, «Yhanno hellodayiskka genttallannee shemppol yenee? Yikkee, gidoda; saatat helleeza; bo7oytta! As Na7ay, nagaranchcho asayis aadhii inginttod woday helleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yikkee dendoytta yedhdhoytta; bo7oytta, tana aathii ingiza athay helleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuusa yeya haga ododar, e taphpho nam7i tamaaritaypp pettay, Yihuda, ellisii helleeza. Ma qeese halaqitay, higge asitamaaritaynnee cimitay kiittin, mashshannee gufe aykkeez gaame asay ezar wolla ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesuusana aathii ingoday ye gaame asayis, «Ta yeerizay eza; eza aykkii, lo7ithii naagii, ekkii kanggoytta» yeegii mala odii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yihuda helleezan garkk Yesuusako shiiqii, «Asitamaarayyo» yeegii Yesuusa yeereeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ye gaame asay Yesuusana aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","E tamaaritaypp pettay fa mashsha shoddii qeese halaqay aylla shocii, e haytto qadhdhii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuusa mahii, asayiko, «Yi Tana paanno aykkizay garkk aykkodayis mashshannee gufe aykkii ye7eenee? ");
INSERT INTO mfxl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta Xooss Kara gancce taamaristtar, gallas gallas yinttar yezin tana aykkekkazar, geeshsha Maxaafay geezay polinttodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E tamaaritay ubbitay eza olii ashshii laasii dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Laxana aadda ma77eez pettii yelaga athay Yesuusa kaalo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Zin ye athay laxana olii ashshii, xiira kallo laasii dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Asay Yesuusa qeese halaqay kara kanggeeza. Ezayid qeese halaqitay, cimitaynnee higge asitamaaritay shiiqii yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phixiroosa qeese halaqay zabba hellodayis haakor eza kaallii yhanigii ezayid naagizitayir bettii tama kazhiza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Qeese halaqitaynnee pirdde shanggitay ubbitay Yesuusa wodhodayis ezal afa markka koyeeza, zin abkka denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gaame asay ezal afa worddo markkatteeza, zin u markkitethay pettii qaala baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Pettii pettii asitay dendii eqqii Yesuusal afa, «E, ‹Taanii asii keexxeez yha Xoossa Keeth laalii, asii kushe keexxinttekka hara Xooss Keethi hayidzii gallasa gancce keexxod› godar nu si7eeza» yeegii worddo markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maaqqozin, u markketithay petto baaya. ");
INSERT INTO mfxl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Qeese halaqay as ubbitay tiinayid dendii eqqii, «Yhayttay nena mootiza mootayis ne mahizbaz baasa?» yeegii Yesuusana oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Zin Yesuusa si77e geeza; abkka mahekkaya. Qeese halaqay, «Anjintteez Xooss Na7ay, Kiristtoosa nenannee?» yeegii mahii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuusa mahii, «E tana, yi As Na7ay, woliqqama Xoossapp ushachch baggar betteezininnee salo shaarar ye7odar be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Qeese halaqay shener fa afila peedhii, «Nuna hara ab markka koshshee? ");
INSERT INTO mfxl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yi e cashsha si7eeza; yinttis ab aazee?» yeegeeza. Unttii ubbitay, «E yhayqqodayis beeziza» yeegii ezal afa pirddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Unttapp pettay pettay ezal afa cutii e aafa goolii zhultittar, «Nena yhadhdheezay oonoo? An nuus odoba!» yeegeeza. Naagizitay eza garafittar ekkii yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phixiroosa qeese halaqay zabbayid yeekk baggar yezin, qeese halaqay gadhindditaypp pettat ize ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phixiroosa tama kazhodar iza dakkii bi7ii, «Neekka Naazirete Yesuusar yeza bay» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Zin Phixiroosa, «Ne gizay abizako ta erooya, taas akaakinttooya» yeegii kaadeeza. Yeegii maaqqii e bale kezeezan garkk shugula uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ye gadhinddata Phixiroosa bi7ii, i lanqqe eqqeez asitayiko, «Yha aththaykka unttar yeza» gi mahii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Zin Phixiroosa maakka kaadeeza. Xiqqa gam7odar, lanqqe eqqeez asitay maakka Phixiroosako, «Ne Galila biitta as maaqqeez gishos tuma unttar yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Zin Phixiroosa, «Ta yi giz atha erooya!» yeegii fana baaddithnnee caaqo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Izir shugula nam7intho uukkeeza. Phixiroosa Yesuusa eziko, «Ne shugula nam77ii tok uukkodaypp tiina hayidzii tok tana kaddoda» eziko geezay elqqi gin yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wontt guur ellisii qeese halaqitay, cimitay, higge asitamaaritaynnee Pirdde shanggo ubbitay shiiqii tobbeeza. U Yesuusana accii kanggii Philaaxoosas aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philaaxoosa eziko, «Ne Ayihuditayis kaato?» yeegii oyceeza. Yesuusa mahii, «Ne geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qeese halaqitay Yesuusana gaame baza mooteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Zin Philaaxoosa mahii Yesuusako, «Nees mahizbaz baasa? U neell afa ab garkk mooto ki7izako be7aamo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Zin Yesuusa hara baz mahaam ixxin, Philaaxoosa malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Philaaxoosas Paaziqa Baale bonchchiza gallas asitay koyiz pettii atha achchapp bili7iz woga yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ye wode pettii Bairbaana giz athay daafa kessii shemppo wodhdheez asitayir wolla achch kara yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gaame asitay Philaaxoosak yi7ii kaseesay garkk oothod garkk eza oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philaaxoosa asana mahii, «Ta yinttis Ayihuditay kaata bili7odana koynee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yha e geezay, qeese halaqitay Yesuusa qinaate aathii inggeezana eriz gishosii. ");
INSERT INTO mfxl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Zin qeese halaqitay Bairbaana billoday garkk, ye shiiqeez asitay Philaaxoosa woossoday garkk asita denthitheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philaaxoosa mahii, «Yeezin, yi Ayihude kaate gizana wayisaday garkk koyee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asitay Philaaxoosal afa uukkii, «Mazqalel afa eza sottoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philaaxoosa asayiko, «Abiso? e ab iita baz ootheenee?» yeegeeza. Zin asay tiinaasaypp gujjii uukkii, «Mazqalel afa eza sottoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philaaxoosa asa ufayssodayis koyii, Bairbaana asayis bili7eeza; yeypp Yesuusana alanggii, mazqalel afa sottoday garkk aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yeypp guye, wottaaddaritay Yesuusa Praytoora ginttiz wottaddartay zabba ekkii kanggii, hara wottaaddarita ubba xeegiseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma zoqo afila eza ma7iseeza; angguthi zawude kochchii, e ommayid gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yeypp guye, eziko, «Ayihuditay kaatayyo saro» yeegii, ees kushe dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","E ommayid gufer shoceeza; ma ezal afa cutteeza; xuggunii eesi goynneeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eza leqqeezaypp guye zoqo afila eepp qaarii ekkii, e afila eza ma7isi mazqalel afa eza sottodayis ekkii kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","U yhanigttar, Iskkinddirerannee Rufoosa ada, Simoona giz Qerena gade as, gaxarepp katama yi7izana hellii, Yesuusa mazqalana wolqqanthii toosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yeezii Golggotta giz aqo Yesuusa kanggeeza. «Golggotta» guussay «Omma ota» guussii. ");
INSERT INTO mfxl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Karbe giz dhaler walakintteez woyine uzho gi ees inggeeza. Zin e uzhaam ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","U mazqalel afa eza sotteezaypp guye oona abii hellodazako gi e afilayil wolla ixa olii shaginttii ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","U mazqalel afa eza sottodar wonttapp hayidzii saate. ");
INSERT INTO mfxl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Unttii, «Ayihuditay kaata» yeegii eza mootiza xuufe xaafii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesuusar nam77ii paannita petta ezpp ushachch baggar yhankka ezpp haddirss baggar mazqalel afa sotteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Geeshsha Maxaafe, «Iita baz ootheez asitayir e tayibintteeza» yeegintteezay polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Oger aadhiz asay Yesuusa toochchii, fa omma eni7isii cazheeza; «Yeezin! Xooss kara laalii hayidzii gallasa gancce keexxizayyo, ");
INSERT INTO mfxl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","an mazqalaypp sulle wodhdhii nena ashshoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yey garkkekka, qeese halaqitay higge tamaarssizitayir wolla Yesuusa toochchii «Yhankkita ashsheeza, zin fana ashshodayis danda7ooya; ");
INSERT INTO mfxl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","nu bi7ii ammanod garkk Kiristtoosa, e Isreele Kaatizako, an mazqalaypp yhatti wodhdho» yeegeeza. Ma hara attozin, ezar mazqalel afa sotintteezitaykka eza toochcheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Usuppun saatepp aykkii, uddufun saate hellodayis biitta ubbay dhumeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uddufun saatel Yesuusa fa qaala dhoqqi udii, «Elohee, Elohee, laama sabaqitanii?» yeegii uukkeeza. Yeya guussay, «Ta Xoossayyo, ta Xoossayyo, tana abis ashsheene?» guussii. ");
INSERT INTO mfxl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ya aqayid eqqeez asaypp pettay pettay yeya si7ii, «Yeezako, Eelaasa xeegiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ye asaypp pettay laasii, zanizar caala woyine kunth; gufe xeeral gaddii, «Naagoytta; Eelaasa mazqalaypp eza wothodayis ye7odazako an wolla be7ada» yeegii Yesuusa doonayiko ushshodayis shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuusa fa qaala dhoqqi udii uukkii, yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Xooss kara sotintteez magarazhay afapp sa7a hellodayis, nam7i kezii per7inttii wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mazqalaypp tiina baggar ezayid eqqeez pettii mato halaqay, Yesuusa wayizii yhayqqeezako bi7ii «yha athay tuma Xooss Na7a» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ya haakor eqqii bi7iza maachchitay yeza. U gancce Magdeela Mayirama, geedo na7a Yayqqoobasinnee Yoosa indat Mayramirannee Saloomira yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ye maachch asitay Yesuusa Galila biitta yez wode eza kaallezitannee eza mokkeezita. Ma Yesuusar wolla Yerusalaame yhanigeez hara gaame maachchi asitay ezayid yeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sa7ay omarsseez gishos shiiqeez asay gancce bonchchintteez Ayihude shanggitaypp pettay, Yooseefa giz athay, Xooss kaatetithay ye7oda giittar yezay, Armmatasa katama asay ye7eeza. Wonttitha mala wonttiza gallas maaqqeez gisho Yooseefa miinggii Philaaxoosak yhanigii, Yesuusa aha ekkodayis woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philaaxoosakka Yesuusa yhayiqa si7ii malabaz geeza; mato halaqa xeegii, «E yhayqqii gam7eenenee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Philaaxoosa Yesuusa yhayiqa mato halaqaypp si7ii e aha Yooseefas inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yooseefa moogo afila wonggii; Yesuusa aha mazqalaypp wothii, afilar xaaxii, zaallapp woocintteez duufo gancce moogeeza. Ma ye duufay doonayid damma shuchch goli7isii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdeela Mayiramira Yoosa indat Mayiramira Yesuusa aha unttii aba gaddizako bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maala gallasay aadheezaypp guye Magdeelawe Mayramo, Yayqqooba indat Mayramannee Saloome yhanigii, Yesuusa aha tizhodayis shitto wonggeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wogga gallas guura zherkkizherkko xalqqe kezodar, duufo yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","U fa gancce pettatii pettatira, «Duufay doonapp nuus shuchch oonoo gol7isii haasoday?» yeegii wolla odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","U be7adar ye damm atteez shuchchay goli7alii hali7eezana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yesuusa moogintteez duufay gancce gelodar pettii yelaga athay booth afila ma77ii, ushachch baggar betteezana bi7ii dagammeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Zin E unttiko, «Dagammippate; mazqalel afa sotintteez, Naazirete Yesuusa yi koyizana ta eriza. E yhaydd baaya, yhayqqopp dendeeza. U eza moogeez aqa yhaya bo7oytta. ");
INSERT INTO mfxl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yhatti yhanigii Yesuusa tamaaritayisnnee Phixiroosas, ‹Yesuusa yinttapp tiinatii Galila aadhiza. E yinttis odeezay garkk yi eza ezayid be7ada› yeegii odoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maachchitay yashshar kukkurttar duufaypp kezii laasii qiteeza. Ma u yashitteez gishos yeya ooskka abikka odekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuusa yhayqqopp dendeezaypp guye wogga gallas guura, laappun tuna ayyanita izpp e kesseez Magdeela Mayramis tiinatii bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iza yhanigii tiina ezar yezitayis, u azanttarannee yeekkittar yezin odeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Zin Yesuusa pathi yezanannee izis bentteezana u si7eez wode iza giza ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yeypp guye, unttapp nam7itay katamapp kezii yhammadar, ogella Yesuusa tiinaasaypp dummatii unttis bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","U guye maaqqii, hara asayis odeeza, Zin hara asaykka u oda tuma geekkaya. ");
INSERT INTO mfxl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Guyepp taphpho pettii e tamaaritay katha maadar, Yesuusa unttis bentteeza. Unttis ammano baazay gishonnee yhayiqopp e dendeezana be7eez asay odin u ammanaam ixxeezayis e unttan boreeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E unttiko, «Biitta ubbayil yhanigii as ubbayis Wongile odoytta. ");
INSERT INTO mfxl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ammaneezaynnee xammaqintteezay attoda, zin ammanekkazay pirddinttoda. ");
INSERT INTO mfxl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ammanizitayis yha malatitay inginttoda. U ta sunthayir tuna ayyanita kessoda, oroth doona nashshoda. ");
INSERT INTO mfxl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","U shoosh aykkiko woy wodhiza baz uzhikokka unttan qohaamii. Ma u fa kushe hargintteezitayil afa gaddii unttan pathoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Goda Yesuusa tamaaritayira nashsheezaypp guye pude dendii salo kezeeza; Xoossapp ushachch baggar betteeza. ");
INSERT INTO mfxl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E tamaaritay yhanigeez aqo ubbayid qaala odeeza. Godaykka unttar wolla oothiza. U odiza qaalay tuma maaqqeeza Xoossay unttisi ingiza mallayir fa qaala miintheeza.");
INSERT INTO mfxl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bonchcho Toofiloosa, nu gancce polintteez baza gaamitay, paasi danda7intteezay garkk xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ye taarika u xaafeezay tiinapp aykkii aafe markkitayinnee qaala odii maaddizitay nuus odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Taakka ta baggar tiinapp akaakii be7eezaypp guye ye taarikay hana lo7ithii nees Toofiloosas xaafay taas lo77o maaqqii bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yeykka, ne tamaareez bazay tuma maaqqeeza erisodayissii. Xammaqiza Waannisa yelintto ");
INSERT INTO mfxl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yihuda kaat Herodoosa wode Abiya baggapp maaqqeez Zakkireesa giz Ayihude qeesay yeza. E machchatakka Aaroona sheeshippe. I sunthaykka Elssabeexo. ");
INSERT INTO mfxl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nam7aykka Goday wogannee azaza ubba naagii borso bayith Xooss tiina xillotithar yeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elssabeexa dhoonth maaqqeez gisho unttis na7a baaya. Nam7aykka cimeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pettii gallas Zakkireesa fa tarar Xooss tiina qeesetitha oothiza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Qeesetith wogar Xooss kara gelii ixaannee cuyishshodayis eza ixa helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","E Ixaannee cuyshshodar asay bale eqqii woossiza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Goday kiitanchchay yarshsho yarshshiza aqaypp ushachch baggar eqqii bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkireesa kiitanchchana bi7ii dagammii iita yashittii pokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Zin kiitanchchay eziko, «Zakkireesa yashitippe; ne woosay sintteeza. Ne machchat Elssabeexa dhiirathi na7a yeloda, e sunthakka ne Waannisa goda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","E nees ufayssi maaqqoda; gaamitay e yelinttayid ufayttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Goday tiina E ubbaypp bayira maaqqoda; woyne ushshii maaqqin hara mathisiz ushshii uzhaamii. Fa indat ulo yezar Geeshsha Ayyanar kumoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isreele asitayipp gaamita u Goda Xoossayiko mahoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aditay wozina na7itayiko mahoda, kiitinttoozita xillitay ecetithayiko mahodaygarkk, Godayis beeziza asa giigisodayis Eelaasa ayyarannee wolqqar Goday tiinar yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkireesa kiitanchchayiko, «Ta yeya abar erodee? Taarannee ta machchatir cimeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiitanchchay mahii, «Ta Xooss tiina eqqiza Gabreele. Yha mishiraachcha nees ododayis Xoossapp kiitintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yikkee, woday helin polinttiza ta qaala ne ammanaam ixxeez gisho yhayi polinttod hellodayis ne muume maaqqoda, odinttodayiskka danda7aamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ye wode Zakkireesa Xooss kara gelii gam7eez gisho abi haneezako gi asay bale naagttar gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","E bale kezii unttar nashshodayis danda7ekkaya. Kusher mallii beezoppe attin odinttodayis danda7oozana bi7ii abukka be7eezaygarkk qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkireesa yarshsho woda wurssii fa kara maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yeyppe guye, e machchat Elssabeexa wodexxeeza. Ichchin agina muume keethapp kezekkazar gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iza, «Goday fa maarotithayir ta borintta asay ganccepp qaarodayis koyii yhaya ootheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elssabeexa wodexin usuppuntho aginar, Xoossii kiitanichcha Gabreelena Galila biitta yez Naazirete katama kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ezii wuddiritiko Dawute sheeshapp maaqqeez Yooseefa giz athayis ushintteez Mayiramiko kiittintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiitanchchay iziko yhanigii, «Aadho keehatithar kumeezannee, saro nees maaqqo, Xooss neer yeza» yeeggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayrama e odayid iita dagammii, «Yhayi waafa sarotho» gi qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiitanchchay mahii, «Mayirame, yashittippe; ne Xooss tiina Saaba dengeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yikkee ne woddexxoda dhiirath na7a yeloda, e sunthakka Yesuusa gi sunthoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E gita maaqqoda, Ubbaypp Aadho Xooss na7a ginttinttii xeeginttoda. Xoossay E aday Dawute zufaana ees inggoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","E Yayqqooba sheeshal afa medhinas kawutoda; e kaatetithayis zawa baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayirama kiitanchchayiko, «Ta dhiirath erooya Yeyi wayizii hanodayis danda7ee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiitanchchay mahii, «Geeshsha Ayyana neell afa wodhdhoda, Ubbap Aadho Xooss wolqqay neell afa kuyatoda. Yey gisho, yelinttiza na7ay geeshsh, Xooss Na7akka ginttinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yikkee, ne dabbat Elssabeexa fa cimatith laythar dhiirathi na7a woddexxeeza. Iza dhoonth ginttintteezano, zin yhatte usuppuntha agina aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoossa gamizbaz baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayirama, «Yeezako, taas Goday ayllatis, ne qaalay garkk hano» yeegeeza. Yeyppe guye, kiitanchchay iippe shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mayirama ye saaminttate dendii Yihuda biitta yez pettii gezze katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkireesa kara gelii Elssabeexo sarotheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elssabeexa Mayiramii sarotha si7eezannii garkk I ulo yez na7ay ufayisar doonggeeza. Elssabeexa Geeshsha Ayyanar kumii, ");
INSERT INTO mfxl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fa qaala dhoqqi udii, «Neenii maachchitay gancceppe anjjintteezano, ne wodexeez na7aykka anjjintteezaya. ");
INSERT INTO mfxl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hano zin, ta Goday indatee, ne taako ye7odayis ta oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yeezako ne sarotha ta si7in ta ulo yez na7ay ufayisar doonggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Goday polod gi inggeez qaala ammaneezana, iza anjjitteezano» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayirama yhayigarkk yeegeeza: «Ta shemppata Goda bonchcheeza, ");
INSERT INTO mfxl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta Ayyanay ta dhale Xoossal ufayttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","E fa ayllatii kawushshatitha be7eeza. Yhayinope aykkii yeletithi ubbay tana anjjitteezano goda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wolqqama maaqqeez E, taas dammabaz ootheeza. E sunthaykka Geeshsha. ");
INSERT INTO mfxl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eza bonchchizitayil afa, e maarotithay medhinapp medhina hellodayis yeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Fa miinth qesayir fa wolqqa beezeeza, fa wozinar utirttizita laaleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wolqqanthiza kaatita u zufaanaypp wodhiseeza; fana toochcheezita dhoqqi udeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nayintteezita lo77o bazar mishsheeza, durita kallo kushe dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Fa maarotitha qoppii, Fa aylla Isreele maaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yeykka nu aditayis odeez qaala, Afraamesinnee e sheeshayis geezana medhinas polodayisii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayirama Elssabeexi lanqqe hayidzii agina gam7ii fa kara maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elssabeexis yelo qammay hellin dhiirath na7a yeleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I shooritaynnee I dabbitay Goday gaame maarotith ootheezana si7ii, izir wolla ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hosppuntha gallas duude na7ana dookalodayis ye7eeza. Na7ana aday sunthayir Zakkireesa gi xeegodayi koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Zin indat, «yey hannena Waannisa giinttinttodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Unttikka, «Ne dabbitaypp yha sunthayir xeegintteezay oonkka baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","E aday oona gi sunth gaddodazako erodayis kozhii eza mallar oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","E xaafiza baz oyccii ekkii, «E sunthay Waannisa» gi xaafeeza. Ubbay E xaafezana bi7ii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Izir Zakkireesa iranthay bilintteeza, Xooss galatittar odintto aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Shooritay ubbitay yashshar kumeeza. Yha haneezibazay Dhoqqi geez Yihuda gade ubbayid odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yeya si7eez ubbay, «Yha na7ay ab hanodeshsha» gi woli gancce odintteeza. Goday kushay ezar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Waannisa aday Zakkireesa Geeshsha Ayyanar kumii yhay garkk yeegii tinbbite odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Isreele Goday Xoossay galatintto, yi7ii fa asa wozeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Fa ayllay Dawute kara atotithi kace dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yeykka binii wode geeshsh nabitay doonayid odintteezay garkk, ");
INSERT INTO mfxl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ezii nuna nu morkkitayppennee nuur eqinttiza ubbitay kusheppe ashshoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yeya E ootheezay nu aditayis fa maarotithi beezodaysinnee, fa geesh caaqa naagodayis. ");
INSERT INTO mfxl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nu ada Afraames caaqqeez caaqa qoppodaysinnee, ");
INSERT INTO mfxl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nu morkkitay kushepp kessii, yashsha bayith eza oothoday garkkesii. ");
INSERT INTO mfxl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nu layth ubbayid geeshshetitharannee xillotithar fa tiina nuna essodayisii. ");
INSERT INTO mfxl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma ta na7ayyo, ne Ubbapp Aadho Xooss nabe ginttinttoda. Godayis oge loythodayis ne e tiina yhammada. ");
INSERT INTO mfxl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Unttii atotith eretith demmadana, u nagaray atto ginttinttin, ne Goday woyayis ododa. ");
INSERT INTO mfxl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nu Xoossay fa keeha maarotithayir wontta xalqqe nuus salopp kessoda. ");
INSERT INTO mfxl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yeykka dhuma ganccennee, yhayiqo kuya oommo yezitayis poo7isodayis, nu tokakka saro ogeko mahoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na7ayikka dicceeza, Ayyanarakka miinggeeza, Isreele asayis benttod gatho liizho demba yezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ye wode Oroome biitta yez as ubbitay taybinttod garkkennee sunthay xaafinttod garkk kaat Awugisxoosa azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yeykka Qerenoosa Soore biitta aqisiza wode haneez tiina woya tayiba. ");
INSERT INTO mfxl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yey gishos, pettii pettii asii fa sunthi xaafisodayis fa yelintteez biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yooseefakka Dawute karappennee kochchapp maaqqeez gishos Galila Naazirete katamapp denddii Dawute katama ginttiz Beeteleme yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","E oyccii gaddeez wolqqa iita, Mayramir wolla xaafinttodayis Yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Unttikka ezayid yezin iis yelo wode helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Fa bayra na7a yeleeza. Qanxxora xaaxii imathii aqiz aqo aqo dhabeez gishos mehe galla muziz goonna gancce woyitheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ye gadayid qamma wude heenggitar qaa7el aqiz mehe heenggizitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Goda kiitanchchay yi7ii unttis bentteeza. Goday bonchcho poo7ay u lanqqayir poo7eeza; unttikka wolqqama yashsha yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kiitanchchay unttiko, «Yashittippatte! Yikkee as ubbayis maaqqeez gita ufayssa mishiraachcho ta ekkii ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yeykka, Dawute katama ashshizay yinttis yhayino yelintteeza. E Goda Kiristtoosa. ");
INSERT INTO mfxl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yeyisikka mallay yhaya. Xiqqa na7ay qanxor xaaxintt goonna gancce woyi7eezana yi demmada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Qoppekkazin gaame salo kiitanchchitay kiitanchchayir wolla benttii, Xoossa galattittar, ");
INSERT INTO mfxl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Bonchcho Xoossis dhoqqe salo, saro biittal afa Xooss qadhdhiza asayis maaqqo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiitanchchitay unttapp shaakinttii salo kezeezaypp guye mehe heenggizitay, «Ane Goday nuus qoncciseezi bazannee haneez baza be7adayis Beeteleme wolla yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Unttikka ellisii yhanigeeza. Mayiramo, Yooseefa, yeyppe xiqqa na7ay goonna gancce woyi7eeza denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bi7ii maaqqii na7ay bagga unttis odintteezana ye aqayid yez asayis geeshshii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yeya si7eez ubbay mehe heenggizitay odeez oda malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayirama haneezibaza ubba fa wozinar qoppitar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mehe heenggizitay unttis odintteezay garkk hanin be7eeza. Yey gisho, u fa si7eezibazisinnee be7eezi baz ubbayis Xoossa bonchchitarannee galatittar maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hosppuntha gallas, dookalintodayis qamma hellin, eza wodexxodaypp tiina kiitanchchay gaddeez sunthayir Yesuusa gintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muse higgay garkk unttii shaagishe wode polintteezaypp guye Yoosefarannee Mayiramir na7a fa Godayis immadayis Yerusalaame yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yeykka, Goday higgayid, «Dhiirath maaqqeez bayra na7a ubbay Godayis shaakintteeza maaqqo» yeeginttii xaafintteezay polodayisii. ");
INSERT INTO mfxl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma Goday higgayid, nam77ii hero woy holle geezay garkk yarshshodayis kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye wode geeshshinnee ammanor miinth maaqqeez Simoona ginttinttiz athay Yerusalaame yeza. E Isreelitay atotithi naagttar yeza. Geeshsha Ayyaanaykka ezal afa yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Xoossii dooreez Kiristtoosa be7ekkazar yhayqqaamana Geeshsha Ayyanay ees beezin erii yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eza ye gallas Ayyana kaalithin Xooss kara yhanigeeza. Na7a indatirannee adayir woga polodayis na7a Yesuusa ekkii geleez wode ");
INSERT INTO mfxl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoona mokkii ekkii na7ana idinggii, Xoossa galatitar. ");
INSERT INTO mfxl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Godayyo ne taas geleez qaalay garkk, yhatte ne aylla saro moyzoba. ");
INSERT INTO mfxl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta aafay as ubbay tiina ne giigiseez, ");
INSERT INTO mfxl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne atotitha be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yeykka Ayihude baa as ubbayis, Xooss tumatith beeziza poo7o, ne asay Isra7eelitayiskka bonchcho» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yoosefarannee Mayramira e bagga odintteezana malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoona unttan anjjeeza. Indat Mayiramiko, «Isreele yez gaamitayis u pokkithayisinnee denddayis Xoossapp doorintteeza. Ma ixxizitayis malla maaqqada ");
INSERT INTO mfxl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne shemppayirakka azanno mashsha aadhoda» Yikkee gaame asay wozina geemmeez qofay benttoday garkk yeya geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma Aseere kochchapp maaqqeez Faanu7ela na7ata Haanna ginttinttiz nabata yeza. Iza iita cimeeza; iza fa azinayir laappun laythi betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","I azinay yhayqqin hosppun tamannee oyddii laythi maaqqoda gatho qammannee gallas pacce bayith woosarannee xoomar Xooss Keetha oothiza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iza ye saatayid yhanigii Xoossa galateeza; Yerusalaame wozintta naagiza ubbayis na7ay bagga markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoosefarannee Mayiramira Goday higgayid azazintteez woga ubbita poleezaypp guye Galila biitta yez fa katama Naazirete maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na7ay diccittarannee ayyanar minggittar yhanigeeza. Ecetithar kumeeza; Xooss aadho keehetithay ezal afa yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yoosefarannee Mayramir Faaziqa Baale bonchchodayis laythar laythar Yerusalaame yhanigiza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuusas taphpho nam77ii laythi maaqqiz wode kasepp oothizay garkk baala bonchchodayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baala bonchcheezaypp guye kara maaqqodar na7ay Yesuusa Yerusalaame atteeza. Zin Yoosefarannee Mayramir E Yerusalaame atteezana erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E kara maaqqiz asayir wolla yeza aazin unttii pettii gallasa oge yhanigeeza. E baazana ereezaypp guye fa dabbitayanee fa laggitay lanqqe koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","E ezayid dhabin koyttar guye Yerusalaame hellodayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Haaydzi gallasapp guye Xooss Keetha asitamaaritay gancce bettii u odizana si7ittarannee unttan oycittar yezin dengeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eza si7iz ubbitay e akaakannee e mahiz malssa malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kara asay eza dengeez wode yhay malabaz geeza. E indatakka, «Ta na7ayyo, abis nuna yhay garkk ootheenee? Ne adayirannee taar nena koyttar daabureeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesuusa unttiko, «Tana abis koyee? Ta, ta aday keetha yezodayis beezizana yi eroosa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Zin E unttiko geezana unttii akaakekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yeyppe guye, unttar wolla Naazirete katama yhanigeeza. Unttis kiitinttittar yezeeza. E indat ye ubbita fa wozina gaddii naageeza. ");
INSERT INTO mfxl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuusa, ecetithar, eqamar, deetteer Xooss tiinannee as tiina dicceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kaatay Xibaaroosa Oroome biittal kawutin, taphpho ichchintho laythar, Phenxxe Philaaxoosa Yihuda aqisiza layithi Herodoosa Galila aqisiza layithi e isha Filphoosa Ixuurasannee Xirakkonddoosa aqisiza wode Lisanoosa Abilaanisana aqisiza wode ");
INSERT INTO mfxl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haannarannee Qayyaafara qeese halaqa maaqqii yezin, Xooss qaalay Zakkireesa na7a Waannisako liizho gadha ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Waannisa, «Yi nagaraypp maaqqoyttannee xammaqinttoytta. Xoossay yi nagara atto goda» yeegii tamaarssittar Yorddanoosa borkka heera yez biitta ubba yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yeykka nabe Isiyaasa fa maxaafayid, «Liizho gadha fa qaala dhoqqi udii, uukkiza athay qaalay, ‹Godayis oge lo7ithoytta, goossakka pidd udoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Loophpha ubbitay kumo, ambaynnee deray ziqqii go. Wobbo ogay luulo, giigekka goossay qinxxii go. ");
INSERT INTO mfxl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Asho ma7eez as ubbitay, Xoossii ashshizana bo7o› » gi xaafintteezay haneeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Waannisa, e kusher xammaqinttodayis ye7eez gaame asayiko, «Yinttano, shooshii na7untho ye7odayis yez bochaypp buuttod garkk yinttan zoreezay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yikkee, yi maaqqitha beeziza lo77o ooso oothoytta, yi wozinar, ‹Nuus, nu aday Afiraame yeza gi gaayirppatte.› Yhana si7oytta, yha shuchchitaypp Xoossay Afraames na7a kessodays danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yeezako, gande minxxayis xaphayid yeza. Yikkee, lo77o aafe aafowa mith ubbitay gachinttii tama gancce wodhdhoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Asay, «Yeezin nuunii ab ootho?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Waannisa mahii, «Nam77ii afila yeza asii baazayis inggo. Katha yezay baazayis shago» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qaraxe gachisizitay xammaqinttodayis yi7ii, «Asitamaarayyo, nu ab udo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","E mahii, «Yinttan kiitteezanpp aathii ekkipate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma wotaaddaritay yi7ii, «Nu abi udo» yeegii oyiceeza. Waannisa, «Obazikka wolqqar dafi ekkippate, oonakka worddor mootippate, yi damoozay yinttis gidoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asay Kiristtoosa ufayisar naagttar yeza gisho Waannisa, «E Kiristtoosa maaqqadeshshaa?» yeegii u fa wozinayid qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Waannisa ubbitayis mahii, «Taanii yinttan haathar xammaqiza, Zin taapp aadhii wolqqamizay ye7oda. Taanii e caammay wodora billodayis beezooya asii. E yinttan geeshsha Ayyanarannee tamar xammaqoda. ");
INSERT INTO mfxl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wudumma yez katha geeshshodayis pithay e kushayid yeza. Geezheez katha fa shaalayid qoloda; bunnana dhaboowa tamar xuuggoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma Waannisa asa gaame zore zorii Wongile sabbakeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Zin Waannisa Herodoosa fa ishay machchat, Heroodiyada, ekkeez gishonnee hara iita oosita ootheez gishos kacceez wode ");
INSERT INTO mfxl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodoosa kasesayil afa hara iita baz ubba gujjii Waannisana woyne geliseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Woyay ubbay xammaqqintteezaypp guye, Yesuusakka ma xammaqintteeza. E woossodar salo dooyintteeza, ");
INSERT INTO mfxl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Geeshsha Ayyanay holle garkke maaqqii ezal afa wodhdheeza. Salopp «Taanii qadhdhiza na7ay nena; ne tana ufayssiza yeegiz» qaala ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuusa taamarsso aykkiz wode ees hasttam laythi zini, asay eza Yooseefa na7a gi qoppeeza. Yooseefa Eele na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eele Maate na7a, Maate Lewe na7a, Lewe Milkka na7a, Milkka Yoona na7a, Yoona Yooseefa na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yooseefa Mataate na7a, Mataate Amoxe na7a, Amoxe Nahoome na7a, Nahoome Asiliime na7a, Asiliime Naage na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naage Ma7aate na7a, Ma7aate Mataatiye na7a, Mataatiye Samaye na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Samaye Yooseefa na7a, Yooseefa Yooda na7a, Yooda Yoonanne na7a, Yoonanne Rase na7a, Rase Zerubaabela na7a, Zerubaabela Salatiyaale na7a, Salatiyaale Neera na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neera Milkka na7a, Milkka Haade na7a, Haade Qoosame na7a, Qoosame Elmodaannee na7a, Elmodaannee Eere na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eere Yoosee7e na7a, Yoosee7e Alaazara na7a, Alaazare Yoorame na7a, Yoorame Maaxate na7a, Maaxate Lewe na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewe Simoone na7a, Simoona Yihuda na7a, Yihuda Yooseefa na7a, Yooseefa Yoonanne na7a, Yoonanne Eliyaaqeme na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaaqeme Maliyye na7a, Maliyye Maynaane na7a, Maynaane Maaxate na7a, Maaxate Naatane na7a, Naatane Dawute na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawute Issaye na7a, Issaye Iyobeede na7a, Iyobeede Boo7eeza na7a, Boo7eeza Salmoona na7a, Salmoona Na7asoona na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na7asoona Aminadaba na7a, Aminadaba Raame na7a, Raame Arnna na7a, Arnne Asroome na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Asroome Paarese na7a, Paarese Yihuda na7a, Yihuda Yayqqooba na7a, Yayqqooba Isaaqa na7a, Yisaaqa Afraame na7a, Afraame Taar na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Taar Naakkore na7a, Naakkore Saruuge na7a, Saruuge Rehu na7a, Rehu Faalaqa na7a, Faalaqa Ebeera na7a, Ebeero Seela na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seela Qaynaame na7a, Qaynaame Arfakisaada na7a, Arfakisaade Seeme na7a, Seeme Nohe na7a, Nohe Laame na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamehe Matusaala na7a, Matusaala Inooke na7a, Heenooke Yaarede na7a, Yaarede Malali7eela na7a, Malaal77ela Qaynaane na7a, ");
INSERT INTO mfxl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Qaynaane Heenosa na7a, Heenose Seete na7a, Seete Addaama na7a, Addaama Xooss na7a. ");
INSERT INTO mfxl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuusa geeshsha Ayyanar kumii Yorddanoose borkkapp maaqqodar Geeshsha Ayyanay eza liizho gadha kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ezayid oyttam gallasinnee qamma xalaher paacintteeza. Ye gallasita abikka meekkazar gam7eez gishos wurssithal nayintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xalahe eziko, «Ne Xooss na7a maaqqiko ane yha shuchcha soollo maaqqo gi azazoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuusa mahii, «Asii Xooss qaalarapp attin soollo aadda yezooya ginttinttii geeshsha maxaafayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yeypp guye, Xalahay Yesuusa adusse derell afa kessii yha alame kaatetititha ellissii beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xalahe, «Yha ubbitayill mawutennee bonchcho taas ingintteeza. Taanii qadhdheez ooskka inggiza gishos nees immada. ");
INSERT INTO mfxl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yey gishos, neenii taas goynniko ubbitay nees maaqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuusa mahii, «Ne Goda, ne Xoossayis, aadda goynnoba, eza aadda aggazoba yeeginttii geeshsha maxaafayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wurssithal Xalahay Yesuusa Yerusalaame kanggii Xooss Keethis kusittel afa essii, «Neenii Xoossa na7a maaqqiko ane sulle sa7a guppii wodhdhoba. ");
INSERT INTO mfxl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Abis giiko, « ‹Nena naagiz fa Kiitanchchita, Xoossay ne gishos kiittoda. ");
INSERT INTO mfxl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ne tokay shuchchar dhubinttaamay garkk, u fa kushayir nena denthoda› yeeginttii xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuusa mahii, «Ne Goda Xoossa paaccippe ginttinttii Geeshsha maxaafayid xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Xalahay Yesuusa paacita ubba wursseezaypp guye hara giiga wode demmad gatho ezipp shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuusa Geeshsha Ayyana wolqqar kumii Galila maaqqeeza. E waaray heera yez biitta ubbayil si7intteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","E Ayihuditay Woosa keetha gelii taamarsseeza; asii ubbay eza galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yeypp fa dicceez katama Naazirete ye7eeza. Tiin oothizay garkk maala gallas Ayihuditay Woosa keetha geleeza. Nabbabodayiskka denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nabe Isayaasa maxaafay ezis ingginttin, xaatha billii, yhay garkke yeegii xaafintteezana denggeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Goda Ayyanay taal afa yeza, manqqitayis Wongile odod garkk Xoossay tana tizheeza. Acintteezitayis bilithi, to7itay be7ad garkk un77intteezita bili7od garkk, ");
INSERT INTO mfxl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xoossay keehodayis qoppeez laytha odod garkk tana kiiteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yeypp guye, maxaafa xaaxii aggaazizayss inggii betteeza. Ayihuditay Woosa Keetha yeza asay ubbay dakkii be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","E, «Yhayi yi hayer si7iz yha maxaafe qaalay yhayino polintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ubbitay e bagga lo77o odinttiza. Ma e doonapp keziz aadho keehatithar kumeez qaalar malabaz giittar, «Yhayi Yooseefa na7a baasanee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","E, unttiko « ‹Neno akimayyo nena ashshoba, yeegiz aaziso nashsha ta si7aamii yey garkk Qifirnahoome ne ootheez baz nu si7eezana ma yhaydda ne katamayid oothoba› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Maakka ta, «Tuma odiza; nabe fa yelintteez biitta bonchchinttooya yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Ta yinttis turo odiza; Nabe Eelaasa layth hayidzii laythinnee bagga salo gorddinttin iita naye biitta ubbayil yez wode gaame azinii baa maachitay Isreele yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eelaasa u ubbitayis kiitinttekkaya. Zin Seraptta gade yeza azinii baa pettii asitiko kiitintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nabe Elssa7e wode Isreele gaame borqqontto harger yez asay yeza. Zin Soore atha Ni7imaanepp attin oonkka geezhekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayihuditay Woosa Keethi yez as ubbitay yeya si7eez wode gaame kacceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Fa betteez aqaypp denddii ambal afa keexxintteez katamapp gaxa kessii urqqii dakkodayis amba xeera kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Zin E u ganccer aadhii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ezaypp Galila biitta yez qifirnahoome katama yhanigeeza. Ezayid maala gallas asa taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","E qaala tamaarssizay mawuter yez as garkk maaqqeez gishos ubbitay e timirtta malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayihuditay Woosa Keetha tuna ayyana aykkeez athay yeza. Ezii fa qaala dhoqqissii ukkittar ");
INSERT INTO mfxl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Naazirete Yesuusa nees nuur abi yenee? Nuupp haakkoba; ne ye7eezay nuna dhabisodayissonnee? Neenii oonazako taanii eriza. Neenii Xoossapp ye7eez xillaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuusa tuna ayyaanaykko, «Si77e gi yha athaypp kezoba» yeegii kacceeza. Tuna ayyanay atha as ubbitay tiina shocii olii abikka qohekkazar ashshii kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","As ubbitay malabaz gi. Woliko, «Hanos, yhayi aba timirtte? Tuna ayyanita mawuterannee wolqqar kiitiza; unttikka keziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","E waaray heera ubbayil kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yeyppe guye, Yesuusa Ayihuditay Woosa keethappi kezii Simoona kara geleeza. Simoona machchat indat iita oxe misha harger hargintteeza. Izo pathoday garkk Yesuusa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I hiixaykko shiiqii zuggii I hargga kacceeza. Mishay ashshin ellisii dendii unttan mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Awa gelod hanodar duma duma harggayir aykintteez asa eziko ke7eeza. E pettayil pettayil afa fa kusha gaddii patheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tuna ayyanitay ma, «Neenii, Xooss na7a» yeegii ukkittar gaame asaypp kezeeza. Zin E unttan kacceeza. E Kiristtoosa maaqqizana unttii eriza gishos pettibazikka odod garkk koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Haga sa7a wonttodar Yesuusa pettii geema aqo yhanigeeza. Asay koyttar E yeza aqa ye7eeza. Unttapp E shaakinttii yhanggaam garkk eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Zin E, «Taanii hara katamitayid yhanigii Xoossa kaatetithii Wongile markattodayis beeziza. Ta kiitintteezay yey gishosii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yihuda biittal yez Ayihuditay Woosa Keetha ubba wuttii sabbakeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pettii gallas Yesuusa Gensareexe Abba lanqqe eqqeezin gaame asay e kantta ukkii urqqinttittar, E taamarssizana Xoossa qaala si7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ezayid abbay gaxa yez nam77ii wogolita be7eeza. Molo aykkiz asitay wogolitaypp wodhdhii fa gita meecciza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ye wogolitaypp Simoonaare gelii biittapp xiqqal gedi abay ganccel shiishoday garkk oyceeza. Yeezii, ye wogolatayid bettii asa wongile taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Fa tamaarssa wurisseezaypp guye Simoonako, «Gede ciimmayiko shiishii molo aykkodayis yi gita oloytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoona mahii, «Asitamaarayyo, qamma muda daaburittar aqi abikka aykkekkaya, zin ne giiko neqaalayir gita nu oloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","U gita oleez wode gitay peedhinttod gatho gaame molo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hara wogolo gancce yez fa zhamitay yi7ii, fana maaddod garkk wuttii xeegeeza. U yi7ii nam77ii wogolita, haathay gancce mitinttod gatho molo kuntheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoon Phixiroosa yeya be7eez wode Yesuusa tiina xuggunii, «Godayoo, taanii nagaranchcho as maaqqeez gishos taapp shaakinttoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yeya E geezay ezinnee ezar yezitay aykkeez molay gaametithayir malabaz maaqqeez gishos. ");
INSERT INTO mfxl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma Simoona zhame maaqqeez Zabidoosa na7itay Yayqqoobarannee Waannisara malabaz geeza. Yesuusa Simoonako, «Yashittippe! Yhanpp neenii as aykkiz as maaqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","U wogolita gaxa shiisheezaypp guye ubbita ashshii Yesuusana kaalo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuusa katamitaypp pettayid maaqqii yeezin pettii boriqontto harger aykintteez asii ye katamayid yeza. Ye athay Yesuusa bi7ii e tiinayid xuggunii, «Godayyo, ne shene maaqqiko tana geeshshodayis ne danda7iza» gi woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuusa fa kusha dakkii bochchii, «Ee, ta shene; geezhoba» yeegeeza. Izir athay geezheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuusa, «Yhaya ooskka odippe, zin yhanigii nenatitha qeesa beezoba. Ne geezheezayis markka maaqqod garkk Muse kiitteez yarshshana yarshshoba» gi azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Maaqqozin, Yesuusa waaray kasepp aadhii dalggittar yhanigeeza. Gaame asay E odiza baz si7odaysinnee fa hargepp paxodayis yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Zin ezii ubba wode fa aaddas geema aqo yhanigii woossiza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pettii gallas Yesuusa tamaarssodar Galilappera Yihuda heera ubbaypp ma Yerusalaameppekka ye7eez Ferasaawitayira higge asitamaaritay ezayid betteeza. Asa pathiza Goday wolqqaykka ezar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye wode asay pettii sila as halar tookkii ke7eeza. Kara gelisii e tiinayid gaddodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Zin as darotithaypp kara gelsodayis gaminttii keethal afa kezii, siittingaa qawuxxii, harggintteez atha halar asa shagii Yesuusa tiina wotheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuusa u ammana bi7ii, «Naat athayyo, ne nagaray atto ginttintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Higge asitamaaritaynnee Ferisaawe asay, «Yhayi Xooss cazhizay oonoo? Pettii Xoossapp attin hara nagara atto godayiss danda7izay oonoo?» yeegii qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuusa u qofa ereez gishos unttiko, «Yi wozina gancce yey garkk abis qoppee? ");
INSERT INTO mfxl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹Ne nagaray ucintteeza gizayppenne dendii yedhdhoba gizayipp aayi lo77o?› ");
INSERT INTO mfxl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Zin ta yeya geezay As Na7ay biittal afa nagara uccodayis mawute yezana yi erodgarkke.» Yeypp maaqqii, sila athayko, «Denddii; ne arssa tookkii ne kara yhanigoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E ellithii denddii u tiina eqqeeza; E tookinttii ye7eez arisa tookkii Xoossa galatittar fa kara yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ye wode ubbitaykka malabaz geeza. Xoossa galatittar, «Yhayino nu damma malata be7eeza» yeegii yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yeypp guye, Yesuusa yeypp kezii yhanigittar. Lewe ginttinttiz pettii qaraxe gachisizay qaraxe gachisiza aqo betteezana bi7ii, «Tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","E ubba baz ashshii denddii eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ye Leway fa kara dammo sibire giigiseeza. Gaame qaraxe gachishizitayinnee hara asay katha maadayis betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farasaawitayira higge asitamaaritay, «Qaraxe gachchisizitayrannee nagara oothizitayir abis mi uzhee?» yeegii Yesuusa tamaaritayir eza zigireeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuusa unttiko, «Harggntteezttaypp attin pathi asis akime koshshooya. ");
INSERT INTO mfxl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taanii nagara oothizitta maarotithiko mahodayispp attin geeshshita xeegodayis ye7ekkaya» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","U Yesuusako, «Waannisa tamaaritay gaame xoomiza, ma Ferisaawitay tamaaritaykka yey garkk oothiza. Zin neesitay ubba wode miizay uzhizay abiso» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuusa unttiko, «Machcho ekkizay unttar yezin laazanthitay xoomoday garkk oothodayis danda7inee? ");
INSERT INTO mfxl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Zin machcho ekkizay unttapp shaakinttod gallas ye7oda, ye wode unttii xoomoda.» ");
INSERT INTO mfxl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma yeegii aaziso odeeza; «Orothi ma7opp peedhii cima afilall afa sikkiza oonkka baaya. Yey garkk oothiko oroth afila per7iza, orothay cimayis giigooya. ");
INSERT INTO mfxl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mal7antto woyine cima ogoro gancce buulliz oonkka baaya. Yeya oothiko, mal7antto woynay cima ogora dhuusiza; woynay laalinttiza ogoraykka adooya. ");
INSERT INTO mfxl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yey gishos, mal7antto woyne orothi ogoro gancce buulinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yikkee, ka7eezay lo77o giz gishos ka7o woyne uzhii maaqqii mal7antto koyizay oonkka baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pettii maala gallas Yesuusa gade ganccer aadhiza. Yesuusa tamaaritay bangga tizhzha duuthii fa kusher mirkkii miiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Zin Ferisaawitay ganccepp pettay pettay, «Maala gallas oothodayis nu higgayid beezoowa baz abis oothee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuusa unttiko mahii, «Dawute nayintteez wode paar yezitayira wolla oothizana yi nabbabekkasa? ");
INSERT INTO mfxl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xooss keetha gelii Ayihuditay qeesitay aaddas beeziza daabbo meeza; paar yezitaysikka inggeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma Yesuusa, «As Na7ay maalas Goda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hara maala gallasi Yesuusa Ayihuditay Woosa keethi gelii taamarissiza. Ye aqayid ushachchi kushe sileez pettii asii yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Higge asitamaaritayinnee Ferisaawe asay eza mootodayis sankke kozhii maala gallas pathiko be7ada gi naagiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Zin Yesuusa u qofa erii kushay sileez athayko, «dendii asay gancce eqqoba» yeegeeza, athaykka denddii eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesuusa, «An ta yinttan pettibaz oyiciza; maala gallas oothodayis beezizay lo77o bazonee iitabazo? Shemppo ashonnee dhabiso?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma Yesuusa e lanqqayir yez asa ubba yuuyii bi7ii athayiko, «Ne kusha piddi udoba» yeegeeza, athaykka E geezan garkk udin kushay paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Zin higge asitamaaritaynnee Ferisaawe asay iita yiladheeza. Yesuusal afa ab udo gi wolla tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ye wode gallasitaypp pettii gallas Yesuusa woossodayis derell afa kezeeza. Qamma muda Xoossa woossittar aqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wonttitha fa taamarita xeegii u ganccepp taphpho nam7ita doorii, unttan, «Hawaarita» gi xeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Unttikka, Phixiroos gi xeegiz Simoona, e isha Indiraase, Yayqqooba, Waannisa, Filphoosa, Barttolomoosa, ");
INSERT INTO mfxl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatoosa, Toomaasa, Ilfoosa na7a Yayqqooba, fa biittayis micinttiz Simoona, ");
INSERT INTO mfxl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yayqqooba na7a Yihudarannee Yesuusa aathii inggeez Asiqorontto Yihuda. ");
INSERT INTO mfxl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuusa hawaaritayir wolla derellapp wodhdhii denba aqo eqqeeza. E tamaaritaypp gaamitay ye aqayid yeza. Yihuda biitta ubbapp Yerusalaameppe, Xiroosappennee Sidoona abba gaxapp gaame asay e taamarssiza baz si7odaysinnee fa hargepp faxodayisi ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tuna ayyanar metinttiza asitaykka yi7ii paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pathiza Wolqqa ezipp kezii asii ubba pathiza gishos asay eza bochchodayis koyiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Fa tamaaritayiko bi7ii yhaygarkke yeegeeza: «Yinttano, manqqitayyo, yi anjjintteezita; Xooss kaatetithay yinttisii. ");
INSERT INTO mfxl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yi yhatti nayinttizitay anjjintteezita, yi mizhoda. Yi yhatti yeekkizitay anjjintteezita yi miiccoda. ");
INSERT INTO mfxl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Asay yinttan ta gisho, As Na7ay gishos ixxiza wode yinttan piliza wode yinttan u toochchiza wodennee, iita sunthi u yinttis inggiza wode yi anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Yeezako, yi gatay salo damma maaqqeez gishos ye wode ufayisar guppoytta. Abis giiko, binii u aditay nabitayil afa yhay garkk udeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Zin durttayyo yinttan ayye; yi yhatti lo77o yessi ekkeezita. ");
INSERT INTO mfxl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yhatti mizheezitayyo yinttan ayye; yi nayinttoda. Yhatti miiccizitayyo abo yinttanoshsho yi kayadhodannee yeekkoda. ");
INSERT INTO mfxl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Asii ubbay yi lo77otitha aadda odiz wode yinttan ayye. U aditay binii worddo nabitayil afa yhay garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Zin tana si7iz yinttis ta odiza; yi morkkita siiqoytta; yinttan ixxizitayis lo77o baz oothoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yinttan baaddizita anjjoytta, yinttan naaqqizitayis woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pettii bagga shanggala baqqizitayis yhankko baggaka beezoba. Ne Koota ekkoda gizayis ne shaamizhakka gujjii inigoba. ");
INSERT INTO mfxl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nena woossiza ubbayis inigoba; neeppi ekkeez oonakka maho gi oyccipp. ");
INSERT INTO mfxl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asay yinttis oothod garkk yi koyiz baz ubba yinttikka asis oothoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Yi yinttan qadhdhiza asa aadda qadhdhiko, aba galata yinttis yenee? Hara attozin, nagaranchchitayikka fana siiqizita siiqiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yinttis lo77o baz oothizitayis aadda lo77o baz oothiko yinttis aba galata yenee? Nagaranchchittaykka yhay garkk oothiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tali7e mahod asis aadda yi tali7iko ab duma galatinttinee? Nagaranchchittaykka guye mahod asii bi7ii tali7iza.» ");
INSERT INTO mfxl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Zin yi morkkita siiqoytta; unttis lo77o baz oothoytta. Guye ekkodayis qoppekkazar tali7oytta. Yeyid yi ekkod gatay damma maaqqoda. Yi Ubbaypp Aadho Xooss na7ita maaqqoda. E fana galatoozitayssinnee iititayiskka keeha. ");
INSERT INTO mfxl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yi aday maariza maaqqeezay garkke yinttikka maarizita maaqqoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Asal afa pirddippate; yinttal afa pirddinttamii. Yi borinttaamay garkk oonakka borippate. Atto goytta; Xoossay yinttis atto goda. ");
INSERT INTO mfxl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Inggoytta; yinttis inginttoda. Yi makkeez bazar yinttis maaqqii makinttoda, ubbarakka lo77o makkiz bazar baqqii, suuddii kunthii, laalinttodar yinttis makinttii inginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Maakka Yesuusa yeegii unttis aaziso odeeza; «To7ay to7a kaalithodayis danda7inee? Kaalithiko nam7itaykka woli ekkii gaga qitossannee? ");
INSERT INTO mfxl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamaaray asitamaaraypp aadhooya. Zin lo7ithii tamaareez athay fa asitamaaray garkk haniza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ne ishay aafayid yeza buuxa abis ne bi7inee? Ne aafayid yeza tuuss aazizana abis bo7oosaa? ");
INSERT INTO mfxl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne aafayid yeza tuuss aazizana be7ekkazar ne ishayiko, ‹Ta ishayyo ne aafayid yez buuxa kesso› godayis wayizii danda7ee? Neno cubbayyo, tiinattii ne aafayid yez tuuss aazizana kessoba. Yeypp guye, ne ishay aafayid yez buuxa kessodayis ne geeshsii be7ada. ");
INSERT INTO mfxl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Lo77o mithii iita aafe aafooya; yey garkkekka iita mithii lo77o aafe aafooya. ");
INSERT INTO mfxl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aafe aafiz mith ubbay fa aafer erinttiza. Angguthapp Balase aafe maxinttoya ma gom7orepp woyne aafay maxinttoya. ");
INSERT INTO mfxl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lo77o as fa wozina gancce kumeez lo77o bazapp lo77o baz kessiza. Iita asii fa wozinayid kumeez iita bazapp iita baz kessiza. Asii fa wozina kumii fucceezaypp fa doonar odiza. ");
INSERT INTO mfxl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ta gizana oothowazar, abis tana, ‹Godayyo, Godayyo, gee?› ");
INSERT INTO mfxl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taako yi7izayinnee ta qaala si7ii poliza ubbitay oona aazizako ta yinttan beessada. ");
INSERT INTO mfxl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E keeth keexxodayis wodhisii, olla bookkii, oommo yez zaallayil afa keethi esseez eca atha aaziza. Di7o di77ii ye keetha urqqeeza, zin miinthii keexxeez gishos eni7odayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Zin ta qaala si7ii oothoozay fa keetha shafel afa keexxeez atha aaziza. Di7o di77ii ye keetha urqqeez wode ellis woddeeza. Ye keethay woddithikka wolqqama maaqqeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuusa yeya ubba as tiina tamaarssii wurisseezaypp guye, qifirnahooma katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ye aqayid pettii mato halaqay yeza. E gaame qadhdhiza ayllay hargginttii yhayiqos helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E Yesuusa bagga si7eez wode fa aylla pathoday garkk eza woosso gi Ayihuditay cimita Yesuusako kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiitintteezitay, Yesuusako yhanigii, «Ne eesi yhaya oothodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Abis giiko, yha athay nu asa qaadhiza, Ayihuditayis Woosa Keethakka keexxeeza» gi miinthii woosseeza ");
INSERT INTO mfxl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuusakka unttar yhanigeeza. Mato halaqay karako ukkodar fa laggita eziko kiittii, «Godayyo, ta keethayid ne gelodayis taas beezekka gishos daaburippe. ");
INSERT INTO mfxl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Taakka tana ne tiina shiiqodayis beeziza as gi qoppooya. Zin ne yhan ize eqqii pettii qaala odoba; ta ayllay paxoda. ");
INSERT INTO mfxl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taas taapp afar halaqay yeza, taapp oommor ta kiittiza wotaaddaritay yeza. Petta, ‹Qitoba› giiko qittiza, yhankka, ‹yhana ye7oba› giiko yi7iza. Ta aylliyakko, ‹Yhanno oothoba› giiko oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuusa yeya si7eez wode malabaz geeza. Guye maaqqii yhanigii asayiko, «Ta yinttis turo odiza; hara attozin Isra7ele ganccekka yhay garkk gita ammano ta denggekka» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiitintteezitay kara maaqqadar ayllay paxin denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wontitha gallas Yesuusa Nayine katama yhanigeeza. E tamaaritayirannee hara gaame asay ezar yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E katama gelod hanodar aha tookkeez gaame asay katamapp kezeeza. Yhayqqeez na7ay fa indatis petto, izakka am7o. Katama asaypp gaamitay izir yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Goday izo bi7ii qadhinttii, «Yeekkippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shiiqii hala bochchin tookkeez asay eqqeeza. Yesuusa, «Naat, yelagayyo denddoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yhayqqeezay denddii bettii nashsha aykkeeza. Yesuusa na7a denthii indatis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","As ubbitay yashittii, «Ubbapp aadhiz nabe nu gancce denddeeza; Xoossay fa asita be7eeza» yeegii Xoossa galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","E waaray Yihudaninne ye heerayid yez biitta ubbayil sintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xammaqiza Waannisa tamaarttay yeya ubbita Waannisas odeeza. E u ganccepp nam7ita xeegii, ");
INSERT INTO mfxl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Ye7od giinttintteezay nenanee? Woy hara naago?» yeegii oycoytta gi Godayiko kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asay Yesuusako yhanigii, xammaqiza Waannisa, «Ye7od giinttintteezay Masay nenanee? Woy hara nu naago?» goytta gi nuna neeko kiiteeza yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ye saatatte Yesuusa gaame asa hargepp patheeza. Tuna ayyanita kesseeza, gaame to7eez as aafitakka bi7iseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Waannisa kanttapp kiitinttii ye7eezitayko, «Yhanigii yi be7eezanannee si7eezana Waannisas odoytta. Aafe to7itay bi7iza, gundditay bili7inttii yedhdhiza, borqqonttor yezitay geezhiza, tullitay si7iza, yhayqqeezittay yhayiqopp denddiza, manqqitayis Wongilay sabbakinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Taal dhubinttowa oonkka anjjintteezaya.» ");
INSERT INTO mfxl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waannisa kiitteezitay yhanigeezaypp guye Yesuusa woyayis Waannisa baz yeegii odeeza: «Yi ab be7adayis liizho kezeene? Carkko eni7issiza maqa be7adayisonee? ");
INSERT INTO mfxl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yeezin, ab be7adayis kezeene? Bonchcho afila ma7eez asa be7adayisinne? Bonchcho afila ma77ezitaynnee sa7a giigeez asay kaati keetha yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yeezin, ab be7adayis kezeene? Nabe be7adayisonee? Ee, ta yeegiza: yi be7adayis kezeezay nabepp aadhizana. ");
INSERT INTO mfxl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","«‹Ne oge ne tiina giigisiza ta kiitanchcha neeppi tiina ta kiittoda› yeeginttii xaafintteezay yhayis ezissii. ");
INSERT INTO mfxl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta yinttis odiza; maachchapp yelintteezitay ganccepp Waannisapp aadhizay baaya. Xooss kaatetititha ubbapp xiqqizay, E ubbappi damma maaqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hara attozin, Yesuusa qaala si7eez qaraxe gachizitayinnee as ubbay Waannisa kushe xammaqqintteezitay Xoossay geesh maaqqiza qoncciseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Zin farasaawitayinnee higge asitamaaritay Waannisa kushe xammaqinttaam ixxii Xooss qofa leqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuusa maaqqii yhay garkke yeegeeza: «Yikkee, yha wode yeletitha abar aazisode? Unttikka oona aazee? ");
INSERT INTO mfxl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gabe gancce bettii woli xeegii, ‹Nu yinttis impillitte puggin, yi yexxooya. Nu sabbii zelalin, yi yeekkooya› yeegiz na7ita aaziza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xammaqiza Waannisa soollo meekazarannee woyine uzhekazar yi7in, ‹Iita ayyanayir yeza yi geeza.› ");
INSERT INTO mfxl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","As Na7ay miitarannee uzhittar yi7in, yha athay ‹Zhinbaraannee ushshii dosiza, qaraxe gachchisizitannee nagara oothizittay dabbo› geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Eccetithii turo maaqqizay fa na7atira erinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferisaawitaypp Pettay Yesuusa katha muzodayis fa kara xeegeeza. E Ferisaaway kara yhanigii leematel afa betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ye katama gancce pettii nagaranchcho maachchi yezana Yesuusa Ferisaaway kara sibirel afa yezana si7eez wode lo7ithii al7o albasxirosa bilggaaxe shitto ekkii ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesuusas guye baggar, e tokay kale eqqii yeekkittar e toka fa aafuthar laakitheeza. Fa binanayir e toka uccittarannee yeerittar shitto tizheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sibirana maakez Ferisaaway yeya bi7ii fa wozinar, «Yhayi nabe maaqqeezako yha asita eza bochchizanna oonazako ma iza waafa nagaranchcho maaqqeezako E erodazin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuusa, «Simoona, ta neesi odiza baz yeza» yeegeeza. E, «Asitamaarayyo, taas odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuusa eziko, «Nam77ii asay peetii athaypp miishe tali7eeza. Pettay ichchin xeet dinnare yhankkay ma ishatam dinnare tali7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nam7itaykka tali7e ciggodayis gaminttin, nam7tayiskka tali7eezana maareeza. Yikkee, yha nam7itaypp ye atha lo7ithii dosoday nees aaya aazee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoona, «Gaame aco maarintteez athay gaame qadhdhoda aaziza» yeegeeza. Yesuusa, «Ne tuma pirddeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yeyppe guye, Yesuusa asttiko maaqqii bi7ii, Simoonako, «Yhanno astto ne bi7inee? Taanii ne kara gelin hara attin ne taas toke haath inggekkaya, Zin iza ta toka fa aafuthar laakithii fa binanayir ucceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne tana yeerii ekkekkaya, Zin iza ta ne kara geleezaypp aykkii ta toke yeero ashshekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neenii ta ommayil zayite tizhekkaya, Zin iza ta toka shitto tizheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iza tana gaame qadhdheez gishos I gaame nagaray atto ginttintteeza. E xiqqa nagaray atto giinttintteezay xiqqal qadhdheeza.» ");
INSERT INTO mfxl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuusa asitiko, «Ne nagaray atto ginttintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ezar wolla bettii miizitay, «Nagara atto yeegizay, E yhayi oonoo?» yeegii fa wozinar qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuusa asitiko, «Ne ammanay nena ashsheeza; saro qitoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yeyppe guye, Yesuusa Xoossa kaatetithii Wonggile sabbakittar katamarannee heerar aadheeza. Ye wode taphpho nam7itay ezar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ma tuna ayyaanappennee duma duma hargepp paxeez pettii pettii maachchitay ezar yeza. Unttikka, laappun tuna ayyanitay kezeez Magdeela Mayramo, ");
INSERT INTO mfxl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herodoosa shuumay Kuuza machchat Yohaanna, Soosinaranne ma hara gaamitay unttan miisher maaddizitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gaame asay duma duma katamappi eziko shiiqin aazisor unttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Pettii biitta oothii aqizay zerithi zerodayis kezeeza. E zerodar pettii pettii zerithay ogel wodhdhii yedhdhintteeza, salo kafitay meeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yhankkitay sisinqqo oommor yeza biittal afa wodhdheeza. Haga doleezanii garkk biittay laako baazay gishos miicceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hara zerithay ma anggunthi gancce wodhdheeza. Agunthar wolla dicceez gishos angguthay cuullii aqayid ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yhankkitay lo77o biittal afa wodhdheeza. Doleez wode xeet kushe aafeeza.» Yeya odii haasii, fa qaala dhoqqi udii, «Si7iz haye yeezii ubbitay si7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E tamaarttay, «Yha aazisays birshshithay abba?» yeegii oycceeza ");
INSERT INTO mfxl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","E, «Xoossa kaattetith xuura baz erod garkk yinttis ingintteeza. Zin hara asay bi7ittar denggaam garkk, si7ittar akaakam garkk aazisor odiza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Yikkee, yha aazisays birshshithay yhay: zerithi yeegintteezay Xooss qaala. ");
INSERT INTO mfxl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oge gaxa wodhdheez zerithay qaala si7izita. Maaqqozin, unttii ammanii attam garkk Xalahay qaala u wozinaypp maxii haasiza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sisilqqo yez biitta afa wodhdheez zerithay qaala si7ii ufayisar ekkizita. U yhattes ammanizapp attin xapho baa gishos paace helliza wode ellis kaddiza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aniguthi gancce zerintteezitay qaala si7izita. Unttikka alame qofar, duretitharannee sa7a yessi hanin cuulinttii beezizay garkk aafekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lo77o biittal wodhdheez zerithay lo77onnee luule wozinar qaala si7ii naagizitannee danda7ar miinggii aafe aafizita. ");
INSERT INTO mfxl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Xomppe xomppii, ota gancce woy arssapp oommor gaddizay baaya. Geliza asii be7ad garkk dhoqqe aqo gaddiza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«Yey gishos, qosintteezay pidhdhe kezekkazar, kamintteez baz, benttekkazar attaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«Yikkee, yi qaala wayizii si7izako naaginttoytta. Yeza ubbayis guzhinttii inginttoda, baazayis hara attozin ezis yeza xiqqatakka ezapp ekinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuusa indatirannee ishitayira eziko ye7eeza. Zin asitay gaametithaypp dendeezayid eza denggodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pettii asii Yesuusako, «Ne indatira ne ishitayira nena koyii bale naagiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesuusa mahii, «Xooss qaala si7ii oosol peeshshizitay ubbay taas indonnee taas ishe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pettii gallas Yesuusarannee e tamaaritayira wolla wogolo gancce gelii, «Abba piinggoda» yeegeeza. Unttikka yhammadayis denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Abbal afar unttii piinggodayis yhammadar Yesuusa gentteeza. Qoppekkazin wolqqama carkko abbal afa denddeeza. Haathay wogolo gancce gelin wogolay mitintto aykkin ubbay yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","E tamaaritay eziko shiiqii, «Nu Godayyo, nu dhabooho yeegii» Yesuusa dentheeza. Yesuusa denddii carkkannee gota seereeza. Ellisii carkkayinnee gotay hayizii cicirkki geeza. Sarotithaykka maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesuusa fa tamaaritayiko, «Yi ammanay aba yenee» yeegeeza. Unttikka, yashittitarannee malabaz giittar pettay pettayiko, «Carkkonnee haathii kiitinttizay, E yhayi oonoo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Abba piinggii Galila baggar yez Gerggesoone biitta helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuusa wogolopp kezii sa7a wodhdhodar tuna ayyanar aykintteez athay katamttipp kezii eza helleeza. Gaame layth afila ma77ekkazar kallo duufo gancce yezaypp attin kara gelooya. ");
INSERT INTO mfxl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesuusana be7eez wode e tiinayid xuggunii, fa qaala dhoqqi udii, «Ubbapp Aadho Xooss na7a Yesuusa neer taas aba pettetithi yenee? Hayyana tana yhatti bixxisppe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yey E geezay, tuna ayyanay athaypp kezod garkk Yesuusa kacceez gishosi. Gaame wode tuna ayyanay eza mooddeez gishos santhalaaterannee toke acciz biraatar accinttii naaginttiza. Zin achcha duuthii tuna ayyanar laaginttii liizho geliza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuusa, «Ne sunthay oonoo?» yeegii oyceeza. E, gaame tuna ayyanitay eza aykkeez gishos fana, «Leegona» geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tuna ayyanitay fana ciimmo kiittaamgarkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ye aqayid derell afa miiz gudaylle wude heengginttiza. Yha guddayllitayll nu gelo gi woosseeza, ezikka «Geloytta» geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tuna ayyanitay athaypp kezii guddayllitayll geleeza. Wuday derellapp sulle gurgguxii abba gancce geleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Heenggizitay haneezana bi7ii woxxii yhanigii, katamannee heera ubbayil odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Asay haneezibaza be7adayis kezii Yesuusako ye7eeza. Tuna ayyanay kezeez athay afila ma77ii, e wozinay maaqqin, Yesuusa toke kale betteezana denggii yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eza be7eez asay tuna ayyanar aykintteez athay wayizii paxeezako odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerggesoone lanqqayid yeezii asay gaame yashsha yashittii Yesuusa fa gadaypp yhanigodgarkk woosseeza. E wogolo gancce gelii guye maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tuna ayyanay kezeez athay Yesuusar yezodayis woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Zin Yesuusa eziko, «Ne kara maaqqoba, Xoossay ab garkk dammabaz nees ootheezako odoba» yeegii moyizeeza. Athaykka Yesuusa ab garkk dammabaz ezis ootheezako katama ubbayid markkattittar qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asay naagii gam7eez gishos Yesuusa maaqqiz wode mokki ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ayihuditay Woosa Keethi halaqa maaqqeez Iyaroosa giz athay fa kara ye7odgarkk Yesuusa tokayil afa wodhdhii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ees taphpho nam7i laythi maaqqeez pettii maachchch na7a yezanna hariginttii yhayiqos hellii yeza. Yesuusa yhanigodar asay eza un77itheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Taphpho nam77ii laythi suuthii goggittar gam7eez asita yeza. Iza paas yeezii shala ubba akimitayis inggii wurseeza. Zin paxodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iza Yesuusas guye baggar shiiqii, e afila manchchato bochcheeza, izira goggiz suuthay eqqii atteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuusa, «Tana bochcheezay oonoo?» yeegeeza. Ubbay «Nu bochchekkaya» yeegin, Phixiroosa, «Asitamaarayyo, gaame asay kaallodarannee urqqithodar bi7ittar wayizii, ‹Tana bochcheezay oonoo?› gee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Zin Yesuusa, «Pettii asii tana bochcheeza; abis giiko, wolqqa taapp kezeezay taas erintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ye asita, ibazi qosinttekkazana erii kukkurittar yi7ii Yesuusa tokayil afa wodhdheeza. Abis bochcheezakkonnee wayizii ellisii paxeezako as ubbitay tiina markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E, «Ta na7ate, ne ammanay nena patheeza; saro qitoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuusa nashsha wurssekkazin, Ayihuditay Woosa Keethi halaqay, Iyaroosa karapp pettii asii yi7ii, «Iyaroosa, ne na7ata yhayqqeeza; yikkee asitaamara cere daaburssippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zin Yesuusa yeya si7ii Iyaroosako, «Yashittippe! Ammanobapp attin, ne na7ata paxoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesuusa Iyaroosa kara helleezan garkk Phixiroosa, Waannisa, Yayqqooba, na7atii adayppennee indattippe attin hara as gelod garkk koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ye aqayid yez asay ubbitay na7atis woo woo gi yeekkodar, Yesuusa, «Yeekkippate! Na7ata gentteezapp attin yhayqqekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Asay na7ata yhayqqeezana eriza gishos e oda leqqii miiceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Zin Yesuusa na7atii kusha aykkii, «Bushitte denddoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na7atis shemppay maaqqin ellis puthuk gi denddii eqqeeza. Yesuusa unttiko, «Iziss miizibaz inggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na7atii adayirannee indatir malabaz geeza. Zin Yesuusa yhaya, «Ooskka odippate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuusa taphpho nam77ii hawaarita faako xeegii, tuna ayyanita kessod garkkennee harge ubba pathod garkk wolqqannee mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xooss kaatetithii baz markkattod garkk hargintteezita pathod garkk kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","E unttiko, «Gufe maaqqin qurbo maaqqin katha maaqqin miishe maaqqin laammii ma77iza afila maaqqin oges gi abikka aykkippate. ");
INSERT INTO mfxl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ye katamapp yi kezod gatho imathettithar yi geleez aqo gam7oytta. ");
INSERT INTO mfxl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Oonkka yinttan mokaam ixxiko ye katamapp kezittar unttis erisiza markka maaqqod garkk yi toke yez buli7a pittii kezoytta.» ");
INSERT INTO mfxl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Unttikka kiitintteezay garkk kezii Wonggile odittar duma duma heera hargintteezita pathittar aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galila biitta aqisiza Herodoosa Yesuusa ootheez baz ubba si7ii dagameeza. Abis giiko, pettii pettii asay Waannisa yhayiqopp denddekka attenna yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baggitay, «Eelaasa bentteeza» giza; yhankkitay ma, «Binii nabitaypp pettay yhayiqoppi denddeeza» yeegii odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Zin Herodoosa, «Waannisa qoodhe ta gachisii wodheeza. Yeegin, yhay garkk yeeginttii e bagga odinttizay, E oonoo?» yeegii Yesuusana fa aafer be7adayis koyiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Taphpho nam77ii hawaaritay guye maaqqii yi7ii, unttii ootheez baz ubba Yesuusas odeeza. E unttan ekkii Beetesayida katamapp lanqqe yez aqo kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Zin gaame asay Yesuusa maaqqizana erii eza kaaleezaa. E unttan mokki ekkii Xooss kaatetith baz taamarsseeza; paxodayis koyizitaykka patheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sa7a omathodar taphpho nam77ii hawaaritay eziko shiiqii, «Nu yezay liizho maaqqeez gishos asay duma duma herarannee katamita yhanigii, kathannee aqiza kara koyod garkk asa moyzoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zin Yesuusa, «Unttis miizibaz yi inggoytta» yeegeeza. Unttii, «Nuus yezay ichchin soollonnee nam77ii molo maaqqeez gishos yha asayis gidiza katha nuunii yhanigii wongaam ixxiko gidaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ye aqayid ichchin mukule maaqqiz dhiirathitay yeza. Yesuusa fa tamaaritayiko, «Ishatam ishatam shaakkii shaakkii asa bettithoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E tamaaritay, E kiitteezay garkk asita bettitheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","E ichchin soollorannee nam7i molita ekkii, salo bi7ii, Xoossa galatii, menthii asa ubba helthod garkk fa tamaaritayis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ubbay mi mizheeza. Unttapp atteez gufay taphpho nam77ii leemate kunth maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yesuusa fa aadda woossodar, e tamaaritay eziko ye7eeza. Pettii gallas E, «Asay tana oona gee?» gi oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Unttii mahii «Pettay pettay, ‹xamaaqiza Waannisa, baggitay Eelaasa, yhankkitay ma, binii nabitaypp pettay yhayiqopp denddeeza› yeegiza» gi maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E mahii, «Yeezin yi tana oona gee» yeegeeza. Phixiroosa, «Neenii Xoossapp tizhintteez Kiristtoosa» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuusa yhaya ooskka odippate gi miinthii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Maakka Yesuusa, «As Na7ay gaame meto ekkoda. Gade cimitayir, qeese halaqitayir, higge asitamaaritayir ixinttoda. Unttii eza wodhoda, zin E hayidzantho gallas yhayiqopp dendoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuusa as ubbayiko, «Tana kaallodayis koyizay oonkka yeziko fana kado, fa maziqala gallas gallastookkii tana kaallo. ");
INSERT INTO mfxl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Fa shemppato ashshodayis koyiz ubbay izo dhabisiza, fa shemppato ta gishos gi dhabisiza oonkka izo ashshiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asii alamel yeza baz ubba mooddii, fa shemppato dhabisiza baz woy qohiza baz maaqqiko eza ab maaddee? ");
INSERT INTO mfxl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oonkka taalannee ta qaalayil yeellatiko As Na7ay fa bonchchor, fa aday bonchchayirannee Geesh kiitanchchitay bonchchor yi7iza wode e tiina yeellatoda. ");
INSERT INTO mfxl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta yinttis turo odiza; yhaydda eqqeezitay gancceppe Xoossa kaattetitha be7ekkazar yhayqqaam pettii pettii asay yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuusa ye oda odin, hosppun gallasapp guye Phixiroosa, Yayqqoobarannee Waannisa paar ekkii woossodayis derell afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E woosal afa yeezin e ciray laamintteeza; afilaykka awa garkk focii booxii foceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nam77ii asay, unttikka Muserannee Eelaasara unttar nashshiza ");
INSERT INTO mfxl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bonchchor benttii Yerusalaame polinttodayis yeza baz, yeyikka, E yha alamaypp shaakinttod baz ezar odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phixiroosarannee ezar yezita gentta olin, u genttapp barkkii e bonchchannee ezar eqqeez nam77ii asita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asay Yesuusapp shaakinttii qitod hanodar, Phixiroosa Yesuusako, «Godayyo, yhaydda yessi nuus lo77o! Petto nees, petto Muses, petto Eelaasas hayidzii gaabba gaabbisoda» yeegeeza. Zin E fa giz baz erooya. ");
INSERT INTO mfxl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E yeegii nashshodar shaara yi7ii unttan kammeeza. E tamaaritay ye shaaray gancce gelittar yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Shaaray gancceppe, «Ta dooreez na7ay yhaya eza si7oytta» yeegiz qaala sintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ye qaalay sintteezaypp guye Yesuusa fa aaddas yezar bentteeza. Ye gallas unttii be7eez baz ooskka odekkazar, fa wozina aykkii si77 gi atteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wonttitha unttii derellapp wodhdhodar gaame asay yi7ii eza helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ye wode woyitaypp pettii asii ukkittar, «Asitamaarayyo, ta na7ay petto eza pathoday garkk ta nena woosiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tuna ayyana qoppekka aykkii uukkisiza; afapp olii gappunttisii qakitisiza, galla maduthisiz un77ithi dakkiza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne tamaarttay kessod garkk woosseeza, zin u danda7ekkaya» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesuusa, «Ammano baa zhuca yeletithuntho, ayide hellodayis ta yinttar yezodee, ayide hellodayis yinttan danda7odee? Ne na7a yhana ekkii ye7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na7a ekkii ye7odar tuna ayyanay shoccii olii kukkursseeza. Zin Yesuusa tuna ayyana kaccii na7aypp kessii patheeza. Na7anakka na7ay adayis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asay ubbay Xoossayis yez dammo wolqqa bi7ii malabaz geeza. Unttii E ootheez bazar malabaz giittar, Yesuusa tamaaritayiko, ");
INSERT INTO mfxl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yhaya ta yinttis odizana lo7ithii si7oytta; As Na7ay morkkitay kushe aadhii inginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Zin E geezbazay unttapp qosintteez gishos dhemelkk geeza. Yey gishos, mahii oyccodayis yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuusa tamaarttay, «Nu gancce ubbapp aadho maaqqaday oonoo?» gi palama aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuusa u wozina qofa erii duude na7a fa kale essii, ");
INSERT INTO mfxl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Yha duude na7a ta sunthar mokkiza oonkka tana mokkiza, tana mokkizay tana azazeezana mokkiza, yi ubbaypp xiqqizay, e aadho maaqqada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Waanisa mahii «godayyo pettii athay ne sunthar xalahe kessodar nu be7eeza. Zin e nu bagga maaqqekka gishos nu eza kayeeza.» ");
INSERT INTO mfxl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuusa mahii «yinttan ixxowa ubbay yinttar yeza kayippate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuusa salo yhanigiza woday ukkeez gishos Yerusalaame yhammadayis murttii denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaare biitta yeezii pettii heera yhanigii, ubba baz ezis giigisoday garkk asa ye aqa kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Zin E yhanigizay Yerusalaame maaqqizana u eriza gishos mokki ekkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuusa tamaarttay Yayqqoobara Waannisara yeya bi7ii, «Godayyo, salopp tama wodhdhii unttan muye god garkk ne koyinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zin Yesuusa guye maaqqii unttan kaccii, Yinttal aba ayyana yezako yi erooya. «Yinttal afa aba ayyana yenee. Yha qofay pettii pettii maxaafitayid baaya As Na7ay as ashshodayis ye7eezaypp attin dhabisodayis baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ezaypp denddii hara heera yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesuusara e tamaaritayira oger yhammadar, pettii asii, «Godayyo ne yhanigiza aqo ubba ta kaalloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuusa mahii, «Shannitayis olla, salo kafitayis keethi yeza, zin As Na7ay fa omma shemppisiza aqo baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yhankkayikokka, «Neenii tana kaalloba» yeegeeza. Zin athay, «Godayyo, tiinatii yhanigii ta ta ada moogii ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zin Yesuusa, «Yhayqqeezitay yhayqqeezita moogod garkk unttis ashshii ashshoba; neenii yhanigii Xoossa kaatetitha sabbakoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma hara asii, «Godayyo, ta nena kaalloda, zin tiinatii ta kara asa sarothi ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuusa mahii, «Koxe aykkii guye bi7iz oonkka Xoossa kaatetithayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yeypp guye, Goday hara laappun tamannee nam7i asita dooreeza. E yhammadayis qoppeez katamannee heera ubba tiinatii yhammad garkk nam7e nam7e udii kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesuusa unttiko, «Yikkee shiiqod torchche kathay gaame zin torchche ooso asay xiqqa. Yeeyeez gishos, torchche katha goday ooso asita kiittod garkk woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yikkee, yhanigoytta, durttay garkk fugitay gancce yinttan ta dakkoda. ");
INSERT INTO mfxl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yi yhanigttar oges yhayitita aykkippate, miishe maaqqin katha maaqqin caamma aykkippate. Ogell afa oonakka sarothar wode aathippatte. ");
INSERT INTO mfxl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yi geliza keetha ubba tiinattii, ‹Saro yha keethayis maaqqo› yeegoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saro qadhdhiza as ye aqayid yeziko, yi saray ezayid aqoda; ixxiko yi saray yinttis maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ooso asis damooze beeziza gishos yi geleez keetha yinttis shiisheez baz ubba miittarannee uzhittar ezayid gam7oytta. Pettay karapp pettay kara yuuyppatte. ");
INSERT INTO mfxl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aba katamakka yi gelodar asay yinttan mokki, yinttis shiisheez baz ubba moytta. ");
INSERT INTO mfxl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ye katama gancce yez hargintteezita pathittar, ‹Xooss kaatetithay yinttiko ukkeeza› yeegii odoyitta. ");
INSERT INTO mfxl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Zin pettii katama gelodar asay yinttan mokkaam ixxiko zoozel kezii yhaygarkke goytta: ");
INSERT INTO mfxl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Nu tokayil afa yez yi katama buli7a pittoda, zin Xooss kaatetithay yinttiko ukkeezana eroytta› ");
INSERT INTO mfxl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pirdda gallasar yha katamatipp Soodome katamas pirdday kawushsha maaqqadana ta yinttis odiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ma maaqqikka, Yesuusa, «Neno Koraazinee, neno Beetesayda, ayye, yinttal oothintteez malatitay Xiroosannee Sidoona oosintteezako ezayid yez asay kayo afila ma77ii, budol afa bettii binii maaroteth gelii attodazin. ");
INSERT INTO mfxl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yey gishos, yinttipp aathii Xiroosasinnee Sidoonas Xooss pirdday kawuzhoda. ");
INSERT INTO mfxl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yhannee qifirnahoome, salo hellodayis ne dhoqqi geenee? Ne sulle Si7oole wodhdhoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Maakka Yesuusa fa tamaaritayiko, «Yinttan si7izay tana si7iza, yinttan ekkozay tana ekkooya, tana ekkozay tana azazeezana ekkooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Laappun tamannee nam77ii tamaaritay kiitintteez aqaypp lo7ithii ufayttitar maaqqeeza. Yesuusako shiiqii, «Godayyo, ne sunthar tuna ayyaanitayikka nuus kiitintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuusa unttiko, «Xalahe salopp dad garkk wodhdhodar ta be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yeezako, shooshinnee yhanigarcco yedhdhod garkkennee morkke wolqqar eqinttod garkk yinttis mawute inggeeza. Yinttan qohod baz akkokka baaya. ");
INSERT INTO mfxl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maaqqozin, yi sunthay salo mazggabayid xaafintteez gishos ufayttoyttapp attin tuna ayyanitay yinttis kiitintteez gishos ufayttippatte» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ye wode Yesuusa geesha Ayyanar ufayttii, «Salo sa7a Godayyo, yha eccitayppennee eranchchitayppe qosii duude na7itayis beezeez gishos ta nena galatiza. Ee ta Adayyo, yeya ne oothodayis lo77o shene maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Ubba baz ta adaypp taas inggintteeza. Na7ay oonazako adaypp attin hara woy na7ay qonccisodayis koyizaypp hara oonkka ada erizay baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma maaqqikka, Yesuusa duma fa tamaaritayiko, «Yi be7eezana bi7izitay anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tuma gaame nabitayinnee kaatitay yi bi7izannee si7izana be7adayisinne si7odayis amotteeza, zin u be7ekkaya, si7ibe7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yeezako, pettii gallas Muse higge eriza pettii athay denddii Yesuusa yeegii paace oych oyceeza. «Asitamaarayyo, medhinas de7o laattodayis taanii ab udo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuusa, «Muse maxaafayid xaafintteezay waagee? Ne wayizii nabbabi akaakee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Athay mahii, « ‹Ne Goda ne Xoossa, ne kunthi wozinappe, ne kunith shemppopp, ne kunth wolqqapennee ne kunthi qofapp qadhdhoba. Maakka ne lagga ne ubbay garkk qadhdhoba› yeegiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuusa eziko, «Neenii yinno likkee maheeza, neekka yhay garkk oothoba. Ne medhinas de7or yezoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Zin athay fana geeshsh oothodayis kozhii, «Hanos E ta laggay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E oychayis Yesuusa yeegii malsse inggeeza, «Pettii asii yezay Yerusalaame katamapp sulle Iyarkko katama yhammadar ogel afa paanitay kezii shoceeza. E afila qaarii ekkii yhayiqoppennee pathapp gancce ooilii qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Guyepp, Ayihude qeese pettay ye ogayar fa yhamo yhanigttar atha bi7ii deshshi gi aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Maakka pettii Leway ye aqa hellittar atha bi7ii hara oger aadhii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Zin, pettii Samaare biitta as yezay ye ogayar yi7ittar atha bi7ii ezis qadhintteeza ");
INSERT INTO mfxl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eziko shiiqii, e madothayil afa zayitennee woyine qoli acceeza. Fa harel afa betithi imathi aqiz keetha kanggeeza. Ye aqayid ezis koshshiza baz ubba ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wonttitha nam77ii diinaare mahii imathi kara adayis inggii, ‹Hayyana yha atha lo7ithii bo7oba. Taanii nees inggeezaypp afar ne kessiza baz ubbita ta nees ciggoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Yikkee, yha hayidzii asitaypp paannitay shoceez athayis laggee maaqqeezay nees oona aazee?» ");
INSERT INTO mfxl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Athay mahii, «Ezis qadhintteezaya» yeegeeza. Yesuusa, «Neekka yhanigii yhay garkk oothoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuusa fa tamaaritayir oge yhanigttar pettii heera helleeza. Ezayid Martta ginttinttiz pettii asita eza fa kara mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iziskka Mayramo giz mishshitta yeza, Mayrama qaala si7ittar Goday toke kale betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Zin Martta gaame oosor un77inttii Yesuusako shiiqii, «Godayyo, ta mishitta ooso ta aaddas ashshii bettii attin ta daaburodar ne bi7ittar si7ii ginee? Iza tana maaddod garkk odoosa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zin Goday yhay garkk gi maheeza, «Martta, Martta, ne gaamebazar tuurittar metinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maaqqozin, koyinttizay pettibaz aadda. Mayrama lo77o baz dooreeza, yeykka izippe ekinttaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pettii gallas Yesuusa pettii aqo woossiza. Woosa wursseezaypp e tamaaritaypp pettay, «Godayyo, Waannisa fa taamarita woosa taamaarisseeza igarkk neekka nuna woosa tamaarssoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuusa, «Yhay garkke yeegii woossoytta: «‹Salo yez nu adayyo ne geesh sunthay anjjintto; ne kaatetithay ye7o. ");
INSERT INTO mfxl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nu gallasa katha yhayino yhayino nuus inggoba. ");
INSERT INTO mfxl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nuna qoheezita nuunii atto gizay garkk, nu nagara atto goba; paace gancce nuna gelisippe› yeegoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Maaqqikka, Yesuusa fa tamaaritayiko yeegeeza: «Aazisos yinttipp pettayis laggee yeza. E giddii bilahe fa laggay kara yhanigii, ‹Ta laggayyo, hayidzii soollo taas tali7ooye. ");
INSERT INTO mfxl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taas laggee maaqqeez pettii asii ogepp yi7in, ezis aathod baz tana dhabeeza› yeegiko, ");
INSERT INTO mfxl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«E laggay keetha gancce yezii, ‹Hayyana tana waaythippe, pengay kobintteeza. Ta na7itaykka taar arssal afa woyi7eeza. Yey gishos, denddii ne koyeez baza inggodayis danda7ooya› yeeginene? ");
INSERT INTO mfxl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta yinttis odiza; laggetithay gishos denddii immadayis koyekka maaqqikokka woosar wayitheez gishos denddii koyiz baz ubba inggiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Yey gishos, taanii yinttis odiza; woossoytta yinttis inginttoda; kozhoytta yi denggoda; bale yi7ii xeegoytta yinttis dooyinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Woossiza ubbay ekkiza; koyizay denggiza; bale yi7ii xeegizayis dooyinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Yinttanno, aditayyo yi ganccepp na7a boora woosiko shuchchi ingizay oonoo? Molo woosiko shooshii ingizay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woy phuuphphule woosiko yhanigarcco ingginee? ");
INSERT INTO mfxl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yi iitita maaqqittar yi na7itayis lo77o baz imo eriko, salo yez yi aday woossizitayis Geeshsha Ayyana wayizii aathii inggaamo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pettii gallas Yesuusa doona muumiseez tuna ayyana pettii athaypp kesseeza. Tuna ayyanay kezeezan garkk muume athay odintteeza. Woyaykka malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Zin pettay pettay, «Tuna ayyana halaqa, Bi7elzebula wolqqar tuna ayyanita kessiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yhankkitay ma faaccodayis salopp malla beezodaygarkk koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zin Yesuusa u qofa erii unttiko, «Woli gancce shaginttiza kaatetithii ubbitay dhabiza; woli gancce shaginttiza keethi woddiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xalahe kaatetithay shaakinttiko e kaatetithay wayizii miinggii eqqodee? Yi tana, ‹E tuna ayyanita Bi7elzebula wolqqar kessiza› giza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yikkee, taanii tuna ayyana Bi7elzebula wolqqar kessiza baz maaqqiko yinttan kaallizitay o wolqqar kessodeshsha? Yey gishos, unttii yinttal afa pirddizita maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Zin taanii tuna ayyanita Xooss wolqqar kessiza baz maaqqiko yikkee Xoossa kaatetithay yinttiko ukkeezana eroytta. ");
INSERT INTO mfxl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Miinth as danccinttii fa keetha naagiz maaqqiko, e shalay bochinttenna. ");
INSERT INTO mfxl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hano zin, ezipp aadhii miinth maaqqeez as yi7ii, eza qohi gamii ammaninttii dancceez dancca bilisii, e shalana bonqqii shagiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Taar wolla maaqqekkazay tana ixxiza; taar shiishozaykka laalliza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Tuna ayyanay asappi kezeez wode shemppiza aqo koyii haathii baa aqor yuuyii. Shemppiza aqo dhabeez wode ‹Maaqqii ta kezeez karttee yhammada› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E maaqqiz wode keethay pitinttii lo77i yezin denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yeypp guye, yhanigii ezipp aadhii iiteez hara laappun tuna ayyanita ekkii yi7iza. Ezal gelii yess aykkiza. Ye athayis tiinaasaypp guyeesay aadhii iita maaqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuusa yeya odal afa yezin pettii asita woya ganccepp dendii, fa qaala dhoqqi udii, «Nena tookkeez ulayinnee ne ammeez ammitay anjjintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zin E, «Anjjintteezitay Xooss qaala si7ii kiitinttizita» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gaame asay shiiqeez wode Yesuusa, «Yha yeletithay iita; malla koyiza. Zin Yoonasa mallitaypp attin hara unttis ingginttooya. ");
INSERT INTO mfxl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yoonasa Nanawe asayis malla maaqqeezay garkk As Na7aykka yha yeletithayis malla maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kaatata Saaba pirdde gallas yha yeletithayira dendii pirddoda. Abis giiko, iza Solomone eccetitha si7odayis biitta gaxapp dendii ye7eeza. Yeezako Solomonepp aadhizay yhaydda yeza ");
INSERT INTO mfxl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nanawe asay pirdde gallas yha yeletithayira dendii unttal afa pirddoda. Abis giiko Yoonasa sibkkater maarotithi geleeza. Yeezako, Yoonasapp aadhizay yhaydda yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Xomppe xomppii qoso aqo woy ota gancce gaddiza asii baaya. Asii poo7ana be7ad garkk dhoqqe aqo gaddiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne galla ubbayis poo7ay ne aafa. Ne aafay lo77o maaqqiko, ne kunth gallay poo7iza. Ne aafay harggiko ne gallay ubbay dhumiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yey gishos, ne gancce yez poo7ay dhumaam garkk naagiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yikkee, ne kunth gallay poo7o maaqqiko, ne asetithayidakka hara dhuma aqo dhabiko, ne galla kunthay wazhzhii geez poo7o garkk maaqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuusa fa nashsha wurisseezan garkk pettii Ferisaaway paar katha maaday garkk xeegeeza. E ezar wolla gelii sibirel afa betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ferisaaway Yesuusa katha maadaypp tiina kushe meeccekkaza bi7ii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goday eziko, «Yinttii Ferisaawitay wanccasinnee keres afa bagga meecciza. Zin yi ganccay bonqqannee iitatithar kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yinttano, boozitayyo, bale bagga medhdheezay gancce medhdheez goday eza baasannee? ");
INSERT INTO mfxl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Zin wanccannee keree yezana manqqitayis inggoytta. Ye wode yinttis ubba baz geesh maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ferisaawitayyo yinttan ayye, sawopp, xalootepp, yey garkk bazipp asiraata kessiza. Zin xillotithinnee Xooss qadhe yinttar baaya. Yhankkita ashshekkazar yhayititakka oothodayis beeziza, zin yi ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ferisaawitayyo yinttan ayye, Ayihuditay Woosa Keetha bonchcho oyide, gabe gancce bonchcho sarotho yi dosiza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Liilamii dhabin asay erekkazar afar yedhdhiz duufo aazizittayyo yinttan ayye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Higge asitamaaray maaqqii, «Asitamaarayyo, ne yeya giittar nuna cazhiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuusa, «Yinttano, higge asitamaaritayyo, yinttanakka ayye, asii tookkodayis danda7oowa deexo toofo toossiza, zin yinttii yi ubbas hara attozin biradhdhe xeerarakka bochchoyya. ");
INSERT INTO mfxl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Yi aditay wodhdheez nabitay duufa yi giigisiza gishos yinttan ayye. ");
INSERT INTO mfxl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yikkee, yi aditay oosa minthodayis u wodhdheez nabitay duufa yi lo7ithiza gishos u iita oosayis yi markka. ");
INSERT INTO mfxl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yey gishos, Xoossay fa ecetithar, ‹Nabitannee hawaarita ta yinttis kiittoda, zin yi baggita wodhoda; yhankkita bayi7oda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yey gishos, yha yeletithitay alamay medhintteezayppe yhanno hellodayis laalintteez nabitay ubbitay suuthayis oyiccinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabeelapp aykkii yarshsho aqosinne Xooss Keethapp ganccer laalintteez Zakkireesa suuthay gishos yha yeletithay oyiccinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Higge asitamaaritayyo, yinttan ayye, eretithi qulppa yi kushe aykkeeza, zin yinttis gelooya yhankkitakka gelisooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuusa yeypp yhammadayis kezodar higge asitamaaritaynnee Ferisaawitay ezar eqinttii oyichchar wayitheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","E doonapp keziz qaalar eza aykkodayis koyii yeya ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ye wode gaame mukuler taybinttiza asay wolalli afa yedhdhinttod gatho asii asal afa shiiqii yezin, Yesuusa fa tamaaritayiko, «Ferisaawitay irshshopp naaginitoytta. Yeyikka cubbotith. ");
INSERT INTO mfxl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Benttekka qosinttii, erinttekka kamintti attizibaz akkokka baaya. ");
INSERT INTO mfxl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yikkee, yi dhuma odeezibazay ubbay poo7o si7inttoda, qol7a haye kalkkasheez baz woyas odinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ta bagguntho, ta odiza si7oytta; asho wodhizapp attin hara abikka oothodayis danda7oozittayis yashittippate. ");
INSERT INTO mfxl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hano zin, yi yashittodayis beezizana ta yinttis beessada. Yeykka wodheezayppe guye Gaanname olodayis mawute yezayis ezis yashittooytta. Ee, tuma giza; ezis yashittooytta. ");
INSERT INTO mfxl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ichchin suunnitay pettii santifess bayizinttoosannee? Hanopp attin unttapp pettatakka Xooss tiina doginttenna. ");
INSERT INTO mfxl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hara attozin, yi ooma binanaykka payidinttii yeza. Yikkee, yashittippate; gaame suunnitaypp yi aadhiza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ta odiza si7oytta; as tiina ta baz markkattiz ubbayis As Na7ay Xooss kiitanchchitay tiina markkottoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","As tiina tana kaddizana Xooss kiitanchchitay tiina ta eza kaddoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","As Na7al afa leqo qaala odiz ubbitay maarotithi demmada, zin geeshsha Ayyana cazhizitay maarinttenna. ");
INSERT INTO mfxl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Asii yinttan aykkii Ayihuditay Woosa Keetha, daynnitay tiinannee kaatitay tiina gooshichchiza wode ab ododazakonnee waagii mahodazako hirigipatte. ");
INSERT INTO mfxl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ye wode yi odod baz geeshsha Ayyanay yinttan tamarssoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Woyitaypp pettii asii Yesuusako yi7ii, «Ta ishay taas nu aday keekepp shaakkod garkk ezis odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuusa mahii, «Naat athayyo, yinttal afa tana daynninnee keeke shaakkiz cima ootheezay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Maakka Yesuusa, «As yessay shalo gaametithar baazay gishos yaare ashshii miinthii yinttan naagoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Maaqqikka aazisor, «Gaday gaame katha inggiz pettii dure athay yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ye athay, ‹Ta katha taanii shiishodayis aqo xiqqeez gishos ab ootho?› yeegii fa wozinar qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yhanppe yessada; tiin yeza shaalita hullii hara dalgge shaale keexxoda. Kathannee taas yeza baz ubba ezayid oloda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fa shemppatiko, ‹Ta shemppate, gaame laythis nees gidiza shalo shiisheeza. Yikkee, shempp mooba, uzhoba, ufayttoba› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Zin Xoossay, ‹Naat, boozo athayyo, yhayino qamma ne shemppata neepp ekinttiza. Yikkee, ne shiisheezay ooss maaqqode?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Yey gishos, paas duretithii sa7all shiishiza asis, Xooss kale dure maaqqekka asis wurssithay yha athayisaygarkke» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yeyppe guye, Yesuusa fa tamaaritayiko, «Yikkee, ta odiza baz si7oytta, yi shemppos ab maadee yi gallas ab ma77odee yeegii un77inttippate. ");
INSERT INTO mfxl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Shemppo kathapp galla afilapp aadhiza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kafita bo7oytta zerooya, maxooya, shaalekka baaya. Zin Xoossay unttan muziza. Yi kafitaypp lo7ithii aadhiza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hano zin, yinttipp un77inttii fa laythal afa pettii qamma gujjodayis danda7izay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yikkee, yha xiqqabaz oothodayis danda7oowa yi harabazis abis un77inttee? ");
INSERT INTO mfxl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","An fudhitay wayizii diccizako bo7oytta. Waayooya suqqooya. Hara attozin, Solomone paas yeezii bonchcho ubbayir unttapp pettay garkkekka ma77ii be7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yinttano, ammano pacceezitayyo, yikkee, Xoossay yhayino benttii wontta tama gancce wodhdhod fudhita yhay garkke ma7isiko, yinttan wayizii aathii ma7isoosa? ");
INSERT INTO mfxl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yey gishos, ab moshsha woy ab uzhoshsha gi yi wozinar un77inttippate. ");
INSERT INTO mfxl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ye ubba Xoossa ammanoowa asay koyiza. Zin yi aday Xoossay yey ubbitay yinttis koshshizana eriza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ubbapp aathii Xooss kaattetitha kozhoytta yey ubbitay yinttis gujjii inginttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Yinttano, xiqqa woyitayyo, yi aday Xoossay kaattetitha yinttis immadayis e lo77o shene maaqqeeza yashittippate. ");
INSERT INTO mfxl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yinttis yeza baz bayizii manqqitayis inggoytta. Kayzo ekkowa, bila moowa aqo, cimowa qurbo gancce, wuroowa shalana salo shiishoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yi wozinay yi shalay yeza aqo maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Yi xeessay danccintteeza, yi xomppay poo7eeza maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Fa goday bossaypp maaqqad gatho barkkii naagizitay garkk, goday yi7ii xeegiz wode ellis dooyodayis giigeez asita aazoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Fa goday maaqqiz wode genttekkazar naagizitay anjjintteezita. Ta turo giza; goday haatar danccii leemmate lanqqayid bettithi mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Goday giddii bilahe maaqqin woy wonttimaathe maaqqin yi7ii, yey garkk genttekazar naagodar denggiza ye ayllitay anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Zin yhaya eroytta; kayizo ayide ye7odazako kara aday erizako keethay bokinttamizin. ");
INSERT INTO mfxl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yinttikka giigii naagoytta; As Na7ay yi qoppekka wode ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phixiroosakka, «Godayyo yha aazisa nu aaddas odinenee as ubbaso?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Goday mahii, «Yikkee, katha muzodayis beeziza woder immad garkk goday fa ayllitayil afa shuumeez ammanthizaynnee wozinaamay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Goday maaqqodar yey garkk oothittar benttiz ayllay E anjjintteezaya ");
INSERT INTO mfxl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta yinttis turo odiza; fa godayis yez shalo ubbayil afa E shuuminttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Zin ye ayllay, ‹Ta goday ellithii ye7enna› yeegii fa wozinar qoppii, gadhinditannee gaachita yhadhdhiko, ma paas kozheez garkk miitarannee uzhittar mathiko, ");
INSERT INTO mfxl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ye ayllay goday E qoppekka gallasaninnee hirggekka wode ye7oda. Yi7ii eza gashichii, e anija ammanoowa asitayir oothoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Goday shenay garkk giigozayinnee e goday ab qadhdhizako erittar oothowa ayllay gaame garafinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Zin fa goday shena erekka attii garafinttodayis beezizana ootheezay xiqqal garafinttoda. Abis giiko gaame inggintteezaypp gaame koyinttiza, gaame hadara ekkeezayppekka gaame immad gi naaginttiza.» ");
INSERT INTO mfxl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Taanii ye7eezay biittal afa tama aythodayis. Yhatti tamay aykkizako tana wayizii ufayssoddeshsha! ");
INSERT INTO mfxl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hano zin, ta yhatti xammaqinttiza xinqqatay yeza. E polinttod gatho ta waafa un77inttodeshsha. ");
INSERT INTO mfxl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sa7all afa sarotithi ko7odayis ye7eeza yinttis aazinee? Yeya baaya, ta ye7eezay shaakkodayis. ");
INSERT INTO mfxl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yhattepp aykkii woli gancce shaakintteez ichchin asay pettii keetha wolla yeza. Nam7ittay hayidzitayil afa, hayizitayikka nam7itayil afa, denddii shaakinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aday na7ayil afa, na7aykka adayil afa, indat na7attil afa, na7ata indatil afa, azinnay indat na7ay machchatil afa, na7ay machchat azinnay indatil afa, dendii shaakinttoda.» ");
INSERT INTO mfxl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Maakka asayiko, «Awa gelo baggar salo shaaratiza wode bi7ii, ellis, ‹Ira ye7oda› yi yeegiza, yey garkkekka haniza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sulle bagga carkko carkkiza wode ‹Sa7ay awoda› yi yeegiza, yey garkkekka haniza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yinttano, cubbitayyo, Salobazinnee sa7abaz shaakkii erizin yha woda shaakkii eroday yinttan wayizii gameenee? ");
INSERT INTO mfxl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Yeezin, yi ubbas abis tuma pirddoosa? ");
INSERT INTO mfxl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ne morkkayir wolla dayina tiina eqqodayis yhanigittar ogel afa giigodayis koyii. Ne giigekka attiko gooshichchi daynna tiina nena kammada. Daynnay nena poolisees aathii immada. E nena woyne oloda. ");
INSERT INTO mfxl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Si7oytta, pettii bakkanna attekazin ciggi haassod gatho ne izipp kezaamizanno eroba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ye wode Yesuusako asay yi7ii Galila asay yarsho yarshshodar unttan Philaaxoosa wodhii u suutha yarshor walakkeez baza odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E yhay garkke yeegii maheeza; «Yeezin yha Galila asay yha iita yhayiqo yhayqqeez gishos Galila yez asii ubbapp aadho nagara oothiza aazinee? ");
INSERT INTO mfxl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yeya baaya! Yinttikka maarotethar maaqqaam attiko, ubbitay yhay garkk dhaboda. ");
INSERT INTO mfxl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Woy ma Salihoome giz bessayid gimbbay woddii wodheez taphpho hosppun asay Yerusalaame yez asii ubbapp aadheez nagara oothiza aazinee? ");
INSERT INTO mfxl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yeya baaya! Zin yinttikka maarotethar maaqqaam attiko ubbay yhay garkk dhaboda.» ");
INSERT INTO mfxl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Maakka Yesuusa yhay garkke gi aaziso odeeza: «Pettii athayis woyne gade tukintteez balase mithat yeza. E iippe aafe koyii yi7ii abikka denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gade goday woyne ooso asayiko, ‹Aafe denggodayis koyii hayidzii laythi maaqqii maaqqii yi7ii abikka denggekkaya. Yey gishos, gachchii hali7isoba; abis biitta melisee?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Zin ooso athay, ‹Godayyo, i gaxa oothii osha olod gatho haberes laythis ashshooyee. ");
INSERT INTO mfxl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Guye laythi aafiko lo77o, attiko gachchii ashshoba› » yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuusa maala gallas Ayihuditay Woosa Keetha taamarissiza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ye bessayid taphpho hosppun laythi tuna ayyana zokko kuuniseez pettii asita yeza. Iza kuuneezay gishos luule eqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuusa izo be7eez wode xeegii, «Yhan asitee, ne hargaypp paxeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Fa kusha Izil afa gaddin, iza eller luulii eqqeeza. Xoossakka galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zin Ayihuditay Woosa keeth halaqay yilottii asayiko, «Ooso oothiz usuppun gallasitay yeza. Yey gishos, ye gallasitayid yi7ii paxoyttapp attin maala gallas baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Goday, «Cubbitayyo, yi ganccepp gemate woy hare maala gallas zadalopp billii haath ushshodayis kanggoozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yeezin, yha asita Afraame na7a maaqqittar xalaher accinttii taphpho hosppun laythi kunth yezeezanis maala gallas billinttodayis beezoossa?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","E yeya odeez wode eqinttizittay ubbitay yeellateeza. Zin as ubbay E ootheez malata ooso ubbayid ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yeyppe guye, Yesuusa yhay garkke yeegeeza, «Xooss kaatetithay ab aazinee? Izo abar aaziso? ");
INSERT INTO mfxl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xooss kaatetithay pettii as fa gade gancce tukkeez sanaficce aafe garkke. Iza diccii damma mith maaqqeeza. Kafitay i shaqayil afa shemppeeza.» ");
INSERT INTO mfxl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma, «Xooss kaattetitha abar aaziso? ");
INSERT INTO mfxl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pettii asita gaame dhiillar walakkii munuqeez xiqqa irshsho aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeyppe guye, Yesuusa Yerusalaame yhanigttar E aadhiz ogel yez katamitaydannee heera tamaarssittar aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pettii as Yesuusako, «Godayyo, attoday xiqqa as aaddanne?» yeegii oycceeza. Yesuusa unttiko, ");
INSERT INTO mfxl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Si7oytta, xunth penger gelodayis butitoytta. Gaamitay gelodayis koyiza zin unttis hanaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Keethi goday denddii penge gorddezayppe guye ‹Nuus dooyooyee› yeegittar bale eqqii xeessi aykkoda. Zin E, ‹Yi oonazakonnee anapp ye7eezako ta erooya› gi mahoda. ");
INSERT INTO mfxl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ye wode yi, ‹Neer wolla meeza, uzheeza, nu denbaydakka ne taamarsseeza› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«E mahii, ‹Yi oonazakonnee anapp ye7eezako ta erooya. Yinttano, iitta baz oothzitayyo taapp haakkoytta› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Afraame, Isaaqa, Yayqqoobarannee nabita ubbita Xoossa kaatetithayid yi be7ada, zin yi bale wodhdhii attiko yinttis yeefonnee achch coonchii maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asay awa kessappe, awa gelopp, pude baggapp sulle baggapp yi7ii Xooss kaatetititha munttal afa bettoda. ");
INSERT INTO mfxl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yey gishos, guyeteezitaypp tiina maaqqoditay, tiineezitaypp guye maaqqoditay yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ye wode Ferisaawitaypp pettay pettay yi7ii, «Herodossa nena wodhodayis koyiz gishos yha bessapp denddii qitoba» geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","E mahii, «Yhanigii, ye workkanitayis yeezako, ‹Yhayinonnee wontta tuna ayyanita kessoda, harggintteezitta pathoda, hayidzantho gallasar haasoda› yeegeeza goyitta. ");
INSERT INTO mfxl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hanopp attin, nabay Yerusalaamepp hara aqo yhayqqodayis beezooya. Yey gishos, yhayino, wonttanne wonttii peezhii ye bessa yhammadayis denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusalaame, Yerusalaame, nabita wodhizannee, neeko kiitintteezita shuchchar shocizannee, shugula fa na7ita fa qefaypp oommor shiishizay garkk ne na7ita ta ta shuphphaypp oommor aappun toke shiishodayis koyennee, zin yi ixxeeza geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta yinttis odiza; yi keethay kaysattoda. Goday sunthar yi7izay anjjintteezaya yi god gatho tana denggaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Maala gallas Yesuusa pettii Farasaawitay halaqay kara katha maadayis gelodar asay e ab udizak be7adayi naagiza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ye aqayid shawuhe harger metinttiza pettii as ezis tiina baggar woyi7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuusa Ferisaawutayikonnee higge asitamaaritayiko, «maala gallas harggintteez as pathizay woganee woga baasa?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","U si77 ateeza. Yesuusa hargginttiza atha bochchii pathi moyzeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","«Maakka yinttipp pettayis na7a woy gemate maala gallas hoobbo wodhdhiko ellisii kessoozay oonoo» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","U pettibazikka mahodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuusa imatos xeegintteezitay bonchcho aqo doorodar bi7ii, yha aazisa odeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Pettii asii nena bossas xeegiko bonchcho aqo bettippe. Neepp aadhii bonchchinttiza asii xeeginttodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yinttan nam7itakka xeegeezay yi7ii, ‹Ne aqa yha imathayis dakkoba› yeegiz wode ne yeellatittar sull wodhdhada. ");
INSERT INTO mfxl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Maaqqozin, ne xeegintteez wode tiinattii ziqqa aqo bi7ii bettoba. Xeegeezay yi7ii, ‹Ta laggayyo, yha bonchcho aqayid bettoba› yeegoda. Ye wode neer wolla xeegintteez asa ubbay tiina ne bonchchinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fana shokk shokk udiz ubbitay kawuzhoda; fana ziqq ziqq udiz ubbitay shokk shokk goda.» ");
INSERT INTO mfxl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Maakka Yesuusa eza mokkeez kara adayiko, «Quma woy kaho imato xeegiz wode neenii kushe maho xeegaamay garkk ne laggita woy ne ishita woy ne dabbita woy ne dure shoorita imato xeegippe. ");
INSERT INTO mfxl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maaqqozin, ne imato makkeez wode manqqita, wobbita, silitannee to7ita xeegoba; ne anjjinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yhayititay kushe mahodayis danda7oowa gishos kushe mahithay geeshshitay denddo gallas Xooss nees mahoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuusar wolla imatol afa betteezitay gancceppe pettay yeya si7ii, «Xoossa kaatetithayid imatol afa betteezay anjjintteezaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuusa, «Pettii as damma imato giigisii gaame asita xeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Imato mokinttiza saatat helliz wode xeegintteez imathita, ‹Yeezako ubba baz giigeeza, yhana ye7oytta› yeegii xeegod garkk fa aylla azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Zin ubbitaykka fa salambe salambe medhdheeza. Pettay, ‹Yhatti ta haga gade wonggeez gishos yhanigii be7adayis koshshiza hayyana tana ashshooyee› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yhankkay, ‹Ichchin waaxa gemate wonggeeza unttan waaxii faacii be7ad gishos hayyana taal lanccippe› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma yhankkay, ‹Taanii haga meddal yez gishos ye7odayis danda7inttaamii› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Ayllay maaqqii yi7ii yeya ubba fa godayis odeeza. Ye wode boss goday kaccinttii ayllayiko, ‹Ellis katama yez goossitayillane husa ogitayill yhanigii, manqqita, wobbita, to7itannee gunddeezita yhana ko7oba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ayllay, ‹Ta godayyo, ne kiiteezay ubbitay polintteeza, zin yhattekka aqo yeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Goday ayllayiko, ‹Goositayil afannee, kara gancce ogell kezoba, ta keethay kumod gatho bentteez ubbitay ye7od garkk udoba. ");
INSERT INTO mfxl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta yinttis odiza; imatinttii atteezitaypp oonkka ta ataalaypp maamizana eroytta› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Gaame asay ezar wolla yhammadar Yesuusa unttiko guye maaqqii, ");
INSERT INTO mfxl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Taako yi7iz ubbitay fa adannee fa indo, fa machchattonnee fa na7ita, fa ishitannee fa mishita, hara attozin fa shemppo ixxoozay ta tamaare maaqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Fa mazqale tookkii tana kaallowa oonkka ta tamaare maaqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Yinttipp pettii asii shuchch keeth keexxodayis koyiko, keeth keexxii wurssodayis ab garkk miishe koshshizako tiinattii erodayis qoppozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yeya maaqqekka attiko, yha athay baasol shuchchi hiixxin wursso gamiko, ");
INSERT INTO mfxl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bi7iza ubbay, ‹Yha athay gimbbithi aykkin wurssodayis eza gameeza› yeegii boriza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Woy pettii kaatay hara kaatar olinttodayis denddittar laatam mukule olanchchita ekkii ye besa kaatayir taphphii mukule olanchchitar eqinttodayis danda7odanannee danda7aamiza tiinattii bettii zorinttoozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eqinttodayis danda7inttoowa baz maaqqiko, ye hara kaatayir haakor yeezin dabbotodayis tiinattii cima dakkii oyicishshiza. ");
INSERT INTO mfxl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yey garkke, yinttapp oonkka paas yeza baz ubbita ashshaam ixxiko ta tamaare maaqqodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Maxine lo77o, zin maxine fa mal7a ashshiko, wayizii maxine giinttinttodayis danda7inee? ");
INSERT INTO mfxl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Biittaskka araddisoskka maaddoowa baz maaqqiz gishos alla olinttoda. Yikkee, si7iz hayer yez as si7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pettii gallas qaraxe gachishizitaynnee nagara oothiz asay Yesuusa timirtta si7odayis e lanqqayir shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Zin farasaawitayir higge asitamaaritay, «Yhay athay nagaranchchita shiishii ekkiza, unttar wolla miiza» yeegii zigireeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuusa yeegii yha aazisa unttis odeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Yi gancceppe pettayis xeet duritay yeza baz maaqqiko unttapp pettay dhabiko uddufun tamannee uddufunita wora ashshii dhabeezana denggod gatho koyoozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Denggeez wode ufayttii fa gannal tookkii, ");
INSERT INTO mfxl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","fa kara maaqqiza. Fa laggittannee shoorita wolla xeegii, ‹Dhabeez ta duura denggeeza, taar wolla ufayttoytta› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yey garkkekka, maarotithi gelowa uddufun tamannee uddufun xillitaypp fa nagaras maaroteth geliz pettii athay gishos salo dammo ufayis maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Woy taphphii shucha bira yeza pettii asita taphphipp pettat dhabiko denggod hellodayis xomppe aytihi keeth pittii miinthii koyoozay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Denggeez wode fa laggittannee fa shoorita xeegii ‹Dhabeez ta shuchcha birtto dengeez gishos taar ufayttoytta› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Si7oytta, yey garkk pettii maarotith geliz nagaranchayir Xoossa kiitanchchitay tiina ufayssi maaqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Maaqqii Yesuusa, «Pettii athayis nam77ii na7itay yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Unttapp geedo na7ay fa adayiko, ‹Ta Adayyo, ne shalaypp ta bagga taas inggoba› yeegeeza. Aday fa shalana fa na7itayis shageeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xiqqa gallasapp guye geedo na7ay fa bagga ubbita accii ekkii haakko gade yhanigeeza. Ezayid ekkii yhanigeez shalana toochchii wursseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","E paas yeza baz ubbita wursseezaypp guye ye gadayid ubbayil miinth naye gelin metintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yey gishos, ye gade asaypp pettay kara gata geleeza. Athay eza gudaylle heemmad garkk fa mootha dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gudayllitay miiz harqqaypp maadayis amotteeza, zin izokka ezis inggiz asii benttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Fa Wozinar, ‹Aappun ta aday ayllitayisi katha alla attin ta yhaydda nayer yhayqqe?› ");
INSERT INTO mfxl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Denddii ta adayiko yhanigii, ‹Ta adayyo, salo Xoossa, sa7a nena ta qoheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yhanpp ne na7a ginttinttii xeeginttodayis taas beezoowa gishos ne kara yez ayllitaypp pettay garkk udii tana tayiboba› yeegoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yey gishos, dendii fa adayiko yhanigeeza. «Hano zin, E haga haakor yeezin aday qadhinttii, eziko woxxii yhanigii idinggii yeereeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na7aykka, ‹Ta adayyo salo Xoossa, sa7a nena ta qoheeza. Yhanpp ne na7a ginttinttii xeeginttodayis taas beezoyya› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«E aday ayllita xeegii, ‹Ellisii ubbapp lo77o maaqqeez afila ki7ii eza ma7issii; e biradhdhayidakka migiddo, e tokayid caamma aathoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Modhdho mehe ki7ii shukkoytta, maada, ufayttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta na7ay yhayi yhayqqeeza, zin yhanno paxeeza; dhabeeza, zin bentteeza› yeegeeza. Yeyppe guye, ufayttithii aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Ye wode bayra na7ay woota gade yeza. Ezaypp yi7ittar kara ukkodar yethinnee donth giirthi si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ayllitaypp petta xeegii hanizay abizako erodayis oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ayllay, ‹Ne ishay saro ye7eez gishos ne aday modhdho mehe ezis shukkeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Bayra ishay kacinttii kara gelodayiskka koyekkaya. Aday bale kezii kara geloda garkk eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Zin E fa adayiko, ‹Yeezako, yhay garkk laythi ta nees aylletti ne kiitappe pettokka pacinchekkazar nees kiittinttin ta ta laggitayir ufayttod garkk hara attozin pettii hooggo deesh taas inggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Zin, yhay ne na7ay ne shalana laammizitayir doonggii wurssii yi7in modhdho mehe shukkeene bay› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Adaykka, ‹Ta na7ayyo, ne ubba wode taar yeza, tabazi ubbay neesi. ");
INSERT INTO mfxl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yhay ne ishay yhayqqeeza, zin paxeeza; dhabeeza, zin bentteeza. Yey gishos, gaame ufayttodayis beeziza› yeegoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuusa fa tamaaritayiko, «Pettii dure athayis ezipp oommor pettii shuumay yeza. Ye shuumay fa goday shalana toochcheeza yeegii mooteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Shalo goday shuuma xeegisii, ‹Taanii waagizin si7aree? Yhanpp ne ta keethis shuum maaqqii oothodayis danda7oowa gishos ta shalana tana helithoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Ye shuumaykka fa wozinar yhay garkke yeegii qoppeeza. ‹Ta goday tana shuumetithaypp wothod haniza, wootii aqodayis wolqqa baaya, woossii maadayis yeellathiza; yeezin ta wayizo? ");
INSERT INTO mfxl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Shuumatithapp tana wodhisiko wode asay tana mokkod garkk oothod baz ta eriza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Yey gishos, e goday aco yez asa petta petta xeegii ki7ii tiina athayko, ‹Neell afa ta goday aco aappunii yenee?› yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«E, ‹Xeet ota zayite aco yeza› yeegeeza. «Shuumay, ‹Wule warqatta yhayishee, ellisii, ishatam ota zayite aco yeza gi xaafoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Yeyppe kaali nam7inthayiko, ‹Nees aappunii yenee?› yeegeeza. «E, Xeet joniya ‹gistte aco yeza› yeegeeza. «Shuumay, ‹Ne wule warqatta yhayshe, ellisii, hosppun tam joniya yeegii xaafoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Shalo goday ammaninttowa shuumay e bilaamatithayis nashshicheeza. Yha alamay na7itay as aythar poo7o na7itaypp aadheez wozinaamita. ");
INSERT INTO mfxl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Yey gishos, ta yinttis odiza; yha worddo miishay worddor bentteez wodayid medhina keetha yinttan mokoday garkk miishayir yinttis laggita wonggoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ubbaypp xiqqa bazal ammanintteezay gaame bazal ammanintteeza maaqqiza. Ma ubbappi xiqqa bazal ammaninttowazay gaame bazal ammaninttooya. ");
INSERT INTO mfxl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yikkee, yha alame miishel yi ammaninttaam ixxiko tuma miishe yinttis oonii hadara immade? ");
INSERT INTO mfxl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yinttii hara as miishel ammaninttaam ixxiko, yi buzo miishe yinttis oonii immade? ");
INSERT INTO mfxl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Pettii ayllay nam77ii goditayis moodinttodayis danda7ooya. Petta ixxiko yhankkaya qadhdhiza woy pettayiko shiiqiko yhankkaya leqqiza. Yey garkk, yi Xoossisinnee miishes moodinttodayis danda7ooya.» ");
INSERT INTO mfxl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Miishe qadhdhiza Ferisaawitay yeya si7ii Yesuusa qaldeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E, «Yinttii yinttan as tiina xillisiza, zin Xoossay yi wozina eriza. As tiina bonchchintteezay Xooss tiina borintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Muse higgaynnee nabitay kiitay Waannisa hellodayis yinttis odinttittar gam7eeza. Yeyppe guye, Xoossa kaatetitha Wonggilay oothittar gam7eeza. Asii ubbay ye aqa gelodayis dafinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Maaqqozin, higgaypp pettii laafa pidaale attodaypp salorannee sa7ar aadhizay shawukkiza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Fa machchat dakkii hara ekkiza ubbay wodire laammiza. Fa azinaypp anjjitteezano ekkeeziykka wodire laammiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ali7onnee buquro afila ma77iza, sa7a hanin gallas gallas ufayisar yez pettii dure as yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hara ma gallay muumer madunxeez pettii Alaazara ginttinttiz manqqay ye dure athay bale doginttii atteezay yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nayepp dendeezayid dure athay leematepp wodhdhiz gufa maadayis amotitar yeza. Hara attozin, kanitay yi7ii e madotha laa7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ye manqqay yhayqqeeza; kiitanchchitay eza Afraame ki7o kanggeeza. Ma dure athaykka yhayqqii moogintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Si7oole un77inttii yezitar dhoqqi gi haakor Afraamennee e ki7o yez Alaazara be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","E, ‹Adayyo Afraame, taasi qadhinttooye; yha lathi tamay gancce eexxittar yez gishos Alaazare fa biradhdhe xeerato haatha dakkii ta iranthato laakithod garkk hayyana eza dakkooye› yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Zin Afraame eziko, ‹Ta na7ayyo, ne sa7a yessayid lo77o baz ekkeezanannee, ma Alaazare iita baz ekkeezana akakoba. Zin yhatti E yhaydda ufayttiza, ma neenii waayttar yeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yha ubbapp aadhii, ‹Yhayppe yinttiko, yinippe yhana nuuko aadhodayis koyizitay piinggaam garkk nuusinnee yinttis gancce damma gaga yeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Dure athay, ‹Ta adayyo, yeezako Alaazara ta aday kara kiittod garkk ta nena woossiza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Taas ichchin ishitay yeza, unttikka yha meto aqa ye7aamay garkk unttis yhanigii markkatto› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Zin Afraame, ‹Unttiss Muserannee nabitayir yeza; unttii odeez baz si7o› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Dure athay, ‹Adayyo Afraame, yey garkk baaya; pettii asii yhayiqopp denddii yhanigiko unttii maarotith geloda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Afiraame, ‹Musennee nabita si7aam ixxiko, hara attozin yhayiqopp pettii asii denddii odikokka ammanenna› yeegeeza.» ");
INSERT INTO mfxl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuusa fa tamaaritayiko, «As dhubithii nagara gelssizabaz yi7ithay attenna. Maaqqozin, nagara gelod garkk oothiza athay ayye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ye athay xiqqitaypp petta balithodaypp woxa fa qoodhel accii abba gancce qitiko ezisi lo77o. ");
INSERT INTO mfxl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yey gishos naaginttoytta. «Ne ishay nagara oothiko kaccoba; qiiradhdhii maarotithar maaqqiko, ezis atto goba. ");
INSERT INTO mfxl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pettii gallas laappun toke qohi, laappun toke, ‹Taanii ta buuta ereeza tana maaroba› yeegii yi7iko ezis atto goba.» ");
INSERT INTO mfxl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hawaaritay Godayiko, «Ammano nuus gujjooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Goday, «Sannaficce aafe garkk ammano yinttis yeziko ‹Yha wala shodinttii abba gancce tukinttoba› yeegiko yinttis kiitinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gujjikka Yesuusa, «Yi gancceppe pettayis wootiza woy dure heenggiz aylle yeziko ooso gadepp woy wudepp kara maaqqadar ‹Elle katha maadayis yhana yi7ii bettoba› yeegizay yenee? ");
INSERT INTO mfxl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Baaya, ‹Taas kaho giigisoba; ta mi, uzhii ashshod gatho eqqii muzoba. Yeypp guye, ne ma maadannee uzhoda› yeeginbaasa? ");
INSERT INTO mfxl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yikkee, goday, ayllay kiita poleez gishos anjjinee? ");
INSERT INTO mfxl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yey gishos, yinttikka kiita ubbita poleez wode ‹Nu pathoowa ayllitay; oothodayis beeziza ooso poleeza› yeegoytta» yeeggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuusa Yerusalaame yhanigittar Samaaresinnee Galila biittas ganccer qoo7ii aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pettii heera gelodar boriqontto harger aykintteez taphphii asitay ezana denggeeza. Unttikka haakko eqqii, ");
INSERT INTO mfxl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Goda Yesuusa, nuus qadhinttooye» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","E unttan bi7ii «Yhanigii yi galla Ayihuditay qeese beezoytta» yeeggeeza. U oger yhanigttar geezheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unttapp pettay fa geezhitha bi7ii dhoqqi geez qaalar Xoossa bonchchittar Yesuusako maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ezii Samaare biitta as, zin Yesuusa tokayil afa xuggunii eza galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuusa, «Geezheezay taphphii asita baasa? Yeezin, uddufuntay aba yenee? ");
INSERT INTO mfxl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yha allaga athaypp attin hara maaqqii Xoossa galatiza as benttekaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Athayiko, «Ne ammanay nena geeshsheeza; denddii qitoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ferisaawe asitay, «Xooss kaatetithay ayide ye7odee?» gi Yesuusana oycceeza. E, «Xooss kaatetithay naagor ye7ooya. ");
INSERT INTO mfxl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Maakka izo, ‹Yhannee woy yinne yeegodayis danda7ooya. Abis giiko, Xooss kaatetithay yi gancce yeza› » yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuusa fa tamaaritayiko, «As Na7ay gallasitaypp petta be7adayis yi amottiz woday ye7oda, zin yi be7aamii. ");
INSERT INTO mfxl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asay, ‹E yeyid yeza› woy, ‹Yhaydda yeza› yeegoda, zin unttan kaallii yhanigppatte. ");
INSERT INTO mfxl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Zeelinthii zeellinggii salo gaxapp gaxa poo7isizay garkk As Na7ay yi7ithi gallasay yey garkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Zin yeyi hanodaypp tiina As Na7ay gaame waayodayisinnee yha yeletithayid ixinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nohe wode haneezay garkk As Na7ay wodayidakka yey garkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohe Markkabe geleez qamma hellodayis asay miitarannee uzhittar, ekkittarannee gelittar yeezin dhabisiza haathay yi7ii ubbita dhabiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Looxe laythakka yey garkk haneeza. Asay miitarannee uzhittar, woonggittarannee bayizittar, tukkittarannee keexxittar, gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Looxe Soodomappe kezeez gallas diinnee ginttinttiz xuuggiz tama salopp bukkii ubba baz dhabiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","As Na7ay benttiz wodekka yey garkk hanoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ye gallas oonkka bale yezay keethal yezaykka gancce yez baz ekkodayis kara gelippe. Yey garkke, gade yez asii abisikka kara maaqqippe. ");
INSERT INTO mfxl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Looxe machchato akaakoytta; ");
INSERT INTO mfxl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Fa shemppato ashshodayis koyiz asii oonkka dhabisoda; fa shemppato aathii inggiz oonkka ashshoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta yinttis odiza; ye gallas nam77ii asay pettii arssal woyi7ada. Pettay ekinttoda, yhankkay attoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nam77ii maachchitay wolla gaaccodar pettat ekinttoda, yhankkat attoda. ");
INSERT INTO mfxl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nam77ii asay wolla gade wootizitaypp pettay ekinttoda, yhankkay attoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Unttii, «Godayyo ana ekkinttodee?» yeegii oycceeza. E, «Gawuxa yez bessa ankko shiiqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuusa fa taamarita azalekka ubba wode woossod garkk tamaarssodayis kozhii yeegii aaziso odeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Pettii katama Xoossis yashittowa asisikka yeellatoowa pettii dayinay yeza ");
INSERT INTO mfxl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ye katama gancce pettii am7at yeza. Izakka, ‹Taasinnee ta morkkay gancce yez moota pirddoba› yeegii ubba wode ye dayinnakka daaburssiza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Daynnay xiqqa wodes i oda si7aam ixxeeza, zin guyepp fa wozinar qopp, ‹Taanii Xoossis yashittaam, asis yeellataam ixxikokka, ");
INSERT INTO mfxl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yha am7at tana ubba wode waayithiza gishos izis pirddoda; yeegii qoppeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Godaykka, «Wuce dayinay geezana yi si7oytta; ");
INSERT INTO mfxl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoossay qammannee gallas eziko uukkiza fa maraxxeezitayis pirddoosa? Unttan maaddodayis gam7inee? ");
INSERT INTO mfxl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta yinttis odizana si7oytta, ellisii pirddoda. Maaqqozin, As Na7ay yi7iz wode sa7all ammano demmadeshsha?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma mahii, Yesuusa, fana geeshsh as garkk uddii ceeqinttizitaysinnee yhankkita borizitayis yhay garkke yeegii aaziso odeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nam7i asitay woossodayis Xooss kara yhanigeeza. Pettay Ferisaawe yhankkay ma qaraxe gachisiz as. ");
INSERT INTO mfxl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ferisaaway eqqii paas woossittar, ‹Xoossayyo taanii yhankkitay garkk bonqqiza, zhucannee laammiza as, ubbarakka ma yha qaraxe gachisiz athay garkk baa gishos nena ta galatiza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saaminttapp nam7i toke xoomiza, ta denggizbaz ubbaypp asiraata kessiza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Zini qaraxe gachisizay ma haakor eqqii hara attozin salo dhoqqi gi be7adayis yashittii fa tira qoxxitar ‹Xoossayyo, tana nagaranchchana maarooye› yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta yinttis odizana si7oytta; Farasaawayppe yhay qaraxe gachisizay Xooss tiina geesh maaqqii fa kara maaqqeeza. Abis giiko, fana dhoqqi dhoqqi udiza as kawuzhoda, fana kawushiza as dhoqqi dhoqqi goda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesuusa duude na7itayil afa fa kusha gaddii anjjoday garkk asay eeko ki7iza. Yesuusa tamaaritay yeya bi7ii abis Yesuusako ki7inee yeegii kacceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zin Yesuusa na7ita faako xeegii, «Na7itay taako ye7odana kayppetee; ye7o goytta. Abis giiko, Xooss kaatetithay yhayititay garkk haneezitayis. ");
INSERT INTO mfxl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta yinttis turo odiza; Xooss kaatetitha duude na7ita garkk ekkozay oonkka ezayid gellamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayihude halaqqitaypp pettay, «keeha asitamaarayyo, medhina de7o denggodays ab ootho?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuusa eziko, «Abis tana keehayyo yeegii xeegee? Pettii Xoossapp attin hara keeha baaya. ");
INSERT INTO mfxl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laammippe, wodhippe, kasitippe, worddo markattippe, ne adannee ne indat bonchchoba yeegiz kiita erinee» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Athaykka, «Yeyitita ubba ta na7atithapp aykkii naagttar gam7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuusa yeya si7ii «Yeezako, nees pettibaz pacciza; nees yez baz ubba bayizii manqqitayis inggoba; salo nena shalo naagiza. Yeezii maaqqii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zin athay yeya si7ii ezis gaame shalo yeza gishos iita qiiratteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuusa atha bi7ii, «Dure asis Xooss kaatetithii gelo wayizii un77odeshsha! ");
INSERT INTO mfxl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dure Xooss kaatetitha gelodayppe gimaale narppe lukor aadhizay shawukkiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yeya si7eez asitay, «Yeya maaqqiko o attodee!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesuusa, «Asis danda7inttoowa baz Xoossis danda7inttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phixiroosa, «Yeezako nu nubaz ubba ashshii nena kaalleeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","«Yesuusa tuma ta yinttis odiza; Xooss kaatetithayis gi fa kara woy fa machchato woy fa ishita woy fa adannee fa indat woy fa na7ita ashsheezay; ");
INSERT INTO mfxl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yha wodayid gaame dakko, ye7od alamayid medhina de7o ekkozay oonkka baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuusa taphpho nam7ita faako xeegii, «Ane Yerusalaame wolla yhammada, nabitay As Na7ay bagga xaafeezibaz ubbitay ezayid polinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","E Ayihude baa asayis aadhii ingginttoda. U eza toochchoda, cazhodannee ezal afa cuttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eza garafeezaypp guye wodhoda, Zin hayidzantho gallas E yhayiqopp dendoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Zini e tamaaritay yey ubbaypp pettibazkka akaakekkaya. E xuuray unttis qosintteez gishos E waageezakko erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuusa Iyarkko ukkodar pettii to7a athay oge gaxa bettii woossiza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","To7a athay asitay ye aqayir aadhodar si7ii, «Yey abba?» gi oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","U, «Naazirete Yesuusa yhayir aadhiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","E, «Dawute na7ayyo, Yesuusa, tana maarooye» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tiin tiin yhanigizitay, «Hayizoba» gi qoddeeza. Zin E, «Dawute na7ayyo, tana maarooye» yeegii darisii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuusa eqqii atha faako ko7od garkk kiiteeza. Athaykka, eeko shiiqin, ");
INSERT INTO mfxl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ta nees ab udod garkk koyee?» yeegii oyceeza. To7ay, «Godayyo ta be7adayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuusa, «Bo7oba, ne ammanay nena patheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Athay izir bi7ii atteeza. Xoossa bonchchittar Yesuusa kaalleeza. As ubbay yeya bi7ii Xoossa galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuusa Iyarkko gelii aadhiza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ezayid Zakkoosa ginttinttiz qaraxe gachisizitay halaqay yeza. E gaame dure. ");
INSERT INTO mfxl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E Yesuusa aayazako be7adayis koyeeza. E haata maaqqeez gishos asii darotithaypp dendeezayid Yesuusa be7adayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesuusa be7adayis kozhii E yhanigiza ogayis tiina woxxii yhanigii pettii gasare mithal afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuusa ye aqa hellittar dhoqqi gi bi7ii, «Zakkoosa, yhayino ta ne kara peezhodayis beeziza gishos ellithii wodhdhoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","E ellis wodhdhii ufayisar Yesuusana mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ye aqayid yez as ubbay yeya bi7ii, «Nagaranchcho kara gelii mokinttodayis haniza» yeegii zigireeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maaqqozin, Zakkiyoosa eqqii Godayiko, «Godayyo, yeezako taas yez shalo ubbaypp bagga manqqitayis immada. Asapp abikka worddor balithii ekkeezbaz maaqqiko oyddii kushe mahoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesuusa ma, «Yha athay Afraame na7a maaqqeez gishos yhayino atotithii yha kara ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","As Na7ay ye7eezay dhabeezana koyodayisinnee ashshodayis» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asay yeya si7ittar yezin Yesuusa Yerusalaame ukkeez gishos Xoossa kaatetithay yhatt ukkeeza aazeez gishos unttis aaziso odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yey gishos, Yesuusa, «Pettii damma asii yezay faasi kaatetithii mawute ekkii ye7odayis hara biitta yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ezis oothiz ayllitaypp taphphita xeegii taphphii minaanee inggii ‹Ta maaqqii ye7od gatho yha miishayir zal7oytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Ye gade asay eza ixxiza gishos yha athay nuul afa kawutoda garkk nu koyooya yeegii as e guyer azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Maaqqozin, ye athay kaat maaqqii fa biitta maaqqeeza. Ye taphphii ayllitay E inggeez miishayir ab garkk zal7i wodhiseezako erodayis kozhii unttan xeegiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Tiinay yi7ii, ‹Godayyo, ne taasi inggeez miishayil hara taphpho wodhdhiseeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«E Goday, ‹Neno ammaninttiza ayllayyo ne lo77o ootheeza. Neenii xiqqa bazal ammaninttiza gishos neesi taphphii katamitayil afa mawute inggeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Nam7anthaykka yi7ii, ‹Godayyo, ne taasi inggeez miishay hara ichchin wodhdheeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Goday eziko, ‹Nessikka ma ichchin katamitayil afa mawute inggeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Yeezako hadzanthay yi7ii, ‹Godayyo, ta qanxxor xaaxii naageez ne miishitta yhannasho. ");
INSERT INTO mfxl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Abis giiko, ne gaddekka baz ekkizanannee ne zerekkabaz maxiz iita as maaqqiz gishos neesi ta yashitteeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«E goday mahii, ‹Neno iita ayllayyo ne doonatiigarkk ta nena pirddoda. Ta gaddekka baz ekkizanannee zerekkabaz maxiz iita as maaqqeeza ne eriko, ");
INSERT INTO mfxl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ta yi7ii ta miisha wodher ekkodgarkk zal7iza asis abis inggekkasa?› ");
INSERT INTO mfxl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«E goday ye aqayid eqqeezayiko, ‹Ezar yez miisha ekkii taphpho wodhiseezayis inggoytta› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Unttii, ‹Godayyo, ezisi binnikka taphphii minaanay yeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Goday, ta yinttis odiza; ‹Yeza ubbayis hara guzhinttoda, zin baazaypp haray atto ezisi yezanakka ekinttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maaqqozin, ta unttal afa kawutamay garkk koyeezita ye ta morkkita yhana ta tiina ki7ii wodhoytta› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuusa yeya odeezaypp guye unttapp tiina aadhii yedhdhittar Yerusalaame yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Debireezeytte Amibal afa yez Beetefaagennee Bitaana ukkittar fa tamaaritaypp nam7ita yeegii azazeeza: ");
INSERT INTO mfxl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Yi tiina yez heera yhanigoytta, yi ize hellodar oonkka toggibe7ekka accinttii yez hare na7a yi demmada. Eza billii yhana ekkii ye7oytta. ");
INSERT INTO mfxl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Oonkka, ‹Abis billee?› gi oyiciko, ‹Goday eza koyiza› yeegoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiitintteezitay yhanigii E geezay garkk hanin be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Unttikka hare na7a billodar goditay bi7ii, «Hare na7a abis billee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Unttii mahii, «Godayis e koshshiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ezaypp hare na7a Yesuusako ke7eeza. Fa afila hare na7ay zokkayil hixxii Yesuusana togiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asaykka E yhanigiza ogayil afa fa afila hiixeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Debireezeytte Derell sulleth Yerusalaame wodhisiz ogeko ukkodar tayibor gaame asay unttii be7eez malatayis ufayttii fa qaala dhoqqi udii, Xoossa galata aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Goday sunthar yi7iz kaatay anjjintteezaya salo saro, ubbappi dhoqqe salo bonchcho, Xoossayis maaqqo» yeegii Xoossa galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Asay gancceppe pettii pettii Ferisaawe asay Yesuusako, «Asitamaarayyo, ne taamarita hayizisoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E unttiko, «Unttii si77e giiko shuchchitay uukkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuusa Yerusalaame ukkittar katama bi7ii izisi yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Nees sarayis maaqqadana yhayino ne erekkaya, yhattekka ne aafaypp qositteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne morkkitay ne kala gasi fa oger oger nena mari un77ithiza wode ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nenannee ne gase giddo yez ne na7ita dhabisoda. Pettii pettii shuchchi denthii laalloda, abis giiko Xoossay nena ashshodayis yi7iz woda ne erekkazay gishshosi» yeegii izis yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yeyppe guye, Yesuusa Xoossa keethi gelii zal7izita ezaypp bayi7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma, «‹Ta keethay Xoossa woossiza keethi maaqqada› gi xaafintteeza, zin yi ta keetha paannitay komi7o udeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gallas gallas Xoossa Keetha taamarissiza. Qeese halaqitay, higge asitamaaritaynnee gade cimitay eza wodhodayis oge koyiza. ");
INSERT INTO mfxl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Maaqqozin, asii ubbay e timirtta fa wozinas aathii si7iz gishos unttis oothod baz dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pettii gallas Yesuusa Xoossa Keethi gancce asa tamaarssodarannee Wonggile markkattodar, qeese halaqitay, higge asitamaaritaynnee gade cimitay wolla eziko yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«Ne yhayitita aba mawuter oothizako nuus odoba. Yha mawuta neesi inigeezay oonoo?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E unttiko, «Taakka yinttan pettibaz oyccoda, ane taasi mahoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xammaqqiza Waannisa xinqqatay Xoossapenne asappee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","U woli gancce yeegii tobbeeza: «Xoossapp giiko yeezin, abis ammanekasa?» yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","«Asapp giiko, asii ubbay Waannisa nabe maaqqizana ammaniza gishos nuna shuchchar shocoda.» ");
INSERT INTO mfxl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yey gishos, «Anappezako nu erooya» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuusa mahii, «Yikkee, taakka aba mawuter yhayitita oothizako yinttis odaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yeypp guye, Yesuusa yeegii yha aazisa asayis odeeza: «Pettii asii woyine tukkeeza. Wootizitayis mattaye inggii gaame wode gam77ii ye7odayis hara gade yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woyne aafa maxiza woday hellin woyine aafaypp ezisi dakkod garkk biitta wootizitayiko fa aylla kiiteeza. Zin wootizitay ye aylla aykkii yhadhdhii kallo kushe dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma maaqqikka hara aylla kiiteeza. Ma biitta wootizitay eza yhadhdhii, toochchii kallo kushe dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yhattekka mahii hayidzantho aylla kiiteeza. Wootizitay ezakka yhadhdhii madunthii woynnee ganccaypp gaxa kessii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Woyine goday, ‹Yeezin ta ab ootho? An ma ta qadhdhiza ta na7a dakkoda; oonii eree u eza bonchchekka ashshaamii› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Zin biitta wootizitay athay na7a bi7ii ‹Yhay eza laattodaya, yhana ye7oytta eza wolla wodhoda, yeeziko laatay nuus maaqqada› yeegii tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woyine ganccepp gaxa kessii wodheeza. Yeezin, woyine goday ye asita wayssadee? ");
INSERT INTO mfxl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yi7ii ye biitta wootizunthan wodhoda, woyine gadana hara asayis immada. Asay yeya si7eez wode ‹Shinchchalle yey garkk baz hanippee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuusa unttan dakkii bi7ii, «Yeezin ‹Gimbbe keexxiza asay boreez shuchchay, keeth muumer tookkii aykkiz Kirkiro garkk ubbapp adhiz shuchchi maaqqeeza› ginttinttii xaafintteezayis birshshithay abba? ");
INSERT INTO mfxl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ye shuchchyil afa wodhiz ubbay gaccinttoda, shuchchay ezal afa wodhdhiz ubbitaykka gaacinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Higge asitamaaritaynnee qeese halaqitay yha aazisay odintteezay unttal afa maaqqeezana erii ye wode eza aykkodayis koyeeza, zin woyayis yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yey gishos, Yesuusa gade aqisiza Oroome kaatayis aathii immadayis koyii e doonapp buuta qaala naagiza. Yeya polisodayis geeshsh as aazii qohiz asita eziko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiitinttii yhanigeez asay, «Asitamaarayyo, neenii odizayinee tamaarssizay likke maaqqeeza, ma Xooss oge tumatithar tamaarssizannee oonakka shaakkoozana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hano zin, Oroome kaatayis giira giirodayis beezinennee beezoosa?» yeegii eza oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Zin E u wozina iitatitha ereezi gishos ");
INSERT INTO mfxl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ane tana pettii santte beezoytta, Ezal afar yez misilaynnee sunthay o bazo?» yeegeeza. U mahii, «Qeesaareessii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","E mahii, «yeezako, Qeesareesa Qeesaares, Xoossiisa Xoossis inggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yey gishos, E maheezi malssaypp woyay tiina buuta denggodays danda7ekkaya. U e mahiz malssa malabaz gi si77e geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yhayiqopp denddo baaya yeegiz Saduqaawitaypp pettay pettay Yesuusako yi7ii, ");
INSERT INTO mfxl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Asitamaarayyo, pettii asii machcho ekkii na7a yelekkazar yhayqqiko, e ishay ye machchato ekkii na7ita yelii fa ishayis kochchii ashshoday garkk Muse xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yeezako laappun ishitay yeza. Bayiray machcho ekkii na7a yelekkazar yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","E kaalaykka izo ekkii na7a yelekkazar yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hayidzanthaykka yey garkk haneeza. Laappunitay ubbay yhay garkk hanii izo ekkeeza, zin na7a yelekkazar yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wurssithal asitakka yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yikkee, laappun ishitay izo ekkeez gishos yhayqqopp denddiza wode iza o machcho maaqqadee?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesuusa mahii, «Asay yha alamayill ekkizannee geliza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Zin yhayiqopp denddii ye7od alamayill yezodayis beeziza asay ekkooyannee gelooya. ");
INSERT INTO mfxl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Unttii kiitanchcho garkk maaqqiz gishos tiinapp yhayqqenna. Yhayiqopp dendeez gishos unttii Xooss na7ita. ");
INSERT INTO mfxl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muse Goda, ‹Afraame Goda, Isaaqa Goda, Yayqqooba Goda› maaqqii tusha wora gancce xuuggiz tama taarika xaafeezayid yhayqqeez asay denddizana beeziza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ubbay ezis path yeza maaqqiz gishos E pathi yezitay Godaypp attin yhayqqeezitay Goda baaya» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Higge asitamaaritaypp pettay pettay, «Asitamaarayyo, lo77o baz ne odeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yeyppe guye, hara oych oyccodayis yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ezaypp maaqqii Yesuusa unttiko, «Asay Kiristtoosa wayizii Dawute na7a yeegee? ");
INSERT INTO mfxl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Abis giiko, Dawute fa ubbas fa mazmuure maxaafayid, «Xoossay ta Godayiko ‹Ta ne morkkita; ne tokay yedhdheez besse oothod gatho, taapp ushachch baggar bettoba› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Yikkee, Dawute Kiristtoosa, ‹Goda gi xeegittar ezis na7a wayizii maaqqee?› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Woya ubbitay si7odar fa tamaaritayiko, ");
INSERT INTO mfxl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Aduss afila ma77ii yuushshe dosizitaypp, gabe gancce bonchcho sarotho, Ayihuditay Woosa Keetha bonchcho oyde, mokinttiza karakka bonchcho aqo koyiz higge asitamaaritaypp naaginttoyta. ");
INSERT INTO mfxl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Unttikka am7itay kara kallosiza, geesh as aazii as beezodayis woosa adussiza. U iita pirdde ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dure asay Xooss Keetha muxaata saaxine olodar Yesuusa dhoqqi gi asa be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma pettii manqqo am7at nam77ii sikkina olodar bi7ii, ");
INSERT INTO mfxl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«Ta yinttis turo odiza; yha manqqo am7at ubbapp aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Abis giiko, yha asii ubbitay fassi yeza bazapp inggeeza, Zin iza fa paccattipp, paas yez aqo peesh ubba inggeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesuusa tamaaritaypp pettay pettay Xooss Keethay gaame lo77iza shuchcharannee asay Xoossis inggeez imotar lo77eezana odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Zin Yesuusa, «Yha yi bi7iza bazay ubbitay laalinttekkazar, shuchchi shuchchal afa gimbbintteezay garkk attam wode ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Unttikka, «Asitamaarayyo, yha ubbitay hanoday ayide? Ma yhay hanodayis mallay abba?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesuusa yeegii unttiss malsse inggeeza: «Balinttamay garkk naaginitoytta. Gaamitay, ‹Taanii Kiristtoosa, woday ukkeeza› yeegittar ta sunthayir ye7oda, zin yi unttan kaallippate. ");
INSERT INTO mfxl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yi ola baggannee cabbo si7eez wode dagammippate. Yey tiinattii hanoday attowa baz maaqqiz gishos wode wurssithay ellis ye7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Maakka, «Woyay woyal afa, kaatetithay kaattetithal afa dendoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gita biitta eni7o hanoda, nayennee gado duma duma bessa daroda, yashshizibazinnee gaame malatitay salopp benttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Zin yha ubbay hanodaypp tiina ta sunthay gishos gi asay yinttan bayi7odannee aykkoda. Ayihuditay Woosa Keethi ganccennee achch keetha yinttan dakkoda. Kaatitay tiinannee gade aqisizitay tiina yinttan kammada. ");
INSERT INTO mfxl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yeykka ta bagga yi unttiss markattodayis lo77o oge maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yey gishos, yi oyccinttiz wode waagii malsse immade gi yi wozinar un77inttaam garkk akaakoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Abis giiko, yi morkkitay yinttar eqinttodayssinnee palamodayis danda7oowa doonannee eccetithii ta yinttis immada. ");
INSERT INTO mfxl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hara attozin, yinttan yeleezitay, yi ishitay, yi dabbitayinnee laggitay yinttan aathii immada. Yi ganccepp petta petta wodhoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta sunthay gishos asii ubbitay tiina yi ixintteezita maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Zin hara attozin, yi cimibayppe pettii binnanakka dhabenna. ");
INSERT INTO mfxl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yi, Danda7ar, yi shemppo ashshoda.» ");
INSERT INTO mfxl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Yerusalaame katamay wotaaddaritayir marinttii betteezin yi bi7iko izis dhabo ukkeezana eroytta. ");
INSERT INTO mfxl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ye wode Yihuda giddo yez ubbitay amiba guye qosintto, katama yezitay yeypp kezo, gaxare yezitay katama gelippe. ");
INSERT INTO mfxl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Abis giiko, yha xaafintteezibaz polinttod garkk yeyi Xoossay kushe mahiz wode. ");
INSERT INTO mfxl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa7all afa damma meto ye7oda, ye sa7ayidakka asal afa Xooss kachchii ye7oda. Yey gishos, wodexxezitannee dhanthizita ayye. ");
INSERT INTO mfxl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","U mashshar yhayqqada, asii ubbitay allaga biitta di7inttoda. Ayihude maaqqekka asita woday polinttod gatho Yerusalaame unttar yedhintteeza maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Awa, aginarannee, xoolinttitayil afa malatitay hanii benttoda. Abbappennee zulo shochaypp dendeezayid biittal yez asay yashittii un77inttoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Salo wolqqitaykka buqinttoday gishos asay yashsharannee biittal afa abi haneneshsha gi naagor fana dogoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ye wode As Na7ay wolqqarannee gaame bonchcho shaarar ye7odar u be7ad. ");
INSERT INTO mfxl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yi atotithay ukkeez gishos yha hanitay polintto aykkiz wode giiginttii eqqoytta, dhoqqi gi bo7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma maaqqikka, yhay garkk gi aaziso odeeza: «Balase mithinnee hara mithii ubba bo7oytta. ");
INSERT INTO mfxl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","U hayay furicodar bone ukkeeza yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yey garkk yha hanitay polnttodar yi bi7iko Xooss kaatetithay ukkeezana eroytta. ");
INSERT INTO mfxl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ta yinttis turo odiza; yha ubbay polinttod gatho yha yeletithitay aadhaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Salonnee sa7a aadhoda, zin ta qaalay aadhaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Yikkee, yi ushshii darorannee, mather yessis un77inttii yi wozinay aykkinttam garkkennee ye qammay akaakekkazin xike garkk yinttal afa hellaamay garkk naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ye qammay biittal yez ubbayil afa hellii xikisii aykkoda. ");
INSERT INTO mfxl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yey gishos, yi7iza iitaypp attodayissinnee As Na7ay tiina eqqodayis danda7od garkk ubba wode miinggii woossoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gallas gallas Yesuusa Xooss Keetha tamaarssittar, qamma qamma Debireezeytte Amibal afa kezii aqiza. ");
INSERT INTO mfxl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asay ubbitay eza si7odayis wontt guura eziko Xoossa keetha yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ye wode Faaziqa yeegiz boora Baale ukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Qeese halaqitaynnee higge asitamaaritay asayis yashitteez gishos wayizii Yesuusa fa ganccepp dhabisodazako oge koyiza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xalahe taphpho nam7itaypp petta maaqqeez Asiqorontto Yihuda ginttinttizay gancce geleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yihuda qeese halaqitayikkora Xoossa Kara naagizitayis halaqitayiko yhanigii Yesuusa wayizii aathii inggodazako unttar maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Unttikka yeyid ufayttii miishe ingodayis ezar tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ezikka ye zorayid giigeeza. Unttis asii erekkazin Aathii immadayis giiga wode naagttar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yeyppe guye, Faaziqa duray shukinttiza boora Baale helleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuusa, «Faaziqa kaho maaday garkk yhanigii nuus giigisoytta» yeegii Phixiroosannee Waannisa kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","U, «Nu aba giigisod garkk ne koyee» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E unttiko, «Yeezako yi katama gelodar haath ota tookkeez athay yinttan helloda. E yhanigii geliza kara eza kaali geloytta. ");
INSERT INTO mfxl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ye kara adayiko asitamaaray, ‹Ta ta tamaaritayira wolla Faaziqa kaho maadayis imathi shemppiza kara aba yenee? yeegeeza› goytta. ");
INSERT INTO mfxl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","E pooqeel afa hiixinttii giigii yez dalgge kifile yinttan beezoda, ezayid makkoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","U yhanigii Yesuusa geezay garkk hanin denggeeza. Faaziqa baale kaho ezayid giigiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saataykka helleez wode Yesuusa hawaaritayir wolla kahol afa betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","E unttiko, «Ta waaye ekkodaypp tiina yha kaha yinttar maadayis lo7ithii amotteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yikkee, si7oytta! Xooss kaatetith yhayis birshshithay polinttod gatho yhayinopp guye yha kaha mahii maamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ushsha ekkii galatii maaqqii, «Yashitte yhaya yi gancce shaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Si7oytta! Xooss kaatetithay ye7od gatho yhayinopp aykkii yha woyine ushshaypp maaqqii ta uzhaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Boora denthii ekkii, galatii maaqqii, «Yhay yinttis ingginttiza ta asho. Yhaya oothittar tana qoppoytta» yeegii unttis baxxii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yey garkkekka, kahopp guye ushsha ekkii, «Yha ushshay yinttis laalintteez ta suuth maaqqiz oroth caaqo. ");
INSERT INTO mfxl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Maaqqozin, tana aathii inggod athay kushay taar wolla pili7o gancce yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","As Na7ay ezis giinttintteezay garkk yhayqqodayis yeza, zin eza aathii inggiz athaya ayye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","U fa gancce, «Yhaya oonii oothodee» gi woli oyccichcheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma u gancce aadho maaqqaday oonoo giz palama medhintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuusa unttiko, «Gade kaatitay fa asita wolqqar mooddiza; fa gadel afa godatizttayikka fana, ‹Lo77o oothizita› yeeginttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Zin yi gancce yey garkk maaqqippe. Yi gancce bayratizay kaalo garkk hano; kaalithizay kaallizay garkk hano. ");
INSERT INTO mfxl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hano zin, mokkizayppennee Mokinttizaypp aayi aadhee? Mokinttiza baasa? Zin taanii yi gancce mokkizay garkk. ");
INSERT INTO mfxl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yinttikka ta metayir taapp shaakinttoowa taar miinggii eqqeezita. ");
INSERT INTO mfxl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Yi ta leematepp maad garkk, uzhod garkkennee zufaanitayil afa bettii taphpho nam77ii Isreele sheeshitayil afa pirddod garkk ta aday tana shuumeezay garkk taakka yinttan ta kaatetitithayil shuumoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Maaqqikka Yesuusa, «Simoona, Simoona, Xalahe yinttan gistte garkke harqqodayis woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Zin taanii ne ammanay dhabaam garkk nees wooseeza. Neekka maaqqeez wode ne ishita minthathob» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoona, «Godayyo, taanii neer accinttodayisnnee yhayqqodayis giigintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuusa Phixiroosako, «Ta nees odiza; yhayino shugula uukkodaypp tiina ne tana hayidzii toke kaddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ma maaqqikka, Yesuusa unttiko, «Taanii yinttan korojjo, qurbonnee caamma baazin kiiteez wode yinttis pacceez baz yenee?» yeegii oycceeza. U mahii, «Akkokka paccekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","E unttiko, «Yhatti korojjonnee qurbo yezay aykko; mashsha baazay fa afila bayizii mashsha wonggo. ");
INSERT INTO mfxl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yhana si7oytta! ‹Zhucitayir taybintteeza› ginttinttii xaafintteezay taal polinttodayis beeziza. Ee, ta gishos xaafintteezibaz polinttizay tumateeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","E tamaarttay, «Godayyo yhaydda nam77ii mashsha yeza» yeegeeza. E, «Gidoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuusa kaseesay garkk denddii Debireezeytte Amibal afa kezeeza. E tamaarttay eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ye aqa helleez wode yi «Paace gancce gelaamay garkk woossoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Unttapp shuchchi dhogin helliza aqo garkk haakkii bunqqittii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Ta Adayyo, ne shene maaqqiko yha meto xuu7a taapp aathoba. Zin ta shene maaqqippe ne shenay hano» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Minthathiza. Kiitanchchay salopp bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gaame un77inttii miinthii woossiza. E cawaykka suuthii xokkizay garkk sa7a xokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesuusa woosa wurssii fa tamaaritayiko ye7eeza. U, azzanoppe dendeezayid daaburii gentteezin denggii, ");
INSERT INTO mfxl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Abis genttee? Paace gancce gelaam garkk denddii woossoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E haga odal afa yezin gaame asay ye7eeza. Taphpho nam7itaypp pettay Yihuda ginttinttizay unttan kaalithiza. E Yesuusa yeerodayis lanqqe Shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Zin Yesuusa, «Yihuda, As Na7a yeerii aathii immade?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesuusa tamaaritay ye hana bi7ii, «Godayyo nu mashshar gachcho?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","U ganccepp pettay qeese halaqay ayillayis shocii ushachch haytto gachchii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zin Yesuusa, «Ashshoba!» yeegeeza. Athay haya bochchii patheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeypp guye, Yesuusa fana aykkodayis ye7eez qeese halaqitayiko, Xooss Keeth naagizita shuumitaykonnee cimitaykko, «Paanno aykkiz as garkk mashshannee gufe aykkii ye7eenee? ");
INSERT INTO mfxl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ubba gallas Xooss Keethi gancce ta yinttar yez wode taal afa kushe gaddekkaya. Zin yhay dhuma kaatetithay mooddeez wodennee yi wode» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yeyppe guye, Yesuusa aykkii qeese halaqay zabba kanggeeza. Phixiroosa haakor Yesuusa kaalliza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asay qeese halaqay zabbayid tama eethii wolla betteezin Phixiroosa unttar wolla betteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pettii gadhindata Phixiroosa tama lanqqe betteezana tama foo7ayir dakkii bi7ii, «Yha athay ezar yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Zin Phixiroosa, «Yhan asitee ta ye atha erooya» yeegii kaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xiqqa saattepp guye pettii hara athay eza bi7ii, «Neekka unttapp pettabay» yeegeeza. Zin Phixiroosa, «Yha athayyo tana baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pettii saate garkk gam7eezaypp guye pettii hara athay tillisii, «Yha athay Galilapp maaqqiz gishos sidhe bayith ezar yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Zin Phixiroosa, «Yha athayyo, ne gizana ta erooya» yeegeeza. E ye oda wurssekkazin shugula uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Goday guye shirnttii eqqii Phixiroosa be7eeza. Phixiroosa, «Yhayino shugula uukkodaypp tiina ne tana hayidzii toke kaddoda» yeegii, Goday odeez qaalay ezis elqqi geeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phixiroosas bale kezii dukka suuth yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuusa naagiz asay eza laqqasonnee yhadho aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","E aafa goozii «An ne Nabezako eroba; nena shoceezay oonoo?» yeegii oyiciza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hara gaame cashshii cazhii kawushiseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa7a wonttiza wode Ayihude gade cimitay, qeese halaqitaynnee higge asitamaaritay shiiqii, Yesuusana fa tiina shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","U, «Ne Kiristtoosa? Ane nuus odoba?» yeegii oyiceeza. Yesuusa, «Ta odizakon yi ammanaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta oycizako yi mahaamii. ");
INSERT INTO mfxl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Zini As Na7ay yhaypp gede wolqqama Xooss ushachch baggar bettoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ye wode ubbitay, «Yeezin, ne Xoossa na7a?» yeegeeza. Ee, «Ta Xooss na7a maaqqeezana yi geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","U, «Yikkee, hara markka ab koshshee? E fa doonar ododar nu si7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ye aqayid shiiqeez ubbitay dendii Yesuusana Philaaxoosako kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Yha athay nu asita balethitar, Oroome kaatayis giira giiraamay garkk kayttarannee ma, ‹Taanii Kiristtoosa yi kaata› yeegodar nu denggeeza» yeegii mooteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philaaxoosa Yesuusana, «Neenii Ayihuditay kaatonnee?» yeegii oyceeza. Yesuusa, «Ee, ne geezay garkke» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philaaxoosa qeese halaqitayikonnee asayiko, «Yha athayil afa ta pettii buutakka denggekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Zini unttii, «Yha athay Galilappe yhaya hellodayis Yihuda muumer iita bazis denthithiza» yeegii miinthii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philaaxoosa yeya si7eez wode Yesuusa Galila aso yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesuusa Herodoosa gadepp ye7eez as maaqqeezana Philaaxoosa ereezaypp guye Herodoosa ye wode Yerusalaame yez gishos eziko dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodoosa Yesuusa be7adayis gaame wodeppe koyttar yez gisho eza be7eez wode gaame ufayttee. Abis giiko, ebaz si7eez gisho malabaz udin be7adayis amotitar yeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodoosa Yesuusana gaame oychchi oyceeza, Zin E abikka mahekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Qeesitay halaqitayinnee higge asitamaaritay ezayid eqqii miinthii eez mootiza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodosarannee e wotaaddaritayir Yesuusa laqqaser leqqeeza. Buquro afila ma7isii Philaaxoosako mahii dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heroodosarannee Philaaxoosar tiin morkkezin ye gallas wolla igintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philaaxoosa qeese halaqita, gade aqisizitannee woyita xeegii, ");
INSERT INTO mfxl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹Yha athay iita bazis denthithiza› gi taako yi ke7eeza. Taakka yi tiina pilagii bi7ini yi shiisheez mootayis aba buutakka eel denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodoosa, yey garkk aba buutakka ezal afa denggekka gishos nuuko dakkeeza. Tuma yha athay yhayiqos helithiz aba buutakka oothekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yey gishos, eza garafii billii dakkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yeya E geezay Faaziqa Baale wode pettii as achchapp unttiss billizay ezis attowa baz maaqqeez gishosi. ");
INSERT INTO mfxl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Woya ubbitay pettipp, «Yha atha gede hali7isoba, nuus Baribaana billoba» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baribaana katama gancce as iita bazis denthithii as wodhdhii accintteez asii. ");
INSERT INTO mfxl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philaaxoosa Yesuusana bili7odayis koyii asayis mahii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maaqqozin, asay, «sottoba! sottoba!» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philaaxoosa hayidzintho, «Yha athay qoheez bazay abba? Wodhos helithiz buuta ta denggekkaya. Yey gishos, garafii dakkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","U fa qaala dhoqqi udii, «Sotinttodayis beeziza» gi miinthii uukkeeza. U uufaykka usa dareeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","U oyichay gishos gi Philaaxoosa ezal afa pirddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Asa iita bazis denthithizannee as wodhdhii accintteezana billod garkk woosseez, ye atha unttiss bili7eeza. Zin Yesuusa unttii koyeez baz oothod garkk unttiss aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesuusana aykkii kammadar Simoona giz Qerena biitta athay gaxarepp ye7odar, denggii maziqala toossii Yesuusa kaallii yhammad garkk ciiphicheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gaame assaynnee u ganccepp fa tira qoxxitar yeekkiza maachchitay e guyayir kaalliza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zin Yesuusa unttiko guye maaqqii Yesuusa, «Yinttanno, Yerusalaame maachitayyo, yi ubbayisinnee yi na7itayis yeekkoyttapp attin taasi yeekkippate. ");
INSERT INTO mfxl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹Yezako dhonthitay, yelekka ulitaynnee ammisekka ammitay anjjintteeza› yi yeegoda gallasay ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ye wode ambitakka, ‹Nuul afa woddoytta›, deritakka, ‹Nuna qosoytte› yeegoda. ");
INSERT INTO mfxl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yikkee, irxxa minxxa yey garkk oothiko mela minxxa wayissadeshsha?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ezar wolla wodhodayis hara nam77ii paanita kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qeeraniyo ginttinttiz aqo helthii sotteeza. Paanitaypp petta ushachch baggar yhankka haddiris baggar sotteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesuusa, «Ta adayyo, u ab oothizako eroowa gishos neenii unttis atto goba» yeegeeza. U e afilayil afa ixa olii shaakinttii ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Asay eqqii be7adar, gade moodizitay, «E Hara asa ashsheeza; Xoossay maraxeez Kiristtoosa eza maaqqiko an fana ashsho» yeegii leqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wotaaddaritay eziko shiiqii, caala woyne ushsh inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yeezii, «Neenii Ayihuditay kaat maaqqiko ane ne ubba ashshoba» yeegii leqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ezis omma baggar, «Yhay Ayihuditay kaat» yeegiz xuufe Girikithora, Oromithora, Ibirayisxxithora xaafii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sottintteez paanno pettay cashshe sa7ar goochchitar, «An neenii Kiristtoosa maaqqiko, nenakka nunakka ashshoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Zin yhankko paannay, «Ne yhay garkk pirddar yezar hara attozin, Xoossis yashittaamoo? ");
INSERT INTO mfxl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuunii nu buutayis beeziza pirdde ekkiza, Zin yha athay pettii iitabazkka oothekkaya» yeegii kacintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Maakka, «Yesuusa, ne ne kaatetithar yi7iz wode tana qoppoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesuusa, «Ta nees turo odiza; yhayino ne taar gannatte yessada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ye gallas usuppun saatepp yhanigii uddufun saate gatho awa poo7o kayeez gishos biitta ubbayil afa dhuma maaqqeeza. Xooss Keeth magarazhay per7inttii nam77ii aqo shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuusa, qaala dhoqqi udii, «Ta Adayyo, ta ta shemppato ne kushayid inggeeza» yeegii yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mato halaqay, haneezaya bi7ii, «Yha athay tumakka geeshsh» yeegii Xooss galateeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yha hanizabaza be7adayis ye aqayid shiiqeez as ubbay haneezibaza bi7ii fa tira qoxxitar fa kara maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maaqqozin, Yesuusa lanqqe eriza as ubbay, yey garkkekka Galilappe kaalli ye7eez maachchitay yeya bi7ittar haakor eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ayihude shanggitaypp pettay, Yooseefa ginttinttiz athay yeza. E Armmatiyasa ginttinttiz Yihuda katamapp ye7eeza. E lo77onnee Geesh as maaqqiz gishos Xoossa kaattetithay yi7ithana naagiza. Shanggitaypp petta maaqqittar u zoretitharannee oosayir baaya. ");
INSERT INTO mfxl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ye athay Philaaxoosako yhanigii, Yesuusa aha moogodayis taas inggoba gi woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yesuusa aha wodhisii afilar xaaxeeza. Zaalla woocii kesseez hara as mooginttekka orothi duufo gancce gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Maala gelod haniza gishos ye gallasay giigintto qamma. ");
INSERT INTO mfxl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilappe denddii Yesuusa kaalli ye7eez maachchitay Yooseefar wolla yhanigii e aha wayizii moogizakko duufa akaakii be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ezaypp maaqqii shittonnee qibaate giigiseeza. Higge kiittizay garkk maala gallas shempp peezheeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saaminttapp Tiina gallas, wogga wode guura yeciyeco, maachchitay fa giigiseez shitto ekkii duufayiko yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","U ize hellodar duufay doona yez shuchchay gol77al7ii hali7eezana denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","U duufa helii geleeza, zin Goda Yesuusa aha denggeekaya. ");
INSERT INTO mfxl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","U ezayid eqqii abii haneenee gi qoppodar akaakekkazin booth pociz afila ma7eez nam77ii asitay u kale eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maachchitay yashittii fa omma sa7a ziqqi udii yezin, asitay unttiko, «Pathana yhayiqitay gancce abis koyee? ");
INSERT INTO mfxl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","E yhaydda baaya; yhayiqopp denddeeza, ‹asii Na7ay nagara oothizttay kushe aadhii inginttoda; unttikka eza sottoda. E hayidzantho gallas yhayiqopp dendoda› yeegii, E yinttar Galila biitta yezitar yinttis odeez qaala qoppoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maachchitay ye wode e qaala qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Maachchitay duufayipp maaqqii haneezibaza ubbita taphpho pettitayisinnee yhankkitayisikka odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yeya hawaaritayis odeezay Magdeela Mayramo, Yohaanna, Yayqqooba indat Mayiramirannee unttar yez hara maachitta. ");
INSERT INTO mfxl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Zin unttiss maachchitay odeezay elmmo aazin ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Zin Phixiroosa denddii woxxii duufo yhanigeeza. Ye aqa hellii zuggii be7adar moogo afila aadda be7eeza. Haneez bazayiss malabazigittar fa kara maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ye gallas kaalliza tamaaritaypp nam7itay Yerusalamepp taphpho nam77ii kilo mitire haakkiza Emahuuse heera yhanigiza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","U wolla haneezibaza ubbita odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","U ye hanay bagga qoppittarannee odinttittar yhanigodar Yesuusa fa ubbas shiiqii unttar yhanigiza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hano zin, unttii eza eraamigarkk u aafay aykintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","E, «Yi wolla ogel afa odinttizay abba?» yeegeeza. U azzanii si77e gi eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unttapp pettay Qeliyoopha ginttinttizay, «Yha qammitay gancce Yerusalaame haneezibaza eroozay, ne biittas imathonee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E mahii, «E haneezay abba?» yeegii oycceeza. Unttii, «Xooss tiinannee as tiina oosorannee odar miinthii nabe maaqqeez Naazirete Yesuusa bagga. ");
INSERT INTO mfxl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eza qeese halaqitaynnee nuna aqisizitay yhayiqo pirddes aathii inggii, sotteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuunii Isreele asa wozode gi ufayttii naageezin yhay hanin yhayino hayidzantho qamma. ");
INSERT INTO mfxl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma nu ganccepp pettii pettii maachchitay nuna doona ayitheeza. Unttii yhayino wontta guura duufo yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","E ahay dhabin maaqqii yi7ii, ‹E pathi yeza› yeegizana kiitanchchitay qonccisin be7eeza yeegii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nu gancceppekka pettay pettay duufa yhanigii maachchitay odeezay hanin be7eeza, Zin eza u be7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","E unttiko, «Yinttano, akaakowa asitayyo, yi wozinay nabitay odeez baz ubbita ammanodayis gam7izitayyo, ");
INSERT INTO mfxl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristtoosa yha meta ekkodayissinne fa bonchchayir gelodayis beezoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Museppennee nabitay ubbaypp dendii Geeshsha Maxaafayid ebazi xaafintteezana ubba unttiss paatteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Unttii yhanigiza gutayiko ukkodar Yesuusa aadhii haakko aqo yhanigiza aazin, ");
INSERT INTO mfxl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Unttii, «Sa7ay qammeez gishos nuur aqoba» yeegii miinthii woosseeza. Yey gishos, unttar aqodayis geleeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Unttar wolla munttal afa bettii, boora, denthii anjjii unttiss baxxii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ye wode unttii eroday garkk u aafay dooyintteeza. Unttikka ereeza. Zin E u kalayipp dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Unttii, «Nu ogel afa yeezin E nuus Geeshsha Maxaafa billittarannee nuur nashshodar nu wozinay xuuginttekasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ye wode dendii guye Yerusalaame ye7eeza. Taphpho pettitayira yhankkitay pettipp shiiqii yeezin denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Unttii, «Goday tuma denddeeza; Simoonas bentteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ye nam77ii tamaarttay Emmahuuse ogel afa yezin haneezanannee boora meez wode wayizii eza ereezako unttiss odeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nam77ii tamaaritay ye odayil afa yezin, Yesuusa u gancce eqqii, «Saro yinttis maaqqo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Maaqqozin, unttii dagammii, meeshe be7eeza aazin yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","E unttiko, «Abis dagameenee? Abis sidhe yi wozinayid geleenee? ");
INSERT INTO mfxl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta kushannee ta toka bo7oytta; ta tana. Maakka aykkii bo7oytta; taal yi bi7izay garkk, meeshes ashonnee meqqethii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yeegii, fa tokannee fa kusha unttan beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","U ufayssapp dendeezayid ammanekkazar malabaz guussal yezin, Yesuusa unttiko, «Yhaydda yinttis miizibaz yenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","U xiqqa michintteez molo ezis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","E ekkii u tiinayid meeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","E, «Ta yinttar gam7eez wode ubbayid Muse higge maxaafitayid, nabitay maxaafitayidannee Mazmuure maxaafitayid, ta gisho xaafintteezibaz ubbitay polinttodayis beeziza yeegii ta yinttis odeez qaalay yhaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ye wode Geeshsha Maxaafita akaakod garkk kaha unttis dooyeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yey garkkekka, «Kiristtoosa waaye ekkoda, hayidzantho qamma yhayiqopp dendoda yeegii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yerusalaameppe denddii as ubbayis nagaraypp maarotithaynne atotithi e sunthayir markkattoda. ");
INSERT INTO mfxl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yi yeyis markkita. ");
INSERT INTO mfxl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yeezako, taakka ta aday inggeez ufayssa yinttis dakkoda. Yi salopp wolqqa ma77od gatho Yerusalaame katama gam7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yeyppe guye, Bitaana katama unttan ekkii qiteeza. Fa kusha denthii anjjeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Unttan anjjittar unttapp shaakinttii udee salo ekintteeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","U zuggii goynnii gaame ufayssar Yerusalaame maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Xoossa ubba wode galatittar Xooss keetha gam7eeza.");
INSERT INTO mfxl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qaala Tiinapp yeza. Qaalaykka Xoossar yeza; ye Qaalay Xoosse. ");
INSERT INTO mfxl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tiina Qaalay Xoossar yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xoossay ubba baz Qaala baggar medhdheeza. Medhintteez bazapp pettii bazkka e baggar medhinttekkabaz baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ezar de7o yeza; ye de7ay asis poo7o. ");
INSERT INTO mfxl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Poo7ay dhuma poo7iza; dhumay poo7ana gamekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xoossii kiitteez, pettii Waannisa giz asii yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Asii ubbay E baggar poo7a ammanod garkk E poo7os markka maaqqii ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E poo7o bagga markattodayis ye7eezaypp attin fa ubbas poo7o baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","As ubbas poo7isiza tuma poo7ay alame yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ezkka alamel yeza. Alamaykka medhdhintteezay e baggara, zin alamaykka eza erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E faasitayiko ye7eeza, zin eesitay eza ekkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Zin E fana ekkeezitaysinnee E suntha ammaneezitayis Xooss na7ita maaqqad garkk mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Unttikka Xoossapp yelintteezaypp attin as yelinttiza wogay garkk dhiirath shenepp woy ashoppennee suuth shener yelinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qaalay as maaqqeeza; aadho keehetitharannee tumatithar kumii nu gancce yezeeza. E adayis pettii na7a maaqqii ekkeez E bonchcha nu be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Waannisa E bagga markkatteeza. Fa qaala dhoqqi uddii, «Taanii, ‹Taapp guyer yi7izay taapp tiin yeza gishos taapp aadhiza› gi markkatteezay yhaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuunii ubbitay E aadho keehetith kunithetithaypp anjjol afa anjjo ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xoossay higge Muse baggar inggeeza, zin aadho keehetithinnee tumatithii Yesuusa Kiristtoosa baggar ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xoossa aafer be7eez as oonkka baaya; fa Aday lanqqe yez pettii Na7ay aadda E fa ubbas Xooss maaqqeezay eza qoncce odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusalaame yez Ayihuditay halaqitay, Qeesitaynnee Lewitay, «Neenii oonoo?» gi, Waannisa oyicod garkk eziko kiittin, Waannisa unttisi markkatteez markkatithay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Waannisa, «Taanii Kiristtoosa baaya» yeegii, milxi udii markkatteezapp attin kaddibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Unttikka, «Yeezin, ne oonoo? Ne Eelaasanee?» yeegii oyiceeza. Waannisa mahii, «Tana baaya» yeegeeza. Ma unttii, «Ne ye7od ginttintteez nabay nenanee?» yeegii oyiceeza. Waannisa, «Wa77a» gi maheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yeezin, «Ne oonoo? Nuunii nuna kiitteezitayis odod garkk ne nena oona gee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Waannisa mahii, «Nabe Isayaasa geezay garkk, «‹Godayis oge luulisoytta!› gi liizho demba uukkiza athay qaalay tana» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma Ferisaawe asitay kiitteez asay ");
INSERT INTO mfxl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Waannisako, «Ne Kiristtoosa woy Eelaasa woy nabe baa ixiko, yeezin abis xammaqee?» gi oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Waannisa mahii, «Taanii haathar xammaqiza, zin yi eroowa asii yi gancce eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E taapp guyer yi7iza. Taanii hara attozin e caamma wodoro billodayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yeyi ubbay Yordanoose borkkapp seko pino, Bitaana katama, Waannisa xammaqiza aqayid haneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Waannisa wonttitha gallas Yesuusa eeko ye7odar bi7ii, «Alame nagara baranchchiza Xooss Duray yhaya! ");
INSERT INTO mfxl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taanii, ‹Taapp guyer pettii asii ye7oda. E taapp tiin yeza gishos taapp aadhiza gi odeezay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","E oonazako taanii erooya. Zin Isreele asayis eza qoncce kessodayis haathar xammaqttar ye7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Waannisa yhay garkk yeegii markkatteeza: «Geeshsha Ayyanay salopp holle garkk wodhdhodarannee ezal shemppodar ta be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yeyi hanodaypp tiina ta eza erooya. Zin haathar xammaqodayis tana kiitteez Xoossay, ‹Geesha Ayyanay wodhdhii ezar yezin neenii be7adayinnee Geeshsha Ayyanar xammaqoday eza› yeegii taas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta yeyi hanodar bi7ii, E Xooss Na7a maaqqeezana markkattiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma wonttitha gallas Waannisa fa tamaaritaypp nam7itayir wolla eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesuusa aadhodar Waannisa bi7ii, «Xooss duray yhayshshe!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nam7i Waannisa tamaaritay Waannisa gizana si7ii Yesuusana kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuusa fana kaallizita guye shirinttii bi7ii, «Yi ab koyinee?» yeegii oyiceeza. Unttii maaqqii, «Asitamaarayyo, ne aba yessade?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesuusa unttiko, «Yhana yi7ii bo7oytta» yeegeeza. Unttii yhanigii E yeza aqa be7eeza. Ye gallas sa7ay taphphii saate heera maaqqiz gishos e lanqqe peezheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Waannisa geezana si7ii, Yesuusana kaalleez nam77ii tamaaritaypp pettay, Simoon Phixiroosa isha Indiraase. ");
INSERT INTO mfxl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Indiraase tiina fa isha Simoonar wolihellii, «Nuunii Kiristtoosa denggeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Indiraase Simoona Yesuusako ke7eeza. Yesuusa Simoona bi7ii, «Neenii Yoona na7a Simoona; ne sunthay Kefa a gi xeeginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wonttitha gallas Yesuusa Galila biitta yhammadayis murtteeza. E Filphoosara denggii, «Tana kaalloba!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filphoosa, Indirasennee Phixiroosa yezeez Beetesayda gizi katamapp ye7eez asii. ");
INSERT INTO mfxl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filphoosa Natina7eelara hellii, «Muse higge maxaafay gancce, ma nabitaykka ebaz xaafeez Yooseefa na7a Naazirete Yesuusa nu dengeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naatina7eela mahii, «Naazirete katamapp lo77o baz kezodayis danda7inee?» yeegeeza. Filphoosa, «Yi7ii bo7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesuusa Naatina7eela faako yi7izana bi7ii, «Gene baa tuma Isreele as yhaya!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naatina7eela Yesuusako, «Neenii tana aba eree?» yeegeeza. Yesuusa mahii, «Filphoosa nena xeegodaypp tiina, neenii balase mithii oommo yeezin taanii nena be7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naatina7eela mahii, «Asitamaarayyo, neenii Xooss Na7a! Neenii Isreele kaate!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuusa eeko, «Ta nena balase mithii oommo be7eeza geez gishos ne ammaninee? Neenii yhaypp aathibaz be7ada!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma Yesuusa, «Taanii yinttis turo odiza; salo dooyinttin, Xooss kiitanchchitay As Na7a afa kezodarannee wodhdhodar yi be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hayidzintha gallas Galila biitta Qaana katama bossi yeza. Yesuusa indat ye bossayid yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuusakka fa tamaaritayir wolla ye bossayid xeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Woyne ushshii wurin, Yesuusa indat Yesuusako, «Unttis woyne ushshii wureeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesuusa mahii, «Ta indatee, ne yhaydda gelippe? Ta woday haga hellekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesuusa indat ooso asitayiko, «E yinttis odeezibaz ababaz maaqqikokka oothoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayihuditay fa shaagishe wogas maadinttiza usuppun shuchch gaanitay ye aqayid yeza. Pettii pettii gaanay nam7i woy hayidzii xugga aykkiza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuusa ooso asitayiko, «Gaanitayid haathii kunthoytta» yeegeeza. Unttii gaanitayis doona hellodayis haathii kuntheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesuusa unttiko, «Yhatti duuqqii boss godayis inggoytta» yeegeeza. Unttii ezisi inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Boss godayis woyne ushshiko laamintteez haatha ganxxii bi7ii anapp ye7eezako erekka, zin haathii kuntheez ooso asitay eriza. Bossa goday machcho ekkizana xeegii, ");
INSERT INTO mfxl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Oonkka lo77o woyne ushshii asa tiinattii ushshiza. Yeezii asay uzhii aleezaypp guye haaxo ushsh inggiza. Zin neenii lo77o woyne ushshii yhanno hellodayis gaddeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuusa yha tiina malata Galila biitta Qaana katama ootheeza; yeyida fa boncha beezeeza. E tamaaritay eza ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yeypp guye, Yesuusa fa indatira, fa ishitayirannee fa tamaaritayir wolla Qifirnahoome katama yhanigii xiqqa gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayihuditay bonchchiza Paaziqa Baalay ukkin Yesuusa Yerusalaame yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yhanigii Xooss kara gancce gematita, harita, duritannee hollita bayizizitannee fa oydel bettii miishe laammizita denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E xurqafer ubbita u mehitayir Xooss karapp bayi7ii bale kesseeza. Miishe laammizitay xarpheezitakka shirii olii u miisha laaleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Holle bayizizitana, «Yha hollita yhaypp kessoytta; ta Aday kara gabe mahippate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","E tamaaritay Geeshsha Maxaafayid, «Taanii ne karayis micinttiza mishay tana tama garkk michchiza giza» ginttinttii xaafintteezana akaakeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yeypp guye, Ayihuditay mahii, «Ne yhaya oothodayis neesi mawute yezayis nuna aba malata oothii beezodee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuusakka, «Yha Xooss kara laalloytta; taanii hayidzii gallasar mahii denthoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Maakka Ayihuditay, «Yha Xoossa Kara keexxodayis oytamanne usuppun laythi ekkeeza, zin neenii hayidzii gallasar denthode?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zin Yesuusa odiza Xoossa karay fa asetithibaga. ");
INSERT INTO mfxl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yey gishos, Yesuusa yhayiqopp denddeezaypp guye e tamaaritay E yeya geezana akaakeezannee Geeshsha maxaafayid xaafinttezannee Yesuusa odeezana ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuusa Paaziqa bonchchiza gallas Yerusalaame yezin, E ootheez mallita bi7ii gaame asay eza ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Zin Yesuusa as ubba eriza gishos unttan ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","As wozina yeza baz E fa ubbas eriza gishos asibaz oonkka ezisi ododay garkk koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ferisaawitay baggapp maaqqeez, Ayihuditay halaqay, Niqodimoosa giz pettii athay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Niqodimoosa qamma Yesuusako yi7ii, «Asitamaarayyo, neenii Xoossay kiitteez asitamaare maaqqeezana nu eriza. Abis giiko, Xoossay ezar yezaam ixxiko yha ne oothiza mallita oothodayis danda7iza asii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuusa mahii, «Taanii nees turo odiza; oonkka maaqqii yelinttaam ixxiko Xooss kaatetitha be7adayis danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqodimoosa, «As cimii wayizii maaqqii yelinttodayis danda7ee? Fa indat ulo maaqqii gelii mahii yelinttodayis danda7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuusa mahii, «Taanii nees turo odiza; oonkka haathapennee Geeshsha Ayyanapp yelinttaam ixxiko, Xooss kaatetith gelodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ashopp yelintteezay asho; Ayanapp yelintteezay Ayyana. ");
INSERT INTO mfxl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taanii, ‹Yi maaqqii yelinttodayis beeziza› gi yinttis odeezay gishos neenii malabaz giippe. ");
INSERT INTO mfxl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Carkko fa kozheez bagga carkkiza. Neenii giirtha si7inepp attin aayaypp yi7izako woy aaya yhanigizako erooya. Ayyanapp yelintteez ubbitay yey garkk» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yeezin Niqodimoosa, «Yeyi wayizii hanodayis danda7ee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuusa mahii, «Neenii Isreelitay asitamaare maaqqittar yhaya eroosa? ");
INSERT INTO mfxl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taanii neesi turo odiza; nu eriza baz odizannee be7eezi baz markkattiza, zin nu markketitha yi ekkooya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Taanii yinttis sa7abaz odin yi ammanowabaz maaqqiko salobaz odin wayizii ammanodee? ");
INSERT INTO mfxl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Salopp wodhdheez As Na7aypp attin salo kezeezay oonkka baaya; salo yez As Na7ay tana» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Muse liizho denbal naase shoosh sotteezay garkk eza ammaneez ubbitay medhina de7o ekkoday garkk As Na7ay sotinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Xoossay yha alame qadhdheez gishos fa Na7a petta aath inggod hellodayis cer doseezay eza ammaniza ubbitay medhina laattoday garkkepp attin dhabaamay garkke. ");
INSERT INTO mfxl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Xoossay fa Na7a yha alame kiitteezay alame pirddodayis baazin alama E baggar ashshodayisii. ");
INSERT INTO mfxl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eza ammaniza oonkka pirddinttamii, zin Eza ammanoowa oonkka pettii Xooss Na7a ammanekka gishos yhatti pirddintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pirddaykka yhaya: poo7o alame ye7eeza, zin as ooso iita maaqqeez gishos asay poo7opp aathii dhuma doseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iita baz oothiza oonkka poo7o ixxiza. Abis giiko, fa ooso pidhe kezaamay garkk poo7oko ye7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Zin tuma oothiz oonkka Xoossay kiitteezay garkk E ootheezana poo7o beezoday garkk poo7oko yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yeypp guye, Yesuusa fa tamaaritayir wolla Yihuda biitta yhanigeeza. Ezayid xammaqttar unttar xiqqa wode gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma Waannisa Saleeme lanqqe yez Henoone yeegiz aqo gaame haath yeza gishos asa ezayid xammaqiza. Asaykka ye aqa yhanigii xammaqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ye wode Waannisa haga acinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yeypp guye, Waannisa tamaaritaynnee Ayihude asay shaagishe woga bagga palameeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Waannisa tamaaritay Waannisako yhanigii, «Asitamaarayyo, Yorddanoosa borkkapp seko pino neer yezay, neenii ebagga markkatteezay, yezako xammaqiza. Asay ubbitaykka ezik yhanigiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Waannisa mahii, «Xoossay inggekka asii ababazikka ekkodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹Taanii Kiristtoosa baaya, zin eepp tiina kiitintteeza› maaqqeez gisho yi, yi ubbas taas markka. ");
INSERT INTO mfxl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gelos giigeezanna ekkodayis giigeez athayssii. Ekkizayis laazanthay kale eqqii E giza si7eez wode lo7ithii ufayttiza. Yey gishos, yhayi ta ufayssay polintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","E gitatodayis taanii xiqqodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Afapp yi7izay ubbaypp afa. Sa7app bentteezay sa7abaz. E sa7abaz odiza. Salopp yi7izay ubbaypp afa. ");
INSERT INTO mfxl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","E fa be7eezbazinnee si7eezibaz markkattiza, zin e markketitha ekkizay baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","E markketitha ekkiza oonkka Xoossay tuma maaqqizana beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xoossay fa Geeshsha Ayyana ees makkekka inggiza gishos Xoossay kiitteezay Xooss qaala odiza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aday fa Na7a dosii ubba baz e kushayid gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na7a ammaniza athayis medhina de7o yeza. Zin Na7a ammanoowa athayil afa Xooss kachchii ezal yezaypp attin E de7o denggaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuusa Waannisasitaypp gaanggiza kaallizita faako shiishizannee xammaqizana Ferisaawitay si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maaqqikokka Yesuusa tamaaritay xammaqeenepp attin Yesuusa oonakka xammaqqekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesuusa asay ebaz giza si7ii Yihudapp denddii Galila yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galila yhanigttar Samaarera aadhoday ezisi attambaz maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yeyi gishos, Yayqqooba fa na7a Yooseefas inggeez gade lanqqe yez Sikaare giz Samaare katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ye aqayid Yayqqoobas haath olla yeza. Yesuusa yedhdhitar daaburii ye haath ollatii lanqqe betteeza. Ye wode sa7ay usuppun saate heera. ");
INSERT INTO mfxl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pettii Samaare asita ye ollaypp haath tikkodayis ye7eeza. Yesuusa ye asitiko, «Tana haathe ushshooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ye wode Yesuusa tamaaritay miiz baz woonggodayis katama yhanigeezaza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ye asita mahii, «Neenii Ayihude as maaqqittar, Samaare maachchi maaqqiz tana wayizii haathe ushshoba gee?» yeegeeza. Yeya iza geezay Ayihuditay Samaaritayir wolihellowa gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuusa mahii, «Neenii Xooss imotanee haathe tana ushshooye gizay oonazako ne ereezako eza ne woossodazin; ezikka neesi de7o inggiza haathii immadazin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ye asita maaqqii, «Godayyo, nees duuqqizabaz baaya; ollaykka ciimmo. Yeezin, de7o inggiz haath ne anapp denggodee? ");
INSERT INTO mfxl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nuus yha haathii olla inggeez nu aday Yayqqoobapp neenii aadhinee? Ezinnee, e na7itaynnee e mehitay yha ollaypp uzheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuusa, «Yha haathaypp uzheez oonkka maaqqii saaminttoda. ");
INSERT INTO mfxl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Zin taanii inggod haatha uzhiz oonkka ubbarakka saaminttaamii. Taanii immad haathay e gancce medhinas de7o inggiz goggiz pultto maaqqada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ye asita mahii, «Godayyo, taanii saaminttamay garkkennee haath tikkodayis yha aqa ye7aamay garkk taasi ye haatha inggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesuusa iziko, «Yhanigii ne azina xeegii ye7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ye asita mahii, «Taas azinii baaya» yeegeeza. Yesuusa iziko, «Taas azina baaya guussayid nees buuta baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nees tiin ichchin azinttay yeza. Yhatti neer yeza athay ne azine baaya. Neenii yhatti turo odeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ye asita mahii, «Godayyo, neenii nabe maaqqizana taanii ereeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu aditay yha derayil afa Xooss goynneeza. Zin yi Ayihuditay asii Xooss goynnodayis beeziza aqay Yerusalaame giza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuusa, «Yhann astte tana ammanoba; yha derayil afa woy Yerusalaame Adayis goynnaam wode ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yi Samaaritay eroowazayis goynniza. Zin nuunii atotithi Ayihudepp yi7iz gishos nu erizayis goynniza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Zin Ada tumar goynnizitay Ayyanarannee tumar goynnod wode ukkeeza; yhattekka helleeza. Yikkee, Aday koyizay yhay garkk oger goynnizita. ");
INSERT INTO mfxl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xoossay Ayyana; ezis goynnizitay Ayyanarannee tumatithar goynnodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ye asita mahii, «Kiristtoosa ginttiz ‹Masay› ye7odana taanii eriza. E yi7ii nuus ubba baz ododa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuusa, «Yha neer nashizay taanii eza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Unttii nashshodar, Yesuusa tamaaritay yhanigeez aqaypp maaqqeeza. Yesuusa maachchar wolla nashshodar u bi7ii malabaz geeza. Zin asttiko, «Abi koyee?» Woy Yesuusako, «Izir abis odinttee?» geezay oonkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yeypp guye, asita fa haath otana ashshii guye katama yhanigii asitayiko, ");
INSERT INTO mfxl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Taanii ootheez baz ubba taasi odeez atha be7adayis yedhdhoytta. E Kiristtoosa maaqqaddeshsha?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asay katamapp kezii Yesuusako yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yeyi hanodar, e tamaaritay Yesuusako, «Asitamaarayyo Xiqqa muntta mooye» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Zin E, «Taas yi eroowa katha ta miizay yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yeyi gishos, E tamaaritay woli gancce, «Ezis miizibaz asii ko7o attenna?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuusa unttiko, «Ta munttay tana kiitteezay shena oothonnee e ooso polodaya. ");
INSERT INTO mfxl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yi, ‹Oyddii aginapp guye kathay maxxos helleeza› goosa? Zin taanii yinttis odiza; kathay kaxxii shiishos helleezaya lo7ithii bo7oytta. ");
INSERT INTO mfxl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zerizayinnee maxxizay wolla ufayttod garkk maxxizay damooze ekkiza ma kathakka medhina de7os shiishiza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yikkee, ‹Pettay zeriza; yhankkay ma maxxiza› giz oday tuma. ");
INSERT INTO mfxl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yinttii daaburekazana shiishoday garkk taanii yinttan azazeeza. Yhankkitay oothii daabureez aqo gelii yi u daaburssi aafa ekkeezitta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ye asita, «E, taanii ootheez ubba baz odeeza» gi markkatteez gishos ye katama yez Samaare asaypp gaamitay Yesuusa ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaare asay Yesuusako yi7ii, fa kale gam7oday garkk Yesuusa woossin E ezayid nam77ii gallas betteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E odiza qaalay gishos tiinaasaypp gaame asay ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma unttii asttiko, «Yhatti nu ammanizay nu ubbas E giza si7eez gishosapp attin neenii markkatteez gishshos baaya. Ma E tuma yha alame ashshiza maaqqizana nuunii ereeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nam77ii gallasapp guye, Yesuusa yeypp kezii Galila biitta qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesuusa fa ubbas, «Nabe fa biittal bonchchinttooya» yeegii tiinatii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuusa Galila helleez wode Galila asay eza mokkeeza. Abis giiko, Paaziqa Baale bonchchiza gallas unttii Yerusalaame yez gishos E ootheez baz ubbita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuusa haathe woyne ushshiko laammeez aqo, Galila yezi Qaanna katama qiteeza. Qifirnahoome kaatay kara oothizi pettii shuumayis na7ay harggintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesuusa Yihudapp Galila ye7eezana ye shuumay si7ii eziko ye7eeza. Yhayqqodayis ukkeez fa na7a yhanigii pathod garkk Yesuusa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuusa shuumayiko, «Xoossay oothiza mallabazinnee mala be7amixiko yi ubbara ammanaam» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Shuumay mahii, «Godayyo, ta na7ay yhayqqekka yeezin taar yedhdhooyee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuusa, «Ne kara qitoba; ne na7ay paxoda» yeegeeza. Ye shuumay Yesuusa geezana ammanii fa kara yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E fa kara yhammadar e ayllitay eziko yi7ittar ezar ogell hellii, «Ne na7ay paxeeza» geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","E ayllita fa na7ayis aappun saater lo77eezako oyceeza. Unttii maaqqii, «Ziqin laappun saater mishay atteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na7ay adayi Yesuusa faako, «Ne na7ay paxoda» geezay ye saatte maaqqizana akaakeeza. Yeyi gishos, ezinnee e kara as ubbitay ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yeyi Yesuusa Yihudapp Galila yi7ii ootheez nam7intho malla. ");
INSERT INTO mfxl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yeypp guye, Yesuusa Ayihuditay bonchchiza baalayis Yerusalaame yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalaame Duritay Penge kale Ibraysxe doonar Beetesayida giz deelee yeza. Ye haathay lanqqe ichchin shemppo bessitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yeyid haathay eni7odana naagiza gaame harigntteezittay, to7itay, wobbitayinnee gundditay woyi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Abis giiko, pettii pettii toke Goda kiitanchchay teqintteez haatha wodhdhii eni7isiza. Haathay eni7odar tiin geleez athay fana aykkeez aba harggepekka paxiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ye aqayid hasttamannee hosppun laythi harggintteez pettii athay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuusa ye atha bi7ii, ma gaame wode harggintteezana erii athayiko, «Paxodayis koyinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Harggintteez athay maaqqii, «Godayoo, haathay eni7odar tana haathay gancce oliza asii baaya. Taanii gelod hanodar haray taapp tiinattii geliza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesuusa eziko, «Denddii eqqoba; ne arssa tookkii qitoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Athay izir ellis paxeeza; fa arssa tookkii qiteeza. Yeyi maala gallasar haneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yeyi gishos, Ayihuditay paxeez athayko, «Yhayino sa7ay maala; neenii ne arssa tookkizay woga baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Zin athay, «Tana patheezay, ne arssa tookkii qitoba geeza» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Unttii eziko, «Nena, ne arssa tookkii qitoba geezay E oonoo?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Zin Yesuusa ye aqayid gaame as ganccer erisekkazar aadhii qiteez gishos athay fana patheezay oonazako erooya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesuusa guyepp ye atha Xooss Keetha denggii, «Yhatt, neenii paxeeza; yhaypp iita baz nena hellaamay garkk maaqqii nagara oothippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yeypp guye, athay yhanigii fana patheezay Yesuusa maaqqeezana Ayihuditayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuusa yeya maala gallas ootheez gishos Ayihuditay Yesuusa bay7ith aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuusa maaqqii, «Ta Aday ubba wode oothiza; taakka oothodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuusa maala bonchcheka gishos aadda baazin Xoossa fa Ade gi fana Xoossar ukkulsseez gishos Ayihuditay eza wodhodayis tiinaasaypp miinthii koyiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuusa mahii, «Taanii yinttis turo odiza; Na7ay fa aaddas abikka oothodayis danda7ooya. E fa Aday oothodar be7eezana aadda oothiza. Aday oothizana Na7aykka oothiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aday fa Na7a qadhdhiza gishos E oothiz ootho ubba fa Na7a beeziza. Yi malabaz goday garkk E yhaypp aadhiz ooso fa Na7a beezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aday yhayqqeezita yhayiqopp denthii unttis de7o inggizay garkk Na7aykka fa koyizitayis de7o inggiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aday Na7ayis pirdde mawute ubba inggeezapp attin E oonakka pirddooya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Asay ubbitay Ada bonchchizay garkk Na7akka bonchchoda. Na7a bonchchowa oonkka Na7a kiitteez Adakka bonchchooya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Taanii yinttis turo odiza; ta qaala si7izitayinnee tana azazeezana ammanizay medhina de7o yeza. E yhayiqopp de7o piinggeez gishos pirddinttamii. ");
INSERT INTO mfxl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taanii yinttis turo odiza; yhayqqeez asay Xooss Na7a qaala si7iz wode ye7oda; yeykka yhatte. Ye qaala si7izay de7or yezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Adayis ees de7o yezay garkk Na7ayiskka ees de7o yezoday garkk inggintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","As Na7a maaqqiz gishos Aday Na7ayis pirdde mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Duufo yezitay e qaala si7ii dendod wode ye7od gishos yhaya malabaz giippate. ");
INSERT INTO mfxl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lo77o ootheezittay de7or yezodayis ma iita ootheezittay pirdde ekkodayis duufopp dendoda. ");
INSERT INTO mfxl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Taanii ta mawuter ababazikka oothodayis danda7ooya. Xoossay taasi odeezay garkk pirddiza. Taanii tana kiitteezay koyiz baz oothizapp attin ta koyiz baz oothowa gishos ta pirdday tuma. ");
INSERT INTO mfxl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Taanii tabaz markkatiko ta markkatithay tuma baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta bagga markkattizay hara yeza; E tabaz markkattizay tuma maaqqizana taanii eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Yi Waannisako as kiittin E tumas markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taanii yeya yinttis odizay, yi attod garkk geezapp attin as markkatithii taas koshsheez gishsho baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Waannisa muqaadday garkk eexittar poo7eeza. Yi xiqqa wodes E poo7ayid ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Zin taasi Waannisapp aadhiz markka yeza. Taanii oothod garkk ta Aday taasi inggeez oositay ta bagga markkattiza; Aday tana azazeezana beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Ma tana kiitteez Aday fa ubbas tabaz markkattiza. Yi E qaala ubbarakka si7ibe7ekka woy e malla bi7ibee7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","E azazeezana yi ammanoowa gishos e qaalay yi wozina gancce baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Geeshsha Maxaapitaypp medhina de7o demmadbaz yinttis aazin unttan pilagiza; unttii tabaz markkattiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Zin yi de7o denggodays taako ye7odayis koyooya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Asapp taanii bonchcho koyooya. ");
INSERT INTO mfxl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Zin taanii yi wozina gancce Xooss qadhe baza eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taanii ta Aday mawuter ye7eeza, zin tana mokkekkaya. Haray fa mawuter yi7iz wode eza mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yi pettay pettaypp bonchcho koyizitay, pettii Xoossapp yi7iz galata ekkodayis koyoozitay, wayizii tana ammanodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Taanii ta Aday tiina yinttan mootizabaz yinttis aazippe. Yinttan mootoday yi ufayssar naagiz Muse. ");
INSERT INTO mfxl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yi Muse ammaneez baz maaqqeezako E ta bagga xaafeez gishos tanakka ammanodazin. ");
INSERT INTO mfxl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Zin yi E xaafeezana ammanaam ixxiko ta qaala wayizii ammanodee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yeypp guye, Yesuusa Xibiradoosa giz Galila Abbapp seko pino piinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E harggintteezitta fathor ootheez malla be7eez gishos gaame asay eza kaalleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuusa derell afa kezii, ezayid fa tamaaritayir wolla betteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayihuditay bonchchiza Paaziqa Baale gallasay helleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuusa gaame asay faako yi7izana bi7ii Filphoosako, «Yha asa ubbita muzodayis gidiza katha anapp woommadee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E yeya Filphoosa faaccodayis geezapp attin E fa ubbas ab oothodazako eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filphoosa maaqqii Yesuusako, «Hara attozin, Ommar ommar, pettii pettii baadhithi helthodayis, nam7i xeet diinaarer soollo wonggikokka gidaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma Yesuusa tamaaritaypp pettay, Simoon Phixiroosa ishay Indiraase, ");
INSERT INTO mfxl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ichchin bangga soollora nam77ii molo aykkeez pettii na7ay yhaydda yeza, zin yha as ubbayis yey ab maaddodee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuusa fa tamaaritayiko, «Asa bettithoytta» yeegeeza. Ye aqayid gaame maata yeza; asay ubbitay beteeza. Dhiirathi asitay taybay ichchin mukulo maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuusa soolla ekkii Xooss galatii maaqqii ezayid betteez asayis gisheeza. Molakka ekkii yhay garkk uddii inggin, asay fa koyeezay garkk meeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","U ubbitay mizheezaypp guye Yesuusa fa tamaaritayiko, «Pettii bazikka iitam garkk atteez gufa shiishoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yeyi gishos, u ubba shiisheeza. Asay miin atteez bangga soollo gufa shiishii taphpho nam77ii leemate kuntheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asay Yesuusa ootheez malla bi7ii «Yhayi tuma yha alame ye7od ginttintteez nabe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuusa u eza aykkii wolqqar kawutisodayis qoppeezana erii, fa aaddas derell afa maaqqii kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sa7ay omathodar Yesuusa tamaaritay abbako wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sa7ay qammeez gishos Yesuusa haga unttiko ye7ekka gishos e tamaaritay wogolo gancce gelii abba piinggii qifirnahooma yhammadayis denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wolqqama carkko carkkeez gishos abbay eni7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ichchin woy usuppun kilo mitire maaqqoday garkk u abba pidhi yhanigeezaypp guye Yesuusa abbal afar yedhdhittar yi7izana bi7ii yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Zin E, «Yashittifatte, tana be» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Unttii ufayttii eza wogolo gancce gelsseeza; izir wogolay u yhanigiza abba gaxa helleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wonttitha gallas abbapp seko pino atteez gaame asay pettii wogolo aadda yezana be7eez gishosinne Yesuusa fa tamaaritayir wogolo gancce gelii, unttar yhanigozannee u fa aaddas yhanigeezana akaakeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Zin Xibaaradoosapp hara wogolitay Yesuusa Xooss galatin, asay soollo meez aqa ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asay Yesuusa woy e tamaaritay ezayid baazana bi7ii, Yesuusa koyodayis wogolitayid gelii qifirnahooma yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asay Yesuusa abbapp seko pino dengeez wode «Asitamaarayyo, yhana wudayid ye7eenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuusa maaqqii, «Taanii yinttis turo odiza; yi tana koyizay soollo mi mizheez gishospp attin malla be7eez gishshos baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dhabiza kathas oothippate, zin medhinas de7o inggiz kathas oothoytta. Xooss Aday E oothod garkk ezis mawute inggeez gishos ye katha As Na7ay yinttis immada eriseeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yeezin unttii, «Nuunii Xooss ootho oothodayis ab oothodee?» yeegii Yesuusa oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuusa maaqqii, «Yi oothod garkk Xoossay koyiz ooso yhaya: E azazeezana ammanoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Unttii mahii, «Nuunii bi7ii, nena ammanod garkk aba malla ne bessade? Ne ab oothodee? ");
INSERT INTO mfxl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Geeshsha Maxaafayid, ‹U maad garkk soollo salopp inggeeza› ginttinttii xaafintteezay garkk nu aditay liizho denba manna meeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesuusa, «Taanii yinttis turo odiza; yinttis salopp tuma soollo inggeezay ta Adaypp attin Muse baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yikkee, Xoossay inggiz soollay salopp wodhdheezay alamayis de7o inggiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Unttii mahii, «Godayyo, nuus ye soolla ubba gallas inggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuusa, «Taanii de7o inggiza soollo; taako yi7iz oonkka ubbarakka nayinttenna. Ma tana ammaniza athay ubbarakka saaminttenna. ");
INSERT INTO mfxl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Zin taanii yinttis odeeza; yi tana be7eeza, zin ammanooya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Aday taasi inggiz ubbitay taako ye7oda; ma taako yi7iz oonakka bale dakkaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taanii ta koyiz baz oothodayis baazin tana kiiteezay koyiz baz oothodayis salopp ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tana kiiteezay koyizay yhaya: taanii E taas inggeez ubbitakka wurssith gallas yhayiqopp denthoday garkkepp attin pettaka dhabisod garkk koyooya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yikkee, ta Aday koyizay yeya: Na7a bi7ii ammaniza ubbitay medhina de7o ekkoda; taanii ye ubbita wurssith gallas medhina de7os yhayiqopp denthoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuusa, «Taanii salopp wodhdheez soollo» geez gishos Ayihuditay eza zigireeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Unttii, «Yhayi nuunii e adannee e indat eriza Yooseefa Na7a Yesuusa baasannee? Yeezin, E wayizii, ‹Taanii salopp wodhdheeza› godayis danda7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuusa mahii, «Pettay pettayira zigiriza ashshoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tana kiiteez ta Aday taako ki7iza asapp attin taako ye7odayis danda7iza oonkka baaya. Taanii wurssithii gallas eza medhina de7os yhayiqopp denthoda. ");
INSERT INTO mfxl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabitay, ‹Xoossay as ubba tamarssoda› yeegii xaafeeza. Ada si7izayinnee ezipp tamaariza oonkka taako yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xooss lanqqepp ye7eezaypp attin Ada be7eezay oonkka baaya; e aadday Ada be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Taanii yinttis turo odiza; tana ammaniza ooskka medhina de7o yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taanii de7o inggiz soollo. ");
INSERT INTO mfxl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yi aditay liizho demba manno meeza, zin yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Salopp yi7iz soollay yhaya; ye soolla miiz oonkka yhayqqaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Salopp ye7eez de7o soollay tana. Oonkka yha soollo miiko medhinas yezoda. Ma yha alamay de7or yezod garkk taanii yinttis immad soollay ta asho» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayihuditay, «Yha athay fa asho nu maad garkk nuus wayizii immadayis danda7ee?» yeegii woli gancce palameeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yey gishos, Yesuusa unttiko, «Taanii yinttis turo odiza; As Na7a asho, yi maam ixxiko, e suutha yi uzhaam ixxiko, yinttis de7o baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta asho miiz athayisinnee ta suutha uzhiz athayis medhina de7o yeza. Taanii wursith gallas eza yhayiqopp denthoda. ");
INSERT INTO mfxl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta ashay tuma muntta; ta suuthaykka tuma ushshii. ");
INSERT INTO mfxl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta asho miiz athayinnee ta suutha uzhiz athay taar yeziza; taakka ezar yeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","De7o Aday tana kiittin, taanii e baggar de7or yezay garkk, tana miiz athaykka ta baggar de7or yezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Salopp wodhdheez soollay yhaya: yi aditay mi yhayqqeez mannay garkk baaya; yha soolla miiz athay medhinas yezoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuusa qifirnahooma katama Ayihuditay Woosa Keetha yhaya taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuusa tamaaritaypp gaame baggay yeya si7ii «Yhayi gelowa timirtte; yhayi oos gelee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuusa fa tamaaritay yeyis zigireezana erii, «Yhayi yinttan dhubbinnee? ");
INSERT INTO mfxl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yeezin, As Na7ay tiin yezabessa pude kezodar yi bi7ii waagodeshsha? ");
INSERT INTO mfxl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ayyanay de7o inggiza; as wolqqa abikka maaddooya. Ta yinttis odiza qaalay de7o inggiz geeshsha Ayyanapp yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Zin yi gancce ammanoozitay yeza» yeegeeza. Ammanoozitay oonanttazako Yesuusa tiinapp aykkii eriza. Ma fana aathii immaday oonazako eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maakka Yesuusa, «Aday yhanigoba geekka oonkka taako ye7odayis danda7ooya gi taanii odeezay yey gishshosi» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yeyi gishos, Yesuusa kaallizitaypp gaamitay eza ashshii guye maaqqeeza; maaqqii eza kaallibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesuusa taphpho nam77ii fa taamarita, «Yinttikka ashshii yhammadayis koyinee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoon Phixiroosa mahii, «Godayyo, nuunii ook yhammadee? Ne medhina de7o inggiz qaalar yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Neenii Geeshsha Xoossay na7a maaqqeezana nuunii ammanizannee eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuusa unttiko, «Taanii yinttan taphpho nam7ita maraxxekasa? Zin yinttipp pettay xalahe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuusa yeya geezay Simoona Na7a Asiqoroto Yihudasi. Yihuda Yesuusana aathii immadayis yezi taphpho nam77ii tamaaritaypp petta. ");
INSERT INTO mfxl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yeypp guye, Ayihuditay Yesuusa wodhodayis koyiz gishos E Yihuda ashshii Galilar yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayihuditay bonchchiza daase Baale bonchchinttodayis ukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yeyi gishos, Yesuusa ishitay, «Ne tamaaritay neenii oothiz mallita be7ad garkk yhaypp denddii Yihuda biitta qitoba. ");
INSERT INTO mfxl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Paas erinttodayis koyiz as oonkka fa oosa qosooya. Neenii yhayitita oothii ne bagga alama erisoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","E ishitay yeya geezay ezal ammanaam ixxeez gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesuusa unttiko, «Taas woday hellekkaya, zin yinttis ubba woday giiga. ");
INSERT INTO mfxl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alamay yinttan ixxodayis danda7ooya, zin taanii alamay oosay iita maaqqizana markkattiz gishos tana ixxiza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yi baala yhanigoyttta; ta woday hellekkazay gishos taanii baala yhanggaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","E yeya gi Galila atteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","E ishitay baala bonchchodayis yhanigeezaypp guye Yesuusa oonakka erisekkazar qosor ye aqa yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayihuditay baala bonchchiza aqayid, «E aba yenee?» yeegii eza koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Asay kalkkashii ebagga odinttodar baggitay, «E lo77o as» godar atteez asay ma, «Wa77a, E woya balithiza» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Zin Ayihude halaqitayis yashitteez gishos oonkka ebagga geesha odinttodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baala bonchchii gaabba helithodar Yesuusa Xoossa keethi yhanigii taamarsso aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayihuditay, «Yha athay timirtte tamaarekazar yhaya ubba wayizii ereennee?» yeegii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesuusa mahii, «Ta taamarssiza timirttay tana kiitteez Xoossapp yi7iz timirttepp attin tabaz baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xooss azazo oothodayis koyiz oonkka yha timirttay Xoossapp yi7izakonnee woy taanii taapp odizako eroda. ");
INSERT INTO mfxl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Paapp odiz oonkka fa ubba bonchcho koyiza. Zin fana kiitteezay bonchcho koyiz oonkka E tumanchcho; ezar worddo baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse yinttis higge inggeeza, zin yinttipp oonkka higge naagekkaya. Yeezin abis tana wodhodayis koyee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Asay mahii, «Neell xalahe yeza; nena wodhodayis oonoo koyizay?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuusa, «Taanii pettii malla uddin yi ubbitay malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yinttii, yi na7ita dookalodgarkk Muse azazeeza. Zin dookalo yi mayzitay udo aykkeezapp attin Muse baaya. Yeyi gishos, yi maala gallas dhiirath na7ita dookaliza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muse higgay kiitteez gishos yi maala gallas dookalizabaz maaqqiko, taanii pettii asii kunthi galla patheez gishos taar abis kaccee? ");
INSERT INTO mfxl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tuma pirdde pirddoyttap attin as aafe bi7ii pirddippate» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalaame asaypp pettay pettay, «U wodhodayis koyiz athay yhaya baasa? ");
INSERT INTO mfxl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yeezako, e pidhdhe odiza; unttii eza abikka gooya. E Kiristtoosa maaqqizana halaqitay tuma erineshsha? ");
INSERT INTO mfxl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kiristtoosa yi7iza wode E anapp yi7izako oonkka erooya, zin e anapp ye7eezako nu eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesuusa Xooss Keetha tamaarssittar fa qaala dhoqqi udii, «Tuma yi taanii oonazakonnee ta anapp ye7eezako erinee? Taanii ta mawuter ye7ekkaya, zin tana kiitteezay tuma; yi eza erooya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Zin taanii E kiittin e lanqqepp ye7eez gishos eza eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yeyi gishos, unttii eza aykkodayis koyeeza. Zin e woday haga hellekkazay gishos oonkka ezal afa kushe gaddekaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Zin gaame asay Yesuusa ammanii, «Kiristtoosa ye7odar yha athay ootheez mallitaypp gaanggiza mallita oothodennee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ferisaawe asay gaame asay Yesuusa oosay bagga kalkkashodar si7eeza. Qeese halaqitayinnee Ferisaawe asay eza aykkii acishodayis Xooss keetha naagizita azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuusa, «Taanii yinttar xiqqa wode gam7oda; yeypp guye tana kiitteezayiko yhammada. ");
INSERT INTO mfxl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yi tana koyoda, zin denggaamii. Taanii yeza aqa yi ye7odayis danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayihuditay pettay pettayira, «yhayi nuunii denggowa aqo aba yhammad hanee? Girike katama gancce yez Ayihuditayiko yhanigii Girikita tamaarssodayis haninenee? ");
INSERT INTO mfxl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹Yi tana koyoda, zin denggaamii› ma, ‹Taanii yezabessa yi ye7odayis danda7ooya› guussay abi guusso?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baala bonchchiza gallasitaypp wolqqamanne wurssith gallas Yesuusa denddii, fa qaala dhoqi uddii, «Saamintteez oonkka taako yi7ii uzho. ");
INSERT INTO mfxl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tana ammaniza oonkka geeshsha Maxaafe geezay garkk de7o inggiz pultto haathay e ganccepp goggoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E yeya geezay eza ammaneezitay ekkodayis yez geeshsha Ayyaanabagga. Yesuusa haga bonchchintteka gishos ye wode geeshsha Ayyanay ingginttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ye asaypp gaamitay E giza si7ii, «Tuma yhayi nabe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yhankkitay ma, «Yhayi Kiristtoosa» yeegeeza. Zin atteez asay ma, «Kiristtoosa Galilapp ye7odenee? ");
INSERT INTO mfxl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Geeshsha Maxaafay, ‹Kiristtoosa Dawite sheeshapp Dawitte yezeez Beeteleme katamap ye7oda› yeegosanee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zini, Yesuusa gishos asay woli gancce shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ye asaypp pettay pettay eza aykkodayis koyeeza, zin oonkka ezal afa kushe gaddekaya. ");
INSERT INTO mfxl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xoossa Keethi naagizitay qeese halaqitayikorannee Ferisaawitayiko guye maaqqii yi7in unttii, «Abis eza ke7ekkasa?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xoossa Keethi naagizitay unttiko, «Yha athay odizay garkk oonkka odinttooya» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ferisaawe asay mahii, «E yinttanakka balitheenee? ");
INSERT INTO mfxl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayihude halaqqitaypp woy Ferisaawe asaypp eza ammaneez as yenee? ");
INSERT INTO mfxl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Muse higge eroowa yha asay baaditteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ferisaawitaypp pettay qamma Yesuusako yhanigeez Niqodimoosa unttiko, ");
INSERT INTO mfxl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Pettii asii giz baz si7ekkazar woy E ab ootheezako erekkar tiinattii ezal afa pirddizay nu higgayid yenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Unttii maaqqii, «Neekka ma Galila biitta aso? Galila biittapp nabe kezaamiza geeshsha Maxaafaypp pilagii denggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ubbitay fa kara fa kara qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesuusa Woyira Derell afa qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma wonttitha gallas guura Xoossa keethi maaqqeeza. Gaame asay eziko yi7in bettii unttan taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Higge asitamaaritayinnee Ferisaawe asay lagitodar aykkeez pettii asito eziko ke7eeza. U as ubbay tiina izo essii, ");
INSERT INTO mfxl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«Asitamaarayyo, yha asita lagitodar nu aykkeez. ");
INSERT INTO mfxl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muse higgay yhann garkk asita shuchchar cadinttii yhayqqod garkk kiittiza. Yeezin, neenii waagee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","U yeya geezay Yesuusana paaccii eza mootizabaz demmadayisii. Zin Yesuusa zuggii fa biradhdher sa7all xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","U eza mahii mahii oyicii ashshaamii ixxin, pude dhoqqi gi, «Yi gancce nagara oothekka as tiinatii izo shuchchar shoco» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maakka zuggii sa7all xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Unttii yeya si7eez wode cimitaypp aykkii pettay pettay kezitar wureeza. Yesuusa aadda ye aqayid eqqeez asitir atteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","E pude dhoqi gi asitiko, «Yhan astte, asay ana yhanigeenee? Neell pirddeez oonkka baasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ya asita, «Godayyo, oonkka baaya» yeegeeza. Yesuusa mahii, «Taankka neell afa pirddaamii. Qitoba; yhannipp maaqqii nagara oothippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Maakka Yesuusa asayiko, «Taanii alames poo7o. Tana kaalliza oonkka de7o inggiz poo7ana dengodaypp attin dhuma gancce wutenna» yeegii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ferisaawe asay, «Ne nebaz markkattiza, zin ne markkatithay tuma baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuusa mahii, «Taanii tabaz markkattikokka ta markkatithay tuma. Abis giiko, taanii anapp ye7eezako ma ana yhanigizako eriza, zin yi erooya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yi as qofal pirddiza; taanii pettii asallakka pirddaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taanii pirddiza baz maaqqikokka ta pirdday tuma. Abis giiko, tana kiitteez ta Aday taar yezaypp attin taanii ta aaddas baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nam77ii as markkatithii miinggiza yey yi higgayid xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taanii tabaz ta ubbas markkattiza; ma tana kiitteez ta Aday tabaz markkattiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Unttii, «Ne aday aba yenee?» yeegii eza oyiceeza. Yesuusa mahii, «Yi tana woy ta Ada erooya. Tana eriza maaqqeezako, yi ta Adakka erodazin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuusa Xoossa Keethi muxaata miishe oliz saaxine yez bessa yeya taamarsseeza. E qammay haga hellekkazay gishos oonkka eza aykkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Maakka Yesuusa unttiko, «Taanii yhammadazin; yi tana koyoda, zin yi atotithi dengaamii yi nagarara yhayqqoda. Taanii yhanigiza aqo yhammadayis yi danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayihude halaqitay, «E, ‹Taanii yhanigiza aqo yi yhammadayis danda7ooya› yeegeeza. E fana fana fa aaddas wodhodayisonee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuusa mahii, «yi sa7app; ta afappe. Yi yha alamaypp, ta yha alamaypp baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yi atotithi dengaam yi nagarara yhayqqod gi ta yinttis odeezay Yhayisii. Taanii Tana yi ammanaam ixxiko yi atotith dengaamii yi nagarara yhayqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Unttii, «Neenii oonoo?» yeegii oyiceeza. Yesuusa maaqqii, «Taanii, tiinapp yinttis odeezay tana. ");
INSERT INTO mfxl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Taanii yi baz odii pirddiza baz gaame baz yeza. Zin tana kiitteezay tumanchcho; ma ta eepp si7eezan aadda alamayis odiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuusa fa Adaybagga odizana u akaakekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yeyi gishos, Yesuusa unttiko, «Yi As Na7a pude dhoqi oothiza wode Taanii Tana Maaqqeezana yi eroda. Maakka taanii ta silixaaner abikka oothodannee ta Aday tana tamaarsseezana odiza yi eroda. ");
INSERT INTO mfxl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tana kiitteezay taar yeza. Taanii ubba wode eza ufayssiza baz oothiza gishos E tana ta ubbas ashshekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuusa yeya ododar si7eez gaame asay eza ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuusa fana ammaneez asitayiko, «Yi ta timirttayis kiittinttiko tuma tana kaallizita. ");
INSERT INTO mfxl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yi tuma eroda; tumaykka yinttan wozii ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Unttii mahii, «Nuunii Afraame sheeshii; nuunii ooskka ayllitibe7ekkaya. Ne waagii, ‹Yi wozinttoda gee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuusa mahii, «Taanii yinttis turo odiza; nagara oothizi oonkka nagara aylle. ");
INSERT INTO mfxl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aylle medhinas kara asar yezooya, zin na7ay medhinas kara asar yeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na7ay yinttan woziko yi tuma wozinttoda. ");
INSERT INTO mfxl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yi Afraame sheesh maaqqeezana taanii eriza. Zin ta qaalay yi wozina gancce baazay gishos tana wodhodayis koyiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taanii ta Aday tana beezeezana odiza, zin yinttikka yi adaypp si7eezan oothiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Unttii mahii, «Nu adayi Afraame» yeegeeza. Yesuusa unttiko, «Yi Afraame na7ita maaqqeezako E ootheezana oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Zin Xoossapp si7eez tuma odeez tana yi wodhodayis koyiza. Afraame yhay garkk oothekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yinttii, yi adayi ootheezana oothiza» yeegeeza. Unttii mahii, «Nuunii lagiter yelintteez na7ita baaya; nuus pettii Aday Xoossay aadda yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuusa unttiko, «Xoossay tuma yi ade maaqqeezako yi tana qadhdhoda; abis giiko, ta Xooss lanqqepp yi7ii yhaydda yeza. Tana E kiitteezapp attin taanii ta mawuter ye7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Taanii giza yi si7odayis kozhoowa gishos ta giz baz yinttis gelooya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yinttii, yi aday xalehay na7ita. Ma yinttii, yi adayi amottizbaz oothodayis koyiza. E tiinap aykkii shemppo wodhiza. Tuma ezar baazay gishos E tuma ixxiza. Worddo ezis medho maaqqeez gishonnee E worddo adenne worddo odinttitar paap odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Taanii turo odiza, zin yi tana ammanooya. ");
INSERT INTO mfxl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yinttapp, ‹Neenii nagara oothodar ta be7eeza› godayis danda7izay oonoo? Taanii turo odinttizabaz maaqqiko tana abis yi ammanoosa? ");
INSERT INTO mfxl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xooss asii Xoossay giz baz si7iza. Yi Xooss as maaqqekka gishos Xoossay giz baz si7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayihuditay mahii, « ‹Neenii Samaare asii; neell tuna ayyana yeza› guusayid buuta yenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuusa unttiko «Taal afa tuna ayyana baaya. Taanii ta Ada bonchchiza, zin yi tana kawushshiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taanii ta ubbas bonchcho koyooya; taanii bonchchinttod garkk koyizaynnee taas pirddizay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taanii yinttis turo odiza; ta qaala naagiz oonkka yhayqqaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayihuditay mahii, «Neell afa tuna ayyana yezana nuunii yhatti ereeza. Afraame yhayqqeeza; nabitaykka yhayqqeeza. Zin neenii, ‹Ta qaala naagiz oonkka yhayqqaamii› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Neenii yhayqqqeez nu ada Afraamepp aadhinee? Nabitaykka ma yhayqqeeza. Neenii nena oona gi qoppee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuusa, «Taanii tana bonchchiko ta bonchchay cere. Yi, ‹Nu Xoossa› giz ta Aday E tana bonchchiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yi eza eraami ixxiko taanii eza eriza. Taanii eza erooya giiko yi garkk worddotiza. Zin taanii eza eriza; ma e qaallakka ta naagiza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yi adayi Afraame ta yi7ith gallasa bi7ii ufayttodayis amotteeza; bi7ikka ufaytteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayihuditay mahii, «Hara attozin, nees ishatam laythi kumekkazin wayizii Afraame be7eeza gee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuusa unttiko, «Taanii yinttis turo odiza; Afraame yelinttodaypp tiin taanii yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yeyi gishos, unttii Yesuusa shocodayis shuchchi ekkeeza. Zin Yesuusa unttapp geemmii Xoossa keethapi kezii qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuusa yhanigittar yelintteezaypp to7a maaqqii yez pettii atha be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E tamaaritay, «Asitamaarayyo, yha athay to7a maaqqii yelinttod garkk nagara ootheezay oonoo? E oothenenne eza yeleezitay ootheenee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuusa, «Xoossa ooso ezal afa benttod garkkepp attin E woy eza yeleezitay nagara ootheez gishos baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Gallasa yezin tana kiitteezay oosa ta oothodayis beeziza. Oonkka oothodayis danda7oowa qammay yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Taanii alamayid yezar alamayis poo7o» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesuusa yeya gi sa7a cutteeza. Fa cuchchayir laafa biitta laakithii ye urqqayir to7a athay aafa tizheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yeezii, «Yhanigii Salihoome giz teqintteez haatha ne aafa meecinttoba» yeegeeza. (Salahoome guussay kiitintteeza guusii) Yeyi gishos, athay yhanigii fa aafa meecinttii bi7ittar maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Athay shooritaynnee athay tiin woossodar be7eez asay, «yhayi bettii woossiza atha baasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pettii pettii asay, «yhayi eza» yeegeeza. Yhankkitay ma, «Wa77a, yhayi eza aazizapp attin eza baaya» yeegeeza. Zin athay, «Ee, tana» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Unttii eziko, «Yeezin ne aafay wayizii be7eenee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","E mahii, «Yesuusa giz athay xiqqa urqqa laakithii ta aafa tizhii, ‹Salihoome yhanigii ne aafa meecinttoba› yeegin, taanii yhanigii meecinttii bi7ii atteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Unttii eziko, «E aba yenee?» yeegii oyiceeza. Athay, «Taanii erooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Unttii tiin to7a, zin yhatti be7eez atha Ferisaawitayiko kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuusa urqqa laakithii athay aafa patheez gallasay maala gallasii. ");
INSERT INTO mfxl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yeyi gishos, athay wayizii be7eezako Ferisaawe asay eza mahii oyiceeza. Athay unttiko, «E ta aafate xiqqa urqqa tizheeza. Ta aafa meecinttii yhatti bi7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ferisaawitaypp pettay pettay, «yhaya ootheez athay maala higge naagoowa gishos Xoossapp ye7ekkaya» yeegeeza. Zin yhankkitay, «Nagaranchcho asii yhay garkk mallita wayizii oothodayis danda7ee?» yeegii woli gancce shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yeyi gishos, Ferisaawe asay athayiko, «E ne aafa bi7iseez gishos ne ebaz waagee?» yeegeeza. Athay, «E nabe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayihude halaqitay, e indatinnee ada xeegii oyicod gatho, athay tiin to7a maaqqeezannee yhatti E bi7izana ammanekaya. ");
INSERT INTO mfxl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Unttii e indatonnee e adayiko, «Yi ‹To7a maaqqii yelintteeza› giz yi na7ay yhaya? Yeezin, yhatti wayizii be7eenee?» yeegii oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eza yeleezitay, «yhayi nu na7a maaqqeezannee to7a maaqqii E yelintteezana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Zin yhatti E wayizii be7eezako ma e aafa oonii patheezako nuunii erooya. Eza oyicoytta. E fana ereez as maaqqeez gishos fabaz ododayis danda7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Eza yeleezitay yeya geezay Ayihuditayis yashitteez gishshosi. Abis giiko, Ayihuditay, Yesuusana E Kiristtoosa yeegii markkattiz asii yezako ye atha Ayihuditay Woosa keethapp bayi7odayis qofa acceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eza yeleezitay, «E fana ereez asii; eza oyicoytta» yeegeezay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yeyi gishos, to7a maaqqii yelintteez atha unttii mahii xeegii, «Tuma ododayis Xoossa bonchoba; yha athay nagaranchcho maaqqizana nu eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Athay mahii, «E nagaranchcho maaqqeezana, ta erooya. Taanii to7a maaqqeezannee e yhatti bi7izana aadda eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Unttii mahii, «E nees ab ootheenee? E ne aafa wayizii patheennee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","E unttiko, «Taanii yinttis odeeza, zin yi si7ibe7ekkaya. Abis maaqqii maaqqii si7odayis koyinnee? Yinttikka e tamaare maaqqodayis koyinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Unttii eza cazhii, «Ne ye athay tamaare; nuunii Muse tamaare geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xoossay Muses odeezana nuunii eriza, zin yha athay E anapp ye7eezakokka nu erooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Athay unttiko, «E anapp ye7eezako yinttii eroozay malabaz, zin E ta aafa patheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xoossa bonchchizannee E koyiz baz oothiza atha Xooss si7eezapp attin nagara oothizita si7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Salo sa7a medhintteezaypp to7a maaqqii yelintteez as aafe patheezay oonkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yha athay Xoossapp kiitinttekkazako pettibazikka oothodayis danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Unttii maaqqii, «Neenii nagarara yelinttii dicceezay nuna tamaarssodayis koyinee?» yeegeeza. U eza Ayihuditay Woosa keethapp kesseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuusa unttii atha bale kesseezana si7ii eza hellii, «As Na7a ne ammaninee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Athay Yesuusako, «Godayyo, ta Eza ammanod garkk E oonoo? Taas odooye?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuusa athayko, «Ne Eza be7eeza; yha neer odinttizay Eza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Athay mahii, «Godayyo, ta ammaniza» yeegii Yesuusas goynniza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuusa, «To7itay be7adgarkk bi7izitay to7oday garkk pirddodayis yha alame ta ye7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ezar yezi xiqqa Ferisaawe asitay yeya si7ii, «Nu to7annee?» yeegii woli oycicheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuusa, «yi to7ita maaqqeezako yinttis nagara baaya. Zin yhatti yi bi7iza giz gishos yi, yi nagarara yi yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuusa, «Taanii yinttis turo odiza; dur kale gancce penger baazin hara oger geliz oonkka kayizonnee paanno. ");
INSERT INTO mfxl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yeya maaqqozin penger gelizay durita heenggizaya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penge naagizay ezisi penga dooyiza; duritaykka E qaala si7iza. E fa durita u sunthayir sunthayir xeegiza; unttan kaalithii bale kessiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","E ootheez faasita bale kesseezaypp guye u tiina tiina yedhdhiza. Unttikka E qaala eriza gishos Eza kaalliza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hara as qaala unttii eroowa gishos eep haakkizapp attin E lassa kaallooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuusa unttis yha aazisa odeeza, abi odeezakko unttii akaakekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mahii Yesuusa unttiko, «Taanii yinttis turo odiza; ta duritayis penge. ");
INSERT INTO mfxl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taapp tiini ye7eez ubbitay kayizonnee paanno, yeya maaqqadar duritay unttan si7ibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Pengey tana; ta baggar geliza oonkka attoda. E ta baggar gelodannee kezoda; lo77o heengginttiz aqo demmada. ");
INSERT INTO mfxl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kayzo kasttodayis, shukkodaysinnee dhabisodayis yi7izap attin harabazis ye7ooya. Taanii unttis de7o yezod garkkerannee kumii fucod garkk ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Taanii lo77o henthancho; lo77o henthanchchay fa duritay gishos fa shemppo aathii inggiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kera heenggiz as duritay godanne henthanchcho baazay gishos fuge yi7iko bi7ii durita ashii hali7iza. Yeyi gishos, suudhume durita aykkii laaliza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kera heenggizay miishes heenggiz gishonnee duritaybaz eza qofisoowa gishos durita ashii laasiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«Taanii lo77o henthanchcho. Ta Aday tana erizay gark taankka ta Ada eriza. Yey garkkekka, ta ta durita eriza; ta duritaykka tana eriza. Taanii ta duritay gishos ta shemppo aathii inggiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yha wudayid baa hara duritay taas yeza. Taanii unttanakka ko7odayis beeziza. Unttii ta qaala si7oda; unttii pettii wude maaqqada; henthanchchaykka petta. ");
INSERT INTO mfxl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Taanii ta shemppo aathii inggii mahii ekkiz gishos ta Aday tana doseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta dosiza ta shemppo aathii inggizaypp attin taapp oonkka ekkenna. Ta ta shemppo aathii immadayisinnee mahii ekkodayis silixxaanee taas yeza. Taanii oothod garkk ta Aday tana kiitteezay yhaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yeya E geez gishos Ayihuditay gancce maakka shaakotethii medhintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Unttapp gaame baggay, «Ezar tuna ayyana yeza! E eeyiza! E giz baz abis si7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yhankkitay ma, «Xalahe aykkeez as yhay garkk odinttooya. Tuna ayyana to7a aafe beezodayis danda7inee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalaame Xoossa Keethi orotheez gallasitay bonchchiza baale helleeza; ye wode sa7a barigo. ");
INSERT INTO mfxl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuusa Xoossa Keethi Solomone baaranddar yuuyiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayihuditay Yesuusa lanqqayid shiiqii eqqii, «Neenii nuna ayide hellodayis sidher gaddodee? Neenii Kiristtoosa maaqqiko ane nuus geeshshii odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuusa maaqqii unttiko, «Taanii yinttis odeeza; zin yi tana ammanooya. Taanii ta Aday taasi inggeez mawuter oothiza oosay tabaz markkattiza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Zin taanii yinttis odeezay garkk yi ta dure maaqqekka gishos ammanooya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta duritay ta qaala si7oda. Ta unttan eriza; unttikka tana kaalliza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taanii unttis medhina de7o inggiza; unttii ubbarakka dhabaamii. Oonkka ta kushep unttan bonqqii ekkodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Unttan taasi inggeez ta Aday ubbap aadhiza oonkka ta Aday kushep unttan bonqqii ekkodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taannee ta Aday petto» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayihuditay Yesuusa shocodayis maakka shuchchi dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesuusa unttiko, «Taanii oothod garkk ta Aday taasi inggeez gaame lo77o oosita yinttan oothii beeziza. Yeyititaypp aayay gishos tana shuchchar shocodayis koyinnee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayihuditay mahii, «Nuunii nena ne lo77o ooso gishos shuchchar shocodayis koyooya. Zin neenii Xooss cazheez gishonnee as maaqqitar ne nena Xooss giz gishshosi» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuusa mahii, «Geeshsha Maxaafayid Xoossay, ‹Yi Xoossita› geezay xaafinttekkasa? ");
INSERT INTO mfxl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Geeshsha Maxaafay medhinas laaminttaammii. Xoossay fa qaala inggeez asita, ‹Xoossita› gi xeegiko, ");
INSERT INTO mfxl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ta tana Xooss na7a geezayis, Aday maraxii yha alame kiitteez tana Xooss Na7a wayizii ‹Xoossa ne cazhiza› yeegee? ");
INSERT INTO mfxl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taanii ta Aday oothizana oothaam ixxiko tana ammanippatte. ");
INSERT INTO mfxl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Zin taanii oothizabaz maaqqiko yinttii tana ammanaam ixxikokka, ta Aday taar yezannee taakka ta Adayir yezana yi erod garkk ta oosa ammanoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Maakka unttii eza aykkodayis koyeeza, zin E unttapp buuttii kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Waannisa tiin xammaqiza aqa, Yorddanoosa borikap seko pino Yesuusa piinggii ezayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gaame asay Yesuusako yi7ii, «Waannisa malata oothekkaya, zin E yha athayabaz odeezbazay ubbay tuma» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ezayid gaame asay Yesuusa ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bitaana heera Alaazara giz pettii athay harggintteeza. Bitaana Mayiramirannee I mishshitti Marttara yeza heera. ");
INSERT INTO mfxl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mayrama Goday toka shitto tizheez fa binanayirakka e toka ucceezanno. Harggintteezay I isha Alaazara. ");
INSERT INTO mfxl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yey gishos, mishunthikka, «Godayyo, ne dosizay harggintteeza» gi Yesuusako azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuusa yeya si7ii «Yha harggay, Xoossaynnee e Na7ay bonchchnttod garkkepp attin yhayiqos helithiz harige baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuusa Martta, I mishshitonnee Alaazara qaadhiza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Zin Alaazare harggintteeza gin Yesuusa si7ii fa yeza aqo nam77ii gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yeypp guye, Yesuusa fa tamaaritayiko, «Mahii Yihuda biitta wolla yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E tamaaritay mahii, «Asitamaarayyo, xiqqa wodepp tiin Ayihuditay nena shuchchar shoccii wodhodayis koyeezannee; yhattekka gede yhammadee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuusa, «Pettii gallasa gancce taphpho nam77ii saate baasannee? Gallas yedhdhiz asii yha alame poo7a bi7iza gishos dhubinttaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Zin qamma yedhdhiz oonkka poo7o baazay gishos dhubinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuusa yeya geezaypp guye unttiko, «Nu qadhdhiza Alaazare gentteeza, zin eza denthodayis taanii yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E tamaaritay mahii, «Godayyo, E gentteezbaz maaqqiko eesi lo77oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuusa Alaazare yhayqqeezay gishos yeya odeeza, zin unttisi cer gentta aaziza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yeyi gishos, Yesuusa qoncisii unttiko, «Alaazare yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yi ammanod garkk taanii ye aqayid baa maaqqeezayis yi gishos tana ufayssiza. An yedhdhoytta; eziko wolla yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yeypp guye, Didimoosa ginttinttiz Toomaasa fa lagge tamaaritayiko, «Asitamaarayir yhayqqodayis nuukka wolla yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuusa Bitaana hellodar Alaazare mooginttin oyddii gallas maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaane Yerusallemepp hayidzii kilo mitire garkk haakkiza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Gaame Ayihuditay Marttannee Mayramo u ishay yhayqqeezayis minthathodayis ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martta Yesuusa ye7eezana si7ii eza mokkodayis kezeeza, zin Mayrama keetha atteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martta Yesuusako, «Godayyo, neenii yhaydda yeza maaqqeezako ta ishay yhayqqaam. ");
INSERT INTO mfxl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Zin yhatti maaqqikokka neenii woossiza baz Xoossay nees immadana taanii eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuusa, «Ne ishay yhayiqopp dendoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martta eziko, «Wurssith gallas E yhayiqopp dendodana ta eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesuusa iziko, «Taanii dendonnee de7o; tana ammaniza oonkka yhayqqikokka de7or yezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma de7or yezayinnee tana ammaniza oonkka yhayqqaam. Yeya ne ammaninee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martta mahii, «Godayoo, ee taanii ammaniza! Neenii Xooss Na7a, alame ye7odayis yeza Kiristtoosa maaqqizana taanii ammaniza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martta yeya geezaypp guye, yhanigii fa mishshitto geema xeegii, «Asitamaaray yi7ii nena koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mayrama yeya si7ii ellisii denddii Yesuusako yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ye wode Yesuusa Martta eza Mokkeez aqo yeza; haga heera hellekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mayramo minthathitar izir kara yezi Ayihuditay, iza denddii ellisii bale kezeezaya bi7ii, duufo yhanigii yeekkodayis haniza aazin izo kaallii kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayrama Yesuusa yeza aqa yhanigii eza bi7ii e tokayil afa guphinggii, «Godayyo, neenii yhaydda yeza maaqqeezako ta ishay yhayqqaamizin» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuusa Mayiraminnee iir yez, Ayihuditay yeekkizana bi7ii, fa wozinar iita micinttii, ");
INSERT INTO mfxl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Aba moogeenee?» yeegii oyicin, «Godayyo, yi7ii bo7oba» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuusa afuxeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yeyi gishos, Ayihuditay, «E Alaazara ab garkk qadhdhizako bo7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Zin unttapp pettay pettay, «yhayi to7a bi7iseezay yha athay yhayqqaam garkk oothodayis danda7aamonee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Maakka Yesuusa micinttii, Alaazare moogintteez duufa qitteeza. Ye duufay shuchchar gorddintteez komi7o. ");
INSERT INTO mfxl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesuusa, «Shuchcha denthoytta» yeegii azazeeza. Martta, «Godayyo, E yhayqqeezaypp oyddii gallas maaqqeez gishos yhatti zeeqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuusa Marttako, «Ne ammanizabaz maaqqiko Xooss bonchcho be7adana taanii nees odekkasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Unttii shuchcha denthin Yesuusa salo pude bi7ii, «adayyo, tana ne si7eez gishos nena galatiza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne ubba wode tana si7izana taanii eriza. Zin yhaydda eqqeez asay neenii tana azazeezana ammanoday garkk taanii u gishos yhaya giza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuusa yeya geezaypp guye, fa qaala dhoqi uddii, «Alaazara, yhana kezoba!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yhayqqeez athay zidhithatir kushaynnee tokay shalor acinttii yezin e aafe baggay goozintteezin duufaypp kezeeza. Yesuusa unttan, «Billoytta! Yhamme goytta!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yeyi gishos, Mayramiko ye7eez Ayihuditaypp gaamitay Yesuusa ootheezana bi7ii eza ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Zin unttapp pettay pettay Ferisaawitayiko yhanigii Yesuusa ootheezana unttisi odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yeypp guye, qeese halaqitayinnee Ferisaawe asay shanggo shiishii, «Yha athay gaame malla oothizi gishos nu abi udoo? ");
INSERT INTO mfxl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuunii eza si77i gi ashshiko as ubbay eza ammanoda. Ma Oroome biitta asay yi7ii nu Xoossa Karannee nu gada dhabisoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Unttapp pettay Qayyaafa gizayi, ye laythi qeese halaqa maaqqeezay, «Yi abikka erooya! ");
INSERT INTO mfxl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Asay ubbitay dhabizaypp as ubbay gishos pettii as yhayqqizay lo77o maaqqizana yi eroosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E yeya paapp geekkaya. Zin (ye laythi qeese halaqa maaqqiz gishos Yesuusa Ayihude as gishos yhayqqodayis beezizana tinbbite odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma Yesuusa Ayihude as aaddas baazin laalinttii yezi Xoossa asii ubba wollal shiishodayisnnee pettii asii oothodayis yhayqqoda.) ");
INSERT INTO mfxl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ye gallasapp aykkii unttii eza wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yey gishos, Yesuusa Ayihuditay gancce geeshshar yuuyekkaya. Zin liizho deniba lanqqe yezi Efreeme heera yhanigeeza. Fa tamaaritayir ye aqayid gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayihuditay bonchchiza Paaziqa gallasay uukkeeza. Ma gaame asay fana qashodayis Paaziqa bonchchiza gallasay hellodaypp tiina ye biittapp Yerusalaame qitteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Unttii Xoossa Keetha eqqii Yesuusa yi7itha naagiza gishos «Abi qoppee? Yesuusa baala bonchchodayis ye7oosa?» yeegii pettay petta oyiceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Qeese halaqitayinnee Ferisaawe asay Yesuusa aykkodayis, E yezabessa eriza oonkka paasi odod garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paaziqa bonchchiza gallasipp usuppun gallas tiinattii, Yesuusa yhayiqopp dentheez Alaazare yezi heera, Bitaana qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ye aqayid unttii ees kaho giigiseeza. Alaazare Yesuusar wollal munttal betteezin Martta unttan mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayrama narddoosa giz gaame al7o geesh shitto ki7i Yesuusa toka tizheeza. Fa binnannayir e toka ucceeza; keetha ubbay shitto sawor tonkki geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Zin Yesuusa tamaaritaypp pettay, Yesuusa aathii inggoday, Asiqoroto Yihuda, ");
INSERT INTO mfxl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Abis yha shittay hayidzii xeet dinnare bayizinttii, miishay manqqitayis ingginttoosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(E kayzo maaqqeez gishos yeya geezapp attin manqqitayis qadhinttii geekkaya. E miishe quribo aykkiza maaqqeez gishos ubba wode ezaypp paas ekkiza.) ");
INSERT INTO mfxl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuusa, «Iza paas yeza baz ta moogo gallasis minjjeez gishos izo ashii ashshoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Manqqitay ubba wode yinttar yezoda, zin taanii ubba wode yinttar yezaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye wode gaame asay Yesuusa Bitaana yezana si7ii gede yhanigeeza. Unttii Yesuusa aadda baazin E yhayiqopp dentheez Alaazarakka be7adayis yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yeyi gishos, qeese halaqitay Alaazarakka ma wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Abis giiko, Alaazara baggar gaame Ayihuditay unttan ixxii Yesuusana ammaniza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wonttitha gallas Paaziqa bonchchiza aqo ye7eez woya Yesuusa Yerusalaame yhanigiza si7ii, ");
INSERT INTO mfxl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Zambba haye ekkii eza mokkodayis kezeeza. Fa qaala dhoqqi udii, «Hosaana! Xoossay galatintto! Goday sunthar yi7izay anjjintto! Xoossa Isreele Kaattay anjjintto!» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Geeshsha Maxaafayid, «Xiyone katamas, yashittippe! Yeezako, ne Kaatay hare na7al afa bettii yi7iza» giinttintteezay garkk Yesuusa hare na7a dengii eza toggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesuusa tamaaritay yeya tiin akaakekaya. Zin Yesuusa bonchchinttezaypp guye unttii yeya ubba akaakeeza. Yeyi ubbay geeshsha Maxaafay geezay gark haneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesuusa Alaazara duufoppi xeegii, yhayiqoppi dentheez wode ezar yez gaame asay Yesuusa oosa markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gaame asay eza mokkodayis kezeezay, E ye mallita ootheezana si7eez gishshosii. ");
INSERT INTO mfxl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yey gishos, Ferisaawe asay pettay peetayiko, «Nu abkka oothodayis danda7ooza bo7oytta; woya ubbay eza kaalliza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Paaziqa bonchchiza gallas goynnodayis Yerusalaame yhanigeezitay gancce pettii pettii Girike asay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Unttii Galila biitta Beetesayda katamapi ye7eez Filphoosakko yhanigii, «Godayyo, nuunii Yesuusa be7adayis koyiza» yeegii woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filphoosa yhanigii Indiraases odin nam7itay yhanigii, Yesuusas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuusa unttiko, «Asi Na7ay, bonchchinttiza wode helleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taanii yinttis turo odiza; pettii gistte aafe biitta gancce wodhdhii wooqqekka attiko fa aaddas attiza. Zin ye gistte aafay wooqqiko gaame aafe aafiza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Fa shemppo qadhdhiza oonkka dhabisiza; fa shemppo yha alamayid ixxiza oonkka medhinas de7os nagisiza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taanii yeza aqo taar yezod garkk taasi oothodayis koyiz oonkka tana kaallodayis beeziza. Taas oothiza oonakka ta Aday bonchchoda. ");
INSERT INTO mfxl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Yhatti ta shemppay gaame un77initeeza; yeezin waago? ‹Ta Adayyo, tana yha saataypp ashshooyee› yeego? Wa77a, taanii ye7eezay meto ekkodayisii. ");
INSERT INTO mfxl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta Adayyo, ne suntha bonchchoba» yeegeeza. Yeypp guye salopp, «Taanii ta suntha bonchcheeza; gujjika bonchchoda» yeegizi qaala ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ye aqayid eqqeez gaame asay ye qaala si7ii, «Yeyi dada» yeegeeza. Yhankkitay ma, «Kiitanchchay eesi odeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuusa mahii unttiko, «Yha qaalay yi gishos ye7eezaypp attin ta gishos baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yha alamay pirddinttiza woday yhatte; yha alama aqisizana yhatti bale oloda. ");
INSERT INTO mfxl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma taanii sa7app dhoqqi geez wode asi ubba taako ko7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E yeya geezay ab garkk yhayiqo yhayqqodazako unttis erisodayisii. ");
INSERT INTO mfxl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gaame asay mahii, «Nu higgay Kiristtoosa medhinas yezana odiza. Yeezin, neenii waagii, As Na7ay dhoqi goddayis beeziza gee? E, As Na7ay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuusa, «Poo7ay yinttar xiqqa wode gam7oda. Yinttis dhumaam garkk poo7o yezin, poo7ayir yedhdhoytta. Dhumar yedhdhiz as ana yhanigizako erooya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Poo7o na7ita maaqqad garkk poo7o yezin poo7ana ammanoytta» yeegeeza. Yesuusa yeya odeezayp guye yhanggii unttapp geemmeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E yey garkk mallita u tiinayid oothinkka ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nabe Isayaasa, «Godayyo, nu markketithi oonii ammaneennee? Goday wolqqay oossi beentteennee?» Geezay tuma maaqqaday garkk unttii eza ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Maakka Isayaasa, «U aafay be7aam garkk, u wozinay akaakam garkk, unttii Xoossiko maaqqin, E unttan pathaamay garkk, Xoossay u aafa too7iseeza. U wozina miintheeza» geez gishos unttii ammanodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayaasa yeya geezay, Yesuusa bonchcho be7eez gishonnee ebaz odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Maaqqikokka, Ayihuditay halaqitayppekka gaamitay Yesuusana ammaneeza. Zin Ferisaawe asitay fana Ayihuditay Woosa keethap kessiza gi yashitteez gishos ammaneez gi geesha markkattekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yeya unttii ootheezay, Xoossar erinttodaypp aathii asar erinttodana doseez gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuusa fa qaala dhoqi uddii, «Tana ammaniza oonkka tana azazeezanakka ammaneezaypp attin tana aadda ammanooya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tana bi7iza oonkka tana azazeezanakka bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tana ammaniza ubbay dhuma gancce yezaam garkk poo7o maaqqii alame taanii ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta qaala si7ii kiitinttoowa oonakka taanii pirddaamii. Abis giiko, taanii alame ashshodayis ye7eezaypp attin pirddodayis ye7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tana ixxizannee ta qaala ekkowa oonakka pirddizay yeza. Taanii odeez qaalay wurssith gallas ye atha pirddoda. ");
INSERT INTO mfxl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Abis giiko, taanii yeya taapp odekkaya, zin tana kiitteez ta Aday taanii ab godazakonne ab ododazako azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma e kiitay medhinas de7o maaqqizana taanii eriza. Yeyi gishos, taanii odizay ta Aday tana odoba geezana» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paaziqa bonchchiza gallasay hellodaypp tiinatii yha alame ashshii Adayiko yhanigiza wode helleezana Yesuusa ereeza. Yha alamayid yez faasita ubba wode doseez; folo siiqorakka unttan doseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesuusara e tamaaritayir wolla kaho maadar Xalahe Simoona na7a Asiqoroto Yihuda Yesuusa aathii immadaygarkk e wozina gancce iita qofa gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuusas Aday ubba baz e kushe gaddeezana, E Xoossapp ye7eezanannee maaqqii eziko yhammadana ereeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesuusa kaho mi denddii fa guulantta qaarii gaddii, pooxa fa xeessa dancceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yeypp guye, gabate gancce haath qoli, fa tamaaritay toke meecceeza; ma fa xeessayida dancceez pooxayir ucceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesuusa Simoon Phixiroosako ye7odar Phixiroosa, «Godayyo, ne ta toka meeccodee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuusa mahii eziko, «Taanii oothizana ne yhatti erooya, zin guyepp akaakoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yeezin, Phixiroosa, «Ne ta toka ubbarakka meeccodayis danda7ooya» yeegeeza. Yesuusa eziko, «Taanii ne toke meeccekka attiko neesinnee taasi pettipetithii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Phixiroosa Yesuusako, «Godayyo, yeezako, ta tokay aadda baazin ta kushannee ta omma meeccoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuusa mahii, «Galla meecintteez oonkka tokepp hara baz meecinttodayis beezooya; e ubbay geeshshii. Yi geeshshii, zin ubba asii geeshshii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuusa fana aathii immad athay oonazako eriza gishos «Yi ubbitay geeshshii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","U toke meecceezaypp guye Yesuusa fa afila mahii ma77eeza. Maaqqii munttal afa bettii unttiko, «Taanii yinttis ootheezana akaakinee? ");
INSERT INTO mfxl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yi tana asitamaarennee Goda giza; taanii yi giza maaqqeez gishos lo77o geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taanii yinttis Godanne asitamaare maaqqitar yi toke meecciko yinttikka pettay pettayis yhay garkk oothodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yikkee, taanii yinttis ootheezay garkk yinttikka oothod garkk yinttis aaziso maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taanii yinttis turo odiza; ayllay fa godaypp, kiitintteezay kiitteezaypp aadhooya. ");
INSERT INTO mfxl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yi yeya erii oothizabaz maaqqiko anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Taanii yinttan ubbita gooya; taanii maraxeezita ta eriza. Zin geeshsha Maxaafayid, ‹Taapp meezay taal afa fa toka dentheeza› ginttinttizay tuma maaqqodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Taanii Tana maaqqeezana yi ammanod garkk yeyi hanodaypp tiinattii yinttis odiza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taanii yinttis turo odiza; taanii kiitteez oonakka mokkiza athay tana mokkiza. Tana mokkiz oonkka tana azazeezana mokkiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuusa yeya odeezaypp guye fa wozinar gaame un77inttii, «Taanii yinttis turo odiza; tana yinttipp pettay aathii immada» gi qonccisii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","E o bagga odizako e tamaaritayis erinttaam ixxin pettay petta be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","E tamaaritaypp pettay, Yesuus dosizay, Yesuusa kale betteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yeyi gishos, Simoon Phixiroosa eza qami7ottii, «E oona gizako an oyicoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yeyi gishos, ye tamaaray Yesuusako haye kale shiiqii, «Godayyo, E oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuusa mahii, «Taanii soollo dushii barssizaya» yeegeeza. Ma soollo duuthii ekkii, dushii, Simoona na7a Asiqoroto Yihuda barsseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihudana soollo baareezaypp guye Xalahe ellisii Yihuda gancce geleeza. Yesuusa eeko, «Ne oothodayis qoppeezanno ellisii oothoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Zin munttal afa betteezitaypp oonkka Yesuusa yeya abis geezako erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihuda miishe aykkizi gishos e tamaaritaypp pettay pettay Yesuusa e, «Paaziqa bonchchiza gallasis paasi koshshiza baz wonggoba woy manqqitayis muxaata inggoba geeza» yeegii qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihuda soollo baareezangarkk izira bale kezeeza. Ye wode sa7a qamma. ");
INSERT INTO mfxl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihuda bale kezeezaypp guye, Yesuusa, «Yhatti As Na7ay bonchchintteeza; Xoossaykka e baggar bonchchintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xoossay e baggar bonchchinttiko E fa ommas As Na7a bonchchoda; ma E yeya ellis oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta na7untho, taanii yinttar gaame wode gam7aamii. Yi tana koyoda, zin taanii Ayihuditayis odeezan garkk, ‹Yi taanii yhanigiza aqo yhammadayis danda7ooya› ");
INSERT INTO mfxl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Taanii yinttis inggiz orothi kiitay yhaya; pettay petta qadhdhoytta. Taanii yinttan qadhdheezay garkk yi pettay petta qadhdhodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yi pettay pettayira dosinttiko yi ta tamaare maaqqizana asii ubbay eroda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoon Phixiroosa Yesuusako, «Godayyo, ne ana yhanigee?» yeegeeza. Yesuusa mahii, «Taanii yhanigiza aqo neenii yhatti kaallodayis danda7ooya, zin guyepp tana kaalloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phixiroosa, «Godayyo, taanii nena yhatti kaallodayis abis danda7oosa? Taanii ne gishos yhayqqodayis giig betteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuusa mahii, «Ta gishos yhayqqodayis tuma giig betteennee? Taanii nees turo odiza; shugula uukkodaypp tiini neenii tana hayidzii tok kaddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuusa fa tamaaritayiko, «Yi wozinay un77inttipe, Xooss ammanoytta, tanakka ammanoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Aday kara gaame aqo yeza. Taanii yinttis bessi giigisodayis yhanigiza. Yeya maaqqekkazako taanii yinttis ododizin. ");
INSERT INTO mfxl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Taanii yhanigii bessi giigiseezaypp guye taanii yeza aqo yi yezod garkk maaqqii yi7ii yinttan taako kanggoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yi taanii yhanigiza aqo kanggiz oge yi eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yeezin, Toomaasa, «Godayyo, neenii yhanigiza aqo nuunii erooya; oga wayizii erodayis danda7odee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuusa mahii, «Oge, tumaynnee de7o tana. Ta baggar maaqqaam ixxiko oonkka ta Adayko yhammadayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yi tana eriza baz maaqqeezako, ta Adakka eroda. Zin yhaypp aykkii yi eza erizanee eza be77eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filphoosa Yesuusako, «Godayyo, Ada nuna beezoba; yeyi nuus gidoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuusa mahii, «Taanii yhaygarkk wode yinttar yeezinka tana eroosa? Tana be7eez athay Adakka be7eeza. Yeezin, neenii waagii, ‹Ada nuna beezooyee› gee? ");
INSERT INTO mfxl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taanii Adayir yezannee Adaykka taar yezana neenii ammanoosannee? Taanii yinttis odiz qaala taanii taapp odooya, zin taar yeza Aday fa ootho oothiza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taanii Adayir yezanannee Adaykka taar yezana yi ammanoytta. Yeya ammanaamixiko ta ootheez malla bazitayil tana ammanoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Taanii yinttis turo odiza; tana ammaniza athay taanii oothiza ooso oothod. Taanii Adayko yhanigiza gishos tana ammaniza oonkka yhaypp aadhiz oosita oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aday Na7ay baggar bonchchnttod garkk ta sunthar yi woossiza ubbita ta yinttis oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta sunthar ababazikka yi oyiciko ta yinttis oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Yi tana qadhiko ta kiita naagoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taanii Ada woossoda; yinttar medhinas yezod garkk minthathiza yinttis immada. ");
INSERT INTO mfxl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yha alame asay eza be7ekkazay gishonnee eroowa gishos eza ekkodayis danda7ooya tuma Ayyana. Zin E yinttar yeza gishonnee yi gancce yezod gishos yi eza eroda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Taanii yinttan inda ade baa na7a garkk yi aadda ashshaamii; maaqqii yinttiko ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xiqqa wodepp guye alamay tana mahii be7enna, zin yi be7ada. Taanii de7or yeza gishos yinttikka de7or yessada. ");
INSERT INTO mfxl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taanii ta Adayir, yi taar, ma taanii yinttar yezana yi ye gallas eroda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ta kiita ekkii naagizay tana qaadhiza. Tana qadhdhizana ta Adaykka qaadhiza; taankka eza qadhdhiza; taanii eesi benttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asiqoroto Yihuda baa yhankko Yihuda Yesuusako, «Godayyo, neenii wayizii alamayis baazin nuus nena beezodee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuusa mahii, «Tana qadhdhiza oonkka ta qaalayis kiittinttoda. Ta Aday eza qadhdhoda. Ma ta Adayira taara eziko yi7ii ezar yezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tana dosowa oonkka ta qaalayis kiittinttooya. Yi si7iz qaalay tana kiitteez Aday bazapp attin tabaz baaya.» ");
INSERT INTO mfxl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Taanii yinttar yhatti yezar yeya yinttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Zin Aday ta sunthar kiittoda minthathiza geesha Ayyanay, yinttan ubba baz tamarssoda. Taanii yinttis odeez ubba E yinttan hassayisoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sarotithi yinttis ashshoda. Taanii ta sarotitha yinttis immada. Ta ingiz sarotithay alamay inggiz sarotithay garkk baaya. Yeyi gishos, un77intippete, yashittipate. ");
INSERT INTO mfxl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","«Taanii yhammad, maaqqii yinttiko ye7oda» geezana yi si7eeza. Yi tana tuma dosizibaz maaqqeezako ta Aday taapp aadhiz gishos taanii eziko yhanigizayid yi ufayttoda. ");
INSERT INTO mfxl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yeyi hanodar yi ammanod garkk yeyi hanekkazin tiinatii taanii yinttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yha alama aqisizay yi7iza gishos yhaypp guye yinttar gaame odinttaamii. Tana E abikka oothodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Zin taanii Ada qadhdhizana alamay erod garkk ta Aday tana azazeezana ubba oothiza. Dendoytta; yhaypp wolla yhammada. ");
INSERT INTO mfxl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Taanii woynnes tuma ubba. Oothizay ta Ada. ");
INSERT INTO mfxl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Taal afa yezii aafe aafowa shaqo ubba E kariza. Aafiz shaqo tiinaasaypp aadhii aafoday garkk ye shaqa E giigisoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Taanii yinttis odeez qaalay gishos yi geeshshita. ");
INSERT INTO mfxl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taar yezoytta; taankka yinttar yezoda. Woynnee shaqay ubbayir yezekka attiko ye shaqay fa aaddas aafe aafodayis danda7ooya. Yey garkkekka, yinttikka taal yezekka attiko aafe aafodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Taanii woynnes ubba; yi shaqqita. Taar yezizaynnee taanii ezar yezizay, E gaame aafe aafoda. Ta baazin yi yi ubbas abikka oothodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Taar yezoowazay shaqo garkk bale olinttii meloda. Unttan shiishii tama oloda, eexoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yi taar yeziko, ta qaalaykka yinttar yeziko, yi koyiz baz abi maaqqikokka woossoytta; yi ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yi gaame aafe aafikonne ta tamaare maaqqiko, yeyid ta Aday bonchchnttoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aday tana qadhdhizay garkk taankka yinttan qadhdhiza; ta siiqayir yezoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taanii ta Aday kiita naagii e siiqayid yezeezay mgarkk yinttikka ta kiita naagiko ta siiqayid yezoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Ta ufayssay yinttar maaqqaday garkkennee yi ufayssay folo maaqqad garkk taanii yinttis yeya odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta kiitay yhaya; taanii yinttan qadhdheezay garkk yinttikka woli woli qadhdhoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Fa shemppo fa laggayis aathii inggizaypp aadhiz dama siiqo baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Taanii yinttan kiitteez ubbita yi oothiko yi ta dabbita. ");
INSERT INTO mfxl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«Aylle fa goday oothizabaz eroowa gishos taanii yinttan yhaypp guye ayllita gamii. Zin ta Adaypp si7eez ubbita taanii yinttis odeez gishos yinttan dosintteezita geeza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taanii yinttan doreezaypp attin yi tana doorekkaya. Yi yhanigii dhaboowa aafe aafod garkk taanii yinttan shuumeeza. Yeezako ta Aday yi ta sunthar woosseezibaz ubba yinttis immada. ");
INSERT INTO mfxl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ta kiitay yhaya: woli woli qadhdhoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Alamay yinttan ixxiko tiinattii tana ixxeeza eroytta. ");
INSERT INTO mfxl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yi alame baz maaqqeezako alamay fabaz garkk yinttan qadhdhoda. Zin taanii yinttan alamepp shagii dooreez gishonnee yi alame baz baa gishos alamay yinttan ixxiza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹Aylle fa godaypp aadhooya› gi taanii yinttis odeezana qoppoytta. Unttii tana bayi7eez baz maaqqiko yinttanakka bayi7oda. Unttii ta qaala naageezbaz maaqqiko yi qaalakka naagoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Zin unttii tana azazeezana eroowa gishos yha ubba ta baggar yinttal afa oothoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taanii yi7ii odekkabaz maaqqeezako unttisi nagara maaqqenna. Zin yhatti unttii ootheez nagarayis odod salambe baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tana ixxizay ta Adakka ixxiza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Oonkka oothekka ooso ta u gancce oothibe7ekkabaz maaqqeezako unttis nagara maaqqaam zin yhatti unttii taanii ootheeza bi7ii tanakka ta Adakka ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Zin u higgayid, ‹Tana cer ixxeeza› ginttinttii xaafintteezay polinttod garkk yeyi haneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Adaypp yi7iz tuma beeziza Ayyana ta yinttis kiittoda. E yinttan minthathoda, tabaz markkottoda. ");
INSERT INTO mfxl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yinttikka tiinapp aykkii taar yeza gishos tabaz markkottoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Taanii yeya yi ammanay dhabaam garkk yinttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","U yinttan Ayihuditay Woosa Keethitaypp kessii dakkoda. Yey garkkekka, yinttan wodhiza oonkka Xoossii koyiz baz oothiza aaziza wode ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Unttii yeya yinttal afa oothizay tana woy Ada eroowa gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Zin unttii yeya yinttal afa oothiza wode hellodar taanii yinttis odeezana yi akaakod garkk taanii yinttis yhaya odeeza. Tiinatii taanii yhaya yinttis odekka gam7eezay ta yinttar yeza gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Zin yhatti taanii tana kiitteezayiko yhanigiza; yinttapp oonkka, ‹Ana yhanigee?› gi tana oyicizay baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Zin taanii yeya odeez gishos yi wozinay azzanor kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Zin taanii yinttis turo odiza; taanii yhanigiko yinttis lo77o. Abis giiko, taanii yhanggaam ixxiko minthathizay yinttiko ye7enna. Zin taanii yhanigii eza yinttiko dakkoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Minthathizay yi7ii, nagarabazinnee, xillotith bazinnee pirdda bagga yha alame as erisoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nagarabaggay, asay tana ammanoowa gishshosii. ");
INSERT INTO mfxl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xillotithibaggay, taanii Adayko yhanigiza gishonnee yi tana maaqqii bo7oowa gishshosi. ");
INSERT INTO mfxl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pirddabaggay, ma alame aqisizay pirddintteez gishshosii. ");
INSERT INTO mfxl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Taanii yinttis odiza gaame baz yeza, zin yhatti yinttis gelooya. ");
INSERT INTO mfxl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tuma Ayyana yi7ii yinttan tumatithii ubbayko kaalithoda. E si7eez baz odizapp attin paapp ababazikka odooya. Ma tiinapp ye7odibaz yinttis E ododa. ");
INSERT INTO mfxl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","E taasi yezaypp ekkii yinttis odiza gishos E tana bonchchoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Adayis yeza baz ubbitay tabaz; ‹Ayyanay taasi yezaypp ekkii yinttis ododa› taanii geezay yey gishosii. ");
INSERT INTO mfxl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Xiqqa wodepp guye yi tana be7aamii; maakka xiqqa wodepp guye yi tana be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","E tamaaritaypp pettay pettay woli gancce, «Xiqqa wodeppi guye yi tana be7aamii; ma xiqqa wodepp guye yi tana be7ada; maakka taanii Adayko yhanigiza guussay waaguusso?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«Xiqqa wodepp guye waaguusso? E abi odinttizako nuus erinttooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Unttii fana oyicodayis koyizana Yesuusa erii, «Taanii, ‹Xiqqa wodeppi guye yi tana be7aamii; ma xiqqa wodepp guye yi tana be7ada› yeegeez gisho yi woli woli oyicinee? ");
INSERT INTO mfxl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taanii yinttis turo odiza; yi yeekkodannee afuxoda, zin yha alamay ufayttoda. Yhatti yi azzanoda, zin yi azzanay ufayisa laaminttoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wodeth asita na7a yelod hanodar fa yelo woday helleez gishos hirigiza. Zin na7a yelleezaypp guye na7a yha alamayil yelintteezay ufayssiza gishos fa meta iza dogiza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yey garkk, yinttikka yi wozinar azaniza, zin taanii yinttan maaqqii be7ada. Yi wozinay lo7ithii ufayttoda; ye ufayssa oonkka yinttapp ekkenna. ");
INSERT INTO mfxl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Ye gallas yi tana ababazikka woosseenaa. Taanii yinttis turo odiza; yi ta sunthar woossiza baz ubba Aday yinttis immada. ");
INSERT INTO mfxl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yhanno hellodayis ta sunthar ababazkka yi woossekkaya. Yi ufayssay folo maaqqad garkk Xoossa woossoytta; yi ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Taanii yhanno hellodayis yinttis aazisor odeeza, yhaypp taanii aazisor odoowa wode ye7oda. Zin Adayibagga taanii yinttis qoncissii ododa. ");
INSERT INTO mfxl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ye gallas yi ta sunthar Ada woossoda; yi gishos taanii Ada woossaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Abis giiko, Aday fa ubbas yinttan qadhdhiza. Yi tana qadhdhiza gishonnee taanii Aday lanqqepp ye7eezana yi ammaneez gishos E yinttan qaadhiza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taanii Aday lanqqepp yha alame ye7eeza; ma alame ashshii Adayko yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E tamaaritay maaqqii, «Yeezako, yhatti neenii qoncce odiza; aazisor abikka odooya. ");
INSERT INTO mfxl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Neenii ubba baz erizana nuunii yhatti eriza; ma nena oonkka oyicod garkk neenii koyooya. Yeyi nuna neenii Xoossapp kiitintteez as maaqqeezay ammanthiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeezin, Yesuusa mahii unttiko, «Yhatti ammaninnee? ");
INSERT INTO mfxl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yeezako, yi, yi kara laalinttiz wodaynnee ta ubbas olii ashii qosinttiza woday ye7oda; yhattekka yi7ii helleeza. Zin Aday taar yeza gishos ta ta aadda baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yi taar yeziko saro yinttis yezoday garkk taanii yeya odeeza. Alamel yezitar yi metinttoda. Zin miinggoytta; taanii alama gameeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuusa yeya odeezaypp guye pude salo bi7ii, yhay garkk yeegeeza: «Adayyo, saatay helleeza; ne Na7ay nena bonchchod garkk neenii ne Na7a bonchchoba. ");
INSERT INTO mfxl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Neenii ezis inggeez ubbayis E medhinas de7o immadaygarkk as ubbayil afa ezisi mawute inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Medhina de7o, nena, pettii tuma Xoossannee ne kiitteez Yesuus Kiristtoosa ero. ");
INSERT INTO mfxl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne ta oothod garkk inggeez oosa polii nena sa7all bonchcheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yhattekka, Adayyo, alame medhinttodaypp tiina ne kale taas yez bonchchayir tana bonchchoba. ");
INSERT INTO mfxl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Alame asaypp neenii taasi inggeezita nena eriseeza. Unttii neesita; neenii unttan taas inggeeza. Unttii ne qaalayiskka kiittintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Neenii taasi inggeez ubba baz neeppi ye7eezana unttii yhatti eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neenii taasi inggeez qaala taanii unttis inggeeza; unttikka ye qaala ekkeeza. Taanii ne lanqqepp ye7eezay tuma maaqqizana erii neenii tana azazeezanakka ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Taanii unttis woossiza. U neesita maaqqeez gishos neenii taas inggeez asayis woossizaypp attin alamayis woossaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taas yeza ubbabazay nebaz; nees yez ubbitaykka tabaz. Taanii u baggar bonchchintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taanii yhaypp guye alamel yezaamii; unttii alamel yeza. Taanii yhatti neeko yhanigiza. Geeshsh Adayyo, yha neenii taas inggeezitay neerannee taara petto maaqqeezaygarkk unttii petto maaqqad garkk unttan ne taas inggeez ne sunthayir naagoba. ");
INSERT INTO mfxl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taanii unttar sa7all yezar, ne taas inggeez ne sunthay wolqqar unttan naageeza. Geeshsha Maxaafay geezay polinttod garkk dhabodayis beeziza athaypp attin unttapp hara oonkka dhabekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Yhatti ta neeko yhanigiza. Ta ufayssay u wozina gancce folo maaqqad garkk yhaya taanii alamel yezar odiza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taanii unttis ne qaala inggeeza. Taanii alamepp maaqqekkazay garkk, unttikka alamepp maaqqekka gishos alame unttan ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neenii iitapp unttan naagod garkkepp attin alamepp kessod garkk woossaamii. ");
INSERT INTO mfxl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taanii alamepp maaqqekkazay garkk unttikka alamepp baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neenii ne tumatithar unttan nebaz oothoba; ne qaalaykka tuma. ");
INSERT INTO mfxl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Neenii tana alame kiitteezay garkk taankka unttan alame azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma unttii tuma geeshsh maaqqad garkk taanii ta ubba u gishos tana ta geeshsh udiza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Taanii u aaddas baazin unttii qaala odin, tana ammanod asitayiskka woossiza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Unttii ubbitay petto maaqqad garkk taanii woossiza. Adayyo, ne taar yezay garkk, ma ta neer yezay garkk unttii nuur yezod garkk woossiza. Ye wode neennee tannee azazeezana alamay ammanoda. ");
INSERT INTO mfxl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neenne taanii petto maaqqeezay garkk, unttii petto maaqqad garkk, neenii tana bonchcheezay garkk, taankka unttan bonchcheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Taanii u gancce, neenii taar yezay garkk unttii folo petto maaqqad garkk nena woossiza. Yeykka, ne tana kiitteezanannee ne tana qadhdheez qadhayir unttan qadhdheezana alame erod garkke. ");
INSERT INTO mfxl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Adayyo, neenii taas inggeezitay taanii yeza aqo taar yezoday garkk koyiza. Alamay medhinttodaypp tiina neenii tana qadhdheez gishos taas inggeez ta bonchcha unttii be7ada. ");
INSERT INTO mfxl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Geeshshi Adayyo, alame nena erooya, zin taan nena eriza. Ma neenii tana azazeezana yhayttitay eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neenii tana siiqeez siiqqay unttar yezod garkk, ma taanii unttar maaqqad garkk, taanii ne suntha unttan eriseeza; tiinaskka erisoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuusa woosa wuurissezayppi guye fa tamaaritayir Qediroona loophpha piinggii, ye bessayid yez woyra gade gancce geleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuusa gaame wode fa tamaaritayir ezayid shiiqiza gishos Yesuusa aathii inggeez Yihuda ye aqat eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yeyi gishos, Yihuda paanoose, zhabbe, toorarannee gonddallera aykkeez gaame wotaaddarita, qeese halaqitayinnee Ferisaawe asay kiitteez Xoossa Keethi naagiz poolisita kaalethi ekkii, ye aqo yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuusa fana hellod haniza baz ubba erii, gaxa kezii, «Oona koyee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Unttii mahii, «Naazirete Yesuusa koyiza» yeegeeza. E mahii, «Tana» yeegeeza. Yesuusa aathii inggeez Yihuda ezayid unttar eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","E, «Tana» geez wode unttii guye shiiqii, fokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesuusa maakka, «Oona koyinnee?» yeegii oyceeza. Unttii, «Naazirete Yesuusa koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","E mahii, «Tana maaqqizana yinttis odeeza. Yikkee, yi tana koyiz baz maaqqeeko yhayttita dakkoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E yeya geezay, «Adayyo, neenii taasi inggezitaypp hara attozin pettaka dhabisekka» geez qaalay polinttod garkke. ");
INSERT INTO mfxl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoon Phixiroosas fa mashsha yeza mashsha shoddii qeese halaqa ayllayis ushachchi haytto, qadhi oleeza. Ye ayllay sunthay Malkkoosa. ");
INSERT INTO mfxl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuusa Phixiroosako, «Ne mashsha shookayid mahoba. Ta Aday taasi inggeez xuu7aypp ta uzhaama neesi aazinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ayihude wotaaddaritayir u halaqay Xoossa Keethi naagiz poolisitayira wolla Yesuusa aykkii acceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tiina Yesuusana Haannako kanggeeza. Haanna ye laythi qeese halaqa maaqqiz Qayyaafa bolle. ");
INSERT INTO mfxl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayyaafa, «Asii woya gishos pettii asii yhayqqiko lo77o» gi tiina Ayihuditana zoreezaya. ");
INSERT INTO mfxl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoon Phixiroosannee hara pettii tamaaray Yesuusa kaallii qitteeza. Qeese halaqay ye yhankko tamaara lo7ithii eriza. Yeyi gishos, E Yesuusar qeese halaqay zabba geleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Zin Phixiroosa baler gase pengel eqqeeza. Qeese halaqay eriza hara tamaaray bale kezii, penge naagiza asttis odin, Phixiroosa gelisseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Penge naagiz asita Phixiroosako, «Neenii, ye athay tamaaritaypp petta baasa?» yeegeeza. Phixiroosa mahii, «Wa77a, tana baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sa7ay meeggiza gishos ayllitayirannee naagizitay xiife tama eethii, marii eqqii kazhiza. Pheixiroosakka unttar eqqii tama kazhiza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Qeese halaqay Yesuusa, e tamaaritay baggannee e timirttay bagga oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuusa mahii, «Taanii asi ubbas geesha odeeza. Taanii Ayihude ubbitay shiiqiza Ayihuditay Woosa Keetha giddonnee Xoossa Keetha ubba wode taamarsseeza. Geema abikka odekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yeezin, neenii tana abis oyicce? Ta ododar si7eez asa oyccoba. Ye asay taanii odeezana eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuusa yeya geez wode ye bessayid eqqeez wotaaddaritaypp pettay Yesuusa baqqii, «Qeese halaqayis yhay garkk yeegii mahinnee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuusa mahii, «Taanii iitta baz odintteez maaqqiko markka ko7oba. Zin taanii turo odintteez maaqqiko tana abis baqqee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yeyi gishos, Haanna, Yesuusa aciniteezan garkk qeese halaqa Qayyaafako dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phixiroosa ezayid eqqii, tama kazhodar, atteez asay eziko, «Neenii yha athay tamaaritaypp petta baasa?» yeegeeza. Phixiroosa mahii, «Wa77a, taanii e tamaare baaya» yeegii kaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Qeese halaqay ayllitayippe pettay, Phixiroosa haya gacheez athay dabbay, Phixiroosako, «Taanii nena ezar atakilittay gancce be7ekkasanee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phixiroosa maakka kaddeeza. E yeya geezan garkk shugula uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wontta guura, unttii Yesuusana Qayyaafa karapp gade aqisizay ooso keetha kanggeeza. Ayihuditay Paaziqa Baale katha maadayis fana tunisaamay garkk gade aqisizay ooso keetha gelekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yeyi gishos, Philaaxoosa unttiko bale kezii, «Yha atha abis mootee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Unttii, «E iita oothekkabaz maaqqeezako nuunii eza neeko ke7aamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philaaxoosa mahii, «Yi eza ekkii kanggii, yi higgay gizay garkk ezal afa pirddoytta» yeegeeza. Ayihuditay, «Oonakka wodhiza mawute nuus baaya» yeegeeza; ");
INSERT INTO mfxl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yeyi haneezay Yesuusa abigarkk yhayiqo yhayqqodazako erisodayis odeez qaalay polinttodayisii. ");
INSERT INTO mfxl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philaaxoosa fa ooso keetha maaqqii gelii, Yesuusa xeegii, «Neenii Ayihude kaato?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuusa Philaaxoosako, «Yha oyicha neenii neepp oyicinennee woy hara asii nees tabaz odeennee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philaaxoosa mahii, «Ta Ayihude aso? Ne asayira qeese halaqitay nena taasi aathii inggeeza. Ne abi ootheenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuusa, «Ta kaatetithay yha alamayid baaya. E yhaydda maaqqeezako ta Ayihuditay halaqitayis aadhii ingginttod garkk ta ayllitay taasi olinttoda. Zin ta kaatetithay yha alamayid baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yeyi gishos, Philaaxoosa Yesuusako, «Yeezin, neenii kaatonnee?» yeegii oyceeza. Yesuusa mahii, «Tuma ta kaate maaqqizana ne geeza. Taanii yelintteezaynnee yha alame ye7eezay tumatithis markkattodayis. Tuma bagga maaqqeez oonkka taanii giza si7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philaaxoosa, «Tuma aba bazo?» yeegeeza. Philaaxoosa yeya geezaypp guye Ayihuditayiko bale kezii, «Taanii eepp aba iitakka denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Zin Paaziqa Baale gallas, pettii asii yinttis achchapp bili7iz woga yeza. Taanii yinttis Ayihuditay kaata billod garkk koyinnee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Unttii mahii, fa qaala dhoqi udii, «Baribaana billobapp attin eza baaya» yeegeeza. Zin Baribaana paanno. ");
INSERT INTO mfxl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yeypp guye, Philaaxoosa Yesuusana garafiseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wotaaddaritay anggunthi zawude medhdhii e ommayil gaddeeza. Ma zoqo afila eza ma7iseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eziko shiiqii, «Ayihude kaatayyo, medhinas kawutoba» yeegii eza baqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philaaxoosa maakka bale kezii, Ayihuditayiko, «Yeezako, taanii eepp aba iitakka denggekaaza yi erod garkk eza yinttiko bale kessoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yeypp guye, Yesuusa anggunthi zawude fa ommal gaddii, zoqo afila ma77ii, bale kezeeza. Philaaxoosa Ayihuditayiko, «Atha yhaya bo7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Qeese halaqitayinnee Xoossa Keethi naagizitay eza be7eez wode fa qaala dhoqi uddii, «Mazqalel afa sottoba! sottoba!» yeegeeza. Philaaxoosa unttiko, «Yi eza kanggii, mazqalel afa sottoytta. Taanii eepp aba iitakka denggekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayihuditay mahii, «Nuus higgay yeza. E fana Xooss na7a ootheez gishos nu higgay garkk E yhayqqodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philaaxoosa yeya si7eez wode tiinaasaypp iita yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Maakka Philaaxoosa fa ooso keethi maaqqii gelii Yesuusako, «Neenii anapp ye7eenee?» yeegii oyceeza. Zin Yesuusa ezisi abikka mahekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yeyi gishos, Philaaxoosa, «Taas odoosa? Nena billodayis woy mazqalel afa sottodayis taasi mawute yezana eroosa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuusa, «Xoossay nees silixannee inggekkabaz maaqqeezako taal afa silixxaanee nees baabonazin. Yeyi gishos, tana nees aathii inggeezay aadhiz nagara ootheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philaaxoosa yeya si7eez wode Yesuusa billodayis oge koyeeza. Zin Ayihuditay fa qaala dhoqi uddii, «Neenii eza billizbaz maaqqiko Kaattay Qeesare bagga baaya. Fana kaate giz oonkka Qeesaares morkke» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philaaxoosa yeya si7ii Yesuusa bale kesseeza. Yeezii, «Lochche Shuchchi» yeegiz bees pirdde oydel betteeza. Ibraysxe qaalayir ye aqay «Gebeta» guussii. ");
INSERT INTO mfxl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ye gallasay Paaziqa Baale bonchchodayis giigintto gallas. Ye wode sa7a usuppun saate heera. Philaaxoosa Ayihuditayiko, «Yi kaata yhaya bo7oytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ayihuditay fa qaala dhoqi udii, «Dhabisoba! Dhabisoba! Mazqalel afa sottoba» yeegeeza. Philaaxoosa mahii, «Yi kaata taanii mazqalel afa sottodayis koyinee?» yeegii oyceeza. Qeese halaqitay, «Qeesarepp hara kaati nuus baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yeypp guye, unttii Yesuusa mazqalel afa sottod garkk Philaaxoosa unttis aathii inggeeza. Unttii Yesuusa aykkii kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuusa fa mazqala tookkii, «Omma ota» giz aqo yhanigeeza. «Omma ota» guussay Ibrayisxe qaalayir «Golggotta» guusii. ");
INSERT INTO mfxl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Unttii ye aqayid mazqalel afa Yesuusa sotteeza. Ma ezar hara nam7i asita, petta gede baggar yhankka yhana baggar mazqalel afa sotteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philaaxoosa, «Ayihuditay Kaati, Naazirete Yesuusa» yeegizi xuufe xaaffii mazqalel afa gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuusa mazqalel afa sotintteez aqay katamas kale yez gishos gaame Ayihuditay ye xuufa nabbabeeza. Xuufay xaafintteezay Ibrayisxxe doonar, Laatinee doonarannee Girike doonara. ");
INSERT INTO mfxl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yeyi gishos, qeese halaqitay Philaaxoosako, «‹Yha athay fana Ayihude kaati yeegeeza› gi xaafobapp attin ‹Ayihude kaati› gi xaafippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yeezin, Philaaxoosa, «Ta xaafeezana xaafeeza» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wotaaddaritay mazqalel afa eza sotteezaypp guye e afila ekkii, oyddii aqo wolla qoo7inttii, petto petto ekkeeza. E afar olii ma77iza adusse afila ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wotaaddaritay, «Oona hellodazako, ixxa olodaypp attin afila per7aamii» yeegeeza. Yeyi haneezay geeshsha Maxaafayid, «Ta afila shaakkii ekkeeza; ta adusse afila gujjikka ixxa oleeza» ginttinttizay polinttodgarkke. Yeyi gishos, wotaadderitay yeya ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zin Yesuusa mazqale kale e indat, e indat mishshiti, Qeliyoophe machchat Mayiramira Magdeela Mayrama eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuusa fa indatinnee E qaadhiza tamaaray ezayid eqqeezita bi7ii, fa indatiko, «Ta indatee, ne na7a yhaya bo7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yeypp guye, ye tamaarayiko, «Ne inidat yhanno bo7oba» yeegeeza. Ye tamaaray izo ye wodepp aykkii fa kara kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yeypp guye, Yesuusa ubbay yhatti polintteezana erii, geeshsha Maxaafayid xaafintteezay polinttod garkk «Tana saamiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ye aqayid pettii xugga kunithi caala woyne yeza. Unttii zanza ye woynayid olii, hisophe mithii xeeral gaddii, Yesuusa doonayiko shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuusa woyna ganxxii bi7ii, «Polintteeza» yeegeeza. Yeypp guye, fa morga ziqqi udii fa shemppa inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ye gallas giigintto gallas maaqqiz gishonnee wonttitha gallasay bonchcho maala maaqqiz gishos asay ahay mazqalel afa maala gallas peezhaamgarkk unttan toka menithii, mazqalaypp wodhisoday garkk Ayihuditay Philaaxoosa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yeyi gishos, wotaaddaritay yhanigii, Yesuusar sotintteez nam7i asay toka mentheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Zin Yesuusako ye7eez wode E yhayqqeeza bi7ii, e toka menthekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Zin wotaaddaritaypp pettay Ea miyya toorar caddin elle suuthinnee haathii goggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yi ammanod garkk yeya be7eezay markkatteeza. E markkatithaykka tuma. Ma yeypp E oosa odizay tuma maaqqeeza eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yeyi haneezay geeshsha Maxaafay, «E meqethitaypp pettii bazikka meqqenna» geezay polinttod garkke. ");
INSERT INTO mfxl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Maakka geeshsha Maxaafay hara aqa, «Unttikka fa caddeezana be7ada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yeypp guye, Armataasa gizi katamapp ye7eez Yooseefa Yesuusa aha ekkodayis Philaaxoosa woosseeza. Yooseefa Ayihuditayis yashitteez gishos qosor Yesuusa kaalliza. Philaaxoosa, «Ekkoba» yeegeeza. Yeyi gishos, Yooseefa shiiqii Yesuusa aha ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma yeypp Niqodimoosa, yhaypp tiin Yesuusako qamma ye7eezay, karbbennee godare uuthara walakintteez pettii kilo giraame maaqqiz shitto ekkii Yooseefar wolla ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ye nam77ii asitay Yesuus aha ekkii, Ayihuditay aha ziidhith wogar, shittora, moogo afilar sawaxeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuusa sotintteez aqay atakiltte gade. Ye atakiltte gancce shuchchip woocintti giigeez tiina oonkka mooginttekka oroth duufay yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ye duufay lanqqe yez gishonnee Ayihuditay maalas giiginttiza gallas maaqqeez gishos Yesuusa aha moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ya Saaminttatis tiina gallas sa7a geezhekkazin, Magdeela Mayrama, Yesuusa moogintteez duufayiko yhanigii shuchchay ye duufay doonaypp hali7eezana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Simoon Phixiroosakonnee Yesuusa qadhdhiza yhankko tamaarayiko woxxii yhanigii, «Duufaypp Goda ekkii dhabeeza; eza aba gaddeezako nu erooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yeyi gishos, Phixiroosannee yhankko tamaaray kezii duufo yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nam7itaykka wolla woxxeeza; zin yhankko tamaaray Phixiroosapp aadhii tiinattii duufo helleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ye tamaaray zuggii, moogo afila be7eeza, zin duufo gancce wodhdhekaya. ");
INSERT INTO mfxl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoon Phixiroosa eza kaallii yi7ii, duufo wodhdhii moogo afilay ezayid yezana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma Yesuusa ommas xaaxintteez afilay dakinthinttii duma pettii aqo yezana be7eeza. Ye afilay duma yezaypp attin moogo afilayir wolla baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ye wode tiinattii duufo helleez yhankko tamaaray gelii bi7ii ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesuusa yhayiqopp denddo beezizana odiza geeshsha maxxaafe qaala unttii haga akaakekaya. ");
INSERT INTO mfxl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yeypp guye, e tamaaritay fa kara maaqqii yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Zin Mayrama ye duufay doonayid eqqii yeekkittar zuggii duufay gancce be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Boothi afila ma77eez nam77ii kiitanchchitay Yesuusa ahay woyi7eez aqayid pettay omma achchara yhankkay toke achchara betteezita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Unttii iiko, «Yhan astte, abis yeekkee?» yeegii oyiceeza. Iza, «Unttii ta Goda ekkii dhabeeza; unttii aba gaddeezako taanii erooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yeya geezaypp guye, izakka guye maaqqii be7adar Yesuusa ezayid eqqeezana be7eeza. Zin E Yesuusa maaqqeezana erekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuusa iziko, «Yhan astte, abis yeekkee? Oona koyee?» yeegii oyceeza. Mayrama atakiltte naagiza asii aazin, «Godayyo, ne ekkeezibaz maaqqiko, eza aba gaddeezako taasi odooye. Taanii eza ekkoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuusa iziko, «Mayrame» yeegeeza. Iza eziko mahii, Ibraysxe doonar «Rebuunii» yeegeeza. Yeyis birshshithay «Asitamaarayyo» guusii. ");
INSERT INTO mfxl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuusa iziko, «Taanii haga ta Adayko yhanigekka gishos tana aykkii ashshodayis koyppe. Zin ta ishitayko yhanigii, ‹Taanii ta Adayikora yi Adayiko, ta Xoossayikora yi Xoossayiko, yhammada geeza› gi unttisi odoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdeela Mayrama Goda be7eezanannee izis yeya E odeezana yhanigii e tamaaritayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Saaminttaypp tiina gallas omarsse, e tamaaritay Ayihuditayis yashittii ibithi gorddii shiiqii betteezin, Yesuusa yi7ii, u gancce eqqii, «Saro yinttis maaqqo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yeya gi maaqqii fa kushannee fa miya unttan beezeeza. E tamaaritay Goda bi7ii gaame ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuusa mahii unttiko, «Saro yinttis maaqqo; ta Aday tana kiitteezaygarkk taankka yinttan kiittiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yeya geezaypp guye, unttal afa ufi gi puggeeza. Ma, «geeshsha Ayyana ekkoytta. ");
INSERT INTO mfxl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yinttii atto geez asay nagaray atto ginttinttoda. Yi atto geekkazittayis nagaray atto giinttinttaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Zin taphpho nam77ii tamaaritaypp pettay, Didimoosa ginttinttiz Toomaasa, Yesuusa ye7eez wode unttar baaya. ");
INSERT INTO mfxl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yeyi gishos, yhankko e tamaaritay Toomaasakko, «Nuunii Goda be7eeza» yeegeeza. Zin Toomaasa unttiko, «Misimarer E cadintteez e kushayid yez beeta be7ekkazar ye beeta ta biradhdher bochchekazar, ma ta kusha e miyayid dakkii be7ekkazar ammanaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Saaminttapp guye, Yesuusa tamaaritay maakka kara shiiqii betteeza; Toomaasakka unttar yeza. Ibithii gorddinttii yeezin Yesuusa yi7ii, u gancce eqqii, «Saro yinttis maaqqo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yeypp guye, Yesuusa Toomaasako, «Ta kusha ne biradhdher bochchii bo7oba. Ma ne kusha ta miyayid dakkii bo7oba; sidhippe, ammanoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasa mahii, «Ta Godayyo, ta Xoossayo» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeezin Yesuusa, «Neenii tana be7eez gishos ammaneeza, zin tana be7ekkazar ammaneezitay anjjintteezita» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuusa yha maxaafay gancce xaafintteez baz hara gaame malita fa tamaaritay tiina ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Zin Yesuusa E Kiristtoosa, Xoossa Na7a maaqqizana yi ammanod garkk ammanii e sunthayir de7o demmaday garkk yhayi xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yeypp guye, Yesuusa Xibaaroosa Abba kale fa tamaaritayis maaqqii bentteeza. E unttis yhaypp kaallii yez hanor benteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoon Phixiroosa, Didimoosa ginttinttiz Toomaasa, Qaana Galilap ye7eez Naatina7eela, Zabidoosa na7itayinnee Yesuusa tamaaritaypp hara nam7itay wolla yeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoon Phixiroosa unttiko, «Taanii molo aykkodayis yhanigiza» yeegeeza. Unttii, «Nuukka neer yhammada» yeegii, wogolo gancce geleeza. Zin unttii ye qamma aba molokka aykkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wontta guura xalqqe dolodayipp tiina, Yesuusa abba gaxa eqqeeza, zin e tamaaritay Yesuusa maaqqeezana erbe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuusa unttiko, «Ta laggitayyo, molo aykkekasa?» yeegeeza. Unttii mahii, «Akkokka aykkekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E mahii, «Yi gita wogolaypp ushachchi baggar oloytta; yi molo aykkoda» yeegeeza. Yeyi gishos, unttii gita ushachchi baggar oleeza. Molay gaanggeez gishos goochchii kessodayis gammintteeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesuusa qaadhiza tamaaray Phixiroosako, «Yhayi Goda bayi!» yeegeeza. Simoon Phixiroosa E geezana si7ii kallo yez gishos fa afila ma77ii abba giddo guppii gelleeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Zin wogolo giddo atteez yhankko tamaaritay molo kumeez gita goochchii, abbapi gaxa kezeeza. U abbapi nam77ii xeet yhadhay garkk haakkiza zini. ");
INSERT INTO mfxl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Unttii abbapp gaxa kezeez wode xiife qaaqar molo yezannee soollo be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuusa unttiko, «Yhatti yi aykkeez molaypp xiqqa yhana inggoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoon Phixiroosa wogolite gelii, xeeti ishatammannee hayidzii dammo molitay kumeez gita goochchii abbapp gaxa kessezza. Molay yey garkk gaame maaqqikonnee gitay feedhdhinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuusa unttiko, «Yhana yi7ii moytta» yeegeeza. E Goda maaqqeezana unttii ereez gishos e tamaaritaypp pettayika, «Neenii oonoo?» gi eza oyicodayis yibatteezay baaya. E Goda maaqqeezana ubbitay ereeza ");
INSERT INTO mfxl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuusa yi7ii, soollo ekkii unttisi inggeeza; molakka yhay garkk inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuusa yhayiqopp denddii fa tamaaritayis benttodar yhayi hayidzantho. ");
INSERT INTO mfxl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","U meezaypp guye, Yesuusa Simoon Phixiroosako, «Yoona na7a Simoona, tana yhayttitaypp aathii qadhinnee?» yeegeeza. Simoon Phixiroosa, «Ee Godayyo, taanii nena qadhdhizana ne eriza» yeegeeza. Yesuusa eziko, «Ta dur na7unthan heenggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuusa nam7antho, «Yoona na7a Simoona, tana qadhdhinee?» yeegeeza. Simoon Phixiroosa, «Ee Godayyo, taanii nena qadhdhizana ne eriza» yeegeeza. Yesuusa, «Ta hooggita heenggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuusa hayidzantho, «Yoona na7ayyo Simoona, tana qadhdhinee?» yeegeeza. Yesuusa hayidzantho Simoon Phixiroosako, «Tana qadhdhinee?» yeegii oycceez gishos Phixiroosa azzanii, «Godayyo, neenii ubba baz eriza; taanii nena qadhdhizana ne eriza» yeegeeza. Yesuusa, «Ta durita heenggoba. ");
INSERT INTO mfxl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Taanii nees turo odiza; neenii na7atithar yez wode ne aaddas danccinttii, ne kozheez bessi yhanigiza. Zin ne cimeez wode ne kusha miccii beezoda. Haray danccisoda; ne aqo bessi kanggoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuusa yeya Phixiroosa ab garkk yhayiqo yhayqqii, Xoossa bonchchisodazikko erisodayis geeza. Yeya geezaypp guye, Yesuusa Phixiroosako, «Tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phixiroosa guye maaqqii, Yesuusa qaadhiza tamaaray faapi guyer yi7izana be7eeza. Ye tamaaray, kaho miiz aqo Yesuusako shiiqii, «Godayyo, nena aathii immaday oonoo?» geezana. ");
INSERT INTO mfxl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phixiroosa ye tamaara bi7ii, «Godayyo, yha athay ma wayadee?» yeegii Yesuusa oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuusa eziko, «Taanii ye7oda hellodayis E shemppor yezod garkk taanii koyko, yeyi nena abi metenee? Neenii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yeyi gishos, ye tamaaray yhayqqaam giz oday e ishita ubbita helleeza. Zin Yesuusa, «Taanii ye7od gatho, E yezod garkk taanii koyko nena abi metenee?» yegeezaypp attin «Yhayqqenna» geekkaya. ");
INSERT INTO mfxl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yha oday bagga markkattezaynne yhaya xaafeezay ye tamaara. E markkatithay tuma maaqqizana nuunii eriza. ");
INSERT INTO mfxl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuusa ootheez hara gaame baz yeza. Ta qoppin, ubba baz ommar ommar xaafintteezako, xaafinttiza maxaafitayis kunithi alamay gidodibaz aazooya.");
INSERT INTO mfxl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tewofiloosa, Yesuusa fa oosa aykkeez wodepp salo yhanigeez gallas hellodayis, ootheezibazinnee tamaarsseezibaz ubba taanii ta tiina maxaafayid xaafeeza. Salo yhanigodaypp tiina E fa dooreez hawaarita Geeshsha Ayyanar azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","E fa iita waaya ekkeezaypp guye yhayiqopp denddeezana gaame markkatithar sidhe baazin qonccisii unttis fana beezeeza. Oyttam gallas unttis qonccii Xooss kaatetithibagga unttan taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pettii wode unttara wolla yezar unttan yhayigarkk yeegii azazeeza: «Ta yinttis odeeza, ta Aday immad geez ufayss qaala naagoyttapp attin Yeruselaamepp kezippate. ");
INSERT INTO mfxl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Abis giiko, Waannisa haathar xammaqqeeza, zin xiqqa wodepp guye Geeshsha Ayyanar yi xammaqinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hawaaritay Yesuusana hellii eeko, «Godayyo, Isra7eelitayis ne kaatetitha mahiz woday yhayanee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuusa unttiko, «Ta Aday fa mawuter oothiza wodannee laytha yi erodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Zini Geeshsha Ayyanay yinttal afa wodhdhiz wode yi wolqqa ekkoda. Yeypp, guye Yerusalaame, Yihuda gade ubbayil, Samaarerannee biitta gaxapp gaxa hellodayis yi taas markkita maaqqoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yeya geezaypp guye unttii be7adar, dhoqq dhoqq gi, salo kezin shaarakka eza u aafaypp geentheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesuusa yhammadar unttii salo fude be7adar, booth ma7o ma77eez nam77ii asitay qopekkazin u achch baggayir eqqii, ");
INSERT INTO mfxl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Galila asayyo, salo bi7ittar, yi abis eqqeenee? Yha yi be7adar salo qiteez Yesuusa yhannii garkk maaqqii ye7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yeypp guye, hawaaritay Dabire zayite Ambalapp Yerusalaame maaqqeeza. Dabire zayite Ambay Yerusalaamepp maala gallasa yedhith garkk haakiza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Unttii Yerusalaame gelii, fooqeel afa kezeeza. Unttikka: Phixiroosa, Waannisa, Yayqqooba, Indiraase, Filphoosa, Toomaasa, Barttolomoosa, Maatoosa, Ilfoosa na7a Yayqqooba, Qanataza Simoonannee Yayqqooba na7a Yihuda. ");
INSERT INTO mfxl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yhayttitay ubbay maachchitayr, Yesuusa indat Maaramirannee Yesuusa ishitayira ubbay pettii wozinar maaqqii ubba wode miinggii woossiza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ye wode Phixiroosa xeetannee laatam maaqqiz ammaniza asay shiiqeez aqo denddii eqqii, yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ta ishuntho, Yesuusana aykkeezita kaalitheez Yihuda bagga Geeshsha Ayyanay tiina Dawute doonar odeez Xooss qaalay polinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yihuda nuur wolla yha oosa oothodayis maraxintteez asii.» ");
INSERT INTO mfxl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Zin Yihuda iita oosor denggeez miishayir gade wonggeeza. E sinor pokkin, e ulay peedhinttin; e maracay zazintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yihudal afa haneezibaza Yerusalaame yez as ubbay si7eeza. Yey gishos, ye gada fa gada doonar «Akalddaama» geeza. Akelddaama guusay Suuth biitta guussii. ");
INSERT INTO mfxl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Yeykka mazmuure maxaafayid, «‹E karay kallo atto; oonkka ezayid yezippee. Ma e shuumatitha haray ekko› ginttinttii xaafintteeza.» ");
INSERT INTO mfxl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Yey gishos, Goda Yesuusa nu gancce yezeez wode ubbayid nuur yezitayppe, ");
INSERT INTO mfxl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ma Xammaqiza Waannisa wodaypp aykkii Goda Yesuusa salo yhanigeez gallas hellodayis nuur yezitaypp pettii asii e denddayis nuur markka maaqqodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yey gishos, asay doorodayis Yosixoosa giz Barssabaasa ginttinttiza Yooseefannee Maataasa nam7ita shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yeypp guye, Xooss woossittar, «As ubba wozina eriza Godayyo, yha nam7itaypp ne oona dooreezako nuna beezoba. ");
INSERT INTO mfxl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yihuda fa aqa qitii, ashsheez oosannee hawaaretith oosa ekkoday garkk yhayttitaypp nuna beezoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Unttal afa ixa olin Ixay Maataasal afa wodhdhin Maataasa taphpho pettii hawaaritayll afa guzhintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Phenxeqosxe giz gallasay helleez wode ammaniza as ubbay pettii aqo shiiqii yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Qoppekkazin wolqqama gote garkk guummiz guumthay salopp yi7ii unttii yez keetha kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tama lath aaziz iranthitay unttis benttittar, shaginttii shaginttii unttal ubbayil afa beteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Unttii ubbay Geeshsha Ayyanar kumii duma duma doonar odinttoday garkk Geeshsha Ayyanay unttan udin odintto aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ye wode biitta ubbapp ye7eez Xoossis yashittiz Ayihuditay Yerusalaame yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ye guumtha si7ii gaame asay shiiqeeza. Ammaniza asay u gade doonar odinttodar si7eez gishos ");
INSERT INTO mfxl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","yhay malabaz gi, «Yha odinttiza as ubbay Galila as baasa? ");
INSERT INTO mfxl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yeezin, nuunii, nu yelintteez biitta doonar unttii odinttodar wayizii si7odayis danda7eenee? ");
INSERT INTO mfxl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nuunii Pharixe, Meede, Elaame, Mesophotaame yezitay, Yihuda, Qaphadooqa, Phanxoosa, Iisiya, ");
INSERT INTO mfxl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phirge, Phinfile, Gibxxe, Qaarina achcha yez Liiba yezita. Nuupp baggityikka Oroomepp ye7eez asita. ");
INSERT INTO mfxl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayihuditaynnee Ayihudetitha ammano geleez asitay, Qarxeesannee Arabe asitay, Xoossii ootheez gita oosa nu qaalayir ododar si7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ubbay malabaz gi, godibaz dhabin woliko, «Yhayi ab maaqqodeshsha?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Zin yhankkitay, «Yeyititay uzhii matheembay» yeegii unttal ari7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Zini Phixiroosa, taphpho pettii hawaaritayira denddii eqqii, fa qaala dhoqq udii, unttiko yhay garkk yeegii odeeza: «Ayihuditayyo, Yerusalaame yez ubbitayo, taanii odiza si7oytta. ");
INSERT INTO mfxl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wonttapp hayidzii saate maaqqeez gishos yi qoppizay garkk yha asitay mathekkaya; yey yinttis erintto. ");
INSERT INTO mfxl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Zin yhay haneezay nabe Iyu7eela odeezay polinttoday garkkes ");
INSERT INTO mfxl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«‹Xoossii, wode wurssitha yhay garkk hanoda yeegiza: taanii as ubbayil afa ta Ayyana gogisoda. Yi dhiirath na7itaynnee maachch na7itay, tinbbite ododa. Yi paanthitay qonccith be7ada; yi cimitay ahumo ahumoda. ");
INSERT INTO mfxl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ye gallasitayid tana ammaniza dhiirathi ayllitayil afannee maachch ayllitayil afa taanii ta Ayyana gogisoda; unttii tinbbite ododa. ");
INSERT INTO mfxl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma taanii afa salor oroth baz, oommo sa7arakka malla beezoda. Suuthii, tamannee wolqqama cuya fuullo benttoda. ");
INSERT INTO mfxl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gitannee bonchcho maaqqeez Goday gallasay hellodaypp tiina awa dhumoda; aginakka suuthii aazoda. ");
INSERT INTO mfxl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ye wode yhay garkk hanoda; Goday sunth xeegiz oonkka attoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Isreele asayyo, yha qaala si7oytta. Naazirete Yesuusa oonatithay, Xoossii yi gancce ootheez wolqqama oosayirannee malatitayir yinttis qoncciza yi, yi ubbas eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xooss tiina fa erarannee fa shenayir Yesuusa yinttis aadhii inggintteeza. Yi eza higge baa asitay kusher mazqalel afa sottis yi wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Zin Xooss yhayiqo wolqqa dhabisii eza dentheeza. Yey gishos, yhayiqo eza aykkodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawute ebagga odittar, «‹Taanii dagammaamay garkk, Goday ta ushachcha yeza. Goda ubba wode ta ta tiina bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yey gishos, ta wozinay ufaytteeza; ta doonay ufayssar kumeeza; yhayqqiz ta asetithay ufayisar yezoda. ");
INSERT INTO mfxl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Abis giiko, ta shemppa Si7oole ashshaamii. Ma ne Xillay aha wooqqithaami. ");
INSERT INTO mfxl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Neenii tana de7o oga eriseeza. Ne taar yezay gishos ta ufayssay kunith maaqqiza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ta ishuntho, nu ada Dawute bagga ta yinttis geeshshii ododa. Dawute yhayqqii moogintteeza; e duufay yhayino hellodayis nu kale yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawute nabe maaqqeez gishos Xooss e sheeshaypp petta e kaatetitha zufaanayil afa betithodayis ees caaqqeez caaqa eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yeyi gishos, Kiristtoosa dendda tiina bi7ii, ‹E shemppay Si7oole attekkaya; e asetithaykka wooqqekkaya› gi odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Xoossii, yha Yesuusa yhayiqoypp dentheezayis nuunii ubbay markka. ");
INSERT INTO mfxl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yey gishos, Xoossii fa ushachcha eza dhoqq dhoqq udii, ees inggod ginttintteez Geeshsha Ayyanay ufayisa fa Xooss Adaypp ekkii, yhaya yi yhatti bi7izannee si7iza nuul afa gogiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Yeykka, Dawute fa ommas salo yhangekkaya zin: «‹Goday, ta Goda, «Taanii ne morkkita ne tokes yedhdhith aqo udod hellodayis yhaydda taapp ushachch bagga bettoba geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Yey gishos, yha yi mazqalel afa sotteez Yesuusa, Xoossii eza Godannee Kiristtoosa maheezana Isreele as ubbay tumapp ero» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asay Phixiroosa geeza si7in u wozinay bochinttin Phixiroosannee yhankko hawaaritayko, «Nu Ishuntho, yeezin nuunii ab udo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phixiroosa unttiko, «Yi nagaray atto ginttinttoday garkk nagaraypp maaqqii, yi pettay pettay Yesuus Kiristtoosa sunthar xammaqinttoytta. Xooss inggiza Geeshsha Ayyana yi ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yeykka Xoossii inggod geez ufayss qaalay yinttisii, yi na7itayisinnee Goday nu Xoossay faak xeegiz haakko yez ubbitayis» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phixiroosa unttis hara qaalakka gujjii markkattii, «Yha wode zhuca asayil afa ye7odayis yez pirddaypp yinttan ashshoytta» yeegii zoreeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Phixiroosa odeezana ekkeezitay xammaqintteeza. Ye gallas hayidzii mukule maaqqiz asay ammanii gujintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Unttii hawaaritay timirttayid, pettipettithar, katha wolla muusarannee Xooss woosar miinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hawaaritay kushe gaame oorothibazinnee malabaz haneezay gishos as ubbay yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ammaneez ubbitay wolla yeziza; paas yeza baz ubba pettipp shagintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Unttii paas yeza baz bayizii miishe pettayis pettayis koshshizay garkk shagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ubba gallas pettii wozinar maaqqii Xooss kara shiiqiza. Fa kara pettay petta xeegii ufayssarannee ashikke wozinar katha miiza. ");
INSERT INTO mfxl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xooss galatittar as ubbayir sabintteeza. Goday ammanii attizita gallas gallas unttal afa gujjiza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pettii gallas Phixiroosannee Waannisa Xooss woossodayis uddufun saater Xooss Kara yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yelintteez gallasapp aykkii toke sileez pettii athay Xooss kara geliza asaypp miishe woossoday garkk ubba wode lo77o giz Xooss kara penge gallas gallas ki7ii gaddizazin. ");
INSERT INTO mfxl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ye toke sileez athay Phixiroosannee Waannisa Xooss Kara gelod hanodar bi7ii unttan miishe woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Unttikka eza dakkii bi7ii, Phixiroosa «Nuuko yhana bo7oba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Toke sila athay unttapp akko baz demmada aazin unttan be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Zin Phixiroosa eziko, «Taas birannee worqqa baaya, zin taas yeza baz ta nees immada. Naazirete Yesuus Kiristtoosa sunthar denddii yedhdhoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yeypp guye, sila athayis ushachch kusha aykkii dentheeza. Ellisii e tokaynnee qilccay miinggii atteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Athay guppii denddii eqqeeza. Gedennee yhana yeth aykkeeza. Yeypp guye, yedhdhitarannee, guppitar Xooss galatittar unttar wolla Xooss Kara geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","E yedhdhodarannee Xooss galatodar asii ubbay eza be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Be7eez ubbitaykka miishe woossodayis lo77o giz Xooss Kara pengel betteezay eza maaqqeeza ereeza; E haneezibaza bi7ii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Athay Phixiroosappennee Waannisapp duuxaam gi aykkii yezin asii ubbay malabaz gi, Solomone barandda giz aqo wolla unttiko woxxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phixiroosa asa bi7ii asayiko, «Isreele asayyo, abis yhaya malabaz gee? Woy abis nuna dakkii be7ee? Nuunii nu wolqqar woy nu Xooss lo7ottithayir yha atha yetheezibaz yinttis aazinee? ");
INSERT INTO mfxl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Afraame, Isaaqa, Yayqqooba Xoossay, nu aditay Xoossay, fa na7a Yesuusa boncheeza. Zin yi yhayiqos aathii inggeeza Philaaxoosa bili7odayis koykokka yi e tiina, ‹Nuunii eza koyooya› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yi geeshshannee xilla, kaddii, shemppo wodheeza yinttis billoday garkk Philaaxoosa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De7o inggiza yi wodheeza, zin Xoossii yhayiqopp eza dentheeza. Yeyis nuunii markka. ");
INSERT INTO mfxl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yha yi bi7izaynnee eriza asay paxii minggeezay Yesuusa sunthar ammaneez gisho. Yha yi ubbay tiina eza yhay garkk patheezay E Yesuusa ammaneez gishosi. ");
INSERT INTO mfxl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Yhattekka ta ishuntho, yinttikka yinttan kalithizitaykka, erekkazar ootheezana taanii eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Zin Xoossii binii nabitay ubba doonar, ‹Kiristtoosa waaye ekkodayis beeziza› yeegeeza polinttoday garkk udeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yikkee, Xoossii yi nagara atto goday garkk maarototh gelii Godayiko maaqqoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Goday kalepp minthatho wode yinttis ye7oda. Goday tiinatii dooreez Kiristtoosa yinttis dakkoda. ");
INSERT INTO mfxl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xoossii fa geesh nabitay doonar binii odeezay garkk ubba baz oroxxiza wode hellodayis yha Yesuusa salo gam7odayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muse, ‹Goda Xoossay tana dentheezay garkk yi ganccepp yinttis nabe denthoda. Yi E giza ubba si7oytta. ");
INSERT INTO mfxl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ye nabay oda si7oowa as oonkka as ganccepp shaakinttii dhabo› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Ma Saami7eelapp aykkii yez nabitay ubbitay yha wode bagga odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yi nabitay na7ita; ma Xoossii Afraames, ‹Sa7all yez as ubba taanii ne sheeshay baggar anjjoda› yeegii nu aditayis geleez qaala caaqo laattiza na7ita. ");
INSERT INTO mfxl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Xooss yinttan ubba yi iita ogaypp mahii anjjoday garkk fa na7a denthii yinttis tiina dakkeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phixiroosannee Waannisa asayis ododar qeesitay, Xooss kara naagizitay halaqaynnee Saduqaawitay unttiko ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Unttii Yesuusa yhayiqopp dendeezannee yeypp denddeezayid yhayiqopp denddo yezana woya taamarsseez gishos yiloteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yey gisho, unttan aykkii sa7a omatheezaypp wonttod hellodayis achch kara gelseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Zin qaala si7eezitaypp gaamitay ammaneeza. Ammaneez dhiirath asay taybay ichchin mukule heleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wonttitha gallas kaalithizitay, cimitayinnee, higge asitamaaritay Yerusalaame shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ye asay gancce qeese halaqa Haanna, Qayyaafa, Waannisa, Iskkinddirennee qeese halaqay kara asitay ubbay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hawaarita fa tiina eesi, «Aba wolqqar woy o sunthar yhaya yi ootheenee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ye wode Phixiroosa Geeshsha Ayyanar kumii, «Woya halaqitayyonnee, cimitayo, ");
INSERT INTO mfxl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yhayino yha wobbo athayis oosintteez lo77o oosayil E wayizii paxeezako yi nuna oyciko, ");
INSERT INTO mfxl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mazqalel afa yi soxxin, Xoossii yhayiqopp dentheez Naazirete Yesuus Kiristtoosa sunthayir yha athay paxii yi tiina eqqeezay yinttisnnee Isreele as ubbayis erintto. ");
INSERT INTO mfxl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","«‹Yinttii gimbbizitay borii ixxeez shuchchay, keethe muumer tookkii aykkiz kirkiro garkke, ubbaypp aadhiz shuchch maaqqeeza; ye shuchchay Yesuusa.› ");
INSERT INTO mfxl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yey gishos, atotithii e baggarapp attin hara o baggarakka baaya. Nuunii e sunthar attod garkk as ubbayis Xoossii salopp oommor inggeez hara sunthii baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Shiiqeez asay Phixiroosannee Waannisa yashsha bayth odeezana be7eez wode unttii tamaarekka cere as maaqqeeza akaakii malabaz geeza; unttii Yesuusar yezayana ereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma paxeez athay Phixiroosarannee Waannisara eqqeezana asay bi7in godibaz dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Zin Phixiroosannee Waannisa bale kezoday garkk udii fa gancce, ");
INSERT INTO mfxl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Yha asita nu ab udo? U kushe oosintteez gita mala bazay Yerusalaame yez ubbayis benttiza. Nuunii yeya eroowa godayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Zin yha oday as gancce laalinttaama ygarkk yikkepp guye yha asitay Yesuusa sunthayir ooskka odaamayinnee taamarisamay garkk miinthii odii» yeegii zorintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Unttan xeegii, Yesuusa sunthayir yhannipp gede yesha odaamay garkkennee tamaarssaamay garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Zin Phixiroosannee Waannisa unttiko mahii, «Xoossis kiitinttodayippennee yinttis kiitinttodaypp Xooss tiina aay lo77ozako an yi pirddoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nuunii be7eezi bazinnee si7eezibaz oda ashshodayis danda7ooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Woya cimitaynnee kaalithizitay kaseesaypp miinthii naagisii unttan dakkii ashsheeza. Asay haneezibazayis Xooss galatiza gishos unttan seerodayis danda7ibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ye malatayir harggepp patheez athayis laythay oyitamapp aadho. ");
INSERT INTO mfxl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phixiroosannee Waannisa bili7inttii unttar ammaniza dabbitayiko yhanigii, qeese halaqitayinnee cimitay faako geezbaz ubba unttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Unttii yeya si7eez wode pettii wozinar maaqqii Xoossa yhay garkk yeegii woosseeza: «Ubba mooddiz Godayyo, salo, sa7a, abbannee u gancce yez ubba baz medhdheezayyo, ");
INSERT INTO mfxl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Neenii ne ayllana, nu ade Dawute doona Geeshsha Ayyanar, «‹Woya abis yiloteenee? Asay abis cere tobbeenee? ");
INSERT INTO mfxl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sa7a kaatityinnee gade haarizitay pettipp Godayil afannee E Kiristtoosal afa denddeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Tumakka, Herodoosannee Phenxe Philaaxoosa Ayihude baa asayirannee Isreele asayira ne tizheez ne geeshsh Na7a Yesuusal afa dendodayis yha katamayi shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ma ne wolqqayidannee ne shenayid udod gi qopp betteeza ubba unttii poleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yhattekka Godayyo, u mandditha bo7oba; nuunii ne ayllitay ne qaala kunth wozinar ododay garkk nuna danda7isoba. ");
INSERT INTO mfxl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne geeshsh oosancho Yesuusa sunthar hargganchchita pathodayis, oorathibazinnee malatitay oosinttoday garkk ne kushe miccoba» gi woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Unttii Xooss woosseezaypp guye ye unttii shiiqeez aqay eni7eeza. U ubbay Geeshsha Ayyanar kumin Xooss qaala goobi odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ammanizitay ubbay qofarannee wozinar petto maaqqeeza. Unttii paas yeza baz tabaz geekkazar pettipp shaakinttiza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hawaaritay Goda Yesuusa yhayiqopp dentheez gita wolqqar markkattiza. Xooss unttis ubbayis aadho keehatithaypp gaanthii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Biitta woy kamppa yezitay ubbay bayizii ekkeez miisha ki7iza gishos ammanizitay gancce metintteezay pettakka baaya. ");
INSERT INTO mfxl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Miishe ki7ii hawaaritayis inggiza; ye miisha pettayis pettayis koshshizay garkk shagii shagii inggiza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qoophiroosa giz aqo yelintteez Yooseefa giz Lewe sheeshaypp maaqqeez pettay yeza. E suntha hawaaritay Barnnabaasa geeza. Barnabaasa guussay Minthatho na7a guussii geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnnabaasa paas yez biitta bayizii miisha ki7ii hawaaritayis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pettii Hanana giz athay fa machchat Saphphirir gade bayizeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ye bayizeez miishaypp fa machchat erodar shagii ashshii, atteezana ki7ii hawaaritay toke kale gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Zin Phixiroosa Hananako, «Neenii Geeshsha Ayyana dooshshoday garkkennee biita bayizeez miishaypp shagii ashshoday garkk Xalahe ne wozina abis geleenee? ");
INSERT INTO mfxl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Neenii bayizodaypp tiina biitay nees baasannee? Ma ne bayiz maaqqinkka miishay nees baasannee? Yeezin, yey garkk oothodayis abis ne wozinar qoppeenee? Neenii Xoossal afa worddoteenepp attin asal afa worddotekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananee ye qaala si7eezangarkk pokkii yhayqqeeza; yeya si7eez ubbay iita yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na7atitha asitay denddii e aha ziidhii afilar xaaxii kanggii moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hayidzii saatepp guye Hanana machchat yeya erekkazar Phixiroosa yeza aqo geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phixiroosa iiko, «Yi biitta yhannii garkk miishes bayizeenee? An taas odoba» yeegeeza. Izaka, «Ee, yhay garkk miishes bayizeez» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phixiroosa iiko, «Neerannee ne azinayira Goda Ayyana faaccodayis abis zorintteene? Yeezako, ne azina moogeez asay baler yeza; nenakka unttii bale kessoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Izakka izir Phixiroosa toke achcha pokkii yhayqqii ateeza; na7atithitay gelodar yhayqqeezano denggii bale kessii, I azinay kale moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Woosa keeth ubbaynnee yeya si7eez hara as ubbay loythii yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hawaaritay gaame malatitannee orothabazita as gancce ootheeza. Ammaniza ubbay Solomone barandda pettipp shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hara asaypp pettii asikka unttan hellodayis minggekka, zin asay unttan bonchchiza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ammaniza dhiirathitaynne maachchitay taybay kaseesaypp gaanggittar gaaggittar qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yey gishos, asay hargganchchita halarannee arssar tookkii Phixiroosa aadhodar e eeshay unttapp pettayil pettayil afa shemppoday garkk oge doona kessii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma gaame asay Yerusalaame kale yez katamitaypp hargganchchitannee tuna ayyana waayisiza asita ekkii yi7iza; ubbaykka paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Qeese halaqaynnee ezir yez Saduqaawitay ubbay qinaater kumii hawaaritayil afa denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hawaarita aykkii woya achch kara oleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Zin Goda kiitanchchay qamma achch kara penga dooyii hawaarita bale kessii, ");
INSERT INTO mfxl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Yhanigii, Xooss kara eqqii yha de7o qaala as ubbayis odoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hawaaritay yeya si7eez wode wontt guura Xooss Kara gelii taamarsso aykkeeza. Qeesitay halaqaynnee ezar yezitay yi7ii, Isreele cimita ubba xeegii shiishii hawaarita fa tiina ko7oday garkk wotaaddarita achch kara azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Zin wotaaddaritay achch kara yhanigii hawaarita denggekka. Guye maaqqii yi7ii woyas, ");
INSERT INTO mfxl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Nuunii yhanigodar achch kara ibithay miinthii gorddettin, naagizitay pengel eqqeezita denggeez. Zin nuunii penga dooyodar gancce hara attozin pettii askka baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yey gishos, Xooss Kara wotaaddarita kiittizayinnee qeese halaqitay yeya si7eez wode «Hawaaritayil afa abi haneenee?» yeegii taweeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ye wode pettii athay unttiko yi7ii, «Yeezako, achch kara yi gelsseez asitay Xooss kara eqqii asa taamarssiza» yeegii unttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Xooss Kara wotaaddarita kiittizay fa wotaaddaritayira yhanigii hawaarita ke7eeza. Zin unttii fana asay shuchchar shocoda gi yashitteez gishos unttan aaddashii ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Unttii hawaarita ki7ii, shiiqeez shanggo tiina ki7in qeese halaqay unttiko, ");
INSERT INTO mfxl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Yinttan nuunii ya athay sunthar tamaarssaamay ygarkk miinthii kiittekkasa? Yeezako, yi timirtta Yerusalaame katama ubba heltheeza. Ye athay shemppayis nuna oyicishodayis qoppine?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phixiroosarannee yhankko hawaaritayir unttis mahittar, «Nuunii asis kiitinttodaypp Xoossis kiitinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mazqalel afa yi sottii wodhdheez Yesuusa nu aditay Xoossay yhayiqopp dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isreelitay nagaraypp maaqqoday garkkennee u nagaray atto ginttinttoday garkk Xooss Yesuusa haarizannee ashshiza udii bonchchor fappe ushachch baggar betitheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yeyis nuunii markka; ma Xooss fana kiitinttizitayis inggeez Geeshsha Ayyaanaykka markka» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shiiqeez asay yeya si7eez wode iita yilottii, hawaarita wodhodayis qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Zin as ubbayid lo77o bonchchintteez, higge asitamaaray, Gamaalale giz pettii Ferisaaway denddii eqqii hawaarita xiqqa wodes bale kessoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yeypp guye, shiiqeez asayiko, «Isreele asayyo, yha asitayil afa yi udodayis qoppizabazipp naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Abis giiko, yhaypp tiina Tewodaasa fana, ‹Taanii damma› gi denddin, oyddii xeet maaqqiz asitay ezar ma7intteeza. Zin eza wodhin eza kaalleez ubbay laalinttin pathoowa as maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yeypp guye, asay taybinttiza wode Galila yez Yihuda denddii gaame as pangga mahii kaalitheez, zin ezakka wodhin eza kaalleez as ubbay laalintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yhattekka ta yinttis odiza; yha asitaypp shaakinttoytta; unttan bochchipatte. Abis giiko, yha qofannee yha oosa as oothizabaz maaqqiko dhaboda. ");
INSERT INTO mfxl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Zini yha qofaynnee yha oosay Xoossapp ye7eez baz maaqqiko, yi unttan dhabisodayis danda7oowa. Yeyititar yi Xoossar kaccinttoda» yeegii odeeza. Yeyi gishos, shiiqeez asay Gamaalale zoriza ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hawaarita kara xeegii gelisii alanggar garafeeza. Yeypp guye, unttiko, «Yesuusa suntha nam7intho denthipatte» gi bili7i dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesuusa sunthay gishos unttii kawushoday beeziza baz maaqqeezana ereez gishos shanggita tiinapp ufayttittar kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Unttii ubba wode Xooss keethannee as kara Yesuusa E Kiristtoosa maaqqeezana taamarssizanannee sabbakizana ashshekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ye wode kaalizitay taybay gaanggii gaanggii yhanigodar, Girike doona odinttiza Ayihuditay Yihuda yelinttii yez Ayihuditayil afa oolleeza. Abis giiko, Girike doona odinttiza Ayihuditay, «Gallas gallas ingginttiza kathayir nu azinii yhayqqeez maachchitayir urqqiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Taphpho nam77ii hawaaritay woosa keeth as ubba xeegii, «Nuunii Xooss qaala odiza ashshii katha gishodayis nuus beezooya. ");
INSERT INTO mfxl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yikkee, nu ishuntho, lo77o asita, Geeshsha Ayyanarannee ecetithar kumeez laappun asita yi ganccepp dooroytta; nuunii unttan yha oosayis shuumoda. ");
INSERT INTO mfxl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Zin nuunii, nu kuminth wode Xooss woosarannee qaala tamaarssor peeshshoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hawaaritay odeez oday as ubba ufaysseeza. Yey gishos, ammanorannee Geeshsha Ayyanar kumeez Isxifaanose, Filphoosa, Phirokoroosa, Niqaarone, Ximoona, Pharmmeenannee Ayihude ammano gelii maaqqeez Anxooka Niqoloosa maraxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Unttan hawaarita tiina ki7in, hawaaritay unttal afa kushe gaddii Xooss woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xooss qaalay dalggi dalggi yhanigeeza. Yerusalaame yez ammanizitay taybay gaanggii gaanggii qiteeza; qeesitayppekka gaamitay ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isxefaanose aadho keehatethayrannee wolqqar kumii as gancce orothibazitannee malabazita udiza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aylletithapp kezizitayis ginttinttiz Ayihude Woosa Keeth asay Qerenappennee Iskkinddireppe Kilqepennee Iisiyappe ye7eez pettii pettii asitay denddii Isxifaanosar palameeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Zin Isxifaanose odinttitar yez ecetithannee Ayyana unttii eqinttodayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ye wode unttii, «Musenannee Xoossa E cazhodar si7eez» giz worddo markkatta denthitheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yey garkk udii woya gade cimitannee higge asitamaarita ezal afa denthitheeza. Isxifaanosena aykkii Shanggo tiina kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ezal afa payideez worddo markkitay, «Yha athay yha Xooss karannee Muse higga mahii mahii cazhiza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","E, ‹Yhay Naazirete Yesuusa, yha Xooss Kara laalloda; ma Muse nuus inggeez higga laammoda› yeegodar nuunii si7eez» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Shanggo shiiqol betteez as ubbay Isxifaanose dakkii be7adar e sinay kiitanchcho sino aaziza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Qeesitay halaqay Isxifaanoseko, «Yha mootay tuma?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isxifaanose, «Ta ishuntho, ta aditayyo, si7oytta! Nu ada Afraame Kaaraane yezodayis yhanigodaypp tiina Masephexoome yezin, bonchcho Xoossay ees qonccii, ");
INSERT INTO mfxl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹Ne gadayppennee ne dabbitaypp shaakinttii taanii nena beeziza biitta qitoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ye wode Afraame Kaladaawitay biittapp kezii Kaaraane yezodayis qiteeza. E aday yhayqqeezaypp guye Xoossii eza yha biitta yhatti yi yez gada ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E hara attozin tokay yedhdhiz aqokka Afiraames inggekka. Zin na7a ees baa wode Xooss yha biitta eesinnee e sheeshayis laata udii inggodana qaala geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xoossii Afraameko, ‹Ne sheeshay hara biitta imathetithar yezoda; ezayid oyddii xeet layth unttii aylletitha haarinttoda. ");
INSERT INTO mfxl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Zin taanii ne sheesha moodiz gadayil afa pirddoda. Yeypp guye, unttii ye biittaypp kezii yhaydda taas goynnoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xoossii Afraame sheeshay dookalinttoday garkk ezar caaqqin, Isaaqa yelintteez hosppuntha gallasar dookaleeza. Isaaqa Yayqqooba dookaleeza; ma Yayqqooba taphpho nam77ii fa na7ita, nu aditay mayzita dookaleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Yayqqooba na7itay Yooseefana qinaatii Gibxxe biitta aylletithis bayizeeza, zin Xoossii ezar yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Eza, e waaye ubbaypp kesseeza. Gibxxe kaat Paarona tiina deettennee ecetith ees inggeeza. Gibxxe kaatay Yooseefas Gibxxe biittannee fa kara ubba aqisod halaqatithi inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Gibxxe biittayidannee Kan7aane gade ubbayid naye gelii gaame asa un77itheeza. Ye wode nu mayzitay katha denggodayis danda7ibe7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayqqooba Gibxxe biittayid katha yezana si7ii nu aditay tiina ged eza dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nam7inth yhamayir Yoosef fa ishitayis fana erseeza. Gibxxe kaat Faarona Yooseefa sheeshay ereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yooseefa fa ade Yayqqoobannee fa dabbo ubba, laappun tamann ichchin asay faako ye7oday garkk kiittii ki7iseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yayqqooba Gibxxe biitta wodhdheeza; eenne e na7itay ezayid yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","U meqetha ye aqaypp Seekeeme tookinttii yhanigii, ezayid Afraame Hamoore na7itaypp gaam birar wongeez duufayid moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Zin Xoossay Afraames inggod geeza poliza layth hellodayis helleez wode Gibxxe biittayid yez nu asay gaanggii gaanggii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yeypp guye, Yooseefa eroowa hara kaat Gibxxe biittayid kawutod hellodayisii. ");
INSERT INTO mfxl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ye kaatay nu zeritha genii xiqqa na7itay yhayqqoday garkk unttan bale kessii oloday garkk nu adita un77itheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Ye wode Muse yelintteez; E Xooss tiina usa lo77o na7a. Fa aday kara hayidzii agina hellodayis dicceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Muse wora gaddeez wode Gibxxe kaatay na7ita denggii ekkii fa na7a udii eza dichcheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muse Gibxxitay ecetith ubba taamarii odarannee oosor mino as maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Muses laythay oyttam kumeez wode fa ishita, Isra7eelita be7adayis fa wozinayid qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isra7eelitaypp pettaya Gibxxe as pettay qohodar bi7ii ye Isreele atha maaddii, ye qoheez Gibxxe atha wodhii kushe maheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muse fa ishita fa baggar Xoossii ashshodayis hanizana unttii akaakoda gi qoppeeza, zin unttii akaakekka. ");
INSERT INTO mfxl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Wonttitha gallas nam77ii Isreele asitay pettay pettayir yhadhinttodar denggeeza unttan dabbosodayis kezii, ‹Asuntho, yi ishita; abis pettay petta qohine?› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«Zin pettay fa lagga qohizay Museko, ‹Nena nuul afa haarizannee daynna ootheezay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Neenii ziqin Gibxxe atha wodheezay garkk tana wodhodayis koyinee?› yeegii Musena urqqii dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muse yeya si7ii Gibxxepp bettii Miidaame biitta bete as maaqqii yezitar nam7i dhirith na7ita yeleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Goda kiitanchchay oyttam laythapp guye Siinna amba kale yez liizho tushe gancce eexiza tama laco gancce Muses bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muse fa be7eezayid malabaz gi, loythii be7adayis tusheko shiiqii yezin, Goda qaalar, ");
INSERT INTO mfxl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Taanii ne aditay, Afraame Xooss, Isaaqa Xooss, Yayqqooba Xooss› yeegttar Museko ye7eez. Muse yashshar kukkurii be7adayis danda7ekka. ");
INSERT INTO mfxl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Goday Museko, ‹Neenii eqqeez biittay geeshshi maaqqeez gishos ne tokayid yez caamma kessoba. ");
INSERT INTO mfxl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taanii Gibxxe yez ta asay un77intta be7eeza. U uufa si7ii unttan ashshodayis wodhdheeza. Yhatti yhana! Taanii nena Gibxxe kiittoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Isreelitay Muse, ‹Nena nuna haarizannee daynna ootheezay oonoo?› yeegii ixxeeza ye muse tushe gancce ees bentteez kiitanchchay baggar haarizannee ashshiza udii Xooss azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ye Muse Isra7eelita Gibxxe biittayir zoqo Abbannee liizho biittar oyttam layth malabazitannee orothabazita oothitar unttan kaalith keseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Isreele asayiko, ‹Xoossii tana dentheezay garkk yi sheeshay ganccepp ta garkk nabe yinttis denthoda› yeegeezay yha Muse. ");
INSERT INTO mfxl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Liizho biitta shiiqeez Isreele asayira yezeezay, nu aditayirannee Siinna ambal afa ees odeez kiitanchchayira yezeez. Ye Muse de7o qaala nuus inggodayis ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Zin nu mayzitay Muses azazinttodayis koyekkaya; eza ixxii guye Gibxxe maaqqodayis amotteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ma Aaroonako, ‹Nuna kaalithiza Xoossita nuus oothoba. Abis giiko, yhayi nuna Gibxxepp ke7eez Muse, wayeezako nuunii erooya› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ye wode ooggona aaziz eeqa ootheeza. Ye eeqayis yarshsho yarshsheez fa kusher ootheez oosayir ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Zin Xoossii unttis zokko maheeza. Unttii salo xoolinttita goynnoday garkk unttan ashshii ashsheeza. Nabitay maxaafayid, «‹Isreele asitayyo, oyttam layth kunth liizho biitta shukkeez mehennee yarshsheez yarshsha taas yarshsheenenee? ");
INSERT INTO mfxl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yi, yinttis goynnodayis kochcheez eeqanne Mooloke dunkkaana Refana giz yi Xoossa xoolintto misila tookkeeza. Taanii yinttan Baabiloonepp seko bagga dakkoda› ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Nu aditayis liizho biitta markka dunkkaanay yeza. Ezakka Xoossii Muse kiitteezannee e beezeezay garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ma nu aditay ye dunkkaana fa aditaypp ekkii Xooss tiina bayi7itheez Ayihude maaqqekka asay biitta aykkeez wode Iyyaasur woli ekkii geleeza. Ye dunkkaanay Dawute wode hellodayiskka ye gadayid yezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawute Xoossar sabintteeza. Ma Yayqqooba Xoossayis keeth keexxodayis Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Zin ees keeth keexxeezay Solomone. ");
INSERT INTO mfxl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Hano zin, Ubbaypp afa Xoossay asii keexxeez keetha yezooya. Nabe geezay garkk, ");
INSERT INTO mfxl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«‹Salo ta zufaane, sa7aykka ta tokay yedhdhiz aqo. Yeezin, taas yi ab garkk keeth keexxode? woy taanii shemppiza aqay aba yenee? ");
INSERT INTO mfxl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yha ubba ootheezay ta kushe baasa?› yeegiza Goday. ");
INSERT INTO mfxl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Yi wayizii si7oowa aso? Yi wozinay Xooss qaala ekkodayis abis ixxeenee? Yi hayay abis tuleenee? Yi, yi aditaykka uba wode Geeshsha Ayyanara eqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabitay ganccepp yi aditay bayi7eezay oonoo? Xillay ye7odana tiinatii odeezana wodheeza. Yhatti yi eza aathii inggii wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yi kiitanchcha kushepp Xooss higga ekkeeza, zin kiitinttekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Unttii yeya si7eez wode fa wozinayid Isxifaanosel afa gaame yilottii, fa achch dhaqii manddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Zin Isxifaanose Geeshsha Ayyanar kumii, salo udee bi7ii, Xooss bonchchonnee Yesuusa Xooss ushachch baggar eqqeezana be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«Yeezako, taanii salo dooyinttin, As Na7ay, Xoossa ushachcha eqqeeza be7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Qaala dhoqq udii ukkittar, fa haya tuccii wola eeko woxxeeza ");
INSERT INTO mfxl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Eza katamaypp gaxa kessii, shuchchar caddeeza. Markkattii fa ma7a pettii Saa7oola giz na7atithay kale gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isxifaanose, «Ta Goda Yesuusa, ta shemppa ekkoba» yeegii xeegodar unttii eza shuchchar cadeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bunqittii, fa qaala dhoqq udii, «Ta Godayyo, yha nagara unttis atto goba» yeegeeza. Yey geezapp maaqqii yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saa7oola Isxifaanose yhayiqayid ma7intteeza. Ye gallas Yerusalaame yez woosa keetha gita bayi7ith denddeeza. Hawaaritay attin ammanizitay ubbay Yihuda biittannee Samaare biitta laalintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pettii pettii Xooss asitay Isxifaanose moogeeza; ma ees iita yeekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Zin Saa7oola woosa keeth dhabisodayis koyiza. Kara kara yuuyii gelii, ammaniza dhiirathitannee maachchita goochchii goochchii kessii achch kara gelsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laalintteez ammanizitay yhanigeez aqo ubbayid qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filphoosa Samaare katama yhanigii Kiristtoosa bagga asayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gaame asay Filphoosa geeza si7eez wodennee E oothiza malabazita be7eez wode eza akaakii si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tuna ayyanitay uukkii gaame asaypp kezeeza; ma gaame gundditaynnee wobbitay bili7intteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ye katamayid yez asay gaame ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Zin Simoona giz pettii athay ye katamitte yeza. E, «Taanii gita gita asi» gi Samaare asa kaayor yhay malabaziyegisittar gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Xiqqapp aykkii damma hellodayis yez as ubbay, «Damma Xoossa wolqqay yhaya» gi eza si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gaame wodepp aykkii kaayor Samaare asa malabaz giseez gishos asay eza si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Zin Filphoosa Xoossa kaatetithannee Yesuus Kiristtoosa sunthibagga dhiirathitayisnne maachchitayis odin, unttii ebaz ammanii xammaqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ma Simoonakka ammanii xammaqinttii Filphoosara wola yhanigii be7eezi baz ubbayidannee oosintteez gita malatita bi7ii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalaame yez hawaaritay Samaare asay Xooss qaala ekkeeza si7ii Phixiroosannee Waannisa unttiko dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phixiroosannee Waannisa yhanigii, ammanizitay Geeshsha Ayyana ekkodaygarkk unttis Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Abis giiko, Samaare asitay Goda Yesuusa sunthar aadda xammaqintteenepp attin unttapp pettayil afakka Geeshsha Ayyana haga wodhdhekka. ");
INSERT INTO mfxl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ye wode Phixiroosannee Waannisa fa kushe unttal afa gaddin, unttii Geeshsha Ayyana ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hawaaritay fa kushe unttal afa gaddin, unttis Geeshsha Ayyanay inggintteeza Simoona be7eez wode Phixiroosasinnee Waannisas miishe ki7ii, ");
INSERT INTO mfxl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Taanikka ta kushe gaddeez ubbay Geeshsha Ayyana ekkoday garkk yha mawute taasikka inggoytte» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Zin Phixiroosa eeko, «Neenii Xooss imota miisher woonggodayis qoppeezay gishos ne miishitir nena ekkii dhabo. ");
INSERT INTO mfxl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne wozinay Xooss tiina luulo maaqqekka gishos nees yhaydda shago woy qaada baaya. ");
INSERT INTO mfxl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Yikkee, yha ne wozina iitatithay gishos nagaraypp maaqqoba. Ne wozina yez iita qofa Xoossii atto goday garkk Goda woossoba. ");
INSERT INTO mfxl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ne iita camo qinaaterannee nagara achcha yezaya taanii bi7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoona mahii, «Yi geezaypp pettakka tana hellaamay garkk taas goda woossoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phixiroosannee Waannisa markkatteezayppennee Goda qaala odeezaypp guye Yerusalaame maaqqeeza. Samaare yez gaame heera Wonggile odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Goda kiitanchchay Filphoosako, «Denddii sulle baggar Yerusalaamepp Gaaza kanggiza liizho biita ogayko yhanigoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filphoosa denddii qiteeza. Hinddeke giz Tophphe kaatatis I miisha ubba naagiza Tophphe as yeza. Eekka goynnodayis Yerusalaame qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Gaarel bettii, Yerusalaamepp fa biitta maaqqittar nabe Isiyaasa maxaafe nabbabiza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Geeshsha Ayyanay Filphoosako, «Ye gaarayko yhanigii kale shiiqoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yeezin Filphoosa woxxii yhanigii hellodar zhandarbay nabe Isiyaasa maxaafe nabbabodar si7ii, «Ne nabbabizay nees gelinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Zhandarbay, «Tana tamarisiza as baazin wayizii gelode?» yeegeeza. Gaarel kezii bettoday garkk Filphoosa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Zhandarbay nabbabiza maxaafay kifilay yhaya, «E dur garkk shukinttodayis laagintteeza; Duri na7a fa ikisa meedizitay tiina si77i gizay garkk, eekka fa doona dooyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","E kawuzheeza; ees geeshsh pirddakka dhabeeza. E yessay yha sa7aypp gachintteez gishos e sheeshibagga oonoo ododay?» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Zhandarbay mahii Filphoosako, «Nabe obaz odee? Fa bagga odinenee hara asibaz odee? Taas odooye» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filphoosa mahii, Xooss qaala ye aqaypp aykkii, Yesuusa bagga odiza Wonggile ees odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Unttii yhanigttar haathii yeza aqo helleeza. Zhandarbay, «Haathe yhaya bo7oba; ta xammaqinttamay garkk abi kaye?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filphoosa eeko, «Neenii ne kunith wozinaypp ammaniko danda7iza» yeegeeza. E mahii, «Yesuus Kiristtoos Xoossa Na7a maaqqeezana taanii ammaniza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gaaray eqqod garkk zhandarbay kiittin, nam7ay wodhdhii haatha geleeza; Filphoosa eza xammaqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Unttii haathapp gaxa kezeezan garkk Goda Ayyanay Filphoosa qoppekkazin ekkeeza. Nam7intha zhandarbay Filphoosa be7ekkaya, zin fa oga ufayttittar qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filphoosa Azaaxona oleeza. Ma Qisaare ye7oda hellodayis katamitayir yuuyii Wonggile markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ye wode Saa7oola Goda kaalizita wodhodayis mandditar qeese halaqitayiko yhanigeez. ");
INSERT INTO mfxl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Goda oge kaalliza dhiirathitannee maachchita denggiko, accii Yerusalaame ko7odayis, Damasqqo yez Ayihude Woosa Keethitayis dabddaabbe xaafinttoday garkk eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","E yhanigii, Damasqqo katama hellodayis ukkodar, qoppekka salopp wolqqama poo7o e yuushayir poo7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","E sa7a pokkeezazin, «Saa7oola, Saa7oola, abis tana bayithinnee?» giz qaala si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saa7oola, «Godayyo, ne oonoo?» yeegii oycceez. «Taanii, ne bayi7ith Yesuusa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Goday eeko, «Denddii katama geloba; ne oothodayis beezizabaza ezayid nees odinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saa7oolara oge yhanigiz asitay akkokka odinttekka eqqii atteeza. Giirth si7inttiza, zin oonakka benttowa. ");
INSERT INTO mfxl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saa7oola pokkeez aqaypp denddii be7adar e aafay denggaam ixeeza. Yey gishos, unttii e kushayid aykkii kaalithii Damasqqo gelseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hayidzii gallas hellodayis E be7adayis danda7ekka; akkokka meekkaya; uzhekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasqqo pettii Hanana giz Yesuusa tamaaray yeza. Goday qoncithar, «Hananaa» yeegii xeegeeza. Hananee mahii, «Ta Godayyo, ta yhaydda yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Goday eeko, «Denddii luulo ginttinttiz oge yhanigii, Yihuda kara Saa7oola giz xersesepp ye7eez woos woossiz atha koyoba. ");
INSERT INTO mfxl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma Hanana ginttiz athay gelii, Saa7oola nam7intho be7aday garkk fa kushe ezal afa gaddodar qoncithar be7eeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hanana mahii, «Godayyo, Yerusalaame ne geeshsh asayil afa ye athay ab garkk iita baz ootheezako taanii gaame asaypp si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma Damasqqo ne suntha xeegizita ubba accodayis, qeese halaqitay ees mawute inggeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Zin Goday eeko, «Saa7oola Ayihude maaqqekka asay tiina, kaatitay tiinannee Isreele asay tiina, ta suntha ersodayisnnee taas oothoayis maraxintteez miisha maaqqeez gishos ne eeko yhanigoba. ");
INSERT INTO mfxl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Abis giiko, ta sunthay gishos E waafa waaye ekkodayis beezizako taanii eza beezoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananee yhanigii, kara gelii, fa kushe Saa7oolal afa gaddii, «Ta isha Saa7oola, ne ye7eez ogayil nees bentteez Goda Yesuusa, ne be7aday garkkennee Geeshsha Ayyanar kumoday garkk tana azazeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ellisii, Saa7oola aafaypp pettii puqo garkkezibazay wodhdhin, Saa7oola nam7intho be7eeza. Ma denddii xammaqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Katha mi miinggeeza, Damasqqo yez ammanizitayir xiqqa gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ellisii Saa7oola, «Yesuusa Xooss Na7a» yeegii Damasqqo yez Ayihude Woosa Keethitayid qaala taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yeya si7eez ubbay malabaz gi, «Yhay Yerusalaame Yesuusa suntha xeegizita dhabisiza baasannee? Ma yhana ye7eezay unttan accii, qeese halaqitay tiina kanggodayis baasannee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Zin Saa7oola qaala odor minggittar minggittar yhanigeeza. Yesuusa, E Kiristtoosa maaqqeezana milxxi udii odeez gishos Damasqqo yez Ayihuditay ees mahodibaz dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gaame gallasapp guye Ayihuditay shiiqii, Saa7oola wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Zin Ayihuditay fana wodhodayis qoppeeza Saa7oola si7eeza. Unttii eza wodhodayis qammannee gallas katama penge naagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Zin e tamaaritay eza qamma kanggii, gimbbe gase lukor daachchora wodhiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saa7oola Yerusalaame helleez wode ammanizitayir walakinttodayis koyeeza. Zin E Kiristtoosa ammaneezay unttis tuma aazam ixxin ees yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Zin Barnnabaasa Saa7oola hawaaritayko kanggeez. Ogel Goday wayizii qoncceezakonnee nashsheezako, ma Saa7oola Damasqqo Yesuusa sunthayir yashittekka wayizii qaala odeezako unttis geeshshii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saa7oola Yerusalaame wutii Goday sunthayir yashittekka qaala odittar, hawaaritayira wolla yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma Saa7oola Girike qaala odeez Ayihuditayra odinttittar palamiza. Zin unttii eza wodhodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ammaniza asitay yeya si7ii, Saa7oola Qisaare kanggii Tersese dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yihuda, Galilarannee Samaare ubbayid yez woosa keethitay saror yezeeza. Ma miinggeeza; Godayis yashittittar Geeshsha Ayyana minthathor gaanggii gaanggii yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phixiroosa gade ubba yuuyttar Liida yez ammaniza asitayko helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ezayid hosppun layth muda silii arssal woyi7ii yez Eeniya giz atha denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phixiroosa, «Eeniya, Yesuus Kiristtoosa nena pathiza; denddii ne hiixa denthoba» yeegeeza. Eekka ellisii denddii eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidarannee Saarona yez as ubbay Eeniya bi7ii, Godayiko maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yoophphe katama pettii Xaabito ginttiz ammaniza asita yeza. (Xaabito guussay gen7e guussii) Iza fa yeza wode ubbayid lo77o baz oothitarannee manqqita maaddittar yezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ye wode iza hargginttii yhayqqin, asay I aha meeccii, pooqeel afa kessii woyitheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liida Yoophphes kale yeza. Ammanizitay Phixiroosa Liida yeza si7ii, «Hayyana nuuko ellisii ye7oba» yeegiz kiita nam77ii asita eeko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yey gishos, Phixiroosa denddii, unttara yhanigeeza. Hellii, pooqeel afa yez kifile eza gelseeza. Am7itay Phixiroosa kalayir eqqii yeekkittar Dorqqa unttara paxa yezar ootheez qamisitannee afilita ubba Phixiroosa beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phixiroosa unttan ubba bale kessii, gulbatii Xoossa woosseeza. Ma ahayko maaqqii, «Xaabite, denddoba» yeegeeza. Xaabita fa aafa dooyii Phixiroosa bi7ii, denddii betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phixiroosa izo fa kusher maaddii denthii esseeza. Yeypp guye, ammanizitannee ami7ta xeegii, denddeezano u tiina ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yha oday Yoophphe katama ubba helleeza. Gaame asay Goda ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phixiroosa Yoophphe Simoona giz degelay kara unddenna gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qisaare, «Xaale ola asitay cuga» ginttinttiz ola asitay gancce pettii Qorineloosa ginttinttiz mato halaqay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Qorineloosa fa kara asayira Xoossa miinthii ammaniza asinnee Xoossa goynniza as. Ayihude manqqitakka gaame maaddiza, ma Xoossa ubba wode woossiza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pettii gallas uddufun saate heera Xooss kiitanchchay eeko yi7ii, «Qornneloosaa» gi xeegodar E qoncithar geeshshii be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qorineloosa dagammii kiitanchcha toli udii bi7ii, «Godayyo, abba?» yeegeeza. Kiitanchchay mahii, «Ne woosannee manqqita ne maaddizay Xooss tiina qofintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yhatti Yoophphe as kiittii, Phixiroosa giz Simoona ki7isoba. ");
INSERT INTO mfxl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Phixiroosa abba kaler degela Simoona kara imathetithi betteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qorineloosa paas odeez kiitanchchay yhanigin, fa ayllitaypp nam7itannee Xooss goynniza fa kale wotaaddaritaypp petta xeegii, ");
INSERT INTO mfxl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Unttis ubba baz odii Yoophphe azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wonttitha gallas unttii yhanigii, Yoophphe katama ukkodar usuppun saate heera Xooss woossodayis Phixiroosa pooqeel afa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","E nayinttii kath maadayis koyeez, zin katha kaxxodar E ahumo be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Salo dooyinttin, damma afila aazizabaz oyddii baggar aykkinttii wodhdhodar E be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ezayid oyddii toker yez mehitay, wora do7ita, ulora goochinttiza medhetithaynnee salo kafita ubbay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ye wode «Phixiroosa, denddii eqqii shukkii mooba» giz qaala eeko ye7eez. ");
INSERT INTO mfxl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Zin Phixiroosa, «Godayyo, wa77a! Ta tuna baz ubbarakka mi eroowa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ma, «Xoossay geeshsheeza neenii tuna giipe» giz qaala nam7intho eeko ye7eez. ");
INSERT INTO mfxl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yeykka, hayidzii toke haneezaypp guye ye gita afila aazizay ellisii udee salo ekintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phixiroosa fa be7eez qoncithayis bili7ithay, «Ab maaqqadeshsha?» gi fa wozinar qoppodar, Qorineloosa kiitteez asitay Simoona kara oyicichi denggii baler eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Fa qaala u dhoqq udii, «Phixiroosa ginttiz Simoona imathay yhaydda yenee?» yeegii oyceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phixiroosa qoncithar be7eezi baza qopithal afa yezin, Geeshsha Ayyana eeko, «Yeezako, hayidzii asitay nena koyiza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Denddii wodhdhoba, taanii unttan kiitteez gishos se7ekka unttar yhanigoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phixiroosa asitayko wodhdhii, «Yi koyizay tanannee; yi abis ye7eenee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Unttii mahii, «Nuna mato halaqay Qorineloosa azazeeza. E geeshsh, Xoossa goynniza asinnee Ayihude as ubbayid gaame bonchchintteez as. Qorineloosa, nena fa kara kanggii qaala neepp si7oday garkk geeshsha kiitanchchay ees odeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phixiroosa asita kara gelssii mokkeeza. Wonttitha gallas, denddii unttara qiteeza. Yoophphe katama yez ammanizitaypp pettay pettay ezar wolla yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wonttitha gallas, Qisaare helleeza. Qorineloosa fa iginttannee fa laggita pettipp xeegii shiishii, Phixiroosa naagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phixiroosa kara gelod hanodar, Qorineloosa eza hellii e tiina xuggunii ees goynnodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Zin Phixiroosa, «Denddoba, taakka ta ommas ne garkk as» yeegii eza dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phixiroosa Qornneloosar odeinttinttar kara gelodar gaamay asay shiiqeeza denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","E asayiko, «Ayihude as hara gader pettipodayis woy woli hellodayis woga baza yi eriza. Zin taanii oonakka tuna woy geeshshi baaya gaamay garkk Xooss tana beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yey gishos, yi taako kiittin ixo bayth ye7eeza. Yhatti tana abis xeegiseezako taas odoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qorineloosa, «Taanii yhayino oyddii gallasapp tiina yhannontte uddufun saate woosa woosodar, phooliz ma7o ma77eez as ta tiina eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","E taako, ‹Qorineloosa, Xoossii ne woosa si7eeza, neenii manqqita maaddeezanakka qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yikkee, as Yoophphe kiittii, Simoon Phixiroosa giza xeegisoba. E, Simoona giz degela athay kara aba doonar betteeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yey gishos, taanii neeko ellisii kiiteeza; ne yi7ithayir lo77o ootheeza. Yikkee, Xoossii nena Kiitteezibaz ubba si7odayis yhatti nuunii ubbay yhaydda Goday tiina yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kaallikka, Phixiroosa, «Xoossii as sino bi7ii asapp ase shaakkooya. ");
INSERT INTO mfxl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Zini duma duma biitta as ubba oona maaqqikokka paas yashittizannee xillo ooso oothizayid Xoossii ufayttiza taanii tuma akaakeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoossay, ubba Goda maaqqeez Yesuus Kiristtoosa baggar sarotith odittar yha Wonggila Isreele asayis azazeeza yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Waannisa xinqqatebagga sabbakeezaypp aykkii Galilapp aykkii Yihuda biita ubba hellodayis haneezibaza yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xoossii Naazirete Yesuusana Geesha Ayyanar tizheezannee wolqqa inggeeza. Xoossii eza yez gishos lo77o baz oothittar harggintteezita pathitarannee Xalahe kushe haarintteez ubba kessittar yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Ayihude biittannee Yerusalaame E ootheez ubba bazayis nuunii markkitta. Unttii mazqalel afa sottii eza wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Zin Xoossii hayidzintha gallas yhayiqopp eza denthii asayis benttoday garkk udeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ye benttithay Xooss tiina maraxeez ees markka maaqqeez nuus markkatizapp attin as ubbayis baaya. E yhayiqopp denddeezaypp guye nuur meezannee uzheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nuunii Wonggile asayis ododay garkkennee paxa yezital afannee yhayqqeezitayil afa pirddodayis Xoossii shuumeezay Yesuusa maaqqeezana markkattoday garkk nuna azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xooss ammaniza ubbay nagaray, e sunthayir atto ginttinttiza nabitay markkatiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phixiroosa haga oda haasekkazin qaala si7odar ubbayil afa Geeshsha Ayyana goggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Phixiroosar Yoophphepp ye7eez ammaniza dookalintteez Ayihude ubbay, Ayihude baazitalakka Geeshsha Ayyana gogeez gishos malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yeya godayis danda7eeza, unttii duma duma doonar nashshittarannee Xoossa galatodar si7eez gishosi. Ye wode Phixiroosa mahii, ");
INSERT INTO mfxl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Yeyitititay ma nugarkk Geeshsha Ayyana ekkeezitay haathar xammaqinttamay garkk kayoday danda7izay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Unttii Yesuus Kiristtoosa sunthayir xammaqinttoday garkk unttan azazeeza. Yeypp guye, unttii paar xiqqa gallas bettoday garkk Phixiroosana woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Hawaaritayinnee Yihuda yez ammanizitay, Ayihude baazitaykka Xoossa qaala ekkeeza si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phixiroosa Yerusalaame yhanigeez wode dookalintteez ammanizitay, ");
INSERT INTO mfxl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","eeko, «Neenii dookalinttekkazityiko gelii unttara katha abis meenee?» yeegii falameeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Zin Phixiroosa haneezibaz tiinapp aykkii maarar odeeza: ");
INSERT INTO mfxl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Taanii Yoophphe katama Xooss woossittar ajuuta be7eeza. Damma afila aazizabaz oyddii baggar aykkinttii salopp wodhdhittar taako ye7eez. ");
INSERT INTO mfxl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taanii dakkii be7adar oyddii toker yez mehita, wora do7ita, ulora goochinttiza medhetithitannee salo kafita be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹Phixiroosa, denddoba, shukkii mooba› giz qaala si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Zini taanii, ‹Godayyo, wa77a, tuna baz woy geezhekkabaz ubbarakka ta doonako helii erooya› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«‹Xoossay geeshsheeza neenii tuna giipe› yeegiz qaala nam7intho salopp ye7eez. ");
INSERT INTO mfxl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«Yey hayidzii toke haneeza, mahii ubbay salo fud ekintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ye saatatekka hayidzii asitay Qisaarepp taako kiitinttii taanii yez kara helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sidhekkazar unttara yhammadaygarkk Ayyana taas odeeza. Ma yha usuppun ishitay Yoophphepp taara Qisaare yhanigeezitayir Qorineloosa kara geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kiitanchchay e kara gancce eqqii, ‹Yoophphe kiittii Phixiroosa ginttinttiz Simoona xeegisoba. ");
INSERT INTO mfxl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nenannee ne kara as ubba ashshiza qaala E nees ododa› geezana Qorineloosa nuus odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Taanii nashsha aykkodar Geeshsha Ayyana tiin nuul afa wodhdheezay garkk unttal afakka wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ye wode ‹Waannisa haathar xammaqeeza, zin yi Geeshsha Ayyanar xammaqinttoda› yeegeez Goda qaalay taas qopintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xoossay nuus Goda Yesuus Kiristtoosa ammaneezitayis inggeez imota izo Ayihude baazitayisikka inggiko, yeezin Xoossa kayodayis taanii oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Unttii yeya si7eez wode fa palama ashshii, «Yeya maaqqiko, Xoossay Ayihude baazitaykka nagarapp maaqqii de7o yezoday garkk maaroteth inggeeza» yeegii Xooss galateeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isxefaanoosana yhayiqos heltheez bay7ithaypp denddeezayid laalintteez ammanizitay qaala Ayihuditay aaddas odittar pinqqe, Qoophiroosannee Anxooka hellodayis yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Zin Qoophiroosappennee Qerenapp ye7eez pettii pettii ammaniza asitay Anxooka yhanigii, Goda Yesuusa Wonggile Girike asayiskka odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Goda wolqqay unttara yeza; ma gaame asay ammanii Godayikko maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ye oda Yerusalaame yez woosa keethay si7eez gishos Barnnabaasana Anxooka azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnnabaasa Anxooka yhanigeez wode Xoossii fa aadho kehetithaypp fa woyayis wayizii inggeezako bi7ii ufaytteeza. Unttii ubbay fa kunth wozinar Godayil miinggii yezoday garkk unttan zoreezay: ");
INSERT INTO mfxl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnnabaasa Geesha Ayyanarannee ammanor kumeez keeha as maaqqeez gishosii. Gaame asaykka Goda ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yeypp guye, Barnnabaasa Saa7oola koyodayis Xerseese qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ezayid Saa7oola denggii Anxooka ekkii ye7eeza. Barnnabaasannee Saa7oola woosa keetha asayira laythi muda bettii gaame asa taamarsseeza. Ammanizitay Anxooka «Kiristtaane» ginttinttii tiina xeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ye wode pettii pettii nabitay Yerusalaamepp Anxooka wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","U ganccepp Agaboosa gizay denddii gade ubbayil iita naye dendodana Ayyana wolqqar tinbbite odeeza. Yeyi haneezay Oroome Kaatay Qalawudoosa wodaydda. ");
INSERT INTO mfxl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ammanizitay ommar ommar fa wolqqay garkk miishe kessii Yihuda yez ammanizitayis maadee dakkodayis qofa acceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Unttii yey garkk udii, miisha Barnnabaasalannee Saa7oolal woosa keeth cimitayis dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ye wode Kaatay Herodoosa woosa keeth asaypp bagga bayithi aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Waannisa isha Yayqqooba mashshar wodhiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yey Ayihudita ufaysseezana bi7ii, gujjii Phixiroosanakka aytheeza. Yey haneezay boora Baale bonchchiza gallasitayida. ");
INSERT INTO mfxl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phixiroosana aykkii acceeza. Paaziqa bonchchiza gallasitaypp guye woya tiina eza kessodayis qoppii, oyddii oyddii wotaaddaritay oyddii aqo naagizitay eza naagoday garkk aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yey gishos, Phixiroosa achch kara naaginttiza. Zin woosa keeth asay ees miinthii Xooss woossiza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodoosa Phixiroosana woya tiina shiishodaypp tiina qamma Phixiroosa nam7i baggar nam7ii wotaaddaritay gancce santhalaater acinttii gentteeza. Naagizitay achch karay pengitayid eqqii naagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Qoppekkazin Goda kiitanchchay qoncceeza. Achch karayid poo7o poo7eeza. Kiitanchchay Phixiroosa miyya bochchii barkkithii «Elle denddoba» yeegeeza. Izirakka santhalaatay e kushaypp wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kiitanchchay eeko, «Ne ma7a ma77oba, ne caammakka aathoba» yeegeeza. Phixiroosa yey garkk ootheeza; kiitanchchay, «Ne afar ma77iz ma7a ma77ii tana kaalloba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phixiroosa achch karapp kezii kiitanchcha kaalleeza. Ees ahumo bi7izay garkk aazizapp attin kiitanchchay oothizabazay tuma aazekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kiitanchchayirannee Phixiroosara tiinasannee nam7intho wotaaddara aadhii katama kanggiza biraata pengayiko helleeza. Pengaykka unttis fa aaddas dooyintteeza. Unttii kezii pettii husa ogel kezeezan garkk qoppekkazin kiitanchchay Phixiroosapp shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phixiroosas wozina maaqqin, «Ta Goday fa kiitanchcha kiittii, Herodoosa kusheppennee naagii betteez Ayihude as ubbaypp ashsheezana yhatti tuma ta ereeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","E yeya akaakeez wode gaame asay pettipp shiiqii Xoossa woossiza aqa, Marqqoosa giz Waannisa indat Mayramii kara yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ezayid baler eqqii xeegeeza. Pettii Rooda giz ooso asita penga ees dooyodayis ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rooda Phixiroosa qaala maaqqeezana erii ufayisar kumii gazara dooyoda ashshii guye woxxii yhanigii, «Phixiroosa bale eqqeeza» yeegii asayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asay iiko, «Neenii eeyinnee!» yeegeeza. Rooda Phixiroosa maaqqeeza geeshshii odeeza. Unttii, «Yey E kiitanchcha» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Zin Phixiroosa baler eqqii xeessi ashshaam ixxin asay gazara dooyii eza bi7ii malabaz geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Zin unttii si77i goday garkk Phixiroosa fa kushayir mallii Goday achch keethaypp eza wayizii kesseezako unttis qonccisii odii, «Yhaya Yayqqoobasinnee ammaniza asayis odoytta» gi ezaypp kezii hara aqo qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sa7a wonttodar «Phixiroosa ana qiteenee» gi wotaaddaritay woli gancce gaame walaseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodoosa Phixiroosa koyisin, E benttekazay gishos naagizita qurii, unttan wodhoday garkk azazeeza. Yeypp guye, Herodoosa Yihudapp Qisaare wodhdhii ezayid xiqqa wode betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodoosa Xiroosa asayirannee Sidoona asayir wola morkke. Unttii biittay katha Herodoosa biittapp denggiza gishos unttii pettipp maaqqii e zhandarba Bilasxoosa paas cima udii dabbotodayis Heroodosakko yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodoosa suntheez gallas fa kaatetith afila ma77ii, zufaanayil afa bettii asayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Asay, «Yey Xooss qaala, as qaala baaya» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodoosa Xoossa bonchchekka gishos izira Goda kiitanchchay eza shocin guxiner minttinttii yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Zin Xooss qaalay diccittarannee dalggittar kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnnabaasannee Saa7oola fa oosa polii Marqqoosa giz Waannisa paar ekkii Yerusalaamepp maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anxooka yez woosa keetha nabitayinnee asitamaaritay yeza. Unttii Barnnabaasa, Karith ginttinttiz Simoona, Qerenapp ye7eez Lukosa, Kaatay Heroodisara dicceez Minaahennee Saa7oola. ");
INSERT INTO mfxl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Unttii Goda goynnitarannee xoomitarannee Geeshsha Ayyanay, «Taanii xeegeez oosayis Barnnabaasannee Saa7oola taas shagoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yey gishos, unttii xoomeezappennee woosseezaypp guye fa kushayid unttal afa gaddii woossii dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yey gishos, Geeshsha Ayyana unttana azazeeza. Selewuqe yhanigeeza; ezaypp markkabe gelii Qoophiroosa haathar teqintteez biita yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Unttii Silmmana hellii Ayihude Woosa Keethitayid Xooss qaala odeeza. Waannisa maaddittar unttar yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Unttii Qoophiroosa haathar teqintteez biitta kanthii Phaafu heliza wode pettii worddo nabe Bar-Yesuusa giz Ayihude ammita denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ye ammitay gade aqisiz Sarggosa Phawuloosa giz wozinaama athayira yeza. Sarggosa Phawuloosa Barnabaasanne Saa7oola faako xeegii Xooss qaala si7odayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Zin Girike doonar ammitay sunthay «Elimmaasa» bilthay gade haarizay ammanamay garkk kayodayis koyii Barnabaasarannee Phawuloosar eqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Zin Phawuloosa giz Saa7oola Geeshsha Ayyanar kumii ammitana dakkii bi7ii, ");
INSERT INTO mfxl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Naati, Xalahe na7ayyo, iitatith ubbay kumeezayo, xillotith ubbayis morkkayo, luule Goda oga mirqiza ashshaamo? ");
INSERT INTO mfxl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yeezako, yhatti Goday kach kushay neell afa yeza. Neenii qooqe maaqqoda; xiqqa wodes awa poo7o be7aamii» yeegeeza. Izir cagganannee dhuma e aafa goozin, fa kushayid aykkii kaalithiza as koyttar yuuyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gade haarizay yeya be7eez wode Godaabaz tamaarssizayid malabaz gi ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawuloosannee ezar yezitay Phaafupp denddii, Phinfila yez Phergge markkaber yhanigeeza. Waannisa unttapp shaakinttii Yerusalaame maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Zin unttii Pherggepp aadhii Phisida yez Anxooka helleeza. Maala gallas gallas Ayihude Woosa Keeth gelii betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse higgayid nabitay maxaafay nabbabintteezaypp guye Ayihude Woosa Keeth halaqitay, «Nu ishuntho, as minthathiza qaala yinttis yezako asayis odoytte» yeegii unttiko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawuloosa denddii eqqii fa kusher mallii, «Isreele asitannee, Xoossa goynniza Ayihude maaqqekka asayyo, si7oytta. ");
INSERT INTO mfxl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yha Isreele asa Xoossay, nu mayzita dooreeza. Gibxxe biitta imathatithar unttii yezin, unttan gaanthii fa gita wolqqar Gibxxe biittapp kesseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Liizho biitta oyttam layth maaqqoda unttan danda7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kan7aane biitta Ayihude maaqqekka laappun kaatetithita haasii u biitta fa asa laatiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yeyi ubbay oydd xeetannee ishatam maaqqad layth gancce haneeza. Yeypp guye nabe Sami7eela wode hellodayis daynnitay aqisoday garkk inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Yeypp guye, unttii paas kaat inggoday garkk woossin, Xoossii Biiname sheeshaypp Qiise na7a, Saa7oola oyttam laythi kawutoday garkk unttis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xoossay Saa7oola shaareezaypp guye unttal afa Dawute kawutiseeza. Xoossay Dawute bagga markkattittar, ‹Taanii ta shene ubba oothiz ta wozina maaqqeez Issaye na7a Dawute denggeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Xoossay, ‹Taanii Dawute sheeshaypp Isreele ashshiza ko7oda› gi qaala geleezay garkk Yesuusana ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuusa ye7odaypp tiina Isreele as ubbay fa nagaraypp maaqqii xammaqinttoday garkk Waannisa qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ma Waannisa fa oosa wurssod hanittar asayiko, ‹Tana yi oona gi qoppee? Taanii yi naagiza Kiristtoosa baaya, zin taanii e caamma bilodayis taas beezowazay taapp guyer yi7iza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Nu Ishuntho, Afraame sheeshuntho, ma yhaydda Ayihude baazin Xoossis yashittizitayo, yha atotitha qaalay nuus kiitintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Abis giiko, Yerusalaame yez asaynnee u halaqitay Yesuusana erekkaya. Maala gallas ubbayid nabbabinttiza nabitay qaala akaakekka gishos ezal afa pirddii nabitay odeez qaala poleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesuusa wodhisodayis pettii sankkekka dhabin Philaaxoosa eza wodhoday garkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Unttii Yesuusabaz Geeshsha Maxaafayid xaafintteezibaz ubba poleez wode mazqalepp eza wodhisii moogeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Zin Xoossay yhayiqopp Yesuusa dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yeypp guye, E paar Galilapp Yerusalaame ye7eezitayis unddenna gallas bentteeza. Unttii yhatti ebaz asayis markkatiza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Xoossii nu aditayis immad geez Wonggile nuunii yinttis odiza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dawute fa Mazmuure Maxaafayid nam7intho shemppayid, « ‹Neenii, ta Na7a, taanii yhayino nena yeleeza› giinttintteezay xaafintteeza Yesuusa, Xoossii yhayiqopp denthii nu mayzitayis inggod geeza nuus u na7itayis poleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E wooqqaamay garkk Xoossay yhayiqopp eza denthor erisodayis, « ‹Taanii Dawutes inggod geez ammanintteez geeshsh anjjo yinttis inggoda› yeegii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yey gishos, Mazmuure Maxaafayid hara aqo ma ‹Ne Xillay aha wooqqisaamii yeegiza.› ");
INSERT INTO mfxl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Dawute fa wode Xoossa qofa poleezaypp guye yhayqqii fa aditayir mooginttii wooqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Zin Xoossay yhayiqopp dentheezay wooqqekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Yey gishos, ta ishuntho, nagara atotithay Yesuusa baggar tiinatii yinttis odintteeza eroytta. Muse higgay nagarapp xillisodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Zin Yesuusa ammaniza ubbay nagarapp xilliza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yey gishos, nabitay geezay yinttal afa hellaamay garkk naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","« ‹Xoossay geezbaz leeqisizuntho! Bo7oytta! Malabaz goytta! Dhaboytta! oonkka odin, yi ammanoowa oosa taanii yi wode oothoda› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawuloosannee Barnnabaasa Ayihude Woosa keethapp kezodar, kaalliza maala gallasayid yeya gujjii ododay garkk asay unttan woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shiiqo laalintteezaypp guye gaame Ayihuditayinnee Ayihuditay ammanayid gelii Xoossa goynniza gaamitay Phawuloosannee Barnnabaasa kaalleeza. Ammaneezitay Xooss aadho keehatithayid miinggii yezoday garkk unttan zoreeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kaalliza maala gallas katama yez asaypp oonkk attekka god hellodayi gaamitay Xooss qaala si7odayis shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zin Ayihuditay gaame asa be7eez wode Phawuloosa qinaattii e nashsha ixxii eza cazheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Phawuloosannee Barnnabaasa yashittekkaya, «Xoossa qaalay tiinatii yinttis odinttodayis koshshiza. Zin yi qaala ixxii medhina de7o ekkodayis nuus beezooya gi yi, yi ommas pirddeez gishos yikkee nuunii Ayihude baazitayko maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yeykka Goday, « ‹Alame kunithay ne baggar attoday garkk, taanii nena Ayihude baa woyas poo7o ootheeza yeegii nuna azazeeza› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayihude baazitay yeya si7ii ufayttii Xooss qaala bonchcheeza. Ma medhina de7os maraxintteez ubbay ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Goda qaalay ye gade ubba helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Zin Ayihuditay, Ayihude baazar Xoosse goynniza bonchintteez maachchitannee katama yez gita asita Phawuloosal afannee Barnnabaasal afa denthitheeza. Ye asitay unttan bayi7ith aykkii fa biittapp kesseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Zin Phawuloosarannee Barnnabaasara ixxizitayis malla maaqqoday garkk fa toke buli7a tiqisii Iqoononnee katama yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma Anxooka yez ammanizitay Geeshsha Ayyanarannee ufayisar kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kaseesaygarkk, Phawuloosannee Barnnabaasa Iqonoone Ayihuditay woosa keeth gelii gaame Ayihuditayinnee Ayihude baazitay ammanod hellodayis qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Zin ammanekka Ayihuditay, Ayihude baazitay wozina laammii ishitayil afa denthitheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hawaaritay ezayid gaame wode gam7eeza. Unttii yashitekka Goday bagga odeeza. Goday malatitannee oorithabaz unttii oothoday garkk unttis mawute inggii fa aadho keehetith qaalay tuma maaqqeezana beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Zin ye katama asay shaakinttii, baggay Ayihuditayir baggay ma Hawaaritayir maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayihude baazitayinnee Ayihuditay fa halaqitayir wolla maaqqii hawaarita qohodayisinnee shuchchar shocodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hawaaritay yeya erii, Lisxirannee Derbe giz Liqa7one katamitannee u heera yez biitta qosintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ezayid Wonggile odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yelintteezaypp aykkii nam77ii tokitay sileez yedhdhii eroowa pettii athay Lisxira yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ye athay Phawuloosa ododar bettii si7izazin. Phawuloosa eza dakkii be7adar paxodayis ees ammano yeza bi7ii, ");
INSERT INTO mfxl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","fa qaala dhoqq udii, «Sitti gi ne tokayir eqqoba» yeegeeza. Yeezin, puthukk gi denddii eqqii yeth aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Phawuloosa ootheeza asay bi7ii u fa qaala dhoqq udii Liqa7one doonar, «Xoossitay as aazii nuuko wodhdheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnnabaasana, «Diya» gi, Phawuloosa yhaydda odar erintteezaya maaqqeez gishos eza, «Hermmeesa» gi suntheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamaypp gaxa yez Diya giz eeqa kara kaahinay kormmitannee fudhe doosita hawaaritayis yarshshodayis kezii katama gaxa ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Zin Barnnabaasannee Phawuloosa yeya si7ii fa ma7a peedheeza. Asay gancce woxxii gelii, ");
INSERT INTO mfxl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","fa qaala dhoqq udii, «Asayyo, yhaya abis oothee? Nuunikka yi garkk ase. Yha pathoowabazaypp salonnee sa7a, abbannee u gancce yez ubba baz medhdheez de7o Xoossayiko yi maaqqoday garkk yinttis nuunii Wonggile ododa. ");
INSERT INTO mfxl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E binii asay fa oge fa oge yhammaday garkk dakkii ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Zini ira salopp bukkiseeza, kathakka woder woder inggeez, kathi inggii yinttan gaame ufaysseeza, yeezii yinttis lo77o baz udii paas markka dhabisekka» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hawaaritay yeya gi paas asay yarshshaamay garkk waayer kayiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anxookappennee Iqoononeppe ye7eez Ayihuditay, asa fa bagga mahii shuchchar Phawuloosa caddeeza. Unttis E yhayqqeezibaz aazin katamapp gaxa goochchii kanggii oleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Zin ammanizita yi7ii, e yuushayid galchchii eqqeezazin E denddii katama geleeza. Wonttitha gallas Barnabaasar pettipp Derbe qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Unttii Derbe katama Wonggile odii gaamita ammantheezaypp guye Lisxira, Iqoononennee Phisida Anxooka maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ye katamitayid yez ammanizita mihithitara unttii ammanor minggod garkk zorttar, «Xoossa kaatetitha gelodayis nuunii gaame waaye ekkodayis beeziza» yeegii taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ma woosa keethitayis ommas ommas cimita dooreeza. Xoomeezayppennee woosseezaypp guye unttii ammaneez Godayis u hadara inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phisida biitta kanthii aadhii Phinfile yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Phergge qaala odeezaypp guye Axaala yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Yeypp unttii fa poleez oosayis Xooss aadho keehatithayis unttan hadara inggeez Anxooka markkaber maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anxooka hellii woosa keeth asa shiishii Xoossay unttara ootheez oosa ubbaynnee Ayihude maaqqekka asay ammanoday garkk unttis wayizii oge dooyeezako odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ezayid ammanizitayir gaame wode gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pettii pettii asay Yihudapp Anxooka yhanigii, «Muse wogay garkk yi dookalinttaam ixxiko attodayis danda7ooya» gi ammanizita taamarsso aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Yey Phawuloosannee Barnnabaasa unttar gaame palamoday garkkennee wacoday garkk ootheeza. Yey gishos, Anxooka yez pettii pettii asay Phawuloosarannee Barnnabaasara Yerusalaame yhanigii Hawaaritayrannee cimitayir woli hellii ye oda billoday garkk qofa acceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Woosa keethay unttan kiittin yhanigeeza. Unttii finqqe Samaarera aadhittar Ayihude baazitay Xoossiko wayizii maaqqeezako odeeza. Yey ammanizita ubba gaame ufaysseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Unttii Yerusalaame hellin woosa keethay, Hawaaritayinnee cimitay unttan mokkeeza. Xoossay unttar ootheezi bazita ubba u odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Zin Ferisaawitay baggapp ammaneez pettii pettii asay denddii eqqii, «Ayihude baazar ammaneez asay dookalinttodayisinnee Muse higga naagodayis beeziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hawaaritayinnee cimitay yeya tobbodayis shiiqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gaame odintteezaypp guye, Phixiroosa denddii eqqii, «Ta ishuntho, Ayihude baazitay Wonggile qaala ta doonaypp si7ii ammanoday garkk tiinatii tana Xooss yi ganccepp dooreezana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","As wozina eriza Xooss Geeshsha Ayyana nuus inggeezay garkk unttiskka inggeezana markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ammanor u wozina geeshsheez gishos nu ganccennee u gancce dummatith gaddekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yey gishos, nu aditaynne nuunii tookkodayis danda7inttoowa qambbara ammanizitay morgayil gaddii yhatti abis Xoossa paace? ");
INSERT INTO mfxl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Goda Yesuusa aadho keehatithayid unttii atteezay garkk nuukka atteezana ammanoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Asay si77i gi, Barnnabaasannee Phawuloosa Ayihude maaqqekka asay gancce fa baggar Xoossii ootheez malatitannee oorothibaz ubba ododar si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Unttii nashsha haaseezaypp guye Yayqqooba, «Ishuntho, ta giza si7oytta. ");
INSERT INTO mfxl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Xoossii Ayihude baazitay ganccepp fa as doorodayis kezii unttan tiin wayizii qopeezako Simoona odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nabitay qaalay yhayir qariza. Geeshsha Maxaafayid, ");
INSERT INTO mfxl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«‹Yhaypp guye, taanii maaqqoda, wodhdheez Dawute keetha denthoda. Laalintteez keethaka ta mahii essoda. ");
INSERT INTO mfxl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Atteez as ubbay taako ye7oda, taanii xeegeez Ayihude maaqqekka as ubbay tana koyoda. ");
INSERT INTO mfxl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Binipp aykkii yey erinttoday garkk udeez goday, tana› yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Yey gishos, ta qofay Xoossiko maaqqeez Ayihude baazita nuunii waayithaamay garkke. ");
INSERT INTO mfxl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Zin unttii eeqas yarshshinttii tuneezibaz maamay garkk, lagitaamay garkk, bawuta maamay garkkennee suuthii uzhaaminnee maamay garkk unttis nuunii dabddaabbe xaafodayis koshshiza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muse higgay binipp aykkii maalagalas Ayihude Woosa Keethi nabbabinttiza katama ubbayid sabbakinttiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yeypp guye, hawaaritaynnee cimitay woosa keeth as ubbayir wolla fa ganccepp xiqqa asita doorii Phawuloosarannee Barnnabaasara Anxooka dakkodayis qofa acceeza. Unttii unddenna erintteez kaalithiza nam7i asita Barssabaasa ginttinttiza e Yihudannee Sillaase dooreeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yhay garkk ginttinttii xaafintteez dabddaabba unttal afa dakkeeza: «Nuunii hawaaritaynnee cimitay yi ishitay, Anxooka, Soorarannee Kilqqe yez Ayihude maaqqekka ishitayis nu sarotha kiittoda. ");
INSERT INTO mfxl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«Nuunii kiittekka asitay nu ganccepp yhanigii, ‹Yi dookalinttodayisinnee higge naagodayis beeziza gi› yinttan waayitheezannee yilotheeza nu si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nuunii dosiza Barnnabaasannee Phawuloosa doorintteez asayir wolla yinttiko kiittodayis pettii wozinar nu murtteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Unttii nu Goda Yesuus Kiristtoosa gishos fa shemppo aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yey gishos, nuunii xaafeezana unttii fa doonarakka gujjii yinttis ododay garkk e Yihudannee Sillaase azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«Yha koshshizitaypp attin hara toofo yinttan toossaamay garkk nuunnee Geeshsha Ayyanay lo77o qofa maaqqeezana be7eeza ");
INSERT INTO mfxl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eeqas yarshintti tuneezibaz miipatte, suuth uzhipatte, bawuta miipatte, lagite ayikkipatte. Yha ubbaypp yi, yinttan naagiko lo77o baz udiza. Saro yezoytta» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yey gishos, kiitintteezitay moyizinttii Anxooka yhanigii ammaniza asita shiishii, dabddaabbe inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Unttii ye minthatho dabddaabba nabbabeezaypp ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ma e Yihudannee Sillaase u fa ommas nabita maaqqeez gishos ammanizita lo7ithii zorii minthatheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Unttii Anxooka xiqqa gallas betteezaypp guye ishitay lo77or moyizin fana kiitteezitayiko maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Zin Sillaase ezayid attodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma Phawuloosarannee Barnnabaasar hara gaame asitayir wolla Goday qaala tamarssitarannee Wonggile odittar Anxooka gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Xiqqa gallasapp guye Phawuloosa Barnnabaasako, «Nuunii Goday qaala odeez katama ubbitayid ammanizitay waafa yezako guye maaqqittar wola be7adannee eroda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnnabaasa Marqqoosa ginttinttiza Waannisa paar yhanigoday garkk koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Zin Phawuloosa Marqqoosa paar yhanigoday garkk koyekkaya. Yeykka, E Phinfila shaakinttii unttar oothodayis yhanigekka gishosi. ");
INSERT INTO mfxl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","U gancce iita kachchii kezin pettay pettaypp shaakintteeza. Barnnabaasa Marqqoosa ekkii markkaber Qoophiroosa kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Zin Phawuloosa Sillaasena dooreeza; ammanizitay Phawuloosa Xooss aadho keehatithayis hadara inggeezaypp guye e qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yeezii, woosa keethita minthathittar Soorarannee Kilqara aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawuloosa Derbbennee Lisxira heleeza. Ezayid Ximaatoosa giz ammaniza as yeza. E indatakka ammaniza Ayihude maachch, e aday Girike asii. ");
INSERT INTO mfxl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lisxirarannee Iqonoone yez ammizitay Ximaatoosa bagga lo7ithii markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawuloosa Ximaatoosa paar kanggodayis koyeeza, eez aday Girike as maaqqeeza ye aqo yez Ayihude ubbay eriza gishos eza dookaleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Unttii katamitayira yhanigttar Yerusalaame yez hawaaritaynnee cimitay acceez qofa ammanizitay naagoday garkk unttis odittar aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Yey gishos, woosa keethitay ammanor minggittar, payidorakka gallas gallas gaanggii gaanggii yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iisiya qaala odaamay garkk Geeshsha Ayyanay unttan kayeez gishos Phirgerannee Galata biittar aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Unttii Miisa zawa helleez wode Bitaana yhammadayis butintteeza. Zin Yesuusa Ayyanay unttan kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yey gishos, unttii Miisa kanttar aadhittar Xiro7aada wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Phawuloosa qamma qoncithar pettii Maqadoona as faako, «Maqadoona piinggii nuna maaddooye» yeegttar eqqii woosodar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ajuuta E be7eezaypp guye ellisii nuunii Maqadoona yhammadayis koyeeza. Yeykka, Wonggile ezayid yez asayis ododayis Xoossay nuna xeegeez aazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Xiro7aadapp denddii markkabe gelii Samotiraaqe yhanigeeza, wonttitha gallas Naaphule yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yeypp denddii Maqadoona biitta yez Filphisoosa giz erintteez worada katama yhanigeeza. Ma Filphisoosa Oroome kaatay olar mooddeez katama. Nuunii ye katamayid xiqqa gallas betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Maala gallas katamaypp gaxa borkka kale Ayihuditay Xooss woossiza aqo yezana qoppii ged yhanigeeza. Ye aqayid shiiqeez maachchitayis qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nuna si7odar asaypp pettii Liida ginttinttiz Tiyatiroona katamapp ye7eeza, Xooss ammaneeza zoqo afila zal7iza, asita yeza. Phawuloosa odiza iza si7oday garkk Goday I wozina dooyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Liida fa kara asayir pettipp xammaqintteezaypp guye nuuko, «Yi tana Goda tuma ammaneeza giiko ta kara yi7ii yezoytta» gi miinthii wooseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nuunii Xoossa woossiza aqa yhammadar iita ayyana iil afa yezanna kaayor fa goditayi gaame miishe ki7iz pettii ayllata nuna heleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Phawuloosannee nuna kaallii, «Yhaytitay Ubbaypp afa Xooss ayllita! Unttii yi attoda oga odizita» gi uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ubba gallas yey garkk giza. Zini Phawuloosa yilottii guye maaqqii, ye ayyana, «Yesuus Kiristtoosa sunthayir izippe kezoba» gi azazeeza. Izirakka iita ayyanay izippe kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Zin I godittay u miishe denggiz ogay dhabeeza bi7ii, Phawuloosannee Sillaase aykkii, awudare dayinnitay tiina goochchii kanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dayinnitay tiina u kanggii, «Yhayititay Ayihude as maaqqittar nu katama asa iita waayithiza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nuunii Oroome gade as maaqqodar ekkodayisinnee oothodayis woga baabaz taamarssiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Asay pettii bagga maaqqii, Phawuloosal afannee Sillaasel afa denddeeza. Dayinnitay u afila qaarii gufer unttan shocoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Unttan gaame yhadhdheezaypp guye achch kara geliseeza. Achch keetha naagizay unttan miinthii naagod garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Achch kara naagizay ye kiita ekkii, Phawuloosannee Sillaase achch karayis qol7a gelisseeza. U toka duthar duuxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Zin giddii bilahe maaqqodar Phawuloosarannee Sillaasera woossittarannee mazimure yexxittar Xoossa galattiza. Achch kara yez hara asitaykka unttii gizibaz si7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Qoppekka achch kara baasay eni7od hellodayis biitta eni7o maaqqeeza. Ye saatatekka penge ubbay dooyintteeza; accintteez as ubba santhalaatay bilintti wodhdheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Achch kara naagizay genttapp barkkodar achch kara penge ubbay dooyintteeza bi7ii achch asay kezii qiteeza aazin fana wodhodayis mashsha ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Zin Phawuloosa qaala dhoqq udii «Nu ubbay yhaydda yeza nena qohippe» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Achch kara naagizay xomppe woossii ekkii ellisii gancce laasii Kukkorittar Phawuloosa tiinannee Sillaase tiina xugguneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Unttan bale kessii, «Ta goditayyo, taanii attodayis ab udodayis beezee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Phawuloosarannee Sillaaser eziko, «Goda Yesuus Kiristtoosa ammanoba; neerannee ne kara asayira attoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Unttii eesinnee e kara yez ubbayis Goday qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Qamma ye saatatekka achch kara naagizay unttan kanggii u sambara meecceeza. Ellisii fa kara as ubbayir xammaqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Phawuloosannee Sillaase fa kara kanggii unttis katha aatheeza. E fa kara as ubbayir Xooss ammaneez gishos ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sa7ay wonttin daynnitay, «Ye asita bili7oba» yeegii poolise halaqita eziko azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Achch kara naagizay, «Yi bilinttodaygarkk daynnitay azazeeza. Yikkee, kezii saro yhanigoytta» yeegii ye kiita Phawuloosas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Zin Phawuloosa ye poolise halaqitayko, «Nuunii Oroome as maaqqadar unttii nuna pirdda bagga asay tiina yhadhdhii, achch kara oleeza. Yhatt nuna geemar kezii qito ginee? Hanena, unttii fa ommas yi7ii nuna kesso» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poolise halaqitay daynnayis yeya odin, Phawuloosarannee Sillaasera Oroome gade as maaqqeeza si7eez wode yashitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yey gishos, daynnitay yi7ii unttiko, «Nuunii yinttan qoheeza» geeza. Achch karapp bale unttan kessii, katamaypp kezii qitodaygarkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawuloosarannee Sillaasera achch karapp kezii Liida kara yhanigeeza. Ezayid ammanizita hellii unttan minthathii kezii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawuloosarannee Sillaasera Amfipholiinarannee Apholoonar aadhii Teselonqqe yhanigeeza. Ezayid Ayihude Woosa Keethi yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawuloosa kaseesay garkk ezayid geleeza. Ezayid hayidzii saamintta Xooss qaalapp asayis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristtoosa waaye ekkodayisinnee yhayiqopp dendodayis beezizana unttis qonccer odittar, «Yesuusa yha taanii yinttis odizay Kiristtoosa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Unttapp pettay pettay oday tuma maaqqeezana ma77ii Phawuloosarannee Sillaasera tobbeeza. Yey garkkekka, Xoossa goyinniza gaame Girike asaynnee gaame bonchchintteez maachchitaykka unttar tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Zin Ayihuditay qinaattii azaliza iita asita gabe ogepp shiisheeza. Katama gancce cabbo medhdheeza; Phawuloosannee Sillaase asayis aathii immadayis kezii Yaasona kara ellis qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Phawuloosannee Sillaase unttis benttaam ixxin, Yaasonennee ishitaypp pettii pettii ammanizita katama halaqitayiko goochchii kanggii, «Yeyititay biita ubba buqqizitay yhatti ma nuuko ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yaasone unttan fa kara gaddeeza. Yhayititay, ‹Yesuusa giz hara kaatay yeza› gi Qeesare kiita ixxizita» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Shiiqeez asaynnee katama halaqitay yeya si7in ezis hanod baz dhabeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Halaqitay Yaasonannee harita waaser bili7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ammanizitay Phawuloosannee Sillaase qammar Beera dakkeeza. Beera hellii, Ayihude Woosa Keethi geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beera asitay Teselonqqe asitaypp aadheez wozina luulita. Unttii qaala kunth wozinapp ekkeeza; gallas gallas Geeshsha Maxaafita nabbabitar Phawuloosa geezay tuma maaqqeezana shaakkii ereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yey gishos, unttapp gaamitay, Girikitayppekka bonchchintteez xiqqa maachchitaynnee dhiirathitay ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Zin Teselonqqe yez Ayihuditay Phawuloosa Xooss qaala Beera gaddekka odeezana si7ii Beera yi7ii asa buqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yeypp guye, ammanizitay ellisii Phawuloosa abba kale dakkeeza. Zin Sillaasennee Ximaatoosa Beera atteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawuloosana moyizeez asay Ateena helthii ashsheeza. Ye asay Sillaasennee Ximaatoosa unttis danda7inttiko ellsii faako ye7od garkk Phawuloosa kiitteez kiita ekkii Beera maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawuloosa Ateena Sillaasenannee Ximaatoosa naagttar, katamay eeqar kumeezana bi7ii shentteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yey gishos, Ayihude Woosa keetha Ayihuditayirannee Xoossa goynniza Ayihude maaqqekka asayir ma gabelakka fana heleez asayir ubba wode palamiza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ephiqoroosa baggapennee Isttoykantta ginttinttiz eranchitaypp pettay pettay Phawuloosar palameeza. Unttapp pettay pettay, «Yha doonanchay ab ododayis koyineshsha?» yeegeeza. Yhankkitay Phawuloosa Yesuusannee yhayiqopp denddo bagga unttis odeez gishos «Oroth eeqitay bagga odiz aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Phawuloosa aykkii Aryoospagoosa ginttiz shiiqo aqa kanggii, «Yha neenii taamarssiza orothibazay abizako nuna erisaamoo? ");
INSERT INTO mfxl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Abis giiko, neenii nuus orothibaz odizay; abizako nuunii erodayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateena as ubbaynnee ezayid yez imathitay orothibaz odinttekazarannee si7ekka peezhooya. ");
INSERT INTO mfxl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phawuloosa Aryoospagoosa shiiqeez asay tiina eqqii, «Ateena asayyo, yi Xoossitayis ubba bazar gaame yashittiza taanii bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Taanii yi katamayir yuuyttar yi goynniza aqita be7adar ‹Erinttoowa Xoossis› ginttinttii xaafintteez yarshsho aqo denggeeza. Yha yi erekkazar goynnizana taanii yinttis odiza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sa7annee sa7all yez ubba baz medhdheez Xoossay, salonnee sa7a Goday, asii keexxeez keetha yezooya. ");
INSERT INTO mfxl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","E de7onnee, shempponnee ubba baz as ubbayis inggiza gishos pacce yez as garkk as maadee koyooya. ");
INSERT INTO mfxl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Asii yezod wodayisnnee aqayis zawa inggeeza. Xoossay as zerithi ubba pettii athaypp medhdhii biita ubbayid gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","E yeya ootheezay asii eza koyoday garkkennee koyii demmaday garkkesii. Hanikokka E nuupp haakkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Yinttipp pettii pettii yexxizitay, ‹Nuunii e na7ita› geezay garkk, Nuunii ezayid pathi yezii, eni7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yikkee, nuunii Xooss na7ita maaqqiz gishos ‹Xoossay as ecetitharannee qofar worqqapp woy birapp woy shuchchapp oosintteezibaz aaziza› yeegii qoppodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yey gishos, Xoossii tiina asay erekka ootheezana ashshii aadheeza, zin yhatti ubba aqo yez as ubbay nagarapp maaqqoday garkk azaziza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Abis giiko, Xoossii fa dooreez athayir sa7all yez as ubbayil afa xillo pirdda pirddodayis qamma giigisii gaddeeza. Eza yhayiqopp denthii yeya as ubbayis tumaseeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Unttapp pettii pettii asitay yhayiqopp denddo bagga Phawuloosapp si7ii, ezal afa ari7eeza. Zin yhankkitay, «Nuunii yeya neepp gujjii si7odayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yey gishos, Phawuloosa u ganccepp kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Zin pettii pettii dhiithitay Phawuloosa hellii ammaneeza. U ganccepp Aryoospagoosa pirdde daynna Diyonasoosa ginttiz asita, Damarsso ginttiz pettii asttinnee yhankkitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yeypp guye, Phawuloosa Ateenapp kezii, Qoronttoosa qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ezayid Aqiila ginttiz Phanxoosa yelintteez pettii Ayihude as denggeeza. Ayihude as ubbay Oroomeppe kezoday garkk kaatay Qalawudoosa kiitteez gishos xiqqa wodepp tiina E fa machchat Phirisqilar Ixaalepp ye7eeza. Phawuloosa unttan hellodayis ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","E oosay unttiisay garkk dunkkaane siko maaqqeez gishos unttar bettii wolla ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Phawuloosa maala gallas ubbayid Ayihuditannee Girikita ammanthodayis Ayihude Woosa keetha unttar odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaasennee Ximaatoosa Meqidonapp yi7in Phawuloosa fa wode ubba inggii Ayihuditayis Yesuusa E, Kiristtoosa gi azala bayth markkattitar qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Zin unttii Phawuloosana ixxii eza cazhin Phawuloosa fa afilaypp buli7a tiqqisttar, «Yi suuthayis yinttan oyico; taanii yhanpp geeshsh. Yhanpp maaqqii, taanii Ayihude maaqqekka asayiko yhammada» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yeypp kezii Xooss goynniza Titosa Yosxoosa giz athay kara yhanigeeza. Yosxoosa karay Ayihude Woosa Keethay kale yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayihude Woosa Keeth halaqay Qarisphoosa fa kara as ubbayir Goda ammaneeza. Qoronttoosa asitayppekka gaamitay Xooss qaala si7eez wode ammanii xammaqintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Goday pettii qamma Phawuloosas qoncithar yi7ii, «Yashitippe; odobapp attin si77i giipe. ");
INSERT INTO mfxl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Taanii neer yeza. Taas yha katamayid, gaame as yez gishos nena qohi iita baz oothod as oonkka baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yey gishos, Phawuloosa Xooss qaala asa tamaarssittar pettii laythinnee usuppun agina unttar betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gaaloosa Akkaya biitta aqisodar Ayihuditay pettipp Phawuloosal afa denddii pirdde keethi kanggii, ");
INSERT INTO mfxl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Yha athay higge ixxii, asay Xooss goynnoday garkk udiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawuloosa nashshod hanodar, Gaaloosa Ayihuditayko, «Ayihuditayyo, yey iita ooso woy naaqo maaqqeezako taanii yi bagga danda7i si7odayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Zin qaalas, yi sunthayisinnee yi higgayis yi palamiza baz maaqqiko yi, yinttis billoytta; yeya taanii pirddaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yeezii, unttan pirdda keethaypp bale kesseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yeypp guye, as ubbay Ayihude Woosa Keeth halaqa Sosteenisa aykkii pirdde keeth tiina yhadhdheeza. Zin Gaaloosas yey abkka aazekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phawuloosa gaame gallas Qoronttoosa betteezaypp guye ammaniza asa sarothi, Phirisqilirannee Aqiilara markkaber Soora yhanigeeza. Zin E yhanigodaypp tiina ees gatho yez gishos Kinkkiroosa katamayid fa omma meedeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Unttii Efesoone hellii Phawuloosa Phirisqilannee Aqiila ezayid ashsheeza. Zin paas Ayihude Woosa Keethi gelii Ayihuditayira odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Unttii paar gaame wode bettoday garkk Phawuloosana woosseeza zin E ixeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Unttapp shaakinttii, «Xoossii giiko yinttiko maaqqii ye7oda» yeegii Efisonepp markkaber dendeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qisaare hellii Yerusalaame yhanigii woosa keeth asay sarotheezaypp guye Anxooka qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ezayid xiqqa wode gam7eezaypp guye taamarita asita ubba minthathittar Galatiyarannee Phirger aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskkinddire yeleta maaqqeez pettii Aphiloosa giz Ayihude as Efesoone qiteeza. E oda eriza asinnee Xooss qaala lo7ithii eriza asii. ");
INSERT INTO mfxl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","E Goda oga taamarii, ayyanar xuuginttii Yesuusa bagga luule odizannee tamarisiza. Hano zin, Waannisa xinqqata aadda eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","E Ayihude Woosa keetha yashittekkazar taamarsseeza. Phirisqilannee Aqiila E odizana si7ii eza paar kara kanggii Xoossa oga tiinaasaypp aathii ees odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphiloosa Akkaza yhammadayis koyin Efesoona yez ammaniza asay e qofa ekkii Akkaya yez ammanizitay eza mokkoday garkk unttis dabddaabbe xaafeeza. E ezayid hellii Xooss aadho keehetithar Yesuus Kiristtoosa ammaneezita gaame maaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yesuusa E Kiristtoosa maaqqeezana Ayihuditayis Xooss qaalaypp qonccisii woya ubbay tiina miinthii taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphiloosa Qoronttoosa yezin, Phawuloosa wookki bagga gader aadhii Efesoone helleeza. Ezayid pettii pettii ammaniza asita denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Unttanakka, «Yi ammaneez wode Geesha Ayyana ekkeenee?» yeegii oyiceeza. Unttii, «wa77a, ekkekkaya; hara attozin, Geesha Ayyana yezanakka nu si7ekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawuloosa unttiko, «Yeezin, yi abar xammaqintteenee?» yeegeeza. Unttii, «Nuunii Waannisa xinqqata xammaqintteeza» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawuloosa, «Waannisa paapp guyer yi7iz Yesuusana asay ammanoday garkk asayis odittar, maarotithis beeziza xinqqata xammaqeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Unttii yeya si7ii Goda Yesuusa tamaarita maaqqodayis E sunthar xammaqintteeza gallas gallas Geeshsha Maxaafita nabbabiza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawuloosa fa kusha unttal afa gaddin Geeshsha Ayyana unttal afa wodhdhin, duma duma doonar odintteeza; ma tinbbite odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ye aqayid taphpho nam7e maaqqiz asitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawuloosa Ayihude Woosa Keeth gelii, Xooss kaatetithii bagga yashittekkazar palamttarannee lo7ithii qonccisttar unttar hayidzii agina hellodayis gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Zin unttapp pettay pettay dhube maaqqii gaame asay tiina Goday oga cazhii ammanaam ixxeeza. Phawuloosa ammanizita unttapp shagii ekkii Xiranoosa giz timirtte keetha ubba wode unttan taamarsseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phawuloosa nam77ii layithi hellodayis qaala odeeza. Yey gishos, Iisiya yez as ubbay, Ayihuditayinnee Ayihude baazitay Goday qaala si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xoossay Phawuloosa kushe wolqqama malabazita ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yey gishos, asay e galla bochcheez maarabe woy ma7o harggintteez asayis kanggiza. Unttikka paxiza; tuna ayyanitaykka unttapp keziza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tuna ayyanita kessittar yuuyiza Ayihuditaypp pettay pettay, «Phawuloosa sabbakiza Yesuusa sunthayir kezoytta gi yinttan azaziza» yeegii, tuna gaalenitay aykkeez asitayil afa Goda Yesuusa suntha xeegeeza ");
INSERT INTO mfxl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayihude Qeese halaqitaypp petta maaqqeez Asqeewa ginttiz athayis yeya oothiza laappun dhiirath na7itay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Zin tuna ayyanay unttiko, «Taanii Yesuusakka Phawuloosa baggakka eriza, zin yinttii oonanttara?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tuna ayyana aykkeez athay unttal afa doonggii wodhdhii, unttal madoth kessii, ye karitipp kallo laasii dhabod hellodayis wolqqamii gameeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesoona yez Ayihuditayinnee Ayihude baazitay ubbay yeya si7ii iita yashitteeza. Goda Yesuusa sunthay gaame bonchintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ammanizitaypp gaamitay fa ootheez iita oosa buuxittarannee qoncce odittar yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Murunitaypp gaamitay fa maxaafita shiishii as ubbay tiina micheeza. Ye maxaafitay waagay waagay ishatam mukule bira maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Yey garkk hanii Xooss qaalay wolqqar diccittarannee dalggittar qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yey polintteezapp guye Phawuloosa, «Taanii Yerusalaame maaqqii Oroome yhammadayis beeziza» yeegii Maqadoonarannee Akkayara aadhii Yerusalaame yhammadayis qofa acceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma fana maaddizitaypp nam7ita Ximaatoosannee Erasxoosa Maqadoona kiittii, paas Iisiya xiqqa wode gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ye wode yha ogay gishos iita kachchii kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Pettii bira oothiz Dimexiroosa ginttiz athay Arxemisa eeqa kara misile birapp medhdhii gaame wodhe denggizazin. ");
INSERT INTO mfxl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yey gishos, yey garkk ooso oothizita pettipp shiishii, «Asayyo, nu duretithay yha oosaypp maaqqeezana yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Phawuloosa, yhay ‹As kushe oosintteezitay Xooss baaya› yeegii, Efesoonarannee xiqqa biittitaypp attin muume Iisa biitta ubbayil yez gaame asayis odii ammantheezannee maheeza yi be7eezannee si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Meto maaqqeezay, nu oosay leqintteezita aadda baazin Iisannee gade ubbayil yez as goynniza gita Xoossinnee Arxemisa karay odinttekka attodaynnee E damotithaykka wodhdhoday yashshiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asay yeya si7ii shener kumii, «Efisoona Arxemisa bayira» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ye uufay katama ubba helleeza. Phawuloosa laggita Maqadoona asita, Gaayoosannee Arsxirokoosa unttar wolla dafi ekkii kaa7iza aqa woxxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawuloosakka asay shiiqeez aqo gelodayis koyeeza, zin ammaneezitay eza kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iisa biitta halaqitaypp Phawuloosas zhame maaqqeez pettay pettay Phawuloosako kiittii, «kaa7iza aqo qonccer kezii benttippe» gi eza woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shiiqeez asayis hanod baz dhabeeza; gaanggiza bagga asay hara attozin abis shiiqeezako erekkazay gishos pettay pettibaz gi uukkiza ma yhankkitay hara baz gi uukkiza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayihuditay Iskkinddirose giz atha woya ganccepp tiina urqqeez, pettii pettii asay E godbaza odin Ezii asay si77i goday garkk fa kushayir mallii beezii, asayis mootinttodayis eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Zin Iskkinddire Ayihude as maaqqeez asay erii nam77ii saate maaqqod hollodayis ubbay pettii qaalar, «Efesoona Arxemisa damma» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wurssitha ye Katamitii xaafay woya si7ii udii, «Efesoona aso! Efesoona katamay gita Arxemiisas eeqa karannee salopp wodhdheez, gita shuchch naagiza maaqqeezana eroowa as oonoo? ");
INSERT INTO mfxl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Yhaya lahiza as baa maaqqiko yi si77ii godayisnnee ellisii 7iita baz oothopp naaginttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Yi yha asita, eeqa keeth miishe kasttekkazitannee nu Xoossita cazhii be7ekkazita ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yey gishos, Dimexiroosannee ezar yez oosanchchitay oorakka mootintto koykko, pirdde keethi yeza; daynnitaykka yeza; u mootodayiskka danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Zini yi hara oda koykko, Shanggo shiiqol oday bi7intto. ");
INSERT INTO mfxl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yey maaqqaam ixxiko yhayino haneezibazayis Oroome kaatetithay nuna oyicoda. Yha buqithayis gaaso baa gishos nuunii malsse mahodayis danda7ooya» ");
INSERT INTO mfxl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","yeegii shiiqa laaleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Cabbotithay hayizeezin Phawuloosa ammaniza asita xeegisii unttan minthatheezaypp guye sarothi Maqadoona yhammadayis kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","E aadhiz biittayid yez ammaniza asayis zore qaala odii minthatheezaypp guye Girike gade qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","E ezayid hayidzii agina bettii, markkaber Soora yhammadayis murttii yezin, Ayihuditay eza wodhodayis kozhizana erii Maqadoonar guye maaqqodayis kozheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Phawuloosa moyizeeza Beerappe Pharhuusa na7a Sophaxiroosa, Teselonqqepp Arsxirokoosannee Sikondduusa, Derbbepp Gaayoosa, Iisiyapp Tikiqoosa, Xirofimoosannee Ximaatoosa. ");
INSERT INTO mfxl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yeyititay tiina yhanigii nuna Xiro7aadal naagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nuunii boora Baale bonchcheezaypp guye Pilphisoosapp markkaber denddii, ichchintha gallas unttan Xiro7aada hellii ezayid laappun gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Saaminttapp tiina gallas nuunii boora wolla maadayis shiiqii yezin, Phawuloosa wonttitha yhammadayis qoppeez gishos unttis qaala odittar giddii bilahe hellodayis oda adussiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nuunii shiiqii betteez pooqayil poo7o wazhzhii geezin. ");
INSERT INTO mfxl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewuxikoosa ginttiz pettii paanthay maskkootel afa bettii, fana dogii gentteeza. Phawuloosa oda adusseezaypp Ewuxikoosa gentta aafer hayidzintho pooqaypp wodhdhii yhayqqeezana asay dentheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Zin Phawuloosa wodhdhii, ezal afa xuggunii. Eza idinggii, «E yhayqqekkaya, hirigipatte» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yeypp guye, fude pooqeel afa kezii boora baxxii meeza. Sa7a wonttod hellodayis asayis odeezaypp guye denddii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ye paxeez pantha kara kanggii gaame ufaytteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Zin Phawuloosa fana ezaypp mokkoday garkk nuus odeezay gishos nu tiinatii markkabekko yhanigii, Asoona yhammadayis denddeeza. Abis giiko, E toker yhammadayis qoppeez gishos nuna yey garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","E nuna Asoona hellin markkaber eza ekkii Mixiline ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wonttitha gallas ezaypp denddii markkaber Kiyoosas tiina baggar yez aqa helleeza; ma wonttitha gallas Saamosa piinggii kaalliza gallas Millixe helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phawuloosa Iisiya gaame gam7odayis koyekka gishos Efesoone kanttar aadhodayis qoppeeza. Paas danda7inttiko Phenxeqosxe Baale gallas Yerusalaame hellodayis ellisiza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawuloosa Miliixepp Efesoona kiittii woosa keeth cimita xeegiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Woosa keeth cimitay eziko yi7in, unttiko yhay garkk yeegeeza: «Taanii Iisa geleez tiina gallasapp aykkii yinttar yezeez wode ubbayid wayizii yezeezako yi eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayihuditay maqinttii taal afa meto helthikokka taanii haayotitharannee gaame aafuthar Godayis ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ayidekka yi kara kara yinttan tamaarssittar yinttan maaddeezaypp pettibazikka pacinchekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Taanii Ayihuditayisinnee Ayihude baazitayis nagarapp Xoossiko maaqqoday garkkennee nu Goda Yesuusa ammanoday garkk markatteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ezayid tana abi hellodazako erooya, yhatti taanii Geeshsha Ayyaanas kiitinttii Yerusalaame yhanigiza: ");
INSERT INTO mfxl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Zin Geeshsha Ayyanay achchinnee waaye tana naagizana katama ubbayid taas markkatteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Zin ta laaso polodayisnnee Goda Yesuusapp ekkeez oosa, Xooss aadho keehatith Wonggile markkattiza poliza ta shemppato pathoowa baz garkk payidiza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Taanii yhattekka Xooss kaatetith markkattittar yi ubbitay ganccer yuuyeeza. Yikkepp guye yinttipp oonkka tana be7aamana eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yey gishos, yinttipp pettii as dhabikokka ta oycinttaamana yhayino yinttis milxi udii odiza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Xooss zore ubba yinttis abikka ashshekkazar odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«Fa aaddas fa suuthar wozeez Xoossa woosa keetha naagoytta. Geeshsha Ayyanay yinttan wude henggizita udii shuumeez wudayisinnee yi ubbayis naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Taanii yhanigeezaypp guye, wudayis qadhinttoowa iita pugitay yi gancce gelodana ta eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ammanizita fa lassa kaalithiza worddo asitamaaritay yi ganccepp dendoda. ");
INSERT INTO mfxl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yey gishos, taanii hayidzii laythi qammannee gallas aafuthar yinttan ommas ommas minthatheeza qoppittar naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Yhattekka yinttan minthodayis geeshsh asayir laatisodayis danda7iza Xoossisinnee E aadho keehateth qaalayis yinttan hadara inggiza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Taanii ooppekka bira woy worqqa woy afila amottekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Taanii ta kusher oothii tanannee taar yezita koshshiza baz maaddeeza yi, yi ommas eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yi yhay garkk daaburii oothittar daabureezita maaddodayannee Goda Yesuusa, ‹Ekkizaypp inggizay anjjintteeza› geez qaala yi qoppodayis beeziza taanii yinttan ubba bazar beezeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Phawuloosa yeya odii haasii u ubbitayira gulbatii Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","U ubbitaykka Phawuloosana idinggii yeekkittar yeereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","E mahii, «Yhayinopp guye tana yi be7aamii» yeegeez qaalay unttan iita azzantheeza. Unttii markkaba hellodayis eza moyizeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nuunii Efesoona cimitaypp shaakintteezan garkk markkaber Qoose yhanigeeza. Wonttitha gallas Ruude hellii ezaypp Phaxira yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pinqqe piinggiz markkabe denggii ezayid gelii yhammadayis denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nuunii Qoophiroosa be7eezan garkk, haddirss bagga ashshii Soora yhanigeeza. Markkabay fa caana ezayid wothodayis koyeez gishos Xiroosa yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ezayid ammaniza asita denggeeza unttar laappun gallas betteeza. Phawuloosa Yerusalaame yhanggaamay garkk unttii ees Ayyanar odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nuunii unttar bettiza woday wurin kezii yhanigeeza. Unttii ubbay fa machchitayrannee fa na7itayir pettii katamapp gaxa kessii nuna moyizeeza. Nuunii abba lanqqe bunqqittii Xoossa woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yeypp guye, woli sarothi nu markkabayid geleeza; unttikka fa kara maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nuunii abbal afar oga haasii, Xiroosapp Phexelemasa helleeza. Ezayid ammaniza asita sarothi, u kale pettii gallas peezheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wonttitha gallas kezii, Qisaare yhanigeeza. Sabaake Filphoosa kara hellii e kale betteeza. E Yerusalaame tiin doorintteez laappunitaypp petta. ");
INSERT INTO mfxl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filphoosas nabe maaqqeez oyddii wudir na7itay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nuunii unddenna gallas ezayid bettii yezin Agaboosa giz nabay Yihudapp Qisaare ye7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuuko yi7ii Phawuloosapp saqqa ekkii fa kushannee fa toka accii, «Geeshsha Ayyanay yha saqqay goda, Yerusalaame Ayihuditay yhay garkk accii, Ayihude maaqqekka asayis aathii immada yeegiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nuunii yeya si7ii nuunnee ezayid yez asitay Phawuloosa Yerusalaame yhanggaamay garkk woosseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Zin Phawuloosa mahii, «Yi yhay garkk yeekkittar abis ta wozina shugishe? Taanii, Goda Yesuusa sunthay gishos achch aadda baazin Yerusalaame yhayqqodayisikka giigintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nu zora E ekkaam ixxin, «Goday shene maaqqo» yeegii si7ii geeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ezayid xiqqa wode gam7eezaypp guye giiginttii Yerusalaame yhammadayis kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qisaare yez ammaniza asitaypp xiqqitay nuur yhanigoytta geeza. Unttii nuunii shemppodayis Minasoona giz Qoophiroosa athay kara kanggeeza. Minasoona tiin ammaneez asaypp petta. ");
INSERT INTO mfxl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nuunii Yerusalaame hellin ammaniza asay nuna ufayssar mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wonttitha gallas Phawuloosa nuur wolla Yayqqoobako yhanigeeza. Woosa keeth cimitay ubbitaykka ezayid yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawuloosa unttan sarotheezaypp guye Ayihude maaqqekka asay gancce fa baggar Xoossii ootheezi bazita ubba unttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Unttii yeya si7ii Xoossa galatii Phawuloosako yhay garkk yeegeeza: «Nu ishayyo, Ayihuditay gancce aappun mukulitay Xoossa ammaneezako ne bi7iza; unttii ubbaykka higga miinthii naagiza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Neenii Ayihude baazitay biitta yez Ayihude ubbay fa na7ita dookalamay garkk, Ayihuditay woga kaallaamay garkkennee Muse higga ixxoday garkk neenii taamarssizana Yerusalaame yez Ayihuditay si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yeezin abi lo77o? Neenii ye7itha tumakka u si7oda. ");
INSERT INTO mfxl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«Yey gishos, nuunii nees odizana si7oba; gatho yez oyddii asitay nu kale yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Unttan ekkii unttara geezhoba; ma unttii fa omma meedinttoday garkk unttis miishe inggoba. Unttii tiina nees si7eezay tuma baazannee neenii ne ubbaskka higge naagiza as maaqqeezana ubbay eroda. ");
INSERT INTO mfxl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«Zin ammaneez Ayihude maaqqekka asita maaqqiko, unttii eeqas yarshintteez baz maamay garkk, suuth uzhaamay garkk, bawuta maamay garkkennee lagitaamay garkk, nuunii oda accii, unttis dabddaabbe xaafeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yeypp guye, Phawuloosa wonttitha gallas asita ekkii, yhanigeeza. E fa geezhiz gallasay ayide polinttodazako ersodayisnnee fa yarshsho ayide yarshodazako erisodayis Xooss Keetha geleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Laappun gallasay wurod hanodar, Iisapp ye7eez Ayihuditay Xooss keetha Phawuloosa bi7ii, as ubba denthithii Phawuloosa aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Isreele asayyo, nuna maaddoytta; yha athay, nu higgannee yha Xooss Karana ixxoday garkk as ubba ubba aqo taamarssiza athay yhaya. Yeykka gidaam ixxin Ayihude baazita Xooss Kara gelssii, yha geeshsh aqa tuniseeza» yeegii uukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Unttii yeya geezay tiina Efesoona Xirofimoosana Phawuloosar wola katamayid be7eez gishos yhatti Phawuloosa Xooss kara eza ekkii geleezbaz unttis aazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katama ubbay sharkkisharkeeza; asii ubbay shiiqii Phawuloosa aykkii Xooss Karapp goochchii bale kesseeza. Xooss Kara pengitay ellisii gorddintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asay Phawuloosa wodhod hanodar, «Yerusalaame katama kunithay buqqintteeza» giz oday Oroome shaalaqayiko helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Shaalaqay wottaddaritannee mato halaqita ekkii laasttar ye7eeza. Asay shaalaqannee wottaaddarita bi7ii Phawuloosa yhadhdhizana ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ye wode shaalaqay shiiqii, Phawuloosa aykkii, nam77ii santhalaater acinttoday garkk azazeeza. Yeezii, E oonazakonnee ab udeezako asa oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Asaypp baggay yhaya gi uukkodar yhankkitay yeya gi uukkiza. Cabbotay dareez gishos shaalaqay tuma shaakkodayis danda7inttaam ixxin, wotaaddaritay Phawuloosa fa yeza aqo kanggoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Phawuloosa yedhdhii kezeez detha hellodar as urqqithay gishos wotaaddaritay eza tookkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gaame asay, «E yhayqqo!» yeegii ukkittar kaaliza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wotaaddaritay Phawuloosa fa yeza aqo gelssod hanodar, Phawuloosa shaalaqayiko, «Ta nees pettibaz ododay garkk udodee?» yeegeeza. E Phawuloosako, «Neenii Girike doona erinee? ");
INSERT INTO mfxl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Neenii yhaypp tiina buqithi medhdhii shemppo wodhdheez oyddii mukule asita ekkii liizho gadha geleez Gibxxe athay nena baasa?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Zin Phawuloosa, «Taanii, Kilqqa yez erintteez Terssese katama as maaqqeez Ayihude asii. Hayyana tana asayis odisooye?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Shaalaqay eziko, «Odoba» yeegin Phawuloosa dethal afa eqqii, asay si77i goday garkk fa kusher maleeza. Asay si77i gin Ibraysxe doonar yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ta ishuntho, ta aduntho, taanii yhatti yinttis inggiza malssa si7oytta.» ");
INSERT INTO mfxl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Phawuloosa unttis Ibraysxe doonar odiza si7ii kaseesaypp aathii si7ii ateeza. E yeegeeza, ");
INSERT INTO mfxl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Taanii Kilqqa yez Xerseese yelinttii yha katamayid dicceeza. Ta asitamaaraykka Gamaalale; taanii nu aditay higga miinthii tamaareeza, yhayino yi ubbay hanizay garkk Xoossayis mishinttiza Ayihude asii. ");
INSERT INTO mfxl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Taanii yha oga kaalliza maachchitayinnee dhiirathita aykkii achch keetha olittarannee unttan wodhisod hellodayis meto beezeez asii. ");
INSERT INTO mfxl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yey garkkekka, qeese halaqaynnee Shanggo ubbay tabaz markkattodayis danda7iza. Taanii Damasqqo yez u ishitayis unttapp dabddaabbe ekkii ezayid yez asitay acinttii seerinttod garkk Yerusalaame ko7odayis yhanigeeza.» ");
INSERT INTO mfxl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Taanii yhanigii Damasqqo hellodar seeta gallas qoppekka salopp gita poo7o ta kalayir poo7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Taanii sa7a pokkii yezin, ‹Saa7oola, Saa7oola, tana abis bayi7inee?› giz qaala si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taanii mahii, ‹Godayyo, neenii oonoo?› yeegeeza. «E mahii, ‹Taanii, ne bayi7ithiz Naazirete Yesuusa› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taar yezitay poo7a be7eezaypp attin taas odiza qaala si7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Taanii, ‹Godayyo, ta ab udo?› yeegeeza. «Goday taako, ‹Denddii Damasqqo yhanigoba. Ne udoday garkk Xooss qoppeezibaz ubba baz ezayid nees odinttoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ye wolqqama poo7aypp denddeezayid ta aafay be7aam ixin, taar yez asitay ta kusha aykkii, tana goochchin Damasqqo helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Damasqqo yez Ayihude ubbay unddenna bonchchiza pettii Hanana giz athay, nu higga bonchchizaynnee Xoossa miinthii woossizay yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hanana taako yi7ii, ta kale eqqii, ‹Ta ishayyo Saa7oola, bo7oba› yeegeeza. Ellisii taanii eza be7o aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«E taako, ‹Nu aditay Xoossay neenii e shene eroday garkk, xilla be7aday garkkennee e doonapp qaala si7oday garkk tiinatii nena dooreeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ne be7eezbazinnee si7eez baz as ubba tiina ees markka maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yhatti abis gam7ee? Denddii xammaqinttoba; e suntha xeegittar ne nagaraypp meecinttoba› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Taanii guye Yerusalaame maaqqii Xooss keetha woosodar, taas qonccithii bentteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Qonccithar Goday taako, ‹Ne taas markkattiz markkatitha asay ekkeka gishos ellisii Yerusalaamepp kezoba› yeegodar ta be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Taanii, ‹Godayyo, Ayihude Woosa Keeth ubbayid nena ammanizita aykkii yadhdheezannee achch kara oleeza unttii eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Unttii ne markka Isxifaanose wodhodar taanii ye odayid asayir tobbeeza. Ma u kale eqqii eza wodheezitayis ma7o naagiza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«Goday taako, ‹Taanii nena Ayihude maaqqekka asayiko haakko aqo kiitteezay gishos denddii qitoba› » yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Phawuloosa ye qaala odii haasod hellodayis asay E giza si7iza. Yeypp guye, fa qaala dhoqq udii, «Yhaya biittaypp dhabisoba! E shemppor yezodayis beezooya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Unttii uukkittarannee, fa ma7o afa dakkittarannee baana afa denthodar; ");
INSERT INTO mfxl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Shaalaqay bi7ii wotaaddaritay Phawuloosana u fa yeza aqo kanggoday garkk azazeeza. Ma asay abis yey garkk uukkizako erodayis koyii Phawuloosa alanggar garafii pilagoday garkk unttan azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Zin wotaaddaritay Phawuloosa dafer miinthii accii garafod hanodar Phawuloosa fa kale eqqeez mato halaqitayiko, «Oroome as pirdda bayith garafizay yinttis woga?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mato halaqay yeya si7ii shaalaqayiko yhanigii, «Yha athay Oroome asii. Neenii ab oothodayis qoppeenee?» yeegii oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Shaalaqay Phawuloosako shiiqii, «Neenii Oroome aso? An taas odoba» yeegeeza. Phawuloosa, «Ee» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Shaalaqay mahii, «Taanii yha gadetitha gaame miisher wonggeeza» yeegeeza. Zin Phawuloosa, «Ta yha gadetitha yeletithar denggii ekkeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yey gishos, Phawuloosa pilagodayis qoppeezitay izir eepp shaakintteeza. Shaalaqay Oroome as maaqqeezana erii acciseezayis yashshitteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wonttitha gallas Shaalaqay, Ayihuditay Phawuloosa abis mooteezako geeshshii erodayis koyeeza. Qeese halaqitayinnee shanggo ubbay shiiqoday garkk azazeeza; ma Phawuloosa achchapp bili7isii u tiina esseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawuloosa shanggana dakkii bi7ii, «Ta ishuntho, taanii yhayino hellodayis Xooss tiina ta yess ubbayid lo77o wozinar yeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Qeese halaqay Hanana, Phawuloosa doonate baqqoday garkk e kale eqqeezana azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ye wode Phawuloosa eeko, «Naati ne borshontto tizheez gabbara aazizayo, Xoossay nena baqqoda. Neenii taal afa higge garkk pirddodayis bettii higge menth tana baqqoday garkk kiittinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Phawuloosa kantta eqqeezitay eeko, «Ne Xooss qeese halaqa cazhinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phawuloosa, «Ta ishuntho, E qeese halaqa maaqqeeza ta erekkaya; abis giiko Xooss qaalayid, ‹Ne woya aqisizayil afa iita qaala odippe› ginttinttii xaafintteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Zin Phawuloosa ye aqayid yez asaypp baggitay Saduqaawita, baggitay Ferisaawita maaqqeezana erii, «Ta ishuntho, taanii Ferisaawennee Ferisaawe na7a; ‹yhayqqeezitay yhayiqopp dendoda› gi taanii ufayisar naagiza gishos unttii taal afa pirddiza» yeegii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Phawuloosa yeya geez wode Ferisaawitay ganccennee Saduqaawitay gancce kachchii kezin shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Abis giiko, Saduqaawitay, «Yhayqqeez as dendooya; kiitanchchoka ayyankka baaya» yeegiza. Zin Ferisaawitay ubbakka ammaniza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ola uufo keseeza; Ferisaawitay bagga maaqqeez higge asitamaaritay denddii eqqii, «Yha athayil afa aba buutakka dengeekkaya; ees ayyana woy kiitanchchay odo attenna» yeegii palameeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kachchay mee7ith aykkin asay Phawuloosa shaqirchchaamaygarkk gi, shaalaqay fa wotaaddaritay wodhdhii unttan ganccepp eza ellisii kessii u fa yeza aqo kanggodaygarkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ye qamma Goday Phawuloosa kale eqqii, «Phawloosa, neenii taas Yerusalaame markkatteeza Oroomekka markkattodayis beeziza; minggoba; akko baaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wonttitha gallas Ayihuditay, «Phawuloosana wodhekazar katha maamii haath uzhaamii» gi caaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Phawuloosal afa yeya maaqqintteez asitay oytamapp gaame. ");
INSERT INTO mfxl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Unttii qeese halaqitaykonnee gade cimatayko yhanigii, «Nuunii Phawuloosa wodhekkazar katha gizibaz maamii gi caaqqeez. ");
INSERT INTO mfxl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yikkee, yinttan shanggay ebaz geeshshii pilagodibaz yez aazisii, Phawuloosa yinttiko ko7oday garkk shalaqa oycoytta. Nuunii E yha shiiqo hellodaypp tiina eza wodhodayis giigii betteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Zin Phawuloosa mishii na7ay ye maaqqintta si7ii yhanigii wotaaddaritay yeza aqo gelii, Phawuloosas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawuloosa mato halaqitaypp petta xeegii, «Yha na7ay shaalaqayis odiza baz yeza gishos eza shalaqayko kanggoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mato halaqay na7a shaalaqayiko kanggii, «Achch kara yez Phawuloosa tana faako xeegii, yha na7ay nees odiza baz yez gishos eza neeko ko7oday garkk tana woosseeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Shaalaqay na7ay kushayid aykkii, duma bale kessii, «Neenii taas ododbazay abba?» yeegii oycceez. ");
INSERT INTO mfxl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na7ay shaalaqayiko, «Ayihuditay Phawuloosa bagga kasepp miinthii pilagodayis koyeezi baz aazisii neenii wontta eza shiiqo ko7oday garkk nena woossodayis zore acceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Zin neenii unttii gizibaz si7ippe. Abis giiko, oytamapp gaame asitay Phawuloosa wodhekkazar ‹Katha maamii, haathe uzhaamii› gi caaqqii, qosinttii eza naagiza. Yhatti ne gizibaz aadda si7odayis naagiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Shaalaqay mahii, «Yhaya ne taas odeezana hara ooskka odippe» yeegii na7a guye dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Shaalaqay mato halaqitaypp nam77ita xeegii, «Qammapp hayidzii saater Qisaare yhanigodayis, nam77ii xeet wotaaddarita, laappun tam para asitannee nam77ii xeet tooranchchita giigisoytta. ");
INSERT INTO mfxl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Gade aqisiza Filkkisako Phawuloosa saror helloday garkk toga mehita giigisoytta» yeegii u azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Shaalaqay Filkkisas yhay garkk giz dabddaabbe xaafeeza: ");
INSERT INTO mfxl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Qalawudoosa Lusosappe gade aqisiza bonchcho Filkkisas, saro nees maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayihuditay yha atha aykkii wodhod hanodar, E Oroome gade as maaqqeezaya erii wotaaddaritayira hellii eza ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ta Unttii eza abis mootizako erodayis koyii unttan u shanggitayiko eza shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Unttii fa higgayis eza mooteezaypp attin eza wodhisizabaz woy acisizibaz baza ta denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Unttii yha athayil afa maaqqintteez zigirssay tana hellin, taanii ellisii eza neeko dakkeeza. Eza mootizitay ne tiina yhanigii mootoday garkk azazeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Yey gishos, wotaaddarita azazeezay garkk Phawuloosa ekkii, qamma Antiphaxirisa helitheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wonttitha gallas paar asitay eza ekkii yhammaday garkk ashshii toke asitay guye maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Togar yez asay Qisaare hellii dabddaabbe gade aqisizayis inggii, Phawuloosana e tiina shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gade aqisizay dabddaabba nabbabeezaypp guye «Phawuloosa, ne aba awurajja aso?» gi eza oyiceeza. E Kilqa as maaqqeezaya erii ");
INSERT INTO mfxl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Taanii nena mootizitay yi7iko ne giza si7oda» yeegeeza. Wotaaddaritay Phawuloosa Herodoosa zabba naaginttoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ichchin gallasappe guye qeese halaqay Hananee, cimitayirannee Xerxeluusa giz pettii afakatayir wolla Qisaare qiteeza. Unttii gade aqisizayil afa Phawuloosana mooteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Phawuloosa xeeginttii geleez wode Xerxeluusa eza yhay garkk yeegii mooteeza: «Bonchcho Filkkisa, nuunii ne baggar unddenna sarotith denggeeza, ne lo77o aqisayid nu biittay unddenna laamintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bonchchintteez Filkkisa, nuunii abakka ayidekka maaqqin unddenna galatar yeya ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Taanii nena gam7isekkazar neenii ne keehetithayir nubaz eller si7od garkk nena woosiza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Yha athay dhube maaqqii gade ubbayid yez Ayihuditay gancce cabbo medhdhii Naazirawitay bagga asa kaalithiza maaqqeezana nu ereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hara attozin, Xooss Kara tunisod hanodar nu eza aykkeeza; nu higgay gizay garkk ezal afa pirddodayis qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Zini shalaqa Luusiyosa yi7ii, wolqqar nu kusheppe eza kessii ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ezar mootinttizitaykka neeko ye7od garkk azazeeza. Neenii ne ommas yha atha pilagii nu eza mootiza moota ubba erodayis danda7iza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayihuditaykka, «Yha oday tuma» gi e qofa ma7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gade aqisizay Phawuloosa odod garkk mallin Phawuloosa yhay garkk yeegi maheeza: «Neenii unddenna wodepp aykkii, yha asayis pirddittar yezana erii taanii odayis ufayssar mahith ingiza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Taanii goynnodayis Yerusalaame kezin taphpho nam7i gallasapp aadhoozana neenii ne ommas erodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayihuditay tana Xooss kara maaqqin Ayihude Woosa kara maaqqin katama maaqqin oorakka palamodar woy as shiishii saro dhabisodayis tobbodar pettii asikka tana denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yhattekka unttii tana mootizabazayis markka denggodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«Zini taanii pettibaz ammaniza; taanii higger yezabazinnee nabitay xaafeez ubba baz ammanii, nu aditay Xoossa, unttikka worddo giz ogayir ta goynniza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Unttii fa aaddas ammanizay ta garkk xillitayinnee xillobaazitayikk yhayiqopp dendodana taakka ammaniza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yey gishos, taanii Xooss tiinannee as tiina ubba wode lo77o kaha taas yezoday garkk miinggiza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Taanii Yerusalaameppe kezeezaypp unddenna laythapp guye ta dabo manqqitayis maadee immadayisinnee yarshsho yarshshodayis Yerusalaame yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Taanii Xooss kara yeya udii qasho woga polii maaqqin tana denggeeza. Ye wode taara gaame woya baaya, kachchikka kezekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Zini Iisapp ye7eez pettii pettii Ayihuditay ezayid yeza; unttii taal afa oda koykko yi7ii tana neell afa mootodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Woy taanii shanggo tiina shiiqeez wode ootheez buuta yeziko yhayititay ne tiina yezitay odo. ");
INSERT INTO mfxl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","‹Taanii u gancce eqqii, yhayqqeezitay dendoda› gi uukkii odeez gishos yhayino yi tiina pirddas shiiqeeza, yeypp hara baz oothekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Zini Filkkisa Goday ogay bagga geeshshii ereez gishos «Taanii yi oda gachcheeza» yeegii woda adusiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mato halaqay Phawuloosana naagttar maaddod garkkennee e dabbitaypp oonkka oycodayis ye7odar kayaamay garkk mato halaqayis azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Xiqqa gallasapp guye, Filkkisa Ayihude bagga maaqqeez fa machchat Dirusillara yi7ii Phawuloosa kiittii ki7isii Kiristtoosa Yesuus ammano bagga eepp si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawuloosa xillotithi bagga, fa ubba aqiso baggannee ye7odayis yez pirdda bagga ododar, Filkkisa yashittii, «Neenii yhattes qitoba taas giigeez wode nena xeegisoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ye wode Phawuloosapp gubbo ekkodayis qoppii eza mahii mahii xeegii erii odinttiza. ");
INSERT INTO mfxl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nam77ii laythapp guye, Filkkisa aqana Phorqqiyoda Fisxoosa ekkeez. Filkkisa Ayihudita ufayssodayis kezii Phawuloosa billekka ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fisxoosa fa aqisiza awurajja gelii hayidzintho gallasapp guye Qisaarepp Yerusalaame kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ezayid qeese halaqitayinnee Ayihuditay bayiritay Phawuloosa mooteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Phawuloosana Yerusalaame ko7or paas lo77o baz oothoday garkk gi Fisxoosana u woosseeza. Yeyakka geezay ogell qosinttii eza wodhodayis unttis giigoday garkke ");
INSERT INTO mfxl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fisxoosa unttiko, «Phawuloosa, Qisaare achch kara yeza; taanii ta ubbaskka ellisii ged guye maaqqad haniza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","E buuteezbaz yezako yi gancce mawuter yezitay taar Qisaare yhanigii eza mooto» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fisxoosa u achcha hosppun woy taphphii gallas garkk gam7eezaypp guye Qisaare qiteeza. Wonttitha gallas pirdda oydel bettii Phawuloosa ko7oday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","E yi7in Yerusalaamepp ye7eez Ayihuditay e kalayid eqqii unttii lathodayis danda7oowa deexo mooto shiisheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawuloosa mahii, «Taanii Ayihude higga maaqqin Xooss Kara woy Oroome Kaata Qeesarekka qohekkaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Zin Fisxoosa Ayihudita ufayssodayis kezii Phawuloosako, «Yerusalaame yhanigii yha mootaybagga ezayid ta tiina pirddinttodayis koyinee?» yeegii oycceez. ");
INSERT INTO mfxl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Zin Phawuloosa, «Taanii pirddinttodayis beeziza Qeesare pirdde keetha eqqeeza. Neenii lo7ithii erizay garkk taanii Ayihudita abarakka qohekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yikkee, taanii qoheezibaz yhayiqoskka helthiza baz buuta ootheezibaz maaqqiko yhayiqopp tana ashshoba gamii. Zin unttii tana mootiza mootay cere maaqqiko oonkka tana unttis aathii inggodayis danda7ooya. Qeesare tabaz pirddo gi oycciza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ye wode Fisxoosa fa zoranchchitayira zorinttii, «Neenii Qeesare tabaz pirddoba gi oycceeza; Qeesareko yhanigiza» yeegii maheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Xiqqa gallasapp guye Kaatay Agirphannee Barnniiqe Fisxoosa sarothodayis Qisaare yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ezayid unttii unddenna gallas gam7in, Fisxoosa Kawayis Phawuloosa bagga yhay garkk yeegii odeeza; «Filkkisa billekka ashshii yhanigeez pettii athay yhaydda yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Taanii Yerusalaame yhanigeez wode qeese halaqitayinnee Ayihude cimitay ezal afa pirddoday garkk tana woossii ebaz taas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Taanii, ‹Mootinttiza athay tana mootizitay tiina eqqii fana mooteezbazayis mahith inggekkazin, oona maaqqikokka aadhii ingginttizay Oroome woga baaya› yeegii unttis maheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«Yey gishos, unttii yhaydda shiiqeez wode taanii gam7ekka wonttitha gallas pirdde keeth gelii Phawuloosa ko7oday garkk kiiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eza mootizitay e kanttar mari eqqii, iitabazar eza mootekka ashshenna gi taanii qoppeezay garkk eza mootekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Zin unttii fa ammano baggannee Phawuloosa, ‹E Path yeza› giz yhayqqeez Yesuusa ginttinttiz athay bagga ezar palamizaza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Taakka yha oda shaakkodayis metitheez gishos Phawuloosa Yerusalaame yhanigii, ezayid pirddinttodayis koyizako gi eza oycceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Zin Phawuloosa fa oda Qeesare billod hellodayis achch keetha gam7odayis oycceeza. Taanii eza Qeesareko dakkod hellodayis E acinttodaygarkk kiiteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Yey gishos, Agirpha Fisxoosako, «Taanii ta ubbaskka ye athay gizibaz si7odayis koyiza» yeegeeza. Fisxoosa eeko, «Neenii wontta E gizibaz si7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wonttitha gallas Agirphannee Barnniqqe gita bonchchor shaalaqitayrannee katama yez wolqqama asitayir yi7ii pirdde keetha geleeza. Fisxoosa Phawuloosa xeegisii ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fisxoosa, «Kaat Agirpha, yhaydda nuur yez asitayyo, Ayihuditay Yerusalaamekka yhaygarkk uukkii, ‹E yikkepp guye path yezodayis beezooya› yeegii, tana woosseez atha yhaya yi bi7iza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Zin eza yhayiqos helthiza baz abikka taanii denggekkaya. E fa ommas, ‹Qeesare tabaz pirddo yeegii oyceeza› geez gishos Qeesareko eza dakkodayis qofa acceeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Taanii ebaz ta kaat Qeesaares xaafisiza oge abikka baaya. Yey gishos, ebaz yi bi7iko ta xaafizay benttodazako gi yi tiina ubbarakka Kaat, Agirpha, ne tiina eza ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Abis giiko, acintteez as dhoqqa daynnas aathitar E abis mootintteezako erisekkazar ashshizay taas boozetith aaziza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirpha Phawuloosako, «Neenii ne bagga ododayis danda7iza» yeegeeza. Ye wode Phawuloosa fa kushe denthii yhay garkk yeegeeza: ");
INSERT INTO mfxl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Kaat, Agirpha, Ayihuditay tana mooteez baz ubbayis mahith inggodayis yhayino ne tiina eqqittar ta anjay lo77o gi qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Yeykka neenii Ayihude wogannee palama ubba loythii eriza yeyi gishos tana danda7ar si7oday garkk ta nena woosiza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Taanii na7atithapp aykkii ta asay ganccerannee Yerusalaame yezeez ta yessa Ayihude ubbay eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taanii tiinapp aykkii, nu ammano wogga miinthii naagiza Ferisaawitay baggaypp maaqqeezana unttii markkattodayis koykko eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yhattekka taanii Xooss nu aditayis inggod geez ufayssa naagiza gishos mootinttii yhaydda eqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ma taphpho nam77ii nu aditay sheeshay Xoossa qammannee gallas miinthii goynnittar Xooss inggod geeza ekkodayis ufayisar naagiza. Kaat Agirpha, Ayihuditay tana mootizay taanii ufayisar yeya naagiza gishos. ");
INSERT INTO mfxl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Xooss yhayqqeezita denthizaya maaqqeezay yi kantta abis ammaninttoosa? ");
INSERT INTO mfxl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Binii taanii ta ubbaskka Naazirete Yesuusa suntha ixxiza danda7intteezbaz ubba oothodayis beeziza gi qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Taanii Yerusalaame ootheezay yhaya. Qeese halaqitaypp mawute ekkii Xoossa asitaypp gaamita aciseeza. Unttan wodhodar u yhayqqodana ta doseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Gaame wode Ayihude Woosa Keeth ubbayid unttii seerinttoday garkkennee Yesuusana cazhoday garkk ta woxiteeza. Taanii aqopp aathii unttan kacceeza hara attozin, hara biitta katamita hellodayis yhanigii ta unttan bayi7itheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Taanii yha odayis qeese halaqitapp mawutennee kiita ekkii Damasqqo yhanigiza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaatayyo, taanii seeta gallas ogell yezin awa poo7opp lo7ithii aadhiz poo7o ta yuushayirannee taara yhanigizitay yuushayir salopp poo7odar be7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nuunii ubbaykka sa7a pokkeezin Ibraysxe doonar, ‹Saa7oola, Saa7oola, tana abis bayithinnee? Neenii nena caddiza biraata qakkiko nena qohiza› yeegii taas ododar si7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Taanii, ‹Godayyo, neenii oonoo?› yeegeeza. «Goday, ‹Taanii, neenii bayi7ithiz Yesuusa; ");
INSERT INTO mfxl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","zin denddoba. Yhayino neenii be7eezayppennee tiinapp ta nena beezodana haras markkattoday garkk taas oosanchcho udii nena shuumodayis nees ta benttoda. ");
INSERT INTO mfxl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isreele asitayppennee taanii nena unttiko kiittiza Ayihude baazitaypp nena ashshoda. ");
INSERT INTO mfxl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Neenii u aafa dooyoday, dhumapp poo7oko, Xalahe kushepp Xoossiko unttan mahoda. Unttii tana ammanii nagara atotith ekkoda. Xooss geeshsheez asay gancce fa laata denggoda› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kaat Agirpha, yey gishos, taas salopp bentteez qonccithayis kiitintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Zin taanii tiinatii Damasqqo yezitay yeypp guye Yerusalaamennee Yihuda biita ubbitayid yezitayinnee Ayihude baazitaykka fa nagarapp Xoossiko maaqqoday garkkennee nagaraypp maaqqodayis beeziza ooso oothod garkk qaala odeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yey gishos, Ayihuditay tana Xooss kara aykkii wodhodayis koyeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Yhayino hellodayis Xooss maadee taapp shaakinttekkaya; yey gishos, xiqqitaysinnee dammitayis markkattittar yhaydda eqqeeza. Nabittaynnee Muse hanoda gi odeezaypp hara pettibazikka taanii odeezibaz baaya. ");
INSERT INTO mfxl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yeykka, ‹Kiristtoosa waaye ekkodayis beeziza; ma yhayiqopp tiina denddii Ayihuditayisinnee Ayihude baazitayis poo7o beezodayis ees beeziza› geeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawuloosa yeya yeegii mahodar, Fisxoosa fa qaala dhoqq udii, «Phawloosa, ne eeyeeza; ne gaame timirttay nena eeyisoss heltheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Zin Phawuloosa, «Bonchcho Fisxoosa, taanii tumabazinnee beeziza baz odizapp attin eeyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Taanii qoncce odiza oda Kaatay eriza. Yha oday geema oosinttekka gishos pettakka eepp qosinttii attamaya taanii lo7ithii eriza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","«Kaat Agirpha, neenii nabita ammaninnee? Neenii unttan ammanizana taanii eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kaatay Agirpha, Phawuloosako, «Yha xiqqa saatayid tana Kiristaanee mahodayis koyinee?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phawuloosa, «Gaame wode maaqqin xiqqa wode ne aadda baazin yhayino ta oda si7iz ubbay yha achchaypp attin ta garkk maaqqoday garkk ta Xooss woosiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yeypp guye, Kaat Agriphpha, gade aqisiz Fisxoosa, Barnniqennee unttar betteez ubbitaykka denddeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Yeypp kezii yhanigttar pettay pettayir, «Yha athay yhayqqos woy achchis helthiza baz akkokka oothekkaya» yeegii odintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirpha Fisxoosako, «Yha athay ‹Qeesare tabaz pirddo› geekazako bilinttodayis danda7izazin atteeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nuunii markkaber Ixaale dakkodayis u murtteez wode kaatitay kaat wotaaddarita ginttinttizitaypp pettii Yuuliyoosa giz mato halaqayis Phawuloosannee hara xiqqa achch asita inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iisa lanqqe yez heerita yhanigodar Adiramixoosa markkabe gelii denddeeza. Maqadoona as maaqqeez Teselonqqe Arsxirokoosa nuur yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wonttitha gallas nuunii Sidoona hellodar, Yuuloosa Phawuloosas qadhinttii fa laggitayko yhanigii koshshiza baz maadinttoday garkk unttiko dakkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Yeypp denddii nu tiinar carkkiza gishos haathar teqintteez biitta, Qoophiroosar miyithii aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqqannee Phinfila yez abba piinggii Luqa yez Muura helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ezayid mato halaqay Ixaale yhanigiz Iskkinddire markkabe denggii, ize nuna geliseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nuunii gaame gallas loddera yhanigii, gaame un7ar Qanddoosa katama kale helleeza. Ezayir yhanigodayis nuna carkko kayin Salmoonar aadhii haathar teqintteez biitta, Qarxeesa miyithii aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gaame metor gaxa gaxa aykkii Laasa katamas ukke yez lo77o ginttinttiz markkabe shemppiza heera kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nuunii ezayid unddenna wode gam7eezaypp guye xooma wode aadheez gisho, markkaber yhamo metiza gishos Phawuloosa unttan zoreeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Yinttanno asitayyo, nu yhamay gita dhabonnee gaame qoho yezay taas benttiza; qohay caanal afannee markkabel afa aadda baazin nu shemppayil afakka helloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Zin mato halaqay Phawuloosa geezaypp aathii markkaba laaggizayinnee markkaba goday giza ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ye abba doonar yez katamay balggo agina aathodayis unttis giigekka gishos gaame asitay paas danda7inttiko Finqqe katama hellii balggo agina ezayid aathodayis zorintteeza. Finqqe awa gelos pude baggappennee awa gelopp sulle baggas gancce abba kantta yez markkabe eqqii caan wodhisiz aqo. ");
INSERT INTO mfxl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kawushsha sulle carkko loddar carkkeez wode fa qoppeezay garkk haneezibaz aazin denddii, markkabe eni7aamay garkk aykkiz biraata udee ekkii Qarxeesa kanttar aadheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Zin gaame gam7ekkazar «Awuraqisa» giz wolqqama gote haathar teqintteez biittapp sulle unttal afa dendeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ye gotay markkaba urqqii yhamo kayeez gishos carkkay markkabay fa doseez oge kanggoday garkk ashshii ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nuunii Qeeda giz haathar teqintteez biitta miyithi yhanigttar gaame metinttii markkabitt wogolito aykkii ashshodayis danda7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Unttii wogola pude kesseezaypp guye wodoror markkabayil afa xaaxii, miinthii acceeza. Sirtiisa giz shafel domi7inttoda gi hirgii, markkabe shaara wothii markkabay cere laaginttod garkk dakkii ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gotay wolqqamittar yhanigin wonttitha gallas caanaypp bagga abba gancce olo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Hayidzintho gallas markkabe miishe ekkii nu kushayir dhugeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nuunii gaame gallas awannee xoolintto be7ekkazay gishonnee wolqqama carkko nuul afa minggeez gishos tiinapp shemppor attoda gi qoppekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ye wode unttii unddenna gallas katha meekka gam7eez gishos Phawuloosa u gancce denddii eqqii, «Asitayyo, yi ta zora ekkii Qarxeesepp denddekkazako yha metaynnee qohay nuna hellaamizin. ");
INSERT INTO mfxl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Zin taanii yinttan yashittippate gi zoriza; abis giiko, yha markkabay dhabodaypp attin yinttipp pettii as shemppokka dhabenna. ");
INSERT INTO mfxl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Zin qamma ta ebaz maaqqeezayinnee ta goynniza Xoossay kiitteez kiitanchchay ta kale eqqii, ");
INSERT INTO mfxl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹Phawuloosa, yashittippe; neenii Oroome Kaatay Qeesare tiina eqqodayis beeziza. Yeezako Xooss ne gishos neer yhanigizita nees inggeeza› yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yey gishos, asitayyo, yashitippate. Ye kiitanchchay taas odeezay hanodana taanii Xoossal ammaninttiza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Zin carkko nuna kanggii pettii haathar teqintteez biitta gaxa oloda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Taphpho oyddantho qamma Adira Abba nuna carkkay gedennee yhana urqqodar, gidii bilahe maaqqeez wode markkabe oothizitayis biittako ukkeeza aazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Unttii ciimmotitha erodayis koyii wodoro xeera deexizabaz accii abba gancce olin, abbay hosppun tam yhadha maaqqeeza. Xiqqa gam7ii, mahii olin usuppuntam yhadha maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Unttii abba gaxa yez shuchchar domi7nttamay garkk yashittii, markkabay yhanggaamay garkk aykkiz oyddii biraatita markkabaypp guyer abba olii, sa7a wonttoday garkk Xooss woossiza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markkabel oothizitay markkabaypp woxxii kezii, markkabay yhanggaamay garkk aykkiz biraatita markkabaypp tiina baggar abba oliza aazin wogola abba gancce oleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Phawuloosa mato halaqaykonnee wotaaddaritayiko, «Yeyititay markkabayid shemppii bettam ixxiko yi attodayis danda7oowa» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yey gishos, wotaaddaritay wogolay accintteeza wodora gachchii dakkii ashsheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sa7a wonttod hanodar ubbitay kath maaday garkk Phawuloosa asayiko, «Yi katha meekka naagttar yhayinor taphpho oyddii gallas gam7eeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Yey gishos, xiqqa katha yi maaday garkk ta yinttan woosiza. Yinttis lo77o maaqqada; hara attozin yi omma binanaypp pettakka dhabaamii» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Phawuloosa yeya gi boora ekkii ubbay tiina Xooss galateeza; baxxii muntta aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ubbay miinggii fa ubbas katha ekkii meeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuunii markkabayid yezitay nam77ii xeetannee laappun tam usuppun. ");
INSERT INTO mfxl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Unttii mi mizheez wode caaneez gistta abba gancce olii markkabay deexa shawukiseeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sa7a wonttin markkaba oosanchchitay aba helleezako erekkazar, abba gaxa yez shafennee silima be7eeza. Paas danda7inttiko markkaba ye silimayiko shiishodayis qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yeezii, markkabay yhanggaamay garkk aykkiz biraatita bili7i abba gancce oleeza. Ye wode laaggiza mitha acciz wodora bili7eeza. Yeypp guye, carkkay markkaba tiina urqqoday garkk markkaba kanggiza shaara tiina baggar dhoqqi udii yhamo aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Zin markkabay shafe dethar domi7inttii mitintteeza. Markkabayis tiina baggay mooginttii eni7aam ixxin, guye baggay zulo urqqithaypp dendii meqito aykkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wotaaddaritay achch asaypp pettakka haatha yhadhdhii kezaamay garkk unttan wodhodayis tobbeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Zin mato halaqay Phawuloosa ashshodayis qopp wotaaddaritay tobba ixeeza. Haathe yhadho eriza ubbay markkabaypp haathayid doonggii doonggii wodhdhii tiinatii gaxa kezoday garkk azazeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Atteezitay sanqqal afannee, markkabe meqayil afa kezoday garkk azazeeza ubbay gaxa saror kezeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nuunii gaxa saro kezeez wode helleez haathar teqintteez biittay Malaxa ginttinttizana ereeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Malaxa asay nuna qadhdhii ufayssar ekkeeza. Ira bukkiza gishonnee meeggiza gishos tama eethii nuna ubba mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phawuloosa gaame afira shiishii tama gaddodar, shooshii tamay michcheez gishos kezii e kushayil afa xaaxinttii eza dukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Malaxa asay shooshii Phawuloosa kushayil xaaxintteeza bi7ii pettay pettayiko, «Tuma yha athay shemppo wodhdheez as; hara attozin abbapp E attinikka Xoossa pirddayppe attii path yezodayis danda7ekka» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Zin Phawuloosa fa kushaypp shoosha wuxarkkii, tama oleeza; eza akkokka qohekka. ");
INSERT INTO mfxl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Unttii, «E asetithay ayidepp ayide, eelliza woy pokkii yhayqqiza» gi naagiza. Zin unddenna wode naageezin e asetithayil abikka laamintteezbaz dhabin, «Yhay tuma Xoosse» yeegii fa qofa laammeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ye heera haathar teqintteez biittayis halaqa, Puploosa gizayis gade yeza; hayidzii gallas hellodayis e nuna siiqor mokkeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Puploosa aday oxe, misharannee gusor hargginttii woyi7ii yeza. Phawuloosa e kara gelii ees Xoossa woosseeza; fa kusha ezalli afa gaddii patheeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yeypp guye, Malaxa yez hargginttiza hara asitayikka yi7ii paxeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Unttii nuna gaame bonchcheeza; nuunii markkaber yhanigodayis denddeez wode oges beeziza baz nuus inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Hayidzii aginapp guye, Malaxa balggo aathii Iskkinddire markkaber yhammadayis denddeeza. Ye markkabayil afa Diyosqoroosa giz mentte eeqitay misile yeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirakuuse katama gelii ezayid hayidzii gallas betteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Yeypp denddii Regiyume katama helleeza. Pettii gallasapp guye, sulle bagga carkkay carkkin, wonttitha gallas Putiyoole katama helleeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ezayid nuunii pettii pettii ammaniza asita denggin, paar saamintta gam7od garkk nuna woosseeza. Yeypp guye, Oroome yhanigeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Oroome yez ammaniza asitay nu bagga si7ii, Afoosa Farusinannee, Hayidzii Aqiza aqo giz aqo hellodayis nuna mokkodayis ye7eeza. Phawuloosa unttan bi7ii Xoossa galateeza e wozinaykka miinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nuunii Oroome geleez wode Phawuloosa fana naagiza wotaaddaritayir fa aaddas bettod garkk ginttintteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Hayidzii gallasapp guye, Phawuloosa Ayihuditay halaqita faako xeegiseeza. Unttii shiiqeez wode unttiko, «Ta ishuntho, taanii nu asay woy nu aditay wogal afa aba qohokka oothekkaya, zin tana Yerusalaame accii Oroome asayis aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Unttii ta moota bi7ii yhayiqos helithiza baz taal afa abikka denggekka gishos tana bili7odayis qoppeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Zin Ayihuditay yeya ixxin ‹Tabaz Qeesare pirddo› yeegeezapp attin taanii ta gadita mootizabaz yezin baaya. ");
INSERT INTO mfxl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Taanii yinttan xeegiseezay yinttan be7adayisinnee yinttis yhaya ododadayisii. Taanii yha santhalatayir acintteezay Isreele asay naagiza ufayssay gishoss» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ayihude halaqitay Phawuloosako, «Nuus Yihudapp nees xaafintteez dabddaabbe hellekkay. Yeypp ye7eez asitaypp pettakka nees iita odeezay baaya. ");
INSERT INTO mfxl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Zin yha ne kaalliza ammana duma duma aqo asay ixxizana nuunii eriza gishos ne qofa si7odayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Unttii fa ye7od gallas Phawuloosas qamma ekkii, ye gallas gaanggii e yeza aqo ye7eeza. E wonttapp omath hellodayis Xooss kaatetithii bagga unttis markkatteeza. Ma unttii Yesuusa bagga ammanoday garkk Muse higgennee nabitay maxaafita lo7ithii tamaareeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Pettay pettay Phawuloosa geezana ammaneeza, zin yhankkitay ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Unttii woli gancce odayil ma77aam ixxeezaypp Phawuloosa pettibaz geezaypp guye yhanigeeza. E yhay garkk yeegeeza: «Geeshsha Ayyanay nu aditayis nabe Isiyaasa doonar odeezay tuma. ");
INSERT INTO mfxl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«‹Neenii yha asayiko yhanigii, yi sis si7iza, zin akaakooya; Yi be7o bi7iza, zin denggooya. ");
INSERT INTO mfxl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Yha asay wozinay muumeeza; u hayay tuleeza; u aafaykka goozntteeza. Yey baazako, unttii fa aafayir bi7ii, fa hayayir si7ii, fa wozinayir akaakii, taako maaqqodazin; taakka unttan pathodazin› yeegoba» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Yikkee, yhay Xooss atotith kiitay Ayihude baazitayis maaqqeezana eriza. Unttikka si7oda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawuloosa yeya geezaypp guye Ayihuditay woli gancce daro palamittar kezii qiteeza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawuloosa kera keetha nam77ii laythi muda betteeza; ezayid yezar faako ye7eezita ubba mokkiza. ");
INSERT INTO mfxl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yashsha baythinnee ookka kayekkazin Xooss kaatetithibaz sabbakeeza; Goda Yesuus Kiristtoosa bagga milxi udii taamarsseeza.");
INSERT INTO mfxl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yesuus Kiristtoosa aylle maaqqeez, hawaare maaqqadayis xeegintteezayppennee Xoossa Wonggile sabbakod garkk shaakintteez Phawuloosa kiitteez kiita. ");
INSERT INTO mfxl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Xoossay gaame wodepp tiina fa nabitay baggar immada geez Xooss Wonggilay geeshsha Maxaafitayid xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ye Wonggilay ashor Dawute sheeshapp yelintteez, Xooss Na7a, nu Goda Yesuus Kiristtoosa bagga odiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ma E fa geeshsha Ayyanar yhayiqopp denddii, Xooss Na7a maaqqizana damma wolqqar beezeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","E baggar Ayihude baazitay ubbitay, ammanii kiitinttod garkk Kiristtoosa sunthay gishos Xoossay aadho keehatithar hawaaretithi mawute nuus inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yesuus Kiristtoosas maaqqad garkk xeegintteezitaypp baggitay yinttana. ");
INSERT INTO mfxl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Oroome gancce yez, Xoossay qaadhizitayssinnee e geeshsh woya maaqqad garkk maraxeezitayis. Xoossa nu Adayppennee Goda Yesuus Kiristtoosapp aadho keehetithinnee sarotithay yinttis maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ubbapp tiinatii, yi ammanay biitta ubbayil sintteez gishos Yesuus Kiristtoos baggar yi gishos ta Xoossa galatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Taanii e Na7ay wonggilay bagga kunth wozinar odiza Xoossay, taanii ta woosayid ubba wode yinttan qoppizayis E markka. ");
INSERT INTO mfxl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Wurssithal, Xooss shene maaqqiko, taanii yinttiko yhammadayis ogay taasi ushachod garkk ubba wode woossiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Taanii yinttis Ayyana imotithi shagodayssinnee yinttan be7adayis laamotiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yeykka, taanii yi ammanayir, ma yi ta ammanayir miinggoday garkk. ");
INSERT INTO mfxl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ta ishuntho, taanii Ayihude baa asaypp aafe denggeezay garkk, yinttapekka aafe denggodayis yinttiko yhammadayis qoppeeza, zin tana kayeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Girike asayisnnee tamaarekka asayis ma ecitayisnnee boozitayis taas aco yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Yey gishos, Oroome gancce yez yinttiskka Wonggile ododayis ta amottiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Wonggilayir yeelataam, tiinatii Ayihudita, ezaypp Grike asayis ammanizita ubba ashshodayis Wonggilay Xooss wolqqa. ");
INSERT INTO mfxl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Xillo ammanor de7o yezoda ginttinttii xaafintteeza. Xooss xillotithay bentteeza; tiinapp aykkii wurssith hellodayis asii xillizay ammanora. ");
INSERT INTO mfxl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tumay erinttaam garkk fa iita oosor kayiza asal afannee nagara ubbayil afa, Xooss seera salopp wodhdhiza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Xoossay unttis benttodayis beeziza baz qoncciseez gishos unttii Xoossibaz eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alame medhintteezaypp aykkii, asis benttowa Xooss hanota, yeykka e medhina wolqqannee Xoossatithay e medhetithayir benttii yeza gishos asay fa iitatithis salambodibaz baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Unttii Xoossa erttar, eza bonchchekayannee galatekkaya. U qofay maaddoowa baz maaqqeeza; u akaakowa wozinay dhumeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Unttii fana ecita giza, zin boozita. ");
INSERT INTO mfxl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Dhaboowa Xoossa goynnodana ashshii, yhayqqiz as medhettithar, kafitay medhettithar, do7itay medhettitharannee ulor goochinttiza bazita aazisii ootheez misilita goynneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Yey gishos, unttii pettay pettayir borsso baz oothii, fa galla toochchod garkk Xoossay unttan u wozinay amottiz tuna oosos aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Yey haneezay unttii Xooss turotitha worddor laammeez gishonnee medhdheez Xoossa ashshii, medhetithii goynneez gishshos. Xoossay medhinas galatintteezaya. Amin7e. ");
INSERT INTO mfxl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yey gishos, Xoossay unttan u borsso amottithayis aathii inggeeza. U maachchitay paas beeziza dhiirathar aqoda ashshii, beezoowa baz hanii maachchii maachchar wolla aqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Yey garkk, dhiirathitay paasi beeziza maachchar aqiza ashii, dhiirathi dhiirathar wola aqeeza. Dhiirathi pettay pettayir amotithar xuuginttii, borsso baz ootheeza. Fa ootheez buutayis beeziza pirdde ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Unttii Xoossa erodayis ixxeez gishos beezoowa baz oothod garkk Xoossay u kaha pathaam qofas aathii inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Unttar zhucatithii, iitatithii, uuzatithii, gene, qinaate, shemppo wodho, palama, dooshanne iita amo kumeeza. Unttii zigirizita, ");
INSERT INTO mfxl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","as sunth iissizita, Xooss ixxizita, cazhizita, utirttizita, ceeqinttizita, iita baz oothodayis koyizitannee fa indisnnee fa adess kiitinttoozita, ");
INSERT INTO mfxl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","akaakozita, caaqo menthizita, siiqo baazita, qadhe baazita. ");
INSERT INTO mfxl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Yeyititay garkk oothizitayis yhayiqo beeziza giz Xoossa higge erittar, yhayitita oothiza. U paasi ooso aadda baazin oothiza yhankkitakka sabbiza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yey gishos, neno hara asal afa pirddizayyo, neenii sankke shishizabaz baaya. Neenii hara asal afa pirddittar, ye ne pirddiza athay garkk oothiko, ne, neell afa pirddiza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Yey garkk oothizitayil afa Xoossii xillo pirdda pirddiza nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Neno, yey garkk ooso oothizitayil afa pirddizayyo, unttii oothizanii garkk oothizayyo, neenii Xooss pirddapp attodbaz aazinee? ");
INSERT INTO mfxl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Woy Xooss keehetitha, garzhonnee danda7a duretitha ne leqqinee? Xoossii nees keeheezay nena nagarapp mahodayis maaqqizana eroosanee? ");
INSERT INTO mfxl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Zin yinttis minonnee maarotethi gelowa wozina yeza. Yey gishos, Xooss seeraynnee xillo pirdday benttiz gallas, neell afa pirdday kuurod garkk udiza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Xoossay pettayis pettayis e oosat garkk immada. ");
INSERT INTO mfxl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lo77o oosor miinggii, galata, bonchchonnee dhaboowa de7o koyizitayis Xoossay medhina de7o immada. ");
INSERT INTO mfxl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Zin fana siiqizita, tuma ixxizitannee iita baz oothodayis koyizitayil afa Xooss seerannee gado ye7oda. ");
INSERT INTO mfxl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Iita baz oothiz as ubbita, tiinatii Ayihudita, ezaypp Grike asa metonnee un7a helloda. ");
INSERT INTO mfxl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Zin Xooss lo77o ooso oothiz ubbayis, tiinatii Ayihuditayis, kaallii Grikes galata, bonchchonnee sarotithi immada. ");
INSERT INTO mfxl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Xoossay as aafe bi7ii shaakkooya. ");
INSERT INTO mfxl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Higge baa nagara ootheez ubbitay higge baa dhabod. Higge yezin, nagara ootheez ubbay higger pirddinttoda. ");
INSERT INTO mfxl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Xooss tiina xillizitay higge naagizitaypp attin higge sis aadda si7izita baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Higge baa Ayihude baa asay medhor higge kiittiza oothiza. Unttisi higgay baa ixxikokka unttii fa wozinar higge eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","U hanotay, higge kiitay u wozinayid xaafintteezana beeziza. Ma u kahay unttal afa markkattiza. U qofay pettii pettii toke unttal buuta gi mootiza; pettii pettii toke unttan luule giza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ta taamarsseez Wongile garkk Xoossay Yesuusa Kiristtoosa baggar as wozina gancce qosintteez qofa pirddiza wode yeyi erinttoda. ");
INSERT INTO mfxl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Zin ne nena Ayihude giza; higgel kattiza; Xoossar yez yessayid ne gayiriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ne oothod garkk Xoossii koyiz baz abizako eriza. Higge tamaareez gishos tuma maaqqizbaz shagii eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Neenii to7ita kaalithiza, ma dhuma yezitayis poo7o maaqqizana shaakkii eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Neenii higgaypp denggeez eretithayirannee tumatithayir boozita erisizannee duudita taamarssiza maaqqizana eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yeezin, ne hara as tamaarssizay ne nena abis tamaarssoosa? Neenii, «Kassitipe» gi sabakkittar, neenii ne ubbas kasttinee? ");
INSERT INTO mfxl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Neenii, «Laammippe» giittar, neenii ne ubbas laamminee? Neenii eeqa ixxittar, eeqar yez kara bonqqinee? ");
INSERT INTO mfxl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Neenii Xooss higgayid ceeqinttiza, zin higgayis kiitinttaam ixxii Xoossa yeellathinnee? ");
INSERT INTO mfxl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Geeshsha Maxaafayid, «Yi sankker Xoossa sunthay Ayihude baa asayir cazhinttiza» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ne higges kiittinttiko, ne dookalinttay adiza, zin neenii higges kiittinttaam ixxiko ne dookalintteekazay garkk maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ayihude maaqqekka as dookalinttekka yezar, higges kiittinttiko, Xoossay eza dookalintteezay garkk payidoosa? ");
INSERT INTO mfxl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Yi, Ayihude asay, yinttis xaafintteez higgaynnee dookolinttii yezin, yi higges kiitinttaam ixxiko, Ayihude baa asay dookalinttaam ixxikoka higges kiitinttii, yinttal afa pirddoda. ");
INSERT INTO mfxl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yikkee, sunthar Ayihude maaqqeez ubbitay tuma Ayihude baaya. Benttiz asho dookalinttay tuma dookalintto baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Zin tuma Ayihudetith gancce baggar Ayihude maaqqiza. Tuma dookalinttay Xooss Ayyanar haniz wozina dookolinttopp attin xaafintteez higgayid haniz galla gacho baaya. Ye athay galata Xoossapp ekkizapp attin asapp baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yeezin, Ayihudetithii ab maadee yenee? Woy dookalintto ab maadee yenee? ");
INSERT INTO mfxl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Tuma Ayihude maaqqithay gaame oger maaddiza. Ubbapp tiin Xoossay fa qaala hadara Ayihuditayis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yeezin, unttapp pettay pettay qaala ammanaam ixxiko, u ixay Xooss geeshshetitha kayinenee? ");
INSERT INTO mfxl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kayooya! As ubbay worddo maaqqikokka Xoossay tuma maaqqo. Geeshsha Maxaafayid, «Neqaalayir ne xilloda; nena mootizana pirddar laththoda» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yeezin, nu worzhay Xoossay geeshsha maaqqizana beeziza baz maaqqiko, nu waagodee? Xoossay nu nagara gishos nuul afa pirddiko, luulo baasanee? Yhaya taanii as qofa garkk giza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Yeya baaya. Yey garkk haniko, Xoossii yha alamayil afa wayizii pirddode? ");
INSERT INTO mfxl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Zin ta worddotithay Xooss tuma qoncisii, e bonchcha dammisii beeziza baz maaqqiko, yeezin, abis taal afa nagaranchcho garkk pirddinee? ");
INSERT INTO mfxl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Pettii pettii asay, «Lo77o baz ye ye7od garkk iita oothiza» yeegii tamaarssizay garkk udii tana mootiza. Yey garkk asal yi7iza Xooss pirdday beezizaya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yeezin, nuunii waagodee? Nu aathonee? Yeya baaya! Ayihude maaqqin, Grike maaqqin ubbitay nagara oommo yezana taanii tiinatii yinttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Geeshsha Maxaafayid, «Xillo as pettakka baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Akakiza as baaya, Xooss koyiz oonkka baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ubbitay balintteeza pettippe adoozita maaqqeeza haayotith oothizay baaya. Pettii askka baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","U doonay dooyintteez duufo, fa iranthayir dooshshiza. U doonaypp, shooshii marze keziza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","U doonayid camo odannee baadithii kumeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","U tokay suuth laalodayis ellisiza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","U ogayid dhabonnee daburssii yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Unttii sarotith oge erooya. ");
INSERT INTO mfxl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Fa yessayid Xoossis yashittooya» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","As ubba doona aythodayisnnee alama muumer Xooss pirddepp oommor shiishodayis, higge inggintteezay higgepp oommo aqizitayis maaqqeezana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Yey gishos, oonkka higges kiitinttii Xooss tiina xillodayis danda7ooya. Higge as ubbitay nagaranchcho maaqqeezana beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Zin yhatti higgennee nabitay markatteez Xooss xillotithay higge baazin qoncceeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Yha xillotitha, Xooss Yesuus Kiristtoosa ammano baggar as ubbas shaako baazin inggiza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Asii ubbay nagara ootheeza; Xoossii unttis inggeez bonchchaypp facceza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Zin unttii Xooss aadho keehatithar, woziza Kiristtoos Yesuusa baggar cer xilleeza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Xoossa Yesuus Kiristtoosa yarshsho udii inggeezay, eza ammaniza ubbitay e suuthayir nagara maarotith demmad garkke. Xoossay yeya ootheezay fa danda7ayir tiina nagara taybekka ashshii, fa xillotithi beezodayis. ");
INSERT INTO mfxl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Yha wodayid Yesuusa ammaniza ubba xillisor, Xoossay fa ubbas xillo maaqqeezana beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Yeezin, nu ceeqinttay aba yenee? Yeykka atteeza. Nuunii ceeqinttizay higges kiitinttiza gishonnee? Wa77a! Ammano higgerapp attin. ");
INSERT INTO mfxl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Xoossii as xillisizay ammanorapp attin higge naagor baazana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Woy Xoossay Ayihuditayis aadda Xoossonee? Ayihude baazitayis Xooss baasannee? Tuma, Ayihude baazitayiskka E Xoosse. ");
INSERT INTO mfxl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Xooss petto; Ayihuditannee Ayihude baazitayissikka ammanor xillisizay eza. ");
INSERT INTO mfxl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yeezin, nuunii higge ammano gishos shaaroda guussonnee? Yeya baaya! Higge minthodaypp attin. ");
INSERT INTO mfxl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yeezin, nu asho ade Afraame ab denggeennee? ");
INSERT INTO mfxl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Afraame oosor xilleezbaz maaqqeezako, E ceeqinttizabaz yeza, maaqqozin, Xooss tiina ceeqinttodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Geesha Maxaafay, «Afraame Xoossa ammaneeza; Xoossay yeya ezis xillotithi uddii ekkeeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Oothiza athay ekkiza damoozay, e ooso wolqqas ciginttiza acopp attin ezis imota baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Zin ooso oothowa oonkka nagaranchchana xillisiza Xoossa ammaniko, e ammanay ezis xillotith maaqqii payidinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Geesha Maxaafayid Dawute, ooso baazin Xoossii xillisiza athay ab garkk anjjintteezako yhay garkk yeegii qoncisii beeziza: ");
INSERT INTO mfxl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«U buutay atto ginttinttizitaynnee u nagaray ucintteezitay anjjintteezita. ");
INSERT INTO mfxl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Goday e nagara payidekka asii anjjintteezaya» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Yeezin, Dawute odeez anjjo dookalintteez as aaddasonee? Woy dookalinttekka asi aaddasonee? Nuunii, «geesha Maxaafay, Afraame Xoossa ammaneeza; Xoossay yeya ezisi xillotithi udii ekkeeza yeegeeza». ");
INSERT INTO mfxl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Yeezin, yey ayide hanee? Afraame dookalinttinennee? Woy dookalinttekka yezini? Dookalinttodaypp tiin haneezapp attin guye baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Afraame dookalinttodaypp tiina e ammanay ezis xillotithi maatame maaqqii payidintteezana erisodayis, e dookaloss malla maaqqeeza. Yey gishos, Afraame dookalinttekka ammanizitayisnnee ammanor xillizitayis ubbitayis ade maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","E dookalintteezitayssikka ade. Afiraame unttisi ade maaqqeezay unttii dookalintteez gishos aadda baazin E dookalinttodaypp tiin ammaneez ammana unttii kaalleez gishos. ");
INSERT INTO mfxl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Afraamesinnee e sheeshayis, «Alame ta yinttis immad» yeegeez ufayssay, Afraame ammanor xilleez gishossipp attin higge naagii poleez gishos baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Higges kiitintteezitay Xoossay immad geez ufayssa ekkizita maaqqiko, as ammano cere; Xooss ufayssaykka shaarintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Higge mentho Xooss kach ki7iza, zin higge baa aqo higge menthokka baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Yey gishos, Xoossii inggeez ufayssay ammanor ekinttiza. Yha ufayssay Afiraame sheesh ubbas Xooss aadho keehetithi baggar inggintteezana beeziza. Yeykka higge naagizitay aaddas baazin Afraame garkk ammaneez ubbitayis. Afraame nu ubbayis ade. ");
INSERT INTO mfxl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Geesha Maxaafayid, «Ta nena gaame woyitayis ade maheeza» ginttinttii Afraame gishos xaafintteeza. Yha ufayssay Afraames inggntteezay yhayqqeezitayis de7o inggizaynnee orothibaz oothiza Xoossay eza maaqqizana E ammaneez gishos. ");
INSERT INTO mfxl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Xoossay Afraames gaame zerith immadana caaqqeeza. Ufayssi oothodayis abkka danda7inttoowa wode Afraame Xoossa ammaneez gishonnee ufayis ootheez gishos gaame woyitayis ade maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Afraames xeet laythi kumod hanikokka, daabureez dhiirathettithannee Saara na7a yelodayis danda7ooza erttar fa ammanayir daaburekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Maaqqozin, E fa ammanayir miinggii Xoossayis bonchcho inggeezapp attin Xoossay inggeez ufayssa ammanaam ixxii, sidhekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Afraame, Xoossay caaqqeez caaqa polodana fa kunth wozinar ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Yey gishos, Xoossii e ammana xillotith udii payideeza. ");
INSERT INTO mfxl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Zin, «Ezis xillotitha tayibeeza» giz qaalay Afraame aaddas xaafinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ye qaalay nu Yesuusa yhayiqopp dentheez Xoossa ammaniza nuuskka nu ammano xillotithar taybinttoday garkk xaafintteezay ");
INSERT INTO mfxl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","nu nagara gishos yhayiqos aathii inggeeza; E nuna xillisodayis yhayiqopp dendeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Yikkee, nu ammanor xilleez gishos nu Goda Yesuus Kiristtoosa baggar Xooss baggar nuus sarotithi aykkoda. ");
INSERT INTO mfxl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Nuunii e baggar yhatti nu eqqeez aadho keehetithay gancce ammanor geleeza. Yey gishos, nu Xoossay bonchcha shaakinttodayis yez ufayisayir ceeqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Yey aadda baazin meto danda7a ki7izana nu eriza gishos nu meto ganccerakka ceeqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ma danda7a garzho, garzho ufayssi inggizana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nuusi inggeez geeshsha Ayyanay baggar Xoossay fa qadha nu wozina gancce gaddeez gishos ye ufayssay nuna yeellathooya. ");
INSERT INTO mfxl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nuunii haga daabureezita maaqqii yezin, Xoossii wode hellin, Kiristtoosa nagara ootheezitay gishos yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Geesh as gishos yhayqqod as waayii demmada, zin keeha as gishos yhayqqod as oonii eree benttekka attaamii. ");
INSERT INTO mfxl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Zin nuunii haga nagaranchcho maaqqii yezin, Kiristtoosa nu gishos yhayqqeeza. Xoossay nuna ab garkk qadhdhizako e qadha beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Yikkee, nuunii Kiristtoosa suuthayir xilleezbaz maaqqiko, ubbaypp aathii e baggar Xooss seeraypp attoda. ");
INSERT INTO mfxl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nuunii tiina Xoossar morkkita, zin e Na7ay yhayiqo baggar ezar igintteeza. Yeypp aathii, yhatt nuunii Xoossar dabboteez e na7ay de7o baggar nuunii attoda. ");
INSERT INTO mfxl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Yey aadda baazin yhatt nuna Xoossar dabbotheez nu Goda Yesuus Kiristtoosa baggar nu Xoossar ceeqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Zini pettii athay baggar nagara yha alama geleeza. Ye nagaray baggar yhayqqo ye7eeza. Asii ubbitay nagara ootheez gishos yhayiqo as kochch ubba helleeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Higge ingginttodaypp tiina alamel nagara yeza, zin higge baa wode nagara nagara maaqqii payidinttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Zin Addaamepp Muse hellodayis yhayiqo as ubba mooddeeza. Hara attozin, Addaama garkk higges azazinttaa ixxii, nagara oothekkazitayis gujjikka yhayiqo kawuteeza. Addaama ye7odayis yezayis aaziso. ");
INSERT INTO mfxl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Zin Xooss aadho keehatithay pettii athay nagaray garkk baaya. Pettii as nagara baggar gaame asay yhayqqeeza. Zin Yesuus Kiristtoosa baggar Xooss aadho keehetithay gaamitayis aadhii gaanggii inggintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Pettii athay nagaray ganccennee Xooss imotay gancce gaame dummatithii yeza. Pettii as nagara baggar Xoossii ezal afa pirddeeza. Zin asay gaame nagara oothikokka Xooss aadho keehetithay xillotith ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Pettii athay nagara baggar yhayiqo kawuteeza. Zin Yesuus Kiristtoosa baggar puceez Xooss aadho keehetithinnee xillotith imota ekkiza ubbay, gamii de7or yezoda. ");
INSERT INTO mfxl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Yikkee, pettii asii nagara ootheez baggar as ubbayil afa pirdda ye7eezay garkk pettii asii xillo ootheez baggar, Xoossii as ubba xillisii de7o inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Pettii asii kiitinttaam ixxeez baggar, gaame asay nagaranchcho maaqqeezay garkk pettii as kiitinttithar gaame asay geeshsh maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Asay nagara wolqqa erod garkk higge ye7eeza, zin nagara wolqqay gaanggeez wode Xooss aadho keehetithay aadhii gaanggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nagara yhayiqo wolqqar kawuteezay garkk Xooss aadho keehetithay xillotithi wolqqar kawutii, nu Goda Yesuus Kiristtoosa baggar nuna medhinas de7oko kaalithiza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Yeezin, nuunii waagodee? Xooss aadho keehetithay gaaggoday garkk nagarara miinggii wolla yezodene? ");
INSERT INTO mfxl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Wa77a, nuunii nagaras yhayqqeezibaz maaqqiko, yeezin, nuunii yhaypp wayizii nagarara yezodee? ");
INSERT INTO mfxl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nu ubbitay Yesuus Kiristtoosar petto maaqqadayis xammaqqinttii e yhayiqayid ezar petto maaqqadayis xammaqqintteezana eroosa? ");
INSERT INTO mfxl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nu xammaqqintteez wode Kiristtoosar yhayqqii moogintteeza. Kiristtoosa Xooss Aday bonchcho wolqqar yhayiqopp dendeezay garkk nuukka orothi yess yezoda. ");
INSERT INTO mfxl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nu e yhayiqayid ezar petto maaqqiko, yey garkkekka, e denddayid ezar wolla petto maaqqada. ");
INSERT INTO mfxl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nu yhaypp guye nagaras aylle maaqqaam garkkennee nu nagaranchcho asho wolqqay dhabod garkk nu cima asetithay Kiristtoosar sottintteezana eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Pettii as yhayqqiz baz maaqqiko, E nagara wolqqapp wozinttii keziza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nuunii Kiristtoosar yhayqqiko, ezar de7o yezodana ammaniza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kiristtoosa yhayiqopp dendeez gishos maaqqii E yhayqqaamizannee yhayiqo tiinapp eza mooddamizana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","E Yhayqqeez wode pettii toke wurssii yhayqqeeza, zin yhatti de7o Xoossis yeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yey garkkekka, yi nagaras yhayqqii, Goda Yesuus Kiristtoosa baggar Xoossis de7o yezana qoppoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Yey gishos, yinttii, yi asho innas kiitinttaam garkk yhayqqiz yi ashayil nagara kawuttippe. ");
INSERT INTO mfxl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ma yi aba asetith kiffle nagara oothodayis worzhe miishe uddii inggippatte. Zin yi yhayiqopp denddii, de7o yeza as garkk yi asho Xoossis inggoytta. Ma yi kunthi asho geeshsha ooso miishe udii Xoossis aathii inggoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Yi Xooss aadho keehetithay oommor yezapp attin higgepp oommor baa gishos nagara yinttan moododayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yeezin, nu waagodee? Higgepp oommor baazin Xooss aadho keehetithay oommor yeza gishos nagara wolla oothonnee? Wa77a! ");
INSERT INTO mfxl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Yi kiitinttodayis yinttan aylle udii inggiz wode ye yi kiitinttizayis aylle maaqqizana yi eriza. Yey garkkekka, yi nagaras kiitinttiko, yinttis yhayiqo ki7iz nagaras aylle maaqqiza. Woy yi Xoossis kiitinttiko xillotith ki7iz Xoossayis aylle maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kase yi nagaras aylle, zin yhatti yi yinttan aathii inggeez tuma timirttayis kunthi wozinapp kiitintteez gishos Xoossis galata maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Yi nagara aylletith achchapp bilinttii xillotith aylle maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Yinttii yi qofar daabura maaqqeez gishos taanii ooskka geliza oger odiza. Kase yinttii, yi asetith kifle ubba tunannee iita baz oothodayis aylle udii inggeezay garkk yhatt yi asetith kifle ubba geeshsh maaqqad garkk xillotithi aylle udii inggoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Yi nagaras ayllettii yeza wode xillotithis haakor yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Yinttan yhatt yeellathiza biin yi iita oosaypp aba aafe denggeennee? Yeyis wurssithay yhayiqo. ");
INSERT INTO mfxl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Zin yi nagara aylletith achchapp bilinttii, Xoossis aylle maaqqiza. Yey yinttan xillo aafe aafisiza e wursithay medhina de7o. ");
INSERT INTO mfxl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nagaras damoozay yhayiqo. Zin Xoossay, nu Goda Kiristtoos Yesuusa baggar ingginttizay medhina de7o. ");
INSERT INTO mfxl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ta ishuntho, taanii odizay higge eriza asayisii. Higge pettii asii pathi yeza wode ubba eza mooddiza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Aazisos, azin geleez astta I azinay pathi yeza wode higger ezar accintteeza. Zin I azinay yhayqqiko ezar iza caaqqeez caaqay izo mooddooya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Yey gishos, iza fa azinay pathi yezin, hara dhiirathi geliko, iza laammeezanno ginttittiza. Zin I azinay yhayqqiko, caaqay izo mooddoowa gishos iza hara azin geliko, iza laammeezanno giinttinttoya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Yey gishos, ta ishuntho, yi Kiristtoosa asho baggar higge wolqqas yhayqqii, Xoossis aafe aafodayis yhayiqopp denddeez Kiristtoosas maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nu asho amo nuna mooddin, nu yezayir higge gujjii nagara oothod garkk nuna denthithiza. Nu asho gancce iita amotithii yeza gishos nuunii yhayiqo aafe aafod garkk ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Zin yhatt nuunii nuna acceez higgayis yhayqqeez gishos nuunii higge achchapp bilintteeza. Yey gishos, orothiza Ayyana ogel Xoossis kiitinttizapp attin xaafintteez cima higges kiitinttaamii. ");
INSERT INTO mfxl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Yeezin, nu waagodee? Higge nagaranee? Wa77a! Zin higge nagara abizako tana eriseeza. Higge, «Amottippe» goozako, amotithii abizako ta eroozinii. ");
INSERT INTO mfxl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Zin ta ubba baz amottod garkk nagara higge baggar taal oge denggeeza. Higge baazako nagara yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kase higge baa wode ta pathi, zin higge inggintteez wode nagara paxxin ta ma yhayqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Taanii de7or yezod garkk Xoossay inggeez higgay taass yhayiqo ke7eeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nagara higge baggar tana dooshiza oge denggii, wodheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Yey gishos, higge geeshshii; ezar xaafintteez kiitaykka geeshshii, xillonnee lo77o. ");
INSERT INTO mfxl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yeezin, lo77o maaqqeez baz taal afa yhayiqo ke7eenennee? Wa77a! Zin nagara nagara maaqqizay benttod garkk lo77o bazar maaddinttii taass yhayiqo ke7eeza. Yey gishos, nagara nagaratithay higge baggar aadhii erintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nuunii higge ayyana baz maaqqizana eriza. Zin taanii nagaras bayizintteez asho asii. ");
INSERT INTO mfxl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Taanii oothizabaz akaakooya; taanii dosizbaz oothodana ashshii ta ixxizabaz oothiza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ta ixxizabaz oothizabaz maaqqiko, higge lo77o maaqqizana ta ma77iza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Yeya maaqqiko, ye oosa taar yeza nagaray oothizapp attin ta oothooya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Taar, yeyikka ta ashor lo77o baz baazana ta eriza. Lo77o baz oothiza amotithii taar yeza, zin lo77o baz oothodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Taanii ixxiza iitta baz oothizapp attin ta qaadhiza lo77o ootha baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Taanii ixxizabaz oothizabaz maaqqiko, yeya taar yeza nagaray oothizapp attin oothizay tana baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Yikkee, ta lo77o baz oothodayis dosodar, iitta baz ooso higge maaqqizana denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Taanii ta wozinar Xooss higgayid ufayttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Zin ta asho gancce yeza ta kaha higger olinttiza duma higge bi7iza. Ye higgay ta asho gancce oothiza nagara higges tana di77i aylle udeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Taanii wayizii sonqqeez aso? Yhayiqos kanggiz yha asetithaypp tana ashshoday oonoo? ");
INSERT INTO mfxl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nu Goda Yesuus Kiristtoosa baggar Xoossis galata maaqqo. Yikkee, taanii ta qofar Xooss higges mooddintteeza; zin ta ashayir nagara higges mooddintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Yey gishos, Kiristtoos Yesuusar yezitayis yhatt pirdda baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kiristtoos Yesuusa baggar nuus de7o inggiz Geeshsha Ayyana higgay, tana nagaranne yhayiqo higge aylletithapp kesseeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nu nagara ashay baggar, higgay daabureez maaqqeez gishos nuna ashshodayis danda7ekkaya. Xoossay fa na7a nagaranchcho as aazisor nagaras yarshsho maaqqad garkk kiittii yeya ootheeza. Yeezii, Xoossay Kiristtoosa ashay baggar nagara, nagaranchcho as gancce pirddeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Xoossay yeya ootheezay, nu asho amo koyizay garkk baazin Geeshsha Ayyanay koyizay garkk yeza nuul afa higge geesh kiitay polinttod garkke. ");
INSERT INTO mfxl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Fa asho amo garkk yezitay fana ufayssiz abaz qoppiza. Zin geeshsha Ayyana shene garkk yezitay geeshsha Ayyana baz qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Asho qofay yhayiqo, zin ayyana bagga qopo de7onnee sarotithii. ");
INSERT INTO mfxl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Asho bagga qofa Xooss kantta morkkintto Xooss higges kiitinttooya kiitinttodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Fa asho amos moodinttizitay Xooss ufayssodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Zin Xooss Ayyanay yinttar yezikonnee yinttan mooddiko, yi Ayyana shener yezapp attin asho amos moodinttenna. Kiristtoosa Ayyanay baa oonkka Kiristtoosa baz baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Zin Kiristtoosa yinttar yeziko, yi ashay nagara baggar yhayqqeeza. Zin yi ayyanay xillotithi baggar de7o yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Zin Yesuusana yhayiqopp dentheez Xooss Ayyanay yinttar yeziko, Kiristtoosa yhayiqopp dentheez Xoossay, yinttar yez fa Geeshsha Ayyanayir yhayqqiz yi ashayis de7o immada. ");
INSERT INTO mfxl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Yikkee, ta ishuntho, nuul aco yeza nu asho shenes yezodayis nu ashos baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Yinttii, yi asho amos yeziko yhayqqodayis yeza, zin geeshsha Ayyana wolqqar nagara ooso wodhiko yi de7or yezoda. ");
INSERT INTO mfxl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Xoossa Ayyanay kaalithiza ubbay Xoossis na7ita. ");
INSERT INTO mfxl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nuunii, «Aabbo, Adayyo» yeegii xeegiz, Xoossis na7ita udiza geeshsha Ayyana ekkeezaypp attin maaqqii yashshar yezodayis aylle udiz ayyana ekkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Xooss Ayyanay nu ayyanayir maaqqii nu Xoossis na7ita maaqqiza markattiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nuunii e na7ita maaqqiko Xoossa laattizita; Kiristtoosar wolla yeya laattoda. Ma nuunii Kiristtoosar meto ekkiko ezar wolla e bonchcha shaakinttoda. ");
INSERT INTO mfxl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nuunii yhatt waayinttiza waaya, tiinapp nuus benttod bonchchayir wolihelthi be7adar, abikka aazii benttoza ta qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Medhetithii ubbitay Xooss na7itay qonciitha gaame laamothar naagiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Medhetithii ubbitay cere bazis moodintteeza; yeykka, medhetithii dooror baazin ufayssis moodinttod garkk ootheez Xooss shener haneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Medhetithay fa ommar dhabisiza aylletithipp wozinttii, Xooss na7itayir wolla bonchcho wozo shaakinttoda. ");
INSERT INTO mfxl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Medhetithay ubbay yhanno hellodayis iqithii aykkeez maachch garkk oolerannee metor yezana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ma medhetith aadda baazin Geesha Ayyana bayra imota garkk ekkeez nuunii, nu ubbas nu ashayis wozo maaqqeez Xooss na7ita maaqqad ufayss naagttar nu ashayir oolliza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Yha ufayssayir nuunii paxeeza. Zin nuunii ufayss oothizabazay benttiz maaqqiko yeya oonii ufayss udee? ");
INSERT INTO mfxl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Zin nu be7ekka baz demmada gi ufayssar naagiko yeya danda7ar naagiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Yey garkk Geesha Ayyanay nu daaburssa maaddiza. Nuunii Xoossa wayizii woossodayis beezizako erooya, zin Ayyanay fa ubbas, asii ododayis danda7inttoowa qaalar nuus gaanatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ma as wozina eriza Xoossay, Geesha Ayyana qofay abizako eriza. Geesha Ayyanay Xooss shenay garkk geeshshitayis gaanatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Xoossa qadhdhizitaysinnee e shenay garkk xeegintteezitayis Xoossay ubba baz lo77os oothizana nu eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Xoossay tiinattii ereezita fa Na7a aazod garkkera na7aykka gaame ishitay ammanizitay gancce bayra maaqqad garkk unttan dummassii gaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Xoossay tiinattii qoppii gaddeezita xeegeeza; xeegeezita xilliseeza; xilliseezita ma bonchcheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Yeezin, nu yha ubbayis waagodee? Xoossay nu bagga maaqqiko nuuri oonoo eqinttoday? ");
INSERT INTO mfxl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","E hara attozin, fa na7ayis qadhdhekazar, nu gishos aathii inggeeza. Yeezin, fa gazza na7a nuus aathii inggeezay wayizii ubba baz cer inggaamo? ");
INSERT INTO mfxl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Xoossii dooreezita mootoday oonoo? Xillisizay Xoosse yeezin pirddoday oonoo? ");
INSERT INTO mfxl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yhayqqeezay yhayiqoppekka denddii Xooss ushachcha betteez, Kiristtoos Yesuusa, E nuus gaanatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yikkee, nuna Kiristtoosa siiqopp shaakkoday oonoo? Metone woy waayenee woy bayi7ithonee woy nayenee woy kallotithonee woy yashshanee woy olanee? ");
INSERT INTO mfxl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Geesha Maxaafayid, «Nu ne gishos ubba gallas butinttiza; shukinttiza duritay garkkekka taybintteeza» ginttinttii xaafintteezay garkk maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Zin nu yha ubbayid nuna qadhdheez Kiristtoosar gamiz ubbitaypp aadhiza. ");
INSERT INTO mfxl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Yey gishos, yhayiqo maaqqin yess maaqqin kiitanchchita maaqqin moddizita maaqqin yhatt yezana maaqqin tiinapp ye7oda maaqqin wolqqamita maaqqin, ");
INSERT INTO mfxl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Dhoqekka maaqqin ziqqekka maaqqin aba medhetithi maaqqin nu Goda, Kiristtoosa Yesuusar yeza Xooss siiqayipp nuna shaakkodayis danda7oozana taanii eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Taanii Kiristtoosar maaqqii turo odiza, worddotooya. Geeshsha Ayyanay kaalithiza ta kahay taanii worddotoozana taas markkattiza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ta wozinar Isra7eelitayis gaame qofarannee duuxoowa un7ara qamma gallas ta qoppiza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Taanii, taas ashor dabo maaqqeez ta ishitay gishos Kiristtoosapp shaakinttii Xooss baadith gancce yezeezako dosizazin. ");
INSERT INTO mfxl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Unttii Isra7eelita, Xoossay unttan fa na7ita udeeza, fa bonchcha unttis qoncce odeeza. Unttar caaqqeeza; higge unttis inggeeza. U Xoossa goynnod tuma oga beezeeza; Xoossay ufayis qaala unttis inggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","U yeletithayid mayzitay kochch; ma Kiristtoosa ashor kochche maaqqii ye7eeza. Ubbaypp aadho maaqqeez Xoossay medhinas galatintto. Amin7e! ");
INSERT INTO mfxl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Maaqqozin, Xoossa qaalay polinttekka atteeza guus baaya. Isra7eelepp yelintteez as ubbitay Isra7eele baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ma Afraame zare ubbitay Afraame na7ita baaya. Xoossay Afraames, «Ne sheeshay Isaaqa baggar xeeginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yeya guussay ashor yelintteez na7itay ubbitay Xooss na7ita baaya. Zin tuma Isra7eele na7itay Xoossay geleez qaalay garkk yelintteez na7ita. ");
INSERT INTO mfxl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Inggoda gi geleez qaalay, «Taanii layth wode yhannode ye7oda; Saarakka dhiirathi na7a yeloda» yeegintteezanno. ");
INSERT INTO mfxl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Yey aadda baazin Irbiqa ma pettii nu ada Isaaqar aqi wodexeez wode. ");
INSERT INTO mfxl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Mentte na7itay yelinttodaypp woy iita woy lo77o udekkazin xeegizaypp attin oosopp baazin dooro Xooss qofay miinggoday garkke ");
INSERT INTO mfxl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","«Bayray geedayis haarinttoda» yeegii Goday iis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Yeykka Geeshsha Maxaafayid, «Yayqqooba dosii, Eesawe ta ixxeeza» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Yeezin, nuunii waagodee? Xoossay ase asapp qurinee? Xoossii quriza godayiss nu danda7ooya! ");
INSERT INTO mfxl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Goday Museko, «Ta maarodayis koyeezitana maaroda; ta qadhinttodayis koyizayis qadhinttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Yikkee, Xooss dooro as shener woy as oosor baazin e maarotithayira. ");
INSERT INTO mfxl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Geesha Maxaafayid, Gibxxe kaatayiko, «Taanii, ta wolqqa neell beezodaysinnee ta sunthay alame ubbayil erinttod garkk yeyis nena kawutiseeza» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Yikkee, Xoossay maarodayis koyizana maariza; wozina muumisodayis koyizay wozina muumisiza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yinttipp pettay, «Yeezin, Xoossay as abis boree? Xooss ixxizay oonoo?» yeegii oycodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Zin neno aso, Xoossar palamodayis ne oonoo? Ooso fana ootheezayiko, «Tana yhay garkk udii abis ootheenee?» gi oycodayis danda7inee? ");
INSERT INTO mfxl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Woy urqqa medhdheezay pettii urqqapp petta bonchcho miishe, yhankka ma tooshe miishe udii medhdhodayis mawute baasannee? ");
INSERT INTO mfxl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Xoossay fa seera beezodayisinnee fa wolqqa ersodayis koy dhabos giigsseez seera miishshita gaame garzhor danda7eezako ab eree? ");
INSERT INTO mfxl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","E yeya ootheezay damma bonchos giigiseez, fa dooreez na7itayis fa bonchcha ersodayisii. ");
INSERT INTO mfxl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ayihude maaqqin, woy Ayihude baa as ubbita Xoossii dooreeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nabe Hosa7e maxaafay gancce, «Ta woya baazitakka, ‹Ta woya› gi xeegoda. Dosinttekka woyitakka, ‹dosintteezita› gi xeegoda. ");
INSERT INTO mfxl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Unttii ‹Ta woya baaya› ginttinttii xeegintteez aqayid, ‹De7o Xooss na7ita› ginttinttii xeeginttoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nabe Isiyaasa Isreele as baz, «Isreele as abba shafe garkk gaanggikokka, unttapp xiqqa as aadda attoda. ");
INSERT INTO mfxl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Goday biitta ubbayil afa ellis murttii ukker yhaya udoda.» ");
INSERT INTO mfxl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Maakka Isiyaasa, «Ubbapp Wolqqama Goday nuus xiqqa zerith ashshekkazako, nuunii Soodomannee Gamoora katama garkk dhabodazin» yeegii tiinattii odeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Yeezin, nu waagodee? Xillotith koyibe7ekka Ayihude baa asay ammanor xillotithi denggeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Zin xillotithayiko helthiz higge yeza Isreele asay xillotithi denggekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Abis denggekkasa? Unttii xillotith ammanor baazin oosor ekkodayis kozheez gishos. Yey gishos, unttii, «Dhubbiza shuchchar» dhubintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Maxaafayid, «Bo7oytta taanii Xiyone dhube shuchchinnee fokkisiz zaalla gaddoda. Eza ammaniza oonkka yeellatenna» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ta ishuntho, ta kunthi wozinar ta amottizaynnee Xoossa woossizay Isreelitay attod garkke. ");
INSERT INTO mfxl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Unttii Xoossis micinttizazin, tuma eretith dhabor micinttoozana ta markkattiza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Unttii Xooss xillotith oge eraam ixxii, fa aadda xillotith kaalleezapp attin Xooss xillotith koyekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","As ubbay ammanor xillod garkk Kiristtoosa higges folo maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Muse asii higge naagii ekkiz xillotithibaz, «Higge naagiz oonkka ye higga naageezay garkk de7o yezoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Zin ammanor ekkiz xillotith bagga giinttintteezay yhaya: «Ne wozinar, ‹Oonii salo kezode?» yeegippe; yey Kiristtoosa wothodayis. ");
INSERT INTO mfxl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Woy, «Sulle sa7a oommo wodhdhoday oonoo?» giippe; yey Kiristtoosa duufopp kessodayis. ");
INSERT INTO mfxl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Zin yeegii xaafintteez: «Qaalay ne kale yeza; ne doona ganccennee ne wozina gancce yeza» Nuunii yinttis odiz ammano qaalay yhaya. ");
INSERT INTO mfxl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","«Yesuusa Goda» gi ne doonar markkatikonnee Xoossay eza yhayiqopp dentheezana ne wozinar ammaniko, ne attoda. ");
INSERT INTO mfxl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Asii fa wozinar ammanii xilliza; fa doonar markkattii attiza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Maxaafay, «Eza ammaniza oonkka yeellattenna» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Pettii Xoossay ubbitay Goda maaqqeez gishos Ayihuditay ganccennee Ayihude baa as gancce dummatithii baaya. E fana xeegiz ubbayis gaame keeha. ");
INSERT INTO mfxl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Goda sunth xeegiz oonkka attoda. ");
INSERT INTO mfxl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Yeezin, unttii ammanekka yezttar wayizii eza xeegodayis danda7ee? U ebaz si7ekka yezttar wayizii eza ammanodayis danda7inee? Ma unttis qaala odiz as baazin, wayizii si7odayis danda7inee? ");
INSERT INTO mfxl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kiitintteez asii baazin qaalay wayizii odinttodayis danda7ee? Maxaafayid, «Ufayss wonggile odiz asis tokitay waafa lo77ineshsha» yeegii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Zin Isiyaasa, «Godayyo, nu markkatith oonii ammaneenee?» yeegeezay garkk, ubbitay wonggile ammanekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Yey gishos, ammanay sisapp yi7iza; sissi Kiristtoosa qaalapp yi7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Maaqqozin, u Qaala si7ibe7ekka guussonnee? Wa77a si7eeza. Maxsaafayid, «U oday biitta ubbayil sintteeza, u qaalay sa7a gaxa helleeza» yeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Zin Isreele asay erekkaya guussonnee? Muse tiina, «Taanii yinttan leqqintteez asay gancce qiirisoda; ma akaakowa asay gancce yinttan yilosoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ma Isiyaasa, «Tana koyekka asayis ta bentteeza; tana oyccekka asayis ta tana beezeeza» yeegii yashittekkazar odeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Zin Isayaasa Isreelitay bagga odittar, «Gallas muda kiitinttoowa asaayssinnee tana ixxiza asayis ta kushe miicceeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","An ta oyciza: yeezin, Xoossay fa woya olii ashshenenee? Ashshekkaya! Taanii ta ubbas Isreele; Afraame sheeshii; Biinama kochche. ");
INSERT INTO mfxl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Xoossay tiin dooreeza asita olooya. Maxaafayid, Eelaasa Isra7eelita Xooss tiina wayizii mooteezako, yi eroosanee? ");
INSERT INTO mfxl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Eelaasa, «Godayyo, unttii ne nabita wodheeza, ne yarshsho aqakka laaleeza. Ta ta aaddas atteeza; unttii tanakka wodhodayis koyiza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Xoossay eeko waagii maheene? «Ba7aale giz eeqas goynnekka laappun mukule asii taasi ashsheeza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Yey garkkekka, yha wodayid Xoossay fa aadho keehatithar maraxeez xiqqa xiqqitay isreele yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","E unttan dooreezay fa aadho keehetithayirapp attin u oosor baaya. Dooray oosor maaqqiko, e aadho keehetithay cere atteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Yeezin, waayenee? Isreelitay fa koyiz baz denggekkaya, zin Xoossii dooreez xiqqitay denggeeza. Atteezitay fa wozina muumiseeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Yeykka, Maxaafayid, «U aafey be7aamay garkk u hayay si7aamay garkk, yhanno hellodayis unttis; Xoossay azaalla ayyana inggeeza» ginttinttii xaafintteezay garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ma Dawute, «U miiz leematay unttan xikennee olla aykko; unttan gol7isiza gaga maaqqo; u iitatithay unttan hello. ");
INSERT INTO mfxl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","U be7ekkazay garkk u aafay aykkintto; ubba wode meto unttan kuuniso» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Yeezin, Dhubintteezitay pokkod garkkennee? Yeya baaya! U wodhithay Ayihude baa asay attod garkk sankke maaqqeeza. Yeykka Ayihuditay unttal afa qinaatamay garkk udeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ayihuditay nagaray alamayis gaame anjjo ke7eeza; ma u gaminttithay Ayihude baa asayis gaame anjjo maaqqeeza. Yeezin, doorintteez Ayihuditay kunthi attiz wode anjjo ab garkk darodeshsha? ");
INSERT INTO mfxl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Taanii, yinttis Ayihude baa asayis odiza. Ayihude baa asayis hawaare maaqqii oothizayira taanii gaame ceeqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ta yeya ootheezay taass asho dabbo maaqqeez Isreelitay qiirssi unttapp xiqqita ashshodayisii. ");
INSERT INTO mfxl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Xoossay unttan olii ashsheez wode yha alamay Xoossar dabbotteeza. Xoossay unttan shiishii ekkiza wode yhayqqeez asii yhayqqopp denday ab garkk maaqqodayis danda7ee? ");
INSERT INTO mfxl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tiina oleez munuqay lo77o maaqqiko yhankkaykka geeshshii. Mithis xapho geeshshii maaqqiko, shaqaykka geeshshii maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Gade tukkeez woyira shaqo karinttin, yinttii wora doleez woyira shaqo maaqqeezitay u aqaydd dhanthisinttii xaphor keziz zayite shaakintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Yikkee, yinttii shaqogarkk karinttii wodhdheezayil afa utirttippate. Yi utirttizabaz maaqqiko, xaphay yinttan tookkeezapp attin yi xapha tookkekkaza akaakoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Neenii, «Ye shaqitay karintteezay, tanii u aqayid dhandinttodaygarkke» yi godayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Yeyi tuma. Unttii ammanaam ixxeez gishos karintteeza. Neenii ammaneez gishos ye aqayid eqqeeza. Ne yashittodayis beezizap attin utirttodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Xoossay medhintto shaqo maaqqeez Ayihuditayis qadhinttaam ixxiko yinttisikka qadhdhenna. ");
INSERT INTO mfxl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Yikkee, Xoossii ab garkk keehazakonnee ab garkk minithizako bo7oytta. E minthatithay fokkeezitayis, ma E keehizay yinttisii. Miinggii eqqaam ixxiko yinttikka gachinttoda. ");
INSERT INTO mfxl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Unttii ammaniko, tiin fa yeza aqa maaqqoda. Xoossay wolqqama unttan mahii, gaddodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yinttan wora yezi woyira maaqqeezita gachchii, karacha tukintteez woyirayil afa yinttan tukkiko, medhintto gade woyira maaqqeezita tiina aqayid mahii tukkodayis wayizii danda7inttoosa? ");
INSERT INTO mfxl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ta ishuntho, yi yinttan era gi gaayirppate. Ta yinttis odiza pettii xuurod baz yeza. Yeykka Isra7eelitaypp baggitay wozina miinthii si7aam ixxeezay wurssithii hellodayis baazin attodayis yez Ayihude baa asitay ubbay kunthar Xoossiko ye7oday garkke. ");
INSERT INTO mfxl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Yey garke, Isreele asitay ubbitay attoda. Maxaafayid: «Nuna wozizay Xiyoonepp ye7oda; Yayqqooba zerithapp iita ubba dhabisoda. ");
INSERT INTO mfxl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Taanii u nagara atto gizay unttar caaqqod caaqay yhaya» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Wonggile ekkaam ixxii, yi gishos morkke maaqqeeza. Maaqqozin, yhattekka unttii doorintteezita, Xoossii u aditay gishos unttan qaadheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Xoossii fa imayraannee fa xeessayir qiirattoya. ");
INSERT INTO mfxl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Yinttii tiin Xoossayis kiittinttekka. Zin yhatt Ayihuditay kiitinttaam ixxin, yi Xooss maarotith ekkeezita. ");
INSERT INTO mfxl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Yey garkke, yi ekkeez maarotitha Ayihuditay ekkod garkk u yhatt Xoossis kiitinttaam ixxeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Xoossii as ubbita fa maarotitha beezodayis koy, asii ubbitay kiitinttaam ixxoday garkk gorddeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Xooss duretitha, eccetithannee eretitha akaakii ododay oonoo? E pirdday pilaginttooya, e ogay erinttooya. ");
INSERT INTO mfxl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Maxaafayid, «Xooss kaha erizay oonoo? Eza zorodayis danda7izay oonoo? ");
INSERT INTO mfxl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Xoossis tali7izaynnee tali7e mahii ekkizay oonoo?» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ubbay eep; ezarannee eesii; Ees medhinas bonchcho maaqqo. Amin7e. ");
INSERT INTO mfxl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Yikkee, ta ishuntho, yinttii, yi asetitha Xooss ufayssiza, pathinnee geeshsha yarshsho udii, immad garkk ta yinttan Xooss kehatithayir woossiza. Xoossa yi goynnodayis beeziza tuma ogay yeya. ");
INSERT INTO mfxl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Lo77o, ufayssizannee folo maaqqeez Xoossa kiita yi shaakkii erodayis yi qofar laaminttoyttapp attin yha alama aazippate. ");
INSERT INTO mfxl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Xoossii yinttis pettayis pettayis inggeez ammanay garkk kahar yez asi garkk qoppoytta. Qoppodayis beezizaypp aathii yinttan dummasii, utirar qoppipate gi taas inggintteez aadho keehatithayir yinttis odiza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nu pettii asetithayil afa duma duma kifilitay yeza; ye duma duma kifilitayis duma duma ooso yeza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Yey garkk, nuunii gaame as maaqqikokka Kiristtoosar pettii asho maaqqeeza. Nuunii pettii asho maaqqii duma duma kifilitay pettay pettayira aykintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nuus inggintteez aadho keehatithar duma duma imotitay yeza. Nu imotithay tinbbite odo maaqqiko, nuus yez ammanay garkk ododayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Nu imotithay hara as maadee maaqqiko, ye oosayir minggodayis beeziza; taamarsso maaqqiko, ye tamaarssayir minggodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Nu imotithay hara as zorith maaqqiko, miinggii zorodayis beeziza. Nu imay nuuss yeza bazapp hara asis imo maaqqiko, wozinapp inggodayis beeziza. Nu imay aqiso maaqqiko, miinggii aqisodayis beeziza. Nu imay hara asis keehith maaqqiko, ufayisar keehodayis beeziza. Nu imay maaro maaqqiko ufayisar maarodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Yi siiqqay qoodhepp qommo maaqqodayis beezooya. Iita baz ixxoytta; lo77o baz miinthii aykkoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Pettay pettayira woli ishegarkk dosinttoytta; pettay petta bonchchoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Oosor azallippate miinggoytta; yi ayyanar xuuginttii Godayis moodinttoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Xoossii inggeez ufayssayir ufayttoytta; meto danda7oytta; ubba wode Xoossa woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ammaniza geeshshita koshshiza bazar maaddoytta; imathita mokkodayis miinggoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Yinttan bayi7izita anjjoytta; anjjoyttapp attin baaddippate. ");
INSERT INTO mfxl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ufayttizitayir ufayttoytta; yeekkizitayir yeekkoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Pettay pettayir pettii qofar yezoytta. Utira qofa ashshii, haayotithar yezodayis miinggoytta. Yi yinttan eca gi qoppippate. ");
INSERT INTO mfxl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Oonkka yinttis iitta baz oothiko, ye athayis iita baz mahippate. Ubba as tiina sabbisiza lo77o ooso oothoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Yinttis danda7inttiko ubba asar saro yezoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ta ishuntho, yinttii, yi ubbas asis kushe kessippatte. Xoossii kushe kessoday garkke ezis ashii ashshoytta. Geesha Maxaafayid, «Ta kushe kessoda; taanii kushe mahoda» yeegeeza Goday, ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Zin Geesha Maxaafayid, «Ne morkkay nayinttiko muzoba; E saaminttiko ushshoba. Ne yeya oothiko e ommayil tama qaaqa kaachiza» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Iita lo77or gammoyttapp attin iitar gammippatte. ");
INSERT INTO mfxl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Aba mawutekka Xooss shener ingginttiza gishosinne yhatti mawuter yezitaykka Xooss shener mawute ekkeez gishos asii ubbay gade aqisizitayis azazinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Yey gishos, mawuter yezitayis kiitinttaam ixxiza oonkka Xooss kiita ixxiza. Kiitinttaam ixxiza oonkka faal afa pirdda ki7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Aqisizitay iita baz oothizitapp attin lo77o oothizita yashisooya. Aqisizitayis yashttamayis koyinee? Yezako lo77o baz oothoba; nena galatoda. ");
INSERT INTO mfxl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Unttii nees lo77o baz oothodayis shuumintteez Xooss aylle. Zin neenii iita baz oothiko, unttii iita baz ootheezana seeriza gishos ezis yashittoba unttii qawa aykkeezay cere baaya. Unttii iita baz oothizita seerii, Xooss kaccizana beeziza Xooss aylle. ");
INSERT INTO mfxl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Yey gishos, Xooss kachch aaddas baazin yi kahay markkattiz gishos gade aqisizitayis kiitinttodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Yi giira giirizaykka yey gishosii. Gade aqisizitay ye oosa oothizay, unttii Xooss ayllita maaqqeez gishshos. ");
INSERT INTO mfxl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ubbayis beezizana inggoytta. Giira beezizitayis giiroytta; qaraxe beezizitayis qaraxe gachoytta; yashittodayis beezizitayis yashittooytta; bonchcho beezizana bonchchoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Pettay pettayir siiqinttoytta. Siiqo acopp attin yinttal afa hara aco yezippe. As dosiza oonkka higgay gizana poleeza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«Laammippe; wodhippe; kasttippe; wordo markkatippe, amottippe» giz azazaynnee hara azazo ubbay, «Ne zhama ne ubbay garkk qadhdhoba» giz azazayir acintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Siiqo fa zhamayil afa iita baz oothooya. Yey gishos, siiqo higges folo. ");
INSERT INTO mfxl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Genttapp yi barkkiza woday yhatti helleez maaqqeezayis layitha eroytta. Nu attotith woday tiin nu ammaneez wodepp aathii yhatt nuuko ukkeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Qammay aadheeza; gallasay ukkeeza. Yikkee, nuunii dhuma ooso ashshii poo7o ola miishe wolla aykkoda. ");
INSERT INTO mfxl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","An gallas poo7o yez as garkk wolla maarar yezoda. Yeththarannee Mathera, laamerannee qayixera palamarannee qinaatera maaqqippe. ");
INSERT INTO mfxl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Goda Yesuus Kiristtoosana ma77oytta; yi nagara oothiz ashay fa inna polod garkk ezis qoppippate. ");
INSERT INTO mfxl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ammanor daabureez oonakka shiishii ekkoyttapp attin e qofayil afa pirddippate. ");
INSERT INTO mfxl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Aazisos, ammanor minggeez pettii as aba kathakka maadayis danda7iza. Zin ammanor xaalekka as atakiltte aadda miiza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Miiz as moowa atha borippe. Moowa as miiz athayil pirddippe. Xoossii ubbita ekkeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Hara as ayllel afa pirddizay neenii oonoo? E daaburin woy minggin fa Godayisii. Goday eza essodayis danda7iza gishos E miinggii eqqoda. ");
INSERT INTO mfxl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ma «Pettii gallasii yhankko gallasaypp aadhiza» yeegii qoppiza asii yeza. Haray ma, «Gallasitay ubbitay wol garkk gina bonchor yeza» gi qoppiza. Zin pettay pettay fa qofa akaakii acco. ");
INSERT INTO mfxl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Gallas bonchchiz oonkka Godayis gi bonchchiza. Ubba katha miiz asii Goday bonchchos gi miiza. E miiz ye kathat gishos Xoossa galatiza. Ubba katha moowa asii Goday bonchchos mooya; ma meekka ashorakka Xoossa galatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nuupp oonkka paas baaya; ma nu ganccepp oonkka paas yhayqqaam. ");
INSERT INTO mfxl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nu shemppor yeziko Godayis yezoda; ma yhayqqikokka Godayis yhayqqoda. Yikkee, nu shemppor yezin woy yhayqqin Godayisii. ");
INSERT INTO mfxl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kiristtoosa yhayqqii yhayiqopp denddeezay, de7or yezitayisinnee yhayqqeezitayis God maaaqadayisii. ");
INSERT INTO mfxl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Yeezin, neenii ne ishayil afa abis pirddee? Woy neenii ne isha abis leqqee? Nuunii ubbitay Xooss pirdda zufaane tiina eqqoda. ");
INSERT INTO mfxl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Geeshsha Maxaafayid Goday, «Taanii path yezaya; as ubbitay ta tiina bunqqitoda; taanii Xooss maaqqeezana inxaris ubbay markkattoda» yeegii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Yikkee, nu ootheez bazis nu ommar ommar Xooss tiina shiiqii mahith immada. ");
INSERT INTO mfxl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Yey gishos, nuunii pettay pettayil afa pirddiza wolla ashshoda. Zin yi isha dhubithiza woy qaxithiza baz oothaamay garkk naaginttoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Goda Yesuusa ammaniza asgarkk, fa ubbas tuna maaqqeez baz baazana taanii geeshshii eriza. Zin pettii asii pettibaz tuna gi qoppiko yey ezis tuna maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ne miiz katha gishos ne isha dhubbizabaz maaqqiko, Kiristtoosar yeza ne isha qadhdhooya. Kiristtoosa e gishos yhayqqeez atha ne miiz katha gishos eza dhabisppe. ");
INSERT INTO mfxl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Yikkee, yinttis yez lo77o baza yhankkitay borod garkke oothippate. ");
INSERT INTO mfxl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Xooss kaatetithay Geeshsha Ayyanayir benttiz xillotithi, sarotithinnee tuma ufayssapp attin muus baggannee ushsh bagga baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Yey garkk Kiristtoosas moodinttiz as Xooss ufayssiza; asay ganccekka anjjinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Yey gishos, ane nuunii sarotithi benttiz ogennee woli ammanor miinthiza oge kaaliza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Katha gishos gi Xoossa ooso dhabisppe. Ubba katha geeshshii, zin hara as se7isiza katha muusii iita. ");
INSERT INTO mfxl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ne ishay dhubinttaam garkk asho maam woy ushsh uzhaam woy dhubbiza hara baz oothaminxiko lo77o. ");
INSERT INTO mfxl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Yikkee, yha ne ammana neesinnee ne Xoossay gancce naagoba. Likke gi qoppeezbaz oothiza wode e kahay mootoowa athay anjjintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Zin sidhitar miiz athayis e muusay ammanor maaqqekka gishos pirddinttiza. Ammano bayith oothintteez ooso ubbitay nagara. ");
INSERT INTO mfxl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nu minthitay daabureezitay daabura tookkodayis beeziza. Nuunii nuna ufayssodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nuunii woli minthodayis zhamita maaddodayisnnee ufayssodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kiristtoosa fana ufayssibe7ekkaya. Zin Geeshsha Maxaafayid, «Asay nena cazheez cashshay tana helleeza» ginttinttii xaafintteezay garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Geeshsha Maxaafay inggiza garzhorannee minthathora nu ufayssa ekkod garkk Geeshsha Maxaafayid xaafintteez ubbitay nuna tamaarssodayis xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Garzhonnee minotith inggiza Goday yinttii Yesuusa Kiristtoosa kaallodar pettepettith yinttis inggo. ");
INSERT INTO mfxl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Yeykka, nu Goda Yesuus Kiristtoosa Ada, Xoossa, pettii wozinarannee pettii qaalar yi bonchchod garkke. ");
INSERT INTO mfxl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kiristtoosa yinttan ekkeezay garkk Xooss bonchchos pettay petta ekkoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Xoossii binii aditayis inggeez ufayssay polinttod garkk e tumatithay erinttoday garkk Kiristtoosa dookalinttos aylle maaqqii ye7eezana ta yinttis odiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Kiristtoosa dookalinttos aylle maheez bazay ma Ayihude baa asay Xoossa e maarotithay gishos galatod garkke. Geeshsha Maxaafayid, «Ta nena Ayihude baa as gancce galatoda; ne suntha sabboda» ginttinttii xaafintteezay garkk haneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ma, «Ayihude baa asayis, Xooss woyayira ufayttoytta» yeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ma mahii, «Ayihude baa asay ubbay, Goda galatooytta; kaatetithii ubbitay eza sabboytta» yeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Yey garkk Isiyaasa, «Issaye xaphopp yelintteez pettay ye7oda; E fa kaatetithita ubbita aqisoda. U fa ufayssa ezalli afa gaddoda» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Geeshsha Ayyana wolqqar yi diccod garkk ufayss inggiz Xoossay, yi ammanay baggar yinttis ufayssara sarotithar kunthii inggo. ");
INSERT INTO mfxl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ta ishuntho yintt lo77otithinne eretithii kumeezana ma pettay petta zorodayis danda7izana ta geeshshii eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Taanii yinttan pettii pettibaz gujjii akaakisodayis koy yashittekkazar yha dabddaabba yinttis xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Taanii Kiristtoos Yesuusa aylle maaqqii, Ayihude maaqqekka asayis qeese garkk oothii, wongile odod garkke Xoossay taas aadho keehetithi inggeeza. Ayihude baa asay Geeshsha Ayyanar geezhii, Xooss ufayssiza yarshsho maaqqad garkk Xoossay yeya ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Taanii Kiristtoos Yesuusar maaqqii Xoossis oothiza oosor ceeqinttiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ayihude baa asay Xoossayis kiittinttod, Kiristtoosa ta qaalannee ta ooso baggar ootheez oosaypp attin hara ta ceeqinttizabaz baaya. ");
INSERT INTO mfxl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Xooss yeya malatarannee Geeshsha Ayyana wolqqar wayizii ootheezakko ta yinttis ododa. Taanii Yerusalamepp aykkii, Iliwarqoonnee hellodayis Kiristtoosa wongile sabbakeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Taanii hara as baaseez aqayid keexxodayis koyooya. Kiristtoosa sunthay xeeginttekka aqo wongile sabbakodayis amottiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Geeshsha Maxaafayid, «E bagga odinttekka asay eza be7ada; E bagga si7ekka asay akaakoda» ginttinttii xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Yey baggar, taanii gaame wode yinttiko ye7odayis koyin danda7inttekkaya. ");
INSERT INTO mfxl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Zin taanii yhatte yha heerar yez aqo ubba helleez gishos gaame laythapp aykkii yinttan be7adayis laamoteez gishos ");
INSERT INTO mfxl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","taanii Ispheenee yhanigitar yinttan be7adayis qoppeeza. Ma xiqqa wode yinttar ufaytteezaypp guye Ispheenee yhanigodar yi ta ogayis tana maaddod garkk koyiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Zin yhatte taanii Xoossa asita maaddodayis Yerusalaame yhanigiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maqadoonarannee Akkaya yez Xooss asitay, Yerusalaame geeshshitay gancce yez manqqita miisher maaddodayis kozheeza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Unttii manqqita maaddoday unttis attowa baz maaqqeez gishos fa ubbas yeya oothodayis qofa acceeza. Ayihuditay Ayihude baazitayira ayyana anjjo shaaginttiko, unttii ma paas yezabazar Ayihudita maaddodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Yey gishos, taanii ye shiiqeez miisha unttisi inggezayppennee ekkeezana ereezapp guye Ispheenee yhanigitar yi lanqqer aadhoda. ");
INSERT INTO mfxl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Taanii yinttiko yhanigiza wode Kiristtoosa anjjo kunthar yhammadana ta eriza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ta ishuntho, taasi Xooss woossittar ta butinttodar taar eqqod garkk Goda Yesuus Kiristtoosarannee Geeshsha Ayyana siiqayir yinttan woossiza. ");
INSERT INTO mfxl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Xoossay tana Yihuda gancce yez ammanoowa asitaypp ashshod garkkennee Yerusalaame ta oothod ooso Xooss asay lanqqe ekkinttod garkk taas woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ma Xooss giiko, taanii yinttiko yhanigii ufayisar yinttar shemppod garkk taasi woossoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Sarotith Xoossay yinttar ubbayir maaqqo. Amin7e. ");
INSERT INTO mfxl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kinkkira katama gancce yez woosa keetha oothiza nu mishshit Feebena lo77o maachch maaqqeezanno yi erod garkk ta koyiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Yi izo ammaniza asitay Goday sunthar mokkodayis beeziza ammaniza asitaypp pettay garkk mokkoytta. Iza yinttapp koyiz baz ubbita izo maaddoytta. Iza fa ubbas gaame as maaddeeza; ma tana ta baggar undenna maaddeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kiristtoosa Yesuusa oosa taar wolla oothizi Phirisqilarannee Aqila ta qoodhe saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Unttii ta gishos fa shemppo yhayiqos aathii inggeeza. Ta aadda baazin Ayihude baa asay woosa keethitay ubbitay unttan galatiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","U kara shiiqiz ammaniza asa ta qoodhe saro goytta. Iisiya biitta Kiristtoosana tiin ammaneezannee, ta qaadhiza Ephanexoosas ta sarotha odoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Yi gishos oosor gaame daabureez Mayramo saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Taar achch kara gam7eezita Ayihude dabbita Anddironiqoosara Yuuliyanar saro goytta. Unttii Yesuusa hawaaritay gancce erintteezita. Ma unttii Kiristtoosa taapp tiina ammaneeza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Goda ammaniza ta siiqo lagga, Amphiliyaxoosa saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kiristtoosa oosa nuur wolla oothiz Urbbanoosera ta qadhdhiza Isttakusa saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Kiristtoosar yessay markkattintteez Axelisas ta sarotha odoytta. Arsixabulo kara asayis ta sarotha odoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ta Ayihude lagga Heroodiyoona saro goytta. Narssisara e kara asaypp Kiristtoosa ammaneezita saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Goday oosor daaburiz maachchi Xirufaynaranne Xirufoosa saro goytta. Ma Godayis gaame daaburii oothiz, ta qadhdhiza Xersiso saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Goday oosor loythii erintteez Rufoosasarannee tana fa na7a garkk bi7iza e indatis ta sarotha odoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asiqqirxxoosa, Filesonxxa, Hermmensa, Phatirobaasasira unttar yez ammaniza ishita ubbayis ta sarotha odoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filoloogusa, Yuuliya, Neera, e mishitto, Olumppoosara unttar yez geeshshita ubbita saro goytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Geeshsha yeera yeerinttittar, pettay petta sarothoytta. Kiristtoosa woosa keetha ubbitay yinttan saro yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ta ishuntho, yi tamaareez timirtta ixxii, yi gancce shaakinttonnee meto medhdhiz asitaypp naaginttoytta. Unttapp haakkoytta. ");
INSERT INTO mfxl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Yey garkk asay fa ulos oothizapp attin nu Goda Kiristtoosas oothooya. Fa liiqo doonarannee worddo qaalar haayo wozina balithiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Wonggilayis yi kiitintteezana as ubbitay si7eezay tana ufayssiza. Zin yi lo77o bazis eca iita bazis boozodana ta koyiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Saro Xoossay Xalahana yi tokaypp oommor elisii gaacoda. Nu Goda Yesuus Kiristtoosa aadho keehetithay yinttar maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Taar oothizi Ximaatoosa, ta dabbitay Luqiyoosa, Yaasonera Sosiphixiroosa yinttan saro yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Yha dabddaabba xaafeezi taanii, Xarxiyoosa, yinttan Goday sunthar saro yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Tana mokkeezaynnee woosa keeth ubbitay mokkiza Gaayoosa, yinttan saro geeza. Katama miishe aykkizi Erasxoosara nu isha Qarxoosa yinttan saro yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Nu Goda Yesuus Kiristtoosa aadho keehetithay yi ubbayir maaqqo. Amin7e. ");
INSERT INTO mfxl_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Xoossis galata maaqqo. Taanii, Yesuus Kiristtoosa baz odiz wongile qaalayir bini wodepp ayikkii qosinttii gam7eez tumatithar, Xoossay yinttan ammanor miinthii essodayis danda7iza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Zin yhatti ye tumay bentteeza. Kaatetithii ubbitay ammanii kiitinttoday garkk medhina Xoossa kiitar nabitay ye tumabaz xaafeeza. ");
INSERT INTO mfxl_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yesuus Kiristtoosa baggar ecetithii e aaddas yeza, pettii Xoossayis medhinas bonchcho maaqqo. Amin7e.");
INSERT INTO mfxl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Xooss shener Yesuus Kiristtoosas hawaare maaqqodayis xeegintteez Phawuloosannee, nu isha Sostenasa, ");
INSERT INTO mfxl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Qoronttoosa yez Xooss woosa keethis, Yesuus Kiristtoosar geezheezitannee geeshshi maaqqoday garkk xeegintteezitayis; ma unttisinnee nuus God maaqqiz nu Goda Yesuus Kiristtoosa suntha ubba aqo xeegiz ubbayis; ");
INSERT INTO mfxl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Xooss, nu Adayippennee nu Goda Yesuus Kiristtoosapp aadho keehetithinnee sarotith yinttis maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Xoossay Kiristtoosa Yesuusa baggar yinttis inggeez aadho keehatithay gishos taanii ubba wode Xoossa galatiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ezayid odarannee eratith ubbayir yi duriteeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Taanii Kiristtoosa bagga markkatteezay tuma maaqqeezay yinttal miinggeeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Yey gishos, yi nu Goda Yesuus Kiristtoosa yi7itha naagttar yezin, aba ayyana imokka yinttis paccenna. ");
INSERT INTO mfxl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Nu Goda Yesuus Kiristtoosa maaqqiz wode yi boronnee borsso bayth wurssithii hellodayis yinttan miinthii naagoda. ");
INSERT INTO mfxl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Fa Na7a, nu Goda Yesuus Kiristtoosar pettipettithay yezoday garkk yinttan xeegeez Xoossay ammaninttizaya. ");
INSERT INTO mfxl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ta ishuntho, yi gancce shaakintto yezaamay garkk yi pettii wozinarannee pettii qofar petto maaqqii, yezod garkk nu Goda Yesuus Kiristtoosa sunthayir ta yinttan woosiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ta ishuntho, Qelo7e kara asay yi gancce ixo yezana taas odeeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ta gizay yinttapp pettay pettay, «Taanii Phawuloosas; taanii Aphiloosas; taanii Phixiroosas; taanii Kiristtoosas» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kiristtoosa shaakintteenee? Yi gishos mazqalel afa sotintteezay Phawulosanee? Woy yi Phawuloosa sunthayir xammaqintteenenee? ");
INSERT INTO mfxl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Taanii Qarisphoosannee Gaayoosapp attin yinttipp oonakka xammaqekka gishos Xoossa galatiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Yey gishos, oonikka yinttan ta sunthayir xammaqintteeza godayis danda7ooya.  ");
INSERT INTO mfxl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ma Isxeefaanosa kara asakka ta xammaqeeza, zin hara oona xammaqeezako taas qopinttooya. ");
INSERT INTO mfxl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kiristtoosa tana kiitteezay Wonggile ododay garkkepp attin xammaqoday garkk baaya. Kiristtoosa mazqalel afa yhayqqeezay cere maaqqaam garkk taanii as ecetith qaalar baaya. ");
INSERT INTO mfxl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kiristtoosa mazqalel afa yhayqqeezana odiza qaalay dhabizitayis boozotithii, zin nuus attizitayis Xooss wolqqa. ");
INSERT INTO mfxl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Geesha Maxaafayid, «Taanii ecitay ecetitha dhabisoda; akaakanchchitay akaaka balithoda» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Yeezin, eca aba yenee? Higge asitamaare aba yenee? Woy yha sa7a eranchchay aba yenee? Xoossii yha sa7a ecetitha eeyatith oothekkasa? ");
INSERT INTO mfxl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Yha sa7a asay fa ecetethar Xoossa eraamay garkk Xoossii fa ecetithar kayi, boozatithar payidinttiza, nuunii odiza qaalayid ammanizita ashshodayis Xoossa shene maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayihuditay malata be7adayis koyiza; ma Girikitay ecetithi koyiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Zin nuunii mazqalel afa sotintteez Kiristtoosa sabbakiza. Yey Ayihuditayis dhube; ma Girikitayis boozetithii. ");
INSERT INTO mfxl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Zin Xoossay xeegeezitayis, Ayihude maaqqin, Girike maaqqin Kiristtoosa Xooss wolqqannee E ecetithii. ");
INSERT INTO mfxl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Xoossa boozetithay as ecetithaypp aadhiza; ma Xooss daaburay as minotithaypp miinggiza. ");
INSERT INTO mfxl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Yikkee, ta ishuntho, Xoossay yinttan xeegodar yi ab garkk asizako qoppoytta. As qofar yi gancce gaamitay ecitay, wolqqamitaynnee dhoqqa kochchitay baaya. ");
INSERT INTO mfxl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Zin Xoossay ecita yeellathodayis alamel yez boozita dooreeza; ma minthita yeellathodayis alamel yez daabureezita dooreeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Xoossay yha alamel gita ginttintteezbaz dhabisodayis, yha sa7a kawuzheezibaz, ixintteezibazinnee pathoowabazi dooreeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Oonkka Xooss tiina ceeqinttaamay garkk yeya ootheeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Zin Xoossay yinttis Kiristtoosa Yesuusar pettipettithar yezod garkk ootheeza. E nuus Xoossapp ecetith, xillotith, geeshshetithinnee wallotith maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Yey gishos, Geeshsha Maxaafayid, «Ceeqinttiza oonikka Godayil ceeqqo» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ta ishuntho, taanii tiina Xoossa qaala yinttis oditattar ye7eez wode doona biilamotitharannee ecetithar ye7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Taanii yinttar yeza wode mazqalel afa sotintteez Yesuus Kiristtoosapp attin hara baz eraami gi ta murtteeza. ");
INSERT INTO mfxl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ta yinttar yez wode daaburar, yashsharannee kukkurisar yeza. ");
INSERT INTO mfxl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ta kiitannee ta timirtta doona biilamotitharannee ecetithar baazin Geeshsha Ayyana wolqqa qonccisithara. ");
INSERT INTO mfxl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Yeykka, yi ammanay Xoossa wolqqayirapp attin as ecetithal katamay garkkesii. ");
INSERT INTO mfxl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ayyana de7or dicceezitayis nuunii ecetith qaalar odiza. Zini yha ecetithay, yha sa7a ecetith woy dhaboss yez yha sa7a haarizitay ecetith baaya. ");
INSERT INTO mfxl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Zini nuunii odiza ecetithay, gaame wodepp tiina Xoossay nu bonchchayis giigiseezannee geema yez xuura ecetithii. ");
INSERT INTO mfxl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Yha sa7a haarizitaypp pettakka yha ecetitha erekkaya. Unttii ereezbaz maaqqeezako, bonchcho Goda mazqalel afa sottaamizin. ");
INSERT INTO mfxl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Zini Geeshsha Maxaafayid, «Aafe be7ekka baz, haye si7ekkabaz, wozina qoppekkabaz, Xoossay fa dosizitayis giigiseeza» yeegiza. ");
INSERT INTO mfxl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Xoossay fa xuura fa Ayyana baggar nuus qoncciseeza. Geeshsha Ayyanay hara attozin geemmeez Xooss xuura ubba pilagiza. ");
INSERT INTO mfxl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","As gancce yez as ayyannpp attin asibaz ookka erooya. Yey garkkekka, Xoossi baz Xooss Ayyanapp attin ookka erooya. ");
INSERT INTO mfxl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Xoossay nuus cere inggeezibaz nu eroday garkk Xoossa Ayyana ekkeezapp attin yha sa7a ayyana ekkekkaya. ");
INSERT INTO mfxl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nuunii ayyana baz, ayyana asayis as ecetithar baazin Xooss Ayyanay inggiza ecetithar taamarssiza. ");
INSERT INTO mfxl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Zini Geeshsha Ayyana baa as Xooss Ayyana imotita ekkaamii. Yey ees boozetithii; ubbay Geeshsha Ayyanar pilaginttiz gishos E erodayis danda7ooya. ");
INSERT INTO mfxl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Zini Geeshsha Ayyana yez asii ubba baz pilagiza, zin eza ookka pilagooya. ");
INSERT INTO mfxl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Geeshsha Maxaafayid, «Goda wozina erizay oonoo? Eza zorodayis danda7izay oonoo?» ginttinttii xaafintteezay garkke. Nuus Kiristtoosa wozina yeza. ");
INSERT INTO mfxl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Ta ishuntho, yi asho asinnee Kiristtoosar haga ochchekka duude na7a garkk yez gishos taanii ayyana baz yinttis ododayis danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Yi miinth katha maadayis danda7ekka gishos taanii yinttan maathi pakeeza; yhattekka yi danda7ekkaya. ");
INSERT INTO mfxl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Yhattekka yi ammanoowa as garkk yeza. Yi gancce yez qinaataynnee woli ixayi ammanoowa as garkk yezana erisoosa? Yi ammanoowa as garkk haniza. ");
INSERT INTO mfxl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Yinttapp pettay, «Taanii Phawuloosas» haray ma, «Taanii Aphiloosas» giiko, ammanoowa as garkk baasannee? ");
INSERT INTO mfxl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yeezin, Aphiloosa abba? Phawuloosa abba? Nuunii yinttan ammantheez Xooss oosanchchita. Xoossay pettayis pettayis inggeez oosay garkk oothiza oosanchchita baasannee? ");
INSERT INTO mfxl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ta tukkeeza; Aphiloosa haath ushsheeza, zini dichcheezay Xoosse. ");
INSERT INTO mfxl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Yey gishos, dichcheez Xoossaypp attin tukkizaykka haath ushshizaykka akkokka baaya. ");
INSERT INTO mfxl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tukkithinnee haathe ushsho wol garkke, zin pettay pettay fa oosaygarkk Xoossay inggiza woyita ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nuunii pettipp Xoossayis oothiza eez oosanchchita maaqqeez gishos yi Xooss ooso gade; Xooss keethe. ");
INSERT INTO mfxl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Xoossay taas inggeez aadho keehatithaygarkk hiillanchcho anaaxe garkk baaso baaseeza. Haray athay ezal afa keexxiza. Zini ezal afa keexxiza oonkka wayizii keexxizako, faasa naagintto. ");
INSERT INTO mfxl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Pettii toke baasintteez baasaypp hara baaso baasodayis oonkka danda7ooya. Ye baasaykka Yesuus Kiristtoosa. ");
INSERT INTO mfxl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Zini yha baasayil afa oonkka worqqar woy birar maaqqin, al7o shuchchar woy mithar maaqqin, matar woy hawuler keexxiko, ");
INSERT INTO mfxl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","pettii pettii as ye baasayil afa abar keexxeezakko pirdda gallas tamar paacintt erinttoda. ");
INSERT INTO mfxl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Oonkka ye baasayil afa keexxeez keethay tamar xuuginttekka attiko, fa woyita ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Zini o oosoykka tamar xuugnttiko, ye athayis woyito baaya. Hano zin, E fa ommas tamapp buutii kezeez as garkk attoda. ");
INSERT INTO mfxl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Yi Xooss keeth maaqqeezannee Xooss Ayyanay yinttara yezana erekkasa? ");
INSERT INTO mfxl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Oonkka Xooss keetha laaliko, Xoossikka eza laaloda. Xooss keethay geeshshii; ye keethaykka yinttana. ");
INSERT INTO mfxl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Oonkka fana dooshshippe. Yha sa7a ecetethar fana eca udii ekkiz oonkka Xooss tiina eca maaqqodayis boozo maaqqo. ");
INSERT INTO mfxl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Yha sa7a ecatithay Xooss tiina boozetithii. Geeshsha Maxaafayid, «Xoossii ecita u gene qofayir aykkoda» yeegintteeza. ");
INSERT INTO mfxl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ma, «Ecitay qofay maaddowabaz maaqqeezana Goday eriza» yeegeeza. ");
INSERT INTO mfxl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Yey gishos, ubbay yinttis maaqqeez gishos oonkka asal ceeqinttipp. ");
INSERT INTO mfxl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Phawuloosa maaqqo, Aphiloosannee Phixiroosa maaqqo, yha alama maaqqo, de7o maaqqo, yhayiqo maaqqo, yhatti yezaya maaqqin, tiinapp ye7od ubbay yinttisii. ");
INSERT INTO mfxl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Yi Kiristtoosasii; Kiristtoosakka Xoossisii. ");
INSERT INTO mfxl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Asay nuna Kiristtoosa aylle Xooss xuure qonccisodayis hadara inggintteez as garkk udii qoppo. ");
INSERT INTO mfxl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ye hadara ekkeez asitay fa Godayis ammanintteezita maaqqodayis beeziza. ");
INSERT INTO mfxl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Zin yinttii woy haray tana pirddiko, taas akkokka baaya. Haray atto, taakka taal afa pirddaamii. ");
INSERT INTO mfxl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ta erizay garkk maaqqiko ta kahay kaccooya, yeykka ta folo geeshsha maaqqeezana beezooya. Taal afa pirddoday Goday aadda. ");
INSERT INTO mfxl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Yey gishos, wode hellekkazin, Goday ye7odaypp tiina oollakka pirddipate. E dhuma geenggeez xuura poo7o kessoda; as wozina qosintteez qofa qonccisoda. Ye wode pettay pettay Xoossaypp galata ekkoda. ");
INSERT INTO mfxl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ta ishuntho, yi gishos gi Aphiloosanannee tana aaziso udii yinttis odeeza. Yeya ta ootheezay, «Xaafintteezaypp aadhippe» yeegii zorizana yi nuupp tamaaroday garkkesii. Yey gishos, oonkka petta gayrinttor yhankka kadhodayis beezooya. ");
INSERT INTO mfxl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ne yhankkitaypp abar aadhinee? Neenii ekkekkabaz abii yenee? Yeezin, neenii ekkeezbaz hara asaypp ekkeez maaqqiko, ekkekka as garkk abis ceeqinttinnee? ");
INSERT INTO mfxl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Yhatti yinttis beeziza baz ubba yi ekkeeza. Yhatti yi duritteeza. Nu bayth yi aadda kawuteeza. Yi tuma kawuteezbaz maaqqeezako, nuukka yinttar kawutodazin. ");
INSERT INTO mfxl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Xoossay nuna hawaarita, yhayqqos pirddintteez as garkk as ubbapp nuna guye aatheeza taas aaziza. Nuunii yha alamayis, kiitanchchitayisinnee asayis kaassibaz maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Nuunii Kiristtoosa gishos boozo maaqqeez, zin yi Kiristtoosar ecita maaqqeeza. Nuunii daabura, zin yi miinth maaqqeeza. Yi bonchchintteeza, zin nuunii tooshintteeza. ");
INSERT INTO mfxl_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Yhanno hellodayis nu nayinttiza, saaminttiza, kallottiza, yhadhinttiza; yezod kamppa dhabin kaa7inttiza. ");
INSERT INTO mfxl_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Nuunii nu kusher yhanttar aqod gi daaburiza. Nuna asii baaddodar nu anjjiza; nuna bayi7ithodar nu garzhiza. ");
INSERT INTO mfxl_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Nuul afa iita baz odinttiza wode lo77o qaala nu mahiza. Nu yhanno hellodayis yha alame pixabazinnee wora wodhdheez buure maaqqeeza. ");
INSERT INTO mfxl_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Taanii yeya xaafizay, ta siiqiza na7itay garkk, yinttan zorodayis xaafeezaypp attin yeellasodayis baaya. ");
INSERT INTO mfxl_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kiristtoosar yinttan kaalithiza payidop aathii yezikokka, gaame aditay baaya. Ta yinttan Kiristtoosa Yesuusa Wonggilayir yeleeza. ");
INSERT INTO mfxl_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Yikkee, yi tana aaziso udii kaallod garkk yinttan woosiza. ");
INSERT INTO mfxl_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Yeyi gishos, ammanintteez, ta siiqiza, Goday baggar ta na7a, Ximaatoosa yinttiko azazeeza. E duma duma aqo yez woosa keetha ta taamarsseez, Kiristtoosa Yesuusar yez ta oga yinttan qofisoda. ");
INSERT INTO mfxl_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Taanii yinttiko ye7aambaz aazin, utirttiza pettii pettii asitay yeza. ");
INSERT INTO mfxl_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Zini Goday giiko, ukkera taanii yinttiko ye7oda. Ye wode utiranchchitay oda aadda baazin unttis aba wolqqakka yezako ta eroda. ");
INSERT INTO mfxl_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Xooss kaatetithay oda aadda baazin Xooss wolqqa. ");
INSERT INTO mfxl_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Taanii yinttiko gufera yhanigone siiqorannee haayo ayyanara yhanigo? Yi aaya doorinee? ");
INSERT INTO mfxl_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Yi gancce lagite yezay zigirinttiza. Yey garkk lagita hara attozin, ammanoowa asaykka oothooya. Yi gancce fa ade machchira tuneez asii yeza. ");
INSERT INTO mfxl_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Yeezin yi qiiradhodayisinnee yeellatodayis beeziza, zin utirttiza. Yey garkk borsso baz ootheez atha yi ganccepp kessodayis beezoosa? ");
INSERT INTO mfxl_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Taanii ashor yinttar yezaam ixxikokka ayyanar ta yinttar yeza. Taanii yinttar yez as garkk hanii yey garkk oosa ootheez athayil afa pirddeeza. ");
INSERT INTO mfxl_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Nu Goda Yesuus Kiristtoosa sunthar yi shiiqodar taanii ayyanar yinttar yezoda. Ezayid Goda Yesuus Kiristtoosa wolqqay yinttar maaqqoda. ");
INSERT INTO mfxl_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Ye athay nagara ashay dhabin, e ayyanay Goda Yesuusa pirdda gallas attoday garkk e Xalahes aadhii inggintto. ");
INSERT INTO mfxl_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Yi gayirinttay lo77o baaya. Xiqqa irshsho munuqo ubba denthizana yi eroosa? ");
INSERT INTO mfxl_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Yi yhatti irshsho baa munuqo maaqqoday garkk, nagara irshsho yinttapp kessoytta. Nuus Paaziqa dur maaqqeez Kiristtoosa yarshshintteeza. ");
INSERT INTO mfxl_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Yeyi gishos, genennee iitatithii yez irshshor baazin tumatitharannee geeshshatithi yez boorar nu baale bonchchoda. ");
INSERT INTO mfxl_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ta tiina xaafeez dabddaabbayid yi lagitiza asana hellaamay garkk yinttis odeeza. ");
INSERT INTO mfxl_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Yeya guussay yha alamel yez lagitizita woy nagaras tenttotizita woy suuqqatizta woy bonqqizita woy eeqas goynnizita ubbar hellipate guuss baaya. Yeya maaqqiko, yha alamaypp yi kezodayis beeziza zin atteeza. ");
INSERT INTO mfxl_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Zini ammaniza giinttii lagitizita woy tenttotiza woy eeqas goynnizitayir woy cazhizitayir woy mathizitayir woy bonqqizitayir wol hellippate gi yinttis odiza. Yey garkk asayira hara attozin, kathakka miipatte. ");
INSERT INTO mfxl_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Woosa keethapp baler yezitayil afa pirddodayis tana abi helthee? Woosa keetha yezitayil afa yi pirddoosanee? ");
INSERT INTO mfxl_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Zini balera yezitayil afa Xooss pirddoda. Ye iita baz oothiz atha yi ganccepp kessoytta. ");
INSERT INTO mfxl_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Yi ganccepp pettay pettayir mooto yezako, yeya ammaniza asay tiina pirddinttodana ashshii ammanoowa as tiina pirddinttodayis wayizii beezee? ");
INSERT INTO mfxl_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Geeshshitay alamel afa pirddodana yi eroosa? Yeezin, yi alamel afa pirddiza baz maaqqiko, yhay garkk xiqqabaz pirddodayis wayizii danda7inttoosa? ");
INSERT INTO mfxl_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nuunii kiitanchchitayil afa pirddodana yi eroosa? Yeezin, yha sa7a yessal afa pirddodayis yinttan wayizii gaame? ");
INSERT INTO mfxl_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Yeezin, yey garkk meto yi gancce medhinttiko, woosa keethi pettipettethapp baler yezitaykonnee borintteez asay tiina pirddinttodayis wayizii kanggee? ");
INSERT INTO mfxl_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Taanii yinttan yeellasodayis yeya giza. Yi gancce kacintteez asita inggithodayis danda7iza akaakiza asii baasa? ");
INSERT INTO mfxl_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Yeezin, pettii ammaniza ishay yhankko ammaniza ishanna pirdda keeth ammanoowa asay tiina mootodayis beezinee? ");
INSERT INTO mfxl_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Yikkee, yi pettay petta mootizabaz maaqqiko yeyi yi pokitha beeziza. Yeypp yi qohinttikonnee dooshinttiko lo77aamo? ");
INSERT INTO mfxl_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Zini yi woli gancce ammanizitay pettay petta qohizannee dooshshiza, yeykka yi ishita. ");
INSERT INTO mfxl_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Worzhitay Xooss kaatetitha laattaamana yi eroosa? Yinttan dooshipate; tenttotizitayinnee lagitizitay woy eeqa goynnizitay woy qayxinttizitay woy dhiirathii dhiirathar peezhizitay, ");
INSERT INTO mfxl_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","woy kayzitay woy uuzitay woy mathizitay woy cazhitay woy bonqizitay Xooss kaatetitha laattaamii. ");
INSERT INTO mfxl_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Yinttapp pettii pettii asay tiina yey garkke. Zini yi yhatti Goda Yesuus Kiristtoosa suntharannee Xooss Ayyanar meecintteeza; geezheeza; xilleeza. ");
INSERT INTO mfxl_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","«Taas ubba baz inggintteeza» Zini ubbay tana adamii. «Taas ubba baz inggintteeza», zin abikka tana haaraamii. ");
INSERT INTO mfxl_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","«Katha ulos; ulokka kathas» Zini Xoossay ulokka kathakka dhabisodana ta yinttis odiza. Nu asetithay Godayssipp attin lagitas baaya. Godaykka nu asetithayisii. ");
INSERT INTO mfxl_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Xoossay Goda yhayiqopp dentheezay garkk, nunakka yhayiqopp fa wolqqar denthoda. ");
INSERT INTO mfxl_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Yi asetithay Kiristtoosa asetithaypp bagga maaqqeezana eroosanee? Yeezin, taanii Kiristtoosa asetithaypp bagga kanggii lagita asetithi maaqqoday garkk udo? Hanena! ");
INSERT INTO mfxl_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Lagitiza athay e peezhiz asttira pettii asetith maaqqeezana yi eroosa? Geeshsha Maxaafayid, «Unttii nam7ay pettii asetithi maaqqoda» ginttintt xaafintteeza. ");
INSERT INTO mfxl_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Zini Godayra pettipiza athay ezar ayyanarakka petto maaqqiza. ");
INSERT INTO mfxl_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Lagitapp haakkoytta. Pettii athay oothiz hara nagara e asetithapp balera oosinttiza, zin lagitiza as fa asetithayil nagara oothiza. ");
INSERT INTO mfxl_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Yi asetithay Xoossay yinttis inggeez yinttar yez Geeshsha Ayyana kara maaqqeezana yi eroosanee? Yi yinttis baaya. ");
INSERT INTO mfxl_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Xoossay yinttan gater wonggeeza. Yeyi gishos, yi asetithayir Xooss bonchchoytta. ");
INSERT INTO mfxl_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Yi taas xaafeez dabiddaabbay bagga as maachch bochchaaminxikko lo77o. ");
INSERT INTO mfxl_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Zini lagitapp attodayis pettay pettay machcho paas ekko; ma pettii pettii machchiskka azin yezo. ");
INSERT INTO mfxl_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Azinay fa machchis, ma machchat fa azinayis beeziza baz udo. ");
INSERT INTO mfxl_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Machchat fa asetithayil afa iis mawute baaya, zin mawute I azinayisi. Yey garkkekka, azinayis E asetithayil afa mawute baaya, zin mawutay machchatisi. ");
INSERT INTO mfxl_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Yi woosar xiqqa wode gam7odayis zorer maaqqaam ixxiko, pettay petta kayppate. Yeypp denddeezayid yinttinatitha haarodayis gaminttin, Xalahe yinttan paaccaamay garkk pettipp yezoytta. ");
INSERT INTO mfxl_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Zini taanii yinttan zorodayis yhaya geezaypp attin azazo baaya. ");
INSERT INTO mfxl_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Asii ubbay ta garkk machcho ekkeka yezizako ta dosiza, zin Xoossay pettayis pettayis inggeez duma duma imotay yeza. Pettayis yhaygarkk yhankkayis hara imotay yeza. ");
INSERT INTO mfxl_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Machcho ekkekkazitayisinnee azin gelekkazitayis ma am7itayis taanii gizay, ta garkk yezoytta gi zoriza. ");
INSERT INTO mfxl_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Zini amor xuuginttodaypp ekkizaynnee gelizay lo77o maaqqeez gishos unttii fana haarodayis danda7aam ixxiko, ekkonne gelo. ");
INSERT INTO mfxl_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Taanii ekkeezitayisinnee geleezitayis yhay garkk gi zoriza; tana baaya Goday azaziza; machchat fa azinaypp shaakinttippe. ");
INSERT INTO mfxl_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Zini shaakinttiko hara azina gelekka fa ubbas yezo woy fa azinayira giigo. Azinay fa machchat billippe. ");
INSERT INTO mfxl_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Zini yhankkitayis Goda baazin taa